﻿USE sofia;
DROP TABLE IF EXISTS sofia.iyx_vpl;
CREATE TABLE iyx_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES iyx_vpl WRITE;
INSERT INTO iyx_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Wu ni mukaanda a makuumbu ma bakaa ba Yiisu Kristo, mwaana a Daavidi, mwaana a Abraami. ");
INSERT INTO iyx_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Isaki mwaana a Abraami; Yaakobi mwaana a Isaki; Yuuda na baana banguu ba nde, baana ba Yaakobi. ");
INSERT INTO iyx_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Peresi na Zeera baana ba Yuuda. Nguu a bo ali Tamare; Eseroni mwaana a Peresi, na Arami mwaana a Eseroni. ");
INSERT INTO iyx_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aminadabi mwaana a Arami; Nasoni mwaana a Aminadabi, Salamoni mwaana a Naasoni. ");
INSERT INTO iyx_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Booze mwaana a Salamoni; na Laabi ali nguu a Booze. Obedi mwaana a Booze, na nguu a Obedi ali Luta. Yeese mwaana a Obedi. ");
INSERT INTO iyx_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Mutini Daavidi mwaana a Yeese. Salomo mwaana a Daavidi. Nguu a nde ali mukari a Uuli. ");
INSERT INTO iyx_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Loboami mwaana a Salomo; Abia mwaana a Loboami; Azafi mwaana a Abia; ");
INSERT INTO iyx_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Yosafate mwaana a Azafi; Yorami mwaana a Yosafate; Ozia mwaana a Yorami; ");
INSERT INTO iyx_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Yotami mwaana Ozia; Akazi mwaana a Yotami; Ezekiase mwaana a Akazi; ");
INSERT INTO iyx_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Manase mwaana a Ezekiase; Amoni mwaana a Manase; Yosia mwaana a Amoni; ");
INSERT INTO iyx_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yekonya na baana ba nguu ba nde, baana ba Yosia, mu taanga di babiti baana ba Iseraeli mu bukori ku ngaanda a Babilooni. ");
INSERT INTO iyx_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nha mbisi a nha babiti baana ba Iseraeli mu bukori ku ngaanda a Babilooni, Selatieli mwaana a Yekonya, na Zorobabeeli mwaana a Salatieeli. ");
INSERT INTO iyx_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Abiyudi mwaana a Zorobabeeli; Eliyakimi mwaana a Abiyudi; Azori mwaana a Eliyakimi. ");
INSERT INTO iyx_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Sadoki mwaana a Azori; Akimi mwaana a Sadoki; Eliyudi mwaana a Akimi. ");
INSERT INTO iyx_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eleazari mwaana a Eliyudi; Matani mwaana a Eleazari; Yaakobi mwaana a Matani. ");
INSERT INTO iyx_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yoosefi mwaana a Yaakobi; ni Yoosefi me wuu, mulumi a Mari, wuli nguu a Yiisu wu bali mu uta Kristo. ");
INSERT INTO iyx_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Litaanga la bisieende bioosi, umatuu mu Abraami natee mu taanga dia Daavidi ali kuumi na bina. Tumake, kuumi na bina umatuu mu taanga dia Daavidi, natee bu babiti baana ba Iseraeli mu bukori ku Babilooni. Na kuumi na bina, umatuu bu babiti baana ba Iseraeli ku Babilooni natee mu taanga dia mbutili a Kristo. ");
INSERT INTO iyx_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Mono bwali mbutili a Yiisu Kristo. Mari, nguu a nde, ali na lilasina la makweele na Yoosefi. Ka tswaamini ti bo budiaala itwaari, Mari abayi yimi mu litu la Muheebili wa Ngira. ");
INSERT INTO iyx_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yoosefi wali mulumi a nde, ali muutu wasuungunu. Na bu nde ali a atoono pe umweese Mari tsionyi nha kulu a baata, Yoosefi aholi kesili ya ukabuu na nde mu tsweeyi. ");
INSERT INTO iyx_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Bu nde akitsimi ndaa yii, tumu a Pfumu wamumonii mu nziori, wamuleeli: «Yoosefi, mwaana a Daavidi, a ba na boomo mu ukweele Mari pe, mundaa ti mu litu la Muheebili wa Ngira nde abayi yimi lii. ");
INSERT INTO iyx_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mari sa abutu mwaana wa baala, wu we kaaha kuumbu Yiisu, ka mwaana wuu sa avuusu baata ba nde mu masumu ma bo.» ");
INSERT INTO iyx_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Maa moosi mayilimi, paa ti maleeli Pfumu mu mubili, mayene tsitsi: ");
INSERT INTO iyx_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Mono, nduumbu sa abaa yimi, na sa abutu mwaana wa baala, wu bakaata Emanweeli.» Mbiindili a kuumbu yii: «Nziaambi li na bisi». ");
INSERT INTO iyx_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yoosefi bu asiimbii, ayilii weti bwamutumi tumu a Pfumu, na nde aholi Mari mu uba mukari a nde. ");
INSERT INTO iyx_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ka nde a avuuti mbuu na mukari pe, natee bu Mari abuti mwaana a nde wa baala, wu Yoosefi ahi kuumbu Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yiisu abutii ku Betelemi mu itinini kia Yuuda, mu taanga dia Mutini Erode. Nha mbisi a mbutili a nde, biyeri biamati ku peembi ya palili a taanga. Bo batoori ku Yeruselemi, ");
INSERT INTO iyx_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","na bafuuli: «Kuni ku butiaangi mwaana, mutini a Bayuudayo? Bisi dimoni mbwelele a nde, bu diali ku palili a taanga, na dimaayiri mu ukuundu nde.» ");
INSERT INTO iyx_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Bu mutini Erode ayuyi ndaa yii, matsimi makwaamisi nde kwalaa, pili mosi ka na baata ba mu Yeruselemi boosi. ");
INSERT INTO iyx_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nde atumisi banguu ba bangaanga ba Nziaambi boosi, na bayiisi ba mikele, nde wabafuuli kuni Mesiya afwaana ubutuu. ");
INSERT INTO iyx_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bo bamuvutili: «Mesiya afwaana ubutuu ku ngaanda a Betelemi, mu itinini kia Yuuda, ka mono maleeli mubili mu Mabasonuu ma Ngira: ");
INSERT INTO iyx_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Beni baata ba Betelemi, mu tsi ya Yuuda, mu ngwanya beni a dili pe baata babavutuu mbisi, mu baata babali mu mangaanda ma Yuuda. Mundaa ti mu beni mukaapala pfumu, wukaaba mubiti a ifuumbu kia me, Iseraeli.”» ");
INSERT INTO iyx_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ni mu buu, Erode atumisi biyeri mu tsweeyi. Nde afuuli bo mu uyaaba bubwe-bubwe, taanga diamonii mbwelele me. ");
INSERT INTO iyx_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tumake nde wabatsindii ku Betelemi na wabaleeli: «Diyene na disaa uyaaba na dedede mioosi miatala imwamwaana. Na bu beni dikaasololo nde, diyaabisa me paa me ka yatsukunu mu ukuundu nde.» ");
INSERT INTO iyx_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Bu bamani na uyuu mialeeli mutini, bo bayeni. Bo bamoni mbwelele wu bakwimono ku palili a taanga: nde akiyene ku kulu a bo, bu atoori nha mbuu yali imwamwaana, mbwelele atsikini. ");
INSERT INTO iyx_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Bo baluuli mu kinyi yalaa bu bamoni mbwelele wuu nha mbuu yii. ");
INSERT INTO iyx_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bo bakoti mu nzo, na bamoni imwamwaana na Mari nguu a nde. Bo batsukini mu ukuundu imwamwaana. Tumake badibili makutu ma bo, na bamuheeri bungori: woolo, malimbi ma mupalisa luki la tsulu yimbwe, na mananaasa ma miire. ");
INSERT INTO iyx_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nha mbisi a nhaa, Nziaambi wabalibili mu nziori, mu uhele uvutuu kwaa mutini Erode. Ni mu buu, bo bayeni mu kuulu kimi mu uvutuu ku tsi a bo. ");
INSERT INTO iyx_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Biyeri bimana na uyene, tumu a Pfumu amonii kwaa Yoosefi mu nziori. Tumu wamuleeli: «Temene, holo imwamwaana na nguu a nde, na bata ku tsi ya Ngipiti, diaala kuu, natee bu me nileele we mu uyiri avutuu. Mundaa mutini Erode sa asaa imwamwaana paa adusu nde.» ");
INSERT INTO iyx_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yoosefi atemini, aholi imwamwaana na nguu a nde, kati a kati a butsuu, na ayeni ayisweeme ku tsi ya Ngipiti. ");
INSERT INTO iyx_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nde adiaali kuu natee bwakwiiri mutini Erode. Mii miayilimi weti buu, paa ti maleeli Pfumu mu munywa a mubili, mayene tsitsi: «Me maata mwaana a me mbili mu upala mu tsi ya Ngipiti.» ");
INSERT INTO iyx_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Mu taanga di mutini Erode ayaabi ti biyeri biamaafutu nde, nde akoti mu iteesi kia kesi ya mifuri. Nde atsindii baata mu udusu baana boosi ba babaala ba tsitsi a bilimi bioolo natee babavulu bungebe, babali ku Betelemi, na mu mapeembi moosi mamadiengele bula baa. Bilimi bioolo bii mutini Erode ayesini bio bu alibili moonyi mu taanga diamonii mbwelele kwaa biyeri bii. ");
INSERT INTO iyx_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ni mu buu maleeli mubili Yelemiya mayeni tsitsi: ");
INSERT INTO iyx_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Bayuyi loori ku ngaanda a Laama, bilili na minyoongo mialaa. Laakeli li mu ulili baana ba nde, nde a atoono pe ti bamuboondo, mundaa baana bamaakwa.» ");
INSERT INTO iyx_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nha mbisi a likwa la mutini Erode, tumu a Pfumu amonii kwaa Yoosefi mu nziori, mu taanga di nde ali ku tsi ya Ngipiti. ");
INSERT INTO iyx_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Nde aleeli kwaa nde: «Temene, holo mwaana na nguu a nde, na vutuu ku tsi ya Iseraeli, mundaa ti bababa mu usaa udusu mwaana bamaakwa.» ");
INSERT INTO iyx_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yoosefi atemini, aholi mwaana na nguu a mwaana, na avutii ku tsi ya Iseraeli. ");
INSERT INTO iyx_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ka Yoosefi ayuyi ti Arikelawusi maakiti nha mbuu a taayi a nde mutini Erode, mu uba mutini a Yuuda. Ni mu buu nde amoni boomo mu uyene kuu. Nziaambi abwilibili nde mu nziori, na nde ayeni ku itinini kia Ngalili. ");
INSERT INTO iyx_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nde ayidiaala ku ngaanda ya Nazareti, ni mubuu maleeli mibili mayene tsitsi: «Sa bamuta musi Nazareti.» ");
INSERT INTO iyx_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mu taanga dii, Yowani Mubootii amonii mu tsi ya tsata mu Yuuda na nde abaandii uyiisi, ");
INSERT INTO iyx_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","akileele: «Disobo ndiaatili a beni, mundaa ti Ipfumu kia mayula ika bebele!» ");
INSERT INTO iyx_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yowani ni muutu wu Yeesaya mubili atsuyi mu nde bu aleeli: «Ndaa mosi li mu uloo mu tsi ya tsata: Diyiluu kuulu a Pfumu, disuungusu misoo mia nde!» ");
INSERT INTO iyx_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ikutu kia Yowani ali batuungu kio mu miooso mia nyama wa kuumbu samo, na nde ali alwaata kobo yibayiluu mu mukaanda a nyama mu luungu la nde. Nde akidia bangwalibaanga na maari ma nyosi. ");
INSERT INTO iyx_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Baata ba Yeruselemi, ba mu itinini kia Yuuda kioosi, na ba mu itinini kioosi kia ku peembi a nziali ya Yorodaani, bakiyene kwaa nde. ");
INSERT INTO iyx_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bo bakiloombo Kolokolo mu masumu ma bo nha kulu a baata na Yowani akibootuu bo mu nziali ya Yorodaani. ");
INSERT INTO iyx_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yowani amoni ti Bafarisi na Basaduki babalayi bakiyiri kwaa nde mu uholo libootuu. Ni mu buu nde wabaleeli: «Beni ifuumbu kia bapili! Na wadiyiisi mu usaa ubata kesi a Nziaambi, yi ka bebele? ");
INSERT INTO iyx_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Dimweese mbutu dili mu uta imbaangi ki ibwe mu kiingili a mayele ma beni. ");
INSERT INTO iyx_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Na a ditsimi pe ti bwakuu mu uleele mu ibene-bame: “Abraami li kaa a bisi.” Ka me nadileeli: Nziaambi utuu ukitisi mamanya ma, mu uba bateeri ba Abraami! ");
INSERT INTO iyx_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mu taanga di, pibi yimaayilimi mu ukese muti nha miaanzi. Pasi muti wu uhele ubutu mbutu dimbwe, sa bakwaanga na udumunu nde ku mbaa. ");
INSERT INTO iyx_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Me nibootuu beni ndila mu maamba mu umweese ti beni dimaasobo ndiaatili, ka wuu wuli mu uyira ku mbisi a me sa abootuu beni mu Muheebili wa Ngira na mu mbaa. Nde avulu me mu litu: me a nafwaana pe so mu umaasa bikoori bia nde. ");
INSERT INTO iyx_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nde akaanga iyengese mu koo kia nde, na sa asoolo mbutu dimbwe na usiisi bifufuri. Nde sa akukuu mbutu dimbwe ku yulu a ibaanga, ka sa atsuu bifufuri ku mbaa yiyihele udimi.» ");
INSERT INTO iyx_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ni mu taanga dii, Yiisu amati ku Ngalili, ayiri ku nziali ya Yorodaani kwaa Yowani, paa Yowani wamubootuu. ");
INSERT INTO iyx_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ka Yowani a asiingi matsimi maa pe, na wamuleeli: «Aba bwafwaana ti me niyiri kwaa we mu uholo libootuu, ka we ka wu uyiri kwaa me!» ");
INSERT INTO iyx_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ka Yiisu avutili, aleeli kwaa nde: «Siingi buba weti buu: ka ni buu bisi diafwaana ukuusu mioosi mi Nziaambi ali mu uloombo.» Ni mu buu, Yowani asiingi, ");
INSERT INTO iyx_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","na bu amani na ubootuu nde, Yiisu apali mu maamba. Nhaa-na-tsi, mayula madibini mu ndaa a nde. Na amoni Muheebili a Nziaambi mu usutuu weti beembe na uyadiaala nha yulu a nde. ");
INSERT INTO iyx_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Na ndaa yayuyini mu mayula yaleeli: «Wuunawu ni mwaana a me wa litoono ndaa; me suusi kinyi a me yoosi mu nde.» ");
INSERT INTO iyx_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tumake, Muheebili a Nziaambi abiti Yiisu ku tsi ya tsata, paa Saatina wamuyesine. ");
INSERT INTO iyx_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nha mbisi a ulabisa maku mana ma biluumbu bia nyanga na bia butsuu kwahele a udia, Yiisu abayi nzala. ");
INSERT INTO iyx_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Saatina muwungisi aswesii kwaa nde na wamuleeli: «So we li mwaana a Nziaambi, tumu mamanya ma makituu mapa.» ");
INSERT INTO iyx_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yiisu avutili: «Mabasonuu ma Ngira mali mu uleele: “Muutu a ali mu ubaa moonyi mu ndila mapa pe, ka mu mandaa moosi ma Nziaambi ali mu uleele.”» ");
INSERT INTO iyx_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ni mu buu, Saatina wamubiti natee ku Yeruselemi, ngaanda ya ngira, wamunayi ku yulu a mbulili a Nzo a Nziaambi, ");
INSERT INTO iyx_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","na wamuleeli: «So we li Mwaana a Nziaambi wa ngwanya, patuu na bwa nha tsi. Mundaa ti Mabasonuu ma Ngira mali mu uleele: “Nziaambi sa aha litumu kwaa batumu ba nde, mu ndaa we, na bo sa bayaka we mu mioo mia bo, paa ti kuulu kia we ihele ukubu baka.”» ");
INSERT INTO iyx_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yiisu abwivutulu kwaa nde: «Mabasonuu ma Ngira mali mu uleele ka ti: “A yesine Pfumu Nziaambi a we pe.”» ");
INSERT INTO iyx_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Saatina abwibiti nde ku yulu a mulaanda wa ngo bula, wamumweesi bipfumu bioosi bia tsi na buzitu ba bio. ");
INSERT INTO iyx_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Na wamuleeli: «Me sa ha we bi bioosi, so we tsukini nha kulu a me na ukuundu me.» ");
INSERT INTO iyx_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ni mu buu Yiisu aleeli kwaa nde: «Matuu nha Saatina! Yene! Mundaa Mabasonuu ma Ngira mali mu uleele: “Kuundu Pfumu Nziaambi a we, na ndila nde we afwaana usalila.”» ");
INSERT INTO iyx_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Mu mbala yi Saatina ninha asiisi nde, na batumu ba Nziaambi baswesii kwaa Yiisu na bamusialili. ");
INSERT INTO iyx_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yiisu bu ayuyi ti Yowani balooso mu perese, nde ayeni ku Ngalili. ");
INSERT INTO iyx_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nde a adiaali pe nha Nazareti, ka ayidiaala ku Kapernawumi. Ngaanda yii ali mu mukoo a mubu a Ngalili, mu bitinini bia Zabuloni na Nefetali. ");
INSERT INTO iyx_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Maa mayilimi buu paa maleeli mubili Yeesaya mayene tsitsi: ");
INSERT INTO iyx_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Beni baata ba bitinini bia Zabuloni na Nefetali, mu kuulu ya mubu, ku peembi yimosi ya nziali a Yorodaani, ku Ngalili ku li mu udiaala bieenyi! ");
INSERT INTO iyx_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Beni baata babali kutso pimisi, sa dimono liyalila lilinene! Kwaa babali mu udiaala mu idziimi kia likwa, liyalila sa limonuu!» ");
INSERT INTO iyx_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Umatuu mu taanga dii, Yiisu abaandii uyiisi, na aleeli: «Disobo ndiaatili a beni, mundaa Ipfumu kia mayula ika bebele!» ");
INSERT INTO iyx_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Bu Yiisu akiyene mu mukoo a mubu wa Ngalili, nde amoni baana banguu boolo babali balobi. Baana banguu baa ali ni Simooni wu bali mu uta ti Peetero, na Andere mukee a nde. Bo bakidumunu siele mu mubu, mu ulobo. ");
INSERT INTO iyx_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yiisu aleeli kwaa bo: «Diduku me, na me sa yiisi beni bwa ulobo baata.» ");
INSERT INTO iyx_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nhaa-na-nhaa, bo babwoongili masiele ma bo na bamuduki. ");
INSERT INTO iyx_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Bu abwiyene nha la-la, nde amoni baana ba nguu boolo bakimi ba babaala, Yaki na Yowani, baana ba Zebedaayi. Bo bali mutso bootu na Zebedaayi, taayi a bo, bo bakiloondo masiele ma bo. Yiisu wabateeri mbili. ");
INSERT INTO iyx_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nhaa-na-nhaa, bo basiisi bootu na taayi a bo, na baduki Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yiisu akidieenge mu Ngalili yoosi, nde akiyiisi mutso manzo ma makutunu ma Bayuudayo ma mu itinini kii. Nde akiyaabisa Ndaa Yimbwe ya Ipfumu kia Nziaambi, na akibeelese baata mu bibeeri bia bo bioosi, na bipii bia bo bioosi. ");
INSERT INTO iyx_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Bayuyi mvuungu a nde mu tsi yoosi ya Siria, na bamubeyi boosi ba bali na bibeeri bia mupili na mupili, so a buu pe bali kutso kwaamisa ya mupili na mupili. Ni bangaa miheebili mimibi, ba bali ka na ibeeri kia sisi na baata bababobo binama. Na Yiisu wababeelisi. ");
INSERT INTO iyx_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Makoongi mamalayi maduki nde: mo makimata ku Ngalili, na ku itinini kia Dekapole, tumake ku ngaanda ya Yeruselemi, ku itinini kia Yuuda na ku itinini kia ku simi la Yorodaani. ");
INSERT INTO iyx_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yiisu bu amoni makoongi maa, nde ahaati nha yulu a mulaanda na adiaali. Miyii mia nde miakukini nha peembi a nde. ");
INSERT INTO iyx_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nde abaandii uha bo nziisili yi: ");
INSERT INTO iyx_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Kinyi yili na bawele mu muheebili, mundaa ti Ipfumu kia mayula ili kia bo! ");
INSERT INTO iyx_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kinyi yili na babali mu ulili, Mundaa ti Nziaambi sa aboondo bo! ");
INSERT INTO iyx_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kinyi yili na bangaa buleembi, mundaa ti bo sa batolo mukobo a tsi wu Nziaambi alasini! ");
INSERT INTO iyx_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kinyi yili na babali na nzala na nyooto a libweeye, mundaa ti Nziaambi sa akuusu manzala ma bo! ");
INSERT INTO iyx_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kinyi yili na babubaakwiilili bambaayi ngebe, mundaa ti Nziaambi ka sa wabakwiilili ngebe! ");
INSERT INTO iyx_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kinyi yili na babatsieeme mu mutimi, mundaa ti bo sa bamono Nziaambi! ");
INSERT INTO iyx_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kinyi yili na babubaamweese iyeenge nha kati a bo, mundaa ti Nziaambi sa ata bo baana ba nde! ");
INSERT INTO iyx_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kinyi yili na babali kutso mbingisi, mundaa libweeye la Nziaambi li bo bali mu usalila, mundaa ti Ipfumu kia mayula yili kia bo! ");
INSERT INTO iyx_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kinyi kwaa beni so baata butuu beni, bukwaamisa beni na uleele mandaa moosi mapia mu beni, mundaa ti beni diasa imiini mu me. ");
INSERT INTO iyx_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Diba kinyi na diyaanga, ka musieende wu munene li mu ukebe beni mu mayula. Ee-e ni buu ka, bakwaamisi mibili miatswaamina beni. ");
INSERT INTO iyx_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Beni dili mungwa wa tsi. Ka so mungwa a abwisaala na isie pe, buni butuu usa paa nde abwaba na isie? Nde a bwisaala na ndutu pe, bubwe mu ubumu nde ku buumbu, so a buu pe, ku baata budiaata nde. ");
INSERT INTO iyx_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Beni dili liyalila la tsi. Ngaanda yi batuungu nha yulu a mulaanda a iyituu usweeme so hoolo pe. ");
INSERT INTO iyx_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","A bali mu unamisa mwiindi mu ufuu nde kutso ipaayi pe, ka bali mu usuusu nde nha yulu a isuusili kia mwiindi, paa aha liyalila kwaa boosi babali mutso nzo. ");
INSERT INTO iyx_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ni buu ka liyalila la beni lafwaana ungeyine nha kulu a baata boosi, paa bo bamono biyiluu bia beni bibibwe, na bakiinzi Taayi a beni wuli mu mayula. ");
INSERT INTO iyx_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«A ditsimi pe ti me nayiri mu utsara mikele mia Mooso na nziisili a mibili. Me a nayiri pe mu utsara mio ka mu uyiluu uha mambiindili ma mio. ");
INSERT INTO iyx_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Me nadileeli, mu ngwanya: natee yula na tsi bihele ulabuu, a so piti a isonii so imosi pe kiavulu mu bukee, na a so mbiindila ndaa so mosi pe yavulu mu bukee butuu ukuungulu mu mikele, natee manini a mandaa moosi. ");
INSERT INTO iyx_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ni mu buu, wu utakala so mosi wavulu mu bukee mu mikele mioosi, na nde yiisi ka kwaa bana mu uyiluu weti buu, sa aba wavulu bukee mu Ipfumu kia mayula. Ka wu usalila mukele wuu, na uyiisi kwaa bana mu uyiluu weti buu sa aba mukuutu mu Ipfumu kia mayula. ");
INSERT INTO iyx_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ee-e, me nadileeli: Beni diafwaana uvulu bayiisi ba mikele na Bafarisi mu utumumu mikele mia Mooso. So beni a divuli pe bo mu libweeye, beni a diba pe nha kati a baa babukoto mu Ipfumu kia Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Beni diayuyi ti, baleeli kwaa bakaa ba bisi: “A dusu pe. So muutu dusi mbaayi muutu, nde afwaana ti bamufuundusu nha kulu a banzioonzi.” ");
INSERT INTO iyx_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ka me nadileeli: pasi muutu wu ukolo mwaana nguu a nde kesi, afwaana ti bamufuundusu nha kulu a banzioonzi. Wuu wu uleele kwaa mwaana nguu a nde ti: “Iwulu!”, afwaana ti bamufuundusu kwaa pfuundu a ikuutu kia Bayuudayo. Wuu wu uleele kwaa mwaana nguu a nde ti: “We mayele pe!” afwaana ti bamudumunu ku mbaa ya ku mbuungulu. ");
INSERT INTO iyx_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Mbiiti we yiri nha kulu a diki la tsuyili mu uha bungori kwaa Nziaambi, na nha mbuu yii we libili moonyi ti mwaana a nguu a we li na kooti na we, ");
INSERT INTO iyx_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","nyaala wa we bungori ba we nha kulu a diki la nzosili nhaa, na yene we kwavuutu iyeenge na mwaana nguu a we, tumake we yiri avutuu na we mweese mu ukuluu kwoosi, bungori ba we kwaa Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Ka bu beni dikeni mu kuulu na mutaata a we, mu uyene ku nzo a pfuundisi, bubwe mu ukwayuhusunu na nde bu beni dikeni mu kuulu. Diyiluu buu paa nde anyaala uyeelele we nha kulu a nzioonzi, tumake nzioonzi a anyaala uyeelele we kwaa basiali ba nde bakaadumunu we mu perese. ");
INSERT INTO iyx_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Me nileele kwaa we, mu ngwanya: we a upala muu pe, so we amani pe ubele yaama la we, natee mukuti wa tsieelele. ");
INSERT INTO iyx_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Beni diayuyi baleeli ti: “A soongo pe!” ");
INSERT INTO iyx_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ka me nadileeli: pasi muutu wu utala mukaasa mu unyiimi nde, nde soongi na nde kutso mutimi a nde. ");
INSERT INTO iyx_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","So ni mundaa lisi la we la koo kia babaala we li mu ubwa mu masumu, sootolo lo na bumu lo ku la. Yavulu bubwe kwaa we, mu ufuusu inama imosi kia nyutu a we, ka a mu ukubu pe ti nyutu a we yoosi yifuu ku mbuungulu. ");
INSERT INTO iyx_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","So ni mundaa koo kia we kia babaala we li mu ubwa mu masumu, kese kio na bumu kio ku la. Yavulu bubwe kwaa we, mu ufuusu inama imosi kia nyutu a we, ka a mu uyene pe we woosi ku mbuungulu. ");
INSERT INTO iyx_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Baleeli ka ti: “Wu ubisi mukari a nde, afwaana uha nde mukaanda wa utsara makweele.” ");
INSERT INTO iyx_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ka me nadileeli: pasi baala lilibisi mukari a nde, wahele usoongo na baala likimi, nde bwiisi mukari mu masumu ma tsoongili. Wu ukweele mukaasa wu baala likimi labingi, nde soongi ka. ");
INSERT INTO iyx_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Beni diayuyi ka ti baleeli kwaa bakaa ba bisi: “A laba mukisi wa pia pe, ka kuusu mi we alasini nha we alaba mukisi nha kulu a Pfumu.” ");
INSERT INTO iyx_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ka me nileele beni mu uhele ulaba mukisi. A dilaba mukisi pe so mu kuumbu a mayula, mundaa ti yula ni mbata a Nziaambi, ");
INSERT INTO iyx_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","a so mu kuumbu a toto pe, mundaa ti toto ni isuusili kia miili mia nde. A so mu kuumbu a Yeruselemi pe, mundaa ti yo ni ngaanda a Mutini wu munene. ");
INSERT INTO iyx_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","A laba mukisi pe so mu kuumbu a mutswe a we, mundaa ti we a utuu pe uhembese, so upiindisi linaanga la we so limosi. ");
INSERT INTO iyx_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","So ni “Ee-e”, dileele “Ee-e”; mbiiti “E-e ngori”, dileele “E-e ngori.” Ndili a buu, yi bubwaleele nha yulu a mabakwaleele, yi imata kwaa Muutu wu mubi. ");
INSERT INTO iyx_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Beni diayuyi baleeli ti: “So muutu tuli we lisi, we ka tulu la nde; so nde sokili we lini, we ka sokolo la nde.” ");
INSERT INTO iyx_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ka me nileele beni mu uhele uvutulu mamabi mu mamabi. So muutu teti we mbata nha tama la we la koo kia babaala, nyaala nde atete ka we mbata nha tama la koo kia bakaasa. ");
INSERT INTO iyx_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","So muutu tooni ubiti we nha kulu a banzioonzi, mundaa aholo ikutu kia we, nyaala aholo ka iyungu kia we. ");
INSERT INTO iyx_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","So muutu bamii we mu uyene mu tsitsi a fuundu limosi la bitaambi, yene na nde mu tsitsi a mafuundu moolo ma bitaambi. ");
INSERT INTO iyx_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ha kwaa wu li mu uloombo we; na a bisi pe usoomboso kwaa wu tooni usoombo kwaa we. ");
INSERT INTO iyx_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Beni diayuyi baleeli ti: “Toono mbaayi a we, na bele mutaata a we.” ");
INSERT INTO iyx_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ka me nileele beni: Ditoono mitaata mia beni, na dikuundu mu boosi ba bali mu ukwaamisa beni. ");
INSERT INTO iyx_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mu yii beni sa diba baana ba Taayi a beni wu li mu mayula. Ka nde li mu ubalisa nyanga a nde nha yulu a bababi na bababwe; nde li mu unooso mvulu nha yulu a babanambita na babahele unambita mu nde. ");
INSERT INTO iyx_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","So beni ditoono ndila babatoono beni, ki musieende beni dituu ubaa kwaa Nziaambi? Batoli ba limaanda ka bali mu uyiluu buu! ");
INSERT INTO iyx_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","So beni diheeri mabwe ndila kwaa baana ba nguu ba beni, ki ndaa ya ukimuu beni dili mu uyiluu? Bangooyi ka bali mu uyiluu bumosi. ");
INSERT INTO iyx_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ni mu buu, diba babakuu, weti bu Taayi a beni wu li ku mayula ali akuu. ");
INSERT INTO iyx_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Dikele a diyiluu mandaa ma Nziaambi atoono mu nzala ya umonuu nha kulu a baata. So beni diyilii buu, beni a dibaa pe musieende, kwaa Taayi a beni wuli mu mayula. ");
INSERT INTO iyx_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ninha mu taanga di we uha libaasila kwaa muwele, a fulu pe miloolo paa bamono we. Ni buu ka bangaa peluu ba li mu usa mutso manzo a makutunu ma Bayuudayo, na mu makuulu. Bo bali mu uyiluu buu paa baata babili bo. Ngwanya me nadileeli: bo bamaaholo musieende a bo. ");
INSERT INTO iyx_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ka mu taanga di koo kia we kia babaala iha libaasila kwaa muwele toono koo kia we kia bakaasa uyaaba pe. ");
INSERT INTO iyx_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ni mu buu, libaasila lii lafwaana uba tsweeyi, na Nziaambi taayi a we, wu li mu umono ma we li mu uyiluu ku tsweeyi, sa aha we musieende. ");
INSERT INTO iyx_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Mu taanga di beni dikuundu, a diba pe weti bangaa peluu. Bo batoono ukuundu mu mutele, mu manzo ma makutunu ma Bayuudayo, na ku tsomo a makuulu paa baata boosi bamono bo. Ngwanya me nadileeli: bo bamaabaa musieende a bo. ");
INSERT INTO iyx_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ka we, mu taanga di we tooni ukuundu, koto kutso itsuru kia nzo a we, koo idibuu, na kuundu Taayi a we wu li nhaa, ku mbuu yii ya tsweeyi. Na mu taanga dii, Taayi a we, wuli mu umono ma we li mu uyiluu mu tsweeyi, sa aha we musieende. ");
INSERT INTO iyx_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«Mu taanga di beni dili mu ukuundu, dinyaala ubaavutulu bitoolo ndila bimosi weti bangooyi. Bo bali mu utsimi ti Nziaambi usiingi likuundu la bo so bo batsuyi kwalaa. ");
INSERT INTO iyx_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","A difwaanina bo pe, ka Nziaambi, Taayi a beni akwayaaba manzala ma beni tswaamina beni diyaabisa nde mo. ");
INSERT INTO iyx_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","«Mono bu beni diafwaana ukuundu: “Taayi a bisi wu li ku mayula, nyaala muutu-muutu ayaaba ti kuumbu a we yiba ya Ngira. ");
INSERT INTO iyx_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nyaala ipfumu kia we iyira, nyaala muutu-muutu, nha tsi, ayiluu litoono la we weti bu lo lili mu uyilimi ku yula. ");
INSERT INTO iyx_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ha bisi bia udia biafwaana mu iluumbu ki. ");
INSERT INTO iyx_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nyaala mayaama ma bisi, weti bu bisi ka dili mu unyaala bangaa mayaama. ");
INSERT INTO iyx_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Na a nyaala bisi dikoto mu mapuusu pe, ka kuulu bisi kwaa Wu Mubi. Ka bia we ni Ipfumu, Litu na Buzitu, mu taanga di dihele uwa. Aameni.” ");
INSERT INTO iyx_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ka, so beni disiiri masumu ma baata babamosi Kolokolo mu mamabi ma bo badiyiluu, Taayi a beni wu li ku yula sa wadisa ka Kolokolo. ");
INSERT INTO iyx_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ka so beni a disiiri pe babamosi Kolokolo, Taayi a beni ka a usa pe beni Kolokolo mu mamabi ma beni madiayiluu. ");
INSERT INTO iyx_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Mu taanga di beni dili mu udii mutuutu, a dimweese kiinzi kia ngebe pe weti bu bangaa peluu ba li mu usa. Bo bali mu usobo kiinzi paa baata boosi bamono ti bo mutuutu bali mu udii. Mu ngwanya me nadileeli: bo bamaakwa holo musieende a bo. ");
INSERT INTO iyx_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ka we mbiiti ka mu udii mutuutu, swaa kiinzi kia we na kili mananaasa ku mutswe a we, ");
INSERT INTO iyx_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","paa baata bahele uyaaba ti we li mu udii mutuutu. Ndili a Taayi a we wu li nhaa, mu tsweeyi, kaayaaba yo. Na Taayi a we, wu li mu umono mi we li mu uyiluu mu tsweeyi, sa aha we musieende. ");
INSERT INTO iyx_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«A dikukuu busini nha tsi nha pe, ku batsieriri na malali bali mu ubiiyisi, ku miyibi mili mu ubulu bidibuu bia manzo mu uyibi. ");
INSERT INTO iyx_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ka dikukuu busini ba beni mu mayula, ku yahele na batsieriri na malali mu ubiiyisi, so miyibi mu ubulu bidibuu bia manzo mu uyibi. ");
INSERT INTO iyx_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ka mutimi a we sa abaabaanganga kuu kuli busini ba we. ");
INSERT INTO iyx_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Misi mili mwiindi a nyutu: So misi mia we polo mili, nyutu a we yoosi yili kutso liyalila. ");
INSERT INTO iyx_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ka so misi mia we mili miabeele, nyutu a we yoosi yili kutso pimisi. Ka so pimisi dimaakiti liyalila la keni uba mu we, bunu pimisi dii sa diba kwaa we dia mukobo. ");
INSERT INTO iyx_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«A wuli na muutu pe wu utuu usalila bapfumu boolo. Ka nde abele wu mumosi na utoono wu mukimi; so a buu pe nde sa akaangama na wu mumosi na umengele wu mukimi. Beni utuu pe usalila nha mbuu mosi Nziaambi na mboongo. ");
INSERT INTO iyx_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Ni mu buu me nileele kwaa beni: a dinyoongo pe mu ndaa bia udia na bia unywa bi beni dili na nzala a bio mundaa idiingi kia beni, so a buu pe mundaa bikutu bi beni dili na nzala bio mundaa nyutu a beni. Idiingi kiavulu bia udia ndutu, na nyutu yavulu bikutu ndutu, a buu pe? ");
INSERT INTO iyx_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Talani banyunyi ba yula: bo a bubaakunu pe, a bubaatolo pe. Bo a bali na bibaanga pe mu ukukuu mbutu, ka Taayi a beni wu li ku yula li mu ubuungulu bo! Ka beni a diavulu banyunyi ndutu pe? ");
INSERT INTO iyx_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Na mu beni, mundaa minyoongo mia nde, utuu ubweese so hoolo biluumbu bia idiingi kia nde? ");
INSERT INTO iyx_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«Ka mu ima dili mu unyoongo mu ndaa ya bikutu? Monani buli mu ukulu bifulu mu matsiee: bio a bili mu usala pe, na a bili mu utuungu bikutu pe. ");
INSERT INTO iyx_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ka bunu, me nileele beni, so mutini Salomo, kutso busini ba nde boosi, a abaa pe bikutu bi bibwe bia weti so ndila imosi mu bifulu bi. ");
INSERT INTO iyx_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Beni bangaa imiini ki ikee! So Nziaambi li mu ulwaatisa bitiiti bili ku matsiee pili yii lolo, na bibudumunu ku mbaa nha ngwaali, mu ima nde uhele uyiluu miavulu mii kwaa beni? ");
INSERT INTO iyx_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ninha a dinyoogo pe na uleele ti: “Ima dikaadia? Ima dikaanywa? Ima dikaalwaata?” ");
INSERT INTO iyx_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ni bangooyi bali mu ubaasaanga bii bioosi. Ka Taayi a beni, wuli ku mayula, akwayaaba ti beni dili na nzala a bio. ");
INSERT INTO iyx_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Dikwasaa Ipfumu na libweeye la Nziaambi, tumake Nziaambi sa aha ka beni bini bioosi. ");
INSERT INTO iyx_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ni mu buu, a diba pe na tari mu iluumbu kia nha ngwaali: mundaa iluumbu kia nha ngwaali sa iba na mandaa ma kio. Pasi iluumbu na mapasi ma kio. ");
INSERT INTO iyx_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«A difuundusu muutu pe, paa Nziaambi ka anyaala ufuundusu beni. ");
INSERT INTO iyx_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ka Nziaambi sa afuundusu beni weti bu beni difuundusu babamosi. Nde sa ayesine beni mu iteesi ki beni dili mu uyesine babamosi. ");
INSERT INTO iyx_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mu ima we li mu utala itiiti kili mu lisi la mwaana a nguu a we, ka bunu we ali mu umono pe itsuru kia muti kili mu lisi la we makulu? ");
INSERT INTO iyx_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Buni we utuu uleele kwaa mwaana a nguu a we ti: “Nyaala me maasa itiiti kili mu lisi la we”, ka bunu we makulu li na itsuru kia muti mu lisi la we? ");
INSERT INTO iyx_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","We ngaa peluu, kwamaasa itsuru kia muti mu lisi la we, tumake we sa mono bubwe-bubwe bwa umaasa itiiti kili mu lisi la mwaana nguu a we. ");
INSERT INTO iyx_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«A diha pe bia ngira kwaa bambwa, mundaa ti bo utuu ukiinguu kwaa beni na ukaka beni; a dibumu pe bilaba bia beni nha kulu a bangulu, mundaa ti bo a badiata bio. ");
INSERT INTO iyx_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Diloombo na sa badiha, disaa na beni sa disololo, dikomboto na sa badidibili munywa a nzo. ");
INSERT INTO iyx_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ka pasi nde wu uloombo, holi; wu usaa, solili; na bali mu udibili munywa a nzo kwaa wu ukomboto. ");
INSERT INTO iyx_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Uli na muutu mu beni wuli mu uha mwaana a nde limanya so mwaana loombi nde lipa? ");
INSERT INTO iyx_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","So a buu pe wamuheeri taari wa kuumbu nyete mbiiti nde loombi tswi? ");
INSERT INTO iyx_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","So bu dili baata bababi, beni diayaaba uha biloo bibibwe kwaa baana ba beni. Mbiiti maa mali ngwanya, Taayi a beni wuli ku mayula ka sa aha biloo bibibwe kwaa baa babuloombo nde bio. ");
INSERT INTO iyx_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Diyiluu kwaa babamosi mioosi mi beni diatoono ti bo badiyiluu. Buu ni buli mu uyiisi mikaanda mia mikele mia Mooso na mia Mibili. ");
INSERT INTO iyx_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Kotani mu munywa a nzo wasweetene! Ka munywa wa saalila na kuulu ya hele na mapasi bili mu ubiti ku pfuuyili. Babalayi ni babubaalabuu muu. ");
INSERT INTO iyx_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ka kuulu ya munywa wasweetene, yili mu ubiti ku moonyi, yili kuulu ya pasi. Baata babakee bali mu uduku yo. ");
INSERT INTO iyx_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Disa mayele mu mibili mia pia. Mio mili mu uyiri kwaa beni mu ifwaani kia mameme, ka kutso kati mio mili miminzi mia tsitsi. ");
INSERT INTO iyx_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Beni sa diabayaaba mu ndiaatili a bo. Utuu pe ukaba inzieenzi mu mutsietsiende, so a buu pe bafiike mu mundungu. ");
INSERT INTO iyx_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Muti wu mubwe ubutu mbutu dimbwe na muti wu mubi ubutu mbutu dimbi. ");
INSERT INTO iyx_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Muti wu mubwe utuu pe ubutu mbutu dimbi; bumosi ka muti wu mubi utuu pe ubutu mbutu dimbwe. ");
INSERT INTO iyx_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pasi muti wu uhele ubutu mbutu dimbwe sa bamukwaanga, na sa bamudumunu ku mbaa. ");
INSERT INTO iyx_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ni mu buu, beni sa diyaaba mibili mia pia mu ndiaatili a bo. ");
INSERT INTO iyx_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«A bo boosi pe ba bubaata me: “Pfumu, Pfumu”, bukoto mu Ipfumu kia mayula, ka ndila babali mu uyiluu litoono la Taayi a me wu li mu mayula. ");
INSERT INTO iyx_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mu iluumbu kia pfuundisi, balayi sa baleele me: “Pfumu, Pfumu, ni mu kuumbu a we bisi diali mibili. Ni mu kuumbu a we bisi diabingi miheebili mimibi. Ni mu kuumbu a we bisi diayiluu bimaanga bialaa. We a ayaaba ndaa yii pe?” ");
INSERT INTO iyx_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ni mu buu, me sa nabaleele: “Me a nayaaba beni so hoolo pe. Takwaani na me, beni ba dili mu uyiluu mandaa mamabi!” ");
INSERT INTO iyx_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Ni mu buu pasi nde wu uyuu mandaa ma me maaleele, na nde salili mo nde sa afwaanina na muutu wa mayele, watuungu ibwa kia nzo a nde nha yulu a manya li linene. ");
INSERT INTO iyx_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mvulu anoyi, manziali mapuulii, iteembi yabwiilili nzo yii, ka yo a yabwiiri pe, mundaa ibwa kia yo batuungu kio nha yulu a manya lii. ");
INSERT INTO iyx_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ka pasi nde wu uyuu mandaa ma me maaleele ma, na nde mo usalila pe, sa afwaanina na muutu wa iwulu watuungu ibwa kia nzo a nde nha yulu a musiee. ");
INSERT INTO iyx_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mvulu anoyi, manziali mapuulii, iteembi yabwiilili nzo yii na yo yabwiiri na bioo: na pfuuyili a yo ali yinene.» ");
INSERT INTO iyx_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Bu Yiisu amani na uha tumini dia nde, boosi bakimii mu mutindi a nziisili a nde. ");
INSERT INTO iyx_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Mundaa ti nde a ali pe weti bayiisi ba mikele ba bo, ka nde akiyiisi bo na litumu loosi. ");
INSERT INTO iyx_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yiisu asutii mulaanda na koongi a baata yamuduki. ");
INSERT INTO iyx_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ninha ngaa a bwaari mosi aswesii, atsukini nha kulu a nde na aleeli: «Muyiisi, so we tooni, we utuu utsieemese me.» ");
INSERT INTO iyx_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yiisu asibili koo, wamubeembi na aleeli: «Me tooni, ki tsieeme.» Na nhaa na nhaa, muutu atsieemi mu bwaari la nde. ");
INSERT INTO iyx_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tumake Yiisu aleeli kwaa nde: «Yuu bubwe: a tsuu yo kwaa muutu so mosi pe. Ka yene bakengese we kwaa ngaanga a Nziaambi, na ha bungori ba Mooso atumi, mu umweese kwaa boosi ti we maabeeluu.» ");
INSERT INTO iyx_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Mu taanga di Yiisu akoti mu ngaanda a Kapernawumi, mukuutu a masodaare mosi, musi Looma, aswesii kwaa nde na aloombi nde libaasila. ");
INSERT INTO iyx_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Aleeli Yiisu mandaa ma: «Pfumu, musiali a me abeele na ala ku nzo, nde binama bia nyutu biamaabobo na li mu umono pasi dia laa.» ");
INSERT INTO iyx_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yiisu aleeli kwaa nde: «Me kuu niyene, na me sa beelese nde.» ");
INSERT INTO iyx_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ka mukuutu a masodaare avutili: «Pfumu, bubwe pe we mu ukoto mu nzo a me. Ka we leele ndaa ndila mosi, na musiali a me sa abeeluu. ");
INSERT INTO iyx_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Me makulu ndi kutsini a litumu la bakuutu ba me, na me ndi na masodaare kutsini a litumu la me. So me ndeeli kwaa mosi: “Yene”, nde yeni, na me nileele kwaa wunu: “Yira”, nde yiri, na so me ndeeli kwaa musiali ame: “Yiluu ndaa yi”, nde yilii yo.» ");
INSERT INTO iyx_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Bu Yiisu ayuyi mandaa maa nde amoni kinyi, na aleeli kwaa babakiduku nde: «Mu ngwanya me nadileeli: me a namono pe muutu wuli na imiini kia pili yi mu Nziaambi mu basi Iseraeli. ");
INSERT INTO iyx_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Me nileele beni, babalayi sa bamatuu ku palili a taanga, na ku li mu udiaama taanga na sa badiaala nha meese mu udia itwaari na bakaa ba bisi Abraami, Isaki na Yaakobi, mu mukuungi wu munene mu Ipfumu kia mayula. ");
INSERT INTO iyx_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ka babali bataasila mu Ipfumu sa babadumunu ku mbari, kutso pimisi, ku bo bakaalili na ukweete mini.» ");
INSERT INTO iyx_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tumake Yiisu aleeli kwaa mukuutu a masodaare wuu: «Vutuu ku nzo a we, Nziaambi heeri we ma we loombi mu imiini!» Na musiali a mukuutu a masodaare abeelii mu taanga ni dii. ");
INSERT INTO iyx_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yiisu ayeni ku nzo a Peetero. Kuu nde amoni buko ba Peetero wa mukaasa ala nha yulu a mbuu, bu ali na baa. ");
INSERT INTO iyx_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yiisu abeembi koo kia nde, na baa lawiiri. Nde atemini, na akoti mu usalila Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tsitsii bu yatoori, babeyi kwaa Yiisu baata babalayi ba miheebili mimibi miakikwaamisa. Mu mandaa ma nde, Yiisu abingi miheebili mimibi kwaa baa bali na mio. ");
INSERT INTO iyx_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nde ayilii buu paa mamaleeli mubili Yeesaya mayene tsitsi: «Nde wadibeelisi mu bibeeri bia bisi, na wadimaasi bipii bia bisi.» ");
INSERT INTO iyx_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yiisu bu amoni koongi a baata yamudiengilili, nde ahi tumini kwaa miyii mia nde, mu uyene na nde itwaari ku simi la diaanga li limosi. ");
INSERT INTO iyx_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Muyiisi a mikele mosi aswesii na wamuleeli: «Muyiisi, me niduku we pasi ku we uyene.» ");
INSERT INTO iyx_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yiisu avutili kwaa nde: «Mibaa miahaa minywa ku tsini a toto na banyunyi bali na manzo ma bo, ka Mwaana a muutu a ali pe na mbuu yi nde utuu ula na usuusu mutswe.» ");
INSERT INTO iyx_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Muutu mukimi, mosi mu miyii mia nde wamuleeli: «Muyiisi, ha me muswa me kwayadii taayi a me.» ");
INSERT INTO iyx_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yiisu avutili kwaa nde: «Duku me. Na nyaala babakwa badii ba bo babakwa.» ");
INSERT INTO iyx_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yiisu akoti mu bootu itwaari na miyii mia nde, mu usabuu diaanga lii. ");
INSERT INTO iyx_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Itsundu-a-tsundu, iteembi kia mifuri kianaangii nha yulu a diaanga, na mapo ma diaanga mabaandii udiamisa bootu. Ka Yiisu ali ala tolo. ");
INSERT INTO iyx_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Miyii miaswesii kwaa nde na bamusiimbili, baloyi: «Pfumu, vuusu bisi! Bisi sa dikwa!» ");
INSERT INTO iyx_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yiisu avutili kwaa bo: «Mu ima beni dili na boomo? Imiini kia beni ili kiadee!» Ninha, nde atemini, afweengi iteembi na maamba ma diaanga, tumake diaanga lawuri na pii. ");
INSERT INTO iyx_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Boosi bakimii na baleeli: «Wu ki pili a muutu wu, paa biteembi na diaanga bitumumu nde?» ");
INSERT INTO iyx_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yiisu bu atoori ku simi la diaanga lilimosi, mu tsi ya basi Ngadareni, babaala boolo bapali kutso mangili, na bayiri mu ubwaana nde. Babaala baa bali na miheebili mimibi miakikwaamisa bo. Muutu so mosi pe wakiyesine ulabuu mu kuulu yii, mundaa ti bo bali baata ba tsitsi. ");
INSERT INTO iyx_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bo babaandii uloo: «Mwaana a Nziaambi, ki ndaa we li mu usaa mu bisi? We nha ayiri kuni mu ukwaamisa bisi tswaamini taanga di Nziaambi akese dito?» ");
INSERT INTO iyx_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nha la-la kwali na mukaanga wu munene wa bangulu babakisaa biloo. ");
INSERT INTO iyx_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Miheebili mimibi mialoombi kwaa Yiisu: «So we tooni ubingi bisi, tsinduu bisi mutso mukaanga a bangulu wu.» ");
INSERT INTO iyx_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yiisu wabaleeli: «Yenani!» Miheebili mimibi miapali mu babaala boolo baa na miayikoto mu bangulu. Nhaa-na-nhaa, mukaanga woosi akulini ku tsuu a mulaanda, abwiiri mu diaanga, na mukaanga woosi afuyi mu maamba. ");
INSERT INTO iyx_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Babakikebe bangulu babati, bayeni ku ngaanda, kuu bayaabisi mandaa moosi, na miayilimi mu baata boolo babali na miheebili mimibi. ");
INSERT INTO iyx_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ni mu buu, baata ba ngaanda boosi bapali mu ubwaana Yiisu. Bu bamumoni, bamuloombi mu usiisi tsi a bo. ");
INSERT INTO iyx_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yiisu akoti mu bootu, abwisabuu diaanga na ayeni ku ngaanda a nde. ");
INSERT INTO iyx_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Baata babeyi kwaa nde muutu wabobo binama, ala nha yulu a laba. Yiisu bu amoni imiini kia bo, nde aleeli kwaa wabobo binama: «Lwaata ibaala mwaana a me! Masumu ma we basiiri mo kolokolo!» ");
INSERT INTO iyx_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ni mu buu, babamosi mu bayiisi ba mikele, balelisini kutso mitimi mia bo: «Muutu wu, li mu utuu Nziaambi!» ");
INSERT INTO iyx_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yiisu ayaabi matsimi ma bo na aleeli: «Mu ima beni dili na matsimi mamabi maa? ");
INSERT INTO iyx_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ima kiavulu pasi? Mu uleele ti: “Masumu ma we basiiri mo kolokolo?” — oo ti mu uleele — “Temene na yene?” ");
INSERT INTO iyx_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ka me natoono ti beni diyaaba: Mwaana a muutu li na litu nha tsini a toto mu usa masumu kolokolo.» Ninha nde aleeli kwaa wabobo binama: «Temene, holo laba la we na yene ku nzo a we.» ");
INSERT INTO iyx_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Muutu wuu atemini na ayeni ku nzo a nde. ");
INSERT INTO iyx_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mu taanga di koongi a baata bamoni buu, boomo babwiilili bo na babili Nziaambi bu aheeri litu la pili yii kwaa baata. ");
INSERT INTO iyx_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yiisu asiisi mbuu yii, na mu taanga di akilabuu, nde amoni muutu mosi kuumbu Mataayi adiaala nha meese ma batoli ba limaanda. Yiisu aleeli kwaa nde: «Duku me!» Mataayi atemini na wamuduki. ");
INSERT INTO iyx_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nha mbisi a nhaa, Yiisu akoti mu nzo a Mataayi mu udia. Kuu kwali na batoli ba limaanda balaa, na baata bakimi bangaa masumu. Bo bayiri mu udiaala itwaari na Yiisu nha meese na miyii mia nde. ");
INSERT INTO iyx_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bafarisi bu bamoni buu, baleeli kwaa miyii mia nde: «Mu ima Muyiisi a beni ali mu udia itwaari na batoli ba limaanda na bangaa masumu?» ");
INSERT INTO iyx_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yiisu ayuyi bo, na aleeli: «Baata babali polo a bali na nzala a mubuyi pe, ka babeeri bubaaba na nzala a nde. ");
INSERT INTO iyx_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Yenani diyii mandaa maleele Nziaambi maa-na-ma: “Mutimi wa ngebe avulu ndutu na bungori babali mu uha kwaa me.” Mundaa, me a na yiri pe mu uta mbili babali mu utsimi ti bo bangaa libweeye, ka babayaaba ti bo bangaa masumu.» ");
INSERT INTO iyx_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Miyii mia Yowani Mubootii miasweesii kwaa Yiisu na miamufuuli: «Mu ima bisi na Bafarisi dibaadiianga mutuutu, ka miyii mia we a mili mu uyiluu buu pe?» ");
INSERT INTO iyx_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Na Yiisu avutili kwaa bo: «Beni dili na tsimi ti babata mbili ku makweele utuu ukoto mu ngebe, mu ntaanga di mufuru a makweele ali itwaari na bo? Ka ngori! Ka taanga sa dito, di bakaamaasa nde nha kati a bo, ni mu taanga dii bo bakaadii mutuutu.» ");
INSERT INTO iyx_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«A uli pe na muutu wu li mu uloondo ikutu ki ikulu, mu iteendi kia tsaanda ki inyatii. Mundaa ti iteendi kii sa ikakala ibari kia ikutu ki ikulu, na wuru sa libwataanyuu kwalaa. ");
INSERT INTO iyx_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Bumosi ka, a bali mu ulooso pe mala ma manyatii mu mambiindi ma makulu. Leeti mambiindi ubuluu, mala utsaamuu, na uhelele mambiindi. Ka mala ma manyatii usiengele mu mambiindi ma manyatii, na buu utuu ukebe bio bubwe.» ");
INSERT INTO iyx_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mu taanga di Yiisu akitsuu kwaa bo buu, pfumu a Bayuudayo mosi ayiri, atsukini nha kulu a nde, na aleeli: «Mwaana a me wa mukaasa maakwa lialili, ka yira naa koo kia we nha yulu a nde, na nde sa aba moonyi.» ");
INSERT INTO iyx_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yiisu atemini na aduki nde na miyii mia nde. ");
INSERT INTO iyx_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mukaasa mosi wakipala makili umatuu bilimi kuumi na bioolo, aswesii ku mbisi a Yiisu, na abeembi toso a ikutu kia nde. ");
INSERT INTO iyx_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Mundaa ti nde akileele kutso mutimi a nde: «So me tuyi ubeembe ndila ikutu kia nde, me sa beeluu». ");
INSERT INTO iyx_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yiisu asieetii, amoni nde na aleeli: «Lwaata ibaala, mwaana a me! Mundaa we amene miaanzi mu me, ninha we maabeeluu.» Na nhaa-na-tsi, mukaasa wuu abeelii. ");
INSERT INTO iyx_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yiisu atoori ku nzo a mukuutu a Bayuudayo wuu. Bu amoni basiyi ba manzaanga bamaayilimi mu ndiili, na koongi a baata yakinyingini kutso kele yalaa ");
INSERT INTO iyx_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","nde aleeli: «Palani mu, mundaa mwaana wa mukaasa a akwa pe, nde tolo ala.» Ka baata basiiri nde saa. ");
INSERT INTO iyx_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Bamana na upalisa koongi ku mbari, Yiisu akoti kutso itsuru kia nzo, nde akaangi mwaana mu koo, na mwaana atemini. ");
INSERT INTO iyx_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mvuungu yatsiaamii mu itinini kii kioosi. ");
INSERT INTO iyx_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Mu taanga di Yiisu amatii nhaa, bingima-ngimi bioolo biamuduki mu uyenaloo: «Mwaana a Daavidi, kwiilili bisi ngebe!» ");
INSERT INTO iyx_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yiisu bu atoori ku nzo a nde, bingima-ngimi biaswesii kwaa nde, na nde wabafuuli: «Beni disiiri imiini ti me utuu uyiluu buu?» Bo bavutili kwaa nde: «Ee-e Pfumu.» ");
INSERT INTO iyx_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ninha, Yiisu abeembi misi mia bo na aleeli: «Nziaambi heeri beni ma beni dili mu ukebe mu imiini kia beni!» ");
INSERT INTO iyx_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Na misi mia bo miatuyi umono. Yiisu wabatsuyi mu ibaala, wabaleeli: «Diyiluu uyuu, muutu so mosi pe wafwaana uyaaba ndaa yi.» ");
INSERT INTO iyx_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ka mu taanga di bo bapali mu nzo, bo bayeni mu utsuu mu Yiisu mu itinini kii kioosi. ");
INSERT INTO iyx_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Bingima-ngimi bioolo bii bu biakiyene, baata bakimi babeyi kwaa Yiisu muutu mosi wa baba mundaa ti nde ali akangama kwaa muheebili wu mubi. ");
INSERT INTO iyx_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Bu Yiisu amani ubingi muheebili wu mubi wuu, muutu wali baba abaandii utsuu. Koongi buyamoni buu, baata boosi bakimii na bakileele: «Kaala a diamono mia bu mu tsi a Iseraeli pe!» ");
INSERT INTO iyx_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ka Bafarisi bakileele: «Ni mukuutu a miheebili mimibi li mu uha nde litu la ubingi miheebili mii!» ");
INSERT INTO iyx_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yiisu akidieenge mu mangaanda na mu mala, nde akiyiisi mutso manzo ma makutunu ma Bayuudayo, akiyaabisa Ndaa Yimbwe ya Ipfumu, na akibeelese bibeeri na bipii bioosi. ");
INSERT INTO iyx_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mutimi a nde aluuli mu ngebe mundaa makoongi ma nde akimono. Ka manyutu ma baata baa ali mamaawa mifuri na bo bali bamaakoto kutso ndeeyili, mundaa ti bo ali aka ilimbisi pe, weti mameme mahele na mukebi. ");
INSERT INTO iyx_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ninha, nde aleeli kwaa miyii mia nde: «Isala kia ukukuu mbutu ili kia laa, ka basiali bali bakee. ");
INSERT INTO iyx_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ni mu buu, diloombo kwaa ngaa tsiee, abwatsinduu basiali mu usa isala kii.» ");
INSERT INTO iyx_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yiisu ateeri miyii mia nde kuumi na mioolo mbili na wabaheri lituu la ubingi miheebili mimibi, na ubeelese bibeeri bioosi, na bipii bioosi. ");
INSERT INTO iyx_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Makuumbu ma batumu kuumi na boolo ni maa-na-ma: watsiomi Simooni, wu bali mu uta Peetero, na mukee a nde Andere; Yaki na mukee a nde Yowani, bo baboolo baana ba Zebedaayi; ");
INSERT INTO iyx_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipe na Baritelemi; Toma na Mataayi mutoli a limaanda; Yaki mwaana a Alife na Tade, ");
INSERT INTO iyx_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simooni muzelote na Yuuda Isikarioti, wuu wayeelili Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yiisu atsindii babaala kuumi na boolo ba mu isala, nde wabaheeri tumini yi: «A diyene pe mu bitinini bia baata babali a Bayuudayo pe, na a dikoto pe mu ngaanda so mosi ya mu itinini kia Samaria. ");
INSERT INTO iyx_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ka diyene ndila ku yili mameme mamadiimbili ma mu mukaanga a Iseraeli. ");
INSERT INTO iyx_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mu kuulu, diyiisi na dileele ndaa yi: “Ipfumu kia mayula ika bebele!” ");
INSERT INTO iyx_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Dibeelese babeeri, disiimbili babakwa, ditsieemese bangaa bwaari, dibingi miheebili mimibi. Beni diabaa mu ibuu, haanani ka mu ibuu. ");
INSERT INTO iyx_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","A diholo so woolo, so mboongo, so mikuti mi beni dilooso mu mibanda mia beni pe. ");
INSERT INTO iyx_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Bu diyene mu midieenge, a dibiti pe so kutu, so bikutu bioolo, so bikoori, so mupaanga. Mundaa musiali afwaana ubaa bia udia mu isala kia nde. ");
INSERT INTO iyx_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«Bu dikoto mu ngaanda so mu bula, disaa muutu wayilimi mu uyaka beni, na didiaala kwaa muutu wuu, natee bu beni dimatuu nha mbuu yii. ");
INSERT INTO iyx_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mu taanga di beni dikoti mu nzo a muutu wuu, dileele: “Iyeenge kwaa beni.” ");
INSERT INTO iyx_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mbiiti baata ba nzo yii bayaki beni, nyaala iyeenge ki beni diloombi iba nha yulu a bo. Ka so bo a bayaki beni pe, nyaala iyeenge ki beni dialoombo mu bo ivutuu kwaa beni bameme. ");
INSERT INTO iyx_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mbiiti mu nzo mosi so mu ngaanda mosi, babisi uyaka so uyuu beni, dipala mu yo, na dikubulu lifuundu la bitaambi bia beni. ");
INSERT INTO iyx_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ngwanya me nadileeli: mu iluumbu kia pfuundisi a tsi, sa basieembe baata ba ngaanda yii mu iteesi kiavulu tsieembili ya baata ba ku ngaanda a Sodomo na ku Ngomoro. ");
INSERT INTO iyx_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Diyuu! Me nitsinduu beni weti mameme nha kati a miminzi. Ka diba na buyeri weti bataari, na diba babahele na toono weti mabeembe. ");
INSERT INTO iyx_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Disa mayele, mundaa ti baata sa babiti beni ku manzo ma pfuundisi, na sa batete beni bikoti mu manzo ma makutunu ma Bayuudayo. ");
INSERT INTO iyx_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Sa badibiti mu uyala mitata nha kulu a batumi ba bitinini na nha kulu a mitini mu toono a me, paa beni dita imbaangi mu me kwaa bo, na kwaa bangooyi. ");
INSERT INTO iyx_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mu taanga di bubiti beni ku nzo a pfuundisi, a diba na tsoongo pe mu mi beni dikaaleele so mu mutindi wu beni dikaatsuu. Mundaa ti Nziaambi sa aha beni mandaa mafwaana mu taanga dii. ");
INSERT INTO iyx_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mo a mumata kwaa beni pe, ka Muheebili a Taayi a beni sa atsuu mu beni. ");
INSERT INTO iyx_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Baana ba nguu sa bayeelele baana ba nguu ba bo ku likwa, na bataayi ka sa bayiluu bumosi kwaa baana ba bo; baana sa bakiinguu mu udwaanisa bataayi na banguu, na uyeelele bo ku tsieembili ya likwa. ");
INSERT INTO iyx_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Baata boosi sa babele beni mu toono a me. Ka wu uhama natee manini sa ayobuu. ");
INSERT INTO iyx_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mu taanga di bukwaamisa beni mutso ngaanda mosi, dibata ku ngaanda kimi. Ngwanya me nadileeli, beni a dimana pe udieengele mangaanda moosi ma mu Iseraeli tswaamini Mwaana a muutu uyira. ");
INSERT INTO iyx_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«A uli na muyii so mosi pe wavulu muyiisi a nde; a uli na musiali so mosi pe wavulu pfumu a nde. ");
INSERT INTO iyx_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yakuu kwaa muyii mu uto mu iteesi kili muyiisi a nde, na kwaa musiali mu uto mu iteesi kili pfumu a nde. Mbiiti batuyi mukuutu a kaanda Belezebuli, binama bia kaanda la nde sa batuu bo kwavulu mifuri. ");
INSERT INTO iyx_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Ninha a diba na boomo ba muutu pe. Mioosi miasweeme sa mimonuu, na mioosi mia tsweeyi sa miyabina. ");
INSERT INTO iyx_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mi nileele me beni kutso pimisi, dileele mio nha liyalila; na mi buleele beni mu mapfuundu nha litswi, dibiisili mio ku yulu a masiaangi. ");
INSERT INTO iyx_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","A dibata pe ba budusu nyutu, ka bo ukoono udusu muwuumu, ka dibatila Nziaambi boomo wu utuu ufuusu mbala mosi nyutu na muwuumu ku mbaa ya ku mbuungulu. ");
INSERT INTO iyx_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","A bali mu uyaalu pe masiee moolo mu mukuti mosi? Bunu a so limosi pe mu mo, lituu ubwa nha tsi, kwahele a ti Taayi a beni ayaaba. ");
INSERT INTO iyx_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ka kwaa beni, so naanga dia beni dioosi dia mutswe bataanga dio. ");
INSERT INTO iyx_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ni mu buu a diba na boomo pe: beni diavulu masiee malaa ndutu! ");
INSERT INTO iyx_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Pasi nde wu usiingi nha kulu a baata ti nde li muyii a me, me ka sa namusiingi nha kulu a Taayi a me wuli mu mayula ti nde wa me ali. ");
INSERT INTO iyx_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ka so muutu tuni me nha kulu a baata, me ka sa namutunu nha kulu a Taayi a me, wuli mu mayula. ");
INSERT INTO iyx_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«A ditsimi pe ti me nayiri mu ubee iyeenge nha tsini a toto: me a nayiri pe mu ubee iyeenge, ka mudiingi. ");
INSERT INTO iyx_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Me nayiri mu ukabala mwaana wa baala na taayi a nde, mwaana wa mukaasa na nguu a nde, mukari a mwaana na buko ba nde wa mukaasa. ");
INSERT INTO iyx_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mitaata mia muutu sa miba ni binama bia kaanda la nde makulu. ");
INSERT INTO iyx_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Pasi nde wu uvulu utoono taayi a nde, so a buu pe nguu a nde, kwavulu me utoono, nde a afwaana pe mu uba wa me. Pasi nde wu uvulu utoono mwaana a nde wa baala, so a buu pe wa mukaasa, kwavulu me utoono, nde a afwaana pe mu uba wa me. ");
INSERT INTO iyx_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Pasi nde wu uhele unaangila kuruwa a nde na uduku me ku mbisi, nde a afwaana pe mu uba wa me. ");
INSERT INTO iyx_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Wu utoono uvuusu idiingi kia nde sa afuusu kio; ka wu ufuusu idiingi kia nde mu ndaa a me, sa avuusu kio. ");
INSERT INTO iyx_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Pasi nde wu uyaka beni, yaki me; pasi nde wu uyaka me, nde yaki wuu watsinduu me. ");
INSERT INTO iyx_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Wu uyaka mubili a Nziaambi, mundaa bu ali mubili, nde sa aholo musieende wu bataasila kwaa mubili; na wu uyaka muutu wakangama mu Nziaambi mundaa bu nde ali akangama mu Nziaambi, nde sa aholo musieende wu bataasila kwaa muutu wakangama mu Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Mu ngwanya, me na dileeli: muutu wu uha so ndila mbasa a maamba ma kioori, kwaa mosi wavulu mu bungebe nha kati a miyii mia me, mundaa bu ali muyii a me, sa aholo musieende a nde.» ");
INSERT INTO iyx_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Bu Yiisu amani na uha tumini dii kwaa miyii mia nde kuumi na mioolo, nde amatii nha mbuu yii, na ayeni mu uyiisi mu mangaanda ma mu itinini kii. ");
INSERT INTO iyx_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yowani Mubootii, bu ali mu perese, ayuyi bu bakitsuu mu biyiluu bia Kristo. Ni mu buu nde atsindii babamosi mu miyii mia nde, ");
INSERT INTO iyx_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","mu ufuulu Yiisu: «We ni Mesiya wu kaayira, oo ti bisi diafwaana ukebe muutu mukimi?» ");
INSERT INTO iyx_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yiisu avutili kwaa bo: «Diyene diyaabisa kwaa Yowani maa ma beni dili mu uyuu na ma beni dili mu umono. ");
INSERT INTO iyx_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Babakwa misi bali mu umono, bikata bili mu utemene, bangaa bwaari bali mu ubeeluu, babakwa matswi bali mu uyuu, babakwa bali mu usiimbuu, na Ndaa Yimbwe bali mu uyaabisa kwaa bawele. ");
INSERT INTO iyx_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kinyi kwaa wu uhama mu umene miaanzi mu Nziaambi mu ndaa a me.» ");
INSERT INTO iyx_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Mu taanga di miyii mia Yowani miayeni, Yiisu abaandii utsuu kwaa koongi mu ndaa a Yowani, nde aleeli: «Ima beni diyimono ku tsi ya tsata? Idiaara ki iteembi ili mu unyingisi? Ngori? ");
INSERT INTO iyx_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ka ima beni diyimono? Muutu walwaata bikutu bia tala? Ka babulwaata bikutu bia tala mu manzo ma mitini bali mu uba. ");
INSERT INTO iyx_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ka ima beni diayamono? Mubili a Nziaambi? Ee-e, me nadileeli, nde avulu na paa mubili. ");
INSERT INTO iyx_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ka mu ndaa a Yowani Mabasonuu ma Ngira mali mu uleele: “Me nitsinduu tumu a me ku kula a we, mu udibili we kuulu, buleeli Nziaambi.” ");
INSERT INTO iyx_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ngwanya me nadileeli: Mu boosi bababutuu mu mukaasa, kaala a kwamoonuu pe muutu wavulu Yowani Mubootii mu bunene. Ka bunu, wavulu bukee mu Ipfumu kia mayula, avulu nde mu unaanguu. ");
INSERT INTO iyx_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Umatuu mu taanga di Yowani Mubotuii akiyiisi natee mu lolo, Ipfumu kia mayula bali mu udwaanisa kio mu kakabi. Na, bangaa kakabi bali mu usaa upatila kio. ");
INSERT INTO iyx_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mikaanda mia mibili mioosi na Mikele mia Mooso bayaabisi Ipfumu kia mayula, natee mu taanga dia Yowani. ");
INSERT INTO iyx_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Na so beni ditooni usiingi ndaa yi, ni nde Yowani wuli weti mubili Eliya wu bayaabisi nziriri a nde. ");
INSERT INTO iyx_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Diyuu bubwe so beni dili na matswi. ");
INSERT INTO iyx_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Na bana me nifwaanisa baata ba lolo ba? Bo bafwaanina na bibabaana biadiaala nha mambuu ma baata boosi bubaakukunu. Ni kuu ku bana bali mu uloo kwaa babamosi: ");
INSERT INTO iyx_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Bisi diafuli beni piipi mu uyimbi mikuungu mia kinyi, ka beni a diakini pe! Bisi diayimbi mikuunga mia likwa ka beni a dialili pe!” ");
INSERT INTO iyx_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ka bunu, Yowani ayiri, nde a li mu udia so unywa pe, ka bali mu uleele: “Nde li na muheebili wu mubi!” ");
INSERT INTO iyx_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tumake, Mwaana a muutu ayiri, nde li mu udia na unywa, na bali mu uleele: “Dimono muutu wu ngaa lidia na nde li mu ukolo mala! Nde li nduu a batoli ba limaanda na bangaa masumu!” Ka buyeri ba Nziaambi bali mu umonuu mu biyiluu bia nde.» ");
INSERT INTO iyx_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ninha, Yiisu abaandii usieembe, baata ba mu mangaanda ma nde ayilii bimaanga bialaa mu mo, mundaa ti baata ba mu mangaanda maa a basobi ndiaatili a bo yimbi pe, na a bakiinguu kwaa Nziaambi pe. Nde aleeli: ");
INSERT INTO iyx_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Ngebe kwaa beni, baata ba ngaanda ya Korazi! Ngebe kwaa beni, baata ba ngaanda ya Betesayida! Ka so bimaanga bi basiiri kwaa beni, ali basiiri bio mu mangaanda ma Tiro na Sidoni, keni umatuu belepe baata ba bo bakoti mu bukwiili. Keni bo balwaati masaaka ma ngooto, na ukili lifutu ku mutswe, na keni basobi ndiaatili a bo yimbi na ukiinguu kwaa Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ni mubuu, me nileele kwaa beni, mu iluumbu kia pfuundisi, Nziaambi sa asieembe beni, mu iteesi kiavulu mifuri na tsieembili ya baata ba Tiro na baata ba Sidoni. ");
INSERT INTO iyx_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ka beni baata ba ngaanda ya Kapernawumi! Beni bu ditsimi ti beni sa dinaanguu natee ku yulu? Sa badikululu natee ku tsi a babakwa. Mundaa ti, so bimaanga bi bayilii mu beni, bayilii bio mu baata ba ngaanda ya ngaanda a Sodomo, keni ngaanda yii yikeni natee lolo. ");
INSERT INTO iyx_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ni mubuu me nadileeli, mu iluumbu kia pfuundisi, beni sa diholo tsieembili yavulu mifuri na tsieembili ya ngaanda a Sodomo.» ");
INSERT INTO iyx_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mu taanga dii, Yiisu aloyi: «Oo Taata, Pfumu a yula na tsi, me nitoono kwaa we, bu we mweesi kwaa bikenyi, moosi ma we aswee kwaa bangaa buyeri, na bangaa nziaabili. ");
INSERT INTO iyx_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ee-e Taata, mu bweese ba we, we atoono ti buba weti buu.» ");
INSERT INTO iyx_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«Taayi a me aha me biloo bioosi. Muutu pe wayaaba Mwaana, so a ni Taayi pe. Muutu pe wayaaba Taayi, so a ni Mwaana pe, na kwaa baa ba Mwaana atoono umweese nde.» ");
INSERT INTO iyx_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Diyiri kwaa me, beni boosi ba manyutu ma maadee mundaa bibiti bialeme bi beni dili mu ubiti, na me sa ha beni iholo. ");
INSERT INTO iyx_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Diholo ikoolo kia me, na nyaalani me nadiyiisi, mundaa ti me ndi na buleembi na mutimi wakuluu, na beni sa dibaa iholo mundaa beni bameme. ");
INSERT INTO iyx_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ikoolo me kii, a ili pe na pasi mu ubiti, na mufunu wu me ndi mu uha beni li waleenge.» ");
INSERT INTO iyx_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nha mbisi a taanga hoolo, Yiisu atabi matsiee ma bele mu iluumbu kia saba. Miyii mia nde miabayi nzala. Bo babaandii ukaba mbutu dia bele na udia dio. ");
INSERT INTO iyx_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Bafarisi bu bamoni buu, baleeli kwaa Yiisu: «Mono, miyii mia we mili mu uyiluu mandaa ma mikele mia bisi mialii, mu uyiluu mu iluumbu kia saba!» ");
INSERT INTO iyx_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yiisu avutili kwaa bo: «Beni a diataanga pe miayilii Daavidi mu taanga di nde me na baata ba nde babayi nzala? ");
INSERT INTO iyx_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nde akoti mu nzo a Nziaambi, na itwaari na baata ba nde, bo badi mapa ma bahi bungori kwaa Nziaambi. Bunu bo a bali na muswa pe mu udia mo, mundaa ti mikele mia bisi mili mu uha muswa wa udia mo, ndila kwaa bangaanga ba Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","So a buu pe, so beni ditaangi mu mikele mia Mooso, beni sa dimono ti mu iluumbu kia saba, bangaanga ba Nziaambi babali mu isala, mutso Nzo a Nziaambi nha mbuu ya Ngira, a bubaakiinzi pe mukele a saba, ka bunu, mu yii, a bubaamono toono mu bo pe. ");
INSERT INTO iyx_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ka me nadileeli: ndaa yili nha, yavulu Nzo a Nziaambi mu mufunu. ");
INSERT INTO iyx_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ngwanya, so beni aba diayaaba mbiindila Mabasonuu ma Ngira ma: “Mutimi wa ngebe avulu ndutu na bungori babali mu uha kwaa me”, keni beni a diheeri tsieembili kwaa bahele a toono pe. ");
INSERT INTO iyx_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Mundaa ti Mwaana a muutu ni Pfumu a saba.» ");
INSERT INTO iyx_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yiisu amatii nhaa, ayeni ku nzo a makutunu ma Bayuudayo. ");
INSERT INTO iyx_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kwali nhaa na muutu mosi wabobo koo. Bafarisi bali na nzala ya ufuundu Yiisu, ni mu buu, bamufuuli: «Mikele mia bisi mili mu uha muswa, mu ubeelese muutu mu iluumbu kia saba?» ");
INSERT INTO iyx_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yiisu avutili kwaa bo: «So mosi mu beni li na indombo ndila imosi, na kio ibwiiri mu idunu kiayii mu iluumbu kia saba, nde sa anyaala kio uyapalisa na uholo kio? ");
INSERT INTO iyx_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ka muutu avulu indombo ndutu! Mu yii, mikele mia bisi mili mu uha muswa mu uyiluu mamabwe kwaa muutu mu iluumbu kia saba.» ");
INSERT INTO iyx_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ni mu buu, Yiisu aleeli kwaa muutu wuu: «Sibili koo kia we.» Nde asibili kio, na koo kiabwihama bubwe-bubwe weti ki imosi. ");
INSERT INTO iyx_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Bafarisi bayeni, na badiaali mu pfuundu, mu umono buni bo butuu udusu Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yiisu bu ayaabi mandaa maa, nde amatii nha mbuu yii. Na baata balaa bamuduki. Nde abeelisi babeeri boosi. ");
INSERT INTO iyx_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ka mu ibaala kioosi nde alii bo mu uyaabisa kwaa baata nde na ali. ");
INSERT INTO iyx_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Maa mayilimi buu paa maleeli mubili Yeesaya mayene tsitsi: ");
INSERT INTO iyx_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Wu ni musiali a me wu me nasoolo, wu me natoono na wu nasuusu kinyi a me yoosi. Me sa suusu Muheebili a me nha yulu a nde, na nde sa ayaabisa ti, me sa fuundusu bifuumbu bioosi bia nha tsi mu ngwanya. ");
INSERT INTO iyx_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nde a ukaama na muutu pe, na a unaangila pe muniingi a ndaa a nde, a buyuu pe nde mu utsuu mu makuulu. ");
INSERT INTO iyx_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nde a uboolo pe idiaara kiamaakwafutunu, a udimisi pe mwiindi wu ka mu udimi. Nde sa ayiluu buu natee bu nde ubiingisi mandaa ma ngwanya, ");
INSERT INTO iyx_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","na bifuumbu bia baata bioosi sa bisuusu ilimbisi kia bo mu nde.» ");
INSERT INTO iyx_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mu taanga dii, babeyi kwaa Yiisu, muutu mosi wa ingimangimi wali ka baba, mundaa ti nde li akangama kwaa muheebili wu mibi. Yiisu wamubeelisi, muutu wuu abaandii utsuu na umono baata. ");
INSERT INTO iyx_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Koongi yakimii, na boosi baleeli: «Nde mwaana a Daavidi ali?» ");
INSERT INTO iyx_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Bafarisi bu bayuyi bo, baleeli: «Muutu wu li mu ubingi miheebili mimibi, mundaa ti Belezebuli mukuutu a mio, li mu uha nde litu.» ");
INSERT INTO iyx_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ka Yiisu ali ayaaba matsimi ma bo. Ni mu buu, nde aleeli kwaa bo: «Pasi ipfumu ki baata bali mu udwaana midiingi bo na bo, tsukili a kio ndila utsaamuu. Pasi ngaanda, so a buu pe, kaanda li baata bali mu uhele ubwayuhusunu bo na bo utuu pe udiingi. ");
INSERT INTO iyx_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","So Saatana bingi Saatana, nde li mu udwaanisa nde makulu. So ni buu, buni ipfumu kia nde ituu udiingi? ");
INSERT INTO iyx_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Beni dili mu utsimi ti me ndi mu ubingi miheebili mimibi mu lituu la Belezebuli, ka mu ki litu baana ba beni bali mu ubingi mio? Baana ba beni bo makulu bali mu umweese ti beni a dili na buungu pe. ");
INSERT INTO iyx_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ka mu ngwanya, ni mu Muheebili a Nziaambi me ndi mu ubingi miheebili mimibi, pili mosi ti Ipfumu kia Nziaambi kiaamaato natee kwaa beni. ");
INSERT INTO iyx_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«A uli pe na wu utuu ukoto mu nzo a muutu ngaa mifuri na upatila bisii bia nde, mbiiti nde a akwakutu pe ngaa mifuri wuu bibolo! Ka nha mbisi a ukutu nde bibolo, tumake nde tuyi uholo bioosi bili mu nzo a nde. ");
INSERT INTO iyx_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Wu uhele uba itwaari na me li mutaata a me; na wu uhele ubaasila me mu ukukuu nde li mu utsara. ");
INSERT INTO iyx_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ni mu buu, me nadileeli: baata utuu uholo nyaalili a matoono ma bo mu masumu moosi, na mu bitari bioosi nha kulu a Nziaambi. Ka wuu wu utuu Muheebili wa Ngira a busa nde kolokolo pe. ");
INSERT INTO iyx_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Wu uleele ndaa yimbi mu Mwaana a muutu, sa bamusa kolokolo. Ka wu utsuu bubi mu Muheebili wa Ngira a busa pe nde kolokolo mu taanga di, so mu taanga dikaayira. ");
INSERT INTO iyx_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Mu ubaa mbutu dimbwe, beni diafwaana uba na muti wu mubwe. So beni dili na muti wuli na ibeeri, beni sa dibaa mbutu dimbi. Ka bali mu uyaaba muti mu mutindi a mbutu di nde ali mu ubutu. ");
INSERT INTO iyx_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Beni ifuumbu kia bapili! Buni beni dituu uleele mandaa ma mabwe, mbiiti beni dili bababi? Mundaa ti munywa upalisa mialuulu mu mutimi. ");
INSERT INTO iyx_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Muutu wu mubwe, li mu upalisa mandaa ma mabwe, mali mu mutimi a nde wu mubwe. Muutu wu mubi, li mu upalisa mandaa ma mabi, mali mu mutimi a ndi wu mubi. ");
INSERT INTO iyx_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Me nadileeli: mu iluumbu kia pfuundisi, baata sa bayala mutata mu mandaa moosi ma buwulu ma bo bapalisa. ");
INSERT INTO iyx_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mundaa ti, mu ma mupala mu munywa a we bufuundusu we. Mu mo we ubiingi, so a buu pe mu mo we ubwa.» ");
INSERT INTO iyx_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ninha bakimi mu bayiisi ba mikele na Bafarisi baleeli kwaa Yiisu: «Muyiisi, bisi ditooni ti we mweese bisi iliimbi kia ukimuu, kili mu umweese ti Nziaambi atsinduu we.» ");
INSERT INTO iyx_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yiisu avutili, aleeli kwaa bo: «Baata ba isieende kia lolo, bali baata bababi na bangaa tsoongili, bo bali mu uloombo iliimbi kia ukimuu. A uli pe na iliimbi ki bumweese bo, ka ndila kii kiayilimi mu mubili Yoona. ");
INSERT INTO iyx_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Weti bu mubili wuu asiiri biluumbu bitata bia nyanga, na bia butsuu mu moonyi a tswi wu munene, bumosi ka Mwaana a muutu sa asa biluumbu bitata bia nyanga na bia butsuu ku tsini a toto. ");
INSERT INTO iyx_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mu iluumbu kia pfuundisi, basi Ninive sa batemene nha kulu a baata ba isieende kia lolo ki, na sa bafuundu bo, mundaa ti basi Ninive basobi ndiaatili bu bo bayuyi nziisili a mubili Yoona. Ka nha uli na wavulu mubili Yoona! ");
INSERT INTO iyx_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mu iluumbu kia pfuundisi, mutini wa mukaasa wa ku tsi ya baanda, sa atemene nha kulu a baata ba isieende kia lolo ki, na ufuundu bo. Mundaa ti mutini wuu amata ku bitini bia tsi bia ku la, mu uyayuu mandaa ma mutini Solomo maluulu mu buyeri. Ka nha uli na wavulu mutini Solomo! ");
INSERT INTO iyx_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Mbiiti muheebili wu mubi maapala mu muutu, nde li mu uyene mayena-yene ku mambuu ma kanya, mu usaa mbuu ya puumini. Mbiiti nde a solili yo pe, ");
INSERT INTO iyx_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","nde li mu uleele: “Me sa vutuu ku nzo a me, muu mu me napali.” Na bu avutii, nde baasi nzo bwaasi, isii pe mu kati, bakoombolo na bayiluu bungeele. ");
INSERT INTO iyx_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ni mu buu, nde sa avutuu mu uyaholo miheebili tsaamba mikimi miavulu nde buhaangi. Bo sa bavutuu mu nzo yii na udiaala muu. Mu yii, mapasi ma muutu wuu sa mavulu mifuri na ma tsiomi. Ni buu ka bukaaba mu baata bababi ba isieende kia lolo ki.» ");
INSERT INTO iyx_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yiisu bu ali keni mu utsuu kwaa koongi, nguu na baana ba nguu ba nde bayiri. Bo ali ku mbari na basiayi utsuu na nde. ");
INSERT INTO iyx_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Muutu mosi aleeli kwaa Yiisu: «Mono, nguu a we na baana banguu ba we, bali ku mbari, na bo bali na nzala a utsuu na we.» ");
INSERT INTO iyx_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yiisu wamuvutili: «Na li nguu a me, na bana bali baana banguu ba me?» ");
INSERT INTO iyx_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tumake, nde alayi miyii mia nde mu koo, na aleeli: «Mono nguu a me na baana banguu ba me nha bali. ");
INSERT INTO iyx_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ka pasi nde wu uyiluu litoono la Taayi a me wuli ku mayula, nde li mwaana a nguu a me wa baala, keri a me, na nguu a me.» ");
INSERT INTO iyx_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Iluumbu kii, Yiisu apali mu nzo, na ayidiaala nha simi la diaanga mu uyiisi. ");
INSERT INTO iyx_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Koongi ya laa yakukini na yamudiengilili, ni mu buu nde ahaati nha yulu a bootu, na adiaali. Baata boosi bali nha simi la diaanga, nha kulu a nde. ");
INSERT INTO iyx_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nde akitsuu bo mandaa malaa mu matsaba, na akileele kwaa bo: «Iluumbu imosi muutu mosi ayinyasila mbutu mu tsiee a nde. ");
INSERT INTO iyx_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Bu nde akinyisila mbutu, di dimosi diabwiiri mu mukoo a kuulu: banyunyi bayiri, na batooti dio. ");
INSERT INTO iyx_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ndaamba a mbutu dimosi diabwiiri nha mbuu ya mamanya, nha yahele na toto dialaa. Mbutu diameni mu mawasa mundaa toto ali yulu-a-yulu. ");
INSERT INTO iyx_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nyanga bu yabali, yanyeengisi mitswiili: mio miakanyi mundaa ti miaanzi ali a miayiluu udiaama pe. ");
INSERT INTO iyx_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ndaamba a mbutu dikimi diabwiiri kutso mingaamba. Mingaamba miakuli na miadusi mitswiili. ");
INSERT INTO iyx_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ka ndaamba a mbutu dikimi diabwiiri nha toto dia mboloso, diameni, diakuli na diabuti mbutu: dini mbutu kama, dini maku-masamina na dibimosi maku-matata.» ");
INSERT INTO iyx_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Na Yiisu abwileele: «Wu li na matswi, nyaala ayuu!» ");
INSERT INTO iyx_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ninha miyii miaswesii kwaa Yiisu na miamufuuli: «Mu ima we li mu uta bo matsaba?» ");
INSERT INTO iyx_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nde wabavutili: «Beni diabaa bweese ba nziaabili a matsweeyi ma Ipfumu kia mayula, ka bo a babayi bweese baa pe. ");
INSERT INTO iyx_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mu ngwanya, kwaa muutu wuli na bisii, sa babwabweese nde bisi bikimi, na nde sa aba na bio bialaa. Ka kwaa muutu wahele na isii, sa bamumaasa ndaamba a bisii bia ali na bio. ");
INSERT INTO iyx_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ni mundaa yii me ndi mu usalila matsaba mu utsuu kwaa bo: mundaa ti bo bali na misi, ka a bali mu umono pe, na bo bali na matswi, ka a bali mu uyuu pe. ");
INSERT INTO iyx_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ninha mbilili yaheeri mubili Yeesaya yili mu uyene tsitsi mundaa bo, bu aleeli: “Beni sa diyiluu uyuu, ka a diyaaba mbiindili pe; beni sa diyiluu utala, ka a dimono pe. ");
INSERT INTO iyx_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mundaa ti ifuumbu ki aka na mutimi bunono; bo bamaadibuu matswi ma bo, na bamaadibuu misi mia bo, paa misi mia bo minyaala umono, paa matswi ma bo manyaala uyuu, na paa mu mayele ma bo banyaala uyaaba mambiindili, na mu buu, bo a buyiravutuu kwaa me pe paa me nababeelese, buleeli Nziaambi.” ");
INSERT INTO iyx_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Ka kwaa beni, kinyi yili na beni: mundaa ti misi mia beni mili mu umono na matswi ma beni mali mu uyuu! ");
INSERT INTO iyx_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ee-e, ngwanya me nadileeli: mibili mia laa na baata babanambita mu Nziaambi bali batoono umono mi beni dili mu umono, ka a bamono mio pe, na uyuu ma beni dili mu uyuu, ka a bayuu mo pe. ");
INSERT INTO iyx_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Ka diyuu mbiindila tsaba ya munyasili a mbutu: ");
INSERT INTO iyx_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Mu taanga di muutu li mu uyuu mandaa ma Ipfumu kia Nziaambi, ka a ali mu uyaaba mambiindili ma mo pe, wu mubi li mu uyiri, na li mu umaasa mbutu dibanyasili mu mutimi a nde. Yii ni mbiindila mbutu diabwi mu mukoo a kuulu. ");
INSERT INTO iyx_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Diabwi nha mbuu ya mamanya, ni muutu wuli mu uyuu mandaa ma Nziaambi, na li mu uyaka mo nhaa na nhaa mu kinyi. ");
INSERT INTO iyx_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ka bu mbutu dii diahele na miaanzi, diadiingi ndila taanga hoolo. Mundaa ti, mu taanga di mapasi, so a buu pe, minyoongo mili mu uyiri, mundaa a mandaa ma Nziaambi, mawasa-mawasa, imiini kia nde sa ibwa. ");
INSERT INTO iyx_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mbutu diabwi kutso mingaamba, ni muutu wuli mu uyuu mandaa ma Nziaambi, ka matsimi ma tsi yi, na busini ba pia, bili mu unyongoso mo, a bibaaha mo kuulu pe mu ubutu. ");
INSERT INTO iyx_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ka diabwi nha toto dia mboloso, ni muutu wuli mu uyuu mandaa ma Nziaambi, na li mu uyaaba mambiindili ma mo. Nde li mu ubutu mbutu: kama, maku masamina, na maku matata.» ");
INSERT INTO iyx_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yiisu abwita bo tsaba kimi: «Mono ifwaani kia Ipfumu kia mayula: muutu mosi ali akunu mbutu dimbwe mutso tsiee a nde. ");
INSERT INTO iyx_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Butsuu bumosi bu baata boosi ali matolo, mutaata a muutu wuu ayiri, akuni itiiti ki ibi mutso bele na ayeni. ");
INSERT INTO iyx_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mu taanga di bele lameni na labaandii ubutu, bitiiti bi bibi ka biameni. ");
INSERT INTO iyx_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Basiali ba ngaa tsiee bayileele nde: “Pfumu, we akuni mbutu dimbwe mutso tsiee a we, ka itiiti ki ibi ki kuni imati?” ");
INSERT INTO iyx_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nde wabavutili: “Mutaata a me yilii buu.” Basiali bamufuuli: “Buni? We tooni ti bisi diyene ditaapala itiiti ki ibi?” ");
INSERT INTO iyx_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nde avutili: “Ngori! Mundaa mu taanga di beni ditaapala itiiti kii, beni utuu utaapala ka bele. ");
INSERT INTO iyx_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Dinyaala bio bioosi bikulu mu itwaari natee mu taanga dia ukukuu, na mu taanga dii, me sa leele kwaa ba bukukuu: dikwamaasa bitiiti bi bibi na dikutu bio mu biko paa ditsuu bio mbaa, tumake disuusu bele ku yulu a ibaanga kia me.”» ");
INSERT INTO iyx_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yiisu abwita bo tsaba kimi: «Ipfumu kia mayula kiafwaanina na libutu la mutarede, li muutu aholi na akuni mutso tsiee a nde. ");
INSERT INTO iyx_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Lo lavulu bukee mu mbutu dioosi. Ka mu taanga di lo limaakulu, lo ka lavulu mbutu bioosi bia mutso wooto mu bula: lo ka mwaana a muti, na banyunyi bali mu uyatuungu manzo ma bo mu mapaki ma nde.» ");
INSERT INTO iyx_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yiisu abwita bo tsaba kimi: «Ipfumu kia mayula kiafwaanina na lifunusu la mapa li mukaasa ali mu uholo na uvuutu na liviiri, paa ipuuti idaanda kwalaa.» ");
INSERT INTO iyx_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yiisu akiyaabisa mii mioosi kwaa makoongi mu matsaba. Nde a akitsuu kwaa bo pe kwahele a usalila matsaba. ");
INSERT INTO iyx_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nde akiyiluu buu paa maleeli mubili a Nziaambi mayene tsitsi: «Me sa dibili munywa a me mu utsuu mu matsaba; me sa yaabisa matsweeyi maa umatuu mu mbaandila tsi.» ");
INSERT INTO iyx_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ninha Yiisu asiisi koongi na ayeni ku nzo. Miyii mia nde miaswesii nha peembi a nde na bamuleeli: «Biindili bisi tsaba ya itiiti ki ibi mutso tsiee.» ");
INSERT INTO iyx_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yiisu avutili kwaa bo: «Wuli mu ukunu mbutu dimbwe ni Mwaana a muutu. ");
INSERT INTO iyx_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Tsiee, ni tsi. Mbutu dimbwe ni babali ku tsini a tumimi dia Ipfumu kia mayula, na itiiti ki ibi ni babali ku tsini a litumu la Wu mubi. ");
INSERT INTO iyx_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mutaata wuli mu ukunu mbutu dimbi, ni Saatana. Ukukuu mbutu ni manini a tsi. Babukukuu, ni batumu ba Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Weti bu bumaasa itiiti ki ibi mu ubumu kio ku mbaa, ni buu bukaaba mu manini a taanga. ");
INSERT INTO iyx_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwaana a muutu sa atsinduu batumu ba nde, bo sa bapalisa mu Ipfumu kia nde, boosi babali mu ubwiisi imiini kia babamosi, na ba bali mu usalila bubi. ");
INSERT INTO iyx_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Batumu baa sa babadumunu mu idunu kia mbaa, ku ba balayi bakaalili na bakaakweete mini. ");
INSERT INTO iyx_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ka ninha, babanambita mu Nziaambi sa bangeyene weti tari mu Ipfumu kia Taayi a bo. Wuli na matswi nyaala ayuu! ");
INSERT INTO iyx_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Ipfumu kia mayula kiafwaanina na busini babwaswee mutso tsiee. Muutu bu asiolili bo, bwiswee bo. Nde luuli mu kinyi na nde yeni, yalii bioosi bi abaa na nde yiravutuu mu usuumbu tsiee yii. ");
INSERT INTO iyx_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Ipfumu kia mayula kiabwafwaanina na muteeri a kaari wuli mu usaa bilaba bia tala. ");
INSERT INTO iyx_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Bu asolili imosi kia tala yavululu, nde yeni na yalii bioosi bi abaa, na nde suumbi ilaba kii. ");
INSERT INTO iyx_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Ipfumu kia mayula kiabwafwaanina na siele li badumunu mu mubu na lili mu ukieese batswi ba mupili na mupili. ");
INSERT INTO iyx_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Bu limani na uluulu, balobi udutu lo natee mu mukoo a nziali, tumake bo badiaali mu usoolo batswi: batswi ba babwe baloosi mu mapwooyi, na babumi bababi. ");
INSERT INTO iyx_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ni buu bukaaba ku manini a taanga. Batumu ba Nziaambi sa bayakabala bababwe na bababi, ");
INSERT INTO iyx_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","mu udumunu bo ku idunu kia mbaa, ku balayi bakaalili na ukweete mini.» ");
INSERT INTO iyx_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yiisu afuuli bo: «Beni diyuyi maa moosi?» Bo bamuvutili: «Ee-e». ");
INSERT INTO iyx_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ninha Yiisu aleeli kwaa bo: «Ni mu buu, pasi muyiisi a mikele wu ukituu muyii a Ipfumu kia mayula afwaanina na ngaa nzo, wu upalisa kutso mbayili a nde yoosi, biloo bi binyatii na bi bikulu.» ");
INSERT INTO iyx_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yiisu bu amani uta matsaba maa, nde amatii nha mbuu yii, ");
INSERT INTO iyx_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","na ayeni ku ngaanda yi nde akuli. Nde ayiisi mu nzo a makutunu ma Bayuudayo, na baata boosi babali nhaa bakimii. Bo baleeli: «Kuni nde abayi buyeri ba? Buni nde ali mu utuu uyiluu bimaanga bi? ");
INSERT INTO iyx_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","A ni nde pe mwaana a mukomini a manzo? Mari a ni nguu a nde pe? Na baana ba nguu ba nde, a ni Yaki, Yoosefi, Simooni na Yude pe? ");
INSERT INTO iyx_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Na bakeri ba nde boosi a bali mu udiaala na bisi nha pe? Kuni nde abayi litu li loosi?» ");
INSERT INTO iyx_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Na mandaa maa moosi makikoonoso bo mu usa imiini mu nde. Ni mu buu Yiisu aleeli kwaa bo: «Bali mu ukiinzi mubili a Nziaambi mu mambuu moosi, ka ndila mu ngaanda yi nde abutuu, na mu kaanda la nde bali mu uhele ukiinzi nde.» ");
INSERT INTO iyx_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nha mbuu yii, Yiisu a ayilii pe bimaanga bialaa mundaa pelili a imiini kia bo. ");
INSERT INTO iyx_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mu taanga dii, Erode mutini a Ngalili, ayuyi ku bakitsuu mu Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nde aleeli kwaa basiali ba nde: «Wuu Yowani Mubootii maasiimbuu mu babakwa! Ni mu buu, nde ali na litu la uyiluu bimaanga.» ");
INSERT INTO iyx_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Erode atsuyi buu, mundaa ti nde ali atumu bakaanga Yowani, bakutulu nde bibolo na badumunu nde mu perese. Ali mu toono a Erodiade, mukari a Filipo mwaana a nguu a nde. ");
INSERT INTO iyx_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Mundaa Yowani akileele kwaa Erode: «We ali na muswa pe mu uholo Erodiade aba mukari a we!» ");
INSERT INTO iyx_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erode ali na nzala ya udusu Yowani, ka nde akibata boomo ba baata, mundaa bo boosi bakimono Yowani weti mubili. ");
INSERT INTO iyx_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ka, iluumbu kia mukuungi wa mbutili a Erode, mwaana a Erodiade wa mukaasa akini nha kulu a baata boosi ba batumisi ku mukuungi, Erode amoni kinyi yalaa mu nde. ");
INSERT INTO iyx_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ni mu buu, Erode alabi mukisi mu uha mwaana wuu, pasi ki nde uloombo. ");
INSERT INTO iyx_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mwaana aduki ndoongi a nguu a nde, na nde aleeli kwaa Erode: «Nha dili nha, ha me mutswe a Yowani Mubootii nha tso ikoombo!» ");
INSERT INTO iyx_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ngebe dialuuli mu mutimi a mutini. Ka mundaa mukisi wu nde alabi nha kulu a baata ba nde atumisi ku mukuungi, nde ahi muswa paa bayiluu weti buli ndoombili a mwaana wa mukaasa. ");
INSERT INTO iyx_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ni mu buu nde atsindii muutu mu uyakese mutswe a Yowani mu perese. ");
INSERT INTO iyx_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Babeyi mutswe a Yowani nha ikoombo na bahi nde kwaa mwaana wa mukaasa, na nde ka ahi mutswe me kwaa nguu a nde. ");
INSERT INTO iyx_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Miyii mia Yowani miayiholo nyutu a nde na badii yo. Tumake bo bayiyaabisa kwaa Yiisu mamalabii. ");
INSERT INTO iyx_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yiisu bu ayuyi ndaa yii, nde amatii nha mbuu yii, nde akoti mu bootu na ayeni. Nde atooni uyene ku mbuu yahele na baata. Ka makoongi ma baata mayaabi buu, bo bamatii mu mangaanda ma mali bebele na baduki Yiisu. Bo bakiyene mu miili ku simi li limosi la diaanga. ");
INSERT INTO iyx_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Mu taanga di Yiisu asutii mu bootu, nde amoni koongi yinene. Mutimi a nde aluuli mu ngebe mundaa baata baa, na nde abaandii mu ubeelese babeeri ba bo. ");
INSERT INTO iyx_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tsitsii bu yatoori, miyii mia nde miaswesii kwaa nde na miamuleeli: «Busi baka mu uyili, na mbuu yi yatakuu na manzo ma baata. Vutulu baata ba boosi paa bo bayene mu mala, mu usuumbu bia udia.» ");
INSERT INTO iyx_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yiisu avutili kwaa bo: «Tsata pe ti bo bayene. Diabaha bia udia beni bame.» ");
INSERT INTO iyx_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ka bo baleeli kwaa nde: «Bisi nha ndila mapa mataana na batswi boolo dili na bio.» ");
INSERT INTO iyx_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yiisu aleeli kwaa bo: «Dibee me bio nha.» ");
INSERT INTO iyx_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nha mbisi nde atumi koongi mu udiaala nha tsini nha mbuu yi bo bali. Tumake nde aholi mapa mataana maa na batswi boolo baa, asiimbili misi, atali ku yula, na avutili matoono kwaa Nziaambi. Nde abukili mapa na ahi mo kwaa miyii, na bo bakabi bio kwaa koongi. ");
INSERT INTO iyx_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Boosi badiiri na bayuuti. Miyii miatoli bitsuru biasiaalili, na mialuusi mapwooyi kuumi na moolo mu bitsuru bii. ");
INSERT INTO iyx_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Litaanga la babadiiri ali utuu uto mafuundu mataana ma babaala, kwahele a utaanga bakaasa na baana. ");
INSERT INTO iyx_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nha mbisi, Yiisu atumi miyii mu ukoto mu bootu paa bo batswaamina ku simi la mubu lilimosi, mu taanga di nde me uleele kwaa baata mu uvutuu ku mangaanda ma bo. ");
INSERT INTO iyx_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Bu amani na uvutulu baata, nde ahaati ku yulu a mulaanda mu ukuundu. Tsitsii bu yatoori, nde ali ninha, nde bake. ");
INSERT INTO iyx_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Bootu ali ka la na simi, mapo ma maamba makinyingisi lo mundaa iteembi kiakibwaana bo. ");
INSERT INTO iyx_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mu kati-a-kati a butsuu, Yiisu ayeni kwaa miyii mia nde bu akidiaata nha yulu a mukaanda a maamba. ");
INSERT INTO iyx_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Mu taanga di bamumoni mu udiaata nha yulu a mukaanda a maamba, bo bapamii na baleeli: «Ki iduuru!» Na bo bakesi mingiri mundaa boomo. ");
INSERT INTO iyx_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ka nhaa na nhaa Yiisu atsuyi kwaa bo na nde aleeli: «Dilwaata ibaala, ni me wa me, a diba na boomo pe!» ");
INSERT INTO iyx_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ninha Peetero avutili, na aleeli kwaa nde: «Pfumu, ngwanya so ni we, ha muswa, paa me diaata nha yulu a mukaanda a maamba mu uyiri kwaa we.» ");
INSERT INTO iyx_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yiisu asiingi, na aleeli: «Yira!» Peetero apali mu bootu na abaandii udiaata nha yula mukaanda a maamba mu uyene kwaa Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ka mu taanga di nde amoni mifuri mia iteembi, nde abayi boomo. Nde abaandii udiaama mu maamba, na aloyi: «Pfumu, vuusu me!» ");
INSERT INTO iyx_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nhaa-na-nhaa, Yiisu asibili koo kia nde, wamukaangi na wamuleeli: «Imiini kia we ki ikee ili! Mu ima we siiri paa?» ");
INSERT INTO iyx_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bo baboolo bakoti mu bootu na iteembi kiawuri. ");
INSERT INTO iyx_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ni mu buu, miyii miali mutso bootu miatsukini nha kulu a Yiisu mu ukuundu nde, na miamuleeli: «Ngwanya we Mwaana a Nziaambi!» ");
INSERT INTO iyx_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bo bamani usabuu diaanga na batoori mu itinini kia Ngenesareti. ");
INSERT INTO iyx_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Baata ba itinini kii bayaabi Yiisu, na batsiari mvuungu a nziriri a nde mu mapeembi moosi, na bamubeyi babeeri boosi. ");
INSERT INTO iyx_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bamubondili paa nde wabaha muswa wa ubumunu so ndila toso a iyungu kia nde. Na boosi bababumini kio babeelii. ");
INSERT INTO iyx_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Bafarisi na bayiisi ba mikele bamati ku Yeruselemi, bayiri kwaa Yiisu na bamufuuli: ");
INSERT INTO iyx_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Mundaa ima miyii mia we mili mu uhele ukiinzi mikele miasiisi bakaa ba bisi? Munda bo a bubaaswaa mioo pe tswaamini a udia weti buli bukulu ba bisi.» ");
INSERT INTO iyx_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yiisu avutili kwaa bo: «Ka beni, mu ima dili mu uhele ukiinzi tumini a Nziaambi, na nha mbuu ya uyiluu buu, beni dili mu ukiinzi bukulu ba beni? ");
INSERT INTO iyx_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ka Nziaambi aleele: “Kiinzi taayi na nguu a we”, na “Pasi nde wu usibi taayi so nguu a nde bafwaana udusu nde.” ");
INSERT INTO iyx_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ka beni dili mu uyiisi ti, so muutu leeli kwaa taayi so kwaa nguu a nde: “Bi me na keni uha we mundaa ubaasila we, ni bi me nataasila mu uha bungori kwaa Nziaambi”, ");
INSERT INTO iyx_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","beni dili mu uha muswa kwaa muutu mu uhele ukiinzi taayi a nde. Ni buu beni dili mu utee mbisi kwaa andaa ma Nziaambi, mu uyiluu weti buli bukulu ba beni. ");
INSERT INTO iyx_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Beni bangaa peluu! Yeesaya mubili a Nziaambi, ali na buungu mu taanga di nde abili, mu toono a beni mu mandaa ma: ");
INSERT INTO iyx_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Baata ba bali mu ukiinzi me ndila mu bibori, ka mitimi mia bo miatakuu na me. ");
INSERT INTO iyx_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Mu matsimi ma bo ti bo me bali mu usalila, ka mu paamba bo bali mu uyiluu buu, mundaa ti, nziisili yi bo bali mu uyiisi, a yili ya mikele miamata kwaa Nziaambi pe, ka yo yili ya mikele miamata kwaa baata.”» ");
INSERT INTO iyx_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tumake Yiisu ateeri koongi, na nde aleeli kwaa boosi: «Diyuululu na diyuu mbiindila mandaa ma: ");
INSERT INTO iyx_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","a bi bikoto mu munywa bili mu usumunu muutu pe. Ka mamupala mu munywa a nde, ni mo mali mu usumunu muutu.» ");
INSERT INTO iyx_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ni mu buu, miyii miaswesii kwaa Yiisu na miamuleeli: «We ayaaba ti Bafarisi bu bayuyi we mu utsuu mandaa maa, bo bamoni pasi mu mitimi mia bo?» ");
INSERT INTO iyx_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nde avutili: «Pasi muti wu Taayi a me wa ku yula ahele ukunu, sa batapala nde. ");
INSERT INTO iyx_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Diabanyaala! Bo bingima-ngimi bili mu ubiti bambayi bingima-ngimi! Na so ingimangimi ibiti mbaayi ingimangimi, bo baboolo sa babwa mu idunu.» ");
INSERT INTO iyx_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Peetero aleeli kwaa nde: «Biindili bisi tsutulu a tsaba yii.» ");
INSERT INTO iyx_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yiisu avutili: «Beni ka kaala mbahala pe? ");
INSERT INTO iyx_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Beni utuu pe uyaaba ti, bioosi bi bikoto mu munywa a muutu bili mu kulunu mu moonyo a nde, na nha mbisi bili mu upala mu nyutu a nde? ");
INSERT INTO iyx_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ka mamupala mu munywa mali mu umata ku mutimi, na ni mo mali mu usumunu muutu. ");
INSERT INTO iyx_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Mundaa mu mutimi a nde ni muli mu umata matsimi mamabi, mamali mu utsindi nde ku ndusili a baata, tsoongili, ipuupu, muyibi, uta bimbaangi bia pia, na uleele mandaa mamabi mu bambaayi. ");
INSERT INTO iyx_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ni maa mali mu usumunu muutu! Ka udia kwahele a uswaa mioo a yili mu usumunu pe muutu.» ");
INSERT INTO iyx_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tumake Yiisu amatii nha mbuu yii na ayeni ku itinini kia Tiro na kia Sidoni. ");
INSERT INTO iyx_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mukaasa mosi, musi Kaana wakidiaala mu itinini kii, ayiri kwaa nde na aloyi: «Pfumu, mwaana a Daavidi, kwiilili me ngebe! Mwaana a me wa mukaasa li akangama kwalaa kwaa miheebili mimibi, nde li mu umono ngo pasi!» ");
INSERT INTO iyx_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ka Yiisu a avutili ndaa so mosi pe. Miyii mia nde miaswesii na mialoombi kwaa nde: «Vutulu nde, mundaa nde li mu uduku bisi nha mbisi mu uyiri aloo.» ");
INSERT INTO iyx_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yiisu avutili: «Me batsinduu ndila kwaa mameme mamadiimbili ma mu mukaanga a Iseraeli.» ");
INSERT INTO iyx_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ka mukaasa ayitsukunu nha kula a nde na aleeli: «Pfumu, baasila me!» ");
INSERT INTO iyx_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yiisu avutili: «Bubwe pe mu uholo mapa ma baana, na udumunu mo kwaa bambwa.» ");
INSERT INTO iyx_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mukaasa wamuleeli: «Ni buu, Pfumu! Ka bunu so bambwa bali mu udia bisiesiengi bili mu ubwa ku tsini a meese ma bapfumu ba bo.» ");
INSERT INTO iyx_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ni mu buu, Yiisu avutili kwaa nde: «Ee-e, maama! Imiini kia we yili ki inene! Nyaala Nziaambi aha we ma we tooni.» Na mwaana a nde abeelii mu dii na taanga dii. ");
INSERT INTO iyx_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yiisu asiisi mbuu yii na ayeni ku mukoo a diaanga la Ngalili. Nde ahaati ku yulu a mulaanda na adiaali. ");
INSERT INTO iyx_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Makoongi ma baata mayiri kwaa nde, babeyi bangaa bitonzo, bingima-ngimi, bangaa bipii, mababa, na babeeri bakimi balaa. Basuusi bo nha miili mia Yiisu, na nde wababeelisi. ");
INSERT INTO iyx_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Baata bakimii bu bamoni mababa mu utsuu, bangaa bipii mu ubeeluu, bitonzo mu udiaata bubwe, na bingima-ngimi mu umono. Na mundaa maa moosi, bo bakoti mu ukiinzi Nziaambi a Iseraeli. ");
INSERT INTO iyx_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yiisu ateeri miyii mia nde mbili na aleeli: «Me ndi na ngebe a baata ba, mundaa ti biluumbu ka bitata bo bali na me nha, na bo ka bia udia pe. Me a natoono pe uvutulu bo kwahele a udia. Bo utuu ubwa iwututu mu kuulu.» ");
INSERT INTO iyx_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Miyii mia nde miamufuuli: «Kuni dituu ubaa, mutso tsi ya tsata mu, bia udia bi diha kwaa koongi yinene yi, paa baata badia na bayuutu?» ");
INSERT INTO iyx_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yiisu afuuli bo: «Mapa kwe beni dili na mo?» Na bo bavutili: «Tsaamba, na mwaana batswi ba bakee.» ");
INSERT INTO iyx_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ninha nde aleeli kwaa koongi mu udiaala nha tsini. ");
INSERT INTO iyx_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tumake nde aholi mapa tsaamba maa na batswi, avutili matoono kwaa Nziaambi, abukili mo na aheeri mo kwaa miyii mia nde, na miyii miakabi mo kwaa boosi. ");
INSERT INTO iyx_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Boosi badiiri na bayuuti. Miyii miatoli bikesi biasiaalili, na mialuusi mapwooyi tsaamba mu bikesi bii. ");
INSERT INTO iyx_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Litaanga la babadiiri lali mafuundu mana ma babaala, kwahele a utaanga bakaasa na baana. ");
INSERT INTO iyx_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Bu amani na uvutulu koongi, Yiisu ahaati mu bootu na ayeni ku itinini kia Mangadani. ");
INSERT INTO iyx_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Bafarisi na Basaduki baswesii kwa Yiisu mu ulebuu nde mweete. Bo bamuloombi ti amweese bo mu iliimbi kia ukimuu ti nde amata kwaa Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ka Yiisu avutili kwaa bo mu mandaa ma: «Mu tsitsii, bu tari lika mu udiaama, beni diayaaba mambiindili na ki taanga dikaaba. Mu taanga dii, beni dili mu uleele: “So yulu labeenge, bisi sa dibaa taanga dimbwe.” ");
INSERT INTO iyx_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na mu ngwaali-a-ngwaali, beni dili mu uleele: “Lolo mvulu sa anoo, mundaa yula labeenge kuni lapiindi.” Beni diayaaba usoboso biliimbi bia mataanga, ka beni ukoono usoboso biliimbi bili mu umonuu mu taanga di! ");
INSERT INTO iyx_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Baata ba isieende kia lolo ki, bali ba babi na bangaa tsoongili nha kulu a Nziaambi, bali mu uloombo iliimbi kia ukimuu. Ka a wuli na iliimbi ki bu mweese bo pe, so a ni kia Yaona pe.» Tumake nde asiisi bo na ayeni. ");
INSERT INTO iyx_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mu taanga di miyii miasabii ku simi la diaanga li limosi, bo badiimbili ubiti mapa. ");
INSERT INTO iyx_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ninha Yiisu aleeli kwaa bo: «Diyuu! Disa mayele mu liviiri la mapa la Bafarisi na Basaduki.» ");
INSERT INTO iyx_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Miyii mialelisini nha kati a bo: «Nde tsuyi buu mundaa bisi a diabee pe mapa.» ");
INSERT INTO iyx_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yiisu ayaabi ma bo bakitsuu na wabafuuli: «Mundaa ima beni dili mu ulelesene nha kati a beni ti mundaa a dili na mapa pe? Beni baata babali na imiini ki ikee mu Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Beni a dili mu ubwayaaba pe? Dilibili moonyi mu mapa mataana, ma bakaba kwaa mafuundu mataana ma babaala, na litaanga la mapwooyi ma beni diabiti! ");
INSERT INTO iyx_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Na dilibili moonyi ka mu mapa tsaamba, ma bakaba kwaa mafuundu mana ma babaala, na litaanga la mapwooyi ma beni diabiti! ");
INSERT INTO iyx_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Buni beni dili mu uhele uyaaba ti, a mu miatala mapa pe me nakitsuu kwaa beni, mu taanga di me nakileele beni: “Disa mayele mu liviiri la mapa la Bafarisi na Basaduki”?» ");
INSERT INTO iyx_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ninha miyii miayaabi ti a mundaa liviiri la mapa pe nde aleeli kwaa bo mu usa mayele, ka mundaa nziisili a Bafarisi na Basaduki. ");
INSERT INTO iyx_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yiisu ayeni ku itinini kia Sezare ya Filipo. Nde afuuli miyii mia nde: «Baata ima bali mu uleele mundaa Mwaana a muutu?» ");
INSERT INTO iyx_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bo bavutili: «Babamosi bali mu uleele ti we Yowani Mubootii, bana ti we Eliya, na bakimi ti we Yelemiya, so a buu pe mu mubili mukimi.» ");
INSERT INTO iyx_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Na Yiisu wabafuuli: «Ka beni, buni dili mu uleele? Me na ndi?» ");
INSERT INTO iyx_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simooni Peetero avutili: «We ni Mesiya, Mwaana a Nziaambi wa moonyi.» ");
INSERT INTO iyx_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ni mu buu Yiisu aleeli kwaa nde: «Ba kinyi, Simooni mwaana a Yoona, mundaa ti a musunyi na makili pe biyaabisi we maa, ka Taayi a me wuli mu mayula. ");
INSERT INTO iyx_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ee-e, me ndeeli kwaa we: we ni Peetero, mbiindili ti “manya.” Na ninha yulu a manya li, me nituungu libuundu la me. So likwa a lituu ubiingi lo pe. ");
INSERT INTO iyx_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Me sa ha we matsiafi ma Ipfumu kia mayula. Mi we ukutu nha tsi, sa bakutu mu mayula. Na mi we unyangila nha tsi, sa banyangila mu mayula.» ");
INSERT INTO iyx_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tumake, Yiisu alii mu ibaala kwaa miyii mia nde, mu uhele uleele kwaa muutu ti nde ni Mesiya. ");
INSERT INTO iyx_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Umatuu mu taanga dii, Yiisu abaandii mu utsuu na yaki-yaki kwaa miyii mia nde bu aleeli: «Me nafwaana uyene ku Yeruselemi na umono pasi dia laa nha mioo mia bakuutu ba Bayuudayo, na banguu ba bangaanga ba Nziaambi na bayiisi ba mikele. Me sa badusu, na mu iluumbu kia bitata, me sa siimbuu.» ");
INSERT INTO iyx_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ninha Peetero abiti nde nha peembi na abaandii usieembe nde na aleeli: «Nziaambi akebe we, Pfumu! Ngori, mii a miyilimi mu we pe!» ");
INSERT INTO iyx_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ka Yiisu bu asieetii, aleeli kwaa Peetero: «Saatina! Swese ku naa, takuu na me! We li baka mu kuulu a me, mundaa ti we a li mu utsimi pe weti Nziaambi, ka matsimi ma we matsimi ma imuutu». ");
INSERT INTO iyx_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tumake Yiisu aleeli kwaa miyii mia nde: «So muutu tooni uduku me, anyaala utsimi mu nde makulu, ka abiti kuruwa a nde na aduku me. ");
INSERT INTO iyx_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Mundaa, pasi nde watoono uvuusu idiingi kia nde sa adiimbisi kio; ka wu udiimbisi idiingi kia nde mu toono a me sa asololo kio. ");
INSERT INTO iyx_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ki ndaanda muutu ubaa so nde bayi busini ba tsi yoosi, na nha mbuu mosi, ufuusu idiingi kia nde? So a buu pe, ki isii muutu utuu uha mu usoboso na idiingi kia nde? ");
INSERT INTO iyx_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ka, Mwaana a muutu sa ayira mu buzitu ba taayi a nde, itwaari na batumu ba nde, na sa aha musieende kwaa muutu-muutu weti buli biyiluu bia nde. ");
INSERT INTO iyx_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mu ngwanya me nadileeli: babamosi mu babali nha, a bukwa pe, natee bo bumono ku Mwaana a muutu uyira weti mutini.» ");
INSERT INTO iyx_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nha mbisi a biluumbu bisamina, Yiisu aholi Peetero, Yaki na Yowani, mukee a Yaki, na abiti bo ku yulu a mulaanda wu mula, bo ali kuu bo bake. ");
INSERT INTO iyx_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mu taanga di bo bakitala nde, Yiisu amonii kwaa bo mu ifwaani ki ikimi: kiinzi kia nde kiabaandii ungeyine weti tari, na bikutu bia nde biahembii na pee weti liyalila. ");
INSERT INTO iyx_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Itsundu-a-tsundu, Mooso na Eliya bamonii kwaa miyii mio mitata. Bo baboolo bakitsuu na Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ninha Peetero aleeli kwaa Yiisu: «Pfumu, bubwe bisa-beni mu uba nha. So we tooni, me utuungu bituru bitata nha, imosi kia we, imosi kia Mooso, na imosi kia Eliya.» ");
INSERT INTO iyx_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nde ali keni mu utsuu, bu tuti la liyalila layifuu bo, na ndaa mosi yayuyini kutso tuti, yaleeli: «Wuunawu ni Mwaana a me wa litoono ndaa, mu nde me nasuusu kinyi a me yoosi. Diyuu nde!» ");
INSERT INTO iyx_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Mu taanga di miyii miayuyi ndaa yii, bo babayi boomo balaa na babwiiri biinzi mu tsini. ");
INSERT INTO iyx_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yiisu aswesii kwaa bo, abeembi bo na aleeli: «Ditemene, a diba na boomo pe.» ");
INSERT INTO iyx_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Bo basiimbili misi mia bo na a bamoni muutu mukimi pe ka ndila Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Bu bakisutuu mulaanda, Yiisu wabahi tumini yi: «A dileele kwaa muutu so moosi pe ma beni dimoni, natee Mwaana a muutu usiimbu mu babakwa.» ");
INSERT INTO iyx_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tumake miyii miafuuli Yiisu: «Mu ima bayiisi ba mikele bali mu uleele ti Eliya afwaana ukwayira?» ");
INSERT INTO iyx_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nde avutili kwaa bo: «Eliya afwaana ukwayira mu uvutulu bungeele mu bioosi. ");
INSERT INTO iyx_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ka mu me, me nileele beni: Eliya amaakwayiri, baata a bamuyaabi pe, na bamuyilii mioosi mi bo batooni. Ni buu ka, bo bakaakwaamisa Mwaana a muutu nde makulu.» ");
INSERT INTO iyx_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ninha, miyii miayaabi ti nde akitsuu bo mundaa a Yowani Mubootii. ");
INSERT INTO iyx_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mu taanga di bo batoori nha yali koongi, muutu mosi aswesii kwaa Yiisu, atsukini nha kulu a nde, ");
INSERT INTO iyx_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","na aleeli: «Pfumu, kwiilili mwaana a me wa baala ngebe. Nde ubaabwa sisi na nde li mu pasi. Mu taanga di nde ali kutso pasi dii, nde ubaabwa ku mbaa, so a buu pe, mu maamba. ");
INSERT INTO iyx_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Me nabee nde kwaa miyii mia we, ka bo a batuu nde ubeelese pe.» ");
INSERT INTO iyx_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yiisu aloyi: «Beni baata ba babi na babahele a imiini! Natee ki taanga me nafwaana uba na beni? Natee ki taanga me nafwaana ubiti mufunu a beni? Dibee me mwaana wuu nha.» ");
INSERT INTO iyx_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yiisu afweengi muheebili wu mubi. Nde apali mu mwaana, na mwaana abeelii mu dii na taanga dii. ");
INSERT INTO iyx_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ninha miyii miaswesii kwaa Yiisu nha mbuu ya bo-bake na bamufuuli: «Mu ima bisi diahele utuu ubingi muheebili wuu?» ");
INSERT INTO iyx_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yiisu avutili kwaa bo: «Mundaa imiini kia beni ngo bukee ili. Mu ngwanya me nadileeli: so beni diali na imiini ki ikee weti libutu la mutarede, beni aba utuu uleele kwaa mulaanda wu: “Sobo mbuu, yene kunaanga”, na nde keni usobo mbuu. Keni a utuu uba na ndaa so mosi yi dikoono beni pe.  ");
INSERT INTO iyx_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ka ndila mu likuundu na ndiili a mutuutu butuu ubiingi pili a muheebili wu.» ");
INSERT INTO iyx_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Iluumbu imosi bu miyii miali itwaari ku Ngalili, Yiisu aleeli kwaa bo: «Mwaana a muutu sa bayeelele nha mioo mia baata. ");
INSERT INTO iyx_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Bo sa bamudusu. Ka mu iluumbu kia bitata, nde sa usiimbuu mu babakwa.» Na mu taanga dii, miyii miamoni ngebe dialaa. ");
INSERT INTO iyx_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Mu taanga di Yiisu na miyii mia nde batoori ku ngaanda ya Kapernawumi, batoli ba limaanda la Nzo a Nziaambi baswesii kwaa Peetero na bamufuuli: «Muyiisi a beni a ali mu ufutu pe limaanda la Nzo a Nziaambi?» ");
INSERT INTO iyx_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Peetero avutili: «Ee-e, nde li mu ufutu.» Mu taanga di Peetero akoti mu nzo, Yiisu akwibaanduu utsuu na aleeli: «Buni we li mu utsimi Simooni? Na afwaana ufutu limaanda kwaa mitini mia tsi yi? Baata ba tsi a bo oo ti bieenyi?» ");
INSERT INTO iyx_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peetero avutili: «Bieenyi.» Yiisu aleeli kwaa nde: «Mu yii, baata ba tsi a bali na kia ufutu pe. ");
INSERT INTO iyx_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ka a diatoono umweese baata ba pasi mu mitimi pe. Ninha, yene ku diaanga, we dumunu lobo mu maamba, tswi watsiomi wu upala, kaanga nde na we dibili munywa a nde. Na nhaa, we sa mono mukuti a mboongo wakuu mu ufutu limaanda la me na la we. Holo mukuti a mboongo wuu, na we futu bo limaanda la bisi baboolo.» ");
INSERT INTO iyx_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mu taanga dii, miyii miaswesii kwaa Yiisu, na miamufuuli: «Na avulu ndutu mu Ipfumu kia mayula?» ");
INSERT INTO iyx_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yiisu ateeri imwamwaana mbili, wamusuusi nha kati a bo, ");
INSERT INTO iyx_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","na aleeli: «Mu ngwanya me nadileeli, so beni a disobi ndiaatili a beni pe na uba weti bibabaana, beni a dituu uba baata ba Ipfumu kia mayula pe. ");
INSERT INTO iyx_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Wavulu ndutu mu Ipfumu kia mayula, ni wuu wu ukuluu na uba weti imwamwaana ki. ");
INSERT INTO iyx_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Na pasi muutu wu uyaka imwamwaana weti kiinaki, mundaa ti muutu wuu atoono me, nde yaki me makulu.» ");
INSERT INTO iyx_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Pasi nde wu ubwiisi mu masumu, mosi mu bibabaana bi bili mu usa imiini mu me, yavulu bubwe kwaa nde bamukutulu limanya li linene mu kiingi, na bamudumunu ku musundu a mubu. ");
INSERT INTO iyx_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ngebe kwaa baata ba tsi! Mundaa ti mandaa ma mukubusu baata mabaka mali ma laa. Mandaa ma pili yi a mubaahele pe, ka ngebe kwaa muutu wuli mu ukubu ti mandaa maa mayilimi! ");
INSERT INTO iyx_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","So ni mundaa koo kia we, so a buu pe, mundaa kuulu kia we, we ubwa mu masumu, kese bio na bumu bio la na we. Ka yavulu bubwe kwaa we mu ukoto mu moonyi wa ngwanya na ndila koo imosi, so a buu pe, kuulu imosi. Uyiluu buu yavulu bubwe, mu uhele uba wu budumunu ku mbaa ya mbuuungulu, na mioo mio mia mioolo, so a buu pe, na miili mio mia mioolo. ");
INSERT INTO iyx_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na so ni mundaa lisi la we, we ubwa mu masumu, sootolo lo, na dumunu lo la na we. Mundaa, yavulu bubwe kwaa we mu ukoto mu moonyi wa ngwanya na ndila lisi limosi, ka a mu uba na misi mio mia mioolo pe, na uba wu budumunu ku mbaa ya mbuungulu.» ");
INSERT INTO iyx_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Disa mayele! A dimeengele pe so mosi mu bibabaana bi. Ka ngwanya me nadileeli, batumu ba bo bali mu taanga dioosi nha kulu a kiinzi kia Taayi a me wuli mu mayula.  ");
INSERT INTO iyx_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ka Mwaana a muutu a yiri mu uvuusu ba bali badiimbili.» ");
INSERT INTO iyx_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«Ima beni dili mu utsimi? Mbiiti muutu li na kama la mameme, ninha limosi mu mo lidiimbili, nde a usiisi pe maku wa na wa mamamosi ku yulu a mulaanda mu uyene ku usaa ladiimbili? ");
INSERT INTO iyx_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ee-e, me nadileeli, so nde solili lo, nde sa amono kinyi yavululu mu limeme lii, kwavulu kinyi ya mu maku wa na wa ma mameme mahele udiimbili. ");
INSERT INTO iyx_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ni buu ka, Taayi a beni wuli mu mayula a atoono pe ti so mosi mu bibabaana bia nde adiimbili.» ");
INSERT INTO iyx_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«So mwaana nguu a we yilii we mimibi, yamono nde mu taanga di beni diba ndila beni boolo na mweese nde bubi ba nde. So nde yuyi we, nhaa we maavuusu nde. ");
INSERT INTO iyx_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ka so nde bisi uyuu we, holo muutu mosi so a buu pe boolo baba itwaari na we, paa weti bu li mu uleele Mabasonuu: “Pasi ndaa bafwaana uyiluu yo nha kulu a bambaangi boolo so batata.” ");
INSERT INTO iyx_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ka so nde bisi uyuu bo, leele yo kwaa libuundu, na so nde bisi uyuu libuundu, holo nde weti mungooyi, so a buu pe mutoli a limaanda.» ");
INSERT INTO iyx_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«Mu ngwanya me nadileeli: pasi ma dikutu beni nha tsi, sa bakutu mo mu mayula. Na pasi ma dinyangila beni nha tsi sa banyangila mo mu mayula.» ");
INSERT INTO iyx_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«Me nadileeli ka ti, so baata boolo nha kati a beni bayuhisini nha tsi, mu uloombo pasi kio mu likuundu, Taayi a me wuli mu mayula sawabaha bo kio, weti bu baloombi. ");
INSERT INTO iyx_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mundaa nha mbuu yi baata boolo so batata bakukunu mu kuumbu a me, me ndi nha kati a bo.» ");
INSERT INTO iyx_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ninha Peetero aswesii kwaa Yiisu na wamufuuli: «Pfumu, mbala kwe me nafwaana usa mwaana nguu a me kolokolo mbiiti nde yilii me bubi? Natee mbala tsaamba?» ");
INSERT INTO iyx_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yiisu avutili kwaa nde: «Ngori, me a nileele pe we ti natee mbala tsaamba, ka natee mbala maku tsaamba mbala tsaamba. ");
INSERT INTO iyx_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ni mu buu, mono ifwaani kia Ipfumu kia mayula: Mutini mosi aholi kesili ti bangaamba ba nde bayala nde mutata, mundaa mayaama ma bo bakoti kwaa nde. ");
INSERT INTO iyx_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mu taanga di babaandii uyala nde mitata, bamubeyi ngaamba mosi wali na yaama la nde, la mafutu mafuundu kuumi ma mikuti mia mboongo. ");
INSERT INTO iyx_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Muutu wuu a ali na mbayili pe mu utuu uvutulu mboongo dii. Ni mu buu pfumu a nde atumi ti bayaluu nde weti mutee na bayaluu ka mukari a nde, baana ba nde na bioosi bi ali na bio, paa babele yaama. ");
INSERT INTO iyx_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ngaamba atsukini nha kulu a pfumu a nde na wamuleeli: “Kama mutimi mu me, na me sa fuutu we yaama loosi.” ");
INSERT INTO iyx_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Pfumu wamukwiilili ngebe: nde anyaali yaama la nde na wamunyaali ayene.» ");
INSERT INTO iyx_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Ngaamba wuu bu apali abwaani mosi mu bambaayi ba nde ba isala, wali na yaama la nde la mikuti kama mia boongo. Nde ayaki na apinyi mbaayi wuu nha kiingi na aleeli: “Bele yaama la me!” ");
INSERT INTO iyx_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mbaayi ngaamba wuu abwiiri nha miili mia nde na wamupeli mbii bu: “Kama mutimi mu me, na me sa bele yaama la we!” ");
INSERT INTO iyx_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ka wu mumosi abisi, nha yulu a nhaa nde wamuheeri paa bamudumunu mu perese natee bu nde ubele yaama la nde. ");
INSERT INTO iyx_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Bambaayi basiali, bu bamoni mamayilimi, bo banyoongi kwalaa na bayileele mioosi kwaa pfumu a bo. ");
INSERT INTO iyx_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ni mu buu pfumu atiiri ngaamba wuu mbili na wamuleeli: “We ngaamba wuli na mutimi wu mubi! Me nanyaala yaama la we mundaa we a apele me mu uyiluu buu. ");
INSERT INTO iyx_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","We aba afwaana ka ukwiili mbaayi a we wa isala ngebe, weti bu me na kwiilili we ngebe!” ");
INSERT INTO iyx_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Pfumu a nde abayi kesi ya mifuri na wamutsindii ku perese la bisala bia mifuri natee bu nde ubele yaama la nde loosi.» ");
INSERT INTO iyx_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Tumake Yiisu abwileele: «Ni buu ka Taayi a me wuli ku yula akaayiluu mu beni, mbiiti muutu-muutu mu beni utuu pe usa mwaana a nguu a nde kolokolo mu mutimi a nde woosi.» ");
INSERT INTO iyx_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Mu taanga di Yiisu amani mu uha nziisili yii, nde asiisi itinini kia Ngalili, na ayeni ku itinini kia tsi ya Yuuda, ku simi li limosi la nziali ya Yorodaani. ");
INSERT INTO iyx_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Koongi a baata yamuduki kuu, na nde abeelisi babeeri ba bo. ");
INSERT INTO iyx_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ndaamba a Bafarisi baswesii kwaa nde mu ulebuu nde mweete. Bo bamufuuli: «Mikele mia Nziaambi mili mu uha muswa kwaa baala mu ubingi mukari a nde mu pasi toono?» ");
INSERT INTO iyx_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yiisu avutili: «Beni a diataanga pe mialeeli Mabasonuu? “Mu mbaandili, Nziaambi wabayilii baala na mukaasa.” ");
INSERT INTO iyx_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tumake Nziaambi aleeli: “Ni mu buu, baala sa asiisi taayi na nguu a nde, na ukaangama mu mukari a nde, na bo baboolo sa baba muutu mosi.” ");
INSERT INTO iyx_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ni mu buu, bo ka a bubwaba baata boolo pe, ka muutu mosi. Ninha, muutu anyaala ukabala bi Nziaambi avuutu.» ");
INSERT INTO iyx_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Bafarisi bamufuuli: «So ni buu, mu ima Mooso atumu baala, mu uha mukaanda a tsialili a makweele kwaa mukari a nde, mu taanga di nde amaabingi nde?» ");
INSERT INTO iyx_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yiisu avutili: «Mooso ahi beni muswa wa ubingi bakari ba beni, mundaa beni dili na mitimi mia minono. Ka mu mbaandila yali buu pe. ");
INSERT INTO iyx_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Me nadileeli: so baala bingi mukari a nde, mbii ti mukari a nde a asoongo pe, na so baala lii kweeli mukaasa mukimi, nde soongi.» ");
INSERT INTO iyx_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Miyii mia nde miamuleeli: «Mbii ni buu buli mukele a makweele, yavulu bubwe mu uhele ukweele.» ");
INSERT INTO iyx_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yiisu avutili kwaa bo: «Babaala boosi a butuu pe usiingi nziisili yi, ka ndila baa ba Nziaambi aha litu la usiingi yo. ");
INSERT INTO iyx_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mandaa malayi mali mu ukoonoso baata mu uhele ukweele: kwaa babamosi, mingoongo mia umatuu bu babutu bo; kwaa bana, bambaayi baata badusi mabutu ma bo; bakimi ka babisi ukweele mundaa Ipfumu kia mayula. Nyaala ti wu utuu usiingi nziisili yi asiingi yo!» ");
INSERT INTO iyx_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Baata babeyi bibabaana kwaa Yiisu paa nde anaa mioo nha yulu a bo na akuundulu bo Nziaambi, ka miyii miasieembi bo. ");
INSERT INTO iyx_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ka Yiisu aleeli: «Dinyaala bibabaana bayiri kwaa me na adiabalii pe, mundaa Ipfumu kia mayula yili kia babali weti bo.» ");
INSERT INTO iyx_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nde anayi mioo nha yulu a bo pa asieme bo, na asiisi mbuu yii. ");
INSERT INTO iyx_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mufuru a baala limosi laswesii kwaa Yiisu na lamufuuli: «Muyiisi, ki ndaa yimbwe me nafwaana uyiluu mu ubaa moonyi wu uhele uwa?» ");
INSERT INTO iyx_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yiisu aleeli kwaa nde: «Mu ima we uha me nduru mu miatala mamabwe? Ndili a mosi li wu mubwe. So we tooni ukoto mu moonyi wu uhele uwa, kiinzi mikele mia Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nde afuuli: «Ki mio?» Yiisu avutili: «A dusu pe; a soongo pe; a yibi pe; a ta imbaangi kia pia pe mu muutu. ");
INSERT INTO iyx_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Kiinzi taayi a we na nguu a we; toono mbaayi muutu na we weti we makulu.» ");
INSERT INTO iyx_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mufuru a baala wamuleeli: «Me nakiinzi mikele mii mioosi. Ima me nafwaana ubwayiluu mu ubaa moonyi wuu?» ");
INSERT INTO iyx_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yiisu wamuleeli: «So we tooni uba wakuu, yene we yaluu bi we abaa bioosi na ha mboongo kwaa bawele, na we sa baa busini mu mayula, na nha mbisi a maa yiri we duku me.» ");
INSERT INTO iyx_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ka mu taanga di mufuru a baala wuu ayuyi mandaa maa, nde ayeni kutso ngebe, mundaa nde ali na busini balaa. ");
INSERT INTO iyx_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ni mu buu Yiisu aleeli kwaa miyii mia nde: «Mu ngwanya me nadileeli: ili pasi kwaa muutu wa isini mu ukoto mu Ipfumu kia mayula. ");
INSERT INTO iyx_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Na me nibwaleele beni ndaa yi: yili pasi kwaa nyama wa weti puundi mu ulabuu mu wuru la tsioongi, ka ya bwavulu pasi kwaa isini mu ukoto mu Ipfumu kia Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Mu taanga di miyii miayuyi mandaa maa, bo bakimii kwalaa na baleeli: «Ka ninha, na utuu uvuu?» ");
INSERT INTO iyx_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yiisu atali bo na wabaleeli: «Kwaa baata mii utuu pe uyilimi, ka kwaa Nziaambi mioosi utuu uyilimi.» ");
INSERT INTO iyx_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ninha Peetero aleeli: «Mono, bisi diasiisi bioosi mu uduku we. Ka ki musieende bisi dikaabaa?» ");
INSERT INTO iyx_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yiisu aleeli kwaa bo: «Mu ngwanya me nadileeli: mu taanga di Mwaana a muutu akaadiaala nha mbata a ipfumu kia nde kia buzitu mu tsi yi inyatii, beni kuumi na boolo ba diaduku me, beni ka sa didiaala nha mambata ma bipfumu mu ufuundusu bifuumbu kuumi na bioolo bia Iseraeli. ");
INSERT INTO iyx_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na baata boosi ba busiisi manzo ma bo, so a buu pe baana ba nguu ba bo, bakeri ba bo, taayi a bo, nguu a bo, baana ba bo, matsiee ma bo mu toono a me, sa babaa biavulu bii mufutu mbala kama, na sa babaa moonyi wu uhele uwa. ");
INSERT INTO iyx_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ka babalayi babali mu taanga di babatsiomi, sa baba batsieelele, na babalayi babali mu taanga di batsieelele sa baba babatsiomi.» ");
INSERT INTO iyx_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Mono bwafwaanina Ipfumu kia mayula: Ngaa tsiee a viinyi mosi apali mu nzo a nde ngwaali-a-ngwaali, mu uholo basiali mu tsiee a nde. ");
INSERT INTO iyx_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nde ayuhisini na bo mu ufutu bo mu tala yi bayuku ukwabaa, mukuti mosi wa mboongo mu iluumbu, na nde wabatsindii mu uyasala ku tsiee a nde ya viinyi. ");
INSERT INTO iyx_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nde abwipala mu nguungu ya wa mu ngwaali, na nde abwimono bakimi babadiaala ku kulu a mbari kwahele a usa isala. ");
INSERT INTO iyx_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nde wabaleeli: “Beni ka diyasala, ku tsiee a me ya viinyi, na me sa nadiha mufutu wafwaana.” ");
INSERT INTO iyx_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Na bo bayeni kuu. Ngaa tsiee abwipala mu nzanga, tumake mu nguungu ya matata nha mbisi a nzanga na ayilii bumosi. ");
INSERT INTO iyx_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nha tsieelele, mu tsitsii, ku bele a nguungu ya mataana nha mbisi a nzanga, nde apali na amoni babaala bakimi batemene nha mbuu me yali yatemene batsiomi. Nde wabafuuli: “Mu ima beni dili mu udiaala nha iluumbu ki ibiimbili kwahele a usa isala?” ");
INSERT INTO iyx_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bo bavutili: “Mundaa muutu pe waholo bisi mu isala.” Nde aleeli kwaa bo: “Ee-e, beni ka diyasala mu tsiee a me ya viinyi.” ");
INSERT INTO iyx_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Tsitsii bu yatoori, ngaa tsiee a viinyi aleeli kwaa mutumi a bisala bia nde: “Tumusu basiali na wabaha muutu-muutu mufutu a nde. We ubaanduu mu babakoto tsieelele mu isala, na we umana mu babakoto tsiomi mu isala.” ");
INSERT INTO iyx_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Babakoti mu isala mu tsitsii, mu nguungu ya mataana nha mbisi a nzanga bayiri, na mutumi me wuu wabahi muutu-muutu mukuti a mboongo mosi. ");
INSERT INTO iyx_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Taanga dia babakoti tsiomi mu isala bu diatoori, bo batsimi ti bakeni ubaa mufutu wavulu wa babamosi. Ka nde wabahi ka kwaa muutu-muutu mukuti a mboongo mosi. ");
INSERT INTO iyx_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Mu taanga di bakiholo mufutu wuu, bo bakitsuu mandaa mamabi mu ngaa tsiee, ");
INSERT INTO iyx_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","na bakileele: “Basiali ba beni dialooso mu isala nha tsieelele ba, basala mu nguungu ndila mosi. Ka we futi bo iteesi imosi na bisi. Ka bunu, bisi dilemisi manyutu mu usala iluumbu ibiimbili ku tsini a nyanga yamifuri!” ");
INSERT INTO iyx_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ka ngaa tsiee avutili kwaa mosi mu bo: “Nduu a me, me a nasa we ndaa yimbi pe. We ayuhusunu na me mu usala mu mukuti a mboongo mosi mu iluumbu, a buu pe? ");
INSERT INTO iyx_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ninha holo mufutu a we na yene wa we. Mundaa ti, me natoono uha kwaa wakoto mu isala nha tsieelele wu iteesi imosi na we. ");
INSERT INTO iyx_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Me a ndi pe na muswa mu uyiluu ma me natoono mu mboongo dia me? So a buu pe we musoyi li na nde mundaa me ndi na mutimi wu mubwe?”» ");
INSERT INTO iyx_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yiisu abwileele: «Ni buu, batsieelele sa baba babatsiomi, na babatsiomi sa baba batsieelele.» ");
INSERT INTO iyx_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yiisu akiyene ku Yeruselemi na miyii mia nde. Bu bakiyene, nde atakii na miyii kuumi na mioolo nha peembi mu uyiisi bo. Nde wabaleeli: ");
INSERT INTO iyx_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Diyuu! Ku Yeruselemi dili mu uyene. A ni kuu pe bakaayeelele Mwaana a muutu, nha mio mia banguu ba bangaanga ba Nziaambi na bayiisi ba mikele? Bo sa bamuha kesili ya likwa, ");
INSERT INTO iyx_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","na sa bamuyeelele nha mioo mia bangooyi, ba busa nde saa, bufiinzi nde bikoti, na bukomo nde nha kuruwa. Na mu iluumbu kia bitata sa asiimbuu mu babakwa mu uba moonyi.» ");
INSERT INTO iyx_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Mu taanga dii, mukari a Zebedaayi aswesii kwaa Yiisu itwaari na baana ba nde boolo ba babaala. Nde abaandini nha kulu a nde mu uloombo nde ndaa mosi. ");
INSERT INTO iyx_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yiisu aleeli kwaa nde: «Ima we atoono?» Nde wamuvutili: «Ha me lilasina ti, mu taanga di we kaaba mutini, baana ba me bo baboolo ba, mbari sa badiaala nha mambuu ma buzitu. Mu bo baboolo, mosi sa adiaala nha koo kia we kia babaala, na wunu nha koo kia we kia bakaasa.» ");
INSERT INTO iyx_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yiisu avutili: «Beni a diyaaba pe ma beni dili mu uloombo. Beni utuu unywa mbasa ya mapasi yi me kaanywa?» Bo bamuvutili: «Ee-e, bisi utuu.» ");
INSERT INTO iyx_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yiisu wabaleeli: «Ka beni sa dinywa mbasa ya me. Ka a me pe nisoolo ba budiaala nha koo kia me kia babaala na nha koo kia me kia bakaasa. Mambuu maa mali ma baata ba Taayi a me ayiluu mo mu bo.» ");
INSERT INTO iyx_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Mu taanga di miyii kuumi mimimosi miayuyi buu, bo bakoli baana ba nguu boolo baa kesi. ");
INSERT INTO iyx_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ninha Yiisu ati boboosi mbili na aleeli: «Beni diyaaba ti bapfumu ba matsi makimi bali mu utumu baata ba bo mu mifuri. Na baata babanaanguu bali mu unyongoso baata bali ku tsini a litumu la bo. ");
INSERT INTO iyx_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ka mandaa maa utuu pe uyilimi weti buu nha kati a beni. Ka mbiiti mosi mu beni atoono uba wanaanguu, nde afwaana uba musali a beni. ");
INSERT INTO iyx_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Na mbiiti mosi mu beni atoono uba mukuutu, nde afwaana uba mutee a beni. ");
INSERT INTO iyx_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Bumosi ka Mwaana a muutu a ayiri pe paa bamusalila. Ka nde ayiri mu usalila baata, na uha moonyi a nde weti bungori mu uyobolo baata babalayi.» ");
INSERT INTO iyx_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Bu bo bapali mu ngaanda Yeriko, koongi yinene yaduki Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Bingima-ngimi bioolo biali biadiaala nha mukoo a kuulu biayuyi ti Yiisu ka mu uyoo. Ninha bio biakiloo: «Pfumu, Mwaana a Daavidi, kwiilili bisi ngebe!» ");
INSERT INTO iyx_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Baata babali mu koongi basieembi bo paa bawuru. Ka bo bahami mu uloo mu mifuri: «Pfumu, Mwaana a Daavidi, kwiilili bisi ngebe!» ");
INSERT INTO iyx_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yiisu atemini, wabateeri mbili na wabafuuli: «Buni me nituu ubaasila beni?» ");
INSERT INTO iyx_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bio biavutili kwaa nde: «Pfumu, dibili misi mia bisi paa mio mimono.» ");
INSERT INTO iyx_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yiisu amoni ngebe dia bio na abeembi misi mia bio. Nhaa na nhaa, bingima-ngimi bioolo bii biabaandii umono bubwe-bubwe na bio biaduki Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Mu taanga di bo bali ka bele na Yeruselemi na batoori ku peembi a bula ba Betefange, nha yulu a mulaanda a Olive. Mu dii na taanga dii, Yiisu atsindii miyii mioolo ku kulu. ");
INSERT INTO iyx_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Nde aleeli kwaa bo: «Diyene ku bula babali nha kulu a beni. Kuu beni sa dimono nhaa-na-tsi puundi wu bakutulu na mwaana a nde. Dinyangila na dibee me bo. ");
INSERT INTO iyx_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","So baleeli beni ndaa, divutulu: “Pfumu li na nzala a bo.” Tumake, sa baha beni muswa paa diyiri na bo.» ");
INSERT INTO iyx_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Maa mayilimi paa ti maleeli Nziaambi mu munywa a mubili mayene tsitsi: ");
INSERT INTO iyx_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Leelani kwaa baata ba Siooni: Mono, mutini a we li mu uyira kwaa we, aluulu mu buleembi, adiaala nha yulu a puundi, na nha yulu a mwaana a puundi, mwaana puundi wa mukari.» ");
INSERT INTO iyx_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ninha miyii miayeni na miayilii miatumi bo Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bo babeyi puundi na mwaana a nde, basuusi biyungu bia bo nha yulu a mwaana a puundi na Yiisu adiaali nha yulu. ");
INSERT INTO iyx_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mu uha nde buzitu, koongi a baata yinene yayali biyungu bia bo mu kuulu. Bakimi bakikese mapaki mu miti na bakisuusu mu kuulu, paa nde adiaata nha yulu a mo. ");
INSERT INTO iyx_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Baata babakiyene ku kulu na ku mbisi a Yiisu bakiloo: «Osaana Mwaana a Daavidi! Nyaala Nziaambi asieme wuli mu uyira mu kuumbu a Pfumu! Osaana kwaa Nziaambi mu mayula!» ");
INSERT INTO iyx_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Mu taanga di Yiisu akoti mu Yeruselemi, baata boosi bakoti kutso nyingi-nyingi, bakifuulu: «Baala li na ali?» ");
INSERT INTO iyx_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Baata bakivutulu: «Wu ni mubili Yiisu musi Nazareti, bula ba mu itinini kia Ngalili.» ");
INSERT INTO iyx_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yiisu akoti mutso lipaanga la Nzo a Nziaambi na abingi boosi ba bakiyaluu, so a buu pe ba bakisuumbu mutso muu. Nde abwiisi meese malaa ma basobi ba mboongo, na mambata ma bayalii a mabeembe. ");
INSERT INTO iyx_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Tumake nde aleeli kwaa bo: «Mu Mabasonuu, Nziaambi li mu uleele: “Nzo a me sa bata yo Nzo a likundu.”» Nde abwileele: «Ka beni diamaakitisi yo, isweemini kia miyibi!» ");
INSERT INTO iyx_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Bingima-ngimi na bangaa bitonzo, baswesii kwaa Yiisu mutso lipaanga la Nzo a Nziaambi, na nde wababeelisi. ");
INSERT INTO iyx_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Banguu ba bangaanga ba Nziaambi na bayiisi ba mikele, babayi kesi. Bo babayi kesi mundaa ti bo bamoni mandaa ma ukimuu ma nde akiyiluu. Baana babali mutso lipaanga la Nzo a Nziaambi bamono buu, bo babaandii uloo: «Osaana mwaana a Daavidi!» ");
INSERT INTO iyx_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Na bo baleeli kwaa Yiisu: «We li mu uyuu ma bo bali mu uleele?» Yiisu avutili kwaa bo: «Ee-e. Beni kaala a diataanga pe Mabasonuu ma ngira ma: “We asa ti, so baana na bibabaana babili we mu biyimbi”?» ");
INSERT INTO iyx_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tumake nde asiisi bo na apali mu ngaanda mu uyene ku Betania ku nde alaari. ");
INSERT INTO iyx_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Bukia ngwaali, mu taanga di nde akiyiravutuu mu ngaanda Yeruselemi, Yiisu akoli nzala. ");
INSERT INTO iyx_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nde amoni muti wa mufiike nha mukoo a kuulu na aswesii nha peembi a nde. Ka bu wamukengisi, ndila makaya nde amoni mu muti wuu. Ni mu buu nde aleeli kwaa muti: «We a ubwabutu mbutu pe!» Na nhaa-na-tsi, muti wa mufiike woosi uyaaba ukanya. ");
INSERT INTO iyx_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Miyii miamoni ndaa yii na miakimii kwalaa. Bo bafuuli kwaa Yiisu: «Buni muti wa mufiike wu akanyi nhaa-na-tsi?» ");
INSERT INTO iyx_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yiisu uvutili kwaa bo: «Mu ngwanya me nadileeli: so beni dili na imiini, na so a disiiri paa pe, beni utuu uyiluu ma me nzilii mu muti wa mufiike wu. Na beni utuu uyiluu mavulu maa. Beni utuu uleele kwaa mulaanda wu: “Matuu nha mbuu yii na yabwa mu mubu”, na mio sa miyilimi. ");
INSERT INTO iyx_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","So beni disiiri imiini mu Nziaambi, beni sa diholo moosi ma beni diloombo mu likundu.» ");
INSERT INTO iyx_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yiisu akoti mutso lipaanga la Nzo a Nziaambi na abaandii uyiisi baata. Banguu ba bangaanga ba Nziaambi na bakuutu ba Bayuudayo baswesii kwaa nde na bamufuuli: «Mu ki litu we li mu uyiluu mandaa maa? Na aha we litu lii?» ");
INSERT INTO iyx_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yiisu avutili kwaa bo: «Me ka nduru nifuulu beni, ndila nduru mosi. So beni diheeri me mvutu, tumake me ka sa ndeele beni mu ki litu me ndi mu uyiluu mandaa maa. ");
INSERT INTO iyx_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Na atsiduu Yowani mu ubootuu baata? Nziaambi oo ti baata?» Ka bo bakabisini matsimi ma bo na balelisini: «So divutili ti: “Nziaambi atsinduu nde”, nde sa afuulu bisi: “Ninha, mu ima beni diakoono usa Yowani imiini?” ");
INSERT INTO iyx_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ka so dileeli: “Baata batsinduu nde”, bisi diafwaana usa mayele mu baata ba, mundaa ti mu matsimi ma boosi ti Yowani ali mubili.» ");
INSERT INTO iyx_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ni mu buu bo bavutili kwaa Yiisu: «Bisi a diayaaba pe.» Yiisu avutili: «Aka, me ka, a nileele pe beni, mu ki litu me ndi mu uyiluu mandaa maa.» ");
INSERT INTO iyx_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yiisu abwileele: «Ima Beni dili mu utsimi mu ndaa yi? Baala limosi ali na baana boolo. Nde aleeli kwaa watsiomi: “Mwaana a me, yene yasala lolo ku tsiee a viinyi.” ");
INSERT INTO iyx_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nde avutili: “Ngori, me a natoono pe.” Ka nha mbisi, nde asobi matsimi na ayeni ku tsiee a viinyi. ");
INSERT INTO iyx_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Taayi aleeli ka bumosi kwaa mwaana wunu. Mwaana wu avutili: “Ee-e, tata me kuu niyene.” Ka nde a ayeni ku tsiee a viinyi pe. ");
INSERT INTO iyx_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Me nadifuuli: na mu bo baboolo, ayiluu litoono la taayi a nde?» Bo bavutili: «Watsiomi.» Ninha Yiisu aleeli kwaa bo: «Mu ngwanya me nadileeli: Batoli ba limaanda na bakaasa ba bapuupu sa baditswaamina mu ukoto mu Ipfumu kia Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yowani mubootii ayiri kwaa beni mu umweese beni kuulu ya libweeye, na beni a diamusiiri imiini pe. Ka batoli ba limaanda na bakaasa ba bapuupu bamusiiri imiini. So nha mbisi a umono mandaa maa, beni a diasobo ndiaatili a beni pe mu usa imiini mu nde.» ");
INSERT INTO iyx_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Diyuu tsaba kimi: Muutu mosi ali akunu tsiee a nde ya viinyi. Nde akayi yo kutso lipaanga. Nde ahayi idunu mu ukamina mala ma mbutu dia viinyi. Nde atuungi nzo yayiluu unaanguu mu mutele mundaa ukebe tsiee a viinyi. Nha mbisi, nde asiisi yo nha mioo mia basiali ba mu tsiee a viinyi, na nde ayeni mu midieenge.» ");
INSERT INTO iyx_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","«Taanga dia utolo mbutu bu diatoori, ngaa tsiee atsindii basiali ba nde kwaa basiali ba mu tsiee mu uyaholo ikuku kia nde mu bibatoli. ");
INSERT INTO iyx_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ka basiali ba mu tsiee bakaangi basiali ba nde. Ka dimono mamayilimi: bo bateti watsiomi, badusi waboolo, na wa mutata bamudusi mu mamanya. ");
INSERT INTO iyx_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ni mu buu, ngaa tsiee abwitsinduu basiali bakimi balutu litaanga la babali batsinduu tsiomi ku tsiee. Ka basiali ba mu tsiee bayilii ka bumosi kwaa bo. ");
INSERT INTO iyx_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nha tsieelele, nde wabatsindii mwaana a nde wabaala. Na nde akitsimi ti: “Bo sa baha likiinzi kwaa mwaana a me.” ");
INSERT INTO iyx_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ka basiali ba mu tsiee bu bamoni mwaana wabaala, bo balelisini nha kati a bo: “Mono mwaana wukaatolo mukobo! Tsweendani, diamudusu, na sa diholo mukobo a nde.” ");
INSERT INTO iyx_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ninha bamukaangi, bapali na nde mu tsiee, na bamudusi.» ");
INSERT INTO iyx_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yiisu afuuli: «Ka mu taanga di ngaa tsiee uyiri, ki mio nde uyiluu mu basiali ba mu tsiee a viinyi ba?» ");
INSERT INTO iyx_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bo bavutili kwaa nde: «Nde sa adusu badusi a baata ba, kwahele a umono bo ngebe. Nde sa aha tsiee kwaa basiali ba viinyi bakimi. Baa babuha kwaa nde mbutu di bo butolo mu tsiee mu taanga diafwaana.» ");
INSERT INTO iyx_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tumake Yiisu aleeli kwaa bo: «Beni keni a diataanga pe ma li mu uleele Mabasoonuu ma ngira? “Manya labumi batuungi, ni lo limaakituu ibwa kia nzo. Maa mamati kwaa Pfumu, kwaa bisi ili ndaa ya kinyi na ya ukimuu.”» ");
INSERT INTO iyx_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yiisu abwileele: «Ni mu buu, me nadileeli: Ipfumu kia Nziaambi, sa badimaasa kio. Sa baha kio kwaa ifuumbu ikimi ki ibutu mbutu mu kio.  ");
INSERT INTO iyx_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Wu ubwa nha yulu a manya li sa akosuu, na so manya li libwiilili muutu, lo sa li nyifili nde.» ");
INSERT INTO iyx_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Banguu ba bangaanga ba Nziaambi na Bafarisi bayuyi matsaba ma Yiisu na bayaabi ti nde mu bo akitsuu. ");
INSERT INTO iyx_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ni mu buu bo basiayi bwa ukaanga nde, ka bo bamoni boomo ba koongi yakitsimi ti Yiisu mubili ali. ");
INSERT INTO iyx_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yiisu abwisalila matsaba mu utsuu kwaa babakiyuu nde. Nde wabaleeli: ");
INSERT INTO iyx_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Mono bwafwaanina Ipfumu kia mayula: Mutini mosi ayilii ndaamba mundaa a makweele ma mwaana a nde wabaala. ");
INSERT INTO iyx_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nde atsindii basiali ba nde mu uta babatumusu mbili, paa bayadia ndaamba yii. Ka bo a batooni uyiri pe. ");
INSERT INTO iyx_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nde abwitsinduu basiali bakimi na wabahi tumini yi: “Dileele kwaa babatumusu: Ndaamba a me yamaayilimi mu taanga di, bangoombo ba me na biboori bia me biamaari bamaadusu. Mioosi miamaayilimi. Diyiri ku ndaamba a mukuungi a makweele ma mwaana a me!” ");
INSERT INTO iyx_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ka babatumusu a bamoni tsoongo pe na bayeni wa bo ku mandaa ma bo makimi: mosi ku tsiee a nde, wunu ku kaari a nde uta. ");
INSERT INTO iyx_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Babamosi bakaangi basiali ba mutini, babamweesi pasi na babadusi. ");
INSERT INTO iyx_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mutini akoli kesi ya mifuri. Nde atsindii masodaare ma nde mu uyadusu badusi a baata ba na unyeengese ngaanda a bo. ");
INSERT INTO iyx_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tumake nde aleeli kwaa basiali ba nde: “Ndaamba a mukuungi a makweele yamaayilimi, ka babakwata mbili a bafwaana pe mu udia yo. ");
INSERT INTO iyx_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ninha, diyene mu mafulu, na ditumusu boosi ba beni dituu umono, bayiri ku mukuungi.” ");
INSERT INTO iyx_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Basiali bayeni mu mafulu na bakukii boosi ba bo bamoni: bababi na bababwe. Ni mu buu, nzo a mukuungi yaluuli mu baata.» ");
INSERT INTO iyx_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Mutini akoti mu nzo a mukuungi, mu umono babatumusu ku mukuungi. Muu, nde amoni baala limosi lahele ulwaata ikutu kia mukuungi. ");
INSERT INTO iyx_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nde wamufuuli: “Nduu a me, we buni siiri mu ukoto kuni, kwahele na ikutu kia mukuungi?” Ka baala li a lavutili ndaa pe. ");
INSERT INTO iyx_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ninha mutini aleeli kwaa basiali ba nde: “Dikutu nde miili na mioo, na didumunu nde ku mbari, ku pimisi. Ni kuu nde akaalili na akaakweete mini.”» ");
INSERT INTO iyx_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ka Yiisu abwileele: «Babalayi bata mbili, ka babasoolo babakehe.» ");
INSERT INTO iyx_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ni mu buu, Bafarisi bayeni ku pfuundu mu umono bwa ukieese Yiisu mu mweete mu nduru yi bufuulu nde. ");
INSERT INTO iyx_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bo batsindii babamosi mu miyii mia bo, na binama bikimi mu kaba la Erode mu uleele kwaa Yiisu: «Muyiisi, bisi diayaaba ti we li mu uta ngwanya. We li mu uyiisi mu ngwanya yoosi, ndiaatili yi Nziaambi ali mu uloombo kwaa bisi. We ali na boomo a mandaa ma babamosi bali mu utsimi pe, mundaa ti, we a li mu usa lisoboso nha kati a baata pe. ");
INSERT INTO iyx_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ninha, leele bisi tsimi a we mu ndaa yi: mikele mia bisi mili mu uha muswa mu ufutu limaanda kwaa mutini Kayisari oo ti ngori?» ");
INSERT INTO iyx_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ka Yiisu ali ayaaba matsimi ma bo mamabi, ni mu buu nde wabaleeli: «Bangaa peluu, mu ima beni dili mu ulebuu me mweete? ");
INSERT INTO iyx_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Dimweese me mboongo di bali mu usalila mu ufutu limaanda.» Bo bamumweesi mukuti a mboongo mosi. ");
INSERT INTO iyx_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yiisu wabafuuli: «Kiinzi na kuumbu, bili mu mbata a mukuti wu, bia na bili?» ");
INSERT INTO iyx_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bo bavutili: «Bia mutini Kayisari». Ni mu buu Yiisu aleeli kwaa bo: «Aka, difutu kwaa Kayisari bili bia Kayisari, na difutu kwaa Nziaambi bili bia Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Bu bo bayuyi mvutu yii, bakimii kwalaa. Bo bamusiisi na bayeni. ");
INSERT INTO iyx_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mu kiina iluumbu kii, Basaduki babamosi bayiri kwaa Yiisu. Ni bo bali mu uyiisi ti, tsimbilili a babakwa yo pe. Bo bamufuuli, ");
INSERT INTO iyx_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","mbii bu: «Muyiisi, mono maleeli Mooso: “So baala likwiiri kwahele a ubutu baana, mwaana a nguu a nde afwaana ukweele mukwiili paa abutulu wakwa baana.” ");
INSERT INTO iyx_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ka nha kati a bisi ali na baana ba nguu tsaamba. Watsiomi akweeli, nde akwiiri kwahele a ubutu baana, na nde asiisi mukwiili a nde kwaa mwaana a nguu a nde. ");
INSERT INTO iyx_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Bumosi ka kwaa waboolo, tumake mu wamutata, natee mu boboosi tsaamba. ");
INSERT INTO iyx_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Nha mbisi a boboosi, mukaasa ka akwiiri. ");
INSERT INTO iyx_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mu iluumbu kia tsimbilili a babakwa, mu bo tsaamba nde mukari a na akaaba? Mundaa boosi bamukweeli.» ");
INSERT INTO iyx_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yiisu avutili kwaa bo: «Beni dili mu ufutu manyutu ma beni bameme, mundaa ti beni a diayaaba pe so Mabasoonuu ma ngira, so litu la Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Mundaa ti, mu taanga di babakwa bakaasiimbuu, babaala na bakaasa a bukwelesene pe, ka bo sa baba weti batumu ba Nziaambi mu mayula. ");
INSERT INTO iyx_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mundaa yatala litu la Nziaambi mu usiimbilili babakwa: beni kaala a diataanga pe ma Nziaambi aleeli kwaa beni? Nde aleeli: ");
INSERT INTO iyx_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Me Nziaambi a Abraami, Nziaambi a Isaki na Nziaambi a Yaakobi.”» Yiisu abwileele: «Beni dili mu uyiluu ummono ti, Nziaambi li Nziaambi a baata babali moonyi, ka a wa babakwa pe.» ");
INSERT INTO iyx_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Boosi babayuyi nde bakimii mu nziisili a nde. ");
INSERT INTO iyx_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mu taanga di Bafarisi bayuyi ti Yiisu adibii minwya mia Basaduki, bo bakukini mu uyene kwaa nde. ");
INSERT INTO iyx_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Na mosi mu bo, muyiisi a mikele, asiayi ulebuu nde mweete. Nde wamufuuli: ");
INSERT INTO iyx_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Muyiisi, ki mukele wavulu ndutu mu mikele mioosi?» ");
INSERT INTO iyx_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yiisu avutili kwaa nde: «“We afwaana utoono Pfumu Nziaambi a we mu mutimi a we woosi, mu muwuumu a we woosi na mu mayele ma we moosi.” ");
INSERT INTO iyx_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Wuu ni mukele watsiomi wavulu bunene na ndutu. ");
INSERT INTO iyx_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na mono mukele wa mioolo, wafwaanina na nde: “Toono mbaayi muutu weti we makulu.” ");
INSERT INTO iyx_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mikele mia Mooso mioosi na nziisili a mibili biakangama mu mikele mioolo mi.» ");
INSERT INTO iyx_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Bu Bafarisi bali bakukunu, Yiisu wabafuuli nduru yi: ");
INSERT INTO iyx_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Beni ima dili mu utsimi mu Mesiya? Nde mwaana a na ali?» Bo bavutili kwaa nde: «Nde li mwaana a mutini Daavidi.» ");
INSERT INTO iyx_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yiisu aleeli kwaa bo: «Ka mu ima, mu litu la Muheebili wa Ngira, Daavidi atuu uta Mesiya, “Pfumu”? Mundaa ti Daavidi aleele: ");
INSERT INTO iyx_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Pfumu Nziaambi aleele kwaa Pfumu a me: Yadiaala nha koo kia me kia babaala, me nibamuu mitaata mia we, mu uba ku tsini a miili mia we” ");
INSERT INTO iyx_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ka mbiiti Daavidi li mu uta nde “Pfumu”, buni Mesiya utuu uba mwaana a Daavidi?» ");
INSERT INTO iyx_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","A so mosi pe mu bo watuyi uvutulu nde ndaa so mosi. Umatuu iluumbu kii, muutu pe wabwibaa mifuri mia ufuulu nde manduru. ");
INSERT INTO iyx_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yiisu atsuyi kwaa koongi yoosi, na kwaa miyii mia nde, ");
INSERT INTO iyx_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Nde aleeli: «Bayiisi ba mikele na Bafarisi bali na mufunu wa ubiindili Mikele mia Mooso. ");
INSERT INTO iyx_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ni mu buu, beni diafwaana utumumu bo na ukuusu moosi ma bo buleele beni. Ka beni a diduku pe weti buli biyiluu bia bo, mundaa ti bo a bali mu usalila pe ma bo bali mu uyiisi. ");
INSERT INTO iyx_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bo bali mu ukutu mifunu mialeme, mili na pasi mu ubiti. Bo bali mu unaa mio nha yulu a bisambuu bia baata. Ka bo makulu bali mu ubisi ubumunu mio so mu muleembi, mu ubaasila bo mu unaangila mio. ");
INSERT INTO iyx_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Bo bali mu usa biyiluu bia bo bioosi, mu nzala ya umonuu nha kulu a baata. Ni mu buu, mu taanga dia likuundu, bo bakutu bipokolo nha mambuunzi, na mu mioo. Mandeengi ma biyungu bia bo mayiluu usaalila ku tsini. ");
INSERT INTO iyx_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bo batoono mambuu ma likiinzi mu mikuungi mia ndiilili, na mambata matsiomi mu manzo ma makutunu ma Bayuudayo. ");
INSERT INTO iyx_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bo batoono uyaka mabwe ma likiinzi mu kulu a mbari, na batoono ti baata bata bo “Muyiisi.” ");
INSERT INTO iyx_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ka beni, a disiingi pe ti bata beni “Muyiisi.” Mundaa ti beni boosi dili baana banguu na beni dili na muyiisi ndila mosi. ");
INSERT INTO iyx_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","A dita pe muutu so mosi nha tsini a toto “Taayi” a beni. Mundaa beni dili na Taayi ndila mosi, ni Taayi wuli ku yulu. ");
INSERT INTO iyx_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","A disiingi pe ka ti bata beni “Pfumu”, mundaa ti beni dili na pfumu ndila mosi, ni Mesiya. ");
INSERT INTO iyx_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Wavulu bunene mu beni, afwaana uba musiali a beni. ");
INSERT INTO iyx_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Wu unaanguu sa bakululu, ka wu ukuluu sa banaangila.» ");
INSERT INTO iyx_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Ngebe kwaa beni, bayiisi ba mikele na Bafarisi, bangaa peluu! Beni dili mu udibuu munywa a Ipfumu kia mayula kwaa baata. Beni bameme a dili mu ukoto muu pe, na a dili mu uha pe kuulu kwaa babatoono ukoto mu kio.»  ");
INSERT INTO iyx_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Ngebe kwaa beni, bayiisi ba mikele na Bafarisi, bangaa peluu! Beni dili mu upatila bioosi bia baa bakwiili, na beni dili mu usa makuundu mamala paa baata bamono beni. Ni mu buu sa badifuundusu mu iteesi kiavulu mifuri.» ");
INSERT INTO iyx_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Ngebe kwaa beni, bayiisi ba mikele na Bafarisi, bangaa peluu! Beni dili mu udieenge mu mambuu moosi nha tsini a toto, na nha yulu a mubu. Beni dili mu uyiluu buu, mu ubaa ndila muutu mosi wu ukiingili mayele. So beni dibayi nde, beni ukitisi nde mwaana a mbuungulu mu iteesi kialutu kia beni mbala dioolo.» ");
INSERT INTO iyx_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Ngebe kwaa beni, babiti bali bingima-ngimi! Beni dili mu uleele: “So muutu labi mukisi mu kuumbu a Nzo a Nziaambi, mukisi wuu a li na ndutu pe. Ka so nde labi mukisi mu woolo la mu Nzo a Nziaambi, muutu wuu afwaana ukiinzi mukisi wuu.” ");
INSERT INTO iyx_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Beni biwulu na bingima-ngimi! Ima kiavulu ndutu: woolo, oo ti Nzo a Nziaambi yili mu uha bungiri kwaa woolo? ");
INSERT INTO iyx_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Beni dili mu uleele ka: “So muutu labi mukisi mu diki la tsuyili a bungori, mukisi wuu a li na ndutu pe. Ka so nde labi mukisi mu bungori babali nha yulu a diki, muutu wuu afwaana ukiinzi mukisi wuu.” ");
INSERT INTO iyx_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Bingima-ngimi! Ima kiavulu ndutu: bungori, oo ti diki lili mu uha bungiri kwaa bungori? ");
INSERT INTO iyx_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ni mu buu wu ulaba mukisi mu diki, nde labi mukisi mu diki na mu bioosi bili nha yulu a lo. ");
INSERT INTO iyx_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Wu ulaba mukisi mu Nzo a Nziaambi, nde labi mukisi mu Nzo a Nziaambi na mu Nziaambi wadiaala mu yo. ");
INSERT INTO iyx_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Wu ulaba mukisi mu yulu, nde labi mukisi mu mbata a Ipfumu kia Nziaambi, na mu Nziaambi wadiaala nha yulu a kio.» ");
INSERT INTO iyx_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Ngebe kwaa beni bayiisi ba mikele na Bafarisi, bangaa peluu! Beni dili mu uha kwaa Nziaambi ikuku kia kuumi-kuumi mu makaya moosi mamuha biloo tsulu yimbwe. Ka beni umeengele nziisili yavulu ndutu mu mikele mia Nziaambi, weti libweeye, mutimi wa ngebe na unambita mu Nziaambi. Beni diafwaana usalila nziisili yii, kwahele a umeengele mikele mikimi. ");
INSERT INTO iyx_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Babiti babakwa misi! Beni uleke mala ma beni mu umaasa imbu, ka beni umini samo!» ");
INSERT INTO iyx_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Ngebe kwaa beni, Bayiisi ba mikele na Bafarisi, bangaa peluu! Beni dili mu uswaa mbasa na ikoombo ku mbari. Ka ku kati, bio bialuulu mu bii bi beni diayibi na mu manzala ma beni mamabi. ");
INSERT INTO iyx_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mufarisi wakwa misi! Kwatsieemese ku kati a mbasa, tumake ku mbari ka mbasa sa yitsieeme.» ");
INSERT INTO iyx_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Ngebe kwaa beni, Bayiisi ba mikele na Bafarisi, bangaa peluu! Beni diafwaanina na mangili mabakili liheembe, mali mu umonuu mamabwe ku mbari. Ka ku kati maluulu mu miyisi mia babakwa, na bioosi biabolo bia mupili na mupili. ");
INSERT INTO iyx_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Bumosi ka kwaa beni, ku mbari beni dili mu umweese kwaa baata boosi ti beni diakangama mu Nziaambi, ka ku kati beni dialuulu mu peluu na mu bubi.» ");
INSERT INTO iyx_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Ngebe kwaa beni, bayiisi ba mikele na Bafarisi, bangaa peluu! Beni dili mu utuungu mibili mangili mamabwe, beni dili mu uyolo mangili ma baata ba libweeye. ");
INSERT INTO iyx_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Beni dili mu uleele: “So bisi diali mu taanga dia bakaa ba bisi, bisi a diakeni pe uba pfuundu mosi na bo mu udusu mibili mia Nziaambi.” ");
INSERT INTO iyx_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Mu yii, beni dili mu uyaaba mu ibeni bameme ti beni dili baana ba baata babadusi mibili. ");
INSERT INTO iyx_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Aka, dihama, dimana mi bataayi ba beni babaandii!» ");
INSERT INTO iyx_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","«Beni bataari, ifuumbu kia bapili! Buni beni dituu ubata pfuundisi ya ku mbuungulu? ");
INSERT INTO iyx_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ni mu buu, diyuu: me sa tsinduu beni mibili, bangaa buyeri, na bayiisi ba mikele. Beni sa didusu babamosi, sa dikomo bana nha kuruwa. Bakimi beni sa diabatete bikoti mu manzo ma makutunu ma Bayuudayo, na beni sa diyoobingisi bo mu pasi ngaanda. ");
INSERT INTO iyx_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ni mu buu, beni sa diyaka tsieembili mundaa makili ma baata babahele na toono, matsiaamii nha tsi. Beni diabaandii udusu baata baa, umatuu mu taanga dia Aabeli muutu wa libweeye, natee mu nguu a ngaanga wa kuumbu Zakaria. Zakaria ali mwaana a Barakia, wu beni diadusi nha kati a mbuu ya ngira na diki la tsuyili a bungori. ");
INSERT INTO iyx_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mu ngwanya, me nadileeli: musieende wa ndusili a baata baa boosi sa abwa nha yulu a baata ba isieende kia lolo ki.» ");
INSERT INTO iyx_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Baata ba Yeruselemi, baata ba Yeruselemi! Beni ba dili mu udusu mibili, ba dili mu udusu mu mamanya baa ba Nziaambi ali mu utsinduu kwaa beni! Mbala kwe me nali na nzala a ukoso beni kutso me. Me nali na nzala ya ukoso bo kutso me, weti bu nguu a tsusu ali mu ukoso baana ba nde kutso mapapi ma nde. Ka beni a diatooni buu pe. ");
INSERT INTO iyx_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mono, nzo a beni yoosi sa babwoongolo. ");
INSERT INTO iyx_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ka me nileele kwaa beni: Umatuu mu taanga di, beni a dibwamono me pe, natee bu beni dileele: “Nyaala Nziaambi asieme wuli mu uyira mu kuumbu a Pfumu!”» ");
INSERT INTO iyx_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yiisu apali mu lipaanga la Nzo a Nziaambi. Bu nde akiyene, miyii mia nde miaswesii kwaa nde mu umweese nde bu batuungu Nzo a Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ni mu buu, nde wabaleeli: «Beni dili mu umono bi bioosi? Mu ngwanya me nadileeli: nha mbuu yi, a ibwasaala manya pe so limosi li basuusu nha yulu a li limosi. Bioosi sa batsala.» ");
INSERT INTO iyx_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yiisu ali adiaala ku mulaanda a Olive. Miyii mia nde miaswesii kwaa nde nha mbuu ya bo bake. Miyii miamufuuli: «Leele bisi mu ki taanga maa muyilimi, na ki iliimbi ikaamweese taanga dia nziriri a we, na dia manini a tsi.» ");
INSERT INTO iyx_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yiisu avutili kwaa bo: «Dikele muutu a ayafutu beni, ");
INSERT INTO iyx_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","mundaa ti baata babalayi sa bayiri mu kuumbu a me. Bo sa baleele: “Me ni Mesiya!” Na bo sa badiimbisi baata balaa. ");
INSERT INTO iyx_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Beni sa diyuu kele a midiingi mia nha bebele, na mamvuungu ma midiingi mia ku la. A diba na boomo pe, mundaa ti maa moosi mafwaana uyilimi, ka yii kaala a manini a tsi pe. ");
INSERT INTO iyx_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Baata ba tsi mosi sa badwaanisa baata ba tsi kimi, na ipfumu imosi sa idwaanisa ipfumu ikimi. Nzala sa yiba, na toto sa linyingini mu bitinini bialaa. ");
INSERT INTO iyx_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mandaa maa moosi sa maba weti mbaandila misoongo mia mbutili. ");
INSERT INTO iyx_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ninha, baata sa badikaanga paa badikwaamisa, na badidusu. Bifuumbu bioosi sa bibele beni mu toono a me.» ");
INSERT INTO iyx_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","«Mu taanga dii, baata babalayi sa babwiisi imiini kia bo. Bo sa bayaluu bambaayi ba bo, na bo sa babelesene bo na bo. ");
INSERT INTO iyx_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mibili mialaa mia pia sa mimonuu, na sa midiimbisi baata balaa. ");
INSERT INTO iyx_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mandaa mamabi sa mavululu, natee mu iteesi ki litoono la babalayi likoto mu ndeeyili. ");
INSERT INTO iyx_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ka wuu wu uba na mukonono natee manini, sa ayobuu. ");
INSERT INTO iyx_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ndaa Yimbwe yi, ya Ipfumu kia Nziaambi sa bayaabisa kwaa baata mu tsi yoosi, paa bamweese imbaangi kwaa bifuumbu bioosi. Na tumake manini a tsi sa iyira.» ");
INSERT INTO iyx_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Beni sa dimono wu bali mu uta “Bubi ba tsitsi bali mu ubee pfuuyili”, wu mubili Danieli atsuyi mu nde. Sa badiaasa nde nha mbuu ya ngira. — Nyaala ti wu utaanga ayuu bubwe mandaa maa. — ");
INSERT INTO iyx_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Mu taanga dii, babakaaba ku itinini kia Yuuda, nyaala ti babata ku yulu a milaanda. ");
INSERT INTO iyx_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wukaaba ku yulu a nzo a nde, anyaala usutuu mu uholo biloo bia nde bili mutso nzo. ");
INSERT INTO iyx_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Na wukaaba ku matsiee, anyaala uvutuu ku nzo a nde mu uyaholo iyungu kia nde.» ");
INSERT INTO iyx_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","«Ki pili a ngebe dikaaba mu biluumbu bii! Sa yiba pasi kwaa bakaasa bangaa mayimi na kwaa babakaanywiisi baana mabeene. ");
INSERT INTO iyx_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Dikuundu Nziaambi paa beni dihele ubata mu taanga dia ndoolo, so a buu pe mu iluumbu kia Saba! ");
INSERT INTO iyx_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Mundaa ti mu taanga dii, pasi sa diba diavulu tsitsi, yili kaala a yamonuu pe umatuu mu baandila tsi natee mu lolo li. Na ku mbisi pasi dia pili yii a dibwamonuu pe. ");
INSERT INTO iyx_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","So Nziaambi a aholi pe kesili, ya usuusu ti taanga dii diba dikusi, keni muutu so mosi aba utuu pe ubaanguu. Ka nde asuusi dio diba dikusi mundaa baa ba nde asoolo. ");
INSERT INTO iyx_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ninha, so muutu leeli beni: “Dimono, Mesiya nha ali!”, so a buu pe “nde kunaanga ali!”, a disa pe nde imiini. ");
INSERT INTO iyx_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mundaa ti Bamesia ba pia na mibili mia pia sa bamonuu. Bo sa bayiluu bimaanga bibinene na bilimbi, mundaa udiimbisi ka so ba Nziaambi asoolo, mbiiti butuu uba weti buu. ");
INSERT INTO iyx_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Diyuu! Me maakwalibili beni moonyi. ");
INSERT INTO iyx_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ka so badileeli: “Dimono, nde ku tsi ya tsata ali!” A diyene kuu pe. So a buu pe, mbii badileeli: “Dimono, nde nha asweeme!” A diyuu nde pe. ");
INSERT INTO iyx_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nzieri li mu usieremene ku yula, umatuu ku palili a taanga natee ku idiaama taanga. Ni buu ka Mwaana a muutu akaayira, nde sa unonuu kwaa boosi. ");
INSERT INTO iyx_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Nha yili nyama wakwa, ninha ka mileri mili mu ukukunu.» ");
INSERT INTO iyx_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Mbala mosi, nha mbisi a mapasi ma biluumbu bii, tari sa likituu pimisi na tsuungi a ubwaha mweeri a nde pe. Bambwelele sa babwa, na tuu dia mayula sa ditsaamu. ");
INSERT INTO iyx_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ninha, iliimbi kia Mwaana a muutu sa imonuu mu mayula. Na bifuumbu bia baata bioosi bia nha tsini a toto sa binyoongo. Bo sa bamono Mwaana a muutu li mu uyira na mifuri mia laa na buzitu, mu matuti ma yula. ");
INSERT INTO iyx_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mvuramvuru yinene sa basii, na nde sa atsinduu batumu ba nde ku matoso ma tsi mo mana. Bo sa bakukuu baa ba nde asoolo, umaatuu ku toso a yulu mosi natee ku toso a yulu yini.» ");
INSERT INTO iyx_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Diyuu nziisili yili mu uha muti wa mufike. Umatuu mu taanga di malimbi mali mu uyoo mu mapaki ma nde, na mbiiti makaya mamaapala, beni diayaaba ti mvulu a tsiomi ka bebele. ");
INSERT INTO iyx_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Bumosi ka, mu taanga di beni dikaamono maa moosi, diyaaba ti nziriri a Mwaana a Muutu yika bebele, yo ka nha munywa a nzo a beni. ");
INSERT INTO iyx_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mu ngwanya me nadileeli: baata ba isieende ki a bukwa pe boosi, tswaamina mandaa maa moosi muyilimi. ");
INSERT INTO iyx_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yula na tsi sa bilabuu, ka mandaa ma me a mulabuu so hoolo pe.» ");
INSERT INTO iyx_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Ka muutu pe wayaaba iluumbu so nguungu yi ndaa yii yikaayilimi: a so batumu ba Nziaambi mu mayula pe, na a so Mwaana pe, ka ndila Taayi ayaaba kio. ");
INSERT INTO iyx_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Mialabii mu taanga dia Nowa, sa milabuu bumosi ka mu nziriri a Mwaana a muutu. ");
INSERT INTO iyx_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Mu taanga dii, tswaamina nyaamba a maamba yinene, baata bakidia na bakinywa, bakikwelesene na bakikweelese baana ba bo. Bo bakiyiluu buu, natee iluumbu kiakoti Nowa mu nzaasa. ");
INSERT INTO iyx_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Bo a bayaabi ndaa so mosi pe, natee bu nyaamba a maamba yinene yayiri, na yabiti bo boosi. Ni buu ka bukaaba mu taanga di Mwaana a muutu akaayira.» ");
INSERT INTO iyx_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","«Mu babaala boolo bakaasala ku matsiee, mosi sa babiti, wunu sa basiisi. ");
INSERT INTO iyx_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Mu bakaasa boolo sa bakaanyii mbutu nha yulu a manya, mosi sa babiti, wunu sa basiisi. ");
INSERT INTO iyx_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ni mu buu, diba likanda! Mundaa ti beni a diyaaba pe ki iluumbu Pfumu a beni akaayira.» ");
INSERT INTO iyx_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","«Diyiluu uyuu ndaa yi! So pfumu a nzo ali ayaaba mu ki taanga mu butsuu, muyibi afwaana uyira, nde akeni uba likanda. Nde a akeni uha nde taanga dia ukoto mu nzo a nde pe. ");
INSERT INTO iyx_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ni mu buu, diyilimi beni ka, mundaa ti Mwaana a muutu sa ayira mu taanga di beni diahele uyaaba.» ");
INSERT INTO iyx_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Ki musiali wuli wahama na wa mayele? Dimono mosi wu, wu pfumu a nde aha isala kia ubuungulu basiali babamosi mu uha bo bia udia mu taanga diafwaana. ");
INSERT INTO iyx_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kinyi kwaa musiali wuu, mbiiti mu taanga di pfumu uyiravutuu ku nzo a nde, nde yibaasa nde kutso isala kii. ");
INSERT INTO iyx_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ngwanya me nadileeli: pfumu sa aha nde isala wa ukebe biloo bia nde bioosi. ");
INSERT INTO iyx_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ka mbiiti nde li musiali wu mubi, nde sa aleele kutso mutimi a nde: “Pfumu a me a ubwayiri pe.” ");
INSERT INTO iyx_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Nha mbisi a nhaa, musiali wuu sa abaanduu mu utete bambaayi ba nde ba isala, nde sa adia na unywa na bakoli ba mala. ");
INSERT INTO iyx_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ee-e, pfumu sa ayiri avutuu mu iluumbu ki musiali ali mu uhele ukebe nde, na mu taanga di nde ahele uyaaba. ");
INSERT INTO iyx_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nde sa asieembe musiali wuu na sa abingi nde. Pfumu sa wamuha tsieembili mosi na bangaa peluu, kuu ku bali mu ulili na ukweete mini.» ");
INSERT INTO iyx_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Ipfumu kia mayula kiafwaanina na miayilii banduumbu kuumi bamosi. Bo baholi miindi mia bo, na bayeni mu ubwaana mufuru a makweele. ");
INSERT INTO iyx_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bataana mu bo ali biwulu, na bataana ali na mayele. ");
INSERT INTO iyx_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Babali biwulu baholi miindi mia bo, ka a babiti maari makimi pe. ");
INSERT INTO iyx_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ka babali na mayele babiti miindi mia bo, na bibasa bia maari. ");
INSERT INTO iyx_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ka mono, mufuru a makweele akisa idii mu uyiri. Bu bo bakikebe nde, tolo lakoli banduumbu ba, na bo boosi balaari.» ");
INSERT INTO iyx_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«Mu kati-a-kati a butsuu, ndaa yayuyini: “Mufuru a makweele ndiowu! Dipala ku ubwaana nde!” ");
INSERT INTO iyx_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ni mu buu, banduumbu kuumi boosi baa basiimbii, na babaandii uyiluu miindi mia bo. ");
INSERT INTO iyx_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Banduumbu ba biwulu baloombi kwaa banduumbu ba mayele: “Diha bisi mwaana maari mu mama beni, mundaa ti miindi mia bisi miaka mu udimi.” ");
INSERT INTO iyx_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Banduumbu ba mayele bavutili: “Ngori, ka maari a mukuu mu beni na mu bisi pe. Aba bubwe beni diyene kwaa bayalii a maari, mu usuumbu mama beni.” ");
INSERT INTO iyx_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ninha, banduumbu ba biwulu bayeni ku usuumbu maari. Ka mu diina taanga dii, mufuru a makweele ayiri. Banduumbu bataana babali bayiluu miindi mia bo, bakoti na nde mutso nzo a mukuungi a makweele. Nha mbisi, muutu ni adibii munywa a nzo mu tsiafi. ");
INSERT INTO iyx_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tumake, banduumbu ba biwulu bayiri na baloyi: “Pfumu! Pfumu! Dibili bisi munywa a nzo!” ");
INSERT INTO iyx_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ka mufuru a makweele avutili: “Mu ngwanya me nadileeli: me a nayaaba beni pe.”» ");
INSERT INTO iyx_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yiisu abwileele: « Ni mu buu diba likanda, mundaa ti beni a diayaaba pe iluumbu na so nguungu yi Mwaana a muutu akaayiri.» ");
INSERT INTO iyx_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Sa buba weti mu muutu wakeni uyene ku midieenge. Tswaamina nde uyene, ateeri basiali ba nde mbili na wabahi busini ba nde mu ukebe. ");
INSERT INTO iyx_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Nde aheeri kwaa mosi makama mataana ma mikuti mia woolo, kwaa wunu makama moolo, kwaa wa mutata kama: muutu-muutu nha tsitsi a mifuri mia nde. Tumake nde ayeni. ");
INSERT INTO iyx_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Musiali wabayi makama mataana ma mikuti mia woolo, ayeni mawasa-mawasa mu uta kaari mu mboongo dii. Nha mbisi a uta kaari, nde abwibaa makama mataana makimi ma mikuti mia woolo. ");
INSERT INTO iyx_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Wabayi makama moolo ma mikuti, ayilii ka bumosi. Nde ka abwibaa makama moolo makimi ma mikuti. ");
INSERT INTO iyx_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ka wabayi kama mosi ya mikuti, ayeni, ahayi idunu na mu tso kio, nde ayiswee mboongo di Pfumu a nde ahi nde.» ");
INSERT INTO iyx_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Nha mbisi a taanga dialaa, Pfumu a basiali ba ayiravutuu, abaandii mu utaanga busini ba nde na bo. ");
INSERT INTO iyx_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Wabayi makama mataana ma mikuti mia woolo, aswesii na amweesi makama mataana makimi ma mikuti, aleeli: “Pfumu, we ali aha me makama mataana ma mikuti mia woolo. Makama mataana makimi ma me mbwibaa, mono mo.” ");
INSERT INTO iyx_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Pfumu a nde wamuleeli: “Bubwe! We musiali wu mubwe na wahama. We monii wahama mu biloo biahele na ndutu, ka me saha we mu ukebe bii bili na ndutu yalaa. Yiri we yaanga na me.” ");
INSERT INTO iyx_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Nha mbisi, musiali wabayi makama moolo ma mikuti aswesii na aleeli: “Pfumu, we ali aha me makama moolo ma mikuti mia woolo. Makama moolo makimi ma me mbayi, mono mo.” ");
INSERT INTO iyx_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Pfumu a nde wamuleeli: “Bubwe! We musiali wu mubwe na wahama. We monii wahama mu biloo biahele na ndutu, ka me saha we mu ukebe bii bili na ndutu yalaa. Yiri we yaanga na me.”» ");
INSERT INTO iyx_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«Nha tsieelele, musiali wabayi kama mosi ya mikuti, aswesii na aleeli: “Pfumu, me ali nayaaba ti we muutu wuli na mutimi wu munono. We ukukuu mbutu nha we ahele unyasila, we utolo mbutu nha we ahele ukunu. ");
INSERT INTO iyx_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Me naba na boomo ba we, na me nayaswee mboongo dia we ku tsini a toto. Ninha mono dio.” ");
INSERT INTO iyx_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Pfumu a nde wamuvutili: “Musiali wu mubi, mubolo! We ali ayaaba ti me nibaakukuu mbutu nha nahele unyasila, nibaatolo mbutu nha me nahele ukunu? ");
INSERT INTO iyx_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ka we ali utuu usuusu mboongo dia me ku nzo a mboongo. Na mu taanga di me niyiri avutuu, keni me holi mboongo dia me na binaa nha yulu.” ");
INSERT INTO iyx_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ni mu buu, pfumu aleeli kwaa basiali bakimi: “Dipatila kama a mikuti mia woolo mili kwaa nde, na diha mio kwaa wuli na fuundu la mikuti. ");
INSERT INTO iyx_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Mundaa ti, pasi wuli na iloo sa abwabaa bikimi, nde sa aba na bio biavululu. Ka kwaa wahele na iloo, sa bamumaasila ka so mwaana kiasaala kwaa nde. ");
INSERT INTO iyx_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mu yatala musiali wahele na ndutu wu, diamudumunu ku pimisi dia ku mbari, kuu ku bali mu ulili na ukweete mini.”» ");
INSERT INTO iyx_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Mu taanga di Mwaana a muutu akaayira mu buzitu ba nde, itwaari na batumu ba Nziaambi boosi, nde sa adiaala nha yulu a mbata a nde ya butini. ");
INSERT INTO iyx_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bifuumbu bioosi bia nha tsini a toto sa bikukunu nha kulu a nde. Nde sa akabala baata babamosi peembi yi, na bana peembi yimosi. Nde sa akabala bo, weti bu mukebi a biboori ubaakabala bindombo na bataba. ");
INSERT INTO iyx_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nde sa asuusu bindombo nha koo kia nde kia babaala, na bataba nha koo kia nde kia bakaasa. ");
INSERT INTO iyx_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ni mu buu, mutini sa aleele kwaa ba buba nha koo kia nde kia babaala: “Yirani, beni ba Taayi a me asieme, na ditolo mukobo a Ipfumu ki bataasila beni umatuu mu mbaandila tsi. Mukobo wuu li wa beni, mundaa ti: ");
INSERT INTO iyx_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Me nali na nzala, beni diahi me bia udia. Me nali na nyooto, beni diahi me maamba ma unywa. Me nali mweenyi, beni diayaki me kwaa beni. ");
INSERT INTO iyx_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Me nali pene, beni dialwaatisi me. Me nali na ubeele, beni diabuyi me. Me nali mu perese, beni diayimono me.” ");
INSERT INTO iyx_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ni mu buu, babayiluu litoono la Nziaambi sa bavutulu: “Pfumu, ki taanga bisi diamoni we na nzala, ninha diahi we bia udia? So a buu pe, ki taanga we ali na nyooto, ninha diahi we maamba ma unywa? ");
INSERT INTO iyx_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ki taanga we ali mweenyi, ninha diayaki we mu manzo ma bisi? So a buu pe, ki taanga we ali pene, ninha dialwaatisi we? ");
INSERT INTO iyx_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ki taanga bisi diamoni we na ubeele, so a buu pe mu perese, ninha diayimono we?” ");
INSERT INTO iyx_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mutini sa avutulu kwaa bo: “Mu ngwanya me nadileeli: pasi taanga di beni diayilii mandaa maa, kwaa mosi mu baana banguu ba me bavulu mu bungebe ba, ni kwaa me beni diayilii buu.”» ");
INSERT INTO iyx_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Tumake, mutini sa aleele kwaa babali nha koo kia nde kia bakaasa: “Takwaani la na me, beni babasibi! Yenani ku mbaa ya bilimi na bilimi yi bayilii mu ndaa Saatina na batumu ba nde. Yenani kuu, mundaa ti: ");
INSERT INTO iyx_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Me nali na nzala, ka beni a diahi me bia udia pe. Me nali na nyooto, ka beni a diahi me maamba ma unywa pe. ");
INSERT INTO iyx_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Me nali mweenyi, ka beni a diayaki me kwaa beni pe. Me nali pene, ka beni a dialwaatisi me pe. Me nali na ubeele na me nali mu perese, ka beni a diahi me libaasila pe.” ");
INSERT INTO iyx_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ni mu buu bo sa bavutulu kwaa nde: “Pfumu, ki taanga bisi diamoni we ali: na nzala, na so nyooto, mweenyi, pene, na ubeele, so a buu pe we ali mu perese, na bisi a diabaasili pe we?” ");
INSERT INTO iyx_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Mutini sa uvutulu kwaa bo: “Mu ngwanya, me nadileeli: Mataanga moosi ma beni diahele uyiluu mandaa maa kwaa mosi mu babavulu bungebe ba, ni kwaa me beni diahele uyiluu buu.” ");
INSERT INTO iyx_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Na bo sa bayene ku tsieembili ya bilimi na bilimi, ka bunu babanambita mu Nziaambi sa bayene ku moonyi wu uhele uwa.» ");
INSERT INTO iyx_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Mu taanga di Yiisu amani uha nziisili yi yoosi, nde aleeli kwaa miyii mia nde: ");
INSERT INTO iyx_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Beni diayaaba ti biluumbu bioolo bisiaali tswaamini a mukuungi a Paaka. Ni mu iluumbu kii, bakaayeelele Mwaana a muutu paa bamukomo nha kuruwa.» ");
INSERT INTO iyx_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ninha, banguu ba bangaanga ba Nziaambi na bakuutu ba Bayuudayo bakukini kutso lipaanga la nguu a bangaanga ba Nziaambi, wa kuumbu Kayifa. ");
INSERT INTO iyx_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Mu itwaari, bo baholi kesili ya ukaanga Yiisu mu tsweeyi na udusu nde. ");
INSERT INTO iyx_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Bo bakileele: «Bisa-beni a dikaangani pe nde mu taanga dia mukuungi, leeti baata sa batemene mu utulu bikiindi.» ");
INSERT INTO iyx_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yiisu ali ku Betania ku nzo a Simooni, mubeeri a bwaari. ");
INSERT INTO iyx_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Bu nde ali kuu, mukaasa mosi aswesii kwaa nde na ibasa kia kuumbu alabaatere, kiali kialuulu mu mananaasa ma tala yalaa. Nde ayitili maari maa nha yulu a mutswe a Yiisu, mu taanga di nde ali nha meese. ");
INSERT INTO iyx_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Bu miyii miamoni buu, mio miabayi kesi na bafuuli: «Mu ima nde ali mu usa mananaasa ma pfunu? ");
INSERT INTO iyx_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Aba utuu uyaluu mananaasa ma mu tala yalaa, na uha mboongo kwaa bawele!» ");
INSERT INTO iyx_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yiisu ayaabi ma bo bakitsuu na wabaleeli: «Mu ima beni dili mu ukwaamisa mukaasa wu? Ka nde yilii ndaa yimbwe mu me. ");
INSERT INTO iyx_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Taanga dioosi, bawele sa baba itwaari na beni. Ka me, a niba pe itwaari na beni taanga dioosi. ");
INSERT INTO iyx_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nde maayitili mananaasa ma mu nyutu a me, mundaa uyiluu ndiili a me. ");
INSERT INTO iyx_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mu ngwanya me nadileeli: Mambuu moosi ma buyaabisa Ndaa Yimbwe yi, mu tsi yoosi, sa batsuu mu ma mukaasa wu ayilii. Mu taanga dii, sa balibili moonyi mu ma nde ayilii mu me.» ");
INSERT INTO iyx_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ni mu buu, mosi mu miyii kuumi na mioolo wa kuumbu Yuuda Isikarioti, ayimono banguu ba bangaanga ba Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Wabaleeli: «Ima beni dikaaha me so me nadiyeelili Yiisu?» Bo bataangi maku matata ma mikuti mia mboongo na bahi nde mio. ");
INSERT INTO iyx_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Umatuu mu taanga dii, Yuuda abaandii usaa makuulu ma uyeelele Yiisu kwaa bo. ");
INSERT INTO iyx_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Mu iluumbu kia tsiomi kia mukuungi a mapa mahele na liviiri, miyii miayifuulu kwaa Yiisu: «Kuni we tooni ti bisi diyiluu we biloo bia Paaka?» ");
INSERT INTO iyx_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yiisu wabavutili: «Diyene ku ngaanda kwaa muutu mosi, na dileele nde: “Muyiisi maleele: Taanga dia me dimaato. Ku nzo a we me ni yadia biloo bia Paaka na miyii mia me.”» ");
INSERT INTO iyx_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Miyii miayilii ma Yiisu atumi bo, na bayilii biloo bia Paaka. ");
INSERT INTO iyx_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Taanga a tsitsii bu diatoori, Yiisu adiaali nha meese, itwaari na miyii mia nde kuumi na mioolo. ");
INSERT INTO iyx_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mu taanga di bo bakidia, Yiisu wabaleeli: «Mu ngwanya me nadileeli: mosi mu beni sa ayeelele me.» ");
INSERT INTO iyx_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Miyii miakoti mu ngebe dialaa, na babaandii mu ufuulu nde mosi mosi: «A me pe Pfumu?» ");
INSERT INTO iyx_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yiisu avutili: «Wuu watsubu lipa la nde na me, mu ikoombo, ni nde kaayeelele me. ");
INSERT INTO iyx_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwaana a muutu sa akwa weti bu Mabasonuu ma ngira mali mu uyaabisa mundaa nde. Ka ki pili a ngebe kwaa muutu wu uyeelele Mwaana a muutu! Ali yavulu bubwe kwaa muutu wuu mu uhele ubutuu.» ");
INSERT INTO iyx_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuuda, wakiyeelele nde atsuyi na afuuli: «Muyiisi, ni me?» Yiisu wamuvutili: «We leeli buu.» ");
INSERT INTO iyx_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mu taanga dia udia, Yiisu aholi lipa. Bu amani uvutulu matoondo kwaa Nziaambi, nde abukili lo na ahi lo kwaa miyii mia nde. Nde wabaleeli: «Diholo na didia, yiinayi ni nyutu a me.» ");
INSERT INTO iyx_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nha mbisi nde aholi mbasa a viinyi. Bu amani uvutulu matoondo kwaa Nziaambi, nde wabaheeri yo. Aleeli: «Dinywa yo beni boosi. ");
INSERT INTO iyx_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ka ma ni makili ma me, makili mali mu uhamisa lilasina la Nziaambi, na matsiaamii mu baata babalayi. Mo matsiaamii mundaa nyaalili a masumu ma bo. ");
INSERT INTO iyx_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Me nileele kwaa beni: Umatuu mu taanga di, me a ni bwanywa mala ma viinyi ma pe. Me a ni bwanywa mo pe, natee iluumbu ki me ni nywa mamanyatii, itwaari na beni, mu Ipfumu kia Taayi a me.» ");
INSERT INTO iyx_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nha mbisi, bo bayimbi mikuunga mia mukuungi, tumake bo bayeni ku Mulaanda a Olive. ");
INSERT INTO iyx_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ninha, Yiisu aleeli kwaa miyii mia nde: «Butsuu ba beni boosi sa dibwoongolo me. Ka dili mu utaanga mu Mabasoonuu ma ngira: “Me sa dusu mukebi, na mukaanga a bindombo sa atsaamuu na uyene butsa-butsa.”» ");
INSERT INTO iyx_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ka Yiisu abwileele: «Mu taanga di me kaasimbuu mu babakwa, me sa tswaamina beni ku Ngalili.» ");
INSERT INTO iyx_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peetero avutili, aleeli kwaa nde: «So bana boosi busiisi we, me a ni siisi we so hoolo pe.» ");
INSERT INTO iyx_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yiisu avutili kwaa nde: «Mu ngwanya me nileele kwaa we: mu butsuu ba, tswaamina tsutsu ukookolo, we sa tunu mbala tata.» ");
INSERT INTO iyx_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peetero aleeli kwaa nde: «So aba ti me nafwaana ukwa itwaari na we, me utuu pe utunu we, so bwafwaana, me utuu ukwa na we!» Na miyii mini mioosi ka mialeeli bumosi. ");
INSERT INTO iyx_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ni mu buu, Yiisu atoori na miyii mia nde ku mbuu mosi ya kuumbu Ngetesemane. Nde aleeli kwaa bo: «Diaalani nha, mu taanga di niyene me kunaanga mu uyakuundu.» ");
INSERT INTO iyx_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tumake, nde abiti Peetero na baana ba Zebedaayi bo baboolo. Nde abaandii umono ngebe na boomo. ");
INSERT INTO iyx_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ninha nde wabaleeli: «Mutimi a me aluulu mu ngebe mundaa likwa. Diba nha, na diba likanda itwaari na me.» ");
INSERT INTO iyx_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nde ayeni mwaana taka, nde abwiisi kiinzi mu tsini, na akuundi mu mandaa ma: «Taayi a me, so butuu uba, takala la na me mbasa ya mapasi yi. Ka a bu li litoono la me pe, ka bu we tooni.» ");
INSERT INTO iyx_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nha mbisi, nde ayiri avutuu kwaa miyii mitata mi, na wababaasi bala tolo. Nde aleeli kwaa Peetero: «Beni diakoono uba likanda itwaari na me so mu nguungu mosi? ");
INSERT INTO iyx_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Diba likanda, na dikuundu paa dihele ubwa mu mapuusu. Mutimi a muutu li na nzala yalaa ya uyiluu mamabwe, ka musunyi a nde adee.» ");
INSERT INTO iyx_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nde abwitakuu mu mbala ya dioolo, na akuundi mu mandaa ma: «Taayi a me, so a butuu pe uba ti mbasa yi yitakuu na me, kwahele ti me nywa yo, nyaala litoono la we liyilima!» ");
INSERT INTO iyx_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nde abwiyiri avutuu kwaa miyii mia nde, na wabamoni bala tolo, mundaa ti misi mia bo miali miamaaleme mu tolo. ");
INSERT INTO iyx_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yiisu abwisiisi bo, atakii na akuundi mu mbala ya mutata, mu mandaa ma nde akwikuundu tsiomi. ");
INSERT INTO iyx_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tumake, nde ayiri avutuu kwaa miyii na wabaleeli: «Beni dikeni matolo na dili mu uwuumu? Mu taanga di, nguungu yamaato, na Mwaana a muutu sa bamuyeelele nha mioo mia bangaa masumu. ");
INSERT INTO iyx_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ditemene, tsweendani! Dimono, muutu wu uyeelele me kwaa bo, nha ali!» ");
INSERT INTO iyx_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yiisu ali keni mu utsuu, mu taanga di Yuuda ayiri. Nde ali mosi mu miyii kuumi na mioolo. Nde ayiri itwaari na koongi yineni ya baata, babali na mikasa na mamboondi. Banguu ba bangaanga ba Nziaambi na bakuutu ba Bayuudayo babatsindii. ");
INSERT INTO iyx_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yuuda, muyeelili a Yiisu kwaa bo, wabaheeri iliimbi ki nde akaasalila mu taanga dii: «Baala li me kaanyumbutu, ni muutu wu beni dili mu usaa. Diamukaanga.» ");
INSERT INTO iyx_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Mawasa-mawasa Yuuda aswesii kwaa Yiisu, wamuleeli: «Bwee, Muyiisi!» Na wamunyumbuti. ");
INSERT INTO iyx_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yiisu avutili kwaa nde: «Nduu a me, yi we yiri mu uyiluu, yiluu yo mawasa.» Ninha babamosi baswesii, baholi Yiisu mu koo na bamukaangi. ");
INSERT INTO iyx_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mosi mu babali na Yiisu apalisi mukasa a nde, ateti musiali a nguu a bangaanga ba Nziaambi. Nde akesi litswi la musiali wuu. ");
INSERT INTO iyx_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ninha, Yiisu aleeli kwaa nde: «Vutulu mukasa a we nha mbuu a nde, mundaa ti boosi ba busalila mukasa mu udusu bana, nde ka sa badusu mu mukasa. ");
INSERT INTO iyx_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","We a ayaaba pe ti me utuu uloombo libaasila kwaa Taayi a me? So me ndoombi buu, mawasa-mawasa, nde utuu utsinduu me mikaanga mia batumu ba Nziaambi mialutu iteesi kia kuumi na mioolo. ");
INSERT INTO iyx_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ka, mbii buu, buni Mabasonuu ma ngira mutuu uyene tsitsi? Mo mali mu uleele ti, ni buu ka mandaa mafwaana uyilimi.» ");
INSERT INTO iyx_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tumake, Yiisu aleeli kwaa koongi: «Beni aba na nzala uyiri na mikasa na mamboondi mu ukaanga me. Me ihaangi ndi? Biluumbu bioosi, me nakidiaala mu Nzo a Nziaambi mu uyiisi, ka bunu, beni a diakaangi me pe. ");
INSERT INTO iyx_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ka ma moosi mamaayilimi paa masonuu mibili mia Nziaambi, mayene tsitsi.» Mawasa-mawasa, miyii mia nde miamusiisi na miabati. ");
INSERT INTO iyx_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Babakaangi Yiisu bamubiti kwaa Kayifa, nguu a bangaanga ba Nziaambi. Ni kuu kwali kwakukunu bayiisi ba mikele na bakuutu ba Bayuudayo. ");
INSERT INTO iyx_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Peetero akiduku Yiisu nha lilala, natee ku lipaanga la Kayifa, nguu a ngaanga Nziaambi. Nde akoti ku kati a lipaanga, na adiaali na bakebi mu umono buni ndaa yisuku. ");
INSERT INTO iyx_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Banguu ba bangaanga ba Nziaambi na Pfuundu a bakuutu kia Bayuudayo yioosi, bakisaa toono so ya pia mu Yiisu, paa bamuha tsieembili ya likwa. ");
INSERT INTO iyx_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ka a babayi toono pe, so bu baata babalayi bayiri, na mifuundu mia pia mu nyutu a nde. Nha tsieelele, baata boolo bayipala. ");
INSERT INTO iyx_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Baleeli: «Muutu wu aleeli: “Me utuu utsala Nzo a Nziaambi, na ubwatuungu yo mu biluumbu bitata.”» ");
INSERT INTO iyx_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kayifa nguu a ngaanga a Nziaambi atemini, na aleeli kwaa Yiisu: «We a li na ya uvutulu pe, mu mi baata ba bali mu uleele mu we?» ");
INSERT INTO iyx_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ka Yiisu a atsuyi ndaa pe. Ni mu buu, Kayifa nguu a ngaanga a Nziaambi aleeli kwaa nde: «Mu kuumbu a Nziaambi wa moonyi, me ni loombo kwaa we mu uvutulu bisi mvutu, na ulaba mukisi: we ni Mesiya, Mwaana a Nziaambi?» ");
INSERT INTO iyx_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yiisu avutili kwaa nde: «We leeli buu. Ka me nadileeli: Umatuu mu taanga di, beni sa dimono Mwaana a muutu adiaala nha koo kia babaala, kia Nziaambi Ngaa Litu. Na beni sa diamumono ka, li mu uyira mu matuti ma yula.» ");
INSERT INTO iyx_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ni mu buu, Kayifa nguu a ngaanga a Nziaambi akaki bikutu bia nde, na aleeli: «Nde maatuu Nziaambi! A dibwisaala na tsata a bambaangi pe! Beni dimaayuu itari ki nde atuyi Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Beni ima ditsimi mu ndaa yii?» Bo bavutili: «Nde li na matoono, na afwaana uholo tsieembili ya likwa.» ");
INSERT INTO iyx_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tumake bo bamutswiili mate ku busu, na bamuteti bikaba. Babamosi bamuteti mambata, ");
INSERT INTO iyx_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","baleeli: «Bili! We wuli Mesiya, leele bisi na teti we!» ");
INSERT INTO iyx_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Peetero ali adiaala kutso lipaanga lii. Musiali mosi wa mukaasa, aswesii kwaa nde na wamuleeli: «We ka, we beeri itwaari na Yiisu, musi Ngalili wuu.» ");
INSERT INTO iyx_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ka nde atuni nha kulu a baata boosi, aleeli: «Me a nayaaba pe mi we tooni uleele.» ");
INSERT INTO iyx_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tumake, nde ayeni ku peembi a idibuu kia lipaanga. Musiali mukimi wa mukaasa wamumoni, na aleeli kwaa babali nha mbuu yii: «Wuunawu ka beeri na Yiisu musi Nazareti.» ");
INSERT INTO iyx_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Na Peetero abwitunu bu aleeli: «Me ni laba mukisi, me a nayaaba muutu wu pe!» ");
INSERT INTO iyx_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nha mbisi a taanga hoolo, babali nhaa baswesii kwaa Peetero, na bamuleeli: «Ngwanya, we ka li mosi mu bo, mundaa ti tsuuhili a we yili mu umweese ku we amata.» ");
INSERT INTO iyx_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ninha Peetero aloyi: «So me futi pia, nyaala Nziaambi asieembe me! Me ndabi mukisi, me a nayaaba pe muutu wu!» Mu dii na taanga dii, tsutsu akookili. ");
INSERT INTO iyx_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Peetero alibili moonyi, mu ndaa yaleeli nde Yiisu: «Tswaamina tsutsu ukookolo, we sa tunu me mbala tata.» Nde apali ku mbari na alili kwalaa. ");
INSERT INTO iyx_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mu ngwaali a ngwaali, banguu ba bangaanga ba Nziaambi boosi, na bakuutu ba ifuumbu kia Bayuudayo, mu itwaari baholi kesili ya udusu Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bo batumi bakutu nde bibolo, bamubiti na bamuyeelili kwaa Pilato, mutumi a itinini. ");
INSERT INTO iyx_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yuuda wayeelili Yiisu, ayuyi ti bamaakese Yiisu tsieembili ya likwa. Nde amoni pasi mu mutimi, ni mu buu, nde ayivutulu maku matata ma mikuti mia mboongo, kwaa banguu ba bangaanga ba Nziaambi, na bakuutu ba Bayuudayo. ");
INSERT INTO iyx_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Nde wabaleeli: «Me nzilii masumu, me maayeelele muutu wahele na toono ku likwa!» Ka bo bamuvutili: «Bisi mii uyaaba pe! Mii miatala we!» ");
INSERT INTO iyx_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yuuda abumi mboongo mutso Nzo a Nziaambi na apali. Tumake ayilele mu swe. ");
INSERT INTO iyx_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Banguu ba bangaanga ba Nziaambi batoli mboongo, baleeli: «Mikele mia bisi a mili mu uha pe muswa, mu ulooso mboongo di mu ikebili kia mboongo kia Nzo a Nziaambi, mundaa ti dio dili mboongo dia makili.» ");
INSERT INTO iyx_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Bu bamani uyuhusunu mu mboongo dii, bo basuumbi tsiee a mumieeni a tumu, paa iba manyimi ma bieenyi. ");
INSERT INTO iyx_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ni mu ndaa yii, bali mu uta tsiee yii «tsiee ya makili», natee mu iluumbu kia lolo. ");
INSERT INTO iyx_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ni mu buu, mamaleeli mubili Yelemiya mayeni tsitsi: «Bo baholi maku matata ma mikuti mia mboongo, tala yi baana ba Iseraeli bali bayesene mu nde. ");
INSERT INTO iyx_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Bo basialili mboongo dii, mu usuumbu tsiee a mumieeni a tumu, weti bu Pfumu aheeri tumini kwaa me.» ");
INSERT INTO iyx_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yiisu atemini nha kulu a mutumi Pilato, wafuuli nde manduru: «We ni mutini a Bayuudayo?» Yiisu avutili: «We leeli yo.» ");
INSERT INTO iyx_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tumake, banguu ba bangaanga ba Nziaambi, na bakuutu ba Bayuudayo bafuundi nde. Ka so bu bo bakifuundu nde, Yiisu a avutili ndaa pe. ");
INSERT INTO iyx_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ni mu buu, Pilato aleeli kwaa nde: «We a li mu uyuu pe mifuundu mioosi mi bo bali mu usa we?» ");
INSERT INTO iyx_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ka Yiisu a avutili nde so mu ndaa so mosi pe, na Pilato akimii kwalaa. ");
INSERT INTO iyx_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Mu pasi mukuungi a Paaka, mutumi ali na ipfu kia uha bunyanga, kwaa muutu mosi mu babali mu perese, wu baata ali batoono. ");
INSERT INTO iyx_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ka bunu, mu biluumbu bii ali na muutu mosi wali mu perese wayiluu uyabina, kuumbu a nde Yiisu Barabase. ");
INSERT INTO iyx_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ni mu buu, Pilato afuuli Baata ba bali bakukunu: «Beni na ditooni ti me ha bunyanga? Yiisu Barabase oo ti Yiisu wu bali mu uta Kristo?» ");
INSERT INTO iyx_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ka bu Pilato akitsuu buu, nde ali ayiluu uyaaba ti, mundaa musoyi bo bamuyeelili Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Mu taanga di Pilato ali adiaala nha mbata a pfuundisi, mukari a nde wamutsindii baata. Baata baa babeyi mukeenzi wu: «Akoto mu kati a ndaa a muutu wahele na toono wu pe, mundaa ti butsuu ba, me moni pasi dialaa mu nziori mu ndaa a nde.» ");
INSERT INTO iyx_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Banguu ba bangaanga ba Nziaambi na bakuutu ba Bayuudayo, batsindi koongi mu uloombo ti, baha bunyanga kwaa Barabase na badusu Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Mutumi abwifuulu bo, aleeli: «Na mu bo baboolo beni ditooni ti me ha bunyanga?» Bo bamuvutili: «Barabase!» ");
INSERT INTO iyx_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato wabafuuli: «Ka me ima niyiluu mu Yiisu wu balimuta Kristo?» Bo boosi bavutili: «Komo nde nha kuruwa!» ");
INSERT INTO iyx_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato afuuli: «Ki ndaa yimbi nde ayiluu?» Ka bo baloyi mu mifuri mia bo mioosi: «Komo nde nha kuruwa!» ");
INSERT INTO iyx_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato amoni ti nde ali ka ndaa kimi ya uyiluu yo pe. Bu nyingi-nyingi yakilutu iteesi, nde aholi maamba, aswayi mioo nha kulu a koongi. Nde aleeli: «Likwa la muutu wu a lili nha yulu a mutswe a me pe! Miatala beni.» ");
INSERT INTO iyx_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Koongi yoosi yavutili: «Nyaala tsieembili a likwa la nde yibwa nha yulu a bisi, na nha yulu a baana ba bisi.» ");
INSERT INTO iyx_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ni mu buu Pilato wabanyaali Barabase. Nha mbisi a nhaa, nde atumi bafiinzi Yiisu bikoti na wamuyeelili paa bamukomo nha kuruwa. ");
INSERT INTO iyx_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Masodaare ma Pilato mabeyi Yiisu mutso nzo a mutumi, na koongi yoosi yavuutini na yamudiengilili. ");
INSERT INTO iyx_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bo bamumaasi bikutu bia nde, na bamulwaatisi iyungu kiabeenge. ");
INSERT INTO iyx_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tumake, bo batuungi iburu kia matsieende, bamusuusi kio ku yulu a mutswe na bamusuusi idiaara nha tso koo kia babaala. Nha mbisi, bo batsukini nha kulu a nde, na bamusiiri saa, bu baleeli: «Bwee, mutini a Bayuudayo!» ");
INSERT INTO iyx_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bo bamutswiili mate na baholi idiaara me, paa batete nde kio nha yulu a mutswe. ");
INSERT INTO iyx_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bu bamani uyiluu usa nde saa, bo bamumaasi iyungu, babwilwaatisa nde bikutu bia nde na bamubiti mu uyakomo nde nha kuruwa. ");
INSERT INTO iyx_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Mu taanga di bakipala mu ngaanda, bo babwaani baala limosi musi Kirene, kuumbu a nde Simooni. Masodaare mamubamii mu ubiti kuruwa a Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Bo batoori ku mbuu mosi yi bali mu uta Ngolongota, mbiindili ti «Mbuu ya iteenge kia mutswe.» ");
INSERT INTO iyx_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Na nha mbuu yii, bo banywiisi Yiisu viinyi li bavuutu na makaya ma kali. Nha mbisi a ubiimbi lo, nde abisi lo unywa. ");
INSERT INTO iyx_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Bo bamukomi nha kuruwa, na batiiri ipa paa bayaaba bwa ukaba bikutu bia nde. ");
INSERT INTO iyx_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tumake, bo badiaali nha mbuu yii mu ukebe nde. ");
INSERT INTO iyx_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nha yulu a kuruwa a nde, babandii itsuru kia bala. Mu bala lii, basonii toono a tsieembili a nde. Mono mandaa mabasonuu: «Wuunawu ni Yiisu, mutini a Bayuudayo.» ");
INSERT INTO iyx_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bakomi ka bipunga-pungu bioolo nha kuruwa, nha peembi a Yiisu. Mosi bakomi nha koo kia babaala, na wunu nha koo kia nde kia bakaasa. ");
INSERT INTO iyx_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Babakiyoo kuulu, bakituu nde bu bakinyingisi mitswe. ");
INSERT INTO iyx_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Bo bakileele kwaa nde: «We wali anhana utsala Nzo a Nziaambi, na ubwatuungu kimi mu biluumbu bitata, ki vuu we makulu, so we ni Mwaana a Nziaambi! Sutuu nha kuruwa yii!» ");
INSERT INTO iyx_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bumosi ka, banguu ba bangaanga ba Nziaambi, bayiisi ba mikele na bakuutu ba Bayuudayo bakisa nde saa. Bo bakileele: ");
INSERT INTO iyx_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Nde avuuyisi baata bakimi, ka nde ka ukoono uvuu nde makulu! Nde ni mutini a Iseraeli? Ka mu taanga di, asutuu nha kuruwa, na bisi sa disa imiini mu nde. ");
INSERT INTO iyx_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nde asuusi ilimbisi kia nde mu Nziaambi, na aleeli: “Me ni Mwaana a Nziaambi.”» Ee, mbiiti Nziaambi atoono nde, nyaala avuusu nde mu taanga di. ");
INSERT INTO iyx_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bumosi ka, bipunga-pungu bibakomi nha kuruwa, nha peembi a nde, biakituu nde. ");
INSERT INTO iyx_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mu nguungu ya nzanga, natee mu ya matata nha mbisi a nzanga, pimisi diabwi mu tsi yoosi. ");
INSERT INTO iyx_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ku peembi a nguungu ya matata nha mbisi a nzanga, Yiisu aloyi mu mifuri: «Eli, Eli, lema sabakatani?» Mbiindili ti: «Nziaambi a me, Nziaambi a me, mu ima we siisi me?» ");
INSERT INTO iyx_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Babamosi mu babali batemene nhaa, bayuyi nde, na baleeli: «Nde Eliya ali mu uta mbili!» ");
INSERT INTO iyx_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mawasa-mawasa, mosi mu bo adumi tiini, mu uyaholo iteendi kia tsaanda. Nde atsubi kio mutso viinyi la nhanyi, na akutili kio ku toso a idiaara. Nde ahi kio paa Yiisu anywa viinyi lii. ");
INSERT INTO iyx_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ka babamosi baleeli: «Mamakebe, dimonani mbiiti mubili Eliya uyavuusu nde!» ");
INSERT INTO iyx_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yiisu abwiloo mu mifuri na nde asieeli muwuumu. ");
INSERT INTO iyx_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Mu taanga dii, ngumbu yi batsiingisi mu Nzo a Nziaambi yakakii mu bibari bioolo, umatuu ku yulu natee ku tsuu. Toto latehiti, mamanya mamanene mapasii. ");
INSERT INTO iyx_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mangili madibini, na baata babalayi, babali banambita mu Nziaambi, babali bamaakwa, basiimbii. ");
INSERT INTO iyx_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nha mbisi a tsimbilili a Yiisu, bo bapali mu mangili. Bo bakoti mu Yeruselemi, ngaanda ya ngira, ku baata babalayi bamoni bo. ");
INSERT INTO iyx_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mukuutu a kama masodaare mosi, musi Looma, na masodaare makikebe Yiisu itwaari na nde, bamoni toto bu la nyingini na moosi makiyilimi. Ni mu buu, bo babayi boomo balaa na baleeli: «Ngwanya, nde aba Mwaana a Nziaambi!» ");
INSERT INTO iyx_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bakaasa balaa bali nha mbuu yii, na bakitala nha la-la. Bo bakiduku Yiisu umatuu ku Ngalili mu usalila nde. ");
INSERT INTO iyx_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nha kati a bo, ali na Mari musi Mangadala, Mari wu nguu a Yaaki na Yoosefi, na nguu a baana ba Zebedaayi. ");
INSERT INTO iyx_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tsitsii bu yatoori, baala limosi la isini, musi Arimate, ayiri. Kuumbu a nde ali Yoosefi na nde ka ali muyii a Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nde ayimono Pilato na wamuloombi nyutu a Yiisu. Ni mu buu, Pilato atumi ti bamuha yo. ");
INSERT INTO iyx_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yoosefi aholi nyutu, akuti yo kutso tsaanda ya liino yinyatii. ");
INSERT INTO iyx_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nde asuusi yo mutso ngili a nde makulu, yi nde atumi ti bakwasootolo nde yo mu manya. Tumake nde atumi ti bakilimisi manya lilinene, mu udibuu munywa a ngili, na nha mbisi nde ayeni. ");
INSERT INTO iyx_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mari musi Mangadala na ndoyi a nde, bali badiaala nha mbuu yii, nha kulu a ngili. ");
INSERT INTO iyx_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Iluumbu kiaduki iluumbu kia nzilimini a saba, banguu ba bangaanga ba Nziaambi na Bafarisi mu itwaari, bayeni ku nzo a mutumi Pilato. ");
INSERT INTO iyx_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Baleeli: «Pfumu, bisi dili mu ulibili moonyi ti ngaa pia wuu, nha nde ali musii, aleeli: “Nha mbisi a biluumbu bitata, me sa siimbuu mu babakwa.” ");
INSERT INTO iyx_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ni mu buu, tsinduu masodaare mayakebe ngili, natee mu tsitsi a biluumbu bitata. So we a yilii buu pe, leeti miyii mia nde sa miyayibi nyutu a nde. Na nha mbisi, sa baleele kwaa koongi ti: “Nde maasiimbuu mu babakwa.” Pia dii, sa divulu mifuri na dia tsiomi.» ");
INSERT INTO iyx_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato wabaleeli: «Dimono masodaare ma mukebe ngili. Diyene na dileele bakebe ngili weti buli tsimi a beni.» ");
INSERT INTO iyx_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ni mu buu bo bayeni mu uyiluu mioosi mundaa kebili a ngili. Bo bahangii manya na basuusi masodaare. ");
INSERT INTO iyx_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nha mbisi a iluumbu kia Saba, mu iluumbu kia limiingi ku makia ma bwisi, Mari musi Mangadala na ndoyi a nde, bayimono ngili. ");
INSERT INTO iyx_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Itsundu-a-tsundu, toto dianyingini mu mifuri. Tumu a Pfumu mosi amati ku yula, asutii. Nde ayinyiingili, akilimisi manya lilinene nha peembi, na adiaali nha yulu a lo. ");
INSERT INTO iyx_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nde ali afwaanina weti nzieri wuli mu useremene, na bikutu bia nde biali biayiluu uhembuu. ");
INSERT INTO iyx_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Masodaare makikebe ngili me yii mamoni boomo balaa, ni mu buu bo batehiti na bo bali ka weti babamaakwa. ");
INSERT INTO iyx_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tumu a Pfumu anaangili ndaa, na aleeli kwaa bakaasa: «A diba na boomo pe. Me nayaaba ti beni Yiisu wubakomi nha kuruwa, dili mu usaa. ");
INSERT INTO iyx_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nde a li nha pe, mundaa siimbiaangi mu babakwa weti bu nde aleeli yo. Diyiri dimono mbuu yi baba basuusu nyutu a nde. ");
INSERT INTO iyx_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Diyene mawasa, dileele kwaa miyii mia nde: “Nde siimbiaangi mu babakwa. Mu taanga di, ka mu uyakebe beni ku Ngalili. Ni kuu beni dikaamono nde.” Mono ma me naba na mo mu uleele kwaa beni.» ");
INSERT INTO iyx_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Bakaasa bo baboolo basiisi ngili mu mawasa, bali baluulu mu boomo na mu kinyi yalaa. Bo badumi tiini mu uyayaabisa ndaa kwaa miyii mia Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Itsundu-a-tsundu, Yiisu ayibwaana bo na aleeli: «Mabwe ma beni!» Bo baswesii kwaa nde, bakaangi miili mia nde, na bamukuundi. ");
INSERT INTO iyx_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ni mu buu, Yiisu aleeli kwaa bo: «A diba na boomo pe. Diyayaabisa kwaa baana ba nguu ba me, mu uyene ku Ngalili. Ni kuu bo bumono me.» ");
INSERT INTO iyx_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Bu bakaasa bali mu kuulu, babamosi mu masodaare bakikebe ngili, bayiri ku kati a ngaanda. Bo bayaabisi kwaa banguu ba bangaanga ba Nziaambi moosi mamayilimi. ");
INSERT INTO iyx_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Banguu ba bangaanga ba Nziaambi, na bakuutu ba Bayuudayo bakukini. Nha mbisi a uyuhusunu, bo bahi mboongo dialaa kwaa masodaare, paa bafuu ndaa. ");
INSERT INTO iyx_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Bo baleeli: «Beni sa dileele ti, miyii mia muutu wu miayayibi nyutu a nde mu butsuu, mu taanga di beni diaba tolo. ");
INSERT INTO iyx_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Na so mutumi yuyi yo, bisi sa diyaaba bu dibiindili kwaa nde, mundaa uhele ulooso beni mu pasi.» ");
INSERT INTO iyx_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Masodaare maholi mboongo na mayilii weti bu babatumi. Ninha, ndaa yapia yii yatsiaamii kwaa Buyuudayo natee mu iluumbu kia lolo. ");
INSERT INTO iyx_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Miyii kuumi na mosi miayeni ku Ngalili, ku mulaanda wu Yiisu ayaabisi bo. ");
INSERT INTO iyx_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Bu bamumoni, bo bamukuundi. Ka bunu, babamosi mu bo a basiingi pe ti ngwanya ali Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yiisu aswesii na wabaleeli: «Litu loosi baha kwaa me, mu mayula na nha tsi. ");
INSERT INTO iyx_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ni mu buu, diyene kwaa baata ba bifuumbu bioosi. Diyiisi bo paa bo baba miyii mia me. Diababootuu mu kuumbu a Taayi, na ya Mwaana, na ya Muheebili wa Ngira. ");
INSERT INTO iyx_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Diabayiisi mu ukiinzi moosi ma me natumi beni. Na diyaaba yi: me sa ba itwaari na beni biluumbu bioosi, natee tsieelili a taanga.»");
INSERT INTO iyx_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Mbaandila Ndaa Yimbwe ya Yiisu Kristo, Mwaana a Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Mu mukaanda a mubili Yeesaya basonuu: «Mono me ni tsinduu tumu a me nha kulu a we, mu uyiluu we kuulu. ");
INSERT INTO iyx_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ni ndaa a muutu mosi, wuli mu uloo mu tsi ya tsata: Diyiluu kulu a Pfumu, diyiluu usuungusu misoo mia nde!» ");
INSERT INTO iyx_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Bu Yowani Mubootii amonii mu tsi ya tsata, nde akibootuu na akiyaabisa: «Disobo ndiaatili a beni, diholo libootuu. Tumake, Nziaambi sa asa masumu ma beni kolokolo.» ");
INSERT INTO iyx_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Baata boosi ba mu itinini kia Yuuda, na ba ku ngaanda ya Yeruselemi, bakiyiri kwaa nde. Bo bakisiingi masumu ma bo nha kulu a baata, na Yowani akibootuu bo mu nziali ya Yorodaani. ");
INSERT INTO iyx_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yowani akilwaata ikutu kibabaamba mu miooso mia nyama wa kuumbu samo. Na nde akilwaata kobo yi bayiluu mu mukaanda a nyama mu luungu la nde. Nde akidia bangwalibaanga na maari ma nyosi wa ku musiti. ");
INSERT INTO iyx_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nde akiyaabisa: «Muutu mosi wavulu me mifuri, li mu uyiri nha mbisi a me. Me a nafwaana pe mu ubaandina, mu unyangila midi mia bikoori bia nde. ");
INSERT INTO iyx_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Me nadibootii mu maamba, ka nde, sa wadibootuu mu Muheebili wa Ngira.» ");
INSERT INTO iyx_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mu biluumbu bii, Yiisu amati ku Ngaanda ya Nazareti, mu itinini kia Ngalili, na Yowani wamubootii mu Yorodaani. ");
INSERT INTO iyx_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Mu taanga di Yiisu akipala mu maamba, nde amoni mayula madibini na Muheebili wa Ngira akulumini nha yulu a nde weti beembe. ");
INSERT INTO iyx_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Na Ndaa yayuyini mu mayula: «We ni Mwaana a me wa litoono ndaa. Mu we me ndi mu umono kinyi a me yoosi.» ");
INSERT INTO iyx_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Mutaanga dina dii, Muheebili a Nziaambi wamubiti ku tsi ya tsata. ");
INSERT INTO iyx_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yiisu adiaali kuu, mu tsitsi a biluumbu maku mana, na Saatina wamuwungisi. Nde akidiaala nha kati a banyama ba ku musiti. Batumu ba Nziaambi bakisalila nde. ");
INSERT INTO iyx_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nha mbisi a nha baloosi Yowani Mubootii mu perese, Yiisu ayeni ku itinini kia Ngalili. Kuu nde akiyiisi Ndaa Yimbwe ya Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Nde akileele: «Taanga dimbwe dimaato, na Ipfumu kia Nziaambi ika bebele! Disobo ndiaatili, na disa imiini mu Ndaa Yimbwe!» ");
INSERT INTO iyx_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yiisu akiyene mu mukoo-mukoo a diaanga la Ngalili, bu nde amoni Simooni na mukee a nde Andere. Bo bakidumunu siele mu maamba, mundaa ti bo ali balobi ba batswi. ");
INSERT INTO iyx_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yiisu wabaleeli: «Diduku me, na beni sa diba balobi ba baata.» ");
INSERT INTO iyx_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nhaa-na-tsi, bo basiisi masiele ma bo, na bamuduki. ");
INSERT INTO iyx_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yiisu asweesii hoolo nha lala, na amoni Yaki na mukee a nde Yowani, bo baboolo baana ba Zebedaayi. Bo bali mutso bootu la bo, na bakiloondo masiele ma bo. ");
INSERT INTO iyx_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nhaa na nhaa, Yiisu wabateeri mbili. Ninha, bo basiisi taayi a bo Zebedaayi mutso bootu na basiali, na bo baduki Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yiisu na miyii mia nde bakoti mu ngaanda ya Kapernawumi. Nhaa na a nhaa, mu iluumbu kia Saba, Yiisu ayeni ku nzo a makutunu ma Bayuudayo. Ni kuu nde abandii uyiisi baata. ");
INSERT INTO iyx_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Babakiyuu nde bakimii mu nziisili a nde. Mu ndaa ti nde akiyiisi bo mu litu, na nziisili a nde yali na lisobuso na nziisili a Bayiisi ba mikele. ");
INSERT INTO iyx_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kaba, mutso nzo a bo ya makutunu ma Bayuudayo, mwali na muutu mosi wu muheebili wu mubi akikwaamisa. Nde abaandii uloo: ");
INSERT INTO iyx_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","« Ima we tooni mu bisi, Yiisu musi Nazareti? We yiri mu ufuusu bisi? Me nayaaba bubwe we na li: wa Ngira, wu Nziaambi atsinduu!» ");
INSERT INTO iyx_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yiisu a tsuyi mu ibaala kwaa muheebili wu mubi na wa muleeli: «Wuru na pii, na pala mu muutu wu!» ");
INSERT INTO iyx_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Muheebili wu mubi anyingisi muutu mu mifuri, na apali mu nde bu aloyi mungiri wu munene. ");
INSERT INTO iyx_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Baata boosi bakimii kwalaa bu bafulisini bo na bo: «Yi ki ndaa yi? Muutu wu li mu uha nziisili yinyatii mu litu loosi! Nde li mu utumu natee kwaa miheebili mimibi, na mio mili mu utumumu nde!» ");
INSERT INTO iyx_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Na, nhaa na nhaa, mvuungu a Yiisu yatsiaamii mu itinini kia Ngalili kioosi. ");
INSERT INTO iyx_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Bo bapali mu nzo a makutunu ma Bayuudayo, na bayeni mu mawasa ku nzo a Simooni na Andere, itwaari na Yaki na Yowani. ");
INSERT INTO iyx_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Buko ba Simooni ali nha yulu a mbuu, na baa. Mawasa-mawasa, batsuyi mu ndaa a nde kwaa Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yiisu asweesii kwaa nde, wamukaangi mu koo na wamutemisi. Baa lamatii mu nde, na nde abaandii mu usalila bo. ");
INSERT INTO iyx_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mu taanga tsitsii, bwiisi bu bamana na uyili, baata babeyi kwaa Yiisu babeeri boosi na babali bakangama kwaa miheebili mimibi. ");
INSERT INTO iyx_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Baata ba ngaanda yoosi bakidwaanina munywa a nzo. ");
INSERT INTO iyx_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yiisu abeelisi baata balaa bakimono pasi mu bibeeri bia mupili na mupili. Nde abingi ka miheebili mialaa mimibi. Nde a akiha pe muswa kwaa miheebili mimibi mu utsuu, mu ndaa ti mio miali miayaaba, nde na ali. ");
INSERT INTO iyx_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Iluumbu kiaduki, mu ngwaali a ngwaali ya na wee, Yiisu asiimbii, na apali mu nzo. Nde ayeni nha mbuu yahele a baata, na nde abaandii ukuundu Nziaambi kuu. ");
INSERT INTO iyx_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simooni na baata babali na nde babaandii usaa Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Bu bamusolili, bamuleeli: «Baata boosi bali mu usaa we.» ");
INSERT INTO iyx_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yiisu wabaleeli: «Tsweendani mu mapeembi makimi, mu mala mabebele, paa me yiisi Ndaa Yimbwe kuu ka. Mundaa ti, ni mu ndaa yo me nayiri.» ");
INSERT INTO iyx_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Na nde adieengili itinini kia Ngalili kioosi. Nde akiyiisi Ndaa Yimbwe, mu manzo ma bo ma makutunu ma Bayuudayo, na akibingi miheebili mimibi. ");
INSERT INTO iyx_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ngaa bwaari mosi ayiri kwaa Yiisu, atsukini nha kulu a nde na wamuloombi: «So we tooni, we utuu utsieemese me!» ");
INSERT INTO iyx_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yiisu bu amoni ngebe dialaa, nde asibili koo, wamubeembi. Yiisu wamuleeli: «Me tooni, ki tsieeme wa we!» ");
INSERT INTO iyx_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nhaa na nhaa, nde abeelii mu bwaari, na nde atsieemi. ");
INSERT INTO iyx_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yiisu wamuvutili na wamutsuyi mu ibaala. ");
INSERT INTO iyx_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Nde wamuleeli: «Yuu bubwe: a leele yo kwaa muutu so mosi pe. Ka yene kwaa ngaanga a Nziaambi, paa we mweese nde ti we maabeeluu. Na ha bungori ba Mooso atumi, mu umweese kwaa boosi ti we maabeeluu.» ");
INSERT INTO iyx_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Muutu wuu ayeni, ka akiyene ayaabisa kwaa boosi mii miayilimi mu nde. Mu toono yii, Yiisu ali ka utuu pe ubwamonuu mutso ngaanda. Nde akidiaala ku mbari a ngaanda, mu mambuu mamahele baata. Ka baata bakimata mu mambuu moosi na bakiyiri kwaa nde. ");
INSERT INTO iyx_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nha mbisi a mwaana biluumbu, Yiisu ayiravutuu ku ngaanda ya Kapernawumi. Na bwayuyini ti nde ku nzo ali. ");
INSERT INTO iyx_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Baata balaa bakukini nhaa, na a yabwiba na mbuu ya udiaala, so nha munywa a nzo pe. Yiisu ayaabisi bo ndaa a Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Baata bayiri, bu bamubeyi muutu wabobo binama wu baata bana nha kati a bo bakibiti. ");
INSERT INTO iyx_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Bo a batuyi pe umweese nde kwaa Yiisu, mu ndaa koongi yali nhaa. Ni mu buu, bo badibili siaangi la nzo nha yulu a mbuu yii yali Yiisu. Mu wuru lii, bo basutili laba li balibanaa wabobo binama. ");
INSERT INTO iyx_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Bu Yiisu, amoni imiini kia bo, aleeli kwaa wabobo binama: «Mwaana a me, masumu ma we basiri kolokolo.» ");
INSERT INTO iyx_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Babamosi mu bayiisi ba mikele, babali badiaala nhaa, batsimi kutso mitimi mia bo: ");
INSERT INTO iyx_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Mu ima muutu wu ali mu utsuu buu? Nde li mu utuu Nziaambi! Na utuu usa masumu kolokolo? Ndili a Nziaambi utuu ukuungulu masumu!» ");
INSERT INTO iyx_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yiisu ayaabi nha na nhaa ma bo bali a tsimi na wabaleeli: «Mu ima beni dili na matsimi ma pili yii? ");
INSERT INTO iyx_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ima kiavulu pasi? Mu uleele ti: “Masumu ma we basiiri mo kolokolo?” — oo ti mu uleele — “Temene, holo laba la we na yene?” ");
INSERT INTO iyx_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ee-e me tooni ti beni diyaaba: Mwaana a muutu li na litu la usa masumu kolokolo nha yulu a toto.» Ni mu buu nde aleeli kwaa wabobo binama: ");
INSERT INTO iyx_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Me ndeeli kwaa we, temene, holo ikala kia we na yene ku nzo a we!» ");
INSERT INTO iyx_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Muutu atemini, nhaa na nhaa aholi laba la nde, na apali nha kulu a baata boosi. Boosi bakimii na bo babili Nziaambi bu baleeli: «Kaala a diamono wabisi ndaa ya pili yi pe!» ");
INSERT INTO iyx_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yiisu abwivutuu mu mukoo a diaanga la Ngalili. Koongi a baata yoosi yayiri kwaa nde, na nde wabayiisi. ");
INSERT INTO iyx_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Bu akilabuu, nde amoni Levi, mwaana a Alafayi, adiaala nha nzo yi bubaafutu limaanda. Yiisu aleeli kwaa nde: «Duku me!» Nde atemini, na wamuduki. ");
INSERT INTO iyx_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tumake Yiisu adiiri mu nzo a Levi. Batoli ba limaanda balaa na bangaa masumu, bakidia nha meese itwaari na Yiisu na miyii mia nde. Bo ali babalayi mu uduku nde. ");
INSERT INTO iyx_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Na bayiisi ba mikele babali kaba limosi na Bafarisi, bamoni ti Yiisu akidia na bangaa masumu na batoli ba limaanda. Bo bakileele kwaa miyii mia nde: «Mu ima nde ali mu udia na batoli ba limaanda na bangaa masumu?» ");
INSERT INTO iyx_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yiisu, bu ayuyi buu, wabaleeli: «A baata bali polo bali na nzala a mubuyi pe, ka babeeri. Me a nayiri pe mu uta mbili babali mu utsimi ti, bo bamaakwayiluu litoono la Nziaambi. Ka me nayiri mu babali mu ulibili moonyi ti bo bangaa masumu.» ");
INSERT INTO iyx_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Iluumbu imosi, miyii mia Yowani mubootii na Bafarisi bakidii mutuutu. Baata bayifuulu Yiisu: «Mu ima miyii mia Yowani na mia Bafarisi bali mu udii mutuutu, ka miyii mia we, a mili mu uyiluu buu pe?» ");
INSERT INTO iyx_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yiisu wabavutili: «Beni ditsimi ti, babatumusu ku mukuungi a makweele utuu udii mutuutu, mu taanga di mufuru a makweele ali na bo? Mu taanga di nde ali na bo, bo utuu pe udii mutuutu. ");
INSERT INTO iyx_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ka biluumbu sa biyiri bi bakaamaasa mufuru a makweele nha kati a bo. Ni mu buu mu iluumbu kii, bo sa badii mutuutu.» ");
INSERT INTO iyx_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Muutu pe wu ubaamba iteendi kia tsaanda ki inyatii, nha yulu a ikutu ki ikulu. Leeti, iteendi ki inyatii, ukaka ikutu ki ikulu, na wuru sa libwavulu bunene. ");
INSERT INTO iyx_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Na muutu utuu pe usiengele mala mamanyatii, mu mambiindi ma makulu. Leeti, mala sa mabulu mambiindi: mala sa matsamuu, na uhelele mambiindi. Ka mala mamanyatii, usiengele mu mambiindi mamanyatii!» ");
INSERT INTO iyx_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mu iluumbu kia Saba, Yiisu akitaba matsiee ma bele. Nha mbuu mosi, miyii mia nde miabaandii ukaba mbutu dia bele. ");
INSERT INTO iyx_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Bafarisi baleeli kwaa Yiisu: «Mono, mu ima miyii mia we mili mu uyiluu mi bahele uha muswa mu iluumbu kia Saba?» ");
INSERT INTO iyx_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yiisu wabavutili: «Beni keni a diataanga pe, maa mayilii mutini Daavidi, iluumbu imosi bu nde na banduu ba nde bali na nzala? ");
INSERT INTO iyx_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Mu taanga dia nguu a ngaanga a Nziaambi wa kuumbu Abiatara, Daavidi akoti mu nzo a Nziaambi. Nde adiiri mapa ma bahi bungori kwaa Nziaambi, ma muutu so mosi a ali na muswa mu udia pe, ka ndila bangaanga ba Nziaambi. Na Daavidi ahi ka mo kwaa banduu ba nde.» ");
INSERT INTO iyx_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yiisu abwileele kwaa bo: «Iluumbu kia Saba bayiluu kio mu toono a baata, ka a bayiluu baata mu toono a Saba pe. ");
INSERT INTO iyx_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ni mu yii, Mwaana a muutu li ka pfumu a Saba.» ");
INSERT INTO iyx_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tumake, Yiisu avutii mu nzo a makutunu ma Bayuudayo. Muu mwali na muutu ngaa koo kiabobo. ");
INSERT INTO iyx_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bakikete Yiisu, mu umono mbiiti nde ubeelese mubeeri mu iluumbu kia Saba, mu ndaa ti bakisaa toono ya ufuundu Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yiisu aleeli kwaa ngaa koo kiabobo: «Temene, yiri nha kati a kati nha.» ");
INSERT INTO iyx_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tumake Yiisu afuuli kwaa babamosi: «Ki muswa baha mu iluumbu kia Saba? Mu uyiluu mamabwe oo ti mu uyiluu mamabi? Mu uvuusu idiingi kia muutu oo ti mu udusu nde?» Ka bo bawuri na pii. ");
INSERT INTO iyx_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yiisu wabatali boosi mu kesi, na amoni ngebe dialaa, bu babisi uyuu. Nde aleeli kwaa muutu wabobo koo: «Sibili koo kia we.» Nde asibili kio na koo kia nde kiabeelii. ");
INSERT INTO iyx_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Bafarisi bapali mu nzo a makutunu ma Bayuudayo, na nhaa na nhaa bakukini na baata ba kaba la Erode Antipase, mu usaa buni budusu Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yiisu na miyii mia nde bayeni mu mukoo a diaanga, na koongi a baata yalaa yamuduki. Baata bamati ku bitinini bia: Ngalili, Yuuda, na Idumayi. Bana ku mangaanda ma: Tiro, Sidoni, Yeruselemi, na ku tsi yili ku simi likimi la Yorodaani. Bo bakiyiri kwaa Yiisu mu makoongi mundaa ti bo bayuyi ma nde akiyiluu. ");
INSERT INTO iyx_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ni mu buu, Yiisu aleeli kwaa miyii mia nde mu uyiluu nde bootu, paa koongi yinyaala usa nde pinyi. ");
INSERT INTO iyx_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ka nde abeelisi babeeri balaa, na boosi bakimono pasi mu bibeeri babwiiri ku yulu a nde paa bamubeembe. ");
INSERT INTO iyx_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na bu miheebili mimibi miakimono Yiisu, mio miakibwa nha miili mia nde na miakiloo: «We ni Mwaana a Nziaambi!» ");
INSERT INTO iyx_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ka Yiisu wabalii mu ibaala, mu uhele uyaabisa ti nde na ali. ");
INSERT INTO iyx_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tumake Yiisu ahaati mulaanda, na nde ati baa ba nde atooni mbili, na bo bayiri kwaa nde. ");
INSERT INTO iyx_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nde abiaalisi kuumi na boolo, ba nde ahi kuumbu batumu. Nde asiooli bo, paa bo baba itwaari na nde, na mu utsinduu bo mu uyaabisa ndaa yimbwe, ");
INSERT INTO iyx_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","na litumu la ubingi miheebili mimibi. ");
INSERT INTO iyx_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Mono kuumi na boolo ba nde abiaalisi: Simooni wu Yiisu aluyi kuumbu Peetero, ");
INSERT INTO iyx_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yaki na mukee a nde Yowani, bo baboolo baana ba Zebedaayi, ba Yiisu ahi kuumbu ya «Boaningisi», mambiindili ti baana ba nzieri, ");
INSERT INTO iyx_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andere, Filipo, Baritelemi, Mataayi, Toma, Yaki mwaana a Alafayi, Tade, Simooni Muzeloti, ");
INSERT INTO iyx_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Yuuda Isikarioti, wuu wayeelili Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tumake Yiisu ayeni ku nzo. Koongi yalaa yabwikukunu, na Yiisu na miyii mia nde a batuyi ka so udia pe. ");
INSERT INTO iyx_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Bu binama bia kaanda la nde bayuyi maa, bo bayiri mu ukaanga nde, na bakileele: «Nde maayamuu lari!» ");
INSERT INTO iyx_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Bayiisi ba mikele bamati ku Yeruselemi baleeli: «Belezebuli li na ikuunu mu nde!» Na bo babwileele: «Ni mu litu la mukuutu a miheebili mimibi nde ali mu ubingi miheebili mimibi!» ");
INSERT INTO iyx_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ni mu buu, Yiisu wabati mbili, na wabaleeli mu matsaba: «Buni Saatina utuu ubingi Saatina? ");
INSERT INTO iyx_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","So ipfumu imosi ikoti mukabini na baata ba ipfumu kii bali mu udwaanisina bo na bo, kio a idiingi pe. ");
INSERT INTO iyx_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Bumosi ka, so kaanda limosi lakabuu na binama bia lo bili mu udwanisina bio na bio, kaanda lii a lituu udiingi pe. ");
INSERT INTO iyx_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ni mu buu, so Saatina li mu udwaanisa nde makulu, so nde li akabuu, nde a utuu udiingi pe. Na tsukili a nde yimaamonuu.» ");
INSERT INTO iyx_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","«A uli pe na wu utuu ukoto mu nzo a muutu ngaa mifuri, na upatila bisii bia nde, mbiiti nde a akwakutu pe ngaa mifuri wuu bibolo! Ka nha mbisi a ukutu nde bibolo, tumake nde tuyi uholo bili mu nzo a nde. ");
INSERT INTO iyx_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ngwanya me na dileeli, moosi ma baata busa, Nziaambi sa asa mo kolokolo: so yaba masumu ma bo, so yaba bitari bi batuu Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ka wuu, wukaatuu Muheebili wa Ngira, nde a utuu ubaa kolokolo pe: nde biti tsieembili ya masumu ma nde ya bilimi na bilimi.» ");
INSERT INTO iyx_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yiisu akitsuu buu mundaa ti bo bakileele: «Nde li akangama kwaa muheebili wumubi.» ");
INSERT INTO iyx_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nguu na baana ba nguu ba Yiisu bayiri ka. Bu bali batemini ku mbari, bo batsindii muutu mu uta nde mbili. ");
INSERT INTO iyx_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Koongi yadiengilili Yiisu yali yadiaala na bamuleeli: «Yuu, nguu a we, baana ba nguu a we bali ku mbari na bali mu usaa we.» ");
INSERT INTO iyx_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yiisu avutili: «Na li nguu a me, na bana bali baana ba nguu ba me?» ");
INSERT INTO iyx_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nde atali baata badiaala bali badiengelele nde, na aleeli: «Mono nguu a me na baana ba nguu ba me! ");
INSERT INTO iyx_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ka pasi muutu wu uyiluu litoono la Nziaambi, nde wuu ni mwaana nguu kwaa me, so a buu pe keri, na nguu a me.» ");
INSERT INTO iyx_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yiisu abwibaanduu uyiisi baata mu mukoo a diaanga la Ngalili. Koongi yalaa yakukini na yamudiengelili. Ni mu buu, nde ahaati mutso bootu na adiaali. Bootu ali nha yulu a maamba, na koongi yoosi ali nha toto, ku simi la diaanga. ");
INSERT INTO iyx_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nde akiyiisi bo mandaa malaa mu matsaba, na akileele kwaa bo mu nziisili a nde: ");
INSERT INTO iyx_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Diyuu! Muutu mosi ayinyasila mbutu mu tsiee a nde. ");
INSERT INTO iyx_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Bu nde akinyasila mbutu, di dimosi diabwiiri mu mukoo a kuulu. Tumake, banyunyi bayiri na batooti dio. ");
INSERT INTO iyx_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ndaamba a mbutu dimosi diabwiiri nha mbuu ya mamanya, nha yahele na toto dialaa. Mbutu diameni mu mawasa, mundaa ti toto ali yulu-a-yulu. ");
INSERT INTO iyx_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nyanga bu yabali, yanyeengisi mitswiili, mio miakanyi mundaa ti miaanzi ali a miayiluu udiaama pe. ");
INSERT INTO iyx_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ndaamba a mbutu dikimi diabwiiri kutso mingaamba. Mingaamba miakuli, na mianyongisi mitswiili. ");
INSERT INTO iyx_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ka ndaamba a mbutu dikimi diabwiiri nha toto dia mboloso, diameni, diakuli na diabuti mbutu. Mbutu dini diabuti mbutu maku-matata, dikimi maku-masamina na didimosi kama.» ");
INSERT INTO iyx_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Na Yiisu aleeli: «Wuli na matswi ma uyuu, nyaala ayuu!» ");
INSERT INTO iyx_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mu taanga di Yiisu atakii la na koongi, babali na nde na miyii kuumi na mioolo, bamufuuli manduru mu ndaa ya matsaba ma nde akita. ");
INSERT INTO iyx_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nde wabavutili: «Kwaa beni, Nziaambi ahi muswa wa uyaaba matsweeyi ma ipfumu kia nde. Kwaa babamosi, mioosi umweese mu ifwaani kia matsaba. ");
INSERT INTO iyx_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Uli buu, paa: “So bo buyiluu utala, bo banyaala umono. So bo buyiluu uyuu, bo ba nyaala ubahala. Leeti bo sa bayiri avutuu kwaa Nziaambi, na nde sa asa bo kolokolo!”» ");
INSERT INTO iyx_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tumake Yiisu wabaleeli: «Beni a dili mu uyaaba pe tsutulu a tsaba yi? Aka buni beni dikaayaaba tsutulu a matsaba mana moosi? ");
INSERT INTO iyx_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Munyasili li mu unyasila mandaa ma Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Babamosi bali mu mukoo a kuulu, nha mbuu yi bakuni Mandaa. Bu bamani na uyuu mo, nhaa na nhaa Saatina li mu uyiri, na li mu umaasa mandaa mabakuni mu bo. ");
INSERT INTO iyx_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bakimi bali mu uyaka mo mu tsieengi dia mamanya. Bu bamani mu uyuu mandaa, nhaa na nhaa bo bali mu yaka mo mu kinyi. ");
INSERT INTO iyx_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ka bo a bali mu unyaala pe ti mo ma mene miaanzi mu bo. Bo bali mu unambita mu mo ndila taanga hoolo. Na, mu taanga di mapasi mali mu uyiri, so a buu pe mapuusu mu ndaa mandaa ma Nziaambi, bo bali mu utee imiini mbisi. ");
INSERT INTO iyx_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bakimi ka bali mu uyaka mo mutso mingaamba. Bo bamaayuu mandaa. ");
INSERT INTO iyx_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ka bo bali mu unyoongo mu mandaa ma tsi yi, mu busini ba pia, na mu manzala ma mupili na mupili. Bii bioosi bili mu usa mandaa ma Nziaambi pinyi. Na mandaa ma Nziaambi a mali mu ubutu mbutu pe. ");
INSERT INTO iyx_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nha tsieelele, bakimi, bali mu uyaka mo nha toto dia mboloso: bo bali mu uyuu mandaa ma Nziaambi, bo bali mu uyaka mo na bali mu ubutu mbutu. Wu mumosi abuti mbutu maku matata, wunu maku masamina, na mukimi kama.» ");
INSERT INTO iyx_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yiisu aleeli kwaa bo: «Na li mu ubee mwiindi paa ti afuu nde ku tsini a ipaayi, so a buu pe ku tsini a mbuu? A mu usuusu nde nha yulu a isuusili kia mwiindi pe? ");
INSERT INTO iyx_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Moosi masweeme sa mayabina, na mioosi mia tsweeyi sa basuusu mio nha liyalila. ");
INSERT INTO iyx_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","So muutu li na matswi mu uyuu, nyaala ayuu.» ");
INSERT INTO iyx_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yiisu abwileele kwaa bo: «Disa mayele mu ma dili mu uyuu! Ileesili ki beni dili mu usalila mu bambaayi, ni ileesili kii ka Nziaambi akaasalila mu beni, na sa babweese ka. ");
INSERT INTO iyx_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kwaa muutu wuli na iloo, sa babwabweese nde bikimi. Ka kwaa wahele na iloo, sa bamumaasa so mwaana a ndaamba yi ali na kio.» ");
INSERT INTO iyx_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yiisu abwileele: «Mono buni bwafwaanina Ipfumu kia Nziaambi: muutu mosi akuni mbutu mu tsiee a nde. ");
INSERT INTO iyx_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","So yaba butsuu, so yaba nyanga, so nde laari tolo, so a buu pe nde temini, nde a ayaaba pe buni mbutu dili mu umene, na buni misumunu mili mu ukulu. ");
INSERT INTO iyx_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Toto dio makulu dili mu ukwakulusu musumunu. Musumunu li mu ukulu, tumake nde li mu upalisa bifulu, na nha tsieelele, mbutu diavululu. ");
INSERT INTO iyx_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Bu mbutu dimaayele, ka taanga dia ukese mu mukwati, mundaa ti taanga dia ukukuu dimaato.» ");
INSERT INTO iyx_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yiisu abwileele: «Na ima dituu ufwaanisa Ipfumu kia Nziaambi? Mu ki tsaba bisi dituu utsuu mu kio? ");
INSERT INTO iyx_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kio ili weti libutu la mutarede, lavulu mu bukee mu mbutu dioosi dia nha tsini a toto. Mu taanga dibali mu ukunu lo, ");
INSERT INTO iyx_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","na lo bu likuli, lo ka lavulu miti mioosi mia mutso wooto mu bula. Nde li mu upalisa mapaki ma manene, na banyunyi bali mu uyatuungu manzo ma bo kutso posi a nde.» ");
INSERT INTO iyx_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yiisu akiyiisi mu matsaba malaa mapili yii, mu iteesi ki babakiyuu nde bakituu ubahala. ");
INSERT INTO iyx_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nde a akitsuu pe kwaa bo kwahele a usalila matsaba. Ka nde akibiindili moosi kwaa miyii mia Nde, mu taanga di nde ali nde bake na bo. ");
INSERT INTO iyx_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mu tsitsii ya iluumbu kii, Yiisu aleeli kwaa miyii mia nde: «Disabwaani ku simi likimi la diaanga.» ");
INSERT INTO iyx_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Yiisu na miyii mia nde basiisi koongi. Yiisu adiaali mutso bootu, miyii mia nde miakoti ka mu bootu paa basabuu diaanga. Mabootu makimi mayeni na bo itwaari na nde. ");
INSERT INTO iyx_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ka mono iteembi kia mifuri kianaangii, mapo makoti mutso bootu, na lo lali laka mu uluulu mu maamba, na lali laka mu udiaama. ");
INSERT INTO iyx_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yiisu ali ala na anaa mutswe nha yulu a futili, ku mbisi a bootu. Miyii mia nde miamusiimbili na miamuleeli: «Muyiisi, bisi sa dikwa! A yili mu umwese we pasi nha mutimi pe?» ");
INSERT INTO iyx_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yiisu asiimbii, afweengi iteembi na aleeli kwaa diaanga: «Wuru! Ba na pii!» Na iteembi kiawuri, na kwamonii iholo ki inene. ");
INSERT INTO iyx_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yiisu aleeli kwaa miyii: «Mu ima beni dili na boomo? Beni keni imiini pe mu Nziaambi?» ");
INSERT INTO iyx_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ka bo babayi boomo balaa na balelisini: «A bene! Wu ki pili a muutu wu, paa biteembi na mapo ma maamba bitumumu nde?» ");
INSERT INTO iyx_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Bo batoori ku simi likimi la diaanga la Ngalili, mu tsi ya basi Ngerasa. ");
INSERT INTO iyx_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Bu Yiisu asutii mu bootu, muutu mosi wu miheebili mimibi miakikwaamisa, ayibwaana nde. Muutu wuu apali kutso mangili, ku nde akidiaala. Muutu so mosi pe wakituu ukutu nde bibolo, so mu misiingi mia bitali. ");
INSERT INTO iyx_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mbala na mbala, bakikutu nde bibolo mu miili mu misiingi mia bitali, ka nde akitabula bibolo bia bitali. Muutu so mosi pe wali na mifuri mia udweemese nde. ");
INSERT INTO iyx_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Taanga dioosi, butsuu na nyanga, nde akidiaala kutso mangili na ku yulu a milaanda. Nde akiloo na akinemese nyutu a nde mu mamanya. ");
INSERT INTO iyx_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Bu nde atalili Yiisu ku la, nde adumi tiini, atsukini nha kulu a nde, ");
INSERT INTO iyx_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","na aloyi mu ndaa yinene: «Yiisu, Mwaana a Nziaambi mu kati a mayula, ki ndaa we li mu usaa mu me? Me loombi kwaa we mu mifuri, mu kuumbu a Nziaambi, a fuundusu me pe!» ");
INSERT INTO iyx_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Nde aleeli buu, mundaa ti Yiisu aleeli kwaa nde: «Muheebili wumubi, pala mu muutu wu!» ");
INSERT INTO iyx_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yiisu wamufuuli: «Kuumbu a we na?» Nde avutili: «Kuumbu a me “Koongi”, mundaa ti bisi diavululu.» ");
INSERT INTO iyx_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Na nde apeli Yiisu mu unyaala utsinduu bo ku mbari a itini kii. ");
INSERT INTO iyx_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kwali nhaa na mukaanga wumunene wa bangulu, bakisaa biloo ku peembi a mulaanda. ");
INSERT INTO iyx_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Miheebili mimibi mialoombi Yiisu: «Tsinduu bisi mutso bangulu ba, na bisi sa dikoto mu bo!» ");
INSERT INTO iyx_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yiisu wabahi muswa. Tumake miheebili mimibi miapali mu muutu wuu, na miakoti mu bangulu. Mukaanga woosi akulini ku tsuu a mulaanda, abwiiri mu diaanga, adiaami na afuyi. Litaanga la bangulu mutso mukaanga wuu, ali helape mafuundu moolo. ");
INSERT INTO iyx_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Babakikebe bangulu babati na babiti mvuungu ku ngaanda na ku mala moosi ma mu itinini kii. Baata bayiri mu umono mamayilimi. ");
INSERT INTO iyx_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bo bayiri kwaa Yiisu na bamoni muutu wali na mukaanga a miheebili mimibi. Nde ali adiaala, alwaata bikutu na nde ali na biluunzi bia nde biakuu. Bo babayi boomo. ");
INSERT INTO iyx_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Babamoni mioosi bayaabisi bo mii miayilimi kwaa muutu wali na miheebili mimibi, na kwaa bangulu. ");
INSERT INTO iyx_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ni mu buu, bo bapeli Yiisu mu usiisi tsi a bo. ");
INSERT INTO iyx_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mu taanga di Yiisu ahaati mu bootu, muutu wali na miheebili mimibi, wamuloombi mu uyene na nde. ");
INSERT INTO iyx_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yiisu a ahi nde muswa pe, ka nde wamuleeli: «Vutuu ku nzo a we, kwaa kaanda la we. Yaabisa bo mioosi mi Pfumu ayilii mu we, bu akwiilili we ngebe.» ");
INSERT INTO iyx_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ni mu buu, muutu wuu ayeni na abaandii mu uyaabisa mu itinini kia Dekapole, mioosi mi Yiisu ayilii mu nde, na baata boosi bakimii. ");
INSERT INTO iyx_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yiisu ayeni ku simi likimi mu bootu. Koongi a baata yakukini na yamudiengelili, bu nde ali atemene mu mukoo a maamba. ");
INSERT INTO iyx_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mosi mu bakuutu ba nzo a makutunu ma Bayuudayo, kuumbu Yayiro, ayiri. Bu nde amono Yiisu, abwiiri nha miili mia nde. ");
INSERT INTO iyx_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Nde aloombi Yiisu mu mukonono woosi, nde aleeli: «Mwaa mwaana a me wa mukaasa, nha peembi a likwa ali. Yanaa mioo nha yulu a nde paa nde avuu na aba moonyi!» ");
INSERT INTO iyx_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yiisu ayeni na nde. Koongi yinene ya baata yamuduki na bamupinyi mu mapeembi moosi. ");
INSERT INTO iyx_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kutso koongi yii, kwali na mukaasa mosi wakipala makili. Nde ali na ibeeri kii, umatuu bilimi kuumi na bioolo. ");
INSERT INTO iyx_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nde amoni pasi dialaa, mu mbuyili a babuyi balaa. Nde amani mboongo dia nde dioosi, na a abeelii pe, ka pasi diakibwavululu. ");
INSERT INTO iyx_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nde ayuyi ma bakitsuu mu Yiisu. Nde ayiri ku mbisi a Yiisu mutso koongi, na abeembi ikutu kia nde. ");
INSERT INTO iyx_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Mundaa ti, nde akileele kutso mutimi a nde: «So me beembi so ndila bikutu bia nde, me sa vuu!» ");
INSERT INTO iyx_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Bu abeembi bikutu bia Yiisu, nhaa-na-tsi, makili makangimi. Nde amoni mutso nyutu a nde ti, nde beelii mu ibeeri kia nde. ");
INSERT INTO iyx_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mu taanga diina dii, Yiisu ayaabi mu indemakulu ti litu lapali mu nde. Nde asieetii nha kati a koongi, na afuuli: «Na beembi bikutu bia me?» ");
INSERT INTO iyx_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Miyii mia nde miamuvutili: «We li mu umono bu koongi yili mu upinyi we mu mapeembi moosi, ka we li mu ubwafuulu ti na beembi we?» ");
INSERT INTO iyx_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ka Yiisu atali mwadiengelele nde, mu umono muutu wasiiri buu. ");
INSERT INTO iyx_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mukaasa atehiti mu boomo, mundaa ti nde ayaabi mamayilimi mu nde. Nde ayibwa nha miili mia Yiisu na aleeli nde ngwanya yoosi. ");
INSERT INTO iyx_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yiisu aleeli kwaa nde: «Mwaana a me, imiini kia we ivuuyisi we. Yene mu iyeenge, na beeluu mu ibeeri kia we.» ");
INSERT INTO iyx_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yiisu bu ali keni mu utsuu, baata bamati ku nzo a Yayiro, na baleeli kwaa nde: «Mwaana a we wa mukaasa maakwa. Mu ki toono dibwakwaamisa Muyiisi, paa ayiri ku nzo a we?» ");
INSERT INTO iyx_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ka Yiisu, bu ayuyi mandaa maa, aleeli kwaa Yayiro: «A ba na boomo pe, sa ndila imiini mu Nziaambi!» ");
INSERT INTO iyx_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yiisu a ahi muswa kwaa muutu mukimi mu uyayili nde pe, nha yulu a Peetero, Yaki na Yowani mukee a nde. ");
INSERT INTO iyx_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bo batoori ku nzo a Yayiro, ku Yiisu amoni nyingi-nyingi, na baata bakilili na uloo miloo miminene. ");
INSERT INTO iyx_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nde akoti na wabaleeli: «Nyingi-nyingi na bilili bi bia ima? Mwaana a akwa pe, nde tolo ala.» ");
INSERT INTO iyx_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ka bo bamusiiri saa. Ni mu buu nde apalisa bo boosi ku mbari, aholi taayi, nguu na miyii mia nde mitata. Tumake akoti na bo mu itsuru kia nzo kiali mwaana. ");
INSERT INTO iyx_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nde akaangi mwaana mu koo na wamuleeli mundaa ya ba Ebeleo: «Talita kuum!» — mambiindili ti: «Mufuru mukaasa, me ndeeli kwaa we, temene!» ");
INSERT INTO iyx_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nhaa na nhaa, mufuru mukaasa wali na bilimi kuumi na bioolo, atemini na abaandii udiaata. Bo bakimii kwalaa. ");
INSERT INTO iyx_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ka Yiisu wabalii mu mifuri mu unyaala uyaabisa yo kwaa muutu so mosi, na aleeli mu uha nde bia udia. ");
INSERT INTO iyx_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yiisu amati nha mbuu yii, na ayeni ku tsi a nde. Miyii mia nde miamuduki. ");
INSERT INTO iyx_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Iluumbu kia saba, nde abaandii uyiisi mu nzo a makutunu ma Bayuudayo. Babalayi mu babakiyuu nde bakimii na baleeli: «Kuni nde ali mu ubaa mandaa maa? Ba ki pili a buyeri baha kwaa nde, na buni bimaanga bi bili mu uyilimi mu mioo mia nde? ");
INSERT INTO iyx_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","A ni nde pe musalpanzi? Ngwanya ni nde mwaana a Mari, na mukulu a Yaki, a Yose, a Yude na Simooni! Bakeri ba nde a bali mu udiaala pe bisi nhaa na nha!» Mandaa maa moosi makikoonoso bo mu usa imiini mu nde. ");
INSERT INTO iyx_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Na Yiisu wabaleeli: «Bali mu umeengele mubili ndila mu tsi a nde, mu kaanda la nde na mu nzo a nde.» ");
INSERT INTO iyx_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Na nde a atuyi uyiluu imaanga so imosi nha bula ba nde pe, so a ni ndila unaa mioo nha yulu a babeeri babamosi na abeelisi bo. ");
INSERT INTO iyx_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Na nde akimii mundaa a pelili a imiini kia basi bula ba nde. Yiisu akidieenge mu malaa moosi mamadiengelele ngaanda a Nazareti, na akiyiisi. ");
INSERT INTO iyx_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nde ati miyii kuumi na mioolo mbila, na abaandii mu utsinduu bo boolo-boolo. Nde wabahi litu nha yulu a miheebili mimibi. ");
INSERT INTO iyx_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Na wabahi tumini yi: «A dibiti iloo so imosi pe mu mudieenge: so mapa pe, so kutu pe, so mboongo mu kobo pe, ka ndila mupaanga. ");
INSERT INTO iyx_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Dilwaata bikoori, ka a dibiti ikutu kia usobo pe.» ");
INSERT INTO iyx_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nde abwileele kwaa bo: «So bayaki beni mu nzo mosi, didiaala muu natee bu beni dimatuu mbuu yii. ");
INSERT INTO iyx_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","So bangaa bula bumosi, babisi uyaka beni na uyuu beni, dipala muu na dikubulu lifuundu la miili mia beni. Kio sa iba imbaangi ki imweese ti bo bayilii bubi nha kulu a Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ni mu buu miyii miayeni, na miayiisi baata mu usobo ndiaatili na uyiravutuu kwaa Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bo bakibingi miheebili mialaa mimibi, bakikili babeeri balaa maari na bakibeelese bo. ");
INSERT INTO iyx_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mutini Erode ayuyi bu bakitsuu mu Yiisu, mundaa ti kuumbu a nde ali ka na mvuungu. Babamosi bakileele: «Yowani Mubootii maasiimbuu mu babakwa! Ni mu buu nde ali na litu la uyiluu bimaanga.» ");
INSERT INTO iyx_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bakimi baleeli: «Ngwanya nde ni mubili Eliya.» Bana bakimi: «Nde ni mubili a Nziaambi. Nde li weti mosi mu mibili mimikulu.» ");
INSERT INTO iyx_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Erode ayuyi moosi ma bakitsuu, na nde aleeli: «Ni Yowani Mubootii! Me natumu bamukese mutswe, ka nde maasiimbuu mu babakwa!» ");
INSERT INTO iyx_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Mutini Erode ali atumu bakaanga Yowani, bakutulu nde bibolo na badumunu nde mu perese. Nde ayilii buu mu toono a mukaasa mosi wa kuumbu Erodiade, wu Erode ali akweeli, so bu nde ali mukari a mwaana a nguu a nde Filipo. ");
INSERT INTO iyx_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ka Yowani akileele kwaa Erode: «We ali na muswa pe wa uholo mukari a mwaana a nguu a we!» ");
INSERT INTO iyx_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ni mu buu, Erodiade abeli Yowani kwalaa na akisaa ti badusu nde, ka a akituu pe. ");
INSERT INTO iyx_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Erode ali na boomo ba Yowani, mundaa ti nde ali ayaaba ti Yowani ali muutu walibweeye. Nde akiyiluu litoono la Nziaambi, na Erode akikala nde. Mu taanga di nde akiyuu Yowani, nde akimono mutimi pasi. Ka bunu, nde ali atoono uyuu mandaa ma Yowani. ");
INSERT INTO iyx_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ka taanga dimbwe diamonii kwaa Erodiade, mu iluumbu kia mukuungi a mbutili a Erode. Erode ayilii ndaamba kwaa baata ba nde balikiinzi, bakuutu ba masodaare na biyeri bia itinini kia Ngalili. ");
INSERT INTO iyx_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mwaana a Erodiade wa mukaasa akoti mu itsuru kia nzo, na akini nha kulu a baata boosi. Nde amweesi kinyi kwaa Erode na kwaa baata ba nde atumisi. Ni mu buu, mutini aleeli kwaa nduumbu mukaasa: «Loombo me pasi ki we atoono, na me sa ha we kio.» ");
INSERT INTO iyx_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Na nde alabi mukisi wu kwaa nde: «Pasi ki we uloombo kwaa me, me sa ha we kio, so yaba ibari kia itini kia me.» ");
INSERT INTO iyx_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nduumbu mukaasa apali na aleeli kwaa nguu a nde: «Ima me ni loombo?» Nguu avutili: «Mutswe a Yowani Mubootii.» ");
INSERT INTO iyx_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nduumbu mukaasa avutii mawasa kwaa mutini, na asiiri nde ndoombili yi: «Me tooni ti we ha me, liaalili, mutswe a Yowani mubootii mutso ikoombo!» ");
INSERT INTO iyx_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mutini amoni ngebe dialaa. Ka nde a atuyi pe ubisi ndoombili a nduumbu mukaasa, mu ndaa ya mikisi mi nde alabi nha kulu a baata ba nde ba atumisi ku mukuungi. ");
INSERT INTO iyx_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nde atsindii mu mawasa lisodaare limosi mu babakikebe nde, na tumini ya ubee mutswe a Yowani mubootii. Lisodaare layeni ku perese na lakesi mutswe a Yowani. ");
INSERT INTO iyx_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Tumake nde abeyi mutswe a Yowani nha tso ikoombo, na ahi nde kwaa nduumbu mukaasa. Nduumbu ka ahi nde kwaa nguu a nde. ");
INSERT INTO iyx_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mu taanga di miyii mia Yowani miayuyi ndaa yii, bo bayeni mu uholo nyutu a nde na basuusi yo mutso ngili. ");
INSERT INTO iyx_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Batumu ba Yiisu bakukini nha peembi a nde, na bamuyaabisi mioosi mi bo bayilii na uyiisi. ");
INSERT INTO iyx_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nde wabaleeli: «Diyiri na me nha mbuu yahele a baata, paa beni diwuumu hoolo, nha taka.» Nde aleeli buu, mundaa ti, baata bakiyene na bakiyiri ali balaa, kuli ti Yiisu na miyii mia nde bakooni so ubaa taanga dia udia. ");
INSERT INTO iyx_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tumake, bo bayeni mutso bootu, ku mbuu mosi yahele a baata, nha taka. ");
INSERT INTO iyx_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ka baata balaa bamoni bo mu uyene na bayaabi ku bakiyene. Ni mu buu, bo bamati mu mangaanda moosi mamabesene, na bakwito nha mbuu yii mu miili tswaamina Yiisu na miyii mia nde buto. ");
INSERT INTO iyx_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Bu Yiisu apali mu bootu, nde amoni koongi yalaa. Nde amoni ngebe ku mutimi mu ndaa baata baa, mu ndaa ti bo bali weti mameme mamahele na mukebi. Na nde abaandii uyiisi bo mandaa malaa. ");
INSERT INTO iyx_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Bu bwisi bali baka mu uyili, miyii miasweesi kwaa nde na miamuleeli: «Busi buka mu uyili, na baata a bubaadiaala pe nha mbuu yi. ");
INSERT INTO iyx_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Vutulu baata ba bayene mu misieenge na mala mamadiengelele, bayasuumbu bia udia.» ");
INSERT INTO iyx_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yiisu avutili kwaa bo: «Diabaha bia udia beni bame!» Bo bafuuli nde: «We tooni ti bisi diyasuumbu mapa ma makama moolo ma mikuti mia mboongo, paa diha bo bia udia?» ");
INSERT INTO iyx_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yiisu wabaleeli: «Mapa kwe beni dili na mo? Diyene dimono.» Bo bayifuulu na bamuleeli: «Bisi dili na mapa mataana na batswi boolo.» ");
INSERT INTO iyx_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ninha Yiisu wabatumi mu udiaala mu makaba, nha yulu a bitiiti bi bibisi. ");
INSERT INTO iyx_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Baata badiaali mu makaba. Makaba mana ali baata kama, na makimi ali baata maku mataana. ");
INSERT INTO iyx_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yiisu aholi mapa mataana na batswi boolo. Nde asiimbili misi ku yula na avutili matoono kwaa Nziaambi. Nde abukili mapa me, na ahi mo kwaa miyii paa bo bakaba mo kwaa baata. Nde akabi ka batswi bo baboolo nha kati a bo boosi. ");
INSERT INTO iyx_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Muutu muutu adiiri na ayutii. ");
INSERT INTO iyx_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Batoli na babiti bitsuru bia mapa masiaalili na bia batswi basiaali, baluusi bitungu kuumi na bioolo. ");
INSERT INTO iyx_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Litaanga la babadiiri mapa, ali mafuundu mataana ma babaala. ");
INSERT INTO iyx_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nha mbisi, Yiisu atumi miyii mia nde mu ukoto mu bootu. Nde ayilii buu, paa bo batswaamina nde ku simi la diaanga lilimosi, mu taanga di nde makulu uvutulu koongi. Simi la diaanga lii, ali ku peembi a ngaanda ya Betesayida. ");
INSERT INTO iyx_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Bu amani na uvutulu baata, nde ahaati ku yulu a mulaanda mu ukuundu Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tsitsii bu yatoori, bootu me lii ali nha kati a kati a diaanga, na Yiisu nde makulu nha simi. ");
INSERT INTO iyx_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nde amoni ti miyii mia nde miali na pasi dialaa mu ubiti bootu, mundaa ti iteembi yakibwaana bo. Ku peembi a makia ma bwisi, nde ayeni ku peembi a bo, bu akidiaata nha yulu a mukaanda a maamba ma diaanga, na atooni ulabuu bo. ");
INSERT INTO iyx_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Bo bu bamoni Yiisu mu udiaata nha yulu a diaanga, bo batsimi ti iduuru, na bo baloyi mingiri. ");
INSERT INTO iyx_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ni mu buu, bo boosi bamumoni na babayi ikuuhulu. Ka nhaa-na-tsi, nde atsuyi kwaa bo, wabaleeli: «Diba ibaala! Ni me, a diba na boomo pe!» ");
INSERT INTO iyx_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tumake nde akoti mu bootu li bo bali, na iteembi kiawuri. Miyii miakimii kwalaa, ");
INSERT INTO iyx_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ka bo a babayi mbahala so hoolo pe mu ndaa imaanga ki nde ayilii mu mapa, mundaa ti bo bali keni kutso bundimbi. ");
INSERT INTO iyx_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Bu bamani na usabuu diaanga, bo batoori mu itinini kia Ngenesareti. ");
INSERT INTO iyx_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Bo bapali mu bootu, na nhaa-na-tsi, baata bayaabi Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ni mu buu baata bayeni mu itinini kioosi, na babaandii ubee babeeri kwaa nde. Bo bakibee babeeri nha yulu a malaba, kuu kubayuyi bu bakileele: «Yiisu nhaa ali!» ");
INSERT INTO iyx_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Mu mambuu moosi ma nde ayeni, mutso mala, mu magaanda na mu misieenge, baata bakisuusu babeeri mu mafulu. Bo bakipele nde anyaala bo babeembe so ndila ndeengi a ikutu kia nde. Boosi bababeembi nde, babeelii. ");
INSERT INTO iyx_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Bafarisi na ndaamba a bayiisi ba mikele babamati ku ngaanda a Yeruselemi, bakukini na badiengelili Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bo bamoni babamosi mu miyii mia nde mu udia biloo bia bo na mioo mia mviindi, pili mosi ti mibahele uswaa weti buli bukulu ba bo. ");
INSERT INTO iyx_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mundaa ti Bafarisi, weti Bayuudayo boosi, bali bakangama mu bukulu ba bakaa ba bo. Bo a bali mu udia pe, kwahele a uswaa mioo mu bungeele. ");
INSERT INTO iyx_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Bu bo bali mu umata ku kooyi, bo a bali mu udia pe tswamina a uyitili maamba mu nyutu. Bo bali mu uyiluu ukiinzi biyiluu bikimi: tswayili a mambuungu, mambasa, na bikoombo bia biseenge. ");
INSERT INTO iyx_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ni mu buu, Bafarisi na bayiisi ba mikele bali mu ufuulu Yiisu: «Mu ima miyii mia we mibaahele uduku bukulu ba bakaa? Na mu ima bali mu udia biloo bia bo na mioo mia mviindi?» ");
INSERT INTO iyx_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yiisu wabavutili: «Beni dili ba ngaa peluu! Yeesaya ali na buungu bu akiyaabisa mandaa mamati kwaa Nziaambi, mabasonuu mu toono a beni: “Baata ba bali mu ukiinzi me ndila mu bibori bia bo, ka mitimi mia bo miatakuu na me. ");
INSERT INTO iyx_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mu ibuu baata ba bali mu ukuundu me. Nziisili yi bo bali mu uyiisi, yili ndila ya mikele miamata kwaa baata.” ");
INSERT INTO iyx_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Beni dili mu usuusu mikele mia Nziaambi nha peembi, mu uduku bukulu ba baata.» ");
INSERT INTO iyx_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yiisu abwileele kwaa bo: «Beni dili na ngo mayele mu ubumu tumini dia Nziaambi, paa dihamisa bukulu ba beni bame! ");
INSERT INTO iyx_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","A mu ibuu pe Mooso aleeli: “We sa kiinzi taayi a we na nguu a we.” Na aleeli ka: “Wuu wu usibi taayi a nde so nguu a nde, nyaala nde abaa tsieembili ya likwa.” ");
INSERT INTO iyx_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ka beni dili mu uleele kwaa muutu: “We li na muswa mu uleele kwaa taayi a we so kwaa nguu a we ti, bi we akeeha nde mu ubaasila nde, we amaatasila bio mu uha bungori kwaa Nziaambi.” We li mu uleele ti: “Biloo bii Korobani.” ");
INSERT INTO iyx_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ni mu buu, beni dili mu uha muswa kwaa muutu wuli mu uhele ubwaha libaasila, kwaa taayi a nde so kwaa nguu a nde! ");
INSERT INTO iyx_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mu pili yii, beni dili mu udusu Mandaa ma Nziaambi, mundaa bukulu ba beni badili mu uyene a yiisi beni na beni. Na beni dili mu uyiluu mandaa malaa makimi ma mutindi wuu.» ");
INSERT INTO iyx_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yiisu abwita koongi a baata mbila, na nde wabaleeli: «Ditete matswi, beni boosi, na diyiluu uyuu me. ");
INSERT INTO iyx_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","A uli na iloo pe kia ku mbari a muutu, kii ituu usumunu nde, bu kio ikoti mu nde. Ka kili mu upala mu muutu, ni kio kili mu usumunu nde.»  ");
INSERT INTO iyx_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Wuli na matswi ma uyuu, nyaala ayuu! ");
INSERT INTO iyx_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yiisu bu atakii na koongi, na akoti mu nzo, miyii mia nde miamufuuli manduru mundaa a tsaba yii. ");
INSERT INTO iyx_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Na nde wabaleeli: «Beni ka a dili na mayele pe? A dili mu uyuu pe? A uli na iloo so imosi pe kia ku mbari, ki ituu usumunu muutu bu kio ikoto mu nde. ");
INSERT INTO iyx_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mundaa ti biloo bii a bili mu ukoto pe kutso mutimi a nde, ka bili mu kulunu mu moonyo a nde, na nha mbisi bili mu upala mu nyutu a nde.» Mu mandaa maa, Yiisu ayaabisi ti biloo bioosi bia udia bili biatsieeme. ");
INSERT INTO iyx_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nde abiindili kwaa miyii mia nde: «Ni maa mamupala mu muutu, mali mu usumunu nde. ");
INSERT INTO iyx_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Mundaa ti ni mu mutimi a muutu, matsimi mamabi mali mu umata. Ni matsimi maa mali mu utsindi nde mu udiaala mutso ipuupu, mu uyibi, mu udusu baata, ");
INSERT INTO iyx_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","usoongo, nzala ya ubaa kwalaa, uyiluu mamabi, ufutu pia, uyiluu mandaa ma tsionyi, uba na linyungu, utuu bitari, uba na liwaa na buwulu. ");
INSERT INTO iyx_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mandaa mamabi maa moosi mali mu umata ku kati a muutu, na mali mu ukitisi nde mu uba wasumuu.» ");
INSERT INTO iyx_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Bu Yiisu amati nhaa, nde ayeni ku itinini kia ngaanda a Tiro, na nde akoti mu nzo mosi. Nde a atooni pe ti muutu so mosi ayaaba, ka a atuyi usweeme pe. ");
INSERT INTO iyx_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mukaasa mosi, wali na mwaana wa mukaasa wu bakikwaamisa kwaa muheebili wu mubi, ayuyi bubakitsuu mu nziriri a Yiisu. Nhaa na nhaa, nde ayibwa nha miili mia Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mukaasa wuu ali musi Eleene, abutii ku Fenisi ya ku itinini kia Siri. Nde aloombi Yiisu paa abingi muheebili wu mubi wali mu mwaana a nde. ");
INSERT INTO iyx_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ka Yiisu aleeli kwaa nde: «Kwanyaala ti baana badia nha tsitsi a yuutu la bo; ka a bwafwaana pe mu uholo mapa ma baana, na udumunu mo kwaa baana ba bambwa.» ");
INSERT INTO iyx_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mukaasa wuu avutili kwaa nde: «Pfumu, baana ba bambwa ka, kutsini a meese, bali mu udia bifufuri bia mapa ma baana.» ");
INSERT INTO iyx_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ni mubuu Yiisu aleeli kwaa nde: «Mundaa mvutu yii, vutuu ku nzo a we! Muheebili wu mubi maapala mu mwaana a we wa mukaasa.» ");
INSERT INTO iyx_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nde avutii ku nzo a nde, na kuu, nde ayibaasa mwaana ala wa nde nha yulu a mbuu. Mundaa ti muheebili wu mubi, ali amaapala mu nde. ");
INSERT INTO iyx_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yiisu asiisi itinini kia Tiro, ayiri avutuu mu kuulu ya Sidoni ku peembi a diaanga la Ngalili, mu kati a itinini kia Dekapole. ");
INSERT INTO iyx_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Baata babeyi kwaa Yiisu muutu wakwa matswi, wali ka baba. Bo bapeli Yiisu mu unaa koo nha yulu a muutu wuu, paa abeelese nde. ");
INSERT INTO iyx_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yiisu aholi nde na atakii na koongi. Nde aloosi mileembi mia nde mu matswi ma muutu wuu, atswiili mate mu mileembi mia nde makulu na abeembi lilimi la muutu wuu. ");
INSERT INTO iyx_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tumake nde asiimbili misi ku yula, akoyi iwuumu na aleeli kwaa muutu wuu: «Efata!» Mambindili: «Dibimi!» ");
INSERT INTO iyx_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nhaa na nhaa, matswi madibimi, lilimi lanyangii na nde atsuyi weti bwafwaana. ");
INSERT INTO iyx_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yiisu atumi kwaa baata mu uhele uyaabisa yo kwaa muutu. Ka bu akihama mu ulii bo, bo ka bakihama mu utsara mvuungu. ");
INSERT INTO iyx_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Baata bakikimuu kwalaa. Bo bakileele: «Mioosi mi nde ali mu usa, mili mi mibwe! Nde li mu ubwayuusu babakwa matwsi, na ubwatsuusu mababa!» ");
INSERT INTO iyx_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mu biluumbu bii, koongi a baata yabwikukunu. Bu koongi yii a yali na bia udia pe, Yiisu ati miyii mia nde mbila, na wabaleeli: ");
INSERT INTO iyx_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Me ndi na ngebe a koongi yi, mundaa ti biluumbu ka bitata bo bali na me nha, na bo ka bia udia pe. ");
INSERT INTO iyx_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Babamosi mu bo bamata ku la. So me mvutili bo mu manzo ma bo kwahele a udia, bo sa bamono pasi mu kuulu.» ");
INSERT INTO iyx_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Miyii miavutili kwaa nde: «Kuni dituu ubaa mapa mu uha bo badia na bayutuu, nha mbuu ya tsata yiinayi?» ");
INSERT INTO iyx_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yiisu wabafuuli: «Mapa kwe beni dili na mo?» Bo baleeli: «Tsaamba». ");
INSERT INTO iyx_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nde atumi koongi mu udiaala nha tsi. Tumake aholi mapa tsaamba, avutili matoondo kwaa Nziaambi, abukili mo na ahi mo kwaa miyii mia nde, paa bo bakaba mo kwaa baata boosi. Miyii ka miayilii buu. ");
INSERT INTO iyx_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bo bali ka na ndaamba a batswi ba bake-bake. Yiisu avutili matoondo kwaa Nziaambi mu ndaa a batswi baa, na aleeli kwaa miyii mia nde mu ukaba ka bo kwaa baata boosi. ");
INSERT INTO iyx_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Boosi badiiri na bayuuti. Miyii miatoli bikesi biasiaalili, na mialuusi bitungu tsaamba mu bikesi bii. ");
INSERT INTO iyx_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Babadiiri ali helape mafuundu mana ma baata. Tumake Yiisu wabavutili mu manzo ma bo. ");
INSERT INTO iyx_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nha mbisi a nhaa, nde ahaati mu bootu na miyii mia nde na ayeni ku itinini kia Dalamanuta. ");
INSERT INTO iyx_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bafarisi bayiri na babaandii utsuu na Yiisu, paa balebuu nde mweete. Bo basiayi mu ubaa kwaa nde, iliimbi ki imatuu ku yula. ");
INSERT INTO iyx_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yiisu akoyi iwuumu kia nde mu ngebe dialaa, na aleeli: «Mu ima kubu yi ili mu uloombo iliimbi? Mu ngwanya, me nadileeli: a uli na iliimbi so imosi pe kibumweese kwaa kubu yi!» ");
INSERT INTO iyx_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tumi nde wabasiisi, abwikoto mu bootu na ayeni ku simi likimi. ");
INSERT INTO iyx_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Miyii miadiimbili mu ubiti mapa, ka ndila lipa limosi lali na bo mutso bootu. ");
INSERT INTO iyx_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yiisu wabahi tumini di: «Diyuu bubwe! Disa mayele mu lifunusu la mapa la Bafarisi na la mutini Erode.» ");
INSERT INTO iyx_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ka miyii miakitsuu bo na bo, mundaa ti bo a bali na mapa pe. ");
INSERT INTO iyx_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yiisu ayaabi mandaa ma bo bakitsuu, na wabafuuli: «Mu ima beni dili mu ulelesene nha kati a beni ti, beni a dili na mapa pe? Beni keni a diayaaba pe? Dili mu ubisi uyuu? ");
INSERT INTO iyx_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Beni dili na misi, ka a dili mu umono pe? Beni dili na matswi, ka a dili mu uyuu pe? Beni a dili mu ulibili moonyi pe, ");
INSERT INTO iyx_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","bu me nabukili mapa mataana mundaa a mafuundu mataana ma baata? Bitungu kwe bialuulu mu bitsuru beni diabiti?» Bo bavutili kwaa nde: «Kuumi na bioolo». ");
INSERT INTO iyx_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yiisu abwifuulu: «Beni a dili mu ulibili moonyi pe, bu me nabukili mapa tsaamba mundaa a mafuundu mana ma baata? Bitungu kwe bialuuli mu bitsuru beni diabiti?» Bo bavutili kwaa nde: «Tsaamba». ");
INSERT INTO iyx_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ninha Yiisu aleeli kwaa bo: «Buni beni a dili mu utuu pe uyaaba?» ");
INSERT INTO iyx_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Bo batoori ku ngaanda a Betesayida, baata babeyi ingimangimi imosi kwaa Yiisu, na bamuloombi mu ubeembe nde paa abeeluu. ");
INSERT INTO iyx_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yiisu akaangi ingimangimi mu koo, na wamubiti ku mbari a bula. Nde wamukili mate mu misi, anayi mioo nha yulu a ingimangimi. Yiisu wamufuuli: «We li mu umono iloo?» ");
INSERT INTO iyx_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ingimangimi kiadibili misi, na kialeeli: «Me ndi mu umono baata, me ndi mu umono bo weti miti mili mu uyene.» ");
INSERT INTO iyx_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yiisu abwinaa mioo mia nde nha yulu a misi mia muutu wuu, nde amoni na yalalaa. Muutu me abeelii, na amoni bioosi biayaluu. ");
INSERT INTO iyx_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ni mubuu Yiisu atsindii nde ku nzo a nde, bu wamuleeli: «A koto so hoolo mutso bula pe.» ");
INSERT INTO iyx_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tumake Yiisu na miyii mia nde, bayeni ku peembi a mala mabesene na itinini kia Kayisari ya Filipo. Mu kuulu, nde afuuli kwaa bo: «Ima baata bali mu uleele, me na ndi?» ");
INSERT INTO iyx_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bo bamuvutili: «Babamosi bali mu uleele ti we Yowani Mubootii, bana ti we mubili Eliya, na bakimi ka ti we li mosi mu mibili mimikulu.» ");
INSERT INTO iyx_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yiisu abwifuulu bo: «A ka beni bame buni dileeli? Kwaa beni me na ndi?» Peetero avutili kwaa nde: «We ni Kristo!» ");
INSERT INTO iyx_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ni mu buu, Yiisu wabatumi mu ibaala mu uhele utsuu mu nde, kwaa muutu so mosi. ");
INSERT INTO iyx_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yiisu abaandii mu uyiisi bo ti, aba bwafwaana ti Mwaana a muutu amono pasi dialaa. Bakuutu ba Bayuudayo, banguu ba bangaanga ba Nziaambi, na kwaa bayiisi ba mikele sa babisi nde. Bo sa badusu nde, na nha mbisi a biluumbu bitata, nde sa asiimbuu mu babakwa. ");
INSERT INTO iyx_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nde ayaabisi bo mandaa maa na yaki-yaki. Ni mu buu Peetero wamubiti nha peembi, na abaandii mu usieembe nde. ");
INSERT INTO iyx_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ka Yiisu asieetii, atali miyii mia nde, na afweengi Peetero mu kakabi: «Saatina! Swese ku naa, mata nha kulu a me! Mundaa ti matsimi ma we a mali matsimi ma Nziaambi pe. Ka matsimi ma we matsimi ma baata.» ");
INSERT INTO iyx_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yiisu ati koongi na miyii mia nde mbili, na wabaleeli: «So muutu tooni uduku me, anyaala utsimi mu nde makulu, ka abiti kuruwa a nde na aduku me. ");
INSERT INTO iyx_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mundaa ti, pasi nde watoono uvuusu idiingi kia nde, sa ahelele kio. Ka wu uhelele idiingi kia nde mu toono a me, sa avuusu kio. ");
INSERT INTO iyx_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ki ndaanda muutu ubaa, so nde bayi busini ba tsi yoosi, na nde fuyisi idiingi kia nde? ");
INSERT INTO iyx_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ki isii muutu utuu uha paa asuumbu muwuumu a nde kwaa Nziaambi? ");
INSERT INTO iyx_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","A dimono tsionyi mu me na mu mandaa ma me pe, nha kulu a kubu yi yahele ukangama mu Nziaambi na utumumu nde. So beni dimoni tsionyi mu me, Mwaana a muutu ka, sa amono tsionyi mu beni, bu akaayira mu buzitu ba Taayi a nde, na batumu ba ngira.» ");
INSERT INTO iyx_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Nde abwileele kwaa bo: «Me ndeeli kwaa beni! Ngwanya, babamosi mu babali nha a bukwa pe, kwahele a umono Ipfumu kia Nziaambi mu uyiri mu lituu.» ");
INSERT INTO iyx_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nha mbisi a biluumbu bisamina, Yiisu aholi itwaari na nde Peetero, Yaki na Yowani. Nde wababiti bo bake, ku yulu a mulaanda wu mula. Mu taanga di bo bakitala nde, Yiisu amonii kwaa bo mu ifwaani ki ikimi. ");
INSERT INTO iyx_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Bikutu bia nde biahembii na pee, na biangeyini kwalaa, kuli ti muutu so mosi pe nha tsini a toto, wu utuu uhembese ikutu pili yii. ");
INSERT INTO iyx_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mibili mio miamioolo Mooso na Eliya, miamonii kwaa miyii mio mitata. Bo baboolo bakitsuu na Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peetero abaandii utsuu, na aleeli kwaa Yiisu: «Muyiisi, bubwe bisa-beni dibaanani nha. Dituungani bituru bitata: imosi kia we, imosi kia Mooso, na imosi kia Eliya.» ");
INSERT INTO iyx_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nde a ayaabi ya uleele pe, mundaa ti bo bali na boomo balaa. ");
INSERT INTO iyx_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tumake, tuti layiri na layifuu bo, na ndaa mosi yayuyini kutso tuti. Ndaa yii yaleeli: «Wuunawu ni Mwaana a me wa litoono ndaa, diyuu nde!» ");
INSERT INTO iyx_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Itsundu-a-tsundu, miyii bu miatali peembi na peembi, bo bamoni ndila Yiisu nde bake, itwaari na bo. ");
INSERT INTO iyx_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Bu bo bakisutuu mulaanda, Yiisu wabatumi mu uhele uleele kwaa muutu so mosi mandaa ma bo bamaamono. Bawuru na pii, natee bu Mwaana a muutu usiimbuu mu babakwa. ");
INSERT INTO iyx_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Bo baduki tumini dii, ka bo bafulisini bo na bo mambiindili ma «Usiimbuu mu babakwa». ");
INSERT INTO iyx_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bo bahi Yiisu manduru: «Mu ima bayiisi ba mikele bali mu uleele ti mubili Eliya ufwaana ukwayiri?» ");
INSERT INTO iyx_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nde wabavutili: «Ee-e ni buu, Eliya afwaana ukwayiri mu uvutulu bungeele mu bioosi. Ka mu ima Mabasonuu mali mu uyaabisa ka ti Mwaana a muutu sa amono pasi dialaa, na sa babisi nde? ");
INSERT INTO iyx_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ee-e, me ni yaabisa kwaa beni: Eliya amaayiri, na baata bamuyilii mioosi mi batooni. Ni buu, Mabasonuu ma Ngira mayaabisi mu toono a nde.» ");
INSERT INTO iyx_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mu taanga di bo batoori nha yali miyii mikimi, bo bamoni koongi a baata yalaa yadiengilili bo, na bayiisi ba Mikele bakitsuu na bo. ");
INSERT INTO iyx_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Bu koongi yamoni Yiisu, yo yakimii, na baata bayiri mu matiini mu ubii nde. ");
INSERT INTO iyx_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yiisu wabafuuli: «Mu ki ndaa dili mu utsuu na bo?» ");
INSERT INTO iyx_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Muutu mosi mutso koongi avutili kwaa nde: «Muyiisi, me maabee we mwaana a me wa baala, mundaa ti na muheebili wumubi wuli mu ukwaamisanga nde na ubaakitisanga nde baba. ");
INSERT INTO iyx_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Taanga dioosi muheebili wuu, ubaakaanganga nde, na ubaabalanga nde nha tsini, pasi mbuu yi nde ubaasa nde. Mwaana li mu upalisa mafuri mu munywa na ukweete mini, na nyutu a nde yimaatilili. Me naloombi kwaa miyii mia we mu ubingi muheebili wuu, ka bo a batuyi pe.» ");
INSERT INTO iyx_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yiisu ayaabisi kwa bo: «Kubu yakoono usa imiini mu Nziaambi, natee ki taanga me nafwaana uba na beni? Natee ki taanga me nafwaana ubiti mufunu a beni? Dibee me mwaana.» ");
INSERT INTO iyx_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bamubeyi mwaana. Bu muheebili amoni Yiisu, nhaa-na-tsi, nde anyingisi mwaana mu mifuri. Mwaana abwi nha tsi, akiyene akilimini na upalisa mafuri mu munywa. ");
INSERT INTO iyx_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yiisu afuuli taayi: «Umatuu ki taanga muheebili wuu abaandii mu ukwaamisa nde?» Taayi avutili: «Umatuu bungebe ba nde. ");
INSERT INTO iyx_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Taanga dialaa muheebili atsinduu nde ku mbaa, so a buu pe, mu maamba mu udusu nde. Ka so we utuu uyiluu ndaa, kwiilili bisi ngebe na yiri baasila bisi!» ");
INSERT INTO iyx_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yiisu avutili: «“So we utuu uyiluu ndaa”, bu we leeli. Ka moosi utuu uyilimi kwaa wu usa imiini mu Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nhaa-na-tsi, taayi a mwaana aloyi: «Me siiri imiini, baasila me, mu ndaa ti pasi kwaa me mu usa imiini!» ");
INSERT INTO iyx_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yiisu amoni ti koongi a baata yakukini. Ni mu buu, nde afweengi muheebili wumubi, na aleeli kwaa nde: «Muheebili wuli mu ukitisi baba na ingimagimi, me tumi we mu upala mu mwaana wu, na a bwavutuu mu nde pe!» ");
INSERT INTO iyx_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Muheebili aloyi mingiri, anyingisi mwaana mu mifuri, na apali mu nde. Mwaana wa baala ali ka weti wakwa, na baata balayi bakileele: «Nde maakwa.» ");
INSERT INTO iyx_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ka Yiisu akaangi nde mu koo, wamutemisi na mwaana atemini. ");
INSERT INTO iyx_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Bu Yiisu avutii ku nzo, na miyii mia nde bu miali miobake na nde, bo bamufuuli: «Mu ima bisi diakoono ubingi muheebili wuu?» ");
INSERT INTO iyx_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yiisu avutili: «Mu ndila likuundu butuu upalisa muheebili wapili yii.» ");
INSERT INTO iyx_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Bu bamati nhaa, bo basiabii itinini kia Ngalili. Yiisu ali a atoono pe ti, muutu so mosi ayaaba mbuu yi bo bali. ");
INSERT INTO iyx_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Mundaa ti, nde ali na nzala ya uyiisi miyii mia nde. Nde aleeli kwaa bo: «Mwaana a muutu sa bayeelele nha mioo mia baata, na bo sa bamudusu. Na nha mbisi a biluumbu bitata, nde sa asiimbuu mu babakwa.» ");
INSERT INTO iyx_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ka miyii a miabahili pe mandaa maa, na bo bali na boomo mu ufuulu nde manduru. ");
INSERT INTO iyx_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bo batoori ku ngaanda Kapernawumi. Mu taanga di nde ali mutso nzo, Yiisu aheeri miyii mia nde manduru: «Ki toono beni dibeeri asa paa mu kuulu?» ");
INSERT INTO iyx_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ka bo bawuri, mundaa ti, mu kuulu, bo na bo bakiyene ayolo paa bayaaba na mu bo wali wavulu mu bunene. ");
INSERT INTO iyx_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ni mu buu Yiisu adiaali, nde ati kuumi na boolo mbili na wabaleeli: «So muutu tooni uba watsiomi, nde afwaana uba watsieelele mu boosi, na ngaamba a boosi.» ");
INSERT INTO iyx_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ni mu buu nde aholi imwamwaana, na wamutemisi nha kati a kati a bo. Nde wamunyumbiti na wabaleeli: ");
INSERT INTO iyx_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Wuu wu uyaka imwamwaana weti kiinaaki, mu kuumbu a me, ni me nde amaayaka. Na wuu wu uyaka me, a me pe nde ayaki, ka wuu watsinduu me.» ");
INSERT INTO iyx_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yowani aleeli kwaa Yiisu: «Muyiisi, bisi dimoni muutu mosi li mu ubingi miheebili mimibi mu kuumbu a we. Na bisi diamuleeli, mu unyaala mu ndaa ti nde ali mu kaba la bisi pe.» ");
INSERT INTO iyx_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ka Yiisu avutili: «A diamulii pe, ka muutu utuu pe uyiluu imaanga mu kuumbu a me, na nhaa mbisi nhaa, nde leeli ndaa yimbi mu me. ");
INSERT INTO iyx_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mundaa ti, wuli a mutaata a bisi pe, li wa bisi. ");
INSERT INTO iyx_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Na pasi nde wu uha beni mbasa a maamba ma unywa, mundaa ti beni dili ba Kristo, ngwanya me nadileeli, nde a uhelele pe musieende a nde.» ");
INSERT INTO iyx_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Pasi nde wu ubwiisi mu masumu, mosi mu bibabaana bibili mu usa imiini mu me, yavulu bubwe kwaa nde bamukutulu limanya li linene mu kiingi, na bamudumunu mu mubu. ");
INSERT INTO iyx_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","So ni mundaa koo kia we, we ubwa mu masumu, kese kio. Mundaa ti, yavulu bubwe kwaa we, mu ukoto mu moonyi wa ngwanya na ndila koo imosi. Uyiluu buu yavulu bubwe, ka a mu uba pe wu ukoto na mioo mioolo ku mbuungulu, ku mbaa yi yihele udimi.  ");
INSERT INTO iyx_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","So ni mundaa kuulu kia we, we ubwa mu masumu, kese kio. Mundaa ti, yavulu bubwe kwaa we mu ukoto mu moonyi wa ngwanya, na ndila kuulu imosi. Uyiluu buu yavulu bubwe, ka a mu uba pe wu ukoto na miili mioolo ku mbuungulu, ku mbaa yi yihele udimi.  ");
INSERT INTO iyx_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na so ni mundaa lisi la we, we ubwa mu masumu, sootolo lo. Mundaa ti, yavulu bubwe kwaa we mu ukoto mu moonyi wa ngwanya na ndila lisi limosi. Ka a mu uba pe wubudumunu ku mbuungulu na misi mio mia mioolo. ");
INSERT INTO iyx_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kuu, “misiobi a mili mu ukwa pe, na mbaa a yili mu udimi pe.” ");
INSERT INTO iyx_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Nziaambi sa anaa mbaa nha yulu a pasi muutu, weti bu baata bali mu usa mungwa mu biloo.» ");
INSERT INTO iyx_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","«Mungwa iloo ki ibwe! Ka so mungwa helili isie kia nde, buni beni dikaavutulu nde kio? Diba na mungwa mu beni bame, na diba na iyeenge beni na beni.» ");
INSERT INTO iyx_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yiisu amata nhaa na ayeni mu itinini kia Yuuda, na ku simi likimi la Yorodaani. Koongi a baata yabwikukunu, nha peembi a nde, na nde wabayiisi mandaa weti bwali ipfu kia nde. ");
INSERT INTO iyx_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bafarisi baswesii kwaa nde, mu ulebuu nde mweete. Bo bamufuuli: «Uli na muswa kwaa baala mu utsara makweele na ubingi mukari a nde?» ");
INSERT INTO iyx_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yiisu wabavutili: «Ki mukele Mooso wadihi?» ");
INSERT INTO iyx_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bo bavutili: «Mooso aha muswa kwaa baala mu usonuu mukaanda wa utsara makweele, na ubingi mukari a nde.» ");
INSERT INTO iyx_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ni mu buu, Yiisu wabaleeli: «Mooso asonii mukele wuu mu toono a beni, mundaa ti beni dili na mitimi mia minono. ");
INSERT INTO iyx_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ka mu mbaandili, Nziaambi ayilii bo “baala na mukaasa”, buleeli Mabasonuu. ");
INSERT INTO iyx_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Ni mu buu, baala sa asiisi taayi na nguu a nde, mu uba itwaari na mukari a nde, ");
INSERT INTO iyx_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na bo baboolo, sa baba musunyi mosi.” Ni mu buu bo a bubwaba pe baata boolo, ka muutu mosi. ");
INSERT INTO iyx_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ni mu buu, muutu pe wafwaana ukabala bi Nziaambi avuutu.» ");
INSERT INTO iyx_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Bu bavutii ku nzo, miyii miabwiha Yiisu manduru mu ndaa yii. ");
INSERT INTO iyx_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nde wabavutili: «Wuu wu ubingi mukari a nde, na kweeli mukaasa mukimi, nde soongi nha kulu a mukari watsiomi. ");
INSERT INTO iyx_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Na so mukaasa bingi mulumi a nde, na kweeli baala likimi, nde soongi.» ");
INSERT INTO iyx_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Baata babeyi bibabaana kwaa Yiisu, paa nde abeembe bio, ka miyii miasieembi bo. ");
INSERT INTO iyx_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Bu Yiisu amoni buu afweengi, na aleeli kwaa miyii mia nde: «Dinyala bibabaana biyiri kwaa me! A diabalii pe, mundaa ti Ipfumu kia Nziaambi ili kia babafwaanina na bo. ");
INSERT INTO iyx_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ngwanya, me nadileeli: muutu wu uhele uyaka Ipfumu kia Nziaambi weti imwamwaana, a utuu ukoto mu kio pe.» ");
INSERT INTO iyx_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tumake nde wababuumbi na wabasiemi, bu anayi bo mioo. ");
INSERT INTO iyx_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Mu taanga di Yiisu akiyene mu kuulu, muutu mosi ayiri mu matiini, ayitsukunu nha kulu a kiinzi kia nde na wamufuuli: «Muyiisi wu mubwe, ima me nafwaana mu usa mu ubaa moonyi wa bilimi na bilimi?» ");
INSERT INTO iyx_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yiisu wamuleeli: «Mu ima we li mu uta me “wu mubwe”? Muutu pe so mosi li wu mubwe, so a ni Nziaambi pe. ");
INSERT INTO iyx_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","We ayaaba mikele: “A dusu muutu pe, a soongo pe, a yibi pe, a ta imbaangi kia pia mu muutu pe, a yiluu ndaa yimbi mu muutu pe, kiinzi taayi a we na nguu a we.”» ");
INSERT INTO iyx_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Muutu wamuvutili: «Muyiisi, me nibaaduku mikele mii mioosi, umata bufuru ba me.» ");
INSERT INTO iyx_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yiisu wamutali mu litoono na wamuleeli: «Iloo ndila imosi ili mu uhele we. Yene, yaluu bi we li na bio, na ha boongo kwaa bawele, na we sa baa busini mu mayula. Tumake yiri na duku me.» ");
INSERT INTO iyx_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ka bu muutu wuu ayuyi buu, nde abayi ngebe, na ayeni mu ngebe mundaa ti nde ali na busini balaa. ");
INSERT INTO iyx_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yiisu atali miyii mia nde bu miamudiengilili, na wabaleeli: «Ili pasi kwaa bangaa busini mu ukoto mu Ipfumu kia Nziaambi!» ");
INSERT INTO iyx_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Miyii miakimii kwalaa mundaa mandaa ma nde. Ni mu buu, Yiisu abwileele kwaa bo: «Baana ba me, uli na pasi mu ukoto mu Ipfumu kia Nziaambi! ");
INSERT INTO iyx_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ili pasi kwaa samo mu ulabuu mu wuru la tsioongi, ka yabwavulu pasi kwaa isini mu ukoto mu Ipfumu kia Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Miyii miakimii kwalaa, na miafulisini bo na bo: «Ka ninha, na utuu uvuu?» ");
INSERT INTO iyx_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yiisu wabatali na wabaleeli: «Kwaa baata mii utuu pe uyilimi, ka a kwaa Nziaambi pe; mundaa kwaa Nziaambi, mioosi utuu uyilimi.» ");
INSERT INTO iyx_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ni mu buu Peetero aleeli kwaa nde: «Mono, bisi dimaasiisi bioosi mu uduku we.» ");
INSERT INTO iyx_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yiisu wamuvutili: «Mu ngwanya, me nadileeli: so muutu siisi nzo a nde, baana ba nguu ba nde, bakeri ba nde, nguu a nde, taayi a nde, baana ba nde, matsiee ma nde mu toono a me, na mu toono ndaa yimbwe, ");
INSERT INTO iyx_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nde sa abaa mbala kama biavulu bii mu taanga di. Nde sa abaa manzo, baana ba nguu, bakeri, banguu, baana na matsiee, kutso mbingisi ka. Na mu taanga dikaayira, nde sa abaa moonyi wa bilimi na bilimi. ");
INSERT INTO iyx_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Balayi babali babatsiomi mu taanga di sa baba babatsieelele; na babatsieelele, sa baba babatsiomi.» ");
INSERT INTO iyx_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Bo bali mu kuulu mu ukumu ku Yeruselemi. Yiisu akiyene nha kulu a miyii mia nde, miali na tari, na baa bakiduku nde bali na boomo. Yiisu abwiholo kuumi na miyii mioolo itwaari na nde na abaandii uyaabisa kwaa bo mandaa makaabwilili nde. ");
INSERT INTO iyx_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«Diyuu! Ku Yeruselemi dili mu uyene, ku buyeelele Mwaana a muutu nha mio mia banguu ba bangaanga ba Nziaambi, na bayiisi ba mikele. Bo sa bamuha kesili ya likwa, na sa bamuyeelele nha mioo mia bangooyi. ");
INSERT INTO iyx_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Bo sa basa nde saa, sa bamutswiili mate ku busu, sa bamufiinzi bikoti, na sa bamudusu. Na, nha mbisi a biluumbu bitata, nde sa usiimbuu mu babakwa.» ");
INSERT INTO iyx_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nha mbisi a nhaa, Yaki na Yowani, baana ba Zebedaayi, bayiri kwaa Yiisu. Bo bamuleeli: «Muyiisi, bisi diatoono ti, we wadiyiluu maa madiloombo kwaa we.» ");
INSERT INTO iyx_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yiisu wabaleeli: «Ima ditooni ti me nadiyiluu?» ");
INSERT INTO iyx_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bo bamuvutili: «Bu we kaadiaala mu buzitu ba we, ha bisi muswa wa udiaala nha peembi a we, wu mumosi nha koo kia we kia babaala, wu mukimi nha koo kia we kia bakaasa.» ");
INSERT INTO iyx_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ka Yiisu wabaleeli: «Beni a diayaaba pe ma dili mu uloombo! Beni utuu unywa mbasa ya mapasi yi me kaanywa, so mu uholo libootuu li bakaaha me?» ");
INSERT INTO iyx_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bo bamuvutili: «Bisi sa dituu.» Yiisu wabaleeli: «Beni sa dinywa mbasa yi me kaanywa na sa badibootuu mu libootuu li bakaabotuu me. ");
INSERT INTO iyx_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ka a me pe nisoolo ba budiaala nha koo kia me kia babaala na nha koo kia me kia bakaasa. Mundaa ti mambuu maa mali ma baata ba Nziaambi ataasila mo.» ");
INSERT INTO iyx_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Mu taanga di miyii kuumi mikimi miayuyi maa, bo bakoli Yaki na Yowani kesi. ");
INSERT INTO iyx_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ni mu buu, Yiisu ati bo boosi mbila na wabaleeli: «Beni diayaaba, baa babali mu utala weti bapfumu ba bangooyi, bo bali mu utumu bo weti bayiisi. Na baata babali na lituu, bali mu umweese bo litumu la bo. ");
INSERT INTO iyx_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ka maa a mafwaana pe mu uyilimi nha kati a beni. Wuu watoono uba mukuutu nha kati a beni sa aba booyi la beni. ");
INSERT INTO iyx_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Na watoono uba watsiomi nha kati a beni, afwaana uba ngaamba a boosi. ");
INSERT INTO iyx_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mundaa ti Mwaana a muutu a ayiri pe paa bamubaasila, ka mu ubaasila baata, na uha moonyi a nde weti kori mu uha bunyanga kwaa babalayi.» ");
INSERT INTO iyx_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yiisu na miyii mia nde batoori ku ngaanda a Yeriko. Nha mbisi a nhaa, mu taanga di bo bakipala na koongi a baata mu ngaanda yii, ingimangimi imosi kibakita Bartimayi, mwaana a Timayi, ali adiaala mu mukoo a kuulu na akiloombo mboongo. ");
INSERT INTO iyx_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mu taanga di nde ayuyi ti wuu Yiisu musi Nazareti, nde abaandii mu uloo: «Yiisu, Mwaana a Daavidi, kwiilili me ngebe!» ");
INSERT INTO iyx_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Baata balayi bamusieembi paa awuru. Ka nde ahami mu uloo: «Mwaana a Daavidi, kwiilili me ngebe!» ");
INSERT INTO iyx_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yiisu atemini, aleeli: «Diamuta mbili.» Ninha bo bateeri ingimangimi mbili, na bamuleeli: «Lwaata ibaala, temene, Yiisu li mu uta we mbili!» ");
INSERT INTO iyx_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ni mu buu, nde abumi iyungu kia nde, atemini mawasa na ayeni kwaa Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yiisu wamufuuli: «Ima we tooni ti me yiluu mu we?» Ingimangimi kiamuvutili: «Rabuni, mbiindili ti “Muyiisi”, me tooni ubwamono!» ");
INSERT INTO iyx_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Na Yiisu wamuleeli: «Yene, imiini kia we ivuuyisi we.» Nhaa-na-tsi, nde abwimono, na aduki Yiisu mu kuulu. ");
INSERT INTO iyx_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Mu taanga di baswesi na Yeruselemi, bebele na mala ma Betefange na ma Betania, bo batoori ku peembi a mulaanda wa Olive. Yiisu atsindii boolo mu miyii mia a nde. Nde wabaleeli: ");
INSERT INTO iyx_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","«Diyene nha bula bali nha kulu a beni. Beni bu dikaakoto mu bo, beni sa dimono mwaana puundi bakutulu, wu muutu so mosi keni a haata nha yulu a nde pe. Diamunyangala na diamubee kwaa me. ");
INSERT INTO iyx_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","So muutu fuuli beni: “Mu ima beni dili mu usa buu?”, diamuleele: “Pfumu li na nzala nde, ka nde sa avutulu nde mawasa-mawasa.”» ");
INSERT INTO iyx_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bo bayeni na bamoni mwaana puundi nha mbari, bakutulu nha munywa a nzo. Bo bamunyangili. ");
INSERT INTO iyx_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Baata babali nha, babafuuli: «Ima beni dili mu sa? Mu ki toono beni dili mu unyangala mwaana puundi wu?» ");
INSERT INTO iyx_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bo babavutili maa ma Yiisu aleeli, na babanyaali bayene. ");
INSERT INTO iyx_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bo babiti mwaana puundi kwa Yiisu, bo bayali biyungu bia bo nha yulu a puundi, na Yiisu adiaali nha yulu a nde. ");
INSERT INTO iyx_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Baata babalayi bayali biyungu bia bo mu kuulu, na bakimi basuusi matsweenyi ma bo bakesi mutso matsiee. ");
INSERT INTO iyx_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Babaki yene nha kulu a Yiisu na babaki duku nde bakiyene aloo: «Osaana! Nyaala Nziaambi asieme wuu wu uyiri mu kuumbu Pfumu! ");
INSERT INTO iyx_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nyaala Nziaambi asieme ipfumu kili mu uyira, ipfumu kia Daavidi taayi a bisi! Osaana mu kati a mayula!» ");
INSERT INTO iyx_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yiisu akoti mu Yeruselemi, na ayeni ku Nzo a Nziaambi. Bu amani na utala peembi na peembi, nde ayeni ku Betania na miyii kuumi na mioolo, ka busi ali ka la. ");
INSERT INTO iyx_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mu iluumbu kiaduki, mu taanga di bo bakisiisi bula ba Betania, Yiisu abayi nzala. ");
INSERT INTO iyx_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nde atalili mufiike wali na makaya, na nde ayimono ti helape sa abaa mbutu dia bafiike. Ka mu taanga di nde asweesii nha peembi a muti, nde ndila makaya abaasi, mundaa ti taanga dia bafiike diali keni a diafwaana pe. ");
INSERT INTO iyx_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ni mu buu, Yiisu aleeli kwaa mufiike: «Muutu so mosi a ubwadia mbutu dia we pe!» Na miyii mia a nde miakiyuululu. ");
INSERT INTO iyx_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bo batoori ku Yeruselemi. Yiisu akoti mu lipaanga la nzo a Nziaambi na abaandii mu ubingi baa bakiyaluu na bakisuumbu mu nzo a Nziaambi. Nde abwiisi meese ma baa bakisobo mboongo, na abwiisi bidiaalili bia baa bakiyaluu mabeembe. ");
INSERT INTO iyx_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Nde alii baata mu utaba lipaanga la Nzo a Nziaambi na bisii. ");
INSERT INTO iyx_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nde akiyiisi na wabaleeli: «Mabasonuu a mali mu uleele pe: “Nzo a me sa bata yo nzo a likuundu a baata boosi”? Ka beni dikitisi yo, isweemini kia miyibi!» ");
INSERT INTO iyx_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bu banguu ba bangaanga ba Nziaambi na bayiisi ba mikele bu bayuyi maa, bo basiayi makuulu ma udusu Yiisu. Ka bo bakibata nde, mundaa ti koongi yoosi yakimii na yatooni nziisili a nde. ");
INSERT INTO iyx_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tsitsii bu yatoori, Yiisu na miyii mia nde bapali mu ngaanda. ");
INSERT INTO iyx_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mu iluumbu kia duki mu ngwaali, bu bakilabuu, bo bamoni mufiike me wuu wu nde asibi. Nde ali maayiluu ukanya natee ku miaanzi. ");
INSERT INTO iyx_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peetero alibili moonyi mu mii mialabii na aleeli kwaa Yiisu: «Muyiisi, mono mufiike wu we asibi maakanya woosi.» ");
INSERT INTO iyx_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ni mu buu Yiisu aleeli kwaa miyii mia nde: «Diba na imiini mu Nziaambi! Ngwanya me nadileeli: ");
INSERT INTO iyx_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mbiiti muutu leeli kwaa mulaanda wu: “Matuu nhana yabwa mu mubu”, na so nde a siiri paa pe mutso mutimi a nde, ka siiri imiini ti ma nde amaaleele sa mayilimi, mo sa mayilimi. ");
INSERT INTO iyx_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ni mu buu, me nileele kwaa beni: Moosi ma beni diloombo mu likuundu, disa imiini ti beni dimaaholo mo na sa badiha mo. ");
INSERT INTO iyx_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Na mu taanga di beni diatemene mu ukuundu Nziaambi, so beni dili na toono na muutu, diamusa kolokolo. Paa ti Taayi a beni ka wuli mu mayula, anyaala mamabi ma beni.  ");
INSERT INTO iyx_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","» ");
INSERT INTO iyx_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Bo bayiri avutuu ku Yeruselemi. Mu taanga di Yiisu akiyene adieenge mutso lipaanga la nzo a Nziaambi, banguu ba bangaanga ba Nziaambi, bayiisi ba mikele na bakuutu ba Bayuudayo bayimono nde. ");
INSERT INTO iyx_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Bamufuuli: «Mu ki litumu we li mu uyiluu mandaa ma? Na aha we muswa wa uyiluu mo?» ");
INSERT INTO iyx_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yiisu wabavutili: «Me ni fuulu beni nduru ndila mosi. Divutulu me mvutu, na me sa nadileele mu ki litumu me ndi mu uyiluu mandaa ma. ");
INSERT INTO iyx_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Libootuu la Yowani kwaa na lo lamati? Kwaa Nziaambi oo ti kwaa baata? Divutulu me mvutu.» ");
INSERT INTO iyx_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bo balelisini: «So dileeli: “Kwaa Nziaambi”, nde sa wadifuulu: “Ka mu ima beni diakoono usa imiini mu Yowani?” ");
INSERT INTO iyx_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ka bisi utuu pe uleele ti “Kwaa baata.”» Bo ali utuu pe uleele buu, mundaa ti bo bakibata boomo ba koongi. Bo boosi bakitsimi ti Yowani ali mubili wangwanya. ");
INSERT INTO iyx_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ni mu buu, bo bavutili kwaa Yiisu: «Bisi a diayaaba pe.» Nde ka ninha avutili: «Ee-e, me ka a nileele beni pe, mu ki litumu me ndi mu uyiluu mandaa ma.» ");
INSERT INTO iyx_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yiisu abaandii utsuu kwaa bakuutu ba Bayuudayo mu matsaba: «Muutu mosi akuni tsiee a viinyi. Nde akayi yo mu lipaanga, na nde ahayi idunu mu ukamina mala ma mbutu dia viinyi. Nde atuungi nzo yayiluu unaanguu mu mutele, mundaa ukebe tsiee a viinyi. Tumake nde asoombuso yo kwaa basiali ba viinyi, na ayeni ku midieenge. ");
INSERT INTO iyx_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Taanga dia utolo mbutu bu diatoori, nde atsindii musiali a nde mosi kwaa basiali ba mu tsiee a viinyi mu uyaholo kwaa bo, ikuku kia nde kia mbutu dia viinyi. ");
INSERT INTO iyx_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ka bo bakaangi musiali wuu, bamuteti na bamuvutili mioo bwaasi. ");
INSERT INTO iyx_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ninha ngaa tsiee abwitsinduu bo musiali a nde mukimi. Wuu, bamuteti nha mutswe na bamutuyi. ");
INSERT INTO iyx_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ngaa tsiee abwitsinduu musiali mukimi, na wuu, bo bamudusi. Bo bayilii bumosi kwaa babalayi bakimi. Bo bateti babamosi na badusi bakimi. ");
INSERT INTO iyx_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nha tsieelele, ngaa tsiee asiaali na ndila mwaana a nde mosi wa mutimi. Nde wamutsindii, mundaa ti nde akileele: “Bo sa bakiinzi mwaana a me.” ");
INSERT INTO iyx_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ka basiali ba mu tsiee a viinyi baa, balelisini bo na bo: “Wu ni mutoli a mukobo! Tsweendani, diamudusu, na mukobo sa aba wa bisi!” ");
INSERT INTO iyx_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ninha bo bakaangi mwaana, bamudusi na babumi nyutu a nde ku mbari a lipaanga la tsiee a viinyi.» ");
INSERT INTO iyx_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yiisu afuuli kwaa bakuutu ba Bayuudayo: «Ngaa viinyi ima akaasa? Nde sa ayiri, nde sa adusu basiali ba mu tsiee a viinyi, na sa aha viinyi kwaa bakimi. ");
INSERT INTO iyx_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Beni a diataanga pe mandaa ma, mu Mabasonuu ma ngira: “Manya li batuungi babumi, limaakituu manya la ibwa, ");
INSERT INTO iyx_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ni Pfumu ayiluu buu, na ili ndaa ya nziaangili nha misi mia bisi!”» ");
INSERT INTO iyx_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Bakuutu ba Bayuudayo bakisaa kuulu ya ukaanga Yiisu, mundaa ti bo bayaabi ti nde ateeri tsaba yii mu ndaa bo. Ka bo babati boomo mu ndaa a koongi. Ni mu buu, bo a bamukaangi pe, bamusiisi na bayeni wa bo. ");
INSERT INTO iyx_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Batsindii kwaa Yiisu Bafarisi bakimi na kaba la baata ba Erode Antipase, paa balebuu nde mweete mu mandaa ma nde akaatsuu. ");
INSERT INTO iyx_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bo bayileele kwaa nde: «Muyiisi, bisi diayaaba ti we ngaa ngwanya. We a li mu ubaabata muutu pe, na we a li mu tala biinzi bia baata pe. Ka we li mu uyiisi mu ngwanya yoosi kuulu yi li mu uha Nziaambi kinyi. Wadileele, baha muswa oo ngori mu ufutu limaanda kwaa mutini Kayisari? Bisi diafwaana ufutu, oo ti ngori?» ");
INSERT INTO iyx_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yiisu ayaabi peluu a bo. Ni mu buu nde wabaleeli: « Mu ima beni dili mu ulebuu me mweete? Dimweese me mukuti a mboongo mosi.» ");
INSERT INTO iyx_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bo babeyi mukuti a mboongo na Yiisu wabafuuli: «Kiinzi ki na bisonii bi bia na bili?» Bo bamuvutili: «Bia mutini Kayisari.» ");
INSERT INTO iyx_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ninha Yiisu wabaleeli: «Divutulu bia Kayisari kwaa Kayisari; na divutulu bia Nziaambi kwaa Nziaambi.» Na bo bakimii kwalaa mu nde. ");
INSERT INTO iyx_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nha mbisi a nhaa, kaba la Basaduki layiri kwaa Yiisu. Ni bo bali mu uyiisi ti, tsimbilili a babakwa yo pe. Bo bamufuuli mbi bu: ");
INSERT INTO iyx_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Muyiisi, mono maleeli Mooso: “So baala likwiiri kwahele a ubutu baana, mwaana a nguu a nde afwaana ukweele mukwiili paa abutulu wakwa baana.” ");
INSERT INTO iyx_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ka ali na baana ba nguu tsaamba. Watsiomi akweeli, nde akwiiri kwahele a ubutu baana, na nde asiisi mukwiili a nde kwaa mwaana a nguu a nde. ");
INSERT INTO iyx_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Waboolo kweeli mukwiili, na nde kwiiri kwahele a usiisi mwaana. Wabatata bumosi, tee bu yadukisini. ");
INSERT INTO iyx_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","So mosi pe mu bo tsaamba wasiisi baana. Nha mbisi a bo boosi, mukaasa ka akwi. ");
INSERT INTO iyx_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Mu taanga dia tsimbilili a babakwa, mukari wa na nde akaaba? Mundaa ti bo tsaamba baholi nde weti mukari.» ");
INSERT INTO iyx_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yiisu wabavutili: «Beni diayaaba mu ima beni dimaadiimbili? Mundaa ti beni a diayaaba pe so Mabasonuu ma ngira, so litu la Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mu ngwanya, mu taanga dia tsimbilili a babakwa, a bubwaba pe na mukari na mulumi. Ka baata boosi sa baba weti batumu ba Nziaambi mu mayula. ");
INSERT INTO iyx_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mu miatala babakwa bali mu usiimbuu, beni a diataangi pe mu mukaanda a Mooso, maa ma Nziaambi ayaabisi nde nha peembi a muti wakiluluu mbaa: “Me ni Nziaambi a Abraami, Nziaambi a Isaki na Nziaambi a Yaakobi!”» ");
INSERT INTO iyx_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yiisu abwileele: «Nde a ali Nziaambi wa babakwa pe, ka wa babali moonyi. Beni Basaduki dili mu uyiluu udiimbili.» ");
INSERT INTO iyx_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mosi mu bayiisi ba mikele ayuyi bu bakitsuu. Nde amoni ti Yiisu avutili bubwee kwaa Basaduki; nde asweesi kwaa nde na wamufuuli: «Ki mukele a Nziaambi wa vulu ndutu mu mikele mioosi?» ");
INSERT INTO iyx_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yiisu wamuvutili: «Watsiomi ni wu: “Yuu Iseraeli! Pfumu a bisi Nziaambi li Pfumu ndila mosi. ");
INSERT INTO iyx_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","We sa toono Pfumu Nziaambi a we, mu mutimi a we woosi, mu muwuumu a we woosi, mu matsimi ma we moosi, na mu mifuri mia we mioosi.” ");
INSERT INTO iyx_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na mono wa mioolo: “We sa toono mbaayi a we, weti we makulu.” A kuli na mukele mukimi wavulu mu bunene na mioolo mii pe.» ");
INSERT INTO iyx_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Muyiisi a mikele abwileele: «Ngo bubwe, Muyiisi! Ma we leeli ma ngwanya: Nziaambi ndila mosi, na mukimi pe weti nde. ");
INSERT INTO iyx_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Utoono nde mu mutimi a we woosi, mu mayele ma we moosi na mu mifuri mia we mioosi. Nziaambi atoono ka ti pasi muutu atoono mbaayi a nde weti nde makulu bwavulu bubwe na bungori boosi ba tsuyili a diki la banyama.» ");
INSERT INTO iyx_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yiisu amoni ti nde vutili mvutu mu mayele na wamuleeli: «We a li la na Ipfumu kia Nziaambi pe.» Na muutu mukimi a asiayi pe mu ubwafuulu nde manduru. ");
INSERT INTO iyx_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Bu Yiisu akiyiisi mutso lipaanga la nzo a Nziaambi, nde aheeri nduru yi: «Buni bayiisi ba mikele butuu uleele ti Kristo li mwaana a Daavidi? ");
INSERT INTO iyx_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daavidi nde makulu, mu tumini a Muheebili wa Ngira, aleeli: “Pfumu aleeli kwaa Pfumu a me: Diaala nha koo kia me kia babaala, natee bu me nisuusu mitaata mia we kutsini a miili mia we.” ");
INSERT INTO iyx_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Daavidi nde makulu li mu uta nde: “Pfumu”, ka buni Kristo utuu ubwaba mwaana a nde?» Koongi yalaa yakiyuu Yiisu mu kinyi yoosi. ");
INSERT INTO iyx_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mono ma Yiisu akiyiisi: «Disa mayele mu bayiisi ba mikele babatoono udieenge na bikutu bibibwe. Bo batoono uyaka mabwe ma likiinzi mu kulu a mbari. ");
INSERT INTO iyx_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bo bali mu usoolo mambuu matsiomi mutso manzo ma makutunu ma Bayuudayo, na mu mambuu ma likiinzi mu mikuungi. ");
INSERT INTO iyx_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bo bali mu upatila biloo bia bakwiili, na mu peluu bali mu usa makuundu mamala. Nziaambi sa afuundusu bo mu mifuri!» ");
INSERT INTO iyx_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yiisu ali adiaala mutso nzo a Nziaambi nha kulu a itungu ki bubaaha bungori, na nde akimono buni baata bakilooso mikuti mia mboongo mu itungu kii. Bisini bibilayi biakilooso mikuti mialaa. ");
INSERT INTO iyx_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mukwiili mosi wa mukaasa wa muwele ayiri na aloosi mikuti mia nde mioolo mimikee. ");
INSERT INTO iyx_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yiisu ati miyii mia nde mbili na wabaleeli: «Ngwanya me nadileeli, mukwiili wuu na wu wa muwele vuli ulooso mboongo na bo boosi. ");
INSERT INTO iyx_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Mundaa ti bo boosi baheeri bia bo, biahele na ndutu. Ka nde, wahele na bioosi, heeri bioosi bi ali na bio. Bioosi bi nde ali na bio mu idiingi kia nde.» ");
INSERT INTO iyx_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Mu taanga di Yiisu akipala mu lipaanga la nzo a Nziaambi, mosi mu miyii mia a nde wamuleeli: «Muyiisi, mono mamanya ma bubwe! Mono ki pili a tuungili!» ");
INSERT INTO iyx_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yiisu wamuleeli: «We li mu umono tuungili yinene yi? A kubwasaala pe nha na nha manya limosi nha yulu a lini. Bioosi sa batsara.» ");
INSERT INTO iyx_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yiisu ayeni ku mulaanda a Olive wali nha kulu a nzo a Nziaambi. Nde ali adiaala itwaari na Peetero, Yaki, Yowani na Andere. Bo bamufuuli: ");
INSERT INTO iyx_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Wadileele, mu ki taanga maa makaayilimi, na ki iliimbi ikaamweese ti maa moosi sa mayilimi?» ");
INSERT INTO iyx_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ni mu buu, Yiisu abaandii uleele kwaa bo: «Disa mayele, muutu ahele udiimbisi beni mu mandaa ma pia. ");
INSERT INTO iyx_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Babalayi sa biyiri mu kuumbu a me, na sa baleele: “Ni me!” Na sa badiimbisi baata babalayi. ");
INSERT INTO iyx_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Bu beni dikaayuu midiingi na kele ya midiingi, a diba na boomo pe. Mundaa ti maa mafwaana uyilimi, ka yii keni a manini a tsi pe. ");
INSERT INTO iyx_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tsi mosi sa idwaanisa tsi kimi. Ipfumu imosi sa idwaanisa ipfumu ikimi. Toto sa dinyingini mu mambuu malaa, na nzala. Yii sa iba weti mbaandila misoongo mia mbutili. ");
INSERT INTO iyx_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Disa mayele mu beni bame. Mundaa ti sa badiyeelele nha kulu a pfuundisi. Sa baditete mu manzo ma makutunu ma Bayuudayo. Sa badifuundusu nha kulu a batumi na mitini, mu toono a me. Sa iba imbaangi kwaa bo. ");
INSERT INTO iyx_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ka bwafwaana tsiomi ti ndaa yimbwe iyabina kwaa baata boosi. ");
INSERT INTO iyx_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mu taanga di bakaabiti beni nha kulu a pfuundisi, a dikwanyoongo pe, mu mii mi beni dikaaleele. Ka dileele mandaa ma bakaaha beni mu taanga dii. Mundaa ti mo a mumata kwaa beni pe, ka kwaa Muheebili wa Ngira. ");
INSERT INTO iyx_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mwaana a nguu sa ayeelele mwaana a nguu a nde makulu mu likwa. Taayi ka sa ayiluu bumosi na mwaana a nde. Baana sa badwaanisa bibuti bia bo na sa bafuundusu bo mu tsieembili ya likwa. ");
INSERT INTO iyx_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Baata boosi sa badibele mu toono a me. Ka wuu wu uba na mukonono natee manini, sa ayobuu. ");
INSERT INTO iyx_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Sa uba na iluumbu ki beni dikaamono muutu wu bali mu uta “Mubi wa tsitsi”, atemene nha mbuu yi nde ahele ufwaana uba. Nyaala ti wukaataanga mandaa ma, ayuu bubwe! Nyaala babakaaba ku Yuuda, babata ku milaanda. ");
INSERT INTO iyx_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wukaaba ku yulu a nzo a nde, anyaala usutuu mu uholo biloo bia nde bili mutso nzo. ");
INSERT INTO iyx_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wukaaba ku matsiee, anyaala uvutuu ku nzo a nde mu uyaholo iyungu kia nde. ");
INSERT INTO iyx_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ki pili a ngebe dikaaba, mu biluumbu bii, kwaa bakaasa bangaa mayimi na kwaa babakaanywiisi baana mabeene. ");
INSERT INTO iyx_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Dikuundu Nziaambi paa ti maa mahele uto mu taanga dia mvulu na dia kioori kia mifuri! ");
INSERT INTO iyx_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mundaa ti mu biluumbu bii, sa uba na tsitsi diavulu bunene. Baata sa bamono pasi dialaa, mu iteesi kiavulu bunene. Umata mbaandila tsi, mu taanga di Nziaambi ayilii bioosi, natee lolo, baata keni a bamono pasi dia pili yii pe. Na a bubwamonuu mandaa ma pili yii pe. ");
INSERT INTO iyx_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","So Pfumu a aholi pe kesili ya usa ti taanga dii diba dikusi, keni muutu so moosi utuu pe uvuu. Ka nde asi dio diba dikusi, mu ndaa a babasoolo mu uba baata ba nde. ");
INSERT INTO iyx_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«Ni mu buu, so muutu wadileeli: “Dimono, Kristo nha ali” so a buu pe: “Dimono, nde kunaa ali!” A diamusa imiini pe. ");
INSERT INTO iyx_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ka bakristo ba pia na mibili mia pia, sa batemene. Sa bayiluu biliimbi bia ukimuu na bimaanga mu udiimbisi, so butuu uba, baa ba Nziaambi asoolo. ");
INSERT INTO iyx_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ni mu buu, disa mayele! Me maakwayaabisa beni mioosi.» ");
INSERT INTO iyx_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Mu biluumbu bii, nha mbisi a tsitsi dia pili yii, tari sa liba pimisi, tsuungi a ubwaha liyalila la nde pe, ");
INSERT INTO iyx_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","bambwelele sa basotuu mu umata ku yula, na tuu dili ku yula sa dinyingini. ");
INSERT INTO iyx_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nha mbisi sa bamono Mwaana a muutu mu uyiri mu matuti, mu litu na mu buzitu ba nde. ");
INSERT INTO iyx_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nde sa atsinduu batumu ba nde mu ukukuu ba nde asoolo mu mapeembi moosi, umata kwasuku toto, natee kwasuku yula.» ");
INSERT INTO iyx_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Diyuu nziisili yili mu uha muti wa mufike: Mu taanga di mapaki ma nde mamaakololo makaya moosi, na makaya mamanyatii maka mu uteete, beni diayaaba ti mvulu a tsiomi ka bebele. ");
INSERT INTO iyx_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ni bumosi mu beni ka, mu taanga di beni dikaamono mandaa maa mu uyilimi, diyaaba ti Mwaana a muutu ka bebele, nha munywa a nzo a we. ");
INSERT INTO iyx_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ngwanya me na dileeli: kubu yi a yilabuu pe tswaamina a maa moosi muyilimi. ");
INSERT INTO iyx_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yula na tsi sa bilabuu, ka mandaa ma me a mulabuu pe.» ");
INSERT INTO iyx_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Mu miatala iluumbu, so a buu pe nguungu, muutu so mosi pe wayaaba, a so batumu ba Nziaambi mu mayula pe, a so Mwaana ka pe. Ndili a Taayi ayaaba. ");
INSERT INTO iyx_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Disa mayele! Diba likanda, mundaa ti beni a diayaaba pe taanga dia tsieelele. ");
INSERT INTO iyx_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Sa buba weti mu taanga di muutu ubayene midieenge. Mu taanga di nde ali mu usiisi nzo a nde, nde li mu usiisi basiali ba nde mu usa yo bungeele. Nde li mu uha kwaa muutu muutu isala kia nde, na li mu utumu kwaa mukebi a munywa nzo mu uba likanda. ");
INSERT INTO iyx_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ni mu buu diba likanda, mundaa ti beni a diayaaba pe taanga dikaayiri ngaa nzo. Helape nde yiri tsitsii, so kati-a-kati a butsuu. So a buu pe, mu taanga di tsutsu ukookolo, so mu ngwaali. ");
INSERT INTO iyx_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","So nde yiri mu itsimbisini, a bwafwaana pe ti nde abaasa beni diala matolo. ");
INSERT INTO iyx_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ma me ndi mu uleele beni, me ndi mu uleele mo kwaa boosi: Diba likanda!» ");
INSERT INTO iyx_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Biluumbu bioolo biasiaali tswaamini a mukuungi a Paaka uto, na mukuungi wa mapa mahele na lifunusu. Mu taanga di, banguu ba bangaanga ba Nziaambi na bayiisi ba mikele, basiayi kuulu mu ukaanga Yiisu mu tsweeyi na mu mayele, paa bamudusu. ");
INSERT INTO iyx_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ni mu buu, bo balelisini: «Dinyaalani ukaanga nde mu taanga dia mukuungi, leeti baata sa batemene kutso nyingi-nyingi.» ");
INSERT INTO iyx_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yiisu ali ku bula Betania, mu nzo a Simooni ngaa a bwaari. Bu nde akidia, mukaasa mosi akoti mu nzo na ibasa kialuulu mu manaasa matala yalaa. Nde adibili ibasa kia alabati, na ayitili mananaasa ma nare nha yulu a mutswe a Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Babamosi mu babali nhaa bakoli kesi: «Mu ki toono babiiyisi wako mananaasa ma? ");
INSERT INTO iyx_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Keni beeri bayaluu mo mu makama matata ma mikuti mia mboongo, na uha mo kwaa bawele!» Bo batsuyi bubi kwalaa mu mukaasa wuu. ");
INSERT INTO iyx_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ka Yiisu aleeli: «Diamunyaala na pii. Mu ima beni dili mu ukwaamisa nde? Yi nde ayilii mu me, ngwanya ili ndaa yimbwe. ");
INSERT INTO iyx_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mundaa ti taanga dioosi beni sa dibaaba itwaari na bawele. Na mu pasi taanga di beni ditooni, beni sa dituu uyiluu bo mamabwe. Ka beni a dituu pe uba na me taanga dioosi. ");
INSERT INTO iyx_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nde yilii ma nde atuyi: Nde kwiyitili mananaasa mu nyutu a me, mundaa uyiluu ndiili a me. ");
INSERT INTO iyx_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ngwanya, me nadileeli: pasi peembi yibuyaabisa Ndaa Yimbwe, mu tsi yoosi, sa balibili moonyi mu nde, mu ndaa yi mukaasa wu ayilii mu me.» ");
INSERT INTO iyx_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yuuda Isikarioti, mosi mu kuumi na miyii mioolo, ayiyaabisa tsimi kwaa banguu ba bangaanga ba Nziaambi mu uyeelele Yiisu kwaa bo. ");
INSERT INTO iyx_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Mu ndaa yimbwe yii, bo bayaangi na balasini bamuha mboongo. Umata mu taanga dii, Yuuda asiayi kuulu yafwaana mu uyeelele Yiisu kwa bo. ");
INSERT INTO iyx_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mu iluumbu kiatsiomi kia mukuungi a mapa ma bahele ufunusu, iluumbu ki bakitsuu bungori ba mwaana a limeme la Paaka, miyii mia Yiisu mialeeli kwaa nde: «Kuni we atoono ti bisi diyayiluu we ndaamba a Paaka?» ");
INSERT INTO iyx_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ninha Yiisu atsinduu mioolo mu miyii mia nde bu aleeli: «Diyene ku ngaanda. Kuu, beni sa dibwaanina na baala limosi lili na mbiindi yaluulu mu maamba. Diamuduku, ");
INSERT INTO iyx_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","na kuu ku nde akaakoto, dileele kwaa ngaa nzo ti: “Muyiisi fuuli we: Kuni kuli itsuru kia nzo ki me kaadia ndaamba a Paaka na miyii mia me?” ");
INSERT INTO iyx_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nde sa wadilaa, itsuru kia nzo ki inene kia ku yulu, mutso nzo a nde, kibasa bungeele na kiamaayilimi. Ni muu beni dikaayiluu ndaamba a Paaka.» ");
INSERT INTO iyx_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Miyii miayeni na miakoti ku ngaanda. Bo bamoni mandaa moosi weti bu Yiisu aleeli yo kwaa bo, na ni kuu bo bayilii ndaamba a Paaka. ");
INSERT INTO iyx_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tsitsii bu yatoori, Yiisu ayiri na miyii mia nde kuumi na mioolo. ");
INSERT INTO iyx_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Bu bo bakidia nha meese, Yiisu aleeli: «Ngwanya me nadileeli: Mosi mu beni, wuli mu udia na me, sa ayeelele me.» ");
INSERT INTO iyx_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Miyii mioosi miakoti mu ngebe, na bo bamuleeli mosi nha mbisi a wunu: «Ni me?» ");
INSERT INTO iyx_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yiisu aleeli kwa bo: «Ni mosi mu beni, mosi mu kuumi na mioolo. Wuu wu utsubu lipa la nde na me, mu ikoombo. ");
INSERT INTO iyx_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mwaana a muutu sa akwa weti bu Mabasonuu ma Ngira mali mu uyaabisa. Ka ngebe kwaa muutu wuu, wu uyeelele Mwaana a muutu! Ali yavulu bubwe kwaa muutu wuu, mu uhele ubutuu!» ");
INSERT INTO iyx_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mu taanga dia udia, Yiisu aholi lipa. Bu amani uvutulu matoondo kwaa Nziaambi, nde abukili lo na ahi lo kwaa miyii mia nde. Nde wabaleeli: «Diholo, yiinayi ni nyutu a me.» ");
INSERT INTO iyx_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nha mbisi, nde aholi mbasa a viinyi. Bu amani uvutulu matoondo kwaa Nziaambi, nde wabaheeri yo. Na boosi banwyiiri yo. ");
INSERT INTO iyx_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yiisu wabaleeli: «Maa-na-ma ni makila ma me, makili mali mu uhamisa lilasina la Nziaambi, matsiaamii mu toono a baata babalayi. ");
INSERT INTO iyx_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ngwanya me nadileeli: Me a nibwanywa pe mala ma mbutu dia viinyi ma, natee iluumbu ki me ni bwanywa mo, mu Ipfumu kia Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tumake bo bamani uyimbi mikuunga mia mukuungi, na bo bayeni ku mulaanda a Olive. ");
INSERT INTO iyx_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yiisu aleeli kwaa miyii mia nde: «Beni boboosi sa dibwoongolo me, ka bali mu utaanga mu Mabasonuu ma Ngira: “Me sa tete mukebi, na mameme sa matsamuu.” ");
INSERT INTO iyx_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ka, Yiisu abwileele, nha mbisi a tsimbilili a me, sa naditswaamina ku Ngalili.» ");
INSERT INTO iyx_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peetero wamuleeli: «Ka so boboosi babwoongili we, me a nibwoongolo we pe!» ");
INSERT INTO iyx_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yiisu avutili kwaa nde « Ngwanya me ndeeli kwaa we: Lolo li, mu butsuu ba ka, tswaamina tsutsu ukookolo mbala dioolo, we sa tunu me mbala tata.» ");
INSERT INTO iyx_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ka Peetero ahami mu usa paa: «So me nikwa ka itwaari na we, ngori me a nituu utunu we pe!» Na boosi baleeli bumosi ka. ");
INSERT INTO iyx_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tumake bo batoori nha mbuu mosi ya kuumbu Ngetesemane, na Yiisu aleeli kwaa miyii mia nde: «Didiaala nhaa na nha, mu taanga di me niyakuundu.» ");
INSERT INTO iyx_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nde abiti itwaari na nde Peetero, Yaki na Yowani. Nde abaandii umono ikuuhulu na mangoongo, ");
INSERT INTO iyx_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","na nde wabaleeli: «Me ndi na ngebe mu ukwa, didiaala nhaa na nha, na diba likanda!» ");
INSERT INTO iyx_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nde ayeni mwaana taka hoolo; atsukini, na akuundi paa ti, so ali butuu uba, ti nguungu yii ya mapasi yilabuu la na nde. ");
INSERT INTO iyx_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nde aleeli: «Aba, Taata, mioosi utuu uyilimi mu we. Takala la na me mbasa ya mapasi yiinayi. Ka, a buba weti buli litoono la me pe, ka buli litoono la we.» ");
INSERT INTO iyx_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nde abwiyiri avutuu na amoni miyii mitaata mialaa tolo. Nde aleeli kwaa Peetero: «Simooni, we tolo? We abayi mifuri mia uba likanda so mu nguungu mosi? ");
INSERT INTO iyx_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Diba likanda na dikuundu paa dihele ubwa mu mapuusu. Mutimi a muutu li ahama, ka musunyi a nde adee.» ");
INSERT INTO iyx_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nde abwitakuu, na akuundi Nziaambi bu abwileele mandaa maanamaa. ");
INSERT INTO iyx_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nha mbisi a mwaana a taanga hoolo, nde abwivutuu kwaa miyii mia nde na wabamoni bala tolo. Bu bo bakooni uba misi bwaasi, bo a bayaabi pe mima buleele kwaa nde. ");
INSERT INTO iyx_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Bu abwiyiri mbala ya mutata, nde aleeli kwaa bo: «Beni kaala matolo na beni dili mu uwuumu? Bumaakuu! Nguungu yimaato. Mu taanga di, muutu mosi sa ayeelele Mwaana a muutu nha mioo mia bangaa masumu. ");
INSERT INTO iyx_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ditemene, tsweendani! Dimono, muutu wukaayeelele me kwaa bo, nha ali!» ");
INSERT INTO iyx_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yiisu ali keni mu utsuu. Ni mu taanga di Yuuda, mosi mu miyii kuumi na mioolo, ayiri. Koongi a baata bali na mikasa na mipaanga bali itwaari na Yuuda. Banguu ba bangaanga ba Nziaambi, bayiisi ba mikele na bakuutu ba babaala boosi baa nibabatsindii bo. ");
INSERT INTO iyx_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yuuda wuu wayeelili Yiisu, amweesi bo iliimbi ki nde akaasa. Nde wabaleeli: «Wuu wu me kaanyumbutu, ni nde. Diamukaanga na diamubiti, diyiluu ukebe nde.» ");
INSERT INTO iyx_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mu taanga di Yuuda atoori, nde asweesi kwaa Yiisu, na wamuleeli: «Muyiisi!» Na wamunyumbiti. ");
INSERT INTO iyx_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Babakimi babwiilili Yiisu na bamukaangi. ");
INSERT INTO iyx_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ka mosi mu babali nhaa, apalisi mukasa a nde mutso kutu a nde, ateti musiali a nguu a bangaanga ba Nziaambi, na wamukesi litswi. ");
INSERT INTO iyx_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yiisu wabaleeli: « Me ihaangi ndi, paa beni diyiri na mikasa na mipaanga, mu ukaanga me? ");
INSERT INTO iyx_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mu biluumbu bioosi me mbeeriangi itwaari na beni, na nakiyiisi mutso lipaanga la nzo a Nziaambi, na beni a diakaangi me pe. Ka maa mamaayilimi, paa Mabasonuu ma Ngira mayene tsitsi.» ");
INSERT INTO iyx_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nhaa-na-tsi, miyii mioosi miamubwoongili, na miabati. ");
INSERT INTO iyx_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mufuru a baala mosi wali walwaata ndila tsaanda mosi, akiduku Yiisu. Bayesini mu ukaanga nde, ");
INSERT INTO iyx_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ka nde anyaali tsaanda na abati pene. ");
INSERT INTO iyx_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ba bakaangi Yiisu babiti nde kwaa nguu a ngaanga a Nziaambi. Banguu ba bangaanga ba Nziaambi, bakuutu ba Bayuudayo na bayiisi ba mikele boosi bakukini. ");
INSERT INTO iyx_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peetero akiduku Yiisu ku lala, natee ku mbari a lipaanga la nzo a nguu a bangaanga ba Nziaambi. Kuu, nde adiaali itwaari na bakebi na akiyoto mbaa. ");
INSERT INTO iyx_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Banguu ba bangaanga ba Nziaambi na ikuutu kia bo kioosi, bakisaa toono yiibwiisi Yiisu paa bamudusu, ka a babayi pe. ");
INSERT INTO iyx_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ka baata babalayi bakita bimbaangi bia pia mu nde, ka a baki uyuhusunu bo na bo pe. ");
INSERT INTO iyx_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Babamosi batemini na bati nde imbaangi kia pia kiinaki: ");
INSERT INTO iyx_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Bisi diayuyi bu aleeli: “Me sa tsara nzo a Nziaambi yiinayi yi batuungu mu mioo mia baata, na mu biluumbu bitata me sa bwatuungu nzo kimi yi ihele uba iyiluu kia muutu.”» ");
INSERT INTO iyx_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ka so mu ndaa yii bo a bayuhisini pe. ");
INSERT INTO iyx_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nguu a bangaanga ba Nziaambi atemini nha kati-a-kati a baata, na ahi Yiisu nduru: «We mvutu yi we uvutulu yo pe? We mima leeli mu bimbaangi bi baata bali mu uta mu we?» ");
INSERT INTO iyx_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ka Yiisu awuri, na a avutili mvutu so mosi pe. Nguu a bangaanga ba Nziaambi abwifuulu nde: «We ni Kristo, mwaana a Ngaa Lisieme?» ");
INSERT INTO iyx_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yiisu avutili: «Ee-e, ni me! Na beni sa dimono Mwaana a muutu adiaala nha koo kia babaala kia wuu wuli na litu, na nde sa ayiri mu matuti ma yula.» ");
INSERT INTO iyx_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ni mu buu nguu a bangaanga ba Nziaambi akaki bikutu bia nde, na aleeli: «Bisi a dili na nzala usaa bambaangi pe! ");
INSERT INTO iyx_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Beni diyuyi bu nde atuyi Nziaambi. Buni beni dili mu utsimi?» Bo boosi bayaabisi ti nde maasa bubi na nde afwaana ubaa tsieembili ya likwa. ");
INSERT INTO iyx_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Babamosi babaandii mu utswiili nde mate, bamufuuli tsaanda ku busu, bamuteti. Bo bamuleeli: «Bili, na yesene uyaaba wu yilii we maa!». Na bakebi ba nzo a Nziaambi bamuteti mambata. ");
INSERT INTO iyx_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Peetero ali keni ku tsini nha mbari a lipaanga la nguu a bangaanga ba Nziaambi. Mu diina taanga dii, mosi mu basiali babakaasa ba nguu a bangaanga wuu ayiri. ");
INSERT INTO iyx_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nde amoni Peetero bu akiyoto mbaa. Musiali wa mukaasa wuu wamutali, na wamuleeli: «We ka beeri na Yiisu musi Nazareti.» ");
INSERT INTO iyx_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Peetero atuni bu ayaabisi: «Me a nayaaba pe ma we tooni uleele, me a ndi mu uyuu pe.» Na nde amati nha mukoo a mbaa, na ayitemene nha peembi na munywa a lipaanga. Ninha, tsutsu akookili. ");
INSERT INTO iyx_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ka musiali wa mukaasa wamumoni, na abwiyaabisa nha kulu a babali nhaa: «Muutu wuunawu, li mosi nha kati a bo!» ");
INSERT INTO iyx_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Na Peetero abwitunu. Mwaana a idii hoolo, baa babali nhaa, bakibwaleele kwaa nde: «Utuu uba ngwanya, we li mosi mu bo, mu ndaa ti we ka, li musi Ngalili.» ");
INSERT INTO iyx_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ninha Peetero aloyi: «Nyaala Nziaambi asieembe me, mbiiti me pia ndi mu ufutu! Ngwanya, me a nayaaba muutu pe wu beni dili mu utsuu mu nde.» ");
INSERT INTO iyx_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nhaa-na-tsi, tsutsu akookili mbala ya dioolo. Ninha, Peetero alibili moonyi mu maa mamuleeli Yiisu: «Tswaamini tsutsu ukookolo mbala dioolo, we sa tunu me mbala tata.» Ni mu buu, Peetero akoti mu ngebe, abaandii ulili. ");
INSERT INTO iyx_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mu ngwaali ya na wee, banguu ba bangaanga a Nziaambi, bayiisi ba mikele na pfuundu a ikuutu kia Bayuudayo kioosi, bakukini. Bakuti Yiisu bibolo, bamubiti na bamuyeelili kwaa mutumi Pilato. ");
INSERT INTO iyx_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato wamufuuli: «We ni mutini a Bayuudayo?» Yiisu wamuvutili: «We leeli buu.» ");
INSERT INTO iyx_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Banguu ba bangaanga ba Nziaambi bafuundi Yiisu kwalaa. ");
INSERT INTO iyx_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato abwiha nde manduru: «We a li na ya uvutulu pe? We li mu uyuu bu baata ba boosi bali mu ufuundu we!» ");
INSERT INTO iyx_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ka Yiisu a abwivutulu ndaa so mosi pe. Ni mu buu, Pilato akimii kwalaa. ");
INSERT INTO iyx_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Mu pasi mukuungi a Paaka, Pilato akiha bunyanga kwaa kori mosi, wuu wu koongi yakiloombo. ");
INSERT INTO iyx_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ka bunu, muutu mosi kuumbu a nde Barabase, ali mu perese na biwulu biadusi muutu, mu taanga yali nyingi-nyingi. ");
INSERT INTO iyx_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Koongi yayeni kwaa mutumi Pilato, na yamuloombi paa babayiluu weti bu yali ipfu kia nde. ");
INSERT INTO iyx_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato wabavutili: «Beni diatoono ti me na dinyaala mutini a Bayuudayo?» ");
INSERT INTO iyx_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ka nde ali ayaaba bubwe ti, mundaa a musoyi, banguu ba bangaanga ba Nziaambi bamuyeelili Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ka banguu ba bangaanga ba Nziaambi, batsindi koongi paa ti Pilato wabanyaalila Barabase nha mbuu a Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato abwifuulu: «So me nyaali beni Barabase, ima ditoono ti me sa mu wuu wu beni dili mu uta mutini a Bayuudayo?» ");
INSERT INTO iyx_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bo bamuvutili bu bakiloo: «Wamukomo nha kuruwa!» ");
INSERT INTO iyx_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato wabafuuli: «Ka ki mamabi nde ayilii?» Ka bo babwihama mu uloo: «Wamukomo nha kuruwa!» ");
INSERT INTO iyx_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Bu Pilato atooni uha kinyi kwaa koongi, nde wabanyaalili Barabase. Nde atumi ti batete Yiisu bikoti, na wamuyeelili paa bamukomo nha kuruwa. ");
INSERT INTO iyx_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Masodaare mabeyi Yiisu mutso nzo a mutumi, na bo bateeri koongi a masodaare yoosi mbili. ");
INSERT INTO iyx_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bo bamulwaatisi iyuungu kiabeenge, na bamunayi nha yulu a mutswe, iburu kia matsieende. ");
INSERT INTO iyx_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bo babaandii uha nde bwee. Bo bamusiiri saa bu bamuleeli: «Bwee, mutini a Bayuudayo!» ");
INSERT INTO iyx_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tumake, bamuteti ikoti nha yulu a mutswe, bamutswiili mate na batsukini nha kulu a nde mu uha nde bwee. ");
INSERT INTO iyx_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bu bamani uyiluu usa nde saa, bamumaasi iyuungu kiabeenge na bamulwaatisi bikutu bia nde makulu. Bobamubiti ku mbari a ngaanda, paa bamukomo nha kuruwa. ");
INSERT INTO iyx_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Muutu mosi wa bula ba Kirene, kuumbu a nde Simooni, taayi a Alekandere na Lufusi. Nde akimata ku matsiee na akilabuu nhaa. Masodaare mamubamii mu ubiti kuruwa a Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bo babiti Yiisu ku mbuu ya kuumbu Ngolongota, mambiindili ti: «mbuu ya iteenge kia mutswe.» ");
INSERT INTO iyx_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bo bali na nzala ya uha nde mala mabavuutu na miire, ka Yiisu abisi. ");
INSERT INTO iyx_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tumake bo bamukomi nha muti wa kuruwa. Na bo bakabi nha kati a bo bikutu bia nde, mu uta nzeke paa bayaaba ikuku ki muutu muutu mu bo akaabiti. ");
INSERT INTO iyx_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ali ka nguungu ya wa ya ngwaali, mu taanga di bakomi nde nha muti wa kuruwa. ");
INSERT INTO iyx_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kwali na bala lalikee li bali basonuu toono yi bamuhi tsieembili. Ali basonuu mandaa ma, nha yulu a bala lii: «Mutini a Bayuudayo». ");
INSERT INTO iyx_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ali bakomo biwulu bioolo, itwaari na nde, muutu muutu nha kurwa a nde. Mosi nha koo kia nde kia babaala, wunu nha koo kia nde kia bakaasa.  ");
INSERT INTO iyx_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Babakilabuu kuulu nha mbuu yii, bakituu nde, na bakinyingisi mitswe. Bo baleeli: «Ee-e! We a ni muutu pe waleeli ti we utuu utsara nzo a Nziaambi, na ubwatuungu yo mu biluumbu bitata? ");
INSERT INTO iyx_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ka vuu mu iwemakulu, sutuu nha kuruwa!» ");
INSERT INTO iyx_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bumosi, banguu ba bangaanga ba Nziaambi na bayiisi ba mikele bakisa Yiisu saa. Bo bakilelesene: «Nde maavuusu bakimi, ka nde ukoono uvuu mu indemakulu! ");
INSERT INTO iyx_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nyaala Kristo, mutini a Iseraeli, asutuu mu taanga di nha kuruwa! Paa bisi dimono, na dimene miaanzi mu nde.» Babakomi itwaari na Yiisu, bakituu ka nde. ");
INSERT INTO iyx_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mu nguungu ya nzanga, pimisi diabwi mu tsi yoosi, na diadiingi natee mu nguungu ya matata ku mbisi a nzanga. ");
INSERT INTO iyx_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Na mu nguungu yii, Yiisu aloyi mu ndaa ya mifuri: «Eloyi, Eloyi, lema sabakatani?» Mambiindili ni ma: «Nziaambi a me, Nziaambi a me, mu ima we siisi me?» ");
INSERT INTO iyx_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Babamosi mu babali nhaa bamuyuyi, na baloyi: «Diyuu, nde ka mu uta mubili Eliya mbili!» ");
INSERT INTO iyx_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mosi mu bo adumi tiini, aluusi itsuru kia tsaanda kiaduu mu viinyi la nhanyi, na akuti kio ku toso a lisoongo. Tumake nde ahaatisi lo kwaa Yiisu paa nde anywa, na aleeli: «Dikebe, bisi sa dimono mbii ti Eliya yiri mu usutulu nde nha kuruwa!» ");
INSERT INTO iyx_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yiisu aloyi mu ndaa yinene na akwi. ");
INSERT INTO iyx_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tsaanda yibabanduu mu nzo a Nziaambi, nha mbuu ya ngira, yakakii mu bibari bioolo, umata ku yulu natee ku tsini. ");
INSERT INTO iyx_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mukuutu a kama masodaare mosi, ali atemene nha kulu a Yiisu. Nde amoni buni Yiisu asieeli muwuumu, na aleeli: «Ngwanya, muutu wu beeri Mwaana a Nziaambi!» ");
INSERT INTO iyx_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kwali ka nhaa, na bakaasa bakitalila ku la. Nha kati a bo, kwali Mari musi Mangadala, Salome, Mari nguu a Yose, na Yaki wa mukee. ");
INSERT INTO iyx_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Bakaasa baa baduki Yiisu. Ni bo bakisalila nde, mu taanga di nde ali ku Ngalili. Mwali ka nhaa na bakaasa bakimi babalayi, babahaati na nde ku Yeruselemi. ");
INSERT INTO iyx_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tsitsii bu yatoori, na bu yali iluumbu kia nzilimini, pili mosi tswaamina na ukoto mu saba, ");
INSERT INTO iyx_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yoosefi, musi Arimate, alwaati ibaala kia nde, na ayimonuu kwaa mutumi Pilato. Nde ali inama imosi kia likiinzi mu pfuundu a bakuutu, na akikebe, nde ka, nziriri a Ipfumu kia Nziaambi. Nde ayeni mu uyaloombo nyutu a Yiisu kwaa Pilato. ");
INSERT INTO iyx_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato akimii bu ayuyi ti Yiisu maakwa. Nde ati mukuutu a kama masodaare mbili, paa afuulu nde mbii ti Yiisu akwa umata bele pe. ");
INSERT INTO iyx_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Bu amani na uyuu mayaabisi nde mukuutu a masodaare, nde ahi muswa kwaa Yoosefi mu uholo nyutu a Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yoosefi asuumbi tsaanda ya lino, nde asutili Yiisu nha yulu a kuruwa. Nde adii nde mu tsaanda yii, na wamusuusi mutso ngili yi basootolo mutso manya. Tumake nde anyiingili manya nha munywa a ngili. ");
INSERT INTO iyx_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mari musi Mangadala na Mari nguu a Yose, bakitala mbuu yi basuusi nyutu a Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Iluumbu kia Saba bu kialabii, Mari musi Mangadala, Mari nguu a Yaki, na Salome basuumbi mananaasa paa bakili mu nyutu a Yiisu. ");
INSERT INTO iyx_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Mu ngwaali a ngwaali a iluumbu kiatsiomi kia limiingi, mu palili a nyanga, bo bayeni ku ngili. ");
INSERT INTO iyx_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bo bakilelesine: «Na kaanyiingili bisi manya lili nha munywa a ngili?» ");
INSERT INTO iyx_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ka bu bo batoori ku ngili, bo bamoni ti bamaanyiingili manya me. Ka bunu, lo ali ngo bunene. ");
INSERT INTO iyx_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ninha bo bakoti mutso ngili. Bo bamoni nhaa mufuru a baala mosi, adiaali nha koo kia babaala, alwaati ikutu kiahembuu. Bo babayi boomo! ");
INSERT INTO iyx_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ni mu buu nde wabaleeli: «A diba na boomo pe! Beni Yiisu musi Nazareti, dili mu usaa, wu bakomo nha muti wa kuruwa? Nde siimbiaangi, na nde a li nha pe. Mono mbuu yi bali basuusu nde. ");
INSERT INTO iyx_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mu taanga di, diyene dileele kwaa miyii mia nde na kwaa Peetero: “Nde maatswaamina beni ku Ngalili. Ni kuu beni dikaamono nde, weti bu akileele beni.”» ");
INSERT INTO iyx_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ninha bo bapali mu ngili, na babati, mundaa ti bo bakiteete mu boomo na ukimuu. Na bo a baleeli ndaa pe so mosi kwaa muutu, mundaa ti bo bali na boomo.  ");
INSERT INTO iyx_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yiisu bu asiimbii mu babakwa mu ngwaali a ngwaali ya iluumbu kia limiingi, nde akwimonuu kwaa Mari musi Mangadala, wu nde apalisi miheebili tsaamba mimibi. ");
INSERT INTO iyx_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nde ayiyaabisa ndaa kwaa bali itwaari na Yiisu, mu taanga di bo bali kutso ku bukwiili na bakilili. ");
INSERT INTO iyx_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ka bu bayuyi ti Yiisu li moonyi, na ti Mari wamumoni, bo a bamusiiri imiini pe. ");
INSERT INTO iyx_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tumake, Yiisu amonii mu mutindi mukimi kwaa miyii mioolo, miali mu kuulu mu uyene ku bula. ");
INSERT INTO iyx_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bo bayiri avutuu mu uyaabisa kwaa miyii mikimi, babaheli ka usa imiini. ");
INSERT INTO iyx_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mu manini, Yiisu amonii kwaa miyii kuumi na mosi, bu bali nha meese. Nde afweengi bo mu ndaa pelili a imiini kia bo, na bu baheli usa imiini mu maleeli bo, baa bamumoni ti maasiimbuu mu babakwa. ");
INSERT INTO iyx_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Tumake nde wabaleeli: «Diyene mu tsi yoosi, diyaabisa Ndaa Yimbwe kwaa baata boosi. ");
INSERT INTO iyx_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Wu umene miaanzi mu me, na wu bakaabootuu, sa avuu. Wu uhele umene miaanzi mu me, Nziaambi sa asieembe nde. ");
INSERT INTO iyx_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Dimono biliimbi bibakaayaaba babasa imiini mu me: bo sa babingi miheebili mimibi, mu kuumbu a me. Bo sa batsuu mu mandaa ma bumweenyi. ");
INSERT INTO iyx_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bo sa bakaanga bataari mu mioo mia bo, na so bo banywiiri bisii bibituu ubiti ku likwa, bio a bituu usa bo bubi pe. Bo sa banaa mioo nha yulu a babeeri, na babeeri sa babeeluu.» ");
INSERT INTO iyx_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bu amani mu utsuu maa kwaa bo, Pfumu anaangii mu mayula na adiaali nha koo kia babaala kia Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Miyii miayeni mu uyaabisa Ndaa Yimbwe mu mambuu moosi. Pfumu akisala itwaari na bo, na akimweese ngwanya a mandaa ma nde, mu biliimbi biakiduku bo.");
INSERT INTO iyx_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Taata Teofili, bu balayi bayesini usonuu mandaa mamayilimi nha kati a bisi. ");
INSERT INTO iyx_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Bo baleeli mo, mbii bwayeelili bisi mo kwaa babali bambaangi ba mamono misi, umata mu mbaandili na bakitii bayiisi ba mandaa ma Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Me ka bu naduki bubwe-bubwe moosi mamayilimi umata mu mbaandili, me natsimi ti bwafwaana, me sonuu kwaa we, mukuutu Teofili, mbii bu malandisini. ");
INSERT INTO iyx_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Me nisa buu paa we yaaba bubwe, ngwanya a mandaa ma bayiisi we. ");
INSERT INTO iyx_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mu taanga di Erode ali mutini a itinini kia Yuuda, mwali na ngaanga a Nziaambi mosi wa kuumbu Zakaria. Nde ali mu kaba la banguu ba bangaanga la kuumbu Abia. Mukari a nde ali Elisabeti, mosi wa mu likaanda la Aaroni. ");
INSERT INTO iyx_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bo baboolo bali balibweeye nha kulu a Nziaambi, na bo bakiduku bubwe-bubwe, mikele mioosi na tumini dia Pfumu. ");
INSERT INTO iyx_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ka bo a bali na mwaana pe, mundaa ti Elisabeti ali ikumbu, na bo baboolo ali aka binunu. ");
INSERT INTO iyx_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Iluumbu imosi, Zakaria akisa isala kia nde kia bungaanga ba Nziaambi nha kulu a Nziaambi, mundaa ti kii ali iluumbu kia kaba la bo mu usala. ");
INSERT INTO iyx_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Weti bwali ipfu kia isala kia bangaanga ba Nziaambi, bo bati zeke. Nha mbisi a uta zeke, Zakaria abwi mu ipa, mu ukoto mu mbuu ya ngira ya Pfumu, mu utsuu malimbi ma mupalisa luki la tsulu yimbwe. ");
INSERT INTO iyx_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kaba loosi la baata lakuundi ku mbari mu taanga dia tsuyili a malimbi ma mupalisa luki la tsulu yimbwe. ");
INSERT INTO iyx_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Itsundu-a-tsundu, tumu a Pfumu amonii kwaa Zakaria, atemini nha koo kia babaala kia diki la tsuyili a malimbi ma mupalisa luki la tsulu yimbwe. ");
INSERT INTO iyx_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Bu Zakaria wamumoni, nde apamii na boomo bamubwiilili. ");
INSERT INTO iyx_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ka tumu a Nziaambi aleeli kwaa nde: «Zakaria, aba na boomo pe, Nziaambi maayuu ndoombili a we, na mukari a we Elisabeti sa abutulu we mwaana wa baala. We sa luu nde kuumbu Yowani. ");
INSERT INTO iyx_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","We sa yaanga na uba na kinyi, baata balaa sa bayaanga mu mbutili a nde. ");
INSERT INTO iyx_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mundaa ti, nde sa aba wumunene nha kulu a Pfumu. Nde a unywa viinyi na mala makimi mamukolo pe, ka sa aluulu mu Muheebili wa Ngira, umata mu moonyo a nguu a nde. ");
INSERT INTO iyx_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nde sa akiingili baana ba Iseraeli balaa kwaa Pfumu, Nziaambi a bo. ");
INSERT INTO iyx_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Yowani sa asa isala kia Nziaambi mu muheebili na lituu, weti bia mubili Eliya. Nde sa uvuutu mitimi mia bataayi na mia baana ba bo, mu ukiingili mayele ma bangaa kene paa baba balibweeye. Ni mu buu, nde sa ayiluu baata babayilimi mu Pfumu.» ");
INSERT INTO iyx_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ka Zakaria aleeli kwaa tumu: «Buni me kaayaaba ti mii mia ngwanya, mundaa ti me na mukari a me bisi aka binunu?» ");
INSERT INTO iyx_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tumu avutili, aleeli kwaa nde: «Me ni tumu Ngabriyeli, wu li mu utemene nha kiinzi kia Nziaambi. Nde maatsinduu me mu umoo na we na uleele ndaa yimbwe yi. ");
INSERT INTO iyx_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Bu we heli usa imiini mu mandaa ma me, we sa ba baba, natee mandaa maa muyilimi mu taanga dia mo.» ");
INSERT INTO iyx_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mu diina taanga dii, baata babakikebe Zakaria bakimii bu adiingi nha mbuu ya ngira. ");
INSERT INTO iyx_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ka bu nde apali, nde a atuuyi utsuu na bo pe. Baata bayaabi ti, nde bayi monini a Nziaambi nha mbuu ya ngira: nde makulu asi biliimbi kwaa bo mu umweese ti nde ka baba. ");
INSERT INTO iyx_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Bu biluumbu bia isala kia nde mu nzo a Nziaambi biakuyi, Zakaria avutii ku nzo a nde. ");
INSERT INTO iyx_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Biluumbu bu bialabii, mukari a nde, Elisabeti, ayolili yimi na asweemi batsuungi bataana. Nde aleeli kutso mutimi: ");
INSERT INTO iyx_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Mono mi Pfumu amaayiluu mu me, mu taanga di, nde maakuulu me mu ndaa yaba mu usa litsoro la me nha kulu a baata.» ");
INSERT INTO iyx_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mu tsuungi wa basamina, Nziaambi atsindii tumu Ngabriyeli ku ngaanda a Ngalili, ya kuumbu Nazareti, ");
INSERT INTO iyx_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kwaa nduumbu yali keni babaala uyaaba pe. Kuumbu a nduumbu me ali Mari. Ali balasina nde mu makweele kwaa baala la kuumbu Yoosefi, wa mu likaanda la Daavidi. ");
INSERT INTO iyx_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Tumu akoti mu nzo a nde, na wamuleeli: «Ba na kinyi, we luuli mu kolokolo! Pfumu li na we.» ");
INSERT INTO iyx_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mari apamii kwa mifuri, mu mandaa maa. Nde atsimi mambiindili ma bwee la pili yi. ");
INSERT INTO iyx_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ka tumu aleeli kwaa nde: «Mari, aba na boomo pe, mundaa ti we bayi bweese kwaa Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mono, we sa yololo yimi na ubutu mwaana wa baala, we sa luu nde kuumbu Yiisu. ");
INSERT INTO iyx_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nde sa aba muutu wumunene, na baata sa bata nde mwaana a Nziaambi wa ku kati a yula. Pfumu Nziaambi sa aha nde mbata a ipfumu kia kaa a nde Daavidi. ");
INSERT INTO iyx_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Sa aba mutini a nzo a Yaakobi bilimi na bilimi, ipfumu kia nde a iba na manini pe.» ");
INSERT INTO iyx_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mari aleeli kwaa tumu: «Buni makaayilimi, mundaa ti me a nayaaba babaala pe?» ");
INSERT INTO iyx_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Tumu avutili, aleeli kwaa nde: «Muheebili wa Ngira sa ayiri nha yulu a we, na lituu la Nziaambi wa ku kati a yula, sa lifuu we mu posi a nde. Ni mu buu, mwaana wu we kaabutu, sa aba wa Ngira na sa bata nde Mwaana a Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Elisabeti, musi nzo a we, ka na yimi mu bununu ba nde. Nde sa abutu mwaana wa baala. Muutu wu bakita ikumbu, yimi la nde ka mu tsuungi wa basamina. ");
INSERT INTO iyx_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Mundaa ti, Nziaambi a ubaakono ndaa so mosi pe.» ");
INSERT INTO iyx_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ka Mari aleeli: «Me mutee a Pfumu. Nyaala buba mbii buli mandaa ma we.» Na tumu asiisi nde. ");
INSERT INTO iyx_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Biluumbu biaduki, Mari atemini, ayeni mawasa ku tsi ya milaanda ku ngaanda a Yuuda. ");
INSERT INTO iyx_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Akoti mu nzo a Zakaria, na abii Elisabeti. ");
INSERT INTO iyx_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Bu Elisabeti ayuyi bwee la Mari, mwaana atsuli mu kinyi mu moonyo a nde, na Elisabeti aluuli mu Muheebili wa Ngira, ");
INSERT INTO iyx_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","na aloyi mu mifuri: «Nziaambi siemi we nha kati a bakaasa boosi, na lisieme la nde sa liba nha yulu a mwaana wu we kaabutu. ");
INSERT INTO iyx_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Me na ndi, paa nguu a Pfumu a me ayiri kwaa me? ");
INSERT INTO iyx_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ka mono, bunzuyi muniingi a bwee la we, mwaana tsuli mu kinyi mu moonyo a me. ");
INSERT INTO iyx_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kinyi kwaa we. We siiri imiini ti, Pfumu sa akuusu mi nde aleeli!» ");
INSERT INTO iyx_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mari aleeli: «Mu muwuumu a me woosi me nikiinzi Pfumu. ");
INSERT INTO iyx_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Muwuumu a me aluulu mu kinyi, mundaa ti: Nziaambi ni Muyobili a me. ");
INSERT INTO iyx_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ka nde tooni usuusu misi mia nde, nha yulu a booyi la nde. Umata lolo li natee mu mataanga makaayira, makubu moosi sa mata me ngaa kinyi. ");
INSERT INTO iyx_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ka Nziaambi Puungu-lituu maayiluu mandaa ma manene mu me. Kuumbu a nde yili ya ngira. ");
INSERT INTO iyx_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ngebe a nde yili mu makubu na makubu, kwaa babubaankiinzanga nde. ");
INSERT INTO iyx_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nde amweesi lituu mu mifuri mia nde, atsiali bangaa liwaa. ");
INSERT INTO iyx_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nde abwiisi mitini mu mambata ma bipfumu bia bo, na anaangili babakuluu, mu usuusu bo nha mbata ya tsiomi. ");
INSERT INTO iyx_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nde ayutisi babakwa nzala mu biloo bibibwe. Abingi bisini mioo na mioo. ");
INSERT INTO iyx_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nde abaasili Iseraeli, ni booyi la nde: mu ulibili ngebe a nde moonyi, ");
INSERT INTO iyx_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","kwaa Abraami na bateeri ba nde, mu bilimi na bilimi, weti bu alasini kwaa bakaa ba bisi.» ");
INSERT INTO iyx_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mari adiaali na Elisabeti helape batsuungi batata, tumake nde avutii ku nzo a nde. ");
INSERT INTO iyx_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Taanga dia Elisabeti dia ubutu bu diatoori, nde abuti mwaana wa baala. ");
INSERT INTO iyx_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Bambaayi ba nde ba bebele na basi nzo ba nde bu bayuyi ti Pfumu amweesi ngebe dia nde dialaa mu nde, bayaangi na nde. ");
INSERT INTO iyx_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mu iluumbu kia pwoombo, bo bayiri mundaa ukese imwamwaana. Batooni uluu kio kuumbu a taayi a nde Zakaria. ");
INSERT INTO iyx_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ka nguu a imwamwaana aleeli: «Pia, a kuumbu yii pe, sa bata nde Yowani.» ");
INSERT INTO iyx_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ka bo baleeli kwaa nde: «Mu basi nzo ba we, a uli na muutu ngaa kuumbu yii pe!» ");
INSERT INTO iyx_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ni mu buu, bo bafuuli taayi a mwaana mu biliimbi, ki kuumbu nde atooni uluu imwamwaana. ");
INSERT INTO iyx_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakaria aloombi itsuru kia bala mu usonuu, na asonii: «Yowani ni kuumbu a nde.» Boosi bakimii. ");
INSERT INTO iyx_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nhaa-na-tsi, Zakaria abaandii utsuu. Nde abili Nziaambi mu ndaa yinene. ");
INSERT INTO iyx_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Boomo babwiilili bambaayi ba nde ba bebele boosi. Mvuungu a mandaa maa moosi, yayeni mu tsi yoosi ya milaanda mia Yuuda. ");
INSERT INTO iyx_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Bo boosi babayuyi mandaa maa, bakitsimi na bafulusunu: «Imwamwaana ki buni ikaaba?» Ngwanya, koo kia Pfumu kiali na nde. ");
INSERT INTO iyx_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakaria, taayi a imwamwaana, aluuli mu Muheebili wa Ngira. Nde abaandii ubili, na aleeli: ");
INSERT INTO iyx_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Mbilili kwaa Pfumu, Nziaambi a Iseraeli, bu nde akiingii kwaa baata ba nde na wabakuuli. ");
INSERT INTO iyx_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nde atsindii bisi Muyobili wa lituu, mosi wa mu nzo a Daavidi, booyi la nde, ");
INSERT INTO iyx_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","mbii bu nde atsuuyi mu minywa mia mibili mia nde mia ngira, umata bele pe. ");
INSERT INTO iyx_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nde alasini kuulili a bisi nha mioo mia mitaata mia bisi na boosi ba bubaabele bisi, ");
INSERT INTO iyx_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","nde amweesi bweese ba nde kwaa bataayi ba bisi na a adiimbili pe lilasina la nde la ngira. ");
INSERT INTO iyx_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Mbii bu Nziaambi asi lilasina kwaa Abraami, ni taayi a bisi, ");
INSERT INTO iyx_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","mu ndaa ukuulu bisi nha mioo mia mitaata, paa diamusalila kwahele a boomo, ");
INSERT INTO iyx_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","paa diba bangira na balibweeye nha kiinzi kia nde, mu pasi iluumbu kia idiingi kia bisi. ");
INSERT INTO iyx_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ka we mwaana a me, we sa ba mubili a Nziaambi waku kati a yula, we sa tswaamina nha kulu a Pfumu, mu uyiluu kuulu a nde, ");
INSERT INTO iyx_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","mu uyaabisa baata ba nde ti, nde li mu uyiri mu uyobolo bo mu nyaalili a masumu ma bo. ");
INSERT INTO iyx_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Mu ngebe na libweeye la nde, Nziaambi a bisi sa ayalisa bisi mu liyalila la yula, lafwaanina na liyalila la nyanga ya ngwaali. ");
INSERT INTO iyx_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Mu uyalisa ba bali mu uba kutso pimisi na pwosi ya likwa, mu usuungusu taambi dia bisi mu kuulu a iyeenge.» ");
INSERT INTO iyx_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Na mwaana akikulu na akihama mu muheebili. Nde ali mu tsi ya tsata, natee iluumbu ki amonii kwaa Iseraeli. ");
INSERT INTO iyx_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mu taanga dii, Kayisari Ongusta apalisi mukaanda watumi ti, baata boosi basonomo mu uyaaba litaanga la baata mu tsi yoosi. ");
INSERT INTO iyx_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Litaanga lii ni latsiomi li basiiri, bu Kilenio ali mutumi mu itinini kia Siria. ");
INSERT INTO iyx_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Boosi bayeni ku usonomo, pasi muutu mu ngaanda a nde. ");
INSERT INTO iyx_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yoosefi, mosi wa nzo a Daavidi, amati ku Ngalili mu ngaanda a Nazareti na ayeni ka ku ngaanda a Betelemi, mu itinini kia Yuuda, ni ngaanda a mutini Daavidi. ");
INSERT INTO iyx_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nde ayeni kuu, paa basonomo na nduumbu a nde Mari wali na yimi. ");
INSERT INTO iyx_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bu bali ku Betelemi, iluumbu kia Mari kia ubutu kiatoori. ");
INSERT INTO iyx_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nde abuti mwaana wa tsiomi wa baala, wamudii matsaanda, wamusuusi mu idiilili kia banyama, mundaa ti a babayi mbuu pe mu nzo a bieenyi. ");
INSERT INTO iyx_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mu itinini kia tsi yii, mwali na bakebi ba biboori bakila mu matsiee mu ukebe biboori bia bo. ");
INSERT INTO iyx_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tumu a Pfumu amonii kwaa bo. Buzitu ba Pfumu bayalisi bo mu peembi na peembi, bamoni boomo balaa. ");
INSERT INTO iyx_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ka tumu a Nziaambi aleeli kwaa bo: «A diba na boomo pe, ka me nadileeli ndaa yimbwe yikaaha kinyi yalaa kwaa baata boosi, ");
INSERT INTO iyx_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Lolo li mu ngaanda a Daavidi, badibutuli Muvuuyisi, ni Kristo Pfumu. ");
INSERT INTO iyx_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Mono iliimbi ki beni dikaayaaba nde: beni sa disololo mwaana wa ikenyi wubadii matsaanda mu idiilili kia banyama.» ");
INSERT INTO iyx_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Itsundu-a-tsundu, mukaanga a batumu ba mayula avuutini na tumu a Nziaambi wuu, babili Nziaambi, baleeli: ");
INSERT INTO iyx_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Buzitu kwaa Nziaambi mu kati a mayula, na iyeenge nha tsi, nha kati a baata ba nde atoono.» ");
INSERT INTO iyx_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Bu batumu basiisi bo na bavutii ku yula, bakebi ba biboori baleelisini: «Tsweendani natee ku Betelemi, dimonani mandaa ma mayilimi ma Pfumu ayaabisi bisi.» ");
INSERT INTO iyx_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bayeni mawasa, basolili Mari na Yoosefi na mwaana wa ikenyi wubalaasa mu idiilili kia banyama. ");
INSERT INTO iyx_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bu bo bamoni nde, bayaabisi mandaa ma tumu a Nziaambi ayaabisi bo, mundaa a imwamwaana kii. ");
INSERT INTO iyx_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bo boosi bayuyi mo, bakimii mu mi bakebi ba biboori baleeli kwaa bo. ");
INSERT INTO iyx_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ka Mari akebi mandaa maa moosi bubwe mu mutimi a nde, na akitsimi mu mo. ");
INSERT INTO iyx_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bakebi ba biboori bavutii, bakiinzi na babili Nziaambi mu moosi ma bayuyi na ma bamoni, mbii bu tumu a Nziaambi aleeli kwaa bo. ");
INSERT INTO iyx_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Biluumbu pwoombo nha mbisi a mbutili, taanga dia ukese mwaana bu diatoori, bamuluyi kuumbu Yiisu, mbii bwayaabisi tumu, bu nguu a nde ali keni yimi ubaa pe. ");
INSERT INTO iyx_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Biluumbu bia tsieemini a bo bu biatoori, weti bu li mikele mia Mooso, Yoosefi na Mari babiti mwaana ku Yeruselemi. Bo babiti nde kuu, mu umweese nde kwaa Pfumu, ");
INSERT INTO iyx_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","mbii bu basonuu mu mikele mia Pfumu: «Pasi mwaana wa tsiomi wa baala, sa aba wa ngira wa Pfumu.» ");
INSERT INTO iyx_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Bo baha ka mu bungori, «biduduu bioolo so baana boolo ba mabeembe» mbii bu baleeli mu mikele mia Pfumu. ");
INSERT INTO iyx_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ka mono, mu Yeruselemi mwali na muutu wa kuumbu Simeoni, ni muutu walibweeye na wakangama mu Nziaambi. Nde akikebe muvuuyisi a Iseraeli. Muheebili wa Ngira ali na nde. ");
INSERT INTO iyx_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Muheebili wa Ngira akwiyaabisa kwaa nde ti: «We a ukwa pe, natee bu we umono Kristo wa Pfumu.» ");
INSERT INTO iyx_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Muheebili wa Ngira abiti Simeoni ku nzo a Nziaambi. Mu taanga dii, Mari na Yoosefi babiti imwamwaana Yiisu mu nzo muu, paa bakuusu mikele mia Pfumu mu nde. ");
INSERT INTO iyx_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeoni wamuholi mu mioo mia nde, avutili matoondo kwaa Nziaambi, aleeli: ");
INSERT INTO iyx_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Pfumu, mu taanga di ndasina dia we dimaakuu, nyaala booyi la we liwuumu mu iyeenge. ");
INSERT INTO iyx_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Mundaa ti, misi mia me mimaamono liyobolo la we, ");
INSERT INTO iyx_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ni liyobolo li we ayiluu kwaa baata boosi: ");
INSERT INTO iyx_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ni liyalila la nziaabisi a we kwaa matsi moosi, na likaaba buzitu kwaa baata ba we, Iseraeli.» ");
INSERT INTO iyx_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Taayi na nguu a Yiisu bakimii, mu mandaa ma Simeoni aleeli mu imwamwaana. ");
INSERT INTO iyx_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeoni asiemi bo, aleeli kwaa Mari nguu a Yiisu: «Mono mwaana wuunawu sa aba mbwiilili na teminini a babalayi mu Iseraeli. Na nde sa aba iliimbi ki baata bakaahele uyuhusunu. ");
INSERT INTO iyx_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nde sa asuusu nha liyalila matsimi ma masweeme mu mitimi mia baata balaa. Ka Mari, we sa mono pasi dialaa, weti muutu wubamaapii mukasa.» ");
INSERT INTO iyx_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kwali ka Aana, mubili wa mukaasa, mwaana a Fanuweli, wa mu ifuumbu kia Aseri. Nde ali na bilimi bialaa. Nde adiaali na mulumi a nde, ndila bilimi tsaamba, umata bu akweeli nde mu buduumbu ba nde. ");
INSERT INTO iyx_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Nde asiaali mukwiili, natee mu iteesi kia bilimi maku pwoombo na bina (84). Nde a asiisi nzo a Nziaambi pe, ka asialili Nziaambi mu udii mutuutu na ukuundu butsuu na nyanga. ");
INSERT INTO iyx_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nde ka atoori mu taanga dii, avutili matoondo kwaa Nziaambi, atsuuyi mu mwaana kwaa baata boosi, babakikebe ti Nziaambi akuulu Yeruselemi. ");
INSERT INTO iyx_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Bu bamani uyiluu mandaa moosi mbii buli mikele mia Pfumu, bibuti bia Yiisu biavutii ku Ngalili, ku ngaanda a bo ya Nazareti. ");
INSERT INTO iyx_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mwaana akikulu, akihama, akiluulu mu buyeri. Bweese ba Nziaambi bali nha yulu a nde. ");
INSERT INTO iyx_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Taayi na nguu a Yiisu, bakiyene pasi ilimi ku Yeruselemi mu mukuungi a Paaka. ");
INSERT INTO iyx_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yiisu bu atoosi bilimi kuumi na bioolo, bo bayeni kuu mbii bwali ipfu kia mukuungi. ");
INSERT INTO iyx_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Bu mukuungi awiiri, na bo bavutii, mwaana a bo Yiisu asiaali ku Yeruselemi, ka taayi na nguu a bayaabi buu pe. ");
INSERT INTO iyx_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Mu matsimi ma bo, Yiisu ali mu kaba la bambaayi babavuuti kuulu na bo. Bo bayeni kuulu ya iteesi kia iluumbu ki ibiimbili, bamusiayi nha kati a basi nzo ba bo, na babayabisina na bo. ");
INSERT INTO iyx_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ka bu bamukooni usololo, bavutii ku Yeruselemi mu usaa nde. ");
INSERT INTO iyx_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nha mbisi a biluumbu bitata, tumi bamusolili mu nzo a Nziaambi mu nde ali adiaala nha kati a bakuutu ba mikele, akiyuululu bo na ufuulu bo manduru. ");
INSERT INTO iyx_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Boosi babakiyuu Yiisu, bakimii mu mayele na mu mamvutu ma nde. ");
INSERT INTO iyx_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Bu taayi na nguu a nde bamumoni, bo bakimii. Nguu a nde wamuleeli: «Mwaana, mu ima we siiri bisi bu? Mono, bisi a taayi a we dimaasaa we mu tsoongo.» ");
INSERT INTO iyx_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nde avutili kwaa bo: «Mu ima dili mu usaa me? Ka beni a diyaaba pe ti, me nafwaana uba mu mandaa ma taayi a me?» ");
INSERT INTO iyx_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ka a bayaabi pe mandaa ma nde aleeli kwaa bo. ");
INSERT INTO iyx_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yiisu avutii na bo ku Nazareti. Nde ali akuluu nha kulu a bo. Nguu a nde akebi bubwe mandaa maa moosi mu mutimi a nde. ");
INSERT INTO iyx_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yiisu akuli mu mutele, mu buyeri, na abayi bweese kwaa Nziaambi na kwaa baata. ");
INSERT INTO iyx_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mu ilimi kia kuumi na bitaana kia tumini a mutini Tibere Kayisari, Ponse Pilato akitumu mu itinini kia Yuuda, Erode akitumu mu itinini kia Ngalili, Filipo ni mwaana a nguu a nde, akitumu mu bitinini bia Ituraya na Trakoniti, na Lisanya akitumu mu Abilene. ");
INSERT INTO iyx_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Mu taanga di Aana na Kayifa bali banguu ba bangaanga ba Nziaambi, mandaa ma Nziaambi mayuyini mu tsi ya tsata kwaa Yowani, ni mwaana a Zakaria. ");
INSERT INTO iyx_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yowani ayeni mu itinini kioosi kiadiengelele Yorodaani. Nde akiyaabisa kwaa baata boosi: «Disobo ndiaatili a beni, diholo libootuu. Tumake, Nziaambi sa asa masumu ma beni kolokolo.» ");
INSERT INTO iyx_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Mbii bu basonuu mu mukaanda a Yeesaya, mubili: «Ndaa mosi yili mu uloo mu tsi ya tsata: Yiluwani kuulu a Pfumu, suungusani misoo mia nde! ");
INSERT INTO iyx_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Pasi mbeenge sa baluusu, milaanda mio osi na bibindi bioosi sa bakululu, pasi muli na mafutu sa basuungusu, makuulu ma mamanya sa balenge. ");
INSERT INTO iyx_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Baata boosi sa bamono liyobolo la Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Makoongi mayiri kwaa Yowani mu uholo libootuu. Nde wabaleeli: «Beni ifuumbu kia bapili! Na wadiyiisi mu usaa ubata kesi a Nziaambi, yi ka bebele? ");
INSERT INTO iyx_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Dimweese mbutu dili mu uta imbaangi ki ibwe mu kiingili a mayele ma beni, ka a dileele pe mu matsimi ma beni: “Abraami li kaa a bisi.” Ka me nadileeli: Nziaambi utuu ukitisi mamanya ma, mu uba bateeri ba Abraami! ");
INSERT INTO iyx_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ka lolo, pibi yimaayilimi mu ukese muti nha miaanzi: Pasi muti wu uhele ubutu mbutu dimbwe, sa bakwaanga na udumunu nde ku mbaa.» ");
INSERT INTO iyx_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Makoongi mamufuuli, maleeli: «Ka ima diafwaana usa?» ");
INSERT INTO iyx_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nde avutili, aleeli kwaa bo: «Pasi wuli na bikutu bioolo, aha imosi kwaa wahele na ikutu. Wuli na bia udia, asa pili mosi.» ");
INSERT INTO iyx_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Batoli ba limaanda bayiri ka mu uholo libootuu, baleeli kwaa Yowani: «Muyiisi, buni diafwaana usa?» ");
INSERT INTO iyx_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nde avutili kwaa bo: «A diholo pe tala yavulu nha yulu a yibakese.» ");
INSERT INTO iyx_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Masodaare ka mamufuuli, baleeli: «Bisi ka buni diafwaana usa?» Yowani aleeli kwaa bo: «A dipatila mboongo dia muutu pe, na a difuundu muutu kwahele a toono pe, ka disiingi ndila mufutu a beni wu beni dili mu ubaa.» ");
INSERT INTO iyx_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Bu baata bakikebe, na bu boosi bakifulusunu ti, helape Yowani ni Kristo. ");
INSERT INTO iyx_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yowani avutili, aleeli kwaa bo boosi: «Me ndi mu ubootuu beni mu maamba, ka wuli mu uyiri avulu me mu lituu. Me a nafwaana so mu unyangila misiingi mia bikoori bia nde pe. Nde sa wadibootuu mu Muheebili wa Ngira na mu mbaa. ");
INSERT INTO iyx_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nde akaanga iyengese mu koo kia nde, paa asoolo mbutu dimbwe na usiisi bifufuri. Nde sa akukuu mbutu dimbwe ku yulu a ibaanga, na utsuu bifufuri ku mbaa yiyihele udimi.» ");
INSERT INTO iyx_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Bu akita bibili bikimi kwaa bo, Yowani ayaabisi ndaa yimbwe kwaa boosi. ");
INSERT INTO iyx_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yowani asieembi Erode mundaa a Erodia, mukari a mwaana a nguu a n de, na mu mandaa moosi makimi mamabi mayilii Erode. ");
INSERT INTO iyx_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nha yulu a maa, Erode abwiyiluu ndaa kimi yavulu bubi, nde aloosi Yowani mu perese. ");
INSERT INTO iyx_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Baata boosi bu bamani uholo libootuu, Yiisu ka bamubootii. Bu akikuundu, yula ladibini, ");
INSERT INTO iyx_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","na Muheebili wa Ngira akulini mu ifwa-fwani kia beembe nha yulu a nde. Mu mayula mwayuyini ndaa: «We ni mwaana a me wa litoono. Mu we me ndi na kinyi yalaa.» ");
INSERT INTO iyx_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yiisu ali hele maku matata ma bilimi bu abaandii uyiisi. Baata batsimi ti nde ni mwaana a Yoosefi, wuli mwaana a Eliya, ");
INSERT INTO iyx_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","wa Matati, wa Levi, wa Meleki, wa Yanayi, wa Yoosefi, ");
INSERT INTO iyx_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","wa Matatiasi, wa Amosi, wa Nawumi, wa Eseli, wa Nangayi, ");
INSERT INTO iyx_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","wa Maati, wa Matatiasi, wa Simeyi, wa Yoseki, wa Yoda, ");
INSERT INTO iyx_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","wa Yowanani, wa Lesa, wa Zorobabeeli, wa Salatieeli, wa Neri ");
INSERT INTO iyx_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","wa Maleki, wa Adi, wa Kosami, wa Elemedami, wa Eri, ");
INSERT INTO iyx_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","wa Yiisu, wa Eliseri, wa Yorimi, wa Matati, wa Levi, ");
INSERT INTO iyx_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","wa Simeoni, wa Yuuda, wa Yoosefi, wa Yonami, wa Eliyakimi, ");
INSERT INTO iyx_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","wa Meleya, wa Mena, wa Matata, wa Natani, wa Daavidi, ");
INSERT INTO iyx_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","wa Yese, wa Obedi, wa Booze, wa Sala, wa Naasoni, ");
INSERT INTO iyx_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","wa Aminadabi, wa Adamini, wa Arani, wa Eseroni, wa Peresi, wa Yuuda, ");
INSERT INTO iyx_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","wa Yaakobi, wa Isaki, wa Abraami, wa Tera, wa Nawori, ");
INSERT INTO iyx_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","wa Saruki, wa Rangawu, wa Faleki, wa Eberi, wa Sala, ");
INSERT INTO iyx_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","wa Kayinami, wa Arafakadi, wa Semi, wa Nowa, wa Lameki, ");
INSERT INTO iyx_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","wa Matusala, wa Enoki, wa Yaredi, wa Malaleli, wa Kayinami, ");
INSERT INTO iyx_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","wa Enosi, wa Seti, wa Aadami, mwaana a Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yiisu aluuli mu Muheebili wa Ngira bu amati ku Yorodaani, Muheebili wamubiti ku tsi ya tsata. ");
INSERT INTO iyx_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Saatina wamusi mapuusu mu maku mana ma biluumbu. Yiisu a adi iloo mu biluumbu bii pe. Biluumbu bii bu bialabii, nde abayi nzala. ");
INSERT INTO iyx_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Saatina aleeli kwaa nde: «So we ni mwaana a Nziaambi, leele kwaa manya li paa likituu lipa.» ");
INSERT INTO iyx_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yiisu avutili kwaa nde: «Basonuu: “Muutu a uba moonyi mu ndila lipa pe.”» ");
INSERT INTO iyx_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Saatina wamubiti nha mbuu yanaanguu, na mu mwaana taanga hoolo, nde wamumweesi bipfumu bioosi bia tsi. ");
INSERT INTO iyx_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Nde aleeli kwaa Yiisu: «Me sa ha we lituu li loosi na busini ba matsi ma. Mundaa ti, bi bioosi baha bio kwaa me, na me utuu uha bio kwaa pasi nde wu me natoono. ");
INSERT INTO iyx_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","So we tsukini nha kulu a me, bi bioosi sa biba bia we.» ");
INSERT INTO iyx_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yiisu avutili, aleeli kwaa nde: «Basonuu: “Ndila Pfumu Nziaambi a we, we afwaana ukuundu, na usalila.”» ");
INSERT INTO iyx_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Saatina wamubiti ku Yeruselemi, wamusuusi nha yulu a nzo a Nziaambi, na aleeli kwaa nde: «So we ni Mwaana a Nziaambi, patuu na bwa nha tsi, ");
INSERT INTO iyx_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","mundaa ti basonuu: “Nziaambi sa atsinduu batumu ba nde, mu ukebe we.” ");
INSERT INTO iyx_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Na “bo sa banaangila we mu mioo mia bo, paa kuulu kia we ihele ukubu baka mu manya.”» ");
INSERT INTO iyx_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yiisu avutili, aleeli kwaa nde: «Basonuu ka: “A yesine Pfumu Nziaambi a we pe.”» ");
INSERT INTO iyx_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Saatina bu amani usa Yiisu mapuusu mu makuulu moosi, nde asiisi Yiisu na tee mu taanga kimi. ");
INSERT INTO iyx_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yiisu avutii ku itinini kia Ngalili, aluuli mu lituu la Muheebili wa Ngira. Mvuungu a nde yatsiaami mu itinini kii kioosi. ");
INSERT INTO iyx_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nde akiyiisi mu manzo ma makutunu ma Bayuudayo, na baata boosi bakibili nde. ");
INSERT INTO iyx_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yiisu ayeni ku ngaanda a Nazareti ku nde akuli. Akoti mu nzo a makutunu ma Bayuudayo, mbii bwali ipfu kia nde mu iluumbu kia puumini. Nde atemini mu utaanga Mabasonuu ma Ngira. ");
INSERT INTO iyx_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bamuhi mukaanda a mubili Yeesaya. Bu amani unyangila mukaanda wuu, nde amoni mbuu yibasonuu: ");
INSERT INTO iyx_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Muheebili a Pfumu li na me, mundaa ti nde abiaalisi me mu uyaabisa ndaa yimbwe kwaa bawele. Nde atsindii me mu uyaabisa bunyanga kwaa makori, na monini kwaa bingimangimi, na mu uvuusu babali kutso kwaamisa, ");
INSERT INTO iyx_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","mu uyaabisa ilimi kia bweese ba Pfumu.» ");
INSERT INTO iyx_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nde afutii mukaanda, avutili nde kwaa musiali a nzo a makutunu ma Bayuudayo, tumake ni adiaali. Baata boosi babali mutso nzo a makutunu a Bayuudayo bamutali. ");
INSERT INTO iyx_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nde abaandii uleele kwaa bo: «Mu iluumbu ki, mandaa ma beni dimaayuu mu matswi ma beni, mamaayilimi.» ");
INSERT INTO iyx_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Boosi bati imbaangi ki ibwe mu nde, bakimii mu mandaa mamabwe mapali mu munywa a nde, baleeli: «Wu a ni mwaana a Yoosefi pe?» ");
INSERT INTO iyx_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nde aleeli kwaa bo: «Ngwanya, beni sa dita tsaba yi mu me: mubuyi, beeluu mu iwe-makulu. Moosi ma bisi diayuyi ti we ayilii mo ku ngaanda a Kapernawumi, yiluu ka mo mu tsi a we makulu.» ");
INSERT INTO iyx_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ka nde abwileele: «Ngwanya me nadileeli: a uli na mubili so mosi pe, wububaasiingi mu tsi a nde makulu. ");
INSERT INTO iyx_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mu ngwanya, me nadileeli: mu taanga dia mubili Eliya, mvulu asi bilimi bitata na batsuungi basamina kwahele a unoo mu tsi a Iseraeli. Tsi yoosi yakoti mu tsata yalaa. Mu taanga dii, mwali ka na bakwiili balaa mu Iseraeli. ");
INSERT INTO iyx_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ka Nziaambi a atsindii Eliya kwaa so mosi mu bo pe, ka ndila kwaa mukwiili mosi wali mu Sarepita, mu tsi a Sidoni. ");
INSERT INTO iyx_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Mu Iseraeli mwali ka na bangaa bwaari balaa mu taanga dia mubili Elisa. Bunu, so mosi pe mu bo abeelii. Ka ndila Namani, musi Siria.» ");
INSERT INTO iyx_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Boosi mu nzo a makutunu ma Bayuudayo baluuli mu kesi, bu bayuyi mandaa maa, ");
INSERT INTO iyx_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","batemini, bamupalisi ku mbari a ngaanda, bamubeyi na tee nha yulu a mbeenge a mulaanda wu batuungu ngaanda a Nazareti, paa bamukilimisi. ");
INSERT INTO iyx_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ka nde ayoyi nha kati a bo, ayeni wa nde. ");
INSERT INTO iyx_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yiisu ayeni ku ngaanda a Kapernawumi, mu itinini kia Ngalili ku akiyiisi mu iluumbu kia saba. ");
INSERT INTO iyx_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Baata bakimii mu nziisili a nde, bu akitsuu na lituu. ");
INSERT INTO iyx_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mu nzo a makutunu ma Bayuudayo, mwali na muutu wali na muheebili wumubi. Nde aloyi mu ndaa yinene na aleeli: ");
INSERT INTO iyx_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Aa Yiisu! Musi Nazareti! We yo ki ndaa li na yo na bisi? Mu ufuhusu bisi we yiri? Me nayaaba bubwe we na li, we ni wa Ngira wa Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yiisu wamusieembi, aleeli: «Wuru kele, pala mu muutu wu.» Muheebili wumubi abwiisi muutu wuu nha kati a baata boosi, apali mu nde, ka a wamumweesi pasi pe. ");
INSERT INTO iyx_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Boosi bakimii, balelisini: «Yi ki pili a ndaa yi? Muutu wu li mu utumu miheebili mimibi, mu lituu na mifuri na mio mili mu upala!» ");
INSERT INTO iyx_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Mvuungu a Yiisu yatsiaamii mu itinini kia tsi kioosi. ");
INSERT INTO iyx_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yiisu bu apali mu nzo a makutunu ma Bayuudayo, ayikoto mu nzo a Simooni. Buko ba Simooni wa mukaasa ali na baa la mifuri, babali mu nzo muu baloombi kwaa Yiisu, abeelisi nde. ");
INSERT INTO iyx_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yiisu abaandini nha yulu a mubeeri, asieembi baa. Lo lasiisi mubeeri, nhaa-na-tsi, mubeeri uyaaba utemene na usalila bo. ");
INSERT INTO iyx_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Taanga bu diadiaami, boosi babali na baata bangaa bibeeri bia mupili na mupili mu manzo, babeyi bo kwaa Yiisu. Nde wababeelisi, bu anayi mioo nha yulu a muutu-muutu. ");
INSERT INTO iyx_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Miheebili mimibi ka miapali mu balayi, mialoyi, mialeeli: «We ni Mwaana a Nziaambi!» Nde asieembi mio, a anyaali mio mitsuu pe, mundaa ti mio miayaabi ti nde ni Kristo. ");
INSERT INTO iyx_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Bukia ngwaali, Yiisu apali, ayeni ku mbuu yatakuu yahele a baata. Makoongi ma baaata mamusiayi, bu bo basolili nde, bo bayiri kwaa nde. Bo a batooni pe ti nde asiisi bo. ");
INSERT INTO iyx_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ka Yiisu aleeli kwaa bo: «Me nafwaana uyaabisa ndaa yimbwe ya Ipfumu kia Nziaambi mu mangaanda makimi ka, ni mu ndaa yii Nziaambi atsinduu me.» ");
INSERT INTO iyx_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Na nde akiyiisi mu manzo ma makutunu ma Bayuudayo ma mu Yuuda. ");
INSERT INTO iyx_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Iluumbu imosi, Yiisu bu atemini nha peembi a diaanga la Ngenesareti, koongi yamupinyini mu uyuu mandaa ma Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nde amoni mabootu moolo mali nha simi la diaanga. Balobi ba batswi basutii mu mo mu uswaa masiele ma bo. ");
INSERT INTO iyx_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yiisu akoti mu mosi mu mabootu maa, ni bootu la Simooni. Yiisu wamuloombi mu utakuu hoolo na simi. Yiisu adiaali mu bootu na abaandii uyiisi makoongi. ");
INSERT INTO iyx_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Bu amani uyiisi, Yiisu aleeli kwaa Simooni: «Diyene nha maamba mali na musundu, didumunu masiele ma beni mu ubaa batswi.» ");
INSERT INTO iyx_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simooni avutili, aleeli: «Muyiisi, bisi dimaasala butsuu bubiimbili, ka a dibayi iloo pe. Ka mu ndaa bu we leeli, me nidumunu masiele.» ");
INSERT INTO iyx_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nha mbisi a udumunu masiele, bo babayi batswi balaa na masiele ma bo mabaandii ukakuu. ");
INSERT INTO iyx_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Bo bati bambaayi ba bo babali mu bootu lilikimi mbila, paa bababasila. Bo bayiri, baluusi mabootu mo mamoolo mu batswi, na mo makeni udiaama. ");
INSERT INTO iyx_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simooni Peetero bu amoni buu, atsukini nha kulu a Yiisu, aleeli: «Pfumu, matuu nha pele a me, mundaa ti me ni ngaa masumu!» ");
INSERT INTO iyx_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simooni na babali na nde bateeti mu boomo, mu ndaa iteesi kia batswi balaa kibabayi. ");
INSERT INTO iyx_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Bambaayi ba Simooni ka: Yaki na Yowani, baana ba Zebedaayi bateeti mu boomo. Ka Yiisu aleeli kwaa Simooni: «A ba na boomo pe, umata lolo li, we saba mulobi a baata.» ");
INSERT INTO iyx_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bu babeyi mabootu nha simi, bo basiisi bioosi, na baduki Yiisu. ");
INSERT INTO iyx_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yiisu bu ali ku ngaanda mosi, muutu mosi wali nyutu yoosi yaluulu mu bwaari bu amoni nde, ayitsukunu nha kulu a nde, busu mu tsini. Nde wamuloombi, aleeli: «Pfumu, so we tooni, we utuu ubeelise me.» ");
INSERT INTO iyx_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yiisu asibili koo, wamubeembi, na aleeli kwaa nde: «Me tooni, ki beeluu wa we.» Nhaa-na-tsi, bwaari uyaaba uwa. ");
INSERT INTO iyx_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yiisu wamutumi: «A yaabisa ndaa yi kwaa muutu pe, ka yene yamonuu kwaa ngaanga a Nziaambi, na ha bungori mu ubeeluu kwa we, mbii bwatumi Mooso. Sa iba imbaangi kwaa bo.» ");
INSERT INTO iyx_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ka mvuungu a Yiisu yavuli utsaamuu. Makoongi malaa makukini mu uyuu nde na ubeeluu mu bibeeri bia bo. ");
INSERT INTO iyx_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ka nde makulu akiyene mu mambuu mahele a baata mu ukuundu. ");
INSERT INTO iyx_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Iluumbu imosi Yiisu akiyiisi. Bafarisi na bayiisi ba mikele bali nhaa. Bo bamati mu mala moosi ma Ngalili, ma Yuuda na mu Yeruselemi. Lituu la Pfumu lali na Yiisu, na ni mu lo nde akibeelese babeeri. ");
INSERT INTO iyx_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mono babaala babeyi nha yulu a mbuu, muutu wabobo binama, bo basiayi mu ulooso nde mutso nzo, na ubee nde nha kulu a Yiisu. ");
INSERT INTO iyx_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Bu bahele uyaaba nha bulooso nde mu nzo mu ndaa a koongi, bahaati ku yulu a siaangi la nzo. Bo batuli wuru na basutili mubeeri nha ikala kia nde nha kati a baata, na bamusuusi nha kulu a Yiisu. ");
INSERT INTO iyx_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yiisu bu amoni imiini kia bo, aleeli kwaa mubeeri: «Mbaayi a me, masumu ma we basiiri kolokolo.» ");
INSERT INTO iyx_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ni mubuu, bayiisi ba mikele, na bafarisi na basonii ba bo babaandii utsimi na uleele ti: «Wuunawu ni na, uli mu utuu Nziaambi? Na utuu usa masumu kolokolo, mbii a ndila Nziaambi pe?» ");
INSERT INTO iyx_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yiisu ayaabi matsimi ma bo, wabaleeli: «Mu ima dili na matsimi ma pili yii? ");
INSERT INTO iyx_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ima kia avulu uleenge nha kati a uleele: “masumu ma we basiiri kolokolo” na “temene, yene wa we?” ");
INSERT INTO iyx_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Me natoono ti, beni diyaaba ti Mwaana a Muutu li na lituu la usa masumu kolokolo nha tsi.» Yiisu aleeli kwaa wa bobo binama: «Me ndeeli kwaa we: temene, holo ikala kia we, yene ku nzo a we.» ");
INSERT INTO iyx_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nhaa-na-tsi, wa bobo binama uyaaba utemene nha kulu a baata boosi, aholi ikala kia nde, ayeni ku nzo a nde, akiinzi Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Boosi bakimii, baluuli mu boomo, babili Nziaambi, baleeli: «Iluumbu ki dimoni mandaa ma kimikimi!» ");
INSERT INTO iyx_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nha mbisi a nhaa, Yiisu apali, amoni mutoli a limaanda, kuumbu a nde Levi, adiaala nha mbuu ya isala kia nde, Yiisu wamuleeli: «Duku me!» ");
INSERT INTO iyx_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi atemini, asiisi bioosi, na wamuduki. ");
INSERT INTO iyx_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Levi ayilii Yiisu ndaamba yinene mu nzo a nde. Batoli ba limaanda balaa na baata bakimi, badiaali na bo nha meese. ");
INSERT INTO iyx_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Bafarisi na bayiisi ba mikele ba bo, banhunhinyi na baleeli kwaa miyii mia Yiisu: «Mu ima beni dibaadia na dibaanywa na batoli ba limaanda na bangaa masumu?» ");
INSERT INTO iyx_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yiisu avutili, aleeli kwaa bo: «Baata bali polo a bali na nzala a mubuyi pe, ka ndila babeeri bali na nzala a nde. ");
INSERT INTO iyx_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Me a nayiri pe mu uta balibweeye mbili, ka bangaa masumu mu ndaa ukiingili bo mayele.» ");
INSERT INTO iyx_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bafarisi baleeli kwaa Yiisu: «Miyii mia Yowani na mia bisi mibaadii mutuutu, na mibaakuundu, ka mia we mibaadia na mibaanywa.» ");
INSERT INTO iyx_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yiisu avutili kwaa bo, aleeli: «Buni beni dituu utumu babayiri ku mukuungi a makweele mu udii mutuutu, mu taanga di mufuru a makweele akeni na bo? ");
INSERT INTO iyx_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ka mu taanga di bakaamaasa mufuru a makweele nha kati a bo, mu biluumbu bii, bo sa badii mutuutu.» ");
INSERT INTO iyx_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yiisu abwita bo tsaba yi: «Muutu a ubaakaka iteendi pe mu ilwaata ki inyatii, na ubaamba kio nha ilwaata ki ikulu. Leeti, nde sa abiiyisi ikutu ki inyatii, mundaa ti, iteendi ki inyatii a kiafwaana na ikutu ki ikulu pe. ");
INSERT INTO iyx_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Pili mosi, muutu a ubaalooso pe viinyi lilinyatii mu mambiindi ma makulu. Ka so nde loosi lo, viinyi lilinyatii sa libulu mambiindi, lo makulu sa litsaamuu na mambiindi sa mabuluu. ");
INSERT INTO iyx_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ka viinyi lilinyatii lafwaana mu mambiindi mamanyatii. ");
INSERT INTO iyx_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","A uli na muutu pe wuli mu ubwatoono viinyi lilinyatii, nha mbisi a unywa lilikulu. Mu ngwanya, nde sa aleele ti: viinyi lilikulu lavulu mu bubwe.» ");
INSERT INTO iyx_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Iluumbu imosi kia saba, Yiisu bu akisabuu matsiee ma bele, miyii mia nde miakabi bele, bakolili mbutu dia bele, banyonhinyi na badi. ");
INSERT INTO iyx_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Bafarisi ba bamosi baleeli kwaa bo: «Mu ima beni dili mu usa mandaa ma mikele mialii iluumbu kia saba?» ");
INSERT INTO iyx_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yiisu avutili kwaa bo: «Ka a dia taangi pe masi Daavidi, bu nde akwi nzala na babali na nde? ");
INSERT INTO iyx_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Nde akoti mu nzo a Nziaambi, aholi mapa ma baha bungori kwaa Nziaambi, adi mo ahi mo kwaa baata bali na nde. Bunu, ndila bangaanga ba Nziaambi bali na muswa mu udia mo.» ");
INSERT INTO iyx_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yiisu aleeli kwaa bo: «Mwaana a muutu li Pfumu a iluumbu kia saba.» ");
INSERT INTO iyx_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mu iluumbu ikimi kia saba, Yiisu akoti mu nzo a makutunu ma Bayuudayo mu uyiisi. Muu mwali na muutu, wali koo kia nde kia babaala kiabobo. ");
INSERT INTO iyx_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Bayiisi ba mikele na bafarisi bakikete nde bubwe mu umono mbii ti Yiisu utuu ubeelese muutu mu iluumbu kia saba, paa basololo toono yi bo bufuundu nde. ");
INSERT INTO iyx_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ka Yiisu ayaabi matsimi ma bo. Nde aleeli kwa muutu wali na koo kiabobo: «Temene, yiri nha, nha kati a baata boosi.» Muutu, atemini ayiiri nha kula bo. ");
INSERT INTO iyx_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Na Yiisu aleeli kwaa bo: «Me nifuulu kwaa beni: mu iluumbu kia saba, uli na muswa mu usa mandaa mamabwe so mamabi? Mu uvuusu muwuumu a muutu na so mu unyaala nde afuu?» ");
INSERT INTO iyx_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nde atali baata boosi, aleeli kwaa ngaa koo kiabobo: «Sibili koo kia we.» Nde asibili kio na koo kia nde kiabeelii. ");
INSERT INTO iyx_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Bayiisi ba mikele na Bafarisi baluuli mu kesi, babayi imoo nha kati a bo mu yibafwaana usa kwaa Yiisu. ");
INSERT INTO iyx_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mu biluumbu bii, Yiisu ayeni ku mulaanda mu ukuundu. Butsuu ba bubiimbili, nde ali kuu mu ukuundu Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Bu bakieeri, Yiisu ati miyii mia nde mbila, asiooli kuumi na boolo, wabaluyi kuumbu batumu. ");
INSERT INTO iyx_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simooni, wu nde aluyi kuumbu Peetero, Andere, mwaana a nguu a Peetero, Yaki, Yowani, Filipo, Baritelemi, ");
INSERT INTO iyx_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mataayi, Toma, Yaki, ni mwaana a Alife, Simooni wu bubaata Zelote. ");
INSERT INTO iyx_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Na Yuuda mwaana a Yaakobi na Yuuda Isikarioti, wu ukituu muyeelili. ");
INSERT INTO iyx_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Nde akulumini na bo, atemini nha mbuu ya ileese. Nhaa mwali na koongi yinene ya miyii mia nde, na koongi a baata balaa babamati mu tsi yoosi ya Yuuda, ku Yeruselemi. Babamosi ka bamati ku mangaanda ma Tiro na Sidoni, ni mangaanda mamali mu mukoo a mubu. ");
INSERT INTO iyx_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bo bayiri mu uyuu nde na mu ubeeluu mu bibeeri bia bo. Ba miheebili mimibi miakikwaamisa, babeelii ka. ");
INSERT INTO iyx_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Koongi yoosi yasiayi mu ubeembe nde, mu ndaa lituu lakipala mu nde na lakibeelisi boosi. ");
INSERT INTO iyx_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yiisu bu asiimbili misi kwaa miyii mia nde, wabaleeli: «Kinyi kwaa beni bali bawele, ka Ipfumu kia Nziaambi ili kia beni! ");
INSERT INTO iyx_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kinyi kwaa beni bali nzala mu taanga di, ka beni sa diyutuu! Kinyi kwaa beni bali mu ulili mu taanga di, ka beni sa disiebe!» ");
INSERT INTO iyx_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","«Kinyi kwaa beni, so baata bubele beni, so baata butunu beni, so baata butuu beni, so baata buleele mabi mu beni mu ndaa a Mwaana a Muutu. ");
INSERT INTO iyx_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Bu iluumbu kii ikaayira, diba na kinyi, diyaanga, ka mono, musieende a beni li wumunene ku yula, ka ni buu ka bwasi bataayi ba bo kwaa mibili.» ");
INSERT INTO iyx_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","«Ka ngebe kwaa beni bisini, beni dimaaholo mboondili a beni. ");
INSERT INTO iyx_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Aa ngebe kwaa beni badili diayutuu mu taanga di, ka beni sa dikwa nzala! Aa ngebe kwaa beni badili mu usiebe mu taanga di, ka beni sa diba mu bukwiili na matsanga! ");
INSERT INTO iyx_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ngebe kwaa beni, mutaanga di baata boosi buleele ma mabwe mu beni, ka ni buu ka bwayilii bataayi ba bo kwaa mibili mia pia!» ");
INSERT INTO iyx_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Ka kwaa beni ba dili mu uyuu me, me nadileeli: Ditoono mitaata mia beni, disa ma mabwe kwaa baata ba bali mu ubele beni. ");
INSERT INTO iyx_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Disieme babusibi beni, dikuundu mu ba butsoro beni. ");
INSERT INTO iyx_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","So muutu teti we mu tama limosi, wamumweese ka lilimosi. So muutu holi iyungu kia we, nyaala nde aholo ka ikutu kia we. ");
INSERT INTO iyx_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Pasi wu uloombo we, wamuha; wu holi bia we, a bwaloombo bio pe. ");
INSERT INTO iyx_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Pasi bu ditooni ti baata badisa, ni buu beni disa kwaa bo. ");
INSERT INTO iyx_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","So ditooni ndila babatoono beni, mu ima buvutulu beni matoondo? Bangaa masumu ka utoono ba batoono bo. ");
INSERT INTO iyx_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","So dili mu usa mandaa mamabwe kwaa ba bali mu usa beni ma mabwe, mu ima buvutulu beni matoondo? Bangaa masumu bali mu usa ka pili mosi! ");
INSERT INTO iyx_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","So dili mu usoombuso kwaa ba badiasa ilimbisi ti sa bafutu, mu ima buvutulu beni matoondo? Bangaa masumu ka bali mu usoombusono mu ndaa ubaa futu! ");
INSERT INTO iyx_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ka ditoono mitaata mia beni, disa mandaa mamabwe, disoomboso kwahele a ukebe ndaanda. Musieende a beni sa aba wu munene, na beni sa diba baana ba Nziaambi wa ku kati a yula, mundaa ti, nde li wumubwe kwaa ba buhele uvutulu nde matoondo na kwaa bababi. ");
INSERT INTO iyx_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Diba bangaa ngebe weti taayi a beni ni ngaa ngebe.» ");
INSERT INTO iyx_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«A difuundusu pe, na mbari Nziaambi ka a ufuundusu beni pe. A dibwiisi pe, na mbari Nziaambi ka a ubwiisi pe beni. Disa bambaayi kolokolo, na Nziaambi ka sa wadisa kolokolo. ");
INSERT INTO iyx_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Dikaba kwaa bambaayi na Nziaambi ka sa wadikaba. Sa baluusu mu pfwoolo a ikutu kia we iteesi ki ibwe ki bakomo, ki banyingisi, na kiapfwaabula. Ka iteesi ki beni dileesele bambaayi, sa Nziaambi sa aleesele beni ka mu kio.» ");
INSERT INTO iyx_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nde abwi ta bo tsaba: «ka ingimangimi utuu ubiti mbaayi ingimangimi? Ka bo baboolo a bubwa mutso dunu pe? ");
INSERT INTO iyx_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Muyii a avulu pe muyiisi a nde, ka pasi muyii wu ubaayii bubwe sa aba weti muyiisi a nde. ");
INSERT INTO iyx_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ka mu ima li mu umono itiiti kili mu lisi la mwaana a nguu a we, ka muti uli mu lisi la weme amoni nde pe? ");
INSERT INTO iyx_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Buni utuu uleele kwaa mbaayi a we: Mbaayi, nyaala me maasa itiiti kili mu lisi la we, we makulu a amono muti uli mu lisi la we pe? We ngaa lisi kutso likaya, kwa maasa muti uli mu lisi la we makulu, tumake sa mono buni we utuu maasa itiiti kili mu lisi la mbaayi a we.» ");
INSERT INTO iyx_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«A uli na muti wu mubwe wu ubaabutu mbutu dimbi pe, a uli ka na muti wu mubi wu ubaabutu mbutu dimbwe pe. ");
INSERT INTO iyx_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ka pasi muti ayaabina mu mbutu dia nde. A bubaakaba mbutu dia bafiike mu muti wa matsieende pe, a bubaakaba mbutu dia viinyi mu mingaamba pe. ");
INSERT INTO iyx_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Muutu wumubwe li mu upalisa mamabwe mu busini ba mutima a nde wumubwe. Muutu wumubi li mu upalisa mamabi mu mutima a nde wumubi. Mu ngwanya, munywa a muutu upalisa mamaluulu mu mutima nde.» ");
INSERT INTO iyx_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Mu ima dibaata me “Pfumu, Pfumu”, ka a dibaayiluu pe ma nibaa leele beni? ");
INSERT INTO iyx_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Pasi wu uyira kwaa me na uyuu mandaa ma me na uyiluu mbii bu mali, me sa mweese beni wu nde afwaanina: ");
INSERT INTO iyx_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nde afwaanina na muutu watuungu nzo. Akwi haa, asundisi na asuusi ibwa nha yulu a manya. Nyaamba ya mifuri yayiri, yabwiilili nzo yii, yo a yabwiiri pe, mu ndaa ti yo batuungu bubwe. ");
INSERT INTO iyx_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ka wuli mu uyuu mandaa ma me, na ali mu usalila mo pe, afwaanina na muutu watuungu nzo nha yulu a tsieengi, kwahele a ibwa. Nyaamba yabwiilili yo: mawasa-mawasa yo uyaaba ubwa, na mbwiilili a nzo yii yali yinene!» ");
INSERT INTO iyx_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yiisu bu amani uleele mandaa ma nde moosi kwaa baata, akoti mu Kapernawumi. ");
INSERT INTO iyx_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Booyi la mukuutu a kama a masodaare wu nde atooni kwalaa ali na ubeele, nha peembi a likwa. ");
INSERT INTO iyx_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Bu ayuyi mvuungu a Yiisu, atsindii bakuutu ba Bayuudayo bamosi kwaa nde mu ya loombo kwaa nde ayiri a beelese mutee a nde. ");
INSERT INTO iyx_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bu batoori kwaa Yiisu, bahanini mu upele nde, baleeli: «muutu wu afwaana ti we ha nde libaasila. ");
INSERT INTO iyx_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ka nde atoono ifuumbu kia bisi, nde makulu wadituungili nzo a makutunu.» ");
INSERT INTO iyx_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yiisu ayeni na bo. Ka bu atoori bebele na nzo, mukuutu a kama a masodaare atsindii banduu, ba muleele: «Pfumu, a mono wa we pasi pe, ka a nafwaana pe ti we koto ku tsini a siaangi la me. ");
INSERT INTO iyx_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ni mu buu, me natsimi ti a nafwaana uyira kwaa we pe, ka leele ndaa ndila mosi, na booyi la me libeeluu. ");
INSERT INTO iyx_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Me makulu ndi ku tsini a litumu la bakuutu bame, na ndi na masadara ma ndi mu utumu. So ndeeli kwaa mosi: yene! Nde yeni; kwaa wu mumosi: yiri, nde yiri; kwaa booyi la me: Yiluu ki, nde yilii kio.» ");
INSERT INTO iyx_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yiisu bu ayuyi maa, akimii mu nde, asieetii, aleeli kwaa baata bakiduku nde: «Me nadileeli: So mu Iseraeli a nasololo imiini ki inene kia pili yi pe.» ");
INSERT INTO iyx_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Babatsindii, bu bavutii ku nzo, babaasi mutee abeeluu. ");
INSERT INTO iyx_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nha mbisi nhaa, Yiisu ayeni ku ngaanda ya kuumbu Nayini, miyii mia nde na koongi a baata yalaa bayeni na nde. ");
INSERT INTO iyx_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Bu asweesi nha kotili a ngaanda, mono bakibiti wakwa, mwaana wa baala ndila mosi wa nguu a nde wali mukwiili, na koongi yalaa ya mu ngaanda yii yali na nde. ");
INSERT INTO iyx_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Pfumu wamumoni, wamukwiilili ngebe, aleeli kwaa nde: «a lili pe!» ");
INSERT INTO iyx_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yiisu asweesi, abeembi mububulu, bababiti batsikini. Yiisu aleeli: «Mufuru, me ndeeli we, temene!» ");
INSERT INTO iyx_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Na wakwa asiimbii, abaandii utsuu. Yiisu wamuvutili kwaa nguu a nde. ");
INSERT INTO iyx_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Boomo babwiilili boosi, bakiinzi Nziaambi, baleeli: «Mubili wu munene maa pala nha kati a bisi, Nziaambi maa yiri mu uyobolo baata ba nde.» ");
INSERT INTO iyx_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mvuungu a ndaa yayilii Yiisu yatsiaamii mu tsi yoosi ya Yuuda na mu mala madiengelele yo. ");
INSERT INTO iyx_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Miyii mia Yowani mia muleeli mandaa maa moosi. Yowani ati miyi mia nde mioolo mbila. ");
INSERT INTO iyx_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Atsindii mio kwaa Pfumu mu ufuulu nde: «We ni wafwaana uyira, ooti diafwaana ukebe muutu mukimi?» ");
INSERT INTO iyx_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Miyii bu miatoori kwaa Yiisu bamuleeli: «Yowani Mubootii waditsinduu difuulu we: we ni wafwaana uyira, so a buu pe bisi diafwaana ukebe mukimi?» ");
INSERT INTO iyx_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mu taanga dii, Yiisu abeelisi baata balaa bangaa bibeeri, ba ngaa bifuumbu, baata bangaa miheebili mimibi, na abeelisi balayi babakwa misi. ");
INSERT INTO iyx_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nha mbisi nde avutili kwaa miyii mia Yowani: «Yenani dileele Yowani ma dimoni na ma diyuyi: Bakwa miisi bali mu umono, bitonzo bili mu udieenge, bangaa bwaari bali mu ubeeluu, bakwa matswi bali mu uyuu, ba bakwa bali mu usiimbuu, ndaa yimbwe bayaabisi kwaa bawele. ");
INSERT INTO iyx_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kinyi kwaa pasi wuu heele ubwiisi imiini kia nde mu me.» ");
INSERT INTO iyx_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ka batumu ba Yowani bu bavutii, Yiisu abaandii utsuu mu Yowani kwaa makoongi, aleeli: «Ima beni diyimono ku tsi ya tsata? Liheese lili mu unyingini mu mupepe? ");
INSERT INTO iyx_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ka ima beni diyimono? Muutu walwaata bikutu bia tala? Ka babali mu ulwaata milwaata mia buzitu na bali mu uba mutso busini bali mu udiaala mu manzo ma mitini. ");
INSERT INTO iyx_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ka ima beni diayamono? Mubili a Nziaambi? Ee-e, me nadileeli, nde avulu na paa mubili. ");
INSERT INTO iyx_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ni mu nde Yowani basonuu: “Mono, me sa tsinduu tumu a me nha kulu we, mu uyiluu we kuulu nha kulu a we.” ");
INSERT INTO iyx_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","«Me nadileeli: Nha kati a babaala boosi babutuu mu mukaasa, a uli na wavulu Yowani mu bunene pe, ka bunu wavulu bukee mu Ipfumu kia Nziaambi avulu nde mu bunene. ");
INSERT INTO iyx_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Baata boosi na batoli ba limaanda bayuyi nde. Baleeli: “Nziaambi tooni bisi uyobolo!” Na baholi libootuu la Yowani. ");
INSERT INTO iyx_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ka bafarisi na bayiisi ba mikele ba bisi ma Nziaambi atooni uyiluu mu bo, na bo babisi libootuu la Yowani.» ");
INSERT INTO iyx_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yiisu abwileele: «Na me nifwaanisa baata ba kubu yi? Na na bafwaanina? ");
INSERT INTO iyx_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bafwaanina na baana ba badiaala nha kooyi, bali mu ulohosono mu uleele: Difuli beni piipi, ka beni a dikini pe, diyimbili beni mikuunga mia likwa, ka beni a dilili pe. ");
INSERT INTO iyx_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ka Yowani Mubootii ayiri, nde ali mu udia mapa pe, ali mu unywa viinyi pe, ka beni dileeli: “Muheebili wu mubi li mu nde.” ");
INSERT INTO iyx_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mwaana a Muutu ayiri, nde li mu udia na li mu unywa, na beni dileeli: “Mono, muutu wu, matsimi ma nde moosi ndila ma udia na unywa mala! Nde li nduu a ba ngaa masumu na batoli ba limaanda.” ");
INSERT INTO iyx_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ka buyeri ba Nziaambi bumonii balibweeye kwaa baana ba nde boosi.» ");
INSERT INTO iyx_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mufarisi mosi aloombi Yiisu adia na nde. Yiisu akoti mu nzo a mufarisi, adiaali nha meese. ");
INSERT INTO iyx_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mwali mu ngaanda yii na mukaasa mosi ngaa masumu. Bu ayaabi ti Yiisu ali nha meese mu nzo a mufarisi, nde abeyi ibasa kia luulu mu mananaasa, ");
INSERT INTO iyx_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ayeni nha peembi a miili mia Yiisu nde. Alili, abolisi miili mia Yiisu mu matsanga, akoombili mio mu naanga dia nde, anyumbiti miili mia Yiisu, ayitili mananaasa nha yula mio. ");
INSERT INTO iyx_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mufarisi wa tumisi Yiisu bu amoni buu aleeli mu mutimi a nde: «mbiiti muutu wu ali mubili, nde keni yaaba ti mukaasa uli mu beembe nde li ngaa masumu.» ");
INSERT INTO iyx_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yiisu, aleeli kwaa mufarisi: «Simooni, ndi na ndaa ya uleele kwaa we.» Simooni avutili: «Muyiisi kileele.» ");
INSERT INTO iyx_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","«Baata boolo bali na yaama la musoombisi a mboongo, watsiomi, makama mataana ma mboongo, ka wu mumosi maku mataana. ");
INSERT INTO iyx_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ka bu baheli na bia ufutu, wabanyaali bo baboolo. Na mu bo kaavulu nde utoono?» ");
INSERT INTO iyx_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simooni avutili: «Me tsimi ti nde wubanyaalili yaama lavulu bunene.» Yiisu aleeli kwaa nde: «We kesi bubwe.» ");
INSERT INTO iyx_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Bu asieetii kwaa mukaasa, aleeli kwaa Simooni: «We li mu umono mukaasa wu? Me koti mu nzo a we, ka we ahi me maamba ma uswaa miili pe. Ka nde swayi miili mia me mu matsanga ma nde, koombili mio mu naanga dia nde. ");
INSERT INTO iyx_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","We a nyumbutu me pe, ka nde umata kotili a me a akoono pe miili mia me unyumbutu. ");
INSERT INTO iyx_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","We ayitili maari nha yula mutswe a me pe, ka nde yitili mananaasa mu miili mia me. ");
INSERT INTO iyx_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ni mu buu nadileele: nde amweesi litoono lalaa bu masumu ma nde malaa banyaali. Ka wu banyaala mama kee, amweesi ka litoono li likee. ");
INSERT INTO iyx_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yiisu aleeli kwaa mukaasa wuu: Masumu ma we basiiri kolokolo.» ");
INSERT INTO iyx_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ba bali badiaala na nde nha meese babaandii uleelesene: «Wuunawu ni na wu tuu usa masumu kolokolo?» ");
INSERT INTO iyx_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ka nde aleeli kwaa mukaasa: «Imiini kia we ivuuyisi we: yene mu iyeenge.» ");
INSERT INTO iyx_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nha mbisi, Yiisu ayeni midieenge mu pasi ngaanda na mu pasi bula mu uyiisi na uyaabisa ndaa yimbwe ya Ipfumu kia Nziaambi. Miyii kuumi na mioolo miali na nde ");
INSERT INTO iyx_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","na Bakaasa bakimi ba babeelisi mu miheebili mimibi na mu bibeeri: ni Mari wu bubaata musi Mangadala, wu bapalisi miheebili tsaamba mimibi, ");
INSERT INTO iyx_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Zaana mukari a mukebi a busini ba Erode wa kuumbu Kuza, na Suzaana na bakimi balaa bababaasili Yiisu na miyii mia nde mu mbayili a bo. ");
INSERT INTO iyx_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Koongi yalaa yakukini, mu pasi ngaanda baata bayiri kwaa Yiisu, nde ati bo tsaba yi: ");
INSERT INTO iyx_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Mukuni mosi ayeni ku tsiee a nde mu ukunu mbutu, ka bu ali mu ukunu, ndaamba a mbutu yaki yena bwa mukuulu a kuulu, baata badiaati, na banyunyi bayula badi dio. ");
INSERT INTO iyx_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Dimosi diabwi nha yula a manya, bu diamani ukulu, dia kanyi mu ndaa ti a kwali nyototo pe. ");
INSERT INTO iyx_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Dimosi diabwi nha tso mingaamba. Diameni na mingaamba mbuu mosi, mingaamba mianyongisi dio. ");
INSERT INTO iyx_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Dimosi diabwi mu tsieengi dimbwe, diakuli, diabuti mbutu kama-kama.» Bu amani maa uleele, aloyi: «wuli na matswi ma uyuu, nyaala ayuu.» ");
INSERT INTO iyx_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Miyii mia Nde mia mufuuli Mambiindili ma tsaba yii. ");
INSERT INTO iyx_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nde avutili: «Beni badihi mu uyaaba matsweeyi ma Ipfumu kia Nziaambi; ka kwaa ba bamosi mu matsaba bali mu uyuu mo, paa so bali na misi bwaasi a bumono iloo pe, na so bayuyi a buyaaba pe.» ");
INSERT INTO iyx_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Mono mbiindila tsaba ni yi: Mbutu ni mandaa ma Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Dia mu kuulu a kuulu, ni baata bali mu uyuu mandaa ma Nziaambi. Ka Saatina li mu uyira mu umaasa ndaa mu mitimi mia bo, mu ndaa ti a basa imiini na ubaa liyobolo. ");
INSERT INTO iyx_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Dia nha yulu a manya ni babali mu uyaka mandaa mu kinyi, ka mo a mali na miaanzi mu bo pe. Bo bali mu usa imiini taanga ndila hoolo, ka mu taanga dia nziesini bo bali mu ubwiisi imiini. ");
INSERT INTO iyx_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Diabwi nha tso mingaamba ni baata babali mu uyuu mandaa. Ka minyoongo, busini na makinyi ma tsi, mali mu unyongoso imiini kia bo. Bo a bali mu utuu ubutu mbutu diayele pe. ");
INSERT INTO iyx_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Diabwi mu tsieengi dimbwe, ni baata bali mu uyuu mandaa mu mutima wafwaana na wumubwe. Bo bubaakebe mo na bubaabutu mbutu, kutso mukonono.» ");
INSERT INTO iyx_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«A uli na muutu wu unamisa mwiindi, mu ufuu nde ku tsini a mbasa pe, so mu ulooso nde ku tsini a mbuu pe. Ka bunu, bali mu usuusu nde nha mbuu yanaanguuu; paa boosi ba bukoto bamono liyalila. ");
INSERT INTO iyx_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ka a uli na iloo pe kibaswee, kikaahele umonuu, a uli na iloo pe kia tsweeyi kikaahele uyabina na umonuu nha kati a liyalila. ");
INSERT INTO iyx_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ni mu buu, disa mayele mu nzuyili a beni. Mu ndaa ti, sa baha kwaa wa baa, ka kwaa wa heele ubaa sa bamupatila so ki nde atsimi ti mbayili a nde.» ");
INSERT INTO iyx_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nguu a Yiisu na baana banguu ba nde bayiri kwaa Nde; ka bakooni uswese kwaa nde mu ndaa a koongi yi inene. ");
INSERT INTO iyx_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Baata baleeli kwaa nde: «Nguu a we na baana ba nguu ba we bali ku mbari, batooni umono we.» ");
INSERT INTO iyx_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ka Yiisu avutili kwaa bo: «Nguu a me na baana ba nguu ba me, ni babubaayuu mandaa ma Nziaambi na usalila mo.» ");
INSERT INTO iyx_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Iluumbu imosi, Yiisu akoti mutso bootu na miyii mia nde. Aleeli kwaa bo: «disabuwani ku simi la diaanga lili mosi.» Na bayeni. ");
INSERT INTO iyx_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Mu taanga di baki sabuu, Yiisu alaari tolo. Iteembi kia mifuri kia abwi nha yula diaanga, bootu laluuli mu maamba, na bali bele na ufuu. ");
INSERT INTO iyx_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Miyii mia Yiisu miaswesi kwaa nde, bamusiimbili na baloyi: «Muyiisi, Muyiisi, bisi dikwiiri.» Ka nde asiimbii, asieembi iteembi na mapo ma maamba biawuri, na bioosi biali na pii. ");
INSERT INTO iyx_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yiisu aleeli kwaa miyii: «Imiini kia beni kuni yili?» Baluuli mu boomo na bakimii, baleelisini: «Ka wuunawu ni na, uli mutuumu kwaa iteembi na maamba? Na bio bili mu utumumu nde.» ");
INSERT INTO iyx_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Basiabii ku tsi a basi Ngerasa, yasuungunu na Ngalili. ");
INSERT INTO iyx_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yiisu bu asutii nha simi, baala limosi lali na miheebili mimibi mu ngaanda yii, lamubwaani. Umata bele pee, lo lali bikutu ulwaata pe, mu nzo udiaala pe ka nde udiaala ku mangili. ");
INSERT INTO iyx_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Bu amoni Yiisu, aloyi, atsukini nha miili mia nde, na aleeli: «Yiisu, Mwaana a Nziaambi wa ku kati a yula? We ki ndaa li na yo na me? Kolokolo a we, a sieembe me pe!» ");
INSERT INTO iyx_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ka Yiisu atumi muheebili wumubi apala mu muutu wuu. Mundaa ti muheebili wuu akikwaamisa nde taanga dioosi. Bakikutu muutu wuu mio na miili mu mikuru mia bitali. Ka nde akitabulanga mio, na muheebili wu mubi aki biti nde mu matsi ma tsata. ");
INSERT INTO iyx_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yiisu wamufuuli: «Kuumbu a we na?» Nde avutili: «Koongi»; mu ndaa ti miheebili mimibi mialaa miali miakoto mu nde. ");
INSERT INTO iyx_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Miheebili mii mia peli Yiisu anyaala utumu mio miyene ku mbeenge. ");
INSERT INTO iyx_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ka nhaa, wali na mukaanga a bangulu wu munene baki dia ku yula a mulaanda. Miheebili mimibi mialoombi kwaa Yiisu aha mio muswa mu ukoto mu bangulu. Yiisu ahi mio muswa. ");
INSERT INTO iyx_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Miheebili mimibi miapali mu muutu, miakoti mu bangulu, mukaanga akilimini mu mbeenge a diaanga mu adiaami. ");
INSERT INTO iyx_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bakebi ba biboori bii bu bamoni ma mayilimi, babati, babiti mamvuungu mu mangaanda na mu mala. ");
INSERT INTO iyx_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Baata bapali mu umono mioosi mialabii, bayiri kwaa Yiisu, bamoni muutu wapali miheebili mimibi adiaala nha pele a Yiisu, alwaata bikutu na ali na imuutu kia nde kioosi. Baata babayi boomo. ");
INSERT INTO iyx_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Babamoni miayilimi baleeli kwaa bamosi buni muutu ngaa miheebili mimibi akuulii. ");
INSERT INTO iyx_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Basi Ngerasa boosi baloombi Yiisu ayene, asiisi bo bu bali na boomo balaa. Yiisu akoti mu bootu, avutii. ");
INSERT INTO iyx_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Baala lapala miheebili mimibi aloombi kwaa Yiisu anyaala nde aba na nde, ka Yiisu avutili nde, aleeli: ");
INSERT INTO iyx_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Vutuu ku nzo a we, leele moosi ma Nziaambi ayilii mu we.» Nde ayeni na ayaabisi mu ngaanda yoosi, moosi mamuyilii Yiisu. ");
INSERT INTO iyx_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Bu Yiisu avutii, koongi a baata yamuyaki mbii bu boosi bakikebe nde. ");
INSERT INTO iyx_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mono baala, la kuumbu Yayiro, ni mukuutu a nzo a makutunu ma Bayuudayo, ayiri ubwa nha miili mia Yiisu, wamupeli akoto mu nzo a nde. ");
INSERT INTO iyx_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Mu ndaa ti nde ali na mwaana wa mukaasa ndila mosi wa bilimi kuumi na bioolo wali nha peembi a likwa. Bu Yiisu akiyene ku nzo a Yayiro, makoongi mamupinyi kwalaa. ");
INSERT INTO iyx_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mwali nhaa na mukaasa ngaa ibeeri kia upala makila umata bilimi kuumi na bioolo, na nde amani mbayili a nde yoosi ya paamba kwaa babuyi. Ka so mosi a atuuyi nde ubeelese pe. ");
INSERT INTO iyx_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mukaasa me ayiri ku mbisi a Yiisu, abeembi ndeengi a mulwaata a nde. Nhaa-na-tsi, ibeeri kia nde kia palili a makila uyaaba uwa. ");
INSERT INTO iyx_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yiisu afuuli: «Na beembi me?» Boosi bu batuni, Peetero aleeli: «Muyiisi, makoongi ma madiengelele we mali mu upinyi we kwalaa.» ");
INSERT INTO iyx_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ka Yiisu aleeli: «Muutu beembi me, ka nziaabi ti mifuri mipali mu me.» ");
INSERT INTO iyx_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mukaasa bu amoni ti bamusolili, ayiri atehete, atsukini nha kulu a Yiisu ni aleeli nha kulu a baata boosi toono yi nde abeembi Yiisu na mbii bu abeelii nhaa-na-tsi. ");
INSERT INTO iyx_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yiisu aleeli kwaa nde: «Mwaana a me, imiini kia we ivuuyisi we. Yene mu iyeenge.» ");
INSERT INTO iyx_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Bu Yiisu ali kene mu utsuu, muutu amati ku nzo a mukuutu a nzo a makutunu a Bayuudayo na aleeli kwaa nde wuu: «Mwaana a we wa mukaasa maakwa, a bwakwaamisa Muyiisi pe.» ");
INSERT INTO iyx_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ka Yiisu bu ayuyi maa, aleeli kwaa Yayiro: «A ba na boomo pe. Sa ndila imiini, nde sa avuu.» ");
INSERT INTO iyx_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Bu Yiisu atoori ku nzo a Yayiro, a anyaali muutu akoto na nde pe nha mbisi a ndila Peetero, Yowani, Yaki na taayi na nguu a mwaana. ");
INSERT INTO iyx_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Boosi bamulili, bakombiti matulu. Ka Yiisu aleeli: «A dilili pe, nde a akwa pe ka ala tolo.» ");
INSERT INTO iyx_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Baata basiebi Yiisu bu bayaabi ti mwaana amaakwa. ");
INSERT INTO iyx_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ka Yiisu akaangi koo kia mwaana, aloyi, aleeli: «Mwaana a ngebe, temene!» ");
INSERT INTO iyx_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Muwuumu a mwaana avutii, nhaa-na-tsi nde uyaaba utemene. Yiisu aloombi bamuha bia udia. ");
INSERT INTO iyx_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Babuti ba mwaana bakimii kwalaa, ka Yiisu wabalii a bayaleele ma mayilimi kwaa muutu so mosi pe. ");
INSERT INTO iyx_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yiisu akukii miyii kuumi na mioolo na ahi bo mifuri na lituu la ubingisi miheebili mioosi mimibi na la ubeelese bibeeri. ");
INSERT INTO iyx_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Wabatsindii mu uyaabisa Ipfumu kia Nziaambi na ubeleese babeeri. ");
INSERT INTO iyx_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Aleeli kwaa bo: «A dibiti iloo pe mu midieenge, so mupaanga pe, so kutu pe, so kia udia pe, so mboongo pe, so diba na bikutu bioolo pe. ");
INSERT INTO iyx_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Pasi nzo yidikoto, diba muu natee bu dimatuu. ");
INSERT INTO iyx_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Pasi ba buhele uholo beni, dipala mu ngaanda yii, na dikubulu lifuundu la miili mia beni mu imbaangi kia bubi ba bo.» ");
INSERT INTO iyx_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Miyii miayeni, bayoyi mu pasi bula, bayaabisi ndaa yimbwe, babeelese babeeri mu mambuu moosi. ");
INSERT INTO iyx_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Erode mutini a Ngalili, ayuyi moosi makilabuu. A ayaabi pe ima afwaana utsimi mu ndaa ti ba bamosi baleeli, Yowani maasiimbuu mu babakwa, ");
INSERT INTO iyx_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ka babakimi ti Eliya maamonuu, ba bakimi ka ti mosi mu mibili mimikulu maasiimbuu mu babakwa. ");
INSERT INTO iyx_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Erode aleeli: «Yowani, me natumu bakese mutswe a nde, ka muutu wuu ni na ndi mu uyuu mandaa ma pili yi?» Na nde asiayi mu umono nde. ");
INSERT INTO iyx_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Batumu bavutii, bamuleeli moosi ma bayilii. Nde atakii na bo, ayeni nha bele a ngaanda yi bubaata Betesayida. ");
INSERT INTO iyx_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Baata bu bayaabi buu, bamuduki. Yiisu wabayaki na ayaabisi bo mu ndaa Ipfumu kia Nziaambi. Nde abeelisi ka ba bali na nzala ubeeluu. ");
INSERT INTO iyx_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Busi babaandii uyili, bakuumi na boolo baswesii, baleeli kwaa Yiisu: «Tsinduu koongi baata bayene mu misieenge na mala mamadiengelele mu usaa ilaari na bia udia, mu ndaa ti muunamu mu tsi ya tsata dili.» ");
INSERT INTO iyx_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yiisu aleeli kwaa bo: «Diabaha bia udia beni bame.» Bo bavutuli: «A dibayi bikimi pe, ka ndila mapa mataana na batswi boolo. We atoono ti diyene usuumbulu baata ba boosi bia udia?» ");
INSERT INTO iyx_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Bo bali helape so maku mataana ma makama ma babaala (5 000). Ka Yiisu aleeli kwaa miyii mia nde: «Diabadiaasa mu makaba makaba maku mataana mataana (50).» ");
INSERT INTO iyx_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Bayilii buu, batumi boosi badiaala. ");
INSERT INTO iyx_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nde aholi mapa mataana na batswi boolo, atali ku yula, na asiemi bio. Nde abukili bio na ahi kwaa miyii paa bakaba kwaa koongi. ");
INSERT INTO iyx_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Baata boosi badi, bayutii. Babiti mapwooyi kuumi na moolo maluulu mu bitsuru biasiaali. ");
INSERT INTO iyx_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Iluumbu imosi Yiisu akikuundu na miyii mia nde nha mbuu yatakuu, nde wabafuuli: «Makoongi maleeli ti me ni na?» ");
INSERT INTO iyx_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bo bavutuli: «Bana ti we Yowani Mubootii, ba bamosi ti Eliya. Babamosi ka ti we ni mosi mu mibili mimikulu maasiimbuu mu babakwa.» ");
INSERT INTO iyx_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nde afuuli kwaa bo: «aka beni ima dileeli, me na ndi?» Peetero avutili: «We ni Kristo wa Nziaambi!» ");
INSERT INTO iyx_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yiisu atumi bo, banyaala uleele ndaa yii kwaa muutu so mosi. ");
INSERT INTO iyx_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nde abwileele: «Mwaana a muutu afwaana umono pasi dialaa. Bakuutu ba baata, na banguu ba bangaanga ba Nziaambi na bayiisi ba mikele sa batunu nde na sa bamudusu. Mu iluumbu kia bitata sa asiimbuu mu babakwa.» ");
INSERT INTO iyx_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nde aleeli kwaa boosi: «So muutu tooni uduku me, anyaala utsimi mu ndila ndeme, aholo kuruwa a nde pasi iluumbu, aduku me. ");
INSERT INTO iyx_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ni mu buu watoono uyobolo muwuumu a nde, sa adiimbisi nde, ka wu udiimbisi muwuumu a nde mu ndaa me sa ayobolo nde. ");
INSERT INTO iyx_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ki ndaanda muutu ubaa so nde bayi tsi yoosi, ka diimbisi muwuumu a nde na yeni ku fuuyili? ");
INSERT INTO iyx_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ka pasi wu ukwa tsionyi mu me na mu mandaa ma me, Mwaana a muutu bu akaayira mu buzitu ba nde na ba Taayi na ba batumu ba ngira, sa akwa tsionyi mu nde. ");
INSERT INTO iyx_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ngwanya me nadileeli: Babamosi ba bali nha a bukwa pe natee bumono ipfumu kia Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Biluumbu hele pwoombo nha mbisi a nhaa bu amani mandaa maa uleele, Yiisu aholi Peetero, Yowani na Yaki, ahaati na bo nha yulu a mulaanda mu ukuundu. ");
INSERT INTO iyx_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Bu akikuundu, kiinzi kia nde yakitii, mulwaata a nde ahembii, angeyini. ");
INSERT INTO iyx_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Itsundu-a-tsundu bamoni babaala boolo bakimoo na nde. Ni Mooso na Eliya ");
INSERT INTO iyx_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","bamonii mu buzitu ba Nziaambi, bakitsuu na Yiisu mu ndaa a nziendila nde yikaayilimi mu Yeruselemi. ");
INSERT INTO iyx_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peetero na ba bali na nde balaari tolo la mifuri, ka bu basiimbii bamoni buzitu ba Yiisu na babaala boolo ba bali na nde. ");
INSERT INTO iyx_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mu taanga di Mooso na Eliya bakikabuu na Yiisu. Peetero aleeli kwaa nde: «Muyiisi, bubwe kwaa bisi mu uba nha. Dituungu bituru bitata, imosi kia we, imosi kia Mooso, imoso kia Eliya.» Peetero a ayaabi ma aleeli pe. ");
INSERT INTO iyx_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Peetero bu akileele maa, ibala kiayiri, kiabafuyi. Miyii miabayi boomo bu bo bakoti kutso ibala. ");
INSERT INTO iyx_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Mu ibala mwamati muniingi waleeli: «Wuunawu ni mwaana a me wu me nasoolo, diyuu nde!» ");
INSERT INTO iyx_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Bu muniingi ayuyini, bamoni Yiisu ndila nde bake. Bawuri; mu biluumbu bii a baleeli kwaa muutu pe ma bo bamoni. ");
INSERT INTO iyx_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mu iluumbu kiaduki, bu bakulumini ku tsuu a mulaanda, koongi yalaa yayiri mu ubwaana Yiisu. ");
INSERT INTO iyx_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kutso makoongi muutu aloyi, aleeli: «Muyiisi, kolokolo a we: mono mwaana a me wa baala, ni mwaana a me ndila mosi. ");
INSERT INTO iyx_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Muheebili wumubi li mu ubaakaanga nde, nhaa-na-tsi nde mu uloo, nde li mu utuutuu mu mifuri na mafuri mubaapala nde mu munywa. Muheebili wuu ubaanyoongoso nde kwalaa na a ali mu unyaala nde pe. ");
INSERT INTO iyx_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Me ndoombiangi kwaa miyii mia we babingi muheebili wuu, ka bakoono.» ");
INSERT INTO iyx_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yiisu aleeli: «Aa kubu yimbi, yahele na imiini! Taanga kwe me kaabwaba na beni na usuku beni? Bee mwaana a we nha.» ");
INSERT INTO iyx_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Bu mwaana aki yiri asweese, muheebili wu mubi abwiisi nde nha tsi, na atutisi nde kwa mifuri. Ka Yiisu afeengi muheebili wumubi, abeelisi mwaana a ngebe, na avutili nde kwaa taayi a nde. ");
INSERT INTO iyx_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Boosi bakimii mu bunene ba Nziaambi. Boosi bu bakimii mu maa moosi ma asi, aleeli kwaa miyii mia nde: ");
INSERT INTO iyx_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Diyuu bubwe mandaa ma me nileele kwaa beni: Mwaana a muutu sa bayeelele nha mioo mia baata.» ");
INSERT INTO iyx_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ka miyii a miayaabi ndeelili yii pe, yo yali ya tsweeyi kwaa bo paa bo banyaala uyaaba mbiindili. Ka bali na boomo mu ufuulu Yiisu mbiindila mandaa maa? ");
INSERT INTO iyx_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Miyii miabaandii ufuulusunu paa bayaaba na avulu mu bunene nha kati bo? ");
INSERT INTO iyx_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yiisu ayaabi matsimi ma mitimi mia bo, aholi imwamwaana, asuusi kio nha peembi a nde, ");
INSERT INTO iyx_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","na aleeli kwaa bo: «Pasi wu uyaka mwaana wu mu kuumbu a me, yaki me makulu, na pasi wu uyaka me yaki ka wa tsinduu me. Ni mu buu wavulu bukee nha kati a beni boosi ni nde wavulu mu bunene.» ");
INSERT INTO iyx_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yowani aleeli: «Muyiisi, bisi diamono muutu wapalisi miheebili mimibi mu kuumbu a we; bisi diakeelii nde, mu ndaa ti nde ali mu kaba la bisi pe.» ");
INSERT INTO iyx_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yiisu avutili kwaa nde: «A diamulii pe, ka pasi wu uhele uba na beni itaata nde ni wa beni.» ");
INSERT INTO iyx_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Bu biluumbu biali ka bele bi Yiisu afwaana uhaata ku yula, nde aholi kesili ya mifuri ya uyene ku Yeruselemi. ");
INSERT INTO iyx_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nde atsindii batumu ku kulu a nde. Bayeni, bakoti mu bula ba basi Samaria mu uyiluu mioosi miafwaana mu nzirili a nde. ");
INSERT INTO iyx_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ka basi bula babisi nde uyaka mundaa ti akiyene ku Yeruselemi. ");
INSERT INTO iyx_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Miyii Yaki na Yowani bu bamoni buu, baleeli: «Pfumu, we atoono ti bisi ditumu mbaa yi isotu ku yula mu unyeengisi bo?» ");
INSERT INTO iyx_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Nde asieetii kwaa bo, wabasieembi. ");
INSERT INTO iyx_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Na bayeni ku bula ba kimi. ");
INSERT INTO iyx_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Bu bali mu kuulu, muutu aleeli kwaa Yiisu: «Me niduku we pasi ku we uyene.» ");
INSERT INTO iyx_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yiisu aleeli kwaa nde: «Mibaa mili na matari, banyunyi ba yula bali na bilaari bia bo, ka Mwaana a muutu a abayi nha usuusu mutswe a nde pe.» ");
INSERT INTO iyx_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ka nde aleeli kwaa muutu mukimi: «Duku me.» Muutu wuu aleeli: «Pfumu, manyaala me yadii taayi a me.» ");
INSERT INTO iyx_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yiisu wamuvutili: «Nyaala babakwa badii babakwa ba bo. Ka we, yene ya yaabisa Ipfumu kia Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Muutu mukimi aleeli ka: «Pfumu, me niduku we, ka nyaala me kwa yaha mabweele kwaa basi nzo ba me.» ");
INSERT INTO iyx_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yiisu aleeli kwaa nde: «Pasi muutu wakaanga tsieengi mu usala na li mu ubwatala ku mbisi, a afwaana pe mu ipfumu kia Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nha mbisi a maa, Pfumu asiooli miyii mikimi maku tsaamba na mioolo, wabatsindii boolo-boolo ku kulu a nde mu mangaanda moosi na mambuu moosi ma nde makulu akee uto. ");
INSERT INTO iyx_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nde aleeli kwaa bo: «Tolili yili yalaa, ka basiali ba bakee, ni mu buu diloombo kwaa pfumu a tolili atsinduu basiali mu isala a nde. ");
INSERT INTO iyx_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Diyene, me naditsindii weti baana ba mameme nha kati a miminzi. ");
INSERT INTO iyx_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","A dibiti ipokolo kia mboongo pe, kutu pe, bikoori pe, na a dibii muutu mu kuulu pe. ");
INSERT INTO iyx_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Mu pasi nzo yi beni dikaakoto, dikwaleele: “Nyaala iyeenge iba mu nzo yi!” ");
INSERT INTO iyx_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","So muu muli na muutu wa iyeenge, iyeenge kia beni sa iba nha yulu a nde, so a buu pe, kio sa ivutuu kwaa beni. ");
INSERT INTO iyx_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Diba mu nzo yii, didia na dinywa bibuha beni, mu ndaa ti musiali afwaana ubaa futu a nde. A diyoo mu manzo-manzo pe. ");
INSERT INTO iyx_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Mu pasi ngaanda yi beni dikoto yi baata buyaka beni, didia bioosi bi badisuusulu. ");
INSERT INTO iyx_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Dibeelese babeeri bali muu, dileele kwaa baata boosi: “Ipfumu kia Nziaambi ika bebele na beni.” ");
INSERT INTO iyx_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ka mu pasi ngaanda yi dikoto so a bayaki beni pe, diyene mu makooyi, dileele kwaa boosi: ");
INSERT INTO iyx_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Bisi dili mu ukubulu so lifuundu la ngaanda a beni lanambiti mu miili mia bisi mu uvutulu beni lo, ka diyaaba ti Ipfumu kia Nziaambi ika bebele.” ");
INSERT INTO iyx_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Me ndeeli kwaa beni ti mu iluumbu kia pfuundisi ngaanda yii sa yivulu ngaanda a Sodomo mu umono pasi.» ");
INSERT INTO iyx_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Aa ngebe kwaa we, Korazini, aa ngebe kwaa we, Betesayida! Ka so bimaanga biayilimi kwaa beni biamonii mu Tiro na mu Sidoni, keni bele pe baata bakoto mu bukwiili, balwaata masaaka ma ngooto, badiaali nha lifuta na bakiingili mayele. ");
INSERT INTO iyx_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ni mu buu mu iluumbu kia pfuundisi pasi dia beni sa divulu mifuri na dia ku Tiro na ku Sidoni. ");
INSERT INTO iyx_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","A we Kapernawumi, we siiri imiini ti we sa banaangila natee ku yula? Ngori, sa bakululu we natee ku tsi a babakwa.» ");
INSERT INTO iyx_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yiisu abwileele kwaa miyii mia nde: «Pasi wu uyuu beni yuyi me, wu utunu beni tuni ka me, na wu tunu me tuni ka watsindii me.» ");
INSERT INTO iyx_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Miyii maku tsaamba na mioolo miayiri avutuu mu kinyi, na baleeli: «Pfumu, so miheebili mimibi mili mu utumumu bisi mu kuumbu a we.» ");
INSERT INTO iyx_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yiisu aleeli kwaa bo: «Me moniaangi Saatina siotii ku yula weti nzieri. ");
INSERT INTO iyx_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Diyuu, me nadiha lituu la udiaata nha yulu a bataari na bangeenge, na nha yula litu loosi la mutaata. A uli iloo so imosi ki isa beni bubi pe. ");
INSERT INTO iyx_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ka a diyaanga mu yi pe, ti miheebili mimibi mili mu usiingili beni. Diyaanga bu makuumbu ma beni masonomo mu mayula.» ");
INSERT INTO iyx_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mu dii na taanga dii, Yiisu aluuli mu kinyi mu Muheebili wa Ngira, aleeli: «Me tooni kwaa we Taata, Pfumu a yula na tsi, mundaa ti we asweeyi mandaa maa moosi kwaa bangaa mayele na buyeri, na amweesi mo kwaa bikenyi. Ee, Taata, ka we tooni buba weti buu. ");
INSERT INTO iyx_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Taayi a me ayeelili me bioosi. Muutu pe wayaaba na li Mwaana mbii a Taayi pe. Na muutu pe wayaaba Taayi mbii a Mwaana pe na wuu wu Mwaana atooni umweese nde.» ");
INSERT INTO iyx_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tumake Yiisu asieetii kwaa miyii mia nde na aleeli kwaa bo nha peembi: «Kinyi kwaa misi mili mu umono ma beni dili mu umono. ");
INSERT INTO iyx_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ni mu buu me nadileeli: Mibili mialaa na mitini batooni umono ma beni dili mu umono, ka a bamoni mo pe, na uyuu ma diyuu beni, ka a bayuyi mo pe.» ");
INSERT INTO iyx_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mono, muyiisi a mikele atemini na aleeli kwaa Yiisu mu ukete nde: «Muyiisi, ima nafwaana usa paa me holo mukobo wa moonyi wa bilimi na bilimi?» ");
INSERT INTO iyx_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yiisu aleeli kwaa nde: «Ima basonuu mu mikele? Buni weli mu utaanga?» ");
INSERT INTO iyx_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mukuutu a mikele avutili, aleeli: «Toono Pfumu Nziaambi a we mu mutimi a we woosi, mu muwuumu a we woosi, mu mifuri mia we mioosi na mu matsimi ma we moosi. Tumake toono mbaayi a we weti we makulu.» ");
INSERT INTO iyx_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yiisu aleeli kwaa nde: «We vutili bubwe. Sa buu na we sa baa moonyi.» ");
INSERT INTO iyx_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ka nde atooni umweese ti nduru a nde yili yasuungunu, aleeli kwaa Yiisu: «Ka mbaayi a me ni na?» ");
INSERT INTO iyx_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yiisu avutili, aleeli: «Muutu akulini ku Yeriko umata mu Yeruselemi, biwulu biamukaangi, biamuteti, biamupatili bikutu bi ali alwaata na bioosi biali na nde, biamusiisi nha peembi a likwa. ");
INSERT INTO iyx_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Bwali ti nguu a ngaanga a Nziaambi mosi akulini mu kuulu yii, bu wamumoni, alabii nha peembi. ");
INSERT INTO iyx_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Pili mosi, mulevita mosi ka atoori nha mbuu yii, bu wamunoni, alabii nha peembi. ");
INSERT INTO iyx_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ka musi Samaria mosi wakiyene ku midieenge, atoori nha li muutu wuu. Bu wamumoni, wamukwiili ngebe dialaa. ");
INSERT INTO iyx_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Asweesi kwaa nde, ayitili maari na viinyi mu maputu ma nde na akuti mo mu matsaanda tumake anaayi nde nha yulu a puundi a nde makulu, wamubiti ku nzo a bieenyi, wamubaasili. ");
INSERT INTO iyx_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Bukia ngwaali musi Samaria apalisi mikuti mioolo, ahi mio kwaa pfumu a nzo, aleeli: “Baasila nde bubwe, pasi kio ikimi ki we kaatsindi mu nde, me sa futu we kio bu me kaayiri avutuu.” ");
INSERT INTO iyx_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Mu bo batata, na we tsimi li mbaayi a wubiwulu biakaangi?» ");
INSERT INTO iyx_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mukuutu a mikele aleeli: «Ni wuu, wamukwiilili ngebe.» Yiisu aleeli kwaa nde: «Yene we ka sa pili mosi.» ");
INSERT INTO iyx_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Bu Yiisu ali mukuulu na miyii mia nde, akoti mu bula bu mosi. Mukaasa wa kuumbu Marte wamuyaki mu nzo a nde. ");
INSERT INTO iyx_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marte ali na mwaana a nguu, kuumbu a nde Mari wadiaali nha miili mia Pfumu, na akiyuu mandaa ma nde. ");
INSERT INTO iyx_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marte ali mutele-mutele mu ndaa bisala bia ulaamba. Ayiri kwaa Yiisu, aleeli: «Pfumu, a yili mu usa we pasi pe ti mwaana a nguu a me asiisi me bake me sa bisala bioosi? Wamuleele abaasila me.» ");
INSERT INTO iyx_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pfumu avutili kwaa nde: «Marte, Marte, we li na matsimi ma mutele-mutele mu mandaa malaa. ");
INSERT INTO iyx_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ka ndaa ndila imosi yili na mufunu; Mari siooli ibari ki ibwe ki bamuhele umaasila.» ");
INSERT INTO iyx_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Iluumbu imosi, Yiisu akikuundu nha mbuu mosi. Bu nde amani ukuundu, mosi mu muyii a nde aleeli kwaa nde: «Pfumu! Wadiyiisi ukuundu mbii bu Yowani ayiisi miyii mia nde.» ");
INSERT INTO iyx_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yiisu aleeli kwaa bo: «Bu dibaakuundu, dileele mbii bu: “Taayi, nyaala kuumbu a we yiba ya Ngira, nyaala Ipfumu kia we iyira, ");
INSERT INTO iyx_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","wadiha bia udia bia bisi bia pasi iluumbu. ");
INSERT INTO iyx_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Sa masumu ma bisi kolokolo, ka bisi ka dibaasa kolokolo kwaa ba bu baasa bisi bubi, a nyaala bisi dibwa mu mapuusu pe.”» ");
INSERT INTO iyx_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nde abwileele kwaa bo: «beni boosi na uli na mbaayi: na uyene kwaa nde mu kati a kati a butsuu, na uleele kwaa nde: “Mbaayi, soomboso me mapa matata, ");
INSERT INTO iyx_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ka mosi mu banduu ba me mati ku midieenge bu ayiri kwaa me, me a ndi na iloo pe kia uha nde.” ");
INSERT INTO iyx_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ka uli mu nzo vutili, na leeli: “Nyaala me bunyanga! Munywa a nzo ba maakwadibuu mu tsiafi, baana na me makulu diamaala, a nituu utemene pe mu uha we mo.” ");
INSERT INTO iyx_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Me nadileeli, so nde atemini pe mu uha nde mo, mu ndaa bu ali mbaayi a nde, sa atemene mu uha bioosi bi mbaayi a nde ali na tsata, mu ndaa pungusu yi ali mu usa nde. ");
INSERT INTO iyx_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ka me nadileeli: diloombo, sa badiha; disaa, beni sa disololo; dikomboto sa badidibili, ");
INSERT INTO iyx_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ka pasi wu uloombo, baheeri; wu usaa, solili; wu ukomboto, bamudibili. ");
INSERT INTO iyx_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ki taayi mu beni, so mwaana a nde so loombi tswi, nde wamuheeri taari? ");
INSERT INTO iyx_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Na so loombi bi, wamuhii ngeenge? ");
INSERT INTO iyx_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ka beni badili baata bababi, diayaaba uha baana ba beni biloo bibibwe, kaambisa Taayi wuli ku yula, sa akoono uha Muheebili wa Ngira kwaa babuloombo?» ");
INSERT INTO iyx_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Iluumbu imosi, Yiisu abingi muheebili wu mubi wa kitiisi muutu baba. Bu muheebili wu mubi apali, baba latsuyi; makoongi ma mali nhaa makimii. ");
INSERT INTO iyx_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ka ba bamosi mu bo baleeli: «Nde ubaabingi miheebili mimibi mu lituu la Belezebuli, uli mukuutu a miheebili mimibi!» ");
INSERT INTO iyx_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ba bakimi bamuketi, bamuloombi iliimbi ki imata ku yula. ");
INSERT INTO iyx_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Bu Yiisu ayaabi matsimi ma bo, wabaleeli: «Pasi ipfumu ki ikoto mu kabini, sa itsaamuu, manzo ma bo sa mabwa mana nha yulu a mana. ");
INSERT INTO iyx_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Beni dileeli ti, me nibaapalisa miheebili mimibi mu lituu la Belezebuli, pili mosi ti Saatina li mutaata a nde makulu. Ka buni ipfumu kia nde idiingi? ");
INSERT INTO iyx_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","So nibaapalisa miheebili mimibi mu lituu la Belezebuli, ka baana ba beni mu ki lituu bali mu upalisa mio? Ni mu buu bo sa baba bafuundisi ba beni! ");
INSERT INTO iyx_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ngwanya mu lituu la Nziaambi me nibaapalisa miheebili mimibi. Bu li mu mweese ti Ipfumu ya Nziaambi kiamaato kwaa beni.» ");
INSERT INTO iyx_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«Muutu wa mifuri wuli na bidwaanini, bu ali mu ukebe nzo a nde, bia nde bioosi bili mu iholo. ");
INSERT INTO iyx_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ka wavulu nde mifuri ayiri, sa wamubwiisi, tumake sa wamupatila bidwaanini bia nde bioosi bi aba mu usa imiini, na ukaba bioosi bi wamuholi. ");
INSERT INTO iyx_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Pasi wu uhele ba na me, abele me; wu uhele ukukuu na me, li mu utsara.» ");
INSERT INTO iyx_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Bu muheebili wumubi upala mu muutu, sa ayene mu mambuu ma tsata, mu uyoosaa mbuu ya puumini. Ka mbiiti nde a solili yo pe, nde sa aleele: “Me nivutuu ku nzo a me yinasiisi.” ");
INSERT INTO iyx_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Bu ayiri a vutuu, moni nzo bakoombolo na bayiluu bubwe. ");
INSERT INTO iyx_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tumi nde sa ayene mu usaa miheebili tsaamba mikimi miavulu nde mu buhaangi, mio sa mikoto na udiaalila mu nzo yii. Mapasi ma muutu wuu sa mavulu mifuri na ma tsiomi.» ");
INSERT INTO iyx_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yiisu bu amani mandaa maa uleele, mukaasa mutso koongi yii anaangili ndaa, aleeli kwaa nde: «Kinyi yili na moonyi wakibiti we, na mabeene makinywiisi we!» ");
INSERT INTO iyx_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ka Yiisu avutili aleeli: «Bu bwee beeri mu leele, kinyi yili na ba bubaayuu mandaa ma Nziaambi na usalila mo!» ");
INSERT INTO iyx_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Makoongi bu madiengilili Yiisu, nde aleele kwaa bo: «Kubu yiinayi ni kubu yimbi. Bo basaa imaanga, ka a bubaa iloo pe, so a ndila iliimbi kia yilimi mu Yoona. ");
INSERT INTO iyx_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Mbii bwali Yoona iliimbi kwaa basi Ninive, ni buu bukaaba Mwaana a muutu kwaa kubu yi. ");
INSERT INTO iyx_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Mu taanga dia pfuundisi, mutini wa mukaasa wa ku baanda sa atemene nha kulu a baata ba kubu yi na nde sa abwiisi bo. Ka nde amati mwasieele matsi mu uyuu buyeri ba Salomo. Mono nha uli na wa vulu Salomo! ");
INSERT INTO iyx_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mu taanga dia pfuundisi, basi Ninive sa batemene nha kulu a kubu yiinayi na sa babwiisi bo mu ndaa ti basi Ninive bakiingili mayele ma bo bu bayuyi nziisili a Yoona. Ka uli nhaa na nhana wavulu Yoona!» ");
INSERT INTO iyx_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Muutu a utuu unamisa mwiindi na usuusu nde nha mbuu ya tsweeyi pe, so ku tsini a ipaayi pe. Ka bali mu usuusu mwiindi, nha yulu, paa ba bukoto mu nzo bamono liyalila. ");
INSERT INTO iyx_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mwiindi a nyutu ni lisi la we. So lisi la we lili polo, nyutu a we yoosi yili mutso liyalila. Ka bu lisi libeeli, nyutu a we yoosi yili pimisi ka. ");
INSERT INTO iyx_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ni mu buu kebe liyalila lili mu we, a liyakituu pimisi. ");
INSERT INTO iyx_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","So nyutu a we yoosi yili mu liyalila, na ibari so imosi a yili nha pimisi pe, yo yoosi sa iyaluu mbii bu mwiindi wu ubaayalisa we.» ");
INSERT INTO iyx_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yiisu bu ali kini mu utsuu, mosi mu bafarisi wamukuungi mu uyadia na nde, Yiisu akoti na adiaali nha meese. ");
INSERT INTO iyx_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mufarisi akimii bu amoni Yiisu mu udia, kwahele ukwaswaa mioo. ");
INSERT INTO iyx_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ka Pfumu aleeli kwaa nde: «Beni bafarisi, dibaatsieemese mbasa na ikoombo ku mbari, ka ku kati beni dialuulu mu musoyi na mimibi. ");
INSERT INTO iyx_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Beni biwulu! Nziaambi wayiluu mbari a biloo, a ni nde pe ka wayiluu kati a bio? ");
INSERT INTO iyx_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Diha bioosi bi bili mu kati kwaa bawele weti bungori na bioosi sa bitsieeme mu beni.» ");
INSERT INTO iyx_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Aa! Ngebe kwaa beni Bafarisi! Ka beni dibaaha ikuku kia kuumi-kuumi mu nduungu a mbala, na nduungu, na bitiiti bioosi bi dibaadia. Ka diameengele mbweeyili na litoono la Nziaambi, bunu bii ni biafwaana mu usa, kwahele a udiimbili bini.» ");
INSERT INTO iyx_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Aa ngebe kwaa beni Bafarisi! Bu dibaatoono mambata ma matsiomi mu manzo ma makutunu, na diatoono uyaka mabwe ma likiinzi mu kulu a mbari.» ");
INSERT INTO iyx_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","«Aa ngebe kwaa beni, bu dili weti mangili ma mahele uyabana, baata bali mu udiaata nha yula a mo kwahele a uyaaba!» ");
INSERT INTO iyx_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mosi mu bayiisi ba mikele aleeli kwaa nde: «Muyiisi, bu li mu uleele maa, uli mu umoonuu weti we li mu utuu bisi!» ");
INSERT INTO iyx_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ka Yiisu avutili aleeli: «Aa ngebe kwaa beni bayiisi ba mikele! Ka beni dili mu unaa mifuna mialeme mu ubiti nha yula baata, ka beni bameme a dibaabeembe mifunu mii muleembi a beni so mosi pe. ");
INSERT INTO iyx_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Aa ngebe kwaa beni, ba dibaatuungu mangili ma mibili bu diayaaba ti ba taayi ba beni badusi mio! ");
INSERT INTO iyx_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ka beni dili mu umweese ti diasiingi biyiluu bia bataayi ba beni mundaa ti bo badusi mibili na beni dili mu ubaatuungu mangili ma mibili mii. ");
INSERT INTO iyx_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ni mu buu, Nziaambi mu buyeri ba nde aleeli: “Me sa na batsinduu mibili na batumu. Sa badusu ba bakimi mu bo na ukwaamisa ba bamosi.” ");
INSERT INTO iyx_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ni mu buu, kubu yi, sa basieembe yo mu ndaa makila ma mibili mioosi mamatsiaamii umata mbaandila tsi, ");
INSERT INTO iyx_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","umata mu makila ma Aabeli natee makila ma Zakaria wu badusi nha kati a diki la nzosili na mbuu ya ngira. Ka me nadileeli: kubu yi sa basieembe yo mu ma mabi maa moosi.» ");
INSERT INTO iyx_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Aa ngebe kwaa beni bayiisi ba mikele! Bu diaholii tsiafi a nziaabili na beni bame a diakoto pe, na dili mu ubaakiki ba batoono ukoto.» ");
INSERT INTO iyx_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ka, Yiisu bu apali mu nzo, bayiisi ba mikele na bafarisi ba mukwaamisi mu iteesi kia mifuri, na ufuulu nde ma nduru ma mupili na mupili. ");
INSERT INTO iyx_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Bamuketi paa babaa mu nde toono mu ma mupala mu munywa a nde! ");
INSERT INTO iyx_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mu taanga dii, mafuundu ma baata makukini, madiaatisini. Yiisu akwiyaabisa kwaa miyii mia nde: «Disa mayele mu liviiri la bafarisi, ni peluu a bo. ");
INSERT INTO iyx_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","A uli na iloo kiasweeme pe ki buhele usololo, na kii kia tsweeyi ki ihele uyabina. ");
INSERT INTO iyx_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ni mu buu, moosi ma dileele kutso pimisi, sa bayuu mu taanga dia liyalila. Ma moosi ma dileele mu mapfuundu, mu itsuru kia kati a nzo, sa mayabina nha kati a baata.» ");
INSERT INTO iyx_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Me nadileeli bambaayi ba me: a diba na boomo ba babubaadusu nyutu pe, ka nha mbisi a nhaa a bubwabaa yi bu tuu usa pe. ");
INSERT INTO iyx_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ka me sa nadilaa wu beni diafwaana ubatila boomo. Dibata Nziaambi uli na lituu la udumunu beni ku diaanga la mbaa nha mbisi a udusu. Ee, me nadileeli, wu dibatila!» ");
INSERT INTO iyx_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","«A bubaayaluu masiee mataana mu mikuti mioolo pe? Ka pasi lo, lili na ndaanda nha kulu a Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ka naanga dia mitswe mia beni dioosi bataanga dio. A diba na boomo pe, beni diavuli masiee ma malayi ndaanda!» ");
INSERT INTO iyx_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Me nadileeli: Pasi wu uta imbaangi mu me nha kulu a baata, Mwaana a muutu ka sa ata imbaangi mu nde nha kulu a batumu ba Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ka pasi wu utunu me nha kulu a baata, Mwaana a muutu ka sa atunu nde nha kulu a batumu ba Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Pasi wu uleele ma mabi mu Mwaana a muutu, sa bamusa kolokolo, ka pasi wu utuu Muheebili wa Ngira, a busiingi kolokolo a nde pe. ");
INSERT INTO iyx_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Mu taanga di bubiti beni ku ma nzo ma makutunu ma Bayuudayo nha kulu a bafuundisi, so ba bali na litumu paa badifuundusu, a diba na maketi-keti pe mu ma diafwaana uvutulu, na ima diafwaana uleele. ");
INSERT INTO iyx_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ka Muheebili wa Ngira sa wadiyiisi ma diafwaana uleele mu taanga dii.» ");
INSERT INTO iyx_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mosi mutso koongi aleeli kwaa Yiisu: «Muyiisi, leele kwaa mwaana a nguu a me akaba na me mukobo a bisi.» ");
INSERT INTO iyx_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ka Yiisu avutili kwaa nde: «Na abiaalisa me mu uba nzioonzi so mukabi a mbayili a beni?» ");
INSERT INTO iyx_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tumake aleeli kwaa bo boosi: «Diyele mu nzala ya ubaa kwa lutulu iteesi, ka idiingi kia muutu a kia tsikini mu mbayili a nde pe so nde li na busini balaa.» ");
INSERT INTO iyx_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nde ati tsaba yi kwaa bo, aleeli: «Muutu mosi wa isini ali na matsiee mabuti mbutu dialaa. ");
INSERT INTO iyx_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Muutu wuu atsimi mu mutimi a nde, aleeli: “Bibaanga bi ndi na bio bi bikee, kuni nisuusu bi kukii biinabi?” ");
INSERT INTO iyx_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ka mono: “Bubwe mu utsara bibaanga bi naba na bio, na utuungu bia vulu bunene, tumake me kukuu biloo bioosi. ");
INSERT INTO iyx_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ku mbisi me sa ndeele kwaa muwuumu a me: Muwuumu a me, we li na biloo bialaa bi kukii mu bilimi bialaa bikaayira, ki wuumu, dia, nywa, sa mukuungi.” ");
INSERT INTO iyx_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ka Nziaambi aleeli kwaa nde: “Aa ngaa buwulu! Butsuu ba we sa kwa. Ninha bioosi bi we kukii bia na bikaa ba?”» ");
INSERT INTO iyx_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yiisu abwileele: «Ni buu bu li mu umonuu kwaa uli mu ukukuu busini ba ndeme, na uhele na busini nha misi mia Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yiisu abwileele kwaa miyii mia nde: «Ni mu buu me nadileeli: A dikwaamisa pe mitimi mia beni, mu bi dikaadia mu ndaa idiingi kia beni, so mu bi dikaalwaata mu manyutu ma beni. ");
INSERT INTO iyx_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ka idiingi, kia vulu biloo bia udia, na nyutu ya vulu milwaata. ");
INSERT INTO iyx_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ditala bikwaakwaa a bibaakunu so ukukuu pe, a bili na bisweeyili so bibaanga pe; Ka Nziaambi ubaa buungulu bio! Ka beni diavulu banyunyi kwalaa! ");
INSERT INTO iyx_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Na mu beni, mu ndaa miniongo mia nde, utuu ubweese so iluumbu imosi mu idiingi kia nde? ");
INSERT INTO iyx_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","So dikooni ndaa yi kee, mu ima dili mu ukwaamosa mitimi mu mandaa ma kimi? ");
INSERT INTO iyx_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Dimono buli mu ukulu bifulu bia matsiee, a bili mu usala pe, na a bibaatuungu pe; ka me nadileeli: So Salomo mu buzitu ba nde boosi a alwaati pe mbii imosi mu bifulu. ");
INSERT INTO iyx_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","So Nziaambi ubaalwaatisa bitiiti bia mu matsiee lolo, na nha ngwaali sa badumunu bio mbaa: buni nde ukoono uyiluu buu kwaa beni! Aa, beni baata ba ngaa imiini ki ikee! ");
INSERT INTO iyx_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ni mu bu, beni a diafwaana ukwaamisa mitimi mia beni pe, mu bi dikaadia so bia unwa. ");
INSERT INTO iyx_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ni bangooyi ba tsi bafwaana usa weti buu, ka beni dili na taayi wayaaba manzaala ma beni moosi. ");
INSERT INTO iyx_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Disaa Ipfumu kia Nziaambi tumi nde sa adibweese bini bioosi bi dili na nzala a bio.» ");
INSERT INTO iyx_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Mwaa mukaanga aba na boomo pe! Ka litoono la Taayi a beni ni mu uhaa beni Ipfumu. ");
INSERT INTO iyx_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Diyaluu bi beni dili na bio, diha mboongo kwaa bawele, diyiluu bipokolo bia mboongo bi bihele ufuu. Dikukuu busini mu mayula ma Nziaambi, ku muyibi ukoono ubesene, na batsierere a butuu ubiiyisi bo pe. ");
INSERT INTO iyx_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ka kuu kuli busini ba beni, ni kuu kukaaba mitimi mia beni ka.» ");
INSERT INTO iyx_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Diyilimi, dikweete kobo mu maluungu ma beni na miindi mia beni miba mia nama. ");
INSERT INTO iyx_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Difwaanina na baata ba bali mu ukebe pfumu a bo. Bu nde umata ku mukuungi a makweele, akomboto nha munywa a nzo, bo sa badibili mu mawasa. ");
INSERT INTO iyx_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kinyi kwaa basiali baa, ba bu pfumu a bo uyiri avutuu, wababaasi bali likanda. Ngwanya me nadileeli: Pfumu sa alwaata bikutu bia isala na sa wabaleele mu udiaala nha yulu a meese paa nde akaba bo bia udia. ");
INSERT INTO iyx_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","So nde toori mu tsutsu a tsiomi so mu tsutsu wa boolo na wababaasi likanda, kinyi kwaa bo! ");
INSERT INTO iyx_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Diyuu: so pfumu a nzo ayaaba taanga dikaayira muyibi, buni keni nde a unyaala pe muyibi abulu nzo a nde. ");
INSERT INTO iyx_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Beni ka diyilima, bu diahele uyaaba taanga di kaayira Mwaana a muutu.» ");
INSERT INTO iyx_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peetero aleeli kwaa nde: «Pfumu, teeri tsaba yi, kwaa bisi kele so a buu pe kwaa baata boosi?» ");
INSERT INTO iyx_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Pfumu avutili: «Ka na li musiali wu mubwe na wa mayele? Ni wu pfumu a nde akaabiaalisa ikuutu mu nzo a nde, paa adisili basiali ba bamosi mu taanga diafwaana. ");
INSERT INTO iyx_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kinyi kwaa na musiali wu pfumu a nde bu akaayiri avutuu, nde li kutso isala, mbii bu bamusiisili kio. ");
INSERT INTO iyx_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ngwanya me nadileeli: Pfumu, sa wamubiaalisa litumu mu bioosi bi ali na bio! ");
INSERT INTO iyx_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ka so musiali wuu leeli mu mutimi a nde: “Pfumu a me a ubaa pe uyiri, sa adiingi mu uyiri!” Na nde baandii mu utete basiali ba bamosi ba babaala na ba Bakaasa, na diri, nywiri, na koli mala. ");
INSERT INTO iyx_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Bu pfumu a musiali wuu akaayira mu iluumbu na taanga di musiali ahele uyaaba, pfumu sa wamubingi, na sa wamukitisi mbuu mosi na babahele a imiini. ");
INSERT INTO iyx_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ka musiali wayaaba litoono la pfumu a nde, na a yilii pe mbii buli litoono la pfumu, nde sa bamudusu kubu ndusili yalaa. ");
INSERT INTO iyx_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ni mu buu, musiali wahele uyaaba litoono la pfumu a nde, ka yilii ma mabi, sa batete nde kwa ukee. Pasi wu bayi bialaa, sa bamuloombo ka kwalaa, pasi wu baha bia funu, sa baloombo kwaa nde ka biavululu.» ");
INSERT INTO iyx_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Me nayiri mu dumunu mbaa nha tsi, na tooni beeri ti mbaa me, keni yi maa-na-ma! ");
INSERT INTO iyx_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Me ndi na libootuu la uholo, ki pili a pasi mu me natee bu lo liyilimi! ");
INSERT INTO iyx_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","A ditsimi pe ti me nayiri mu ubee iyeenge nha tsi. Me na dileeli: Ngori, mu me sa uba kabini. ");
INSERT INTO iyx_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ni mu buu, umata lolo li, mu bataa bataana bali mu nzo mosi, sa bakabuu, batata kolo ya bo, boolo ka kolo ya bo: ");
INSERT INTO iyx_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Taayi sa abaa mutaata kwaa mwaana wa baala, mwaana wa baala kwaa taayi nde. Nguu sa baa mutaata kwaa mwaana wa mukaasa, na mwaana wa mukaasa kwaa nguu nde. Nguu a mulumi sa aba mutaata a buko ba mukaasa, buko ba mukaasa ka sa abele nguu a mulumi a nde.» ");
INSERT INTO iyx_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yiisu aleeli ka kwaa makoongi: «Bu dimono ibala, ikumi ku peembi yi yidiaama taanga, beni dileeli mu mawasa: “Mvulu sa anoo”, sa buba weti buu. ");
INSERT INTO iyx_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ka bu mupepe wa ku baanda li mu ufuulu, beni dileeli: “Sa iba na kiaangila kia mifuri”, na sa buba weti buu. ");
INSERT INTO iyx_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Bangaa peluu, beni diayaaba usoboso biliimbi bia ku yulu na bia nha tsi buni dili kutso bundimbi na uhele uyaaba mu ki taanga dika?» ");
INSERT INTO iyx_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Mu ima, dili mu uhele uba na mbahila mu ibene bameme, mu uyiluu ma libweeye? ");
INSERT INTO iyx_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ka buli mu uyene na mutaata a we ku nzo a pfuundisi, bubwe mu ukwayuhusunu bu dili na nde keni mu kula, paa nde anyaala uyeelele we nha kulu a nzioonzi. Tumake nzioonzi a ayeelele we pe kwaa masodaare makaadumunu we mu perese. ");
INSERT INTO iyx_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Me ndeeli kwaa we: Ti we a upala muu pe, so we a beli yamaa loosi pe, natee bu ufutu mukuti wa tsieelele.» ");
INSERT INTO iyx_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mu taanga dii, baata ba bamosi bayileele Yiisu, mia yilii Pilato bu atumi badusu basi Ngalili mu taanga di bo bakiha bungori ba diki kwaa Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yiisu avutili kwaa bo: «Mu matsimi ma beni ti basi Ngalili baa bavulu baata boosi ba Ngalili mu masumu, paa bo bamono pasi dia pili yii? ");
INSERT INTO iyx_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Me nadileeli: Ngori, beni ka so a dikiingili mayele pe, beni boosi sa dikwa pili mosi na bo. ");
INSERT INTO iyx_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","So a buu pe, kuumi na pwoombo (18) la baata, ba babwiilili nzo Silowa bu bakwiri, mu matsimi ma beni ti bo bavulu baata boosi, bali mu udiaala mu Yeruselemi mu ma mabi? ");
INSERT INTO iyx_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ngori, me nadileeli: ka so a dikiingili mayele pe, beni boosi sa difuu pili mosi na bo ka.» ");
INSERT INTO iyx_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Nha yulu a maa, nde ati ka bo tsaba yi: «Muutu ali akunu muti wa mufiike mutso nguundu a nde ya viinyi; bu ayiri ku usaa mbutu mu nde ka a bayi dio pe. ");
INSERT INTO iyx_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nde aleeli kwaa musiali a nguundu a viinyi: “Mono, bilimi bitata nibaayasaa mbutu mu muti wa mufiike wu, ka a nibaabaa dio pe. Kwaanga nde! Mu ima ali mu ubiiyisi tsieengi kwahele a ndaanda?” ");
INSERT INTO iyx_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Musiali avutili, aleeli kwaa nde: “Pfumu, manyaala nde ilimi ki natee me maatipi toto diadiengelele nde na ulooso mboloso. ");
INSERT INTO iyx_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Paa hele sa abutu mbutu bilimi bi biyiri, so a buu pe, sa diamukwaanga.”» ");
INSERT INTO iyx_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mu iluumbu kia saba, Yiisu akiyiisi mu mosi mu manzo ma makutunu ma Bayuudayo. ");
INSERT INTO iyx_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mono mwali muu na mukaasa ngaa ipii kia mungoongo wabaandina umata bilimi kuumi na pwoombo, mbii bu muheebili wu mubi akaangi nde, mu iteesi kia uhele usuungunu bubwe. ");
INSERT INTO iyx_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yiisu bu wamumoni, wamuteeri mbila, aleeli kwaa nde: «Mukaasa, we maakuuluu mu ibeeri kia we.» ");
INSERT INTO iyx_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yiisu wamunayi mioo, nhaa-na-tsi nde uyaaba usuungunu, na abili Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ka mukuutu a nzo a makutunu a Bayuudayo akoli kesi bu Yiisu abeelisi mu iluumbu kia saba. Na aleeli kwaa koongi: «Biluumbu bisamina biafwaana mu isala; beni diafwaana mu uyiri badibeelese mu bio, ka a mu iluumbu kia saba pe!» ");
INSERT INTO iyx_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Pfumu avutili kwaa nde, aleeli: «Beni bangaa peluu! Muutu-muutu mu beni a ali mu unyangila ngoombo so puundi a nde nha idiilili ya nde mu saba pe, na ubiti iboori mu uyanywiisi kio pe? ");
INSERT INTO iyx_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ka mukaasa wu, uli ka ni mwaana a Abraami, wu Saatina akutu bibolo umata kuumi na bilimi pwoombo, ka a bubwe pe mu unyangila nde mu mapaanga mu iluumbu kia saba?» ");
INSERT INTO iyx_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Bu aleeli maa, mitaata mia nde mioosi miakwi tsionyi; koongi yoosi yali na kinyi, mu moosi ma buzitu ma nde ali ayilii. ");
INSERT INTO iyx_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yiisu aleeli: «Na ima Ipfumu kia Nziaambi kiafwaanina? Na ima me nituu ufwaanisa kio? ");
INSERT INTO iyx_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kio yafwaanina na libutu la booyi li muutu akuni mu wooto la nde, bu lameni, lakulii, na la kitii muti, banyunyi ba yula batuungi manzo ma bo mu mapaki ma nde.» ");
INSERT INTO iyx_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yiisu abwileele: «Na ima nituu ufwaanisa Ipfumu kia Nziaambi? ");
INSERT INTO iyx_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kio yafwaanina na lifunusu la mapa li mukaasa aholi, avuuti lo na iteesi ki ilayi kia fariini a mapa natee bioosi biamani ufunu.» ");
INSERT INTO iyx_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yiisu bu akitaba mangaanda na mala mu uyene ku Yeruselemi, nde akiyiisi kulu a kulu. ");
INSERT INTO iyx_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Muutu wamufuuli: «Pfumu iteesi kia ba buyobuu ki ikee ili?» Yiisu avutili, aleeli: ");
INSERT INTO iyx_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Didwaana mu ukoto mu munywa wasweetene: ka me nadileeli, ba balayi sa basaa mu ukoto ka a butuu pe.» ");
INSERT INTO iyx_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","«Mu taanga di pfumu a nzo akaatemene, na ubiinduu munywa a nzo, beni ba diasaala ku mbari, sa diyakomboto nha munywa a nzo na uleele: “Pfumu, Pfumu, wadidibili.” Ka nde sa avutulu kwaa beni: “Me a nayaaba pe beni ba kuni!” ");
INSERT INTO iyx_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Bunu beni sa diamuleele: “Bisi diadi na dianywi na we, we ayiisi mu makuulu ma mu mangaanda ma bisi.” ");
INSERT INTO iyx_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nde sa abwaleele kwaa beni: “Me a nayaaba pe beni ba kuni dili. Dimatuu nha pele a me, beni ba dibaasa ma mabi!” ");
INSERT INTO iyx_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Beni sa dilili na ukweete mini, bu dikaamono Abraami na Isaki na Yaakobi na mibili mioosi mu ipfumu ya Nziaambi, ka beni sa ba bingi ku mbari! ");
INSERT INTO iyx_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Baata sa bamata ku peembi ya ku yi pala taanga na ku yidiaama taanga, ya ku taanda na ya baanda, sa badiaala nha meese mu Ipfumu kia Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ni mu buu, uli na ba batsieelele bakaaba batsiomi, na ba batsiomi bakaaba batsieelele.» ");
INSERT INTO iyx_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mu taanga dii, bana mu bafarisi bayiri, baleeli kwaa Yiisu: «Pala, matuu mu ngaanda yi, mu ndaa ti Erode atoono we udusu.» ");
INSERT INTO iyx_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yiisu aleeli kwaa bo: «Yenani dileele kwaa mubaa wuu: “Me ndi mu upalisa miheebili mimibi na ndi mu ubeelese babeeri mu lolo li, na nha ngwaali, ka mu iluumbu kia bitata me sa mana isala kia me.” ");
INSERT INTO iyx_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ka mu lolo li na nha ngwaali na munamosi, me nafwaana udukusu kuulu yi ndi mu uyene. Mu ndaa ti a uli na muswa pe ti mubili bamudusu mu ngaanda kimi na Yeruselemi.» ");
INSERT INTO iyx_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Yeruselemi, Yeruselemi, we wu ubaadusu mibili na ubaadusu mu ma manya baa ba Nziaambi ubaatsinduu kwaa we! Bunu, taanga dialaa, me naba natoono ukukuu baana ba we, mbii bu tsutsu ubaafuu baana ba nde kutso mapapi ma nde, ka beni a diatooni pe! ");
INSERT INTO iyx_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Monani, sa ba bwoongolo nzo a beni. Me nadileeli: Beni a dibwamono me so hoolo pe, natee taanga di beni dikaaleele: “Nyaala Nziaambi asieme wu uyira mu kuumbu a Pfumu!”» ");
INSERT INTO iyx_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Bwali mu saba, Yiisu akoti mu nzo a mukuutu mosi mu bafarisi mu uyadia. Ba bali muu, basieetili misi nha yula nde, bamuketi. ");
INSERT INTO iyx_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mono muutu wali na ibeeri kia idaanda nyutu yoosi ayiri na atemini nha kulu a nde. ");
INSERT INTO iyx_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yiisu afuuli, aleeli kwaa bayiisi ba mikele na bafarisi: «Uli na muswa mu ubeelese muutu mu saba, ooti Ngori?» ");
INSERT INTO iyx_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Bo ba bawuri na pii. Yiisu akaangi mubeeri, wamubeelisi, na wa mu vutili kwa mati. ");
INSERT INTO iyx_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tumake, aleeli kwaa bo: «Na mu beni mwaana so ngoombo a nde abwa mu idunu, ka afwaana pe mupalisi nde, mu iluumbu kia saba?» ");
INSERT INTO iyx_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ka bo bakooni uvutulu ndaa mu nduru yi. ");
INSERT INTO iyx_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yiisu ati tsaba kwaa baba kuungi, bu amoni bu bo bakisoolo mambuu ma tsiomi, mutsolili a ma mbuu ma matsiomi, aleeli kwaa bo: ");
INSERT INTO iyx_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Bu bakuungi we kwaa muutu mu mukuungi a makweele, a diaala nha mbuu ya tsiomi pe. Ka helape batumusu muutu wavulu we mu buzitu. ");
INSERT INTO iyx_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Na watumusu beni baboolo, sa aleele we: “Siisi nde mbuu yii.” Ka we sa ba na tsionyi mu uyene ku mbuu yili ku mbisi. ");
INSERT INTO iyx_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ka bu bakuungi we, holo mbuu yili ku mbisi, paa nde watumisi we bu akaayiri sa aleele kwaa we: “Nduu a me, swese ku kula na ya diaala nha mbuu ya zaangama.” Babadiaala na we nha meese sa baha we buzitu. ");
INSERT INTO iyx_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ka nibuu, pasi wu unaanguu mu inde makulu sa bamukulula, ka pasi wu ukuluu mu inde makulu sa bamunaangila.» ");
INSERT INTO iyx_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yiisu aleeli ka kwaa wamuti mbila: «Bu li mu uyiluu ndaamba, atumusu pe ba nduu so baana ba nguu a we, so basi nzo ba we, so bambaayi ba we babisini, mu ndaa bo sa ba vutulu we mamvutu. ");
INSERT INTO iyx_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ka bu li mu uyiluu ndaamba, tumusu bawele, ba ngaa bifuumbu, ba bali na bitonzo, babakwa misi. ");
INSERT INTO iyx_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kinyi sa yiba na we, mu ndaa ti bo a bubaa kibuvutulu we pe, ka Nziaambi sa avutulu we mamvutu mu tsimbilili a balibweeye mu babakwa.» ");
INSERT INTO iyx_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Muutu mosi mu ba batumisi, bu ayuyi maa, aleeli kwaa Yiisu: «Kinyi kwaa wukaadia mu Ipfumu kia Nziaambi!» ");
INSERT INTO iyx_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ka Yiisu avutili kwaa nde: «Muutu alaambi ndaamba yi inene na atumisi baata balaa. ");
INSERT INTO iyx_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mu taanga dia udia, nde atsindii booyi la nde mu ya leele kwaa ba batumusu: “Yirani mu ndaa ti ndaamba ya maayilimi.” ");
INSERT INTO iyx_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kasi boosi babaandii uloombo kolokolo. Wa tsiomi aleeli kwaa nde: “Tsuumbiangi tsiee, ndi na nzala a yo uyamono, sa me kolokolo.” ");
INSERT INTO iyx_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Wu mumosi aleeli: “Me tsuumbiangi bangoombo kuumi, me nzeni ku ya kengese bo, Me loombi we mu usa me kolokolo.” ");
INSERT INTO iyx_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wu mumosi ka aleeli: “Me bu bukweelangi mukaasa, ni mu buu a nituu uyira pe.” ");
INSERT INTO iyx_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Musiali ayiri ahi mamvutu moosi kwaa pfumu a nde. Ka pfumu a nzo akoti mu kesi, na aleeli kwaa musiali a nde: “Pala na sa mawasa, yena saa mu makuulu ma manene na ma misoo ma mu kati a ngaanda, bee bawele, na bangaa bifuumbu na ba bakwa miisi na bangaa bitonzo.” ");
INSERT INTO iyx_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Musiali aleeli: “Pfumu, bu maayilimi mbii bu we tumi, ka mbuu keni ya saalila.” ");
INSERT INTO iyx_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Pfumu aleeli kwaa booyi: “Pala mu makuulu, na yene natee mu mala, pasi nde wu we umono, wababamuu mu uyiri kwa me, paa nzo a me yiluula.” ");
INSERT INTO iyx_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ka me nadileeli, ti a so mosi mu ba me naba na kuungu, ka biimba ndaamba a me.» ");
INSERT INTO iyx_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Makoongi ma vuuti kuulu na Yiisu. Nde bu asieetii, aleeli kwaa mo: ");
INSERT INTO iyx_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«So muutu uyiri kwaa me na heli ubele taayi a nde, na nguu a nde, na mukari a nde, na baana ba nde, na baana ba nguu ba nde ba babala na ba Bakaasa na paa idiingi kia nde makulu, a utuu uba muyii a me pe. ");
INSERT INTO iyx_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Pasi wu uhele ubiti kuruwa a nde na uduku me, a atuu uba muyii a me pe. ");
INSERT INTO iyx_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ka na mu beni, bu atooni utuungu nzo a yungi, ukwadiaala pe mu utaanga tala mboongo na uyaaba mbiiti dio sa dikuu mu umana nzo? ");
INSERT INTO iyx_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Helape, nha mbisi a utuungu ibwa, ka kooni umana, boosi babumono nde sa basa nde saa, na uleele: ");
INSERT INTO iyx_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Muutu wu abaandii utuungu, ka akooni umana.” ");
INSERT INTO iyx_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","«Bumosi ka kwaa mutini wuli mu uyene ku udwaanisa mutini mukimi mudiingi, afwaana ukwadiaala mu utsimi, buni nde utuu ubiingi mu fuundu la masodaare li ali na lo, bu ayaabi ti mbaayi wuu na mafuundu moolo ma masodaare. ");
INSERT INTO iyx_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","So nde moni ti nde a utuu pe ubiingi, nde keni na taanga dia utsinduu batumu na uloombo iyeenge kwaa mbaayi mutini bu akeni ku la. ");
INSERT INTO iyx_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Pili mosi ka mu beni, pasi wu uhele usiisi bioosi bi abaa, a utuu uba muyii a me pe.» ");
INSERT INTO iyx_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Mungwa li iloo ki ibwe. Ka so mungwa ma hele isie, na ima bubaavutulu isie kii? ");
INSERT INTO iyx_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Bunu nde ka ndaanda pe, so mu toto so mu mboloso, bafwaana ubumu nde. Wuli na matswi ma uyuu, nyaala nde ayuu!» ");
INSERT INTO iyx_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Batoli a limaanda boosi na bangaa masumu bayiri asweese kwaa Yiisu mu uyuu nde. ");
INSERT INTO iyx_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Bafarisi na bayiisi ba mikele, banhunhinyi mu ndaa Yiisu, baleeli: «Wuunawu ubaayaka bangaa masumu na ubaadia na bo!» ");
INSERT INTO iyx_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ka Yiisu wabatiri tsaba yi, aleeli: ");
INSERT INTO iyx_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Nha kati a beni, ki muutu uli na kama la mameme na diimbisi limosi mu mo, ka nde a usiisi maku wa na wa mu tsiee pe mu uyene usaa limeme ladiimbili natee bu usololo lo. ");
INSERT INTO iyx_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Bu asolili lo, naangila lo nha bisaambuu bia nde na yaangi. ");
INSERT INTO iyx_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Bu atoori ku nzo a nde, kukii banduu ba nde na bambaayi bebele na leeli kwaa bo: “Yaangani na me, mu ndaa ti me maasololo limeme la me laba ladiimbili.” ");
INSERT INTO iyx_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ni buu me nadileeli: mu yula sa muvulu uba na kinyi yalaa bu so ndila mosi mu bangaa masumu ukiingili mayele. Ka a mu maku wa na wa (99) pe a bangaa libweeye ba bahele na nzala a ukiingili mayele.» ");
INSERT INTO iyx_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«So a buu pe, ki mukaasa uli na kuumi la mikuti mia tala na diimbisi mosi, nde a unamisa mwiindi pe na ukoombolo nzo mu usaa bubwe-bubwe, natee bu asololo mukuti wuu? ");
INSERT INTO iyx_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Bu asolili mukuti wuu, sa ata banduu ba nde ba Bakaasa na bambaayi ba nde ba Bakaasa ba bebele mbila na uleele: “Yaangani na me, me maasololo mukuti a me wa tala waba wadiimbili!” ");
INSERT INTO iyx_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Me nadileeli: Nibuu buli na kinyi nha kulu a batumu ba Nziaambi bu ngaa masumu mosi ali mu ukiingili mayele.» ");
INSERT INTO iyx_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yiisu abwileele: «Muutu ali na baana boolo ba babaala. ");
INSERT INTO iyx_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Wa ngebe aleeli kwaa taayi a nde: “Taata, ha me ikuku kia mukobo.” Taayi akabi busini ba nde kwaa baana bo baboolo. ");
INSERT INTO iyx_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nha mbisi a taanga hoolo, mwaana wa ngebe akukii busini ba nde boosi na, ayeni ku tsi ya la. Kuu afuusi busini boosi mu makinyi ma tsi. ");
INSERT INTO iyx_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Bu amani usalila busini boosi, tsata ya mifuri yakoti mu tsi yii, nde ka akoti mu buwele. ");
INSERT INTO iyx_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nde ayeni mu usaa isala kwaa muutu mosi mu basi tsi yii wamutsindii ku matsiee ma nde mu uliisili bangulu. ");
INSERT INTO iyx_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nde ali na matsimi ma udia biloo bi bakiha bangulu, ka a bamuheri muswa pe mu udia dio. ");
INSERT INTO iyx_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ka matsimi madiengilili nde, aleeli: “Basiali kwe mu nzo a taayi a me, bali na biloo bia matsaalisa, ka kuni me ndi mu ukwaa mu nzala! ");
INSERT INTO iyx_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Me nafwaana uvutuu kwaa taayi a me na uleele kwaa nde: Taata, nasi masumu kwaa Nziaambi na nha kiinzi kia we. ");
INSERT INTO iyx_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","A nabwafwaana pe we bwata me mwaana a we. Kitisi me weti mosi mu basiali ba we.” ");
INSERT INTO iyx_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nde atemini na avutii kwaa taayi a nde.» «Ka bu ali keni la na nzo, taayi a nde wamutalili, wamukwiilili ngebe, adumi tiini, wamubwiilili mu kiingi na wamunyumbiti. ");
INSERT INTO iyx_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mwaana aleeli: “Taata, nasi masumu kwaa Nziaambi na nha kiinzi kia we, a nabwafwaana pe we bwata me mwaana a we.” ");
INSERT INTO iyx_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ka taayi aleeli kwaa basiali ba nde: “Mawasa-mawasa, dibee mulwaata wavulu mu bubwe, dilwaatisa nde nde, diamulwaatisa ka muluunga mu muleembi a nde na bikoori mu miili mia nde. ");
INSERT INTO iyx_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Dibee mukolo a ngoombo wa too, didusu nde, didiaanani na diyaangani. ");
INSERT INTO iyx_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Mundaa ti mwaana a me wu beeri wa kwaa maasiimbuu; beeri adiimbili ka solii.” Na babaandii uyaanga.» ");
INSERT INTO iyx_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Bu maa makiyilimi mwaana a nde wa mukuutu ali ku matsiee. Bu ayiri asweese nha nzo, ayuyi muniingi a ngoombi na makini. ");
INSERT INTO iyx_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nde ati mosi mu mabooyi mbila, wa mufuuli: “Ki ndaa yili mu uyoo?” ");
INSERT INTO iyx_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Musiali avutili kwaa nde: “Mukee a we maayiri avutuu, taayi we maadusu mukolo a ngoombo wa too, mu ndaa ti nde wamumoni keni moonyi.” ");
INSERT INTO iyx_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mono, mwaana wuu akoli kesi, na a abwitoono ukoto pe mu nzo. Taayi apali na wamupeli. ");
INSERT INTO iyx_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ka mwaana avutili, aleeli kwaa taayi a nde: “Mono, bilimi bialaa ndi mu ubaasalila we, kaala a natunu mikele mia we pe, ka we a ahi me so mwaana a taba pe paa me yaanga na banduu ba me. ");
INSERT INTO iyx_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ka mwaana a we wu, bu amati ku ufuhusu busini ba we itwaari na bapuupu, we wamudusili mukolo a ngoombo wa too!” ");
INSERT INTO iyx_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Taayi aleeli kwaa nde: “Mwaana a me, we li na me taanga dioosi, bioosi bi ndi na bio bia we. ");
INSERT INTO iyx_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ka diafwaana usa mukuungi na uyaanga mu ndaa ti mukee a we wu beeri maakwa maasiimbuu, nde aba adiimbili ka maasoluu!”» ");
INSERT INTO iyx_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yiisu aleeli ka kwaa miyii mia nde: «Muutu mosi wa isini ali na mukebi a busini ba nde. Baata bamuleeli: “mukebi a we li mu usa busini ba we pfunu.” ");
INSERT INTO iyx_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Mukuutu wuu ati mukebi a busini ba nde mbila na wamuleeli: “Ima me ndi mu uyuu mu we? Leele me buni we ubaakebe busini ba me, mu ndaa ti we a ubwaba mukebi a busini ba me pe.” ");
INSERT INTO iyx_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Mukebi a busini atsimi kutso mutimi a nde: “Ima nisa, bu pfumu a me akaamaasa me mu kebili a busini ba nde? Me a ndi na mifuri pe mu usala matsiee, na ndi na tsionyi mu usa tsoo. ");
INSERT INTO iyx_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Me Nziaambi buni nisa paa baata bayaka me mu manzo ma bo, nha bakaamaasa me mu isala.” ");
INSERT INTO iyx_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Boosi ba bakoti mayaama kwaa pfumu a nde, nde wabatiri mbila mosi na mosi. Nde aleeli kwaa wa tsiomi: “yaama la kwe we akoti kwaa pfumu a me?” ");
INSERT INTO iyx_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ngaa yaama avutili: “minguungu kama mia maari ma olive.” Mukebi a busini aleeli kwaa nde: “holo mukaanda a we, diaala mawasa sonuu maku mataana.” ");
INSERT INTO iyx_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tumake nde aleeli kwaa waduku: “Ka, we yaama la kwe akoti?” Muutu wuu ni avutili: “Masaaka kama ma mbutu dia bele.” Mukebi a busini aleeli kwaa nde: “Holo mukaanda a we, sonuu maku pwoombo (80).” ");
INSERT INTO iyx_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Pfumu akimii mu nzilii a mukebi a busini wu mubi, mundaa ti nde asiali mu mayele. Ka, baata ba mu taanga di bavulu baana ba liyalila mayele.» ");
INSERT INTO iyx_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yiisu abwileele: «me nadileele: disalila busini bahele a libweeye mu ubaa banduu paa bu busini bukaawa, banduu baa sabadiyaka mu manzo ma bilimi na bilimi. ");
INSERT INTO iyx_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Wa hama mu bi bikee, ahama ka mu bi binene, wahele a libweeye mu bi bikee, ahele ka libweeye mu bi binene. ");
INSERT INTO iyx_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ni mu buu, so diheli uhama mu busini bahele a libweeye, na kaasa ilimbisi mu beni mu uha beni busini ba ngwanya? ");
INSERT INTO iyx_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na so dihele uhama mu bia bangani, na kaaha beni bia beni? ");
INSERT INTO iyx_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","A uli na musiali pe wu utuu usalila bapfumu boolo. Ka nde sa abele wu mumosi na utoono wu mukimi, so a buu pe, nde sa ayukunu na wu mumosi na ubele wu mukimi. Beni a dituu usalila Nziaambi na mboongo pe.» ");
INSERT INTO iyx_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Bafarisi ba bali batoono mboongo bu bayuyi mandaa maa moosi, basiiri Yiisu saa. ");
INSERT INTO iyx_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ka Yiisu aleeli kwaa bo: «Beni dibaalaa nha kulu a baata ti beni ni bangaa libweeye, ka Nziaambi ayaaba mitimi mia beni, ka bili bianaangama nha misi mia baata, ni bi Nziaambi ali mu umono ingaanzi. ");
INSERT INTO iyx_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mikele na mibili miadiingi natee mu taanga dia Yowani. Umatuu mu taanga dii, bali mu uyaabisa ndaa yimbwe ya Ipfumu kia Nziaambi, na pasi muutu li mu usa mifuri mu ukoto mu kio. ");
INSERT INTO iyx_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Bunu yavulu uleenge kwaa yulu na tsi mu ulabuu, ka isonii so imosi kiavulu bukee mu mikele a yilabuu pe. ");
INSERT INTO iyx_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Pasi wu ubisi mukari a nde na kweeli mukimi, nde soongi, na pasi wu ukweele mukaasa wu mulumi a nde abisi, nde soongi ka.» ");
INSERT INTO iyx_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yiisu abwileele: «Mwali muutu wa isini wakilwaata matsaanda ma mabwe na ma tala, nde akisa mikuungi pasi iluumbu. ");
INSERT INTO iyx_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ka kwali ka muwele mosi, kuumbu a nde Laazaro, wakiyala nha munywa a nzo a baala la isini, nde ali na maputu nyutu yoosi. ");
INSERT INTO iyx_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nde ali na nzala a udia biakibwa nha tsini a meese ma isini. Ka bunu, bambwa bakiyaleete maputu ma nde. ");
INSERT INTO iyx_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Muwele bu akwi, batumu ba Nziaambi bamubiti kwaa Abraami. Isini ka bu akwi, bamudii. ");
INSERT INTO iyx_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ku tsi a babakwa, muutu wa isini bu akimono pasi, asiimbili miisi mia nde, amoni ku la, Abraami na Laazaro nha peembi a nde. ");
INSERT INTO iyx_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nde aloyi: “Taata Abraami, kwiilili me ngebe, tsinduu Laazaro alooso toso a muleembi a nde mu maamba paa aboloso lilimi la me, ka ndi mu umono pasi dialaa kutso mbaa yi.” ");
INSERT INTO iyx_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ka Abraami wamuvutili: “Mwaana a me, libili moonyi ti we abaa busini nha we ali musii, ka Laazaro abayi mapasi. Mu taanga di, nhaa na nha bali mu uboondo nde, ka we li mu umono pasi. ");
INSERT INTO iyx_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nha yulu a maa, nha kati a bisi a beni ili na mbeenge yi inene, paa babutoono umatuu kuni mu uyiri kwaa beni bakoono, na beni kuu dikoono uyira kwaa bisi kuni.” ");
INSERT INTO iyx_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Isini aleeli: “Taata, ka me niloombo kwaa we mu utsinduu Laazaro ku nzo a taayi a me, ");
INSERT INTO iyx_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ka ndi na baana ba nguu bataana ba babaala. Ayata bo imbaangi bubwe, paa bo ka banyaala uyiri ku mbuu ya pasi yi.” ");
INSERT INTO iyx_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ka Abraami aleeli: “Bo bali na Mooso na mibili, bo bafwaana mu uyuu bo.” ");
INSERT INTO iyx_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Isini aleeli: “Ngori taata Abraami, ka so muutu mosi wu mati ku tsi ya babakwa yeni kwaa bo, sabakiingili mayele.” ");
INSERT INTO iyx_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ka Abraami wamuvutili: “So a bayuyi Mooso na mibili pe, a butuu usa imiini pe, so muutu simbii mu babakwa.”» ");
INSERT INTO iyx_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yiisu aleeli kwaa miyii mia nde: «Mabaka a mutuu uhele pe; ka ngebe kwaa wu ukubusu mo! ");
INSERT INTO iyx_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Bubwe bakutulu muutu wuu manya li linene mu kiingi na bamudumunu mu mubu, usa nde buu yavulu bubwe mu ndaa ti a ayabwisi mu masumu so ndila mosi mu bangebe ba. ");
INSERT INTO iyx_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Diyele! So mwaana a nguu a we si masumu, wamusieembe, so nde kiingili mayele, wamusa kolokolo. ");
INSERT INTO iyx_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","So nde si masumu mbala tsaamba mu iluumbu, ka nde yiri kwaa we mbala tsaamba na nde leeli: “Me kiingili mayele”; Wamusa kolokolo.» ");
INSERT INTO iyx_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Batumu baleeli kwaa pfumu: «Bweese bisi imiini.» ");
INSERT INTO iyx_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Pfumu avutili: «So diali na imiini weti libutu la booyi, keni beni utuu uleele kwaa muti wu: Tapuu na yamene mu mubu; nde a keni utumumu beni.» ");
INSERT INTO iyx_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Mu beni boosi na li na musiali wu ubaasala matsiee so wu ubaakebe biboori, bu nde umata ku matsiee sa aleele kwaa nde: “Yoo mawasa diaala nha meese.” ");
INSERT INTO iyx_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ka nde sa aleele kwaa musiali a nde: “Laamba me bi nidia, sobo bikutu suusu me biloo me ndia na me nywa. Tumake we ka sa dia na unywa.” ");
INSERT INTO iyx_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ka nde a ali na tsata a uvutulu matoondo kwaa musiali bu ayilii mi nde wamutumi pe! ");
INSERT INTO iyx_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Pili mosi, beni ka, bu diyiluu moosi ma batumu beni, dileele: Bisi ni basiali bahele a ndutu: “dimaayiluu mi diafwaana uyiluu.”» ");
INSERT INTO iyx_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Bu Yiisu ali ayene ku Yeruselemi, nde alabii nha kati a Samaria na Ngalili. ");
INSERT INTO iyx_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Bu nde akoti ku bula bu mosi, kuumi la babaala bangaa bwaari bamubwaani, bo batemini nha lala. ");
INSERT INTO iyx_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Baloyi, baleeli: «Yiisu, muyiisi, kwiilili bisi ngebe!» ");
INSERT INTO iyx_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Bu nde amoni bo, aleeli: «Yenani diyamonuu kwaa bangaanga ba Nziaambi.» Bu bakiyene, bo babeelii. ");
INSERT INTO iyx_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ka ndila mosi mu bo bu amoni ti nde maabeeluu, avutii, akiinzi Nziaambi mu ndaa yinene; ");
INSERT INTO iyx_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","nde atsukini busu mu tsi nha miili mia Yiisu, na avutili matoondo kwaa nde. Nde ali musi Samaria. ");
INSERT INTO iyx_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yiisu aleeli: «Bo a kuumi pe babeeluu? Ka ba wa kuni bali? ");
INSERT INTO iyx_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Wo! Ndili a mweenyi wu yiri avutuu mu uvutulu matoondo kwaa Nziaambi?» ");
INSERT INTO iyx_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tumake, Yiisu aleeli kwaa nde: «temene yene; imiini kia we ivuuyisi we.» ");
INSERT INTO iyx_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Bafarisi bafuuli Yiisu mu uyaaba ki taanga Ipfumu kia Nziaambi yikaayira, nde avutili kwaa bo: «Ipfumu kia Nziaambi a ili mu uyiri weti iloo ki dimono mu misi pe. ");
INSERT INTO iyx_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","A buleele pe: “Kio nha ili”, so “Kio kunaa ili!” Ka mono Ipfumu kia Nziaambi yili nha kati a beni.» ");
INSERT INTO iyx_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nde aleeli kwaa miyii: «Taanga dikaayira beni sadiba na nzala a umono Mwaana a muutu so mu ndila iluumbu imosi, ka a dimono nde pe. ");
INSERT INTO iyx_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Sa baleele kwaa beni: “Nde kunaa ali!” so “nde nha ali!” A diyene kuu pe, a didumu matiini kuu pe. ");
INSERT INTO iyx_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ka mbii bu nzieri ubaasiereme mu uyalisa yulu loosi, ni buu, bukaaba Mwaana a muutu mu iluumbu kia nde. ");
INSERT INTO iyx_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ka nde afwaana ukwamono pasi dialaa na sa babisi nde kwaa baata ba kubu yi. ");
INSERT INTO iyx_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Miayilimi mu taanga dia Nowa, sa miyilimi ka mu biluumbu bia Mwaana a muutu. ");
INSERT INTO iyx_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Baata bakidia na unywa, Bakaasa na babaala bakikweele na bakikweelise natee mu iluumbu kia koti Nowa mu nzaasa, nyaamba a maamba yayiri, yafuusi bioosi. ");
INSERT INTO iyx_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Sa iba mbii bwali mu taanga dia Loti: Baata bakidia, bakinywa, bakisuumbu, bakiyaluu, bakikunu, bakituungu; ");
INSERT INTO iyx_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ka mu iluumbi kiapali Loti mu ngaanda a Sodomo mbaa na mamanya ma mbaa bianoyi, biafuusi boosi. ");
INSERT INTO iyx_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ni buu bukaaba mu iluumbu kikaamonuu mwaana a muutu. ");
INSERT INTO iyx_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Mu iluumbu kii, wukaaba ku yulu a siaangi a nyaala usutuu mu uyaholo bisii bia nde mu nzo. Na wu kaba ku matsiee anyaala uvutuu ku nzo. ");
INSERT INTO iyx_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Dilibili moonyi mu mukari a Loti. ");
INSERT INTO iyx_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Wu usaa uvuusu idiingi kia nde, sa adiimbisi kio, na wu udiimbisi idiingi kia nde, sa avuusu kio. ");
INSERT INTO iyx_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Me nadileele: Butsuu baa, mu baata boolo ba bala nha yulu a mbuu mosi, mosi sa baholo, na sa basiisi wunu. ");
INSERT INTO iyx_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Mu Bakaasa boolo ba bunyii mayaa nha mbuu mosi, mosi sa baholo, wu mumosi sa basiisi. ");
INSERT INTO iyx_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Mu Babaala boolo ba busala nha tsiee mosi, mosi sa baholo, wu mumosi sa basiisi.» ");
INSERT INTO iyx_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Miyii miafuulu kwaa nde: «Pfumu, kuni maa makaayilimi?» Nde aleeli kwaa bo: «Ku kukaaba mvuumbi, ni kuu ku kaakukunu mileri.» ");
INSERT INTO iyx_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yiisu ati bo tsaba, mu umweese ti bo bobafwaana ukuundu taanga dioosi, na uhele ukoono. ");
INSERT INTO iyx_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nde aleeli: «Mu ngaanda mosi mwali na mufuundisi wali a hele ubatili Nziaambi boomo, na muutu ukiinzi pe. ");
INSERT INTO iyx_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mwali na mukwiili ka mu ngaanda yii wakiyaleele kwaa nde: “biingisi me nha kulu a mutaata a me.” ");
INSERT INTO iyx_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","«Mu taanga dialaa mufuundisi a atooni pe. Ka nde aleeli ku kutso mutimi a nde: “Me nayaaba ti me ndi Nziaambi boomo ubatila pe na muutu ukiinzi pe. ");
INSERT INTO iyx_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ka, mundaa ti mukwiili wu li ukwaamisa me, me sa biingisi nde, paa nde anyaala uyakoloso me mutswe nha na ukwaamisa me.” ");
INSERT INTO iyx_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","«Pfumu abwileele: Diyuu maleeli mufuundisi wa hele a libweeye. ");
INSERT INTO iyx_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ka Nziaambi a abiingisi pe baba nde ba asoolo bali mu uloo kwaa nde nyanga na butsuu? Nde sa adiingi mu uyabaasila bo? ");
INSERT INTO iyx_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Me ni leele kwaa beni: Nde sa abiingisi bo mawasa. Ka Mwaana a muutu bu akaayira, sa asololo ba ngaa imiini nha tsi?» ");
INSERT INTO iyx_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yiisu abwita tsaba yi kwaa baata ba bakitsimi ti bo ni balibweeye, na bakikeembele ba bamosi: ");
INSERT INTO iyx_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Baata boolo bayeni ku nzo a Nziaambi mu ukuundu, mosi ali mufarisi, na wu mukimi ali mutoli a limaanda. ");
INSERT INTO iyx_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mufarisi atemini, akuundi kutso mutimi a nde: “O Nziaambi a me, me nitoono kwaa we mu ndaa ti me a ndi weti baata ba bamosi pe, bo ni bataani, bahele a libweeye, basoongi. Na a ndi pe ka weti mutoli a limaanda wu. ");
INSERT INTO iyx_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Me nibaadii mutuutu mbala dioolo mu limiingi, nibaaha ikuku kia kuumi-kuumi mu bioosi bi nibaabaa.” ");
INSERT INTO iyx_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ka mutoli a limaanda atemini ku la, a atuuyi so usiimbili miisi ku yula pe, ka anaayi mioo nha butulu ba nde, aleeli: Nziaambi, kwiilili me ngebe, me ni ngaa masumu. ");
INSERT INTO iyx_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Me nadileeli: Mutoli a limaanda bu uyene ku nzo a nde, amaakwamonuu walibweeye nha kulu a Nziaambi, ka a Mufarisi wu pe. Mundaa ti, wu ubaanaanguu, sa bakululu nde, ka wu ukuluu, sa banaangila nde.» ");
INSERT INTO iyx_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Baata babeyi baana ba bikenyi kwaa Yiisu paa nde anaa bo mioo, miyii mia nde bu miamoni buu, miasieembi bo. ");
INSERT INTO iyx_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ka Yiisu ati bo mbila, aleeli: «Dinyaala bibabaana biyiri kwaa me, a dilii bo pe, mu ndaa ti Ipfumu kia Nziaambi ni kia ba bali weti bo. ");
INSERT INTO iyx_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ya ngwanya, me nadileele: Pasi wu uhele uyaka Ipfumu kia Nziaambi weti imwamwaana, a akoto kio so hoolo pe.» ");
INSERT INTO iyx_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mukuutu mosi afuuli Yiisu: «Muyiisi wu mubwe, ima me nafwaana usa paa me tolo mukobo wa moonyi wa bilimi na bilimi?» ");
INSERT INTO iyx_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yiisu aleeli kwaa nde: «Mu ima we li mu uta me “wu mubwe”? A uli na muutu wu mubwe pe, umaasa ndila Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","We ayaaba mikele: A soongo pe, a dusu pe, a yibi pe, a ta imbaangi kia pia mu muutu pe, kiinzi taayi a we na nguu a we.» ");
INSERT INTO iyx_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nde avutili: «Mikele mii mioosi ndi mu uduku mio umata bufuru ba me.» ");
INSERT INTO iyx_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yiisu bu ayuyi nde, aleeli kwaa nde: «Iloo imosi ikimi ili mu uhele we. Yaluu bioosi bi we li na bio, kaba bio kwaa bawele, na we sa baa busini mu mayula. Nha mbisi yiri na duku me.» ");
INSERT INTO iyx_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ka bu muutu wu ayuyi buu, nde abayi ngebe dialaa mu ndaa ti nde ali ngo isini. ");
INSERT INTO iyx_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yiisu bu amoni ti nde ali na ngebe, aleeli: «pasi dialaa kwaa ba bali na busini mu ukoto mu Ipfumu kia Nziaambi! ");
INSERT INTO iyx_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Uli na pasi kwaa puundi wuli na kuuki mu uyoo mu wuru la tsioongi yibubaaloondo matsaanda, ka yabwavulu pasi kwaa isini mu ukoto mu Ipfumu kia Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ba baliayuu nde baleeli: «Ka, na utuu uvuu?» ");
INSERT INTO iyx_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yiisu avutili: «Mandaa ma baata bukoono, Nziaambi mo ukoono pe.» ");
INSERT INTO iyx_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Peetero aleeli: «Mono, bisi diasiisi bidiali na bio mu uduku we.» ");
INSERT INTO iyx_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Nde aleeli kwaa bo: «Ngwanya, me nadileeli, mbii ti muutu siisi nzo nde, so mukari a nde, so baana ba nguu ba nde, so bibuti bia nde, so baana ba nde mu ndaa Ipfumu kia Nziaambi, ");
INSERT INTO iyx_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nde sa ayaka kwavululu mu taanga di. Na nde sa ayaka moonyi wa bilimi na bilimi mu taanga dikaayiri.» ");
INSERT INTO iyx_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yiisu atakii na miyii mia nde kuumi na mioolo nha peembi, aleeli kwaa bo: «Diyuu, ku Yeruselemi diyenani, moosi masonii mibili mu Mwaana a muutu sa mayilimi. ");
INSERT INTO iyx_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Mundaa ti sa bayeelele nde kwaa bangooyi; sa basa nde saa, na utuu nde, na utswiili nde mate; ");
INSERT INTO iyx_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Na bu bumana nde utete bo sa badusu nde. Ka iluumbu kia bitata, nde sa asiimbuu mu babakwa.» ");
INSERT INTO iyx_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ka miyii mia nde a miayaabi ndaa so mosi mu mandaa maa pe; tsuyili yii yali yasweeme kwaa bo. A bayaabi tsutulu a mandaa ma Yiisu aleeli pe. ");
INSERT INTO iyx_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Bu Yiisu akibesine na Yeriko, muutu wakwa miisi adiaali nha mukoo a kuulu, mu ubaaloombo libaasili. ");
INSERT INTO iyx_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nde ayuyi koongi yakilabuu, afuuli: «Kii ima?» ");
INSERT INTO iyx_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bamuyaabisi: «Yiisu, musi Nazareti, li mu uyoo.» ");
INSERT INTO iyx_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ni mu buu nde aloyi: «Yiisu, Mwaana a Daavidi, kwiilili me ngebe.» ");
INSERT INTO iyx_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ba batswaamini ku kulu a nde bamusieembi paa nde awuru, ka nde akibwaloo mu mifuri: «Mwaana a Daavidi, kwiilili me ngebe.» ");
INSERT INTO iyx_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yiisu atsikini, atumi ti dibee nde kwaa nde. Bu nde ayiri asweese, Yiisu afuuli nde: ");
INSERT INTO iyx_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Ima we atoono me sa mu we?» Nde avutili: «Pfumu, me tooni ubwamono.» ");
INSERT INTO iyx_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yiisu aleeli kwaa nde: «Bwamono wa we. Imiini kia we ivuuyisi we!» ");
INSERT INTO iyx_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nhaa-na-tsi nde abwibaanduu umono, na nde aduki Yiisu, abili Nziaambi. Baata boosi bu bamoni buu, bakiinzi Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yiisu akoti ku Yeriko, na nde atabi ngaanda. ");
INSERT INTO iyx_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ali na baala li mosi kuumbu Zakaayi. Nde ali mukuutu a batoli balimaanda, nde ali isini. ");
INSERT INTO iyx_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nde akisaa umono, Yiisu ni na, ka nde akooni mu ndaa a koongi, na nde ali mukusi. ");
INSERT INTO iyx_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Adumi tiini ku kulu, ahaati mu muti wa kuumbu sikomore paa amono Yiisu nha nde uyoo mu kuulu yii. ");
INSERT INTO iyx_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yiisu bu atoori nha mbuu yii, asiimbili misi, aleeli kwaa nde: «Zakaayi, sutuu mawasa, me na nafwaana ubaa mbuu mu nzo a we lolo.» ");
INSERT INTO iyx_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Mu kinyi yoosi, Zakaayi asutii mawasa mu uyaka nde. ");
INSERT INTO iyx_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bu bamoni buu, bo boosi banhunhinyi, baleeli: «Nde maayakoto mu nzo a ngaa masumu!» ");
INSERT INTO iyx_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakaayi atemini, aleeli kwaa Nde: «Pfumu, mono, ibari kia busini ba me niha kwaa bawele, mbii ti me napatili wosi isii kwaa muutu, me sa vutulu nde kio mbala na.» ");
INSERT INTO iyx_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yiisu aleeli kwaa nde: «lolo liyobolo limaakoto mu nzo yi, mundaa ti weka mwaana a Abraami. ");
INSERT INTO iyx_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mu ndaa, Mwaana a muutu ayiri mu usaa na uyobolo ba badiimbili.» ");
INSERT INTO iyx_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Bu bayuyi buu, Yiisu abwita tsaba kimi, mundaa ti nde ali bele na Yeruselemi, na baliatsimi ti Ipfumu kia Nziaambi sa imonuu nhaa-na-tsi. ");
INSERT INTO iyx_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nde aleeli mbii bu: «Muutu wa nzo ya likiinzi ayeni ku tsi ya la, ku uholo ipfumu na uyiri avutuu. ");
INSERT INTO iyx_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nde ati basiali ba nde kuumi mbila, ahi bo mukuti kuumi mia woolo, na wabaleeli: “Dita kaari natee bu me niyiri avutuu.” ");
INSERT INTO iyx_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ka baata ba ku tsi a nde bakibele nde, batsindii batumu nha mbisi a nde uyaabisa: “A diatoono muutu wu aba mutini a bisi pe.” ");
INSERT INTO iyx_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Nha mbisi a ubiaalisa nde mu uba mutini, nde avutii, atumi, bata basiali ba nde mbila, ba nde ahi mikuti mia woolo, mu uyaaba ki ndaanda bo bamaabaa. ");
INSERT INTO iyx_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Wa tsiomi ayiri, aleeli: “Pfumu, me mbayi ndaanda a mikuti mia woolo kuumi nha yulu a mukutu a woolo a we.” ");
INSERT INTO iyx_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Pfumu wamuleeli: “Ngo bubwe, we musiali walibweeye, bu we hami mu biavulu bukee, me suusu we mukuutu a mangaanda kuumi.” ");
INSERT INTO iyx_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Wa boolo ayiri, aleeli: “Pfumu, me mbayi ndaanda a mikuti mitaana mia woolo nha yula a mukuti a we.” ");
INSERT INTO iyx_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Pfumu aleeli kwaa wuu ka: “We ka, me suusi mukuutu a mangaanda mataana.” ");
INSERT INTO iyx_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Musiali mukimi ayiri, aleeli: “Pfumu, mono mukuti a woolo a we, wu naswee kutso tsaanda. ");
INSERT INTO iyx_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Me aba na boomo ba we, bu we li muutu wa ibaala, ubaa holo ki we ahele usuusu, na ubaakukuu ki we ahele ukunu.” ");
INSERT INTO iyx_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Pfumu aleeli kwaa nde: “musiali wu mubi, mu mi we maatsuu me kaafuundusu we. We aba ayaaba ti me ni muutu wa ibaala, nibaaholo ki nahele usuusu, nibaakukuu ki nahele ukunu. ");
INSERT INTO iyx_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Mu ima we ahele usuusu mboongo dia me ku nzo a mboongo? Bu nziri, me keni uholo dio na ndaanda.” ");
INSERT INTO iyx_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Na nde aleeli kwaa bali nhaa: “Dipatila nde mukuti a woolo, diha nde kwaa uli na mikuti mia woolo kuumi.” ");
INSERT INTO iyx_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ka bo baleeli kwaa nde: “Pfumu, nde li na mikuti mia woolo kuumi!” ");
INSERT INTO iyx_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Me nadileeli: “Sa ba ha kwaa uli na iloo, ka kwaa hele a iloo, sa ba patila nde so ki ali na kio. ");
INSERT INTO iyx_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ka kwaa mitaata mia me mia heli utoono ti me ba mutini a bo, dibee mio nha, dikese mio makiingi nha kulu a me.”» ");
INSERT INTO iyx_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Bu nde amani na utsuu, Yiisu atswaamini ku kulu a koongi, na ayeni ku Yeruselemi. ");
INSERT INTO iyx_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Bu nde abesine na Betefange na Betania nha peembi a mulaanda wu bubaata mulaanda a Olive, nde atsindii mioolo mu miyii mia nde. ");
INSERT INTO iyx_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Aleeli: «Yenani ku bula ba nha kulu a beni; bu dikoto mu bo, sa disololo mwaana a puundi bakutu uli muutu keni a adiaala pe nha yulu a nde; dinyangila nde na dibee nde nha. ");
INSERT INTO iyx_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","So muutu fuuli beni: “Mu ima dinyangila nde?” Dileele kwaa nde: “Pfumu li na nzala a nde.”» ");
INSERT INTO iyx_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ba batsindii bayeni, na basolili mioosi mbii bu baleeli bo. ");
INSERT INTO iyx_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bu bakinyingila mwaana a puundi ba ngaa nde baleeli kwaa bo: «Mu ima dili mu unyangila mwaana a puundi wu?» ");
INSERT INTO iyx_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bo bavutuli: «Pfumu li na nzala a nde.» ");
INSERT INTO iyx_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bo babeyi nde kwaa Yiisu; basuusi bikutu bia bo nha yulu a mwaana a puundi, na banayi Yiisu nha yula. ");
INSERT INTO iyx_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Bu Yiisu akiyene, baata bakiyala bikutu bia bo mu kuulu. ");
INSERT INTO iyx_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Bu nde akibesine na Yeruselemi mu kuulu ya usutuu mulaanda a Olive, koongi a miyii miayaangi na miakiinzi Nziaambi mu ndaa yinene, mu bimaanga bi bo bamoni. ");
INSERT INTO iyx_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Baleeli: «Nziaambi asieme mutini uli mu uyiri mu kuumbu a Pfumu! Iyeenge mu yula na buzitu mu kati a mayula!» ");
INSERT INTO iyx_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Babamosi mu bafarisi nha kati a koongi baleeli kwaa nde: «Muyiisi, sieembe miyii mia we mi wuru kele.» ");
INSERT INTO iyx_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nde avutili kwaa bo: «Me na dileeli, so bo baa-na-ba bawuri, ni mamanya samaloo.» ");
INSERT INTO iyx_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Bu Yiisu atoori nha peembi ngaanda a Yeruselemi, amoni yo, alili mu ndaa yo, ");
INSERT INTO iyx_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","aleeli: «So weka ali ayaaba mu lolo li buni we usololo iyeenge! Ka mu taanga di, kio imaasweeme kwaa we! ");
INSERT INTO iyx_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ka biluumbu bikaayira kwaa we, bili ti mitaata mia we, sa midiengelele we, sa midiaalila we na uswetese we mu mapeembi moosi. ");
INSERT INTO iyx_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Sa bakosolo we na baana ba we, na a busiisi manya nha yulu a manya mu we pe, mu ndaa ti we ayaabi taanga di Nziaambi ayiri mu ukuulu we pe.» ");
INSERT INTO iyx_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yiisu akoti mu nzo a Nziaambi, abaandii ubingi bakiyaluu, ");
INSERT INTO iyx_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","aleeli kwaa bo: «Basonuu: “Nzo a me sa yiba nzo a likuundu.” Ka beni dimaasa yo mbuu ya tsweeyi ya miyibi!» ");
INSERT INTO iyx_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yiisu akiyiisi pasi iluumbu mu nzo a Nziaambi. Ka banguu ba bangaanga ba Nziaambi, na bayiisi ba mikele, na bakuutu ba baata, basiayi udusu nde. ");
INSERT INTO iyx_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ka bo a bayaabi pe buni bafwaana usa, mu ndaa ti baata boosi bakiduku nde mu uyuu mandaa ma nde. ");
INSERT INTO iyx_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Iluumbu imosi nha kati a biluumbu bii, Yiisu akiyiisi baata mu nzo a Nziaambi na uyaabisa ndaa yimbwe. Banguu ba bangaanga ba Nziaambi na bayiisi ba mikele, na bakuutu ba baata bayiri, ");
INSERT INTO iyx_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","na ba leeli kwaa nde: «Leele bisi mu ki lituu we li musa mandaa ma! Na aha we lituu lii?» ");
INSERT INTO iyx_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nde avutili, kwaa bo: «Me ka nifuulu beni nduru, vutulani me: ");
INSERT INTO iyx_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Lituu la ubootuu baata, na ahi lo kwaa Yowani? Nziaambi oo baata?» ");
INSERT INTO iyx_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ka bo balelisini: «So divutili ti Nziaambi ahi nde lo, nde sa aleele: “mu ima beni diahele usa nde imiini?” ");
INSERT INTO iyx_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","So divutili ti baata ba muhi nde lo, koongi yoosi sa yidusu bisi mu mamanya, mu ndaa ti boosi basi imiini ti Yowani ali mubili.» ");
INSERT INTO iyx_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ka bavutuli ti: «bisi a diayaaba pe na ahi nde lituu mu ubootuu.» ");
INSERT INTO iyx_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ka Yiisu wabaleeli: «me ka a nileele beni pe mu ki lituu me ndi mu usa mandaa ma.» ");
INSERT INTO iyx_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tumake, Yiisu ati tsaba yi kwaa koongi: «Muutu mosi akuni nguundu a viinyi, asiisi yo nha mioo mia basiali ba viinyi, na ayeni ku midieenge mu taanga dialaa. ");
INSERT INTO iyx_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Taanga dia tolili bu diatoori, ngaa nguundu wuu atsindii musiali mosi kwaa basiali ba viinyi, paa baha nde ikuku kia mbutu dia viinyi. Ka basiali ba viinyi bamuteti na bamuvutili mioo na mioo. ");
INSERT INTO iyx_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nde abwitsinduu musiali mukimi, bo bamuteti na bamutuyi, tumake bamuvutili mioo na mioo. ");
INSERT INTO iyx_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nde abwitsinduu musiali wa mutata, bo bamunemisi na bamupalisi ku mbari a nguundu. ");
INSERT INTO iyx_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ngaa nguundu a viinyi aleeli: “me buni nisa? Me sa tsinduu mwaana a me wa litoono, hele a pe sa bamukiinzi.” ");
INSERT INTO iyx_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ka basiali ba viinyi bu bamumoni, balelisini: “Wuunawu ni mutoli a mukobo; diamudusu paa ti mukobo aba ka wa bisi.” ");
INSERT INTO iyx_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Na bo bamubingisi ku mbari a nguundu a viinyi, bamudusi. Buni ngaa nguundu a viinyi akaayiluu yiluu mu bo? ");
INSERT INTO iyx_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nde sa ayiri nde makulu, sa adusu basiali ba viinyi, na sa aha nguundu a viinyi kwaa bakimi.» Bu bayuyi mandaa maa, bakimii, baloyi: «Ngori a uba buu pe.» ");
INSERT INTO iyx_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ka Yiisu wabatali isooso, na aleeli: «Tsutulu a mandaa mabasonuu ma, ma? “Ni manya li bameengili, limaakituu manya la ibwa.” ");
INSERT INTO iyx_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Pasi nde wu ubwa nha yulu a manya li, nde sa akosuu; na pasi wu lo libwiilili, lo sa likosolo nde.» ");
INSERT INTO iyx_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Bayiisi ba mikele na banguu ba bangaanga ba Nziaambi basiayi mu ukaanga Yiisu mu taanga dii, ka babayi boomo ba baata. Bo bayaabi ti, mu ndaa bo nde ati tsaba yii. ");
INSERT INTO iyx_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Bamuketi, batsindii baata bafuti uba balibweeye, mu usaa toono yi butuu ukaanga nde mu mimipala mu munywa a nde, paa bamuyeelele kwaa ipfumu kia tsi na kwaa mutini. ");
INSERT INTO iyx_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Baata baa bamufuuli: «Muyiisi, diayaaba ti we ubaatsuu na ubaayiisi bubwe; we a li na ipengenge pe, ka we li mu uyiisi kuulu a Nziaambi mu ngwanya. ");
INSERT INTO iyx_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ka leele a ti bisi, bisi dili na muswa wa ufutu limaanda kwaa Kayisari oo ngori?» ");
INSERT INTO iyx_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ka Yiisu ayaabi ti mweete bamulebii, wabaleeli: «Dimweese me mukuti a mboongo mosi. ");
INSERT INTO iyx_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Kiinzi na kuumbu bili mu mukuti wu bia na bili?» Bo bavutuli: «Bia Kayisari.» ");
INSERT INTO iyx_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ka Yiisu aleeli kwaa bo: «Divutulu kwaa Kayisari bia Kayisari na kwaa Nziaambi bia Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bo bakooni usololo toono mu ma akileele nha kulu a baata; Ka bo bakimii mu mvutu a nde, ba beeri na pii. ");
INSERT INTO iyx_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kaba la basaduki bakihamisa ti a muli na tsimbilili mu babakwa pe, bayiri mu ufuulu Yiisu: ");
INSERT INTO iyx_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Muyiisi, mono bu Mooso wadisonii: “So muutu li na mwaana a nguu, kwiiri na siisi mukari kwa hele a mwaana, mwaana a nguu a nde afwaana ukweele mukwiili mu uha baana kwaa wakwi.” ");
INSERT INTO iyx_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kwali baana ba nguu tsaamba. Wa tsiomi akweeli mukaasa, akwi na a abuti mwaana pe. ");
INSERT INTO iyx_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Wa boolo aholi mukwiili, ");
INSERT INTO iyx_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","na wa mutata ka aholi mukwiili. Boosi ba yili buu natee wa tsaamba, bo bakwi kwa hele a usiisi baana. ");
INSERT INTO iyx_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Nha tsieelele mukaasa ka akwi. ");
INSERT INTO iyx_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mu iluumbu kia tsimbilili a babakwa, mukaasa wuu mukari a na akaaba? Mu ndaa ti bo tsaamba bamukweeli!» ");
INSERT INTO iyx_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yiisu aleeli kwaa bo: «Nha tsini a toto nha, babaala na Bakaasa bali mu ukwelisine, na bali mu ukweelise. ");
INSERT INTO iyx_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ka ba bakaamonuu ba balibweeye mu usiimbuu mu babakwa na ukoto mu tsi yii, a bukweele pe. ");
INSERT INTO iyx_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bo a butuu ubwakwa pe; mu ndaa ti bo bafwaanina na batumu ba Nziaambi, na bali baana ba Nziaambi, bu busiimbuu mu babakwa. ");
INSERT INTO iyx_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mooso ayaabisi ti babakwa sa basiimbuu, mii ni mia yaabisi Mooso mu ndaa a muti waluli mbaa, bu nde ati Pfumu “Nziaambi a Abraami, Nziaambi a Isaki, na Nziaambi a Yaakobi.” ");
INSERT INTO iyx_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ka nde a ali pe Nziaambi a babakwa, ka nde Nziaambi a ba bali moonyi; ka mu nde boosi bali moonyi.» ");
INSERT INTO iyx_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ba bamosi mu bayiisi ba mikele bavutuli: «Muyiisi, we tsuyi bubwe.» ");
INSERT INTO iyx_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Na a babwituu ufuulu nde nduru so mosi pe. ");
INSERT INTO iyx_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yiisu wabaleeli: «Buni butuu uleele ti Kristo ni mwaana a Daavidi? ");
INSERT INTO iyx_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ka Daavidi nde makulu aleeli mu mukaanda wa Mikuunga: “Pfumu aleeli kwaa Pfumu a me: Diaala nha koo kia me kia babaala, ");
INSERT INTO iyx_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","natee bu me nisuusu mitaata mia we ku tsini a miili mia we.” ");
INSERT INTO iyx_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Daavidi li mu uta nde Pfumu, ka buni nde utuu uba mwaana a nde?» ");
INSERT INTO iyx_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Bu baata boosi bakiyuu nde, Yiisu aleeli kwaa miyii mia nde: ");
INSERT INTO iyx_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Disa mayele mu bayiisi ba mikele. Bo batoono udieenge mu miloopo mimila, batoono babii bo mu makooyi, na usoolo mambata matsiomi mu manzo ma makutunu ma Bayuudayo, na mu mikuungi. ");
INSERT INTO iyx_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bo bali mu upatila biabaa bakwiili, na mu nzala a umonuu bo bubaasa makuundu mamala. Ka pfuundisi a bo sa yiba yavulu mifuri.» ");
INSERT INTO iyx_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yiisu asiimbili miisi, amoni bisini biakilooso bungori ba bo mutso itungu kia bungori. ");
INSERT INTO iyx_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nde amoni ka mukwiili wa muwele aloosi mwaana mikuti mioolo. ");
INSERT INTO iyx_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ka nde aleeli: «Mu ngwanya me ni leeli kwa beni: Mukwiili wuunawu wa muwele ma haa kwa vulu boosi. ");
INSERT INTO iyx_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ka ba boosi ba hii bungori mu mboongo diahele a tsala mu busini ba bo, ka wuunawu mu buwele ba nde hii bioosi bi ali na bio.» ");
INSERT INTO iyx_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Bu ba bamosi bakitsuu mu ndaa nzo a Nziaambi, bo baleeli ti yo yali ngo bubwe na mamanya ma ba tungi yo, na bioosi bi bahi kwa Nziaambi biabweyisi yo. Yiisu aleeli: ");
INSERT INTO iyx_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Bi beni dili mu umono bi, mu biluumbu bikaayira, a mu saala manya nha yulu a manya pe; bioosi sa ba tsala.» ");
INSERT INTO iyx_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bamufuuli: «Muyiisi, ki taanga maa makaayira? Ki iliimbi ikaa mweese mandaa maa?» ");
INSERT INTO iyx_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yiisu avutili: «Dikele, a bafutu beni, ka balaa bakaayiri mu kuumbu a me na uleele: “Me ni Mesiya!” na: “Taanga dika bebele!” a diduku bo pe. ");
INSERT INTO iyx_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Bu dikaayuu bali mu utsuu mu midiingi na punga-pungu a diba na boomo pe, ka maa mafwaana ukwato, ka keni a manini pe.» ");
INSERT INTO iyx_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ka nde aleeli kwaa bo: «Ipfumu imosi sa idwaanisa ipfumu ikimi, na tsi mosi sa yidwaaanisa tsi kimi. ");
INSERT INTO iyx_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Toto sa diningini kwa mifuri, na mu mambuu malaa, sa muba bibeeri bia tsitsi na tsata; sa muba ka na mandaa ma tsitsi, na biliimbi bia kimikimi ku yula.» ");
INSERT INTO iyx_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«Ka tswami a maa moosi, sa bakaanga beni, sa bakwaamisa beni, sa bayeelele beni mu ufuundusu mu manzo ma makutunu a Bayuudayo, na sa badumunu beni mu perese. Sa babiti beni nha kulu a bapfumu ba tsi na mitini mu ndaa kuumbu a me. ");
INSERT INTO iyx_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Maa moosi sa mabiti beni mu uta imbaangi mu me. ");
INSERT INTO iyx_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Diyiluu uyaaba ti beni a diafwaana ukwatsimi mi dika vutulu pe. ");
INSERT INTO iyx_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ka me sa nadiha mandaa, na buyeri, na mitaata mia beni mioosi a mituu utungululu beni pe. ");
INSERT INTO iyx_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Bibuti bia beni, na baana ba nguu ba beni, banduu, na bambaayi ba beni ba bebele, sa ba yeelele beni, na sa badusu balayi mu beni. ");
INSERT INTO iyx_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Boosi sa babele beni mu ndaa kuumbu a me. ");
INSERT INTO iyx_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ka so linaanga limosi la mitswe mia beni a limatu pe. ");
INSERT INTO iyx_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mu mukonono a beni, beni sadivuusu miwuumu mia beni.» ");
INSERT INTO iyx_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Bu beni dikaamono mikaanga mia masodaare mia diengelele Yeruselemi, diyaaba ti mu taanga dii, tsialili a yo yika bebele. ");
INSERT INTO iyx_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mu taanga dii, bakaaba ku Yuuda, babata kutso milaanda, bakaaba kutso Yeruselemi, bapala, na bakaaba mu mala, banyaala ukoto mu ngaanda. ");
INSERT INTO iyx_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ka sa biba biluumbu bia pfuundisi, paa moosi mabasonuu mayilimi. ");
INSERT INTO iyx_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Aa kipila ngebe mu Bakaasa bakaaba na mayimi na ba bakaanywiisi mu biluumbu bii! Ka sa muba na pasi dialaa mu tsi, na kesi a Nziaambi sa yibwa nha yulu a baata ba. ");
INSERT INTO iyx_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sa badusu bo mu mukasa, sa babiti bo makori mu matsi ma bumweenyi, na Yeruselemi sa badiaata ku tsini a miili mia bangooyi, natee bu taanga dikaakuu.» ");
INSERT INTO iyx_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Sa muba na biliimbi mu nyanga, mu tsuungi, na mu bambwelele. Naha yulu a toto, matsi sa maluulu mu boomo balaa mu ndaa kele a mubu na mapo ma maamba: ");
INSERT INTO iyx_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","baata sa bakwa mu boomo mu ndaa utsimi mu mikaayira mu tsi. Ka tuu dia yula sa dinyingini. ");
INSERT INTO iyx_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ka sa bamono Mwaana a muutu li mu uyira nha yulu a matuti na lituu, na buzitu balaa. ");
INSERT INTO iyx_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Bu maa makaabaanduu uyilimi, diba likanda na diba na ibaala, mu ndaa ti kuuyili a beni yika bebele.» ");
INSERT INTO iyx_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yiisu abwita bo tsaba: «Dikengese muti wa mufiike na miti mini moosi. ");
INSERT INTO iyx_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Bu beni dimono makaya mabaandii uteete, diyaabi ti, maangala maka mu uwa na mvulu a tsiomi ka bebele. ");
INSERT INTO iyx_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Bumosi, beni ka, bu dika mono mandaa maa maka mu uyilimi, diyaaba ti Ipfumu kia Nziaambi yika bebele. ");
INSERT INTO iyx_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ngwanya, me ndeeli kwaa beni: Kubu yi a yilabuu pe tswaamina a mandaa ma moosi muyilimi. ");
INSERT INTO iyx_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yula na tsi sa bilabuu, ka mandaa ma me a mulabuu so holo pe.» ");
INSERT INTO iyx_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Disa mayele! Kele mitimi mia beni a mileme mu ndiilili na mu nywiilili a mala ya mifuri, na mu minioongo mia idiingi, paa ti iluumbu kii a iyabwiilili beni mu itsimbisini. ");
INSERT INTO iyx_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ka kio sa iyira weti siele, nha yulu a baata boosi bali nha yulu a toto. ");
INSERT INTO iyx_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Diba likanda na dikuundu mu taanga dioosi, paa dibaa mifuri mia ubiingi mu mioosi mikaayira, na mu utemene nha kulu a Mwaana a muutu.» ");
INSERT INTO iyx_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Mu nyanga, Yiisu akiyiisi mu nzo a Nziaambi. Ka tsitsii nde akipala mu ulabisa butsuu ku mulaanda wa kuumbu mulaanda Olive. ");
INSERT INTO iyx_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ngwaali a ngwaali, baata boosi bakiyene ku nzo a Nziaambi mu uyuu nde. ");
INSERT INTO iyx_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Mukuungi a mapa ma hele liviiri wu bubaata Paaka ali bebele. ");
INSERT INTO iyx_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Banguu ba bangaanga ba Nziaambi na bayiisi ba mikele basiayi buni budusu Yiisu, ka bo bali na boomo ba baata. ");
INSERT INTO iyx_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ka Saatina akoti mu Yuuda wu bubaata Isikarioti, wali mosi mu miyii kuumi na mioolo. ");
INSERT INTO iyx_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yuuda ayeni mu uyuhusunu na banguu ba bangaanga ba Nziaambi, na bakuutu ba bakebi ba nzo a Nziaambi, mu usaa kuulu yi nde uyeelele Yiisu kwaa bo. ");
INSERT INTO iyx_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bo bayaangi, na bayuhisini mu uha nde mboongo. ");
INSERT INTO iyx_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nde asiingi, na nde abaandii usaa taanga diafwaana mu uyeelele Yiisu kwaa bo kwahele a baata ba yaaba. ");
INSERT INTO iyx_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Iluumbu kia mukuungi a mapa mahele na lifunusu, ki bafwaana mu udusu baana ba mameme ma Paaka kiatoori. ");
INSERT INTO iyx_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yiisu atsindi Peetero na Yowani, wabaleeli: «Diyene diyiluu bisi biloo bia Paaka, paa di diaanani.» ");
INSERT INTO iyx_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bo bafuuli kwaa nde: «Kuni we tooni ti bisi diyiluu bio?» ");
INSERT INTO iyx_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nde avutili kwaa bo: «Diyuu: bu beni dika koto mu ngaanda, beni sa dibwaanina na muutu mosi wabiti lisaanga la maamba, diduku nde mu nzo yi nde akaayakoto ya koto, ");
INSERT INTO iyx_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","na dileele kwaa ngaa nzo: “Muyiisi leeli kwaa we: Mu ki itsuru kia nzo nidia biloo bia Paaka na miyii mia me?” ");
INSERT INTO iyx_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nde sa alaa beni itsuru ki inene ku etaze, ki babweeyise, ni kuu beni dika yiluu biloo bia Paaka.» ");
INSERT INTO iyx_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bo bayeni, bamoni mandaa moosi weti bu nde aleeli kwa bo, na bayilii biloo bia Paaka. ");
INSERT INTO iyx_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Taanga bu dia atoori, Yiisu adiaali nha meese, na batumu ba nde. ");
INSERT INTO iyx_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nde aleeli kwaa bo: «Me aba ngo nzala udia biloo bia Paaka bi na beni, tswaamina me nimono pasi. ");
INSERT INTO iyx_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ka me nileeli kwaa beni, me a nibwadia bio pe, natee bu tsutulu a ndaa yikaayilimi mu Ipfumu kia Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nde aholi mbasa, avutili matoondo, na aleeli: «Diholo yiinayi, na dikaba yo nha kati a beni; ");
INSERT INTO iyx_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ka me leeli kwaa beni, umata mu taanga di a nibwanywa viinyi pe natee Ipfumu kia Nziaambi iyira.» ");
INSERT INTO iyx_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tumake nde aholi lipa, bu amani uvutulu matoondo kwaa Nziaambi, nde abukili lo na ahi lo kwaa bo, na aleeli: «Yiinayi ni nyutu a me, yibahi mu beni. Diyiluu buu, mu ulibili moonyi mu me.» ");
INSERT INTO iyx_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nde asi bumosi mu mbasa, nha mbisi a udia aleeli: «Mbasa yiinayi ni lilasina lilinyatii, layilimi mu makila ma me, mamatsiaamii mu beni. ");
INSERT INTO iyx_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ka dimono, wu uyeelele me li nha meese ma, na me. ");
INSERT INTO iyx_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mwaana a muutu sa akwa, weti bu Nziaambi ayesini, ki pili a ngebe kwaa muutu wuu, wu uyeelele nde.» ");
INSERT INTO iyx_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Na bo babaandii ufulusunu mu uyaaba na nha kati a bo utuu uyiluu ndaa ya pili yi. ");
INSERT INTO iyx_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Paa diabwi nha kati a bo: «Na nha kati a bo utuu umonuu weti wavulu bunene.» ");
INSERT INTO iyx_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yiisu aleeli kwaa bo: «Mitini mia matsi mili na litumu loosi nha yulu a matsi ma bo, na babali na litumu nha yulu a matsi maa batoono ti baata bata bo “Bayilii a mamabwe.” ");
INSERT INTO iyx_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ka kwaa beni a buli buu pe. Ka, wa wavulu bunene nha kati a beni, aba weti wavulu bungebe, na wuu wu utumu afwaana uba weti musiali. ");
INSERT INTO iyx_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ka, na avulu mu bunene, wadiaala nha meese oo wuu uli mu usalila? A wa diaala nha meese pe? Ka bunu me ndi nha kati a beni weti musiali. ");
INSERT INTO iyx_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Beni ni badianambiti mu me, mu taanga dia mapasi ma me. ");
INSERT INTO iyx_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ni mu bu me heeri beni Ipfumu, mbii bu Taayi a me ahi me kio. ");
INSERT INTO iyx_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Me heeri beni kio, paa ti beni didia na dinywa nha meese ma me, mu Ipfumu kia me, na beni sa didiaala nha mambata ma ipfumu mu ufuundusu bifuumbu kuumi na bioolo bia Iseraeli.» ");
INSERT INTO iyx_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","«Simooni, Simooni! Yuu: Saatina aloombi litumu mu unyingisi beni boosi, weti bu bubaayengese looso. ");
INSERT INTO iyx_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ka me nakuundi mu we, paa ti imiini kia we a iyadiimbili; na we, bu kaakiingili mayele, hamisa baana ba nguu ba we.» ");
INSERT INTO iyx_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Peetero aleeli kwaa nde: «Pfumu, me nayilimi mu uyene na we, na mu perese na mu likwa.» ");
INSERT INTO iyx_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yiisu avutili kwaa nde: «Peetero, me leele kwa we, lolo li tswaamina tsutsu ukookolo, we sa tunu me mbala tata ti we ayaaba me pe.» ");
INSERT INTO iyx_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nde abwileele kwaa bo: «Bu me naditsindii beni kwahele a ipokolo kia mboongo, so kutu, so bikoori, ima kiaheli na beni?» Bo bavutuli: «A iloo pe.» ");
INSERT INTO iyx_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Nde aleeli kwaa bo: «Ka mu taanga di, wu li na ipokolo kia mboongo, aholo kio. Bumosi ka kwaa wuli na kutu, na wuu wahele na mukasa, ayaluu ikutu kia nde, mu usuumbu mukasa. ");
INSERT INTO iyx_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Me leeli kwaa beni, bwafwaana ti Mabasonuu mayilimi mu me: “Nde ka bataangi nha kati a baa bahele na mikele.” Ka, Mabasonuu mu me maka mu uyilimi.» ");
INSERT INTO iyx_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Bo baleeli: «Pfumu mono mikasa mioolo.» Na nde aleeli kwaa bo: «Bu maakuu.» ");
INSERT INTO iyx_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nde apali, na ayeni ku mulaanda a olive, mbii bwali ipfu kia nde. Miyii mia nde mia muduki. ");
INSERT INTO iyx_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Bu bo batoori nha mbuu yii, nde aleeli kwaa bo: «Dikuundu, paa di nyaala ubwa mu puusu.» ");
INSERT INTO iyx_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Na nde atakii na bo mu mwaa iteesi hoolo, na atsukini mu ukuundu, ");
INSERT INTO iyx_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","aleeli: «Taata so lili litoono la we, maasa me mbasa yi. Ka a buli litoono la me pe, ka nyaala litoono la we liyilima» ");
INSERT INTO iyx_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ni mubuu tumu a Nziaambi amati ku yula, amonii kwa nde mu uhamisa nde. ");
INSERT INTO iyx_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Boomo bu ba mubwiilili, nde akuundi mu ibaala kialaa, na tuumu la nde lakitii weti mabete ma makila matsoli nha tsi. ");
INSERT INTO iyx_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nha bisi a likuundu, nde atemini ayiri a uvutuu kwaa miyii, wababaasi bala tolo mu ndaa ngebe, ");
INSERT INTO iyx_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Na nde aleeli kwaa bo: «Mu ima dilaari tolo? Ditemene dikuundu paa dihele ubwa mu puusu.» ");
INSERT INTO iyx_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Bu ali kene mu utsuu, mosi mu miyii kuumi na mioolo wu bu baata Yuuda abeyi koongi, asweesii kwaa Yiisu mu unyumbutu nde. ");
INSERT INTO iyx_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yiisu aleeli kwaa nde: «Yuuda, mu unyumbutu we uyeelele Mwaana a muutu?» ");
INSERT INTO iyx_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Bu bamoni mamakeni uyiri, ba bali na Yiisu baleeli kwaa nde: «Pfumu, didwaana mu mukasa?» ");
INSERT INTO iyx_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Na mosi mu bo ateti booyi la nguu a ngaanga a Nziaambi, na akesi nde litswi la koo kia babaala. ");
INSERT INTO iyx_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ka Yiisu aleeli: «Dinyaala, bu maakuu.» Tumake nde abeembi litswi la booyi la nguu a ngaanga, na abeelisi nde. ");
INSERT INTO iyx_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yiisu aleeli kwaa banguu ba bangaanga ba Nziaambi, kwaa bakuutu ba bakebi ba nzo a Nziaambi na bakuutu ba baata, babayiri mu ukaanga nde: «Beni dipali na mikasa na mipaanga weti ti me ali ihaangi? ");
INSERT INTO iyx_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Biluumbu bioosi me nali na beni mu nzo a Nziaambi, na beni a diakaangi me pe. Ka di taanga dia beni na lituu la pimisi.» ");
INSERT INTO iyx_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Bu bakaangi Yiisu, bo babiti nde na bamuloosi mu nzo a nguu a bangaanga ba Nziaambi. Peetero aduki ku lala. ");
INSERT INTO iyx_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Bo bavuuti mbaa nha kati a mbari na badiaali. Peetero ali adiaali nha kati a bo. ");
INSERT INTO iyx_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Booyi limosi la mukaasa lamoni Peetero adiaala nha mukoo a mbaa, atali nde isooso, na aleeli: «Wuunawu ka aba na nde.» ");
INSERT INTO iyx_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ka nde wamutuni, aleeli: «A maama, me a nayaaba wa me nde pe.» ");
INSERT INTO iyx_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Idii pe, muutu mukimi amoni nde na aleeli: «Weka, li mosi mu bo!» Na Peetero avutili: «Ngori taata, a uli ngwanya pe.» ");
INSERT INTO iyx_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nha bisi a nguungu mosi, mukimi ahami mu uleele: «Mu ngwanya, wuunawu ka aba na nde, ka nde li musi Ngalili.» ");
INSERT INTO iyx_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Peetero avutili: «Me a nayaaba pe ma we tooni uleele.» Nhaa-na-tsi, bu ali keni mu utsu, tsutsu akookili. ");
INSERT INTO iyx_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ka Pfumu asieetii, na atali Peetero. Peetero alibili moonyi mu mandaa ma Pfumu aleeli kwa nde: «tswaamini tsutsu ukookolo lolo, we sa tunu me mbala tata.» ");
INSERT INTO iyx_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nde apali ku mbari, na alili mu ngebe dialaa. ");
INSERT INTO iyx_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Babaala baki kebe Yiisu, bamutsori, na bamuteti. ");
INSERT INTO iyx_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bo bafuyi nde busu na bafuuli nde, baleeli: «Bili! Leele na teti we?» ");
INSERT INTO iyx_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Na bo babwituu nde bituyi bia mupili na mupili. ");
INSERT INTO iyx_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Bu busu bakieeri, bakuutu ba baata, na banguu ba bangaanga ba Nziaambi na bayiisi ba mikele bakukini. Bo babiti Yiisu nha kulu a pfuundu a bakuutu ba banzioonzi ba Bayuudayo. ");
INSERT INTO iyx_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Bo baleeli: «So ni we li Kristo, leele bisi.» Nde avutili kwaa bo: «So me ndeeli beni, beni a disiingi so hoolo pe, ");
INSERT INTO iyx_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ka so me fuuli beni nduru, beni a divutulu so hoolo pe. ");
INSERT INTO iyx_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ka umata mu taanga di, Mwaana a muutu sa adiaala nha koo kia babaala kia Nziaambi puungu lituu.» ");
INSERT INTO iyx_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Boosi baleeli: «Ka we ni mwaana a Nziaambi?» Nde avutili kwaa bo: «Beni bame dileeli ti me ni Mwaana a Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ni mu buu bo baleeli: «Bisi a dili na nzala a imbaangi ikimi pe! Bisi bame dimaayuu mandaa mu munywa a nde.» ");
INSERT INTO iyx_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Baata boosi batemini itwaari na babiti Yiisu nha kulu a Pilato. ");
INSERT INTO iyx_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Bo babaandii ufuundu nde, baleeli: «Bisi dibaasi muutu wu mu utsindi baata ba tsi a bisi paa badwaanisa litumu la tsi: nde li mu ulii bo ufutu limaanda kwaa Kayisari, na nde li mu uleele mu inde makulu ti nde ni Kristo, mutini.» ");
INSERT INTO iyx_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato afuuli nde: «We ni mutini a Bayuudayo?» Nde avutili kwaa nde: «Ni we leeli buu.» ");
INSERT INTO iyx_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato aleeli kwaa banguu ba bangaanga ba Nziaambi na kwa koongi: «Me amoni toono ya uholo kesili mu muutu wu pe.» ");
INSERT INTO iyx_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ka bo bahanini na baleeli: «Nziisili a nde yili mu utsindi baata mu udwaanisa litumu la tsi, umata mu Ngalili, mu nde abaandii, mu Yuuda yoosi, natee nhaa na nha.» ");
INSERT INTO iyx_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Bu Pilato ayuyi maa, afuuli mbii ti muutu wu ni musi Ngalili. ");
INSERT INTO iyx_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Bu nde ayaabi ti Yiisu amati mu itinini kia tsi kia litumu la Erode, nde atsindii Yiisu kwaa Erode wali ka mu Yeruselemi mu biluumbu bii. ");
INSERT INTO iyx_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Bu Erode amoni Yiisu, nde ali na kinyi yalaa. Umata belepe ka nde ali na nzala umono nde, mu ndaa ma nde ayuyi baleeli mu nde, na nde ali na ilimbisi mu umono nde asa imaanga. ");
INSERT INTO iyx_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nde afuuli nde manduru malaa, ka Yiisu a avutili nde pe. ");
INSERT INTO iyx_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Banguu ba bangaanga ba Nziaambi na bayiisi ba mikele bali nhaa, na bafutili nde mandaa mu iteesi kia mifuri. ");
INSERT INTO iyx_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ka Erode ka, na masodaare ma nde, bamutsori; na bu bamani usiebe nde na ulwaatisi nde ikutu kia tala, nde abwivutulu Yiisu kwaa Pilato. ");
INSERT INTO iyx_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tsiomi, Pilato na Erode bali mitaata. Ka bo bavuutili imbaayi mu kiina iluumbu kii. ");
INSERT INTO iyx_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato akukii banguu ba bangaanga ba Nziaambi, bakuutu na baata boosi, ");
INSERT INTO iyx_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","na aleeli kwaa bo: «Beni dibeyi me muutu wu mu ndaa ti nde li mu utsindi baata mu udwaanisa ipfumu kia tsi. Ka me fuuli nde nha kulu a beni, na me amoni toono yimbi mu nde pe yi beni dili mu ufuundu nde. ");
INSERT INTO iyx_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erode ka a asolili toono yimbi mu nde pe, ni mu buu nde amaavutulu bisi nde. Mu yii, a uli na ndaa yi nde asa pe yafwaana mu likwa.  ");
INSERT INTO iyx_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Me sa tumu bafiinzi nde bikoti, na nha mbisi me sa namunyaala.» ");
INSERT INTO iyx_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Mu pasi mukuungi a Paaka, Pilato ali na ipfu kia upalisa bo kori mosi uli mu perese. ");
INSERT INTO iyx_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ka bo boosi baloyi mu itwaari: «Dusu muutu wu, na nyaala bisi Barabase.» ");
INSERT INTO iyx_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barnaba ali baloosi mu perese mundaa bu punga-pungu bali mu ngaanda na mu ndaa ti nde adusi muutu. ");
INSERT INTO iyx_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Bu Pilato ali na nzala a unyaala Yiisu, nde abwileele bo ndaa yiina yii. ");
INSERT INTO iyx_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ka bo baloyi: «Komo nde nha kuruwa! Komo nde nha kuruwa!» ");
INSERT INTO iyx_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Nde aleeli kwaa bo mu mbala la mutata: «Ki ndaa yimbi nde ayiluu? Me amoni toono mu nde pe yafwaana mu likwa. Ni mu buu me sa nyaala nde, nha mbisi a utumu ti bafiinzi nde bikoti.» ");
INSERT INTO iyx_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ka bo bahanini mu uloo mu mifuri, ba loombi: «Wamukomo nha kuruwa!» Na miloo mia bo miabiingi. ");
INSERT INTO iyx_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilato aholi kesili mu ukuusu litoono la bo. ");
INSERT INTO iyx_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nde anyaali wu bo baloombi wali mu perese mu ndaa ikiindi na ndusili; ka nde ayeelili bo Yiisu paa bayiluu mu nde pasi mi bo batoono. ");
INSERT INTO iyx_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Bu bo babiti nde, bo baholi Simooni musi Kirene, wakimata ku matsie, na bo bamukwiyi kuruwa paa nde abiti yo nha mbisi a Yiisu. ");
INSERT INTO iyx_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Koongi yinene ya baata yaduki nde, na bakaasa bakilili na unyoongo mu nde. ");
INSERT INTO iyx_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yiisu asieetii kwaa bo na aleeli: «Bakaasa ba Yeruselemi, a dilili mu me pe; ka dilili mu beneme na mu baana ba beni. ");
INSERT INTO iyx_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ka biluumbu biyiri bi bakaaleele: “Kinyi kwaa Bakaasa ba bikumbu, kinyi kwaa mioonyo miahele ubutu, na mabeene mahele unywiisi!” ");
INSERT INTO iyx_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ka sa babaleele kwaa milaanda miminene: “Dibwa nha yulu a bisi”, na kwaa milaanda mimikee: “Diswee bisi!” ");
INSERT INTO iyx_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ka mbii basiiri buu kwaa muti wu mubisi, buni bukaaba kwaa muti wa kaya?» ");
INSERT INTO iyx_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Babeyi mu taanga dii, biwulu bioolo bikimi, mu udusu bio na Yiisu. ");
INSERT INTO iyx_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Bu batoori nha mbuu yibubaata «Iteenge kia mutswe», bo bakomi nde nhaa, na biwulu bio bia bioolo. Mosi nha koo kia babaala na wu mumosi nha koo kia bakaasa. ");
INSERT INTO iyx_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tumake, Yiisu aleeli: «Taata, sa bo kolokolo, ka a bayaaba pe mi bo bali mu uyiluu.» Bo bati zeke mu ukaba bikutu bia nde. ");
INSERT INTO iyx_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Baata batemini nhaa na bakitala. Ka bakuutu bakisa nde saa, baleeli: «Nde avuusu bakimi. Nyaala avuu ndeme akulu, mbii ti nde Kristo, wu Nziaambi asoolo!» ");
INSERT INTO iyx_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Masodaare ka masi nde saa, bo baswesii na bahi nde viinyi la nhanyi, ");
INSERT INTO iyx_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","na baleeli: «So we ni mutini a Bayuudayo, vuusu nyutu a we, we makulu!» ");
INSERT INTO iyx_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nha yulu a mutswe a nde, mwali na bisonii bi: «Wuunawu ni mutini a Bayuudayo.» ");
INSERT INTO iyx_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mosi mu biwulu bi bakomi nha kuruwa atuuyi Yiisu wamuleeli: «We a ni Kristo pe? Vuu mu iweme na vuusu bisi ka!» ");
INSERT INTO iyx_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ka wu mu mosi asieembi mbaayi na wamuleeli: «We a ubaabata Nziaambi boomo pe? Bunu weli kutso tsieembili moosi na nde. ");
INSERT INTO iyx_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kwaa we na me, tsieembili a bisi yasuungunu, mundaa ti bisi dili mu ufutu mamabi madiayiluu, ka wuunawu a ayiluu ndaa so mosi yimbi pe.» ");
INSERT INTO iyx_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Na nde abwileele: «Yiisu libili me moonyi mu taanga di we kaayira mu ipfumu kia we.» ");
INSERT INTO iyx_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yiisu avutili kwaa nde: «Ngwanya, me ni leele kwaa we: lolo li we saba na me ku paradiso.» ");
INSERT INTO iyx_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Taanga dia nzanga bu diali ka bebele, pimisi diabwi mu tsi yoosi natee mu nguungu ya mutata nha mbisi a nzanga. ");
INSERT INTO iyx_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Nyanga bu yali keni yasweeme, ngumbu ya Nzo a Nziaambi yakakii nha kati a kati. ");
INSERT INTO iyx_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yiisu aloyi mu ndaa yi inene, aleeli: «Taata, nha mioo mia we me nzieelili muwuumu a me.» Bu aleeli buu, asieeli muwuumu. ");
INSERT INTO iyx_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mukuutu a masodaare bu amoni moosi mayilimi, akiinzi Nziaambi, aleeli: «Ngwanya! Wuunawu beeri muutu wa libweeye.» ");
INSERT INTO iyx_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Baata boosi ba bakukini mu umono mandaa maa, bu bamoni mayilimi, bavutii na bakiyene akubulu mapfuuku mu minyoongo. ");
INSERT INTO iyx_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Banduu ba Yiisu na Bakaasa bakiduku nde umata ku Ngalili, batemini nha lilala, mu utalila makilabuu. ");
INSERT INTO iyx_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Mwali muutu mosi mu pfuundu a bakuutu ba banzioonzi ba Bayuudayo, kuumbu a nde Yoosefi, muutu wu mubwe na wa libweeye, ");
INSERT INTO iyx_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","nde a asiingi pe kesili na biyiluu bia bambaayi. Nde ni musi Arimataya, ngaanda a Bayuudayo, na nde akikebe Ipfumu kia Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nde ayeni kwaa Pilato, na aloombi nyutu a Yiisu. ");
INSERT INTO iyx_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nde asutili yo nha kuruwa, adii yo tsaanda a liino, na asuusi yo mu ngili yi basootolo mu manya, mwali keni a badii muutu pe. ");
INSERT INTO iyx_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ali iluumbu kia uyilimi mu saba, na hoolo yasiaali ti saba yibaanduu. ");
INSERT INTO iyx_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Bakaasa ba baduki Yiisu, umata ku Ngalili, bayeni na Yoosefi, bo bamoni ngila a Yiisu na mbii bu basuusi nyutu a nde. ");
INSERT INTO iyx_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Na bo bavutii, mu uyiluu mananaasa na maari, tumake mu iluumbu kia saba, bo bawuumi mbii bwali mikele. ");
INSERT INTO iyx_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Mu iluumbu kia tsiomi kia limiingi mu ngwaali a ngwaali, bakaasa bayeni ku ngili, babiti mananaasa ma bo bayilii. ");
INSERT INTO iyx_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bo bayibaasa manya lali lafuu munywa a ngila banyiingili nha peembi; ");
INSERT INTO iyx_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Bo bakoti, ka a basolili nyutu a Pfumu Yiisu pe. ");
INSERT INTO iyx_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Bu bali afulusunu, babaala boolo balwaata matsaanda mangeyini bamonii kwaa bo. ");
INSERT INTO iyx_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bu Bakaasa bamoni boomo, babaandisi biinzi bia bo mu tsi, ka babaala baa baleeli kwaa bo: «Mu ima dili mu usaa wu li moonyi mu babakwa? ");
INSERT INTO iyx_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nde a ali nha pe, ka siimbiangi wa nde. Dilibili moonyi mu mi nde aleeli beni mu taanga di nde abeeri keni ku Ngalili: ");
INSERT INTO iyx_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Bwafaana ti bayeelele Mwaana a muutu nha mioo mia bangaa masumu, paa bakomo nde nha kuruwa, na asiimbuu mu iluumbu kia bitata.”» ");
INSERT INTO iyx_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ni nhaa, bakaasa balibili moonyi mu mandaa ma nde. ");
INSERT INTO iyx_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Bo bamati ku ngila na bayeni mu uyayaabisa maa moosi kwaa batumu kuumi na mosi na kwaa miyii mini mioosi. ");
INSERT INTO iyx_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ali Mari, musi Mangadala, na Zaana, na Mari, nguu a Yaki, na bakaasa bakimi. Bo baleeli mandaa maa kwaa batumu. ");
INSERT INTO iyx_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ka bo batsimi ti mandaa ma babaleeli kwaa bo mahele a tsala, na a babasi imiini pe. ");
INSERT INTO iyx_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ka Peetero atemini, ayeni mawasa ku ngila. Bu abaandini amoni ndila matsaanda ma liino. Tumake, nde akimii kwalaa mu moosi mayilimi na avutii ku nzo a nde. ");
INSERT INTO iyx_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mono, iluumbu kii, mioolo mu miyii miayeni ku bula ba kuumbu Emawusi, batakuu na Yeruselemi, mu iteesi kia bakilometre helape kuumi na boolo. ");
INSERT INTO iyx_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Babayi imoo nha kati a bo mu maa moosi malabii. ");
INSERT INTO iyx_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Bu bakitsuu na ufulusunu, nde makulu Yiisu asweesi, na avuuti na bo. ");
INSERT INTO iyx_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Bamumoni, ka a batuyi uyaaba nde pe. ");
INSERT INTO iyx_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yiisu aleeli kwaa bo: «Mu ki mandaa beni dili mu yolo, bu dili mu uyene?» Batsikini na mabusu ma bo mali na ngebe. ");
INSERT INTO iyx_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mosi mu bo, kuumbu a nde Klewopa, avutili, aleeli kwaa nde: «Ka ndila we mu Yeruselemi, wahele uyaaba mabwi nha mu biluumbu bi?» ");
INSERT INTO iyx_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Aleeli kwaa bo: «Ki ma ndaa?» Baleeli kwaa nde: «Ma mu Yiisu, ni musi Nazareti, wabeeri mibili wa lituu mu biyiluu na mu mandaa nha kulu a Nziaambi na baata boosi. ");
INSERT INTO iyx_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Banguu ba bangaanga ba Nziaambi na bakuutu ba bisi bayeelili nde mu uha nde tsieembili ya likwa, na bamukomi nha kuruwa. ");
INSERT INTO iyx_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Bisi diasi ilimbisi ti nde wa keni kuulu Iseraeli, ka lolo ka iluumbu kia bitata, umatuu bu bayiluu mandaa maa mayilimi. ");
INSERT INTO iyx_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Diali na dungunguu mu ndaa ti Bakaasa ba bamosi nha kati a bisi bayeni ngwaali a ngwaali yi ku ngila. ");
INSERT INTO iyx_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ka bu bahele usololo nyutu a nde, bo bayileele ti batumu ba Nziaambi bamonii kwaa bo, na baleeli bo ti Yiisu li moonyi. ");
INSERT INTO iyx_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ba bamosi mu ba bali na bisi bayeni ku ngila, bamoni bioosi mbii bwaleeli Bakaasa, ka nde a bamumoni pe.» ");
INSERT INTO iyx_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yiisu aleeli kwaa bo: «Beni a dili na mayele pe. Mitimi mia beni mia leme mu usa imiini mu moosi maleeli mibili! ");
INSERT INTO iyx_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ali abwafwaana pe ti Kristo amono pasi dia buu, tswaamina nde ukoto mu buzitu ba nde?» ");
INSERT INTO iyx_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tumake, nde wababiindili moosi mabasonuu mu mandaa ma Nziaambi mu ndaa nde. Nde wababiindili mo ubaanduu mu mikaanda mia Mooso natee mu mikaanda mioosi mia mibili. ");
INSERT INTO iyx_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Bu batoori nha peembi a bula ba bakiyene, nde asi weti wu ulabuu. ");
INSERT INTO iyx_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Bo bamupeli, baleeli: «Ba na bisi, ka tsitsii yimaato, busu baka mu uyili.» Mu yii, nde akoti mu udiaala na bo. ");
INSERT INTO iyx_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Bu adiaali na bo nha meese, nde a holi lipa, avutili matoondo kwaa Nziaambi, abukili na wabahi lo. ");
INSERT INTO iyx_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ni mu buu, miisi mia bo miadibini na bamuyaabi. Ka nde adiimbili nha kulu a bo. ");
INSERT INTO iyx_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Baleelisini: «Mitimi mia bisi mialuuli mu kinyi mu kuulu, bu nde abeeri abiindili bisi, Mabasonuu.» ");
INSERT INTO iyx_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Mu diina taanga dii, bo batemini, bavutii ku Yeruselemi, babaasi kuumi na mosi bakukunu na babali na bo. ");
INSERT INTO iyx_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Boosi baleeli kwaa miyii mioolo mii: «Mu ngwanya Pfumu siimbiangi na moniaangi kwaa Simooni.» ");
INSERT INTO iyx_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Miyii mioolo mialeeli kwaa bo mioosi mialabii mu kula na buni bo bamuyaabi bu nde akibukulu lipa. ");
INSERT INTO iyx_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Bu bali bakeni mu utsu, Yiisu nde makulu amonii nha kati a bo, aleeli: «Iyeenge kwaa beni!» ");
INSERT INTO iyx_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Bo babayi boomo balaa, batehiti na batsimi ti bo bamoni iduuru. ");
INSERT INTO iyx_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ka Yiisu aleeli kwaa bo: «Mu ima matsimi ma beni mali mutele-mutele na dili na maketi-keti mu mitimi mia beni? ");
INSERT INTO iyx_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Dimono mioo na miili mia me, ni me wa me. Dibeembe me, dikengese me. Iduuru a ili na musunyi na miyisi weti bu me ndi pe.» ");
INSERT INTO iyx_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Bu akileele buu, wabamweesi mioo na miili mia nde. ");
INSERT INTO iyx_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ka bu bali keni kutso kinyi na ukimuu, a batuyi usa imiini pe natee bu Yiisu aleeli kwaa bo: «A dili na iloo kia udia nha pe?» ");
INSERT INTO iyx_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bamuhi itsuru kia tswi kibakaanga. ");
INSERT INTO iyx_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Aholi kio, na adi nha kulu a bo. ");
INSERT INTO iyx_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tumake nde aleeli kwaa bo: «Ma ni mandaa ma me naleeli beni bu nali na beni, moosi ma basonuu mu me mu mikele mia Mooso, mu mibili, na mu mikuunga, mafwaana mu uyilimi.» ");
INSERT INTO iyx_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ni mu buu nde adibili mayele ma bo paa bayaaba tsutulu a Mabasonuu. ");
INSERT INTO iyx_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Na aleeli kwaa bo: «Mono, bu ni bwasonomo: Kristo afwaana umono pasi na usiimbuu mu babakwa mu iluumbu kia bitata, ");
INSERT INTO iyx_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","mu kuumbu a nde sa bayiisi kiingili a mayele na uleele nyaalili a masumu kwaa bifuumbu bioosi, ubaanduu mu Yeruselemi. ");
INSERT INTO iyx_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Beni ni bambaangi ba mandaa ma. ");
INSERT INTO iyx_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mono, me ni tsinduu beni mi Taayi a me alasini beni. Ka beni didiaala mu ngaanda natee bu beni dikalwaata lituu la yula.» ");
INSERT INTO iyx_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nha mbisi a nhaa, Yiisu abiti miyii mia nde natee ku peembi a Betania, anaangili mioo mia nde ku yula, na wabasiemi. ");
INSERT INTO iyx_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Bu nde akisieme bo, nde akinaanguu, na ahaati ku yula. ");
INSERT INTO iyx_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Miyii bu miamani ubili Yiisu, bo bavutii ku Yeruselemi mu kinyi yalaa. ");
INSERT INTO iyx_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bo bali mu nzo a Nziaambi taanga dioosi na bakikiinzanga Nziaambi.");
INSERT INTO iyx_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mu mbaandili mwali Ndaa, Ndaa yali na Nziaambi, na Ndaa yo makulu yali Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Mu mbaandili yo yali na Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Bioosi biayilimi mu yo, na a uli na iloo so imosi pe, kibayiluu kiayilimi kwahele a yo. ");
INSERT INTO iyx_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mu yo mwali na moonyi, na moonyi wuu ali liyalila la baata. ");
INSERT INTO iyx_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Liyalila langeyini kutso pimisi, ka pimisi a diadimisi lo pe. ");
INSERT INTO iyx_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nziaambi atsindii muutu mu uyayaabisa Ndaa a nde kwaa baata, ni muutu wa kuumbu Yowani. ");
INSERT INTO iyx_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Nde ayiri weti mbaangi, mu uta imbaangi mu liyalila lii, paa boosi basa imiini mundaa imbaangi kia nde. ");
INSERT INTO iyx_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Nde makulu a ali liyalila pe, ka nde ayiri mu uta imbaangi mu liyalila. ");
INSERT INTO iyx_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Liyalila li ali ni ndila lo limosi la ngwanya, lili mu uyiri mu tsi, na lili mu uyalisa baata boosi. ");
INSERT INTO iyx_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ndaa yali mu tsi. Tsi yayilimi mu yo, ka bunu tsi a yamuyaabi pe. ");
INSERT INTO iyx_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yo yayiri mu tsi a baata ba yo, ka baata ba tsi yii a bayaki yo pe. ");
INSERT INTO iyx_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ka kwaa boosi babayaki yo na babasi imiini mu kuumbu a yo, yo yahi bo muswa wa uba baana ba Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bo a babutii baana ba Nziaambi mu musunyi na makili pe, so mu litoono la muutu pe. Ka bo babutii mu litoono la Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ndaa yakitii muutu, na muutu wuu adiaali nha kati a bisi. Bisi diamoni buzitu ba nde, buzitu ba Mwaana ndila mosi wamata kwaa Taayi a nde. Nde ali aluulu mu bweese ba Nziaambi na mu ngwanya. ");
INSERT INTO iyx_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yowani ati imbaangi mu nde. Yowani ayaabisi kwaa baata: «Ni mu nde me natsuyi bu naleeli: “Nde li mu uyiri ku mbisi a me, ka nde avulu me ndutu, mundaa ti nde akwiba tswaamina me ni butuu.”» ");
INSERT INTO iyx_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Bisi boosi diayaki ikuku kia busini ba nde. Bisi diayaki bweese nha yulu a bweese. ");
INSERT INTO iyx_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nziaambi ahi bisi mikele mu Mooso. Ka bweese na ngwanya biayiri mu Yiisu Kristo. ");
INSERT INTO iyx_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Muutu so mosi pe wamaamono Nziaambi. Ka Mwaana ndila mosi, wuli mu udiaala nha peembi a Taayi, wamweesi bisi bu Taayi ali. ");
INSERT INTO iyx_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Bu bakuutu ba Bayuudayo ba ku ngaanda a Yeruselemi, batsindii kaba la bangaanga ba Nziaambi na Balevita, mu ufuulu Yowani: «We na li?» Mono mialeeli Yowani: ");
INSERT INTO iyx_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nde a abisi pe uha bo mvutu. Ka nde aleeli na yaki-yaki nha kulu a boosi: «Me a ndi Kristo pe.» ");
INSERT INTO iyx_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Bo bamufuuli: «Ka we na li? We ni mubili Eliya?» Yowani avutili: «Ngori, me a ndi Eliya pe.» Bo babwileele: «We ni mubili wu bisi dili mu ukebe?» Nde abwivutulu: «Ngori, me a ndi mubili wuu pe.» ");
INSERT INTO iyx_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ka bo baleeli kwaa nde: «Ninha we na li? Bisi diafwaana uha mvutu kwaa babatsinduu bisi. We ima leeli mu we makulu?» ");
INSERT INTO iyx_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yowani avutili: «Me ni muniingi a wuu wuli mu uloo ku tsi ya tsata: “Diyiluu Pfumu kuulu yayiluu usuungunu!”» Weti bwaleeli mubili Yeesaya. ");
INSERT INTO iyx_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Baata babatsindii kwaa Yowani bali Bafarisi. ");
INSERT INTO iyx_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Bo babwifuulu nde: «Mbiiti we a li Kristo pe, so mubili Eliya pe, na so mubili wuu pe, ka mu ima we li mu ubootuu baata?» ");
INSERT INTO iyx_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yowani wabavutili: «Me ni bootu beni mu maamba. Ka nha kati a beni, uli na muutu wu beni diahele uyaaba. ");
INSERT INTO iyx_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ni nde wuu wuli mu uyiri ku mbisi a me. Ka me a nafwaana pe so hoolo mu unyangila midi mia bikoori bia nde.» ");
INSERT INTO iyx_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Mandaa maa moosi makilabuu ku Betania, ku simi li limosi la nziali, ya kuumbu Yorodaani, ku Yowani akibootuu. ");
INSERT INTO iyx_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Iluumbu kiaduki, Yowani amoni Yiisu mu uyiri kwaa nde. Nde aleeli: «Dimono mwaana a limeme la Nziaambi, lili mu umaasa masumu ma baata ba tsi. ");
INSERT INTO iyx_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Mu nde me natsuyi bu naleeli: “Muutu li mu uyiri ku mbisi a me, ka nde avulu me ndutu, mundaa ti nde akwiba tswaamina me ni butuu.” ");
INSERT INTO iyx_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Me a nali nayaaba nde pe. Ka me nayiri mu ubootuu mu maamba, paa me yaabisa nde kwaa baata ba Iseraeli.» ");
INSERT INTO iyx_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yowani abwileele ta imbaangi: «Me namono Muheebili a Nziaambi mu usutuu, umatuu ku yulu weti beembe, na ahami mu uba itwaari na nde. ");
INSERT INTO iyx_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Me a nakiyaaba pe nde na ali. Ka Nziaambi, watsinduu me mu ubootuu mu maamba, aleeli kwaa me: “Muutu wu we kaamono Muheebili mu usutuu na uba na nde, ni nde kaabootuu baata mu Muheebili wa Ngira.” ");
INSERT INTO iyx_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Me maamono Muheebili mu usutuu nha yulu a nde, na ngwanya me ndi mbaangi ti nde ni Mwaana a Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mu iluumbu kiaduki, Yowani ali keni nhaa, na mioolo mu miyii mia nde. ");
INSERT INTO iyx_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Bu nde amoni Yiisu mu uyoo, nde aleeli: «Dimono limeme la Nziaambi!» ");
INSERT INTO iyx_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Miyii mia Yowani mioolo miayuyi mandaa maa, na mio miaduki Yiisu. ");
INSERT INTO iyx_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yiisu asieetii, na amoni ti bo bali mu uduku nde. Nde wabafuuli: «Ima beni dili mu usaa?» Bo bamuleeli: «We kuni li mu udiaala, Rabi?» Mambiindili ma Rabi, «Muyiisi». ");
INSERT INTO iyx_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yiisu avutili kwaa bo: «Yirani, na sa dimono.» Bo bayeni na bamoni ku nde akidiaala. Na bo bayoosi iluumbu kii itwaari na Yiisu. Helape ali ka nguungu ya mana ku mbisi a nzanga. ");
INSERT INTO iyx_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andere, mwaana a nguu a Simooni Peetero, ali mosi mu baboolo babayuyi mandaa ma Yowani, na baduki Yiisu. ");
INSERT INTO iyx_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Tsiomi a tsiomi, Andere ayimono mwaana a nguu a nde Simooni. Nde wamuleeli: «Bisi dimaamono Mesiya.» Mambiindili ma Mesiya, «Kristo». ");
INSERT INTO iyx_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Tumake nde abiti Simooni kwaa Yiisu. Yiisu wamumoni na aleeli: «We ni Simooni mwaana a Yowani. Sa baha we kuumbu ya ubili “Kepasi.”» Mbiindila kuumbu yii, «Manya». ");
INSERT INTO iyx_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Iluumbu kiaduki, Yiisu aholi kesili ya uyene ku Ngalili. Nde abwaanini na Filipo, na wamuleeli: «Duku me!» ");
INSERT INTO iyx_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo ali musi Betesayida, ni ngaanda ka ya Andere na Peetero. ");
INSERT INTO iyx_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Nha mbisi, Filipo abwaanini na Natanaeli, na wamuleeli: «Bisi dimaamono wuu wu Mooso atsuyi mu Mukaanda wa Mikele, na wu mibili ka miatsuyi. Ni Yiisu, mwaana a Yoosefi, wa ku ngaanda a Nazareti.» ");
INSERT INTO iyx_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaeli wamuleeli: «Ndaa yimbwe utuu umata ku ngaanda a Nazareti?» Filipo wamuvutili: «Yiri, na we sa mono.» ");
INSERT INTO iyx_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Bu Yiisu amoni Natanaeli mu uyiri kwaa nde, nde aleeli mu ndaa Natanaeli: «Mono musi Iseraeli wa ngo nde. A uli na ndaa ya pia mu nde pe.» ");
INSERT INTO iyx_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaeli wamufuuli: «Buni we yaabi me?» Yiisu avutili: «Me namono we nha tsini a muti wa mufiike, tswaamina Filipo uta we mbili.» ");
INSERT INTO iyx_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ni mu buu, Natanaeli wamuleeli: «Muyiisi, we ni Mwaana a Nziaambi wa ngwanya, we mutini a Iseraeli!» ");
INSERT INTO iyx_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yiisu wamuvutili: «We nha siiri imiini mu me, mundaa ti me ndeeli kwaa we ti me namono we nha tsini a muti wa mufiike? We sa mono mandaa mamavulu maa-na-ma mu bunene!» ");
INSERT INTO iyx_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Na nde abwileele: «Ee-e, ngwanya me nadileeli: beni sa dimono mayulu madibini, na batumu ba Nziaambi mu uhaata na usutuu nha yulu a Mwaana a muutu!» ");
INSERT INTO iyx_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nha mbisi a biluumbu bioolo, ali na mukuungi a makweele ku ngaanda a Kaana, mu itinini kia Ngalili. Nguu a Yiisu ali nhaa. ");
INSERT INTO iyx_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ali bakuungi ka Yiisu na miyii mia nde ku makweele me. ");
INSERT INTO iyx_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mu taanga di mala mawi, nguu a Yiisu wamuleeli: «Bo ka mala pe.» ");
INSERT INTO iyx_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ka Yiisu wamuvutili: «Maama, we ima li mu usaa mu me? Taanga dia me keni a diafwaana pe.» ");
INSERT INTO iyx_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nguu a Yiisu aleeli kwaa basiali: «Disa mioosi mi nde uleele kwaa beni.» ");
INSERT INTO iyx_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ali na masaanga masamina ma bayiluu mu mamanya, ma Bayuudayo bakisalila mu matsaa ma tsieemini. Mu pasi lisaanga ali utuu ukoto iteesi kia kama a baliitre ba maamba. ");
INSERT INTO iyx_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yiisu aleeli kwaa basiali: «Diluusu masaanga ma mu maamba.» Bo baluusi mo tee mu minywa. ");
INSERT INTO iyx_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ni mu buu, Yiisu wabaleeli: «Ditee mwaana a ndaamba a maamba ma, na dibiti mo kwaa mubiti a mukuungi.» Bo bayilii buu. ");
INSERT INTO iyx_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mubiti a mukuungi abiimbi maamba mamakitii viinyi. Nde a ayaabi pe kuni mala maa mamati, ka basiali babateyi maamba bayaabi ku mo mamati. Ni mu buu nde ati mukweeli mbili, ");
INSERT INTO iyx_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","na wamuleeli: «Baata boosi koo ubaanduu uha mala mavulu bubwe. Tumake, bu babata mbili bamaanywa kwalaa, sa baha bo mala mahele ubweeye. Ka we, maaswee mala ma mabwe tee mu taanga di!» ");
INSERT INTO iyx_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Mono, imaanga kia tsiomi kiayilii Yiisu ku Kaana, mu itinini kia Ngalili. Nde abaandii umweese buzitu ba nde, na miyii mia nde miasi imiini mu nde. ");
INSERT INTO iyx_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nha mbisi a nhaa, nde ayeni ku ngaanda a Kapernawumi na nguu a nde, na baana ba nguu ba babaala, na miyii mia nde. Bo badiaali kuu mu ndila mwaana a biluumbu hoolo. ");
INSERT INTO iyx_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Mukuungi a Bayuudayo wa Paaka ali ka bebele, ni buu Yiisu ayeni ku ngaanda a Yeruselemi. ");
INSERT INTO iyx_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ku nzo a Nziaambi, nde amoni baata bakiyaluu bangoombo, bindombo na mabeembe. Nde amoni ka baata bakisoomboso mboongo badiaala nha mameese ma bo. ");
INSERT INTO iyx_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ni mu buu, nde ayilii ikoti mu misiingi, na abingi bo boosi ku mbari a nzo a Nziaambi, na bangoombo ba bo, na bindombo bia bo. Tumake, nde atsiali mboongo dia basoombisi nha tsi, na abuundili mameese ma bo. ");
INSERT INTO iyx_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Tumake Yiisu aleeli kwaa bayalii a mabeembe: «Dimaasa bi bioosi nha! A dikitisi nzo a Taayi a me pe mu uba nzo a mumbungu!» ");
INSERT INTO iyx_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Miyii mia nde mialibili moonyi mu mandaa maa mu Mabasonuu ma Ngira: «Oo Nziaambi, litoono li me ndi na lo mu nzo a we, lili mu unyeengese me weti mbaa.» ");
INSERT INTO iyx_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ni mu buu, bakuutu ba Bayuudayo bamufuuli: «Ki imaanga we utuu usa mu umweese bisi ti we na muswa wa uyiluu mandaa ma pili yii?» ");
INSERT INTO iyx_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yiisu avutili kwaa bo: «Ditsala nzo a Nziaambi yiinayi, na mu biluumbu bitata me sa bwatuungu yo.» ");
INSERT INTO iyx_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Bo bamuleeli: «Imaa? Babatuungi yo basi bilimi maku-mana na bisamina. Ka we, we sa bwatuungu yo mu biluumbu bitata?» ");
INSERT INTO iyx_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ka nzo a Nziaambi yi Yiisu akitsuu mu yo, ali nyutu a nde makulu. ");
INSERT INTO iyx_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ni mu buu, mu taanga di Yiisu asiimbii mu babakwa, miyii mia nde mialibili moonyi ti nde aleeli buu. Na bo basi imiini mu Mabasonuu ma Ngira na mu mandaa ma Yiisu aleeli. ");
INSERT INTO iyx_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Bu Yiisu ali ku ngaanda a Yeruselemi mu taanga dia mukuungi a Paaka, babalayi basi imiini mu kuumbu a nde, bu bakimono bimaanga bi nde akiyiluu. ");
INSERT INTO iyx_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ka Yiisu a asi mutimi mu bo pe, mundaa ti nde ayaabi bo boosi bubwe-bubwe. ");
INSERT INTO iyx_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nde a ali na nzala pe ti bayaabisa nde ndaa so mosi, mundaa ti nde makulu ali ayaaba matsimi ma mitimi mia baata. ");
INSERT INTO iyx_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ali na muutu mosi nha kati a Bafarisi, kuumbu a nde Nikodemo. Nde ali mosi mu bakuutu ba Bayuudayo. ");
INSERT INTO iyx_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Butsuu bumosi nde ayiri ku uyamono Yiisu na wamuleeli: «Muyiisi, bisi diayaaba ti Nziaambi atsinduu we mu uyayiisi bisi. Mundaa ti muutu pe wu utuu uyiluu bimaanga weti bu we li mu uyiluu bio, so Nziaambi a ali na nde pe.» ");
INSERT INTO iyx_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yiisu wamuvutili: «Ee-e, ngwanya me nileele we: muutu pe wu utuu umono Ipfumu kia mayula so nde a butii pe libutuu lilinyatii.» ");
INSERT INTO iyx_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemo wamufuuli: «Buni muutu wakulu utuu ubwabutuu? Nde utuu ubwavutuu mu moonyo a nguu a nde na ubutuu mbala ya dioolo?» ");
INSERT INTO iyx_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yiisu wamuvutili: «Ee-e, ngwanya me nileele we: muutu pe wu utuu ukoto mu Ipfumu kia Nziaambi so nde a butii pe libutuu la mu maamba na la mu Muheebili. ");
INSERT INTO iyx_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kiabutuu mu musunyi ili musunyi, na kiabutuu mu Muheebili a Nziaambi, ili muheebili. ");
INSERT INTO iyx_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","A kimuu pe bu me ndeeli we: “Beni boosi diafwaana ubutuu libutuu lilinyatii.” ");
INSERT INTO iyx_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mupepe uyene ku nde atoono, we li mu uyuu kele yi nde ali mu usa. Ka we a ayaaba pe kuni nde ali mu umata, na kuni nde ali mu uyene. Mono bu ili mu uba kwaa pasi muutu wu ubutuu mu Muheebili a Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemo wamufuuli: «Buni mii mituu uyilimi?» ");
INSERT INTO iyx_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yiisu wamuvutili: «We wuli muyiisi wa mvuungu mu Iseraeli, we a ayaaba pe mandaa maa? ");
INSERT INTO iyx_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ee-e, ngwanya me nileele we: bisi dibaatsuu mu mandaa ma diayaaba, na dibaata imbaangi mu mandaa ma bisi diamono. Ka beni a dibaasingi pe imbaangi kia bisi. ");
INSERT INTO iyx_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Me maatsuu kwaa beni mu mimili mu ulabuu nha tsini a toto nha, na beni a diasa imiini mu me pe. Aka buni beni disa me imiini so me tsuyi beni mu mimili mu ulabuu ku mayula? ");
INSERT INTO iyx_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Muutu pe wahaati ku yula, so a ndila Mwaana a muutu pe wamati ku yula mu usutuu nha tsi! ");
INSERT INTO iyx_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mbii bu Mooso abandii taari nha muti mu tsi ya tsata, ni buu ka Mwaana a muutu afwaana bamunaangila. ");
INSERT INTO iyx_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Paa pasi muutu wu usa imiini mu nde, abaa moonyi wa bilimi na bilimi. ");
INSERT INTO iyx_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ka mbii bu Nziaambi atooni tsi, nde aheeri Mwaana a nde ndila mosi, paa pasi wu usa imiini mu nde, a budusu pe, ka sa abaa moonyi wa bilimi na bilimi. ");
INSERT INTO iyx_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nziaambi a atsindii pe mwaana a nde nha tsi mu ufuundusu tsi. Ka paa ti tsi iyobuu mu nde. ");
INSERT INTO iyx_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Wu usa imiini mu kuumbu a Mwaana, a bufuundusu pe. Ka wu uhele usa imiini mu kuumbu a Mwaana, bamaakwafuundusu nde. Mundaa ti nde a asi imiini pe mu kuumbu a Mwaana ndila mosi wa Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mono buli pfuundisi: liyalila limaayiri nha tsi, ka baata batooni pimisi nha mbuu ya liyalila, mundaa ti biyiluu bia bo bili bibibi. ");
INSERT INTO iyx_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Pasi wu uyiluu mamabi beli liyalila, na takii na lo. Mundaa ti nde li na boomo ti biyiluu bia nde bibibi biyabina nyanga-bala. ");
INSERT INTO iyx_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ka wu ubaayiluu mandaa ma ngwanya ubaayiri ku liyalila. Paa bamono na yaki-yaki ti, mandaa ma nde ali mu uyiluu mali masuungunu na Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nha mbisi a nhaa, Yiisu na miyii mia nde bayeni ku itinini kia Yuuda. Nde adiaali kuu taanga hoolo na bo, na nde akibootuu baata. ");
INSERT INTO iyx_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yowani ka akibootuu ku bula ba kuumbu Enoni, bebele na Salimi, mundaa ti maamba ali mavululu kuu. Baata bakiyiri kwaa nde, na nde akibootuu bo. ");
INSERT INTO iyx_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Mu taanga dii, Yowani ali keni a balooso pe nde mu perese. ");
INSERT INTO iyx_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Babamosi mu miyii mia Yowani bakiyolo na Muyuudayo mosi, mu ndaa matsaa ma tsieemini. ");
INSERT INTO iyx_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bo bayeni kwaa Yowani na bamuleeli: «Muyiisi, muutu wali na we ku simi li limosi la Yorodaani, wuu wu we ati imbaangi mu nde, mono nde li mu ubootuu! Baata boosi bali mu uyene kwaa nde!» ");
INSERT INTO iyx_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yowani wabavutili: «A uli na muutu pe wu utuu ubaa iloo so imosi, mbii ti Nziaambi a ahi nde kio pe. ");
INSERT INTO iyx_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Beni bame dili bambaangi ti me naleeli: “Me a ndi Kristo pe, ka me batsinduu nha kulu a nde.” ");
INSERT INTO iyx_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mu mukuungi a makweele, baala lilibaakweele mukaasa, ni nde mulumi a mukaasa wuu. Nduu a mulumi koo utemene nha peembi a nde, mu uyuu nde. Nde koo aluulu mu kinyi, mu uyuu muniingi a mbaayi a nde wumaakweele. Kinyi yii ni yili na me, na yo yimaakuu mu taanga di. ");
INSERT INTO iyx_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nde afwaana uyoo nha kulu, na me nha mbisi.» ");
INSERT INTO iyx_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Muutu wamata ku yula, li nha yulu a baata boosi. Ka wuli wa nha tsi, li wa tsi, na li mu utsuu mandaa ma tsi. Muutu wamata ku yula li nha yulu a baata boosi. ");
INSERT INTO iyx_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nde li mu uta imbaangi mu mi nde amoni, na mi nde ayuyi. Ka muutu pe wuli mu usiingi imbaangi kia nde. ");
INSERT INTO iyx_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Wu usiingi imbaangi kia nde, siingi ka ti Nziaambi li wa ngwanya. ");
INSERT INTO iyx_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Muutu wu Nziaambi atsinduu li mu uleele mandaa ma Nziaambi, mundaa ti Nziaambi li mu uha nde Muheebili a nde woosi. ");
INSERT INTO iyx_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Taayi atoono Mwaana, na nde asuusu bioosi nha tso mioo mia Mwaana. ");
INSERT INTO iyx_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Muutu wu usa imiini mu Mwaana, bayi moonyi wa bilimi na bilimi. Ka wu ubisi usa imiini mu Mwaana, a ubaa moonyi wuu pe, ka Nziaambi sa aba na kesi a nde.» ");
INSERT INTO iyx_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Bafarisi bayuyi ti Yiisu ali na miyii mialaa, na akibootuu baata kwavulu Yowani. Mu uyiluu umono, Yiisu nde makulu a akibootuu pe, ka miyii mia nde miakibootuu. Yiisu bu ayuyi mabakileele, nde amati ku itinini kia Yuuda, na avutii ku itinini kia Ngalili. ");
INSERT INTO iyx_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Mu uto ku Ngalili, toono nde ataba itinini kia Samaria. ");
INSERT INTO iyx_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nde atoori bebele na ngaanda a Samaria mosi, ya kuumbu Sikare. Ngaanda yii, ali bebele na itsuru kia tsi ki Yaakobi ahi kwaa mwaana a nde Yoosefi. ");
INSERT INTO iyx_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Nhaa, mwali na idunu kia maamba kia Yaakobi. Bu nyutu yalemi Yiisu mu ndaa midieenge, nde adiaali nha peembi a idunu. Ali ka helape nguungu ya nzanga. ");
INSERT INTO iyx_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Musi Samaria mosi wa mukaasa ayiri ku uyatee maamba, na Yiisu wamuleeli: «Ha me maamba ma unywa.» ");
INSERT INTO iyx_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Mu taanga me dii, miyii mia nde miali miayeni ku ngaanda, mu uyasuumbu bia udia. ");
INSERT INTO iyx_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Musi Samaria me wuu aleeli kwaa Yiisu: «We Muyuudayo li! Buni we utuu uloombo maamba kwaa me, musi Samaria?» Mukaasa aleeli buu mundaa ti, Bayuudayo a bubaayuhusunu pe na basi Samaria. ");
INSERT INTO iyx_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yiisu wamuvutili: «So we ali ayaaba bungori ba Nziaambi anhana uha kwaa we, na so ali ayaaba wuli mu uloombo we maamba ma unywa, we akeni uloombo nde maamba. Nde keni uha we maamba ma moonyi.» ");
INSERT INTO iyx_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mukaasa wamuvutili: «Taata, we a li na ipaayi pe, na idunu ili na musundu. Kuni we utuu ubaa maamba ma moonyi maa? ");
INSERT INTO iyx_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","We avulu kaa a bisi Yaakobi waha bisi idunu ki? Nde makulu anywi maamba ma kio, baana ba nde na biboori bia nde ka bianywiiri mo.» ");
INSERT INTO iyx_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yiisu wamuvutili: «Pasi muutu wu unywa maamba ma, sa abwabaa nyooto a maamba. ");
INSERT INTO iyx_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ka muutu wu unywa maamba ma me niha nde, a ubwaba na nyooto a maamba so hoolo pe. Maamba ma me niha nde, sa maba idia kia maamba kili ukanya pe, sa mabaapalanga mu nde natee mu moonyi wa bilimi na bilimi.» ");
INSERT INTO iyx_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mukaasa wemuleeli: «Taata, ha me maamba maa, paa me nyaala ubwabaa nyooto a maamba. Na, paa me nyaala ubwayiranga nha mu uyatee maamba.» ");
INSERT INTO iyx_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yiisu wamuleeli: «Yene, ta mulumi a we mbili, na yiravutuu nha.» ");
INSERT INTO iyx_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mukaasa wamuvutili: «Me a ndi na mulumi pe.» Na Yiisu wamuleeli: «We tsuyi ngwanya, bu we leeli ti we a li na mulumi pe. ");
INSERT INTO iyx_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Mundaa ti, we ali na balumi bataana, na baala li we li na nde mu taanga di a ali mulumi a we pe. Mu yii, we ngwanya leeli.» ");
INSERT INTO iyx_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ni mu buu mukaasa wamuleeli: «Taata, me ndi mu umono ti we mubili a Nziaambi we li. ");
INSERT INTO iyx_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bakaa ba bisi basi Samaria bakuundi Nziaambi nha yulu a mulaanda wu. Ka beni Bayuudayo, beni dibaaleele ti mbuu yi bafwaana ukuundu Nziaambi ku Yeruselemi yili.» ");
INSERT INTO iyx_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ka Yiisu wamuvutili: «Maama, sa imiini mu ndaa yi, taanga dili mu uyiri, di beni a dibwakuundu pe Taata Nziaambi, so nha yulu a mulaanda wu, so ku Yeruselemi. ");
INSERT INTO iyx_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Beni basi Samaria dibaakuundu Nziaambi kwahele a uyaaba nde. Bisi Bayuudayo dibaakuundu nde na diayaaba nde, mundaa ti liyobolo lamata kwaa Bayuudayo. ");
INSERT INTO iyx_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ka taanga dili mu uyiri, na dio diamaakwato. Taanga di bakuundi ba ngwanya bakaakuundu Taayi, mu Muheebili na mu ngwanya. Mundaa ti ni bakuundi ba pili yii Taayi ali mu usaa. ");
INSERT INTO iyx_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nziaambi Muheebili ali, na ba bukuundu nde, bafwaana ukuundu nde mu Muheebili wuli mu ubiti ku ngwanya.» ");
INSERT INTO iyx_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mukaasa wamuleeli: «Me nayaaba ti Mesiya, wu bubaata Kristo, sa ayiri. Nha nde akaayiri, nde sa ayiisi bisi mandaa moosi.» ");
INSERT INTO iyx_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yiisu wamuvutili: «Me ni Kristo, me wu li mu utsuu na we.» ");
INSERT INTO iyx_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Mu taanga dii, miyii mia Yiisu miayiravutuu. Bo bakimii mu umono nde mu utsuu na mukaasa. Ka bunu, so mosi pe wamufuuli: «Ima we li mu usaa?» so a buu pe: «Ki ndaa we li mu utsuu na nde?» ");
INSERT INTO iyx_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ni mu buu, mukaasa asiisi lisaanga la nde, na avutii ku ngaanda, ku ayileele kwaa baata: ");
INSERT INTO iyx_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Diyamono muutu wu maaleele me mandaa moosi ma me nayiluu. Helape nde ni Kristo!» ");
INSERT INTO iyx_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ninha, baata bapali mu ngaanda, na bayeni kwali Yiisu. ");
INSERT INTO iyx_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mu taanga dii, miyii miakihama mu uloombo kwaa Yiisu: «Muyiisi, dia mwaana a iloo!» ");
INSERT INTO iyx_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ka nde wabavutili: «Me ndi na biloo bia udia, bi beni diahele uyaaba.» ");
INSERT INTO iyx_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Miyii miafulisini bo na bo: «Na muutu wumaabee nde bia udia?» ");
INSERT INTO iyx_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yiisu wabaleeli: «Biloo bia me, ni uyiluu litoono la watsinduu me, na umana isala ki nde aha kwaa me. ");
INSERT INTO iyx_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Baata bubaaleelanga: “Batsuungi bana bamaasala, na sa diba taanga dia ukukuu.” Ka me nadileeli, diyiluu umono matsiee: mbutu dimaayele na diamaayilimi paa bakukuu dio. ");
INSERT INTO iyx_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Wu ukukuu maakwayaka mufutu a nde. Nde li mu ukukuu mbutu paa aswee dio mu moonyi wa bilimi na bilimi. Ni mu buu, mukuni na mukukii sa bayaanga mu itwaari. ");
INSERT INTO iyx_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Mundaa ti, ngwanya baata bubaaleelanga ti: “Muutu mosi ubaakunu, mukimi ubaakukuu.” ");
INSERT INTO iyx_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Me natsinduu beni mu ukukuu mutso tsiee yi beni diahele umono pasi. Babamosi bamoni pasi mu yo, na beni dibayi ndaanda mu isala kia bo.» ");
INSERT INTO iyx_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Basi Samaria babalayi mu ngaanda yii, basi imiini mu Yiisu, mundaa imbaangi kia mukaasa waleeli: «Nde leeli me mioosi mi me nayiluu.» ");
INSERT INTO iyx_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ni mu buu, mu taanga di basi Samaria bayiri kwaa nde, bo bamuloombi mu udiaala na bo. Na Yiisu adiaali nhaa biluumbu bioolo. ");
INSERT INTO iyx_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Baata babasi imiini babwivululu bulayi, mundaa mi Yiisu nde makulu akileele. ");
INSERT INTO iyx_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Bo bakileele kwaa mukaasa: «Mu taanga di, bisi a dili mu usa pe imiini mu ndila ma we leeli kwaa bisi, ka mundaa ti bisi bame dimaayuu nde, na bisi dimaayaaba ti nde ni Muvuuyisi a baata ba tsi.» ");
INSERT INTO iyx_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nha mbisi a biluumbu bioolo, Yiisu ayeni ku Ngalili. ");
INSERT INTO iyx_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yiisu nde makulu ali akwileele: «A bali mu uta imbaangi kwaa mubili mu tsi a nde makulu pe.» ");
INSERT INTO iyx_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ka, mu taanga di nde atoori ku Ngalili, baata ba itinini kii bayaki nde bubwe. Bo bamoni mioosi mi nde ayilii ku Yeruselemi mu taanga dia mukuungi a Paaka. Mundaa ti bo ka ali bayeni ku mukuungi wuu. ");
INSERT INTO iyx_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ninha, Yiisu avutii ku ngaanda a Kaana mu itinini kia Ngalili, ku nde akitisi maamba viinyi. Ku ngaanda a Kapernawumi, kwali na musiali a mutini, wali na mwaana wa baala wali na ubeele. ");
INSERT INTO iyx_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Bu nde ayuyi ti Yiisu maamata ku itinini kia Yuuda, na maato ku Ngalili, nde ayimono Yiisu na wamuloombi mu uyene ku Kapernawumi itwaari na nde. Nde ayilii buu, paa Yiisu ayabeelese mwaana a nde, wali nha peembi a likwa. ");
INSERT INTO iyx_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yiisu wamuleeli: «So beni a dimoni biliimbi bia ukimuu na bimaanga pe, beni a dituu usa imiini so hoolo pe.» ");
INSERT INTO iyx_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Musiali a mutini wamuvutili: «Pfumu, yiri ku nzo a me tswaamina mwaana a me ukwa.» ");
INSERT INTO iyx_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yiisu wamuleeli: «Vutuu ku nzo a we, mwaana a we sa aba moonyi.» Taayi a mwaana wuu, asi imiini mu mi Yiisu aleeli nde, na avutii ku nzo a nde. ");
INSERT INTO iyx_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Bu nde akiyiravutuu, mu taanga di basiali ba nde bayibwaana nde, na bamuleeli: «Mwaana a we maabeeluu!» ");
INSERT INTO iyx_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nde wabafuuli mu ki taanga mwaana a nde abeelii, na bo bamuvutili: «Aba matsii, mu nguungu ya tsiomi nha mbisi a nzanga, nha baa lawa nde.» ");
INSERT INTO iyx_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Taayi a mwaana alibili moonyi ti, ni mu nguungu yii, Yiisu aleeli kwaa nde: «Mwaana a we sa aba moonyi.» Ni mu buu nde asi imiini mu Yiisu, nde na kaanda la nde loosi. ");
INSERT INTO iyx_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kii ali ni iliimbi kia bioolo ki Yiisu ayilii. Nde ayilii kio ku Ngalili, nha mbisi a umata ku Yuuda. ");
INSERT INTO iyx_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nha mbisi a nhaa, Yiisu ayeni ku Yeruselemi ku mukuungi a Bayuudayo. ");
INSERT INTO iyx_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Mu ngaanda yii, mwali na ikotili kia kuumbu «Ikotili kia Mameme». Nha peembi a ikotili kii, mwali na bipaangala bitaana biadiengelele idia kibubaata «Betezata» kwaa Baebeleo. ");
INSERT INTO iyx_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mutso bipaangala bii, ali na koongi a babeeri: bingima-ngimi, bangaa bitonzo na bababobo binama. Bo bakikebe ti maamba manyingini. ");
INSERT INTO iyx_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Mundaa ti taanga dikimi, tumu a Nziaambi akisutuu mutso idia na akinyingisi maamba. Mubeeri watsiomi wu ubwa mu idia, nha mbisi a nha bamaanyingisi maamba, nde ubeeluu mu ibeeri kia nde, so ibeeri kii ibeeri so a buni. ");
INSERT INTO iyx_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ali nhaa na baala limosi lali na ibeeri, umatuu bilimi maku matata na pwoombo. ");
INSERT INTO iyx_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yiisu amoni nde ala nha tsi. Bu nde ayaabi ti nde ali mubeeri umatuu taanga dialaa, Yiisu wamufuuli: «We atoono ubeeluu?» ");
INSERT INTO iyx_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mubeeri wuu wamuvutili: «Pfumu, me a ndi na muutu pe wu utsindili me mutso idia, nha maamba mali mu unyingini. Mu taanga di me nisaa ubwa muu, muutu mukimi amaakwasutuu.» ");
INSERT INTO iyx_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yiisu wamuleeli: «Temene, holo ikala kia we, na yene.» ");
INSERT INTO iyx_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nhaa-na-tsi, baala lii labeelii. Nde aholi ikala kia nde, na ayeni. Ka mandaa maa moosi makiyilimi mu iluumbu kia saba. ");
INSERT INTO iyx_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ni mu buu bakuutu ba Bayuudayo baleeli kwaa baala labeelii: «Lolo iluumbu kia saba, mikele a mili mu uha we muswa pe mu ubiti ikala kia we.» ");
INSERT INTO iyx_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nde wabavutili: «Wubeelisi me, maaleele kwaa me bu: “Holo ikala kia we, na yene.”» ");
INSERT INTO iyx_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ni mu buu, bo bamufuuli: «Na maleele we: “Holo ikala kia we, na yene”?» ");
INSERT INTO iyx_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ka baala labeelii a ayaabi wamubeelisi pe, mundaa ti Yiisu akoti kutso koongi yali nhaa, na a abwimonuu pe. ");
INSERT INTO iyx_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Nha mbisi a nhaa, Yiisu abwaani nde mutso lipaanga la nzo a Nziaambi, na wamuleeli: «Mono! We maabeeluu mu taanga di. A bwasa masumu pe, paa ndaa yavulu bubi yinyaala ubwiilili we.» ");
INSERT INTO iyx_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tumake, baala lii layileele kwaa bakuutu ba Bayuudayo ti, ni Yiisu muutu wabeelisi nde. ");
INSERT INTO iyx_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ni mu buu, bo babaandii ukwaamisa Yiisu, mundaa ti nde ayilii mandaa maa mu iluumbu kia saba. ");
INSERT INTO iyx_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ka Yiisu wabaleeli: «Taayi a me li mu usala taanga dioosi, na me ka ndi mu usala.» ");
INSERT INTO iyx_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Mu ndaa a ndaa yii, bakuutu ba Bayuudayo babwisaa mu iteesi kiavululu mu udusu Yiisu. Bo bali na kesi a nde. Mundaa ti nde a akiinzi pe mukele a saba, na mundaa ti nde aleele ka ti Nziaambi li Taayi a nde. Mu mandaa maa, nde akimweese ti nde li iteesi mosi na Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yiisu abwileele kwaa bo: «Ee-e, ngwanya me nadileeli: Mwaana a utuu uyiluu ndaa so mosi pe mu inde makulu. Nde uyiluu ndila ma ali mu umono Taayi mu uyiluu. Moosi ma Taayi ali mu uyiluu, Mwaana ka li mu uyiluu bumosi. ");
INSERT INTO iyx_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mundaa ti Taayi atoono Mwaana, na li mu ulaa nde bioosi bi nde makulu Taayi ali mu uyiluu. Nde sa wamulaa bisala biabwavulu biinabi mu bunene, na beni sa dikimuu. ");
INSERT INTO iyx_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ka, weti bu Taayi ali mu usiimbili babakwa, na li mu uha bo moonyi, bumosi ka Mwaana li mu uha moonyi kwaa wu nde atoono. ");
INSERT INTO iyx_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Na Taayi a li mu ufuundusu muutu pe, ka nde aha kwaa Mwaana litu loosi la ufuundusu. ");
INSERT INTO iyx_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Nde aha mwaana litu loosi la ufuundusu, paa boosi baha buzitu kwaa Mwaana weti bu bali mu uha buzitu kwaa Taayi. Wu uhele uha buzitu kwaa Mwaana, a li mu uha pe ka buzitu kwaa Taayi watsinduu nde. ");
INSERT INTO iyx_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ee-e, ngwanya me nadileeli: pasi wu uyuu mandaa ma me, na siiri imiini mu watsinduu me, bayi moonyi wa bilimi na bilimi. A bufuundusu nde pe, ka nde mata ku likwa, na nde ka moonyi. ");
INSERT INTO iyx_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ee-e, ngwanya me nadileeli: taanga dili mu uyiri, na dio diamaakwato, di babakwa bakaayuu muniingi a ndaa a Mwaana a Nziaambi, na babuyuu nde sa baba moonyi. ");
INSERT INTO iyx_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mundaa ti, weti bu Taayi ali na moonyi mu inde makulu, bumosi ka nde aha muswa kwaa Mwaana mu uba idia kia moonyi. ");
INSERT INTO iyx_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na nde aha kwaa Mwaana nde litu la ufuundusu baata, mundaa ti nde li Mwaana a muutu. ");
INSERT INTO iyx_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","A dikimuu pe, mundaa ti taanga dili mu uyiri, di boosi babakwa bali mu mangili, bakaayuu muniingi ndaa a Mwaana a muutu. ");
INSERT INTO iyx_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Bo sa bapala mu mangili ma bo. Babayilii mandaa ma mabwe sa basiimbuu mu ubaa moonyi. Ka babayilii ma mabi sa basiimbuu mu uyaka tsieembili. ");
INSERT INTO iyx_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Me a nituu pe uyiluu ndaa so mosi mu ime makulu. Me ndi mu ufuundusu weti bu Nziaambi ali mu uleele kwaa me. Pfuundisi a me yili yasuungunu, mundaa ti me a ndi mu usaa pe uyiluu mi me natoono, ka litoono la watsinduu me.» ");
INSERT INTO iyx_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«So me teeri imbaangi mu nyutu a me makulu, imbaangi kia me a kiafwaana pe. ");
INSERT INTO iyx_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ka uli na muutu mukimi wuli mu uta imbaangi mu me, na me nayaaba ti imbaangi ki nde ali mu uta mu me, ili kia ngwanya. ");
INSERT INTO iyx_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Beni diatsinduu batumu kwaa Yowani, na nde teeri imbaangi mu ngwanya. ");
INSERT INTO iyx_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Me a ndi na nzala pe ti bata imbaangi mu me. Ka mbiiti me ndi mu uleele beni buu, paa beni diyobuu. ");
INSERT INTO iyx_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yowani ali weti mwiindi wu bali mu unamisa paa ayalisa. Beni diatooni uyaanga mu liyalila la nde mu mwaana a taanga hoolo. ");
INSERT INTO iyx_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ka me ndi na imbaangi mu me, kiavulu bunene na imbaangi kia Yowani: bisala bi Taayi aha me mu ukuusu. Bisala bi me ndi mu usa bi, bili mu uta imbaangi mu me. Bio bili mu umweese ti Taayi atsinduu me. ");
INSERT INTO iyx_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Na Taayi watsinduu me, li mu uta ka imbaangi mu me. Ka beni a diayuyi ndaa a nde so hoolo pe, na keni a diamono kiinzi kia nde pe. ");
INSERT INTO iyx_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Mandaa ma nde a mali mu udiaala pe mu beni, mundaa ti beni a dili mu usa pe imiini mu wu nde atsinduu. ");
INSERT INTO iyx_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Beni dili mu uyii Mabasonuu ma Ngira mu bungeele boosi, mundaa ti beni dili mu utsimi ti beni sa dibaa moonyi wa bilimi na bilimi mu mo. Ka bunu, ni mo mali mu uta imbaangi mu me! ");
INSERT INTO iyx_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Bunu, beni a diatoono pe uyiri kwaa me mu ubaa moonyi. ");
INSERT INTO iyx_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Buzitu ba me a bali mu umata pe kwaa baata. ");
INSERT INTO iyx_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ka me nayaaba beni, na me nayaaba ti beni a dili na litoono mu Nziaambi pe. ");
INSERT INTO iyx_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mbiiti muutu mukimi yiri mu kuumbu a nde makulu, beni sa diamuyaka. Ka me nayiri mu kuumbu a Taayi a me, na beni dili mu ubisi uyaka me. ");
INSERT INTO iyx_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Buni beni dituu usa imiini? Beni ba dibaayaka buzitu ba beni bana mu bana, na a dili mu usaa pe buzitu bali mu umata kwaa Nziaambi nde makulu. ");
INSERT INTO iyx_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ka a ditsimi pe me sa fuundu beni kwaa Taayi a me. Ka Mooso kaafuundu beni, Mooso wu beni diasa ilimbisi mu nde. ");
INSERT INTO iyx_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","So beni diali diasa imiini mu Mooso, beni diakeni usa ka imiini mu me, mundaa ti nde asonii mu ndaa me. ");
INSERT INTO iyx_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ka so beni a disiiri imiini pe mu ma nde asonuu, buni beni disa imiini mu mandaa ma me ndi mu uleele?» ");
INSERT INTO iyx_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nha mbisi a nhaa, Yiisu ayeni ku simi li limosi la diaanga la Ngalili, libakita ka diaanga la Tiberiade. ");
INSERT INTO iyx_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Koongi a baata yinene yakiduku nde, mundaa ti baata bakimono biliimbi bia kimikimi bi nde akiyiluu mu ubelisa babeeri. ");
INSERT INTO iyx_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yiisu ahaati nha mulaanda na adiaali kuu na miyii mia nde. ");
INSERT INTO iyx_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Mukuungi a Bayuudayo wa Paaka, ali ka bebele. ");
INSERT INTO iyx_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Bu Yiisu asiimbili misi na amoni ti koongi a baata yinene yakiyiri kwaa nde, nde afuuli Filipo: «Kuni bisi dituu usuumbu mapa malaa mu uha bia udia kwaa baata ba boosi?» ");
INSERT INTO iyx_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yiisu ali aleeli buu mu ukete Filipo, mundaa ti Yiisu ali akwayaaba mi nde anhana usa. ");
INSERT INTO iyx_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipo wamuvutili: «So mu makama moolo ma mikuti mia mboongo, a dituu pe usuumbu mapa mamukuu bo boosi, paa mosi na mosi mu bo abaa mwaana a itsuru.» ");
INSERT INTO iyx_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Wu mu mosi mu miyii mia nde, Andere, mwaana a nguu a Simooni Peetero, aleeli kwaa nde: ");
INSERT INTO iyx_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Nha na nha uli na mufuru a baala wuli na mapa mataana ma oreze na batswi boolo. Ka mwaana a bii, ima bituu usa nha kulu a koongi a baata ba boosi?» ");
INSERT INTO iyx_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yiisu aleeli ti baata boosi badiaala. Ali na bitiiti bialaa nha mbuu yii, ninha baata badiaali nha tsi. Litaanga la babaala ali utuu uto mafuundu mataana. ");
INSERT INTO iyx_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yiisu aholi mapa, na nha mbisi a uvutulu matoono kwaa Nziaambi, nde akabi mo kwaa babali nhaa. Bumosi ka, nde abwiha bo batswi weti bu bo bali batoono. ");
INSERT INTO iyx_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Mu taanga di bo boosi badiiri mu tsitsi a yuutu la bo, Yiisu aleeli kwaa miyii mia nde: «Ditolo bitsuru bisiaali, paa ti iloo so imosi inyaala udiimbili.» ");
INSERT INTO iyx_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Bo batoli bio, na baluusi mapwooyi kuumi na moolo mu bitsuru biasiaali mu mapa mataana ma oreze, ma baata badi. ");
INSERT INTO iyx_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Baata bu bamoni iliimbi kiayilii Yiisu, baleeli: «Mu ngwanya, wu ni mubili waba wafwaana mu uyiri nha tsi!» ");
INSERT INTO iyx_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yiisu ali ayaaba ti bakeni uyaholo nde mu mifuri, mu usuusu nde aba mutini a bo. Ni mu buu, nde abwiyene ku yulu a mulaanda, nde bake. ");
INSERT INTO iyx_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tsitsii bu yatoori, miyii mia Yiisu miasutii ku mukoo a diaanga. ");
INSERT INTO iyx_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bo bakoti mu bootu mu usabuu diaanga na uyene ku ngaanda a Kapernawumi. Butsuu ali bumaato, na Yiisu ali keni a ayiri pe mu uba itwaari na bo. ");
INSERT INTO iyx_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Maamba ma diaanga makinyingini mundaa ti ali na iteembi kia mifuri. ");
INSERT INTO iyx_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Miyii ali miamaatakuu na simi, mu iteesi kia bakilometre bataana so a buu pe basamina. Mu taanga di bo bamoni Yiisu mu udiaata nha yulu a mukaanda a maamba ma diaanga, mu uyiri kwaa bo, bo babayi boomo balaa. ");
INSERT INTO iyx_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ka Yiisu wabaleeli: «Ni me wa me, a diba na boomo pe!» ");
INSERT INTO iyx_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Miyii miasiayi ulooso nde mu bootu, ka nhaa-na-tsi, bootu batoori ku bo bakiyene. ");
INSERT INTO iyx_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mu iluumbu kiaduki, baata boosi babali basaala ku simi la diaanga li limosi bayaabi ti, nhaa mwali na ndila bootu limosi. Baata bayaabi ti Yiisu a akoti pe itwaari na miyii mia nde mu bootu lii, ka miyii mia nde miayeni mio bake. ");
INSERT INTO iyx_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ka mabootu makimi mamakimata ku ngaanda ya Tiberiade, matoori bebele na mbuu yibadiiri mapa, nha mbisi a likuundu la Pfumu la mvutili a matoondo. ");
INSERT INTO iyx_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mu taanga di baata bamoni ti Yiisu na miyii mia nde a bali nhaa pe, bo bakoti mu mabootu maa, na bayeni ku ngaanda ya Kapernawumi mu uyasaa nde. ");
INSERT INTO iyx_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bo bayibaasa Yiisu ku simi la diaanga lilikimi, na bamuleeli: «Muyiisi, mu ki taanga we toori nha?» ");
INSERT INTO iyx_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yiisu wabavutili: «Ee-e, mu ngwanya me nadileeli: beni dili mu usaa me, a mundaa pe ti, beni dimaayiluu uyaaba tsutulu a biliimbi bia kimi-kimi bi me nzilii. Ka beni dili mu usaa me, mundaa ti beni didiiri mapa mu tsitsi a yuutu la beni. ");
INSERT INTO iyx_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","A disala pe mundaa biloo bibifuu. Ka disala mundaa biloo bibidiingi, na bili iteeli kia moonyi wa bilimi na bilimi. Biloo bii, Mwaana a muutu sa wadiha bio, mundaa ti Nziaambi, Taayi, anaa nha yulu a nde iliimbi kia litumu la nde.» ");
INSERT INTO iyx_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Bo bamufuuli: «Ima bisi diafwaana usa mu ukuusu bisala bi Nziaambi atoono?» ");
INSERT INTO iyx_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yiisu wabavutili: «Isala ki Nziaambi asaa kwaa beni, ni usa imiini mu wuu wu nde atsinduu.» ");
INSERT INTO iyx_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Bo bamuleeli: «Ki iliimbi we utuu umweese kwaa bisi, paa bisi disa imiini mu we? Ima we usa? ");
INSERT INTO iyx_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Bakaa ba bisi badi mapa ma maane mu tsi ya tsata, weti buli mu uleele Mabasonuu ma Ngira: “Nde wabaheeri mapa mamamati ku yula.”» ");
INSERT INTO iyx_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yiisu wabavutili: «Ee-e, ngwanya me nadileeli: a Mooso pe ahi beni lipa lamati ku yula, ka Taayi a me li mu uha beni lipa la ngwanya lili mu umata ku yula. ");
INSERT INTO iyx_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Mundaa ti lipa la Nziaambi, ni wuu wuli mu umata ku yula, na wuli mu uha moonyi kwaa baata boosi ba nha tsi.» ");
INSERT INTO iyx_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Bo bamuleeli: «Pfumu, baahaanganga bisi lipa lii taanga dioosi.» ");
INSERT INTO iyx_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yiisu abwileele: «Me ni lipa la moonyi. Wu uyiri kwaa me a ubwaba na nzala pe, na wu usa imiini mu me a ubwaba na nyooto pe. ");
INSERT INTO iyx_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ka weti bu me nadileeli: beni dimaamono me, ka bunu beni a dili mu usa imiini pe. ");
INSERT INTO iyx_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Pasi nde mu baa ba Nziaambi ali mu uha kwaa me, sa ayiri kwaa me, na me a nibaabingi pe wu uyiri kwaa me. ");
INSERT INTO iyx_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Mundaa ti me a namati pe ku yula mu uyiluu litoono la me makulu, ka mu uyiluu litoono la watsinduu me. ");
INSERT INTO iyx_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na mono bwatoono watsinduu me: me nyaala udiimbisi so mosi mu ba nde aha kwaa me. Ka me siimbili bo mu babakwa mu iluumbu kia tsieelele. ");
INSERT INTO iyx_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ee-e, mono bwatoono Taayi a me: boosi babali mu umono Mwaana, na babali mu usa imiini mu nde, babaa moonyi wa bilimi na bilimi, na me siimbili bo mu babakwa mu iluumbu kia tsieelele.» ");
INSERT INTO iyx_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Bayuudayo basiiri Yiisu saa mundaa ti nde aleeli: «Me ni lipa lamati ku yula.» ");
INSERT INTO iyx_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Bo bakileele: «Wu a ni Yiisu pe, mwaana a Yoosefi? Bisi diayiluu uyaaba taayi a nde na nguu a nde. Buni, mu taanga di nde utuu uleele ti: “Me namati ku yula.”» ");
INSERT INTO iyx_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yiisu wabavutili: «Dinyaala unhunhunyu nha kati a beni. ");
INSERT INTO iyx_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Muutu pe wu utuu uyiri kwaa me so Taayi watsinduu me a tiiri nde mbili pe. Na, me sa siimbili nde mu babakwa mu iluumbu kia tsieelele. ");
INSERT INTO iyx_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Mibili miasonii mandaa ma: “Nziaambi sa ayiisi bo boosi.” Ni mu buu, pasi muutu wuli mu uyuu Taayi, na wuli mu uyaka nziisili a nde, li mu uyiri kwaa me. ");
INSERT INTO iyx_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Muutu pe so mosi wamaamono Taayi, ka ndila wamata kwaa Nziaambi amono Taayi. ");
INSERT INTO iyx_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ee-e, ngwanya me nadileeli: wu usa imiini mu nde, li na moonyi wa bilimi na bilimi. ");
INSERT INTO iyx_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","«Me ni lipa la moonyi. ");
INSERT INTO iyx_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Bakaa ba beni badiiri maane ku tsi ya tsata, na bo bamaakwa. ");
INSERT INTO iyx_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ka lipa lili mu umata ku yula, lili ti muutu wu udia lo, a ukwa pe. ");
INSERT INTO iyx_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Me ni lipa la moonyi limati ku mayula. So muutu diiri lipa li, nde sa aba moonyi taanga dioosi. Lipa li me niha paa tsi yiba moonyi, ni nyutu a me.» ");
INSERT INTO iyx_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Mu ndaa yii, Bayuudayo bakaami kwa mifuri bo na bo. Bo bafuuli: «Buni muutu wu utuu uha bisi nyutu a nde mu udia?» ");
INSERT INTO iyx_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yiisu avutili: «Ee-e, ngwanya me nadileeli: so beni a didiiri pe nyutu a Mwaana a muutu, na so beni a dinywiiri makili ma nde pe, beni a diba na moonyi mu beni pe. ");
INSERT INTO iyx_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mundaa ti muutu wu udia nyutu a me, na wu unywa makili ma me li na moonyi wa bilimi na bilimi, na me sa namusiimbili mu babakwa mu iluumbu kia tsieelele. ");
INSERT INTO iyx_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Mundaa ti nyutu a me yili biloo bia ngwanya, na makili ma me mali bia unywa bia ngwanya. ");
INSERT INTO iyx_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ni mu buu, wu udia nyutu a me, na unywa makili ma me sa aba mu me, na me ka sa ba mu nde. ");
INSERT INTO iyx_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Taayi watsinduu me li moonyi, na me ndi moonyi mu nde. Bumosi ka, wu udia nyutu a me, sa aba moonyi mu me. ");
INSERT INTO iyx_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ka mono lipa limati ku yula. Lo a lili pe weti ladi bakaa ba beni, babakwi. Ka wu udia lipa li, sa aba moonyi mu taanga dioosi.» ");
INSERT INTO iyx_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yiisu aleeli mandaa maa bu nde akiyiisi mu nzo a makutunu ma Bayuudayo ya ku Kapernawumi. ");
INSERT INTO iyx_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Babalayi mu miyii mia nde miakiyuu nde, mialeeli: «Nziisili yi yili ya pasi mu usiingi! Na utuu usiingi?» ");
INSERT INTO iyx_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yiisu ali ayiluu uyaaba ti miyii mia nde miaba mu unhunhunyu mu ndaa yii. Ni mu buu nde wabaleeli: «Nziisili yii yimweesi beni pasi mu mitimi? ");
INSERT INTO iyx_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ka beni buni dikaasa so dimoni Mwaana a muutu mu uhaata ku yula ku nde ali tsiomi? ");
INSERT INTO iyx_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ni Muheebili a Nziaambi li mu uha moonyi. Musunyi a ali na ndutu pe. Mandaa ma me maaleele beni mali Muheebili na moonyi. ");
INSERT INTO iyx_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ka nha kati a beni uli na bali mu uhele usa me imiini.» Ka bunu, umatuu mu mbaandili, Yiisu ali ayaaba bana bakihele usa imiini na, na kaayeelele nde. ");
INSERT INTO iyx_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nde abwileele: «Ni mu buu me maaleele beni ti, muutu pe wu utuu uyiri kwaa me so, Tata Nziaambi aheeri pe nde muswa mu uyiri kwaa me.» ");
INSERT INTO iyx_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Umatuu mu taanga dii, balayi mu miyii mia nde basiisi na banyaali ubwadieenge na nde. ");
INSERT INTO iyx_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ni mu buu Yiisu afuuli kwaa miyii kuumi na mioolo: «Beni ka ditooni uyene?» ");
INSERT INTO iyx_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simooni Peetero wamuvutili: «Pfumu, kwaa na bisi diyene? We li na mandaa mali mu uha moonyi wa bilimi na bilimi. ");
INSERT INTO iyx_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Bisi diasa imiini na diayaaba ti, we ni wuu wa Ngira, wu Nziaambi atsinduu!» ");
INSERT INTO iyx_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yiisu wabavutili: «A me pe nasoolo beni kuumi na boolo? Ka bunu, mosi mu beni li musiali a Saatina!» ");
INSERT INTO iyx_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nde mu ndaa Yuuda akitsuu, mwaana a Simooni Isikarioti. Mundaa ti Yuuda, so bu nde ali mosi mu miyii kuumi na mioolo, sa ayaluu Yiisu. ");
INSERT INTO iyx_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nha mbisi a nhaa, Yiisu akiyene adieenge mu itinini kia Ngalili. Nde ali a atoono pe utaba mangaanda ma Yuuda, mundaa ti bakuutu ba Bayuudayo bakisaa udusu nde. ");
INSERT INTO iyx_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mukuungi a Bayuudayo wa Bituru ali ka bebele. ");
INSERT INTO iyx_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Baana banguu ba Yiisu bamuleeli: «Mata nhana yene ku Yuuda, paa miyii mia we, mio ka, mimono bimaanga bi we li mu usa. ");
INSERT INTO iyx_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","A uli na muutu pe wu ubaasala mu tsweeyi, mbii ti nde li na nzala ya uyabina kwaa baata. Bu yili ti we li mu uyiluu bimaanga bia pili yii, bubwe we yabina kwaa baata boosi.» ");
INSERT INTO iyx_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Mundaa ti, baana ba nguu ba nde bo makulu a bakisa pe imiini mu nde. ");
INSERT INTO iyx_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yiisu wabaleeli: «Taanga dia me keni a diafwaana pe. Ka kwaa beni, taanga dioosi koo dimbwe. ");
INSERT INTO iyx_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Baata ba tsi a butuu ubele beni pe, ka bo bali na ibelili mu me, mundaa ti me ndi mu uta imbaangi ti, biyiluu bia bo bili bibibi. ");
INSERT INTO iyx_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Beni ni bali, diyene wa beni ku mukuungi. Me a niyene pe ku mukuungi wuu, mundaa ti taanga dia me keni a diafwaana pe.» ");
INSERT INTO iyx_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nha mbisi a uleele buu, nde asiaali ku itinini kia Ngalili. ");
INSERT INTO iyx_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ka mu taanga di baana ba nguu ba nde bayeni ku mukuungi, Yiisu ka ayeni kuu. Ka nde a ayeni pe nha kulu a baata, ka mu tsweeyi nde ayeni kuu. ");
INSERT INTO iyx_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Bakuutu ba Bayuudayo bamusiayi ku mukuungi wuu, na bakifulusunu: «Nde kuni ali?» ");
INSERT INTO iyx_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mutso koongi, baata bakitsuu kwalaa mu nde. Babamosi bakileele: «Nde muutu wu mubwe ali.» Ka babakimi ti: «Pia, nde muutu wu mubi ali, nde li mu udiimbisi baata.» ");
INSERT INTO iyx_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ka muutu pe so mosi wakitsuu mu nde nha kulu a baata. Mundaa ti bo boosi bali na boomo ba bakuutu ba Bayuudayo. ");
INSERT INTO iyx_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Bu mukuungi ali maato nha kati a kati, Yiisu ayeni ku nzo a Nziaambi na abaandii uyiisi. ");
INSERT INTO iyx_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Bayuudayo bakikimuu na bakifulusunu: «Buni nde ali mu uyaaba mandaa ma Nziaambi moosi, nde wahele uyii?» ");
INSERT INTO iyx_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yiisu wabavutili: «A nziisili a me pe me ndi mu uha, ka nziisili a watsinduu me. ");
INSERT INTO iyx_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Watoono uyiluu litoono la Nziaambi, sa ayaaba ti nziisili a me kwaa Nziaambi yili mu umata. Na nde sa ayaaba ka ti, me a mu litumu la me makulu pe, me ndi mu utsuu. ");
INSERT INTO iyx_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Wu utsuu mu kuumbu a nde makulu, li mu usaa buzitu mu nde makulu. Ka wu li mu usaa buzitu ba watsinduu nde, li mu uta ngwanya, na a uli na ndaa ya pia mu nde pe. ");
INSERT INTO iyx_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mooso a ahi pe beni Mikele? Ka so mosi pe mu beni li mu usalila mio mu kuulu yafwaana. Mu ima beni dili mu usaa udusu me?» ");
INSERT INTO iyx_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Baata ba mu koongi bamuvutili: «We li na muheebili wu mubi! Na li mu usaa udusu we?» ");
INSERT INTO iyx_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yiisu wabavutili: «Me ndila imaanga imosi me maayiluu, na beni boosi dili mu ukimuu! ");
INSERT INTO iyx_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mooso aloombi beni mu ukese bibabaana bia babaala. Ka bunu, tumini dii a diamata pe kwaa nde, ka kwaa bamwakaa ba bisi ba tsiomi. Ka bu yili ti ni buu Mooso aloombi beni, beni dili mu usiingi mu ukese muutu mu iluumbu kia saba. ");
INSERT INTO iyx_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Beni dili mu ukese muutu mu iluumbu kia saba, mu ukiinzi Mikele mia Mooso. Ka mu ima beni dili na kesi a me, mundaa ti me maabeelese muutu wu mubiimbili mu iluumbu kia saba? ");
INSERT INTO iyx_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Dinyaala ufuundusu ndila mu ma beni dili mu umono mu misi mia beni, ka difuundusu bwafwaana.» ");
INSERT INTO iyx_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Babamosi mu basi Yeruselemi bakifulusunu: «A ni nde pe wu bali mu usaa udusu? ");
INSERT INTO iyx_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Dimono: nde li mu utsuu nha kulu a baata, na bo a bali mu uleele ndaa so mosi pe! Helape bakuutu ba bisi bamaayaaba ti ngwanya nde ni Kristo. ");
INSERT INTO iyx_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ka taanga di Kristo akaayira, muutu so mosi pe kaayaaba kuni nde akaamata. Ka bunu, nde wu, bisi diayaaba ku nde amata.» ");
INSERT INTO iyx_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yiisu akiyiisi mutso lipaanga la nzo a Nziaambi. Nde aloyi: «Aka me, beni diayaaba me? Beni diayaaba kuni me namata? Ka bunu, me a nayiri pe mu litumu la me makulu. Wuu watsinduu me li afwaana ti basa ilimbisi mu nde. Ka beni a diayaaba nde pe. ");
INSERT INTO iyx_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Me nayaaba nde, mundaa ti, me kwaa nde namata, na nde atsinduu me.» ");
INSERT INTO iyx_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ni mu buu, bo basiayi ukaanga nde. Ka muutu pe wanayi koo kia nde nha yulu a Yiisu, mundaa ti taanga dia nde ali keni a diato pe. ");
INSERT INTO iyx_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ka bunu, mutso koongi baata balaa basi imiini mu nde. Bo bakileele: «Nha Kristo akaayira, nde sa ayiluu biliimbi bia kimi-kimi biavulu bi muutu wu ali mu uyiluu.» ");
INSERT INTO iyx_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Bafarisi bayuyi mabakinhunhunyu mutso koongi, mu ndaa a Yiisu. Ni mu buu, banguu ba bangaanga ba Nziaambi, na Bafarisi batsindii bakebi ba nzo a Nziaambi mu uyakaanga Yiisu. ");
INSERT INTO iyx_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yiisu aleeli: «Me keni na beni mu mwaana a taanga hoolo. Tumake, me sa yene kwaa watsinduu me. ");
INSERT INTO iyx_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Beni sa disaa me, ka a disololo me pe. Ku me kaaba, beni a dituu uyiri kuu pe.» ");
INSERT INTO iyx_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Bayuudayo bafulisini nha kati a bo: «Kuni nde anhana uyene paa bisi dikoono usololo nde? Kwaa Bayuudayo batsaamuu kutso basi Eleene, na ubiti nziisili a nde kwaa basi Eleene? ");
INSERT INTO iyx_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Mandaa ma nde aleeli ma, tsutulu ma? “Beni sa disaa me, ka beni a disololo me pe. Ku me kaaba, beni a dituu uyiri kuu pe!”» ");
INSERT INTO iyx_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Mu iluumbu kia mukuungi kia tsieelele, ni iluumbu kiavulu ndutu, Yiisu atemini na aloyi: «So muutu li na nyooto, nyaala ayiri kwaa me, na anywa. ");
INSERT INTO iyx_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Weti buli mu uleele Mabasonuu ma Ngira: “Wuu wuli mu usa imiini mu me, manziali ma maamba ma moonyi sa mapala mu mutimi a nde.”» ");
INSERT INTO iyx_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yiisu akileele buu, mu ndaa a Muheebili a Nziaambi, wu babakisa imiini mu nde bakaayaka. Ka mu taanga dii, Muheebili a Nziaambi ali keni a baha pe. Mundaa ti Yiisu ali keni a amonuu pe mu buzitu ba nde. ");
INSERT INTO iyx_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nha mbisi a uyuu mandaa maa, baata babamosi mutso koongi bakileele: «Ngwanya muutu wu ni mubili wayaabisi Mooso!» ");
INSERT INTO iyx_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Babakimi bakileele: «Nde ni Kristo!» Ka babakimi ka bakifuulu: «Ngwanya Kristo utuu uba musi Ngalili? ");
INSERT INTO iyx_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Mabasonuu ma ngira a mali mu uleele pe ti, Kristo sa aba wa mu likaanda la mutini Daavidi? Na mo a mali mu uleele ka pe ti, nde sa aba musi Betelemi, bula bakidiaala mutini Daavidi?» ");
INSERT INTO iyx_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ni mu buu, kabini yakoti nha kati a baata mu ndaa a Yiisu. ");
INSERT INTO iyx_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Babamosi mu bo bakisaa ti bakaanga Yiisu, ka muutu so mosi pe wanayi koo nha yulu a nde. ");
INSERT INTO iyx_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Bakebi ba nzo a Nziaambi babali batsinduu mu ukaanga Yiisu bavutii. Banguu ba bangaanga ba Nziaambi na Bafarisi babafuuli: «Mu ima beni dihele ubee nde?» ");
INSERT INTO iyx_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Bakebi bavutili: «Keni a diamono pe muutu so mosi wuli mu utsuu weti nde!» ");
INSERT INTO iyx_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Bafarisi bavutili: «Beni ka dimaasiingi mandaa ma nde? ");
INSERT INTO iyx_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Uli na mukuutu so mosi, so a buu pe, Mufarisi so mosi wasa imiini mu nde? ");
INSERT INTO iyx_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ka baata babahele uyaaba mikele mia Mooso ba, basibi bo!» ");
INSERT INTO iyx_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemo, mosi mu Bafarisi, ali nhaa. Ni nde, muutu wakwiyamono Yiisu tsiomi. Nde aleeli kwaa bo: ");
INSERT INTO iyx_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Mikele mia bisi a mili mu ufuundusu pe muutu, kwahele a ukwayuu nde, na uyaaba ma nde ayiluu.» ");
INSERT INTO iyx_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Bo bamuvutili: «Buni, we ka musi Ngalili? Kengese Mabasonuu ma Ngira, na we sa mono ti a uli na mubili so mosi pe, wapala mu itinini kia Ngalili.» ");
INSERT INTO iyx_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tumake, muutu muutu avutii ku nzo a nde. ");
INSERT INTO iyx_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yiisu ayeni ku mulaanda Olive. ");
INSERT INTO iyx_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ngwaali a ngwaali, nde avutii ku nzo a Nziaambi, na baata boosi bayiri nha peembi a nde. Nde adiaali na abaandii uyiisi bo. ");
INSERT INTO iyx_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Bayiisi ba mikele na Bafarisi babeyi kwaa Yiisu, mukaasa mosi wu bo bakaangi mu usoongo. Bo basuusi nde nha kati a kati a baata boosi. ");
INSERT INTO iyx_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ninha bo bafuuli Yiisu: «Muyiisi, mukaasa wu bamaakaanga nde mu usoongo. ");
INSERT INTO iyx_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mu Mikele mia mubili Mooso nde aha bisi litumu la udusu mukaasa wa pili yi mu mamanya. Ka we, ima we leeli?» ");
INSERT INTO iyx_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bo bamufuuli nduru yii, mu ulebuu nde mweete, paa babaa bwa ufuundu nde. Ka Yiisu abaandini, na abaandii usonuu nha tsi mu muleembi a nde. ");
INSERT INTO iyx_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ka bu bo bahanini mu ufuulu nde manduru, Yiisu atemini, na aleeli: «Nyaala muutu wuli keni a asa masumu pe, nha kati a beni, atete nde limanya la tsiomi.» ");
INSERT INTO iyx_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tumake, Yiisu abwibaandina, na ahami mu usonuu nha tsi. ");
INSERT INTO iyx_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Bu Bafarisi bayuyi buu, bo bayeni wunu nha mbisi a wunu, ubaanduu mu wavulu bukuutu. Nha mbisi a mandaa maa, Yiisu asiaali nde bake na mukaasa wali mu mutele, nha kulu a nde. ");
INSERT INTO iyx_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ninha Yiisu atemini na wamuleeli: «Maama, ninha bo kuni bali? Muutu pe so mosi wu sieembi we?» ");
INSERT INTO iyx_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mukaasa avutili: «Muutu pe Pfumu.» Yiisu ninha avutili kwaa nde: «Me ka a nisieembe pe we. We utuu uyene wa we. Ka umatuu mu taanga di, a bwasa masumu pe.» ");
INSERT INTO iyx_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yiisu abwileele kwaa bo: «Me ni liyalila la tsi. Wu uduku me, a udiaata pe kutso pimisi, ka nde sa abaa liyalila la moonyi.» ");
INSERT INTO iyx_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Bafarisi baleeli kwaa nde: «We li mu uta imbaangi mu we makulu. Ni mu buu, imbaangi kia we ili kia pia.» ");
INSERT INTO iyx_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yiisu wabavutili: «So me ndi mu uta imbaangi mu me makulu, ka diyuluu uyaaba ti, imbaangi kia me ili kia ngwanya. Mundaa ti, me nayaaba kuni me namata, na kuni me ndi mu uyene. Ka beni, a diayaaba pe kuni me namata, so a buu pe, kuni me ndi mu uyene. ");
INSERT INTO iyx_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Beni dili mu ufuundusu mu imuutu. Ka me a ndi mu ufuundusu muutu pe. ");
INSERT INTO iyx_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Na mbiiti me fuundisi muutu, pfuundisi a me yili ya ngwanya. Mundaa ti me a ndi pe me bake, Taayi watsinduu me li itwaari na me. ");
INSERT INTO iyx_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mu mikele mia beni, basonuu ti utuu usiingi imbaangi kia baata boolo weti kia ngwanya. ");
INSERT INTO iyx_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Me ndi mu uta imbaangi mu me makulu, na Taayi watsinduu me li mu uta ka imbaangi mu me.» ");
INSERT INTO iyx_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Bo bamufuuli: «Taayi a we kuni ali?» Yiisu wabavutili: «Beni a diayaaba pe so me, na so Taayi a me. Mbiiti beni ali diyaaba me, beni diakeni uyaaba ka Taayi a me.» ");
INSERT INTO iyx_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yiisu aleeli mandaa ma moosi, mu taanga di nde akiyiisi mu nzo a Nziaambi. Mbuu yi nde akiyiisi ali bebele na itsuru kia nzo kia busini. Muutu pe so mosi wakaangi nde, mundaa ti taanga dia nde ali keni a diafwaana pe. ");
INSERT INTO iyx_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yiisu abwileele kwaa bo: «Me sa yene. Beni sa disaa me, na beni sa dikwa kutso masumu ma beni. Beni a dituu pe uyene ku me niyene.» ");
INSERT INTO iyx_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Bayuudayo bafulisini: «Nde nyutu akaadusu? Mundaa ti nde li mu uleele ti, “beni a dituu pe uyene ku me niyene.”» ");
INSERT INTO iyx_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yiisu wabavutili: «Beni baata ba nha tsini dili, ka me, muutu wa ku yula ndi. Beni dili baata ba tsi yi, me a ndi wa tsi yi pe. ");
INSERT INTO iyx_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ni mu buu me ndeeli beni ti, beni sa dikwa kutso masumu ma beni. So beni a disiingi pe ti, me ni muutu wu me ndi mu uleele ti me ndi, beni sa dikwa kutso masumu ma beni.» ");
INSERT INTO iyx_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Bo bamufuuli: «We na li?» Yiisu wabavutili: «Ma me ndi mu ubaaleelanga beni umatuu mu mbaandili. ");
INSERT INTO iyx_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Me ndi na mandaa mavululu ma uleele, na ma ufuundusu mu beni. Ka watsinduu me, li mu uleele ngwanya. Na mandaa ma me nayuu kwaa nde, ni mo me ndi mu uleele kwaa tsi.» ");
INSERT INTO iyx_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Bo a babahili pe ti, nde mu Taayi akitsuu kwaa bo. ");
INSERT INTO iyx_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yiisu abwileele: «Mu taanga di beni dikaanaangila Mwaana a muutu, beni sa diyaaba ti, me ni muutu wu me ndi mu uleele ti me ndi, na me a ndi mu uyiluu ndaa so mosi pe mu ime makulu. Me ndila ma Taayi ayiisi me, me ndi mu uleele. ");
INSERT INTO iyx_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Watsinduu me li itwaari na me. Nde a asiisi pe me, me bake. Mundaa ti, me ndi mu ubaayiluuwanga taanga dioosi, mandaa ma nde atoono.» ");
INSERT INTO iyx_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Bu Yiisu akitsuu buu, baata balaa basi imiini mu nde. ");
INSERT INTO iyx_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yiisu aleeli kwaa Bayuudayo babasi imiini mu nde: «So beni dikangimi mu mandaa ma me, ngwanya beni dili miyii mia me. ");
INSERT INTO iyx_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Beni sa diyaaba ngwanya, na ngwanya sa yiha beni bunyanga.» ");
INSERT INTO iyx_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bo bamuvutili: «Bisi dili baana ba Abraami, na bisi kaala a diaba batee ba muutu so mosi pe. Buni we utuu uleele bisi: “Beni sa diba bunyanga?”» ");
INSERT INTO iyx_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yiisu wabavutili: «Ee-e, ngwanya me nadileeli! Pasi muutu wu usa masumu, li mutee a masumu. ");
INSERT INTO iyx_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mutee ubaabaanganga wa likaanda mu mwaana a taanga hoolo. Ka mwaana li wa mu likaanda taanga dioosi. ");
INSERT INTO iyx_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","So Mwaana hi beni bunyanga, ngwanya beni sa diba baata ba bunyanga. ");
INSERT INTO iyx_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Me nayaaba ti beni dili baana ba Abraami. Ka beni dili mu usaa udusu me, mundaa ti beni a dili mu usiingi pe mandaa ma me. ");
INSERT INTO iyx_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Me ndi mu utsuu mu mandaa ma me namono kwaa Taayi a me. Ni mu buu, beni ka diyiluu ma beni dimaayuu kwaa taayi a beni.» ");
INSERT INTO iyx_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bo bavutili: «Taayi a bisi, ni Abraami.» Yiisu wabavutili: «Mbiiti beni dili baana ba Abraami, diyiluu makiyiluu Abraami. ");
INSERT INTO iyx_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ka beni dili mu usaa udusu me, me wu leeli beni ngwanya yi me nayii kwaa Nziaambi. Abraami a ayilii ndaa so mosi ya pili yii pe! ");
INSERT INTO iyx_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Beni dili mu uyiluu mandaa mamosi na taayi a beni.» Bo bamuvutili: «Bisi a dili baana ba bindwaala pe. Bisi dili na Taayi ndila mosi, ni Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yiisu avutili: «Mbiiti ngwanya Nziaambi ali Taayi a beni, beni diakeni utoono me. Mundaa ti me kwaa Nziaambi namata, na mundaa a nde me ndi nha. Me a nayiri pe mu litoono la me makulu, ka nde atsinduu me. ");
INSERT INTO iyx_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mu ima beni dili mu uhele ubahala mandaa ma me ndi mu uleele? Mundaa ti beni a dili mu utuu pe uyuu mandaa ma me. ");
INSERT INTO iyx_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Taayi a beni ni Saatina, na beni diatoono uyiluu manzala ma taayi a beni. Nde li mudusi a baata umatuu mu mbaandili. Nde ubaabelanga ngwanya, mundaa ti ngwanya a yili mu nde pe. Mbiiti nde li mu uta pia, pili a nde yili buu, mundaa ti nde li ngaa pia, na nde li taayi a pia. ");
INSERT INTO iyx_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ka me, mundaa ti me ndi mu uleele ngwanya, beni a dili mu usa imiini mu me pe. ");
INSERT INTO iyx_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Na nha kati a beni utuu umweese ti me nasa lisumu? Ka mbiiti me ndi mu uleele ngwanya, mu ima beni a dili mu uhele usa imiini mu me? ");
INSERT INTO iyx_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Muutu wuli wa Nziaambi, koo li mu uyuu mandaa ma Nziaambi ali mu uleele. Ka beni a dili baata ba Nziaambi pe, ni mu buu, beni a dili mu uyuu mandaa ma nde pe.» ");
INSERT INTO iyx_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Bayuudayo baleeli kwaa Yiisu: «Bisi a dili na buungu pe mu uleele ti we li musi Samaria, na we akangama kwaa miheebili mimibi?» ");
INSERT INTO iyx_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yiisu avutili: «Me a nakangama pe kwaa miheebili mimibi. Ka me ndi mu ukiinzi Taayi a me, na beni dili mu ubisi ukiinzi me. ");
INSERT INTO iyx_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Me a ndi mu usaa buzitu mu me makulu pe. Uli na muutu wuli mu usaa buzitu mu me, na wuli mu ufuundusu baata. ");
INSERT INTO iyx_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ee-e, ngwanya me nadileeli! Muutu wu utumumu mandaa ma me a ukwa pe.» ");
INSERT INTO iyx_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Bayuudayo bavutili: «Nha ka bisi dimaayiluu uyaaba ti we akangama kwaa miheebili mimibi! Abraami akwi, mibili miakwi. Ka we li mu uleele ti wu utumumu mandaa ma we a ukwa pe. ");
INSERT INTO iyx_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Mu matsimi ma we ti we avulu Abraami wakwa? Mibili ka miakwa. We bu li mu utsimi ti we na li?» ");
INSERT INTO iyx_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yiisu avutili: «Mbiiti me makulu ndi mu umweese buzitu ba me, keni buzitu ba me a bali na ndutu pe. Ka Taayi a me li mu umweese buzitu ba me. Beni dili mu uleele ti “Nde Nziaambi a bisi ali”, ");
INSERT INTO iyx_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ka bunu beni a diayaaba nde pe. Ka me, me nayaaba nde. Mbiiti me naba naleele ti me a nayaaba nde pe, me keniba ngaa pia weti beni. Ka me nayaaba nde, na me ndi mu utumumu mandaa ma nde. ");
INSERT INTO iyx_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Taayi a beni Abraami ali aluulu mu kinyi, ndila mu tsimi ya umono iluumbu kia me. Nde amoni kio na nde ali na kinyi mundaa a kio.» ");
INSERT INTO iyx_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Bayuudayo bamuleeli: «We kaala so maku mataana ma bilimi a atooso pe, ka we amono Abraami?» ");
INSERT INTO iyx_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yiisu wabavutili: «Ee-e, ngwanya me nadileeli! Tswaamina Abraami ubutuu, “me ndi.”» ");
INSERT INTO iyx_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ninha, bo batoli mamanya mu utete Yiisu. Ka Yiisu asweemi na apali mu Nzo a Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Mu kuulu, Yiisu amoni muutu wali ingimangimi umatuu mbutili a nde. ");
INSERT INTO iyx_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Miyii mia nde miamufuuli: «Muyiisi, mundaa a masumu ma nde oo ti mundaa masumu ma bibuti bia nde, nde abutii ingimangimi?» ");
INSERT INTO iyx_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yiisu avutili: «A mundaa masumu ma nde, na ma bibuti bia nde pe, nde a butii ingimangimi. Ka nde abutii ingimangimi paa ti, isala kia Nziaambi imonuu mu nde. ");
INSERT INTO iyx_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Bu yikeni nyanga, bisi diafwaana ukuusu bisala bia watsinduu me. Nha bwisi bukaayili, muutu so mosi pe wu kaatuu usala. ");
INSERT INTO iyx_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Bu me keni nha tsini a toto nha, me ndi liyalila la tsi.» ");
INSERT INTO iyx_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nha mbisi a mandaa maa, nde atswiili mate nha tsi, na asi mwaana mutamba mu mate ma nde. Nde akili mutamba wuu nha yulu a misi mia ingimangimi, ");
INSERT INTO iyx_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","na wamuleeli: «Yayobo ku idia kia kuumbu Silowa.» Mambiindili ma kuumbu yii: «Wu batsinduu.» Ingimangimi kiayeni kuu, kiayobi, na bu nde ayiri avutuu, nde amoni na yalilaa. ");
INSERT INTO iyx_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Bambaayi ba nde na baata babamoni nde bu akiloombo mboongo tsiomi, bafuuli: «Wu a ni nde pe wakidiaala nha tsi na tsi mu uloombo mboongo?» ");
INSERT INTO iyx_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Babamosi bakileele: «Ni nde.» Babakimi ti: «Pia, a nde pe, ka nde afwaanina nde!» Ka nde makulu akileele: «Ni me wa me!» ");
INSERT INTO iyx_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Bo bafuuli nde: «Buni misi mia we misiiri mu udibini?» ");
INSERT INTO iyx_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nde abiindili: «Baala la kuumbu Yiisu maayiluu mwaana a mutamba, nde maakili nde nha yulu a misi, na maalele me: “Yene yayobo ku idia kia kuumbu Silowa.” Me nayeni kuu, me nayobo, na me ndi mu umono!» ");
INSERT INTO iyx_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bo bamufuuli: «Kuni nde ali?» Nde ni avutili bo: «Me a nayaaba pe.» ");
INSERT INTO iyx_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Babiti muutu wali ingimangimi kwaa Bafarisi. ");
INSERT INTO iyx_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Kaba, iluumbu ki Yiisu ayilii mutamba mu udibili misi mia nde, ali iluumbu kia saba. ");
INSERT INTO iyx_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ni mu buu, Bafarisi ka, bafuuli nde miayilimi paa nde abaanduu umono mu taanga di. Nde wabayali mutata: «Nde akili me mwaana mutamba nha yulu a misi, me maayobo, na mu taanga di me ka mu umono.» ");
INSERT INTO iyx_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ndaamba a Bafarisi baleeli kwaa nde: «Wu yilii maa a utuu umata kwaa Nziaambi pe, mundaa ti nde ali mu ukiinzi iluumbu kia saba pe.» Ka babamosi bavutili: «Buni ngaa masumu utuu uyiluu bimaanga bia pili yi?» Na Bafarisi bakabii mu makaba moolo. ");
INSERT INTO iyx_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Bo babwifuulu kwaa ingimangimi kiabeelii: «Aka we, ima we li mu uleele mu muutu wudibili we misi?» Nde ni avutili ti: «Nde mubili ali.» ");
INSERT INTO iyx_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ka bakuutu ba Bayuudayo a batooni pe usa imiini ti, nde ali ingimangimi, na nde ka mu umono. Ni mu buu, bo batumisi bibuti bia nde, ");
INSERT INTO iyx_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","na babafuuli manduru: «Ngwanya wuu na wu ni mwaana a we? Beni utuu uleeli ti nde abutuu ingimangimi? Aka buni nde aka mu umono na yalilaa mu taanga di?» ");
INSERT INTO iyx_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Bibuti biavutili: «Bisi diayaaba ti, nde mwaana a bisi na abutuu ingimangimi. ");
INSERT INTO iyx_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ka buni nde amaasa mu umono, yii bisi a diayaaba pe! Na a diayaaba pe ka, na maadibili misi mia nde! Fuulani nde: nde a ali pe mwaana ngebe, nde utuu uvutulu beni mamvutu nde makulu!» ");
INSERT INTO iyx_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Bo batsuyi buu mundaa ti, bo bali na boomo ba bakuutu ba Bayuudayo. Mundaa ti, bakuutu ba Bayuudayo bali bamaayuhusunu mu ubingi mu nzo a makutunu ma bo, pasi muutuu wu uleele ti Yiisu ni Kristo. ");
INSERT INTO iyx_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ni mu buu bibuti bialeeli: «Nde a ali pe ngebe, difuulu nde!» ");
INSERT INTO iyx_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Bafarisi bati wali ingimangimi mbili mu mbala ya dioolo, na bamuleeli: «Leele ngwanya nha kulu a Nziaambi. Bisi diayaaba ti muutu wuu li ngaa masumu.» ");
INSERT INTO iyx_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nde avutili: «Me a nayaaba pe mbiiti nde ngaa masumu ali, oo ngori. Ka me nayaaba ndaa mosi: me nali ingimangimi na me ndi mu umono na yalilaa mu taanga di!» ");
INSERT INTO iyx_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Bo bamufuuli: «Ima nde amaasa we? Buni nde amaadibili misi mia we?» ");
INSERT INTO iyx_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nde ni avutili: «Me namaakwaleele beni yo, na beni a diayuu pe. Mu ima beni dili na nzala me bwaleele beni yo? Helape beni ka nzala uba miyii mia nde!» ");
INSERT INTO iyx_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Bo bamutuyi na bamuleeli: «We muyii a nde li! Bisi miyii mia Mooso dili. ");
INSERT INTO iyx_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Bisi diayaaba ti Nziaambi atsuu kwaa Mooso. Ka nde, bisi a diayaaba pe kuni nde amata!» ");
INSERT INTO iyx_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nde avutili: «Mono ndaa ya ukimuu: beni a diayaaba pe nde wa kuni ali, ka bunu nde maadibili misi mia me! ");
INSERT INTO iyx_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Bisa beni diayaaba ti Nziaambi a ubaayuu pe bangaa masumu, ka nde ubaayuu pasi muutu wu ubaakinzi nde na uyiluu litoono la nde. ");
INSERT INTO iyx_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kaala a diayuu pe ti muutu maadibili misi mia muutu wabutuu ingimangimi. ");
INSERT INTO iyx_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Mbiiti muutu wuu a amati kwaa Nziaambi pe, nde a keni utuu uyiluu ndaa so mosi pe.» ");
INSERT INTO iyx_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Bo bamuvutili: «We woosi li kutso masumu umatuu mbutili a we, na we a li na ndaa ya uyiisi bisi pe!» Na bo babingi nde ku mbari. ");
INSERT INTO iyx_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yiisu ayuyi ti babingi muutu wali ingimangimi ku mbari. Yiisu ayimono nde na wamufuuli: «We li mu usa imiini mu Mwaana a muutu?» ");
INSERT INTO iyx_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nde avutili: «Pfumu, nde na ali? Leele me paa me sa imiini mu nde.» ");
INSERT INTO iyx_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yiisu wamuleeli: «We li mu umono nde. Ni nde li mu utsuu kwaa we.» ");
INSERT INTO iyx_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nde ni avutili: «Me ndi mu usa imiini, Pfumu.» Na nde atsukini nha kulu a Yiisu. ");
INSERT INTO iyx_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yiisu ni aleeli: «Me nayiri nha tsi yi, paa pfuundisi yiba: paa bingima-ngimi bimono, na babumono bakituu bingima-ngimi.» ");
INSERT INTO iyx_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ndaamba a Bafarisi babali nha pele a nde, bayuyi mandaa maa na bamufuuli: «Bisi ka bingima-ngimi dili?» ");
INSERT INTO iyx_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yiisu avutili kwaa bo: «Mbiiti beni diali bingima-ngimi, beni a diakeeba na masumu pe. Ka bunu, beni dili mu uleele ti: “Bisi dili mu umono”, ni mu buu masumu ma beni ni buunabu mali.» ");
INSERT INTO iyx_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yiisu aleeli: «Ee-e, ngwanya me nadileeli! Muutu wu ukoto mutso ihaanga kia mameme kwahele a uyoo nha munywa a ihaanga, ka haati mu ibaa, muutu wuu muyibi ali, nde ipunga-pungu. ");
INSERT INTO iyx_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ka muutu wu ukoto mu munywa a ihaanga, li mukebi a mameme. ");
INSERT INTO iyx_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mu ndaa a nde, mukebi a ihaanga ali mu udibili ihaanga. Mameme mali mu uyuu muniingi a ndaa a nde. Na nde li mu uta mameme ma nde, pasi lo mu kuumbu a lo, na li mu ubiti mo ku mbari. ");
INSERT INTO iyx_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Mu taanga di nde ali mu upalisa mo, nde li mu uyene nha kulu a mo, na mameme mali mu uduku nde, mundaa ti mo mayaaba muniingi a ndaa a nde. ");
INSERT INTO iyx_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ka mo a mutuu uduku so hoolo pe muutu wu mo mahele uyaaba. Mo sa mabata la na nde, mundaa ti mo a mayaaba pe miniingi mia baata bakimi.» ");
INSERT INTO iyx_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yiisu asialili ifwaani kii mu utsuu kwaa bo. Ka babakiyuu nde a babahili ma nde akileele pe. ");
INSERT INTO iyx_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yiisu abwileele: «Ee-e, ngwanya me nadileeli! Me ni munywa a lipaanga la mameme. ");
INSERT INTO iyx_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Boosi babayiratswaamina me, miyibi na bipunga-pungu bali. Ka mameme a mayuyi bo pe. ");
INSERT INTO iyx_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Me ndi munywa a ihaanga. Wu uyoo mu me mu ukoto, sa avuu. Nde sa atuu ukoto na upala, na sa abaa biloo bia udia. ");
INSERT INTO iyx_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Muyibi koo li mu uyiri ndila mu uyibi, mu udusu na mu utsala. Ka me nayiri paa baata babaa moonyi, na babaa nde wavululu. ");
INSERT INTO iyx_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Me ndi mukebi wu mubwe. Mukebi wu mubwe ubaayeelele moonyi a nde, mundaa a mameme ma nde. ");
INSERT INTO iyx_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Muutu wuli mu usala ndila mu mboongo, a ali pe mukebi wa ngwanya, mundaa ti a nde a wu baakebanga mameme mu taanga dioosi pe. Mameme a mali ma nde pe. Mu taanga di nde ali mu umono miminzi mu uyiri, nde li mu ubaabwongolo mo, na li mu ubata. Miminzi mili mu ukaanga mameme, na mili mu utsala mukaanga woosi. ");
INSERT INTO iyx_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Muutu wuli mu usala ndila mu mboongo, na nde a ali na tsoongo mundaa a mameme pe. ");
INSERT INTO iyx_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Me ndi mukebi wu mubwe. Me nayaaba mameme ma me, na mo ka mayaaba me. ");
INSERT INTO iyx_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Bumosi ka Taayi ayaaba me, na me ka nayaaba Taayi. Na me ndi mu uha moonyi a me mu mameme ma me. ");
INSERT INTO iyx_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Me ndi na mameme makimi mamali a mutso ihaanga ki pe. Me nafwaana ubiti mo ka. Mo sa mayuu muniingi a ndaa a me, na mo sa maba mukaanga ndila mosi, na mukebi ndila mosi. ");
INSERT INTO iyx_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ni mu buu Taayi atoono me, mundaa ti me ndi mu uha moonyi a me, mu ubwaholo nde. ");
INSERT INTO iyx_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Muutu pe wuli mu uholo moonyi a me, ka mu litoono la me makulu me ndi mu uha nde. Me ndi na litu la uha nde, na me ndi na litu la ubwaholo nde. Lii ni litumu li Taayi a me aha kwaa me.» ");
INSERT INTO iyx_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Bayuudayo babwikabuu mundaa a mandaa maa. ");
INSERT INTO iyx_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Babalayi mu bo bakileele: «Nde akangama kwaa muheebili wu mubi! Nde mubeeri a lari! Mu ima beni dili mu uyuu nde?» ");
INSERT INTO iyx_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Babamosi bakivutulu: «Muutu wakangama kwaa muheebili wu mubi utuu pe utsuu bu. Muheebili wu mubi li na litu la udibili misi mia bingima-ngimi?» ");
INSERT INTO iyx_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Bakisa mukuungi a ndibili a moonyi a lisieme la nzo a Nziaambi ku ngaanda a Yeruselemi. Ali ka taanga dia kioori kia mifuri. ");
INSERT INTO iyx_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yiisu akidieenge mutso lipaanga la nzo a Nziaambi, ku tsini a ipaangala kia Solomo. ");
INSERT INTO iyx_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Bayuudayo bamudiengilili na bamuleeli: «Natee ki taanga we unyaala bisi kutso kenge-kenge? Ngwanya mbii ti we ni Kristo, leele bisi yo na yaki-yaki.» ");
INSERT INTO iyx_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yiisu wabavutili: «Me naleeli beni yo, ka beni a dili mu usa imiini pe. Mandaa ma me ndi mu uyiluu mu kuumbu a Taayi a me, mali mu uta imbaangi mu me. ");
INSERT INTO iyx_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ka beni a dili mu usa imiini pe, mundaa ti beni a dili pe mu kaba la mameme ma me. ");
INSERT INTO iyx_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mameme ma me mali mu uyuu muniingi a ndaa a me. Me nayaaba mo, na mo ka mali mu uduku me. ");
INSERT INTO iyx_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Me ndi mu uha mo moonyi wa bilimi na bilimi. Mameme a mudiimbili so hoolo pe. Muutu pe so mosi wu upatila mo nha koo kia me. ");
INSERT INTO iyx_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Taayi a me wa aha mo kwaa me, avulu bioosi mu litu, na muutu pe so mosi wu utuu upatila mo nha koo kia Taayi. ");
INSERT INTO iyx_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Me na Taayi, bisi dili muutu mosi.» ");
INSERT INTO iyx_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Bayuudayo babwitolo mamanya mu utete Yiisu. ");
INSERT INTO iyx_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yiisu wabafuuli: «Me nadimweesi mandaa malaa mamabwe mamata kwaa Taayi. Mu ki ndaa mu mandaa maa, ma na yiluu, beni dili na nzala ya udusu me mu mamanya?» ");
INSERT INTO iyx_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Bayuudayo bamuvutili: «Bisi a dili pe na nzala ya udusu we mu mamanya mundaa biyiluu bibibwe bi we ayiluu. Ka mu itari ki we atuu Nziaambi: we muutu li, ka we li mu uleele mu iwemakulu ti we Nziaambi li!» ");
INSERT INTO iyx_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yiisu avutili: «A basonuu pe mu mikele mia beni ti: “Me ndeeli ti, beni banziaambi dili”? ");
INSERT INTO iyx_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Bisa-beni diayaaba ti a butuu pe umaasa mali mu uleele Mabasonuu ma Ngira. Ka bunu, baata ba mikele mili mu uta banziaambi ni baata babayiisi mandaa ma Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Me, Taayi abiaalisa me, na nde atsinduu me nha tsi. So me ndeeli ti: “Me ndi Mwaana a Nziaambi”, buni beni dituu uleele ti me ndi mu utuu Nziaambi? ");
INSERT INTO iyx_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Mbii ti me a ndi mu uyiluu pe biyiluu bia Taayi a me, dinyaala usa imiini mu me. ");
INSERT INTO iyx_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ka mbii ti me ndi mu uyiluu bio, so beni a dili mu usa imiini mu me pe, disa imiini mu biyiluu bia me. Disa imiini, paa beni diyaaba na dibahala ti Taayi li mu me, na me ndi mu Taayi.» ");
INSERT INTO iyx_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Bo babwisaa ukaanga nde, ka a bamubayi pe. ");
INSERT INTO iyx_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yiisu abwiyene ku simi li limosi la nziali ya kuumbu Yorodaani, nha mbuu yi Yowani akibootuu baata. Nde adiaali kuu mwaana biluumbu hoolo. ");
INSERT INTO iyx_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Baata babalayi bayiri kwaa nde na bakileele: «Yowani a ayilii pe biliimbi bia ukimuu, ka moosi ma Yowani aleeli mu muutu wu mali ma ngwanya!» ");
INSERT INTO iyx_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Na, nha mbuu yii, bo ali babalayi mu usa imiini mu Yiisu. ");
INSERT INTO iyx_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ali na baala limosi labeele la kuumbu Laazaro. Nde ali musi Betania, ni bula ba Mari na Marte, bakeri ba nde. ");
INSERT INTO iyx_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mari ni mukaasa wayitili mananaasa mu miili mia Yiisu, na wakoombili mio mu naanga dia nde. Laazaro wali wabeele ali keri a nde. ");
INSERT INTO iyx_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Baana ba nguu bo baboolo ba bakaasa batsindii muutu mu uleele kwaa Yiisu: «Pfumu, nduu a we li mu ubeele.» ");
INSERT INTO iyx_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Mu taanga di Yiisu ayuyi mukeenzi wuu, nde aleeli: «Ibeeri kia Laazaro a ibiti pe nde ku likwa. Kio sa imweese buzitu ba Nziaambi, paa buzitu ba Mwaana a Nziaambi bayabina mu kio.» ");
INSERT INTO iyx_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yiisu akitoono Marte na mwaana a nguu a nde, na Laazaro ka. ");
INSERT INTO iyx_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ka bunu, mu taanga di nde ayuyi ti Laazaro li mu ubeele, nde abwilabisa biluumbu bioolo ku nde ali. ");
INSERT INTO iyx_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tumake, nde aleeli kwaa miyii mia nde: «Divutuwani ku itinini kia Yuda.» ");
INSERT INTO iyx_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Miyii miavutili: «Muyiisi, liaalili nha, bakuutu ba Bayuudayo baba mu usaa udusu we mu mamanya! We na nzala ubwavutuu ku?» ");
INSERT INTO iyx_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yiisu wabaleeli: «Mu iluumbu, uli na manguungu kuumi na moolo, a buu pe? Mbiiti muutu li mu udieenge mu nyanga, nde a li mu ukubu baka pe, mundaa ti nde li mu umono liyalila la tsi yi. ");
INSERT INTO iyx_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ka mbiiti muutu li mu udieenge butsuu, nde li mu ukubu baka, mundaa ti liyalila a lili mu nde pe.» ");
INSERT INTO iyx_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nha mbisi a uleele buu, Yiisu abwileele: «Mbaayi a bisi Laazaro maala tolo, ka me nde niyasiimbili.» ");
INSERT INTO iyx_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Miyii miavutili: «Pfumu, mbiiti nde tolo ala, nde sa abeeluu.» ");
INSERT INTO iyx_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Bunu, mu likwa la Laazaro Yiisu akitsuu, ka miyii miakitsimi ti nde mu tolo akitsuu. ");
INSERT INTO iyx_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ni mu buu, Yiisu wabaleeli na yaki-yaki: «Laazaro maakwa. ");
INSERT INTO iyx_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Me ndi na kinyi mu beni mundaa ti beni a diali kuu pe, mundaa ti mu yii, beni utuu usa imiini mu me. Ka tsweendani kwaa Laazaro.» ");
INSERT INTO iyx_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Toma, wubali mu uta «mbu», aleeli kwaa bambaayi miyii: «Tsweendani bisa-beni ka, paa dikwaanani itwaari na Muyiisi a bisi!» ");
INSERT INTO iyx_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Mu taanga di Yiisu ayito, bamuleeli ti biluumbu ka bina umatuu bubadii Laazaro. ");
INSERT INTO iyx_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bula ba kuumbu Betania, bebele bali na ngaanda a Yeruselemi. Bakilometre helape batata bali mu ukabila Betania na Yeruselemi. ");
INSERT INTO iyx_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Bayuudayo babalayi bali bayiri kwaa Marte na Mari, mu uboondo bo mundaa likwa la keri a bo. ");
INSERT INTO iyx_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Bu Marte ayuyi ti Yiisu akiyiri, nde ayeni mu uyabwaana nde. Ka Mari asiaali ku nzo. ");
INSERT INTO iyx_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marte aleeli kwaa Yiisu: «Pfumu, mbiiti we ali nha, keni keri a me a amaakwa pe! ");
INSERT INTO iyx_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ka me nayaaba ka mu taanga di ti, bioosi bi we uloombo kwaa Nziaambi, Nziaambi sa aha we bio.» ");
INSERT INTO iyx_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yiisu aleeli: «Keri a we sa asiimbuu mu babakwa.» ");
INSERT INTO iyx_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marte avutili: «Me nayaaba ti nde sa asiimbuu mu babakwa, mu iluumbu kia tsieelele.» ");
INSERT INTO iyx_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yiisu abwileele: «Me ndi tsimbilili na moonyi. Wu usa imiini mu me, sa aba moonyi, so nde kwiiri. ");
INSERT INTO iyx_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Na wu uba moonyi na usa imiini mu me, a ukwa pe. We siiri imiini mu mandaa maa?» ");
INSERT INTO iyx_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Nde aleeli: «Ee-e Pfumu, me nsiiri imiini ti we ni Kristo, Mwaana a Nziaambi, wuli mu uyiri nha tsi.» ");
INSERT INTO iyx_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nha mbisi a uleele mandaa maa, Marte ayeni kwaa mwaana a nguu a nde Mari, na wamuleeli mu tsweeyi: «Muyiisi nha ali, na nde li mu usaa we.» ");
INSERT INTO iyx_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mari amana na uyuu buu, nde atemini mu mawasa na ayeni kwaa Yiisu. ");
INSERT INTO iyx_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Kaba Yiisu ali keni a akoto pe kutso bula, ka nde ali keni nha mbuu yi Marte ayibwaana nde. ");
INSERT INTO iyx_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Bu Bayuudayo babali mutso nzo na Mari mu uboondo nde, bamumoni mu utemene mu mawasa na upala mu nzo, bo bamuduki. Bo bakitsimi ti nde ku ngili akiyene, mu uyalili kuu. ");
INSERT INTO iyx_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mari atoori nha mbuu yali Yiisu. Mu taanga di nde amoni Yiisu, nde ayibwa nha miili mia nde, na wamuleeli: «Pfumu, so we ali nha, keni keri a me a akwiiri pe.» ");
INSERT INTO iyx_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mu taanga di Yiisu amoni nde, na Bayuudayo babayiri na nde mu ulili, Yiisu amoni ngebe dialaa kutso mutimi a nde, na matsimi ma nde maviinzii. ");
INSERT INTO iyx_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Nde wabafuuli: «Kuni beni diadii nde?» Bo bamuvutili: «Pfumu, yiri na we sa mono.» ");
INSERT INTO iyx_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yiisu alili. ");
INSERT INTO iyx_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ninha Bayuudayo baleeli: «Dimono! Nde ali ngo utoono Laazaro!» ");
INSERT INTO iyx_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ka babamosi mu bo bakileele: «Nde wadibili misi mia ingimangimi, mu ima nde ahele usa ti Laazaro anyaala ukwa?» ");
INSERT INTO iyx_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ni mu buu, Yiisu bu abwimono ngebe dialaa ku mutimi, ayeni ku ngili. Yo yali wuru libasootolo mutso manya, na libali badibuu munywa mu manya lilinene. ");
INSERT INTO iyx_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yiisu aleeli: «Dimaasa manya.» Marte keri a wakwa, avutili: «Pfumu, nde aka utuu upala tsulu, mundaa ti ka biluumbu bina basuusu nde muu.» ");
INSERT INTO iyx_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yiisu wamuvutili: «Me a naleele pe we ti, so we siiri imiini, we sa mono buzitu ba Nziaambi?» ");
INSERT INTO iyx_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ni mu buu, bo bamaasi manya. Yiisu asiimbili misi ku yula, na aleeli: «Taata, me ni vutulu we matoondo bu we yuyi me. ");
INSERT INTO iyx_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Me nayaaba ti we ubaayuwanga me taanga dioosi, ka me ndi mu utsuu mundaa koongi yadieengelele me yi, paa bo basa imiini ti we atsinduu me.» ");
INSERT INTO iyx_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nha mbisi a utsuu buu, nde aloyi mu mifuri: «Laazaro, pala muu!» ");
INSERT INTO iyx_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Muutu waba wakwa, apali, miili na mioo bakutu mu biteendi, na busu bafuu mu tsaanda. Yiisu aleeli: «Dinyangila nde na dinyaala nde ayene.» ");
INSERT INTO iyx_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Bayuudayo babalayi mu babali bayiri kwaa Mari, na babamoni mandaa ma Yiisu ayilii, basi imiini mu nde. ");
INSERT INTO iyx_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ka ndaamba a Bayuudayo bakimi bayimono Bafarisi, na babaleeli mandaa mayilii Yiisu. ");
INSERT INTO iyx_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Banguu ba bangaanga ba Nziaambi na Bafarisi bakukii pfuundu a ikuutu kia Bayuudayo, na baleeli: «Ima disaanani? Mundaa ti, muutu wu li mu uyiluu biliimbi bialaa bia ukimuu! ");
INSERT INTO iyx_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","So bisa-beni dinyaali nde, boosi sa basa imiini mu nde, na basi Loma sa bakoto mu ndaa yi. Bo sa batsala nzo a Nziaambi a bisi na baata ba tsi a bisi!» ");
INSERT INTO iyx_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ka mosi mu bo, wa kuumbu Kayifa, wali mukuutu a banguu ba bangaanga ba Nziaambi mu ilimi kii, aleeli: «Beni a dili mu ubahala ndaa so mosi pe! ");
INSERT INTO iyx_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Beni a dili mu umono ndaanda a beni pe? Yavulu bubwe, muutu ndila mosi akwa mu toono a baata boosi. Mu yii, baata ba tsi yoosi a bufuu pe!» ");
INSERT INTO iyx_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaba, a mu inde makulu pe nde akitsuu buu. Ka bu nde ali mukuutu a banguu ba bangaanga ba Nziaambi mu ilimi kii, nde ubili akibili ti Yiisu afwaana mu ukwa, mu toono a Bayuudayo boosi. ");
INSERT INTO iyx_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Na a yali ndila mu ifuumbu ki pe, ka mu uvuutu ka baana ba Nziaambi boosi babatsamuu mu tsi yoosi. ");
INSERT INTO iyx_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Umatuu iluumbu kii, bo baholi kesili ya udusu Yiisu. ");
INSERT INTO iyx_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ni mu buu, Yiisu anyaali ubwamonuu nha kulu a baata, na nha kulu a Bayuudayo. Nde ayeni ku itinini kiabesene na tsi ya tsata, ku ngaanda mosi ya kuumbu Efrayime, ku nde adiaali na miyii mia nde. ");
INSERT INTO iyx_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Mukuungi a Bayuudayo wa Paaka ali bebele, na baata babalayi bakiyene ku Yeruselemi, mu utsieemese manyutu ma bo, tswaamina mukuungi a Paaka uto. ");
INSERT INTO iyx_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Bo bakisaa Yiisu, na bu bo bali mutso lipaanga la nzo a Nziaambi, bo bakifulusunu bo na bo: «Ima beni dili mu utsimi? Nde sa ayiri oo ti a uyiri pe ku mukuungi?» ");
INSERT INTO iyx_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Banguu ba bangaanga ba Nziaambi na Bafarisi ali bahi tumini ti mbiiti muutu ayaaba kuli Yiisu, nde afwaana uleele bo, paa bamukaanga. ");
INSERT INTO iyx_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Biluumbu bisamina tswaamina mukuungi a Paaka uto, Yiisu ayeni ku bula ba kuumbu Betania, ku Laazaro wu nde asiimbili mu babakwa akidiaala. ");
INSERT INTO iyx_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kuu, bamuhi biloo. Marte wamuyilii meese, na Laazaro ali mosi mu babali na Yiisu nha meese. ");
INSERT INTO iyx_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mari aholi ndaamba liitere la mananaasa ma ngo tala, mabakamina mu ifulu kia kuumbu nare. Na ayitili mo mu miili mia Yiisu. Tumake nde akoombili miili mia Yiisu mu naanga dia nde. Nzo yoosi yaluuli mu tsulu a mananaasa. ");
INSERT INTO iyx_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Mosi mu miyii mia Yiisu wu bali mu uta Yuda Iskarioti, wukaayeelele nde, afuuli: ");
INSERT INTO iyx_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Mu ima bamaahele uyaluu mananaasa ma, mu makama matata ma mikuti mia mboongo, paa baha dio kwaa bawele?» ");
INSERT INTO iyx_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yuuda akileele buu, a mundaa pe ti nde li na tsoongo a bawele, ka mundaa ti nde ali muyibi. Nde ali wakikaanga ipokolo kia mboongo dia twaari, na akiyibi di bakilooso muu. ");
INSERT INTO iyx_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ka Yiisu aleeli: «Nyaala nde swii! Nde siiri buu, mundaa iluumbu ki bakaalooso me mu ngili. ");
INSERT INTO iyx_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Beni sa dibaabaanganga na bawele taanga dioosi, ka me, beni a dikaabaanganga na me taanga dioosi pe.» ");
INSERT INTO iyx_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Koongi yinene ya Bayuudayo bayuyi ti, Yiisu ali ku bula ba kuumbu Betania. Bo bayeni kuu, mu uyamono Yiisu. Bo bayeni kuu ka, mu uyamono Laazaro wu Yiisu asiimbili mu babakwa. ");
INSERT INTO iyx_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Banguu ba bangaanga ba Nziaambi baholi kesili ya udusu ka Laazaro. ");
INSERT INTO iyx_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Mundaa ti ali mu toono a nde, Bayuudayo babalayi bakimata mu kaba la bo, na bakisa imiini mu Yiisu. ");
INSERT INTO iyx_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Iluumbu kiaduki, koongi yalaa yali yayiri ku mukuungi a Paaka, yayuyi ti Yiisu li mu uyiri ku ngaanda a Yeruselemi. ");
INSERT INTO iyx_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Bo boosi baholi matsiooni, na bapali mu ngaanda mu uyabwaana nde. Bo bakiloo: «Osaana! Nyaala Nziaambi asieme wuli mu uyiri mu kuumbu a Pfumu! Nyaala Nziaambi asieme mutini a Iseraeli!» ");
INSERT INTO iyx_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yiisu amoni mwaana a puundi na adiaali nha yulu a nde, weti buli mu uyaabisa Mabasonuu ma Ngira: ");
INSERT INTO iyx_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Aba na boomo pe, ngaanda ya kuumbu Siooni! Mono, mutini a we li mu uyiri, nde adiaala nha yulu a mwaana a puundi.» ");
INSERT INTO iyx_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Miyii mia nde a miabahili pe mandaa maa nhana tsi. Ka mu taanga di Yiisu anaangii mu buzitu, bo balibili moonyi ti Mabasonuu ma Ngira ali mayaabisa buu mu ndaa a Yiisu. Na bakuusi mu ndaa a nde mandaa ma Mabasonuu makileele. ");
INSERT INTO iyx_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Baata boosi babali na Yiisu mu taanga di nde ati Laazaro mu upala mu ngili, na wamusiimbili mu babakwa, bakileele mandaa ma bo bamoni. ");
INSERT INTO iyx_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ni mu ndaa yii, koongi yayibwaana nde: baata bayuyi ti nde ali ayiluu iliimbi kia ukimuu ki. ");
INSERT INTO iyx_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mu yii, Bafarisi balelisini nha kati a bo: «Dimono, beni a dituu ndaa so mosi pe: dimono bu baata boosi bali mu uduku nde!» ");
INSERT INTO iyx_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kwali na ndaamba a basi Eleene nha kati a baata babayeni ku ngaanda a Yeruselemi ku mukuungi mu ukuundu Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Basi Eleene baa baswesii kwaa Filipo, wali musi Betesayida ku itinini kia Ngalili. Bo bamufuuli: «Pfumu, bisi dili na nzala ya umono Yiisu.» ");
INSERT INTO iyx_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipo ayileele kwaa Andere, tumake bo baboolo bayileele kwaa Yiisu. ");
INSERT INTO iyx_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yiisu wabavutili: «Nguungu yimaato yibakaanaangila Mwaana a muutu mu buzitu ba nde. ");
INSERT INTO iyx_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ee-e, ngwanya me nadileeli: libutu la bele limaabwa nha tsi lafwaana mu ukwa. Mbiiti lo a likwiiri pe, lo a libutu pe. Ka mbiiti lo likwiiri, lo sa libutu mbutu diavululu. ");
INSERT INTO iyx_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Muutu wu utoono idiingi a nde, sa ahelele kio. Ka mbii ti muutu tooni Nziaambi kwavulu utoono idiingi kia nde nha tsi nha, nde wuu sa akebe kio mu moonyi wa bilimi na bilimi. ");
INSERT INTO iyx_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","So muutu tooni usalila me, nyaala aduku me. Mu yii, musiali a me ka sa aba nha me ndi. Taayi a me sa anaangila muutu wuli mu usalila me.» ");
INSERT INTO iyx_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«Mu taanga di, mutimi a me maaviinzuu. Ima me nileele? Me ndeele ti, “Taata kuulu me mu mapasi ma nguungu yi?” Ngori, mundaa ti ni mu ndaa a nguungu yi me nayiri. ");
INSERT INTO iyx_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Taata, mweese buzitu ba kuumbu a we!» Mu taanga diina dii, muniingi ayuyini mu mayulu: «Me maamweese buzitu ba me, na me sa bwamweese bo.» ");
INSERT INTO iyx_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Koongi yali nhaa, na yayuyi muniingi wuu yaleeli: «Kii idumu kia nzieri!» Babakimi bakileele: «Tumu a Nziaambi maatsuu kwaa nde!» ");
INSERT INTO iyx_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yiisu wabaleeli: «A mu ndaa a me pe muniingi wuu ayuyini, ka mu ndaa a beni. ");
INSERT INTO iyx_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Diinadi ni taanga di bakaafuundusu tsi yi. Mu taanga di, Saatina pfumu a tsi yi, sa bamubingi ku mbari. ");
INSERT INTO iyx_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Mu taanga di bakaanaangila me, mu umaasa me nha tsi, me sa dutu baata boosi kwaa me.» ");
INSERT INTO iyx_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Mu mandaa maa, Yiisu akimweese buni nde akaakwa. ");
INSERT INTO iyx_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Koongi yamuvutili: «Bisi diayii mu mikaanda mia mikele mia bisi ti Kristo li moonyi taanga dioosi. Buni we utuu uleele ti Mwaana a muutu afwaana ti bamunaangila? Mwaana a muutu wuu na?» ");
INSERT INTO iyx_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yiisu abwileele: «Liyalila likeni nha kati a beni mu mwaana a taanga hoolo. Didiaata bu liyalila likeni nha kati a beni, paa pimisi dinyaala ubwilili beni. Mundaa ti, muutu wuli mu udiaata kutso pimisi a ayaaba pe ku nde ali mu uyene. ");
INSERT INTO iyx_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ni mu buu, disa imiini mu liyalila bu lo likeni nha kati a beni, paa beni diba baata ba liyalila.» Yiisu amana na uleele buu, nde ayeni na ayisweeme la na bo. ");
INSERT INTO iyx_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","So bu yili ti nde akiyiluu biliimbi bia ukimuu nha kulu a bo, bo a bakisa imiini mu nde pe. ");
INSERT INTO iyx_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Mu yii, mandaa maleeli mubili Yeesaya mayeni tsitsi: «Pfumu, na siiri imiini mu nziisili a bisi? Kwaa na Pfumu amweesi lituu la nde?» ");
INSERT INTO iyx_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Mubili Yeesaya abiindili ka, mu ima baata ba aba utuu pe usa imiini. ");
INSERT INTO iyx_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Nziaambi maadusu bo misi, Nde maakitisi mitimi mia bo miba miminono. Nde yilii buu paa misi mia bo minyaala umono, na paa mitimi mia bo minyaala ubahala. Ni mu buu, bo bali mu uhele ukiinguu kwaa me, paa me mbeelese bo.» ");
INSERT INTO iyx_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Mubili Yeesaya aleeli buu, mundaa ti nde ali amono buzitu ba Yiisu, na nde akitsuu mu nde. ");
INSERT INTO iyx_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ka bunu, balayi so nha kati a bakuutu ba Bayuudayo, basi imiini mu Yiisu. Ka, mu ndaa Bafarisi, bakuutu baa a bakileele buu nha kulu a baata pe, leeti a babingi bo mu nzo a makutunu ma Bayuudayo. ");
INSERT INTO iyx_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Bo bakiyiluu buu, mundaa ti bo bakivulu utoono buzitu bakimata kwaa baata, ka a bakimata kwaa Nziaambi pe. ");
INSERT INTO iyx_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yiisu aloyi: «Muutu wu usa imiini mu me, a mu me pe nde asiiri imiini, ka mu watsinduu me. ");
INSERT INTO iyx_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Wu umono me, moni ka watsinduu me. ");
INSERT INTO iyx_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Me nayiri nha tsi mu uyalisa yo, paa pasi wu usa imiini mu me, anyaala ubwaba kutso pimisi. ");
INSERT INTO iyx_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","So muutu yuyi mandaa ma me, na a asialili mo pe, me a nifuundusu muutu wuu pe. Mundaa ti, me a nayiri pe mu ufuundusu tsi, ka mu uyobolo tsi. ");
INSERT INTO iyx_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Muutu wu ubisi me, na wu uhele usiingi mandaa ma me, bayi mandaa mamufuundusu nde. Ni mandaa ma me makaafuundusu nde mu iluumbu kia tsieelele. ");
INSERT INTO iyx_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mu ngwanya, me a ndi mu utsuu pe mu ime makulu. Ka Taayi watsinduu me, atumu me nde makulu, ma me nafwaana uleele na uyiisi. ");
INSERT INTO iyx_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na me nayaaba ti, ma nde ali mu utumu mali mu ubiti ku moonyi wa bilimi na bilimi. Mu yii, mandaa ma me ndi mu uleele, me ndi mu uleele mo weti bu Taayi a me aleeli me mo.» ");
INSERT INTO iyx_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ali tswaamina mukuungi a Paaka uto. Yiisu ali ayaaba ti taanga dia nde dimaato. Ni taanga dia usiisi tsi yi, na uyene kwaa Taayi. Nde akitoono baba nde babali mu tsi. Nde atooni bo natee manini. ");
INSERT INTO iyx_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yiisu na miyii mia nde bakidia biloo bia tsitsii. Saatina ali amaakwamenese tsimi ya uyeelele Yiisu, mu mutimi a Yuuda, mwaana a Simooni Iskarioti. ");
INSERT INTO iyx_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yiisu ali ayaaba ti, Taayi ali asuusu bioosi nha tso mioo mia nde. Nde ali ayaaba ka ti, nde amati kwaa Nziaambi, na kwaa nde ali mu uvutuu. ");
INSERT INTO iyx_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Bu bo bali nha meese, Yiisu atemini, amaasi ikutu kia nde kia yulu. Nde aholi ilipili kibubaakoombolo maamba mu nyutu, ki nde akuti mu luungu. ");
INSERT INTO iyx_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tumake, nde aloosi maamba mu ikoombo, na abaandii uswaa miili mia miyii mia nde. Tumake, nde akikoombili mio, mu ilipili kiali mu luungu la nde. ");
INSERT INTO iyx_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Mu taanga di nde atoori nha kulu a Simooni Peetero, Peetero wamufuuli: «Pfumu, we uswaa me miili?» ");
INSERT INTO iyx_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yiisu wamuvutili: «Mu taanga di, we a li mu uyaaba pe ma me ndi mu uyiluu. Ka bweele we sa yaaba.» ");
INSERT INTO iyx_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peetero wamuleeli: «Ngori, we utuu pe uswaa me miili!» Ka Yiisu avutili: « Mbiiti me a swayi we miili pe, we a ubwaba muyii a me pe.» ");
INSERT INTO iyx_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ninha Simooni Peetero avutili: «Mbiiti buu Pfumu, a uswaa me ndila miili pe. Swaa ka mioo na mutswe a me!» ");
INSERT INTO iyx_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yiisu abwileele: «Muutu wumaayobo, a ali na nzala a ubwayobo pe. Ka helape ndila miili butuu uswaa nde, mundaa ti nde li atsieeme nyutu yoosi. Beni dili diatsieeme, ka a beni boosi pe.» ");
INSERT INTO iyx_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yiisu ali ayaaba muutu wukaayeelele nde. Ni mu buu, nde aleeli: «A beni boosi pe dili diatsieeme.» ");
INSERT INTO iyx_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nha mbisi a uswaa bo miili, Yiisu abwilwaata ikutu kia nde, na avutii nha meese. Nde wabaleeli: «Beni dili mu uyaaba tsutulu a ndaa yi me swayi beni miili? ");
INSERT INTO iyx_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Beni dili mu uta me “Muyiisi” na “Pfumu”, beni dili na buungu, mundaa ti me ndi buu. ");
INSERT INTO iyx_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ka mbiiti me wuli, Pfumu na Muyiisi a beni, me maaswaa beni miili, beni ka diafwaana uyiluu bumosi bana mu bana. ");
INSERT INTO iyx_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Me mweesi beni buu, paa beni ka disa weti bu me siiri mu beni. ");
INSERT INTO iyx_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mu ngwanya, me nadileeli: musiali a avulu pe pfumu a nde mu ndutu. Bumosi ka, tumu a avulu pe watsinduu nde. ");
INSERT INTO iyx_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mu taanga di, beni diyaabi mandaa maa. Mbiiti beni disialili mo, beni sa diba mu kinyi.» ");
INSERT INTO iyx_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«Me a ndi mu utsuu pe mu ndaa beni boosi. Me nayaaba ba me nasoolo. Ka toono mandaa Mabasonuu ma Ngira mayene tsitsi: “Muutu wu me naba mu ukaba lipa na nde, maakaluu ku yulu a me.” ");
INSERT INTO iyx_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Me ndi mu ukwaleele beni yo mu taanga di, tswaamina mandaa muyilimi, paa nha mandaa muyilimi, beni disa imiini ti “me ni muutu wu me ndi mu uleele ti me ndi.” ");
INSERT INTO iyx_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ee-e, ngwanya me nadileeli: wu uyaka muutu wu me natsinduu, yaki me ka. Na wu uyaka me, yaki ka watsinduu me.» ");
INSERT INTO iyx_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nha mbisi a uleele mandaa maa, mutimi a Yiisu aviinzii. Nde aleeli na yaki-yaki: «Ngwanya me nadileeli: mosi mu beni sa ayeelele me.» ");
INSERT INTO iyx_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Miyii miatalisini mio na mio, kwahele a uyaaba, mu na Yiisu akitsuu. ");
INSERT INTO iyx_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mosi mu miyii, wu Yiisu ali atoono kwalaa, ali adiaala nha bele a Yiisu. ");
INSERT INTO iyx_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simooni Peetero atumi nde mu ufuulu kwaa Yiisu, mu na nde akitsuu. ");
INSERT INTO iyx_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Muyii wuu abaandini nha bele a Yiisu, na wamufuuli: «Pfumu, muutu wuu ni na?» ");
INSERT INTO iyx_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yiisu avutili: «Me sa tsubu itsuru kia lipa mu ikoombo. Wuu wu me kaaha itsuru kii, ni nde.» Yiisu aholi itsuru kia lipa, atsubi kio mu ikoombo na ahi kio kwaa Yuuda, mwaana Simooni Iskarioti. ");
INSERT INTO iyx_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yuuda amana na uholo itsuru kia lipa, Saatina akoti mu mutimi a nde. Yiisu wamuleeli: «Ndaa yi we li mu unhana uyiluu, yiluu yo mawasa!» ");
INSERT INTO iyx_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Muutu so mosi pe mu babali nha meese, wayaabi mu ima Yiisu akileele buu kwaa Yuuda. ");
INSERT INTO iyx_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yuuda bu ali mukaangi a ipokolo kia mboongo dia twaari, babamosi mu bo bakitsimi ti Yiisu wamutumi mu uyasuumbu bi bo bali na nzala a bio mu ndaa mukuungi. So a buu pe, mu uyaha bungori kwaa bawele. ");
INSERT INTO iyx_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ni mu buu, Yuuda aholi itsuru kia lipa, na nhaa-na-tsi nde apali. Ali ka butsuu. ");
INSERT INTO iyx_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nha mbisi a nha Yuuda apali, Yiisu aleeli: «Mu taanga di, buzitu ba Mwaana a muutu bamaamonuu, na buzitu ba Nziaambi bumonii mu nde. ");
INSERT INTO iyx_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Na mbiiti buzitu ba Nziaambi bamonii mu nde, Nziaambi ka sa amweese mu nde makulu, buzitu ba Mwaana. Na nde sa ayiluu buu, mawasa-mawasa. ");
INSERT INTO iyx_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Baana ba me, taanga ndila hoolo dimaasala me mu uba itwaari na beni. Beni sa disaa me. Weti bu me naleeli yo kwaa Bayuudayo babamosi, me nileele yo kwaa beni ka: “Beni a dituu pe uyene ku me ndi mu uyene.” ");
INSERT INTO iyx_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Me niha beni tumini dinyatii: ditonosono bana mu bana. Beni diafwaana mu utonosono bana mu bana weti bu me naditooni. ");
INSERT INTO iyx_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","So beni dili na litoono bana mu bana, baata boosi sa bayaaba ti beni dili miyii mia me.» ");
INSERT INTO iyx_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simooni Peetero wamufuuli: «Pfumu, we kuni li mu uyene?» Yiisu wamuvutili: «Ku me ndi mu uyene, we a utuu pe uduku me kuu, mu taanga di. Ka mbari we sa duku me.» ");
INSERT INTO iyx_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peetero wamuleeli: «Pfumu, mu ima me utuu pe uduku we mu taanga di? Me sa ha moonyi a me mu we!» ");
INSERT INTO iyx_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yiisu avutili: «We sa ha moonyi a we mu me? Ngwanya me nileele kwaa we ti, tswaamina tsutsu ukookolo, we sa tunu me mbala tata.» ");
INSERT INTO iyx_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yiisu wabaleeli: «A diviinzili mitimi mia beni pe. Beni diasa imiini mu Nziaambi, disa ka imiini mu me. ");
INSERT INTO iyx_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Uli na mambuu mamalayi mu nzo a Taayi a me. So ali a buu pe, me a nakeni pe uleele beni ti, me ndi mu uyayiluu beni mbuu. ");
INSERT INTO iyx_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na mbiiti me ndi mu uyayiluu beni mbuu, me sa yiri avutuu. Na me sa holo beni na me, paa kuu ku me ndi, beni ka diba nha mbuu yii. ");
INSERT INTO iyx_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Beni diayaaba kuulu yili mu ubiti ku me ndi mu uyene.» ");
INSERT INTO iyx_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toma wamuleeli: «Pfumu, bisi a diayaaba pe ku we li mu uyene. Buni bisi dituu uyaaba kuulu?» ");
INSERT INTO iyx_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yiisu wamuvutili: «Me ndi kuulu, ngwanya na moonyi. A uli na muutu pe wu utuu uyiri kwaa Taayi, so nde a yoyi pe kwaa me. ");
INSERT INTO iyx_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Mbiiti beni diayaaba me, beni sa diyaaba ka Taayi. Na, umata mu taanga di, beni dimaayaaba nde, na dimaamono nde.» ");
INSERT INTO iyx_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipo wamufuuli: «Pfumu, mweese bisi Taayi, na sa bukuu kwaa bisi.» ");
INSERT INTO iyx_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yiisu wamuvutili: «Umatuu bele pe me ndi na beni, ka beni keni a diayaaba me pe, Filipo? Muutu wumoni me, moni ka Taayi. Buni we utuu uleele: “Mweese bisi Taayi?” ");
INSERT INTO iyx_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","We a li mu usa pe imiini ti, me ndi mu Taayi, na Taayi li mu me? Mandaa ma me ndi mu uleele beni, a mali mu umata pe kwaa me. Ni Taayi wuli mu uba mu me, li mu ukuusu biyiluu bia nde makulu. ");
INSERT INTO iyx_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Disa imiini mu me, mu taanga di me ndi mu uleele: me ndi mu Taayi, na Taayi li mu me. So a buu pe, disa imiini so mundaa a biyiluu bio makulu.» ");
INSERT INTO iyx_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","«Ee-e, ngwanya me nadileeli: wu usa imiini mu me, sa asa ka biyiluu bi me ndi mu usa. Nde sa asa ka so biavulu bunene, mundaa ti me ndi mu uyene kwaa Taayi. ");
INSERT INTO iyx_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Na bioosi bi beni dikaaloombo mu kuumbu a me, me sa nadiyiluu bio, paa Mwaana amweese buzitu ba Taayi. ");
INSERT INTO iyx_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","So beni diloombi me iloo mu kuumbu a me, me sa yiluu kio.» ");
INSERT INTO iyx_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Mbiiti beni diatoono me, beni sa ditumumu mikele mia me. ");
INSERT INTO iyx_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Me sa loombo kwaa Taayi mu uha beni Mubaasili, wukaaba na beni taanga dioosi. ");
INSERT INTO iyx_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ni Muheebili wuli mu umweese ngwanya. Baata ba tsi a butuu uyaka nde pe, mundaa ti bo a bali mu umono nde pe, na a bayaaba nde pe. Ka beni, beni diayaaba nde, mundaa ti nde li mu uba na beni, na nde sa abaabaanganga mu beni taanga dioosi.» ");
INSERT INTO iyx_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","«Me a nisiisi pe beni, beni bake weti bitsaana. Me sa yiri avutuu kwaa beni. ");
INSERT INTO iyx_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Taanga hoolo dimaasaala, na tsi a yibwamono me pe. Ka beni, sa dimono me. Mundaa ti, me ndi moonyi, na beni ka sa diba moonyi. ");
INSERT INTO iyx_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mu iluumbu kii, beni sa diyaaba ti me ndi moonyi mu Taayi a me. Beni sa diyaaba ka ti, beni dili moonyi mu me, na me ka ndi moonyi mu beni. ");
INSERT INTO iyx_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Muutu wu uyaka mikele mia me, na tumimi mio, nde wuu ni watoono me. Wu utoono me, Taayi a me ka sa atoono nde. Me ka sa toono nde, na me sa yabina kwaa nde.» ");
INSERT INTO iyx_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuuda, a wa Iskarioti pe, afuuli Yiisu: «Pfumu, buni we uyabina ndila kwaa bisi, ka a kwaa tsi pe?» ");
INSERT INTO iyx_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yiisu avutili: «Muutu watoono me, sa atumumu mandaa ma me, na Taayi a me sa atoono nde. Bisa Taayi a me, sa diyiri kwaa muutu wuu. Na bisi sa didiaala mu nde. ");
INSERT INTO iyx_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Muutu wahele utoono me, a ali mu utumumu pe mandaa ma me ndi mu uleele. Na mandaa ma beni dili mu uyuu me mu uleele, a mali mu umata pe kwaa me. Ka kwaa Taayi a me watsinduu me, mo mali mu umata.» ");
INSERT INTO iyx_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«Me ndeeli beni mo, mu taanga di me keni itwaari na beni. ");
INSERT INTO iyx_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Mubaasili a beni, Muheebili wa Ngira wu Taayi akaatsinduu mu kuumbu a me, sa ayiisi beni mandaa moosi. Na nde sa alibili beni moonyi, mu moosi ma me ndeeli beni.» ");
INSERT INTO iyx_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«Iyeenge me ndi mu usiisi kwaa beni. Ni iyeenge kia me, me heeri kwaa beni. Me a ndi mu uha beni kio weti bu tsi yili mu uha pe. A diviinzili mitimi mia beni pe, a diba na boomo pe. ");
INSERT INTO iyx_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Beni diyuyi bu me ndeeli: “Me ndi mu uyene, ka me sa yiri avutuu kwaa beni.” Mbiiti beni diatoono me mu ngwanya yoosi, beni diakeni uba na kinyi mu uyaaba ti me ndi mu uyene kwaa Taayi. Mundaa ti, Taayi avulu me mu bunene. ");
INSERT INTO iyx_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Me maakwaleele beni yo mu taanga di, tswaamina mandaa muyilimi, paa nha mandaa muyilimi, beni disa imiini. ");
INSERT INTO iyx_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Me a nibwatsuu pe kwalaa na beni, mundaa ti pfumu a tsi yi, li mu uyiri. Nde a ali na lituu so hoolo nha yulu a me pe. ");
INSERT INTO iyx_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ka tsi yafwaana mu uyaaba ti me natoono Taayi, na ti me ndi mu uyiluu weti bu Taayi atumu me. Ditemene, dimatani nha mbuu yi!» ");
INSERT INTO iyx_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«Me ndi muti a viinyi wa ngwanya, na Taayi a me li ngaa tsiee a viinyi. ");
INSERT INTO iyx_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nde li mu ukese pasi paki, lanambata mu me, na lili mu uhele ubutu mbutu. Ka nde li mu utsieemese pasi paki lili mu ubutu mbutu, paa lo libutu mbutu diavulu bulayi. ");
INSERT INTO iyx_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Beni diamaakwatsieeme, mundaa a ndaa yi me ndeeli kwaa beni. ");
INSERT INTO iyx_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Dinambata mu me, weti bu me nanambata mu beni. Paki a lili mu ubutu mbutu mu ilo makulu pe, kwahele a unambata mu muti a viinyi. Bumosi, beni ka a dituu ubutu mbutu pe, mbiiti beni a dinambata pe mu me.» ");
INSERT INTO iyx_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«Me ndi muti a viinyi, na beni dili mapaki. Muutu wu unambata mu me, na wu me nanambata mu nde, li mu ubutu mbutu dialaa. Mundaa ti, kwahele a me, beni a dituu uyiluu ndaa so mosi pe. ");
INSERT INTO iyx_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Muutu wu uhele unambata mu me, sa badumunu nde ku mbari, weti bu bubaadumunu paki, na nde sa akanya. Mapaki makanya, koo bali mu utolo mo, bali mu udumunu mo ku mbaa, na mali mu unyeenge. ");
INSERT INTO iyx_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","So beni dinambata mu me, na mandaa ma me mabeeri mu beni, diloombo bi beni diatoono, na sa bayiluu buu mu beni. ");
INSERT INTO iyx_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Dimono bu buzitu ba Taayi a me bali mu uyabina. Bo bali mu umonuu mu taanga di beni dili mu ubutu mbutu dindayi, na beni dili mu umweese ti, beni dili miyii mia me.» ");
INSERT INTO iyx_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","«Weti bu Taayi atoono me, ni buu ka me ka natoono beni. Diba kutso litoono la me. ");
INSERT INTO iyx_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mbiiti beni dili mu utumumu mikele mia me, beni diafwaana uba kutso litoono la me, weti bu me ndi mu utumumu mikele mia Taata, na me ndi mu uba kutso litoono la nde. ");
INSERT INTO iyx_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Me ndeeli beni buu paa kinyi a me yiba mu beni, na paa kinyi a beni yiba yakuu. ");
INSERT INTO iyx_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Dimono mukele a me: Ditonosono bana mu bana, weti bu me naditoono.» ");
INSERT INTO iyx_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","«Litoono lavulu bunene li muutu utuu umweese, ni la uyeelele moonyi a nde mu bambaayi ba nde. ");
INSERT INTO iyx_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Beni dili bambaayi ba me, mbiiti beni dili mu uyiluu mi me ndi mu utumu beni. ");
INSERT INTO iyx_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Me a ndi mu ubwata beni basiali pe, mundaa ti musiali a ayaaba pe mandaa mali mu uyiluu pfumu a nde. Me ndi mu uta beni bambaayi, mundaa ti me maalaa beni mandaa moosi ma me nayii kwaa Taayi a me. ");
INSERT INTO iyx_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","A beni pe diasoolo me, ka me nasoolo beni. Me maaha beni isala paa beni diyene na dibutu mbutu, na mbutu dididiingi. Mu yii, Taayi a me sa wadiha bioosi bi beni diloombo mu kuumbu a me. ");
INSERT INTO iyx_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ni mu buu, ndaa yi me ndi mu utumu beni, ni utonosono bana mu bana.» ");
INSERT INTO iyx_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Mbiiti tsi yili mu ubele beni, diyaaba ti yo yakwabele me, tswaamina yo yibele beni. ");
INSERT INTO iyx_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mbiiti beni ali baata ba tsi, keni tsi yakeni utoono bibili bia nde. Ka beni a dili baata ba tsi pe. Me nasoolo beni nha kati baata ba tsi, na paa beni diba ba me. Ni mu buu, tsi yili mu ubele beni. ");
INSERT INTO iyx_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Dilibili moonyi mu ndaa yi me ndeeli beni: “Musiali a avulu pfumu a nde mu ndutu pe.” Mbiiti bo bamaabingisi me, bo sa babingisi beni ka. Mbiiti bo bamaatumumu ndaa a me, bo sa batumumu ka ndaa a beni. ");
INSERT INTO iyx_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ka bo sa babingisi beni mu ndaa kuumbu a me. Mundaa ti, bo a bayaaba pe watsinduu me.» ");
INSERT INTO iyx_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","«Mbiiti me ali a nayiri pe, na a nali na natsuu pe kwaa bo, bo a bakeni uba na masumu pe. Ka mu taanga di, bo ka buungu pe mu ndaa masumu ma bo. ");
INSERT INTO iyx_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Muutu wuli na ibelili mu me, li na ibelili ka mu Taayi a me. ");
INSERT INTO iyx_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mbii ti me a nali nayiluu nha kati a bo, biyiluu bili ti muutu keni a ayiluu pe, bo a bakeni uba na masumu pe. Ka bunu, bo bamoni biyiluu bia me, na bo bali mu ubele me na Taayi a me. ");
INSERT INTO iyx_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ka maa mali mu uyilimi, paa mabasonuu mu mikele mia bo mayene tsitsi: “Bo babeli me kwahele a toono.” ");
INSERT INTO iyx_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Mu taanga di Mubaasili a beni akaayiri, wu me kaatsinduu beni mu kuumbu a Taayi, ni Muheebili wuli mu umweese ngwanya, na wuli mu umata kwaa Taayi, nde sa ata imbaangi mu me. ");
INSERT INTO iyx_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Na beni ka, sa dita imbaangi mu me, mundaa ti beni diali na me, umatuu mu mbaandili.» ");
INSERT INTO iyx_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Me ndeeli beni ndaa yii, paa beni dinyaala ubwiisi imiini. ");
INSERT INTO iyx_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Sa babingi beni mu manzo ma makutunu ma Bayuudayo. Na, taanga dili mu uyiri di babudusu beni bakaatsimi ti, bo Nziaambi bali mu usalila, mu pili yii. ");
INSERT INTO iyx_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bo sa bayiluu buu, mundaa ti bo a bayaaba so Taayi pe, so me pe. ");
INSERT INTO iyx_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ka me maayaabisa beni yo, paa bu taanga dii dikaato, beni dilibili moonyi ti me nayaabisi beni yo.» «Me a nayaabisi pe beni yo mu mbaandili, mundaa ti me ali itwaari na beni. ");
INSERT INTO iyx_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Mu taanga di, me ndi mu uyene kwaa watsinduu me. So mosi pe mu beni wuli mu ufuulu me: “We kuni li mu uyene?” ");
INSERT INTO iyx_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ka mundaa ti me ndeeli beni mandaa ma, mitimi mia beni mimaaluulu mu ngebe. ");
INSERT INTO iyx_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ka bunu, me ndi mu uleele beni ngwanya: yavulu bubwe mu beni me yene. Mundaa ti, mbiiti me a yeni pe, Mubaasili a uyiri kwaa beni pe. Ka so me yeni, na me sa tsinduu beni nde. ");
INSERT INTO iyx_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Na mu taanga di nde akaayira, nde sa atungululu baata ba tsi yi, mu masumu ma bo, sa mweese bo libweeye la Nziaambi, na pfuundisi yi Nziaambi a kaa sa. ");
INSERT INTO iyx_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Mundaa yatala masumu, Nde sa atungululu bo mundaa ti bo a bali mu usa imiini mu me pe. ");
INSERT INTO iyx_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Mu yatala libweeye la Nziaambi, Nde sa amweese bo matoono ma bo mundaa ti, me ndi mu uyene kwaa Taayi, na beni a dibwamono me pe. ");
INSERT INTO iyx_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Mu ndaa yatala pfuundisi, Nde sa amweese bo matoono ma bo, mundaa ti Nziaambi sa afuundusu pfumu a tsi yi.» ");
INSERT INTO iyx_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Me keni na mandaa malaa ma uleele kwaa beni, ka mu taanga di, beni a dituu pe ukutu mutimi mu uyuu mo. ");
INSERT INTO iyx_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ka mu taanga di Muheebili wuli mu umweese ngwanya akaayira, nde sa wadibiti kutso ngwanya yoosi. Nde a akaatsuu pe mu nde makulu, ka nde sa aleele mioosi mi nde akaayuu kwaa me. Nde sa ayaabisa beni mandaa mamafwaana uyira. ");
INSERT INTO iyx_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nde sa amweese buzitu ba me, mundaa ti mandaa ma nde akaayaabisa beni, kwaa me makaamata. ");
INSERT INTO iyx_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Bioosi bibili bia Taayi, bili ka bia me. Ni mu buu me ndeeli ti, “Mandaa ma Muheebili akaayaabisa beni, kwaa me makaamata.”» ");
INSERT INTO iyx_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Ndili a mwaana a taanga hoolo dimaasaala, na beni a dibwamono me pe. Tumake, mwaana a taanga hoolo nha mbisi a nhaa, beni sa dibwamono me.» ");
INSERT INTO iyx_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Babamosi mu miyii mia Yiisu, mialelisini: «Nde ima ali mu unhana uleele bisi? Nde maaleele: “Ndili a mwaana a taanga hoolo dimaasaala, na beni a dibwamono me pe. Tumake, mwaana a taanga hoolo nha mbisi a nhaa, beni sa dibwamono me.” Nde maaleele ka: “Me ndi mu uyene kwaa Taayi.” ");
INSERT INTO iyx_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“Mwaana a taanga hoolo”, mambiindili mama? Bisi a dili mu uyaaba pe nde ima anhana uleele.» ");
INSERT INTO iyx_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yiisu ayaabi ti bo ali na nzala ya ufuulu nde manduru. Ninha nde wabambiindili: «Beni dili mu ufulusunu, mu uyaaba tsutulu a mandaa ma me ndeeli: “Ndili a mwaana a taanga hoolo dimaasaala, na beni a dibwamono me pe. Tumake, mwaana a taanga hoolo nha mbisi a nhaa, beni sa dibwamono me.” ");
INSERT INTO iyx_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ee-e, ngwanya me nadileeli: beni sa dilili, na beni sa dikoto mu minyoongo. Ka baata ba tsi, sa bayaanga. Beni sa diba mu ngebe, ka ngebe dia beni sa dikituu makinyi. ");
INSERT INTO iyx_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mu taanga di mukaasa ali mu ubaa misoongo, nde ubaaba mu ngebe, mundaa ti taanga dia mapasi ma nde dimaato. Ka mu taanga di mwaana ali mu ubutuu, nde li mu udiimbili mapasi ma nde. Nde ubaaba na kinyi yalaa, mundaa ti nde maabutu mwaana. ");
INSERT INTO iyx_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ni mu buu, beni ka dili mu minyoongo mu taanga di. Ka me sa bwamonono na beni, na mitimi mia beni sa miba na kinyi. Muntaanga dii, muutu so mosi pe wukaamaasa beni kinyi a beni.» ");
INSERT INTO iyx_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","«Bu iluumbu kii ikaato, beni a dibwafuulu me nduru mu ndaa so mosi pe. Ee-e, ngwanya me nadileeli: pasi iloo ki beni diloombo kwaa Taayi mu kuumbu a me, nde sa wadiha kio. ");
INSERT INTO iyx_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Natee mu taanga di, beni keni a dialoombo iloo so imosi pe mu kuumbu a me. Diloombo, na sa badiha. Na kinyi a beni sa yiba yakuu.» ");
INSERT INTO iyx_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Me maa leele beni mandaa maa moosi mu usalila bifwafwani na matsaba. Ka mu taanga dikaayira, me a ni bwatsuu mu bifwaani na matsaba pe. Ka me sa yaabisa beni na yaki-yaki, mandaa matala Taayi. ");
INSERT INTO iyx_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Mu iluumbu kii, beni sa diloombo ma beni dili na nzala mo kwaa Taayi, mu kuumbu a me. Me a ndi mu uleele beni pe ti, me sa kuundu Taayi mu ndaa a beni. ");
INSERT INTO iyx_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Mundaa ti Taayi nde makulu atoono beni. Nde atoono beni mundaa ti beni diatoono me, na mundaa ti beni diasa imiini ti me namata kwaa Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Me namata kwaa Taayi, na me nayiri nha tsi. Mu taanga di, me ndi mu usiisi tsi, na me ndi mu uvutuu kwaa Taayi.» ");
INSERT INTO iyx_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Miyii mia nde miamuleeli: «Maamono, nha ka we ka mu utsuu na yaki-yaki, kwahele a usalila bifwafwani! ");
INSERT INTO iyx_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mu taanga di, bisi di maayaaba ti we akwayaaba mandaa moosi, tswaamina bufuulu we manduru. Ni mu buu, bisi dili mu usa imiini ti we amata kwaa Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yiisu abwileele: «Nha ka beni diamaasa imiini? ");
INSERT INTO iyx_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ka, taanga hoolo dimaasaala, na dio diamaato, di beni dikaatsaamuu. Beni sa dibata muutu muutu ku nzo a nde, na beni sa disiisi me mebake. Ka me a ndi mebake pe, mundaa ti Taayi li itwaari na me. ");
INSERT INTO iyx_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Me maaleele beni mandaa maa moosi, paa beni diba mu iyeenge, mundaa beni dianambata mu me. Beni sa dimono mapasi mu tsi. Ka dilwaata ibaala! Me maabiingi nha yulu a tsi!» ");
INSERT INTO iyx_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Bu Yiisu amani na utsuu buu, nde asiimbili misi ku yulu na aleeli: «Taata, nguungu yimaato. Mweese buzitu ba Mwaana a we, paa Mwaana ka amweese buzitu ba we. ");
INSERT INTO iyx_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","We aha nde lituu nha yulu a baata boosi, paa nde aha moonyi kwaa baa ba we aha kwaa nde. ");
INSERT INTO iyx_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Na, moonyi wa bilimi na bilimi, ni uyaaba we Nziaambi wa ngwanya ndila mosi, na uyaaba Yiisu Kristo wu we atsinduu. ");
INSERT INTO iyx_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Me maamweese buzitu ba we nha tsini a toto nha, bu me mani isala ki we aha me usa. ");
INSERT INTO iyx_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Mu taanga di, Taata mweese buzitu ba me. Ni buzitu ba me nali na bo nha kulu a we, tswaamina tsi yiba. ");
INSERT INTO iyx_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Me maasa ti baata ba we aha me nha tsi, bayaaba we. Bo bali baata ba we, we aha bo kwaa me, na bo batumimi ndaa a we. ");
INSERT INTO iyx_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Mu taanga di, bo bamaayaaba ti bioosi bi we aha kwaa me, kwaa we biamata. ");
INSERT INTO iyx_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mundaa ti, me maaha kwaa bo mandaa ma we aha kwaa me. Bo bamaayaka mo, bo bamaayaba ti ngwanya me kwaa we namata. Na bo bamaasa imiini ti we atsinduu me.» ");
INSERT INTO iyx_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«Me ndi mu ukuundu we mundaa a bo. Me a ndi mu ukuundu pe mundaa baata ba tsi, ka mundaa a baata ba we aha kwaa me. Mundaa ti bo baata ba we bali. ");
INSERT INTO iyx_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Bioosi bibili bia me, ni bia we, na bioosi bibili bia we, ni bia me. Na buzitu ba me, bali mu umonuu mu bo. ");
INSERT INTO iyx_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Taanga hoolo dimaasaala, na me a nabwasaala pe nha tsi, ka bo nha tsini a toto bali. Me ndi mu uyiri kwaa we. Taata wa Ngira, kebe bo babanambita mu we, we wuli mu me, paa bo baba muutu mosi, weti bu bisa-we dili muutu mosi. ");
INSERT INTO iyx_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Mu taanga di me nali itwaari na bo, me nakikebe bo mu litu la kuumbu a we, ni litu liwe aha kwaa me. Me nakali bo, na so mosi mu bo pe wadiimbili, nha yulu a wuu wu uyene ku ndiimbisi a nde. Nde afwaana udimbili, paa Mabasonuu ma Ngira mamaayene tsitsi. ");
INSERT INTO iyx_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ka mu taanga di, me ndi mu uyiri kwaa we. Me ndi mu uleele mandaa ma bu me keni nha tsini a toto, paa bo baba na kinyi a me mu bo, kinyi yakuu. ");
INSERT INTO iyx_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Me maaha bo ndaa a we, na tsi yili mu ubele bo, mundaa ti, bo a bali baata ba tsi pe, weti bu me ka nahele uba wa tsi. ");
INSERT INTO iyx_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Me a ndoombi kwaa we pe paa we maasa bo nha tsi, ka mu ukala bo kwaa Wumubi. ");
INSERT INTO iyx_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Bo a bali baata ba tsi pe, weti bu me makulu nahele uba wa tsi. ");
INSERT INTO iyx_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Biaalisa bo mu ngwanya. Ndaa a we ni ngwanya. ");
INSERT INTO iyx_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Weti bu we atsinduu me nha tsini a toto, me ka maatsinduu bo nha tsini a toto. ");
INSERT INTO iyx_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Me maayeelele nyutu a me yoosi kwaa we mundaa a bo, paa bo ka bayeelele manyutu ma bo moosi mu isala kia we mu ngwanya.» ");
INSERT INTO iyx_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Me a ndi mu ukuundu pe ndila mu bo, ka mundaa baata boosi bakaasa ka imiini mu me, mundaa a mandaa ma bo buleele mu kuumbu a me. ");
INSERT INTO iyx_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Me ndi mu ukuundu paa bo boosi baba muutu mosi. Taata, nyaala bo baba muutu mosi na bisi, weti bu we li muutu mosi na me, na weti bu me ndi muutu mosi na we. Nyaala bo baba muutu mosi, paa tsi yisa imiini ti, we atsinduu me. ");
INSERT INTO iyx_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Me maaha bo buzitu ba we aha me, paa bo baba muutu mosi, weti bu bisa-we dili muutu mosi. ");
INSERT INTO iyx_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Me ndi moonyi mu bo, na we li moonyi mu me. Ni buu bo bakaaba muutu mosi mu ngwanya, paa tsi yiyaaba ti we atsinduu me. Na, tsi yiyaaba ka ti, we atoono bo weti bu we atoono me.» ");
INSERT INTO iyx_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«Taata, me ndi na nzala ti baata ba we aha kwaa me baba na me ku me ndi, paa bo bamono buzitu ba me. Ni buzitu ba we aha me, mundaa ti we atooni me tswaamina nzilimini a tsi. ");
INSERT INTO iyx_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Taata walibweeye, tsi a yayaaba we pe, ka me nayaaba we. Na miyii mia me mimaayaaba ti, we atsinduu me. ");
INSERT INTO iyx_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Me maayaabisa kuumbu a we kwaa bo, na me sa bwayaabisa yo, paa litoono li we atoono me liba mu bo, na me makulu ka me mba mu bo.» ");
INSERT INTO iyx_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yiisu bu amani na utsuu mandaa maa, nde asiabii na miyii mia nde ku simi lilimosi la muwiili a maamba wa kuumbu Kederoni. Bo bakoti mu luumbu lali mu simi lii. ");
INSERT INTO iyx_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yuuda muyeelili a Yiisu, ali ayaaba ka mbuu yii. Mundaa ti, Yiisu na miyii mia nde bali na ipfu kia ukukunu kuu. ");
INSERT INTO iyx_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ni mu buu, Yuuda ayeni ku luumbu lii. Na nde abiti mukaanga a masodaare na bakebi ba nzo a Nziaambi, ba banguu ba bangaanga ba Nziaambi na Bafarisi bamuhi. Bo bali na bidwaanini, na babiti miindi na bikukunu bia mbaa. ");
INSERT INTO iyx_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yiisu wali wayaaba mioosi mikaabwiilili nde, asweesii kwaa bo na wabafuuli: «Beni na dili mu usaa?» ");
INSERT INTO iyx_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Bo bamuvutili: «Yiisu musi Nazareti». Yiisu wabaleeli: «Me ndio wu!» Na Yuuda muyeelili a nde, ali atemene nhaa na bo. ");
INSERT INTO iyx_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nha Yiisu aleeli ti me ndio wu, bo bavutii mbisi na babwi nha tsi. ");
INSERT INTO iyx_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yiisu abwifuulu bo: «Beni na dili mu usaa?» Bo babwileele: «Yiisu musi Nazareti». ");
INSERT INTO iyx_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yiisu avutili: «Me maaleele beni ti ni me. Mbiiti beni me dili mu usaa, dinyaala babamosi bayene.» ");
INSERT INTO iyx_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yiisu atsuyi buu, paa mandaa ma nde aleeli mayene tsitsi: «Taata, me a maadiimbisi pe so mosi mu ba we aha kwaa me.» ");
INSERT INTO iyx_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simooni Peetero wali na mukasa, apalisi nde. Nde ateti musiali a nguu a ngaanga a Nziaambi, na wamukesi litswi la koo kia babaala. Kuumbu a musiali wuu ali Malakusi. ");
INSERT INTO iyx_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ka Yiisu aleeli kwaa Peetero: «Vutulu mukasa a we mu isweehili kia nde. We buli mu utsimi ti me a aninywa pe mbasa ya mapasi yi Taata amaaha kwaa me?» ");
INSERT INTO iyx_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mu taanga dii, mukaanga a masodaare na mukuutu a bo, na bakebi ba nzo a Nziaambi bakaangi Yiisu na bamukuti bibolo. ");
INSERT INTO iyx_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Bo bakwibiti nde kwaa nguu a bangaanga ba Nziaambi wa kuumbu Ane. Ane ali buko ba Kayifa, mukuutu a banguu ba bangaanga ba Nziaambi mu ilimi kii. ");
INSERT INTO iyx_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaba Kayifa ali aha ndoongi yi kwaa bakuutu ba Bayuudayo: «Yavulu bubwe muutu ndila mosi akwa mu toono a baata boosi.» ");
INSERT INTO iyx_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simooni Peetero na muyii mosi mukimi bakiduku Yiisu. Nguu a bangaanga ba Nziaambi ali ayiluu uyaaba muyii mukimi wuu. Ni mu buu, bo bakoti mbala mosi na Yiisu mutso lipaanga la nguu a bangaanga ba Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ka Peetero asiaali ku mbari, nha bele a munywa a lipaanga. Muyii mukimi wuu, wali wayabina kwaa nguu a bangaanga ba Nziaambi apali ku mbari a lipaanga. Nde atsuyi na mukaasa wakikebe munywa lipaanga, na tumake nde akotisi Peetero kutso lipaanga. ");
INSERT INTO iyx_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mukaasa wuu afuuli Peetero: «We ka a li pe mosi mu miyii mia baala lii?» Peetero avutili: «Ngori, me a ndi muyii a nde pe!» ");
INSERT INTO iyx_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ali na kioori kiavululu. Ni mu buu, basiali na bakebi bali badiaala nha mukoo a mbaa, mu uyoto mbaa. Peetero ka akiyoto mbaa na bo. ");
INSERT INTO iyx_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Nguu a bangaanga ba Nziaambi, afuuli Yiisu manduru mu ndaa miyii mia nde, na mundaa nziisili yi nde akiyiisi. ");
INSERT INTO iyx_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yiisu wamuvutili: «Me nakitsuu nha kulu a baata boosi. Na taanga dioosi, me nakiyiisi mu nzo a makutunu ma Bayuudayo, na mutso lipaanga la nzo a Nziaambi. Ni kuu ku Bayuudayo boosi bali mu ukukunu. Me a naleeli ndaa so mosi mu tsweeyi pe. ");
INSERT INTO iyx_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Mu ima we li mu ufuulu me manduru ma pili yii? Fuulu kwaa babakiyuu me, ima me naleele kwaa bo: bo bayaaba ma me naleele.» ");
INSERT INTO iyx_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Mu mandaa maa, mosi mu bakebi bali nhaa, ateti Yiisu mbata. Nde wamuleeli: «Yi mvutu yi we uha kwaa nguu a bangaanga ba Nziaambi?» ");
INSERT INTO iyx_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yiisu avutili: «Leele me, ki ndaa yimbi me maaleele? Ka mbiiti ma maaleeli, ngwanya mali, mu ima we li mu utete me?» ");
INSERT INTO iyx_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nguu a bangaanga ba Nziaambi wa kuumbu Ane, atsinduu nde na bibolo, kwaa mukuutu a banguu ba bangaanga ba Nziaambi Kayifa. ");
INSERT INTO iyx_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Bu maa makiyilimi, Simooni Peetero ali ninha, mu uyoto mbaa. Bamuleeli: «We ka a li pe mosi mu miyii mia nde?» Ka Peetero atuni bu aleeli: «Ngori, me a ndi muyii a nde pe!» ");
INSERT INTO iyx_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mosi mu basiali ba nguu a bangaanga ba Nziaambi, ali kaanda limosi na muutu wu Peetero akesi litswi. Nde afuuli Peetero: «Me a namono pe we na nde mutso luumbu?» ");
INSERT INTO iyx_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ka Peetero abwitunu. Nhaa-na-tsi, tsutsu akookili. ");
INSERT INTO iyx_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tumake, ni babiti Yiisu kwaa Kayifa, ku nzo a mutumi a Looma. Ali ngwaali a ngwaali. Bababiti Yiisu a bakoti pe mutso nzo. Bo bayilii buu, paa bo banyaala usumuu, na bahama mu uba kutso tsieemini, paa baba na muswa wa udia biloo bia mukuungi a Paaka. ");
INSERT INTO iyx_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ni mu buu, mutumi Pilato ayimono bo ku mbari. Nde wabafuuli: «Mu ki ndaa beni dili mu ufuundu muutu wu?» ");
INSERT INTO iyx_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Bo bamuvutili: «Mbiiti nde ali a ayiluu ndaa yimbi pe, bisi a diakeni uyayeelele we nde pe.» ");
INSERT INTO iyx_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato abwileele: «Diholo nde beni bame, na difuundusu nde weti buli mikele mia beni.» Ka bo bavutili: «Bisi a dili na muswa pe wa uha muutu tsieembili ya likwa.» ");
INSERT INTO iyx_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Maa mayilimi, paa mandaa maleeli Yiisu mayene tsitsi, mu ayaabisi buni nde ukwa. ");
INSERT INTO iyx_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato akoti mutso nzo. Nde ati Yiisu mbili, na wamufuuli nduru yi: «We ni mutini a Bayuudayo?» ");
INSERT INTO iyx_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yiisu avutili: «We nha leeli buu mundaa ti we makulu tsimi buu, oo ti baata bakimi bamaaleele we buu mu ndaa a me?» ");
INSERT INTO iyx_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato avutili: «Mundaa ti me Muyuudayo ndi? Baata ba ifuumbu kia we na banguu ba bangaanga ba Nziaambi, bamaayeelele we kwaa me. We ki ndaa mayiluu?» ");
INSERT INTO iyx_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yiisu avutili: «Ipfumu kia me a ili kia tsi yi pe. Mbiiti ipfumu kia me ali kia tsi yi, keni basiali ba me bakeni udwaana, paa bakuutu ba Bayuudayo banyaala ukaanga me. Ka ngori, ipfumu kia me a ili kia tsi yi pe.» ");
INSERT INTO iyx_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ninha, Pilato wamufuuli: «Mu yii, we mutini li?» Yiisu wamuvutili: «We leeli ti me mutini ndi. Me nabutuu na me nayiri nha tsi mu uta imbaangi mundaa ngwanya. Pasi muutu wuli mu usalila ngwanya, li mu uyuu mandaa ma me ndi mu uleele.» ");
INSERT INTO iyx_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato wamuvutili: «Ngwanya ni ima?» Amana na uleele mandaa maa, Pilato ni abwiyene kwaa Bayuudayo ku mbari. Nde wabaleeli: «Me amoni toono so mosi pe mu uha muutu wu tsieembili ya likwa. ");
INSERT INTO iyx_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ka beni dili na ipfu kili ti me ha bunyanga kwaa kori mosi mu mukuungi a Paaka. Beni ditooni ti me ha bunyanga kwaa “mutini a Bayuudayo”?» ");
INSERT INTO iyx_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Bo baloyi: «Ngori, a nde pe! Bisi Barabase diatoono!» Ka bunu, Barabase wuu ali ihaangi. ");
INSERT INTO iyx_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ni mu buu, Pilato atumi babiti Yiisu na bafiinzi nde bikoti. ");
INSERT INTO iyx_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Masodaare mamunayi iburu kia matsieende nha mutswe. Bamulwaatisi ka iyungu kiabeenge. ");
INSERT INTO iyx_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bo bayiri nha bele a nde, na bamuleeli: «Bwee la we, mutini a Bayuudayo!» Na bakiha nde mambata. ");
INSERT INTO iyx_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato abwipala, na aleeli kwaa baata bali ku mbari: «Monani, me nde nibee kwaa beni nha mbari nha, paa beni diyaaba ti, me a ndi mu umono pe toono ya usieembe nde.» ");
INSERT INTO iyx_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ni mu buu, Yiisu apali ku mbari. Nde ali alwaata iburu kia matsieende, na iyungu kiabeenge. Pilato wabaleeli: «Dimono muutu me!» ");
INSERT INTO iyx_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ka mu taanga di banguu ba bangaanga ba Nziaambi na bakebi bo bamumoni, bo baloyi: «Komo nde nha kuruwa! Komo nde nha kuruwa!» Pilato abwileele: «Diholo nde na dikomo nde beni bame. Mundaa ti, mu me, me a ndi mu umono pe toono so mosi ya usieembe nde.» ");
INSERT INTO iyx_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Bayuudayo bavutili: «Bisi dili na mikele, na mikele mii mili mu uleele ti nde afwaana ukwa. Mundaa ti nde aleeli ti nde li Mwaana a Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Bu Pilato ayuyi mandaa maa, nde abwibaa boomo balaa. ");
INSERT INTO iyx_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nde akoti mu nzo na afuuli Yiisu: «We wa kuni li?» Ka Yiisu a wamuhi mvutu pe. ");
INSERT INTO iyx_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato wamuleeli: «We li mu ubisi utsuu na me? We a ayaaba pe ti me ndi na lituu la uha we bunyanga, na me ndi ka na lituu la ukomo we nha kuruwa?» ");
INSERT INTO iyx_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yiisu wamuvutili: «We a akeni uba na lituu so hoolo pe nha kulu a me, so Nziaambi a aheeri we lo pe. Ni mu buu, muutu wayeelele me kwaa we, li na lisumu lavulu bunene na la we.» ");
INSERT INTO iyx_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Umatuu mu taanga dii, Pilato akisaa kuulu ya uha Yiisu bunyanga. Ka Bayuudayo bakiloo: «Mbiiti we heeri nde bunyanga, we a li nduu a mutini Kayisari pe! Pasi muutu wuli mu uleele ti nde mutini ali, li mutaata a mitini Kayisari!» ");
INSERT INTO iyx_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Mu taanga di Pilato ayuyi mandaa maa, nde abiti Yiisu ku mbari. Nde ayidiaala nha mbata a mufuundisi, nha mbuu yibali mu uta: «mbari ya mu mamanya». Mbuu yii, kuumbu a yo «Ngabata» mu Iebeleo. ");
INSERT INTO iyx_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ali helape ka nzanga, mu iluumbu kiatswaamina mukuungi a Paaka. Pilato aleeli kwaa Bayuudayo: «Dimono mutini a beni!» ");
INSERT INTO iyx_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ka bo bakiloo: «Dusu nde! Dusu nde! Komo nde nha kuruwa!» Pilato wabafuuli: «Beni diatoono ti me komo mutini a beni?» Banguu ba bangaanga ba Nziaambi bavutili: «Bisi a dili na mutini mukimi pe, nha yulu mutini Kayisari.» ");
INSERT INTO iyx_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Mu yii, Pilato wabayeelili Yiisu, paa bamukomo nha kuruwa. Ni mu buu, masodaare babiti Yiisu. ");
INSERT INTO iyx_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yiisu nde makulu abiti kuruwa a nde, umatuu ku palili a ngaanda Yeruselemi natee ku mbuu yibali mu uta «mbuu ya iteenge kia mutswe». Kuumbu a mbuu yii mu Iebeleo «Ngolongota». ");
INSERT INTO iyx_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ni kuu ku bakomi Yiisu na baata boolo bakimi itwaari na nde. Mosi ku koo kia nde kia babaala, wunu ku koo kia nde kia bakaasa, na Yiisu nha kati a kati. ");
INSERT INTO iyx_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato asonii nha yulu a mwaana a bala, na atumi banaa lo nha yulu a kurwa. Nde asonii bisionii bi: «Yiisu musi Nazareti, mutini a Bayuudayo.» ");
INSERT INTO iyx_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Bayuudayo babalayi bataangi bisonii bii. Mundaa ti mbuu yibali bakomi Yiisu ali bebele na ngaanda, na bisionii ali mu Iebeleo, mu ndaa a basi Looma na mu ndaa ya basi Eleene. ");
INSERT INTO iyx_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Banguu ba bangaanga ba Nziaambi baleeli kwaa Pilato: «A sonuu pe “mutini a Bayuudayo.” Ka sonuu ti “muutu wu aleele ti nde li mutini a Bayuudayo.”» ");
INSERT INTO iyx_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato avutili: «Bi me nasonuu, ni buu biba.» ");
INSERT INTO iyx_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Mu taanga di masodaare mamani na ukomo Yiisu nha kuruwa, bo baholi bikutu bia nde. Bo bakabili bio mu makaba mana, na bahi pasi kaba kwaa pasi lisodaare. Bo baholi ka iyungu kia Yiisu kibahele ubaamba umata ku yulu natee ku tsi. ");
INSERT INTO iyx_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Masodaare malelisini: «Dinyaalani ukaka iyungu ki. Ka ditaanani zeke mu uyaaba kio kia na ikaaba.» Maa mayilimi paa Mabasonuu ma ngira mayene tsitsi: «Bo bamaakabisina bikutu bia me, bamaata zeke mu uyaaba, na kaaholo iyungu kia me.» Ni mandaa maa masodaare mayilii. ");
INSERT INTO iyx_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nha peembi a kuruwa a Yiisu, ali na bakaasa ba: nguu a Yiisu, mwaana a nguu a nguu a nde, Mari mukari a Klopasi, na Mari musi Mangadala. ");
INSERT INTO iyx_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Mu taanga di Yiisu amoni nguu a nde, na muyii wu nde akitoono nha bele a nguu a nde, nde aleeli kwaa nguu a nde: «Mono mwaana a we.» ");
INSERT INTO iyx_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tumake ni aleeli kwaa muyii wuu: «Mono nguu a we.» Na umatuu mu taanga dii, muyii wuu aholi Mari mu uba na nde ku nzo a nde. ");
INSERT INTO iyx_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Nha mbisi a nhaa, Yiisu ali ka maayaaba ti, mandaa moosi mamakuu. Na paa Mabasonuu ma Ngira mayene tsitsi, nde aleeli: «Me na nyooto a maamba.» ");
INSERT INTO iyx_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nhaa mwali na lisaanga laluulu mu viinyi la nhanyi. Masodaare matsubi itsuru kia tsaanda yaduu mutso viinyi la nhanyi. Bo bakuti kio nha toso a itsuru kia muti wu bali mu uta isopi. Bo bahaatisi iteendi kii nha munywa a Yiisu. ");
INSERT INTO iyx_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yiisu anywi viinyi la nhanyi lii, na aleeli: «Mioosi mimaakuu!» Nde atali ku tsi na asieeli muwuumu. ");
INSERT INTO iyx_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ali tswaamina iluumbu kia mukuungi a Paaka. Na kwaa Bayuudayo, a bwali bwafwaana pe ti bamvuumbi baba nha yulu a bakuruwa mu iluumbu kia saba. Mundaa ti iluumbu kia saba kii, ali iluumbu imosi kiavulu bunene mu Basaba boosi. Ni mu buu, bakuutu ba Bayuudayo baloombi kwaa Pilato mu utumu ti, baboolo miili mia baata babakomi. Na mu utumu ka ti, bamaasa manyutu ma bo nha bakuruwa. ");
INSERT INTO iyx_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Masodaare mayiboolo miili mia watsiomi wu bakomi nha kuruwa, mbala mosi na Yiisu. Tumake mia waboolo. ");
INSERT INTO iyx_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ka mu taanga di bo batoori kwaa Yiisu, bo bamoni ti nde ali amaakwakwa. Ni mu buu, bo a bamubooli miili pe. ");
INSERT INTO iyx_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ka mosi mu masodaare atuli Yiisu libaanzi mu yoo la nde. Na nhaa-na-tsi, makili na maamba mapali. ");
INSERT INTO iyx_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Muutu wamoni mandaa maa, ati imbaangi mu mo, na imbaangi kia nde ili kia ngwanya. Nde ayaaba ti nde li mu uta ngwanya, paa beni ka disa imiini. ");
INSERT INTO iyx_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Mundaa ti, maa moosi mamaayilimi paa Mabasonuu ma Ngira mayene tsitsi: «A buboolo nde muyisi so mosi pe.» ");
INSERT INTO iyx_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Na mukaanda mukumi wa Mabasonuu ma Ngira, li mu ubwaleele ti: «Bo sa basumu misi mia bo nha yulu a muutu wu bo bamaatulu libaanzi.» ");
INSERT INTO iyx_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nha mbisi a nhaa, Yoosefi musi ngaanda ya Arimate, ayiloombo muswa kwaa Pilato wa uholo nyutu a Yiisu. Yoosefi wu ka ali muyii a Yiisu, ka mu tsweeyi, mundaa ti nde ali na boomo ba bakuutu ba Bayuudayo. Pilato wamuhi muswa wa uholo nyutu a Yiisu. Ni mu buu, Yoosefi ayimaasa nyutu a Yiisu. ");
INSERT INTO iyx_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemo wali wayimono Yiisu butsuu, ayiri ka. Nde abeyi helape maku matata ma bakilo ba mananaasa, mabayiluu mu miire na aloweese. ");
INSERT INTO iyx_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yoosefi na Nikodemo baholi nyutu a Yiisu, na badii yo kutso matsaanda ma liino. Bo bayitili maari ma mananaasa, weti buli ipfu kia Bayuudayo nha bubaadii bamvuumbi ba bo. ");
INSERT INTO iyx_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Nha mbuu yi bakomi Yiisu, ali na luumbu. Na mutso luumbu lii, ali na ngili mosi yinyatii. Ali keni a badii pe mvuumbi so mosi mutso ngili yii. ");
INSERT INTO iyx_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Bu yali iluumbu kia nzilimini a mukuungi a Paaka, na bu yali ti ngili bebele, bo basuusi nyutu a Yiisu muu. ");
INSERT INTO iyx_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ngwaali a ngwaali mu iluumbu kia limiingi, ku makia ma busi, Mari musi Mangadala ayeni ku ngili. Nde amoni ti manya lali lafuu munywa a ngili, ali bamaamaasa. ");
INSERT INTO iyx_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ni mu buu, nde ayeni mu tiini kwaa Simooni Peetero na muyii mukimi wu Yiisu akitoono. Nde aleeli kwaa bo: «Bamaamaasa nyutu a Pfumu mu ngili a nde, na a diayaaba pe nhani bamaasuusu yo.» ");
INSERT INTO iyx_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Peetero na muyii mukimi wuu bayeni ku ngili. ");
INSERT INTO iyx_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bo baboolo bayeni mu matiini. Ka muyii mukimi wu avuli Peetero mu tiini, na akwito watsiomi ku ngili. ");
INSERT INTO iyx_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nde abaandini mu umono, na amoni matsaanda ma liino bali basuusu nhaa. Ka nde a akoti pe. ");
INSERT INTO iyx_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simooni Peetero wakiyiri nha mbisi a nde, atoori na akoti mu ngili. Nde amoni matsaanda ma liino basuusu nha tsi. ");
INSERT INTO iyx_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Nde amoni ka tsaanda yibali badii mutswe a Yiisu. Tsaanda yii a yali pe mbuu mosi na matsaanda ma liino. Ka yo ali bafutuu, basuusu nha tata, nha mbuu kimi. ");
INSERT INTO iyx_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Mu taanga dii, muyii mukimi wuu, watoori wa tsiomi ku ngili, akoti ka. Nde amoni na asi imiini. ");
INSERT INTO iyx_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ka miyii ali keni a miabahala pe mandaa Mabasonuu ma Ngira, mali mu uleele ti Yiisu afwaana mu usiimbuu mu babakwa. ");
INSERT INTO iyx_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tumake, miyii mio miamioolo miavutii ku manzo ma bo. ");
INSERT INTO iyx_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mari ali atemene ku mbari, nha bele a ngili, na akilili. Bu nde akilili, nde abaandini mu umono kutso ngili. ");
INSERT INTO iyx_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Nde amoni batumu ba Nziaambi boolo, balwaata bikutu biahembuu, na badiaala nha mbuu yibali basuusu nyutu a Yiisu. Mosi ali adiaala nha mbuu yali mutswe a Yiisu, na wunu nha yali miili mia nde. ");
INSERT INTO iyx_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Batumu ba Nziaambi bafuulu kwaa Mari: «Maama, mu ima we li mu ulili?» Nde wabavutili: «Bamaamaasa Pfumu a me, na me a nayaaba pe kuni bamaasuusu nde.» ");
INSERT INTO iyx_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Amana na uleele buu, nde asieetii na amoni Yiisu ali atemene nhaa. Ka nde a akiyaaba pe ti wuu ali Yiisu. ");
INSERT INTO iyx_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yiisu wamufuuli: «Maama, mu ima we li mu ulili? We na li mu usaa?» Mari bu akitsimi ti wu ali musiali a luumbu lii, nde wamuleeli: «Taata, mbiiti we maamaasa nde, leele me kuni we suusi nde. Na me sa yaholo nde.» ");
INSERT INTO iyx_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yiisu wamuleeli: «Mari!» Mari asieetii kwaa nde, na aleeli mu Iebeleo: «Rabuni!» mbiindili ti «Muyiisi!» ");
INSERT INTO iyx_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yiisu abwileele: «Akaanga me pe, mundaa ti me keni a nahaata pe kwaa Taayi. Ka yene kwaa baana ba nguu ba me, na leele bo ti “Me ndi mu uhaata kwaa Taayi a me, wuli ka Taayi a beni; na kwaa Nziaambi a me, wuli ka Nziaambi a beni.”» ");
INSERT INTO iyx_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ni mu buu, Mari musi Mangadala ayeni kwaa miyii, na wabayaabisi: «Me maamono Pfumu!» Na nde wabayaabisi mandaa ma Yiisu wamuleeli. ");
INSERT INTO iyx_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Tsitsii a iluumbu kia limiingi kii na kii, miyii miali miakukunu mutso nzo mosi. Bo bali babiinduu nzo mu tsiafi, mundaa ti bo bali na boomo ba bakuutu ba Bayuudayo. Yiisu ayiri, na atemini nha kati a kati a bo. Nde wabaleeli: «Iyeenge kwaa beni!» ");
INSERT INTO iyx_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Nha mbisi a uleele buu, nde wabamweesi mioo mia nde, na libaanzi la nde. Miyii mialuuli mu kinyi bu bo bamoni Pfumu. ");
INSERT INTO iyx_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yiisu abwileele: «Iyeenge kwaa beni! Weti bu Taayi atsinduu me, me ka nitsinduu beni.» ");
INSERT INTO iyx_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nha mbisi a uleele ndaa yii, nde afuli bo mupepe, na wabaleeli: «Diyaka Muheebili wa Ngira! ");
INSERT INTO iyx_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Baa ba beni dikaasa masumu ma bo kolokolo, Nziaambi sa asa bo kolokolo. Ba beni dikaabisi usa kolokolo, Nziaambi a usa bo kolokolo pe.» ");
INSERT INTO iyx_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Toma, ali mosi mu miyii kuumi na mioolo, wubahi kuumbu ya ubili Mbu. Nde a ali pe itwaari na bo nha Yiisu ayiri. ");
INSERT INTO iyx_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Miyii mimimosi mialeeli kwaa nde: «Bisi dimaamono Pfumu.» Ka Toma avutili: «Mbiiti me a moni pe ikiri kia tsootso mu mioo mia nde, me a nisa pe imiini. Mbiiti me a ndoosi pe muleembi a me nha mbuu yaba tsootso, na koo kia me mu libaanzi la nde, me a nisa pe imiini.» ");
INSERT INTO iyx_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Limiingi limosi nha mbisi a nhaa, miyii mia Yiisu ali miabwikukunu mutso nzo. Na Toma ka ali itwaari na bo. Ka bu bo bali babiinduu nzo mu tsiafi, Yiisu ayiri, na atemini nha kati a kati a bo. Nde aleeli: «Iyeenge kwaa beni!» ");
INSERT INTO iyx_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tumake, nde aleeli kwaa Toma: «Sa muleembi a we nha, na mono mioo mia me. Bee koo kia we, na sa kio nha libaanzi la me. A bwabisi pe mu usa imiini, ba muutu ngaa imiini!» ");
INSERT INTO iyx_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma wamuvutili: «Pfumu a me, na Nziaambi a me!» ");
INSERT INTO iyx_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yiisu abwileele: «Mundaa bu we moni me, we siiri imiini? Kinyi kwaa baata babahele umono, ka basa imiini!» ");
INSERT INTO iyx_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yiisu abwiyiluu biliimbi bikimi bia ukimuu, nha kulu a miyii mia nde. Biliimbi bii, a batsuu pe mu bio mu mukaanda wu. ");
INSERT INTO iyx_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ka mandaa mabasonuu mu mukaanda wu, basonuu mo paa beni disa imiini ti Yiisu ni Kristo, Mwaana a Nziaambi. Na, bu beni disa imiini, beni sa dibaa moonyi mu kuumbu a nde. ");
INSERT INTO iyx_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nha mbisi a mwaana biluumbu, Yiisu abwimonuu kwaa miyii mia nde, ku mukoo a diaanga la Tiberiade. Mono bu nde amonii kwaa bo: ");
INSERT INTO iyx_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simooni Peetero, Toma wu baha kuumbu ya ubili Mbu, Natanaeli musi Kaana mu itinini kia Ngalili, baana a Zebedaayi, na miyii mia Yiisu mioolo mikimi bali itwaari. ");
INSERT INTO iyx_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simooni Peetero wabayaabisi: «Me ndi mu uyene ku ulobo.» Bo bamuleeli: «Bisi ka na we diyene.» Bo boosi bayeni na bakoti mu bootu. Ka butsuu baa, bo a babayi tswi so mosi pe. ");
INSERT INTO iyx_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Busi bu babaandii ukia, Yiisu ali atemene nhaa, nha simi la diaanga. Ka miyii a miayaabi pe ti wuu ali nde. ");
INSERT INTO iyx_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yiisu wabaleeli: «Banduu ba me, beni utuu ubaa iloo kia udia?» Bo bavutili: «Pia, bisi a dili na iloo pe!» ");
INSERT INTO iyx_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yiisu wabaleeli: «Didumunu siele mu maamba, ku koo kia bootu kia babaala, na beni sa dibaa batswi.» Bo badumini siele, na a bali abwatuu pe udutu lo mu upalisa lo mu maamba, mundaa ti lo ali lamaaluulu mu batswi. ");
INSERT INTO iyx_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mu taanga dii, muyii wu Yiisu akitoono aleeli kwaa Peetero: «Wu ni Pfumu!» Bu Peetero ayuyi ndaa yii ti wu ni Pfumu, nde alwaati ikutu kia nde kia yulu, mundaa ti nde a ali na ikutu pe. Nde abwi mu maamba. ");
INSERT INTO iyx_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Miyii mikimi miayiri mu bootu, mu uyiri adutu siele laluulu mu batswi. Bo a bali pe ngo la na simi. Bo ali taka na simi mu iteesi kia bameetere helape kama. ");
INSERT INTO iyx_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nha bo batoori nha simi, bo bamoni mbaa ya makala na batswi nha yulu, na bo bamoni ka mapa nha peembi. ");
INSERT INTO iyx_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yiisu wabaleeli: «Dibee ndaamba a batswi ba beni dimaabaa.» ");
INSERT INTO iyx_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simooni Peetero akoti mu bootu, na aduti tee nha tsi, siele laluulu mu batswi babanene. Litaanga la batswi mutso siele ali kama maku mataana na batswi batata (153) mu boosi. Ka so mu litaanga lii loosi, siele a lakikii pe. ");
INSERT INTO iyx_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yiisu wabaleeli: «Diyiri diyadia.» So mosi pe mu miyii wayesini ufuulu nde: «We na li?» Mundaa ti bo ali bayaaba ti wuu ali Pfumu. ");
INSERT INTO iyx_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yiisu aswesii kwaa bo, nde aholi lipa na wabakabi lo. Nde ayilii bumosi ka mu tswi. ");
INSERT INTO iyx_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yii ali mbala ya mutata yi Yiisu amonii kwaa miyii mia nde, umatuu bu nde asiimbii mu babakwa. ");
INSERT INTO iyx_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nha mbisi a udia, Yiisu aleeli kwaa Simooni Peetero: «Simooni, mwaana a Yowani, we atoono me kwavulu baa-na-ba?» Nde avutili: «Ee-e Pfumu, we ayaaba ti me natoono we.» Yiisu wamuleeli: «Kebe mameme ma me.» ");
INSERT INTO iyx_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yiisu wamufuuli mu mbala ya dioolo: «Simooni, mwaana a Yowani, we atoono me?» Simooni avutili: «Ee-e Pfumu, we ayaaba ti me natoono we.» Yiisu wamuleeli: «Kebe mameme ma me.» ");
INSERT INTO iyx_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yiisu wamufuuli mu mbala ya mutata: «Simooni, mwaana a Yowani, we atoono me?» Peetero amoni ngebe bu Yiisu wamufuuli mu mbala ya mutata: «We atoono me?» Na nde avutili: «Pfumu, we ayaaba mandaa moosi. We ayaaba ti me natoono we!» Yiisu abwileele: «Kebe mameme ma me. ");
INSERT INTO iyx_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mu ngwanya, me nileele kwaa we: nha we ali mufuru, we makulu akikutu kobo a we, na akiyene pasi ku we atoono. Ka nha we kaanunu, we sa sibili mioo, na muutu mukimi sa akutu kobo a we, na sa abiti we ku we ahele utoono uyene.» ");
INSERT INTO iyx_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Mu mandaa maa, Yiisu akiyaabisa buni Peetero akaakwa, na uha buzitu kwaa Nziaambi mu likwa lii. Tumake, Yiisu wamuleeli: «Duku me!» ");
INSERT INTO iyx_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Peetero asieetii, na amoni muyii wu Yiisu akitoono mu uduku bo. Ni muyii wabaandini nha bele a Yiisu nha bo bakidia, mu ufuulu nde: «Pfumu, na kaayeelele we?» ");
INSERT INTO iyx_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Bu Peetero wamumoni, nde aleeli kwaa Yiisu: «Pfumu, aka nde, mima mikaabwiilili nde?» ");
INSERT INTO iyx_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yiisu wamuvutili: «Mbiiti me tooni ti nde aba moonyi natee bu me niyiri avutuu, ndaa a we nhani yili? We duku me ndili!» ");
INSERT INTO iyx_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ubaanduu iluumbu kii, mvuungu a ndaa yii yatsiaamii nha kati a bangaa imiini ti, muyii wuu a ukwa pe. Ka bunu, Yiisu a aleeli pe kwaa Peetero ti, muyii wuu a ukwa pe. Ka Yiisu ali aleeli: «Mbiiti me tooni ti nde aba moonyi natee bu me niyiri avutuu, ndaa a we nhani yili?» ");
INSERT INTO iyx_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ni muyii me wuu li mu uta imbaangi mu mandaa maa, na wumaasonuu mo. Na bisi diayaaba ti imbaangi kia nde ili kia ngwanya. ");
INSERT INTO iyx_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Uli na mandaa makimi mamalayi ma Yiisu ayilii. Ka mbiiti busonuu mo mosi na mosi mu mikaanda, me nitsimi ti tsi yoosi sa yiba yikee mu uswee mikaanda mibakeni usonuu.");
INSERT INTO iyx_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teofili, mu mukaanda a me wa tsiomi, me nasonii mioosi, mia baandii Yiisu uyiluu na uyiisi. ");
INSERT INTO iyx_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Tswaamini a iluumbu ki nde ahaati ku yula, mu litu la Muheebili wa Ngira, ahi mandongi ma nde, kwaa batumu ba nde ba asiooli. ");
INSERT INTO iyx_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ku mbisi a likwa la nde, nde makulu amonii kwaa bo, ti nde li moonyi, mu biliimbi bialaa, nha mbisi a mapasi ma nde amoni. Mu maku mana ma biluumbu, nde amonii kwaa bo, na wabatsuyi mu mia tala Ipfumu kia Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Bu akidia na bo, nde wabaleeli ti: «A dipala mu ngaanda a Yeruselemi pe, ka dikebe lilasina la Taata, li beni diayuyi kwaa meeni. ");
INSERT INTO iyx_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yowani abootii mu maamba, ka beni sa badibootuu mu Muheebili wa Ngira, nha mbisi a mwaana biluumbu hoolo.» ");
INSERT INTO iyx_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Batumu bakukini na Yiisu, bamufuuli: «Pfumu, buni mu taanga di we kaadiaasa ipfumu kia Iseraeli?» ");
INSERT INTO iyx_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yiisu wabavutili: «A mia tala beni pe, mu uyaaba taanga di Taata akutu, mu litumu la nde makulu. ");
INSERT INTO iyx_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ka beni sa diholo mifuri mia Muheebili wa Ngira ukaayira nha yulu a beni. Beni sa diba bambaangi ba me mu Yeruselemi, mu tsi ya Yuuda yoosi, na mu tsi ya Samaria, natee kwa suku tsi yoosi.» ");
INSERT INTO iyx_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Bu amani uleele maa, nde anaangii ku yula, na tuti lafuyi nde, nha misi mia bo. ");
INSERT INTO iyx_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bu bakitala ku yula, ku Yiisu akiyene, babaala boolo bamonii kwaa bo, babalwaata bikutu biahembuu. ");
INSERT INTO iyx_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Bo baleeli: «Basi Ngalili, mu ima dili mu uhama mu utala isooso ku yula? Yiisu wuu, wu Nziaambi anaangili ku yula nha kati a beni, sa avutuu weti bu beni dimoni nde mu uyene.» ");
INSERT INTO iyx_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Bu basiisi mulaanda a Olive, mu iteesi kia helape kilometere mosi, bo bavutii ku Yeruselemi. ");
INSERT INTO iyx_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Bu batoori ku Yeruselemi, bo bahaati ku itsuru kia nzo kia ku yulu. Kuu, ku bali na ipfu kia uvuutunu, kwali: Peetero, Yowani, Yaki, Andere, Filipo, Toma, Baritelemi, Mataayi, Yaki mwaana Alife, Simooni muzeloti na Yuuda mwaana Yaki. ");
INSERT INTO iyx_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Boosi mu itwaari bahami, mu likuundu, na Bakaasa na Mari nguu a Yiisu na baana banguu ba Yiisu. ");
INSERT INTO iyx_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mu biluumbu bii, litaanga la babali bakukunu bali iteesi kia kama na maku moolo ma baata. Peetero atemini nha kati a baana ba nguu, na aleeli: ");
INSERT INTO iyx_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Baana ba nguu ba me, aba bwafwaana ti ma Basonuu ma Ngira mayilimi mbii bwaleeli Muheebili wa Ngira, mu munywa a Daavidi, wa kwitsuu mu Yuuda. Ni nde wa kitii mubiti a baa, ba bakaangi Yiisu. ");
INSERT INTO iyx_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Nde beeri mosi mu litaanga la bisi, na nde asiali isala imoosi na bisi. ");
INSERT INTO iyx_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Bu amani usuumbu tsiee mu mboongo di bafuti nde diasumuu, nde apatii na moonyo apasii, na misopo mia nde miatsiamii. ");
INSERT INTO iyx_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ndaa yii yayabini kwa baata boosi mu Yeruselemi. Ni mubuu tsiee yii bati yo mu ndaa a bo: “Akeledama” mbiindili ti “tsiee ya makila.” ");
INSERT INTO iyx_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ka basonuu mu mukaanda Mikuunga: “Nyaala nzo a nde yiba yi babwoongolo, na muutu so moosi a nyaala udiaala mu yo.” Na basonuu ka: “Muutu mukimi aholo isala kia nde.” ");
INSERT INTO iyx_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Bwafwaana ti, mosi aba mbaangi itwaari na bisi, mu tsimbilili a Pfumu Yiisu mu babakwa. Muutu wuu afwaana uba wakidieenge na bisi, mu taanga dioosi di Pfumu Yiisu akiyene nha kula bisi, umatuu bu Yowani abootii Nde, natee mu iluumbu ki Nziaambi, anaangili Nde nha kati a bisi, mu uyene ku yula.» ");
INSERT INTO iyx_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Bo batemisi na bamweesi baata boolo: Yoosefi wubakita Barisabase, uli kuumbu ya ubili Yusitusi, na Matiasi. ");
INSERT INTO iyx_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tumake bakuundi kwaa Nziaambi mbii bu: «Pfumu, we wayaaba mitimi mia baata boosi, mweese mu bo baboolo na we siooli, ");
INSERT INTO iyx_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","paa ti nde aholo mbuu mu isala kia batumu, yi Yuuda asiisi mu uyene ku mbuu yafwaana kwaa nde.» ");
INSERT INTO iyx_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Bo bati ipaa nha kati a bo, na ipaa kiabwi nha yulu a Matiasi, wu babweesi nha tso a batumu kuumi na mosi. ");
INSERT INTO iyx_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Iluumbu kia Pentekoti bu kiatoori, babasa imiini mu Nziaambi bakukini nha mbuu mosi. ");
INSERT INTO iyx_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Itsundu-a-tsundu, kele yamatii ku yula, weti iteembi kiamifuri, yaluusi nzo yoosi, yi bali badiaala. ");
INSERT INTO iyx_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ndimi weti Milee mia mbaa, diamonii kwaa bo, dio diakabii na diasutii nha yulu a mosi-mosi mu bo. ");
INSERT INTO iyx_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Bo boosi baluuli mu Muheebili wa Ngira, na bo babaandii mu utsuu mu ndimi, weti bu Muheebili aleeli kwaa bo mu uyaabisa. ");
INSERT INTO iyx_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ku Yeruselemi kwali na Bayuudayo babali na likiinzi la Nziaambi, bamati mu matsi moosi. ");
INSERT INTO iyx_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Kele yii bu yayuyini, koongi a baata yakukini. Bo bakimii, mu ndaa muutu-muutu akiyuu bo, mu utsuu mu ndaa a nde ya bula. ");
INSERT INTO iyx_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Bo bapamii na bakimii, baleeli: «Baata ba boosi, a bali pe basi Ngalili? ");
INSERT INTO iyx_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ka buni muutu-muutu mu bisi, ali mu uyuu bo mu utsuu mu ndaa a nde ya bula? ");
INSERT INTO iyx_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nha kati a bisi uli na baata babamata ku Parte, ku Mede, ku Elami, na basi Mesopotami, na Yuuda, na Kapadoki, na Ponte, na itinini kia Asia, ");
INSERT INTO iyx_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","na Firingia, na Pamfili, na Ngipiti, na mu tsi ya Libi mu itinini ya Kireni, na babamati ku Looma, ");
INSERT INTO iyx_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","na Bayuudayo, na baata bakimi babakoto mu libuundu la bo, babali ku iduku kia Kerete na babali ku itinini kia Arabi. Ka bunu bisi dili mu uyuu bo, bali mu utsuu mu mandaa ma bisi, mu biyiluu bi bibwe bia Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Bo boosi bakimii na mayele mawi bo. Baleelisini nha kati a bo: «Ka maa-na-ma mbiindili ma?» ");
INSERT INTO iyx_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ka ba bamosi basi saa, baleeli: «Maala ma bo bali mu ubaakolo.» ");
INSERT INTO iyx_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Peetero, atemini itwaari na batumu kuumi na mosi, anaangili ndaa, aleeli kwaa koongi: «Basi Yuuda, na beni boosi babali mu udiaala mu Yeruselemi, “ditete matswi” mu manileele beni! Diyaaba ti: ");
INSERT INTO iyx_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Baata ba a bakolo pe weti bu beni dili mu utsimi, mundaa ti dikini mu nguungu ya wa mu ngwaali. ");
INSERT INTO iyx_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ka ma ni maleeli mubili Yoweli: ");
INSERT INTO iyx_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Mu biluumbu bia tsieelele, bu leeli Nziaambi: Me sa yitili Muheebili a me nha yulu ma nyutu ma baata boosi, baana ba beni ba babaala, na ba Bakaasa sa babili, bafuru ba beni sa bamono mamono misi, na binunu bia beni sa bilooto manziori. ");
INSERT INTO iyx_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ee, nha yulu a mabooyi ma me ma babaala na ma Bakaasa, mu biluumbu bii, me sa yitili Muheebili a me, na bo sa babili. ");
INSERT INTO iyx_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Me sa mweese bimaanga mu yula, na biliimbi nha tsini a toto: makila, mbaa na tuti la luki. ");
INSERT INTO iyx_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Nyanga sa ikituu pimisi, na tsuungi sa abeenge weti makila, tswaamina iluumbu kia Pfumu ito, iluumbu kii ki inene na kia kimi-kimi. ");
INSERT INTO iyx_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ka, pasi nde wu ka abili kuumbu a Pfumu, sa ayobuu.” ");
INSERT INTO iyx_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«Baata ba Iseraeli, diyuu bubwe mandaa ma: Yiisu musi Nazareti, muutu wuu wu Nziaambi atsindii kwaa beni mu sa mu litu bimaanga na biliimbi. Nde ayilii bio nha kati a beni weti bu beni bame diayiluu uyaaba. ");
INSERT INTO iyx_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Muutu wuu, wubayeelili weti bu ili kesili a Nziaambi, beni diamudusi, bu diahi muswa kwaa bangooyi mu ukomo nde nha muti wa kuruwa. ");
INSERT INTO iyx_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ka Nziaambi wamusiimbili mu ba bakwa, bu wamukuuli mu mapasi ma likwa, mundaa ti likwa a lali na litu pe, la udiaasa nde. ");
INSERT INTO iyx_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ka Daavidi aleeli mundaa nde: “Mu taanga dioosi, me nakimono Pfumu nha kulu a me, mundaa nde li nha koo kia me kia babaala, paa me hele uteete. ");
INSERT INTO iyx_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ni mu buu, mutimi a me li mu uyaanga, na ndimuyimbi mu kinyi; bumosi ka nyutu a me sa yiwuumu kutso ilimbisi. ");
INSERT INTO iyx_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Mundaa ti Pfumu, we a ubwoongolo pe muwuumu a me ku tsi a babakwa; we awunyaala pe wa we wa Ngira amono mbolili. ");
INSERT INTO iyx_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","We amweesi me makuulu ma moonyi, we Nziaambi sa luusu me mu kinyi bu we li itwaari na me.” ");
INSERT INTO iyx_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«Baana banguu ba me, nyaalani me ndeele kwaa beni na yaki-yaki, mu toono a kaa Daavidi, ti nde akwi na badii, na ngili a nde yili nha kati a bisi, natee iluumbu ki. ");
INSERT INTO iyx_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Bu nde ali mubili, na ali ayaaba ti Nziaambi alasini na alabi mukisi mu nde ti, mosi wa mu likaanda la nde, sa adiaala nha yulu a mbata a ipfumu kia nde, ");
INSERT INTO iyx_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Daavidi akwibili tsimbilili a Mesiya mu babakwa, bu aleeli: “Nde a bamubwongolo pe ku tsi a babakwa; na nyutu a nde ayaboli pe mutso ngili.” ");
INSERT INTO iyx_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yiisu wuu, wu Nziaambi usiimbili mu babakwa, na bisi boosi dili bambaangi ba mamono misi. ");
INSERT INTO iyx_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nziaambi wamunaangili nha koo kia Nde kia babaala. Na aholi kwaa Taayi, Muheebili wa Ngira wu Nziaambi alasini. Yiisu ayitili Nde nha yulu a bisi, mbii bu beni dili mu umono na uyuu mu taanga di. ");
INSERT INTO iyx_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ka, Daavidi a ahaati pe ku mayula, bunu nde aleeli: “Pfumu Nziaambi aleeli kwaa Pfumu a me: diaala nha koo kia me kia babaala, ");
INSERT INTO iyx_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","natee me nisuusu mitaata mia we ku tsini a miili mia we.” ");
INSERT INTO iyx_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ni mu buu, nzo a Iseraeli yoosi yafwaana uyaaba bubwe ti Yiisu wu beni diakomi nha kuruwa, Nziaambi biaalisi nde Pfumu na Mesiya!» ");
INSERT INTO iyx_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Bu bamana uyuu maa, bo bamoni pasi kutso mitimi, na baleeli kwaa Peetero na kwaa batumu ba bamosi: «Baana ba nguu, bisi buni diafwaana usa?» ");
INSERT INTO iyx_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peetero avutili aleeli kwaa bo: «Dikiingili mayele, disobo ndiaatili na muutu-muutu aholo libootuu mu kuumbu a Yiisu Kristo. Diyiluu buu paa Nziaambi asa masumu ma beni kolokolo, tumake sadiholo bungori ba Muheebili wa Ngira. ");
INSERT INTO iyx_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ka lilasina la Nziaambi lili la beni, na baana ba beni, na bana boosi babali kula, ba Pfumu Nziaambi a bisi akaata mbili.» ");
INSERT INTO iyx_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Peetero ayaabisi bo mandaa makimi ma malayi, mu uyuhusu na uhamisa bo, aleeli: «Diholo liyobolo, dipala kutso isieende ki ibi ki!» ");
INSERT INTO iyx_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ba basiingi mandaa ma nde baholi libootuu, na mu iluumbu kii, helape mapfuundu matata ma baata, mafunisi kaba la baba sa imiini mu Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bo boosi bahami munziisili a batumu, mu itwaari, mu kabili a lipa na mu likuundu. ");
INSERT INTO iyx_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Bo boosi babayi boomo balaa, mundaa ti Nziaambi akiyiluu bimaanga na biliimbi bialaa mu batumu. ");
INSERT INTO iyx_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Boosi babasi imiini bali itwaari, na bakikaba bioosi biali na bo. ");
INSERT INTO iyx_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bo bayalii matsiee na mbahili a bo, na bakabi mboongo dii kwaa boosi, weti bwali manzala ma pasi muutu. ");
INSERT INTO iyx_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Pasi iluumbu, bo bakihama mu ukukunu kutso lipaanga la Nzo a Nziaambi, na bakikaba lipa mu manzo na bakidia biloo mu kinyi na mu mutimi wa bwaasi. ");
INSERT INTO iyx_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Bakibili Nziaambi na babayi bweese kwaa baata boosi. Na Pfumu akibweese pasi iluumbu, litaanga la baata ba bayobii. ");
INSERT INTO iyx_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Peetero na Yowani bayeni ku Nzo a Nziaambi, mu nguungu ya matata ku mbisi a nzanga mu likuundu. ");
INSERT INTO iyx_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Kuu kwali na Baata babakibee baala limosi, wabutii ikata. Na bakisuusu nde pasi iluumbu, nha munywa a Nzo a Nziaambi, wu bubaata «wumubwe». Bo babeyi nde paa muutu wuu a loombo libaasila kwaa babakikoto kutso lipaanga la Nzo a Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Bu amoni Peetero na Yowani mu ukoto kutso lipaanga la Nzo a Nziaambi, wabaloombi libaasila. ");
INSERT INTO iyx_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Peetero na Yowani bamutali isooso, tumake Peetero wamuleeli: «Tala bisi.» ");
INSERT INTO iyx_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Muutu wuu atali bo bubwe, ka nde ali na ilimbisi kia ubaa iloo kwaa bo. ");
INSERT INTO iyx_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ka Peetero aleeli kwaa nde: «Me a ndi na mboongo pe, me a ndi na woolo pe, ka ki me ndi na kio, me niha we kio: mu kuumbu a Yiisu Kristo musi Nazareti, temene na diaata!» ");
INSERT INTO iyx_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Bu wamukaangi mu koo kia babaala, nde wamutemisi. Nhaa na nhaa, miili na makere ma nde biahami. ");
INSERT INTO iyx_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Nhaa-na-tsi, nde adumii, atemini ayeeni, na akoti itwaari na bo kutso lipaanga la Nzo a Nziaambi, akiyene adumuu na abili Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Koongi yoosi yamoni nde bu akidiaata na bu akibili Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Bamuyaabi ti ni nde wakidiaala nha munywa a Nzo a Nziaambi, wu bubaata «wumubwe» mu uloombo libaasila. Baata bapamii na bakimii mu miayilimi mu ikata ki. ");
INSERT INTO iyx_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Bu nde ali keni a atakuu na Peetero na Yowani pe, koongi yoosi yakimii, yadumi tiini, yayeni ku peembi a bo, nha ipaangala ki bubaata «ipaangala kia Salomo». ");
INSERT INTO iyx_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Peetero bu amoni buu, aleeli kwaa koongi: «Baata ba Iseraeli, mu ima beni dili mu ukimuu mu mandaa ma? Mu ima beni dili mu utala bisi isooso, weti so bisi ditemisi nde mu litu la bisi bameme, so a buu pe mu libweeye la bisi mu Nziaambi? ");
INSERT INTO iyx_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nziaambi a Abraami, Nziaambi a Isaki, Nziaambi a Yaakobi, Nziaambi a bamwakaa ba bisi, abiingisi musiali a nde Yiisu. Beni diamuyeelili, na diamutuni nha kulu a Pilato, ka bunu nde ali na tsimi ya unyaala Nde. ");
INSERT INTO iyx_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Beni diatuni wa Ngira, wa Libweeye, na dialoombi badipalisa mudusi. ");
INSERT INTO iyx_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Beni diadusi Pfumu a moonyi, ka Nziaambi wamusiimbili mu babakwa, bisi dili babaangi ba mamono misi. ");
INSERT INTO iyx_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Muutu wu beni dimono wu, na wu diayaaba beni, mu lituu la kuumbu a Yiisu, na mu imiini mu nde, abayi mifuri. Ni mu imiini mu Yiisu nde abeelii weti bu beni dili mu umono.» ");
INSERT INTO iyx_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Ka baana ba nguu ba me, me tsimi ti kutso bundimbi beni na bapfumu ba beni diayilii buu. ");
INSERT INTO iyx_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ka Nziaambi akuusi mi nde akwiyaabisa mu minywa mia mibili mioosi ti Mesiya a nde afwaana umono pasi. ");
INSERT INTO iyx_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ni mu buu, dikiingili mayele, disobo biyiluu na divutuu kwaa Nziaambi, paa masumu ma beni banyaala. ");
INSERT INTO iyx_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Diyiluu buu, tumake mataanga ma puumini sa mayira, na Pfumu sa atsinduu beni Yiisu ni Mesiya wubadilasini. ");
INSERT INTO iyx_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Mu taanga di, Nde afwaana udiaala ku yula, natee taanga di bioosi bikaaba bibinyatii, weti bu Nziaambi ayaabisi mu minywa mia mibili mia Ngira umatuu bele pe. ");
INSERT INTO iyx_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mooso aleeli: “Pfumu Nziaambi a beni sa waditsinduu, mubili weti me, nha kati a baana ba nguu ba beni. Bubwe mu uyuu nde, mu moosi ma nde uleele. ");
INSERT INTO iyx_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ka pasi wu uhele uyuu mubili wuu, sa ba takala nde, nha kati a baana ba Nziaambi na sa badusu nde.” ");
INSERT INTO iyx_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Mibili mioosi, umatuu mu Samweli, na ba bayiri nha mbisi a nde, batsuyi ka mu ndaa biluumbu bii na bayaabisi bio. ");
INSERT INTO iyx_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Beni dili baana ba mibili, na baana ba mutsii wu Nziaambi akuti na bakaa ba beni, bu aleeli kwaa Abraami: “Me sasieme bifuumbu bioosi nha tsini a toto mu baana ba we.” ");
INSERT INTO iyx_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Tsiomi mundaa a beni, Nziaambi atsinduu musiali a nde, mu ufulu beni muulu, paa muutu-muutu mu beni, amatuu mu ma mabi ma nde.» ");
INSERT INTO iyx_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Bu Peetero na Yowani bali keni mu utsuu kwaa koongi, bangaanga ba Nziaambi, mukuutu a bakebi ba Nzo a Nziaambi na Basaduki bayiri nha peembi a bo. ");
INSERT INTO iyx_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Bo bakoli kesi mu ndaa nziisili a batumu boolo baa, yili mu uyaabisa ti Yiisu asiimbii mu likwa, mu nde babakwa utuu usiimbuu ka. ");
INSERT INTO iyx_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Bakaangi bo na baloosi bo mutso perese, mu ukebe iluumbu kia nha ngwaali mundaa ti bwisi ali bumayili. ");
INSERT INTO iyx_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Bunu, balayi mu ba bayuyi nziisili a batumu basiiri imiini mu Nziaambi. Na litaanga la baata lafuni mu iteesi kia helape mafuundu mataana. ");
INSERT INTO iyx_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Bukia ngwaali, bapfumu ba Bayuudayo, na bakuutu, na bayiisi ba Mikele, bakukini ku Yeruselemi. ");
INSERT INTO iyx_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kwali Aana nguu a ngaanga a Nziaambi, itwaari na Kayifa, Yowani, Alekandere na boosi babutii mu kaanda la nguu a ngaanga a Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Babeyi Peetero na Yowani nha kulu a bo, na babafuuli: «Mu ki litu, so a buu pe, mu kuumbu a na, beni dibeelisi nde?» ");
INSERT INTO iyx_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ka Peetero, bu aluuli mu Muheebili wa Ngira, wabaleeli: «Bapfumu ba koongi na bakuutu ba baata, ");
INSERT INTO iyx_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Bisi diyilii ndaa yimbwe kwaa ikata, na lolo baka mu ufuulu bisi manduru buni muutu wu abeelii. ");
INSERT INTO iyx_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Diyiluu uyaaba bubwe beni boosi na koongi a Iseraeli ti mu kuumbu a Yiisu Kristo musi Nazareti, wu beni diakomi nha muti wa kuruwa, na wu Nziaambi asiimbili mu babakwa, ni mu ndaa Nde, muutu wu atemini nha kulu a beni na ali polo. ");
INSERT INTO iyx_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ni mu ndaa Yiisu, ma basonuu ma Ngira mali mu uyaabisa: “Manya li, beni batuungi ba manzo diabumi, ni lo limaakituu manya la tala, manya la ibwa.” ");
INSERT INTO iyx_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","A uli na Liyobolo mu muutu mukimi pe, mu ndaa a uli pe na kuumbu kimi nha tsini a toto, yi Nziaambi aha kwaa baata, yi bisi dituu uyobuu.» ");
INSERT INTO iyx_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Bo bu bamoni ilimbisi kia Peetero na Yowani, ikuutu kia pfuundu a Bayuudayo kiakimii, ka bo bayaabi ti baata ba a bali na nziaabili pe. Bo balibili moonyi, ti Peetero na Yowani bali itwaari na Yiisu. ");
INSERT INTO iyx_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ka bu bakimono muutu wa beelii atemene nha peembi a bo, a babayi ya uvutulu pe. ");
INSERT INTO iyx_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Bo batumi bo mu upala ku mbari a pfuundu a ikuutu. Bakuutu badiaali mu ukutu pfuundu, ");
INSERT INTO iyx_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","baleelisini: «Ima diyiluu mu baata ba? Ka basi Yeruselemi boosi bayaaba ti imaanga ki, bo bayilii kio, na bisi a dituu utunu kio pe. ");
INSERT INTO iyx_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ka mu ndaa ti, ndaa yii, ihele ubwayabina nha kati a koongi, diabalii mu ibaala kioosi, banyaala ubwatsuu mu kuumbu a Yiisu.» ");
INSERT INTO iyx_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ni mu buu bo babati mbila, balii bo mu ibaala, mu uhele ubwatsuu na uyiisi mu kuumbu a Yiisu. ");
INSERT INTO iyx_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Peetero na Yowani bavutuli kwaa bo, baleeli: «Buni, leelani, so bwafwaana nha kiinzi kia Nziaambi, mu utumumu beni, na uhele utumumu Nziaambi? Dikengese bene bameme. ");
INSERT INTO iyx_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ka, bisi a dituu pe unyaala utsuu mu mi diamoni na mi diayuyi.» ");
INSERT INTO iyx_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Bakuutu ba Bayuudayo babwikwaamisa bo na babanyaali, kwa hele a ubaa toono ya usieembe bo, mu ndaa koongi. Ka boosi bakibili Nziaambi mu maa mayilimi. ");
INSERT INTO iyx_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Muutu wuu, wabelii mu imaanga kii, ali alutu maku mana ma bilimi. ");
INSERT INTO iyx_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nha mbisi a unyaala bo, Peetero na Yowani bayeni kwaa banduu ba bo, na baleeli moosi ma banguu ba bangaanga ba Nziaambi na bakuutu ba Bayuudayo baleeli kwaa bo. ");
INSERT INTO iyx_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Bu bamani uyuu maa, bangaa imiini boosi mu itwaari, banaangili ndaa kwaa Nziaambi mu likuundu na baleeli: «Pfumu, ni we ayilii yula, na tsi, na mubu na biloo bioosi bili mu bio, ");
INSERT INTO iyx_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ni we atsuuyi mu Muheebili wa Ngira, mu munywa a Daavidi, kaa a bisi musiali a we, ti: “Mu ima bifuumbu bia nha tsi bili mu unyingini? Mu ima makoongi ma baata makuti mapfuundu ma ibuu? ");
INSERT INTO iyx_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mitini mia tsi miayilimi mu mudiingi, na bapfumu bakukini, bavuutini nha mbuu mosi mu udwaanisa Pfumu, na Mesiya a Nde.” ");
INSERT INTO iyx_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ka ni mubuu, mu ngwanya, Erode na Ponse Pilato bavuutini itwaari na bangooyi na koongi a Iseraeli mutso ngaanda yi, mu udwaanisa musiali a we wa Ngira, Yiisu wu we abiaalisi. ");
INSERT INTO iyx_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bo bayilii maa moosi, mu ukuusu moosi ma koo kia we na kesili a we biakwiyesene. ");
INSERT INTO iyx_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Na mu taanga di, Pfumu, mono minhana mia bo mimibi, na ha muswa kwaa basiali ba we mu uyiisi mandaa ma we mu ibaala kioosi. ");
INSERT INTO iyx_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Sibili koo kia we paa bimaanga na biliimbi biyilimi mu kuumbu a Yiisu, musiali a we wa Ngira.» ");
INSERT INTO iyx_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Bu bamani ukuundu, mbuu yi bo bali bakukunu yanyingini, boosi baluuli mu Muheebili wa Ngira: na bayaabisi ndaa a Nziaambi mu ibaala kialaa. ");
INSERT INTO iyx_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Kaba la boosi babasi imiini, bali mutimi mosi na matsimi mamosi. A so mosi pe nha kati a bo wakileele ti mbayili a nde yili ya nde makulu, ka bioosi biali bia itwaari. ");
INSERT INTO iyx_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Mu lituu la mifuri batumu bakita imbaangi kia tsimbilili a Pfumu Yiisu mu babakwa, na bweese ba Nziaambi balaa bali nha yulu a bo boosi. ");
INSERT INTO iyx_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nha kati a bo, a kwali muwele pe. Ka boosi ba bali na matsie ma bo na manzo ma bo bayalii bio na babeyi tala a bii bi bayalii, ");
INSERT INTO iyx_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","na basuusi mboongo nha miili mia batumu. Na bakabi dio weti bwali manzala ma muutu-muutu. ");
INSERT INTO iyx_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kwali na muutu mosi kuumbu a nde, Yoosefi mulevita musi Kipiria wu batumu bakita ka Barnaba, mbiindili ti «muutu uli mu uhamisa». Muutu me mulevita. ");
INSERT INTO iyx_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nde ayalii tsiee a nde, abiti mboongo na asuusi dio nha miili mia batumu. ");
INSERT INTO iyx_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kwali baala limosi kuumbu a nde Anania, itwaari na Safira mukari a nde, bayalii ka tsiee a bo. ");
INSERT INTO iyx_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Bayuhisini nde na mukari a nde, mu uswee ndaamba a mboongo. Nha mbisi Anania abeyi diasiaali na asuusi dio nha miili mia batumu. ");
INSERT INTO iyx_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Peetero aleeli kwaa nde: «Anania, mu ima Saatina aluusi mutimi a we, paa we futu pia kwaa Muheebili wa Ngira, mu uswee ndaamba a mboongo di we ayaluu tsiee? ");
INSERT INTO iyx_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tswaamina we uyaluu tsiee, we aba utuu ukebe yo, na nha mbisi a uyaluu yo, we aba utuu uyiluu mi we atoono mu mboongo. Buni we tsimi mu mutimi a we mu uyiluu ndaa ya pili yi? A kwaa baata pe we futi pia, ka kwaa Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Bu Anania ayuyi mandaa maa, nde abwi nha tsi na akwi. Boomo balaa babwiili boosi ba bayuyi ndaa yii. ");
INSERT INTO iyx_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Bafuru batemini, badii mvuumbi matsaanda, bamubiti na bamudii. ");
INSERT INTO iyx_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Nha mbisi a manguungu helape matata, mukari a nde atoori nhaa, kwahele a uyaaba mialabii. ");
INSERT INTO iyx_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peetero wamufuuli: «Leele me, mu tala yii beni diayaluu tsiee?» Nde avutili: «Ee, ni mu tala yii.» ");
INSERT INTO iyx_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ka Peetero aleeli kwaa nde: «Mu ima beni diyuhisini, mu uwungusu Muheebili a Pfumu? Ka yaaba ti baa babayidii mulumi a we nha munywa a nzo bali, bo sababiti we ka!» ");
INSERT INTO iyx_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Nhaa-na-tsi, nde abwi nha miili mia Peetero, na akwi. Bafuru bu bakoti, bamubaasi akwa. Bayeni na nde na bamudii nha peembi a mulumi a nde. ");
INSERT INTO iyx_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Boomo balaa babwiilili libuundu loosi, na boosi babayuyi mandaa maa. ");
INSERT INTO iyx_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Batumu bayilii biliimbi na bimaanga bialaa nha tso koongi. Babasi imiini mu Yiisu boosi, bavuutini mu itwaari nha ipaangala kia Salomo. ");
INSERT INTO iyx_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","A so muutu mukimi pe wasiayi uyavuutunu na kaba la babasi imiini, bunu koongi yakikiinzi bo kwalaa. ");
INSERT INTO iyx_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Koongi yalaa ya babaala na Bakaasa basi imiini mu Pfumu, na bakoti mu kaba la bo. ");
INSERT INTO iyx_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Mu toono yii, baata bakibee babeeri mu makuulu mamanene, na bakisuusu bo nha yulu a bikala na malaba, paa nha Peetero ulabuu, iziimi kia nde ifuu so ndila mosi mu bo. ");
INSERT INTO iyx_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Koongi a baata yamati mu mangaanda madiengelele Yeruselemi, babeyi babeeri na baata ba miheebili mimibi miakikwaamisa, na boosi babeelii. ");
INSERT INTO iyx_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nguu a ngaanga na boosi bali na nde, na kaba la Basaduki, baluuli mu musoyi baholi kesili mundaa batumu. ");
INSERT INTO iyx_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Bakaangi bo na babaloosi mu perese. ");
INSERT INTO iyx_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ka mu butsuu tumu a Pfumu adibili minywa mia perese, wabapalisi na wabaleeli: ");
INSERT INTO iyx_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Diyene dikoto kutso lipaanga la Nzo a Nziaambi, na dileele kwaa baata mandaa moosi ma moonyi wu munyatii.» ");
INSERT INTO iyx_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Bu bayuyi maa, bo bakoti mu lipaanga la Nzo a Nziaambi mu ngwaali a ngwaali na babaandii uyiisi. Nguu a bangaanga a Nziaambi na boosi babali na nde, batumisi pfuundu a ikuutu kia Bayuudayo na mvuutini a bakuutu boosi ba Iseraeli, na batsindii baata mu uyaholo batumu ku perese. ");
INSERT INTO iyx_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ka bakebi ba nzo a Nziaambi ba batsindii bu batoori, a babaasi pe batumu mutso perese. Bu bavutii, baleeli ma bamoni: ");
INSERT INTO iyx_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Bisi dimoni perese badibuu bubwe-bubwe, bakebi ba perese batemene nha minywa mia nzo a perese, ka bu diadibili, a diamono muutu so mosi ku kati pe.» ");
INSERT INTO iyx_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Bu bamana uyuu maa, mukuutu a bakebi ba Nzo a Nziaambi na banguu ba bangaanga, a bayaabi pe ima bafwaana usa mu bo, na basiayi uyaaba mima miabwiili batumu. ");
INSERT INTO iyx_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Muutu mosi ayiyaabisa bo: «Diyuu! Baata ba beni dialooso mu perese, bali mu uyiisi baata kutso lipaanga la Nzo a Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ni mu buu, mukuutu wuu na bakebi ba nde bayiholo batumu. Babiti bo buke-buke, mundaa ti bo bali na boomo ti koongi ayitete bo mamanya. ");
INSERT INTO iyx_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bu bayiri na bo, bo bamweese bo nha kulu a pfuundu a ikuutu kia Bayuudayo. Nguu a bangaanga wabafundisi, ");
INSERT INTO iyx_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","wabaleeli: «Bisi a dialii pe beni mu uyiisi mu kuumbu yii? Beni dimaluusu Yeruselemi mu nziisili a beni! Na beni ditooni unaa mafuumbu ma likwa la muutu wuu nha yulu a bisi.» ");
INSERT INTO iyx_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Peetero na batumu bavutuli: «Bubwe mu utumumu kwaa Nziaambi, ka a kwaa baata pe. ");
INSERT INTO iyx_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nziaambi a bamwakaa ba bisi asiimbili Yiisu wu beni diadusi bu diamukomi nha muti wa kuruwa. ");
INSERT INTO iyx_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nziaambi wamunaangili nha koo kia nde kia babaala, na wamubiaalisi weti Pfumu na Muvuuyisi, paa aha kwaa baata ba Iseraeli kiingili a mayele, mu usobo ndiaatili, na baholo nyaalili a masumu. ");
INSERT INTO iyx_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Bisi dili bambaangi ba maa moosi, bisi na Muheebili wa Ngira wu Nziaambi ahi kwaa ba bubaatumumu nde.» ");
INSERT INTO iyx_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Mu taanga di ikuutu ya pfuundu kiayuyi mii, babayi kesi, na babayi tsimi ya udusu batumu. ");
INSERT INTO iyx_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ka mosi mu Bafarisi, kuumbu a nde Ngamalieele, muyiisi a Mikele, wu baata boosi bakikiinzi, atemini nha kati a pfuundu a ikuutu kia Bayuudayo, atumi bapalisa batumu mu mwaana a taanga hoolo. ");
INSERT INTO iyx_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Tumake nde aleeli kwa koongi: «Baata ba Iseraeli, disa mayele mu mi diatsimi uyiluu mu ndaa a baata ba. ");
INSERT INTO iyx_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Mu biluumbu biyoyi bi, wamonii muutu moosi wa kuumbu Teda, wakisaa umweese ti nde muutu wa likiinzi; na baata balaa bamuduki, mu litaanga helape makama-mana ma babaala. Bamudusi, na boosi ba bali nha mbisi a nde batsiaamii, ndaa yii yawi. ");
INSERT INTO iyx_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Nha mbisi a nde, kwamonii ka muutu mukimi wa kuumbu Yuuda musi Ngalili, mu biluumbu bia taangili a baata. Nde akoyi baata balaa nha mbisi a nde: nde ka akwi, na boosi ba bakiduku nde, batsiaamii. ");
INSERT INTO iyx_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Mu taanga di, me nileele kwaa beni: ditakuu wa beni na baata ba, na diabanyaala. So ili matsimi na biyiluu bia imuutu, bio sa bisuku. ");
INSERT INTO iyx_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ka so bimati kwaa Nziaambi, beni a dituu udiimbisi bio pe. Disa mayele a diyadwaanisa pe Nziaambi!» Koongi yayuyi tsimi a Ngamalieele. ");
INSERT INTO iyx_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Bo bati batumu mbili, babateti bikoti, na babalii mu uhele ubwatsuu mu kuumbu a Yiisu, na babanyaali. ");
INSERT INTO iyx_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Batumu basiisi pfuundu a ikuutu kia Bayuudayo, bayeni mu kinyi yoosi mundaa bwafwaana kwaa bo ti bamono pasi mu kuumbu a Yiisu. ");
INSERT INTO iyx_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Pasi iluumbu, kutso lipaanga la Nzo a Nziaambi na mutso manzo, bo bahami mu uyiisi na uyaabisa ndaa yimbwe ya Yiisu ni Mesiya. ");
INSERT INTO iyx_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mu biluumbu bii, bu litaanga la miyii lakipfunu, kaba la Bayuudayo lakitsuu ndaa ya basi Eleene, bakinhunhunyu mu kaba la Bayuudayo bakitsuu ndaa a Baebeleo. Minhu-nhunyu mi ali mu ndaa ti bakimeengele bakwiili ba bo, mu kabili a biloo bia pasi iluumbu. ");
INSERT INTO iyx_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Batumu kuumi na boolo, batumisi koongi a miyii, na baleeli: «A bwafwaana kwaa bisi pe mu unyaala uyiisi mandaa ma Nziaambi na mu ukaba bia udia. ");
INSERT INTO iyx_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ni mu buu baana ba nguu, disoolo nha kati a beni babaala tsaamba, ba bali mu uta imbaangi ki ibwe mu bo, ba baluulu mu Muheebili wa Ngira na mu buyeri. Bisi sadiha bo mufunu wa ukaba biloo. ");
INSERT INTO iyx_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Bisi ni badili, sa dihama mu isala kia likuundu na kia uyiisi mandaa ma Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Koongi yoosi yamoni kinyi mu matsimi maa. Bo basooli Estefano, muutu waluulu mu imiini mu Nziaambi na mu Muheebili wa Ngira, Filipo, Prokore, Nikanore, Timoni, Paremena na Nikola wa ku vulu la Antioki wakitii na akoti mu libuundu la Bayuudayo. ");
INSERT INTO iyx_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ku mbisi atsolili, babamweesi kwaa batumu. Babakuundili na babanayi mioo. ");
INSERT INTO iyx_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Mandaa ma Nziaambi matsiaamii, na litaanga la miyii lafuni mawasa-mawasa mu vulu la Yeruselemi. Koongi yalaa ya bangaanga ba Nziaambi yasiiri imiini mu Yiisu. ");
INSERT INTO iyx_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Estefano ali aluulu mu litu na mu bweese ba Nziaambi, akibayilu bimaanga na biliimbi bi binene, nha kati a koongi. ");
INSERT INTO iyx_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Mwaana kaba la Bayuudayo la nzo makutunu, yi bakita ti nzo a «baata ba bakuuli mu butee» — bo boosi bali basi Kireni, basi Alekandere, basi Silisi, na baata ba ku itinini kia Asia — ni bo bakoti mu paa na Estefano. ");
INSERT INTO iyx_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ka bo a batuyi ubiingi pe mu ndaa tsuyili ya buyeri yi Muheebili wa Ngira akiha kwaa Estefano. ");
INSERT INTO iyx_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ni mu buu, bo bahi mboongo kwaa baata paa baleele ti: «Bisi diayuu nde mu utuu Mooso na utsoro Nziaambi!» ");
INSERT INTO iyx_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Bo batsindi baata boosi, na bakuutu ba Bayuudayo na bayiisi ba Mikele. Bo boosi bu bayiri, bakaangi Estefano na bamubiti nha kulu a pfuundu a ikuutu kia Bayuudayo. ");
INSERT INTO iyx_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Bo babeyi bambaangi ba pia, ba baleeli: «Muutu wu li mu hama utsuwanga mandaa ma mabi mu Nzo abisi ya Ngira na mu mikele mia Mooso. ");
INSERT INTO iyx_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Na bisi diayuu nde mu uleele ti Yiisu musi Nazareti sa atsala Nzo ya Ngira, na sa asobo bukulu ba Mooso ba asiisi bisi.» ");
INSERT INTO iyx_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Boosi ba bali nha pfuundu a ikuutu kia Bayuudayo misi mia bo miali miatala isooso nha yulu a Estefano. Mundaa ti bo boosi bamoni kiinzi kia nde kiali imaafwaanina weti kia Tumu a Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Nguu a bangaanga ba Nziaambi afuuli nde: «Ma bali mu uleele mu we magwanya?» ");
INSERT INTO iyx_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Estefano avutili: «Baana banguu ba me na bataayi ba me, diyuu me bubwe! Nziaambi wa buzitu amonii kwaa Abraami, kaa a bisi a beni mu taanga di nde ali ku itinini kia Mesopotami, tswaamina nde uyadiaala ku ngaanda a Arana. ");
INSERT INTO iyx_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Na Nziaambi aleeli kwaa nde: “Pala mu tsi a we, na mu kaanda la we, na yene ku tsi yi me kaamweese we.” ");
INSERT INTO iyx_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ni mu buu nde apali mu tsi a basi Saledeni, na ayidiaala ku Arana. Tumi nha mbisi a likwa la taayi a nde, Nziaambi wamubiti umatuu ku vulu la Arana natee ku tsi yi beni dili mu udiaala lolo li. ");
INSERT INTO iyx_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nziaambi a ahi nde ibwa mu tsi yii pe, a so mwaana ibari kia toto kia ikee pe. Ka Nziaambi wamusi lilasini li: “Me sa ha we tsi yi, na yo sa yiba yawe natee bateeri ba we nha mbisi a we.” Ka bunu mu taanga dii, nde ali keni mwaana pe. ");
INSERT INTO iyx_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nziaambi aleeli kwaa nde: “Baana ba we na bateeri ba we sa badiaala ku tsi ya bumweenyi. Kuu bo sa baba mu bukori na sa bamweese bo pasi mu tsitsi a makama-mana ma bilimi.” ");
INSERT INTO iyx_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nziaambi abwileele ka: “Me sa fuundusu tsi yi bo buba mu bukori. Nha mbisi a nhaa, bo sa bapala mu yo, na sa bayakiinzi me nha mbuu yi.” ");
INSERT INTO iyx_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Tumake, Nziaambi ayilii mutsii na Abraami. Iliimbi kia mutsii wuu ni kesili a mwaana wa baala. Ni mu buu, Abraami akesi mwaana a nde Isaki mu iluumbu kia pwoombo nha mbisi a mbutili a nde. Bumosi ka Isaki akesi mwaana a nde Yaakobi, na Yaakobi akesi baana ba nde kuumi na boolo, ba bali bakaa ba bisi.» ");
INSERT INTO iyx_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Mu ndaa musoyi bakaa ba bisi, bayalii mwaana nguu a bo Yoosefi ku tsi ya Ngipiti mu uba kori. Ka Nziaambi ali itwaari na nde. ");
INSERT INTO iyx_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Na wamukuuli mu mapasi ma nde moosi. Nziaambi wamuhi mayele na amonii muutu wabweese nha kulu a Farao, mutini a ku Ngipiti. Ni mu buu, Farao abiaalisi nde pfumu mu Ngipiti na nha yulu a nzo a nde yoosi. ");
INSERT INTO iyx_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Nha mbisi a nha, mono nzala ya mifuri yakoti mu tsi yoosi ya Ngipiti na mu tsi ya Kaana. Pasi diali dialaa, na bamwakaa ba bisi bakooni ubaa bia udia. ");
INSERT INTO iyx_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yaakobi bu ayuyi ti kuli na biloo bia udia ku Ngipiti, nde atsindii bamwakaa ba bisi kuu mu mbala ya tsiomi. ");
INSERT INTO iyx_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Bu bayeni mbala ya dioolo, Yoosefi ayabini kwaa baana ba nguu ba nde, na Farao ayaabi kaanda lapali Yoosefi. ");
INSERT INTO iyx_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Nha mbisa nhaa, Yoosefi atumi bayaholo Yaakobi taayi a nde, na kaanda loosi. Bo bali mu litaanga la maku tsaamba na baata bataana. ");
INSERT INTO iyx_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Bu Yaakobi ayeni ku Ngipiti, nde akwi kuu na bamwakaa ba bisi baba moosi. ");
INSERT INTO iyx_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Babiti bamvumbi ba bo ku bula ba kuumbu Siseme, na badii bo ku ngili yi Abraami asuumbi mu mboongo, kwaa baana ba Aamori ku Siseme.» ");
INSERT INTO iyx_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Bu taanga diali ka bebele mu ukuusu lilasina li Nziaambi asi na Abraami, koongi a bisi yakuli na yafuni mu Ngipiti. ");
INSERT INTO iyx_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ka mono mutini mukimi wu munyatii abaandii mu utumu ku Ngipiti, nde ali a ayaaba pe Yoosefi. ");
INSERT INTO iyx_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mutini wu munyatii wuu, afuti koongi a bisi na bamwakaa ba bisi na amweesi bo pasi dialaa. Mutini wu abiti bo, natee mu iteesi kia ubamuu bo, paa babwoongolo baana ba bo ba bikenyi paa bakwa. ");
INSERT INTO iyx_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ni mu taanga dii Mooso abutii, wali mwaana wumubwe nha kiinzi kia Nziaambi. Batsatsi nde mu nzo a taayi a nde mu tsitsi a batsuungi batata. ");
INSERT INTO iyx_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Bu babwoongili Mooso, mwaana a Farao wa mukasa, aholi nde na abuungili nde weti mwaana a nde makulu. ");
INSERT INTO iyx_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ni mu buu, Mooso akuli kutso nziisili na abayi nziaabili yoosi ya basi Ngipiti, na nde ayabini ka muutu wa litu mu mandaa ma nde na mu biyiluu bia nde. ");
INSERT INTO iyx_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Bu Mooso, akuusi maku mana ma bilimi, nde abayi tsimi ya uyamono baana ba nguu ba nde, baana ba Iseraeli. ");
INSERT INTO iyx_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Bu amoni musi Ngipiti mu umweese pasi kwa mosi mu baata ba Iseraeli, nde akoti mu ukala ubaki mweese pasi. Mooso bu akivutulu mamabi kwaa musi Ngipiti, nde wamudusi. ");
INSERT INTO iyx_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Nde atsimi ti helape baana ba nguu ba nde, ali utuu ubahala ti mu nde, Nziaambi atoono ukuulu bo, ka bo a batuyi ubahala buu pe. ");
INSERT INTO iyx_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Iluumbu kiaduki, nde amoni baata ba Iseraeli ba bakidwaana. Mooso asiayi mu uvuutu bo iyeenge, na aleele: “Beni bambaayi ba me, beni baana ba nguu mosi, mu kitoono dili mu mweese bana pasi?” ");
INSERT INTO iyx_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ka wuu wakimweese mbaayi pasi, abaasili Mooso na aleele: “Na asuusu we mu uba mukuutu na nzioonzi nha yulu a bisi? ");
INSERT INTO iyx_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","We me tooni udusu ka, weti bu adusi musi Ngipiti matsii?” ");
INSERT INTO iyx_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Bu ayuyi mandaa maa, Mooso abati na ayidiaala mu tsi ya bumweenyi, tsi ya Madiani. Kuu, nde abuti baana boolo ba babaala.» ");
INSERT INTO iyx_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Nha mbisi a maku mana ma bilimi, Tumu a Nziaambi amonii kwaa Mooso mu tsi ya tsata ku mulaanda a Sinayi, kutso mulee a mbaa yakinama nhaa mu miti mia mikee. ");
INSERT INTO iyx_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Bu amoni buu, Mooso akimii mu monini yii, na bu akiswese mu utala bubwe, nde ayuyi ndaa a Pfumu yaleeli: ");
INSERT INTO iyx_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Me ni Nziaambi a bamwakaa ba we, Nziaambi a Abraami, Isaki na Yaakobi.” Mooso a tehiti mu boomo, na akooni ubwatala. ");
INSERT INTO iyx_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ni mu buu, Pfumu aleeli kwaa nde: “Maasa bikoori bia we mu miili mia we, mu ndaa ti mbuu yi we atemene yili mbuu ya Ngira. ");
INSERT INTO iyx_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Me maamono ma mapasi ma baata ba me babali ku Ngipiti. Me mayuu mikonyo mia bo na me maasutuu mu ukuulu bo. Mu taanga di yene, me nitsinduu we ku Ngipiti.”» ");
INSERT INTO iyx_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Mooso muutu wu baata ba Iseraeli babisi, bu bamuleeli: “Na asuusu we mu uba mukuutu na nzioonzi nha kati a bisi?” Ee, ni nde wu Nziaambi atsindii mu uba mukuutu na mukuuli, weti bwaleeli Tumu a Nziaambi, wamonii kwa nde mu mulee a mbaa yakiluluu mu miti mia mikee. ");
INSERT INTO iyx_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ni Mooso apalisi baata ba Iseraeli mu Ngipiti, na a yilii bimaanga na biliimbi mu tsi yii, nha Mubu Wabeenge na mu tsi ya tsata mu maku mana ma bilimi. ");
INSERT INTO iyx_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ni Mooso waleeli ka kwa baana ba Iseraeli ti: “Nziaambi sa apalisa mubili nha kati a beni, wuli mwaana nguu a beni weti me, wuli mosi nha kati a baata ba beni.” ");
INSERT INTO iyx_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mu taanga di baana ba Iseraeli bali bakukunu mu tsi yahele a baata, Mooso ali nha kati a bamwakaa ba bisi na Tumu a Nziaambi waki tsuu kwa nde nha yulu a mulaanda a Sinayi. Mooso aholi mandaa ma moonyi mu utoosolo mo kwa bisi. ");
INSERT INTO iyx_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ka bamwakaa ba bisi a batooni utumumu nde pe; bamutuni, na bo batooni uvutuu ku Ngipiti. ");
INSERT INTO iyx_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ni mu buu, bo baleeli kwaa Aaroni: “Yiluu bisi banziaambi ba buyooyene nha kulu a bisi, mu ndaa Mooso wuu wapalisa bisi ku tsi ya Ngipiti, a diayaaba pe mima amabwaana na mio.” ");
INSERT INTO iyx_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Mu iluumbu kii, bo bayilii iteyi kia mwaana ngoombo, na babeyi bungori kwaa iteyi kii, na bo basi mukuungi mu ndaa ukiinzi biyiluu bia mio mia bo. ");
INSERT INTO iyx_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ka Nziaambi ateyi bo mbisi, na wabanyaali bakuundu bambwelele ba yula, weti bu basonuu mu mukaanda a mibili: “Baata ba Iseraeli, kwaa me beni diahi banyama na bungori bakimi mu maku mana ma bilimi mu tsi ya tsata? ");
INSERT INTO iyx_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Beni diabiti nzo a ngooto ya Nziaambi a beni uli kuumbu Moloke, na ifwaani kia Nziaambi a beni wabambwelele uli kuumbu Refani, beni diayilii biteyi bii, paa beni dikuundu bio! Ni mu buu, me sabiti beni ku bukori, ku tsi yala, ya bumweenyi ku mbisi a Babilooni.”» ");
INSERT INTO iyx_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Ku tsi yili baata pe, bamwakaa ba bisi bali na nzo a ngooto mwali na mamanya ma ba sonuu Mikele. Bayilii nzo yi weti bu Nziaambi atumi kwaa Mooso. Nde atuungi yo mu ifwaani ki nde amoni. ");
INSERT INTO iyx_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Nzo a ngooto yii, bahi yo kwaa bamwakaa ba bisi mu kubu yaduki. Bo babiti yo ku tsini a litumu la Yooswa. Mu taanga dii, bo babiingi matsi ma bifuumbu bia baata ba Nziaambi abingi nha kulu a bo. Nzo a ngooto yii yali natee mu taanga dia Daavidi. ");
INSERT INTO iyx_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daavidi wabayi bweese nha kulu a Nziaambi, na nde aloombi muswa wa utuungu Nzo a Nziaambi a Yaakobi. ");
INSERT INTO iyx_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ka ni Salomo wamutuungili nzo. ");
INSERT INTO iyx_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ka bunu Nziaambi wa ku mayula a ubaadiaala pe mu manzo matuungu baata. Weti buleeli mubili: ");
INSERT INTO iyx_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Yula ni mbata a ipfumu kia me, na toto ni isuusili kia miili mia me. Ki pili a nzo beni dituu utuungulu me? Buleeli Pfumu, na ki mbuu me nituu uwuumu? ");
INSERT INTO iyx_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ka a me Nziaambi nayiluu biloo bioosi mu mioo mia me pe?”» ");
INSERT INTO iyx_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«Beni dili baata, bangaa mutswe pini, mitimi miakubu, na matswi makwa mu uhele uyuu mbili a Nziaambi. Beni dili mu udwaanisa Muheebili wa Ngira! Beni diafwaanina weti bamwakaa ba beni! ");
INSERT INTO iyx_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ki mubili wu bamwakaa ba beni bahele ukwaamisa? Bo badusi ba bayaabisi nzirili a Muutu wa Libweeye. Na mu taanga di, ni nde beni dimaayeelele na dimaadusu. ");
INSERT INTO iyx_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Beni badiayaki Mikele mu libaasila la Batumu ba Nziaambi, kasi a diatumumi Mikele mii pe!» ");
INSERT INTO iyx_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Baata ba pfuundu a ikuutu kia Bayuudayo bafweengi bu bayuyi mandaa maa. Bakweetisi mini mu umweese kesi a bo kwa Estefano. ");
INSERT INTO iyx_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ka Estefano, bu ali aluulu mu Muheebili wa Ngira, atali ku yula, amoni buzitu ba Nziaambi, na Yiisu atemene nha koo kia babaala kia Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Nde aleeli: «Diyuu, me ndi mu umono mayula mali bwaasi, na Mwaana a Muutu atemene nha koo kia babaala kia Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Bo baloyi mu mifuri, na badibii matswi ma bo. Bo boosi mu itwaari bayibwa nha yulu a nde. ");
INSERT INTO iyx_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Bo bakoyi nde ku mbari a ngaanda, na bateti nde mamanya mu udusu nde. Bambaangi basuusi bikutu bia bo paa mufuru a baala wa kuumbu Sawuli akebe bio. ");
INSERT INTO iyx_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Mu taanga dibakitete nde mamanya, Estefano akikuundu mbii bu: «Pfumu Yiisu! Hoolo muwuumu a me.» ");
INSERT INTO iyx_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tumake atsukini, na aloyi mu mifuri: «Pfumu, a taanga masumu ma bo pe!» Bu amani na uleele mandaa maa, nde akwi. ");
INSERT INTO iyx_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sawuli asiingisi ndusili a Estefano. Mu iluumbu kii, mbingisi yinene yakoti mu libuundu la Yeruselemi. Boosi ba basa imiini batsiaamii mu bitinini bia Yuuda na bia Samaria, ka batumu basaali. ");
INSERT INTO iyx_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ka baata bangaa likiinzi la Nziaambi badii Estefano, balili na banyoongi kwalaa mu likwa la nde. ");
INSERT INTO iyx_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ka Sawuli ahami mu utsala libuundu. Nde akoti mu manzo, akaangi babaala na Bakaasa, na aloosi bo mu perese. ");
INSERT INTO iyx_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Bangaa imiini ba batsiaamii, bakiyaabisa Ndaa Yimbwe mu ma mbuu moosi ma bakiyene. ");
INSERT INTO iyx_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ni mu buu, Filipo ayeni ku ngaanda mosi ya Samaria, mu yaabisa baata ndaa ya Mesiya. ");
INSERT INTO iyx_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Mu taanga di koongi yayuyi nziisili a Filipo, na bu bamoni bimaanga bi nde ali ayiluu, bo bakangimi mu ma bakiyuu mu munywa a nde. ");
INSERT INTO iyx_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ee-e, mu ngwanya, miheebili mimibi miakipala mu babeeri ba balayi na miakiloo mu mifuri. Bikata na bitonzo bialaa biabeelii. ");
INSERT INTO iyx_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ni mu buu kinyi yalaa yamonii mutso ngaanda yii. ");
INSERT INTO iyx_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kwali baala limosi watswaamini Filipo mu ngaanda yi, kuumbu a nde Simooni. Nde akisalila biyiluu bia pimisi, baata ba itinini kia Samaria ba kikimuu mu biyiluu bia nde. Na nde akimonuu ti nde muutu wa lidumu. ");
INSERT INTO iyx_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ni mu buu, umatuu binge-ngebe natee baata ba bakulu ba mu itinini kii, bahi nde lidumu, bakileele: «Muutu wu, li Litu la Nziaambi, li bali mu uta “Litu li Linene.”» ");
INSERT INTO iyx_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Toono yi bo bakangimi mu nde, mu ndaa ti, umatuu bele pe, bo bakimono mia ukimuu mu biyiluu bia nde bia pimisi. ");
INSERT INTO iyx_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ka ku mbisa kuu, basi imiini mu Ndaa Yimbwe ya Yiisu Kristo yi Filipo ayiisi bo, Ndaa ya Ipfumu kia Nziaambi. Baata balaa, babaala na bakaasa baholi libootuu. ");
INSERT INTO iyx_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simooni nde makulu ka asiiri imiini mu Nziaambi na aholi libootuu. Nde anambiti Filipo, akimii kwalaa, na akibili nde bu akimono biliimbi na bimaanga bi binene biakiyiluu Filipo. ");
INSERT INTO iyx_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Bu batumu ba bali ku Yeruselemi, bayuyi ti basi Samaria bamaasiingi mandaa ma Nziaambi, ni mu buu bo batsindii Peetero na Yowani kwaa bo. ");
INSERT INTO iyx_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Bu Peetero na Yowani batoori ku Samaria, bo bakuundili bo Nziaambi, paa bayaka Muheebili wa Ngira, ");
INSERT INTO iyx_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","mu ndaa ti Muheebili wa Ngira ali keni a abwiilili pe mu muutu so mosi mu bo. Ka bo ali ndila libootuu baholi mu kuumbu a Pfumu Yiisu. ");
INSERT INTO iyx_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ni mu buu, Peetero na Yowani banayi mioo nha yulu a bo, na bo bayaki Muheebili wa Ngira. ");
INSERT INTO iyx_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Mu taanga di Simooni amoni ti, ba basa imiini, bayaki Muheebili wa Ngira mu nayili a mioo kwaa batumu. Nde abeyi mboongo kwaa Peetero na Yowani, ");
INSERT INTO iyx_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","na aleeli: «Diha me ka litu li, paa wuu, wu me ni naa mioo, ayaka Muheebili wa Ngira.» ");
INSERT INTO iyx_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ka Peetero avutili kwaa nde: «Nyaala we fuu itwaari na mboongo dia we, mu ndaa bu we tsimi ti bungori ba Nziaambi bali mu usuumbu bo mu mboongo! ");
INSERT INTO iyx_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","We a li na ikuku mu isala ki pe, mu ndaa mutima we a asuungunu pe nha kulu a Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ni mu buu, so we utuu usiisi matsimi ma we ma mabi, kiingili mayele, sobo ndiaatili na kuundu Pfumu, paa helape nde sa asa we kolokolo mu matsimi ma mutimi a we. ");
INSERT INTO iyx_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mu ndaa ti me ndi mu umono ti mutimi a we aluulu mu musoyi na we li kori kwaa masumu.» ");
INSERT INTO iyx_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simooni avutili aleeli kwaa Peetero na Yowani: «Beni bame dikuundu mu me kwaa Pfumu, paa me hele ubwiilili ndaa so mosi, mu ma dileeli beni.» ");
INSERT INTO iyx_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Bu bamani uta imbaangi mu Yiisu na uyaabisa mandaa ma Pfumu, Peetero na Yowani bavutii ku Yeruselemi, bu bakiyene ayaabisa Ndaa Yimbwe mu mala malaa ma mu Samaria. ");
INSERT INTO iyx_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Iluumbu imosi, Tumu a Pfumu aleeli kwaa Filipo: «Temene na yene ku peembi ya Sude, mu kuulu yi li mu umata ku Yeruselemi natee mu uto ku ngaanda ya Ngaza, mu tsi ya tsata.» ");
INSERT INTO iyx_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filipo atemini na ayeni. Mu kuulu nde abwaani muutu wa ku tsi ya Etiopi, wali musiali wu munene. Muutu wuu ali na mufunu wa ukebe busini ba Kandase, mutini wa mukaasa wa tsi ya Etiopi. Muutu wuu ayiri ku Yeruselemi mu ukuundu Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Nde bu akivutuu ku tsi a nde, adiaali mutso tomo a nde ya midiingi, mu uyene ataanga mukaanda a mubili Yeesaya. ");
INSERT INTO iyx_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Muheebili wa Ngira aleeli kwaa Filipo: «Swesuu ku peembi a tomo yi.» ");
INSERT INTO iyx_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipo adumi tiini, asweesi nha peembe a tomo yii, na ayuyi bu muutu wuu akitaanga mukaanda a mubili Yeesaya. Nde wamufuuli: «Li mu uyaaba mambiindili ma mandaa ma we li mu utaanga?» ");
INSERT INTO iyx_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Musi Etiopi aleeli: «Buni nituu uyaaba mbii ti muutu a abiindili me pe?» Na nde aleeli Filipo mu uhaata na udiaala nha peembi a nde. ");
INSERT INTO iyx_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Itsuru kia mandaa ma Nziaambi ki akitaanga yakileele weti bu: «Nde ali weti indombo kibakibiti ku udusu, weti mwaana a limeme lili mu hele uloo, nha kulu a wuu uli mu utebe nde miooso, nde ka a aleeli ndaa so mosi pe. ");
INSERT INTO iyx_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Bamweesi nde tsionyi ka a abayi libweeye pe. Na utuu utsuu mu ndaa imbisi kia nde? Ee, bakese idiingi kia nde nha tsi nha.» ");
INSERT INTO iyx_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Musi Etiopi afuuli kwaa Filipo: «Kolokolo a we, leele me, mubili wu, mu na ali mu utsuu? Mu nde makulu, oo ti mu muutu mukimi?» ");
INSERT INTO iyx_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ni mu buu, Filipo abiindili nde umatuu mu mandaa ma nde akitaanga, natee Ndaa Yimbwe yatala mu Yiisu. ");
INSERT INTO iyx_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Bu bakiyene mu kuulu, batoori nha mbuu yali maamba. Musi Etiopi aleeli: «Mono maamba, ima ikoonoso me mu uholo libootuu?»  ");
INSERT INTO iyx_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipo aleeli kwaa nde: «So we siiri imiini mu mutimi a we woosi, we utuu holo libootuu.» Nde avutili: «Me siiri imiini ti Yiisu Kristo li Mwaana a Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Nde atemisi tomo, bo basutii bo baboolo mu maamba, na Filipo wamubootii. ");
INSERT INTO iyx_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Mu taanga di bo bapali mu maamba, itsundu-a-tsundu, Muheebili a Pfumu amaasi Filipo, na musi Etiopi a abwimono nde pe. Nde ahami mu uduku kuulu a nde mu kinyi. ");
INSERT INTO iyx_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipo atoori ku ngaanda ya Azoti, akiyene ayaabisa Ndaa Yimbwe mu mala moosi mu akilutu, natee bu nde atoori ku ngaanda ya Sezare. ");
INSERT INTO iyx_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Mu taanga dii, Sawuli ahami mu matsimi ma nde ma ukwaamisa na usaa udusu miyii mia Pfumu. Nde ayeni kwaa nguu a bangaanga ba Nziaambi, ");
INSERT INTO iyx_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","mu uyaloombo mikaanda mi miha nde muswa mu ukoto manzo ma kutunu ma Bayuudayo, ma mali ku ngaanda ya Damaseko. Nde a yiliyi buu, paa bu nde akaabaasa baata kuu, ba babaala so ba Bakaasa, ba bali mu uduku Kuulu a Pfumu, nde sa wabakaanga, na ubiti bo ku Yeruselemi. ");
INSERT INTO iyx_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Bu Sawuli akiyene mu kuulu na ali ka bebele na ngaanda ya Damaseko, itsundu-a-tsundu liyalila lamati ku yula, layalisi na ladiengilili nde. ");
INSERT INTO iyx_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Nde abwi nha tsi, na ayuyi ndaa yakileele kwaa nde: «Sawuli, Sawuli, mu ima we li mu ubingisi me?» ");
INSERT INTO iyx_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Nde afuuli: «We ni na Pfumu?» Na ndaa yavutili: «Me ni Yiisu wu weli mu ubingisi. ");
INSERT INTO iyx_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Mu taanga di, temene na koto mu ngaanda ya Damaseko na sa baleele we mi we afwaana usa.» ");
INSERT INTO iyx_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Baata bakidieenge na Sawuli batemini, bakwi mamama. Bo bayuyi ndaa yii, ka a bamoni muutu pe. ");
INSERT INTO iyx_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ku mbisi a mii, Sawuli atemini na adibili misi, ka a akibwamono pe. Baa babaki sa midieenge na nde bamukaangi mu koo, na bamubiti ku Damaseko. ");
INSERT INTO iyx_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Nde asi biluumbu bitata mu bungima-ngimi, kwahele a udia so unywa. ");
INSERT INTO iyx_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Kwali ku Damaseko muyii mosi, kuumbu a nde Anania. Pfumu amonii kwaa nde kutso monini na aleeli: «Anania!». Na nde avutili: «Me nha ndi Pfumu!» ");
INSERT INTO iyx_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Pfumu aleeli kwaa nde: «Temene mu mawasa na yene mu kuulu yi bubaata “kuulu yasuungunu”, na koto mu nzo a Yuuda. Kuu we sa fuulu muutu wuli kuumbu a nde Sawuli, musi Tarasi. Nde li mu ukuundu Nziaambi mu taanga di. ");
INSERT INTO iyx_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Sawuli ka kutso monini, amoni muutu wa kuumbu nde Anania wakikoto mu nzo yi nde ali. Muutu wuu akinaa nde mioo paa abwamono.» ");
INSERT INTO iyx_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Anania avutili: «Pfumu, baata balaa batsuu me mu muutu wuu, na bayaabisa me, mamabi moosi ma nde ayiluu kwaa baata ba we ba ngira ba bali ku Yeruselemi. ");
INSERT INTO iyx_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Tumake nde ma ayiri kuni ku Damaseko, na muswa wu banguu ba bangaanga ba Nziaambi bahi nde mu ukaanga boosi ba bali mu ukuundu mu kuumbu a we.» ");
INSERT INTO iyx_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ka Pfumu aleeli kwaa nde: «Yene! Muutu wuu li isialili ki me nasoolo, mu uyaabisa kuumbu a me kwa bifuumbu na mitini mia bo, na kwa baata ba Iseraeli. ");
INSERT INTO iyx_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Me sa mweese nde me makulu, moosi ma nde afwaana umono pasi, mu ndaa kuumbu a me.» ");
INSERT INTO iyx_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Tumake, Anania ayeni. Bu nde atoori, akoti mu nzo, anaayi Sawuli mioo aleeli: «Sawuli mwaana a nguu a me, Pfumu Yiisu wamonii kwaa we mu kuulu yi we beeri ayiri, ni nde tsindii me paa we bwamono, na we luulu mu Muheebili wa Ngira.» ");
INSERT INTO iyx_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Mu taanga dina dii, bisii bia weti makala ma batswi, bia matii mu misi mia nde, na nde abwimono. Nde atemini na aholi libootuu. ");
INSERT INTO iyx_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Bu amani udia, nde abayi mifuri. Sawuli alabisi mwaana biluumbu na miyii miali ku Damaseko. ");
INSERT INTO iyx_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nhaa-na-tsi, nde abaandii uyiisi mu manzo ma makutunu ma Bayuudayo ti Yiisu ni Mwaana a Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Boosi bakiyuu nde, bakimii, baleeli: «Buni? A muutu wu pe wakiyene adwaanisa, baa bakikuundu mu kuumbu a Yiisu ku Yeruselemi? Nha ayiri nde nha, a ku ukaanga na ubiti bo nha kulu a banguu ba bangaanga ba Nziaambi pe?» ");
INSERT INTO iyx_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sawuli akimweese mu ngwanya kwaa baata ti Yiisu ni Mesiya. Nziisili a nde yakuli na yavuli mu litu na nziisili a Bayuudayo ba ku Damaseko. Ni mu buu, a babwi baa mia uleele nha kulu a nde pe. ");
INSERT INTO iyx_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Biluumbu bialaa bu bialabii, Bayuudayo bayuhisini mu uholo kesili ya udusu nde. ");
INSERT INTO iyx_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ka Sawuli ayaabi mapfu-pfundu ma Bayuudayo, ti bo bakikebe minywa mia ngaanda paa bamudusu. ");
INSERT INTO iyx_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Butsuu bu batoori, miyii mia Sawuli miamuholi, miamukotisi mutso itungu, miasutili nde ku mbisi a ibaa kia ngaanda. ");
INSERT INTO iyx_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Bu nde atoori ku Yeruselemi, Sawuli asiayi mu uvuutunu na kaba la miyii. Ka bo boosi bali na boomo ba nde, mu ndaa a baki sa imiini pe ti ngwanya nde ka muyii. ");
INSERT INTO iyx_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ka muutu moosi wa kuumbu Barnaba wamuholi, wamubiti kwaa batumu. Na wababiindili buni, Sawuli abwaanini na Pfumu mu kuulu, buni Pfumu atsuuyi kwaa nde, na buni ku Damaseko nde ayiisi mu ilimbisi mu kuumbu a Yiisu. ");
INSERT INTO iyx_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Umatuu mu taanga dii, Sawuli akidieenge mu bunyanga boosi na batumu mutso Yeruselemi. Nde akiyiisi mu ibaala kioosi mu kuumbu a Pfumu. ");
INSERT INTO iyx_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nde akitsuu na akisa ka paa na Bayuudayo bakitsuu ndaa ya basi Eleene, ka bo bakisaa udusu nde. ");
INSERT INTO iyx_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Bu baana ba nguu bayaabi buu, babiti Sawuli ku ngaanda ya Sezare, na nha mbisi bamutsindii ku ngaanda ya Tarasi. ");
INSERT INTO iyx_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Libuundu lali mu iyeenge, mu itinini kia Yuuda, kia Ngalili na kia Samaria. Lo lakikulu mu imiini na lakidiaata mu likiinzi la Pfumu, na lo lakifunu mu libaasila la Muheebili wa Ngira. ");
INSERT INTO iyx_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Bu Peetero akidieenge mu bitinini bii bioosi, nde ayeni ka kwaa bangaa imiini bakidiaala ku ngaanda ya Lida. ");
INSERT INTO iyx_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Kuu nde amoni muutu wa kuumbu Ene, wa ikata ala nha yulu a ikala, mutsitsi a bilimi pwoombo. ");
INSERT INTO iyx_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Peetero aleeli kwaa nde: «Ene, Yiisu Kristo beelisi we! Temene kutu ikala kia we.» Nhaa na nhaa nde atemini. ");
INSERT INTO iyx_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Basi Lida na basi Saroni bo boosi bamumoni, bakiingili mayele, na basobi ndiaatili mu ndaa ukiinzi Pfumu. ");
INSERT INTO iyx_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Mukaasa mosi mu ngaanda ya Yopi, nde ali muyii, kuumbu a nde Tabita, mambiindili «Dorkase», so a buu pe «Tsietsi». Nde ali na biyiluu bi bibwe, na akiha libaasila kwaa bawele. ");
INSERT INTO iyx_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mu biluumbu bii nde abwi ubeele na akwi. Bayobisi mvuumbi, na basuusi yo mu itsuru kia ku yulu a nzo. ");
INSERT INTO iyx_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Miyii bu miayuyi ti Peetero ali ku Lida yili nha peembi a Yopi, batsindii baata boolo mu upele nde, bo baleeli: «Kolokolo a we, yiri mawasa kwaa bisi!» ");
INSERT INTO iyx_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Peetero atemini, ayiri na bo. Bu atoori, bamuhaatisi ku itsuru kia ku yulu a nzo. Bakwiili boosi baswesii kwaa nde mu ulili. Bamweesi nde bikutu na biyungu bi Dorkase akituungu, bu nde ali keni moonyi. ");
INSERT INTO iyx_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Peetero apalisi bo boosi ku mbari, bu atsukini, akuundi, tumake asieetii kwali mvuumbi, na aleeli: «Tabita, temene!» Tabita adibili misi, bu amoni Peetero, nde adiaali. ");
INSERT INTO iyx_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Peetero akaangi nde mu koo, na atemisi nde. Peetero ati bangaa imiini na bakwiili, nde amweesi Tabita kwaa bo bu ali ka musii. ");
INSERT INTO iyx_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ndaa yii yayabini mu ngaanda ya Yopi yoosi, na imiini kia babalayi kia meni miaanzi mu Pfumu. ");
INSERT INTO iyx_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Peetero adiaali biluumbu bialaa ku Yopi, ku nzo a Simooni wali musiali a mikaanda mia banyama. ");
INSERT INTO iyx_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kwali mu ngaanda ya Sezare, na muutu mosi kuumbu a nde Koreneyi, mukuutu a kaba la masodaare libakita kuumbu «kaba la basi Italia». ");
INSERT INTO iyx_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Nde ali muutu wa libweeye, na akikiinzi Nziaambi na kaanda la nde loosi. Nde akiha libaasila kwaa bawele ba Bayuudayo, na akikuundu Nziaambi mu taanga dioosi. ");
INSERT INTO iyx_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Iluumbu imoosi, mu nguungu ya matata ku mbisi a nzanga, nde abayi monini: Tumu a Nziaambi akoti kwaa nde na wamuleeli: «Koreneyi!». ");
INSERT INTO iyx_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Nde atali nde isooso kutso boomo, na wamuleeli: «Ki ndaa Pfumu?» Tumu wamuvutili: «Likuundu la we na libaasila li we li mu ubaaha kwaa bawele, bimaato nha kulu a Nziaambi, na nde libili moonyi mu bio. ");
INSERT INTO iyx_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Mu taanga di, tsinduu baata ku ngaanda ya Yopi na tumusu Simooni wu bubaata Peetero. ");
INSERT INTO iyx_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nde li ku nzo a Simooni wa musiali a mikaanda mia banyama, na nzo yili mu mukoo a mubu.» ");
INSERT INTO iyx_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Bu tumu a Nziaambi wakitsuu kwaa nde ayeni, Koreneyi ati mabooyi ma nde moolo mbili, na lisodaare la nde la mutimi, wali na likiinzi la Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Bu amani uyaabisa kwaa bo moosi ma tumu a Nziaambi aleeli, nde wabatsindii ku Yopi. ");
INSERT INTO iyx_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Iluumbu kia duki, bu bali mu kuulu na baki besene na ngaanda ya Yopi, Peetero ahaati ku yulu a nzo mu ukuundu Nziaambi, ku bele a nguungu ya nzanga. ");
INSERT INTO iyx_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nde akoli nzala na asiayi udia. Mu taanga di bakilaamba nde biloo, Nziaambi ahi nde monini. ");
INSERT INTO iyx_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nde amoni yula bwaasi na iloo imosi kiafwaanina na tsaanda yi nene yi bakaanga mu matoso mo mana, yakikulunu na yakisutuu natee nha tsi. ");
INSERT INTO iyx_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Kutso yo kwali na bifuumbu bia banyama bialaa: banyama ba miili mina, na ba makala bali mu ukoo moonyo na banyunyi bali mu uyene mu yula. ");
INSERT INTO iyx_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ndaa mosi yaleeli kwaa nde: «Peetero! Temene, dusu we dia!» ");
INSERT INTO iyx_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Peetero avutili: «Ngori, Pfumu! Me kaala a nibaadia pe biloo bi basa ngiri na biasumuu!» ");
INSERT INTO iyx_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ndaa yabwileele kwaa nde: «Bi Nziaambi atsieemese, we muswa pe mu umono ti bio biasumuu.» ");
INSERT INTO iyx_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Buu bwamonii mbala tata, na nha mbisi nhaa, iloo ki kiahaati ku yula. ");
INSERT INTO iyx_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Peetero bu akitsimi mbiindila monini yi, nde abayi mu taanga dii ka baata bakimi batoori nha munywa a nzo. Baata baa ba Koreneyi atsindii mu ufuulu kuli nzo a Simooni. ");
INSERT INTO iyx_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Bo bateeri bangaa nzo, na bafuuli mbiiti Simooni wu bubaata Peetero kuu ubaadiaala. ");
INSERT INTO iyx_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Peetero bu ali keni mu utsimi mundaa a monini, Muheebili wa Ngira aleeli kwaa nde: «Mono, babaala batata bali mu usaa we. ");
INSERT INTO iyx_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Temene, sutuu na yene na bo kwahele a ukenge, mu ndaa ti me tsindii bo.» ");
INSERT INTO iyx_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Peetero asutii, abwaani bo na aleeli: «Me ni muutu wu beni dili mu usaa. Ki ndaa yibeyi beni kuni?» ");
INSERT INTO iyx_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bo bavutuli: «Bisi batsindii kwa Koreneyi, mukuutu a masodaare, muutu wa libweeye na likiinzi la Nziaambi. Na kaanda loosi la Bayuudayo lili mu uta imbaangi ki ibwe mu nde. Tumu wa Ngira aleeli kwaa Koreneyi mu uloombo we mu uyene ku nzo a nde, paa nde ayuu mandaa ma we uleele kwaa nde.» ");
INSERT INTO iyx_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Peetero ayaki bo na wabalayi mbuu ya ula tolo. Bukia-ngwaali, nde atemini, na ayeni na bo, na baana ba nguu bakimi ba ku Yopi bayeni na nde itwaari. ");
INSERT INTO iyx_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Iluumbu kiaduki, nde atoori ku Sezare. Koreneyi akikebe bo, na kaanda la nde, na bambaayi ba nde ba mutimi. ");
INSERT INTO iyx_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Peetero bu atoori, Koreneyi ayibwaana nde, abaandini, atsukini na abwi nha miili mia Peetero, mu uha nde likiinzi. ");
INSERT INTO iyx_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ka Peetero wamutemisi na wamuleeli: «Temene! Me ka ndi muutu weti we.» ");
INSERT INTO iyx_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Bu akiyolo na Koreneyi, nde akoti mu nzo, na amoni baata balaa bakukunu. ");
INSERT INTO iyx_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Nde aleeli kwaa bo: «Beni diayaaba ti balii kwaa bisi a beni Bayuudayo mu uba itwaari so a buu pe mu ukoto mu nzo a wuu uli a Muyuudayo pe. Ka Nziaambi amweesi kwaa me ti abwafwaana pe mu uleele kwaa muutu ti nde asumuu so a buu pe nde na mviindi. ");
INSERT INTO iyx_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ni mu buu me nziri kwahele a ukenge, mu taanga di beni diatsinduu muutu mu uya saa me. Mu ndaa yii, me na nzala uyaaba mu ki toono beni ditumisi me.» ");
INSERT INTO iyx_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Koreneyi aleeli: «Umatuu biluumbu bina, me naba mu ukuundu ku nzo a me, mu nguungu ya matata nha mbisi a nzanga. Itsundu-a-tsundu, muutu walwaata bikutu bili mu ungeyene moniaangi kwaa me, ");
INSERT INTO iyx_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","na leeli: “Koreneyi, Nziaambi yuyi likuundu la we. Na nde libili moonyi mu libaasila li we li mu uha kwaa bawele. ");
INSERT INTO iyx_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Mu taanga di, tsinduu muutu ku Yopi, na tumusu Simooni wu bubaata Peetero. Nde li ku nzo a Simooni wa musiali a mikaanda mia banyama, na nzo a nde yili mu mukoo a mubu.” ");
INSERT INTO iyx_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Me tsindii muutu mawasa-mawasa kwaa we, na we siiri bubwe bu we yiri. Mu taanga di bisi boosi dili nha kulu a Nziaambi, mu uyuu moosi ma Pfumu atumu we mu uleele.» ");
INSERT INTO iyx_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Bu abaandii utsuu, Peetero aleeli: «Mu ngwanya, me maa yaaba ti Nziaambi a ubaasa pe lisobuso nha kati a baata, ");
INSERT INTO iyx_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ka mu pasi ifuumbu, wu uba na likiinzi la Nziaambi, na wu usalila libweeye, sa amonuu wu mubwe nha kulu a Nde. ");
INSERT INTO iyx_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nde atsindii mandaa ma Nde kwaa basi Iseraeli, mu uyaabisa kwaa bo Ndaa Yimbwe ya iyeenge mu Yiisu Kristo: Ni Nde uli Pfumu a boosi. ");
INSERT INTO iyx_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Beni diayaaba mandaa ma mayilimi mu Yuuda yoosi, bu mabaandii ku Ngalili ku mbisi a libootuu layaabisi Yowani. ");
INSERT INTO iyx_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Beni diayaaba, buni Nziaambi abiaalisi Yiisu musi Nazareti mu Muheebili wa Ngira na mu litu loosi. Muu mu nde akilabuu, akiyiluu ma mabwe, na akibeelese baata boosi ba bakangama kwaa Saatina. Ka Nziaambi ali na Nde. ");
INSERT INTO iyx_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Bisi dili bambaangi mu mioosi mi Nde ayilii mu tsi a Bayuudayo na ku Yeruselemi. Bo badusi nde, bu bamukomi nha muti wa kuruwa. ");
INSERT INTO iyx_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Nziaambi wamusiimbili mu iluumbu kia bitata. Nde wamuhi muswa wa umonuu, ");
INSERT INTO iyx_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","a kwaa baata boosi pe, ka ndila kwaa bambaangi ba Nziaambi ba akwisoolo, kwaa bisi ba diadiiri na dianywiiri itwaari na Nde, nha mbisi a tsimbilili a Nde mu babakwa, ");
INSERT INTO iyx_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nde wadihi litumu mu uyaabisa kwaa baata na uta imbaangi ti ni Nde wu Nziaambi abiaalisi mu ufuundusu ba misii na ba bakwa. ");
INSERT INTO iyx_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Mibili mioosi mili mu ubaata Nde imbaangi: pasi wu usa imiini mu Yiisu, holi nyaalili a masumu mu kuumbu a Nde.» ");
INSERT INTO iyx_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Peetero bu ali keni mu utsuu, Muheebili wa Ngira abwiilili nha yulu a boosi babakiyuu Ndaa a Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Bangaa imiini boosi mu kaba la Bayuudayo, ba bayiri na Peetero bakimii, mu ndaa bamoni ti bungori ba Muheebili wa Ngira bayitili ka nha yulu a babali a Bayuudayo pe. ");
INSERT INTO iyx_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ka bo bakiyuu bu bakitsuu mu mandaa ma bumweenyi na bu bakibili bunene ba Nziaambi. Ka Peetero abwileele: ");
INSERT INTO iyx_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Buni! Utuu ulii libootuu kwaa baata, ba bamaayaka Muheebili wa Ngira weti bu bisi ka diayaki?» ");
INSERT INTO iyx_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nde ahi muswa paa bo baholo libootuu mu kuumbu a Yiisu Kristo. Tumake, bo baloombi kwaa nde mu udiaala mwaana biluumbu na bo. ");
INSERT INTO iyx_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Batumu na baana ba nguu babali ku itinini kia Yuuda, bayuyi ti bangooyi ka bamaasiingi mandaa ma Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Mu taanga di Peetero ayiri avutuu ku Yeruselemi, Bayuudayo babasa imiini mu Yiisu bakaamisi nde, ");
INSERT INTO iyx_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","baleeli: «We maakoto mu manzo ma bangooyi, baata babali a Bayuudayo pe, na we diiri itwaari na bo!» ");
INSERT INTO iyx_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ninha, Peetero ayali bo mutata weti bu mioosi miayooyi, nde aleeli diyuu bubwe: ");
INSERT INTO iyx_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Bu na li ku ngaanda a Yopi mu likuundu, kutso ibala kia muheebili me nabayi monini: iloo imosi kiasutii, weti tsaanda yinene, yi bakaanga mu matoso mo mana, yamati mu yula, yatoori natee nha me nali. ");
INSERT INTO iyx_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Bu nakitala iloo kii isooso, me namoni: banyama ba miili mina, na ba ku musiti na ba makala bali mu ukoo moonyo na banyunyi bali mu uyene mu yula. ");
INSERT INTO iyx_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nayuyi ndaa yaleeli kwaa me: “Temene, Peetero, dusu na dia bio!” ");
INSERT INTO iyx_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ka me navutili: “Ngori Pfumu! Mundaa kiasumuu, so a buu pe, iloo ki basa ngiri so imosi a ibaakoto mu munywa a me pe.” ");
INSERT INTO iyx_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ndaa yabwiyuunu mu yula mu mbala ya dioolo: “Bi Nziaambi atsieemese, we muswa pe mu umono ti bio biasumuu!” ");
INSERT INTO iyx_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Buu bwamonii mbala tata, na nha mbisi a nhaa iloo kii kiahaati ku yula. ");
INSERT INTO iyx_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Mawasa-mawasa baata batata, bamati ku ngaanda ya Sezare, bayiri ku nzo yi bisi diali, batsindii bo kwaa me. ");
INSERT INTO iyx_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Muheebili wa Ngira aleeli kwaa me, me yene itwaari na bo. Kwahele a ukenge, me nayeni na baana ba nguu basamina babali na me nhaa. Bu diatoori, bisi boosi diakoti mu nzo a Koreneyi. ");
INSERT INTO iyx_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Nde wadiyaabisi buni tumu a Nziaambi amonii kwaa nde mutso nzo na aleeli: “Tsinduu baata ku ngaanda ya Yopi, na tumusu Simooni wu bubaata Peetero. ");
INSERT INTO iyx_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nde sa aleele we mandaa ma we uyobuu, we na baata ba nzo a we yoosi.” ");
INSERT INTO iyx_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Me bu nabaandii utsuu, Muheebili wa Ngira abwi nha yula bo, weti bu akwibwiilili bisi. ");
INSERT INTO iyx_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ni mu buu, me nalibili moonyi mu mandaa ma Pfumu wadileeli: “Yowani abootii mu maamba, ka beni sa badibootuu mu Muheebili wa Ngira.” ");
INSERT INTO iyx_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Bu ili ti Nziaambi ahi bungori kwaa bo bangooyi, iteesi imosi weti kwaa bisi badiasa imiini mu Pfumu Yiisu Kristo, ka me ni na mu utuu ukabisa litoono la Nziaambi?» ");
INSERT INTO iyx_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Bu Bayuudayo babasa imiini bamani na uyuu buu, bawuri na pii, babili Nziaambi baleeli: «Ee, Nziaambi maaha ka kwaa bangooyi pwaasi ya kiingili a mayele yi ibiti bo ku moonyi wa ngwanya.» ");
INSERT INTO iyx_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ku mbisi a mamalabii, boosi batsiaamii mu mbingisi yabeyi likwa la Estefano. Bayoyi natee ku itinini kia Fenisi, ku iduku kia Kipiria, na ku ngaanda ya Antioki, kwahele a uyiisi ndaa a Nziaambi kwaa muutu, so a ndila kwaa Bayuudayo pe. ");
INSERT INTO iyx_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ka babamosi mu bo babasa imiini, ba ku Kipiria na ku Kireni, bayiri ku Antioki. Kuu, bo bayaabisi ndaa yimbwe ya Pfumu Yiisu kwaa bangooyi. ");
INSERT INTO iyx_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Litu la Pfumu labwiilili bo. Ni mu buu, litaanga la baata babasi imiini mu Pfumu na babasieetii kwaa nde, lafuni kwalaa. ");
INSERT INTO iyx_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ndaa yii yayuyini kwaa libuundu lali ku Yeruselemi. Ni mu buu, bo batsindii Barnaba ku Antioki. ");
INSERT INTO iyx_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nde bu atoori, amoni iteesi kia bweese ba Nziaambi mu bo. Ni mu buu, nde ayaangi na ahamisi bo boosi, mu ukangama mu Pfumu mu mutimi mosi. ");
INSERT INTO iyx_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnaba ali muutu wu mubwe, waluulu mu Muheebili wa Ngira na mu imiini. Mu ndaa yii koongi yalaa yasiingi Pfumu. ");
INSERT INTO iyx_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tumake, Barnaba ayeni ku ngaanda ya Tarasi mu uyasaa Sawuli. ");
INSERT INTO iyx_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Na bu wamumoni, nde wamubiti ku Antioki. Bo balabisi ilimi kia ibiimbili, itwaari nha kati a libuundu lii, bo bayiisi baata balaa. Ni ku Antioki, mu mbala ya tsiomi bati miyii mia pfumu Yiisu ti bangaa Kristo. ");
INSERT INTO iyx_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mu biluumbu bii, kaba la mibili lamati ku Yeruselemi mu uyene ku Antioki. ");
INSERT INTO iyx_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Mosi mu mibili mii, wa kuumbu Angabusi atemini, na ayaabisi mutso iteesi kia Muheebili wa Ngira ti, sa uba na nzala yinene mu tsi yoosi yili baata. Nzala me yamonii mu taanga dia Kolodo wali mutini nha yulu a mitini. ");
INSERT INTO iyx_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ni mu buu, miyii miaholi kesili, weti buli mbahili a muutu-muutu, mu utsinduu libaasila kwaa baana ba nguu bali ku tsi ya Yuuda. ");
INSERT INTO iyx_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ee, bayilii buu, batsindii libaasila mu mioo mia Barnaba na Sawuli kwaa bakuutu ba babaala ba ku Yeruselemi. ");
INSERT INTO iyx_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Mu taanga dii, mutini Erode abaandii ukwaamisa babamosi mu ba libuundu. ");
INSERT INTO iyx_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Nde atumi badusu mu mukasa, Yaki, mwaana nguu a Yowani. ");
INSERT INTO iyx_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Bu Erode amoni ti Bayuudayo bali na kinyi mu ndaa yii, nde aholi kesili ya ukaanga ka Peetero. Nde ayilii buu mu taanga dia biluumbu bia mapa ma bahele ufunusu. ");
INSERT INTO iyx_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Erode akaangi Peetero, wamuloosi mu perese, na ahi litumu kwaa makaba mana ma masodaare mu ukebe nde. Aholi kesili ti nha mbisi a mukuungi wa Paaka, nde sa wamufuundusu nha kulu a baata. ");
INSERT INTO iyx_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Peetero ali bakebe mu nzo a perese, ka libuundu lakihama mu ukuundu Nziaambi mundaa nde. ");
INSERT INTO iyx_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Mu butsuu batswaamini iluumbu ki Erode aholi kesili, bu ali na tsimi ya ufuundusu nde nha kulu a baata, Peetero ali ala tolo nha kati a masodaare moolo. Bakutu nde mikuru mioolo mia bitali mu mioo. Na nha munywa a nzo a perese basuusi bakebi. ");
INSERT INTO iyx_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Itsundu-a-tsundu tumu a Pfumu amonii na liyalila layalisi itsuru ya nzo a perese. Tumu asiimbili Peetero bu ateti nde mu libaanzi na aleeli: «Temene mu mawasa!» Mikuru miabitali miamatii mu mioo mia nde na miabwi. ");
INSERT INTO iyx_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Nha mbisi a nhaa, tumu a Nziaambi aleeli kwaa nde: «Lwaata ikutu kia we, kutu kobo a we, lwaata bikoori bia we ka.» Nde ayilii buu. Tumu abwileele kwaa nde: «Lwaata iyungu kia we na duku me.» ");
INSERT INTO iyx_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Peetero apali mu perese na aduki tumu. Nde a akiyaaba pe ti mi tumu akiyuluu ali mia ngwanya, ka nde atsimi ti mii mioosi ali monini. ");
INSERT INTO iyx_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Bu baluti kaba latsiomi la bakebi, tumake lamoolo, batoori nha munywa a nzo wa bitali wuli mu uha kuulu ya upala ku mbari a nzo a perese, mu ukoto mu ngaanda. Munywa a nzo wuu, mu inde makulu adibini nha kulu a bo. Bo bapali na baswesii nha peembi a kuulu, na nhaa na nhaa, tumu asiisi Peetero. ");
INSERT INTO iyx_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ni buu, Peetero avutii mu imuutu kia nde, aleeli: «Mu taanga di, me maayaaba mu ngwanya ti: Pfumu atsinduu tumu a nde. Na nde maakuulu me mu mioo mia Erode, na mu bubi boosi ba Bayuudayo bali na tsimi ya uyiluu mu me.» ");
INSERT INTO iyx_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Bu amani uyaaba ndaa, nde ayeni ku nzo a Mari, nguu a Yowani wu bubaata kuumbu Malako. Baata ba balayi ali bakukini kuu na bakikuundu Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Bu akombiti nha munywa a nzo, booyi la mukaasa kuumbu a nde Roode, asweesii mu udibili nzo. ");
INSERT INTO iyx_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nde ayaabi muniingi a ndaa a Peetero. Na kutso kinyi yoosi, nde a adibili nzo pe. Nde adumi tiini mu uyayaabisa ti: «Ni Peetero li mukomboto.» ");
INSERT INTO iyx_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Bo baleeli kwaa nde: «We li lari!» Ka nde ahami mu uta imbaangi ti: «Ngwanya, ni Peetero.» Bo babisi, baleeli: «Ngori! Wuu tumu a Nziaambi wuli mu ukebe nde!» ");
INSERT INTO iyx_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ka Peetero ahami mu ukomboto, natee bu badibili nzo. Mu taanga di bo badibili munywa a nzo, bo bakimii bu bamumoni. ");
INSERT INTO iyx_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Peetero wabawurisi bu anaayi koo kia nde nha munywa. Nde wabayaabisi buni Pfumu wamupalisi mu nzo a perese na abwileele: «Diyaabisa buu kwaa Yaakobi na baana ba nguu bakimi.» Bu apali, ayeni ku peembi kimi. ");
INSERT INTO iyx_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Busi bu bakieeri, nyingi-nyingi yabwi nha kati a masodaare. Bafulisini: «Peetero, mima abwaani na mio?» ");
INSERT INTO iyx_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Erode atumi ti basaa Peetero, ka a bamusolili pe. Nde atumi ti bafuulu masodaare: «Kuni Peetero ali?» Na nha mbisi, ahi litumu la udusu masodaare maa. Tumake Erode asiisi itinini kia Yuuda na ayeni ku ngaanda ya Sezare. Nde adiaali kuu mu mwaana taanga hoolo. ");
INSERT INTO iyx_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Mutini Erode ali na itaata na basi Tiro na basi Sidoni. Bia udia ku mangaanda ma Tiro na Sidoni biakimata ku tsi a Erode. Mundaa yi, bo baloombi uvuutu iyeenge na nde. Ni mu buu basi Tiro na basi Sidoni baloombi libaasili kwaa Balositi, mukebi a itsuru kia nzo kia mutini. Mu itwaari, bo bayimono Erode paa bavuutu iyeenge. ");
INSERT INTO iyx_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Mu iluumbu ki bayesini, Erode, bu alwaati bikutu bia ipfumu adiaali nha mbata a ipfumu, na atsuuyi kwaa bo nha kula a baata boosi. ");
INSERT INTO iyx_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Baata bakiloo: «Wuu na wu a muutu pe li mu utsuu, ka inzia-nziaambi!» ");
INSERT INTO iyx_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Nhaa na nhaa, Tumu a Pfumu ateti Erode, mundaa ti nde asiayi uholo likiinzi lafwaana ndila kwaa Nziaambi. Nde akwiiri, na batungu bamudiiri. ");
INSERT INTO iyx_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Bunu, mandaa ma Nziaambi mayabini kwalaa. ");
INSERT INTO iyx_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnaba na Sawuli bu bamani isala kia bo ku Yeruselemi, bavutii, na babiti Yowani wu bubaata Malako. ");
INSERT INTO iyx_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Mu libuundu la ku Antioki, kwali na mibili na miyiisi: Barnaba, Simeoni wu bubaata «mu piindi», Lukio wa musi Kireni, Manayi mbaayi a Erode wa bungebe, na Sawuli. ");
INSERT INTO iyx_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Bu bali mu ukuundu Pfumu Nziaambi na udii mutuutu, Muheebili wa Ngira aleeli: «Ditakala nha peembi Barnaba na Sawuli ba me nasoolo mu isala kia me.» ");
INSERT INTO iyx_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Bu bamani udii mutuutu na ukuundu, banayi bo mioo mu uha bolisieeme na banyaali bo bayene. ");
INSERT INTO iyx_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Muheebili wa Ngira bu wabatsindii, bo basutii ku ngaanda ya Selesi, na bakoti mu bootu, bo bayeni ku iduku kia Kipiria. ");
INSERT INTO iyx_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Bu batoori ku Salamini, bo bayaabisi ndaa a Nziaambi mu manzo ma makutunu ma Bayuudayo. Yowani ali na bo mu uha libaasila. ");
INSERT INTO iyx_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Nha mbisi, bu basiabii iduku kia Pafos, bo bamoni Muyuudayo mosi ngaa paanda. Nde ali mubili wa pia, kuumbu a nde Bari-Yiisu. ");
INSERT INTO iyx_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Nde ali kwaa mutumi a iduku wa kuumbu Seringi Pawulusi, muutu ngaa mayele. Nde atumisi Barnaba na Sawuli mu nzala a uyuu mandaa ma Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ngaa paanda me, wuli kuumbu a nde Elima, adwaanisi Barnaba na Sawuli, paa akoonoso mutumi mu usa imiini mu Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ka mono, Sawuli wu bubaata ka Pawuli, waluulu mu Muheebili wa Ngira, wamutali isooso, ");
INSERT INTO iyx_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","aleeli: «We li mwaana a Saatina, muutu waluulu mu pia na mukwibi, mutaata a mandaa ma libweeye. Ki taanga we unyaala utekese makuulu ma Pfumu ma mali masuungunu? ");
INSERT INTO iyx_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ka mono, mu taanga di: koo kia Pfumu ika nha yulu a we. We sa ba ingima-ngimi, na a ubwa mono pe liyalila la tari mu mwaana taanga hoolo.» Nhaa na nhaa pimisi diabwiilili Elima, adieengili na asiayi koo ki ibaasila nde. ");
INSERT INTO iyx_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Bu mutumi amoni mamayilimi, nde asi imiini mu Pfumu, mundaa mutimi a nde anemini mu nziisili. ");
INSERT INTO iyx_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Bu bakoti mu bootu ku ngaanda ya Pafos, Pawuli na babali na nde batoori ku ngaanda ya Peringi, ya ku itinini kia ku Pamfili. Yowani wabasiisi, na avutii ku Yeruselemi. ");
INSERT INTO iyx_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Bo ka basiisi ngaanda ya Peringi, batoori ku ngaanda ya Antioki ku itinini kia Pisidi. Bo bakoti mu nzo a makutunu ma Bayuudayo, mu iluumbu kia Saba, na badiaali. ");
INSERT INTO iyx_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Nha mbisi a taangili a Mikele na mibili, bakuutu ba nzo a makutunu ma Bayuudayo batsindii mukeenzi kwaa bo: «Baana ba nguu, so dili na ndaa ya pamisi ya uleele kwaa baata, ditsuu.» ");
INSERT INTO iyx_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pawuli, atemini na anaangili koo, mu usaa utsuu: «Baata ba Iseraeli na beni badili mu ubatila Nziaambi boomo, diyuu! ");
INSERT INTO iyx_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nziaambi a baata ba Iseraeli, asooli bataayi ba bisi. Na afunisi koongi yii, bu yo yali mu bumweenyi ku tsi ya Ngipiti. Na mu litu la koo kia nde, Nziaambi wabapalisi mu yo. ");
INSERT INTO iyx_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Nde wababaasili mu bilimi helape maku mana mutso tsi ya hele a baata. ");
INSERT INTO iyx_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Na bu afuusi bifuumbu tsaamba bia baata mu tsi a Kaana. Nde ahi tsi yii mukobo kwaa baata ba nde. ");
INSERT INTO iyx_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Mandaa maa moosi madiingi helape makama mana na maku mataana ma bilimi.» «Na nha mbisi, nde wabahi banzioonzi natee mu taanga dia mubili Samweli. ");
INSERT INTO iyx_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Tumake, bo baloombi ti babiaalisa mutini nha kati a bo, na Nziaambi wabahi Sawuli, mwaana a Kiisi, baala la mu ifuumbu kia Benyamini, watumi bo mu bilimi maku mana. ");
INSERT INTO iyx_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Bu amaasi Sawuli, nde wabahi mutini Daavidi, wu Nde ati imbaangi ki: “Me maasololo Daavidi, mwaana a Yesi, muutu wu li mu uha mutimi a me kinyi, nde sa ayiluu weti buli manzala ma me.” ");
INSERT INTO iyx_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Mu ifuumbu kia mutini Daavidi, Nziaambi atsindii Yiisu wu uvuusu baata ba Iseraeli weti bwali lilasini la nde. ");
INSERT INTO iyx_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Tswaamina a nzirili a Yiisu na mbaandila isala kia nde, Yowani Mubootii ayaabisi kwaa ifuumbu kioosi kia Iseraeli, ti bafwaana usobo ndiaatili na ukiingili mayele ma bo. Nha mbisi baholo libootuu, paa bavutuu kwaa Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yowani Mubootii ku manini a isala kia nde, akileele: “Mu matsimi ma beni, me na ndi? Me a ndi wuu wu beni dili mu ukebe pe! Ka nde li mu uyira nha mbisi a me, na me a nafwaana pe mu unyangila misiingi mia bikoori bia nde.”» ");
INSERT INTO iyx_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«Baana ba nguu ba me, baata ba ifuumbu imosi kia Abraami, na beni bakimi ba dili mu uha Nziaambi likiinzi, kwaa bisi a beni batsindii ndaa yi ya liyobolo. ");
INSERT INTO iyx_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ka basi Yeruselemi na bapfumu ba bo a babwilibili moonyi pe ti Yiisu ayiri ku bo uyobolo. Na bo a bayaabi pe mambiindili ma mandaa ma mibili, ma bali mu utaanga mu pasi iluumbu kia puumini. Ka bo bakuusi mandaa maa bu bamufuundisi. ");
INSERT INTO iyx_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Bo baloombi kwaa Pilato mu udusu nde, bunu a babayi mu nde toono ya uhoolo nde kesili ya likwa pe. ");
INSERT INTO iyx_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Bu bamani ukuusu moosi ma basonuu mundaa nde, bamusutili nha kuruwa, na bamusuusi mutso ngili. ");
INSERT INTO iyx_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ka Nziaambi wamusiimbili mu babakwa. ");
INSERT INTO iyx_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Mu biluumbu bialaa, Yiisu amonii kwaa baa babayeni na nde itwaari, umatuu ku Ngalili natee ku Yeruselemi. Bo bali bambaangi ba nde nha kulu a baata ba Iseraeli. ");
INSERT INTO iyx_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Na bisi, dili mu uyaabisa beni Ndaa Yimbwe: yili lilasina li Nziaambi asiiri kwaa bataayi ba bisi. ");
INSERT INTO iyx_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Nziaambi kuhisi lilasini li kwaa bisi, baana ba bo, bu asiimbili Yiisu mu likwa. Basonuu mu mukaanda wa Mikuunga mu kiiti kia bioolo: “We ni Mwaana a me, lolo li, me ka taayi kwaa we.” ");
INSERT INTO iyx_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Nziaambi ayaabisi ti nde sa asiimbili Yiisu mu babakwa, paa nyutu a nde yinyaala ubolo, buu ni bu aleeli: “Me sa nadiha lisieeme la ngira, li nadilasini kwaa Daavidi, lo lili la ngwanya.” ");
INSERT INTO iyx_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ni buu, nde ali mu uleele ka, mu kiiti ikimi: “We a unyaala pe nyutu a wa we wa ngira yikoto mu mbolili.” ");
INSERT INTO iyx_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Bu Daavidi amani usala mu isieende kia nde, weti bwali kesili a Nziaambi, nde akwi. Bamudii nha peembi a bataayi ba nde, na nyutu a nde yaboli. ");
INSERT INTO iyx_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Kasi nyutu a wuu, wu Nziaambi asiimbili mu likwa, a yamoni mbolili pe. ");
INSERT INTO iyx_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Baana ba nguu ba me, beni diafwaana uyaaba ti nyaalili a masumu, badiyaabisi yo mu Yiisu. Ka Mikele mia Mooso a miatuu pe ukitisi beni baata bafwaana nha kulu a Nziaambi. Ni mu buu, pasi nde wu usa imiini mu Yiisu, sa aholo nyalili a masumu ma nde moosi na sa ayobuu. ");
INSERT INTO iyx_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ni mu buu, disa mayele, paa ma maleeli mibili mahele ubwiilili beni: ");
INSERT INTO iyx_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“Ditala, beni ba ngaa liwaa, dikimuu na difuu! Ka me ni yiluu ndaa bu beni dikini moonyi, yi beni dihele usiingi mbii ti baleeli beni yo mu uleele!”» ");
INSERT INTO iyx_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pawuli na Barnaba bu bapali mu nzo a makutunu a Bayuudayo, ba baloombi mu ubwatsuu mu ndaa yii mu iluumbu kia puumini kikaayira. ");
INSERT INTO iyx_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Mvuutini bu yatsiaamii, Bayuudayo babalayi na baata bakimi bakangimi mu libuundu la Bayuudayo, baduki Pawuli na Barnaba. Bo babahamisi mu ukangama mu bweese ba Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Saba la duki, ngaanda yoosi yavuutini mu uyuu mandaa ma Pfumu. ");
INSERT INTO iyx_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Bayuudayo, bu bamoni makoongi ma baata, baluuli mu musoyi, mu bitari badwaanisi miakileele Pawuli. ");
INSERT INTO iyx_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ka Pawuli na Barnaba mu ilimbisi kioosi baleeli: «Aba bwafwaana ti ndaa a Nziaambi bakwayaabisa yo kwaa beni. Bu beni dibisi yo uholo, na bu beni dimoni beni bameme ti, beni a diafwaana pe mu ukoto mu moonyi wa bilimi na bilimi, mundaa yii, bisi dimaakiinguu kwaa bangooyi. ");
INSERT INTO iyx_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ka Pfumu wadihi litumu li: “Me nabiaalisi we mu uba liyalila la baata ba matsi makimi, mu ubiti liyobolo natee kwasuku toto.”» ");
INSERT INTO iyx_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Mu taanga di bangooyi bayuyi buu, bamoni kinyi, babili mandaa ma Pfumu. Na boosi ba bataasili mu uhoolo moonyi wa bilimi na bilimi, basi imiini mu Pfumu. ");
INSERT INTO iyx_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Mandaa ma Pfumu matsiaamii mu tsi yoosi. ");
INSERT INTO iyx_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ka bapfumu ba Bayuudayo batsindi bakaasa ba likiinzi bakikuundu Nziaambi na pfuundu a ikuutu kia ngaanda. Bo bakoti mu ubingisi Pawuli na Barnaba, natee bu bapalisi bo mu tsi a bo. ");
INSERT INTO iyx_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pawuli na Barnaba bakubili lifuundu la miili mia bo, mu ulibili bo mu mimibi mibayilii nha kulu a bo, na bayeni ku ngaanda ya Ikonio. ");
INSERT INTO iyx_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ka miyii miali ku Antioki mialuuli mu kinyi na mu Muheebili wa Ngira. ");
INSERT INTO iyx_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ku ngaanda ya Ikonio, Pawuli na Barnaba bakoti ka mu nzo a makutunu ma Bayuudayo, bo bayiisi koongi yinene ya Bayuudayo na basi Eleene. Mundaa a nziisili a bo, baata babalayi basi imiini mu Pfumu. ");
INSERT INTO iyx_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ka Bayuudayo, ba babisi usa imiini mu Pfumu, batsindi bangooyi mu uba na matsimi ma mabi mu baana ba nguu. ");
INSERT INTO iyx_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pawuli na Barnaba badiaali ku ngaanda yii, mwaana taanga dialaa. Bo batsuyi mu ndaa bweese ba Pfumu mu ilimbisi kialaa. Ni kuu, Pfumu Yiisu ahi bo lituu la usa bimaanga na biliimbi bialaa, mu uhamisa na umweese ti nziisili a bo yili ya ngwanya. ");
INSERT INTO iyx_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Mutso ngaanda, koongi yakabii: ba bamosi bayeni mu kaba la Bayuudayo, bana mu kaba la batumu. ");
INSERT INTO iyx_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Baba moosi mu Bayuudayo na bangooyi na bakuutu ba bo bakiyilimi mu umweese bo pasi na utete bo mamanya. ");
INSERT INTO iyx_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Bu Batumu bayaabi buu, bo babati ku itinini kia Likawonia, na bayisweeme ku ngaanda ya Lisitara na ya ku Derebe na mu mambuu madiengelele ma ngaanda maa. ");
INSERT INTO iyx_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Kuu bo bayiisi Ndaa Yimbwe. ");
INSERT INTO iyx_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ku ngaanda ya Lisitara, kwali na muutu mosi wali wabobo miili, nde ali ikata umata bu babutu nde na a akituu udiaata pe. Bu ali adiaala, ");
INSERT INTO iyx_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","nde akiyuu Pawuli mu utsuu. Pawuli atali nde isooso, na bu amoni ti nde ali na imiini mu uvuu, ");
INSERT INTO iyx_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","nde aleeli mu ndaa yinene: «Temene na suungunu!» Mbala mosi nde adumii, atemini na adiaati. ");
INSERT INTO iyx_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Bu bamoni ma Pawuli ayilii, makoongi maloyi mu ndaa a basi Likawonia: «Banziaambi bamaafwaanina na baata na bamaasutuu kwaa bisi!» ");
INSERT INTO iyx_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bo bateeri Barnaba mu kuumbu ya «Zewusi» na Pawuli «Erimesi», mundaa ti Pawuli ni nde wakitoosolo mandaa. ");
INSERT INTO iyx_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Nzo a nziaambi wa kuumbu Zewusi ali nha kotili a ngaanda. Ngaanga a nziaambi a Zewusi abeyi balumi ba bangoombo babadii bifulu, na asuusi bo nha munywa a lipaanga la ngaanda. Mu itwaari na koongi, nde ali atoono udusu bangoombo baa mu uha bungori ba diki kwaa ba tumu. ");
INSERT INTO iyx_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ka bu Pawuli na Barnaba bayuyi buu, bo bakaki bikutu bia bo, mu umweese ngebe na tsionyi dia bo na bakoti mu mawasa kutso koongi, mu uyene aloo: ");
INSERT INTO iyx_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Banduu ba me, mu ima dili mu uyiluu mandaa ma pili yii? Bisi ka dili baata weti beni! Bisi dili mu uyaabisa beni ndaa yimbwe, paa beni dinyaala mandaa mahele a ndutu, mu uswesuu kwaa Nziaambi wa moonyi wayiluu yula na tsi, mubu na bioosi bili mu bio. ");
INSERT INTO iyx_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Mu taanga dikulu, nde ahi muswa kwaa bifuumbu bioosi, mu uduku makuulu ma bo makulu. ");
INSERT INTO iyx_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ka bunu, mu umweese imbaangi kia nde, nde li mu uyiluu ma mabwe bu ali mu uha beni bamvulu ba mayula paa bikunu bia beni bimene, na beni dikukuu bio mutaanga diafwaana. Nde li mu uha beni bia udia, na uyaangisa mitimi mia beni.» ");
INSERT INTO iyx_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","So bu baleeli maa, bo a batuyi pe mu ukabisa matsimi ma baata, ma uha bo bungori. ");
INSERT INTO iyx_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ni mu buu Bayuudayo ba bamati ku Antioki na ku Ikonio bu bayiri, batsindi koongi mu uyiluu mamabi kwaa batumu. Bo bateti Pawuli mamanya, na bamukooyi ku mbari a ngaanda, bu bakitsimi ti maakwa. ");
INSERT INTO iyx_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ka miyii bu miamudiengilili, nde atemini na akoti mu ngaanda. Bukia ngwaali nde ayeni na Barnaba ku ngaanda ya Derebe. ");
INSERT INTO iyx_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pawuli na Barnaba bu bamani uyaabisa ndaa yimbwe kutso ngaanda ya Derebe babayi miyii mialaa. Bo bavutii ku ma ngaanda ma: Lisitara, Ikonio na Antioki ya ku Pisidi. ");
INSERT INTO iyx_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Bo bakihamisa na uha mifuri kwaa miyii mu ukangama kutso imiini, bu bakileele: «Bisi a beni diafwaana umono pasi dialaa mu ukoto mu Ipfumu kia Nziaambi.» ");
INSERT INTO iyx_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pawuli na Barnaba basooli bakuutu mu pasi libuundu. Bu bamani ukuundu Nziaambi na udii mutuutu, bo bayeelili bo kwaa Pfumu wuu wu bo basa imiini. ");
INSERT INTO iyx_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Tumake, bo batabi itinini kia Pisidi, na batoori ku itinini kia Pamfili. ");
INSERT INTO iyx_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Bu bamani uyiisi mandaa ma Nziaambi ku ngaanda ya Peringi, bo bayeni ku ngaanda ya Atalia. ");
INSERT INTO iyx_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Umatuu ku Atalia, bo bakoti mu bootu mu uyene ku Antioki, kuu ku bo baholi bweese ba Nziaambi, mu isala ki bo bamaakuusu. ");
INSERT INTO iyx_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Bu batoori, bakukii libuundu, na bayaabisi moosi ma Nziaambi ayilii itwaari na bo. Pawuli na Barnaba babiindili kwaa bo buni Nziaambi adibili kuulu yi bangooyi busa imiini mu nde. ");
INSERT INTO iyx_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Na bo badiaali kuu taanga dialaa na miyii mia ku Antioki. ");
INSERT INTO iyx_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Kaba la baata ba bamati ku tsi ya Yuuda batoori ku ngaanda ya Antioki, bakiyiisi baana ba nguu mbii bu: «So a bakesi pe beni na baana ba beni ba babaala, weti buli mikele mia Mooso, Nziaambi a uyobolo beni pe.» ");
INSERT INTO iyx_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pawuli na Barnaba batuli kaama la mifuri na bo mu ndaa yii. Nha mbisi, bo baholi kesili ti Pawuli, Barnaba na kaba la baata baa, bayene ku Yeruselemi paa batsuu mu ndaa yii, nha kulu a batumu na bakuutu. ");
INSERT INTO iyx_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Libuundu lahi kwaa bo libaasila lafwaana mu mudieenge. Bo balabii mu kuulu ya itinini kia Fenisi na kia Samaria, bo bakiyene ayaabisa buni bangooyi ba meni miaanzi mu Pfumu. Ndaa yi yahiiri kinyi yalaa kwaa baana ba nguu boosi. ");
INSERT INTO iyx_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Bu boboosi batoori ku Yeruselemi, baana ba nguu ba libuundu, batumu na bakuutu bayaki bo. Pawuli na Barnaba bayaabisi mi Nziaambi ayilii itwaari na bo. ");
INSERT INTO iyx_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Kaba la baata mu libuundu la Bafarisi babasi imiini mu Nziaambi, batemini na baleeli ti: «Toono ukese babali a Bayuudayo pe na uleele kwaa bo mu utumumu mikele mia Mooso.» ");
INSERT INTO iyx_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Batumu na bakuutu bavuutini mu ukengese ndaa yii. ");
INSERT INTO iyx_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ku mbisi a kaama la mifuri, Peetero atemini na wabaleeli: «Baana ba nguu, beni diayaaba ti umatuu belepe, Nziaambi asooli me nha kati a beni, paa me yaabisa Ndaa Yimbwe kwaa bangooyi bayuu na basa imiini. ");
INSERT INTO iyx_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Nziaambi wayaaba mitimi mia baata boosi, bu ahi bo Muheebili wa Ngira weti bu ahi kwaa bisi ka, nde li mu umweese ti nde asiingi ka bangooyi. ");
INSERT INTO iyx_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nde a asi lisobuso pe nha kati a bisi a beni na bo, mundaa nde atsieemisi mitimi mia bo bu basiiri imiini mu Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Mu taanga di, mu ima beni ditooni usongo Nziaambi? So diyilii buu dili mu unaa mufunu waleme nha yulu a miyii, wuli umatuu bataayi babisi, natee bisi bameme diakooni nde ubiti. ");
INSERT INTO iyx_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ka mu imiini, mu bweese ba Pfumu Yiisu diyobuu, mu iteesi imosi na bo ka.» ");
INSERT INTO iyx_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Mvuutini yoosi yawuri na pii, na yo yayuulili Barnaba na Pawuli, babayaabisi bo biliimbi na bimaanga bi Nziaambi a yilii mu bo nha kati a bangooyi. ");
INSERT INTO iyx_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Bu bamani utsuu, Yaakobi aleeli: «Baana ba nguu, diyuu me! ");
INSERT INTO iyx_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simooni Peetero abiindili, buni mu mbaandili Nziaambi asooli nha kati a babali bangooyi, baata ba buba ba nde. ");
INSERT INTO iyx_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Mandaa ma mafwaanina na mamaleeli mibili, mbii bu basonii: ");
INSERT INTO iyx_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Nha mbisi a nhaa, me sa bwayiri, bu leeli Pfumu, mu ubwa tuungu nzo a Daavidi ya ba ya maabwa, me sa bwatuungu bibaa, na me sa bwatemse yo. ");
INSERT INTO iyx_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Paa baata babamosi ka basaa Pfumu, ee, bifuumbu bikimi bikaasieetuu kwaa me sa baba baata ba me. Bu leeli Pfumu, ");
INSERT INTO iyx_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","me wakwiyaabisa minhana mia me umatuu bele pe.”» ");
INSERT INTO iyx_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yaakobi abwileele ti: «Ni mu buu, me ndi itwaari na babali mu utsimi ti, bubwe pe mu umweese bangooyi babamaasiingi Nziaambi pasi. ");
INSERT INTO iyx_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ka disonuu bo mukaanda paa banyaala udia banyama basuumuu ba baha bu ngori kwaa biteyi, banyaala tsoongili, na banyaala udia banyama babahele upalisa makili, na banyaala udia makili. ");
INSERT INTO iyx_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Mundaa umatuu taanga dikulu, baata bali mu uyiisi Mikele mia Mooso mu mangaanda moosi, na bali mu utaanga mio mu manzo ma makutunu ma Bayuudayo, mu pasi iluumbu kia Saba.» ");
INSERT INTO iyx_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ni mubuu, batumu na bakuutu itwaari na libuundu loosi, bamoni ti bubwe mu usoolo baata nha kati a bo na mu utsinduu bo, itwaari na Pawuli na Barnaba, ku ngaanda ya Antioki. Ninha basooli: Yude, wu bubaata Barisabase, na Sila, babali na litumu nha yulu a baana ba nguu. ");
INSERT INTO iyx_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Bahi bo mukaanda wu basonuu weti bu: «Baana banguu ba beni batumu na bakuutu ba libuundu, bisi diheeri “mabwe kwaa beni” baana ba nguu ba bisi babali a Bayuudayo pe, babali ku ngaanda ya Antioki, ku tsi ya Siria na ku itinini kia Silisi. ");
INSERT INTO iyx_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Bisi diayuu ti kaba la baata baba mati kwaa bisi, ba bisi diahele uhaa muswa, bayawungusu beni na bamweese beni ngebe mu tsuyili a bo. ");
INSERT INTO iyx_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ni mu buu, mu itwaari bisi diaholo kesili ya usoolo baata, na utsinduu beni bo. Baata me bali mu uyiri kuulu moosi na banduu ba bisi ba litoono, Barnaba na Pawuli, ");
INSERT INTO iyx_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","babayeelili moonyi a bo mu isala kia Pfumu a bisi Yiisu Kristo. ");
INSERT INTO iyx_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ni mu buu, bisi ditsinduu beni Yude na Sila, paa bo bayaabisa beni bo makulu ma bisi diasonuu mu mukaanda wu. ");
INSERT INTO iyx_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ni mu buu, Muheebili wa Ngira na bisi bameme, dimaamono ti bubwe pe mu ubwanaa beni mifunu mikimi. Ka beni diafwaana kele ukiinzi mikele miinami mili na ndutu: ");
INSERT INTO iyx_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","a didia pe banyama ba baha bungori kwaa biteyi, a didia pe makili, udia ka pe banyama babahele upalisa makili, na dinyaala tsoongili. So beni dikiinzi tumini yii yoosi, beni diyilii bubwe. Ka mabweele.» ");
INSERT INTO iyx_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Babatsindii bayeni na batoori ku ngaanda ya Antioki, bakukii libuundu na bahi mukaanda. ");
INSERT INTO iyx_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Bu bataangi mukaanda, bayaangi mu pamisi yi bo babayi mu mandaa ma basonuu. ");
INSERT INTO iyx_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yude na Sila, babali mibili, batsuyi mu idii kialaa kwaa baana ba nguu, mu uhamisa bo na uha bo mifuri mu imiini kia bo mu Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Bo balabisi idii ki ikee kuu, tumake bakabii mu iyeenge na baana ba nguu, na bo bavutii kwaa babatsindii bo.  ");
INSERT INTO iyx_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ka Sila amoni ti bu bwee mu usaala ku Antioki, Yude avutii nde bake ku Yeruselemi. ");
INSERT INTO iyx_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pawuli na Barnaba basiaali wa bo ku Antioki, itwaari na ba bamosi, bo bayiisi na bayaabisi Ndaa Yimbwe ya Pfumu. ");
INSERT INTO iyx_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ku mbisi a taanga hoolo, Pawuli aleeli kwaa Barnaba: «Divutuu mu uyene amono baana ba nguu mu mangaanda moosi ku diayaabisi ma ndaa ma Pfumu, paa diyaaba mu ki iteesi bo bali.» ");
INSERT INTO iyx_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnaba asiingi tsimi a Pawuli, ka nde ali atoono ti bo bayene itwaari na Yowani wu bubaata ti Malako. ");
INSERT INTO iyx_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ka Pawuli a asiingi pe tsimi yii, mundaa ti Yowani wababati na asiisi bo ku itinini kia Pamfili bu bali keni a bamana pe isala. ");
INSERT INTO iyx_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Kaama bu lahami, bo bakabii. Barnaba aholi Malako, bakoti mu bootu na bayeni ku iduku kia Kipiria. ");
INSERT INTO iyx_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pawuli asooli Sila mu uyene na nde mu midieenge. Baana ba nguu baloombili bo bweese ba Pfumu, tumake bo bayeni. ");
INSERT INTO iyx_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pawuli atabi tsi ya Siria na itinini kia Silisi mu uyene ahamisa mabuundu ma Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pawuli atoori ku ngaanda ya Derebe na ku ngaanda ya Lisitara. Kuu kwali na muyii mosi, kuumbu a nde Timoteo, nguu a nde Muyuudayo, wakitii ngaa imiini, ka taayi a nde ali musi Eleene. ");
INSERT INTO iyx_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Baana ba nguu ba ku Lisitara na ba ku Ikonio bakita imbaangi ki ibwe mu ndiaatili a nde. ");
INSERT INTO iyx_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pawuli ali atoono udieenge na nde. Bu wamuholi, wamukesi bubaala, mundaa Bayuudayo ba bali mu bitinini bii, ka boosi ali bayaaba ti taayi a nde ali musi Eleene. ");
INSERT INTO iyx_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Mu mangaanda ma bakilabuu, bo bakiyaabisa kwaa bangaa imiini, kesili yaholi batumu na bakuutu ba Yeruselemi, na bakiloombo kwaa bo mu utumumu kesili yii. ");
INSERT INTO iyx_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Mabuundu ma Nziaambi makihama mu imiini na makifunu mu litaanga la baata iluumbu pasi iluumbu. ");
INSERT INTO iyx_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Muheebili wa Ngira a ahi pe bo muswa mu uyaabisa ndaa a Nziaambi mu itinini kia Asia. Ni mu buu, bo batabi bitinini bia Firingia na Ngalatia. ");
INSERT INTO iyx_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Bu batoori bebele na itinini kia Misia, bo babayi tsimi ya uyene ku itinini kia Bitinya. Ka Muheebili a Yiisu a wabahi muswa pe. ");
INSERT INTO iyx_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Tumake, bu batabi Misia, bo basutii ku ngaanda ya Trowasi mu mukoo a mubu. ");
INSERT INTO iyx_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Mu butsuu, Pawuli abayi monini. Nde amoni musi Masedwane mosi atemene, wamusiiri ndoombili yi: «Yiri ku tsi ya Masedwane, mu uyabasila bisi!» ");
INSERT INTO iyx_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Mu mawasa, nha mbisi a monini yii, bisi diasayi mu uyene ku tsi ya Masedwane, mundaa dia siiri ilimbisi ti Nziaambi waditiiri mbili, mu ubiti Ndaa Yimbwe kwa baata ba ku itinini kii. ");
INSERT INTO iyx_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Bisi diakoti mu bootu nha Trowasi, diayeni ku iduku kia Samotarasi, na iluumbu kiaduki diatoori ku ngaanda ya Neyapoli. ");
INSERT INTO iyx_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Bu diamati kuu, bisi diayeni ku ngaanda ya Filipi, ngaanda yinene yatsiomi mu tsi ya Masedwane, yo yali ku tsini a litumu la basi Looma. Bisi dialabisi biluumbu bialaa mu ngaanda yii. ");
INSERT INTO iyx_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Mu iluumbu kia saba, bisi diapali ku mbari a ngaanda, na diayeni ku mukoo a nziali. Kuu, bisi diakitsimi ti dituu umono mbuu ya likuundu ya Bayuudayo. Bisi diadiaali na diatsuyi kwa Bakaasa babali bakukunu nhaa. ");
INSERT INTO iyx_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Mosi mu bakaasa baa, kuumbu a nde Lidi, musi ngaanda ya Tiatiri, nde ali muyalii a matsaanda matala mamabwe mabeenge, na ali mukuundi a Nziaambi. Nde akiyuu bisi. Pfumu adibili mutimi a nde, paa nde asiingi mandaa makileele Pawuli. ");
INSERT INTO iyx_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Babootii nde na kaanda la nde loosi. Nha mbisi, nde waditimbila ku nzo a nde, na aleeli weti bu: «So beni dimoni ti mu ngwanya me maasa imiini mu Pfumu, diyadiaala ku nzo a me.» Na nde wadibamii mu usiingi ndoombili a nde. ");
INSERT INTO iyx_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Iluumbu imosi bu diakiyene ku mbuu ya likuundu, musiali mosi wa mukaasa ayibwaana bisi: nde ali na muheebili wu mubi, wa mbomo, wakibiti nde mu uteese mandaa ma mu uyiri ku kulu. Nde akibee mboongo dialaa kwaa bapfumu ba nde, mu uteese kwa nde. ");
INSERT INTO iyx_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Bu diakiyene na Pawuli, mukaasa wuu akiduku bisi nha mbisi, mu uyiri aloo mu mifuri ti: «Baata ba, basiali ba Nziaambi a Puungu bali! Bo bali mu uyaabisa beni kuulu yili mu ubiti ku liyobolo.» ");
INSERT INTO iyx_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nde ayilii buu mu biluumbu bialaa. Mu manini, Pawuli akoli kesi, asieetii, na aleeli kwaa muheebili wuu: «Mu kuumbu a Yiisu Kristo, me ni tumu we mu upala mu mukaasa wu!» Mu taanga diinadii, muheebili wu mubi apali mu nde. ");
INSERT INTO iyx_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Bu bapfumu ba mukaasa wuu, bamoni ti bo ka utuu pe ubwasalila nde mu ubaa mboongo, bo bakaangi Pawuli na Sila na bakoosili bo nha kulu a batumi, nha kati a mbari ku baata bubaa vuutunu. ");
INSERT INTO iyx_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Bo babiti bo kwaa bafuundisi ba basi Looma, na baleeli: «Baata ba bali Bayuudayo, bo bali mu usa butsa-butsa mu ngaanda a bisi. ");
INSERT INTO iyx_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Bo bali mu uyiisi bisi bipfu, bi bisi basi Looma diahele na muswa mu usiingi so a bu pe mu usalila bio.» ");
INSERT INTO iyx_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Baata boosi bakoli bo kesi. Bafuundisi bahi muswa wa umaasa Pawuli na Sila bikutu, na batumi ti batete bo bikoti. ");
INSERT INTO iyx_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Bu bamani mu utete bo bikoti bialaa, badumini bo mu perese. Tumake batumi kwaa mukebi a nzo a perese mu uyiluu ukebe bo bubwe. ");
INSERT INTO iyx_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Bu mukebi aholi tumini yii, nde wabadumini kutso itsuru kia tsieelele kia nzo a perese, na akuti miili mia bo mu bikoolo. ");
INSERT INTO iyx_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Mu kati a kati a butsuu, Pawuli na Sila bakikuundu na bakiyimbi mu ubili Nziaambi. Makori makimi ma mali mu nzo a perese makiyuu bo. ");
INSERT INTO iyx_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Itsundu-a-tsundu, toto dianyingini mu mifuri, ibwa kia nzo a perese ka kianyingini. Nhaa-na-tsi minywa mia nzo a perese mioosi miadibini na mikuru mia bitali mibakuti makori moosi ma mali mu perese mianyangii. ");
INSERT INTO iyx_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mukebi a perese asiimbii bu amoni ti minywa mia nzo a perese ka bwaasi. Nde aholi mbeeri ya mukasa paa adusu nyutu, mundaa atsimi ti makori ma maabata. ");
INSERT INTO iyx_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ka Pawuli aloyi mu mifuri mioosi, aleeli: «Adusu nyutu a we pe, bisi boosi nha dili.» ");
INSERT INTO iyx_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ni mu buu, mukebi a perese aloombi mwiindi, nde akoti mu mawasa mu itsuru kiali makori, na nde abwi nha miili mia Pawuli na Sila kutso utehete mu boomo. ");
INSERT INTO iyx_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Tumake, nde apalisi Pawuli na Sila ku mbari, na afuuli bo: «Bataata, me ima nafwaana usa paa ti me yobuu?» ");
INSERT INTO iyx_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bo bavutuli: «Sa imiini mu Pfumu Yiisu na we sa yobuu, we na baata ba nzo a we yoosi.» ");
INSERT INTO iyx_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Na bo bayaabisi ndaa a Pfumu, kwaa nde na kwaa boosi babali mu nzo a nde. ");
INSERT INTO iyx_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Mu butsuu baa na baa, mukebi a perese aholi Pawuli na Sila, aswaayi maputu ma bo. Na nha mbisi, bamubootii, na baata boosi ba nzo a nde. ");
INSERT INTO iyx_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Nde abiti Pawuli na Sila ku nzo a nde, na wabahi biloo bia udia. Mukebi a perese na boosi ba mu nzo a nde baluuli mu kinyi, mundaa basi imiini mu Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Busi bu bakieri, bafuundisi ba basi Looma, batsindii basiali ba bo, mu uyaleele kwaa mukebi a perese ti: «Palisa baata baa.» ");
INSERT INTO iyx_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Mukebi a perese ayitooso mandaa maa kwaa Pawuli: «Bafuundisi ba ma aha muswa wa upalisa we mu perese. Ni mu buu, beni ka utuu upala, na diyene mu iyeenge.» ");
INSERT INTO iyx_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ka Pawuli aleeli kwaa babali mu usala na bafuundisi: «Bo batumu ti batete bisi bikoti nha kulu a baata boosi, kwahele a ufuundusu bisi, bunu bisi ka dili basi Looma. Nha mbisi a nhaa bo badumunu bisi mu perese. Mu taanga di, bo ka na nzala upalisa bisi mu perese mu tsweeyi? Ngori! Nyaala, bo makulu bayapalisa bisi!» ");
INSERT INTO iyx_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Basiali bayitooso mandaa maa kwaa bafuundisi. Bo bu bayuyi ti Pawuli na Sila basi Looma bali, babayi boomo. ");
INSERT INTO iyx_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ni mu buu, bo bayiri, mu uloombo kolokolo kwaa Pawuli na Sila, babapalisi mu perese, na babaloombi ti basiisi ngaanda yii. ");
INSERT INTO iyx_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Bu bapali mu perese, Pawuli na Sila bayeni ku nzo a Lidi. Bu bamani mu umono baana ba nguu, na bu babahamisi, bo bayeni. ");
INSERT INTO iyx_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Bo batabi ngaanda ya Afipoli na ya Apoloni na batoori ku ngaanda ya Tesalonika, kwali nzo a makutunu ma Bayuudayo. ");
INSERT INTO iyx_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Weti bwali ipfu kia nde, Pawuli ayeni ku nzo a makutunu ma Bayuudayo. Mu masaba matata madukusunu, nde abiindili kwaa baata babali mu nzo yii, ma basonuu ma ngira. ");
INSERT INTO iyx_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Nde wababiindili na wabamweesi weti buli ma basonuu ti Mesiya afwaana umono pasi, na sa asiimbuu mu babakwa. Nde akileele bo: «Yiisu, wu me ndi mu uyaabisa beni, ni nde Mesiya.» ");
INSERT INTO iyx_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ba bamosi mu bo basiingi ma bayuyi, bakoti mu kaba la Pawuli na Sila. Kaba lalaa la basi Eleene ba bakikiinzi Nziaambi, na bakaasa balaa ba likiinzi, bavuutini ka na ba Pawuli. ");
INSERT INTO iyx_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ka Bayuudayo baluuli mu musoyi. Bo bakukii bipunga-pungu bi bo bamoni mu makuulu. Batsindi bio mu usa buwulu mutso ngaanda. Bo bayikoto mu nzo a Yasoni, basiayi Pawuli na Sila paa babiti bo nha kulu a baata. ");
INSERT INTO iyx_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ka bu bakooni usololo bo, bo bakoyi Yasoni na bakimi ba ngaa imiini mu Yiisu nha kulu a batumi ba ngaanda, na bakiloo: «Baata ba bamaasa butsa-butsa mu tsi yoosi, na mu taanga di bo bamaato nhaa na nha! ");
INSERT INTO iyx_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yasoni ayaki bo ku nzo a nde. Baata ba boosi a bali mu ukiinzi pe mikele mia mutini Kayisari, ka bo bali mu uleele ti uli na mutini mukimi, wa kuumbu Yiisu.» ");
INSERT INTO iyx_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Mandaa maa, mamweesi baata na batumi ba ngaanda yii mutimi pasi. ");
INSERT INTO iyx_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Mu ndaa yi, Yasoni na baana ba nguu ba mu libuundu babeli ikori kwaa batumi ba ngaanda, tswaamini a bunyaala bo. ");
INSERT INTO iyx_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Butsuu bu batoori, baana ba nguu babatisi Pawuli na Sila ku Beere. Bu batoori kuu, bo bayeni ku nzo a makutunu ma Bayuudayo. ");
INSERT INTO iyx_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Bayuudayo ba mu ngaanda a Beere bali bavulu ba ku Tesalonika mutimi bubwe. Bo bayaki mandaa ma Nziaambi mu kinyi yalaa. Pasi iluumbu, bo bakiyii ma basonuu ma Ngira, mu ukengese mbiiti makiyiisi Pawuli mali ma ngwanya. ");
INSERT INTO iyx_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Balayi mu bo basi imiini mu Pfumu. Bakaasa ba likiinzi na babaala balaa ba basi Eleene, basi mu Pfumu. ");
INSERT INTO iyx_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ka taanga di Bayuudayo ba ku Tesalonika bayuyi ti Pawuli akiyaabisa ka mandaa ma Nziaambi ku Beere, bo bayeni kuu, na batsindi koongi mu ulooso butsa-butsa. ");
INSERT INTO iyx_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ni mu buu, mu mawasa baana ba nguu babatisi Pawuli mu kuulu yili mu uyene ku mubu. Ka Sila na Timoteo basiaali ku ngaanda ya Beere. ");
INSERT INTO iyx_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Babakiyayili Pawuli, bamutoosi natee ku ngaanda ya Ateene. Tumake bo bavutii ku Beere, na bo bayitoosolo tumini a Pawuli kwaa Sila na Timoteo: bo bayabaa nde mu mawasa ku nde ali. ");
INSERT INTO iyx_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Mu taanga di Pawuli akikebe Sila na Timoteo ku ngaanda ya Ateene, bu amoni ti ngaanda yii yali yaluulu mu banziaambi ba biteyi, matsimi ma nde makoti mu ngebe dialaa. ");
INSERT INTO iyx_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Pawuli akiyolo mutso nzo a makutunu, itwaari na Bayuudayo na pasi baata babasa imiini mu Nziaambi. Na mu pasi iluumbu, nde akiyolo ka na baata ba nde akibwaana na bo ku kati a mbari nha mbuu ya mbwaanini. ");
INSERT INTO iyx_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Kaba la baata ba ngaa mayele ba Epikire na ba Esitoyisi bakitsuu ka na nde. Ba bamosi bafuuli ti: «Ngaa kele wu ima atooni uleele?» Babakimi bu bakiyuu nde mu uyaabisa Ndaa Yimbwe ya mu Yiisu na tsimbilili a babakwa, bavutuli ti: «Nde weti wuli mu uyaabisa banziaambi ba bieenyi.» ");
INSERT INTO iyx_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ni mu buu, bo baholi Pawuli na bamubiti nha kula pfuundu a Aropaze, na bamufuuli: «We utuu ubiindili bisi nziisili yi nyatii yi we li mu uyiisi baata? ");
INSERT INTO iyx_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","We li mu uyaabisa bisi mandaa ma bumweenyi, na bisi diatoono uyaaba bubwe mambiindili ma mo.» ");
INSERT INTO iyx_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Bo baleeli buu, mundaa ti basi Ateene boosi na bieenyi biakidiaala na bo, bakilabisa taanga dia bo ndila mu uyuu matsimi ma manyatii. ");
INSERT INTO iyx_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pawuli atemini nha kati a pfuundu a Aropaze aleeli: «Baata ba ku ngaanda Ateene, me ndi mu umono ti mu mioosi, beni dili mu umweese inziaambi kialaa. ");
INSERT INTO iyx_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Mutaanga di me beeri adieenge mu ngaanda a beni, na bu me beeri atala biteyi bi beni dili mu ukuundu, me na mono ka diki limosi li beni dibaatsuu bungori, lili na bisonii bi: “kwaa Nziaambi wu bahele uyaaba.” Ee, me nziri mu uyayaabisa beni Nziaambi wu beni dili mu ukuundu kwahele a uyaaba nde. ");
INSERT INTO iyx_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Nziaambi wayiluu tsi na bioosi bili mu yo, ni Pfumu a yulu na tsi, na nde a ubaadiaala pe mu manzo ma Nziaambi ma batuungu mu mioo mia baata. ");
INSERT INTO iyx_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Nde a ali ka pe na nzala ti baata bamubaasila, na bamuha iloo pasi kio. Ka nde ni wuli mu uha muwuumu wa moonyi na bioosi bikimi bidili na nzala bio. ");
INSERT INTO iyx_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Umatuu mu muutu mosi, nde ayiluu bifuumbu bia baata bioosi, na asuusu bio nha yulu a toto loosi. Nde akese mataanga ma mvulu na ma maangala, na mandili ma matsi ma bo budiaala. ");
INSERT INTO iyx_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Nde ayiluu buu, paa baata bamusaa, so bayesini mu usaa nde, helape bamusolili. Mu ngwanya, Nziaambi a ali la pe na pasi muutu mu bisi. ");
INSERT INTO iyx_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ka: “Ni mundaa nde bisi dili moonyi, dili mu unyingini, na dili na idiingi.” Ni buu ka bwaleeli basonii ba beni ba bamosi: “Bisi ka dili baana ba nde.” ");
INSERT INTO iyx_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Bu bisi dili baana ba Nziaambi, muutu anyaala utsimi ti Nziaambi afwaanina na iteyi kia woolo, so kia palata, so a bu pe kia manya, bi musiali a biteyi ayiluu mu mioo na mayele ma nde. ");
INSERT INTO iyx_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ka Nziaambi a li mu ubwatala pe mataanga ma baata bali kutso bundimbi. Ka mu taanga di, nde li mu uta boosi mbili mu mambuu moosi, mu ukiingili mayele, na usobo ndiaatili. ");
INSERT INTO iyx_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ka nde akesi iluumbu ki nde ufuundusu baata ba tsi yoosi mu libweeye, mu muutu moosi wu nde asooli. Nde amweesi imbaangi kwaa boosi, bu nde asiimbili muutu wuu mu babakwa.» ");
INSERT INTO iyx_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Bu bayuyi Pawuli mu utsuu mu ndaa tsimbilili a babakwa, ba bamosi basi nde saa, ka bana baleeli: «Bisi diatoono ubwayuu we mu utsuu mu ndaa yii iluumbu ikimi.» ");
INSERT INTO iyx_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ni mu buu, Pawuli asiisi bo. ");
INSERT INTO iyx_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ka bunu, mwaana kaba la baata laduki nde na basiiri imiini. Nha kati a bo kwali na Deni, mosi mu bakuutu ba pfuundu a Aropaze. Kwali ka na mukaasa mosi wa kuumbu Damari, na baata bakimi. ");
INSERT INTO iyx_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Nha mbisi a nhaa, Pawuli asiisi Ateene na ayeni ku ngaanda ya Kolito. ");
INSERT INTO iyx_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Nde abwaani kuu, Muyuudayo mosi kuumbu Akila, muutu wa ku itinini kia Ponte. Nde buu bu akimata ku tsi ya Italia na mukari a nde Pirisile, mu ndaa ti, mutini Kolodo ahi litumu ti Bayuudayo boosi bapala mu Looma. Pawuli ayimono bo. ");
INSERT INTO iyx_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Bu nde akisa isala imosi na bo kia utuungu manzo ma ngooto, nde ayidiaala kwaa bo paa basala mu itwaari. ");
INSERT INTO iyx_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Mu pasi iluumbu kia saba, Pawuli akiyolo mu nzo a makutunu ma Bayuudayo. Nde akisaa makuulu paa Bayuudayo na basi Eleene basa imiini mu ma nde akitsuu. ");
INSERT INTO iyx_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Bu Sila na Timoteo bamati ku tsi ya Masedwane, Pawuli akiyeelele taanga dia nde dioosi mu nziisili a mandaa ma Nziaambi. Nde akimweese kwaa Bayuudayo ti Yiisu ni Mesiya. ");
INSERT INTO iyx_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ka, Bayuudayo baa badwaanisi nziisili a nde na bamutuyi. Ni mu buu, nde akubili lifuundu la bikutu bia nde tswaamina nde uyene na wabaleeli: «So beni diyeni ku mbuungulu, ndaa a beni bameme. A yatala me pe. Mu taanga di, me ka kwaa bangooyi niyene.» ");
INSERT INTO iyx_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Nde amatii nha mbuu yii, na ayeni ku nzo a muutu mosi, wa kuumbu Titiyusi Yusitusi wakikiinzi Nziaambi. Nzo a nde ali nha peembi a nzo a makutunu ma Bayuudayo. ");
INSERT INTO iyx_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kirisipusi, mukuutu a nzo a makutunu yii, nde na kaanda la nde loosi basiiri imiini mu Pfumu. Basi Korinto babalayi bakiyuu Pawuli basiiri ka imiini na baholi libootuu. ");
INSERT INTO iyx_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Butsuu bumosi, Pfumu aleeli kwaa Pawuli mu monini: «A ba na boomo pe, ka hama mu utsuu, a wuru pe, ");
INSERT INTO iyx_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ka me ndi itwaari na we. Muutu pe so mosi wu utuu uyiluu we ndaa yimbi, mundaa ti baata balaa mu ngaanda yi bali bibayi bia me.» ");
INSERT INTO iyx_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pawuli adiaali ku Korinto ilimi imosi na ndaamba, mu uyiisi mandaa ma Nziaambi kwaa boosi. ");
INSERT INTO iyx_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Mu taanga di Ngalioni musi Looma akitumu itinini kia Akayi, Bayuudayo bayuhisini mu uyiluu ma mabi kwaa Pawuli. Bamubiti ku nzo a pfuundisi, ");
INSERT INTO iyx_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","na baleeli: «Muutu wu li mu utsindi baata mu ukuundu Nziaambi, kwahele a ukiinzi mikele mia bisi.» ");
INSERT INTO iyx_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Mu taanga di Pawuli akeni ubaanduu mu utsuu, Ngalioni avutili kwaa Bayuudayo, aleeli: «So beeri ti mundaa ya ndusili so a bu pe ndaa ya vulu bubi, me keni uholo taanga mu uyuu beni Bayuudayo. ");
INSERT INTO iyx_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ka bu uli ti, mandaa ma makaama matala: tsuyili, makuumbu, na mu mikele mia beni bame, mii miatala beni. Ngori a me, mu uba nzioonzi mu ma ndaa ma pili yii.» ");
INSERT INTO iyx_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Nha mbisi a nhaa, nde wabapalisi mu nzo a pfuundisi. ");
INSERT INTO iyx_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ni mu buu, bo boosi bakaangi Sositene, mukuutu a nzo a makutunu ma Bayuudayo, na bamuteti nha mbari a nzo a pfuundisi. Ka Ngalioni a amoni tsoongo pe. ");
INSERT INTO iyx_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pawuli abwilabisa biluumbu bialaa ku Korinto. Tumi asiisi baana ba nguu na akoti mu bootu, mu uyene ku tsi ya Siria, itwaari na Pirisile na Akila. Tswaamini a nde uyene, bamutebi naanga dia mutswe ku ngaanda a Senkere, mu ndaa lilasina li nde asi kwaa Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Mu taanga di bo batoori ku ngaanda ya Efeso, Pawuli asiisi Pirisile na Akila. Nde ayeni ku nzo a makutunu na ayoli na Bayuudayo. ");
INSERT INTO iyx_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Bo bamuloombi mu ulabisa biluumbu bialaa kuu, ka nde abisi. ");
INSERT INTO iyx_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Pawuli wabasiisi, aleeli: «So Nziaambi tooni, me sa yiri avutuu kwaa beni.» Na nde akoti mu bootu na asiisi Efeso. ");
INSERT INTO iyx_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Nha mbisi a uto ku ngaanda ya Sezare, nde akwiyene ku Yeruselemi mu uyaba balibuundu. Tumake, nde ayeni ku Antioki ya ku tsi ya Siria. ");
INSERT INTO iyx_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Nde alabisi taanga hoolo kuu, nde avutii, na atabi tsiomi itinini kia Ngalatia, tumake kia Firingia, mu uyene a hamisa imiini kia miyii mioosi. ");
INSERT INTO iyx_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Muyuudayo mosi, kuumbu a nde Apolo, wu babutu ku ngaanda ya Alekandere, atoori ku ngaanda ya Efeso. Nde ali na tsuyili yimbwe na ali ayaaba bubwe-bubwe Mabasonuu Mangira. ");
INSERT INTO iyx_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Nde abayi nziisili mu miatala kuulu a Pfumu, na mu ilimbisi kioosi, nde akiyaabisa na akiyiisi na de-de-de Ndaa Yimbwe ya mu Yiisu. Ka Apolo ali ndila libootuu la Yowani ayaaba. ");
INSERT INTO iyx_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Nde atsuuyi mu ilimbisi kioosi mu nzo a makutunu ma Bayuudayo. Pirisile na Akila bu bamuyuyi, bamuholi mu uba na bo, na bamubiindili kuulu a Nziaambi mbii bwafwaana. ");
INSERT INTO iyx_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Tumake, Apolo abayi tsimi ya uyene ku itinini kia Akayi. Baana banguu bamuhamisi na batsindii mukaanda kwaa miyii miali kuu, paa bayaka nde bubwe. Bu atoori kuu, nde amonii muutu wa mufunu, mu bweese ba Nziaambi, kwaa babamaasa imiini mu Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ni mu buu, mu mandaa maleme, nde amweesi ti tsuyili a Bayuudayo a yafwaana pe, na nde alaayi kwaa bo mu mabasonuu ma Ngira ti Yiisu ni Mesiya. ");
INSERT INTO iyx_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Mu taanga di Apolo ali ku ngaanda ya Kolito, Pawuli atabi itinini kia ku yulu a milaanda mia tsi ya Asia, na atoori ku ngaanda ya Efeso. Nde abwaani kaba la miyii kuu, ");
INSERT INTO iyx_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","nde wabafuuli: «Beni diayaki Muheebili wa Ngira mu taanga di beni diasiiri imiini?» Bo bamuvutili: «Ngori, bisi kaala a diayuu so ku butsuu mu Muheebili wa Ngira pe.» ");
INSERT INTO iyx_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ni mu buu, Pawuli wabafuuli: «Ki libootuu beni diaholi?» Bo bavutuli: «Libootuu li Yowani ayaabisi.» ");
INSERT INTO iyx_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pawuli aleeli kwaa bo: «Yowani akibootuu baata bakisiingi ukiingili mayele na usobo ndiaatili. Nde akileele kwaa baata ba Iseraeli, mu usa imiini mu wuu ukaayira nha mbisi a nde. Muutu wuu ni Yiisu.» ");
INSERT INTO iyx_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ku mbisi a uyuu mandaa maa, bo baholi libootuu mu kuumbu a Pfumu Yiisu. ");
INSERT INTO iyx_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Tumake, Pawuli wabanayi mioo na bo bayaki Muheebili wa Ngira. Bo babaandii utsuu mu ndimi na ubili mandaa makimata kwaa Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Baata baa ali kuumi na boolo mu kaba la miyii. ");
INSERT INTO iyx_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Taanga dioosi, Pawuli akiyene ku nzo a makutunu ma Bayuudayo, kuu nde akiyiisi baata baa mu ilimbisi kioosi, mu tsitsi a batsuungi batata. Nde akitsuu mu Ipfumu kia Nziaambi, na nde akisa mifuri mu usaa makuulu, paa ba bakiyuu nde basiingi ma nde akileele. ");
INSERT INTO iyx_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ka babalayi mu bo bakubisi mitimi mia bo, babisi usa imiini, na basiiri kuulu a Pfumu saa nha kulu a baata boosi. Ni mu buu, Pawuli wabasiisi, na ayeni na miyii, nde akiyiisi bo biluumbu bioosi ku nzo a nziisili ya muutu mosi wa kuumbu Tiranosi. ");
INSERT INTO iyx_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Pawuli ahami mu uyiisi bo mu tsitsi a bilimi bioolo, natee bu baata boosi ba Bayuudayo na basi Eleene, ba mu itinini kia Asia, bayuyi mandaa ma Pfumu. ");
INSERT INTO iyx_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Nziaambi akiyiluu bimaanga bia ukimuu mu mioo mia Pawuli. ");
INSERT INTO iyx_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ni mu buu, baata bakibiti matsaanda so a buu pe bitambila biabumini nyutu a Pawuli, na bakinaa bio mu yulu a babeeri. Mundaa yii, babeeri bakibeeluu na miheebili mimibi miakipala mu bo. ");
INSERT INTO iyx_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Bayuudayo bakimi bakiyene mu mambuu moosi mu ubingi miheebili mimibi miali mu babeeri. Ni mu buu, bo bayesini ka mu usalila kuumbu a Pfumu Yiisu. Bo bakileele kwaa miheebili mimibi: «Me ni tumu beni mu upala mu nyutu a muutu wu, mu kuumbu a Yiisu, wu Pawuli ali mu uyiisi!» ");
INSERT INTO iyx_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ni buu bwakiyiluu baana tsaamba ba Seva wuli nguu a ngaanga a Nziaambi mu Bayuudayo. ");
INSERT INTO iyx_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ka iluumbu imosi, muheebili wu mubi avutili kwaa bo: «Me nayaaba Yiisu, na me nayaaba ka Pawuli na ali, ka dileele me beni ba na dili?» ");
INSERT INTO iyx_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Na muutu wali na muheebili wu mubi ayibwiilili bo mu udwaanisa bo, na avuli bo boosi mifuri. Nde wabamweesi pasi dialaa, na baana ba Seva bapali mu nzo a nde, mapene na maputu malaa mu manyutu. ");
INSERT INTO iyx_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Baata boosi ba mu ngaanda ya Efeso, Bayuudayo na basi Eleene, bu bayuyi mandaa maa, bo boosi babayi boomo ba Nziaambi, na bo bakiinzi kwalaa kuumbu a Pfumu Yiisu. ");
INSERT INTO iyx_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Balayi mu ba babasi imiini mu Pfumu, bayiyaabisa ma mabi ma bo bayilii nha kulu a baata boosi. ");
INSERT INTO iyx_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Kaba lalaa la bakihaanda, babeyi mikaanda mia bo, na batsuyi mio mbaa nha kulu a baata boosi. Bataangi tala a mikaanda mii, na yatoori tsitsi a maku mataana ma mapfuundu ma mboongo. ");
INSERT INTO iyx_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ni mu buu, mandaa ma Nziaambi matsiaamii kwavululu, mu iteesi kialaa na mu mifuri mu ma mbuu moosi, mu lituu la Pfumu. ");
INSERT INTO iyx_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Nha mbisi a mandaa maa, Pawuli aholi kesili mu utaba tsi ya Masedwane na itinini kia Akayi, nha mbisi sa ayene ku Yeruselemi. Nde akileele: «Me bu kaamatuu kuu, me nafwaana ka uto ku ngaanda ya Looma.» ");
INSERT INTO iyx_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ni mu buu, nde atsindii ku Masedwane boolo mu babaasili ba nde: Timoteo na Erasiti. Ka nde makulu abwidiaala taanga hoolo mu itinini kia Asia. ");
INSERT INTO iyx_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Mutaanga dii, butsa-butsa ba mifuri babwiiri mu ngaanda ya Efeso, mu ndaa Kuulu a Pfumu. ");
INSERT INTO iyx_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Mutsuli a palata, wa kuumbu Dimitiri, akitsulu mu palata bifwa-fwani bia nzo a inzia-nziaambi kia mukaasa wa kuumbu Aretemi. Mu isala kii nde na basiali ba nde bakibaa ndaanda yalaa. ");
INSERT INTO iyx_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Nde akukii basiali ba nde na baa bakisala isala kiafwaanina na kia nde, na wabaleeli: «Bambaayi ba me, beni diayaaba ti isala ki ili mu uha bisa-beni busini balaa. ");
INSERT INTO iyx_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ka beni dili mu umono na dili muyuu ma mali mu ulabuu! Pawuli me wuu, li mu uyaabisa ti, banziaambi ba baata bali mu uyiluu mu mioo mia bo, a bali banziaambi ba ngwanya pe. Nde matuu ukoo baata balaa, a ndila mu ngaanda ya Efeso yi pe, ka tee mu itinini kioosi kia Asia, paa basiingi ma nde ali mu uleele. ");
INSERT INTO iyx_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Baata utuu ubele isala kia bisi a beni mundaa ma nde ali mu uleele, na umeengele nzo a inzia-nziaambi kia mukaasa kia kuumbu Aretemi. Ni inzia-nziaambi me kii, ki bali mu ukuundu mu itinini kioosi kia Asia na mu tsi yoosi yadiengilele baata. Mundaa yii, Aretemi a ubwaba na likiinzi pe!» ");
INSERT INTO iyx_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ba bayuyi mandaa maa, bo baluuli mu kesi, na baloyi, baleeli: «Nyaala, Aretemi nziaambi a basi Efeso, anaanguu!» ");
INSERT INTO iyx_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ngaanda yoosi yaluuli mu butsa-butsa. Kutso kuu, bakaangi na bakoyi Ngayu na Arisitariki, baata ba ngaanda ya ku Masedwane, ba bakisa midieenge na Pawuli. Bayeni bo boosi ku mbuu yi baata bali na ipfu kia ubaavuutunu. ");
INSERT INTO iyx_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pawuli ali na nzala ya umonuu nha kulu a koongi, ka miyii miamulii. ");
INSERT INTO iyx_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Kaba la bapfumu ba mu itinini kia Asia, ba bali bambaayi ba nde, batsindii nde mukeenzi paa anyaala uyene ku mbuu yi baata bubaavuutunu. ");
INSERT INTO iyx_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Mutaanga dii, koongi yavuutini yali kutso butsa-butsa: ba bamosi bakiloo mu uloombo ndaa mosi, bana mu uloombo ndaa kimi, na balayi mu bo a bakiyaaba pe mu ki ndaa bo bakukini. ");
INSERT INTO iyx_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Baata bakimi mutso koongi babiindili ndaa kwaa muutu moosi wa kuumbu Alekandere, wu Buyuudayo bakitsindi mu uba nha kulu. Alekandere anaangili koo mu usaa utsuu na ubiindili mandaa nha kulu a koongi. ");
INSERT INTO iyx_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ka mu taanga di baata bayaabi ti nde Muyuudayo, boosi baloyi mu ndaa mosi, mu tsitsi a manguungu moolo, baleeli: «Nyaala, Aretemi nziaambi a basi Efeso, anaanguu!» ");
INSERT INTO iyx_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Tumake, musonii a mikaanda mu bakuutu ba ngaanda atuuyi uwurusu koongi, aleeli: «Basi Efeso! Baata boosi bayaaba ti ngaanda ya Efeso yili ikuundu kia nzo a nziaambi wa mukaasa Aretemi, ngaa litu wanaanguu. Efeso yili ka ikuundu kia iteyi kia nde kiamati ku yula. ");
INSERT INTO iyx_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","A so muutu moosi pe wu utuu usa paa mu ndaa yii, beni diafwaana uba na swii na dinyaala uyiluu mandaa weti baata ba biwulu. ");
INSERT INTO iyx_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Beni dibeyi baata ba nhaa na nha, bunu bo a bayibi pe bisii bia nzo a nziaambi a bisi wa mukaasa, na a batuu nde pe. ");
INSERT INTO iyx_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","So Dimitiri na bambaayi ba nde ba isala, bali na ndaa na muutu, manzo ma pfuundisi na mo, na banzioonzi ka na bo, bayafuundu kuu. ");
INSERT INTO iyx_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ka so beni dili na ndaa kimi ya uyaabisa, sa bakengese yo ku pfuundu a ikuutu kia ngaanda. ");
INSERT INTO iyx_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","So a dikebi pe, utuu uyafuundu bisi mu miyilimi lolo li, ti bisi dimaatsindi baata mu usa butsa-butsa. A dituu ubaa buungu pe mu uyiluu mvuutini ya pili yi, mu ndaa ti, a dituu uha mbiindili yafwaana mu yo pe.» Bu amani mu utsuu buu, nde aleeli kwaa baata muutu-muutu avutuu ku nzo a nde. ");
INSERT INTO iyx_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Taanga di butsa-butsa me bawiiri, Pawuli akukii bangaa imiini na wabahamisi. Bu amani uha bo mabweele, nde ayeni ku tsi ya Masedwane. ");
INSERT INTO iyx_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Bu akitaba tsi yii, kutso bimoo na bo, nde akiyene ahamisa bangaa imiini kwalaa. Tumake, nde ayeni ku tsi ya Eleene. ");
INSERT INTO iyx_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Nde alabisi batsuungi batata kuu. Mu taanga di nde akeni uholo bootu paa ayene ku tsi ya Siria, nde ayuyi ti Bayuudayo bakisa mapfuundu mu nzala ya ti bamudusu. Ni mu buu, nde aholi kesili ya uvutuu mu kuulu ya Masedwane mu uto ku tsi ya Siria. ");
INSERT INTO iyx_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Baata bakiyene na Pawuli itwaari, ni ba: Sopatiri mwaana a Pirusi wa ku ngaanda ya Beere, Arisitariki na Sekundusi basi Tesalonika, Ngayo wa ku ngaanda ya Derebe, Tisikusi na Trofimi ba ku itinini kia Asia, na Timoteo. ");
INSERT INTO iyx_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Baa-na-ba batswaamii, na bakebi bisi ku ngaanda ya Trowasi. ");
INSERT INTO iyx_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nha mbisi a mukuungi wa mapa ma bahele ufunusu, bisi diakoti mu bootu ku ngaanda ya Filipi. Biluumbu bitaana bu biayooyi, bisi diayibaa bo ku Trowasi, kuu dialabisi limiingi libiimbili. ");
INSERT INTO iyx_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Mu tsitsii ya Saba, bisi diali diakukunu mu udia biloo bia itwaari, na Pawuli akiyiisi bangaa imiini. Bu nde ali na tsimi ya uyene mu iluumbu kiaduku, nde ayiisi mu taanga dialaa, natee kati a kati a butsuu. ");
INSERT INTO iyx_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Miindi miali mialaa, mu itsuru kia nzo kia ku yulu, mu bisi diali diakukunu. ");
INSERT INTO iyx_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mufuru a baala mosi wa kuumbu Etiki, ali adiaala nha neele a nzo. Nde alaari tolo la mifuri bu Pawuli adiingi mu uyiisi. Mu taanga di nde ali ala tolo, nde apatii umatuu mu ingo kia nzo ya matata, natee nha tsi. Bo banaangili nde, ka nde ali amaakwa. ");
INSERT INTO iyx_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pawuli bu asutii, abaandini, wamuholi mu mioo mia nde na aleeli: «A diba na boomo pe, nde musii ali!» ");
INSERT INTO iyx_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Tumake, bu babwihaata, Pawuli abukili lipa na badi lo mu itwaari. Nha mbisi a utsuu kwalaa, natee bu bwisi bakieeri, nde ayeni. ");
INSERT INTO iyx_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Bavutii na mwaana a baala wuu ku nzo a nde, bu ali ka musii. Ndaa yii yahamisi boosi kwalaa. ");
INSERT INTO iyx_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Bisi diakoti mu bootu na diatswaamii mu uyene ku Asosi, ku diayuhisini mu ubwaanana na Pawuli. Bisi diayilii buu, mundaa ti nde ali aholi kesili ya uyene ku ngaanda ya Asosi mu miili. ");
INSERT INTO iyx_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Mu taanga di nde ayibaasa bisi ku Asosi, bisi diamuholi, diakoti na nde mu bootu na diayeni ku iduku kia Mitilene. ");
INSERT INTO iyx_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Bu diamati kuu, iluumbu kiaduki, bisi diahami mu uyene mu bootu na diatoori nha kulu a iduku kia Kiyo. Mu iluumbu kiabwiduku, bisi diatoori nha iduku kia Samosi, tumake, mu iluumbu kia nha mbisi a kii, diatoori ku Mileti. ");
INSERT INTO iyx_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pawuli aholi kesili ya uhele utsikini mu ngaanda ya Efeso, mundaa uhele ulabisa taanga, mu itinini kia Asia. Nde ayilii buu, mundaa ti nde akibingili uto mu mawasa ku Yeruselemi, tswaamina iluumbu kia Pentekoti ito. ");
INSERT INTO iyx_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Pawuli bu ali ku Mileti, nde atumisi bakuutu ba libuundu ba ku Efeso. ");
INSERT INTO iyx_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Mu taanga di bakuutu baa bayiri kwaa nde, nde wabaleeli: «Ubaanduu iluumbu kiatsiomi ki me natoori mu itinini kia Asia, beni diayiluu uyaaba ndiaatili a me nha kati a beni. ");
INSERT INTO iyx_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Me nasalili Pfumu mu ukuluu kwoosi, kutso matsanga na pasi di me namoni mu ndaa a mapfu-pfundu ma Bayuudayo. ");
INSERT INTO iyx_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Beni diayaaba ti, me a nasweyi pe ndaa so mosi ya mufunu kwaa beni. Me nayaabisi na nayiisi beni mioosi, mu manzo ma beni na nha kulu a baata boosi. ");
INSERT INTO iyx_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Me nati Bayuudayo na basi Eleene mu ukinguu kwaa Nziaambi na usa imiini mu Pfumu a bisi Yiisu. ");
INSERT INTO iyx_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Mu taanga di, me ndi mu uyene ku Yeruselemi, weti bu Muheebili wa Ngira ali mu utumu me, na a nayaaba pe mi mibwiilili me kuu. ");
INSERT INTO iyx_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ka ndila ti, mu pasi ngaanda, Muheebili wa Ngira aba mu uyaabisa me ti perese na mapasi bili mu ukebe me. ");
INSERT INTO iyx_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ka mu me, idiingi kia me a ili na ndutu pe. Kili na ndutu kwaa me, ni mu usukusu isala ki Pfumu Yiisu aha kwaa me: uyaabisa Ndaa Yimbwe ya bweese ba Nziaambi kwaa baata boosi.» ");
INSERT INTO iyx_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«Me nalabii nha kati a beni mu uyene ayaabisa Ipfumu kia Nziaambi, ka mu taanga di, me nayaaba ti so mosi mu beni a ubwamono me pe. ");
INSERT INTO iyx_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ni mu buu me nileele beni lolo li: so mosi mu beni diimbili, yii a yili ndaa a me pe. ");
INSERT INTO iyx_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ka me nadiyaabisi minhana mia Nziaambi mioosi, kwahele a uswee beni ndaa so mosi. ");
INSERT INTO iyx_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Diba likanda mu ndaa a beni bame, na mu ndaa mukaanga a mameme wu Muheebili wa Ngira aha beni mu ukebe. Diyiluu ukebe mukaanga mameme wu Nziaambi asuumbu mu tala ya makili ma mwaana a nde makulu. ");
INSERT INTO iyx_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Me nayaaba ti ku mbisi a nziendili a me, miminzi sa mikoto nha kati a beni na sa batsala mukaanga a mameme. ");
INSERT INTO iyx_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Na nha kati a beni, baata sa baleele mandaa ma pia, paa bakoo bangaa imiini mu uduku bo. ");
INSERT INTO iyx_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ni mu buu, diyele! Na dilibili moonyi ti, mu tsitsi a bilimi bitata, butsuu na nyanga, me a na koono pe ulibili moonyi so kutso matsanga, kwaa mosi-mosi mu beni.» ");
INSERT INTO iyx_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«Ka mu taanga di, me niyeelele beni kwaa Nziaambi na mu mandaa ma bweese ba nde. Nde li na lituu la ukulusu beni mu imiini, na uha mukobo kwaa boosi ba banambita mu nde. ");
INSERT INTO iyx_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Me a nasaa ubaa mboongo pe, so woolo, na so milwaata mia muutu pe. ");
INSERT INTO iyx_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Beni diayaaba beni bame ti me nasala mu mioo mia me, mu ubaa bi me na banduu ba me, diali na bio nzala. ");
INSERT INTO iyx_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Me nadilayi mu mioosi ti bubwe mu usala mbii buu, mu ndaa ubaasila bawele. Dilibili moonyi mu mandaa ma Pfumu Yiisu aleeli nde makulu: “Kinyi yili yavululu mu uha, ka a mu uyaka pe.”» ");
INSERT INTO iyx_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pawuli bu amani utsuu, nde atsukini na bo itwaari, na akuundi Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Boosi balili, babuumbi Pawuli, na bamunyumbiti mu uha nde mabweele. ");
INSERT INTO iyx_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Bo bavuli umono ngebe mundaa ti Pawuli aleeli kwaa bo ti bo a bubwamono nde pe. Tumake, bo bayiyili nde natee bu nde akoti mu bootu. ");
INSERT INTO iyx_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nha mbisi nha diakabii na bo, bisi diayeni ku iduku kia Kose mu bootu. Bukia ngwaali, bisi diayeni ku iduku kia Rodesi. Bu diamati kuu, bisi diatoori ku ngaanda ya Patara. ");
INSERT INTO iyx_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ku Patara, bisi diayibaasa bootu lakisabuu mubu mu uyene ku tsi ya Fenisi. Bisi diakoti mu lo na diayeni. ");
INSERT INTO iyx_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Mu taanga di diatoori bebele na iduku kia Kipiria, bisi diasiisi kio mu koo kia imbwoo, na diayeni ku peembi a tsi ya Siria. Bisi diatsikini nha ngaanda ya Tiro, mu usutulu mifunu miali mu bootu. ");
INSERT INTO iyx_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Bisi diabaasi bangaa imiini ku Tiro, na dialabisi biluumbu tsaamba itwaari na bo. Muheebili wa Ngira wabalibili mundaa Pawuli na bo bamuleeli ti, anyaala uyene ku Yeruselemi. ");
INSERT INTO iyx_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ka Biluumbu tsaamba bu bialabii, bisi diahami mu ubwaduku kuulu a bisi. Bo boosi bayiyili bisi itwaari na bakari na baana ba bo, natee ku mbari a ngaanda. Bu diatoori nha mukoo a mubu, bisi diatsukini na diakuundi Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Tumake, ku mbisi a uhelisine mabweele, bisi diakoti mu bootu, na bo bavutii ku manzo ma bo. ");
INSERT INTO iyx_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Midieenge mia bisi mia mu bootu miasuki bu diamati ku ngaanda ya Tiro, mu uto ku ngaanda ya Potolimayi. Kuu bisi diahi mabwe kwaa baana ba nguu na dialabisi iluumbu imosi na bo. ");
INSERT INTO iyx_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Mu iluumbu kiaduki, bisi diayeni na diatoori ku ngaanda ya Sezare. Bu diali kuu, diakoti na diadiaali mu nzo a muyiisi a Ndaa Yimbwe, kuumbu a nde Filipo. Nde ali mosi mu baata tsaamba ba basooli mu isala kia ukaba biloo kwa bakwiili ku Yeruselemi. ");
INSERT INTO iyx_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Filipo ali na baana bana ba banduumbu, ba bali keni a bavuutunu pe na babaala, bo bali na bungori ba mbilili. ");
INSERT INTO iyx_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Bisi diali nhaa, umatuu biluumbu bialaa. Mubili mosi, wa kuumbu Angabusi, amati ku itinini kia Yuuda, na ayiri nhaa. ");
INSERT INTO iyx_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nde ayimono bisi, aholi kobo a Pawuli, akuti bibolo mu miili na mu mioo mia nde makulu, na aleeli: «Mono miyaabisi Muheebili wa Ngira: Bayuudayo ku Yeruselemi sa bakutu ngaa kobo yi bibolo, weti bu beni dili mu umono bu, na sa bamuyeelele mu mioo mia bangooyi.» ");
INSERT INTO iyx_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nha mbisi a uyuu mandaa maa, bisi na baana ba nguu ba ku Sezare, diapeli Pawuli paa anyaala uyene ku Yeruselemi. ");
INSERT INTO iyx_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ka, Pawuli avutili aleeli: «Mu ima dili mu ulili na dili na nzala ya udeehese ibaala ki ndi na kio? Me namaayilimi, a ndila mu bibolo bi bukutu me pe, ka na mu ukwa ka ku Yeruselemi mu kuumbu a Pfumu Yiisu.» ");
INSERT INTO iyx_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ka bu diakooni usobo matsimi ma nde, bisi dianyaali, na dialeeli: «Nyaala litoono la Pfumu liyilima!» ");
INSERT INTO iyx_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Nha mbisi a ulabisa biluumbu kuu, bisi diayilimi mu usa midieenge na diayeni ku Yeruselemi. ");
INSERT INTO iyx_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Miyii mia ku Sezare miayiyili bisi kuu. Na bo babiti bisi ku nzo a muutu mosi wa kuumbu Naasoni ku bisi diafwaana ula. Nde ali musi Kipiria, na nde ali ngaa imiini umatuu bele pe. ");
INSERT INTO iyx_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Mu taanga di bisi diatoori ku Yeruselemi, baana ba nguu bayaki bisi mu kinyi. ");
INSERT INTO iyx_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Bukia ngwaali, Pawuli ayeni na bisi ku nzo a Yaakobi, kwali na mvuuntini a bakuutu ba libuundu boosi. ");
INSERT INTO iyx_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pawuli abii bo, na aleeli musama na yaki-yaki, mu mandaa moosi ma Nziaambi ayilii nha kati a bangooyi mu isala kia Pawuli. ");
INSERT INTO iyx_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Bu bamani uyuu nde, bo bakiinzi Nziaambi. Tumake baleeli kwaa Pawuli: «Mwaana a nguu a bisi, we li mu umono, buni mapfuundu ma Bayuudayo mamaasa imiini mu Pfumu Yiisu, kasi bo boosi keni bakangama mu Mikele mia Mooso. ");
INSERT INTO iyx_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ka mono bayaabisi kwaa bo ti we li mu uyene ayiisi kwaa Bayuudayo boosi, bali mu udiaala mu matsi ma bangooyi, banyaala utumumu mikele mia Mooso, banyaala ka ubwakese baana ba bo ba babaala, na banyaala ubwaduku bukulu ba Bayuudayo. ");
INSERT INTO iyx_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Nha ka buni bisi di sa? Mu ndaa ti bo sa bayuu ti we nha li! ");
INSERT INTO iyx_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Bubwe we yiluu mandaa ma bisi dileele kwaa we. Bisi dili nhana babaala bana, ba basa mulaba kwaa Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Yene na bo, tsieemese nyutu a we itwaari na bo. Futu mboongo mu bo paa bakuungulu bo naanga dia mutswe. Nha mbisi nhaa baata boosi sa bayaaba ti mabaleele mu we mali mandaa ma pia. Na sa buyabina ti we ka, li mu utumumu Mikele mia Mooso. ");
INSERT INTO iyx_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ka kwaa bangooyi ba bamaasa imiini, bisi diayaabisi bo mu mikaanda kesili dia bisi. Bo bafwaana mu uhele udia banyama ba baha bungori kwaa biteyi, udia pe makili, udia ka pe banyama babahele upalisa makili, na banyaala tsoongili.» ");
INSERT INTO iyx_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ni mu buu, Pawuli ayeni na babaala bana baa, na iluumbu kiaduki, bo boosi batsieemise manyutu ma bo. Tumake Pawuli akoti ku kati a lipaanga la nzo a Nziaambi mu uyaabisa kwaa ngaanga Nziaambi, ki taanga biluumbu bia tsieemini bikaasuku, pili mosi ti mu ki taanga bakaaha bungori kwaa Nziaambi mu mosi-mosi mu bo. ");
INSERT INTO iyx_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Biluumbu tsaamba bia tsieemini bu biali bika mu uwa, Bayuudayo bakimi ba ku itinini kia Asia, bamoni Pawuli mutso nzo a Nziaambi. Bo bakotisi butsa-butsa kutso koongi, paa bakaanga nde. ");
INSERT INTO iyx_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Bo baloyi: «Baata ba Iseraeli, dibaasila bisi! Monani muutu wuli mu uyiisi mu mambuu moosi na kwaa baata boosi paa bahele ukiinzi baata ba Iseraeli, Mikele mia Mooso na Nzo a Nziaambi yi. Na mu taanga di, nde maalooso na paa bangooyi mutso nzo a Nziaambi, na maasumunu mbuu ya Ngiri yi!» ");
INSERT INTO iyx_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Bo batsuyi buu, mundaa ti bu bo bamoni Pawuli itwaari na Trofimi musi Efeso mutso ngaanda ya Yeruselemi, bo batsimi ti Pawuli akotisi nde mutso nzo a Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Butsa-butsa bakoti mu ngaanda yoosi, na baata badumi matiini mu mapeembi moosi. Bakaangi Pawuli, na babiti nde ku mbari a lipaanga la nzo a Nziaambi. Nhaa-na-tsi, bo badibii minywa lipaanga. ");
INSERT INTO iyx_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Bu bakisaa udusu Pawuli, mvuungu yatoori kwaa mukuutu watsiomi wa masodaare ma Looma ti butsa-butsa bamaakoto mu Yeruselemi yoosi. ");
INSERT INTO iyx_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Mawasa-mawasa, nde aholi masodaare na bakuutu ba bo, na adumi tiini mu uyene kwali koongi. Bu bamoni mutumi a masodaare na masodaare, bo banyaali utete Pawuli. ");
INSERT INTO iyx_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ni mu buu, mukuutu a masodaare wa tsiomi bu asweesi nha peembi a Pawuli, atumi bakaanga na bakutu nde bibolo mikuru mioolo mia bitali. Tumi nde asiayi mu uyaaba muutu wu nde na ali, na nde ima ayiluu. ");
INSERT INTO iyx_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ka kutso koongi, baata ba bamosi bakiloo mu uleele ndaa mosi, na bana mu uleele ndaa kimi. Mukuutu masodaare me wuu, a atuuyi uyaaba ndaa so mosi pe yi bakitete Pawuli nha kati a butsa-butsa baa. Ni mu buu, nde atumi babiti Pawuli ku nzo a masodaare. ");
INSERT INTO iyx_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Mu taanga di Pawuli atoori nha yulu a ikaari, masodaare mamunaangili mundaa ti koongi yakitsimi uyiluu nde bubi. ");
INSERT INTO iyx_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ka boosi bakiduku nde mu uyene aloo: «Diamudusu!» ");
INSERT INTO iyx_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Mu taanga dibakee ukotoso Pawuli mutso nzo a masodaare, nde aleeli kwaa mukuutu a masodaare wa tsiomi: «Ndi na muswa mu uleele we ndaa?» Nde wamufuuli: «We ayaaba utsuu ndaa ya basi Eleene? ");
INSERT INTO iyx_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","We a ni musi Ngipiti wakotisi butsa-butsa mu biluumbu bialabii bi pe, na wabiti ku tsi ya tsata mafuundu mana ma bipunga-pungu pe?» ");
INSERT INTO iyx_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pawuli avutili: «Me Muyuudayo, nabutuu mu ngaanda Tarasi, ngaanda yayabina kwalaa, mu itinini kia Silisi. Ni mu buu, kolokolo a we, ha me muswa mu utsuu kwaa koongi.» ");
INSERT INTO iyx_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Mukuutu a masodaare wamuhi muswa. Pawuli atemini nha yulu a ikaari, anaangili koo paa koongi yiba na pii. Baata boosi bawuri, na nde wabatsuyi mu ndaa ya Bayuudayo. ");
INSERT INTO iyx_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Baana ba nguu ba me na bataayi ba me, diyuu ma me ndi na mo ma uleele beni mu taanga di mundaa ukala nyutu a me.» ");
INSERT INTO iyx_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Bu bo bayuyi ti nde li mu utsuu kwaa bo mu ndaa ya Bayuudayo, bo badiaali na pii. Ni mu buu, Pawuli aleeli: ");
INSERT INTO iyx_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Me Muyuudayo ndi, me nabutuu ku Tarasi, mu itinini kia Silisi. Ka me nha Yeruselemi nha nakulu, na Ngamalieele ali muyiisi a me, na nde ayiisi me mu uyaaba bubwe-bubwe mikele mia bakaa ba bisi. Me nali ka nakangama mu mifuri mioosi mu Nziaambi weti bu beni dili lolo li. ");
INSERT INTO iyx_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Me nakwaamisi natee mu iteesi kia likwa, ba bakiduku Kuulu a Pfumu. Me natumu mu ukaanga na ulooso perese bakaasa na babaala. ");
INSERT INTO iyx_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Nguu a bangaanga ba Nziaambi, na pfuundu a ikuutu kioosi, utuu uta imbaangi ti me ngwanya ndi mu uleele. Bo batsindii kwaa baana ba nguu ba ku Damaseko me na bahi me mikaanda, mimiha me muswa mu uyene ku ngaanda yii, mu yakaanga baata baa, na ubee bo ku Yeruselemi paa bafuundusu bo.» ");
INSERT INTO iyx_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«Me ali mu kuulu, na me nakibesene na ngaanda ya Damaseko. Itsundu-a-tsundu ku peembi a nguungu ya nzanga, liyalila la mifuri lamati ku yula ladiengilili me peembi na peembi. ");
INSERT INTO iyx_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Me nabwi nha tsi, na nayuyi muniingi a ndaa wakileele kwaa me: “Sawuli, Sawuli, mu ima we li mu ubingisi me?” ");
INSERT INTO iyx_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Me nafuuli: “We na li, Pfumu?” Muniingi a ndaa avutili: “Me ni Yiisu musi Nazareti wu we li mu ubingisi.” ");
INSERT INTO iyx_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ba bali itwaari na me bamoni liyalila, ka bo a bayuyi pe muniingi a ndaa a muutu wakitsuu kwaa me. ");
INSERT INTO iyx_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ni mu buu, me nafuuli: “Ima me nafwaana usa, Pfumu?” Na Pfumu aleeli kwaa me: “Temene yene ku Damaseko, na kuu sa baleele we mioosi mi Nziaambi utumu we mu usa.” ");
INSERT INTO iyx_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Bu liyalila la mifuri lii lakitisi me ingima-ngimi, ba bali itwaari na me bakaangi me mu koo, na babiti me ku Damaseko. ");
INSERT INTO iyx_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Kuu kwali na muutu mosi wa kuumbu Anania, muutu ngaa likiinzi la Nziaambi na wali akangama mu mikele mia bisi, na Bayuudayo boosi ba ku Damaseko bakita imbaangi ki ibwe mu nde. ");
INSERT INTO iyx_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Nde ayiri kwaa me, atemini nha peembi a me, na aleeli kwaa me: “Sawuli, mwaana a nguu a me, nyaala ti we bwamono!” Nhaa-na-tsi me nabwibaanduu umono, na me namoni nde. ");
INSERT INTO iyx_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Nde abwileele: “Nziaambi a bakaa ba bisi, akwasoolo we paa we yaaba litoono la nde, we mono nde Ngaa libweeye, na we yuu muniingi a ndaa a nde. ");
INSERT INTO iyx_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ka we afwaana uba mbaangi a nde nha kulu a baata boosi, mu uyaabisa moosi ma we moni na ma we yuyi. ");
INSERT INTO iyx_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Na mu taanga di, we ima li mu ubwakebe? Temene, holo libootuu na ta kuumbu a nde mbili, paa we tsieeme mu masumu ma we.”» ");
INSERT INTO iyx_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«Me navutii ku Yeruselemi. Bu me nakikuundu mu nzo a Nziaambi, me nabayi monini. ");
INSERT INTO iyx_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Me namoni Pfumu, na nde aleeli kwaa me: “Sa mawasa pala mu Yeruselemi, ka basi ngaanda yi a busiingi imbaangi kia we mu me pe.” ");
INSERT INTO iyx_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Me navutili: “Pfumu, bo bayaaba bubwe ti me nakiyene mu pasi nzo a makutunu ma Bayuudayo, mu ulooso bakisa imiini mu we mu perese, na utete bo. ");
INSERT INTO iyx_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Na mu taanga di badusi Estefano mbaangi a we, me ka nali nhaa. Me nasiingisi miayilii ba badusi nde, na me makulu wakikaanga bikutu bia bo.” ");
INSERT INTO iyx_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ni mu buu, Pfumu aleeli kwaa me: “Yene, ka me sa tsinduu we kula, kwaa bifuumbu bili mu matsi makimi!”» ");
INSERT INTO iyx_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Koongi yayuyi Pawuli natee bu nde amani uleele mandaa maa. Ka ni mu buu, boosi baloyi na baleeli: «Didusu nde! Muutu wa pili yi a afwaana mu uba moonyi nha tsini a toto nha pe.» ");
INSERT INTO iyx_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Bo bakiloo mu mifuri, bakidulu biyungu, bakiwisi bio ku yulu na bakinaangala lifuundu. ");
INSERT INTO iyx_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Mukuutu a masodaare ahi litumu la ukotoso Pawuli kutso lipaanga la nzo a masodaare, na utete nde bikoti, paa atsuu mu ki toono koongi yakiloo mu mifuri mu ndaa nde. ");
INSERT INTO iyx_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ka bu bamukuti mikuru paa bamutete bikoti, Pawuli aleeli kwaa mukuutu a kama masodaare wali nhaa: «Beni dili na muswa wa utete musi Looma bikoti kwahele a ukwafuundusu nde?» ");
INSERT INTO iyx_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Mukuutu a masodaare bu ayuyi buu, nde ayiyaabisa kwaa mukuutu wa tsiomi, wamuleeli: «Ima we tooni usa? Muutu wu musi Looma ali!» ");
INSERT INTO iyx_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Mukuutu wa tsiomi ayeni nha peembi a Pawuli na wamufuuli: «Leele me, ngwanya we musi Looma li?» Pawuli avutili: «Ee, ni buu!» ");
INSERT INTO iyx_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ni mu buu, mukuutu wu aleeli: «Me nahi mboongo dialaa mu uba musi Looma.» Ka Pawuli avutili: «Ka me musi Looma umata mbutili a me.» ");
INSERT INTO iyx_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Nhaa-na-tsi, babakeni utete Pawuli paa atsuu, batakii na nde. Bu nde ayaabi ti Pawuli musi Looma ali, mukuutu abayi boomo, mundaa ti nde ahi litumu la ukutu musi Looma bibolo mu mikuru mia bitali. ");
INSERT INTO iyx_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Mukuutu a masodaare wa tsiomi ali na nzala ya uyaaba bubwe, mu ki toono Bayuudayo bafuundi Pawuli. Ni mu buu, iluumbu kiaduki, nde atumi bamunyangila bibolo bia mu mikuru mia bitali, na atumisi banguu ba bangaanga ba Nziaambi, na pfuundu a bakuutu ba Bayuudayo boosi. Nha mbisi nde abeyi Pawuli na bamutemisi nha kulu a bo. ");
INSERT INTO iyx_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pawuli atali pfuundu a bakuutu ba Bayuudayo isooso, na aleeli: «Baana ba nguu bame, mu me, me ndi mu usalila Nziaambi, mu matsimi masuungunu na mu bunyanga boosi, umata bele pe natee iluumbu ki.» ");
INSERT INTO iyx_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Nguu a bangaanga ba Nziaambi wa kuumbu Anania, atumi ba bali nha peembi a Pawuli, mu utete nde nha munywa. ");
INSERT INTO iyx_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ka Pawuli aleeli kwaa nde: «Muutu ngaa peluu, ka Nziaambi sa atete we! We adiaala nhaa mu ufuundusu me weti buli mikele, ka we makulu ali mu utumumu pe mikele, bu we maatumu ti batete me!» ");
INSERT INTO iyx_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ba bali nha peembi a Pawuli bamuleeli: «We li mu utuu nguu a bangaanga ba Nziaambi!» ");
INSERT INTO iyx_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pawuli avutili: «Baana ba nguu bame, me aba a nayaaba pe ti nde nguu a bangaanga ba Nziaambi ali. Ka bunu, mandaa ma Nziaambi mali mu uleele ti: “Atsuu ma mabi mu mukuutu a koongi a baata ba we pe!”» ");
INSERT INTO iyx_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pawuli ali ayaaba ti kutso pfuundu a bakuutu ba Bayuudayo, ba bamosi ali Basaduki, na bakimi ali Bafarisi. Ni mu buu nde aloyi nha kulu a bo: «Baana ba nguu bame, me ndi mu Mufarisi, mwaana a Bafarisi. Mu ndaa ti me na sa ilimbisi mu tsimbilili a babakwa, ni bali mu ufuundusu me.» ");
INSERT INTO iyx_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Nde bu amani uleele buu, Bafarisi na Basaduki babaandii ukaama, na kabini yakoti mutso pfuundu a ikuutu. ");
INSERT INTO iyx_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Kabini yii ya yiri mundaa ti Basaduki bakileele ti tsimbilili a babakwa yo pe, so batumu ba Nziaambi bo pe, so miheebili ka mio pe. Ka Bafarisi bakileele ti bi bioosi bia ngwanya bili. ");
INSERT INTO iyx_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Kele yinene ya yuyini, na ndaamba a bayiisi ba mikele, ba ku kaba la Bafarisi, batemini, baleeli mu mifuri mioosi: «Bisi a dimoni ndaa yimbi so mosi mu muutu wu pe, helape tumu a Nziaambi so a buu pe muheebili tsuyi kwaa nde!» ");
INSERT INTO iyx_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Kaama bu lavuli mifuri, mukuutu a masodaare abayi boomo ti sa bakese Pawuli bitsuru-bitsuru. Ni mu buu nde atumi masodaare mu usutuu, bapalisa Pawuli nha kati a bo, na babiti nde ku lipaanga lili nzo a masodaare. ");
INSERT INTO iyx_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Mu butsuu baduki, Pfumu amonii kwaa Pawuli na wamuleeli: «Ba na ibaala! We maata imbaangi mu me nha Yeruselemi nha, we afwaana ka uta imbaangi mu me ku Looma.» ");
INSERT INTO iyx_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Bukia ngwaali, Bayuudayo bakimi bakuti pfuundu: balabi mukisi ti bo a bunywa pe na a budia ka pe so iloo imosi natee bu bo budusu Pawuli. ");
INSERT INTO iyx_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Litaanga la ba bakuti pfuundu yii ali lalutu maku mana ma baata. ");
INSERT INTO iyx_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Bo bayimono banguu ba bangaanga ba Nziaambi na bakuutu ba Bayuudayo, na baleeli kwaa bo: «Bisi dimaalaba mukisi ti bisi a dibwadia iloo so imosi pe, natee bu bisi didusu Pawuli. ");
INSERT INTO iyx_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Ni mu buu, beni diloombo muswa kwaa mukuutu a masodaare wa tsiomi, mu kuumbu a pfuundu a bakuutu ba Bayuudayo, mu ubee Pawuli, weti so beni dili na nzala ya ukengese ndaa a nde bubwe-bubwe. Bisi diamaa lebuu nde mweete na diamayilimi mu udusu nde, tswaamina nde uto nhaa na nha.» ");
INSERT INTO iyx_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ka nzaba a Pawuli wa baala, mwaana a keri a nde, ayuyi pfuundu yii, ayeni ku lipaanga la masodaare, akoti na ayaabisi yo kwaa Pawuli. ");
INSERT INTO iyx_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ni mu buu, Pawuli ati mosi mu bakuutu ba kama masodaare mbili na wamuleeli: «Biti mufuru a baala wuunawu kwaa mukuutu a masodaare wa tsiomi, ka nde li na ndaa ya uyaabisa kwaa nde.» ");
INSERT INTO iyx_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Mukuutu wuu a ayeni na nde, wamubitii kwaa mukuutu a masodaare wa tsiomi, na aleeli: «Pawuli wuli mosi mu makori, ata me mbili na aleele kwaa me mu ubee mufuru a baala wuunawu kwaa we, nde li na ndaa ya uleele we.» ");
INSERT INTO iyx_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Mukuutu a masodaare aholi mufuru a baala mu koo, ayeni na nde nha peembi, na wamufuuli: «Ki ndaa we tooni uleele me?» ");
INSERT INTO iyx_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Nde wamuvutili: «Bayuudayo bamaayuhusunu mu uloombo kwaa we mu ubiti Pawuli nha ngwaali, nha kulu a pfuundu a bakuutu ba bo. Bo sa basaa we ufutu ti bo bali na nzala ya ukengese ndaa a nde bubwe-bubwe. ");
INSERT INTO iyx_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","We beeri keni uli asiingi ndoombili a bo pe, mundaa ti maku mana ma baata na baata bakimi nha kati a bo sa balebuu nde mweete. Bo balaba mukisi mu unyaala udia, na unyaala unywa natee bu budusu Pawuli. Mu taanga di, bo bamaayilimi na ndila kesili a we bali mu ukebe.» ");
INSERT INTO iyx_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Nha mbisi a uleele kwaa mufuru a baala mu unyaala uyaabisa kwaa muutu so mosi, mandaa ma mufuru wuu ayaabisi nde, mukuutu a masodaare wa tsiomi wamuvutili ku amati. ");
INSERT INTO iyx_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Nha mbisi a nhaa, mukuutu a masodaare ati bakuutu boolo bakimi mbili, na wabaleeli: «Dikukuu makama moolo ma masodaare, maku-tsaamba ma masodaare ma mubaabiti basevaala, makama moolo ma masodaare bali mu udwaana mu mayoo, na diyilimi beni boosi mu uyene ku Sezare, mu nguungu ya wa ya butsuu. ");
INSERT INTO iyx_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Diyiluu ka basevaala ba bubiti Pawuli peembe-polo kwaa mutumi Feliki.» ");
INSERT INTO iyx_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Nha mbisi a nhaa, nde asonii mukaanda weti bu: ");
INSERT INTO iyx_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Taata Feliki, mutumi a itinini, yaka mabwe mamati kwaa me Kolodo Lisiasi. ");
INSERT INTO iyx_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Bayuudayo aba bakaanga muutu wu me ndi mu utsinduu kwaa we wu, na bakeni udusu nde. Ka mu taanga di me nayaabi ti nde musi Looma, me nayeni itwaari na masodaare ma me, na me nakuuli nde. ");
INSERT INTO iyx_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Me bu nali na nzala ya uyaaba toono yi Bayuudayo bakifuundu nde, me nabiti nde nha kulu a pfuundu a bakuutu ba bo. ");
INSERT INTO iyx_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Me namoni ti bo bakifuundu nde, mu mandaa matala mikele mia bo makulu. Ka nde a ayiluu ndaa yimbi pe, yi bafwaana udusu nde so ulooso nde mu perese. ");
INSERT INTO iyx_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Na bu bayaabisi me ti Bayuudayo bakisa pfuundu ya ulebuu nde mweete mu udusu nde, mawasa-mawasa, me naholi kesili ya utsinduu nde kwaa we, na me naleeli kwaa bo, bayafuundu nde kwaa we.» ");
INSERT INTO iyx_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Masodaare mayilii weti bwali litumu li bo bayaki: bo baholi Pawuli na bamubiti ku ngaanda Antipatirisi mu butsuu. ");
INSERT INTO iyx_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Iluumbu kiaduki, masodaare ma makiyene mu miili mavutii ku lipaanga la bo. Ka masodaare makibiti basevaala mahami mu uyene kuulu mosi na Pawuli. ");
INSERT INTO iyx_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Bu bo batoori ku Sezare, masodaare me mayakisi mukaanda kwaa mu mutumi Feliki na bamumweesi Pawuli. ");
INSERT INTO iyx_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Mutumi ataangi mukaanda, na afuuli Pawuli nde wa ki itinini ali. Bu ayaabi ti Pawuli ali musi itinini kia Silisi, ");
INSERT INTO iyx_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","nde wamuleeli: «Me sayuu we mu taanga di ba bafuundu we bakaato.» Tumake nde ahi litumu la ukebe Pawuli kutso lipaanga la nzo a mutini Erode. ");
INSERT INTO iyx_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Nha mbisi a biluumbu bitaana, Anania nguu a bangaanga ba Nziaambi atoori itwaari na ndaamba a bakuutu ba Bayuudayo, na nzioonzi mosi kuumbu a nde Teritulusi. Bo bamonii nha kulu a mutumi Feliki, mu uyafuundu Pawuli. ");
INSERT INTO iyx_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Babeyi Pawuli, na Teritulusi abaandii ufuundu nde mbii bu: «Mukuutu Feliki, mundaa we bisi dili na iyeenge kiafwaana, na mundaa buyeri ba we, tsiobili yimbwe yikoti mu tsi yi na mandaa ma bisi boosi mamaabweye. ");
INSERT INTO iyx_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Bisi ditooni we kwalaa taata Feliki, mu mioosi mi bisi dili mu uholo mu taanga dioosi na mu mambuu moosi. ");
INSERT INTO iyx_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ka me a natoono ulabisa we taanga pe, ni mu buu, me ndoombi we kolokolo mu uyuu bisi, mu mwaana taanga hoolo. ");
INSERT INTO iyx_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Bisi dimoni ti muutu wu ngo mubi ali, isala kia nde mu ulooso butsa-butsa nha kati a Bayuudayo boosi, mu tsi yoosi. Nde mukuutu a libuundu la ndiimbisi la basi Nazareti. ");
INSERT INTO iyx_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","7","Nde asiayi usumunu bungiri ba Nzo a Nziaambi, ni mu buu, bisi diakaangi nde. ");
INSERT INTO iyx_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","So we fuuli nde manduru, we sa mono ti, mandaa moosi ma bisi dili mu ufuundu nde mali ma ngwanya.» ");
INSERT INTO iyx_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Bayuudayo basilili mifuundu mii, na baleeli ti mili mia ngwanya. ");
INSERT INTO iyx_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ni mu buu, mutumi Feliki ahi Pawuli muswa mu utsuu, na Pawuli aleeli: «Me nayaaba ti, we li mu uyiluu mandaa kutso libweeye mu tsi a bisi umata bilimi bialaa. Ka ni mu ilimbisi me tooni ukala nyutu a me nha kulu a we. ");
INSERT INTO iyx_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","We makulu utuu usaa makuulu ma uyaaba ti, biluumbu kuumi na bioolo keni a bialabuu pe umatuu bu me natoori ku Yeruselemi, mu ukiinzi Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Muutu so mosi pe wamono me ti ndi mu ukaama na baata, so a buu pe, ndi mu utsindi baata mu usa butsa-butsa mutso nzo a Nziaambi, so mu manzo ma makutunu ma Bayuudayo, so ku kati a ngaanda. ");
INSERT INTO iyx_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Baata ba a butuu pe umweese we ti mandaa ma bali mu ufuundu me mu taanga di mali ma ngwanya. ");
INSERT INTO iyx_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ka me siingi nha kulu a we ti: me ndi mu usalila Nziaambi a bakaa ba bisi. Na me na sa imiini mu mioosi mi basonuu mu Mikele na mu mikaanda mia Mibili. Ka me ndi mu uduku Kuulu a Pfumu, ni Kuulu yii, yi bo bali mu uleele ti libuundu la ndiimbisi. ");
INSERT INTO iyx_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Me ndi na ilimbisi mu Nziaambi, ilimbisi ki bo makulu ka bali na kio, ti baata boosi bababwe na bababi sa basiimbuu mu likwa. ");
INSERT INTO iyx_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ni mubuu, me ndi mu usa mifuri mu udiaata taanga dioosi weti bwafwaana na mutimi watsieeme, nha kulu a Nziaambi, na nha kulu a baata.» ");
INSERT INTO iyx_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«Nha mbisi a bilimi bialaa, bi me na labisi mu matsi makimi, me navutii ku Yeruselemi, mu ubee libaasila kwaa baata ba me, na uha bungori kwaa Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Mu taanga di bo bayibaasa me mu nzo a Nziaambi, me ali mu utsieemese nyutu ame. Koongi a baata a yali nhaa pe, na butsa-butsa ka ali bo pe. ");
INSERT INTO iyx_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ka ndila ndaamba a Bayuudayo ba itinini kia Asia bali nhaa, na ni bo bakeni uyafuundu me kwaa we, mbiiti bo bali na ndaa na me. ");
INSERT INTO iyx_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","So a buu pe, baata babali nha, bu bo bakifuundusu me nha kulu a pfuundu a ikuutu, baleele ki ndaa yimbi bo bamoni mu me. ");
INSERT INTO iyx_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ndaa yoosi utuu uba mu mi me nayaabisi mu mifuri nha kulu a bo, bu naleeli: “Mu ndaa ti me na sa ilimbisi mu tsimbilili a babakwa, ni bali mu ufuundusu me lolo li nha kulu a beni.”» ");
INSERT INTO iyx_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feliki, wali wayaaba bubwe ndaa yatala Kuulu a Pfumu, a atooni ukese ndaa yii iluumbu kii pe, na aleeli kwaa bafuundi: «Me sa kese ndaa a beni bu mukuutu a masodaare wa tsiomi Lisiasi akaayira.» ");
INSERT INTO iyx_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Nde atumi kwaa mukuutu a masodaare mu ukebe Pawuli mu perese, na uha nde mwaana bunyanga hoolo paa banduu ba nde babaa muswa wa ubaasila nde. ");
INSERT INTO iyx_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Nha mbisi a mwaana biluumbu, Feliki ayiri na mukari a nde Durusili wali Muyuudayo. Nde atumisi Pawuli na ayuyi nde mu miatala imiini mu Yiisu Kristo. ");
INSERT INTO iyx_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ka mu taanga di Pawuli abaandii utsuu mu ndaa yatala ndiaatili yafwaana nha kulu a Nziaambi, mu kamini a mutimi, na mu pfuundisi yikaayira, Feliki abayi boomo, na aleeli kwaa nde: «We utuu uyene wa we mu taanga di. Me sa bwata we mbili nha me nibaa taanga.» ");
INSERT INTO iyx_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Nde atsuuyi buu, mundaa ti nde ali na ilimbisi ti, Pawuli sa aha nde mboongo, ni mu buu nde akitumusu nde taanga dioosi paa ayolo na nde. ");
INSERT INTO iyx_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Nha mbisi a bilimi bioolo, Porosiwu Festusi akiti nha mbuu ya Feliki. Ka bu ali atoono umonuu wu mubwe nha kulu a Bayuudayo, Feliki anyaali Pawuli mu perese. ");
INSERT INTO iyx_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Biluumbu bitata nha mbisi a nha badiasi nde nha mbata a ipfumu ku ngaanda ya Sezare, mutumi wu mu nyatii, Festusi ayeni ku Yeruselemi. ");
INSERT INTO iyx_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ni kuu, Banguu ba bangaanga ba Nziaambi na bakuutu ba Bayuudayo, bayiri mu uyafuundu Pawuli. Bo baloombi kwaa Festusi ");
INSERT INTO iyx_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","mu uha bo bweese ba ubwavutuu na Pawuli ku Yeruselemi, mundaa ti bo ali bamakutu pfuundu ya ulebuu nde mweete paa badusu nde mu kuulu. ");
INSERT INTO iyx_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ka Festusi avutili ti Pawuli li mu perese ku Sezare, na mu mwaana biluumbu hoolo, nde makulu Festusi sa avutuu kuu. ");
INSERT INTO iyx_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Nde abwileele: «Nyaala bakuutu ba beni bayene itwaari na me ku Sezare, paa bafuundu muutu wu kuu, mbiiti nde ayiluu ndaa yimbi.» ");
INSERT INTO iyx_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festusi alabisi ndila biluumbu pwoombo so a buu pe kuumi kwaa bo, tumake, nde avutii ku Sezare. Iluumbu kiaduki, nde adiaali mu nzo a pfuundisi, na atumi babee Pawuli. ");
INSERT INTO iyx_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Mu taanga di nde ayiri, Bayuudayo babamati ku Yeruselemi bamudiengilili na bamufuundi mu mandaa malaa matsitsi, ma bo makulu a batuyi pe mu uta imbaangi mu mo. ");
INSERT INTO iyx_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ka Pawuli akali nyutu a nde bu aleeli: «Me a nayiluu ndaa yimbi so mosi pe, nha kulu a mikele mia Bayuudayo, so nha kulu a Nzo a Nziaambi, so nha kulu a mutini Kayisari.» ");
INSERT INTO iyx_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festusi bu ali atoono umonuu muutu wumubwe nha kulu a Bayuudayo, afuuli Pawuli: «Buni, tooni wa we mu uyene ku Yeruselemi, paa bafuundusu we, nha kulu a me mu ndaa yii?» ");
INSERT INTO iyx_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pawuli avutili: «Me ndi nha kulu a mbata a pfuundisi a mutini, ninha ka bafwaana ufuundusu me. Me a nayiluu ndaa yimbi nha kulu a Bayuudayo pe, weti bu we makulu ayiluu uyaaba bubwe-bubwe. ");
INSERT INTO iyx_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Mu mioosi mi bali mu ufuundu me, mbiiti me nasa bubi, na mbiiti me nayiluu ndaa yi me nafwaana ukwa mu yo, me a nibisi pe ukwa. Ka so a uli pe na ndaa ya ngwanya mu mifuundu mia baata ba mu me, muutu so mosi pe wuli na muswa mu uyeelele me kwaa bo. Me ndoombi ti mutini Kayisari akese ndaa a me.» ");
INSERT INTO iyx_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ni mubuu Festusi, bu amani utsuu na baata ba pfuundu a nde, avutili: «We loombi ti mutini Kayisari afuundusu we, ka we nha kulu a nde uyene.» ");
INSERT INTO iyx_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Biluumbu holo bu bialabii, mutini Angiripa na keri a nde Berinise, batoori ku Sezare mu ubii Festusi. ");
INSERT INTO iyx_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Bu bali na biluumbu bialaa bia ulabisa kuu, Festusi ayaabisi ndaa a Pawuli kwaa mutini, bu wamuleeli ti: «Nhaa na nha uli na muutu mosi wu Feliki asiisi mu perese. ");
INSERT INTO iyx_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Mu taanga di me nayeni ku Yeruselemi, banguu ba bangaanga ba Nziaambi, na bakuutu ba Bayuudayo bamufuundi na baloombi kwaa me mu uha nde tsieembili. ");
INSERT INTO iyx_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Me navutili kwaa bo ti, basi Looma a bali pe na ipfu kia uyeelele muutu ku nzo a pfuundisi, mbiiti nde keni a abaa pe taanga dia ukala nyutu a nde nha kulu a bambeeni ba nde, mu mi bali mu ufuundu nde. ");
INSERT INTO iyx_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Ni mu buu bo boosi bayiri na me nha. Mu uhele ulabisa taanga dialaa, bukia ngwaali, me nayidiaala mu nzo a pfuundisi na me natumi babee me muutu wuu. ");
INSERT INTO iyx_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Bambeeni ba nde batemini mu ufuundu nde, ka mifuundu mia bo a miamweese pe ti nde ayiluu mandaa ma mabi, weti bu me naba mu ukebe. ");
INSERT INTO iyx_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ka bo bakikaama na nde ndila mu miatala libuundu la bo, na mu ndaa muutu moosi wa kuumbu Yiisu, wakwiiri, na wu Pawuli ali mu uyaabisa ti nde moonyi akeni. ");
INSERT INTO iyx_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ka me a namoni pe buni me nituu utaba ndaa yi, ni mu buu me nahi tsimi kwaa Pawuli mu uyene ku Yeruselemi paa bamufuundusu kuu. ");
INSERT INTO iyx_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ka Pawuli aloombi ti mutini a basi Loma afuundusu nde. Ni mu buu me natumi ti bamukebe mu perese natee bu me nitsinduu nde kwaa mutini Kayisari.» ");
INSERT INTO iyx_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Angiripa aleeli kwaa Festusi: «Me natoono uyuu muutu wu me makulu.» Festusi avutili: «Nha ngwaali we kaayuu nde.» ");
INSERT INTO iyx_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ni mu buu, bukia ngwaali, Angiripa na Berinise bayiri na batsieengi ba bo kutso lidumu loosi li bali mu uha kwaa ba pfumu. Bobakoti mutso nzo a pfuundisi na bakuutu ba masodaare na bakuutu ba ngaanda ba buzitu. Mu litumu la Festusi, babeyi Pawuli. ");
INSERT INTO iyx_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Tumake Festusi aleeli: «Mutini Angiripa na beni boosi badili nhana bisi, dimono muutu wu. Bayuudayo boosi, bayiri mu ufuundu nde kwaa me, umata ku Yeruselemi, natee nhaa na nha. Bo bali mu uloo na bali mu uleele ti nde a abwafwaana pe mu uba moonyi. ");
INSERT INTO iyx_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ka me moni ti, nde a ayiluu toono so moosi pe yi bafwaana udusu nde. Ka nde makulu, aloombo ti mutini a basi Looma afuundusu nde. Ni mu buu, mu ndaa mandaa ma ndeme aleeli, me naholo kesili ya utsinduu nde kwaa mutini. ");
INSERT INTO iyx_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ka me a ndi na ndaa ya mufunu ya usonuu kwaa mutumi a basi Looma mu toono a nde pe. Ni mu buu me mbeyi nde nha kulu a beni, na vulu-vulu nha kulu a we, mutini Angiripa, paa ti nha mbisi a manduru ma bufuulu nde, me baa ndaa ya usonuu. ");
INSERT INTO iyx_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ni mu buu, bubwe pe kwaa me, mu utsinduu kori ku Looma kwahele a ubiindili bubwe-bubwe matoono moosi ma bali mu ufuundu nde.» ");
INSERT INTO iyx_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Mutini Angiripa aleeli kwaa Pawuli: «We li na muswa mu utsuu mu ndaa ukala nyutu a we.» Ni mu buu, Pawuli anaangili koo kia nde, mu ubaanduu utsuu weti bu: ");
INSERT INTO iyx_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Mitini Angiripa, me ndi na kinyi lolo li mu ukala nyutu a me nha kulu a we mu mioosi mi Bayuudayo bali mu ufuundu me, ");
INSERT INTO iyx_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","bu uli ti we ayiluu uyaaba bubwe-bubwe bukulu ba Bayuudayo na mandaa ma makaama ma bo. Ni mu buu me ndoombi kwaa we mu uyuu me kutso kamini a mutimi.» ");
INSERT INTO iyx_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«Umata bufuru ba me, Bayuudayo boosi bayaaba bwali ndiaatili a me, na buni me nadiaali nha kati a baata ba me, ubaanduu ku tsi yi babutu me natee bu me na kuli ku Yeruselemi. ");
INSERT INTO iyx_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Bo bayaaba me umata bele pe, na bo makulu utuu uta imbaangi, so bo batoono, ti me nali inama mu kaba la Bafarisi. Na Bafarisi ni ba bavulu ukangama mu mikele mia Bayuudayo nha kulu a ma kaba mana moosi.» ");
INSERT INTO iyx_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","«Na mu taanga di, me ndi nha kulu a pfuundisi mundaa ti, me na sa ilimbisi mu lilasina li Nziaambi asi kwaa bakaa ba bisi. ");
INSERT INTO iyx_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Bifuumbu kuumi na bioolo bia baata ba bisi ba sa ilimbisi mu umono nzilimini a lilasina lii, bu bali mu usalila Nziaambi mutso pamini butsuu na nyanga. Ni mu ndaa ilimbisi kii, mutini a me, Bayuudayo bali mu ufuundu me! ");
INSERT INTO iyx_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Mu ima beni Bayuudayo dili mu usa paa ti, Nziaambi utuu usiimbili babakwa? ");
INSERT INTO iyx_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Me makulu ka, nakitsimi ti me nafwaana udwaanisa mu makuulu moosi, baata babali mu utaangila kuumbu a Yiisu musi Nazareti. ");
INSERT INTO iyx_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Maa, ni ma me nayilii ku Yeruselemi. Banguu ba bangaanga ba Nziaambi bahi me muswa, na me naloosi bangaa imiini balaa mu perese. Na mu taanga di bakikese bo tsieembili ya likwa, me nakisilili. ");
INSERT INTO iyx_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Mutaanga dioosi, bu me nakilabuu mu manzo ma makutunu ma Bayuudayo moosi, me nakimweese bo pasi na me nakibamuu bo mu usibi Nziaambi kwalaa. Kesi a me ya mifuri nha yulu a bo yabiti me mu ubingisi bo natee mu magaanda ma bumweenyi.» ");
INSERT INTO iyx_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«Ni mu buu me nayeni ku ngaanda ya Damaseko, mu litumu na muswa bi banguu ba bangaanga ba Nziaambi bahi me. ");
INSERT INTO iyx_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Mutini a me Angiripa, bu me nali mu kuulu, mu nguungu ya nzanga, me namoni liyalila lamati ku yula, lavulu nyanga mu ungeyene, ladiengilili me na layalisi me na bambaayi ba me ba midieenge. ");
INSERT INTO iyx_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Bisi boosi diabwi nha tsi na me nayuyi muniingi a ndaa wakileele me mu ndaa ya Bayuudayo: “Sawuli, Sawuli! Mu ima we limubingisi me? Ka mu ibuu we li mu udwaana weti iboori kili mu uhele utumumu pfumu a nde wakaanga muti mu usuungusu nde mu kuulu.” ");
INSERT INTO iyx_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Me nafuuli: “We ni na Pfumu?” Na Pfumu avutili kwaa me: “Me ni Yiisu, wu we li mu ubingisi. ");
INSERT INTO iyx_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ka siimbuu, na temene. Me monii kwaa we paa we ba musiali a me. We sa ba mbaangi a me mu uyaabisa buni we moni me lolo li, na uyaabisa ma me nibwamweese kwaa we. ");
INSERT INTO iyx_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Me sa kuulu we mu mioo mia Bayuudayo na mu mioo mia bifuumbu bikimi, ku me kaatsinduu we. ");
INSERT INTO iyx_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Me tsindii we paa we dibili bo misi: we maasa bo mu pimisi na ubee bo ku liyalila; we maasa bo mu lituu la Saatina na ubee bo kwaa Nziaambi. So bo basiiri imiini mu me, bo sa baholo nyaalili a masumu ma bo na mbuu nha kati a baata babangira ba Nziaambi.”» ");
INSERT INTO iyx_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«Ni mu buu, mutini Angiripa, me a na bisi pe utumumu monini yi me na bayi yamati ku yulu. ");
INSERT INTO iyx_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ka me nakwiyiisi tsiomi kwaa basi Damaseko na basi Yeruselemi, tumake kwaa basi Yuuda loosi na kwaa bifuumbu bikimi. Me na loombi ti: bo basobo ndiaatili, mu ukinguu kwaa Nziaambi na umweese mu biyiluu bia bo ti mu ngwanya bo bamaasobo. ");
INSERT INTO iyx_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ni mu ndaa yii, Bayuudayo bakaangi me bu nali mu Nzo a Nziaambi na basiayi mu udusu me. ");
INSERT INTO iyx_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ka Nziaambi akali me, natee mu iluumbu ki, na me keni nhaa na nha, mu uta imbaangi kia me kwaa boosi, kwaa baana ba bangebe na kwaa bakuutu. Me a ndi mu uyaabisa mandaa makimi pe so a ndila maa maleeli Mooso na Mibili mamafwaana uyilimi: ");
INSERT INTO iyx_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ti Mesiya afwaana umono pasi, ti nde sa aba watsiomi mu usiimbuu mu babakwa na sa ayaabisa liyalila la liyobolo kwaa baata ba ifuumbu bioosi bikimi.» ");
INSERT INTO iyx_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Bu Pawuli akitsuu mu ukala nyutu a nde, Festusi aloyi mu mifuri: «We lari lili mu ukolo we, Pawuli! We ayii kwalaa ni mu buu, we ka mu ubeele lari!» ");
INSERT INTO iyx_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pawuli avutili kwaa nde: «Pfumu Festusi, me a nabeele wa me lari pe. Mandaa ma me ndi mu uleele, mali ma ngwanya na ma masuungunu. ");
INSERT INTO iyx_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Mutini a me we ayiluu uyaaba mandaa ma moosi. Na nha kulu a we, me utuu utsuu mu mo mu ilimbisi kioosi. Me na sa imiini ti we a adiimbili ndaa so moosi mu mo pe, mundaa ti mo a mayilimi mu tsweeyi pe, ka mo mayabina nha kula baata boosi. ");
INSERT INTO iyx_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Mutini Angiripa, we asa imiini mu maa mayaabisi mibili? Ee me nayaaba ti we asa imiini mu mo!» ");
INSERT INTO iyx_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Angiripa aleeli kwaa Pawuli: «Matsimi ma we ti we utuu usobo matsimi ma me, paa me ba ngaa Kristo mu ndila mwaana a taanga hoolo?» ");
INSERT INTO iyx_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pawuli avutili: «So iba mu taanga holo so a buu pe mu taanga dikaayira, me ndi mu ukuundu Nziaambi paa ti a ndila we pe, ka beni boosi badili mu uyuu me lolo li, beni diba ka weti bu me ndi, ka kwahele a ukutulu beni mikuru mia bitali mi me ndi na mio mi!» ");
INSERT INTO iyx_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Nha mbisi a uyuu mandaa maa, mutini Angiripa, na Festusi mutumi a tsi, na Berinise na boosi bali itwaari na bo, batemini. ");
INSERT INTO iyx_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Bu batakii nha peembi bo baleelisini ti: «Muutu wu a ayiluu toono so moosi yi bafwaana udusu nde so ulooso nde mu perese pe.» ");
INSERT INTO iyx_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Na Angiripa aleeli kwaa Festusi: «So nde aba a aloombo pe ti bamufuundusu nha kulu a mutini Kayisari, beeri bubwe mu uha nde bunyanga.» ");
INSERT INTO iyx_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Bu baholi kesili ti bisi diafwaana uyene ku tsi ya Italia mu bootu, bahi Pawuli na makori makimi nha mioo mia mukuutu a masodaare, wa kuumbu Yuuli, mosi mu binama bia mikaanga mia mutini a Looma. ");
INSERT INTO iyx_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Bisi diakoti mu bootu lamati ku Adaramita, lakiyene ku peembi a pooro ya itinini kia Asia. Bisi diayeni na muutu wali kuumbu Arisitariki, wa ku tsi ya Masedwane mu ngaanda ya ku Tesalonika. ");
INSERT INTO iyx_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Iluumbu kiaduki, bisi diatoori ku ngaanda ya Sidoni. Yuuli wakikebe Pawuli mu bungeele boosi, ahi nde muswa mu uyamono banduu ba nde, paa baha nde libaasila mu bi ali na nzala a bio. ");
INSERT INTO iyx_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Bu diamati nhaa, bisi diayeni ku peembi ya simi, ku taanda a iduku kia Kipiria, kuu iteembi ali mifuri pe. ");
INSERT INTO iyx_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Bisi diasabii mubu, bebele na itinini kia Silisi na kia Pamfili, na diatoori ku ngaanda ya Mira mu itinini kia Lisia. ");
INSERT INTO iyx_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Nha mbuu yii, mukuutu a masodaare me wuu, bu amoni bootu lakimatuu ku ngaanda ya Alekandere lakiyene ku tsi ya Italia, nde akotisi bisi muu. ");
INSERT INTO iyx_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Mu biluumbu bialaa, bisi diakiyene buke-buke. Na mu pasi dialaa, bisi diatoori ku peembi a ngaanda ya Kinide. Ka bu iteembi kiadikoonisi mu uduku musuungunu wuu, bisi dialabii ku baanda a Salemoni kutoso a iduku kia Kerete, kuu iteembi ali mifuri pe mialaa. ");
INSERT INTO iyx_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Mu pasi, bisi diahami mu uyene mu mukoo-mukoo, natee bu diatoori ku mbuu yi bubaata ti «pooro yimbwe ya mabootu», bebele na ngaanda ya Lasee. ");
INSERT INTO iyx_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Bisi dialabisi taanga dialaa na diamoni ngo pasi. Bootu lakiyene mu pasi dioosi mundaa ti, iluumbu kia Bayuudayo kia nyalili a masumu ali imaalabuu. Ni mu ndaa yii Pawuli wabalibili moonyi, na aleeli kwaa bo ti: ");
INSERT INTO iyx_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«Banduu ba me, me ndi mu umono ti midieenge mi, sa miba mia tsitsi: bootu na bioosi bili mutso muu sa bibiiyi kwalaa. Na nha mbisi, bisi bameme ka utuu uhelele muwuumu.» ");
INSERT INTO iyx_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Kasi mukuutu a masodaare ali avulu usa ilimbisi, mu mubiti a bootu na mu ngaa bootu, mu iteesi kia uhele uyuu mia kileele Pawuli. ");
INSERT INTO iyx_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ndaa yimosi ya ti, itsikini kia mabootu kii ali a kiafwaana pe mu udiaala nhaa mu taanga dia kioori kia mifuri. Ni mubuu babalayi mu babali mu bootu, baholi kesili ya umatuu nhaa. Bo ali na tsimi so butuu ubaayato ku Feniki, ku itsikini kia mabootu kia ku iduku kia Kerete. Itsikini kii kiatalisi ku baanda ya peembi yili mu udiaama taanga, kuu bisi utu usweeme iteembi, natee bu taanga dia kioori kia mifuri dilabuu. ");
INSERT INTO iyx_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Iteembi kia ike-ike kiamati ku baanda kiabaandii upepe. Bo bahamisi matsimi ma bo ma uyene. Bo banyangili mikuru mia bitali bialeme miakikaanga bootu na bayeni bebele na simi la iduku kia Kerete. ");
INSERT INTO iyx_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Mwaana idii hoolo iteembi kia mifuri, kia kuumbu «iteembi kia ku taanda, bele na ku ipala taanga», kiasutii umatuu ku yulu a milaanda mia iduku. ");
INSERT INTO iyx_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Iteembi kii kiabiti bootu na a diabayi bwa usa pe mu utemese bootu na bisi diasiisi kuulu ya tsiomi yi diaki duku, diakiyene mayene-ayene mu litumu la iteembi. ");
INSERT INTO iyx_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Bisi dialabii ku baanda a iduku kia kuumbu Kawuda na bisi diasweemi hoolo nha mbuu yii. Mu pasi dialaa bisi diatuyi utemese luungu lilikee li bayesene mundaa uvuusu baata. ");
INSERT INTO iyx_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Bu baloosi luungu mu bootu, basiali ba mu bootu, bakutili misiingi mu mbata a bootu loosi, mu uhamisa lo. Bu bali na boomo ba uyakieeluu nha yulu a bimbumuni bia musiee ku simi la tsi ya Libi, bo basutili mabala maleme ku mbisi a bootu paa lo liyene buke-buke na banyaali iteembi itsindi bootu. ");
INSERT INTO iyx_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Iluumbu kiaduki, iteembi kiahami mu unyingisi bootu labisi mu mifuri. Baata babaandii ubumu mifunu miali mu bootu mutso mubu. ");
INSERT INTO iyx_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Mu iluumbu kia bitata, basiali ba bootu, badumini bisalili bi bali mu ubiti bootu mu mubu. ");
INSERT INTO iyx_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Biluumbu bialaa bialabii, tari na bambwelele a biabwimonuu kwaa bisi pe. Ka iteembi kiahami mu mifuri mialaa. Na ilimbisi kia uvuu ali ka kio pe mu bisi. ");
INSERT INTO iyx_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Babali mu bootu a babayi pe bia udia, umatuu belepe. Pawuli bu atemini nha kati a bo, aleeli: «Oo! Banduu bame, ali bwafwaana ti beni diyuu me, na uhele usiisi iduku ya Kerete, keni a ubiiyisi na ufuhusu bi bioosi pe. ");
INSERT INTO iyx_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ka mu taanga di, me niloombo kwaa beni mu ulwaata ibaala, ka muutu so mosi mu beni a ukwa pe. Kasi ndila bootu likaa fuu. ");
INSERT INTO iyx_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ee, mu butsuu ba, tumu a Nziaambi a me, wu me ndi mu usalila, ayamonuu kwaa me ");
INSERT INTO iyx_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","na nde leeli kwaa me: “Pawuli aba na boomo pe, we afwaana uyamonuu nha kulu a mutini Kayisari. Na mundaa we, Nziaambi mu litoono la nde mu we, boosi bali mu usa midieenge na we, sa bavuu.” ");
INSERT INTO iyx_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ni mundaa yii, banduu diba na ibaala, mundaa me na siingi Nziaambi: ma nde aleeli kwaa me, sa mayilimi. ");
INSERT INTO iyx_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ka bisi diafwaana ukwayakieeluu nha yulu a imbumuni kia iduku imosi.» ");
INSERT INTO iyx_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Butsuu baa, bali ka ba kuumi bana. Umatuu bu iteembi kiabaandii uyene atsindi bisi, nha yulu a mubu wa Mediterane. Mu kati a kati a butsuu, basiali ba mu bootu, batsimi ti helape ali dimaaswesuu bebele na toto. ");
INSERT INTO iyx_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Bo bayesini musundu a maamba na babayi ba meetere maku matata na tsaamba. Bu baswesii nha kukulu hoolo, babwiyesene musundu a maamba, na babayi ba meetere maku moolo na pwoombo. ");
INSERT INTO iyx_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Bo bali na boomo, ti bootu la bisi sa liyakubu mamanya. Ninha bo basutili bitali bibinene bina ku mbisi a bootu, paa lo liyene buke-buke, na bakikuundu ti bwisi bukia mawasa. ");
INSERT INTO iyx_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ka basiali ba mu bootu bali na nzala ya usiisi bootu mu ubata. Bo bafuti ti bitali bibinene bialeme buyakutulu ku mutswe a bootu. Basutili luungu lilikee ku mutswe a bootu. ");
INSERT INTO iyx_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Pawuli aleeli kwaa mukuutu na kwaa masodaare ti: «So baata ba basiisi bootu, beni a dituu uvuu pe.» ");
INSERT INTO iyx_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Ninha masodaare matabili misiingi mi bali bakutulu luungu me, na babwisi lo layeni mu maamba. ");
INSERT INTO iyx_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Tswaamini a bwisi bukia, Pawuli ahamisi bo boosi mu uholo bia udia, nde aleeli ti: «Iluumbu ki kia kuumi na bina beni dili kutso kwaamisa na kwahele a udia iloo. ");
INSERT INTO iyx_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Ni mu ndaa yii me nileele beni mu uholo bia udia, ka bio bili na ndaanda mundaa mvuuyili a beni. Ka a so mosi mu beni pe ukaadiimbisi linaanga la mutswe a nde.» ");
INSERT INTO iyx_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Bu aleeli mandaa maa, nde aholi lipa, avutili matoondo kwaa Nziaambi, nha kulu a bo boosi, tumake nde abukili lo na abaandii udia. ");
INSERT INTO iyx_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Bo boosi balwaati ibaala, na bo ka badiiri. ");
INSERT INTO iyx_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Mutso bootu bisi diali makama moolo maku tsaamba na baata basamina. ");
INSERT INTO iyx_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Bu muutu-muutu adiiri na ayutii, babumi biloo bioosi mu mubu mundaa uleengese bootu. ");
INSERT INTO iyx_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Busi bu bakieeri, basiali ba mu bootu a babwiyaaba kwali toto pe, kasi bo batalili mwaana a maala ma maamba na musiee wapalila. Bo bakuti tsimi ya uyesene ubiti bootu nha mbuu yii. ");
INSERT INTO iyx_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Bo banyangili bitali biabinene, bialeme na banyaali bio biyene mu mubu. Mu taanga ni dii, banyangili misiingi mi bakisalila mu usuungusu bootu. Tumake bo bahaatisi tsaanda yinene ku kulu a bootu, paa ti iteembi itsindi bootu natee ku simi. ");
INSERT INTO iyx_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ka bo bayikubu imbumuni kia musiee, bu bo bali keni nha kati a kati a mubu. Na bootu lakielii nha mbuu yii. Itsuru kia mutswe a bootu kiayikatuu kutso musiee na bootu ali ka bwa unyingini pe. Mu taanga dii itsuru kia mbisi kiatsiaamii mu ndaa mifuri mia mapo. ");
INSERT INTO iyx_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Masodaare mabayi tsimi ya udusu makori, paa ti so mosi mu bo, anyaala ubata mundaa uvuusu nyutu a nde, mu uyobo. ");
INSERT INTO iyx_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ka mukuutu a masodaare bu ali atoono uvuusu Pawuli, akabisi tsimi a bo yii. Nde atumi kwaa boosi babatuu uyobo, badumuu, mu maamba na bakwayene ku simi. ");
INSERT INTO iyx_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Babamosi baduki bambaayi bu basalili mabala na bibabari bia bootu. Mu mutindi wuu bo boosi batoori ku simi, peembe-polo. ");
INSERT INTO iyx_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Bu diatoori bubwe nha iduku kii peembe-polo, bayaabisi bisi ti kuumbu a kio Malite. ");
INSERT INTO iyx_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Baata ba ku iduku kii badibwaani mu litoono lalaa. Bu mvulu akinoo na abeyi kioori kialaa, bo bavuuti mbaa yinene, bati bisi boosi mbila mu uyayoto yo. ");
INSERT INTO iyx_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pawuli atoli iko kia bitsotso mu udumunu kio ku mbaa, ka pili apali kutso kuu mu ndaa mbabiri a mbaa, akayi nde na akatili nha koo kia nde. ");
INSERT INTO iyx_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Baata ba ku iduku kii bu bamoni pili mu utsiingi mu koo kia Pawuli, bo baleelisini nha kati a bo ti: «Ngwanya muutu wu mudusi ali, mundaa ti pfuundisi a nziaambi a bisi, a yitooni uha pe nde muswa mu uba moonyi, so bu nde avuuyi mu mubu.» ");
INSERT INTO iyx_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ka Pawuli akubili koo kia nde, taari abwi kutso mbaa. Nde a amoni pasi so hoolo pe. ");
INSERT INTO iyx_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Baata boosi bakikebe ti koo kia nde sa idaanda, so a buu pe sa akwa nhaa-na-tsi. Ka bubakebi mu idii kialaa, bo a bamoni ndaa ya pasi yabwiilili nde pe. Bo basobi matsimi, na baleeli ti: «Nde nziaambi ali.» ");
INSERT INTO iyx_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Bebele na mbuu yii, ali na lipaanga la mutumi a iduku kii, kuumbu a nde ni Pubiliwusi. Nde wadiyaki mu litoono lalaa na wadidiaasi ku nzo a nde mutsitsi a biluumbu bitata. ");
INSERT INTO iyx_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Taayi a Pubiliwusi ali ala nha yulu a mbuu. Nde ali na baa na moonyo wa makili. Pawuli ayimono nde, akuundili nde Nziaambi, wamunayi mioo, na nde abeelii. ");
INSERT INTO iyx_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Nha mbisi a nhaa, babeeri bakimi ba ku iduku bayiri ka kwa Pawuli, na bo babeelii. ");
INSERT INTO iyx_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Bo bamweesi bisi likiinzi lalaa. Mu taanga di bisi diakiyilimi mu uyene mu bootu, bo bahi bisi bioosi biali biafwaana mu midieenge. ");
INSERT INTO iyx_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Batsuungi batata bu ba labiyi, bisi diakoti mu bootu lakimata ku ngaanda ya Alekandere. Kuumbu yibakita bootu lii: «banziaambi ba bambu». Bootu me, ali la labisi taanga dia kioori ku iduku kii. ");
INSERT INTO iyx_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Bisi diatoori ku ngaanda ya Sirakuse, kuu bisi dialabisi biluumbu bitata. ");
INSERT INTO iyx_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Bu diakoti mu bootu, bisi diaduki mukoo a mubu na diatoori ku ngaanda ya Lengio. Iluumbu kiaduki, iteembi kia peembi ya baanda kiakipepe, nha mbisi a biluumbu bioolo bisi diatoori ku ngaanda ya Puzolisi. ");
INSERT INTO iyx_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Mu ngaanda yii, bisi diabaasi baana ba nguu, ba baloombi bisi mu udiaala na bo mu tsitsi a limiingi li mosi. Tumake, bisi diatoori ku ngaanda ya Looma. ");
INSERT INTO iyx_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Baana ba nguu ba ku Looma bu bayuyi mamvuungu ma bisi, bayibwaana bisi nha mafuulu ma Apiwusi, na «Manzo ma Bieenyi Matata». Pawuli bu wabamoni avutili matoondo kwaa Nziaambi, na abwibaa mifuri. ");
INSERT INTO iyx_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Mu taanga di diatoori ku Looma, bahi muswa kwaa Pawuli mu udiaala mu nzo ya ndebake. Lisodaara lakikebe nde. ");
INSERT INTO iyx_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Nha mbisi a biluumbu bitata, Pawuli atumisi ku nzo a nde bakuutu ba Bayuudayo ba ku Looma. Bu bayikukunu, nde aleeli kwaa bo ti: «Baana ba nguu, me nayaaba ti a nayiluu ndaa yimbi so mosi pe kwaa ifuumbu kia bisi a beni, so a buu pe kwaa bukulu ba bakaa ba bisi a beni. Ka bakaangi me ku Yeruselemi, na bayeelili me kwaa basi Looma. ");
INSERT INTO iyx_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ka bakuutu ba Looma bu bafuuli me manduru, bo moni ti ali bubwe baha me bunyanga, mundaa ti a babayi pe toono ya uha me tsieembili ya likwa. ");
INSERT INTO iyx_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ka Bayuudayo a basiingi pe ti banyaala me, ni mu ndaa yii me naloombi ti mutini Kayisari a kengese toono a me. Ka me a ndi na matsimi pe ma ufuundu ifuumbu kia me. ");
INSERT INTO iyx_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ni mu ndaa yii me naloombo ti dimononani, na me tsuu na beni. Ee, mu ndaa muutu wuu, me ndi kori mu mikuru mia bitali mi. Mu muutu me wuu, mukaanga a Iseraeli asuusu ilimbisi.» ");
INSERT INTO iyx_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Bo bamuvutili ti: «Mu ndaa yatala we, bisi a diaholo pe mukaanda so mosi wamata ku ngaanda Yuuda. Muutu ka so mosi pe mu baana ba nguu wamatuu kuu, mu uyayaabisa bisi mi mialabii, so a buu pe mu uyatsuu ma mabi mu kuumbu a we kwaa bisi. ");
INSERT INTO iyx_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ka bisi aba diatoono uyuu matsimi ma we. Mundaa ti bisi diayaaba ti mu mambuu moosi, bali mu udwaanisa libuundu li we akangama mu lo li.» ");
INSERT INTO iyx_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Bo bakuti layi na Pawuli, na, iluumbu kia layi bu kiatoori, bo bayiri mu litaanga lalaa ku nzo yi nde akidiaala. Ubaanduu ngwaali natee tsitsii, Pawuli abiindili kwaa bo, nde ayaabisi bo mu miatala Ipfumu kia Nziaambi, na asiayi makuulu ma bo bu utuu usiingi Yiisu. Nde akibiindili bo ubaanduu mu mandaa mabasonuu mu Mikele mia Mooso, natee mu Mikaanda mia Mibili. ");
INSERT INTO iyx_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Baata babamosi basiiri imiini mu ma nde akileele, ka bana a basiiri imiini pe. ");
INSERT INTO iyx_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Mu taanga di bo bakivutuu kwahele a uyuhusunu nha kati a bo, Pawuli aleeli kwaa bo ndaa ya tsieelele yi: «Mu ngwanya Muheebili wa Ngira watsuyi mu Yeesaya kwaa bakaa ba beni, ");
INSERT INTO iyx_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","nde aleeli: “Yene kwaa baata ba, na leele bo: beni sa diyuu, ka a diyaaba mbiindili pe; beni sa ditala, ka a dimono pe. ");
INSERT INTO iyx_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Mundaa ti baata ba ka na mutswe pini: bo bamaadibuu matswi ma bo, bo bamaadibuu misi mia bo, paa misi mia bo mihele umono, matswi ma bo mahele uyuu, na mu mayele ma bo bakoono uyaaba mambiindili, na banyaala uyiri a vutuu kwaa me, paa me beelese bo.” ");
INSERT INTO iyx_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Pawuli abwileele kwaa bo, mundaa yii beni diafwaana uyaaba ti, mu taanga di Nziaambi maatsinduu ndaa ya liyobolo kwaa bangooyi. Bo sa bayuu yo!»  ");
INSERT INTO iyx_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Pawuli bu amani utsuu mandaa maa, Bayuudayo bakiyene avutuu mutso kaama la mifuri nha kati a bo. ");
INSERT INTO iyx_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pawuli adiaali mu tsitsi a bilimi bioolo mu nzo yi nde akifutu. Nde akiyaka baata boosi babakiyamono nde. ");
INSERT INTO iyx_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Nde akiyaabisa Ipfumu kia Nziaambi, na akiyiisi mandaa matala Pfumu Yiisu Kristo, mu ilimbisi kioosi, na kutso bunyanga.");
INSERT INTO iyx_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Me Pawuli booyi la Yiisu Kristo. Nziaambi ati me mbila mu uba tumu, na asiooli me mu uyaabisa Ndaa Yimbwe ya Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Umatuu bele pe, mu Mabasonuu ma Ngira, Nziaambi asialili mibili mia nde, mu uyaabisa lilasini la Ndaa Yimbwe yi. ");
INSERT INTO iyx_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Ndaa Yimbwe me, yatala mwaana a Nde, Pfumu a bisi Yiisu Kristo. Mu peembi ya imuutu, nde abutii mu likaanda la Daavidi. ");
INSERT INTO iyx_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Ka mu peembi ya Muheebili wa Ngira, nde amonii Mwaana a Nziaambi mu lituu, mu taanga di nde asiimbii mu babakwa. ");
INSERT INTO iyx_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Mu nde, Nziaambi ahi me bweese ba uba tumu mu ndaa buzitu ba Kristo, paa me biti baata ba bifuumbu bioosi mu usa imiini mu kuumbu a nde, na utumumu nde. ");
INSERT INTO iyx_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Beni ka dili mu litaanga la baata baa, beni ba Nziaambi ateeri mbila paa beni diba baata ba Yiisu Kristo. ");
INSERT INTO iyx_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Me nisonuu beni mukaanda wu, beni badili ku ngaanda a Looma, beni boosi ba Nziaambi atoono na ba nde ateeri mbila mu uba moonyi mu nde. Nyaala Taayi a bisi Nziaambi na Pfumu a bisi Yiisu Kristo basieme beni na uha beni iyeenge. ");
INSERT INTO iyx_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Tswaamini a mioosi, me tooni uvutulu matoondo kwaa Nziaambi a me mu Yiisu Kristo, mu ndaa beni boosi. Mundaa ti, baata bali mu utsuu mu imiini kia beni mu tsi yoosi yadieengelele baata. ");
INSERT INTO iyx_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Nziaambi ayaaba ti me ndi mu uta ngwanya, nde wu me ndi mu usalila mu mutimi a me woosi mu uyaabisa Ndaa Yimbwe yatala Mwaana a nde. Nziaambi ayaaba ti me ndi mu utsimanga mu beni mu taanga dioosi. ");
INSERT INTO iyx_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Mu pasi taanga di me ndi mu ukuundu, me ndi mu uloombo kwaa Nziaambi, so lii ni litoono la nde, aha me kuulu ya uyiri kwaa beni. ");
INSERT INTO iyx_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Ngwanya, me ndi na nzala yalaa ya umono beni, paa ti Nziaambi aha beni bungori ba Muheebili wa Ngira mu ndaa uhamisa imiini kia beni. ");
INSERT INTO iyx_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Ka vulu-vulu, me ndi na nzala ya uba itwaari na beni, paa bisi a beni diholani pamini mu itwaari. Me holo pamini mu imiini kia beni, na beni mu imiini kia me. ");
INSERT INTO iyx_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Baana ba nguu ba me, me natoono ti beni diyaaba ti, taanga dialaa me nibaanhana uyiri kwaa beni. Ka natee mu taanga di, me a natuu pe mu uyiluu buu. Me aba natoono ti isala kia me ibutu mbutu kwaa beni, weti bu kio kiabuti mbutu kwaa bifuumbu bikimi. ");
INSERT INTO iyx_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Me ndi na mufunu wa uyene kwaa baata boosi. Kwaa basienzi na kwaa babali a basienzi pe. Kwaa biyeri na kwaa bangaa bundimbi. ");
INSERT INTO iyx_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ni mubuu, me ndi na nzala ya uyaabisa Ndaa Yimbwe kwaa beni ka bali ku ngaanda a Looma. ");
INSERT INTO iyx_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Mu ngwanya, kwahele a tsionyi me ndi mu uyaabisa Ndaa Yimbwe. Yo yili ni mifuri mi Nziaambi ali mu usalila mu uyobolo baata boosi babali mu usa imiini. Tsiomi kwaa Bayuudayo, tumake, na kwaa babali a Bayuudayo pe. ");
INSERT INTO iyx_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Ngwanya Ndaa Yimbwe yili mu umweese buni Nziaambi ali mu usa ti baata baba balibweeye nha kulu a nde. Libweeye lii uyiri mu imiini, na mu ndaa imiini. Weti buli mu uleele Mabasonuu ma Ngira: «Walibweeye sa aba moonyi, mundaa imiini.» ");
INSERT INTO iyx_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Umata ku yula, Nziaambi li mu umweese kesi a nde mu pasi lisumu, na mu pasi ndaa yimbi yi baata bubaayiluu. Bo bali mu ukiki kuulu kwaa ngwanya, mu mamabi ma bo ma bali mu uyiluu. ");
INSERT INTO iyx_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Ka bunu, mandaa ma butuu uyaaba mu Nziaambi, mali mayabina kwaa bo. Nziaambi nde makulu alayi bo mo kwa na yaki-yaki. ");
INSERT INTO iyx_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Mu ngwanya, umata bu Nziaambi ayilii tsi, mandaa ma nde mali mu uhele umonuu mu misi, pili mosi, lituu la nde la bilimi na bilimi, na inziaambi nde, bili mu umonuu mu biyiluu bia nde. Ni mubuu, baata a butuu uleele pe ti bo a bayaaba pe. ");
INSERT INTO iyx_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Bo bayaaba Nziaambi, ka bo a bali mu ukiinzi nde pe, na bo a bali mu uvutulu nde matoondo pe, weti bwafwaana kwaa nde. Ka bo, aka na matsimi mamabi na mitimi mia bo mia buwulu, miamaakoto kutso pimisi. ");
INSERT INTO iyx_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Bo bali mu umonuu ti bo biyeri, ka bunu bo babeeri ba lari! ");
INSERT INTO iyx_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Nha mbuu ya ukiinzi buzitu ba Nziaambi wa bilimi na bilimi, bo bakiinzi biteyi bia ifwaani kia muutu wu utuu ukwa, bia banyunyi na banyama bali na miili nina, na bataari. ");
INSERT INTO iyx_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Ni mubuu, Nziaambi abwoongili bo kutso biyiluu bia bo bia mviindi, weti buli manzala mamabi ma mitimi mia bo. Paa ti bo bamweese manyutu ma bo tsionyi. ");
INSERT INTO iyx_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Bo bali mu ukitisi ngwanya yatala Nziaambi mu pia. Bo bali mu ukuundu na usalila biloo bi Nziaambi ayiluu. Bo babali mu ukuundu na usalila biyiluu bia Nziaambi, nha mbuu ya ukuundu muyilii nde makulu, wu bafwaana ubili mu taanga dioosi! Ameni. ");
INSERT INTO iyx_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Ni mubuu, Nziaambi abwoongili bo mu manzala ma bo ma tsionyi. Bakaasa ba bo a bali mu ubwapala na babaala pe, ka bo bali mu upala na bambaayi bakaasa. Tsialili yii yili ya ku buko. ");
INSERT INTO iyx_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Bumosi ka, babaala a bali mu ubwapala na bakaasa pe. Bo bali mu ululuu mu nyooto ya upala na bambaayi babaala. Babaala bali mu uyiluu mandaa ma tsionyi bana mu bana, na bo makulu bali mu uholo tsieembili yafwaana na ndiimbisi a bo. ");
INSERT INTO iyx_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Bu bo babisi uyaaba Nziaambi, Nziaambi ka abwoongili bo kwaa mayele ma bo matekene. Ni mubuu, bo bali mu uyiluu mandaa mabakeehele uyiluu. ");
INSERT INTO iyx_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Bo baluulu mu mandaa moosi mahele na libweeye, mamabi, ma linyungu, ma ibaala. Bo baluulu mu musoyi, mu ndusili, mu makaama, mu mayele mamabi, na ma ndimi dioolo. Bo bali mu ufutulu bambaayi mandaa ma pia. ");
INSERT INTO iyx_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Bo bali mu utsuu mandaa mamabi bana mu bana. Bo bali mitaata mia Nziaambi. Bo na munywa, na liwaa na lizoo. Bo koo bayilimi taanga dioosi mu utsimi mandaa mamabi. Bo bubaatemenene bataayi na banguu ba bo. ");
INSERT INTO iyx_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Bo a bali na mayele pe, na a bubaakuusu ndasina dia bo pe. Bo bali na mutimi bunono na a bu bamono mbaayi ngebe pe. ");
INSERT INTO iyx_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Bo bayiluu uyaaba tumini dia Nziaambi diasuungunu. Baata bali na ndiaatili ya pili yii, bafwaana ukwa. Ka bunu, bo bali mu uhama mu uyiluu mandaa ma pili yii, na nha yulu, bo bali mu usiingisi ka bali mu uyiluu mo. ");
INSERT INTO iyx_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","We, so yaba ti we a na li, we wuli mu ufuundusu bambaayi, a busa we kolokolo pe. Mundaa ti nha we li mu ufuundusu bambaayi, na bu we li mu uyiluu weti bo, we li mu uholo tsieembili mu iwemakulu. ");
INSERT INTO iyx_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Ka bisi diayaaba ti Nziaambi ubaafuundusu mu ngwanya, baata babubaayiluu mandaa ma pili yii. ");
INSERT INTO iyx_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","We wuli mu ufuundusu bambaayi mu mandaa ma we li mu uyiluu we makulu! Ee we tsimi ti we sa vuu mu pfuundisi a Nziaambi? ");
INSERT INTO iyx_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","So a buu pe, we umeengele li mu umeengele bunene ba libweeye la Nziaambi, kamini a mutimi a nde, na mutimi a nde wumubwe? Buni, we a ayaaba pe ti libweeye la Nziaambi lili mu ubiti we ku kiingili a mayele? ");
INSERT INTO iyx_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Mundaa mutswe pini we na mutimi a we wumunono, we li mu ubaakukuu nha yulu a we makulu, kesi a Nziaambi yavulu bunene, mu iluumbu ki nde akaamweese kesi na pfuundisi a nde biasuungunu. ");
INSERT INTO iyx_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Mu iluumbu kii, Nziaambi sa asieende muutu-muutu weti buli biyiluu bia nde. ");
INSERT INTO iyx_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Nde sa aha moonyi wa bilimi na bilimi kwaa babali mu hama mu uyiluu ma ndaa mamabwe, na kwaa babali mu usaa buzitu ba Nziaambi, likiinzi na moonyi wu uhele uwa. ");
INSERT INTO iyx_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Ka nde sa amweese kesi na fuukiri bia nde kwaa babutemenene nde, kwaa babudwaanisa ngwanya, na kwaa babayeelele manyutu mu mandaa mahele na libweeye. ");
INSERT INTO iyx_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Mapasi na ngebe sa mabwiilili boosi babali mu uyiluu mandaa mamabi. Tsiomi kwaa Bayuudayo, tumake kwaa babali a Bayuudayo pe. ");
INSERT INTO iyx_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Ka Nziaambi sa aha buzitu, likiinzi na iyeenge kwaa boosi babali mu uyiluu mandaa mamabwe. Tsiomi kwaa Bayuudayo, tumake kwaa babali a Bayuudayo pe. ");
INSERT INTO iyx_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Ka Nziaambi ali na ipengenge pe. ");
INSERT INTO iyx_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Boosi bali mu usa masumu kwa hele uyaaba mikele mia Mooso, sa ba fuu, kwahele mikele mii. Ka boosi babayaaba mikele mia Mooso na bali mu usa masumu, sa bafuundusu bo weti buli mikele mii. ");
INSERT INTO iyx_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Ka nha kulu a Nziaambi, baata balibweeye a babali mu uyuu mikele pe, ka babali mu usalila mio, bakaata balibweeye. ");
INSERT INTO iyx_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Baata babali a Bayuudayo pe, na abayaaba mikele mia Mooso pe, ka bo bali mu usalila mio mu ibomakulu, ka weti ti, bo bali na mikele mu mitimi mia bo. Ka bunu, bo a bali na mio pe. ");
INSERT INTO iyx_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Ninha, bo bali mu umweese ti mandaa mali mu utumu mikele mali masonomo mu mitimi mia bo. Matsimi ma mitimi mia bo, mali mu uta imbaangi ka. Na matsimi ma bo nhana mali mu ubaafuundu bo, nhana mali mu ubaakala bo. ");
INSERT INTO iyx_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Mono mikaamonuu mu iluumbu ki Nziaambi akaa fuundusu mu Yiisu Kristo, mandaa moosi masweeme mu idiingi kia pasi muutu, weti buli mu uleele Ndaa Yimbwe yi me ndi mu uyaabisa. ");
INSERT INTO iyx_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ka we, wuli mu ubili ti we Muyuudayo, we akangama mu mikele, na we li na liwaa mu Nziaambi a we. ");
INSERT INTO iyx_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","We ayaaba litoono la nde, na mikele miayiisi we mu usoolo mandaa ma mabwe. ");
INSERT INTO iyx_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","We li mu baatsimi ti we mubiti a bingima-ngimi, liyalila kwa babali mu pimisi! ");
INSERT INTO iyx_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","We li mutsimi ti we muyiisi kwaa bangaabundimbi, na muyiisi kwaa baana. Mu ndaa ti we ayiluu uyaaba ti, kutso mikele we li mu ubaa nziaabili yakuu na ya ngwanya. ");
INSERT INTO iyx_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Ee, we wuli muyiisi bambaayi, mu ima we li mu uhele uyiisi we makulu? We uli mu uyiisi ti, a diyibi pe, mu ima we li mu uyibi we makulu? ");
INSERT INTO iyx_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","We wuli mu ulii baata usoongo, mu ima we li mu uyiluu buu? We wuli mu ubele biteyi, mu ima we li mu upatila mu mifuri biloo bia mu manzo ma bo ma makuundu? ");
INSERT INTO iyx_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","We li na liwaa mu mikele, ka we li mu utsoro Nziaambi, bu we li mu uyiluu ku buko, mandaa ma mikele mia nde mili mu utumu! ");
INSERT INTO iyx_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Mu ngwanya, Mabasonuu ma Ngira mali mu uleele: «Mu ndaa beni, bifuumbu bikimi bili mu utsoro kuumbu a Nziaambi». ");
INSERT INTO iyx_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Mbiiti we ubaakiinzi mikele, kesili yili na ndutu; ka mbiiti we asumunu mikele, we li weti muutu ubahele ukese. ");
INSERT INTO iyx_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ka mbiiti muutu ubahele ukese li mu utumumu mikele, Nziaambi sa mono nde weti muutu wubakese. ");
INSERT INTO iyx_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Muutu wubahele ukese mu musunyi, ka nde li mu utumumu mikele, sa afuundusu we. We wuli mu uhele utumumu mikele. So bu yili ti we li na mikele mi basonuu na so bu weli wubakese. ");
INSERT INTO iyx_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Ni mubuu, ngo Muyuudayo a wuli mu umonuu mu misi pe, na wuli na iliimbi ki li mu mweese ti nde li wubakese mu nyutu a nde. ");
INSERT INTO iyx_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Ka ngo Muyuudayo, ni wuli buu kutso mutimi a nde. Nde ni wu bakese kutso mutimi a nde, mu kesili ya Muheebili a Nziaambi, ka a ya mikele mi basonuu pe. Ngo Muyuudayo wu li mu uhoolo mbilili a Nziaambi, ka a ya baata pe. ");
INSERT INTO iyx_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Ni mu buu, mu ki toono Muyuudayo avulu baata bakimi? Kesili yili na ndutu? ");
INSERT INTO iyx_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Ndutu yili yinene, mu mandaa malaa! Tsiomi, kwaa Bayuudayo Nziaambi ahi mandaa ma nde. ");
INSERT INTO iyx_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Uli ngwanya ti babamosi nha kati a bo a banambita pe mu Nziaambi. A ka Nziaambi utuu koono unambita mu ndasini dia nde, mu ndaa ti bo a banambita pe mu nde? ");
INSERT INTO iyx_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ngori! Bwa fwaana uyabina ti Nziaambi li wangwanya, na baata boosi bali bangaa pia, weti buli mu uleele Mabasonuu ma Ngira: «Paa we monuu walibweeye mu mandaa ma we li mu uleele, na paa we biingi so bafuundisi we.» ");
INSERT INTO iyx_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Ka so pelili a libweeye la bisi yili mu umweese libweeye la Nziaambi, ima bisi dituu uleele? Nziaambi a li na libweeye pe mundaa ti, nde li mu kolo kesi a nde nha yulu a bisi? — Me ndi mu utsuu mutsuyili ya imuutu. ");
INSERT INTO iyx_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Ngori! Ka so Nziaambi ali walibweeye pe, buni nde akaatuu ufuundusu tsi? ");
INSERT INTO iyx_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Ka mbii ti pia dia me dili mu umweese kwa na yalilaa ngwanya a Nziaambi, na dili mu usalila mu umweese buzitu ba nde. Mu ima butuu ubwafuundusu me weti ngaa masumu? ");
INSERT INTO iyx_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Mu yii, mu ima dihele uleele ti: « Diyiluwani mandaa mamabi, paa mu mo mandaa mamabwe mapala»? Mu ngwanya, baata babamosi, mu utsoro bisi, bali mu uleele ti maa ni mandaa ma bisi. Baata sa bafuundusu bo, na buu ni bwafwaana kwaa bo! ");
INSERT INTO iyx_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Aka ima dituu uleele? Bisi Bayuudayo diavulu bifuumbu bikimi ndutu? Ee-e, ka a mu mandaa moosi pe! Bisi diamaakwamweese ti baata boosi, yaba Bayuudayo na baata babali a Bayuudayo pe, bali ku tsini a litumu la masumu. ");
INSERT INTO iyx_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Mabasonuu ma Ngira mali mu uleele: « A uli na muutu wa libweeye pe, a so mosi pe. ");
INSERT INTO iyx_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","A uli na muutu pe so mosi uli na mayele, Muutu so mosi pe uli mu usaa Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Baata boosi bamaasiisi kulu yimbwe, mu itwaari bo boosi bamaadiimbili. A uli na muutu pe so mosi wuli uyiluu mamabwe. A so mosi pe! ");
INSERT INTO iyx_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Miwuri mia bo mili weti mangili mabwaasi. Ndimi dia bo isala pia ufutu. Misa mia bataari mili mu ubaapala mu minywa mia bo. ");
INSERT INTO iyx_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Minywa mia bo mialuulu mu mandaa ma tsibili na makali. ");
INSERT INTO iyx_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Bo na malwangimina mu udusu baata. ");
INSERT INTO iyx_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Bo bali mu utsala na bali mu usiisi ngebe mu mambuu moosi ma bo bali mu uyoo. ");
INSERT INTO iyx_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Bo a bayaaba pe kuulu a iyeenge. ");
INSERT INTO iyx_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Bo a bali mu ubatila Nziaambi boomo pe.» ");
INSERT INTO iyx_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Bisi diayaaba ti mioosi mili mu uleele mikele, mili mu utsuu kwaa baata babali ku tsini a litumu la mikele. Paa ti, muutu so mosi anyaala udibili munywa nde mu ukala nyutu a nde, na paa ti tsi yoosi yadieengelele baata, basieembe yo nha kulu a Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","A uli na muutu pe so mosi wukaamonuu walibweeye nha misi mia Nziaambi, mundaa ti nde li mu utumumu mikele. Mikele mili mu ubaasila baata mu uyaaba masumu. ");
INSERT INTO iyx_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ka mu taanga di, Nziaambi maamweese bisi, buni nde ali mu ukitisi bisi balibweeye nha kulu a nde. Na nde li mu uyiluu buu, kwahele usalila mikele. Mikaanda mia Mikele na mia Mibili mili mu usilili ndaa yii. ");
INSERT INTO iyx_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Nziaambi ubaakitisi baata baba balibweeye mu imiini, na bu bo banambata mu Yiisu Kristo. Nde li mu usa buu, kwaa boosi babali mu usa imiini mu Yiisu Kristo. Mundaa ti, a uli na lisoboso nha kati a bo pe. ");
INSERT INTO iyx_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Baata boosi basa masumu, bahelili buzitu ba Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Ka Nziaambi mu bweese ba nde, li mu ukitisi bo baba balibweeye kwahele a mufutu, mu Yiisu Kristo wuli mu ukuulu bo mu masumu. ");
INSERT INTO iyx_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","26","Nziaambi aheeri Yiisu Kristo weti bungori mu ndaa nyalili a masumu. Ninha, mu likwa la nde, baata babasa imiini mu nde baholi nyaalili a masumu ma bo. Mu yii, Nziaambi amweesi ti nde li walibweeye taanga dioosi. Tsiomi nde ali buu, mu taanga di nde akami mutimi mu unyaala usieembe masumu ma baata. Na nde li buu ka mu taanga di. Mundaa ti, nde atoono uba walibweeye, na ukitisi boosi babali mu usa imiini mu Yiisu baba balibweeye. ");
INSERT INTO iyx_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Mu yii, uli na toono kimi yi dibwasa liwaa? Ngori, so moosi pe! Ka mu a ima bisi dili mu uleele mandaa maa? Mu utumumu mikele? Pia, ka mikele mili mu ubiti bisi mu usa imiini. ");
INSERT INTO iyx_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Mu ngwanya, bisi dili mu utsimi ti, muutu li mu umonuu walibweeye mu ndaa imiini. Ka a mu ndaa pe ti nde li mu utumumu mikele. ");
INSERT INTO iyx_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","So a buu pe, Nziaambi ndila wa Bayuudayo ali? Nde a ali pe ka Nziaambi a bifuumbu bini? Ee-e, nde li ka Nziaambi a bifuumbu bini bioosi. ");
INSERT INTO iyx_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Ka bu yili ti Nziaambi ndila mosi ali! Na Nziaambi sa akitisi Bayuudayo na babali a Bayuudayo pe baba balibweeye mu imiini. ");
INSERT INTO iyx_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Yii yatoono uleele ti, mu ndaa imiini bisi dili mu umaasa ndutu la mikele? Pia ngwanya, ka bisi dili mu uha mio ndutu ya ngwanya! ");
INSERT INTO iyx_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Ima bisi dituu uleele mu Abraami, mwakaa a bisi? Ima nde abayi mu inde makulu? ");
INSERT INTO iyx_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Mbii ti Abraami amonii muutu walibweeye mu ndaa mandaa ma nde ayilii, nde akeni ubaa ndaa ya usa lizoo. Ka nde utuu pe udzoo nha kulu a Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Ngwanya, buni Mabasonuu ma Ngira mali mu uleele? «Abraami asi imiini mu Nziaambi, na Nziaambi amoni nde weti muutu walibweeye mu ndaa imiini kia nde.» ");
INSERT INTO iyx_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Muutu wuli mu usala li mu ubaa mufutu. A bali mu uha pe nde mufutu wuu weti bungori. Ka nde li musieende wu nde afwaana ubaa. ");
INSERT INTO iyx_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Ka mu taanga di muutu ali mu uhele usa isala, na siiri imiini kia nde mu Nziaambi wu utuu ukitisi ngaa masumu aba walibweeye, Nziaambi li mu umono imiini kia nde, na li mu uholo nde weti muutu walibweeye. ");
INSERT INTO iyx_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Bumosika, Daavidi ali mu utsuu mu kinyi a muutu wu Nziaambi ali mu umono weti walibweeye kwahele a utaanga biyiluu bia nde: ");
INSERT INTO iyx_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«Kinyi kwaa baata ba Nziaambi asa bubi ba bo kolokolo, na ba nde akuungili masumu ma bo! ");
INSERT INTO iyx_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Kinyi kwaa muutu wu Pfumu ali mu uhele utaanga lisumu la nde!» ");
INSERT INTO iyx_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Kinyi yii yili ndila kwaa baata babakese bubaala, oo tii, yo yili ka kwaa babahele ukese bubaala? Ee-e, bisi dileeli ti «Nziaambi amoni Abraami weti muutu walibweeye mu ndaa imiini kia nde». ");
INSERT INTO iyx_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Mu ki taanga mii miayilimi? Tswaamini akesili a nde oo ti nha mbisi a kesili a nde? Ngori, a nha mbisi a kesili a nde pe, ka tswaamini a bu kese nde! ");
INSERT INTO iyx_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Nha mbisi Abraami abayi iliimbi kia kesili. Kio ali Iliimbi kili mu umweese ti Nziaambi amoni nde walibweeye mu ndaa imiini. Bunu, nde ali keni aba kese pe. Ni mu buu, Abraami akitii taayi a baata boosi babasa imiini mu Nziaambi, so bubahele ukese bo. Na Nziaambi li mu umono baata baa weti balibweeye. ");
INSERT INTO iyx_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Nde li ka taayi a baata babakese, pili mosi ti, babali mu uhele usuku ndila nha kesili, ka bali mu uduku ifwaani kia imiini kia taayi a bisi Abraami tswamini a bukese nde. ");
INSERT INTO iyx_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Nziaambi alasini kwaa Abraami na baana ba nde ti bo sa batolo mukobo wa tsi. Nziaambi a asi pe lilasini lii mu ndaa ti Abraami atumimi mikele, ka mu ndaa ti Nziaambi amoni nde weti muutu walibweeye mu ndaa imiini kia nde. ");
INSERT INTO iyx_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Mbii ti babutolo mukobo wubalasina, ubaa nde mu utumumu mikele, mu yii, imiini a kiakeni uba na ndutu pe, na lilasina la Nziaambi a lakeni uba lahele a isala. ");
INSERT INTO iyx_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Bunu, mikele mili mu ubee kesi a Nziaambi. Ka nha mbuu yahele a mikele, tsumini a mikele ka yo pe. ");
INSERT INTO iyx_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Ni mubuu, mu ndaa imiini basi lilasina, paa ti lo liba bungori ba Nziaambi ba paamba, na paa lo basiingisi lo kwaa baana ba Abraami boosi. Lilasina a lili ndila kwaa babali mu ukiinzi mikele pe, ka kwaa boosi ka babali na imiini weti Abraami, Uli taayi a bisi boosi. ");
INSERT INTO iyx_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Weti bu li mu uleele Mabasonuu ma Ngira: «Me nabiaalisa we taayi a bifuumbu bibilayi bia baata.» Nde li taayi a bisi nha kulu a Nziaambi wu nde asi imiini mu nde, Nziaambi wuli mu uha moonyi kwaa babakwa, na wuli mu usa ti biloo bioosi biali bio pe, biba. ");
INSERT INTO iyx_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Abraami asi imiini. Nde asi ilimbisi, ka bunu, ilimbisi ali aka kio pe. Ni mu buu nde akitii «kaa a bifuumbu bibilayi bia baata», weti bu Nziaambi aleeli nde: «Buu ni bu kaa ba litaanga la baana ba we.» ");
INSERT INTO iyx_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Nde ali helape na kama a bilimi. Ka imiini kia nde a kiadeyi pe, bu nde akitsimi mu nyutu a nde yali yamaakongo, mu iteesi kia uto nha peembi a likwa. Na nde akitsimi ka mu Saara, mukari a nde, wali ikumbu. ");
INSERT INTO iyx_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Nde a adiimbisi imiini kia nde pe na asi pe paa mu lilasina la Nziaambi. Kabunu, imiini kia nde kiahamisi nde na nde abili Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Nde ali na ngo ilimbisi kia ngwanya ti Nziaambi li na litu la ukuusu lilasina la nde. ");
INSERT INTO iyx_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Ni mubuu ka, bali mu uleele mu Abraami ti, mu toono a imiini kia nde « Nziaambi amoni nde walibweeye.» ");
INSERT INTO iyx_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Ka mandaa ma: «Nziaambi amoni nde walibweeye», a basonuu pe mo ndila mu Abraami. ");
INSERT INTO iyx_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Basonuu mo ka mu ndaa bisi, badiafwaana umonuu balibweeye, mu ndaa ti bisi dia sa imiini mu Nziaambi wa siimbili Yiisu Pfumu a bisi mu babakwa. ");
INSERT INTO iyx_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Bamuyeelili mu likwa mu toono a mamabi ma bisi, na Nziaambi wamusiimbili mu babakwa mu ndaa ukitisi bisi diba balibweeye. ");
INSERT INTO iyx_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Ni mu buu, Nziaambi wadimoni balibweeye mu ndaa imiini. Na mu taanga di, bisi dili na iyeenge na Nziaambi mu Pfumu a bisi Yiisu kristo. ");
INSERT INTO iyx_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Mu imiini mu Yiisu, bisi ka diatuu ubaa bweese ba Nziaambi, ba bisi dianambita mu bo mu mifuri. Na bisi dili mu usuusu kinyi a bisi, mu ilimbisi kia ubaa ikuku kia buzitu ba Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Ka vulu-vulu, bisi dili mu usuusu kinyi a bisi so mu mapasi. Mundaa ti, bisi diayaaba ti mapasi mali mu ubutu mukonono. ");
INSERT INTO iyx_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Na, mukonono li mu ubutu pamini kutso nziesini, na pamini yili mu ubutu ilimbisi. ");
INSERT INTO iyx_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Ilimbisi kii a ili mu ukwiisi bisi tsionyi pe, mundaa ti, Nziaambi ayitili litoono la nde mu mitimi mia bisi mu Muheebili wa Ngira wu nde aha kwaa bisi. ");
INSERT INTO iyx_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Ee, mu taanga di bisi diali keni mifuri pe, Kristo akwi mu ndaa bangaa masumu mu taanga diafwaana. ");
INSERT INTO iyx_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Uli pasi mu umono muutu wu ukwa nha mbuu a muutu wasuungunu. Ka helape, muutu utuu ubaa mifuri mu ukwa nha mbuu a muutu wu mubwe. ");
INSERT INTO iyx_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Ka Nziaambi amweesi bisi mu ki iteesi nde atoono bisi: Kristo akwi mu ndaa bisi, bu diali keni bangaa masumu. ");
INSERT INTO iyx_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Mu makili ma nde, bisi dimaamonuu balibweeye mu taanga di. Ngwanya ni buu ka, Kristo sa avuusu bisi mu kesi a Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Ee, bu bisi diali mitaata mia Nziaambi, nde avuuti iyeenge kia bisi na nde mu likwa la mwaana a nde. Koomboso mu taanga di, di bisi dimaavuutu iyeenge na nde, nde sa avuusu bisi mu moonyi a mwaana a nde. ");
INSERT INTO iyx_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Nha yulu a maa, bisi dili na kinyi mu Nziaambi, mundaa Pfumu a bisi Yiisu Kristo, wumaavuutu iyeenge kia bisi na Nziaambi mu taanga di. ");
INSERT INTO iyx_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Lisumu lakoti mu tsi mu toono a muutu ndila mosi, ni Aadami. Na lisumu labeyi likwa. Na mu yii, likwa latoori kwaa baata boosi, mu ndaa ti boosi basi masumu... ");
INSERT INTO iyx_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Tswaamini Nziaambi uha mikele kwaa Mooso, masumu mali makwaba mu tsi. Ka bu mikele miali keni mio pe, a bakitaanga masumu pe. ");
INSERT INTO iyx_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Ka bunu, umata mu taanga dia Aadami natee mu taanga dia Mooso, likwa lamweesi lituu la lo so nha yulu a babahele usa masumu, weti Aadami, wabisi usiingi tumini dia Nziaambi. Aadami ali ifwaani kia muutu wuu wukaayiri. ");
INSERT INTO iyx_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Ka lisumu la Aadami a lafwaanina pe na bunene ba bungori ba bweese ba Nziaambi. Ngwanya, baata balaa bakwiiri mundaa lisumu la muutu ndila mosi wuu. Ka bungori ba bweese ba Nziaambi babwavulu bunene. Kwaa babalayi, bungori baa bahi bo bayibuu mundaa muutu moosi, ni Yiisu Kristo. ");
INSERT INTO iyx_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Na bungori ba Nziaambi a bafwaanina pe, na mili mu ubutu lisumu la muutu ndila moosi. Pfuundisi yayiri mulisumu la muutu ndila mosi, musieende a yo ni tsieembili. Ka bungori bapaamba ba Nziaambi ali mu uha nha mbisi a masumu mamalayi, musieende ni nyaalili a masumu. ");
INSERT INTO iyx_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Ngwanya, mu ndila muutu mosi, na mulisumu la ndila muutu moosi wuu, likwa lamweesi lituu la lo nha yulu a baata boosi. Ka mu ndila Yiisu Kristo, baata bali mu uba biavululu: Nde li muha bo mandaa mama bwe kwa ibuu, na nde li mu ukitisi bo balibweeye. Mu Kristo, bo sababamoonyi na sabatumu na nde. ");
INSERT INTO iyx_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Ni mu buu, lisumu la ndila muutu mosi, ni Aadami, labeyi tsieembili a baata boosi. Bumosi ka, isala kia libweeye kia muutu ndila mosi, ni Yiisu Kristo, ili mu ubaasila baata boosi mu umonuu balibweeye na mu uba moonyi. ");
INSERT INTO iyx_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Mu ndaa muutu ndila mosi wahele utumumu Nziaambi, baata balaa babwiiri mu masumu. Bumosi ka, mu muutu ndila mosi watumimi Nziaambi, baata balaa bamonii ba libweeye. ");
INSERT INTO iyx_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Mikele miayiri, na bubi bavulili. Ka nha mbuu ya vululu masumu, bweese ba Nziaambi babwavululu iteesi. ");
INSERT INTO iyx_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Ni mubuu, bu masumu mamweesi litu la mo mu uha likwa, bumosi ka, bweese ba Nziaambi bali na lituu loosi, mu ukitisi baata baba balibweeye, mu ubiti bisi ku moonyi wa bilimi na bilimi mu Yiisu Kristo, Pfumu a bisi. ");
INSERT INTO iyx_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Ima dituu ubwaleele? Bisi diafwaana uhama mu uba kutso masumu, paa ti kolokolo a Nziaambi yibwavululu? ");
INSERT INTO iyx_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Pia a buu pe! Bisi dili babakwa mu masumu: Buni bisi dituu ubwaba kutso masumu? ");
INSERT INTO iyx_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Beni a diayaaba pe ti, bisi boosi ba diaholo libootuu mu Yiisu Kristo, ni mu likwa la Nde bisi badibootii? ");
INSERT INTO iyx_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Ni mubuu, mu libootuu badiyii bisi na nde, mu uba itwaari mu likwa la nde. Paa ti, weti bu Kristo asiimbii mu babakwa mu lituu la buzitu ba Taayi, bisi ka didiaata mu moonyi wu munyatii. ");
INSERT INTO iyx_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Mu ngwanya, so bisi dili itwaari na nde mu likwa lafwaanina na la nde, bisi sa diba ka itwaari na nde mu tsimbilili yafwaanina na ya nde. ");
INSERT INTO iyx_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Diyilwani uyaaba ndaa yi: Imuutu kia bisi ki diali na kio katatsiomi, kiakwiiri na Kristo nha kuruwa, paa ti itwaari kia bisi na masumu itsamuu, na paa ti bisi dibwanyaala uba batee kwa masumu. ");
INSERT INTO iyx_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Mu ndaa ti, pasi nde wakwa itwaari na Kristo, ka walibweeye na nde ka bunyanga kwaa masumu. ");
INSERT INTO iyx_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Ka so bisi diakwa na Kristo, bisi dili na imiini ti bisi ka sadiba moonyi itwaari na nde. ");
INSERT INTO iyx_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Ngwanya, bisi diayaaba ti, umata bu Kristo asiimbii mu babakwa, nde a utuu ubwakwa pe: likwa a labwaba na lituu nha yulu a nde pe. ");
INSERT INTO iyx_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Bu akwiiri, nde akwi mbala mosi kwa ikulu, mundaa masumu ma baata. Ka mu taanga di, bu nde ali moonyi nde li moonyi mu Nziaambi. ");
INSERT INTO iyx_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Bu mosi, beni ka, dimonuu weti beni diakwa mu masumu na, dimonuu ka weti babali moonyi mu Nziaambi it