﻿USE sofia;
DROP TABLE IF EXISTS sofia.ixlNNT_vpl;
CREATE TABLE ixlNNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ixlNNT_vpl WRITE;
INSERT INTO ixlNNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","U Jesucristo uvaꞌ tiaal David, as tiaal u Abrahameꞌ Aak unpajte. As ech vibꞌii unqꞌa qꞌesla ibꞌaal Aak ileꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","As ikꞌaol Abraham u Isaac; ikꞌaol u Isaac u Jacob; ikꞌaol u Jacob u Judá tukꞌ unqꞌa titzꞌin tatzikeꞌ; ");
INSERT INTO ixlNNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ikꞌaol u Judá u Fares tukꞌ u Zara. As Tamar ibꞌii vitxutxeꞌ. As ikꞌaol u Fares u Esrom ikꞌaol u Esrom u Aram; ");
INSERT INTO ixlNNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ikꞌaol u Aram u Aminadab; ikꞌaol u Aminadab u Naasón; ikꞌaol u Naasón u Salmón; ");
INSERT INTO ixlNNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ikꞌaol u Salmón u Booz. As itxutx u Booz u Rahab. Ikꞌaol u Booz u Obed. As itxutx u Obed u Rut. Ikꞌaol u Obed u Isaí; ");
INSERT INTO ixlNNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ikꞌaol u Isaí u David uvaꞌ ok ijlenaalil. Ikꞌaol u David u Salomón. As itxutx u Salomón u ixoj uvaꞌ tixqelik u Urías. ");
INSERT INTO ixlNNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ikꞌaol u Salomón u Roboam; ikꞌaol u Roboam u Abías; ikꞌaol u Abías u Asa; ");
INSERT INTO ixlNNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ikꞌaol u Asa u Josafat; ikꞌaol u Josafat u Joram; ikꞌaol u Joram u Uzías; ");
INSERT INTO ixlNNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ikꞌaol u Uzías u Jotam; ikꞌaol u Jotam u Acaz; ikꞌaol u Acaz u Ezequías; ");
INSERT INTO ixlNNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ikꞌaol u Ezequías u Manasés; ikꞌaol u Manasés u Amón; ikꞌaol u Amón u Josías. ");
INSERT INTO ixlNNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","As ech unbꞌiit teqꞌol bꞌen unqꞌa tiaal Israel preexhuil tu u Babilonia, as ikꞌaol veꞌt u Josías u Jeconías tukꞌ unqꞌa titzꞌineꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tul maꞌtik ibꞌen veꞌt unqꞌa tiaal Israel preexhuil tu u Babilonia, as ikꞌaol veꞌt u Jeconías u Salatiel. As ikꞌaol u Salatiel u Zorobabel; ");
INSERT INTO ixlNNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ikꞌaol u Zorobabel u Abiud; ikꞌaol u Abiud u Eliaquim; ikꞌaol u Eliaquim u Azor; ");
INSERT INTO ixlNNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ikꞌaol u Azor u Sadoc; ikꞌaol u Sadoc u Aquim; ikꞌaol u Aquim u Eliud; ");
INSERT INTO ixlNNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ikꞌaol u Eliud u Eleazar; ikꞌaol u Eleazar u Matán; ikꞌaol u Matán u Jacob; ");
INSERT INTO ixlNNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ikꞌaol u Jacob u Xhuꞌl, vitzumel u Maꞌleꞌ. As aꞌ u Maꞌleꞌ vitxutx u Jesús uvaꞌ Cristo. ");
INSERT INTO ixlNNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","As kaalaval jolol unqꞌa tiaal u Abraham uveꞌ xeꞌtik tzan stiꞌ. As aꞌ ulkat tiꞌ u David. Kaalavat jolte uveꞌ xeꞌtik tzan tiꞌ u David. As aꞌ ulkat tul uvaꞌ sitxeypik bꞌen unqꞌa tiaal Israel preexhuil tu Babilonia. Kaalavat jolte tul siqꞌaavik veꞌt tzan unqꞌa tiaal Israel tu vitenameꞌ. As aꞌ ulkat tul uvaꞌ stitzꞌebꞌ u Cristo. ");
INSERT INTO ixlNNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ech u titzꞌebꞌ u Jesucristo ileꞌ. Tul kꞌujlik veꞌt tzii tiꞌ u Maꞌleꞌ tukꞌ u Xhuꞌleꞌ tiꞌ uvaꞌ la teqꞌo tibꞌ chaꞌma as tul yeꞌxnik teqꞌot tibꞌ chaꞌma, as jeꞌ veꞌt ventasioon tiꞌ u Maꞌleꞌ, vitxutx u Jesúseꞌ, taꞌn u Tiixhla Espíritueꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","As jikik chit itxumbꞌal u Xhuꞌleꞌ, vitzumel u Maꞌleꞌ, vatz u Tiixheꞌ. As yeꞌ nikat isaꞌ u Xhuꞌleꞌ teesal iqꞌii u Maꞌleꞌ vatz unqꞌa tenameꞌ. Tal veꞌt jeꞌ u Xhuꞌleꞌ ste uvaꞌ tu kuxh isuuchil la taqꞌ veꞌt kan u Xhuꞌleꞌ u Maꞌleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tul uvaꞌ nikat ibꞌan veꞌt jeꞌ u Xhuꞌleꞌ tiviꞌ, as ul tal veꞌt umaꞌl u ángel ste tivatzikꞌ. As ech tal u ángel ileꞌ: «Axh Xhuꞌl, tiaal David, yeꞌ kuxh xoꞌv axh tiꞌ eeqꞌot eebꞌ tukꞌ u Maꞌleꞌ, tan aꞌ u Tiixhla Espíritueꞌ kat ul aqꞌon kan ventasioon stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","As la til veꞌt ixoj umaꞌl u neꞌ. As tul la itzꞌebꞌi, as Jesús ibꞌii u neꞌeꞌ la ebꞌaneꞌ, tan aꞌeꞌ la qꞌalpun vitenameꞌ vatz vipaaveꞌ,» tiꞌk u ángel tal te u Xhuꞌleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","As ech kat ibꞌan veꞌteꞌ echeꞌ uvaꞌ tal kan u Kubꞌaal Tiixheꞌ taꞌn u qꞌajsan tetz viyoleꞌ tul uvaꞌ ech tal Aak ileꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","La jeꞌ ventasioon tiꞌ umaꞌl u qꞌopo ixoj. As la til ixoj umaꞌl u neꞌ. As tul la oksal ibꞌii u neꞌeꞌ, as Emanuel ibꞌii la ibꞌaneꞌ, tiꞌk viyol u Tiixheꞌ uvaꞌ tal kan. As aꞌ isuuchil u yoleꞌ uvaꞌ Emanuel tu kuyolbꞌal: Ateꞌ u Tiixheꞌ sqiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tul ul taama u Xhuꞌleꞌ taꞌn vivatzikꞌeꞌ, as inima veꞌt u Xhuꞌleꞌ kam uvaꞌ tal u ángel ste. As kꞌuxh teqꞌo veꞌt tibꞌ u Xhuꞌleꞌ tukꞌ u Maꞌleꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","as yeꞌl u Xhuꞌleꞌ nikat ivat kꞌatz u Maꞌleꞌ. Pet itzꞌebꞌnal veꞌt u neꞌeꞌ. As tul itzꞌebꞌ u neꞌeꞌ, as Jesús ibꞌii u neꞌeꞌ uvaꞌ toksa veꞌt u Xhuꞌleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","As tul atik ok u Herodeseꞌ ijlenaalil tu u Judea, as tul bꞌex itzꞌebꞌoj u Jesúseꞌ tu u tal tenameꞌ uvaꞌ Belén, uvaꞌ echen tu u Judea. As oon veꞌt kaꞌl unqꞌa naj tu u Jerusalén uvaꞌ nimal txumbꞌal chusel staꞌn as tukꞌ tiꞌ unqꞌa txꞌumileꞌ. As aꞌ tzaanajkat chajnaj tu u bꞌuuqꞌebꞌal qꞌii. ");
INSERT INTO ixlNNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","As ech ul tal chajnaj ileꞌ: —¿Katil atkat u tijlenaal unqꞌa tiaal Israel uvaꞌ kat itzꞌebꞌya? Tan tul atik oꞌ tu u bꞌuuqꞌebꞌal qꞌii as kat qil tzan umaꞌl u txꞌumil, texhlal tetz uvaꞌ kat itzꞌebꞌya. Estiꞌeꞌ il oꞌ quleꞌ tiꞌ qoksat iqꞌii u neꞌeꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","As bꞌex alpo veꞌt te u Herodes uvaꞌ nikat tal chajnaj. As samun veꞌt naj tukꞌ unqꞌa aa Jerusaléneꞌ skajayil taꞌn u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","As oora chit imolo veꞌt u Herodes unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh uvaꞌ atik tu u Jerusaléneꞌ tukꞌ unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ. As ichꞌoti veꞌt naj te chajnaj uvaꞌ katil la itzꞌebꞌkat u Cristo. ");
INSERT INTO ixlNNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","As ech tal veꞌt chajnaj ileꞌ: —Echen la itzꞌebꞌkat u Cristoeꞌ tu u tal tenameꞌ uveꞌ Belén uvaꞌ echen tzitzaꞌ tu u Judea, tan echeꞌ ni tal u yoleꞌ uvaꞌ tzꞌibꞌamal kan taꞌn umaꞌl u qꞌajsan tetz viyol u Tiixheꞌ uvaꞌ ech ni tal ileꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Axh u tal tenam uveꞌ Belén uvaꞌ echen tu u Judea, tan kꞌuxh yeꞌl aqꞌii xoꞌl unjoltu unqꞌa tenameꞌ tu u Judea, as axh la aqꞌon el tzan umaꞌl u eqꞌon tetz bꞌey vatz vuntenameꞌ uvaꞌ tiaal Israel, tiꞌk u yoleꞌ tal kan,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","As ijutxi veꞌt u Herodeseꞌ imolol unqꞌa najeꞌ uvaꞌ chuselik tibꞌ tiꞌ unqꞌa txꞌumileꞌ. As ibꞌan veꞌt u Herodeseꞌ ichꞌotil te chajnaj uvaꞌ jatvaꞌx qꞌii ichee u txꞌumileꞌ uveꞌ til chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","As ech tal veꞌt u Herodes ileꞌ tul ichaj bꞌen naj chajnaj tu u Belén: —Bꞌenoj ex tu u Belén. As bꞌenoj etabꞌi itzibꞌlal u neꞌeꞌ sbꞌaꞌn. As tul la elejeꞌ, as la ul etal sve, tan la bꞌen vileꞌ tiꞌ voksat iqꞌii,— tiꞌk u Herodeseꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","As tul tabꞌi chajnaj viyol u Herodeseꞌ, as bꞌen veꞌt chajnaj. As an chit u txꞌumileꞌ uvaꞌ maꞌtik tilat chajnaj tu u bꞌuuqꞌebꞌal qꞌii as til veꞌt chajnaj unpajte. As aꞌeꞌ eqꞌon bꞌey vatz chajnaj. As aꞌ bꞌex txakebꞌojkat u txꞌumileꞌ tiibꞌa u kabꞌaleꞌ uveꞌ atikkat u neꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","As vaꞌlik chit itxuqꞌtxun veꞌt chajnaj tul til veꞌt chajnaj u txꞌumileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","As ok veꞌt chajnaj tu u kabꞌaleꞌ. As til veꞌt chajnaj u neꞌeꞌ kꞌatz vitxutxeꞌ, u Maꞌleꞌ. As kuꞌ veꞌt chajnaj qaaloj svatz tiꞌ toksal iqꞌii u neꞌeꞌ. As ijaj veꞌt chajnaj unqꞌa ikaaxhaeꞌ. As toya veꞌt chajnaj u bꞌaꞌnla qꞌan chꞌichꞌeꞌ te u neꞌeꞌ, tukꞌ incienso, as tukꞌ txꞌumtxꞌulla tzꞌakabꞌal uvaꞌ mirra ibꞌii. ");
INSERT INTO ixlNNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tul qꞌaav veꞌt chajnaj, as ul alpo te chajnaj tivatzikꞌ uvaꞌ yeꞌ la qꞌaav veꞌt chajnaj vatz u Herodeseꞌ. Estiꞌeꞌ vaꞌlen bꞌey teqꞌo veꞌt chajnaj tiꞌ iqꞌaav tu vitenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tul kuxh el chꞌuꞌl unqꞌa najeꞌ uvaꞌ chuselik tibꞌ tiꞌ unqꞌa txꞌumileꞌ, as ul veꞌt umaꞌl u ángel tivatzikꞌ u Xhuꞌleꞌ unpajte. As ech ul tal ileꞌ: «Xhuꞌl, txakpen. As kuxh tu u Egipto tukꞌ u neꞌeꞌ as tukꞌ vitxutxeꞌ. As la atin ex tzitziꞌ. As in lanal alon see uvaꞌ jatu la el chꞌuꞌl ex tzitziꞌ, tan tuk ichuk u Herodes u neꞌeꞌ tiꞌ iyatzꞌataꞌ,» tiꞌk u ángeleꞌ tal te u Xhuꞌleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","As yak kuxh ul veꞌt taama u Xhuꞌleꞌ tu u aqꞌbꞌaleꞌ. As txakpu veꞌteꞌ. As teqꞌo veꞌt u neꞌeꞌ tukꞌ vitxutxeꞌ. As bꞌen veꞌt tu u Egipto. ");
INSERT INTO ixlNNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Aꞌ atinkat chaꞌma tu u Egiptoeꞌ. Pet kamnal veꞌt u Herodes. As bꞌex ibꞌana kam uvaꞌ tal u Tiixheꞌ te unqꞌa qꞌajsan tetz viyoleꞌ, tan ech tal Aak ileꞌ: «Kat unmolo tzan vunKꞌaoleꞌ tu u Egipto,» tiꞌk u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Tul til veꞌt u Herodeseꞌ uvaꞌ chulil kan naj syol taꞌn unqꞌa najeꞌ uvaꞌ chuselik tibꞌ tiꞌ unqꞌa txꞌumileꞌ, as ul veꞌt iviꞌ naj. As ichaj veꞌt bꞌen naj unqꞌa soleꞌ tiꞌ iyatzꞌat unqꞌa talaj neꞌ xaakeꞌ tu u Beléneꞌ tukꞌ tu unqꞌa talaj tenameꞌ uvaꞌ najlich u Belén. As aꞌ unqꞌa neꞌeꞌ yatzꞌpi uveꞌ yeꞌxnik ibꞌan kaꞌvaꞌl iyaabꞌ, tan aꞌ bꞌenkat u Herodeseꞌ tiꞌ tachax unqꞌa qꞌiieꞌ uvaꞌ alax ste taꞌn unqꞌa najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","As bꞌex ibꞌan u yoleꞌ uvaꞌ tal kan u Tiixheꞌ taꞌn u qꞌajsan tetz viyoleꞌ uvaꞌ Jeremías, tul ech tal ileꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","La abꞌil veꞌt tuul iviꞌ unqꞌa ixojeꞌ tu u Ramá uvaꞌ saqꞌchibꞌal chit toqꞌeꞌ, tan kat kamyu veꞌt unqꞌa taleꞌ. As aꞌ u Raquel ni toqꞌeꞌ tiꞌ unqꞌa taleꞌ uveꞌ kat kami. As yeꞌ nisaꞌ uvaꞌ la mutxbꞌeli, tiꞌk u Jeremíaseꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Tul maꞌtik ikam veꞌt u Herodeseꞌ, as ul tal umaꞌl u ángel tivatzikꞌ u Xhuꞌleꞌ tu u Egipto. ");
INSERT INTO ixlNNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","As ech ul tal ileꞌ: «Xhuꞌl, txakpen. Kuxh veꞌteꞌ tukꞌ u neꞌeꞌ as tukꞌ vitxutxeꞌ. As qꞌaavoj ex tu vetenameꞌ, tan kat kamyu veꞌt u Herodeseꞌ uvaꞌ nikat alon ikam u neꞌeꞌ,» tiꞌk u ángel. ");
INSERT INTO ixlNNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","As txakpu veꞌt u Xhuꞌleꞌ. As teqꞌo veꞌt u neꞌeꞌ tukꞌ vitxutxeꞌ. As qꞌaav veꞌt chaꞌma tu u txꞌavaꞌeꞌ uvaꞌ tetz unqꞌa tiaal Israeleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","As tul tabꞌi u Xhuꞌleꞌ uvaꞌ aꞌ u Arquelao, vikꞌaol u Herodeseꞌ, atik veꞌt ok ijlenaalil sichꞌexel vibꞌaaleꞌ tu u Judea, as xoꞌv veꞌt u Xhuꞌleꞌ tiꞌ toon tu u Judea. As ul tal veꞌt u ángel tivatzikꞌ uvaꞌ la uch ibꞌen tu u Galilea. As estiꞌeꞌ aꞌ bꞌenkat veꞌt tu u Galilea. ");
INSERT INTO ixlNNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","As bꞌex veꞌt chaꞌma jejebꞌoj tu u tenameꞌ uvaꞌ Nazaret. As bꞌex ibꞌan veꞌt u yoleꞌ uveꞌ alel kan taꞌn unqꞌa qꞌajsan tetz viyol u Tiixheꞌ uvaꞌ aa Nazaret u Jesúseꞌ la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","As tu veꞌt unqꞌa qꞌiieꞌ, as ul tal veꞌt u Xhuneꞌ viyol u Tiixheꞌ tu u tzuukin txꞌavaꞌeꞌ uvaꞌ at tu u Judeaeꞌ. As aꞌ u Xhuneꞌ uvaꞌ nik aqꞌon kuꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","As ech nik tal u Xhun ileꞌ tul nik tal viyol u Tiixheꞌ: —¡Ekꞌaxataj vepaaveꞌ! Tan il u Tiixh ileꞌ tul veꞌt tukꞌ u tijleꞌmeꞌ tiꞌ vitenameꞌ,— tiꞌk u Xhuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","As aꞌ u Xhuneꞌ uveꞌ kat tal kan u Isaías, u qꞌajsan tetz viyol u Tiixheꞌ, tul ech tal ileꞌ: Tan la uch umaꞌl u sikꞌiꞌm tu u tzuukin txꞌavaꞌeꞌ. As ech la tal ileꞌ: «¡Ebꞌantaj etucheꞌ tiꞌ ekꞌulat u Kubꞌaaleꞌ! ¡As ejikbꞌaꞌtaj vetxumbꞌaleꞌ echeꞌ ijikbꞌaꞌl umaj bꞌey!» chaj la taleꞌ, tiꞌk u Isaías. ");
INSERT INTO ixlNNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","As u toksaꞌm u Xhuneꞌ, as aꞌ vixiꞌl u camello uvaꞌ chemike. As kꞌalik ok umaꞌl u tzꞌuꞌm xeꞌ tuul. As aꞌ unqꞌa sakꞌeꞌ nik techbꞌu tukꞌ u taꞌl kabꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","As mamaꞌla tenam nikat tex abꞌin veꞌt viyol u Xhuneꞌ. At uxhchil tzaa tu u Jerusalén as tukꞌ tu u Judeaeꞌ skajayil. As at uxhchil tzaa tu unqꞌa talaj tenameꞌ tziꞌ u nimla aꞌeꞌ uvaꞌ Jordán ibꞌii. ");
INSERT INTO ixlNNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","As jankꞌal unqꞌa uxhchileꞌ uveꞌ nikat tal vipaaveꞌ te u Tiixheꞌ, as taqꞌ veꞌt kuꞌ u Xhuneꞌ unqꞌa uxhchileꞌ xeꞌ u nimla aꞌeꞌ tukꞌ vibꞌii u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tul til veꞌt u Xhuneꞌ uvaꞌ yeꞌ saach unqꞌa fariseoeꞌ tukꞌ unqꞌa saduceoeꞌ ooni tiꞌ uvaꞌ la kuꞌ xeꞌ u aꞌeꞌ, as ech tal veꞌt u Xhun ileꞌ te chajnaj: —¡Ech vetxumbꞌaleꞌ echeꞌ u txꞌiꞌlatxooeꞌ! ¿Tan abꞌil kat alon sete uvaꞌ la ooj ex vatz u kꞌaxkꞌoeꞌ uveꞌ tuleꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ebꞌantaj u bꞌaꞌneꞌ, texhlal tetz uvaꞌ kat ekꞌaxal etibꞌ vatz u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","As yeꞌ etitzꞌa uvaꞌ tiꞌ kuxh uvaꞌ: «Oꞌ tiaal u Abraham,» chꞌex netaleꞌ, as yeꞌl ex la pal ex tu u kꞌaxkꞌoeꞌ uvaꞌ tuleꞌ. Pet tuk val sete uvaꞌ echeꞌ kꞌaxkꞌo koj ibꞌensat u Tiixheꞌ unqꞌa kꞌubꞌeꞌ stiaal u Abraham. ");
INSERT INTO ixlNNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","As ech veꞌt bꞌanel etaꞌneꞌ echeꞌ unqꞌa tzeꞌeꞌ uvaꞌ at veꞌt ok u kꞌoxbꞌaleꞌ stiꞌ tiꞌ itzokꞌpu unqꞌa taqꞌil tzeꞌeꞌ. As abꞌiste u tzeꞌeꞌ uveꞌ yeꞌ bꞌaꞌn vivatzeꞌ ni taqꞌeꞌ, as la tzokꞌax el. As la sutil ok tu xamal. ");
INSERT INTO ixlNNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Jik chit tuk val sete, tan xeꞌ kuxh aꞌeꞌ ni vaqꞌkat kuꞌ ex, texhlal tetz uvaꞌ kat ekꞌaxal vepaaveꞌ. Pet ech koj umaꞌt u uxhchileꞌ uvaꞌ aꞌn tuleꞌ, tan nimeꞌ u tijleꞌmeꞌ sviꞌ. As jit unkꞌuleleꞌ uvaꞌ la unsaapu vixaꞌpeꞌ. As tul la uli, as Aakeꞌ la oksan u Tiixhla Espíritu tu vetaanxelaleꞌ, as la ijikbꞌaꞌ veꞌt ex Aak tukꞌ vixamalileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tan ech la bꞌancheꞌ sete echeꞌ nibꞌanchu te u trigo, tan il u txaabꞌal tetz u trigoeꞌ ileꞌ at tiqꞌabꞌ Aak. As la ikol veꞌt Aak u bꞌaꞌnla trigoeꞌ tu u tatinbꞌaleꞌ. Pet ech koj u chꞌiseꞌ, tan yakloꞌk tu u xamaleꞌ, umaꞌl u xamal uvaꞌ yeꞌxh jatu la tzaai,— tiꞌk u Xhuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","As tzaa veꞌt u Jesúseꞌ tu u Galilea. As ul veꞌt Aak tziꞌ u Jordáneꞌ uvaꞌ atikkat u Xhuneꞌ, tiꞌ uvaꞌ la aqꞌax veꞌt kuꞌ Aak xeꞌ u aꞌeꞌ taꞌn u Xhuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","As yeꞌ nikat isaꞌ u Xhuneꞌ. As ech tal u Xhun ileꞌ te u Jesúseꞌ: —Yeꞌle, Pap, tan ¿kam qꞌii uvaꞌ in la aqꞌon kuꞌ axh xeꞌ u aꞌeꞌ? Pet axheꞌ la aqꞌon kuꞌ in xeꞌ u aꞌeꞌ. As tul aꞌ naaleꞌ uvaꞌ in la aqꞌon kuꞌ axh,— tiꞌk u Xhuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","As ech tal veꞌt u Jesúseꞌ ileꞌ: —Techal la untzojpisa uvaꞌ ni tal u Tiixheꞌ,— tiꞌk u Jesúseꞌ. As inima veꞌt u Xhuneꞌ viyol u Jesúseꞌ. As taqꞌ veꞌt kuꞌ u Xhuneꞌ u Jesúseꞌ xeꞌ u aꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","As tul jeꞌ veꞌt chꞌuꞌl u Jesúseꞌ xeꞌ u aꞌeꞌ, as ijajpu veꞌt tibꞌ u almikaꞌeꞌ. As til veꞌt Aak ikuꞌ chꞌuꞌl u Tiixhla Espíritu tu almikaꞌ uvaꞌ ech ikuꞌ chꞌuꞌleꞌ echeꞌ umaj u paroomaxh. As ul veꞌt tiibꞌa u Jesúseꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","As abꞌil umaꞌl u yol tu almikaꞌ uvaꞌ ech tal ileꞌ: —Aꞌ vunKꞌaoleꞌ uvaꞌ, xoꞌn chit sve. As vaꞌl chit untxuqꞌtxun veꞌt stiꞌ,— tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","As bꞌen veꞌt u Jesúseꞌ tu u tzuukin txꞌavaꞌeꞌ taꞌn u Tiixhla Espíritueꞌ, tiꞌ uvaꞌ la ichuk u txꞌiꞌlanajeꞌ txumbꞌal tiꞌ ipaavin u Jesúseꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","As kaꞌviinqil qꞌii tukꞌ kaꞌviinqit aqꞌbꞌal uvaꞌ yeꞌl u Jesúseꞌ nikat itxꞌaꞌneꞌ. As vaꞌy veꞌt Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","As ul veꞌt u txꞌiꞌlanajeꞌ kꞌatz u Jesúseꞌ. As ech tal veꞌt naj ileꞌ: —Asoj axh iKꞌaol u Tiixheꞌ, as ala uvaꞌ la bꞌen unqꞌa kꞌubꞌeꞌ txꞌixil,— tiꞌk u txꞌiꞌlanajeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ech tal veꞌt u Jesús ileꞌ: —Ech ni tal viyol u Tiixh ileꞌ uvaꞌ tzꞌibꞌamal kan: Jit kuxh u txꞌixeꞌ la isbꞌaꞌn unqꞌa uxhchileꞌ. Pet kajayil chit unqꞌa yoleꞌ uveꞌ ni tel chꞌuꞌl titziꞌ u Kubꞌaal Tiixheꞌ, as aꞌeꞌ uveꞌ la isbꞌaꞌn unqꞌa uxhchileꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","As bꞌen veꞌt u Jesúseꞌ taꞌn u txꞌiꞌlanajeꞌ tu u tenam uvaꞌ txaael taꞌn u Tiixheꞌ uvaꞌ Jerusalén. As jeꞌ veꞌt Aak viꞌ u tostiixheꞌ taꞌn u txꞌiꞌlanajeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","As ech tal veꞌt naj ileꞌ: —Asoj axh viKꞌaol u Tiixheꞌ, as suti kuꞌ eebꞌ tzitzaꞌ, tan ech ni tal u yol ileꞌ uvaꞌ tzꞌibꞌamal kan: La ichaj tzan u Tiixheꞌ unqꞌa ángel tiꞌ ul ilochat axh. As la ul ikꞌul axh unqꞌa ángel aqꞌal uvaꞌ yeꞌ la kꞌaxbꞌu veꞌt avoj tiꞌ umaj u kꞌubꞌ,— tiꞌk u txꞌiꞌlanajeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ech tal veꞌt u Jesús ileꞌ: —Ech ni tal viyol u Tiixh ileꞌ uvaꞌ tzꞌibꞌamal kan: Yeꞌ la uch abꞌekꞌat u Kubꞌaal Tiixheꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","As bꞌen veꞌt u Jesúseꞌ viꞌ umaꞌl u nimla vitz taꞌn u txꞌiꞌlanajeꞌ. As ikꞌuch veꞌt u txꞌiꞌlanajeꞌ te u Jesúseꞌ jankꞌal unqꞌa veeꞌ at tulaj unqꞌa tenameꞌ skajayil vatz u txꞌavaꞌeꞌ as tukꞌ unqꞌa itxꞌiibꞌal iqꞌii unqꞌa tenameꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","As ech tal naj ileꞌ: —Asoj la kuꞌ axh qaaloj sunvatz tiꞌ ooksat unqꞌii, as la vaqꞌ unqꞌa veeꞌ see skajayil,— tiꞌk u txꞌiꞌlanajeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ech tal veꞌt u Jesús ileꞌ: —Jetzꞌen el sunvatz, txꞌiꞌlanaj, tan ech ni tal umaꞌt u yol ileꞌ uvaꞌ tzꞌibꞌamal kan: Taꞌn kuxh u Tiixheꞌ, u Kubꞌaaleꞌ, la kuꞌ axh qaaloj svatz. As Aak kuxheꞌ la anima,— tiꞌk u Jesúseꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","As taqꞌ veꞌt kan u txꞌiꞌlanajeꞌ u Jesúseꞌ. As ul veꞌt kaꞌl unqꞌa ángel kꞌatz Aak tiꞌ ilochpu veꞌt Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","As tul tabꞌi veꞌt u Jesúseꞌ yol uvaꞌ maꞌtik tok veꞌt u Xhuneꞌ tu u kaarsa, as qꞌaav veꞌt Aak tu u Galilea. ");
INSERT INTO ixlNNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","As taqꞌ veꞌt kan Aak u Nazaret. As aꞌ bꞌexkat veꞌt Aak jejebꞌoj tu u Capernaúm uvaꞌ echen tziꞌ u nimla naabꞌeꞌ uvaꞌ atikkat vitxꞌavaꞌ u Zabulón tukꞌ u Neftalí. ");
INSERT INTO ixlNNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","As bꞌex ibꞌan veꞌt u yoleꞌ uveꞌ alelik kan taꞌn u Isaías, u qꞌajsan tetz viyol u Tiixheꞌ, uvaꞌ ech nik tal ileꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Unqꞌa uxhchileꞌ uveꞌ jejleꞌl tu vitxꞌavaꞌ u Zabulón tukꞌ tu vitxꞌavaꞌ u Neftalí, tukꞌ unqꞌa uxhchileꞌ uvaꞌ echen najlich u nimla bꞌeyeꞌ uvaꞌ yakleꞌl tziꞌ u mareꞌ, tukꞌ unqꞌa uxhchileꞌ uvaꞌ echen jalit u Jordán, as tukꞌ unqꞌa jit tiaal Israel uvaꞌ jejleꞌl tu u Galilea, ");
INSERT INTO ixlNNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","as aꞌ unqꞌa tenameꞌ uvaꞌ eyen u taanxelaleꞌ tu u qꞌej toktoeꞌ. As la til veꞌt unqꞌa tenameꞌ umaꞌl u txijun tetz u taanxelaleꞌ uvaꞌ nim talcheꞌ. As jankꞌal unqꞌa tenameꞌ uvaꞌ at tzan u kamchileꞌ stiꞌ, as la txijul veꞌteꞌ, tiꞌk u yoleꞌ uveꞌ tal kan u Isaías. ");
INSERT INTO ixlNNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tul kat oon veꞌt u Jesús tu u Capernaúm, as xeꞌt veꞌt Aak tiꞌ talat viyol u Tiixheꞌ. As ech nik tal Aak ileꞌ: —¡Ekꞌaxataj vepaaveꞌ! Tan il u Tiixh ileꞌ tul veꞌteꞌ tukꞌ u tijleꞌmeꞌ tiꞌ vitenameꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Tul nik ixaan u Jesús tziꞌ u mar tu u Galilea, as til veꞌt Aak u Simón uvaꞌ Luꞌ, tukꞌ u titzꞌineꞌ uvaꞌ Lixh. As nik isuti bꞌen chajnaj vikꞌacheꞌ xeꞌ u mar, tan txeyol txay chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","As ech tal u Jesús ileꞌ te chajnaj: —Xekebꞌoj ex sviꞌ. As la voksa veꞌt ex tiꞌ uvaꞌ la eteqꞌo tzan unqꞌa tenameꞌ tiꞌ tok sunkꞌatz,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","As yak kuxh taqꞌ veꞌt kan chajnaj unqꞌa ikꞌacheꞌ. As xekebꞌ veꞌt chajnaj tiꞌ u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Bꞌiil kuxh ixaa u Jesús. As bꞌex ilej Aak kaꞌvaꞌt unqꞌa txeyol txay uvaꞌ titzꞌin tibꞌ, tukꞌ u Jacobo tukꞌ u Xhun, vikꞌaol u Zebedeo. As xonlik kuxh chajnaj tukꞌ vibꞌaaleꞌ tu u barco, tan nikat kuxh ikꞌooa chajnaj unqꞌa ikꞌacheꞌ. As imolo veꞌt u Jesús chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","As yak kuxh taqꞌ veꞌt kan chajnaj vibꞌaaleꞌ tukꞌ u barco. As xekebꞌ veꞌt chajnaj tiꞌ u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","As bꞌex veꞌt u Jesús chusun tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh, tulaj unqꞌa talaj tenameꞌ tu u Galilea skajayil. As nikat tal u Jesús isuuchil u bꞌaꞌnla yoleꞌ tiꞌ u Tiixheꞌ uvaꞌ la ul veꞌt tukꞌ u tijleꞌmeꞌ tiꞌ vitenameꞌ. As nikat ibꞌaꞌnxisa veꞌt Aak unqꞌa aachꞌoꞌmeꞌ skajayil, kꞌuxh kam kuxh chꞌoꞌmil. ");
INSERT INTO ixlNNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","As pax veꞌt itzibꞌlal Aak tulaj unqꞌa tenameꞌ tu u Siria. As mamaꞌla aachꞌoꞌm eqꞌol tzan vatz Aak. As ati uvaꞌ subꞌul atik ok skꞌatz. As ati uvaꞌ chꞌuꞌjil elnallukat. As ati uvaꞌ yeꞌ nikat itxꞌol itiin vichiꞌoleꞌ. As kat ibꞌaꞌnxisa veꞌt u Jesús skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","As mamaꞌla tenam xekelik tiꞌ Aak. As xekelik unqꞌa aa Galilea tukꞌ unqꞌa aa Decápolis, tukꞌ unqꞌa aa Jerusalén, tukꞌ kaꞌt unqꞌa aa Judea, as tukꞌ kaꞌt unqꞌa tenameꞌ uvaꞌ jalit u Jordán. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","As til veꞌt u Jesús u mamaꞌla tenam. As jeꞌ veꞌt Aak viꞌ umaꞌl u vitz. As xonebꞌ veꞌt tzan Aak. As jetzꞌen veꞌt ok unqꞌa ichusulibꞌ Aakeꞌ skꞌatz. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","As xeꞌt veꞌt Aak chusun. As ech tal veꞌt Aak ileꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Achvebꞌal chit unqꞌa uxhchileꞌ uveꞌ ootzimal staꞌn uvaꞌ techal chit la lochpu taꞌn u Tiixheꞌ, tan aꞌ uxhchileꞌ uvaꞌ at tokebꞌal xoꞌl unqꞌa tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","As achvebꞌal chit unqꞌa uxhchileꞌ uveꞌ nitxumuneꞌ, tan la mutxbꞌel veꞌteꞌ taꞌn u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","As achvebꞌal chit unqꞌa uxhchileꞌ uveꞌ sula aama, tan tetzeꞌ u vatz txꞌavaꞌeꞌ skajayil la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","As achvebꞌal chit unqꞌa uxhchileꞌ uveꞌ nivaꞌy u taanxelaleꞌ as nitzaj itziꞌ tiꞌ ibꞌanat u jikeꞌ uvaꞌ ni tal viyol u Tiixheꞌ, tan aꞌeꞌ la lochpu taꞌn Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","As achvebꞌal chit unqꞌa uxhchileꞌ uveꞌ nitxum ivatz imool, tan la itxum u Tiixheꞌ ivatz. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","As achvebꞌal chit unqꞌa uxhchileꞌ uveꞌ txꞌaael veꞌt u taanxelaleꞌ taꞌn u Tiixheꞌ, tan la til veꞌt tibꞌ tukꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","As achvebꞌal chit unqꞌa uxhchileꞌ uveꞌ nichukun txumbꞌal tiꞌ iyaꞌsal chꞌaꞌo, tan aꞌeꞌ uvaꞌ meꞌal ikꞌaol u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","As achvebꞌal chit unqꞌa uxhchileꞌ uveꞌ ni palebꞌen unqꞌa kꞌaxkꞌoeꞌ tiꞌ ibꞌanat u jikeꞌ vatz u Tiixheꞌ, tan aꞌ uxhchileꞌ uvaꞌ at tokebꞌal xoꞌl unqꞌa tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","As achvebꞌal chit ex tiꞌ uvaꞌ nenima in as kꞌuxh la xeꞌt unqꞌa uxhchileꞌ setiꞌ. As la yoqꞌpu veꞌt ex. As kam kuxh chuli yolil la alpu setiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Chiibꞌojtaj ex. As txuqꞌtxunoj ex, tan nimeꞌ vetxꞌajaꞌmeꞌ tuk aqꞌaxoj sete tu almikaꞌ. As chiibꞌojtaj ex kꞌuxh la epalebꞌe kꞌaxkꞌo, tan ech chit kat ulbꞌel unqꞌa qꞌajsan tetz viyol u Tiixheꞌ tul uvaꞌ yeꞌxnik ul ex. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","As ech exeꞌ u atzꞌameꞌ xoꞌl unqꞌa tenameꞌ. Pet asoj la pal veꞌt ipitzꞌpolil u atzꞌameꞌ, as yeꞌ la txakon veꞌteꞌ, tan la koj uch ichee ipitzꞌpolil unpajte. Pet la kuxh makꞌpik veꞌt eleꞌ tu bꞌey. As la pal ipachꞌ veꞌt unqꞌa xaoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","As ech exeꞌ echeꞌ umaj txijubꞌal xoꞌl unqꞌa tenameꞌ, echeꞌ umaꞌl u tenam uvaꞌ at jeꞌ viꞌ umaꞌl u vitz, tan kajayil uxhchil la ilon. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","As la koj uchi uvaꞌ tul la matxax umaj xamal, as aꞌ la mujaxkat ok jaqꞌ umaj kaaxha. Pet aꞌ la aqꞌaxkat jeꞌ viꞌ u matxbꞌaleꞌ, aqꞌal uvaꞌ la itxiju u xamaleꞌ unqꞌa uxhchileꞌ skajayil uveꞌ at tu u kabꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Echat chit ex la ibꞌaneꞌ, tan exeꞌ la kꞌuchun u bꞌaꞌneꞌ vatz unqꞌa uxhchileꞌ echeꞌ nibꞌan u xamaleꞌ tul nitxijuneꞌ. As la til unqꞌa uxhchileꞌ u bꞌaꞌneꞌ uveꞌ nebꞌaneꞌ. As la toksa veꞌt unqꞌa uxhchileꞌ iqꞌii u Kubꞌaal Tiixheꞌ uvaꞌ echen tu almikaꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Kamal netitzꞌa uvaꞌ kat ul in tiꞌ ul veesat iyakꞌil u tzaqꞌiteꞌ uvaꞌ tzꞌibꞌamal kan taꞌn u Moisés, tukꞌ viyol unqꞌa qꞌajsan tetz viyol Aakeꞌ. As jit eesamal iqꞌiieꞌ kat ul unbꞌana. Pet kat ul in tiꞌ ul valat isuuchil, as tiꞌ ul unbꞌanataꞌ kam uveꞌ nital sviꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","As tuk val sete, tan tul yeꞌxnaj sotz u almikaꞌeꞌ tukꞌ u vatz txꞌavaꞌeꞌ, as yeꞌle uvaꞌ yeꞌ koj tuk ibꞌan umaj yol uvaꞌ tzꞌibꞌamal kan. Pet techal chiteꞌ tuk ibꞌaneꞌ skajayil kam uveꞌ tzꞌibꞌamal kan. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Tan abꞌil uvaꞌ la teesa iyakꞌil umaj unqꞌa tzaqꞌiteꞌ uveꞌ tzꞌibꞌamal kan uvaꞌ chꞌoo kuxh iyolbꞌeleꞌ, asoj la ichus te unqꞌa tenameꞌ uvaꞌ yeꞌ la nimali, as la eesal iqꞌii u uxhchileꞌ xoꞌl unqꞌa tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. Pet abꞌil uveꞌ la niman unqꞌa tzaqꞌiteꞌ as la ichus te unqꞌa tenameꞌ uvaꞌ la nimali, as nim chit talcheꞌ la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","As tuk val sete, asoj yeꞌ la pal ex tiꞌ enimat u jikla tzaqꞌiteꞌ tiꞌ uvaꞌ nibꞌan unqꞌa fariseo as tukꞌ unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as yeꞌl etokebꞌal xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","As ootzimal setaꞌn uvaꞌ ech ni tal umaꞌl u yol ileꞌ uvaꞌ alax kan te unqꞌa tenameꞌ uvaꞌ naꞌytzan: «Eyatzꞌak umaj uxhchil, tan abꞌil uveꞌ la yatzꞌoni as tetz chit veꞌteꞌ uvaꞌ la bꞌen tu u choobꞌal paaveꞌ,» tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pet tuk val sete, as abꞌil uveꞌ la kuxh ul iviꞌ tiꞌ umaj imool, as la chee ipaav vatz u bꞌanol isuuchil unqꞌa tenameꞌ. As abꞌil uveꞌ la toksa jeꞌ iqꞌii tul la teesa iqꞌii vimooleꞌ, as la chee ipaav vatz unqꞌa bꞌanol isuuchil u tenameꞌ uveꞌ molel tibꞌ. As abꞌil uveꞌ la chiꞌan taama tiꞌ vimooleꞌ tul niyoqꞌon stiꞌ, as aꞌ la aqꞌaxkat veꞌt bꞌen tu u choobꞌal paaveꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","As tuk val sete, tul la eteqꞌo bꞌen umaj oy vatz u atinbꞌaleꞌ uvaꞌ niyatzꞌpukat unqꞌa txooeꞌ, asoj la ul sekꞌuꞌl uvaꞌ yael etibꞌ tukꞌ umaj etitzꞌin etatzik, ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","as la etaqꞌ kan u oyeꞌ vatz u nachbꞌal Tiixheꞌ. As la bꞌen echuk vetitzꞌin etatzikeꞌ uveꞌ yael etibꞌ stukꞌ. As tul la ikꞌul tibꞌ eyol stukꞌ, as aꞌn la bꞌen etaqꞌoꞌk u oyeꞌ vatz u nachbꞌal Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Asoj at umaj uxhchil ni alon uvaꞌ la ixoch ex, as tul uvaꞌ atil ex tu bꞌey, as oora kuxh la eyol sevatzaj tiꞌ u yaaibꞌeꞌ uvaꞌ nebꞌaneꞌ, tan la ibꞌaneꞌ uvaꞌ la bꞌen ixoch ex te u bꞌaal tenameꞌ. As la aqꞌax veꞌt ok ex tiqꞌabꞌ u mayuleꞌ uveꞌ ni xeen u kaarsaeꞌ. As la juplik veꞌt ok ex tu u kaarsa. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","As jik chit ni val sete, tan yeꞌl exeꞌ la el chꞌuꞌl ex tu u kaarsaeꞌ. Pet lanal chit echoo skajayil, jankꞌal uvaꞌ la ijaj u bꞌanol isuuchil unqꞌa tenameꞌ sete. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","As ootzimal setaꞌn uvaꞌ ech ni tal umaꞌt u yol ileꞌ uvaꞌ alax kan: Yeꞌ la ichuk u najeꞌ tixoj. As yeꞌ la moolin u ixojeꞌ, tiꞌk u tzaqꞌiteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pet tuk val sete, tan abꞌil uveꞌ la ilon umaj ixoj asoj la kuxh tachva bꞌen naj u ixojeꞌ tiꞌ ibꞌanat u vaꞌlexheꞌ stukꞌ, as kat paavinyu veꞌt naj tu u taanxelaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Asoj la paavin ex taꞌn u sebꞌal evatzeꞌ, as eyaꞌsataj epaavineꞌ eela kuxh stukꞌ uvaꞌ kat eteesal el u bꞌaqꞌ evatzeꞌ, tan aal bꞌaꞌneꞌ uvaꞌ la etzꞌej umaj u bꞌaqꞌ evatzeꞌ. As yeꞌ la bꞌen vechiꞌoleꞌ skajayil tu u choobꞌal paaveꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Asoj la paavin ex taꞌn u sebꞌal eqꞌabꞌeꞌ, as eyaꞌsataj epaavineꞌ eela kuxh stukꞌ uvaꞌ kat etzokꞌlu el veqꞌabꞌeꞌ as kat sutil el, tan aal bꞌaꞌneꞌ uvaꞌ la etzꞌej umaj veqꞌabꞌeꞌ. As yeꞌ la bꞌen vechiꞌoleꞌ skajayil tu u choobꞌal paaveꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","As ootzimal setaꞌn unpajte uvaꞌ alax kan uvaꞌ ech ni tal ileꞌ: Abꞌil la ijatx tibꞌ tukꞌ tixqel as techanal la taqꞌ naj umaꞌl u uꞌuj tiqꞌabꞌ ixoj, texhlal tetz uvaꞌ jatxel veꞌt tibꞌ naj tukꞌ ixoj, tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pet tuk val sete, tan asoj la ijatx tibꞌ u najeꞌ tukꞌ u tixqeleꞌ, as tul yeꞌl ixoj kat iyansa tibꞌ tukꞌ umaꞌtoj naj, as iqꞌaaqꞌal naj uvaꞌ la paavin u tixqel najeꞌ. As abꞌil la teqꞌo tibꞌ tukꞌ u ixojeꞌ, as la paavin veꞌteꞌ kꞌatz ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","As abꞌimal umaꞌt u yol setaꞌn uvaꞌ alax kan te unqꞌa tenameꞌ naꞌytzan uvaꞌ ech tal ileꞌ: Asoj la aal umaj ayol tukꞌ viBꞌii u Tiixheꞌ, as techal la atzojpisa kam uvaꞌ kat aala. As yeꞌ la achuli yol, tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pet tuk val sete, tan kaminiꞌk kuxh etoksa kꞌatz veyoleꞌ tiꞌ uvaꞌ la nimali. As etoksak kuxh u almikaꞌeꞌ kꞌatz veyoleꞌ, tan ixonlebꞌal u Tiixheꞌ u almikaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","As mitaꞌn u txꞌavaꞌeꞌ la etoksa kꞌatz veyoleꞌ, tan tiꞌ uvaꞌ ech u txꞌavaꞌeꞌ echeꞌ tiꞌlebꞌal toj u Tiixheꞌ. As mitaꞌn kuxh u Jerusalén la etoksa tiꞌ veyoleꞌ, tan tiꞌ uvaꞌ itenam u Nimla Ijlenaaleꞌ u Jerusalén. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","As mitaꞌn kuxh la etoksa u xiꞌl eviꞌeꞌ kꞌatz veyoleꞌ, tan echeꞌ la koj olebꞌ ex tiꞌ isajbꞌisal umaꞌl u xiꞌl eviꞌeꞌ. As mitaꞌn la olebꞌ ex tiꞌ iqꞌejbꞌisaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Pet ech eyolon ileꞌ tul la yolon ex: «An chiteꞌ,» chaj ex, asoj an chittuꞌ. As: «Yeꞌle,» chaj ex asoj jitꞌeꞌcheꞌ. Tan asoj jit ech eyoloneꞌ tul la yolon ex, as xeꞌ u txꞌiꞌlanajeꞌ tzaanajkat vetxumbꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","As ootzimal umaꞌt u yoleꞌ setaꞌn uvaꞌ alel kan uvaꞌ ech ni tal ileꞌ: Abꞌil uvaꞌ la poqꞌon el tzan bꞌaqꞌ ivatz imool, as la poqꞌlik el u bꞌaqꞌ ivatzeꞌ unpajte. As abꞌil uvaꞌ la itoopisa el tee imool, as la toopisal el u tee unpajte, tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pet ech koj uveꞌ tuk val sete, tan eqꞌaavisak ichꞌexel u vaꞌlexheꞌ uveꞌ la bꞌanchu sete. Pet asoj la itzꞌich umaj uxhchil u sebꞌal evatzeꞌ, as etaqꞌtaj ok unjalit vevatzeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Asoj abꞌil la ichuk ixeꞌt setiꞌ tiꞌ imaat vekamiꞌxheꞌ, as etaqꞌtaj vekamiꞌxheꞌ tukꞌ vexheerkaeꞌ ste. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Asoj la alax sete tiꞌ uvaꞌ la etija bꞌen umaj ijatz tu umaꞌl iꞌl, as kaꞌvaꞌl iꞌl la etijakat bꞌen. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Asoj abꞌil la jajon umaj kam sete, as etaqꞌtaj ste. Asoj abꞌil la ul jajon umaj kam sete skꞌam, as yeꞌl ex la epiꞌu etibꞌ tiꞌ etaqꞌat ste. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","As ootzimal umaꞌt u yoleꞌ setaꞌn uvaꞌ alax kan uvaꞌ ech ni tal ileꞌ: «Xoꞌnoj unqꞌa emooleꞌ sete. As chiꞌanoj etaama tiꞌ unqꞌa uxhchileꞌ uveꞌ nichiꞌan taama setiꞌ,» tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pet ech koj uveꞌ tuk val sete, tan xoꞌnoj unqꞌa uxhchileꞌ sete uveꞌ nichꞌoꞌn taama setiꞌ. As bꞌaꞌnoj eyolon tiꞌ unqꞌa uxhchileꞌ uvaꞌ vaꞌlexh iyolon setiꞌ. As ebꞌantaj bꞌaꞌnil te unqꞌa uxhchileꞌ uvaꞌ ni bꞌanon u vaꞌlexheꞌ sete. As enachtaj Tiixh tiꞌ unqꞌa uxhchileꞌ uveꞌ nixeꞌt setiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Asoj ech la ebꞌaneꞌ, as ech ekꞌuchateꞌ uvaꞌ ex meꞌal ikꞌaol u Kubꞌaaleꞌ uvaꞌ echen tu almikaꞌ, tan Aakeꞌ ni aqꞌon el tzan u qꞌiieꞌ tiꞌ unqꞌa bꞌaꞌnla aamaeꞌ tukꞌ unqꞌa txꞌiꞌla aamaeꞌ. As ni taqꞌ Aak u jabꞌaleꞌ tiꞌ unqꞌa jikla aamaeꞌ tukꞌ tiꞌ unqꞌa paasan tziieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tan asoj aꞌ kuxh unqꞌa uxhchileꞌ xoꞌn sete uvaꞌ xoꞌn ex ste, as ¿kam umaj etxꞌajaꞌm qꞌii la ekꞌul stiꞌ? ¿As ma yeꞌ etootza uvaꞌ ech nibꞌan unqꞌa uxhchileꞌ uvaꞌ ni molon u puajeꞌ tetz u Roma? ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Asoj aꞌ kuxh unqꞌa etitzꞌin etatzikeꞌ netiixhi, as eelatel kuxh ex tukꞌ unqꞌa uxhchileꞌ uvaꞌ yeꞌ ni niman u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pet jik chit ex la ebꞌaneꞌ echeꞌ u Kubꞌaaleꞌ uvaꞌ echen tu almikaꞌ, tan jik chit Aakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","As tuk val sete uvaꞌ yeꞌ la epaxsa viꞌ unqꞌa tenameꞌ tul la ebꞌan umaj bꞌaꞌnil. As tiꞌ inik kuxhtuꞌ uvaꞌ la til ex unqꞌa tenameꞌ kam uvaꞌ kat ebꞌana, tan asoj la epaxsa viꞌ unqꞌa tenameꞌ, as yeꞌl etxꞌajaꞌm la taqꞌ u Kubꞌaaleꞌ uvaꞌ echen tu almikaꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","As tul la ebꞌan umaj bꞌaꞌnil te umaj uxhchil, as yeꞌ la epaxsa viꞌ unqꞌa tenameꞌ, echeꞌ uveꞌ nibꞌan unqꞌa kaꞌvatzeꞌ tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh as tulaj unqꞌa bꞌeyeꞌ aqꞌal uvaꞌ la oksal iqꞌii chajnaj taꞌn unqꞌa tenameꞌ. Pet tuk val sete uvaꞌ taꞌn itxꞌajaꞌm chajnajeꞌ uvaꞌ la oksal iqꞌii chajnaj taꞌn unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pet ech koj ex, tan tul la ebꞌan umaj u bꞌaꞌnil te umaj uxhchil, as katiniꞌk etalkat. As mitaꞌn la etal te umaj uxhchil uvaꞌ kꞌulel tibꞌ eyol stukꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","aqꞌal uvaꞌ yeꞌxhebꞌil la ootzin uvaꞌ kat ebꞌan umaꞌl u bꞌaꞌnil te umaj uxhchil. Pet aꞌ kuxh u Kubꞌaaleꞌ uvaꞌ at tu almikaꞌ ootzin tetz u bꞌaꞌnileꞌ uveꞌ kat ebꞌana, tan naꞌleꞌ vatz Aak kam uveꞌ nebꞌaneꞌ. As la til unqꞌa uxhchileꞌ u bꞌaꞌnileꞌ uveꞌ la ibꞌan Aak sete. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","As tul la enach Tiixh, as ebꞌanak etetz echeꞌ uveꞌ nibꞌan unqꞌa najeꞌ uveꞌ kaꞌvatz, tan tul ninach chajnaj Tiixh, as achaꞌv chit te chajnaj tul nitxakebꞌ chajnaj tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh as tulaj unqꞌa juꞌ peꞌeꞌ as tu kꞌayibꞌaleꞌ, tiꞌ uvaꞌ la til unqꞌa tenameꞌ. Pet tuk val sete uvaꞌ taꞌn itxꞌajaꞌm chajnajeꞌ uvaꞌ la oksal iqꞌii chajnaj taꞌn unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pet ech koj ex, tan tul la enach Tiixh, as la ok ex tu vekabꞌaleꞌ. As la ejup u tziꞌ kabꞌaleꞌ aqꞌal uvaꞌ ex kuxh sejunal tukꞌ u Kubꞌaaleꞌ uvaꞌ yeꞌxhebꞌil ni ilon, tan naꞌleꞌ vetaanxelaleꞌ vatz Aak. As la til unqꞌa uxhchileꞌ u bꞌaꞌnileꞌ uveꞌ la ibꞌan Aak sete. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","As tul la enach Tiixh, as pilqꞌiꞌk kuxh ex tiꞌ veyoleꞌ echeꞌ nibꞌan unqꞌa uxhchileꞌ uveꞌ yeꞌ ootzin tetz u Tiixheꞌ, tan aꞌ ni tal jeꞌ ste uvaꞌ asoj la kuxh pilqꞌu tiꞌ viyoleꞌ, as aꞌeꞌ nititzꞌa uvaꞌ la taqꞌ Aak ste kam uvaꞌ nijajeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Pet ebꞌanak etetz echeꞌ uveꞌ nibꞌan unqꞌa uxhchileꞌ, tan ootzimaleꞌ taꞌn u Kubꞌaaleꞌ kam uveꞌ nisaꞌvit setiꞌ. As at veꞌt skꞌuꞌl Aak tul yeꞌxnaj ejaj te Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","As ech la etal ileꞌ tul la enach Tiixh: Kubꞌaal Tiixh, echen axh tu almikaꞌ. Tiixhla bꞌii chiteꞌ tatin vabꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","As ulen veꞌteꞌ tukꞌ u eejleꞌmeꞌ tiꞌ vatenameꞌ skajayil. As aꞌ ni qaleꞌ uvaꞌ la abꞌan vatz u txꞌavaꞌeꞌ kam uvaꞌ ni tal aama echeꞌ uvaꞌ nabꞌan tu almikaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Bꞌan bꞌaꞌnil. Aqꞌ vas qechbꞌubꞌaleꞌ uvaꞌ la qechbꞌu jun qꞌii. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","As sotzsa kupaaveꞌ, Pap, tiꞌ u vaꞌlexheꞌ uveꞌ nu kubꞌan savatz, echeꞌ kusotzsat ipaav u kumooleꞌ uveꞌ ni paavin sukuvatz. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Bꞌan bꞌaꞌnil. Achajpuk kan oꞌ tiꞌ kubꞌen tu u vaꞌlexheꞌ. Pet la akol oꞌ vatz u txꞌiꞌlanajeꞌ, tan taꞌn axheꞌ at eejleꞌm tiꞌ unqꞌa tenameꞌ skajayil. As taꞌn axheꞌ la qoksa aqꞌii sbꞌenameen tiꞌ chit ibꞌeneꞌ. An chiteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Tan asoj la esotzsa ipaav unqꞌa emooleꞌ uvaꞌ nipaavin sevatz, as echat la ibꞌan u Kubꞌaaleꞌ uvaꞌ echen tu almikaꞌ, tan la isotzsa Aakeꞌ vepaaveꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pet asoj yeꞌ la esotzsa ipaav unqꞌa emooleꞌ veꞌt ni paavin sevatz, as yeꞌl vepaaveꞌ la isotzsa u Kubꞌaaleꞌ uvaꞌ echen tu almikaꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","As ebꞌanak etetz echeꞌ uveꞌ nibꞌan unqꞌa kaꞌvatzeꞌ, tan tul uvaꞌ nikuy chajnaj ivaꞌy, as txumlebꞌal chit ivatz chajnaj nibꞌaneꞌ vatz unqꞌa tenameꞌ, tan aꞌ nisaꞌ chajnaj uvaꞌ la til unqꞌa tenameꞌ uvaꞌ nikuy chajnaj ivaꞌy. Pet tuk val sete uvaꞌ taꞌn itxꞌajaꞌm chajnajeꞌ uveꞌ kat oksal iqꞌii taꞌn unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pet ech koj ex, tan tul uvaꞌ la ekuy evaꞌy vatz u Tiixheꞌ, as la exee eviꞌ. As la etxꞌaa evatz, ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","aqꞌal uvaꞌ yeꞌ la pal unqꞌa tenameꞌ stuul kam uvaꞌ nebꞌaneꞌ. Pet vatz u Kubꞌaal Tiixheꞌ la ebꞌankat, tan naꞌleꞌ vetaanxelaleꞌ vatz Aak. As la til unqꞌa tenameꞌ u bꞌaꞌnileꞌ uveꞌ la ibꞌan Aak sete. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","As tuk val sete, yeꞌ kuxh etoksa etaama tiꞌ u txꞌiibꞌal qꞌiieꞌ tzitzaꞌ vatz u txꞌavaꞌeꞌ, tan jankꞌal uvaꞌ la emoleꞌ, as la pokꞌteꞌ. As moj la yani. As la kuxh esuti veꞌt el. As moj u elqꞌomeꞌ la elqꞌan. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Pet aꞌ la etoksakat etaama tiꞌ emolat unqꞌa nimla txꞌiibꞌal qꞌiieꞌ tu almikaꞌ, tan aꞌeꞌ yeꞌ la pokꞌti. As yeꞌ la yani. As mitaꞌn u elqꞌomeꞌ la elqꞌan. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","As katil uvaꞌ nemolkat unqꞌa etetzeꞌ, as tzitziꞌeꞌ netoksakat etaama. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","As tuk val sete, tan u bꞌaqꞌ evatzeꞌ ni kꞌuchun uvaꞌ kam vetxumbꞌaleꞌ, tan asoj bꞌaꞌn u bꞌaqꞌ evatzeꞌ, as bꞌaꞌneꞌ vetxumbꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pet asoj vaꞌlexh u bꞌaqꞌ evatzeꞌ, as echen exeꞌ tu u qꞌej toktoeꞌ tukꞌ vetxumbꞌaleꞌ. Tan asoj echen ex tu u qꞌej toktoeꞌ tukꞌ vetxumbꞌaleꞌ, as txumlebꞌal kuxh etatineꞌ tu u qꞌej toktoeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","As yeꞌ la uch taqꞌonvu umaj uxhchil xeꞌ kaꞌvaꞌl bꞌaal aqꞌon, tan la tixva kan u uxhchileꞌ umaꞌl u bꞌaal aqꞌoneꞌ. As la ixoꞌni umaꞌte. As moj la inima umaꞌl u bꞌaal aqꞌoneꞌ. As yeꞌ la inima umaꞌte. Estiꞌeꞌ la val sete, etoksataj etaama tiꞌ u Tiixheꞌ, tan asoj netoksa etaama tiꞌ u txꞌiibꞌal eqꞌiieꞌ vatz u txꞌavaꞌeꞌ, as yeꞌ la uchi uvaꞌ la etoksa etaama tiꞌ enimat u Kubꞌaal Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Estiꞌeꞌ ni val sete uvaꞌ yeꞌ kuxh exaansa etaama tiꞌ uvaꞌ kam la etechbꞌu sqꞌejal, moj kam la etukꞌa, as mitaꞌn tiꞌ unqꞌa etoksaꞌmeꞌ uvaꞌ kam la etoksaꞌmi, tan nim talcheꞌ vetiichajileꞌ tiꞌ vetechbꞌubꞌaleꞌ. As nim talcheꞌ vechiꞌoleꞌ tiꞌ vetoksaꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Etiltaj unqꞌa tzꞌikineꞌ uveꞌ nixichꞌan tu almikaꞌ, tan yeꞌl txoo ni taveꞌ. As yeꞌl txoo nipitxꞌoneꞌ. Yeꞌl ikꞌuay txoo ati. As aꞌ u Kubꞌaal Tiixheꞌ uvaꞌ echen tu almikaꞌ ni aqꞌon techbꞌubꞌal txoo. ¿As aꞌ kol chit veꞌt yeꞌl ex qꞌa? Tan nim etalcheꞌ tiꞌ unqꞌa tzꞌikineꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","As tuk val sete uvaꞌ yeꞌl umaj ex la koj olebꞌ ex tiꞌ echꞌiisat etxakebꞌeꞌ tukꞌ kaꞌvaꞌtoj kꞌuchbꞌal, as kꞌuxh nexaansa etaama stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","As yeꞌ kuxh exaansa etaama tiꞌ uvaꞌ kam la etoksaꞌmi. Pet etitzꞌataj unqꞌa xuꞌmeꞌ, tan achaꞌv chit ichꞌiieꞌ, as kꞌuxh yeꞌxhkam ni taqꞌonveꞌ as yeꞌxhkam nichemoneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pet tuk val sete, tan mitaꞌn kuxh u ijlenaal Salomón kat lejon ivejat tibꞌ tukꞌ u toksaꞌmeꞌ tiꞌ unqꞌa xuꞌmeꞌ, as kꞌuxh xoꞌvebꞌalik kuxh naj tiꞌ ivejat tibꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","As chꞌiꞌumal chit unqꞌa xuꞌmeꞌ uveꞌ cheesamal taꞌn u Tiixheꞌ, as kꞌuxh yeꞌ kuxh jatvaꞌl qꞌii stuul as kat tzaj veꞌteꞌ as eela itzꞌeꞌ veꞌteꞌ tukꞌ unqꞌa chꞌiseꞌ. As aꞌ kol chit yeꞌ la ibꞌan Aak qꞌa sete tiꞌ elochpeꞌ tan nim etalcheꞌ tiꞌ unqꞌa xuꞌmeꞌ, ex uvaꞌ bꞌiil kuxh u kꞌujlebꞌal ekꞌuꞌleꞌ at tiꞌ u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","As yeꞌ kuxh exaansa etaama. As yeꞌ la etal ech ileꞌ: «¿Kam tuk qechbꞌu? As ¿kam tuk qukꞌa? As ¿kam tuk qoksaꞌmi?» chajiniꞌk ex etala, ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","tan aꞌ kuxheꞌ ni titzꞌa unqꞌa tenameꞌ uveꞌ yeꞌ ni niman u Kubꞌaal Tiixheꞌ. Pet ech koj ex, tan ootzimaleꞌ taꞌn u Kubꞌaal Tiixheꞌ uvaꞌ echen tu almikaꞌ kam uvaꞌ nisaꞌvit setiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pet aal bꞌaꞌneꞌ uvaꞌ la ok ex xoꞌl unqꞌa tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. As etoksataj etaama tiꞌ ebꞌanat u jikla txumbꞌaleꞌ vatz Aak. As Aakeꞌ la aqꞌon veꞌt unqꞌa veeꞌ skajayil sete, kam uvaꞌ nisaꞌvit setiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Estiꞌeꞌ ni val sete, yeꞌ kuxh exaansa etaama tiꞌ u qꞌiieꞌ uveꞌ qꞌejal, tan kam kuxheꞌ eqꞌomal taꞌn junun unqꞌa qꞌiieꞌ. As kat kuxh ibꞌanleꞌ kam uvaꞌ eqꞌomal taꞌn junun unqꞌa qꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yeꞌ kuxh ebꞌan isuuchil vemooleꞌ, aqꞌal uvaꞌ yeꞌ la bꞌanax esuuchil taꞌn vemooleꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","tan kam chit ebꞌanat isuuchil vemooleꞌ, as echat chit la bꞌanax sete. As kam chit u txumbꞌaleꞌ uvaꞌ la ebꞌan tiꞌ vemooleꞌ, as echat chit la bꞌanchu sete. ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿As kam qꞌii uveꞌ vaꞌl kuxh esajit ok u tal chꞌiseꞌ tu vivatz vetitzꞌin etatzikeꞌ, as tul yeꞌ netil jeꞌ etibꞌ tul at umaꞌl u potzoꞌm tu vevatzeꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Tan asoj at umaꞌl u potzoꞌm tu vevatzeꞌ, as ¿la kol uch etalat qꞌa te vetitzꞌin etatzikeꞌ uvaꞌ: «¡Qeꞌna! Tuk veesa el tzan u tal chꞌiseꞌ tu vavatzeꞌ,» ma chaj ex la etaleꞌ? ¡Tul il u potzoꞌm ileꞌ at tu vevatzeꞌ! ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Ex kuxh kaꞌvatz! Eteesataj u potzoꞌmeꞌ tu vevatzeꞌ bꞌaxa. As aꞌn la uch etilat veꞌt u chꞌiseꞌ tivatz vetitzꞌin etatzikeꞌ. As la eteesa veꞌt el. ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Pet tuk val sete, tan yeꞌ la uch etalat u bꞌaꞌnla yoleꞌ te unqꞌa uxhchileꞌ uvaꞌ yeꞌ la saꞌon tabꞌit viyol u Tiixheꞌ, tan aꞌeꞌ yeꞌ la niman. As la ibꞌaneꞌ uvaꞌ la ul iviꞌ setiꞌ echeꞌ nibꞌan unqꞌa txꞌiꞌeꞌ tul uvaꞌ nichiꞌ ex txꞌiꞌ. As moj ech itxumbꞌal unqꞌa uxhchileꞌ echeꞌ unqꞌa chichameꞌ, as latzꞌ koj tiꞌ txoo, tan la kuxh ipachꞌ txooeꞌ tu toj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","As ejajtaj. As la aqꞌpeꞌ sete. Echuktaj. As la elejeꞌ. As etꞌoktaj u tziꞌ kabꞌaleꞌ. As la jajpeꞌ u tziꞌ kabꞌaleꞌ sevatz. ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tan abꞌil uvaꞌ la jajon, as la ikꞌuleꞌ. As abꞌil uvaꞌ la chukun, as la ilejeꞌ. As abꞌil uvaꞌ la tꞌokon u tziꞌ kabꞌaleꞌ, as la jajpeꞌ u tziꞌ kabꞌaleꞌ svatz. ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿As at kol umaj ex qꞌa uvaꞌ la txꞌakon taqꞌax umaj kꞌubꞌ te vetalaj intxaꞌeꞌ tul la ijaj ipaan sete? ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿As moj ichibꞌil txꞌiꞌlatxoo la etaqꞌ te vetalaj intxaꞌeꞌ tul la ijaj unbꞌooj chibꞌil txay sete? ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tan kꞌuxh txꞌiꞌla aama chit ex, as ootzimal setaꞌn uvaꞌ aꞌ u bꞌaꞌneꞌ netaqꞌ te unqꞌa etalaj intxaꞌeꞌ. ¿As aꞌ kol chit yeꞌl u Kubꞌaal Tiixheꞌ qꞌa uvaꞌ at tu almikaꞌ? Tan nimeꞌ vibꞌaꞌnil Aakeꞌ setiꞌ. Tan la taqꞌ Aakeꞌ u bꞌaꞌnileꞌ sete, abꞌiste ex uvaꞌ la jajon te Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","As kam kuxh uvaꞌ la ebꞌaneꞌ, as echat la ebꞌan te unqꞌa uxhchileꞌ echeꞌ uvaꞌ nesaꞌ uvaꞌ la bꞌanchu sete. Tan ech isuuchil u tzaqꞌiteꞌ uvaꞌ tzꞌibꞌamal kan, as tukꞌ kaꞌt unqꞌa yoleꞌ uvaꞌ itzꞌibꞌa kan unqꞌa qꞌajsan tetz viyol u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","As okoj ex tu u tziꞌ kabꞌaleꞌ uvaꞌ chꞌoo kuxh ivatz, tan at umaꞌt u tziꞌ kabꞌaleꞌ uvaꞌ nim chit ivatz. As at umaꞌt u bꞌey uvaꞌ nim chit ivatz uvaꞌ ech toon tu u choobꞌal paaveꞌ. As nimal unqꞌa tenameꞌ ni tok tu u nimla tziꞌ kabꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pet kaꞌl kuxh unqꞌa uxhchileꞌ la itxꞌol tok tu u tziꞌ kabꞌaleꞌ uvaꞌ chꞌoo kuxh ivatz as tukꞌ tu u bꞌeyeꞌ uvaꞌ chꞌoo kuxh ivatz uvaꞌ la eqꞌon unqꞌa uxhchileꞌ tu vitiichajileꞌ uveꞌ yeꞌl iyaꞌtebꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Estiꞌeꞌ ni val sete, atoj chit enachbꞌal vatz unqꞌa chulin yoleꞌ uvaꞌ nu kuxh ibꞌensa tibꞌ qꞌajsan tetz viyol u Tiixheꞌ. As ech tilon vitxumbꞌaleꞌ echeꞌ umaꞌl u bꞌaꞌnla kaneeroꞌ. Pet ech koj u taanxelaleꞌ, tan echeꞌ umaꞌl u xoꞌ tiꞌ ichiꞌat ex. ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Pet aꞌ vitxumbꞌal unqꞌa uxhchileꞌ la kꞌuchun sete ma bꞌaꞌn moj yeꞌle, echeꞌ nibꞌan unqꞌa tzeꞌeꞌ, tan yeꞌ la uch quxat uuva tiꞌ u chꞌiꞌxeꞌ. As yeꞌ la uch quxat higuera tiꞌ u vokkin chꞌiꞌx. ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","As jankꞌal unqꞌa tzeꞌeꞌ uveꞌ bꞌaꞌn, as bꞌaꞌn vivatz tzeꞌeꞌ. Pet ech koj u tzeꞌeꞌ uveꞌ yeꞌ bꞌaꞌn, tan vaꞌlexh vivatz tzeꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","As u tzeꞌeꞌ uveꞌ bꞌaꞌn, as yeꞌ la uch taqꞌat tzeꞌ ivatz uvaꞌ yeꞌ bꞌaꞌn; as u tzeꞌeꞌ uveꞌ yeꞌ bꞌaꞌn, as yeꞌ la uch taqꞌat tzeꞌ ivatz uvaꞌ bꞌaꞌn. ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pet jankꞌal unqꞌa tzeꞌeꞌ uveꞌ vaꞌlexh ivatz ni taqꞌeꞌ, as la tzokꞌax el. As la oksal tu u xamaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Estiꞌeꞌ ni val sete uvaꞌ aꞌ vitxumbꞌal unqꞌa uxhchileꞌ la kꞌuchun ma bꞌaꞌn moj yeꞌle, echeꞌ uvaꞌ nibꞌan unqꞌa tzeꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","As jit kajayil unqꞌa uxhchileꞌ uvaꞌ ni alon sve: «¡Kubꞌaal Jesús! ¡Kubꞌaal Jesús!» taqꞌeꞌ ni tal sve, as yeꞌl tokebꞌal xoꞌl unqꞌa tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. Pet taꞌn kuxh unqꞌa uxhchileꞌ uveꞌ ni niman kam uveꞌ nisaꞌ Aak uvaꞌ la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","As la ibꞌan umaꞌl u qꞌii uvaꞌ nimal uxhchil la alon sve, «¡Kubꞌaal Jesús! ¡Kubꞌaal Jesús!» chaj la tal sve. As ati la alon uvaꞌ: «Tukꞌ vabꞌiieꞌ, Pap, kat qal vayoleꞌ; as tukꞌ vabꞌiieꞌ kat qeesa el unqꞌa subꞌuleꞌ; as tukꞌ vabꞌiieꞌ kat kukꞌuch vanimla bꞌaꞌnileꞌ vatz unqꞌa tenameꞌ,» chaj veꞌteꞌ la tal sve. ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","As ech la val veꞌt ileꞌ: «Yeꞌ vootzaj ex. Jetzꞌenoj el ex sunvatz, tan ex bꞌanol tetz unqꞌa vaꞌlexheꞌ,» chaj in la val veꞌt ste. ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","As abꞌil uveꞌ la abꞌin vunyoleꞌ as la inima, as la ibꞌan eela tukꞌ umaj naj uvaꞌ at itxumbꞌal, as la ilak vikabꞌaleꞌ viꞌ u sivaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","As tul la ul umaꞌl u mam jabꞌal tukꞌ umaꞌl u mam kajiqꞌ tiꞌ u kabꞌaleꞌ, as la sipkꞌu veꞌt unqꞌa aꞌeꞌ. As yeꞌl u kabꞌaleꞌ la kuꞌi, tan chabꞌamal chit ikꞌujebꞌ u kabꞌaleꞌ viꞌ u sivaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pet abꞌil uveꞌ la abꞌin vunyoleꞌ as yeꞌ la inima, as la ibꞌan eela tukꞌ umaꞌt u naj uvaꞌ yeꞌl itxumbꞌal ati uvaꞌ la ilak ikabꞌal viꞌ u sanabꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","As tul la ul veꞌt u mam jabꞌaleꞌ tukꞌ u mam kajiqꞌeꞌ tiꞌ u kabꞌaleꞌ, as la sipkꞌu veꞌt unqꞌa aꞌeꞌ. As la pal tija veꞌt u aꞌeꞌ u kabꞌaleꞌ. As txumlebꞌal chit veꞌt teꞌp u kabꞌaleꞌ la ibꞌaneꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","As tul yaꞌ veꞌt u Jesús tiꞌ iyoloneꞌ, as teqꞌo veꞌt taama unqꞌa tenameꞌ tiꞌ u chusbꞌaleꞌ uvaꞌ nik tal Aak, ");
INSERT INTO ixlNNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","tan ech iyolon Aakeꞌ echeꞌ umaj naj uvaꞌ at tijleꞌm. Pet ech koj unqꞌa najeꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, tan jitꞌeꞌch ichusun chajnajeꞌ echeꞌ uveꞌ nik ibꞌan Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","As tul kuꞌ chꞌuꞌl u Jesús vatz u vitzeꞌ, as aꞌ chit mamaꞌla tenameꞌ xekelik veꞌt tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","As ul veꞌt umaꞌl u naj kꞌatz u Jesús uvaꞌ atik ok chꞌaꞌk chin stiꞌ. As kuꞌ naj qaaloj vatz Aak. As ech tal naj ileꞌ: —Pap, asoj la asaꞌ, as bꞌan bꞌaꞌnil sve. As eesa u chꞌoꞌmeꞌ sviꞌ, tan la olebꞌ axheꞌ,— tiꞌk naj tal te u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","As taqꞌ veꞌt bꞌen u Jesús iqꞌabꞌ tiꞌ naj. As ech tal veꞌt Aak ileꞌ: —Nunsaꞌ. Kat bꞌaꞌnxiy veꞌt axheꞌ,— tiꞌk Aak. As yak kuxh el veꞌt u chꞌaꞌk chineꞌ tiꞌ naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","As ech tal veꞌt u Jesús ileꞌ: —Tuk val see uvaꞌ katiniꞌk chit aalkat uvaꞌ kat bꞌaꞌnxiy axh. Pet kuxh kꞌuch eebꞌ vatz unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh. As kuxh aqꞌ u oyeꞌ uvaꞌ alel kan taꞌn u Moisés, texhlal tetz uvaꞌ kat txanyu veꞌt axh,— tiꞌk Aak tala. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","As tul ok u Jesús tu u Capernaúm, as ul umaꞌl viqꞌesal unqꞌa soleꞌ vatz u Jesús. As ijaj naj bꞌaꞌnil te Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","As ech tal naj ileꞌ: —Pap, bꞌan bꞌaꞌnil. Bꞌaꞌnxisa umaꞌl vas unkꞌam uveꞌ nichꞌoꞌneꞌ, tan ileꞌ koxhleꞌl tunkabꞌal. As yeꞌ nitxꞌol veꞌt itiinsat tibꞌ, tan nimxinal chittuꞌ,— tiꞌk u najeꞌ tal te u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ech tal veꞌt u Jesús ileꞌ: —Bꞌaꞌn kuxheꞌ. Bꞌen unbꞌaꞌnxisa,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","As ech tal veꞌt viqꞌesal unqꞌa sol ileꞌ: —Yeꞌle, Pap, tan nim aalcheꞌ. As yeꞌl vijleꞌm ati uvaꞌ la oon axh tunkabꞌal. Pet al bꞌen kuxhtuꞌ uvaꞌ la bꞌaꞌnx veꞌt vunkꞌameꞌ. As tuk bꞌaꞌnxojeꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","tan echeꞌ in, tan at unqꞌesal echeꞌ axh. As at sol jaqꞌ u vijleꞌmeꞌ unpajte. As kam uveꞌ la val te umaj vunsoleꞌ, as la ibꞌaneꞌ. Asoj la val te umaj naj: «Kuxh bꞌen,» chaj in ste, as maꞌte. Asoj: «Siꞌu,» chaj in te umaꞌt naj, as la ul naj sunvatz. Asoj la val te umaj vunkꞌameꞌ: «Bꞌan u viꞌleꞌ,» chaj in ste, as la ibꞌaneꞌ,— tiꞌk naj tal te u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","As tul tabꞌi veꞌt u Jesús u yoleꞌ uvaꞌ tal viqꞌesal unqꞌa soleꞌ, as txuqꞌtxun veꞌt Aak. As ech tal veꞌt Aak ileꞌ xoꞌl unqꞌa tenameꞌ: —Ileꞌ jik chit tuk val sete, tan yeꞌl umaj naj vileꞌte xoꞌl unqꞌa tiaal Israel uvaꞌ ech u kꞌujlebꞌal ikꞌuꞌleꞌ echeꞌ nibꞌan u najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","As tuk val sete uvaꞌ yeꞌ saach unqꞌa uxhchileꞌ la ul tibꞌuuqꞌebꞌal qꞌii as la ul tibꞌenebꞌal qꞌii. As la xonebꞌ tu almikaꞌ kꞌatz u Abraham, tukꞌ u Isaac, tukꞌ u Jacob tiꞌ itxꞌaꞌneꞌ, as tukꞌ unqꞌa tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pet nimal unqꞌa tiaal Israel uvaꞌ yeꞌ nisaꞌ tok jaqꞌ u tijleꞌm u Tiixheꞌ, as ech ibꞌen tu u qꞌej toktoeꞌ. As tzitziꞌ la oqꞌkat veꞌteꞌ. As la ikꞌux veꞌt tibꞌ tee taꞌn u kꞌaxkꞌoeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","As ech tal veꞌt u Jesús ileꞌ te viqꞌesal unqꞌa soleꞌ: —Kuxh veꞌteꞌ, tan kam uvaꞌ kat anima as kat ibꞌanlaꞌ,— tiꞌk u Jesús. As tul kuxh tal Aak u yoleꞌ, as yak kuxh el u chꞌoꞌmeꞌ tiꞌ vikꞌam najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","As oon veꞌt u Jesús tikabꞌal u Luꞌeꞌ. As koxhlik vijiꞌ u Luꞌeꞌ viꞌ chꞌach taꞌn xamal chꞌoꞌm. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","As itxey veꞌt u Jesús iqꞌabꞌ vijiꞌ u Luꞌeꞌ. As yak kuxh el veꞌt u xamal chꞌoꞌmeꞌ stiꞌ. As txakpu veꞌteꞌ. As taqꞌ veꞌt vijiꞌ u Luꞌeꞌ techbꞌubꞌal unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","As tul tzꞌotin veꞌteꞌ, as yeꞌ saach unqꞌa aachꞌoꞌmeꞌ eqꞌol tzan vatz u Jesús. Atik unqꞌa aachꞌoꞌmeꞌ uvaꞌ atik ok subꞌul skꞌatz. As tukꞌ viyol Aakeꞌ as kat el unqꞌa subꞌuleꞌ. As ibꞌaꞌnxisa Aak unqꞌa aachꞌoꞌmeꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","As bꞌex ibꞌan veꞌt umaꞌt u yol uvaꞌ kat tal kan u Isaías, u qꞌajsan tetz viyol u Tiixheꞌ, uvaꞌ ech tal ileꞌ: Aakeꞌ la taqꞌ tibꞌ sqiꞌ tiꞌ teesat u kuchꞌoꞌmeꞌ tukꞌ unqꞌa veeꞌ nichꞌoꞌnsan oꞌ, tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","As tul til u Jesús uvaꞌ aꞌ chit mamaꞌla tenameꞌ nikat imol tibꞌ kꞌatz Aak, as tal veꞌt Aak iqꞌax jalit u mar. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","As jetzꞌen veꞌt ok umaꞌl u naj kꞌatz Aak, uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ. As ech tal veꞌt naj ileꞌ: —Pap, aꞌ ni valeꞌ uvaꞌ la xekebꞌ in seeꞌ, katil kuxh uvaꞌ la bꞌenkat axh,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ech tal u Jesús ileꞌ: —Unqꞌa chisi as at ijul txoo. As unqꞌa tzꞌikineꞌ uvaꞌ nixichꞌan vatz u almikaꞌeꞌ tan at isok txoo. Pet ech koj VIKꞌAOL U NAJEꞌ tan yeꞌl ivitzꞌ ati uvaꞌ la qꞌaꞌebꞌ ok stiꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","As ech tal umaꞌt vichusulibꞌ Aak ileꞌ: —Pap, la xekebꞌ in seeꞌ ni valeꞌ, poro lanal bꞌen unmuj kan ak unbꞌaaleꞌ bꞌaxa. As aꞌn la xekebꞌ ineꞌ seeꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ech tal veꞌt u Jesús ileꞌ: —Xekebꞌen sviꞌ cheel. Imujeꞌn tibꞌ unqꞌa uxhchileꞌ svatzaj uvaꞌ kamnal u taanxelaleꞌ vatz u Tiixheꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","As tul ok veꞌt u Jesús tu umaꞌt u barco, as xekebꞌ veꞌt unqꞌa ichusulibꞌ Aakeꞌ stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","As vat veꞌt u Jesús. As xeꞌt veꞌt umaꞌl u mam kajiqꞌ jabꞌal viꞌ u mar. As vaꞌlik chit ipilqꞌut tibꞌ u aꞌeꞌ taꞌn u mam kajiqꞌ jabꞌaleꞌ. As nik tok veꞌt u aꞌeꞌ tu u barco. As bꞌiit kuxh yeꞌ nik ibꞌen veꞌt u barco xeꞌ u mar. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","As bꞌex ibꞌey veꞌt chajnaj u Jesús. Ech tal veꞌt chajnaj ileꞌ te Aak: —¡Loch oꞌ, Pap, tan tuk bꞌenoj veꞌt oꞌ xeꞌ u aꞌeꞌ!— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","As ech tal veꞌt u Jesús ileꞌ: —¿Kam qꞌi nexoꞌva, ex uvaꞌ bꞌiil kuxh u kꞌujlebꞌal ekꞌuꞌleꞌ ati?— tiꞌk Aak. As txakpu veꞌt u Jesús. As iyaa veꞌt Aak u kajiqꞌeꞌ tukꞌ u mar. As yak kuxh yaꞌ veꞌt u aꞌeꞌ tiꞌ ipilqꞌut tibꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","As yak kuxh samun veꞌt unqꞌa ichusulibꞌ Aakeꞌ. As ech tal veꞌt chajnaj ileꞌ svatzaj: —¡Xoꞌvebꞌal u tijleꞌm Aakeꞌ, tan ninimal Aak taꞌn u kajiqꞌ jabꞌaleꞌ tukꞌ u mar!— tiꞌk chajnaj svatzaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","As oon veꞌt u Jesús jalit u mar tu vitxꞌavaꞌ unqꞌa aa Gadara. As ul ilej Aak kaꞌvaꞌl unqꞌa naj uvaꞌ atik ok subꞌul skꞌatz. As aꞌ elkat chꞌuꞌl chajnaj tu u viꞌ kamnajeꞌ. As abꞌil koj nikat itxꞌak ipal tu u bꞌeyeꞌ uveꞌ atikkat unqꞌa najeꞌ uveꞌ atik u subꞌuleꞌ skꞌatz, tan yeꞌxhebꞌil nik ichajpu pal chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","As sikꞌin veꞌt chajnaj. As ech tal veꞌt chajnaj ileꞌ: —¡Jesús, iKꞌaol Tiixh! ¿Kam nasaꞌ sqe? ¿As ma kat ulyu veꞌt axh tiꞌ ayansat oꞌ? As tul yeꞌl u qꞌiieꞌ ilejeꞌte,— tiꞌk unqꞌa najeꞌ tal te u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","As nik ikꞌuachin unjolol unqꞌa chicham najlich uveꞌ atikkat u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","As ech tal unqꞌa subꞌul ileꞌ tul ijaj bꞌaꞌnil te u Jesús: —Asoj la atilu el oꞌ, as bꞌan bꞌaꞌnil. Aqꞌ qokebꞌal tiꞌ unqꞌa chichameꞌ,— tiꞌk unqꞌa subꞌuleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ech tal veꞌt u Jesús ileꞌ: —¡Bꞌenoj ex bꞌa!— tiꞌk Aak. As el veꞌt chꞌuꞌl unqꞌa subꞌuleꞌ kꞌatz unqꞌa najeꞌ. As ok veꞌt unqꞌa subꞌuleꞌ tiꞌ unqꞌa chichameꞌ. As oojeꞌl ibꞌen veꞌt unqꞌa chichameꞌ. As chajpik veꞌt bꞌen txoo vatz vitz tiꞌ toon tu u mar. As kam veꞌt txoo skajayil xeꞌ u mar. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","As ooj veꞌt unqꞌa xeen chichameꞌ. As tul oon veꞌt chajnaj tu u tenameꞌ, as tal veꞌt chajnaj kam kat ibꞌan unqꞌa najeꞌ uveꞌ atik ok unqꞌa subꞌuleꞌ skꞌatz as tukꞌ uveꞌ kat ibꞌan unqꞌa chichameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","As el veꞌt chꞌuꞌl unqꞌa uxhchileꞌ skajayil uveꞌ atik tu u tenameꞌ tiꞌ ichukpu u Jesús. Tul lejpu veꞌt Aak, as ijaj veꞌt unqꞌa uxhchileꞌ bꞌaꞌnil te Aak tiꞌ uvaꞌ la el veꞌt Aak tzitziꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","As ok veꞌt u Jesús tu u barco unpajte. As qꞌaav veꞌt Aak tu u tenameꞌ uvaꞌ jejlikkat Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","As eqꞌol veꞌt tzan umaꞌl u aachꞌoꞌm viꞌ umaꞌl u chꞌachiꞌm tzeꞌ, tan tzeꞌunik tibꞌ vichiꞌoleꞌ. As oksal veꞌt u aachꞌoꞌmeꞌ vatz u Jesús. Tul til u Jesús uvaꞌ kꞌujlik chit ikꞌuꞌl chajnaj tiꞌ Aak, as ech tal veꞌt Aak ileꞌ te u aachꞌoꞌmeꞌ: —Yeꞌ txumun axh, vitzꞌin vatzik, tan kat sotzyeꞌ vapaaveꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","As tul tabꞌi unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as ech tal veꞌt jeꞌ chajnaj ileꞌ ste: —¡Ni teesa naj iqꞌii u Tiixheꞌ tukꞌ viyoleꞌ!— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Atik skꞌuꞌl u Jesús uvaꞌ kam nik tal jeꞌ chajnaj ste. As ech tal veꞌt Aak ileꞌ: —¿Kam qꞌi uveꞌ vaꞌlen kuxh netitzꞌa tiꞌ vunyoleꞌ uvaꞌ kat vala? ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿As abꞌiste umaꞌtoj qꞌi uvaꞌ yeꞌ la olebꞌ in tiꞌ ibꞌancheꞌ uvaꞌ netitzꞌa? ¿Ma tiꞌ uvaꞌ: «Kat sotzyeꞌ vapaaveꞌ,» chaj in te u aachꞌoꞌmeꞌ? ¿Pet moj: «Txakpen. As kuxh veꞌteꞌ,» chaj in la val te u aachꞌoꞌmeꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pet aqꞌal uvaꞌ la etootzi u tijleꞌm VIKꞌAOL U NAJEꞌ tiꞌ ul isotzsat ipaav unqꞌa aapaaveꞌ vatz u txꞌavaꞌeꞌ, as sevatz tuk valkat te u aachꞌoꞌmeꞌ,— tiꞌk Aak. As ech tal veꞌt Aak ileꞌ te u aachꞌoꞌmeꞌ: —Txakpen. As eqꞌo vasokeꞌ. As kuxh veꞌt takabꞌal,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","As yak kuxh txakpu veꞌt u aachꞌoꞌmeꞌ uvaꞌ tzeꞌunik tibꞌ vichiꞌoleꞌ. As bꞌen veꞌt naj tikabꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","As tul til veꞌt unqꞌa tenameꞌ uveꞌ ibꞌan u Jesús, as teqꞌo veꞌt taama unqꞌa tenameꞌ. As toksa veꞌt unqꞌa tenameꞌ iqꞌii u Tiixheꞌ, tan tiꞌ uvaꞌ maꞌtik taqꞌat Aak tijleꞌm u Jesús tiꞌ ilochat unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","As tul pal veꞌt u Jesús tziꞌ u mar, as til veꞌt Aak umaꞌl u naj uvaꞌ Mateo ibꞌii uvaꞌ xonlik tu u atinbꞌal uvaꞌ nimolpukat puaj tetz u Roma. As ech tal veꞌt Aak ileꞌ te naj: —Siꞌu. Xekebꞌen sviꞌ,— tiꞌk Aak. As txakpu veꞌt u Mateo. As xekebꞌ veꞌt naj tiꞌ u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","As bꞌex veꞌt u Jesús txꞌaꞌon tikabꞌal u Mateo. Nimal unqꞌa molol puajeꞌ tetz Roma tukꞌ unjoltu unqꞌa uxhchileꞌ uveꞌ yeꞌ ni niman u Tiixheꞌ, as xonebꞌ veꞌt ok chajnaj kꞌatz u Jesús tukꞌ unqꞌa ichusulibꞌ Aakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tul til veꞌt unqꞌa fariseo, as ichꞌoti veꞌt chajnaj itziꞌ unqꞌa ichusulibꞌ Aakeꞌ. —¿Kam qꞌi uvaꞌ nu kuxh itxꞌaꞌnik ok vechusuleꞌ xoꞌl unqꞌa aapaaveꞌ tukꞌ unqꞌa molol puajeꞌ tetz u Roma?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","As tul tabꞌi veꞌt u Jesús uvaꞌ ech nik tal unqꞌa fariseo, as ech tal veꞌt Aak ileꞌ te chajnaj: —Abꞌil uveꞌ yeꞌl chꞌoꞌm stiꞌ, as yeꞌl u aatzꞌakeꞌ la txakon stiꞌ. Pet aꞌ unqꞌa aachꞌoꞌmeꞌ uveꞌ nitxakon u aatzꞌakeꞌ stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","As bꞌenoj echustaj kam isuuchil u yoleꞌ uvaꞌ ech ni tal ileꞌ: Aꞌ ni val sete uvaꞌ la etxum ivatz vemooleꞌ. As aꞌeꞌ uveꞌ bꞌaꞌn sve tiꞌ unqꞌa txooeꞌ uvaꞌ la yatzꞌpu sunvatz, tiꞌk u yoleꞌ. Estiꞌeꞌ tuk val sete uvaꞌ jit unqꞌa uxhchileꞌ tul unmolo uvaꞌ ni tal jeꞌ ste uvaꞌ yeꞌl ipaav ati. Pet unqꞌa uxhchileꞌ uvaꞌ nichꞌoꞌn ste uvaꞌ kat paavini, as aꞌeꞌ tul unmolo, aqꞌal uvaꞌ la ijalpu veꞌt vitxumbꞌaleꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","As ul ichꞌoti veꞌt kaꞌl vichusulibꞌ u Xhuneꞌ te u Jesús. As ech tal veꞌt chajnaj ileꞌ: —¿Kam qꞌi, Pap? Tan oꞌ tukꞌ unqꞌa fariseo as jatpajul kuxh nu kukuy kuvaꞌy vatz u Tiixheꞌ. ¿As kam qꞌi uvaꞌ yeꞌ nikuy unqꞌa achusulibꞌeꞌ ivaꞌy?— tiꞌk chajnaj tal te Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ech tal veꞌt u Jesús ileꞌ: —As tul uvaꞌ at umaj nimla qꞌii tiꞌ teqꞌot tibꞌ umaj meꞌal ikꞌaol umaj uxhchil, ¿as lakol uch qꞌa uvaꞌ la ikuy unqꞌa ilonaaleꞌ ivaꞌy tul il u tzumela ileꞌ at tu u nimla qꞌiieꞌ? Pet lanal ilej umaꞌl u qꞌii uveꞌ la ul eesal el u tzumelaeꞌ sxoꞌl. As aꞌn la ikuy veꞌt unqꞌa ilonaaleꞌ ivaꞌy. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","As yeꞌxhebꞌil la kꞌooan umaj qꞌaꞌl oksaꞌm taꞌn umaj u akꞌ kꞌoo, tan la iqꞌix u akꞌ kꞌooeꞌ u qꞌaꞌl oksaꞌmeꞌ. As aal chit la qꞌixmu veꞌt u qꞌaꞌl oksaꞌmeꞌ taꞌn u akꞌ kꞌooeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","As yeꞌ la uch taqꞌax kuꞌ u akꞌ vino tu umaj qꞌaꞌl tzꞌuꞌm uvaꞌ ech tiloneꞌ xhaalo, tan la iqꞌix u akꞌ vino u qꞌaꞌl tzꞌuꞌmeꞌ, tul la qꞌuꞌili. As la peqꞌxik el u vino. As la tzꞌejxu veꞌt u tzꞌuꞌmeꞌ tukꞌ u vino. Pet tu umaj akꞌ tzꞌuꞌm la kuꞌkat u akꞌ vino, aqꞌal uvaꞌ yeꞌ la tzꞌejxi. As mitaꞌn la yan u tzꞌuꞌmeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","As antelik iyolon u Jesús tul bꞌex uloj umaꞌl viqꞌesal unqꞌa tiaal Israel. As qaaebꞌ veꞌt naj vatz Aak. As ech tal naj ileꞌ: —Bꞌan bꞌaꞌnil, Pap. Kuxh il vas unmeꞌaleꞌ uveꞌ kat kamya. As bꞌan bꞌaꞌnil. Kuxh ila. As la aaqꞌ jeꞌ aqꞌabꞌ stiꞌ, aqꞌal uvaꞌ la ul taama,— tiꞌk naj tala. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","As txakpu veꞌt u Jesús. As bꞌen veꞌt Aak tiꞌ naj tukꞌ unqꞌa ichusulibꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","As tul nik ixaan u Jesús tu bꞌey, as ul veꞌt umaꞌl u ixoj kꞌatz Aak uvaꞌ kabꞌlavaxnik yaabꞌ ixeꞌt ixoj chꞌoꞌnoj, tan aꞌ vitxꞌaao u ixojeꞌ yeꞌ nikat iyaꞌeꞌ. Pet at kuxh veꞌt sbꞌenameen. As jetzꞌen ok ixoj tiꞌ iqul Aak. As ikanoꞌk ixoj u toksaꞌm Aakeꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","tan ech nik tal jeꞌ ixoj ileꞌ ste: «Tul kuxh la unkanoꞌk u toksaꞌm u Jesús, as tuk bꞌaꞌnxoj ineꞌ,» tiꞌk ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","As isuchqꞌi veꞌt tibꞌ u Jesús. As isaji veꞌt bꞌen Aak ixoj. As ech tal veꞌt Aak ileꞌ: —Yeꞌ txumun axh, ixoj, tan kat elyu veꞌt u chꞌoꞌmeꞌ seeꞌ, tan tiꞌ uvaꞌ kat akꞌujbꞌaꞌ akꞌuꞌl sviꞌ,— tiꞌk u Jesús. As yak kuxh el veꞌt u chꞌoꞌmeꞌ tiꞌ ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","As tul oon veꞌt u Jesús tu vikabꞌal u Jairo, as isaji veꞌt bꞌen Aak unqꞌa najeꞌ uveꞌ nik oqꞌsan u suꞌeꞌ kꞌatz u kamnajeꞌ. As til veꞌt Aak uvaꞌ vaꞌl chit toqꞌ unqꞌa uxhchileꞌ kꞌatz u kamnajeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","As ech tal veꞌt Aak ileꞌ te unqꞌa uxhchileꞌ: —¡Bꞌenoj el ex tiꞌ kabꞌal! Tan yeꞌl u xvaakeꞌ kamnal koj. Pet vatik kuxheꞌ,— tiꞌk Aak. As itzeꞌle kuxh unqꞌa tenameꞌ viyol Aakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","As tul el veꞌt chꞌuꞌl unqꞌa uxhchileꞌ, as ok veꞌt Aak tu kabꞌal. As itxey veꞌt Aak iqꞌabꞌ u xvaakeꞌ. As txakpu veꞌt ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","As pax veꞌt itzibꞌlal u yoleꞌ tulaj unqꞌa tenameꞌ as tu unjoltu unqꞌa atinbꞌaleꞌ tiꞌ uveꞌ ibꞌan u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","As tul el veꞌt chꞌuꞌl u Jesús tzitziꞌ, as xekebꞌ bꞌen kaꞌvaꞌl unqꞌa tzot tiꞌ Aak. As sikꞌin veꞌt chajnaj. Ech nikat tal chajnaj ileꞌ: —¡Pap tiaal David, txum kuvatz!— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","As oon veꞌt u Jesús tu kabꞌal. As jetzꞌen veꞌt ok unqꞌa tzoteꞌ kꞌatz Aak. As ichꞌoti veꞌt Aak te chajnaj: —¿Ma nenima uvaꞌ la untxꞌol unbꞌaꞌnxisat vevatzeꞌ?— tiꞌk Aak. —Kano, Pap. Bꞌan bꞌaꞌnil sqe,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","As ikan veꞌt u Jesús vivatz chajnajeꞌ. As ech tal veꞌt Aak ileꞌ te chajnaj: —Tan tiꞌ uvaꞌ kat ekꞌujbꞌaꞌ ekꞌuꞌl sviꞌ as tuk unbꞌaꞌnxisa vevatzeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","As yak kuxh bꞌaꞌnx veꞌt vivatz chajnajeꞌ. As ilon veꞌt chajnaj. As tal veꞌt Aak te chajnaj tiꞌ uvaꞌ yeꞌxhebꞌil la tal chajnaj ste tiꞌ uvaꞌ kat ibꞌaꞌnxisa Aak vivatz chajnajeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pet tul kuxh el chꞌuꞌl chajnaj kꞌatz u Jesús, as bꞌex ipaxsa veꞌt chajnaj itzibꞌlal Aak tulaj unqꞌa tenameꞌ as tulaj unjoltu unqꞌa atinbꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","As tul uvaꞌ nik ipaxsa veꞌt chajnaj itzibꞌlal u Jesús, as eqꞌol veꞌt ok umaꞌl u aachꞌoꞌm vatz Aak uvaꞌ mem taꞌn u subꞌuleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","As teesa veꞌt u Jesús u subꞌuleꞌ tiꞌ u najeꞌ. As yolon veꞌt naj. As teqꞌo veꞌt taama unqꞌa tenameꞌ skajayil. As ech tal veꞌt unqꞌa tenam ileꞌ svatzaj: —Yeꞌ atixoj qil ibꞌaꞌnx veꞌt umaj uxhchil tu kutenameꞌ echeꞌ uveꞌ kat qillaꞌ,— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pet ech koj unqꞌa fariseo, tan ech tal veꞌt chajnaj ileꞌ: —Aꞌ vibꞌooqꞌol unqꞌa subꞌuleꞌ aqꞌol tetz u tijleꞌm najeꞌ tiꞌ teesal el unqꞌa subꞌuleꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","As isoli veꞌt u Jesús unqꞌa tenameꞌ tukꞌ unqꞌa talaj tenameꞌ. As nik ichusun veꞌt Aak tulaj unqꞌa atinbꞌaleꞌ tetz nachbꞌal Tiixh. As nikat tal Aak isuuchil u bꞌaꞌnla yoleꞌ tiꞌ u Tiixheꞌ uvaꞌ la ul veꞌt tukꞌ u tijleꞌmeꞌ tiꞌ vitenameꞌ. As kam kuxh chꞌoꞌmil uveꞌ atik xoꞌl unqꞌa tenameꞌ as nik ibꞌaꞌnxisa veꞌt Aak unqꞌa aachꞌoꞌmeꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","As tul til veꞌt u Jesús u mamaꞌla tenameꞌ uvaꞌ ech tatineꞌ echeꞌ unjoloj kaneeroꞌ uvaꞌ yeꞌl xeen tetz ati, as itxum veꞌt Aak ivatz. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ech tal veꞌt Aak ileꞌ te unqꞌa ichusulibꞌeꞌ: —Ech veꞌt tatin unqꞌa tenameꞌ echeꞌ unqꞌa koꞌmeꞌ uvaꞌ la pitxꞌlu veꞌteꞌ. As tul kaꞌl kuxh unqꞌa aqꞌonvileꞌ ati. ");
INSERT INTO ixlNNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pet ejajtaj te Tiixheꞌ tiꞌ uvaꞌ la ichaj tzan Aak unqꞌa aqꞌonvileꞌ tiꞌ ipitxꞌlu veꞌt u koꞌmeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","As imolo veꞌt u Jesús kabꞌlaval unqꞌa ichusulibꞌeꞌ. As taqꞌ veꞌt Aak tijleꞌm chajnaj tiꞌ teesal unqꞌa subꞌuleꞌ as tiꞌ ibꞌaꞌnxisal unqꞌa aachꞌoꞌmeꞌ, kꞌuxh kam kuxh chꞌoꞌmil nik bꞌanon. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aꞌ vibꞌii kabꞌlaval unqꞌa apóstol u viꞌlaꞌ: U Simón uvaꞌ Luꞌ; tukꞌ u Lixh, u titzꞌin u Simón; u Jacobo, vikꞌaol u Zebedeo; u Xhun, u titzꞌin u Jacobo; ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","u Piꞌl; u Bartolomé; u Maxh; u Mateo uvaꞌ nik molon puaj tetz u Roma; umaꞌt u Jacobo, vikꞌaol u Alfeo; u Tadeo; ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","umaꞌt u Simón uvaꞌ echenik xoꞌl unqꞌa tenam uvaꞌ nik alon itilul el unqꞌa ibꞌooqꞌol unqꞌa tenameꞌ uvaꞌ atik kan taꞌn u ijlenaaleꞌ tu u Roma; tukꞌ u Judas uvaꞌ Iscariote uvaꞌ kat kꞌayin u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","As ichaj veꞌt bꞌen u Jesús kabꞌlaval unqꞌa apóstol. As ech tal Aak ileꞌ te chajnaj: —Tul la bꞌen ex, as yeꞌ la ok ex xoꞌl unqꞌa uxhchileꞌ uveꞌ jit tiaal Israel. As mitaꞌn xoꞌl unqꞌa tenameꞌ tu u Samaria la okkat ex. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Pet aꞌ la okkat ex bꞌaxa xoꞌl unqꞌa tenameꞌ uveꞌ tiaal Israel, tan ech tatin unqꞌa uxhchileꞌ echeꞌ unjoloj unqꞌa kaneeroꞌ uveꞌ tzꞌejxinajle. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","As bꞌen epasataj u yoleꞌ, as ech la bꞌen etal ileꞌ ste: Tan il u Tiixh ileꞌ tul veꞌt tukꞌ u tijleꞌmeꞌ tiꞌ vitenameꞌ, chaj ex la etaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","As bꞌen ebꞌaꞌnxisataj unqꞌa aachꞌoꞌmeꞌ tukꞌ unqꞌa uxhchileꞌ uvaꞌ atoꞌk chꞌaꞌk chin stiꞌ. As etulsataj taama unqꞌa kamnajeꞌ. As eteesataj el unqꞌa subꞌuleꞌ tiꞌ unqꞌa uxhchileꞌ. Asoj la ebꞌan umaj bꞌaꞌnil, as ejajak ijaꞌmil, tan oyamal kuxheꞌ vetijleꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","As eteqꞌok epuaj tetz bꞌey. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","As mitaꞌn umaꞌtoj kam la eteqꞌo. Eteqꞌok umaꞌtoj exaꞌp; eteqꞌok chꞌexpubꞌ etiꞌ. As eteqꞌok esam; as eteqꞌok etechbꞌubꞌal, tan umaꞌl u aqꞌonvil as tetz chiteꞌ uvaꞌ la aqꞌpu veꞌt u techbꞌubꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","As tul la oon ex tu umaj tenam moj tu umaj tal tenam, as la echuk umaj uxhchil uvaꞌ bꞌaꞌn itxumbꞌal. As la ejaj evatbꞌal ste. As tzitziꞌ la atinkat ex lanal el chꞌuꞌl ex tu u tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tul la ok ex tu u kabꞌaleꞌ, as la etiixhi unqꞌa uxhchileꞌ uveꞌ at tu u kabꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Asoj bꞌaꞌn itxumbꞌal unqꞌa uxhchileꞌ la ibꞌan sete, as bꞌaꞌn tatin svatzaj la ibꞌaneꞌ taꞌn u Tiixheꞌ. Asoj yeꞌle, as yeꞌ bꞌaꞌn tatin u uxhchileꞌ svatzaj. Pet ech koj ex tan bꞌaꞌn chit etatineꞌ sevatzaj la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Pet abꞌil uvaꞌ yeꞌ la kꞌulun ex as yeꞌ la isaꞌ tabꞌit veyoleꞌ, as la el chꞌuꞌl ex tu u kabꞌaleꞌ moj tu u tenameꞌ katil uvaꞌ yeꞌ la kꞌulpukat ex. As la echitu veꞌt el u pojoeꞌ tiꞌ vetojeꞌ texhlal tetz uvaꞌ yeꞌ bꞌaꞌn vitxumbꞌal unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","As jik chit tuk val sete, tan la ilej umaꞌl u qꞌii uvaꞌ la ul u kꞌaxkꞌoeꞌ tiꞌ u tenameꞌ. As xoꞌvebꞌal chit u kꞌaxkꞌoeꞌ la ibꞌaneꞌ tiꞌ uveꞌ kat ibꞌan tu u Sodoma tukꞌ u Gomorra. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","As tuk unchaj bꞌen ex. As ech ebꞌeneꞌ echeꞌ ibꞌen unjoloj kaneeroꞌ xoꞌl unqꞌa xoꞌeꞌ. Pet atoj enachbꞌal echeꞌ nibꞌan unqꞌa txꞌiꞌlatxooeꞌ. As sula aama ex la ibꞌaneꞌ echeꞌ nibꞌan unqꞌa paroomaxheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","As atoj enachbꞌal vatz unqꞌa uxhchileꞌ, tan la eqꞌol ok ex vatz unqꞌa bꞌanol tetz isuuchil unqꞌa tenameꞌ. As la qꞌospu veꞌt ex tulaj unqꞌa atinbꞌaleꞌ tetz nachbꞌal Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","As tiꞌ kuxh uvaꞌ kꞌujleꞌl ekꞌuꞌl sviꞌ, as la eqꞌol veꞌt ok ex vatz unqꞌa ijlenaaleꞌ as vatz unqꞌa bꞌanol ivatz u ijlenaaleꞌ. As la etal veꞌt vunyoleꞌ te unqꞌa ijlenaaleꞌ as te unqꞌa uxhchileꞌ uvaꞌ jit tiaal Israel. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","As tul la txeypik bꞌen ex vatz unqꞌa ijlenaaleꞌ, as xaaniꞌk kuxh etaama tiꞌ uvaꞌ kam la etaleꞌ, tan la aqꞌax veꞌt eyol kam uvaꞌ la etal veꞌteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","As jit veꞌt exeꞌ la yolon ex. Pet aꞌ u Tiixhla Espíritu la aqꞌon veyoleꞌ kam uvaꞌ la etaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","As la ixoch veꞌt tibꞌ unqꞌa uxhchileꞌ tukꞌ unqꞌa titzꞌin tatzikeꞌ tiꞌ iyatzꞌat tibꞌ. As echat la ibꞌan unqꞌa bꞌaalaeꞌ te unqꞌa meꞌal ikꞌaoleꞌ. As la ul veꞌt iviꞌ unqꞌa meꞌal kꞌaoleꞌ tiꞌ vibꞌaaleꞌ. As la tal veꞌt iyatzꞌpu vibꞌaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","As la ixval veꞌt ex taꞌn unqꞌa tenameꞌ tiꞌ kuxh uvaꞌ kꞌujleꞌl ekꞌuꞌl sviꞌ. As abꞌil uvaꞌ yeꞌ la iyaꞌsa inimat in, kꞌuxh kam kuxh kꞌaxkꞌo la ipalebꞌe, as at itiichajil sunkꞌatz la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Asoj la tilul ex tu umaj tenam, as la ooj ex tiꞌ etoon tu umaꞌt u tenam, tan tuk val sete uvaꞌ yeꞌxnaj olebꞌ ex tiꞌ isolil vitenam unqꞌa tiaal Israeleꞌ skajayil tul la bꞌen uloj VIKꞌAOL U NAJEꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","As tuk chit ixvaloj ex, tan yeꞌl umaj u chusulibꞌeꞌ uvaꞌ at pal tiꞌ u chusul tetzeꞌ. As yeꞌl umaj kꞌam at pal tiꞌ vibꞌaal u aqꞌoneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","As kat ibꞌanleꞌ uvaꞌ la epalebꞌe unqꞌa kꞌaxkꞌoeꞌ echeꞌ uveꞌ nunpalebꞌe. As tul in vechusuleꞌ. As echat chit la ibꞌan u kꞌameꞌ echeꞌ nibꞌan u bꞌaal aqꞌoneꞌ. As ech u vatineꞌ sexoꞌl echeꞌ umaj bꞌaala xoꞌl unqꞌa meꞌal ikꞌaoleꞌ. Asoj kat alpi uvaꞌ: «Axh Beelzebú uvaꞌ vibꞌooqꞌol unqꞌa subꞌuleꞌ,» chꞌelel u bꞌaalaeꞌ, ¿as aꞌ kol chit yeꞌ la alax qꞌa tiꞌ unqꞌa meꞌal ikꞌaoleꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Pet xoꞌviꞌk ex te unqꞌa tenameꞌ, tan jankꞌal unqꞌa yoleꞌ uvaꞌ yeꞌxhebꞌil ootzin tetz, as techal la ootzili. As jankꞌal unqꞌa yoleꞌ uvaꞌ mujel, as techal la ootzili. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","As jankꞌal unqꞌa yoleꞌ uveꞌ ni val sete cheel, as techal la bꞌen etal isuuchil te unqꞌa uxhchileꞌ. As jankꞌal unqꞌa yoleꞌ uveꞌ nu kuyol skujunal setukꞌ as bꞌenoj etaltaj viꞌ unqꞌa tenameꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","As xoꞌviꞌk ex te unqꞌa uxhchileꞌ uveꞌ la yatzꞌon vechiꞌoleꞌ, tan echeꞌ la koj olebꞌ tiꞌ iyatzꞌat vetaanxelaleꞌ. Pet exoꞌvataj u Tiixheꞌ, tan la taqꞌ bꞌen Aak vechiꞌoleꞌ tukꞌ vetaanxelaleꞌ tu u choobꞌal paaveꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","As ootzimal setaꞌn uvaꞌ yeꞌxh jatvaꞌl nibꞌenkat kaꞌvoꞌj talaj tzꞌikin tul nikꞌayileꞌ. As echeꞌ la kuxh koj chajpik tzan txoo tu txꞌavaꞌ, asoj jit u Kubꞌaal Tiixheꞌ la alon. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Echat kuxh ex unpajte, tan junun unqꞌa xiꞌl eviꞌeꞌ, as acheleꞌ skajayil taꞌn Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Estiꞌeꞌ ni val sete uvaꞌ xoꞌviꞌk chit ex, tan nim etalcheꞌ vatz u Tiixheꞌ tiꞌ unqꞌa talaj tzꞌikineꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","As abꞌil uvaꞌ yeꞌ la xoꞌvi tiꞌ talat tibꞌ uvaꞌ nimamal in staꞌn vatz unqꞌa tenameꞌ, as echat la unbꞌan stiꞌ vatz vunBꞌaaleꞌ uvaꞌ echen tu almikaꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pet abꞌil uvaꞌ la teesa tibꞌ sunkꞌatz vatz unqꞌa tenameꞌ, as echat la unbꞌan stiꞌ vatz vunBꞌaaleꞌ uvaꞌ echen tu almikaꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","As kamal netitzꞌa uvaꞌ kat ul in tiꞌ uvaꞌ bꞌaꞌn tatin unqꞌa uxhchileꞌ svatzaj vatz u txꞌavaꞌeꞌ, as tul yeꞌle tan aal tuk okoj veꞌt ixoꞌl. As techal la iyatzꞌ veꞌt tibꞌ svatzaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","As tul kat ul in, as at unqꞌa najeꞌ kat iyaa tibꞌ tukꞌ vibꞌaaleꞌ. As at unqꞌa ixojeꞌ kat iyaa tibꞌ tukꞌ vitxutxeꞌ as unqꞌa alibꞌaeꞌ tukꞌ u talibꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tan yeꞌle uvaꞌ kat koj chit la ulkat unqꞌa chꞌoꞌnchil aamaeꞌ. Pet an kuxh unqꞌa titzꞌin tatzikeꞌ la oksan u chꞌoꞌnchil aamaileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Estiꞌeꞌ ni val sete uvaꞌ abꞌil uveꞌ aꞌ kuxh vitxutxeꞌ moj vibꞌaaleꞌ la ixoꞌni as yeꞌ la ixoꞌni in, as jit tetzeꞌ uvaꞌ la ok sunkꞌatz. As abꞌil uveꞌ aꞌ kuxh la ixoꞌni u meꞌal ikꞌaoleꞌ as yeꞌ la ixoꞌni in, as jit tetzeꞌ uvaꞌ la ok sunkꞌatz. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","As abꞌil uvaꞌ yeꞌ la kuyun unqꞌa kꞌaxkꞌoeꞌ tiꞌ ixekebꞌ sviꞌ, as yeꞌ la uch tok veꞌt chusulibꞌil sunkꞌatz. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","As abꞌil uveꞌ aꞌ kuxh vitiichajileꞌ ni titzꞌa veꞌt vatz u txꞌavaꞌeꞌ, as yeꞌl itiichajil kꞌatz u Tiixheꞌ la ibꞌaneꞌ. Pet abꞌil uvaꞌ yeꞌ la toksa taama tiꞌ u vatz txꞌavaꞌeꞌ tan tiꞌ uvaꞌ nimamal in staꞌn, as at itiichajil kꞌatz u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","As abꞌil uveꞌ la kꞌulun ex as eela kuxh stukꞌ uvaꞌ in nikꞌul in. As abꞌil uveꞌ ni kꞌulun in as eela kuxh stukꞌ uvaꞌ aꞌ vunBꞌaaleꞌ nikꞌuleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","As abꞌil uveꞌ la kꞌulun umaj u qꞌajsan tetz viyol u Tiixheꞌ, as eela kuxh vitxꞌajaꞌmeꞌ tukꞌ vitxꞌajaꞌm u qꞌajsan tetz viyol u Tiixheꞌ. As abꞌil uvaꞌ la kꞌulun umaj u jikla aama as eela kuxh vitxꞌajaꞌmeꞌ tukꞌ vitxꞌajaꞌm u jikla aamaeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","As abꞌil la aqꞌon umaj u picheel cheꞌvla aꞌ te umaj vunchusulibꞌeꞌ tiꞌ kuxh uvaꞌ unchusulibꞌ, as jik chit tuk val sete uvaꞌ at itxꞌajaꞌm xeꞌ u Tiixheꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","As tul yaꞌ veꞌt u Jesús tiꞌ talat bꞌen itxumbꞌal kabꞌlaval unqꞌa ichusulibꞌeꞌ, as bꞌen veꞌt Aak tiꞌ ichusuneꞌ as tiꞌ ipaxsat viyol u Tiixheꞌ tulaj unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","As tul atik ok u Xhuneꞌ tu u kaarsa, as tabꞌi veꞌt naj itzibꞌlal u Jesucristo. As ichaj veꞌt bꞌen u Xhuneꞌ kaꞌvaꞌl unqꞌa ichusulibꞌeꞌ ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","tiꞌ bꞌen ichꞌotit te Aak. Ech tal veꞌt chajnaj ileꞌ: —¿Ma axh u Cristo uvaꞌ alel kan uvaꞌ la uli? ¿Pet moj la kutxꞌebꞌ tul umaꞌtoj uxhchil?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","As ech tal veꞌt Aak ileꞌ te unqꞌa ichusulibꞌ u Xhuneꞌ: —Bꞌenoj etaltaj te u Xhuneꞌ kam uvaꞌ kat etila as kam uvaꞌ kat etabꞌi, ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","tan ni tilon veꞌt unqꞌa uxhchileꞌ uvaꞌ tzotike; as nixaan veꞌt unqꞌa uxhchileꞌ uvaꞌ koꞌxike; as unqꞌa uxhchileꞌ uveꞌ atik ok chꞌaꞌk chin stiꞌ, as kat txanyu veꞌteꞌ; as ni tabꞌin veꞌt unqꞌa uxhchileꞌ uvaꞌ yeꞌ nik tabꞌineꞌ; as kat ulyu veꞌt taama unqꞌa kamnajeꞌ. As ni talax veꞌt u bꞌaꞌnla yoleꞌ te unqꞌa meebꞌaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","As achvebꞌal chit u uxhchileꞌ uvaꞌ yeꞌ la kaꞌkabꞌin taama tiꞌ ikꞌujbꞌaꞌt ikꞌuꞌl sviꞌ,— tiꞌk u Jesús tal te chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tul qꞌaav veꞌt unqꞌa ichusulibꞌ u Xhuneꞌ, as tal veꞌt u Jesús isuuchil u yoleꞌ tiꞌ u Xhuneꞌ xoꞌl unqꞌa tenameꞌ. As ech tal veꞌt Aak ileꞌ: —¿Kam kat bꞌex etil tiꞌ u Xhuneꞌ tul atik tu u tzuukin txꞌavaꞌeꞌ? ¿Ma kat bꞌex etil umaj uxhchil uvaꞌ ech vitxumbꞌaleꞌ echeꞌ viꞌoj aa uvaꞌ niliiqꞌaꞌch taꞌn u kajiqꞌeꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Pet moj aꞌ kat bꞌex etil umaj uxhchil uvaꞌ vejel chit tibꞌ tukꞌ u toksaꞌmeꞌ? Yeꞌle, tan jankꞌal unqꞌa najeꞌ uveꞌ vejel chit tibꞌ tukꞌ u toksaꞌmeꞌ, as aꞌ kuxh atkat chajnajeꞌ tulaj ikabꞌal unqꞌa ijlenaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Pet kam qꞌi kat bꞌex etil tiꞌ u Xhuneꞌ? ¿As moj umaj qꞌajsan tetz viyol u Tiixheꞌ? Kano, an chiteꞌ, tan qꞌajsan tetz viyol u Tiixheꞌ u Xhuneꞌ. Pet at pal u Xhuneꞌ tiꞌ unjoltu unqꞌa qꞌajsan tetz viyol u Tiixheꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","tan aꞌ u Xhuneꞌ uvaꞌ ni tal u yoleꞌ uvaꞌ tzꞌibꞌamal kan uvaꞌ ech ni tal ileꞌ: Tuk unbꞌaxsa bꞌen umaꞌl u alol tetz vunyoleꞌ savatz. As aꞌeꞌ la bꞌanon tuch u bꞌeyeꞌ savatz, tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","As jik chit tuk val sete, tan yeꞌl umaꞌtoj uxhchil kat itzꞌebꞌi uvaꞌ nim talchu tiꞌ u Xhuneꞌ uvaꞌ nik aqꞌon kuꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ. Pet u uxhchileꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ, as ni tileꞌ uveꞌ nunbꞌaneꞌ, as antu veꞌt unqꞌa uxhchileꞌ uveꞌ tzꞌubꞌ kuxh talcheꞌ ni ilon, as nim veꞌt talcheꞌ tiꞌ u Xhuneꞌ, tan yeꞌ kat til u Xhuneꞌ uveꞌ nunbꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tul xeꞌt u Xhuneꞌ chusun, as xeꞌt unqꞌa uxhchileꞌ tiꞌ iyaꞌlut tibꞌ tiꞌ toksat tibꞌ xoꞌl unqꞌa tenameꞌ uveꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ, tan aꞌ ni tal unqꞌa uxhchileꞌ uvaꞌ tukꞌ kuxh viyakꞌileꞌ uvaꞌ la ok xoꞌl unqꞌa itenam Aakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","As kajayil chit unqꞌa qꞌajsan tetz viyol u Tiixheꞌ, tukꞌ u tzaqꞌiteꞌ uveꞌ itzꞌibꞌa kan u Moisés kat yolon kan tiꞌ unqꞌa uvaꞌ ni tuch veꞌt cheel. As katnal ul veꞌt u Xhuneꞌ tiꞌ ul ibꞌanataꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","tan u Elías uvaꞌ alel kan u tulebꞌaleꞌ as ivaatzileꞌ kat ul ibꞌan u Xhuneꞌ. Asoj la enima, as enimataj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","As abꞌiste ex uvaꞌ nepal tu vunyoleꞌ, as etabꞌitaj uveꞌ ni valeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿As kam unbꞌooj la unbꞌan eela tukꞌ u txumbꞌaleꞌ uveꞌ nebꞌaneꞌ? Tan eela kuxh vetxumbꞌaleꞌ tukꞌ unqꞌa xaakeꞌ uveꞌ nixonebꞌ tu kꞌayibꞌal. As nisikꞌineꞌ tul nisaacheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","As ech ni tal ileꞌ svatzaj: «Kꞌuxh kat qoqꞌsa unqꞌa aaeꞌ sevatz, as yeꞌl ex kat bꞌix ex; as kꞌuxh kat kubꞌitza unqꞌa bꞌitzeꞌ uvaꞌ txumlebꞌal chittuꞌ, as yeꞌl ex kat oqꞌ ex,» tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","As tul kat ul u Xhuneꞌ, as nik ikuy ivaꞌy. As yeꞌ nik tukꞌa u taꞌl u uuvaeꞌ. As kat eteesa iqꞌii, tan kat etala uvaꞌ subꞌul atik ok skꞌatz, uveꞌ nik etaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","As tul kat ul in, in VIKꞌAOL U NAJEꞌ, as nuntxꞌaꞌneꞌ, as ni vukꞌa u taꞌl u uuvaeꞌ. As netal veꞌt sviꞌ uvaꞌ in bꞌichꞌ uul as vetz kꞌultziꞌ vibꞌ tukꞌ unqꞌa molol puajeꞌ tetz u Roma as tukꞌ unqꞌa uxhchileꞌ uvaꞌ aapaav sevatz. Pet ech koj uveꞌ la val sete, tan aꞌ la etexhlakat u jikla txumbꞌaleꞌ tiꞌ uveꞌ nunbꞌaneꞌ as tukꞌ uveꞌ kat ibꞌan u Xhuneꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","As xeꞌt iyaa veꞌt u Jesús unqꞌa tenameꞌ uvaꞌ maꞌtik ikꞌuchat Aak unqꞌa mamaꞌla bꞌaꞌnileꞌ ste, tan tiꞌ uvaꞌ yeꞌ kat ijalpu veꞌt unqꞌa uxhchileꞌ vitxumbꞌaleꞌ. Ech tal veꞌt Aak ileꞌ te unqꞌa uxhchileꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Oyebꞌ chit evatz, ex aa Corazín; as oyebꞌ chit evatz, ex aa Betsaida! Tan aꞌ koj kat unbꞌankat unqꞌa nimla bꞌaꞌnileꞌ vatz unqꞌa aa Tiro as vatz unqꞌa aa Sidón echeꞌ uveꞌ nunbꞌan sexoꞌl scheel, as naꞌytzaneꞌxh ijalput unqꞌa tenameꞌ itxumbꞌal vatz u Tiixheꞌ. As kat ikꞌuchleꞌ uvaꞌ kat ijalpu veꞌt vitxumbꞌaleꞌ tiꞌ toksat unqꞌa qichkin oksaꞌmeꞌ as tiꞌ taqꞌat jeꞌ tzaꞌj tiviꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Estiꞌeꞌ ni val sete uvaꞌ xoꞌvebꞌal chit u kꞌaxkꞌoeꞌ uveꞌ la ul setiꞌ tiꞌ unqꞌa aa Tiro tukꞌ unqꞌa aa Sidón, tul la ilej veꞌt u qꞌiieꞌ uvaꞌ la bꞌanax isuuchil unqꞌa tenameꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","As echat kuxh ex, ex aa Capernaúm, tan aꞌ netaleꞌ uvaꞌ la oon ex tu almikaꞌ tukꞌ u txꞌiibꞌal eqꞌiieꞌ. As yeꞌle, tan aꞌ la aqꞌpikkat bꞌen ex tu u kꞌaxkꞌola atinbꞌaleꞌ uvaꞌ atkat unqꞌa kamnajeꞌ uvaꞌ paasan tzii, tan tu koj u Sodoma taꞌ kat kꞌuchpukat unqꞌa bꞌaꞌnileꞌ echeꞌ uvaꞌ kat unkꞌuch sexoꞌl, as atileꞌxh unqꞌa aa Sodoma cheel. ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Estiꞌeꞌ ni val sete, tan xoꞌvebꞌal chit unqꞌa kꞌaxkꞌoeꞌ la ul setiꞌ tiꞌ unqꞌa kꞌaxkꞌo uveꞌ la ul tiꞌ unqꞌa aa Sodoma tul la ilej u qꞌiieꞌ tiꞌ ibꞌanax isuuchil unqꞌa tenameꞌ skajayil,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","As an chit tu unqꞌa qꞌiieꞌ inach veꞌt u Jesús Tiixh. Ech tal Aak ileꞌ: —UnBꞌaal, axheꞌ viBꞌaal u almikaꞌeꞌ tukꞌ u vatz txꞌavaꞌeꞌ skajayil. As ni voksa aqꞌii, tan tiꞌ uvaꞌ kat amuj veꞌt isuuchil unqꞌa yoleꞌ vatz unqꞌa uxhchileꞌ uveꞌ at itxumbꞌal ni tal jeꞌ ste. As aꞌ kat akꞌuchkat te unqꞌa uxhchileꞌ uvaꞌ ech itxumbꞌaleꞌ echeꞌ unqꞌa talaj intxaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","As an chiteꞌ, unBꞌaal, tan echeꞌ taꞌ uveꞌ nasaꞌ,— tiꞌk u Jesús tul inach Aak Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","As ech tal veꞌt u Jesús ileꞌ te unqꞌa tenameꞌ: —Tan at veꞌt vijleꞌm tiꞌ unqꞌa veeꞌ skajayil taꞌn vunBꞌaaleꞌ. As yeꞌxhebꞌil ootzin vetz uvaꞌ in iKꞌaol u Tiixheꞌ. As yeꞌxhebꞌil ootzin tetz vunBꞌaaleꞌ. Pet taꞌn kuxh ineꞌ uvaꞌ ootzin tetz Aak as tukꞌ unqꞌa tenameꞌ uvaꞌ la unsaꞌ vaqꞌat ste tiꞌ uvaꞌ la tootzi Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Estiꞌeꞌ tuk val sete, siꞌunajtaj sunkꞌatz sekajayil, tan ineꞌ la aqꞌon etiꞌlebꞌal, jankꞌal ex uveꞌ koolinal ex taꞌn vetaqꞌoneꞌ as ijtzꞌinalu veꞌt ex taꞌn vepaaveꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","As okojtaj ex sunkꞌatz. As eelataj kubꞌeneꞌ. As echustaj etibꞌ sunkꞌatz, tan in chit sula aama tukꞌ chit u vaanxelaleꞌ. As sunkꞌatz la elejkat u iꞌlichileꞌ tetz vetaanxelaleꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","tan jit tzaꞌleꞌ tiꞌ enimat vuntzaqꞌiteꞌ. As yeꞌle uvaꞌ kꞌaxkꞌo koj enimat u bꞌaꞌnla yoleꞌ uvaꞌ ni val sete,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tu umaꞌl u xeem qꞌii, as bꞌex paloj u Jesús tukꞌ unqꞌa ichusulibꞌeꞌ xoꞌl unqꞌa trigo uvaꞌ avamalike. As nikat ivaꞌy veꞌt chajnaj. As xeꞌt itzuj veꞌt chajnaj kaꞌl ivatz unqꞌa trigo. As techbꞌu chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tul til veꞌt kaꞌl unqꞌa fariseo, as ech tal veꞌt chajnaj ileꞌ te u Jesús: —Saji u veeꞌ nibꞌan unqꞌa achusulibꞌeꞌ, tan aꞌeꞌ yeꞌ la uch ibꞌanchu tu u xeem qꞌiieꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","As ech tal veꞌt u Jesús ileꞌ: —¿Ma yeꞌxhkam bꞌa nesikꞌle uvaꞌ kat ibꞌan u David tukꞌ unqꞌa imooleꞌ uvaꞌ xekik stiꞌ, tul uvaꞌ kat vaꞌyi? ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tan kat ok veꞌt u David vatz u atinbꞌaleꞌ uvaꞌ ninachpukat Tiixh. As unqꞌa paaneꞌ uvaꞌ maꞌtik teesal el tzan viꞌ u meexhaeꞌ tu u nachbꞌal Tiixheꞌ, as kat itxꞌaꞌ u David tukꞌ unqꞌa imooleꞌ, kꞌuxh yeꞌl tokebꞌal u David tiꞌ techbꞌut unqꞌa paaneꞌ as mitaꞌn unqꞌa imooleꞌ uvaꞌ xekelik stiꞌ. Pet taꞌn kuxh unqꞌa oksan iyol tenam vatz Tiixh la echbꞌun unqꞌa paaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿As ma yeꞌxhkam bꞌa nesikꞌle tu u tzaqꞌiteꞌ uveꞌ itzꞌibꞌa kan u Moisés tiꞌ unqꞌa oksan iyol tenam vatz Tiixh? Tan jun xeem qꞌii ni tok chajnaj tu u nachbꞌal Tiixheꞌ tiꞌ ibꞌanat chajnaj u taqꞌoneꞌ tiꞌ u tijleꞌmeꞌ. Tan kꞌuxh yeꞌ la uch taqꞌonvu uxhchil tu u xeem qꞌiieꞌ, as yeꞌl ipaav unqꞌa nachol Tiixheꞌ vatz u Tiixheꞌ tiꞌ u taqꞌoneꞌ uveꞌ nibꞌan tu u xeem qꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","As tuk val sete, tan at umaꞌl u uxhchil sexoꞌl cheel uvaꞌ nim chit talcheꞌ tiꞌ u tostiixheꞌ. As ineꞌ u uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","As la koj pal ex stuul tiꞌ umaꞌl u yol uvaꞌ ech ni tal ileꞌ: Aꞌ nunsaꞌ uvaꞌ la etxum ivatz vemooleꞌ. As aꞌeꞌ uveꞌ bꞌaꞌn sve tiꞌ unqꞌa txooeꞌ uveꞌ la eyatzꞌ jeꞌ tzan sunvatz, tiꞌk u yoleꞌ. As nu koj epal stuul, as yeꞌl ipaaveꞌ unqꞌa uxhchileꞌ la etaqꞌ jeꞌ uveꞌ yeꞌl ipaav ati. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","As tul ineꞌ uvaꞌ in VIKꞌAOL U NAJEꞌ, as ineꞌ viBꞌaal u xeem qꞌiieꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tul maꞌtik ipal u Jesús kꞌatz unqꞌa trigo, as ok veꞌt Aak tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","As atik ok umaꞌl u naj uvaꞌ kꞌoroꞌxhinik tibꞌ umaꞌl viqꞌabꞌeꞌ. Tul nikat ichuk kaꞌl unqꞌa fariseo txumbꞌal tiꞌ icheesat ipaav u Jesús. As ichꞌoti veꞌt chajnaj te Aak. Ech tal chajnaj ileꞌ: —¿Ma la uch ibꞌaꞌnxisal umaj aachꞌoꞌm tu u xeem qꞌiieꞌ moj yeꞌle?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ech tal veꞌt u Jesús ileꞌ: —Asoj at umaj ex uvaꞌ at umaj ekaneeroꞌ as tul la bꞌen txoo tu umaj jul tu u xeem qꞌiieꞌ, ¿as ma yeꞌ la bꞌen eteqꞌo jeꞌ tzan txoo tu u juleꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿As aꞌ kol chit yeꞌl umaj uxhchil qꞌa? Tan nim talcheꞌ u uxhchileꞌ tiꞌ u kaneeroꞌeꞌ. Estiꞌeꞌ ni val sete uvaꞌ la uch ibꞌanax u bꞌaꞌneꞌ tu u xeem qꞌiieꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","As ech tal veꞌt Aak ileꞌ te u aachꞌoꞌmeꞌ: —Yuꞌbꞌaꞌ vaqꞌabꞌeꞌ,— tiꞌk Aak. As iyuꞌbꞌaꞌ veꞌt naj viqꞌabꞌeꞌ. As yak kuxh bꞌaꞌnx veꞌt viqꞌabꞌ najeꞌ. As eela veꞌt viqꞌabꞌ najeꞌ skaabꞌil ibꞌana. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tul el veꞌt chꞌuꞌl unqꞌa fariseo tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh, as xeꞌt iyol veꞌt chajnaj svatzaj tiꞌ ichukax txumbꞌal tiꞌ iyatzꞌpu u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","As ootzimalik taꞌn u Jesús kam uvaꞌ nikat iyol veꞌt chajnaj. As el veꞌt chꞌuꞌl Aak tu u tenameꞌ. As aꞌ chit mamaꞌla tenameꞌ xekebꞌ veꞌt tiꞌ Aak. As nikat ibꞌaꞌnxisa veꞌt Aak unqꞌa aachꞌoꞌmeꞌ skajayil uvaꞌ kat oon kꞌatz Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","As tal u Jesús te chajnaj uvaꞌ yeꞌxh katil la talkat chajnaj uvaꞌ kam u tijleꞌm Aakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","As bꞌex ibꞌan veꞌt umaꞌt u yol uvaꞌ tal kan u qꞌajsan tetz viyol u Tiixheꞌ uvaꞌ Isaías. Ech tal ileꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Il umaꞌl vunkꞌam ilaꞌ at sexoꞌl uvaꞌ txaael bꞌen svaꞌn, uvaꞌ xoꞌn chit sve. As tuk voksa vunTiixhla Espíritu stiꞌ, tan nitxuqꞌtxun veꞌt vaama stiꞌ. As aꞌeꞌ la alon unqꞌa jikla yoleꞌ xoꞌl unqꞌa tenameꞌ uvaꞌ jit tiaal Israel. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","As yeꞌl chꞌaꞌo la ibꞌaneꞌ. As yeꞌxhkam la sikꞌini. As yeꞌxhebꞌil la abꞌin u tuul iviꞌeꞌ tu bꞌey. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","As yeꞌ la ul itatzꞌ umaj aa uvaꞌ vuchꞌul veꞌteꞌ. As yeꞌl u xamaleꞌ la itzaasa uveꞌ nu kuxh ibꞌusbꞌulaꞌneꞌ. Pet techal chit la ilej veꞌt u qꞌiieꞌ uvaꞌ la olebꞌ veꞌt tiꞌ ikꞌujbꞌaꞌt u jikla txumbꞌaleꞌ xoꞌl unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","As la ikꞌujbꞌaꞌ unqꞌa uxhchileꞌ ikꞌuꞌl stiꞌ uvaꞌ jit tiaal Israel, tiꞌk u yoleꞌ uvaꞌ tal kan u Isaías. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","As eqꞌol ok umaꞌl u aachꞌoꞌm vatz u Jesús uvaꞌ tzot as mem unpajte, tan atik ok subꞌul skꞌatz. As ibꞌaꞌnxisa veꞌt u Jesús u najeꞌ. As yolon veꞌt naj. As ilon naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","As teqꞌo veꞌt taama unqꞌa tenameꞌ. As ech tal veꞌt ileꞌ svatzaj: —¿Moj jit u tiaal David u najeꞌ uvaꞌ alel kan u tulebꞌaleꞌ?— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","As tul tabꞌi veꞌt unqꞌa fariseo, as ech tal veꞌt chajnaj ileꞌ: —Yeꞌle, pet aꞌ vibꞌooqꞌol unqꞌa subꞌuleꞌ uvaꞌ Beelzebú ni aqꞌon tijleꞌm naj tiꞌ teesal el unqꞌa subꞌuleꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","As ootzimalik vitxumbꞌal chajnajeꞌ taꞌn u Jesús uvaꞌ kam nikat tal chajnaj tiꞌ Aak. As ech tal veꞌt Aak ileꞌ: —As jankꞌal unqꞌa nimla tenameꞌ, asoj jatxel tibꞌ, as yeꞌl iyol nikꞌul tibꞌ svatzaj. As la kuxh teꞌpisa veꞌt tibꞌ u tenameꞌ. As echat tatin unqꞌa uxhchileꞌ tu umaj tenam as moj tu umaj kabꞌal, tan asoj yeꞌ la ikꞌul tibꞌ iyol svatzaj, as yeꞌl unqꞌa uxhchileꞌ bꞌaꞌn koj tatineꞌ la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","As echat kuxh bꞌanel taꞌn u Satanás, tan asoj aꞌ u Satanás ni laqꞌbꞌan el unqꞌa imooleꞌ, as jatxel tibꞌeꞌ svatzaj. As la kuxh yookꞌeꞌ u tatin u txꞌiꞌlanajeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Tan asoj ni veesa el unqꞌa subꞌuleꞌ taꞌn u Satanás uvaꞌ Beelzebú, ¿as abꞌil etz u yakꞌileꞌ qꞌi uveꞌ nitxakonsa unqꞌa echusulibꞌeꞌ tul ni teesa el unqꞌa subꞌuleꞌ? As ech ni valkateꞌ sete uvaꞌ an chit chajnaj ni kꞌuchun uvaꞌ sotznal ekꞌuꞌl tul ni teesa el chajnaj unqꞌa subꞌuleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pet nunlaqꞌbꞌa el unqꞌa subꞌuleꞌ taꞌn viTiixhla Espíritu u Tiixheꞌ, as aꞌ texhlal tetzeꞌ uvaꞌ kat ulyu veꞌt u tijleꞌm u Tiixheꞌ tiꞌ vitenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","As la koj uch tok umaj uxhchil tikabꞌal umaj naj uvaꞌ xoꞌvebꞌal chit viyakꞌileꞌ tiꞌ bꞌen telqꞌat el tzan u tetz najeꞌ. Pet lanal kꞌalpeꞌ u najeꞌ uvaꞌ xoꞌvebꞌal chit viyakꞌileꞌ, as aꞌn la uch telqꞌal veꞌt unqꞌa tetz najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Pet tuk val sete, tan abꞌil uvaꞌ jit echen sunkꞌatz, as aꞌeꞌ ni chꞌoꞌn taama sviꞌ. As abꞌil uveꞌ yeꞌ ni lochon in, as aꞌeꞌ ni majon ivatz unqꞌa tenameꞌ tiꞌ tok sunkꞌatz. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Estiꞌeꞌ tuk val sete, tan kam kuxh yoqꞌoꞌmil la tal umaj uxhchil vatz u Tiixheꞌ as moj kam kuxh paavil la ibꞌan umaj uxhchil, as la uch isotzsal ipaav u uxhchileꞌ. Pet abꞌil uvaꞌ la yoqꞌon tiꞌ u bꞌaꞌnileꞌ uvaꞌ nibꞌan u Tiixhla Espíritu tiꞌ talataꞌ uvaꞌ aꞌ u txꞌiꞌlanajeꞌ ni bꞌanon, as yeꞌl ipaav u uxhchileꞌ la sotzi. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","As abꞌil uvaꞌ la yoqꞌon sviꞌ, in uvaꞌ in VIKꞌAOL U NAJEꞌ, as la uch isotz ipaav u uxhchileꞌ. Pet asoj abꞌil la yoqꞌon tiꞌ u Tiixhla Espíritu, as yeꞌl ipaav u uxhchileꞌ la sotz veꞌteꞌ, mitaꞌn cheel tu unqꞌa qꞌiiaꞌ as mitaꞌn tu u qꞌiieꞌ uveꞌ tuleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Tan asoj bꞌaꞌn u tzeꞌeꞌ, as bꞌaꞌneꞌ vivatz tzeꞌeꞌ; asoj vaꞌlexh u tzeꞌeꞌ, as vaꞌlexheꞌ taꞌ vivatz tzeꞌeꞌ, tan la exhlal unqꞌa tzeꞌeꞌ tul la vatzin tzeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Ech etxumbꞌaleꞌ echeꞌ unqꞌa txꞌiꞌlatxooeꞌ! Tan la koj uch etalat umaj bꞌaꞌnla yol, tan aꞌ u vaꞌlexheꞌ uveꞌ at tu vetaanxelaleꞌ. Tan kam uveꞌ at tu vetaanxelaleꞌ, as aꞌeꞌ ni tal vetziꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","As u bꞌaꞌnla aamaeꞌ, tan aꞌ kuxh unqꞌa bꞌaꞌnla chaj txumbꞌaleꞌ ni tel chꞌuꞌl tu u taanxelaleꞌ. Pet ech koj u uxhchileꞌ uvaꞌ vaꞌlexh vitxumbꞌaleꞌ, tan aꞌ kuxh u vaꞌlexheꞌ ni tel chꞌuꞌl tu u taanxelaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","As tuk val sete, tan jankꞌal unqꞌa vaꞌlexhla chaj yoleꞌ uvaꞌ la tal unqꞌa uxhchileꞌ as tuknal chꞌotpoj itziꞌ tiꞌ u vaꞌlexheꞌ uveꞌ kat tala, tul la ilej veꞌt u qꞌiieꞌ tiꞌ ibꞌanax isuuchil unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","As aꞌ ni val kateꞌ tan an kuxh veyoleꞌ la bꞌanon uvaꞌ yeꞌl epaav ati. As an kuxh veyoleꞌ la alon ebꞌen tu u kꞌaxkꞌoeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","As ech tal veꞌt kaꞌl unqꞌa uxhchil ileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as tukꞌ kaꞌt unqꞌa fariseo: —Chusul, aꞌ ni qaleꞌ uvaꞌ la qil akꞌuchat umaj kꞌuchbꞌal tetz uvaꞌ at eejleꞌm,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","As ech tal veꞌt u Jesús ileꞌ: —¡Ech veꞌt vetxumbꞌaleꞌ echeꞌ unqꞌa uxhchileꞌ uvaꞌ vaꞌlexh vitxumbꞌaleꞌ nibꞌaneꞌ! ¡As ech veꞌt ex vatz u Tiixheꞌ echeꞌ umaj naj uvaꞌ nichuk tixoj! As kꞌuxh nejaj umaj kꞌuchbꞌal tetz u vijleꞌmeꞌ, as echeꞌ la koj kꞌuchpu sete. Pet aꞌ kuxh uvaꞌ la kꞌuchpu sete echeꞌ uvaꞌ kat ibꞌan u Jonás, u qꞌajsan tetz viyol u Tiixheꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","tan echat chit tuk unbꞌaneꞌ echeꞌ uveꞌ kat ibꞌan u Jonás, tan oxvaꞌl qꞌii tukꞌ oxvaꞌt aqꞌbꞌal kat atin u Jonás tu tuul umaꞌl u nimla txay. As oxvaꞌl qꞌii tukꞌ oxvaꞌt aqꞌbꞌal tukꞌ atinoj VIKꞌAOL U NAJEꞌ tu u txꞌavaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","As la ul veꞌt unqꞌa aa Nínive vatz u Tiixheꞌ tiꞌ ixochat ex tu u qꞌiieꞌ uvaꞌ la bꞌanax isuuchil unqꞌa tenameꞌ skajayil, tan tul uvaꞌ tabꞌi unqꞌa tenameꞌ viyol u Jonás, as yak kuxh ikꞌaxa tibꞌ. Pet ech koj ex, tan kꞌuxh at in sexoꞌl uvaꞌ nim valcheꞌ tiꞌ u Jonás, as yeꞌ nekꞌaxa etibꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","As abꞌimaleꞌ setaꞌn uvaꞌ ibꞌan u ixoj uvaꞌ ijlenaalike tu u tenam uvaꞌ Sabá, tan tziꞌaꞌn kat tzaakat ixoj tiꞌ ul tabꞌit itxumbꞌal te u ijlenaal uvaꞌ Salomón. As tul la ilej u qꞌiieꞌ tiꞌ ibꞌanax isuuchil unqꞌa tenameꞌ skajayil, as antu veꞌt u ixojeꞌ la uli tiꞌ ixochat ex, tan kꞌuxh at in sexoꞌl, as yeꞌ nesaꞌ etabꞌit vunyoleꞌ. As tul nim valcheꞌ tiꞌ u Salomón. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","As la val sete, tan ech etatineꞌ la ibꞌaneꞌ echeꞌ umaj uxhchil uvaꞌ kat el chꞌuꞌl umaj subꞌul skꞌatz. As kat kuxh xaan veꞌt u subꞌuleꞌ tu u tzuukin txꞌavaꞌeꞌ tiꞌ ichukat tiꞌlebꞌal. As tul yeꞌ kat ilej u tiꞌlebꞌaleꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","as ech kat tal veꞌt jeꞌ ileꞌ ste: «La qꞌaav veꞌt in tu u vatinbꞌaleꞌ uveꞌ kat elkat chꞌuꞌl in,» chaj la taleꞌ. As tul la oon veꞌt u subꞌuleꞌ, as ech veꞌt tatin u uxhchileꞌ echeꞌ umaj kabꞌal uvaꞌ amleꞌl kuxhtuꞌ, as eesamal veꞌt chꞌis stuul, as chꞌiꞌumal tiloneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","As la bꞌen teqꞌo veꞌt tzan u subꞌuleꞌ vujvaꞌt imool uvaꞌ nim talcheꞌ tiꞌ ibꞌanax u vaꞌlexheꞌ. As la ok veꞌt unqꞌa subꞌuleꞌ kꞌatz u uxhchileꞌ. As pal chit veꞌt iviꞌ la ibꞌan u uxhchileꞌ tiꞌ uvaꞌ nik ibꞌan bꞌaxa. As echat chit tuk ebꞌaneꞌ, jankꞌal ex uvaꞌ vaꞌlexh vetxumbꞌaleꞌ nebꞌaneꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","As nikattel iyolon u Jesús xoꞌl unqꞌa uxhchileꞌ tul bꞌex oonoj veꞌt vitxutx Aakeꞌ tukꞌ unqꞌa titzꞌin Aakeꞌ. As nikat isaꞌ chaꞌma iyolon tukꞌ Aak. As aꞌ kuxh atkat chaꞌma tiꞌ u kabꞌaleꞌ uveꞌ atikkat Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","As ech bꞌex tal veꞌt umaꞌl u uxhchil ileꞌ te u Jesús: —Il ak atxutx at tiꞌ kabꞌal tukꞌ unqꞌa eetzꞌin. As nisaꞌ aak iyolon see,— tiꞌk u uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","As ech tal veꞌt u Jesús ileꞌ: —Tuk val sete uvaꞌ abꞌil ech tatineꞌ sunkꞌatz echeꞌ vuntxutxeꞌ as abꞌil uvaꞌ ech tatineꞌ sunkꞌatz echeꞌ unqꞌa vitzꞌineꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","As ikꞌuch veꞌt Aak unqꞌa ichusulibꞌeꞌ taꞌn iqꞌabꞌ. As ech tal veꞌt Aak ileꞌ: —As ech exeꞌ vuntxutxeꞌ; as ech exeꞌ unqꞌa vitzꞌineꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","tan jankꞌal unqꞌa uxhchileꞌ uveꞌ ni bꞌanon kam uveꞌ ni tal u Tiixheꞌ uvaꞌ at tu almikaꞌ, as ech tatineꞌ echeꞌ vitzꞌin, as ech tatineꞌ echeꞌ vanabꞌ, as ech tatineꞌ echeꞌ untxutx,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","An chit tu u qꞌiieꞌ, el veꞌt chꞌuꞌl u Jesús tu kabꞌal. As bꞌex veꞌt Aak xonloj tziꞌ u mar. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","As aꞌ chit mamaꞌla tenameꞌ imol tibꞌ tiꞌ Aak. As ok veꞌt Aak tu umaꞌl u barco. Xonebꞌ veꞌt Aak. As kaaik veꞌt kan unqꞌa tenameꞌ tziꞌ u aꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nimal unqꞌa yoleꞌ nikat tal Aak te unqꞌa tenameꞌ. As tukꞌ kꞌuchuvatz nikat ichusunkat Aak. Ech tal Aak ileꞌ: —Bꞌex veꞌt umaꞌl u naj avoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","As tul av naj, as at unqꞌa iiaeꞌ uvaꞌ echik toon tu bꞌey. As ul unqꞌa tzꞌikineꞌ. As ijuna veꞌt txoo. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","As at unqꞌa iiaeꞌ ech toon xoꞌl unqꞌa kꞌubꞌeꞌ uvaꞌ yeꞌlkat tuul txꞌavaꞌ. As oora chit kat bꞌuuqꞌi, tan yeꞌl tuul txꞌavaꞌ at xoꞌl unqꞌa kꞌubꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","As tul kat tzꞌeꞌsan veꞌt u qꞌiieꞌ, as oora kuxh kat tzaj veꞌteꞌ, tan tiꞌ uvaꞌ yeꞌl taqꞌil kat bꞌen taꞌn unqꞌa kꞌubꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","As at unqꞌa iiaeꞌ echik toon xoꞌl chꞌiꞌx. As tul kat chꞌii unqꞌa chꞌiꞌxeꞌ, as kat isoka veꞌt unqꞌa chꞌiꞌxeꞌ u chikoeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pet ech koj unqꞌa iiaeꞌ uvaꞌ echik toon tu u bꞌaꞌnla txꞌavaꞌeꞌ, tan kat taqꞌ ivatz. As ati uvaꞌ kat aqꞌon oꞌkꞌalal (100) ivatz tiꞌ junun viꞌl; as ati uvaꞌ kat aqꞌon oxkꞌalal (60) ivatz; as ati uvaꞌ kat aqꞌon vinaj laval (30) ivatz. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","As abꞌiste ex uvaꞌ nepal tu vunyoleꞌ, as etabꞌitaj uveꞌ ni valeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","As ijetzꞌ veꞌt ok tibꞌ unqꞌa ichusulibꞌ u Jesús skꞌatz. As ech tal veꞌt chajnaj ileꞌ te Aak: —¿Kam bꞌan taꞌneꞌ, Pap, uvaꞌ tukꞌ kuxh kꞌuchuvatz nachusunkat te unqꞌa tenameꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ech tal veꞌt u Jesús ileꞌ: —As ex uvaꞌ at veꞌt ok ex xoꞌl unqꞌa tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. As sete tuk valkat isuuchil u tijleꞌm u Tiixheꞌ, as yeꞌxhibꞌil ootzin tetz. Pet ech koj unjoltu unqꞌa tenameꞌ, as yeꞌxhkam la alax isuuchil ste. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","As abꞌil uvaꞌ ni toksa taama tiꞌ inimat u yoleꞌ, kꞌuxh bꞌiil kuxh nipal stuul, as la alpu isuuchil ste. As aal la chee itxumbꞌal stiꞌ. Pet ech koj u uxhchileꞌ uvaꞌ yeꞌ ni toksa taama tiꞌ tabꞌit u yoleꞌ as tukꞌ tiꞌ inimataꞌ, as aal la sotzsal veꞌt u yoleꞌ skꞌuꞌl. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Estiꞌeꞌ uvaꞌ tukꞌ kꞌuchuvatz nunchusunkat xoꞌl unqꞌa tenameꞌ, tan kꞌuxh ni tileꞌ kam uveꞌ nunbꞌaneꞌ as kꞌuxh ni tabꞌi unqꞌa yoleꞌ uvaꞌ ni valeꞌ, as yeꞌ nipal stuul. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","As aꞌeꞌ nibꞌaneꞌ uvaꞌ itzꞌibꞌa kan u Isaías, u qꞌajsan tetz viyol u Tiixheꞌ, uvaꞌ ech ni tal ileꞌ: Kꞌuxh nimal yol la tabꞌi, as yeꞌ la pal stuul; as kꞌuxh nimal unqꞌa veeꞌ la tileꞌ, as yeꞌ la texhla, ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","tan yannal itxumbꞌal unqꞌa tenameꞌ. As eela kuxh stukꞌ uvaꞌ jupel vixikineꞌ tukꞌ vivatzeꞌ. As yeꞌ nipal tisuuchil u yoleꞌ uvaꞌ ni tabꞌi tukꞌ uvaꞌ ni tileꞌ. As yeꞌ nijalpu vitxumbꞌaleꞌ. Estiꞌeꞌ uvaꞌ yeꞌl ipaav la sotzi, tiꞌk u yoleꞌ uvaꞌ itzꞌibꞌa kan u Isaías. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pet ech koj ex, tan achvebꞌal chit ex, tan nepal stuul kam uvaꞌ netileꞌ. As nesaꞌ etabꞌit u yoleꞌ uveꞌ ni valeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","As jik chit ni val sete, tan yeꞌ saach unqꞌa qꞌajsan tetz viyol u Tiixheꞌ tukꞌ kaꞌt unqꞌa niman tetz Aakeꞌ uvaꞌ atik naꞌytzan kat saꞌon tilat unqꞌa veeꞌ netil cheel. As yeꞌ kat tila. As kꞌuxh kat isaꞌ tabꞌit unqꞌa yoleꞌ uveꞌ netabꞌi cheel, as yeꞌ kat tabꞌi. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","As etabꞌitaj isuuchil u kꞌuchuvatzeꞌ uveꞌ tuk valeꞌ tiꞌ u najeꞌ uveꞌ ni taveꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tan unqꞌa iiaeꞌ uveꞌ kat kuꞌ tu bꞌey, as aꞌ ni tokkateꞌ tiꞌ unqꞌa uxhchileꞌ uvaꞌ ni abꞌin u yoleꞌ tiꞌ u tijleꞌm u Tiixheꞌ. As yeꞌ nipal stuul, tan ni tul teesa u txꞌiꞌlanajeꞌ u yoleꞌ uveꞌ kat ok tu u taanxelal unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","As unqꞌa iiaeꞌ uveꞌ kat oon xoꞌl unqꞌa kꞌubꞌeꞌ, as aꞌ ni tokkateꞌ tiꞌ unqꞌa uxhchileꞌ uveꞌ tul ni tabꞌi u yoleꞌ, as nichiibꞌ stiꞌ. As ni tok u yoleꞌ tu u taanxelaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pet ech unqꞌa uxhchileꞌ echeꞌ u iiaeꞌ uvaꞌ yeꞌ kat palik bꞌen u taqꞌileꞌ tu u txꞌavaꞌeꞌ, tan yeꞌ kat yakꞌin u yoleꞌ tu u taanxelaleꞌ. As yeꞌxh jatvaꞌl qꞌii kat ibꞌana, tan tul kat ul unqꞌa kꞌaxkꞌoeꞌ tiꞌ u uxhchileꞌ tiꞌ uvaꞌ nimamal u yoleꞌ staꞌn, as oora kuxh kat kaꞌkabꞌin taama stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","As unqꞌa iiaeꞌ uveꞌ kat oon xoꞌl unqꞌa chꞌiꞌxeꞌ, as aꞌ ni tokkateꞌ tiꞌ unqꞌa uxhchileꞌ uveꞌ kat abꞌin u yoleꞌ. As ni xaansa unqꞌa uxhchileꞌ taama tiꞌ unqꞌa veeꞌ at vatz u txꞌavaꞌeꞌ as tukꞌ tiꞌ u txꞌiibꞌal qꞌiieꞌ uvaꞌ ni sotzsan ikꞌuꞌl unqꞌa uxhchileꞌ tiꞌ u yoleꞌ. Estiꞌeꞌ yeꞌ niyakꞌin u yoleꞌ tu u taanxelal unqꞌa uxhchileꞌ echeꞌ umaj u tzeꞌ uvaꞌ yeꞌ nivatzineꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pet ech koj unqꞌa iiaeꞌ uveꞌ ech toon tu u bꞌaꞌnla txꞌavaꞌeꞌ, tan aꞌ ni tokkateꞌ tiꞌ unqꞌa uxhchileꞌ uveꞌ ni abꞌin u yoleꞌ as ninima. As niyakꞌin veꞌt u yoleꞌ tu u taanxelaleꞌ echeꞌ unqꞌa tzeꞌeꞌ uvaꞌ nivatzineꞌ, tan ati uvaꞌ ni taqꞌ oꞌkꞌalal (100) ivatz, as ati uvaꞌ ni taqꞌ oxkꞌalal (60) ivatz, as ati uvaꞌ ni taqꞌ vinaj laval (30) ivatz tiꞌ junun viꞌl,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","As tal u Jesús umaꞌt u kꞌuchuvatz uvaꞌ ech ileꞌ: —Ech nibꞌan u tijleꞌm u Tiixheꞌ echeꞌ nibꞌan umaj naj uvaꞌ kat ichaj bꞌen ikꞌam tiꞌ tavat u bꞌaꞌnla iiaeꞌ uvaꞌ trigo tu vitxꞌavaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","As tul kat tzꞌotin veꞌteꞌ, as vat veꞌt unqꞌa kꞌameꞌ. As oon veꞌt umaꞌt u naj uvaꞌ nik ichꞌoꞌn taama tiꞌ vibꞌaal u txꞌavaꞌeꞌ. As bꞌex tava kan naj unqꞌa vaꞌlexhla iiaeꞌ xoꞌl unqꞌa trigo, uvaꞌ ech tiloneꞌ echeꞌ trigo. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tul kat bꞌuuqꞌ veꞌt unqꞌa trigo, as xuꞌmat veꞌteꞌ. As antu veꞌt u vaꞌlexhla iiaeꞌ uvaꞌ echeꞌ trigo kat bꞌuuqꞌ xoꞌl unqꞌa trigo. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","As oon veꞌt unqꞌa kꞌameꞌ xeꞌ vibꞌaal u trigo. As ech tal chajnaj ileꞌ: «Pap, bꞌaꞌnla iiaeꞌ unqꞌa iiaeꞌ uveꞌ kat bꞌex qava tu vatxꞌavaꞌeꞌ. ¿As katileꞌ qꞌi kat tzaakat veꞌt unqꞌa vaꞌlexhla chaj kꞌuacheꞌ uveꞌ echeꞌ trigo uveꞌ kat chee xoꞌl unqꞌa trigo?» tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ech tal veꞌt vibꞌaal u trigo ileꞌ te unqꞌa ikꞌameꞌ: «Aꞌ umaꞌl u uxhchileꞌ uveꞌ nichꞌoꞌn taama sviꞌ kat bꞌex bꞌanon,» tiꞌk vibꞌaal u trigo. As ech tal veꞌt unqꞌa kꞌam ileꞌ: «¿Pap, ma nasaꞌ uvaꞌ la bꞌen kutzuj u vaꞌlexhla kꞌuacheꞌ uveꞌ echeꞌ trigo uvaꞌ at xoꞌl unqꞌa trigo?» tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ech tal veꞌt vibꞌaal u trigo ileꞌ: «Yeꞌle, tan asoj la etzuj u vaꞌlexhla kꞌuacheꞌ uveꞌ echeꞌ trigo, as anteꞌ u trigoeꞌ la etzujeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pet chꞌiiojno skaabꞌil. As lanal ilej veꞌt u qꞌiieꞌ tiꞌ imakleꞌ, as aꞌn la val te unqꞌa makꞌol tetzeꞌ tiꞌ teesat chajnaj unqꞌa vaꞌlexhla kꞌuacheꞌ bꞌaxa. As la imol chajnaj. As la ikꞌal chajnaj tiꞌ tok tu xamal. As aꞌn la itzokꞌ veꞌt chajnaj unqꞌa trigoeꞌ tiꞌ ikolpeꞌ,» tiꞌk vibꞌaal u trigoeꞌ tal te unqꞌa ikꞌameꞌ,— tiꞌk u Jesúseꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","As tal veꞌt u Jesús umaꞌt u kꞌuchuvatz. As ech tal Aak ileꞌ: —Ech nibꞌan u tijleꞌm u Tiixheꞌ echeꞌ uvaꞌ kat ibꞌan u iiaeꞌ tetz u mostaza uvaꞌ bꞌex tava umaꞌl u naj tu vitxꞌavaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","As kꞌuxh tzꞌup chit u iiaeꞌ tiꞌ unjoltu unqꞌa iiaeꞌ, as tul uvaꞌ kat chꞌii veꞌteꞌ, as nim chit kat oonkat tiꞌ unjoltu unqꞌa chikoeꞌ uveꞌ at tu u peꞌeꞌ. As ni tul veꞌt unqꞌa talaj tzꞌikineꞌ tiꞌ ibꞌanat visokeꞌ viꞌ viqꞌabꞌ u tzeꞌeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","As ech tal u Jesús ileꞌ tiꞌ umaꞌt u kꞌuchuvatz: —Ech nibꞌan u tijleꞌm u Tiixheꞌ echeꞌ nibꞌan u levadura uveꞌ nipaxi tibꞌ xoꞌl oxvaꞌl paabꞌal u harina. As kat ipaxi veꞌt bꞌen tibꞌ u levadura xoꞌl viqꞌotil u paaneꞌ. As kat isipkꞌisa veꞌt skajayil,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","As jankꞌal chit unqꞌa chusbꞌaleꞌ uveꞌ nik tal Aak tiꞌ tilat u Tiixheꞌ isuuchil vitenameꞌ, as tukꞌ kuxh kꞌuchuvatz nik ichusunkat Aak. As yeꞌl umaꞌtoj yol nik tal Aak uvaꞌ jit tukꞌ kꞌuchuvatz, ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","tan aꞌeꞌ nik ibꞌan u Jesús kam uvaꞌ alel kan taꞌn umaꞌt u qꞌajsan tetz viyol u Tiixheꞌ, tul ech tal ileꞌ: Tul la yolon in, as tukꞌ kꞌuchuvatz la yolonkat in. As la val veꞌt isuuchil unqꞌa txumbꞌaleꞌ uvaꞌ yeꞌ ootzimal taꞌn unqꞌa tenameꞌ uvaꞌ kꞌujbꞌaꞌl kan tul uvaꞌ sichee u vatz txꞌavaꞌeꞌ, tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","As taqꞌ veꞌt kan u Jesús unqꞌa tenameꞌ. As ok veꞌt Aak tu u kabꞌaleꞌ. Jetzꞌen veꞌt ok unqꞌa ichusulibꞌ Aakeꞌ skꞌatz. As ech tal veꞌt chajnaj ileꞌ: —Pap, bꞌan bꞌaꞌnil. Al isuuchil u yoleꞌ sqe uveꞌ kat aal tiꞌ unqꞌa vaꞌlexhla kꞌuacheꞌ uvaꞌ xoꞌl unqꞌa trigo,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ech tal veꞌt u Jesús ileꞌ: —U najeꞌ uveꞌ ni avan u bꞌaꞌnla iiaeꞌ, as aꞌ VIKꞌAOL U NAJEꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","As u txꞌavaꞌeꞌ, as aꞌeꞌ unqꞌa tenameꞌ. As unqꞌa bꞌaꞌnla iiaeꞌ, as aꞌeꞌ unqꞌa tenameꞌ uveꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. Pet ech koj unqꞌa vaꞌlexhla kꞌuacheꞌ, tan aꞌ unqꞌa uxhchileꞌ uveꞌ echen kꞌatz u txꞌiꞌlanajeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","As u najeꞌ uvaꞌ nichꞌoꞌn taama uveꞌ kat avan kan u vaꞌlexhla kꞌuacheꞌ, as aꞌeꞌ u txꞌiꞌlanajeꞌ. Tul la maklu u trigo, as aꞌeꞌ vimotxtebꞌal u qꞌiieꞌ vatz u txꞌavaꞌeꞌ. As unqꞌa makꞌol tetz u trigo as aꞌ unqꞌa ángel. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","As echeꞌ uveꞌ nibꞌanchu te unqꞌa vaꞌlexhla kꞌuacheꞌ tan tul kat molaxi as kat oksal tu xamal tiꞌ itzꞌeꞌsaleꞌ, as echat tuk ibꞌan unqꞌa uxhchileꞌ uvaꞌ ni bꞌanon u vaꞌlexheꞌ tul la ilej imoxtel u qꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Tan la ichaj veꞌt tzan VIKꞌAOL U NAJEꞌ unqꞌa ángel tiꞌ ul teesat el unqꞌa uxhchileꞌ uveꞌ ni paavinsan vimooleꞌ as tukꞌ unqꞌa paasan tziieꞌ uvaꞌ ni bꞌanon u vaꞌlexheꞌ, uveꞌ at xoꞌl unqꞌa tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","As la sutil veꞌt bꞌen unqꞌa paasantziilla uxhchileꞌ tu u oornoeꞌ uveꞌ nitoypukat u xamaleꞌ. As tzitziꞌ la oqꞌkat veꞌteꞌ. As la ikꞌux veꞌt tibꞌ tee. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pet ech koj unqꞌa jikla aamaeꞌ uvaꞌ at jaqꞌ u tijleꞌm u Kubꞌaaleꞌ, tan achaꞌv chit veꞌt tatineꞌ la ibꞌan vatz Aak echeꞌ nibꞌan u qꞌiieꞌ tul nitxijuneꞌ. As abꞌiste ex uvaꞌ nepal tu vunyoleꞌ, as etabꞌitaj uveꞌ ni valeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","As ech nibꞌan u tijleꞌm u Tiixheꞌ echeꞌ umaj u txꞌiibꞌal qꞌii uvaꞌ mujel tu umaj u txꞌavaꞌ. Tul la ilej umaj u naj u txꞌiibꞌal qꞌiieꞌ, as la chiibꞌ veꞌt naj stiꞌ. As la imuj kan naj. As la bꞌen ikꞌayi veꞌt kan naj unqꞌa tetzeꞌ skajayil, aqꞌal uvaꞌ la bꞌen iloqꞌ naj u txꞌavaꞌeꞌ uveꞌ atkat u txꞌiibꞌal qꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","As ech la ibꞌan unqꞌa uxhchileꞌ uvaꞌ nisaꞌ tok xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ echeꞌ la ibꞌan umaj aakꞌaꞌy uveꞌ nixaaneꞌ tiꞌ ichukat unqꞌa bꞌaꞌnla chaj kueentaxheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","As tul la ilej naj umaj u bꞌaꞌnla kueentaxh uvaꞌ jeꞌnal ijaꞌmil, as la bꞌen ikꞌayi kan naj unqꞌa tetzeꞌ skajayil. As la iloqꞌ veꞌt naj u bꞌaꞌnla kueentaxheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","As ech nibꞌan u tijleꞌm u Tiixheꞌ echeꞌ nibꞌan umaj u kꞌach tetz txeyol txay. As tul uvaꞌ nisutil bꞌen u kꞌacheꞌ xeꞌ u aꞌeꞌ, as kam kuxh txayil ni tok tu u kꞌacheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","As tul ninoo veꞌt u kꞌacheꞌ, as ni teqꞌol veꞌt el tzan tziꞌ u aꞌeꞌ taꞌn unqꞌa txeyol txayeꞌ. As nixonebꞌ veꞌt chajnaj tiꞌ itxaat veꞌt unqꞌa bꞌaꞌnla txayeꞌ. As la ikol veꞌt chajnaj tu vixuꞌkeꞌ. Pet ech koj unqꞌa txayeꞌ uvaꞌ vaꞌlexh, tan la isuti veꞌt el chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Echat chit la ibꞌaneꞌ tul la ilej vimoxtel u qꞌiieꞌ, tan la ul veꞌt unqꞌa ángel tiꞌ teesat el tzan Aak unqꞌa jikla aamaeꞌ xoꞌl unqꞌa uxhchileꞌ uvaꞌ vaꞌlexh vitxumbꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","As la sutil bꞌen unqꞌa uxhchil uvaꞌ vaꞌlexh vitxumbꞌaleꞌ tu uveꞌ nitoypukat u xamaleꞌ. As tzitziꞌ la oqꞌkat veꞌteꞌ. As la ikꞌux veꞌt tibꞌ tee,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","As ichꞌoti veꞌt u Jesús te unqꞌa ichusulibꞌeꞌ: —¿Ma kat palyu ex tu unqꞌa yoleꞌ uvaꞌ kat val sete?— tiꞌk Aak. —Kano, Pap. Kat palyu oꞌ stuul,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","As ech tal veꞌt u Jesús ileꞌ: —Tuk val sete, unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as tul la pal tu u yoleꞌ tiꞌ tok unqꞌa uxhchileꞌ xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ, as ech la ibꞌaneꞌ echeꞌ nibꞌan umaj u bꞌaal kabꞌal uveꞌ kam kuxh kolel staꞌn tu vikabꞌaleꞌ. As la teqꞌo el tzan unqꞌa tetzeꞌ tiꞌ ibꞌanbꞌetaꞌ, as moj unqꞌa veeꞌ akꞌnale moj oꞌt veꞌteꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","As tul kat tzojpu veꞌt u Jesús tiꞌ talat unqꞌa kꞌuchuvatzeꞌ, as bꞌen veꞌt Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","As oon veꞌt Aak tu vitenameꞌ uveꞌ chꞌii kat Aak. As chusun veꞌt Aak tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh. As teqꞌo veꞌt taama unqꞌa uxhchileꞌ taꞌn u yoleꞌ uveꞌ nikat tal Aak. As ech tal veꞌt unqꞌa uxhchil ileꞌ svatzaj: —¿Katileꞌ qꞌi kat bꞌex teqꞌokat u najeꞌ vitxumbꞌaleꞌ? ¿As katileꞌ qꞌi bꞌex ichuskat tibꞌ naj tiꞌ ibꞌanax unqꞌa nimla bꞌaꞌnileꞌ uveꞌ nibꞌan naj? ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿As jit kol vikꞌaol u seeoleꞌ qꞌa u najeꞌ? Tan itxutx najeꞌ u Maꞌleꞌ. As titzꞌin najeꞌ u Jacobo, tukꞌ u Xhuꞌl, tukꞌ u Simón, tukꞌ u Judas. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","As ootzimaleꞌ unqꞌa tanabꞌ najeꞌ sqaꞌn. ¿Katileꞌ qꞌi tzaakat unqꞌa txumbꞌaleꞌ taꞌn naj?— tiꞌk unqꞌa uxhchileꞌ tal tiꞌ u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","As yeꞌ kat isaꞌ veꞌt unqꞌa uxhchileꞌ inimat u Jesús. As ech tal veꞌt u Jesús ileꞌ: —Katil kuxh la oksalkat iqꞌii umaꞌl u qꞌajsan tetz viyol u Tiixheꞌ. Pet ech koj tu vitenameꞌ tukꞌ tu vikabꞌaleꞌ, as echeꞌ la koj oksal iqꞌii,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","As kaꞌl kuxh unqꞌa nimla bꞌaꞌnileꞌ ibꞌan veꞌt Aak xoꞌl unqꞌa tenameꞌ tzitziꞌ, tan tiꞌ uvaꞌ yeꞌ nikat ikꞌujbꞌaꞌ unqꞌa uxhchileꞌ ikꞌuꞌl tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","As tu unqꞌa qꞌiieꞌ, as tabꞌi veꞌt u Herodes itzibꞌlal u Jesús, tan naj kꞌujlik kan sbꞌooqꞌolil tiꞌ tilat isuuchil kajvaꞌl unqꞌa tenameꞌ taꞌn u ijlenaaleꞌ tu u Roma. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","As ech tal veꞌt u Herodes ileꞌ te unqꞌa lochol tetzeꞌ: —Aꞌ u Xhuneꞌ uvaꞌ nik aqꞌon kuꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ uvaꞌ kat ulyu taama unpajte. Estiꞌeꞌ ni tolebꞌ tiꞌ ibꞌanat unqꞌa nimla bꞌaꞌnileꞌ,— tiꞌk u Herodes. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","As tal u Herodes u yoleꞌ, tan tiꞌ uvaꞌ maꞌtik talat naj itxeypu u Xhuneꞌ, as maꞌtik talat naj ikꞌalat veꞌt taꞌn kateena, as maꞌtik talat naj toksal tu u kaarsa tiꞌ inimal viyol u Herodías, uvaꞌ tixqelik u Piꞌleꞌ uvaꞌ titzꞌin u Herodes, ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","tan tiꞌ uvaꞌ ech nik tal u Xhun ileꞌ te u Herodes: —Paaveꞌ kat abꞌana tiꞌ uvaꞌ kat eeqꞌo eebꞌ tukꞌ u ixojeꞌ,— tiꞌk u Xhuneꞌ tal te u Herodes. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Estiꞌeꞌ nikat isaꞌ veꞌt u Herodes iyatzꞌat u Xhuneꞌ. Pet nikat ixoꞌv naj vatz unqꞌa tenameꞌ, tan qꞌajsan tetz viyol u Tiixheꞌ u Xhuneꞌ vatz unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","As tul kat tzꞌaj iyaabꞌ u Herodes, as kat ibꞌan veꞌt naj umaꞌl u nimla qꞌii. As ok veꞌt u tal u Herodías bꞌixoj vatz u Herodes as tukꞌ vatz unqꞌa ilonaaleꞌ. As tul achaꞌvik chit ibꞌix veꞌt ixoj uveꞌ til u Herodes. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","As taltziꞌ veꞌt u Herodes te u ixoj tukꞌ viBꞌii u Tiixheꞌ uvaꞌ la taqꞌ naj kam uvaꞌ la ijaj ixoj te naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","As aꞌ u Herodías alon te u taleꞌ tiꞌ uvaꞌ kam la ijaj ixoj te u Herodes. As ech bꞌex tal veꞌt ixoj ileꞌ: —Nunsaꞌ viviꞌ u Xhuneꞌ uvaꞌ nikat aqꞌon kuꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ. As aꞌ ni valeꞌ uvaꞌ la aaqꞌ tzan sve tu umaj u pulaato,— tiꞌk ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","As txumun veꞌt u Herodes taꞌn viyol u ixojeꞌ. Tan tiꞌ uvaꞌ maꞌtik taltziꞌt naj te u ixojeꞌ tukꞌ tiila yol vatz unqꞌa ilonaaleꞌ, as taqꞌ chit veꞌt naj kam uvaꞌ ijaj ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","As tal veꞌt u Herodes uvaꞌ la bꞌen tzokꞌpoj el viviꞌ u Xhuneꞌ tu u kaarsa. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","As eqꞌol veꞌt tzan viviꞌ u Xhuneꞌ tu umaꞌl u pulaato. As ul aqꞌaxoj te u ixojeꞌ. As bꞌex taqꞌ veꞌt ok ixoj te vitxutxeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","As ul veꞌt kaꞌl unqꞌa ichusulibꞌ u Xhuneꞌ tiꞌ imujlu vichiꞌoleꞌ. As tul maꞌt imujat chajnaj, as bꞌex tal veꞌt chajnaj te u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","As tul tabꞌi veꞌt u Jesús uvaꞌ yatzꞌpu veꞌt u Xhuneꞌ, as el veꞌt chꞌuꞌl Aak tzitziꞌ. As ok veꞌt Aak tu umaꞌl u barco tiꞌ iqꞌaxit Aak u mar tiꞌ toon tu umaꞌt u atinbꞌal uvaꞌ yeꞌlikkat tenam. Tul tabꞌi veꞌt unqꞌa uxhchileꞌ uvaꞌ maꞌt ibꞌen veꞌt Aak tu u barco, as el veꞌt chꞌuꞌl unqꞌa uxhchileꞌ tulaj unqꞌa talaj tenameꞌ. As xaoꞌm ibꞌen veꞌt unqꞌa uxhchileꞌ tiꞌ toon kꞌatz Aak jalit u mar. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","As tul oon veꞌt u Jesús jalit u mar, as til veꞌt Aak uvaꞌ mamaꞌla tenam molik veꞌt tibꞌ tiꞌ ikꞌulpu Aak. As itxum veꞌt Aak ivatz unqꞌa tenameꞌ. As ibꞌaꞌnxisa veꞌt Aak unqꞌa aachꞌoꞌmeꞌ uveꞌ atik xoꞌl unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","As tul kuꞌ veꞌt qꞌii, as jetzꞌen veꞌt ok unqꞌa ichusulibꞌ u Jesús skꞌatz. As ech tal veꞌt chajnaj ileꞌ te Aak: —Kat kuꞌy veꞌt qꞌii. As tul yeꞌl kabꞌal at tzitzaꞌ. Pet al te unqꞌa tenameꞌ uvaꞌ la bꞌen iloqꞌ ipaan tulaj unqꞌa talaj tenameꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ech tal veꞌt u Jesús ileꞌ: —Yeꞌl unqꞌa tenameꞌ la bꞌeni. Pet ex la aqꞌon ipaan,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","—As yeꞌl paan eqꞌomal sqaꞌn tiꞌ itzujbꞌel unqꞌa tenameꞌ skajayil. Pet oꞌvaꞌl kuxh paan ati tukꞌ kaꞌvaꞌt txay,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Etaqꞌtaj tzan sve,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","As tal veꞌt Aak uvaꞌ la xonebꞌ unqꞌa tenameꞌ skajayil vatz u chaqꞌaalaeꞌ. As itxey veꞌt Aak oꞌvaꞌl unqꞌa paaneꞌ tukꞌ kaꞌvaꞌt unqꞌa txayeꞌ. As kaꞌyik veꞌt jeꞌ Aak tu almikaꞌ. As taqꞌ veꞌt Aak taꞌntiixh te u Tiixheꞌ stiꞌ. As ijatx veꞌt Aak unqꞌa paaneꞌ. As taqꞌ veꞌt Aak te unqꞌa ichusulibꞌeꞌ tiꞌ uvaꞌ la ijatx veꞌt chajnaj xoꞌl unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","As tul maꞌtik itxꞌaꞌn unqꞌa tenameꞌ sbꞌaꞌn skajayil, as imol veꞌt unqꞌa ichusulibꞌ Aakeꞌ unqꞌa yaꞌl paaneꞌ. As nootel kabꞌlavat xuꞌk staꞌn. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","As kamal oꞌvaꞌl mil unqꞌa najeꞌ uveꞌ txꞌaꞌon u paaneꞌ. As jit achpu unqꞌa ixojeꞌ tukꞌ unqꞌa talaj intxaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","As tul uvaꞌ nik iqꞌiila kan u Jesús unqꞌa tenameꞌ, as tal veꞌt Aak te unqꞌa ichusulibꞌeꞌ uvaꞌ la ok veꞌt chajnaj tu u barco as la bꞌax veꞌt chajnaj vatz Aak tiꞌ iqꞌaxit u mar. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tul maꞌtik iqꞌiilat kan u Jesús unqꞌa tenameꞌ, as jeꞌ veꞌt Aak viꞌ umaꞌl u tal vitz tiꞌ inachat Tiixh. Tul tzꞌotin veꞌteꞌ, as aꞌik kuxh u Jesús atik tzitziꞌ sijunal. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Echen veꞌt u barco pokꞌoꞌchbꞌal u mar, tan nik ijojpi u mam kajiqꞌeꞌ u barco, tan aalik itzaa u kajiqꞌeꞌ vatz u barco. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tul uvaꞌ txantik kuxh isajbꞌeꞌ, as xaoꞌm tok u Jesús viꞌ u mar. As bꞌex ilej veꞌt Aak chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tul til unqꞌa ichusulibꞌ Aakeꞌ uvaꞌ nikat ixaan veꞌt Aak viꞌ u mar, as xoꞌv veꞌt chajnaj. As ech tal veꞌt chajnaj ileꞌ: —¡Umaꞌl u xoꞌval tuleꞌ!— tiꞌk chajnaj, tul sikꞌin veꞌt chajnaj taꞌn xoꞌvichil. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","As yolon veꞌt u Jesús te chajnaj. As ech tal veꞌt Aak ileꞌ: —Yeꞌ kuxh xoꞌv ex. Pet etiibꞌisataj etaama, tan ineꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ech tal u Luꞌ ileꞌ: —Pap, asoj axh u veeꞌ, as al sve uvaꞌ la bꞌen in sakꞌatz viꞌ u aꞌeꞌ,— tiꞌk u Luꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Elen chꞌuꞌl bꞌa,— tiꞌk Aak tal te u Luꞌeꞌ. Oora chit el veꞌt chꞌuꞌl u Luꞌeꞌ tu u barco. As xaan veꞌt naj viꞌ u aꞌeꞌ tiꞌ toon kꞌatz u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","As tul til veꞌt naj ipilqꞌut tibꞌ u aꞌeꞌ taꞌn u mam kajiqꞌeꞌ, as xoꞌv veꞌt naj. As jilchel ibꞌen naj xeꞌ u aꞌeꞌ taꞌn xoꞌvichil. As sikꞌin veꞌt naj: —¡Pap, loch in!— tiꞌk naj te u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","As oora chit taqꞌ veꞌt bꞌen u Jesús iqꞌabꞌ tiꞌ itxeyat naj. As teqꞌo veꞌt jeꞌ tzan Aak naj xeꞌ u aꞌeꞌ. As ech tal veꞌt Aak ileꞌ: —¡Yeꞌxh jankꞌal kꞌujlebꞌal akꞌuꞌl ati! ¿Kam uvaꞌ kat kuxh kaꞌkabꞌin akꞌuꞌl sviꞌ?— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tul jeꞌ veꞌt u Jesús tu u barco tukꞌ u Luꞌeꞌ, as yak kuxh yaꞌ veꞌt u kajiqꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","As unqꞌa ichusulibꞌ Aakeꞌ uveꞌ atik tu u barco, as toksa veꞌt chajnaj iqꞌii u Jesús. Ech tal chajnaj ileꞌ: —¡An chiteꞌ vil, Pap, tan axh chiteꞌ vil viKꞌaol u Tiixheꞌ!— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","As tul maꞌtik iqꞌaxit u Jesús u mar tukꞌ unqꞌa ichusulibꞌeꞌ, as oon veꞌt Aak tu u txꞌavaꞌeꞌ uvaꞌ Genesaret. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","As tul texhla veꞌt unqꞌa tenameꞌ u Jesús, as pax veꞌt itzibꞌlal Aak tulaj unqꞌa tenameꞌ uvaꞌ najlich u Genesaret. As teqꞌo veꞌt tzan unqꞌa tenameꞌ unqꞌa aachꞌoꞌmeꞌ vatz Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","As ijaj veꞌt unqꞌa tenameꞌ kuybꞌal te Aak uvaꞌ aal kuxh koj u toksaꞌm Aakeꞌ la ikan unqꞌa aachꞌoꞌmeꞌ uveꞌ nik taleꞌ, tan abꞌil uveꞌ nik kanon u toksaꞌm Aakeꞌ, as yak chit nik tel u chꞌoꞌmeꞌ stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","As kaꞌl unqꞌa fariseo uvaꞌ aꞌ tzaanajlikkat tu u Jerusalén tukꞌ kaꞌt unqꞌa uxhchileꞌ uvaꞌ chuselik tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as oon veꞌt chajnaj kꞌatz u Jesús. Ech tal veꞌt chajnaj ileꞌ te Aak: ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Kam qꞌi uvaꞌ yeꞌ ninima unqꞌa achusulibꞌeꞌ unqꞌa yoleꞌ uvaꞌ kꞌujlu kan taꞌn unqꞌa qꞌesla kubꞌaaleꞌ? Tan yeꞌl iqꞌabꞌ chajnaj nitxꞌaaeꞌ tul nitxꞌaꞌn chajnaj,— tiꞌk unqꞌa fariseo tukꞌ unqꞌa uxhchileꞌ uvaꞌ chuselik tibꞌ tiꞌ u tzaqꞌiteꞌ uvaꞌ tzꞌibꞌamal kan. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","As ech tal veꞌt u Jesús ileꞌ: —¿As kano ex qꞌi? ¿Kam qꞌi uvaꞌ nepaasa veꞌt tzii tiꞌ u tzaqꞌiteꞌ uvaꞌ tzꞌibꞌamal kan? As aꞌ nenima unqꞌa chusbꞌaleꞌ uvaꞌ at kan taꞌn unqꞌa qꞌesla ebꞌaaleꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","tan ech ni tal vitzaqꞌit u Tiixh ileꞌ: Xoꞌnoj vatxutxeꞌ see; as xoꞌnoj vabꞌaaleꞌ see, tiꞌke. As ech ni tal ileꞌ unpajte: Abꞌil uveꞌ la iyoqꞌ itxutx as la iyoqꞌ ibꞌaal, as techal la yatzꞌpi, tiꞌk u tzaqꞌiteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pet ech koj ex, tan aꞌ netaleꞌ uvaꞌ la uch talat umaj uxhchil te vitxutxeꞌ moj te vibꞌaaleꞌ ech ileꞌ: «Yeꞌ la uch unlochat ex, tan jankꞌal uvaꞌ la unloch ex staꞌn, as te u Tiixheꞌ kat vaqꞌlukat,» chaj u uxhchileꞌ la tal te vitxutxeꞌ moj te vibꞌaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","As aꞌ netaleꞌ uvaꞌ yeꞌ la uch ilochat veꞌt unqꞌa uxhchileꞌ vitxutxeꞌ tukꞌ vibꞌaaleꞌ. Estiꞌeꞌ ni val sete uvaꞌ nepaasa veꞌt tzii tiꞌ u tzaqꞌiteꞌ uvaꞌ tzꞌibꞌamal kan, tan aꞌ veꞌt ichusbꞌal unqꞌa qꞌesla ebꞌaaleꞌ nenima. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Tan ex kuxh kaꞌvatz, tan an chiteꞌ uveꞌ tal kan u Isaías, u qꞌajsan tetz viyol u Tiixheꞌ, tul ech tal ileꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Tul ni toksa unqꞌa tenameꞌ unqꞌii, as itziꞌ kuxh unqꞌa tenameꞌ ni alon. Pet ech koj u taanxelal unqꞌa tenameꞌ, tan yeꞌ ni toksa taama sviꞌ tiꞌ inimat in. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","As kamchaj la itxaꞌki tul uvaꞌ la inach in unqꞌa tenameꞌ, tan tul nichusuneꞌ, as aꞌ kuxh unqꞌa chusbꞌaleꞌ nichuseꞌ uveꞌ at kan taꞌn unqꞌa qꞌesla ibꞌaaleꞌ, tiꞌk u Tiixheꞌ tal te u Isaías,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","As imolo veꞌt tzan u Jesús unqꞌa tenameꞌ skꞌatz. As ech tal veꞌt Aak ileꞌ: —Etabꞌitaj vunyoleꞌ. As palojtaj ex stuul. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tan kam u veeꞌ ni techbꞌu umaj uxhchil, as jiteꞌ la paavinsan vatz u Tiixheꞌ. Pet aꞌ unqꞌa yoleꞌ uveꞌ ni tel chꞌuꞌl titziꞌ, as aꞌeꞌ nipaavinsan vatz Aak,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","As jetzꞌen veꞌt ok unqꞌa ichusulibꞌ Aakeꞌ skꞌatz. As ech tal veꞌt chajnaj ileꞌ: —¿Ma at sakꞌuꞌl, Pap, uvaꞌ kat chꞌoꞌn te unqꞌa fariseo tiꞌ uvaꞌ kat aala?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ech tal veꞌt u Jesús ileꞌ: —Tan jankꞌal unqꞌa chusbꞌaleꞌ uvaꞌ jit u Kubꞌaal Tiixheꞌ alol tetz, as ech la ibꞌaneꞌ echeꞌ umaj u chiko uvaꞌ la tzujpik el tukꞌ u taqꞌileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","As la val sete, eteesataj etibꞌ kꞌatz chajnaj, tan ech chajnajeꞌ echeꞌ umaj u tzot uvaꞌ la chꞌijin umaꞌt u tzot, tan asoj la ichꞌiji u tzoteꞌ umaꞌt u tzot, as eela ikuꞌeꞌ skaabꞌil tu u juleꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","As ech tal veꞌt u Luꞌ ileꞌ: —Bꞌan bꞌaꞌnil. As al isuuchil u kꞌuchuvatzeꞌ sqe uveꞌ kat aala,— tiꞌk u Luꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ech tal u Jesús ileꞌ: —¿As mitaꞌn kuxh ex bꞌa nepal tu u yoleꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿As ma yeꞌ nepal stuul? Tan kam uvaꞌ la techbꞌu umaj uxhchil, as yaklu pal kuxheꞌ tu tuul u uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pet ech koj unqꞌa yoleꞌ uveꞌ ni tel chꞌuꞌl titziꞌ umaj uxhchil, tan tu u taanxelaleꞌ ni telkat chꞌuꞌl. As aꞌeꞌ ni paavinsan ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","tan tu u taanxelal unqꞌa uxhchileꞌ ni telkat chꞌuꞌl unqꞌa vaꞌlexhla chaj txumbꞌaleꞌ echeꞌ unqꞌa yatzꞌol aama, unqꞌa maaol tixqel imool as maaol itzumel imool, as echeꞌ unqꞌa najeꞌ uvaꞌ yeꞌl tixqel tisuuchil as moj unqꞌa ixojeꞌ uvaꞌ yeꞌl itzumel tisuuchil, as tukꞌ unqꞌa uxhchileꞌ uveꞌ ni telqꞌeꞌ, as tukꞌ unqꞌa chulin yoleꞌ, as tukꞌ unqꞌa chukul chꞌaꞌoeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","As aꞌ unqꞌa txumbꞌaleꞌ uvaꞌ ni paavinsan unqꞌa uxhchileꞌ. Pet ech koj uveꞌ yeꞌ la etxꞌaa veqꞌabꞌeꞌ tul la txꞌaꞌn ex, as jiteꞌ la paavinsan ex,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","As el veꞌt chꞌuꞌl u Jesús tu u Galilea. As oon veꞌt Aak najlich u Tiro tukꞌ u Sidón. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","As umaꞌl u ixoj uvaꞌ aa Canán, as ul ikꞌul veꞌt ixoj u Jesús, tan aꞌ jejlikkat ixoj tzitziꞌ. As ech tal ixoj ileꞌ tul taqꞌ jeꞌ ixoj tuul iviꞌ: —Txum unvatz, Pap tiaal David, tan nimxinajlu chit vas valeꞌ taꞌn umaꞌl u subꞌul,— tiꞌk ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pet jit ikꞌulbꞌe u Jesús ixoj. As jetzꞌen veꞌt ok unqꞌa ichusulibꞌeꞌ Aakeꞌ skꞌatz. As ijaj veꞌt chajnaj kuybꞌal te Aak: —Pap, al te u ixojeꞌ uvaꞌ la bꞌen ixoj, tan vaꞌl kuxh isikꞌin ixoj tiꞌ kuqul,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ech tal veꞌt u Jesús ileꞌ: —Aꞌ chajelkat in tiꞌ ilochax unqꞌa tiaal Israel, tan ech tatineꞌ echeꞌ unjoloj kaneeroꞌ uveꞌ tzꞌejxinajle,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","As jetzꞌen veꞌt ok ixoj kꞌatz u Jesús. As kuꞌ veꞌt ixoj qaaloj vatz Aak. Ech tal veꞌt ixoj ileꞌ: —¡Bꞌan bꞌaꞌnil sve, Pap! ¡Loch in!— tiꞌk ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","—Yeꞌ la ibꞌaneꞌ uvaꞌ la qaqꞌ vitxꞌix unqꞌa talaj intxaꞌeꞌ te unqꞌa talaj txꞌiꞌeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","—Kano, Pap. Pet antu unqꞌa talaj txꞌiꞌeꞌ ni echbꞌun unqꞌa vuy txꞌixeꞌ uveꞌ ni chajpik kuꞌ jaqꞌ vimeexha u uxhchileꞌ uvaꞌ etzin tetz unqꞌa talaj txꞌiꞌeꞌ,— tiꞌk ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","As ech tal u Jesús ileꞌ: —Ixoj, nim chiteꞌ u kꞌujlebꞌal akꞌuꞌleꞌ. As estiꞌeꞌ la ibꞌaneꞌ kam uveꞌ ni tal aama,— tiꞌk u Jesús. As tul kuxh tal Aak u yoleꞌ, as yak kuxh bꞌaꞌnx veꞌt u tal ixojeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","As qꞌaav veꞌt u Jesús unpajte tiꞌ ibꞌen kꞌatz u mar uveꞌ Galilea. As jeꞌ veꞌt Aak viꞌ umaꞌl u vitz. As tul xonlik veꞌt Aak tzitziꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","as imol veꞌt ok tibꞌ u mamaꞌla tenameꞌ kꞌatz Aak uvaꞌ eqꞌomal unqꞌa koꞌxeꞌ staꞌn tukꞌ unqꞌa tzoteꞌ tukꞌ unqꞌa uxhchileꞌ uvaꞌ koyix iqꞌabꞌ tukꞌ unqꞌa memeꞌ as tukꞌ unjoltu aachꞌoꞌm. As kat ibꞌaꞌnxisa veꞌt Aak skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","As teqꞌo veꞌt taama unqꞌa tenameꞌ tul til unqꞌa tenameꞌ iyolon unqꞌa memeꞌ. As toksa veꞌt unqꞌa tenameꞌ iqꞌii u Tiixheꞌ, tan bꞌaꞌnik veꞌt unqꞌa uxhchileꞌ uveꞌ koyixik iqꞌabꞌ. As nik ixaan veꞌt unqꞌa koꞌxeꞌ. As nik tilon veꞌt unqꞌa tzoteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","As imolo veꞌt u Jesús unqꞌa ichusulibꞌeꞌ. As ech tal veꞌt Aak ileꞌ: —Nuntxum ivatz unqꞌa tenameꞌ, tan kat ibꞌanlu veꞌt oxvaꞌl qꞌii scheel uvaꞌ xekel unqꞌa tenameꞌ sviꞌ. As yeꞌxhkam chit unbꞌooj ati uvaꞌ la techbꞌu. As yeꞌ nunsaꞌ uvaꞌ la bꞌen unqꞌa tenameꞌ tikabꞌal tul yeꞌxnaj txꞌaꞌni, tan la bꞌujleꞌ tu bꞌey,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ech tal unqꞌa ichusulibꞌ Aak ileꞌ: —¿Katil la bꞌen qeqꞌokat mamaꞌla paan tzitzaꞌ tu u tzuukin txꞌavaꞌeꞌ tiꞌ itzujbꞌel unqꞌa tenameꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","As ech tal veꞌt u Jesús ileꞌ: —¿Jankꞌoj paan qꞌi ati?— tiꞌk Aak. —Vujvaꞌl kuxh paan ati tukꞌ kaꞌt unqꞌa talaj txay,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","As tal veꞌt Aak ixonebꞌ unqꞌa tenameꞌ tu txꞌavaꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","As itxey veꞌt Aak vujvaꞌl u paaneꞌ tukꞌ kaꞌt unqꞌa talaj txayeꞌ. As taqꞌ veꞌt Aak taꞌntiixh te u Tiixheꞌ stiꞌ. As ijatx veꞌt Aak. As taqꞌ veꞌt Aak te unqꞌa ichusulibꞌeꞌ. As ijatx veꞌt chajnaj xoꞌl unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","As txꞌaꞌn veꞌt unqꞌa tenameꞌ skajayil sbꞌaꞌn. As imol veꞌt unqꞌa ichusulibꞌ Aakeꞌ unqꞌa yaꞌl paaneꞌ. As nootel vujvaꞌt xuꞌk staꞌn. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","As kajvaꞌl mil unqꞌa najeꞌ txꞌaꞌni. As yeꞌ kat achpu unqꞌa ixojeꞌ tukꞌ unqꞌa talaj intxaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","As tul maꞌtik ibꞌen veꞌt u mamaꞌla tenameꞌ, as ok veꞌt u Jesús tu u barco unpajte. As echik toon veꞌt Aak najlich u tal tenam uvaꞌ Magdala. ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","As oon kaꞌl unqꞌa fariseo tukꞌ kaꞌt unqꞌa saduceo kꞌatz u Jesús tiꞌ ijajataꞌ uvaꞌ la ikꞌuch Aak umaj u kꞌuchbꞌal tetz u tijleꞌmeꞌ, as kꞌuchbꞌal tetzeꞌ asoj aꞌ tzaanajkat Aak tu almikaꞌ. As nik kuxh ichuk chajnaj txumbꞌal tiꞌ uvaꞌ la icheesa chajnaj ipaav Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ech tal veꞌt u Jesús ileꞌ: —As tul nikuꞌ qꞌii as tul kat etila uvaꞌ kajux veꞌt u almikaꞌeꞌ, as: «Saqꞌi la ibꞌan sqꞌejal,» chꞌex netaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Asoj netileꞌ uvaꞌ kajux veꞌt u almikaꞌeꞌ tul nisajbꞌeꞌ, as: «Mam jabꞌal tul cheel, tan at suutzꞌ vatz u almikaꞌeꞌ,» chꞌex netaleꞌ. ¡Ex kuxh kaꞌvatz tukꞌ vetxumbꞌaleꞌ! Tan nepal stuul kam uveꞌ tuk uchoj vatz u almikaꞌeꞌ. ¿As kam qꞌi uveꞌ yeꞌ nepal stuul tiꞌ unqꞌa kꞌuchbꞌal tetzeꞌ uveꞌ ni tuch sexoꞌl tu unqꞌa qꞌiieꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","¡Ech veꞌt vetxumbꞌaleꞌ echeꞌ unqꞌa uxhchileꞌ uvaꞌ vaꞌlexh vitxumbꞌaleꞌ! ¡As ech veꞌt exeꞌ echeꞌ umaj naj uvaꞌ nichuk tixoj! As kꞌuxh nejaj umaj kꞌuchbꞌal tetz u vijleꞌmeꞌ, as echeꞌ la koj kꞌuchpu sete. Pet aꞌ kuxh veꞌt la kꞌuchpu sete echeꞌ uvaꞌ kat ibꞌan u Jonás, u qꞌajsan tetz viyol u Tiixheꞌ,— tiꞌk u Jesús. As taqꞌ veꞌt kan Aak chajnaj. As bꞌen veꞌt Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","As tul pal u Jesús tukꞌ unqꞌa ichusulibꞌeꞌ jalit u mar, as jit inach chajnaj teqꞌot ipaan. ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","As ech tal veꞌt u Jesús ileꞌ: —Tuk val sete, atoj enachbꞌal vatz vilevadura unqꞌa fariseo tukꞌ unqꞌa saduceo,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","As tal veꞌt jeꞌ chajnaj ste uvaꞌ: —Kamal tiꞌ uveꞌ yeꞌ kat qeqꞌo tzan kupaan, as estiꞌeꞌ ni tal Aak u yoleꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","As ootzimalik taꞌn u Jesús uvaꞌ kam nikat titzꞌa chajnaj. As ech tal veꞌt Aak ileꞌ: —Yeꞌxh jankꞌal u kꞌujlebꞌal ekꞌuꞌleꞌ ati. ¿As kam qꞌi uvaꞌ netal jeꞌ sete uvaꞌ: «Yeꞌl kupaan ati,» chꞌex netaleꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ma yeꞌ nepal bꞌa tu uveꞌ kat unbꞌana? ¿As ma yeꞌ netulsa bꞌa sekꞌuꞌl uvaꞌ oꞌvaꞌl kuxh paan as kat noo oꞌvaꞌl mil unqꞌa tenameꞌ staꞌn as jatvaꞌt xuꞌk unqꞌa yaꞌl paaneꞌ qꞌi kat emola? ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿As moj yeꞌ netulsa sekꞌuꞌl uvaꞌ vujvaꞌl u paaneꞌ kat unjatx xoꞌl kajvaꞌl mil unqꞌa tenameꞌ as jatvaꞌttel xuꞌk u yaꞌl paaneꞌ qꞌi kat emola? ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Kam qꞌi uvaꞌ yeꞌ nepal tu vunyoleꞌ? Tan jit u paaneꞌ ni val sete. Pet aꞌeꞌ ni val sete uvaꞌ: «Atoj enachbꞌal vatz vilevadura unqꞌa fariseo tukꞌ unqꞌa saduceo,» chꞌin sete,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","As tul tal Aak isuuchil u yoleꞌ, as aꞌn pal veꞌt chajnaj stuul uvaꞌ jit u levadura uveꞌ nibꞌen xoꞌl u paaneꞌ uveꞌ nik tal Aak. Pet aꞌ vitxumbꞌal unqꞌa fariseo tukꞌ unqꞌa saduceo uveꞌ nikat tal Aak kam uveꞌ ibꞌan chajnaj, tul uvaꞌ nik ichusun chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","As oon veꞌt u Jesús najlich u tenam u Cesarea, uvaꞌ kat ikꞌujbꞌaꞌ kan u Piꞌleꞌ uvaꞌ kꞌujlik kan taꞌn u ijlenaal tu u Roma. As ech tal veꞌt u Jesús ileꞌ te unqꞌa ichusulibꞌeꞌ: —¿Kam u tijleꞌmeꞌ VIKꞌAOL U NAJEꞌ uveꞌ ni tal unqꞌa tenameꞌ?— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ech tal veꞌt unqꞌa ichusulibꞌ Aak ileꞌ: —At uxhchil ni alon uvaꞌ axh u Xhuneꞌ uveꞌ nik aqꞌon kuꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ; as at kaꞌl uxhchil ni alon uvaꞌ axh u Elías; as at kaꞌt uxhchil ni alon uvaꞌ axh u Jeremías as moj umaꞌtoj u qꞌajsan tetz viyol u Tiixheꞌ uvaꞌ kat ul taama unpajte,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","As: —¿Kano ex qꞌi? ¿Kam vijleꞌm uveꞌ netaleꞌ?— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","As ech tal veꞌt u Luꞌ ileꞌ uvaꞌ Simón: —Axheꞌ taꞌ u Cristo, viKꞌaol u islich Tiixheꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ech tal veꞌt u Jesús ileꞌ te u Luꞌeꞌ: —Achvebꞌal chit axh Simón, ikꞌaol u Jonás, tan jit kuxh umaj vatz txꞌavaꞌilla aama kat alon see. Pet aꞌ vunBꞌaaleꞌ uvaꞌ echen tu almikaꞌ kat kꞌuchun visuuchil u yoleꞌ see. ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","As tuk val see, Simón, uvaꞌ axh Luꞌ unpajte. As viꞌ u sivaneꞌ tuk unkꞌujbꞌaꞌkat kan vuntenameꞌ uvaꞌ molomal svaꞌn. As u txꞌiꞌlanajeꞌ tukꞌ unqꞌa imooleꞌ uvaꞌ iqꞌesal unqꞌa paasan tziieꞌ uvaꞌ echen tu u kꞌaxkꞌola atinbꞌaleꞌ, as yeꞌ la olebꞌ tiꞌ isotzsal u tenameꞌ uvaꞌ molomal svaꞌn. ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","As tuk vaqꞌ veꞌt u eejleꞌmeꞌ tiꞌ uvaꞌ axh la ilon isuuchil u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. As kam uvaꞌ la aal ibꞌancheꞌ vatz u txꞌavaꞌeꞌ, as aꞌeꞌ la bꞌanax tu almikaꞌ; as kam uvaꞌ la aaleꞌ uvaꞌ yeꞌ la bꞌanchu vatz u txꞌavaꞌeꞌ, as aꞌeꞌ yeꞌ la bꞌanchu tu almikaꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","As tal veꞌt Aak te chajnaj uvaꞌ yeꞌxhebꞌil la tal chajnaj ste uvaꞌ Aak u Cristo. ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","As tu u qꞌiieꞌ, as xeꞌt veꞌt u Jesús tiꞌ talat isuuchil te unqꞌa ichusulibꞌeꞌ uvaꞌ la bꞌen Aak tu u Jerusalén. As techal chit la ipalebꞌe Aak unqꞌa kꞌaxkꞌoeꞌ taꞌn unqꞌa bꞌaal tenameꞌ, tukꞌ taꞌn unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh, as tukꞌ unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ. As la yatzꞌpi. As la ul taama Aak titoxvu qꞌii. ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","As teqꞌo veꞌt el u Luꞌeꞌ u Jesús sijunal. As imaj veꞌt u Luꞌeꞌ ivatz Aak tiꞌ uvaꞌ yeꞌ la tal Aak u yoleꞌ. Ech tal veꞌt naj ileꞌ: —¡Tiixh la kolon axh! ¡Aꞌ chiteꞌ yeꞌ la uch ibꞌanat uveꞌ naaleꞌ!— tiꞌk u Luꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","As isuchqꞌi veꞌt tibꞌ Aak. As tal veꞌt Aak te u Luꞌeꞌ: —¡Jetzꞌen el sunvatz, Luꞌ! Tan aꞌ vitxumbꞌal u Satanás nooksa taviꞌ, tan yeꞌl uvaꞌ aꞌ koj u tetz u Tiixheꞌ atoꞌk taviꞌ. Pet aꞌ vitxumbꞌal unqꞌa uxhchileꞌ atoꞌk taviꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","As ech tal veꞌt Aak ileꞌ te unqꞌa ichusulibꞌeꞌ: —Abꞌiste ex uvaꞌ la esaꞌ etoksat etibꞌ sunkꞌatz, as jit vetxumbꞌaleꞌ la etoksa. Pet aꞌ uvaꞌ la ebꞌaneꞌ kam uvaꞌ nunbꞌaneꞌ, kꞌuxh la epalebꞌe kꞌaxkꞌo as moj la kam ex sviꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","tan abꞌil uveꞌ aꞌ kuxh vitiichajileꞌ ni titzꞌa vatz u txꞌavaꞌeꞌ, as yeꞌl itiichajil ati kꞌatz u Tiixheꞌ. Pet abꞌil uvaꞌ la taqꞌ vitiichajileꞌ sviꞌ, as aꞌeꞌ uveꞌ at itiichajil kꞌatz Aak la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿As kam ibꞌaꞌnil qꞌi tiꞌ umaj uxhchil uvaꞌ la itxꞌak u vatz txꞌavaꞌeꞌ skajayil, as tul yeꞌl itiichajil ati kꞌatz u Tiixheꞌ? Tan yeꞌl umaj kam la uch taqꞌat u uxhchileꞌ tiꞌ uvaꞌ at vitiichajileꞌ kꞌatz Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tan la kuꞌ chꞌuꞌl VIKꞌAOL U NAJEꞌ tu almikaꞌ tukꞌ unqꞌa ángel, as la litzꞌloꞌlan veꞌt u vulebꞌaleꞌ eela kuxh stukꞌ uvaꞌ aꞌ vunBꞌaaleꞌ la ilpi. As la ul vaqꞌ veꞌt itxꞌajaꞌm unqꞌa uxhchileꞌ sijununil tiꞌ uveꞌ kat ibꞌana. ");
INSERT INTO ixlNNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","As jik chit tuk val sete, tan at jolol ex uvaꞌ at ex tzitzaꞌ uvaꞌ yeꞌxnaj kam ex tul la ilej veꞌt u qꞌiieꞌ. As la etil veꞌt tul VIKꞌAOL U NAJEꞌ tukꞌ u tijleꞌmeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Vaajil qꞌii stuul, as teqꞌo veꞌt u Jesús u Luꞌeꞌ stiꞌ, tukꞌ u Jacob, as tukꞌ u titzꞌineꞌ uvaꞌ Xhun. As bꞌen veꞌt Aak viꞌ umaꞌl u vitz uvaꞌ nim chit at jeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","As jalpu veꞌt ikaꞌy Aak vatz chajnaj. Vaꞌlik chit ilitzꞌloꞌlan veꞌt ivatz Aak echeꞌ nibꞌan u qꞌiieꞌ. As vaꞌlik chit ipolal veꞌt u toksaꞌm Aakeꞌ echeꞌ u sajeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","As chee veꞌt u Moisés tukꞌ u Elías vatz u Jesús tukꞌ chajnaj. As yolon veꞌt tukꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","As ech tal veꞌt u Luꞌ ileꞌ te u Jesús: —Kubꞌaal, bꞌaꞌneꞌ uvaꞌ la atin veꞌt oꞌ tzitzaꞌ. Asoj la asaꞌ, la kubꞌan oxvoꞌj tal pach: Umaꞌl eetz; umaꞌt tetz u Moisés; as umaꞌt tetz u Elías,— tiꞌk u Luꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","As antelik kuxh iyolon u Luꞌeꞌ tul chee veꞌt umaꞌl u suutzꞌ uvaꞌ vaꞌlik chit ipolal. As atin veꞌt tiibꞌa u Jesús tukꞌ chajnaj. As tabꞌi veꞌt chajnaj umaꞌl u tuul viꞌ tu u suutzꞌeꞌ uvaꞌ ech ni tal ileꞌ: —¡Aꞌ vunKꞌaoleꞌ u vaaꞌ! ¡As xoꞌn chit sve! ¡As vaꞌl ichiibꞌ veꞌt vaama stiꞌ! ¡As aꞌeꞌ la enima!— tiꞌk u tuul viꞌ tu u suutzꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tul uvaꞌ tabꞌi veꞌt unqꞌa ichusulibꞌ u Jesús u yoleꞌ, as yak kuxh xoꞌv veꞌt chajnaj. As kuꞌ veꞌt chajnaj qaaloj. As taqꞌ veꞌt kuꞌ chajnaj ivatz tu txꞌavaꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","As jetzꞌen veꞌt ok u Jesús kꞌatz chajnaj. Ikan veꞌt ok Aak chajnaj. As ech tal Aak ileꞌ: —Txakpojtaj ex. Yeꞌ kuxh xoꞌv ex,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","As tul sajin veꞌt chajnaj, as yeꞌxhebꞌil atik veꞌt kꞌatz Aak. Pet Aak kuxh veꞌt atik sijunal. ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","As tul kuꞌ chꞌuꞌl u Jesús viꞌ u vitzeꞌ tukꞌ chajnaj, as ech tal veꞌt Aak ileꞌ te chajnaj: —Yeꞌxh katil la etalkat kam uvaꞌ kat kꞌuchpu sete. Pet tul la kam VIKꞌAOL U NAJEꞌ as la ul taama unpajte, as aꞌn la etal veꞌteꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","As ech tal veꞌt unqꞌa ichusulibꞌ Aak ileꞌ: —¿Kam qꞌi uveꞌ ni tal unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ tan uvaꞌ bꞌaxel la ul u Elías?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ech tal veꞌt u Jesús ileꞌ: —An chiteꞌ uveꞌ ni tal chajnaj, tan tzꞌibꞌamal kan uvaꞌ bꞌaxel la ul u Elías tiꞌ tul ibꞌanat tuch unqꞌa tenameꞌ tiꞌ u vulebꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pet tuk val sete, tan ulyeꞌ u Elías. As yeꞌ kat exhlal u tijleꞌmeꞌ. As kat ibꞌan unqꞌa uxhchileꞌ ste kam uvaꞌ kat tal taama unqꞌa uxhchileꞌ stiꞌ. Echat chit tuk ulbꞌeloj VIKꞌAOL U NAJEꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","As pal veꞌt chajnaj tu viyol u Jesús uvaꞌ aꞌ u Xhuneꞌ nikat tal Aak, uvaꞌ nikat aqꞌon kuꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","As tul oon veꞌt chajnaj kꞌatz unqꞌa mamaꞌla tenameꞌ, as jetzꞌen veꞌt ok umaꞌl u naj kꞌatz u Jesús. Kuꞌ naj qaaloj vatz Aak. As ech tal naj ileꞌ te Aak: ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Pap, txum ivatz umaꞌl vas unkꞌaol, tan atoꞌk umaꞌl u chꞌoꞌm skꞌatz. As kam kuxh nibꞌan taꞌn u chꞌoꞌmeꞌ. As jatpajux kuxh bꞌen naj tu xamal as tukꞌ tu aꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","As kat veqꞌo tzan vatz unqꞌa achusulibꞌeꞌ. As yeꞌ kat olebꞌ chajnaj tiꞌ ibꞌaꞌnxisaleꞌ,— tiꞌk u najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","As ech tal veꞌt u Jesús ileꞌ: —¡Ex chit bꞌa yeꞌ nekꞌujbꞌaꞌ ekꞌuꞌl sviꞌ! ¡As vaꞌlen kuxh vetxumbꞌaleꞌ! ¿Ma tuk kuxh atinoj in sexoꞌl uveꞌ netitzꞌa? ¿As la kuxh kol txꞌebꞌon veꞌt in qꞌa setiꞌ tiꞌ uvaꞌ la ekꞌujbꞌaꞌ ekꞌuꞌl sviꞌ? As eteqꞌotaj tzan u xaakeꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","As iyaa veꞌt u Jesús u subꞌuleꞌ uveꞌ atik ok kꞌatz u xaakeꞌ. As el veꞌt u subꞌuleꞌ tiꞌ naj. As yak kuxh bꞌaꞌnx veꞌt naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","As tul uvaꞌ aꞌik kuxh veꞌt u Jesús tukꞌ unqꞌa ichusulibꞌeꞌ, as ech tal veꞌt chajnaj ileꞌ te Aak: —¿Kam qꞌi uveꞌ yeꞌ kat olebꞌ oꞌ tiꞌ tel u subꞌuleꞌ kꞌatz u xaakeꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ech tal veꞌt Aak ileꞌ: —Yeꞌ kat olebꞌ ex tiꞌ tel u subꞌuleꞌ, tan tiꞌ uvaꞌ unbꞌiil kuxh u kꞌujlebꞌal ekꞌuꞌl ati. As tuk val sete, tan ech koj u kꞌujlebꞌal ekꞌuꞌleꞌ echeꞌ umaj iia uvaꞌ tetz mostaza uvaꞌ tzꞌup chittuꞌ, as la etaleꞌ te u vitzeꞌ uvaꞌ: «Qꞌaxen tu umaꞌt u atinbꞌaleꞌ,» chaj ex. As la chit ibꞌaneꞌ kam uvaꞌ la etaleꞌ, tan yeꞌle uvaꞌ yeꞌ koj la uch ebꞌanataꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Unqꞌa subꞌuleꞌ uvaꞌ echeꞌ u veeꞌ, tan tukꞌ kuxh nacho Tiixh as tukꞌ ikuypu vaꞌy vatz u Tiixheꞌ la elkat,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","As tul yeꞌxnik el chꞌuꞌl u Jesús tu u Galilea tukꞌ unqꞌa ichusulibꞌeꞌ, as ech tal Aak ileꞌ: —Ineꞌ uvaꞌ in VIKꞌAOL U NAJEꞌ, as la oksal ok in tiqꞌabꞌ unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","As la yatzꞌpu veꞌt in. As la ul vaama titoxvu qꞌii,— tiꞌk Aak. As txumun veꞌt chajnaj taꞌn viyol Aakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","As tul oon veꞌt u Jesús tu u Capernaúm tukꞌ unqꞌa ichusulibꞌeꞌ, as jetzꞌen veꞌt ok kaꞌl unqꞌa molol tetz puaj kꞌatz u Luꞌeꞌ, tan nik imolpu puaj tiꞌ ibꞌanchu tuch u tostiixheꞌ. Ech tal chajnaj ileꞌ te u Luꞌeꞌ: —¿Ma ni taqꞌ vechusuleꞌ ikutx?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Kano, ni taqꞌ Aakeꞌ,— tiꞌk u Luꞌeꞌ. As tul ok veꞌt u Luꞌeꞌ tu kabꞌal uvaꞌ atikkat u Jesús, as bꞌaxel kat yolon veꞌt Aak vatz u Luꞌeꞌ. Ech tal veꞌt Aak ileꞌ: —¿Kam ni tal axh, Simón? ¿Abꞌil nijajpu u puajeꞌ ste taꞌn unqꞌa ijlenaaleꞌ? ¿Ma te unqꞌa aatenameꞌ? ¿Pet moj te unqꞌa uxhchileꞌ uvaꞌ echen tu umaꞌt u tenam?— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Aꞌ nijajpukat u puajeꞌ te unqꞌa uxhchileꞌ uvaꞌ echen tu umaꞌt u tenam,— tiꞌk u Luꞌeꞌ. As ech tal veꞌt u Jesús ileꞌ: —An chiteꞌ uveꞌ naaleꞌ, tan yeꞌxhkam nijajax te unqꞌa aatenameꞌ. As la uchi uvaꞌ yeꞌl kukutx la qaqꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pet tiꞌ uvaꞌ yeꞌ la yan itxumbꞌal unqꞌa uxhchileꞌ sqiꞌ, as kuxh tziꞌ u mar. Aqꞌ bꞌen u txeybꞌal txayeꞌ xeꞌ u aꞌeꞌ. As abꞌiste u txayeꞌ la jeꞌ chꞌuꞌl bꞌaxa as lajaj vitziꞌ txooeꞌ. As la alej umaꞌl u puaj titziꞌ txoo. As la ul achoo u eetzeꞌ tukꞌ u vetzeꞌ, jankꞌal uvaꞌ nijaj chajnaj te unqꞌa uxhchileꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","As an kuxh tu u ooraeꞌ, as jetzꞌen veꞌt ok unqꞌa ichusulibꞌ Aakeꞌ skꞌatz. As ech tal chajnaj ileꞌ te Aak: —¿Pap, abꞌiste oꞌ nim qalcheꞌ tiꞌ u kumooleꞌ la ibꞌaneꞌ tul la ilej u qꞌiieꞌ uvaꞌ la ok veꞌt u tenameꞌ jaqꞌ u tijleꞌm u Tiixheꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","As imolo veꞌt tzan u Jesús umaꞌl u tal xaak. As itxakbꞌaꞌ veꞌt Aak naj xoꞌl chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","As ech tal veꞌt Aak ileꞌ: —Jik chit tuk val sete, tan asoj yeꞌ la ebꞌan vetxumbꞌaleꞌ echeꞌ itxumbꞌal unqꞌa talaj intxaꞌeꞌ, as yeꞌl etokebꞌal xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ uvaꞌ ni til Aak isuuchil, ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","tan abꞌil uvaꞌ nisaꞌ uvaꞌ nim talcheꞌ la ibꞌaneꞌ xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ, as aal bꞌaꞌneꞌ uvaꞌ ech vitxumbꞌaleꞌ echeꞌ vitxumbꞌal u tal xaakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","As abꞌil uvaꞌ tukꞌ vunbꞌiieꞌ la ibꞌankat umaj bꞌaꞌnil te umaj talaj intxaꞌ echeꞌ u tal xaak ilaꞌ, as sveeꞌ la ibꞌankat. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Pet abꞌil la kaꞌkabꞌinsan taama umaj u niman vetzeꞌ uvaꞌ yeꞌ yakꞌinoj vitxumbꞌaleꞌ tiꞌ vunyoleꞌ, as aal bꞌaꞌneꞌ uvaꞌ la kꞌalpik veꞌt ok umaj u nimla kaꞌ tiqul u uxhchileꞌ. As la sutil veꞌt bꞌen xeꞌ u mar. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","As ech ni valkateꞌ sete, tan techal chiteꞌ la ul unqꞌa kꞌaxkꞌoeꞌ. As txumlebꞌal ivatz unqꞌa tenameꞌ uvaꞌ la kaꞌkabꞌin taama taꞌn unqꞌa kꞌaxkꞌoeꞌ uvaꞌ la ipalebꞌe. ¡As oyebꞌ chit ivatz u uxhchileꞌ uvaꞌ la kaꞌkabꞌinsan taama umaj u niman vetzeꞌ! ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","As la val sete, tan asoj la paavin ex taꞌn veqꞌabꞌeꞌ moj taꞌn vetojeꞌ, as eyaꞌsataj epaavineꞌ eela kuxh stukꞌ uvaꞌ kat etzokꞌlu veꞌt el veqꞌabꞌeꞌ tukꞌ vetojeꞌ, tan aal bꞌaꞌneꞌ uvaꞌ ech exeꞌ echeꞌ umaj kuchꞌ as moj echeꞌ umaj koꞌx tul la ok ex tu vetiichajileꞌ uveꞌ yeꞌl iyaꞌtebꞌal, as tiꞌ uvaꞌ kꞌuxh at veqꞌabꞌeꞌ tukꞌ vetojeꞌ skaabꞌil tul aꞌ la bꞌenkat ex tu u choobꞌal paaveꞌ uveꞌ ni toypukat u xamaleꞌ uveꞌ yeꞌl iyaꞌtebꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Asoj la paavin ex taꞌn u bꞌaqꞌ evatzeꞌ, as eyaꞌsataj epaavineꞌ eela kuxh stukꞌ uvaꞌ kat eteesal veꞌt el u bꞌaqꞌ evatzeꞌ, tan aal bꞌaꞌneꞌ uvaꞌ umaꞌl kuxh u bꞌaqꞌ evatzeꞌ tul la ok ex tu uveꞌ atkat u tiichajileꞌ tetz vetaanxelaleꞌ, as tiꞌ uvaꞌ kꞌuxh at kaꞌvaꞌl u bꞌaqꞌ evatzeꞌ as tul aꞌ la bꞌenkat ex tu u choobꞌal paaveꞌ uveꞌ atkat u xamaleꞌ uvaꞌ yeꞌl iyaꞌebꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","As etixvak unqꞌa uxhchileꞌ uvaꞌ ech vitxumbꞌaleꞌ echeꞌ unqꞌa talaj intxaꞌeꞌ, tan jik chit la val sete, tan unqꞌa ángel uvaꞌ tetz unqꞌa uxhchileꞌ as atoꞌk vatz u Kubꞌaal Tiixheꞌ tu almikaꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","As in uvaꞌ in VIKꞌAOL U NAJEꞌ, as kat ul in tiꞌ unlochat unqꞌa tenameꞌ uveꞌ tzꞌejxinajle. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","As ech nunbꞌaneꞌ echeꞌ umaꞌl u naj uvaꞌ at oꞌkꞌalal (100) ikaneeroꞌ. As tul kat itzꞌej kan naj umaj txoo, ¿as ma yeꞌ la taqꞌ kan naj bꞌelelaval toꞌkꞌal (99) unqꞌa ikaneeroꞌeꞌ tu u atinbꞌaleꞌ uvaꞌ yeꞌxhkam la bꞌanon as la bꞌen ichuk naj vikaneeroꞌeꞌ xoꞌl koobꞌal? ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","As ni val sete, asoj la ilej veꞌt naj txoo, as mamaꞌla chiibꞌichil la ibꞌan veꞌt naj tiꞌ txoo tiꞌ bꞌelelaval u toꞌkꞌaleꞌ uveꞌ yeꞌ kat tzꞌejxi. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","As echat chit nibꞌan u Kubꞌaaleꞌ uveꞌ at tu almikaꞌ, tan yeꞌ nisaꞌ Aak uvaꞌ la tzꞌejxik kan umaj unqꞌa uxhchileꞌ uvaꞌ ech vitxumbꞌaleꞌ echeꞌ unqꞌa talaj intxaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Asoj la paavin umaj u eetzꞌin aatzikeꞌ savatz, as la aal isuuchil ste tul uvaꞌ axh kuxh stukꞌ sajunal. Asoj la tabꞌi vayoleꞌ, as bꞌaꞌn veꞌt aatineꞌ tukꞌ u eetzꞌin aatzikeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pet asoj yeꞌ la tabꞌi vayoleꞌ, as eeqꞌo umaj moj kaꞌvaꞌtoj u qitzꞌin qatzikeꞌ seeꞌ tiꞌ etalat isuuchil vipaaveꞌ ste. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Pet asoj yeꞌ la tabꞌi viyol unqꞌa qitzꞌin qatikeꞌ uvaꞌ la eeqꞌo seeꞌ, as la bꞌen aal veꞌteꞌ xoꞌl unqꞌa qitzꞌin qatzikeꞌ uveꞌ ni niman Tiixh. Asoj echat kuxh la ibꞌaneꞌ, as eela kuxh veꞌteꞌ tukꞌ umaj uxhchil uvaꞌ yeꞌ ni niman Tiixh as moj echeꞌ umaj u molol puaj tetz u Roma. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Tan jik chit tuk val sete, tan kam uveꞌ la etal ibꞌancheꞌ vatz u txꞌavaꞌeꞌ as aꞌeꞌ la bꞌanax tu almikaꞌ. As kam uvaꞌ la etaleꞌ uvaꞌ yeꞌ la bꞌanchu vatz u txꞌavaꞌeꞌ as aꞌeꞌ yeꞌ la bꞌanchu tu almikaꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","As tuk val sete unpajte, tan asoj at kaꞌvoꞌj ex uvaꞌ la ikꞌul tibꞌ veyoleꞌ tzitzaꞌ vatz u txꞌavaꞌeꞌ tiꞌ umaj kam uvaꞌ la ejaj te vunBꞌaaleꞌ uveꞌ tu almikaꞌ, as la chit ibꞌan Aakeꞌ kam uvaꞌ la ejajeꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","tan katil uvaꞌ atkat kaꞌvoꞌj moj oxvoꞌj uxhchil tiꞌ imolat tibꞌ tiꞌ vunbꞌiieꞌ, as at ineꞌ sxoꞌl,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","As jetzꞌen veꞌt ok u Luꞌeꞌ kꞌatz u Jesús. As ech tal veꞌt naj ileꞌ: —¿Pap, jatpajul la unsotzsa ipaav umaj vitzꞌin vatzik uvaꞌ la bꞌanon umaj vaꞌlexh sve? ¿Ma la unsotzsa ipaav asoj vujpajul la ibꞌan umaj vaꞌlexh sve?— tiꞌk u Luꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ech tal veꞌt u Jesús ileꞌ: —Yeꞌle, jit kuxh vujpajul la asotzsa ipaav u eetzꞌin aatzikeꞌ, pet vujpajul laval imutxꞌ la asotzsa ipaav u eetzꞌin aatzikeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","As ech tal u Jesús ileꞌ: —Ech la ibꞌan u tijleꞌm u Tiixheꞌ echeꞌ kat ibꞌan umaꞌl u ijlenaal uvaꞌ kat tal veꞌt tixmal vitxꞌoj unqꞌa ikꞌameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","As tul kat tixma veꞌt u ijlenaaleꞌ vitxꞌoj unqꞌa ikꞌameꞌ, as bꞌex eqꞌoloj tzan umaꞌl u naj uvaꞌ xoꞌvebꞌal chit vitxꞌojeꞌ xeꞌ u ijlenaaleꞌ, tan laval mil vitxꞌojeꞌ atik veꞌteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","As yeꞌlik chit ipuaj naj atike tiꞌ ichooat vitxꞌojeꞌ. As tal veꞌt u ijlenaaleꞌ uvaꞌ la kꞌayil veꞌt naj, tukꞌ u tixqeleꞌ, tukꞌ unqꞌa initxaꞌeꞌ, as tukꞌ unqꞌa tetz najeꞌ skajayil tiꞌ ichoop veꞌt u txꞌojeꞌ xeꞌ u ijlenaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","As kuꞌ veꞌt u kꞌameꞌ qaaloj vatz u ijlenaaleꞌ tiꞌ ijajat kuybꞌal. As ech tal veꞌt naj ileꞌ: «Sotzsa unpaaveꞌ, pap. Txꞌebꞌ unbꞌiitoj in. As la chit unchoo vuntxꞌojeꞌ skajayil,» tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","As itxum veꞌt u ijlenaaleꞌ ivatz naj. As kat isotzsa veꞌt u ijlenaaleꞌ ipaav naj tiꞌ vitxꞌojeꞌ skajayil. As kat chajpul veꞌt naj taꞌn u ijlenaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","As tul kuxh el chꞌuꞌl u kꞌameꞌ vatz u ijlenaaleꞌ, as ikꞌul naj umaꞌt vimool uvaꞌ atik unbꞌiil vitxꞌojeꞌ xeꞌ naj. As oꞌkꞌalal (100) qꞌii aqꞌon itxꞌoj u najeꞌ. Oora chit itxey veꞌt naj vas imooleꞌ. As ipochꞌ veꞌt naj iqul. As: «¡Oora choo vatxꞌojeꞌ cheel!» tiꞌk naj tal te vimooleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","As kuꞌ veꞌt vimool najeꞌ qaaloj vatz tiꞌ ijajat kuybꞌal te naj. «Sotzsa unpaaveꞌ. Txꞌebꞌ unbꞌiitoj in. As tuk chit unchoo vuntxꞌojeꞌ skajayil,» tiꞌk vimool najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","As echeꞌ nikat koj tabꞌi naj viyol vimooleꞌ. Pet taqꞌ veꞌt bꞌen naj vimooleꞌ tu u kaarsa. As techanal la ichoo vitxꞌojeꞌ kajayil uveꞌ nik tal naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tul til veꞌt unjoltu unqꞌa kꞌameꞌ, as chꞌoꞌn veꞌt te chajnaj. As bꞌex tal veꞌt chajnaj te u ijlenaaleꞌ kam uveꞌ kat tulbꞌe naj vimooleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","As tul tabꞌi veꞌt u ijlenaaleꞌ, as imolo veꞌt tzan u ijlenaaleꞌ u najeꞌ. As ech tal veꞌt u ijlenaal ileꞌ te naj: «¡Axh chit txꞌiꞌla aamaeꞌ vil! Tan kꞌuxh nim chit vatxꞌojeꞌ siinxeꞌ, as kat unsotzsa veꞌt apaav tiꞌ vatxꞌojeꞌ, tan tiꞌ uvaꞌ kat ajaj kuybꞌal sve. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¡As kat koj atxum ivatz u najeꞌ uveꞌ atik itxꞌoj saxeꞌ echeꞌ uvaꞌ kat unbꞌan see!» tiꞌk u ijlenaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","As ul veꞌt iviꞌ u ijlenaaleꞌ. As taqꞌ veꞌt ok u ijlenaaleꞌ naj te unqꞌa qꞌosonaleꞌ tiꞌ iqꞌospu naj, techal la ichoo naj vitxꞌojeꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Echat la ibꞌan u Tiixheꞌ sete uvaꞌ echen tu almikaꞌ, asoj jit ayaꞌl ekꞌuꞌl la esotzsa ipaav unqꞌa etitzꞌin etatzikeꞌ tiꞌ u vaꞌlexheꞌ uvaꞌ la ibꞌan sete,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","As tul yaꞌ veꞌt talat u Jesús unqꞌa yoleꞌ, as el veꞌt chꞌuꞌl Aak tu u Galilea. As oon veꞌt Aak tu u Judea jalit u nimla aꞌeꞌ u Jordán. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","As aꞌ chit mamaꞌla tenameꞌ xekik tiꞌ Aak. As ibꞌaꞌnxisa veꞌt Aak unqꞌa aachꞌoꞌmeꞌ tzitziꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","As ul veꞌt kaꞌl unqꞌa fariseo tiꞌ ichꞌotil umaꞌl u yol te Aak as tiꞌ ichukax ipaav Aak. Ech tal veꞌt chajnaj ileꞌ: —¿Ma la uch ijatxat tibꞌ umaj naj tukꞌ tixqeleꞌ kꞌuxh kam kuxh stiꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ech tal veꞌt u Jesús ileꞌ: —Tan tixeꞌtebꞌal u vatz txꞌavaꞌeꞌ kat icheesa u Tiixheꞌ u najeꞌ as kat icheesa Aak u ixojeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","As ech kat tal veꞌt u Tiixh ileꞌ: «Estiꞌeꞌ la taqꞌ kan u najeꞌ vitxutxeꞌ tukꞌ vibꞌaaleꞌ. As la teqꞌo tibꞌ naj tukꞌ u tixqeleꞌ. As unvatzul kuxh veꞌteꞌ tukꞌ u tixqeleꞌ,» tiꞌk u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","As jit veꞌt kaꞌvaꞌl. Pet eela kuxh stukꞌ uvaꞌ umaꞌl kuxh veꞌteꞌ vatz Aak. Estiꞌeꞌ la val sete, tan abꞌil uvaꞌ aꞌ u Tiixheꞌ kat bꞌanon uvaꞌ kat teqꞌo tibꞌ, as yeꞌxhebꞌil la jatxon ivatz,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","As ech tal veꞌt unqꞌa fariseo ileꞌ: —¿As kam qꞌi uveꞌ ni tal u Moisés uvaꞌ la itzꞌibꞌa kan u najeꞌ tu umaj uꞌuj tiꞌ uvaꞌ kam stiꞌ la ijatxkat tibꞌ naj tukꞌ u tixqeleꞌ? As la uch ijatxat tibꞌ naj tukꞌ u tixqeleꞌ,— tiꞌk unqꞌa fariseo. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ech tal veꞌt u Jesús ileꞌ: —As tiꞌ kuxh vipaasan tziil unqꞌa tenameꞌ, as kat taqꞌ veꞌt u Moisés tokebꞌal u jatxiibꞌeꞌ. Pet jitꞌeꞌcheꞌ uvaꞌ kat tal kan u Tiixheꞌ bꞌaxa. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","As tuk val sete, u najeꞌ uvaꞌ kat ijatxeꞌl u tixqeleꞌ as tul yeꞌl ixoj kat iyansa tibꞌ tukꞌ umaꞌtoj naj, asoj la teqꞌo tibꞌ naj tukꞌ umaꞌt ixoj, as la paavin veꞌt naj vatz u Tiixheꞌ. As echat la ibꞌan umaꞌt u najeꞌ, tan la paavin veꞌt naj asoj la tixqeli naj u ixojeꞌ uveꞌ jatxel tibꞌ tukꞌ vitzumeleꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","As ech tal veꞌt unqꞌa ichusulibꞌ u Jesús ileꞌ: —Asoj ech isuuchil u yoleꞌ tiꞌ tatin umaj naj tukꞌ u tixqeleꞌ, as aal bꞌaꞌneꞌ bꞌa uvaꞌ yeꞌ la ichuk naj tixqel,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ech tal veꞌt u Jesús ileꞌ: —Jit kajayil unqꞌa najeꞌ la txꞌolon ikuyat u yolaꞌ. Pet aꞌ kuxh unqꞌa najeꞌ uveꞌ la taqꞌ u Tiixheꞌ ste tiꞌ ikuyataꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tan at unqꞌa najeꞌ uvaꞌ at tzan stiꞌ tul yeꞌxnik itzꞌebꞌi uvaꞌ yeꞌl tixqel nichukeꞌ. As at unqꞌa najeꞌ uvaꞌ an kuxh umaꞌt naj ni bꞌanon ste uvaꞌ yeꞌl tixqel nichukeꞌ. As at unqꞌa najeꞌ uvaꞌ an kuxheꞌ ni bꞌanon jeꞌ ste uvaꞌ yeꞌl veꞌt tixqel nichukeꞌ. As nibꞌaneꞌ tiꞌ toksat taama tiꞌ u tijleꞌm u Tiixheꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","As eqꞌol veꞌt ok kaꞌl unqꞌa talaj intxaꞌ vatz u Jesús tiꞌ uvaꞌ la taqꞌ jeꞌ Aak iqꞌabꞌ tiꞌ chiintxaꞌ as la inach Aak Tiixh stiꞌ. As yaan veꞌt unqꞌa ichusulibꞌ Aakeꞌ te unqꞌa uxhchileꞌ uveꞌ nik eqꞌon ok unqꞌa talaj intxaꞌeꞌ vatz Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","As ech tal veꞌt u Jesús ileꞌ: —Echajputaj ok tzan unqꞌa talaj intxaꞌeꞌ sunkꞌatz. As yeꞌ kuxh emaj chiintxaꞌ, tan abꞌil uvaꞌ ech itxumbꞌaleꞌ echeꞌ vitxumbꞌal unqꞌa talaj intxaꞌeꞌ, as aꞌeꞌ uveꞌ at tokebꞌal xoꞌl unqꞌa tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","As taqꞌ veꞌt jeꞌ u Jesús iqꞌabꞌ tiꞌ iviꞌ unqꞌa talaj intxaꞌeꞌ tiꞌ taqꞌat Aak vibꞌaꞌnileꞌ stiꞌ. Tul bꞌaꞌnxi, as bꞌen veꞌt Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","As bꞌex uloj umaꞌl u chelem naj kꞌatz u Jesús. As ech tal veꞌt naj ileꞌ te Aak: —¿Bꞌaꞌnla Chusul, abꞌiste u bꞌaꞌneꞌ la unbꞌaneꞌ tiꞌ uvaꞌ at untiichajil uvaꞌ yeꞌl iyaꞌtebꞌal?— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ech tal veꞌt u Jesús ileꞌ: —¿Kam qꞌi uvaꞌ, «Bꞌaꞌnla Chusul,» chꞌaxh sve? Tan yeꞌl umaj bꞌaꞌnla chusul ati. Pet taꞌneꞌ u Tiixheꞌ. Pet asoj nasaꞌ uvaꞌ at atiichajil kꞌatz Aak, as nima unqꞌa tzaqꞌiteꞌ uveꞌ ni tal Aak,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—¿Abꞌisteeꞌ qꞌi, Pap, u tzaqꞌiteꞌ uveꞌ naaleꞌ?— tiꞌk naj. As ech tal veꞌt u Jesús ileꞌ: Ayatzꞌak umaj uxhchil. Achukak eexoj. Elqꞌiꞌk axh. Acheesak ipaav amool. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Nima abꞌaal; nima atxutx. As xoꞌnoj u eetzꞌin aatzikeꞌ see echeꞌ uvaꞌ nabꞌan jeꞌ see,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","—As nimamal chiteꞌ svaꞌn skajayil tul chꞌoo telik in. ¿Pet kam umaꞌtoj qꞌi, Pap, la unbꞌaneꞌ?— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","—Asoj aꞌ nasaꞌ uvaꞌ jik chit axh vatz u Tiixheꞌ, as kuxh kꞌayi kan unqꞌa txꞌiibꞌal aqꞌiieꞌ skajayil. As la ajatx veꞌt vijaꞌmileꞌ xoꞌl unqꞌa meebꞌaꞌeꞌ. As siꞌu. Xekebꞌen sviꞌ. As nimal u bꞌaꞌnileꞌ lakꞌul tu almikaꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","As tul tabꞌi u chelem najeꞌ u yoleꞌ uvaꞌ tal u Jesús, as txumun veꞌt naj tul bꞌen naj, tan tiꞌ uvaꞌ nimal u txꞌiibꞌal iqꞌii najeꞌ atike. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","As ech tal veꞌt u Jesús ileꞌ te unqꞌa ichusulibꞌeꞌ: —Jik chit tuk val sete, tan kaꞌl tzii stiꞌ uvaꞌ at tokebꞌal umaj txꞌioliqꞌii xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","As tuk val sete unpajte, tan oora kuxheꞌ la pal umaj camello tu vixotoꞌlil umaj tzꞌisbꞌal bꞌaj tiꞌ uvaꞌ la ok umaj txꞌioliqꞌii xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","As tul tabꞌi unqꞌa ichusulibꞌ Aakeꞌ u yoleꞌ, as teqꞌo veꞌt taama chajnaj. As ech tal veꞌt chajnaj ileꞌ te Aak: —Asoj ech la ibꞌaneꞌ echeꞌ uveꞌ, ¿as abꞌil veꞌteꞌ qꞌi la ok xoꞌl vitenam u Kubꞌaal Tiixheꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","As isaji veꞌt u Jesús chajnaj. As ech tal veꞌt Aak ileꞌ: —As vatz unqꞌa uxhchileꞌ, as aꞌ chiteꞌ yeꞌ la uchi. Pet ech koj vatz u Tiixheꞌ, tan la chit ibꞌaneꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","As ech tal veꞌt u Luꞌ ileꞌ te u Jesús: —Kat qaqꞌlu veꞌt kan unqꞌa qetzeꞌ skajayil. As il oꞌ xekel veꞌt oꞌ seeꞌ. ¿As kam qꞌi la aqꞌax sqe?— tiꞌk u Luꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ech tal veꞌt u Jesús ileꞌ: —Tuk val sete, jankꞌal ex uveꞌ xekel chit ex sviꞌ, as la ilej umaꞌl u qꞌii uvaꞌ la jalpul veꞌt unqꞌa txumbꞌaleꞌ skajayil, tul la xonebꞌ veꞌt VIKꞌAOL U NAJEꞌ tu xonlebꞌaleꞌ uvaꞌ nim talcheꞌ uvaꞌ ni litzꞌloꞌlaneꞌ. As antu veꞌt ex la xonebꞌ veꞌt ex tu kabꞌlavat unqꞌa bꞌaꞌnla xonlebꞌaleꞌ tiꞌ ebꞌanat isuuchil kabꞌlaval jolol unqꞌa tenameꞌ uvaꞌ tiaal Israel, ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","tan abꞌil uvaꞌ la taqꞌ kan ikabꞌal tiꞌ ixekebꞌ sviꞌ, moj la taqꞌ kan titzꞌin tatzik, moj itxutx, moj ibꞌaal, moj tixqel, moj meꞌal ikꞌaol, as moj itxꞌavaꞌ; as oꞌkꞌalal (100) ichꞌexel u tetzeꞌ la aqꞌax veꞌt ste tiꞌ unqꞌa tetzeꞌ uvaꞌ kat taqꞌ kan sviꞌ. As at veꞌt itiichajil uvaꞌ yeꞌl iyaꞌtebꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","As la val sete, tan nimal unqꞌa uxhchileꞌ uvaꞌ ni toksal iqꞌii taꞌn unqꞌa tenameꞌ, as tul aꞌeꞌ uvaꞌ jit nim talpeꞌ vatz u Tiixheꞌ. Pet ech koj unqꞌa uxhchileꞌ uvaꞌ yeꞌl iqꞌii vatz unqꞌa tenameꞌ, as aꞌeꞌ uvaꞌ nim talcheꞌ vatz u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Tan ech nibꞌan u tijleꞌm u Tiixheꞌ echeꞌ nibꞌan umaj u bꞌaal aqꞌon. Tul kat sajbꞌu veꞌteꞌ, as kat el veꞌt u bꞌaal aqꞌoneꞌ tiꞌ ichukat ikꞌam tiꞌ u taqꞌoneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","As ikꞌul tibꞌ iyol naj tukꞌ kaꞌl unqꞌa aqꞌonvil uvaꞌ kaniꞌch la choopkat chajnaj tiꞌ qꞌii. As ichaj bꞌen naj chajnaj tiꞌ u aqꞌoneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tul oon bꞌeluval oora, as el veꞌt u bꞌaal aqꞌoneꞌ. As bꞌex ilej veꞌt naj kaꞌt unqꞌa aqꞌonvileꞌ uvaꞌ txakleꞌl kuxh tu kꞌayibꞌal, tan tiꞌ uvaꞌ yeꞌlik taqꞌon chajnaj atike. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","As: «Bꞌenojtaj ex sviꞌ aqꞌonvoj. As la unchoo veqꞌiieꞌ, kaniꞌch uvaꞌ la itxꞌak umaꞌl aqꞌonvil,» tiꞌk u bꞌaal aqꞌoneꞌ. As bꞌen veꞌt chajnaj aqꞌonvoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tul chaqꞌaan veꞌt qꞌii, as el veꞌt u bꞌaal aqꞌoneꞌ. As echat chit kat ibꞌan veꞌt u bꞌaal aqꞌoneꞌ tukꞌ kaꞌt aqꞌonvil. Tul kat oon oxvaꞌl oora kuꞌqꞌii, as echat chit kat ibꞌan u bꞌaal aqꞌoneꞌ unpajte tukꞌ kaꞌt aqꞌonvil. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","As tul kat oon oꞌvaꞌl oora kuꞌqꞌii, as el veꞌt u bꞌaal aqꞌoneꞌ. As ilej veꞌt naj kaꞌt unqꞌa aqꞌonvil uveꞌ yeꞌlik taqꞌon. As ech tal veꞌt u bꞌaal aqꞌon ileꞌ te chajnaj: «¿Kam qꞌi uvaꞌ at kuxh ex tu u qꞌiiaꞌ? As yeꞌl ex netaqꞌonveꞌ,» tiꞌk u bꞌaal aqꞌoneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","«Yeꞌle, pap, tan yeꞌxhebꞌil kat aqꞌon qaqꞌon,» tiꞌk chajnaj. As: «Bꞌenoj ex bꞌa sviꞌ. As la unchoo veqꞌii, kaniꞌch uvaꞌ la itxꞌak umaj aqꞌonvil,» tiꞌk u bꞌaal aqꞌoneꞌ te chajnaj. As bꞌen veꞌt chajnaj aqꞌonvoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Tul tzꞌotin veꞌteꞌ, as tal veꞌt u bꞌaal aqꞌoneꞌ te u ilol tetz isuuchil u aqꞌoneꞌ. As ech tal veꞌt naj ileꞌ: «Molo tzan unqꞌa aqꞌonvileꞌ skajayil. As choo veꞌt chajnaj. As bꞌaxel la achoo unqꞌa aqꞌonvileꞌ uveꞌ kat ul timoxtel. As imoxtel la achoo unqꞌa aqꞌonvileꞌ uveꞌ bꞌaxel kat uli,» tiꞌk u bꞌaal aqꞌoneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tul choop veꞌt unqꞌa aqꞌonvileꞌ uveꞌ bꞌiitik kuxh ibꞌen veꞌt qꞌii tul ok aqꞌonvoj, as ijaꞌmil umaꞌl qꞌii aqꞌon kat choopkat chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tul til veꞌt unqꞌa najeꞌ uveꞌ qꞌalaꞌm chit xeꞌt aqꞌonvoj, as tal jeꞌ chajnaj ste uvaꞌ kamal nimal tuk choopojkat veꞌt chajnaj uvaꞌ nikat taleꞌ. As tul choop veꞌt chajnaj, as eela kuxh ijaꞌmil chajnaj kat ibꞌana. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","As tul ikꞌul veꞌt chajnaj vijaꞌmileꞌ, as yan veꞌt ikꞌuꞌl chajnaj. As xeꞌt veꞌt chajnaj tiꞌ iyolax u bꞌaal aqꞌoneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ech tal chajnaj ileꞌ: «Umaꞌl kuxh oora kat aqꞌonvu unqꞌa naj ileꞌ. As eela kuxh u kujaꞌmileꞌ tukꞌ chajnaj kat ibꞌan naj. As tul il oꞌ ilaꞌ uvaꞌ umaꞌl chit qꞌii kat aqꞌonv oꞌ vatz u qꞌiieꞌ uveꞌ vaꞌl chit ikꞌachoneꞌ,» tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","As ech tal veꞌt u bꞌaal aqꞌon ileꞌ te umaꞌl u aqꞌonvileꞌ: «Txaj, yeꞌl umaj onkonil nunbꞌan see, ¿tan ma yeꞌ kat ikꞌul tibꞌ kuyol bꞌa uvaꞌ kaniꞌch la unchookat axh tiꞌ qꞌii? ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","As kꞌul vajaꞌmileꞌ. As kuxh veꞌteꞌ, tan ayaꞌl chit unkꞌuꞌl kat vaqꞌ vijaꞌmil chajnajeꞌ echeꞌ uvaꞌ kat vaqꞌ see. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","As in kuxheꞌ la alon kam la unbꞌan tukꞌ u vetzeꞌ. ¿Pet moj nichꞌoꞌn aama tiꞌ uvaꞌ ni voybꞌe ivatz kaꞌl unqꞌa aqꞌonvileꞌ?» tiꞌk u bꞌaal aqꞌoneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Estiꞌeꞌ ni val sete uvaꞌ at unqꞌa uxhchileꞌ uveꞌ echen kꞌatz u Tiixheꞌ uveꞌ la ilpi tukꞌ vitxumbꞌaleꞌ, as tul aꞌeꞌ uvaꞌ jetzꞌennal el kꞌatz Aak. Pet at unqꞌa uxhchileꞌ uvaꞌ texh jetzꞌennal el kꞌatz Aak uvaꞌ la ilpi, as tul aꞌeꞌ uvaꞌ echen kꞌatz Aak. As at unqꞌa uxhchileꞌ uvaꞌ bꞌaxel, as aꞌeꞌ imoxtel. As at unqꞌa uxhchileꞌ uveꞌ timoxtel, as aꞌeꞌ bꞌaxel,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","As tul bꞌen veꞌt u Jesús tu bꞌey tiꞌ toon tu u Jerusalén, as imolo veꞌt el Aak kabꞌlaval unqꞌa ichusulibꞌeꞌ. As ech tal veꞌt Aak ileꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Il oꞌ maꞌt veꞌt jeꞌ oꞌ tu u Jerusalén. As tuk oksaloj ok VIKꞌAOL U NAJEꞌ tiqꞌabꞌ unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh tukꞌ te unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ. As tuk alaxoj unkameꞌ. As la yatzꞌpu veꞌt in. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","As tuk oksaloj in tiqꞌabꞌ unqꞌa jit tiaal Israel. As la eesal unqꞌii. As la qꞌospu veꞌt in. As la aqꞌax veꞌt jeꞌ in vatz umaꞌl u kurus tiꞌ unkameꞌ. As titoxvu qꞌii, la ul vaama,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","As jetzꞌen veꞌt ok u tixqel u Zebedeo kꞌatz u Jesús. As xekik kaꞌvaꞌl unqꞌa taleꞌ stiꞌ, u Jacob tukꞌ u Xhuneꞌ. As kuꞌ veꞌt u naneꞌ qaaloj vatz u Jesús. As ech tal ileꞌ te Aak: —Pap, la unjaj bꞌaꞌnil see,— tiꞌke. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","—¿Kam ni tal aama qꞌi?— tiꞌk u Jesús. —Aꞌ ni valeꞌ uvaꞌ tul la ok axh ijlenaalil, as la akꞌujbꞌaꞌ uvaꞌ la xonebꞌ kaꞌvaꞌl u valeꞌ sakꞌatz. Umaꞌl la xonebꞌ tasebꞌal; as umaꞌt la xonebꞌ tamax,— tiꞌk u tixqel u Zebedeo. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","As ech tal veꞌt u Jesús ileꞌ: —Yeꞌ nepal stuul kam uveꞌ nejaj sve. ¿As ma la etxꞌol epal tu u kꞌaxkꞌoeꞌ uveꞌ tuk unpalebꞌe; as ma la etxꞌol epal tu u kamchileꞌ uvaꞌ tuk unpalebꞌe?— tiꞌk u Jesúseꞌ. —Kano, la kutxꞌoleꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","As ech tal veꞌt u Jesús ileꞌ te chajnaj: —An chiteꞌ, tan la pal ex tu u kꞌaxkꞌoeꞌ uveꞌ tuk unpalebꞌe. As la pal ex tu u kamchileꞌ uveꞌ tuk palojkat in. Pet ech koj uvaꞌ netal exonebꞌ tunsebꞌal tukꞌ tu vunmaxeꞌ, tan jit ineꞌ la aqꞌon sete. Pet aꞌ la aqꞌaxkat te unqꞌa uxhchileꞌ uvaꞌ txaael veꞌt taꞌn u Tiixheꞌ, tan bꞌanel veꞌt tucheꞌ taꞌn Aak tiꞌ taqꞌax ste,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","As tul tabꞌi veꞌt lavat unqꞌa ichusulibꞌ Aakeꞌ, as ul veꞌt iviꞌ chajnaj tiꞌ kaꞌvaꞌl unqꞌa imooleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","As imolo veꞌt tzan u Jesús unqꞌa ichusulibꞌeꞌ. As ech tal veꞌt Aak ileꞌ te chajnaj: —Ootzimal setaꞌn uvaꞌ jankꞌal unqꞌa najeꞌ uveꞌ at tijleꞌm vatz u txꞌavaꞌeꞌ as nim chit chajnaj ninacheꞌ tiꞌ ibꞌekꞌat unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pet jitꞌeꞌch la ibꞌan sexoꞌl tan abꞌiste ex uvaꞌ nesaꞌ uvaꞌ nim etalcheꞌ tiꞌ unqꞌa emooleꞌ, as exeꞌ la lochon vemooleꞌ la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","As ex uvaꞌ nesaꞌ uvaꞌ at etijleꞌm xoꞌl unqꞌa emooleꞌ, as ex lochol tetz vemooleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Echeꞌ kat koj ul VIKꞌAOL U NAJEꞌ tiꞌ uvaꞌ la lochpi taꞌn unqꞌa tenameꞌ. Pet kat uli tiꞌ taqꞌat tibꞌ kamoj tiꞌ iqꞌalpul unqꞌa tenameꞌ vatz vipaaveꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","As tul el veꞌt chꞌuꞌl u Jesús tu u Jericó, as aꞌ chit mamaꞌla tenameꞌ xekebꞌ veꞌt tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","As xonlik kaꞌvaꞌl unqꞌa tzot tziꞌ bꞌey. Tul tabꞌi chajnaj ipal veꞌt u Jesús, as sikꞌin veꞌt chajnaj. Ech nikat tal chajnaj ileꞌ: —¡Pap tiaal David, txum kuvatz!— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","As iyaa veꞌt unqꞌa tenameꞌ kaꞌvaꞌl u tzoteꞌ tiꞌ uvaꞌ la yaꞌ chajnaj tiꞌ isikꞌineꞌ. As aal chit taqꞌ veꞌt jeꞌ chajnaj tuul iviꞌ. Ech tal veꞌt chajnaj ileꞌ: —¡Pap tiaal David, txum kuvatz!— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","As txakebꞌ veꞌt u Jesús. As imolo veꞌt tzan Aak chajnaj. Ech tal Aak ileꞌ te chajnaj: —¿Kam qꞌi nesaꞌ uvaꞌ la unbꞌaneꞌ?— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","As ech tal veꞌt chajnaj ileꞌ: —Pap, aꞌ ni qaleꞌ uvaꞌ la ilon vas kuvatzeꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","As itxum veꞌt u Jesús ivatz chajnaj. Ikan veꞌt ok Aak vivatz chajnajeꞌ. As yak kuxh ilon veꞌt chajnaj. As xekebꞌ veꞌt chajnaj tiꞌ u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Tul bꞌiitik kuxh toon veꞌt u Jesús tu u Jerusalén tukꞌ unqꞌa ichusulibꞌeꞌ, as oon veꞌt Aak tu u tal tenam u Betfagé kꞌatz umaꞌl u vitz uvaꞌ Olivos. As ichaj veꞌt bꞌen Aak kaꞌvaꞌl unqꞌa ichusulibꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ech tal Aak ileꞌ te chajnaj: —Bꞌenoj ex tu u tal tenameꞌ uveꞌ at tzan. Tul la oon ex, as la bꞌen elej umaꞌl u bꞌur tukꞌ umaꞌl u tal uvaꞌ kꞌalel kan. La esaapu txoo; as la eteqꞌo tzan txoo. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Asoj abꞌil la yaaon ex tiꞌ txoo, as ech la etal ileꞌ: «Aꞌ u Kubꞌaaleꞌ tuk txakonsan txoo,» chaj ex la etaleꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","As ech kat bꞌex ibꞌan umaꞌl u yol ileꞌ uveꞌ alel kan taꞌn umaꞌl u qꞌajsan tetz viyol u Tiixheꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Etaltaj te unqꞌa tenameꞌ uveꞌ tu u Sion uvaꞌ: Il vetijlenaal ileꞌ tul setiꞌ. As sula txumbꞌal u txumbꞌaleꞌ eqꞌomal staꞌn. As at jeꞌ tiꞌ umaꞌl u tal bꞌur, u tal umaꞌl u bꞌur tetz ijatz, tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","As bꞌen veꞌt kaꞌvaꞌl unqꞌa ichusulibꞌ Aakeꞌ. As ibꞌan veꞌt chajnaj kam uvaꞌ tal Aak te chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","As teqꞌo veꞌt chajnaj u bꞌureꞌ tukꞌ u tal bꞌureꞌ. As taqꞌ veꞌt jeꞌ chajnaj unqꞌa ixbꞌuꞌjeꞌ tiꞌ u tal bꞌureꞌ. As jeꞌ veꞌt u Jesús tiꞌ txoo. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","As at unqꞌa uxhchileꞌ kat iliipu kuꞌ unqꞌa ixbꞌuꞌjeꞌ tu bꞌey. As ati uvaꞌ bꞌex itzokꞌ tzan xaj chꞌiꞌm. As kat taqꞌ kuꞌ tu bꞌey vatz Aak, tan aꞌ chit mamaꞌla tenameꞌ xekik tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","As unqꞌa tenameꞌ uvaꞌ bꞌaxik vatz u Jesús tukꞌ uveꞌ xekik tiꞌ Aak, as taqꞌ veꞌt jeꞌ tuul iviꞌ tiꞌ isikꞌineꞌ tiꞌ Aak. As ech tal ileꞌ: —¡Qoksataj iqꞌii u tiaal David! ¡Tan achvebꞌal chit tuleꞌ tukꞌ vibꞌii u Kubꞌaaleꞌ! ¡As qoksataj iqꞌii tan nim talcheꞌ uveꞌ echen tu almikaꞌ!— tiꞌk unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","As tul ok veꞌt u Jesús tu u Jerusalén, as sotz veꞌt ikꞌuꞌl unqꞌa tenameꞌ. As at unqꞌa tenameꞌ ech nik tal ileꞌ svatzaj: —¿Abꞌileꞌ qꞌi uveꞌ tuleꞌ?— tiꞌk unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ech tal veꞌt kaꞌt unqꞌa tenam ileꞌ: —Aꞌ u Jesús, u qꞌajsan tetz viyol u Tiixheꞌ, uvaꞌ kat tzaa tu u Nazaret uvaꞌ echen tu u Galilea,— tiꞌk unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","As tul ok veꞌt u Jesús vatz viqꞌanal u tostiixheꞌ, as itilu veꞌt el Aak unqꞌa uxhchileꞌ uveꞌ nikat ikꞌayineꞌ as tukꞌ unqꞌa uxhchileꞌ uveꞌ nikat iloqꞌoneꞌ. As ipilqꞌu veꞌt Aak imeexha unqꞌa jalol puajeꞌ as tukꞌ u tatinbꞌal unqꞌa paroomaxheꞌ uveꞌ nik ikꞌayileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","As ech tal veꞌt Aak ileꞌ: —Ech ni tal u yoleꞌ uvaꞌ tzꞌibꞌamal kan: Nachbꞌal Tiixheꞌ vunkabꞌaleꞌ la ibꞌaneꞌ, tiꞌk Aak. Pet ech koj ex, tan kat ebꞌensal veꞌteꞌ statinbꞌal elqꞌom,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","As ul veꞌt unqꞌa tzoteꞌ tukꞌ unqꞌa koꞌxeꞌ kꞌatz u Jesús tu u tostiixheꞌ. As ibꞌaꞌnxisa veꞌt Aak unqꞌa uxhchileꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","As tul til veꞌt unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh tukꞌ unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, uvaꞌ ibꞌaꞌnxisa u Jesús unqꞌa uxhchileꞌ, as chꞌoꞌn veꞌt taama chajnaj stiꞌ as tukꞌ tiꞌ uvaꞌ tabꞌi chajnaj uvaꞌ nik isikꞌin unqꞌa tal intxaꞌeꞌ, tan ech nik tal ileꞌ: «¡Qoksataj iqꞌii u tiaal David!» tiꞌk unqꞌa tal intxaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","As ech tal veꞌt chajnaj ileꞌ te u Jesús: —¿Ma naabꞌi uveꞌ ni tal unqꞌa talaj intxaꞌeꞌ?— tiꞌk chajnaj. Ech tal u Jesús ileꞌ: —Kano, ni vabꞌieꞌ. ¿As ma yeꞌ atixoj esikꞌle umaꞌl u yol uvaꞌ ech ni tal ileꞌ? Aꞌ viyol unqꞌa talaj intxaꞌeꞌ tukꞌ u tuul iviꞌ unqꞌa talaj neꞌeꞌ uveꞌ nitel ichꞌuꞌuneꞌ as la toksa unqꞌii, tiꞌk u yoleꞌ,— tiꞌk u Jesús tal te chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","As taqꞌ veꞌt kan u Jesús chajnaj. As el veꞌt chꞌuꞌl Aak tu u Jerusalén. As bꞌex veꞌt Aak vatoj tu u tal tenam uvaꞌ Betania. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tul sajbꞌu veꞌteꞌ, as bꞌen veꞌt u Jesús tu bꞌey tiꞌ iqꞌaav tu u Jerusalén. Tul nikat ixaan Aak, as vaꞌy veꞌt Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","As til veꞌt Aak umaꞌl u tzeꞌ uvaꞌ higuera tziꞌ u bꞌeyeꞌ. As jetzꞌen veꞌt ok Aak kꞌatz u tzeꞌeꞌ, tan kamal atik ivatz tzeꞌ uvaꞌ nik tal Aak. As yeꞌlik chit umaj ivatz tzeꞌ atike. Pet ixaj kuxh tzeꞌ atike. As ech tal veꞌt Aak ileꞌ: —Yeꞌxh jatu la vatzin veꞌt axh,— tiꞌk Aak tal te u tzeꞌeꞌ. As yak kuxh tzaj veꞌt u tzeꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","As tul til veꞌt unqꞌa ichusulibꞌ Aakeꞌ, as sotz veꞌt ikꞌuꞌl chajnaj. As ech tal veꞌt chajnaj ileꞌ te Aak: —¿Kam qꞌi uveꞌ oora chit kat tzaj veꞌt u tzeꞌeꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","As ech tal veꞌt u Jesús ileꞌ: —Jik chit tuk val sete, tan asoj kꞌujleꞌl ekꞌuꞌl sviꞌ, as jit kuxh ech la ebꞌaneꞌ echeꞌ uveꞌ kat unbꞌan te u tzeꞌeꞌ. Pet la uch etalateꞌ te u vitz ileꞌ uvaꞌ: «¡Elen tzitziꞌ! ¡As kuxh bꞌen tu u mar!» chaj ex la etaleꞌ. As la chit ibꞌaneꞌ asoj yeꞌ la kaꞌkabꞌin etaama, ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","tan asoj kꞌujleꞌl chit ekꞌuꞌl tiꞌ u Tiixheꞌ tul la enach Tiixh, as la chit ibꞌan Aak kam uveꞌ la ejaj te Aak,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","As tul oon veꞌt u Jesús tu u Jerusalén, as ok veꞌt Aak tu u tostiixheꞌ. As xeꞌt veꞌt Aak chusun. As jetzꞌen veꞌt ok unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh tukꞌ kaꞌt unqꞌa bꞌaal tenameꞌ. As ech tal veꞌt chajnaj ileꞌ te u Jesús: —¿Abꞌil aqꞌol tetz u eejleꞌmeꞌ tiꞌ uvaꞌ kat ul atilu el unqꞌa uxhchileꞌ vatz iqꞌanal u tostiixheꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","As ech tal u Jesús ileꞌ: —Tuk unchꞌoti umaꞌl u yol sete. Asoj la etal sve kam uvaꞌ la unchꞌoti, as la val veꞌt sete uvaꞌ abꞌil aqꞌol tetz u vijleꞌmeꞌ tiꞌ unqꞌa veeꞌ kat unbꞌana. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Etaltaj sve: ¿Abꞌil kat chajon tzan u Xhuneꞌ uvaꞌ nik aqꞌon kuꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ? ¿Ma aꞌ u Tiixheꞌ? ¿Pet moj umaj vatz txꞌavaꞌilla aama?— tiꞌk u Jesús. As iyol veꞌt chajnaj svatzaj uvaꞌ kam la tal chajnaj. Ech tal veꞌt chajnaj ileꞌ: —Asoj tuk qaleꞌ uvaꞌ Tiixh kat chajon tzan u Xhuneꞌ, as: «¿Kam qꞌi yeꞌ kat enima u Xhuneꞌ?» chaj naj tuk tal sqe. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pet asoj tuk qaleꞌ uvaꞌ: «Vatz txꞌavaꞌilla aama kuxheꞌ kat chajon tzan u Xhuneꞌ,» chaj oꞌ, as tul nu kuxoꞌv vatz unqꞌa tenameꞌ, tan kajayil chit unqꞌa tenameꞌ ni niman uvaꞌ qꞌajsan tetz viyol u Tiixheꞌ u Xhuneꞌ,— tiꞌk chajnaj svatzaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","As ech tal chajnaj ileꞌ te u Jesús: —Yeꞌ qootzaj abꞌil kat chajon tzan u Xhuneꞌ,— tiꞌk chajnaj. As ech tal u Jesús ileꞌ: —Mitaꞌn in la alon sete uvaꞌ abꞌil kat aqꞌon u vijleꞌmeꞌ tiꞌ uvaꞌ kat unbꞌana. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","¿Pet kam tuk etal tiꞌ umaꞌt u yoleꞌ uvaꞌ tuk val sete? As atik umaꞌl u bꞌaala uvaꞌ kaꞌvaꞌl ikꞌaol. As ech tal u bꞌaala ileꞌ te umaꞌl vikꞌaoleꞌ: «Unkꞌaol, kuxh aqꞌonvoj cheel xoꞌl unqꞌa uuvaeꞌ uvaꞌ avamal svaꞌn,» tiꞌk u bꞌaalaeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","As ech tal vikꞌaol ileꞌ: «Yeꞌ unsaꞌ la unbꞌan u aqꞌoneꞌ,» tiꞌk naj tal te vibꞌaaleꞌ. As xamtik kuxh veꞌt stuul, ikꞌaxa veꞌt u kꞌaolaeꞌ. As bꞌen veꞌt naj aqꞌonvoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","As bꞌex tal veꞌt u bꞌaalaeꞌ te umaꞌt vikꞌaoleꞌ. As ech tal u kꞌaola ileꞌ: «Bꞌaꞌn kuxheꞌ bꞌa, pap. Tuk unbꞌaneꞌ,» tiꞌk naj. As jit bꞌen naj tiꞌ u aqꞌoneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","As etaltaj sve: ¿Abꞌiste kaꞌvaꞌl u kꞌaolaeꞌ kat bꞌanon uvaꞌ kat tal vibꞌaaleꞌ ste?— tiꞌk u Jesús. As ech tal chajnaj ileꞌ: —Aꞌ u najeꞌ uvaꞌ alpu ste bꞌaxa,— tiꞌk chajnaj. As ech tal veꞌt u Jesús ileꞌ te chajnaj: —An chiteꞌ uveꞌ netaleꞌ. As jik chit tuk val sete, tan unqꞌa molol puajeꞌ tetz u Roma tukꞌ unqꞌa ixoj uvaꞌ yanaꞌs, as aꞌ uxhchileꞌ bꞌaxel la ok sevatz xoꞌl u tenameꞌ uveꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","As kat ul tal u Xhuneꞌ unqꞌa jikla yoleꞌ sete. As yeꞌ kat enima. Pet ech koj unqꞌa molol puajeꞌ tetz u Roma tukꞌ unqꞌa ixoj uvaꞌ yanaꞌs, tan oora kat inima chaꞌma unqꞌa yoleꞌ uveꞌ kat ul tal u Xhuneꞌ. Pet ech koj ex, tan kꞌuxh kat etila, as yeꞌ kat ejalpu vetxumbꞌaleꞌ tiꞌ enimataꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","As etabꞌitaj isuuchil umaꞌt u kꞌuchuvatz uvaꞌ tuk val sete, atik umaꞌl u naj uvaꞌ atik itxꞌavaꞌ. As tava naj kaꞌl unqꞌa uuva. As toksa veꞌt naj peꞌ stiꞌ. As ibꞌan veꞌt naj umaꞌl u atinbꞌal uvaꞌ nipochꞌilkat el u taꞌl u uuvaeꞌ. As ilak veꞌt naj umaꞌt u atinbꞌal xeebꞌal tetz unqꞌa uuvaeꞌ uvaꞌ nim chit itxakebꞌeꞌ. As taqꞌ veꞌt kan naj vitxꞌavaꞌeꞌ tukꞌ vichikoeꞌ skꞌam te kaꞌl unqꞌa kꞌamol. As bꞌen veꞌt naj tziꞌaꞌn. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tul ilej veꞌt u qꞌii tiꞌ tuxpu vivatz unqꞌa uuvaeꞌ, as ichaj veꞌt bꞌen u bꞌaal txꞌavaꞌeꞌ kaꞌl vikꞌam tiꞌ bꞌen teqꞌot unbꞌooj ivatz u uuvaeꞌ, kꞌambꞌal tetz u txꞌavaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Tul oon veꞌt vikꞌam vibꞌaal u txꞌavaꞌeꞌ, as kat itxey veꞌt unqꞌa kꞌamoleꞌ. As umaꞌl kat qꞌospi; as umaꞌte kat yatzꞌpi; as umaꞌte kat sutil taꞌn kꞌubꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","As ichaj veꞌt bꞌen vibꞌaal u txꞌavaꞌeꞌ unjoltu unqꞌa ikꞌameꞌ. As nimal u kꞌameꞌ kat ichaj bꞌen tiꞌ uvaꞌ bꞌen bꞌaxa. As echat chit kat bꞌanchu te unqꞌa kꞌameꞌ echeꞌ uvaꞌ kat ulbꞌel unqꞌa kꞌameꞌ bꞌaxa. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","As tul maꞌtik ichajat veꞌt bꞌen vibꞌaal unqꞌa uuvaeꞌ unqꞌa ikꞌameꞌ, as aꞌ veꞌt vikꞌaoleꞌ kat ichaj bꞌen, tan ech tal jeꞌ ileꞌ ste: «Tuk nimalojeꞌ vunkꞌaoleꞌ taꞌn unqꞌa kꞌamoleꞌ,» tiꞌk vibꞌaal unqꞌa uuvaeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tul til unqꞌa kꞌamoleꞌ u kꞌaolaeꞌ, as ech tal veꞌt chajnaj ileꞌ svatzaj: «Aꞌ vikꞌaol najeꞌ vil tuleꞌ. As aꞌ najeꞌ tuk etzin kan unqꞌa uuvaeꞌ tukꞌ u txꞌavaꞌeꞌ. ¡Pet koꞌ kuyatzꞌ naj! ¡As oꞌ la kaaik kan oꞌ tu u txꞌavaꞌeꞌ!» tiꞌk unqꞌa kꞌamoleꞌ tal svatzaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","As itxey veꞌt chajnaj vikꞌaol u bꞌaal unqꞌa uuvaeꞌ. As teqꞌo el chajnaj tiꞌeꞌl u txꞌavaꞌeꞌ uvaꞌ atikkat unqꞌa uuvaeꞌ. As iyatzꞌ veꞌt chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","As tul la ul veꞌt vibꞌaal u txꞌavaꞌeꞌ, ¿as kam qꞌi la ulbꞌel veꞌt unqꞌa kꞌamoleꞌ uveꞌ netaleꞌ?— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","As ech tal veꞌt unqꞌa iqꞌesal unqꞌa tenam ileꞌ: —La yatzꞌpeꞌ unqꞌa kꞌamoleꞌ uveꞌ paasan tzii. As yeꞌl ivatzeꞌ la txumli. As la taqꞌ veꞌt u bꞌaal txꞌavaꞌeꞌ vitxꞌavaꞌeꞌ skꞌam te kaꞌtoj kꞌamol uvaꞌ jik chit la chooni tiꞌ u kꞌambꞌal tetz u txꞌavaꞌeꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","As ech tal veꞌt u Jesús ileꞌ: —¿As ma yeꞌ atixoj esikꞌle umaꞌl u yol uvaꞌ tzꞌibꞌamal kan? Uvaꞌ ech ni tal ileꞌ: As u kꞌubꞌeꞌ uvaꞌ kat sutil el taꞌn unqꞌa lakol kabꞌaleꞌ, as aꞌ veꞌteꞌ uveꞌ xeꞌabꞌ tetz vixoobꞌ u kabꞌaleꞌ. As aꞌ chit achvebꞌaleꞌ sqe, tan aꞌ u Tiixheꞌ kat bꞌanon, tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Estiꞌeꞌ ni val sete, tan atik etokebꞌal xoꞌl unqꞌa tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. Pet ech koj cheel tan yeꞌl veꞌt etokebꞌal, as aꞌ la aqꞌpukat veꞌt te unqꞌa uxhchileꞌ uvaꞌ la niman viyol Aakeꞌ, as nibꞌaneꞌ kam uveꞌ ni tal Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","As tuk val sete, tan abꞌil uveꞌ la jojtxꞌu tiꞌ u kꞌubꞌeꞌ, as yak chit la tatzꞌmeꞌ. As abꞌil uvaꞌ la kuꞌ u kꞌubꞌeꞌ stiꞌ, as yak chit la vuchꞌmeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tul tabꞌi veꞌt unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh, tukꞌ unqꞌa fariseo, as bꞌen veꞌt te chajnaj uvaꞌ chajnaj nikat tal u Jesús tukꞌ u kꞌuchuvatzeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","As tal veꞌt chajnaj itxeypu u Jesús. Pet nikat ixoꞌv chajnaj vatz unqꞌa tenameꞌ, tan qꞌajsan tetz viyol u Tiixheꞌ u Jesús uveꞌ nikat tal unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","As tal veꞌt u Jesús umaꞌt u kꞌuchuvatz te unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh tukꞌ te unqꞌa fariseo. As ech tal veꞌt Aak ileꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Ech la ibꞌan u Tiixheꞌ tiꞌ u tenameꞌ uveꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ, echeꞌ nibꞌan umaj ijlenaal uvaꞌ nibꞌan umaj bꞌaꞌnla txꞌaꞌoꞌm, tul niteqꞌo tibꞌ vikꞌaoleꞌ tukꞌ u tixqeleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","As kat ichaj bꞌen u ijlenaaleꞌ unqꞌa ikꞌameꞌ tiꞌ imolat veꞌt unqꞌa uxhchileꞌ uvaꞌ kat isaꞌbꞌelal tu u nimla qꞌiieꞌ. As jit isaꞌ unqꞌa uxhchileꞌ tul tu u nimla qꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","As ichaj veꞌt u ijlenaaleꞌ kaꞌt ikꞌam unpajte. Ech tal u ijlenaal ileꞌ: «Ech la bꞌen etal ileꞌ te unqꞌa uxhchileꞌ uvaꞌ kat unsaꞌbꞌela: –¡Il txꞌix ileꞌ kat bꞌaꞌnxiy veꞌteꞌ! Tan kat iyatzꞌlu veꞌt u ijlenaaleꞌ unqꞌa tzaqꞌal vaakaxheꞌ tukꞌ kaꞌt unqꞌa txooeꞌ. As ulojtaj ex. Ul etiltaj teqꞌot tibꞌ vikꞌaoleꞌ tukꞌ tixqel,– chaj ex la etaleꞌ,» tiꞌk u ijlenaaleꞌ tal te unqꞌa ikꞌameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","As jit kuxh latzꞌ viyol unqꞌa kꞌameꞌ te unqꞌa uxhchileꞌ uvaꞌ kat saꞌbꞌelali, tan ati uvaꞌ kat bꞌen tu aqꞌon as ati uvaꞌ aꞌ vikꞌaꞌyeꞌ bꞌex tila. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","As at chajnaj uvaꞌ kat txeyon veꞌt unqꞌa kꞌameꞌ uvaꞌ ichaj bꞌen u ijlenaaleꞌ. As kat iyoqꞌ veꞌt chajnaj unqꞌa kꞌameꞌ. As kat iyatzꞌ chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","As tul tabꞌi veꞌt u ijlenaaleꞌ uveꞌ ibꞌan unqꞌa najeꞌ te unqꞌa kꞌameꞌ, as ul veꞌt iviꞌ naj. As ichaj veꞌt bꞌen naj unqꞌa soleꞌ tiꞌ bꞌen iyatzꞌat veꞌt unqꞌa yatzꞌol aamaeꞌ as tiꞌ itzꞌeꞌsal veꞌt u tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","As ech tal veꞌt u ijlenaal ileꞌ te vikꞌameꞌ: «Il veꞌt u txꞌaꞌoꞌm ileꞌ bꞌanel veꞌt tucheꞌ tetz u nimla qꞌiieꞌ. As unqꞌa uxhchileꞌ uvaꞌ kat unmolo bꞌaxa, as jit tetzeꞌ uvaꞌ la atin tu u nimla qꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Pet bꞌenoj ex tulaj unqꞌa bꞌeyeꞌ. As jankꞌal unqꞌa uxhchileꞌ uvaꞌ la elejeꞌ, as emolotaj tzan tiꞌ tul tu u nimla qꞌiieꞌ,» tiꞌk u ijlenaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","As el veꞌt unqꞌa kꞌameꞌ tu bꞌey. As jankꞌal unqꞌa uxhchileꞌ uveꞌ kat ilej veꞌt chajnaj as imolo veꞌt ok chajnaj. Ati uvaꞌ txꞌiꞌla aama. As ati uvaꞌ bꞌaꞌnla aama. As noo veꞌt u kabꞌaleꞌ taꞌn unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","As tul ok veꞌt u ijlenaaleꞌ tu u kabꞌaleꞌ tiꞌ tilat unqꞌa ilonaaleꞌ, as til u ijlenaaleꞌ umaꞌl u naj xoꞌl vimooleꞌ uvaꞌ yeꞌl u oksaꞌmeꞌ atik ok staꞌn uvaꞌ tetz nimla qꞌii. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","As ech tal veꞌt u ijlenaal ileꞌ te u najeꞌ: «¿Vetz kꞌul tziꞌ, kam uveꞌ kat kuxh ok chꞌuꞌl axh tzitzaꞌ? As tul yeꞌl ooksaꞌm atoꞌk uvaꞌ tetz u nimla qꞌiieꞌ,» tiꞌk u ijlenaaleꞌ. As jit tiin u najeꞌ te u ijlenaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","As ech tal veꞌt u ijlenaal ileꞌ te unqꞌa ikꞌameꞌ: «Ekꞌaltaj toj u najeꞌ tukꞌ viqꞌabꞌ naj. As bꞌen esutitaj el naj tiꞌeꞌl u kabꞌaleꞌ tu u qꞌej toktoeꞌ uvaꞌ la oqꞌkat veꞌt naj as tu uvaꞌ la ikꞌuxkat veꞌt tibꞌ tee naj,» tiꞌk u ijlenaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","As estiꞌeꞌ ni val sete, tan nimal unqꞌa uxhchileꞌ uveꞌ nimolo u Tiixheꞌ. As kaꞌl kuxheꞌ uveꞌ la itxaa Aak xoꞌl,— tiꞌk u Jesús tal te unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh tukꞌ unqꞌa fariseo. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","As el veꞌt chꞌuꞌl unqꞌa fariseo vatz u Jesús. As bꞌex ichuk veꞌt chajnaj txumbꞌal tiꞌ uvaꞌ kam la ibꞌan chajnaj tiꞌ icheesal ipaav u Jesús tiꞌ umaj u yoleꞌ uvaꞌ la tal Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","As ichaj veꞌt unqꞌa fariseo kaꞌl unqꞌa imool tukꞌ kaꞌt unqꞌa uxhchil uvaꞌ echenik kꞌatz u Herodes. As ech bꞌex tal veꞌt chajnaj ileꞌ te u Jesús: —Chusul, ootzimal atxumbꞌal sqaꞌn uvaꞌ jik chit axh. As jik chit nachus unqꞌa uxhchileꞌ tiꞌ uvaꞌ jik vitxumbꞌaleꞌ la ibꞌan vatz u Tiixheꞌ. As eela kuxh ivatz unqꞌa uxhchileꞌ nabꞌaneꞌ, kꞌuxh at tijleꞌm as kꞌuxh yeꞌl tijleꞌm ati. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","As aꞌ ni qaleꞌ uvaꞌ la aal sqe kam ni tal axh: ¿Ma bꞌaꞌn uvaꞌ la kuchoo veꞌt u puajeꞌ uveꞌ nijajpu sqe taꞌn u ijlenaaleꞌ tu u Roma, pet moj yeꞌle?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","As ootzimalik vitxumbꞌal chajnajeꞌ taꞌn Aak uvaꞌ vaꞌlexh kuxhtuꞌ. As ech tal veꞌt Aak ileꞌ: —¡Ex kuxh kaꞌvatz! ¿Kam qꞌi uveꞌ nu kuxh echuk txumbꞌal sviꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pet ekꞌuchtaj u puajeꞌ sve uveꞌ netaqꞌ te u ijlenaaleꞌ,— tiꞌk u Jesús. As ikꞌuch veꞌt ok chajnaj umaꞌl u puajeꞌ tetz ijaꞌmil umaꞌl u qꞌii aqꞌon. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","As tul til u Jesús u puajeꞌ, as ech tal veꞌt Aak ileꞌ te chajnaj: —¿Abꞌil etz u vatzibꞌaleꞌ qꞌi uveꞌ at vatz u puajeꞌ? ¿As abꞌil etz u tzꞌibꞌeꞌ uveꞌ at kuꞌ stiꞌ?— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ech tal veꞌt chajnaj ileꞌ: —Tetz u ijlenaaleꞌ tu u Roma,— tiꞌk chajnaj. As ech tal veꞌt Aak ileꞌ: —Jankꞌal u tetz u ijlenaaleꞌ uvaꞌ tu u Roma, as etaqꞌtaj ste; as jankꞌal u tetz u Tiixheꞌ, as etaqꞌtaj te Aak,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","As tul tabꞌi veꞌt chajnaj viyol u Jesús, as teqꞌo veꞌt taama chajnaj. As taqꞌ veꞌt kan chajnaj Aak. As bꞌen veꞌt chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","As an chit tu u qꞌiieꞌ, as bꞌex til veꞌt kaꞌl unqꞌa saduceo u Jesús. Aꞌ nikat tal chajnaj uvaꞌ yeꞌl taama unqꞌa kamnajeꞌ la uli. As ech tal veꞌt chajnaj ileꞌ te Aak: ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Chusul, kat tal kan u Moisés uvaꞌ: «Asoj la kam umaj naj as tul yeꞌl umaj initxaꞌ naj la kaaik kan xeꞌ u tixqeleꞌ, as aꞌ umaj u titzꞌin tatzik najeꞌ la teqꞌo tibꞌ tukꞌ u ixojeꞌ tiꞌ taqꞌat kan tiaal u najeꞌ uvaꞌ kat kami,» tiꞌk u Moisés. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","As ibꞌan unpajul tan atik vujvaꞌl unqꞌa naj uvaꞌ titzꞌin tibꞌ. As teqꞌo tibꞌ u atzikaeꞌ tukꞌ umaꞌl u ixoj. As tul kam veꞌt naj, as jit kaaik kan umaj initxaꞌ naj. As kaa veꞌt u tixqel najeꞌ txakayil. As teqꞌo veꞌt tibꞌ ixoj tukꞌ u bꞌaxa itzꞌinaeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","As kam u bꞌaxa itzꞌinaeꞌ unpajte. As teqꞌo veꞌt tibꞌ ixoj tukꞌ u kaꞌv itzꞌinaeꞌ. As techal chit kat teqꞌo tibꞌ ixoj tukꞌ vujvaꞌl unqꞌa najeꞌ uveꞌ titzꞌin tibꞌ, tan junun chit ikam veꞌt chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","As tul maꞌtik ikam vujvaꞌl unqꞌa najeꞌ, as kam veꞌt u ixojeꞌ unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","¿As abꞌiste veꞌt u najeꞌ qꞌi itzumel u ixojeꞌ la ibꞌaneꞌ tul la ul veꞌt taama unqꞌa kamnajeꞌ? Tan kat teqꞌo tibꞌ ixoj tukꞌ vujvaꞌl unqꞌa najeꞌ,— tiꞌk unqꞌa saduceo. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ech tal veꞌt u Jesús ileꞌ: —Sotznal chit ekꞌuꞌl, tan yeꞌ nepal stuul kam uvaꞌ ni tal viyol u Tiixheꞌ. As mitaꞌn yeꞌ nepal stuul tiꞌ uvaꞌ la tulsa Aak taama unqꞌa kamnajeꞌ unpajte, ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","tan tul la ul veꞌt taama unqꞌa kamnajeꞌ, as yeꞌl unqꞌa najeꞌ la teqꞌo tibꞌ tukꞌ unqꞌa ixojeꞌ. As mitaꞌn unqꞌa ixojeꞌ. Pet ech veꞌteꞌ echeꞌ unqꞌa ángel uveꞌ at tu almikaꞌ la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Echeꞌ u tulebꞌal taama unqꞌa kamnajeꞌ, ¿tan ma yeꞌ atixoj esikꞌle u yoleꞌ uvaꞌ tzꞌibꞌamal kan uvaꞌ ech ni tal ileꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Tan ineꞌ in iTiixh u Abraham tukꞌ u Isaac tukꞌ u Jacob, tiꞌk u Tiixheꞌ? As jit unqꞌa kamnajeꞌ ni niman u Tiixheꞌ. Pet aꞌ unqꞌa uxhchileꞌ uvaꞌ isleꞌle vatz Aak,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","As tul tabꞌi unqꞌa tenameꞌ viyol u Jesús, as teqꞌo veꞌt taama tiꞌ unqꞌa yoleꞌ uveꞌ nik tal Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","As tul tabꞌi unqꞌa fariseo uvaꞌ jit tiin veꞌt unqꞌa saduceo taꞌn u yoleꞌ uvaꞌ tal u Jesús, as imol veꞌt tibꞌ chajnaj tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","As umaꞌl u naj uvaꞌ chuselik tibꞌ tiꞌ u tzaqꞌiteꞌ uvaꞌ tzꞌibꞌamal kan, as ichuk veꞌt naj txumbꞌal tiꞌ icheesat ipaav u Jesús. As ech tal veꞌt naj ileꞌ te Aak: ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Chusul, ¿abꞌiste u tzaqꞌiteꞌ uvaꞌ nim talcheꞌ tiꞌ unjoltu unqꞌa tzaqꞌiteꞌ?— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ech tal veꞌt u Jesús ileꞌ: —«Ayaꞌloj chit ekꞌuꞌl la exoꞌni u Tiixheꞌ tukꞌ chit etaanxelal as tukꞌ chit etxumbꞌal.» ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","As aꞌ u tzaqꞌiteꞌ uvaꞌ nim talcheꞌ tiꞌ unjoltu unqꞌa tzaqꞌiteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","As echat chit umaꞌt u tzaqꞌiteꞌ uvaꞌ ech ni tal ileꞌ: «Xoꞌnoj vamooleꞌ see echeꞌ uvaꞌ nabꞌan jeꞌ see,» taqꞌ vikaꞌv u tzaqꞌiteꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","tan aꞌ ni telkat chꞌuꞌl unqꞌa iyol unqꞌa qꞌajsan tetz viyol u Tiixheꞌ tiꞌ kaꞌvaꞌl unqꞌa tzaqꞌiteꞌ uvaꞌ ni val sete,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Tul uvaꞌ moliktel tibꞌ unqꞌa fariseo, as ech tal u Jesús ileꞌ te chajnaj: ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Kam ni tal ex tiꞌ u Cristo? ¿As abꞌil etz iial uveꞌ netaleꞌ?— tiꞌk Aak. Ech tal veꞌt chajnaj ileꞌ: —Tiaal u David u Cristo la ibꞌaneꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","As ech tal veꞌt Aak ileꞌ: —Asoj tiaal David u Cristo, ¿as kam qꞌi uveꞌ «vunBꞌaaleꞌ,» tiꞌk u David stiꞌ taꞌn u Tiixhla Espíritu? Tan ech u yol ileꞌ uvaꞌ tal kan u David: ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ech kat tal veꞌt u Kubꞌaal ileꞌ te vunBꞌaaleꞌ: «Xonebꞌen tu vunsebꞌaleꞌ, techanal la vaqꞌ kan unqꞌa uxhchileꞌ jaqꞌ avoj uveꞌ nichꞌoꞌn taama seeꞌ,» tiꞌk u David. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿As kam isuuchil qꞌi uvaꞌ tiaal David u Cristo? Taꞌn «vunBꞌaaleꞌ,» tiꞌk u David ni tal tiꞌ u Cristo— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","As yeꞌxhebꞌil kat tiin veꞌteꞌ taꞌn u yoleꞌ uveꞌ kat tal u Jesús. As yeꞌxhebꞌil chit kat itxꞌak ichꞌotil umaꞌtoj yol te u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","As ech tal veꞌt u Jesús ileꞌ te unqꞌa tenameꞌ tukꞌ te unqꞌa ichusulibꞌ Aakeꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Unqꞌa fariseo tukꞌ unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as aꞌ taqꞌon chajnajeꞌ tiꞌ ichusax unqꞌa yoleꞌ uvaꞌ tal kan u Moisés. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Estiꞌeꞌ ni val sete uvaꞌ, enimataj kuxh unqꞌa yoleꞌ uvaꞌ la tal chajnaj sete uvaꞌ la ebꞌaneꞌ. As ebꞌantaj. Pet ebꞌanak etetz echeꞌ uveꞌ nibꞌan chajnaj, tan kam uveꞌ ni tal chajnaj uvaꞌ la ebꞌaneꞌ, as vaꞌlen uveꞌ nibꞌan chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tan nimal unqꞌa yoleꞌ uvaꞌ yeꞌxhebꞌil la olebꞌ tiꞌ inimaleꞌ, as aꞌeꞌ uveꞌ ni tal chajnaj uvaꞌ techal la bꞌanchi. As mitaꞌn kuxh chajnaj la lochon unqꞌa uxhchileꞌ tiꞌ inimaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","As jankꞌal uveꞌ nibꞌan chajnaj, as vatz kuxh unqꞌa tenameꞌ nibꞌankat chajnaj, tiꞌ uvaꞌ la ok iqꞌii chajnaj taꞌn unqꞌa tenameꞌ. Tan achaꞌv chit te chajnaj tiꞌ ikꞌalat jeꞌ umaj tzꞌuꞌm tziꞌ ipala tukꞌ tiꞌ iqꞌabꞌ uvaꞌ tzꞌibꞌamalkat unbꞌiil viyol u Tiixheꞌ. As ni toksa chajnaj unqꞌa toksaꞌmeꞌ uvaꞌ vejel chittuꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","As aꞌ chit nichuk chajnaj u bꞌaꞌnla chaj atinbꞌaleꞌ uveꞌ ni tuchkat umaj bꞌaꞌnla txꞌaꞌoꞌm as tukꞌ unqꞌa bꞌaꞌnla xonlebꞌaleꞌ tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","As ni tal chajnaj uvaꞌ la ok iqꞌii chajnaj taꞌn unqꞌa tenameꞌ tu u kꞌayibꞌaleꞌ. As «kuchusul,» chaj chꞌelel chajnaj uveꞌ ni taleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pet ech koj ex, tan yeꞌ la esaꞌ uvaꞌ «chusul,» chaj chꞌelel ex, echeꞌ uveꞌ nibꞌan chajnaj, tan etitzꞌin etatzik etibꞌeꞌ sevatzaj. As umaꞌl kuxheꞌ veChusuleꞌ ati. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","As etalak «Kubꞌaal» te umaj uxhchil uvaꞌ vatz txꞌavaꞌil aama kuxhtuꞌ, tan umaꞌl kuxheꞌ u Kubꞌaaleꞌ uveꞌ echen tu almikaꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","As etoksak kuxh etibꞌ chusulil vatz vemooleꞌ, tan umaꞌl kuxheꞌ veChusuleꞌ. As ineꞌ veChusuleꞌ uvaꞌ Cristo. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Asoj at umaj ex la etal etoksat etibꞌ sqꞌesalil xoꞌl vemooleꞌ, as etoksataj etibꞌ slochol tetz vemooleꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","tan abꞌil uveꞌ ni toksa jeꞌ iqꞌii as la eesal iqꞌii. As abꞌil uveꞌ yeꞌ ni toksa jeꞌ iqꞌii as la oksal iqꞌii. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","¡As oyebꞌ chit evatz, ex fariseo tukꞌ ex uvaꞌ chusel etibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ! Tan ex kuxh kaꞌvatz, tan nemaj ivatz unqꞌa uxhchileꞌ uvaꞌ nisaꞌ tok xoꞌl unqꞌa tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. As tul yeꞌl ex netokeꞌ. As mitaꞌn nechajpu ok unqꞌa uxhchileꞌ uveꞌ nisaꞌ tok xoꞌl vitenam Aakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","As echat kuxh ex, ex fariseo tukꞌ ex uvaꞌ chusel etibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, tan ¡oyebꞌ chit evatz! Tan ex kuxh kaꞌvatz, tan mamaꞌla chit yol netaleꞌ tul nenach Tiixh. As tul nemaa vikabꞌal unqꞌa txakay ixojeꞌ. As yeꞌ netoksa setiꞌ. Estiꞌeꞌ uvaꞌ nimal chit u kꞌaxkꞌoeꞌ la ul setiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡As oyebꞌ chit evatz, ex fariseo tukꞌ ex uvaꞌ chusel etibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ! Tan ex kuxh kaꞌvatz. Tan katil kuxh nepalkat tiꞌ tok unqꞌa uxhchileꞌ sekꞌatz. As tul kat ok veꞌt tiꞌ inimal vechusbꞌaleꞌ, as pal chit veꞌt iviꞌ nibꞌan unqꞌa uxhchileꞌ setiꞌ. As eela ibꞌen tu u choobꞌal paaveꞌ setukꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Oyebꞌ chit evatz! Tan ech exeꞌ echeꞌ umaj u tzot uveꞌ nichꞌijin umaꞌt u tzot, tan ech netal ileꞌ: «Asoj abꞌil la tal umaj u tiila yol tiꞌ u tostiixheꞌ, as la kuxh uchi uvaꞌ yeꞌ la ibꞌaneꞌ uveꞌ kat tala. Pet asoj tiꞌ u ooroꞌeꞌ uveꞌ atoꞌk tu u tostiixheꞌ la talkat umaj u tiila yol, as techal la ibꞌaneꞌ,» chꞌex netaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Ex chit oonkon tukꞌ vetxumbꞌaleꞌ! ¡As ech exeꞌ echeꞌ tzot! ¿Ma yeꞌ nepal stuul uvaꞌ nim talchu u tostiixheꞌ tiꞌ u ooroꞌeꞌ, tan tiꞌ uvaꞌ atoꞌk tu u tostiixheꞌ, as txaatisamal veꞌt u ooroꞌeꞌ tiꞌ itxakonsal vatz u Tiixheꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","As netal unpajte uvaꞌ: «Asoj abꞌil la alon umaj u tiila yol tiꞌ u atinbꞌaleꞌ uveꞌ niyatzꞌpukat unqꞌa txooeꞌ vatz u tostiixheꞌ, as la uchi uvaꞌ yeꞌ la ibꞌaneꞌ uvaꞌ kat tala. Pet asoj tiꞌ unqꞌa txooeꞌ uveꞌ niyatzꞌpeꞌ viꞌ u atinbꞌaleꞌ la talkat umaj u tiila yol, as techal la ibꞌaneꞌ,» chꞌex netaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡As ech exeꞌ echeꞌ tzot, tan yeꞌl etxumbꞌal ati! ¿As ma yeꞌ ootzimal setaꞌn uvaꞌ nim talchu u atinbꞌaleꞌ uveꞌ niyatzꞌpukat unqꞌa txooeꞌ tiꞌ unqꞌa txooeꞌ uveꞌ niyatzꞌpeꞌ? Tan tiꞌ uvaꞌ viꞌ u atinbꞌaleꞌ niyatzꞌpukat unqꞌa txooeꞌ, as estiꞌeꞌ nitxakon veꞌt sevatz tul netal umaj u tiila yol tiꞌ veyoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","As tuk val sete uvaꞌ abꞌil uvaꞌ ni tal umaj u tiila yol tiꞌ u atinbꞌaleꞌ uveꞌ niyatzꞌpukat unqꞌa txooeꞌ as antu unqꞌa txooeꞌ uvaꞌ kat yatzꞌpu viꞌ u atinbꞌaleꞌ kat ok stuul. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","As abꞌil uvaꞌ ni tal umaj u tiila yol tiꞌ u tostiixheꞌ, as anteꞌ u Tiixheꞌ ni tok stuul, tan Aakeꞌ at tu u atinbꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","As abꞌil uvaꞌ ni tal umaj u tiila yol tiꞌ u almikaꞌeꞌ, as anteꞌ vixonlebꞌal Aakeꞌ ni tok stuul; as anteꞌ u Tiixheꞌ uvaꞌ xonleꞌl stuul. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡As oyebꞌ chit evatz, ex fariseo tukꞌ ex uvaꞌ chusel etibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ! Tan kaꞌvatz kuxh ex. As kꞌuxh netoya umaꞌl xoꞌl laval u uxhchꞌeꞌneꞌ te u Tiixheꞌ tukꞌ unqꞌa ijuꞌ u txꞌimayeꞌ tukꞌ unqꞌa kulaantoeꞌ, as yeꞌ nebꞌan uvaꞌ nim talcheꞌ vatz u Tiixheꞌ, tan yeꞌ nebꞌan u jikeꞌ vatz Aak. As mitaꞌn netxum ivatz unqꞌa uxhchileꞌ. As mitaꞌn nekꞌujbꞌaꞌ ekꞌuꞌl tiꞌ Aak. Tan bꞌaꞌneꞌ uvaꞌ yeꞌ la eyaꞌsa etoyeꞌ vatz Aak. As yeꞌ nebꞌan kaꞌt unqꞌa yoleꞌ uveꞌ nisaꞌ Aak uvaꞌ la bꞌanchi. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡As ech exeꞌ echeꞌ tzot tul neteqꞌo bꞌey vatz unqꞌa tenameꞌ! Tan netok ilil tiꞌ ebꞌanat uvaꞌ chꞌoo kuxhtuꞌ echeꞌ umaj u tal us uveꞌ la eesal el tiꞌ uvaꞌ yeꞌ la echbꞌuli. As tul yeꞌ netok ilil tiꞌ ebꞌanat unqꞌa vaaꞌ nim talcheꞌ. Eela kuxh tukꞌ uvaꞌ nebꞌiqꞌ umaj u camello. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡As oyebꞌ chit evatz, ex fariseo tukꞌ ex uvaꞌ chusel etibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ! As ex kuxh kaꞌvatz, tan ech bꞌanel etaꞌneꞌ echeꞌ umaj u picheel tukꞌ umaj u laj uvaꞌ aꞌ kuxh u tiꞌeꞌ nitxꞌaapeꞌ. As tul noonal tuul taꞌn tzꞌil. As ech bꞌan taꞌn vetxumbꞌaleꞌ taꞌn unqꞌa vaꞌlexheꞌ tukꞌ unqꞌa elaqꞌeꞌ uveꞌ nebꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡As ex fariseo, ech vetxumbꞌaleꞌ echeꞌ tzot! Pet ejalputaj vetxumbꞌaleꞌ bꞌaxa aqꞌal uvaꞌ ech la ebꞌaneꞌ echeꞌ umaj u picheel tukꞌ umaj u laj uvaꞌ bꞌaxel kat txꞌaap u tuuleꞌ. As aꞌn kat txꞌaap veꞌt u tiꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡As oyebꞌ chit evatz, ex fariseo tukꞌ ex uvaꞌ chusel etibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ! Tan ex kuxh kaꞌvatz. Tan ech vetxumbꞌaleꞌ echeꞌ ijulil kamnaj uvaꞌ vaꞌl chit ipolal u tiꞌeꞌ. As achaꞌv chit tiloneꞌ. Pet ech koj u tuuleꞌ, tan noonajlu veꞌt taꞌn ibꞌajil unqꞌa kamnajeꞌ. As vaꞌl chit ixeval u tuuleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","As ech bꞌanel taꞌn vetxumbꞌaleꞌ, tan chꞌiꞌumal chit ex vatz unqꞌa tenameꞌ. As ech koj vetaanxelaleꞌ, tan noonajlu kuxh taꞌn unqꞌa kaꞌvatzla chaj txumbꞌaleꞌ tukꞌ unqꞌa vaꞌlexheꞌ uveꞌ nebꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡As oyebꞌ chit evatz, ex fariseo tukꞌ ex uvaꞌ chusel etibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ! Tan ex kuxh kaꞌvatz, tan an chit ex ni lakon unqꞌa bꞌaꞌnla chaj oornoeꞌ uveꞌ mujelkat unqꞌa qꞌajsan tetz viyol u Tiixheꞌ. As nevej unqꞌa tzꞌajeꞌ uvaꞌ mujel kat unqꞌa jikla chaj aamaeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","As ech netal ileꞌ: «Atik koj chit oꞌeꞌ taꞌ naꞌytzan tul atik unqꞌa qꞌesla kubꞌaaleꞌ, as yeꞌl oꞌeꞌxh kat qoksa qibꞌ kꞌatz unqꞌa uxhchileꞌ tul kat iyatzꞌ unqꞌa qꞌajsan tetz viyol u Tiixheꞌ,» chꞌex netaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","As tukꞌ u yoleꞌ uvaꞌ netaleꞌ, as an chit ex ni alon uvaꞌ eqꞌomaltel vitxumbꞌal unqꞌa qꞌesla ebꞌaaleꞌ setaꞌn, uvaꞌ kat yatzꞌon unqꞌa qꞌajsan tetz viyol u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Estiꞌeꞌ tuk val sete, etzojpisataj kam uveꞌ kat ixeꞌtisa unqꞌa qꞌesla ebꞌaaleꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","tan ¡ech vetxumbꞌaleꞌ echeꞌ u txꞌiꞌlatxooeꞌ! ¿Kam qꞌi la ebꞌaneꞌ tiꞌ etooj vatz u kꞌaxkꞌoeꞌ uveꞌ tul setiꞌ, tul la bꞌen ex tu u choobꞌal paaveꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Tan tuk unchaj bꞌen kaꞌt unqꞌa qꞌajsan tetz vunyoleꞌ sexoꞌl, tukꞌ kaꞌt unqꞌa uxhchileꞌ uvaꞌ at itxumbꞌal, tukꞌ kaꞌt unqꞌa uxhchileꞌ uvaꞌ la chusun ex. As ati uvaꞌ tuk eyatzꞌeꞌ; as ati uvaꞌ tuk etaqꞌ jeꞌ vatz ikurus; as ati uvaꞌ tuk eqꞌoseꞌ tulaj unqꞌa atinbꞌaleꞌ tetz nachbꞌal Tiixh; as ati uvaꞌ tuk etilu el tulaj unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Estiꞌeꞌ tuk ulojkat u kꞌaxkꞌoeꞌ setiꞌ tukꞌ tiꞌ unqꞌa qꞌesla ebꞌaaleꞌ, tan tiꞌ uvaꞌ nimal unqꞌa najeꞌ kat eyatzꞌa uveꞌ jik chit itxumbꞌal. As aꞌ kat xeꞌtikkat tzan tiꞌ u Abel. As kat ul tiꞌ vikꞌaol u Berequías uvaꞌ Zacarías uvaꞌ kat yatzꞌpi vatz u tostiixheꞌ kꞌatz u atinbꞌaleꞌ uvaꞌ niyatzꞌpukat unqꞌa txooeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","As jik chit tuk val sete, tan jankꞌal uveꞌ ni valeꞌ as tuleꞌ setiꞌ, jankꞌal ex uvaꞌ ech vetxumbꞌaleꞌ echeꞌ u txꞌiꞌlatxooeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","¡Oyebꞌ chit evatz, ex aa Jerusalén, tan exeꞌ uvaꞌ kat yatzꞌon unqꞌa qꞌajsan tetz viyol u Tiixheꞌ! As kat esuti kꞌubꞌ tiꞌ unqꞌa uxhchileꞌ uvaꞌ kat ichaj tzan u Tiixheꞌ. As jatpajul kuxh kat val unmolat ex sunkꞌatz echeꞌ nibꞌan umaj u txutx akꞌatxeꞌ tukꞌ unqꞌa ineꞌeꞌ tul nijoji akꞌatx vineꞌeꞌ. As yeꞌ kat esaꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Estiꞌeꞌ ni val sete uvaꞌ tuk tzꞌinebꞌoj kan u tenameꞌ tukꞌ u tostiixheꞌ uvaꞌ at sexoꞌl. ");
INSERT INTO ixlNNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","As tuk val sete uvaꞌ jatu koj la etil veꞌt unvatz. Pet lanal ilej veꞌt u qꞌiieꞌ uvaꞌ ech la etal veꞌt ileꞌ sviꞌ: «¡Qoksataj iqꞌii Aak uveꞌ tul tukꞌ vibꞌii u Kubꞌaaleꞌ!» chaj veꞌt ex,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","As tul el chꞌuꞌl u Jesús tu tostiixheꞌ, as bꞌen veꞌt Aak. As jetzꞌen veꞌt ok unqꞌa ichusulibꞌ Aakeꞌ skꞌatz tiꞌ ikꞌuchat veꞌt chajnaj unqꞌa bꞌaꞌnla chaj kabꞌaleꞌ te Aak uvaꞌ seteꞌrumal tiꞌ u tostiixheꞌ staꞌn, tan achaꞌv chit tiloneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","As ech tal veꞌt u Jesús ileꞌ te chajnaj: —¿Ma achaꞌv chit tatin u tostiixheꞌ netileꞌ? Pet tuk val sete, uvaꞌ yeꞌl umaj sivan la kaa viꞌ umaꞌt sivan, tan kajayil chiteꞌ la eꞌpi,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","As bꞌen veꞌt u Jesús sijunal tukꞌ unqꞌa ichusulibꞌeꞌ viꞌ u vitzeꞌ uveꞌ Olivos. As tul xonlik veꞌt Aak, as jetzꞌen veꞌt ok unqꞌa ichusulibꞌ Aakeꞌ skꞌatz. As ech tal veꞌt chajnaj ileꞌ te Aak: —Pap, al sqe uvaꞌ jatu la ibꞌan uveꞌ naaleꞌ. ¿As kam kꞌuchbꞌal tetz u oolebꞌaleꞌ? ¿As kam la uchi tul uvaꞌ la ilej u qꞌiieꞌ tiꞌ itzojpisal skajayil uvaꞌ kꞌujlu kan?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ech tal veꞌt u Jesús ileꞌ: —Atoj chit enachbꞌal vatz unqꞌa chulin yoleꞌ aqꞌal uvaꞌ yeꞌ la maxtibꞌel ex, ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","tan nimal unqꞌa chulin yoleꞌ la ul tukꞌ vunbꞌiieꞌ. As la ul taleꞌ uvaꞌ: «Ineꞌ u Cristo,» chaj la taleꞌ. As nimal unqꞌa uxhchileꞌ la isotzsa ikꞌuꞌl. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","As la etabꞌi veꞌt yol tiꞌ unqꞌa chꞌaꞌoeꞌ uveꞌ la uchi as tiꞌ uvaꞌ la xeꞌt veꞌt chꞌaꞌo. Pet atoj enachbꞌal aqꞌal uvaꞌ yeꞌ la xoꞌv ex, tan techal chit la ibꞌaneꞌ. As tul la uch veꞌt unqꞌa veeꞌ ni val sete, as yeꞌxnaj ilejat u qꞌiieꞌ tiꞌ itzojpisal uvaꞌ kꞌujlu kan, ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","tan lanal ibꞌan unqꞌa nimla tenameꞌ chꞌaꞌo svatzaj. As lanal ibꞌan unqꞌa ijlenaaleꞌ chꞌaꞌo tukꞌ umaꞌt ijlenaal. As mamaꞌla chꞌoꞌm la tijma veꞌt unqꞌa uxhchileꞌ. As mamaꞌla vaꞌy la ibꞌaneꞌ. As katil kuxh la ibꞌankat kabꞌlaano. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","As ixeꞌtebꞌal kuxh unqꞌa kꞌaxkꞌoeꞌ uvaꞌ txumlebꞌal chit la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","As la eqꞌoloꞌk ex vatz unqꞌa bꞌooqꞌol tenameꞌ. As mamaꞌla kꞌaxkꞌo la epalebꞌe. As at ex la yatzꞌpu veꞌt ex, tan nimal chit unqꞌa uxhchileꞌ la ixvan ex tiꞌ uvaꞌ kꞌujleꞌl ekꞌuꞌl sviꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","As nimal unqꞌa uxhchileꞌ la teesa kan tibꞌ sviꞌ. As la kuxh ixoch tibꞌ svatzaj. As la ichiꞌansa tibꞌ taama svatzaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","As nimal unqꞌa uxhchileꞌ la toksa veꞌt tibꞌ qꞌajsan tetz viyol u Tiixheꞌ uveꞌ la taleꞌ. As nimal veꞌt unqꞌa uxhchileꞌ la isotzsa ikꞌuꞌl. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","As tiꞌ uvaꞌ mamaꞌla vaꞌlexh la ibꞌan vatz u txꞌavaꞌeꞌ, as nimal uxhchil yeꞌ la ixoꞌni veꞌt tibꞌ svatzaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pet abꞌil uvaꞌ yeꞌ la iyaꞌsa inimat in, kꞌuxh kam kuxh kꞌaxkꞌo la ipalebꞌe, as aꞌeꞌ uvaꞌ at itiichajil kꞌatz u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","As lanal paxsal unqꞌa bꞌaꞌnla yoleꞌ tulaj unqꞌa tenameꞌ skajayil tiꞌ uvaꞌ at u tenameꞌ jaqꞌ u tijleꞌm u Tiixheꞌ. As la sotz veꞌt u vatz txꞌavaꞌeꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Estiꞌeꞌ ni val sete, tul la etil tuch veꞌt u mam txumlebꞌaleꞌ uvaꞌ txojonbꞌal chittuꞌ uvaꞌ la bꞌanchi tu u bꞌaꞌnla atinbꞌaleꞌ uvaꞌ ninachpukat Tiixh, as la pal ex stuul, jankꞌal ex uvaꞌ la sikꞌlen u yoleꞌ, tan aꞌeꞌ uvaꞌ kat tal kan u qꞌajsan tetz viyol u Tiixheꞌ uvaꞌ Daniel. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","As tul la etil ixeꞌt u mam txumlebꞌaleꞌ, as jankꞌal ex uvaꞌ at ex tzitzaꞌ tu u Judea, as la ooj veꞌt ex tulaj unqꞌa koobꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","As jankꞌal ex uvaꞌ at jeꞌ ex viꞌ vekabꞌaleꞌ, as yeꞌ la kuꞌ veꞌt chꞌuꞌl ex tiꞌ ul eteqꞌot unqꞌa etetzeꞌ uveꞌ at tu vekabꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","As ex uvaꞌ at bꞌen ex tu vitz, as yeꞌ la qꞌaavik tzan ex tiꞌ ul eteqꞌot kaꞌt etoksaꞌm. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","As oyebꞌ chit evatz, ex ixoj uvaꞌ at eyaabꞌil tiꞌ etilat umaj etalaj intxaꞌ tukꞌ ex uvaꞌ nitel ichꞌuꞌun veneꞌeꞌ, tul la ul u kꞌaxkꞌoeꞌ setiꞌ tu u qꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Estiꞌeꞌ ni val sete, enachtaj chit Tiixh aqꞌal uvaꞌ jit tu u qꞌala as mitaꞌn tu umaj u xeem qꞌii tul uvaꞌ la ooj ex vatz u kꞌaxkꞌoeꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","tan tu unqꞌa qꞌiieꞌ, as mamaꞌla chit kꞌaxkꞌo la uli. As yeꞌ atixoj chit ibꞌan u kꞌaxkꞌoeꞌ echeꞌ u veeꞌ tul sichee u vatz txꞌavaꞌeꞌ. As echeꞌ latel koj ibꞌan unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","As yeꞌ koj la ichꞌoobꞌisa u Tiixheꞌ u kꞌaxkꞌoeꞌ, as yeꞌxhebꞌileꞌ la itxꞌoltel vatz u kꞌaxkꞌoeꞌ. Pet tiꞌ uvaꞌ nitxum Aak ivatz unqꞌa tenameꞌ uveꞌ txaael veꞌt taꞌn Aak, as estiꞌeꞌ tuk ichꞌoobꞌisa Aak u kꞌaxkꞌoeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Tan asoj abꞌil la alon sete uvaꞌ: «Il u Cristo ileꞌ at tzitzaꞌ» as moj «Ileꞌ at tziꞌleꞌ,» chaj chꞌelel ex, as enimaki. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tan at uxhchil la ul alon sete uvaꞌ: «Ineꞌ in Cristo» as moj «Ineꞌ in qꞌajsan tetz viyol u Tiixheꞌ,» chaj la tal sete. As la ibꞌan unqꞌa chulin yoleꞌ tetz echeꞌ unqꞌa kꞌuchbꞌal tetz viyakꞌil u Tiixheꞌ, uvaꞌ la teqꞌo taama unqꞌa tenameꞌ stiꞌ. As la imaxtibꞌe unqꞌa chulin yoleꞌ unqꞌa tenameꞌ. As la koj uchi, as anteꞌ unqꞌa itenam Aakeꞌ uveꞌ txaael taꞌn Aak la maxtibꞌeli. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pet ileꞌ kat val isuuchil sete bꞌaxa tul yeꞌxnaj ibꞌana, ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","tan asoj la alpu sete uvaꞌ: «Il u Cristo ileꞌ at tu u tzuukin txꞌavaꞌeꞌ,» chaj chꞌelel ex, as bꞌeniꞌk ex as moj: «Il u Cristo mujel tibꞌ tu umaꞌl u kabꞌal,» chaj chꞌelel ex, as enimaki. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","As ech u tulebꞌaleꞌ VIKꞌAOL U NAJEꞌecheꞌ uveꞌ nibꞌan u kayampaꞌleꞌ, tan naꞌl tibꞌuuqꞌebꞌal qꞌii as naꞌl tibꞌenebꞌal qꞌii. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","As la enima u yoleꞌ uvaꞌ ni val sete tiꞌ u vulebꞌaleꞌ echeꞌ enimat u yoleꞌ uvaꞌ ech ni tal ileꞌ: «Katil uveꞌ atkat umaj u txoo uvaꞌ kamnajle, as tzitziꞌ nimolkat tibꞌ unqꞌa quꞌseꞌ» tiꞌk u yoleꞌ uvaꞌ nenima. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","As tul kuxh la pal u kꞌaxkꞌoeꞌ tu unqꞌa qꞌiieꞌ, as la tokin veꞌt u qꞌiieꞌ. As yeꞌl veꞌt u ichꞌeꞌ la txijuni. As la chajpik veꞌt tzan unqꞌa txꞌumileꞌ tu almikaꞌ. As la iyiku veꞌt u Tiixheꞌ unqꞌa veeꞌ at tu almikaꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","As la ilax veꞌt kꞌuchbꞌal tetz u vulebꞌaleꞌ vatz u almikaꞌeꞌ, in VIKꞌAOL U NAJEꞌ. As kajayil chit unqꞌa tenameꞌ la txumun veꞌteꞌ tul la til vuleꞌ tu u suutzꞌeꞌ tukꞌ vunyakꞌileꞌ as la litzꞌloꞌlan u vulebꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tul la oqꞌsal umaꞌl u trompeta uvaꞌ saqꞌchibꞌal chit toqꞌeꞌ, as la unchaj veꞌt tzan unqꞌa ángel tiꞌ ul imolat unqꞌa tenameꞌ vatz u txꞌavaꞌeꞌ skajayil uvaꞌ txaael svaꞌn. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Estiꞌeꞌ ni val sete, eteesataj etexhlabꞌal tiꞌ u higuera, tan tul uvaꞌ vaꞌl ichaꞌxal unqꞌa iqꞌabꞌ tzeꞌeꞌ, as ni tel chꞌuꞌl unqꞌa ixaj tzeꞌeꞌ. As ootzimal veꞌt setaꞌn uvaꞌ saqꞌi tuk eloj veꞌteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Echat chit tuk ibꞌaneꞌ tiꞌ u vulebꞌaleꞌ, tan tul uvaꞌ la etil unqꞌa kꞌuchbꞌal tetz u vulebꞌaleꞌ skajayil uveꞌ ni val sete, as la pal veꞌt ex stuul uvaꞌ najli veꞌt u vulebꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","As jik chit tuk val sete, tan yeꞌxnaj sotz unqꞌa tenameꞌ uvaꞌ tiaal Israel vatz u txꞌavaꞌeꞌ tul la ibꞌan unqꞌa veeꞌ skajayil uveꞌ ni val sete, ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","tan la pal u almikaꞌeꞌ tukꞌ u vatz txꞌavaꞌeꞌ. Pet ech koj vunyoleꞌ, tan aꞌ chiteꞌ yeꞌ la pali. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yeꞌxhebꞌil ootzin tetz uvaꞌ kam qꞌiil as kam oora la ibꞌaneꞌ. As mitaꞌn unqꞌa ángel tu almikaꞌ. Pet taꞌn kuxh vunBꞌaaleꞌ ootzin tetz. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Tan kam chit uvaꞌ kat ibꞌan unqꞌa tenameꞌ tul uvaꞌ atik u Noé vatz u txꞌavaꞌeꞌ, as echat chit tuk ibꞌaneꞌ tul la ul in unpajte, in VIKꞌAOL U NAJEꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","tan tul uvaꞌ bꞌiitik kuxh tul u mam jabꞌaleꞌ tiꞌ unqꞌa tenameꞌ, as nikat itxꞌaꞌn unqꞌa tenameꞌ as nikat tukꞌaꞌ. As nikat teqꞌo tibꞌ tukꞌ tixqel. As ech kuxh nikat ibꞌan unqꞌa tenameꞌ tul kat ex ilej u qꞌiieꞌ uvaꞌ kat ok u Noé tu u barco. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","As yeꞌ nik titzꞌa unqꞌa tenameꞌ uvaꞌ la ul u kꞌaxkꞌoeꞌ stiꞌ. Pet ul veꞌt u mam jabꞌaleꞌ. As kam veꞌt unqꞌa tenameꞌ skajayil. As echat chit tuk ibꞌaneꞌ tul la ul in unpajte, in VIKꞌAOL U NAJEꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","As kaꞌvaꞌl unqꞌa najeꞌ uvaꞌ at bꞌen tu vitz, as umaꞌl naj la eqꞌoli; as umaꞌt naj la kaaik kan. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","As at kaꞌvaꞌl u ixoj uvaꞌ nicheꞌeneꞌ vatz kaꞌ. As umaꞌl ixoj la bꞌeni; as umaꞌt ixoj la kaaik kan. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Estiꞌeꞌ ni val sete, atoj enachbꞌal, tan yeꞌ etootza kam oora la ul in, in uvaꞌ in veBꞌooqꞌoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","As palojtaj ex tu unqꞌa yoleꞌ uvaꞌ ni val sete, tan asoj la tootzi u bꞌaal kabꞌaleꞌ uvaꞌ kam qꞌiil la ul u elqꞌomeꞌ tiꞌ tok tu u kabꞌaleꞌ, as echeꞌ la koj taqꞌ kan naj vikabꞌaleꞌ vatz u elqꞌomeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Estiꞌeꞌ ni val sete, ebꞌantaj chit etucheꞌ, tan aꞌ chiteꞌ yeꞌl sekꞌuꞌl tul uvaꞌ la ul VIKꞌAOL U NAJEꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","As ech la ebꞌaneꞌ echeꞌ umaj u kꞌam uvaꞌ kꞌujleꞌl ikꞌuꞌl u bꞌaal aqꞌoneꞌ stiꞌ, tan jik chit ni taqꞌonvu naj. As aꞌ najeꞌ uvaꞌ la ikꞌujbꞌaꞌ kan u bꞌaal aqꞌoneꞌ tiꞌ tilat unqꞌa tetzeꞌ. As najeꞌ la ilon uvaꞌ ma at techbꞌubꞌal unqꞌa kꞌameꞌ jun qꞌii. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","As tul la ul veꞌt vibꞌaal u aqꞌoneꞌ, as achvebꞌal chit tatin u kꞌameꞌ asoj jik chit kat inima naj u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","As jik chit tuk val sete, tan la toksa veꞌt u bꞌaal aqꞌoneꞌ u kꞌameꞌ ilol tetz unqꞌa tetzeꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pet asoj paasan tzii u ilol tetz unqꞌa kꞌameꞌ la ibꞌaneꞌ, as ech la tal jeꞌ u naj ileꞌ ste: «Yeꞌl u bꞌaal aqꞌoneꞌ la ul cheel,» chaj naj la taleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","As la xeꞌt naj tiꞌ iqꞌosax unqꞌa tetz kꞌamileꞌ, as la imolo veꞌt tibꞌ naj tukꞌ unqꞌa qꞌabꞌareeleꞌ. As la txꞌaꞌn naj; as la ukꞌaꞌ naj tukꞌ chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","As tul aꞌ la ul veꞌt u bꞌaal aqꞌoneꞌ tu u qꞌiieꞌ uvaꞌ yeꞌ ni titzꞌa naj uvaꞌ la ul u bꞌaal aqꞌoneꞌ, tan yeꞌ tootzaj naj uvaꞌ kam oora as kam qꞌiil la ul u bꞌaal aqꞌoneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","As la ul iqꞌos veꞌt u bꞌaal aqꞌoneꞌ naj. As ech ibꞌen veꞌt naj kꞌatz unqꞌa kaꞌvatzeꞌ. As tzitziꞌ la oqꞌkat veꞌt naj. As la ikꞌux veꞌt tibꞌ tee naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","As tul la ilej veꞌt u qꞌiieꞌ, as ech la ibꞌan unqꞌa uxhchileꞌ uvaꞌ nisaꞌ tok xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ echeꞌ nibꞌan laval unqꞌa qꞌopo ixoj. As bꞌex chaꞌma tu u nimla qꞌiieꞌ tiꞌ ikꞌulat umaꞌl u naj uvaꞌ la teqꞌo tibꞌ tukꞌ tixqel, as teqꞌo veꞌt unqꞌa qꞌopo ixojeꞌ u txijubꞌ tetzeꞌ sijununila tiꞌ ikꞌulat u tzumelaeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","As oꞌvaꞌl unqꞌa ixojeꞌ uvaꞌ yeꞌlik itxumbꞌal tiꞌ ibꞌanat tucheꞌ. Pet ech koj oꞌvaꞌte, tan atik itxumbꞌal chaꞌma tiꞌ ibꞌanat tucheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Unqꞌa ixojeꞌ uvaꞌ yeꞌlik itxumbꞌal tiꞌ ibꞌanat tucheꞌ, as kat teqꞌo veꞌt u txijubꞌ tetzeꞌ. Pet yeꞌl aceite tetz u txijubꞌ tetzeꞌ kat teqꞌo. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pet ech koj oꞌvaꞌt unqꞌa ixojeꞌ uvaꞌ atik itxumbꞌal, tan kat inoosa veꞌt chaꞌma u txijubꞌ tetzeꞌ tukꞌ aceite. As kat teqꞌo chaꞌma unbꞌiit aceite tu vixhaaloeꞌ unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","As bꞌalax veꞌt u tzumelaeꞌ tiꞌ tuleꞌ. Tul naꞌ veꞌt aqꞌbꞌal, as tzaa veꞌt ivataꞌm chaꞌma. As vat veꞌt chaꞌma. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Kamal pokꞌoꞌch chit aqꞌbꞌal as tabꞌi veꞌt chaꞌma umaꞌl u sikꞌiꞌm uvaꞌ ech tal ileꞌ: «¡Il u tzumela tuleꞌ! ¡Elojtaj chꞌuꞌl ex! ¡Bꞌen ekꞌultaj!» tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Oora chit txakpu laval unqꞌa ixojeꞌ tiꞌ ibꞌanat tuch u txijubꞌ tetzeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","As oꞌvaꞌl unqꞌa ixojeꞌ uveꞌ yeꞌlik itxumbꞌal tiꞌ ibꞌanat tucheꞌ, as ech tal chaꞌma ileꞌ te oꞌvaꞌt unqꞌa ixojeꞌ uvaꞌ atik vitxumbꞌaleꞌ: «Etaqꞌtaj unbꞌooj ku-aceite, tan il u txijubꞌ qetzeꞌ tuk tzaao veꞌteꞌ,» tiꞌk chaꞌma. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ech tal veꞌt oꞌvaꞌt unqꞌa ixoj ileꞌ: «Yeꞌle, tan yeꞌ la tzꞌaj veꞌt u ku-aceite. As mitaꞌn la tzꞌaji uvaꞌ la qaqꞌ etetz. Pet bꞌen eloqꞌtaj unbꞌooj etetz,» tiꞌk unqꞌa ixojeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","As bꞌex ichuk veꞌt oꞌvaꞌl unqꞌa ixojeꞌ vi-aceite. As tul atik bꞌen chaꞌma tiꞌ iloqꞌat vi-aceite, as bꞌex uloj u tzumelaeꞌ. As tul ok veꞌt u tzumelaeꞌ tu kabꞌal, as ok veꞌt oꞌvaꞌl unqꞌa ixojeꞌ uvaꞌ atik itxumbꞌal tiꞌ ibꞌanat tucheꞌ. As juplu veꞌt u tziꞌ kabꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","As unbꞌiil kuxh stuul, as ul veꞌt oꞌvaꞌt unqꞌa ixojeꞌ. As sikꞌin veꞌt ok chaꞌma vatz kabꞌal: «¡Bꞌan bꞌaꞌnil, pap! ¡Jajoꞌk oꞌ!» tiꞌk chaꞌma. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ech tal veꞌt el tzan u tzumela ileꞌ: «Jik chit tuk val sete, yeꞌ vootzaj ex,» tiꞌk u tzumelaeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Estiꞌeꞌ ni val sete, atoj enachbꞌal, tan yeꞌ etootza kam oora as kam qꞌiil la ul veꞌt VIKꞌAOL U NAJEꞌ vatz u txꞌavaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","As ech la ibꞌan tijleꞌm u Tiixheꞌ echeꞌ nibꞌan umaꞌl u bꞌaal aqꞌon uvaꞌ bꞌen veꞌt naach tu umaꞌt u tenam. As kat imolo veꞌt unqꞌa ikꞌameꞌ tiꞌ ijatxat veꞌt kan vipuajeꞌ te chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Umaꞌl u kꞌameꞌ kat aqꞌax kan oꞌvaꞌl mil puaj ste; as umaꞌte, as kaꞌvaꞌl mil kat kaa ste; as umaꞌte, as umaꞌt mil kat kaa ste. As junun chajnaj kat aqꞌax kan puaj ste tiꞌ uvaꞌ jankꞌal la olebꞌ chajnaj tiꞌ taqꞌonvaleꞌ. As kat bꞌen veꞌt u bꞌaal aqꞌoneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","As u kꞌameꞌ uveꞌ kat kꞌulun oꞌvaꞌl mil u puajeꞌ, as xeꞌt veꞌt naj aqꞌonvoj stukꞌ. As olebꞌ veꞌt naj tiꞌ itxꞌakat oꞌvaꞌt mil. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Echat chit kat ibꞌan u kꞌameꞌ uveꞌ kat kꞌulun kaꞌvaꞌl mil, as kat aqꞌonvu veꞌt naj tukꞌ u puajeꞌ. As kat itxꞌak veꞌt naj kaꞌvaꞌt mil. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pet ech koj u kꞌameꞌ uveꞌ kat kꞌulun umaꞌl mil, tan kat kuxh imuj veꞌt naj u puajeꞌ tu u txꞌavaꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Nimal qꞌii stuul, as ul veꞌt ibꞌaal u aqꞌoneꞌ. As xeꞌt tach veꞌt naj unqꞌa tetzeꞌ uvaꞌ kat ijatx kan te unqꞌa ikꞌameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Bꞌaxik chit ok veꞌt u kꞌameꞌ uveꞌ kat kꞌulun oꞌvaꞌl mil. As ikꞌuch veꞌt naj oꞌvaꞌl mil u puajeꞌ te ibꞌaal u aqꞌoneꞌ as tukꞌ oꞌvaꞌt mil uveꞌ itxꞌak naj tukꞌ u puajeꞌ. Ech tal veꞌt u kꞌam ileꞌ te u bꞌaal aqꞌoneꞌ: «Pap, oꞌvaꞌl mil u puajeꞌ uveꞌ kat aaqꞌ kan sve, as il oꞌvaꞌt mil ilaꞌ kat untxꞌak stukꞌ,» tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ech tal veꞌt u bꞌaal aqꞌon ileꞌ: «Bꞌaꞌn kuxheꞌ, tan axh bꞌaꞌnla aqꞌonvil. As tul jik chit kat abꞌana tukꞌ unbꞌiil u vetzeꞌ. As nimal u vetzeꞌ uvaꞌ la unkꞌujbꞌaꞌ veꞌt kan axh stiꞌ. Chiibꞌoj oꞌ tiꞌ uvaꞌ kat abꞌana,» tiꞌk u bꞌaal aqꞌoneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","As ok veꞌt umaꞌt u kꞌameꞌ uveꞌ kꞌulun kan kaꞌvaꞌl mil. As ech tal veꞌt naj ileꞌ: «Pap, kaꞌvaꞌl mil kat aaqꞌ kan sve. As il u puaj ilaꞌ tukꞌ kaꞌvaꞌt mil uvaꞌ kat untxꞌak stukꞌ,» tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ech tal veꞌt u bꞌaal aqꞌon ileꞌ te u kꞌameꞌ: «Bꞌaꞌn kuxheꞌ, tan axh bꞌaꞌnla aqꞌonvil. As tul jik chit kat abꞌana tukꞌ unbꞌiil u vetzeꞌ. As nimal u vetzeꞌ uvaꞌ la unkꞌujbꞌaꞌ veꞌt kan axh stiꞌ. Chiibꞌoj oꞌ tiꞌ uvaꞌ kat abꞌana,» tiꞌk u bꞌaal aqꞌoneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pet ech koj umaꞌt u kꞌameꞌ uvaꞌ umaꞌl kuxh mil puaj kat ikꞌula, tan tul ok veꞌt naj, as ech tal naj ileꞌ: «Pap, ootzimal axh svaꞌn uvaꞌ itzꞌaꞌjtu kuxh asaꞌ. As kꞌuxh jit axh kat avan, as najaj ivatz unqꞌa chikoeꞌ sqe uvaꞌ jit axh kat avan. As naaleꞌ uvaꞌ la amol unqꞌa veeꞌ uvaꞌ jit axh kat avan. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Estiꞌeꞌ kat xoꞌv in see. As kat bꞌex unmuj kan vapuajeꞌ tu txꞌavaꞌ. As il vapuaj ilaꞌ,» tiꞌk u kꞌameꞌ tal te u bꞌaal aqꞌoneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ech tal veꞌt u bꞌaal aqꞌon ileꞌ: «¡Axh kuxh umaꞌl u qꞌeꞌayla kꞌam, tan vaꞌlexh kuxh atxumbꞌal! Tan ootzimal in aꞌn uvaꞌ nunmol ivatz unqꞌa chikoeꞌ uvaꞌ jit in kat avan as nunmol unqꞌa veeꞌ uvaꞌ jit in avan tetz. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","As kat koj aaqꞌ vas unpuajeꞌ te unqꞌa uxhchileꞌ uvaꞌ ni taqꞌonvu tu u molbꞌal puajeꞌ. As aal koj chit unbꞌooj tal vunpuajeꞌ kat aaqꞌ sve tul kat ul in,» tiꞌk u bꞌaal aqꞌoneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","As ech tal veꞌt u bꞌaal aqꞌon ileꞌ te kaꞌt unqꞌa ikꞌameꞌ: «Emaataj umaꞌl mil te u najeꞌ. As etaqꞌtaj te u najeꞌ uveꞌ laval mil u tetzeꞌ ati, ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","tan abꞌil uvaꞌ at tetz, as aal la vaqꞌ veꞌt imaas u tetzeꞌ ste. Pet abꞌil uvaꞌ yeꞌl tetz ati, as aal la maap u tetzeꞌ uvaꞌ ati. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","As u kꞌameꞌ uvaꞌ yeꞌ kat ibꞌan uveꞌ kat val ste, as esutitaj bꞌen tu u qꞌej toktoeꞌ uvaꞌ la oqꞌkat veꞌteꞌ. As techal la ikꞌux veꞌt tibꞌ tee,» tiꞌk u bꞌaal aqꞌoneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","As tul la ul veꞌt VIKꞌAOL U NAJEꞌ vatz u txꞌavaꞌeꞌ, as aꞌ la xonebꞌ kat in viꞌ u xonlebꞌaleꞌ uvaꞌ nim talcheꞌ uvaꞌ nilitzꞌloꞌlaneꞌ tan xoꞌlamal in taꞌn unqꞌa ángel skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","As la molax veꞌt unqꞌa tenameꞌ skajayil sunvatz. As la unjatx veꞌt ixoꞌl unqꞌa tenameꞌ echeꞌ nibꞌan u xeen txooeꞌ, tan ni teesa el naj u kaneeroꞌeꞌ xoꞌl unqꞌa sikꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","As aꞌ la bꞌenkat unqꞌa kaneeroꞌeꞌ tisebꞌal. As ech ibꞌen unqꞌa sikꞌeꞌ timax, la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","As ech la val veꞌt ileꞌ te unqꞌa tenameꞌ uveꞌ echen tunsebꞌal, ineꞌ u Ijlenaaleꞌ: «Siꞌunaj sunkꞌatz, ex uvaꞌ bꞌaꞌn veꞌt eyolbꞌeleꞌ taꞌn vunBꞌaaleꞌ. As at veꞌt etokebꞌal xoꞌl unqꞌa tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ uvaꞌ bꞌanel veꞌt tuch setiꞌ taꞌn Aak tul uvaꞌ yeꞌxnik chee u vatz txꞌavaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","As tul nikat unvaꞌyeꞌ, as kat etaqꞌ untxꞌix; as tul nikat itzaj untziꞌ, as kat etaqꞌ vukꞌaꞌ; as tul kat unjaj unvatbꞌal sete, as kat etaqꞌ unvatbꞌal; ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","as tul yeꞌlik voksaꞌm, as kat etaqꞌ voksaꞌm; as tul nikat unchꞌoꞌneꞌ, as kat bꞌex eloch in; as tul uvaꞌ atik ok in tu u kaarsa, as kat bꞌex etil in,» chaj veꞌt in la val te unqꞌa tenameꞌ uvaꞌ echen tunsebꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","As ech la tal veꞌt unqꞌa tenam ileꞌ uvaꞌ echen tunsebꞌal uveꞌ jik chit itxumbꞌal: «¿Jatu tzan qꞌi, Pap, uvaꞌ nikat avaꞌyeꞌ as kat qaqꞌ atxꞌix; as nikat itzaj atziꞌ as kat qaqꞌ ookꞌaꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","as kat ajaj avatbꞌal as kat qaqꞌ avatbꞌal, as yeꞌlik ooksaꞌm as kat qaqꞌ ooksaꞌm, ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","as nikat achꞌoꞌneꞌ as kat bꞌex kuloch axh, as atik ok axh tu u kaarsa as kat bꞌex qil axh?» chaj veꞌt unqꞌa tenameꞌ la tal sve. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","As ech la val veꞌt ileꞌ te unqꞌa tenameꞌ uvaꞌ echen tunsebꞌal: «Tuk val sete, tan kam chit umaj bꞌaꞌnil kat ebꞌan te unqꞌa niman vetzeꞌ, kꞌuxh yeꞌl tijleꞌm ati, as ineꞌ taꞌ kat ebꞌan sve,» chaj veꞌt in la val ste, tan ineꞌ u Ijlenaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Pet ech koj unqꞌa tenameꞌ uveꞌ echen tunmax, tan ech la val veꞌt ileꞌ ste: «Kuxh el sunvatz, ex uvaꞌ yeꞌl veꞌt vibꞌaꞌnil vunBꞌaaleꞌ at setiꞌ. As ech ebꞌen tu u xamaleꞌ uveꞌ yeꞌl iyaꞌtebꞌal, uvaꞌ bꞌanel tucheꞌ uvaꞌ la bꞌenkat u txꞌiꞌlanajeꞌ tukꞌ unqꞌa ángel uvaꞌ echen kꞌatz naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","As tul nikat unvaꞌyeꞌ, as yeꞌ kat etaqꞌ untxꞌix; as tul nikat itzaj untziꞌ, as yeꞌ kat etaqꞌ vukꞌaꞌ; ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","as tul kat unjaj unvatbꞌal sete, as yeꞌ kat etaqꞌ unvatbꞌal; as tul yeꞌlik voksaꞌm, as yeꞌ kat etaqꞌ voksaꞌm; as tul nikat unchꞌoꞌneꞌ, as yeꞌ kat eloch in; as tul kat ok in tu u kaarsa, as yeꞌ kat bꞌex etil in,» chaj veꞌt in la val ste. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","As ech la tal veꞌt unqꞌa tenam ileꞌ sve: «¿Pap, jatu tzan qꞌi uvaꞌ yeꞌ kat kuloch axh tul nikat avaꞌyeꞌ, as nikat itzaj atziꞌ, as yeꞌlik ooksaꞌm, as chꞌoꞌm nik bꞌanon axh, as atik ok axh tu u kaarsa, as tul kat ajaj avatbꞌal sqe, as yeꞌ kat kuloch axh?» chaj veꞌt unqꞌa tenameꞌ la tal sve. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","As ech la val veꞌt ileꞌ: «Jik chit tuk val sete, tan kam u bꞌaꞌnileꞌ uveꞌ yeꞌ kat ebꞌan te unqꞌa niman vetzeꞌ, kꞌuxh yeꞌl tijleꞌm ati, as ineꞌ uveꞌ yeꞌ kat ebꞌan u bꞌaꞌnileꞌ sve,» chaj veꞌt in la valeꞌ, in uvaꞌ in u Ijlenaal. ");
INSERT INTO ixlNNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","As la bꞌen unqꞌa paasan tziieꞌ tiꞌ ipalebꞌet unqꞌa kꞌaxkꞌoeꞌ uvaꞌ yeꞌl iyaꞌtebꞌal. Pet ech koj veꞌt unqꞌa tenameꞌ uveꞌ jik chit itxumbꞌal, tan la bꞌen tu uveꞌ atkat vitiichajileꞌ uveꞌ yeꞌl iyaꞌtebꞌal,— tiꞌk u Jesús tal te unqꞌa ichusulibꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","As tul kuxh tal u Jesús unqꞌa yoleꞌ, as ech tal veꞌt Aak ileꞌ te unqꞌa ichusulibꞌeꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Ootzimal setaꞌn uvaꞌ kaꞌvaꞌt kuxh qꞌii tul u nimla qꞌiieꞌ uvaꞌ pascua. As la aqꞌax veꞌt ok VIKꞌAOL U NAJEꞌ tiqꞌabꞌ unqꞌa iqꞌesal unqꞌa tenameꞌ tiꞌ iyatzꞌpeꞌ vatz umaꞌl u kurus,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","As unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh, tukꞌ unqꞌa naj uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as tukꞌ kaꞌt unqꞌa bꞌaal tenam, as imol veꞌt tibꞌ chajnaj vatz iqꞌanal vikabꞌal unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh uvaꞌ Caifás. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","As ichuk veꞌt chajnaj txumbꞌal tiꞌ itxeypu u Jesús tukꞌ chuli yol. As la iyatzꞌ chajnaj Aak uvaꞌ nik taleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","As ech tal veꞌt chajnaj ileꞌ svatzaj: —Yeꞌ la txeypu naj cheel. Pet palnal u nimla qꞌiieꞌ, as aꞌn la txeypu veꞌt naj, aqꞌal uvaꞌ yeꞌ la veqꞌelkabꞌan unqꞌa tenameꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Atik u Jesús tu u Betania tu vikabꞌal u Simón uvaꞌ maꞌtik teesat Aak u chꞌaꞌk chineꞌ stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tul xonlik veꞌt ok Aak vatz u meexhaeꞌ, as bꞌex uloj umaꞌl u ixoj kꞌatz Aak uvaꞌ eqꞌomalik txꞌumtxꞌulla tzꞌakabꞌal staꞌn uvaꞌ jeꞌnal chit ijaꞌmil, tu umaꞌl u bꞌaꞌnla lemeeta. As ipeqꞌ veꞌt jeꞌ u ixoj u txꞌumtxꞌulla tzꞌakabꞌaleꞌ tiꞌ iviꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","As tul til unqꞌa ichusulibꞌ Aakeꞌ, as ul veꞌt iviꞌ chajnaj. Ech tal veꞌt chajnaj ileꞌ: —¿Kam itxaꞌk u bꞌaꞌnla tzꞌakabꞌaleꞌ kat kuxh ipeqꞌ jeꞌ ixoj tiꞌ iviꞌ Aak? ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Pet kꞌayimal koj kat bꞌanaxi, tan nimal puajeꞌ taꞌ vijaꞌmil u tzꞌakabꞌaleꞌ. As te koj unqꞌa meebꞌaꞌeꞌ kat aqꞌaxkat,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ootzimal veꞌt taꞌn u Jesús uveꞌ kam nikat tal unqꞌa ichusulibꞌ Aakeꞌ. As ech tal veꞌt Aak ileꞌ: —¿Kam qꞌi uvaꞌ kam kuxh netal tiꞌ u ixojeꞌ? Tan bꞌaꞌneꞌ taꞌ uveꞌ kat ibꞌan ixoj sve. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","At chiteꞌ unqꞌa meebꞌaꞌeꞌ sexoꞌl. Pet ech koj in, tan echeꞌ bꞌenameen koj tuk atinoj in sexoꞌl. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","As u txꞌumtxꞌulla tzꞌakabꞌaleꞌ uvaꞌ kat ipeqꞌ jeꞌ u ixojeꞌ tiꞌ unviꞌ, as bꞌanel vucheꞌ kat ibꞌanlu veꞌt ixoj tiꞌ unmujleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","As jik chit tuk val sete, tan katil uvaꞌ la paxsalkat u bꞌaꞌnla yoleꞌ sviꞌ vatz u txꞌavaꞌeꞌ, as la paxsal itzibꞌlal u bꞌaꞌnileꞌ uvaꞌ kat ibꞌan u ixojeꞌ sve tiꞌ tulsat unqꞌa tenameꞌ skꞌuꞌl uvaꞌ kat ibꞌan u ixojeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","U Judas uvaꞌ Iscariote, as najeꞌ uveꞌ atik ok xoꞌl kabꞌlaval unqꞌa ichusulibꞌ u Jesús, as bꞌex til veꞌt naj unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","As ech bꞌex tal naj ileꞌ te chajnaj: —¿Kam la etaqꞌ sve as la vaqꞌoꞌk u Jesús teqꞌabꞌ?— tiꞌk naj. As taltziꞌ veꞌt chajnaj vinaj laval (30) saj chꞌichꞌ puaj te naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","As xeꞌt veꞌt naj tiꞌ ichukat txumbꞌal tiꞌ taqꞌat ok u Jesús tiqꞌabꞌ chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","As tu veꞌt u bꞌaxa qꞌii tetz u nimla qꞌiieꞌ tul uvaꞌ nik itxꞌaꞌp u paaneꞌ uvaꞌ yeꞌl levadura nikuꞌ sxoꞌl, as jetzꞌen veꞌt ok unqꞌa ichusulibꞌ u Jesús skꞌatz. As ech tal veꞌt chajnaj ileꞌ te Aak: —¿Katil nasaꞌkat uvaꞌ la bꞌen kubꞌankat tuch u txꞌaꞌoꞌmeꞌ uveꞌ tetz u nimla qꞌiieꞌ tiꞌ kunimataꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ech tal veꞌt Aak ileꞌ te chajnaj: —Bꞌenoj ex tu u tenameꞌ xeꞌ u uxhchileꞌ uvaꞌ ootzimal setaꞌn. As ech la bꞌen etal ileꞌ ste: «Ech ni tal u chusul qetz ileꞌ: –Najli veꞌt u qꞌiieꞌ uvaꞌ kꞌujlu kan sviꞌ. As la txꞌaꞌn in takabꞌal tukꞌ unqꞌa unchusulibꞌeꞌ tiꞌ inimal u nimla qꞌiieꞌ,– taqꞌ Aak ni taleꞌ,» chaj ex la bꞌen etal ste,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","As bꞌex ibꞌan veꞌt chajnaj kam uveꞌ tal Aak te chajnaj. As ibꞌan veꞌt chajnaj tuch u txꞌaꞌoꞌmeꞌ tiꞌ u nimla qꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","As tul tzꞌotin veꞌteꞌ, as xonebꞌ veꞌt u Jesús vatz u meexhaeꞌ tukꞌ kabꞌlaval unqꞌa ichusulibꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","As tul nikat itxꞌaꞌn Aak tukꞌ chajnaj, as ech tal veꞌt Aak ileꞌ: —Jik chit tuk val sete, tan at umaꞌl ex uvaꞌ tuk aqꞌon ok in tiqꞌabꞌ unqꞌa iqꞌesal unqꞌa tenameꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","As yak kuxh txumun veꞌt chajnaj. As ech tal veꞌt chajnaj ileꞌ sijununila: —¿Ma jit in naal in, Pap?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","As ech tal veꞌt u Jesús ileꞌ: —Abꞌil ex uveꞌ tuk ejil kuꞌ vepaaneꞌ tu u lajeꞌ sunkꞌatz, as aꞌ exeꞌ la aqꞌon ok in tiqꞌabꞌ unqꞌa iqꞌesal unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","As jik chit la val sete, tan kam chit uveꞌ tzꞌibꞌamal kan tiꞌ VIKꞌAOL U NAJEꞌ, as aꞌeꞌ uveꞌ tuk unpalebꞌe. ¡Pet oyebꞌ chit ivatz u najeꞌ uveꞌ tuk aqꞌon ok in tiqꞌabꞌ unqꞌa iqꞌesal unqꞌa tenameꞌ! Tan aal bꞌaꞌneꞌ uvaꞌ jit koj itzꞌebꞌ naj vatz u txꞌavaꞌeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","As ech tal veꞌt u Judas ileꞌ uvaꞌ nik chukun txumbꞌal tiꞌ toksal ok Aak: —¿Chusul, ma jit in uveꞌ naaleꞌ?— tiꞌk naj te u Jesús. —Il axh kat aallu eebꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","As tul aalik itxꞌaꞌn veꞌt u Jesús tukꞌ unqꞌa ichusulibꞌeꞌ, as itxey veꞌt Aak u paaneꞌ. As taqꞌ veꞌt Aak taꞌntiixh stiꞌ. As ijatx veꞌt Aak; as taqꞌ veꞌt Aak te chajnaj. As ech tal veꞌt Aak ileꞌ: —Ekꞌultaj; as etxꞌaꞌtaj, tan aꞌeꞌ vunchiꞌoleꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","As itxey veꞌt u Jesús u koopa. As taqꞌ veꞌt Aak taꞌntiixh stiꞌ. As taqꞌ veꞌt ok Aak te chajnaj. As ech tal veꞌt Aak ileꞌ: —Etukꞌataj sekajayil, ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","tan aꞌ vunkajaleꞌ uvaꞌ tuk jejon kan u akꞌ tzaqꞌiteꞌ tiꞌ ikꞌulat tibꞌ iyol u tenameꞌ tukꞌ u Tiixheꞌ, tan tuk eloj vunkajaleꞌ tiꞌ unsotzsat ipaav unqꞌa tenameꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","As tuk val sete, tan yeꞌxh jatu la vukꞌa veꞌt u taꞌl u uuvaeꞌ echeꞌ u vaaꞌ nu kubꞌan cheel. Pet lanal ilej veꞌt u qꞌiieꞌ uvaꞌ la ilpu veꞌteꞌ uvaꞌ at veꞌt unqꞌa tenameꞌ jaqꞌ u tijleꞌm vunBꞌaaleꞌ. As aꞌn la vukꞌa veꞌt u taꞌl u akꞌ uuvaeꞌ setukꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","As tul yaꞌ veꞌt ibꞌitzal u bꞌitzeꞌ, as bꞌen veꞌt u Jesús tukꞌ unqꞌa ichusulibꞌeꞌ viꞌ u vitzeꞌ uvaꞌ Olivos. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ech tal veꞌt u Jesús ileꞌ: —Tu u aqꞌbꞌalaꞌ as tuk kaꞌkabꞌinoj etaama sviꞌ, tan ech ni tal u yol ileꞌ uvaꞌ tzꞌibꞌamal kan: La unkꞌaxbꞌisa veꞌt u xeen txooeꞌ. As katil kuxh la oojkat veꞌt unqꞌa kaneeroꞌeꞌ, tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","As tul la ul veꞌt vaama unpajte, as bꞌaxel la oon in sevatz tu u Galilea,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","As ech tal veꞌt u Luꞌ ileꞌ te u Jesús: —Pap, kꞌuxh la kaꞌkabꞌin taama unqꞌa unmooleꞌ skajayil seeꞌ, ech koj in tan yeꞌxh jatu la kaꞌkabꞌin vaama seeꞌ,— tiꞌk u Luꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ech tal u Jesús ileꞌ: —As jik chit tuk val see, Luꞌ: Tan tu u aqꞌbꞌalaꞌ tul yeꞌxnaj oqꞌ u peleꞌxheꞌ, as oxpajul maꞌt eesat eebꞌ sunkꞌatz,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","As ech tal u Luꞌ ileꞌ: —Pap, asoj la alpu akameꞌ, as eela kukameꞌ la kam oꞌ, tan ineꞌ yeꞌ la veesa kan vibꞌ sakꞌatz,— tiꞌk u Luꞌeꞌ. As echat chit tal unjoltu unqꞌa ichusulibꞌ Aakeꞌ skajayil echeꞌ uveꞌ tal u Luꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","As bꞌen veꞌt u Jesús tukꞌ unqꞌa ichusulibꞌeꞌ tu umaꞌl u atinbꞌal uvaꞌ Getsemaní. Ech tal veꞌt Aak ileꞌ te chajnaj: —Maꞌt unnach Tiixh tziꞌleꞌ. As xonebꞌoj kan ex tzitzaꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Teqꞌo veꞌt Aak u Luꞌeꞌ stiꞌ tukꞌ kaꞌvaꞌt vikꞌaol u Zebedeo. As ok veꞌt umaꞌl u mam txumuꞌm xeꞌ taama Aak tukꞌ xaanchil aama. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","As ech tal veꞌt Aak ileꞌ te oxvaꞌl unqꞌa ichusulibꞌeꞌ: —¡Ootzimal svaꞌn uvaꞌ tuk kamoj in! ¡As vaꞌl chit itxumun veꞌt vaama! Pet kaaoj kan ex tzitzaꞌ. Isebꞌojtaj chit ex tiꞌ enachat Tiixh sunkꞌatz,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","As jetzꞌen veꞌt el unbꞌiil u Jesús kꞌatz chajnaj. Qaaebꞌ veꞌt Aak techal toon ivatz Aak tu txꞌavaꞌ. As ech tal veꞌt Aak ileꞌ tul inach Aak Tiixh: —UnBꞌaal, asoj la uchi, as eesa el in vatz u kꞌaxkꞌoeꞌ uvaꞌ kꞌujlu kan sviꞌ. As jit in la alon. Pet axh la alon kam uvaꞌ la unbꞌaneꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","As tul qꞌaavik tzan u Jesús kꞌatz oxvaꞌl unqꞌa ichusulibꞌeꞌ, as vatik veꞌt chajnaj. As ech tal veꞌt Aak ileꞌ te u Luꞌeꞌ: —¿Ma yeꞌ nekuy umaj oora uvaꞌ la isebꞌ ex sunkꞌatz? ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Isebꞌoj chit ex. As enachtaj chit Tiixh aqꞌal uvaꞌ la iyakꞌinsa Aak u kꞌujlebꞌal ekꞌuꞌleꞌ sviꞌ tul la chukax txumbꞌal setiꞌ tiꞌ eteesal sunkꞌatz. As kꞌuxh ayaꞌl chit ikꞌuꞌl vetaanxelaleꞌ tiꞌ enachat Tiixh, as ech koj vechiꞌoleꞌ, tan yeꞌ nisaꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","As bꞌex inach veꞌt u Jesús Tiixh tikaꞌpa. As ech tal veꞌt Aak ileꞌ: —UnBꞌaal, asoj yeꞌ la ibꞌaneꞌ uvaꞌ la akol in vatz u kꞌaxkꞌoeꞌ, as ibꞌana kam uveꞌ kꞌujlu kan sviꞌ aꞌn,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","As tul qꞌaavik veꞌt tzan Aak kꞌatz unqꞌa ichusulibꞌeꞌ, as vatik veꞌt chajnaj unpajte, tan atik vataꞌm tivatz chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","As taqꞌ veꞌt kan u Jesús chajnaj. As bꞌex inach Aak Tiixh titoxpa. As an chit viyol Aakeꞌ tala uvaꞌ tal bꞌaxa. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","As qꞌaavik tzan Aak kꞌatz unqꞌa ichusulibꞌeꞌ unpajte. As ech tal veꞌt Aak ileꞌ: —¿Antel kuxh vatik ex bꞌa? ¿As iꞌlichil kuxh nebꞌaneꞌ? As tul kat ilejlu veꞌt u ooraeꞌ uvaꞌ tuk aqꞌaxoj ok VIKꞌAOL U NAJEꞌ tiqꞌabꞌ unqꞌa aapaaveꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Pet txakpoj ex! ¡Koꞌnaj! Tan il u naj ileꞌ tul veꞌteꞌ uveꞌ tuk aqꞌon ok in tiqꞌabꞌ unqꞌa aapaaveꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","As antelik kuxh iyolon u Jesús tul bꞌex oonoj u Judas uveꞌ atik ok xoꞌl kabꞌlaval unqꞌa ichusulibꞌ Aakeꞌ. As aꞌ chit mamaꞌla tenameꞌ eqꞌomalik chꞌichꞌ tukꞌ tzeꞌ staꞌn uvaꞌ xekik tiꞌ u Judas, tan aꞌ unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh tukꞌ kaꞌt unqꞌa bꞌaal tenameꞌ uvaꞌ chajon bꞌen unqꞌa uxhchileꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","tan maꞌtik taqꞌat u Judas itxumbꞌal chajnaj uvaꞌ kam la ibꞌan chajnaj tul la bꞌen ilej chajnaj u Jesús. Ech tal naj ileꞌ: —Abꞌil uveꞌ la untzꞌubꞌ txala itziꞌ, as aꞌ najeꞌ uveꞌ la etxeyeꞌ,— tiꞌk u Judas tala. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","As yak kuxh jetzꞌen veꞌt ok u Judas kꞌatz u Jesús. Ech tal veꞌt naj ileꞌ: —¡Tixen, Chusul!— tiꞌk naj. As itzꞌubꞌ veꞌt ok naj txala itziꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ech tal veꞌt Aak ileꞌ te u Judas: —Vetz kꞌultziꞌ, bꞌana kam uveꞌ eqꞌomal taꞌn aama,— tiꞌk u Jesús tal te naj. As loqꞌ chit ul ixaꞌpu veꞌt unqꞌa uxhchileꞌ u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","As tzaa veꞌt umaꞌl vichusulibꞌ u Jesús. As teqꞌo veꞌt jeꞌ tzan naj vichꞌichꞌeꞌ tu totzotz. As itzokꞌ veꞌt el naj ixikin umaꞌl vikꞌam viqꞌesal oksan iyol tenam vatz Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","As ech tal veꞌt u Jesús ileꞌ te naj: —¡Kol kuꞌ vachꞌichꞌeꞌ tu u totzotzeꞌ! Tan jankꞌal unqꞌa uxhchileꞌ uveꞌ ni bꞌanon chꞌaꞌo tukꞌ chꞌichꞌ, as an chit tukꞌ chꞌichꞌ la yatzꞌpukat. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Tan ma yeꞌl sakꞌuꞌl uvaꞌ la uch unjajat bꞌaꞌnil te vunBꞌaaleꞌ scheel, as la ichaj tzan Aak kaꞌbꞌlavoj mil unqꞌa ángel tiꞌ ul ilochat in? ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pet asoj la unjaj te Aak, as yeꞌle uveꞌ la ibꞌaneꞌ kam uveꞌ tzꞌibꞌamal kan sviꞌ. Pet techal chit tuk ibꞌaneꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","As ech tal veꞌt u Jesús ileꞌ te unqꞌa najeꞌ: —¿Kam qꞌi uveꞌ eqꞌomal chꞌichꞌ setaꞌn tukꞌ tzeꞌ tiꞌ ul etxeyat in? ¿In kol umaj u elqꞌom qꞌa? As tul jun qꞌii atik in sexoꞌl tiꞌ unchusuneꞌ tu unqꞌa atinbꞌaleꞌ uvaꞌ at tu u tostiixheꞌ. As yeꞌl in kat etxey in. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pet ech chit tuk ibꞌaneꞌ kam uveꞌ tzꞌibꞌamal kan sviꞌ taꞌn unqꞌa qꞌajsan tetz viyol u Tiixheꞌ,— tiꞌk u Jesús. As tul tabꞌi veꞌt unqꞌa ichusulibꞌ Aakeꞌ, as ooj veꞌt chajnaj skajayil. As taqꞌ veꞌt kan chajnaj Aak sijunal xoꞌl unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","As tul itxey veꞌt unqꞌa tenameꞌ u Jesús, as bꞌex toksa veꞌt ok chajnaj Aak vatz u Caifás, viqꞌesal oksan iyol tenam vatz Tiixh, tu uveꞌ kꞌulikkat tibꞌ kaꞌl unqꞌa uxhchil uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as tukꞌ kaꞌt unqꞌa bꞌaal tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","As ech koj u Luꞌeꞌ, tan naach kuxh xekelikkat naj tiꞌ u Jesús techal toon veꞌt naj vatz iqꞌanal u Caifás. As xonlik veꞌt ok u Luꞌeꞌ kꞌatz kaꞌl unqꞌa xeen tetz u tostiixheꞌ tiꞌ tilat naj uvaꞌ kam tuk ulbꞌeloj u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","As unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh, tukꞌ kaꞌt unqꞌa bꞌanol isuuchil unqꞌa tenameꞌ, as tukꞌ kaꞌt unqꞌa bꞌaal tenameꞌ, as ibꞌan veꞌt umaꞌl u nukꞌu tiꞌ ichukat chajnaj txumbꞌal tukꞌ kaꞌt unqꞌa cheesan paaveꞌ tiꞌ uvaꞌ la yatzꞌpu veꞌt u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","As yeꞌlik iyakꞌil u cheesan paaveꞌ uvaꞌ nik tal unqꞌa uxhchileꞌ. As kꞌuxh nimal unqꞌa uxhchileꞌ oon xoꞌl chajnaj tiꞌ icheesal ipaav Aak, as jit olebꞌ chajnaj tukꞌ u cheesan paaveꞌ tiꞌ uvaꞌ la yatzꞌpu veꞌt Aak. Pet oonnal veꞌt kaꞌvaꞌt chulin yol ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","uvaꞌ ech kat tal ileꞌ: —Ech tal u naj ileꞌ: «La olebꞌ in tiꞌ veꞌpisat u tostiixheꞌ. As tu kuxh oxvaꞌl qꞌii la unlakkat unpajte,» tiꞌk naj tala,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","As txakpu veꞌt viqꞌesal oksan iyol tenam vatz Tiixh. As ech tal veꞌt naj ileꞌ te u Jesús: —¿Kam qꞌi uveꞌ yeꞌ natiineꞌ? ¿As kam ni tal axh tiꞌ unqꞌa yoleꞌ uveꞌ ni tal chajnaj seeꞌ?— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","As yeꞌl u Jesús tiini. As ech tal veꞌt naj ileꞌ unpajte: —As tukꞌ vibꞌii u islich Tiixheꞌ tuk val see, ¡Al sqe! ¿Ma axh u Cristo, viKꞌaol u Tiixheꞌ?— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ech tal veꞌt u Jesús ileꞌ: —An chiteꞌ uvaꞌ kat aala. Tan la ilej umaꞌl u qꞌii uvaꞌ la etil veꞌt VIKꞌAOL U NAJEꞌ tul uvaꞌ la xonebꞌ veꞌt isebꞌal u Tiixheꞌ uveꞌ nim chit tijleꞌm. As la etil ikuꞌ veꞌt chꞌuꞌl xoꞌl u suutzꞌeꞌ tu almikaꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","As tul tabꞌi viqꞌesal u oksan iyol tenam vatz Tiixh u yoleꞌ uvaꞌ tal u Jesús, as iqꞌix veꞌt naj u toksaꞌmeꞌ. As ech tal veꞌt naj ileꞌ: —¡Kat toksa tibꞌ u najeꞌ Tiixhil! ¡Jit tzꞌajinal la kuchꞌoti te umaꞌtoj uxhchil, tan ileꞌ kat etabꞌilaꞌ! ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿As kam ni tal ex tiꞌ viyol najeꞌ?— tiꞌk naj. Ech tal veꞌt unqꞌa uxhchil ileꞌ: —¡Tetz veꞌt naj u kamchileꞌ tiꞌ viyoleꞌ!— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","As at uxhchil tzubꞌan veꞌt ivatz u Jesús; as at uxhchil topon veꞌt Aak taꞌn qꞌabꞌ. As at uxhchil tzꞌichon ivatz Aak taꞌn qꞌabꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","As ech tal ileꞌ te Aak: —Axh uvaꞌ nooksa eebꞌ Cristo, asoj axh qꞌajsan tetz viyol u Tiixheꞌ, as qꞌiia uvaꞌ abꞌil kat qꞌoson axh,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","As tul xonlik u Luꞌeꞌ vatz qꞌanal, as jetzꞌen veꞌt ok umaꞌl u aaichꞌ kꞌatz naj. As ech tal veꞌt ixoj ileꞌ te u Luꞌeꞌ: —Antik axheꞌ molonik eebꞌ tukꞌ u Jesús, u aa Galilea,— tiꞌk ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","As tal veꞌt u Luꞌeꞌ vatz unqꞌa uxhchileꞌ skajayil uvaꞌ yeꞌ tootzaj naj u Jesús. Ech tal naj ileꞌ: —Yeꞌ vootzaj uveꞌ naaleꞌ,— tiꞌk u Luꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","As jetzꞌen veꞌt bꞌen u Luꞌeꞌ kꞌatz u nimla tziꞌ kabꞌaleꞌ. As ilchu naj taꞌn umaꞌt u aaichꞌ. As ech tal veꞌt ixoj ileꞌ xoꞌl unqꞌa tenameꞌ: —Antik u najeꞌ xekik tiꞌ u Jesús, u aa Nazaret,— tiꞌk ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ech tal veꞌt u Luꞌ ileꞌ tukꞌ viBꞌii u Tiixheꞌ: —¡Yeꞌ vootzaj u najeꞌ uveꞌ naaleꞌ!— tiꞌk u Luꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Unbꞌiil kuxh stuul, as jetzꞌen veꞌt ok unqꞌa uxhchileꞌ kꞌatz u Luꞌeꞌ. As ech tal veꞌt unqꞌa uxhchil ileꞌ te u Luꞌeꞌ: —An chiteꞌ vil amool eebꞌeꞌ tukꞌ u Jesús, tan aꞌ vayoloneꞌ ni kꞌuchun,— tiꞌk unqꞌa uxhchileꞌ uvaꞌ molik tibꞌ vatz iqꞌanal viqꞌesal oksan iyol tenam vatz Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","As ech tal veꞌt u Luꞌ ileꞌ: —¡Asoj nu kuxh unchuli yol sevatz, as sviꞌ la ulkat u vaꞌlexheꞌ, tan vatz u Tiixheꞌ ni valkat uvaꞌ yeꞌ vootzaj u najeꞌ uveꞌ netaleꞌ!— tiꞌk u Luꞌeꞌ. As tul nik tal naj u yoleꞌ, as bꞌex oqꞌoj veꞌt u peleꞌxheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","As jubꞌin veꞌt tul viyol u Jesús skꞌuꞌl u Luꞌeꞌ uvaꞌ maꞌtik talat Aak: «Tul yeꞌxnaj oqꞌ u peleꞌxheꞌ cheel tu aqꞌbꞌalaꞌ, as oxpajul maꞌt eesat eebꞌ sunkꞌatz,» tiꞌk Aak. As el veꞌt chꞌuꞌl u Luꞌeꞌ vatz u qꞌanaleꞌ. As aꞌ chit oqꞌeleꞌ ibꞌan veꞌt naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","As tul sajbꞌu veꞌteꞌ, as ikꞌul veꞌt tibꞌ unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh tukꞌ kaꞌt unqꞌa bꞌaal tenameꞌ. As ikꞌul veꞌt tibꞌ iyol chajnaj uvaꞌ techal la yatzꞌpu veꞌt u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","As iqitz veꞌt chajnaj iqꞌabꞌ Aak. As teqꞌo veꞌt ok chajnaj Aak vatz u Poncio Pilato uvaꞌ nik bꞌanon ivatz u ijlenaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","As tul til u Judas uvaꞌ kꞌayin u Jesús uvaꞌ la yatzꞌpu veꞌt u Jesús, as ijalpu veꞌt naj vitxumbꞌaleꞌ. As bꞌex iqꞌaavisa veꞌt kan naj vinaj laval u puajeꞌ te unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh tukꞌ unqꞌa bꞌaal tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ech tal veꞌt naj ileꞌ te chajnaj: —Kat paavinyu veꞌt in, tan yeꞌl ipaav u najeꞌ ati. As kat kuxh voksa ok naj teqꞌabꞌ,— tiꞌk u Judas. As ech tal veꞌt chajnaj ileꞌ: —¿At kol qokebꞌal qꞌa stiꞌ? Pet axh kuxheꞌ la ilon kam tuk abꞌaneꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","As isuti veꞌt kan u Judas u puajeꞌ tu u tostiixheꞌ. As bꞌen veꞌt naj. As ichꞌuybꞌaꞌ veꞌt tibꞌ naj. As kam veꞌt naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","As isikꞌ veꞌt unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh u puajeꞌ. As ech tal veꞌt chajnaj ileꞌ: —Yeꞌ la uch qoksat ok u puajeꞌ xoꞌl unqꞌa oyeꞌ uvaꞌ at tu u kaaxhaeꞌ, tan kajal nixaan taꞌn u puajeꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","As tul bꞌaꞌnxi tiꞌ ikꞌulat tibꞌ iyol chajnaj, as bꞌex iloqꞌ veꞌt chajnaj umaꞌl u txꞌavaꞌ xeꞌ umaꞌl u naj uvaꞌ ni bꞌanon tzꞌaj laj. As txakonsal veꞌt u txꞌavaꞌeꞌ mujbꞌal tetz unqꞌa uxhchileꞌ uvaꞌ jit tiaal Israel. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Estiꞌeꞌ uvaꞌ nitel talpu cheel uvaꞌ tiꞌ kajal loqꞌpukat u txꞌavaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","As bꞌex ibꞌan veꞌt umaꞌt u yol uvaꞌ alel kan taꞌn u qꞌajsan tetz viyol u Tiixheꞌ uvaꞌ Jeremías, tan ech tal u Jeremías ileꞌ: As teqꞌo veꞌt chajnaj vinaj laval u puajeꞌ, vijaꞌmil umaꞌl u uxhchil uvaꞌ nim talchu xoꞌl unqꞌa tiaal Israel, tan ech vijaꞌmileꞌ uvaꞌ kꞌujlu kan taꞌn unqꞌa tiaal Israel. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","As kat txakonsali tiꞌ iloqꞌax vitxꞌavaꞌ umaꞌl u bꞌanol tzꞌaj laj echeꞌ uveꞌ kat tal u kuBꞌooqꞌoleꞌ sve, tiꞌk u Jeremías. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","As tul txaklik veꞌt ok u Jesús vatz u bꞌanol ivatz u ijlenaaleꞌ, as ichꞌoti veꞌt naj itziꞌ Aak. Ech tal naj ileꞌ: —¿Ma axh u tijlenaal unqꞌa tiaal Israel?— tiꞌk naj. Ech tal veꞌt u Jesús ileꞌ: —An chiteꞌ uveꞌ naaleꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","As kꞌuxh nikat icheesa unqꞌa bꞌaal tenameꞌ tukꞌ unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh ipaav u Jesús, as yeꞌl Aak kat tzaqꞌbꞌi. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","As ech tal veꞌt u Poncio Pilato ileꞌ te Aak: —¿Ma yeꞌ naabꞌi unqꞌa yoleꞌ uveꞌ ni tal chajnaj seeꞌ?— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","As sotz veꞌt ikꞌuꞌl naj, tan jit tal u Jesús umaj yol. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","As tu u nimla qꞌiieꞌ uvaꞌ pascua, as chiannalik veꞌt te unqꞌa tenameꞌ taꞌn u bꞌanol ivatz u ijlenaaleꞌ uvaꞌ aꞌ unqꞌa tenameꞌ la txaaon umaj preexhu uvaꞌ la chajpuli. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","As atik ok umaꞌl u naj preexhuil uvaꞌ Barrabás. As ootzimalik vipaav najeꞌ taꞌn unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","As tul molik tibꞌ unqꞌa tenameꞌ vatz u Pilato, as ichꞌoti veꞌt naj te unqꞌa tenameꞌ: —¿Abꞌiste u najeꞌ la unchajpu el cheel? ¿Ma aꞌ u Barrabás? ¿Pet moj aꞌ u Jesús uveꞌ Cristo nitalpeꞌ?— tiꞌk u Pilato, ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","tan atik skꞌuꞌl u Pilato uvaꞌ taꞌn kuxh chꞌoꞌnchil aama nikat toksakat unqꞌa iqꞌesal unqꞌa tenameꞌ u Jesús tiqꞌabꞌ u Pilato. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","As tul xonlik u Pilato tu vixhiila uvaꞌ nibꞌanaxkat isuuchil unqꞌa uxhchileꞌ, as ichaj bꞌen u tixqel najeꞌ yol. Ech tal bꞌen ixoj ileꞌ: «Yeꞌ kuxh achuk apaav tiꞌ u jikla najeꞌ, tan kalabꞌ chit kꞌaxkꞌo kat unpalebꞌe tunvatzikꞌ tiꞌ u najeꞌ,» tiꞌk u tixqel najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","As unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh tukꞌ kaꞌt unqꞌa bꞌaal tenameꞌ, as toksa veꞌt chajnaj tiviꞌ unqꞌa tenameꞌ tiꞌ uvaꞌ aꞌ u Barrabás la chajpuli, as la yatzꞌpu u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","As ech tal veꞌt u Pilato ileꞌ: —¿Abꞌiste kaꞌvaꞌl u najeꞌ la unchajpu el uveꞌ netaleꞌ?— tiꞌk naj. Ech tal veꞌt unqꞌa tenam ileꞌ: —Chajpu el tzan u Barrabás,— tiꞌk unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","As ech tal veꞌt u Pilato ileꞌ: —¿Kam qꞌi tuk unbꞌan tiꞌ u Jesús uveꞌ Cristo ni talpeꞌ?— tiꞌk u Pilato. As kajayil chit unqꞌa tenameꞌ kat alon: —¡Yatzꞌpoj naj vatz u kuruseꞌ!— tiꞌk unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","As ech tal veꞌt u Pilato ileꞌ: —¿Kam ipaav u najeꞌ qꞌi kat ibꞌana?— tiꞌk u Pilato. As aal chit taqꞌ jeꞌ unqꞌa tenameꞌ tuul iviꞌ. As ech tal veꞌt ileꞌ: —¡Yatzꞌpoj naj vatz u kuruseꞌ!— tiꞌk unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","As til veꞌt u Pilato uvaꞌ yeꞌ nik tok veꞌt yol tiviꞌ unqꞌa tenameꞌ. Pet aal chit nik iveqꞌelkabꞌan unqꞌa tenameꞌ. As ijaj veꞌt u Pilato unbꞌiil u aꞌ. As itxꞌaa veꞌt naj iqꞌabꞌ vatz unqꞌa tenameꞌ. Ech tal veꞌt naj ileꞌ: —Yeꞌl unpaav tiꞌ vikamebꞌal u jikla najeꞌ, tan exeꞌ ni alon ikameꞌ,— tiꞌk u Pilato. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ech tal veꞌt unqꞌa tenam ileꞌ skajayil: —¡Jeꞌonoj u kupaaveꞌ sqiꞌ tukꞌ unqꞌa meꞌal kukꞌaoleꞌ tiꞌ ibꞌeneꞌ tiꞌ vikamebꞌal u najeꞌ!— tiꞌk unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ichajpu veꞌt u Pilato u Barrabás. As tal veꞌt naj iqꞌospu u Jesús taꞌn tzꞌuꞌm. As tul bꞌaꞌnxi, as taqꞌ veꞌt ok naj u Jesús te unqꞌa tenameꞌ tiꞌ iyatzꞌpu veꞌt Aak vatz u kuruseꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","As unqꞌa isol u bꞌanol ivatz u ijlenaaleꞌ, as teqꞌo veꞌt chajnaj u Jesús tikabꞌal u bꞌanol ivatz u ijlenaaleꞌ uvaꞌ atikkat u tatinbꞌal unqꞌa soleꞌ. As imol veꞌt ok unqꞌa imooleꞌ skajayil kꞌatz u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","As teesa veꞌt unqꞌa soleꞌ u toksaꞌm Aakeꞌ. As toksa veꞌt chajnaj umaꞌl u kaj oksaꞌm tiꞌ Aak echeꞌ toksaꞌm umaj ijlenaal. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","As taqꞌ veꞌt jeꞌ chajnaj umaꞌl u koroona chꞌiꞌx tiꞌ iviꞌ Aak uvaꞌ paatxꞌumalike. As taqꞌoꞌk chajnaj umaꞌl u aa tisebꞌal iqꞌabꞌ Aak echeꞌ ibꞌaara umaj ijlenaal. As qaaebꞌ veꞌt chajnaj vatz Aak tiꞌ teesal iqꞌii Aak. As ech tal chajnaj ileꞌ te Aak: —¡Keche, Pap, axh tijlenaal unqꞌa tiaal Israel!— tiꞌk chajnaj tul nikat teesa chajnaj iqꞌii Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","As itzubꞌa veꞌt chajnaj Aak. As imaa chajnaj u aaeꞌ tiqꞌabꞌ Aak. As ivekꞌ chajnaj tiꞌ iviꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","As tul maꞌtik teesat chajnaj iqꞌii Aak, as teesa veꞌt el chajnaj u kaj oksaꞌmeꞌ tiꞌ Aak. As toksa veꞌt chajnaj u toksaꞌm Aakeꞌ. As teqꞌo veꞌt chajnaj Aak tiꞌ iyatzꞌpu vatz u kuruseꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","As tul bꞌen veꞌt chajnaj tu bꞌey, as ikꞌul chajnaj umaꞌl u naj uvaꞌ Simón uvaꞌ tzaanaj tu u Cirene. As itxey veꞌt chajnaj u Simón tiꞌ uvaꞌ la tija naj vikurus u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tul oon veꞌt chajnaj tu umaꞌl u atinbꞌal uvaꞌ Gólgota ibꞌii uvaꞌ «Tatinbꞌal Bꞌajil Kꞌoꞌn» chꞌelel, ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","as taqꞌ veꞌt chajnaj unbꞌiil u taꞌl uuva te u Jesús uvaꞌ yuelik tibꞌ tukꞌ kꞌayla aꞌ. As tul inach Aak, as jit tukꞌa veꞌt Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","As tul maꞌt taqꞌat veꞌt jeꞌ unqꞌa soleꞌ u Jesús vatz u kuruseꞌ, as ijatx veꞌt chajnaj u toksaꞌm Aakeꞌ svatzaj. As itxꞌak veꞌt tibꞌ chajnaj tiꞌ u toksaꞌm Aakeꞌ, tiꞌ itzojpisal umaꞌl u yol uvaꞌ alel kan taꞌn u qꞌajsan tetz viyol u Tiixheꞌ tiꞌ u Jesús uvaꞌ ech ni tal ileꞌ: Ijatx veꞌt chajnaj u voksaꞌmeꞌ svatzaj. As itxꞌak veꞌt tibꞌ chajnaj stiꞌ, tiꞌk u yoleꞌ uvaꞌ tal kan u qꞌajsan tetz viyol u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tul bꞌaꞌnxi, as xonebꞌ veꞌt chajnaj tiꞌ ixeep Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","As taqꞌ veꞌt jeꞌ chajnaj umaꞌl u aqꞌen tiviꞌ u kuruseꞌ uvaꞌ tzꞌibꞌamalikkat uvaꞌ kam stiꞌ nikat iyatzꞌpukat Aak. Ech nik tal ileꞌ: Aꞌ U JESÚS UVAꞌ, U TIJLENAAL UNQꞌA TIAAL ISRAEL, tiꞌk u tzꞌibꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","As taqꞌ veꞌt jeꞌ chajnaj kaꞌvaꞌl unqꞌa elqꞌomeꞌ vatz kaꞌvaꞌt unqꞌa kuruseꞌ. Umaꞌl naj jeꞌ tisebꞌal u Jesús; as umaꞌt naj jeꞌ timax Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","As jankꞌal unqꞌa uxhchileꞌ uveꞌ nikat ipaleꞌ, as nik iyiku veꞌt iviꞌ tul nikat iyoqꞌon tiꞌ u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","As ech nik tal ileꞌ: —Nikat aaleꞌ uvaꞌ la eꞌpisa u tostiixheꞌ as titoxvu qꞌii la alak unpajte, uvaꞌ naaleꞌ. Asoj axh viKꞌaol u Tiixheꞌ uveꞌ naaleꞌ, as qꞌalpu eebꞌ vatz u kamchileꞌ scheel. As kuꞌen chꞌuꞌl vatz u kuruseꞌ,— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","As echat chit nik ibꞌan unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh, tukꞌ unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as tukꞌ kaꞌt unqꞌa bꞌaal tenameꞌ. As ech tal veꞌt chajnaj ileꞌ tiꞌ u Jesús: ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—As kꞌuxh kat iqꞌalpu naj unqꞌa uxhchileꞌ vatz unqꞌa chꞌoꞌmeꞌ, as yeꞌ nitxꞌol veꞌt naj iqꞌalput tibꞌ vatz u kuruseꞌ. Asoj naj u qijlenaaleꞌ, as kuꞌoj chꞌuꞌl naj vatz u kuruseꞌ cheel. As aꞌn la kunima veꞌt naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","As kat tal naj sqe uvaꞌ naj iKꞌaol u Tiixheꞌ. Asoj kꞌujleꞌl ikꞌuꞌl naj tiꞌ u Tiixheꞌ, as iloch u Tiixheꞌ bꞌa naj cheel, asoj nisaꞌ u Tiixheꞌ naj,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","As echat nikat ibꞌan unqꞌa elqꞌomeꞌ uveꞌ atik jeꞌ vatz unqꞌa kuruseꞌ kꞌatz u Jesús, tan antik chajnaj nik iyoqꞌon tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","As tul chaqꞌaan veꞌt qꞌii, as tokin veꞌt ivatz u txꞌavaꞌeꞌ. As techanal oon veꞌt oxvaꞌl oora kuꞌqꞌii, as aꞌn ilon veꞌt u qꞌiieꞌ unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tul bꞌiitik kuxh toon veꞌt oxvaꞌl oora kuꞌqꞌii, as sikꞌin veꞌt u Jesús. As ech tal veꞌt Aak ileꞌ: —¿Elí, Elí, lama sabactani?— tiꞌk Aak. Aꞌ isuuchil u yoleꞌ uvaꞌ «¡Kubꞌaal Tiixh, Kubꞌaal Tiixh! ¿Kam qꞌi uveꞌ nu kuxh aaqꞌ kan in sunjunal?» tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","As kaꞌl unqꞌa uxhchil uvaꞌ atik tzitziꞌ, as tul tabꞌi isikꞌin u Jesús, as ech tal veꞌt ileꞌ svatzaj: —Aꞌ u Elías nimolo naj,— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","As oora chit bꞌex teqꞌo veꞌt tzan umaꞌl u naj umaꞌl u patxkin kꞌoo. As takꞌsa naj taꞌn kꞌayla taꞌl uuva. As ikꞌaloꞌk naj tijuꞌ umaꞌl u aa. As taqꞌ jeꞌ naj te u Jesús aqꞌal uvaꞌ la tukꞌa Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ech tal veꞌt kaꞌt unqꞌa imool naj ileꞌ ste: —Yeꞌ eetz tiꞌ naj. Tuk qileꞌ ma tuk uloj u Elías tiꞌ iqꞌalpul naj,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","As sikꞌin veꞌt u Jesús unpajte. As taqꞌ veꞌt ok Aak u taanxelaleꞌ te u Tiixheꞌ. As kam veꞌt Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","As qꞌixmu veꞌt u nimla ixbꞌuꞌjeꞌ uveꞌ nik jatxon tuul u tostiixheꞌ. As kaꞌvaꞌl kuꞌ u ixbꞌuꞌjeꞌ stuul, tan kat qꞌixmik kuꞌ tzan tiviꞌ as kat ul xeꞌ toj. As ul veꞌt umaꞌl u kabꞌlaano. As eꞌp veꞌt unqꞌa sivaneꞌ staꞌn. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","As ijaj veꞌt tibꞌ unqꞌa juleꞌ vatz u piꞌuneꞌ uveꞌ mujikkat unqꞌa kamnajeꞌ. As nimal unqꞌa kamnajeꞌ ul veꞌt taama uveꞌ nimanik tetz u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","As tul maꞌtik tul veꞌt taama u Jesús, as el veꞌt chꞌuꞌl unqꞌa uxhchileꞌ tu u juleꞌ. As ok veꞌt tu u tenameꞌ uvaꞌ txaael taꞌn u Tiixheꞌ uvaꞌ Jerusalén. As nimal unqꞌa uxhchileꞌ kat ilon unqꞌa kamnajeꞌ uvaꞌ kat ul taama. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Viqꞌesal unqꞌa soleꞌ tukꞌ unqꞌa isol najeꞌ uvaꞌ nik xeen u Jesús, as tul til chajnaj u kabꞌlaanoeꞌ tukꞌ uvaꞌ kat til chajnaj tul kat kam Aak, as vaꞌlik chit ixoꞌv veꞌt chajnaj. As ech tal veꞌt chajnaj ileꞌ svatzaj: —An chiteꞌ vil. IKꞌaol Tiixheꞌ vil u najeꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","As nimal unqꞌa ixojeꞌ atik tzitziꞌ uvaꞌ locholik tetz Aak tul sitzaa Aak tu u Galilea. As tziꞌaꞌn kuxh nikat isajinkat veꞌt tzan unqꞌa ixojeꞌ tiꞌ Aak tul uvaꞌ sikam veꞌt Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Antik u Maꞌleꞌ uvaꞌ tzaanaj tu u tenam uvaꞌ Magdala, tukꞌ umaꞌt u Maꞌleꞌ, vitxutx u Jacob tukꞌ u Xhuꞌleꞌ, as tukꞌ vitxutx unqꞌa ikꞌaol u Zebedeo. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","As tul bꞌiitik ikuꞌ qꞌii, as bꞌex veꞌt umaꞌl u txꞌioliqꞌii uvaꞌ Xhuꞌl xeꞌ u Pilato. As aꞌ tzaanajkat u Xhuꞌleꞌ tu u tenam uvaꞌ Arimatea. As nimamalik u Jesús taꞌn naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","As bꞌex ijaj veꞌt naj vichiꞌol u Jesús te u Pilato. As tal veꞌt u Pilato te unqꞌa isoleꞌ uvaꞌ la aqꞌax vichiꞌol Aakeꞌ te u Xhuꞌleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","As teqꞌo veꞌt kuꞌ tzan u Xhuꞌleꞌ vichiꞌol Aakeꞌ. As ibꞌoch veꞌt naj tu umaꞌl u saj maanta. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","As bꞌex imuj veꞌt kan naj tu umaꞌl u jul uvaꞌ aꞌn kꞌotik ok vatz umaꞌl u piꞌun. As tul maꞌtik ibꞌalqꞌut veꞌt ok naj umaꞌl u nimla sivan tziꞌ u juleꞌ, as bꞌen veꞌt naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","As u Maꞌleꞌ uvaꞌ tzaanaj tu u tenam uvaꞌ Magdala, as xonlik kuxh tziꞌ u juleꞌ tukꞌ umaꞌt u Maꞌleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","As ech eꞌtal stuul, tul paly veꞌt u qꞌii uveꞌ ni bꞌanaxkat tuch u nimla qꞌiieꞌ, as imol veꞌt tibꞌ unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh tukꞌ unqꞌa fariseo vatz u Pilato. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ech bꞌex tal chajnaj ileꞌ: —Pap, tul qal see, tan kat ul sukukꞌuꞌl uvaꞌ tul yeꞌxnik kam u chulin yoleꞌ, as kat tal naj uvaꞌ titoxvu qꞌii la ul taama naj unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Estiꞌeꞌ tul kujaj bꞌaꞌnil see uvaꞌ la achaj bꞌen kaꞌoj unqꞌa soleꞌ tiꞌ ixeep u juleꞌ uvaꞌ kat mujlukat naj. As lanal pal oxvaꞌl u qꞌiieꞌ tiꞌ imujlu naj, tan la ibꞌaneꞌ uvaꞌ la oon unqꞌa ichusulibꞌ najeꞌ tiꞌ bꞌen telqꞌat vichiꞌol najeꞌ. As la bꞌen tal veꞌt chajnaj te unqꞌa tenameꞌ uvaꞌ kat ulyu taama naj unpajte. As la ibꞌaneꞌ uvaꞌ nim la bꞌenkat u chuli yoleꞌ tiꞌ unqꞌa chuli yoleꞌ uvaꞌ kat tal u najeꞌ bꞌaxa,— tiꞌk chajnaj te u Pilato. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ech tal veꞌt u Pilato ileꞌ: —Il kaꞌl unqꞌa sol ileꞌ. Eteqꞌotaj chajnaj tiꞌ ixeep u juleꞌ echeꞌ uveꞌ netaleꞌ,— tiꞌk u Pilato. ");
INSERT INTO ixlNNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","As bꞌex toksa veꞌt kan unqꞌa iqꞌesal u tenameꞌ umaꞌl u exhlal tiꞌ u sivaneꞌ uvaꞌ nik jupun itziꞌ u juleꞌ tiꞌ uvaꞌ yeꞌxhebꞌil la jajon. As taqꞌ veꞌt kan chajnaj unqꞌa soleꞌ tiꞌ ixeep itziꞌ u juleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","As tul maꞌtik ipal veꞌt u xeem qꞌiieꞌ, as sajbꞌu veꞌteꞌ tu u bꞌaxa qꞌii tu xhemaanaeꞌ. As bꞌen veꞌt u Maꞌleꞌ uvaꞌ tzaanaj tu u tenam uvaꞌ Magdala, tukꞌ umaꞌt u Maꞌleꞌ tiꞌ tilat u juleꞌ uveꞌ mujlukat u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","As ul veꞌt umaꞌl u mam kabꞌlaano, tan kuꞌ veꞌt chꞌuꞌl umaꞌl u ángel tu almikaꞌ. As teesa veꞌt el u ángel u sivaneꞌ uveꞌ atik ok tziꞌ u juleꞌ. As xonebꞌ veꞌt jeꞌ u ángel viꞌ u sivaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Echik tilon u ángel echeꞌ ilitzꞌloꞌlan umaj kayampaꞌl. As vaꞌlik chit ipolal u toksaꞌmeꞌ echeꞌ txuncheꞌv. ");
INSERT INTO ixlNNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tul til unqꞌa soleꞌ u ángel, as vaꞌlik chit itꞌuntꞌuch veꞌt chajnaj taꞌn xoꞌvichil. As ech veꞌt chajnajeꞌ echeꞌ kamnaj kat ibꞌana. ");
INSERT INTO ixlNNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","As tul oon veꞌt unqꞌa ixojeꞌ, as ech tal veꞌt u ángel ileꞌ te chaꞌma: —Yeꞌ kuxh xoꞌv ex, tan ootzimal svaꞌn uvaꞌ aꞌ u Jesús nechukeꞌ, uvaꞌ kat kam vatz u kuruseꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Pet yeꞌl veꞌt Aak at tzitzaꞌ, tan kat ulyu veꞌt taama Aak unpajte, echeꞌ uvaꞌ tal kan Aak sete. Pet siꞌunaj. Etiltaj ok u veeꞌ mujlukat Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","As oora kuxh bꞌen etaltaj te unqꞌa ichusulibꞌ Aakeꞌ cheel uvaꞌ kat ulyu veꞌt taama Aak. As il Aak tuk bꞌaxoj bꞌen sevatz tu u Galilea. As tzitziꞌ la etilkat veꞌt Aak. As ileꞌ kat vallu veꞌt sete,— tiꞌk u ángel. ");
INSERT INTO ixlNNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","As kꞌuxh xoꞌvebꞌal chit uveꞌ til chaꞌma, as vaꞌlik chit ichiibꞌ veꞌt chaꞌma. As el veꞌt chꞌuꞌl chaꞌma tu u juleꞌ. As oojeꞌl ibꞌen veꞌt chaꞌma tiꞌ bꞌen talat te unqꞌa ichusulibꞌ Aakeꞌ kam uvaꞌ kat til chaꞌma. ");
INSERT INTO ixlNNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","As ikꞌuch veꞌt tibꞌ u Jesús te chaꞌma tu bꞌey. As ech tal Aak ileꞌ: —¡Keche!— tiꞌk Aak. As jetzꞌen veꞌt ok chaꞌma kꞌatz Aak. As ijele veꞌt chaꞌma u toj Aakeꞌ tul qaalik chaꞌma tiꞌ toksal iqꞌii Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","As ech tal veꞌt u Jesús: —Yeꞌ kuxh xoꞌv ex. Pet bꞌenoj etaltaj te unqꞌa vitzꞌineꞌ uvaꞌ bꞌenoj chajnaj tu u Galilea, tan tzitziꞌ la tilkat in chajnaj,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","As tul kat bꞌen veꞌt chaꞌma, as kat bꞌex veꞌt kaꞌl unqꞌa sol tu u tenam uveꞌ xeenik tetz u juleꞌ uveꞌ mujlukat u Jesús. As bꞌex tal veꞌt chajnaj te unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh uvaꞌ kam kat til chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","As imol veꞌt tibꞌ unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh tukꞌ unqꞌa bꞌaal tenameꞌ tiꞌ ibꞌanat nukꞌuj. As ikꞌul veꞌt tibꞌ iyol chajnaj. As nimal puaj kat taqꞌ veꞌt chajnaj te unqꞌa soleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","As ech tal chajnaj ileꞌ te unqꞌa soleꞌ: —Ech la etal ileꞌ: «Tul uvaꞌ vatik oꞌ aqꞌbꞌal as kat bꞌex telqꞌa unqꞌa ichusulibꞌ u Jesús vichiꞌoleꞌ tu u juleꞌ» chaj ex la etaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Pet asoj la tabꞌi veꞌt u bꞌanol ivatz u ijlenaaleꞌ u yoleꞌ, as oꞌ la mutxbꞌen veꞌt naj tiꞌ uvaꞌ yeꞌl kꞌaxkꞌo la epalebꞌe— tiꞌk chajnaj tal te unqꞌa soleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","As ikꞌul veꞌt unqꞌa soleꞌ u puajeꞌ. As bꞌex tal veꞌt chajnaj u yoleꞌ uvaꞌ alax te chajnaj. As antel kuxh talax u yoleꞌ scheel xoꞌl unqꞌa tiaal Israel. ");
INSERT INTO ixlNNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Bꞌen veꞌt junlaval ichusulibꞌ u Jesús tu u Galilea viꞌ u vitz uvaꞌ maꞌtik talat u Jesús te unqꞌa ixojeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","As tul til veꞌt chajnaj u Jesús, as kuꞌ veꞌt chajnaj qaaloj vatz Aak tiꞌ toksal iqꞌii Aak. As atik jununil chajnaj uvaꞌ nikat ikaꞌkabꞌin taama tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","As jetzꞌen veꞌt ok u Jesús kꞌatz chajnaj: As ech tal veꞌt Aak ileꞌ: —Kat aqꞌax veꞌt u vijleꞌmeꞌ tiꞌ vilat isuuchil unqꞌa veeꞌ skajayil uveꞌ at tu almikaꞌ tukꞌ unqꞌa veeꞌ at vatz u txꞌavaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Estiꞌeꞌ tuk val sete, bꞌenoj ex. Bꞌenoj echus unqꞌa tenameꞌ skajayil tiꞌ uvaꞌ la inima in. As la etaqꞌ kuꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ tukꞌ vibꞌii u Tiixheꞌ, tukꞌ vunbꞌiieꞌ uvaꞌ in viKꞌaol u Tiixheꞌ, as tukꞌ vibꞌii u Tiixhla Espíritu. ");
INSERT INTO ixlNNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","As la echus unqꞌa tenameꞌ tiꞌ uvaꞌ la chit inima unqꞌa yoleꞌ skajayil uveꞌ kat val sete. As at chit veꞌt in sekꞌatz la ibꞌaneꞌ tiꞌ chit ibꞌeneꞌ, techal la sotz ivatz u txꞌavaꞌeꞌ,— tiꞌk u Jesús. An chiteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","As ech ixeꞌt u bꞌaꞌnla yoleꞌ tiꞌ u Jesucristo, viKꞌaol u Tiixheꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","echeꞌ uvaꞌ tzꞌibꞌamal kan taꞌn u Isaías, u qꞌajsan tetz viyol u Tiixheꞌ, uvaꞌ ech ni tal ileꞌ: Tuk unbꞌaxsa bꞌen umaꞌl u alol tetz vunyoleꞌ savatz, uvaꞌ la bꞌanon tuch u bꞌeyeꞌ savatz. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tan la uch umaꞌl u sikꞌiꞌm tu u tzuukin txꞌavaꞌeꞌ. As ech la tal ileꞌ: «¡Ebꞌantaj etucheꞌ tiꞌ ekꞌulat u kuBꞌooqꞌoleꞌ! ¡As ejikbꞌaꞌtaj vetxumbꞌaleꞌ echeꞌ ijikbꞌaꞌl umaj bꞌey!» chaj la ul taleꞌ, tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","As kat ul ibꞌan u Xhuneꞌ kam uveꞌ tzꞌibꞌamalik kan taꞌn u Isaías, tan kat ul tal u Xhuneꞌ viyol u Tiixheꞌ tu u tzuukin txꞌavaꞌeꞌ. As kat ul tala uvaꞌ la kuꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ, texhlal tetz uvaꞌ kat ikꞌaxal unqꞌa uxhchileꞌ vipaaveꞌ vatz u Tiixheꞌ, aqꞌal uvaꞌ la isotzsa veꞌt Aak ipaav unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","As nimal unqꞌa aa Judea tukꞌ unqꞌa aa Jerusalén, as ul tabꞌi veꞌt viyol u Xhuneꞌ. As jankꞌal unqꞌa uxhchileꞌ uveꞌ nikat tal vipaaveꞌ te u Tiixheꞌ, as taqꞌ veꞌt kuꞌ u Xhuneꞌ unqꞌa uxhchileꞌ xeꞌ u nimla aꞌeꞌ uvaꞌ Jordán. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","As aꞌ vixiꞌl u camello uvaꞌ atik ok tiꞌ u Xhuneꞌ. As kꞌalik ok umaꞌl u tzꞌuꞌm xeꞌ tuul. As aꞌ unqꞌa talaj sakꞌeꞌ tukꞌ u taꞌl kabꞌeꞌ nikat techbꞌu. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","As nik tal u Xhuneꞌ viyol u Tiixheꞌ. As ech tal ileꞌ: —Tuk uloj umaꞌt u uxhchil uvaꞌ nim talchu u tijleꞌmeꞌ sviꞌ. As jit unkꞌuleleꞌ uvaꞌ la unsaapu vikꞌaꞌjil vixaꞌpeꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","tan kꞌuxh kat vaqꞌlu bꞌen ex xeꞌ u aꞌeꞌ, as aꞌ kuxheꞌ uveꞌ kat vaqꞌkat bꞌen ex. Pet ech koj u uxhchileꞌ uveꞌ aꞌn tuleꞌ, tan tul toksa u Tiixhla Espíritu tu vetaanxelaleꞌ,— tiꞌk u Xhuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","As bꞌex ibꞌan veꞌt tu umaꞌl u qꞌii tul tzaa veꞌt u Jesús tu u Nazaret uvaꞌ echen tu u Galilea. As aqꞌax veꞌt kuꞌ u Jesús xeꞌ u aꞌeꞌ tu u Jordán taꞌn u Xhuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","As tul jeꞌ veꞌt chꞌuꞌl u Jesús xeꞌ u aꞌeꞌ, as til veꞌt Aak ijajput tibꞌ u almikaꞌeꞌ. As til veꞌt Aak ikuꞌ chꞌuꞌl u Tiixhla Espíritu stiibꞌa, uvaꞌ ech tiloneꞌ echeꞌ umaj paroomaxh. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","As abꞌil veꞌt umaꞌl u tuul viꞌ tu almikaꞌ uvaꞌ ech tal ileꞌ: —Axheꞌ axh vunKꞌaoleꞌ uvaꞌ xoꞌn chit axh sve. As vaꞌl chit untxuqꞌtxun veꞌt seeꞌ,— tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tul bꞌaꞌnxi, as ichaj veꞌt bꞌen u Tiixhla Espíritu u Jesús tu u tzuukin txꞌavaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","As kaꞌviinqil qꞌii kat atin u Jesús tu u tzuukin txꞌavaꞌeꞌ. As kat ichuk veꞌt u Satanás txumbꞌal tiꞌ uvaꞌ la paavin Aak. As nik ilochpu veꞌt Aak taꞌn unqꞌa ángel, tan echenik Aak xoꞌl unqꞌa txooeꞌ uvaꞌ la chiꞌon uxhchil. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tul maꞌtik toksal u Xhuneꞌ tu u kaarsa, as qꞌaav veꞌt u Jesús tu u Galilea tiꞌ talat veꞌt u bꞌaꞌnla yoleꞌ tiꞌ u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","As ech tal Aak ileꞌ: —Kat ilejlu veꞌt u qꞌiieꞌ uvaꞌ la ok u tenameꞌ jaqꞌ u tijleꞌm u Tiixheꞌ. As ekꞌaxataj vepaaveꞌ. As enimataj u bꞌaꞌnla yoleꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tul nik ixaan u Jesús tziꞌ u mar tu u Galilea, as til veꞌt Aak u Simón tukꞌ u titzꞌineꞌ uvaꞌ Lixh. As nik isuti bꞌen chajnaj vikꞌacheꞌ xeꞌ u mar, tan txeyol txay chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","As ech tal u Jesús ileꞌ te chajnaj: —Xekebꞌoj ex sviꞌ. As la voksa veꞌt ex tiꞌ uvaꞌ la eteqꞌo tzan unqꞌa uxhchileꞌ tiꞌ tok sunkꞌatz,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","As yak kuxh taqꞌ veꞌt kan chajnaj unqꞌa ikꞌacheꞌ. As xekebꞌ veꞌt chajnaj tiꞌ u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","As bꞌiil kuxh ixaa u Jesús tziꞌ u aꞌeꞌ. As til veꞌt Aak u Jacobo tukꞌ u titzꞌineꞌ uvaꞌ Xhun, unqꞌa ikꞌaol u Zebedeo. Atik ok chajnaj tukꞌ vibꞌaaleꞌ tu u barco, tan nikat kuxh ikꞌooa chajnaj unqꞌa ikꞌacheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","As imolo veꞌt Aak chajnaj. As taqꞌ veꞌt kan chajnaj vibꞌaaleꞌ uvaꞌ Zebedeo tu u barco tukꞌ unqꞌa ikꞌameꞌ. As xekebꞌ veꞌt chajnaj tiꞌ u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","As oon veꞌt u Jesús tukꞌ chajnaj tu u Capernaúm. As tu u xeem qꞌiieꞌ tu jun xhemaana, as nik tex veꞌt Aak tukꞌ chajnaj tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh uvaꞌ nichuspukat viyol u Tiixheꞌ. As nik ichusun veꞌt Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","As teqꞌo veꞌt taama unqꞌa uxhchileꞌ tiꞌ u chusbꞌaleꞌ uveꞌ nik tal Aak, tan ech iyolon Aakeꞌ echeꞌ umaj naj uvaꞌ at tijleꞌm. Pet ech koj unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, tan jitꞌeꞌch ichusun chajnajeꞌ echeꞌ uveꞌ nik ibꞌan Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","As atik ok umaꞌl u naj tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh, as atik ok subꞌul kꞌatz naj. As vaꞌlik chit isikꞌin naj taꞌn u subꞌuleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ech tal veꞌt naj ileꞌ taꞌn u subꞌuleꞌ: —¡Jesús, aa Nazaret! ¿Kam asaꞌ sqe? ¡Yeꞌ ul ayansa oꞌ! Tan ootzimal svaꞌn uvaꞌ axheꞌ uvaꞌ chajel tzan axh taꞌn u Tiixheꞌ. As ayaꞌl chit akꞌuꞌl nooksa aama tiꞌ Aak,— tiꞌk u najeꞌ taꞌn u subꞌuleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Pet ech tal veꞌt u Jesús ileꞌ te u subꞌuleꞌ: —¡Chaa tziꞌ! ¡Elen tiꞌ u najeꞌ!— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","As xoꞌvebꞌal chit iyikut veꞌt u subꞌuleꞌ u najeꞌ. As mam sikꞌiꞌm ibꞌan naj. As el veꞌt u subꞌuleꞌ tiꞌ naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","As teqꞌo veꞌt taama unqꞌa uxhchileꞌ skajayil. As ech tal veꞌt ileꞌ svatzaj: —¿Kameꞌ qꞌi uveꞌ ni tucheꞌ? ¿As kam chusbꞌalileꞌ qꞌi uveꞌ eqꞌomal taꞌn u najeꞌ? Tan tukꞌ u tijleꞌm najeꞌ, as ni tal naj tel unqꞌa subꞌuleꞌ. As ninima unqꞌa subꞌuleꞌ viyol najeꞌ,— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","As oora chit pax veꞌt itzibꞌlal u Jesús tu unqꞌa tenameꞌ uvaꞌ atik tu u Galilea. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","As tul el chꞌuꞌl u Jesús tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh, as bꞌen veꞌt Aak tukꞌ u Jacob, tukꞌ u Xhuneꞌ. As oon veꞌt Aak tu u kabꞌaleꞌ uvaꞌ atikkat u Simón tukꞌ u Lixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","As koxhlik vijiꞌ u Luꞌeꞌ viꞌ chꞌach taꞌn xamal chꞌoꞌm. As alpu veꞌt te u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","As jetzꞌen veꞌt ok Aak kꞌatz vijiꞌ u Luꞌeꞌ. As itxey veꞌt Aak iqꞌabꞌ. As itxakpisa veꞌt Aak. As oora kuxh el veꞌt u xamal chꞌoꞌmeꞌ tiꞌ vijiꞌ u Luꞌeꞌ. As taqꞌ veꞌt vijiꞌ u Luꞌeꞌ techbꞌubꞌal unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","As tzꞌotin veꞌteꞌ, tan maꞌtik ibꞌen veꞌt qꞌii. As yeꞌ saach unqꞌa aachꞌoꞌmeꞌ eqꞌol tzan tukꞌ unqꞌa uxhchileꞌ uvaꞌ atik ok subꞌul skꞌatz. As eqꞌol ok vatz u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","As mamaꞌla tenam imol veꞌt ok tibꞌ tziꞌ u kabꞌaleꞌ uveꞌ atikkat u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","As nimal unqꞌa aachꞌoꞌmeꞌ kat ibꞌaꞌnxisa veꞌt Aak uvaꞌ kam kuxh chꞌoꞌmil nik bꞌanon. As nimal unqꞌa subꞌuleꞌ kat teesa veꞌt Aak tiꞌ unqꞌa uxhchileꞌ. As yeꞌ nik isaꞌ Aak uvaꞌ la yolon unqꞌa subꞌuleꞌ, tan ootzimalik taꞌn unqꞌa subꞌuleꞌ uvaꞌ iKꞌaol Tiixh u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Qꞌalaꞌm chit lakpu u Jesús. As tul tokixtele, as el chꞌuꞌl Aak. As bꞌen veꞌt Aak tu umaꞌl u atinbꞌal uvaꞌ yeꞌlkat uxhchil. As inach veꞌt Aak Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","As u Simón tukꞌ unqꞌa imooleꞌ, as bꞌex ichuk veꞌt chajnaj u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tul ilej veꞌt chajnaj Aak, as ech tal veꞌt chajnaj ileꞌ: —Nimal chit unqꞌa uxhchileꞌ nichukun seeꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ech tal veꞌt Aak ileꞌ: —Koꞌnaj tu kaꞌt unqꞌa tenameꞌ uveꞌ najli tiꞌ bꞌen valat u bꞌaꞌnla yoleꞌ, tan estiꞌeꞌ kat ulkat in,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","As bꞌex tal veꞌt Aak u bꞌaꞌnla yoleꞌ tu unqꞌa atinbꞌaleꞌ tetz nachbꞌal Tiixh tulaj unqꞌa talaj tenameꞌ tu u Galilea. As nik teesa veꞌt el Aak unqꞌa subꞌuleꞌ tiꞌ unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","As ul veꞌt umaꞌl u naj kꞌatz u Jesús uvaꞌ atik ok chꞌaꞌk chin stiꞌ. As kuꞌ naj qaaloj vatz Aak tiꞌ ijajat bꞌaꞌnil. As ech tal naj ileꞌ: —Asoj la asaꞌ, as bꞌan bꞌaꞌnil sve. As eesa u chꞌoꞌmeꞌ sviꞌ, tan la olebꞌ axheꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","As itxum veꞌt Aak ivatz naj. As taqꞌ veꞌt bꞌen Aak iqꞌabꞌ tiꞌ naj. As ech tal veꞌt Aak ileꞌ: —Nunsaꞌ. Kat bꞌaꞌnxiy veꞌt axheꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","As tul kuxh tal Aak u yoleꞌ, as yak kuxh el veꞌt u chꞌaꞌk chineꞌ tiꞌ u najeꞌ. As bꞌaꞌnik veꞌt naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","As tal veꞌt u Jesús uvaꞌ la bꞌen naj. As tal veꞌt Aak te naj tiꞌ uvaꞌ yeꞌxh katil la talkat naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","As ech tal veꞌt Aak ileꞌ: —Katiniꞌk chit aalkat tiꞌ uvaꞌ kat unbꞌaꞌnxisa axh. Pet kuxh kꞌuch eebꞌ vatz umaꞌl oksan iyol tenam vatz Tiixh. As kuxh aqꞌ u oyeꞌ uvaꞌ alel kan taꞌn u Moisés, texhlal tetz uvaꞌ kat txanyu veꞌt axh,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pet aal chit bꞌex ipaxsa veꞌt naj itzibꞌlal u Jesús, kam uvaꞌ kat ibꞌan Aak. Estiꞌeꞌ uvaꞌ yeꞌl Aak nik ikꞌuch veꞌt tibꞌ tu u tenameꞌ. Pet aꞌ atinkat veꞌt Aak tu umaꞌl u atinbꞌal uvaꞌ yeꞌlkat tenam. As katil kuxh tzaakat veꞌt unqꞌa tenameꞌ tiꞌ ul tilat uveꞌ nik ibꞌan Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tul pal veꞌt kaꞌl unqꞌa qꞌii, as ok veꞌt u Jesús tu u Capernaúm unpajte. As tabꞌi veꞌt unqꞌa tenameꞌ uvaꞌ atik Aak tu kabꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","As oora kuxh imol veꞌt tibꞌ u tenameꞌ. As yeꞌ nik tuch veꞌt tok unqꞌa uxhchileꞌ tu u tziꞌ kabꞌaleꞌ. As nik tal veꞌt u Jesús viyol u Tiixheꞌ te unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","As ul veꞌt kajvaꞌl unqꞌa naj uvaꞌ chelemalik umaꞌl u aachꞌoꞌm viꞌ umaꞌl u chꞌachiꞌm tzeꞌ staꞌn, tan tzeꞌunik tibꞌ vichiꞌol u aachꞌoꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","As tul yeꞌ nik tuch tok chajnaj vatz u Jesús taꞌn unqꞌa mamaꞌla tenameꞌ, as teesa veꞌt chajnaj unbꞌiil iviꞌ u kabꞌaleꞌ uveꞌ atikkat Aak. As taqꞌ veꞌt kuꞌ chajnaj u aachꞌoꞌmeꞌ tukꞌ u chꞌachiꞌm tzeꞌeꞌ vatz Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tul til u Jesús uvaꞌ kꞌujlik chit ikꞌuꞌl chajnaj tiꞌ Aak, as ech tal veꞌt Aak ileꞌ te u aachꞌoꞌmeꞌ: —Unkꞌaol, kat sotzyeꞌ vapaaveꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","As tul xonlik ok kaꞌl unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as ech titzꞌa veꞌt chajnaj ileꞌ tu u taanxelaleꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«¿Kam yolileꞌ uveꞌ ni tal u najeꞌ? Tan aꞌ u Tiixheꞌ ni teesa naj iqꞌii. As yeꞌxhebꞌil la sotzsan u paaveꞌ. Pet taꞌneꞌ u Tiixheꞌ la sotzsan u paaveꞌ,» tiꞌk chajnaj nik tal jeꞌ ste. ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","As atik skꞌuꞌl u Jesús uvaꞌ kam nik tal taama chajnaj. As ech tal veꞌt Aak ileꞌ: —¿Kam qꞌi uveꞌ nu kuxh etitzꞌa uvaꞌ ni veesa iqꞌii u Tiixheꞌ, uvaꞌ netaleꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿As abꞌiste qꞌi uvaꞌ yeꞌ la olebꞌ in tiꞌ ibꞌancheꞌ uvaꞌ netitzꞌa? ¿Ma tiꞌ uvaꞌ: «Kat sotzyeꞌ vapaaveꞌ,» chaj in te u aachꞌoꞌmeꞌ? ¿Pet moj: «Txakpen. As eqꞌo vachꞌachiꞌm tzeꞌeꞌ. As kuxh veꞌteꞌ,» chaj in la valeꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pet aqꞌal uvaꞌ la etootzi u tijleꞌm VIKꞌAOL U NAJEꞌ as kat uli tiꞌ ul isotzsat ipaav unqꞌa aapaaveꞌ vatz u txꞌavaꞌeꞌ, as sevatz tuk valkat te u aachꞌoꞌmeꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","As ech tal veꞌt Aak ileꞌ te u aachꞌoꞌmeꞌ: —Txakpen. As eqꞌo vasokeꞌ. As kuxh veꞌt takabꞌal,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","As yak kuxh txakpu veꞌt u najeꞌ. Teqꞌo veꞌt naj u chꞌachiꞌm tzeꞌeꞌ. As el veꞌt chꞌuꞌl naj xoꞌl unqꞌa tenameꞌ. As teqꞌo veꞌt taama unqꞌa tenameꞌ. As toksa veꞌt unqꞌa tenameꞌ iqꞌii u Tiixheꞌ. As ech tal veꞌt ileꞌ: —¡Yeꞌ atixoj qil ibꞌanax umaj bꞌaꞌnil echeꞌ uveꞌ kat uchya!— tiꞌk unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","As bꞌen veꞌt u Jesús tziꞌ u mar unpajte. As ul veꞌt unqꞌa tenameꞌ kꞌatz Aak. As chusun veꞌt Aak xoꞌl unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tul pal veꞌt Aak tziꞌ u mar, as til veꞌt Aak u Leví, vikꞌaol u Alfeo, uvaꞌ xonlike tu u atinbꞌaleꞌ uvaꞌ nimolpukat puaj tetz Roma. As ech tal veꞌt Aak ileꞌ te naj: —Siꞌu. Xekebꞌen sviꞌ,— tiꞌk Aak. As txakpu veꞌt naj. As xekebꞌ veꞌt naj tiꞌ u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","As teqꞌo veꞌt u Leví u Jesús tikabꞌal. Nimal unqꞌa molol puajeꞌ tetz Roma tukꞌ unqꞌa uxhchileꞌ uvaꞌ aapaav ni tal unqꞌa fariseo, as xonebꞌ veꞌt ok chajnaj kꞌatz u Jesús tukꞌ unqꞌa ichusulibꞌ Aakeꞌ, tan nimal chit uxhchil xekelik tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","As kaꞌl unqꞌa fariseo tukꞌ kaꞌt unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as tul til chajnaj uvaꞌ nik itxꞌaꞌn u Jesús kꞌatz unqꞌa molol puajeꞌ tukꞌ unjoltu unqꞌa uxhchileꞌ uveꞌ yeꞌ ni niman u Tiixheꞌ, as ech tal chajnaj ileꞌ te unqꞌa ichusulibꞌ Aakeꞌ: —¿Kam bꞌan taꞌneꞌ qꞌi uveꞌ nu kuxh itxꞌaꞌn vechusuleꞌ tukꞌ unqꞌa molol puajeꞌ tukꞌ unqꞌa aapaaveꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tul tabꞌi u Jesús, as ech tal veꞌt Aak ileꞌ: —Abꞌil uveꞌ yeꞌl chꞌoꞌm stiꞌ, as yeꞌle u aatzꞌakeꞌ la txakon stiꞌ. Pet aꞌ unqꞌa aachꞌoꞌmeꞌ uveꞌ nitxakon u aatzꞌakeꞌ stiꞌ. As jit unqꞌa uxhchileꞌ tul unmolo uvaꞌ ni tal jeꞌ ste uvaꞌ yeꞌl ipaav ati. Pet unqꞌa uxhchileꞌ uvaꞌ nichꞌoꞌn ste uvaꞌ kat paavini, as aꞌeꞌ tul unmolo,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","As nik ikuy unqꞌa ichusulibꞌ u Xhuneꞌ ivaꞌy tiꞌ inachat Tiixh. As echat nik ibꞌan unqꞌa ichusulibꞌ unqꞌa fariseo. As tul til kaꞌl unqꞌa uxhchil, as ichꞌoti veꞌt te u Jesús. As ech tal ileꞌ: —Nikuy unqꞌa ichusulibꞌ u Xhuneꞌ ivaꞌy tiꞌ inachat Tiixh. As echat nibꞌan vichusulibꞌ unqꞌa fariseo. ¿As kam qꞌi uvaꞌ yeꞌxhkam nibꞌan unqꞌa achusulibꞌeꞌ?— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ech tal veꞌt u Jesús ileꞌ: —¿La kol uch qꞌa uvaꞌ la ikuy unqꞌa ilonaaleꞌ ivaꞌy tu umaj nimla qꞌii tiꞌ teqꞌo tibꞌ umaj meꞌal ikꞌaol umaj uxhchil? As tul il u tzumela ileꞌ at xoꞌl. As yeꞌl ivaꞌy chajnajeꞌ la ikuyeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","As lanal ilej umaꞌl u qꞌii uvaꞌ la ul eesal el u tzumelaeꞌ sxoꞌl, as aꞌn la ikuy veꞌt unqꞌa ilonaaleꞌ ivaꞌy. ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","As yeꞌxhebꞌil la kꞌooan umaj qꞌaꞌl oksaꞌm taꞌn umaj u akꞌ kꞌoo, tan la iqꞌix u akꞌ kꞌooeꞌ u qꞌaꞌl oksaꞌmeꞌ. As aal chit la qꞌixmu veꞌt u qꞌaꞌl oksaꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","As mitaꞌn la uch taqꞌax kuꞌ u akꞌ vino tu umaj qꞌaꞌl tzꞌuꞌm uvaꞌ ech tiloneꞌ xhaalo, tan la iqꞌix u akꞌ vino u qꞌaꞌl tzꞌuꞌmeꞌ, tul la qꞌuꞌili. As la peqꞌxu veꞌt u vino. As la tzꞌejxu veꞌt u tzꞌuꞌmeꞌ tukꞌ u vino. Pet tu umaj akꞌ tzꞌuꞌm la kuꞌkat u akꞌ vino,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tu umaꞌl u xeem qꞌii as bꞌex paloj u Jesús tukꞌ unqꞌa ichusulibꞌeꞌ xoꞌl unqꞌa trigo uveꞌ avamalike. As xeꞌt tux veꞌt chajnaj kaꞌl ivatz unqꞌa trigo. ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","As ech tal veꞌt kaꞌl unqꞌa fariseo ileꞌ te u Jesús: —¿Kam bꞌan taꞌn uveꞌ nibꞌan unqꞌa achusulibꞌeꞌ? As tul aꞌeꞌ uveꞌ yeꞌ la uch ibꞌanchu tu u xeem qꞌiieꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ech tal veꞌt u Jesús ileꞌ: —¿Ma yeꞌxhkam bꞌa sikꞌlemal setaꞌn tiꞌ uvaꞌ kam kat ibꞌan u David, tul uvaꞌ nik ivaꞌy veꞌt tukꞌ unqꞌa imooleꞌ uvaꞌ xekelik stiꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","As kat ok veꞌt u David vatz u atinbꞌaleꞌ uvaꞌ ninachpukat Tiixh tul uvaꞌ atik ok u Abiatar sibꞌooqꞌol oksan iyol tenam vatz Tiixh. As kat itxꞌaꞌ veꞌt u David u paaneꞌ uvaꞌ maꞌtik teesal el tzan viꞌ u meexhaeꞌ tu u nachbꞌal Tiixheꞌ. As kat taqꞌ veꞌt u David te unqꞌa imooleꞌ uvaꞌ xekelik stiꞌ. As tul aꞌ kuxh unqꞌa oksan iyol tenam vatz Tiixh uvaꞌ la echbꞌun unqꞌa paaneꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","As ech tal u Jesús ileꞌ unpajte: —As tiꞌ u najeꞌ la txakonkat u xeem qꞌiieꞌ tul sikꞌujbꞌaꞌt kan u Tiixheꞌ. Pet jit u xeem qꞌiieꞌ la txakonsan u najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","As tul ineꞌ uvaꞌ in VIKꞌAOL U NAJEꞌ, as ineꞌ viBꞌaal u xeem qꞌiieꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","As tu umaꞌt u xeem qꞌii, as ok veꞌt u Jesús tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh unpajte uvaꞌ ninachpukat Tiixh. As atik ok umaꞌl u naj tzitziꞌ uvaꞌ kꞌoroꞌxhinik tibꞌ umaꞌl viqꞌabꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","As nik kuxh til kaꞌl unqꞌa fariseo tiꞌ uvaꞌ ma tuk ibꞌaꞌnxisa u Jesús u najeꞌ tu u xeem qꞌiieꞌ moj yeꞌle, tan nik ichuk chajnaj txumbꞌal tiꞌ icheesal ipaav Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","As ech tal veꞌt Aak ileꞌ te u najeꞌ uveꞌ kꞌoroꞌxhinik tibꞌ viqꞌabꞌeꞌ: —Txakpen. As txakebꞌen sukuxoꞌl,— tiꞌk Aak tal te naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","As ech tal veꞌt Aak ileꞌ te unqꞌa fariseo: —¿Abꞌiste uveꞌ la uch kubꞌanat tu u xeem qꞌiieꞌ? ¿Ma u bꞌaꞌneꞌ, pet moj u vaꞌlexheꞌ? ¿As ma la uch kulochat unqꞌa uxhchileꞌ, pet moj la kuxh qil ikameꞌ?— tiꞌk Aak. As jit tiin veꞌt unqꞌa fariseo. ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","As txumun veꞌt Aak, tan til veꞌt Aak uvaꞌ yeꞌ nik itxum chajnaj ivatz u aachꞌoꞌmeꞌ. As ul veꞌt iviꞌ Aak tiꞌ chajnaj. As junun isajit veꞌt bꞌen Aak chajnaj. As ech tal veꞌt Aak ileꞌ te u najeꞌ: —Yuꞌbꞌaꞌ vaqꞌabꞌeꞌ,— tiꞌk Aak. As iyuꞌbꞌaꞌ veꞌt naj viqꞌabꞌeꞌ. As yak kuxh bꞌaꞌnx veꞌt viqꞌabꞌ najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","As tul el veꞌt chꞌuꞌl unqꞌa fariseo tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh, as ikꞌul veꞌt tibꞌ iyol chajnaj tukꞌ unqꞌa najeꞌ uveꞌ echen kꞌatz u Herodes tiꞌ uvaꞌ la yatzꞌpu u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","As bꞌen veꞌt Aak tziꞌ u mar unpajte tukꞌ unqꞌa ichusulibꞌeꞌ. As mamaꞌla aa Galilea kat xekebꞌ veꞌt tiꞌ Aak, tukꞌ unqꞌa aa Judea, ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","tukꞌ unqꞌa aa Jerusalén, tukꞌ unqꞌa aa Idumea, tukꞌ unqꞌa tenameꞌ uveꞌ echen tu unqꞌa talaj tenameꞌ uvaꞌ najlich u tenameꞌ uvaꞌ Tiro tukꞌ u tenameꞌ uvaꞌ Sidón, as tukꞌ unqꞌa tenameꞌ uvaꞌ echen jalit u aꞌ uvaꞌ Jordán, tan tabꞌi veꞌt unqꞌa tenameꞌ itzibꞌlal unqꞌa mamaꞌla bꞌaꞌnileꞌ uvaꞌ nik ibꞌan u Jesús. As xekebꞌ veꞌt unqꞌa tenameꞌ tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","As tal veꞌt Aak te unqꞌa ichusulibꞌeꞌ uvaꞌ la ibꞌan chajnaj tucheꞌ tukꞌ umaj barco tiꞌ uvaꞌ la el Aak vatz unqꞌa tenameꞌ, aqꞌal uvaꞌ yeꞌ la pochꞌax Aak taꞌn unqꞌa tenameꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","tan mamaꞌla aachꞌoꞌm maꞌtik ibꞌaꞌnxisat Aak. Estiꞌeꞌ nikat ipochꞌ veꞌt ok tibꞌ unqꞌa aachꞌoꞌmeꞌ tiꞌ u Jesús, tan nik isaꞌ unqꞌa aachꞌoꞌmeꞌ ikanat Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","As tul til unqꞌa subꞌuleꞌ u Jesús, as kuꞌ veꞌt unqꞌa subꞌuleꞌ qaaloj vatz Aak. As taqꞌ veꞌt jeꞌ unqꞌa subꞌuleꞌ tuul iviꞌ. As ech tal veꞌt ileꞌ: —¡Axheꞌ viKꞌaol u Tiixheꞌ!— tiꞌk unqꞌa subꞌuleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","As iyaa veꞌt Aak unqꞌa subꞌuleꞌ tiꞌ uvaꞌ yeꞌ la tal unqꞌa subꞌuleꞌ u tijleꞌm Aakeꞌ xoꞌl unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","As jeꞌ veꞌt u Jesús viꞌ umaꞌl u vitz. As teqꞌo veꞌt Aak unqꞌa ichusulibꞌeꞌ stiꞌ uveꞌ txaaelik taꞌn Aak. As xekebꞌ veꞌt chajnaj tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","As ikꞌujbꞌaꞌ veꞌt kan Aak kabꞌlaval unqꞌa ichusulibꞌeꞌ tiꞌ uvaꞌ la atin kꞌatz Aak as tiꞌ ichajat bꞌen Aak tiꞌ bꞌen talat viyol u Tiixheꞌ ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","as tiꞌ uvaꞌ la taqꞌ Aak u tijleꞌm chajnajeꞌ tiꞌ ibꞌaꞌnxisal unqꞌa aachꞌoꞌmeꞌ as tiꞌ teesal unqꞌa subꞌuleꞌ unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","As aꞌ vibꞌii kabꞌlaval unqꞌa apóstol u viꞌlaꞌ: U Simón uvaꞌ kat toksa Aak vibꞌii uvaꞌ Luꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","tukꞌ kaꞌvaꞌl vikꞌaol u Zebedeo, u Jacobo tukꞌ u titzꞌin uvaꞌ Xhun. Aꞌ chajnajeꞌ uvaꞌ Boanerges kat ibꞌiia taꞌn Aak, tan ikꞌaol qꞌankoo isuuchil u yoleꞌ uvaꞌ Boanerges, ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","tukꞌ u Lixh, tukꞌ u Piꞌl, tukꞌ u Bartolomé, tukꞌ u Mateo, tukꞌ u Maxh, tukꞌ umaꞌt u Jacobo, vikꞌaol u Alfeo, tukꞌ u Tadeo, tukꞌ umaꞌt u Simón uvaꞌ echenik xoꞌl unqꞌa tenam uvaꞌ nik alon itilul el unqꞌa ibꞌooqꞌol unqꞌa tenameꞌ uvaꞌ atik kan taꞌn u ijlenaaleꞌ tu u Roma; ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","as tukꞌ u Judas uvaꞌ Iscariote uvaꞌ kat kꞌayin u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","As tul ok veꞌt Aak tu umaꞌl u kabꞌal, as imol veꞌt tibꞌ unqꞌa tenameꞌ. As yeꞌ nik tuch veꞌt itxꞌaꞌn Aak tukꞌ unqꞌa ichusulibꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","As tul tabꞌi veꞌt unqꞌa tatin u Jesús uvaꞌ atik Aak tu u kabꞌaleꞌ, as ul eqꞌoloj veꞌt u Jesús taꞌn unqꞌa tatineꞌ uvaꞌ nik taleꞌ, tan yannalik veꞌt iviꞌ u Jesús uveꞌ nik titzꞌa unqꞌa tatineꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ech koj unqꞌa uxhchileꞌ uvaꞌ tzaa tu u Jerusalén, uvaꞌ chuselik tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as ech nik tal chajnaj ileꞌ: —Aꞌ vibꞌooqꞌol unqꞌa subꞌuleꞌ uvaꞌ Beelzebú ni aqꞌon tijleꞌm u najeꞌ tiꞌ teesal el unqꞌa subꞌuleꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tul imolo veꞌt Aak unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as tukꞌ kꞌuchuvatz kat yolonkat Aak. As ech tal veꞌt Aak ileꞌ: —¿La kol uch itilut el u Satanás qꞌa unqꞌa imooleꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tan asoj jatxel tibꞌ umaj nimla tenam svatzaj kꞌatz u ijlenaaleꞌ, as yeꞌl u tenameꞌ uvaꞌ bꞌaꞌn koj tatineꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Asoj yeꞌ la ikꞌul tibꞌ iyol unqꞌa uxhchileꞌ svatzaj tu umaj kabꞌal, as yeꞌl unqꞌa uxhchileꞌ bꞌaꞌn koj tatineꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Asoj la ixek tibꞌ unqꞌa imool u Satanás stiꞌ, as yeꞌ kꞌulel tibꞌ iyol svatzaj. As yeꞌle bꞌa bꞌaꞌn koj tatineꞌ la ibꞌaneꞌ. As sotzchileꞌ la ibꞌan veꞌteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","As yeꞌxhebꞌil la uch tok tikabꞌal umaj naj uvaꞌ xoꞌvebꞌal chit viyakꞌileꞌ tiꞌ bꞌen telqꞌat el tzan u tetz najeꞌ. Pet lanal kꞌalpeꞌ u najeꞌ. As aꞌn la uch telqꞌal veꞌt unqꞌa tetz najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","As jik chit tuk val sete, tan jankꞌal unqꞌa paaveꞌ uvaꞌ la ibꞌan unqꞌa uxhchileꞌ as kam kuxh yoqꞌoꞌmil la taleꞌ vatz u Tiixheꞌ, as la uch isotzsal ipaav unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pet abꞌil uvaꞌ la yoqꞌon tiꞌ u Tiixhla Espíritu tiꞌ chit ibꞌeneꞌ, as yeꞌl ipaav u uxhchileꞌ la sotz veꞌteꞌ. As aapaav chit veꞌteꞌ tiꞌ chit ibꞌeneꞌ,— tiꞌk u Jesús, ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","tan tiꞌ uvaꞌ nik tal unqꞌa uxhchileꞌ uvaꞌ atik u subꞌuleꞌ kꞌatz u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","As ech unbꞌiil stuul, as ul veꞌt vitxutx u Jesús tukꞌ unqꞌa titzꞌin Aakeꞌ. As kat kuxh kaaik kan tiꞌ kabꞌal. As bꞌex alpo veꞌt ok te u Jesús uvaꞌ la el chꞌuꞌl Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","As ech tal veꞌt unqꞌa uxhchil ileꞌ uvaꞌ xonlik txala Aak: —Il ak atxutx tukꞌ unqꞌa eetzꞌin at tiꞌ kabꞌal. As nichuk axh aak,— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ech tal veꞌt u Jesús ileꞌ: —Tuk val sete uvaꞌ abꞌil ech tatineꞌ sunkꞌatz echeꞌ vuntxutxeꞌ as abꞌil uvaꞌ ech tatineꞌ sunkꞌatz echeꞌ unqꞌa vitzꞌineꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","As isaji veꞌt bꞌen Aak unqꞌa uxhchileꞌ uveꞌ xonlik txala Aak. Ech tal veꞌt Aak ileꞌ: —As ech exeꞌ echeꞌ vuntxutxeꞌ; as ech exeꞌ echeꞌ unqꞌa vitzꞌineꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","tan jankꞌal unqꞌa uxhchileꞌ uveꞌ ni niman kam uveꞌ ni tal u Tiixheꞌ, as ech tatineꞌ echeꞌ vitzꞌin, as ech tatineꞌ echeꞌ vanabꞌ, as ech tatineꞌ echeꞌ untxutx,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","As xeꞌt veꞌt u Jesús chusun unpajte tziꞌ u mar. As aꞌ chit mamaꞌla tenameꞌ imol veꞌt tibꞌ tiꞌ Aak. As ok veꞌt Aak tu umaꞌl u barco. As xonebꞌ veꞌt Aak tu u barco viꞌ u mar. As kat kaaik veꞌt kan unqꞌa tenameꞌ tziꞌ u mar. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","As tukꞌ kꞌuchuvatz nikat ichusunkat Aak. As nimal chit chusbꞌal kat tal Aak. Ech tal Aak ileꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Etabꞌitaj umaꞌl u yol tiꞌ umaꞌl u naj uvaꞌ kat bꞌex avoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","As tul av naj, as at unqꞌa iiaeꞌ uvaꞌ echik toon tu bꞌey. As ul unqꞌa tzꞌikineꞌ tu almikaꞌ. As ijuna veꞌt txoo. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","As at unqꞌa iiaeꞌ ech toon xoꞌl unqꞌa kꞌubꞌeꞌ uvaꞌ yeꞌlkat tuul txꞌavaꞌ. As oora chit kat bꞌuuqꞌi, tan yeꞌl tuul txꞌavaꞌ at xoꞌl unqꞌa kꞌubꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","As tul kat tzꞌeꞌsan veꞌt u qꞌiieꞌ, as oora kuxh kat tzaj veꞌteꞌ, tan tiꞌ uvaꞌ yeꞌl taqꞌil kat bꞌen taꞌn unqꞌa kꞌubꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","As at unqꞌa iiaeꞌ echik toon xoꞌl chꞌiꞌx. As tul kat chꞌii unqꞌa chꞌiꞌxeꞌ, as kat isoka veꞌt unqꞌa chꞌiꞌxeꞌ unqꞌa talaj chikoeꞌ. As yeꞌ kat vatzin veꞌteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pet ech koj unqꞌa iiaeꞌ uvaꞌ echik toon tu u bꞌaꞌnla txꞌavaꞌeꞌ, tan tul kat bꞌuuqꞌi, as kat chꞌii veꞌteꞌ. As kat taqꞌ ivatz. As ati uvaꞌ kat aqꞌon vinaj laval (30) ivatz; as ati kat aqꞌon oxkꞌalal (60) ivatz; as ati uvaꞌ kat aqꞌon oꞌkꞌalal (100) ivatz tiꞌ junun viꞌl,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","As ech tal veꞌt Aak ileꞌ: —Abꞌiste ex uvaꞌ nepal tu vunyoleꞌ, as etabꞌitaj uveꞌ ni valeꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","As tul uvaꞌ aꞌik kuxh veꞌt u Jesús sijunal, tukꞌ kaꞌt unqꞌa uxhchileꞌ uveꞌ atik kꞌatz Aak, tukꞌ kabꞌlavat unqꞌa ichusulibꞌ Aakeꞌ, as ichꞌoti veꞌt chajnaj isuuchil u kꞌuchuvatzeꞌ uveꞌ kat tal Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","As ech tal veꞌt Aak ileꞌ: —As sete tuk valkat isuuchil uvaꞌ yeꞌxhebꞌil ootzin tetz tiꞌ uvaꞌ kam tok unqꞌa tenameꞌ jaqꞌ u tijleꞌm u Tiixheꞌ. Pet ech koj unqꞌa tenameꞌ uvaꞌ yeꞌl tetz tiꞌ vitenam u Tiixheꞌ, tan tukꞌ kuxh kꞌuchuvatz la alaxkat unqꞌa yoleꞌ ste. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","As kꞌuxh ni tileꞌ kam uveꞌ nunbꞌaneꞌ as kꞌuxh ni tabꞌi unqꞌa yoleꞌ uvaꞌ ni valeꞌ, as yeꞌ nipal stuul; as yeꞌ nijalpu vitxumbꞌaleꞌ. Estiꞌeꞌ uvaꞌ yeꞌl ipaav la sotzi,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","As ech tal veꞌt Aak ileꞌ te unqꞌa ichusulibꞌeꞌ: —¿Ma yeꞌ nepal bꞌa tu u kꞌuchuvatzeꞌ? ¿Aꞌ kol veꞌt kaꞌt unqꞌa kꞌuchuvatzeꞌ qꞌa la pal ex stuul? ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tan u najeꞌ uveꞌ ni taveꞌ, as aꞌ u uxhchileꞌ uveꞌ ni alon isuuchil viyol u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","As unqꞌa iiaeꞌ uvaꞌ kat oon tu bꞌey, as aꞌ ni tokkateꞌ tiꞌ unqꞌa uxhchileꞌ uveꞌ ni abꞌin viyol u Tiixheꞌ. As tul maꞌt tabꞌit u yoleꞌ, as kat ul u Satanás tiꞌ teesat el u yoleꞌ tu u taanxelal u uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","As unqꞌa iiaeꞌ uveꞌ kat oon xoꞌl unqꞌa kꞌubꞌeꞌ, tan aꞌ ni tokkateꞌ tiꞌ unqꞌa uxhchileꞌ uvaꞌ tul ni tabꞌi u yoleꞌ, as nichiibꞌ stiꞌ. As ni tok u yoleꞌ tu u taanxelal. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","As yeꞌ kat yakꞌin u yoleꞌ tu u taanxelaleꞌ, tan ech unqꞌa uxhchileꞌ echeꞌ u iiaeꞌ uvaꞌ yeꞌ kat palik bꞌen u taqꞌileꞌ tu txꞌavaꞌeꞌ. As yeꞌxh jatvaꞌl qꞌii kat ibꞌana, tan tul kat ul unqꞌa kꞌaxkꞌoeꞌ tiꞌ u uxhchileꞌ tiꞌ uvaꞌ nimamal u yoleꞌ staꞌn, as oora kuxh kat kaꞌkabꞌin taama stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","As unqꞌa iiaeꞌ uveꞌ kat oon xoꞌl unqꞌa chꞌiꞌxeꞌ, as aꞌ ni tokkateꞌ tiꞌ unqꞌa uxhchileꞌ uveꞌ kat abꞌin viyol u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","As nu kuxh ixaansa unqꞌa uxhchileꞌ taama tiꞌ unqꞌa veeꞌ at vatz u txꞌavaꞌeꞌ as tukꞌ tiꞌ u txꞌiibꞌal qꞌiieꞌ uvaꞌ ni sotzsan ikꞌuꞌl unqꞌa uxhchileꞌ tiꞌ u yoleꞌ. As kam kuxh unqꞌa veeꞌ ni tachva. Estiꞌeꞌ yeꞌ niyakꞌin u yoleꞌ tu u taanxelal unqꞌa uxhchileꞌ echeꞌ umaj tzeꞌ uvaꞌ yeꞌ nivatzineꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","As unqꞌa iiaeꞌ uvaꞌ ech toon tu bꞌaꞌnla txꞌavaꞌ, as aꞌ ni tokkateꞌ tiꞌ unqꞌa uxhchileꞌ uveꞌ ni abꞌin viyol u Tiixheꞌ. As ni toksa taama tiꞌ inimataꞌ, as ech nibꞌan unqꞌa uxhchileꞌ echeꞌ unqꞌa tzeꞌeꞌ uvaꞌ nivatzineꞌ, tan ati uvaꞌ ni taqꞌ vinaj laval (30) ivatz, as ati ni taqꞌ oxkꞌalal (60) ivatz, as ati ni taqꞌ oꞌkꞌalal (100) ivatz tiꞌ junun viꞌl,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","As ech tal u Jesús ileꞌ unpajte: —¿As la kol uch qꞌa uvaꞌ tul la matxax umaj txijubꞌal, as aꞌ kol la oksalkat qꞌa jaqꞌ umaj kaaxha moj jaqꞌ umaj chꞌach? Pet aꞌ la aqꞌpikkat jeꞌeꞌ viꞌ u matxbꞌaleꞌ tiꞌ itxijuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Estiꞌeꞌ uvaꞌ yeꞌl umaj kam ati uvaꞌ yeꞌ koj la ootzili. As kam uveꞌ mujel as techal la el chꞌuꞌl viꞌ saj tiꞌ tilpeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","As abꞌiste ex uvaꞌ nepal tu vunyoleꞌ, as etabꞌitaj uveꞌ ni valeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","As ech tal veꞌt Aak ileꞌ: —Ebꞌantaj jeꞌ teviꞌ tiꞌ unqꞌa yoleꞌ uveꞌ netabꞌi, tan asoj la etoksa etaama tiꞌ etabꞌitaꞌ, as aal la taqꞌ u Kubꞌaal Tiixheꞌ etxumbꞌal tiꞌ epal stuul. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","As abꞌil uvaꞌ ni toksa taama tiꞌ inimat u yoleꞌ, kꞌuxh bꞌiil kuxh nipal stuul, as aal la chee itxumbꞌal stiꞌ. Pet ech koj u uxhchileꞌ uvaꞌ yeꞌ ni toksa taama tiꞌ tabꞌit u yoleꞌ as tukꞌ tiꞌ inimataꞌ, as aal la sotzsal veꞌt u yoleꞌ skꞌuꞌl,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","As ech tal veꞌt u Jesús ileꞌ unpajte: —Ech nibꞌan u tijleꞌm u Tiixheꞌ tiꞌ vitenameꞌ echeꞌ nibꞌan umaj naj uvaꞌ ni tava u iiaeꞌ tu u txꞌavaꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","As tul maꞌt tavat naj u iiaeꞌ, as la vat naj jun aqꞌbꞌal; as la lakpu naj jun qꞌii. As il u iia ileꞌ nixalmit veꞌteꞌ tiꞌ ichꞌiieꞌ, kꞌuxh yeꞌ tootzaj naj kam nibꞌaneꞌ tul nichꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tan aꞌ u txꞌavaꞌeꞌ kat bꞌanon uvaꞌ kat xalmit u iiaeꞌ. As kat chee veꞌt ixaj; as kat chee veꞌt toj. As nimal ivatz kat taqꞌ veꞌteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","As tul uvaꞌ kat qꞌanbꞌu veꞌt vivatzeꞌ, as kat maklu veꞌteꞌ, tan tiꞌ uvaꞌ kat ilej veꞌt viqꞌiieꞌ tiꞌ imakleꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","As ech tal veꞌt u Jesús ileꞌ unpajte: —Tuk val isuuchil sete tiꞌ uvaꞌ kam inaꞌ u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Tan ech inaꞌ vitenam Aakeꞌ echeꞌ uvaꞌ kat ibꞌan u iiaeꞌ tetz u mostaza uvaꞌ kat aval tu umaj txꞌavaꞌ. As kꞌuxh tzꞌup chit u iiaeꞌ tiꞌ unjoltu unqꞌa iiaeꞌ uvaꞌ kat aval tu u txꞌavaꞌeꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","as tul kat chꞌii veꞌteꞌ, as nim chit kat oonkat tiꞌ unjoltu unqꞌa chikoeꞌ uveꞌ at tu u txꞌavaꞌeꞌ. As nim chit unqꞌa iqꞌabꞌeꞌ kat ibꞌana. As ni tul veꞌt unqꞌa talaj tzꞌikineꞌ iꞌloj jaqꞌ vimuuil unqꞌa ixaj tzeꞌeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","As mamaꞌla kꞌuchuvatz echeꞌ unqꞌa veeꞌ kat ichus u Jesús, jankꞌal unqꞌa chusbꞌaleꞌ uveꞌ kat itxꞌol unqꞌa uxhchileꞌ ipal stuul. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","As yeꞌl umaꞌtoj yol nik tal Aak uvaꞌ jit tukꞌ kꞌuchuvatz. Pet tul uvaꞌ Aak kuxh veꞌt sijunal tukꞌ unqꞌa ichusulibꞌeꞌ, as nik tal Aak isuuchil unqꞌa kꞌuchuvatzeꞌ ste. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","As tu u qꞌiieꞌ tul uvaꞌ tzꞌotin veꞌteꞌ, as ech tal veꞌt u Jesús ileꞌ te unqꞌa ichusulibꞌeꞌ: —Koꞌnaj jalit u mar,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","As iqꞌiila veꞌt kan unqꞌa ichusulibꞌ Aakeꞌ unqꞌa tenameꞌ. As teqꞌo veꞌt bꞌen chajnaj Aak jalit u mar tu u barco. As bꞌen veꞌt kaꞌt unqꞌa uxhchileꞌ tukꞌ unqꞌa ibarco tiꞌ u barco uvaꞌ atikkat ok Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","As tul maꞌtik ipalik ok chajnaj viꞌ u mar tukꞌ u barco, as xeꞌt veꞌt umaꞌl u mam kajiqꞌ jabꞌal. As vaꞌlik chit ipilqꞌut veꞌt tibꞌ u mar. As nik tok veꞌt u aꞌeꞌ tu u barco. As bꞌiit kuxh yeꞌ nik ibꞌen veꞌt u barco xeꞌ u mar. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","As vatik chit veꞌt u Jesús tu u barco. As atik kuꞌ iviꞌ Aak viꞌ umaꞌl u vitzꞌ. As ul bꞌeyloj veꞌt Aak taꞌn unqꞌa ichusulibꞌeꞌ. As ech tal veꞌt chajnaj ileꞌ te Aak: —¿Chusul, ma yeꞌ neetzꞌa uvaꞌ tuk kamoj veꞌt oꞌ? ¡Tan tuk bꞌenoj veꞌt oꞌ tukꞌ u barco xeꞌ u mar!— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","As txakpu veꞌt u Jesús. As iyaa veꞌt Aak u kajiqꞌeꞌ tukꞌ u mar. As ech tal veꞌt Aak ileꞌ: —¡Yaꞌoj ex! ¡As yeꞌ tiin ex!— tiꞌk Aak. As yak kuxh yaꞌ veꞌt u kajiqꞌeꞌ. As liibꞌ veꞌt u mar. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","As ech tal veꞌt u Jesús ileꞌ te unqꞌa ichusulibꞌeꞌ: —¿Kam qꞌi uvaꞌ vaꞌl kuxh exoꞌv veꞌteꞌ? ¿As ma yeꞌl ex bꞌa nekꞌujbꞌaꞌ ekꞌuꞌl sviꞌ?— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","As ok veꞌt umaꞌl u mam xoꞌvichil xeꞌ taama chajnaj. As ech tal veꞌt chajnaj ileꞌ svatzaj: —¡Nim chit u tijleꞌm Aakeꞌ, tan ninimal Aak taꞌn u kajiqꞌ jabꞌaleꞌ tukꞌ u mar!— tiꞌk chajnaj svatzaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","As tul oon veꞌt u Jesús tukꞌ unqꞌa ichusulibꞌeꞌ jalit u mar, tu vitxꞌavaꞌ unqꞌa aa Gadara, ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","as el veꞌt chꞌuꞌl Aak tu u barco. As ul veꞌt umaꞌl u naj uvaꞌ atik ok umaꞌl u subꞌul skꞌatz tiꞌ ikꞌulpu u Jesús. As aꞌ elkat chꞌuꞌl u najeꞌ viꞌ kamnaj, ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","tan aꞌ atikkat naj tu uveꞌ nimujlukat unqꞌa kamnajeꞌ. As yeꞌxhebꞌil nik tolebꞌ tiꞌ ikꞌalat u najeꞌ, as mitaꞌn tukꞌ kateena. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","As jatpajul kuxh maꞌtik ikꞌalpu u toj najeꞌ tukꞌ iqꞌabꞌ naj taꞌn kateena. As nik tolebꞌ naj tiꞌ iratꞌpu u kateenaeꞌ. As yeꞌxhebꞌil nik tolebꞌ tiꞌ naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","As nik ixaan naj sqꞌiil as aqꞌbꞌal unpajte. As nik isikꞌin naj viꞌ unqꞌa vitzeꞌ as viꞌ kamnaj unpajte. As nikat kuxh ikꞌaxbꞌisa jeꞌ tibꞌ naj taꞌn unqꞌa kꞌubꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tul til naj u Jesús tziꞌaꞌn, as oojeꞌl itzaa naj. As kuꞌ naj qaaloj vatz Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","As ech tal veꞌt naj ileꞌ tukꞌ sikꞌiꞌm: —¿Kam asaꞌ sve, Jesús, iKꞌaol Tiixh uvaꞌ at tu almikaꞌ uvaꞌ nim talcheꞌ? ¡Tuk unjaj bꞌaꞌnil see tukꞌ vibꞌii u Tiixheꞌ uvaꞌ yeꞌ la aaqꞌ bꞌen in tu u kꞌaxkꞌoeꞌ!— tiꞌk u najeꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","tan tiꞌ uvaꞌ maꞌtik talat u Jesús te u najeꞌ uvaꞌ la el u subꞌuleꞌ tiꞌ naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","As ech tal veꞌt u Jesús ileꞌ te u subꞌuleꞌ: —¿Kam abꞌii?— tiꞌk Aak. As ech tal veꞌt u subꞌul ileꞌ: —Legión unbꞌii, tan nimal unxaaneꞌ,— tiꞌk u subꞌuleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","As ijaj veꞌt u subꞌuleꞌ kuybꞌal te u Jesús tiꞌ uvaꞌ yeꞌ la itilu el Aak u subꞌuleꞌ tu vitxꞌavaꞌ unqꞌa aa Gadara. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","As nimal unqꞌa chichameꞌ nik ikꞌuachineꞌ najlich umaꞌl u tal vitz. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","As ijaj veꞌt unqꞌa subꞌuleꞌ bꞌaꞌnil te u Jesús. Ech tal veꞌt ileꞌ: —¡Chaj bꞌen oꞌ tiꞌ unqꞌa chichameꞌ, aqꞌal uvaꞌ la ok oꞌ stiꞌ!— tiꞌk unqꞌa subꞌuleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","As taqꞌ veꞌt u Jesús tokebꞌal unqꞌa subꞌuleꞌ tiꞌ unqꞌa chichameꞌ. As el veꞌt chꞌuꞌl unqꞌa subꞌuleꞌ kꞌatz u najeꞌ. As ok veꞌt unqꞌa subꞌuleꞌ tiꞌ unqꞌa chichameꞌ, tan kamal kaꞌvoꞌj mil (2,000) unqꞌa chichameꞌ atik tzitziꞌ. As oojeꞌl ibꞌen veꞌt txoo tiꞌ isutit veꞌt bꞌen tibꞌ xeꞌ u mar vatz u vitzeꞌ. As kam veꞌt txoo xeꞌ u mar. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","As ooj veꞌt unqꞌa xeen chichameꞌ. As bꞌex tal veꞌt chajnaj itzibꞌlal tu u tenameꞌ tukꞌ tulaj unqꞌa talaj tenameꞌ. As nimal unqꞌa uxhchileꞌ uli tiꞌ tilataꞌ kam uveꞌ kat uchi. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tul oon unqꞌa uxhchileꞌ kꞌatz u Jesús, as til veꞌt unqꞌa uxhchileꞌ uvaꞌ xonlik veꞌt u najeꞌ uveꞌ kꞌaxbꞌinalik taꞌn unqꞌa mamaꞌla subꞌuleꞌ. As teqꞌo veꞌt taama unqꞌa uxhchileꞌ, tan atik veꞌt ok toksaꞌm u najeꞌ. As bꞌaꞌnik veꞌt iyolon naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","As tal veꞌt unqꞌa uxhchileꞌ isuuchil uvaꞌ kat ilon tel unqꞌa subꞌuleꞌ tiꞌ u najeꞌ. As kat tal veꞌt chajnaj te unqꞌa tenameꞌ kam uvaꞌ kat tila, tul uvaꞌ kat ok unqꞌa subꞌuleꞌ tiꞌ unqꞌa chichameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","As xeꞌt veꞌt unqꞌa tenameꞌ tiꞌ ijajat bꞌaꞌnil te u Jesús tiꞌ uvaꞌ la el veꞌt Aak tu u atinbꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","As tul ok veꞌt u Jesús tu u barco unpajte tiꞌ iqꞌaav Aak jalit u mar, as u naj uvaꞌ maꞌtik tel unqꞌa subꞌuleꞌ stiꞌ, as ijaj veꞌt naj bꞌaꞌnil te Aak uvaꞌ la xekebꞌ naj tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pet ech tal veꞌt Aak ileꞌ te naj: —Kuxh takabꞌal kꞌatz unqꞌa aatineꞌ. As kuxh al ste kam unqꞌa nimla bꞌaꞌnileꞌ uvaꞌ kat ibꞌanlu u Tiixheꞌ see, tan nitxum Aak avatz,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","As bꞌex ipaxsa veꞌt u najeꞌ itzibꞌlal u Jesús tulaj unqꞌa tenameꞌ uveꞌ tu Decápolis kam u bꞌaꞌnileꞌ uveꞌ kat ibꞌan Aak te naj. As kajayil chit unqꞌa uxhchileꞌ teqꞌo veꞌt taama. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","As tul maꞌt iqꞌax veꞌt u Jesús jalit u mar tukꞌ u barco unpajte, as mamaꞌla tenam imol veꞌt tibꞌ tiꞌ Aak. As kaa veꞌt Aak tziꞌ u mar. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","As ul veꞌt umaꞌl u naj uvaꞌ Jairo ibꞌii uvaꞌ bꞌooqꞌolik xoꞌl unqꞌa tiaal Israel tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh. As tul til naj u Jesús, as qaaebꞌ veꞌt naj vatz Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","As vaꞌlik chit ijajat veꞌt naj bꞌaꞌnil te Aak. Ech tal veꞌt naj ileꞌ: —Tuk kamoj veꞌt vas unmeꞌaleꞌ. Pet bꞌan bꞌaꞌnil. Kuxh ila. As la aaqꞌ jeꞌ aqꞌabꞌ stiꞌ, aqꞌal uvaꞌ la bꞌaꞌnxi. As yeꞌxhkam la kami,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","As bꞌen veꞌt u Jesús tiꞌ naj. As aꞌ chit mamaꞌla tenameꞌ xekelik tiꞌ Aak. As vaꞌlik chit ipochꞌat veꞌt unqꞌa tenameꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","As atik ok umaꞌl u ixoj xoꞌl unqꞌa tenameꞌ uvaꞌ kabꞌlavaxnik yaabꞌ ixeꞌt chꞌoꞌnoj, tan aꞌ vitxꞌaao u ixojeꞌ yeꞌ nik iyaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","As maꞌtik kuxh ibꞌuchlu ixoj taꞌn unqꞌa aatzꞌakeꞌ. As maꞌtik kuxh isotzsat ixoj vipuajeꞌ taꞌn unqꞌa aatzꞌakeꞌ. As yeꞌ nik ibꞌaꞌnx veꞌt ixoj. Pet aal chit nik inimxu veꞌt u chꞌoꞌmeꞌ kꞌatz ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Tul uvaꞌ tabꞌi veꞌt ixoj itzibꞌlal u Jesús, as oon veꞌt ixoj tiꞌ ijetzꞌet ok tibꞌ tiꞌ iqul Aak xoꞌl unqꞌa tenameꞌ. As ikan veꞌt ok ixoj u toksaꞌm Aakeꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","tan ech nik tal jeꞌ ixoj ileꞌ ste: «Tul kuxh la unkanoꞌk u toksaꞌm u Jesús, as tuk bꞌaꞌnxoj veꞌt ineꞌ,» tiꞌk ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","As tul kuxh ikan ixoj u toksaꞌm Aakeꞌ, as yak kuxh yaꞌ veꞌt vitxꞌaao ixojeꞌ skꞌatz. As inach veꞌt ixoj uvaꞌ bꞌaꞌnik veꞌt ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","As inach veꞌt u Jesús uvaꞌ maꞌtik tel chꞌuꞌl u bꞌaꞌnileꞌ kꞌatz Aak. As isuchqꞌi veꞌt tibꞌ Aak xoꞌl unqꞌa tenameꞌ. Ech tal veꞌt Aak ileꞌ: —¿Abꞌil kat kanon u voksaꞌmeꞌ?— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","As ech tal veꞌt unqꞌa ichusulibꞌ Aak ileꞌ: —U mam tenameꞌ ni pochꞌon axh. ¿As kam qꞌi uveꞌ naaleꞌ uvaꞌ: «¿Abꞌil kat kanon u voksaꞌmeꞌ?» chꞌaxh naaleꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","As yeꞌ nikat iyaꞌ Aak tiꞌ isajineꞌ xoꞌl unqꞌa tenameꞌ tiꞌ uvaꞌ abꞌil kat kanon Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","As atik veꞌt skꞌuꞌl u ixojeꞌ uvaꞌ maꞌtik ibꞌaꞌnx veꞌt ixoj. As ijetzꞌ veꞌt ok tibꞌ ixoj. As kuꞌ veꞌt ixoj qaaloj vatz Aak, tan vaꞌlik chit itꞌuntꞌuch veꞌt ixoj taꞌn xoꞌvichil. As tal veꞌt ixoj isuuchil te Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","As ech tal veꞌt Aak ileꞌ: —Ixoj, kat elyu veꞌt u chꞌoꞌmeꞌ seeꞌ, tan tiꞌ uvaꞌ kat akꞌujbꞌaꞌ akꞌuꞌl sviꞌ. As bꞌaꞌn veꞌt axh. As aꞌ vibꞌaꞌnil u Tiixheꞌ la bꞌen seeꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","As antelik kuxh iyolon Aak tukꞌ u ixojeꞌ, tul bꞌex uloj veꞌt kaꞌl unqꞌa uxhchil uvaꞌ chajel veꞌt taꞌn unqꞌa tatin u Jairo uvaꞌ nik bꞌooqꞌolin u atinbꞌaleꞌ tetz nachbꞌal Tiixh. Ech ul tal ileꞌ te naj: —Kat kamyu veꞌt vas ameꞌaleꞌ. As yeꞌxhkam kuxh aal veꞌt te u Chusuleꞌ,— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","As tul tabꞌi veꞌt u Jesús u yoleꞌ, as ech tal veꞌt Aak ileꞌ te u najeꞌ uvaꞌ nik bꞌooqꞌolin u atinbꞌaleꞌ tetz nachbꞌal Tiixh: —Yeꞌ kuxh xoꞌv axh. Pet kꞌujbꞌaꞌ akꞌuꞌl sviꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","As tal veꞌt Aak uvaꞌ yeꞌl unqꞌa tenameꞌ la bꞌen tiꞌ Aak. Pet taꞌn kuxh u Luꞌeꞌ tukꞌ u Santiago tukꞌ u Xhuneꞌ, u titzꞌin u Santiago, kat teqꞌo Aak stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","As tul oon veꞌt Aak tukꞌ chajnaj tu vikabꞌal u Jairo, as til veꞌt Aak uvaꞌ vaꞌlik chit toqꞌ unqꞌa uxhchileꞌ tiꞌ u xvaakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","As ok veꞌt Aak tu kabꞌal. As ech tal veꞌt Aak ileꞌ: —¿As kam qꞌi uveꞌ vaꞌl kuxh etoqꞌeꞌ tiꞌ u xvaakeꞌ? Tan yeꞌl ixoj kamnal koj. Pet vatik kuxheꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","As itzeꞌle kuxh unqꞌa uxhchileꞌ viyol Aakeꞌ. As tal veꞌt Aak uvaꞌ la el unqꞌa uxhchileꞌ tiꞌeꞌl kabꞌal. As teqꞌo veꞌt ok Aak oxvaꞌl unqꞌa ichusulibꞌeꞌ stiꞌ uvaꞌ xekelik tiꞌ Aak. As ok veꞌt Aak tukꞌ chajnaj, tukꞌ vibꞌaal u xvaakeꞌ, as tukꞌ vitxutxeꞌ, tu uvaꞌ atikkat u xvaakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","As itxey veꞌt Aak iqꞌabꞌ u xvaakeꞌ. As ech tal veꞌt Aak ileꞌ: —Talita cumi,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","As txakpu veꞌt u xvaakeꞌ uvaꞌ kabꞌlavalik kuxh iyaabꞌ. As xaan veꞌt ixoj. As teqꞌo veꞌt taama unqꞌa uxhchileꞌ uvaꞌ atik ok tu u kabꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","As ibꞌeya veꞌt Aak te unqꞌa uxhchileꞌ uvaꞌ yeꞌxh katil la alpukat tiꞌ uvaꞌ kat tulsa Aak taama u xvaakeꞌ. As tal veꞌt Aak uvaꞌ la aqꞌax veꞌt techbꞌubꞌal ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","As el veꞌt chꞌuꞌl u Jesús tu vikabꞌal u Jairo. As oon veꞌt Aak tu vitenameꞌ uvaꞌ Nazaret. As xekelik unqꞌa ichusulibꞌ Aakeꞌ stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","As tul ilej veꞌt u xeem qꞌiieꞌ, as ok Aak tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh. As xeꞌt veꞌt Aak chusun. Tul tabꞌi veꞌt unqꞌa uxhchileꞌ ichusun Aak, as teqꞌo veꞌt taama unqꞌa uxhchileꞌ. As ech tal veꞌt ileꞌ svatzaj: —¿Katileꞌ qꞌi kat bꞌex teqꞌokat u najeꞌ vitxumbꞌaleꞌ tiꞌ unqꞌa nimla bꞌaꞌnileꞌ uvaꞌ nibꞌan naj? ¿As kam nimla txumbꞌalileꞌ qꞌi kat bꞌex ichus tibꞌ naj stiꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿As moj jit u najeꞌ uvaꞌ seeol, u tal u Maꞌleꞌ? ¿As moj jit titzꞌin najeꞌ u Jacobo, tukꞌ u Xhuꞌl, tukꞌ u Judas, tukꞌ u Simón? As ootzimaleꞌ unqꞌa tanabꞌ najeꞌ sqaꞌn,— tiꞌk unqꞌa uxhchileꞌ svatzaj, tan yeꞌ kat isaꞌ unqꞌa uxhchileꞌ inimat u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","As ech tal veꞌt u Jesús ileꞌ te unqꞌa uxhchileꞌ: —As katil kuxh la oksalkat iqꞌii umaꞌl u qꞌajsan tetz viyol u Tiixheꞌ. Pet ech koj tu vitenameꞌ tukꞌ xoꞌl unqꞌa tatineꞌ tikabꞌal, tan echeꞌ la koj oksal iqꞌii,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","As jit uch ibꞌanat veꞌt Aak unqꞌa nimla bꞌaꞌnileꞌ tu vitenameꞌ. Pet taꞌn kuxh kaꞌl unqꞌa aachꞌoꞌm kat taqꞌ jeꞌ Aak iqꞌabꞌ stiꞌ. As kat bꞌaꞌnxi. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","As kat yan veꞌt te Aak uvaꞌ yeꞌ kat ikꞌujbꞌaꞌ unqꞌa uxhchileꞌ ikꞌuꞌl tiꞌ Aak. As bꞌex isoli veꞌt Aak unqꞌa talaj tenameꞌ uveꞌ echen najlich u Nazaret. As nikat ichusun veꞌt Aak tzitziꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","As imolo veꞌt Aak kabꞌlaval unqꞌa ichusulibꞌeꞌ. As ichaj veꞌt bꞌen Aak chajnaj. As kaꞌkabꞌil teqꞌot tibꞌ chajnaj kat ibꞌan Aak. As taqꞌ veꞌt Aak tijleꞌm chajnaj tiꞌ teesal unqꞌa subꞌuleꞌ kꞌatz unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","As kat tal bꞌen Aak te chajnaj uvaꞌ yeꞌl unbꞌooj tetz chajnaj la teqꞌo tu bꞌey. As yeꞌl isam chajnaj la teqꞌo. As mitaꞌn txꞌix; as mitaꞌn puaj. Pet taꞌn kuxh vikarote chajnajeꞌ la teqꞌo. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","As la uch toksat chajnaj ixaꞌp. Pet yeꞌl kaꞌvoꞌj toksaꞌm chajnaj la teqꞌo. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","As ech tal veꞌt Aak ileꞌ: —Abꞌiste u kabꞌaleꞌ uvaꞌ la kꞌulpukat ex uvaꞌ la bꞌenkat ex, as tzitziꞌ la atinkat ex lanal el chꞌuꞌl ex tu u tenameꞌ. As aꞌn la etaqꞌ kan u atinbꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Asoj at umaj tenam uvaꞌ yeꞌ la kꞌulpukat ex, asoj yeꞌ la isaꞌ unqꞌa tenameꞌ tabꞌit veyoleꞌ, as la el chꞌuꞌl ex tzitziꞌ. As la echitu el u pojoeꞌ uveꞌ at tiꞌ vetojeꞌ, texhlal tetz uvaꞌ yeꞌ bꞌaꞌn vitxumbꞌal unqꞌa tenameꞌ. As jik chit tuk val sete uvaꞌ tu u qꞌiieꞌ uveꞌ la ulkat u kꞌaxkꞌoeꞌ, tan nimeꞌ u kꞌaxkꞌoeꞌ la ul tiꞌ u tenameꞌ tiꞌ uveꞌ kat ul tiꞌ u Sodoma tukꞌ u Gomorra,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","As el veꞌt chꞌuꞌl unqꞌa ichusulibꞌ u Jesús tiꞌ bꞌen talat te unqꞌa tenameꞌ uvaꞌ la ikꞌaxa tibꞌ unqꞌa tenameꞌ tiꞌ tok kꞌatz u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","As kat teesa veꞌt el chajnaj unqꞌa subꞌuleꞌ tiꞌ unqꞌa uxhchileꞌ. As nimal unqꞌa aachꞌoꞌmeꞌ kat ivaa chajnaj taꞌn aceite. As kat bꞌaꞌnx veꞌt unqꞌa aachꞌoꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","As tabꞌi veꞌt u ijlenaaleꞌ uvaꞌ Herodes uvaꞌ nik toksal veꞌt iqꞌii u Jesús, tan katil kuxh nik tokkat veꞌt iqꞌii Aak. As ech tal veꞌt naj ileꞌ: —Aꞌ u Xhuneꞌ uvaꞌ nik aqꞌon kuꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ uvaꞌ kat ulyu taama unpajte. Estiꞌeꞌ ni tolebꞌ tiꞌ ibꞌanat unqꞌa nimla bꞌaꞌnileꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pet ech tal kaꞌt unqꞌa uxhchil ileꞌ: —Kamal u Elías,— tiꞌke. As at unjolte uvaꞌ ech nik tal ileꞌ: —Kamal aꞌ umaj u qꞌajsan tetz viyol u Tiixheꞌ echeꞌ unqꞌa uvaꞌ kat ul naꞌytzan,— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","As tul tabꞌi veꞌt u Herodes u yoleꞌ tiꞌ u Jesús, as ech tal veꞌt naj ileꞌ: —Aꞌ u Xhuneꞌ bꞌa kat ulyu taama unpajte uvaꞌ kat val itzokꞌpik el iviꞌ,— tiꞌk u Herodes. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Tan maꞌtik talat naj itxeypu u Xhuneꞌ, as tal naj iqitzpu taꞌn kateena tu u kaarsa tiꞌ inimal viyol u Herodías, u tixqel u Piꞌl uvaꞌ titzꞌin u Herodes, tan ixoj alon uvaꞌ la yatzꞌpu u Xhuneꞌ, tan tixqelik veꞌt u Herodes u Herodías. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","As aꞌ ibꞌankat u Herodes, tan ech nik tal u Xhun ileꞌ te u Herodes: «Paaveꞌ kat abꞌana, tan kat eexqeli veꞌt u tixqel veetzꞌineꞌ,» tiꞌk u Xhuneꞌ tala. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","As nik ichꞌoꞌn veꞌt taama u Herodías tiꞌ u Xhuneꞌ. As ichuk veꞌt ixoj txumbꞌal tiꞌ iyatzꞌpu u Xhuneꞌ, tan nikat isaꞌ ixoj uvaꞌ la kam u Xhuneꞌ. As yeꞌ nik tolebꞌ ixoj, ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","tan nik ixoꞌva u Herodes u Xhuneꞌ, tan naꞌlik vatz u Herodes uvaꞌ jik itxumbꞌal u Xhuneꞌ as yeꞌl u vaꞌlexheꞌ nik ibꞌaneꞌ. Estiꞌeꞌ nik ikol u Herodes u Xhuneꞌ vatz ixoj. As kꞌuxh nik isotz veꞌt ikꞌuꞌl u Herodes taꞌn viyol u Xhuneꞌ, as nik ichiibꞌ naj tiꞌ tabꞌil unqꞌa yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","As aꞌ uchkat veꞌt vatz u Herodías tul uvaꞌ kat tzꞌaj veꞌt iyaabꞌ u Herodes, tan kat ibꞌan veꞌt naj umaꞌl u bꞌaꞌnla txꞌaꞌoꞌm tukꞌ unqꞌa bꞌooqꞌol tenameꞌ, tukꞌ unqꞌa lochol tetz najeꞌ, as tukꞌ kaꞌt unqꞌa najeꞌ uveꞌ nim iyolbꞌeleꞌ tu u Galilea. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","As ok veꞌt u tal u Herodías bꞌixoj tu u nimla qꞌiieꞌ. As achaꞌvik chit ibꞌix ixoj uveꞌ til u Herodes tukꞌ unqꞌa imooleꞌ uveꞌ atik ok skꞌatz viꞌ u meexhaeꞌ. As ech tal veꞌt u Herodes ileꞌ te ixoj: —Jaj sve kam uveꞌ nasaꞌ. As la vaqꞌ see,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","As tukꞌ tiila yol taltziꞌ veꞌt u Herodes. As ech tal ileꞌ: —Kꞌuxh la ajaj unpokꞌoꞌchoj u txꞌiibꞌal unqꞌiieꞌ, as techal la vaqꞌ see kam uvaꞌ la ajaj sve,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","As el veꞌt chꞌuꞌl ixoj. As ul ichꞌoti veꞌt ixoj te vitxutxeꞌ: —¿Kam qꞌi la unjajeꞌ?— tiꞌk ixoj. As ech tal veꞌt u txutxa ileꞌ: —Jaj viviꞌ u Xhuneꞌ uvaꞌ nik aqꞌon kuꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ,— tiꞌk vitxutx ixojeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","As oora chit ok veꞌt ixoj uveꞌ atikkat u Herodes. As ech tal veꞌt ixoj ileꞌ: —Aꞌ ni valeꞌ uvaꞌ la aaqꞌ tzan viviꞌ u Xhuneꞌ sve cheel tu umaj pulaato,— tiꞌk ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","As txumun veꞌt u Herodes tiꞌ uvaꞌ ijaj ixoj viviꞌ u Xhuneꞌ. Tan tiꞌ uvaꞌ maꞌtik tal tziꞌt naj te ixoj tukꞌ tiila yol vatz unqꞌa ilonaaleꞌ viꞌ u meexhaeꞌ, as taqꞌ chit veꞌt naj kam uvaꞌ ijaj ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","As yak kuxh ichaj veꞌt bꞌen naj umaꞌl u sol tiꞌ bꞌen teqꞌot tzan viviꞌ u Xhuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","As bꞌex veꞌt u soleꞌ tu u kaarsaeꞌ. Itzokꞌ veꞌt el naj viviꞌ u Xhuneꞌ. As teqꞌo veꞌt tzan naj tu umaꞌl u pulaato. As taqꞌ veꞌt ok naj te u ixojeꞌ; as taqꞌ veꞌt ok ixoj te vitxutxeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tul uvaꞌ tabꞌi veꞌt unqꞌa ichusulibꞌ u Xhuneꞌ, as ul teqꞌo veꞌt chajnaj vichiꞌol u Xhuneꞌ. As bꞌex imuj veꞌt chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","As kat ul veꞌt kabꞌlaval unqꞌa ichusulibꞌ u Jesús skꞌatz. As kat ul tal veꞌt chajnaj te u Jesús kam chit uvaꞌ kat bꞌex ibꞌan chajnaj, as kam uvaꞌ kat bꞌex ichus kan chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","As ech tal veꞌt u Jesús ileꞌ: —Koꞌnaj tu umaꞌl u atinbꞌal uvaꞌ yeꞌlkat uxhchil. As koꞌnaj unbꞌooj iꞌloj,— tiꞌk Aak, tan mamaꞌla chit tenam nikat tuleꞌ; as nik ibꞌeneꞌ. As yeꞌ nik tuch veꞌt itxꞌaꞌn chajnaj tukꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","As ok veꞌt chajnaj tu umaꞌl u barco. As bꞌen veꞌt chajnaj tukꞌ u Jesús tu umaꞌt u atinbꞌal uvaꞌ yeꞌlikkat tenam. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pet nimal chit tenam ilon veꞌt ibꞌen Aak tukꞌ chajnaj. As kat el chꞌuꞌl stoj tulaj unqꞌa talaj tenameꞌ tiꞌ ibꞌen ikꞌulat Aak tziꞌ u aꞌeꞌ. As bꞌaxik oon veꞌt unqꞌa tenameꞌ vatz Aak. As kat imol veꞌt tibꞌ unqꞌa tenameꞌ tiꞌ Aak unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","As tul el veꞌt chꞌuꞌl u Jesús tu u barco, as til veꞌt Aak u mamaꞌla tenameꞌ. As itxum veꞌt Aak ivatz, tan ech veꞌteꞌ echeꞌ unjoloj kaneeroꞌ uvaꞌ yeꞌl xeen tetz ati. As xeꞌt veꞌt Aak chusun. As nimal chusbꞌal tal Aak ste. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","As tul kuꞌ veꞌt qꞌii, as jetzꞌen veꞌt ok unqꞌa ichusulibꞌ Aakeꞌ skꞌatz. As ech tal veꞌt chajnaj ileꞌ te Aak: —Kat kuꞌy veꞌt qꞌii. As tul yeꞌl kabꞌal at tzitzaꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","As yeꞌl techbꞌubꞌal unqꞌa tenameꞌ eqꞌomal staꞌn. Pet al ste uvaꞌ la bꞌen iloqꞌ ipaan tulaj unqꞌa kabꞌaleꞌ as tulaj unqꞌa talaj tenameꞌ uvaꞌ najli kuxhtuꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","As ech tal veꞌt Aak ileꞌ: —Yeꞌle, pet ex la aqꞌon ipaan,— tiꞌk Aak. As ech tal veꞌt chajnaj ileꞌ: —¿As ma oꞌ la bꞌen loqꞌon veꞌt ipaan unqꞌa tenameꞌ uvaꞌ naaleꞌ? Tan aꞌ ni taleꞌ uvaꞌ at laakꞌaloj (200) qꞌii aqꞌon tiꞌ ijaꞌmil ipaan unqꞌa tenameꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ech tal veꞌt Aak ileꞌ: —As bꞌen etiltaj jankꞌoj paan ati,— tiꞌk Aak. As bꞌex til veꞌt chajnaj. As ech ul tal veꞌt chajnaj ileꞌ: —Oꞌvaꞌl kuxh paan ati tukꞌ kaꞌvaꞌt u txay,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","As tal veꞌt Aak te unqꞌa ichusulibꞌeꞌ uvaꞌ la xonebꞌ unqꞌa tenameꞌ skajayil tiꞌ chaj tꞌuubꞌul vatz u chaqꞌaalaeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","As xonebꞌ veꞌt unqꞌa tenameꞌ vatz u chaqꞌaalaeꞌ tiꞌ chaj tꞌuubꞌul. Ati uvaꞌ oꞌkꞌalal (100) itꞌubꞌit tibꞌ; as ati uvaꞌ laval toxkꞌal (50) itꞌubꞌit tibꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","As itxey veꞌt Aak oꞌvaꞌl unqꞌa paaneꞌ tukꞌ kaꞌvaꞌt unqꞌa txayeꞌ. As kaꞌyik veꞌt jeꞌ Aak tu almikaꞌ. As taqꞌ veꞌt Aak taꞌntiixh te u Tiixheꞌ stiꞌ. As ijatx veꞌt Aak. As taqꞌ veꞌt Aak unqꞌa paaneꞌ tukꞌ kaꞌvaꞌt unqꞌa txayeꞌ te unqꞌa ichusulibꞌeꞌ tiꞌ uvaꞌ la ijatx veꞌt chajnaj xoꞌl unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","As tul maꞌtik itxꞌaꞌn unqꞌa tenameꞌ sbꞌaꞌn skajayil, ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","as imol veꞌt unqꞌa ichusulibꞌ Aakeꞌ unqꞌa yaꞌl paaneꞌ tukꞌ unqꞌa yaꞌl txayeꞌ. As nootel kabꞌlavat xuꞌk staꞌn. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","As oꞌvaꞌl mil unqꞌa najeꞌ uveꞌ kat txꞌaꞌni. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","As tul uvaꞌ nik iqꞌiila kan u Jesús unqꞌa tenameꞌ, as tal veꞌt Aak te unqꞌa ichusulibꞌeꞌ uvaꞌ la ok veꞌt chajnaj tu u barco as la bꞌax veꞌt chajnaj vatz Aak tiꞌ iqꞌaxit u mar as tiꞌ toon chajnaj tu u tenam u Betsaida. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","As tul maꞌt iqꞌiilat kan Aak unqꞌa tenameꞌ, as bꞌex veꞌt Aak viꞌ umaꞌl tal vitz sijunal tiꞌ inachat Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","As kaaik veꞌt kan Aak sijunal viꞌ u vitzeꞌ. As maꞌtik toon veꞌt u barco pokꞌoꞌch u mar, tul aalik itzꞌotin veꞌteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","As tul txantik isajbꞌu veꞌteꞌ, as til u Jesús uvaꞌ vaꞌlik chit iyaꞌlut tibꞌ chajnaj tukꞌ u barco, tan aalik itzaa u kajiqꞌeꞌ vatz u barco. As xaoꞌm tok veꞌt Aak viꞌ u mar tiꞌ bꞌen ilejat Aak chajnaj. As tal veꞌt Aak ibꞌax vatz chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tul til chajnaj uvaꞌ nikat ixaan veꞌt Aak viꞌ u mar, as nik tal chajnaj uvaꞌ kamal xoꞌval uveꞌ nik til chajnaj. As sikꞌin veꞌt chajnaj, ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","tan kajayil chit chajnaj ilon. As xoꞌv veꞌt chajnaj. As yolon veꞌt u Jesús te chajnaj. As ech tal veꞌt Aak ileꞌ: —Yeꞌ kuxh xoꞌv ex. Pet etiibꞌisataj etaama, tan ineꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","As jeꞌ veꞌt u Jesús tu u barco kꞌatz chajnaj. As yak kuxh yaꞌ veꞌt u kajiqꞌeꞌ. As teqꞌo chit veꞌt taama chajnaj, ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","tan tiꞌ uvaꞌ yeꞌ nik ipal chajnaj stuul tiꞌ u tijleꞌm u Jesús uvaꞌ ibꞌan Aak tul sinaꞌsat Aak u paaneꞌ, tan aluxik kuxh taama chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","As tul maꞌtik iqꞌaxit u Jesús u mar tukꞌ unqꞌa ichusulibꞌeꞌ, as oon veꞌt chajaak tziꞌ u aꞌeꞌ tu u txꞌavaꞌeꞌ uvaꞌ Genesaret. As tzitziꞌ ikꞌalkat veꞌt chajnaj u barco tziꞌ u aꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","As tul el veꞌt chꞌuꞌl chajnaj tu u barco tukꞌ u Jesús, as yak kuxh texhla veꞌt unqꞌa tenameꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tul nik ipal Aak tulaj unqꞌa tenameꞌ uvaꞌ echen najlich u Genesaret, as kat eqꞌol veꞌt tzan unqꞌa aachꞌoꞌmeꞌ viꞌ unqꞌa chꞌachiꞌm tzeꞌeꞌ tu uvaꞌ nik tabꞌilkat unqꞌa uxhchileꞌ uveꞌ atikkat Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","As katil uveꞌ nik ipalkat Aak, moj tulaj unqꞌa tenameꞌ, moj tulaj unqꞌa talaj tenameꞌ, as moj tulaj vitz, as nik taqꞌ kuꞌ unqꞌa uxhchileꞌ unqꞌa aachꞌoꞌmeꞌ tu bꞌey. As nik ijaj kuybꞌal te Aak uvaꞌ aal kuxh koj u toksaꞌm Aakeꞌ la ikan unqꞌa aachꞌoꞌmeꞌ uveꞌ nik taleꞌ, tan abꞌil uveꞌ nik kanon u toksaꞌm Aakeꞌ, as yak chit nik tel u chꞌoꞌmeꞌ stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","As kaꞌl unqꞌa fariseo uvaꞌ aꞌ tzaanajlikkat tu u Jerusalén tukꞌ kaꞌt unqꞌa uxhchileꞌ uvaꞌ chuselik tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as oon veꞌt chajnaj kꞌatz u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","As til veꞌt chajnaj kaꞌl unqꞌa ichusulibꞌ Aakeꞌ uvaꞌ jit itxꞌaa chajnaj iqꞌabꞌ tul nitxꞌaꞌneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Pet ech koj unqꞌa fariseo tukꞌ unjoltu unqꞌa tiaal Israel skajayil, tan nik inima chajnaj unqꞌa yoleꞌ uvaꞌ kꞌujlik kan taꞌn unqꞌa qꞌesla ibꞌaaleꞌ. As aꞌ nik tal chajnaj uvaꞌ yeꞌxhebꞌil la txꞌaꞌni asoj yeꞌxhebꞌil la itxꞌaa iqꞌabꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","As tul uvaꞌ maꞌt itzaa chajnaj tu kꞌayibꞌal, as yeꞌ la uch itxꞌaꞌneꞌ asoj yeꞌxnaj itxꞌaat iqꞌabꞌ. As nimatel kuxh unqꞌa txumbꞌaleꞌ nik inima chajnaj, echeꞌ u txꞌaao tuul u picheeleꞌ, tukꞌ u xhaaloeꞌ, tukꞌ unqꞌa chꞌichꞌ xhiꞌleꞌ, tukꞌ unqꞌa isokeꞌ uvaꞌ nisoka tul nitxꞌaꞌneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Estiꞌeꞌ kat ichꞌoti veꞌt chajnaj te u Jesús. As ech tal veꞌt chajnaj ileꞌ te Aak: —¿Kam qꞌi uvaꞌ yeꞌ ninima unqꞌa achusulibꞌeꞌ unqꞌa yoleꞌ uvaꞌ kꞌujlu kan taꞌn unqꞌa qꞌesla kubꞌaaleꞌ? Tan yeꞌl iqꞌabꞌ chajnaj nitxꞌaaeꞌ tul nitxꞌaꞌn chajnaj,— tiꞌk unqꞌa fariseo tukꞌ unqꞌa uxhchileꞌ uvaꞌ chuselik tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ech tal veꞌt u Jesús ileꞌ: —¡Kaꞌvatz kuxh ex! Tan an chiteꞌ u yoleꞌ uvaꞌ tzꞌibꞌamal kan setiꞌ taꞌn u qꞌajsan tetz viyol u Tiixheꞌ uvaꞌ Isaías, tul ech tal u Tiixh ileꞌ ste: Tul ni toksa unqꞌa tenameꞌ unqꞌii, as itziꞌ kuxh unqꞌa tenameꞌ ni alon. Pet ech koj u taanxelal unqꞌa tenameꞌ, tan yeꞌ ni toksa taama sviꞌ tiꞌ inimat in. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","As kamchaj la itxaꞌki tul uvaꞌ la inach in unqꞌa tenameꞌ, tan tul nichusuneꞌ, as aꞌ kuxh unqꞌa chusbꞌaleꞌ nichuseꞌ uveꞌ at kan taꞌn unqꞌa qꞌesla ibꞌaaleꞌ, tiꞌk u Tiixheꞌ tal te u Isaías. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","As echeꞌ uveꞌ nebꞌaneꞌ, tan netaqꞌ kan u tzaqꞌiteꞌ uvaꞌ tzꞌibꞌamal kan. As aꞌ uvaꞌ kꞌujlu kan taꞌn unqꞌa najeꞌ nenima, echeꞌ u txꞌaap tuul unqꞌa xhaaloeꞌ tukꞌ unqꞌa picheeleꞌ uveꞌ netukꞌaꞌkat, as tukꞌ kaꞌt unqꞌa txumbꞌaleꞌ uveꞌ nebꞌaneꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","As ech tal veꞌt u Jesús ileꞌ unpajte: —As tiꞌ kuxh inimal vichusbꞌal unqꞌa najeꞌ, as nexaqꞌpi kan u tzaqꞌiteꞌ uvaꞌ tzꞌibꞌamal kan. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","As ech kat tal kan u Moisés ileꞌ: «Xoꞌnoj vetxutxeꞌ sete tukꞌ vebꞌaaleꞌ,» tiꞌk Aak tala. As ech tal Aak ileꞌ unpajte: «Abꞌil uvaꞌ la iyoqꞌ vitxutxeꞌ tukꞌ vibꞌaaleꞌ, as techal la yatzꞌpi,» tiꞌke. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pet ech koj ex, tan ech netal ileꞌ tul nechus unqꞌa uxhchileꞌ: «Kam koj umaꞌtoj la uch ibꞌanat umaj uxhchil. Pet aꞌ la tal u uxhchileꞌ te vitxutxeꞌ tukꞌ te vibꞌaaleꞌ: –Yeꞌxhkam la vulbꞌe veꞌt unlochat ex, tan corbán unqꞌa vetzeꞌ skajayil,– » chaj la taleꞌ uveꞌ netaleꞌ. (As aꞌ isuuchil u yoleꞌ corbán: As aꞌ unqꞌa oyeꞌ uveꞌ la aqꞌax te u Tiixheꞌ.) ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","As aꞌ netaleꞌ uvaꞌ ech la ibꞌan unqꞌa uxhchileꞌ te u txutx ibꞌaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","As nepaasa veꞌt tzii tiꞌ u tzaqꞌiteꞌ uvaꞌ tzꞌibꞌamal kan tiꞌ enimat unqꞌa chusbꞌaleꞌ uveꞌ kꞌujlu kan sexoꞌl taꞌn unqꞌa qꞌesla ebꞌaaleꞌ. As attel unjoltu unqꞌa yoleꞌ tiꞌ u tzaqꞌiteꞌ uvaꞌ tzꞌibꞌamal kan uvaꞌ yeꞌ nenima,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","As imolo veꞌt tzan Aak unqꞌa tenameꞌ skꞌatz. As ech tal veꞌt Aak ileꞌ: —Etabꞌitaj vunyoleꞌ. As palojtaj ex stuul sekajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tan yeꞌl umaj echbꞌubꞌal la yansan taanxelal umaj uxhchil, tul la techbꞌu. Pet u vaꞌlexhla yoleꞌ uveꞌ la el chꞌuꞌl tu u taanxelal u uxhchileꞌ, as aꞌeꞌ nipaavinsan vatz u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","As abꞌiste ex uvaꞌ nepal tu vunyoleꞌ, as etabꞌitaj uveꞌ ni valeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","As taqꞌ veꞌt kan u Jesús unqꞌa tenameꞌ. As ok veꞌt Aak tu kabꞌal. As ichꞌoti veꞌt unqꞌa ichusulibꞌ Aakeꞌ ste tiꞌ u yoleꞌ uvaꞌ tal Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","As ech tal veꞌt Aak ileꞌ: —¿As mitaꞌn kuxh ex bꞌa nepal tu u yoleꞌ? ¿As ma yeꞌ nepal stuul? Tan kam uveꞌ la techbꞌu umaj uxhchil, as jiteꞌ la paavinsan u uxhchileꞌ vatz u Tiixheꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","tan yeꞌle ni tok tu u taanxelaleꞌ. Pet yaklu pal kuxheꞌ tu tuuleꞌ,— tiꞌk u Jesús. As aꞌ isuuchil u yoleꞌ uvaꞌ tal Aak tiꞌ uvaꞌ la uch techbꞌul unqꞌa echbꞌubꞌaleꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","As kat tal Aak: —Tul la el chꞌuꞌl umaj u vaꞌlexhla yol tu u taanxelal umaj uxhchil, as aꞌeꞌ ni yansan u taanxelal u uxhchileꞌ vatz u Tiixheꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","tan tu u taanxelal unqꞌa uxhchileꞌ ni telkat chꞌuꞌl unqꞌa vaꞌlexhla chaj txumbꞌaleꞌ, echeꞌ unqꞌa najeꞌ uveꞌ nichuk tixoj, tukꞌ unqꞌa uxhchileꞌ uvaꞌ niyansa tibꞌ tukꞌ umaꞌt uxhchil, tukꞌ unqꞌa yatzꞌol aamaeꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","tukꞌ unqꞌa elaqꞌeꞌ, tukꞌ u achvan txꞌiibꞌal qꞌiieꞌ, tukꞌ unjoltu unqꞌa vaꞌlexheꞌ, tukꞌ unqꞌa uxhchileꞌ uveꞌ ni maxtibꞌen imool, tukꞌ unqꞌa tachaꞌv vichiꞌoleꞌ, tukꞌ u chꞌoꞌnchil aamaeꞌ, tukꞌ u chukul yoleꞌ, tukꞌ u jeꞌsaibꞌeꞌ, as tukꞌ unqꞌa uxhchileꞌ uvaꞌ yeꞌl itxumbꞌal tijikil. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","As jankꞌal chit unqꞌa vaꞌlexheꞌ uvaꞌ kat vala, as aꞌ ni telkat chꞌuꞌl tu u taanxelal unqꞌa uxhchileꞌ. As nipaavinsa unqꞌa uxhchileꞌ vatz u Tiixheꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","As el veꞌt chꞌuꞌl u Jesús tu u Galilea. As oon veꞌt Aak najlich u Tiro tukꞌ u Sidón. As tul ok veꞌt Aak tu umaꞌl u kabꞌal, as aꞌ tal Aak uvaꞌ yeꞌxhebꞌil la ootzin uvaꞌ atik Aak tzitziꞌ. Pet jit uchi, tan tabꞌi veꞌt unqꞌa uxhchileꞌ itzibꞌlal uvaꞌ katil atikkat Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","As tabꞌi umaꞌl u ixoj itzibꞌlal Aak. As yeꞌntu chit tul veꞌt ixoj vatz Aak, tan atik ok umaꞌl u subꞌul tiꞌ vixvaak u ixojeꞌ. As kuꞌ veꞌt u ixoj qaaloj vatz Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","As jit tiaal Israel u ixoj. Pet aꞌ jejlikkat u ixoj tu u tenam Sirofenicia uvaꞌ atik ok tiqꞌabꞌ u Siria. As ijaj ixoj bꞌaꞌnil te Aak tiꞌ uvaꞌ la teesa el Aak u subꞌuleꞌ tiꞌ vixvaak u ixojeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ech tal veꞌt Aak ileꞌ te ixoj: —Pet txꞌaꞌnnal unqꞌa talaj intxaꞌeꞌ sbꞌaꞌn bꞌaxa, tan yeꞌ la ibꞌaneꞌ uvaꞌ la qaqꞌ vitxꞌix unqꞌa talaj intxaꞌeꞌ te unqꞌa talaj txꞌiꞌeꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","As ech tal veꞌt u ixoj ileꞌ: —Kano, Pap. Pet antu unqꞌa talaj txꞌiꞌeꞌ taꞌ ni echbꞌun unqꞌa vuy txꞌixeꞌ uveꞌ nichajpik kuꞌ jaqꞌ u meexhaeꞌ taꞌn unqꞌa talaj intxaꞌeꞌ,— tiꞌk ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ech tal veꞌt u Jesús ileꞌ: —Tiꞌ uvaꞌ jik chit kat aal sve, as tuk val see, yeꞌ kuxh atxumunsa veꞌt aama. Pet kuxh veꞌteꞌ, tan kat elyu veꞌt u subꞌuleꞌ tiꞌ u xvaakeꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tul oon veꞌt ixoj tikabꞌal, as koxhlik kuxh veꞌt vixvaak ixojeꞌ viꞌ chꞌach. As maꞌtik tel veꞌt u subꞌuleꞌ tiꞌ u xvaakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tul el veꞌt chꞌuꞌl u Jesús najlich u txꞌavaꞌ uvaꞌ Tiro ibꞌii, as pal veꞌt Aak tu u txꞌavaꞌ uvaꞌ Sidón ibꞌii. As oon veꞌt Aak najlich u mar uvaꞌ Galilea. As atin veꞌt Aak tu u Decápolis. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","As umaꞌl u chakan uvaꞌ nik ikꞌabꞌ tibꞌ itziꞌ, as eqꞌol veꞌt ok vatz u Jesús. As jajpu veꞌt bꞌaꞌnil te Aak uvaꞌ la taqꞌ jeꞌ Aak iqꞌabꞌ stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","As teqꞌo veꞌt bꞌen Aak u najeꞌ sijunal. As toksa veꞌt Aak u viꞌ iqꞌabꞌeꞌ tu vixikin najeꞌ. As toksa ok Aak u taꞌl itzubꞌeꞌ viꞌ u taqꞌ najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","As sajin veꞌt jeꞌ Aak tu almikaꞌ. As txumun veꞌt Aak. As ech tal veꞌt Aak ileꞌ: —¡Efata!— tiꞌk Aak, tan ech isuuchil u yoleꞌ u efata: «Jajpen» tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","As yak kuxh abꞌin veꞌt naj. As yolon veꞌt naj, tan bꞌaꞌn veꞌt u taqꞌ najeꞌ ibꞌana. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","As kꞌuxh tal u Jesús te unqꞌa uxhchileꞌ uvaꞌ yeꞌxh katil la alpukat, as aal chit tal veꞌt unqꞌa uxhchileꞌ kam uvaꞌ ibꞌan Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","As teqꞌo veꞌt taama unqꞌa uxhchileꞌ tiꞌ u nimla bꞌaꞌnileꞌ uvaꞌ ibꞌan Aak. As ech tal veꞌt ileꞌ: —Chꞌiꞌumal chit uvaꞌ kat ibꞌan Aak skajayil, tan kat bꞌaꞌnxiy veꞌt unqꞌa kumooleꞌ uvaꞌ chakanike tukꞌ unqꞌa veeꞌ nik ikꞌabꞌ tibꞌ itziꞌ,— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","As tu unqꞌa qꞌiieꞌ, as mamaꞌla tenameꞌ imol veꞌt tibꞌ unpajte kꞌatz u Jesús. As yeꞌlik veꞌt techbꞌubꞌal eqꞌomalik staꞌn. As imolo veꞌt u Jesús unqꞌa ichusulibꞌeꞌ. As ech tal veꞌt Aak ileꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Nuntxum ivatz unqꞌa tenameꞌ, tan kat ibꞌanlu veꞌt oxvaꞌx qꞌii scheel uvaꞌ xekel unqꞌa tenameꞌ sviꞌ. As yeꞌxhkam chit unbꞌooj ati uvaꞌ la techbꞌu. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Asoj tuk unchaj bꞌen tikabꞌal tul yeꞌxnaj txꞌaꞌni, as la bꞌujleꞌ tu bꞌey, tan at uxhchil uvaꞌ tziꞌaꞌn tzaanajkat,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","As ech tal veꞌt unqꞌa ichusulibꞌ Aak ileꞌ: —¿Katileꞌ la bꞌen eqꞌolojkat mamaꞌla paan tiꞌ itzujbꞌel unqꞌa tenameꞌ tzitzaꞌ tu u tzuukin txꞌavaꞌeꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ech tal veꞌt Aak ileꞌ: «¿Jankꞌoj u paan qꞌi ati?» tiꞌk Aak. As ech tal veꞌt chajnaj ileꞌ: —Vujvaꞌl kuxh u paan ati,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","As tal veꞌt Aak ixonebꞌ unqꞌa tenameꞌ tu u txꞌavaꞌ. As itxey veꞌt Aak vujvaꞌl u paaneꞌ. As taqꞌ veꞌt Aak taꞌntiixh te u Tiixheꞌ stiꞌ. As ijatx veꞌt Aak u paaneꞌ. As taqꞌ veꞌt Aak te unqꞌa ichusulibꞌeꞌ tiꞌ uvaꞌ la ijatx veꞌt chajnaj xoꞌl unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","As atik kaꞌt unqꞌa talaj txay xeꞌ chajnaj. As taqꞌ veꞌt Aak taꞌntiixh te u Tiixheꞌ stiꞌ. As tal veꞌt Aak te unqꞌa ichusulibꞌeꞌ uvaꞌ la ijatx bꞌen chajnaj vatz unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","As txꞌaꞌn veꞌt unqꞌa tenameꞌ sbꞌaꞌn. As imol veꞌt unqꞌa ichusulibꞌ Aakeꞌ unqꞌa yaꞌl paaneꞌ. As nootel vujvaꞌt xuꞌk staꞌn. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","As kamal kajvaꞌl mil unqꞌa tenameꞌ uveꞌ kat txꞌaꞌni. As iqꞌiila veꞌt kan u Jesús unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","As ok veꞌt Aak tu u barco tukꞌ unqꞌa ichusulibꞌeꞌ unpajte. As echik toon veꞌt Aak tu u Dalmanuta. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","As xeꞌt veꞌt kaꞌt unqꞌa fariseo tiꞌ u Jesús tiꞌ uvaꞌ la ikꞌuch Aak umaj kꞌuchbꞌal tetz asoj aꞌ tzaanajkat Aak tu almikaꞌ. As nik kuxh ichuk chajnaj txumbꞌal tiꞌ uvaꞌ la icheesa chajnaj ipaav Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","As txumun veꞌt taama Aak. As ech tal veꞌt Aak ileꞌ: —Vaꞌlexh kuxh etxumbꞌal. ¿As kam qꞌi uveꞌ nu kuxh ejaj sve tiꞌ unbꞌanat umaj nimla bꞌaꞌnil, kꞌuchbꞌal tetz u vijleꞌmeꞌ? As la val sete, tan yeꞌl umaꞌtoj kꞌuchbꞌal tetz u vijleꞌmeꞌ la unkꞌuch sete,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","As taqꞌ veꞌt kan Aak unqꞌa fariseo. As ok veꞌt Aak tu u barco unpajte tukꞌ unqꞌa ichusulibꞌeꞌ. As bꞌen veꞌt Aak jalit u mar. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","As jit inach unqꞌa ichusulibꞌ u Jesús teqꞌot ipaan. Pet umaꞌl kuxh u paan eqꞌomik taꞌn chajnaj tul bꞌen chajnaj tu u barco. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","As ech tal veꞌt u Jesús ileꞌ te chajnaj: —Tuk val sete, atoj enachbꞌal vatz vilevadura unqꞌa fariseo tukꞌ u Herodes,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","As iyol veꞌt unqꞌa ichusulibꞌ Aakeꞌ svatzaj. Ech tal veꞌt chajnaj ileꞌ: —Kamal tiꞌ uveꞌ yeꞌ kat qeqꞌo tzan kupaan, as estiꞌeꞌ ni tal Aak u yoleꞌ,— tiꞌk chajnaj svatzaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","As ootzimalik veꞌt taꞌn u Jesús uvaꞌ kam nikat titzꞌa chajnaj. As ech tal veꞌt Aak ileꞌ: —¿Kam qꞌi uveꞌ: «Yeꞌl kupaan ati,» chu kuxh ex netaleꞌ? ¿Ma yeꞌ nepal bꞌa tu uveꞌ kat unbꞌana? ¿As ma kat sotzyu sekꞌuꞌl? ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿As moj ech exeꞌ echeꞌ unqꞌa tenameꞌ uvaꞌ kꞌuxh ni tileꞌ uvaꞌ kam nunbꞌaneꞌ, as yeꞌ nipal stuul as kꞌuxh ni tabꞌi kam uvaꞌ ni valeꞌ, as yeꞌ nibꞌen ste? ¿As ma yeꞌ netulsa bꞌa sekꞌuꞌl uvaꞌ kat unbꞌana? ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","As tul uvaꞌ kat unjatx oꞌvaꞌl u paan xoꞌl oꞌvaꞌl mil unqꞌa uxhchileꞌ, ¿as jatvaꞌt xuꞌk u yaꞌl paan qꞌi kat emola?— tiꞌk Aak. —Kabꞌlavat u xuꞌk yaꞌl paan kat kumola,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","As ech tal veꞌt Aak ileꞌ unpajte: —As tul kat unjatx vujvaꞌl unqꞌa paaneꞌ xoꞌl kajvaꞌl mil unqꞌa tenameꞌ, ¿as jatvaꞌt u xuꞌk kat nooi taꞌn u yaꞌl paaneꞌ uvaꞌ kat emola?— tiꞌk Aak. —Vujvaꞌt xuꞌk kat kumola,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","As ech tal veꞌt Aak ileꞌ te chajnaj: —¿Kam qꞌi uvaꞌ yeꞌ nepal tu vunyoleꞌ?— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tul uvaꞌ oon veꞌt u Jesús tu Betsaida, as eqꞌol veꞌt tzan umaꞌl u tzot. As jajpu veꞌt bꞌaꞌnil te Aak uvaꞌ la taqꞌ jeꞌ Aak iqꞌabꞌ tiꞌ u tzoteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","As itxey veꞌt Aak iqꞌabꞌ u tzoteꞌ. As teqꞌo veꞌt el Aak tiꞌeꞌl u tenameꞌ. As takꞌsa veꞌt Aak u tziꞌ ivatz u najeꞌ taꞌn u taꞌl itzubꞌeꞌ. As taqꞌ veꞌt jeꞌ Aak iqꞌabꞌ tziꞌ ivatz u najeꞌ. As ichꞌoti veꞌt Aak uvaꞌ ma nik tilon veꞌt unbꞌooj u najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","As ilon veꞌt unbꞌiil u najeꞌ. As ech tal u naj ileꞌ: —Ni vil veꞌt unqꞌa uxhchileꞌ. As nixaaneꞌ. As ech tiloneꞌ echeꞌ unqꞌa tzeꞌeꞌ uveꞌ ni vileꞌ,— tiꞌk u najeꞌ uvaꞌ tzotike. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","As taqꞌ veꞌt jeꞌ u Jesús iqꞌabꞌ tziꞌ ivatz u tzoteꞌ unpajte. As ibꞌaꞌnxisa veꞌt Aak vivatz u najeꞌ. As bꞌaꞌnik veꞌt tilon u najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","As ech tal veꞌt Aak ileꞌ tul ichaj bꞌen Aak u najeꞌ tikabꞌal: —Okiꞌk axh tu u tal tenameꞌ. As katiniꞌk aalkat kam u bꞌaꞌnileꞌ uvaꞌ kat unbꞌan see,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","As el veꞌt chꞌuꞌl u Jesús tukꞌ unqꞌa ichusulibꞌeꞌ tiꞌ ibꞌen tulaj unqꞌa talaj tenameꞌ uvaꞌ najlich u tenam u Cesarea, uvaꞌ kat ikꞌujbꞌaꞌ kan u Piꞌleꞌ uvaꞌ kꞌujlik kan taꞌn u ijlenaal tu u Roma. As tul uvaꞌ atik Aak tu bꞌey tukꞌ chajnaj, as ech tal veꞌt Aak ileꞌ te chajnaj: —¿Kam u vijleꞌmeꞌ uveꞌ ni tal unqꞌa tenameꞌ?— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ech tal veꞌt chajnaj ileꞌ: —At uxhchil ni alon uvaꞌ axh u Xhuneꞌ uvaꞌ nik aqꞌon kuꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ; as at kaꞌt u uxhchil ni alon uvaꞌ axh u Elías; as at kaꞌt u uxhchil ni alon uvaꞌ axh umaꞌtoj unqꞌa qꞌajsan tetz viyol u Tiixheꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","As ech tal veꞌt Aak ileꞌ: —¿As kano ex qꞌi? ¿Abꞌil in qꞌi uveꞌ netaleꞌ?— tiꞌk Aak. As ech tal veꞌt u Luꞌ ileꞌ: —Axheꞌ taꞌ u Cristo,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","As tal veꞌt Aak te chajnaj uvaꞌ yeꞌxhebꞌil la tal chajnaj ste uvaꞌ Aak u Cristo. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","As xeꞌt u Jesús tiꞌ talat te unqꞌa ichusulibꞌeꞌ tiꞌ uvaꞌ kam u kꞌaxkꞌoeꞌ la ipalebꞌe Aak. As ech tal veꞌt Aak ileꞌ: —Aꞌ unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh, tukꞌ unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as tukꞌ unjoltu unqꞌa bꞌaal tenameꞌ, as aꞌeꞌ la ixvan VIKꞌAOL U NAJEꞌ. As la yatzꞌaxon. As la ul taama titoxvu qꞌii,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","As jik chit tal veꞌt Aak uvaꞌ techal la ipalebꞌe Aak unqꞌa kꞌaxkꞌoeꞌ. As teqꞌo veꞌt el u Luꞌeꞌ u Jesús sijunal. As imaj veꞌt u Luꞌeꞌ ivatz Aak tiꞌ uvaꞌ yeꞌ la tal Aak u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","As isuchqꞌi veꞌt tibꞌ u Jesús. As isaji veꞌt bꞌen Aak unqꞌa ichusulibꞌeꞌ. As iyaa veꞌt Aak u Luꞌeꞌ. Ech tal veꞌt Aak ileꞌ: —¡Jetzꞌen el sunvatz, Satanás!— tiꞌk Aak te u Luꞌeꞌ. As ech tal veꞌt Aak ileꞌ unpajte te u Luꞌeꞌ: —Aꞌ neetzꞌa kam uvaꞌ nisaꞌ u Tiixheꞌ. Pet aꞌ kuxh neetzꞌa kam uvaꞌ ni titzꞌa unqꞌa uxhchileꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","As imolo veꞌt Aak unqꞌa uxhchileꞌ tukꞌ unqꞌa ichusulibꞌeꞌ. Ech tal veꞌt Aak ileꞌ: —Abꞌiste ex uvaꞌ la esaꞌ etoksat etibꞌ sunkꞌatz, as jit vetxumbꞌaleꞌ la etoksa. Pet aꞌ uvaꞌ la ebꞌaneꞌ kam uvaꞌ nunbꞌaneꞌ, kꞌuxh la epalebꞌe kꞌaxkꞌo as moj la kam ex sviꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","tan abꞌil uvaꞌ aꞌ kuxh ni titzꞌa vitiichajileꞌ vatz u txꞌavaꞌeꞌ, as yeꞌl itiichajil kꞌatz u Tiixheꞌ. Pet abꞌil uvaꞌ la toksa taama tiꞌ inimat in as tiꞌ inimat u bꞌaꞌnla yoleꞌ, as aꞌeꞌ uveꞌ at itiichajil kꞌatz u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿As kam ibꞌaꞌnil qꞌi tiꞌ umaj u uxhchil uvaꞌ la itxꞌak u vatz txꞌavaꞌeꞌ skajayil, as tul yeꞌl itiichajil ati kꞌatz u Tiixheꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tan yeꞌl umaj kam la uch taqꞌat u uxhchileꞌ tiꞌ uvaꞌ at vitiichajileꞌ kꞌatz Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Asoj at umaj uxhchil la chꞌixvu sviꞌ as tiꞌ vunyoleꞌ vatz unqꞌa tenameꞌ uveꞌ aꞌ kuxh u paaveꞌ nibꞌaneꞌ, as la chꞌixvu veꞌt VIKꞌAOL U NAJEꞌ svatz unpajte tul uvaꞌ la ul veꞌt tikaꞌpa tukꞌ unqꞌa Tiixhla ángeleꞌ as tukꞌ viyakꞌil viBꞌaaleꞌ,— tiꞌk u Jesúseꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","As ech tal u Jesús ileꞌ unpajte: —As ileꞌ jik chit tuk val sete, tan at jolol ex uvaꞌ at ex tzitzaꞌ uvaꞌ yeꞌxnaj kam ex tul la ilej veꞌt u qꞌiieꞌ. As la etil veꞌteꞌ uvaꞌ at tijleꞌm u Tiixheꞌ as tukꞌ viyakꞌileꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Vaajil qꞌii stuul, as teqꞌo veꞌt u Jesús u Luꞌeꞌ stiꞌ, tukꞌ u Jacob, tukꞌ u Xhuneꞌ. As bꞌen veꞌt Aak tukꞌ chajnaj viꞌ umaꞌl u vitz uvaꞌ nim chit at jeꞌ. As jalpu veꞌt ikaꞌy Aak vatz chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","As litzꞌloꞌlan veꞌt u toksaꞌm Aakeꞌ. As yeꞌl umaj uxhchil vatz u txꞌavaꞌeꞌ la olebꞌ tiꞌ ipolbꞌisal umaj oksaꞌm echeꞌ uveꞌ kat ibꞌan u toksaꞌm Aakeꞌ, tan vaꞌlik chit ipolal veꞌteꞌ echeꞌ u txuncheꞌveꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","As chee veꞌt u Elías tukꞌ u Moisés vatz u Jesús vatz chajnaj. As yolon veꞌt u Elías tukꞌ u Moisés tukꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","As ech tal veꞌt u Luꞌ ileꞌ te u Jesús: —Chusul, bꞌaꞌneꞌ uvaꞌ la atin veꞌt oꞌ tzitzaꞌ. As la kubꞌan oxvoꞌj tal pach: umaꞌl eetz, umaꞌt tetz u Moisés, as umaꞌt tetz u Elías,— tiꞌk u Luꞌeꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","tan yeꞌ nik titzꞌa u Luꞌeꞌ kam uveꞌ nik taleꞌ, tan maꞌtik ixoꞌv chajnaj taꞌn uveꞌ til chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","As chee veꞌt umaꞌl u suutzꞌ tiibꞌa u Jesús tukꞌ chajnaj. As tabꞌi veꞌt chajnaj umaꞌl u tuul viꞌ tu u suutzꞌeꞌ uvaꞌ ech ni tal ileꞌ: —¡Aꞌ vunKꞌaoleꞌ uvaꞌ xoꞌn chit sve! ¡As aꞌeꞌ la etabꞌi, as la enima!— tiꞌk u tuul viꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","As tul sajin veꞌt chajnaj, as yeꞌxhebꞌil atik veꞌteꞌ. Pet aꞌik kuxh veꞌt u Jesús atike. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","As tul kuꞌ chꞌuꞌl u Jesús tukꞌ chajnaj viꞌ u vitzeꞌ, as tal veꞌt Aak te chajnaj uvaꞌ yeꞌxh katil la talkat chajnaj tiꞌ uveꞌ kat til chajnaj. Pet lanal kam Aak as lanal ul taama Aak unpajte, as aꞌn la tal veꞌt chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","As atik kuxh veꞌt u yoleꞌ skꞌuꞌl chajnaj. As nik kuxh ichꞌoti veꞌt tibꞌ te chajnaj uvaꞌ kam ni tokkat u yoleꞌ uveꞌ la ul taama u Jesús unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","As ech tal veꞌt chajnaj ileꞌ te Aak: —¿Kam qꞌi uveꞌ ni tal unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, uvaꞌ bꞌaxel la ul u Elías?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ech tal veꞌt u Jesús ileꞌ: —An chiteꞌ uvaꞌ ni tal chajnaj uvaꞌ tzꞌibꞌamal kan uvaꞌ bꞌaxel la ul u Elíaseꞌ tiꞌ tul ibꞌanat tuch unqꞌa tenameꞌ tiꞌ u vulebꞌaleꞌ. ¿Pet kam ni tal ex qꞌi tiꞌ umaꞌt u yoleꞌ uveꞌ tzꞌibꞌamal kan tiꞌ VIKꞌAOL U NAJEꞌ uvaꞌ tuknal chit ipalebꞌe unqꞌa kꞌaxkꞌoeꞌ as la ixvali? ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","As tuk val sete, tan ulyeꞌ u Elías. As kat ibꞌan unqꞌa tenameꞌ ste kam uvaꞌ nik tal taama unqꞌa tenameꞌ stiꞌ, echeꞌ uvaꞌ tzꞌibꞌamal kan stiꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","As tul ul veꞌt u Jesús tukꞌ chajnaj kꞌatz kaꞌt unqꞌa ichusulibꞌ Aakeꞌ, as til veꞌt Aak uvaꞌ mamaꞌla tenam molik veꞌt ok tibꞌ kꞌatz unqꞌa ichusulibꞌeꞌ uvaꞌ maꞌtik ikaaik kan, tan yeꞌ nik ikꞌul tibꞌ iyol chajnaj tukꞌ kaꞌt unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","As tul til veꞌt unqꞌa tenameꞌ tul u Jesús, as teqꞌo veꞌt taama. As qꞌax chit ibꞌen veꞌteꞌ tiꞌ itiixhil Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","As ech tal veꞌt Aak ileꞌ te unqꞌa tenameꞌ: —¿Kam yolileꞌ uveꞌ yeꞌ nekꞌul etibꞌ stiꞌ tukꞌ unqꞌa unchusulibꞌeꞌ?— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","As ech tal umaꞌl u uxhchil ileꞌ xoꞌl unqꞌa tenameꞌ: —Chusul, kat veqꞌol tzan vas unkꞌaoleꞌ aqꞌal uvaꞌ la abꞌaꞌnxisa naj, tan atoꞌk umaꞌl u subꞌul skꞌatz uvaꞌ ni memtisan. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","As kꞌuxh katil kuxh atkat vunkꞌaoleꞌ as tul nitxey u subꞌuleꞌ naj, as nisuti bꞌen u subꞌuleꞌ naj tu txꞌavaꞌ. As nitzeꞌu tibꞌ naj. Ni tel chꞌuꞌl xoj itziꞌ. As vaꞌl chit ijachꞌkabꞌan tee. As kat unjaj bꞌaꞌnil te unqꞌa achusulibꞌeꞌ uvaꞌ la teesa chajnaj u subꞌuleꞌ skꞌatz. As yeꞌ kat olebꞌ chajnaj,— tiꞌk vibꞌaal u xaakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","As ech tal veꞌt u Jesús ileꞌ: —¡Ex chit yeꞌ nekꞌujbꞌaꞌ ekꞌuꞌl sviꞌ! ¿Ma tuk kuxh atinoj in sexoꞌl uveꞌ netitzꞌa? ¿As la kuxh kol txꞌebꞌon veꞌt in qꞌa setiꞌ tiꞌ uvaꞌ la ekꞌujbꞌaꞌ ekꞌuꞌl sviꞌ? Pet eteqꞌotaj tzan u xaakeꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","As u xaakeꞌ uvaꞌ atik ok subꞌul skꞌatz, as eqꞌol veꞌt tzan vatz u Jesús. As tul til u subꞌuleꞌ u Jesús, as isuti veꞌt bꞌen u subꞌuleꞌ u xaakeꞌ tu u txꞌavaꞌ tukꞌ txꞌiꞌtziꞌl. As ibꞌalqꞌu veꞌt tibꞌ naj taꞌn u subꞌuleꞌ. As el veꞌt xoj itziꞌ naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","As ech tal veꞌt Aak ileꞌ te vibꞌaal u xaakeꞌ: —¿Jatvaꞌx qꞌii ixeꞌteꞌ uvaꞌ ech nibꞌaneꞌ echeꞌ u veeꞌ?— tiꞌk Aak. Ech tal veꞌt u bꞌaala ileꞌ: —Tu tzan itzꞌupileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","As jatpajux kuxh isuti bꞌen u subꞌuleꞌ tu u xamal as tukꞌ tu aꞌ tiꞌ iyatzꞌpeꞌ. Pet bꞌan bꞌaꞌnil. Txum kuvatz. As loch oꞌ asoj la uch savatz,— tiꞌk vibꞌaal u xaakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","As ech tal u Jesús ileꞌ: —¿Kam ni tokkat u yoleꞌ uvaꞌ naaleꞌ: «Asoj la uch savatz,» chꞌaxh naaleꞌ? Tan kajayil chiteꞌ la ibꞌaneꞌ asoj la akꞌujbꞌaꞌ akꞌuꞌl sviꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","As yak kuxh sikꞌin veꞌt vibꞌaal u xaakeꞌ. Ech tal ileꞌ: —As nunnima uvaꞌ naaleꞌ. Pet loch in, tan bꞌiil kuxh u kꞌujlebꞌal unkꞌuꞌleꞌ at seeꞌ,— tiꞌk vibꞌaal u xaakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tul til u Jesús uvaꞌ nik imol veꞌt ok tibꞌ unqꞌa tenameꞌ, as iyaa veꞌt Aak u subꞌuleꞌ. Ech tal veꞌt Aak ileꞌ: —Axh subꞌul uvaꞌ kat memtisan u xaakeꞌ as yeꞌ ni tabꞌin veꞌt naj aꞌn, as tuk val see uvaꞌ la el axh tiꞌ naj. As yeꞌl unpajte la ok veꞌt axh tiꞌ naj,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","As sikꞌin veꞌt u subꞌuleꞌ. As isuti veꞌt bꞌen u subꞌuleꞌ u xaakeꞌ tu txꞌavaꞌ tukꞌ chit txꞌiꞌtziꞌl. As tul el u subꞌuleꞌ kꞌatz u xaakeꞌ, as ech veꞌt u xaakeꞌ kamnaj kat ibꞌana. As nimal uxhchil kat alon uvaꞌ kat kamyu veꞌt naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","As itxey veꞌt u Jesús iqꞌabꞌ u xaakeꞌ uvaꞌ atik ok subꞌul skꞌatz. As itxakbꞌaꞌ veꞌt Aak naj. As txakebꞌ veꞌt naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tul ok veꞌt Aak tu kabꞌal, as ech tal veꞌt unqꞌa ichusulibꞌ Aak ileꞌ ste tul Aakik kuxh tukꞌ chajnaj: —¿Kam qꞌi uveꞌ yeꞌ kat olebꞌ oꞌ tiꞌ tel u subꞌuleꞌ kꞌatz u xaakeꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ech tal veꞌt Aak ileꞌ: —Unqꞌa subꞌuleꞌ uvaꞌ echeꞌ u veeꞌ, tan tukꞌ kuxh nacho Tiixh as tukꞌ ikuypu vaꞌy vatz u Tiixheꞌ la elkat,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","As tul el veꞌt chꞌuꞌl u Jesús tzitziꞌ, as xaan veꞌt Aak tukꞌ unqꞌa ichusulibꞌeꞌ tu u Galilea. As aꞌ nik tal Aak uvaꞌ yeꞌxhkam la abꞌil itzibꞌlal, ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","tan nik ichusun Aak xoꞌl unqꞌa ichusulibꞌeꞌ. As ech nik tal Aak ileꞌ te chajnaj: —VIKꞌAOL U NAJEꞌ as la oksal ok tiqꞌabꞌ unqꞌa uxhchileꞌ. As la yatzꞌpu veꞌteꞌ. As kꞌuxh la kami, as la ul taama titoxvu qꞌii,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","As jit pal chajnaj tu u yoleꞌ uvaꞌ tal Aak. As xoꞌv chajnaj tiꞌ ichꞌotil te Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","As tul oon Aak tu u Capernaúm tukꞌ unqꞌa ichusulibꞌeꞌ, as ok veꞌt Aak tu u kabꞌal tukꞌ chajnaj. As ichꞌoti veꞌt Aak te chajnaj uvaꞌ kam nik iyol chajnaj tu bꞌey. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","As jit tiin veꞌt chajnaj, tan tiꞌ uvaꞌ yeꞌ nik ikꞌul tibꞌ iyol chajnaj tu bꞌey tiꞌ uvaꞌ abꞌiste chajnaj uvaꞌ nim talcheꞌ tiꞌ unqꞌa imooleꞌ la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","As xonebꞌ veꞌt Aak. Imolo veꞌt Aak kabꞌlaval unqꞌa ichusulibꞌeꞌ. As ech tal Aak ileꞌ: —Abꞌil uvaꞌ nisaꞌ uvaꞌ nim talcheꞌ tiꞌ unqꞌa imooleꞌ, as yeꞌ la ijeꞌsa tibꞌ xoꞌl unqꞌa imooleꞌ. As ayaꞌl chit ikꞌuꞌl la iloch vimooleꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","As imolo veꞌt tzan u Jesús umaꞌl u tal xaak. As itxakbꞌaꞌ veꞌt Aak naj xoꞌl chajnaj. Ech tal veꞌt Aak ileꞌ tul uvaꞌ ijele Aak u tal xaakeꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—As abꞌil uvaꞌ tukꞌ vunbꞌiieꞌ la ibꞌankat umaj u bꞌaꞌnil te umaj talaj intxaꞌ echeꞌ u tal xaak ilaꞌ, as sve la ibꞌankat. As abꞌil uvaꞌ la bꞌanon umaj u bꞌaꞌnil sve, as jit kuxh sveeꞌ la ibꞌankat. Pet anteꞌ u chajol tzan vetzeꞌ la ibꞌan u bꞌaꞌnileꞌ ste,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","As ech tal veꞌt u Xhun ileꞌ: —Chusul, kat qil umaꞌl u naj uvaꞌ tukꞌ vabꞌiieꞌ ni teesakat el naj unqꞌa subꞌuleꞌ kꞌatz unqꞌa uxhchileꞌ. As kat kuyaꞌsa veꞌt kan te naj, tan yeꞌl naj xekel koj sqiꞌ,— tiꞌk u Xhuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","As ech tal veꞌt u Jesús ileꞌ: —Yeꞌ kuxh eyaꞌsa kan te naj, tan asoj tukꞌ vunbꞌiieꞌ kat ibꞌankat naj umaj kꞌuchbꞌal tetz vibꞌaꞌnil u Tiixheꞌ, as echeꞌ la koj tal umaj u vaꞌlexhla yol sviꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","tan abꞌil uveꞌ yeꞌ nichꞌoꞌn taama sqiꞌ, as echen sukukꞌatz. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","As la val sete, abꞌil uvaꞌ la aqꞌon umaj u picheel aꞌ sete tukꞌ vunbꞌiieꞌ tiꞌ uvaꞌ echen ex sunkꞌatz, as at itxꞌajaꞌmeꞌ xeꞌ u Tiixheꞌ la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Pet abꞌil la kaꞌkabꞌinsan taama umaj u niman vetzeꞌ uvaꞌ yeꞌ yakꞌinoj vitxumbꞌaleꞌ tiꞌ vunyoleꞌ, as aal bꞌaꞌneꞌ uvaꞌ la kꞌalpik veꞌt ok umaj kaꞌ tiqul u uxhchileꞌ. As la sutil veꞌt bꞌen xeꞌ u mar. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","As la val sete, tan asoj la paavin ex taꞌn veqꞌabꞌeꞌ, as eyaꞌsataj epaavineꞌ eela kuxh stukꞌ uvaꞌ kat etzokꞌlu veꞌt el veqꞌabꞌeꞌ, tan aal bꞌaꞌneꞌ uvaꞌ ech exeꞌ echeꞌ umaj kuchꞌ tul la ok ex tu uveꞌ atkat u tiichajileꞌ tetz vetaanxelaleꞌ as tiꞌ uvaꞌ kꞌuxh at veqꞌabꞌeꞌ skaabꞌil tul aꞌ la bꞌenkat ex tu u choobꞌal paaveꞌ uveꞌ ni toypukat u xamaleꞌ uveꞌ yeꞌxhebꞌil la olebꞌ tiꞌ itzaasaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","As yeꞌl veꞌt ikamebꞌal unqꞌa txitxbꞌileꞌ tzitziꞌ. As mitaꞌn u xamaleꞌ la tzaa veꞌteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Asoj la paavin ex taꞌn vetojeꞌ, as eyaꞌsataj epaavineꞌ eela kuxh stukꞌ uvaꞌ kat etzokꞌlu veꞌt el vetojeꞌ, tan aal bꞌaꞌneꞌ uvaꞌ ech exeꞌ echeꞌ umaj koꞌx tul la ok ex tu uveꞌ atkat u tiichajileꞌ tetz vetaanxelaleꞌ as tiꞌ uvaꞌ kꞌuxh at etojeꞌ skaabꞌil tul aꞌ la bꞌenkat ex tu u choobꞌal paaveꞌ uveꞌ ni toypukat u xamaleꞌ uveꞌ yeꞌxhebꞌil la olebꞌ tiꞌ itzaasaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","As yeꞌl veꞌt ikamebꞌal unqꞌa txitxbꞌileꞌ tzitziꞌ. As mitaꞌn u xamaleꞌ la tzaa veꞌteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Asoj la paavin ex taꞌn u bꞌaqꞌ evatzeꞌ, as eyaꞌsataj epaavineꞌ eela kuxh stukꞌ uvaꞌ kat eteesal veꞌt el u bꞌaqꞌ evatzeꞌ, tan aal bꞌaꞌneꞌ uvaꞌ umaꞌl kuxh u bꞌaqꞌ evatzeꞌ tul la ok ex kꞌatz u Tiixheꞌ tu almikaꞌ as tiꞌ uvaꞌ kꞌuxh at unqꞌa bꞌaqꞌ evatzeꞌ skaabꞌil as tul aꞌ la bꞌenkat ex tu u choobꞌal paaveꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","As yeꞌl veꞌt ikamebꞌal unqꞌa txitxbꞌileꞌ tzitziꞌ. As mitaꞌn u xamaleꞌ la tzaa veꞌteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","As la val sete, aꞌ u kꞌaxkꞌoeꞌ la eesan el u vaꞌlexheꞌ setiꞌ, uvaꞌ echeꞌ xamal. As bꞌaꞌn veꞌt ex vatz u Tiixheꞌ la ibꞌaneꞌ, echeꞌ unqꞌa oyeꞌ uvaꞌ ni toksal vatz Aak tul atoꞌk atzꞌam stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","As chꞌiꞌumaleꞌ u atzꞌameꞌ. Pet asoj la motx vipitzꞌpolil u atzꞌameꞌ, as yeꞌ la txakon veꞌteꞌ, tan la koj uch ichee ipitzꞌpolil unpajte. Estiꞌeꞌ ni val sete uvaꞌ ayaꞌloj chit ekꞌuꞌl la etoksa etaama sviꞌ. As bꞌaꞌnoj chit etatineꞌ sevatzaj,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","As el veꞌt chꞌuꞌl u Jesús tu u Capernaúm. As oon veꞌt Aak tu u Judea as tukꞌ tu u txꞌavaꞌ uvaꞌ jalit u nimla aꞌ u Jordán. As imol veꞌt tibꞌ unqꞌa tenameꞌ tiꞌ Aak unpajte. As chusun veꞌt Aak xoꞌl unqꞌa tenameꞌ, tan ech nik ibꞌan Aak sbꞌenameen. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","As ijetzꞌ veꞌt ok tibꞌ kaꞌl unqꞌa fariseo kꞌatz Aak tiꞌ ichukax ipaav Aak. As ichꞌoti veꞌt chajnaj umaꞌl u yol te Aak tiꞌ uvaꞌ ma la uch ijatxat el umaj u naj u tixqeleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ech tal veꞌt Aak ileꞌ: —¿Kam kat tal kan u Moisés sete tiꞌ u yoleꞌ?— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","As ech tal veꞌt chajnaj ileꞌ: —Kat tal kan u Moisés uvaꞌ la uch ijatxat tibꞌ umaj u naj tukꞌ u tixqeleꞌ. As lanal itzꞌibꞌa naj uvaꞌ kam stiꞌ la ijatxkat tibꞌ naj tukꞌ u tixqeleꞌ. As la taqꞌ naj u uꞌujeꞌ te ixoj. As aꞌn la uch ijatxat el naj u tixqeleꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","As ech tal veꞌt u Jesús ileꞌ: —As tiꞌ kuxh vipaasan tziil unqꞌa tenameꞌ, as kat itzꞌibꞌa kan u Moisés u tzaqꞌiteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tan tixeꞌtebꞌal u vatz txꞌavaꞌeꞌ kat icheesa u Tiixheꞌ u najeꞌ as u ixojeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Estiꞌeꞌ la taqꞌ veꞌt kan u najeꞌ vibꞌaaleꞌ tukꞌ vitxutxeꞌ. As la teqꞌo veꞌt tibꞌ naj tukꞌ u tixqeleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","As eela kuxh stukꞌ uvaꞌ umaꞌl kuxh veꞌt uxhchil la ibꞌaneꞌ vatz u Tiixheꞌ. As jit veꞌt kaꞌvaꞌl, pet unvatzul kuxh veꞌt vichiꞌoleꞌ skaabꞌil la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","As la val sete, tan abꞌil uvaꞌ aꞌ u Tiixheꞌ kat bꞌanon uvaꞌ kat teqꞌo tibꞌ, as yeꞌxhebꞌil la jatxon ivatz,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tul uvaꞌ atik veꞌt u Jesús tu u kabꞌaleꞌ tukꞌ unqꞌa ichusulibꞌeꞌ, as ichꞌoti veꞌt chajnaj tiꞌ uveꞌ kat tal Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ech tal veꞌt Aak ileꞌ: —Abꞌil uvaꞌ la ijatxeꞌl u tixqeleꞌ as la teqꞌo tibꞌ tukꞌ umaꞌt ixoj, as la paavin veꞌt naj vatz u tixqeleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","As echat u ixojeꞌ uveꞌ la ijatx tibꞌ tukꞌ vitzumeleꞌ as la teqꞌo tibꞌ ixoj tukꞌ umaꞌt naj, as la paavin veꞌt ixoj,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","As teqꞌo veꞌt ok unqꞌa uxhchileꞌ unqꞌa italaj intxaꞌeꞌ vatz u Jesús tiꞌ uvaꞌ la taqꞌ jeꞌ Aak iqꞌabꞌ tiꞌ chiintxaꞌ. As yaan veꞌt unqꞌa ichusulibꞌ Aakeꞌ te unqꞌa uxhchileꞌ uveꞌ nik eqꞌon ok unqꞌa talaj intxaꞌeꞌ vatz Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","As tul til veꞌt Aak, as ul veꞌt iviꞌ Aak tiꞌ uvaꞌ nik imaj chajnaj ivatz unqꞌa talaj intxaꞌeꞌ. As ech tal veꞌt Aak ileꞌ: —Echajputaj ok tzan unqꞌa talaj intxaꞌeꞌ sunkꞌatz. As yeꞌ kuxh emaj chiintxaꞌ, tan abꞌil uvaꞌ ech itxumbꞌaleꞌ echeꞌ vitxumbꞌal unqꞌa talaj intxaꞌeꞌ, as aꞌeꞌ uveꞌ at tokebꞌal xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","As jik chit tuk val sete, tan abꞌil uvaꞌ jitꞌeꞌch vitxumbꞌaleꞌ echeꞌ itxumbꞌal umaj talaj intxaꞌ la ibꞌaneꞌ tiꞌ uvaꞌ la til u Tiixheꞌ isuuchil, as yeꞌl tokebꞌal xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","As junun ijelet veꞌt Aak unqꞌa talaj intxaꞌeꞌ. As taqꞌ veꞌt jeꞌ Aak iqꞌabꞌ tiꞌ chiintxaꞌ, as tal veꞌt Aak uvaꞌ aꞌ u bꞌaꞌneꞌ la ul tiꞌ chiintxaꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","As tul el veꞌt chꞌuꞌl u Jesús tiꞌ ibꞌeneꞌ, as qꞌax tul veꞌt umaꞌl u naj. As kuꞌ veꞌt naj qaaloj vatz Aak. As ech tal veꞌt naj ileꞌ: —¿Bꞌaꞌnla Chusul, kam la unbꞌaneꞌ tiꞌ uvaꞌ at untiichajil uvaꞌ yeꞌl iyaꞌtebꞌal?— tiꞌk najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ech tal veꞌt u Jesús ileꞌ: —¿Kam qꞌi uvaꞌ: «Bꞌaꞌnla Chusul,» chꞌaxh sve? Tan yeꞌl umaj bꞌaꞌnla chusul ati, pet taꞌneꞌ u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","As ootzimal unqꞌa tzaqꞌiteꞌ aꞌn uvaꞌ ech ni tal ileꞌ: Achukak eexoj. Ayatzꞌak umaj uxhchil. Elqꞌiꞌk axh. Acheesak ipaav amool. Amaxtibꞌek amool. Nima abꞌaal; nima atxutx,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","As ech tal veꞌt u naj ileꞌ: —Chusul, nimamal chiteꞌ svaꞌn skajayil tu unchꞌooil,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","As isaji veꞌt u Jesús naj. As ixoꞌni veꞌt Aak naj. Ech tal veꞌt Aak ileꞌ: —Atil chit umaꞌte uvaꞌ yeꞌ abꞌaneꞌte. Pet kuxh kꞌayi kan unqꞌa txꞌiibꞌal aqꞌiieꞌ skajayil. As la ajatx veꞌt vijaꞌmileꞌ xoꞌl unqꞌa meebꞌaꞌeꞌ. As nimal u bꞌaꞌnileꞌ lakꞌul tu almikaꞌ. Pet siꞌu. Xekebꞌen sviꞌ, as kꞌuxh la apalebꞌe kꞌaxkꞌo as moj la kam axh sviꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","As tul tabꞌi u najeꞌ u yoleꞌ, as txumun veꞌt u naj tul bꞌen veꞌt naj, tan tiꞌ uvaꞌ nimal u txꞌiibꞌal iqꞌii u najeꞌ atike. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","As isaji veꞌt bꞌen u Jesús unqꞌa ichusulibꞌeꞌ stxala. Ech tal veꞌt Aak ileꞌ: —¡Kaꞌl tzii tiꞌ unqꞌa uxhchileꞌ uvaꞌ at txꞌiibꞌal iqꞌii uvaꞌ at tokebꞌal xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ!— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","As teqꞌo veꞌt taama unqꞌa ichusulibꞌ Aakeꞌ tul uvaꞌ tabꞌi veꞌt chajnaj viyol Aakeꞌ. As ech tal veꞌt Aak ileꞌ te chajnaj: —Ex unchusulibꞌ, la val sete uvaꞌ abꞌil uveꞌ aꞌ nikꞌujbꞌaꞌkat ikꞌuꞌl tiꞌ u txꞌiibꞌal iqꞌiieꞌ, as kaꞌl tzii stiꞌ uvaꞌ at tokebꞌal xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","As oora kuxheꞌ la pal umaj u camello tixotoꞌlil umaj tzꞌisbꞌal bꞌaj tiꞌ uvaꞌ la ok umaj txꞌioliqꞌii xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","As tul tabꞌi veꞌt chajnaj u yoleꞌ, as aal chit teqꞌo veꞌt taama chajnaj. Ech tal veꞌt chajnaj ileꞌ svatzaj: —¿Asoj ech la ibꞌaneꞌ echeꞌ u veeꞌ? ¿as abꞌil qꞌii la ok xoꞌl vitenam u Tiixheꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","As isaji veꞌt u Jesús chajnaj. Ech tal veꞌt Aak ileꞌ: —As vatz unqꞌa uxhchileꞌ, as aꞌ chiteꞌ yeꞌ la uchi. Pet ech koj vatz u Tiixheꞌ, tan la chit ibꞌaneꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","As ech tal veꞌt u Luꞌ ileꞌ: —Kat qaqꞌlu veꞌt kan unqꞌa qetzeꞌ skajayil. As il oꞌ xekel veꞌt oꞌ seeꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","As ech tal veꞌt u Jesús ileꞌ: —As jik chit la val sete, tan abꞌil uvaꞌ la taqꞌ kan ikabꞌal, moj titzꞌin tatzik, moj ibꞌaal, moj itxutx, moj tixqel, moj meꞌal ikꞌaol, moj itxꞌavaꞌ tiꞌ uvaꞌ la xekebꞌ sviꞌ as tiꞌ uvaꞌ nimamal u bꞌaꞌnla yoleꞌ staꞌn, ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","as nimal ichꞌexel u tetzeꞌ la ikꞌuleꞌ tetz vitiichajileꞌ vatz u txꞌavaꞌeꞌ. As la ikꞌul ichꞌexel vikabꞌaleꞌ, tukꞌ unqꞌa titzꞌin tatzikeꞌ, tukꞌ itxutx, tukꞌ meꞌal ikꞌaol, tukꞌ itxꞌavaꞌ, as kꞌuxh kam kuxh kꞌaxkꞌo la ipalebꞌe. As tu unqꞌa qꞌiieꞌ uvaꞌ aꞌn tuleꞌ, as at veꞌt itiichajil u uxhchileꞌ uveꞌ yeꞌl iyaꞌtebꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tan nimal unqꞌa uxhchileꞌ uvaꞌ ni toksal iqꞌii taꞌn unqꞌa tenameꞌ, as tul aꞌeꞌ uvaꞌ jit nim talcheꞌ vatz u Tiixheꞌ. Pet ech koj unqꞌa uxhchileꞌ uvaꞌ yeꞌl iqꞌii vatz unqꞌa tenameꞌ, as aꞌeꞌ uvaꞌ nim talcheꞌ vatz u Tiixheꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tul aalik ijeꞌ u Jesús tu u Jerusalén, as bꞌax veꞌt Aak vatz unqꞌa ichusulibꞌeꞌ. As teqꞌo veꞌt taama chajnaj tiꞌ uvaꞌ aalik ijeꞌ Aak tu u Jerusalén. As vaꞌlik chit ixoꞌv veꞌt kaꞌt unqꞌa uxhchileꞌ uvaꞌ xekik tiꞌ Aak. As imolo veꞌt el Aak kabꞌlaval unqꞌa ichusulibꞌeꞌ. As tal veꞌt Aak te chajnaj kam uvaꞌ la ipalebꞌe Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ech tal veꞌt Aak ileꞌ: —Il oꞌ maꞌt veꞌt jeꞌ oꞌ tu u Jerusalén. As tuk oksaloj ok VIKꞌAOL U NAJEꞌ tiqꞌabꞌ unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh tukꞌ te unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ. As tuk alaxoj ikameꞌ. As la yatzꞌpi. As la oksal tiqꞌabꞌ unqꞌa tenameꞌ uvaꞌ jit tiaal Israel. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","As la eesal iqꞌii. La qꞌospu veꞌteꞌ; la tzubꞌali; la yatzꞌpu veꞌteꞌ. As titoxvu qꞌii la ul taama,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","U Jacob tukꞌ u Xhuneꞌ uvaꞌ ikꞌaol u Zebedeo, as jetzꞌen veꞌt ok chajnaj kꞌatz u Jesús. As ech tal veꞌt chajnaj ileꞌ: —Chusul, tuk kujaj umaꞌl u bꞌaꞌnil see. As aꞌ ni qaleꞌ uvaꞌ la abꞌaneꞌ kam uvaꞌ tuk kujaj see,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ech tal veꞌt u Jesús ileꞌ: —¿Kam qꞌi nesaꞌ uveꞌ la unbꞌaneꞌ?— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","As ech tal veꞌt chajnaj ileꞌ: —Tul la oksal veꞌt aqꞌii, as la aaqꞌ qijleꞌm tiꞌ uvaꞌ la xonebꞌ umaꞌl oꞌ tasebꞌal as umaꞌt oꞌ tamax,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ech tal veꞌt u Jesús ileꞌ: —Yeꞌ nepal stuul kam uvaꞌ nejajeꞌ. ¿Ma la etxꞌol epal tu u kꞌaxkꞌoeꞌ uveꞌ tuk unpalebꞌe? ¿As ma tuk etxꞌol etok tu u mam txumlebꞌaleꞌ uvaꞌ tuk unpalebꞌe?— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Kano, la kutxꞌoleꞌ,— tiꞌk chajnaj. As ech tal veꞌt u Jesús ileꞌ: —An chiteꞌ uvaꞌ netitzꞌa, tan la epalebꞌe u kꞌaxkꞌoeꞌ uveꞌ la unpalebꞌe. As la epalebꞌe u mam txumlebꞌaleꞌ uvaꞌ la unpalebꞌe. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pet ech koj uvaꞌ netal exonebꞌ tu vunsebꞌaleꞌ tukꞌ tu vunmaxeꞌ, tan jit ineꞌ la aqꞌon sete. Pet aꞌ la aqꞌaxkat te unqꞌa uxhchileꞌ uvaꞌ txaael veꞌt taꞌn u Tiixheꞌ, tan bꞌanel veꞌt tucheꞌ taꞌn Aak tiꞌ taqꞌax ste,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tul tabꞌi veꞌt lavat unqꞌa ichusulibꞌ Aakeꞌ, as ul veꞌt iviꞌ chajnaj tiꞌ u Jacob tukꞌ u Xhuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","As imolo veꞌt tzan u Jesús chajnaj. As ech tal veꞌt Aak ileꞌ: —Ootzimaleꞌ setaꞌn uvaꞌ jankꞌal unqꞌa najeꞌ uveꞌ ni tok ijlenaalil tiꞌ unqꞌa tenameꞌ, as ni toksa jeꞌ iqꞌii tiꞌ unqꞌa tenameꞌ. As nim chit chajnaj ninacheꞌ tukꞌ unqꞌa imooleꞌ, tul nipaasa tibꞌ chajnaj tiꞌ unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pet jitꞌeꞌch la ibꞌan sexoꞌl, tan abꞌiste ex uvaꞌ nesaꞌ uvaꞌ nim etalcheꞌ tiꞌ unqꞌa emooleꞌ, as exeꞌ lochol tetz vemooleꞌ la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","As abꞌiste ex uvaꞌ nesaꞌ uvaꞌ at etijleꞌm xoꞌl unqꞌa emooleꞌ, as ex lochol tetz vemooleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tan VIKꞌAOL U NAJEꞌ kat uli jit tiꞌ uvaꞌ la lochpi taꞌn unqꞌa tenameꞌ kat ulkat, pet kat uli tiꞌ ul taqꞌat tibꞌ kamoj tiꞌ iqꞌalpul unqꞌa tenameꞌ vatz vipaaveꞌ,— tiꞌk u Jesúseꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","As oon veꞌt Aak tu u Jericó. As tul el veꞌt Aak tziꞌeꞌl u tenameꞌ tukꞌ unqꞌa ichusulibꞌeꞌ tukꞌ unjoltu unqꞌa tenameꞌ, as xonlik umaꞌl u tzot tziꞌ bꞌey tiꞌ ijoyat ipuaj. As Bartimeo ibꞌii naj. As vikꞌaol u Timeo. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tul tabꞌi veꞌt naj uvaꞌ aꞌ u Jesús uvaꞌ aa Nazaret nik ipaleꞌ, as xeꞌt veꞌt naj sikꞌin. Ech tal veꞌt naj ileꞌ: —¡Jesús, tiaal David, txum unvatz!— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","As nimal uxhchil yaaon naj tiꞌ uvaꞌ nisikꞌin naj. As aal chit taqꞌ veꞌt jeꞌ naj tuul iviꞌ. As ech tal veꞌt naj ileꞌ unpajte: —¡Pap, axh tiaal David, txum unvatz!— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","As txakebꞌ veꞌt u Jesús. As tal veꞌt Aak imolol u tzoteꞌ. As tul molol veꞌt tzan, ech alpu ileꞌ ste: —Txakpen. Bꞌan atiaal, tan nimolo axh u Jesús,— tiꞌk unqꞌa uxhchileꞌ te naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","As taqꞌ veꞌt kan naj umaꞌl u chelkin oksaꞌm uvaꞌ atik ok tiꞌ naj. As txakpu veꞌt naj tiꞌ tul kꞌatz u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","As ech tal veꞌt u Jesús ileꞌ: —¿Kam qꞌi nasaꞌ uvaꞌ la unbꞌaneꞌ?— tiꞌk Aak. Ech tal veꞌt u tzot ileꞌ: —Chusul, aꞌ ni valeꞌ uvaꞌ la ilon vunvatzeꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","As ech tal veꞌt u Jesús ileꞌ: —Kuxh veꞌteꞌ, tan tiꞌ uvaꞌ kat akꞌujbꞌaꞌ akꞌuꞌl sviꞌ, as kat ilonyu veꞌt vavatzeꞌ,— tiꞌk Aak. As yak kuxh ilon veꞌt naj. As xekebꞌ veꞌt naj tiꞌ u Jesús tul bꞌen veꞌt Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tul bꞌiitik kuxh toon veꞌt u Jesús tu u Jerusalén, tul atik Aak kꞌatz u Betfagé tukꞌ u Betania, kꞌatz umaꞌl u vitz uvaꞌ Olivos, as ichaj veꞌt bꞌen Aak kaꞌvaꞌl unqꞌa ichusulibꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ech tal veꞌt Aak ileꞌ: —Bꞌenoj ex tu u tal tenameꞌ uveꞌ at tzan. As tul la oon ex, as la bꞌen elej umaꞌl u tal bꞌur uvaꞌ yeꞌ atixoj jeꞌ umaj uxhchil stiꞌ. As kꞌalel kan txoo. As la esaapu txoo. As la eteqꞌo tzan txoo. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Asoj abꞌil la alon sete uvaꞌ: «¿Kam itxaꞌk txoo nesaapu?» chaj chꞌelel ex, as ech la etal ileꞌ: «Aꞌ u kuBꞌooqꞌoleꞌ tuk txakonsan txoo. As tuk iqꞌaavisa Aak txoo,» chaj ex,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","As bꞌen veꞌt chajnaj. As bꞌex ilej chajnaj u tal bꞌureꞌ uvaꞌ kꞌalik kan tu bꞌey tziꞌ umaꞌl u kabꞌal. As isaapu veꞌt chajnaj txoo. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","As ech tal veꞌt kaꞌl unqꞌa uxhchil ileꞌ uvaꞌ atik tzitziꞌ: —¿Kam itxaꞌk u tal bꞌureꞌ qꞌi nesaapu?— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","As tal veꞌt chajnaj kam uvaꞌ tal u Jesús te chajnaj. As taqꞌ veꞌt unqꞌa uxhchileꞌ u bꞌureꞌ te chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Teqꞌo veꞌt tzan chajnaj u bꞌureꞌ kꞌatz u Jesús. As taqꞌ veꞌt jeꞌ chajnaj unqꞌa ixbꞌuꞌjeꞌ tiꞌ txoo. As jeꞌ veꞌt Aak tiꞌ txoo. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","As iliipu veꞌt kuꞌ unqꞌa tenameꞌ ixbꞌuꞌj tu bꞌey. As at uxhchil tzokꞌon veꞌt xaj chꞌiꞌm. As taqꞌ veꞌt kuꞌ tu u bꞌeyeꞌ vatz Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","As unqꞌa uxhchileꞌ uvaꞌ bꞌaxik vatz Aak tukꞌ unqꞌa veeꞌ xekik tiꞌ Aak, as taqꞌ veꞌt jeꞌ tuul iviꞌ tiꞌ isikꞌin tiꞌ Aak. Ech nik tal ileꞌ: —¡Qoksataj iqꞌii Aak, tan achvebꞌal chit tul Aak tukꞌ vibꞌii u Kubꞌaal Tiixheꞌ! ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡As achvebꞌal chit tul Aak tiꞌ u tenameꞌ uveꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ echeꞌ uvaꞌ kat ibꞌan u qꞌesla kubꞌaaleꞌ uvaꞌ David! ¡As qoksataj iqꞌii u Tiixheꞌ uvaꞌ echen tu almikaꞌ!— tiꞌk unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","As tul ok veꞌt u Jesús tu u Jerusalén, as ok veꞌt Aak vatz iqꞌanal u tostiixheꞌ. As isaji kuxh Aak unqꞌa veeꞌ skajayil. As qꞌaav veꞌt Aak tu u Betania tukꞌ kabꞌlaval unqꞌa ichusulibꞌeꞌ, tan aalik veꞌt itzꞌotineꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tu umaꞌt qꞌii, as el veꞌt chꞌuꞌl Aak tu u Betania tiꞌ ibꞌen tu u Jerusalén unpajte. As vaꞌy veꞌt Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","As til veꞌt bꞌen Aak viꞌl u higuera uvaꞌ atik ixaj. As jetzꞌen veꞌt ok Aak kꞌatz tzeꞌ, tan kamal atik ivatz tzeꞌ uvaꞌ nik tal Aak. As tul yeꞌlik chit umaj ivatz tzeꞌ atike. Pet ixaj kuxh tzeꞌ atike, tan yeꞌxnik ilejat ivatzin tzeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","As ech tal veꞌt Aak ileꞌ: —Yeꞌxh jatu la loꞌp veꞌt umaj avatz taꞌn umaj uxhchil,— tiꞌk Aak tal te u tzeꞌeꞌ. As tabꞌi veꞌt unqꞌa chusulibꞌ Aakeꞌ uveꞌ tal Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","As tul ok veꞌt u Jesús tu u Jerusalén, as ok veꞌt Aak vatz viqꞌanal u tostiixheꞌ. As itilu veꞌt el Aak unqꞌa uxhchileꞌ uveꞌ nikat ikꞌayineꞌ as tukꞌ unqꞌa uxhchileꞌ uveꞌ nikat iloqꞌoneꞌ. As ipilqꞌu veꞌt Aak imeexha unqꞌa jalol puajeꞌ tukꞌ u tatinbꞌal unqꞌa paroomaxheꞌ uveꞌ nik kꞌayileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","As yeꞌ nik ichajpu ok u Jesús umaj uxhchil uvaꞌ eqꞌomal ikꞌaꞌy staꞌn. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","As xeꞌt veꞌt Aak chusun. Ech tal veꞌt Aak ileꞌ: —Ootzimal setaꞌn uvaꞌ ech ni tal u yol ileꞌ uvaꞌ tzꞌibꞌamal kan: Nachbꞌal vetzeꞌ vunkabꞌaleꞌ la ibꞌaneꞌ tiꞌ uvaꞌ la inach in unqꞌa tenameꞌ skajayil, tiꞌk Aak. Pet ech koj ex, tan kat ebꞌensal veꞌteꞌ statinbꞌal elqꞌom,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","As unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh tukꞌ unqꞌa uxhchileꞌ uvaꞌ chuselik tibꞌ tiꞌ u tzaqꞌiteꞌ uvaꞌ tzꞌibꞌamal kan, as tabꞌi veꞌt chajnaj u yoleꞌ uvaꞌ tal u Jesús. As ichuk veꞌt chajnaj txumbꞌal tiꞌ iyatzꞌpu veꞌt Aak. As nik ixoꞌv chajnaj te Aak, tan achaꞌv chit ichusun Aak vatz unqꞌa tenameꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","As tul tzꞌotin veꞌteꞌ, as el veꞌt chꞌuꞌl u Jesús tu u tenameꞌ unpajte tukꞌ unqꞌa ichusulibꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tu veꞌt umaꞌt qꞌii qꞌalaꞌm, as pal veꞌt u Jesús tukꞌ unqꞌa ichusulibꞌeꞌ unpajte kꞌatz u higuera. As til veꞌt chajnaj uvaꞌ maꞌtik itzaj veꞌt u higuera tukꞌ u taqꞌileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","As tulsa veꞌt u Luꞌeꞌ unqꞌa yoleꞌ skꞌuꞌl uvaꞌ tal u Jesús te u higuera. Ech tal veꞌt naj ileꞌ: —Chusul, il u higuera ileꞌ kat tzajyu veꞌteꞌ uvaꞌ kat aal ste uvaꞌ yeꞌxh jatu la loꞌp veꞌt umaj ivatz taꞌn unqꞌa uxhchileꞌ,— tiꞌk u Luꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ech tal veꞌt u Jesús ileꞌ: —Ekꞌujbꞌaꞌtaj ekꞌuꞌl tiꞌ u Tiixheꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","tan jik chit tuk val sete, asoj la etal te u vitz ileꞌ: «¡Elen tzitziꞌ! ¡As kuxh bꞌen tu u mar!» chaj ex la etaleꞌ, as la chit ibꞌaneꞌ asoj yeꞌ la kaꞌkabꞌin etaama. Pet la ekꞌujbꞌaꞌ ekꞌuꞌl tiꞌ uvaꞌ la chit ibꞌaneꞌ kam uvaꞌ la etaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Estiꞌeꞌ ni val sete, tan asoj kꞌujleꞌl chit ekꞌuꞌl tiꞌ u Tiixheꞌ tul la enach Tiixh, as la chit ibꞌan Aak kam uveꞌ la ejaj te Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","As tul la enach u Tiixheꞌ uvaꞌ echen tu almikaꞌ, as esotzsataj ipaav umaj uxhchil uvaꞌ atoꞌk exoꞌl stukꞌ, aqꞌal uvaꞌ la isotzsa u Tiixheꞌ epaav, ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","tan asoj yeꞌ la esotzsa ipaav u uxhchileꞌ, as yeꞌl epaav la isotzsa u Tiixheꞌ uvaꞌ echen tu almikaꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","As ok veꞌt u Jesús tu u Jerusalén unpajte. As tul nik ixaan Aak vatz iqꞌanal u tostiixheꞌ, as kat jetzꞌen veꞌt ok unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh, tukꞌ unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as tukꞌ unkaꞌt unqꞌa bꞌaal tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ech tal veꞌt chajnaj ileꞌ: —¿Abꞌil aqꞌol tetz u eejleꞌmeꞌ tiꞌ uvaꞌ kat ul atilu el unqꞌa uxhchileꞌ vatz iqꞌanal u tostiixheꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","As ech tal veꞌt u Jesús ileꞌ: —Tuk unchꞌoti umaꞌl u yol sete. Asoj la etal sve, as la val sete uvaꞌ abꞌil aqꞌol tetz u vijleꞌmeꞌ tiꞌ unqꞌa veeꞌ kat unbꞌana. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Etaltaj sve: ¿Abꞌil kat chajon tzan u Xhuneꞌ uvaꞌ nik aqꞌon kuꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ? ¿Ma aꞌ u Tiixheꞌ? ¿Pet moj umaj vatz txꞌavaꞌilla aama?— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","As iyol veꞌt chajnaj svatzaj uvaꞌ kam la tal chajnaj. Ech tal veꞌt chajnaj ileꞌ: —Asoj tuk qaleꞌ uvaꞌ Tiixh kat chajon tzan u Xhuneꞌ, as: «¿Kam qꞌi yeꞌ kat enima u Xhuneꞌ?» chaj naj tuk tal sqe. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","As yeꞌ la uch qalataꞌ uvaꞌ umaj vatz txꞌavaꞌilla aama kat chajon tzan u Xhuneꞌ,— tiꞌk chajnaj svatzaj, tan nik ixoꞌva chajnaj unqꞌa tenameꞌ, tan kajayil chit unqꞌa tenameꞌ nik niman uvaꞌ qꞌajsan tetz viyol u Tiixheꞌ u Xhuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Estiꞌeꞌ ech tal veꞌt chajnaj ileꞌ te u Jesús: —Yeꞌ qootzaj abꞌil kat chajon tzan u Xhuneꞌ,— tiꞌk chajnaj. As ech tal u Jesús ileꞌ: —Mitaꞌn in la alon sete uvaꞌ abꞌil kat aqꞌon u vijleꞌmeꞌ tiꞌ uvaꞌ kat unbꞌana,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","As xeꞌt veꞌt u Jesús chusun tukꞌ kaꞌt unqꞌa kꞌuchuvatz. As ech tal Aak ileꞌ: —Tan tava veꞌt umaꞌl u naj kaꞌl unqꞌa uuva tu vitxꞌavaꞌeꞌ. As toksa naj peꞌ stiꞌ. As ibꞌan veꞌt naj tuch umaꞌl u atinbꞌal uvaꞌ la pochꞌilkat u taꞌl u uuvaeꞌ. As ilak veꞌt naj umaꞌt u atinbꞌal xeebꞌal tetz unqꞌa uuvaeꞌ uvaꞌ nim chit itxakebꞌeꞌ. As taqꞌ veꞌt kan naj vitxꞌavaꞌeꞌ tukꞌ unqꞌa uuvaeꞌ skꞌam te kaꞌl unqꞌa kꞌamol. As bꞌen veꞌt naj tziꞌaꞌn. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tul ilej veꞌt u qꞌiieꞌ tiꞌ ituxpu ivatz unqꞌa uuvaeꞌ, as ichaj veꞌt vibꞌaal unqꞌa uuvaeꞌ umaꞌl vikꞌam xeꞌ unqꞌa kꞌamoleꞌ tiꞌ ul teqꞌot unbꞌooj ivatz unqꞌa uuvaeꞌ, kꞌambꞌal tetz u txꞌavaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","As kat itxey unqꞌa kꞌamoleꞌ u kꞌameꞌ uvaꞌ chajel taꞌn u bꞌaal txꞌavaꞌeꞌ. As yeꞌxhkam chit taqꞌ bꞌen chajnaj stiꞌ. Pet kat iqꞌos veꞌt chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","As ichaj veꞌt bꞌen vibꞌaal unqꞌa uuvaeꞌ umaꞌt vikꞌameꞌ. As tul ooni, as isuti chajnaj kꞌubꞌ tiꞌ iviꞌ. As tul maꞌt iyoqꞌat chajnaj, as iqꞌaavisa bꞌen chajnaj kꞌatz vibꞌaal u uuvaeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","As ichaj veꞌt bꞌen vibꞌaal unqꞌa uuvaeꞌ umaꞌt ikꞌam. As iyatzꞌ veꞌt unqꞌa kꞌamoleꞌ u kꞌameꞌ. As ichaj veꞌt bꞌen vibꞌaal unqꞌa uuvaeꞌ unjoltu ikꞌam. As ati uvaꞌ kat kꞌaxbꞌisali; as ati uvaꞌ kat yatzꞌpi. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","As tul maꞌtik ichajat veꞌt bꞌen vibꞌaal unqꞌa uuvaeꞌ unqꞌa ikꞌameꞌ, as aꞌ veꞌt vikꞌaoleꞌ kat ichaj bꞌen uvaꞌ xoꞌnik chit ste, tan ech tal jeꞌ u bꞌaal u uuva ileꞌ ste: «Tuk nimalojeꞌ vunkꞌaoleꞌ taꞌn unqꞌa kꞌamoleꞌ,» tiꞌke. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","As ech tal veꞌt unqꞌa kꞌamol ileꞌ svatzaj: «Aꞌ vikꞌaol najeꞌ vil tuleꞌ. As aꞌ najeꞌ tuk etzin kan unqꞌa uuvaeꞌ tukꞌ u txꞌavaꞌeꞌ. ¡Pet koꞌ kuyatzꞌ naj! ¡As qetz veꞌt u txꞌavaꞌeꞌ la ibꞌaneꞌ!» tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","As itxey veꞌt chajnaj vikꞌaol vibꞌaal u uuvaeꞌ. As iyatzꞌ veꞌt chajnaj. As bꞌex isuti veꞌt el chajnaj vichiꞌoleꞌ tiꞌeꞌl u txꞌavaꞌeꞌ uvaꞌ atikkat unqꞌa uuvaeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","¿As kam qꞌi la ibꞌan veꞌt vibꞌaal unqꞌa uuvaeꞌ uvaꞌ netaleꞌ? ¿As yeꞌ kol la bꞌen iyatzꞌ veꞌt naj qꞌa unqꞌa kꞌamoleꞌ? As vaꞌlen la taqꞌkat veꞌt vitxꞌavaꞌeꞌ skꞌam, uvaꞌ atkat unqꞌa uuvaeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿As ma yeꞌ atixoj esikꞌle u yoleꞌ uvaꞌ tzꞌibꞌamal kan uvaꞌ ech ni tal ileꞌ: As u kꞌubꞌeꞌ uvaꞌ kat sutil el taꞌn unqꞌa lakol kabꞌaleꞌ, as aꞌ veꞌteꞌ uveꞌ xeꞌabꞌ tetz vixoobꞌ u kabꞌaleꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","As aꞌ chit achvebꞌaleꞌ sqe, tan aꞌ u Tiixheꞌ kat bꞌanon, tiꞌk u yoleꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","As unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh, tukꞌ unqꞌa uxhchileꞌ uvaꞌ chuselik tibꞌ tiꞌ u tzaqꞌiteꞌ uvaꞌ tzꞌibꞌamal kan, as tukꞌ kaꞌt unqꞌa bꞌaal tenameꞌ, as tal veꞌt chajnaj itxeyat u Jesús, tan pal veꞌt chajnaj stuul uvaꞌ chajnaj nikat tal u Jesús tukꞌ u kꞌuchuvatzeꞌ uvaꞌ nik tal Aak. As jit ibꞌan chajnaj, tan nik ixoꞌv chajnaj vatz unqꞌa tenameꞌ. As bꞌen veꞌt chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","As chajpik veꞌt bꞌen kaꞌl unqꞌa fariseo tukꞌ kaꞌt unqꞌa tiaal Israel uvaꞌ atik ok kꞌatz u Herodes, tiꞌ icheesat chajnaj ipaav u Jesús. As la uch ixochat veꞌt chajnaj Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","As tul oon veꞌt chajnaj kꞌatz Aak, as ech tal veꞌt chajnaj ileꞌ: —Chusul, ootzimal veꞌt sqaꞌn uvaꞌ jik chit nayoloneꞌ. As yeꞌxhebꞌil naxoꞌv ste tul nachusuneꞌ, tan eela ivatz unqꞌa uxhchileꞌ nabꞌaneꞌ. As kꞌuxh at tijleꞌm as kꞌuxh yeꞌl tijleꞌm ati, as nachus unqꞌa uxhchileꞌ tiꞌ uvaꞌ jik vitxumbꞌaleꞌ la ibꞌan vatz u Tiixheꞌ. As tuk kuchꞌoti see, ¿ma bꞌaꞌn uvaꞌ la kuchoo veꞌt u puajeꞌ uveꞌ nijajpu sqe taꞌn u ijlenaaleꞌ tu u Roma, pet moj yeꞌle?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","As ootzimalik taꞌn u Jesús uvaꞌ kaꞌvatz kuxh chajnaj. As ech tal veꞌt Aak ileꞌ: —¿Kam qꞌi uveꞌ nu kuxh echuk txumbꞌal sviꞌ? Eteqꞌotaj tzan umaj u puajeꞌ. As la vileꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","As eqꞌol veꞌt tzan u puajeꞌ. As ech tal veꞌt Aak ileꞌ: —¿Abꞌil etz u vatzibꞌaleꞌ qꞌi tukꞌ u tzꞌibꞌeꞌ uveꞌ at vatz u puajeꞌ?— tiꞌk Aak. As ech tal chajnaj ileꞌ: —Tetz u ijlenaaleꞌ tu u Roma,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ech tal veꞌt u Jesús ileꞌ: —As jankꞌal u tetz u ijlenaaleꞌ uveꞌ tu u Roma, as etaqꞌtaj ste. Pet jankꞌal u tetz u Tiixheꞌ, as etaqꞌtaj te Aak,— tiꞌk u Jesús. As teqꞌo veꞌt taama chajnaj taꞌn u yoleꞌ uveꞌ tal Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","As unqꞌa saduceo uvaꞌ ni alon uvaꞌ yeꞌl unqꞌa kamnajeꞌ ni tul taama, as ul kaꞌl chajnaj tiꞌ ichꞌotit te u Jesús. Ech tal chajnaj ileꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Chusul, kat itzꞌibꞌa kan u Moisés umaꞌl u yol uvaꞌ ech ni tal ileꞌ: «Asoj la kam umaj naj as tul yeꞌl umaj initxaꞌ naj la kaaik kan xeꞌ u tixqeleꞌ, as aꞌ umaj u titzꞌin tatzik najeꞌ la teqꞌo tibꞌ tukꞌ u ixojeꞌ tiꞌ taqꞌat kan tiaal u najeꞌ uvaꞌ kat kami,» tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","As ibꞌan unpajul atik vujvaꞌl unqꞌa naj uvaꞌ titzꞌinik tibꞌ. As kat teqꞌo tibꞌ u atzikaeꞌ tukꞌ u tixqeleꞌ. As kam veꞌt naj. As jit kaaik kan meꞌal ikꞌaol naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","As teqꞌo tibꞌ u ixojeꞌ tukꞌ u bꞌaxa titzꞌin najeꞌ. As kat kam naj. As jit kaaik kan meꞌal ikꞌaol naj. As echat chit kat ibꞌan ikaꞌv u itzꞌinaeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","As ech kat ibꞌan veꞌt vujvaꞌl unqꞌa najeꞌ skajayil uvaꞌ titzꞌin tibꞌ. As jit kaaik kan meꞌal ikꞌaol chajnaj. As tul maꞌtik ikam veꞌt vujvaꞌl unqꞌa najeꞌ uvaꞌ titzꞌin tibꞌ, as kam veꞌt u ixojeꞌ unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","As tul uvaꞌ la ul veꞌt taama unqꞌa kamnajeꞌ, ¿as abꞌiste veꞌt u najeꞌ qꞌi itzumel u ixojeꞌ? Tan kat teqꞌo tibꞌ ixoj tukꞌ vujvaꞌl unqꞌa najeꞌ uvaꞌ titzꞌin tibꞌ,— tiꞌk unqꞌa saduceo. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ech tal veꞌt u Jesús ileꞌ: —Sotznal chit ekꞌuꞌl, tan yeꞌ nepal stuul kam uvaꞌ ni tal viyol u Tiixheꞌ. As mitaꞌn yeꞌ nepal stuul tiꞌ uvaꞌ la tulsa Aak taama unqꞌa kamnajeꞌ unpajte, ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","tan tul la ul veꞌt taama unqꞌa kamnajeꞌ, as yeꞌl unqꞌa najeꞌ la teqꞌo tibꞌ tukꞌ umaj u ixoj. As mitaꞌn unqꞌa ixojeꞌ. Pet ech veꞌteꞌ echeꞌ unqꞌa ángel uveꞌ at tu almikaꞌ la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","As echat ni tal u yoleꞌ uvaꞌ kat tal kan u Moisés tiꞌ tul taama unqꞌa kamnajeꞌ unpajte. As yeꞌ nepal tu u yoleꞌ uvaꞌ tal u Moisés, tul uvaꞌ kat yolon Aak xoꞌl u vokkin chꞌiꞌxeꞌ. As ech tal Aak ileꞌ: «Ineꞌ iTiixh u Abraham, as iTiixh u Isaac, as iTiixh u Jacob,» tiꞌk Aak te u Moisés. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Estiꞌeꞌ uvaꞌ sotznalu chit ekꞌuꞌl, tan jit aꞌ unqꞌa kamnajeꞌ ni niman u Tiixheꞌ. Pet aꞌ unqꞌa uxhchileꞌ uvaꞌ isleꞌl vatz Aak,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","As umaꞌl u uxhchil uvaꞌ chuselik tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as tabꞌi veꞌteꞌ uvaꞌ ikꞌulbꞌe veꞌt u Jesús unqꞌa saduceo tibꞌaꞌnil. As jetzꞌen veꞌt ok naj kꞌatz Aak. As ech tal veꞌt naj ileꞌ: —¿Abꞌiste u tzaqꞌiteꞌ uveꞌ nim talcheꞌ?— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ech tal veꞌt Aak ileꞌ: —U tzaqꞌiteꞌ uveꞌ nim talcheꞌ, as ech ni tal ileꞌ: Ex kumool tiaal Israel, etabꞌitaj u yoleꞌ uvaꞌ tuk val sete, umaꞌl kuxh u Tiixheꞌ. As Aakeꞌ kuBꞌooqꞌol. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","As ayaꞌloj chit ekꞌuꞌl la exoꞌni u Tiixheꞌ tukꞌ chit etaanxelal, tukꞌ chit etxumbꞌal, as tukꞌ chit eyakꞌil, tiꞌk u tzaqꞌiteꞌ. As aꞌeꞌ u tzaqꞌiteꞌ uvaꞌ nim talcheꞌ tiꞌ unjoltu unqꞌa tzaqꞌiteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","As vikaꞌv u tzaqꞌiteꞌ, as eela tukꞌ u bꞌaxaeꞌ, tan ech ni tal ileꞌ: Xoꞌnoj vemooleꞌ sete echeꞌ uvaꞌ nebꞌan jeꞌ sete, tiꞌk u tzaqꞌiteꞌ. As yeꞌl umaꞌtoj tzaqꞌit uvaꞌ nim talcheꞌ tiꞌ kaꞌvaꞌl unqꞌa tzaqꞌiteꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","As ech tal veꞌt u naj ileꞌ uvaꞌ chuselik tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ: —An chiteꞌ, chusul, uveꞌ naaleꞌ, uvaꞌ umaꞌl kuxh u Tiixheꞌ ati. As yeꞌl umaꞌtoj tiixh echeꞌ u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","As ayaꞌloj chit kukꞌuꞌl la kuxoꞌni u Tiixheꞌ tukꞌ chit kutxumbꞌal, tukꞌ chit qaanxelal, as tukꞌ chit kuyakꞌil. As la kuxoꞌni u kumooleꞌ echeꞌ uvaꞌ nu kubꞌan jeꞌ sqe. As aꞌeꞌ uvaꞌ nim talcheꞌ tiꞌ itzꞌeꞌsal ok unqꞌa oyeꞌ as tukꞌ unqꞌa txooeꞌ vatz u Tiixheꞌ,— tiꞌk u najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","As til veꞌt u Jesús uvaꞌ ikꞌulbꞌe veꞌt u najeꞌ Aak tijikil. As ech tal veꞌt Aak ileꞌ: —Bꞌiit kuxh asaꞌ tiꞌ ook xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ,— tiꞌk u Jesús. As yeꞌxhebꞌil chit kat chꞌotin umaꞌtoj yol te Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Tul nik ichusun u Jesús vatz iqꞌanal u tostiixheꞌ, as ech tal veꞌt Aak ileꞌ: —Unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, ¿as kam bꞌan taꞌn qꞌi uvaꞌ ni tal chajnaj uvaꞌ tiaal David u Cristo? ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tan ech ni tal umaꞌl yol ileꞌ uvaꞌ tal u David taꞌn u Tiixhla Espíritu: Ech tal u Bꞌooqꞌol ileꞌ te vunBꞌooqꞌoleꞌ: Xonebꞌen tu vunsebꞌaleꞌ techanal la vaqꞌ kan unqꞌa uxhchileꞌ jaqꞌ avoj uveꞌ nichꞌoꞌn taama seeꞌ, tiꞌk u David tal kan. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Pet tul ni tal u David tiꞌ u Cristo uvaꞌ «unBꞌooqꞌol,» taqꞌeꞌ ni taleꞌ, ¿as kam qꞌi uvaꞌ nenima uvaꞌ tiaal David u Cristo?— tiꞌk u Jesús. As ayaꞌlik chit ikꞌuꞌl unqꞌa uxhchileꞌ tul nik tabꞌi viyol Aakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","As ech tal veꞌt u Jesús ileꞌ tul nik ichusun Aak: —Atoj enachbꞌal vatz unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, tan achaꞌv chit te chajnaj uvaꞌ ni toksa chajnaj unqꞌa bꞌaꞌnla oksaꞌmeꞌ tukꞌ uvaꞌ ni tok iqꞌii chajnaj taꞌn unqꞌa tenameꞌ tu u kꞌayibꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","As aꞌ unqꞌa bꞌaꞌnla chaj xonlebꞌaleꞌ nichuk chajnaj tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh. As aꞌ nixonebꞌkat chajnaj tu u bꞌaxa xonlebꞌaleꞌ tul ni tuch unqꞌa bꞌaꞌnla txꞌaꞌoꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","As nimaa chajnaj vikabꞌal unqꞌa txakay ixojeꞌ. As nimal chit yol ni tal chajnaj tiꞌ ikꞌuchat chajnaj uvaꞌ bꞌaꞌnla nachol Tiixh chajnaj ni tal jeꞌ ste. As tul aꞌ chajnajeꞌ uveꞌ nimal u kꞌaxkꞌoeꞌ la ipalebꞌe,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","As tul xonlik veꞌt u Jesús txala u kaaxhaeꞌ uvaꞌ nimolpukat u puajeꞌ, as aalik veꞌt ok u Jesús te unqꞌa uxhchileꞌ uveꞌ nik aqꞌon kuꞌ unqꞌa puajeꞌ tu u kaaxhaeꞌ. As nimal unqꞌa txꞌioliqꞌiieꞌ uvaꞌ atik tzitziꞌ. As nimal chit puaj nik taqꞌ kuꞌ chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","As ul veꞌt umaꞌl u txakay ixoj uvaꞌ meebꞌaꞌ chittuꞌ tiꞌ ul taqꞌat kuꞌ kaꞌvaꞌl vas ipuaj uvaꞌ yeꞌxh jatvaꞌl ijaꞌmil. As tul til veꞌt u Jesús taqꞌat kuꞌ u txakay ixojeꞌ u puajeꞌ tu u kaaxhaeꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","as imolo veꞌt Aak unqꞌa ichusulibꞌeꞌ. Ech tal veꞌt Aak ileꞌ: —Jik chit tuk val sete, tan u txakay ixojeꞌ uvaꞌ meebꞌaꞌ chittuꞌ, as nimal chiteꞌ u oyeꞌ uvaꞌ kat taqꞌ kuꞌ tiꞌ unjoltu unqꞌa uxhchileꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","tan jankꞌal unqꞌa txꞌioliqꞌiieꞌ uveꞌ kat taqꞌ kuꞌ unqꞌa oyeꞌ, as aꞌ kuxh unqꞌa yaꞌleꞌ ni taqꞌ kuꞌ. Pet ech koj u txakayeꞌ, tan kꞌuxh meebꞌaꞌ chit ixoj, as kat taqꞌ kuꞌ ixoj jankꞌal uveꞌ nitxakon stiꞌ jun qꞌii,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","El veꞌt chꞌuꞌl u Jesús vatz iqꞌanal u tostiixheꞌ tukꞌ unqꞌa ichusulibꞌeꞌ. As ech tal veꞌt umaꞌl vichusulibꞌ Aak ileꞌ ste: —¡Chusul, achaꞌv chit tilon unqꞌa sivaneꞌ tukꞌ unqꞌa bꞌaꞌnla kabꞌaleꞌ uvaꞌ seteꞌrumal tiꞌ u tostiixheꞌ staꞌn!— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","As ech tal veꞌt u Jesús ileꞌ: —¿Ma achaꞌv chit unqꞌa bꞌaꞌnla kabꞌaleꞌ uveꞌ neeleꞌ? As tuk val see uvaꞌ yeꞌl umaj sivan la kaa viꞌ umaꞌt sivan, tan kajayil chiteꞌ la eꞌpi,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","As bꞌen veꞌt u Jesús tukꞌ unqꞌa ichusulibꞌeꞌ viꞌ u vitzeꞌ uvaꞌ Olivos, uvaꞌ nikaꞌya tibꞌ tukꞌ u tostiixheꞌ. As xonebꞌ veꞌt Aak sijunal. As ul ichꞌoti veꞌt u Luꞌeꞌ, tukꞌ u Jacob, tukꞌ u Xhuneꞌ, as tukꞌ u Lixheꞌ umaꞌl u yol te Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","As ech tal chajnaj ileꞌ: —Pap, al sqe uvaꞌ jatu la ibꞌan u veeꞌ naaleꞌ. ¿As kam texhlal tetz tul bꞌiit itzojpisal unqꞌa veeꞌ skajayil?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","As ech tal veꞌt u Jesús ileꞌ: —Atoj chit enachbꞌal vatz unqꞌa chulin yoleꞌ aqꞌal uvaꞌ yeꞌ la maxtibꞌel ex, ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","tan nimal unqꞌa chulin yoleꞌ la ul tukꞌ vunbꞌiieꞌ. As la ul taleꞌ uvaꞌ: «Ineꞌ u Cristo,» chaj la taleꞌ. As nimal unqꞌa uxhchileꞌ la isotzsa ikꞌuꞌl. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","As xoꞌviꞌk kuxh ex tul la etabꞌi yol tiꞌ uvaꞌ kat xeꞌtiy veꞌt chꞌaꞌo tu umaꞌl u tenam as moj tiꞌ uvaꞌ tuk xeꞌtoj chꞌaꞌo tu umaꞌt tenam, tan echnal chit la ibꞌaneꞌ. As jit oora la ilej u qꞌiieꞌ tiꞌ itzojpisal veꞌteꞌ uvaꞌ alel kan tiꞌ isotz u vatz txꞌavaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tan lanal ibꞌan unqꞌa nimla tenameꞌ chꞌaꞌo svatzaj. As lanal ibꞌan unqꞌa ijlenaaleꞌ chꞌaꞌo svatzaj unpajte. As katil kuxh la ibꞌankat kabꞌlaano. As mamaꞌla vaꞌy la ibꞌaneꞌ. As la veqꞌelkabꞌan unqꞌa tenameꞌ. As ixeꞌtebꞌal kuxh unqꞌa kꞌaxkꞌoeꞌ uvaꞌ txumlebꞌal chit la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","As la chit etil etibꞌ, tan la oksal ok ex vatz unqꞌa bꞌanol tetz isuuchil unqꞌa tenameꞌ. As la qꞌospu veꞌt ex tulaj unqꞌa atinbꞌaleꞌ tetz nachbꞌal Tiixh. As tiꞌ kuxh uvaꞌ kꞌujleꞌl ekꞌuꞌl sviꞌ as la eqꞌol ex vatz unqꞌa ijlenaaleꞌ as vatz unqꞌa bꞌanol ivatz u ijlenaaleꞌ. As tzitziꞌ la bꞌen etalkat isuuchil u yoleꞌ sviꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","As tul uvaꞌ yeꞌxnaj ilejat u qꞌiieꞌ tiꞌ isotz u vatz txꞌavaꞌeꞌ, tan techal la alpu u bꞌaꞌnla yoleꞌ tulaj unqꞌa tenameꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","As tul uvaꞌ la txeypik bꞌen ex vatz unqꞌa ijlenaaleꞌ, as exaansak kuxh etaama tiꞌ uvaꞌ kam la etaleꞌ, tan la aqꞌpu veꞌt eyol uvaꞌ kam la etaleꞌ, tan jit veꞌt etetz u yoleꞌ uveꞌ la etaleꞌ. Pet aꞌ veꞌt u yoleꞌ la etaleꞌ uveꞌ la aqꞌpu sete taꞌn u Tiixhla Espíritu. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","As la ixoch veꞌt tibꞌ unqꞌa uxhchileꞌ tukꞌ unqꞌa titzꞌin tatzikeꞌ tiꞌ iyatzꞌat tibꞌ. As echat la ibꞌan unqꞌa bꞌaalaeꞌ te unqꞌa meꞌal ikꞌaoleꞌ. As la ul veꞌt iviꞌ unqꞌa meꞌal kꞌaoleꞌ tiꞌ unqꞌa ibꞌaaleꞌ. As la tal veꞌt iyatzꞌpeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","As nimal unqꞌa tenameꞌ la ixvan ex tiꞌ uvaꞌ kꞌujleꞌl ekꞌuꞌl sviꞌ. Pet abꞌil uvaꞌ yeꞌ la iyaꞌsa inimat in, kꞌuxh kam kuxh kꞌaxkꞌo la ipalebꞌe, as aꞌeꞌ uvaꞌ at itiichajil kꞌatz u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","As tul la etil tuch veꞌt u mam txumlebꞌaleꞌ uvaꞌ txojonbꞌal chittuꞌ uvaꞌ la bꞌanchi tu u bꞌaꞌnla atinbꞌaleꞌ, as la pal ex stuul, jankꞌal ex uvaꞌ la sikꞌlen u yoleꞌ, tan aꞌeꞌ uvaꞌ kat tal kan u qꞌajsan tetz viyol u Tiixheꞌ uvaꞌ Daniel. As tul la etil ixeꞌt u mam txumlebꞌaleꞌ, as jankꞌal ex uvaꞌ at ex tzitzaꞌ tu u Judea, as la ooj veꞌt ex tulaj unqꞌa koobꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","As jankꞌal ex uvaꞌ at jeꞌ ex viꞌ vekabꞌaleꞌ, as yeꞌ la kuꞌ veꞌt chꞌuꞌl ex tiꞌ bꞌen eteqꞌot el tzan unqꞌa etetzeꞌ uveꞌ at tu vekabꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","As ex uvaꞌ at bꞌen ex tu vitz, as yeꞌ la qꞌaavik tzan ex tiꞌ ul eteqꞌot kaꞌt etoksaꞌm. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","As oyebꞌ chit evatz, ex ixoj uvaꞌ at eyaabꞌil tiꞌ etilat umaj etalaj intxaꞌ tukꞌ ex uvaꞌ nitel ichꞌuꞌun veneꞌeꞌ tul la ul u kꞌaxkꞌoeꞌ setiꞌ tu u qꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","As enachtaj chit Tiixh aqꞌal uvaꞌ jit tu qꞌalaeꞌ uvaꞌ la ooj ex vatz u kꞌaxkꞌoeꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","tan mamaꞌla chit kꞌaxkꞌo la uli. As yeꞌ atixoj chit ibꞌan u kꞌaxkꞌoeꞌ echeꞌ u veeꞌ tul sichee u vatz txꞌavaꞌeꞌ taꞌn u Tiixheꞌ. As echeꞌ latel koj ibꞌan unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","As yeꞌ koj la ichꞌoobꞌisa u Tiixheꞌ u kꞌaxkꞌoeꞌ, as yeꞌxhebꞌileꞌ la itxꞌol tel vatz u kꞌaxkꞌoeꞌ. Pet tiꞌ uvaꞌ nitxum Aak ivatz unqꞌa tenameꞌ uveꞌ txaael veꞌt taꞌn Aak, as estiꞌeꞌ tuk ichꞌoobꞌisa Aak u kꞌaxkꞌoeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Tan asoj abꞌil la alon sete uvaꞌ: «Il u Cristo ileꞌ at tzitzaꞌ» as moj «Ileꞌ at tziꞌleꞌ,» chaj chꞌelel ex, as enimaki, ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","tan at uxhchil la ul alon sete uvaꞌ: «Ineꞌ in U Cristo» as moj «Ineꞌ in U qꞌajsan tetz viyol u Tiixheꞌ,» chaj la tal sete. As la ikꞌuch unqꞌa kꞌuchbꞌal tetz unqꞌa bꞌaꞌnileꞌ vatz unqꞌa tenameꞌ uvaꞌ la teqꞌo taama unqꞌa tenameꞌ staꞌn tiꞌ imaxtibꞌel unqꞌa tenameꞌ. As la koj uchi, as anteꞌ unqꞌa itenam u Tiixheꞌ uveꞌ txaael veꞌt taꞌn Aak la maxtibꞌeli. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pet atoj enachbꞌal, tan ileꞌ kat val isuuchil sete bꞌaxa tul yeꞌxnaj ibꞌana. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","As tul maꞌt ipal u mam kꞌaxkꞌoeꞌ tu unqꞌa qꞌiieꞌ, as la tokin veꞌt u qꞌiieꞌ. As yeꞌl veꞌt u ichꞌeꞌ la txijun veꞌteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","As la chajpik veꞌt tzan unqꞌa txꞌumileꞌ vatz u almikaꞌeꞌ. As la yikul veꞌt unqꞌa veeꞌ at vatz u almikaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","As la til veꞌt unqꞌa tenameꞌ u tulebꞌaleꞌ VIKꞌAOL U NAJEꞌ tu u suutzꞌeꞌ. As la ul in tukꞌ vunyakꞌileꞌ as la litzꞌloꞌlan u vulebꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","As la unchaj veꞌt tzan unqꞌa ángel tiꞌ ul imolat unqꞌa tenameꞌ uvaꞌ txaael svaꞌn vatz u txꞌavaꞌeꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Eteesataj etexhlabꞌal tiꞌ u higuera, tan tul uvaꞌ vaꞌl ichaꞌxal unqꞌa iqꞌabꞌ tzeꞌeꞌ, as ni tel chꞌuꞌl unqꞌa ixaj tzeꞌeꞌ. As ootzimal veꞌt setaꞌn uvaꞌ saqꞌi tuk eloj veꞌteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Echat chit tuk ibꞌan u vulebꞌaleꞌ, tan tul uvaꞌ la etil unqꞌa kꞌuchbꞌal tetz u vulebꞌaleꞌ uveꞌ ni val sete, as la pal veꞌt ex stuul uvaꞌ najli veꞌt u vulebꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","As jik chit tuk val sete, tan yeꞌxnaj sotz unqꞌa tenameꞌ uvaꞌ tiaal Israel vatz u txꞌavaꞌeꞌ tul la ibꞌan unqꞌa veeꞌ skajayil uveꞌ ni val sete, ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","tan la pal u almikaꞌeꞌ tukꞌ u vatz txꞌavaꞌeꞌ. Pet ech koj vunyoleꞌ, tan aꞌ chiteꞌ yeꞌ la pali. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","As yeꞌxhebꞌil ootzin tetz uvaꞌ kam qꞌiil as kam oora la ibꞌaneꞌ. As mitaꞌn unqꞌa ángel uveꞌ at tu almikaꞌ as mitaꞌn VIKꞌAOL U NAJEꞌ. Pet aꞌ kuxh u Kubꞌaaleꞌ ootzin tetz. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Estiꞌeꞌ ni val sete uvaꞌ etiltaj jeꞌ chit etibꞌ. As atoj chit enachbꞌal. As enachtaj chit Tiixh, tan yeꞌ etootza uvaꞌ jatu la ibꞌan uveꞌ ni val sete. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","As ech la ibꞌan u yoleꞌ uvaꞌ ni val sete echeꞌ umaj u naj uvaꞌ la bꞌen tu umaꞌt tenam, tan la taqꞌ kan u najeꞌ vikabꞌaleꞌ. As la ikꞌujbꞌaꞌ kan naj vikꞌameꞌ tiꞌ ixeep u kabꞌaleꞌ. As la taqꞌ kan u najeꞌ taqꞌon unqꞌa kꞌameꞌ sijununila. As ech la tal kan naj ileꞌ te u xeen tetz u tziꞌ kabꞌaleꞌ: «La achabꞌa ixeep u tziꞌ kabꞌaleꞌ,» chaj naj te vikꞌameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Estiꞌeꞌ ni val sete, atoj chit enachbꞌal, tan ech etatineꞌ echeꞌ u xeen tziꞌ kabꞌaleꞌ, uvaꞌ yeꞌ tootzaj uvaꞌ jatu la ul u bꞌaal kabꞌaleꞌ. ¿As ma sotzsaj, pet moj pokꞌoꞌch aqꞌbꞌal, moj txanti isajbꞌeꞌ, pet moj tul la oqꞌ u peleꞌxheꞌ, as moj maꞌt isajbꞌeꞌ tul la ul vibꞌaal u kabꞌaleꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","As atoj chit enachbꞌal, aqꞌal uvaꞌ yeꞌl ex vatik ex tul uvaꞌ la ul in unpajte, in uvaꞌ ech vatineꞌ echeꞌ vibꞌaal u kabꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","As kam uveꞌ ni val sete, as anteꞌ unqꞌa uxhchileꞌ ni val ste tiꞌ uvaꞌ atoj chit inachbꞌal,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","As ech kaꞌvaꞌt qꞌii tul u nimla qꞌiieꞌ uvaꞌ pascua uvaꞌ nik itxꞌaꞌpkat u paaneꞌ uvaꞌ yeꞌl levadura nikuꞌ xoꞌl. As unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh as tukꞌ unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as nik ichuk veꞌt chajnaj txumbꞌal tiꞌ itxeypu veꞌt u Jesús tukꞌ chuli yol, as tiꞌ iyatzꞌpeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","As ech tal veꞌt chajnaj ileꞌ svatzaj: —Yeꞌ la txeypu veꞌt naj cheel. Pet palnal u nimla qꞌiieꞌ, as aꞌn la txeypu veꞌt naj, aqꞌal uvaꞌ yeꞌ la veqꞌelkabꞌan unqꞌa tenameꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Atik veꞌt u Jesús tu u Betania tu vikabꞌal u Simón uvaꞌ maꞌtik teesat el Aak chꞌaꞌk chin stiꞌ. As tul xonlik ok Aak vatz u meexhaeꞌ, as bꞌex uloj umaꞌl u ixoj uvaꞌ eqꞌomalik txꞌumtxꞌulla tzꞌakabꞌal staꞌn uvaꞌ jeꞌnal chit ijaꞌmil uvaꞌ at tu umaꞌl u bꞌaꞌnla lemeeta. As iqꞌipeꞌl ixoj jupbꞌal itziꞌ u lemeetaeꞌ. As taqꞌ veꞌt jeꞌ ixoj u txꞌumtxꞌulla tzꞌakabꞌaleꞌ tiꞌ iviꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","As kaꞌl unqꞌa uxhchil uveꞌ atik kꞌatz Aak ul veꞌt iviꞌ tiꞌ uveꞌ uchi. As ech tal veꞌt jeꞌ ileꞌ ste: —¿Kam itxaꞌk u bꞌaꞌnla tzꞌakabꞌaleꞌ kat kuxh ipeqꞌ jeꞌ ixoj tiꞌ iviꞌ Aak? ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Pet kꞌayimal koj kat bꞌanchi, tan oꞌlaval kꞌalal (300) qꞌii aqꞌon ijaꞌmil u txꞌumtxꞌulla tzꞌakabꞌaleꞌ. As kat koj aqꞌpu vijaꞌmileꞌ te unqꞌa meebꞌaꞌeꞌ,— tiꞌk unqꞌa uxhchileꞌ nik tal tiꞌ ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","As ech tal veꞌt u Jesús ileꞌ: —¿Kam qꞌi uvaꞌ kam kuxh netal tiꞌ u ixojeꞌ? Tan bꞌaꞌneꞌ taꞌ uveꞌ kat ibꞌan ixoj sve. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","At chiteꞌ unqꞌa meebꞌaꞌeꞌ sexoꞌl. As la uch ebꞌanat u bꞌaꞌneꞌ ste asoj la esaꞌ. Pet ech koj in, tan echeꞌ bꞌenameen koj tuk atinoj in sexoꞌl. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","As echeꞌ u ixojeꞌ, tan kat ibꞌanlu veꞌt ixoj kam uvaꞌ kat uch vatz ixoj tiꞌ ibꞌanataꞌ, tan kat toksal veꞌt ixoj u txꞌumtxꞌulla tzꞌakabꞌaleꞌ tiꞌ vunchiꞌoleꞌ tiꞌ vunmujlebꞌaleꞌ, kꞌuxh yeꞌl in kamoj in. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","As jik chit tuk val sete, tan katil uvaꞌ la paxsalkat u bꞌaꞌnla yoleꞌ sviꞌ vatz u txꞌavaꞌeꞌ, as la paxsal itzibꞌlal u bꞌaꞌnileꞌ uvaꞌ kat ibꞌan u ixojeꞌ sve tiꞌ tulsat unqꞌa tenameꞌ skꞌuꞌl uvaꞌ kat ibꞌan u ixojeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","U Judas uvaꞌ Iscariote, as najeꞌ uveꞌ atik ok xoꞌl kabꞌlaval unqꞌa ichusulibꞌ u Jesús, as bꞌex til veꞌt naj unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh tiꞌ uvaꞌ la taqꞌoꞌk naj u Jesús tiqꞌabꞌ chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tul tabꞌi veꞌt chajnaj u yoleꞌ, as txuqꞌtxun chit veꞌt chajnaj. As taltziꞌ veꞌt chajnaj puaj te u Judas. As ichuk veꞌt naj txumbꞌal uvaꞌ kam la tulbꞌe veꞌt naj taqꞌat ok u Jesús tiqꞌabꞌ chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","As tu veꞌt u bꞌaxa qꞌii tetz u nimla qꞌiieꞌ tul uvaꞌ sitxꞌaꞌp u paaneꞌ uvaꞌ yeꞌl levadura nikuꞌ sxoꞌl, as ech tal veꞌt unqꞌa ichusulibꞌ u Jesús ileꞌ ste: —¿Katil nasaꞌkat uvaꞌ la bꞌen kubꞌankat tuch u txꞌaꞌoꞌmeꞌ uveꞌ tetz u nimla qꞌiieꞌ tiꞌ kunimataꞌ?— tiꞌk chajnaj, tan tu unqꞌa qꞌiieꞌ as niyatzꞌpu unqꞌa talaj kaneeroꞌeꞌ tiꞌ inimal u nimla qꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","As ichaj veꞌt bꞌen u Jesús kaꞌvaꞌl unqꞌa ichusulibꞌeꞌ. As ech tal Aak ileꞌ: —Bꞌenoj ex tu u tenameꞌ. As la ekꞌul etibꞌ tukꞌ umaꞌl u naj uvaꞌ eqꞌomal umaꞌl txeꞌn aꞌ staꞌn. As la xekebꞌ ex tiꞌ naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","As katil la oonkat u najeꞌ, as ech la etal ileꞌ te vibꞌaal u kabꞌaleꞌ: «Ech ni tal u chusul qetz ileꞌ: –¿Abꞌiste u kabꞌaleꞌ uvaꞌ la txꞌaꞌnkat in tukꞌ unqꞌa unchusulibꞌeꞌ tiꞌ inimal u nimla qꞌiieꞌ?– taqꞌ Aak ni taleꞌ,» chaj ex la bꞌen etal ste. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","As la ikꞌuch veꞌt vibꞌaal u kabꞌaleꞌ umaꞌl u nimla kabꞌal sete uvaꞌ echen tikaꞌv ichup u kabꞌaleꞌ. As bꞌanel veꞌt tuch u kabꞌaleꞌ staꞌn. As tzitziꞌ la ebꞌankat tuch u txꞌaꞌoꞌmeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","As bꞌen veꞌt unqꞌa ichusulibꞌ Aakeꞌ. As tul ok veꞌt chajnaj tu u tenameꞌ, as bꞌex ibꞌana kam uvaꞌ tal Aak te chajnaj. As ibꞌan veꞌt chajnaj tuch u txꞌaꞌoꞌmeꞌ tetz u nimla qꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","As tul tzꞌotin veꞌteꞌ, as ul veꞌt u Jesús tukꞌ kabꞌlaval unqꞌa ichusulibꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","As xonebꞌ veꞌt Aak tukꞌ chajnaj vatz u meexhaeꞌ. As tul nikat itxꞌaꞌn Aak tukꞌ chajnaj, as ech tal veꞌt Aak ileꞌ: —Jik chit tuk val sete, tan at umaꞌl ex netxꞌaꞌn sunkꞌatz, uvaꞌ tuk aqꞌon ok in tiqꞌabꞌ unqꞌa iqꞌesal unqꞌa tenameꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","As txumun veꞌt taama chajnaj. As junun talat veꞌt chajnaj: —¿Ma jit in?— tiꞌk umaꞌl naj; as: —¿Ma jit in?— tiꞌk umaꞌt naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ech tal veꞌt u Jesús ileꞌ: —Exeꞌ umaꞌl uveꞌ xoꞌl kabꞌlaval unqꞌa unchusulibꞌeꞌ uvaꞌ nejil kuꞌ vepaaneꞌ sunkꞌatz tu u lajeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","As jik chit la val sete, tan kam chit uveꞌ tzꞌibꞌamal kan tiꞌ VIKꞌAOL U NAJEꞌ, as aꞌeꞌ uveꞌ tuk unpalebꞌe. ¡Pet oyebꞌ chit ivatz u najeꞌ uveꞌ tuk aqꞌon ok VIKꞌAOL U NAJEꞌ tiqꞌabꞌ unqꞌa iqꞌesal unqꞌa tenameꞌ! Tan aal bꞌaꞌneꞌ uvaꞌ jit koj itzꞌebꞌ naj vatz u txꞌavaꞌeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","As tul aalik itxꞌaꞌn veꞌt u Jesús tukꞌ unqꞌa ichusulibꞌeꞌ, as itxey veꞌt Aak u paaneꞌ. As taqꞌ veꞌt Aak taꞌntiixh stiꞌ. As ijatx veꞌt Aak; as taqꞌ veꞌt Aak te chajnaj. As ech tal veꞌt Aak ileꞌ: «Ekꞌultaj, tan aꞌeꞌ vunchiꞌoleꞌ,» tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","As itxey veꞌt Aak u koopa. As taqꞌ veꞌt Aak taꞌntiixh stiꞌ. As taqꞌ veꞌt ok Aak te chajnaj. As tukꞌa veꞌt chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ech tal veꞌt Aak ileꞌ: —Aꞌ vunkajaleꞌ uvaꞌ tuk jejon kan u akꞌ tzaqꞌiteꞌ, tan tuk eloj vunkajaleꞌ tiꞌ unqꞌa tenameꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","As jik chit tuk val sete, tan yeꞌxh jatu la vukꞌa veꞌt u taꞌl u uuvaeꞌ echeꞌ u vaaꞌ nu kubꞌan cheel. Pet lanal ilej veꞌt u qꞌiieꞌ uvaꞌ la ilpu veꞌteꞌ uvaꞌ at u tenameꞌ jaqꞌ u tijleꞌm u Tiixheꞌ. As aꞌn la vukꞌa veꞌteꞌ unpajte,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","As tul yaꞌ veꞌt ibꞌitzal u bꞌitzeꞌ, as bꞌen veꞌt u Jesús tukꞌ unqꞌa ichusulibꞌeꞌ viꞌ u vitzeꞌ uvaꞌ Olivos. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","As ech tal veꞌt Aak ileꞌ: —Tu u aqꞌbꞌalaꞌ as tuk kaꞌkabꞌinoj veꞌt etaama sviꞌ, tan ech ni tal u yol ileꞌ uvaꞌ tzꞌibꞌamal kan: La unkꞌaxbꞌisa veꞌt u xeen txooeꞌ. As katil kuxh la oojkat veꞌt unqꞌa kaneeroꞌeꞌ, tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","As la val sete, tul la ul veꞌt vaama unpajte, as bꞌaxel la oon in sevatz tu u Galilea,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","As ech tal veꞌt u Luꞌ ileꞌ: —Kꞌuxh kajayil unqꞌa unmooleꞌ la kaꞌkabꞌin taama seeꞌ, as ech koj in, tan yeꞌl in la kaꞌkabꞌin vaama seeꞌ,— tiꞌk u Luꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ech tal veꞌt u Jesús ileꞌ: —As jik chit tuk val see, tan tu aqꞌbꞌalaꞌ tul uvaꞌ yeꞌxnaj oqꞌ u peleꞌxheꞌ kaꞌpajul, as oxpajul maꞌt eesat eebꞌ sunkꞌatz,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","As yaꞌltik chit u Luꞌeꞌ tul ech tal ileꞌ: —Asoj la alpu akameꞌ, as eela kukameꞌ la kam oꞌ, tan ineꞌ yeꞌ la veesa kan vibꞌ sakꞌatz,— tiꞌk naj. As echat chit tal unjoltu unqꞌa ichusulibꞌ Aakeꞌ skajayil echeꞌ uveꞌ tal u Luꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","As ul veꞌt u Jesús tukꞌ chajnaj tu umaꞌl u atinbꞌal uvaꞌ Getsemaní. Ech tal veꞌt Aak ileꞌ te unqꞌa ichusulibꞌeꞌ: —Maꞌt unnach Tiixh tziꞌleꞌ. As xonebꞌoj kan ex tzitzaꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","As teqꞌo veꞌt Aak u Luꞌeꞌ stiꞌ, tukꞌ u Santiago, tukꞌ u Xhuneꞌ. As ok veꞌt umaꞌl u mam txumuꞌm xeꞌ taama Aak tukꞌ xaanchil aama. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ech tal veꞌt Aak ileꞌ: —¡Ootzimal svaꞌn uvaꞌ tuk kamoj veꞌt in! ¡As vaꞌl chit itxumun veꞌt vaama! Pet kaaoj kan ex tzitzaꞌ. As isloj chit ex,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","As jetzꞌen veꞌt el unbꞌiil Aak. As qaaebꞌ veꞌt Aak techal toon ivatz Aak vatz txꞌavaꞌ. As inach veꞌt Aak Tiixh tiꞌ uvaꞌ yeꞌ koj la ipalebꞌe Aak unqꞌa kꞌaxkꞌoeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","As ech tal veꞌt Aak ileꞌ: —UnBꞌaal, xoꞌn chit axh sve. As tuk unjaj see uvaꞌ la eesa el u kꞌaxkꞌoeꞌ sunvatz, tan kajayil chiteꞌ uveꞌ la uch abꞌanataꞌ. As jit in la alon see. Pet axh la alon, Pap,— tiꞌk u Jesús tal te u Kubꞌaal Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","As tul qꞌaavik veꞌt tzan Aak kꞌatz oxvaꞌl unqꞌa ichusulibꞌeꞌ, as vatik veꞌt chajnaj. Ech tal veꞌt Aak ileꞌ te u Luꞌeꞌ: —¿Ma vatik axh bꞌa, Simón? ¿Ma yeꞌ kat akuy umaj oora uvaꞌ la isebꞌ axh? ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Isebꞌoj chit ex. As enachtaj chit Tiixh aqꞌal uvaꞌ la iyakꞌinsa Aak u kꞌujlebꞌal ekꞌuꞌleꞌ sviꞌ tul la chukax txumbꞌal setiꞌ tiꞌ eteesal sunkꞌatz. As kꞌuxh ayaꞌl chit ikꞌuꞌl vetaanxelaleꞌ tiꞌ enachat Tiixh, as ech koj vechiꞌoleꞌ, tan yeꞌ nisaꞌ— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","As bꞌex inach veꞌt Aak Tiixh unpajte. As an chit u yoleꞌ tal Aak uvaꞌ tal Aak bꞌaxa. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tul qꞌaavik veꞌt tzan Aak kꞌatz unqꞌa ichusulibꞌeꞌ unpajte, as vatik veꞌt chajnaj, tan atik vataꞌm tivatz chajnaj. As jit chee veꞌt iyol chajnaj kam uvaꞌ la tal te Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","As tul ul veꞌt Aak titoxpa, as ech tal veꞌt Aak ileꞌ: —¿Antel kuxh vatik ex bꞌa? ¿As iꞌlichil kuxh bꞌa nebꞌaneꞌ? Pet kat ilejlu veꞌteꞌ tiꞌ uvaꞌ la aqꞌax ok in uvaꞌ in VIKꞌAOL U NAJEꞌ tiqꞌabꞌ unqꞌa aapaaveꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pet txakpoj ex. Koꞌnaj, tan il u naj tul veꞌteꞌ uvaꞌ tuk aqꞌon ok in tiqꞌabꞌ unqꞌa najeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","As antelik kuxh iyolon u Jesús tul bꞌex oonoj u Judas uveꞌ atik ok xoꞌl kabꞌlaval unqꞌa ichusulibꞌ Aakeꞌ. As aꞌ chit mamaꞌla tenameꞌ eqꞌomalik chꞌichꞌ tukꞌ tzeꞌ staꞌn uvaꞌ xekik tiꞌ u Judas tan aꞌ unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh, tukꞌ unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as tukꞌ kaꞌt unqꞌa bꞌaal tenameꞌ uvaꞌ chajon bꞌen unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","As maꞌtik taqꞌat u Judas itxumbꞌal chajnaj uvaꞌ kam la ibꞌan chajnaj tul la bꞌen ilej chajnaj u Jesús. Ech tal naj ileꞌ: —Abꞌil uveꞌ la untzꞌubꞌ txala itziꞌ, as aꞌ najeꞌ uveꞌ la etxeyeꞌ as la eqitzeꞌ tul la eteqꞌo,— tiꞌk u Judas. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tul oon veꞌt u Judas, as yak kuxh jetzꞌen veꞌt ok naj kꞌatz u Jesús. As ech tal veꞌt naj ileꞌ: —Keche, Chusul,— tiꞌk naj. As itzꞌubꞌ veꞌt naj txala itziꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","As loqꞌ chit ul ixaꞌpu veꞌt unqꞌa uxhchileꞌ u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","As tzaa veꞌt umaꞌl vichusulibꞌ u Jesús. As teqꞌo veꞌt jeꞌ tzan naj vichꞌichꞌeꞌ tu totzotz. As itzokꞌ veꞌt el naj ixikin umaꞌl vikꞌam viqꞌesal oksan iyol tenam vatz Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","As ech tal veꞌt u Jesús ileꞌ: —¿Kam qꞌi uvaꞌ eqꞌomal chꞌichꞌ tukꞌ tzeꞌ setaꞌn tiꞌ ul etxeyat in? ¿In kol umaj elqꞌom qꞌa? ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","As tul jun qꞌii atik in sexoꞌl tiꞌ unchusuneꞌ tu unqꞌa atinbꞌaleꞌ tu u tostiixheꞌ. As yeꞌ kat etxey in. Pet ech chit tuk ibꞌaneꞌ kam uvaꞌ tzꞌibꞌamal kan,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","As tul tabꞌi veꞌt unqꞌa ichusulibꞌ Aakeꞌ, as ooj veꞌt chajnaj skajayil. As taqꞌ veꞌt kan chajnaj Aak sijunal xoꞌl unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","As atik umaꞌl u chelem naj uvaꞌ bꞌochik tibꞌ tu ixbꞌuꞌj uvaꞌ chajlunik tetz Aak. As txeypu veꞌt naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","As itxꞌol naj toojeꞌ. As aꞌ kuxh u ixbꞌuꞌjeꞌ kaa veꞌt tiqꞌabꞌ unqꞌa najeꞌ. As tꞌosleꞌlik kuxh veꞌt naj tul ooj naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","As eqꞌol veꞌt ok u Jesús vatz viqꞌesal oksan iyol tenam vatz Tiixh. As imol veꞌt tibꞌ unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh, tukꞌ kaꞌt unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as tukꞌ kaꞌt unqꞌa bꞌaal tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","As naach kuxh xekelikkat u Luꞌeꞌ tiꞌ u Jesús techal toon veꞌt naj vatz iqꞌanal viqꞌesal oksan iyol tenam vatz Tiixh. As xonlik veꞌt ok u Luꞌeꞌ kꞌatz kaꞌl unqꞌa xeen tetz u tostiixheꞌ tiꞌ ileeat veꞌt ok tibꞌ vatz xamal. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","As unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh tukꞌ kaꞌt unqꞌa bꞌanol isuuchil unqꞌa tenameꞌ uveꞌ molik veꞌt tibꞌ, tan nik ichuk chajnaj txumbꞌal tukꞌ kaꞌl unqꞌa cheesan paav tiꞌ iyatzꞌpu veꞌt u Jesús. As yeꞌlik iyakꞌil u cheesa paaveꞌ uvaꞌ nik tal unqꞌa uxhchileꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","tan kꞌuxh nimal unqꞌa uxhchileꞌ nik cheesan ipaav Aak, as yeꞌ nik ikꞌul tibꞌ iyol chajnaj svatzaj tiꞌ uvaꞌ la yatzꞌpu veꞌt Aak stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","As txakpu veꞌt kaꞌt unqꞌa naj tiꞌ icheesal ipaav Aak. As ech tal veꞌt chajnaj ileꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Ech kat tal naj ileꞌ kat qabꞌi: «La veꞌpisa veꞌt u tostiixheꞌ uveꞌ bꞌanel taꞌn unqꞌa najeꞌ. As oxvaꞌl kuxh qꞌii la unlak umaꞌte uvaꞌ jit unqꞌa najeꞌ la bꞌanon,» tiꞌk naj,— tiꞌk unqꞌa cheesan tetz ipaav u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pet jit eela u cheesa paaveꞌ nik tal chajnaj tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","As viqꞌesal oksan iyol tenam vatz Tiixh, as txakpu veꞌt naj tiꞌ ichꞌotit kaꞌl u yol te u Jesús. As ech tal veꞌt naj ileꞌ te Aak: —¿Kam qꞌi uveꞌ yeꞌ natiineꞌ? ¿As kam ni tal axh tiꞌ unqꞌa yoleꞌ uveꞌ ni tal chajnaj seeꞌ?— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","As jit tiin u Jesús. As yeꞌl umaj yol tal Aak. As ech tal veꞌt naj ileꞌ unpajte: —¿Ma axh u Cristo, viKꞌaol u Tiixheꞌ uvaꞌ ni toksal iqꞌii?— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ech tal veꞌt u Jesús ileꞌ: —Ineꞌ uveꞌ naaleꞌ. As la etil veꞌt in tul uvaꞌ xonleꞌl veꞌt in tu visebꞌal u Kubꞌaal Tiixheꞌ uvaꞌ nim chit u tijleꞌmeꞌ. As la etil unkuꞌ chꞌuꞌl VIKꞌAOL U NAJEꞌ tu almikaꞌ xoꞌl u suutzꞌeꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","As iqꞌix veꞌt viqꞌesal oksan iyol tenam vatz Tiixh u toksaꞌmeꞌ. Ech tal veꞌt naj ileꞌ: —Jit tzꞌajinal la ul umaꞌtoj uxhchil tiꞌ ixochpu naj, ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","tan kat etabꞌil u yoleꞌ uveꞌ ni tal naj, tan ni toksa tibꞌ naj Tiixhil. ¿As kam ni tal ex tiꞌ naj?— tiꞌk naj. As kajayil chit unqꞌa uxhchileꞌ uvaꞌ molik tibꞌ alon veꞌteꞌ uvaꞌ tetz chit veꞌt u Jesús uvaꞌ la kam Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","As xeꞌt veꞌt kaꞌl unqꞌa uxhchil tiꞌ itzubꞌal Aak. As ijup veꞌt chajnaj ivatz Aak. As itop veꞌt chajnaj Aak taꞌn qꞌabꞌ. As ech tal veꞌt chajnaj ileꞌ: —Asoj axh qꞌajsan tetz viyol u Tiixheꞌ, as qꞌiia uvaꞌ abꞌil kat qꞌoson axh,— tiꞌk chajnaj. As itzꞌich veꞌt unqꞌa xeen tetz u tostiixheꞌ ivatz Aak taꞌn qꞌabꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","As echenik kuꞌ tzan u Luꞌeꞌ vatz iqꞌanal vikabꞌal viqꞌesal oksan iyol tenam vatz Tiixh. As ul veꞌt umaꞌl vikꞌam viqꞌesal unqꞌa nachol Tiixheꞌ uvaꞌ atikkat u Luꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","As tul til veꞌt ixoj u Luꞌeꞌ uvaꞌ nik ileeoꞌk tibꞌ naj vatz xamal, as ech tal veꞌt ixoj ileꞌ tul aalik ok ixoj te naj: —Antik axheꞌ molonik eebꞌ tukꞌ u Jesús uvaꞌ aa Nazaret,— tiꞌk ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ech tal veꞌt u Luꞌ ileꞌ: —Yeꞌ vootzaj u najeꞌ uveꞌ naaleꞌ; as yeꞌ la pal in tu u yoleꞌ uveꞌ naaleꞌ,— tiꞌk u Luꞌeꞌ. As el veꞌt chꞌuꞌl naj tziꞌ kabꞌal. As tul bꞌex oqꞌoj veꞌt u peleꞌxheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","As til veꞌt ixoj u Luꞌeꞌ unpajte. As ech tal veꞌt ok ixoj ileꞌ te unqꞌa uxhchileꞌ uveꞌ atik tzitziꞌ: —U najeꞌ viꞌleꞌ, as imool tibꞌ najeꞌ tukꞌ unqꞌa ichusulibꞌ u Jesús,— tiꞌk ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","As tal veꞌt u Luꞌeꞌ unpajte uvaꞌ yeꞌ toojtzaj naj u Jesús. As unbꞌiil kuxh stuul, as ech tal veꞌt unqꞌa uxhchil ileꞌ te u Luꞌeꞌ: —An chiteꞌ vil amool eebꞌeꞌ tukꞌ unqꞌa ichusulibꞌ u Jesús, tan axh aa Galilea. As ech ayoloneꞌ echeꞌ chajnaj,— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","As ech tal veꞌt u Luꞌ ileꞌ: —¡Asoj nu kuxh unchuli yol sevatz, as sviꞌ la ulkat u vaꞌlexheꞌ, tan vatz u Tiixheꞌ ni valkat uvaꞌ yeꞌ vootzaj u najeꞌ uveꞌ netaleꞌ!— tiꞌk u Luꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","As oqꞌ veꞌt u peleꞌxheꞌ tikaꞌpa. As jubꞌin veꞌt tul viyol u Jesús skꞌuꞌl u Luꞌeꞌ uvaꞌ maꞌtik talat Aak: «Tul yeꞌxnaj oqꞌ u peleꞌxheꞌ tikaꞌpa, as oxpajul maꞌt eesat eebꞌ sunkꞌatz,» tiꞌk Aak. As tul ul veꞌt u yoleꞌ skꞌuꞌl u Luꞌeꞌ, as xeꞌt veꞌt naj oqꞌoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","As kuꞌsaj chittuꞌ, as ikꞌul veꞌt tibꞌ viyol unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh, tukꞌ kaꞌt unqꞌa bꞌaal tenameꞌ, tukꞌ unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as tukꞌ kaꞌt unqꞌa bꞌanol isuuchil unqꞌa tenameꞌ. As iqitz veꞌt chajnaj u Jesús. As bꞌex toksa veꞌt ok chajnaj Aak vatz u Pilato. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","As ech tal veꞌt u Pilato ileꞌ: —¿Ma axh u tijlenaal unqꞌa tiaal Israel?— tiꞌk naj. —An chiteꞌ uveꞌ naaleꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","As unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh, as nimal ipaav Aak nikat icheesa chajnaj vatz u Pilato. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","As ech tal veꞌt u Pilato ileꞌ te u Jesús unpajte: —¿Yeꞌ kuxh natiineꞌ? As tul nimal chit apaav ni tal chajnaj,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","As kꞌuxh ech alpeꞌ te Aak, as mitaꞌn tal Aak umaj yol. As sotz veꞌt ikꞌuꞌl u Pilato stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","As tu u nimla qꞌiieꞌ uvaꞌ pascua, as nik ichajpu u Pilato umaꞌl u preexhu, abꞌil uvaꞌ nikat tal unqꞌa tenameꞌ ichajpuleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","As atik ok umaꞌl u naj preexhuil uvaꞌ Barrabás. As txeyik naj tukꞌ kaꞌt imool, tan maꞌtik iyatzꞌon chajnaj tiꞌ ibꞌanat chꞌaꞌo tiꞌ u ijlenaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","As ul tal veꞌt unqꞌa tenameꞌ te u Pilato uvaꞌ la ichajpu naj umaj u preexhueꞌ tu u nimla qꞌiieꞌ echeꞌ uvaꞌ nik ibꞌan tu jun yaabꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ech tal veꞌt u Pilato ileꞌ: —¿Ma la esaꞌ uvaꞌ la unchajpu u najeꞌ uvaꞌ ni toksa tibꞌ setijlenaalil?— tiꞌk naj, ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","tan atik veꞌt skꞌuꞌl u Pilato uvaꞌ taꞌn kuxh chꞌoꞌnchil aama nikat toksakat unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh u Jesús tiqꞌabꞌ naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","As unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh tukꞌ kaꞌt unqꞌa bꞌaal tenameꞌ, as toksa veꞌt chajnaj tiviꞌ unqꞌa tenameꞌ tiꞌ uvaꞌ aꞌ u Barrabás la chajpuli. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","As ech tal veꞌt u Pilato ileꞌ: —¿As kam nesaꞌ qꞌi uvaꞌ la unbꞌan tiꞌ vetijlenaaleꞌ uveꞌ netaleꞌ?— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","As taqꞌ veꞌt jeꞌ unqꞌa tenameꞌ tuul iviꞌ. Ech tal ileꞌ: —¡Yatzꞌpoj naj vatz u kuruseꞌ!— tiꞌk unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—¿As kam ipaav u najeꞌ qꞌi kat ibꞌana?— tiꞌk u Pilato. As aal chit taqꞌ jeꞌ unqꞌa tenameꞌ tuul iviꞌ. As ech tal veꞌt ileꞌ: —¡Yatzꞌpoj naj vatz u kuruseꞌ!— tiꞌk unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","As ichajpu veꞌt el tzan naj u Barrabás. As tal veꞌt naj iqꞌospu u Jesús taꞌn tzꞌuꞌm. As toksa veꞌt naj Aak tiqꞌabꞌ unqꞌa soleꞌ tiꞌ uvaꞌ la bꞌen yatzꞌpoj Aak vatz u kuruseꞌ. Tan aꞌ nital u Pilato uvaꞌ bꞌaꞌn ikaa naj vatz u tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","As teqꞌo veꞌt ok unqꞌa soleꞌ u Jesús vatz iqꞌanal vikabꞌal u bꞌanol ivatz u ijlenaaleꞌ. As imol veꞌt unqꞌa soleꞌ unqꞌa imooleꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","As toksa veꞌt unqꞌa soleꞌ umaꞌl u muraꞌt oksaꞌm tiꞌ u Jesús. As taqꞌ veꞌt jeꞌ chajnaj umaꞌl u koroona chꞌiꞌx tiꞌ iviꞌ Aak uvaꞌ paatxꞌumalike. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","As ech tal chajnaj ileꞌ te Aak: —¡Keche, pap, axh tijlenaal unqꞌa tiaal Israel!— tiꞌk chajnaj tiꞌ teesal iqꞌii Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","As ivekꞌ chajnaj umaꞌl u aa tiꞌ iviꞌ Aak. As itzubꞌa veꞌt chajnaj Aak. As qaaebꞌ veꞌt chajnaj vatz Aak tiꞌ itzeꞌlel Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","As tul maꞌtik teesat chajnaj iqꞌii Aak, as teesa veꞌt el chajnaj u muraꞌt oksaꞌmeꞌ tiꞌ Aak. As toksa veꞌt chajnaj u toksaꞌm Aakeꞌ unpajte. As teqꞌo veꞌt el chajnaj Aak tiꞌ iyatzꞌpu veꞌt Aak vatz u kuruseꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","As tul bꞌex paloj umaꞌl u aa Cirene uvaꞌ aalik itzaa tu vitz, as itxey veꞌt unqꞌa soleꞌ naj tiꞌ uvaꞌ la tija naj u kuruseꞌ. As Simón ibꞌii u najeꞌ. As naj ibꞌaal u Alejandro tukꞌ u Rufo. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","As teqꞌo veꞌt unqꞌa soleꞌ u Jesús tu u atinbꞌal uvaꞌ Gólgota ibꞌii. (As aꞌ isuuchil u yoleꞌ uvaꞌ Gólgota: Tatinbꞌal Bꞌajil Kꞌoꞌn.) ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","As taqꞌ veꞌt chajnaj unbꞌiil u taꞌl uuva te Aak uvaꞌ yuel tibꞌ tukꞌ kꞌayla tzꞌakabꞌal uvaꞌ mirra ibꞌii. As jit isaꞌ Aak tukꞌataꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","As tul maꞌt taqꞌat veꞌt jeꞌ unqꞌa soleꞌ u Jesús vatz u kuruseꞌ, as ijatx veꞌt chajnaj u toksaꞌm Aakeꞌ svatzaj. As itxꞌak veꞌt tibꞌ chajnaj tiꞌ u toksaꞌm Aakeꞌ tiꞌ uvaꞌ abꞌiste u najeꞌ la eqꞌon u toksaꞌm Aakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","As bꞌeluval oora qꞌalaꞌm tul uvaꞌ taqꞌ veꞌt jeꞌ unqꞌa soleꞌ u Jesús vatz u kuruseꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","As atik veꞌt jeꞌ umaꞌl u aqꞌen tiviꞌ u kuruseꞌ uvaꞌ tzꞌibꞌamalikkat uvaꞌ kam stiꞌ la kamkat Aak. As ech nik tal u tzꞌibꞌ ileꞌ: Aꞌ U TIJLENAAL UNQꞌA TIAAL ISRAEL, tiꞌk u tzꞌibꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","As antik kaꞌvaꞌt unqꞌa elqꞌom taqꞌ jeꞌ chajnaj vatz kaꞌvaꞌt unqꞌa kuruseꞌ. Umaꞌl naj jeꞌ tisebꞌal u Jesús; as umaꞌt naj timax Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","As aꞌeꞌ kat ibꞌana uvaꞌ tzꞌibꞌamal kan uvaꞌ ech ni tal ileꞌ: As kat oksal veꞌt xoꞌl tachul unqꞌa paasan tziꞌeꞌ, tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","As tul uvaꞌ nik ipal unqꞌa uxhchileꞌ, as nik iyiku iviꞌ tul nikat iyoqꞌon tiꞌ u Jesús. As ech nik tal ileꞌ te Aak: —Nikat aaleꞌ uvaꞌ la eꞌpisa u tostiixheꞌ. As titoxvu qꞌii la alak unpajte, uvaꞌ naaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","As qꞌalpu eebꞌ vatz u kamchileꞌ scheel. As kuꞌen chꞌuꞌl vatz u kuruseꞌ,— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","As echat chit nik ibꞌan unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh, tukꞌ unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, tan ech nik tal chajnaj ileꞌ svatzaj tul nikat iyoqꞌon tiꞌ u Jesús: —Kꞌuxh kat iqꞌalpu naj unqꞌa uxhchileꞌ vatz unqꞌa chꞌoꞌmeꞌ, as yeꞌ nitxꞌol veꞌt naj iqꞌalput tibꞌ vatz u kuruseꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Asoj naj u Cristo, u tijlenaal u kutenameꞌ uvaꞌ tiaal Israel, as kuꞌoj chꞌuꞌl naj vatz u kuruseꞌ. As tul la qil ikuꞌ chꞌuꞌl naj, as aꞌn la kunima veꞌt naj,— tiꞌk chajnaj. As echat nik ibꞌan unqꞌa najeꞌ uveꞌ atik jeꞌ vatz unqꞌa kuruseꞌ kꞌatz u Jesús, tan nik teesa chajnaj iqꞌii Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","As tul chaqꞌaan veꞌt qꞌii, as tokin veꞌt ivatz u txꞌavaꞌeꞌ. As techanal oon veꞌt oxvaꞌl oora kuꞌqꞌii, as aꞌn ilon veꞌt u qꞌiieꞌ unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","As tul oon veꞌt oxvaꞌl oora kuꞌqꞌii, as taqꞌ veꞌt jeꞌ u Jesús tuul iviꞌ. As ech tal veꞌt Aak ileꞌ: —¿Eloi, Eloi, lama sabactani?— tiꞌk Aak. Aꞌ isuuchil u yoleꞌ uvaꞌ: «¡Kubꞌaal Tiixh, Kubꞌaal Tiixh! ¿Kam qꞌi uveꞌ nu kuxh aaqꞌ kan in sunjunal?» tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","As kaꞌl unqꞌa uxhchil uvaꞌ atik tzitziꞌ, as tul tabꞌi u yoleꞌ uvaꞌ tal u Jesús, as ech tal veꞌt ileꞌ svatzaj: —¡Etabꞌitaj! Tan nimolo veꞌt naj u Elías,— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","As oora chit bꞌex umaꞌl u naj tiꞌ takꞌsat umaꞌl u patxkin kꞌoo taꞌn kꞌayla taꞌl uuva. As ikꞌaloꞌk naj tiꞌ ijuꞌ umaꞌl u aa. As taqꞌ veꞌt jeꞌ naj te u Jesús. As ech tal veꞌt naj ileꞌ: —¡Qeꞌna! ¡Qil kuxhtuꞌ! Pet tuk qileꞌ ma tuk uloj u Elías tiꞌ teqꞌol kuꞌ tzan naj vatz u kuruseꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","As aal chit taqꞌ veꞌt jeꞌ u Jesús tuul iviꞌ tiꞌ isikꞌineꞌ. As kam veꞌt Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","As qꞌixmu veꞌt u nimla ixbꞌuꞌjeꞌ uveꞌ nik jatxon tuul u tostiixheꞌ. As kaꞌvaꞌl kuꞌ u ixbꞌuꞌjeꞌ stuul, tan kat qꞌixmik kuꞌ tzan tiviꞌ as kat ul xeꞌ toj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","As viqꞌesal unqꞌa soleꞌ uvaꞌ txaklik kꞌatz u kuruseꞌ, as tul tabꞌi naj isikꞌin u Jesús as til naj uvaꞌ kam ibꞌan Aak tul kat kam Aak, as ech tal veꞌt naj ileꞌ: —An chiteꞌ vil. IKꞌaol Tiixheꞌ vil u najeꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","As atik kaꞌl unqꞌa ixoj tzitziꞌ uvaꞌ tziꞌaꞌn kuxh nikat isajinkat veꞌt tzan tul uvaꞌ sikam veꞌt u Jesús. As antik u Maꞌleꞌ uvaꞌ tzaanaj tu u tenam uvaꞌ Magdala, tukꞌ umaꞌt u Maꞌleꞌ, vitxutx u Xhuꞌleꞌ tukꞌ u Jacob uvaꞌ itzꞌina, as tukꞌ u Salomé. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","As aꞌ unqꞌa ixojeꞌ uvaꞌ xekelik veꞌt tiꞌ u Jesús uvaꞌ nik lochon kꞌatz Aak tul atik Aak tu u Galilea. As antik unjoltu unqꞌa ixoj uvaꞌ xekelik tiꞌ Aak tul kat bꞌen Aak tu u Jerusalén. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","As nik ibꞌan unqꞌa tenameꞌ tucheꞌ tiꞌ inimat u xeem qꞌiieꞌ, tan aalik ikuꞌ veꞌt qꞌii as bꞌiitik kuxh ixeꞌt veꞌt u xeem qꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","As estiꞌeꞌ bꞌex veꞌt umaꞌl u naj uvaꞌ Xhuꞌl ibꞌii, u aa Arimatea uvaꞌ atik ok xoꞌl unqꞌa bꞌanol isuuchil unqꞌa tenameꞌ, tiꞌ ijajat vichiꞌol u Jesús te u Pilato. As nik itxꞌebꞌ naj u qꞌiieꞌ tiꞌ ikꞌuchat u Tiixheꞌ uvaꞌ at u tenameꞌ jaqꞌ u tijleꞌm u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Tul tabꞌi veꞌt u Pilato uvaꞌ maꞌtik ikam veꞌt u Jesús, as teqꞌo veꞌt taama naj. As imolo veꞌt naj viqꞌesal unqꞌa soleꞌ. As ichꞌoti naj uvaꞌ ma kat chit kamyu veꞌt u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","As tul tal veꞌt viqꞌesal unqꞌa soleꞌ isuuchil uvaꞌ kat kamyu Aak, as tal veꞌt u Pilato uvaꞌ la uch veꞌt teqꞌot u Xhuꞌleꞌ vichiꞌol Aakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","As bꞌex iloqꞌ veꞌt u Xhuꞌleꞌ umaꞌl u saj maanta. As teqꞌo veꞌt kuꞌ tzan naj vichiꞌol u Jesús vatz u kuruseꞌ. As ibꞌoch veꞌt naj tu u ixbꞌuꞌjeꞌ. As bꞌex imuj veꞌt kan naj tu umaꞌl u jul uvaꞌ kꞌotik ok vatz umaꞌl u piꞌun. As ibꞌalqꞌu veꞌt ok naj umaꞌl u sivan tziꞌ u juleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","As u Maꞌleꞌ uvaꞌ tzaanaj tu u tenam uvaꞌ Magdala tukꞌ u Maꞌl uvaꞌ itxutx umaꞌt u Xhuꞌleꞌ, as til veꞌt chaꞌma katil uvaꞌ mujlukat u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tul maꞌtik ipal u xeem qꞌiieꞌ, as bꞌex iloqꞌ veꞌt u Maꞌleꞌ uvaꞌ aa Magdala txꞌumtxꞌulla tzꞌakabꞌal, tukꞌ u Salomé, as tukꞌ u Maꞌleꞌ uvaꞌ itxutx u Jacob, tan nikat tal chaꞌma uvaꞌ la bꞌen toksa chaꞌma u tzꞌakabꞌaleꞌ tiꞌ vichiꞌol u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","As tul kuxh bꞌuqꞌ qꞌii tu u bꞌaxa qꞌiieꞌ tu xhemaana, as bꞌen veꞌt unqꞌa ixojeꞌ kꞌatz u juleꞌ uvaꞌ mujlukat u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","As ech nik tal veꞌt chaꞌma ileꞌ svatzaj tu bꞌey: —¿Abꞌileꞌ qꞌi tuk eesan el u sivaneꞌ tziꞌ u juleꞌ sukuvatz?— tiꞌk chaꞌma. ");
INSERT INTO ixlNNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","As tul bꞌiitik kuxh toon chaꞌma, as til veꞌt bꞌen chaꞌma uvaꞌ eesamalik veꞌt el u nimla sivaneꞌ tziꞌ u juleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","As oon veꞌt chaꞌma. As tul ok veꞌt chaꞌma tu u juleꞌ, as til veꞌt chaꞌma uvaꞌ xonlik umaꞌl u ángel tisebꞌal chaꞌma uvaꞌ ech tiloneꞌ echeꞌ umaj chelem naj. As atik ok umaꞌl u chelkin oksaꞌm stiꞌ uvaꞌ vaꞌlik chit ipolal. As yak chit xoꞌv veꞌt chaꞌma staꞌn. ");
INSERT INTO ixlNNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","As ech tal veꞌt u ángel ileꞌ te chaꞌma: —Yeꞌ kuxh xoꞌv ex. Ootzimaleꞌ svaꞌn uvaꞌ aꞌ u Jesús nechukeꞌ uvaꞌ aa Nazaret uvaꞌ kat yatzꞌpu vatz u kuruseꞌ. As kat ulyu taama unpajte. As etiltaj uveꞌ kat mujlukat, tan yeꞌxhkam at veꞌt tzitzaꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","As bꞌenoj ex; bꞌen etaltaj te unqꞌa ichusulibꞌ Aakeꞌ as tukꞌ te u Luꞌeꞌ, tan il Aak bꞌaxel veꞌt sevatz tu u Galilea. As tzitziꞌ la etilkat Aak, echeꞌ uvaꞌ tal kan Aak sete,— tiꞌk u ángel tal te unqꞌa ixojeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","As vaꞌlik chit itꞌuntꞌuch veꞌt chaꞌma. As oojik veꞌt el tzan chaꞌma tu u juleꞌ. As yeꞌxhebꞌil tal chaꞌma ste tu bꞌey, tan nik ixoꞌv veꞌt chaꞌma. ");
INSERT INTO ixlNNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tul maꞌtik tul veꞌt taama u Jesús sqꞌalaꞌm tu u bꞌaxa qꞌiieꞌ tu u xhemaanaeꞌ, as bꞌaxel ikꞌuch veꞌt tibꞌ Aak vatz u Maꞌleꞌ uvaꞌ aa Magdala, uvaꞌ maꞌtik teesat Aak vujvaꞌl u subꞌuleꞌ skꞌatz. ");
INSERT INTO ixlNNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","As bꞌen veꞌt ixoj. Bꞌex tal veꞌt ixoj te kaꞌt unqꞌa ichusulibꞌ Aakeꞌ uvaꞌ naꞌxnik ixekebꞌ tiꞌ Aak, tan vaꞌlik chit toqꞌeꞌ taꞌn txumuꞌm. ");
INSERT INTO ixlNNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","As tul tabꞌi veꞌt unqꞌa ichusulibꞌ Aakeꞌ u yoleꞌ uvaꞌ tal u Maꞌleꞌ tiꞌ uvaꞌ maꞌtik tilat veꞌt ixoj Aak, tan maꞌtik tul taama Aak unpajte, as yeꞌ nik inima veꞌt unqꞌa ichusulibꞌ Aakeꞌ u yoleꞌ uvaꞌ nik tal ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","As xamtik veꞌt stuul, as ikꞌuch veꞌt tibꞌ Aak te kaꞌvaꞌt uxhchil uvaꞌ nik ixaan tu bꞌey tiꞌ ibꞌen tu vitz. As jit texhla chajnaj Aak oora. ");
INSERT INTO ixlNNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","As tul texhla veꞌt chajnaj Aak, as bꞌex tal veꞌt chajnaj te unqꞌa imooleꞌ. As yeꞌ nik inima unqꞌa imool chajnajeꞌ u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","As xamtel veꞌt stuul, as ikꞌuch veꞌt tibꞌ Aak te junlavat unqꞌa apóstol tul uvaꞌ atik veꞌt ok chajnaj vatz u meexhaeꞌ. As iyaa veꞌt Aak chajnaj tiꞌ uvaꞌ yeꞌ nik ikꞌujbꞌaꞌ chajnaj ikꞌuꞌl tiꞌ Aak, tan tiꞌ uvaꞌ chajnaj chit yeꞌ nik niman viyol unqꞌa uxhchileꞌ uveꞌ kat ilon Aak uvaꞌ maꞌtik tul taama Aak unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","As ech tal veꞌt Aak ileꞌ: —Bꞌenoj ex. Bꞌen etaltaj u bꞌaꞌnla yoleꞌ te unqꞌa tenameꞌ skajayil uvaꞌ at vatz u txꞌavaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","As abꞌil uvaꞌ la niman unqꞌa unyoleꞌ uvaꞌ la bꞌen etal ste as la kuꞌ veꞌt xeꞌ u aꞌeꞌ, as aꞌeꞌ yeꞌ la bꞌen tu u kꞌaxkꞌoeꞌ. Pet abꞌil uvaꞌ yeꞌ la niman, as aꞌeꞌ la bꞌen tu u kꞌaxkꞌoeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","As aꞌ unqꞌa kꞌuchbꞌal tetz vunbꞌaꞌnileꞌ u viꞌlaꞌ uvaꞌ la bꞌen ibꞌan unqꞌa uxhchileꞌ uveꞌ la niman vunyoleꞌ: As tukꞌ vunbꞌiieꞌ la teesa veꞌt el unqꞌa subꞌuleꞌ tiꞌ unqꞌa uxhchileꞌ uvaꞌ atoꞌk u subꞌuleꞌ skꞌatz. As la iyolbꞌe veꞌt unqꞌa niman vetzeꞌ kaꞌt unqꞌa yolbꞌaleꞌ uvaꞌ yeꞌ ootzimal staꞌn. ");
INSERT INTO ixlNNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","As kꞌuxh la itxey unqꞌa uxhchileꞌ unqꞌa txꞌiꞌlatxooeꞌ taꞌn iqꞌabꞌ, as moj la tukꞌa umaj tzꞌakabꞌal uvaꞌ la yatzꞌoni, as yeꞌxhkam la bꞌanon. As tul la taqꞌ jeꞌ unqꞌa uxhchileꞌ iqꞌabꞌ tiꞌ unqꞌa aachꞌoꞌmeꞌ, as la bꞌaꞌnxeꞌ unqꞌa aachꞌoꞌmeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","As tul yaꞌ veꞌt u Jesús tiꞌ iyoloneꞌ, as eqꞌol veꞌt jeꞌ Aak tu almikaꞌ. As xonebꞌ veꞌt Aak tisebꞌal u Kubꞌaal Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","As ijatx veꞌt tibꞌ unqꞌa ichusulibꞌ Aakeꞌ. As bꞌex tal veꞌt chajnaj u bꞌaꞌnla yoleꞌ tulaj unqꞌa tenameꞌ. As iloch veꞌt kuꞌ tzan u Jesús chajnaj. As iyakꞌinsa veꞌt Aak u yoleꞌ tukꞌ unqꞌa kꞌuchbꞌal tetz vibꞌaꞌnileꞌ uveꞌ xoꞌvebꞌal chittuꞌ uvaꞌ bꞌex ibꞌan chajnaj. An chiteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nimal unqꞌa uxhchileꞌ uvaꞌ jik chit kat itzꞌibꞌa kan tiꞌ talax isuuchil unqꞌa veeꞌ kat uch sukuxoꞌl ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","echeꞌ uvaꞌ kat chuspu sqe taꞌn unqꞌa qitzꞌin qatzikeꞌ uvaꞌ kat ilon kam uvaꞌ kat uchi tixeꞌtebꞌal unqꞌa yoleꞌ, tan an chit chajaakeꞌ uvaꞌ kat kꞌujebꞌ kan tiꞌ ipaxsal unqꞌa yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","As bꞌaꞌn veꞌt sve uvaꞌ jik chit nuntzꞌibꞌa bꞌen unqꞌa yoleꞌ see, pap Teófilo, tan kat unchꞌoti veꞌt sbꞌaꞌn kam chit uvaꞌ kat uchi tixeꞌtebꞌal ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","aqꞌal uvaꞌ la ootzi uvaꞌ jik chit u yoleꞌ uvaꞌ kat chuspik kan see. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tul atik veꞌt ok u Herodes ijlenaalil tu u Judea, as atik umaꞌl oksan iyol tenam vatz Tiixh uvaꞌ Zacarías uvaꞌ tiaal u Abías. As Elisabet u tixqeleꞌ. As aꞌ tzaanalkat u tixqeleꞌ xoꞌl unqꞌa tiaal u Aarón. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Jik chit itxumbꞌal chaꞌma skaabꞌil vatz u Tiixheꞌ, tan nikat inima chaꞌma viyol u Tiixheꞌ. As jik chit nik inima veꞌt chaꞌma u tzaqꞌiteꞌ uvaꞌ tzꞌibꞌamal kan uvaꞌ alik kan taꞌn Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","As yeꞌlik chit meꞌal ikꞌaol chaꞌma, tan yeꞌl u Elisabet nik talaneꞌ. As qꞌestik chit veꞌt chaꞌma skaabꞌil. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","As bꞌex ilej veꞌt umaꞌl u qꞌii tul uvaꞌ aꞌik u Zacarías tukꞌ kaꞌt unqꞌa imooleꞌ atik ok tixhemaana tiꞌ tilat isuuchil u tostiixheꞌ tu u Jerusalén. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","As kat ikꞌulvatzi u Zacarías uvaꞌ aꞌeꞌ la ok tu u tostiixheꞌ tiꞌ itzꞌeꞌsal u incienso tu u nachbꞌal Tiixheꞌ, tan echeꞌ nik ibꞌan umaꞌl oksan iyol tenam vatz Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","As molik tibꞌ unqꞌa tenameꞌ vatz iqꞌanal u tostiixheꞌ. As tul nikat itzꞌeꞌsa u Zacarías u incienso, as tul nikat inach unqꞌa tenameꞌ Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","As tul atik u Zacarías vatz u atinbꞌaleꞌ uveꞌ nik itzꞌeꞌsalkat u incienso, as ul veꞌt umaꞌl u ángel txakebꞌoj tisebꞌal u meexhaeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","As yak kuxh xoꞌv veꞌt u Zacarías. Yeꞌ nikat ichee veꞌt tiviꞌ tiꞌ uvaꞌ kam la ibꞌan veꞌt vatz u ángel. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","As ech tal veꞌt u ángel ileꞌ: —Zacarías, yeꞌ xoꞌv axh, tan kat tabꞌil veꞌt u Tiixheꞌ u nachbꞌal Tiixheꞌ uveꞌ nabꞌaneꞌ, tan la itzꞌebꞌ veꞌt umaꞌl vineꞌ u eexqeleꞌ, u Elisabet. As tul la itzꞌebꞌ u neꞌeꞌ, as Xhun ibꞌii la abꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","As la txuqꞌtxun veꞌt axh taꞌn chiibꞌichil. As nimal unqꞌa uxhchileꞌ la txuqꞌtxun veꞌt stiꞌ tul uvaꞌ la itzꞌebꞌi, ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","tan nim talchu vakꞌaoleꞌ la ibꞌan vatz u Tiixheꞌ. As yeꞌl u vino la tukꞌa. As mitaꞌn umaꞌtoj aꞌ uvaꞌ qꞌuꞌimal setaꞌn. As kꞌuxh yeꞌxnaj itzꞌebꞌi, as aꞌ u Tiixhla Espíritu la aqꞌon itxumbꞌal tiꞌ ibꞌanataꞌ kam uvaꞌ la tal u Tiixheꞌ ste. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","As aꞌeꞌ la bꞌanon uvaꞌ nimal unqꞌa tiaal Israel la ikꞌaxa veꞌt tibꞌ tiꞌ inimat u Kubꞌaal Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","As bꞌaxel la ul veꞌt vatz Aak. As eela u tijleꞌmeꞌ tukꞌ u Elías la ibꞌaneꞌ uvaꞌ xoꞌvebꞌalik chit u tijleꞌmeꞌ, tan tiꞌ u yoleꞌ uveꞌ la ul taleꞌ as la ijikbꞌaꞌ veꞌt unqꞌa bꞌaalaeꞌ vitxumbꞌaleꞌ tiꞌ uvaꞌ la ixoꞌni veꞌt unqꞌa meꞌal ikꞌaoleꞌ. As la ijikbꞌaꞌ veꞌt unqꞌa paasan tziieꞌ vitxumbꞌaleꞌ tiꞌ inimat vitxumbꞌal unqꞌa jikla aamaeꞌ. As ech la ibꞌan unqꞌa tenameꞌ tiꞌ ikꞌulat veꞌt Aak,— tiꞌk u ángel. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","As ech tal veꞌt u Zacarías ileꞌ te u ángel: —¿Kam la vulbꞌe vootzit qꞌi uvaꞌ asoj an chit vayoleꞌ uveꞌ naaleꞌ? Tan qꞌestu veꞌt in tukꞌ u vixqeleꞌ,— tiꞌk u Zacarías. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ech tal veꞌt u ángel ileꞌ: —Ineꞌ in Karaꞌp. As in ichaj u Tiixheꞌ. As Aakeꞌ kat chajon tzan in tiꞌ ul valat u bꞌaꞌnla yoleꞌ see. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","As tiꞌ uvaꞌ yeꞌ kat anima veꞌt uvaꞌ kat val see, as cheel tuk kaaoj veꞌt axh smemil. As yeꞌl axh la yolon veꞌt axh. Pet lanal itzꞌebꞌ veꞌt vakꞌaoleꞌ uveꞌ ni val see, as aꞌn la yolon veꞌt axh unpajte,— tiꞌk u ángel. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","As tul uvaꞌ atik ok u Zacarías tu u Tiixhla atinbꞌaleꞌ, as mamaꞌla tenameꞌ nikat itxꞌebꞌon kan vatz u qꞌanaleꞌ. As nikat kuxh isotz ikꞌuꞌl unqꞌa tenameꞌ, tan yeꞌsebꞌ chit el chꞌuꞌl u Zacarías tu u Tiixhla atinbꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","As tul el veꞌt chꞌuꞌl u Zacarías, as maꞌtik imemtu veꞌteꞌ. As nikat kuxh ikꞌuchun veꞌt tukꞌ iqꞌabꞌ. As kat pal veꞌt unqꞌa tenameꞌ stuul uvaꞌ at umaj kam uvaꞌ kat ikꞌuch u Tiixheꞌ ste. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","As tul tzꞌaj veꞌt iqꞌii u Zacarías tiꞌ tilat isuuchil u aqꞌoneꞌ tu tostiixheꞌ, as bꞌen veꞌt tikabꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","As tul atik veꞌt u Zacarías tikabꞌal, as jeꞌ veꞌt ventasioon tiꞌ u Elisabet. As oꞌvaꞌl ichꞌ uvaꞌ kolik kuxh tibꞌ u Elisabet tu kabꞌal. As ech nikat tal veꞌt jeꞌ ileꞌ ste: ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«As kat ibꞌanlu veꞌt u Kubꞌaaleꞌ bꞌaꞌnil sve. Taꞌntiixh te Aak, tan aꞌ isaꞌ Aak uvaꞌ yeꞌ la yoqꞌax veꞌt in taꞌn unqꞌa tenameꞌ tiꞌ uvaꞌ yeꞌl vas val ati,» tiꞌk u Elisabet. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","As tul ibꞌan vaajil ichꞌ ijeꞌ ventasioon tiꞌ u Elisabet, as ichaj veꞌt u Tiixheꞌ u ángel uvaꞌ Karaꞌp tu umaꞌl u tal tenam tu u Galilea uvaꞌ Nazaret ibꞌii ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","xeꞌ umaꞌl u qꞌopo ixoj uvaꞌ Maꞌl ibꞌii uvaꞌ kꞌujlik veꞌt tzii stiꞌ tukꞌ umaꞌl u naj uvaꞌ Xhuꞌl uvaꞌ tiaal tibꞌ tukꞌ u David. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","As tul oon veꞌt u ángel tu u kabꞌaleꞌ uveꞌ atikkat u Maꞌleꞌ, as ech tal veꞌt ileꞌ: —¡Keche, Maꞌl! Tan at u Tiixheꞌ seeꞌ. As nim veꞌt u bꞌaꞌnileꞌ uvaꞌ tuk ibꞌan u Tiixheꞌ see tiꞌ uveꞌ nibꞌan Aak te unjoltu unqꞌa ixojeꞌ,— tiꞌk u ángel. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","As tul tabꞌi u Maꞌleꞌ viyol u ángel, as yak chit sotz veꞌt ikꞌuꞌl taꞌn u yoleꞌ uveꞌ tal u ángel. As ech tal veꞌt jeꞌ ileꞌ ste: «¿Kam isuuchil u yoleꞌ qꞌi uveꞌ ni talpu sve?» tiꞌk u Maꞌleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","As ech tal veꞌt u ángel ileꞌ: —¡Yeꞌ xoꞌv axh, Maꞌl! Tan bꞌaꞌn veꞌt atxumbꞌal vatz u Tiixheꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","tan tuk jeꞌoj ventasioon seeꞌ. As la itzꞌebꞌ veꞌt umaꞌl vaneꞌ. As tul la itzꞌebꞌi, as Jesús ibꞌii la abꞌaneꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","tan nim talchu u neꞌeꞌ la ibꞌaneꞌ. As iKꞌaol u Tiixheꞌ tu almikaꞌ u neꞌeꞌ, tan aꞌ u Kubꞌaal Tiixheꞌ, u kuBꞌooqꞌoleꞌ, la oksan veꞌt u tijleꞌmeꞌ echeꞌ uvaꞌ kat tulbꞌe Aak u qꞌesla ebꞌaaleꞌ uvaꞌ David. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","As la ok veꞌt ijlenaalil tiꞌ unqꞌa tiaal Israel. As yeꞌxh jatu la el veꞌt tiꞌ u ijlenaalileꞌ, tan yeꞌl iyaꞌtebꞌal u tijleꞌmeꞌ la ibꞌaneꞌ,— tiꞌk u ángel tal te u Maꞌleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","As ech tal veꞌt u Maꞌl ileꞌ te u ángel: —¿Kam isuuchil u yoleꞌ uveꞌ naal sve? Tan yeꞌl untzumel ati,— tiꞌk u Maꞌleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ech tal veꞌt u ángel ileꞌ: —As aꞌ u Tiixhla Espíritu tuk uloj seeꞌ. As aꞌ vibꞌaꞌnil u Tiixheꞌ tu almikaꞌ tuk uloj seeꞌ tiꞌ uvaꞌ la itzꞌebꞌ umaꞌl vaneꞌ. Estiꞌeꞌ ni val see tiꞌ u neꞌeꞌ uveꞌ la itzꞌebꞌi, tan Tiixhla Aamaeꞌ, iKꞌaol u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","As echat kat ibꞌanlu veꞌt vananeꞌ uvaꞌ aatin eebꞌ stukꞌ, u Elisabet, tan kꞌuxh qꞌestu veꞌteꞌ, as la itzꞌebꞌ veꞌt umaꞌl vineꞌ. As kꞌuxh ni talchu stiꞌ uvaꞌ yeꞌxh jatu la alani, as cheel kat ibꞌanlu vaajix ichꞌ ijeꞌ ventasioon stiꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","tan yeꞌl umaj kam uvaꞌ yeꞌ koj la itxꞌol u Tiixheꞌ ibꞌanataꞌ,— tiꞌk u ángel. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","As ech tal veꞌt u Maꞌl ileꞌ: —Il in ilaꞌ. As ineꞌ in ikꞌam u Tiixheꞌ. As la ibꞌan Aak sviꞌ kam uveꞌ naaleꞌ,— tiꞌk u Maꞌleꞌ. As bꞌen veꞌt u ángel. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","As an kuxh tu unqꞌa qꞌiieꞌ, as ibꞌan veꞌt u Maꞌleꞌ tucheꞌ. As yeꞌntu chit ibꞌen u Maꞌleꞌ tu umaꞌl u tal tenam uvaꞌ echen xoꞌl unqꞌa vitzeꞌ tu u Judea, tiꞌ bꞌen iqꞌelut u Elisabet. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tul oon veꞌt u Maꞌleꞌ tu vikabꞌal u Zacarías, as itiixhi veꞌt u Maꞌleꞌ u Elisabet. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","As tul kuxh tabꞌi u Elisabet itiixhil taꞌn u Maꞌleꞌ, as yak kuxh iyiku veꞌt tibꞌ u tal neꞌeꞌ kꞌatz u Elisabet. As taqꞌ veꞌt u Tiixhla Espíritu itxumbꞌal u Elisabet tiꞌ iyoloneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","As ech tal veꞌt u Elisabet ileꞌ tul taqꞌ jeꞌ u tuul iviꞌ: —As nim veꞌt u bꞌaꞌnileꞌ uvaꞌ tuk ibꞌan u Tiixheꞌ see tiꞌ uveꞌ nibꞌan Aak te unjoltu unqꞌa ixojeꞌ. As nimal bꞌaꞌnil la ibꞌan u Tiixheꞌ te u neꞌeꞌ uvaꞌ la itzꞌebꞌi. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿As kam veꞌt vijleꞌm qꞌi uvaꞌ tul eel veꞌt in? Tul axh vitxutx vunBꞌooqꞌoleꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","tan tul kuxh uvaꞌ kat atiixhi in, as yak kuxh kat iyiku veꞌt tibꞌ u neꞌeꞌ sunkꞌatz taꞌn chiibꞌichil. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","As achvebꞌal chit axh, tan kat akꞌujbꞌaꞌ akꞌuꞌl tiꞌ u Tiixheꞌ, tan tuk tzojpisaloj unqꞌa yoleꞌ uvaꞌ kat alpu see taꞌn u Tiixheꞌ,— tiꞌk u Elisabet. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","As ech tal veꞌt u Maꞌl ileꞌ te u Elisabet: —Vaꞌl chit ichiibꞌ u vaanxelaleꞌ tiꞌ toksal iqꞌii u Kubꞌaal Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","As vaꞌl chit itxuqꞌtxun veꞌt vaama tiꞌ u Tiixheꞌ, u sotzsan tetz vunpaaveꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","tan kꞌuxh jit nim valcheꞌ xoꞌl unqꞌa tenameꞌ, as nimal bꞌaꞌnil kat ikꞌuch u Tiixheꞌ sve, tan in ikꞌam Aak. As la tal veꞌt unqꞌa tenameꞌ skajayil uvaꞌ achvebꞌal u bꞌaꞌnileꞌ uvaꞌ kat ibꞌan Aak sve, ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","tan xoꞌvebꞌal chit vibꞌaꞌnil Aakeꞌ uveꞌ kat ibꞌanlu sve. As xoꞌvebꞌal chit viyakꞌil Aakeꞌ. As Tiixhla bꞌiieꞌ vibꞌii Aakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","As nichit itxum u Tiixheꞌ ivatz unqꞌa tenameꞌ uveꞌ kat ibꞌanlu kan. As echat nibꞌan cheel tiꞌ chit ibꞌeneꞌ tiꞌ unqꞌa tenameꞌ uveꞌ ni xoꞌvan Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","As mamaꞌla bꞌaꞌnil nibꞌan Aak tukꞌ viyakꞌileꞌ. As jankꞌal unqꞌa uxhchileꞌ uveꞌ nijeꞌsa tibꞌ, as kat teesa veꞌt Aak iqꞌii. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","As at unqꞌa ijlenaaleꞌ kat teesa Aak tiꞌ u tijleꞌmeꞌ. As kat toksa veꞌt Aak iqꞌii unqꞌa uxhchileꞌ uveꞌ yeꞌ ni toksal iqꞌii taꞌn unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kat inoosa veꞌt Aak unqꞌa uxhchileꞌ uveꞌ nivaꞌyeꞌ. As kat taqꞌ veꞌt kan Aak unqꞌa txꞌioliqꞌiieꞌ vatz vaꞌy. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","As kat iloch veꞌt Aak unqꞌa mam kukuyeꞌ uvaꞌ tiaal Israel. As yeꞌ kat sotz skꞌuꞌl Aak tiꞌ itxumat kuvatz, ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","tan echeꞌ uveꞌ alel kan taꞌn Aak te u qꞌesla kubꞌaaleꞌ uvaꞌ Abraham, tukꞌ te unqꞌa tiaaleꞌ skajayil,— tiꞌk u Maꞌleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","As kamal oxvaꞌl ichꞌ ibꞌan u Maꞌleꞌ xeꞌ u Elisabet. As qꞌaav veꞌt u Maꞌleꞌ tikabꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","As tul ilej veꞌt iqꞌii u Elisabet tiꞌ talaneꞌ, as itzꞌebꞌ veꞌt vineꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","As tul tabꞌi veꞌt unqꞌa titzꞌin tatzikeꞌ tukꞌ unqꞌa uxhchileꞌ uveꞌ echen najlich vikabꞌaleꞌ, as vaꞌlik chit ichiibꞌ veꞌt unqꞌa uxhchileꞌ skajayil, tan tiꞌ uvaꞌ nimla bꞌaꞌnil kat ibꞌanlu u Tiixheꞌ te u Elisabet. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","As tul ibꞌan u neꞌeꞌ vaaxil qꞌii, as bꞌex tzokꞌaxoj el unbꞌiil vichiꞌoleꞌ. As tal veꞌt unqꞌa uxhchileꞌ uvaꞌ Zacarías u neꞌeꞌ la ibꞌaneꞌ echeꞌ ibꞌii vibꞌaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","As ech tal veꞌt vitxutx u neꞌeꞌ ileꞌ: —Yeꞌle, tan Xhun ibꞌii u neꞌeꞌ tuk ibꞌaneꞌ,— tiꞌk aak tala. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ech tal veꞌt unqꞌa uxhchil ileꞌ: —¿Kam qꞌi uvaꞌ yeꞌ nasaꞌ uvaꞌ Zacarías u neꞌeꞌ? Tan yeꞌl Xhun xoꞌl unqꞌa etatineꞌ,— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","As tukꞌ kuxh veꞌt kꞌuchuꞌm nik ichꞌoti veꞌt ok unqꞌa uxhchileꞌ te u Zacarías tiꞌ uvaꞌ kam ibꞌii u neꞌeꞌ la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","As ijaj veꞌt u Zacarías umaꞌl u tal aqꞌen. As itzꞌibꞌa veꞌt u Zacarías vibꞌii u neꞌeꞌ vatz aqꞌen. «Xhun ibꞌii u neꞌeꞌ tuk ibꞌaneꞌ,» tiꞌk u tzꞌibꞌeꞌ uveꞌ itzꞌibꞌa. As kat kuxh sotz veꞌt ikꞌuꞌl unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","As tul kuxh itzꞌibꞌa u yoleꞌ, as yak kuxh yolon veꞌt u Zacarías unpajte. As kat toksa veꞌt iqꞌii u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","As teqꞌo veꞌt taama unqꞌa tenameꞌ taꞌn xoꞌvichil. As oora chit ipaxsa veꞌt unqꞌa tenameꞌ itzibꞌlal u yoleꞌ xoꞌl unqꞌa talaj tenameꞌ tu u Judea. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Jankꞌal unqꞌa tenameꞌ uveꞌ abꞌin u yoleꞌ, as ech tal veꞌt jeꞌ ileꞌ ste: «¿As kamal at tijleꞌm u neꞌeꞌ tuk ibꞌaneꞌ?» tiꞌk unqꞌa uxhchileꞌ, tan atik chit vibꞌaꞌnil u Tiixheꞌ tiꞌ u neꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","As u Zacarías, vibꞌaal u neꞌeꞌ, as taqꞌ veꞌt u Tiixhla Espíritu itxumbꞌal tiꞌ talat unqꞌa yoleꞌ tiꞌ u neꞌeꞌ. As ech tal veꞌt ileꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Ni voksa iqꞌii u Kubꞌaal Tiixheꞌ, u Tiixheꞌ uvaꞌ ni qoksa iqꞌii, oꞌ uvaꞌ oꞌ tiaal Israel, tan kat ulyu veꞌt sukuxoꞌl tiꞌ kuqꞌalpuleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","As kat taqꞌlu veꞌt tzan u Tiixheꞌ umaꞌl u qꞌalpun qetz uvaꞌ xoꞌvebꞌal chit u tijleꞌmeꞌ. As aꞌeꞌ tiaal u qꞌesla kubꞌaaleꞌ uvaꞌ David, uvaꞌ atik tijleꞌm taꞌn Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tan echeꞌ uvaꞌ kat tal kan u Tiixheꞌ taꞌn unqꞌa qꞌajsan tetz viyoleꞌ uveꞌ kat ul bꞌaxa uvaꞌ txaaik taꞌn Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ech tal kan ileꞌ: La ul teesa veꞌt oꞌ u qꞌalpun qetzeꞌ vatz unqꞌa chꞌoꞌnchil aamaeꞌ as tukꞌ vatz unqꞌa uxhchileꞌ uveꞌ ni ixvan oꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","as kat itxum veꞌt Aak ivatz unqꞌa qꞌesla kubꞌaaleꞌ tan yeꞌ nisotz skꞌuꞌl Aak tiꞌ u Tiixhla tzaqꞌiteꞌ uvaꞌ tal kan Aak te u qꞌesla kubꞌaaleꞌ uvaꞌ Abraham. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","As yeꞌ nisotz skꞌuꞌl Aak tiꞌ itzojpisat uvaꞌ kat tal kan Aak te u qꞌesla kubꞌaaleꞌ uvaꞌ Abraham tiꞌ uvaꞌ la taqꞌ tzan Aak u qꞌalpun qetzeꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","tiꞌ ul teesat oꞌ Aak vatz unqꞌa chꞌoꞌnchil aamaeꞌ tiꞌ uvaꞌ yeꞌ la xoꞌv veꞌt oꞌ tiꞌ qoksat veꞌt iqꞌii u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","As jik chit u kutxumbꞌaleꞌ la ibꞌan vatz Aak. As jik chit la kunima veꞌt Aak techal la kukamebꞌe. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","As tuk val see, unkꞌaol, tan aꞌ u Tiixheꞌ uvaꞌ at tu almikaꞌ la oksan axh qꞌajsan tetz viyoleꞌ, tan axh tuk bꞌaxoj veꞌt axh vatz u kuBꞌooqꞌoleꞌ tiꞌ ijikbꞌaꞌl itxumbꞌal unqꞌa tenameꞌ ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","as tiꞌ uvaꞌ la qootzi veꞌteꞌ, jankꞌal oꞌ uvaꞌ oꞌ itenam u Tiixheꞌ, uvaꞌ la teesa veꞌt oꞌ Aak vatz unqꞌa kꞌaxkꞌoeꞌ. As la qootzi veꞌteꞌ uvaꞌ la isotzsa veꞌt Aak u kupaaveꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","tan ayaꞌl chit ikꞌul Aak tiꞌ itxumat kuvatz. Estiꞌeꞌ la ul u txijun qetzeꞌ sukuxoꞌl echeꞌ ibꞌuuqꞌ u qꞌiieꞌ vatz u almikaꞌeꞌ. Aꞌeꞌ u Cristo uvaꞌ la ul tu almikaꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","tiꞌ tul itxijut veꞌt Aak unqꞌa uxhchileꞌ uveꞌ echen u taanxelaleꞌ tu u qꞌej toktoeꞌ. As la ul teesa Aak unqꞌa uxhchileꞌ vatz u kamchileꞌ, as la iloch oꞌ Aak tiꞌ uvaꞌ bꞌaꞌn qatineꞌ sukuvatzaj,— tiꞌk u Zacarías. ");
INSERT INTO ixlNNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","As tul nik ichꞌii veꞌt u Xhuneꞌ, as nik iyakꞌin veꞌt itxumbꞌal kꞌatz u Tiixheꞌ. As aꞌ atinkat veꞌteꞌ tu u tzuukin txꞌavaꞌeꞌ. As katnal ilej u qꞌii uvaꞌ la ikꞌuch veꞌt tibꞌ vatz unqꞌa tiaal Israel. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","An chit tu unqꞌa qꞌiieꞌ, as taqꞌeꞌl tzan u Augusto umaꞌl u ley, tan atik ok naj ijlenaalil tu u Roma. As taleꞌl tzan naj uvaꞌ la eqꞌol tachul unqꞌa tenameꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","As aꞌs tel u tachul unqꞌa tenameꞌ bꞌaxa taꞌn u Augusto tul uvaꞌ atik ok u Cirenio bꞌanol ivatz u ijlenaaleꞌ tu u Siria. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","As bꞌen veꞌt unqꞌa uxhchileꞌ skajayil tulaj unqꞌa itenameꞌ uveꞌ itzꞌebꞌnalkat tiꞌ itzꞌibꞌat veꞌt tibꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","As estiꞌeꞌ el veꞌt chꞌuꞌl u Xhuꞌleꞌ tu u tenameꞌ uvaꞌ Nazaret uvaꞌ echen tu u Galilea. As aꞌ bꞌenkat veꞌteꞌ tu u Belén uvaꞌ echen tu u Judea, uvaꞌ itzꞌebꞌnalikkat u David, tan tiaalik tibꞌ u David tukꞌ u Xhuꞌl. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","As bꞌex itzꞌibꞌa veꞌt tibꞌ u Xhuꞌleꞌ tukꞌ u Maꞌleꞌ, tan kꞌujlik veꞌt tzii tiꞌ chaꞌma. As atik veꞌt iyaabꞌil u Maꞌleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","As tul uvaꞌ atik veꞌt chaꞌma tu u Belén, as ilej veꞌt u qꞌiieꞌ tiꞌ titzꞌebꞌ u neꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","As itzꞌebꞌ veꞌteꞌ. As aꞌeꞌ u bꞌaxa tal u Maꞌleꞌ. As ibꞌoch veꞌt u Maꞌleꞌ u neꞌeꞌ tu umaꞌl u txoꞌ. As ikoxhbꞌaꞌ veꞌt kuꞌ tu umaꞌl u jukꞌubꞌ, tan jit ilej veꞌt chaꞌma ivatbꞌal tu umaj kabꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","As atik kaꞌl unqꞌa xeen kaneeroꞌ najlich u Belén. As nik ivata chajnaj unqꞌa kaneeroꞌeꞌ aqꞌbꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","As aat kuxh til veꞌt chajnaj tul veꞌt umaꞌl u ángel uvaꞌ tetz u Kubꞌaal Tiixheꞌ. As yak chit txijul veꞌt chajnaj taꞌn vilitzꞌloꞌlan u Tiixheꞌ. As kat chit xoꞌv veꞌt chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","As ech tal veꞌt u ángel ileꞌ: —Yeꞌ kuxh xoꞌv ex, tan aꞌ umaꞌl u bꞌaꞌnla yoleꞌ tul val sete. As la txuqꞌtxun veꞌt ex stiꞌ tukꞌ unqꞌa tenameꞌ unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","As cheel kat itzꞌebꞌyu veꞌt u qꞌalpun tetz unqꞌa tenameꞌ. As aꞌ kat itzꞌebꞌkat tu u tenam uvaꞌ alalkat u David. As aꞌeꞌ u Cristo uvaꞌ Kubꞌaal. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","As abꞌiste u neꞌeꞌ uveꞌ ni val sete as kꞌuchbꞌal tetz uvaꞌ, tan tul la bꞌen elej u neꞌeꞌ, as bꞌochel tu umaꞌl u txoꞌ. As koxhlu kuꞌ tu umaꞌl u jukꞌubꞌ,— tiꞌk u ángel. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","As aat kuxh til veꞌt unqꞌa xeen txooeꞌ ichee veꞌt mamaꞌla ángel svatz. As ech tal veꞌt unqꞌa ángel ileꞌ tiꞌ toksat iqꞌii u Tiixheꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—¡Qoksataj iqꞌii u Tiixheꞌ uvaꞌ echen tu almikaꞌ! tan Aakeꞌ nibꞌanon uvaꞌ bꞌaꞌn tatin unqꞌa uxhchileꞌ svatzaj vatz u txꞌavaꞌeꞌ, tan echeꞌ uvaꞌ nisaꞌ u Tiixheꞌ— tiꞌk unqꞌa ángel. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","As tul qꞌaav veꞌt unqꞌa ángel tu almikaꞌ, as ech tal veꞌt unqꞌa xeen txoo ileꞌ svatzaj: —Koꞌnaj tu u Belén. Koꞌnaj qil uveꞌ kat tal u Tiixheꞌ sqe,— tiꞌk unqꞌa xeen txooeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","As qꞌax chit veꞌt ibꞌen chajnaj. Bꞌex ilej veꞌt chajnaj u Maꞌleꞌ tukꞌ u Xhuꞌleꞌ tukꞌ u neꞌeꞌ. As koxhlik kuꞌ u tal neꞌeꞌ tu u jukꞌubꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","As tul til veꞌt chajnaj u neꞌeꞌ, as kat tal veꞌt chajnaj te chaꞌma kam uvaꞌ kat ul tal u ángel te chajnaj tiꞌ u neꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","As jankꞌal unqꞌa uxhchileꞌ uveꞌ kat abꞌin viyol unqꞌa xeen txooeꞌ as kat chit txuqꞌtxun veꞌteꞌ taꞌn u yoleꞌ uveꞌ tal chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","As nikat kuxh titzꞌa u Maꞌleꞌ unqꞌa yoleꞌ. As kat ibꞌan veꞌt jeꞌ tiviꞌ uvaꞌ kam isuuchil u yoleꞌ uveꞌ kat tabꞌi. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","As tul qꞌaav veꞌt unqꞌa xeen txooeꞌ kꞌatz unqꞌa ikaneeroꞌeꞌ, as vaꞌlik chit itxuqꞌtxun veꞌt chajnaj. As toksa veꞌt chajnaj iqꞌii u Tiixheꞌ tiꞌ unqꞌa veeꞌ kat tabꞌi as tiꞌ unqꞌa veeꞌ kat tila echeꞌ uvaꞌ kat alax te chajnaj taꞌn u ángel. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","As tul ibꞌan u neꞌeꞌ vaaxil qꞌii as bꞌex tzokꞌaxoj veꞌt el unbꞌiil vichiꞌoleꞌ, as oksal veꞌt ibꞌii uvaꞌ Jesús, tan echeꞌ uveꞌ alik kan taꞌn u ángel te u Maꞌleꞌ tul uvaꞌ yeꞌxnik jeꞌ ventasioon stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","As tul ibꞌan u Maꞌleꞌ kaꞌviinqil qꞌii tiꞌ u neꞌeꞌ echeꞌ uvaꞌ alik kan taꞌn u Moisés, as eqꞌol veꞌt u neꞌeꞌ taꞌn vitxutxeꞌ tukꞌ vibꞌaaleꞌ tu u Jerusalén tiꞌ inachpu veꞌt Tiixh stiꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","tan ech ni tal u yol ileꞌ uvaꞌ tzꞌibꞌamal kan taꞌn u Moisés: «Asoj xaak u bꞌaxa tal u ixojeꞌ, as tetz Tiixh naj la ibꞌaneꞌ,» tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","As inima veꞌt chaꞌma u yoleꞌ uvaꞌ alelik kan taꞌn u Moisés uvaꞌ ech ni tal ileꞌ: «As la oyal veꞌt untzumoj koꞌrakꞌum as moj tzumoj paroomaxh vatz u Tiixheꞌ,» tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","As atik umaꞌl u pap tu u Jerusalén uvaꞌ Simeón ibꞌii, as nik toksa taama tiꞌ inachat Tiixh. As atik ok taama tiꞌ u Tiixheꞌ. As nikat itxꞌebꞌon tiꞌ ilejat u qꞌiieꞌ uvaꞌ la ul u qꞌalpun tetz u tenameꞌ uvaꞌ tiaal Israel tiꞌ ilochpeꞌ. As aꞌik u Tiixhla Espíritu nik lochon u Simeón tiꞌ ibꞌanataꞌ kam uvaꞌ nik tal u Tiixheꞌ stiꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","tan maꞌtik talat u Tiixhla Espíritu ste uvaꞌ techal la til kan tul u Cristo uvaꞌ la ichaj tzan u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","As an chit u Tiixhla Espíritu oksan xeꞌ taama u Simeón tiꞌ toon vatz u tostiixheꞌ. As tul bꞌex oonoj u neꞌeꞌ taꞌn u Xhuꞌleꞌ tukꞌ u Maꞌleꞌ tiꞌ toksal veꞌt u neꞌeꞌ vatz u Tiixheꞌ tiꞌ inimat chaꞌma u tzaqꞌiteꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","as ijele veꞌt u Simeón u neꞌeꞌ. As ech tal veꞌt u Simeón ileꞌ tiꞌ toksat iqꞌii u Tiixheꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—Kubꞌaal Tiixh, la uchi uvaꞌ la kam veꞌt in echeꞌ uvaꞌ alel kan aꞌn, tan bꞌaꞌn tatin veꞌt u vaanxelaleꞌ savatz, ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","tan kat villu veꞌt u qꞌalpun qetzeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","As axheꞌ, Pap, la chꞌiisan aqꞌal uvaꞌ la ilax taꞌn unqꞌa tenameꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","As la tal veꞌt isuuchil vayoleꞌ te unqꞌa tenameꞌ uveꞌ jit tiaal Israel echeꞌ itxijul umaꞌl tenam uvaꞌ echen tu u toktoeꞌ. As la oksal iqꞌii vatenameꞌ uveꞌ tiaal Israel taꞌn u neꞌeꞌ,— tiꞌk u Simeón. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","As tul tabꞌi veꞌt u Xhuꞌleꞌ tukꞌ u Maꞌleꞌ u yoleꞌ uveꞌ tal u Simeón tiꞌ u neꞌeꞌ, as kat chit sotz veꞌt ikꞌuꞌl chaꞌma. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","As toksa veꞌt u Simeón iqꞌii u Tiixheꞌ. As ech tal veꞌt ileꞌ te u Maꞌleꞌ: —Tan kꞌujleꞌl veꞌt u neꞌeꞌ tiꞌ uvaꞌ at unqꞌa tiaal Israel la niman, as ati uvaꞌ yeꞌ la niman. As at unqꞌa uxhchileꞌ la chꞌoꞌn veꞌt taama stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","As la ootzil vitxumbꞌal unqꞌa uxhchileꞌ kam uveꞌ ni titzꞌa taama. Pet ech koj axh, tan ech tok umaj u mam txumuꞌm xeꞌ aama echeꞌ tok umaj chꞌichꞌ tu u taanxelal umaj uxhchil,— tiꞌk u Simeón tal te u Maꞌleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Atik umaꞌl u qꞌajsan tetz viyol u Tiixheꞌ vatz iqꞌanal u tostiixheꞌ. As An ibꞌii u ixojeꞌ. As imeꞌal u Fanuel uvaꞌ tiaal u Aser ixoj. As txulnalik ixoj tul teqꞌo tibꞌ ixoj tukꞌ vitzumeleꞌ. As vujvaꞌl kuxh yaabꞌ teqꞌo tibꞌ ixoj tukꞌ vitzumeleꞌ. As kat kam veꞌt vitzumel ixojeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","As kaaik veꞌt kan ixoj txakayil kajvaꞌl toꞌkꞌal (84) yaabꞌ. As tul qꞌestik chit veꞌt ixoj. As bꞌenameen atik chit ixoj vatz iqꞌanal u tostiixheꞌ. As nik inach ixoj Tiixh sqꞌiil as aqꞌbꞌal. As nikat ikuy veꞌt ixoj ivaꞌy tiꞌ inachat Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","As tul yaꞌ veꞌt u Simeón tiꞌ iyoloneꞌ, as jetzꞌen veꞌt ok u Aneꞌ kꞌatz u neꞌeꞌ tiꞌ taqꞌat taꞌntiixh te u Tiixheꞌ stiꞌ. As nik tal u Aneꞌ isuuchil u tijleꞌm u neꞌeꞌ te unqꞌa uxhchileꞌ tu u Jerusalén uveꞌ nik itxꞌebꞌon tiꞌ u qꞌalpun tetz unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","As tul tzojpu veꞌt u Xhuꞌleꞌ tukꞌ u Maꞌleꞌ tiꞌ uvaꞌ alelik kan tu u tzaqꞌiteꞌ taꞌn u Tiixheꞌ, as qꞌaav veꞌt chaꞌma tu u Nazaret uvaꞌ echen tu u Galilea. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","As chꞌiichil chit nik ibꞌan veꞌt u Jesús. As nik ichee veꞌt iyakꞌil. As nik ichee veꞌt itxumbꞌal. As nik taqꞌ veꞌt tzan u Tiixheꞌ vibꞌaꞌnileꞌ stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","As jun yaabꞌ nikat ibꞌen vitxutx u Jesús tukꞌ vibꞌaaleꞌ tu u Jerusalén tiꞌ tilat u nimla qꞌiieꞌ uvaꞌ pascua ibꞌii. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tul maꞌtik ibꞌanat u Jesús kabꞌlaval yaabꞌ, as bꞌex veꞌt vitxutxeꞌ tukꞌ vibꞌaaleꞌ tu u nimla qꞌiieꞌ, tan ech chit nik ibꞌan chaꞌma tu jun yaabꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","As tul pal veꞌt u nimla qꞌiieꞌ, as qꞌaav veꞌt vitxutx u Jesús tukꞌ vibꞌaaleꞌ tiꞌ ibꞌen tu vitenameꞌ. As kaaik veꞌt kan u Jesús tu u Jerusalén. As jit ilax ikaa Aak, ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","tan kamal xekelik Aak xoꞌl unqꞌa tenameꞌ uvaꞌ nikat tal chaꞌma. As tul uvaꞌ maꞌtik ixaat veꞌt chaꞌma umaꞌl qꞌii xaoꞌm, as aꞌn ichuk veꞌt chaꞌma u Jesús xoꞌl unqꞌa tatineꞌ tukꞌ xoꞌl unqꞌa tenameꞌ uveꞌ ootzimalik taꞌn chaꞌma. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","As jit ilej veꞌt chaꞌma u Jesús. As qꞌaav veꞌt chaꞌma tu u Jerusalén tiꞌ ichukat u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","As tu veꞌt itoxvu qꞌii, as aꞌn ilej veꞌt chaꞌma u Jesús. As aꞌ xonlikkat ok u Jesús tu u tostiixheꞌ xoꞌl unqꞌa najeꞌ uveꞌ nik ichusun u tzaqꞌiteꞌ uvaꞌ tzꞌibꞌamal kan. As nik tabꞌi u Jesús viyol chajnajeꞌ. As nikat ichꞌoti u Jesús itziꞌ chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","As jankꞌal unqꞌa uxhchileꞌ uveꞌ nikat abꞌin viyol u Jesús as teqꞌo chit veꞌt taama chajnaj tiꞌ vitxumbꞌal u Jesús, tan chꞌiꞌumal chit talat veꞌt u Jesús isuuchil unqꞌa yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","As echat chit kat ibꞌan vibꞌaal u Jesús tukꞌ vitxutxeꞌ tiꞌ uvaꞌ til chaꞌma uvaꞌ tal u Jesús isuuchil u yoleꞌ. As ech tal veꞌt u Maꞌl ileꞌ: —¿Kameꞌ qꞌi, val, uveꞌ kat oolbꞌe oꞌ? As kat kuxh axaansal veꞌt qaama. As in tukꞌ ak abꞌaaleꞌ, as kat kuxh chukunyu veꞌt oꞌ seeꞌ,— tiꞌk u Maꞌleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","As ech tal veꞌt u Jesús ileꞌ: —¿As kam qꞌi uveꞌ nechuk sve? ¿As yeꞌ kol ootzimal qꞌa setaꞌn uvaꞌ aꞌ chit la atinkat in tu vikabꞌal vunBꞌaaleꞌ?— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","As jit pal u Maꞌleꞌ stuul tukꞌ u Xhuꞌleꞌ tiꞌ uvaꞌ kam ni tokkat u yoleꞌ uveꞌ tal u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","As tul tal u Jesús u yoleꞌ, as bꞌen veꞌt Aak tiꞌ vibꞌaaleꞌ tukꞌ tiꞌ vitxutxeꞌ tu u Nazaret. As nikat inima u Jesús yol kam uvaꞌ nik tal chaꞌma ste. As nikat kuxh titzꞌa vitxutxeꞌ unqꞌa yoleꞌ uveꞌ kat tal u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","As nikat ichꞌii veꞌt itxakebꞌ u Jesús. Nikat ichee veꞌt itxumbꞌal. As bꞌaꞌn vitxumbꞌal u Jesús vatz u Tiixheꞌ as tukꞌ vatz unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","As tul ibꞌan oꞌlaval yaabꞌ tok veꞌt u César uvaꞌ Tiberia ijlenaalil tu u Roma, as aꞌik u Poncio Pilato uveꞌ atik ok bꞌanol ivatz tu u Judea. As aꞌ atikkat ok u Herodes tu u Galilea. As aꞌ atikkat ok u Piꞌleꞌ, u titzꞌin u Herodes, tu u Iturea tukꞌ tu u Trakonite. As aꞌ atikkat ok u Lisanias tu u Abilinia. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","As tul atik ok u Anás tukꞌ u Caifás iqꞌesalil oksan iyol tenam vatz Tiixh, as yolon veꞌt u Tiixheꞌ te u Xhuneꞌ, vikꞌaol u Zacarías, tu u tzuukin txꞌavaꞌeꞌ, tan aꞌ isaꞌ u Tiixheꞌ uvaꞌ la bꞌen ipaxsa u Xhuneꞌ viyol Aakeꞌ xoꞌl unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","As pal veꞌt u Xhuneꞌ tulaj unqꞌa tenameꞌ tziꞌ u Jordán tiꞌ talat viyol u Tiixheꞌ te unqꞌa tenameꞌ. As nik tal veꞌteꞌ uvaꞌ la kuꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ, texhlal tetz uvaꞌ kat ikꞌaxal unqꞌa uxhchileꞌ vipaaveꞌ vatz u Tiixheꞌ, aqꞌal uvaꞌ la isotzsa veꞌt Aak ipaav unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tan echeꞌ umaꞌl u yol uvaꞌ tzꞌibꞌamal kan taꞌn u Isaías uvaꞌ ech ni tal ileꞌ: Tan la uch umaꞌl u sikꞌiꞌm tu u tzuukin txꞌavaꞌeꞌ. As ech la tal ileꞌ: «¡Ebꞌantaj etucheꞌ tiꞌ ekꞌulat u kuBꞌooqꞌoleꞌ! ¡As ejikbꞌaꞌtaj vetxumbꞌaleꞌ echeꞌ ijikbꞌaꞌl umaj bꞌey! ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","As la noosal u xoꞌl u vitzeꞌ. As la eꞌpul el u vitzeꞌ, aqꞌal uvaꞌ chaqꞌaala chit la ibꞌan veꞌteꞌ. As ech ejikbꞌaꞌt vetxumbꞌaleꞌ echeꞌ ijikbꞌaꞌl umaj bꞌey uveꞌ koyixi. As jankꞌal unqꞌa bꞌeyeꞌ uveꞌ at jul stuul as labꞌalili. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","As kajayil chit unqꞌa tenameꞌ tuk ilon tul uvaꞌ tuk isotzsa veꞌt u Tiixheꞌ vipaav unqꞌa tenameꞌ,» chaj la taleꞌ, tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","As ul veꞌt unqꞌa tenameꞌ kꞌatz u Xhuneꞌ tiꞌ uvaꞌ la taqꞌ kuꞌ u Xhuneꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ. As ech tal u Xhun ileꞌ: —¡Ech vetxumbꞌaleꞌ echeꞌ u txꞌiꞌlatxooeꞌ! ¿Tan abꞌil kat alon sete uvaꞌ la ooj ex vatz u kꞌaxkꞌoeꞌ uveꞌ tuleꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ebꞌantaj bꞌaꞌnil, texhlal tetz uvaꞌ kat ekꞌaxal veꞌt etibꞌ vatz u Tiixheꞌ. As yeꞌ etitzꞌa uvaꞌ tiꞌ kuxh uvaꞌ: «Oꞌ tiaal u Abraham,» chꞌex netaleꞌ, as yeꞌl ex la pal ex tu u kꞌaxkꞌoeꞌ uvaꞌ tuleꞌ, tan tuk val sete uvaꞌ echeꞌ kꞌaxkꞌo koj ibꞌensat u Tiixheꞌ unqꞌa kꞌubꞌeꞌ stiaal u Abraham. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","As ech veꞌt bꞌanel etaꞌneꞌ echeꞌ unqꞌa tzeꞌeꞌ uvaꞌ at veꞌt ok u kꞌoxbꞌaleꞌ stiꞌ tiꞌ itzokꞌpu unqꞌa taqꞌil tzeꞌeꞌ. As abꞌiste u tzeꞌeꞌ uveꞌ yeꞌ bꞌaꞌn vivatzeꞌ ni taqꞌeꞌ as la tzokꞌax el. As la sutil ok tu xamal,— tiꞌk u Xhuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","As ech tal veꞌt kaꞌl unqꞌa uxhchil ileꞌ xoꞌl unqꞌa tenameꞌ: —¿As kam qꞌi la kubꞌaneꞌ tiꞌ uvaꞌ la kukꞌucheꞌ uvaꞌ kat kukꞌaxal qibꞌ?— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ech tal u Xhun ileꞌ: —Abꞌiste ex uveꞌ at kaꞌvaꞌl etoksaꞌm as etaqꞌtaj umaj te vemooleꞌ uveꞌ yeꞌl tetz ati. As abꞌiste ex uveꞌ at etxꞌix as etaqꞌtaj tetz unqꞌa uxhchileꞌ uveꞌ yeꞌl itxꞌix ati,— tiꞌk u Xhuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","As kaꞌl unqꞌa uxhchil uvaꞌ nik molon puaj tetz u ijlenaaleꞌ tu u Roma, as ul veꞌt chajnaj kꞌatz u Xhuneꞌ tiꞌ uvaꞌ la kuꞌ chajnaj xeꞌ u aꞌeꞌ. As ech tal veꞌt chajnaj ileꞌ: —¿Chusul, kam la kubꞌaneꞌ tiꞌ uvaꞌ la kukꞌucheꞌ uvaꞌ kat kukꞌaxal qibꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ech tal veꞌt u Xhun ileꞌ: —Yeꞌ kuxh ejaj kaꞌt puaj tiꞌ uveꞌ alel sete taꞌn u ijlenaaleꞌ,— tiꞌk u Xhuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","As ech tal kaꞌt unqꞌa sol ileꞌ: —¿As kano oꞌ qꞌi? ¿Kam la kubꞌaneꞌ?— tiꞌk chajnaj. Ech tal veꞌt u Xhun ileꞌ: —Yeꞌ kuxh exoꞌvisa unqꞌa uxhchileꞌ tiꞌ emaat unqꞌa tetzeꞌ. As yeꞌ la echeesa yol tiꞌ exochat unqꞌa uxhchileꞌ. As ekꞌujbꞌaꞌtaj kuxh ekꞌuꞌl tiꞌ vejaꞌmileꞌ uveꞌ nekꞌuleꞌ,— tiꞌk u Xhuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","As yeꞌ saach unqꞌa tenameꞌ nikat alon svatzaj uvaꞌ kamal aꞌ veꞌt u Xhuneꞌ u Cristo uvaꞌ nik tal jeꞌ ste, tan nikat itxꞌebꞌ unqꞌa tenameꞌ u tulebꞌal u Cristo. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","As ech tal veꞌt u Xhun ileꞌ te unqꞌa tenameꞌ: —Jik chit tuk val sete, tan xeꞌ kuxh u aꞌeꞌ ni vaqꞌkat kuꞌ ex. Pet ech koj umaꞌt u uxhchileꞌ uveꞌ aꞌn tuleꞌ, tan nim talcheꞌ u tijleꞌmeꞌ sviꞌ. As jit unkꞌuleleꞌ uvaꞌ la unsaapu vikꞌaꞌjil vixaꞌpeꞌ. As tul la uli, as Aakeꞌ la oksan u Tiixhla Espíritueꞌ tu vetaanxelaleꞌ, as la ijikbꞌaꞌ veꞌt ex Aak tukꞌ vixamalileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tan ech la bꞌancheꞌ sete echeꞌ nibꞌanchu te u trigo, tan il u txaabꞌal tetz u trigo ileꞌ at tiqꞌabꞌ Aak. As la ikol veꞌt Aak u bꞌaꞌnla trigo tu u tatinbꞌaleꞌ. Pet ech koj u chꞌiseꞌ, tan yakloꞌk tu xamal, umaꞌl u xamal uvaꞌ yeꞌxhjatu la tzaai,— tiꞌk u Xhuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","As nimal chit unqꞌa yoleꞌ nik tal u Xhuneꞌ te unqꞌa tenameꞌ tiꞌ toksat xeꞌ taama unqꞌa uxhchileꞌ tiꞌ uvaꞌ la inima u bꞌaꞌnla yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","As u Herodes uvaꞌ kꞌujlik kan tiꞌ tilat isuuchil kajvaꞌl unqꞌa tenameꞌ taꞌn u ijlenaaleꞌ tu u Roma, as kat tixqeli veꞌt naj u Herodías, u tixqel u Piꞌleꞌ uvaꞌ titzꞌin u Herodes. Estiꞌeꞌ kat iyaa veꞌt u Xhuneꞌ u Herodes as tukꞌ tiꞌ unjoltu unqꞌa vaꞌlexheꞌ uveꞌ nik ibꞌan naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","As aal chit paavin veꞌt u Herodes tukꞌ unjoltu unqꞌa vaꞌlexheꞌ uvaꞌ kat ibꞌana. As tal veꞌt naj tok u Xhuneꞌ tu u kaarsa. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","As tul yeꞌxnik ok u Xhuneꞌ tu u kaarsa, as mamaꞌla uxhchileꞌ nikat taqꞌ kuꞌ naj xeꞌ u aꞌeꞌ. As antu veꞌt u Jesús kat kuꞌ veꞌt xeꞌ u aꞌeꞌ taꞌn u Xhuneꞌ. As tul kuxh inach u Jesús Tiixh, as ijajpu veꞌt tibꞌ u almikaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","As kuꞌ veꞌt chꞌuꞌl u Tiixhla Espíritu tiibꞌa u Jesús. As ech tiloneꞌ echeꞌ tilax umaj paroomaxh. As abꞌil umaꞌl u tuul viꞌ tu almikaꞌ uvaꞌ ech tal ileꞌ: —Axheꞌ unKꞌaol uvaꞌ xoꞌn chit axh sve. As vaꞌl chit untxuqꞌtxun seeꞌ,— tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","As tul ibꞌan u Jesús vinaj laval yaabꞌ, as xeꞌt veꞌt Aak tiꞌ ipaxsal viyol u Tiixheꞌ xoꞌl unqꞌa tenameꞌ. As vatz unqꞌa tenameꞌ, as ikꞌaol u Xhuꞌleꞌ u Jesús. As ikꞌaol Elí u Xhuꞌl; ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ikꞌaol Matat u Elí; ikꞌaol Leví u Matat. As ikꞌaol Melqui u Leví; ikꞌaol Jana u Melqui. As ikꞌaol umaꞌt u Xhuꞌl u Jana. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ikꞌaol Matatías u Xhuꞌl; ikꞌaol Amós u Matatías; ikꞌaol Nahum u Amós. As ikꞌaol Esli u Nahum; ikꞌaol Nagai u Esli. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","As ikꞌaol Maat u Nagai; ikꞌaol Matatías u Maat; ikꞌaol Semei u Matatías. As ikꞌaol umaꞌt u Xhuꞌl u Semei; ikꞌaol Judá u Xhuꞌl; ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ikꞌaol Joana u Judá; ikꞌaol Resa u Joana; ikꞌaol Zorobabel u Resa; ikꞌaol Salatiel u Zorobabel; ikꞌaol Neri u Salatiel. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","As ikꞌaol Melqui u Neri; ikꞌaol Adi u Melqui; ikꞌaol Cosam u Adi; ikꞌaol Elmodam u Cosam. As ikꞌaol Er u Elmodam; ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ikꞌaol Josué u Er; ikꞌaol Eliezer u Josué; ikꞌaol Jorim u Eliezer; ikꞌaol Matat u Jorim. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","As ikꞌaol Leví u Matat; ikꞌaol Simeón u Leví; ikꞌaol Judá u Simeón; ikꞌaol umaꞌt u Xhuꞌl u Judá; ikꞌaol Jonán u Xhuꞌl. As ikꞌaol Eliaquim u Jonán; ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ikꞌaol Melea u Eliaquim; ikꞌaol Mainán u Melea; ikꞌaol Matata u Mainán; ikꞌaol Natán u Matata. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","As ikꞌaol David u Natán; ikꞌaol Isaí u David; ikꞌaol Obed u Isaí; ikꞌaol Booz u Obed; ikꞌaol Salmón u Booz; ikꞌaol Naasón u Salmón. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","As ikꞌaol Aminadab u Naasón; ikꞌaol Aram u Aminadab; ikꞌaol Esrom u Aram; ikꞌaol Fares u Esrom, ikꞌaol Judá u Fares. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","As ikꞌaol Jacob u Judá; ikꞌaol Isaac u Jacob; ikꞌaol Abraham u Isaac; ikꞌaol Taré u Abraham; ikꞌaol Nacor u Taré. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","As ikꞌaol Serug u Nacor; ikꞌaol Ragau u Serug; ikꞌaol Peleg u Ragau; ikꞌaol Heber u Peleg; ikꞌaol Sala u Heber; ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ikꞌaol Cainán u Sala; ikꞌaol Arfaxad u Cainán. As ikꞌaol Sem u Arfaxad; ikꞌaol Noé u Sem; ikꞌaol Lamec u Noé; ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ikꞌaol Matusalén u Lamec; ikꞌaol Enoc u Matusalén; ikꞌaol Jared u Enoc; ikꞌaol Mahalaleel u Jared; ikꞌaol umaꞌt u Cainán u Mahalaleel. ");
INSERT INTO ixlNNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","As ikꞌaol Enós u Cainán; ikꞌaol Set u Enós; ikꞌaol Adán u Set. As aꞌ u Tiixheꞌ cheesan tetz u Adán. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","As atik itxumbꞌal u Jesús taꞌn u Tiixhla Espíritu tiꞌ ibꞌanat Aak kam uvaꞌ ni tal u Tiixheꞌ ste. As el veꞌt chꞌuꞌl Aak tziꞌ u nimla aꞌeꞌ u Jordán. As oon veꞌt Aak tu u tzuukin txꞌavaꞌeꞌ taꞌn u Tiixhla Espíritu. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","As kaꞌviinqil qꞌii kat atin u Jesús tu u tzuukin tzꞌavaꞌeꞌ. As yeꞌl Aak kat txꞌaꞌni. Pet kat ikuy veꞌt Aak ivaꞌy. As kat ul veꞌt u txꞌiꞌlanajeꞌ tiꞌ ul ichukat txumbꞌal tiꞌ uvaꞌ la paavin u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","As ech tal veꞌt u txꞌiꞌlanaj ileꞌ: —Asoj axh iKꞌaol u Tiixheꞌ, as ala uvaꞌ la bꞌen u kꞌubꞌeꞌ stxꞌixil,— tiꞌk u txꞌiꞌlanajeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ech tal veꞌt u Jesús ileꞌ: —Ech ni tal viyol u Tiixh ileꞌ uvaꞌ tzꞌibꞌamal kan: Jit kuxh u txꞌixeꞌ la isbꞌaꞌn unqꞌa uxhchileꞌ. Pet kajayil chit unqꞌa iyol u Tiixheꞌ, as aꞌeꞌ uvaꞌ la isbꞌaꞌn unqꞌa uxhchileꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","As bꞌen veꞌt u Jesús taꞌn u txꞌiꞌlanajeꞌ viꞌ umaꞌl u nimla vitz. As kam chit unqꞌa veeꞌ at tulaj unqꞌa tenameꞌ skajayil vatz u txꞌavaꞌeꞌ, as ikꞌuch veꞌt naj te u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","As ech tal veꞌt naj ileꞌ: —As la voksa veꞌt axh sibꞌooqꞌolil unqꞌa tenameꞌ skajayil. As la vaqꞌ unqꞌa itxꞌiibꞌal iqꞌiieꞌ see, tan at tunqꞌabꞌ skajayil. As la uch vaqꞌat te umaj uxhchil, abꞌil uveꞌ la unsaꞌ vaqꞌat ste. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Asoj la kuꞌ axh qaaloj sunvatz tiꞌ ooksat unqꞌii, as eetzeꞌ uveꞌ skajayil,— tiꞌk u txꞌiꞌlanajeꞌ te u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ech tal veꞌt u Jesús ileꞌ: —Jetzꞌen el sunvatz, Satanás, tan ech ni tal umaꞌt u yol ileꞌ uvaꞌ tzꞌibꞌamal kan: Taꞌn kuxh u Tiixheꞌ, vaBꞌooqꞌoleꞌ, la kuꞌ axh qaaloj svatz. As Aak kuxheꞌ la anima,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","As teqꞌo veꞌt u txꞌiꞌlanajeꞌ u Jesús viꞌ u tostiixheꞌ tu u Jerusalén. As ech tal veꞌt naj ileꞌ te Aak: —Asoj axh iKꞌaol u Tiixheꞌ, as suti kuꞌ eebꞌ tzitzaꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","tan ech ni tal umaꞌt u yol ileꞌ uvaꞌ tzꞌibꞌamal kan: La ichaj tzan u Tiixheꞌ unqꞌa ángel tiꞌ ul ilochat axh. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","As: La ul ikꞌul axh unqꞌa ángel aqꞌal uvaꞌ yeꞌ la kꞌaxbꞌu veꞌt avoj tiꞌ umaj kꞌubꞌ,— tiꞌk u txꞌiꞌlanajeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ech tal veꞌt u Jesús ileꞌ: —Ech ni tal umaꞌt u yol ileꞌ uvaꞌ tzꞌibꞌamal kan: Yeꞌ la uch abꞌekꞌat u Kubꞌaal Tiixheꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","As tul kat tzojpu veꞌt u txꞌiꞌlanajeꞌ tiꞌ ichukat txumbꞌal tiꞌ ikuꞌ u Jesús tu paav, as taqꞌ veꞌt kan naj u Jesús. As nik kuxh itxꞌebꞌ veꞌt naj ilejat umaꞌtoj qꞌii tiꞌ ichukat txumbꞌal unpajte tiꞌ u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","As atik itxumbꞌal u Jesús taꞌn u Tiixhla Espíritu tul qꞌaav veꞌt Aak tu u Galilea. As pax veꞌt itzibꞌlal u Jesús tulaj unqꞌa tenameꞌ tukꞌ tulaj unqꞌa talaj tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","As nikat ichusun veꞌt u Jesús tulaj unqꞌa atinbꞌaleꞌ tetz nachbꞌal Tiixh taꞌn unqꞌa tiaal Israel. As nimal unqꞌa uxhchileꞌ nik oksan veꞌt iqꞌii Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","As oon veꞌt u Jesús tu u Nazaret uvaꞌ chꞌiikat Aak. As tul kat ilej u xeem qꞌiieꞌ, as ok veꞌt Aak tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh, tan ech chit nik ibꞌan Aak tu jun xeem qꞌii. As txakebꞌ veꞌt Aak tiꞌ isikꞌlet Aak viyol u Tiixheꞌ xoꞌl unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","As aqꞌpik veꞌt ok u uꞌujeꞌ te Aak uveꞌ tzꞌibꞌamal kan taꞌn u Isaías, u qꞌajsan tetz viyol u Tiixheꞌ tul ijaj veꞌt Aak u uꞌujeꞌ. As ilej veꞌt Aak u yoleꞌ uvaꞌ ech ni tal ileꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Aꞌ viTiixhla Espíritu u Kubꞌaaleꞌ ni lochon in tiꞌ unbꞌanataꞌ kam uvaꞌ ni tal Aak sviꞌ. As txaael veꞌt in taꞌn Aak tiꞌ valat unqꞌa bꞌaꞌnla yoleꞌ xoꞌl unqꞌa meebꞌaꞌeꞌ. As kat ichaj veꞌt tzan in Aak tiꞌ ilochax unqꞌa uxhchileꞌ uvaꞌ kꞌaxbꞌinal u taanxelaleꞌ taꞌn u paaveꞌ, as tiꞌ valat unqꞌa yoleꞌ tiꞌ ichajpul veꞌt unqꞌa uxhchileꞌ uveꞌ kꞌalel taꞌn u paaveꞌ, as la ilon veꞌt unqꞌa tzoteꞌ, as tiꞌ unqꞌalput unqꞌa tenameꞌ uveꞌ bꞌuchel kuxhtuꞌ taꞌn vipaaveꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","as tiꞌ valat te unqꞌa uxhchileꞌ uvaꞌ kat ilejlu veꞌt u qꞌiieꞌ uvaꞌ la taqꞌ veꞌt Aak vibꞌaꞌnileꞌ te unqꞌa uxhchileꞌ, tiꞌk u yoleꞌ uvaꞌ isikꞌle u Jesús tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","As tul bꞌaꞌnxi, as ibꞌalqꞌu veꞌt Aak u uꞌujeꞌ. As taqꞌ veꞌt ok Aak te u lochonaaleꞌ. As xonebꞌ veꞌt Aak. As kaꞌyamalik chit veꞌt Aak taꞌn unqꞌa uxhchileꞌ skajayil uveꞌ atik tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","As ech tal veꞌt u Jesús ileꞌ: —As cheel kat ibꞌanlu veꞌt u veeꞌ sevatz, uvaꞌ alel kan tu u uꞌujeꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","As achaꞌv chit viyol Aakeꞌ te unqꞌa tenameꞌ. As teqꞌo veꞌt taama unqꞌa tenameꞌ tiꞌ u yoleꞌ uveꞌ isikꞌle Aak. As ech tal veꞌt unqꞌa tenam ileꞌ: —¿Jit kol vikꞌaol u Xhuꞌleꞌ qꞌa u najeꞌ?— tiꞌk unqꞌa tenameꞌ tal svatzaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ech tal veꞌt Aak ileꞌ: —Pet ni vitzꞌa uvaꞌ ech tuk etal ileꞌ sve: «¡Axh aatzꞌak, tzꞌaka eebꞌ sajunal!» chaj ex tuk etal sve. As moj ech la etal ileꞌ: «Jankꞌal unqꞌa bꞌaꞌnileꞌ uvaꞌ ni qabꞌi yol stiꞌ uvaꞌ kat abꞌan tu u Capernaúm as echat abꞌan tzitzaꞌ tu vatenameꞌ cheel,» chaj ex,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","As ech tal veꞌt Aak ileꞌ unpajte: —Tan echeꞌ bꞌaꞌn koj iyolbꞌel umaꞌl u qꞌajsan tetz viyol u Tiixheꞌ vatz unqꞌa uxhchileꞌ tu vitenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","As jik chit tuk val sete, tul uvaꞌ jit ul jabꞌal tu oxvaꞌl yaabꞌ tukꞌ vaajil ichꞌ taꞌn u Elías, as mamaꞌla vaꞌy kat ibꞌana. As kꞌuxh nimal unqꞌa txakay ixojeꞌ atik tu u Israel, ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","as jit ichaj bꞌen u Tiixheꞌ u Elías xeꞌ umaj txakay ixoj tu u Israel. Pet aꞌ ichajkat bꞌen Aak u Elías xeꞌ umaꞌl u txakay ixoj tu u Sarepta uvaꞌ echen tu u Sidón. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","As kꞌuxh nimal unqꞌa aachꞌoꞌmeꞌ atike uvaꞌ atik ok chꞌaꞌk chin stiꞌ tu u Israel tul uvaꞌ atik u Eliseo, u qꞌajsan tetz viyol u Tiixheꞌ, as yeꞌxhebꞌil kat bꞌaꞌnxi. Pet taꞌn kuxh u Naamán, u aa Siria, kat bꞌaꞌnxi,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","As tul tabꞌi veꞌt unqꞌa tenameꞌ viyol u Jesús tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh, as ul veꞌt iviꞌ chajnaj tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","As imol veꞌt ok tibꞌ unqꞌa uxhchileꞌ tiꞌ Aak tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh. As tilul veꞌt el Aak tiꞌeꞌl u tenameꞌ. As eqꞌol veꞌt jeꞌ Aak viꞌ u vitzeꞌ uvaꞌ jejlikkat unqꞌa tenameꞌ, tan aꞌ tal unqꞌa tenameꞌ uvaꞌ la sutil bꞌen Aak vatz u vitzeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pet pal kuxh veꞌt Aak xoꞌl unqꞌa tenameꞌ. As bꞌen veꞌt Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","As oon veꞌt u Jesús tu u Capernaúm uvaꞌ echen tu u Galilea. As tu u xeem qꞌiieꞌ tu jun xhemaana nikat ichus veꞌt Aak unqꞌa uxhchileꞌ tu u atinbꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","As teqꞌo veꞌt taama unqꞌa uxhchileꞌ tiꞌ u chusbꞌaleꞌ uveꞌ nik tal Aak, tan nik ikꞌuch Aak tukꞌ viyoloneꞌ uvaꞌ atik tijleꞌm Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","As atik ok umaꞌl u naj tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh uvaꞌ atik ok subꞌul skꞌatz. As taqꞌ jeꞌ naj tuul iviꞌ tiꞌ isikꞌineꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Ech tal veꞌt naj ileꞌ taꞌn u subꞌuleꞌ: —¡Jesús, aa Nazaret! ¿Kam asaꞌ sqe? ¡Yeꞌ ul ayansa oꞌ! Tan ootzimal svaꞌn uvaꞌ axheꞌ uvaꞌ chajel tzan axh taꞌn u Tiixheꞌ. As ayaꞌl chit akꞌuꞌl nooksa aama tiꞌ Aak,— tiꞌk u najeꞌ taꞌn u subꞌuleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ech tal veꞌt Aak ileꞌ te u subꞌuleꞌ: —¡Chaa tziꞌ! ¡Elen tiꞌ u najeꞌ!— tiꞌk Aak. As isuti veꞌt bꞌen u subꞌuleꞌ u najeꞌ tu txꞌavaꞌ vatz unqꞌa uxhchileꞌ. As el veꞌt u subꞌuleꞌ tiꞌ u najeꞌ. As jit ikꞌaxbꞌisa u subꞌuleꞌ u najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","As kat teqꞌo veꞌt taama unqꞌa uxhchileꞌ skajayil tiꞌ uveꞌ ibꞌan u Jesús. As ech tal veꞌt unqꞌa uxhchil ileꞌ svatzaj: —¿Kam tijleꞌm viyol u najeꞌ uveꞌ ni taleꞌ? Tan tul ni tal naj tel unqꞌa subꞌuleꞌ kꞌatz unqꞌa uxhchileꞌ, as ninima unqꞌa subꞌuleꞌ viyol najeꞌ,— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","As ipaxsa veꞌt unqꞌa uxhchileꞌ itzibꞌlal u Jesús tulaj unqꞌa talaj tenameꞌ uvaꞌ najlike. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","El veꞌt chꞌuꞌl u Jesús tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh. As ok veꞌt Aak tu vikabꞌal u Simón uvaꞌ Luꞌ. As jajpu veꞌt bꞌaꞌnil te Aak tiꞌ vijiꞌ u Luꞌeꞌ, tan nimxinalik chit veꞌteꞌ taꞌn xamal chꞌoꞌm. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","As jetzꞌen veꞌt ok Aak kꞌatz u aachꞌoꞌmeꞌ. As iyaa veꞌt Aak u xamal chꞌoꞌmeꞌ. As yak kuxh el veꞌt u xamal chꞌoꞌmeꞌ kꞌatz vijiꞌ u Luꞌeꞌ. As oora chit txakpu veꞌteꞌ. As taqꞌ veꞌt techbꞌubꞌal unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","As tul maꞌtik ibꞌen veꞌt qꞌii, as teqꞌo veꞌt tzan unqꞌa uxhchileꞌ unqꞌa aachꞌoꞌmeꞌ vatz u Jesús, kꞌuxh kam kuxh chꞌoꞌmil nik bꞌanon. As junun taqꞌat veꞌt jeꞌ Aak iqꞌabꞌ tiꞌ unqꞌa aachꞌoꞌmeꞌ. As nikat ibꞌaꞌnx veꞌteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","As tul nikat tel unqꞌa subꞌuleꞌ kꞌatz unqꞌa uxhchileꞌ, as vaꞌlik chit isikꞌin u subꞌuleꞌ tiꞌ teleꞌ. Ech nik tal ileꞌ te u Jesús: —¡Axheꞌ viKꞌaol u Tiixheꞌ!— tiꞌk unqꞌa subꞌuleꞌ. As iyaa veꞌt u Jesús unqꞌa subꞌuleꞌ, tan yeꞌ nisaꞌ Aak uvaꞌ la yolon u subꞌuleꞌ tan ootzimalik taꞌn u subꞌuleꞌ uvaꞌ aꞌ u Jesús u Cristo. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","As tul sajbꞌu veꞌteꞌ, as bꞌex ichuk u Jesús umaꞌl u atinbꞌal uvaꞌ yeꞌlkat uxhchil. As nik ichukun veꞌt unqꞌa tenameꞌ tiꞌ Aak. As tul ilej unqꞌa tenameꞌ Aak, as ijaj veꞌt kuybꞌal te Aak tiꞌ uvaꞌ la kaaik kan Aak tu u tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","As ech tal veꞌt Aak ileꞌ: —Yeꞌle, tan techal chiteꞌ uvaꞌ la bꞌen unpaxsa u bꞌaꞌnla yoleꞌ te unjoltu unqꞌa tenameꞌ, tiꞌ uvaꞌ at u tenameꞌ jaqꞌ u tijleꞌm u Tiixheꞌ, tan estiꞌeꞌ uvaꞌ kat ichaj tzan in Aak,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","As bꞌex tal veꞌt Aak u bꞌaꞌnla yoleꞌ tu unqꞌa atinbꞌaleꞌ tetz nachbꞌal Tiixh tulaj unqꞌa talaj tenameꞌ tu u Galilea. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","As tul uvaꞌ atik u Jesús tziꞌ u mar uvaꞌ Genesaret, as aꞌ chit mamaꞌla tenameꞌ oon kꞌatz Aak. As vaꞌlik chit ipochꞌat unqꞌa tenameꞌ Aak tiꞌ tabꞌil viyol Aakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","As til veꞌt Aak kaꞌvaꞌl u barco tziꞌ u mar uveꞌ elkat chꞌuꞌl unqꞌa txeyol txayeꞌ. As nikat kuxh itxꞌaa chajnaj unqꞌa ikꞌacheꞌ tziꞌ u aꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","As ok veꞌt u Jesús tu umaꞌl u barco uvaꞌ tetz u Simón uvaꞌ Luꞌ. As ijaj Aak bꞌaꞌnil te u Luꞌeꞌ uvaꞌ la ijetzꞌ ok naj unbꞌooj u barco tziꞌ u aꞌeꞌ. As xonebꞌ veꞌt Aak. As chusun veꞌt el tzan Aak tu u barco xoꞌl unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","As tul yaꞌ u Jesús tiꞌ iyoloneꞌ xoꞌl unqꞌa tenameꞌ, as ech tal veꞌt Aak ileꞌ te u Simón: —Eeqꞌo ok u barco tu uveꞌ nimkat tuul u aꞌeꞌ. As etaqꞌtaj bꞌen unqꞌa ekꞌacheꞌ xeꞌ u aꞌeꞌ tiꞌ etxeyat unqꞌa txayeꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ech tal veꞌt u Simón ileꞌ: —Chusul, as umaꞌx chit aqꞌbꞌal oꞌ tiꞌ kutxeyat u txayeꞌ. As yeꞌ kat kutxey umaj txoo. Pet asoj axh la alon, as tuk vaqꞌ bꞌen u kꞌacheꞌ xeꞌ u aꞌeꞌ unpajte,— tiꞌk u Simón. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","As ibꞌan veꞌt chajnaj kam uveꞌ tal u Jesús. As aꞌ chit mamaꞌla txayeꞌ ok veꞌt tu u kꞌacheꞌ. As nik iratꞌmu veꞌt u kꞌacheꞌ jaqꞌ talal unqꞌa txayeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","As ibꞌetxu veꞌt tzan chajnaj unqꞌa imooleꞌ uveꞌ echenik tu umaꞌt u barco tiꞌ ilochpeꞌ. As tul ul veꞌt chajnaj, as inoosa chajnaj kaꞌvaꞌt u barco taꞌn unqꞌa txayeꞌ. As unbꞌiit kuxh yeꞌ nikat imujtxꞌik veꞌt bꞌen unqꞌa barco xeꞌ u aꞌeꞌ taꞌn talal unqꞌa txayeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","As tul til u Simón uvaꞌ Luꞌ inoo veꞌt unqꞌa barco taꞌn unqꞌa txayeꞌ, as kuꞌ veꞌt naj qaaloj vatz Aak. As ech tal veꞌt naj ileꞌ: —Yeꞌ la uch aatin sunkꞌatz, Pap, tan in aapaav,— tiꞌk u Luꞌeꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","tan teqꞌo chit taama naj tukꞌ unqꞌa imooleꞌ tiꞌ unqꞌa mamaꞌla txayeꞌ uveꞌ itxey chajnaj taꞌn u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","As echat chit kat ibꞌan u Xhuneꞌ tukꞌ u Jacob. As aꞌeꞌ kaꞌvaꞌl vikꞌaol u Zebedeo uvaꞌ imool tibꞌ tukꞌ u Simón. As ech tal veꞌt u Jesús ileꞌ te u Simón: —Yeꞌ xoꞌv axh, tan cheel jit veꞌt axh txeyol txay la ibꞌaneꞌ. Pet aꞌ veꞌt unqꞌa tenameꞌ la eeqꞌo tzan tiꞌ tok sunkꞌatz,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","As ijetzꞌ veꞌt el tzan chajnaj unqꞌa ibarco tziꞌ u mar. As taqꞌ veꞌt kan chajnaj unqꞌa tetzeꞌ skajayil. As xekebꞌ veꞌt chajnaj tiꞌ u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","As tul atik u Jesús tu umaꞌl u tenam uvaꞌ tu u Galilea, as bꞌex oonoj umaꞌl u naj kꞌatz Aak uvaꞌ mamaꞌla chꞌaꞌk chin atik ok stiꞌ. Tul til naj Aak, as kuꞌ naj qaaloj techal toon ivatz naj vatz txꞌavaꞌ vatz Aak. As ech tal veꞌt naj ileꞌ: —Pap, asoj la asaꞌ, as bꞌan bꞌaꞌnil sve. As eesa u chꞌoꞌmeꞌ sviꞌ, tan la olebꞌ axheꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","As taqꞌ veꞌt bꞌen u Jesús iqꞌabꞌ tiꞌ naj. Ech tal Aak ileꞌ: —Bꞌaꞌn kuxheꞌ. Kat bꞌaꞌnxiy veꞌt axheꞌ,— tiꞌk Aak. As yak kuxh el u chꞌaꞌk chineꞌ tiꞌ naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","As ech tal veꞌt u Jesús ileꞌ te naj: —Katiniꞌk chit aalkat. Pet kuxh kꞌuch eebꞌ vatz u nachol Tiixheꞌ tiꞌ unqꞌa tenameꞌ. As kuxh aqꞌ veꞌt u oyeꞌ uvaꞌ alel kan taꞌn u Moisés, texhlal tetz uvaꞌ kat txanyu veꞌt axh,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","As aal chit nik ipax veꞌt itzibꞌlal u Jesús xoꞌl unqꞌa tenameꞌ. As aꞌ chit mamaꞌla tenameꞌ nikat imol veꞌt tibꞌ tiꞌ tabꞌil viyol Aakeꞌ as tiꞌ uvaꞌ la ibꞌaꞌnxisa veꞌt Aak unqꞌa aachꞌoꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pet bꞌenameen nikat tel chꞌuꞌl u Jesús xoꞌl unqꞌa tenameꞌ tiꞌ ibꞌen inachat Tiixh sijunal tu unqꞌa atinbꞌaleꞌ uveꞌ yeꞌlkat uxhchil. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","As tu umaꞌl u qꞌii tul nikat ichusun u Jesús tu umaꞌl u kabꞌal, as xonlik ok kaꞌl unqꞌa fariseo tukꞌ kaꞌt unqꞌa uxhchileꞌ uvaꞌ chuselik tibꞌ tiꞌ u tzaqꞌiteꞌ uvaꞌ tzꞌibꞌamal kan. As aꞌ tzaakat chajnaj tulaj unqꞌa talaj tenameꞌ uvaꞌ tu u Galilea tukꞌ tu u Judea as tukꞌ tu u Jerusalén. As atik veꞌt vibꞌaꞌnil u Kubꞌaal Tiixheꞌ kꞌatz u Jesús tiꞌ ibꞌaꞌnxisal unqꞌa aachꞌoꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","As oon kaꞌl unqꞌa naj vatz u kabꞌaleꞌ uvaꞌ atikkat ok u Jesús. As chelemalik umaꞌl u aachꞌoꞌm taꞌn chajnaj viꞌ umaꞌl u chꞌachiꞌm tzeꞌ, tan tzeꞌunik tibꞌ vichiꞌoleꞌ. As tal chajnaj tok tu kabꞌal tiꞌ taqꞌat ok u aachꞌoꞌmeꞌ vatz u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","As jit uch tok chajnaj taꞌn unqꞌa mamaꞌla tenameꞌ. As jeꞌ veꞌt chajnaj viꞌ u kabꞌaleꞌ. As teesa veꞌt chajnaj unbꞌiil iviꞌ u kabꞌaleꞌ. As taqꞌ veꞌt kuꞌ chajnaj u aachꞌoꞌmeꞌ tukꞌ u chꞌachiꞌm tzeꞌeꞌ xoꞌl unqꞌa tenameꞌ vatz u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","As tul til veꞌt u Jesús uvaꞌ kꞌujlik chit ikꞌuꞌl chajnaj tiꞌ Aak. As ech tal veꞌt Aak ileꞌ te u aachꞌoꞌmeꞌ: —Kat sotzyeꞌ vapaaveꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","As unqꞌa fariseo tukꞌ unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as ech tal veꞌt jeꞌ ileꞌ ste: —¿Kam tijleꞌmeꞌ qꞌi u najeꞌ uveꞌ ni taleꞌ? Tan ni teesa naj iqꞌii u Tiixheꞌ, tan yeꞌl umaj uxhchil at vatz u txꞌavaꞌeꞌ uvaꞌ la sotzsan paav. Pet taꞌneꞌ u Tiixheꞌ la sotzsan u paaveꞌ,— tiꞌk chajnaj svatzaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","As atik skꞌuꞌl u Jesús uvaꞌ kam nik tal jeꞌ chajnaj ste. As ech tal veꞌt Aak ileꞌ te chajnaj: —¿Kam qꞌi uveꞌ vaꞌlen kuxh netitzꞌa tiꞌ vunyoleꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Tan abꞌiste qꞌi uvaꞌ yeꞌ la olebꞌ in tiꞌ ibꞌancheꞌ uvaꞌ netitzꞌa? ¿Ma tiꞌ uvaꞌ: «Kat sotzyeꞌ vapaaveꞌ,» chaj in te u aachꞌoꞌmeꞌ? ¿Pet moj: «Txakpen. As kuxh veꞌteꞌ,» chaj in la valeꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pet aqꞌal uvaꞌ la etootzi u tijleꞌm VIKꞌAOL U NAJEꞌ tiꞌ ul isotzsat ipaav unqꞌa aapaaveꞌ vatz u txꞌavaꞌeꞌ, as sevatz tuk valkat te u aachꞌoꞌmeꞌ,— tiꞌk Aak. As ech tal veꞌt Aak ileꞌ te u aachꞌoꞌmeꞌ: —Txakpen. As eqꞌo vachꞌachiꞌm tzeꞌeꞌ. As kuxh veꞌt takabꞌal,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","As yak kuxh txakpu veꞌt u najeꞌ vatz unqꞌa tenameꞌ. As isikꞌ veꞌt naj u chꞌachiꞌm tzeꞌeꞌ. As bꞌen veꞌt naj tikabꞌal. As vaꞌlik chit toksat veꞌt naj iqꞌii u Tiixheꞌ tul bꞌen naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","As teqꞌo veꞌt taama unqꞌa tenameꞌ taꞌn uveꞌ ibꞌan u Jesús. As toksa veꞌt unqꞌa tenameꞌ iqꞌii u Tiixheꞌ tiꞌ uveꞌ ibꞌan Aak. As ech tal veꞌt unqꞌa tenam ileꞌ svatzaj: —Xoꞌvebꞌal chit uveꞌ kat qillu veꞌt cheel,— tiꞌk unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","As xamtik veꞌt stuul, as el veꞌt chꞌuꞌl u Jesús tu u tenameꞌ. As til veꞌt Aak umaꞌl u naj uvaꞌ Leví ibꞌii uvaꞌ nik molon puaj tetz u Roma. Xonlik naj tu u atinbꞌaleꞌ uvaꞌ nik imolpukat u puajeꞌ. As ech tal veꞌt Aak ileꞌ te naj: —Siꞌu. Xekebꞌen sviꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","As txakpu veꞌt u Leví. Taqꞌ veꞌt kan naj unqꞌa veeꞌ skajayil. As xekebꞌ veꞌt naj tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","As ibꞌan veꞌt u Leví tuch umaꞌl u nimla txꞌaꞌoꞌm tikabꞌal tiꞌ u Jesús. As nimal unqꞌa najeꞌ ooni uvaꞌ nik molon puaj tetz u Roma. As atik ok chajnaj vatz u meexhaeꞌ kꞌatz Aak tukꞌ kaꞌt unqꞌa uxhchil. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","As xeꞌt veꞌt kaꞌl unqꞌa fariseo tiꞌ unqꞌa ichusulibꞌ Aakeꞌ, tukꞌ kaꞌt unqꞌa uxhchileꞌ uvaꞌ chuselik tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ. As ech tal veꞌt ileꞌ: —¿Kam bꞌan taꞌn qꞌi uvaꞌ netxꞌaꞌneꞌ as netukꞌaꞌeꞌ xoꞌl unqꞌa molol puajeꞌ tetz u Roma tukꞌ unjoltu unqꞌa uxhchileꞌ uveꞌ yeꞌ ni niman u Tiixheꞌ?— tiꞌk chajnaj tal te unqꞌa ichusulibꞌ u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","As tul tabꞌi veꞌt u Jesús u yoleꞌ uveꞌ alpu te unqꞌa ichusulibꞌeꞌ, as ech tal veꞌt Aak ileꞌ: —Abꞌil uveꞌ yeꞌl chꞌoꞌm stiꞌ, as yeꞌle u aatzꞌakeꞌ la txakon stiꞌ. Pet aꞌ unqꞌa aachꞌoꞌmeꞌ uveꞌ nitxakon u aatzꞌakeꞌ stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","As jit unqꞌa uxhchileꞌ tul unmolo uvaꞌ ni tal jeꞌ ste uvaꞌ yeꞌl ipaav ati. Pet aꞌ unqꞌa uxhchileꞌ uvaꞌ nichꞌoꞌn ste uvaꞌ kat paavini, as aꞌeꞌ tul unmolo, aqꞌal uvaꞌ la ijalpu veꞌt vitxumbꞌaleꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","As ech tal veꞌt kaꞌl unqꞌa uxhchil ileꞌ te u Jesús: —¿Kam qꞌi uvaꞌ jatpajul kuxh nikuy unqꞌa ichusulibꞌ u Xhuneꞌ ivaꞌy tul ninach chajnaj Tiixh? As echat chit nibꞌan unqꞌa ichusulibꞌ unqꞌa fariseo. Pet ech koj unqꞌa achusulibꞌeꞌ, tan nitxꞌaꞌn chajnaj. As ni tukꞌaꞌ chajnaj. ¿As kam qꞌi uveꞌ yeꞌ nikuy chajnaj ivaꞌy?— tiꞌk unqꞌa uxhchileꞌ tal te u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ech tal veꞌt Aak ileꞌ: —¿La kol uch qꞌa uvaꞌ la iyaꞌlu unqꞌa ilonaaleꞌ ikuyat ivaꞌy tu umaj nimla qꞌii tiꞌ teqꞌot tibꞌ umaj meꞌal umaj uxhchil? As tul il u tzumela ileꞌ at xoꞌl unqꞌa ilonaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","As lanal ilej umaꞌl u qꞌii uvaꞌ la ul eesal el u tzumelaeꞌ sxoꞌl. As aꞌn la ikuy veꞌt unqꞌa ilonaaleꞌ ivaꞌy,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","As tal veꞌt u Jesús umaꞌl u kꞌuchuvatz uvaꞌ ech ni tal ileꞌ: —Yeꞌxhebꞌil la jachꞌun umaj akꞌ oksaꞌm tiꞌ ikꞌooal umaj qꞌaꞌl oksaꞌm, tan asoj ech la ibꞌaneꞌ, as la yan veꞌt u akꞌ oksaꞌmeꞌ. As jit kuxh taꞌneꞌ. Pet yeꞌ bꞌaꞌn tilpu veꞌt u akꞌ oksaꞌmeꞌ tukꞌ u qꞌaꞌl oksaꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","As mitaꞌn la uch taqꞌax kuꞌ u akꞌ vino tu umaj qꞌaꞌl tzꞌuꞌm uvaꞌ ech tiloneꞌ xhaalo, tan la iqꞌix u akꞌ vino u qꞌaꞌl tzꞌuꞌmeꞌ tul la qꞌuꞌili. As la peqꞌxu veꞌt u vino. As la tzꞌejxu veꞌt u tzꞌuꞌm xhaaloeꞌ tukꞌ u vino. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pet tu umaj akꞌ tzꞌuꞌm xhaalo la kuꞌkat u akꞌ vino, aqꞌal uvaꞌ yeꞌ la tzꞌejxi. As mitaꞌn la yan u tzꞌuꞌm xhaaloeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","As abꞌil uvaꞌ la ukꞌan u vino uvaꞌ qꞌuꞌimal as echeꞌ la koj isaꞌ tukꞌat u akꞌ vino uveꞌ yeꞌ qꞌuꞌimal, tan ech la tal ileꞌ: «Vaꞌl itxꞌumtxꞌul u vino uveꞌ qꞌuꞌimal tiꞌ u akꞌ vino uveꞌ yeꞌ qꞌuꞌimal,» chaj u uxhchileꞌ la taleꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tu umaꞌl u xeem qꞌii, as bꞌex paloj u Jesús tukꞌ unqꞌa ichusulibꞌeꞌ xoꞌl unqꞌa trigo uvaꞌ avamalike. As pal ikꞌus veꞌt chajnaj kaꞌl ivatz unqꞌa trigo. As iyuli chajnaj tiqꞌabꞌ. As techbꞌu veꞌt chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tul til veꞌt kaꞌl unqꞌa fariseo, as ech tal veꞌt chajnaj ileꞌ te unqꞌa ichusulibꞌ Aakeꞌ: —¿Kam bꞌan taꞌn uveꞌ nebꞌaneꞌ? As tul aꞌeꞌ uveꞌ yeꞌ la uch ibꞌanchu tu u xeem qꞌiieꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ech tal veꞌt u Jesús ileꞌ: —¿Ma yeꞌxhkam bꞌa nesikꞌle uvaꞌ kat ibꞌan u David tul uvaꞌ kat vaꞌyi tukꞌ unqꞌa imooleꞌ uvaꞌ xekelik stiꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tan kat ok veꞌt u David vatz u atinbꞌaleꞌ uvaꞌ ninachpukat Tiixh. As kat itxꞌaꞌ veꞌt u paaneꞌ uvaꞌ maꞌtik teesal el tzan viꞌ u meexha tu u nachbꞌal Tiixheꞌ. As kat taqꞌ u David te unqꞌa imooleꞌ uvaꞌ xekelik stiꞌ. As tul aꞌ kuxh unqꞌa oksan iyol tenam vatz Tiixh uvaꞌ la echbꞌun unqꞌa paaneꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","As ech tal veꞌt u Jesús ileꞌ: —As tul ineꞌ uvaꞌ in VIKꞌAOL U NAJEꞌ, as ineꞌ viBꞌaal u xeem qꞌiieꞌ,— tiꞌk u Jesús tal te unqꞌa fariseo. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","As tu umaꞌt u xeem qꞌii, as ok veꞌt u Jesús tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh. As chusun veꞌt Aak xoꞌl unqꞌa tenameꞌ. Atik ok umaꞌl u naj uvaꞌ kꞌoroꞌxhinik tibꞌ visebꞌal iqꞌabꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","As nik kuxh itxꞌebꞌ kaꞌl unqꞌa fariseo tukꞌ kaꞌt unqꞌa uxhchil uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ tiꞌ uvaꞌ ma tuk ibꞌaꞌnxisa u Jesús u najeꞌ tu u xeem qꞌiieꞌ moj yeꞌle, tan nik ichuk chajnaj txumbꞌal tiꞌ icheesal ipaav Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pet ootzimalik vitxumbꞌal chajnajeꞌ taꞌn u Jesús. As ech tal veꞌt Aak ileꞌ te u najeꞌ uveꞌ kꞌoroꞌxhinik tibꞌ viqꞌabꞌeꞌ: —Txakpen. As txakebꞌen sukuxoꞌl,— tiꞌk Aak. As txakpu veꞌt naj. As ul veꞌt naj txakebꞌoj xoꞌl chajaak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","As ech tal veꞌt u Jesús ileꞌ: —As tuk unchꞌoti umaꞌl u yol sete. ¿Abꞌiste uveꞌ la uch kubꞌanat tu u xeem qꞌiieꞌ? ¿Ma u bꞌaꞌneꞌ? ¿Pet moj u vaꞌlexheꞌ? ¿As ma la uch kulochat unqꞌa uxhchileꞌ? ¿Pet moj la kuxh qil ikameꞌ?— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","As isaji veꞌt bꞌen u Jesús unqꞌa tenameꞌ uveꞌ atik ok kꞌatz Aak. As ech tal veꞌt Aak ileꞌ te u aachꞌoꞌmeꞌ: —Yuꞌbꞌaꞌ vaqꞌabꞌeꞌ,— tiꞌk Aak tal te naj. As iyuꞌbꞌaꞌ veꞌt naj viqꞌabꞌeꞌ. As yak kuxh bꞌaꞌnx veꞌt viqꞌabꞌ najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","As ul veꞌt iviꞌ unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ tukꞌ unqꞌa fariseo tiꞌ uveꞌ ibꞌan u Jesús. As iyol veꞌt chajnaj svatzaj uvaꞌ kam la tulbꞌe chajnaj tiꞌ tel iqꞌii u Jesús vatz unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","As tul ilej veꞌt umaꞌl u qꞌii, as jeꞌ veꞌt u Jesús viꞌ umaꞌl u vitz tiꞌ inachat Tiixh. As umaꞌl chit aqꞌbꞌal Aak tiꞌ inachat Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","As tul sajbꞌu veꞌteꞌ, as imolo veꞌt tzan Aak unqꞌa ichusulibꞌeꞌ. As itxaa veꞌt Aak kabꞌlaval unqꞌa ichusulibꞌeꞌ. As aꞌ chajnajeꞌ uveꞌ kat ikꞌujbꞌaꞌ veꞌt kan Aak apóstol. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Aꞌ u Simón uvaꞌ kat toksa Aak vibꞌii uvaꞌ Luꞌ, tukꞌ u Lixh uveꞌ titzꞌin tibꞌ tukꞌ u Simón, tukꞌ u Jacobo, tukꞌ u Xhun, tukꞌ u Piꞌl, tukꞌ u Bartolomé, ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","tukꞌ u Mateo, tukꞌ u Maxh, tukꞌ umaꞌt u Jacobo, vikꞌaol u Alfeo, tukꞌ umaꞌt u Simón uvaꞌ Selote chꞌelel, ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","tukꞌ u Judas, vikꞌaol u Jacobo, tukꞌ u Judas uvaꞌ Iscariote uveꞌ kꞌayin u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","As kuꞌ veꞌt chꞌuꞌl u Jesús viꞌ u vitzeꞌ tukꞌ unqꞌa apóstol as tukꞌ unqꞌa uxhchileꞌ uveꞌ nik ichus tibꞌ kꞌatz Aak. As txakebꞌ veꞌt chajaak xoꞌl unqꞌa tenameꞌ vatz umaꞌl u chaqꞌaala, tan molik tibꞌ unqꞌa uxhchileꞌ tiꞌ tabꞌit viyol Aakeꞌ. As at uxhchil tzaa tu u Judea, tu u Jerusalén, tukꞌ tu unqꞌa tzꞌaꞌla vitzeꞌ uvaꞌ tu u Tiro, tukꞌ tu u Sidón. As aꞌ nikat taleꞌ uvaꞌ la teesa Aak u chꞌoꞌmeꞌ stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","As jankꞌal unqꞌa uxhchileꞌ uveꞌ atik ok subꞌul skꞌatz, as nikat ibꞌaꞌnxisa veꞌt u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","As aꞌ chit mamaꞌla tenameꞌ nikat saꞌon ikanat u Jesús, tan atik vibꞌaꞌnil u Tiixheꞌ kꞌatz Aak. As nik ibꞌaꞌnxisa Aak unqꞌa aachꞌoꞌmeꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","As isaji veꞌt bꞌen u Jesús unqꞌa uxhchileꞌ uvaꞌ nik ichus tibꞌ kꞌatz Aak. As ech tal veꞌt Aak ileꞌ: —Achvebꞌal chit ex, jankꞌal ex uveꞌ ootzimal setaꞌn uvaꞌ techal chit la iloch ex u Tiixheꞌ, tan aꞌ exeꞌ uvaꞌ at etokebꞌal xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","As achvebꞌal chit ex, jankꞌal ex uveꞌ nivaꞌy vetaanxelaleꞌ tiꞌ viyol u Tiixheꞌ, tan aꞌ exeꞌ la iloch ex u Tiixheꞌ. As achvebꞌal chit ex, jankꞌal ex uveꞌ netoqꞌ scheel taꞌn txumuꞌm, tan aꞌ exeꞌ uvaꞌ la chiibꞌ veꞌt ex xamtel. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","As achvebꞌal chit ex, jankꞌal ex uveꞌ la ixval ex, as la tilul ex, as la yoqꞌpu veꞌt ex taꞌn unqꞌa uxhchileꞌ, as stiꞌ kuxh VIKꞌAOL U NAJEꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","As chiibꞌojtaj ex tu u qꞌiieꞌ tul ech la ulbꞌel exeꞌ, tan nimeꞌ vetxꞌajaꞌmeꞌ tuk aqꞌa xoj sete tu almikaꞌ. As chiibꞌojtaj ex kꞌuxh la epalebꞌe kꞌaxkꞌo, tan ech chit kat ulbꞌel unqꞌa qꞌajsan tetz viyol u Tiixheꞌ taꞌn unqꞌa qꞌesla ebꞌaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pet ech koj ex, uvaꞌ ex txꞌioliqꞌii, tan ¡oyebꞌ chit evatz! tan kat chiibꞌiy ex vatz u txꞌavaꞌeꞌ. Estiꞌeꞌ yeꞌl umaꞌtoj etxꞌajaꞌm la ekꞌuleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","¡As oyebꞌ chit evatz, jankꞌal ex uveꞌ yeꞌl etaanxelal nivaꞌyeꞌ tiꞌ viyol u Tiixheꞌ! tan tiꞌ uvaꞌ at veꞌt vetxꞌiibꞌal eqꞌiieꞌ. As xamtel as aꞌn la vaꞌy veꞌt vetaanxelaleꞌ. ¡As oyebꞌ chit evatz, jankꞌal ex uveꞌ netzeꞌlen cheel taꞌn chiibꞌichil! tan xamtel la txumun veꞌt vetaanxelaleꞌ. As la oqꞌ veꞌt ex. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","As ¡oyebꞌ chit evatz tul niyolbꞌe ex unqꞌa uxhchileꞌ skajayil tiꞌ toksal eqꞌii! tan ech kat ulbꞌel unqꞌa qꞌesla ebꞌaaleꞌ tul nikat toksa iqꞌii unqꞌa chulin yoleꞌ uvaꞌ nik toksa tibꞌ qꞌajsan tetz viyol u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","As jankꞌal ex uveꞌ ni niman vunyoleꞌ, as tuk val sete, xoꞌnoj unqꞌa uxhchileꞌ sete uveꞌ nichꞌoꞌn taama setiꞌ. Ebꞌantaj bꞌaꞌnil te unqꞌa uxhchileꞌ uveꞌ ni bꞌanon u vaꞌlexheꞌ sete. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","As bꞌaꞌnoj eyolon tiꞌ unqꞌa uxhchileꞌ uvaꞌ vaꞌlexh iyolon setiꞌ. As enachtaj Tiixh tiꞌ unqꞌa uxhchileꞌ uveꞌ nixeꞌt setiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Asoj la itzꞌich umaj uxhchil evatz, as etaqꞌtaj ok unjalit vevatzeꞌ. Asoj abꞌil la maon vexheerkaeꞌ, as etaqꞌtaj kan vekamiꞌxheꞌ unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","As abꞌil uvaꞌ la jajon umaj kam sete, as etaqꞌtaj ste. As abꞌil uvaꞌ la maon umaj etetz, as yeꞌ la eyaꞌlu uvaꞌ la iqꞌaavisa sete. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","As kam u bꞌaꞌnileꞌ uvaꞌ nesaꞌ uvaꞌ la ibꞌan unqꞌa uxhchileꞌ sete, as echat la ebꞌan te unqꞌa uxhchileꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","tan asoj aꞌ kuxh unqꞌa uxhchileꞌ xoꞌn sete uvaꞌ xoꞌn ex ste, as yeꞌ la oksal eqꞌii tiꞌ uveꞌ nebꞌaneꞌ, tan echat kuxh nibꞌan unqꞌa uxhchileꞌ uveꞌ yeꞌ ni niman u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Asoj aꞌ kuxh nebꞌankat bꞌaꞌnil te unqꞌa uxhchileꞌ uveꞌ ni bꞌanon u bꞌaꞌnileꞌ sete, as yeꞌ la oksal eqꞌii tiꞌ uveꞌ nebꞌaneꞌ, tan echat kuxh nibꞌan unqꞌa uxhchileꞌ uveꞌ yeꞌ ni niman u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Asoj aꞌ kuxh unqꞌa uxhchileꞌ la etaqꞌ ikꞌam uvaꞌ ootzimal setaꞌn uvaꞌ la iqꞌaavisa sete kam uvaꞌ kat ikꞌama, as yeꞌ la oksal eqꞌii tiꞌ uveꞌ la ebꞌaneꞌ, tan echat kuxh nibꞌan unqꞌa uxhchileꞌ uvaꞌ yeꞌ ni niman u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pet xoꞌnoj unqꞌa uxhchileꞌ sete uvaꞌ nichꞌoꞌn taama setiꞌ. Ebꞌantaj bꞌaꞌnil ste. Etaqꞌtaj ikꞌam unqꞌa uxhchileꞌ. Pet yeꞌ la etxꞌebꞌ ichꞌexel, aqꞌal uvaꞌ nim chit vetxꞌajaꞌmeꞌ la ekꞌuleꞌ. As ech ekꞌuchateꞌ uvaꞌ ex veꞌt meꞌal ikꞌaol u Tiixheꞌ uvaꞌ echen tu almikaꞌ, tan bꞌaꞌnla txumbꞌaleꞌ vitxumbꞌal Aakeꞌ tiꞌ unqꞌa jeꞌnaj vatzeꞌ tukꞌ unqꞌa paasan tziieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Estiꞌeꞌ ni val sete, etxumtaj chit ivatz unqꞌa uxhchileꞌ echeꞌ uveꞌ nibꞌan u Kubꞌaal Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Asoj yeꞌ la ebꞌan isuuchil vemooleꞌ, as yeꞌl ex la bꞌanax esuuchil taꞌn vemooleꞌ. Asoj yeꞌl ipaav vemooleꞌ la echukeꞌ, as yeꞌl epaav la chukpi taꞌn vemooleꞌ. Asoj la esotzsa ipaav unqꞌa emooleꞌ, as la sotzsal epaav unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Asoj ayaꞌl chit ekꞌuꞌl la eloch vemooleꞌ, as ayaꞌl chit ikꞌuꞌl u Tiixheꞌ la iloch ex Aak. As nimaleꞌ la taqꞌ Aak sete tiꞌ uveꞌ la etaqꞌ te vemooleꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","As tal veꞌt u Jesús umaꞌt u kꞌuchuvatz uvaꞌ ech ni tal ileꞌ: —Tan yeꞌ la itxꞌol umaj tzot ichꞌijil umaꞌt tzot, tan eela ikuꞌeꞌ skaabꞌil tu jul. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Yeꞌ la lejon itxumbꞌal umaj chusulibꞌ tiꞌ u chusul tetzeꞌ. As tul la tzojpu veꞌt ichusat tibꞌ u chusulibꞌeꞌ, as aꞌn la teqꞌo veꞌt vitxumbꞌal u chusul tetzeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿As kam qꞌi uveꞌ vaꞌl kuxh esajit ok u tal chꞌiseꞌ tu vivatz vetitzꞌin etatzikeꞌ, as tul yeꞌ netil jeꞌ etibꞌ, tul at umaꞌl u potzoꞌm tu vevatzeꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Tan asoj at umaꞌl u potzoꞌm tu vevatzeꞌ, as ¿la kol uch etalat qꞌa te: «Vetitzꞌin etatzikeꞌ, tuk veesa el tzan u chꞌiseꞌ tu vavatzeꞌ,» ma chaj ex la etaleꞌ? ¡Tul il u potzoꞌm ileꞌ atoꞌk tu vevatzeꞌ! ¡Ex kuxh kaꞌvatz! Eteesataj u potzoꞌmeꞌ tu vevatzeꞌ bꞌaxa. As aꞌn la uch etilat veꞌt u chꞌiseꞌ tivatz vetitzꞌin etatzikeꞌ. As la eteesa veꞌt el. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","As jit bꞌaꞌneꞌ u tzeꞌeꞌ uvaꞌ vaꞌlexh ivatz ni taqꞌeꞌ; as jit vaꞌlexh u tzeꞌeꞌ uvaꞌ bꞌaꞌn vivatzeꞌ ni taqꞌeꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","tan la exhlal unqꞌa tzeꞌeꞌ tul la vatzin tzeꞌ. As echeꞌ la koj uch quxat umaj higuera tiꞌ umaj chꞌiꞌx; as mitaꞌn la koj uch quxat umaj uuva tiꞌ umaj vokkin chꞌiꞌx. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Echat bꞌanel taꞌn unqꞌa uxhchileꞌ, tan u bꞌaꞌnla aamaeꞌ, as aꞌ kuxh unqꞌa bꞌaꞌnla chaj txumbꞌaleꞌ ni tel chꞌuꞌl tu u taanxelaleꞌ. Pet ech koj u uxhchileꞌ uvaꞌ vaꞌlexh vitxumbꞌaleꞌ, tan aꞌ kuxh u vaꞌlexheꞌ ni tel chꞌuꞌl tu u taanxelaleꞌ. As kam uveꞌ at tu u taanxelal u uxhchileꞌ, as aꞌeꞌ ni tal vitziꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿As kam qꞌi uveꞌ: «¡Kubꞌaal Jesús! ¡Kubꞌaal Jesús!» chu kuxh ex sve, tul yeꞌ nenima unqꞌa yoleꞌ uveꞌ ni val sete? ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Tuk val sete, tan jankꞌal u uxhchileꞌ uveꞌ ni tok chꞌuꞌl sunkꞌatz as ni tabꞌi vunyoleꞌ as ninima uveꞌ ni val ste, ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","as ech bꞌan taꞌn u uxhchileꞌ echeꞌ umaꞌl u naj uvaꞌ kat ilak vikabꞌaleꞌ, tan kat ikꞌot naj u juleꞌ. As nimal kat taqꞌ bꞌen naj u juleꞌ techal kat ilej naj u sivaneꞌ. As kat ichabꞌa naj taqꞌat bꞌen u tzꞌajeꞌ tetz u kabꞌaleꞌ viꞌ u sivaneꞌ. As tul kat ul veꞌt umaꞌl u mam jabꞌal, as kat sipkꞌu veꞌt unqꞌa jobꞌich aꞌeꞌ. As jankꞌal chit iyakꞌil u aꞌeꞌ kat ul iputzꞌ tibꞌ tiꞌ u kabꞌaleꞌ. As yeꞌl u kabꞌaleꞌ kat tiini, tan chabꞌamal ikꞌujebꞌ u kabꞌaleꞌ viꞌ u sivaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pet ech koj unqꞌa uxhchileꞌ uveꞌ ni abꞌin vunyoleꞌ, as yeꞌ ninima, tan ech bꞌan taꞌn unqꞌa uxhchileꞌ echeꞌ umaꞌt u naj uvaꞌ kat ilak vikabꞌaleꞌ viꞌ u sanabꞌeꞌ, tan yeꞌl tzꞌaj kat taqꞌ kan naj sjaqꞌ. As tul uvaꞌ kat sipkꞌu veꞌt unqꞌa jobꞌich aꞌeꞌ, as kat pal tija veꞌt u aꞌeꞌ u kabꞌaleꞌ. As txumlebꞌal chit teꞌp veꞌt u kabꞌaleꞌ kat ibꞌana,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","As tul yaꞌ veꞌt iyolon u Jesús xoꞌl unqꞌa tenameꞌ, as qꞌaavik veꞌt ok Aak tu u Capernaúm. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","As atik umaꞌl viqꞌesal unqꞌa sol tzitziꞌ uvaꞌ bꞌiitik kuxh ikam veꞌt umaꞌl vikꞌam taꞌn umaꞌl u chꞌoꞌm. As xoꞌnik chit vikꞌameꞌ ste. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","As tul tabꞌi veꞌt viqꞌesal unqꞌa soleꞌ itzibꞌlal u Jesús, as ichaj veꞌt bꞌen naj kaꞌl unqꞌa iqꞌesal unqꞌa tiaal Israel tiꞌ bꞌen ijajat veꞌt chajnaj bꞌaꞌnil te u Jesús tiꞌ uvaꞌ la ul ibꞌaꞌnxisa Aak vikꞌam viqꞌesal unqꞌa soleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","As tul oon veꞌt unqꞌa iqꞌesal unqꞌa tiaal Israel kꞌatz u Jesús, as ijaj veꞌt chajnaj kuybꞌal te Aak. As ech tal veꞌt chajnaj ileꞌ te Aak: —La kujaj umaꞌl u bꞌaꞌnil see, pap, tiꞌ uvaꞌ la bꞌen abꞌaꞌnxisa umaꞌl vikꞌam viqꞌesal unqꞌa soleꞌ, tan bꞌaꞌneꞌ uvaꞌ la abꞌan bꞌaꞌnil te naj, tan bꞌaꞌn itxumbꞌal naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","As xoꞌn chit u kutenameꞌ te naj. As najeꞌ kat bꞌanon isuuchil tiꞌ ilakpu u atinbꞌaleꞌ tetz nachbꞌal Tiixh,— tiꞌk chajnaj tal te u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","As bꞌen veꞌt u Jesús tiꞌ chajnaj. As tul bꞌiitik toon veꞌt Aak kꞌatz vikabꞌal viqꞌesal unqꞌa soleꞌ, as ichaj veꞌt tzan viqꞌesal unqꞌa soleꞌ kaꞌl unqꞌa tetz kꞌultziꞌ. As ech ul tal chajnaj ileꞌ: —Pap, ni tal tzan viqꞌesal unqꞌa soleꞌ see uvaꞌ yeꞌ kuxh la akoolisa eebꞌ tiꞌ oon tikabꞌal aak. As jit tetz aak uvaꞌ la oon axh tu vikabꞌal aak, tan nim aalcheꞌ tiꞌ aak uvaꞌ ni taleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","As yeꞌl tijleꞌm aak at pal seeꞌ. Estiꞌeꞌ yeꞌ ni tul aak savatz. Pet asoj la abꞌan bꞌaꞌnil, as la kuxh aal bꞌen u yoleꞌ tiꞌ ibꞌaꞌnxisal vikꞌam aakeꞌ. As tuk bꞌaꞌnxojeꞌ vikꞌameꞌ uvaꞌ ni taleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","As ni tal aak uvaꞌ at ibꞌooqꞌol aak uvaꞌ techal ninima aak. As at isol aak unpajte uvaꞌ techal ninima kam ni tal aak ste, tan asoj la tal aak te umaj visoleꞌ: «Kuxh bꞌen,» chaj aak ste, as maꞌte. Asoj: «Siꞌu,» chaj aak te umaꞌt naj, as techal la ul naj vatz aak. Asoj la tal aak te umaj vikꞌameꞌ: «Bꞌan u viꞌleꞌ,» chaj aak ste, as nibꞌaneꞌ,— tiꞌk chajnaj tal te u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","As tul tabꞌi veꞌt u Jesús u yoleꞌ uvaꞌ tal tzan viqꞌesal unqꞌa soleꞌ, as txuqꞌtxun veꞌt Aak stiꞌ. As isuchqꞌi veꞌt tibꞌ Aak tiꞌ isajit bꞌen unqꞌa tenameꞌ uveꞌ xekik tiꞌ Aak. As ech tal veꞌt Aak ileꞌ: —Ileꞌ jik chit tuk val sete, tan yeꞌl umaj naj vileꞌte xoꞌl unqꞌa tiaal Israel uvaꞌ ech ikꞌujbꞌaꞌt ikꞌuꞌleꞌ sviꞌ echeꞌ nibꞌan viqꞌesal unqꞌa soleꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","As tul qꞌaav veꞌt unqꞌa najeꞌ tikabꞌal viqꞌesal unqꞌa soleꞌ, as bꞌaꞌnik veꞌt vikꞌam najeꞌ, tul oon veꞌt chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","As bꞌen veꞌt u Jesús tu umaꞌt u tenam uvaꞌ Nain. As nimalik unqꞌa ichusulibꞌ Aakeꞌ xekik stiꞌ tukꞌ unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","As bꞌiitik kuxh toon veꞌt u Jesús tziꞌ u tenameꞌ. As til veꞌt Aak uvaꞌ chelemalik umaꞌl u kamnaj, tal umaꞌl u txakay ixoj. As taꞌn chiteꞌ unchꞌiꞌtil u tal u ixojeꞌ. As aꞌ chit mamaꞌla tenameꞌ xekik tiꞌ ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","As til veꞌt Aak u ixojeꞌ. As itxum veꞌt Aak ivatz ixoj. As ech tal veꞌt Aak ileꞌ: —Yeꞌ kuxh oqꞌ axh,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","As jetzꞌen veꞌt ok Aak kꞌatz unqꞌa uxhchileꞌ uveꞌ chelen tetz u kamnajeꞌ. As ikan veꞌt ok Aak vikaaxha u kamnajeꞌ. As txakebꞌ veꞌt chajnaj. As ech tal veꞌt Aak ileꞌ te u kamnajeꞌ: —Chelem xaak, ileꞌ tuk val see, ¡Txakpen!— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","As ul veꞌt taama u xaakeꞌ. As xonebꞌ veꞌt naj. As xeꞌt veꞌt naj yolon. As ech tal veꞌt u Jesús ileꞌ te vitxutx u xaakeꞌ: —As taqꞌ veꞌt ok Aak u xaakeꞌ te vitxutxeꞌ Il vaval ileꞌ kat ulyu taama,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","As teqꞌo veꞌt taama unqꞌa uxhchileꞌ skajayil taꞌn uveꞌ ibꞌan u Jesús. As ech tal veꞌt unqꞌa uxhchil ileꞌ tiꞌ toksal iqꞌii u Tiixheꞌ: —¡Kat ulyu veꞌt umaꞌl u qꞌajsan tetz viyol u Tiixheꞌ sukuxoꞌl uvaꞌ nim chit talcheꞌ! As aꞌ u Tiixheꞌ kat ulyu veꞌt sukuxoꞌl tiꞌ kulochpeꞌ,— tiꞌk unqꞌa uxhchileꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","As oora kuxh pax veꞌt itzibꞌlal u Jesús tulaj unqꞌa tenameꞌ tu u Judea as tulaj unqꞌa koꞌmeꞌ unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","As tul tabꞌi veꞌt u Xhuneꞌ itzibꞌlal u Jesús kam uveꞌ nik ibꞌan Aak, as imolo veꞌt tzan u Xhuneꞌ kaꞌvaꞌl unqꞌa ichusulibꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","As ichaj veꞌt bꞌen u Xhuneꞌ chajnaj kꞌatz u Jesús tiꞌ ichꞌotit chajnaj ste: —¿Ma axh u Cristo uvaꞌ alel kan uvaꞌ la uli? ¿Pet moj latel kutxꞌebꞌ tul umaꞌtoj uxhchil? chaj ex la etaleꞌ,— tiꞌk u Xhuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","As tul oon veꞌt chajnaj kꞌatz u Jesús, as ech tal veꞌt chajnaj ileꞌ: —Aꞌ u Xhuneꞌ uveꞌ nikat aqꞌon kuꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ, as kat ichaj tzan oꞌ tiꞌ kuchꞌotit see uvaꞌ: «¿Ma axh u Cristo uvaꞌ alel kan uvaꞌ la uli? ¿Pet moj latel kutxꞌebꞌ tul umaꞌtoj uxhchil?»— tiꞌk chajnaj tal te u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","As tul aꞌs chit ibꞌaꞌnxisat Aak unqꞌa aachꞌoꞌmeꞌ, as nik ibꞌaꞌnxisa veꞌt Aak unqꞌa uxhchileꞌ uveꞌ nik ipalebꞌe unqꞌa kꞌaxkꞌoeꞌ taꞌn unqꞌa subꞌuleꞌ. As yeꞌ saach unqꞌa tzoteꞌ kat ilon veꞌt taꞌn Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","As ech tal veꞌt Aak ileꞌ te unqꞌa ichusulibꞌ u Xhuneꞌ: —Bꞌenoj etaltaj te u Xhuneꞌ kam uveꞌ kat etila as kam uveꞌ kat etabꞌi, tan ni tilon veꞌt unqꞌa uxhchileꞌ uvaꞌ tzotike; as nixaan veꞌt unqꞌa uxhchileꞌ uvaꞌ koꞌxike; as unqꞌa uxhchileꞌ uveꞌ atik ok chꞌaꞌk chin stiꞌ, as kat txanyu veꞌteꞌ; as ni tabꞌin veꞌt unqꞌa uxhchileꞌ uvaꞌ yeꞌ nik tabꞌineꞌ; as kat ulyu veꞌt taama unqꞌa kamnajeꞌ. As ni talax veꞌt u bꞌaꞌnla yoleꞌ te unqꞌa meebꞌaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","As achvebꞌal chit u uxhchileꞌ uvaꞌ yeꞌ la kaꞌkabꞌin taama tiꞌ ikꞌujbꞌaꞌt ikꞌuꞌl sviꞌ,— tiꞌk u Jesús tal te chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","As qꞌaav veꞌt unqꞌa ichusulibꞌ u Xhuneꞌ. As tal veꞌt u Jesús isuuchil u yoleꞌ tiꞌ u Xhuneꞌ xoꞌl unqꞌa tenameꞌ. As ech tal veꞌt Aak ileꞌ: —¿Kam kat bꞌex etil tiꞌ u Xhuneꞌ, tul atik tu u tzuukin txꞌavaꞌeꞌ? ¿Ma kat bꞌex etil umaj uxhchil uvaꞌ ech vitxumbꞌaleꞌ echeꞌ viꞌoj aa uvaꞌ niliiqꞌaꞌch taꞌn u kajiqꞌeꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Pet moj kat bꞌex etil umaj uxhchil uvaꞌ vejel chit tibꞌ tukꞌ u toksaꞌmeꞌ? Yeꞌle taꞌ, tan jankꞌal unqꞌa najeꞌ uveꞌ vejel chit tibꞌ tukꞌ u toksaꞌmeꞌ, as aꞌ kuxh atkat chajnajeꞌ tulaj ikabꞌal unqꞌa ijlenaaleꞌ. As nimal bꞌaꞌnla chaj kam at xeꞌ chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Pet kam kat bꞌex etil tiꞌ u Xhuneꞌ? ¿As moj umaj u qꞌajsan tetz viyol u Tiixheꞌ kat etila? Kano. An chiteꞌ, tan qꞌajsan tetz viyol u Tiixheꞌ u Xhuneꞌ. As at pal u Xhuneꞌ tiꞌ unjoltu unqꞌa qꞌajsan tetz viyol u Tiixheꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","tan aꞌ u Xhuneꞌ uvaꞌ ni tal u yoleꞌ uvaꞌ tzꞌibꞌamal kan uvaꞌ ech ni tal ileꞌ: Tuk unbꞌaxsa bꞌen umaꞌl u alol tetz vunyoleꞌ savatz. As aꞌeꞌ la bꞌanon tuch u bꞌeyeꞌ savatz, tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","As tuk val sete, tan yeꞌl umaꞌtoj vatz txꞌavaꞌilla uxhchil kat itzꞌebꞌi uvaꞌ qꞌajsan tetz viyol u Tiixheꞌ, uvaꞌ nim talchu tiꞌ u Xhuneꞌ uvaꞌ nik aqꞌon kuꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ. Pet abꞌil uvaꞌ at tokebꞌal xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ, as aꞌ uxhchileꞌ uvaꞌ at pal tiꞌ u Xhuneꞌ, kꞌuxh yeꞌl tijleꞌm ati,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","As tul tabꞌi veꞌt unqꞌa uxhchileꞌ viyol u Jesús tukꞌ unqꞌa najeꞌ uvaꞌ ni molon u puaj tetz u Roma, as ech tal ileꞌ: «Jik chit itxumbꞌal u Tiixheꞌ,» tiꞌke, tan maꞌtik ikuꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ taꞌn u Xhuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pet ech koj unqꞌa fariseo tukꞌ unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, tan yeꞌ kat inima chajnaj kam uvaꞌ nikat isaꞌ u Tiixheꞌ tiꞌ chajnaj. As yeꞌ kat isaꞌ veꞌt chajnaj uvaꞌ la taqꞌ kuꞌ u Xhuneꞌ chajnaj xeꞌ u aꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","As ech tal veꞌt u Kubꞌaal Jesús ileꞌ te chajnaj: —¿As abꞌiste qꞌi la unbꞌan eela tukꞌ u txumbꞌaleꞌ uveꞌ nebꞌaneꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Tan eela kuxh vetxumbꞌaleꞌ tukꞌ unqꞌa xaakeꞌ uveꞌ xonleꞌl tu kꞌayibꞌal. As nisikꞌineꞌ tul nisaacheꞌ. As ech ni tal ileꞌ svatzaj: «Kꞌuxh kat qoqꞌsa unqꞌa aaeꞌ sevatz, as yeꞌl ex kat bꞌix ex. As kꞌuxh kat kubꞌitza unqꞌa bꞌitzeꞌ uvaꞌ txumlebꞌal chittuꞌ, as yeꞌl ex kat oqꞌ ex,» tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","As tul kat ul u Xhuneꞌ, as nik ikuy ivaꞌy. As yeꞌ nik tukꞌa u taꞌl u uuvaeꞌ. As kat eteesa iqꞌii, tan kat etala uvaꞌ subꞌul atik ok skꞌatz. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","As tul kat ul VIKꞌAOL U NAJEꞌ, as nitxꞌaꞌneꞌ, as ni tukꞌa u taꞌl u uuvaeꞌ. As netal veꞌt stiꞌ uvaꞌ bꞌichꞌ uul chittuꞌ, as tetz kꞌultziꞌ tibꞌ tukꞌ unqꞌa molol puajeꞌ tetz u Roma, as tukꞌ unqꞌa uxhchileꞌ uvaꞌ aapaav sevatz. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pet ech koj uveꞌ la val sete, tan aꞌ la etexhlakat u jikla txumbꞌaleꞌ tiꞌ uveꞌ nunbꞌaneꞌ as tukꞌ uveꞌ kat ibꞌan u Xhuneꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","As ijaj veꞌt umaꞌl u fariseo bꞌaꞌnil te u Jesús uvaꞌ la bꞌen Aak txꞌaꞌnoj tikabꞌal naj. As tul oon Aak tikabꞌal naj, as xonebꞌ veꞌt ok Aak kꞌatz u meexhaeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","As atik umaꞌl u yanaꞌsla ixoj tu u tenameꞌ. Tul tabꞌi veꞌt ixoj uvaꞌ nikat itxꞌaꞌn u Jesús tikabꞌal u fariseo uvaꞌ Simón, as teqꞌo veꞌt ixoj u txꞌumtxꞌulla tzꞌakabꞌaleꞌ tu umaꞌl u bꞌaꞌnla lemeeta. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","As pesebꞌ veꞌt ok ixoj kꞌatz toj u Jesús. As xeꞌt ixoj oqꞌoj. As itxꞌaa ixoj u tiꞌ toj Aakeꞌ taꞌn u taꞌl ivatzeꞌ. As itzajsa veꞌt ixoj taꞌn u xiꞌl iviꞌeꞌ. As itzꞌubꞌ veꞌt ixoj u tiꞌ toj Aakeꞌ tul nik toksa ixoj u txꞌumtxꞌulla tzꞌakabꞌaleꞌ tiꞌ u toj Aakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","As u fariseo uvaꞌ kat saꞌbꞌelan u Jesús tiꞌ u txꞌaꞌoꞌmeꞌ, as tul kat til naj uvaꞌ kam kat ibꞌan u ixojeꞌ, as kat titzꞌa naj «Asoj qꞌajsan tetz viyol u Tiixheꞌ u najeꞌ, as la tootzi najeꞌ taꞌ uvaꞌ eesan kuxh tibꞌ u ixojeꞌ tu bꞌey. As tul nu kuxh ikanoꞌk ixoj naj.» ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","As ech tal veꞌt u Jesús ileꞌ te u fariseo: —Simón, tuk val umaꞌl u yol see,— tiꞌk u Jesús. —Al bꞌa sve, Chusul,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","As ech tal veꞌt u Jesús ileꞌ te naj: —Atik kaꞌvaꞌl u naj uvaꞌ atik itxꞌoj xeꞌ umaꞌl u naj uvaꞌ nik aqꞌon puaj skꞌam. As umaꞌl naj vinaj oꞌl kꞌalal (500) qꞌii aqꞌon itxꞌoj naj atike; umaꞌt naj laval toxkꞌal (50) kuxh qꞌii aqꞌon itxꞌoj naj unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","As isotzsa kuxh veꞌt u najeꞌ ipaav chajnaj skaabꞌil tiꞌ vitxꞌojeꞌ, tan yeꞌ nikat tolebꞌ chajnaj tiꞌ ichooat vitxꞌojeꞌ. As al sve, Simón, ¿abꞌiste kaꞌvaꞌl u najeꞌ uvaꞌ atik itxꞌoj uvaꞌ maas kat xoꞌnin veꞌt u najeꞌ uveꞌ kat sotzsan vipaav chajnaj tiꞌ vitxꞌojeꞌ?— tiꞌk u Jesús tal te u Simón. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","As ech tal veꞌt u Simón ileꞌ: —Aꞌ u najeꞌ uveꞌ nimal itxꞌoj atike, as aꞌ najeꞌ kat xoꞌnin veꞌt u najeꞌ uveꞌ nimal ipaav kat sotzsali,— tiꞌk u Simón. —An chiteꞌ taꞌ uveꞌ naaleꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","As isuchqꞌi veꞌt tibꞌ Aak. As ikaꞌya veꞌt Aak u ixojeꞌ. Ech tal veꞌt Aak ileꞌ te u Simón: —¿Ma kat eellaꞌ kam uvaꞌ kat ibꞌan u ixojeꞌ? Tan tul kat ok chꞌuꞌl in tu vakabꞌaleꞌ, as yeꞌ kat aaqꞌ unbꞌooj txꞌaabꞌal tiꞌ voj. Pet ech koj ixoj, tan kat itxꞌaal veꞌt ixoj u tiꞌ vojeꞌ taꞌn u taꞌl ivatzeꞌ. As kat itzajsal ixoj taꞌn u xiꞌl iviꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","As mitaꞌn yeꞌ kat atzꞌubꞌ txala untziꞌ tul kat ok chꞌuꞌl in tu vakabꞌaleꞌ. Pet ech koj u ixojeꞌ, tan yeꞌ niyaꞌsa ixoj itzꞌubꞌat u tiꞌ vojeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","As yeꞌl umaj txꞌumtxꞌulla tzꞌakabꞌal kat ooksa sviꞌ. Pet ech koj u ixojeꞌ, tan kat toksal veꞌt ixoj u txꞌumtxꞌulla tzꞌakabꞌaleꞌ tiꞌ u vojeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","As tuk val see, Simón: Kat sotzyu veꞌt vipaav u ixojeꞌ. Pet atik skꞌuꞌl ixoj uvaꞌ nimal chit vipaav ixoj atike. Estiꞌeꞌ uvaꞌ tul kat unsotzsa ipaav ixoj, as maas chit xoꞌn veꞌt in te ixoj. Pet abꞌil uveꞌ bꞌiil kuxh vipaaveꞌ ni tal jeꞌ ste, as tul kat unsotzsa veꞌt vipaaveꞌ, as bꞌiil kuxh kat ixoꞌni veꞌt in u uxhchileꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","As ech tal veꞌt u Jesús ileꞌ te ixoj: —Kat sotzyu veꞌt vapaaveꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","As ech tal veꞌt jeꞌ unjoltu unqꞌa uxhchil ileꞌ ste uveꞌ atik ok vatz u meexhaeꞌ kꞌatz u Jesús: —¿Kam tijleꞌmeꞌ qꞌi u najeꞌ tiꞌ uvaꞌ nisotzsa naj ipaav unqꞌa uxhchileꞌ uveꞌ ni taleꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","As ech tal veꞌt u Jesús ileꞌ te ixoj: —Kat qꞌalpiy axh vatz vapaaveꞌ, tan tiꞌ uvaꞌ kat akꞌujbꞌaꞌ akꞌuꞌl sviꞌ. As bꞌaꞌn veꞌt aatin tukꞌ u Tiixheꞌ tukꞌ vachiꞌoleꞌ tiꞌ abꞌeneꞌ— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","As xamtik veꞌt stuul, as nikat ixaan veꞌt u Jesús tukꞌ kabꞌlaval unqꞌa ichusulibꞌeꞌ tulaj unqꞌa tenameꞌ as tulaj unqꞌa talaj tenameꞌ. As nikat ipaxsa veꞌt Aak u bꞌaꞌnla yoleꞌ tiꞌ tok unqꞌa uxhchileꞌ xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","As xekik kaꞌl unqꞌa ixoj tiꞌ u Jesús uvaꞌ maꞌtik teesat Aak unqꞌa subꞌuleꞌ skꞌatz tukꞌ kaꞌt unqꞌa chꞌoꞌmeꞌ. As antik u Maꞌleꞌ uvaꞌ aa Magdala uvaꞌ maꞌtik teesat Aak vujvaꞌl unqꞌa subꞌuleꞌ skꞌatz. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","As antik u Xhiveꞌ uveꞌ xekik tiꞌ u Jesús, u tixqel u Chusa uvaꞌ kꞌujlike tiꞌ tilat unqꞌa tetz u ijlenaaleꞌ uvaꞌ Herodes. As antik u Susana tukꞌ kaꞌt unqꞌa ixoj unpajte. Aꞌ chaꞌmaeꞌ nikat lochon u Jesús tukꞌ unqꞌa txꞌiibꞌal iqꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Yeꞌ saach unqꞌa uxhchileꞌ kat tzaa tulaj unqꞌa tenameꞌ. As kat imol tibꞌ tiꞌ u Jesús. As ech tal veꞌt Aak ileꞌ tul tal Aak umaꞌt u kꞌuchuvatz: ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Bꞌex veꞌt umaꞌl u naj avoj. As tul av naj, as at unqꞌa iiaeꞌ uvaꞌ echik toon tu bꞌey. As kat pachꞌli. As tul ul veꞌt unqꞌa tzꞌikineꞌ tu almikaꞌ, as ijuna veꞌt txoo. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","As at unqꞌa iiaeꞌ uvaꞌ kat oon xoꞌl kꞌubꞌ. As tul kat bꞌuuqꞌi, as oora chit kat tzaj veꞌteꞌ, tan tiꞌ uvaꞌ tzaji kuxh u txꞌavaꞌeꞌ xoꞌl unqꞌa kꞌubꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","As at unqꞌa iiaeꞌ ech toon xoꞌl unqꞌa chꞌiꞌxeꞌ. As tul kat bꞌuuqꞌi, as eela ichꞌii tukꞌ u chꞌiꞌxeꞌ. As kat isoka veꞌt unqꞌa chꞌiꞌxeꞌ u chikoeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","As at unqꞌa iiaeꞌ ech toon tu bꞌaꞌnla txꞌavaꞌ. As tul kat bꞌuuqꞌi, as oꞌkꞌalal (100) ivatz tiꞌ junun viꞌl kat taqꞌa,— tiꞌk u Jesús. As tul nik tal Aak unqꞌa yoleꞌ, as taqꞌ veꞌt jeꞌ Aak tuul iviꞌ. As ech tal veꞌt Aak ileꞌ: —Abꞌiste ex uvaꞌ nepal tu vunyoleꞌ, as etabꞌitaj uveꞌ ni valeꞌ,— tiꞌk u Jesús tal xoꞌl unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","As ichꞌoti veꞌt unqꞌa ichusulibꞌ u Jesús uvaꞌ kam isuuchil u kꞌuchuvatzeꞌ uveꞌ nik tal Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ech tal veꞌt u Jesús ileꞌ: —As sete tuk valkat isuuchil uvaꞌ yeꞌxhebꞌil ootzin tetz tiꞌ uvaꞌ kam tok unqꞌa uxhchileꞌ xoꞌl vitenam u Tiixheꞌ uvaꞌ ni til Aak isuuchil. Pet tukꞌ kuxh kꞌuchuvatz nunchusunkat xoꞌl unqꞌa tenameꞌ. Estiꞌeꞌ uvaꞌ kꞌuxh ni tileꞌ kam uveꞌ nunbꞌaneꞌ, as kꞌuxh ni tabꞌi unqꞌa yoleꞌ uvaꞌ ni valeꞌ, as yeꞌ nipal stuul. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","As ech isuuchil u kꞌuchuvatz ileꞌ uveꞌ kat vala: Tan unqꞌa iiaeꞌ uveꞌ kat vala, as aꞌeꞌ viyol u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","As unqꞌa iiaeꞌ uveꞌ ech toon tu bꞌey, as aꞌ ni tokkateꞌ tiꞌ unqꞌa uxhchileꞌ uveꞌ ni abꞌin viyol u Tiixheꞌ. As tul maꞌt tabꞌit u yoleꞌ, as kat ul u txꞌiꞌlanajeꞌ tiꞌ teesat el u yoleꞌ tu u taanxelal u uxhchileꞌ. Estiꞌeꞌ uvaꞌ yeꞌ ninima u uxhchileꞌ viyol u Tiixheꞌ. As yeꞌ la sotz veꞌt ipaav. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","As unqꞌa iiaeꞌ uveꞌ ech toon xoꞌl unqꞌa kꞌubꞌeꞌ, as aꞌ ni tokkateꞌ tiꞌ unqꞌa uxhchileꞌ uveꞌ ni abꞌin viyol u Tiixheꞌ. As tul ni tabꞌi u yoleꞌ, as nichiibꞌ stiꞌ. As ni tok u yoleꞌ tu u taanxelal. As ech unqꞌa uxhchileꞌ echeꞌ u iiaeꞌ uvaꞌ yeꞌ kat palik bꞌen u taqꞌileꞌ tu u txꞌavaꞌeꞌ, tan yeꞌ kat yakꞌin u yoleꞌ tu u taanxelal unqꞌa uxhchileꞌ. As yeꞌxh jatvaꞌl qꞌii kat inima u yoleꞌ, tan tul kat ul unqꞌa kꞌaxkꞌoeꞌ tiꞌ unqꞌa uxhchileꞌ, as kat teesa veꞌt kan tibꞌ tiꞌ u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","As unqꞌa iiaeꞌ uveꞌ ech toon xoꞌl unqꞌa chꞌiꞌxeꞌ, as aꞌ ni tokkateꞌ tiꞌ unqꞌa uxhchileꞌ uveꞌ kat abꞌin viyol u Tiixheꞌ. As tul kat pal veꞌt unqꞌa qꞌiieꞌ, as kat sotz veꞌt viyol u Tiixheꞌ tu u taanxelal unqꞌa uxhchileꞌ, tan nu kuxh ixaansa taama tiꞌ unqꞌa veeꞌ vatz u txꞌavaꞌeꞌ, tukꞌ tiꞌ u txꞌiibꞌal qꞌiieꞌ, as tukꞌ u tachaꞌv vichiꞌoleꞌ. Estiꞌeꞌ yeꞌ kat yakꞌin u yoleꞌ tu u taanxelaleꞌ echeꞌ umaj tzeꞌ uvaꞌ yeꞌ nivatzineꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pet ech koj unqꞌa iiaeꞌ uveꞌ ech toon tu u bꞌaꞌnla txꞌavaꞌeꞌ, tan aꞌ ni tokkateꞌ tiꞌ unqꞌa uxhchileꞌ uvaꞌ bꞌaꞌn itxumbꞌal, as yeꞌl u vaꞌlexheꞌ ni titzꞌa, as ni toksa taama tiꞌ inimat unqꞌa yoleꞌ uvaꞌ nichuspu ste. As niyakꞌin veꞌt u yoleꞌ tu u taanxelal unqꞌa uxhchileꞌ. As kꞌuxh kam kuxh nipalebꞌe, as yeꞌ niyaꞌsa inimataꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","As tul la imatx umaj uxhchil umaj xamal, as yeꞌ la uchi uvaꞌ la imuj u xamaleꞌ jaqꞌ umaj ukꞌal moj jaqꞌ umaj chꞌach. Pet la aqꞌax jeꞌ viꞌ u matxbꞌaleꞌ. As abꞌil uvaꞌ la ok tu u kabꞌaleꞌ, as la til veꞌt u uxhchileꞌ u xamaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","As echat tuk ibꞌan unqꞌa yoleꞌ uveꞌ ni val sete, tan jankꞌal unqꞌa yoleꞌ uvaꞌ yeꞌxhebꞌil ootzinik tetz as techal la ootzili. As jankꞌal unqꞌa yoleꞌ uvaꞌ mujelike as techal la ootzil veꞌt cheel, tan techal la el chꞌuꞌl vatz u sajeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","As etabꞌitaj u yoleꞌ uveꞌ ni valeꞌ, tan abꞌil uvaꞌ ni toksa taama tiꞌ inimat u yoleꞌ, kꞌuxh bꞌiil kuxh nipal stuul, as aal la chee itxumbꞌal stiꞌ. Pet ech koj u uxhchileꞌ uvaꞌ yeꞌ ni toksa taama tiꞌ tabꞌit u yoleꞌ as tukꞌ tiꞌ inimataꞌ, as aal la sotzsal veꞌt u yoleꞌ skꞌuꞌl uvaꞌ nipal stuul, uvaꞌ ni tal jeꞌ ste,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","As oon veꞌt vitxutx u Jesús tukꞌ unqꞌa titzꞌin Aakeꞌ. As jit uch tok chaꞌma kꞌatz u Jesús, tan aꞌ chit mamaꞌla tenameꞌ atik ok kꞌatz Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","As bꞌex alpo te Aak uvaꞌ: —Il ak atxutx at tiꞌeꞌl kabꞌal tukꞌ unqꞌa eetzꞌineꞌ. As nisaꞌ aak iyolon see,— tiꞌk chꞌelel u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","As ech tal veꞌt Aak ileꞌ: —Jankꞌal unqꞌa uxhchileꞌ uveꞌ ni abꞌin viyol u Tiixheꞌ as ninima, as ech tatineꞌ echeꞌ untxutx, as ech tatineꞌ echeꞌ vitzꞌin,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","As tu umaꞌl u qꞌii, as ok veꞌt u Jesús tukꞌ unqꞌa ichusulibꞌeꞌ tu umaꞌl u barco. As ech tal veꞌt Aak ileꞌ te chajnaj: —Koꞌnaj jalit u mar,— tiꞌk Aak. As bꞌen veꞌt Aak tukꞌ chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","As tul nik ixaan veꞌt u barco viꞌ u aꞌeꞌ, as vat veꞌt u Jesús. As xeꞌt veꞌt umaꞌl u mam kajiqꞌ viꞌ u mar. As vaꞌlik chit ipilqꞌut veꞌt tibꞌ u aꞌeꞌ taꞌn u kajiqꞌeꞌ. As mamaꞌla kꞌaxkꞌo nik ipalebꞌe unqꞌa ichusulibꞌ Aakeꞌ, tan bꞌiit kuxh yeꞌ nik inoo veꞌt u barco taꞌn u aꞌeꞌ. As bꞌiit kuxh yeꞌ nikat ibꞌen u barco xeꞌ u aꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","As bꞌex ibꞌey veꞌt chajnaj u Jesús. As ech tal veꞌt chajnaj ileꞌ te Aak: —¡Chusul! ¡Chusul! ¡Tuk bꞌenoj veꞌt oꞌ xeꞌ u aꞌeꞌ!— tiꞌk chajnaj. As txakpu veꞌt u Jesús. As iyaa veꞌt Aak u kajiqꞌeꞌ tukꞌ u aꞌeꞌ. As yak kuxh tanebꞌ veꞌt u kajiqꞌ jabꞌaleꞌ. As liibꞌ veꞌt u mar. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","As ech tal veꞌt u Jesús ileꞌ te chajnaj: —¿Kam kat ebꞌana uvaꞌ yeꞌ kat ekꞌujbꞌaꞌ ekꞌuꞌl sviꞌ?— tiꞌk Aak. As vaꞌlik chit ixoꞌv veꞌt chajnaj. As samun kuxh veꞌt chajnaj tiꞌ uveꞌ ibꞌan u Jesús. As ech tal veꞌt chajnaj ileꞌ svatzaj: —¡Nim chit u tijleꞌm Aakeꞌ, tan ninimal Aak taꞌn u kajiqꞌ jabꞌaleꞌ tukꞌ u mar, tul ni tal Aak umaj yol ste!— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","As oon veꞌt u Jesús tukꞌ chajnaj tu vitxꞌavaꞌ unqꞌa aa Gadara uvaꞌ echen jalit u mar tu u Galilea. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","As tul el veꞌt chꞌuꞌl u Jesús tu u barco tukꞌ chajnaj, as ul veꞌt umaꞌl u naj uvaꞌ aa Gadara tiꞌ ikꞌulpu Aak. As yeꞌl toksaꞌm naj atik ok staꞌn, tan naꞌxnik tok veꞌt subꞌul skꞌatz. As yeꞌl naj jejleꞌl koj tu umaj kabꞌal. Pet aꞌ kuxh atikkat naj tu uveꞌ nik imujlukat unqꞌa kamnajeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","As tul kuxh til veꞌt naj Aak, as kuꞌ naj qaaloj vatz Aak. As taqꞌ veꞌt jeꞌ naj tuul iviꞌ. As ech tal naj ileꞌ: —¿Kam asaꞌ sve, Jesús, iKꞌaol Tiixh uvaꞌ at tu almikaꞌ uvaꞌ nim talcheꞌ? Bꞌan bꞌaꞌnil sve. Yeꞌ aqꞌ bꞌen in tu kꞌaxkꞌoeꞌ,— tiꞌk naj, ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","tan tiꞌ uvaꞌ maꞌtik talat u Jesús uvaꞌ la el u subꞌuleꞌ kꞌatz u najeꞌ, tan naꞌxnik tok veꞌt u subꞌuleꞌ kꞌatz naj. As kꞌuxh jatpajul kuxh nikat iqitzpu iqꞌabꞌ naj tukꞌ toj naj taꞌn kateena, as nikat iratꞌ naj u kateenaeꞌ. As nikat teqꞌo u subꞌuleꞌ naj tulaj unqꞌa tzuukin txꞌavaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","As ech tal veꞌt u Jesús ileꞌ te u subꞌuleꞌ: —¿Kam abꞌii?— tiꞌk Aak. As ech tal veꞌt u subꞌul ileꞌ: —Legión unbꞌii,— tiꞌk u subꞌuleꞌ, tan tiꞌ uvaꞌ yeꞌ saach ixaan unqꞌa subꞌuleꞌ uveꞌ atik ok kꞌatz naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","As ijaj veꞌt unqꞌa subꞌuleꞌ kuybꞌal te u Jesús uvaꞌ yeꞌ la ichaj bꞌen Aak unqꞌa subꞌuleꞌ tu nimla tokkin juleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","As atik unjolol unqꞌa chicham uveꞌ nikat ikꞌuachineꞌ vatz umaꞌl u tal vitz. As ijaj veꞌt unqꞌa subꞌuleꞌ kuybꞌal te u Jesús uvaꞌ la ok unqꞌa subꞌuleꞌ tiꞌ unqꞌa chichameꞌ. As taqꞌ veꞌt Aak tokebꞌal unqꞌa subꞌuleꞌ tiꞌ unqꞌa chichameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","As el veꞌt chꞌuꞌl unqꞌa subꞌuleꞌ kꞌatz u najeꞌ. As ok veꞌt unqꞌa subꞌuleꞌ tiꞌ unqꞌa chichameꞌ. As ooj veꞌt txoo skajayil. As isuti veꞌt bꞌen tibꞌ txoo xeꞌ u mar taꞌn unqꞌa subꞌuleꞌ. As kam veꞌt txoo skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","As tul til veꞌt unqꞌa xeen chichameꞌ ikam unqꞌa chichameꞌ, as oora chit kat ooj veꞌt chajnaj. As bꞌex tal veꞌt chajnaj te unqꞌa aatenameꞌ tukꞌ te unqꞌa uxhchileꞌ uveꞌ tulaj unqꞌa talaj tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","As bꞌex til veꞌt unqꞌa tenameꞌ kam uveꞌ uchi. As tul oon veꞌt unqꞌa tenameꞌ kꞌatz u Jesús, as til veꞌteꞌ uvaꞌ xonlik veꞌt u najeꞌ kꞌatz toj u Jesús. As teqꞌo veꞌt taama chajnaj, tan atik veꞌt ok toksaꞌm u najeꞌ. As bꞌaꞌnik veꞌt iyolon naj, tan maꞌtik tel veꞌt unqꞌa subꞌuleꞌ kꞌatz naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","As tal veꞌt unqꞌa uxhchileꞌ isuuchil uvaꞌ kat ilon kam uveꞌ kat uchi uvaꞌ kat ibꞌaꞌnxisa u Jesús u najeꞌ uveꞌ atik ok unqꞌa subꞌuleꞌ stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","As yeꞌ saach unqꞌa tenameꞌ tzaa tulaj unqꞌa talaj tenameꞌ tu u Gadara tiꞌ ul tilataꞌ kam uvaꞌ kat uchi. As ijaj chajnaj bꞌaꞌnil te u Jesús uvaꞌ la el veꞌt Aak tu u txꞌavaꞌeꞌ, tan tiꞌ uvaꞌ vaꞌlik chit ixoꞌv chajnaj taꞌn uveꞌ kat ibꞌan Aak. As ok veꞌt Aak tu u barco tiꞌ iqꞌaav veꞌteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ech koj u najeꞌ uvaꞌ maꞌtik teesat u Jesús unqꞌa subꞌuleꞌ stiꞌ, as ijaj veꞌt naj bꞌaꞌnil te Aak uvaꞌ la xekebꞌ naj tiꞌ Aak. As ech tal veꞌt Aak ileꞌ te naj: ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Kuxh takabꞌal kꞌatz unqꞌa aatineꞌ. Kuxh al ste uvaꞌ kam unqꞌa nimla bꞌaꞌnileꞌ kat ibꞌanlu u Tiixheꞌ see,— tiꞌk u Jesús. As bꞌen veꞌt naj. Bꞌex tal veꞌt naj tu vitenameꞌ skajayil kam u bꞌaꞌnileꞌ uveꞌ kat ibꞌan u Jesús te naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","As tul kat qꞌaavik veꞌt el tzan u Jesús jalit u mar, as aꞌ chit mamaꞌla tenameꞌ nikat itxꞌebꞌon tiꞌ Aak. As vaꞌlik chit ichiibꞌ veꞌt unqꞌa tenameꞌ tiꞌ ikꞌulat Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","As bꞌex oonoj umaꞌl u naj vatz Aak uvaꞌ Jairo ibꞌii uvaꞌ nik bꞌooqꞌolin u atinbꞌaleꞌ tetz nachbꞌal Tiixh. As qaaebꞌ veꞌt naj vatz Aak. As ijaj naj bꞌaꞌnil uvaꞌ la bꞌen Aak tiꞌ naj tu vikabꞌaleꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","tan bꞌiitik kuxh ikam vas imeꞌal najeꞌ taꞌn chꞌoꞌm. As unchꞌiꞌtil kuxh vas ixvaak najeꞌ atike uvaꞌ kabꞌlavalik kuxh iyaabꞌ. As tul bꞌen veꞌt u Jesús tiꞌ naj, as mamaꞌla tenameꞌ nikat ipochꞌ veꞌt tibꞌ tiꞌ Aak tu bꞌeyeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","As atik ok umaꞌl u ixoj xoꞌl unqꞌa tenameꞌ uvaꞌ kabꞌlavaxnik yaabꞌ ixeꞌt ixoj chꞌoꞌnoj, tan aꞌ vitxꞌaao u ixojeꞌ yeꞌ nikat iyaꞌeꞌ. As maꞌtik kuxh isotzsat ixoj vipuajeꞌ taꞌn unqꞌa aatzꞌakeꞌ. Pet yeꞌxhebꞌil kat olebꞌ tiꞌ itzꞌakal ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","As jetzꞌen veꞌt ok ixoj tiꞌ iqul u Jesús. As ikan veꞌt ok ixoj u toksaꞌm Aakeꞌ. As yak kuxh yaꞌ veꞌt vitxꞌaao ixojeꞌ skꞌatz. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","As ech tal veꞌt Aak ileꞌ xoꞌl unqꞌa tenameꞌ: —¿Abꞌil kat kanon u voksaꞌmeꞌ?— tiꞌk u Jesús. Ech tal unqꞌa tenam ileꞌ: —Yeꞌxhebꞌil ni kanon u ooksaꞌmeꞌ,— tiꞌk chajnaj. As ech tal veꞌt u Luꞌ ileꞌ tukꞌ unqꞌa uxhchileꞌ uvaꞌ xekik tiꞌ Aak: —¿Kam qꞌii, Chusul, uvaꞌ: «¿Abꞌil kat kanon u voksaꞌmeꞌ?» chu kuxh axh naaleꞌ? As tul il u mamaꞌla tenameꞌ nipochꞌ tibꞌ seeꞌ,— tiꞌk u Luꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","As ech tal u Jesús ileꞌ: —Yeꞌle, pet at umaꞌl u uxhchil kat kanon in, tan kat unnachlu tel iyakꞌil u bꞌaꞌnileꞌ sunkꞌatz,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","As til veꞌt ixoj uvaꞌ yeꞌ la uch imujat veꞌt tibꞌ ixoj vatz Aak. As kuꞌ veꞌt ixoj qaaloj vatz Aak, tan vaꞌlik chit itꞌuntꞌuch veꞌt ixoj taꞌn xoꞌvichil. As tal veꞌt tibꞌ ixoj vatz unqꞌa tenameꞌ uvaꞌ kam stiꞌ ikankat ixoj u toksaꞌm Aakeꞌ. As tal veꞌt ixoj uvaꞌ oora kuxh kat el u chꞌoꞌmeꞌ tiꞌ ixoj taꞌn Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","As ech tal veꞌt u Jesús ileꞌ te ixoj: —Ixoj, kat elyu veꞌt u chꞌoꞌmeꞌ seeꞌ, tan tiꞌ uvaꞌ kat akꞌujbꞌaꞌ akꞌuꞌl sviꞌ. As kuxh veꞌteꞌ. Achaꞌv abꞌeneꞌ tukꞌ vibꞌaꞌnil u Tiixheꞌ,— tiꞌk u Jesús tal te u ixojeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","As antelik kuxh iyolon Aak tukꞌ ixoj, tul bꞌex uloj umaꞌl vikꞌam u Jairo uvaꞌ bꞌooqꞌol tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh. As ech tal veꞌt naj ileꞌ te u Jairo: —Kat kamyu veꞌt vas ameꞌaleꞌ. As yeꞌxhkam kuxh aal veꞌt te u Chusuleꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","As tul tabꞌi veꞌt u Jesús viyol vikꞌam u Jairo, as ech tal veꞌt Aak ileꞌ te u Jairo: —Yeꞌ kuxh xoꞌv axh. Pet kꞌujbꞌaꞌ akꞌuꞌl sviꞌ. As tuk bꞌaꞌnxojeꞌ vas ameꞌaleꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tul oon veꞌt u Jesús tu vikabꞌal u Jairo, as jit ikꞌuloꞌk Aak unqꞌa tenameꞌ stiꞌ. Pet taꞌn kuxh u Luꞌeꞌ tukꞌ u Jacob tukꞌ u Xhuneꞌ teqꞌo ok Aak stiꞌ tukꞌ vibꞌaal u xvaakeꞌ tukꞌ vitxutxeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","As jankꞌal unqꞌa uxhchileꞌ uveꞌ bꞌex ilon u kamnajeꞌ as vaꞌlik chit toqꞌ veꞌt taꞌn txumuꞌm. As ech tal veꞌt u Jesús ileꞌ: —Yeꞌ kuxh oqꞌ ex, tan yeꞌl u xvaakeꞌ kamnal koj. Pet vatik kuxheꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","As itzeꞌle kuxh unqꞌa uxhchileꞌ viyol Aakeꞌ, tan maꞌtik tilat unqꞌa uxhchileꞌ uvaꞌ maꞌtik ikam u xvaakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","As itxey veꞌt Aak iqꞌabꞌ u xvaakeꞌ. As taqꞌ veꞌt jeꞌ Aak tuul iviꞌ. Ech tal Aak ileꞌ te ixoj: —¡Xvaak, txakpen!— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","As yak kuxh ul veꞌt taama u xvaakeꞌ. Txakpu veꞌt ixoj. As tal veꞌt u Jesús uvaꞌ la aqꞌax veꞌt techbꞌubꞌal ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","As sotz veꞌt ikꞌuꞌl vitxutx u xvaakeꞌ tukꞌ vibꞌaaleꞌ. As tal veꞌt Aak te chaꞌma uvaꞌ yeꞌxh katil la talkat chaꞌma kam uveꞌ kat ibꞌan Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","As imolo veꞌt tzan u Jesús kabꞌlaval unqꞌa ichusulibꞌeꞌ. As taqꞌ veꞌt Aak tijleꞌm chajnaj tiꞌ teesal unqꞌa subꞌuleꞌ kꞌatz unqꞌa uxhchileꞌ as tiꞌ ibꞌaꞌnxisat unqꞌa aachꞌoꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","As ichaj veꞌt bꞌen Aak chajnaj tiꞌ ibꞌaꞌnxisat unqꞌa aachꞌoꞌmeꞌ as tiꞌ talat isuuchil te unqꞌa tenameꞌ tiꞌ uvaꞌ kam tok unqꞌa uxhchileꞌ xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ech tal Aak ileꞌ te chajnaj: —Kaminiꞌk eteqꞌo tu bꞌey. Eteqꞌok ekaroote; eteqꞌok etxꞌuꞌy; eteqꞌok epuaj, as mitaꞌn echꞌexpubꞌ etiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","As abꞌiste umaj kabꞌal uvaꞌ la kꞌulpukat ex as la atin ex tzitziꞌ. As techanal la el chꞌuꞌl ex tu u tenameꞌ, as aꞌn la etaqꞌ kan u kabꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Asoj at umaj tenam uvaꞌ yeꞌ la kꞌulpukat ex, as la el chꞌuꞌl ex tziꞌ u tenameꞌ. As la echitu el u pojoeꞌ tiꞌ vetojeꞌ texhlal tetz uvaꞌ yeꞌ bꞌaꞌn vitxumbꞌal unqꞌa tenameꞌ vatz u Tiixheꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","As bꞌen veꞌt chajnaj tulaj unqꞌa tenameꞌ as tulaj unqꞌa talaj tenameꞌ. As katil uveꞌ nikat ipalkat chajnaj, as nikat ipaxsa veꞌt chajnaj u bꞌaꞌnla yoleꞌ tiꞌ u Jesús. As nikat ibꞌaꞌnxisa chajnaj unqꞌa aachꞌoꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","As u Herodes uvaꞌ kꞌujlik kan tiꞌ tilat isuuchil kajvaꞌl unqꞌa tenameꞌ taꞌn u ijlenaaleꞌ tu u Roma, as tul tabꞌi veꞌt naj itzibꞌlal unqꞌa nimla bꞌaꞌnileꞌ uvaꞌ nikat ibꞌan u Jesús, as sotz veꞌt ikꞌuꞌl naj, tan at unqꞌa tenameꞌ nikat alon uvaꞌ kat ulyu veꞌt taama u Xhuneꞌ unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","As at unkaꞌte nik alon uvaꞌ aꞌ u Elías, u qꞌajsan tetz viyol u Tiixheꞌ, uveꞌ kat ulya. As at kaꞌt uxhchil nikat alon uvaꞌ: —Kamal kat ul taama umaꞌtoj qꞌajsan tetz viyol u Tiixheꞌ uvaꞌ kat ul naꞌytzan,— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pet ech tal veꞌt u Herodes ileꞌ: —As ineꞌ kat alon uvaꞌ kat tzokꞌpik el iviꞌ u Xhuneꞌ. ¿As abꞌisteeꞌ qꞌi u najeꞌ uveꞌ yeꞌ kuxh saach unqꞌa yoleꞌ uveꞌ ni vabꞌi stiꞌ?— tiꞌk u Herodes. As nikat ichuk veꞌt naj txumbꞌal tiꞌ tootzit naj u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","As tul qꞌaavik veꞌt tzan kabꞌlaval unqꞌa apóstol, as tal veꞌt ok chajnaj te u Jesús uvaꞌ kam bꞌex ibꞌan chajnaj. As teqꞌo veꞌt bꞌen Aak chajnaj tu umaꞌl u atinbꞌal uvaꞌ yeꞌlikkat tenam, najlich u tenam uvaꞌ Betsaida. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","As tul tabꞌi veꞌt unqꞌa tenameꞌ uvaꞌ atik u Jesús tzitziꞌ, as bꞌex ichuk veꞌt unqꞌa tenameꞌ Aak. As ikꞌul veꞌt Aak unqꞌa tenameꞌ. As tal veꞌt Aak isuuchil ste tiꞌ uvaꞌ kam tok unqꞌa uxhchileꞌ xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. As kat ibꞌaꞌnxisa veꞌt Aak unqꞌa aachꞌoꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","As tul kuꞌ veꞌt qꞌii, as jetzꞌen veꞌt ok kabꞌlaval unqꞌa ichusulibꞌ Aakeꞌ skꞌatz. As ech tal veꞌt chajnaj ileꞌ te Aak: —Al te unqꞌa tenameꞌ uvaꞌ la bꞌen ichuk techbꞌubꞌal tukꞌ ivatbꞌal tulaj unqꞌa talaj tenameꞌ uveꞌ najli, tan tzitzaꞌ kam koj ati, tan yeꞌl umaj kabꞌal at tzitzaꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","As ech tal veꞌt u Jesús ileꞌ: —Yeꞌle, pet ex la aqꞌon ipaan unqꞌa tenameꞌ,— tiꞌk Aak. As ech tal veꞌt chajnaj ileꞌ: —As yeꞌl paan eqꞌomal sqaꞌn tiꞌ itzujbꞌel unqꞌa tenameꞌ skajayil. Pet oꞌvaꞌl kuxh paan ati tukꞌ kaꞌvaꞌt txay. ¿Pet moj aꞌ naaleꞌ uvaꞌ la bꞌen kuloqꞌ techbꞌubꞌal unqꞌa tenameꞌ skajayil?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kamal oꞌvaꞌl mil unqꞌa najeꞌ atike. As ech tal veꞌt Aak ileꞌ te unqꞌa ichusulibꞌeꞌ: —Etaltaj te unqꞌa tenameꞌ uvaꞌ la xonebꞌ skajayil. As laval toxkꞌal (50) uxhchil tu junun tꞌuubꞌul la ebꞌaneꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","As ibꞌan veꞌt chajnaj kam uveꞌ tal Aak. As tal veꞌt chajnaj ixonebꞌ unqꞌa tenameꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","As itxey veꞌt Aak oꞌvaꞌl unqꞌa paaneꞌ tukꞌ kaꞌvaꞌt unqꞌa txayeꞌ. As kaꞌyik veꞌt jeꞌ Aak tu almikaꞌ. As taqꞌ veꞌt Aak taꞌntiixh te u Tiixheꞌ stiꞌ. As ijatx veꞌt Aak. As taqꞌ veꞌt Aak te unqꞌa ichusulibꞌeꞌ tiꞌ uvaꞌ la ijatx veꞌt chajnaj xoꞌl unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","As tul maꞌtik itxꞌaꞌn unqꞌa tenameꞌ sbꞌaꞌn skajayil, as imol veꞌt unqꞌa ichusulibꞌ Aakeꞌ kabꞌlavat xuꞌk unqꞌa yaꞌl paaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","As tu umaꞌl u qꞌii, as teesa el tibꞌ u Jesús tukꞌ unqꞌa ichusulibꞌeꞌ tiꞌ inachat Tiixh. As ech tal veꞌt Aak ileꞌ te chajnaj: —¿Kam u vijleꞌmeꞌ uveꞌ ni tal unqꞌa tenameꞌ?— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ech tal veꞌt chajnaj ileꞌ: —At uxhchil ni alon uvaꞌ axh u Xhuneꞌ uvaꞌ nik aqꞌon kuꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ; at kaꞌt uxhchil ni alon uvaꞌ axh u Elías; as at kaꞌt uxhchil ni alon uvaꞌ axh umaꞌtoj u qꞌajsan tetz viyol u Tiixheꞌ uvaꞌ kat ul taama unpajte,— tiꞌk unqꞌa ichusulibꞌ Aakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","As ech tal veꞌt u Jesús ileꞌ: —¿Kano ex qꞌii? ¿Kam u vijleꞌmeꞌ uveꞌ netaleꞌ?— tiꞌk Aak. —Axheꞌ taꞌ u Cristo uveꞌ kat ichaj tzan u Tiixheꞌ,— tiꞌk u Luꞌeꞌ tal veꞌt te Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","As tal veꞌt Aak te chajnaj uvaꞌ yeꞌxhebꞌil la tal chajnaj ste uvaꞌ Aak u Cristo. As ikaꞌpu Aak talat te chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","As ech tal veꞌt Aak ileꞌ te chajnaj: —Techal chit la ipalebꞌe VIKꞌAOL U NAJEꞌ unqꞌa kꞌaxkꞌoeꞌ tan la ixvali taꞌn unqꞌa bꞌaal tenameꞌ, tukꞌ unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh, as tukꞌ unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ. As la yatzꞌpi. As titoxvu qꞌii la ul taama unpajte,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","As ech tal veꞌt Aak ileꞌ xoꞌl unqꞌa tenameꞌ: —Abꞌiste ex uvaꞌ la esaꞌ etoksat etibꞌ sunkꞌatz, as jit vetxumbꞌaleꞌ la etoksa. Pet aꞌ uvaꞌ la ebꞌan jun qꞌii kam uvaꞌ nunbꞌaneꞌ, kꞌuxh la epalebꞌe kꞌaxkꞌo as moj la kam ex sviꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","tan abꞌil uveꞌ aꞌ kuxh vitiichajileꞌ ni titzꞌa vatz u txꞌavaꞌeꞌ, as yeꞌl itiichajil kꞌatz u Tiixheꞌ la ibꞌaneꞌ. Pet abꞌil uvaꞌ la taqꞌ vitiichajileꞌ sviꞌ, as aꞌeꞌ uveꞌ at itiichajil kꞌatz Aak la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿As kam ibꞌaꞌnil qꞌi tiꞌ umaj uxhchil uvaꞌ la itxꞌak u vatz txꞌavaꞌeꞌ skajayil, as tul yeꞌl itiichajil at kꞌatz u Tiixheꞌ as la kuxh tzꞌejxeꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","As abꞌil uvaꞌ la chꞌixvu vatz unqꞌa tenameꞌ tiꞌ talat uvaꞌ nimamal veꞌt in staꞌn as nimamal vunyoleꞌ staꞌn, as la chꞌixvu veꞌteꞌ VIKꞌAOL U NAJEꞌ vatz unpajte. As yeꞌl tokebꞌal sunkꞌatz tul la kuꞌ chꞌuꞌl in tu almikaꞌ as la litzꞌloꞌlan u vulebꞌaleꞌ, as la ilitzꞌloꞌlan vunBꞌaaleꞌ tukꞌ unqꞌa tiixhla ángeleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","As jik chit tuk val sete, tan at jolol ex uvaꞌ at ex tzitzaꞌ uvaꞌ yeꞌxnaj kam ex tul la ilej veꞌt u qꞌiieꞌ. As la etil veꞌteꞌ uvaꞌ at tijleꞌm u Tiixheꞌ,— tiꞌk u Jesús tal xoꞌl unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","As vaaxil veꞌt qꞌii stuul uvaꞌ talat u Jesús unqꞌa yoleꞌ, as teqꞌo veꞌt Aak u Luꞌeꞌ stiꞌ, tukꞌ u Xhuneꞌ, tukꞌ u Jacob viꞌ umaꞌl u vitz tiꞌ inachat Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","As tul nikat inach Aak Tiixh, as jalpu veꞌt ikaꞌy Aak vatz chajnaj. As vaꞌlik chit ilitzꞌloꞌlan u toksaꞌm Aakeꞌ. As vaꞌlik chit ipolal unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","As chee veꞌt kaꞌvaꞌl unqꞌa naj vatz Aak. As yolon veꞌt chajnaj tukꞌ Aak. As aꞌeꞌ u Moisés tukꞌ u Elías. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","As vaꞌlik chit ilitzꞌloꞌlan tiꞌ. Aꞌ nikat iyoleꞌ tukꞌ u Jesús uvaꞌ kam ikam Aak tuk kamoj tu u Jerusalén. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","As kꞌuxh atik vataꞌm tivatz u Luꞌeꞌ tukꞌ kaꞌvaꞌt vimooleꞌ, as chajnaj chit yeꞌ kat vati. As islik kuxh chajnaj tul til veꞌt chajnaj ilitzꞌloꞌlan u bꞌaꞌnileꞌ tiꞌ u Jesús. As til veꞌt chajnaj kaꞌvaꞌt unqꞌa naj uveꞌ txaklik kꞌatz Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","As tul aalik ibꞌen veꞌt u Moisés tukꞌ u Elías, as ech tal veꞌt u Luꞌ ileꞌ te Aak: —¡Chusul, bꞌaꞌneꞌ uvaꞌ la atin oꞌ tzitzaꞌ! As la kulak oxvoꞌj tal pach ni valeꞌ: umaꞌl eetz; as umaꞌt tetz u Moisés; as umaꞌt tetz u Elías,— tiꞌk u Luꞌeꞌ. As tal kuxh u Luꞌeꞌ u yoleꞌ, tan yeꞌ nik titzꞌa kam uveꞌ nik taleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","As antelik kuxh iyolon u Luꞌeꞌ tul chee veꞌt umaꞌl u suutzꞌ tiibꞌa chajnaj. As xoꞌv veꞌt chajnaj tul kat kaa chajnaj tu u suutzꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","As tabꞌi veꞌt chajnaj umaꞌl u tuul viꞌ tu u suutzꞌeꞌ uvaꞌ ech ni tal ileꞌ: —¡Aꞌ vunKꞌaoleꞌ u vaaꞌ! ¡As xoꞌn chit sve! ¡As aꞌeꞌ la enima!— tiꞌk u tuul viꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","As tul yaꞌ veꞌt u tuul viꞌeꞌ, as til veꞌt chajnaj uvaꞌ aꞌik kuxh veꞌt u Jesús sijunal. As yeꞌl veꞌt umaꞌtoj yol kat tal chajnaj. As nimal veꞌt qꞌii stuul uvaꞌ yeꞌxhebꞌil kat tal chajnaj ste tiꞌ uveꞌ kat til chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","As ech qꞌejal stuul, as kuꞌ veꞌt chꞌuꞌl u Jesús viꞌ u vitzeꞌ tukꞌ unqꞌa ichusulibꞌeꞌ. As aꞌ chit mamaꞌla tenameꞌ ul kꞌulun veꞌt Aak tu bꞌey. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","As umaꞌl u naj uvaꞌ atik xoꞌl unqꞌa tenameꞌ, as taqꞌ veꞌt jeꞌ naj tuul iviꞌ. As ech tal veꞌt naj ileꞌ: —¡Chusul, bꞌan bꞌaꞌnil! ¡Loch unchꞌiꞌtil vas unkꞌaoleꞌ! ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Tan chajpuul nixeꞌt naj sikꞌin taꞌn umaꞌl u subꞌul uvaꞌ atoꞌk skꞌatz. As xoꞌvebꞌal chit isutil bꞌen tu txꞌavaꞌ taꞌn u subꞌuleꞌ. As niyiku tibꞌ. As ni tel xoj itziꞌ. As yeꞌ nisaꞌ u subꞌuleꞌ tel skꞌatz. As vaꞌl chit ikꞌaxbꞌisat tibꞌ taꞌn u subꞌuleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","As kat unjaj bꞌaꞌnil te unqꞌa achusulibꞌeꞌ uvaꞌ la teesa chajnaj u subꞌuleꞌ skꞌatz. As yeꞌ kat olebꞌ chajnaj,— tiꞌk u najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","As ech tal veꞌt u Jesús ileꞌ: —¡Ex chit bꞌa yeꞌ nekꞌujbꞌaꞌ ekꞌuꞌl sviꞌ! ¡As vaꞌlen kuxh vetxumbꞌaleꞌ! ¿As ma tuk kuxh atinoj in bꞌa sexoꞌl uveꞌ netitzꞌa? ¿As la kuxh kol txꞌebꞌon veꞌt in qꞌa setiꞌ tiꞌ uvaꞌ la ekꞌujbꞌaꞌ ekꞌuꞌl sviꞌ? ¡Eqꞌo tzan vaxaakeꞌ sunvatz!— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","As tul jetzꞌen veꞌt ok u xaakeꞌ kꞌatz u Jesús, as isuti veꞌt u subꞌuleꞌ u xaakeꞌ tu txꞌavaꞌ tukꞌ chit txꞌiꞌtziꞌl. As xoꞌvebꞌal chit iyikut veꞌt u subꞌuleꞌ naj. As iyaa veꞌt u Jesús u subꞌuleꞌ. As yak kuxh ibꞌaꞌnxisa Aak u xaakeꞌ. As taqꞌ veꞌt ok Aak u xaakeꞌ te vibꞌaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","As teqꞌo veꞌt taama unqꞌa tenameꞌ skajayil, tan tiꞌ uvaꞌ at tijleꞌm u Tiixheꞌ tiꞌ ibꞌaꞌnxisal u xaakeꞌ. As tul nikat iyol veꞌt unqꞌa tenameꞌ svatzaj tiꞌ uveꞌ ibꞌan u Jesús, as ech tal veꞌt Aak ileꞌ te unqꞌa ichusulibꞌeꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Etaqꞌtaj chit vunyoleꞌ teviꞌ uvaꞌ tuk val sete, tan VIKꞌAOL U NAJEꞌ, as la aqꞌax ok tiqꞌabꞌ unqꞌa uxhchileꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","As jit pal chajnaj tu u yoleꞌ uvaꞌ tal u Jesús, tan yeꞌ kat taqꞌ u Tiixheꞌ te chajnaj uvaꞌ la tootzi chajnaj isuuchil u yoleꞌ as tiꞌ uvaꞌ la pal chajnaj stuul. As xoꞌv chajnaj tiꞌ ichꞌotil isuuchil u yoleꞌ te u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","As xeꞌt veꞌt unqꞌa ichusulibꞌ u Jesús tiꞌ iyolataꞌ tiꞌ uvaꞌ abꞌiste naj nim talcheꞌ tiꞌ unqꞌa imooleꞌ la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","As naꞌlik veꞌt vatz u Jesús uvaꞌ kam nik tal taama chajnaj. As imolo veꞌt tzan Aak umaꞌl u tal xaak. As itxakbꞌaꞌ veꞌt Aak u tal xaakeꞌ stxala. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","As ech tal veꞌt Aak ileꞌ te chajnaj: —Abꞌil uvaꞌ tukꞌ vunbꞌiieꞌ la ibꞌankat umaj bꞌaꞌnil te umaj talaj intxaꞌ echeꞌ u tal xaak ilaꞌ, as sveeꞌ la ibꞌankat. As abꞌil uvaꞌ la bꞌanon umaj bꞌaꞌnil sve, as jit kuxh sveeꞌ la ibꞌankat. Pet anteꞌ u chajol tzan vetzeꞌ la ibꞌan u bꞌaꞌnileꞌ ste. As abꞌil uvaꞌ la ichꞌoobꞌisa tibꞌ tukꞌ vitxumbꞌaleꞌ vatz vimooleꞌ, as aꞌeꞌ nim talcheꞌ la ibꞌaneꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","As ech tal veꞌt u Xhun ileꞌ: —Chusul, kat qil umaꞌl u naj uvaꞌ tukꞌ vabꞌiieꞌ ni teesakat el naj unqꞌa subꞌuleꞌ kꞌatz unqꞌa uxhchileꞌ. As kat kuyaꞌsa veꞌt kan te naj, tan yeꞌl naj xekel koj sqiꞌ,— tiꞌk u Xhuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ech tal veꞌt u Jesús ileꞌ: —Yeꞌ kuxh eyaꞌsa kan te naj, tan abꞌil uveꞌ yeꞌ nichꞌoꞌn taama sqiꞌ, as echeneꞌ sukukꞌatz,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","As tul txantik kuxh veꞌt ilejat qꞌii tiꞌ ikꞌulpik veꞌt jeꞌ u Jesús tu almikaꞌ, as ayaꞌl chit ikꞌuꞌl Aak tiꞌ ibꞌen tu u Jerusalén. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","As ichaj veꞌt bꞌen Aak kaꞌl unqꞌa naj tu umaꞌl u tal tenam uvaꞌ echen tu u Samaria tiꞌ bꞌen ibꞌanat chajnaj tuch u atinbꞌaleꞌ uvaꞌ la oonkat Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","As jit isaꞌ unqꞌa aa Samaria uvaꞌ la atin Aak xoꞌl chajnaj, tan tiꞌ uvaꞌ til chajnaj uvaꞌ yakik Aak tiꞌ toksat iqꞌii u Tiixheꞌ tu u Jerusalén. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","As tul til veꞌt u Jacob tukꞌ u Xhuneꞌ, as ech tal veꞌt chajnaj ileꞌ te Aak: —¿Pap, ma nasaꞌ uvaꞌ la qal ikuꞌ chꞌuꞌl umaj xamal tu almikaꞌ tiꞌ isotzsal unqꞌa tenameꞌ echeꞌ ibꞌan u Elías?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","As isuchqꞌi veꞌt tibꞌ u Jesús. As iyaa veꞌt Aak chajnaj. Ech tal veꞌt Aak ileꞌ: —Yeꞌ paloj ex stuul uvaꞌ abꞌil ni alon u yoleꞌ sete, ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","tan yeꞌ kat ul VIKꞌAOL U NAJEꞌ tiꞌ itzꞌejxisal unqꞌa tenameꞌ. Pet tiꞌ iqꞌalpuleꞌ kat ulkat,— tiꞌk Aak. As kat bꞌen veꞌt Aak tukꞌ chajnaj tu umaꞌt tal tenam. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","As tul nikat ixaan u Jesús tu bꞌey tukꞌ unqꞌa ichusulibꞌeꞌ, as ech tal umaꞌl u naj ileꞌ te Aak: —Pap, aꞌ ni valeꞌ uvaꞌ la xekebꞌ in seeꞌ, katil kuxh uvaꞌ la bꞌenkat axh,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ech tal u Jesús ileꞌ: —At ijul unqꞌa chisi. As echat unqꞌa tzꞌikineꞌ uvaꞌ nixichꞌan vatz u almikaꞌeꞌ, tan at isok txoo. Pet ech koj VIKꞌAOL U NAJEꞌ tan yeꞌl ivitzꞌ ati uvaꞌ la qaebꞌ ok stiꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","As ech tal veꞌt u Jesús ileꞌ te umaꞌt naj: —¡Xekebꞌen sviꞌ!— tiꞌk Aak. Ech tal veꞌt naj ileꞌ te Aak: —Pap, lanal unmuj kan ak unbꞌaaleꞌ bꞌaxa. As aꞌn la xekebꞌ in seeꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ech tal veꞌt u Jesús ileꞌ: —Imujeꞌn tibꞌ unqꞌa uxhchileꞌ svatzaj uvaꞌ kamnal u taanxelaleꞌ vatz u Tiixheꞌ. Pet yeꞌ eetz stiꞌ. Kuxh paxsa u yoleꞌ xoꞌl unqꞌa tenameꞌ tiꞌ tok unqꞌa uxhchileꞌ xoꞌl vitenam u Tiixheꞌ uvaꞌ ni til Aak isuuchil,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","As ech tal veꞌt umaꞌt u naj ileꞌ te u Jesús: —Pap, la xekebꞌ in seeꞌ ni valeꞌ. As maꞌt unqꞌiila kan unqꞌa vatineꞌ tu vunkabꞌaleꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","As ech tal veꞌt u Jesús ileꞌ: —Abꞌil uvaꞌ ni titzꞌa iqꞌaav tiꞌ iqul as tul maꞌt toksat tibꞌ sunkꞌatz, as yeꞌ la uch tok xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ, tan eela vitxumbꞌal u uxhchileꞌ tukꞌ umaj uxhchil uvaꞌ vaꞌlen kuxh la isaji. As tul txeyel u tzeꞌeꞌ staꞌn uvaꞌ ni kꞌobꞌon u txꞌavaꞌeꞌ taꞌn unqꞌa vaakaxheꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Xamtik veꞌt stuul, as itxaa veꞌt u Jesús laval imutxꞌ (70) unqꞌa ichusulibꞌeꞌ. As ichaj veꞌt bꞌen Aak chajnaj tulaj unqꞌa tenameꞌ katil uveꞌ la palkat Aak. As kaꞌkabꞌil ibꞌen veꞌt chajnaj ibꞌan Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","As ech tal veꞌt bꞌen Aak ileꞌ te chajnaj: —Ech veꞌt tatin unqꞌa tenameꞌ echeꞌ unqꞌa koꞌmeꞌ uvaꞌ la pitxꞌlu veꞌteꞌ. As tul kaꞌl kuxh unqꞌa aqꞌonvileꞌ ati. Pet ejajtaj te u Kubꞌaal Tiixheꞌ tiꞌ uvaꞌ la ichaj tzan Aak kaꞌtoj uxhchil tiꞌ talat isuuchil viyol Aakeꞌ xoꞌl unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","As bꞌenoj ex, tan ineꞌ ni chajon bꞌen ex. Pet ech ebꞌeneꞌ echeꞌ ibꞌen unjoloj kaneeroꞌ xoꞌl unqꞌa xoꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kaminiꞌk eteqꞌo. Eteqꞌok esam; eteqꞌok epuaj; eteqꞌok exaꞌp. As ebꞌalak kuxh etibꞌ tiꞌ yol tu bꞌey tukꞌ umaj uxhchil. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","As abꞌiste kabꞌal la kꞌulpukat ex, as ech la etal ileꞌ te unqꞌa uxhchileꞌ tul la ok ex tu u kabꞌaleꞌ: «As bꞌaꞌnoj etatin sevatzaj,» chaj ex la etaleꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","tan asoj at umaj bꞌaal kabꞌal uvaꞌ bꞌaꞌn tatin svatzaj tikabꞌal, as bꞌaꞌn tatin svatzaj la ibꞌaneꞌ. Asoj yeꞌle, as yeꞌ bꞌaꞌn tatin u uxhchileꞌ svatzaj. Pet ech koj ex tan bꞌaꞌn chit etatineꞌ sevatzaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","As xaaniꞌk kuxh ex tulaj unqꞌa kabꞌaleꞌ. As abꞌiste u kabꞌaleꞌ uveꞌ la kꞌulpukat ex, as tzitziꞌ la atinkat ex. As kam unqꞌa echbꞌubꞌaleꞌ la aqꞌax sete as la etechbꞌu. As la etukꞌa kam uveꞌ la aqꞌax sete, tan umaꞌl u aqꞌonvil as tetz chiteꞌ uvaꞌ la aqꞌpu veꞌt u techbꞌubꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","As tul la oon ex tu umaj tenam uveꞌ la kꞌulpukat ex, as etechbꞌutaj kam unqꞌa veeꞌ la aqꞌax sete. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","As la ebꞌaꞌnxisa unqꞌa aachꞌoꞌmeꞌ uveꞌ at tzitziꞌ. As ech la etal ileꞌ te unqꞌa uxhchileꞌ: «Kat ilejlu veꞌt u qꞌiieꞌ tiꞌ u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ,» chaj ex la etaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Asoj yeꞌ la ikꞌul ex unqꞌa uxhchileꞌ tul la oon ex tu umaj tenam, as la el chꞌuꞌl ex tu u tenameꞌ. As ech la etal ileꞌ tul la el chꞌuꞌl ex tu unqꞌa bꞌeyeꞌ xoꞌl unqꞌa kabꞌaleꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","«As jankꞌal unqꞌa pojoeꞌ uveꞌ kat ok tiꞌ u qojeꞌ tzitzaꞌ tu u tenameꞌ, as la kuputzꞌ kan, texhlal tetz uvaꞌ yeꞌ kat ekꞌul viyol u Tiixheꞌ. Pet la qal sete, kat ilejlu veꞌt u qꞌiieꞌ uvaꞌ la ok u tenameꞌ jaqꞌ u tijleꞌm u Tiixheꞌ» chaj ex la etaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","As ileꞌ ni val sete uvaꞌ la ilej umaꞌl u qꞌii uvaꞌ la ul u kꞌaxkꞌoeꞌ tiꞌ u tenameꞌ. As xoꞌvebꞌal chit u kꞌaxkꞌoeꞌ la ibꞌaneꞌ tiꞌ uveꞌ kat ibꞌan tu u Sodoma,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","As ech umaꞌt u yol ileꞌ tal Aak tiꞌ kaꞌt unqꞌa tenameꞌ uveꞌ yeꞌ nik niman viyol Aakeꞌ: —¡Oyebꞌ chit evatz, ex aa Corazín; as oyebꞌ chit evatz, ex aa Betsaida! Tan aꞌ koj kat unbꞌankat unqꞌa nimla bꞌaꞌnileꞌ vatz unqꞌa aa Tiro as vatz unqꞌa aa Sidón echeꞌ uveꞌ nunbꞌan sexoꞌl scheel, as naꞌytzaneꞌxh ijalput unqꞌa tenameꞌ itxumbꞌal vatz u Tiixheꞌ. As kat ikꞌuchleꞌ uvaꞌ kat ijalpu veꞌt vitxumbꞌaleꞌ tiꞌ toksat unqꞌa qichkin oksaꞌmeꞌ as tiꞌ taqꞌat jeꞌ tzaꞌj tiviꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Estiꞌeꞌ ni val sete uvaꞌ xoꞌvebꞌal chit u kꞌaxkꞌoeꞌ uveꞌ la ul setiꞌ tukꞌ unqꞌa aa Tiro as tukꞌ unqꞌa aa Sidón, tul la bꞌanchu isuuchil unqꞌa tenameꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","As echat kuxh ex, ex aa Capernaúm, tan aꞌ netaleꞌ uvaꞌ la oon ex tu almikaꞌ tukꞌ u txꞌiibꞌal eqꞌiieꞌ. As yeꞌle, tan aꞌ la aqꞌpikkat bꞌen ex tu u kꞌaxkꞌola atinbꞌaleꞌ uvaꞌ atkat unqꞌa kamnajeꞌ uvaꞌ paasan tzii,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","As ech kaꞌt unqꞌa yol ileꞌ tal bꞌen Aak te laval imutxꞌ unqꞌa ichusulibꞌeꞌ tul ichaj bꞌen Aak chajnaj: —Abꞌil uveꞌ la niman veyoleꞌ as ineꞌ la inima in. As abꞌil uveꞌ la ixvan veyoleꞌ as ineꞌ la tixva in. As abꞌil uveꞌ la ixvan in as aꞌ u chajol tzan vetzeꞌ ni tixva,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","As tul kat qꞌaavik tzan unqꞌa laval imutxꞌ (70) ichusulibꞌ u Jesús skꞌatz tukꞌ chiibꞌichil, as ech tal chajnaj ileꞌ te Aak: —Pap, kat inima oꞌ unqꞌa subꞌuleꞌ taꞌn vabꞌiieꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ech tal veꞌt u Jesús ileꞌ: —An chiteꞌ taꞌ, tan kat vil ikuꞌ chꞌuꞌl u Satanás tu almikaꞌ. As ech ikuꞌ chꞌuꞌl najeꞌ echeꞌ umaj kayampaꞌl. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","As kat vaqꞌlu veꞌt iyakꞌil vetijleꞌmeꞌ tiꞌ uvaꞌ yeꞌxhkam la tulbꞌe ex unqꞌa txꞌiꞌlatxooeꞌ tukꞌ unqꞌa ixkabꞌeꞌ, kꞌuxh la epachꞌ txoo tu bꞌey, tan at etijleꞌm svaꞌn tiꞌ etolebꞌ tiꞌ u txꞌiꞌlanajeꞌ tukꞌ unqꞌa imooleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pet yeꞌ kuxh txuqꞌtxun ex tiꞌ uveꞌ ninima ex unqꞌa subꞌuleꞌ. Pet txuqꞌtxunoj ex tiꞌ uveꞌ tzꞌibꞌamal veꞌt vebꞌiieꞌ tu uꞌujeꞌ uveꞌ at tu almikaꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","As tul nikat tal u Jesús viyoleꞌ, as vaꞌlik chit itxuqꞌtxun veꞌt Aak taꞌn u Tiixhla Espíritu. As ech tal veꞌt Aak ileꞌ te u Kubꞌaal Tiixheꞌ tu almikaꞌ: —UnBꞌaal, axheꞌ viBꞌooqꞌol u almikaꞌeꞌ tukꞌ u vatz txꞌavaꞌeꞌ skajayil. As ni voksa aqꞌii, tiꞌ uvaꞌ kat amuj veꞌt isuuchil unqꞌa yoleꞌ vatz unqꞌa uxhchileꞌ uveꞌ at itxumbꞌal ni tal jeꞌ ste. As aꞌ kat akꞌuchkat te unqꞌa uxhchileꞌ uvaꞌ ech itxumbꞌaleꞌ echeꞌ unqꞌa talaj intxaꞌeꞌ. As an chiteꞌ, unBꞌaal, tan echeꞌ uvaꞌ nasaꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","As ech tal veꞌt u Jesús ileꞌ te unqꞌa tenameꞌ: —Tan at veꞌt vijleꞌm tiꞌ unqꞌa veeꞌ skajayil taꞌn vunBꞌaaleꞌ. As yeꞌxhebꞌil ootzin vetz uvaꞌ in iKꞌaol u Tiixheꞌ; as yeꞌxhebꞌil ootzin tetz vunBꞌaaleꞌ. Pet taꞌn ineꞌ ootzin tetz Aak as tukꞌ unqꞌa tenameꞌ uvaꞌ la unsaꞌ vaqꞌat tootzil Aak ste,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","As isuchqꞌi veꞌt tibꞌ u Jesús. As ech tal veꞌt Aak ileꞌ te unqꞌa ichusulibꞌeꞌ: —Achvebꞌal chit ex tukꞌ unqꞌa uxhchileꞌ uveꞌ ni ilon unqꞌa nimla bꞌaꞌnileꞌ uvaꞌ nikꞌuchpu sevatz cheel, ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","tan ileꞌ ni val sete uvaꞌ yeꞌ saach unqꞌa qꞌajsan tetz viyol u Tiixheꞌ tukꞌ unqꞌa ijlenaaleꞌ uvaꞌ atik naꞌytzan kat saꞌon tilat unqꞌa veeꞌ netil cheel. As yeꞌ kat tila. As kꞌuxh kat isaꞌ tabꞌit unqꞌa yoleꞌ uveꞌ netabꞌi cheel, as yeꞌ kat tabꞌi,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","As umaꞌl u naj uvaꞌ chuselik tibꞌ tiꞌ u tzaqꞌiteꞌ uvaꞌ tzꞌibꞌamal kan, as txakpu veꞌt naj xoꞌl unqꞌa tenameꞌ, tan aꞌ nik tal naj uvaꞌ la icheesa naj ipaav u Jesús. As ech tal naj ileꞌ te Aak: —¿Chusul, kam la unbꞌaneꞌ tiꞌ uvaꞌ at untiichajil uvaꞌ yeꞌl iyaꞌtebꞌal?— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ech tal veꞌt u Jesús ileꞌ: —¿Kam ni tal u tzaqꞌiteꞌ uvaꞌ tzꞌibꞌamal kan? ¿As kam neetzꞌa stiꞌ tul nasikꞌle?— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","As ech tal veꞌt u naj ileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ: —Ech ni tal vitzaqꞌit u Tiixh ileꞌ sqe: Ayaꞌloj chit ekꞌuꞌl la exoꞌni u Kubꞌaal Tiixheꞌ tukꞌ chit etaanxelal, tukꞌ chit eyakꞌil, as tukꞌ chit etxumbꞌal. As xoꞌnoj vemooleꞌ sete echeꞌ uvaꞌ nebꞌan jeꞌ sete, taqꞌ u tzaqꞌiteꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ech tal veꞌt u Jesús ileꞌ te naj: —Jik chit kat aal u yoleꞌ. Asoj la anima u yoleꞌ, as at atiichajil kꞌatz u Tiixheꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","As ibꞌensa veꞌt tibꞌ naj jikla aamail vatz Aak. As ech tal naj ileꞌ te Aak: —¿Pap, abꞌisteeꞌ qꞌi vunmooleꞌ uveꞌ ni tal u yoleꞌ?— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","As ech tal veꞌt u Jesús ileꞌ: —Ibꞌan unpajul, as el veꞌt chꞌuꞌl umaꞌl u naj tu u Jerusalén tiꞌ ibꞌen tu u Jericó. As ikꞌul naj kaꞌl unqꞌa elqꞌom tu bꞌey. As telqꞌa veꞌt unqꞌa elqꞌomeꞌ unqꞌa tetz najeꞌ skajayil tukꞌ u toksaꞌmeꞌ. As kat ikꞌaxbꞌisa veꞌt kan unqꞌa elqꞌomeꞌ naj. As bꞌiit kuxh jit kam naj taꞌn unqꞌa elqꞌomeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","As bꞌex paloj umaꞌl oksan iyol tenam vatz Tiixh. As tul til naj vas najeꞌ, as isaji kan kuxh naj. As ikꞌaj tibꞌ naj tu bꞌey. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","As bꞌex uloj umaꞌt u tiaal u Leví. As pal kuxh isaji kan naj. As ikꞌaj tibꞌ naj tu bꞌey unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","As bꞌex uloj veꞌt umaꞌt u naj uvaꞌ tzaanaj tu u Samaria. As tul til naj vas najeꞌ uveꞌ kꞌaxbꞌinalike, as itxum veꞌt naj ivatz. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","As jetzꞌen veꞌt ok naj skꞌatz. As itzꞌaka veꞌt naj vas najeꞌ taꞌn aceite tukꞌ vino. As ibꞌoch veꞌt naj uveꞌ kꞌaxbꞌinale. As taqꞌ veꞌt jeꞌ naj vas najeꞌ tiꞌ vikaayeꞌ. As teqꞌo veꞌt bꞌen naj tu umaꞌl u vatbꞌal. As ixee veꞌt naj vas najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ech veꞌt qꞌejal stuul, as teqꞌo veꞌt jeꞌ tzan naj kaꞌvaꞌl puaj vatz tuul uvaꞌ kaꞌvaꞌl qꞌii aqꞌon ijaꞌmil. As taqꞌ veꞌt kan naj te vibꞌaal u vatbꞌaleꞌ. As ech tal naj ileꞌ: «Bꞌan bꞌaꞌnil. La chit eel u najeꞌ. Asoj la asotzsa nimal puaj tiꞌ u najeꞌ, as la aal sve. As in la choon,» tiꞌk u najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","¿As abꞌiste u najeꞌ xoꞌl oxvaꞌl unqꞌa najeꞌ qꞌi uveꞌ imool tibꞌ tukꞌ vas najeꞌ kat ibꞌana uveꞌ kat kꞌaxbꞌisal taꞌn unqꞌa elqꞌomeꞌ?— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ech tal veꞌt u naj ileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ: —Aꞌ u najeꞌ uveꞌ kat txumun ivatz u najeꞌ uveꞌ kꞌaxbꞌinalike,— tiꞌk naj. As ech tal veꞌt u Jesús ileꞌ: —Kuxh veꞌteꞌ. As echat la abꞌaneꞌ echeꞌ uvaꞌ kat ibꞌan u aa Samaria,— tiꞌk u Jesús tal te naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","As tul bꞌen veꞌt u Jesús tu bꞌey, as oon veꞌt Aak tu umaꞌl u koꞌm uvaꞌ jejlikkat umaꞌl u ixoj uvaꞌ Taa. As kat ikꞌul veꞌt ixoj Aak tikabꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Atik umaꞌl u titzꞌin ixoj uvaꞌ Maꞌl ibꞌii. Tul oon u Jesús tikabꞌal chaꞌma, as kuꞌ u Maꞌleꞌ xonloj vatz Aak tiꞌ tabꞌit ixoj viyol Aakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pet ech koj u Taaeꞌ, tan aꞌ kuxh u taqꞌon ixojeꞌ nikat titzꞌa. As jetzꞌen veꞌt ok ixoj kꞌatz u Jesús. As ech tal ixoj ileꞌ: —¿Pap, texh yeꞌ kuxh neetzꞌa? Tan yeꞌ niloch in ixoj Maꞌleꞌ. As in kuxh ni veloꞌk tiꞌ u aqꞌoneꞌ. Pet al te ixoj uvaꞌ la iloch in ixoj,— tiꞌk u Taaeꞌ tal te u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ech tal veꞌt u Jesús ileꞌ te u Taaeꞌ: —Ileꞌ tuk val see, Taa: Tan vaꞌl kuxh apojbꞌeꞌ tiꞌ unqꞌa aqꞌoneꞌ uveꞌ nabꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pet uveꞌ nibꞌan u Maꞌleꞌ, as aꞌeꞌ uvaꞌ nim talcheꞌ tiꞌ unqꞌa echbꞌubꞌaleꞌ. As yeꞌ la ibꞌaneꞌ uvaꞌ layaap ixoj stiꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Atik veꞌt u Jesús tu umaꞌl u atinbꞌal tiꞌ inachat Tiixh. As tul tzojpu veꞌt Aak, as ech tal veꞌt umaꞌl vichusulibꞌ Aak ileꞌ ste: —Pap, al sqe uvaꞌ kam kunachat Tiixh echeꞌ kat ibꞌan u Xhuneꞌ te unqꞌa ichusulibꞌeꞌ,— tiꞌk naj te Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","As ech tal veꞌt u Jesús ileꞌ: —Ech la etal ileꞌ tul la enach Tiixh: Kubꞌaal Tiixh, echen axh tu almikaꞌ. Tiixhla bꞌii chiteꞌ tatin vabꞌiieꞌ. As ulen veꞌteꞌ tukꞌ u Eejleꞌmeꞌ tiꞌ vatenameꞌ skajayil. As aꞌ ni qaleꞌ uvaꞌ la abꞌan vatz u txꞌavaꞌeꞌ kam uvaꞌ ni tal aama echeꞌ uvaꞌ nabꞌan tu almikaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Bꞌan bꞌaꞌnil. Aqꞌ vas qechbꞌubꞌaleꞌ uvaꞌ la qechbꞌu jun qꞌii. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","As sotzsa kupaaveꞌ, Pap, tiꞌ u vaꞌlexheꞌ uveꞌ nu kubꞌan savatz, echeꞌ uveꞌ nu kubꞌaneꞌ, tan nu kusotzsa ipaav u kumooleꞌ uveꞌ ni paavin sukuvatz. As bꞌan bꞌaꞌnil. Achajpuk kan oꞌ tiꞌ kubꞌen tu u vaꞌlexheꞌ. Pet la akol oꞌ vatz u txꞌiꞌlanajeꞌ, chaj ex la etaleꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","As tal veꞌt u Jesús unpajte. As ech tal Aak ileꞌ: —Qal bꞌen stiꞌ uvaꞌ at umaꞌl vetetz kꞌultziꞌ uveꞌ la bꞌen etil pokꞌoꞌch aqꞌbꞌal. As ech la etal ileꞌ te naj: «Bꞌan bꞌaꞌnil sve. Unchꞌexu oxvoꞌj unpaan see, ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","tan kat ulyu veꞌt umaꞌl u vetz kꞌultziꞌ. As naach tzaanalkat naj. As yeꞌl chit unbꞌooj echbꞌubꞌal ati tiꞌ vaqꞌat te naj,» chaj ex la etaleꞌ te vetetz kꞌultziꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","As yeꞌle taꞌ uvaꞌ ech koj la taleꞌl tzan naj ileꞌ sete: «Yeꞌ kuxh ul akꞌaji ok tzan in, tan chabꞌamal ikolil u kabꞌaleꞌ svaꞌn. As il unqꞌa meꞌal unkꞌaol ileꞌ vatik sunkꞌatz viꞌ chꞌach. As yeꞌ la uch untxakpeꞌ tiꞌ bꞌen vaqꞌat el uveꞌ najaj sve,» chaj koj naj la taleꞌl tzan sete. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","As ileꞌ tuk val sete uvaꞌ kꞌuxh yeꞌ la isaꞌ vetetz kꞌultziꞌeꞌ ilakpeꞌ tiꞌ ul taqꞌat sete kam uvaꞌ nejaj ste tiꞌ kuxh uvaꞌ etetz kꞌultziꞌ etibꞌ stukꞌ, as la chit taqꞌ najeꞌ skajayil kam uveꞌ nejaj te naj, aqꞌal uvaꞌ yeꞌ la el ichꞌixubꞌal naj vatz unqꞌa uxhchileꞌ uveꞌ atkat naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Estiꞌeꞌ ni val sete, ejajtaj. As la aqꞌpeꞌ sete. Echuktaj. As la elejeꞌ. Etꞌoktaj u tziꞌ kabꞌaleꞌ. As la jajpeꞌ u tziꞌ kabꞌaleꞌ sevatz, ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","tan abꞌil uvaꞌ la jajon, as la ikꞌuleꞌ. As abꞌil uvaꞌ la chukun, as la ilejeꞌ. As abꞌil uvaꞌ la tꞌokon u tziꞌ kabꞌaleꞌ, as la jajpeꞌ u tziꞌ kabꞌaleꞌ svatz. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","As echeꞌ at koj umaj bꞌaala sexoꞌl uvaꞌ la aqꞌon umaj kꞌubꞌ te vitalaj intxaꞌeꞌ, tul la ijaj ipaan ste. As mitaꞌn ichibꞌil txꞌiꞌlatxoo la taqꞌ u bꞌaalaeꞌ te vitalaj intxaꞌeꞌ, tul la ijaj unbꞌooj chibꞌil txay ste. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Asoj la ijaj vikꞌaoleꞌ umaj kꞌolobꞌ, as echeꞌ la koj taqꞌ u bꞌaalaeꞌ umaj ixkabꞌ ste. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Estiꞌeꞌ ni val sete, tan kꞌuxh txꞌiꞌla aama ex, as ootzimal setaꞌn uvaꞌ aꞌ u bꞌaꞌneꞌ netaqꞌ te unqꞌa etalaj intxaꞌeꞌ. ¿As aꞌ kol chit yeꞌl u Kubꞌaal Tiixheꞌ qꞌa uvaꞌ at tu almikaꞌ? Tan la taqꞌ Aak u Tiixhla Espíritu sete, abꞌiste ex uvaꞌ la jajon te Aak,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","As ibꞌan tu umaꞌl u qꞌii tul nik teesa u Jesús subꞌul kꞌatz umaꞌl u naj uvaꞌ mem taꞌn u subꞌuleꞌ. Tul maꞌtik tel u subꞌuleꞌ kꞌatz u najeꞌ, as yolon veꞌt naj. As teqꞌo veꞌt taama unqꞌa tenameꞌ tiꞌ uvaꞌ ibꞌaꞌnxisa Aak naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pet atik kaꞌl unqꞌa uxhchil nikat alon tiꞌ Aak uvaꞌ: «Aꞌ vibꞌooqꞌol unqꞌa subꞌuleꞌ uvaꞌ Beelzebú ni aqꞌon tijleꞌm u najeꞌ tiꞌ teesal el unqꞌa subꞌuleꞌ,» tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Atik kaꞌt unqꞌa uxhchil uvaꞌ nik ichuk txumbꞌal tiꞌ uvaꞌ la icheesa chajnaj ipaav u Jesús. As ul ijaj chajnaj te Aak uvaꞌ la ikꞌuch Aak umaj nimla bꞌaꞌnil, kꞌuchbꞌal tetz uvaꞌ asoj aꞌ tzaanajkat Aak tu almikaꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","As ootzimalik vitxumbꞌal chajnajeꞌ taꞌn Aak. As ech tal veꞌt Aak ileꞌ: —As jankꞌal unqꞌa nimla tenameꞌ, asoj jatxel tibꞌ, as yeꞌl iyol nikꞌul tibꞌ svatzaj. As la kuxh teꞌpisa veꞌt tibꞌ u tenameꞌ. As echat tatin unqꞌa uxhchileꞌ tu umaj kabꞌal, tan asoj yeꞌ la ikꞌul tibꞌ iyol svatzaj, as la kuxh yaneꞌ u tatineꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Echat kuxh bꞌanel taꞌn u Satanás tukꞌ unqꞌa imooleꞌ, tan asoj jatxel tibꞌ chajnaj svatzaj, as yeꞌle bꞌa bꞌaꞌn koj tatineꞌ. As aꞌ ni valkateꞌ sete, tan tiꞌ uvaꞌ netal sviꞌ uvaꞌ ni veesa el unqꞌa subꞌuleꞌ kꞌatz unqꞌa uxhchileꞌ taꞌn viyakꞌil u Beelzebú uveꞌ netaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Pet asoj ni veesa unqꞌa subꞌuleꞌ taꞌn viyakꞌil u Beelzebú uveꞌ netaleꞌ, ¿as abꞌil qꞌi ni aqꞌon iyakꞌil unqꞌa emooleꞌ tiꞌ teesat el unqꞌa subꞌuleꞌ kꞌatz unqꞌa uxhchileꞌ? Estiꞌeꞌ ni val sete uvaꞌ an chit unqꞌa emooleꞌ tuk alon isuuchil setiꞌ uvaꞌ sotznal ekꞌuꞌl. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tan asoj nunlaqꞌbꞌa el unqꞌa subꞌuleꞌ taꞌn viyakꞌil u Tiixheꞌ, as aꞌ texhlal tetzeꞌ uvaꞌ kat okyu veꞌt u tenameꞌ jaqꞌ u tijleꞌm u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","As echeꞌ umaj naj uvaꞌ tii tatineꞌ uvaꞌ bꞌanel tuch naj tukꞌ unqꞌa ichꞌichꞌeꞌ tiꞌ ixeep vikabꞌaleꞌ. As kam koj la bꞌanon unqꞌa tetz najeꞌ tu vikabꞌaleꞌ tan chabꞌamal ixeepeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pet tul la ul umaꞌtoj naj uvaꞌ at pal iyakꞌil tiꞌ u najeꞌ, as la ibꞌan u najeꞌ te naj. As la imaa veꞌt naj vichꞌichꞌ najeꞌ tiqꞌabꞌ uveꞌ kꞌujleꞌl ikꞌuꞌl naj stiꞌ. As aꞌ veꞌt u najeꞌ uvaꞌ kat olebꞌ tiꞌ naj la jatxon unqꞌa tetz najeꞌ uveꞌ at tu vikabꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Estiꞌeꞌ ni val sete uvaꞌ abꞌil uveꞌ jit echen sunkꞌatz, as aꞌeꞌ uvaꞌ yeꞌ ni saꞌon in. As abꞌil uveꞌ yeꞌ ni lochon in tiꞌ teqꞌot tzan unqꞌa uxhchileꞌ sunkꞌatz, as eela kuxh stukꞌ uvaꞌ an chiteꞌ ni eesan el unqꞌa uxhchileꞌ sunkꞌatz. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Tul la el chꞌuꞌl umaꞌl u subꞌul skꞌatz umaj uxhchil, as la kuxh xaan veꞌt u subꞌuleꞌ tu u tzuukin txꞌavaꞌeꞌ tiꞌ ichukat tiꞌlebꞌal. As tul yeꞌ la ilej u tiꞌlebꞌaleꞌ, as ech la tal veꞌt jeꞌ ileꞌ ste: «La qꞌaav in tu u vatinbꞌal uveꞌ kat elkat chꞌuꞌl in,» chaj la taleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","As tul la oon veꞌt u subꞌuleꞌ, as ech veꞌt tatin u uxhchileꞌ echeꞌ umaj u kabꞌal uvaꞌ eesamal chꞌis stuul as chꞌiꞌumal tiloneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","As la bꞌen teqꞌo veꞌt tzan u subꞌuleꞌ vujvaꞌt imool uvaꞌ nim talcheꞌ tiꞌ ibꞌanax u vaꞌlexheꞌ. As tul la ok veꞌt u subꞌuleꞌ tukꞌ vimooleꞌ, as la jejebꞌ veꞌt unqꞌa subꞌuleꞌ tu u taanxelal u uxhchileꞌ. As pal chit veꞌt iviꞌ la ibꞌan u uxhchileꞌ tiꞌ uvaꞌ nik ibꞌan bꞌaxa,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","As antelik iyolon u Jesús. As sikꞌin veꞌt umaꞌl u ixoj xoꞌl unqꞌa tenameꞌ. Ech tal ixoj ileꞌ: —Achvebꞌal chit u ixojeꞌ uveꞌ kat itzꞌbꞌaꞌn axh. As kat taqꞌ achꞌuꞌ,— tiꞌk ixoj te u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ech tal veꞌt u Jesús ileꞌ: —Kano, an chiteꞌ naaleꞌ. Pet achvebꞌal chit unqꞌa uxhchileꞌ uveꞌ ni abꞌin viyol u Tiixheꞌ. As ninima,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","As aꞌ chit mamaꞌla tenameꞌ nikat imol veꞌt ok tibꞌ kꞌatz u Jesús. As ech tal veꞌt Aak ileꞌ: —¡Ech veꞌt vetxumbꞌaleꞌ echeꞌ unqꞌa uxhchileꞌ uvaꞌ vaꞌlexh vitxumbꞌaleꞌ nibꞌaneꞌ! As nejaj umaj kꞌuchbꞌal tetz u vijleꞌmeꞌ. As echeꞌ la koj kꞌuchpu sete. As aꞌ kuxh uveꞌ la kꞌuchpu sete echeꞌ uvaꞌ kat ibꞌan u Jonás, u qꞌajsan tetz viyol u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","As ech u kꞌuchbꞌal tetz VIKꞌAOL U NAJEꞌ tuk unbꞌan sevatz echeꞌ uvaꞌ kat ibꞌan u Jonás vatz unqꞌa aa Nínive. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","As abꞌimaleꞌ setaꞌn uvaꞌ ibꞌan u ixoj uvaꞌ ijlenaalike tu u tenam uvaꞌ Sabá, tan tziꞌaꞌn kat tzaakat ixoj tiꞌ ul tabꞌit itxumbꞌal te u ijlenaaleꞌ uvaꞌ Salomón. As tul la ilej u qꞌiieꞌ tiꞌ ibꞌanax isuuchil unqꞌa tenameꞌ skajayil, as antu veꞌt u ixojeꞌ la uli tiꞌ ixochat ex vatz u Tiixheꞌ, tan kꞌuxh at in sexoꞌl, as yeꞌ nesaꞌ etabꞌit vunyoleꞌ. As tul nim valcheꞌ tiꞌ u Salomón. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","As echat chit la ibꞌan unqꞌa aa Nínive, tan tul la ilej veꞌt u qꞌiieꞌ tiꞌ ibꞌanax isuuchil unqꞌa tenameꞌ skajayil, as la ul veꞌt unqꞌa aa Nínive tiꞌ ixochat ex vatz u Tiixheꞌ, tan tul kat tal veꞌt u Jonás viyol u Tiixheꞌ ste, as oora chit kat ikꞌaxa veꞌt tibꞌ. Pet ech koj ex, tan kꞌuxh at in sexoꞌl, as yeꞌ nesaꞌ ekꞌaxat etibꞌ. As tul nim valcheꞌ tiꞌ u Jonás. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","As yeꞌxhebꞌil la mujun umaj xamal uvaꞌ maꞌt imatxleꞌ. As mitaꞌn la oksal jaqꞌ umaj kaaxha. Pet aꞌ la aqꞌaxkat jeꞌ viꞌ u matxbꞌaleꞌ. As abꞌil uvaꞌ la ok tu u kabꞌaleꞌ, as la til u uxhchileꞌ u xamaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","As echeꞌ u bꞌaqꞌ evatzeꞌ tan aꞌeꞌ nikꞌuchun kam vetxumbꞌaleꞌ, tan asoj bꞌaꞌn u bꞌaqꞌ evatzeꞌ, as bꞌaꞌneꞌ vetxumbꞌaleꞌ. Pet asoj vaꞌlexh u bꞌaqꞌ evatzeꞌ, as vaꞌlexheꞌ vetxumbꞌaleꞌ. As at veꞌt bꞌen ex tu qꞌej toktoeꞌ tukꞌ vetxumbꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Estiꞌeꞌ tuk val sete, etiltaj jeꞌ etibꞌ, aqꞌal uvaꞌ yeꞌ la bꞌen vetxumbꞌaleꞌ tu u qꞌej toktoeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tan asoj bꞌaꞌn u bꞌaqꞌ evatzeꞌ as yeꞌl ex at bꞌen ex tu u toktoeꞌ tukꞌ vetxumbꞌaleꞌ, as jankꞌal veꞌt vetxumbꞌaleꞌ as bꞌaꞌn veꞌt tatineꞌ echeꞌ nibꞌan u xamaleꞌ tul nitxijun setiꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","As tul yaꞌ veꞌt iyolon u Jesús, as imolo veꞌt umaꞌl u fariseo Aak tiꞌ ibꞌen Aak txꞌaꞌon tikabꞌal naj. As bꞌen veꞌt Aak tiꞌ naj. As ok veꞌt Aak xonloj vatz u meexhaeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","As tul til veꞌt u fariseo uvaꞌ xonlik u Jesús vatz u meexhaeꞌ, as yan veꞌt tiviꞌ naj, tan yeꞌ kat itxꞌaa Aak iqꞌabꞌ tul kat xeꞌt Aak txꞌaꞌon. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","As ech tal veꞌt u Jesús ileꞌ: —As ex fariseo, tan ech bꞌanel etaꞌneꞌ echeꞌ umaj picheel tukꞌ umaj laj uvaꞌ aꞌ kuxh u tiꞌeꞌ nitxꞌaapeꞌ. As tul noonal tuul taꞌn tzꞌil. As ech bꞌan taꞌn vetxumbꞌaleꞌ taꞌn unqꞌa vaꞌlexheꞌ tukꞌ unqꞌa elaqꞌeꞌ uveꞌ nebꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Ex kuxh paasan tzii tukꞌ vetxumbꞌaleꞌ! ¿Ma yeꞌ nepal stuul uvaꞌ aꞌ u Tiixheꞌ cheesan tetz vechiꞌoleꞌ, as Aakeꞌ cheesan tetz vetaanxelaleꞌ unpajte? ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pet ejalputaj vetxumbꞌaleꞌ. As ayaꞌloj chit ekꞌuꞌl la eloch unqꞌa meebꞌaꞌeꞌ. As ech exeꞌ echeꞌ u picheeleꞌ as moj u lajeꞌ uvaꞌ kat txꞌaap u tuuleꞌ bꞌaxa as aꞌn kat txꞌaap u tiꞌeꞌ unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Pet oyebꞌ chit evatz, ex fariseo! Tan kꞌuxh netaqꞌ umaj xoꞌl laval unqꞌa uschꞌeꞌneꞌ, tukꞌ unqꞌa luutaeꞌ, tukꞌ unqꞌa itzaaeꞌ tu u tostiixheꞌ, as yeꞌ nebꞌan unqꞌa jikla txumbꞌaleꞌ te unqꞌa uxhchileꞌ. As yeꞌ nexoꞌni u Tiixheꞌ. As tul aꞌeꞌ uveꞌ techal la ebꞌaneꞌ. Pet yeꞌ la eyaꞌsa etaqꞌat unqꞌa chikoeꞌ tu u tostiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡As oyebꞌ chit evatz, ex fariseo! Tan netaleꞌ uvaꞌ ex kuxh la xonebꞌ ex tu unqꞌa bꞌaxa xonlebꞌaleꞌ tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh. As tul nexaan tu u kꞌayibꞌaleꞌ, as aꞌ netaleꞌ uvaꞌ techal la oksal eqꞌii taꞌn unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡As oyebꞌ chit evatz, ex fariseo tukꞌ ex uvaꞌ chusel etibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ! Tan ech vetxumbꞌaleꞌ echeꞌ ijulil umaj kamnaj uvaꞌ yeꞌ naꞌl. As kꞌuxh nipal unqꞌa xaoleꞌ stiibꞌa, as yeꞌ nibꞌen ste uvaꞌ mujel kamnaj tzitziꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","As ech tal veꞌt umaꞌl u naj ileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ: —Chusul, antu veꞌt oꞌeꞌ taꞌ nayoqꞌ oꞌ tukꞌ vayoleꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ech tal veꞌt u Jesús ileꞌ unpajte: —¡Oyebꞌ chit evatz, ex uvaꞌ chusel etibꞌ tiꞌ u tzaqꞌiteꞌ uvaꞌ tzꞌibꞌamal kan! Tan nimal unqꞌa yoleꞌ uveꞌ netal te unqꞌa uxhchileꞌ uvaꞌ la bꞌanchi. As tul yeꞌxhebꞌil la olebꞌ tiꞌ inimaleꞌ. As mitaꞌn kuxh ex la lochon unbꞌooj unqꞌa uxhchileꞌ tiꞌ inimaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡As oyebꞌ chit evatz! Tan nelak unqꞌa bꞌaꞌnla chaj oornoeꞌ uveꞌ mujelkat unqꞌa qꞌajsan tetz viyol u Tiixheꞌ uvaꞌ kat iyatzꞌ unqꞌa qꞌesla ebꞌaaleꞌ uvaꞌ naꞌytzan. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","As tul ech nebꞌaneꞌ, as an kuxh ex ni kꞌuchun uvaꞌ eqꞌomaltel vitxumbꞌal unqꞌa qꞌesla ebꞌaaleꞌ setaꞌn, tan aꞌ unqꞌa qꞌesla ebꞌaaleꞌ kat yatzꞌon unqꞌa qꞌajsan tetz viyol u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Pet ootzimalik taꞌn u Tiixheꞌ uvaꞌ ech la ibꞌaneꞌ. Estiꞌeꞌ ech tal Aak ileꞌ: «Tuk unchaj bꞌen kaꞌt unqꞌa qꞌajsan tetz vunyoleꞌ tukꞌ unqꞌa apóstol xoꞌl unqꞌa tenameꞌ. As ati la yatzꞌpi; as ati la tiluli taꞌn unqꞌa tenameꞌ,» tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","As ex chiteꞌ at epaav tiꞌ vikamebꞌal unqꞌa qꞌajsan tetz viyol u Tiixheꞌ uveꞌ kat yatzꞌpi naꞌytzan, ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","tan aꞌ kat xeꞌtikkat tzan tiꞌ vikamebꞌal u Abel. As kat ul tiꞌ vikamebꞌal u Zacarías uvaꞌ kat yatzꞌpi vatz u tostiixheꞌ kꞌatz u atinbꞌaleꞌ uvaꞌ niyatzꞌpukat unqꞌa txooeꞌ. Estiꞌeꞌ ni val sete uvaꞌ ex chiteꞌ at epaav tiꞌ vikamebꞌal unqꞌa qꞌajsan tetz viyol u Tiixheꞌ, jankꞌal ex uveꞌ ech vetxumbꞌaleꞌ echeꞌ unqꞌa qꞌesla ebꞌaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡As oyebꞌ chit evatz, ex uvaꞌ chusel etibꞌ tiꞌ u tzaqꞌiteꞌ uvaꞌ tzꞌibꞌamal kan! Tan kat kuxh emuj isuuchil viyol u Tiixheꞌ vatz unqꞌa tenameꞌ. As mitaꞌn ex kat ootzin isuuchil. As nemaj ivatz unqꞌa tenameꞌ tiꞌ uvaꞌ la tootzi isuuchil viyol u Tiixheꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","As tul kuxh tzojpu u Jesús tiꞌ iyoloneꞌ, as el veꞌt chꞌuꞌl Aak tikabꞌal u fariseo. As kaꞌt unqꞌa fariseo tukꞌ unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as ichuk veꞌt chajnaj txumbꞌal tiꞌ Aak, tan ul veꞌt iviꞌ chajnaj tiꞌ uveꞌ tal Aak. As kam kuxh nikat ichꞌoti veꞌt chajnaj te Aak, ");
INSERT INTO ixlNNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","tan aꞌ nik tal chajnaj uvaꞌ kam umaj vaꞌlexh la tal Aak tiꞌ icheesal ipaav Aak. As la bꞌen ixoch chajnaj Aak vatz unqꞌa iqꞌesaleꞌ, uvaꞌ nikat taleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Aꞌ chit mamaꞌla tenameꞌ nikat imol veꞌt ok tibꞌ kꞌatz u Jesús. As vaꞌl chit ipachꞌat veꞌt tibꞌ toj unqꞌa tenameꞌ kꞌatz Aak. As ech tal veꞌt Aak ileꞌ te unqꞌa ichusulibꞌeꞌ: —Atoj enachbꞌal vatz vitxumbꞌal unqꞌa fariseo, tan ech vitxumbꞌal chajnajeꞌ echeꞌ u levadura. As okiꞌk vitxumbꞌal chajnajeꞌ teviꞌ, tan kaꞌvatz kuxh chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pet la val sete, tan jankꞌal unqꞌa yoleꞌ uvaꞌ yeꞌxhebꞌil ootzin tetz, as techal la ootzili. As jankꞌal unqꞌa yoleꞌ uvaꞌ mujel, as techal la ootzili. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","As jankꞌal unqꞌa yoleꞌ uveꞌ kat emuj etalataꞌ, as la chit el chꞌuꞌl viꞌ saj tiꞌ tabꞌileꞌ. As jankꞌal chit unqꞌa yoleꞌ uveꞌ kat ejasoꞌk te vemooleꞌ viꞌ u kabꞌaleꞌ, as la chit alax viꞌ unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","As ileꞌ ni val sete, ex vetz kꞌultziꞌ, as yeꞌ kuxh xoꞌv ex te unqꞌa uxhchileꞌ uveꞌ la olebꞌ tiꞌ eyatzꞌpeꞌ, tan yeꞌxhkam chit umaꞌtoj vaꞌlexh la itxꞌol veꞌt chajnaj ibꞌanat setiꞌ, tul maꞌt ekameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pet ileꞌ tuk val sete uvaꞌ abꞌil la exoꞌva, tan aꞌ kuxh u Tiixheꞌ la exoꞌva, tan jit taꞌn la olebꞌ Aak tiꞌ eyatzꞌpeꞌ. Pet la olebꞌ Aak tiꞌ taqꞌat bꞌen vetaanxelaleꞌ tu u choobꞌal paaveꞌ. Estiꞌeꞌ ni val sete uvaꞌ aꞌeꞌ la xoꞌvali. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","As ootzimal setaꞌn uvaꞌ yeꞌxh jatvaꞌl nibꞌenkat oꞌvoꞌj talaj tzꞌikin tul nikꞌayileꞌ, tan oꞌvaꞌl txoo tiꞌ kaꞌvaꞌl u tal puajeꞌ. As echeꞌ la koj sotz umaj txoo skꞌuꞌl u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Echat kuxh ex unpajte, tan junun unqꞌa xiꞌl eviꞌeꞌ, tan acheleꞌ skajayil taꞌn Aak. Estiꞌeꞌ ni val sete uvaꞌ yeꞌ kuxh xoꞌv ex, tan nim etalcheꞌ vatz u Tiixheꞌ tiꞌ unqꞌa talaj tzꞌikineꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","As ileꞌ tuk val sete, tan abꞌil uvaꞌ yeꞌ la xoꞌvi tiꞌ talat tibꞌ uvaꞌ nimamal veꞌt VIKꞌAOL U NAJEꞌ staꞌn vatz unqꞌa tenameꞌ, as echat la unbꞌan stiꞌ vatz unqꞌa ángel uvaꞌ tetz u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pet abꞌil uvaꞌ la teesa tibꞌ sunkꞌatz vatz unqꞌa tenameꞌ, as echat la unbꞌan stiꞌ vatz unqꞌa ángel uvaꞌ tetz u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","As abꞌil uvaꞌ la yoqꞌon VIKꞌAOL U NAJEꞌ, as la uch isotz ipaav u uxhchileꞌ. Pet asoj abꞌil la yoqꞌon tiꞌ u Tiixhla Espíritu, as yeꞌl ipaav u uxhchileꞌ la sotz veꞌteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","As tul la txeypik bꞌen ex tu umaj atinbꞌaleꞌ tetz nachbꞌal Tiixh, as vatz unqꞌa bꞌanol tetz isuuchil unqꞌa tenameꞌ, as moj vatz unjoltu unqꞌa bꞌaal tenameꞌ tiꞌ icheesal epaav, as xaaniꞌk kuxh etaama tiꞌ uvaꞌ kam la etaleꞌ tiꞌ eqꞌalat etibꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","tan aꞌ u Tiixhla Espíritu la alon sete uvaꞌ kam la etaleꞌ tu u qꞌiieꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","As ech tal veꞌt umaꞌl u naj ileꞌ xoꞌl unqꞌa tenameꞌ te u Jesús: —Chusul, bꞌan bꞌaꞌnil. Al te u vatzikeꞌ uvaꞌ la taqꞌ naj unvaatzil tiꞌ u txꞌavaꞌeꞌ, uvaꞌ kat taqꞌ kan vunbꞌaaleꞌ— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ech tal veꞌt Aak ileꞌ: —Ileꞌ tuk val see, tan jit vetzeꞌ uvaꞌ la unbꞌan esuuchil tiꞌ unjatxat vetxꞌavaꞌeꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","As ech tal veꞌt u Jesús ileꞌ te unqꞌa tenameꞌ: —Etiltaj jeꞌ etibꞌ. Aꞌiniꞌk kuxh u txꞌiibꞌal qꞌiieꞌ la etoksa etaama stiꞌ, tan jit tiꞌ imolat imaas txꞌiibꞌal qꞌii atkat umaj uxhchil vatz u txꞌavaꞌeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","As tal veꞌt u Jesús umaꞌt u kꞌuchuvatz. Ech tal Aak ileꞌ: —Atik umaꞌl u txꞌioliqꞌii uvaꞌ mamaꞌla itxꞌavaꞌ atike. As mamaꞌla chikoeꞌ kat imola. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","As ech tal veꞌt jeꞌ ileꞌ ste: «¿Kameꞌ qꞌi tuk unbꞌaneꞌ? Tan yeꞌle taꞌ vunkꞌuayeꞌ tuk tzꞌajoj tiꞌ unkolat vunchikoeꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Pet kat ulyu veꞌt sunkꞌuꞌl kam uveꞌ tuk unbꞌaneꞌ, tan tuk veꞌpu vunkꞌuayeꞌ. As la unlak veꞌt umaꞌte uvaꞌ nim veꞌteꞌ. As aꞌ la unkolkat unqꞌa unchikoeꞌ skajayil tukꞌ unjoltu unqꞌa vetzeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","As tul la bꞌaꞌnxi, as la val veꞌt jeꞌ sve uvaꞌ: –Cheel la iꞌl veꞌt vaama, tan yeꞌ saach unqꞌa vetzeꞌ kat unkollu veꞌteꞌ. As nimal veꞌt yaabꞌ tuk itxꞌol veꞌteꞌ. As la txꞌaꞌn in; la ukꞌaꞌ in; la chiibꞌ veꞌt in sbꞌenameen,– chaj in la valeꞌ,» tiꞌk u txꞌioliqꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pet ech ul tal veꞌt u Tiixh ileꞌ te naj: «¡Axh kuxh paasan tzii, tan cheel tu u aqꞌbꞌaleꞌ tuk kamoj axh! As jankꞌal unqꞌa eetzeꞌ uveꞌ kat akola as jit eetzeꞌ tuk ibꞌaneꞌ,» tiꞌk u Tiixheꞌ tal te u txꞌioliqꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","As ech nibꞌan unqꞌa uxhchileꞌ uveꞌ aꞌ kuxh u txꞌiibꞌal qꞌiieꞌ ni titzꞌa vatz u txꞌavaꞌeꞌ. As jit u bꞌaꞌneꞌ nichukeꞌ vatz u Tiixheꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","As ech tal veꞌt u Jesús ileꞌ te unqꞌa ichusulibꞌeꞌ: —Ileꞌ tuk val sete, tan yeꞌ exaansa etaama tiꞌ uvaꞌ kam la etechbꞌu tiꞌ etatineꞌ vatz u txꞌavaꞌeꞌ, as mitaꞌn tiꞌ unqꞌa etoksaꞌmeꞌ uvaꞌ kam la etoksaꞌmi, ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","tan nim talcheꞌ vetiichajileꞌ tiꞌ vetechbꞌubꞌaleꞌ. As nim talcheꞌ vechiꞌoleꞌ tiꞌ vetoksaꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","As etitzꞌataj unqꞌa jooeꞌ, tan kꞌuxh yeꞌl txoo ni taveꞌ, as mitaꞌn yeꞌl txoo ni pitxꞌoneꞌ, as kꞌuxh yeꞌl ikꞌuay txoo ati, as aꞌ u Tiixheꞌ uvaꞌ echen tu almikaꞌ ni aqꞌon techbꞌubꞌal txoo. ¿As aꞌ kol chit yeꞌl veꞌt ex qꞌa? Tan nim etalcheꞌ tiꞌ unqꞌa tzꞌikineꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","As yeꞌl umaj ex la koj olebꞌ ex tiꞌ echꞌiisat etxakebꞌeꞌ tukꞌ kaꞌvaꞌtoj kꞌuchbꞌal, kꞌuxh la exaansa etaama stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Estiꞌeꞌ la val sete, asoj yeꞌ la olebꞌ ex tiꞌ unqꞌa veeꞌ tzꞌup kuxhtuꞌ, ¿as kam qꞌi uveꞌ vaꞌl kuxh exaansat etaama tiꞌ unjoltu unqꞌa veeꞌ vatz u txꞌavaꞌeꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","As etitzꞌataj unqꞌa xuꞌmeꞌ, tan vaꞌl chit tachaꞌvin ichꞌiieꞌ. As echeꞌ nu koj taqꞌonveꞌ. As mitaꞌn nichemoneꞌ. Pet tuk val sete, tan mitaꞌn kuxh u ijlenaal Salomón kat lejon ivejat tibꞌ tukꞌ u toksaꞌmeꞌ tiꞌ unqꞌa xuꞌmeꞌ, as kꞌuxh xoꞌvebꞌalik kuxh naj tiꞌ ivejat tibꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","As ileꞌ tuk val sete, asoj u Tiixheꞌ ni bꞌanon uvaꞌ achaꞌv ichꞌii unqꞌa kꞌuacheꞌ uveꞌ at vatz u chaqꞌaalaeꞌ cheel as qꞌejal la sutil bꞌen tu xamal, ¿as aꞌ kol chit yeꞌ la ibꞌan Aak qꞌa sete tiꞌ elochpeꞌ, ex uvaꞌ bꞌiil kuxh u kꞌujlebꞌal ekꞌuꞌleꞌ tiꞌ Aak? ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","As yeꞌ kuxh exaansa etaama tiꞌ uvaꞌ kam la etechbꞌu moj kam la etukꞌa. As yeꞌ kuxh el etaama stiꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","tan aꞌ kuxheꞌ ni xaansan taama unqꞌa tenameꞌ uvaꞌ yeꞌ ni niman u Tiixheꞌ. Pet ech koj ex, tan ootzimaleꞌ taꞌn u Kubꞌaal Tiixheꞌ kam uvaꞌ nisaꞌvit setiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Pet etoksataj etaama tiꞌ u Tiixheꞌ, ex uvaꞌ at veꞌt ok ex xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. As Aakeꞌ la aqꞌon veꞌt unqꞌa veeꞌ skajayil sete kam uvaꞌ nisaꞌvit setiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","As yeꞌ kuxh xoꞌv ex, uvaꞌ ech exeꞌ talaj kaneeroꞌ. As kꞌuxh kaꞌl kuxh ex, as at veꞌt ok ex xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ, as ayaꞌl chit ikꞌuꞌl Aak tiꞌ taqꞌat etijleꞌm tiꞌ uvaꞌ la etil isuuchil unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Pet ekꞌayitaj unqꞌa etetzeꞌ. As etaqꞌtaj vijaꞌmileꞌ te unqꞌa meebꞌaꞌeꞌ. Asoj ech la ebꞌaneꞌ tiꞌ emolat unqꞌa nimla bꞌaꞌnileꞌ tu almikaꞌ echeꞌ imolax puaj tu umaj kolbꞌal, tan aꞌeꞌ yeꞌ la yani. As yeꞌxhebꞌil la elqꞌan. As yeꞌ la pokꞌti, tan aꞌ nekolkat tu almikaꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","As katil uvaꞌ nemolkat unqꞌa etetzeꞌ, as tzitziꞌeꞌ netoksakat etaama. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","As ebꞌantaj chit etuch sqꞌiil as aqꞌbꞌal echeꞌ umaj uxhchil uvaꞌ matxel chit vixamaleꞌ staꞌn. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","As ech la ebꞌaneꞌ echeꞌ nibꞌan kaꞌl unqꞌa kꞌam, tul la itxꞌebꞌ tul u bꞌaal aqꞌoneꞌ uvaꞌ bꞌex tu umaj nimla qꞌii tiꞌ teqꞌot tibꞌ umaj meꞌal ikꞌaol umaj uxhchil. As tul la itꞌok u bꞌaal aqꞌoneꞌ u tziꞌ kabꞌaleꞌ, as oora la jajpu u tziꞌ kabꞌaleꞌ svatz taꞌn unqꞌa ikꞌameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","As achvebꞌal chit unqꞌa kꞌameꞌ la ibꞌaneꞌ asoj bꞌanel tucheꞌ tiꞌ ikꞌulpu veꞌt u bꞌaal aqꞌoneꞌ, tul la uli, tan aal la ibꞌan veꞌt u bꞌaal aqꞌoneꞌ tucheꞌ. As la xonbꞌaꞌl veꞌt unqꞌa kꞌameꞌ vatz u meexhaeꞌ. As aꞌ veꞌt u bꞌaal aqꞌoneꞌ la aqꞌon veꞌt ok unqꞌa techbꞌubꞌal unqꞌa kꞌameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","As kꞌuxh kam kuxh qꞌiil la ul u bꞌaal aqꞌoneꞌ, kꞌuxh pokꞌoꞌch aqꞌbꞌal as kꞌuxh txanti isajbꞌeꞌ tul la uli, as chiibꞌebꞌal chit tatin unqꞌa kꞌameꞌ la ibꞌaneꞌ asoj txꞌebꞌel tul u bꞌaal aqꞌoneꞌ staꞌn. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","As palojtaj ex tu unqꞌa yoleꞌ uvaꞌ ni val sete, tan asoj la tootzi u bꞌaal kabꞌaleꞌ uvaꞌ kam qꞌiil la ul u elqꞌomeꞌ tiꞌ tok tu u kabꞌaleꞌ, as echeꞌ la koj taqꞌ kan naj vikabꞌaleꞌ vatz u elqꞌomeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Estiꞌeꞌ ni val sete, ebꞌantaj chit etucheꞌ, tan aꞌ chiteꞌ yeꞌl sekꞌuꞌl tul uvaꞌ la ul VIKꞌAOL U NAJEꞌ unpajte,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","As ech tal veꞌt u Luꞌ ileꞌ te u Jesús: —¿Pap, ma sqe kuxh kat aalkat u kꞌuchuvatzeꞌ? ¿Pet moj te unqꞌa uxhchileꞌ unpajte?— tiꞌk u Luꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ech tal veꞌt u Jesús ileꞌ: —As ech la ebꞌaneꞌ echeꞌ umaj kꞌam uvaꞌ kꞌujleꞌl ikꞌuꞌl u bꞌaal aqꞌoneꞌ stiꞌ, tan jik chit ni taqꞌonvu naj. As aꞌ najeꞌ uvaꞌ la ikꞌujbꞌaꞌ kan u bꞌaal aqꞌoneꞌ tiꞌ tilat unqꞌa tetzeꞌ. As najeꞌ la ilon uvaꞌ ma at techbꞌubꞌal unqꞌa kꞌameꞌ jun qꞌii. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","As tul la ul veꞌt vibꞌaal u aqꞌoneꞌ, as achvebꞌal chit tatin u kꞌameꞌ asoj jik chit kat inima naj u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","As jik chit tuk val sete, tan la toksa veꞌt u bꞌaal aqꞌoneꞌ u kꞌameꞌ ilol tetz unqꞌa tetzeꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pet asoj paasan tzii u ilol tetz unqꞌa kꞌameꞌ la ibꞌaneꞌ, as ech la tal jeꞌ naj ileꞌ ste: «Yeꞌl u bꞌaal aqꞌoneꞌ la ul cheel,» chaj naj la taleꞌ. As la xeꞌt naj tiꞌ iqꞌosax unqꞌa tetz kꞌamileꞌ, kꞌuxh ixoj as kꞌuxh naj. As la txꞌaꞌn naj; as la ukꞌaꞌ naj; as la qꞌabꞌan naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","As tul aꞌ la ul veꞌt u bꞌaal aqꞌoneꞌ tu u qꞌiieꞌ uvaꞌ yeꞌ ni titzꞌa naj uvaꞌ la ul u bꞌaal aqꞌoneꞌ, tan yeꞌ tootzaj naj uvaꞌ kam oora as kam qꞌiil la ul u bꞌaal aqꞌoneꞌ. As xoꞌvebꞌal chit iqꞌospu veꞌt naj taꞌn u bꞌaal aqꞌoneꞌ. As ech ibꞌen veꞌt naj xoꞌl unqꞌa paasan tziieꞌ taꞌn u bꞌaal aqꞌoneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Tan abꞌiste u kꞌameꞌ uvaꞌ alel veꞌt kan u taqꞌoneꞌ ste as yeꞌ kat ibꞌana, as la ul iqꞌos veꞌt u bꞌaal aqꞌoneꞌ, tan yeꞌ kat inima uvaꞌ kat alpu ste, tan yeꞌ kat til isuuchil u aqꞌoneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pet ech koj umaꞌt u kꞌameꞌ uveꞌ yeꞌ ootzimal staꞌn kam uveꞌ alel kan taꞌn u bꞌaal aqꞌoneꞌ, tan asoj la ipaasa tzii, as bꞌiil kuxh la qꞌospu veꞌteꞌ, kꞌuxh tetz chittuꞌ uvaꞌ la qꞌospi tiꞌ uveꞌ kat ibꞌana. Tan abꞌil uvaꞌ nimal itxumbꞌal kat taqꞌ u Tiixheꞌ tiꞌ tootzit viyol Aakeꞌ, as nitxꞌebꞌ Aak uvaꞌ nimal bꞌaꞌnil la ibꞌan u uxhchileꞌ tukꞌ vibꞌii Aakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","As tuk val sete, tan kat ul in tiꞌ uvaꞌ la xeꞌt u Tiixheꞌ tiꞌ ibꞌanat isuuchil unqꞌa tenameꞌ as tiꞌ tok unqꞌa tenameꞌ tu kꞌaxkꞌo tiꞌ vipaaveꞌ echeꞌ ikuꞌ chꞌuꞌl umaj xamal vatz u txꞌavaꞌeꞌ. As aꞌ nunsaꞌ uvaꞌ kat koj oypiya. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pet vaꞌl chit ichꞌoꞌn u vaanxelaleꞌ, tan tuknal chit unpalebꞌe u kꞌaxkꞌoeꞌ. As techal chit tuk untzojpisa. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","As kamal netitzꞌa uvaꞌ kat ul in tiꞌ uvaꞌ bꞌaꞌn tatin unqꞌa uxhchileꞌ svatzaj vatz u txꞌavaꞌeꞌ, as tul yeꞌle tan aal tuk okoj veꞌt ixoꞌl. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tan tuknal chit ijatx tibꞌ ivatz oꞌvaꞌl unqꞌa uxhchileꞌ tu umaj kabꞌal. As sviꞌ kuxhtuꞌ la okkat ixoꞌl, tan kꞌuxh oxvaꞌl unqꞌa uxhchileꞌ la ikꞌul tibꞌ iyol sviꞌ, as yeꞌ la ikꞌul tibꞌ iyol tukꞌ kaꞌvaꞌte. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","As at unqꞌa bꞌaalaeꞌ tuk okoj ixoꞌl tukꞌ unqꞌa ikꞌaoleꞌ; as at unqꞌa kꞌaolaeꞌ tuk okoj ixoꞌl tukꞌ vibꞌaaleꞌ; as at unqꞌa txutxaeꞌ tuk okoj ixoꞌl tukꞌ u taleꞌ; as at unqꞌa tal u txutxaeꞌ tuk okoj ixoꞌl tukꞌ vitxutxeꞌ; as at unqꞌa alibꞌaeꞌ tuk okoj ixoꞌl tukꞌ u talibꞌeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","As ech tal veꞌt u Jesús ileꞌ xoꞌl unqꞌa tenameꞌ: —Tul uvaꞌ netil itxakpu u suutzꞌeꞌ tibꞌenebꞌal u qꞌiieꞌ, as ech netal ileꞌ: «La ul jabꞌal sqꞌejal,» chꞌex netaleꞌ. As ni tul u jabꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","As tul nenach itzaa u kajiqꞌeꞌ tu u bꞌenabꞌal kajiqꞌeꞌ, as netaleꞌ uvaꞌ: «Tuk eloj veꞌt saqꞌi,» chꞌex netaleꞌ. As nitel saqꞌi. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Ex kuxh kaꞌvatz tukꞌ vetxumbꞌaleꞌ! Tan nepal stuul kam uveꞌ tuk uchoj vatz u txꞌavaꞌeꞌ as vatz u almikaꞌeꞌ. ¿As kam qꞌi uveꞌ yeꞌ nepal tu uveꞌ ni tuch sexoꞌl cheel? ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","As bꞌaꞌneꞌ uvaꞌ la pal ex stuul tiꞌ ebꞌanat u jikla txumbꞌaleꞌ uveꞌ bꞌaꞌn vatz u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tan asoj at umaj uxhchil uvaꞌ ni tal ixochon setiꞌ vatz u bꞌanol isuuchil unqꞌa tenameꞌ, as tul yeꞌxnaj oon ex vatz u bꞌanol isuuchil unqꞌa tenameꞌ, as la eyol tukꞌ u uxhchileꞌ uveꞌ ni alon ixochat ex aqꞌal uvaꞌ la isotzsa tibꞌ epaav sevatzaj, tan asoj yeꞌle, as techal chit la ok veꞌt ex vatz u bꞌanol isuuchil unqꞌa tenameꞌ. As la aqꞌax veꞌt ok ex tiqꞌabꞌ u xeen tetz u kaarsaeꞌ. As la juplik veꞌt ok ex tu u kaarsaeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","As tuk val sete, tan yeꞌl exeꞌ la el chꞌuꞌl ex tu u kaarsaeꞌ. Pet lanal chit echoo skajayil, jatvaꞌl uvaꞌ la ijaj u bꞌanol isuuchil unqꞌa tenameꞌ sete,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","As an chit tu unqꞌa qꞌiieꞌ, as tal veꞌt kaꞌl unqꞌa uxhchil te Aak uvaꞌ iyatzꞌ unqꞌa isol u Pilato kaꞌl unqꞌa aa Galilea tul nik iyatzꞌ unqꞌa uxhchileꞌ unqꞌa txooeꞌ uveꞌ nitzꞌeꞌsal vatz u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","As ech tal veꞌt u Jesús ileꞌ: —¿Ma aꞌ netaleꞌ uvaꞌ nim chit ipaav chajnaj tiꞌ joltu unqꞌa aa Galilea? ¿As ma estiꞌeꞌ kat yatzꞌax veꞌt chajnaj uvaꞌ netaleꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","¡Yeꞌle taꞌ! Pet tuk val sete, tan asoj yeꞌ la ekꞌaxa etibꞌ tiꞌ vepaaveꞌ vatz u Tiixheꞌ, as echat kuxh la ebꞌaneꞌ echeꞌ unqꞌa uxhchileꞌ unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿As moj ech netitzꞌa tiꞌ vaaxajlavat unqꞌa najeꞌ uvaꞌ kat kam jaqꞌ u tzꞌajeꞌ uvaꞌ kat kuꞌ tu u Siloé? ¿As ma at pal ipaav chajnaj tiꞌ unjoltu unqꞌa uxhchileꞌ tu u Jerusalén uvaꞌ netaleꞌ? ¿As ma estiꞌeꞌ kat kam chajnaj? ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","¡Yeꞌle taꞌ! Pet ileꞌ tuk val sete, tan asoj yeꞌ la ekꞌaxa etibꞌ tiꞌ vepaaveꞌ vatz u Tiixheꞌ, as echat kuxh la ebꞌaneꞌ echeꞌ uveꞌ kat ibꞌan chajnaj,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","As tal veꞌt u Jesús umaꞌt u kꞌuchuvatz ech ileꞌ: —Atik umaꞌl u naj uvaꞌ avamalik umaꞌl u tzeꞌ staꞌn uvaꞌ higuera. As bꞌex til veꞌt naj u tzeꞌeꞌ xoꞌl unqꞌa ichikoeꞌ, tan kamal atik veꞌt ivatz tzeꞌ uvaꞌ nikat tal naj. Tul oon naj xeꞌ toj tzeꞌ, as yeꞌlik chit umaj ivatz tzeꞌ atike. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","As ech tal veꞌt naj ileꞌ te vikꞌameꞌ uveꞌ nik josqꞌin u ixoꞌl unqꞌa chikoeꞌ: «As kat ibꞌanlu oxvaꞌx yaabꞌ vuleꞌ tiꞌ unchukat ivatz u tzeꞌeꞌ. As yeꞌl umaj ivatz tzeꞌ unlejeꞌte. Pet tzokꞌpoj el u tzeꞌeꞌ, tan ¿kam chaj itxaꞌk tzeꞌ uvaꞌ la kuxh atin tzeꞌ tu vuntxꞌavaꞌeꞌ? As tul yeꞌl tzeꞌ ni vatzineꞌ,» tiꞌk u bꞌaal txꞌavaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","As ech tal veꞌt u kꞌam ileꞌ te u bꞌaal txꞌavaꞌeꞌ: «Pap, il chit umaꞌtoj yaabꞌ. As tuk unjosqꞌi tzeꞌ. As tuk voksa qꞌiꞌaꞌn xeꞌ toj tzeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","As kamal la vatzin veꞌt tzeꞌ. Asoj yeꞌle, as aꞌn la tzokꞌax veꞌt el tzeꞌ,» tiꞌk u kꞌameꞌ tal veꞌt te u bꞌaal txꞌavaꞌeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tu umaꞌl u xeem qꞌii, as nikat ichusun u Jesús tu umaꞌl u atinbꞌaleꞌ tetz nachbꞌal Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","As atik ok umaꞌl u ixoj tzitziꞌ uvaꞌ vaaxajlavaxnik yaabꞌ ichꞌoꞌn ixoj, tan chabꞌamal chit ikꞌolax ixoj taꞌn umaꞌl u subꞌul. As yeꞌl ixoj nikat itxꞌol veꞌt iyuꞌbꞌaꞌt tibꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tul til veꞌt u Jesús u ixojeꞌ, as imolo veꞌt tzan Aak. As ech tal veꞌt Aak ileꞌ te ixoj: —Ixoj, kat bꞌaꞌnxiy axh. Kat elyu u chꞌoꞌmeꞌ sakꞌatz,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","As taqꞌ veꞌt jeꞌ u Jesús iqꞌabꞌ tiꞌ ixoj. As yak kuxh ijikbꞌaꞌ veꞌt tibꞌ ixoj. As toksa veꞌt ixoj iqꞌii u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","U najeꞌ uveꞌ viqꞌesal u atinbꞌaleꞌ tetz nachbꞌal Tiixh as tul til naj uvaꞌ nikat ibꞌaꞌnxisa u Jesús umaꞌl u ixoj tu u xeem qꞌiieꞌ, as ul veꞌt iviꞌ naj. As ech tal veꞌt naj ileꞌ te unqꞌa tenameꞌ: —At vaajil qꞌii uvaꞌ la uch etaqꞌonveꞌ. As aꞌ qꞌiieꞌ la uch etuleꞌ tiꞌ ebꞌaꞌnxisaleꞌ. Pet yeꞌ la uchi uvaꞌ la bꞌaꞌnxisal ex tu u xeem qꞌiieꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","As ech tal veꞌt u Jesús ileꞌ te naj: —¡Ex chit kaꞌvatz tukꞌ veyoleꞌ! ¿Ma yeꞌ netex esaapu umaj vevaakaxheꞌ moj vekaayeꞌ tu u xeem qꞌiieꞌ tiꞌ bꞌen etaqꞌat tukꞌaꞌ txoo? ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","¿As ma yeꞌ la uch ibꞌaꞌnxisal u ixojeꞌ bꞌa vatz u chꞌoꞌmeꞌ tu u xeem qꞌiieꞌ uveꞌ netaleꞌ? Tan tiaal u Abraham taꞌ ixoj. As kat ibꞌanlu vaaxajlavax yaabꞌ uvaꞌ kꞌalel kuxh ixoj taꞌn u Satanás,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","As tul tabꞌi veꞌt unqꞌa uxhchileꞌ uvaꞌ nichꞌoꞌn taama tiꞌ u Jesús, as chꞌixvu kuxh veꞌt chajnaj vatz Aak. Pet vaꞌlik chit itxuqꞌtxun veꞌt unqꞌa tenameꞌ, tiꞌ Aak, tan tiꞌ uvaꞌ yeꞌ saach unqꞌa bꞌaꞌnileꞌ uvaꞌ kat ibꞌan Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","As ech tal veꞌt u Jesús ileꞌ: —Tuk val isuuchil sete tiꞌ uvaꞌ kam tok u tenameꞌ jaqꞌ u tijleꞌm u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Tan ech inaꞌ vitenam Aakeꞌ echeꞌ uvaꞌ kat ibꞌan u iiaeꞌ tetz u mostaza uvaꞌ bꞌex tava umaꞌl u naj tu vitxꞌavaꞌeꞌ. As nim chit kat oonkat tzeꞌ tul kat chꞌii veꞌteꞌ. As kat ibꞌan veꞌt unqꞌa tzꞌikineꞌ isok viꞌ unqꞌa iqꞌabꞌ tzeꞌeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","As ech tal veꞌt u Jesús ileꞌ: —As u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ, as ech ipaxit tibꞌeꞌ xoꞌl unqꞌa tenameꞌ ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","echeꞌ ipaxit bꞌen tibꞌ u levadura uvaꞌ kat toksa umaꞌl u ixoj xoꞌl oxvaꞌl paabꞌal u harina. As kat ipaxi veꞌt bꞌen tibꞌ u levadura xoꞌl viqꞌotil u paaneꞌ. As kat sipkꞌu veꞌt skajayil,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","As tul aalik ibꞌen u Jesús tu u Jerusalén, as pal ichus kan Aak u bꞌaꞌnla yoleꞌ te unqꞌa uxhchileꞌ tulaj unqꞌa tenameꞌ as tukꞌ tulaj unqꞌa talaj tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","As ech tal veꞌt umaꞌl u naj ileꞌ te Aak: —¿Pap, ma yeꞌxh jankꞌal unqꞌa uxhchileꞌ bꞌa la ok tu almikaꞌ?— tiꞌk naj. Ech tal veꞌt Aak ileꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Eyaꞌlutaj chit etibꞌ tiꞌ etok tu u tziꞌ kabꞌaleꞌ uveꞌ chꞌoo kuxh ivatz, tan ileꞌ la val sete uvaꞌ nimal unqꞌa tenameꞌ la tal tokeꞌ. As yeꞌ la uch tokeꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","tan tul uvaꞌ la txakpu veꞌt u bꞌaal kabꞌaleꞌ tiꞌ ijupat u tziꞌ kabꞌaleꞌ, as unqꞌa tenameꞌ uvaꞌ at kan tiꞌ kabꞌal, as la sikꞌin veꞌteꞌ. As ech la tal ileꞌ: «¡Bꞌan bꞌaꞌnil, pap! ¡Jajoꞌk oꞌ!» chaj la taleꞌ. As: «Yeꞌ vootzaj ex; as yeꞌ vootzaj kat tzaanajkat ex,» chaj u bꞌaal kabꞌaleꞌ la taleꞌl tzan. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","As ech la etal veꞌt ok ileꞌ: «¡Pap, oꞌeꞌ kat txꞌaꞌn oꞌ sakꞌatz; as kat ukꞌaꞌ oꞌ sakꞌatz! ¡As sukuxoꞌl kat chusunkat axh tulaj unqꞌa bꞌeyeꞌ!» chaj veꞌt unqꞌa tenameꞌ la taleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pet ech la tal veꞌt el tzan u bꞌaal kabꞌal ileꞌ sete: «Kat vallu sete uvaꞌ yeꞌ vootzaj ex as yeꞌ vootzaj katil tzaanajkat ex. Pet jetzꞌenoj el ex sunvatz, jankꞌal ex uvaꞌ ni bꞌanon u vaꞌlexheꞌ,» chaj veꞌt u bꞌaal kabꞌaleꞌ la taleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","As tul la etil veꞌt u Abraham, tukꞌ u Isaac, tukꞌ u Jacob, as tukꞌ unjoltu unqꞌa qꞌajsan tetz viyol u Tiixheꞌ uvaꞌ at veꞌt ok xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ, as la oqꞌ veꞌt ex. As la ikꞌux veꞌt tibꞌ etee, tan yeꞌl veꞌt etokebꞌal kꞌatz Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","As katil kuxh la tzaakat unjoltu unqꞌa tenameꞌ vatz u txꞌavaꞌeꞌ tiꞌ ikꞌulat tibꞌ. As la xonebꞌ veꞌteꞌ tiꞌ itxꞌaꞌn xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tan at unqꞌa uxhchileꞌ uveꞌ echen kꞌatz u Tiixheꞌ uveꞌ la ilpi tukꞌ vitxumbꞌaleꞌ. As aꞌeꞌ uvaꞌ jetzꞌennal veꞌt el kꞌatz Aak. As at unjolte uvaꞌ jetzꞌennal el kꞌatz Aak uvaꞌ la ilpi. As aꞌeꞌ uvaꞌ echen kꞌatz Aak. As at unqꞌa uxhchileꞌ uveꞌ bꞌaxel, as aꞌeꞌ imoxtel. As at unqꞌa uxhchileꞌ uveꞌ imoxtel, as aꞌeꞌ bꞌaxel,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","As tul kuxh tzojpu iyolon u Jesús, as bꞌex uloj kaꞌl unqꞌa fariseo vatz Aak. As ech ul tal chajnaj ileꞌ te Aak: —¡Oora kuxh el axh tzitzaꞌ, tan ni tal u Herodes ayatzꞌpeꞌ!— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ech tal veꞌt u Jesús ileꞌ: —U Herodes as ech vitxumbꞌaleꞌ echeꞌ chisi. As ech bꞌen etal ileꞌ te naj: «Ech ni tal u Jesús ileꞌ see: –Cheel tukꞌ qꞌejal tuk veesa el unqꞌa subꞌuleꞌ tiꞌ unqꞌa uxhchileꞌ. As tuk unbꞌaꞌnxisa unqꞌa aachꞌoꞌmeꞌ. As kabꞌi la untzojpisa veꞌt u vaqꞌoneꞌ,– taqꞌ u Jesús,» chaj ex la bꞌen etal te naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","As cheel, qꞌejal, as kabꞌi, techal la unbꞌan unqꞌa aqꞌoneꞌ. As la oon in tu u Jerusalén, tan yeꞌ la ibꞌaneꞌ uvaꞌ la kam in tu umaꞌtoj tenam uvaꞌ jit Jerusalén, in uvaꞌ in u qꞌajsan tetz viyol u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","¡Oyebꞌ chit evatz, ex aa Jerusalén, tan exeꞌ uvaꞌ kat yatzꞌon unqꞌa qꞌajsan tetz viyol u Tiixheꞌ! As kat esuti kꞌubꞌ tiꞌ unqꞌa uxhchileꞌ uvaꞌ kat ichaj tzan Aak. As jatpajul kuxh kat val unmolat ex sunkꞌatz echeꞌ nibꞌan umaj u txutx akꞌatx tukꞌ unqꞌa ineꞌeꞌ tul nijoji akꞌatx vineꞌeꞌ. As yeꞌ kat esaꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Estiꞌeꞌ ni val sete uvaꞌ tuk tzꞌinebꞌoj kan vetenameꞌ tu u Jerusalén tukꞌ tu u tostiixheꞌ uvaꞌ at sexoꞌl. As tuk val sete uvaꞌ jatu koj la etil veꞌt unvatz. Pet lanal ilej veꞌt u qꞌiieꞌ uvaꞌ ech la etal veꞌt ileꞌ sviꞌ: «¡Qoksataj iqꞌii Aak tukꞌ vibꞌii u Kubꞌaal Tiixheꞌ!» chaj veꞌt ex,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","As tul ok veꞌt u Jesús txꞌaꞌon tikabꞌal umaꞌl viqꞌesal unqꞌa fariseo tu u xeem qꞌiieꞌ, as nikat kuxh til bꞌen kaꞌl unqꞌa fariseo tukꞌ kaꞌt unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, tiꞌ uvaꞌ kam tuk ibꞌan Aak tu xeem qꞌiieꞌ, tan nik ichꞌoꞌn taama chajnaj tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","As atik ok umaꞌl u naj xoꞌl unqꞌa uxhchileꞌ vatz Aak uvaꞌ sipkꞌinajlik vichiꞌoleꞌ taꞌn umaꞌl u chꞌoꞌm. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","As ech tal veꞌt Aak ileꞌ te unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, tukꞌ unqꞌa fariseo: —¿Ma la uch ibꞌaꞌnxisal umaj aachꞌoꞌm tu u xeem qꞌiieꞌ? ¿Pet moj yeꞌle?— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","As yeꞌxhebꞌil tiini. As teqꞌo veꞌt tzan Aak u aachꞌoꞌmeꞌ. As ibꞌaꞌnxisa veꞌt Aak naj. As ichaj veꞌt bꞌen Aak naj uvaꞌ la bꞌen naj tikabꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","As ech tal veꞌt Aak ileꞌ te unqꞌa fariseo tukꞌ unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ: —Asoj la bꞌen veꞌt umaj vevaakaxheꞌ moj umaj vebꞌureꞌ tu umaj jul, ¿as ma yeꞌ la bꞌen eteqꞌo veꞌt jeꞌ tzan txoo tu u juleꞌ, kꞌuxh tu xeem qꞌii?— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","As yeꞌ kat chee veꞌt tiviꞌ chajnaj kam la tal chajnaj te Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","As til veꞌt u Jesús unqꞌa najeꞌ uveꞌ saꞌbꞌelali tiꞌ u bꞌaꞌnla txꞌaꞌoꞌmeꞌ. As tul til veꞌt Aak uvaꞌ nik itxaa chajnaj unqꞌa bꞌaxa xonlebꞌaleꞌ tiꞌ tok vatz u meexhaeꞌ, as ech tal veꞌt Aak ileꞌ tiꞌ umaꞌt u kꞌuchuvatz: ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Asoj abꞌil la saꞌbꞌelan axh tu umaj nimla qꞌii tiꞌ teqꞌot tibꞌ umaj meꞌal ikꞌaol umaj uxhchil, as yeꞌ la xonebꞌ axh tu u bꞌaxa xonlebꞌaleꞌ, tan jit kuxh nim uvaꞌ la ul umaꞌt naj uvaꞌ nim talchu seeꞌ. As la molol veꞌt ok naj taꞌn u bꞌaal kabꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","As la ul tal u bꞌaal kabꞌaleꞌ see uvaꞌ la aaqꞌ kan u xonlebꞌaleꞌ. As la kuxh chꞌixvu veꞌt axh vatz unqꞌa uxhchileꞌ, tan tiꞌ uvaꞌ la bꞌen axh xonloj timoxtel u xonlebꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Asoj la saꞌbꞌelal axh, as la xonebꞌ axh timoxtel u xonlebꞌaleꞌ, tan la ibꞌaneꞌ uvaꞌ la ul tal veꞌt u bꞌaal kabꞌaleꞌ see uvaꞌ: «Siꞌu. Xonebꞌen tziꞌlaꞌ tu u bꞌaxa xonlebꞌaleꞌ,» chaj chꞌelel axh. As la ok veꞌt aqꞌii vatz unqꞌa uxhchileꞌ uveꞌ xonleꞌl sakꞌatz vatz u meexhaeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Estiꞌeꞌ tuk val sete uvaꞌ abꞌil uveꞌ la toksa jeꞌ iqꞌii, as la el iqꞌii. Pet abꞌil uveꞌ yeꞌ la toksa jeꞌ iqꞌii as la oksal iqꞌii,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","As ech tal veꞌt u Jesús ileꞌ te u najeꞌ uveꞌ saꞌbꞌelan Aak: —Tul la abꞌan umaj bꞌaꞌnla txꞌaꞌoꞌm, as yeꞌ la amolo tzan unqꞌa eetz kꞌultziꞌeꞌ tukꞌ unqꞌa eetzꞌin aatzikeꞌ, as mitaꞌn kuxh unqꞌa abꞌesiinoeꞌ uveꞌ txꞌioliqꞌii, tan la iqꞌaavisa ichꞌexeleꞌ see. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pet tul la abꞌan umaj bꞌaꞌnla txꞌaꞌoꞌm, as aꞌ unqꞌa meebꞌaꞌeꞌ la amolo, tukꞌ unqꞌa koꞌxeꞌ, tukꞌ unqꞌa kuchꞌeꞌ, as tukꞌ unqꞌa tzoteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","As achvebꞌal axh la ibꞌaneꞌ, tan yeꞌl ichꞌexel la aqꞌpu veꞌt see. Pet aꞌ u Tiixheꞌ la aqꞌon ichꞌexel see tu u qꞌiieꞌ uvaꞌ la ul veꞌt taama unqꞌa kamnajeꞌ uvaꞌ txꞌaael veꞌt u taanxelaleꞌ taꞌn Aak,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","As tabꞌi veꞌt umaꞌl u naj viyol u Jesús, uvaꞌ xonlik ok vatz u meexha kꞌatz Aak. As ech tal veꞌt naj ileꞌ te Aak: —¡Achvebꞌal chiteꞌ bꞌa unqꞌa uxhchileꞌ uveꞌ la txꞌaꞌn veꞌt kꞌatz u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ!— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ech tal veꞌt u Jesús ileꞌ: —Kat ibꞌan umaꞌl u naj tuch umaꞌl u bꞌaꞌnla txꞌaꞌoꞌm. As aꞌ chit mamaꞌla tenameꞌ kat isaꞌbꞌela naj tiꞌ u txꞌaꞌoꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","As tul kat ilej veꞌt u txꞌaꞌoꞌmeꞌ tetz kuꞌ qꞌii, as ech tal veꞌt naj ileꞌ te vikꞌameꞌ tiꞌ bꞌen talat te unqꞌa uxhchileꞌ uveꞌ kat saꞌbꞌelali: «Koꞌnaj txꞌaꞌon, tan il u bꞌaꞌnla echbꞌubꞌal ileꞌ bꞌanel veꞌt tucheꞌ,» tiꞌk u kꞌameꞌ bꞌex tala. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","As junun chit ijajat veꞌt unqꞌa uxhchileꞌ kuybꞌal te u kꞌameꞌ. As ech tal veꞌt umaꞌl u naj ileꞌ: «La isotzsa aak unpaav, tan in chit yeꞌ la uch unbꞌeneꞌ, tan kat unloqꞌlu unbꞌiil vuntxꞌavaꞌ. As techal tuk bꞌen vileꞌ,» tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","As ech tal veꞌt umaꞌt naj ileꞌ te u kꞌameꞌ: «La isotzsa aak unpaav, tan kat unloqꞌlu oꞌtzumul vunbꞌooyaxh. As maꞌt unchus txoo tiꞌ aqꞌon,» tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","As ech tal umaꞌt naj ileꞌ unpajte: «La isotzsa aak unpaav, tan aꞌn in kat veqꞌo vibꞌ tukꞌ vixqel. Estiꞌeꞌ yeꞌ la uch vooneꞌ,» tiꞌk naj tal te u kꞌameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","As qꞌaav veꞌt u kꞌameꞌ. As bꞌex tal veꞌt u kꞌameꞌ te u najeꞌ uvaꞌ kat bꞌanon tuch u txꞌaꞌoꞌmeꞌ kam uvaꞌ alpu veꞌt ste. As tul tabꞌi veꞌt u najeꞌ uvaꞌ bꞌanon tuch u txꞌaꞌoꞌmeꞌ, as ul veꞌt iviꞌ naj. As ech tal veꞌt naj ileꞌ te vikꞌameꞌ: «¡Oora! ¡Kuxh tu bꞌey, xoꞌlaj kabꞌal! As kuxh molo tzan unqꞌa meebꞌaꞌeꞌ, tukꞌ unqꞌa koꞌxeꞌ, tukꞌ unqꞌa tzoteꞌ, as tukꞌ unqꞌa kuchꞌeꞌ. As uloj txꞌaꞌon tu vunkabꞌaleꞌ,» tiꞌk naj tal te vikꞌameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","As ech tal veꞌt u kꞌam ileꞌ te u najeꞌ: «Pap, kat unbꞌanlaꞌ jankꞌal uvaꞌ kat aal sve. Pet yeꞌ nooj u kabꞌaleꞌ, tan atil atinbꞌal,» tiꞌk u kꞌameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ech tal veꞌt u naj ileꞌ te u kꞌameꞌ: «¡Kuxh unpajte! ¡Kuxh xoꞌl unqꞌa vitzeꞌ! As kuxh yaꞌlu tzan unqꞌa uxhchileꞌ tiꞌ tok chꞌuꞌl tu vunkabꞌaleꞌ, tan aꞌ ni valeꞌ uvaꞌ la noo vunkabꞌaleꞌ tiꞌ u txꞌaꞌoꞌmeꞌ,» tiꞌk u najeꞌ tal te u kꞌameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Estiꞌeꞌ ni val sete uvaꞌ yeꞌl umaj ex la txꞌaꞌn ex sunkꞌatz, jankꞌal ex uvaꞌ bꞌaxa kat saꞌbꞌelal ex tiꞌ etxꞌaꞌn sunkꞌatz,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","As mamaꞌla tenam xekik tiꞌ u Jesús. As isuchqꞌi veꞌt tibꞌ Aak tiꞌ isajil unqꞌa tenameꞌ. As ech tal veꞌt Aak ileꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Asoj at umaj uxhchil la xekebꞌ sviꞌ tul yeꞌ nixoꞌni veꞌt in tiꞌ vibꞌaaleꞌ, tukꞌ vitxutxeꞌ, tukꞌ u tixqeleꞌ, tukꞌ unqꞌa meꞌal ikꞌaoleꞌ, tukꞌ unqꞌa titzꞌin tatzikeꞌ, as tukꞌ vitiichajileꞌ unpajte, as yeꞌ la uch veꞌt tok chusulibꞌil sunkꞌatz. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","As abꞌil uvaꞌ yeꞌ la kuyun unqꞌa kꞌaxkꞌoeꞌ tiꞌ ixekebꞌ sviꞌ, as yeꞌ la uch tok veꞌt chusulibꞌil sunkꞌatz. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","As la val sete uvaꞌ ech la ebꞌaneꞌ echeꞌ umaj naj uvaꞌ la tal ilakat ikabꞌal. As tul yeꞌxnaj xeꞌt naj tiꞌ ilakat u kabꞌaleꞌ, as la xonebꞌ naj tiꞌ titzꞌataꞌ ma la tzꞌaj vipuaj najeꞌ tiꞌ ilakat vikabꞌaleꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","tan asoj yeꞌ la olebꞌ naj, as la kuxh tzeꞌlel veꞌt naj taꞌn unqꞌa uxhchileꞌ uveꞌ la pal ilon kan u taqꞌon najeꞌ. As tul maꞌt taqꞌat kuꞌ naj u tzꞌajeꞌ tiꞌ ixeꞌt u kabꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","As ech la alpu veꞌt ileꞌ tiꞌ naj: «Kat kuxh ixeꞌtisa u najeꞌ u kabꞌaleꞌ. As yeꞌ kat itxꞌol veꞌt naj itzojpisaleꞌ,» chaj chꞌelel naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","As ech la ebꞌaneꞌ echeꞌ la ibꞌan umaj ijlenaal uvaꞌ la xeꞌtik tzan umaꞌt ijlenaal stiꞌ, tan bꞌaxeleꞌ tuk ibꞌan jeꞌ naj tiviꞌ ma la olebꞌ laval mil visol najeꞌ tiꞌ viinqil mil visol umaꞌt u ijlenaaleꞌ uvaꞌ la ul bꞌanon chꞌaꞌo stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Asoj la til u ijlenaaleꞌ uvaꞌ yeꞌ la olebꞌ naj tukꞌ laval mil visoleꞌ, as la ichaj veꞌt bꞌen naj umaꞌl vichaj tiꞌ iyaꞌsat u chꞌaꞌoeꞌ tul uvaꞌ yeꞌxnaj ul unqꞌa soleꞌ tiꞌ ibꞌanat chꞌaꞌo stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Estiꞌeꞌ ni val sete uvaꞌ abꞌiste umaj ex uvaꞌ yeꞌ la etaqꞌ kan unqꞌa etetzeꞌ skajayil sviꞌ, as yeꞌ la uch etok veꞌt chusulibꞌil sunkꞌatz. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","As chꞌiꞌumaleꞌ u atzꞌameꞌ. Pet asoj la motx veꞌt vipitzꞌpolil u atzꞌameꞌ, as la koj txakon veꞌteꞌ tan la koj uch ichee veꞌt ipitzꞌpolil unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","As mitaꞌn la koj txakoni tiꞌ tok siqꞌiꞌaꞌnil u txꞌavaꞌeꞌ. Pet la kuxh makꞌpik veꞌt eleꞌ. As abꞌiste ex uveꞌ nepal tu vunyoleꞌ, as etabꞌitaj uveꞌ ni valeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","As tul nikat ichusun u Jesús, as nimal chit unqꞌa molol puajeꞌ tetz u Roma tukꞌ unjoltu unqꞌa uxhchileꞌ uveꞌ eesan kuxh tibꞌ tu bꞌey, as kat jetzꞌen ok kꞌatz Aak tiꞌ tabꞌit u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pet ech koj unqꞌa fariseo tukꞌ unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, tan nikat ichꞌoꞌn taama chajnaj tiꞌ u Jesús. Ech nikat tal chajnaj ileꞌ: —¡Kam bꞌan taꞌn u najeꞌ! Tan nu kuxh ikꞌuloꞌk naj unqꞌa uxhchileꞌ skꞌatz uveꞌ aapaav chittuꞌ. As nitxꞌaꞌn naj tukꞌ unqꞌa uxhchileꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","As ech tal veꞌt u Jesús ileꞌ tukꞌ umaꞌt u kꞌuchuvatz te chajnaj: ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Asoj at umaj ex uvaꞌ at oꞌkꞌaloj (100) ekaneeroꞌ asoj la tzꞌejxik kan umaj txoo, ¿as ma yeꞌ la etaqꞌ kan u bꞌelelaval toꞌkꞌal (99) vekaneeroꞌeꞌ vatz chaqꞌaala as la bꞌen echuk u txooeꞌ uveꞌ kat tzꞌejxik kan? As techal la elej txoo. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","As tul la elej txoo, as la txuqꞌtxun veꞌt ex. As la etaqꞌ veꞌt jeꞌ viꞌ echelebꞌ tiꞌ eteqꞌot veꞌt tzan txoo xoꞌl vimooleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","As tul la oon veꞌt ex tu kabꞌal, as la emolo veꞌt unqꞌa etetz kꞌultziꞌeꞌ tukꞌ unqꞌa ebꞌesiinoeꞌ. As ech la etal ileꞌ: «¡Chiibꞌojtaj ex sunkꞌatz! Tan kat unlejlu vunkaneeroꞌeꞌ uvaꞌ kat tzꞌejxi,» chaj ex la etaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","As ileꞌ la val sete, tan at chiibꞌichil tu almikaꞌ tiꞌ umaꞌl u aapaaveꞌ uveꞌ aꞌn kat ikꞌaxa tibꞌ vatz u Tiixheꞌ tiꞌ bꞌelelaval toꞌkꞌal (99) unqꞌa uxhchileꞌ uveꞌ jik veꞌt itxumbꞌal as jit tzꞌajinal la ikꞌaxa tibꞌ vatz Aak uveꞌ ni tal jeꞌ ste. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","As echeꞌ umaj ixoj uvaꞌ at laval ipuaj uvaꞌ nim ijaꞌmil, asoj la itzꞌej ixoj umaj vas ipuajeꞌ, as la imatx ixoj xamal tiꞌ ichukat vipuajeꞌ. As la teesa ixoj chꞌis tu kabꞌal techanal chit la ilej ixoj vipuajeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","As tul la ilej ixoj, as la bꞌen imolo veꞌt ixoj unqꞌa tetz kꞌultziꞌeꞌ tukꞌ unqꞌa ibꞌesiinoeꞌ. As ech la tal veꞌt ixoj ileꞌ: «¡Chiibꞌojtaj ex sunkꞌatz! Tan kat unlejlu vas unpuajeꞌ uveꞌ kat untzꞌeja,» chaj veꞌt ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","As ileꞌ la val sete, tan at chiibꞌichil xoꞌl unqꞌa ángel uvaꞌ tetz u Tiixheꞌ tiꞌ umaꞌl u aapaaveꞌ uveꞌ kat ikꞌaxa tibꞌ vatz u Tiixheꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","As ech tal u Jesús ileꞌ: —Atik umaꞌl u naj uvaꞌ atik kaꞌvaꞌl vikꞌaol. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","As ok veꞌt u itzꞌinaeꞌ vatz vibꞌaaleꞌ. As ech tal naj ileꞌ: «Pap, aqꞌ vunvaatzileꞌ sve cheel uvaꞌ la vetzi,» tiꞌk naj. As ijatx veꞌt u bꞌaalaeꞌ vimeebꞌaꞌleꞌ vatz unqꞌa ikꞌaoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","As yeꞌ kuxh jatvaꞌl qꞌii stuul, as imol veꞌt u itzꞌinaeꞌ vijaꞌmil vivaatzileꞌ. As bꞌen veꞌt naj tu umaꞌt tenam uvaꞌ naach chittuꞌ tiꞌ teesat tibꞌ tu bꞌey tukꞌ vipuajeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","As tul maꞌtik teesat veꞌt naj itxumbꞌal tukꞌ vipuajeꞌ skajayil, as kat uch umaꞌl u mam vaꞌy tu u tenameꞌ. As yeꞌl veꞌt tetz naj atike. As kat ipalebꞌe veꞌt naj vaꞌy. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","As bꞌex ichuk veꞌt naj taqꞌon xeꞌ umaꞌl u aatenam. As ichaj veꞌt bꞌen u aatenameꞌ naj tiꞌ ixeeat chicham. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","As nikat tal veꞌt naj techbꞌut unqꞌa techbꞌubꞌal unqꞌa chichameꞌ, tan yeꞌxhebꞌil nikat aqꞌon techbꞌubꞌal naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","As qꞌoon titzꞌa veꞌt jeꞌ naj uvaꞌ nik ipalebꞌe naj kꞌaxkꞌo. As ech tal veꞌt jeꞌ naj ileꞌ ste: «Koꞌlekoleꞌ unqꞌa aqꞌonvileꞌ at xeꞌ aak unbꞌaaleꞌ. As noonaj kuxh chajnajeꞌ. As tul il in ilaꞌ tuk kamoj in taꞌn vaꞌy. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Pet tuk qꞌaavoj in kꞌatz aak unbꞌaaleꞌ. As ech la bꞌen val ileꞌ te aak: –Pap, kat paavinyu veꞌt in vatz u Tiixheꞌ as savatz unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","As jit veꞌt vetzeꞌ uvaꞌ in akꞌaol. Pet ooksa kuxh veꞌt in echeꞌ umaj akꞌam, chaj in la val te aak,– tiꞌk naj tal jeꞌ ste.» ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","As txakpu veꞌt naj. As qꞌaav veꞌt naj kꞌatz vibꞌaaleꞌ. Tul bꞌiit telik tul naj kꞌatz vibꞌaaleꞌ, as til veꞌt bꞌen aak vikꞌaoleꞌ. As kat chit jeꞌ chꞌuꞌl taama aak tiꞌ naj. As kat itxum aak ivatz naj. As qꞌax ibꞌen veꞌt aak tiꞌ ikꞌulat naj. As ijele veꞌt aak naj. Itzꞌubꞌ veꞌt aak txala itziꞌ naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","As ech tal veꞌt naj ileꞌ te vibꞌaaleꞌ: «Pap, kat paavinyu veꞌt in vatz u Tiixheꞌ; as kat paavinyu veꞌt in savatz. As jit veꞌt vetzeꞌ uvaꞌ in akꞌaol,» tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pet ech tal veꞌt aak ileꞌ te unqꞌa ikꞌameꞌ: «Bꞌen eteqꞌotaj el tzan unqꞌa bꞌaꞌnla oksaꞌmeꞌ. As etoksataj tiꞌ vunkꞌaoleꞌ. As etaqꞌtaj kuꞌ u ixkolqꞌabꞌeꞌ viꞌ iqꞌabꞌ naj. As etoksataj ixaꞌp naj tu toj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","As bꞌenoj eteqꞌotaj tzan u tzaqꞌal vaakaxheꞌ. As eyatzꞌtaj, tan la txꞌaꞌn oꞌ. As la kubꞌan umaꞌl u nimla qꞌii, ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","tan kamyeꞌ vunkꞌaoleꞌ ni valeꞌ. As tul isleꞌl najeꞌ vil. As tzꞌejxiy najeꞌ ni valeꞌ. As il naj ileꞌ kat ulya,» tiꞌk vibꞌaal najeꞌ tala. As xeꞌt veꞌt u nimla qꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","As atik bꞌen u atzikaeꞌ tu aqꞌon. As tul ul veꞌt naj najlich u kabꞌaleꞌ, as tabꞌi veꞌt naj toqꞌ unqꞌa qꞌoobꞌeꞌtzeꞌ, tan vaꞌl chit ichiibꞌ veꞌt unqꞌa uxhchileꞌ tu u nimla qꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","As imolo veꞌt naj umaꞌl u kꞌameꞌ. As ichꞌoti veꞌt naj: «¿Kam uveꞌ ni tucheꞌ?» tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","As ech tal veꞌt u kꞌam ileꞌ te naj: «¡Aꞌ veetzꞌineꞌ kat ulya! As kat tal aak abꞌaaleꞌ iyatzꞌpu u tzaqꞌal vaakaxheꞌ tiꞌ ibꞌanat u nimla qꞌiieꞌ, tan tiꞌ uvaꞌ bꞌaꞌn kuxh tul veetzꞌineꞌ kat uli,» tiꞌk u kꞌameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","As ul veꞌt iviꞌ u atzikaeꞌ. As yeꞌ nikat isaꞌ veꞌt naj tok tu kabꞌal. As el veꞌt chꞌuꞌl vibꞌaal najeꞌ tiꞌ imutxbꞌet ok aak naj tu kabꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pet ech tal veꞌt u atzika ileꞌ: «Nimax veꞌt yaabꞌ vaqꞌonvu sakꞌatz. As yeꞌ atixoj vixva kan axh. Pet nimamal axh taꞌ svaꞌn. As yeꞌ atixoj chit ooya umaj tal unsikꞌ tiꞌ unbꞌanat umaj unnimla qꞌii tukꞌ unqꞌa vetz kꞌultziꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pet ech koj vakꞌaoleꞌ uveꞌ kat teesa tibꞌ tu bꞌey tukꞌ unqꞌa ixojeꞌ uvaꞌ yanaꞌs. As tul kat qꞌaavik tzan naj, as kat aal iyatzꞌpu veꞌt u tzaqꞌal vaakaxheꞌ tiꞌ akꞌulat naj,» tiꞌk u atzikaeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","As ech tal veꞌt u bꞌaala ileꞌ: «Unkꞌaol, at chit axheꞌ taꞌ sunkꞌatz bꞌenameen. As jankꞌal chit unqꞌa vetzeꞌ uveꞌ ati as eetz chiteꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pet bꞌaꞌneꞌ taꞌ uvaꞌ la txuqꞌtxun oꞌ, tan kamnajlu veꞌteꞌ u eetzꞌineꞌ nikat valeꞌ. As il naj ileꞌ vil isleꞌle. As tzꞌejxinal najeꞌ sunvatz. ¡As il naj ileꞌ ati!» tiꞌk u bꞌaalaeꞌ tal te u atzikaeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","As ech tal veꞌt u Jesús ileꞌ te unqꞌa ichusulibꞌeꞌ: —Atik umaꞌl u naj uvaꞌ txꞌioliqꞌii. As atik umaꞌl vikꞌam naj uvaꞌ nikat ilon isuuchil unqꞌa itxꞌiibꞌal iqꞌii najeꞌ. As bꞌex alaxoj te u bꞌaal aqꞌoneꞌ uvaꞌ vaꞌlexh kuxh itxumbꞌal u kꞌameꞌ, tan nikat kuxh teesa naj itxumbꞌal vitxꞌiibꞌal iqꞌii u bꞌaal aqꞌoneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","As imolo veꞌt u bꞌaal aqꞌoneꞌ u kꞌameꞌ. As ech tal veꞌt naj ileꞌ te u kꞌameꞌ: «As kat vabꞌil yol tiꞌ u aaqꞌoneꞌ. As oksa kan tachul unqꞌa veeꞌ kat abꞌana, tan la el veꞌt axh,» tiꞌk u bꞌaal aqꞌoneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","As ibꞌan veꞌt jeꞌ u ilol isuuchil u aqꞌoneꞌ tiviꞌ. As ech tal naj ileꞌ: «¿Kameꞌ qꞌi tuk unbꞌaneꞌ? Tan ni teesa veꞌt in u bꞌaal aqꞌoneꞌ tiꞌ u vaqꞌoneꞌ. As tul yeꞌl unyakꞌil ati tiꞌ vaqꞌonvat u txꞌavaꞌeꞌ. As la chꞌixvu veꞌt in tiꞌ unjoyat unpuaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Pet ech tuk unbꞌan ileꞌ tiꞌ uvaꞌ at unqꞌa uxhchileꞌ uvaꞌ la lochon in. As la ikꞌul in tikabꞌal tul uvaꞌ yeꞌl vaqꞌon ati,» tiꞌk naj tal jeꞌ ste. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","As junun imolot veꞌt naj unqꞌa najeꞌ uveꞌ atik itxꞌoj xeꞌ u bꞌaal aqꞌoneꞌ. As ech tal veꞌt naj ileꞌ te umaꞌl u naj uveꞌ atik itxꞌoj: «¿Jatvaꞌleꞌ vatxꞌojeꞌ at xeꞌ u bꞌaal aqꞌoneꞌ?» tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ech tal veꞌt u naj ileꞌ: «Oꞌkꞌalal (100) toneel aceite vuntxꞌojeꞌ,» tiꞌk u najeꞌ. As ech tal veꞌt u ilol isuuchil u aqꞌon ileꞌ: «Il vavuꞌuj ilaꞌ bꞌa. As xonebꞌen. Oora kuxh kubꞌan ichꞌexel u uꞌujeꞌ. As laval kuxh toxkꞌal (50) toneel la qaqꞌ veꞌt kuꞌ tu u uꞌujeꞌ,» tiꞌk u ilol isuuchil u aqꞌoneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","As ech tal veꞌt naj ileꞌ te umaꞌt u najeꞌ: «¿Jatvaꞌl vatxꞌojeꞌ at xeꞌ u bꞌaal aqꞌoneꞌ?» tiꞌk naj. Ech tal veꞌt u naj ileꞌ: «Oꞌkꞌalal (100) ijatz trigo vuntxꞌojeꞌ,» tiꞌk naj. As ech tal veꞌt u ilol isuuchil u aqꞌon ileꞌ: «Il vavuꞌuj ilaꞌ tetz vatxꞌojeꞌ. Oora kuxh kubꞌan ichꞌexel. As mutxꞌul (80) kuxh ijatz la qaqꞌ kuꞌ tu u uꞌujeꞌ,» tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","As tul tabꞌi veꞌt u bꞌaal aqꞌoneꞌ kam uvaꞌ nik ibꞌan u ilol tetz isuuchil u aqꞌoneꞌ tukꞌ unqꞌa itxumbꞌal najeꞌ uvaꞌ vaꞌlexh kuxh nik ibꞌaneꞌ, as toksa veꞌt u bꞌaal aqꞌoneꞌ iqꞌii naj, tan tiꞌ uvaꞌ tzitumal chit naj. As kat iloch naj unqꞌa najeꞌ uvaꞌ atik itxꞌoj xeꞌ u bꞌaal aqꞌoneꞌ, aqꞌal uvaꞌ chajnaj la lochon veꞌt naj tul la eesal naj tu taqꞌoneꞌ. Estiꞌeꞌ ni val sete uvaꞌ tzitumal unqꞌa uxhchileꞌ uveꞌ yeꞌ ni niman u Tiixheꞌ tiꞌ ibꞌanat isuuchil u tatineꞌ tukꞌ vimooleꞌ, tiꞌ unqꞌa uxhchileꞌ uvaꞌ ni niman u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","As la val sete, etxakonsataj unqꞌa emeebꞌaꞌleꞌ vatz u txꞌavaꞌeꞌ tiꞌ elochat vemooleꞌ. As tul la yaꞌ veꞌt etatin vatz u txꞌavaꞌeꞌ, as la ikꞌul veꞌt ok ex u Tiixheꞌ tu uveꞌ atkat veꞌt vetiichajileꞌ uveꞌ yeꞌl iyaꞌtebꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Tan abꞌil uvaꞌ jik chit itxumbꞌal tiꞌ tilat isuuchil unbꞌooj uvaꞌ kat oksal tiqꞌabꞌ, as echat chit la ibꞌaneꞌ, kꞌuxh nimal chit la aqꞌax ste tiꞌ tilat isuuchil. As abꞌil uveꞌ jit jik itxumbꞌal tiꞌ tilat isuuchil unbꞌooj uvaꞌ la oksal tiqꞌabꞌ, as echat chit la ibꞌaneꞌ, kꞌuxh nimal chit la aqꞌax ste. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Estiꞌeꞌ tuk val sete, tan asoj yeꞌ kat etil isuuchil unqꞌa txꞌiibꞌal qꞌiieꞌ tibꞌaꞌnil uvaꞌ kat aqꞌax sete, as yeꞌxhebꞌileꞌ la aqꞌon veꞌt u txꞌiibꞌal qꞌiieꞌ sete uvaꞌ yeꞌl iyaꞌtebꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Tan asoj yeꞌ kat etxꞌol etilat isuuchil u tetz u Tiixheꞌ uvaꞌ kat aqꞌax sete vatz u txꞌavaꞌeꞌ, as ¿aal kol la aqꞌax unqꞌa bꞌaꞌnileꞌ qꞌa sete uvaꞌ nisaꞌ u Tiixheꞌ taqꞌat sete? ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","As la val sete, tan yeꞌ la uch taqꞌonvu umaj kꞌam xeꞌ kaꞌvaꞌl unqꞌa bꞌaal aqꞌoneꞌ, tan la tixva kan u kꞌameꞌ umaꞌl u bꞌaal aqꞌoneꞌ. As la ixoꞌni umaꞌte. As moj la inima u kꞌameꞌ umaꞌl u bꞌaal aqꞌoneꞌ. As yeꞌ la inima umaꞌte. Estiꞌeꞌ la val sete, etoksataj etaama tiꞌ u Tiixheꞌ, tan asoj netoksa etaama tiꞌ u txꞌiibꞌal eqꞌiieꞌ vatz u txꞌavaꞌeꞌ, as yeꞌ la uchi uvaꞌ la etoksa etaama tiꞌ enimat u Tiixheꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Tul atik kaꞌl unqꞌa fariseo uvaꞌ aal chit nikattel taama tiꞌ u puajeꞌ. As tul tabꞌi chajnaj viyol u Jesús, as tzeꞌlebꞌal kuxh Aak te chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","As ech tal veꞌt u Jesús ileꞌ te chajnaj: —As ni kuxh ebꞌensa etibꞌ jikla aamail vatz unqꞌa emooleꞌ. As ootzimaleꞌ vetaanxelaleꞌ taꞌn u Tiixheꞌ, tan at unqꞌa txumbꞌaleꞌ uvaꞌ ni toksa unqꞌa tenameꞌ taama stiꞌ. As aꞌeꞌ uvaꞌ yeꞌ nisaꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","As aꞌ unqꞌa yoleꞌ uvaꞌ tzꞌibꞌamal kan taꞌn u Moisés as tukꞌ kaꞌt unqꞌa qꞌajsan tetz viyol u Tiixheꞌ, as aꞌeꞌ nik chusun ex. As tul kat ul veꞌt u Xhuneꞌ uvaꞌ nik aqꞌon kuꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ. As yeꞌ saach unqꞌa tenameꞌ niyaꞌlu tibꞌ tiꞌ tok xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u Tijeleꞌm u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pet tuk val sete, tan yeꞌ kuxh kꞌaxkꞌo isotz u almikaꞌeꞌ tukꞌ u vatz txꞌavaꞌeꞌ. Pet ech kojeꞌ unqꞌa yoleꞌ uveꞌ tzꞌibꞌamal kan tu u tzaqꞌiteꞌ taꞌn u Moisés, tan tuk chit ibꞌaneꞌ skajayil kam uveꞌ tzꞌibꞌamal kan. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","As abꞌil uvaꞌ la ijatxeꞌl u tixqeleꞌ as la teqꞌo tibꞌ tukꞌ umaꞌt ixoj, as la paavin veꞌt naj. As abꞌil uveꞌ la teqꞌo tibꞌ tukꞌ u ixojeꞌ uveꞌ jatxel tibꞌ tukꞌ vitzumeleꞌ, as la paavin veꞌteꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","As ech tal u Jesús ileꞌ: —Atik umaꞌl u naj uvaꞌ txꞌioliqꞌii. As bꞌaꞌnla chaj oksaꞌm chit nikat toksa naj. As xoꞌvebꞌal chit naj tukꞌ unqꞌa tetzeꞌ, tan nik ibꞌan naj unqꞌa bꞌaꞌnla chaj txꞌaꞌoꞌmeꞌ jun qꞌii. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","As atik umaꞌt vas naj uvaꞌ meebꞌaꞌik chittuꞌ uvaꞌ Lázaro ibꞌii. As aꞌ chit chineꞌ atik tiꞌ vas najeꞌ. As nikat ixonebꞌ naj jun qꞌii tziꞌ ikabꞌal u txꞌioliqꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","As nikat tachva u Lázaro uvaꞌ la techbꞌu unqꞌa vuy txꞌixeꞌ uveꞌ nikat ichajpik kuꞌ viꞌ vimeexha u txꞌioliqꞌiieꞌ. Tul xonlik u Lázaro tziꞌ ikabꞌal u txꞌiol iqꞌiieꞌ, as ul unqꞌa txꞌiꞌeꞌ tiꞌ ileqꞌul unqꞌa chineꞌ uveꞌ atik tiꞌ u Lázaro. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","As tul kam veꞌt u meebꞌaꞌeꞌ uvaꞌ Lázaro, as ul eqꞌoloj veꞌt jeꞌ naj taꞌn unqꞌa ángel. As aꞌ oonkat naj kꞌatz u Abraham tu almikaꞌ. As tul kam veꞌt u txꞌioliqꞌiieꞌ, as bꞌex mujaxoj veꞌt naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","As vaꞌlik chit ipalebꞌet veꞌt u txꞌiol iqꞌiieꞌ u kꞌaxkꞌoeꞌ tu u atinbꞌaleꞌ uvaꞌ atikkat unqꞌa kamnajeꞌ. As kaꞌyik veꞌt jeꞌ naj tu almikaꞌ. As til veꞌt jeꞌ naj u Abraham tukꞌ u Lázaro, tan atik u Lázaro kꞌatz u Abraham. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","As sikꞌin veꞌt jeꞌ naj tu almikaꞌ. Ech tal veꞌt naj ileꞌ: «¡Kubꞌaal Abraham, txum unvatz! Bꞌan bꞌaꞌnil sve. Chaj kuꞌ tzan u Lázaro tiꞌ ul iliꞌbꞌisat vuntziꞌeꞌ tukꞌ unbꞌooj aꞌ taꞌn u viꞌ iqꞌabꞌeꞌ, tan vaꞌl unpalebꞌet unqꞌa kꞌaxkꞌoeꞌ tzitzaꞌ tu u xamaleꞌ,» tiꞌk u txꞌioliqꞌiieꞌ tal jeꞌ te u Abraham. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","As ech tal veꞌt u Abraham ileꞌ: «Oolsa sakꞌuꞌl, unkꞌaol, uvaꞌ bꞌaꞌnik chit aatineꞌ vatz u txꞌavaꞌeꞌ tukꞌ u txꞌiibꞌal aqꞌiieꞌ. Pet ech koj u Lázaro, tan oyebꞌ chit ivatz naj kat ibꞌan vatz u txꞌavaꞌeꞌ. As cheel il naj ileꞌ bꞌaꞌn veꞌt tatin tzitzaꞌ. As axh uveꞌ ni palebꞌen u kꞌaxkꞌoeꞌ cheel. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","As kꞌuxh la qal kubꞌen tiꞌ bꞌen qilat axh, as yeꞌ la uchi, tan at umaꞌl u mam jul sukuxoꞌl. As echat kuxh ex, tan yeꞌ la uch etul veꞌt tzitzaꞌ,» tiꞌk u Abraham. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","As ech tal veꞌt u txꞌioliqꞌii ileꞌ: «Bꞌan bꞌaꞌnil, kubꞌaal Abraham. Chaj bꞌen u Lázaro bꞌa xeꞌ ak unbꞌaaleꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","tan atil oꞌvaꞌt vitzꞌin. As aꞌ ni valeꞌ uvaꞌ la bꞌen ibꞌeya veꞌt u Lázaro te chajnaj, aqꞌal uvaꞌ yeꞌ la ul ipalebꞌe chajnaj u kꞌaxkꞌoeꞌ tzitzaꞌ,» tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","As ech tal veꞌt u Abraham ileꞌ: «Tzꞌibꞌamal kaneꞌ unqꞌa yoleꞌ taꞌn u Moisés tukꞌ kaꞌt unqꞌa qꞌajsan tetz viyol u Tiixheꞌ. As ni talpeꞌ te unqꞌa eetzꞌineꞌ. As chajnajeꞌ la ilon asoj la inima chajnaj moj yeꞌle,» tiꞌk u Abraham. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","As ech tal veꞌt u txꞌioliqꞌii ileꞌ: «Yeꞌle, kubꞌaal Abraham. Yeꞌ la inima chajnajeꞌ u yoleꞌ uvaꞌ tzꞌibꞌamal kan. Pet asoj la ul taama umaj kamnaj as la bꞌen tal xoꞌl chajnaj tiꞌ u kꞌaxkꞌoeꞌ uvaꞌ at tzitzaꞌ, as aꞌn la ikꞌaxa tibꞌ chajnajeꞌ tiꞌ vipaaveꞌ,» tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ech tal veꞌt u Abraham ileꞌ: «Asoj yeꞌ nisaꞌ chajnaj inimat viyol u Moisés tukꞌ unqꞌa qꞌajsan tetz viyol u Tiixheꞌ, as echeꞌ la koj chit inima chajnaj kꞌuxh la ul taama umaj kamnaj tiꞌ bꞌen talat isuuchil te chajnaj,» tiꞌk u Abraham tala,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","As ech tal veꞌt u Jesús ileꞌ te unqꞌa ichusulibꞌeꞌ: —Tuk chit ulojeꞌ unqꞌa kꞌaxkꞌoeꞌ tiꞌ ikaꞌkabꞌinsal taama unqꞌa uxhchileꞌ tiꞌ inimat in. ¡Pet oyebꞌ chit ivatz u uxhchileꞌ uvaꞌ la kaꞌkabꞌinsan taama unqꞌa niman vetzeꞌ! ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Tan asoj la ikaꞌkabꞌinsa u uxhchileꞌ taama umaj u niman vetzeꞌ uvaꞌ yeꞌ yakꞌinoj vitxumbꞌaleꞌ tiꞌ vunyoleꞌ, as aal bꞌaꞌneꞌ uvaꞌ la kꞌalpik veꞌt ok umaj kaꞌ tiqul u uxhchileꞌ. As la sutil bꞌen xeꞌ u mar. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","As etiltaj chit etibꞌ sbꞌaꞌn, tan asoj la ibꞌan umaj vetitzꞌin etatzikeꞌ umaj paav sete, as la ebꞌeya ste. As tul la ikꞌaxa vipaaveꞌ sevatz, as la esotzsa ipaav. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","As kꞌuxh la paavin umaj uxhchil vujpajoj sevatz tumaj qꞌii, as esotzsataj ipaav. Asoj vujpajul la ul tal u uxhchileꞌ sete uvaꞌ: «Kat paavinyu veꞌt in sevatz. As sotzsataj vunpaaveꞌ,» chaj u uxhchileꞌ la tal sete, as la esotzsa ipaav,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","As ech tal veꞌt unqꞌa apóstol ileꞌ te u Jesús: —Aqꞌ chit kꞌujlebꞌal kukꞌuꞌl,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","As ech tal veꞌt u Jesús ileꞌ te chajnaj: —As ech koj u kꞌujlebꞌal ekꞌuꞌleꞌ echeꞌ umaj iia uvaꞌ tetz mostaza, as la uch etalataꞌ te umaꞌl u tzeꞌeꞌ uvaꞌ: «Txakpen, tzeꞌ. As kuxh ava eebꞌ tu u mar,» chaj ex la etaleꞌ. As la chit ibꞌaneꞌ kam uvaꞌ la etaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","As qal bꞌen stiꞌ uvaꞌ at umaj ekꞌam uvaꞌ kat bꞌex xeen txoo, moj aqꞌon kat bꞌex ibꞌana. As tul kat ul veꞌt tu vitz, ¿as ma ech la etal ileꞌ ste: «Oken chꞌuꞌl. Xonebꞌen vatz u meexhaeꞌ. As txꞌaꞌon veꞌteꞌ,» ma chaj ex la etaleꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Yeꞌxh la etaleꞌ taꞌ echeꞌ uveꞌ ste. Pet ech la etal ileꞌ: «Bꞌan tuch vuntxꞌixeꞌ bꞌaxa. As lanal txꞌaꞌn in. La ukꞌaꞌ in. As aꞌn la txꞌaꞌn veꞌt axh. As la ukꞌaꞌ axh,» chaj exeꞌ la etaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","As ni valeꞌ uvaꞌ mitaꞌn kuxh taꞌntiixh la etaqꞌ te vekꞌameꞌ asoj aꞌ kuxh u aqꞌoneꞌ kat bꞌex ibꞌana kam uveꞌ kat etal ste. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","As echat la ebꞌaneꞌ unpajte, tan tul uvaꞌ la tzojpu veꞌt ex tiꞌ u aqꞌoneꞌ uveꞌ kat alax sete, as ech la etal veꞌt ileꞌ: «Oꞌ kuxh kꞌameꞌ. As jit qetzeꞌ uvaꞌ la oksal kuqꞌii tiꞌ u aqꞌoneꞌ uvaꞌ kat kubꞌana, tan aꞌ kuxh kat kubꞌana kam uveꞌ kat alax sqe,» chaj ex la etaleꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","As tul bꞌen veꞌt u Jesús tu bꞌey tiꞌ toon tu u Jerusalén, as pal veꞌt Aak tu vinaajeꞌl u Samaria tukꞌ u Galilea. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","As ok veꞌt Aak tu umaꞌl u tal tenam. As bꞌex eloj chꞌuꞌl laval unqꞌa aachꞌoꞌm uveꞌ atik chꞌaꞌk chin stiꞌ, tan nik isaꞌ chajnaj uvaꞌ la til chajnaj u Jesús. As yeꞌl chajnaj jetzꞌen ok kꞌatz Aak. Pet naach kuxh atikkat tzan chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","As taqꞌ veꞌt jeꞌ chajnaj tuul iviꞌ. Ech tal veꞌt chajnaj ileꞌ: —¡Jesús, Chusul, txum kuvatz!— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","As tul til veꞌt u Jesús chajnaj, as ech tal veꞌt Aak ileꞌ: —Bꞌenoj ex tu u Jerusalén. As bꞌen ekꞌuchtaj etibꞌ vatz unqꞌa oksan iyol tenam vatz Tiixh,— tiꞌk Aak tal te chajnaj. As bꞌen veꞌt chajnaj. As tul kuxh bꞌen chajnaj, as yak kuxh el u chꞌoꞌmeꞌ tiꞌ chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","As umaꞌl u najeꞌ uvaꞌ kat el u chꞌoꞌmeꞌ stiꞌ, as tul til veꞌt naj uvaꞌ yeꞌlik veꞌt u chꞌaꞌk chineꞌ stiꞌ, as qꞌaav veꞌt naj kꞌatz u Jesús. As taqꞌ veꞌt jeꞌ naj tuul iviꞌ tiꞌ toksal veꞌt iqꞌii u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","As qaaebꞌ veꞌt naj vatz u Jesús. As oon veꞌt ivatz naj vatz txꞌavaꞌ tiꞌ taqꞌat taꞌntiixh te Aak. As tul aa Samaria u najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","As ech tal veꞌt u Jesús ileꞌ te naj: —¿Axh kuxh kol qꞌa? ¿As kech bꞌeluvat unqꞌa uxhchileꞌ qꞌi? Tan lavalen exeꞌ taꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿As ma yeꞌl umaj uxhchil bꞌa uvaꞌ tiaal Israel kat qꞌaavik tzan tiꞌ toksal iqꞌii u Tiixheꞌ? ¿Pet ma axh kuxh bꞌa uvaꞌ jit axh tiaal Israel? ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","As txakpen. Kuxh veꞌteꞌ, tan kat txanyu veꞌt axh, tan tiꞌ uvaꞌ kat akꞌujbꞌaꞌ akꞌuꞌl sviꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","As ech tal veꞌt kaꞌl unqꞌa fariseo ileꞌ te u Jesús: —¿Jatueꞌ qꞌi la ok u tenameꞌ jaqꞌ u tijleꞌm u Tiixheꞌ?— tiꞌk chajnaj. As ech tal veꞌt u Jesús ileꞌ: —Echeꞌ la koj ilpi uvaꞌ jatu la ok u tenameꞌ jaqꞌ u tijleꞌm u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","As u tenameꞌ uvaꞌ ni til Aak isuuchil, as yeꞌ la uch talat umaj uxhchil uvaꞌ: «Ileꞌ at tzitzaꞌ,» as moj: «Ileꞌ at tziꞌleꞌ,» chaj la taleꞌ, tan ileꞌ at sexoꞌl cheel,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","As ech tal veꞌt u Jesús ileꞌ te unqꞌa ichusulibꞌeꞌ: —Tuk ilej umaꞌl u qꞌii uvaꞌ la esaꞌ veꞌteꞌ uvaꞌ la atil veꞌt VIKꞌAOL U NAJEꞌ tu umaj qꞌii sexoꞌl. As yeꞌl la etileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","As la alax sete uvaꞌ: «¡Il Aak at tziꞌleꞌ!» as moj: «¡Il Aak at tzitzaꞌ!» chaj chꞌelel ex. As bꞌeniꞌk etila; as enimaki. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","As ech tul VIKꞌAOL U NAJEꞌ echeꞌ nibꞌan u kayampaꞌleꞌ tan xoꞌvebꞌal chit ilitzꞌkabꞌaneꞌ vatz u almikaꞌeꞌ, tan naꞌl tibꞌuuqꞌebꞌal qꞌii as naꞌl tibꞌenebꞌal qꞌii. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pet techanal tuk unpalebꞌe unqꞌa kꞌaxkꞌoeꞌ, tan tuk ixvaloj in taꞌn unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","As echeꞌ uveꞌ kat ibꞌana tul uvaꞌ atik u Noé, as echat chit tuk ibꞌaneꞌ tul la ul VIKꞌAOL U NAJEꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nikat itxꞌaꞌn unqꞌa tenameꞌ, as nikat tukꞌaꞌ, as nikat teqꞌo tibꞌ tukꞌ ikꞌulel. As ech kuxh nikat ibꞌan unqꞌa tenameꞌ tul kat ilej u qꞌiieꞌ uvaꞌ kat ok u Noé tu u barco. As ul veꞌt u mam jabꞌaleꞌ. As sotz veꞌt unqꞌa tenameꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","As echat chit la ibꞌaneꞌ tul la ul in echeꞌ uveꞌ kat ibꞌan unqꞌa tenameꞌ uvaꞌ atikkat u Lot. Tan nikat itxꞌaꞌneꞌ, as nikat tukꞌaꞌ, nikat iloqꞌoneꞌ, as nikat ikꞌayineꞌ, nikat tava unqꞌa ichikoeꞌ, as nik ilak unqꞌa ikabꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","As tul bꞌex ilej u qꞌiieꞌ uvaꞌ aꞌs tel chꞌuꞌl u Lot tu u Sodoma, as kuꞌ veꞌt chꞌuꞌl xamal tukꞌ azufre tu almikaꞌ tiꞌ isotzsal veꞌt unqꞌa tenameꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","As echat chit la ibꞌaneꞌ tu u qꞌiieꞌ uvaꞌ la til veꞌt unqꞌa tenameꞌ u tulebꞌal VIKꞌAOL U NAJEꞌ unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","As tul la ilej veꞌt u qꞌiieꞌ, as abꞌiste ex uvaꞌ at jeꞌ ex viꞌ vekabꞌaleꞌ, as yeꞌl ex la kuꞌ veꞌt chꞌuꞌl ex tiꞌ ul eteqꞌot unqꞌa etetzeꞌ uveꞌ at tu vekabꞌaleꞌ. As ex uvaꞌ at bꞌen ex tu vitz, as yeꞌl ex la qꞌaavik veꞌt tzan ex tu u tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","As etulsataj sekꞌuꞌl uvaꞌ kat ibꞌan u tixqel u Lot, ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","tan abꞌil uveꞌ aꞌ kuxh vitiichajileꞌ ni titzꞌa vatz u txꞌavaꞌeꞌ, as yeꞌl itiichajil kꞌatz u Tiixheꞌ la ibꞌaneꞌ. Pet abꞌil uvaꞌ yeꞌ la toksa taama tiꞌ u vatz txꞌavaꞌeꞌ tan tiꞌ uvaꞌ nimamal in staꞌn, as at itiichajil kꞌatz u Tiixheꞌ la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","As la val sete, tul la ilej u qꞌiieꞌ uvaꞌ la ul in unpajte, as at kaꞌvaꞌl uxhchil vatik viꞌ vichꞌacheꞌ aqꞌbꞌal. As umaꞌl la bꞌeni; as umaꞌt la kaaik kan. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","As la ibꞌaneꞌ uvaꞌ at kaꞌvaꞌl u ixoj uvaꞌ nicheꞌeneꞌ. As umaꞌl ixoj la bꞌeni; as umaꞌt ixoj la kaaik kan. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","At kaꞌvaꞌl unqꞌa naj uvaꞌ la bꞌen tu vitz. As umaꞌl naj la bꞌeni; as umaꞌt naj la kaaik kan,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","As ech tal veꞌt unqꞌa ichusulibꞌ Aak ileꞌ: —¿Katileꞌ qꞌi, Pap, la ibꞌankat uveꞌ naaleꞌ?— tiꞌk chajnaj. Ech tal veꞌt Aak ileꞌ: —As la enima u yoleꞌ uvaꞌ ni val sete tiꞌ u vulebꞌaleꞌ echeꞌ enimat u yoleꞌ uvaꞌ ech ni tal ileꞌ: «Katil uveꞌ atkat umaj txoo uvaꞌ kamnajle, as tzitziꞌ nimolkat tibꞌ unqꞌa quꞌseꞌ,» tiꞌk u yoleꞌ uvaꞌ nenima,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","As tal veꞌt u Jesús umaꞌt u kꞌuchuvatz te unqꞌa ichusulibꞌeꞌ tiꞌ uvaꞌ la chit inach chajnaj Tiixh, as yeꞌ la pal ikꞌuꞌl chajnaj tiꞌ inachax Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ech tal veꞌt Aak ileꞌ: —Atik umaꞌl u bꞌanol isuuchil unqꞌa uxhchileꞌ tu umaꞌl u tenam uvaꞌ yeꞌ nikat inima Tiixh. As echeꞌ nikat koj ixoꞌva naj umaj uxhchil. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","As atik umaꞌl u txakay ixoj tu u tenameꞌ. As ok veꞌt ixoj vatz naj. As aꞌ nikat tal u ixojeꞌ uvaꞌ la bꞌanax isuuchil ixoj tukꞌ umaꞌl u uxhchil uvaꞌ nikat iyaa tibꞌ tukꞌ ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","As jatpajul kuxh nikat toon u txakay ixojeꞌ vatz u bꞌanol isuuchil unqꞌa tenameꞌ. As echeꞌ nikat koj tabꞌi naj viyol u ixojeꞌ. Pet xamtik veꞌt stuul, as ech tal veꞌt jeꞌ naj ileꞌ ste: «Kꞌuxh yeꞌl u Tiixheꞌ nunnima, as kꞌuxh yeꞌxhebꞌil nunxoꞌva, ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","as tuk unbꞌan isuuchil u ixojeꞌ, tan yaꞌltu kuxh ixoj sviꞌ. As tuk paloj unkꞌuꞌl taꞌn ixoj,» tiꞌk u bꞌanol isuuchil unqꞌa uxhchileꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","As ech tal veꞌt Aak ileꞌ te unqꞌa uxhchileꞌ: —Etitzꞌataj uvaꞌ kat ibꞌan u bꞌanol isuuchil unqꞌa uxhchileꞌ, kꞌuxh vaꞌlexh vitxumbꞌal najeꞌ nik ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿As aꞌ kol chit yeꞌ la ibꞌan u Tiixheꞌ qꞌa sete tukꞌ unqꞌa uxhchileꞌ uvaꞌ txaael taꞌn Aak, jankꞌal ex uvaꞌ yeꞌ neyaꞌ tiꞌ enachat Tiixh sqꞌiil aqꞌbꞌal? ¿As ma la bꞌalax u Tiixheꞌ bꞌa tiꞌ ibꞌanat esuuchil? ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yeꞌle taꞌ. Pet tuk val sete, tan oora kuxheꞌ la ibꞌan Aak esuuchil. Pet tul uvaꞌ la ul VIKꞌAOL U NAJEꞌ vatz u txꞌavaꞌeꞌ, ¿as ma nimatel tenam kꞌujleꞌl ikꞌuꞌl sviꞌ tul uvaꞌ la uli?— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","As tal veꞌt u Jesús umaꞌt u kꞌuchuvatz te kaꞌl unqꞌa uxhchil uvaꞌ jik chit veꞌt vitxumbꞌal vatz u Tiixheꞌ uvaꞌ nik tal jeꞌ ste. As yeꞌl kuxh itxaꞌk unjoltu unqꞌa uxhchileꞌ svatz. As ech tal veꞌt Aak ileꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Kat bꞌex kaꞌvaꞌl unqꞌa naj tu u tostiixheꞌ tiꞌ inachat Tiixh, umaꞌl u fariseo, as umaꞌt u molol tetz puaj tetz u Roma. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","As txakebꞌ veꞌt u fariseo tiꞌ inachat Tiixh tiꞌ toksat jeꞌ iqꞌii. As ech tal veꞌt naj ileꞌ: «Kubꞌaal Tiixh, la vaqꞌ taꞌntiixh see, tan jitꞌeꞌch ineꞌ echeꞌ unjoltu unqꞌa uxhchileꞌ uveꞌ ni bꞌanon u vaꞌlexheꞌ, echeꞌ unqꞌa najeꞌ uvaꞌ ni telqꞌeꞌ tukꞌ unqꞌa u najeꞌ uveꞌ nichuk tixoj. As mitaꞌn ech koj ineꞌ echeꞌ u najeꞌ, u viꞌleꞌ, u molol tetz u puajeꞌ tetz u Roma. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Tan kaꞌpuul nunkuy unvaꞌy tu jun xhemaana. As ni voya umaꞌl u puaj see xoꞌl laval uveꞌ nuntxꞌakeꞌ,» tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pet ech koj u molol tetz u puajeꞌ tetz u Roma, tan naach kuxh atikkat tzan naj. As yeꞌ nikat itxꞌak naj taqꞌat jeꞌ ivatz tu almikaꞌ. As xeꞌt ipum veꞌt naj tziꞌ taama. As ech tal veꞌt naj ileꞌ: «Kubꞌaal Tiixh, txum unvatz tiꞌ vunpaaveꞌ uvaꞌ kat unbꞌan savatz,» tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","As ileꞌ ni val sete uvaꞌ aꞌ u molol tetz u puajeꞌ tetz u Roma uvaꞌ jik veꞌt itxumbꞌal vatz u Tiixheꞌ tul kat qꞌaav veꞌt tikabꞌal. Pet ech koj u fariseo, tan yeꞌ bꞌaꞌn vitxumbꞌal najeꞌ vatz u Tiixheꞌ, tan abꞌil uvaꞌ la ijeꞌsa tibꞌ as la el iqꞌii vatz u Tiixheꞌ. Pet ech koj u uxhchileꞌ uveꞌ yeꞌ la toksa iqꞌii, tan aꞌeꞌ la oksal iqꞌii taꞌn u Tiixheꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","As teqꞌo veꞌt ok unqꞌa uxhchileꞌ unqꞌa italaj intxaꞌeꞌ vatz u Jesús tiꞌ uvaꞌ la taqꞌ jeꞌ Aak iqꞌabꞌ tiꞌ chiintxaꞌ. As tul til unqꞌa ichusulibꞌ Aakeꞌ, as iyaa veꞌt chajnaj unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","As imolo veꞌt tzan Aak unqꞌa ichusulibꞌeꞌ. As ech tal veꞌt Aak ileꞌ ste: —Echajputaj ok tzan unqꞌa talaj intxaꞌeꞌ sunkꞌatz. As yeꞌ kuxh emaj chiintxaꞌ, tan abꞌil uvaꞌ ech itxumbꞌaleꞌ echeꞌ vitxumbꞌal unqꞌa talaj intxaꞌeꞌ, as aꞌeꞌ uveꞌ at tokebꞌal xoꞌl u tenameꞌ uveꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","As jik chit tuk val sete, tan abꞌil uvaꞌ jitꞌeꞌch vitxumbꞌaleꞌ echeꞌ itxumbꞌal umaj talaj intxaꞌ la ibꞌaneꞌ tiꞌ uvaꞌ la til u Tiixheꞌ isuuchil, as yeꞌl tokebꞌal xoꞌl vitenam u Tiixheꞌ uvaꞌ ni til Aak isuuchil,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","As ech tal veꞌt umaꞌl u naj ileꞌ uveꞌ nim talcheꞌ: —¿Bꞌaꞌnla Chusul, kam la unbꞌaneꞌ tiꞌ uvaꞌ at untiichajil uvaꞌ yeꞌl iyaꞌtebꞌal?— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ech tal veꞌt u Jesús ileꞌ: —¿Kam qꞌi uvaꞌ: «Bꞌaꞌnla Chusul,» chꞌaxh sve? Tan yeꞌl umaj bꞌaꞌnla chusul ati. Pet taꞌneꞌ u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","As ateꞌ sakꞌuꞌl kam uvaꞌ la abꞌaneꞌ, tan ootzimal u tzaqꞌiteꞌ uvaꞌ tzꞌibꞌamal kan aꞌn uvaꞌ ech ni tal ileꞌ: Achukak eexoj. Ayatzꞌak umaj uxhchil. Elqꞌiꞌk axh. Acheesak ipaav amool. Nima abꞌaal; nima atxutx, taqꞌ u tzaqꞌiteꞌ,— tiꞌk u Jesús tal te u najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","As ech tal veꞌt u naj ileꞌ: —Nimamal chiteꞌ svaꞌn skajayil tul chꞌoo telik in,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","As tul tabꞌi veꞌt u Jesús viyol u najeꞌ, as ech tal veꞌt Aak ileꞌ: —As atil chit umaꞌte uvaꞌ yeꞌ abꞌaneꞌte. Pet kꞌayi unqꞌa eetzeꞌ skajayil. As la ajatx veꞌt vijaꞌmileꞌ xoꞌl unqꞌa meebꞌaꞌeꞌ. As nimal u bꞌaꞌnileꞌ lakꞌul tu almikaꞌ. As siꞌu. Xekebꞌen sviꞌ,— tiꞌk u Jesús tal te naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","As tul tabꞌi naj u yoleꞌ uvaꞌ tal Aak, as txumun veꞌt naj, tan yeꞌ saach unqꞌa txꞌiibꞌal iqꞌii najeꞌ atike. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","As til veꞌt u Jesús uvaꞌ nik itxumun veꞌt naj tiꞌ u yoleꞌ uvaꞌ tal Aak. As ech tal veꞌt Aak ileꞌ: —Kaꞌl chit tziieꞌ uvaꞌ at tokebꞌal unqꞌa txꞌiol iqꞌiieꞌ xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","tan oora kuxheꞌ la pal veꞌt umaj camello tixotoꞌlil umaj tzꞌisbꞌal bꞌaj tiꞌ uvaꞌ la ok umaj txꞌioliqꞌii xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","As ech tal veꞌt unqꞌa uxhchil ileꞌ uveꞌ abꞌin viyol Aakeꞌ: —Asoj ech la ibꞌaneꞌ echeꞌ u veeꞌ, ¿as abꞌil veꞌteꞌ qꞌi la ok xoꞌl vitenam u Tiixheꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ech tal veꞌt u Jesús ileꞌ: —Kam uveꞌ yeꞌ nitxꞌol unqꞌa uxhchileꞌ ibꞌanataꞌ, as la olebꞌeꞌ u Tiixheꞌ tiꞌ ibꞌanataꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","As ech tal veꞌt u Luꞌ ileꞌ: —Tan kat qaqꞌlu veꞌt kan unqꞌa qetzeꞌ skajayil. As il oꞌ xekel veꞌt oꞌ seeꞌ,— tiꞌk u Luꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","As ech tal veꞌt u Jesús ileꞌ: —Ileꞌ jik chit tuk val sete, tan jankꞌal unqꞌa uxhchileꞌ uveꞌ kat taqꞌlu kan ikabꞌal, moj itxutx, moj ibꞌaal, moj unqꞌa titzꞌin tatzikeꞌ, moj tixqel, as moj unqꞌa meꞌal ikꞌaoleꞌ, tan tiꞌ uvaꞌ kat ok xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","as aꞌ unqꞌa uxhchileꞌ uvaꞌ nimal ichꞌexel la aqꞌax ste tzitzaꞌ vatz u txꞌavaꞌeꞌ. As tu unqꞌa qꞌiieꞌ uvaꞌ aꞌn tuleꞌ, as at veꞌt itiichajil uvaꞌ yeꞌl iyaꞌtebꞌal,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","As imolo veꞌt el u Jesús kabꞌlaval unqꞌa ichusulibꞌeꞌ. Ech tal veꞌt Aak ileꞌ: —Cheel bꞌen veꞌt jeꞌ oꞌ tu u Jerusalén. As la bꞌen ibꞌan veꞌt unqꞌa yoleꞌ skajayil uveꞌ tzꞌibꞌamal kan sviꞌ taꞌn unqꞌa qꞌajsan tetz viyol u Tiixheꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","tan tuk aqꞌaxoj ok in tiqꞌabꞌ unqꞌa jit tiaal Israel. As tuk eesaloj unqꞌii; as tuk yoqꞌpoj veꞌt in; as tuk tzubꞌaloj in; ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","as tuk qꞌospoj in; as la yatzꞌpu veꞌt in. As titoxvu qꞌii la ul vaama,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","As jit pal veꞌt unqꞌa ichusulibꞌeꞌ tu viyol Aakeꞌ, tan yeꞌ kat taqꞌ u Tiixheꞌ te chajnaj uvaꞌ la tootzi chajnaj visuuchil u yoleꞌ. Estiꞌeꞌ yeꞌ kat tootzi veꞌt chajnaj kam tokkat viyol u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","As tul unbꞌiitik kuxh toon veꞌt u Jesús tu u Jericó, as xonlik umaꞌl u tzot tziꞌ bꞌey tiꞌ ijoyat ipuaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","As tul tabꞌi veꞌt u tzoteꞌ uvaꞌ aꞌ chit mamaꞌla xaoleꞌ nikat ipal veꞌt tu bꞌey, as ichꞌoti veꞌt naj uvaꞌ kam nik tucheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","As alax veꞌt te u tzoteꞌ uvaꞌ aꞌ u Jesús, u aa Nazaret, uveꞌ nik ipal kꞌatz naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","As sikꞌin veꞌt naj. As ech tal veꞌt naj ileꞌ: —¡Jesús, tiaal David, txum unvatz!— tiꞌk u tzoteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","As yaan veꞌt unqꞌa uxhchileꞌ uveꞌ bꞌaxik vatz u Jesús te u tzoteꞌ, tiꞌ uvaꞌ yeꞌ la sikꞌin naj. As aal chit taqꞌ jeꞌ naj tuul iviꞌ. As ech tal veꞌt naj ileꞌ: —¡Jesús, tiaal David, txum unvatz!— tiꞌk naj tal te u Jesús unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","As txakebꞌ veꞌt u Jesús. As tal veꞌt Aak teqꞌol tzan u tzoteꞌ svatz. As tul ul veꞌt naj vatz Aak, as ech tal veꞌt Aak ileꞌ te u tzoteꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Kam nasaꞌ uvaꞌ la unbꞌaneꞌ?— tiꞌk u Jesús. As ech tal veꞌt u tzot ileꞌ: —Pap, aꞌ ni valeꞌ uvaꞌ la ilon vunvatzeꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","As ech tal veꞌt Aak ileꞌ: —Kat bꞌaꞌnxiyeꞌ vavatzeꞌ, tan kat akꞌujbꞌaꞌ akꞌuꞌl sviꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","As yak kuxh ilon veꞌt u tzoteꞌ. As xekebꞌ veꞌt naj tiꞌ Aak. As vaꞌlik chit toksat veꞌt naj iqꞌii u Tiixheꞌ. As jankꞌal unqꞌa uxhchileꞌ uveꞌ kat ilon, as toksa veꞌt chajaak iqꞌii u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","As tul ok veꞌt u Jesús tu u Jericó, as nikat ixaan Aak tu u tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","As atik umaꞌl u txꞌioliqꞌii tzitziꞌ uvaꞌ Zaqueo ibꞌii. As naj iqꞌesal xoꞌl unqꞌa molol tetz puaj tetz u Roma. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","As aꞌ chit nik tal naj uvaꞌ la til naj uvaꞌ abꞌiste u Jesús. As yeꞌ nik tucheꞌ, tan tiꞌ uvaꞌ chꞌooik kuxh itxakebꞌ naj. As aꞌ chit mamaꞌla tenameꞌ xekik tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","As tul til naj uvaꞌ yeꞌ nik tucheꞌ, as oojeꞌl chit ibꞌen naj. As jeꞌ veꞌt naj viꞌ umaꞌl u tzeꞌ uvaꞌ higuera, tan atik skꞌuꞌl naj uvaꞌ la pal u Jesús tzitziꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","As tul oon veꞌt u Jesús najlich u tzeꞌeꞌ, as kaꞌyik veꞌt jeꞌ Aak viꞌ u tzeꞌeꞌ. As ech tal veꞌt jeꞌ Aak ileꞌ te naj: —¡Zaqueo, oora kuꞌen chꞌuꞌl tzitziꞌ! Tan cheel tuk kaaoj kan in tu vakabꞌaleꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","As oora chit kuꞌ veꞌt chꞌuꞌl u Zaqueo viꞌ u tzeꞌeꞌ. Vaꞌlik chit itxuqꞌtxun veꞌt naj tiꞌ ikꞌulat u Jesús tikabꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","As tul til veꞌt unqꞌa tenameꞌ tok u Jesús tikabꞌal u Zaqueo, as kam kuxh nikat tal veꞌt unqꞌa tenameꞌ tiꞌ Aak, tan tiꞌ uvaꞌ kat ok Aak tikabꞌal umaꞌl u uxhchileꞌ uveꞌ nimal ipaav atike vatz unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","As txakebꞌ veꞌt u Zaqueo xoꞌl unqꞌa uxhchileꞌ uvaꞌ xonlike. As ech tal veꞌt naj ileꞌ te u Jesús: —Pap, la vaqꞌ unpokꞌoꞌchil vunmeebꞌaꞌleꞌ te unqꞌa meebꞌaꞌeꞌ. Asoj at umaj uxhchil kat velqꞌa tetz, as kajvaꞌl veꞌt ichꞌexel la vaqꞌ ste,— tiꞌk u Zaqueo. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ech tal veꞌt u Jesús ileꞌ: —As cheel kat sotzyu veꞌt vipaav unqꞌa uxhchileꞌ tu u kabꞌalaꞌ, tan tiaal u Abraham u najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tan kat ul VIKꞌAOL U NAJEꞌtiꞌ ilochat unqꞌa uxhchileꞌ uveꞌ at kan tu u paaveꞌ as tiꞌ iqꞌalputaꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","As tul bꞌiitik kuxh toon veꞌt u Jesús tu u Jerusalén, as nikat tabꞌi unqꞌa tenameꞌ viyol Aakeꞌ. As xeꞌt veꞌt Aak tiꞌ talat umaꞌt u kꞌuchuvatz, tan atik skꞌuꞌl Aak uvaꞌ nikat titzꞌa unqꞌa tenameꞌ uvaꞌ yeꞌxh jatvaꞌt qꞌii la kꞌuchax veꞌteꞌ uvaꞌ at u tenameꞌ jaqꞌ u tijleꞌm u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","As ech tal veꞌt Aak ileꞌ xoꞌl unqꞌa tenameꞌ: —Atik umaꞌl u naj uvaꞌ nim talcheꞌ. As kat ibꞌan naj tucheꞌ tiꞌ ibꞌen tu umaꞌt u tenam uvaꞌ naach chittuꞌ, tan la bꞌen ikꞌul naj u tijleꞌmeꞌ tiꞌ tok naj bꞌanol ivatz u ijlenaaleꞌ. As aꞌn la ul veꞌt naj tu vitenameꞌ unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","As imolo veꞌt naj laval vikꞌameꞌ. As taqꞌ veꞌt kan naj puaj uvaꞌ oꞌkꞌalal (100) qꞌii aqꞌon ijaꞌmil te junun unqꞌa ikꞌameꞌ. As ech tal kan naj ileꞌ: «Aqꞌonvojtaj ex tukꞌ vunpuajeꞌ aqꞌal uvaꞌ la naꞌi, as techoj kuxh ul in,» tiꞌk naj tal te unqꞌa ikꞌameꞌ. As bꞌen veꞌt naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pet yeꞌ nikat isaꞌ unqꞌa tenameꞌ u najeꞌ uvaꞌ la ok naj bꞌanol ivatz u ijlenaaleꞌ. As ichaj veꞌt unqꞌa tenameꞌ kaꞌl unqꞌa naj uveꞌ tzaanaj kat u najeꞌ uveꞌ ni tal tok bꞌooqꞌolil tiꞌ ibꞌen talat yol tiꞌ uvaꞌ yeꞌl u najeꞌ la ok bꞌanol ivatz u ijlenaaleꞌ. As ech tal bꞌen unqꞌa tenam ileꞌ: «Yeꞌ kusaꞌ u najeꞌ uvaꞌ la ok naj bꞌanol ivatz u ijlenaaleꞌ sqiꞌ,» tiꞌk unqꞌa tenameꞌ tal bꞌen. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","As jit nimal viyol unqꞌa tenameꞌ, tan kat chit oksal veꞌt naj bꞌanol ivatz u ijlenaaleꞌ tiꞌ unqꞌa tenameꞌ. As qꞌaavik veꞌt tzan naj tu vitenameꞌ. As imolo veꞌt naj laval vikꞌameꞌ uveꞌ kꞌulun kan u puajeꞌ. As ichꞌoti veꞌt naj te unqꞌa ikꞌameꞌ uvaꞌ jankꞌax itxꞌak veꞌt chajnaj tukꞌ vipuaj najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","As tul ok veꞌt u bꞌaxa kꞌameꞌ vatz u najeꞌ, as ech tal veꞌt u kꞌam ileꞌ: «Pap, il u puaj ilaꞌ. As laval kat untxꞌaklu stukꞌ,» tiꞌk u kꞌameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ech tal veꞌt u bꞌanol ivatz u ijlenaal ileꞌ te u kꞌameꞌ: «Bꞌaꞌn kuxheꞌ, tan axh bꞌaꞌnla aqꞌonvil. As tuk unkꞌujbꞌaꞌ veꞌt kan axh bꞌooqꞌolil tiꞌ laval unqꞌa tenameꞌ, tan jik chit atxumbꞌal kat abꞌana tiꞌ unbꞌiil uvaꞌ kat vaqꞌ see,» tiꞌk naj tal te u bꞌaxa kꞌameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","As ok veꞌt ikaꞌv u kꞌameꞌ vatz u bꞌanol ivatz u ijlenaaleꞌ. As ech tal veꞌt u kꞌam ileꞌ: «Pap, il vapuaj ilaꞌ. As oꞌvaꞌt kat untxꞌaklu stukꞌ,» tiꞌk u kꞌameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ech tal veꞌt u bꞌanol ivatz u ijlenaal ileꞌ te u kꞌameꞌ: «Bꞌaꞌn kuxheꞌ, tan tuk unkꞌujbꞌaꞌ veꞌt kan axh bꞌooqꞌolil tiꞌ oꞌvaꞌl unqꞌa tenameꞌ,» tiꞌk naj tal te u kꞌameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","As ok veꞌt itoxvu u kꞌameꞌ vatz u bꞌanol ivatz u ijlenaaleꞌ. As ech tal veꞌt naj ileꞌ: «Pap, il vapuaj ilaꞌ skajayil. Kat kuxh unkol tu umaꞌl u suꞌt, ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","tan kat xoꞌv in see, tan ootzimal axh svaꞌn uvaꞌ itzꞌaꞌjtu kuxh asaꞌ. As vootzajle uvaꞌ namol veꞌt ivatz unqꞌa chikoeꞌ, kꞌuxh jit axh kat aqꞌonvan. As la bꞌen eeqꞌo ivatz uvaꞌ jit axh kat avan,» tiꞌk u kꞌameꞌ tal te u bꞌanol ivatz u ijlenaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ech tal veꞌt u bꞌanol ivatz u ijlenaal ileꞌ te u kꞌameꞌ: «¡Jit axh bꞌaꞌnla kꞌameꞌ vil! As an chit vayoleꞌ tuk untxakonsa tiꞌ unbꞌanat asuuchil, tan ootzimal in aꞌn uvaꞌ itzꞌaꞌjtu kuxh nunsaꞌ. As ootzimal in aꞌn uvaꞌ nu kuxh unmol ivatz unqꞌa chikoeꞌ kꞌuxh jit in kat avan as jit in kat aqꞌonvan. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿As kam tetzeꞌ qꞌi uvaꞌ kat koj bꞌex ooksa kan vunpuajeꞌ tu uveꞌ nikolpukat unqꞌa puajeꞌ? As aal kuxh koj unbꞌooj tal vunpuajeꞌ kat aaqꞌ sve tul kat ul in tukꞌ u vijleꞌmeꞌ,» tiꞌk u bꞌanol ivatz u ijlenaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","As ech tal veꞌt u bꞌanol ivatz u ijlenaal ileꞌ te unjoltu unqꞌa ikꞌameꞌ uveꞌ atik tzitziꞌ: «Emaataj u puajeꞌ te u najeꞌ. As etaqꞌtaj te u najeꞌ uveꞌ kat txꞌakon lavat u puajeꞌ,» tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","As ech tal veꞌt unqꞌa kꞌam ileꞌ ste: «Pap, tan at veꞌt laval puaj xeꞌ naj,» tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ech tal veꞌt u bꞌanol ivatz u ijlenaal ileꞌ: «Ileꞌ ni val sete, tan abꞌil uvaꞌ at tetz, as aal la vaqꞌ veꞌt imaas u tetzeꞌ ste. Pet abꞌil uvaꞌ yeꞌl tetz ati, as aal la maap u tetzeꞌ uvaꞌ ati. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","As jankꞌal unqꞌa uxhchileꞌ uvaꞌ yeꞌ nik saꞌon uvaꞌ la ok in bꞌanol ivatz u ijlenaaleꞌ stiꞌ, as eteqꞌotaj tzan sunvatz. As eyatzꞌtaj,» tiꞌk veꞌt u bꞌanol ivatz u ijlenaaleꞌ,— tiꞌk u Jesús tal te unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","As tul yaꞌ veꞌt u Jesús tiꞌ talat u kꞌuchuvatzeꞌ, as bꞌen veꞌt Aak tu bꞌey tukꞌ unqꞌa tenameꞌ uvaꞌ xekik tiꞌ Aak tiꞌ toon tu u Jerusalén. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","As oon veꞌt Aak tukꞌ unqꞌa tenameꞌ kꞌatz u vitz uvaꞌ Olivos uvaꞌ echen najlich u tal tenam uvaꞌ Betfagé tukꞌ u tal tenam uvaꞌ Betania. As ichaj veꞌt bꞌen Aak kaꞌvaꞌl unqꞌa ichusulibꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","As ech tal veꞌt Aak ileꞌ te chajnaj: —Bꞌenoj ex tu u tal tenameꞌ uvaꞌ at tzan. Tul la oon ex, as la elej umaꞌl u tal bꞌur uvaꞌ yeꞌ atixoj jeꞌ umaj uxhchil stiꞌ. As kꞌalel txoo. As la esaapu txoo; as la eteqꞌo tzan txoo. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Asoj la tal umaj uxhchil sete uvaꞌ: «¿Kam nu kuxh esaapu u bꞌureꞌ?» chaj u uxhchileꞌ, as ech la etal ileꞌ: «Aꞌ u kuBꞌooqꞌoleꞌ tuk txakonsan txoo,» chaj ex la etaleꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","As bꞌen veꞌt unqꞌa ichusulibꞌ Aakeꞌ uvaꞌ ichaj Aak. As bꞌex ilej chajnaj u bꞌureꞌ uvaꞌ tal Aak te chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","As tul kuxh isaapu chajnaj u tal bꞌureꞌ, as bꞌex oonoj veꞌt kaꞌl unqꞌa uxhchil uvaꞌ etzin tetz txoo. As ech tal veꞌt ileꞌ te chajnaj: —¿Kam itxaꞌk u tal bꞌureꞌ nesaapu?— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ech tal veꞌt unqꞌa ichusulibꞌ Aak ileꞌ: —Aꞌ u kuBꞌooqꞌoleꞌ tuk txakonsan txoo,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","As teqꞌo veꞌt tzan chajnaj u tal bꞌureꞌ vatz u Jesús. As taqꞌ veꞌt jeꞌ chajnaj unqꞌa ixbꞌuꞌjeꞌ tiꞌ txoo. As jeꞌ veꞌt Aak tiꞌ txoo taꞌn chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","As tul nik ipal veꞌt Aak tukꞌ u bꞌureꞌ, as iliipu veꞌt kuꞌ unqꞌa uxhchileꞌ unqꞌa ixbꞌuꞌjeꞌ tu bꞌey vatz Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","As tul bꞌiitik kuxh toon veꞌt Aak tukꞌ u najeꞌ vatz u vitzeꞌ uveꞌ Olivos, as mamaꞌla tenam xekik tiꞌ Aak. As sikꞌin veꞌt unqꞌa tenameꞌ taꞌn chiibꞌichil. As nikat taqꞌ veꞌt jeꞌ tuul iviꞌ tiꞌ toksal iqꞌii u Tiixheꞌ, tan tiꞌ uvaꞌ maꞌtik tilat unqꞌa tenameꞌ u bꞌaꞌnileꞌ uvaꞌ kat ibꞌan Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","As ech tal veꞌt unqꞌa tenam ileꞌ: —¡Qoksataj iqꞌii u Qijlenaaleꞌ uveꞌ tuleꞌ tukꞌ vibꞌii u Kubꞌaal Tiixheꞌ! ¡As bꞌaꞌn veꞌt qatin tukꞌ u Tiixheꞌ tu almikaꞌ, as qoksataj iqꞌii Aak tan eyen Aak tu almikaꞌ!— tiꞌk unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","As ech tal veꞌt kaꞌl unqꞌa fariseo ileꞌ uvaꞌ xekik xoꞌl unqꞌa tenameꞌ: —Chusul, al te unqꞌa achusulibꞌeꞌ uvaꞌ yeꞌ la sikꞌin chajnaj,— tiꞌk unqꞌa fariseo tal te u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ech tal veꞌt Aak ileꞌ: —Ileꞌ ni val sete, tan asoj la yaꞌ unqꞌa uxhchileꞌ tiꞌ isikꞌineꞌ, as aꞌ veꞌt unqꞌa kꞌubꞌeꞌ la sikꞌin taꞌn chiibꞌichil,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","As tul oon veꞌt u Jesús najlich u Jerusalén, as til veꞌt bꞌen Aak u tenameꞌ tu u Jerusalén. As xeꞌt veꞌt Aak oqꞌoj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","As ech tal veꞌt Aak ileꞌ: —As kat koj chit pal ex tu visuuchil unqꞌa uveꞌ la iloch ex tiꞌ uvaꞌ bꞌaꞌn etatineꞌ sevatzaj. Pet ech koj uveꞌ cheel, tan mujel veꞌt sevatz tiꞌ uvaꞌ yeꞌ la pal ex stuul. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","As tuk val sete, tan la ilej unqꞌa qꞌiieꞌ uvaꞌ tuk chit xoꞌlaloj ex taꞌn unqꞌa tenameꞌ uvaꞌ nichꞌoꞌn taama setiꞌ. As yeꞌxh katil la elkat veꞌt ex, tan xoꞌlamal veꞌt ex la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","As tuk yansaloj vetenameꞌ taꞌn unqꞌa tenameꞌ uvaꞌ nichꞌoꞌn taama setiꞌ, tan tuk eꞌpulojeꞌ vekabꞌaleꞌ. As mitaꞌn kuxh umaj kꞌubꞌ la kaaik kan tiibꞌa umaꞌt kꞌubꞌ. Pet kajayil chit tuk eꞌpuloj, tan tiꞌ uvaꞌ yeꞌ kat pal ex stuul uvaꞌ kat ul lochpoj ex cheel,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","As tul ok veꞌt u Jesús vatz viqꞌanal u tostiixheꞌ, as itilu veꞌt el Aak unqꞌa uxhchileꞌ uveꞌ nikat ikꞌayineꞌ as tukꞌ unqꞌa uxhchileꞌ uveꞌ nikat iloqꞌoneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","As ech tal veꞌt Aak ileꞌ: —Ech ni tal u umaꞌl u yol ileꞌ uvaꞌ tzꞌibꞌamal kan: Nachbꞌal vetzeꞌ vunkabꞌaleꞌ la ibꞌaneꞌ. Pet ech koj ex, tan kat ebꞌensal veꞌteꞌ statinbꞌal elqꞌom,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","As nik ichusun veꞌt u Jesús jun qꞌii tu u tostiixheꞌ. Pet unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh, tukꞌ unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as tukꞌ kaꞌt unqꞌa bꞌaal tenameꞌ, as nikat ichuk veꞌt chajnaj txumbꞌal tiꞌ iyatzꞌpu veꞌt Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","As jit uch vatz chajnaj, tan til veꞌt chajnaj uvaꞌ ayaꞌl chit ikꞌuꞌl unqꞌa tenameꞌ tiꞌ tabꞌit u yoleꞌ uveꞌ nikat tal Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","As ibꞌan tu umaꞌl u qꞌii tul atik u Jesús vatz iqꞌanal u tostiixheꞌ. As tul nikat ichusun Aak tiꞌ unqꞌa bꞌaꞌnla yoleꞌ tetz u sotzbꞌal paaveꞌ, as oon veꞌt kaꞌl unqꞌa bꞌaal tenam, tukꞌ kaꞌt unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh, as tukꞌ kaꞌt unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","As ech tal veꞌt chajnaj ileꞌ te Aak: —Al sqe: ¿Abꞌil aqꞌol tetz u eejleꞌmeꞌ tiꞌ uvaꞌ kat ul atilu el unqꞌa uxhchileꞌ vatz iqꞌanal u tostiixheꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ech tal veꞌt u Jesús ileꞌ: —Tuk unchꞌoti umaꞌl u yol sete. As etaltaj sve: ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Abꞌil chajol tzan tetz u Xhuneꞌ uvaꞌ nik aqꞌon kuꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ? ¿Ma aꞌ u Tiixheꞌ chajol tzan tetz? ¿Pet moj aꞌ unqꞌa vatz txꞌavaꞌilla aamaeꞌ chajol tzan tetz?— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","As iyol veꞌt chajnaj svatzaj uvaꞌ kam la tal chajnaj. Ech tal veꞌt chajnaj ileꞌ: —Asoj tuk qaleꞌ uvaꞌ Tiixh kat chajon tzan naj, as: «¿Kam qꞌi yeꞌ kat enima u Xhuneꞌ?» chaj najeꞌ tuk tal sqe. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pet asoj tuk qaleꞌ uvaꞌ vatz txꞌavaꞌilla aama kuxheꞌ kat chajon tzan naj, as tuk isuti unqꞌa tenameꞌ kꞌubꞌ sqiꞌ, tan ninima unqꞌa tenameꞌ uvaꞌ qꞌajsan tetz viyol u Tiixheꞌ u Xhuneꞌ,— tiꞌk chajnaj svatzaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","As ech tal veꞌt chajnaj ileꞌ te Aak: —Yeꞌ qootzaj abꞌil kat chajon tzan u Xhuneꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","As ech tal veꞌt u Jesús ileꞌ te chajnaj: —Mitaꞌn in la alon sete uvaꞌ abꞌil kat aqꞌon u vijleꞌmeꞌ tiꞌ uvaꞌ kat unbꞌana,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","As tal veꞌt u Jesús umaꞌt u kꞌuchuvatz te unqꞌa tenameꞌ. Ech tal Aak ileꞌ: —Tan tava veꞌt umaꞌl u naj kaꞌl unqꞌa uuva tu vitxꞌavaꞌeꞌ. As taqꞌ veꞌt kan naj vitxꞌavaꞌeꞌ tukꞌ vichikoeꞌ skꞌam te kaꞌl unqꞌa aqꞌonvil. As nimal qꞌii bꞌex ibꞌan naj tu umaꞌt tenam. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tul ilej veꞌt u qꞌiieꞌ tiꞌ ituxpu ivatz unqꞌa uuvaeꞌ, as ichaj veꞌt vibꞌaal unqꞌa uuvaeꞌ umaꞌl vikꞌam xeꞌ unqꞌa kꞌamoleꞌ tiꞌ ul teqꞌot unbꞌooj ivatz unqꞌa uuvaeꞌ kꞌambꞌal tetz u txꞌavaꞌeꞌ. As yeꞌxhkam chit taqꞌ bꞌen chajnaj stiꞌ. Pet kat iqꞌos veꞌt chajnaj u kꞌameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","As ichaj veꞌt bꞌen vibꞌaal unqꞌa uuvaeꞌ umaꞌt vikꞌameꞌ. As echat chit ibꞌan unqꞌa kꞌamoleꞌ te u kꞌameꞌ, tan xeꞌt iqꞌos chajnaj. As iyoqꞌ veꞌt chajnaj. As qꞌaav kuxh veꞌt u kꞌameꞌ, tan jit taqꞌ chajnaj vivatz u uuvaeꞌ ste. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","As ichaj veꞌt bꞌen vibꞌaal unqꞌa uuvaeꞌ itoxvu vikꞌameꞌ. As echat chit kat ibꞌan unqꞌa kꞌamoleꞌ. Tan kat ikꞌaxbꞌisa chajnaj tul kat itilu el chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","As ech tal veꞌt jeꞌ vibꞌaal u uuva ileꞌ ste: «¿Kam tuk unbꞌaneꞌ? Pet tuk unchaj bꞌen vunkꞌaoleꞌ uveꞌ xoꞌn chit sve. As tul la til chajnaj vunkꞌaoleꞌ, as kamal aꞌn la inima veꞌt chajnaj,» tiꞌk vibꞌaal unqꞌa uuvaeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Tul til veꞌt unqꞌa kꞌamoleꞌ toon u kꞌaolaeꞌ, as ech tal veꞌt chajnaj ileꞌ svatzaj: «Aꞌ vikꞌaol najeꞌ vil tuleꞌ. As aꞌ najeꞌ tuk etzin kan unqꞌa uuvaeꞌ tukꞌ u txꞌavaꞌeꞌ. ¡Pet koꞌ kuyatzꞌ naj! ¡As qetz veꞌt u txꞌavaꞌeꞌ la ibꞌaneꞌ!» tiꞌk unqꞌa kꞌamoleꞌ tal svatzaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","As teqꞌo veꞌt el unqꞌa kꞌamoleꞌ vikꞌaol vibꞌaal unqꞌa uuvaeꞌ tiꞌeꞌl u txꞌavaꞌeꞌ uvaꞌ atikkat unqꞌa uuvaeꞌ. As kat iyatzꞌ veꞌt chajnaj. As tuk vabꞌi sete, ¿kam la tulbꞌe veꞌt vibꞌaal u chikoeꞌ qꞌi unqꞌa kꞌamoleꞌ uveꞌ netaleꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","As tuk val sete, tan la ul veꞌteꞌ vibꞌaal u chikoeꞌ. As la iyatzꞌ veꞌt unqꞌa kꞌamoleꞌ skajayil. As vaꞌlen veꞌt unqꞌa kꞌamoleꞌ la kaa tu vitxꞌavaꞌeꞌ,— tiꞌk u Jesús. As ech tal veꞌt unqꞌa tenam ileꞌ tul tabꞌi u yoleꞌ uveꞌ tal Aak: —¡Tiixheꞌ la alon uvaꞌ yeꞌl unpajoj la ibꞌaneꞌ echeꞌ uveꞌ naaleꞌ!— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","As isaji veꞌt bꞌen u Jesús unqꞌa tenameꞌ. As ech tal veꞌt Aak ileꞌ: —¿As kam ni tokkat u yoleꞌ qꞌi sete uveꞌ tzꞌibꞌamal kan uvaꞌ ech ni tal ileꞌ? As u kꞌubꞌeꞌ uvaꞌ kat sutil el taꞌn unqꞌa lakol kabꞌaleꞌ, as tul aꞌeꞌ ni tok xeꞌabꞌ tetz vixoobꞌ u kabꞌaleꞌ, tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","As abꞌil uveꞌ la jojtxꞌu tiꞌ u kꞌubꞌeꞌ, as yak chit la tatzꞌmeꞌ. As abꞌil uvaꞌ la kuꞌ u kꞌubꞌeꞌ stiꞌ, as yak chit la vuchꞌmeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","As bꞌen veꞌt te unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh as tukꞌ unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ uvaꞌ chajnaj nikat tal Aak tukꞌ u kꞌuchuvatzeꞌ. As oora koj chit itxey veꞌt chajnaj u Jesús uvaꞌ nik taleꞌ. As nik ixoꞌv chajnaj vatz unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","As atik chit veꞌt kuꞌ chajnaj tiꞌ icheesal ipaav u Jesús. As ichaj veꞌt bꞌen chajnaj kaꞌl unqꞌa eesan yol uvaꞌ nikat ibꞌensa veꞌt tibꞌ jikla aamail, tiꞌ tabꞌit viyol u Jesús, tan aꞌ nikat tal chajnaj uvaꞌ la ixoch veꞌt chajnaj Aak. As la toksa veꞌt ok chajnaj Aak tiqꞌabꞌ u bꞌooqꞌol tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","As ech tal veꞌt unqꞌa eesan yol ileꞌ te Aak: —Chusul, ootzimal veꞌt sqaꞌn uvaꞌ jik chit nayoloneꞌ as jik chit nachusuneꞌ. As tukꞌ chit ijikil nachus unqꞌa uxhchileꞌ tiꞌ uvaꞌ jik vitxumbꞌaleꞌ la ibꞌan vatz u Tiixheꞌ, tan eela ivatz unqꞌa uxhchileꞌ nabꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Estiꞌeꞌ tuk qabꞌi umaꞌl u yol see, ¿ma bꞌaꞌn uvaꞌ la kuchoo veꞌt u puajeꞌ uveꞌ nijajpu sqe taꞌn u ijlenaaleꞌ tu u Roma, pet moj yeꞌle?— tiꞌk unqꞌa najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","As atik veꞌt skꞌuꞌl Aak uvaꞌ tuch kuxh nikat tal chajnaj te Aak. As ech tal veꞌt Aak ileꞌ: —¿Kam stiꞌ qꞌi uveꞌ nu kuxh echuk txumbꞌal sviꞌ tiꞌ uvaꞌ la echeesa unpaav? ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Pet ekꞌuchtaj umaj u puajeꞌ sve. ¿As abꞌil etz u vatzibꞌaleꞌ tukꞌ u tzꞌibꞌeꞌ uveꞌ at vatz u puajeꞌ?— tiꞌk Aak. Ech tal veꞌt chajnaj ileꞌ: —Tetz u ijlenaaleꞌ tu u Roma,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","As ech tal veꞌt u Jesús ileꞌ: —Jankꞌal u tetz u ijlenaaleꞌ tu u Roma, as etaqꞌtaj ste. As jankꞌal unqꞌa tetz u Tiixheꞌ, as etaqꞌtaj te Aak,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","As teqꞌo veꞌt taama chajnaj taꞌn viyol Aakeꞌ. As jit tiin veꞌt chajnaj, tan yeꞌ kat olebꞌ chajnaj tiꞌ icheesal ipaav Aak vatz unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","As jetzꞌen veꞌt ok kaꞌl unqꞌa saduceo kꞌatz u Jesús tiꞌ ichꞌotil te Aak, tan yeꞌl unqꞌa kamnajeꞌ la ul taama unpajte uveꞌ ni tal unqꞌa saduceo. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","As ech tal veꞌt chajnaj ileꞌ te Aak: —Chusul, kat itzꞌibꞌa kan u Moisés umaꞌl u yol uvaꞌ ech ni tal ileꞌ: «Asoj la kam umaj naj as tul yeꞌl umaj initxaꞌ naj la kaaik kan xeꞌ u tixqeleꞌ, as aꞌ umaj u titzꞌin tatzik najeꞌ la teqꞌo tibꞌ tukꞌ u ixojeꞌ tiꞌ taqꞌat kan tiaal u najeꞌ uvaꞌ kat kami,» tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","As atik vujvaꞌl unqꞌa naj uvaꞌ titzꞌin tibꞌ. As kat teqꞌo tibꞌ u atzikaeꞌ tukꞌ u ixojeꞌ. As kat kam naj. As jit nitxaꞌin kan naj tukꞌ u tixqeleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","As teqꞌo veꞌt tibꞌ u bꞌaxa itzꞌinaeꞌ tukꞌ u tixqel u atzikaeꞌ. As kat kam naj unpajte. As jit nitxaꞌin kan naj tukꞌ ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","As teqꞌo tibꞌ ikaꞌv u itzꞌinaeꞌ tukꞌ u ixojeꞌ. As kat kam naj. As eela chit kat el vujvaꞌl unqꞌa najeꞌ uveꞌ titzꞌin tibꞌ. As jit nitxaꞌin kan umaj chajnaj tukꞌ u ixojeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","As tul maꞌtik ikam vujvaꞌl unqꞌa najeꞌ uvaꞌ titzꞌin tibꞌ, as kam veꞌt u ixojeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","As tuk qabꞌi see, as tul uvaꞌ la ul veꞌt taama unqꞌa kamnajeꞌ, ¿as abꞌiste veꞌt u najeꞌ qꞌi itzumel u ixojeꞌ? Tan kat teqꞌo tibꞌ ixoj tukꞌ vujvaꞌl unqꞌa najeꞌ uvaꞌ titzꞌin tibꞌ,— tiꞌk unqꞌa saduceo. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","As ech tal veꞌt u Jesús ileꞌ: —Unqꞌa tenameꞌ uvaꞌ at vatz u txꞌavaꞌeꞌ, as ni teqꞌo tibꞌ unqꞌa najeꞌ tukꞌ unqꞌa ixojeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pet ech koj unqꞌa jikla aamaeꞌ uvaꞌ tetz chittuꞌ tiꞌ ibꞌen kꞌatz u Tiixheꞌ tu umaꞌt u tiichajileꞌ tul la ul taama unpajte, tan yeꞌxhebꞌil la teqꞌo veꞌt tibꞌ tukꞌ ikꞌulel. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","As yeꞌxhkam la kam veꞌteꞌ unpajte, tan eela kuxh veꞌteꞌ tukꞌ unqꞌa ángel la ibꞌaneꞌ. As aꞌeꞌ unqꞌa jikla meꞌal ikꞌaol u Tiixheꞌ uvaꞌ la ul taama unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","As echat u yoleꞌ uvaꞌ kat tal kan u Moisés tiꞌ tul taama unqꞌa kamnajeꞌ unpajte, tan aꞌ kat tal kan u Moisés tu u uꞌujeꞌ tiꞌ uvaꞌ itzꞌibꞌa kan tiꞌ u vokkin chꞌiꞌxeꞌ uvaꞌ nikat itzꞌeꞌeꞌ. As kat tal kan u Moisés uvaꞌ aꞌ u Tiixheꞌ viTiixh u Abraham, as viTiixh u Isaac, as viTiixh u Jacob. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Estiꞌeꞌ ni val sete uvaꞌ aꞌ u Tiixheꞌ viTiixh unqꞌa islich aamaeꞌ, tan vatz u Tiixheꞌ as yeꞌl umaj niman tetz uvaꞌ kamnajlu koj. Pet isleꞌle skajayil,— tiꞌk veꞌt Aak tal te unqꞌa saduceo. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","As ech tal veꞌt kaꞌl unqꞌa naj ileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ: —Chusul, jik chit tel u yoleꞌ uveꞌ naaleꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","As yeꞌxhebꞌil chit kat itxꞌak ichꞌotil umaꞌtoj yol te Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","As ech tal veꞌt u Jesús ileꞌ te unqꞌa tenameꞌ: —¿Kam bꞌan taꞌn qꞌi uvaꞌ ninima unqꞌa tenameꞌ uvaꞌ tiaal David u Cristo? ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tan ech ni tal u David ileꞌ tu u uꞌujeꞌ uvaꞌ Salmo: Ech tal u Bꞌooqꞌol ileꞌ te vunBꞌooqꞌoleꞌ: «Xonebꞌen tu vunsebꞌaleꞌ ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","techanal la vaqꞌ kan unqꞌa uxhchileꞌ jaqꞌ avoj uveꞌ nichꞌoꞌn taama seeꞌ,» tiꞌk u David tal kan. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Pet tul ni tal u David tiꞌ u Cristo uvaꞌ «unBꞌooqꞌol,» taqꞌ ni taleꞌ, ¿as kam qꞌi uvaꞌ nenima uvaꞌ tiaal David u Cristo?— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","As tul nikat tabꞌi unqꞌa tenameꞌ viyol u Jesús, as ech tal veꞌt Aak ileꞌ te unqꞌa ichusulibꞌeꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Atoj enachbꞌal vatz unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, tan achaꞌv chit te chajnaj uvaꞌ ni toksa chajnaj unqꞌa bꞌaꞌnla oksaꞌmeꞌ tukꞌ uvaꞌ ni tok iqꞌii chajnaj taꞌn unqꞌa tenameꞌ tu u kꞌayibꞌaleꞌ. As aꞌ unqꞌa bꞌaꞌnla chaj xonlebꞌaleꞌ nichuk chajnaj tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh. As aꞌ nixonebꞌkat chajnaj tu u bꞌaxa xonlebꞌaleꞌ tul ni tuch unqꞌa bꞌaꞌnla txꞌaꞌoꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","As nimaa chajnaj vikabꞌal unqꞌa txakay ixojeꞌ. As mamaꞌla chit yol ni tal chajnaj tul ninach chajnaj Tiixh tiꞌ toksat jeꞌ chajnaj iqꞌii vatz unqꞌa tenameꞌ. As tuk val sete tan tul chiteꞌ u nimla kꞌaxkꞌoeꞌ tiꞌ chajnaj taꞌn u Tiixheꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","As isaji veꞌt bꞌen u Jesús unqꞌa txꞌiol iqꞌiieꞌ tul uvaꞌ nikat pal taqꞌ kuꞌ chajnaj u puajeꞌ tu u kaaxhaeꞌ uvaꞌ nimolpukat u puajeꞌ tetz u tostiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","As til Aak ipal umaꞌl u txakay ixoj uvaꞌ meebꞌaꞌ chittuꞌ. As pal taqꞌ veꞌt kuꞌ ixoj kaꞌvaꞌl vas ipuaj tu u kaaxhaeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","As ech tal veꞌt Aak ileꞌ te unqꞌa ichusulibꞌeꞌ: —Jik chit tuk val sete tan u txakay ixojeꞌ uvaꞌ meebꞌaꞌ chittuꞌ as nimal chiteꞌ u oyeꞌ uvaꞌ kat taqꞌ kuꞌ tiꞌ unqꞌa txꞌiol iqꞌiieꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","tan aꞌ kuxh unbꞌiil u puajeꞌ ni taqꞌ kuꞌ unqꞌa txꞌiol iqꞌiieꞌ uvaꞌ niyaꞌlan kan xeꞌ chajnaj. Pet ech koj u ixojeꞌ, tan kꞌuxh meebꞌaꞌ chit ixoj, as kat taqꞌ kuꞌ ixoj jankꞌal uveꞌ nitxakon stiꞌ jun qꞌii,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","As nikat iyol kaꞌl unqꞌa ichusulibꞌ u Jesús tiꞌ u tostiixheꞌ uvaꞌ chꞌiꞌumal chit tiloneꞌ taꞌn unqꞌa bꞌaꞌnla chaj sivaneꞌ uvaꞌ atoꞌk stiꞌ as tukꞌ unqꞌa bꞌaꞌnla chaj oyeꞌ uvaꞌ nikat toya unqꞌa uxhchileꞌ tiꞌ ivejat u tostiixheꞌ. As ech tal veꞌt Aak ileꞌ te chajnaj: ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—As uveꞌ netil tiꞌ u tostiixheꞌ scheel, as la ilej umaꞌl u qꞌii uvaꞌ echeꞌ la koj kaaik kan umaj sivan viꞌ umaꞌt sivan. Pet techal tuk eꞌpoj tzan skajayil,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","As ichꞌoti veꞌt unqꞌa ichusulibꞌ Aakeꞌ ste. Ech tal veꞌt chajnaj ileꞌ: —¿Chusul, jatu la ibꞌan uveꞌ naaleꞌ? ¿As kam texhlal tetz tul bꞌiit ibꞌanataꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ech tal veꞌt u Jesús ileꞌ: —Atoj chit enachbꞌal vatz unqꞌa chulin yoleꞌ aqꞌal uvaꞌ yeꞌ la maxtibꞌel ex, tan nimal unqꞌa chulin yoleꞌ la ul tukꞌ vunbꞌiieꞌ. As la ul taleꞌ uvaꞌ: «Ineꞌ u Cristo» as moj «Tul veꞌt u Cristo,» chaj la taleꞌ. As yeꞌxhkam la enima. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","As xoꞌviꞌk kuxh ex tul la etabꞌi yol tiꞌ unqꞌa mam chꞌaꞌoeꞌ moj tiꞌ unqꞌa uxhchileꞌ uveꞌ nibꞌan chꞌaꞌo tiꞌaj unqꞌa ijlenaaleꞌ, tan lanal chit ibꞌaneꞌ bꞌaxa. As jit oora la ilej u qꞌiieꞌ tiꞌ itzojpisal veꞌteꞌ uvaꞌ alel kan tiꞌ isotz u vatz txꞌavaꞌeꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","As ech tal Aak ileꞌ unpajte: —La ibꞌan unqꞌa nimla tenameꞌ chꞌaꞌo svatzaj; as la ibꞌan unqꞌa ijlenaaleꞌ chꞌaꞌo svatzaj unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","As la ibꞌan kabꞌlaano uvaꞌ xoꞌvebꞌal chittuꞌ. As katil kuxh la ibꞌankat mamaꞌla vaꞌy tukꞌ unqꞌa mamaꞌla chꞌoꞌmeꞌ uvaꞌ txumlebꞌal chittuꞌ. Mamaꞌla xoꞌvichil la ipalebꞌe unqꞌa tenameꞌ. As xoꞌvebꞌal chit unqꞌa veeꞌ la ikꞌuch tibꞌ vatz u almikaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","As tul yeꞌxnaj uch unqꞌa veeꞌ ni val sete, as la txeypu veꞌt ex. As mamaꞌla kꞌaxkꞌo la epalebꞌe taꞌn unqꞌa bꞌooqꞌol tenameꞌ. As tiꞌ kuxh uvaꞌ kꞌujleꞌl ekꞌuꞌl sviꞌ, as la eqꞌoloꞌk ex vatz unqꞌa qꞌesaleꞌ uveꞌ tu unqꞌa atinbꞌaleꞌ tetz nachbꞌal Tiixh. As la oksal ex tiqꞌabꞌ unqꞌa ijlenaaleꞌ tukꞌ tiqꞌabꞌ unqꞌa bꞌanol ivatz u ijlenaaleꞌ tulaj unqꞌa tenameꞌ. As at ex uvaꞌ la oksal ex tu u kaarsa. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","As tul la epalebꞌe unqꞌa kꞌaxkꞌoeꞌ taꞌn chajnaj, as tzitziꞌ la uchkat etalat veꞌt isuuchil unqꞌa bꞌaꞌnla yoleꞌ sviꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","As yeꞌ la exaansa etaama tiꞌ uvaꞌ kam la etaleꞌ vatz unqꞌa uxhchileꞌ uveꞌ la txeyon ex, ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","tan ineꞌ la aqꞌon etxumbꞌal tiꞌ eyoloneꞌ. As yeꞌ la olebꞌ unqꞌa uxhchileꞌ uveꞌ ni chꞌoꞌn taama setiꞌ tiꞌ teesal iqꞌii u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","As at ex uvaꞌ la oksal veꞌt ex tiqꞌabꞌ unqꞌa uxhchileꞌ uvaꞌ ni chꞌoꞌn taama setiꞌ taꞌn unqꞌa txutx ebꞌaaleꞌ, as moj taꞌn unqꞌa etitzꞌin etatzikeꞌ, as moj taꞌn unqꞌa etatineꞌ, as moj taꞌn unqꞌa etetz kꞌultziꞌeꞌ. As at ex la yatzꞌpu veꞌt ex. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","As nimal unqꞌa tenameꞌ la ixvan ex tiꞌ uvaꞌ kꞌujleꞌl ekꞌuꞌl sviꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","As yeꞌl umaj u xiꞌl eviꞌeꞌ la tzꞌejxi. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","As tioj chit etaama la ebꞌaneꞌ vatz unqꞌa kꞌaxkꞌoeꞌ, tan asoj ech la ebꞌaneꞌ, as at veꞌt etiichajil kꞌatz Aak la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","As tul la etil veꞌteꞌ uvaꞌ xoꞌlamal u Jerusalén taꞌn unqꞌa soleꞌ, as aꞌ veꞌt texhlal tetz uvaꞌ unbꞌiit kuxh isotz veꞌt u tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","As jankꞌal ex uvaꞌ at ex tzitzaꞌ tu u Judea, as la ooj veꞌt ex tulaj unqꞌa koobꞌaleꞌ. As ex uvaꞌ echen ex tu u Jerusalén, as la oojik el ex. As ex uvaꞌ at bꞌen ex tu vitz, as yeꞌ la ok veꞌt ex tu u tenameꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","tan tu unqꞌa qꞌiieꞌ as la aqꞌax ichꞌexel te unqꞌa tenameꞌ uvaꞌ kat ixvan u jikla yoleꞌ. As jankꞌal uvaꞌ tzꞌibꞌamal kan tiꞌ unqꞌa tenameꞌ, as la tzojpisal veꞌteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","As oyebꞌ chit evatz, ex ixoj uvaꞌ at eyaabꞌil tiꞌ etilat umaj etalaj intxaꞌ tukꞌ ex uvaꞌ nitel ichꞌuꞌun veneꞌeꞌ, tul la ul u kꞌaxkꞌoeꞌ setiꞌ tu u qꞌiieꞌ, tan mamaꞌla chit kꞌaxkꞌo la ipalebꞌe unqꞌa tenameꞌ tu u Judea, tan la ul vitxꞌiꞌtziꞌl u Tiixheꞌ tiꞌ unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","As ati la kam taꞌn chꞌichꞌ; as ati la eqꞌol veꞌt spreexhuil tulaj unqꞌa tenameꞌ uvaꞌ jit tiaal Israel, tan la ul eꞌpuloj veꞌt u Jerusalén taꞌn unqꞌa tenameꞌ uvaꞌ jit tiaal Israel. As aꞌ veꞌt unqꞌa tenameꞌ la bꞌekꞌon veꞌteꞌ techal la ilej u qꞌiieꞌ uveꞌ alel kan taꞌn u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","As la ilax veꞌt unqꞌa kꞌuchbꞌal tetz u vulebꞌaleꞌ vatz u qꞌiieꞌ tukꞌ vatz u ichꞌeꞌ as tukꞌ xoꞌl unqꞌa txꞌumileꞌ. As la xaan veꞌt taama unqꞌa tenameꞌ vatz u txꞌavaꞌeꞌ. As la teqꞌo veꞌt taama taꞌn vivulun u mar tul la ipilqꞌu tibꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","As yeꞌl veꞌt iyakꞌil unqꞌa tenameꞌ la ibꞌan taꞌn xoꞌvichil tiꞌ titzꞌaleꞌ uvaꞌ kam kuxh kꞌaxkꞌo la ul veꞌt stiꞌ, tan la iyiku veꞌt u Tiixheꞌ unqꞌa veeꞌ at vatz u almikaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","As la til veꞌt unqꞌa tenameꞌ u tulebꞌaleꞌ VIKꞌAOL U NAJEꞌtu u suutzꞌeꞌ. As la uli tukꞌ iyakꞌil as la litzꞌloꞌlan u tulebꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tul la xeꞌt unqꞌa veeꞌ ni valeꞌ, as la eyakꞌinsa etibꞌ. As la sajin veꞌt jeꞌ ex tu almikaꞌ, tan tuk qꞌalpuloj veꞌt ex vatz u kꞌaxkꞌoeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","As tal veꞌt u Jesús umaꞌt u kꞌuchuvatz uvaꞌ ech ni tal ileꞌ: —Eteesataj etexhlabꞌal tiꞌ u higuera tukꞌ unjoltu unqꞌa tzeꞌeꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","tan tul uvaꞌ netil itooqꞌ vixaj tzeꞌeꞌ, as ootzimal setaꞌn uvaꞌ saqꞌi tuk eloj veꞌteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","As echat chit tuk ibꞌan unpajte, tan tul la etil tuch unqꞌa veeꞌ ni val sete, as la etootzi veꞌteꞌ uvaꞌ txantu ilejat veꞌt u qꞌiieꞌ uvaꞌ la ilpu veꞌteꞌ uvaꞌ at u tenameꞌ jaqꞌ u tijleꞌm u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","As jik chit tuk val sete, tan yeꞌxnaj sotz unqꞌa tenameꞌ uvaꞌ tiaal Israel vatz u txꞌavaꞌeꞌ tul la ibꞌan unqꞌa veeꞌ skajayil uveꞌ ni val sete, ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","tan la pal u almikaꞌeꞌ tukꞌ u vatz txꞌavaꞌeꞌ. Pet ech koj vunyoleꞌ, tan aꞌ chiteꞌ yeꞌ la pali. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","La chit etil jeꞌ etibꞌ. As eyansak vetaanxelaleꞌ taꞌn unqꞌa vaꞌlexheꞌ echeꞌ u qꞌabꞌaꞌmeꞌ. As teesak kan kuxh ex unqꞌa xaanchil aamaeꞌ vatz u txꞌavaꞌeꞌ, tan yeꞌ nachel sete tul la ul u qꞌiieꞌ tiꞌ u vulebꞌaleꞌ ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","echeꞌ nibꞌanax tukꞌ umaj ijvil uvaꞌ ni ikꞌan unqꞌa txooeꞌ, tan yeꞌ nachel te txoo tul ni tikꞌal txoo. Tan ech tul u kꞌaxkꞌoeꞌ tiꞌ unqꞌa uxhchileꞌ skajayil uvaꞌ at vatz u txꞌavaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","As atoj enachbꞌal sbꞌenameen. As enachtaj Tiixh tiꞌ uvaꞌ la iloch ex u Tiixheꞌ tiꞌ epal vatz unqꞌa kꞌaxkꞌoeꞌ uveꞌ tuk uloj setiꞌ. As yeꞌl ex la xoꞌv ex vatz VIKꞌAOL U NAJEꞌ tul la uli tu almikaꞌ unpajte,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","As qꞌiil nikat ichusun u Jesús tu u tostiixheꞌ. As sotzsaj maꞌt Aak viꞌ u vitzeꞌ uveꞌ Olivos. ");
INSERT INTO ixlNNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","As nimal chit unqꞌa tenameꞌ nik isebꞌa tibꞌ tiꞌ ibꞌen tu u tostiixheꞌ tiꞌ tabꞌil viyol Aakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","As bꞌiitik kuxh ilejat veꞌt u nimla qꞌiieꞌ uvaꞌ pascua ibꞌii, uvaꞌ nitxꞌaꞌpkat u paaneꞌ uvaꞌ yeꞌl levadura nikuꞌ xoꞌl. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","As unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh as tukꞌ unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as nik ichuk veꞌt chajnaj txumbꞌal tiꞌ iyatzꞌpu u Jesús, tan nikat ixoꞌva chajnaj unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","As ok veꞌt u Satanás viꞌ u taanxelal u Judas uvaꞌ Iscariote. As aꞌ najeꞌ uveꞌ atik ok xoꞌl kabꞌlaval unqꞌa ichusulibꞌ u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","As bꞌex veꞌt u Judas yolon xeꞌ unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh tukꞌ unqꞌa ibꞌooqꞌol unqꞌa xeen tetz u tostiixheꞌ. As iyol veꞌt chajnaj tukꞌ naj tiꞌ uvaꞌ kam la tulbꞌe naj taqꞌax ok u Jesús tiqꞌabꞌ chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","As txuqꞌtxun chit veꞌt chajnaj tiꞌ viyol u Judas. As ikꞌul veꞌt tibꞌ iyol chajnaj uvaꞌ la taqꞌ chajnaj puaj te u Judas. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","As ikꞌujbꞌaꞌ veꞌt u Judas uvaꞌ naj la oksan u Jesús tiqꞌabꞌ chajnaj. As ichuk veꞌt naj txumbꞌal, tan aꞌ nikat tal naj uvaꞌ yeꞌl tenam kꞌatz u Jesús tul la bꞌen toksa naj Aak tiqꞌabꞌ chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","As ilej veꞌt u bꞌaxa qꞌiieꞌ tiꞌ ixeꞌt u nimla qꞌiieꞌ uvaꞌ nitxꞌaꞌpkat u paaneꞌ uvaꞌ yeꞌl levadura nikuꞌ xoꞌl. As tu unqꞌa qꞌiieꞌ, as techal chit nik iyatzꞌpu unqꞌa talaj kaneeroꞌeꞌ tiꞌ inimal u nimla qꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","As ichaj veꞌt bꞌen u Jesús u Luꞌeꞌ tukꞌ u Xhuneꞌ. As ech tal veꞌt Aak ileꞌ te chajnaj: —Bꞌenoj ex. Bꞌen ebꞌantaj tuch u txꞌaꞌoꞌmeꞌ tetz u nimla qꞌiieꞌ, aqꞌal uvaꞌ la kunima,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ech tal veꞌt chajnaj ileꞌ: —¿Pap, katil nasaꞌkat uvaꞌ la bꞌen kubꞌankat tuch u txꞌaꞌoꞌmeꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","As ech tal veꞌt u Jesús ileꞌ: —Tul la ok ex tu u tenameꞌ, as la ekꞌul etibꞌ tukꞌ umaꞌl u naj uvaꞌ eqꞌomal umaꞌl txeꞌn aꞌ staꞌn. As la xekebꞌ ex tiꞌ naj techal la ok naj tu umaꞌl u kabꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","As ech la etal ileꞌ te vibꞌaal u kabꞌaleꞌ: «Ech ni tal u chusul qetz ileꞌ: –¿Abꞌiste u kabꞌaleꞌ uvaꞌ la txꞌaꞌnkat in tukꞌ unqꞌa unchusulibꞌeꞌ tiꞌ inimal u nimla qꞌiieꞌ?– taqꞌ Aak ni taleꞌ,» chaj ex la bꞌen etal ste. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","As la ikꞌuch veꞌt vibꞌaal u kabꞌaleꞌ umaꞌl u nimla kabꞌal sete uvaꞌ echen tikaꞌv ichup u kabꞌaleꞌ. As bꞌanel veꞌt tuch u kabꞌaleꞌ staꞌn. As tzitziꞌ la ebꞌankat tuch u txꞌaꞌoꞌmeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","As bꞌen veꞌt unqꞌa ichusulibꞌ Aakeꞌ. As bꞌex ibꞌana kam uvaꞌ tal Aak te chajnaj. As ibꞌan veꞌt chajnaj tuch u txꞌaꞌoꞌmeꞌ tetz u nimla qꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","As tul tzꞌotin veꞌteꞌ, as xonebꞌ veꞌt u Jesús vatz u meexhaeꞌ tukꞌ unqꞌa apóstol. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","As ech tal veꞌt Aak ileꞌ te chajnaj: —Aꞌ chiteꞌ nunsaꞌ uvaꞌ la unbꞌan u txꞌaꞌoꞌmeꞌ setukꞌ tu u nimla qꞌiieꞌ tul uvaꞌ yeꞌxnaj unpalebꞌet u kꞌaxkꞌoeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","As ileꞌ la val sete uvaꞌ echeꞌ jatu koj la unbꞌan umaꞌtoj txꞌaꞌoꞌm setukꞌ echeꞌ uvaꞌ nu kubꞌan cheel. Pet lanal oon u qꞌiieꞌ tiꞌ uvaꞌ la ilpu veꞌteꞌ uvaꞌ at veꞌt u tenameꞌ jaqꞌ u tijleꞌm u Tiixheꞌ. As aꞌn la unbꞌan u txꞌaꞌoꞌmeꞌ setukꞌ unpajte tiꞌ inimal u nimla qꞌiieꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","As itxey veꞌt u Jesús u koopa. As taqꞌ veꞌt Aak taꞌntiixh te u Tiixheꞌ stiꞌ. As ech tal veꞌt Aak ileꞌ: —Ekꞌultaj u koopaeꞌ. As etukꞌataj, ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","tan ileꞌ la val sete uvaꞌ yeꞌxh jatu la vukꞌa veꞌt u taꞌl u uuvaeꞌ echeꞌ uvaꞌ nu kubꞌan cheel. Pet lanal ilpu veꞌteꞌ uvaꞌ at u tenameꞌ jaqꞌ u tijleꞌm u Tiixheꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","As itxey veꞌt Aak u paaneꞌ. Taqꞌ veꞌt Aak taꞌntiixh stiꞌ. Ijatx veꞌt Aak. As taqꞌ veꞌt Aak te chajnaj. Ech tal veꞌt Aak ileꞌ: —Aꞌ vunchiꞌoleꞌ uvaꞌ tuk vaqꞌ kꞌaxbꞌisaloj setiꞌ. As chajpaj chit etxꞌaꞌat u paaneꞌ echeꞌ u vaaꞌ nu kubꞌan cheel, as la etulsa in sekꞌuꞌl,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","As tul bꞌaꞌnxi itxꞌaꞌn veꞌt chajnaj, as itxey veꞌt Aak u koopa. As ech tal veꞌt Aak ileꞌ: —As u aꞌeꞌ uvaꞌ at kuꞌ tu u koopaeꞌ, as aꞌeꞌ u akꞌ tzaqꞌiteꞌ uveꞌ la kꞌujebꞌ kan taꞌn vunkajaleꞌ uveꞌ tuk eloj setiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","As umaꞌl ex uvaꞌ tuk aqꞌon ok in tiqꞌabꞌ unqꞌa iqꞌesal unqꞌa tenameꞌ, as il ex atoꞌk tzan ex sunkꞌatz vatz u meexhaeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","As jik chit la val sete, tan in uvaꞌ in IKꞌAOL U NAJEꞌ, as kam chit uveꞌ kꞌujlu kan sviꞌ, as aꞌeꞌ uveꞌ tuk unpalebꞌe. ¡Pet oyebꞌ chit ivatz u najeꞌ uveꞌ tuk aqꞌon ok in tiqꞌabꞌ unqꞌa iqꞌesal unqꞌa tenameꞌ!— tiꞌk u Jesúseꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","As xeꞌt ichꞌoti veꞌt tibꞌ te chajnaj uvaꞌ abꞌiste chajnaj la kꞌayin u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","As xeꞌt iyaa veꞌt tibꞌ unqꞌa apóstol tiꞌ uvaꞌ abꞌiste chajnaj uvaꞌ nim talcheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","As ech tal veꞌt Aak ileꞌ: —Jankꞌal unqꞌa ijlenaaleꞌ tetz unqꞌa tenameꞌ, as nim chit chajnaj ninacheꞌ tiꞌ ibꞌekꞌat unqꞌa tenameꞌ. As ni toksa tibꞌ chajnaj nimla lochol tetz unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pet ech koj ex, tan jitꞌeꞌch la ebꞌaneꞌ echeꞌ uveꞌ nibꞌan unqꞌa najeꞌ. Pet abꞌiste ex uvaꞌ ex iqꞌesal xoꞌl vemooleꞌ, as ech vetxumbꞌaleꞌ la ebꞌaneꞌ echeꞌ umaj uxhchil uvaꞌ yeꞌl tijleꞌm ati as moj echeꞌ umaj kꞌam. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿As kam ni tal ex? ¿Abꞌil uveꞌ nim talcheꞌ? ¿Ma aꞌ u uxhchileꞌ uveꞌ xonlu ok vatz u meexhaeꞌ? ¿Pet moj aꞌ u kꞌameꞌ uveꞌ niqꞌajsan unqꞌa echbꞌubꞌaleꞌ? As ootzimal setaꞌn uvaꞌ aꞌ u uxhchileꞌ uvaꞌ atoꞌk vatz u meexhaeꞌ uvaꞌ nim talcheꞌ tiꞌ u kꞌameꞌ. Pet ech koj uveꞌ nunbꞌan sexoꞌl, tan ech nunbꞌaneꞌ echeꞌ nibꞌan umaj kꞌam. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","As yeꞌl kaꞌtoj uxhchil kat atin sunkꞌatz. Pet ex kuxh kat atin ex sunkꞌatz tul kat unpalebꞌe unqꞌa kꞌaxkꞌoeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Estiꞌeꞌ tuk vaqꞌ etijleꞌm tiꞌ unqꞌa tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ, echeꞌ uveꞌ kat ibꞌan u vunBꞌaaleꞌ sve tiꞌ vilat isuuchil unqꞌa untenameꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","tan at vijleꞌm tiꞌ u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. As la oksal eqꞌii. As la xonebꞌ veꞌt ex sunkꞌatz vatz vunmeexhaeꞌ tiꞌ etxꞌaꞌneꞌ as tiꞌ etukꞌaꞌeꞌ. As la xonebꞌ veꞌt ex tu unqꞌa bꞌaꞌnla xonlebꞌaleꞌ tiꞌ ebꞌanat isuuchil kabꞌlaval unqꞌa tenameꞌ uvaꞌ tiaal Israel,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","As ech tal veꞌt u Jesús ileꞌ te u Luꞌeꞌ: —Simón, Simón, ileꞌ la val see uvaꞌ kat ijajlu veꞌt ex u Satanás sekajayil tiꞌ uvaꞌ ech la tulbꞌe ex najeꞌ echeꞌ nibꞌanchu te u trigo tul nitxaap tu u txaabꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pet kat unjajlu bꞌaꞌnil te u Tiixheꞌ seeꞌ tiꞌ uvaꞌ yeꞌ la atzꞌej u kꞌujlebꞌal akꞌuꞌleꞌ sviꞌ. As tul la yakꞌin veꞌt u kꞌujlebꞌal akꞌuꞌleꞌ sviꞌ unpajte, as laloch veꞌt unqꞌa eetzꞌin aatzikeꞌ tiꞌ iyakꞌin u kꞌujlebꞌal ikꞌuꞌleꞌ sviꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ech tal veꞌt u Luꞌ ileꞌ: —Pap, kꞌuxh la oksal in tu u kaarsa as moj la yatzꞌpu veꞌt in seeꞌ, as la chit xekebꞌ in seeꞌ,— tiꞌk u Luꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","As ech tal veꞌt u Jesús ileꞌ: —Luꞌ, la val see tan tul yeꞌxnaj oqꞌ u peleꞌxheꞌ cheel, as oxpajul maꞌt aalataꞌ uvaꞌ yeꞌ ootzaj in,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","As ech tal veꞌt u Jesús ileꞌ te unqꞌa ichusulibꞌeꞌ: —Tul kat unchaj bꞌen ex unpajxi, as kat val sete uvaꞌ: «Yeꞌl epuaj la eteqꞌo. As mitaꞌn esam. As yeꞌl untzumtoj exaꞌp la eteqꞌo,» chꞌin kat val sete. ¿Pet moj kam kat eyaꞌta tul uvaꞌ kat bꞌex ex?— tiꞌk Aak. Ech tal veꞌt chajnaj ileꞌ: —Yeꞌxhkam, Pap, kat kuyaꞌta,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","As ech tal veꞌt Aak ileꞌ: —Pet ech koj uveꞌ tuk val sete cheel, tan abꞌiste ex uvaꞌ at epuaj, as eteqꞌotaj. As eteqꞌotaj esam. As jankꞌal ex uvaꞌ yeꞌl echꞌichꞌ ati, as ekꞌayitaj umaj etoksaꞌm. As eloqꞌtaj echꞌichꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","tan ileꞌ la val sete uvaꞌ techal chit la unpalebꞌe kam uvaꞌ tzꞌibꞌamal kan uvaꞌ ech ni tal ileꞌ: Antu veꞌteꞌ la ok xoꞌl tachul unqꞌa aapaaveꞌ, taqꞌ u yoleꞌ. As kam chit uveꞌ tzꞌibꞌamal kan sviꞌ as tuk chit ibꞌaneꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","As ech tal veꞌt chajnaj ileꞌ: —Pap, il kaꞌvaꞌl chꞌichꞌ ilaꞌ ati,— tiꞌk chajnaj. Ech tal veꞌt Aak ileꞌ: —Kat ibꞌanleꞌ bꞌa,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","As el veꞌt chꞌuꞌl u Jesús tu kabꞌal, as xekebꞌ veꞌt unqꞌa ichusulibꞌ Aakeꞌ stiꞌ. As bꞌen veꞌt Aak tukꞌ chajnaj xeꞌ tuul u vitzeꞌ uveꞌ Olivos, tan ech chit nikat ibꞌan Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","As tul oon veꞌt Aak tu u atinbꞌaleꞌ tukꞌ chajnaj, as ech tal veꞌt Aak ileꞌ te chajnaj: —Enachtaj chit Tiixh aqꞌal uvaꞌ la iyakꞌinsa Aak u kꞌujlebꞌal ekꞌuꞌleꞌ sviꞌ tul la chukax txumbꞌal setiꞌ tiꞌ eteesal sunkꞌatz,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","As jetzꞌen veꞌt el unbꞌiil Aak kꞌatz chajnaj. Kamal ixaa veꞌt el Aak kaꞌvoꞌj kꞌaꞌj. As kuꞌ veꞌt Aak qaaloj. As inach veꞌt Aak Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ech tal veꞌt Aak ileꞌ: —UnBꞌaal, asoj la asaꞌ, as bꞌan bꞌaꞌnil sve uvaꞌ yeꞌl in la pal in tu u kꞌaxkꞌoeꞌ. As jit in la alon. Pet axh la alon,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","As kuꞌ veꞌt chꞌuꞌl umaꞌl u ángel tu almikaꞌ. As ikꞌuch veꞌt tibꞌ te Aak tiꞌ iyakꞌinsal taama Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","As ayaꞌl chit veꞌt ikꞌuꞌl Aak nikat inach veꞌt Aak Tiixh, tan vaꞌlik chit itxumun veꞌt taama Aak. As vaꞌlik chit ijoltzꞌaꞌt veꞌt Aak. As nikat ichꞌanxik kuꞌ vitzꞌaꞌ Aakeꞌ tu txꞌavaꞌ echeꞌ ichꞌanxik kuꞌ kaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","As tul yaꞌ veꞌt Aak tiꞌ inachat Tiixh, as txakpu veꞌt Aak. As qꞌaavik veꞌt tzan Aak kꞌatz chajnaj. As vatik veꞌt chajnaj, tan atik vataꞌm tivatz chajnaj taꞌn txumuꞌm. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","As ech tal veꞌt Aak ileꞌ te chajnaj: —¿Kam qꞌi uveꞌ vatik kuxh ex? Txakpoj ex. Enachtaj Tiixh aqꞌal uvaꞌ la iyakꞌinsa Aak u kꞌujlebꞌal ekꞌuꞌleꞌ sviꞌ aqꞌal uvaꞌ yeꞌxhkam kuxh la epalebꞌe,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","As antelik iyolon u Jesús tul bꞌex oonoj u mamaꞌla tenameꞌ tiꞌ itxeypu veꞌt u Jesús. As u Judas uvaꞌ atik ok xoꞌl kabꞌlaval unqꞌa ichusulibꞌ Aakeꞌ, as naj bꞌaxik vatz unqꞌa tenameꞌ. As tul jetzꞌen veꞌt ok naj vatz Aak tiꞌ itzꞌubꞌat naj txala itziꞌ Aak, ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","as ech tal veꞌt Aak ileꞌ te naj: —¿Judas, ma tukꞌ tzꞌubꞌu tziꞌ tuk aaqꞌkat ok in tiqꞌabꞌ unqꞌa uxhchileꞌ uvaꞌ tuk txeyon in, in uvaꞌ in VIKꞌAOL U NAJEꞌ?— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Aꞌn pal veꞌt unqꞌa ichusulibꞌ Aakeꞌ stuul uvaꞌ kam nik ibꞌan u Judas. As ech tal veꞌt chajnaj ileꞌ te u Jesús: —¿Pap, ma la uch kukꞌulelat unqꞌa najeꞌ tukꞌ u kuchꞌichꞌeꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","As tzaa veꞌt umaꞌl naj. As teqꞌo veꞌt jeꞌ tzan naj vichꞌichꞌeꞌ tu totzotz. As itzokꞌ veꞌt el naj visebꞌal ixikin umaꞌl vikꞌam iqꞌesal oksan iyol tenam vatz Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","As ech tal veꞌt u Jesús ileꞌ: —¡Yaꞌsa uveꞌ nabꞌaneꞌ! ¡Yeꞌ eetz tiꞌ naj!— tiꞌk Aak. As ikan veꞌt ok Aak vixikin najeꞌ. As yak kuxh txan vixikin najeꞌ taꞌn Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","As ech tal veꞌt Aak ileꞌ te unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh, tukꞌ unqꞌa iqꞌesal unqꞌa xeen tetz u tostiixheꞌ, tukꞌ kaꞌt unqꞌa bꞌaal tenameꞌ uvaꞌ kat oon tiꞌ itxeyat Aak: —¿Kam qꞌi uvaꞌ eqꞌomal chꞌichꞌ tukꞌ tzeꞌ setaꞌn tiꞌ ul etxeyat in? ¿In kol umaj elqꞌom qꞌa sevatz? ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","As tul jun qꞌii atik in sexoꞌl tu u tostiixheꞌ, as yeꞌ kat etxey in. Pet etetz veꞌteꞌ bꞌa scheel tukꞌ u txꞌiꞌlanajeꞌ tiꞌ etxeyat in, tan kat taqꞌlu veꞌt u Tiixheꞌ etokebꞌal tiꞌ etxeyat in,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","As itxey veꞌt unqꞌa tenameꞌ u Jesús. As teqꞌo veꞌt ok chajnaj Aak tu vikabꞌal iqꞌesal oksan iyol tenam vatz Tiixh. As ech koj u Luꞌeꞌ, tan naach kuxh xekelikkat naj tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","As tul maꞌtik toksat kaꞌl unqꞌa uxhchileꞌ xamal vatz u qꞌanaleꞌ, as xonebꞌ veꞌt ok u Luꞌeꞌ kꞌatz chajnaj vatz u xamaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","As til veꞌt umaꞌl u aaichꞌ uvaꞌ xonlik ok u Luꞌeꞌ vatz u xamaleꞌ. As ibꞌan veꞌt ixoj ikaꞌyal naj. As ech tal veꞌt ixoj ileꞌ: —U najeꞌ viꞌleꞌ, imool tibꞌ najeꞌ tukꞌ u Jesús,— tiꞌk ixoj tal xoꞌl unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","As ech tal veꞌt u Luꞌ ileꞌ: —¡Ixoj, yeꞌ vootzaj u najeꞌ uveꞌ naaleꞌ!— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","As unbꞌiil kuxh veꞌt stuul, as ilpu veꞌt u Luꞌeꞌ taꞌn umaꞌt u naj. As ech tal veꞌt naj ileꞌ te u Luꞌeꞌ: —An chiteꞌ vil amool eebꞌeꞌ tukꞌ chajnaj,— tiꞌk naj. Ech tal veꞌt u Luꞌ ileꞌ: —¡Yeꞌle! ¡Jit unmool vibꞌeꞌ tukꞌ chajnaj!— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","As kamal umaꞌl oora stuul, as ech tal veꞌt umaꞌt naj ileꞌ tiꞌ u Luꞌeꞌ: —An chiteꞌ vil imool tibꞌ najeꞌ tukꞌ u Jesús, tan aa Galilea naj,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ech tal veꞌt u Luꞌ ileꞌ: —¡Yeꞌ vootzaj kam uveꞌ naaleꞌ!— tiꞌk u Luꞌeꞌ. As antelik kuxh iyolon u Luꞌeꞌ tul bꞌex oqꞌoj veꞌt u peleꞌxheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","As isuchqꞌi veꞌt tibꞌ u Jesús. As isaji veꞌt Aak u Luꞌeꞌ. As jubꞌin veꞌt tul viyol Aakeꞌ skꞌuꞌl u Luꞌeꞌ uvaꞌ maꞌtik talat Aak: «Tul yeꞌxnaj oqꞌ u peleꞌxheꞌ, as oxpajul maꞌt eesat eebꞌ sunkꞌatz,» tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","As el veꞌt chꞌuꞌl u Luꞌeꞌ vatz u qꞌanaleꞌ. As vaꞌl chit toqꞌ veꞌt naj tiꞌ ikꞌaxat tibꞌ tiꞌ uvaꞌ kat tal naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","As tzeꞌlebꞌalik kuxh u Jesús te unqꞌa najeꞌ uvaꞌ nik xeeon Aak. As xeꞌt veꞌt chajnaj tiꞌ iqꞌospu Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","As ijup veꞌt chajnaj ivatz Aak taꞌn umaꞌl u suꞌt. As ikꞌaxbꞌisa veꞌt chajnaj ivatz Aak taꞌn qꞌabꞌ. As ech tal veꞌt chajnaj ileꞌ: —Asoj axh qꞌajsan tetz viyol u Tiixheꞌ, as qꞌiia uvaꞌ abꞌil kat qꞌoson axh,— tiꞌk chajnaj te Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","As kam kuxh kꞌaxkꞌola yolil nikat taloꞌk chajnaj te Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","As tul sajbꞌu veꞌteꞌ, as imol veꞌt tibꞌ unqꞌa bꞌaal tenameꞌ, tukꞌ unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh, tukꞌ kaꞌt unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ. As eqꞌol veꞌt ok u Jesús xoꞌl chajnaj tu abꞌiꞌmeꞌ. As ech tal veꞌt chajnaj ileꞌ te Aak: ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Al sqe: ¿Ma axh u Cristo?— tiꞌk chajnaj. Ech tal veꞌt Aak ileꞌ: —Kꞌuxh la val sete, as echeꞌ la koj enima in. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","As kꞌuxh la unchꞌoti umaj yol sete, as echeꞌ la koj etal sve. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","As tuk val sete, uvaꞌ in IKꞌAOL U NAJEꞌ tuk ilej umaꞌl u qꞌii uvaꞌ tuk xonebꞌoj in tu visebꞌal u Kubꞌaal Tiixheꞌ uvaꞌ nim chit u tijleꞌmeꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","As ech tal veꞌt chajnaj ileꞌ skajayil: —¿Ma aꞌ naaleꞌ bꞌa uvaꞌ axh viKꞌaol u Tiixheꞌ?— tiꞌk chajnaj. Ech tal veꞌt Aak ileꞌ: —Kano, an chiteꞌ uveꞌ netaleꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","As ech tal veꞌt chajnaj ileꞌ svatzaj: —¿Kam veꞌt itxaꞌk umaꞌtoj yol uvaꞌ la qabꞌi? Tan ileꞌ kat qabꞌilaꞌ uvaꞌ ni tal naj,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","As tul tzojpu veꞌt u yoleꞌ tu u abꞌiꞌmeꞌ, as jankꞌal unqꞌa uxhchileꞌ uvaꞌ molik tibꞌ tiꞌ icheesal ipaav u Jesús, as bꞌex toksa veꞌt chajnaj Aak vatz u Pilato. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","As xeꞌt icheesa veꞌt chajnaj ipaav Aak te u Pilato. Ech tal veꞌt chajnaj ileꞌ: —Kat kuchꞌotil itziꞌ u najeꞌ. As kat qootzil veꞌteꞌ uvaꞌ nisotzsa naj ikꞌuꞌl unqꞌa tenameꞌ, tan ni tal naj uvaꞌ yeꞌ la taqꞌ unqꞌa tenameꞌ u puajeꞌ te u ijlenaaleꞌ tu u Roma. As ni tal naj unpajte uvaꞌ naj u ijlenaaleꞌ uvaꞌ Cristo,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","As ech tal veꞌt u Pilato ileꞌ te u Jesús: —¿Ma axh u tijlenaal unqꞌa tiaal Israel?— tiꞌk u Pilato. Ech tal veꞌt Aak ileꞌ: —Kano. An chiteꞌ uveꞌ naaleꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","As ech tal veꞌt u Pilato ileꞌ te unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh tukꞌ te unqꞌa tenameꞌ: —Yeꞌl umaj ipaav u najeꞌ nunlejeꞌ,— tiꞌk u Pilato. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","As iyaꞌlu veꞌt chajnaj u Pilato. Ech tal veꞌt chajnaj ileꞌ: —Niyansa naj itxumbꞌal unqꞌa tenameꞌ skajayil tzitzaꞌ tu u Judea taꞌn u yoleꞌ uveꞌ nichus naj, tan kat xeꞌtik tzan naj tu u Galilea. As il naj tul tzitzaꞌ tu u Judea,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","As tul tabꞌi veꞌt u Pilato uvaꞌ aꞌ xeꞌtikkat tzan u Jesús chusun tu u Galilea, as ech tal veꞌt naj ileꞌ te chajnaj: —¿Ma aa Galilea u najeꞌ?— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","As tul alax veꞌt te u Pilato uvaꞌ aa Galilea u Jesús, as ichaj veꞌt bꞌen naj u Jesús vatz u Herodes, tan aꞌ u Herodes bꞌooqꞌol tu u Galilea. As tu u qꞌiieꞌ atik u Herodes tu u Jerusalén. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","As tul til veꞌt u Herodes u Jesús, as vaꞌlik chit itxuqꞌtxun veꞌt naj, tan naꞌxnik tabꞌit naj yol tiꞌ Aak. As aꞌ nikat tal naj uvaꞌ la til naj ibꞌanat Aak umaj kꞌuchbꞌal tetz vibꞌaꞌnil u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","As nimal kuxh yol nik ichꞌoti naj te Aak. As jit tiin Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","As unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh tukꞌ unqꞌa uxhchileꞌ uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as yeꞌ nik iyaꞌ veꞌt chajnaj tiꞌ icheesat ipaav u Jesús vatz u Herodes. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","As teesa veꞌt u Herodes iqꞌii Aak tukꞌ unqꞌa isoleꞌ. As toksa veꞌt chajnaj umaꞌl u bꞌaꞌnla oksaꞌm tiꞌ Aak. As tal veꞌt u Herodes uvaꞌ la bꞌen Aak vatz u Pilato unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","As tu veꞌt u qꞌiieꞌ ikꞌul veꞌt tibꞌ iyol u Herodes tukꞌ u Pilato, tan atik ok ixoꞌl chajnaj sbꞌaxa. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","As imol veꞌt u Pilato unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh, tukꞌ kaꞌt unqꞌa iqꞌesal unqꞌa tenameꞌ, as tukꞌ unqꞌa tenameꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","As ech tal veꞌt u Pilato ileꞌ: —Exeꞌ kat eqꞌon tzan u najeꞌ sunvatz. As netaleꞌ uvaꞌ nisotzsa naj ikꞌuꞌl unqꞌa tenameꞌ, tan aꞌ ni toksa naj tiviꞌ unqꞌa tenameꞌ uvaꞌ yeꞌ la nimal u ijlenaaleꞌ. As ileꞌ kat unchꞌotil te naj sevatz tiꞌ uveꞌ netal sve. As yeꞌl ipaav naj nunlejeꞌ tiꞌ uveꞌ netal sve. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","As echat kuxh kat ibꞌan u Herodes, tan kat iqꞌaavisa veꞌt tzan naj u Jesús sunvatz. Estiꞌeꞌ uvaꞌ la etootzi uvaꞌ yeꞌl ipaav naj ati uvaꞌ la kam naj stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Pet tuk val iqꞌospu naj taꞌn tzꞌuꞌm. As la unchajpu veꞌt el naj,— tiꞌk u Pilato, ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","tan chiannallu te u Pilato uvaꞌ jun yaabꞌ nichajpu el naj umaj u preexhueꞌ tu u nimla qꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","As jolol chit taqꞌat veꞌt jeꞌ unqꞌa tenameꞌ tuul iviꞌ. As ech tal veꞌt ileꞌ: —¡Yatzꞌpoj u Jesús! ¡As chajpuloj u Barrabás!— tiꞌk unqꞌa tenameꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","tan atik veꞌt ok u Barrabás tu u kaarsa, tan antik naj xoꞌl unqꞌa tenameꞌ uvaꞌ nik alon uvaꞌ laik eesal u bꞌanol ivatz u ijlenaaleꞌ tu u Jerusalén. As maꞌtik iyatzꞌon naj unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","As aꞌ nikat tal u Pilato uvaꞌ la chajpul u Jesús. As tal veꞌt naj te unqꞌa tenameꞌ unpajte uvaꞌ la ichajpu naj u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","As aal chit taqꞌ veꞌt jeꞌ unqꞌa tenameꞌ tuul iviꞌ. As ech tal veꞌt ileꞌ: —¡Yatzꞌpoj naj vatz u kuruseꞌ! ¡Yatzꞌpoj naj vatz u kuruseꞌ!— tiꞌk unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","As ech tal veꞌt u Pilato ileꞌ titoxpa: —¿As kam ipaav u najeꞌ qꞌi kat ibꞌana? ¡Tan yeꞌl ipaav naj ati uvaꞌ la yatzꞌpu naj stiꞌ! Pet tuk val iqꞌospu naj. As la unchajpu el naj,— tiꞌk u Pilato. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","As aal chit taqꞌ veꞌt jeꞌ unqꞌa tenameꞌ tuul iviꞌ tukꞌ unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh, tiꞌ ijajataꞌ uvaꞌ la yatzꞌpu u Jesús vatz u kuruseꞌ. As techal chit olebꞌ chajnaj tiꞌ unqꞌa veeꞌ nik tal chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","As tal veꞌt u Pilato uvaꞌ la bꞌanaxi kam uveꞌ nik tal unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","As ichajpu veꞌt u Pilato u Barrabás uvaꞌ atik ok tu u kaarsa tiꞌ paasan tziil as tiꞌ yatzꞌoꞌm, as taqꞌ veꞌt ok u Pilato u Jesús tiqꞌabꞌ unqꞌa tenameꞌ tiꞌ uvaꞌ la ibꞌan unqꞌa tenameꞌ te Aak kam uveꞌ nik tal taama. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","As tul teqꞌo veꞌt unqꞌa tenameꞌ u Jesús tiꞌ iyatzꞌpu vatz u kuruseꞌ, as itxey veꞌt chajnaj umaꞌl u aa Cirene uvaꞌ Simón ibꞌii uvaꞌ aalik itzaa tu vitz. As taqꞌ veꞌt jeꞌ chajnaj u kuruseꞌ viꞌ ichelebꞌ naj. As xekebꞌ veꞌt naj tiꞌ u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","As aꞌ chit mamaꞌla tenameꞌ xekik tiꞌ Aak. As nimal unqꞌa ixojeꞌ uvaꞌ nikat itxumuneꞌ, as vaꞌlik chit toqꞌ chaꞌma tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","As isuchqꞌi veꞌt tibꞌ Aak. As ech tal veꞌt Aak ileꞌ te chaꞌma: —Ex ixoj uveꞌ aa Jerusalén, yeꞌ kuxh oqꞌ ex sviꞌ. Pet etoqꞌletaj jeꞌ etibꞌ; as etoqꞌletaj unqꞌa etaleꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","tan tul umaꞌl u qꞌii uvaꞌ la alpu veꞌteꞌ uvaꞌ: «Chiibꞌebꞌal chit unqꞌa ixojeꞌ uveꞌ yeꞌ ni talaneꞌ, tukꞌ unqꞌa ixojeꞌ uveꞌ yeꞌ nijeꞌ ventasioon stiꞌ, tukꞌ unqꞌa ixojeꞌ uveꞌ yeꞌ kat chꞌuꞌul vichꞌuꞌeꞌ,» chaj u yoleꞌ la taleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","As tul la bꞌen ibꞌaneꞌ, as ech la tal veꞌt unqꞌa tenam ileꞌ te unqꞌa vitzeꞌ: «¡Eꞌpen tzan sqiꞌ! ¡Emujtaj oꞌ vatz u kꞌaxkꞌoeꞌ!» chaj veꞌt unqꞌa tenameꞌ la taleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","As la val sete, asoj ech ni vulbꞌeleꞌ echeꞌ u vaaꞌ as tul yeꞌl unpaav ati, ¿as aꞌ kol chit yeꞌ la bꞌanchu qꞌa sete, tul ex aapaav?— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","As eqꞌomalik kaꞌvaꞌt unqꞌa naj taꞌn unqꞌa tenameꞌ, uvaꞌ bꞌanol vaꞌlexh chittuꞌ tiꞌ uvaꞌ eela iyatzꞌpeꞌ tukꞌ u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","As tul oon veꞌt unqꞌa tenameꞌ, tukꞌ Aak, as tukꞌ kaꞌvaꞌt unqꞌa najeꞌ tu u atinbꞌaleꞌ uvaꞌ «Tatinbꞌal Bꞌajil Kꞌoꞌn» ibꞌii, as tzitziꞌ aqꞌaxkat veꞌt jeꞌ Aak vatz u kuruseꞌ. As aqꞌax veꞌt jeꞌ kaꞌvaꞌt unqꞌa najeꞌ vatz ikurus unpajte: umaꞌl naj atik jeꞌ tisebꞌal Aak; as umaꞌt naj timax Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","As ech tal veꞌt u Jesús ileꞌ: —Pap, sotzsa ipaav unqꞌa uxhchileꞌ, tan yeꞌ tootzajeꞌ uveꞌ nibꞌaneꞌ,— tiꞌk Aak. As ijatx veꞌt unqꞌa soleꞌ u toksaꞌm Aakeꞌ svatzaj. As itxꞌak veꞌt tibꞌ chajnaj tiꞌ u toksaꞌm Aakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","As tul nikat ikaꞌya jeꞌ unqꞌa tenameꞌ u Jesús, as ech tal veꞌt unqꞌa iqꞌesal unqꞌa tenam ileꞌ tul nik teesa chajnaj iqꞌii Aak: —Kat itxꞌol naj iqꞌalpul unqꞌa uxhchileꞌ vatz unqꞌa chꞌoꞌmeꞌ. Asoj an chittuꞌ uvaꞌ naj u Cristo uvaꞌ kꞌujleꞌl taꞌn u Tiixheꞌ, as iqꞌalpu tibꞌ naj vatz u kamchileꞌ scheel,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","As jetzꞌen veꞌt ok unqꞌa soleꞌ kꞌatz u kuruseꞌ tiꞌ teesat chajnaj iqꞌii u Jesús. As taqꞌ jeꞌ chajnaj unbꞌiil u kꞌayla taꞌl uuva te Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","As ech tal chajnaj ileꞌ: —Asoj axh u tijlenaal unqꞌa tiaal Israel, as qꞌalpu eebꞌ vatz u kamchileꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","As atik veꞌt jeꞌ umaꞌl u tzꞌibꞌ tiviꞌ u kuruseꞌ tu viyolbꞌal unqꞌa aa Grecia, tukꞌ tu viyolbꞌal unqꞌa aa Roma, as tukꞌ tu viyolbꞌal unqꞌa tiaal Israel. As ech nik tal u tzꞌibꞌ ileꞌ: Aꞌ U TIJLENAAL UNQꞌA TIAAL ISRAEL U VAAꞌ, tiꞌk u tzꞌibꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","As umaꞌl u bꞌanol vaꞌlexh uvaꞌ atik jeꞌ vatz u kuruseꞌ kꞌatz u Jesús, as ech tal naj ileꞌ tul nik teesa naj iqꞌii u Jesús: —Asoj axh u Cristo, as qꞌalpu eebꞌ vatz u kuruseꞌ; as qꞌalpu oꞌ unpajte,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","As yaanik veꞌt tzan umaꞌt u bꞌanol vaꞌlexheꞌ te vimooleꞌ. Ech tal naj ileꞌ: —¿Ma yeꞌ naxoꞌva u Tiixheꞌ bꞌa? Tul antu veꞌt axh tuk kamoj axh. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","As ech koj oꞌ, tan nu kupalebꞌe u kꞌaxkꞌoeꞌ, tan tiꞌ chit u kupaaveꞌ tuk kamojkat oꞌ. Pet ech koj u Jesús, tan yeꞌl umaj vaꞌlexh kat ibꞌana,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","As ech tal veꞌt naj ileꞌ te u Jesús: —Pap, la oolsa in sakꞌuꞌl tul uvaꞌ la ul axh tiꞌ ook ijlenaalil tiꞌ unqꞌa tenameꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ech tal veꞌt u Jesús ileꞌ te naj: —Ileꞌ jik chit tuk val see, tan cheel tuk atinoj axh sunkꞌatz tu u bꞌaꞌnla atinbꞌaleꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","As tul chaqꞌaan veꞌt qꞌii, as tokin veꞌt ivatz u txꞌavaꞌeꞌ. As techanal oon veꞌt oxvaꞌl oora kuꞌqꞌii. As aꞌn ilon veꞌt u qꞌiieꞌ unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","As tokin veꞌt ivatz u qꞌiieꞌ. As qꞌixmu veꞌt u nimla jitkin ixbꞌuꞌjeꞌ uveꞌ nik jatxon tuul u tostiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","As sikꞌin veꞌt u Jesús. Ech tal veꞌt Aak ileꞌ: —UnBꞌaal, tuk unjatxoꞌk u vaanxelaleꞌ taqꞌabꞌ,— tiꞌk Aak. As tul kuxh tal veꞌt Aak u yoleꞌ, as kam veꞌt Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","As tul til veꞌt viqꞌesal unqꞌa soleꞌ kam uveꞌ uchi, as toksa veꞌt naj iqꞌii u Tiixheꞌ. Ech tal veꞌt naj ileꞌ: —An chiteꞌ vil. Yeꞌl ipaaveꞌ vil u najeꞌ ati. As jikla aama chit najeꞌ vil,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","As unqꞌa tenameꞌ uveꞌ nik ilon kam uveꞌ uchi, as nik ipum veꞌt tziꞌ taama taꞌn txumuꞌm tul qꞌaav veꞌt tu u tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pet ech koj unqꞌa uxhchileꞌ uvaꞌ ootzinik tibꞌ tukꞌ u Jesús as tukꞌ unqꞌa ixojeꞌ uveꞌ xekik chit tiꞌ Aak tul sitzaa Aak tu u Galilea, tan naach kuxh atikkat tzan tiꞌ tilataꞌ kam uvaꞌ nik tulbꞌel Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","As atik umaꞌl u naj tu u Jerusalén uvaꞌ tzaanaj tu u tal tenameꞌ uvaꞌ Arimatea uvaꞌ echen tu u Judea. As Xhuꞌl ibꞌii naj. As jik chit itxumbꞌal naj, tan bꞌaꞌnla aama chit naj. As kꞌuxh atik ok naj xoꞌl unqꞌa bꞌanol isuuchil unqꞌa tenameꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","as jit ikꞌul tibꞌ iyol naj tukꞌ unqꞌa imooleꞌ tiꞌ uvaꞌ la kam u Jesús. As nik itxꞌebꞌ naj u qꞌiieꞌ tiꞌ uvaꞌ la ilpi uvaꞌ at u tenameꞌ jaqꞌ u tijleꞌm u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","As bꞌex ijaj veꞌt naj vichiꞌol u Jesús te u Pilato. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","As teqꞌo veꞌt kuꞌ tzan naj vichiꞌol Aakeꞌ vatz u kuruseꞌ. As ibꞌoch veꞌt naj tu umaꞌl u saj maanta. As bꞌex imuj veꞌt naj tu umaꞌl u jul uvaꞌ kꞌotik ok vatz umaꞌl u piꞌun uvaꞌ yeꞌxnik mujlu umaj kamnaj stuul. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","As aꞌik u qꞌiieꞌ uveꞌ nikat ibꞌan unqꞌa tenameꞌ tucheꞌ tiꞌ inimal u xeem qꞌiieꞌ, tan aalik ixeꞌt veꞌt u xeem qꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","As unqꞌa ixojeꞌ uveꞌ xekik chit tiꞌ u Jesús tul xeꞌt Aak chusun tu u Galilea, as bꞌex til chaꞌma katil uveꞌ mujlukat Aak. As tiloꞌk chaꞌma uvaꞌ kam ulbꞌel ikaa vichiꞌol Aakeꞌ tu u juleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","As qꞌaav veꞌt chaꞌma tu kabꞌal. Bꞌex ibꞌan veꞌt chaꞌma tuch unqꞌa txꞌumtxꞌulla tzꞌakabꞌaleꞌ uvaꞌ laik ok tiꞌ vichiꞌol u Jesús. As tul bꞌanax tuch unqꞌa tzꞌakabꞌaleꞌ, as iꞌl veꞌt chaꞌma tu u xeem qꞌiieꞌ, echeꞌ uveꞌ alel kan. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","As tul kuxh bꞌuuqꞌ qꞌii tu u bꞌaxa qꞌiieꞌ tu xhemaana, as bꞌen veꞌt unqꞌa ixojeꞌ kꞌatz u juleꞌ uvaꞌ mujlukat u Jesús. As eqꞌomalik veꞌt unqꞌa txꞌumtxꞌulla tzꞌakabꞌaleꞌ taꞌn chaꞌma uvaꞌ maꞌtik ibꞌanat chaꞌma tucheꞌ, tiꞌ bꞌen toksat tiꞌ vichiꞌol u Jesús, uvaꞌ nik taleꞌ. As antik kaꞌt unqꞌa ixoj xekik tiꞌ chaꞌma. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","As tul oon veꞌt chaꞌma tziꞌ u juleꞌ, as til veꞌt chaꞌma uvaꞌ bꞌalqꞌumalik veꞌt el u sivaneꞌ uvaꞌ atik tziꞌ u juleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","As ok veꞌt chaꞌma tu u juleꞌ. As til veꞌt chaꞌma uvaꞌ yeꞌlik veꞌt vichiꞌol u Kubꞌaal Jesús atike. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","As sotz veꞌt ikꞌuꞌl chaꞌma. As txaklik kuxh veꞌt chaꞌma tzitziꞌ. As aat kuxh til veꞌt chaꞌma uvaꞌ txaklik veꞌt ok kaꞌvaꞌl unqꞌa naj txala chaꞌma uvaꞌ vaꞌlik chit ilitzꞌkabꞌan unqꞌa toksaꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","As aal chit xoꞌv veꞌt chaꞌma. As qaaebꞌ veꞌt chaꞌma vatz unqꞌa najeꞌ techal toon ivatz chaꞌma vatz txꞌavaꞌ. As ech tal veꞌt unqꞌa naj ileꞌ te chaꞌma: —¿Kam qꞌi uveꞌ nu kuxh echuk u Jesús xoꞌl unqꞌa kamnajeꞌ? Tan yeꞌl Aak kamnajle, ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","tan kat ulyu veꞌt taama Aak. As yeꞌl veꞌt Aak at tzitzaꞌ. Etulsataj viyol Aakeꞌ sekꞌuꞌl uvaꞌ tal kan Aak sete tul uvaꞌ atik Aak tu u Galilea, ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","tan ech kat tal kan Aak ileꞌ: «La aqꞌax ok VIKꞌAOL U NAJEꞌ tiqꞌabꞌ unqꞌa uxhchileꞌ uveꞌ yeꞌ ni niman u Tiixheꞌ. As la kam veꞌt vatz u kuruseꞌ. As titoxvu qꞌii la ul taama unpajte,» tiꞌk Aak,— tiꞌk unqꞌa najeꞌ tal te chaꞌma. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","As ul veꞌt viyol u Jesús skꞌuꞌl chaꞌma. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","As el veꞌt chꞌuꞌl chaꞌma tu u juleꞌ. As bꞌex tal veꞌt chaꞌma te junlaval unqꞌa ichusulibꞌ Aakeꞌ tukꞌ te unjoltu unqꞌa niman tetz Aakeꞌ kam uvaꞌ til chaꞌma. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Antik u Maꞌleꞌ uvaꞌ tzaanaj tu Magdala, tukꞌ u Xhiv, tukꞌ umaꞌt u Maꞌl uvaꞌ vitxutx u Jacobo, tukꞌ kaꞌt unqꞌa ixoj, as aꞌ chaꞌmaeꞌ ul alon te unqꞌa apóstol. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","As jit inima chajnaj viyol unqꞌa ixojeꞌ, tan chꞌuꞌjil elnallukat chaꞌma nikat tal chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","As txakpu veꞌt u Luꞌeꞌ. Oojeꞌl chit veꞌt tel chꞌuꞌl naj tiꞌ bꞌen tilat u juleꞌ uveꞌ mujlukat u Jesús. As tul oon naj, as sajin ok naj tu u juleꞌ. As aꞌ kuxh unqꞌa maantaeꞌ til veꞌt naj uveꞌ bꞌochlukat u Jesús. As vaꞌlik chit teqꞌot veꞌt taama naj tiꞌ uveꞌ til naj. As bꞌen veꞌt naj tu kabꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","As an chit tu qꞌiieꞌ, as bꞌen veꞌt kaꞌvaꞌl vichusulibꞌ u Jesús tu umaꞌl u tal tenam uvaꞌ Emaús. Kamal oxvaꞌl iꞌl ixoꞌl tukꞌ u Jerusalén. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","As tul nikat ixaan chajnaj, as nikat iyolbꞌe chajnaj kam chit uveꞌ kat uchi. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","As tul nikat iyolon chajnaj, as jetzꞌen veꞌt ok u Jesús tiꞌ ixekebꞌ tiꞌ chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","As at kuxh til chajnaj uvaꞌ xekik umaꞌl u uxhchil tiꞌ chajnaj. As jit texhla chajnaj uvaꞌ aꞌik u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","As ech tal veꞌt u Jesús ileꞌ te chajnaj: —¿Kam yolileꞌ qꞌi uveꞌ neyoleꞌ tul nexaaneꞌ? ¿As kam uveꞌ nu kuxh etxumuneꞌ?— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","As umaꞌl u naj uvaꞌ Cleofas ibꞌii as ech tal naj ileꞌ: —¿Ma jit axh aatenam bꞌa? ¿As ma yeꞌ ootzimal bꞌa aꞌn kam uveꞌ kat uch tu u Jerusalén tu unqꞌa qꞌiieꞌ?— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ech tal veꞌt u Jesús ileꞌ: —¿As kam qꞌi kat uchi?— tiꞌk Aak. As ech tal veꞌt chajnaj ileꞌ: —¿As ma yeꞌ kat aabꞌi bꞌa tiꞌ uveꞌ kat ulbꞌel u Jesús uvaꞌ aa Nazaret? As Aakeꞌ qꞌajsan tetz viyol u Tiixheꞌ. As nim chit unqꞌa bꞌaꞌnileꞌ uvaꞌ kat ikꞌuch Aak tukꞌ uveꞌ kat tal Aak vatz u Tiixheꞌ as vatz unqꞌa tenameꞌ unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pet aꞌ unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh tukꞌ unqꞌa iqꞌesal u tenameꞌ uvaꞌ kat kꞌujbꞌaꞌn tiꞌ ikam Aak vatz u kuruseꞌ. As kat aqꞌpik veꞌt jeꞌ Aak vatz u kuruseꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Pet ech koj oꞌ, tan aꞌ kat qala uvaꞌ Aakeꞌ la qꞌalpun u kutenameꞌ vatz unqꞌa uxhchileꞌ uvaꞌ nichꞌoꞌn taama sqiꞌ. As yeꞌ kat bꞌex ibꞌana, tan kat ibꞌanlu veꞌt oxvaꞌl qꞌii ikam veꞌt Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","As kat sotz veꞌt kukꞌuꞌl tul kat ul tal kaꞌl unqꞌa ixoj sqe tiꞌ uvaꞌ kam kat til chaꞌma, tan kuꞌsaj kat bꞌex chaꞌma kꞌatz u juleꞌ uveꞌ mujlukat Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","As yeꞌl veꞌt vichiꞌol Aakeꞌ kat ilej veꞌt chaꞌma tu juleꞌ. As ni tal veꞌt chaꞌma uvaꞌ kat ikꞌuch tibꞌ kaꞌl unqꞌa ángel vatz chaꞌma. As kat tal unqꞌa ángel te chaꞌma uvaꞌ isleꞌl veꞌt Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","As yak kuxh bꞌen veꞌt kaꞌl unqꞌa kumool. Bꞌex til veꞌt chajnaj u juleꞌ. As ni tal chajnaj uvaꞌ an chittuꞌ kam uvaꞌ kat tal unqꞌa ixojeꞌ. As jit til chajnaj u Jesús,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","As ech tal veꞌt u Jesús ileꞌ: —¡Ex chit yeꞌ nepal stuul! ¡Kam chit alkin aamaileꞌ vetetzeꞌ! Tan yeꞌxh nenima unqꞌa yoleꞌ uvaꞌ tzꞌibꞌamal kan taꞌn unqꞌa qꞌajsan tetz viyol u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿As moj yeꞌ ootzimal setaꞌn uvaꞌ techanal la ipalebꞌe u Cristo unqꞌa kꞌaxkꞌoeꞌ? As aꞌn la oksal veꞌt iqꞌii Aak tul uvaꞌ la ok Aak tu almikaꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","As aꞌ xeꞌtkat Aak tiꞌ unqꞌa yoleꞌ uveꞌ tzꞌibꞌamal kan taꞌn u Moisés. As tal veꞌt Aak unpajte tiꞌ unqꞌa yoleꞌ uvaꞌ alel kan taꞌn kaꞌt unqꞌa qꞌajsan tetz viyol u Tiixheꞌ. As tal veꞌt Aak isuuchil unqꞌa yoleꞌ te chajnaj uvaꞌ tzꞌibꞌamal kan tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","As tul oon veꞌt chajnaj tziꞌ u tal tenameꞌ uvaꞌ yakikkat chajnaj, as tal veꞌt u Jesús uvaꞌ yakik veꞌt Aak tu umaꞌt tenam. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","As iyaꞌlu veꞌt chajnaj Aak. Ech tal chajnaj ileꞌ te Aak: —Kaaen kan sukukꞌatz, tan maꞌt veꞌt kuꞌ qꞌii. As tuk tzꞌotinoj veꞌteꞌ,— tiꞌk chajnaj. As ok veꞌt Aak kꞌatz chajnaj tu kabꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","As tul xonlik veꞌt u Jesús tukꞌ chajnaj vatz u meexhaeꞌ tiꞌ itxꞌaꞌneꞌ, as itxey veꞌt Aak u paaneꞌ. As taqꞌ veꞌt Aak taꞌntiixh te u Tiixheꞌ stiꞌ. As ijatx veꞌt Aak te chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","As tul ikꞌul veꞌt chajnaj u paaneꞌ, as texhla veꞌt chajnaj uvaꞌ aꞌik u Jesús. As oora kuxh sotz veꞌt Aak vatz chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","As ech tal veꞌt chajnaj ileꞌ svatzaj: —¡As vaꞌlik chit itxuqꞌtxun u qaanxelaleꞌ tul nikat tal Aak isuuchil unqꞌa yoleꞌ sqe tu bꞌey!— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","As yak kuxh txakpu veꞌt chajnaj. As qꞌaav veꞌt chajnaj tu u Jerusalén. As tul oon veꞌt chajnaj, as kꞌulik tibꞌ junlaval unqꞌa apóstol tukꞌ kaꞌt unqꞌa niman tetz u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","As ech tal veꞌt unqꞌa apóstol ileꞌ tukꞌ unqꞌa niman tetz Aakeꞌ te chajnaj: —¡An chiteꞌ! ¡Kat ulyu veꞌt taama u Kubꞌaal Jesús! Tan kat ikꞌuch tibꞌ Aak te u Simón,— tiꞌke. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","As tal veꞌt ok kaꞌvaꞌl unqꞌa najeꞌ te unqꞌa apóstol uvaꞌ kam ibꞌan chajnaj tukꞌ Aak tu bꞌey, as kam ibꞌan chajnaj tul texhla chajnaj Aak tul ijatx Aak u paaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","As antelik kuxh iyolon unqꞌa najeꞌ, as aat kuxh ilpu veꞌteꞌ uvaꞌ txaklik veꞌt u Jesús xoꞌl unqꞌa uxhchileꞌ uvaꞌ molik tibꞌ. As ech tal veꞌt Aak ileꞌ: —As bꞌaꞌnoj etatin sevatzaj sekajayil,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","As teqꞌo veꞌt taama unqꞌa uxhchileꞌ. As xoꞌv veꞌteꞌ, tan kamal xoꞌval uvaꞌ nikat tal veꞌteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","As ech tal veꞌt Aak ileꞌ te unqꞌa uxhchileꞌ uveꞌ molik tibꞌ tu kabꞌal: —¿Kam uveꞌ nu kuxh exoꞌveꞌ as nu kuxh ikaꞌkabꞌin etaama? ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Etiltaj vunqꞌabꞌeꞌ tukꞌ unqꞌa vojeꞌ, tan ineꞌ taꞌ. As ekantaj in aqꞌal uvaꞌ la pal ex stuul tiꞌ etexhlat in, tan yeꞌl ichibꞌil as yeꞌl ibꞌajil unqꞌa xoꞌvaleꞌ ati. Pet ech koj in, tan il unchiꞌol ati tukꞌ unbꞌajil echeꞌ uvaꞌ netileꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","As tul kuxh tal u Jesús u yoleꞌ, as ikꞌuch veꞌt Aak viqꞌabꞌeꞌ tukꞌ u tojeꞌ te chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","As kꞌuxh vaꞌlik chit ichiibꞌ veꞌt chajnaj, as nikat teqꞌo taama chajnaj, tan yeꞌxnik inima chajnaj uvaꞌ maꞌtik tul taama u Jesús. Estiꞌeꞌ uvaꞌ ech tal Aak ileꞌ te chajnaj: —¿Ma at echbꞌubꞌal sexeꞌ? Ebꞌantaj bꞌaꞌnil. Etaqꞌ unbꞌooj vetz,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","As taqꞌ veꞌt chajnaj unbꞌiil u bꞌoxiꞌm txay te Aak tukꞌ unbꞌiit u txꞌix kabꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","As ikꞌul veꞌt Aak. As techbꞌu veꞌt Aak vatz chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","As ech tal veꞌt Aak ileꞌ te chajnaj: —As jankꞌal chit unqꞌa kꞌaxkꞌoeꞌ uveꞌ kat unpalebꞌe, as aꞌeꞌ uveꞌ kat val sete bꞌaxa tul yeꞌxnaj kam in. As techal chit kat ibꞌana kam unqꞌa veeꞌ tzꞌibꞌamal kan sviꞌ taꞌn u Moisés tukꞌ kaꞌt unqꞌa qꞌajsan tetz viyol u Tiixheꞌ, tukꞌ u yoleꞌ uvaꞌ ni tal tu Salmo,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","As taqꞌ veꞌt Aak itxumbꞌal chajnaj tiꞌ uvaꞌ la pal chajnaj tu yoleꞌ uvaꞌ tzꞌibꞌamal kan tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","As ech tal veꞌt Aak ileꞌ te chajnaj: —Ech ni tal unqꞌa yol ileꞌ uvaꞌ tzꞌibꞌamal kan sviꞌ: «La chit ipalebꞌe u Cristo u kamchileꞌ. As titoxvu qꞌii la ul taama unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","As tukꞌ vibꞌii Aakeꞌ la alpukat isuuchil u yoleꞌ xoꞌl unqꞌa tenameꞌ skajayil tiꞌ uvaꞌ la ikꞌaxa tibꞌ unqꞌa tenameꞌ tiꞌ vipaaveꞌ as la sotzsal veꞌt ipaav. As aꞌ la xeꞌtkat tu u Jerusalén tiꞌ talax isuuchil u yoleꞌ,» tiꞌk u yoleꞌ uvaꞌ tzꞌibꞌamal kan sviꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","As exeꞌ tuk paxsan veꞌt unqꞌa yoleꞌ sviꞌ, tan exeꞌ kat abꞌin as exeꞌ kat ilon kam uvaꞌ kat ulbꞌel in. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Pet kaaoj kan ex tzitzaꞌ tu u Jerusalén. As lanal ekꞌul veyakꞌileꞌ uveꞌ la kuꞌ chꞌuꞌl tu almikaꞌ, tan tuk unchaj tzan u lochol etetzeꞌ uveꞌ alel kan taꞌn vunBꞌaaleꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","As teqꞌo veꞌt el u Jesús unqꞌa ichusulibꞌeꞌ tiꞌeꞌl u Jerusalén. As tul oon Aak tukꞌ chajnaj najlich u Betania, as taqꞌ veꞌt jeꞌ Aak iqꞌabꞌ, as bꞌaꞌn veꞌt iyolon Aak tiꞌ chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","As tul kuxh tal Aak u bꞌaꞌneꞌ tiꞌ chajnaj, as ijetzꞌ veꞌt el tibꞌ Aak. As aat kuxh til veꞌt chajnaj teqꞌol veꞌt jeꞌ Aak tu almikaꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","As toksa veꞌt chajnaj iqꞌii u Jesús. As qꞌaav veꞌt chajnaj tu u Jerusalén. As vaꞌlik chit itxuqꞌtxun veꞌt chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","As jun qꞌii nikat imol veꞌt tibꞌ chajnaj tu u tostiixheꞌ tiꞌ toksal iqꞌii u Tiixheꞌ. An chiteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","As xeꞌ qꞌiisaj atik chit umaꞌl u uxhchil uvaꞌ nikꞌuchun kam bꞌantaꞌn u Tiixheꞌ. As echenikeꞌ kꞌatz u Tiixheꞌ, tan an chit Tiixheꞌ u uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","As atik chiteꞌ u uxhchileꞌ kꞌatz u Tiixheꞌ tul yeꞌxnik chee u vatz txꞌavaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Jankꞌal chit unqꞌa veeꞌ ati, as aꞌeꞌ cheesan tetz. As yeꞌl umaj kam ati uvaꞌ jit u uxhchileꞌ cheesan tetz. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","As echen u tiichajileꞌ kꞌatz u uxhchileꞌ. As aꞌ vitiichajileꞌ u txijun tetz u qaanxelaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","As aꞌ u txijun tetz u qaanxelaleꞌ ni txijun bꞌen u qꞌej toktoeꞌ. As jatu koj la olebꞌ u qꞌej toktoeꞌ tiꞌ itzaasaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","As atik umaꞌl u naj uvaꞌ Xhun ibꞌii uvaꞌ ichaj tzan u Tiixheꞌ ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","tiꞌ ul talat isuuchil unqꞌa yoleꞌ sukuxoꞌl tiꞌ u txijun tetz u qaanxelaleꞌ, aqꞌal uvaꞌ kajayil chit oꞌ tukꞌ unqꞌa tenameꞌ la kukꞌujbꞌaꞌ kukꞌuꞌl tiꞌ u txijun tetz u qaanxelaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jit u Xhuneꞌ u txijun tetz u qaanxelaleꞌ. Pet aꞌ u Xhuneꞌ u alol tetz isuuchil u yoleꞌ tiꞌ uvaꞌ abꞌil u txijun tetz u qaanxelaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","As tul kat ul u txijun tetz u qaanxelaleꞌ uvaꞌ taꞌn chiteꞌ unchꞌiꞌtil vatz u txꞌavaꞌeꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","as atik u txijun tetz u qaanxelaleꞌ xoꞌl unqꞌa tenameꞌ. As kꞌuxh aꞌeꞌ u cheesan tetz u vatz txꞌavaꞌeꞌ skajayil, as yeꞌ kat texhla unqꞌa tenameꞌ u tijleꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","As kꞌuxh aꞌ ulkat xoꞌl vitenameꞌ, as yeꞌ kat kꞌulpu veꞌteꞌ taꞌn vitenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pet abꞌil uveꞌ kat niman as kat ikꞌujbꞌaꞌ ikꞌuꞌl stiꞌ, as aꞌeꞌ kat oksan oꞌ smeꞌal ikꞌaol Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","As yeꞌl uvaꞌ tukꞌ koj itxumbꞌal umaj vatz txꞌavaꞌilla aama as tukꞌ koj u tachaꞌv umaj uxhchil uvaꞌ kat ok oꞌ smeꞌal ikꞌaol Tiixh. Pet tachaꞌv chit u Tiixheꞌ uvaꞌ kat ok oꞌ smeꞌal ikꞌaol Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","As u uxhchileꞌ uvaꞌ nikꞌuchun kam bꞌantaꞌn u Tiixheꞌ, as atik veꞌt sukuxoꞌl, as nimal veꞌt bꞌaꞌnil kat ibꞌana, as nik tal veꞌt u jikla yoleꞌ te unqꞌa tenameꞌ. As kat teqꞌo veꞌt qaama tan ech nik ibꞌaneꞌ echeꞌ uveꞌ nik ibꞌan u Tiixheꞌ tan aꞌeꞌ unchꞌiꞌtil viKꞌaol u Tiixheꞌ. Estiꞌeꞌ kat teqꞌo veꞌt qaama tiꞌ unqꞌa uveꞌ nik ibꞌan Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","As tal u Xhuneꞌ isuuchil unqꞌa yoleꞌ stiꞌ. As ech tal ileꞌ: —Aakeꞌ uvaꞌ kat vala, uvaꞌ ech val ileꞌ: «Xekel tzan umaꞌl u uxhchil sviꞌ. As nim talcheꞌ sviꞌ, tan atik chiteꞌ tul uvaꞌ yeꞌxnik itzꞌebꞌ in,»— tiꞌk u Xhuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","As yeꞌ niyaꞌ u Tiixheꞌ tiꞌ taqꞌat vibꞌaꞌnileꞌ sqe, tan nim chit vibꞌaꞌnil Aakeꞌ sqiꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","tan bꞌaꞌneꞌ vitzaqꞌit Aakeꞌ uvaꞌ atik kan sukuxoꞌl taꞌn u Moisés bꞌaxa. Pet aal chit nim talchu veꞌt vibꞌaꞌnileꞌ tukꞌ u jikla yoleꞌ uvaꞌ at sqiꞌ, as u uxhchil uvaꞌ ni val sete as aꞌeꞌ u Jesucristo, ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","tan yeꞌxhebꞌil kat ilon ikaꞌy u Tiixheꞌ. Pet taꞌn kuxh unchꞌiꞌtil viKꞌaol Aakeꞌ uvaꞌ umaꞌl kuxh vitxumbꞌal Aakeꞌ stukꞌ, as aꞌeꞌ uveꞌ kat alon isuuchil sqe. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Unqꞌa iqꞌesal unqꞌa tenameꞌ tu u Jerusalén as kat ichaj bꞌen chajnaj kaꞌl unqꞌa nachol Tiixh tukꞌ kaꞌt unqꞌa tiaal u Leví tiꞌ bꞌen ichꞌotil te u Xhuneꞌ. As ech tal chajnaj ileꞌ: —¿Kam eejleꞌmeꞌ qꞌi?— tiꞌk chajnaj. As tal veꞌt u Xhuneꞌ isuuchil u tijleꞌmeꞌ te chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","As yeꞌ kat imuj u Xhuneꞌ yol. Pet jik chit kat tal u Xhuneꞌ: —Jit ineꞌ u Cristo,— tiꞌk u Xhuneꞌ tal te chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","As ichꞌoti veꞌt chajnaj: —¿Abꞌiste axh qꞌi uveꞌ naaleꞌ? ¿Ma axh u Elías?— tiꞌk chajnaj. —Yeꞌle, jit ineꞌ,— tiꞌk u Xhuneꞌ. —¿Pet moj axh u qꞌajsan tetz viyol u Tiixheꞌ uvaꞌ la uli?— tiꞌk chajnaj. —Yeꞌle, jit ineꞌ,— tiꞌk u Xhuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","—¿Abꞌiste veꞌt axh qꞌi uveꞌ naaleꞌ? As al sqe, tan la qootzi tiꞌ bꞌen qalat te unqꞌa chajol qetzeꞌ. ¿As kam u eejleꞌmeꞌ uveꞌ la bꞌen qaleꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","As ech tal veꞌt u Xhun ileꞌ: —Aꞌ u vijleꞌmeꞌ uvaꞌ tal kan u qꞌajsan tetz viyol u Tiixheꞌ uvaꞌ Isaías, tul ech tal ileꞌ: Tan ineꞌ uvaꞌ nunsikꞌineꞌ tu u tzuukin txꞌavaꞌeꞌ. As ech ni val ileꞌ: «¡Ebꞌantaj etucheꞌ tiꞌ ekꞌulat u kuBꞌooqꞌoleꞌ echeꞌ ijikbꞌaꞌl umaj bꞌey!» tiꞌk u Isaías tal kan,— tiꞌk u Xhuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","As aꞌ unqꞌa fariseo chajon bꞌen unqꞌa najeꞌ tiꞌ ichꞌotil itziꞌ u Xhuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","As ech tal veꞌt unqꞌa naj ileꞌ te u Xhuneꞌ: —Asoj jit axh u Cristo, jit axh u Elías, jit axh u qꞌajsan tetz viyol u Tiixheꞌ uvaꞌ la uli, as ¿kam qꞌi uveꞌ naaqꞌ kuꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","As ech tal veꞌt u Xhun ileꞌ: —Tan xeꞌ kuxh aꞌeꞌ ni vaqꞌkat kuꞌ unqꞌa uxhchileꞌ. Pet at umaꞌl u uxhchil sexoꞌl uvaꞌ yeꞌ ootzimal u tijleꞌmeꞌ setaꞌn. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","As xekel veꞌt tzan sviꞌ. As jit unkꞌuleleꞌ uvaꞌ la unsaaput vixaꞌpeꞌ, tan nim talcheꞌ sviꞌ,— tiꞌk u Xhuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","As aꞌ ibꞌankat tu umaꞌl u tal tenam uveꞌ Betania jalit u nimla aꞌeꞌ uveꞌ Jordán. As tzitziꞌ nik taqꞌkat kuꞌ u Xhuneꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ tukꞌ vibꞌii u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ech veꞌt qꞌejal stuul, as til veꞌt u Xhuneꞌ ijetzꞌen ok u Jesús skꞌatz. As ech tal veꞌt u Xhun ileꞌ xoꞌl unqꞌa tenameꞌ: —¡Etiltaj, tan il Aak ileꞌ uvaꞌ ech tatineꞌ echeꞌ kaneeroꞌ uvaꞌ niyatzꞌpu vatz u Tiixheꞌ! As Aakeꞌ chajel veꞌt tzan taꞌn u Tiixheꞌ tiꞌ ul isotzsal ipaav unqꞌa tenameꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","As Aakeꞌ uvaꞌ kat val sete uvaꞌ ech val ileꞌ: «Xekel tzan umaꞌl u uxhchil sviꞌ. As atik chiteꞌ tul yeꞌxnik itzꞌebꞌ in,» chꞌin kat vala. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","As mitaꞌn in ootzin tetz Aak. Pet kat ul vaqꞌ kuꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ, aqꞌal uvaꞌ la ootzil veꞌt Aak taꞌn u kutenameꞌ uvaꞌ tiaal Israel,— tiꞌk u Xhuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","As ech tal u Xhun ileꞌ unpajte: —Kat vil ikuꞌ veꞌt chꞌuꞌl u Tiixhla Espíritu tu almikaꞌ, echeꞌ ikuꞌ chꞌuꞌl umaj paroomaxh. As ul ikꞌujbꞌaꞌ veꞌt tibꞌ tiibꞌa Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","As tul yeꞌxnik vootzi Aak, as maꞌtik talat u chajol vetzeꞌ sve uvaꞌ chajon tzan in tiꞌ vaqꞌat kuꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ: «Abꞌil uvaꞌ la eel ikuꞌ veꞌt chꞌuꞌl u Tiixhla Espíritu stiibꞌa as la atin skꞌatz, as Aakeꞌ la aqꞌon veꞌt ok u Tiixhla Espíritu tu vetaanxelaleꞌ,» tiꞌk sve. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","As aꞌeꞌ kat vila. Estiꞌeꞌ ni val sete uvaꞌ Aakeꞌ viKꞌaol u Tiixheꞌ,— tiꞌk u Xhuneꞌ tal te unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ech qꞌejal stuul, as atik veꞌt u Xhuneꞌ tukꞌ kaꞌvaꞌl vichusulibꞌeꞌ tziꞌ u aꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tul til u Xhuneꞌ ipal u Jesús, as ech tal veꞌt ileꞌ: —¡Il Aak ileꞌ! ¡As Aakeꞌ uvaꞌ ech tatineꞌ echeꞌ kaneeroꞌ uvaꞌ niyatzꞌpu vatz u Tiixheꞌ! As chajel veꞌt tzan Aak taꞌn u Tiixheꞌ tiꞌ ul isotzsal ipaav unqꞌa tenameꞌ skajayil,— tiꞌk u Xhuneꞌ tal te kaꞌvaꞌl vichusulibꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","As tul tabꞌi veꞌt chajnaj uvaꞌ tal u Xhuneꞌ tiꞌ u Jesús, as taqꞌ veꞌt kan chajnaj u Xhuneꞌ. As xekebꞌ veꞌt chajnaj tiꞌ u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","As isuchqꞌi veꞌt tibꞌ Aak. Isaji veꞌt Aak kaꞌvaꞌl u najeꞌ uvaꞌ xekik tiꞌ Aak. As ichꞌoti veꞌt Aak itziꞌ chajnaj: —¿Kam nechukeꞌ?— tiꞌk Aak tal te chajnaj. Ech tal veꞌt chajnaj ileꞌ: —¿Rabí, katil jejleꞌlkat axh?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","As ech tal Aak ileꞌ: —Siꞌunaj. Etiltaj,— tiꞌk Aak tal te chajnaj. Bꞌen veꞌt chajnaj tiꞌ Aak. Bꞌex til veꞌt chajnaj katil uveꞌ atikkat Aak. As kaa veꞌt chajnaj kꞌatz Aak, tan kamal kajvaꞌl oora kuꞌ qꞌii oon chajnaj kꞌatz Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","As Lixh ibꞌii umaꞌl u najeꞌ uvaꞌ kat abꞌin viyol u Xhuneꞌ. As xekebꞌ veꞌt naj tiꞌ u Jesúseꞌ. As aꞌ u Lixheꞌ u titzꞌin u Simón uvaꞌ Luꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","As bꞌex ichuk veꞌt u Lixheꞌ u Simón. As tul ilej naj u Simón uvaꞌ Luꞌ, as ech tal naj ileꞌ: —¡Kat kulejlu veꞌt u Mesías!— tiꞌk naj, tan «Cristo» isuuchil u yoleꞌ uvaꞌ «Mesías.» ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","As teqꞌo u Lixheꞌ u Simón stiꞌ. Bꞌex ikꞌuch veꞌt naj u Jesús. Tul oon u Simón vatz u Jesús, as aalik ok Aak te naj. As ech tal veꞌt Aak ileꞌ: —Axh Simón, ikꞌaol Jonás, cheel jit veꞌt axh Simón. Pet axh veꞌt Cefas la ibꞌaneꞌ,— tiꞌk u Jesús, tan aꞌ isuuchil u yoleꞌ uvaꞌ «Cefas» as «Luꞌ» tu kuyolbꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ech qꞌejal stuul, as tal veꞌt u Jesús ibꞌen tu u Galilea. As tul oon veꞌt Aak, ilej veꞌt Aak umaꞌl u naj uvaꞌ Piꞌl. As ech tal Aak ileꞌ te naj: —Xekebꞌen sviꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","As aꞌ tzaanajkat u Piꞌleꞌ tu u Betsaida, tan umaꞌl kuxh itenam naj tukꞌ u Luꞌeꞌ as tukꞌ u Lixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","As bꞌex ichuk veꞌt u Piꞌleꞌ u Natanael. Tul ilej naj u Natanael, as ech tal naj ileꞌ: —Kat kulejlu veꞌt u uxhchileꞌ uvaꞌ itzꞌibꞌa kan u Moisés tukꞌ uvaꞌ tal kan unqꞌa qꞌajsan tetz viyol u Tiixheꞌ. As aꞌeꞌ vil uvaꞌ Jesús, vikꞌaol u Xhuꞌleꞌ, uvaꞌ aa Nazaret,— tiꞌk u Piꞌleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","As ech tal u Natanael ileꞌ: —¿La kol chit el chꞌuꞌl umaj bꞌaꞌnla uxhchil qꞌa tu u Nazaret?— tiꞌk naj. Ech tal veꞌt u Piꞌl ileꞌ: —¡Koꞌon! ¡Kuxh ila!— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","As tul til veꞌt u Jesús toon u Natanael skꞌatz, as ech tal veꞌt Aak ileꞌ tiꞌ naj: —Il umaꞌl u tiaal Israel ileꞌ uvaꞌ jik chit itxumbꞌal, tan yeꞌl yol nichuli naj,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","As ichꞌoti veꞌt u Natanael te Aak: —¿Katil qꞌi ootzikat in?— tiꞌk naj. As ech tal veꞌt Aak ileꞌ: —Maꞌtik vilat axh jaqꞌ umaꞌl u higuera tul yeꞌxnik oon u Piꞌleꞌ tiꞌ amololeꞌ,— tiꞌk Aak tal te naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ech tal u Natanael ileꞌ: —Chusul, axheꞌ vil viKꞌaol u Tiixheꞌ. As axheꞌ u tijlenaal u kutenameꞌ uveꞌ tiaal Israel,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","As ech tal veꞌt u Jesús ileꞌ: —¿Ma nakꞌujbꞌaꞌ akꞌuꞌl sviꞌ tiꞌ uvaꞌ kat val see uvaꞌ kat vil axh jaqꞌ u tzeꞌeꞌ uvaꞌ higuera? Pet tuk val see, tan nimeꞌ uveꞌ tuk eeleꞌ tiꞌ uvaꞌ kat val see. ");
INSERT INTO ixlNNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","As ech tal veꞌt u Jesús ileꞌ: —Tan jik chit tuk val sete, tan la etil uvaꞌ jajleꞌl veꞌt u almikaꞌeꞌ. As tuk etil ijeꞌeꞌ as ikuꞌ chꞌuꞌl unqꞌa ángeleꞌ uvaꞌ tetz u Tiixheꞌ tiibꞌa VIKꞌAOL U NAJEꞌ tiꞌ ilochpeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tu veꞌt itoxvu qꞌii, as tiꞌ umaꞌl u nimla qꞌii tiꞌ teqꞌot tibꞌ umaj uxhchil tu u tenam uvaꞌ Caná uvaꞌ echen tu u Galilea. Atik vitxutx u Jesús tzitziꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","As saꞌbꞌelal veꞌt u Jesús tukꞌ unqꞌa ichusulibꞌeꞌ tu u tzumbꞌaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","As til veꞌt vitxutx u Jesús uvaꞌ motx veꞌt u vino xoꞌl unqꞌa tenameꞌ. As ech tal veꞌt ileꞌ: —Kat motxyu veꞌt u vino,— tiꞌk vitxutx Aakeꞌ tal ste. ");
INSERT INTO ixlNNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","As ech tal veꞌt Aak ileꞌ: —¿Txutx, kam ni tokkat u yoleꞌ uveꞌ naal sve? Tan yeꞌ ilejeꞌte uvaꞌ la unkꞌuch u vijleꞌmeꞌ te unqꞌa tenameꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","As ech tal veꞌt vitxutx u Jesús ileꞌ te unqꞌa lochonaaleꞌ: —Ebꞌantaj kam uveꞌ tuk tal Aak sete,— tiꞌk vitxutx u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","As atik vaajil unqꞌa nimla chaj loꞌch. As kamal oꞌvoꞌj txeꞌn aꞌ nikat ibꞌen tu junun u loꞌcheꞌ. As aꞌ itxaꞌk unqꞌa loꞌcheꞌ tiꞌ imolpu aꞌ uvaꞌ nik itxakonsa unqꞌa tiaal Israel tiꞌ itxꞌaat iqꞌabꞌ tukꞌ tiꞌ itxꞌaat unqꞌa aqꞌonbꞌaleꞌ tu kabꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","As ech tal veꞌt u Jesús ileꞌ te unqꞌa lochonaaleꞌ: —Enoosataj unqꞌa loꞌcheꞌ taꞌn aꞌ,— tiꞌk Aak. As inoosa veꞌt chajnaj unqꞌa loꞌcheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","As tul noo veꞌt unqꞌa loꞌcheꞌ, as ech tal veꞌt Aak ileꞌ: —Eteesataj el tzan unbꞌooj uveꞌ at tu u loꞌcheꞌ. As bꞌen etaqꞌtaj te u ilol tetz isuuchil u nimla qꞌiieꞌ tiꞌ teqꞌot tibꞌ meꞌal ikꞌaol umaj uxhchil,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","As tul tukꞌa veꞌt u ilol tetz isuuchil u tzumbꞌaꞌeꞌ u aꞌeꞌ uveꞌ ibꞌensa u Jesús sbꞌaꞌnla vino, as jit alpu te naj uvaꞌ katil tzaakat u vino. As aꞌik kuxh unqꞌa lochonaaleꞌ ootzin tetz. As imolo veꞌt u ilol tetz isuuchil u nimla qꞌiieꞌ u najeꞌ uveꞌ teqꞌo tibꞌ tukꞌ tixqel. ");
INSERT INTO ixlNNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","As ech tal veꞌt naj ileꞌ: —Jankꞌal chit unqꞌa najeꞌ as aꞌ nibꞌaxsa chajnaj unqꞌa bꞌaꞌnla chaj vino. As tul nimal maꞌt tukꞌaleꞌ, as aꞌn kat pal veꞌt u vino uveꞌ yeꞌl itxaꞌk. Pet ech koj axh, tan kat akol u bꞌaꞌnla vino. As aꞌn ileꞌ naaqꞌ veꞌteꞌ,— tiꞌk naj tal te u najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","As aꞌ u bꞌaxa kꞌuchbꞌal tetz u tijleꞌm u Jesús uvaꞌ kat ibꞌana. As aꞌ kat ibꞌankat tu u tal tenam uvaꞌ Caná uvaꞌ echen tu u Galilea. As kat ikꞌuch veꞌt Aak uvaꞌ nim talchu veꞌt Aak. As aal chit ikꞌujbꞌaꞌ veꞌt unqꞌa ichusulibꞌ Aakeꞌ ikꞌuꞌl stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","As tul maꞌtik itzojpu veꞌt u nimla qꞌiieꞌ tiꞌ teqꞌot tibꞌ meꞌal ikꞌaol umaj uxhchil, as bꞌen veꞌt Aak tu u Capernaúm tukꞌ vitxutxeꞌ tukꞌ unqꞌa titzꞌin Aakeꞌ tukꞌ unqꞌa ichusulibꞌeꞌ. As yeꞌ kuxh jatvaꞌl qꞌii ibꞌan Aak tzitziꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","As bꞌiitik kuxh tul veꞌt u nimla qꞌiieꞌ uvaꞌ pascua ibꞌii. As bꞌen veꞌt u Jesús tu u Jerusalén tukꞌ unqꞌa ichusulibꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","As tul ok veꞌt Aak vatz viqꞌanal u tostiixheꞌ, as til veꞌt Aak unqꞌa uxhchileꞌ uveꞌ nik ikꞌayineꞌ. At chajnaj nikat kꞌayin vaakaxh, kaneeroꞌ, paroomaxh tiꞌ toksat unqꞌa tenameꞌ unqꞌa avaneꞌ vatz u Tiixheꞌ. As til Aak uvaꞌ xonlik kaꞌt unqꞌa naj uvaꞌ nik jalon unqꞌa puajeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","As ipaatxꞌu veꞌt Aak umaꞌl u tzꞌuꞌm. As ilaqꞌbꞌa veꞌt el Aak unqꞌa uxhchileꞌ skajayil uveꞌ nik kꞌayin unqꞌa ikaneeroꞌeꞌ tukꞌ unqꞌa ivaakaxheꞌ. As imakꞌeꞌl Aak vipuaj unqꞌa najeꞌ uveꞌ nikat jalon puaj. As ipilqꞌu veꞌt Aak unqꞌa imeexha chajnajeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","As ech tal veꞌt Aak ileꞌ te unqꞌa kꞌayin paroomaxheꞌ: —¡Eteqꞌotaj el unqꞌa etetzeꞌ! ¡Yeꞌ kuxh etoksa u tostiixheꞌ skꞌayibꞌalil, tan tetz vunBꞌaaleꞌ!— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","As aꞌn ul veꞌt u yoleꞌ skꞌuꞌl unqꞌa ichusulibꞌ Aakeꞌ uvaꞌ tzꞌibꞌamal kan uvaꞌ ech ni tal ileꞌ: As nichꞌoꞌn vaama tiꞌ unqꞌa veeꞌ ni tuch tu vakabꞌaleꞌ, tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","As ech tal veꞌt unqꞌa iqꞌesal unqꞌa tenam ileꞌ te u Jesús: —¿Kam kꞌuchbꞌal tetz u eejleꞌmeꞌ la akꞌuch sqe uvaꞌ la uch abꞌanataꞌ uveꞌ nabꞌaneꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","As ech tal veꞌt u Jesús ileꞌ: —Kꞌuxh la eteꞌpu u kabꞌalaꞌ, as la untxakpisa titoxvu qꞌii,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","As ech tal veꞌt chajnaj ileꞌ: —¿Ma aꞌ naaleꞌ uvaꞌ oxvaꞌl kuxh qꞌii la atxakpisakat u tostiixheꞌ? As tul vaajil toxkꞌal yaabꞌ (46) kat txakpisalkat,— tiꞌk unqꞌa iqꞌesal unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","As yeꞌl uvaꞌ aꞌ koj chit u kabꞌaleꞌ uvaꞌ tal Aak. Pet aꞌ vichiꞌol Aakeꞌ uvaꞌ tala, tul uvaꞌ la ul taama Aak unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","As xamtik veꞌt stuul tul maꞌtik tul veꞌt taama Aak, as ul veꞌt viyol Aakeꞌ skꞌuꞌl unqꞌa ichusulibꞌeꞌ uvaꞌ tal Aak. As inima veꞌt chajnaj u yoleꞌ uveꞌ tzꞌibꞌamal kan tiꞌ u tulebꞌal taama Aakeꞌ as tukꞌ u yoleꞌ uvaꞌ tal Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","As tul atik u Jesús tu u Jerusalén tiꞌ tilat u nimla qꞌiieꞌ, as yeꞌ saach unqꞌa tenameꞌ ikꞌujbꞌaꞌ ikꞌuꞌl tiꞌ Aak, tan tiꞌ uvaꞌ til veꞌt unqꞌa tenameꞌ unqꞌa kꞌuchbꞌal tetz u tijleꞌm Aakeꞌ uveꞌ nik ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pet jit ikꞌujbꞌaꞌ Aak ikꞌuꞌl tiꞌ unqꞌa tenameꞌ, tan ootzimalik taꞌn Aak kam uvaꞌ at tu u taanxelal unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","As jit tzꞌajinal la alpu te Aak uvaꞌ kam bꞌan taꞌn itxumbꞌal unqꞌa tenameꞌ, tan ootzimal vitxumbꞌal unqꞌa tenameꞌ taꞌn Aak skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Atik umaꞌl u fariseo uvaꞌ Nicodemo ibꞌii. As naj umaꞌl viqꞌesal unqꞌa tiaal Israel. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","As oon veꞌt naj aqꞌbꞌal xeꞌ u Jesús. As ech bꞌex tal naj ileꞌ: —Chusul, as ootzimal sqaꞌn uvaꞌ aꞌ u Tiixheꞌ kat chajon tzan axh, tan yeꞌxhebꞌil la txꞌolon ibꞌanax unqꞌa kꞌuchbꞌal tetz u tijleꞌm u Tiixheꞌ uveꞌ nabꞌaneꞌ, asoj yeꞌl Aak at skꞌatz,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","As ech tal veꞌt u Jesús ileꞌ: —Jik chit tuk val see, tan abꞌil uvaꞌ yeꞌ la itzꞌebꞌ tikaꞌpa, as yeꞌ la uch tok xoꞌl unqꞌa tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","As ech tal veꞌt u Nicodemo ileꞌ: —¿Kam la tulbꞌe umaj naj qꞌi titzꞌebꞌeꞌ tul qꞌestu veꞌt naj? ¿Ma la uch bꞌa uvaꞌ la ok naj kꞌatz vitxutxeꞌ tiꞌ titzꞌebꞌ unpajte?— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ech tal veꞌt u Jesús ileꞌ: —Jik chit tuk val see, abꞌil uvaꞌ yeꞌxhkam itzꞌebꞌnal kꞌatz u Tiixheꞌ taꞌn u Tiixhla Espíritu as yeꞌxhkam itzꞌebꞌnal taꞌn u aꞌeꞌ, as yeꞌ la uch tok xoꞌl u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","As abꞌil uveꞌ kat itzꞌebꞌ kꞌatz vitxutxeꞌ as vatz txꞌavaꞌilla chiꞌol kuxheꞌ. Pet abꞌil uveꞌ la itzꞌebꞌ taꞌn u Tiixhla Espíritu, as at veꞌt itiichajil kꞌatz u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","As yeꞌ kuxh sotz akꞌuꞌl tiꞌ u yoleꞌ uveꞌ ni val see uvaꞌ techal chit la itzꞌebꞌ ex tikaꞌpa, ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","tan echeꞌ u kajiqꞌeꞌ tan kꞌuxh naabꞌi ivuluneꞌ, as yeꞌ natxꞌol eelataꞌ katiꞌch itzaaeꞌ, as katiꞌch ibꞌeneꞌ. Echat kuxh bꞌanel taꞌn unqꞌa uxhchileꞌ uveꞌ ni titzꞌebꞌ taꞌn u Tiixhla Espíritu,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","As ech tal veꞌt u Nicodemo ileꞌ: —¿La kol chit ibꞌan qꞌa echeꞌ uveꞌ naaleꞌ?— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ech tal veꞌt u Jesús ileꞌ te naj: —Axh umaꞌl u chusul tetz viyol u Tiixheꞌ xoꞌl unqꞌa tenameꞌ. ¿As ma yeꞌ napal bꞌa tu unqꞌa yoleꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ileꞌ jik chit tuk val see tan kam unqꞌa veeꞌ ootzimal sqaꞌn as aꞌeꞌ ni qaleꞌ. As kam uvaꞌ ni qileꞌ as aꞌeꞌ ni qal isuuchil. As kꞌuxh aꞌ visuuchil u yoleꞌ uveꞌ ni val sete, as yeꞌ nenima. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","As kꞌuxh aꞌ unqꞌa vatz txꞌavaꞌilla yoleꞌ uveꞌ ni val sete, as yeꞌ kat enima. ¿As aꞌ kol chit la enima unqꞌa yoleꞌ qꞌa uvaꞌ tetz u Tiixheꞌ uvaꞌ la val sete? ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Tan yeꞌxhebꞌil kat jeꞌ tu almikaꞌ, pet taꞌn kuxh ineꞌ uvaꞌ in IKꞌAOL U NAJEꞌ uvaꞌ kat kuꞌ chꞌuꞌl tu almikaꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","As echat chit la unbꞌaneꞌ echeꞌ uvaꞌ kat ibꞌan u Moisés, tul kat taqꞌ jeꞌ umaꞌl u vatzibꞌal txꞌiꞌlatxoo vatz umaꞌl u tzeꞌ tu u tzuukin txꞌavaꞌeꞌ tiꞌ tel unqꞌa tenameꞌ vatz u kamchileꞌ. As techal la aqꞌpik jeꞌ in vatz umaꞌl u tzeꞌ uvaꞌ in IKꞌAOL U NAJEꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","aqꞌal uvaꞌ at itiichajil u taanxelal unqꞌa uxhchileꞌ kꞌatz u Tiixheꞌ, jankꞌal unqꞌa uxhchileꞌ uveꞌ la ikꞌujbꞌaꞌ ikꞌuꞌl sviꞌ. As yeꞌ la itzꞌej vitiichajileꞌ uveꞌ yeꞌl iyaꞌtebꞌal,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Tan kat itxum u Tiixheꞌ ivatz unqꞌa tenameꞌ skajayil vatz u txꞌavaꞌeꞌ. Estiꞌeꞌ kat taqꞌ tzan Aak unchꞌiꞌtil viKꞌaoleꞌ tiꞌ ikameꞌ, aqꞌal uvaꞌ jankꞌal unqꞌa uxhchileꞌ uvaꞌ la ikꞌujbꞌaꞌ ikꞌuꞌl tiꞌ viKꞌaol Aakeꞌ as yeꞌ la tzꞌejxi. Pet at itiichajil uvaꞌ yeꞌl iyaꞌtebꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","As yeꞌ kat ichaj tzan u Tiixheꞌ viKꞌaoleꞌ vatz u txꞌavaꞌeꞌ tiꞌ uvaꞌ la taqꞌ bꞌen Aak unqꞌa tenameꞌ tu u kꞌaxkꞌoeꞌ. Pet kat ichaj tzan Aak viKꞌaoleꞌ tiꞌ iqꞌalpul unqꞌa tenameꞌ vatz vipaaveꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Estiꞌeꞌ jankꞌal unqꞌa uxhchileꞌ uveꞌ la niman viKꞌaol u Tiixheꞌ as yeꞌl u kꞌaxkꞌoeꞌ at tzan stiꞌ. Pet jankꞌal unqꞌa uxhchileꞌ uvaꞌ yeꞌ ni niman as aꞌeꞌ at veꞌt tzan u kꞌaxkꞌoeꞌ stiꞌ, tan tiꞌ uvaꞌ yeꞌ kat ikꞌujbꞌaꞌ ikꞌuꞌl tiꞌ unchꞌiꞌtil viKꞌaol u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","As kat teesa veꞌt el tibꞌ unqꞌa tenameꞌ kꞌatz u txijun tetz u taanxelaleꞌ tul uvaꞌ kat ul Aak vatz u txꞌavaꞌeꞌ, tan tiꞌ uvaꞌ nisaꞌ unqꞌa tenameꞌ ibꞌanat u vaꞌlexheꞌ. Pet yeꞌ nisaꞌ inimat u txijun tetz u taanxelaleꞌ. Estiꞌeꞌ at veꞌt tzan u kꞌaxkꞌoeꞌ tiꞌ unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","As jankꞌal unqꞌa tenameꞌ uveꞌ aꞌ kuxh u vaꞌlexheꞌ nibꞌaneꞌ as nichiꞌan taama tiꞌ u txijun tetz u taanxelaleꞌ. As ni teesa veꞌt el tibꞌ skꞌatz, tan aꞌ isaꞌ uvaꞌ yeꞌ la majax ivatz tiꞌ ipaavineꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pet ech koj unqꞌa uxhchileꞌ uveꞌ ni bꞌanon u jikeꞌ, tan nijetzꞌen ok kꞌatz u txijun tetz u taanxelaleꞌ, aqꞌal uvaꞌ la tootzi unqꞌa tenameꞌ uvaꞌ aꞌ u Tiixheꞌ aqꞌol tetz vitxumbꞌaleꞌ tiꞌ ibꞌanat u bꞌaꞌneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","As xamtik veꞌt stuul, as el veꞌt u Jesús tu u Jerusalén tukꞌ unqꞌa ichusulibꞌeꞌ. As oon veꞌt Aak tu u Judea uvaꞌ nik taqꞌaxkat kuꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ taꞌn Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","As echat nik ibꞌan u Xhuneꞌ unpajte, tan nik taqꞌ kuꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ tu u tenameꞌ uvaꞌ Enón, najlich u Salim, tan tiꞌ uvaꞌ nim u aꞌeꞌ uvaꞌ atik tzitziꞌ. As yeꞌ saach unqꞌa uxhchileꞌ uli tiꞌ ikuꞌ xeꞌ u aꞌeꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","tan yeꞌxnik oksal u Xhuneꞌ tu u kaarsa. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","As nik iyaa tibꞌ unqꞌa ichusulibꞌ u Xhuneꞌ tukꞌ kaꞌt vimooleꞌ uvaꞌ tiaal Israel, tiꞌ uvaꞌ kam la tulbꞌe unqꞌa uxhchileꞌ teesat el u vaꞌlexheꞌ tu u taanxelaleꞌ vatz u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","As ech bꞌex tal veꞌt unqꞌa ichusulibꞌ u Xhun ileꞌ ste: —Chusul, u najeꞌ uvaꞌ atik sakꞌatz jalit u nimla aꞌeꞌ uvaꞌ Jordán, uvaꞌ yolon axh stiꞌ, as ni taqꞌ kuꞌ naj unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ. As yeꞌ saach tok veꞌt unqꞌa tenameꞌ kꞌatz naj,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ech tal veꞌt u Xhun ileꞌ te chajnaj tiꞌ u Jesús: —Aꞌeꞌ nibꞌaneꞌ uvaꞌ alel tzan ste taꞌn u Tiixheꞌ, tan yeꞌxhkam la uch ibꞌanat umaj uxhchil, asoj jit u Tiixheꞌ tu almikaꞌ kat aqꞌon ste. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","As an chit exeꞌ kat abꞌin vunyoleꞌ uvaꞌ ech kat val ileꞌ: Jit ineꞌ u Cristo, tan Tiixheꞌ kat chajon tzan in bꞌaxa vatz u Cristo,— chꞌin kat val sete, ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","tan ech vatineꞌ vatz u Cristo echeꞌ umaj tetz kꞌultziꞌ u tzumelaeꞌ uvaꞌ at txala, tan aꞌ kuxh u tzumelaeꞌ kꞌujleꞌl tiꞌ u ixqelaeꞌ. Pet ech koj u tetz kꞌultziꞌ u tzumelaeꞌ, tan nichiibꞌeꞌ tul ni tabꞌi u tuul iviꞌeꞌ. As echat chit bꞌan vaꞌn, tan vaꞌl chit unchiibꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","As aal tuk oksaloj veꞌt iqꞌii Aak. Pet ech koj in, tan yeꞌl unqꞌii la oksal veꞌteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Tan aꞌ tzaanajkat Aak tu almikaꞌ. As Aak veꞌteꞌ nim talcheꞌ tiꞌ unqꞌa tenameꞌ skajayil. Pet ech koj in, tan in kuxh vatz txꞌavaꞌil aama, as aꞌ kuxh u vatz txꞌavaꞌil yoleꞌ ni valeꞌ, tan aꞌ kuxh u vatz txꞌavaꞌil txumbꞌaleꞌ eqꞌomal svaꞌn. Pet ech koj u Jesús, tan aꞌ tzaanajkat Aak tu almikaꞌ. As taꞌn Aakeꞌ nim talcheꞌ tiꞌ unqꞌa tenameꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","As aꞌeꞌ ni tal u Jesús kam uveꞌ kat til Aak tukꞌ uveꞌ kat tabꞌi Aak. As kaꞌl kuxh unqꞌa uxhchileꞌ ni niman viyol Aakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pet abꞌil uvaꞌ ni niman u yoleꞌ uvaꞌ ni tal u Jesús, as nikꞌucheꞌ uvaꞌ jik chit u yoleꞌ uveꞌ ni tal u Tiixheꞌ ste,— tiꞌk u Xhuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kat ichaj tzan u Tiixheꞌ u Jesúseꞌ. As tul uvaꞌ niyolon u Jesús, as an chit u Tiixheꞌ niyoloneꞌ. Tan ayaꞌl chit ikꞌuꞌl u Tiixheꞌ kat taqꞌ Aak viTiixhla Espíritu te u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","As xoꞌn chit viKꞌaol u Kubꞌaaleꞌ ste. As kat toksa Aak viKꞌaoleꞌ Bꞌooqꞌolil tiꞌ unqꞌa veeꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Estiꞌeꞌ uvaꞌ abꞌil la ikꞌujbꞌaꞌ ikꞌuꞌl tiꞌ viKꞌaol u Tiixheꞌ as at veꞌt itiichajil uvaꞌ yeꞌl iyaꞌtebꞌal. Pet abꞌil uvaꞌ yeꞌ la niman Aak as yeꞌl veꞌt itiichajil u taanxelaleꞌ kꞌatz u Tiixheꞌ, pet aꞌ veꞌt vitxꞌiꞌtziꞌl u Tiixheꞌ at veꞌt tzan stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","As ootzimalik taꞌn u Jesús uvaꞌ maꞌtik tabꞌit unqꞌa fariseo itzibꞌlal Aak uvaꞌ nimal chit unqꞌa uxhchileꞌ nikat ikuꞌ xeꞌ u aꞌeꞌ taꞌn Aak tiꞌ uveꞌ nik ibꞌan u Xhuneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","As tul jit u Jesús nik aqꞌon kuꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ. Pet aꞌ unqꞌa ichusulibꞌ Aakeꞌ nik bꞌanon. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","As tul tabꞌi u Jesús uvaꞌ maꞌtik tabꞌit unqꞌa fariseo, as el veꞌt chꞌuꞌl u Jesús tu u Judea. As tal veꞌt Aak ibꞌen tu u Galilea unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","As echik ipal Aak tu u Samaria. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","As oon veꞌt Aak tu umaꞌl u tenam uvaꞌ Sicar uvaꞌ echen tu u Samaria. As aꞌ atikkat u txꞌavaꞌeꞌ uveꞌ kat taqꞌ kan u Jacob te vikꞌaol uvaꞌ Xhuꞌl najlich u Sicar. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","As kꞌotik umaꞌl u jul tzitziꞌ uvaꞌ ni teqꞌolkat jeꞌ tzan aꞌ uvaꞌ kꞌotik kan taꞌn u Jacob. As tul chaqꞌaan veꞌt qꞌii, as xonebꞌ veꞌt u Jesús tziꞌ u juleꞌ, tan koolinalik veꞌt Aak taꞌn xaoꞌm. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","As ul umaꞌl u ixoj uvaꞌ aa Samaria tziꞌaꞌvoj tu uveꞌ atikkat u aꞌeꞌ. As ech tal veꞌt u Jesús ileꞌ te ixoj: —Aqꞌ unbꞌooj vaaꞌ uvaꞌ la vukꞌa,— tiꞌk Aak, ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","tan maꞌtik ibꞌen veꞌt unqꞌa ichusulibꞌ Aakeꞌ tu u tenameꞌ tiꞌ iloqꞌat echbꞌubꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","As ech tal veꞌt u ixoj ileꞌ: —¿Kam qꞌi uveꞌ nu kuxh ajaj avaaꞌ sve? As tul axh tiaal Israel. As in aa Samaria,— tiꞌk ixoj te u Jesús, tan yeꞌ nik iqꞌiila tibꞌ unqꞌa tiaal Israel tukꞌ unqꞌa aa Samaria. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","As ech tal veꞌt u Jesús ileꞌ: —Ootzimal koj vibꞌaꞌnil u Tiixheꞌ taꞌ aꞌn, as la pal axheꞌ taꞌ stuul uvaꞌ abꞌiste in uveꞌ ni jajon u aꞌeꞌ see. As lajaj sve. As la vaqꞌeꞌ u aꞌeꞌ see uveꞌ la aqꞌon atiichajil,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","As ech tal veꞌt u ixoj ileꞌ te u Jesús: —Pap, mitaꞌn chit umaj aatinbꞌal ati tiꞌ eeqꞌot jeꞌ tzan u aꞌeꞌ. As tul nim chit tuul u juleꞌ. ¿As kat la eeqꞌokat jeꞌ tzan u aꞌeꞌ qꞌi uveꞌ naaleꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿As nim kol chit aalchu veꞌt qꞌa tiꞌ u kubꞌaal Jacob? Tan aakeꞌ kꞌotol kan tetz u aꞌeꞌ. As tzitzaꞌ nik tul teqꞌokat aak taaꞌ tukꞌ unqꞌa meꞌal ikꞌaoleꞌ. As tzitzaꞌ nik tukꞌaꞌkat unqꞌa tavan aakeꞌ,— tiꞌk ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","As ech tal veꞌt u Jesús ileꞌ: —Jankꞌal unqꞌa uxhchileꞌ uveꞌ la ukꞌan u aꞌeꞌ uvaꞌ at tzitzaꞌ as echeꞌ la koj pal vitzajitziꞌleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pet jankꞌal unqꞌa uxhchileꞌ uveꞌ la ukꞌan u aꞌeꞌ uveꞌ la vaqꞌeꞌ as echeꞌ jatu koj la tzaj veꞌt itziꞌ. As echeꞌ nibꞌan unqꞌa aꞌeꞌ uveꞌ ni tel chꞌuꞌl tu u vitzeꞌ as ech la ibꞌaneꞌ tiꞌ taqꞌax etiichajil uveꞌ yeꞌl iyaꞌtebꞌal,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","As ech tal u ixoj ileꞌ: —Pap, aqꞌ u aꞌeꞌ bꞌa sve uveꞌ naaleꞌ, aqꞌal uvaꞌ yeꞌxh jatu la tzaj veꞌt untziꞌ. As yeꞌl in la ul veꞌt in tziꞌaꞌvoj tzitzaꞌ,— tiꞌk ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ech tal u Jesús ileꞌ: —Bꞌaꞌn kuxheꞌ bꞌa. Kuxh molo vatzumeleꞌ. As eela etuleꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","As ech tal veꞌt ixoj ileꞌ: —Yeꞌl untzumel ati,— tiꞌk ixoj. Ech tal veꞌt u Jesús ileꞌ te ixoj: —An chiteꞌ bꞌa naaleꞌ uvaꞌ yeꞌl atzumel ati, ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","tan oꞌvaꞌx naj ajatx eebꞌ stukꞌ. As u najeꞌ uveꞌ eqꞌomal aꞌn cheel as jit atzumel najeꞌ. An chiteꞌ bꞌa uveꞌ naaleꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","As ech tal veꞌt ixoj ileꞌ: —Pap, texh axh qꞌajsan tetz viyol u Tiixheꞌ ni vabꞌi. As la unchꞌoti see, ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","tan tzitzaꞌ viꞌ u vitzeꞌ nik inachkat unqꞌa qꞌesla kubꞌaaleꞌ u Tiixheꞌ. Pet ech koj ex, tan aꞌ netaleꞌ uvaꞌ tu kuxh u Jerusalén la nachpukat Tiixh,— tiꞌk ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","As ech tal veꞌt u Jesús ileꞌ: —Nima uveꞌ tuk val see, tan la ul umaꞌl u qꞌii uvaꞌ jit kuxh tzꞌajinal viꞌ u vitzeꞌ as jit tzꞌajinal tu u Jerusalén la nachpukat u Tiixheꞌ. Pet katil kuxh la uch inachpukat veꞌt Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Tan nu kuxh enach umaꞌl u tiixh uvaꞌ yeꞌ ootzimal setaꞌn. Pet ech koj oꞌ, tan ootzimal u Tiixheꞌ sqaꞌn uveꞌ nu kunacheꞌ, tan aꞌ xeꞌtikkat tzan u sotzbꞌal paaveꞌ sukuxoꞌl, oꞌ unqꞌa tiaal Israel. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","As u qꞌiieꞌ uvaꞌ ni val see as ileꞌ najli veꞌt cheel tiꞌ uvaꞌ la inach unqꞌa tenameꞌ u Tiixheꞌ tukꞌ chit taanxelal, tan aꞌ isaꞌ Aak uvaꞌ jik chit itxumbꞌal unqꞌa uxhchileꞌ la ibꞌaneꞌ tul la inach Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","As jankꞌal unqꞌa uxhchileꞌ uvaꞌ la nachon Tiixh, as techal chit la inach Tiixh tukꞌ chit taanxelal as tukꞌ tijikil, tan ech u Tiixheꞌ echeꞌ u kajiqꞌeꞌ, tan yeꞌ naꞌl,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","As ech tal veꞌt u ixoj ileꞌ: —Ootzimaleꞌ svaꞌn uvaꞌ la ul umaꞌl u uxhchil uvaꞌ alel kan u tulebꞌaleꞌ taꞌn u Tiixheꞌ uvaꞌ Cristo chꞌelel. As aꞌeꞌ la alon veꞌt isuuchil sqe skajayil tul uvaꞌ la uli,— tiꞌk ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","As ech tal veꞌt u Jesús ileꞌ: —Ineꞌ taꞌ uveꞌ nunyolon see,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","As tul tzojpu iyolon Aak tukꞌ u ixojeꞌ, as bꞌex uloj veꞌt unqꞌa ichusulibꞌ Aakeꞌ. As sotz veꞌt ikꞌuꞌl chajnaj tiꞌ uveꞌ til chajnaj uvaꞌ nik iyolon Aak tukꞌ u ixojeꞌ, tan tiꞌ uvaꞌ yeꞌl umaj chusul la uch iyolon tukꞌ umaj ixoj xoꞌl tenam. As jit ichꞌoti umaj naj te Aak uvaꞌ: —¿Kam nayol tukꞌ u ixojeꞌ?— tiꞌk koj umaj chajnaj tal te Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","As taqꞌ veꞌt kan u ixojeꞌ vitxeꞌneꞌ. As bꞌex tal veꞌt ixoj tu vitenameꞌ. As ech tal veꞌt ixoj ileꞌ te unqꞌa uxhchileꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—¡Siꞌunaj! ¡Ul etiltaj umaꞌl u naj uveꞌ kat alonyu sve tiꞌ unqꞌa veeꞌ bꞌanel svaꞌn skajayil! ¿As ma jit u najeꞌ u Cristo?— tiꞌk ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","As el veꞌt chꞌuꞌl unqꞌa uxhchileꞌ tu vitenameꞌ tiꞌ tul veꞌt kꞌatz Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","As tul maꞌtik ibꞌen veꞌt ixoj, as jetzꞌen veꞌt ok unqꞌa ichusulibꞌ Aakeꞌ skꞌatz. As ech tal veꞌt chajnaj ileꞌ te Aak: —Chusul, txꞌaꞌon,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ech tal veꞌt Aak ileꞌ: —At umaꞌl u vechbꞌubꞌal uveꞌ yeꞌ ootzimal setaꞌn,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","As ech tal veꞌt chajnaj ileꞌ svatzaj: —¿Kam qꞌi estaꞌn? ¿Pet moj abꞌil kat eqꞌon tzan unbꞌooj techbꞌubꞌal Aak?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","As ech tal veꞌt u Jesús ileꞌ: —As aꞌ veꞌt vechbꞌubꞌaleꞌ uvaꞌ la unbꞌaneꞌ kam uveꞌ ni tal taama u chajol vetzeꞌ. As la untzojpisa uvaꞌ kat tal Aak sve. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","As netaleꞌ uvaꞌ: «Kajvaꞌten ichꞌ imakax ivatz u chikoeꞌ,» chꞌex netaleꞌ. As ileꞌ ni val sete, esajitaj bꞌen unqꞌa tenameꞌ, tan ech unqꞌa tenameꞌ echeꞌ unqꞌa chikoeꞌ uveꞌ qꞌantu veꞌteꞌ tiꞌ imakleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","As abꞌil uveꞌ la molon tzan unqꞌa tenameꞌ tiꞌ tok itiichajil uveꞌ yeꞌl iyaꞌtebꞌal as echeꞌ umaꞌl u uxhchil uvaꞌ ni makon ivatz unqꞌa chikoeꞌ, tan la til ivatz u taqꞌoneꞌ. As estiꞌeꞌ uvaꞌ eela ichiibꞌ unqꞌa uxhchileꞌ uvaꞌ ni makoneꞌ tukꞌ unqꞌa uxhchileꞌ uveꞌ kat avan. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","As an chiteꞌ taꞌ u yoleꞌ uvaꞌ: «Umaꞌl uxhchil ni avan. As umaꞌt uxhchil ni makon,» tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","As cheel nunchaj bꞌen ex tiꞌ bꞌen emakat uveꞌ jit ex kat avan, tan vaꞌlen kat aqꞌonvan sevatz. As cheel antu veꞌt ex tuk ilon veꞌt ivatz unqꞌa taqꞌon unqꞌa uxhchileꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","As yeꞌ saach unqꞌa aa Samaria uvaꞌ atik tu u tenam uvaꞌ Sicar, as kat ikꞌujbꞌaꞌ ikꞌuꞌl tiꞌ u Jesús taꞌn u yoleꞌ uveꞌ tal u ixojeꞌ, tan ech maꞌtik talat ixoj ileꞌ: —¡Tan nimal unqꞌa vaꞌlexheꞌ uvaꞌ bꞌanel svaꞌn, as kat tal Aak sve!— tiꞌk ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","As ul ijaj unqꞌa aa Samaria bꞌaꞌnil te u Jesús tiꞌ uvaꞌ la kaa Aak tu u tenameꞌ. As kaꞌvaꞌl qꞌii atin veꞌt Aak xoꞌl unqꞌa aa Samaria. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","As aal chit kat ikꞌujbꞌaꞌ veꞌt unqꞌa uxhchileꞌ ikꞌuꞌl tiꞌ u Jesús tiꞌ unqꞌa yoleꞌ uveꞌ nik tal Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","As ech tal veꞌt unqꞌa uxhchil ileꞌ te u ixoj: —Jit kuxh tiꞌ u yoleꞌ uveꞌ kat aal sqe nu kukꞌujbꞌaꞌkat kukꞌuꞌl. Pet kat qabꞌil veꞌteꞌ, as kat qootzil veꞌteꞌ uvaꞌ an chiteꞌ vil uvaꞌ Aak u sotzsan tetz ipaav unqꞌa tenameꞌ skajayil,— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Tu veꞌt ikaꞌv u qꞌiieꞌ, as el veꞌt chꞌuꞌl u Jesús tu u Samaria. As bꞌen veꞌt Aak tu u Galilea. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","As atik skꞌuꞌl Aak uvaꞌ yeꞌ la oksal iqꞌii Aak taꞌn unqꞌa uxhchileꞌ tu vitenameꞌ, tan maꞌtik talat Aak uvaꞌ yeꞌl umaj qꞌajsan tetz viyol u Tiixheꞌ la oksal iqꞌii tu vitenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","As oon veꞌt Aak tu u Galilea. As jankꞌal unqꞌa aa Galilea uveꞌ maꞌtik tex tu u Jerusalén tiꞌ u nimla qꞌiieꞌ, as oora chit ikꞌul veꞌt ok chajnaj Aak, tan maꞌtik tilat chajnaj kam uveꞌ kat ibꞌan Aak tu u Jerusalén. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","As oon veꞌt u Jesús unpajte tu u tenameꞌ uvaꞌ Caná uvaꞌ echen tu u Galilea, uvaꞌ ibꞌensakat Aak u aꞌeꞌ vinoil. As atik umaꞌl u naj tzitziꞌ uvaꞌ lochol tetz u ijlenaaleꞌ, uvaꞌ nikat ichꞌoꞌn umaꞌl vikꞌaol tu u Capernaúm. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","As tul tabꞌi veꞌt naj itzibꞌlal uvaꞌ maꞌtik itzaa u Jesús tu u Judea as maꞌtik toon veꞌt Aak tu u Galilea, as oon veꞌt naj tiꞌ ijajat kuybꞌal te Aak uvaꞌ la bꞌen Aak tiꞌ ibꞌaꞌnxisal vikꞌaol najeꞌ, tan bꞌiitik kuxh ikam vikꞌaol najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","As ech tal veꞌt u Jesús ileꞌ te naj: —Yeꞌ koj kat unkꞌuch unqꞌa texhlal u tijleꞌm u Tiixheꞌ sete, as kamal yeꞌl ex taꞌ la ekꞌujbꞌaꞌ ekꞌuꞌl sviꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","As ech tal veꞌt u lochol tetz u ijlenaal ileꞌ: —Pap, bꞌan bꞌaꞌnil. Kuxh il vas unkꞌaoleꞌ cheel tan tuk kamoj veꞌteꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","As ech tal veꞌt u Jesús ileꞌ te naj: —Kuxh veꞌteꞌ. Il vakꞌaol ileꞌ isleꞌle,— tiꞌk Aak. As tul tabꞌi veꞌt u najeꞌ viyol Aakeꞌ, as inima veꞌt naj. As bꞌen veꞌt naj tu vitenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","As tul bꞌiitik kuxh toon naj tu vitenameꞌ, as ul kꞌulpoj veꞌt naj tu bꞌey taꞌn kaꞌl unqꞌa ikꞌam. As ech tal chajnaj ileꞌ: —Pap, ¡isleꞌl veꞌt vakꞌaoleꞌ cheel!— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","As ech tal veꞌt u lochol tetz u ijlenaal ileꞌ: —¿Kam oora qꞌi kat bꞌaꞌnxi?— tiꞌk naj. As ech tal veꞌt unqꞌa kꞌam ileꞌ te naj: —Eꞌttzaneꞌ txalqꞌu qꞌii yaꞌ veꞌt u xamaleꞌ tiꞌ naj,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","As tul tabꞌi veꞌt u lochol tetz u ijlenaaleꞌ u yoleꞌ uvaꞌ tal unqꞌa kꞌameꞌ, as ul veꞌt skꞌuꞌl naj uvaꞌ ech ooraeꞌ uvaꞌ tal u Jesús te naj uvaꞌ: «Il vakꞌaol ileꞌ isleꞌle,» tiꞌk Aak. As kat ikꞌujbꞌaꞌ veꞌt naj ikꞌuꞌl tiꞌ Aak tukꞌ unqꞌa tatineꞌ tikabꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","As tu u Galilea ikꞌuchkat u Jesús vikaꞌv u kꞌuchbꞌal tetz u tijleꞌmeꞌ vatz unqꞌa tenameꞌ tul maꞌtik itzaa Aak tu u Judea. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","As xamtik veꞌt stuul tul uvaꞌ ilej umaꞌt u nimla qꞌiieꞌ uveꞌ nikat inima unqꞌa tiaal Israel tu jun yaabꞌ, as bꞌex veꞌt u Jesús tu u Jerusalén unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","As bꞌanik umaꞌl u nimla tzꞌaj tetz molbꞌal aꞌ uvaꞌ Betesda ibꞌii tu yolbꞌal hebreo. As aꞌ echenkat najlich itziꞌ u tapiaaleꞌ uvaꞌ tokebꞌal kaneeroꞌ ibꞌii. As u nimla molbꞌal aꞌeꞌ uveꞌ atik jeꞌ iviꞌ as oꞌvaꞌl toj uvaꞌ tzꞌaj txꞌapike. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","As yeꞌ saach unqꞌa aachꞌoꞌmeꞌ koxhlik tziꞌ u molbꞌal aꞌeꞌ. At koꞌx, at tzot, ati uvaꞌ kꞌoroꞌxhin tibꞌ taꞌn chꞌoꞌm. As nikat itxꞌebꞌ unqꞌa aachꞌoꞌmeꞌ uvaꞌ la tiin veꞌt u aꞌeꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","tan jit kuxh nim la ul itiinsa umaj ángel u aꞌeꞌ. As abꞌiste kuxh u aachꞌoꞌmeꞌ uvaꞌ bꞌaxel la ok xeꞌ u aꞌeꞌ tul la itiinsa tibꞌ u aꞌeꞌ, as la bꞌaꞌnxi, kꞌuxh kam kuxh chꞌoꞌmil uvaꞌ nik bꞌanon. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","As atik umaꞌl u aachꞌoꞌm tziꞌ u nimla molbꞌal aꞌeꞌ uvaꞌ maꞌtik ibꞌanat veꞌt vinaj vaaxajlaval (38) yaabꞌ ixeꞌt chꞌoꞌnoj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","As til veꞌt u Jesús u aachꞌoꞌmeꞌ uvaꞌ koxhlik tziꞌ u aꞌeꞌ. As atik veꞌt skꞌuꞌl Aak uvaꞌ naꞌxnik ixeꞌt naj chꞌoꞌnoj. As ech tal veꞌt Aak ileꞌ: —¿Ma nasaꞌ uvaꞌ la bꞌaꞌnx veꞌt axh?— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ech tal veꞌt naj ileꞌ: —¡Kano, Pap! As yeꞌxhebꞌil ni bꞌanon bꞌaꞌnil sve tiꞌ vaqꞌax bꞌen xeꞌ u aꞌeꞌ. As kꞌuxh nunyaꞌlu vibꞌ tiꞌ unkuꞌeꞌ tul ni tiinsa tibꞌ u aꞌeꞌ, as bꞌaxel nibꞌaxsa tibꞌ umaꞌt uxhchil sunvatz,— tiꞌk u aachꞌoꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","As ech tal veꞌt u Jesús ileꞌ: —Txakpen. Eqꞌo vachꞌachiꞌm tzeꞌeꞌ. As kuxh veꞌt takabꞌal,— tiꞌk Aak tal te naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","As yak chit bꞌaꞌnx veꞌt u aachꞌoꞌmeꞌ. As teqꞌo veꞌt naj u chꞌachiꞌm tzeꞌeꞌ. As xaan veꞌteꞌ. As tu u xeem qꞌiieꞌ ibꞌaꞌnxisa u Jesús u aachꞌoꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","As ech tal veꞌt unqꞌa iqꞌesal unqꞌa tenam ileꞌ te u najeꞌ uvaꞌ maꞌtik tel u chꞌoꞌmeꞌ stiꞌ: —Xeem qꞌii taꞌ cheel. As txaaeꞌ uvaꞌ ijamal kuxh vachꞌachiꞌm tzeꞌeꞌ,— tiꞌk chajnaj te naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","As ech tal veꞌt naj ileꞌ: —U uxhchileꞌ uveꞌ kat bꞌaꞌnxisan in as aꞌeꞌ kat alon sve: «Sikꞌ vachꞌachiꞌm tzeꞌeꞌ. As kuxh veꞌteꞌ,» tiꞌk sve,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","As ichꞌoti veꞌt unqꞌa iqꞌesal unqꞌa tenameꞌ itziꞌ naj. As ech tal chajnaj ileꞌ: —¿Abꞌil u najeꞌ qꞌi uveꞌ kat alon see uvaꞌ: «Sikꞌ vachꞌachiꞌm tzeꞌeꞌ. As kuxh veꞌteꞌ,» taqꞌ kat tal see?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","As yeꞌ tootzaj naj uvaꞌ abꞌil bꞌaꞌnxisan naj, tan maꞌtik tel chꞌuꞌl u Jesús xoꞌl unqꞌa tenameꞌ uveꞌ atik tzitziꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","As xamtik veꞌt stuul, ikꞌul tibꞌ u Jesús tukꞌ u najeꞌ vatz viqꞌanal u tostiixheꞌ. As ech tal veꞌt Aak ileꞌ te naj: —Ileꞌ tuk val see, tan il axh bꞌaꞌn veꞌt axh cheel. As yeꞌ paavin veꞌt axh, aqꞌal uvaꞌ yeꞌ la ul umaꞌtoj kꞌaxkꞌo seeꞌ uvaꞌ nim tiꞌ unqꞌa veeꞌ kat apalebꞌe,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","As bꞌex tal veꞌt naj te unqꞌa iqꞌesal unqꞌa tenameꞌ uveꞌ aꞌ u Jesús kat bꞌaꞌnxisan naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Estiꞌeꞌ uveꞌ ibꞌan veꞌt unqꞌa iqꞌesal unqꞌa tenameꞌ ikꞌuꞌl tiꞌ ichukat txumbꞌal tiꞌ u Jesús, tan tiꞌ uvaꞌ ibꞌaꞌnxisa Aak u aachꞌoꞌmeꞌ tu u xeem qꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","As ech tal veꞌt u Jesús ileꞌ te chajnaj: —As kꞌuxh tu u xeem qꞌiieꞌ, yeꞌ niyaꞌ vunBꞌaaleꞌ tiꞌ ibꞌanat u bꞌaꞌnileꞌ. Estiꞌeꞌ nunbꞌan u bꞌaꞌneꞌ tu u xeem qꞌiieꞌ unpajte,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","As tabꞌi veꞌt unqꞌa iqꞌesal unqꞌa tenameꞌ u yoleꞌ uvaꞌ tal u Jesús. As aal chit ichuk veꞌt chajnaj txumbꞌal tiꞌ iyatzꞌax Aak. As jit kuxh tiꞌ uvaꞌ maꞌtik ibꞌaꞌnxisat Aak u aachꞌoꞌmeꞌ tu u xeem qꞌiieꞌ. Pet tiꞌ uvaꞌ «VunBꞌaaleꞌ,» tiꞌk Aak tiꞌ u Tiixheꞌ. As nik tal tibꞌ Aak uvaꞌ eela Aak tukꞌ u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","As ech tal veꞌt u Jesús ileꞌ te chajnaj: —Ileꞌ jik chit tuk val sete tan yeꞌxhkam la uch unbꞌanataꞌ sunjunal. Pet aꞌ nunbꞌaneꞌ uveꞌ ni vileꞌ uvaꞌ nibꞌan vunBꞌaaleꞌ. As jankꞌal uveꞌ nibꞌan vunBꞌaaleꞌ as echat nunbꞌaneꞌ unpajte, ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","tan xoꞌn chit in te vunBꞌaaleꞌ. As nikꞌuch Aak sve jankꞌal uveꞌ nibꞌan Aak, tan nim chiteꞌ u bꞌaꞌnileꞌ uveꞌ la ikꞌuch Aak sve tiꞌ unqꞌa viꞌlaꞌ. Estiꞌeꞌ la chit teqꞌo etaama tiꞌ uveꞌ la etileꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","tan echat la unbꞌaneꞌ echeꞌ uvaꞌ nibꞌan vunBꞌaaleꞌ. As ni tulsa Aak taama unqꞌa kamnajeꞌ. As ni taqꞌ Aak itiichajil u taanxelal unqꞌa uxhchileꞌ. As echat in unpajte, tan la vaqꞌ itiichajil u taanxelal unqꞌa uxhchileꞌ kꞌatz Aak, as jankꞌal unqꞌa uxhchileꞌ uvaꞌ la unsaꞌ la vaqꞌ itiichajil. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","As yeꞌxhebꞌil nibꞌan vunBꞌaaleꞌ isuuchil. Pet kat ikꞌujbꞌaꞌ veꞌt in Aak tiꞌ uvaꞌ in la bꞌanon veꞌt isuuchil unqꞌa tenameꞌ skajayil, ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","aqꞌal uvaꞌ la toksa unqꞌa tenameꞌ unqꞌii echeꞌ toksat iqꞌii vunBꞌaaleꞌ. Tan abꞌil uvaꞌ yeꞌ ni oksan unqꞌii as yeꞌl iqꞌii vunBꞌaaleꞌ ni toksa unpajte, as tul Aakeꞌ chajol tzan vetz. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","As ileꞌ jik chit tuk val sete, u uxhchileꞌ uveꞌ la niman unqꞌa yoleꞌ uvaꞌ ni valeꞌ as la ikꞌujbꞌaꞌ ikꞌuꞌl tiꞌ u Tiixheꞌ uvaꞌ chajol tzan vetz, tan at chit itiichajil u taanxelaleꞌ uveꞌ yeꞌl iyaꞌtebꞌal. As yeꞌl u kꞌaxkꞌo at veꞌt tzan tiꞌ unqꞌa uxhchileꞌ, tan elnallu veꞌt vatz u kamchileꞌ. As at veꞌt itiichajil uvaꞌ yeꞌl iyaꞌtebꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tan tuk chit val sete tan tuk ilej u qꞌiieꞌ uvaꞌ kꞌujleꞌl veꞌt taꞌn u Tiixheꞌ, as ileꞌ at veꞌt scheel. As unqꞌa uxhchileꞌ uveꞌ kamnajlu veꞌt u taanxelaleꞌ vatz u Tiixheꞌ as tuk chit tabꞌi u tuul unviꞌeꞌ, tan ineꞌ viKꞌaol u Tiixheꞌ. As abꞌil uvaꞌ la niman unqꞌa yoleꞌ uvaꞌ ni valeꞌ as aꞌeꞌ la isebꞌ u taanxelaleꞌ kꞌatz u Tiixheꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","tan echeꞌ taꞌ vunBꞌaaleꞌ tan at itiichajil Aak sijunal. As echat chit in, tan kat taqꞌ Aak sve uvaꞌ at untiichajil sunjunal, tan in viKꞌaol Aakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","As kat taqꞌ veꞌt Aak u vijleꞌmeꞌ tiꞌ unbꞌanat isuuchil unqꞌa tenameꞌ skajayil, tan ineꞌ IKꞌAOL U NAJEꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","As yeꞌ la sotz ekꞌuꞌl tiꞌ uvaꞌ ni val sete, tan tuk ilej umaꞌl u qꞌii uvaꞌ jankꞌal chit unqꞌa kamnajeꞌ uvaꞌ mujel tu u juleꞌ as la tabꞌi u tuul unviꞌeꞌ tul la unmolo. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","As jankꞌal unqꞌa uxhchileꞌ uvaꞌ bꞌaꞌn kat ibꞌana vatz u txꞌavaꞌeꞌ as la jeꞌ veꞌt chꞌuꞌl tu unqꞌa ijuleꞌ tiꞌ tul taama unpajte. As ech ibꞌen kꞌatz u Tiixheꞌ, tan at itiichajil u taanxelaleꞌ kꞌatz Aak. Pet ech koj unqꞌa uxhchileꞌ uveꞌ kat bꞌanon u vaꞌlexheꞌ vatz u txꞌavaꞌeꞌ, tan tul la ul taama, as aꞌ la bꞌenkat tu u choobꞌal paaveꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","As yeꞌxhkam la uch unbꞌanat isuuchil sunjunal. Pet kam uveꞌ ni tal vunBꞌaaleꞌ sve tiꞌ unbꞌanat isuuchil unqꞌa tenameꞌ skajayil as aꞌeꞌ nunbꞌaneꞌ. As jik chiteꞌ ni val isuuchil, tan jit vuntxumbꞌaleꞌ ni voksa. Pet aꞌ vitxumbꞌal vunBꞌaaleꞌ eqꞌomal svaꞌn uvaꞌ chajol tzan vetz, ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","tan asoj an kuxh in la alon u vijleꞌmeꞌ, as echeꞌ la koj nimal in. As la koj alaxi uvaꞌ jik chit vunyoleꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","pet Aakeꞌ ni alon u vijleꞌmeꞌ. As ootzimal svaꞌn uvaꞌ kam chit uveꞌ ni tal Aak sviꞌ as an chiteꞌ viyol Aakeꞌ uveꞌ ni taleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","As exeꞌ kat chajon bꞌen kaꞌl unqꞌa uxhchil tiꞌ ichꞌotil itziꞌ u Xhuneꞌ. As kam chit uveꞌ kat tal tzan u Xhuneꞌ sete as jik chiteꞌ uveꞌ kat tal tzan sviꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","As jit iyol umaj uxhchil kꞌujbꞌaꞌn tetz u vijleꞌmeꞌ. Pet ni val isuuchil u yoleꞌ sexoꞌl, aqꞌal uvaꞌ at veꞌt sotzbꞌal epaav. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Tan ech u Xhuneꞌ echeꞌ umaꞌl u xamal uvaꞌ kat txijun ex. As kat chiibꞌ ex tiꞌ viyol u Xhuneꞌ. As yeꞌxh jankꞌal qꞌii kat chiibꞌ veꞌt ex stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pet an chit unqꞌa bꞌaꞌnileꞌ uvaꞌ nunbꞌaneꞌ as aꞌeꞌ ni kꞌuchun u vijleꞌmeꞌ, tan nim chit talcheꞌ unqꞌa bꞌaꞌnileꞌ uvaꞌ nunbꞌaneꞌ tiꞌ unqꞌa yoleꞌ uvaꞌ kat tal u Xhuneꞌ sviꞌ, tan aꞌ u bꞌaꞌnileꞌ uveꞌ kat taqꞌ vunBꞌaaleꞌ sve tiꞌ uvaꞌ techal la unbꞌaneꞌ, as aꞌeꞌ la kꞌuchun u vijleꞌmeꞌ uvaꞌ aꞌ vunBꞌaaleꞌ kat chajon tzan in. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","As vunBꞌaaleꞌ uveꞌ chajol tzan vetz as Aakeꞌ ni alon isuuchil u vijleꞌmeꞌ unpajte. Yeꞌ atixoj etabꞌi tuul iviꞌ Aak. As mitaꞌn ikaꞌy Aak kat etila. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Pet yeꞌl viyol Aakeꞌ at koj tu vetaanxelaleꞌ, as yeꞌ nekꞌujbꞌaꞌ ekꞌuꞌl sviꞌ uvaꞌ kat ichaj tzan in Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","As tul bꞌenameen chit nechus etibꞌ tiꞌ viyol Aakeꞌ uvaꞌ tzꞌibꞌamal kan, tan aꞌ netaleꞌ uvaꞌ at itiichajil uvaꞌ yeꞌl iyaꞌtebꞌal, tan tiꞌ uvaꞌ chusel etibꞌ. As tul aꞌeꞌ ni alon isuuchil u vijleꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","As yeꞌ nesaꞌ etoksat etibꞌ sunkꞌatz. As tul ineꞌ la aqꞌon itiichajil uvaꞌ yeꞌl iyaꞌtebꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","As yeꞌ la voksa stuul kꞌuxh la etoksa unqꞌii, ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","tan ootzimal ex svaꞌn uvaꞌ yeꞌl u Tiixheꞌ xoꞌn koj sete tukꞌ etaanxelal. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","As kꞌuxh tukꞌ vibꞌii vunBꞌaaleꞌ kat ulkat in, as yeꞌ kat ekꞌul in. Pet asoj la ul umaꞌtoj naj tukꞌ kuxh itxumbꞌal, as oora chit la txuqꞌtxun ex tiꞌ ekꞌulat naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","As nu kuxh etoksa jeꞌ eqꞌii sevatzaj. Pet yeꞌ nebꞌaneꞌ kam uvaꞌ nisaꞌ u Tiixheꞌ setiꞌ tiꞌ uvaꞌ la toksa Aak eqꞌii. As tul taꞌn Aakeꞌ Tiixh. As mitaꞌn in nekꞌujbꞌaꞌ ekꞌuꞌl sviꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Pet etalaki uvaꞌ in la alon ok vepaaveꞌ te vunBꞌaaleꞌ, tan aꞌ unqꞌa yoleꞌ uveꞌ tzꞌibꞌamal kan taꞌn u Moisés tuk alon ok vepaaveꞌ, kꞌuxh netal jeꞌ sete uvaꞌ at kꞌujlebꞌal ekꞌuꞌl tiꞌ uvaꞌ tzꞌibꞌamal kan taꞌn u Moisés. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","As kat koj enima unqꞌa yoleꞌ uveꞌ kat tal u Moisés, as ineꞌ taꞌ kat enima in, tan ineꞌ uvaꞌ ni tal u yoleꞌ uveꞌ tzꞌibꞌamal kan taꞌn u Moisés. ");
INSERT INTO ixlNNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Tan asoj yeꞌ nenima unqꞌa yoleꞌ uveꞌ tzꞌibꞌamal kan taꞌn u Moisés, ¿as aꞌ kol chit veꞌt unqꞌa veeꞌ qꞌa la enima uveꞌ ni val sete cheel?— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","As xamtik veꞌt stuul, as el veꞌt chꞌuꞌl Aak tu u Jerusalén. As bꞌen veꞌt Aak tu u Galilea, ok veꞌt Aak tu umaꞌl u barco. As qꞌax veꞌt Aak jalit u mar uveꞌ echen tu u Galilea uvaꞌ Tiberias ibꞌii. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","As aꞌ chit mamaꞌla tenameꞌ xekik tiꞌ Aak, tan tiꞌ uvaꞌ maꞌtik tilat unqꞌa tenameꞌ u kꞌuchbꞌal tetz vibꞌaꞌnil Aakeꞌ uveꞌ ibꞌan tiꞌ unqꞌa aachꞌoꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","As jeꞌ veꞌt Aak viꞌ umaꞌl u tal vitz. As xonebꞌ veꞌt Aak tukꞌ unqꞌa ichusulibꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","As txantik kuxh tul veꞌt u nimla qꞌiieꞌ uvaꞌ pascua uvaꞌ nik inima unqꞌa tiaal Israel jun yaabꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Tul til veꞌt Aak uvaꞌ mamaꞌla tenam xekelik tiꞌ Aak, as ech tal veꞌt Aak ileꞌ: —¿Tikat la bꞌen kuloqꞌkat paan tiꞌ kutxꞌaꞌnsat unqꞌa tenameꞌ?— tiꞌk Aak tal te u Piꞌleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","As tal kuxh Aak te u Piꞌleꞌ, tan ootzimalik taꞌn Aak uvaꞌ kam la ibꞌan Aak. Pet aꞌ isaꞌ Aak uvaꞌ kam la tal u Piꞌleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","As ech tal veꞌt u Piꞌl ileꞌ te u Jesús: —Yeꞌ la tzꞌaj ijaꞌmil laval kꞌalal (200) qꞌii aqꞌon tiꞌ qaqꞌat unbꞌooj techbꞌubꞌal unqꞌa tenameꞌ,— tiꞌk u Piꞌleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Pet umaꞌt u chusulibꞌ uvaꞌ Lixh, titzꞌin u Simón uveꞌ Luꞌ, as ech tal naj ileꞌ te Aak: ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Il umaꞌl u xaak ilaꞌ uvaꞌ eqꞌomal oꞌvaꞌl paan staꞌn uvaꞌ cebada tukꞌ kaꞌvaꞌt tal txay. As echeꞌ la koj tzꞌaj xoꞌl unqꞌa tenameꞌ,— tiꞌk u Lixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","As ech tal veꞌt u Jesús ileꞌ te unqꞌa ichusulibꞌeꞌ: —Etaltaj te unqꞌa tenameꞌ uvaꞌ la xonebꞌ skajayil,— tiꞌk Aak, tan echenik unqꞌa tenameꞌ vatz umaꞌl u nimla chaqꞌaala. As xonebꞌ veꞌt unqꞌa tenameꞌ skajayil. As kamal oꞌvaꞌl mil unqꞌa najeꞌ atike. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","As itxey veꞌt u Jesús oꞌvaꞌl u paaneꞌ uvaꞌ atik xeꞌ u xaakeꞌ. As tul maꞌtik taqꞌat veꞌt Aak taꞌntiixh te u Tiixheꞌ stiꞌ, as ijatx veꞌt Aak, as taqꞌ veꞌt Aak te unqꞌa ichusulibꞌeꞌ. As echat chit ibꞌan Aak tukꞌ unqꞌa txayeꞌ. As aqꞌax veꞌt te unqꞌa tenameꞌ uvaꞌ xonlik vatz u chaqꞌaalaeꞌ, jankꞌal uvaꞌ nik isaꞌ unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","As tul maꞌtik itxꞌaꞌn unqꞌa tenameꞌ sbꞌaꞌn, as ech tal veꞌt Aak ileꞌ te unqꞌa ichusulibꞌeꞌ: —Emoltaj unqꞌa yaꞌl paaneꞌ. As yeꞌxhkam la etxaqꞌu kan,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","As imol veꞌt chajnaj unqꞌa yaꞌl paaneꞌ. As inoosa veꞌt chajnaj kabꞌlavat xuꞌk u yaꞌl paaneꞌ taꞌn oꞌvaꞌl unqꞌa paaneꞌ uvaꞌ atik cebada xoꞌl uveꞌ ijatx u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","As til unqꞌa tenameꞌ u kꞌuchbꞌal tetz vibꞌaꞌnil u Tiixheꞌ uveꞌ ikꞌuch u Jesús. As ech tal veꞌt unqꞌa tenam ileꞌ svatzaj: —An chiteꞌ vil. Kat ulyu veꞌt u qꞌajsan tetz viyol u Tiixheꞌ uvaꞌ alel kan u tulebꞌaleꞌ taꞌn u Moisés,— tiꞌk unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","As naꞌlik vatz u Jesús uvaꞌ nikat tal veꞌt unqꞌa tenameꞌ toksal Aak ijlenaalil. As bꞌen veꞌt Aak viꞌ u tal vitzeꞌ sijunal unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","As tul tzꞌotin veꞌteꞌ, as kuꞌ veꞌt chꞌuꞌl unqꞌa ichusulibꞌ Aakeꞌ viꞌ u tal vitzeꞌ tiꞌ toon tziꞌ u mar. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","As kꞌuxh maꞌtik itzꞌotin veꞌteꞌ, as yeꞌxnik ul u Jesús kꞌatz chajnaj. As ok veꞌt chajnaj tu umaꞌl u barco. As bꞌen veꞌt chajnaj viꞌ u mar tiꞌ ibꞌen tu u Capernaúm. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","As xeꞌt veꞌt umaꞌl u kajiqꞌ viꞌ u mar uvaꞌ xoꞌvebꞌal chittuꞌ. Vaꞌlik chit ipilqꞌut veꞌt tibꞌ u aꞌeꞌ taꞌn u kajiqꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kamal pal tiꞌ umaꞌl iꞌl maꞌtik ixaat ok chajnaj viꞌ u aꞌeꞌ. As aat kuxh til veꞌt chajnaj u Jesús uvaꞌ nikat ixaan veꞌt Aak viꞌ u mar. As bꞌiitik kuxh tul veꞌt Aak kꞌatz u barco. As xoꞌv veꞌt chajnaj taꞌn Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","As ech tal veꞌt Aak ileꞌ: —Yeꞌ kuxh xoꞌv ex, tan ineꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","As ayaꞌl chit ikꞌuꞌl chajnaj ikꞌul veꞌt jeꞌ chajnaj Aak tu u barco. As aat kuxh til veꞌt chajnaj toon tukꞌ u barco tziꞌ u txꞌavaꞌeꞌ tu uveꞌ yakikkat chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ech veꞌt qꞌejal stuul, as sotz veꞌt ikꞌuꞌl unqꞌa uxhchileꞌ uveꞌ kaaik kan jalit u mar tiꞌ uvaꞌ kam kat ibꞌan u Jesús tiꞌ toon jalit u mar, tan ootzimalik taꞌn unqꞌa uxhchileꞌ uvaꞌ umaꞌl kuxh u barco maꞌtik ibꞌen viꞌ u aꞌeꞌ. As jit bꞌen veꞌt u Jesús tu u barco. Pet aꞌ kuxh unqꞌa ichusulibꞌ Aakeꞌ bꞌeni. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","As maꞌtik tul veꞌt unjoltu unqꞌa uxhchil tukꞌ kaꞌt unqꞌa barco uvaꞌ tzaa tu u Tiberias tiꞌ ichukat u Jesús. As aꞌ ulkat unqꞌa barco tziꞌ u aꞌeꞌ najlich uveꞌ maꞌtik inachatkat u Jesús Tiixh tiꞌ u paaneꞌ, tul aꞌs itzujbꞌet Aak oꞌvaꞌl mil unqꞌa najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","As tul til veꞌt unqꞌa uxhchileꞌ uvaꞌ yeꞌlik u Jesús as mitaꞌn unqꞌa ichusulibꞌ Aakeꞌ atike, as ok veꞌt unqꞌa uxhchileꞌ unpajte tu unqꞌa barco. As bꞌen veꞌt tu u Capernaúm tiꞌ ichukat u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","As tul ilej veꞌt unqꞌa tenameꞌ u Jesús jalit u mar, as ech tal veꞌt unqꞌa tenam ileꞌ: —¿Chusul, jatu tzan qꞌi ul axh tzitzaꞌ?— tiꞌk unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ech tal veꞌt Aak ileꞌ: —Ileꞌ jik chit tuk val sete, tan nechuk in. As jit tiꞌ uvaꞌ kat etil unqꞌa kꞌuchbꞌal tetz vibꞌaꞌnil u Tiixheꞌ uveꞌ kat unbꞌana. Pet tiꞌ kuxh uvaꞌ kat etxꞌaꞌ u paaneꞌ as kat noo veꞌt ex sbꞌaꞌn. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","As jit kuxh tiꞌ u echbꞌubꞌaleꞌ la etoksakat etaama uveꞌ nimotxeꞌ. Pet aꞌ la etoksakat etaama tiꞌ u echbꞌubꞌaleꞌ uveꞌ yeꞌ la motxi uveꞌ la aqꞌon etiichajil uveꞌ yeꞌl iyaꞌtebꞌal, tan ineꞌ la aqꞌon sete, uvaꞌ in IKꞌAOL U NAJEꞌ, tan nichiibꞌ u Kubꞌaal Tiixheꞌ sviꞌ tiꞌ vaqꞌat sete,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","As ech tal veꞌt unqꞌa tenam ileꞌ te u Jesús: —¿Kam la kubꞌaneꞌ qꞌi tiꞌ kubꞌanat uveꞌ nisaꞌ u Tiixheꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ech tal veꞌt u Jesús ileꞌ: —Aꞌ nisaꞌ u Tiixheꞌ setiꞌ uvaꞌ la enima in, tan ineꞌ kat ichaj tzan in Aak sexoꞌl,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","As ech tal veꞌt unqꞌa tenam ileꞌ: —¿Kam umaj kꞌuchbꞌal tetz u tijleꞌm u Tiixheꞌ la akꞌuch sukuvatz tiꞌ uvaꞌ la kunima veꞌt axh? ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","As echeꞌ unqꞌa qꞌesla kubꞌaaleꞌ tan kat techbꞌu chajaak u maná tu u tzuukin txꞌavaꞌeꞌ, echeꞌ uvaꞌ ni tal umaꞌl u yol uvaꞌ tzꞌibꞌamal kan, tan ech ni tal ileꞌ: As taqꞌ veꞌt kuꞌ tzan u Tiixheꞌ u echbꞌubꞌaleꞌ tu almikaꞌ, aqꞌal uvaꞌ la techbꞌu unqꞌa tenameꞌ, tiꞌk u yoleꞌ,— tiꞌk chajnaj tal te u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","As ech tal veꞌt u Jesús ileꞌ: —Jik chit tuk val sete, tan jit u Moisés kat aqꞌon u echbꞌubꞌaleꞌ uvaꞌ kat kuꞌ chꞌuꞌl tu almikaꞌ te unqꞌa tenameꞌ. Pet vunBꞌaaleꞌ uvaꞌ kat aqꞌon kuꞌ tzan u echbꞌubꞌaleꞌ naꞌytzan, as an chit Aakeꞌ ni aqꞌon kuꞌ tzan u bꞌaꞌnla echbꞌubꞌaleꞌ cheel, uvaꞌ yeꞌxhkam umaꞌtoj la lejon stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","As u echbꞌubꞌaleꞌ uveꞌ ni taqꞌ Aak cheel, as aꞌeꞌ uvaꞌ ni val sete uvaꞌ kat kuꞌ chꞌuꞌl tu almikaꞌ. As ni taqꞌ itiichajil unqꞌa tenameꞌ vatz u txꞌavaꞌeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","As ech tal veꞌt unqꞌa tenam ileꞌ: —Pap, aqꞌ u echbꞌubꞌaleꞌ sqe bꞌenameen, uveꞌ naaleꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","As ech tal veꞌt u Jesús ileꞌ: —Ineꞌ uvaꞌ ech vatineꞌ echeꞌ u echbꞌubꞌaleꞌ uveꞌ ni aqꞌon itiichajil unqꞌa uxhchileꞌ cheel. As abꞌil uvaꞌ la toksa tibꞌ sunkꞌatz, as yeꞌxh jatu la vaꞌyi; as abꞌil uvaꞌ la ikꞌujbꞌaꞌ ikꞌuꞌl sviꞌ, as yeꞌxh jatueꞌ la tzaj veꞌt itziꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pet kat vallu sete uvaꞌ kꞌuxh kat etil in, as yeꞌ nekꞌujbꞌaꞌ ekꞌuꞌl sviꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","As jankꞌal chit unqꞌa uxhchileꞌ uveꞌ ni taqꞌ vunBꞌaaleꞌ sve, as la toksa tibꞌ sunkꞌatz. As abꞌil uvaꞌ la toksa tibꞌ sunkꞌatz, as yeꞌ la uch vixvataꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","As la val sete, tan yeꞌl in kat koj kuꞌ chꞌuꞌl in tu almikaꞌ tiꞌ unbꞌanataꞌ kam uvaꞌ ni tal vaama. Pet aꞌ tul unbꞌaneꞌ kam uveꞌ ni tal u chajol tzan vetzeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","As aꞌ ni tal u chajol tzan vetzeꞌ uvaꞌ yeꞌxhebꞌil la untzꞌej kan. Pet jankꞌal uveꞌ kat taqꞌ Aak sve, as la vulsa taama timoxtel qꞌii. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","As aꞌ ni tal u chajol vetzeꞌ uvaꞌ at itiichajil unqꞌa uxhchileꞌ uveꞌ yeꞌl iyaꞌtebꞌal, jankꞌal uvaꞌ ni ootzin u vijleꞌmeꞌ as nikꞌujbꞌaꞌ ikꞌuꞌl sviꞌ. As la vulsa taama timoxtel qꞌii, in uvaꞌ in viKꞌaol u Tiixheꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","As yan veꞌt viyol u Jesús tiviꞌ unqꞌa iqꞌesal unqꞌa tenameꞌ tiꞌ uvaꞌ tal Aak uvaꞌ: —Ech vatineꞌ echeꞌ u echbꞌubꞌaleꞌ uveꞌ kat kuꞌ chꞌuꞌl tu almikaꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","As ech tal veꞌt chajnaj ileꞌ svatzaj: —¿As jit kol ikꞌaol u Xhuꞌleꞌ qꞌa u Jesús? Tan ootzimaleꞌ vibꞌaal najeꞌ tukꞌ vitxutx najeꞌ sqaꞌn. ¿As kam qꞌi uveꞌ ni tal naj uvaꞌ, «Ineꞌ kat kuꞌ chꞌuꞌl in tu almikaꞌ,» taqꞌ naj ni taleꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","As ech tal veꞌt u Jesús ileꞌ te chajnaj: —Yeꞌ kuxh eyol in sevatzaj, ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","tan yeꞌxhebꞌil la toksa tibꞌ sunkꞌatz, asoj jit vunBꞌaaleꞌ la alon, uvaꞌ kat chajon tzan in. Pet jankꞌal unqꞌa uxhchileꞌ uvaꞌ la toksa tibꞌ sunkꞌatz, as ineꞌ la ulsan taama timoxtel qꞌii, ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","tan ech la ibꞌaneꞌ uvaꞌ tzꞌibꞌamal kan taꞌn unqꞌa qꞌajsan tetz viyol u Tiixheꞌ uvaꞌ ech ni tal ileꞌ: La chee itxumbꞌal unqꞌa tenameꞌ taꞌn u Tiixheꞌ, tiꞌk u yoleꞌ. Estiꞌeꞌ ni val sete uvaꞌ jankꞌal unqꞌa uxhchileꞌ uveꞌ ni abꞌin viyol vunBꞌaaleꞌ as nichee itxumbꞌal staꞌn, as aꞌeꞌ uvaꞌ ni toksa tibꞌ sunkꞌatz. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","As yeꞌxhebꞌil kat ilon vunBꞌaaleꞌ. Pet ineꞌ kat ilon Aak, uvaꞌ kꞌatz Aak tzaanajkat in. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","As jik chit tuk val sete, tan abꞌil uveꞌ nikꞌujbꞌaꞌ ikꞌuꞌl sviꞌ, as at itiichajil uveꞌ yeꞌl iyaꞌtebꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","As ech vatineꞌ echeꞌ u echbꞌubꞌaleꞌ uvaꞌ ni aqꞌon itiichajil unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","As kat techbꞌu unqꞌa qꞌesla kubꞌaaleꞌ u maná tu u tzuukin txꞌavaꞌeꞌ. As kat kami. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pet il in at in cheel, uvaꞌ ech vatineꞌ echeꞌ u echbꞌubꞌaleꞌ uvaꞌ kat kuꞌ chꞌuꞌl tu almikaꞌ, aqꞌal uvaꞌ yeꞌxh jatu la kam unqꞌa uxhchileꞌ jankꞌal uvaꞌ la echbꞌun. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","As in uvaꞌ kat kuꞌ chꞌuꞌl in tu almikaꞌ, as ech ineꞌ echeꞌ u echbꞌubꞌaleꞌ uvaꞌ ni aqꞌon itiichajil unqꞌa uxhchileꞌ. As abꞌil uvaꞌ la echbꞌun u echbꞌubꞌaleꞌ, as at itiichajil uveꞌ yeꞌl iyaꞌtebꞌal. As u echbꞌubꞌaleꞌ uveꞌ la vaqꞌeꞌ, as aꞌ vunchiꞌoleꞌ uvaꞌ la vaqꞌ kamoj tiꞌ unqꞌa tenameꞌ, aqꞌal uvaꞌ at itiichajil uveꞌ yeꞌl iyaꞌtebꞌal,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","As iyaa veꞌt tibꞌ unqꞌa iqꞌesal unqꞌa tenameꞌ svatzaj. Ech tal veꞌt chajnaj ileꞌ: —¿Kam la tulbꞌe u najeꞌ qꞌi taqꞌat vichiꞌoleꞌ sqe tiꞌ qechbꞌutaꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","As ech tal veꞌt u Jesús ileꞌ te chajnaj tiꞌ talat Aak isuuchil vikamebꞌaleꞌ: —Jik chit tuk val sete, in uvaꞌ IKꞌAOL U NAJEꞌ. Tan asoj yeꞌ la etechbꞌu vunchiꞌoleꞌ, asoj yeꞌ la etukꞌa vunkajaleꞌ, as yeꞌl etiichajil ati. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","As abꞌil uveꞌ la echbꞌun vunchiꞌoleꞌ as la tukꞌa vunkajaleꞌ, as at itiichajil uveꞌ yeꞌl iyaꞌtebꞌal. As la vulsa taama timoxtel qꞌii. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","As aꞌ vunchiꞌoleꞌ u echbꞌubꞌaleꞌ uvaꞌ yeꞌxhkam umaꞌtoj la lejon stiꞌ; as aꞌ vunkajaleꞌ u ukꞌaꞌeꞌ uvaꞌ yeꞌxhkam umaꞌtoj la lejon stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","As abꞌil uveꞌ la echbꞌun vunchiꞌoleꞌ as la tukꞌa vunkajaleꞌ, as la toksa taama sviꞌ. As la voksa vaama stiꞌ unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","As aꞌ vunBꞌaaleꞌ, u aqꞌol tetz tiichajil, as Aakeꞌ uvaꞌ kat chajon tzan in. As at itiichajil Aak, estiꞌeꞌ at untiichajil. As echat chit la ibꞌan u uxhchileꞌ uvaꞌ ech vatineꞌ svatz echeꞌ u techbꞌubꞌaleꞌ, tan tukꞌ vuntiichajileꞌ at veꞌt itiichajil sunkꞌatz. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","As ech vatineꞌ echeꞌ u echbꞌubꞌaleꞌ uvaꞌ kat kuꞌ chꞌuꞌl tu almikaꞌ. As jit ech ineꞌ u maná uveꞌ kat techbꞌu unqꞌa qꞌesla kubꞌaaleꞌ tu u tzuukin txꞌavaꞌeꞌ, tan kꞌuxh kat techbꞌu, as kat kami. Pet abꞌil uveꞌ la echbꞌun u echbꞌubꞌaleꞌ uveꞌ ni valeꞌ, as at itiichajil sunkꞌatz uveꞌ yeꞌl iyaꞌtebꞌal,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","As aꞌ unqꞌa yoleꞌ uvaꞌ kat ichus kan u Jesús te unqꞌa uxhchileꞌ tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh tu u Capernaúm. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","As tul tabꞌi veꞌt unqꞌa ichusulibꞌ Aakeꞌ unqꞌa yoleꞌ uvaꞌ tal Aak, as nimal chajnaj alon veꞌt svatzaj: —¡Tiꞌ tabꞌil u yoleꞌ uveꞌ ni tal Aak! ¡Abꞌil koj la niman!— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","As ootzimal taꞌn u Jesús uvaꞌ kat yan u yoleꞌ tiviꞌ chajnaj. As ech tal veꞌt Aak ileꞌ te chajnaj: —¿Ma kat iyansa ex u yoleꞌ uveꞌ kat val sete? ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Pet la pal ex stuul tul la etil ijeꞌ VIKꞌAOL U NAJEꞌ tu almikaꞌ uveꞌ atikkat sbꞌaxa. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","As aꞌ u Tiixhla Espíritu aqꞌol tetz u tiichajileꞌ. As yeꞌl umaj uxhchil la olebꞌ tiꞌ taqꞌat etiichajil. Pet ech koj unqꞌa yoleꞌ uvaꞌ ni val sete, tan aꞌeꞌ la aqꞌon etiichajil taꞌn u Tiixhla Espíritu. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","As at kaꞌt ex uvaꞌ yeꞌ ni niman unqꞌa yoleꞌ uvaꞌ ni val sete,— tiꞌk u Jesús, tan ootzimalik taꞌn Aak tul simolot Aak unqꞌa ichusulibꞌeꞌ skꞌatz abꞌil uveꞌ yeꞌ nik niman Aak. As atik skꞌuꞌl Aak uvaꞌ abꞌiste naj la kꞌayin Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","As ech tal veꞌt Aak ileꞌ xoꞌl unqꞌa uxhchileꞌ: —Estiꞌeꞌ ni val sete uvaꞌ yeꞌxhebꞌil chiteꞌ taꞌ la toksa tibꞌ sunkꞌatz, asoj jit vunBꞌaaleꞌ la alon,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","As tabꞌi veꞌt unqꞌa ichusulibꞌ u Jesús u yoleꞌ uveꞌ tal Aak. As nimal unqꞌa uxhchileꞌ teesa veꞌt el tibꞌ kꞌatz Aak. As jit xekebꞌ veꞌt unqꞌa uxhchileꞌ tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","As tul til veꞌt Aak uvaꞌ nik teesa veꞌt el tibꞌ unqꞌa uxhchileꞌ kꞌatz Aak, as ech tal veꞌt Aak ileꞌ te kabꞌlaval unqꞌa ichusulibꞌeꞌ: —¿Kano ex qꞌi? ¿Ma antu ex la eteesa veꞌt el etibꞌ sunkꞌatz?— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ech tal veꞌt u Simón ileꞌ uvaꞌ Luꞌ te u Jesús: —¿Pap, abꞌil umaꞌtoj qꞌi uvaꞌ la qoksa qibꞌ skꞌatz? Tan taꞌn axheꞌ uveꞌ ni alon u yoleꞌ sqe uveꞌ tetz kutiichajil uveꞌ yeꞌl iyaꞌtebꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","As kat kunima axh, tan ootzimal sqaꞌn uvaꞌ axh u Cristo, viKꞌaol u islich Tiixheꞌ,— tiꞌk u Luꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","As ech tal veꞌt u Jesús ileꞌ: —Ootzimaleꞌ setaꞌn uvaꞌ kabꞌlaval ex kat untxaa ex. As at umaꞌl ex uvaꞌ ech vetxumbꞌaleꞌ echeꞌ u txꞌiꞌlanajeꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","As aꞌ u Judas uvaꞌ Iscariote, vikꞌaol u Simón, nikat tal Aak, tan atik skꞌuꞌl Aak uvaꞌ naj tuk aqꞌon ok Aak tiqꞌabꞌ unqꞌa uxhchileꞌ uvaꞌ nichꞌoꞌn taama tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","As xamtik veꞌt stuul, as aꞌ nikat ixaankat veꞌt u Jesús tulaj unqꞌa tenameꞌ tu u Galilea, tan jit isaꞌ Aak tatin tu u Judea, tan nikat ichuk unqꞌa iqꞌesal unqꞌa tenameꞌ txumbꞌal tiꞌ iyatzꞌpu veꞌt Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","As txantik ilejat u nimla qꞌiieꞌ uvaꞌ nik ilak unqꞌa tiaal Israel unqꞌa talaj ipacheꞌ tiꞌ tulsat skꞌuꞌl tiꞌ uvaꞌ kaꞌviinqil yaabꞌ kat atin unqꞌa qꞌesla ibꞌaaleꞌ tu u tzuukin txꞌavaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","As ech tal veꞌt unqꞌa titzꞌin u Jesús ileꞌ ste: —Kuxh tu u Judea, aqꞌal uvaꞌ la til unqꞌa achusulibꞌeꞌ unqꞌa kꞌuchbꞌal tetz vibꞌaꞌnil u Tiixheꞌ uveꞌ nabꞌaneꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","tan abꞌil uvaꞌ nisaꞌ uvaꞌ la ootzil taꞌn unqꞌa tenameꞌ as yeꞌ la uch imujat tibꞌ. As kuxh kꞌuch eebꞌ vatz unqꞌa tenameꞌ, asoj nim vabꞌaꞌnileꞌ nabꞌaneꞌ,— tiꞌk chajnaj, ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","tan mitaꞌn kuxh unqꞌa titzꞌin Aakeꞌ nikat niman Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","As ech tal veꞌt u Jesús ileꞌ: —Yeꞌ ilejeꞌt u qꞌiieꞌ tiꞌ unbꞌen tu u nimla qꞌiieꞌ. Pet ech koj ex, tan kam kuxh qꞌiil la uch ebꞌeneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","As echeꞌ la koj tixva ex unqꞌa tenameꞌ. Pet ech koj in, tan ni tixva in unqꞌa tenameꞌ, tan tiꞌ uvaꞌ ni valoꞌk ste uvaꞌ vaꞌlexh nibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","As bꞌenoj etiltaj u nimla qꞌiieꞌ. Pet ech koj in, tan yeꞌl in la bꞌen in cheel, tan yeꞌ ilejeꞌt u qꞌiieꞌ tiꞌ unkꞌuchat vibꞌ vatz unqꞌa tenameꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","As tul yaꞌ Aak tiꞌ talat unqꞌa yoleꞌ, as kaa veꞌt Aak tu u Galilea. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","As tul kuxh bꞌen unqꞌa titzꞌin u Jesús tu u nimla qꞌiieꞌ, as bꞌen veꞌt Aak unpajte. As yeꞌ kat ikꞌuch Aak ibꞌeneꞌ. As jit ikꞌuch tibꞌ Aak vatz unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","As nik ichuk veꞌt unqꞌa iqꞌesal unqꞌa tenameꞌ Aak xoꞌl unqꞌa mamaꞌla tenameꞌ tu u nimla qꞌiieꞌ. As ech nikat tal chajnaj ileꞌ svatzaj: —¿Katil atkat u najeꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","As nik iyolbꞌe veꞌt unqꞌa tenameꞌ u Jesús. As at jolol uxhchil ech nik tal ileꞌ: —Chꞌiꞌumal itxumbꞌal u najeꞌ,— tiꞌk chajnaj. Pet ech koj unjolte, tan ech nik tal ileꞌ: —Yeꞌ bꞌaꞌn veꞌt nibꞌan u najeꞌ, tan nu kuxh iyansa naj itxumbꞌal unqꞌa kumooleꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","As nik kuxh ijutxi unqꞌa tenameꞌ iyoloneꞌ tiꞌ u Jesús, tan tiꞌ uvaꞌ nik ixoꞌv chajnaj vatz unqꞌa iqꞌesal unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","As tul maꞌtik ipokꞌoꞌchin u nimla qꞌiieꞌ, as ok veꞌt u Jesús vatz iqꞌanal u tostiixheꞌ. As ichus veꞌt Aak unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","As sotz veꞌt ikꞌuꞌl unqꞌa iqꞌesal unqꞌa tenameꞌ. As ech tal veꞌt chajnaj ileꞌ: —¿Kam kat tulbꞌe u najeꞌ tootzit viyol u Tiixheꞌ? As tul yeꞌl naj kat ichus tibꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","As ech tal veꞌt u Jesús ileꞌ: —Unqꞌa yoleꞌ uveꞌ nunchus sexoꞌl as jit ineꞌ ni alon. Pet aꞌ u chajol vetzeꞌ ni alon. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","As abꞌil uvaꞌ la saꞌon ibꞌanat uveꞌ ni tal u Tiixheꞌ as la tootzi uvaꞌ ma xeꞌ Aak tzaanajkat unqꞌa yoleꞌ uvaꞌ nunchuseꞌ, pet moj nu kuxh uncheesa tunviꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","As abꞌil uvaꞌ la kuxh icheesa umaj chusbꞌal tiviꞌ as jeꞌsaibꞌeꞌ nibꞌaneꞌ. Pet ech koj in tan aꞌ u chajol vetzeꞌ ni voksa iqꞌii, as jik chit nunchusuneꞌ. As yeꞌl umaj vaꞌlexh nunbꞌan sevatz. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿As kam stiꞌ qꞌi uveꞌ netal unyatzꞌpeꞌ? As tul at veꞌt u tzaqꞌiteꞌ uvaꞌ tzꞌibꞌamal kan sexoꞌl taꞌn u Moisés. As yeꞌl umaj ex ni niman, tan netal unyatzꞌpeꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","As ech tal veꞌt unqꞌa tenam ileꞌ: —¡Subꞌuleꞌ atoꞌk sakꞌatz! ¿Abꞌil ni alon ayatzꞌpeꞌ?— tiꞌk unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","As ech tal veꞌt u Jesús ileꞌ: —Tiꞌ kuxh umaꞌl u bꞌaꞌnil uveꞌ kat unbꞌan tu u xeem qꞌiieꞌ as kat teqꞌo etaama stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","As la val sete, tul uvaꞌ nilej vaaxil qꞌii titzꞌebꞌ umaj neꞌ uvaꞌ xaak, as netzokꞌeꞌl unbꞌiil vichiꞌoleꞌ echeꞌ uvaꞌ tal kan u Moisés. As jit tetz u Moisés u yoleꞌ, pet Tiixh kat alon te unqꞌa qꞌesla ebꞌaaleꞌ. As kꞌuxh tu u xeem qꞌii ni chit ebꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Asoj ni tuch itzokꞌax el unbꞌiil ichiꞌol umaj neꞌ xaak tu u xeem qꞌiieꞌ tiꞌ uvaꞌ yeꞌ la epaasa tzii tiꞌ u tzaqꞌiteꞌ uvaꞌ tal kan u Moisés, as ¿kam qꞌi uveꞌ ni tul eviꞌ sviꞌ tiꞌ uvaꞌ kat unbꞌaꞌnxisa umaꞌl u aachꞌoꞌm tu u xeem qꞌiieꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","As jikoj chit ebꞌan unsuuchil. As ebꞌantaj teviꞌ asoj bꞌaꞌn nunbꞌaneꞌ moj yeꞌle,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","As ech tal veꞌt kaꞌl unqꞌa aa Jerusalén ileꞌ svatzaj tiꞌ u Jesús: —¿Ma jit u najeꞌ nichukpeꞌ uvaꞌ ni talax iyatzꞌpeꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","As il naj ileꞌ niyolon xoꞌl unqꞌa tenameꞌ. As yeꞌxhkam kuxh ni talax tiꞌ naj. Kamal naꞌl vatz unqꞌa kubꞌooqꞌoleꞌ uvaꞌ aꞌ u Cristoeꞌ u najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pet ootzimal sqaꞌn uvaꞌ katil tzaakat naj. Pet ech koj u Cristo, tan tul la ul Aak, as yeꞌxhebꞌil la ootzin katil la tzaakat Aak,— tiꞌk unqꞌa tenameꞌ svatzaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","As tul nikat ichusun u Jesús vatz iqꞌanal u tostiixheꞌ, as taqꞌ veꞌt jeꞌ Aak tuul iviꞌ xoꞌl unqꞌa tenameꞌ. As ech tal veꞌt Aak ileꞌ: —Ootzimal in setaꞌn. As ootzimal setaꞌn uvaꞌ katil tzaanajkat in. As yeꞌl uvaꞌ kat kuxh koj ul in tukꞌ untxumbꞌal. Pet aꞌ u jikla Tiixheꞌ kat chajon tzan in uvaꞌ yeꞌ ootzimal setaꞌn. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","As ootzimal Aak svaꞌn, tan kꞌatz Aak tzaanajkat in. As Aakeꞌ chajon tzan in,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","As kꞌuxh nik tal veꞌt unqꞌa iqꞌesal unqꞌa tenameꞌ itxeyat Aak, as yeꞌxhebꞌil kat txeyon Aak, tan yeꞌxnik ilejat u qꞌiieꞌ uvaꞌ la txeypu veꞌt Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","As yeꞌ saach unqꞌa tenameꞌ ikꞌujbꞌaꞌ ikꞌuꞌl tiꞌ Aak. Ech nik tal veꞌt ileꞌ svatzaj: —Asoj jit u Cristo u Jesús, as tul la ul u Cristo, as ¿la kol pal veꞌt vibꞌaꞌnileꞌ qꞌa tiꞌ u mamaꞌla kꞌuchbꞌal tetz u tijleꞌm u Jesús uveꞌ kat ibꞌanlu veꞌteꞌ?— tiꞌk unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","As tabꞌi veꞌt unqꞌa fariseo unqꞌa yoleꞌ uvaꞌ nik tal unqꞌa uxhchileꞌ tiꞌ u Jesús. As imol veꞌt tibꞌ chajnaj tukꞌ unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh. As ichaj veꞌt bꞌen chajnaj kaꞌl unqꞌa xeen tetz u tostiixheꞌ tiꞌ itxeypu u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","As ech tal veꞌt u Jesús ileꞌ xoꞌl unqꞌa tenameꞌ: —Unbꞌiitoj kuxheꞌ tuk unbꞌan sexoꞌl. As tuk qꞌaavoj veꞌt in kꞌatz u chajol vetzeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","As kꞌuxh la echuk veꞌt in, as echeꞌ la koj elej veꞌt in, tan la koj uch etooneꞌ tu u atinbꞌaleꞌ uveꞌ la atinkat in,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","As ech tal veꞌt unqꞌa fariseo ileꞌ svatzaj tukꞌ unqꞌa iqꞌesal unqꞌa nachol Tiixheꞌ: —¿Katileꞌ qꞌi la bꞌenkat u najeꞌ uveꞌ ni taleꞌ, uvaꞌ yeꞌ la kulej veꞌt naj? ¿Ma aꞌ la bꞌenkat naj bꞌa xoꞌl unqꞌa kumooleꞌ uvaꞌ jejleꞌl xoꞌl unqꞌa tenameꞌ uvaꞌ jit tiaal Israel? ¿Pet moj la bꞌen ichus veꞌt naj unqꞌa tenameꞌ uvaꞌ jit tiaal Israel? ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿As kam ni tokkat viyol najeꞌ uveꞌ ni taleꞌ: «Kꞌuxh la echuk in, as yeꞌl in la elej veꞌt in. As la koj etxꞌol etooneꞌ tu u atinbꞌaleꞌ uveꞌ la atinkat in,» taqꞌ kuxh naj ni taleꞌ,— tiꞌk chajnaj? ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","As timoxtebꞌal u nimla qꞌiieꞌ as aꞌ u qꞌiieꞌ uveꞌ nim talcheꞌ tu u nimla qꞌiieꞌ. As txakpu veꞌt u Jesús vatz unqꞌa tenameꞌ. As taqꞌ veꞌt jeꞌ Aak tuul iviꞌ. Ech tal Aak ileꞌ: —Abꞌiste ex nitzaj etziꞌ as etoksataj etibꞌ sunkꞌatz. As ukꞌaꞌoj ex sunkꞌatz, ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","tan abꞌil uvaꞌ la ikꞌujbꞌaꞌ ikꞌuꞌl sviꞌ as ech la ibꞌaneꞌ echeꞌ uvaꞌ tzꞌibꞌamal kan tu viyol u Tiixheꞌ. Tan ech tel chꞌuꞌl vunbꞌaꞌnileꞌ tu u taanxelaleꞌ echeꞌ nibꞌan u aꞌeꞌ tul ni tel chꞌuꞌl tu u vitzeꞌ uvaꞌ ni aqꞌon tiichajil,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","As aꞌ u Tiixhla Espíritu nikat tal Aak, uvaꞌ la ok veꞌt tu u taanxelal unqꞌa uxhchileꞌ uvaꞌ la ikꞌujbꞌaꞌ ikꞌuꞌl tiꞌ Aak, tan yeꞌxnik ul u Tiixhla Espíritu tiꞌ tok tu u taanxelal unqꞌa niman tetz Aakeꞌ. As yeꞌxnik oon Aak tu u atinbꞌaleꞌ uveꞌ la oksalkat iqꞌiia Aak kꞌatz viBꞌaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","As tul tabꞌi veꞌt unqꞌa tenameꞌ unqꞌa yoleꞌ uveꞌ tal u Jesús, as ech tal veꞌt unjolol unqꞌa naj ileꞌ: —An chiteꞌ vil. Aꞌ u qꞌajsan tetz viyol u Tiixheꞌ kat ulyu veꞌteꞌ uvaꞌ alel kan u tulebꞌaleꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","As ech tal unjoltu unqꞌa naj ileꞌ: —An chiteꞌ. Aꞌ u Cristo kat ulyu veꞌteꞌ,— tiꞌk chajnaj. As atik kaꞌt uxhchil uvaꞌ ech tal ileꞌ: —¿As tu kol u Galilea qꞌa la tzaakat u Cristo? ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿As yeꞌ kol qꞌa sekꞌuꞌl uvaꞌ alel kan tu viyol u Tiixheꞌ uvaꞌ tiaal David u Cristo la ibꞌaneꞌ? Tan aꞌ la tzaakat tu u Belén, uvaꞌ atikkat u David,— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","As yeꞌ nik ikꞌul tibꞌ iyol unqꞌa tenameꞌ svatzaj tiꞌ u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","As atik unjolol unqꞌa uxhchileꞌ nik alon uvaꞌ la txeyax Aak. As yeꞌxhebꞌil kat txeyon Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","As tul qꞌaav veꞌt unqꞌa xeen tetz u tostiixheꞌ uvaꞌ maꞌtik ichajax bꞌen taꞌn unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh tukꞌ unqꞌa fariseo tiꞌ itxeypu veꞌt u Jesús, as ech alpu veꞌt ileꞌ te chajnaj: —¿Kam tetzeꞌ uveꞌ yeꞌ kat eteqꞌo tzan u Jesús?— tiꞌk unqꞌa chajol tetz chajnajeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ech tal veꞌt unqꞌa xeen tetz u tostiixh ileꞌ: —As yeꞌ atixoj qabꞌi iyolon umaj uxhchil uvaꞌ achaꞌv iyoloneꞌ echeꞌ iyolon u najeꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","As ech tal veꞌt unqꞌa fariseo ileꞌ te chajnaj: —¿Ma antu veꞌt ex bꞌa kat yanyu veꞌt etxumbꞌal taꞌn u najeꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿As ma yeꞌ ootzimal setaꞌn uvaꞌ yeꞌl umaj unqꞌa kuqꞌesaleꞌ ni niman u najeꞌ? As mitaꞌn oꞌ uvaꞌ oꞌ fariseo ni niman naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","As jankꞌal unqꞌa tenameꞌ uveꞌ ni niman u najeꞌ, as niyansa veꞌt tibꞌ, tan echeꞌ ootzimal koj u tzaqꞌiteꞌ uvaꞌ tzꞌibꞌamal kan taꞌn naj,— tiꞌk unqꞌa fariseo. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","As u Nicodemo uvaꞌ bꞌex yolon xeꞌ u Jesús aqꞌbꞌal, tan imool tibꞌ naj tukꞌ unqꞌa fariseo. As ech tal veꞌt naj ileꞌ te vimooleꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Palojtaj oꞌ stuul uvaꞌ aꞌ ni tal u kuleyeꞌ uvaꞌ lanal qabꞌi isuuchil bꞌaxa. As aꞌn la qal itxeypu umaj uxhchil tul uvaꞌ la qootzi vipaaveꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","As ech tal veꞌt unqꞌa imool naj ileꞌ: —¿As ma aꞌ nooksakat eebꞌ kꞌatz unqꞌa aa Galilea? ¡Chus eebꞌ sbꞌaꞌn tiꞌ viyol u Tiixheꞌ, tan yeꞌl umaj qꞌajsan tetz viyol u Tiixheꞌ uvaꞌ aa Galilea!— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","As ijatx veꞌt tibꞌ chajnaj. As bꞌen veꞌt chajnaj tulaj ikabꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","As bꞌen veꞌt u Jesús. As oon veꞌt Aak viꞌ u tal vitzeꞌ uvaꞌ Olivos ibꞌii. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ech qꞌejal stuul, as qꞌaav veꞌt Aak tu u tostiixheꞌ. As mamaꞌla tenameꞌ imol veꞌt tibꞌ tiꞌ Aak. As tul xonebꞌ veꞌt Aak xoꞌl unqꞌa tenameꞌ, as xeꞌt veꞌt Aak chusun. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","As kaꞌl unqꞌa fariseo tukꞌ kaꞌt unqꞌa uxhchil uvaꞌ chusel tibꞌ tiꞌ unqꞌa tzaqꞌiteꞌ, as teqꞌo veꞌt tzan chajnaj umaꞌl u ixoj uvaꞌ bꞌex lejpoj tul nik ipaavineꞌ tukꞌ umaꞌt naj. As oksal veꞌt ok ixoj vatz u Jesús xoꞌl unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","As ech tal veꞌt ok chajnaj ileꞌ te Aak: —Chusul, il umaꞌl u ixoj ilaꞌ kat kulejlaꞌ tul nipaavin ixoj tukꞌ umaꞌt naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","¿As kam tuk aal stiꞌ? Tan tzꞌibꞌamal kan taꞌn u Moisés uvaꞌ asoj la kulej umaj ixoj uvaꞌ ech nibꞌaneꞌ, as la kusuti kꞌubꞌ tiꞌ ixoj tiꞌ iyatzꞌpeꞌ,— tiꞌk chajnaj, ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","tan aꞌ nikat tal chajnaj uvaꞌ la chee ipaav Aak tiꞌ uvaꞌ la bꞌen ixoch chajnaj Aak. As ixibꞌbꞌaꞌ kuꞌ tibꞌ Aak. As xeꞌt Aak tzꞌibꞌoj vatz txꞌavaꞌ tukꞌ viꞌ iqꞌabꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","As yaꞌltik chit chajnaj tiꞌ ichꞌotil ok te Aak tiꞌ u ixojeꞌ. Txakpu veꞌt Aak. As ech tal veꞌt Aak ileꞌ: —Abꞌiste umaj ex uvaꞌ yeꞌl epaav ati as ex la sutin u kꞌubꞌeꞌ bꞌaxa tiꞌ u ixojeꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","As ixibꞌbꞌaꞌ kuꞌ tibꞌ u Jesús unpajte. As xeꞌt veꞌt Aak tzꞌibꞌoj vatz u txꞌavaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","As junun kuxh ibꞌen veꞌt unqꞌa xochol tetz u ixojeꞌ. As bꞌaxik chit bꞌen unqꞌa qꞌesla aamaeꞌ. As tul bꞌen chajnaj skajayil, as aꞌ kuxh veꞌt u ixojeꞌ kaaik kan kꞌatz u Jesús xoꞌl unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","As txakpu veꞌt Aak unpajte. As ech tal veꞌt Aak ileꞌ te ixoj: —¿Kech unqꞌa naj uvaꞌ ni xochon axh? ¿Moj yeꞌxhebꞌil ni alon akameꞌ?— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","As ech tal u ixoj ileꞌ: —Yeꞌle, Pap. Yeꞌxhebꞌil veꞌteꞌ,— tiꞌk ixoj. As ech tal veꞌt Aak ileꞌ: —Mitaꞌn in la alon akameꞌ. Pet kuxh veꞌteꞌ. As yeꞌ paavin veꞌt axh,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","As ech tal veꞌt u Jesús ileꞌ xoꞌl unqꞌa tenameꞌ: —Ineꞌ txijun tetz u taanxelal unqꞌa uxhchileꞌ skajayil. Abꞌil uveꞌ la xekebꞌ sviꞌ, as yeꞌxh jatu la xaan veꞌt tu u qꞌej toktoeꞌ, tan at veꞌt in skꞌatz, tan ineꞌ u txijun tetzeꞌ uvaꞌ la aqꞌon itiichajil u taanxelaleꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","As ech tal veꞌt unqꞌa fariseo ileꞌ te Aak: —An kuxh axh nayolon jeꞌ seeꞌ. Estiꞌeꞌ uvaꞌ aꞌ chit vayoleꞌ yeꞌ la txakoni,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","As ech tal veꞌt Aak ileꞌ: —As kꞌuxh an kuxh in ni val jeꞌ vibꞌ, as jik chiteꞌ nunyoloneꞌ, tan ootzimal svaꞌn uvaꞌ katil tzaanajkat in, as katiꞌch unbꞌeneꞌ la bꞌen in. Pet ech koj ex, tan yeꞌ ootzimal setaꞌn kat tzaanajkat in, as katil la bꞌenkat in. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","As vatz txꞌavaꞌilla txumbꞌal kuxheꞌ nebꞌan sviꞌ tiꞌ ebꞌanat unsuuchil. Pet ech koj in, tan yeꞌl umaj uxhchil nunbꞌan isuuchil cheel. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pet tul la unbꞌan isuuchil unqꞌa tenameꞌ as jik chiteꞌ la unbꞌan isuuchil, tan jit kuxh in la bꞌanon sunjunal. Pet anteꞌ u chajol tzan vetzeꞌ la bꞌanon isuuchil, ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","tan ech ni tal u yol ileꞌ uvaꞌ tzꞌibꞌamal kan: «Tan asoj la ikꞌul tibꞌ iyol kaꞌvoꞌj uxhchil tiꞌ umaj txumbꞌal, as la nimal viyoleꞌ,» tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Estiꞌeꞌ uvaꞌ jit kuxh in nunyolon jeꞌ sviꞌ. Pet anteꞌ vunBꞌaaleꞌ uveꞌ kat chajon tzan in uveꞌ ni alon u yoleꞌ sviꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","As ech tal veꞌt chajnaj ileꞌ: —¿Kech vabꞌaaleꞌ qꞌi uvaꞌ ni alon u yoleꞌ seeꞌ?— tiꞌk chajnaj. Ech tal veꞌt Aak ileꞌ: —Yeꞌ netexhla abꞌiste u vijleꞌmeꞌ. ¿As aꞌ kol chit vunBꞌaaleꞌ qꞌa la etexhla u tijleꞌmeꞌ? Tan asoj la etexhla uvaꞌ abꞌiste u vijleꞌmeꞌ, as anteꞌ vunBꞌaaleꞌ la etexhla u tijleꞌmeꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","As aꞌ unqꞌa yoleꞌ uvaꞌ tal veꞌt Aak tul nik ichus veꞌt Aak unqꞌa uxhchileꞌ vatz u tostiixheꞌ kꞌatz u atinbꞌaleꞌ uvaꞌ nik imolpukat unqꞌa puajeꞌ uvaꞌ nik toyal vatz u Tiixheꞌ. As echeꞌ abꞌil koj txeyon Aak, tan tiꞌ uvaꞌ yeꞌxnik ilejat u qꞌiieꞌ tiꞌ uvaꞌ la txeypu veꞌt Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","As ech tal u Jesús ileꞌ: —La bꞌen in. As la echuk veꞌt in. As katil uveꞌ la bꞌenkat in as echeꞌ la koj uch etoon sunkꞌatz, tan aꞌ vepaaveꞌ la eqꞌon ex tu u kamchileꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","As ech tal veꞌt unqꞌa uxhchil ileꞌ svatzaj uvaꞌ nikat ichꞌoꞌn taama tiꞌ u Jesús: —¿As kam ni tokkat viyol najeꞌ uveꞌ ni taleꞌ? «Katil uveꞌ la bꞌenkat in, as echeꞌ la koj uch etoon sunkꞌatz,» taqꞌ kuxh naj ni taleꞌ. Kamal tuk kuxh iyatzꞌ jeꞌ tibꞌ naj sijunal uveꞌ ni taleꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","As ech tal veꞌt u Jesús ileꞌ: —Echen vetxumbꞌaleꞌ tzitzaꞌ vatz u txꞌavaꞌeꞌ. Pet ech koj in, tan aꞌ tzaanajkat in tu almikaꞌ. As vatz txꞌavaꞌilla txumbꞌal kuxheꞌ eqꞌomal setaꞌn. Pet ech koj in, tan jit vatz txꞌavaꞌilla txumbꞌal eqꞌomal svaꞌn. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ech ni valkateꞌ sete tan an kuxh vepaaveꞌ la eqꞌon ex tu u kamchileꞌ, tan tiꞌ uvaꞌ yeꞌ kat enima uvaꞌ abꞌiste u vijleꞌmeꞌ uveꞌ ni val sete,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","As ech tal veꞌt chajnaj ileꞌ te Aak: —¿As kam eejleꞌm qꞌi uvaꞌ naaleꞌ?— tiꞌk chajnaj. Ech tal veꞌt Aak ileꞌ: —Jatpajux kuxh val u vijleꞌmeꞌ sete. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","As nimatel unqꞌa yoleꞌ la val sete tul la unbꞌan esuuchil. As atoj sekꞌuꞌl uvaꞌ jik chit itxumbꞌal u chajol vetzeꞌ. As kam chit unqꞌa yoleꞌ uveꞌ kat tal Aak sve as aꞌeꞌ ni val sete. As ni val te unqꞌa tenameꞌ vatz u txꞌavaꞌeꞌ unpajte,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","As echeꞌ nikat koj ipal unqꞌa uxhchileꞌ tu u yoleꞌ uvaꞌ aꞌ u Kubꞌaal Tiixheꞌ uveꞌ nikat tal Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Estiꞌeꞌ uveꞌ ech tal Aak ileꞌ: —As la etexhla veꞌt in uvaꞌ abꞌiste u vijleꞌmeꞌ tul uvaꞌ la eteesa el in vatz u txꞌavaꞌeꞌ. As aꞌn la pal veꞌt ex stuul uvaꞌ yeꞌl umaj txumbꞌal nunbꞌan sunjunal. Pet aꞌ unqꞌa yoleꞌ uveꞌ ni valeꞌ uveꞌ kat ichus vunBꞌaaleꞌ sve, tan ineꞌ IKꞌAOL U NAJEꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","As at chit vunBꞌaaleꞌ sviꞌ uvaꞌ kat chajon tzan in. As yeꞌl in ni taqꞌ kan in Aak sunjunal, tan nunbꞌaneꞌ kam uvaꞌ bꞌaꞌn te Aak,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","As tul tal u Jesús u yoleꞌ, as yeꞌ saach unqꞌa tenameꞌ ikꞌujbꞌaꞌ ikꞌuꞌl tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","As ech tal veꞌt u Jesús ileꞌ te unqꞌa uxhchileꞌ uveꞌ ni niman veꞌt Aak: —Asoj la enima unqꞌa yoleꞌ uvaꞌ ni val sete, as ex veꞌt unchusulibꞌ la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","As la pal veꞌt ex stuul uvaꞌ kam isuuchil u jikla yoleꞌ, tan aꞌ u jikla yoleꞌ la qꞌalpun ex,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","As ech tal veꞌt unqꞌa uxhchil ileꞌ: —¿Kam ni tokkat vayoleꞌ uveꞌ naaleꞌ tiꞌ uvaꞌ la qꞌalpu veꞌt oꞌ? Tan yeꞌ atixoj ok oꞌ skꞌamil xeꞌ umaj uxhchil, tan oꞌ tiaal u Abraham,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","As ech tal veꞌt Aak ileꞌ: —Ileꞌ jik chit tuk val isuuchil sete, tan jankꞌal unqꞌa uxhchileꞌ uveꞌ aꞌ kuxh u paaveꞌ nibꞌaneꞌ, as aꞌeꞌ ikꞌam u paaveꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","As yeꞌl u kꞌameꞌ la koj jejebꞌ tu u kabꞌaleꞌ xeꞌ u bꞌaal kabꞌaleꞌ. Pet ech koj u kꞌaolaeꞌ, tan aꞌ jejleꞌlkat kꞌatz vibꞌaaleꞌ tu u kabꞌaleꞌ tiꞌ chit ibꞌeneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Estiꞌeꞌ ni val sete, tan asoj aꞌ viKꞌaol u Tiixheꞌ la qꞌalpun ex, as qꞌalpinal chit veꞌt ex la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","As ootzimal svaꞌn uvaꞌ ex tiaal u Abraham. As netal veꞌt unkameꞌ, tan tiꞌ uvaꞌ yeꞌ nepal tu unqꞌa yoleꞌ uvaꞌ ni val sete. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","As unqꞌa yoleꞌ uveꞌ ni valeꞌ, as aꞌeꞌ uvaꞌ kꞌuchel sve taꞌn vunBꞌaaleꞌ. As ileꞌ ni val sete. Echat kuxh ex unpajte, tan kam uveꞌ netabꞌi taꞌn vebꞌaaleꞌ as aꞌeꞌ nebꞌaneꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","As ech tal veꞌt unqꞌa uxhchil ileꞌ: —Oꞌ tiaal u kubꞌaal Abraham,— tiꞌk chajnaj. Ech tal veꞌt u Jesús ileꞌ: —Ex koj tiaal u Abraham, as aꞌ la ebꞌaneꞌ uveꞌ nik ibꞌan u Abraham. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pet ech koj ex tan netal veꞌt unyatzꞌpeꞌ tiꞌ uvaꞌ kat val isuuchil u jikla yoleꞌ sete uvaꞌ kat tal u Tiixheꞌ sve. As ech koj kat ibꞌan u Abraham echeꞌ uveꞌ nebꞌaneꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","tan aꞌ kuxh nebꞌaneꞌ kam uveꞌ nibꞌan vebꞌaaleꞌ,— tiꞌk Aak. As ech tal veꞌt chajnaj ileꞌ: —¡Yeꞌl uvaꞌ sikꞌel tzan kuxh koj oꞌ xeꞌ peꞌ! Pet ootzimal Kubꞌaal sqaꞌn. As aꞌ u Tiixheꞌ taꞌ u Kubꞌaaleꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","As ech tal veꞌt Aak ileꞌ: —As aꞌ koj chit u Tiixheꞌ vebꞌaaleꞌ, as xoꞌn ineꞌ sete tan kꞌatz u Tiixheꞌ tzaanajkat in. As echeꞌ tukꞌ kuxh koj untxumbꞌal uvaꞌ kat ul in tzitzaꞌ, pet Aakeꞌ kat chajon tzan in. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","As tuk val sete kam stiꞌ uveꞌ yeꞌ nepal tu vunyoleꞌ uveꞌ ni valeꞌ, tan tiꞌ uvaꞌ yeꞌ nesaꞌ etabꞌit vunyoleꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","tan aꞌ u txꞌiꞌlanajeꞌ vebꞌaaleꞌ. As kam chit uvaꞌ nisaꞌ vebꞌaaleꞌ as aꞌeꞌ nebꞌaneꞌ, tan aꞌeꞌ yatzꞌol tetz unqꞌa uxhchileꞌ bꞌaxa yol. As echat chit nibꞌan cheel, tan yeꞌl u jikla txumbꞌaleꞌ eqꞌomal staꞌn. As tul niyoloneꞌ tukꞌ vichuli yolileꞌ, as aꞌ vitxumbꞌaleꞌ nikꞌucheꞌ, tan aꞌ u txꞌiꞌlanajeꞌ cheesan tetz u chuli yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pet ech koj in tan ni valoꞌk u jikla yoleꞌ sete. As yeꞌ nenima in. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Asoj jik chit unqꞌa yoleꞌ ni val sete, ¿as kam stiꞌ qꞌi yeꞌ nekꞌujbꞌaꞌ ekꞌuꞌl sviꞌ? ¿Pet moj at umaj ex uvaꞌ la kꞌuchun sve abꞌiste vunpaaveꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tan abꞌil uvaꞌ aꞌ u Tiixheꞌ vibꞌaaleꞌ, as ayaꞌl chit ikꞌuꞌl nisaꞌ inimat viyol u Tiixheꞌ. Pet ech koj ex, tan jit u Tiixheꞌ vebꞌaaleꞌ. Estiꞌeꞌ yeꞌ nesaꞌ enimat viyol u Tiixheꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","As ech tal veꞌt unqꞌa uxhchil ileꞌ: —An chiteꞌ vil uveꞌ ni qal seeꞌ, tan ¡ech axheꞌ aa Samaria! ¡As aꞌ u subꞌuleꞌ atoꞌk sakꞌatz!— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ech tal veꞌt u Jesús ileꞌ: —Yeꞌl subꞌul atoꞌk sunkꞌatz. Pet aꞌ vunBꞌaaleꞌ taꞌ ni voksa iqꞌii. Pet ech koj ex, tan neteesa unqꞌii. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","As aꞌ koj ni valeꞌ uvaꞌ la oksal unqꞌii setaꞌn. Pet at umaꞌl u oksan tetz unqꞌii. As aꞌeꞌ vunBꞌaaleꞌ uvaꞌ la bꞌanon esuuchil. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","As ileꞌ jik chit tuk val sete, tan abꞌil uveꞌ la niman vunyoleꞌ as yeꞌxh jatueꞌ la kami,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","As ech tal veꞌt unqꞌa uxhchil ileꞌ: —¡Ileꞌ kat qootzil veꞌt cheel uvaꞌ atoꞌk chit u subꞌuleꞌ sakꞌatz! Tan kat kam u Abraham tukꞌ unqꞌa qꞌajsan tetz viyol u Tiixheꞌ. As naaleꞌ uvaꞌ, «Abꞌil la niman vunyoleꞌ as yeꞌxh jatueꞌ la kami,» chꞌaxh naaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿As ma nim aalchu veꞌt bꞌa tiꞌ u kubꞌaal Abraham? Tan kat kam u Abraham. As kat kam unqꞌa qꞌajsan tetz viyol u Tiixheꞌ. ¿Pet kam veꞌt u eejleꞌmeꞌ qꞌi uveꞌ naaleꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","As ech tal veꞌt u Jesús ileꞌ: —Asoj an kuxh in la voksa jeꞌ unqꞌii, as yeꞌl itxaꞌk vunyoleꞌ. Pet aꞌ vunBꞌaaleꞌ ni oksan unqꞌii. As an chit vunBꞌaaleꞌ taꞌ uveꞌ «kuTiixh» chꞌex netal stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","As tul yeꞌl Tiixh at tu vetaanxelaleꞌ. Pet ech koj in, tan ootzimal chit Aak svaꞌn. As la koj valeꞌ uvaꞌ, «Yeꞌ vootzaj Aak,» chaj koj in, tan at Aak sunkꞌatz. Asoj la valeꞌ uvaꞌ, «Yeꞌ vootzaj Aak,» chaj in, as in chulin yoleꞌ, echeꞌ ex. Pet ootzimal Aak svaꞌn. As nimamal viyol Aakeꞌ svaꞌn. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Pet u Abraham uvaꞌ «kubꞌaal» chꞌex netal stiꞌ, as nikat ichiibꞌ veꞌt aak sviꞌ. As nikat itxuqꞌtxun aak tiꞌ itxꞌebꞌlu u qꞌiieꞌ tiꞌ u vulebꞌaleꞌ, tan naꞌlik vatz aak uvaꞌ la ul in,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","As ech tal veꞌt unqꞌa uxhchil ileꞌ: —Yeꞌl axh taꞌ abꞌaneꞌt lavoj toxkꞌal (50) yaabꞌ. ¿As ma kat eel u Abraham bꞌa uveꞌ naaleꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ech tal veꞌt u Jesús ileꞌ: —Ileꞌ jik chit tuk val sete, as tul yeꞌxnik itzꞌebꞌ u Abraham, as atik chit ineꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","As isikꞌ veꞌt unqꞌa uxhchileꞌ kꞌubꞌ tiꞌ isutil tiꞌ Aak. As imuj veꞌt tibꞌ Aak tiꞌ tel chꞌuꞌl tu u tostiixheꞌ xoꞌl chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","As tul nikat ixaan u Jesús tu bꞌey, as til veꞌt Aak umaꞌl u naj uvaꞌ tzotike stitzꞌebꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","As ech tal veꞌt unqꞌa ichusulibꞌ Aak ileꞌ: —¿Chusul, abꞌil etz u paaveꞌ tiꞌ uveꞌ tzot vas najeꞌ stitzꞌebꞌeꞌ? ¿Ma ipaav naj? ¿Pet moj ipaav u txutx bꞌaalaeꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ech tal veꞌt Aak ileꞌ: —Yeꞌle. Jit ipaav najeꞌ. As jit ipaav vitxutx najeꞌ tukꞌ vibꞌaal najeꞌ uvaꞌ tzotik naj stitzꞌebꞌeꞌ, pet aqꞌal uvaꞌ la ikꞌuch u Tiixheꞌ vibꞌaꞌnileꞌ tiꞌ naj. As estiꞌeꞌ tzotik naj stitzꞌebꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","As techal chit tuk unbꞌan unqꞌa bꞌaꞌnileꞌ uvaꞌ tal tzan u chajol vetzeꞌ sve tul uvaꞌ yeꞌxnaj bꞌen qꞌii, tan tul la ok aqꞌbꞌal, as yeꞌxhebꞌil la uch veꞌt taqꞌonveꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","As tul atiltel in vatz u txꞌavaꞌeꞌ, as in txijun tetz u taanxelal unqꞌa uxhchileꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","As tzubꞌik veꞌt kuꞌ Aak tu txꞌavaꞌ. Ibꞌan veꞌt Aak unbꞌiil u suj. As toksa veꞌt ok Aak u sujeꞌ tziꞌ ivatz u tzoteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","As ech tal veꞌt Aak ileꞌ te u tzoteꞌ: —Kuxh txꞌaa vavatzeꞌ tu u piilaeꞌ uveꞌ Siloé,— tiꞌk Aak. As isuuchil u yoleꞌ uvaꞌ Siloé, uveꞌ «chajel tzan.» As oora chit bꞌex itxꞌaa veꞌt u tzoteꞌ vivatzeꞌ tu u aꞌeꞌ. As tul qꞌaav veꞌt naj, as nik tilon veꞌt naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","As unqꞌa uxhchileꞌ uveꞌ echen kꞌatz ikabꞌal naj tukꞌ unqꞌa uxhchileꞌ uvaꞌ ootzinik tetz naj uvaꞌ tzotik naj, as ech tal veꞌt ileꞌ: —¿Ma jit u najeꞌ uveꞌ nikat ixonebꞌ tiꞌ ijoyat ipuaj?— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","As at uxhchil nik alon: —Kano. Najeꞌ taꞌ,— tiꞌke. As at jolte uvaꞌ: —Yeꞌle. Jit najeꞌ. As eela unbꞌiil tilon naj tukꞌ u tzoteꞌ,— tiꞌke. As ech tal veꞌt naj ileꞌ: —Ineꞌ uvaꞌ inik tzot,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","As ech tal veꞌt unqꞌa uxhchil ileꞌ te naj: —¿Kam qꞌi uveꞌ neelon veꞌt cheel?— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ech tal veꞌt u naj ileꞌ uvaꞌ tzotike: —U najeꞌ uvaꞌ Jesús ibꞌii as kat ibꞌan unbꞌiil u suj. As kat toksa ok tziꞌ unvatz. As ech tal ileꞌ sve, «Kuxh txꞌaa vavatzeꞌ tu u aꞌeꞌ uvaꞌ Siloé,» tiꞌk sve. As kat bꞌex untxꞌaa veꞌt vunvatzeꞌ. As yak kuxh ilon veꞌt in,— tiꞌk u najeꞌ uvaꞌ tzotike. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","As ech tal unqꞌa uxhchil ileꞌ te naj: —¿Kat atkat u najeꞌ qꞌi?— tiꞌk unqꞌa uxhchileꞌ. Ech tal veꞌt u naj ileꞌ uvaꞌ tzotike: —Yeꞌ vootzaj,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","U naj uvaꞌ tzotike as eqꞌol veꞌt ok naj vatz unqꞌa fariseo, ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","tan tiꞌ uvaꞌ tu u xeem qꞌiieꞌ uveꞌ ibꞌan u Jesús u sujeꞌ. As ibꞌaꞌnxisa veꞌt Aak vivatz u najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","As ichꞌoti veꞌt unqꞌa fariseo te u najeꞌ tiꞌ uvaꞌ kam kat ibꞌan naj tiꞌ uvaꞌ ni tilon veꞌt naj. As ech tal veꞌt naj ileꞌ: —Suj kuxheꞌ kat toksa tziꞌ unvatz. As tul kat bꞌex untxꞌaa vunvatzeꞌ, as kat ilon veꞌt in,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","As ech tal veꞌt kaꞌl unqꞌa fariseo ileꞌ: —¡Junkꞌu! Tan aꞌ texhlal tetz uvaꞌ jit xeꞌ u Tiixheꞌ tzaanajkat u najeꞌ, tan nipaasa naj tzii tu u xeem qꞌiieꞌ,— tiꞌk chajnaj. Pet ech koj kaꞌt chajnaj: —Asoj aapaav u najeꞌ, as ¿kam la tulbꞌe naj qꞌi ikꞌuchat umaj kꞌuchbꞌal tetz tijleꞌm u Tiixheꞌ echeꞌ u veeꞌ?— tiꞌk chajnaj. As nik tok veꞌt ixoꞌl chajnaj svatzaj tiꞌ u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","As ech tal veꞌt chajnaj ileꞌ te u najeꞌ uveꞌ tzotike: —¿Kano axh qꞌi? ¿Kam ni tal aama tiꞌ u najeꞌ uveꞌ kat bꞌaꞌnxisan vavatzeꞌ?— tiꞌk chajnaj. As ech tal veꞌt u naj ileꞌ: —Ni valeꞌ uvaꞌ qꞌajsan tetz viyol u Tiixheꞌ u najeꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pet ech koj unqꞌa uxhchileꞌ uvaꞌ nik ichꞌoꞌn taama tiꞌ u Jesús, tan yeꞌ nik inima uvaꞌ tzotik u najeꞌ, as nik tilon veꞌt naj. As bꞌex mololoj veꞌt vitxutx najeꞌ tukꞌ vibꞌaal najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","As ech tal veꞌt chajnaj ileꞌ te vitxutx najeꞌ tukꞌ vibꞌaal najeꞌ: —¿Ma aꞌ vakꞌaoleꞌ u vaaꞌ tzotike stitzꞌebꞌeꞌ uveꞌ ni tal unqꞌa tenameꞌ? ¿As kam kat ibꞌan naj uvaꞌ ni tilon veꞌt naj cheel?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ech tal veꞌt vitxutx naj ileꞌ tukꞌ vibꞌaal najeꞌ: —Taꞌn qootzajle uvaꞌ qetz naj, as tzotik naj stitzꞌebꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pet yeꞌ qootzaj kam kat ibꞌan naj uvaꞌ ni tilon veꞌt naj, as abꞌil kat bꞌaꞌnxisan vivatz najeꞌ. Pet echꞌotitaj te naj. As an kuxh najeꞌ tuk alon sete, tan tzꞌajnajlu veꞌt iyaabꞌ naj,— tiꞌk chaꞌma. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tan nikat ixoꞌv veꞌt chaꞌma te unqꞌa iqꞌesal unqꞌa tenameꞌ, tan maꞌtik ikꞌulat tibꞌ iyol chajnaj uvaꞌ asoj abꞌil la niman uvaꞌ aꞌ u Cristo u Jesús, as la laqꞌbꞌal el tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh, uveꞌ nikat tal chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Estiꞌeꞌ tal vitxutx u najeꞌ tukꞌ vibꞌaal najeꞌ uvaꞌ: —Echꞌotitaj te naj, tan tzꞌajnajlu veꞌt iyaabꞌ naj,— tiꞌk chaꞌma. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","As molol veꞌt u najeꞌ uveꞌ tzotike. As ech tal veꞌt unqꞌa iqꞌesal unqꞌa tenam ileꞌ te naj: —Yeꞌ eesa iqꞌii u Tiixheꞌ tukꞌ u chuli yoleꞌ, tan ileꞌ ootzimal sqaꞌn uvaꞌ aapaaveꞌ u najeꞌ uveꞌ kat bꞌaꞌnxisan vavatzeꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","As ech tal veꞌt naj ileꞌ: —Yeꞌ vootzaj bꞌa asoj aapaav u najeꞌ moj yeꞌle. Pet taꞌn kuxh ootzimaleꞌ svaꞌn uvaꞌ inik tzot, as cheel il in ni vilon veꞌteꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","As ech tal veꞌt chajnaj ileꞌ: —¿Kam qꞌi kat tulbꞌe axh naj tiꞌ ibꞌaꞌnxisal vavatzeꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","As ech tal veꞌt u naj ileꞌ: —As valleꞌ sete. As yeꞌ kuxh ni tok vunyoleꞌ teviꞌ. ¿As kam qꞌi uvaꞌ nesaꞌ etabꞌit unpajte? ¿Ma aꞌ nesaꞌ bꞌa uvaꞌ antu veꞌt ex la ok ex sichusulibꞌ u najeꞌ?— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","As yoqꞌon veꞌt chajnaj te u najeꞌ. Ech tal veꞌt chajnaj ileꞌ: —¡Echen nooksakat eebꞌ kꞌatz naj! ¡Pet ech koj oꞌ, tan aꞌ ni qoksakat qibꞌ kꞌatz u Moisés! ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","As ootzimal sqaꞌn uvaꞌ kat yolon u Tiixheꞌ tukꞌ u Moisés, pet ech koj u najeꞌ tan yeꞌ qootzaj katil tzaanajkat naj,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","As ech tal veꞌt naj ileꞌ te chajnaj: —¡Vaꞌlen kuxh eyoloneꞌ! Yeꞌ etootzale katil tzaanajlukat Aak, as tul Aak kat bꞌaꞌnxisan vunvatzeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","As ootzimal svaꞌn setukꞌ uvaꞌ yeꞌ ni tabꞌi u Tiixheꞌ viyol unqꞌa aapaaveꞌ. Pet abꞌil uvaꞌ ni niman Aak as nibꞌaneꞌ kam uvaꞌ ni tal Aak, as aꞌ uxhchileꞌ ni tabꞌi u Tiixheꞌ viyoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Pet yeꞌ atixoj vabꞌi uvaꞌ at umaj uxhchil la ilon umaj tzot staꞌn uvaꞌ tzotik stitzꞌebꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Asoj jit kꞌatz u Tiixheꞌ tzaanajkat, as yeꞌxhkam chiteꞌ la itxꞌol ibꞌanataꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","As ech tal veꞌt unqꞌa iqꞌesal unqꞌa tenam ileꞌ: —¡Axh chit umaꞌl u aapaav tul kat itzꞌebꞌ axh! ¿As la kol achusoꞌk tzan oꞌ qꞌa uvaꞌ naaleꞌ?— tiꞌk chajnaj. As ilaqꞌbꞌa veꞌt el chajnaj vas najeꞌ tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","As tul tabꞌi veꞌt u Jesús uvaꞌ maꞌtik ilaqꞌbꞌal el tzan u najeꞌ, as ech tal veꞌt Aak ileꞌ te naj tul ilej Aak naj: —¿Ma kꞌujleꞌl akꞌuꞌl tiꞌ viKꞌaol u Tiixheꞌ?— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","As ech tal veꞌt naj ileꞌ: —¿As abꞌiste viKꞌaol u Tiixheꞌ qꞌi, tiꞌ uvaꞌ la unkꞌujbꞌaꞌ unkꞌuꞌl stiꞌ?— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","As ech tal veꞌt u Jesús ileꞌ: —As ootzimal veꞌteꞌ aꞌn, tan ineꞌ uveꞌ nunyolon see,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ech tal veꞌt naj ileꞌ: —¡Tuk unkꞌujbꞌaꞌ veꞌt unkꞌuꞌl seeꞌ!— tiꞌk naj. As kuꞌ veꞌt naj qaaloj vatz Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","As ech tal veꞌt Aak ileꞌ: —Estiꞌeꞌ kat ul in vatz u txꞌavaꞌeꞌ tiꞌ ul unjatxat ixoꞌl unqꞌa uxhchileꞌ, tan la ilon veꞌt unqꞌa uxhchileꞌ uvaꞌ yeꞌ ni tiloneꞌ. Pet ech koj unqꞌa uxhchileꞌ uveꞌ ni tiloneꞌ ni taleꞌ, as aꞌeꞌ uvaꞌ tzot veꞌteꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","As tul tabꞌi veꞌt kaꞌl unqꞌa fariseo, as ech tal veꞌt chajnaj ileꞌ: —¿As ma oꞌ tzot bꞌa uveꞌ naaleꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","As ech tal veꞌt u Jesús ileꞌ: —Ex koj tzot, as yeꞌl epaaveꞌ ati. Pet tiꞌ uvaꞌ netaleꞌ uvaꞌ, «Ni qiloneꞌ,» chꞌex netaleꞌ, as estiꞌeꞌ uveꞌ eqꞌomal vepaaveꞌ setaꞌn,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","As ech tal veꞌt u Jesús ileꞌ: —As jik chit tuk valeꞌ, tan abꞌil uvaꞌ jitꞌeꞌch tok tziꞌ ipeꞌ unqꞌa kaneeroꞌeꞌ asoj ech tok viꞌ u peꞌeꞌ, as aꞌeꞌ u elqꞌomeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pet u uxhchileꞌ uveꞌ ech tok tziꞌ ipeꞌ unqꞌa kaneeroꞌeꞌ, as aꞌeꞌ u xeen tetz txooeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","As nijaj veꞌt u vatan tetz u kaneeroꞌeꞌ u tziꞌ peꞌeꞌ vatz u xeen txooeꞌ. As junun imolot veꞌt u xeen txooeꞌ vikaneeroꞌeꞌ tukꞌ vibꞌii txooeꞌ, tan ni texhla veꞌt unqꞌa kaneeroꞌeꞌ u tuul iviꞌ u xeen tetzeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","As tul maꞌt teqꞌot el tzan u xeen txooeꞌ unqꞌa kaneeroꞌeꞌ, as la bꞌax veꞌt naj vatz unqꞌa ikaneeroꞌeꞌ. As la xekebꞌ veꞌt txoo stiꞌ, tan tiꞌ uvaꞌ ni texhla veꞌt txoo u tuul iviꞌ u xeen tetzeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pet yeꞌ la xekebꞌ unqꞌa kaneeroꞌeꞌ tiꞌ umaj uxhchil uvaꞌ yeꞌ ootzimal u tuul iviꞌeꞌ staꞌn, tan la kuxh ooj veꞌt txoo svatz,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","As u yoleꞌ uvaꞌ tal Aak as kꞌuchuvatz kuxheꞌ. As echeꞌ pal koj chajnaj stuul kam ni tokkat u yoleꞌ uveꞌ tal Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","As ech tal veꞌt u Jesús ileꞌ: —Ileꞌ jik chit tuk val sete, tan ineꞌ u tziꞌ peꞌeꞌ uveꞌ ni tokkat unqꞌa kaneeroꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Pet unqꞌa najeꞌ uveꞌ bꞌaxel kat ul toksa tibꞌ xeen txooil, as elqꞌomeꞌ, tan nikat tal telqꞌat unqꞌa kaneeroꞌeꞌ. As yeꞌ kat inima unqꞌa kaneeroꞌeꞌ viyoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","As ineꞌ u tziꞌ ipeꞌ unqꞌa kaneeroꞌeꞌ. As jankꞌal unqꞌa kaneeroꞌeꞌ uvaꞌ in la eqꞌon ok tzan as kolel veꞌteꞌ svaꞌn. As la oki. As la eli. As bꞌaꞌnla chaj kꞌuach la techbꞌu txoo. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ech koj u elqꞌomeꞌ, tan aal kuxh la ul telqꞌa unqꞌa kaneeroꞌeꞌ. As la iyatzꞌeꞌ. As la isotzsa ivatz unqꞌa kaneeroꞌeꞌ. Pet ech koj in, tan kat ul in tiꞌ vaqꞌat itiichajil unqꞌa uxhchileꞌ uvaꞌ echeꞌ unqꞌa kaneeroꞌeꞌ. As at itiichajil unqꞌa uxhchileꞌ uveꞌ yeꞌl iyaꞌtebꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","As ineꞌ u bꞌaꞌnla xeen kaneeroꞌeꞌ tan la vaqꞌ vibꞌ kamoj tiꞌ unqꞌa unkaneeroꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pet ech koj u uxhchileꞌ uvaꞌ chooel tiꞌ ixeep unqꞌa kaneeroꞌeꞌ, tan aꞌ kuxh vijaꞌmileꞌ ni titzꞌa, tan jit tetz unqꞌa kaneeroꞌeꞌ. As tul la til u uxhchileꞌ tul umaj xoꞌ, as la ooj veꞌteꞌ. As la kuxh taqꞌ veꞌt kan u uxhchileꞌ unqꞌa kaneeroꞌeꞌ sijunal vatz u xoꞌeꞌ. As tul la itxey veꞌt u xoꞌeꞌ umaj u kaneeroꞌeꞌ, as la ipaxi veꞌt tibꞌ unqꞌa kaneeroꞌeꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","As la ooj veꞌt u xeen tetz txooeꞌ, tan tiꞌ uvaꞌ chooel kuxhtuꞌ. As jit kuxh latzꞌ unqꞌa kaneeroꞌeꞌ stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Pet ineꞌ u bꞌaꞌnla xeen txoo. As ootzimal vunkaneeroꞌeꞌ svaꞌn. As ootzimal in taꞌn vunkaneeroꞌeꞌ unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","As echat kuxh in tukꞌ vunBꞌaaleꞌ, tan ootzimal in taꞌn Aak. As ootzimal Aak svaꞌn. As ineꞌ u bꞌaꞌnla xeen txoo, tan la vaqꞌ vibꞌ kamoj tiꞌ vunkaneeroꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","As jit kuxh taꞌneꞌ vunkaneeroꞌeꞌ uvaꞌ at tzitzaꞌ. Pet atiltel txoo uvaꞌ yeꞌ atoꞌk tzan tu u peꞌeꞌ. As tuk veqꞌo ok tzan txoo, tan tuk texhla veꞌt txoo u tuul unviꞌeꞌ. As umaꞌl kuxh veꞌt peꞌ la atinkat veꞌt txoo skajayil. As umaꞌl kuxh veꞌt xeen tetz txoo la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","As ayaꞌl chit unkꞌuꞌl la vaqꞌ vibꞌ kamoj tiꞌ unqꞌa unkaneeroꞌeꞌ. As la ul vaama unpajte. Estiꞌeꞌ uvaꞌ xoꞌn chit in te vunBꞌaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","As yeꞌxhebꞌil la maon sve as echeneꞌ vitiichajileꞌ tunqꞌabꞌ. La uchi uvaꞌ la vaqꞌ itiichajil as moj la veesa tan yeꞌxhibꞌil la eesan tunqꞌabꞌ tan aꞌ vunbꞌaaleꞌ aqꞌol tetz sve,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","As tul tabꞌi veꞌt unqꞌa fariseo unqꞌa yoleꞌ uveꞌ tal u Jesús, as ok veꞌt ixoꞌl chajnaj svatzaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","As nimal unqꞌa fariseo alon uvaꞌ: —¡An chiteꞌ taꞌ u yoleꞌ uvaꞌ kat qala, tan atoꞌk u subꞌuleꞌ viꞌ taama u najeꞌ! ¡Chꞌuꞌjileꞌ elnallukat naj! ¿Kam itxaꞌk viyol najeꞌ netabꞌi?— tiꞌk unjolol chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","As ech tal unjoltu chajnaj ileꞌ: —Asoj atoꞌk subꞌul kꞌatz umaj naj, as jitꞌeꞌch iyolon najeꞌ la ibꞌaneꞌ echeꞌ u veeꞌ. ¿As la kol olebꞌ umaj subꞌul qꞌa tiꞌ ibꞌaꞌnxisal ivatz unqꞌa tzoteꞌ?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","As tul maꞌtik tok veꞌt u qꞌalaeꞌ, as nikat tuch u nimla qꞌiieꞌ tu u Jerusalén tiꞌ tulsat unqꞌa tenameꞌ skꞌuꞌl uvaꞌ kat bꞌanax veꞌt tuch u tostiixheꞌ, tan naꞌxnik teesat unqꞌa aa Roma iqꞌii u tostiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Atik u Jesús tu u tostiixheꞌ, as tul nikat ixaan Aak tu u teenta uvaꞌ Salomón ibꞌii, ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","as imol veꞌt ok tibꞌ kaꞌl unqꞌa iqꞌesal unqꞌa tenameꞌ tiꞌ u Jesús. As ech tal veꞌt chajnaj ileꞌ te Aak: —¿Jatu la aal isuuchil sqe? Asoj axh u Cristo, pet al sqe cheel xoꞌl unqꞌa tenameꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","As ech tal veꞌt u Jesús ileꞌ te chajnaj: —Tan kat val isuuchil sete. As yeꞌ nenima in. As jankꞌal unqꞌa bꞌaꞌnileꞌ uveꞌ nunbꞌaneꞌ tukꞌ vibꞌii vunBꞌaaleꞌ as aꞌeꞌ ni kꞌuchun u vijleꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pet yeꞌ nenima vunyoleꞌ, tan tiꞌ uvaꞌ jit echen ex xoꞌl vunkaneeroꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Pet ech koj vunkaneeroꞌeꞌ, tan ni tabꞌi txoo tuul unviꞌ. As ootzimal txoo svaꞌn. As nixekebꞌ txoo sviꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","As ni vaqꞌ itiichajil uvaꞌ yeꞌl iyaꞌtebꞌal. As echeꞌ jatu koj la sotz ivatz txoo. As yeꞌxhebꞌil la eesan txoo tunqꞌabꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","tan aꞌ vunBꞌaaleꞌ kat aqꞌon sve. As Aakeꞌ uvaꞌ nim talchu tiꞌ unqꞌa veeꞌ skajayil. Estiꞌeꞌ uvaꞌ yeꞌxhebꞌil la olebꞌ tiꞌ teesal tiqꞌabꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","As vatzul kuxh in tukꞌ vunBꞌaaleꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","As isikꞌ veꞌt unqꞌa uxhchileꞌ kꞌubꞌ unpajte tiꞌ isutil tiꞌ u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","As ech tal veꞌt u Jesús ileꞌ: —Nimal unqꞌa bꞌaꞌnileꞌ kat unkꞌuch sevatz taꞌn vunBꞌaaleꞌ. ¿As abꞌiste u bꞌaꞌnileꞌ qꞌi uveꞌ tuk eyatzꞌ in stiꞌ?— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ech tal veꞌt unqꞌa uxhchil ileꞌ: —Jit tiꞌ umaj bꞌaꞌnil tuk kuyatzꞌkat axh. Pet tiꞌ uveꞌ neesa iqꞌii u Tiixheꞌ, tan axh kuxh najeꞌ. Pet nu kuxh ooksa jeꞌ eebꞌ Tiixhil,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","As ech tal veꞌt u Jesús ileꞌ: —Ootzimal u yoleꞌ setaꞌn uvaꞌ tzꞌibꞌamal kan uvaꞌ ech ni tal ileꞌ: «Exeꞌ ex tiixh,» tiꞌk u Tiixheꞌ tal te unqꞌa bꞌanol isuuchil unqꞌa tenameꞌ naꞌytzan. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","As ootzimaleꞌ sqaꞌn uvaꞌ yeꞌ la uch teesal iqꞌii viyol u Tiixheꞌ. Pet techal la nimali skajayil. Asoj Tiixh kat alon uvaꞌ tiixh unqꞌa najeꞌ la ibꞌaneꞌ uvaꞌ atik tijleꞌm taꞌn Aak, ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿as kam qꞌi uvaꞌ netal sviꞌ uvaꞌ ni veesa iqꞌii u Tiixheꞌ tiꞌ kuxh uvaꞌ kat val sete uvaꞌ, «In viKꞌaol u Tiixheꞌ»? Tan Aakeꞌ kat aqꞌon u vijleꞌmeꞌ. As kat ichaj tzan in Aak xoꞌl unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Asoj yeꞌ nunbꞌaneꞌ kam uvaꞌ nibꞌan vunBꞌaaleꞌ, as yeꞌ la enima in. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pet asoj nunbꞌaneꞌ uvaꞌ nibꞌan vunBꞌaaleꞌ, as kꞌuxh yeꞌ la enima in tiꞌ unqꞌa yoleꞌ uvaꞌ ni val sete, as enimataj in tiꞌ uveꞌ nunbꞌaneꞌ aqꞌal uvaꞌ la etootzi uvaꞌ at vunBꞌaaleꞌ sunkꞌatz. As at in kꞌatz Aak,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","As itxey veꞌt unqꞌa uxhchileꞌ u Jesús skꞌuꞌl. As ooj veꞌt Aak xoꞌl chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","As bꞌen veꞌt u Jesús jalit u nimla aꞌeꞌ uvaꞌ Jordán. As atik veꞌt Aak tu u tzuukin txꞌavaꞌeꞌ uvaꞌ nikat taqꞌkat kuꞌ u Xhuneꞌ unqꞌa uxhchileꞌ xeꞌ u aꞌeꞌ tukꞌ vibꞌii u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nimal unqꞌa tenameꞌ oon veꞌt kꞌatz u Jesús. As ech tal veꞌt unqꞌa tenam ileꞌ: —An chiteꞌ vil. Kꞌuxh yeꞌ kat ikꞌuch u Xhuneꞌ umaj kꞌuchbꞌal tetz u tijleꞌm u Tiixheꞌ, as jikla yol chiteꞌ vil uveꞌ kat tal u Xhuneꞌ tiꞌ u Jesús,— tiꞌk unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Estiꞌeꞌ uvaꞌ nimal unqꞌa tenameꞌ kat ikꞌujbꞌaꞌ ikꞌuꞌl tiꞌ u Jesús tzitziꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","As umaꞌl u naj uvaꞌ Lázaro ibꞌii, as aachꞌoꞌmik naj. As echenik naj tu u tal tenam uvaꞌ Betania tukꞌ unqꞌa tanabꞌeꞌ, u Taaeꞌ tukꞌ u Maꞌleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","As u Maꞌleꞌ uvaꞌ tanabꞌ u Lázaro, as ixojeꞌ uvaꞌ kat oksan u txꞌumtxꞌulla tzꞌakabꞌaleꞌ tiꞌ toj u Jesús. As kat itzajsa veꞌt ixoj taꞌn u xiꞌl iviꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","As ichaj veꞌt bꞌen unqꞌa tanabꞌ u Lázaro umaꞌl uxhchil kꞌatz u Jesús. As ech bꞌex alpo veꞌt ileꞌ te Aak: —Pap, vixibꞌin u Taaeꞌ tukꞌ u Maꞌleꞌ uvaꞌ xoꞌn chit see, as chꞌoꞌm ni bꞌanon veꞌt naj,— tiꞌk u uxhchileꞌ tal te Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","As tul tabꞌi veꞌt u Jesús u yoleꞌ uvaꞌ tal bꞌen chaꞌma, as ech tal veꞌt Aak ileꞌ: —Yeꞌl u chꞌoꞌmeꞌ la koj chit olebꞌ tiꞌ ikam u Lázaro. Pet la oksal veꞌt iqꞌii u Tiixheꞌ tiꞌ uveꞌ tuk ibꞌan u Tiixheꞌ tiꞌ naj. As la ok veꞌt unqꞌii staꞌn, tan ineꞌ viKꞌaol u Tiixheꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","As kꞌuxh xoꞌn chit u Taaeꞌ tukꞌ u Maꞌleꞌ tukꞌ u Lázaro te Aak, ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","as tul tabꞌi Aak uvaꞌ nikat ichꞌoꞌn u Lázaro, as yeꞌl uvaꞌ yak kuxh koj el chꞌuꞌl Aak. Pet kaꞌvaꞌttel qꞌii atin kan Aak tu uveꞌ atikkat Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","As xamtik stuul, tal veꞌt Aak te unqꞌa ichusulibꞌeꞌ: —Koꞌnaj sviꞌ tu u Judea,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","As ech tal veꞌt unqꞌa ichusulibꞌ Aak ileꞌ: —Chusul, ¿ma naal veꞌt abꞌen tu u Judea unpajte? As tul ni tal unqꞌa iqꞌesal unqꞌa tenameꞌ ayatzꞌpeꞌ taꞌn kꞌubꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","As ech tal veꞌt Aak ileꞌ: —Ootzimaleꞌ setaꞌn uvaꞌ kabꞌlaval oora tuul u qꞌiieꞌ. As abꞌil uveꞌ ni xaan sqꞌiil, as yeꞌxhkam la itxꞌet toj, tan at veꞌt txijun tetz vatz u txꞌavaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pet abꞌil uvaꞌ ni xaan aqꞌbꞌal, as la itxꞌet toj, tan yeꞌl u txijun tetzeꞌ at skꞌatz,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","As tul maꞌtik talat u Jesús u yoleꞌ, as ech tal veꞌt Aak ileꞌ te unqꞌa ichusulibꞌeꞌ: —Kat vatyu vas qetz kꞌultziꞌeꞌ. Pet bꞌen in tiꞌ unbꞌeyat naj,— tiꞌk Aak tal tiꞌ u Lázaro. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","As ech tal veꞌt unqꞌa ichusulibꞌ Aak ileꞌ: —Pap, asoj kat vatyu veꞌt naj, as tuk bꞌaꞌnxoj najeꞌ bꞌa,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Pet aꞌ uveꞌ tal Aak uvaꞌ maꞌtik ikam veꞌt u Lázaro. As ech koj unqꞌa ichusulibꞌ Aakeꞌ, tan vataꞌm chit veꞌt nik ibꞌan u Lázaro uvaꞌ nik tal jeꞌ chajnaj ste. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","As tal veꞌt Aak isuuchil te chajnaj. As ech tal Aak ileꞌ: —Kat kamyu u Lázaro. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","As nuntxuqꞌtxun stiꞌ uvaꞌ yeꞌl in at in tzitziꞌ, tan setiꞌ la txakonkat tiꞌ uvaꞌ la ekꞌujbꞌaꞌ ekꞌuꞌl sviꞌ. Pet koꞌnaj qila,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","As ech tal veꞌt u Maxh ileꞌ uvaꞌ Dídimo: —Koꞌnaj bꞌa unpajte. Eela kukam tukꞌ Aak,— tiꞌk naj tal te unqꞌa imooleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","As tul oon veꞌt u Jesús najlich u Betania, as tabꞌi veꞌt Aak uvaꞌ kajvaꞌxnik qꞌii imujax veꞌt u Lázaro. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","As pal pokꞌoꞌchil iꞌl ixoꞌl u Betania tukꞌ u Jerusalén. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","As estiꞌeꞌ yeꞌ saach unqꞌa aa Jerusalén ul yakꞌinsan taama u Taaeꞌ tukꞌ u Maꞌleꞌ tiꞌ uvaꞌ kat kam u Lázaro. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","As tul tabꞌi veꞌt u Taaeꞌ uvaꞌ unbꞌiitik kuxh toon veꞌt u Jesús, as qꞌax tel chꞌuꞌl ixoj. Bꞌex ikꞌul veꞌt ixoj u Jesús tu bꞌey. Pet ech koj u Maꞌleꞌ tan kat kaa ixoj tu kabꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","As ech tal veꞌt u Taa ileꞌ te u Jesús: —Pap, atik koj axh tzitzaꞌ, as yeꞌleꞌxh vunxibꞌineꞌ kat kami. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pet ootzimal svaꞌn uvaꞌ kam kuxh bꞌaꞌnil la ajaj te u Tiixheꞌ as la taqꞌ Aak see,— tiꞌk u Taaeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","As ech tal Aak ileꞌ: —Tuk uloj taamaeꞌ vaxibꞌineꞌ— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","As ech tal veꞌt u Taa ileꞌ: —Kano qꞌi. Ootzimaleꞌ svaꞌn uvaꞌ la chit ul taama vunxibꞌineꞌ tul la ul taama unqꞌa kamnajeꞌ timoxtel qꞌii,— tiꞌk ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","As ech tal veꞌt Aak ileꞌ: —Ineꞌ la ulsan taama unqꞌa kamnajeꞌ. As ineꞌ aqꞌol tetz itiichajil. As jankꞌal unqꞌa uxhchileꞌ uveꞌ la ikꞌujbꞌaꞌ ikꞌuꞌl sviꞌ as at chit itiichajileꞌ, kꞌuxh maꞌt ikameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","As jankꞌal unqꞌa uxhchileꞌ uveꞌ isleꞌle as kꞌujleꞌl ikꞌuꞌl sviꞌ, as yeꞌxh jatueꞌ la kam u taanxelaleꞌ vatz u Tiixheꞌ. ¿Ma nanima u yoleꞌ uveꞌ ni val see?— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","As ech tal u Taa ileꞌ: —Kano, Pap. Kat unnimaleꞌ uvaꞌ axheꞌ u Cristo. As axheꞌ viKꞌaol u Tiixheꞌ uvaꞌ kat ulyu vatz u txꞌavaꞌeꞌ,— tiꞌk ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","As tul kuxh tal u Taaeꞌ u yoleꞌ te u Jesús, as qꞌaav veꞌt ixoj tu kabꞌal. Bꞌex ijas veꞌt ok ixoj te u Maꞌleꞌ uvaꞌ: —Il u Chusul kat ulya. As nimolo axh Aak,— tiꞌk u Taaeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","As tul tabꞌi veꞌt u Maꞌleꞌ u yoleꞌ uvaꞌ tal u Taaeꞌ ste, as qꞌax tel veꞌt chꞌuꞌl ixoj tiꞌ bꞌen tilat u Jesús, ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","tan yeꞌxnik oon Aak tu u tal tenameꞌ. Pet atiliktel Aak tu uveꞌ ikꞌulkat tibꞌ Aak tukꞌ u Taaeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","As tul til unqꞌa uxhchileꞌ uveꞌ atik tikabꞌal chaꞌma tiꞌ iyakꞌinsal taama chaꞌma vatz u txumuꞌmeꞌ, uvaꞌ qꞌax tel chꞌuꞌl u Maꞌleꞌ, as xekebꞌ veꞌt el tzan unqꞌa uxhchileꞌ tiꞌ ixoj, tan kamal yakik ixoj tu uveꞌ mujlukat u Lázaro tiꞌ toqꞌ sijunal uveꞌ nikat tal unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","As tul oon veꞌt u Maꞌleꞌ kꞌatz u Jesús tu uveꞌ atikkat Aak, as kuꞌ veꞌt ixoj qaaloj vatz Aak. As ech tal veꞌt ixoj ileꞌ: —Pap, atik koj axh taꞌ tzitzaꞌ, as yeꞌleꞌxh vunxibꞌineꞌ kat kami,— tiꞌk ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","As til veꞌt u Jesús uvaꞌ nik toqꞌ u Maꞌleꞌ tukꞌ unqꞌa uxhchileꞌ uveꞌ xekik tiꞌ ixoj. As ok veꞌt umaꞌl u mam txumuꞌm tu u taanxelal Aak tiꞌ uvaꞌ kat kam u Lázaro taꞌn u chꞌoꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","As ech tal veꞌt Aak ileꞌ: —¿Katil qꞌi kat emujkat u Lázaro?— tiꞌk Aak. Ech tal veꞌt unqꞌa uxhchil ileꞌ: —Siꞌu, Pap. Koꞌ qileꞌ,— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","As oqꞌ veꞌt u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","As ech tal veꞌt unqꞌa uxhchil ileꞌ: —Xoꞌnik chit najeꞌ te Aak,— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pet ech tal veꞌt kaꞌt unqꞌa uxhchil ileꞌ: —Kat ibꞌaꞌnxisa naj ivatz u tzoteꞌ. ¿As kam qꞌi uvaꞌ yeꞌ kat olebꞌ naj tiꞌ uvaꞌ yeꞌ koj kat kam u Lázaro?— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Aal chit kat txumun veꞌt u Jesús. As jetzꞌen veꞌt ok Aak tziꞌ u juleꞌ uvaꞌ mujlukat u Lázaro. As jupik itziꞌ u juleꞌ taꞌn umaꞌl u nimla kꞌubꞌ, tan kꞌotik ok u juleꞌ vatz umaꞌl u piꞌun. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","As ech tal veꞌt u Jesús ileꞌ: —Eteesataj el u kꞌubꞌeꞌ tziꞌ u juleꞌ,— tiꞌk Aak tal te unqꞌa uxhchileꞌ. As ech tal veꞌt u Taa ileꞌ te u tanabꞌ u Lázaro: —As xev veꞌteꞌ, Pap, tan kajvaꞌx qꞌii imujlu veꞌt naj,— tiꞌk ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","As ech tal veꞌt u Jesús ileꞌ: —¿Ma yeꞌ kat val bꞌa see uvaꞌ asoj la akꞌujbꞌaꞌ akꞌuꞌl sviꞌ as la chit eeleꞌ uvaꞌ nim chit talcheꞌ u Tiixheꞌ?— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","As teesa veꞌt unqꞌa uxhchileꞌ u kꞌubꞌeꞌ tziꞌ u juleꞌ. As sajin veꞌt jeꞌ u Jesús tu almikaꞌ. As ech tal veꞌt Aak ileꞌ: —Taꞌntiixh see, unBꞌaal, tan kat aabꞌil vunyoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","As ootzimal svaꞌn uvaꞌ naabꞌi vunyoleꞌ bꞌenameen. Pet tiꞌ kuxh veꞌt unqꞌa tenameꞌ uveꞌ at sunkꞌatz as ni val see, aqꞌal uvaꞌ la inima unqꞌa uxhchileꞌ uvaꞌ axh kat chajon tzan in,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","As tul tzojpu veꞌt inachat Aak Tiixh, as taqꞌ veꞌt jeꞌ Aak tuul iviꞌ. As sikꞌin veꞌt Aak. Ech tal Aak ileꞌ: —¡Lázaro, elen chꞌuꞌl tu u juleꞌ!— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","As el veꞌt chꞌuꞌl u Lázaro tu u juleꞌ. As ech tal veꞌt Aak ileꞌ te unqꞌa uxhchileꞌ: —Esaaputaj naj, aqꞌal uvaꞌ la xaan veꞌt naj,— tiꞌk Aak, tan bꞌochelik naj tu u maantaeꞌ tukꞌ iqꞌabꞌ tukꞌ toj. As jupik ivatz naj taꞌn suꞌt unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","As tul til veꞌt unqꞌa uxhchileꞌ uveꞌ xekik tiꞌ u Maꞌleꞌ u nimla bꞌaꞌnileꞌ uveꞌ ibꞌan u Jesús, as yeꞌ saach unqꞌa uxhchileꞌ ikꞌujbꞌaꞌ veꞌt ikꞌuꞌl tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pet ech koj kaꞌt unqꞌa uxhchileꞌ, tan bꞌex tal veꞌt te unqꞌa fariseo kam uveꞌ ibꞌan u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","As imol veꞌt tibꞌ unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh tukꞌ unqꞌa fariseo tiꞌ ibꞌanat inukꞌu. As ech tal veꞌt chajnaj ileꞌ: —¿Kam tuk kubꞌaneꞌ? Tan mamaꞌla kꞌuchbꞌal tetz u tijleꞌm najeꞌ nikꞌuch vatz unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Asoj yeꞌxhkam kuxh tuk kubꞌaneꞌ, as tuk mox inima unqꞌa tenameꞌ viyol najeꞌ. As tuk uloj unqꞌa isol u ijlenaaleꞌ tu u Roma. As tuk teꞌpu chajnaj u kutostiixheꞌ. As la sotzsal u kutenameꞌ skajayil,— tiꞌk chajnaj svatzaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","As yolon veꞌt umaꞌl u naj xoꞌl chajnaj uvaꞌ Caifás ibꞌii uvaꞌ atik ok siqꞌesalil oksan iyol tenam vatz Tiixh tu u yaabꞌeꞌ. As ech tal naj ileꞌ: —¡Yeꞌ etootza uvaꞌ nim talcheꞌ u yoleꞌ! ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿As ma yeꞌ nepal stuul uvaꞌ aal bꞌaꞌneꞌ uvaꞌ la kam umaj naj tiꞌ u kutenameꞌ, aqꞌal uvaꞌ yeꞌl u tenameꞌ la sotzi?— tiꞌk u Caifás. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Echeꞌ tal kuxh koj u Caifás u yoleꞌ tukꞌ itxumbꞌal. Pet tiꞌ uveꞌ naj iqꞌesal oksan iyol tenam vatz Tiixh tu u yaabꞌeꞌ, estiꞌeꞌ kat tal veꞌt naj u yoleꞌ taꞌn u Tiixheꞌ uvaꞌ la chit kam u Jesús tiꞌ unqꞌa tenameꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","As jit kuxh tiꞌ unqꞌa tiaal Israel la kamkat u Jesús. Pet tiꞌ uvaꞌ yeꞌl ixoꞌl unqꞌa tenameꞌ la ibꞌaneꞌ taꞌn u Jesús, aqꞌal uvaꞌ unvatzul kuxh veꞌt unqꞌa tenameꞌ la ibꞌan vatz u Tiixheꞌ, kꞌuxh paxin tibꞌ unqꞌa tenameꞌ vatz u txꞌavaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Estiꞌeꞌ ikꞌujbꞌaꞌ veꞌt unqꞌa iqꞌesal unqꞌa tenameꞌ uvaꞌ la kam u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","As yeꞌ nikat ikꞌuch veꞌt tibꞌ u Jesús xoꞌl unqꞌa tenameꞌ. Pet el veꞌt chꞌuꞌl Aak tu u Betania. As bꞌen veꞌt Aak tu umaꞌt u tenam uvaꞌ Efraín, najlich veꞌt u tzuukin txꞌavaꞌeꞌ. As tzitziꞌ atinkat veꞌt Aak tukꞌ unqꞌa ichusulibꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","As unbꞌiitik kuxh ilejat veꞌt u nimla qꞌiieꞌ uvaꞌ pascua, uvaꞌ nikat inima unqꞌa tiaal Israel. As yeꞌ saach unqꞌa uxhchileꞌ tzaa tulaj itenam tiꞌ tul tu u Jerusalén tiꞌ teesat el u vaꞌlexheꞌ stiꞌ vatz u Tiixheꞌ jaqꞌ u nimla qꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","As nikat ichuk unqꞌa uxhchileꞌ u Jesús xoꞌl unqꞌa tenameꞌ tu u tostiixheꞌ. As ech nikat tal ileꞌ svatzaj: —¿Kam ni tal etaama? ¿Ma tul u Jesús tu u nimla qꞌiieꞌ moj yeꞌle?— tiꞌk unqꞌa uxhchileꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","tan maꞌtik talax el tzan te unqꞌa tenameꞌ skajayil taꞌn unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh tukꞌ unqꞌa fariseo, uvaꞌ: —Asoj at umaj ex ootzin tetz uvaꞌ kat atkat u Jesús, as la etal sqe, aqꞌal uvaꞌ jik kuxh qooneꞌ tiꞌ kutxeyat naj,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ech veꞌt vaajit qꞌii tul u nimla qꞌiieꞌ uvaꞌ pascua, as qꞌaav veꞌt u Jesús tu u Betania uveꞌ atikkat u Lázaro uvaꞌ kami, uvaꞌ maꞌtik tulsat Aak taama unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","As ibꞌan veꞌt unqꞌa tanabꞌ u Lázaro tuch umaꞌl u bꞌaꞌnla txꞌaꞌoꞌm kuꞌqꞌii tiꞌ toksal iqꞌii u Jesús. As nikat iqꞌajsa u Taaeꞌ unqꞌa taꞌleꞌ. As xonlik u Lázaro vatz u meexhaeꞌ tukꞌ u Jesús tiꞌ itxꞌaꞌneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","As teqꞌo veꞌt tzan u Maꞌleꞌ umaꞌl lemeeta u txꞌumtxꞌulla tzꞌakabꞌaleꞌ uvaꞌ jeꞌnal chit ijaꞌmil. As toksa ixoj tiꞌ toj u Jesús, as itzajsa veꞌt ixoj taꞌn u xiꞌl iviꞌeꞌ. Vaꞌlik chit itxꞌumtxꞌul veꞌt tuul u kabꞌaleꞌ taꞌn u txꞌumtxꞌulla tzꞌakabꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","As ech tal veꞌt umaꞌl vichusulibꞌ u Jesús ileꞌ uvaꞌ la kꞌayin Aak, u Iscariote uvaꞌ Judas ibꞌii: ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Kam qꞌi uvaꞌ kat koj kꞌayil u txꞌumtxꞌulla tzꞌakabꞌaleꞌ? Tan jeꞌnal chit ijaꞌmil. Kamal oꞌlaval kꞌalal (300) qꞌii aqꞌon ijaꞌmil. As kat koj aqꞌax vijaꞌmileꞌ te unqꞌa meebꞌaꞌeꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","As yeꞌl uvaꞌ aꞌ koj chit unqꞌa meebꞌaꞌeꞌ nikat itxum naj ivatz. Pet nikat telqꞌa naj u puajeꞌ, tan naj kololik tetz u puajeꞌ xoꞌl chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","As ech tal veꞌt u Jesús ileꞌ te naj: —¡Yeꞌxhkam kuxh etal tiꞌ u ixojeꞌ! Tan kolel u txꞌumtxꞌulla tzꞌakabꞌaleꞌ taꞌn ixoj. As texhlal tetz u qꞌiieꞌ nibꞌan ixoj tul uvaꞌ la mujlu veꞌt in, ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","tan echeꞌ bꞌenameen koj la atin in sexoꞌl. Pet ech koj unqꞌa meebꞌaꞌeꞌ, tan at chiteꞌ tuk ibꞌan sexoꞌl,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","As tul tabꞌi veꞌt unqꞌa tenameꞌ uvaꞌ atik u Jesús tu u Betania, as yeꞌ saach unqꞌa tenameꞌ bꞌex tu u Betania tiꞌ bꞌen tilat u Jesús tukꞌ u Lázaro, tan tiꞌ uvaꞌ maꞌtik tulsat Aak taama u Lázaro. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Estiꞌeꞌ ichuk unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh txumbꞌal tiꞌ iyatzꞌat veꞌt u Lázaro tukꞌ u Jesús, ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","tan ipaav kuxh u Lázaro uveꞌ yeꞌ saach unqꞌa tenameꞌ nikat teesa veꞌt tibꞌ kꞌatz unqꞌa iqꞌesal unqꞌa nachol Tiixheꞌ. As nikat ikꞌujbꞌaꞌ veꞌt ikꞌuꞌl tiꞌ u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ech veꞌt qꞌejal stuul, as tabꞌi veꞌt unqꞌa mamaꞌla tenameꞌ uvaꞌ la oon veꞌt u Jesús tu u Jerusalén, tan yeꞌ saach unqꞌa tenameꞌ maꞌtik toon veꞌt tu u Jerusalén tiꞌ u nimla qꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","As teqꞌo veꞌt unqꞌa tenameꞌ xaj chꞌiꞌm. As el veꞌt chꞌuꞌl tu u Jerusalén tiꞌ ikꞌulax veꞌt u Jesús tziꞌ u tenameꞌ. As tul til veꞌt unqꞌa tenameꞌ tul Aak, as taqꞌ veꞌt jeꞌ tuul iviꞌ. As ech tal ileꞌ: —¡Qoksataj iqꞌii Aak, tan achvebꞌal chit tul Aak tukꞌ vibꞌii u Kubꞌaal Tiixheꞌ! ¡As Aakeꞌ u Qijlenaaleꞌ, oꞌ uvaꞌ oꞌ tiaal Israel!— tiꞌk unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","As tul ilej Aak umaꞌl u tal bꞌur, as jeꞌ veꞌt Aak tiꞌ txoo echeꞌ uvaꞌ alel kan tu viyol u Tiixheꞌ, tan ech ni tal viyol u Tiixh ileꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Yeꞌ kuxh xoꞌv ex, jankꞌal ex uvaꞌ ex aa Sion, tan il vetijlenaal ileꞌ tuleꞌ uvaꞌ at jeꞌ tiꞌ umaꞌl u tal bꞌur, tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","As jit pal unqꞌa ichusulibꞌ Aakeꞌ stuul kam uvaꞌ nik tucheꞌ. Pet tul oksal veꞌt iqꞌii Aak, as aꞌn ul veꞌt skꞌuꞌl chajnaj uvaꞌ tzꞌibꞌamalik kan tu viyol u Tiixheꞌ uvaꞌ kam la ulbꞌel Aak. As aꞌn pal veꞌt chajnajeꞌ stuul uvaꞌ kat chit ibꞌana uvaꞌ tzꞌibꞌamal kan tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","As unqꞌa uxhchileꞌ uveꞌ ilon isikꞌlet el tzan Aak u Lázaro tu u juleꞌ, as bꞌex tal veꞌt unqꞌa uxhchileꞌ xoꞌl u tenameꞌ uveꞌ jit ilon, kam uveꞌ kat uchi tiꞌ u Lázaro. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Estiꞌeꞌ el chꞌuꞌl unqꞌa tenameꞌ tiꞌ ikꞌulpu u Jesús, tan tiꞌ uvaꞌ abꞌil itzibꞌlal u kꞌuchbꞌal tetz u tijleꞌm Aakeꞌ, tan tiꞌ uvaꞌ ul taama u Lázaro taꞌn Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pet ech koj unqꞌa fariseo, tan ech tal chajnaj ileꞌ svatzaj: «¡As ileꞌ kat ikꞌuchlu veꞌteꞌ uvaꞌ yeꞌ la olebꞌ oꞌ tiꞌ u najeꞌ, tan kajayil chit veꞌt unqꞌa tenameꞌ xekel veꞌt tiꞌ naj!» tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","As atik jolol unqꞌa uxhchil uvaꞌ jit tiaal Israel xoꞌl unqꞌa tenameꞌ uvaꞌ maꞌtik toon tu u Jerusalén tiꞌ inachat Tiixh tu u nimla qꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","As jetzꞌen veꞌt ok unqꞌa uxhchileꞌ kꞌatz u Piꞌleꞌ uvaꞌ tzaanaj tu u Betsaida uvaꞌ echen tu u Galilea. As ech tal veꞌt ileꞌ: —Bꞌan bꞌaꞌnil. Kꞌuch u Jesús sqe, tan nu kusaꞌ qilat Aak,— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","As bꞌex tal veꞌt u Piꞌleꞌ te u Lixheꞌ kam uvaꞌ kat tal unqꞌa uxhchileꞌ. As bꞌex veꞌt chajnaj tiꞌ talat u yoleꞌ te u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","As ech tal veꞌt u Jesús ileꞌ te chajnaj: —Najli veꞌt u qꞌiieꞌ uvaꞌ la bꞌen veꞌt VIKꞌAOL U NAJEꞌ kꞌatz viBꞌaaleꞌ unpajte, as la oksal veꞌt iqꞌii. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Estiꞌeꞌ jik chit tuk val sete, asoj la kaa u iiaeꞌ tetz u trigo tu txꞌavaꞌ asoj yeꞌ la kami as yeꞌle bꞌa la xalmiti, as la kuxh atineꞌ bꞌa tzitziꞌ. Asoj la kami as la xalmiti, nimal ivatzeꞌ bꞌa la taqꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Abꞌil uvaꞌ xoꞌn vitiichajileꞌ ste vatz u txꞌavaꞌeꞌ, as la itzꞌejeꞌ. Abꞌil uveꞌ ni tixva vitiichajileꞌ vatz u txꞌavaꞌeꞌ, as xoꞌneꞌ bꞌa vitiichajileꞌ ste uveꞌ yeꞌl iyaꞌtebꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","As abꞌil uvaꞌ la niman in as la xekebꞌ sviꞌ, tan katil uveꞌ atkat in, as tzitziꞌ la atinkat u niman vetzeꞌ. As abꞌil uveꞌ la niman in, as la toksa vunBꞌaaleꞌ iqꞌii. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","As cheel tan vaꞌl chit itxumun vaama. ¿As kam qꞌi la valeꞌ? ¿Ma ech la val ileꞌ: «UnBꞌaal, kol in vatz u kꞌaxkꞌoeꞌ uvaꞌ kꞌujlu kan sviꞌ,» ma chaj in la valeꞌ? Yeꞌle taꞌ, tan aꞌ stiꞌeꞌ kat ulkat in,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","As ech tal u Jesús ileꞌ unpajte: —UnBꞌaal, kꞌuch kuꞌ tzan u eejleꞌmeꞌ vatz unqꞌa tenameꞌ,— tiꞌk Aak. As kat abꞌil umaꞌl u tuul viꞌ tu almikaꞌ. Ech tal ileꞌ: —Kat unkꞌuchleꞌ uvaꞌ nivoksa aqꞌii vatz unqꞌa tenameꞌ. As tuk voksa aqꞌii unpajte,— tiꞌk u tuul viꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","As jankꞌal chit unqꞌa tenameꞌ uveꞌ atike as tabꞌi u tuul viꞌeꞌ tu almikaꞌeꞌ. As yeꞌ kat pal stuul. As at unjolol unqꞌa uxhchileꞌ kat alon uvaꞌ: —Qꞌankooeꞌ kat tiini.— As unjolte kat alon uvaꞌ: —Umaj ángel kat yolon tukꞌ Aak,— tiꞌke. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","As ech tal veꞌt Aak ileꞌ xoꞌl unqꞌa tenameꞌ: —Echeꞌ sviꞌ koj kat yolonkat kuꞌ tzan u tuul viꞌeꞌ. Pet setiꞌeꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","tan kat ilejlu veꞌt u qꞌiieꞌ uvaꞌ tuk bꞌanaxoj veꞌt isuuchil unqꞌa tenameꞌ vatz u txꞌavaꞌeꞌ. As tuk laqꞌbꞌaloj el u txꞌiꞌlanajeꞌ uveꞌ ni toksa tibꞌ sbꞌooqꞌolil tiꞌ unqꞌa tenameꞌ uveꞌ at vatz u txꞌavaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","As tul la aqꞌpik jeꞌ in vatz u kuruseꞌ, as la unmutxbꞌe unqꞌa tenameꞌ skajayil tiꞌ tok sunkꞌatz,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","As tal Aak u yoleꞌ tiꞌ uvaꞌ la pal unqꞌa tenameꞌ stuul tiꞌ uvaꞌ kam ikam Aak la kami. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","As ech tal veꞌt unqꞌa tenam ileꞌ te Aak: —Tan abꞌimal viyol u Tiixheꞌ sqaꞌn uvaꞌ tul la ul u Cristo vatz u txꞌavaꞌeꞌ, as la atin veꞌteꞌ tiꞌ chit ibꞌeneꞌ. ¿As kam ni tokkat u yoleꞌ qꞌi uveꞌ naaleꞌ uvaꞌ: «Techal chit la aqꞌpik jeꞌ VIKꞌAOL U NAJEꞌ vatz u kuruseꞌ,» chꞌaxh naaleꞌ? ¿Abꞌiste qꞌi VIKꞌAOL U NAJEꞌ uveꞌ naaleꞌ?— tiꞌk unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","As ech tal veꞌt u Jesús ileꞌ: —Unbꞌiitoj kuxheꞌ tuk atinoj in sexoꞌl tiꞌ untxijut ex, tan ineꞌ u txijun etetzeꞌ. As xaanojtaj ex vatz u sajeꞌ tul uvaꞌ yeꞌxnaj bꞌen in, aqꞌal uvaꞌ yeꞌ la ul u qꞌej toktoeꞌ setiꞌ. As yeꞌ la kaa ex tu u qꞌej toktoeꞌ, tan abꞌil la xaan tu u qꞌej toktoeꞌ, as yeꞌ tootzaj katil kꞌajelkat staꞌn. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","As ekꞌujbꞌaꞌtaj ekꞌuꞌl sviꞌ tul uvaꞌ at in sexoꞌl tiꞌ etxijuleꞌ, aqꞌal uvaꞌ ex la txijun veꞌt unqꞌa tenameꞌ unpajte,— tiꞌk Aak. As tul kuxh yaꞌ u Jesús tiꞌ iyoloneꞌ, as bꞌen veꞌt Aak. As imuj veꞌt tibꞌ Aak vatz unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","As kꞌuxh nimal unqꞌa kꞌuchbꞌal tetz viyakꞌil Aakeꞌ maꞌtik ibꞌanataꞌ vatz unqꞌa tenameꞌ, as yeꞌ nik ikꞌujbꞌaꞌ unqꞌa tenameꞌ ikꞌuꞌl tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","As ech kat ibꞌaneꞌ uvaꞌ itzꞌibꞌa kan u Isaías, u qꞌajsan tetz viyol u Tiixheꞌ, uvaꞌ ech ni tal ileꞌ: Kubꞌaal Tiixh, yeꞌxhebꞌil chit ni niman vayoleꞌ uveꞌ ni val xoꞌl u tenameꞌ. As mitaꞌn nipal unqꞌa tenameꞌ stuul jankꞌal uvaꞌ kat akꞌuch ste, tiꞌk u Isaías. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Estiꞌeꞌ uvaꞌ yeꞌ kat uch ikꞌujbꞌaꞌt unqꞌa tenameꞌ ikꞌuꞌl tiꞌ u Jesús, tan ech kat ibꞌan unqꞌa tenameꞌ echeꞌ ni tal umaꞌt u yol uvaꞌ itzꞌibꞌa kan u Isaías uvaꞌ ech ni tal ileꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","As Tiixheꞌ kat bꞌanon uvaꞌ yeꞌ nikat ibꞌen te unqꞌa tenameꞌ tiꞌ unqꞌa kꞌuchbꞌal tetz vibꞌaꞌnil Aakeꞌ. As an chit Aakeꞌ kat bꞌanon uvaꞌ yeꞌ nikat tok xeꞌ taama unqꞌa tenameꞌ tiꞌ inimal Aak. Estiꞌeꞌ uvaꞌ ech tal Aak ileꞌ: «Yeꞌ kat til unqꞌa tenameꞌ jankꞌal uvaꞌ kat unkꞌuch ste. As yeꞌ kat pal stuul. As yeꞌ kat ijalpu vitxumbꞌaleꞌ tiꞌ uvaꞌ la unsotzsa ipaav,» tiꞌk u Tiixheꞌ, taqꞌ u yoleꞌ uvaꞌ itzꞌibꞌa kan u Isaías. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","As tal veꞌt u Isaías unqꞌa yoleꞌ, tan tiꞌ uvaꞌ maꞌtik tilat veꞌt u Isaías uvaꞌ nim talchu u Tiixheꞌ. As tal veꞌt kan u Isaías kaꞌl unqꞌa yol tiꞌ u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","As kꞌuxh ech u yoleꞌ uvaꞌ tzꞌibꞌamal kan, as nimal unqꞌa iqꞌesal unqꞌa tenameꞌ ikꞌujbꞌaꞌ ikꞌuꞌl tiꞌ u Jesús. Pet yeꞌ nikat tal tibꞌ vatz unqꞌa fariseo uvaꞌ nik inima chajnaj Aak, tan yeꞌ nikat isaꞌ chajnaj uvaꞌ la laqꞌbꞌal el tzan chajnaj tu u atinbꞌaleꞌ tetz nachbꞌal Tiixh taꞌn unqꞌa fariseo. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","As aꞌ nikat isaꞌ chajnaj uvaꞌ la oksal iqꞌii chajnaj taꞌn unqꞌa uxhchileꞌ. Pet jit uvaꞌ aꞌ koj nisaꞌ chajnaj uvaꞌ la oksal iqꞌii chajnaj taꞌn u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","As taqꞌ veꞌt jeꞌ u Jesús tuul iviꞌ xoꞌl unqꞌa uxhchileꞌ. As ech tal veꞌt Aak ileꞌ: —Jankꞌal unqꞌa uxhchileꞌ uveꞌ kꞌujleꞌl ikꞌuꞌl sviꞌ as jit kuxh ineꞌ uvaꞌ nikꞌujbꞌaꞌ ikꞌuꞌl sviꞌ. Pet antu u chajol tzan vetzeꞌ kat ikꞌujbꞌaꞌ ikꞌuꞌl stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","As jankꞌal unqꞌa uxhchileꞌ uveꞌ ni exhlan in as an chit u chajol tzan vetzeꞌ ni texhla unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","As ineꞌ u txijun tetz u taanxelal unqꞌa uxhchileꞌ skajayil. Estiꞌeꞌ kat ulkat in vatz u txꞌavaꞌeꞌ, aqꞌal uvaꞌ abꞌil la ikꞌujbꞌaꞌ ikꞌuꞌl sviꞌ as yeꞌ la atin veꞌt u taanxelaleꞌ tu u qꞌej toktoeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Pet ech koj unqꞌa uxhchileꞌ uveꞌ ni abꞌin vunyoleꞌ as yeꞌ ninima, tan jit ineꞌ taꞌ la bꞌanon isuuchil, tan yeꞌl in kat koj ul in tiꞌ unbꞌanat isuuchil unqꞌa tenameꞌ. Pet kat ul in tiꞌ iqꞌalpul unqꞌa uxhchileꞌ vatz vipaaveꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","As abꞌil uvaꞌ la ixvan in as yeꞌ la inima unqꞌa yoleꞌ uvaꞌ ni val ste, as at umaꞌl u bꞌanol tetz isuuchil. As unqꞌa yoleꞌ uveꞌ ni valeꞌ as aꞌeꞌ la itxakonsa u Tiixheꞌ tiꞌ ibꞌanax isuuchil unqꞌa uxhchileꞌ tu unqꞌa qꞌiieꞌ uvaꞌ tuk uloj, ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","tan yeꞌl in nunyolon tukꞌ untxumbꞌal. Pet aꞌ vunBꞌaaleꞌ, u chajol tzan vetzeꞌ, as Aakeꞌ kat alon sve uvaꞌ kam unqꞌa yoleꞌ la ul val sexoꞌl. ");
INSERT INTO ixlNNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","As ootzimal veꞌt svaꞌn uvaꞌ aꞌ unqꞌa yoleꞌ uvaꞌ kat tal vunBꞌaaleꞌ sve ni aqꞌon itiichajil uveꞌ yeꞌl iyaꞌtebꞌal. Estiꞌeꞌ kam uvaꞌ kat tal vunBꞌaaleꞌ sve, as aꞌeꞌ ni val sete,— tiꞌk u Jesús tal xoꞌl unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","As ech unbꞌiit ixeꞌt u nimla qꞌiieꞌ uvaꞌ pascua. As ootzimal taꞌn u Jesús uvaꞌ bꞌiit kuxh ilejat u qꞌii tiꞌ taqꞌat kan Aak u vatz txꞌavaꞌeꞌ tiꞌ iqꞌaav veꞌt Aak kꞌatz u Kubꞌaaleꞌ tu almikaꞌ. As ixoꞌni veꞌt Aak unqꞌa niman tetzeꞌ uveꞌ atik vatz u txꞌavaꞌeꞌ. As yeꞌ kat yaꞌ Aak tiꞌ ixoꞌnileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","As tul nikat itxꞌaꞌn veꞌt Aak tukꞌ unqꞌa ichusulibꞌeꞌ tu u kuꞌqꞌiieꞌ tiꞌ inimal u nimla qꞌiieꞌ, as maꞌtik toksat veꞌt u txꞌiꞌlanajeꞌ vitxumbꞌaleꞌ tu u taanxelal u Judas uvaꞌ Iscariote, vikꞌaol u Simón, tiꞌ toksal ok Aak tiqꞌabꞌ unqꞌa iqꞌesal unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Tan ootzimalik taꞌn Aak uvaꞌ maꞌtik taqꞌat u Kubꞌaal Tiixheꞌ unqꞌa veeꞌ skajayil tiqꞌabꞌ Aak. As ootzimalik taꞌn Aak uvaꞌ xeꞌ u Tiixheꞌ tzaanajkat Aak, as la qꞌaav veꞌt Aak kꞌatz u Tiixheꞌ unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","As txakpu veꞌt Aak. As teesa veꞌt Aak umaꞌl u toksaꞌm. As ikꞌal veꞌt ok Aak umaꞌl u ixbꞌuꞌj xeꞌ tuul. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Taqꞌ veꞌt kuꞌ Aak aꞌ tu umaꞌl u nimla lekbꞌal aꞌ. As xeꞌt itxꞌaa veꞌt Aak tiꞌ toj unqꞌa ichusulibꞌeꞌ. As itzajsa veꞌt Aak unqꞌa tiꞌ toj chajnajeꞌ taꞌn ixbꞌuꞌj uveꞌ kꞌalik ok xeꞌ tuul Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","As tul oon veꞌt Aak kꞌatz u Simón uvaꞌ Luꞌ tiꞌ itxꞌaat Aak u tiꞌ toj najeꞌ, as ech tal veꞌt u Luꞌ ileꞌ te Aak: —Yeꞌ la ibꞌaneꞌ taꞌ, Pap, uvaꞌ axh la txꞌaaon u tiꞌ vojeꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","As ech tal veꞌt Aak ileꞌ: —Yeꞌ la pal axheꞌ stuul kam uveꞌ nunbꞌaneꞌ. As xamtel, as aꞌn la pal veꞌt axh stuul,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","As ech tal veꞌt u Luꞌ ileꞌ: —¡Aꞌeꞌ yeꞌ la uchi uvaꞌ la atxꞌaa u tiꞌ vojeꞌ!— tiꞌk naj. As ech tal veꞌt Aak ileꞌ: —Asoj yeꞌ la untxꞌaa u tiꞌ avoj, as yeꞌl ookebꞌal sunkꞌatz,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","As ech tal veꞌt u Luꞌ ileꞌ: —Pap, jit kuxh u tiꞌ vojeꞌ la atxꞌaaeꞌ. Pet antu unqꞌa tiꞌ unqꞌabꞌeꞌ tukꞌ vunviꞌeꞌ unpajte,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","As ech tal veꞌt Aak ileꞌ: —Abꞌil uveꞌ txꞌaael veꞌt tiꞌ as jit tzꞌajinaleꞌ la txꞌaap veꞌt tiꞌ skajayil. Pet taꞌn kuxh u tiꞌ tojeꞌ la txꞌaap veꞌteꞌ, tan yeꞌl veꞌt tzꞌil tiꞌ vichiꞌoleꞌ. Echeꞌ ex tan yeꞌl tzꞌil setiꞌ. As jik chit veꞌt etxumbꞌal, as kꞌuxh jit kajayil ex,— tiꞌk Aak, ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","tan tiꞌ uvaꞌ ootzimal veꞌt taꞌn Aak uvaꞌ abꞌil la aqꞌon ok Aak tiqꞌabꞌ unqꞌa iqꞌesal unqꞌa tenameꞌ. Estiꞌeꞌ uveꞌ tal Aak: —Jit kajayil ex uvaꞌ jik vetxumbꞌaleꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","As tul bꞌaꞌnxi itxꞌaat veꞌt Aak u tiꞌ toj chajnajeꞌ, as toksa veꞌt Aak u toksaꞌmeꞌ uvaꞌ teesa tul sixeꞌt Aak tiꞌ itxꞌaat u tiꞌ toj chajnajeꞌ. As xonebꞌ veꞌt Aak vatz u meexhaeꞌ unpajte. As tal veꞌt Aak te chajnaj: —¿Ma kat pal ex stuul kam uveꞌ kat unbꞌan sete? ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","As an chiteꞌ taꞌ uveꞌ netaleꞌ uvaꞌ in u Chusul etetzeꞌ, as in veBꞌooqꞌoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","As kat untxꞌaa unqꞌa tiꞌ etojeꞌ. As tul in u Chusul etetzeꞌ. As ineꞌ veBꞌooqꞌoleꞌ. Estiꞌeꞌ ni val sete uvaꞌ echat la ebꞌaneꞌ. As la itxꞌaa tibꞌ tiꞌ etoj tukꞌ unqꞌa emooleꞌ sevatzaj, ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","tan ileꞌ kat unkꞌuchlu kan vuntxumbꞌaleꞌ sete, aqꞌal uvaꞌ la ebꞌan veꞌt etetz sevatzaj echeꞌ uveꞌ kat unbꞌan sete. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","As jik chit tuk val sete, tan yeꞌl umaj kꞌam uvaꞌ at pal koj tiꞌ u bꞌaal aqꞌoneꞌ. As yeꞌ la lejon u najeꞌ uveꞌ la chajpi tiꞌ u chajol tetzeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Asoj kat pal ex stuul, as ech la ebꞌaneꞌ. As chiibꞌebꞌal chit etatineꞌ la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","As jit chit kajayil ex ni val ex, tan ootzimal veꞌt ex svaꞌn tul uvaꞌ kat untxaa veꞌt ex. As ech chit la ibꞌaneꞌ echeꞌ uveꞌ tzꞌibꞌamal kan, tan ech ni tal ileꞌ: Umaꞌl u uxhchil uveꞌ nitxꞌaꞌn veꞌt sunkꞌatz as nichiꞌan veꞌt taama sviꞌ, tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","As ileꞌ bꞌaxel ni val sete tul yeꞌxnaj ibꞌana. As tul uvaꞌ la ibꞌaneꞌ, as aꞌn la etootzi veꞌteꞌ uvaꞌ kam u vijleꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","As jik chit la val sete, tan abꞌil la kꞌulun ex uvaꞌ in ni chajon bꞌen ex, as ineꞌ nikꞌul veꞌt in. As abꞌil uveꞌ ni kꞌulun in as aꞌ u chajol tzan vetzeꞌ nikꞌuleꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","As tul yaꞌ u Jesús tiꞌ talat u yoleꞌ, as vaꞌlik chit itxumun veꞌt taama Aak. As ech tal veꞌt Aak ileꞌ: —Jik chit tuk val sete, tan at umaꞌl ex uvaꞌ tuk aqꞌon ok in tiqꞌabꞌ unqꞌa iqꞌesal unqꞌa tenameꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","As xeꞌt ikaꞌya veꞌt tibꞌ unqꞌa ichusulibꞌ Aakeꞌ svatzaj. As ibꞌan veꞌt jeꞌ chajnaj tiviꞌ uvaꞌ abꞌiste naj nikat tal Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","As atik umaꞌl vichusulibꞌ Aak uvaꞌ nikat itxꞌaꞌn txala Aak. As atik ok iviꞌ naj tziꞌ taama Aak, tan kꞌulik chit tibꞌ iyol Aak tukꞌ naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","As ikꞌuch bꞌen u Simón uvaꞌ Luꞌ te naj tiꞌ uvaꞌ la ichꞌoti naj te Aak uvaꞌ abꞌil uveꞌ nikat tal Aak, ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","tan atik ok iviꞌ naj tziꞌ taama Aak. As ech tal veꞌt naj ileꞌ te Aak: —Pap, al sqe abꞌiste oꞌ uveꞌ naaleꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","As ech tal veꞌt Aak ileꞌ: —Abꞌiste ex tuk vaqꞌ u paaneꞌ sete uveꞌ tuk vakꞌsa, as aꞌ exeꞌ uveꞌ kat vala,— tiꞌk Aak. As takꞌsa veꞌt Aak u paaneꞌ. As taqꞌ veꞌt Aak te u Judas uvaꞌ Iscariote, vikꞌaol u Simón. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","As tul kuxh ikꞌul u Judas u paaneꞌ, as ok veꞌt u txꞌiꞌlanaj tu u taanxelal najeꞌ. As ech tal veꞌt u Jesús ileꞌ te naj: —Kam uveꞌ tuk abꞌaneꞌ as oora kuxh abꞌana,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","As tul tal Aak u yoleꞌ te u Judas xoꞌl unqꞌa ichusulibꞌeꞌ uvaꞌ xonlik vatz u meexhaeꞌ, as jit pal chajnaj stuul kam stiꞌ talkat Aak u yoleꞌ te u Judas. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","As atik chajnaj nikat itzꞌan uvaꞌ: «Kuxh loqꞌ unbꞌooj qechbꞌubꞌal tetz u nimla qꞌiieꞌ,» kamal tiꞌk Aak uvaꞌ nikat tal chajnaj, tan aꞌ u Judas kololik tetz u puajeꞌ. As moj tiꞌ bꞌen taqꞌat naj unbꞌooj tetz unqꞌa meebꞌaꞌeꞌ, uveꞌ nikat tal jeꞌ chajnaj ste. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","As tul maꞌtik itzꞌotineꞌ, as bꞌen veꞌt u Judas, tan maꞌtik ikꞌulat naj u paaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","As tul maꞌtik ibꞌen u Judas, as ech tal veꞌt u Jesús ileꞌ: —Kat oonyu veꞌt u qꞌiieꞌ uvaꞌ la oksal veꞌt iqꞌii VIKꞌAOL U NAJEꞌ. As stiꞌ la oksalkat veꞌt iqꞌii vunBꞌaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","As tul la oksal veꞌt iqꞌii vunBꞌaaleꞌ sviꞌ, as la toksa veꞌt vunBꞌaaleꞌ unqꞌii unpajte. As yeꞌxh jatvaꞌt qꞌii la ikꞌuch vunBꞌaaleꞌ unqꞌa veeꞌ ni val sete. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","As ex uvaꞌ xoꞌn ex sve, as tuk val sete uvaꞌ unbꞌiit kuxh tuk atinoj in sexoꞌl. As echat chit la val sete echeꞌ uvaꞌ kat val te unqꞌa iqꞌesal unqꞌa tenameꞌ, tan la bꞌen in. As la echuk in. As yeꞌ la ibꞌaneꞌ uvaꞌ la epalebꞌe echeꞌ uveꞌ tuk unpalebꞌe. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","As tuk val kan umaꞌl u akꞌ tzaqꞌit sete uvaꞌ ech ni tal ileꞌ: Xoꞌnoj chit etibꞌ sevatzaj. As echeꞌ uvaꞌ kat unbꞌan sete tiꞌ unxoꞌnit ex, as echat la ebꞌaneꞌ sevatzaj. As exoꞌnitaj etibꞌ sevatzaj, ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","tan asoj ech la ebꞌaneꞌ tiꞌ exoꞌnit etibꞌ sevatzaj, as la til veꞌt ex unqꞌa tenameꞌ tiꞌ uvaꞌ nimamal veꞌt in setaꞌn,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","As ech tal veꞌt u Luꞌ ileꞌ uvaꞌ Simón te u Jesús: —¿Pap, katileꞌ qꞌi la bꞌenkat axh?— tiꞌk naj. As ech tal veꞌt Aak ileꞌ te naj: —As yeꞌ la ibꞌaneꞌ uvaꞌ la epalebꞌe uveꞌ tuk unpalebꞌe. Pet xamteleꞌ la epalebꞌe,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","As ech tal veꞌt u Luꞌ ileꞌ: —¿Pap, kam stiꞌ qꞌi uvaꞌ yeꞌ la uch unxekebꞌ seeꞌ cheel? Tan kꞌuxh la alpu unkameꞌ, as techal la xekebꞌ in seeꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","As ech tal veꞌt u Jesús ileꞌ: —¿Moj an chit naaleꞌ uvaꞌ la xekebꞌ axh sviꞌ, kꞌuxh la alpu veꞌt akameꞌ? Ileꞌ jik chit tuk val see, tan tul yeꞌxnaj oqꞌ u peleꞌxheꞌ, as oxpajul maꞌt eesat eebꞌ sunkꞌatz,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","As ech tal veꞌt u Jesús ileꞌ: —Yeꞌ kuxh exaansa etaama. As ekꞌujbꞌaꞌtaj ekꞌuꞌl tiꞌ u Tiixheꞌ. As ekꞌujbꞌaꞌtaj ekꞌuꞌl sviꞌ unpajte, ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","tan nimal atinbꞌal ati xeꞌ vunBꞌaaleꞌ. As jitꞌeꞌch kojeꞌ, as yeꞌleꞌxh la val sete. Pet bꞌen in tiꞌ unbꞌanat isuuchil vetatinbꞌaleꞌ kꞌatz u Kubꞌaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","As tul uvaꞌ la bꞌen in, as la bꞌen unbꞌan isuuchil vetatinbꞌaleꞌ. As la ul in unpajte, tan la ul veqꞌo veꞌt ex, aqꞌal uvaꞌ katil uveꞌ la atinkat in as tzitziꞌ la atinkat ex, ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","tan ootzimaleꞌ setaꞌn uvaꞌ katiꞌch unbꞌeneꞌ. As ootzimal u bꞌeyeꞌ setaꞌn uveꞌ la bꞌenkat in,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","As ech tal u Maxh ileꞌ te u Jesús: —Pap, as yeꞌ qootzaj uvaꞌ katil la bꞌenkat axh. ¿As kam la qulbꞌe qootzit u bꞌeyeꞌ qꞌi?— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ech tal veꞌt u Jesús ileꞌ: —Ineꞌ u bꞌeyeꞌ. As ineꞌ u jikla yoleꞌ. As ineꞌ u tiichajileꞌ, tan yeꞌxhebꞌil la uch tok kꞌatz vunBꞌaaleꞌ, asoj jit in la oksan kꞌatz Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","As kat koj bꞌen sete kam u vijleꞌmeꞌ, as la bꞌeneꞌ sete kam u tijleꞌm vunBꞌaaleꞌ unpajte. As cheel tuk etootzi veꞌt u tijleꞌm vunBꞌaaleꞌ, tan il in netil veꞌt in tan eela kuxh ineꞌ tukꞌ vunBꞌaaleꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","As ech tal veꞌt u Piꞌl ileꞌ: —Pap, kꞌuch u Kubꞌaal Tiixheꞌ sqe. As kat ibꞌanleꞌ,— tiꞌk u Piꞌleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","As ech tal veꞌt Aak ileꞌ: —Naꞌytzaneꞌ taꞌ, Piꞌl, vatin sexoꞌl. ¿As ma yeꞌ ootzit veꞌt u vijleꞌmeꞌ? Tan abꞌil uveꞌ kat ilon in, as aꞌ Kubꞌaaleꞌ kat tillaꞌ. ¿Kam qꞌi uvaꞌ naal veꞌt sve uvaꞌ: «Kꞌuch u Kubꞌaaleꞌ sqe,» chꞌaxh naaleꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Ma yeꞌ nanima uvaꞌ at in kꞌatz vunBꞌaaleꞌ, as at Aak sunkꞌatz? Tan jit vuntxumbꞌaleꞌ ni voksa tiꞌ valat unqꞌa yoleꞌ sete. Pet aꞌ vunBꞌaaleꞌ uveꞌ at sunkꞌatz as Aakeꞌ ni bꞌanon unqꞌa kꞌuchbꞌal tetz vibꞌaꞌnileꞌ sviꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Enimataj uvaꞌ ni valeꞌ uvaꞌ at in kꞌatz vunBꞌaaleꞌ, as at vunBꞌaaleꞌ sunkꞌatz. Pet asoj yeꞌ nenima in tiꞌ unqꞌa yoleꞌ uvaꞌ ni val sete, as enimataj in tiꞌ unqꞌa bꞌaꞌnileꞌ uveꞌ nunbꞌan sexoꞌl. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","As jik chit tuk val sete, tan abꞌil uvaꞌ kꞌujleꞌl ikꞌuꞌl sviꞌ as la ibꞌan unqꞌa bꞌaꞌnileꞌ echeꞌ uvaꞌ nunbꞌaneꞌ. As la pal unqꞌa bꞌaꞌnileꞌ uveꞌ la ibꞌaneꞌ tiꞌ uveꞌ nunbꞌaneꞌ, tan tuk bꞌenoj in kꞌatz vunBꞌaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","As kam unqꞌa veeꞌ la ejaj te vunBꞌaaleꞌ tukꞌ vunbꞌiieꞌ as la unbꞌaneꞌ, aqꞌal uvaꞌ la unkꞌucheꞌ uvaꞌ nitoksal iqꞌii vunBꞌaaleꞌ taꞌn viKꞌaol u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","As kam chit unqꞌa veeꞌ la ejaj tukꞌ vunbꞌiieꞌ, as la chit unbꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Asoj xoꞌn veꞌt in sete, as enimataj vuntzaqꞌiteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","As la unjaj bꞌaꞌnil te vunBꞌaaleꞌ tiꞌ taqꞌat tzan Aak umaꞌt u lochol etetz, aqꞌal uvaꞌ la atin veꞌt sexoꞌl tiꞌ chit ibꞌeneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","As aꞌeꞌ u Tiixhla Espíritu uvaꞌ la lochon ex tiꞌ etootzit isuuchil u yoleꞌ sviꞌ. As yeꞌ la uch tok kꞌatz unqꞌa uxhchileꞌ uveꞌ vatz txꞌavaꞌilla txumbꞌal vitxumbꞌaleꞌ, tan yeꞌxhkam ni tileꞌ as yeꞌxhkam ootzimal staꞌn. Pet ech koj ex, tan ootzimal veꞌt u Tiixhla Espíritu setaꞌn, tan at veꞌt sexoꞌl. As tuk atinoj veꞌt sekꞌatz. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","As yeꞌl ex la koj chit velebꞌe kan ex. Pet latel ul in sekꞌatz. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Yeꞌxh jatvaꞌt qꞌii as yeꞌ la til veꞌt in unqꞌa uxhchileꞌ uveꞌ yeꞌ ni niman in. Pet ech koj ex, tan la etil veꞌt in, tan isleꞌl in. As isleꞌl veꞌt ex sunkꞌatz la ibꞌaneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","As tu veꞌt u qꞌiieꞌ as la etootzi veꞌteꞌ uvaꞌ at in kꞌatz vunBꞌaaleꞌ. As at ex sunkꞌatz. As at in sekꞌatz. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","As abꞌil uvaꞌ ootzimal veꞌt vuntzaqꞌiteꞌ staꞌn, as ninima, as aꞌeꞌ uveꞌ xoꞌn in ste. As abꞌil uveꞌ xoꞌn in ste as tuk xoꞌnilojeꞌ taꞌn vunBꞌaaleꞌ. As ineꞌ la xoꞌnin veꞌteꞌ. As la unkꞌuch vuntxumbꞌaleꞌ ste,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","As ech tal veꞌt u Judas uvaꞌ jit u Iscariote ech ileꞌ: —¿Pap, kam qꞌi uveꞌ aꞌ kuxh la akꞌuchkat vatxumbꞌaleꞌ sqe, as jit te unqꞌa uxhchileꞌ uveꞌ yeꞌ ni niman axh?— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","As ech tal veꞌt Aak ileꞌ: —Abꞌil uvaꞌ la xoꞌnin veꞌt in as la inima veꞌt vunyoleꞌ, as xoꞌn veꞌteꞌ te vunBꞌaaleꞌ. As la ul veꞌt oꞌ skꞌatz; as la atin veꞌt oꞌ skꞌatz. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Pet abꞌil uveꞌ yeꞌ xoꞌn in ste, as yeꞌ ninima vunyoleꞌ. As tul jit kuxh vetzeꞌ u yoleꞌ uveꞌ ni valeꞌ. Pet tetz vunBꞌaaleꞌ unpajte, u chajol tzan vetzeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","As ni val unqꞌa txumbꞌaleꞌ sete, tan atiltel in sexoꞌl. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pet la ul u lochol etetzeꞌ uvaꞌ Tiixhla Espíritu uveꞌ tuk ichaj tzan vunBꞌaaleꞌ, tukꞌ vunbꞌiieꞌ. As aꞌ veꞌteꞌ la chusun ex tiꞌ etootzit isuuchil unqꞌa veeꞌ nunbꞌaneꞌ. As la tulsa veꞌt vunyoleꞌ sekꞌuꞌl uvaꞌ kat val sete. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","As in kuxheꞌ la aqꞌon sete uvaꞌ bꞌaꞌn etatin sevatzaj. As yeꞌ kuxh exaansa etaama, tan in kuxheꞌ la aqꞌon sete tiꞌ uvaꞌ bꞌaꞌn etatin sevatzaj. As yeꞌ xoꞌv ex, tan jit eela uveꞌ tuk vaqꞌ sete tiꞌ uvaꞌ la taqꞌ unqꞌa vatz txꞌavaꞌilla txumbꞌaleꞌ sete. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","As etabꞌileꞌ uvaꞌ kat val sete uvaꞌ la bꞌen in, as la qꞌaav veꞌt in sekꞌatz unpajte. Asoj an chittuꞌ uvaꞌ xoꞌn in sete, as kat chiibꞌiy veꞌt exeꞌ taꞌ tiꞌ vunyoleꞌ uvaꞌ bꞌen in kꞌatz vunBꞌaaleꞌ, tan nim talcheꞌ vunBꞌaaleꞌ sviꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","As bꞌaxel ni val kan unqꞌa yoleꞌ sete, aqꞌal uvaꞌ tul la bꞌen ibꞌaneꞌ, as la enima veꞌteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","As yeꞌ kuxh jankꞌat yol tuk val sete cheel, tan tul veꞌt vibꞌooqꞌol unqꞌa uxhchileꞌ uveꞌ yeꞌ ni niman vunyoleꞌ. As tul nim talcheꞌ u vijleꞌmeꞌ stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","As tuk chit unbꞌaneꞌ kam uvaꞌ kat tal vunBꞌaaleꞌ sve, aqꞌal uvaꞌ la tootzi veꞌt unqꞌa uxhchileꞌ skajayil uvaꞌ xoꞌn vunBꞌaaleꞌ sve. As txakpoj ex. Koꞌnaj veꞌteꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","As ech tal veꞌt u Jesús ileꞌ: —Tan ech ineꞌ echeꞌ u jikla toj u uuvaeꞌ. As ech vunBꞌaaleꞌ echeꞌ umaj uxhchil uvaꞌ ni josqꞌin u uuvaeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","As abꞌiste viqꞌabꞌ u uuvaeꞌ uvaꞌ yeꞌ la taqꞌ ivatz, as la itzokꞌ veꞌt el vunBꞌaaleꞌ. Pet ech koj unqꞌa iqꞌabꞌeꞌ uveꞌ la taqꞌ ivatz, tan la ijosqꞌi veꞌt Aak, aqꞌal uvaꞌ nimal ivatz la taqꞌ veꞌteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","As ech kat vulbꞌe ex, tan kat unjosqꞌi veꞌt vetaanxelaleꞌ taꞌn vunyoleꞌ uveꞌ kat val sete. ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","As tuk chit voksa vaama setiꞌ tiꞌ chit ibꞌeneꞌ. Echabꞌataj etoksat etaama sviꞌ tiꞌ chit ibꞌeneꞌ tiꞌ uvaꞌ yeꞌ la ebꞌaneꞌ echeꞌ umaj iqꞌabꞌ u uuvaeꞌ uvaꞌ yeꞌ atoꞌk tiꞌ u tojeꞌ, tan yeꞌ la uch taqꞌat ivatz sijunal. As echat ex, tan asoj yeꞌ la etoksa etaama sviꞌ, as yeꞌxhkam la etxꞌol ebꞌanat sejunal. ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","As ineꞌ taꞌ u toj u uuvaeꞌ. As exeꞌ viqꞌabꞌeꞌ. As jankꞌal ex uvaꞌ la etoksa etaama sviꞌ bꞌenameen as la voksa vaama setiꞌ unpajte. As nimal chit veꞌt bꞌaꞌnil la ebꞌaneꞌ echeꞌ nibꞌan u uuvaeꞌ tul nivatzin tzeꞌ. Pet asoj yeꞌ la etoksa etaama sviꞌ, as yeꞌxhkam chit la etxꞌol ebꞌanat sejunal. ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Abꞌil uveꞌ yeꞌ la ichabꞌa toksat taama sviꞌ as la eesal el echeꞌ teesal el umaj iqꞌabꞌ u uuvaeꞌ. As tul la tzaji, as la molpi. As la tzꞌeꞌsal veꞌt tu u xamaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Asoj la etoksa etaama sviꞌ as la atin unqꞌa unyoleꞌ sekꞌuꞌl bꞌenameen tiꞌ ebꞌanat unqꞌa bꞌaꞌneꞌ. As ejajtaj sve kam u bꞌaꞌnileꞌ uvaꞌ ni tal etaama. As la chit unbꞌaneꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","tan ech la okkat iqꞌii vunBꞌaaleꞌ. As ech ekꞌuchateꞌ uvaꞌ ex niman vetz tiꞌ ebꞌanat u bꞌaꞌneꞌ echeꞌ nibꞌan u uuvaeꞌ tul ni taqꞌ tzeꞌ ivatz. ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Tan xoꞌn in te vunBꞌaaleꞌ. As echat nunbꞌan unpajte, tan xoꞌn ex sve. As etoksataj etaama sviꞌ, tan xoꞌn ex sve. ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Asoj la enima vuntzaqꞌiteꞌ. As exoꞌnitaj etibꞌ sevetzaj tan ineꞌ ni aqꞌon u xoꞌniibꞌeꞌ sete. As echeꞌ uveꞌ nunbꞌaneꞌ tan nunnima vitzaqꞌit vunBꞌaaleꞌ as nunxoꞌni vibꞌ tukꞌ vunBꞌaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","As ni val kan unqꞌa yoleꞌ sete, aqꞌal uvaꞌ la txuqꞌtxun ex echeꞌ nunbꞌaneꞌ. As la chit atin u chiibꞌichileꞌ tu vetaanxelaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","As aꞌ vuntzaqꞌiteꞌ uveꞌ ni val sete uvaꞌ xoꞌnoj chit etibꞌ sevatzaj, echeꞌ uveꞌ kat unbꞌan sete, tan xoꞌn chit ex sve. ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","As yeꞌl umaj xoꞌniibꞌ uvaꞌ nim talcheꞌ uvaꞌ la ibꞌan umaj uxhchil tiꞌ u tetz kꞌultziꞌeꞌ uvaꞌ xoꞌn chit ste, asoj yeꞌ la taqꞌ tibꞌ kamoj tiꞌ u tetz kꞌultziꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","As exeꞌ u vetz kꞌultziꞌeꞌ, asoj yeꞌ la yaꞌ ex tiꞌ ebꞌanataꞌ kam uveꞌ ni val sete. ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","As jit veꞌt ex unkꞌam, tan yeꞌ tootzaj u kꞌameꞌ kam ni tal taama vibꞌaal u aqꞌoneꞌ. Pet ni valeꞌ uvaꞌ ex veꞌteꞌ u vetz kꞌultziꞌeꞌ, tan ootzimal setaꞌn kam uvaꞌ ni tal vunBꞌaaleꞌ sve. As kat vallu veꞌt sete. ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","As jit exeꞌ kat txaaon in. Pet ineꞌ kat txaaon ex, tan kat unkꞌujbꞌaꞌ kan ex tiꞌ uvaꞌ la ebꞌan u bꞌaꞌneꞌ, echeꞌ nibꞌan u uuvaeꞌ tul nivatzineꞌ. As kam la ejaj te vunBꞌaaleꞌ tukꞌ vunbꞌiieꞌ as la taqꞌ Aakeꞌ sete, aqꞌal uvaꞌ yeꞌl ex la yaꞌ veꞌt ex tiꞌ ebꞌanat u bꞌaꞌneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","As ni val sete uvaꞌ xoꞌnoj chit etibꞌ sevatzaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Asoj la chiꞌan taama unqꞌa uxhchileꞌ setiꞌ, as la etulsa sekꞌuꞌl uvaꞌ bꞌaxel kat chiꞌan taama sviꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","As unvatzul kuxh koj ex tukꞌ unqꞌa uxhchileꞌ, as xoꞌn exeꞌ taꞌ ste, echeꞌ uveꞌ nibꞌan svatzaj. Pet nichiꞌan veꞌt taama setiꞌ, tan tiꞌ uvaꞌ kat untxaa ex xoꞌl unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","As la etulsa vunyoleꞌ sekꞌuꞌl uveꞌ kat val sete: «Tan yeꞌl umaj kꞌam uvaꞌ at pal koj tiꞌ u bꞌaal aqꞌoneꞌ,» chꞌin sete. Estiꞌeꞌ la val sete uvaꞌ kat itilu in unqꞌa uxhchileꞌ. As echat la ulbꞌel ex unpajte. As at uxhchil kat niman vunyoleꞌ. As la nimal veyoleꞌ taꞌn unqꞌa uxhchileꞌ unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","As ech ixeꞌt unqꞌa uxhchileꞌ setiꞌ, tan tiꞌ uvaꞌ nenima in. As yeꞌ tootzaj unqꞌa uxhchileꞌ u chajol tzan vetzeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","As yeꞌ koj kat ul in tiꞌ valat unqꞌa yoleꞌ te unqꞌa uxhchileꞌ, as yeꞌl ipaaveꞌ ati. As cheel yeꞌ la uch talataꞌ uvaꞌ yeꞌl ipaav ati, ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","tan abꞌil uveꞌ ni chiꞌan taama sviꞌ as tiꞌ vunBꞌaaleꞌ nichiꞌankat taama unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","As yeꞌ koj kat ul unkꞌuch unqꞌa bꞌaꞌnileꞌ uveꞌ yeꞌxhebꞌil ni bꞌanon echeꞌ uvaꞌ kat unbꞌana, as yeꞌl ipaaveꞌ unqꞌa uxhchileꞌ ati. As ech koj cheel tan kꞌuxh kat tillaꞌ, as nitel ichiꞌan taama sviꞌ as tiꞌ vunBꞌaaleꞌ unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","As aꞌeꞌ kat ibꞌana uvaꞌ tzꞌibꞌamal kan uvaꞌ ech ni tal ileꞌ: As kꞌuxh yeꞌxhkam nunbꞌaneꞌ, kat chiꞌan taama unqꞌa uxhchileꞌ sviꞌ, tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Pet la unchaj tzan u lochol etetzeꞌ. As aꞌeꞌ u Tiixhla Espíritu uvaꞌ atoꞌk kꞌatz vunBꞌaaleꞌ. As tul la uli, as la tal isuuchil u yoleꞌ sete sviꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","As an chit ex la alon ok isuuchil unqꞌa yoleꞌ sviꞌ te unqꞌa uxhchileꞌ unpajte, tan xekelik chit ex sviꞌ, tul uvaꞌ kat xeꞌt in tiꞌ valat viyol vunBꞌaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","As jankꞌal unqꞌa yoleꞌ uvaꞌ kat val sete, as aꞌ kat valkateꞌ sete tiꞌ uvaꞌ yeꞌ la etzꞌej u kꞌujlebꞌal ekꞌuꞌleꞌ sviꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","tan la laqꞌbꞌal ex tu unqꞌa atinbꞌaleꞌ tetz nachbꞌal Tiixh. As la ilej umaꞌl u qꞌii uvaꞌ la iyatzꞌ ex unqꞌa uxhchileꞌ. As tul aꞌ u bꞌaꞌneꞌ nibꞌan unqꞌa uxhchileꞌ uveꞌ la tal jeꞌ ste vatz u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","As aꞌ nibꞌankat unqꞌa uxhchileꞌ, tiꞌ uvaꞌ yeꞌ nipal tu tijleꞌm u Kubꞌaal Tiixheꞌ. As mitaꞌn nibꞌen ste kam u vijleꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Pet ileꞌ kat vallu sete uvaꞌ ech la ulbꞌel ex. As tul la ilej u qꞌiieꞌ tiꞌ u yoleꞌ uvaꞌ ni valeꞌ, as la etulsa veꞌt sekꞌuꞌl uvaꞌ kat vallu kan isuuchil sete. ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","As cheel tuk qꞌaavoj in kꞌatz u chajol vetzeꞌ. Pet yeꞌl umaj ex ni chꞌotin sve uvaꞌ katil la bꞌenkat in, ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","tan netxumuneꞌ taꞌn unqꞌa yoleꞌ uveꞌ kat val sete. ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pet jik chit tuk val sete, tan aal bꞌaꞌneꞌ la ibꞌan sete uvaꞌ la bꞌen in, tan asoj yeꞌ la bꞌen in, as echeꞌ la koj ul u lochol etetzeꞌ. Pet la bꞌen in. As la unchaj tzan u lochol etetzeꞌ sekꞌatz. ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","As tul uvaꞌ la ul u lochol etetzeꞌ, as aꞌeꞌ la ul alon isuuchil te unqꞌa tenameꞌ tiꞌ vipaaveꞌ. As la ul tal isuuchil tiꞌ u jikeꞌ as tukꞌ tiꞌ u kꞌaxkꞌoeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","As la ul tal u lochol etetzeꞌ isuuchil tiꞌ u paaveꞌ, tan tiꞌ uvaꞌ yeꞌ ninima in unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","As la ul tal isuuchil tiꞌ u jikeꞌ, tan bꞌen veꞌt in kꞌatz vunBꞌaaleꞌ. As yeꞌl in la etil veꞌt in vatz u txꞌavaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","As la ul tal veꞌt isuuchil tiꞌ u kꞌaxkꞌoeꞌ, tan tiꞌ uvaꞌ at veꞌt kan vibꞌooqꞌol unqꞌa uxhchileꞌ jaqꞌ u kꞌaxkꞌoeꞌ, uvaꞌ yeꞌ ni niman in. ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","As nimatel unqꞌa yoleꞌ uveꞌ la val sete. As yeꞌl ex la olebꞌ ex cheel tiꞌ epal stuul. ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","As tul la ul veꞌt u jikla Tiixhla Espíritu, as aꞌeꞌ la eqꞌon ex tu u jikla txumbꞌaleꞌ. Tan jit vitxumbꞌaleꞌ la ul tal sete, pet aꞌ la ul taleꞌ kam uveꞌ kat tabꞌi. As la ul taqꞌ etxumbꞌal tiꞌ uvaꞌ kam la uli. ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","As la ul ikꞌuch isuuchil sete tiꞌ toksal unqꞌii, tan aꞌ unqꞌa unyoleꞌ kat ul val sete, aqꞌal uvaꞌ la etootzi vunyoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tan jankꞌal chit unqꞌa tetz vunBꞌaaleꞌ as vetzeꞌ unpajte. Estiꞌeꞌ kat vallu sete, «Kam unqꞌa unyoleꞌ uvaꞌ la val te u Tiixhla Espíritu, as aꞌeꞌ la ul tal sete, aqꞌal uvaꞌ la etootzi unqꞌa unyoleꞌ.» ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Bꞌiitoj kuxh tuk unbꞌan veꞌt sexoꞌl. As yeꞌ la etil veꞌt in. As yeꞌxh jatvaꞌt qꞌii as la etil veꞌt in unpajte. As la bꞌen veꞌt in kꞌatz vunBꞌaaleꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","As ech tal veꞌt kaꞌl unqꞌa ichusulibꞌ u Jesús ileꞌ svatzaj: —Yeꞌ la pal oꞌ tu viyol Aakeꞌ uveꞌ ni tal sqe, «Tan unbꞌiitoj kuxheꞌ tuk unbꞌan veꞌt sexoꞌl. As yeꞌ la etil veꞌt in. As yeꞌxh jatvaꞌt qꞌii as la etil veꞌt in unpajte. As la bꞌen veꞌt in kꞌatz vunBꞌaaleꞌ,» taqꞌ kuxh Aak ni tal sqe. ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿As kam ni tokkat viyol Aakeꞌ u vaaꞌ, «Bꞌiitoj kuxheꞌ,» taqꞌ Aak? Tan aꞌeꞌ taꞌ yeꞌ la pal oꞌ stuul,— tiꞌk chajnaj svatzaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","As naꞌlik vatz u Jesús uvaꞌ nik isaꞌ chajnaj ichꞌotit te Aak. As ech tal veꞌt Aak ileꞌ te chajnaj: —¿Ma aꞌeꞌ nichꞌoti tibꞌ sevatzaj tiꞌ uveꞌ kat val sete uvaꞌ: «Bꞌiitoj kuxheꞌ tuk unbꞌan veꞌt sexoꞌl. As yeꞌ la etil veꞌt in. As bꞌiit kuxh stuul as la etil veꞌt in unpajte,» chꞌin kat val sete? ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","As jik chit tuk val sete uvaꞌ tuk oqꞌoj ex taꞌn txumuꞌm. Pet ech koj unqꞌa uxhchileꞌ, tan chiibꞌichil tuk ibꞌaneꞌ. Pet kꞌuxh tuk txumunoj ex, as la bꞌen u txumuꞌmeꞌ schiibꞌichil, ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","echeꞌ nibꞌan umaj ixoj uvaꞌ ni talaneꞌ, tan tul nichꞌoꞌn ixoj tiꞌ u neꞌeꞌ, as vaꞌl chit itxumun veꞌt ixoj, tan kat oonyu veꞌt ixoj vatz viqꞌiieꞌ tiꞌ ichꞌoꞌneꞌ. As tul kat itzꞌebꞌ veꞌt vineꞌ ixojeꞌ, as echeꞌ nitel koj tul u chꞌoꞌmeꞌ skꞌuꞌl ixoj. As vaꞌl chit ichiibꞌ veꞌt ixoj tiꞌ u taleꞌ uveꞌ kat itzꞌebꞌi. ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","As echat kuxh tuk ebꞌaneꞌ unpajte, tan tuk txumunoj ex. As tuk vil vibꞌeꞌ setukꞌ unpajte, as la chiibꞌ veꞌt ex sviꞌ. As yeꞌxhebꞌil la eesan el u chiibꞌichileꞌ tu vetaanxelaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","As tu u qꞌiieꞌ, as echeꞌ kam koj la echꞌoti veꞌt sve. Pet ileꞌ jik chit tuk val sete uvaꞌ kam chit uveꞌ la ejaj te vunBꞌaaleꞌ tukꞌ vunbꞌiieꞌ, as la taqꞌ Aakeꞌ sete. ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tan yeꞌxhkam chit ejajeꞌt te vunBꞌaaleꞌ tukꞌ vunbꞌiieꞌ. Pet tuk val sete, ejajtaj te Aak. As la ekꞌuleꞌ, aqꞌal uvaꞌ la chiibꞌ vetaanxelaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","As kat untxakonsa unqꞌa kꞌuchuvatzeꞌ tiꞌ valat unqꞌa yoleꞌ sete. Pet tul umaꞌl u qꞌii uvaꞌ yeꞌ la untxakonsa veꞌt unqꞌa kꞌuchuvatzeꞌ tiꞌ unyolon sete, tan jik chit la yolon veꞌt in sete tiꞌ vunBꞌaaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","As tu u qꞌiieꞌ, as la ejaj veꞌt te Aak tukꞌ vunbꞌiieꞌ. As jit aꞌ ni valeꞌ uvaꞌ in la jajon te Aak setiꞌ. Pet ex la jajon te Aak, ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","tan xoꞌn veꞌt ex te Aak, tan tiꞌ uvaꞌ xoꞌn in sete. As nenima uvaꞌ aꞌ tzaanajkat in kꞌatz Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","As kat el chꞌuꞌl in kꞌatz vunBꞌaaleꞌ. As kat ul in tzitzaꞌ vatz u txꞌavaꞌeꞌ. As tuk vaqꞌ veꞌt kan u vatz txꞌavaꞌeꞌ unpajte, tan tuk qꞌaavoj in kꞌatz vunBꞌaaleꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","As ech tal veꞌt unqꞌa ichusulibꞌ u Jesús ileꞌ: —As cheel jik chit nayolon veꞌteꞌ, tan jit veꞌt tukꞌ kꞌuchuvatz nayolonkat. ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","As kat palyu veꞌt oꞌ stuul uvaꞌ ootzimal unqꞌa txumbꞌaleꞌ aꞌn skajayil. As jit kuxh tzꞌajinal uvaꞌ la chꞌotil umaj yol see, tan at veꞌt sakꞌuꞌl tul yeꞌxnaj chꞌotil see. As ech qootziteꞌ uvaꞌ aꞌ tzaanajkat axh kꞌatz u Tiixheꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","As ech tal veꞌt u Jesús ileꞌ: —¿Ma aꞌ netaleꞌ uvaꞌ nenima veꞌt in cheel? ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Pet tuk val sete uvaꞌ unbꞌiit kuxh ilejat u qꞌiieꞌ uvaꞌ la etaqꞌ veꞌt kan in, tan tuk tiluloj ex sekajayil. As katil kuxh la bꞌenkat veꞌt ex sejununilaj. As yeꞌl in la koj kaaik kan in sunjunal, tan at u Kubꞌaal Tiixheꞌ sunkꞌatz. ");
INSERT INTO ixlNNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Pet kat vallu kan unqꞌa yoleꞌ sete, aqꞌal uvaꞌ la yakꞌin veꞌt etaama sunkꞌatz. As kꞌuxh tuk epalebꞌe unqꞌa kꞌaxkꞌoeꞌ vatz u txꞌavaꞌeꞌ, as ekꞌujbꞌaꞌtaj ekꞌuꞌl sviꞌ, tan kat olebꞌyu veꞌt in tiꞌ unqꞌa kꞌaxkꞌoeꞌ skajayil,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","As tul yaꞌ veꞌt u Jesús tiꞌ talat unqꞌa yoleꞌ te unqꞌa ichusulibꞌeꞌ, as kaꞌyik veꞌt jeꞌ Aak tu almikaꞌ. As ech tal veꞌt Aak ileꞌ: —UnBꞌaal, kat ilejlu veꞌt u qꞌiieꞌ. As oksa veꞌt unqꞌii vatz unqꞌa tenameꞌ, aqꞌal uvaꞌ la unkꞌuch vatz unqꞌa tenameꞌ uvaꞌ nitoksal aqꞌii unpajte, tan ineꞌ vaKꞌaoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","As axheꞌ kat aqꞌon u vijleꞌmeꞌ tiꞌ unqꞌa tenameꞌ skajayil, tiꞌ uvaꞌ la vaqꞌ itiichajil uveꞌ yeꞌl iyaꞌtebꞌal, jankꞌal uveꞌ kat aal sve uvaꞌ la vaqꞌ ste. ");
INSERT INTO ixlNNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","As aꞌeꞌ vitiichajileꞌ uveꞌ yeꞌl iyaꞌtebꞌal uvaꞌ la tootzi axh uvaꞌ taꞌn axheꞌ u jikla Tiixheꞌ. As la tootzi in unpajte, tan ineꞌ u Cristo uvaꞌ kat achaj tzan vatz u txꞌavaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","As kat ul voksa aqꞌii vatz u txꞌavaꞌeꞌ tiꞌ untzojpisat uveꞌ kat aal sve. ");
INSERT INTO ixlNNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","As cheel oksa veꞌt unqꞌii tiꞌ ooksat in sakꞌatz unpajte echeꞌ uvaꞌ nikat unbꞌan sakꞌatz tul uvaꞌ yeꞌxnik chee u vatz txꞌavaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","As kat vallu veꞌt isuuchil u eejleꞌmeꞌ te unqꞌa tenameꞌ vatz u txꞌavaꞌeꞌ. As unqꞌa uxhchileꞌ uvaꞌ kat aaqꞌ sve as kat inimal veꞌt vayoleꞌ, tan eetzeꞌ unqꞌa uxhchileꞌ uvaꞌ kat aaqꞌ sve. ");
INSERT INTO ixlNNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","As cheel kat tootzi veꞌt unqꞌa uxhchileꞌ unqꞌa yoleꞌ uvaꞌ kat vala as tukꞌ unqꞌa bꞌaꞌnileꞌ uvaꞌ kat unkꞌucha tiꞌ uvaꞌ axh kat aqꞌon sve skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","As jankꞌal unqꞌa yoleꞌ uvaꞌ kat aal sve, as kat vallu veꞌt te unqꞌa uxhchileꞌ. As kat tootzil veꞌteꞌ uvaꞌ aꞌ tzaanajkat in sakꞌatz. As kat inimal veꞌteꞌ uvaꞌ axh kat chajon tzan in, tan kat isaꞌ tabꞌil veꞌt unqꞌa yoleꞌ uvaꞌ kat val ste. ");
INSERT INTO ixlNNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","As nunjaj bꞌaꞌnil see tiꞌ unqꞌa uxhchileꞌ uvaꞌ kat aaqꞌ sve, tan eetzeꞌ. Pet jit tiꞌ unqꞌa uxhchileꞌ uveꞌ yeꞌ kat niman vayoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","As jankꞌal chit unqꞌa uxhchileꞌ uvaꞌ vetz, as eetzeꞌ; as jankꞌal unqꞌa uxhchileꞌ uvaꞌ eetz, as vetzeꞌ. As ni toksa veꞌt unqꞌa uxhchileꞌ unqꞌii unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","UnBꞌaal, tan taꞌn axheꞌ, axh jikla Tiixh, as kol veꞌt unqꞌa uxhchileꞌ uvaꞌ kat aaqꞌ sve tukꞌ vabꞌiieꞌ, aqꞌal uvaꞌ unvatzul kuxh veꞌteꞌ echeꞌ u qatineꞌ, tan bꞌiit kuxh tuk atinoj veꞌt in vatz u txꞌavaꞌeꞌ. As la bꞌen veꞌt in sakꞌatz. ");
INSERT INTO ixlNNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","As tul at in kꞌatz unqꞌa uxhchileꞌ vatz u txꞌavaꞌeꞌ, as ineꞌ ni lochon tukꞌ vabꞌiieꞌ. As jankꞌal uveꞌ kat aaqꞌ sve as kolel svaꞌn. As yeꞌl umaj kat tzꞌejxi. Pet taꞌn kuxh umaꞌl u naj uvaꞌ alel veꞌt kan stiꞌ uvaꞌ la bꞌen tu kꞌaxkꞌo, tiꞌ uvaꞌ la bꞌen ibꞌaneꞌ uvaꞌ tzꞌibꞌamal kan. ");
INSERT INTO ixlNNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","As cheel tuk qꞌaavoj veꞌt in sakꞌatz. Estiꞌeꞌ ni val unqꞌa yoleꞌ te unqꞌa uxhchileꞌ, aqꞌal uvaꞌ la chiibꞌ veꞌt u taanxelaleꞌ seeꞌ echeꞌ ichiibꞌ u vaanxelaleꞌ seeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","As kat vallu veꞌt vayoleꞌ te unqꞌa uxhchileꞌ. As ni tixval veꞌt unqꞌa niman vetzeꞌ taꞌn unqꞌa uxhchileꞌ uveꞌ yeꞌ ni niman vayoleꞌ, tan tiꞌ uvaꞌ jit eela vitxumbꞌaleꞌ tukꞌ unqꞌa uxhchileꞌ. As echat kuxh in, tan jit eela vuntxumbꞌaleꞌ tukꞌ unqꞌa uxhchileꞌ uveꞌ yeꞌ ni niman vayoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","As aꞌ koj nunjaj see uvaꞌ la eesa el unqꞌa uxhchileꞌ uvaꞌ kat aaqꞌ sve xoꞌl unqꞌa uxhchileꞌ uveꞌ yeꞌ ni niman vayoleꞌ. Pet aꞌ ni valeꞌ uvaꞌ la akoleꞌ vatz u txꞌiꞌlanajeꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","tan jit eela vitxumbꞌaleꞌ tukꞌ unqꞌa uxhchileꞌ uveꞌ yeꞌ ni niman vayoleꞌ. As echat kuxh in unpajte, tan jit eela vuntxumbꞌaleꞌ stukꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","As aqꞌ iyakꞌil u taanxelal unqꞌa uxhchileꞌ uvaꞌ txaael veꞌt aꞌn taꞌn vajikla yoleꞌ, tan taꞌneꞌ vayoleꞌ uveꞌ jik chittuꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Tan axheꞌ kat chajon tzan in xoꞌl unqꞌa tenameꞌ vatz u txꞌavaꞌeꞌ. As echat nunbꞌaneꞌ te unqꞌa uxhchileꞌ uvaꞌ kat aaqꞌ sve, tan nunchaj veꞌt bꞌen xoꞌl unqꞌa tenameꞌ unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","As ayaꞌl chit unkꞌuꞌl la vaqꞌ vibꞌ kamoj tiꞌ unqꞌa niman vetzeꞌ, aqꞌal uvaꞌ ayaꞌl chit ikꞌuꞌl unqꞌa niman vetzeꞌ la ibꞌaneꞌ tiꞌ inimal vayoleꞌ uvaꞌ jik chittuꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","As jit kuxh tiꞌ unqꞌa niman vetzeꞌ nunjajkat bꞌaꞌnil see uveꞌ ni niman in cheel. Pet tiꞌ unjoltu unqꞌa uxhchileꞌ uvaꞌ aꞌn la ikꞌujbꞌaꞌ ikꞌuꞌl sviꞌ, tul la bꞌen tal unqꞌa niman vetzeꞌ vayoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","As nunjaj bꞌaꞌnil see, Kubꞌaal Tiixh, tiꞌ unqꞌa niman qetzeꞌ tiꞌ uvaꞌ unvatzul kuxh veꞌt la ibꞌan svatzaj echeꞌ oꞌ, tan at axh sunkꞌatz. As at in sakꞌatz. Estiꞌeꞌ unvatzul kuxh veꞌt oꞌ tukꞌ unqꞌa niman qetzeꞌ la ibꞌaneꞌ. As la inima veꞌt unqꞌa tenameꞌ skajayil uvaꞌ axh kat chajon tzan in, ");
INSERT INTO ixlNNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","as tul uvaꞌ kat ooksa veꞌt unqꞌii, as kat vaqꞌlu veꞌt te unqꞌa niman qetzeꞌ, aqꞌal uvaꞌ vatzul kuxh veꞌteꞌ la ibꞌaneꞌ echeꞌ u qatineꞌ, tan unvatzul kuxh oꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","As at in kꞌatz unqꞌa niman qetzeꞌ. As at axh sunkꞌatz unpajte, aqꞌal uvaꞌ yeꞌxhebꞌil kuxh umaꞌtoj la saꞌvit tiꞌ unqꞌa niman qetzeꞌ tiꞌ uvaꞌ vatzul kuxh svatzaj la ibꞌaneꞌ. As ech la tootzikat unqꞌa tenameꞌ skajayil uvaꞌ axh kat chajon tzan in, as xoꞌn unqꞌa niman qetzeꞌ see echeꞌ uveꞌ nabꞌan sve. ");
INSERT INTO ixlNNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Kubꞌaal Tiixh, nunsaꞌ uvaꞌ katil la atinkat in as aꞌ la atinkat unqꞌa uxhchileꞌ sunkꞌatz uvaꞌ kat aaqꞌ sve, aqꞌal uvaꞌ la tileꞌ uvaꞌ kat ooksa veꞌt unqꞌii, tan tiꞌ uvaꞌ xoꞌn chit in see, tul yeꞌxnik chee u vatz txꞌavaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Kubꞌaal Tiixh, tan axheꞌ u jikla Tiixheꞌ, as jankꞌal unqꞌa uxhchileꞌ uveꞌ yeꞌ ni niman oꞌ as yeꞌ tootzaj axh. Pet ech koj in, tan ootzimal axh svaꞌn. As kat tootzil veꞌt unqꞌa niman qetzeꞌ uvaꞌ axh kat chajon tzan in. ");
INSERT INTO ixlNNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","As kat vallu veꞌt isuuchil te unqꞌa uxhchileꞌ seeꞌ. As kat tootzil veꞌt axh. As tuktel val ste unpajte, aqꞌal uvaꞌ la ixoꞌni tibꞌ svatzaj, echeꞌ uveꞌ nabꞌan sve. As at in skꞌatz la ibꞌaneꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","As tul kuxh tal u Jesús unqꞌa yoleꞌ, as el veꞌt chꞌuꞌl Aak tukꞌ unqꞌa ichusulibꞌeꞌ tiꞌ iqꞌax jalit u xoꞌl vitzeꞌ uvaꞌ Cedrón ibꞌii, tan atik kaꞌl unqꞌa chiko tzitziꞌ. As ok veꞌt Aak xoꞌl unqꞌa chikoeꞌ tukꞌ unqꞌa ichusulibꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","As ootzimalik u atinbꞌaleꞌ taꞌn u Judas, uvaꞌ kꞌayin u Jesús, tan jatpajul kuxh nik tex Aak tukꞌ unqꞌa ichusulibꞌeꞌ tu u atinbꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","As teqꞌo veꞌt u Judas kaꞌl unqꞌa sol stiꞌ tukꞌ kaꞌt unqꞌa xeen tetz u tostiixheꞌ uvaꞌ kat ichaj bꞌen unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh tukꞌ unqꞌa fariseo. As eqꞌomalik chꞌichꞌ taꞌn unqꞌa uxhchileꞌ tukꞌ txijubꞌ tetz. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","As el veꞌt chꞌuꞌl u Jesús tiꞌ ul ikꞌulat chajnaj, tan atik skꞌuꞌl Aak uvaꞌ kam la ul veꞌt tiꞌ Aak. As ech tal veꞌt Aak ileꞌ te chajnaj: —¿Abꞌil qꞌi nechukeꞌ?— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","As ech tal veꞌt chajnaj ileꞌ: —Nu kuchuk u Jesús, u aa Nazaret,— tiꞌk chajnaj. —Ineꞌ,— tiꞌk Aak. As antik u Judas uvaꞌ kꞌayin u Jesús molonik tibꞌ tukꞌ chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","As tul tal u Jesús uvaꞌ: «Ineꞌ,» tiꞌk Aak, as pakꞌkabꞌan ibꞌen veꞌt chajnaj tu txꞌavaꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","As ech tal veꞌt u Jesús ileꞌ tikaꞌpa: —¿Abꞌil nechukeꞌ?— tiꞌk Aak. —Aꞌ u Jesús nu kuchukeꞌ uvaꞌ aa Nazaret,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","—Ileꞌ kat vallu sete uvaꞌ ineꞌ. Asoj in chit nechuk in, as echajputaj bꞌen unqꞌa unchusulibꞌeꞌ uveꞌ xekel sviꞌ,— tiꞌk Aak, ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","tiꞌ uvaꞌ la ibꞌan u yoleꞌ uvaꞌ maꞌt talat Aak uvaꞌ: «Jankꞌal unqꞌa uxhchileꞌ uvaꞌ kat aaqꞌ sve as yeꞌl umaj kat tzꞌejxi,» tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","As u Simón uvaꞌ Luꞌ, as eqꞌomalik umaꞌl u chꞌichꞌ staꞌn. As teqꞌo jeꞌ tzan naj u chꞌichꞌeꞌ tu totzotz. As itzokꞌeꞌl naj visebꞌal ixikin umaꞌl vikꞌam iqꞌesal oksan iyol tenam vatz Tiixh uvaꞌ Malco ibꞌii. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","As ech tal veꞌt u Jesús ileꞌ te u Luꞌeꞌ: —Aqꞌ kuꞌ vachꞌichꞌeꞌ tu u totzotzeꞌ, tan kam unqꞌa kꞌaxkꞌoeꞌ uvaꞌ kꞌujlu kan taꞌn vunBꞌaaleꞌ uvaꞌ la unpalebꞌe, as techal chit la unpalebꞌeeꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Unqꞌa soleꞌ tukꞌ viqꞌesaleꞌ as tukꞌ unqꞌa xeen tetz u toxtiixheꞌ as itxey veꞌt chajnaj u Jesús, as ikꞌal veꞌt chajnaj Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","As bꞌaxa aꞌ bꞌex taqꞌkat chajnaj u Jesús tu vikabꞌal u Anás, vijiꞌ u Caifás, uvaꞌ atik ok sqꞌesalil xoꞌl unqꞌa oksan iyol tenam vatz Tiixh tu u yaabꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","As aꞌ u Caifás uveꞌ kat alon xoꞌl unqꞌa iqꞌesal unqꞌa tenameꞌ uvaꞌ: «Aal chit bꞌaꞌneꞌ uvaꞌ la kam umaj naj tiꞌ unqꞌa tenameꞌ,» tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","As tul eqꞌol veꞌt ok u Jesús tu vikabꞌal u Anás, as xekik u Simón uvaꞌ Luꞌ tiꞌ Aak tukꞌ umaꞌt vichusulibꞌ Aakeꞌ. As kat kꞌulax ok vimool u Luꞌeꞌ vatz qꞌanal, tan ootzimalik naj taꞌn viqꞌesal oksan iyol tenam vatz Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pet ech koj u Luꞌeꞌ, tan kat kaaik kan naj tiꞌeꞌl u kabꞌaleꞌ. Tul til vimool u Luꞌeꞌ uvaꞌ kaaik kan naj, as el veꞌt chꞌuꞌl naj. As ul ijaj naj bꞌaꞌnil te u ixojeꞌ uvaꞌ nik xeon u tziꞌ kabꞌaleꞌ tiꞌ uvaꞌ la ok chꞌuꞌl u Luꞌeꞌ vatz u qꞌanaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","As ech tal veꞌt u ixoj ileꞌ te u Luꞌeꞌ: —¿Ma jit axh ichusulibꞌ u najeꞌ?— tiꞌk ixoj. —Yeꞌle, jit ineꞌ,— tiꞌk u Luꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","As txaklik unqꞌa kꞌameꞌ tukꞌ unqꞌa xeen tetz u tostiixheꞌ vatz qꞌanal, tan maꞌtik toksat chajnaj xamal, tan vaꞌlik chit taqꞌbꞌu cheꞌv. As txaklik ok u Luꞌeꞌ kꞌatz chajnaj tiꞌ ileeat ok tibꞌ vatz u xamaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","As ichꞌoti veꞌt viqꞌesal oksan iyol tenam vatz Tiixh itziꞌ u Jesús tiꞌ uvaꞌ abꞌil unqꞌa ichusulibꞌ Aakeꞌ, as abꞌiste chusbꞌal nik ichus Aak te chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","As ech tal veꞌt Aak ileꞌ: —As vatz unqꞌa uxhchileꞌ skajayil kat yolonkat in. As kat chusun in tulaj unqꞌa atinbꞌaleꞌ tetz nachbꞌal Tiixh, as vatz u tostiixheꞌ, as tu uveꞌ nimolkat tibꞌ unqꞌa uxhchileꞌ. As yeꞌ atixoj unmuj umaj yol vatz unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿As kam qꞌi uveꞌ nachꞌoti sve? Pet abꞌi te unqꞌa uxhchileꞌ uveꞌ kat abꞌin vunyoleꞌ. As tuk taleꞌ kam kat vala, tan ootzimaleꞌ staꞌn,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","As tul kuxh tal u Jesús u yoleꞌ, as ul itzꞌichoꞌk umaꞌl u xeen tetz u tostiixheꞌ qꞌabꞌ jaqꞌ ivatz Aak. As ech tal naj ileꞌ te Aak: —¿Ma ech atzaqꞌbꞌet viqꞌesal oksan iyol tenam vatz Tiixh echeꞌ uveꞌ?— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","As ech tal veꞌt Aak ileꞌ: —Asoj vaꞌlexh kat vala, as etaltaj sve. Pet asoj jit vaꞌlexh kat vala, as ¿kam qꞌi uveꞌ nu kuxh aqꞌos in?— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","As tal veꞌt u Anás uvaꞌ la eqꞌol bꞌen Aak vatz u Caifás, viqꞌesal oksan iyol tenam vatz Tiixh. As qitzelik ibꞌen veꞌt Aak taꞌn chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","As antelik kuxh txaklik ok u Luꞌeꞌ vatz u xamaleꞌ tiꞌ ileeat tibꞌ. As ech tal veꞌt umaꞌl u uxhchil ileꞌ te naj: —¿Ma jit axh ichusulibꞌ u najeꞌ?— tiꞌk u uxhchileꞌ. As ech tal veꞌt u Luꞌ ileꞌ: —Yeꞌle, jit ineꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","As umaꞌl vikꞌam iqꞌesal oksan iyol tenam vatz Tiixh uvaꞌ tatinik tibꞌ tukꞌ u najeꞌ uveꞌ itzokꞌeꞌl u Luꞌeꞌ vixikineꞌ, as ech tal veꞌt naj ileꞌ te u Luꞌeꞌ: —¿Jit kol vil axh qꞌa tukꞌ u najeꞌ xoꞌl u chikoeꞌ?— tiꞌk u najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","As teesa veꞌt tibꞌ u Luꞌeꞌ kꞌatz u Jesús titoxpa. As bꞌex oqꞌoj veꞌt u peleꞌxheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","As kuꞌsaj chittuꞌ, as eqꞌol el tzan u Jesús tikabꞌal u Caifás tiꞌ ibꞌen Aak tu vikabꞌal u bꞌanol ivatz u ijlenaaleꞌ. Pet nik tal unqꞌa iqꞌesal unqꞌa tenameꞌ uvaꞌ yeꞌ la iyansa tibꞌ chajnaj jaqꞌ u nimla qꞌiieꞌ uvaꞌ pascua. Estiꞌeꞌ jit ok chajnaj tu vikabꞌal u bꞌanol ivatz u ijlenaaleꞌ, aqꞌal uvaꞌ la uch itxꞌaꞌn chajnaj tu u nimla qꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","As el veꞌt chꞌuꞌl u Pilato vatz chajnaj. As ech tal veꞌt naj ileꞌ: —¿Kam ipaav u najeꞌ qꞌi?— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","As ech tal veꞌt chajnaj ileꞌ: —As bꞌaꞌn koj itxumbꞌal naj, as yeꞌl najeꞌ la qaqꞌ veꞌt ok tzan savatz,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","As ech tal veꞌt u Pilato ileꞌ: —Eteqꞌotaj bꞌen naj. As ebꞌantaj isuuchil naj sexoꞌl tukꞌ veleyeꞌ,— tiꞌk naj. As ech tal veꞌt unqꞌa iqꞌesal unqꞌa tenam ileꞌ: —Yeꞌxhkam at tu kuqꞌabꞌ tiꞌ kubꞌanat isuuchil umaj naj tiꞌ ikameꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","As kat chit bꞌex ibꞌan u yoleꞌ uvaꞌ maꞌtik talat u Jesús tiꞌ uvaꞌ la pal unqꞌa uxhchileꞌ stuul uvaꞌ kam ikam Aak la kami. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","As qꞌaavik ok u Pilato tu u kabꞌaleꞌ. As imolo veꞌt naj u Jesús. As ech tal veꞌt naj ileꞌ te Aak: —¿Ma axh u tijlenaal unqꞌa tiaal Israel?— tiꞌk u Pilato. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ech tal veꞌt Aak ileꞌ: —¿Ma axh kuxh ni alon sajunal? ¿Pet moj abꞌil kat alon see sviꞌ?— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","As ech tal veꞌt u Pilato ileꞌ: —¿In kol tiaal Israel qꞌa? ¿Kam kat abꞌana? Tan aꞌ unqꞌa amooleꞌ uveꞌ kat aqꞌon ok tzan axh sunvatz, tukꞌ unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh,— tiꞌk u Pilato. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ech tal veꞌt u Jesús ileꞌ: —As jit vatz txꞌavaꞌilla txumbꞌaleꞌ u vijleꞌmeꞌ tiꞌ vilat isuuchil u tenameꞌ. As ech kojeꞌ, as la ixeꞌtisa vuntenameꞌ chꞌaꞌo uveꞌ atoꞌk sunkꞌatz, tiꞌ uvaꞌ yeꞌ la oksal ok in tiqꞌabꞌ unqꞌa iqꞌesal unqꞌa tenameꞌ. Pet jitꞌeꞌch u vijleꞌmeꞌ uvaꞌ nunbꞌaneꞌ tiꞌ vilat isuuchil vuntenameꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","As ech tal veꞌt u Pilato ileꞌ: —¿Ma axh ijlenaal bꞌa?— tiꞌk u Pilato. As ech tal veꞌt u Jesús ileꞌ: —An chiteꞌ uveꞌ naaleꞌ. Estiꞌeꞌ kat itzꞌebꞌ in as kat ul in vatz u txꞌavaꞌeꞌ tiꞌ ul valat isuuchil u jikla yoleꞌ. As jankꞌal unqꞌa uxhchileꞌ uveꞌ at veꞌt u jikla yoleꞌ tu u taanxelaleꞌ, as ninima vunyoleꞌ,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","As ech tal veꞌt u Pilato ileꞌ: —¿Abꞌiste u jikla yoleꞌ uveꞌ naaleꞌ?— tiꞌk u Pilato. As tul kuxh tal naj u yoleꞌ, as el veꞌt chꞌuꞌl naj kꞌatz u Jesús. As ul veꞌt naj vatz unqꞌa iqꞌesal unqꞌa tenameꞌ. As ech tal veꞌt naj ileꞌ te chajnaj: —Yeꞌl umaj ipaav u najeꞌ nunlejeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","As chiannal veꞌt sete uvaꞌ la unchajpu el umaꞌl u preexhueꞌ tu u nimla qꞌiieꞌ. ¿Ma la esaꞌ uvaꞌ la unchajpu u najeꞌ uvaꞌ ni toksa tibꞌ setijlenaalil?— tiꞌk u Pilato. ");
INSERT INTO ixlNNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","As jolol chit isikꞌin veꞌt unqꞌa tenameꞌ. As ech tal veꞌt ileꞌ: —¡Yeꞌl u najeꞌ la achajpu! ¡Pet aꞌ u Barrabás la achajpu!— tiꞌk unqꞌa tenameꞌ. As tul elqꞌom u Barrabás. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","As tal veꞌt u Pilato iqꞌospu u Jesús taꞌn tzꞌuꞌm. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","As ipaatxꞌu veꞌt unqꞌa soleꞌ umaꞌl u chꞌiꞌx koroona. As taqꞌ veꞌt jeꞌ chajnaj tiꞌ iviꞌ Aak. As toksa veꞌt ok chajnaj umaꞌl u muraꞌt oksaꞌm tiꞌ Aak tiꞌ itzeꞌlel Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","As ech tal veꞌt chajnaj ileꞌ te Aak: —¡Keche, pap, axh u tijlenaal unqꞌa tiaal Israel!— tiꞌk unqꞌa soleꞌ tal te Aak tiꞌ itzeꞌlel Aak. As tul itzꞌich chajnaj ivatz Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","As el veꞌt chꞌuꞌl u Pilato unpajte. As ech tal veꞌt naj ileꞌ: —Tuk veqꞌo el tzan naj sevatz, tiꞌ uvaꞌ la pal ex stuul uvaꞌ yeꞌl umaj ipaav naj nunlejeꞌ,— tiꞌk u Pilato. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","As eqꞌol veꞌt el tzan u Jesús tiꞌ ikꞌuchax vatz unqꞌa tenameꞌ. Atik veꞌt jeꞌ u chꞌiꞌx koroona tiꞌ iviꞌ Aak. As atik veꞌt ok u muraꞌt oksaꞌmeꞌ tiꞌ Aak. As ech tal veꞌt u Pilato ileꞌ te unqꞌa tenameꞌ: —Il naj ilaꞌ. As ex la ilon kam la etulbꞌe naj,— tiꞌk u Pilato. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","As tul til veꞌt unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh tukꞌ unqꞌa xeen tetz u tostiixheꞌ u Jesús, as taqꞌ veꞌt jeꞌ chajnaj tuul iviꞌ. As ech tal veꞌt chajnaj ileꞌ: —¡Yatzꞌpoj naj vatz u kuruseꞌ! ¡Yatzꞌpoj naj vatz u kuruseꞌ!— tiꞌk chajnaj. As ech tal veꞌt u Pilato ileꞌ: —Sunvatz as yeꞌl ipaav naj ati. Asoj ex la alon, as eteqꞌotaj naj. As eyatzꞌtaj naj vatz u kuruseꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","As ech tal veꞌt unqꞌa iqꞌesal unqꞌa tenam ileꞌ: —At umaꞌl u tzaqꞌit uvaꞌ nimamal sqaꞌn. As aꞌ ni taleꞌ uvaꞌ la kam u najeꞌ, tan tiꞌ uvaꞌ ni toksa tibꞌ naj iKꞌaol u Tiixheꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","As tul tabꞌi veꞌt u Pilato u yoleꞌ, as aal chit xoꞌv veꞌt naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","As qꞌaavik veꞌt ok naj tu kabꞌal unpajte tukꞌ u Jesús. As ech tal veꞌt naj ileꞌ te Aak: —¿Katil tzaanajkat axh?— tiꞌk naj. As jit tal u Jesús umaj yol te naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","As ech tal veꞌt u Pilato ileꞌ unpajte: —¿Kam qꞌi yeꞌ nakꞌulbꞌe in? ¿Ma yeꞌ ootzimal aꞌn uvaꞌ at tunqꞌabꞌ tiꞌ unchajput axh as tiꞌ vaqꞌat jeꞌ axh vatz u kuruseꞌ?— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","As ech tal veꞌt u Jesús ileꞌ: —Yeꞌ koj kat aqꞌax see taꞌn vunBꞌaaleꞌ uvaꞌ at tu almikaꞌ, as yeꞌl eetzeꞌ taꞌ sviꞌ. Estiꞌeꞌ uvaꞌ yeꞌ la lejon vapaaveꞌ tiꞌ vipaav u najeꞌ uvaꞌ kat aqꞌon ok in see,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","As tul tabꞌi veꞌt u Pilato viyol u Jesús, as xeꞌt ichuk veꞌt naj txumbꞌal tiꞌ ichajpul Aak. As aal chit taqꞌ veꞌt jeꞌ unqꞌa iqꞌesal unqꞌa tenameꞌ tuul iviꞌ tiꞌ isikꞌineꞌ. As ech tal veꞌt chajnaj ileꞌ: —¡Asoj tuk achajpu el u najeꞌ, as jit kꞌulel tibꞌ ayol tukꞌ u qijlenaaleꞌ tu u Roma, tan abꞌil umaj uvaꞌ la toksa tibꞌ ijlenaalil vatz u qijlenaaleꞌ as ni teesa naj iqꞌii u qijlenaaleꞌ!— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","As tul tabꞌi u Pilato viyol chajnajeꞌ, as teqꞌo veꞌt el tzan naj u Jesús unpajte. As xonebꞌ veꞌt naj tu vixhiilaeꞌ uveꞌ nikat ibꞌankat naj isuuchil unqꞌa preexhueꞌ vatz u qꞌanaleꞌ uvaꞌ lemelik kuꞌ kꞌubꞌ vatz uvaꞌ Gábata ibꞌii tu yolbꞌal hebreo. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","As ech kuxh veꞌt qꞌejal u xeem qꞌiieꞌ tu u nimla qꞌiieꞌ uvaꞌ pascua. As tul maꞌtik ichaqꞌaan veꞌt qꞌii, as ech tal veꞌt u Pilato ileꞌ te unqꞌa iqꞌesal unqꞌa tiaal Israel: —¡Il vetijlenaal ilaꞌ!— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","As aal chit taqꞌ veꞌt jeꞌ chajnaj tuul iviꞌ tiꞌ isikꞌineꞌ. As ech tal veꞌt chajnaj ileꞌ: —¡Eqꞌoloj naj! ¡Eqꞌoloj naj! ¡As yatzꞌpoj naj vatz u kuruseꞌ!— tiꞌk chajnaj. As ech tal veꞌt u Pilato ileꞌ: —¿Ma aꞌ netaleꞌ uvaꞌ la val iyatzꞌpu vetijlenaaleꞌ vatz u kuruseꞌ?— tiꞌk naj. As ech tal veꞌt unqꞌa iqꞌesal unqꞌa nachol Tiixh ileꞌ: —¡Yeꞌl umaꞌtoj qijlenaal tiꞌ u ijlenaaleꞌ tu u Roma uvaꞌ César!— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","As tul tabꞌi veꞌt u Pilato u yoleꞌ, as taqꞌ veꞌt ok naj u Jesús te chajnaj. As teqꞌo veꞌt chajnaj Aak tiꞌ iyatzꞌpu vatz u kuruseꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","As ijamal veꞌt u kuruseꞌ taꞌn u Jesús tul el chꞌuꞌl Aak tiꞌ ibꞌen taꞌn chajnaj tu u atinbꞌaleꞌ uvaꞌ «Tatinbꞌal Bꞌajil Kꞌoꞌn» chꞌelel. As Gólgota ibꞌii tu yolbꞌal hebreo. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","As tzitziꞌ aqꞌpikkat jeꞌ Aak vatz u kuruseꞌ. As jeꞌ veꞌt kaꞌvaꞌt unqꞌa naj vatz kaꞌvaꞌt unqꞌa kuruseꞌ: umaꞌl naj jeꞌ tisebꞌal Aak; as umaꞌt naj timax Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","As tal veꞌt u Pilato itzꞌibꞌal kaꞌl unqꞌa tzꞌibꞌ vatz umaꞌl u tal aqꞌen uvaꞌ ech nik tal ileꞌ: Aꞌ U JESÚS, U AA NAZARET, UVAꞌ TIJLENAAL UNQꞌA TIAAL ISRAEL, tiꞌk u yoleꞌ uvaꞌ kat aqꞌax jeꞌ tiviꞌ u kuruseꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","As yeꞌ saach unqꞌa tiaal Israel sikꞌlen u tzꞌibꞌeꞌ, tan najlik kuxh ixoꞌl u Jerusalén tukꞌ u atinbꞌaleꞌ uveꞌ jeꞌkat u Jesús vatz u kuruseꞌ. Tu oxvaꞌl yolbꞌal tzꞌibꞌalkat: tu hebreo, tu latín, as tukꞌ tu griego. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","As ech tal veꞌt unqꞌa iqꞌesal oksan iyol tenam vatz Tiixh ileꞌ te u Pilato: —Yeꞌ koj kat aal itzꞌibꞌaleꞌ uvaꞌ qijlenaal u Jesús. Pet aꞌ koj kat aal itzꞌibꞌaleꞌ uvaꞌ ni toksa tibꞌ naj ijlenaalil,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ech tal veꞌt u Pilato ileꞌ: —Yeꞌle, tan kam uveꞌ kat val itzꞌibꞌaleꞌ as yeꞌ la uch ijalpul veꞌteꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","As tul olebꞌ veꞌt unqꞌa soleꞌ tiꞌ ijeꞌ u Jesús vatz u kuruseꞌ, as ijatx veꞌt chajnaj u toksaꞌm Aakeꞌ svatzaj. As kajvaꞌl elkat u toksaꞌm Aakeꞌ stuul, tan junun ibꞌen veꞌt vatz chajnaj. As teqꞌo tzan chajnaj umaꞌt u chelkin toksaꞌm Aak uvaꞌ yeꞌl itzꞌisbꞌal atike, ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","tan ech tal veꞌt chajnaj ileꞌ svatzaj: —Yeꞌ la ibꞌaneꞌ uvaꞌ la kujatx sukuvatz. Pet tuk kubꞌan umaꞌl u txꞌakiibꞌ. As abꞌiste oꞌ uvaꞌ la txꞌakon, as oꞌ la eqꞌon,— tiꞌk unqꞌa soleꞌ. As aꞌ chiteꞌ bꞌex ibꞌana uvaꞌ tzꞌibꞌamal kan uvaꞌ ech ni tal ileꞌ: Kat ijatx chajnaj u voksaꞌmeꞌ svatzaj. As kat itxꞌak tibꞌ stiꞌ, tiꞌk u yoleꞌ. As aꞌ chiteꞌ kat ibꞌan unqꞌa soleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","As txaklik veꞌt vitxutx u Jesús kꞌatz u kuruseꞌ tukꞌ u titzꞌin vitxutx Aakeꞌ uvaꞌ Maꞌl ibꞌii, u tixqel u Cleofas, as tukꞌ umaꞌt u Maꞌl uvaꞌ tzaanaj tu u tenam uvaꞌ Magdala. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","As isaji veꞌt bꞌen u Jesús vitxutxeꞌ tukꞌ umaꞌl vichusulibꞌeꞌ uveꞌ kꞌulik chit tibꞌ iyol Aak stukꞌ. As ech tal veꞌt Aak ileꞌ te vitxutxeꞌ: —Aꞌ veꞌt unchꞌexeleꞌ vunchusulibꞌeꞌ la ibꞌaneꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","As ech tal veꞌt Aak ileꞌ te vichusulibꞌeꞌ: —Aꞌ veꞌt atxutxeꞌ vuntxutxeꞌ la ibꞌaneꞌ,— tiꞌk Aak. As an chit tu u qꞌiieꞌ ikꞌul veꞌt ok vichusulibꞌ Aakeꞌ vitxutxeꞌ tu vikabꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","As ootzimalik taꞌn u Jesús uvaꞌ bꞌiitik kuxh itzojpisat Aak jankꞌal uveꞌ ul ibꞌan Aak. As ech tal veꞌt Aak ileꞌ: —Nitzaj untziꞌ,— tiꞌk Aak. As bꞌex ibꞌan u yoleꞌ, uvaꞌ tzꞌibꞌamal kan tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","As atik umaꞌl u xhaalo uvaꞌ noonalike taꞌn kꞌayla taꞌl uuva. As takꞌsa veꞌt unqꞌa soleꞌ umaꞌl u patxkin kꞌoo. As taqꞌ veꞌt jeꞌ chajnaj titziꞌ Aak taꞌn umaꞌl u qꞌabꞌ tzeꞌ, uvaꞌ hisopo ibꞌii. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Tul maꞌtik tukꞌat Aak u kꞌayla taꞌl uuvaeꞌ, as ech tal veꞌt Aak ileꞌ: —¡Kat tzojpiy veꞌteꞌ skajayil!— tiꞌk Aak. As ivichꞌqꞌu veꞌt tibꞌ iviꞌ Aak. Taqꞌ veꞌt ok Aak u taanxelaleꞌ te u Tiixheꞌ. As kam veꞌt Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","As ijaj veꞌt unqꞌa iqꞌesal unqꞌa tenameꞌ bꞌaꞌnil te u Pilato uvaꞌ la bꞌen vuchꞌpoj unqꞌa ikux unqꞌa najeꞌ uvaꞌ atik jeꞌ vatz unqꞌa kuruseꞌ, aqꞌal uvaꞌ oora kuxh la kami, tan ech veꞌt qꞌejal u xeem qꞌiieꞌ tu u nimla qꞌiieꞌ uvaꞌ pascua. As la eesal kuꞌ tzan unqꞌa kamnajeꞌ vatz u kuruseꞌ uvaꞌ nik taleꞌ, tan yeꞌ la uch ikaa vatz u kuruseꞌ tu u xeem qꞌiieꞌ. As nimla yolik chit u xeem qꞌiieꞌ te chajnaj tu u nimla qꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","As ichaj veꞌt bꞌen u Pilato unqꞌa soleꞌ. As bꞌaxel kat vuchꞌpu toj umaꞌl naj. As vuchꞌpu veꞌt u toj umaꞌt naj uvaꞌ atik jeꞌ vatz unqꞌa kuruseꞌ txala u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","As tul oon veꞌt unqꞌa soleꞌ kꞌatz Aak, as jit ivuchꞌ veꞌt chajnaj u toj Aakeꞌ, tan til chajnaj uvaꞌ maꞌtik ikam veꞌt Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pet itoqꞌ veꞌt jeꞌ umaꞌl u sol u txala tuul Aakeꞌ taꞌn umaꞌl u jutzꞌ viꞌ chꞌichꞌ. As yak kuxh el veꞌt chꞌuꞌl kaj tukꞌ aꞌ txala tuul Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","As ineꞌ ilon kam uveꞌ kat ibꞌan u Jesús. As ni val veꞌt isuuchil sete, tan an chiteꞌ uveꞌ ni val sete. As ootzimal svaꞌn uvaꞌ jik chit ni valeꞌ, aqꞌal uvaꞌ la ekꞌujbꞌaꞌ ekꞌuꞌl tiꞌ u Jesús, ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","tan echeꞌ ibꞌan kuxh koj. Pet aꞌeꞌ bꞌex ibꞌana uvaꞌ tzꞌibꞌamal kan uvaꞌ ech ni tal ileꞌ: Echeꞌ la koj vuchꞌpu umaj vibꞌajil u jikla uxhchileꞌ, tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","As ech ni tal umaꞌt u yol ileꞌ: La til unqꞌa tenameꞌ umaꞌl u uxhchil uvaꞌ maꞌt qoplu u txala tuuleꞌ taꞌn chꞌichꞌ, tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","As tul maꞌtik ikam veꞌt u Jesús, as bꞌex ijaj veꞌt u Xhuꞌl u aa Arimatea bꞌaꞌnil te u Pilato tiꞌ teqꞌol vichiꞌol u Jesús, tan nimamalik u Jesús taꞌn u Xhuꞌleꞌ. As yeꞌ nikat tal tibꞌ naj, tan nikat ixoꞌv naj vatz unqꞌa imooleꞌ uvaꞌ iqꞌesal unqꞌa tenameꞌ. As tal veꞌt u Pilato te unqꞌa isoleꞌ uvaꞌ la uch taqꞌax vichiꞌol u Jesús te u Xhuꞌleꞌ. As bꞌex teqꞌo veꞌt kuꞌ tzan u Xhuꞌleꞌ vichiꞌol Aakeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","As antik u Nicodemo uvaꞌ bꞌex qꞌelun u Jesús aqꞌbꞌal, as ul veꞌt naj tukꞌ umaꞌl u txꞌumtxꞌulla tzꞌakabꞌal uvaꞌ mirra ibꞌii kamal viinqil aalmo talal, tan yuelik tibꞌ u mirra tukꞌ umaꞌt u tzꞌakabꞌal uvaꞌ áloe. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","As teqꞌo veꞌt chajnaj vichiꞌol u Jesús. As toksa veꞌt chajnaj u txꞌumtxꞌulla tzꞌakabꞌaleꞌ stiꞌ. As ibꞌoch veꞌt chajnaj tu kaꞌl unqꞌa bꞌaꞌnla ixbꞌuꞌj, tan ech chit nibꞌan unqꞌa tiaal Israel tiꞌ imujat unqꞌa ikamnajeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","As atik chiko kꞌatz u atinbꞌaleꞌ uveꞌ aqꞌpikkat jeꞌ u Jesús vatz u kuruseꞌ. As atik umaꞌl u jul tzitziꞌ uvaꞌ aꞌn kꞌotike uvaꞌ yeꞌxnik mujlu umaj kamnaj stuul. ");
INSERT INTO ixlNNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","As tzitziꞌ imujkat chajnaj u Jesús, tan tiꞌ uvaꞌ aalik ixeꞌt veꞌt u xeem qꞌiieꞌ tu u nimla qꞌiieꞌ uvaꞌ pascua as najlik kuxh u juleꞌ uveꞌ kamkat Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","As bꞌiitik chit isajbꞌeꞌ tu u bꞌaxa qꞌiieꞌ tu u xhemaanaeꞌ, as bꞌen veꞌt u Maꞌleꞌ uveꞌ tzaanaj tu u tenam uvaꞌ Magdala kꞌatz u juleꞌ uvaꞌ mujlukat u Jesús. Tul oon veꞌt ixoj tziꞌ u juleꞌ, as til veꞌt ixoj uvaꞌ maꞌtik teesal veꞌt u sivaneꞌ tziꞌ u juleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","As qꞌax ibꞌen veꞌt ixoj. As bꞌex tal veꞌt ixoj te u Simón uvaꞌ Luꞌ as te umaꞌt vichusulibꞌ Aakeꞌ uveꞌ kꞌulik chit tibꞌ iyol Aak stukꞌ. Ech bꞌex tal ixoj ileꞌ: —¡Kat bꞌex eqꞌolyu vichiꞌol u Kubꞌaal Jesús tu u juleꞌ! As yeꞌ qootzaj katil bꞌex aqꞌaxojkat,— tiꞌk ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","As el veꞌt chꞌuꞌl u Luꞌeꞌ tukꞌ umaꞌt vichusulibꞌ Aakeꞌ. As bꞌex veꞌt chajnaj tziꞌ u juleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Vaꞌlik chit toojeꞌl chajnaj tiꞌ ibꞌeneꞌ. As pal chit toojeꞌl vimool u Luꞌeꞌ, tan naj oon bꞌaxa tziꞌ u juleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","As kꞌoebꞌ naj tiꞌ tilat ok tu u juleꞌ. As jit ok naj. As aꞌ kuxh veꞌt unqꞌa maantaeꞌ tiloꞌk naj uvaꞌ atik kan uveꞌ bꞌochlukat u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","As tul oon veꞌt u Simón uvaꞌ Luꞌ, as yakik ok naj tu u juleꞌ. As til veꞌt naj u maantaeꞌ uvaꞌ atik kan ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","tukꞌ u suꞌteꞌ uveꞌ bꞌochlukat viviꞌ u Jesús. As vaꞌlen bꞌalqꞌumalikkat veꞌt kan u suꞌteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","As ok veꞌt vimool u Luꞌeꞌ uvaꞌ oon bꞌaxa tziꞌ u juleꞌ. As tul til naj uveꞌ yeꞌlik veꞌt u Jesús tu u juleꞌ, as yak kuxh inima veꞌt naj uvaꞌ maꞌtik tul taama Aak, ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","tan yeꞌxnik pal chajnaj stuul tiꞌ uveꞌ tzꞌibꞌamal kan uvaꞌ la ul taama u Jesús unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","As qꞌaav veꞌt kaꞌvaꞌl vichusulibꞌ Aakeꞌ kꞌatz unqꞌa imooleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","As bꞌiilik kuxh stuul, as oon veꞌt u Maꞌleꞌ uveꞌ aa Magdala tziꞌ u juleꞌ unpajte. As vaꞌlik chit toqꞌ ixoj. As tul nikat toqꞌ ixoj, as kꞌoebꞌ veꞌt ixoj tiꞌ isajit ok tuul u juleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","As til veꞌt ok ixoj kaꞌvaꞌl unqꞌa ángel uvaꞌ vaꞌlik chit ipolal unqꞌa toksaꞌmeꞌ. Xonlik umaꞌl u ángel viꞌ u sivaneꞌ uveꞌ atikkat bꞌen iviꞌ u Jesús. As xonlik umaꞌte uveꞌ atikkat bꞌen u toj Aakeꞌ tu uveꞌ mujlukat Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","As ech tal veꞌt unqꞌa ángel ileꞌ te u Maꞌleꞌ: —¿Ixoj, kam nooqꞌle?— tiꞌk unqꞌa ángel. Ech tal veꞌt u Maꞌl ileꞌ: —Ni voqꞌeꞌ, tan tiꞌ uveꞌ kat eqꞌoliy veꞌt u Kubꞌaal Jesús. As yeꞌ vootzaj katil kat eqꞌolkat,— tiꞌk ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","As tul kuxh tal ixoj u yoleꞌ, as isuchqꞌi tibꞌ ixoj. Til veꞌt ixoj uvaꞌ txaklik veꞌt ok u Jesús kꞌatz ixoj. As jit texhla ixoj Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","As ech tal veꞌt Aak ileꞌ: —¿Ixoj, kam nooqꞌle? ¿Abꞌil nachukeꞌ?— tiꞌk Aak. Ech tal veꞌt ixoj ileꞌ: —Pap, asoj axh kat eqꞌon, as al sve katil bꞌex aaqꞌkat. As la bꞌen veqꞌo,— tiꞌk ixoj, tan kamal u xeen tetz unqꞌa chikoeꞌ u najeꞌ uvaꞌ nik tal ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","As ech tal veꞌt u Jesús ileꞌ: —¡Maꞌl!— tiꞌk Aak. As isuchqꞌi veꞌt tibꞌ ixoj. As ech tal veꞌt ixoj ileꞌ tu yolbꞌal hebreo: —¡Raboni!— tiꞌk ixoj. As aꞌ isuuchil u yoleꞌ Raboni uvaꞌ Chusul qetz tu kuyolbꞌal. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","As ech tal veꞌt u Jesús ileꞌ: —Chajpu in, tan yeꞌ bꞌenoj in kꞌatz vunBꞌaaleꞌ. Pet kuxh al te unqꞌa eetz chusulibꞌeꞌ, tan bꞌen veꞌt in kꞌatz vunBꞌaaleꞌ uvaꞌ eBꞌaal, as vunTiixheꞌ uvaꞌ eTiixh,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","As bꞌex veꞌt ixoj unpajte kꞌatz unqꞌa tetz chusulibꞌeꞌ. As bꞌex tal veꞌt ixoj uvaꞌ maꞌtik tilat ixoj Aak. As tal veꞌt ixoj kam uvaꞌ kat tal Aak te ixoj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","As an chit tu u bꞌaxa qꞌiieꞌ tu u xhemaanaeꞌ, as molik veꞌt tibꞌ unqꞌa ichusulibꞌ Aakeꞌ tul uvaꞌ maꞌtik itzꞌotin veꞌteꞌ. As kolimalik u kabꞌaleꞌ, tan nikat ixoꞌv chajnaj vatz unqꞌa iqꞌesal unqꞌa tenameꞌ. As ul veꞌt u Jesús txakebꞌoj xoꞌl chajnaj. As ech tal veꞌt Aak ileꞌ: —As bꞌaꞌnoj etatin sevatzaj sekajayil,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","As tul tal Aak u yoleꞌ, as ikꞌuch veꞌt Aak viqꞌabꞌeꞌ tukꞌ u txala tuuleꞌ te chajnaj. As vaꞌlik chit itxuqꞌtxun veꞌt chajnaj tul til chajnaj Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","As ech tal veꞌt Aak ileꞌ te chajnaj unpajte: —Aꞌ vibꞌaꞌnil u Tiixheꞌ la atin sexoꞌl. As tuk unchaj bꞌen ex tiꞌ talax vunyoleꞌ echeꞌ kat ibꞌan u Kubꞌaal Tiixheꞌ sve, tan kat ichaj tzan in Aak tiꞌ talax viyoleꞌ sexoꞌl,— tiꞌk u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","As tul tal u Jesús u yoleꞌ, as ixuli bꞌen Aak vixeveꞌ. As ech tal Aak ileꞌ: —Ekꞌultaj u Tiixhla Espíritu, ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","tan abꞌil uvaꞌ la etal isotz ipaav, as la sotz ipaav. Pet abꞌil uvaꞌ yeꞌ la etal isotz ipaav, as yeꞌl ipaav la sotzi,— tiꞌk Aak te unqꞌa ichusulibꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","As u Maxh uvaꞌ Xuꞌm chꞌelel uvaꞌ atik ok xoꞌl kabꞌlaval unqꞌa ichusulibꞌ u Jesús, as yeꞌlik naj tul ikꞌuch tibꞌ u Jesús xoꞌl unqꞌa ichusulibꞌeꞌ bꞌaxa. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","As tul ul veꞌt naj, as ech tal veꞌt ok unqꞌa imool naj ileꞌ ste: —Kat qillu veꞌt u Kubꞌaal Jesús,— tiꞌk chajnaj. As ech tal veꞌt u Maxh ileꞌ: —Lanal vil u tokebꞌal unqꞌa laavuxheꞌ tu viqꞌabꞌeꞌ, as lanal voksa u viꞌ unqꞌabꞌeꞌ stuul as tukꞌ u txala tuul Aakeꞌ uveꞌ qopel, as aꞌn la unnimaeꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","As ech vaaxit qꞌii stuul, as jupik tibꞌ unqꞌa ichusulibꞌ u Jesús tu u kabꞌal unpajte. As atik u Maxheꞌ xoꞌl chajnaj. As aat kuxh til chajnaj uvaꞌ txaklik veꞌt ok Aak xoꞌl chajnaj. As ech tal veꞌt Aak ileꞌ: —Aꞌ vibꞌaꞌnil u Tiixheꞌ la kaa sexoꞌl,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","As ech tal veꞌt Aak ileꞌ te u Maxheꞌ: —Oksa u viꞌ aqꞌabꞌeꞌ tu uveꞌ kꞌaxbꞌinale. As oksa viꞌ aqꞌabꞌeꞌ tu u txala vuuleꞌ unpajte. As yeꞌ kuxh kaꞌkabꞌin aama. Pet kꞌujbꞌaꞌ akꞌuꞌl sviꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","As ech tal veꞌt u Maxh ileꞌ: —Kubꞌaal Jesús, as axheꞌ vunTiixheꞌ,— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","As ech tal veꞌt u Jesús ileꞌ: —Katnal chit eel in, Maxh. As aꞌn kat anima veꞌt in. Pet achvebꞌal chit unqꞌa uxhchileꞌ uveꞌ kꞌuxh yeꞌ kat til in, as ninima veꞌt in,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","As nimatel unqꞌa kꞌuchbꞌal tetz u tijleꞌm u Jesús kat ikꞌuch vatz unqꞌa ichusulibꞌeꞌ. As yeꞌxhkam tzꞌibꞌamal kan tu u uꞌujeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pet jankꞌal unqꞌa viꞌlaꞌ uvaꞌ tzꞌibꞌamal kan, as kat tzꞌibꞌal kan tiꞌ uvaꞌ la kukꞌujbꞌaꞌ kukꞌuꞌl tiꞌ u Jesús uvaꞌ Aak u Cristo, viKꞌaol u Tiixheꞌ. As estiꞌeꞌ uvaꞌ at veꞌt kutiichajil kꞌatz u Tiixheꞌ tukꞌ vibꞌii Aakeꞌ, asoj kꞌujleꞌl kukꞌuꞌl tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","As xamtik veꞌt stuul, as ikꞌuch veꞌt tibꞌ u Jesús vatz unqꞌa ichusulibꞌeꞌ unpajte tziꞌ u mar uveꞌ Tiberias ibꞌii. As tul ikꞌuch veꞌt tibꞌ Aak te chajnaj, ");
INSERT INTO ixlNNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","as kꞌulik tibꞌ u Simón uvaꞌ Luꞌ, tukꞌ u Maxh uvaꞌ Xuꞌm ni talpeꞌ, tukꞌ u Natanael uvaꞌ aa Caná uvaꞌ echen tu u Galilea, tukꞌ kaꞌvaꞌt vikꞌaol u Zebedeo, as tukꞌ kaꞌvaꞌt unqꞌa ichusulibꞌ Aakeꞌ unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","As ech tal veꞌt u Luꞌ ileꞌ te chajnaj: —Maꞌt in tiꞌ untxeyat txay,— tiꞌk naj. Ech tal veꞌt unqꞌa imool u Luꞌ ileꞌ: —La bꞌen oꞌ seeꞌ,— tiꞌk chajnaj. As bꞌen veꞌt chajnaj tiꞌ naj. As ok veꞌt chajnaj tu umaꞌl u barco. As umaꞌl chit aqꞌbꞌal chajnaj tiꞌ itxeyat txay. As jit olebꞌ chajnaj tiꞌ itxeyat umaj txoo. ");
INSERT INTO ixlNNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","As tul aalik isajbꞌu veꞌteꞌ, as aat kuxh til chajnaj uvaꞌ txaklik veꞌt u Jesús tziꞌ u mar. As jit texhla chajnaj Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","As ech tal veꞌt bꞌen Aak ileꞌ te chajnaj: —Keche, vitzꞌin vatzik, ¿ma at echbꞌubꞌal uvaꞌ la vechbꞌu?— tiꞌk Aak. —Yeꞌxhkam ati,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","As ech tal veꞌt bꞌen Aak ileꞌ te chajnaj: —Etaqꞌtaj bꞌen u kꞌacheꞌ tisebꞌal u barco, tan tzitziꞌ la elejkat txoo,— tiꞌk Aak. As ibꞌan chajnaj kam uveꞌ tal Aak. As tul teqꞌo veꞌt jeꞌ tzan chajnaj u kꞌacheꞌ, as echeꞌ nikat koj tolebꞌ veꞌt chajnaj tiꞌ teqꞌot jeꞌ tzan u kꞌacheꞌ tukꞌ unqꞌa mamaꞌla chaj txayeꞌ xeꞌ u aꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","As yolon veꞌt u chusulibꞌeꞌ uvaꞌ kꞌulik chit tibꞌ iyol Aak stukꞌ. As ech tal veꞌt ok naj ileꞌ te u Luꞌeꞌ: —¿Kam qꞌi? ¡Tan aꞌ u Kubꞌaal Jesús vil!— tiꞌk naj. As tul tabꞌi veꞌt u Simón uvaꞌ Luꞌ, as il kuxh toksat veꞌt naj u toksaꞌmeꞌ, tan eesamalik u toksaꞌm najeꞌ staꞌn. As isuti veꞌt tibꞌ naj xeꞌ u aꞌeꞌ tiꞌ toon kꞌatz u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Pet ech koj unqꞌa imool u Luꞌeꞌ, tan qꞌoon kuxh tel chꞌuꞌl chajnaj tukꞌ u barco, tan najlik u barco tziꞌ u aꞌeꞌ. As kamal kajvaꞌl kuxh kꞌaꞌj atik ok u barco tziꞌ u aꞌeꞌ. As tzujumal tel chꞌuꞌl u kꞌacheꞌ ibꞌan chajnaj, tan noonalik chit veꞌt u kꞌacheꞌ taꞌn unqꞌa txayeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","As tul el veꞌt chꞌuꞌl chajnaj tu u barco, as til veꞌt chajnaj uvaꞌ atik veꞌt txaꞌ xamal tziꞌ u aꞌeꞌ. As atik jeꞌ umaꞌl u txay viꞌ u txaꞌ xamaleꞌ. As atik kaꞌl unqꞌa paan skꞌatz. ");
INSERT INTO ixlNNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","As ech tal veꞌt u Jesús ileꞌ: —Eteqꞌotaj tzan kaꞌvoꞌj unqꞌa txayeꞌ uveꞌ aꞌn kat etxeya,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","As jeꞌ veꞌt u Simón uvaꞌ Luꞌ tu u barco. As bꞌex iqini veꞌt el tzan naj u kꞌacheꞌ uveꞌ noonalik taꞌn unqꞌa nimla chaj txayeꞌ, tan oxlaval ivaaxajkꞌalal (153) unqꞌa txayeꞌ atik ok tu u kꞌacheꞌ. As yeꞌl u kꞌacheꞌ kat ratꞌmi jaqꞌ talal unqꞌa txayeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","As ech tal veꞌt u Jesús ileꞌ: —Siꞌunaj. Etzujbꞌetaj etibꞌ,— tiꞌk Aak. As echeꞌ abꞌiste koj umaj unqꞌa ichusulibꞌ Aakeꞌ chꞌotin ste uvaꞌ, «¿Abꞌiste axh qꞌi?» tiꞌk koj chajnaj. Pet atik veꞌt skꞌuꞌl chajnaj uvaꞌ aꞌik u Kubꞌaal Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","As itxey u Jesús u paaneꞌ. As ijatx veꞌt Aak xoꞌl chajnaj. As echat chit ibꞌan Aak tiꞌ u txayeꞌ unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Tan itoxpa uveꞌ ikꞌuchat tibꞌ Aak vatz unqꞌa ichusulibꞌeꞌ, tan maꞌtik tul taama Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","As tul bꞌaꞌnxi itxꞌaꞌn chajnaj, as ech tal veꞌt u Jesús ileꞌ te u Simón uvaꞌ Luꞌ: —¿Simón, ikꞌaol Jonás, ma xoꞌn in see tiꞌ unqꞌa amooleꞌ?— tiꞌk Aak. Ech tal veꞌt u Luꞌ ileꞌ: —Kano, Pap, ootzimaleꞌ aꞌn uvaꞌ xoꞌn axh sve,— tiꞌk naj. As ech tal veꞌt Aak ileꞌ: —Loch unqꞌa niman vetzeꞌ. As ech axeaateꞌ echeꞌ ixeep unqꞌa talaj kaneeroꞌeꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","As ech tal veꞌt u Jesús ileꞌ tikaꞌpa: —¿Simón, ikꞌaol Jonás, ma xoꞌn in see?— tiꞌk Aak. Ech tal veꞌt u Luꞌ ileꞌ: —Kano, Pap, ootzimaleꞌ aꞌn uvaꞌ xoꞌn axh sve,— tiꞌk naj. Ech tal veꞌt u Jesús ileꞌ: —As la eel unqꞌa niman vetzeꞌ. As ech axeaateꞌ echeꞌ ixeep unqꞌa kaneeroꞌeꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","As ech tal veꞌt u Jesús ileꞌ titoxpa: —¿Simón, ikꞌaol Jonás, ma xoꞌn in see?— tiꞌk Aak. As txumun veꞌt taama u Luꞌeꞌ, tan tiꞌ uvaꞌ ichꞌoti Aak te naj titoxpa tiꞌ uvaꞌ ma xoꞌn Aak te naj. As ech tal veꞌt naj ileꞌ: —Pap, ootzimal chiteꞌ aꞌn skajayil. As ootzimaleꞌ aꞌn uvaꞌ xoꞌn axh sve,— tiꞌk naj. As ech tal veꞌt u Jesús ileꞌ: —Loch unqꞌa niman vetzeꞌ. As ech axeaateꞌ echeꞌ ixeep unqꞌa kaneeroꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","As jik chit tuk val see, tan tul uvaꞌ txulnalik axh, as kat achabꞌa ajikꞌat xeꞌ avuul taꞌn vakꞌalbꞌaleꞌ. As kꞌuxh katil kuxh kat aalkat abꞌeneꞌ as aꞌ kat bꞌenkat axh tzitziꞌ. Pet tul la qꞌesbꞌu veꞌt axh, as la oon veꞌt umaꞌl u qꞌii uvaꞌ la aaqꞌ veꞌt el aqꞌabꞌ. As vaꞌlen la kꞌalon veꞌt xeꞌ avuul. As la eqꞌol veꞌt bꞌen axh katil uvaꞌ yeꞌ la asaꞌkat abꞌeneꞌ,— tiꞌk Aak tal te u Luꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","As tal veꞌt u Jesús unqꞌa yoleꞌ tiꞌ ikꞌuchat veꞌt te u Luꞌeꞌ uvaꞌ kam ikam naj la kami tiꞌ toksal iqꞌii u Tiixheꞌ. As tul kuxh tal u Jesús unqꞌa yoleꞌ, as ech tal veꞌt Aak ileꞌ unpajte: —Aqꞌ yakꞌil tiꞌ uvaꞌ ni val see,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","As isuchqꞌi veꞌt tibꞌ u Luꞌeꞌ. As til veꞌt naj umaꞌt vimooleꞌ uvaꞌ xekik tiꞌ u Jesús. As aꞌ u chusulibꞌeꞌ uvaꞌ kꞌulik chit tibꞌ iyol Aak stukꞌ. As najeꞌ uvaꞌ atik ok iviꞌ tziꞌ taama Aak tul nik itxꞌaꞌn chajnaj tukꞌ Aak. As najeꞌ chꞌotin te Aak abꞌiste u najeꞌ uvaꞌ la kꞌayin Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","As tul til u Luꞌeꞌ u najeꞌ, as ichꞌoti veꞌt naj te u Jesús. As ech tal u Luꞌ ileꞌ: —¿Pap, kam tuk ibꞌan u najeꞌ qꞌi?— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ech tal veꞌt Aak ileꞌ: —Ineꞌ taꞌ tiꞌ naj. Tan asoj la valeꞌ uvaꞌ latel itxꞌebꞌ in naj tiꞌ u vulebꞌaleꞌ, as ineꞌ taꞌ la alon. As yeꞌ eetz tiꞌ naj. Pet aqꞌ yakꞌil tiꞌ uvaꞌ kat val see,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Estiꞌeꞌ abꞌil veꞌt umaꞌl u yol tiꞌ u chusulibꞌeꞌ xoꞌl unqꞌa qitzꞌin qatzikeꞌ uvaꞌ yeꞌl naj la kam veꞌteꞌ. As jitꞌeꞌch viyol u Jesús tala tiꞌ u najeꞌ uvaꞌ yeꞌl naj la kam veꞌteꞌ. Pet taꞌn kuxh tal Aak uvaꞌ: «Asoj la valeꞌ uvaꞌ latel itxꞌebꞌ in naj tiꞌ u vulebꞌaleꞌ, as yeꞌ eetz tiꞌ naj,» tiꞌk Aak tala. ");
INSERT INTO ixlNNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","As ineꞌ taꞌ in Xhun, vichusulibꞌ u Jesús, uvaꞌ ni alon isuuchil u yoleꞌ tiꞌ unqꞌa veeꞌ kat vila. As ineꞌ tzꞌibꞌan tetz unqꞌa yolaꞌ. Estiꞌeꞌ uvaꞌ ootzimal veꞌt setaꞌn uvaꞌ jik chit unqꞌa yoleꞌ uveꞌ kat untzꞌibꞌa kan tiꞌ Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","As yeꞌ saach unqꞌa veeꞌ kat ibꞌan u Jesús. As la koj tzꞌibꞌal kan unqꞌa veeꞌ skajayil uvaꞌ ul ibꞌan Aak vatz u txꞌavaꞌeꞌ, as ni vitzꞌa uvaꞌ yeꞌ la tzꞌaj veꞌteꞌ vatz u txꞌavaꞌeꞌ tiꞌ unqꞌa uꞌujeꞌ uvaꞌ la tzꞌibꞌal unqꞌa yoleꞌ stuul. An chiteꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","As tul vaqꞌ bꞌen u bꞌaxa uꞌujeꞌ see, pap Teófilo, as kat untzꞌibꞌa bꞌen see tiꞌ unqꞌa bꞌaꞌnileꞌ skajayil uvaꞌ kat ul ibꞌan u Jesús as tukꞌ unqꞌa uvaꞌ ul ichus kan Aak xoꞌl unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","As kat bꞌex ilej u qꞌiieꞌ tul uvaꞌ kat eqꞌol veꞌt jeꞌ Aak tu almikaꞌ, tan maꞌtik itzaqꞌtik kan Aak taꞌn u Tiixhla Espíritu te unqꞌa apóstol uvaꞌ txaaelik taꞌn Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","As tul maꞌtik ikam Aak, as kat ikꞌuch veꞌt tibꞌ Aak te chajnaj tu kaꞌviinqil qꞌii, texhlal tetz uvaꞌ maꞌtik tul taama Aak unpajte. As kat tal kan Aak isuuchil tiꞌ u tenameꞌ uvaꞌ at jaqꞌ u tijleꞌm u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","As tul atik veꞌt Aak xoꞌl unqꞌa apóstol, as ech tal kan Aak ileꞌ te chajnaj: —Yeꞌl ex la el ex tu u Jerusalén. Pet lanal etxꞌebꞌeꞌ uvaꞌ alel kan taꞌn u Kubꞌaal Tiixheꞌ, echeꞌ uvaꞌ kat val sete, ");
INSERT INTO ixlNNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","tan xeꞌ kuxh aꞌeꞌ kat taqꞌkat kuꞌ u Xhuneꞌ unqꞌa uxhchileꞌ. Pet ech koj ex, tan yeꞌ kuxh jatvaꞌt qꞌii stuul la ok veꞌt u Tiixhla Espíritu tu vetaanxelaleꞌ,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","As tul molik tibꞌ u Jesús tukꞌ unqꞌa niman tetzeꞌ, as ech tal veꞌt chajnaj ileꞌ te Aak: —¿Pap, ma cheel la ooksa veꞌt u kutenameꞌ snimil tiꞌ unjoltu unqꞌa tenameꞌ echeꞌ uvaꞌ bꞌanik taꞌn bꞌaxa?— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","As ech tal veꞌt u Jesús ileꞌ: —Jit etetzeꞌ uvaꞌ la etootzi jatu la ibꞌaneꞌ. Pet taꞌn u Kubꞌaal Tiixheꞌ ootzin tetz tukꞌ u tijleꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","As tul la ok u Tiixhla Espíritu tu vetaanxelaleꞌ, as la ekꞌul veꞌt etijleꞌm. As la epaxsa veꞌt u bꞌaꞌnla yoleꞌ sviꞌ xoꞌl unqꞌa tenameꞌ tzitzaꞌ tu u Jerusalén, tu u Judea, as tukꞌ tu u Samaria. As lanal oon ex timoxtel u vatz txꞌavaꞌeꞌ skajayil,— tiꞌk Aak. ");
INSERT INTO ixlNNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","As tul kuxh tal u Jesús unqꞌa yoleꞌ, as til veꞌt chajnaj ijeꞌ Aak tu almikaꞌ. As sotz veꞌt Aak tu umaꞌl u suutzꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","As antelik kuxh isajin jeꞌ unqꞌa uxhchileꞌ tiꞌ Aak tu almikaꞌ, as aat kuxh til unqꞌa uxhchileꞌ uvaꞌ txaklik veꞌt ok kaꞌvaꞌl unqꞌa ángel skꞌatz uvaꞌ vaꞌlik chit ipolal unqꞌa toksaꞌmeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ech tal veꞌt unqꞌa ángel ileꞌ: —Ex aa Galilea, ¿kam uvaꞌ antel kuxh ekaꞌyik jeꞌ tu almikaꞌ? Tan tuk uloj u Jesús vatz u txꞌavaꞌeꞌ unpajte. As kam chit ijeꞌ Aak kat etila tu almikaꞌ as echat chit tul Aak tuk uloj tikaꞌpa,— tiꞌk unqꞌa ángel. ");
INSERT INTO ixlNNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","As tzaa veꞌt unqꞌa uxhchileꞌ viꞌ u vitz uvaꞌ Olivos. As ul veꞌt tu u Jerusalén, tan kamal pokꞌoꞌchil iꞌl ixoꞌl u vitzeꞌ tukꞌ u Jerusalén. ");
INSERT INTO ixlNNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","As tul ok veꞌt unqꞌa niman tetz u Jesús tu u tenameꞌ, as echik ijeꞌ chajnaj tikaꞌv ichup u kabꞌaleꞌ uvaꞌ nik ivatkat u Lixh, tukꞌ u Piꞌl, tukꞌ u Maxh, tukꞌ u Bartolomé, tukꞌ u Mateo, tukꞌ u Jacobo uvaꞌ ikꞌaol u Alfeo, tukꞌ u Simón uvaꞌ Celote chꞌelel, as tukꞌ u Judas uvaꞌ ikꞌaol umaꞌt u Jacobo. ");
INSERT INTO ixlNNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","As tul nikat imol tibꞌ unqꞌa apóstol tukꞌ unqꞌa ixojeꞌ, tukꞌ unqꞌa titzꞌin u Jesús, as tukꞌ u Maꞌleꞌ vitxutx Aakeꞌ, as unvatzulik chit unqꞌa uxhchileꞌ skajayil tiꞌ inachat Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tu umaꞌl u qꞌii, as kamal vajkꞌalal (120) unqꞌa niman tetz u Jesús uvaꞌ molik tibꞌ. As txakpu veꞌt u Luꞌeꞌ xoꞌl unqꞌa tenameꞌ. Ech tal veꞌt ileꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Vitzꞌin vatzik, kat chit bꞌex ibꞌanlu veꞌt u yoleꞌ uvaꞌ tzꞌibꞌamal kan uvaꞌ tal kan u David taꞌn u Tiixhla Espíritu tiꞌ u Judas uvaꞌ naj eqꞌon bꞌey vatz unqꞌa uxhchileꞌ uveꞌ kat txeyon u Jesús. ");
INSERT INTO ixlNNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","As tul antik u Judas sukuxoꞌl. As antik naj atik tijleꞌm tiꞌ u aqꞌoneꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","As kat loqꞌpu umaꞌl u txꞌavaꞌ tiꞌ u puajeꞌ uvaꞌ kat ikꞌul naj tiꞌ u vaꞌlexheꞌ uvaꞌ kat ibꞌan naj. As tul maꞌt ichꞌuybꞌaꞌt tibꞌ naj, as jojel ibꞌen veꞌt naj tu txꞌavaꞌ. As qꞌixmu veꞌt naj spokꞌoꞌch. As motxik veꞌt el tzan u taqꞌitxaꞌ najeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","As pax veꞌt itzibꞌlal u yoleꞌ xoꞌl unqꞌa tenameꞌ tu u Jerusalén. Estiꞌeꞌ oksal veꞌt Acéldama tiꞌ u txꞌavaꞌeꞌ tu viyolbꞌal unqꞌa tenameꞌ tu u Jerusalén, tan aꞌ ni tokkat u yoleꞌ uvaꞌ «loqꞌel taꞌn ijaꞌmil kajal,» tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","As aal chit bꞌaꞌneꞌ uvaꞌ la chukax ichꞌexel u Judas, tan ech ni tal umaꞌl u yol ileꞌ uvaꞌ tzꞌibꞌamal kan tu Salmo: La kaaik kan tatinbꞌal naj. As yeꞌl umaj uxhchil la atin stuul, tiꞌk u yoleꞌ. As ech ni tal umaꞌt yol ileꞌ tiꞌ naj: La ok veꞌt umaꞌt uxhchil sichꞌexel, tiꞌk u yoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Estiꞌeꞌ techal chit la ok umaꞌtoj naj sukuxoꞌl tiꞌ talat isuuchil uvaꞌ kat ul taama u Jesús. As il kaꞌl unqꞌa naj ileꞌ xekeltel sqiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","As tul antik chajnaj xekik sqiꞌ tul uvaꞌ sikuꞌ Aak xeꞌ u aꞌeꞌ taꞌn u Xhuneꞌ, as tul nik ixaan Aak sukuxoꞌl, as tul kat jeꞌ veꞌt Aak tu almikaꞌ. As il chajnaj ileꞌ atiltel sukuxoꞌl cheel,— tiꞌk u Luꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","As itxaa veꞌt chajnaj kaꞌvaꞌl unqꞌa naj: umaꞌl naj Xhuꞌl uvaꞌ Barsabás as Justo chꞌelel naj unpajte. As umaꞌt naj Matías ibꞌii. ");
INSERT INTO ixlNNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","As ech tal chajnaj ileꞌ tul inach chajnaj Tiixh tiꞌ kaꞌvaꞌl unqꞌa najeꞌ: —Axheꞌ Kubꞌaal Tiixh uvaꞌ ootzin tetz unqꞌa qaanxelaleꞌ skukajayil, as bꞌan bꞌaꞌnil. Kꞌuch sqe abꞌiste kaꞌvaꞌl unqꞌa najeꞌ uvaꞌ txaael veꞌt s-aꞌn ");
INSERT INTO ixlNNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","tiꞌ tok veꞌt sichꞌexel u Judas uvaꞌ kat taqꞌ kan u tijleꞌmeꞌ taꞌn u paasan tziileꞌ tiꞌ ibꞌen tu u choobꞌal paaveꞌ,— tiꞌk chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","As ijaj veꞌt chajnaj itxumbꞌal te u Tiixheꞌ tiꞌ kaꞌvaꞌl unqꞌa najeꞌ tiꞌ uvaꞌ abꞌiste naj la kaai. As aꞌ u Matías kat kaa veꞌteꞌ. As ok veꞌt naj xoꞌl junlavat unqꞌa apóstol. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","As tul ilej veꞌt u nimla qꞌiieꞌ uvaꞌ Pentecostés, as kꞌulik tibꞌ unqꞌa niman tetz u Jesús. As vatzulik chit unqꞌa uxhchileꞌ svatzaj. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","As aat kuxh tabꞌi veꞌt unqꞌa uxhchileꞌ ivulun ikuꞌ chꞌuꞌl umaꞌl u vaaꞌ echeꞌ kajiqꞌ tu almikaꞌ. As xoꞌvebꞌal chit ivuluneꞌ tul ok tu kabꞌaleꞌ uvaꞌ xonlikkat unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","As aat kuxh til unqꞌa uxhchileꞌ ichee umaꞌl u vaaꞌ echeꞌ taqꞌ xamal. As ipaxi veꞌt bꞌen tibꞌ tiibꞌa unqꞌa uxhchileꞌ sijununila. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","As taqꞌ veꞌt u Tiixhla Espíritu itxumbꞌal unqꞌa uxhchileꞌ skajayil tiꞌ iyoloneꞌ. As xeꞌt veꞌt yolon tu kaꞌt yolbꞌal, tan aꞌ u Tiixhla Espíritu kat aqꞌon ste uvaꞌ la yolon tu unqꞌa yolbꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","As nimal unqꞌa tiaal Israel uvaꞌ tzaanaj tulaj unqꞌa tenameꞌ skajayil as atik tu u Jerusalén tu u nimla qꞌiieꞌ, tan nik toksa taama tiꞌ inachat Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","As tul vulun ikuꞌ chꞌuꞌl tu almikaꞌ uvaꞌ echeꞌ mam kajiqꞌ, as mamaꞌla tenameꞌ imol veꞌt tibꞌ stiꞌ. As nikat isotz veꞌt ikꞌuꞌl unqꞌa tenameꞌ, tan tabꞌi veꞌt unqꞌa tenameꞌ uvaꞌ nik iyolon veꞌt unqꞌa niman tetz u Jesús tu kaꞌt unqꞌa yolbꞌaleꞌ tetz junun unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","As sotz veꞌt ikꞌuꞌl unqꞌa tenameꞌ. As teqꞌo chit veꞌt taama. As ech tal veꞌt ileꞌ svatzaj: —¿Jit kol aa Galilea unqꞌa najeꞌ qꞌa uveꞌ niyoloneꞌ? ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿As kam qꞌi uveꞌ ni qabꞌi veꞌt iyolon chajnaj tu unqꞌa kuyolbꞌaleꞌ uvaꞌ kat kuchꞌiiabꞌe? ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Tan at uxhchil sukuxoꞌl uvaꞌ aꞌ kat chꞌiikat tu u Partia, tu u Media, tu u Elam, tu u Mesopotamia, tu u Judea, tu u Capadocia, tu u Ponto, tu u Asia, ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","tu u Frigia, tu u Panfilia, as tukꞌ tu u Egipto. As at uxhchil uvaꞌ aꞌ tzaanajkat tu unqꞌa tenameꞌ tu u Africa uvaꞌ vatz bꞌen u Cirene, tukꞌ kaꞌt unqꞌa uxhchileꞌ uvaꞌ aa Roma uveꞌ jejleꞌl veꞌt tzitzaꞌ uvaꞌ tiaal Israel tukꞌ unqꞌa uxhchileꞌ uvaꞌ jit tiaal Israel uvaꞌ kat toksa tibꞌ niman tetz u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","As at uxhchil sukuxoꞌl uvaꞌ aa Creta tukꞌ unqꞌa aa Arabia. As ni qabꞌi iyolbꞌet chajnaj u kuyolbꞌaleꞌ tiꞌ talax isuuchil vibꞌaꞌnil u Tiixheꞌ uvaꞌ achvebꞌal chittuꞌ,— tiꞌk unqꞌa tenameꞌ svatzaj. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","As kat teqꞌo veꞌt taama unqꞌa tenameꞌ skajayil. As sotz veꞌt ikꞌuꞌl. As ech tal veꞌt kaꞌt unqꞌa uxhchil ileꞌ svatzaj: —¿Kam ni tokkat uveꞌ ni tucheꞌ?— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pet ech koj unkaꞌt unqꞌa uxhchileꞌ, tan tzeꞌlebꞌal kuxh ste. As ech nik tal ileꞌ: —Qꞌabꞌareeleꞌ unqꞌa najeꞌ,— tiꞌk unqꞌa uxhchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","As txakebꞌ veꞌt u Luꞌeꞌ tukꞌ junlavat unqꞌa apóstol. As taqꞌ veꞌt jeꞌ u Luꞌeꞌ tuul iviꞌ. Ech tal veꞌt ileꞌ: —Ex kumool tiaal Israel uvaꞌ tziꞌaꞌn tzaanajkat ex tukꞌ ex uvaꞌ jejleꞌl veꞌt ex tzitzaꞌ tu u Jerusalén, etabꞌitaj u yoleꞌ uvaꞌ tuk val sete. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Tan yeꞌl oꞌ qꞌabꞌareel koj oꞌ echeꞌ uveꞌ netaleꞌ, as tul aꞌn bꞌeluval oora cheel qꞌalaꞌm. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Pet aꞌ uvaꞌ ni tucheꞌ uvaꞌ tzꞌibꞌamal kan taꞌn u qꞌajsan tetz viyol u Tiixheꞌ uvaꞌ Joel, uvaꞌ ech ni tal ileꞌ: ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","«Ech la ibꞌan ileꞌ tul uvaꞌ la bꞌen ilej unqꞌa qꞌiieꞌ uvaꞌ aꞌn tuleꞌ: Tan la vaqꞌ veꞌt kuꞌ tzan vunTiixhla Espíritu tiꞌ unqꞌa tenameꞌ skajayil. As la tal veꞌt unqꞌa meꞌal ekꞌaoleꞌ vunyoleꞌ. As la til veꞌt unqꞌa txul aamaeꞌ unqꞌa veeꞌ echeꞌ vatzikꞌ. As la vatzkꞌu veꞌt unqꞌa qꞌesla chaj aamaeꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","tan tu veꞌt unqꞌa qꞌiieꞌ, as la vaqꞌ kuꞌ tzan vunTiixhla Espíritu tiꞌ unqꞌa niman vetzeꞌ, tiꞌ unqꞌa najeꞌ tukꞌ unqꞌa ixojeꞌ. As aꞌeꞌ la alon veꞌt vunyoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","As la unkꞌuch veꞌt unqꞌa kꞌuchbꞌal tetz u vijleꞌmeꞌ vatz u almikaꞌeꞌ uvaꞌ la teqꞌo veꞌt taama unqꞌa tenameꞌ staꞌn. As la unkꞌuch veꞌt unqꞌa veeꞌ uvaꞌ xoꞌvebꞌal chittuꞌ vatz u txꞌavaꞌeꞌ, as echeꞌ kaj, tukꞌ xamal, as tukꞌ sibꞌ uvaꞌ echeꞌ suutzꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","As la tokin veꞌt ivatz u qꞌiieꞌ. As la kajun veꞌt ivatz u ichꞌeꞌ, tul yeꞌxnaj ilej u qꞌiieꞌ tiꞌ u vulebꞌaleꞌ, in uvaꞌ in veBꞌaaleꞌ, tan xoꞌvebꞌal chit la ibꞌan tu u qꞌiieꞌ uvaꞌ alel kan svaꞌn. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","As la unqꞌalpueꞌ unqꞌa uxhchileꞌ uveꞌ la ootzin in uvaꞌ in iTiixh,» tiꞌk u Tiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Vitzꞌin vatzik, ex kumool uvaꞌ tiaal Israel, etabꞌitaj u yoleꞌ uvaꞌ tuk val sete, tan ootzimal setaꞌn uvaꞌ aꞌ u Jesús, u aa Nazaret, uvaꞌ kat ikꞌuch u Tiixheꞌ u tijleꞌmeꞌ sukuxoꞌl, tan tukꞌ vibꞌaꞌnil u Jesús kat ibꞌankat u Tiixheꞌ unqꞌa nimla bꞌaꞌnileꞌ tukꞌ unqꞌa kꞌuchbꞌal tetz u tijleꞌm Aakeꞌ uvaꞌ kat teqꞌo taama unqꞌa uxhchileꞌ stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","As tul aꞌ u Jesús uvaꞌ kat etxeya. As kat etoksa ok tiqꞌabꞌ unqꞌa bꞌanol vaꞌlexheꞌ echeꞌ uvaꞌ kꞌujlu kan taꞌn u Tiixheꞌ. As kat etaqꞌ jeꞌ vatz u kuruseꞌ. As kat eyatzꞌa. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","As an chit u Jesús kat eyatzꞌa uvaꞌ kat ul taama taꞌn u Tiixheꞌ. As yeꞌ kat olebꞌ u kamchileꞌ stiꞌ, tan kat teesa veꞌt u Kubꞌaal Tiixheꞌ u Jesús tiqꞌabꞌ u kamchileꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","As kat itzꞌibꞌa kan u David unqꞌa yoleꞌ tiꞌ u Jesús tul ech tal ileꞌ: Nik vileꞌ uvaꞌ at chit u Kubꞌaal Tiixheꞌ sunkꞌatz. As yeꞌxhebꞌil la xoꞌvisan in, tan echen Aak tu vunsebꞌaleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","As estiꞌeꞌ uvaꞌ vaꞌl chit ichiibꞌ u vaanxelaleꞌ. As vaꞌl chit unbꞌitz taꞌn chiibꞌichil. As kꞌujleꞌl unkꞌuꞌl seeꞌ uvaꞌ axh la aqꞌon itiichajil vunchiꞌoleꞌ unpajte. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","As yeꞌ la aaqꞌ kan u vaanxelaleꞌ tu u atinbꞌaleꞌ uvaꞌ atkat unqꞌa kamnajeꞌ. As axh la bꞌanon uvaꞌ yeꞌl vunchiꞌoleꞌ la qꞌeei, in uvaꞌ kꞌujlu kan in aꞌn. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","As alel sve aꞌn uvaꞌ at untiichajil la ibꞌaneꞌ, tan la ul vaama unpajte. Estiꞌeꞌ uvaꞌ mamaꞌla chiibꞌichil at tu u vaanxelaleꞌ, tan at chit axh sunkꞌatz tiꞌ chit ibꞌeneꞌ, tiꞌk u yoleꞌ uvaꞌ itzꞌibꞌa kan u David. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","As, vitzꞌin vatzik, tuk val isuuchil sete kam uvaꞌ ibꞌan u qꞌesla kubꞌaaleꞌ uvaꞌ David: Tan kat kami; as kat mujli. As il vijulil ileꞌ atiltel sukuxoꞌl cheel. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","As qꞌajsan tetz viyol u Tiixheꞌ u David. As atik skꞌuꞌl u David uvaꞌ maꞌtik talat kan u Tiixheꞌ ste uvaꞌ aꞌ la ulkat u Cristo xoꞌl unqꞌa tiaal David. As la ok u Cristo ijlenaalil tiꞌ u kutenameꞌ echeꞌ uvaꞌ kat ibꞌan u David. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","As tul yeꞌxnik ul u Cristo, as tal kan u David isuuchil unqꞌa yoleꞌ, tan ikꞌuch veꞌt u Tiixheꞌ ste tiꞌ uvaꞌ yeꞌl u taanxelal u Cristo la kaaik kan tu u atinbꞌaleꞌ uvaꞌ atkat unqꞌa kamnajeꞌ. Pet la ul taama Aak. As yeꞌl vichiꞌol Aakeꞌ la qꞌeei tu txꞌavaꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","As aꞌ u Jesús uvaꞌ kat tulsa u Tiixheꞌ taama. As estiꞌeꞌ ni qal isuuchil sete cheel, ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","tan kat eqꞌol veꞌt jeꞌ u Jesús tu almikaꞌ tisebꞌal u Tiixheꞌ. As aꞌ u Kubꞌaal Tiixheꞌ kat aqꞌon u Tiixhla Espíritu te u Jesús echeꞌ uvaꞌ alel kan taꞌn Aak. As aꞌ u Jesús kat aqꞌon veꞌt kuꞌ tzan u Tiixhla Espíritu sqiꞌ. As aꞌeꞌ uvaꞌ netileꞌ as netabꞌi cheel. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tan kꞌuxh yeꞌ kat jeꞌ veꞌt u David tu almikaꞌ, as ech tal veꞌt aak ileꞌ: «Ech kat tal veꞌt u Kubꞌaal Tiixh ileꞌ te vunBꞌaaleꞌ: Xonebꞌen tu vunsebꞌaleꞌ, ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","as la voksa veꞌt axh sbꞌooqꞌolil tiꞌ unqꞌa uxhchileꞌ uveꞌ ni chꞌoꞌn taama seeꞌ,» tiꞌk u David. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Estiꞌeꞌ tuk val sete, jankꞌal ex uvaꞌ ex kumool tiaal Israel, palojtaj ex stuul uvaꞌ aꞌ u Jesús uvaꞌ kat etal iyatzꞌpu vatz u kuruseꞌ, as aꞌeꞌ u Cristo uvaꞌ kat ikꞌujbꞌaꞌ kan u Tiixheꞌ. As kuBꞌooqꞌoleꞌ u Jesús taꞌn u Tiixheꞌ,— tiꞌk u Luꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","As tul tabꞌi veꞌt unqꞌa tenameꞌ viyol u Luꞌeꞌ, as teqꞌo veꞌt taama skajayil. Ech tal veꞌt ileꞌ te u Luꞌeꞌ tukꞌ te junlavat unqꞌa apóstol: —¿Qitzꞌin qatzik, kam la kubꞌan veꞌt cheel?— tiꞌk unqꞌa tenameꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","As ech tal veꞌt u Luꞌ ileꞌ: —Ejalputaj vetxumbꞌaleꞌ. As kuꞌojtaj ex xeꞌ u aꞌeꞌ tukꞌ vibꞌii u Jesucristo. As la sotz veꞌt vepaaveꞌ. As la ul veꞌt u Tiixhla Espíritu setiꞌ uvaꞌ la taqꞌ u Tiixheꞌ sete, ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","tan etetz veꞌteꞌ uvaꞌ alel kan taꞌn u Tiixheꞌ uvaꞌ la taqꞌ Aak sete. As tetz unqꞌa meꞌal ekꞌaoleꞌ tukꞌ unqꞌa uxhchileꞌ uveꞌ echen tu unjoltu unqꞌa tenameꞌ, tan jankꞌal unqꞌa uxhchileꞌ uvaꞌ la imolo u Tiixheꞌ tiꞌ inimaleꞌ, as tetzeꞌ unpajte,— tiꞌk u Luꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","As nimatel yol nikat tal u Luꞌeꞌ xoꞌl unqꞌa tenameꞌ tiꞌ ibꞌeyat ste. As ech tal veꞌt u Luꞌ ileꞌ: —Eteesataj el tzan etibꞌ kꞌatz unqꞌa uxhchileꞌ uvaꞌ vaꞌlexh kuxh nibꞌaneꞌ,— tiꞌk u Luꞌeꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","As jankꞌal unqꞌa uxhchileꞌ uvaꞌ kat niman u yoleꞌ uvaꞌ kat tal u Luꞌeꞌ, as kat kuꞌ veꞌt xeꞌ u aꞌeꞌ. Kamal oxvaꞌl mil tachul unqꞌa uxhchileꞌ uvaꞌ kat ok veꞌt xoꞌl unqꞌa niman tetz u Jesús tu u qꞌiieꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","As nik inima veꞌt unqꞌa uxhchileꞌ u chusbꞌaleꞌ uvaꞌ nik ichus unqꞌa apóstol. As unvatzulik chit veꞌt vitxumbꞌaleꞌ skajayil, tul nikat imol veꞌt tibꞌ tiꞌ ijatxax veꞌt u echbꞌubꞌaleꞌ svatzaj. As nik inach veꞌt Tiixh. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","As kat chit ok veꞌt xeꞌ taama unqꞌa uxhchileꞌ skajayil tiꞌ u Tiixheꞌ, tan mamaꞌla kꞌuchbꞌal tetz vibꞌaꞌnil u Tiixheꞌ nik ikꞌuch unqꞌa apóstoleꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","As unvatzulik chit itxumbꞌal unqꞌa niman tetz u Jesús. As vatzulik chit veꞌteꞌ tukꞌ unqꞌa tetzeꞌ skajayil. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","As nikat ikꞌayi veꞌt unqꞌa niman tetz u Jesús unqꞌa tetzeꞌ. As nikat ijatx veꞌt vijaꞌmileꞌ xoꞌl unqꞌa imooleꞌ kam uvaꞌ nik isaꞌvit stiꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","As yeꞌ nik iyaꞌsa veꞌt unqꞌa niman tetz Aakeꞌ ikꞌulat tibꞌ jun qꞌii vatz viqꞌanal u tostiixheꞌ. As tukꞌ chit chiibꞌichil nikat ijatx veꞌt u echbꞌubꞌaleꞌ svatzaj tulaj ikabꞌal, tan ivatz chit Tiixh taanxelal. ");
INSERT INTO ixlNNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","As nik toksa veꞌt iqꞌii u Tiixheꞌ. As bꞌaꞌnik veꞌt itxumbꞌal vatz unqꞌa tenameꞌ. As jun qꞌii nikat inaꞌsa veꞌt u Kubꞌaal Jesús tachul unqꞌa niman tetzeꞌ, jankꞌal unqꞌa uxhchileꞌ uveꞌ nikat isaꞌ Aak iqꞌalpul vatz vipaaveꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Tu umaꞌl u qꞌii, jeꞌ veꞌt u Luꞌeꞌ tukꞌ u Xhuneꞌ tu tostiixheꞌ tiꞌ inachat Tiixh tu oxvaꞌl oora kuꞌqꞌii. ");
INSERT INTO ixlNNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","As xonlik umaꞌl u naj uvaꞌ koꞌxik chit stitzꞌebꞌeꞌ tziꞌ u tostiixheꞌ uvaꞌ Bꞌaꞌnla Tziꞌ Kabꞌal ibꞌii. As nikat ijoy naj ipuaj te unqꞌa tenameꞌ uveꞌ nik tok tu tostiixheꞌ. ");
INSERT INTO ixlNNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","As tul til veꞌt u koꞌxeꞌ uvaꞌ aalik tok u Luꞌeꞌ tukꞌ u Xhuneꞌ tu tostiixheꞌ, as ijoy veꞌt naj ipuaj te chajnaj. ");
INSERT INTO ixlNNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","As isaji veꞌt u Luꞌeꞌ tukꞌ u Xhuneꞌ u koꞌxeꞌ. As ech tal veꞌt u Luꞌeꞌ ileꞌ: —¡Saji tzan oꞌ!— tiꞌk naj. ");
INSERT INTO ixlNNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","As tul tabꞌi u koꞌxeꞌ u yoleꞌ, as titzꞌa naj uvaꞌ kamal la taqꞌ chajnaj ipuaj naj uvaꞌ tala. ");
INSERT INTO ixlNNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","As ech tal veꞌt u Luꞌ ileꞌ: —Yeꞌl puaj eqꞌomal svaꞌn. Pet kam uvaꞌ eqꞌomal taꞌn u vaanxelaleꞌ, as la vaqꞌ s