﻿USE sofia;
DROP TABLE IF EXISTS sofia.ixlCNT_vpl;
CREATE TABLE ixlCNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ixlCNT_vpl WRITE;
INSERT INTO ixlCNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Aꞌ u tachul ibꞌii qꞌul ikꞌuy imam u Jesucristo tzaꞌ, vituꞌxh ixalam u Daviid utz, vituꞌxh ixalam u Abrahaam. ");
INSERT INTO ixlCNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Uncheeꞌ aatz u Abrahaam, aꞌ ikꞌaol atini u Isaac. Aatz u Isaac, aꞌ ikꞌaol atini u Jacoob. Aatz u Jacoob, aꞌ ikꞌaol atini u Judaa tuchꞌ tereꞌn qꞌu tatzik tuchꞌ itzaꞌqꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Aatz u Judaa, aꞌ initxaꞌa atin tuchꞌ u Tamaar, u Fares tuchꞌ u Zara. Aatz u Fares, aꞌ ikꞌaol atini u Esroom. Aatz u Esroom, aꞌ ikꞌaol atini u Araam. ");
INSERT INTO ixlCNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aatz u Araam, aꞌ ikꞌaol atini u Aminadaab. Aatz u Aminadaab, aꞌ ikꞌaol atini u Nasoon. Aatz u Nasoon, aꞌ ikꞌaol atini u Salmoon. ");
INSERT INTO ixlCNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Aatz u Salmoon, aꞌ initxaꞌa atin tuchꞌ u Rahaab, u Booz. Aatz u Booz, aꞌ initxaꞌa atin tuchꞌ u Rut, u Obeed. Aatz u Obeed, aꞌ ikꞌaol atini u Isaii. ");
INSERT INTO ixlCNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Aatz u Isaii, aꞌ ikꞌaol atini u ijlenal Daviid. Aatz u ijlenal Daviid, aꞌ ikꞌaol atini u Salomoon, initxaꞌa tuchꞌ u ixoj vaꞌl tixojich u Urias. ");
INSERT INTO ixlCNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Uncheeꞌ aatz u Salomoon, aꞌ ikꞌaol atini u Roboaam. Aatz u Roboaam, aꞌ ikꞌaol atini u Abias. Aatz u Abias, aꞌ ikꞌaol atini u Asa. ");
INSERT INTO ixlCNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aatz u Asa, aꞌ ikꞌaol atini u Josafaat. Aatz u Josafaat, aꞌ ikꞌaol atini u Joraam. Aatz u Joraam, aꞌ ikꞌaol atini u Uzias. ");
INSERT INTO ixlCNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Aatz u Uzias, aꞌ ikꞌaol atini u Jotaam. Aatz u Jotaam, aꞌ ikꞌaol atini u Acaaz. Aatz u Acaaz, aꞌ ikꞌaol atini u Esequias. ");
INSERT INTO ixlCNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Aatz u Esequias, aꞌ ikꞌaol atini u Manasees. Aatz u Manasees, aꞌ ikꞌaol atini u Amoon. Aatz u Amoon, aꞌ ikꞌaol atini u Josias. ");
INSERT INTO ixlCNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Aatz u Josias, aꞌ ikꞌaol atini u Jeconias, tuchꞌ tereꞌn itzaꞌqꞌ. Aꞌ titzꞌpeꞌ tikuenta u txaypichil bꞌen tu u txꞌavaꞌ Babiloonia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Uncheeꞌ xamtich tek tiꞌ u txaypichil bꞌen tu Babiloonia, aatz u Jeconias, atin ikꞌaol; ayaꞌ u Salatieel. Aatz u Salatieel, aꞌ ikꞌaol atini u Zorobabeel. ");
INSERT INTO ixlCNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Aatz u Zorobabeel, aꞌ ikꞌaol atini u Abiuud. Aatz u Abiuud, aꞌ ikꞌaol atini u Eliaquiim. Aatz u Eliaquiim, aꞌ ikꞌaol atini u Azoor. ");
INSERT INTO ixlCNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aatz u Azoor, aꞌ ikꞌaol atini u Sadooc. Aatz u Sadooc, aꞌ ikꞌaol atini u Aquiim. Aatz u Aquiim, aꞌ ikꞌaol atini u Eliuud. ");
INSERT INTO ixlCNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Aatz u Eliuud, aꞌ ikꞌaol atini u Eleazar. Aatz u Eleazar, aꞌ ikꞌaol atini u Mataan. Aatz u Mataan, aꞌ ikꞌaol atini u Jacoob. ");
INSERT INTO ixlCNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Aatz u Jacoob, aꞌ ikꞌaol atini u Xhep. Ayaꞌ vivinaj u Liꞌ, u alan tetz u Jesuus. Aatz u Jesuus, aꞌ viTxaaom u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Uncheeꞌ ech 14 tanul qꞌu kꞌuya mama tziꞌ, nixeꞌtkꞌasuꞌl tiꞌ u Abrahaam utz, nuꞌlyaꞌoj tiꞌ u Daviid. Utz aatz nixeꞌtkꞌasuꞌl tiꞌ u Daviid, neꞌnyaꞌoj tu u txaypichil bꞌen tu Babiloonia, 14 paj tanul. Xeꞌt paj kꞌasuꞌl tiꞌ u txaypichil bꞌen tu Babiloonia utz, nuꞌlyaꞌoj tu u titzꞌpebꞌal u Jesuus viTxaaom u Tioxh, 14 pajeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Uncheeꞌ ech u titzꞌpu u Jesucristo tzaꞌ. Aatz u Liꞌ, vinan u Jesuus, oknajich tek u Xhep tiꞌ. Utz aatz yeꞌsajich motx ikꞌultu tibꞌ, atin u Liꞌ tu tiichajla yaabꞌil. Loqꞌ titxumbꞌal u Tioxhla Espiiritu. ");
INSERT INTO ixlCNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ech aatz u Xhep, vaꞌl siꞌchbꞌens ivinaj tan, siꞌchtektaqꞌka u Liꞌ itxuma. Yeꞌ naꞌl siꞌchiꞌaneꞌ. Yeꞌt ipaxsa el itziiul, majbꞌal tel iqꞌii tan, jikomla vinajich. ");
INSERT INTO ixlCNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tuul ech vaꞌl maꞌtich itxumtaꞌ siꞌaneꞌ, yeꞌk talcheꞌ chee maꞌl u aanjel tetz u Tioxh tivatzikꞌ. Utz tal te ech tzaꞌ: —Xhep, ituꞌxh ixalam Daviid, yeꞌ koꞌxh kaꞌtziiunaxh tiꞌ iiqꞌot u Liꞌ tziꞌ tan, aatz vaꞌl atil kꞌatza, u Tioxhla Espiiritu vetiꞌan itxumbꞌal tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ech siꞌitzꞌpu maꞌl titzꞌin, xiak. Utz Jesuus vibꞌii looksa tan, aꞌ u Chitol tetz vitenam tu paav.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Utz iꞌan koꞌnkoxh ok u kam tziꞌ. Pek aꞌ tzojpi vaꞌl tal u Tioxh titziꞌ u alol tetz viyolbꞌal aas tal ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","—Aatz siꞌan maꞌl u ixviak, tiira ixviak yeꞌ tootzaj vinaj, saꞌatin tu tiichajla yaabꞌil. Utz sachee maꞌl titzꞌin, xiak. Aatz ibꞌii saoksali utz, Emanueel. Tioxh tu kuxoꞌl chu u tokebꞌal.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ech aatz kꞌas u Xhep, iꞌan tekuꞌen kam vaꞌl tal u aanjel te utz, tiqꞌo tek u Liꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Loqꞌ yeꞌt ok kꞌatza. Itzꞌpu koꞌxh u titzꞌin. Utz aatz itzꞌpi, Jesuus ibꞌii toksa. ");
INSERT INTO ixlCNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Uncheeꞌ aatz itzꞌpu u Jesuus tu u tenam Beleen tikuenta Judea, aꞌich ijlenal u Herodes. Utz motx opon tu Jerusaleen unjolol qꞌu aa txumbꞌal tiꞌ qꞌu txꞌumiꞌl. Aꞌ motx kꞌaskuꞌl tikuenta aal telaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Utz motx ichꞌoti ech tzaꞌ: —¿Keꞌch u tal nitxaꞌ itzꞌpia, vaꞌl siꞌan ijlenalil xoꞌl qꞌu Israeel tzaꞌ? Tan vetqil ichee u txꞌumiꞌl tikuenta aal telaꞌ, vixheenyail. Ech ul pecheꞌojoꞌ siatz. Ul qoksa iqꞌii.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ech taꞌxh tabꞌi u yol u ijlenal Herodes, yakich elaꞌokoj taanima taqꞌo tuchꞌ qꞌu aa Jerusaleen. ");
INSERT INTO ixlCNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Uncheeꞌ ech isavsat kajay qꞌu qꞌesal oksan yol vatz Tioxh tuchꞌ qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar utz, ichꞌoti te til tenam siꞌitzꞌpik viTxaaom u Tioxh vaꞌl suꞌuli. ");
INSERT INTO ixlCNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ech alax te ech tzaꞌ: —Aꞌ siꞌitzꞌpik tu u tenam Beleen tikuenta Judea tan, ech tzꞌibꞌamalka tu u alol tetz u yolbꞌal Tioxh, aas tal ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","«Aatz axh tenam Beleen tikuenta Judea, yitꞌ chꞌoo tereꞌn koj aalchu vatz tereꞌn qꞌu nimaj tenam tikuenta Judea tan, aꞌ sacheek maꞌl u qꞌesala takuenta, u iqꞌon ibꞌey vuntenam Israeel.» Chia.— Texh tu u Herodes. ");
INSERT INTO ixlCNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Uncheeꞌ aatz u Herodes, ijutzi isavsal qꞌu aa txumbꞌal tiꞌ qꞌu txꞌumiꞌl utz, ichꞌoti itziꞌ bꞌaꞌnil, tiꞌ jatvaꞌx tiempo xeꞌt motx tiltu u txꞌumiꞌl tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ech tek ichaj bꞌen tu Beleen utz, tal te ech tzaꞌ: —Bꞌenojex utz, chꞌotitaj inujul bꞌaꞌnil kam bꞌanel tu u tal nitxaꞌ tziꞌ. Utz aatz lechabꞌa, letal ve tan, seꞌnpecheꞌojin siatz majte. Seꞌnvoksa iqꞌii.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Uncheeꞌ taꞌxh veet tabꞌil viyol u ijlenal tu qꞌu aa txumbꞌal tiꞌ qꞌu txꞌumiꞌl, motx tek bꞌeni. Utz bꞌaxabꞌ paj u txꞌumiꞌl siatz vaꞌl til tikuenta aal telaꞌ. Anal txakeꞌ u txꞌumiꞌl aas opon viꞌ u atibꞌal vaꞌl atichku u tal nitxaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ech tiira motx txuqꞌtxun qꞌu aa txumbꞌal aas til itxakeꞌ u txꞌumiꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ech motx okoꞌp tu u atibꞌal utz, til u tal nitxaꞌ; aꞌ imol u Liꞌ, vinan. Ech motx pecheꞌ kuꞌ vatz u tal nitxaꞌ utz, toksa iqꞌii. Motx ijaj qꞌu iqꞌobꞌ txꞌiibꞌal iqꞌii utz, motx taqꞌ oya te. Motx taqꞌ ibꞌaꞌnla qꞌan chꞌichꞌ, tuchꞌ kaxhlaan pom utz, tuchꞌ txꞌumqꞌixsabꞌal, mirra. ");
INSERT INTO ixlCNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Uncheeꞌ tꞌoyax tek qꞌu aa txumbꞌal tivatzikꞌ. Alax te aas yeꞌk samotxpaal xeꞌ u Herodes. Ech paarten tek bꞌey motx tiqꞌo aas iqꞌaaveꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Uncheeꞌ aatz maꞌtich motx iqꞌaaveꞌ, chee maꞌl u aanjel tivatzikꞌ u Xhep; tal te ech tzaꞌ: —¡Lakpen, bꞌan uucheꞌ! Iqꞌo bꞌen u tal nitxaꞌ tuchꞌ vinan tziꞌ utz, jutzpen bꞌen tuchꞌ tikuenta Egipto. Atinen tziꞌ. Laꞌnalval see lakꞌasuꞌlaxh tan, toj nal iꞌaneꞌ aas sachokax u tal nitxaꞌ tu u Herodes. Siyatzꞌeꞌ sitxumeꞌ.— Texh u aanjel. ");
INSERT INTO ixlCNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ech kꞌas tek u Xhep tu u aqꞌbꞌal tziꞌ. Tiqꞌo bꞌen u tal nitxaꞌ tuchꞌ vinan utz, bꞌen tu Egipto. ");
INSERT INTO ixlCNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ech aꞌ motx atinku latziꞌ kamnalich el u Herodes. Loqꞌ itzojpu chit u yol vaꞌl alich nal tu u Tioxh titziꞌ u alol tetz viyolbꞌal aas tal ech tzaꞌ: —Val ikꞌasuꞌl vunKꞌaol tu Egipto.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Uncheeꞌ aatz til u Herodes aas maꞌtich koꞌn tel iqꞌii tu qꞌu aa txumbꞌal, xoꞌvebꞌal ilakp iviꞌ iꞌana tan, yeꞌt paal tal u yol te. Utz tal tek iyatzꞌax kajay qꞌu talaj xiak qꞌuꞌl tu u tenam Beleen tuchꞌ qꞌuꞌl najaꞌch chaj u tenam, ayaꞌ qꞌuꞌl anal titzꞌeꞌaꞌ neꞌnyaꞌoj tu qꞌuꞌl kaꞌl iyaꞌbꞌ. Tan aꞌ bꞌenku tiꞌ u tiempo vaꞌl alax te tu qꞌu aa txumbꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ech itzojpu u yol vaꞌl alich tu u Jeremias, u alol tetz u yolbꞌal Tioxh, aas tal ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","—Techal tuch qꞌeqꞌuꞌm tu u txꞌavaꞌ Ramaa. Techal bꞌoj tuch juujuꞌlanchil tu oqꞌel utz, vaꞌl txumumla chaj yol nitalaxeꞌ. Vaꞌl toqꞌ qꞌul ituꞌxh ixalam u Raqueel tiꞌ qꞌu titzꞌin utz, yeꞌ isaꞌ samoxbꞌeli tan, motx yatzꞌax qꞌu titzꞌin.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Uncheeꞌ aatz maꞌtich tek ikam u Herodes, chee maꞌl u aanjel tetz Tioxh tivatzikꞌ u Xhep aas atich tu Egipto. ");
INSERT INTO ixlCNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Utz tal te ech tzaꞌ: —Kuxh tek tikuenta vitxꞌavaꞌ qꞌu Israeel. Iqꞌo bꞌen u tal nitxaꞌ tuchꞌ vinan tan, kamyu qꞌuꞌl nichitzꞌan iyatzꞌax u tal nitxaꞌ tziꞌ.— Texh u aanjel. ");
INSERT INTO ixlCNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ech telkꞌasuꞌl u Xhep tziꞌ. Tiqꞌo kꞌasuꞌl u tal nitxaꞌ tuchꞌ vinan utz, ul tu u txꞌavaꞌ tikuenta qꞌu Israeel. ");
INSERT INTO ixlCNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pek aatz u Xhep, ixoꞌva bꞌenchil tu Judea tan, tabꞌi aas u Arquelao atich ok ijlenalil sivatzil u Herodes vitat. Ech tꞌoyax tivatzikꞌ tu u Tioxh. Utz aꞌ tek ikꞌajvu bꞌen tikuenta Galilea. ");
INSERT INTO ixlCNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ech tuleꞌ uli. Utz ex jejeꞌoj tu u tenam Nazareet. Loqꞌ itzojpu chit u Yolbꞌal Tioxh, vaꞌl alel nal tu qꞌu alol tetz u yolbꞌal Tioxh aas: —Aa Nazareet chaj teꞌleꞌ.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Uncheeꞌ aatz iꞌan tu u tiempo tziꞌ, ul u Xhan, u bꞌanol vautiismo utz, nichipaxsa talax u yolbꞌal Tioxh tu u tzꞌinlich tzaji txꞌavaꞌ tikuenta Judea. ");
INSERT INTO ixlCNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nichtal ech tzaꞌ: —Kꞌaxataj qꞌul epaav tan, ninajabꞌ tul viQꞌesalail u Tioxh tu Amlika tu kuxoꞌl.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Utz tiꞌ u Xhan yolonku u Isaias, u alol tetz u yolbꞌal Tioxh, aas taltu ech tzaꞌ: —Sajeꞌ iviꞌ maꞌl u vinaj tu yol tu u tzꞌinlich tzaji txꞌavaꞌ; satal ech tzaꞌ: «Jikomtixsataj etxumbꞌal vatz u kuBꞌaal Tioxh, echaꞌ ijikomtixsal bꞌey siatz sebꞌaneꞌ.» Chaj.— Texh u Isaias. ");
INSERT INTO ixlCNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Uncheeꞌ aatzich u toksaꞌm u Xhan tan, chemich xiꞌl camello. Utz tzꞌuꞌm u qitzbꞌal xeꞌaj tuul. Aꞌich techbꞌubꞌal sakꞌ tuchꞌ taꞌl kabꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ech nichtopon qꞌu aa Jerusaleen kꞌatz u Xhan tuchꞌ qꞌu aa tikuenta Judea utz, tuchꞌ qꞌuꞌl jejlich tziꞌ u nimaꞌ Jordaan. ");
INSERT INTO ixlCNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Utz nichmotxikꞌaxa qꞌul ipaav. Ech bꞌanax tek vautisaar tu u Xhan tu u nimaꞌ Jordaan. ");
INSERT INTO ixlCNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Uncheeꞌ til u Xhan aas antu opon qꞌu fariseo tuchꞌ qꞌu saduceo. Aꞌ isaꞌ sabꞌanax vautisaar majte. Ech tal tek te ech tzaꞌ: —Txꞌiꞌla chaj aanima, ¿abꞌil nichusunex te aas tu koꞌxh vebꞌant evautiismo setxꞌol etel vatz vikꞌaꞌnal u Tioxh vaꞌl tuleꞌ? ");
INSERT INTO ixlCNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Pek kꞌuchtaj u bꞌaꞌnil, techlal aas nojchit vetekꞌaxal qꞌul epaav. Ech ex sebꞌaneꞌ u tzeꞌ vaꞌl txꞌanel ivatzineꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Utz yeꞌ koꞌxh etal tiꞌ etaanima aas: «Aꞌ kutat u Abrahaam. Kam koj sabꞌanonoꞌ.» Chajkojex. ¡Tan nojchit nival sete aas yeꞌ koj saveeti sabꞌens kꞌaol Abrahaam qꞌu sivan tu u Tioxh tziꞌ! ");
INSERT INTO ixlCNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Utz chꞌiam texh niꞌan vikꞌaꞌnal u Tioxh kꞌatz qꞌuꞌl yeꞌ nikꞌuchun u bꞌaꞌnil. Echaꞌ ichꞌian kꞌoxbꞌal tiꞌ itzokꞌpu maꞌj tzeꞌ. Tan abꞌiste u tzeꞌ vaꞌl yitꞌ bꞌaꞌn koj ivatz siꞌaneꞌ, satzokꞌpi utz, sakꞌachpu tu xamal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Aatz in tan, nojchit tu koꞌn aꞌ nunbꞌanvu vautisaarex. Techlal ekꞌaxat epaav. Pek ech koj vaꞌl tul viꞌ tan, tiira paalchu tijleꞌm sunviꞌ. Aal yeꞌk sikꞌuloꞌk viꞌ soꞌokꞌins iqꞌon ixaabꞌ. Aꞌ vaꞌl sabꞌanon vautisaarex tixamlil u Tioxhla Espiiritu. ");
INSERT INTO ixlCNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Utz iqꞌomal ichꞌilibꞌal tiqꞌabꞌ, sichꞌili el ichꞌimil vitriigo. Utz simoloꞌk vitriigo tu kolbꞌal tetz. Pek aatz vichꞌimil, simoleꞌl tu u paqꞌbꞌal el tetz. Ech sikꞌachoꞌk tu u xamal vaꞌl yeꞌk itzaaeꞌ.— Texh u Xhan. ");
INSERT INTO ixlCNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Uncheeꞌ kꞌasuꞌl u Jesuus tikuenta Galilea. Utz ul xeꞌ u Xhan tziꞌ u nimaꞌ Jordaan, tiꞌ sabꞌanax vautisaar tu u Xhan. ");
INSERT INTO ixlCNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pek aatz u Xhan, yeꞌ nichisaꞌa te. Tal koꞌn te ech tzaꞌ: —Aal axh sabꞌanon vautisaarin bꞌatzꞌi. Pek aal aatz axh, sunbꞌan vautisaaraxh, aas naaleꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tzaqꞌbꞌel tek tu u Jesuus ech tzaꞌ: —Bꞌan vautisaarin, ech sakunojpixsa vaꞌl nital u Tioxh.— Texh u Jesuus. Ech tek ibꞌanax vautisaar tu u Xhan. ");
INSERT INTO ixlCNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Uncheeꞌ taꞌxh veet iꞌant ivautiismo u Jesuus, jeꞌul tu u aꞌ. Utz jajpu u amlika tu u muꞌkꞌul tziꞌ. Ech aꞌ texh til ikuꞌl u Tioxhla Espiiritu. Echaꞌ paroomaxh kuꞌl tibꞌa. ");
INSERT INTO ixlCNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ech uch kꞌasuꞌl maꞌl u yol tu Amlika, tal ech tzaꞌ: —Aꞌ vunKꞌaol tiichitꞌin tiꞌ atziꞌ, vaꞌl kꞌujlel unkꞌuꞌl tiꞌ.— Texh u yol. ");
INSERT INTO ixlCNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Uncheeꞌ iqꞌol bꞌen u Jesuus tu maꞌl u tzꞌinlich tzaji txꞌavaꞌ tu u Tioxhla Espiiritu. Utz bꞌanax provaal isubꞌax tu txꞌiꞌliꞌinaj latziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","40 qꞌii 40 aqꞌbꞌal kuꞌ tiꞌ ikuyax ivaꞌy, yeꞌt txꞌaꞌni. Utz taꞌxh paal qꞌu qꞌii tziꞌ, kam tek tu vaꞌy. ");
INSERT INTO ixlCNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ech opon u txꞌiꞌliꞌinaj kꞌatza, tal te ech tzaꞌ: —Untzꞌoj nojchit axh iKꞌaol Tioxh, bꞌensas kaxhlaan txꞌix qꞌu sivan tziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Tzaqꞌbꞌel tu u Jesuus utz, tal ech tzaꞌ: —Tzꞌibꞌamalka tu u Yolbꞌal Tioxh aas: «Taꞌn koꞌnkoxh u kaxhlaan txꞌix saꞌitzꞌpixsan qꞌu aanima, pek tu kajay qꞌu yol alel tu u Tioxh majte.» Chia.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Uncheeꞌ aatz u txꞌiꞌliꞌinaj, tiqꞌo bꞌen u Jesuus tu u tenam Jerusaleen utz, jeꞌop taqꞌo tu u xoobꞌal iviꞌ viqꞌanalil u totztioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Tal te ech tzaꞌ: —Untzꞌoj nojchit axh iKꞌaol Tioxh, kꞌon koꞌp iibꞌ tzaꞌ qabꞌi. Tan tzꞌibꞌamalka majte aas: «Atil qꞌu aanjel tetz u Tioxh saiꞌ. Suꞌlikꞌulaxh tiqꞌabꞌ. Ech yeꞌk sapaqꞌoꞌk iibꞌ tiꞌ sivan.» Chia.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Tzꞌibꞌamalka majte aas: «Sakoꞌnkoxhayaꞌlu u Tioxh u kuBꞌaals Amilka tiꞌ ibꞌanax kam.» Chia.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Uncheeꞌ aatz paj iꞌan u txꞌiꞌliꞌinaj, tiqꞌo bꞌen u Jesuus viꞌ maꞌl u tꞌankin muunte. Utz ikꞌuch kajay qꞌu tenam te tuchꞌ qꞌu mamaj txꞌiibꞌal iqꞌii atil tu u vatz amlika txꞌavaꞌ tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Utz tal tu u Jesuus ech tzaꞌ: —Savaqꞌ kajay qꞌu kam see tziꞌ oj sapecheꞌaxh sunvatz utz, sooksa unqꞌii.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —¡Maꞌt tzik axh txꞌiꞌliꞌinaj! Tan tzꞌibꞌamalka tu u Yolbꞌal Tioxh aas: «Taꞌxh u Tioxh u kuBꞌaals Amlika sooksa iqꞌii utz, taꞌxh maꞌl sanima.» Chia.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ech telabꞌelka tu u txꞌiꞌliꞌinaj. Utz ech ul unjolol aanjel. Ul taqꞌ techbꞌubꞌal u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Uncheeꞌ tabꞌi u Jesuus aas atich tek ok u Xhan tu tzeꞌ. Ech qꞌaavtekbꞌen tu Galilea. ");
INSERT INTO ixlCNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Paal yakloj vatz u Nazareet. Utz ex atoj tu u tenam Capernauum, tziꞌ choo tikuenta u txꞌavaꞌ Zabuloon tuchꞌ Neftalii. ");
INSERT INTO ixlCNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Utz bꞌenkoꞌnkoxhok pek itzojpu chit u Yolbꞌal Tioxh vaꞌl tal u Isaias alol tetz u yolbꞌal Tioxh, aas tal ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","—Txꞌavaꞌ tikuenta Zabuloon, txꞌavaꞌ tikuenta Neftalii, tu u bꞌey maꞌt tziꞌ choo sala bꞌen u Jordaan tikuenta Galilea, itxꞌavaꞌ puera aanima, ");
INSERT INTO ixlCNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","aatz qꞌu aanima tziꞌ, samotxtil mam bꞌaꞌnil, kꞌuxh tiira tzꞌejel bꞌen tibꞌ tu mam paav. Utz sapaqꞌun mam txijtxubꞌal tzixeꞌ kꞌuxh chꞌiam texh niꞌan tu kamchil.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Uncheeꞌ xeꞌt u Jesuus tiꞌ talax u yolbꞌal Tioxh latziꞌ. Nichtal ech tzaꞌ: —Kꞌaxataj qꞌul epaav tan, atil tek viQꞌesalail u Tioxh tu Amlika texoꞌl.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Uncheeꞌ aatz nichipaal u Jesuus tziꞌ u choo tu Galilea, til kaꞌvaꞌl qꞌu vinaj tziꞌ, itzaꞌqꞌ tibꞌ. Maꞌl, Xhim ibꞌii utz; Luꞌ ibꞌii majte. Aꞌich imol u Lixh, vitzaꞌqꞌ. Nichmotxtaqꞌ koꞌp kꞌach tu aꞌ, eesabꞌ txay. Tan jolol eesanich txay. ");
INSERT INTO ixlCNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ech tal u Jesuus te ech tzaꞌ: —Niꞌextaj viꞌ tan, savoksaꞌexs chokol aanima. Yitꞌ txay tereꞌn koj sechokeꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ech yakich motx taqꞌka qꞌul ikꞌach, eesabꞌ itxay. Utz xambꞌu tiꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Bꞌiit koꞌxh paj ixaa tuul utz, til kaꞌvaꞌt qꞌu vinaj, itzaꞌqꞌ tibꞌ. Ikꞌaol u Zebedeo. Ayaꞌ u Jacobo tuchꞌ u Xhan, vitzaꞌqꞌ. Nichmotxikꞌooa qꞌul ikꞌach tu jukubꞌ tuchꞌ vitat. Utz isikꞌle. ");
INSERT INTO ixlCNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ech yakich motx taqꞌka u jukubꞌ utz, taqꞌka vitat. Ech motx xambꞌu tiꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Uncheeꞌ paal u Jesuus tikuenta kajay u Galilea. Utz nichichus u yolbꞌal Tioxh tu qꞌu atibꞌal chusbꞌal tetz u oꞌtla mantaar. Utz ipaxsa talax u bꞌaꞌnla chusbꞌal tetz viQꞌesalail u Tioxh tulaj tenam majte. Utz tzꞌajel iatz yaabꞌil nichteesa. Nichiꞌan bꞌaꞌn tu kajay qꞌu aanima qꞌuꞌl atich tu yaabꞌil tuchꞌ tu kꞌaxkꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ech antu paxku bꞌen talax itziiul u Jesuus tikuenta u txꞌavaꞌ Siiria. Utz iqꞌol ul kajay qꞌu aanima siatz qꞌuꞌl atich tu kꞌaxkꞌo, tu il, tu yaabꞌil, tu tzaꞌl, qꞌuꞌl atich ok txꞌiꞌliꞌinaj kꞌatza, tuchꞌ qꞌuꞌl niꞌan tiila yaabꞌil tiꞌ ichꞌ utz, tuchꞌ qꞌuꞌl numtzꞌinaj iqꞌabꞌs tajan. Utz nichibꞌan bꞌaꞌn te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Uncheeꞌ sibꞌla aanima xambꞌu tiꞌ u Jesuus. At aa tikuenta Galilea. At aa tikuenta Decaapolis. At aa Jerusaleen. At aa Judea. Utz at aa sala bꞌen Jordaan. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Uncheeꞌ aatz til u Jesuus aas mam tenam molich tibꞌ, bꞌenjeꞌ viꞌ maꞌl u muunte. Kꞌujeꞌi utz, xaan opon qꞌul ichusulibꞌ kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ech xeꞌt ichusun u Jesuus utz, tal tu qꞌul ichusulibꞌ ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Chiꞌbꞌebꞌal tetz qꞌu aanima qꞌuꞌl at niꞌenku te aas niyaꞌta Tioxh tan, tetz viQꞌesalail u Tioxh tu Amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Chiꞌbꞌebꞌal tetz qꞌu aanima qꞌuꞌl nitoqꞌ vatz Tioxh tan, saꞌnalaqꞌax nimal ikꞌuꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Chiꞌbꞌebꞌal tetz qꞌu aanima qꞌuꞌl yeꞌ nitꞌanbꞌaꞌ tibꞌ tan, saꞌnaltetzi u txꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Chiꞌbꞌebꞌal tetz qꞌu aanima qꞌuꞌl tiira nitachva ibꞌanax vijikomal, echaꞌ tachval echbꞌubꞌal niꞌaneꞌ aas nikam tu vaꞌy, nikam tu tzaj itziꞌl tan, saꞌnalpaasal tu u tachaꞌv. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Chiꞌbꞌebꞌal tetz qꞌu aanima qꞌuꞌl nitxum iatz aanima tan, satxumax iatz tu u Tioxh majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Chiꞌbꞌebꞌal tetz qꞌu aanima qꞌuꞌl yeꞌxhkam nititzꞌa ibꞌanax u paav, bꞌaꞌn u taanima tan, saꞌnaltil iatz u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Chiꞌbꞌebꞌal tetz qꞌu aanima qꞌuꞌl niꞌan yaꞌl tok u paas tan, saꞌnal alax tiꞌ aas ikꞌaol imeꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Chiꞌbꞌebꞌal tetz qꞌu aanima qꞌuꞌl nitojchal tiꞌ vijikomal tan, aꞌ tetz viQꞌesalail u Tioxh tu Amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Chiꞌbꞌebꞌal etetz siꞌaneꞌ oj sayoqꞌaxex viꞌ, saojchalex utz, kam koꞌn yeꞌxtxojla chaj kam sasuyax setiꞌ, loqꞌ txubꞌaꞌl kuꞌen. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ech txuqꞌtxunojex utz, chiꞌbꞌojex tan, mam echoobꞌal sekꞌul tu Amlika. Tan echat koꞌxh tixval qꞌu alol tetz u yolbꞌal Tioxh bꞌanax koꞌxtene atziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ech ex u atzꞌam tu u vatz amlika txꞌavaꞌ tzaꞌ aas nichiꞌbꞌixsa utz, nimaj iyan kam. Tan untzꞌoj sasotz vichiꞌlil u atzꞌam, kam tereꞌn koj satxakunka. Saꞌtexhkꞌonax el. Saꞌtexhtzeqꞌaxka. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ech ex aꞌ txijtxubꞌal tu u vatz amlika txꞌavaꞌ tzaꞌ oj sekꞌuch qꞌu bꞌaꞌnil vatz aanima. Echaꞌ maꞌl tenam atil jeꞌ viꞌ muunte, mujel koj tatineꞌ. Pek paqꞌlele. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tan echaꞌ u txijtxubꞌal aas nimatxleꞌ, yitꞌ sakoꞌnkojmujli. Pek aal nitꞌanbꞌaꞌl jeꞌ. Ech sitxijtxu tuul otzotz. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ech vinaꞌvit vebꞌanon vatz qꞌu aanima sebꞌaneꞌ. Ech aatz latila tiira bꞌaꞌn ebꞌanoneꞌ, laꞌtektoksa iqꞌii u kuTat tu Amlika taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yeꞌ koꞌxh etitzꞌa aas aꞌ ul unsotzsa u oꞌtla mantaar, nikoꞌxh qꞌu yol alelka tu qꞌu alol tetz u yolbꞌal Tioxh. Yitꞌ aꞌ koj ul unsotzsa. Pek aal aꞌ ul untzojpixsa. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tan niꞌxhtekꞌval sete kꞌuxh sasotz u vatz amlika txꞌavaꞌ tzaꞌ, jatu koj sayaꞌ itzojpu u Yolbꞌal Tioxh. Maꞌl itzojpeꞌ, kꞌuxh chꞌoo texhtuꞌ tiloneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Echtzixeꞌt chꞌoo tatin tu viQꞌesalail u Tioxh tu Amlika siꞌaneꞌ oj abꞌil yeꞌ saniman maꞌj qꞌu mantaar tan, chꞌoo texh siatz. Utz echat koꞌxh majte oj nikꞌuch vatz imol aas yeꞌk sinima qꞌu mantaar. Pek abꞌil saniman utz, echat nikꞌuchtimol, nim tatin tu viQꞌesalail u Tioxh tu Amlika siꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ech nojchit nival sete, oj yeꞌk sapaal vejikomil vatz qꞌu aa txumbꞌal tetz u oꞌtla mantaar utz, vatz qꞌu fariseo, saꞌkojekꞌul viQꞌesalail u Tioxh tu Amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Etootzajle aas nital u oꞌtla mantaar tu qꞌu kꞌuy kumam ech tzaꞌ: «Yatzꞌonichꞌex. Tan abꞌil vaꞌl sayatzꞌoni, paav satija.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pek nival sete tan, abꞌil qꞌuꞌl sakoꞌxhtaqꞌen ikꞌaꞌnat imol utz, paav satija. Abꞌil qꞌuꞌl siyoqꞌ imol, aꞌ sayaꞌk vatz qꞌu qꞌatbꞌal tzii. Utz aatz qꞌuꞌl sisuy yol tiꞌ imol, aꞌ seꞌenku tu xamal, choobꞌal paav. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Echaꞌ tziꞌ untzꞌoj siiqꞌo ul aoya vatz u nachbꞌal Tioxh utz, tuul suꞌul sakꞌuꞌl aas atil axoꞌl tuchꞌ maꞌl amol, ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","aqꞌka vaoya vatz u nachbꞌal Tioxh. Utz kuxh bꞌan bꞌaꞌn tuchꞌ bꞌaxa. Ech nal luꞌlaaqꞌ vaoya. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Bꞌan bꞌaꞌn tuchꞌ vaꞌl nixochꞌaxh tuul koꞌxh yeꞌsaj oopon tuchꞌ tu qꞌatbꞌal tzii tan, noj toksaꞌaxh tiqꞌabꞌ u juees. Utz aatz u juees, satoksabꞌenaxh tiqꞌabꞌ polesiꞌy. Ech sataqꞌkuꞌaxh tu tzeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Utz niꞌxhtekꞌval see aas taꞌn kuꞌchil saꞌaneꞌ. Saꞌtereꞌnkojeluꞌlaxh oj yeꞌsajen achoot kajay vatxꞌoj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Etootzaj nal majte aas nital u oꞌtla mantaar ech tzaꞌ: «Eteesach etibꞌ tu bꞌey tuchꞌ aanima yitꞌ ekꞌulel koj.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pek nival sete tan, abꞌil vaꞌl tuchꞌ koꞌxhtuꞌ sisaji ok maꞌl ixoj utz, satachva ok, vetteesal tibꞌ tu bꞌey tuchꞌ tu taanima atziꞌ tan, yitꞌ ikꞌulel koj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ech tokeꞌ oj nitaqꞌbꞌenaxh u sebꞌal bꞌaqꞌ aatz tu paav, yaaqꞌ tzii te. Maj iibꞌ. Aal tek bꞌaꞌn seesa. Ech yeꞌk labꞌenaxh tu choobꞌal paav, tu xamal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Echat pajeꞌ oj nitaqꞌbꞌenaxh u sebꞌal aqꞌabꞌ tu paav, yaaqꞌ tzii te satxakun tiꞌ u paav. Maj iibꞌ. Aal tek bꞌaꞌn seesa. Ech yeꞌk labꞌenaxh tu xamal choobꞌal paav. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ech paj nital u mantaar aqꞌelka tzaꞌ majte: «Abꞌil vaꞌl sataqꞌka tixoj, taqꞌ koꞌn bꞌen maꞌl tuꞌ tetz jatxbꞌalibꞌ.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pek nival sete, abꞌil qꞌuꞌl sakoꞌxhtaqꞌ tojchat tixoj yitꞌ tiꞌ koj niteesa tibꞌ tu bꞌey tuchꞌ vaꞌt vinaj, aal aꞌ nitaqꞌ tzii sateesa tibꞌ u ixoj tu bꞌey tuchꞌ vaꞌt vinaj tziꞌ aas yitꞌ ikꞌulel koj. Utz abꞌil u vinaj vaꞌl sikꞌul tibꞌ tuchꞌ u ixoj vaꞌl ojchamal tziꞌ, eesaibꞌ tu bꞌey niꞌan tuchꞌ tan, yitꞌ ikꞌulel koj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Etootzaj majte aas ech alaxnaj tu qꞌu kꞌuy chaj kumam koꞌxtene tzaꞌ: «Oj kam maꞌj setalaꞌtziꞌi tu u Tioxh, aas setoksa ibꞌii kam tuul, tzojpixsataj. Yitꞌiꞌas sakoꞌnkoxhetxubꞌaꞌli Tioxh.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pek nival sete tan, yitꞌiꞌas sakoꞌnkoxhetoksa ibꞌii kam tuul aas kam maꞌj setalaꞌtziꞌi tu u Tioxh. Nikoꞌxh saꞌkojetoksa Amlika tuul. Tan tatibꞌal u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Utz nikoꞌxh u txꞌavaꞌ saꞌkojetoksa tuul. Tan itzeqꞌbꞌal u Tioxh. Utz nikoꞌxh u Jerusaleen tan, tetz atkoꞌxh u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Utz nikoꞌxh veviꞌ saꞌkojetoksa tuul. Tan saꞌkojveeti setaqꞌ bꞌen saj oj qꞌej maꞌl xiꞌl viꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Pek aatz veyol sebꞌaneꞌ tan, oj saꞌi utz, bꞌantaj. Pek oj yeꞌka utz, yeꞌ ebꞌana. Tan oj laꞌtereꞌnechup iviꞌ, tetz tek u maalo atziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Etootzaj majte aas alaxnaj ech tzaꞌ: «Oj abꞌil sitzottixsa bꞌaqꞌ iatz imol, satzottixsal bꞌaqꞌ iatz majte. Utz oj abꞌil sateesa tee imol, saeesal tee majte.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pek nival sete, yeꞌk sekꞌulela ok vaꞌl yeꞌxtxoj niꞌan sete. Kꞌuxh sipaqꞌoꞌk sebꞌal txala etziꞌ, pilqꞌutaj koꞌn ok vaꞌt siatz. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Echaꞌ tziꞌ majte oj abꞌil sichok ixeꞌt sekꞌatza tiꞌ imaaleꞌl etoksaꞌm, aqꞌtaj te. Tiqꞌon vechakeꞌt majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Untzꞌoj sabꞌanax yaꞌlex tiꞌ tijal maꞌj ijatz aas maꞌl kiloometro, sexaa sataleꞌ, iqꞌotaj utz; aal tu kaꞌvaꞌl kiloometro seꞌnetaqꞌvuka. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Utz aqꞌtaj tetz abꞌil kam nijaj sete. Utz abꞌil sijaj ikꞌam sete, yeꞌk siꞌaneꞌ yeꞌk setaqꞌ te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Etootzaj majte aas alaxnaj ech tzaꞌ: «Tiiojex tiꞌ qꞌul etamiigo sebꞌaneꞌ. Pek yeꞌk itxaꞌk qꞌul ekoontra sete sebꞌaneꞌ.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pek nival sete, tiiojex tiꞌ qꞌul ekoontra sebꞌaneꞌ. Altaj bꞌaꞌnla chaj yol tiꞌ qꞌuꞌl nialon tzꞌejbꞌal yol setiꞌ. Bꞌantaj bꞌaꞌnil tu qꞌuꞌl niꞌixvanex. Utz qꞌilataj sikꞌletaj Tioxh tiꞌ qꞌuꞌl niꞌojchanex. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ech nojchit ex ikꞌaol imeꞌal u kuTat tu Amlika siꞌaneꞌ tziꞌ. Tan maꞌl koꞌn itxijtxun u qꞌii viꞌ kajay qꞌu aanima niꞌaneꞌ, kꞌuxh bꞌaꞌn, kꞌuxh yeꞌxtxoj. Utz maꞌl tul ijabꞌal qꞌu aanima niꞌaneꞌ kꞌuxh jikom, kꞌuxh yitꞌ jikom. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tan oj taꞌxh sebꞌan bꞌaꞌn ex te qꞌuꞌl bꞌaꞌn sete, kam koj echoobꞌal sekꞌul tu Amlika. Tan ech ibꞌanon qꞌuꞌl yeꞌ tootzaj Tioxh atziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Utz oj taꞌxh seqꞌila qꞌul etitzꞌin etatzik, ¿kam tek bꞌoj bꞌaꞌnla kam nebꞌaneꞌ? Tan echat koꞌxh ibꞌanon qꞌu aanima qꞌuꞌl yeꞌ tootzaj Tioxh atziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pek bꞌantajex echaꞌ u kuTat tu Amlika tziꞌ aas tzꞌajel iatz bꞌaꞌnil niꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yeꞌ koꞌxh ebꞌana aas setoksa jeꞌ eqꞌii vatz qꞌu aanima tiꞌ ibꞌanax vijikomal. Tan oj ech sebꞌan tziꞌ, saꞌkojekꞌul echoobꞌal xeꞌ u kuTat tu Amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Pek oj seloch meꞌbꞌaꞌ, yeꞌ koꞌxh eyoleꞌl, echaꞌ niꞌan qꞌu kaꞌvatzla chaj qꞌesala aas nitopon tu qꞌu atibꞌal chusbꞌal tetz u oꞌtla mantaar. Utz ech niꞌan tu bꞌey majte. Aꞌ isaꞌ toksal iqꞌii. Ech niꞌxhtekꞌval sete aas tu koꞌxh u toksal iqꞌii tu qꞌu aanima, eesanyu texh qꞌul ichoobꞌal tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pek aatz seloch qꞌu meꞌbꞌaꞌ, nikoꞌxh u aanima saootzajin vaꞌl tiira bꞌaꞌn ex tuchꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ech aatz velochoneꞌ tziꞌ, yeꞌxhabꞌil koꞌxh saootzajin. Tan aatz u kuTat vaꞌl nitil qꞌu kam yeꞌ naꞌl, aꞌ tek saoksan eqꞌii vatz tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Utz aatz seqꞌila sikꞌle Tioxh, yeꞌ koꞌxh ebꞌan ex echaꞌ qꞌu kaꞌvatz qꞌuꞌl vatz chit ikꞌuꞌl txaklele niqꞌila sikꞌle Tioxh tu qꞌu atibꞌal chusbꞌal tetz u oꞌtla mantaar tuchꞌ tu qꞌu qꞌeꞌtx chaj bꞌey majte. Tan aꞌ isaꞌ tilax tu aanima. Utz niꞌxhtekꞌval sete aas tu koꞌxh u toksal iqꞌii tu qꞌu aanima tziꞌ, eesanyu texh qꞌul ichoobꞌal tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pek aatz seqꞌila esikꞌle Tioxh, juptaj etibꞌ toꞌotzotz. Utz qꞌilataj sikꞌletaj u kuTat vaꞌl yeꞌ naꞌl tatineꞌ. Loqꞌ kajay nitileꞌ utz, aꞌ soꞌoksan eqꞌii vatz tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Utz aatz seqꞌila esikꞌle Tioxh, yeꞌ koꞌxh ekaꞌpaju etoxpaju qꞌu yol qꞌuꞌl yeꞌk texh tokebꞌal. Tan ech niꞌan qꞌu aanima qꞌuꞌl yeꞌ tootzaj Tioxh. Aꞌ nimotxtaleꞌ aas saꞌxhnimal tu u Tioxh tu vikaꞌpajut itoxpajut qꞌul iyol. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Pek aatz ex, yeꞌ koꞌxh ebꞌan ex echi. Tan tootzajle u kuTat, kam nesavsa kꞌuxh yeꞌsajen ejajtu te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Uncheeꞌ ech eqꞌilat esikꞌlet Tioxh sebꞌan tzaꞌ: «KuBꞌaals Amlika, tioxhla bꞌii tatin vabꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Uloj abꞌan vaQꞌesalail. Utz bꞌan vatxumbꞌal tu u vatz txꞌavaꞌ tzaꞌ, echaꞌ vaꞌl naꞌan tu Amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Aqꞌ u qechbꞌubꞌal tetz jun qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Utz kuy qꞌu kupaav, echaꞌ oꞌ nikukuy qꞌu aanima qꞌuꞌl kam niꞌan qe. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Yaaqꞌ tzii sakuꞌoꞌ tu qꞌu paav qꞌuꞌl nitok sukuvatz. Eesaꞌoꞌ vatz u txꞌiꞌliꞌinaj. Tan eetz u Qꞌesalail, eetz u ijleꞌm utz, eetz u techalil bꞌenamen yeꞌk iyaꞌeꞌ. Aꞌi.» Chajex. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Tan oj sekuy qꞌu aanima qꞌuꞌl kam niꞌan sete, echat koꞌxh u kuTat tu Amlika majte, sikuyex. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pek oj yeꞌk sekuy qꞌu aanima tiꞌ vaꞌl niꞌan sete, echat koꞌxh u kuTat majte, saꞌkojikuyex tiꞌ qꞌu yeꞌxtxojla kam nebꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Aatz sakuꞌex tiꞌ ikuyl evaꞌy tiꞌ iqꞌilal sikꞌlel Tioxh, yeꞌ koꞌxh ebꞌana aas vaꞌl txumuꞌm tevatz sebꞌaneꞌ, echaꞌ niꞌan qꞌu kaꞌvatzla chaj aanima. Tan nimotxitxumunsa tibꞌ. Nimnaꞌl aas nikuy ivaꞌy. Aꞌ isaꞌ sailax tu qꞌu aanima. Ech niꞌxhtekꞌval sete aas tu koꞌxh u tilax tu qꞌu aanima tziꞌ, eesanyu texh qꞌul ichoobꞌal tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pek aatz sakuꞌex tiꞌ ikuyl evaꞌy tiꞌ iqꞌilal sikꞌlel Tioxh, josqꞌitaj eviꞌ. Utz txꞌaataj evatz. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ech yeꞌk sekꞌuch tu qꞌu aanima aas atilkuꞌex tiꞌ ikuyax evaꞌy. Pek aꞌ sekꞌuchvu tu u kuTat vaꞌl yeꞌ naꞌl tatineꞌ. Tan kajay nitileꞌ. Utz aꞌ tek soꞌoksan eqꞌii vatz tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Yeꞌ koꞌxh emol txꞌiibꞌal eqꞌii tu u vatz amlika txꞌavaꞌ tzaꞌ. Tan nikoꞌnipokꞌteꞌ. Utz nixajteꞌ. Ech niyaneꞌ. Utz nitok elqꞌom tuul majte utz, nitelqꞌaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Pek aꞌ sebꞌanvu bꞌen txꞌiibꞌal eqꞌii tu Amlika tu vaꞌl yeꞌ nipokꞌtik qꞌu kam. Utz nikojixajteꞌ. Nikojiyaneꞌ. Utz saꞌkojoleꞌ elqꞌom tiꞌ telqꞌaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tan til vaꞌl atilku u txꞌiibꞌal eqꞌii, ayeꞌn vetaanima tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Bꞌaꞌn etatin vatz Tioxh untzꞌoj jikom isajil qꞌu kam nebꞌaneꞌ utz, yeꞌxhkam netitzꞌa onkonil tiꞌ. Tan aatz u bꞌaqꞌ evatz, aꞌ u txijtxubꞌ tetz vechiꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pek oj yitꞌ jik koj isajil qꞌu kam nebꞌan tuchꞌ qꞌu bꞌaqꞌ evatz, aꞌ chit netitzꞌa u onkonil tiꞌ. Tiira atil bꞌenex tu u paav atziꞌ. Bꞌaꞌn koj etatin vatz Tioxh; tu uken atilkꞌex. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Saꞌkojiꞌaneꞌ aas kaꞌvaꞌl tioxh sinima u aanima. Tan sinima maꞌl atziꞌ utz, siqel vaꞌte. Tii tiꞌ maꞌl atziꞌ utz, yeꞌk itxaꞌk vaꞌt te atziꞌ. Echtzixeꞌt yeꞌk saveeti aas kaꞌvaꞌl tiqꞌol sebꞌaneꞌ, u Tioxh tuchꞌ qꞌu txꞌiibꞌal qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ech tokeꞌ yeꞌ koꞌxh elaꞌokꞌex tiꞌ u vatz eqꞌii esaj. Echaꞌ tziꞌ kam setechbꞌu utz, kam setukꞌa. Utz yitꞌ sakoꞌnkoxhelaꞌokꞌex tiꞌ ivijax vechiꞌl majte, tiꞌ aas kam setoksaꞌmi. Tan paalchu tekoj u echbꞌubꞌal tuchꞌ u oksaꞌm viꞌ u atinchil tu bꞌenqꞌii bꞌensaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Sajitaj qꞌu tzꞌichin nipaal tu amlika etileꞌ. Yeꞌkax chikoni. Yeꞌkax imol vatz ichikobꞌeꞌm. Utz yeꞌk molbꞌal titzꞌlebꞌal. Tan u kuTat tu Amlika nitzujbꞌen tziꞌ. Ech ¿yitꞌ tzik paalchꞌex vatz qꞌu tzꞌichin tziꞌ tzik? ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Tan kꞌuxh saꞌxhelaꞌok maꞌj aanima, saꞌkojoleꞌi sataqꞌ jeꞌop bꞌitoj tatin tu u vatz iqꞌii saj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Utz echat koꞌxh tiꞌ u oksaꞌm. ¿Kantuꞌ aas niꞌxhetelaꞌ etokeꞌ? Sajitaj qꞌu xuꞌm jaꞌjchajtzeꞌ etileꞌ kaniꞌch ichꞌiieꞌ. Tan yeꞌkax aqꞌonini. Utz yeꞌkax chemoni. Utz txꞌanel isajineꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ech tokeꞌ nival sete aas aal nikoꞌxh u ijlenal Salomoon ech koj ivijtu tibꞌ iꞌana u tilon qꞌu xuꞌm tziꞌ kꞌuxh mamala txꞌiiol iqꞌiich. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Echat koꞌxh pajeꞌ qꞌu xajtzeꞌ qꞌuꞌl jaꞌjtzeꞌ. U Tioxh chit nibꞌanon aas txꞌanel tilon qꞌul ixuꞌm. Vaꞌl ichaꞌxabꞌeꞌ kꞌuxh ech qꞌejal nikꞌachlu tu xamal. Utz ¿yitꞌ tzik ech taqꞌax etoksaꞌm siꞌan u Tioxh nenacheꞌ kꞌuxh yeꞌ maas kꞌujlel ekꞌuꞌl tiꞌ? ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Echtzixeꞌt yeꞌ koꞌxh etal tu elaꞌokchil ech tzaꞌ: «¿Kam saqechbꞌu? ¿Kam saqukꞌa? Utz ¿kam saqoksaꞌmi?» Chajkojex. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tan qꞌu puera aanima qꞌuꞌl yeꞌ tootzaj Tioxh koꞌn nitelaꞌ tok tiꞌ qꞌu kam tziꞌ. Pek ech koj ex tan, tootzajle u kuTat tu Amlika aas nesavsa kajay qꞌu kam tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pek aꞌ chit saelaꞌokkꞌex tiꞌ viQꞌesalail u Tioxh, tuchꞌ tiꞌ vijikomil. Ech toj texh tal tul kajay qꞌu kam atziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ech yeꞌ koꞌxh elaꞌokꞌex tiꞌ u qꞌii vaꞌl qꞌejal. Tan aatz u qꞌii qꞌejal, kam koꞌn elaꞌokchil suꞌul tuul. Pek chuspi koꞌxhtuꞌ seqꞌiꞌ qꞌu tzaꞌl tetz junun qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yeꞌ koꞌxh eyol paal u aanima oj niyolpu sevatz. Ech yeꞌk sakuꞌ vikꞌaꞌnal u Tioxh setiꞌ, tiꞌ veyolpu majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tan kaniꞌch itxꞌolax inujul qꞌu aanima sebꞌaneꞌ, echat chit itxꞌolax enujul siꞌan u Tioxh majte. Utz kam chit vaꞌl sebꞌan tu qꞌu aanima, echat chit sabꞌanax sete majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Pek ¿kam tokeꞌ aas taꞌxh tii nesaji u tal yeꞌxtxojla kam niꞌan emol sevatz utz, yeꞌxhat niꞌenku sete aas paalchu vebꞌanon siiꞌ? Ela koꞌxh tuchꞌ siil maꞌl tal juy chꞌis tu bꞌaqꞌ iatz amol; loqꞌ aꞌ yeꞌ niileꞌ aas mam tzeꞌ vaꞌl atil tu bꞌaqꞌ aatz. ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ela koꞌxh tuchꞌ siil maꞌl tal juy chꞌis tu bꞌaqꞌ iatz amol; loqꞌ aꞌ yeꞌ niileꞌ aas mam tzeꞌ vaꞌl atil tu bꞌaqꞌ aatz. Yeꞌk saveeti aas setoksa maꞌl aanima tu jik tiꞌ koꞌxh maꞌl u tal yeꞌxtxoj niꞌaneꞌ oj, tuul aatz ex, paalchu vepaav siatz. Tan ela koꞌxh tuchꞌ setal te ech tzaꞌ atziꞌ: «Aqꞌ tzii saveesa eluꞌl maꞌl u juy chꞌis taatz tziꞌ.» Chajex te. Tuul aatz ex, aal maꞌl mam tzeꞌ at okoꞌp tevatz utz, yeꞌ veet esajin taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Kaꞌvatz, yaꞌsataj qꞌu mamaj paav bꞌaxa! Ech nal saꞌtekveeti setal tu vemol aas siyaꞌsa qꞌu talaj kam niꞌaneꞌ. Eesataj eluꞌl u mam tzeꞌ xeꞌ bꞌaqꞌ evatz bꞌaxa tziꞌ. Utz aatz bꞌaꞌn tek etiloneꞌ, ech nal seꞌneteesa eluꞌl u juy chꞌis xeꞌ bꞌaqꞌ iatz vemol. ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Yeꞌ koꞌxh etal veꞌt u yolbꞌal Tioxh tu qꞌuꞌl echaꞌ txꞌiꞌ tiꞌ paav. Utz yeꞌ etal tu qꞌu bꞌoch xichin majte qꞌuꞌl tiira yeꞌ nitabꞌi yol tan, kam koj itxaꞌk te. Nikoꞌntaqꞌka eloꞌp echil tziꞌ utz; noj koꞌn iꞌan sete. ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Uncheeꞌ jajtaj tu u Tioxh kam nesavsa utz, saꞌaqꞌax sete. Choktaj utz, sechabꞌa. Sichꞌinojex vatz jubꞌal utz, sajajaxex. ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tan abꞌil qꞌuꞌl kam nijaj tu u Tioxh, nikꞌuleꞌ. Abꞌil qꞌuꞌl nichokoneꞌ, nichabꞌa. Utz abꞌil qꞌuꞌl nisichꞌin vatz jubꞌal, nijajaxeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Echaꞌ ex, ¿oj tzik sivan koꞌn setaqꞌ tekꞌaol emeꞌal oj sijaj ikaxhlaan txꞌix sete? ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Utz echat koꞌxhtuꞌ oj sijaj maꞌj ichiꞌo txay sete. ¿Tzꞌoj tzik txꞌiꞌla txokop setaqꞌ te? ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tan kꞌuxh yeꞌxtxoj chit etxumbꞌal, etootzajle kam bꞌaꞌnla chaj kam netaqꞌ tu qꞌul enitxaꞌa utz, aꞌ chixh u kuTat tu Amlika nenacheꞌ tziꞌ, yeꞌ koꞌxh sataqꞌ bꞌaꞌnla chaj kam tu qꞌuꞌl kam nijaj te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ech tokeꞌ kajay qꞌu bꞌaꞌnil esaꞌ siꞌan qꞌu aanima sete, echat sebꞌan te majte. Tan ech nital u oꞌtla mantaar. Utz ech alelka tu qꞌu alol tetz u yolbꞌal Tioxh majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Aꞌ soꞌokkꞌex tu u okebꞌal vaꞌl chꞌoo ivatz; u tal bꞌey vaꞌl siꞌiqꞌon opon uchchil tu bꞌenqꞌii bꞌensaj utz, vaꞌl kaꞌxvaꞌl koꞌn aanima nichabꞌan. Okiꞌchꞌex tu u mam jankin okebꞌal, vaꞌl yak tu u choobꞌal paav. Tan nim ivatz u bꞌey yak tuul. Utz mamala tenam atoꞌk tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Kuentaꞌex tiꞌ qꞌu chulin alol tetz u yolbꞌal Tioxh qꞌuꞌl tul texoꞌl. Suula niman Tioxh tiloneꞌ, pek jolol eesanal tu bꞌey. Ech tuleꞌ maanxhola karneꞌl. Loqꞌ aatz tu taanima tan, echaꞌ vaꞌynajla lobo. ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","17","Pek loqꞌ nimnaꞌl tan, tu koꞌxh qꞌul ibꞌanoneꞌ toj etilva. Echaꞌ qꞌu bꞌaꞌnla chaj vatzomla tzeꞌ, bꞌaꞌn ivatz nitaqꞌeꞌ. Pek aatz qꞌu yeꞌxtxojla chaj vatzomla tzeꞌ, yeꞌxtxoj ivatz nitaqꞌeꞌ. Tan saꞌkojiꞌaneꞌ aas sachee uuva tiꞌ qꞌu chꞌiꞌx. Utz saꞌkojiꞌan majte sachee viikuxh tiꞌ u paal chꞌiꞌx. ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yeꞌxh bꞌoj siꞌaneꞌ aas yeꞌxtxoj ivatz u bꞌaꞌnla vatzomla tzeꞌ sataqꞌeꞌ. Utz yeꞌxh bꞌoj siꞌan majte aas bꞌaꞌn ivatz u yeꞌxtxojla vatzomla tzeꞌ sataqꞌeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tan aatz qꞌu vatzomla tzeꞌ qꞌuꞌl yitꞌ bꞌaꞌn koj ivatz nitaqꞌeꞌ, nitzokꞌax el. Utz nikꞌachax ok tu xamal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ech tokeꞌ tu koꞌxh qꞌul ibꞌanoneꞌ setilva oj chulin alol tetz u yolbꞌal Tioxh. Echaꞌ u tzeꞌ, nimnaꞌl tu vivatz bꞌaꞌn tzik oj yitꞌ bꞌaꞌn koj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Tan yitꞌ kajay koj qꞌuꞌl: «unBꞌaal, unBꞌaal,» chu ve, soꞌokoꞌp tu viQꞌesalail u Tioxh tu Amlika. Pek taꞌxh soꞌokoꞌp qꞌuꞌl nibꞌanon vitxumbꞌal vunTat tu Amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Utz sibꞌal koꞌxh toj alon ve tu maꞌl u qꞌii siꞌaneꞌ, ech tzaꞌ: «unBꞌaal, vetqal paal u yolbꞌal Tioxh tabꞌii. Vetqojcheꞌl qꞌu tioxhil txꞌiꞌliꞌinaj tabꞌii. Utz sibꞌ koꞌxh txaichil vetkubꞌan tu vabꞌii majte.» Chaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pek aatz in tan, sakoꞌnuntzaqꞌbꞌe ech tzaꞌ: «Tiira yeꞌ ootzajimalex vaqꞌo. Elojbꞌenex sunvatz aa paavla chaj aanima.» Chajin te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Uncheeꞌ abꞌil niabꞌin qꞌu yol nivaleꞌ tzaꞌ utz, niꞌaneꞌ kam nitaleꞌ, ela tuchꞌ u tzakꞌkin vinaj atziꞌ aas aꞌ taqꞌvu jeꞌ totzotz viꞌ sivan. ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ech kꞌuxh kuꞌ mam jabꞌal, yeꞌt kuꞌ taqꞌo. Utz kꞌuxh el nimaꞌ utz, ipaqꞌoꞌk tibꞌ mam kajiqꞌ tiꞌ, yeꞌt kuꞌi. Tan viꞌ sivan taqꞌvu jeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pek abꞌil paj vaꞌl niabꞌin qꞌul unyol tzaꞌ utz, yeꞌ niꞌaneꞌ kam nitaleꞌ, ela tuchꞌ u txoxkin vinaj atziꞌ vaꞌl vatz txꞌavaꞌ koꞌn iꞌanvu jeꞌ totzotz. ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ech aatz kuꞌ mam jabꞌal, el nimaꞌ utz, paal mam kajiqꞌ. Ipaqꞌoꞌk tibꞌ tiꞌ, yakich kuꞌoj taqꞌo. Ech bꞌoono isotz sotzi.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Uncheeꞌ aatz tek tzojpu u Jesuus tiꞌ talax kajay qꞌu yol tziꞌ, tiira vaꞌlich motx itzꞌejx ikꞌuꞌl qꞌu aanima tu vichusuneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Tan, atil tijleꞌm tu vichusuneꞌ. Txayoꞌm niꞌan tu qꞌul iyol. Yitꞌeꞌch koj aꞌ qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Uncheeꞌ kuꞌl u Jesuus viꞌ u muunte vaꞌl chusunka. Mam tenam xamich tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ech xaan opon maꞌl u chꞌaꞌkꞌiꞌ vinaj kꞌatza. Pecheꞌ kuꞌ siatz utz, tal te ech tzaꞌ: —UnBꞌaal, ¿yetz asaꞌ saꞌan bꞌaꞌn ve?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Aatz u Jesuus tan, iyuj bꞌen viqꞌabꞌ. Ikan u vinaj utz, tal te ech tzaꞌ: —Eeꞌ, sunsaꞌ. Bꞌan bꞌaꞌn.— Texh te. Ech tu koꞌxh unmuꞌkꞌul iꞌan bꞌaꞌn u vinaj tu u chꞌaꞌk tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Utz tal paj u Jesuus te ech tzaꞌ: —Abꞌi iileꞌ. Abꞌilich koꞌxh e aalvu u kam tziꞌ. Pek kuxh utz, kꞌuch tu u oksan yol vatz Tioxh aas bꞌaꞌntꞌaxh. Iqꞌo bꞌen u txakunsaꞌm tetz vatxꞌoloꞌm siatz. Ayaꞌ vaꞌl alelka tu u oꞌtla mantaar tu u Moisees. Ech satileꞌ aas bꞌaꞌntꞌaxh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Uncheeꞌ aatz opon u Jesuus tu vitenam Capernauum, ul maꞌl u capitaan siatz, qꞌesal sol tu Roma. Utz ijaj chit bꞌaꞌnil te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Tal te ech tzaꞌ: —UnBꞌaal, tiira yaꞌv maꞌl vatz vaqꞌonom. Atilka tu atibꞌal cheel. Numtzꞌinaj ichiꞌl utz, tiira tajinnaj tu u chiꞌom.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tal u Jesuus te ech tzaꞌ: —Sabꞌenin. Seꞌnunbꞌan bꞌaꞌn te.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tzaqꞌbꞌu u capitaan utz, tala: —UnBꞌaal, yeꞌ nikꞌuloꞌk viꞌ aas soꞌokoꞌpꞌaxh tu votzotz. Pek al koꞌn bꞌen aas siꞌan bꞌaꞌn utz, siꞌan bꞌaꞌn u vaqꞌonom. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tan echaꞌ in. Atilkoꞌnokꞌin jaqꞌ imantaar unqꞌesal. Utz atoꞌk sol jaqꞌ unmantaar majte. Utz nival tu maꞌj: «Kuxh tzaꞌ.» Chiꞌin te utz, nibꞌenaꞌ. «Niꞌaxh tzaꞌ.» Chiꞌin tu vaꞌtioj utz, nituleꞌ. Utz nival tu vaꞌt vaqꞌonom: «Bꞌan vaꞌl tzaꞌ.» Chiꞌin te utz, niꞌaneꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ech taꞌxh tabꞌi u yol u Jesuus tziꞌ, techal chit tabꞌi utz, yakich tzꞌejxoj ikꞌuꞌl taqꞌo. Tal tek tu qꞌu aanima qꞌuꞌl xamich tiꞌ ech tzaꞌ: —¡Niꞌxhtekꞌval sete, yeꞌsaj viltu maꞌj aanima Israeel, aas tiira kꞌujlel ikꞌuꞌl viꞌ echaꞌ u puera vinaj tziꞌ! ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Utz nival sete aas til koꞌxh sakꞌaskuꞌl puera aanima tikuenta aal telaꞌ utz, tikuenta aal tokeꞌ utz, samotxchꞌuxheꞌ kꞌatz u Abrahaam, kꞌatz u Isaac, tuchꞌ kꞌatz u Jacoob tu viQꞌesalail u Tioxh tu Amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pek aatz qꞌu Israeel qꞌuꞌl soꞌokoꞌp tu viQꞌesalail u Tioxh bꞌanel, sakoꞌnaqꞌaxka eloꞌp tu elqꞌej ech tziꞌ. Ech aꞌ soꞌoqꞌku tziꞌ. Utz aꞌ sajarachꞌunku tee tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ech aatz u Jesuus tan, tal tu u capitaan ech tzaꞌ: —Kuxh taatibꞌal. Tan kam chit echaꞌ vanimataꞌ tziꞌ, ech siꞌaneꞌ.— Texh te. Ech aatz u aqꞌonom, yakich koꞌxh iꞌan bꞌaꞌn aas iyolon u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Uncheeꞌ opon u Jesuus tu tatibꞌal u Luꞌ. Utz tila tzanlich vi-ixoj jiꞌ u Luꞌ vatz txꞌach. Tajinnajich tu xamal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ech kanax iqꞌabꞌ tu u Jesuus utz, yakich tzaaoj u xamal tiꞌ. Ech tek ilakpeꞌ utz, xeꞌt iꞌan techbꞌubꞌal u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Uncheeꞌ aatz tek sotzsaj, sibꞌal aanima iqꞌol ul vatz u Jesuus aas atich ok tioxhil txꞌiꞌliꞌinaj kꞌatza. Utz tu koꞌn qꞌul iyol nichtojcheꞌl qꞌu txꞌiꞌliꞌinaj. Utz iꞌan bꞌaꞌn tu kajay qꞌu yaꞌv majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Loqꞌ itzojpu chit u yol alichka tu u Isaias, u alol tetz u yolbꞌal Tioxh, aas tal ech tzaꞌ: —Aꞌ iqꞌon bꞌen kajay qꞌu kuyaabꞌil. Utz aꞌ u eesan tetz kajay qꞌu kuchiꞌom.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Uncheeꞌ aatz til u Jesuus aas mam tenam mulchich ok tiꞌ, tal tek ipaal bꞌen sala bꞌen u choo tu qꞌu chusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Pek tuul opon maꞌl u aa txumbꞌal tiꞌ u oꞌtla mantaar utz, tal te ech tzaꞌ: —Chusul saxambꞌin saiꞌ kꞌuxh til chit ech abꞌenaꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tal u Jesuus te ech tzaꞌ: —Aal atil ijul qꞌu yak, kolbꞌal tibꞌ sunvatz. Utz atil isok qꞌu tzꞌichin. Pek aatz u Kꞌaola vaꞌl bꞌennaj koꞌn aanima, yeꞌk tatibꞌal tinujul.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tal paj chit vaꞌt qꞌu niman tetz te ech tzaꞌ: —UnBꞌaal, saxambꞌin saiꞌ, pek analen lakam vuntat. Laꞌnalunmuj bꞌaxa.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tal tek u Jesuus te ech tzaꞌ: —Niꞌaxh viꞌ cheel. Tan aꞌ samujun qꞌu kamchil qꞌu aanima qꞌuꞌl kamnaj tatin vatz Tioxh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ech tokbꞌen u Jesuus tu u jukubꞌ, antu qꞌul ichusulibꞌ bꞌen tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Utz yeꞌk talcheꞌ, xeꞌt maꞌl u mam kajiqꞌ jabꞌal viꞌ u choo. Utz nichtekisotzka u jukubꞌ tu vipilqꞌaꞌtxan u choo tziꞌ. Loqꞌ vatchich koꞌn u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ech ex tek kꞌasaloj tu qꞌul ichusulibꞌ utz, tal te ech tzaꞌ: —¡KuBꞌaal, eesaꞌoꞌ vatz u tzaꞌl tzaꞌ tan, toj bꞌenojoꞌ tu aꞌ!— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Alax tek te tu u Jesuus ech tzaꞌ: —¿Kantuꞌ nexoꞌveꞌ? Tiira yeꞌ kꞌujlel ekꞌuꞌl viꞌ.— Texhtuꞌ. Ech lakpu u Jesuus; iyaa u mam kajiqꞌ tuchꞌ u choo. Utz yaꞌi. Vaꞌlich texh tachavan ikalkoch u aꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ech motx chit tzꞌejx ikꞌuꞌl qꞌu vinaj taqꞌo. Utz motx tal ech tzaꞌ: —¡Abꞌil tek u vinaj tziꞌ tan, aal nimali tu u kajiqꞌ jabꞌal tuchꞌ u choo tziꞌ!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Uncheeꞌ motx tek opon tunpaqꞌit itziꞌaj u choo, tikuenta u txꞌavaꞌ Gaadara. Utz ul kꞌulaxoj tu kaꞌvaꞌl qꞌu vinaj. Atoꞌk tioxhil txꞌiꞌliꞌinaj kꞌatza. Aꞌ motx kꞌaskuꞌl xoꞌl mujbꞌal kamnaj. Utz nojchit toxhqꞌebꞌal qꞌu vinaj tziꞌ. Abꞌil koj nichiqꞌiꞌ paalchil tu u bꞌey najaꞌch vaꞌl atichka. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ech motx qꞌeqꞌuni. Utz motx tala: —¿Kam asaꞌ qe, Jesuus iKꞌaol Tioxh? ¡Kꞌuxh ulyaxh tan, oꞌ ul uulebꞌeꞌoꞌ utz, yeꞌsaj topon kutiempo!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Uncheeꞌ tuul nichtechbꞌun unjolol qꞌu bꞌoch sinajaꞌch. Tiira sibꞌal ixaaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Utz aatz qꞌu tioxhil txꞌiꞌliꞌinaj tan, ijajabꞌe u Jesuus ech tzaꞌ: —Oj soojcheꞌloꞌ, aqꞌ tzii qe soꞌokꞌoꞌ kꞌatz kajay qꞌu bꞌoch tziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Alax te tu u Jesuus ech tzaꞌ: —¡Bꞌenojex!— Texh te. Ech motx telaꞌ utz, ok kꞌatz kajay qꞌu bꞌoch. Ech yeꞌk chit talcheꞌ, motx ex ikꞌon bꞌen tibꞌ qꞌu bꞌoch tziꞌ peepu, yakich tu u choo. Utz ech motx jiqꞌmu tu aꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ech aatz tek qꞌuꞌl nichmotxxeen qꞌu bꞌoch tziꞌ, motx tꞌaspi kꞌasuꞌl utz, ul tu tenam. Ech motx chit ul tal kajay qꞌu kam uchi tziꞌ. Utz tala kam vaꞌl iꞌan qꞌu vinaj qꞌuꞌl atich ok tioxhil txꞌiꞌliꞌinaj kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ech kajay qꞌu aanima tu tenam motx ul kꞌulun u Jesuus. Utz taꞌxh til u Jesuus, motx tal te aas saelbꞌen tikuenta qꞌul itxꞌavaꞌ tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Uncheeꞌ ech okbꞌen u Jesuus tu u jukubꞌ, iqꞌexpuka u choo. Opon tu vitenam Capernauum. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Pek aatz iꞌana, iqꞌol ul maꞌl u vinaj siatz numtzꞌinaj ichiꞌl. Chelemich topon tu chelebꞌ tetz. Ech til u Jesuus aas kꞌujlel ikꞌuꞌl qꞌu iqꞌon tetz tiꞌ ibꞌantu bꞌaꞌn u yaꞌv. Tal tek tu u numtzꞌinaj ech tzaꞌ: —Atoj nimal akꞌuꞌl bꞌaal. Tan kuyel qꞌul apaav kajayil.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ech aatz unjolol qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar qꞌuꞌl atich opon, taꞌxh tabꞌi vaꞌl tal u Jesuus tzaꞌ, nichtal tu taanima ech tzaꞌ: —Eesan iqꞌii Tioxh vaꞌl tziꞌ tan, nital ikuyax paav.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pek aatz u Jesuus tan, paal itxumbꞌal tuul kam vaꞌl nichmotxtitzꞌa qꞌu vinaj tziꞌ. Tal tek te ech tzaꞌ: —¿Kantuꞌ netitzꞌa onkonil viꞌ te etaanima? ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Abꞌiste tek u yol vaꞌl yitꞌ tzaꞌl koj alaxi uncheeꞌ; aꞌ tzik aꞌ vaꞌl: «Kuyel tek qꞌul apaav;» oj ayaꞌ vaꞌl: «Lakpen utz, xaan.» Chajin te? ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pek nojchit sunkꞌuch sevatz aas atil tijleꞌm u Kꞌaola vaꞌl bꞌennaj koꞌn aanima tiꞌ ikuyax paav tu vatz txꞌavaꞌ tzaꞌ.— Texh te. Ech tal tu u numtzꞌinaj ech tzaꞌ: —Lakpen. Iqꞌo bꞌen u chelebꞌ eetz utz, kuxh taatibꞌal.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ech ilakpu u numtzꞌinaj utz, bꞌen tu tatibꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Utz motx tzꞌejx ikꞌuꞌl qꞌu aanima aas til u kam tziꞌ. Utz nichtekmotxtoksa iqꞌii Tioxh tiꞌ. Tan atich tijleꞌm u Jesuus tiꞌ ibꞌanax bꞌaꞌn tu yaꞌv, kꞌuxh aanima koꞌn siatz. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Uncheeꞌ kꞌastekꞌul u Jesuus tziꞌ. Utz til maꞌl u vinaj, Tio ibꞌii. Kꞌujlich tu vaꞌl nijajlik jaꞌmel alkavaar. Tal u Jesuus te ech tzaꞌ: —Xambꞌen viꞌ.— Texh te. Ech lakpu u Tio utz, xambꞌu tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pek xamtel tekuꞌen aatz iꞌan u Jesuus tan, ex txꞌaꞌn tu atibꞌal xeꞌ u Tio. Utz motx opon sibꞌal qꞌu subꞌulla chaj jajol jaꞌmel alkavaar. Ant imol unjot qꞌu aa paavla chaj aanima. Utz motx kꞌujeꞌ vatz meexha kꞌatz u Jesuus utz, kꞌatz qꞌul ichusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ech taꞌxh til u kam qꞌu fariseo tziꞌ, motx tal tu qꞌu chusulibꞌ ech tzaꞌ: —¿Kam tokeꞌ bꞌatzꞌi aas ela nitxꞌaꞌn u chusul etetz tuchꞌ qꞌu subꞌulla chaj jajol jaꞌmel alkavaar utz, tuchꞌ qꞌu aa paavla chaj aanima tziꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ech taꞌxh tabꞌi u yol u Jesuus tziꞌ, tal ech tzaꞌ: —Aatz qꞌu tiichajla aanima, yeꞌxhkam nisavsa aa tzꞌak. Pek ech koj qꞌu yaꞌv tan, nisavsa aa tzꞌak. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Tan aꞌ koj ul unchok jikomla aanima. Pek aꞌ ul unchok aa paav sikꞌaxa ipaav. Echtzixeꞌt nival sete, aas bꞌenoj echꞌoti kam tokebꞌal u Yolbꞌal Tioxh vaꞌl nital ech tzaꞌ: «Aꞌ unsaꞌ setxum iatz emol utz, yitꞌ taꞌn koꞌnkoxh setitzꞌa ikꞌachax avan tetz txꞌoloꞌm.» Chia.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Uncheeꞌ ul qꞌul ichusulibꞌ u Xhan, u bꞌanol vautiismo kꞌatz u Jesuus utz, tal te ech tzaꞌ: —¿Kam tokeꞌ aas oꞌ koꞌxh tuchꞌ qꞌu fariseo tzukꞌel nikukuy kuvaꞌy tiꞌ iqꞌilal sikꞌlel Tioxh, pek aatz qꞌul achusulibꞌ tziꞌ, yeꞌxhkam nimotxikuy ivaꞌy?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Aatz u Jesuus tan, tal te ech tzaꞌ: —Yeꞌk siꞌaneꞌ aas sakoꞌxhtxumun qꞌu aanima qꞌuꞌl nisavsal tiꞌ tilax tzumbꞌaꞌa tuul atil u xiak tixoꞌl vaꞌl tzumeꞌya. Pek saꞌnalul tiempo aas saeesalbꞌenin xoꞌl qꞌul unchusulibꞌ. Ech analen tek samotxikuy ivaꞌy tiꞌ iqꞌilal sikꞌlel Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Aatz u bꞌaꞌnla chusbꞌal tan, saꞌkojikꞌul tibꞌ tuchꞌ vaꞌl ninalenima. Tan yeꞌkax bꞌanaxi aas sakꞌooal maꞌl qꞌaꞌl oksaꞌm tu akꞌ kꞌoo. Tan sakꞌolon u akꞌ kꞌoo atziꞌ utz, aal siyakꞌinsa u qꞌixiꞌl tiꞌ u oksaꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Echat majte yeꞌkax aqꞌax kuꞌ tu qꞌaꞌl tzꞌuꞌm u taꞌl uuva vaꞌl anal telaꞌ. Tan aatz u taꞌl uuva vaꞌl anal telaꞌ, sasipkꞌi utz, sikꞌux u qꞌaꞌl tzꞌuꞌm. Ech nipeqꞌxeꞌ. Ech nitel u qꞌaꞌl tzꞌuꞌm titxaꞌk. Pek aꞌ saꞌaqꞌaxku kuꞌ u taꞌl uuva vaꞌl anal telaꞌ tu akꞌ tzꞌuꞌm. Ech ela koꞌxh bꞌaꞌn saelka.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Tuul nichtal qꞌu kam u Jesuus tziꞌ utz, opon maꞌl u vinaj kꞌatza qꞌesala tatin xoꞌl qꞌu Israeel. Utz ex pecheꞌoj kuꞌ siatz. Tal ech tzaꞌ: —Maꞌxh kamyu maꞌl vatz unmeꞌal cheel tzaꞌ. Pek niꞌaxh. Tul aqꞌ jeꞌ vaqꞌabꞌ tibꞌa, ech saqꞌaavuꞌl taanima.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ech yakich xambꞌu bꞌen u Jesuus tuchꞌ qꞌul ichusulibꞌ tiꞌ u vinaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ech tuul atich ok u Jesuus tiꞌ bꞌey, xaan opon maꞌl u ixoj tiꞌ iqul. Yaꞌvich. Kaj nichtel kꞌatza. Kabꞌlaalich yaꞌbꞌ ixeꞌt viyaabꞌil. Utz ikanoꞌk ijuꞌ u toksaꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tan nichnaltal u ixoj tu taanima ech tzaꞌ: —Kꞌuxh taꞌxh sunkanoꞌk ijuꞌ u toksaꞌm, saꞌxhunbꞌan bꞌaꞌn atziꞌ.— Texhich. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Pek aatz u Jesuus tan, ipilqꞌu tibꞌ utz, tal te ech tzaꞌ: —Yeꞌ koꞌxh qeonaxh, txutx. Tan tiꞌ vikꞌujeꞌ akꞌuꞌl viꞌ kꞌuxh vetaꞌanlu bꞌaꞌn.— Texh te. Ech yakich iꞌan bꞌaꞌn u ixoj tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ech taꞌxh opon u Jesuus tu atibꞌal xeꞌ u qꞌesala vaꞌl kam imeꞌal, til qꞌu xulin aa utz, til qꞌu aanima vaꞌlich motx iqꞌeqꞌelkabꞌin tu oqꞌel. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Utz tal tek te ech tzaꞌ: —¡Elojuꞌlex! Tan yitꞌ kamnaj koj u ixviak atziꞌ, pek vatchel kuꞌen.— Texhtuꞌ. Loqꞌ nichkoꞌnibꞌanbꞌel u Jesuus tiꞌ vaꞌl tala. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ech ipaasa eluꞌl qꞌu aanima u Jesuus qꞌanal utz, okoꞌp toꞌotzotz. Utz itxay iqꞌabꞌ u ixviak; ech ilakpeꞌ. Qꞌaavuꞌl taanima taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ech aatz viyolil u txaichil tziꞌ, pax chit paal itziiul tikuenta kajay u txꞌavaꞌ tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Uncheeꞌ aatz tek kꞌasuꞌl u Jesuus latziꞌ, xambꞌoꞌk kaꞌvaꞌl qꞌu moy tiꞌ. Utz nichiqꞌeqꞌun taltu ech tzaꞌ: —¡Ituꞌxh ixalam Daviid, txum kuvatz!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ech taꞌxh opon tu atibꞌal, opon qꞌu moy tzixeꞌ utz, tal u Jesuus te ech tzaꞌ: —¿Ni tzik enima aas soꞌoleꞌin tiꞌ esajinsaleꞌ?— Texh te. Tzaqꞌbꞌu qꞌu moy tal ech tzaꞌ: —¡Eeꞌ nikunima kuBꞌaal!— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ech aatz u Jesuus tan, ikan qꞌu bꞌaqꞌ iatz utz, tal te ech tzaꞌ: —Tiꞌ vikꞌujeꞌ ekꞌuꞌl viꞌ sebꞌan bꞌaꞌn.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Utz ech yakich sajinoj qꞌu vinaj tziꞌ. Utz tiira alax te tu u Jesuus bꞌaꞌnil ech tzaꞌ: —Abꞌitaj bꞌaꞌnil. Yeꞌxhabꞌil koꞌxh soꞌootzajin u kam tziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pek taꞌxh motx kꞌasuꞌl qꞌu vinaj tziꞌ, xeꞌt ipaxsa itziiul tu jankꞌal u txꞌavaꞌ kam vaꞌl iꞌan u Jesuus te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Uncheeꞌ tuul koꞌxh nichipaal eluꞌl qꞌu moy, aꞌ tek iqꞌol opon vaꞌt u mem vatz u Jesuus. Atich ok tioxhil txꞌiꞌliꞌinaj kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ojchal el u tioxhil txꞌiꞌliꞌinaj kꞌatza tu u Jesuus utz, yolon tek u mem. Ech tiira sotz ikꞌuꞌl qꞌu aanima taqꞌo. Motx tek tal ech tzaꞌ: —¡Yeꞌkax tek qil kam tu kuxoꞌl oꞌ Israeel tzaꞌ aas echaꞌ tziꞌ!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pek aatz qꞌu fariseo nichtal ech tzaꞌ: —Viqꞌesal qꞌu txꞌiꞌliꞌinaj nilochon tiꞌ tojchal el qꞌu tioxhil txꞌiꞌliꞌinaj atziꞌ.— Texh tiꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Uncheeꞌ nichipaal u Jesuus tu qꞌu nimaj tenam tuchꞌ tu qꞌu talaj tenam. Aꞌ nichichus u bꞌaꞌnla chusbꞌal tu qꞌu atibꞌal chusbꞌal tetz u oꞌtla mantaar. Nichipaxsa itziiul u bꞌaꞌnla chusbꞌal majte tetz viQꞌesalail u Tioxh. Utz nichibꞌan bꞌaꞌn tu kajay qꞌuꞌl atil yaabꞌil kꞌatza. Nichteesa qꞌu chiꞌom kꞌatz aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ech txumun u Jesuus aas til u mam tenam tan, yeꞌk iqꞌesal sateesa bꞌey siatz. Echaꞌ karneꞌl yeꞌk xeen tetz, paximal koꞌxh tibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ech tal tek tu qꞌul ichusulibꞌ ech tzaꞌ: —Nojchit tiira sibꞌalen qꞌu aanima niyaꞌta Tioxh tziꞌ, pek bꞌiil koꞌxh qꞌu paxsan tetz u yolbꞌal Tioxh tixoꞌl. Ela tuchꞌ triigo aas qꞌanbꞌia utz, bꞌiil koꞌxh chokol tetz atoꞌk. ");
INSERT INTO ixlCNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Echtzixeꞌt jajtaj tu u Tioxh, aas satoksa tereꞌn paxsan tetz viyolbꞌal tixoꞌl. Ech siꞌaneꞌ vaꞌl niꞌan u bꞌaal triigo aas nitoksa tereꞌn taqꞌonom tiꞌ imolax vivatz vichikobꞌeꞌm.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Uncheeꞌ aatz u Jesuus, isikꞌle opon kabꞌlaal qꞌul ichusulibꞌ kꞌatza. Utz taqꞌ tijleꞌm tiꞌ tojchal el qꞌu tioxhil txꞌiꞌliꞌinaj kꞌatz aanima utz, tiꞌ ibꞌanax bꞌaꞌn tu qꞌu aanima majte, kꞌuxh kam koꞌn chiꞌomil nichbꞌanon. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ech vibꞌii kabꞌlaal qꞌu chusulibꞌ ichaja tzaꞌ. Aatz vibꞌaxa utz, Xhim; Luꞌ chu teꞌl majte. Ant imol u Lixh, vitzaꞌqꞌ. Antu u Jacobo, tuchꞌ u Xhan, vitzaꞌqꞌ, qꞌul ikꞌaol u Zebedeo. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Antu u Felipe, u Bartolomee, u Maxh, u Tio vaꞌl jajolich jaꞌmel alkavaar, u Jacobo, vikꞌaol u Alfeo. Antu u Tadeo. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ant aꞌ u Xhim vaꞌl atich ok xoꞌl qꞌu cananista, tuchꞌ u Judas aa Cariote, vaꞌl kꞌayin u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Aꞌ kabꞌlaal qꞌuꞌl ichaj bꞌen u Jesuus tziꞌ. Utz ibꞌan bꞌen talax te ech tzaꞌ: —Bꞌeniꞌchꞌex titenam qꞌu puera aanima. Utz okichꞌopꞌex titenam qꞌu aa Samaaria majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Pek aꞌ seꞌenkꞌex xeꞌ qꞌu qetz aa tenamil Israeel, ayaꞌ qꞌuꞌl tzꞌejxinaj echaꞌ itzꞌejxuka karneꞌl tiꞌ xeen tetz. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ech til chit sapaalkꞌex, paxsataj talax itziiul ech tzaꞌ: «Najabꞌyu tul viQꞌesalail u Tioxh tu Amlika texoꞌl.» Chajex. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Bꞌantaj bꞌaꞌn tu qꞌu yaꞌv. Bꞌantaj bꞌaꞌn tu qꞌuꞌl atil chꞌaꞌk tiꞌ. Qꞌaavixsataj ul taanima kamnaj. Utz ojchataj el tioxhil txꞌiꞌliꞌinaj. Oya ikꞌulax u bꞌaꞌnil vetebꞌana utz, oya u bꞌaꞌnil sebꞌan majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Etiqꞌoch bꞌen puaj. Nikoꞌxh bꞌaꞌnla qꞌan chꞌichꞌ, bꞌaꞌnla saj chꞌichꞌ utz, nikoꞌxh nojla qꞌan chꞌichꞌ setiqꞌo tu qꞌu kolbꞌal epuaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Utz etiqꞌoch bꞌen etxim, iqꞌobꞌ etechbꞌubꞌal tetz ebꞌey. Nikoꞌxh untzumt etoksaꞌm. Nikoꞌxh untzumt exaabꞌ. Utz yeꞌk setiqꞌo ebꞌaara. Tan aatz u aqꞌonom, aꞌ satxꞌaꞌnku tiꞌ u taqꞌon. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Pek aatz loꞌoponex tu maꞌl nimla tenam, oj tu tal tenam, letabꞌi inujul abꞌil maꞌj aanima aas bꞌaꞌn talcheꞌ. Utz aꞌ laꞌatinkꞌex tzixeꞌ. Analen leꞌelkꞌasuꞌlex tu u atibꞌal aas lakꞌasuꞌlex. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Utz aatz loꞌoponex tu maꞌj atibꞌal, letal ichajlichil qꞌu bꞌaal atibꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ech oj ayaꞌl ikꞌuꞌl likꞌulex, saꞌatin u paas tzixeꞌ vaꞌl setal tiꞌ. Pek oj yeꞌ lajeꞌ ikꞌuꞌl, saqꞌaavkꞌasuꞌl u paas setiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Utz oj abꞌil maꞌj yeꞌ lakꞌulunex utz, yeꞌ likꞌulviꞌex tiꞌ qꞌul eyol, kꞌasojulex tu u atibꞌal tziꞌ. Utz elojkꞌasuꞌlex tu u tenam tziꞌ. Eesatajka qꞌu pojoj tiꞌ etajan, techlal aas lakoꞌntila. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tan niꞌxhtekꞌval sete, aatz luꞌul u qꞌii vaꞌl satxꞌolax inujul qꞌu aanima, paalchu u choobꞌal paav sakuꞌ tiꞌ u tenam tziꞌ, vatz u qelolla tenam Sodoma tuchꞌ u qelolla tenam Gomorra oꞌtla yol. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Aatz cheel, aꞌ nunchajvubꞌenex xoꞌl chiꞌkꞌulan etetz. Ech echajaxeꞌ ichajax bꞌen karneꞌl xoꞌl lobo. Ech tokeꞌ kuentaꞌex sebꞌaneꞌ. Echaꞌ u txꞌiꞌla txokop aas telabꞌal elchil. Utz bꞌantaj ex maanxho, echaꞌ paroomaxh majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Utz kuentaꞌex tiꞌ qꞌu aanima tan, saꞌnaliꞌaneꞌ aas satiqꞌooponex tu qꞌatbꞌal tzii. Utz satzꞌuꞌmalex taqꞌo tu qꞌu atibꞌal chusbꞌal tetz u oꞌtla mantaar. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Viꞌ kuꞌen kꞌuxh saxochaxex; siꞌiqꞌoloponex vatz governadoor utz, tuchꞌ vatz ijlenal. Ech laveetetaltu u bꞌaꞌnla chusbꞌal vatz qꞌu puera aanima tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pek aatz latxaypꞌex, elaꞌokiꞌch koꞌxh etaanima tiꞌ aas kam setaleꞌ. Tan tuul txayelex, saꞌalax eyol kam setaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tan ex tereꞌn koj vaꞌl sayolonex, pek u Tioxhla Espiiritu tetz u kuTat sayolon tetziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Toj nal iꞌaneꞌ aas siyatzꞌ tibꞌ aanima itzaꞌqꞌ tibꞌ. Utz ech siꞌan u tat majte, siyatzꞌ jeꞌ ikꞌaol. Utz aatz qꞌu kꞌaol meꞌala, salakpu kꞌatz qꞌul itxutx ibꞌaal utz, siyatzꞌeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Utz saꞌnalchiꞌkꞌulalex tiꞌ vunnimaleꞌ. Pek abꞌil vaꞌl yeꞌxh saqeoni, saꞌnalitzojpixsa, aꞌ vaꞌl soꞌopon tu u bꞌenqꞌii bꞌensaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Utz aatz laojchalex tu maꞌl tenam, oojojkoꞌnbꞌenex tu vaꞌte. Tan niꞌxhtekꞌval sete aas yeꞌsaj koꞌxh etzojp eloꞌp tiꞌ talax u yolbꞌal Tioxh tu qꞌu tenam tikuenta Israeel aas luꞌul u Kꞌaola vaꞌl bꞌennaj koꞌn aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Yitꞌ paalnaj koj tijleꞌm u chusulibꞌ vatz u chusul tetz. Utz yitꞌ paalnaj koj tijleꞌm u aqꞌonom vatz u bꞌaal taqꞌon. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Pek sakoꞌniqꞌiꞌ qꞌu chusulibꞌ kam saꞌalax tiꞌ, echaꞌ nitalax tiꞌ u chusul tetz. Utz echat koꞌxh u aqꞌonom tuchꞌ u bꞌaal taqꞌon. Tan oj “qꞌesal txꞌiꞌliꞌinaj” chu teꞌl u Tata, aꞌ chixh qꞌu kꞌaol meꞌala yeꞌ saꞌalax tiꞌ majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Pek yeꞌ koꞌxh qeonex. Tan yeꞌk maꞌj kam sajutzil ibꞌanaxeꞌ yeꞌ koj saeluꞌl itziiul. Utz yeꞌk maꞌj mujich kam yeꞌ koj saꞌabꞌili. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ech kam vaꞌl sete koꞌxh nunchusva, altaj eloꞌp itziiul vatzsaj. Utz qetumal talax viꞌaj otzotz qꞌu yol sebꞌaneꞌ qꞌuꞌl tiira ex koꞌxh vetabꞌin. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Utz yeꞌ koꞌxh xoꞌvex tu qꞌu aanima qꞌuꞌl yatzꞌol koꞌn tetz u chiꞌl tan, tech koj tiꞌ iyatzꞌax u aanxel. Pek aꞌ sexoꞌva u Tioxh vaꞌl soꞌoleꞌ tiꞌ iyatzꞌpu u chiꞌl utz, soꞌoleꞌ tiꞌ taqꞌax bꞌen u aanxel tu u xamal u choobꞌal paav. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Tan echaꞌ qꞌu talaj tzꞌichin, kꞌuxh tiira yeꞌk ijaꞌmel, kaꞌvaꞌl koꞌn tiꞌ maꞌl sentaavo, sakoꞌnkoxhkam maꞌj oj yitꞌ u kuTat koj saꞌaqꞌon tzii tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Yeꞌ koꞌxh xoꞌvex tan, aal tootzajle u kuTat jatvaꞌl tachul qꞌu xiꞌl kuviꞌ tziꞌ. Tootzajle ekolcheꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Yeꞌ koꞌxh xoꞌvex tan, paalch ejaꞌmel vatz sibꞌal talaj tzꞌichin. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Aatz qꞌuꞌl yeꞌk sachꞌixvu tiꞌ talax untziiul vatz qꞌu aanima, saꞌkojchꞌixveꞌlin tiꞌ vatz vunTat tu Amlika majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pek aatz qꞌuꞌl sateesa tibꞌ tuul vatz aanima aas tootzajin, sakoꞌnveesa vibꞌ tuul aas vootzajle, vatz vunTat tu Amlika majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yeꞌ koꞌxh etitzꞌa aas taꞌxh ul voksa paas tu u vatz amlika txꞌavaꞌ tzaꞌ. ¡Yeꞌka! ¡Yitꞌ taꞌn koꞌn koj! Pek soꞌok chꞌaꞌo majte; loqꞌ viꞌ kuꞌen. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tan aatz qꞌuꞌl sanimanin, soꞌok ixoꞌl tuchꞌ qꞌuꞌl yeꞌ sanimanin. Soꞌok ixoꞌl u kꞌaola tuchꞌ u tata. Soꞌok ixoꞌl u itzꞌina ixviak tuchꞌ vinan utz, u alibꞌa tuchꞌ vitxutx. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tan aatz vikoontra u aanima vaꞌl sanimanin, aꞌ sacheek jeꞌ tu tatibꞌal xoꞌl qꞌu titzꞌin tatzik qꞌuꞌl yeꞌ sanimanin. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Pek abꞌil vaꞌl tiira taꞌxh tii tiꞌ itat inan vatz vitzꞌejtu taanima viꞌ, yeꞌ nikꞌuloꞌk tiꞌ aas soꞌok viꞌ. Abꞌil vaꞌl tiira taꞌxh tii tiꞌ ikꞌaol imeꞌal vatz vitzꞌejtu taanima viꞌ, yeꞌ nikꞌuloꞌk tiꞌ aas soꞌok viꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Abꞌil qꞌuꞌl yeꞌ siqꞌiꞌ paalchil tu mam il tzaꞌl viꞌ utz, yeꞌk siqꞌiꞌ paalchil tu qꞌul unpaalebꞌal, yeꞌ nikꞌuloꞌk tiꞌ aas soꞌok viꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Abꞌil qꞌuꞌl taꞌxh nititzꞌa u vatz iqꞌii isaj tu u vatz txꞌavaꞌ tzaꞌ utz, yeꞌk siqꞌiꞌ kamchil viꞌ, sitzꞌej u atinchil tu bꞌenqꞌii bꞌensaj. Pek abꞌil qꞌuꞌl liqꞌiꞌ kamchil viꞌ, aꞌ qꞌuꞌl saꞌatin tu u bꞌenqꞌii bꞌensaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Abꞌil qꞌuꞌl sakꞌulunex, in aꞌ nikꞌulin tziꞌ. Utz aatz qꞌuꞌl nikꞌulunin, nikꞌul u Tioxh majte atziꞌ vaꞌl vetchajonulin. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Abꞌil qꞌuꞌl sakꞌulun qꞌu paxsan tetz u yolbꞌal Tioxh, ela koꞌn ichoobꞌal sikꞌul tuchꞌ qꞌu paxsan tetz u yolbꞌal Tioxh. Echat majte abꞌil sakꞌulun maꞌj qꞌu jikomla aanima, ela koꞌn ichoobꞌal sikꞌul tuchꞌ siꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Utz abꞌil qꞌuꞌl kꞌuxh maꞌj koꞌxh vaaso chiꞌul aꞌ lataqꞌ tu maꞌj qꞌu chꞌooal niman vetz, niꞌxhtekꞌval sete aas saꞌkojyaꞌtziꞌ ikꞌult ichoobꞌal tan, niman vetz vaꞌl vettaqꞌ taaꞌ.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Utz taꞌxh yaꞌ u Jesuus, tiꞌ ibꞌantu bꞌen talax qꞌu kam tu kabꞌlaal qꞌul ichusulibꞌ tziꞌ, elbꞌen tu vaꞌl atichka. Ex chusun tunjot tenam. Utz nichipaxsa talax u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Uncheeꞌ atich okoꞌp u Xhan tu tzeꞌ. Tabꞌi itziiul kam qꞌuꞌl nichiꞌan viTxaaom u Tioxh. Ech ichajtu bꞌen kaꞌvaꞌl qꞌul ichusulibꞌ tzixeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Utz ul ichꞌoti te ech tzaꞌ: —¿Axh tzik viTxaaom u Tioxh vaꞌl sauli? ¿Oj sakuchꞌia vaꞌte?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Bꞌenoj etal tu u Xhan kam qꞌuꞌl netileꞌ netabꞌi tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Tan nitekisajin qꞌu moy. Nitekixaan qꞌu koꞌx. Nitekiꞌan bꞌaꞌn qꞌu chꞌaꞌkꞌiꞌ. Nitektabꞌin qꞌu chakan. Nitekqꞌaavtitzꞌpixsal kamnaj. Utz nitektabꞌil u bꞌaꞌnla chusbꞌal tu qꞌu meꞌbꞌaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ech chiꞌbꞌebꞌal tetz qꞌu aanima qꞌuꞌl yeꞌ nikaꞌtziiun viꞌ.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Uncheeꞌ tuul koꞌxh nichtelbꞌen qꞌul ichusulibꞌ u Xhan, xeꞌt iyolon u Jesuus tiꞌ u Xhan tu qꞌu aanima ech tzaꞌ: —¿Kam bꞌanel titxumbꞌal u vinaj vaꞌl ex etil tu tzꞌinlich tzaji txꞌavaꞌ bꞌatzꞌi? ¿Ech tzik aꞌ maꞌj aa aas vaꞌl koꞌxh ibꞌen sunchaj jalil tu kajiqꞌ? Yeꞌka. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Pek ¿kam ex etileꞌ? ¿Aꞌ tzik ex etil maꞌj vinaj aas toksaꞌm ijlenal atoꞌk taqꞌo? Yeꞌka. Tan aatz qꞌuꞌl bꞌaꞌnla chaj oksaꞌm atoꞌk taqꞌo, ayeꞌn tu qꞌu tatibꞌal ijlenal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Loqꞌ ¿kam ex etileꞌ? ¿Maꞌj tzik alol tetz u yolbꞌal Tioxh? Bꞌaꞌntan aꞌ i. Utz nival sete aas nim tatin vatz tereꞌn qꞌu alol tetz u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tan aꞌ vaꞌl tzꞌibꞌamalka tiꞌ tu u Yolbꞌal Tioxh ech tzaꞌ: «Sunbꞌaxabꞌsa bꞌen vunchaj saatz. Aꞌ sapaxsan itziiul val ooponbꞌal. Echaꞌ ibꞌanax tuch bꞌey saatz siꞌaneꞌ. Chu u Tioxh.» Texh u alol tetz u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ech niꞌxhtekꞌval sete aas yeꞌxhabꞌil koꞌxh vaꞌtoj paalchu tijleꞌm viꞌ u Xhan, u bꞌanol vautiismo xoꞌl kajay qꞌu aanima qꞌuꞌl alamal. Pek loqꞌ kꞌuxh echi, aatz qꞌuꞌl chꞌoo koꞌn u tijleꞌm tu viQꞌesalail u Tioxh tu Amlika, paalchu tijleꞌm viꞌ u Xhan. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ayaꞌxchen tuich ikuenta u Xhan, u bꞌanol vautiismo utz, ulyu koꞌxh tzaꞌ tuul, atil unjolol aanima nichij viQꞌesalail u Tioxh tu Amlika. Nimaj ipax paal. Loqꞌ tech koj tiꞌ. Pek abꞌil qꞌuꞌl tiira niꞌan yaꞌl tibꞌ tiꞌ tok tu viQꞌesalail u Tioxh, aꞌ qꞌuꞌl nitokeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tan kajay qꞌu alol tetz u yolbꞌal Tioxh tuchꞌ u oꞌtla mantaar, aꞌ niyolonku tiꞌ viQꞌesalail u Tioxh, ulyu koꞌxh tikuenta u Xhan. Tan aꞌ u yaꞌtebꞌal alol tetz u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Utz oj sesaꞌa, nimataj kam nitaleꞌ tan, aatz u Xhan, echaꞌ u Elias atziꞌ, vaꞌl saꞌnalchituli alaxnaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Abꞌiste ex niabꞌin qꞌu yol tzaꞌ, nimataj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Kam bꞌoj ela tuchꞌ qꞌu qelolla chaj aanima tu u tiempo tzaꞌ? Ela tuchꞌ qꞌu talaj nitxaꞌ atziꞌ aas nisaach tu kꞌayibꞌal, utz niqetunsa bꞌen talax timol ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","«Vetkuxuli aa utz, yeꞌn bꞌixex, yeꞌn chiꞌbꞌex qiꞌ. Vetbꞌitzꞌoꞌ echaꞌ ibꞌitzal kamnaj utz, yeꞌn oqꞌex tu txumuꞌm.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Tan aatz iꞌan u Xhan, u bꞌanol vautiismo, yeꞌt txꞌaꞌni utz, yeꞌt tukꞌa taꞌl uuva. Utz: «Tioxhil txꞌiꞌliꞌinaj atil kꞌatza.» Chu teꞌleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Pek aatz u Kꞌaola vaꞌl bꞌennaj koꞌn aanima, vaꞌl itxꞌaꞌneꞌ utz, nitukꞌa taꞌl uuva. Utz netal viꞌ ech tzaꞌ: «Ulyu maꞌl u vinaj yeꞌk chit iyaꞌebꞌal tu echbꞌuꞌm, tu ukꞌa taꞌl uuva. Nimolo tibꞌ tuchꞌ aa paav, tuchꞌ subꞌulla chaj jajol jaꞌmel alkavaar.» Cheꞌex viꞌ. Loqꞌ aatz vitxumbꞌal u Tioxh, aꞌ niilchik tu vibꞌanon qꞌul ikꞌaol imeꞌal Tioxh.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Uncheeꞌ sibꞌ txaichil iꞌan u Jesuus tu unjolol tenam, loqꞌ yeꞌ nichmotxikꞌaxa qꞌul ipaav qꞌu aanima tziꞌ. Ech xeꞌt tek tal tzꞌejbꞌal yol u Jesuus tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Utz tal tiꞌ ech tzaꞌ: —¡Tilayol sayaꞌkꞌex aa Coraziin, tuchꞌ ex aa Betsaida! Tan yeꞌ nenima qꞌu mamaj txaichil unbꞌan texoꞌl. Pek xoꞌl koj qꞌu aa paavla chaj puera aanima aa Tiro tuchꞌ qꞌu aa paavla chaj puera aanima aa Sidoon unbꞌanva, oora koꞌxh motx ikꞌaxa qꞌul ipaav koj atziꞌ. Utz motx toksa oksaꞌm techlal txumuꞌm. Utz imakꞌ jeꞌ tzaꞌa tiviꞌ tiꞌ qꞌul ipaav koj atziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ech tok nival sete, aatz luꞌul u qꞌii vaꞌl satxꞌolax inujul qꞌu aanima, paalchu u choobꞌal paav sakuꞌ setiꞌ vatz qꞌu aa Tiro tuchꞌ qꞌu aa Sidoon. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Utz echat ex majte aa Capernauum. Kamal netaleꞌ aas saꞌxhtꞌanbꞌaꞌlex. ¡Yeꞌxhjatu! Pek bꞌoono ebꞌajax kuꞌl sabꞌanli; ech sabꞌenex tu choobꞌal paav. Tan aꞌ koj vetuchku qꞌu mamaj txaichil tixoꞌl qꞌu aa Sodoma tziꞌ, echaꞌ qꞌuꞌl vetunbꞌan texoꞌl, motx ikꞌaxa qꞌul ipaav koj atziꞌ. Utz ankoꞌxh atil tu u tiempo cheel koj tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ech tok nival sete, aatz luꞌul u qꞌii vaꞌl satxꞌolax inujul qꞌu aanima, paalchu u choobꞌal paav sakuꞌ setiꞌ vatz qꞌu aa Sodoma tziꞌ.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Uncheeꞌ aatz iꞌan tu u qꞌii tziꞌ, iqꞌila sikꞌle Tioxh u Jesuus utz, tal ech tzaꞌ: —Nivaqꞌ taꞌntioxh see Tat. Axh iBꞌaal u Amlika txꞌavaꞌ tziꞌ. Tan vetakꞌuch vatxumbꞌal tu qꞌuꞌl yeꞌk tootzajibꞌal, qꞌuꞌl echaꞌ talaj nitxaꞌ. Utz yeꞌn akꞌuch tu qꞌuꞌl nitoksa iqꞌii tiꞌ qꞌul itxumbꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aꞌi, Tat. Tan ech vasaꞌ tziꞌ.— Texh u Jesuus tu viqꞌilat u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tal paj u Jesuus ech tzaꞌ: —Kajay qꞌu kam vettoksal vunTat tunqꞌabꞌ. Utz abꞌil koj maꞌj tekꞌ ootzajin tetz viKꞌaol u Tioxh tuchꞌ itxumbꞌal, pek taꞌxh u kuTat. Utz abꞌil koj ootzajin tetz u kuTat, pek taꞌxh u Kꞌaola. Utz antu saootzajin majte qꞌuꞌl u Kꞌaola saꞌaqꞌon eluꞌl te vatzsaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ech tokeꞌ ulojex sunkꞌatza kajay ex ijtzinajex utz, jochpinajex jaqꞌ vepaav tan, in sailansanex. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Oksataj etibꞌ jaqꞌ vunmantaar. Utz iltaj ok etetz viꞌ tan, in maanxho. Utz jik u vaanima. Ech sailan vetaanxelal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tan yitꞌ tzaꞌl koj iqꞌol vunmantaar. Utz yitꞌ tii koj nimali.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Uncheeꞌ aatz iꞌan tu maꞌl u ilanbꞌal qꞌii, paal u Jesuus tuchꞌ qꞌul ichusulibꞌ xoꞌl unjolol qꞌu chikobꞌeꞌm. Utz nichikam qꞌu chusulibꞌ tu vaꞌy. Ech motx itxꞌup vatz triigo utz, techbꞌu. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pek taꞌxh ilax tu qꞌu fariseo, tal tek tu u Jesuus ech tzaꞌ: —Yitꞌ bꞌaꞌn koj bꞌanax tu u ilanbꞌal qꞌii vaꞌl niꞌan qꞌuꞌl achusulibꞌ tziꞌ. Aꞌ niqel u kukostuumbre tzꞌibꞌamal tiꞌ u ilanbꞌal qꞌii.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tal tek u Jesuus te ech tzaꞌ: —¿Yetz sikꞌlemal setaqꞌo kam vaꞌl iꞌan u Daviid tuchꞌ qꞌuꞌl xamich tiꞌ aas kam tu vaꞌy? ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tan motx okoꞌp tu u totztioxh utz, motx itxꞌaꞌ tetz u txaaꞌla kaxhlaan txꞌix tetz Tioxh vaꞌl yitꞌ aqꞌich koj tzii aas abꞌil koꞌxh satxꞌaꞌon. Nikoꞌxh u Daviid tuchꞌ qꞌul imol aqꞌelku tzii. Pek taꞌxh aqꞌelku tzii tu qꞌu oksan yol vatz Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Utz ¿yetz sikꞌlemal setaqꞌo tu u oꞌtla mantaar majte, aas yitꞌ aa paav koj qꞌu oksan yol kꞌuxh nitaqꞌonin tu ilanbꞌal qꞌii tu viqꞌanalil u totztioxh? ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ech nival sete aas paalchu tijleꞌm vatz u totztioxh vaꞌl atil tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Utz yeꞌ nekan tokebꞌal u Yolbꞌal Tioxh vaꞌl nital ech tzaꞌ: «Aꞌ unsaꞌ setxum iatz emol; yitꞌ taꞌn koꞌnkoxh setitzꞌa ikꞌachax ok avan tu txꞌoloꞌm.» Chia. Tan sakoꞌnkoxhekꞌon paav tiꞌ bꞌaꞌnla aanima koj atziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tan aatz u Kꞌaola vaꞌl bꞌennaj koꞌn aanima, aa yol tiꞌ u ilanbꞌal qꞌii.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Uncheeꞌ aatz tek kꞌasuꞌl u Jesuus latziꞌ, bꞌenoꞌk tu maꞌl u atibꞌal chusbꞌal tetz u oꞌtla mantaar. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Utz atich maꞌl u vinaj tziꞌ aas yeꞌ nichiyikun unpaqꞌil iqꞌabꞌ. Ech aatz qꞌu fariseo, vet sikꞌuꞌl ichꞌoti tu u Jesuus ech tzaꞌ: —¿Bꞌaꞌn tzik vatz u kukostuumbre tzꞌibꞌamal aas sabꞌanax bꞌaꞌn tu qꞌu yaꞌv tu u ilanbꞌal qꞌii?— Texh te. Tan aꞌ isaꞌ ixochtu u Jesuus tiꞌ vaꞌl sataleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Pek alax te tu u Jesuus ech tzaꞌ: —Abꞌiste koj maꞌj sabꞌanon sete aas yitꞌ oora seꞌntiqꞌo jeꞌul maꞌl vikarneꞌl vaꞌl taꞌxh maꞌl, oj sachajpu bꞌen tu jul tu u ilanbꞌal qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Utz aal sibꞌ paalchu u aanima vatz maꞌl karneꞌl. Echtzixeꞌt bꞌaꞌn sabꞌanax bꞌaꞌn tu maꞌl aanima kꞌuxh tu u ilanbꞌal qꞌii.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ech tal tek u Jesuus tu u yaꞌv ech tzaꞌ: —Yuj vaqꞌabꞌ tziꞌ.— Texh te. Iyuj viqꞌabꞌ u vinaj utz, yakich iꞌan bꞌaꞌn. Ela texh kaak tuchꞌ vaꞌt viqꞌabꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pek motx kꞌasuꞌl qꞌu fariseo. Utz motx ex inukꞌeꞌ kaniꞌch ixochax u Jesuus siꞌaneꞌ; satal ikameꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Pek tabꞌi u Jesuus. Ech eltekbꞌen tu vaꞌl atichka. Utz mam tenam xambꞌu bꞌen tiꞌ. Utz iꞌan bꞌaꞌn tu kajay qꞌu yaꞌv. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Loqꞌ tiira nichtal tu qꞌu aanima bꞌaꞌnil aas yeꞌk sataqꞌ eluꞌl itziiul. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tan ech chit itzojpu u yol alelka tu u Isaias, u alol tetz u yolbꞌal Tioxh aas tal ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Aꞌ u bꞌanol tetz vuntxumbꞌal tzaꞌ, vunTxaaom. Tiiꞌin tiꞌ. Utz kꞌujlebꞌal unkꞌuꞌl. Savoksa vunTioxhla Espiiritu kꞌatza, ech satal vinujul tu kajay qꞌu tenam tzꞌejxinaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Yitꞌ sakoꞌnkoxhiyaa yoli tibꞌ. Yitꞌ sakoꞌnkoxhqꞌeqꞌuni utz, yitꞌ sakoꞌnkoxhtxabꞌaꞌpun tu bꞌey. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Aal koj sateesa ikꞌuꞌl u paxaꞌl aa utz, aal koj sitzaasa u xamal vaꞌl bꞌiit koꞌxh nitel isibꞌel. Pek aal saꞌnalpaal tetz vinujul taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Utz aꞌ sakꞌujeꞌk ikꞌuꞌl kajay qꞌu puera tenam tiꞌ siꞌaneꞌ.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Uncheeꞌ iqꞌol opon maꞌl u vinaj vatz u Jesuus. Moyich utz, memich majte. Atich ok tioxhil txꞌiꞌliꞌinaj kꞌatza. Utz bꞌanax bꞌaꞌn te tu u Jesuus. Ilon tek u vinaj utz, yolon tek majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ech kajay qꞌu aanima motx tzꞌejx ikꞌuꞌl tiꞌ vaꞌl iꞌan u Jesuus. Utz nichtekmotxtal ech tzaꞌ: —¡Kamal aꞌ vituꞌxh ixalam u Daviid vaꞌl saꞌchituli!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pek aatz qꞌu fariseo, taꞌxh motx tabꞌi u yol tziꞌ, motx tal ech tzaꞌ: —¡Aꞌ koj tziꞌ! Tan u Belzebuu, u qꞌesal tioxhil txꞌiꞌliꞌinaj niaqꞌon tijleꞌm tiꞌ tojchal el tioxhil txꞌiꞌliꞌinaj.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","26","Pek aatz u Jesuus tan, paal itxumbꞌal tu qꞌuꞌl nichtitzꞌa utz, tal tek te ech tzaꞌ: —¿Kaniꞌch bꞌoj tatin viqꞌesalail u txꞌiꞌliꞌinaj tinujul oj atoꞌk ixoꞌl tibꞌilaj? Saꞌkojveet iqꞌesalaineꞌ oj jatxel tibꞌ iatz. Echat koꞌxhtuꞌ aꞌ maꞌj ijlenal majte. Oj jatxel tibꞌ iatz tuchꞌ qꞌul imol tu viqꞌesalail, sakoꞌnjinkꞌi. Utz ech pajeꞌ aꞌ maꞌj tenam, oj untanoj itzꞌin atzik tu maꞌl atibꞌal, jatxel tibꞌ iatz, saꞌkojveet iꞌantu maꞌl iatz. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Utz oj u qꞌesal tioxhil txꞌiꞌliꞌinaj niaqꞌon vijleꞌm tiꞌ tojchal el qꞌu tioxhil txꞌiꞌliꞌinaj netaleꞌ, ¡kamal aꞌ paj niaqꞌon tijleꞌm qꞌu aanima qꞌuꞌl nechus tiꞌ tojchal el majte uncheeꞌ! Aꞌ tek samotxalon sete atziꞌ, abꞌil niaqꞌon vijleꞌm, u Tioxh tzik oj viqꞌesal qꞌu tioxhil txꞌiꞌliꞌinaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pek oj u Tioxhla Espiiritu niaqꞌon vijleꞌm, nojchit aꞌ u techlal aas ulyu viQꞌesalail u Tioxh texoꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Tan echaꞌ tziꞌ, abꞌil koj saveet tokoꞌp toꞌotzotz xeꞌ maꞌl aanima aa yakꞌil oj yitꞌ bꞌaxal koj siqitzeꞌ. Pek bꞌaxal siqitzeꞌ, ech soꞌoleꞌ tiꞌ ijolonsal bꞌen qꞌu tetz. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Pek abꞌiste yitꞌ oknaj koj viꞌ, nikoontrain atziꞌ. Utz abꞌiste vaꞌl yeꞌxhkam nitoksa vetz, tzꞌejoꞌm niꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ech tokeꞌ nival sete, kajay qꞌu paav sakuyli utz, kajay qꞌu yoqꞌoꞌmla yol nital qꞌu aanima, sakuyli. Pek abꞌil sayoqꞌon saqelon u Tioxhla Espiiritu, yeꞌxhjatu sakuyaxi. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Aal sakuyli abꞌil qꞌuꞌl sayoqꞌon u Kꞌaola vaꞌl bꞌennaj koꞌn aanima. Pek ech koj qꞌuꞌl sayoqꞌon saqelon u Tioxhla Espiiritu, yeꞌxhjatu sakuyli. Nikoꞌxh tu u vatz amlika txꞌavaꞌ tzaꞌ; nikoꞌxh tu vaꞌt u atinchil. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","34","¡Txꞌiꞌla chaj aanima! ¡Kaniꞌch bꞌoj etaltu bꞌaꞌnla chaj yol nenacheꞌ tan, jolol ex onkon! Kam qꞌuꞌl atil xeꞌ taanima u aanima, aꞌ vaꞌl nijeꞌul titziꞌ. Pek bꞌantaj u bꞌaꞌnil, ech sekꞌucheꞌ ex bꞌaꞌn. Echaꞌ u bꞌaꞌnla tzeꞌ, bꞌaꞌn ivatz nitaqꞌeꞌ. Utz aatz u yeꞌxtxojla tzeꞌ, yeꞌxtxoj ivatz nitaqꞌeꞌ. Tan aꞌ niꞌilchik u tzeꞌ tu vivatz; bꞌaꞌn tzik oj yeꞌxtxoj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tan aatz u bꞌaꞌnla aanima, aꞌ nikꞌuchvu u bꞌaꞌnil vaꞌl atil xeꞌ taanima tu viyoloneꞌ. Pek ech koj u onkonla aanima, aꞌ nikꞌuchvu tu viyolon majte aas onkonil atil xeꞌ taanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ech tok nival sete, saꞌnaltxꞌolch inujul qꞌu aanima tiꞌ kajay qꞌu yol qꞌuꞌl yeꞌk koꞌxh tokebꞌal nimotxtaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tan tu koꞌn qꞌul eyoloneꞌ satxꞌolax enujul; oj bꞌaꞌn, sabꞌenex tu u bꞌaꞌnil; oj yeꞌxtxoj, sabꞌenex tu choobꞌal paav majte.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Uncheeꞌ aatz unjolol qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar, ant imol unjolol fariseo, tal tu u Jesuus ech tzaꞌ: —Chusul, kꞌuch maꞌj xheenya kuvatz oj nojchit axh iTxaaom Tioxh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —¡Aatz ex itzꞌlelex tu u tiempo tzaꞌ, jolol ex qelolla chaj aanima! Ex aa paav utz, nejaj xheenya aas sakꞌuchax sete netaleꞌ. Pek ¡yeꞌka! Taꞌxh maꞌl xheenya setootzaji, vaꞌl tiꞌ u Jonaas, u alol tetz u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tan echaꞌ vaꞌl iꞌan u Jonaas aas oxvaꞌl qꞌii tuchꞌ oxvaꞌt aqꞌbꞌal iꞌan tu tuul u mam txay, echat koꞌxh siꞌan u Kꞌaola vaꞌl bꞌennaj koꞌn aanima majte. Oxvaꞌl qꞌii tuchꞌ oxvaꞌt aqꞌbꞌal siꞌan jaqꞌ txꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Aatz qꞌu aa Niinive, toj nal tal ebꞌen tu choobꞌal paav, ex itzꞌlelex tu u tiempo tzaꞌ aas latxꞌolax inujul qꞌu aanima; tan, motx ikꞌaxa qꞌul ipaav tu u yolbꞌal Tioxh vaꞌl ex tal u Jonaas tixoꞌl. Pek aatz ex, yeꞌ nekꞌaxa qꞌul epaav tiꞌ qꞌul iyol vaꞌl paalchu tijleꞌm viꞌ u Jonaas. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Echat maꞌl u ixoj ijlenal majte, toj nal tal ebꞌen tu choobꞌal paav, ex itzꞌlelex tu u tiempo tzaꞌ. Tan yaꞌviloꞌm kꞌaskuꞌl tikuenta aal ikuꞌeꞌ tiꞌ ul tabꞌil vimam txumbꞌal u Salomoon. Pek paalchu tijleꞌm viꞌ u Salomoon vaꞌl atil tzaꞌ cheel utz, yeꞌ nenima. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Aatz nitel u tioxhil txꞌiꞌliꞌinaj kꞌatz maꞌl aanima, nipaal tu tzaji txꞌavaꞌ nichok tilanbꞌal. Loqꞌ yeꞌ nichabꞌa. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ech nitektal ech tzaꞌ: «Saqꞌaavbꞌenin tu u vatibꞌal vaꞌl vetkꞌaskuꞌlin.» Chia. Ech aatz nitopon tu u tatibꞌal, tiira bꞌaꞌnla tek amel, chꞌisel utz, vijel majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Uncheeꞌ ech nitiqꞌo opon jujvaꞌt imol, aas maas aqꞌel tek iviꞌ siiꞌ. Utz ech taꞌn aꞌ oponya. Aꞌ tek nimotxatinku tziꞌ. Ech aal maas tek sael u aanima tu bꞌey tziꞌ vaꞌl atoꞌk qꞌu tioxhil txꞌiꞌliꞌinaj kꞌatza, vatzich u tatin bꞌaxa yol. Uncheeꞌ ¡echat koꞌxh vaꞌl sebꞌaneꞌ jankꞌil ex, ex onkonla chaj aanima itzꞌlelex tu u tiempo tzaꞌ!— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Uncheeꞌ tuul ankoꞌxh nichiyolon u Jesuus tu qꞌu tenam, opon vinan tuchꞌ qꞌul itzaꞌqꞌ. Aꞌ isaꞌ siꞌchyolon tuchꞌ u Jesuus. Utz yeꞌt veet tokoꞌp kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ech alax tek tu u Jesuus ech tzaꞌ: —Nisavsaꞌaxh vanan tuchꞌ qꞌul atzaꞌqꞌ. Aꞌ isaꞌ sayolonaxh tuchꞌ chi.— Texh teꞌleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pek itzaqꞌbꞌe koꞌn vaꞌl alon te utz, tal te ech tzaꞌ: —¿Abꞌil unnan naaleꞌ? Utz ¿abꞌil qꞌul untzaꞌqꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ech ikꞌuchtu bꞌen qꞌul ichusulibꞌ tiqꞌabꞌ utz, tal tiꞌ ech tzaꞌ: —Aꞌ vunnan tzuta. Utz aꞌ qꞌul untzaꞌqꞌ tzuyi. ");
INSERT INTO ixlCNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tan aatz kajay qꞌuꞌl nibꞌanon vitxumbꞌal vunTat tu Amlika, aꞌ qꞌuꞌl untzaꞌqꞌ atziꞌ; aꞌ vanabꞌ atziꞌ utz; aꞌ vunnan atziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Uncheeꞌ aatz iꞌan u Jesuus tu u qꞌii tziꞌ, elkꞌasuꞌl tu u atibꞌal. Utz ex kꞌujeꞌoj tziꞌ choo. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mam tenam chit imol tibꞌ kꞌatza. Ech jeꞌtekꞌop u Jesuus tu maꞌl u jukubꞌ. Kꞌujeꞌ tuul utz, xeꞌt ichusuneꞌ, tuul aatz qꞌu aanima tan, atich koꞌn tziꞌ aꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ech sibꞌ koꞌxh yol tal u Jesuus. Nichikꞌam tiꞌ kam ech tzaꞌ: —Aatz iꞌan maꞌl u chikol, bꞌen tu chikoꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Utz tuul nichimakꞌ paal u ia, atia aꞌ kuꞌk tu bꞌey. Utz motx koꞌn ex tzotiloj tu qꞌu tzꞌichin. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Atia aꞌ kuꞌk viꞌaj sivan aas bꞌiil koꞌxh txꞌavaꞌ atil siiꞌ. Utz oora itzꞌpu u ia tan, xax koꞌn u txꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pek tzꞌaꞌbꞌ u qꞌii. Lumin tu vitzꞌaꞌl utz, tzaji. Tan bꞌiil koꞌn bꞌennaj u taqꞌil. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Utz at u ia, aꞌ kuꞌk xoꞌl chꞌiꞌx. Pek chꞌii qꞌu chꞌiꞌx utz, isotzsa. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pek aatz untante, aꞌ kuꞌk tu bꞌaꞌnla txꞌavaꞌ. Utz ech vatzini. Atia 100 ivatz taqꞌ tiꞌ junun tajan. Atia 60 ivatz taqꞌa. Utz atia 30 ivatz taqꞌ majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Abꞌiste ex niabꞌin qꞌu yol tzaꞌ, nimataj.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Uncheeꞌ xaan tek opon qꞌu chusulibꞌ kꞌatz u Jesuus utz, tal tek te ech tzaꞌ: —¿Kam tokeꞌ aꞌ nakꞌam tiꞌ kam aas nayolon tu qꞌu aanima tziꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ech itzaqꞌbꞌe utz, tal te ech tzaꞌ: —Bꞌaꞌn ex tan, aqꞌel tzii, sete aas setootzaji u tokebꞌal qꞌu kam qꞌuꞌl yeꞌ ootzajimal tokebꞌal tiꞌ viQꞌesalail u Tioxh tu Amlika. Pek ech koj qꞌu aanima tziꞌ, saꞌkojtootzaji u tokebꞌal tan, yeꞌ aqꞌel te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tan abꞌiste vaꞌl atil nal itxumbꞌal tiꞌ qꞌu kam qꞌuꞌl yeꞌ ootzajimal tokebꞌal, aal saꞌaqꞌax tereꞌn tetz. Ech sibꞌal tek itxumbꞌal saꞌatini. Pek abꞌiste vaꞌl yeꞌk maas itxumbꞌal tiꞌ, aal samaaleꞌl te jankꞌal vatz tetz aqꞌel. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Tu kꞌamich kam nunyolonku te tan, nisajineꞌ tiloneꞌ, loqꞌ yeꞌxhat niꞌenku te. Kꞌuxh nitabꞌineꞌ, nikojikan tabꞌil tokebꞌal qꞌu kam. Utz nikojipaal itxumbꞌal tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tan ech chit itzojpu vaꞌl bꞌaxabꞌsamal talax tu u Isaias aas tal ech tzaꞌ: «Aatz qꞌu aanima tziꞌ, saꞌmotxabꞌin tuchꞌ ixichin, loqꞌ saꞌkojpaal itxumbꞌal tu vaꞌl satabꞌi. Utz samotxsajini, loqꞌ saꞌkojikan tilaxeꞌ kam vaꞌl sisaji. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tan tiibꞌinaj taanima qꞌu tenam tziꞌ. Yeꞌ nimotxisaꞌa tabꞌileꞌ kam tokebꞌal qꞌu yol. Yeꞌ nimotxisaꞌa tilax qꞌu kam ijikomal. Ech tokeꞌ yeꞌ samotxilon tuchꞌ bꞌaqꞌ iatz. Yeꞌ samotxabꞌin tuchꞌ ixichin. Utz nikoꞌxh satootzaji u tokebꞌal qꞌu kam tuchꞌ taanima. Ech yeꞌk saqꞌaavoꞌk sunkꞌatza. Utz yiꞌsaꞌ sunbꞌan bꞌaꞌn te majte.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pek aatz ex, chiꞌbꞌebꞌal etetz tan, netil inujul qꞌu kam tuchꞌ bꞌaqꞌ evatz. Utz nekan tabꞌil tokebꞌal tuchꞌ exichin. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tan niꞌxhtekꞌval sete, sibꞌal koꞌxh qꞌu alol tetz u yolbꞌal Tioxh motx tachva tilaxeꞌ kam vaꞌl netil cheel. Pek yeꞌt tila. Utz motx tachva tabꞌileꞌ kam vaꞌl netabꞌi cheel. Pek yeꞌt motx tabꞌi. Echat qꞌu jikomla chaj aanima majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Pek abꞌitaj uncheeꞌ kam u tokebꞌal u yol tiꞌ u chikol. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Aatz u aanima vaꞌl niabꞌin qꞌu yol tiꞌ viQꞌesalail u Tioxh utz, yeꞌ nipaal itxumbꞌal tuul, aꞌ nikꞌam tiꞌ u ia vaꞌl aꞌ kuꞌk tu bꞌey. Tan nikoꞌnulsotzsaloj u yolbꞌal Tioxh tu taanima tu u txꞌiꞌliꞌinaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Atil aanima nitabꞌi u yolbꞌal Tioxh utz, kaana itxuqꞌtxun tiꞌ bꞌaxa aas nikꞌuleꞌ. Ech aꞌ nikꞌam tiꞌ u ia vaꞌl aꞌ kuꞌk viꞌaj sivan, aas bꞌiil koꞌxh txꞌavaꞌ siiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pek yeꞌ bꞌennaj taqꞌil. Bꞌiil koꞌn niꞌanoꞌk. Tan echaꞌ tziꞌ, nitul maꞌj tzaꞌlla kam tiꞌ utz, nixeꞌkꞌulal tiꞌ u yolbꞌal Tioxh majte, sibꞌ niꞌenku te. Utz yeꞌ koꞌxh tiil ikuꞌeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Pek atil aanima nitabꞌi u yolbꞌal Tioxh, loqꞌ nikoꞌnisotz bꞌen sikꞌuꞌl tu qꞌu elaꞌokchil tiꞌ vimeꞌbꞌiꞌl tu u vatz amlika txꞌavaꞌ tzaꞌ. Aꞌ nikꞌam tiꞌ u ia vaꞌl aꞌ kuꞌk xoꞌl chꞌiꞌx. Ech yeꞌxhkam nivatzin taqꞌo. Utz nisotz bꞌen sikꞌuꞌl tiꞌ tachvaloꞌk qꞌu txꞌiibꞌal qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pek ech koj vaꞌl aꞌ kuꞌk tu bꞌaꞌnla txꞌavaꞌ, aꞌ nikꞌam tiꞌ u aanima vaꞌl niabꞌin u yolbꞌal Tioxh utz, nipaal itxumbꞌal tuul. Echaꞌ u ia aas nivatzineꞌ. Atia 100 ivatz nitaqꞌeꞌ. Atia 60 ivatz nitaqꞌeꞌ. Utz 30 ivatz nitaqꞌ majte.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Tal paj chit vaꞌt kꞌamich kam u Jesuus tu qꞌu aanima ech tzaꞌ: —Aatz viQꞌesalail u Tioxh tu Amlika, ela tuchꞌ maꞌl u vinaj vaꞌl ichik bꞌaꞌnla ia triigo titxꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pek aatz tu aqꞌbꞌal, tuul vatchel qꞌu aanima, ul vikoontra, ul ichikka yeꞌxtxojla ia xoꞌl u triigo. Utz bꞌeni. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ech jeꞌul u triigo, chꞌii. Utz vatzini. Loqꞌ chee u yeꞌxtxojla xajtzeꞌ tixoꞌl majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ech aatz qꞌu aqꞌonom tan, motx tek ex tal tu u bꞌaal chikobꞌeꞌm ech tzaꞌ: «Bꞌaal nitxaꞌ, tiira bꞌaꞌnla ia vaꞌl vetachik tu vatxꞌavaꞌ. Pek ¿til chaj unjalkꞌik u yeꞌxtxojla xajtzeꞌ tziꞌ?» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tzaqꞌbꞌu u bꞌaal chikobꞌeꞌm ech tzaꞌ: «Maꞌl u koontra vetexchikonka atziꞌ.» Texhtuꞌ. Tal qꞌu aqꞌonom te ech tzaꞌ: «Pek ¿satz asaꞌa seꞌnkubꞌuqꞌeꞌl tixoꞌl uncheeꞌ?» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Tal u bꞌaal chikobꞌeꞌm ech tzaꞌ: «Yeꞌka. Tan bꞌaꞌn siꞌaneꞌ aas tuul nebꞌuqꞌeꞌl u yeꞌxtxojla xajtzeꞌ, sabꞌuqꞌxu kꞌasuꞌl triigo tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pek aꞌ liꞌilon, chꞌiiojna sijununil utz, qꞌanbꞌunale. Ech saval tu qꞌu chokol tetz tu u tiempo tziꞌ: Moltaj qꞌu yeꞌxtxojla chaj xajtzeꞌ bꞌaxal tziꞌ. Utz tiꞌ bꞌoꞌkꞌol iqitzax sebꞌaneꞌ. Ech satzꞌeꞌi. Pek ech koj u triigo tan, aꞌ semolvu tu kolbꞌal tetz. Chajin te.» Chu u bꞌaal chikobꞌeꞌm tu qꞌu taqꞌonom.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Aatz u Jesuus, ikꞌam paj tiꞌ vaꞌt kam utz, tal ech tzaꞌ: —Aatz viQꞌesalail u Tioxh tu Amlika, ela tuchꞌ maꞌl u bꞌaqꞌ muxhtaansa ichik maꞌl u vinaj titxꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tan aꞌ u ia vaꞌl nojchit tiira tal chꞌoo vatz tereꞌn qꞌu tiil itza. Pek paalchu ichꞌii viꞌ tereꞌn qꞌu itza niꞌaneꞌ. Aatz nichꞌiieꞌ utz, nibꞌens nimla tzeꞌ. Aal nitekꞌuliꞌan isok qꞌu tzꞌichin viꞌaj qꞌul iqꞌabꞌ.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Aatz u Jesuus, ikꞌam paj tiꞌ vaꞌt kam ech tzaꞌ: —Aatz viQꞌesalail u Tioxh tu Amlika, ela tuchꞌ u txꞌamil kaxhlaan txꞌix vaꞌl taqꞌ bꞌen maꞌl u ixoj xoꞌl oxvaꞌl paabꞌal ariina. Utz ech itxꞌamtu kajay viqꞌotiil u kaxhlaan txꞌix taqꞌo.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Aatz kajay qꞌu yol tal u Jesuus tu qꞌu aanima, aꞌ ikꞌam tiꞌ kam. Utz yeꞌxhkam nichiyoloneꞌ untzꞌoj yeꞌ nichikꞌam tiꞌ kam. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ech chit itzojpu u yol alichnalka tu u alol tetz u yolbꞌal Tioxh aas tal ech tzaꞌ: —Sayolonin utz, kam koꞌn sunkꞌam tiꞌ. Ech saval eluꞌl inujul qꞌu kam qꞌuꞌl yeꞌ ootzajimal u tokebꞌal xeꞌ qꞌii xeꞌ saj.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Uncheeꞌ ijatx tek tibꞌ u Jesuus tuchꞌ qꞌu aanima. Ech bꞌenoꞌk u Jesuus tu atibꞌal. Utz xaan opon qꞌu chusulibꞌ kꞌatza, tal te ech tzaꞌ: —Bꞌan talax qe bꞌaꞌnil kam tokebꞌal u yeꞌxtxojla xajtzeꞌ vetakꞌam tiꞌ aas chee xoꞌl u chikobꞌeꞌm.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Aatz vaꞌl chikon u bꞌaꞌnla ia, ayaꞌ u Kꞌaola vaꞌl bꞌennaj koꞌn aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Aatz u txꞌavaꞌ, ayaꞌ u vatz amlika txꞌavaꞌ. Aatz u bꞌaꞌnla ia, ayaꞌ qꞌuꞌl oknaj tek tu viQꞌesalail u Tioxh. Utz aatz u yeꞌxtxojla ia, ayaꞌ qꞌu aanima qꞌu niman tetz u txꞌiꞌliꞌinaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Aatz u koontra vaꞌl chikon, ayaꞌ u txꞌiꞌliꞌinaj. Aatz u tiempo tzokꞌbꞌal tetz utz, ayaꞌ u motxebꞌal qꞌii saj siꞌaneꞌ. Utz aatz qꞌu molol tetz, ayaꞌ qꞌu aanjel. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kam chit ech vitzokꞌax el qꞌu yeꞌxtxojla xajtzeꞌ tziꞌ utz, nikꞌachax ok tu xamal, ech sabꞌanax tu qꞌu aanima tu u motxebꞌal qꞌii saj siꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Tan aatz u Kꞌaola vaꞌl bꞌennaj koꞌn aanima, sichaj kꞌasuꞌl qꞌul iaanjel utz, suꞌlteesa tu u vatz txꞌavaꞌ tzaꞌ jankꞌal qꞌu aanima oknaj tu viQꞌesalail qꞌuꞌl nitaqꞌ bꞌen imol tu paav utz, tuchꞌ qꞌu bꞌanol tetz onkonil. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ech sikꞌon bꞌen tu u mam xamal. Ayaꞌ u choobꞌal paav, paalchu viꞌ oorno. Ech latziꞌ samotxoqꞌka utz, aꞌ sajarachꞌunku tee tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pek aatz qꞌu jikomla aanima, qꞌu niman tetz u Tioxh tan, samotxribꞌuni. Echaꞌ iribꞌun qꞌii siꞌan tu viQꞌesalail u kuTat. Ech nimanoj, abꞌil nikanon tabꞌil tokebꞌal qꞌu kam tzaꞌ.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Tal paj u Jesuus ech tzaꞌ: —Aatz viQꞌesalail u Tioxh tu Amlika, ela tuchꞌ maꞌl sivan sibꞌ ijaꞌmel aas mujel tatin tu maꞌj txꞌavaꞌ. Utz aatz nichabꞌal tu maꞌl u aanima, nikoꞌnpajqꞌaavimujka. Utz kaana itxuqꞌtxun tiꞌ. Ech tek neꞌnikꞌayika kajay qꞌu tetz. Utz niloqꞌ u txꞌavaꞌ tziꞌ. Ech satetzi u txꞌiibꞌal qꞌii vaꞌl mujel tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Aatz paj viQꞌesalail u Tioxh tu Amlika, echaꞌ maꞌl lakol. Aꞌ nichok bꞌaꞌnla chaj perla. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Utz aatz nichabꞌa maꞌl u techalla perla sibꞌ ijaꞌmel, nitekenikꞌayika kajay qꞌu tetz atile utz, niloqꞌeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Aatz paj viQꞌesalail u Tioxh tu Amlika majte echaꞌ maꞌl mam kꞌach, eesabꞌ txay, aas nikꞌonax okoꞌp tu choo. Jatvatzul koꞌn iatz txay nitok tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Utz aatz maꞌt inoo u kꞌach tziꞌ, nitektiqꞌol eluꞌl tu eesan tetz tziꞌ aꞌ. Ech nitxaa qꞌu bꞌaꞌnla chaj txay utz, nitaqꞌ kuꞌ tu txakatx. Pek aatz qꞌuꞌl yeꞌxtxoj, nikꞌoneꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Echat chit vaꞌl suꞌuch majte aas luꞌul u motxebꞌal qꞌii saj. Saul qꞌu aanjel, sateesa qꞌu aa paavla chaj aanima xoꞌl qꞌu jikomla chaj aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ech sikꞌon bꞌen tu u mam xamal. Ayaꞌ u choobꞌal paav paalchu viꞌ xamal tu oorno. Utz latziꞌ samotxoqꞌka utz, aꞌ sajarachꞌunku tee tziꞌ.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tal paj u Jesuus ech tzaꞌ: —¿Matz paal etxumbꞌal tu qꞌu kam nivaleꞌ tzaꞌ?— Texhtuꞌ. Tzaqꞌbꞌu qꞌu aanima utz, motx tala: —Eeꞌ, vetia.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tal paj u Jesuus: —Aatz kajay qꞌu aa txumbꞌal tetz u oꞌtla mantaar qꞌuꞌl oknaj tiꞌ u bꞌaꞌnla chusbꞌal utz, chusel tibꞌ tiꞌ, tootzaj u oꞌtla mantaar tuchꞌ u akꞌ bꞌaꞌnla chusbꞌal. Ela tuchꞌ maꞌl u tata atziꞌ vaꞌl nitiqꞌo jeꞌul akꞌ kam utz, oꞌtla kam tu kolbꞌal txꞌiibꞌal iqꞌii.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Uncheeꞌ taꞌxh veet iyolon u Jesuus tiꞌ qꞌu kam ikꞌam tiꞌ, eltekbꞌen tu vaꞌl atichka. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ech ul tu vitenam. Xeꞌt ichus qꞌu aanima tu atibꞌal chusbꞌal tetz u oꞌtla mantaar. Utz nichitzꞌejx ikꞌuꞌl qꞌu aanima taqꞌo. Nichmotxtal ech tzaꞌ: —¿Til tek nicheek u mam itxumbꞌal atziꞌ? Utz ¿kam tek ech iveet qꞌu mamaj txaichil niꞌaneꞌ atziꞌ? ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Yitꞌ tzik aꞌ vikꞌaol u kꞌoxol tziꞌ? ¿Yitꞌ tzik Liꞌ ibꞌii vinan? Tan aꞌ vitzaꞌqꞌ u Jacobo atziꞌ, u Xhep, u Xhim tuchꞌ u Judas. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Utz aal jejlel qꞌu tanabꞌ tzaꞌ atziꞌ. Pek ¿til tek nicheek kajay qꞌu kam sikꞌuꞌl atziꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ech nichtekmotxteesa iqꞌii tiꞌ. Pek tal tek u Jesuus te ech tzaꞌ: —Aatz qꞌu alol tetz u yolbꞌal Tioxh, taꞌxh yeꞌ oknajk iqꞌii titenam tuchꞌ xoꞌl titzꞌin tatzik.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ech bꞌiil koꞌxh txaichil iꞌan u Jesuus tziꞌ tan, yeꞌt nimal tu qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Uncheeꞌ aatz u Herodes, u governadoor tikuenta Galilea, tabꞌi itziiul tok iqꞌii u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Utz tal tu qꞌu taqꞌonom ech tzaꞌ: —U Xhan aꞌ qꞌaav itzꞌpi xoꞌl qꞌu kamnaj tziꞌ, ayaꞌ u bꞌanol vautiismo. Echtzixeꞌt atil mam tijleꞌm tiꞌ ibꞌanax txaichil.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tan aatz u Herodes, aꞌ alon itxaypu u Xhan. Tal iqitzpu tu kadeena utz, taqꞌ kuꞌ tu tzeꞌ tiꞌ koꞌn u Herodias, u tixojich u Felipe vitzaꞌqꞌ u Herodes tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Tan nichtal u Xhan te ech tzaꞌ: —Yitꞌ bꞌaꞌn koj vaꞌl naꞌaneꞌ aas iqꞌomal u tixoj vatzaꞌqꞌ saaqꞌo tziꞌ.— Texhich te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ech nichiꞌan ikꞌuꞌl u Herodes tiꞌ u Xhan. Pek nichixoꞌva qꞌu tenam tan, nimamich taqꞌo aas alol tetz u yolbꞌal Tioxh tixoꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pek aatz iꞌana, paal iqꞌii tzꞌajebꞌal iyaꞌbꞌ u Herodes. Bꞌix u titzꞌin u Herodias tu xoꞌl. Ech txꞌanel chit til u Herodes. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Utz ech tala aas sataqꞌ kajay qꞌu kam sijaj u ixviak te. Toksa ibꞌii qꞌul itioxh tuul aas sataqꞌeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Pek aatz u ixviak, chajtziꞌl tu vinan bꞌaxa. Ech tek tal te ech tzaꞌ: —Aqꞌ viviꞌ u Xhan ve tu maꞌl puraato cheel tzaꞌ, u bꞌanol vautiismo.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ech txumun chit u Herodes tiꞌ vaꞌl jajax te. Pek inima. Tal tek taqꞌax viviꞌ u Xhan tu u ixviak, tiꞌ tan, vatz qꞌul imol tal u kam tziꞌ, qꞌuꞌl atich ok vatz meexha tuchꞌ utz, tiꞌ majte tan, toksa ibꞌii qꞌul itioxh tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ech tal ikutil el viviꞌ u Xhan aas atich kuꞌ tu tzeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Utz iqꞌol ul viviꞌ u Xhan tu maꞌl puraato. Ech aqꞌax tu u ixviak. Utz aatz u ixviak, ex taqꞌ tu vinan. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Uncheeꞌ motx tek opon qꞌul ichusulibꞌ u Xhan. Ex tiqꞌo vinimal utz, imuja. Ech tek motx ex tal itziiul tu u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Uncheeꞌ aatz tabꞌi itziiul u kam u Jesuus tziꞌ, eltekbꞌen tu vaꞌl atichka. Okbꞌen tu maꞌl u jukubꞌ sijunal utz, ex tu maꞌl u tzꞌinlich txꞌavaꞌ xaannaj el. Pek tabꞌi qꞌu aanima aas til maꞌtka. Motx bꞌen tu tajan. Ex ikꞌuleꞌ. Aꞌ elkubꞌen tu qꞌu tenam tziꞌ aꞌ utz, ex ikꞌul sala bꞌen aꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ech el u Jesuus tu jukubꞌ. Til qꞌu mam tenam utz, itxum iatz. Ech ibꞌan bꞌaꞌn tu qꞌu yaꞌv atich tixoꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tuul tek tiira maꞌtich ikuꞌ qꞌii, xaan opon qꞌul ichusulibꞌ kꞌatza utz, tal te ech tzaꞌ: —Maꞌxh kuꞌy qꞌii. Utz yeꞌxhkam bꞌoj sachee tu vaꞌl atilkꞌoꞌ tzaꞌ. Pek chaj bꞌen qꞌu tenam tziꞌ. Samotxeniloqꞌ techbꞌubꞌal xeꞌ qꞌu aanima jejlel tu qꞌu jaꞌjtzeꞌ tziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Pek alax te tu u Jesuus ech tzaꞌ: —Yitꞌ ministeer koj samotxbꞌeni atziꞌ. Aqꞌtaj techbꞌubꞌal tzexeꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Motx tal ech tzaꞌ: —Yeꞌxhjankꞌal echbꞌubꞌal atil quxeꞌ. Taꞌxh atil oꞌvaꞌl kaxhlaan txꞌix tuchꞌ kaꞌvaꞌt txay.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Tal u Jesuus te: —Aqꞌtaj ul tzaꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ech talt ichꞌuxheꞌ qꞌu aanima viꞌ chꞌim. Utz itxay oꞌvaꞌl u kaxhlaan txꞌix tiqꞌabꞌ tuchꞌ kaꞌvaꞌt u txay. Ech sajin jeꞌ tu amlika. Ijaj bꞌaꞌnil tiꞌ utz, ipixh qꞌu kaxhlaan txꞌix. Taqꞌ tu qꞌul ichusulibꞌ. Utz aatz qꞌul ichusulibꞌ, taqꞌ tek tu qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ech motx txꞌaꞌni sikajayil utz, motx nooi. Molax tek qꞌuꞌl chanani. Kabꞌlaat txakatx elkoꞌp bꞌoono inooeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Utz 5,000 qꞌu vinaj txꞌaꞌni. Sibꞌat ixoj tuchꞌ talaj nitxaꞌ txꞌaꞌn majte. Yeꞌt achaxi. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Uncheeꞌ aatz u Jesuus tan, oora tal tok bꞌen qꞌul ichusulibꞌ tu jukubꞌ. Ibꞌaxabꞌsa bꞌen siatz tunpaqꞌit u tziꞌ choo. Tuul nichtalka ibꞌen tu qꞌu tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Aatz tek veet taltuka ibꞌen tu qꞌu mam tenam, bꞌenjeꞌ viꞌ maꞌl u muunte sijunal. Ex iqꞌila sikꞌle Tioxh. Utz ok koꞌxh aqꞌbꞌal tuul. Ankoꞌxh atich tziꞌ sijunal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Pek aatz qꞌu chusulibꞌ, atich ok tu u jukubꞌ. Maꞌtich tokoꞌp tinikꞌa u choo. Utz techal bꞌoj itxalaꞌpunsal u jukubꞌ tu vipilqꞌaꞌtxan u choo. Tan ok maꞌl mam kajiqꞌ tibꞌey. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Pek aatz iꞌana aas bꞌiitich tereꞌn isajbꞌu saj, ul u Jesuus kꞌatza. Xaaom tul viꞌ u choo. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Utz taꞌxh ilax tu qꞌu chusulibꞌ aas nichixaan viꞌ aꞌ, motx sotz ikꞌuꞌl. Utz motx tal ech tzaꞌ: —¡U poyinal la!— Texhtuꞌ. Ech motx qꞌeqꞌun tu xoꞌval. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pek qꞌilal tek tu u Jesuus utz, tal te ech tzaꞌ: —Yeꞌ koꞌxh qeonex. In atziꞌ. Yeꞌ xoꞌvex.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Utz ech tzaqꞌbꞌel tu u Luꞌ ech tzaꞌ: —UnBꞌaal oj nojchit axh, ala aas saxaanin viꞌ u aꞌ tziꞌ. Soꞌoponin sakꞌatza.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Tal u Jesuus te ech tzaꞌ: —¡Niꞌaxh!— Texh te. Ech el u Luꞌ tu jukubꞌ. Xeꞌt ixaan viꞌ u aꞌ. Aal ibꞌen kꞌatz u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pek xoꞌv u Luꞌ taꞌxh tila aas techal ixumkabꞌin u mam kajiqꞌ. Utz xeꞌt tek isotz koꞌp tu aꞌ. Ech tek qꞌeqꞌun taltu ech tzaꞌ: —¡UnBꞌaal, eesa jiꞌulin!— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ech tu koꞌxh unmuꞌkꞌul txayax jeꞌul siqꞌabꞌ tu u Jesuus utz, tal te: —Tiira bꞌiil koꞌxh kꞌujlel akꞌuꞌl viꞌ. ¿Kantuꞌ vetkaꞌtziiunaxh?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ech taꞌxh motx jeꞌop tu u jukubꞌ, yaꞌ u mam kajiqꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Utz aatz tek qꞌuꞌl atich nal tu u jukubꞌ, motx tek pecheꞌ kuꞌ vatz u Jesuus utz, tal ech tzaꞌ: —¡Nojchit axh viKꞌaol u Tioxh!— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Uncheeꞌ aatz tek veet ipaal bꞌen viꞌ u choo, opon tek tu u txꞌavaꞌ tikuenta Genesareet. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ech taꞌxh ilax iatz u Jesuus tu qꞌu aanima, motx ipaxsa bꞌen itziiul tu jankꞌal qꞌu tenam tikuenta u txꞌavaꞌ tziꞌ. Ech motx iqꞌol ul qꞌu yaꞌv siatz. ");
INSERT INTO ixlCNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Utz jajax bꞌaꞌnil te aas sataqꞌ tzii tu qꞌu yaꞌv sikan vitziꞌaj u toksaꞌm. Ech motx iꞌan bꞌaꞌn kajay qꞌu yaꞌv tuchꞌ koꞌxh vikantaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Uncheeꞌ kꞌasuꞌl unjolol qꞌu fariseo tu Jerusaleen utz, opon kꞌatz u Jesuus. Ant imol qꞌu aa txumbꞌal tetz u oꞌtla mantaar. Utz motx tal tu u Jesuus ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Kam tokeꞌ aas niqel vikostuumbre qꞌu kukꞌuy kumam tzꞌibꞌamal qꞌul achusulibꞌ tziꞌ? Tan yeꞌxhkam niꞌan u kostuumbre tiꞌ itxꞌaal iqꞌabꞌ aas nitxꞌaꞌneꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tzaqꞌbꞌu u Jesuus utz, tal ech tzaꞌ: —Utz ¿kam tok majte, aas neqel vimantaar u Tioxh tiꞌ inimal vikostuumbre qꞌul ekꞌuy emam tzꞌibꞌamal? ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tan aꞌ u mantaar alel tu u Tioxh ech tzaꞌ: «Atoj tatin atxutx abꞌaal saatz. Tan abꞌil vaꞌl yeꞌk itxaꞌk itxutx ibꞌaal siatz, yatzꞌel sabꞌanli. Yeꞌk txumlichil iatz.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pek aatz netaleꞌ, saveeti aas satal maꞌj aanima titxutx ibꞌaal ech tzaꞌ: «Yeꞌxhkam veꞌt eetz savaqꞌeꞌ tan, aꞌ savaqꞌvu tu u Tioxh kajay val eetz savaqꞌeꞌ bꞌanel.» Cheꞌex. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Utz aatz qꞌuꞌl nibꞌanon ech tziꞌ, aꞌ niqel u mantaar Tioxh tiꞌ inimal qꞌul ikostuumbre qꞌu kukꞌuy kumam tan, yeꞌkan itxaꞌk itxutx ibꞌaal te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Jolol ¡ex kaꞌvatz! Tinujul chit vaꞌl tal u Isaias setiꞌ ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","«Aatz qꞌu tenam tziꞌ, tu koꞌxh qꞌul itziꞌ nitoksa unqꞌii. Pek aatz qꞌu taanima, tzian elnaj sunkꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ech yeꞌk koꞌxh tokebꞌal kꞌuxh nitoksa unqꞌii, kꞌuxh ninachꞌin. Tan aꞌ nichus ikostuumbre aanima. Nibꞌensas echaꞌ imantaar Tioxh. Chu u Tioxh.» Chia.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ech aatz u Jesuus, isikꞌle tek ul qꞌu mam tenam kꞌatza utz, tal te ech tzaꞌ: —Abꞌitaj bꞌaꞌnil vaꞌl nivaleꞌ tzaꞌ utz, paaloj etxumbꞌal tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yitꞌ nikojipaavin u aanima oj yeꞌ niꞌan u kostuumbre tiꞌ itxꞌaal iqꞌabꞌ aas nitechbꞌuneꞌ. Pek aꞌ niaqꞌon bꞌen u aanima tu paav qꞌu yeꞌxtxojla yol nijeꞌul titziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ech xaan tek opon qꞌul ichusulibꞌ u Jesuus kꞌatza utz, tal te: —¿At tzik vetbꞌenku see aas sibꞌ vetbꞌenku qꞌu yol tu qꞌu fariseo vaꞌl vetaala?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ech itzaqꞌbꞌe ech tzaꞌ: —Kajay qꞌu ia qꞌuꞌl yitꞌ vunTat koj tu Amlika vetchikon, sakoꞌnbꞌuqꞌax jeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kam esaꞌ te tan, jolol echaꞌ moy atziꞌ aas nitiqꞌo ibꞌey vaꞌt moy. Tan oj nojchit siꞌiqꞌol ibꞌey maꞌl moy tu vaꞌt moy, ela koꞌxh sabꞌen tu jul kaꞌbꞌil atziꞌ.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ech tzaqꞌbꞌu u Luꞌ utz, tal ech tzaꞌ: —Bꞌan talax qe bꞌaꞌnil kam tok u kam vetakꞌam tiꞌ tziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Tal u Jesuus ech tzaꞌ: —Utz ¿ant ex yeꞌxh bꞌoj etxumbꞌal tzik? ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tan kam vaꞌl nitechbꞌu u aanima, aꞌ nikoꞌkoꞌp tu tuul. Ech xamtel nibꞌen tu xaanbꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pek ech koj qꞌu yeꞌxtxojla yol nijeꞌul titziꞌ qꞌu aanima tan, aꞌ nikꞌaskuꞌl tu taanima. Utz aꞌ vaꞌl niaqꞌon bꞌen tu paav. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tan tu taanima u aanima nikꞌaskuꞌl qꞌu yeꞌxtxojla chaj txumbꞌal. Echaꞌ qꞌu yatzꞌoꞌm, u eesaibꞌ tu bꞌey tuchꞌ aanima, u elaqꞌ, qꞌu txubꞌaꞌlla chaj yol nitzꞌejax tiꞌ qꞌu aanima utz, tuchꞌ u yoqꞌoꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Aꞌ qꞌu kam nibꞌensan aa paav u aanima tziꞌ. Pek kꞌuxh yeꞌ sabꞌanax u kostuumbre tiꞌ itxꞌaal qꞌabꞌ aas suꞌuch txꞌaꞌom, yeꞌxhkam niyansa u aanima.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Uncheeꞌ kꞌastekꞌul u Jesuus tu vaꞌl atichka utz, bꞌen tikuenta Tiro tuchꞌ tikuenta Sidoon. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ech aatz iꞌan maꞌl u ixoj aꞌ kꞌaskuꞌl tikuenta u txꞌavaꞌ Canaan, vaꞌlich iqetun taltu ech tzaꞌ: —¡UnBꞌaal, ituꞌxh ixalam Daviid, txum unvatz! Tan aatz maꞌl u vitzꞌin ixviak, techal tulebꞌel tu u tioxhil txꞌiꞌliꞌinaj atoꞌk kꞌatza.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pek aatz u Jesuus tan, paat yeꞌ nichitzaqꞌbꞌe. Ech xaan tek opon qꞌul ichusulibꞌ kꞌatza utz, ijaj bꞌaꞌnil tu u Jesuus ech tzaꞌ: —Chaj bꞌen u ixoj tziꞌ tan, iqetun koꞌxh tok qiꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tzaqꞌbꞌu u Jesuus, tal ech tzaꞌ: —Kꞌuxh vetꞌulin tan, chajelin. Taꞌxh ul vil qꞌu Israeel qꞌuꞌl sotznaj ikꞌuꞌl echaꞌ karneꞌl aas tzꞌejxinaj.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pek aatz u ixoj tan, tabꞌi utz, ul pecheꞌoj vatz u Jesuus utz, tala: —¡UnBꞌaal, lochꞌin!— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tal koꞌn paj u Jesuus ech tzaꞌ: —Yitꞌ saꞌkojiꞌaneꞌ saqeesa u bꞌaꞌnil vatz qꞌu Israeel utz, saqaqꞌ tu qꞌu puera aanima. Echaꞌ u kaxhlaan txꞌix, saꞌkojiꞌaneꞌ saqeesa vatz qꞌu kꞌaol meꞌala utz, saqoksa vatz qꞌu txꞌiꞌ.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Pek tal u ixoj ech tzaꞌ: —Aꞌ chituꞌ, unBꞌaal. Pek loqꞌ aal aatz qꞌu txꞌiꞌ, nimotxtechbꞌu qꞌu juyaj kaxhlaan txꞌix qꞌuꞌl nichajpeꞌl viꞌ imeexha qꞌul ikoꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Uncheeꞌ tzaqꞌbꞌu tek u Jesuus utz, tala: —Ixoj, tiira kꞌujlel akꞌuꞌl viꞌ. Nojpoj vaꞌl najajeꞌ tziꞌ.— Texh te. Ech aatz u titzꞌin u ixoj tziꞌ, yakich iꞌan bꞌaꞌn tu u muꞌkꞌul tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kꞌastekꞌul u Jesuus latziꞌ utz, paal tziꞌ u choo tu Galilea. Ech ibꞌenjeꞌ viꞌ maꞌl u muunte utz, kꞌujeꞌi. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Utz sibꞌal aanima xaan opon kꞌatza. Iqꞌomich koꞌx taqꞌo, tuchꞌ moy, tuchꞌ kut qꞌabꞌ, tuchꞌ mem utz, tuchꞌ sibꞌat tereꞌn yaꞌv majte. Oksal vatz u Jesuus. Ech motx iꞌan bꞌaꞌn te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ech nichmotxitzꞌejx ikꞌuꞌl qꞌu aanima. Tan nichtekiyolon qꞌuꞌl memich. Tzꞌajel tek iqꞌabꞌ qꞌuꞌl kut qꞌabꞌich. Nichtekixaan qꞌu koꞌx. Utz nichtileꞌ aas bꞌaꞌn tek isajin qꞌu moy. Ech nichtekmotxtoksa iqꞌii viTioxh qꞌu Israeel tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Uncheeꞌ aatz u Jesuus, isikꞌle ul qꞌul ichusulibꞌ kꞌatza utz, tal te ech tzaꞌ: —Nuntxum iatz qꞌu tenam tziꞌ. Tan oxvaꞌx qꞌii cheel tatin sunkꞌatza utz, yeꞌkan techbꞌubꞌal. Utz yuꞌnsaꞌ sunchaj bꞌen ech tziꞌ tuul atil tu vaꞌy. Tan noj motx ijochpu tu bꞌey.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Utz alax te tu qꞌul ichusulibꞌ ech tzaꞌ: —¿Til saqiqꞌov sibꞌla echbꞌubꞌal tetz qꞌu mam tenam tu u tzꞌinlich txꞌavaꞌ tzaꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tal u Jesuus te ech tzaꞌ: —¿Jankꞌat echbꞌubꞌal atil tzexeꞌ?— Texh u Jesuus. Utz motx tzaqꞌbꞌu ech tzaꞌ: —Jujvaꞌl koꞌn, tuchꞌ kaꞌxvaꞌt txay.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ech aatz u Jesuus tan, tal ikꞌujeꞌ qꞌu aanima vatz txꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Utz itxay jujvaꞌl qꞌu kaxhlaan txꞌix tiqꞌabꞌ tuchꞌ qꞌu txay. Ikꞌama Tioxh tiꞌ. Ech ipixh tuul utz, taqꞌ tu qꞌu chusulibꞌ. Aꞌ tek motx jatxon paal vatz qꞌu tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ech motx itxꞌaꞌn sikajayil. Motx nooi. Ech molax tek qꞌuꞌl chanani. Utz jujvaꞌt txakatx elkoꞌp, bꞌoono inooeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Utz 4,000 qꞌu vinaj qꞌuꞌl txꞌaꞌni. Sibꞌat ixoj tuchꞌ talaj nitxaꞌ txꞌaꞌn majte yeꞌt achaxi. ");
INSERT INTO ixlCNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Uncheeꞌ tal tek ibꞌen qꞌu aanima u Jesuus utz, ok tek tu jukubꞌ. Bꞌen tu u txꞌavaꞌ tikuenta Magdala. ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Uncheeꞌ opon qꞌu fariseo kꞌatz u Jesuus tuchꞌ qꞌu saduceo. Utz vet sikꞌuꞌl motx iꞌana, ijaj xheenya te sikꞌuch tu amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pek tzaqꞌbꞌel koꞌn tu u Jesuus ech tzaꞌ: —Aatz nikuꞌ qꞌii, nimotxetaleꞌ: «Txꞌanel saqꞌi qꞌejal. Nimnaꞌl tan, vikajxu xeꞌ amlika.» Cheꞌex. ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Utz aatz netal qꞌalaꞌm: «Suꞌul jabꞌal cheel. Nimnaꞌl tan, viqꞌejbꞌu xeꞌ amlika tu sutzꞌ.» Cheꞌex. ¡Junal ex kaꞌvatz! Etootzajle tilax qꞌu xheenya qꞌuꞌl nichee vatz amlika, pek tiira yeꞌxhat niꞌenku sete abꞌiste qꞌu xheenya nituch setiꞌaj tu u tiempo tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Aatz ex, itzꞌlelex tu u tiempo tzaꞌ, jolol ex qelolla chaj aanima. ¡Ex aa paav utz, nejaj xheenya sakꞌuchax sete! Pek yeꞌk xheenya sakꞌuchax sete. Taꞌxh maꞌl xheenya setileꞌ, vaꞌl tiꞌ u Jonaas u alol tetz u yolbꞌal Tioxh.— Texhtuꞌ. Ech telabꞌelka tu u Jesuus, bꞌeni. ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Uncheeꞌ motx tek opon sala bꞌen u aꞌ. Yeꞌt inach tiqꞌol bꞌen techbꞌubꞌal qꞌu chusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Utz tal u Jesuus te ech tzaꞌ: —Iltaj utz, kuentaꞌex tiꞌ vaꞌl nichus qꞌu fariseo tuchꞌ qꞌu saduceo tziꞌ. Tan paxinchil niꞌaneꞌ, echaꞌ vitxꞌamil u kaxhlaan txꞌix.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Aatz qꞌu chusulibꞌ tan, nichtekmotxtal sivatzaj ech tzaꞌ: —Kꞌuxh nital qe ech tziꞌ, tiꞌ atziꞌ yeꞌn kunach tiqꞌol qechbꞌubꞌal.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Pek aatz u Jesuus tan, paal itxumbꞌal tu vaꞌl nichmotxtaleꞌ utz, tal te ech tzaꞌ: —Tiira bꞌiil koꞌxh kꞌujlel ekꞌul tiꞌ Tioxh. ¿Kantuꞌ aꞌ netitzꞌa aas yeꞌk echbꞌubꞌal? ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Yeꞌxh nikaa sekꞌuꞌl tzik? ¿Nikoꞌxh yeꞌ nenach oꞌvaꞌl u kaxhlaan txꞌix tzik, vaꞌl tzꞌaj vatz 5,000 aanima? Utz ¿yetz nenacheꞌ aas jatvaꞌt txakatx chan emola? ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Utz echat paj jujvaꞌl u kaxhlaan txꞌix majte vaꞌl tzꞌaj vatz 4,000 aanima. Utz ¿jatvaꞌt txakatx chan emola? ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Kam tokeꞌ aas tiira yeꞌ nitel etxumbꞌal tu qꞌu kam? Tan aꞌ koj nival u kaxhlaan txꞌix. Pek aꞌ nival vaꞌl nichus qꞌu fariseo tuchꞌ qꞌu saduceo, vaꞌl ech ipaxineꞌ niꞌaneꞌ vipaxin u txꞌamil kaxhlaan txꞌix.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ech nal tek el itxumbꞌal qꞌu chusulibꞌ tuul aas yitꞌ aꞌ koj siꞌanvu kuenta tibꞌ tiꞌ u txꞌamil kaxhlaan txꞌix, pek aꞌ sibꞌanvu kuenta tibꞌ tiꞌ vichusbꞌal qꞌu fariseo tuchꞌ qꞌu saduceo. ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Uncheeꞌ aatz tek opon u Jesuus tu u tenam Cesarea Filipo, ichꞌoti tu qꞌul ichusulibꞌ ech tzaꞌ: —¿Kam nital qꞌu aanima tiꞌ u Kꞌaola vaꞌl bꞌennaj koꞌn aanima? ¿Abꞌil aas nitaleꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Motx tzaqꞌbꞌu ech tzaꞌ: —At nialon aas axh Xhan, u bꞌanol vautiismo. At nialon aas axh Elias. At nialon aas axh Jeremias. Utz at nialon aas axh maꞌj qꞌu alol tetz u yolbꞌal Tioxh nitaleꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ech tal paj u Jesuus ech tzaꞌ: —Pek aatz ex, ¿abꞌil in netaleꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tzaqꞌbꞌu u Xhim vaꞌl Luꞌ ibꞌii utz, tala: —Axh viTxaaom u Tioxh vaꞌl saꞌchitꞌulaxh, viKꞌaol u itzꞌlich Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Uncheeꞌ tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Xhim, ikꞌaol Jonaas, chiꞌbꞌebꞌal eetz tan, yitꞌ aanima koj vetalon see vaꞌl naaleꞌ tziꞌ, pek vunTat tu Amlika vetoksan sakꞌuꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Utz aatz in, nival see, aas axh Luꞌ. Utz aꞌ sunchikvu qꞌu niman vetz viꞌ u tiila sivan tzaꞌ. Utz tech koj u txꞌiꞌliꞌinaj tiꞌ iyaꞌsaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Utz savaqꞌ u laave see tetz viQꞌesalail u Tioxh tu Amlika majte. Ech kam vaꞌl saqitz tu u vatz txꞌavaꞌ tzaꞌ, saqitzpu tu Amlika majte. Utz kam vaꞌl saqꞌal tu u vatz txꞌavaꞌ tzaꞌ, saqꞌalpu tu Amlika majte.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Utz tal u Jesuus tu qꞌul ichusulibꞌ aas yeꞌxhabꞌil koꞌxh e satalva aas aꞌ viTxaaom u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Uncheeꞌ ech vixeꞌt u Jesuus tiꞌ talax tu qꞌul ichusulibꞌ tziꞌ, aas ministeer sabꞌen tu Jerusaleen. Utz saꞌxhpaasal tu kꞌaxkꞌo tu qꞌu qꞌesal qꞌatol tzii, tu qꞌu qꞌesal oksan yol utz, tuchꞌ tu qꞌu aa txumbꞌal tetz u oꞌtla mantaar. Ech sakami. Loqꞌ sakoꞌnqꞌaavitzꞌpu titoxvaꞌ qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pek aatz u Luꞌ, isikꞌle bꞌen u Jesuus echil tziꞌ. Xeꞌt imaj iatz ech tzaꞌ tiꞌ vaꞌl tala: —¡UnBꞌaal, oyobꞌ aatz! ¡Yeꞌk siꞌaneꞌ sapaalaxh tu u kam naaleꞌ tziꞌ!— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ech aatz u Jesuus tan, isuchqꞌi tibꞌ utz, tal tu u Luꞌ ech tzaꞌ: —¡Xaaneꞌl sunvatz txꞌiꞌliꞌinaj! Aal koꞌxh namajin. Tan aꞌ koj niitzꞌa qꞌu kam tetz u Tioxh, pek aꞌ niitzꞌa qꞌu kam tetz qꞌu aanima.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Uncheeꞌ tal u Jesuus tu qꞌul ichusulibꞌ ech tzaꞌ: —Oj abꞌil sisaꞌa xambꞌichil viꞌ, imaj tibꞌ tiꞌ toksal tetz vitxumbꞌal. Pek iqꞌiꞌ paalchil tu mam il tzaꞌl viꞌ utz, xambꞌoj viꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tan abꞌil qꞌuꞌl taꞌxh nititzꞌa u vatz iqꞌii isaj tu u vatz txꞌavaꞌ tzaꞌ, tzꞌejoꞌm siꞌaneꞌ. Pek abꞌil qꞌuꞌl kꞌuxh sitzꞌej u vatz iqꞌii isaj viꞌ, aꞌ vaꞌl sachabꞌan u bꞌenchil tu bꞌenqꞌii bꞌensaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tan kam koj siꞌan kanaal u aanima kꞌuxh satetza u vatz amlika txꞌavaꞌ kajayil tzaꞌ, untzꞌoj aꞌ seꞌenku u taanxelal tu choobꞌal paav. Tan kam koj choobꞌal sataqꞌ u aanima tiꞌ itool u taanxelal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tan suꞌltaqꞌ u choobꞌal u Kꞌaola vaꞌl bꞌennaj koꞌn aanima tu junun aanima tiꞌ qꞌul ibꞌanoneꞌ aas luꞌul tu u tijleꞌm viTat tuchꞌ qꞌul iaanjel. ");
INSERT INTO ixlCNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Niꞌxhtekꞌval sete, atil kaꞌvoꞌj oxvoꞌj ex cheel atziꞌ, atilex tzaꞌ, aas yeꞌsajen ekameꞌ, satil tul u Kꞌaola vaꞌl bꞌennaj koꞌn aanima tu viQꞌesalail.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Uncheeꞌ maꞌtich tel vaajil qꞌii tuul, aatz u Jesuus, tiqꞌo bꞌen viꞌ maꞌl u tꞌankin muunte u Luꞌ, u Jacobo, tuchꞌ u Xhan, vitzaꞌqꞌ u Jacobo. ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ech ijalpixsa tilon u Jesuus siatz. Techal tek iribꞌun ivatz, echaꞌ u qꞌii tziꞌ. Utz tiira sajich tek qꞌu toksaꞌm, echaꞌ ipaqꞌun saj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tuul aꞌ texh til ichee u Moisees tuchꞌ u Elias. Utz nichtekiyolon tuchꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Aatz tek u Luꞌ, tal tu u Jesuus ech tzaꞌ: —¡UnBꞌaal, bꞌaꞌn atziꞌ aas atiloꞌ tzaꞌ! Pek ¿satz asaꞌa sakubꞌan oxvoꞌj muuabꞌal nachpixsabꞌal? Maꞌl eetz. Vaꞌt tetz u Moisees. Utz vaꞌt tetz u Elias.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ech tuul ankoꞌxh nichiyoloneꞌ, motx okka jaqꞌ maꞌl u ribꞌunnaj sutzꞌ. Utz abꞌil maꞌl u yol uch tu u sutzꞌ. Tal ech tzaꞌ: —Aꞌ vunKꞌaol. Tiiꞌin tiꞌ atziꞌ. Vaꞌl nikꞌujeꞌ unkꞌuꞌl tiꞌ. Aꞌ vaꞌl setabꞌi tetz.— Texh u yol. ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ech taꞌxh tabꞌi u yol qꞌu chusulibꞌ tziꞌ, motx pecheꞌi. Taqꞌ kuꞌ ivatz vatz txꞌavaꞌ tuul kaana ixoꞌveꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ech aatz u Jesuus tan, xaan opon kꞌatza. Ikana utz, tal te: —Lakpojex utz, yeꞌ koꞌxh xoꞌvex.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ech motx tek sajini utz, yeꞌxhabꞌil tereꞌn tila. Aꞌ texh atichka u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Aatz tek nichmotxikuꞌl viꞌ u muunte, tiira tal u Jesuus te bꞌaꞌnil ech tzaꞌ: —Yeꞌxhabꞌil koꞌxh e setalvu u kam vetetillaꞌ tziꞌ. Anal letala aas maꞌt qꞌaav titzꞌpu xoꞌl qꞌu kamnaj u Kꞌaola vaꞌl bꞌennaj koꞌn aanima.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ech aatz qꞌu chusulibꞌ tan, ichꞌoti tu u Jesuus ech tzaꞌ: —¿Kam tok vaꞌl nital qꞌu aa txumbꞌal tetz u oꞌtla mantaar aas: «Ministeer aꞌ bꞌaxal suꞌul u Elias.» Chia?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Nojchituꞌ. Aꞌ suꞌul u Elias bꞌaxal utz, aꞌ saqꞌaaviꞌanvu bꞌaꞌn kajay qꞌu kam tikuenta. ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pek ootzajitaj tan, ulnaj tek u Elias utz, yeꞌxhat koꞌn bꞌenku tu qꞌu aanima tziꞌ. Tan motx koꞌn iꞌan te kam tal qꞌu taanima tiꞌ. Echat koꞌxh paj samotxiꞌan tu u Kꞌaola vaꞌl bꞌennaj koꞌn aanima.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ech tek motx el itxumbꞌal qꞌu chusulibꞌ tuul aas aꞌ nichyolonku tiꞌ u Xhan, u bꞌanol vautiismo. ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Uncheeꞌ motx tek opon kꞌatz qꞌu mam tenam. Utz ul maꞌl u vinaj, ul pecheꞌoj kuꞌ siatz. Tal te ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—¡UnBꞌaal, txum iatz vunkꞌaol! Tan atil maꞌl tiila yaabꞌil kꞌatza. Tiira txumbꞌal iatz taqꞌo. Jatpax koꞌxh paaloꞌk tu xamal utz, jatpax koꞌxh bꞌen tu aꞌ taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Vetviqꞌo ul vatz qꞌul achusulibꞌ tziꞌ, pek yeꞌn motx oleꞌ tiꞌ ibꞌanax bꞌaꞌn te.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ech tzaqꞌbꞌu u Jesuus, tal ech tzaꞌ: —Tiira ex kaꞌtziiunnajla chaj aanima. ¡Tiira ex aa paav itzꞌlelex tu tiempo tzaꞌ! Ech koꞌn chixh vatin texoꞌl tzaꞌ. Ech koꞌn chixh unqꞌiꞌtꞌex tziꞌ. Iqꞌotaj ul tzaꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ech aatz u Jesuus tojcha el u tioxhil txꞌiꞌliꞌinaj kꞌatz u xiak utz, yakich iꞌan bꞌaꞌn tu u muꞌkꞌul tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Uncheeꞌ motx tek xaan opon qꞌu chusulibꞌ kꞌatz u Jesuus, aas ijunalich tekoꞌn utz, tal te ech tzaꞌ: —¿Kam tokeꞌ aas yeꞌn oleꞌoꞌ tiꞌ tojchal el u tioxhil txꞌiꞌliꞌinaj tziꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tal u Jesuus te ech tzaꞌ: —Tiꞌ tan, bꞌiil koꞌxh kꞌujlel ekꞌuꞌl tiꞌ u Tioxh. Pek niꞌxhtekꞌval sete aas kꞌuxh echil koꞌxh sakꞌujeꞌ ekꞌuꞌl echaꞌ maꞌj bꞌaqꞌ muxhtaansa, kam koj vaꞌt yeꞌ saveet sevatz. Echaꞌ tziꞌ letal tu maꞌl muunte: «Elenbꞌen tzaꞌ; kuxh bꞌen tziꞌ.» Chajex te. Sael bꞌen atziꞌ. Kajay saveeti. ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pek aatz u tioxhil txꞌiꞌliꞌinaj tziꞌ tan, sakoꞌnkoxhel ech tziꞌ. Pek tu chit ekuyt evaꞌy, tiꞌ eqꞌilat esikꞌlet Tioxh, bꞌaꞌntan saeli.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Uncheeꞌ imol tibꞌ u Jesuus tuchꞌ qꞌul ichusulibꞌ tu Galilea. Tal u Jesuus te ech tzaꞌ: —Soꞌoksal u Kꞌaola vaꞌl bꞌennaj koꞌn aanima tiqꞌabꞌ qꞌu qꞌatol tzii. ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Utz samotxiyatzꞌeꞌ. Pek loqꞌ saqꞌaavitzꞌpu titoxvaꞌ qꞌii.— Texh u Jesuus. Ech tiira motx chit txumun qꞌu chusulibꞌ tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Aatz tek motx opon tu u Capernauum, ul qꞌu vinaj kꞌatz u Luꞌ, qꞌu jajol tetz u choobꞌal okebꞌalop tu viqꞌanalil u totztioxh. Ayaꞌ vijaꞌmel kaꞌvaꞌl qꞌii aqꞌon. Utz tal te ech tzaꞌ: —Aatz u chusul etetz tziꞌ, ¿ni tzik ichoo u okebꞌalop tu viqꞌanalil u totztioxh?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Eeꞌ, nichooeꞌ atziꞌ.— Texh u Luꞌ. Ech taꞌxh opon u Luꞌ tu u atibꞌal, bꞌaxal yolon u Jesuus te ech tzaꞌ: —Kan tal nanacheꞌ Luꞌ, ¿abꞌil e nijajvu u jaꞌmel alkavaar qꞌu ijlenal tu u vatz txꞌavaꞌ tzaꞌ? ¿Tu tzik qꞌu tetz aa tenamil, pek oj tu qꞌu puera aanima?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Tzaqꞌbꞌu u Luꞌ utz, tala: —Tu qꞌu puera aanima atziꞌ.— Texhtuꞌ. Utz tal u Jesuus te ech tzaꞌ: —Uncheeꞌ aatz qꞌu tetz aa tenamil yeꞌkax chooni. ");
INSERT INTO ixlCNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pek majbꞌal ichiꞌon ikꞌuꞌl qiꞌ, kuxh tziꞌ u choo tziꞌ. Aqꞌ koꞌp u eesabꞌ txay tu aꞌ. Ech abꞌiste u bꞌaxa txay leesa jiꞌul, lajaj vitziꞌ. Tan sachabꞌa maꞌl u puaj tuul. Iqꞌo kꞌasuꞌl u puaj tziꞌ utz, lachoo u qokebꞌalop; in utz, tuchꞌ axh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Uncheeꞌ aatz iꞌana, xaan opon qꞌu chusulibꞌ kꞌatz u Jesuus utz, tal te ech tzaꞌ: —¿Abꞌiste maꞌj qe aas nim tijleꞌm siꞌan tu viQꞌesalail u Tioxh tu Amlika?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ech isikꞌle ul maꞌl tal nitxaꞌ u Jesuus. Itxakbꞌaꞌ tixoꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Utz tal ech tzaꞌ: —Niꞌxhtekꞌval sete, saꞌkojokoꞌpꞌex tu viQꞌesalail u Tioxh tu Amlika oj yeꞌk sachꞌexpꞌex; oj yeꞌk sebꞌensa etibꞌ echaꞌ ex tal nitxaꞌ aas maanxho. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tan abꞌiste vaꞌl sataqꞌ bꞌen tibꞌ chꞌoo echaꞌ u tal nitxaꞌ tzaꞌ, aꞌ vaꞌl nim tijleꞌm siꞌan tu viQꞌesalail u Tioxh tu Amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Utz abꞌil lakꞌulun maꞌl tal nitxaꞌ tunbꞌii echaꞌ tzaꞌ, in aꞌ nikꞌulin tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Pek abꞌil vaꞌl saꞌaqꞌon bꞌen maꞌj qꞌu chꞌooal niman vetz tu paav, aal tek bꞌaꞌn saqitzax ok maꞌl mam sivan siqul, cheꞌbꞌ triigo, ech seꞌnkꞌonaxoj okoꞌp tu u mar. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Tilayol u paav tu u vatz txꞌavaꞌ tzaꞌ vaꞌl niaqꞌon kuꞌ qꞌu aanima. Loqꞌ ech chituꞌ atziꞌ. Pek aꞌ tiira tilayol sayaꞌk u aanima vaꞌl sataqꞌ bꞌen imol tu paav. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ech tokeꞌ oj nitaqꞌbꞌenaxh vaqꞌabꞌ val aajan tu paav, aal tek bꞌaꞌn seesa. Tan kꞌuxh axh kut qꞌabꞌ utz, kꞌuxh axh kut ajan, taꞌxhtzii soꞌokopꞌaxh tu bꞌenqꞌii bꞌensaj. Tan kꞌuxh tzꞌajel chit aqꞌabꞌ aajan, tilayol oj aꞌ yakkꞌaxh tu xamal u choobꞌal paav vaꞌl yeꞌk iyaꞌeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Utz oj aal nitaqꞌbꞌenaxh u bꞌaqꞌ avatz tu paav, yaaqꞌ tzii tu u tachaꞌv. Aal bꞌaꞌn seesa tan, kꞌuxh maꞌl koꞌn bꞌaqꞌ avatz, taꞌxhtzii soꞌokoꞌpꞌaxh tu bꞌenqꞌii bꞌensaj. Pek kꞌuxh tzꞌajel kaꞌvaꞌl bꞌaqꞌ avatz, tilayol untzꞌoj aꞌ yakkꞌaxh tu u xamal u choobꞌal paav. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ech tokeꞌ, kuentaꞌex. Eteesach koꞌxh iqꞌii qꞌu chꞌooal niman vetz. Tan nojchit nivaleꞌ atil aanjel xeen tetz tu vunTat tu Amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tan aatz u Kꞌaola vaꞌl bꞌennaj koꞌn aanima, aꞌ ul teesa tu u paav qꞌuꞌl maꞌtich itzꞌejxeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Kam bꞌoj saelka nenacheꞌ? Atil koj maꞌj vinaj aas 100 ikarneꞌl atile. Pek satzꞌejxuka maꞌj te. ¿Oj tzik yeꞌ sataqꞌka vaꞌt u 99 tziꞌ utz, seꞌnichok u tzꞌejxinaj tulaj jaꞌjtzeꞌ? ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ech oj lichabꞌa, niꞌxhtekꞌval sete aas saꞌxhtxuqꞌtxun tiꞌ. Paalch itxuqꞌtxun tiꞌ siꞌan vatz u 99 karneꞌl qꞌuꞌl yitꞌ tzꞌejxinaj koj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Utz echat koꞌxh majte, yitꞌ itxumbꞌal koj u kuTat tu Amlika aas satzꞌejxu maꞌj tu qꞌu chꞌooal niman vetz tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ech tokeꞌ, oj kam siꞌan vahermano see, al te, kaꞌl koꞌxh axaan tuchꞌ. Ech oj likan tabꞌil tokebꞌal, vetooksal tu jik atziꞌ. Ech qꞌaavi abꞌan bꞌaꞌn tuchꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pek oj yeꞌ koꞌn likan tabꞌileꞌ, iqꞌo tek bꞌen maꞌj oj kaꞌvoꞌj amol saiꞌ. Ech kaꞌvoꞌj oxvoꞌj aanima sailon vinujul vaꞌl saal te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Pek oj yeꞌ koꞌn paj latabꞌi tokebꞌal vatz qꞌul amol tziꞌ, al tek vatz qꞌu aanima niman tetz u Tioxh. Pek oj yeꞌ koꞌn paj likan tabꞌil tokebꞌal vaꞌl laꞌalax te tu qꞌu aanima niman tetz u Tioxh, aqꞌ tek bꞌen aanima yeꞌ tootzaj Tioxh, echaꞌ qꞌu subꞌulla jajol jaꞌmel alkavaar. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Tan niꞌxhtekꞌval sete, kajay vaꞌl seqitz tu u vatz txꞌavaꞌ tzaꞌ, saqitzpu tu Amlika majte. Utz kam vaꞌl sechitpu tu u vatz txꞌavaꞌ tzaꞌ, sachitpu tu Amlika majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Utz nipajval sete majte oj atil kaꞌvoꞌj ex senukꞌ sevatz tu u vatz txꞌavaꞌ tzaꞌ, aas kam koꞌxh maꞌj ibꞌii sejajeꞌ, saaqꞌax sete tu vunTat tu Amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tan til molelku tibꞌ kaꞌvoꞌj oxvoꞌj aanima tiꞌ vunbꞌii, latziꞌ atilkꞌin tixoꞌl majte.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ech xaan opon u Luꞌ kꞌatz u Jesuus utz, tal te ech tzaꞌ: —¿UnBꞌaal jatpajul sunkuy ipaav vunhermano vaꞌl kam koꞌxh siꞌan ve? ¿Jujpajul koꞌn tzik?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Tal u Jesuus te ech tzaꞌ: —Jujpajul koꞌn chajkojin see, pek jujpajul 70 sakuyeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Aatz viQꞌesalail u Tioxh tu Amlika, ela tuchꞌ maꞌl u ijlenal vaꞌl iꞌan tiꞌ jankꞌal itxꞌoj qꞌu taqꞌonom atil tzixeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Utz aatz xeꞌt iꞌan tiꞌ, iqꞌol opon maꞌl u taqꞌonom siatz aas maꞌl 60,000 ijaꞌmel qꞌii aqꞌon itxꞌoj tzixeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Aatz u vinaj tziꞌ tan, yeꞌt oleꞌ tiꞌ ichool vitxꞌoj. Ech aatz u ijlenal tal tek ikꞌayil ok vatz aqꞌon tuchꞌ tixoj, ikꞌaol, imeꞌal utz, tuchꞌ kajay qꞌu tetz atile. Ech seꞌel vitxꞌoj tala. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Pek pecheꞌ kuꞌ u aqꞌonom vatz u bꞌaal taqꞌon, ijaj kuybꞌal te. Tal te ech tzaꞌ: «¡Kuyin! Chꞌiabꞌitojin, unbꞌaal tan, sunchoo kajay vuntxꞌoj tzaxeꞌ.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ech txumax iatz u aqꞌonom tu u bꞌaal taqꞌon tziꞌ utz, ikuy tiꞌ vitxꞌoj. Ech ichajpu. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Pek taꞌxh elkꞌasuꞌl u aqꞌonom vaꞌl kuyli tziꞌ, til tibꞌ tuchꞌ vaꞌt u tetz aqꞌonomil atich itxꞌoj tzixeꞌ. Ijaꞌmel 100 qꞌii aqꞌon vitxꞌoj. Utz itxaya, ipochꞌi siqul tuul nichtal te ech tzaꞌ: «¡Choo koꞌn vatxꞌoj tzunxeꞌ cheel!» Chu te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ech aatz u tetz aqꞌonomil tziꞌ tan, pecheꞌ siatz utz, nichijajabꞌe ech tzaꞌ: «¡Kuyin! Chꞌiabꞌitojin tan, sunchoo kajay vuntxꞌoj tzaxeꞌ.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pek aatz u aqꞌonom tziꞌ tan, yeꞌt koꞌn isaꞌa. Ech tal tok tu tzeꞌ, ichoo nal kajay vitxꞌoj tala. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Uncheeꞌ ilax tunjot qꞌu tetz aqꞌonomil. Motx chit txumun tiꞌ kam vaꞌl bꞌanax tu vimol tziꞌ utz, ex tek tal tu u bꞌaal taqꞌon kam vaꞌl motx tila. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ech aatz u bꞌaal aqꞌon tan, isavsa tek u aqꞌonom tziꞌ utz, tal te ech tzaꞌ: «¡Onkonla aqꞌonom! ¡Vetunkuyaxh tiꞌ kajay vatxꞌoj tan, vetajaj kuybꞌal ve! ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Pek ¿kantuꞌ yitꞌ ech koj itxuml iatz vamol vetaꞌana, echaꞌ untxumt aatz?» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ech techal ilakp iviꞌ u bꞌaal taqꞌon tiꞌ. Toksa tiqꞌabꞌ qꞌu tzꞌuꞌman preexhu utz, ichoo nal kajay vitxꞌoj tzixeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Echat siꞌan vunTat tu Amlika sete majte, oj yitꞌ tuchꞌ etaanima sekuy ipaav emol.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Uncheeꞌ aatz tek yaꞌ taltu qꞌu yol u Jesuus tzaꞌ, elbꞌen tu Galilea utz, bꞌen tikuenta Judea vatz bꞌen u Jordaan. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mam tenam xambꞌu bꞌen tiꞌ. Utz iꞌan bꞌaꞌn tu qꞌu yaꞌv latziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Pek xaan opon unjolol qꞌu fariseo kꞌatza utz, vet sikꞌuꞌl motx ichꞌoti te ech tzaꞌ: —¿Satz veeti satojcha tixoj maꞌj vinaj aas kam koꞌxh tiꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —¿Yetz sikꞌlemal setaqꞌo tu u Yolbꞌal Tioxh? aas u Tioxh vaꞌl cheesan qꞌu aanima xeꞌ qꞌii xeꞌ saj; maꞌl vinaj utz, maꞌl ixoj iꞌana. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tal u Tioxh: «Ech tokeꞌ sataqꞌka itxutx ibꞌaal u aanima vaꞌl sachee ikꞌulel utz, maꞌl tekoꞌn saelkoꞌp vatz Tioxh.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ech yitꞌ kaꞌvaꞌl tereꞌn koj, pek maꞌl tekoꞌn saelka sikaꞌbꞌil. Ech tokeꞌ abꞌil vaꞌl vatz Tioxh nikꞌul tibꞌ, yeꞌxhabꞌil koꞌxh maꞌj aanima sajatxon.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tal qꞌu fariseo te ech tzaꞌ: —¿Kam tokeꞌ uncheeꞌ taqꞌka tzii u Moisees aas saveeti satojcha tixoj u vinaj? Sakoꞌnaqꞌax maꞌl tuꞌ u ixoj tetz jatxbꞌalibꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tal u Jesuus te: —Kꞌuxh taqꞌka tzii u Moisees aas saveeti setojcha etixoj, tiꞌ atziꞌ tan, taꞌxh okoj tetz qꞌul ekꞌuy emam. Pek ech koj ikaa xeꞌ qꞌii xeꞌ saj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Pek nival sete, aatz u vinaj vaꞌl nikoꞌxhtaqꞌan tojchat tixoj utz, nichok vaꞌt tixoj, eesaibꞌ tu bꞌey niꞌan tuchꞌ atziꞌ tan, yitꞌ aꞌ koj vikꞌulel. Tan vettojcha u tixoj yitꞌ tiꞌ koj aas niteesa tibꞌ u tixoj tu bꞌey tuchꞌ vaꞌt vinaj. Utz abꞌiste u vinaj vaꞌl saiqꞌon u ixoj ojchamal tziꞌ, eesaibꞌ paj niꞌan tu bꞌey tuchꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ech alax tek te tu qꞌul ichusulibꞌ ech tzaꞌ: —Untzꞌoj ech vaꞌl sapaalku u vinaj tuchꞌ u tixoj tziꞌ, uncheeꞌ aal tek bꞌaꞌn yeꞌk sichok tixoj atziꞌ uncheeꞌ. Utz yeꞌk satzumeꞌi.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Uncheeꞌ tal tek u Jesuus ech tzaꞌ: —Yitꞌ kajay koj satxꞌakon u atinchil ech tziꞌ. Pek taꞌxhtuꞌ, qꞌuꞌl tetzan tu u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tan atil vinaj tetzan tu u Tioxh tu alabꞌ tetz aas yiꞌsaꞌ ixoj. Utz at majte, aanima koꞌn nibꞌanon te aas yiꞌsaꞌ ixoj. Utz atil paj majte yiꞌsaꞌ ixoj. Loqꞌ anat nibꞌanon tibꞌ, tiꞌ u taqꞌonin tiꞌ viQꞌesalail u Tioxh tu Amlika niꞌanva. Ech abꞌil satxꞌakon u atinchil ech tziꞌ utz, itxꞌakeꞌ.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Uncheeꞌ ex oksaloj unjolol talaj nitxaꞌ vatz u Jesuus. Aꞌ isaꞌ qꞌul itxutx ibꞌaal aas sataqꞌ jeꞌ iqꞌabꞌ tibꞌa utz, siqꞌila sikꞌle Tioxh tiꞌ. Pek nichkoꞌniyaal tu qꞌu chusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ech tal tek u Jesuus te ech tzaꞌ: —Aqꞌtaj tzii suꞌul qꞌu talaj nitxaꞌ sunkꞌatza tziꞌ. Yeꞌ koꞌxh emaj iatz. Tan aatz viQꞌesalail u Tioxh tu Amlika, tetz qꞌuꞌl echaꞌ talaj nitxaꞌ aas yeꞌ nijeꞌsa tibꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ech taqꞌ jeꞌ iqꞌabꞌ tibꞌa qꞌu talaj nitxaꞌ. Utz eltekbꞌen tu vaꞌl atichka. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Uncheeꞌ ul maꞌl u xiak kꞌatz u Jesuus utz, tal te ech tzaꞌ: —Bꞌaꞌnla chusul, ¿abꞌiste qꞌu bꞌaꞌnil sunbꞌaneꞌ, ech soꞌokoꞌpꞌin tu bꞌenqꞌii bꞌensaj?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Tal u Jesuus te: —¿Kantuꞌ naaleꞌ aas in bꞌaꞌn? Tan taꞌxh maꞌl bꞌaꞌn atile, ayaꞌ u Tioxh. Pek oj aꞌ asaꞌ okchil tu bꞌenqꞌii bꞌensaj, nima koꞌn qꞌul imantaar Tioxh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tal u xiak ech tzaꞌ: —¿Abꞌiste te?— Texhtuꞌ. Tal u Jesuus ech tzaꞌ: —Yeꞌk sayatzꞌonaxh. Eesach iibꞌ tu bꞌey tuchꞌ aanima yitꞌ akꞌulel koj. Yeꞌk saelqꞌaxh. Yeꞌk saal txubꞌaꞌl tiꞌ amol. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Atoj tatin atxutx abꞌaal saatz. Utz tiiꞌaxh tiꞌ kajay aanima echat koꞌxhtuꞌ naꞌan saiꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tal u xiak te ech tzaꞌ: —Ninalunnima tunchꞌooil kajay qꞌu kam naaleꞌ atziꞌ. Pek ¿kam tereꞌn sunbꞌaneꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Tal u Jesuus te ech tzaꞌ: —Oj nojchit aꞌ asaꞌ saꞌan tzꞌajelaxh vatz u Tioxh, saꞌan vinujul, kuxh kꞌayi kajay qꞌul eetz utz, aqꞌ vijaꞌmel tu qꞌu meꞌbꞌaꞌ. Ech saꞌatin txꞌiibꞌal aqꞌii tu Amlika. Utz niꞌaxh, xambꞌen viꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Taꞌxh tabꞌi u yol u xiak tziꞌ, txumun tek tiꞌ. Elbꞌen tan, sibꞌal txꞌiibꞌal iqꞌii atiche. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ech tal tek u Jesuus tu qꞌul ichusulibꞌ ech tzaꞌ: —Niꞌxhtekꞌval sete, aas tiira tzaꞌl soꞌokoꞌp maꞌl txꞌiiol iqꞌii tu viQꞌesalail u Tioxh tu Amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Aal yitꞌ tzaꞌl koj tokoꞌp u camello tixotoꞌlil u bꞌaj vatz u tokoꞌp maꞌl txꞌiiol iqꞌii tu viQꞌesalail u Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ech taꞌxh tabꞌi u yol qꞌu chusulibꞌ tziꞌ, tiira motx sotz ikꞌuꞌl utz, motx tal ech tzaꞌ: —¿Abꞌil tek tech tu okichꞌop xeꞌ Tioxh uncheeꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Pek tii tek sajil tu u Jesuus utz, tal te ech tzaꞌ: —Yeꞌ chit saveet vatz qꞌu aanima, pek kajay saveet iꞌan tu u Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ech itzaqꞌbꞌu u Luꞌ utz, tala: —Aatz oꞌ vetqaqꞌluka kajay qꞌu qetz utz, xameloꞌ saiꞌ. Pek ¿kam bꞌoj qetz saꞌaqꞌax tiꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Tal tek u Jesuus tu kajay qꞌul ichusulibꞌ ech tzaꞌ: —Niꞌxhtekꞌval sete, samotxokꞌex te tijleꞌm, jatvaꞌlex xamelex viꞌ. Seqꞌat tzii xoꞌl kabꞌlaal tanul qꞌu Israeel aas lachꞌexpu u vatz Amlika txꞌavaꞌ utz, loꞌok tu u mam techalla tijleꞌm u Kꞌaola vaꞌl bꞌennaj koꞌn aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Tan abꞌil qꞌuꞌl sataqꞌka tetz viꞌ, aatz u bꞌaꞌnil vaꞌl sikꞌuleꞌ, 100 tanul paalchu vatz vaꞌl sataqꞌka. Utz saetzan tiꞌ u bꞌenqꞌii bꞌensaj. Echaꞌ qꞌuꞌl sataqꞌka totzotz; sataqꞌka tatzik, itzaꞌqꞌ; sataqꞌka tanabꞌ; sataqꞌka itat, inan; sataqꞌka ikꞌaol imeꞌal tuchꞌ itxꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pek sibꞌal koꞌxh qꞌuꞌl sibꞌ tatin ninach cheel, bꞌiil koꞌn tatin toj iꞌaneꞌ. Pek sibꞌal qꞌuꞌl bꞌiil koꞌn tatin ninach cheel, sibꞌ tatin toj iꞌaneꞌ.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Tal paj chit u Jesuus ech tzaꞌ: —Aatz viQꞌesalail u Tioxh tu Amlika, ela tuchꞌ maꞌl u vinaj txutxa bꞌaala, aas kꞌasuꞌl qꞌalaꞌm ex ichok taqꞌonom, aqꞌonin tetz viuuva, vichikobꞌeꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Utz ikꞌul tibꞌ iyol tuchꞌ qꞌu aqꞌonom aas ech sichoova kaniꞌch u jaꞌmel qꞌii. Ech ichaj bꞌen tu vichikobꞌeꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kꞌaspajchitꞌul u vinaj tziꞌ. Aꞌ chit alas 9ich qꞌalaꞌm, til unjoltu chokol aqꞌon. Atich koꞌxh tu kꞌayibꞌal; yeꞌk taqꞌon. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Utz tal te ech tzaꞌ: «Bꞌenoj aqꞌoninex tzunxeꞌ tunchikobꞌeꞌm utz, sunchooꞌex tijikomal.» Texh te. Ech motx bꞌeni. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kꞌaspajchitꞌul u vinaj chaqꞌaal qꞌii tziꞌ, tuchꞌ alas 3, kuꞌqꞌii. Utz echat koꞌxh paj iꞌana. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Pek aꞌ chit siꞌchtexhiꞌan alas 5 kuꞌqꞌii, kꞌaspajul. Utz til unjot chokol aqꞌon atich koꞌxhtuꞌ. Utz tal te ech tzaꞌ: «¿Kantuꞌ maꞌx koꞌxh qꞌii etatin tzaꞌ yeꞌn etaqꞌonineꞌ?» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Motx tzaqꞌbꞌu ech tzaꞌ: «Tan yeꞌxhabꞌil maꞌj nuꞌltal taqꞌon qe.» Texhtuꞌ. Ech tal tek u vinaj te: «Bꞌenoj aqꞌoninex tzunxeꞌ tunchikobꞌeꞌm utz, sunchooꞌex tijikomal.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Uncheeꞌ aatz tek sotzsaj, tal u bꞌaal aqꞌon, tu u qꞌesal xeen aqꞌonom ech tzaꞌ: «Sikꞌle qꞌu aqꞌonom utz, choo qꞌul iqꞌii. Aꞌ bꞌaxal sachoo qꞌu yaꞌtebꞌal bꞌenchil. Utz ech tek qꞌu bꞌaxa bꞌenchil tu aqꞌon.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Anchituꞌ. Motx opon qꞌu aqꞌonom qꞌuꞌl alas 5 bꞌeni. Utz ijaꞌmel maꞌl qꞌii aqꞌon motx ikꞌula sijununil. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ech aatz motx opon qꞌu bꞌaxa okchil, aꞌ nichtitzꞌa aas maas ijaꞌmel siꞌchmotxikꞌuleꞌ tala. Pek jaꞌmel koꞌn paj maꞌl qꞌii aqꞌon ikꞌula sijununil. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ech aatz veet motx ikꞌultu qꞌul ijaꞌmel, xeꞌt motx iyaayoli u bꞌaal aqꞌon. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Utz tal te ech tzaꞌ: «Aatz qꞌu yaꞌtebꞌal okchil tu aqꞌon tziꞌ, maꞌl koꞌn oora vetmotxaqꞌonini. Utz ela koꞌn kujaꞌmel tuchꞌ vetaꞌana, kꞌuxh aal aatz oꞌ, vetmotxkꞌaxbꞌiꞌoꞌ utz, vetkuqꞌiꞌa paalyeꞌl qꞌii qiꞌ.» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tzaqꞌbꞌu u bꞌaal aqꞌon tu maꞌl u aqꞌonom ech tzaꞌ: «Vamiigo, yeꞌxhkam nivelqꞌaꞌaxh. Tan ¿yeꞌn koj kunukꞌa aas ijaꞌmel maꞌl qꞌii aqꞌon sunchoovaxh? ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Pek iqꞌo bꞌen vajaꞌmel tziꞌ utz, kuxh. Pek echat koꞌxh ichool qꞌu yaꞌtebꞌal okchil tu aqꞌon vetunbꞌana echaꞌ axh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Tan in koꞌxh tzii kam lunbꞌan tuchꞌ vunpuaj. Pek ¿oj nichiꞌon sakꞌuꞌl aas in bꞌaꞌn?» Texh u bꞌaal aqꞌon. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Aatz qꞌu bꞌaxa, tiyaꞌtebꞌal siꞌaneꞌ utz; aatz qꞌu yaꞌtebꞌal, tibꞌaxa siꞌaneꞌ. Tan sibꞌal qꞌuꞌl sikꞌlemal koꞌxhtuꞌ, pek bꞌiil koꞌn qꞌuꞌl txaael.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Uncheeꞌ tuul atich ok u Jesuus tiꞌ u bꞌey maꞌt tu Jerusaleen, ixaanseꞌl tibꞌ tuchꞌ kabꞌlaal qꞌul ichusulibꞌ utz, tal te ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Aatz cheel, maꞌtꞌoꞌ tu Jerusaleen. Utz soꞌoksal u Kꞌaola vaꞌl bꞌennaj koꞌn aanima tiqꞌabꞌ qꞌu qꞌesal oksan yol vatz Tioxh, tuchꞌ tiqꞌabꞌ qꞌu aa txumbꞌal tetz u oꞌtla mantaar. Ech samotxtal iyatzꞌleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Utz soꞌoksal tiqꞌabꞌ qꞌu puera aanima majte. Ech saeesal iqꞌii. Satzꞌuꞌmali utz, sataqꞌ jeꞌ vatz kurus. Loqꞌ titoxvaꞌ qꞌii saqꞌaavitzꞌpi.— Texh u Jesuus tu qꞌul ichusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Uncheeꞌ xaan opon u tixoj u Zebedeo kꞌatz u Jesuus. Aꞌ imol qꞌu titzꞌin utz, pecheꞌ kuꞌ siatz tiꞌ ijajax maꞌl bꞌaꞌnil te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Utz tal u Jesuus te ech tzaꞌ: —¿Kam asaꞌ?— Texh te. Tzaqꞌbꞌu u ixoj ech tzaꞌ: —Aꞌ unsaꞌ taꞌxh saaleꞌ aas sakꞌujeꞌ kaꞌvaꞌl qꞌu vitzꞌin sakꞌatza tu vaQꞌesalail; maꞌl tasebꞌal utz, vaꞌt tamax.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Tzaqꞌbꞌu Jesuus ech tzaꞌ: —Yeꞌ etootzaj kam nejajeꞌ. ¿Satz etxꞌakeꞌ sapaalex tu u mam il tzaꞌl vaꞌl sapaalkꞌin? Utz ¿satz etxꞌakeꞌ aas ech ekameꞌ unkameꞌ?— Texhtuꞌ. —Eeꞌ. Saiꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Tal paj u Jesuus te ech tzaꞌ: —Uncheeꞌ nojchit setxꞌakeꞌ aas aꞌ sapaalkꞌex tu u mam il tzaꞌl vaꞌl sapaalkꞌin utz, setxꞌakeꞌ aas ech ekam sakamex vunkameꞌ. Pek ech koj vekꞌujeꞌ tunsebꞌal netaleꞌ tziꞌ tuchꞌ tunmax tan, yitꞌ in koj aa yol tiꞌ taqꞌaxeꞌ. Pek aꞌ saetzan qꞌuꞌl tetz chit tu vunTat.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ech taꞌxh tabꞌi u yol lavat qꞌu chusulibꞌ tziꞌ, motx lakp iviꞌ tiꞌ qꞌu vinaj qꞌuꞌl itzaꞌqꞌ tibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Aatz u Jesuus, motx tek isikꞌle eluꞌl siatz utz, tal te ech tzaꞌ: —Etootzajle aatz qꞌu ijlenal tetz qꞌu puera aanima niꞌxhibꞌensa tibꞌ qꞌesala viꞌ qꞌuꞌl atil jaqꞌ imantaar. Utz aatz qꞌuꞌl atil tijleꞌm, vatz ikꞌuꞌl ikꞌuchax u tijleꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pek aatz texoꞌl, yitꞌ ech koj siꞌaneꞌ. Yeꞌk sejeꞌsa etibꞌ tan, abꞌil vaꞌl qꞌesalail isaꞌ, aꞌ vaꞌl maas lochol texoꞌl siꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Utz abꞌil vaꞌl aꞌ isaꞌ u qꞌesal ijleꞌm texoꞌl, yeꞌk sijeꞌsa tibꞌ. Pek aal aꞌ vaꞌl maas salochon texoꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tan echaꞌ u Kꞌaola vaꞌl bꞌennaj koꞌn aanima kꞌuxh vetꞌuli, aal koj vetilbꞌeli. Pek aal ul taqꞌ tibꞌ tiꞌ qꞌu aanima. Utz vetꞌulkamoj tiꞌ ichitpul qꞌu aanima tu paav.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Uncheeꞌ aatz tek kꞌasuꞌl u Jesuus tuchꞌ qꞌul ichusulibꞌ tu Jericoo, mam tenam xamich tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Utz atich kaꞌvaꞌl qꞌu moy kꞌujlich tu bꞌey. Ech tabꞌi aas u Jesuus vaꞌl nichipaaleꞌ, motx qetun taltu ech tzaꞌ: —¡KuBꞌaal, ituꞌxh ixalam u Daviid, txum kuvatz!— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Pek nichkoꞌnimajax iqꞌeqꞌun tu qꞌu aanima. Loqꞌ aal koꞌn motx qꞌeqꞌun tereꞌn utz, nichtaleꞌ: —¡KuBꞌaal, ituꞌxh ixalam Daviid, txum kuvatz!— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ech txakeꞌ tek u Jesuus. Isikꞌle ul utz, tal te ech tzaꞌ: —¿Kam u bꞌaꞌnil esaꞌ sunbꞌan sete?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ech tek motx tal te tzaꞌ: —KuBꞌaal, aꞌ kusaꞌ sailonoꞌ tuchꞌ qꞌu bꞌaqꞌ kuvatz tzaꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ech aatz u Jesuus tan, itxum chit iatz. Ech ikan qꞌu bꞌaqꞌ iatz utz, tu koꞌxh unmuꞌkꞌul, iloni. Utz xambꞌu tek tiꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Uncheeꞌ aatz tek motx opon najaꞌch u Jerusaleen utz, opon tu Betfagee, viꞌ u muunte vaꞌl Olivo. Aatz u Jesuus, ichaj bꞌen kaꞌvaꞌl qꞌul ichusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Utz tal te ech tzaꞌ: —Bꞌenojex tu u tal tenam sukuvatz bꞌen tziꞌ. Utz yak setil maꞌl u txutx bꞌuuro qitzel. Aꞌ imol maꞌl chelemla tal. Chittaj utz, iqꞌotaj ul ve. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Pek oj abꞌil maꞌj kam latal sete tiꞌ, letal te ech tzaꞌ: «U kuBꞌaal satxakunsan.» Chajex te. Ech oora sataqꞌ kꞌasuꞌl setiꞌ.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Pek sauch kajay u kam tziꞌ tan, itzojpu chit u yol vaꞌl alelka tu u alol tetz u yolbꞌal Tioxh aas tal ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","—Al tu qꞌu aanima qꞌuꞌl atil tikuenta Sioon ech tzaꞌ: «Abꞌitaj tan, suꞌul vetIjlenal texoꞌl vaꞌl maanxho. Tiꞌ koꞌn maꞌl chelem bꞌuuro atik jeꞌ, titzꞌin ijtzomla txokop.» Chajaxh.— Texh u Tioxh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ech motx bꞌen qꞌul ichusulibꞌ utz, ech iꞌana kam vaꞌl tal u Jesuus te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Tiqꞌo ul u txutx bꞌuuro tuchꞌ u chelem bꞌuuro. Ech motx taqꞌ jeꞌ qꞌul ichakeꞌt tiꞌ qꞌu bꞌuuro utz, jeꞌ u Jesuus tiꞌ u chelem bꞌuuro. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Uncheeꞌ aatz tek qꞌu mam tenam tan, xeꞌt motx iliiu kuꞌ qꞌul ichakeꞌt tibꞌey u Jesuus. Utz at qꞌabꞌaj tzeꞌ nichichokeꞌ. Ech nichtaqꞌ kuꞌ tibꞌey majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Utz nichmotxiqꞌeqꞌun qꞌu tenam qꞌuꞌl bꞌaxaich siatz tuchꞌ qꞌuꞌl xamich tiꞌ. Ech nimotxtal ech tzaꞌ: —¡Bꞌan bꞌaꞌnil eesaꞌoꞌ tu u tzaꞌl tzaꞌ! ¡Techalaxh, ituꞌxh ixalam Daviid! ¡Tan tibꞌii u kuBꞌaals Amlika vetꞌulkꞌaxh! ¡Techal u Tioxh tu Amlika!— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ech aatz tek opon u Jesuus tu Jerusaleen, mam tenam motx chokon taanima taqꞌo utz, motx tal tibꞌilaj ech tzaꞌ: —¿Abꞌil chaj vaꞌl tziꞌ?— Texh tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Utz motx tzaqꞌbꞌel tunjot aanima ech tzaꞌ: —U Jesuus atziꞌ, u alol tetz u yolbꞌal Tioxh vaꞌl aa Nazareet tikuenta Galilea.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Uncheeꞌ opon u Jesuus tu viqꞌanalil u totztioxh utz, tojcha eluꞌl kajay qꞌuꞌl nichikꞌayin tziꞌ utz, tuchꞌ qꞌuꞌl nichiloqꞌoneꞌ. Ixhutꞌpi qꞌul imeexha qꞌu chꞌexun puaj majte, tuchꞌ vikꞌujlebꞌal qꞌu aa kꞌaꞌy paroomaxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Utz tal te ech tzaꞌ: —Tzꞌibꞌamalka tu u Yolbꞌal Tioxh: «Aatz u votzotz tan, qꞌilabꞌ sikꞌlebꞌ tetz Tioxh ibꞌii alel.» Pek aatz ex, vetetaqꞌlu bꞌens tatibꞌal elqꞌom.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ech opon unjolol moy tuchꞌ unjot koꞌx kꞌatz u Jesuus tu viqꞌanalil u totztioxh. Utz ibꞌan bꞌaꞌn te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pek aatz qꞌu qꞌesal oksan yol vatz Tioxh tuchꞌ qꞌu aa txumbꞌal tetz u oꞌtla mantaar, motx lakp iviꞌ aas til qꞌu mamaj txaichil iꞌan u Jesuus. Utz lakp iviꞌ majte aas tabꞌi viqꞌeqꞌun ibꞌitz qꞌu talaj nitxaꞌ tu viqꞌanalil u totztioxh ech tzaꞌ: —¡Techal axh ituꞌxh ixalam Daviid!— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ech motx tek tal tu u Jesuus ech tzaꞌ: —¿Ni tzik aabꞌi vaꞌl nital qꞌu talaj nitxaꞌ tziꞌ?— Texh te. Tal u Jesuus te ech tzaꞌ: —Eeꞌ nichitvabꞌi. Pek ¿yetz sikꞌlemal u Yolbꞌal Tioxh setaqꞌo vaꞌl nital ech tzaꞌ?: «Niꞌxhitxꞌol ibꞌitzal Tioxh saaqꞌo qꞌu talaj nitxaꞌ tuchꞌ qꞌuꞌl an tereꞌn nichꞌuꞌneꞌ.» Chia.— Texh u Jesuus te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Pek elabꞌelka tu u Jesuus. Kꞌasuꞌl tu u tenam tziꞌ utz, aꞌ vatku tu Betaania. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ech aatz tek iꞌan qꞌalaꞌm, qꞌaavbꞌen u Jesuus tu Jerusaleen utz, kam tu vaꞌy tu bꞌey. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ech til maꞌl u tzeꞌil viikuxh tziꞌ bꞌey. Opon kꞌatza. Ex ichok ivatz, loqꞌ yeꞌkich maꞌj ivatz. Taꞌxh atich ixaj. Utz tal tek tzꞌejbꞌal yol tiꞌ ech tzaꞌ: —Yeꞌxhjatu veꞌt savatzinaxh.— Texh te. Ech yakich tzajoj u tzeꞌil viikuxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Aatz tilt u kam qꞌu chusulibꞌ tziꞌ, motx tzꞌejx ikꞌuꞌl. Utz nichtekmotxtal tibꞌilaj ech tzaꞌ: —¡Kan chaj tek tokeꞌ aas yakich koꞌxh vettzajoj u tzeꞌil viikuxh tziꞌ!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tzaqꞌbꞌu u Jesuus, ech tzaꞌ: —Niꞌxhtekꞌval sete, kꞌujlel koj chit ekꞌuꞌl tiꞌ Tioxh, yeꞌ koj nekaꞌtziiuneꞌ, echat koꞌxh sebꞌan majte. Utz yitꞌ taꞌn koꞌnkoxh sebꞌaneꞌ echaꞌ vaꞌl vetunbꞌan tu u tzeꞌil viikuxh. Ech oj setal tu u muunte tziꞌ: «Elenbꞌen; kuxh tu u choo tziꞌ.» Chajex te. Nojchit siꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Sakoꞌnenima. Ech sekꞌuleꞌ kam kajay vaꞌl sejaj tu veqꞌilat esikꞌlet Tioxh.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Uncheeꞌ opon u Jesuus tu viqꞌanalil u totztioxh utz, xeꞌt ichusuneꞌ. Tuul opon qꞌu qꞌesal oksan yol kꞌatza tuchꞌ qꞌu qꞌesal qꞌatol tzii utz, alax te ech tzaꞌ: —¿Kam iijleꞌm aas ech naꞌan tziꞌ? Utz ¿abꞌil vetaqꞌon val iijleꞌm tziꞌ?— Texh teꞌleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Tzaqꞌbꞌu u Jesuus utz, tal te ech tzaꞌ: —Sunchꞌoti maꞌl kam sete majte. Oj letzaqꞌbꞌe vaꞌl sunchꞌoti sete, saval sete abꞌil vetaqꞌon vijleꞌm tiꞌ qꞌu kam nunbꞌaneꞌ tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Abꞌil vetaqꞌon tijleꞌm u Xhan, u bꞌanol vautiismo, tiꞌ ibꞌanax vautiismo? ¿Tioxh tzik untzꞌoj sikꞌuꞌl koꞌn aanima cheeka?— Texh te. Ech nichtekmotxtal sivatzaj ech tzaꞌ: — «Tioxh chajon.» Oj chajoꞌ. «¿Kantuꞌ yeꞌt enima?» Chaj qe atziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Utz oj: «Aanima koꞌn chajon.» Saqaleꞌ, nikuxoꞌva qꞌu tenam tziꞌ. Tan nojchit alol tetz u yolbꞌal Tioxh u Xhan siatz.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ech motx itzaqꞌbꞌet u Jesuus ech tzaꞌ: —Yeꞌ qootzaj.— Texh te. Utz tal tek u Jesuus te ech tzaꞌ: —Uncheeꞌ yitꞌ saꞌkojval sete majte abꞌil aqꞌon vijleꞌm tiꞌ qꞌu kam nunbꞌaneꞌ tzaꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Tal paj u Jesuus: —Pek ¿kam bꞌoj saelka nenacheꞌ? Aatz maꞌl u vinaj, atich kaꞌvaꞌl ikꞌaol. Utz opon kꞌatz maꞌl, tal te ech tzaꞌ: «Unkꞌaol, seꞌnaqꞌoninaxh tu uuva cheel.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tzaqꞌbꞌu u xiak utz: «Yuꞌnsaꞌ.» Texh kuꞌen. Loqꞌ xamtel tuul ikꞌaxa utz, bꞌeni. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ech opon kꞌatz vaꞌte utz, echat koꞌxh paj tal te. Tzaqꞌbꞌu u xiak utz, tal ech tzaꞌ: «Oji tat, sabꞌenin.» Texhtuꞌ. Loqꞌ yeꞌt bꞌeni. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Uncheeꞌ ¿abꞌiste tu kaꞌvaꞌl qꞌu xiak inima imantaar vitat nenacheꞌ tziꞌ?— Texhtuꞌ. Ech alax te ech tzaꞌ: —Ayaꞌ u bꞌaxa.— Texh teꞌleꞌ. Tal paj u Jesuus te ech tzaꞌ: —Niꞌxhtekꞌval sete, aꞌ bꞌaxal soꞌok sevatz tu viQꞌesalail u Tioxh qꞌu subꞌulla chaj jajol jaꞌmel alkavaar tuchꞌ qꞌu aa paavla chaj ixoj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tan ul u Xhan texoꞌl. Aꞌ nichiꞌan vijikomal. Utz yeꞌt koꞌn motx enima aas ichaj Tioxh. Pek aal aꞌ niman qꞌu subꞌulla chaj jajol jaꞌmel alkavaar tuchꞌ qꞌu aa paavla chaj ixoj. Utz kꞌuxh etil qꞌu kam tziꞌ, yeꞌt ekꞌaxa qꞌul epaav. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Abꞌitaj vaꞌt u kꞌamich kam tzaꞌ. Atich maꞌl u bꞌaal nitxaꞌ, ichik untanul iuuva tu vitxꞌavaꞌ. Utz toksa peꞌ tiꞌ. Ikꞌot maꞌl pachꞌbꞌal tetz uuva tuul. Inukꞌ jeꞌ maꞌl u tꞌankin xeebꞌ tetz u chikobꞌeꞌm. Ech taqꞌtuka kꞌam tunjolol kꞌamol. Utz bꞌen tzian. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Uncheeꞌ opon tek u tiempo tetz iqꞌanbꞌebꞌal u uuva. Ichaj opon unjolol taqꞌonom u bꞌaal txꞌavaꞌ xeꞌ qꞌu kꞌamol tziꞌ, tiꞌ en tiqꞌol u kꞌambꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pek aatz qꞌu kꞌamol tziꞌ, motx koꞌn itxay qꞌu aqꞌonom qꞌuꞌl chajaxi. Utz maꞌl iqꞌosa. Vaꞌt iyatzꞌa. Utz vaꞌt ipaqꞌ sivan. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ech ichaj paj bꞌen unjoltu taqꞌonom u bꞌaal txꞌavaꞌ tziꞌ. Sibꞌalich tek ixaan vatz qꞌuꞌl ichaj bꞌen bꞌaxa utz, echat koꞌxh paj motx iꞌan qꞌu kꞌamol te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ech tiyaꞌtebꞌal tekuꞌen, aꞌ tek ichaj bꞌen vikꞌaol utz, tal ech tzaꞌ: «Atil tek bꞌoj tatin vunkꞌaol siatz siꞌaneꞌ atziꞌ.» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pek taꞌxh motx til topon u kꞌaola qꞌu kꞌamol txꞌavaꞌ tziꞌ, tal sivatzaj ech tzaꞌ: «Aꞌ vaꞌl soꞌokka tu vimeꞌbꞌiꞌl vitat atziꞌ. Pek ¡niꞌextaj! ¡Kuyatzꞌtaj! Ech oꞌ tek soꞌokkaꞌoꞌ tu qꞌu tetz.» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ech motx itxaya. Tiqꞌo eluꞌl tu u chikobꞌeꞌm utz, iyatzꞌa. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Uncheeꞌ ¿kam tek bꞌoj sabꞌanax tu qꞌu kꞌamol nenacheꞌ tziꞌ aas luꞌul u bꞌaal chikobꞌeꞌm?— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Motx tal ech tzaꞌ: —Yatzꞌel qꞌu onkonla chaj kꞌamol siꞌaneꞌ tziꞌ. Saꞌkojitxum iatz. Ech sataqꞌka kꞌam vichikobꞌeꞌm tunjoltu kꞌamol aas nojchit sataqꞌ u kꞌambꞌal tinujul chaj paj saqꞌanbꞌi.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tal tek u Jesuus te ech tzaꞌ: —¿Yetz sikꞌlemal tu u Yolbꞌal Tioxh setaqꞌo tzik? vaꞌl nital ech tzaꞌ: «Aatz u Sivan vaꞌl taqꞌka eloꞌp qꞌu bꞌanol otzotz echil tziꞌ, aal aꞌ u Sivan vaꞌl tiira ibꞌoꞌqꞌol tetz xoobꞌal. U kuBꞌaals Amlika vetbꞌanon u kam tziꞌ utz, techal sukuvatz.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ech tok nival sete, saeesal viQꞌesalail u Tioxh sevatz. Utz aꞌ saꞌaqꞌaxku tu aanima aas tinujul chit sataqꞌ tu u Tioxh vaꞌl sajajax te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ech abꞌil qꞌuꞌl sakuꞌ viꞌ u Sivan tziꞌ, sapaxi. Utz abꞌil qꞌuꞌl lakuꞌ u Sivan tiꞌ tziꞌ, bꞌaꞌntan sajuyajti.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ech taꞌxh tabꞌi u kꞌamich kam qꞌu qꞌesal oksan yol tzaꞌ tuchꞌ qꞌu fariseo, motx paal itxumbꞌal tuul aas aꞌ qꞌuꞌl nichtalaxeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Utz siꞌchmotxitxayeꞌ tala, pek nichixoꞌva qꞌu mam tenam. Tan nojchit aꞌ u alol tetz u yolbꞌal Tioxh u Jesuus vatz qꞌu tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Uncheeꞌ yolon paj u Jesuus tu qꞌu qꞌesala tiꞌ kꞌamich kam. Utz tal te ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Aatz viQꞌesalail u Tioxh tu Amlika, ela tuchꞌ maꞌl u ijlenal iꞌan nimla qꞌii tiꞌ itzumeꞌ vikꞌaol. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ech ichaj bꞌen ichaj tiꞌ en isikꞌlel qꞌu aanima qꞌuꞌl savsamich taqꞌo tiꞌ u tzumbꞌaꞌa. Pek yeꞌt koꞌn motx isaꞌa ulchil. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ech ichaj paj bꞌen unjolt ichaj utz, tal bꞌen te ech tzaꞌ: «Altaj tu qꞌuꞌl savsamal vaqꞌo ech tzaꞌ: Aatz cheel, veeti qꞌu echbꞌubꞌal. Vetvallu ikuꞌ qꞌul unvaakaxh tuchꞌ qꞌul unqꞌiitinajla txokop. Ech chꞌiam texh niꞌan u echbꞌubꞌal. Pek niꞌextaj tu u tzumbꞌaꞌa. Chajex te.» Texh teꞌleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pek yeꞌt koꞌn motx isaꞌa qꞌuꞌl savsamich. Motx koꞌn ichok ibꞌey. Maꞌl, bꞌen tu taqꞌon. Utz vaꞌt, tu kꞌaꞌy. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Utz aatz unjolte, motx koꞌn itxay qꞌu chaj; motx iꞌan te utz, iyatzꞌa. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ech aatz tabꞌi u ijlenal, lakpu tek iviꞌ. Ech tek ichaj bꞌen qꞌul isol. Ex isotzsa qꞌu yatzꞌol. Utz ikꞌachka vitenam. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ech tal tepaj u ijlenal tu qꞌul ichaj ech tzaꞌ: «Nojchit chꞌiam texh niꞌan qꞌu kam tetz u tzumbꞌaꞌa. Pek aatz qꞌuꞌl vetunsavsa, yeꞌ peꞌk nikꞌuloꞌk tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Pek aatz cheel, bꞌenojex tu qꞌu qꞌeꞌtx chaj bꞌey utz, savsataj ul tu u tzumbꞌaꞌa tzaꞌ jatvoꞌj aanima letila.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ech motx bꞌen qꞌu chaj tulaj qꞌeꞌtx chaj bꞌey. Utz imol kajay qꞌu aanima motx tila. At bꞌaꞌnla aanima utz; at yitꞌ bꞌaꞌnla koj aanima imola. Ech inoo u atibꞌal vaꞌl uchku u tzumbꞌaꞌa. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Uncheeꞌ oktekꞌop u ijlenal toꞌotzotz utz, til qꞌu aanima oponi. Utz til maꞌl u vinaj aas yitꞌ atich koj ok toksaꞌm tetz ilbꞌal tzumbꞌaꞌa. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Utz tal u ijlenal te ech tzaꞌ: «¿Vinaj kaniꞌch muukuꞌl tzaꞌ? Tan yeꞌ oknaj ooksaꞌm tetz ilbꞌal tzumbꞌaꞌa.» Texh te. Pek paat yeꞌt tzaqꞌbꞌu u vinaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ech tal tek u ijlenal tu qꞌul ixekol ech tzaꞌ: «Qitztaj u vinaj siqꞌabꞌs tajan tziꞌ utz, aqꞌtaj eloꞌp tu uken qꞌanal. Ech latziꞌ soꞌoqꞌka utz, latziꞌ sajarachꞌunku tee.» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tan sibꞌal qꞌuꞌl sikꞌlemal koꞌxhtuꞌ, pek bꞌiil koꞌn qꞌuꞌl txaael.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Uncheeꞌ ech tek motx telkꞌasuꞌl qꞌu fariseo utz, motx inukꞌ sivatzaj kaniꞌch itxaypu u Jesuus siꞌan tiꞌ maꞌj yol. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ech motx ichaj ul qꞌu tetz aa uqꞌaybꞌal. Aꞌ imol uli qꞌuꞌl oknaj tiꞌ u Herodes utz, tal tu u Jesuus ech tzaꞌ: —Chusul, qootzajle aas naal vinujul. Utz tinujul nachusun tiꞌ u bꞌey maꞌt xeꞌ Tioxh. Yitꞌ aꞌ koj nooksa tetz aanima utz, yitꞌ aꞌ koj nasaji kam tatin aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Pek kantal nanacheꞌ, al qe. ¿Bꞌaꞌn tzik aas nikuchoo jaꞌmel alkavaar tu ijlenal Cesar? Pek ¿oj yeꞌka?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ech aatz u Jesuus tan, yakich til u tonkonil qꞌu vinaj tziꞌ utz, tal te ech tzaꞌ: —¡Kaꞌvatz! ¿Kam tokeꞌ aas vet sekꞌuꞌl netal ve ech tziꞌ? ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Aqꞌtaj ul u puaj qabꞌi savil vaꞌl nechoobꞌev u jaꞌmel alkavaar.— Texh te. Ech motx ikꞌuchtu maꞌl puaj te, jaꞌmel maꞌl qꞌii aqꞌon. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Utz tal u Jesuus te ech tzaꞌ: —¿Abꞌil etz vatzibꞌal vaꞌl atoꞌk vatz u puaj tziꞌ utz; abꞌil etz bꞌii vaꞌl tzꞌibꞌamal ok siatz majte?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Utz motx tal ech tzaꞌ: —Tetz u ijlenal Cesar atziꞌ.— Texhtuꞌ. Ech tal paj u Jesuus: —Aqꞌtaj tu u Cesar kam tiꞌ vaꞌl ninalchoonkꞌex te. Utz aqꞌtaj tu u Tioxh abꞌiste u tetz u Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Taꞌxh tek motx tabꞌi u yol tziꞌ, motx tzꞌejx ikꞌuꞌl tiꞌ. Utz taqꞌtexhka u Jesuus, motx bꞌeni. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Uncheeꞌ ankoꞌxh tu u qꞌii tziꞌ, opon qꞌu saduceo kꞌatz u Jesuus. Ayaꞌ qꞌuꞌl nimotxniman aas yeꞌk saqꞌaavitzꞌpu qꞌu kamnaj nimotxtaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ech vet sikꞌuꞌl motx ichꞌoti te ech tzaꞌ: —Chusul, tal u Moisees aas: «Oj sakam maꞌl vinaj, yeꞌk initxaꞌa sakaai, sikꞌulka tibꞌ u tixoj tuchꞌ vitzaꞌqꞌ. Ech lachee ichꞌexel vaꞌl vetkami.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Pek aatz iꞌana, atich jujvaꞌl vinaj tu kuxoꞌl, itzaꞌqꞌ tibꞌ. Utz ikꞌul tibꞌ u bꞌaxa, pek kam koꞌn u vinaj tziꞌ. Yeꞌt kaa initxaꞌa. Ech ikꞌulka tibꞌ u tixoj tuchꞌ vitzaꞌqꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Utz echat koꞌxh paj iꞌan u kaꞌbꞌ tzaꞌqꞌ tuchꞌ u tox tzaꞌqꞌ, kam kuꞌen. Ech tzojpu koꞌxh sijujvaꞌ tziꞌ, motx kameꞌl vatz u ixoj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ech aatz maꞌtich ikameꞌl jujvaꞌl qꞌu vinaj, kam tek u ixoj majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Utz aatz tek tu u qꞌaavitzꞌpichil, ¿abꞌil tek etz ixoj u ixoj liꞌan tu jujvaꞌl qꞌu vinaj tziꞌ? Tan vetikꞌul tibꞌ tuchꞌ sikajayil.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tzaqꞌbꞌu tek u Jesuus utz, tala: —¡Tiira yolpinajex aabꞌi! Yeꞌ etootzaj u Yolbꞌal Tioxh utz, yeꞌ etootzaj u mam tijleꞌm u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tan aatz siꞌan tu u qꞌaavitzꞌpichil, yeꞌkan kꞌuliꞌbꞌ suꞌuchi. Tan ela tek qꞌu aanima tuchꞌ qꞌul iaanjel u Tioxh tu Amlika siꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pek aatz tiꞌ u qꞌaavtitzꞌpu qꞌu kamnaj netaleꞌ tziꞌ, ¿yetz sikꞌlemal setaqꞌo vaꞌl alel tu u Tioxh ech tzaꞌ? ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","«In viTioxh u Abrahaam, u Isaac, tuchꞌ u Jacoob.» Chia. Tan aatz u Tioxh, yitꞌ iTioxh koj kamnaj; pek iTioxh itzꞌlich.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ech motx tzꞌejx ikꞌuꞌl qꞌu aanima aas tabꞌi vichusbꞌal u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Uncheeꞌ taꞌxh tabꞌi qꞌu fariseo aas subꞌax qꞌu saduceo tu yol, motx tek imol tibꞌ tiꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ech aatz maꞌl u chusul tetz u oꞌtla mantaar tixoꞌl, vet koꞌxh sikꞌuꞌl ichꞌoti tu u Jesuus ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Chusul, ¿abꞌiste chit u mantaar vaꞌl tiira ibꞌoꞌqꞌol tu u oꞌtla mantaar?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tal u Jesuus te ech tzaꞌ: — «Tzꞌejoj avaanima tiꞌ u Tioxh u kuBꞌaal tuchꞌ avaanima, tuchꞌ avaanxelal utz, tuchꞌ atxumbꞌal.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Aꞌ u bꞌaxa utz, aꞌ vibꞌoꞌqꞌol u mantaar tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Utz aatz u kaꞌbꞌ mantaar, ela koꞌn tuchꞌ u bꞌaxa tziꞌ. Utz nital ech tzaꞌ: «Tiiꞌaxh tiꞌ amol, echat koꞌxhtuꞌ naꞌan saiꞌ.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ech aatz kaꞌvaꞌl u mantaar tziꞌ, aꞌ vixeꞌal kajay u oꞌtla mantaar tuchꞌ viyol qꞌu alol tetz u yolbꞌal Tioxh.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Uncheeꞌ tuul ankoꞌxh molich tibꞌ qꞌu fariseo, chꞌotil te tu u Jesuus ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Kam bꞌoj netal tiꞌ viTxaaom u Tioxh? ¿Abꞌil etz tuꞌxh xalam netaleꞌ?— Texh te. Alax te ech tzaꞌ: —Ituꞌxh ixalam u Daviid.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Tal u Jesuus te: —¿Kam tokeꞌ uncheeꞌ aas “UnBꞌaal” texh u Daviid tiꞌ viTxaaom u Tioxh? U Tioxhla Espiiritu oksan sikꞌuꞌl aas tal ech tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","«Aatz u Tioxh tal tu vunBꞌaal ech tzaꞌ: Kꞌujach tunsebꞌal tan, saꞌnalvaqꞌka qꞌul akoontra jaqꞌ axaabꞌ. Chia.» Texh u Daviid. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tan oj “unBꞌaal” texh u Daviid tiꞌ, ¿kam tek tokeꞌ oj ituꞌxh ixalam kuꞌen netaleꞌ?— Texh u Jesuus te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ech yeꞌxhabꞌil maꞌj txꞌolon itzaqꞌbꞌeleꞌ. Utz abꞌil tereꞌn koj vaꞌtoj chꞌotin kam te tu qꞌu qꞌii taabꞌaul. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Uncheeꞌ yolon u Jesuus tu qꞌu tenam tuchꞌ tu qꞌul ichusulibꞌ. Tal te ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Aatz qꞌu aa txumbꞌal tetz u oꞌtla mantaar tuchꞌ qꞌu fariseo, atil chit tijleꞌm tiꞌ ichusax qꞌul imantaar u Moisees. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ech kam qꞌu mantaar satal sete, nimataj utz, bꞌantaj. Pek etilchoꞌk etetz tiꞌ qꞌul ibꞌanoneꞌ. Tan nitaleꞌ utz, yeꞌ nimotxiꞌan bꞌanol tetz. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tan kaana bꞌoj mantaar nital tu qꞌu aanima aas tiira tii nimali. Taꞌxhtuꞌ aꞌ nitaleꞌ sabꞌanli. Echaꞌ iqitzax mam ijatz niꞌaneꞌ utz, nitaqꞌ jeꞌ tiviꞌ qꞌu aanima. Pek jatu koj sikanoꞌk bꞌioj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Utz aatz kajay qꞌu kam nimotxiꞌaneꞌ, aꞌ chit isaꞌ sailax tu aanima. Echaꞌ qꞌu talaj ikaaxha qꞌuꞌl tzꞌibꞌamal kaꞌxvaꞌl u mantaar tuul, niꞌxhmotxinimbꞌixsa. Utz niꞌxhichꞌiisa tajan ibꞌoy qꞌul ibꞌuꞌj qꞌuꞌl nitoksa aas niqꞌila sikꞌle Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Aꞌ chit isaꞌ kuꞌchil tu qꞌu bꞌaxa chaj kꞌujlebꞌal til niuchku txꞌaꞌom. Utz aꞌ chit nikꞌujeꞌk tu qꞌu bꞌaxa chaj kꞌujlebꞌal tu qꞌu atibꞌal chusbꞌal tetz u oꞌtla mantaar majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Utz vatz chit ikꞌuꞌl aas nitalax ichajlichil tu kꞌayibꞌal. Utz “chusul” chu teꞌl majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pek aatz ex tan, esaꞌchi aas “chusul” chaj eteꞌleꞌ. Tan maꞌl koꞌn u Chusul etetz atile, ayaꞌ viTxaaom u Tioxh. Utz ela koꞌn etitzꞌin etatzik etibꞌ sekajayil. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Utz yeꞌ koꞌxh etal “tat” tu maꞌj chusul tu u vatz txꞌavaꞌ tzaꞌ. Tan maꞌl koꞌn eTat atile, vaꞌl ayeꞌn tu Amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Utz yeꞌ koꞌxh alax “chusul” sete majte. Tan maꞌl koꞌn u Chusul etetz atile, ayaꞌ viTxaaom u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Utz abꞌiste vaꞌl qꞌesala texoꞌl, yeꞌk sijeꞌsa tibꞌ. Pek aꞌ vaꞌl maas salochoni. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tan abꞌil vaꞌl sitꞌanbꞌaꞌ tibꞌ, sakoꞌnel iqꞌii. Pek abꞌil vaꞌl yeꞌ sitꞌanbꞌaꞌ tibꞌ, aꞌ vaꞌl soꞌok iqꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Pek ¡tiira tilayol sayaꞌkꞌex kaꞌvatzla chaj aa txumbꞌal tetz u oꞌtla mantaar tuchꞌ ex fariseo! Tan nemaj u okebꞌal tu viQꞌesalail u Tioxh vatz qꞌu aanima. Nikoꞌxh ex nesaꞌa okichꞌop utz, yeꞌ netaqꞌ tzii soꞌokoꞌp qꞌuꞌl nisaꞌa okichꞌop. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Tiira tilayol sayaꞌkꞌex kaꞌvatzla chaj aa txumbꞌal tetz u oꞌtla mantaar tuchꞌ ex fariseo! Tan netelqꞌa tzaj txakay ixoj. Utz yeꞌ sekꞌuch netaleꞌ. Nikoꞌxh ebꞌanoꞌk sibꞌ chit tuul qꞌul eqꞌilat esikꞌlet Tioxh nebꞌaneꞌ. Ech tokeꞌ sibꞌ u choobꞌal paav saꞌalax ikuꞌ setiꞌ tiꞌ u subꞌuꞌm nebꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Tiira tilayol sayaꞌkꞌex kaꞌvatzla chaj aa txumbꞌal tetz u oꞌtla mantaar tuchꞌ ex fariseo! Tan til chaj koꞌxh nechokvu niman tetz qꞌul etuqꞌaybꞌal. Utz aatz maꞌt ibꞌens emol, epaav koꞌn aas kaꞌpajul tek nikꞌuloꞌk tiꞌ seꞌen tu choobꞌal paav taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Tiira tilayol sayaꞌkꞌex! Ech ex moyla iqꞌon bꞌey tan, nimotxetaleꞌ: «Abꞌil vaꞌl kam nitalaꞌtziꞌi tu u Tioxh, loqꞌ taꞌn nitoksa viqꞌanalil u totztioxh tuul, ela koꞌxh tuchꞌ yeꞌxhkam maꞌj nitalaꞌtziꞌi. Pek abꞌil vaꞌl aꞌ nitoksa u bꞌaꞌnla qꞌan chꞌichꞌ atil tu u totztioxh tu vaꞌl nitalaꞌtziꞌi, aa txꞌoj tekuꞌen.» Cheꞌex. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Txoxkin! ¡Jolol ech ex moy! Abꞌiste vaꞌl maas ibꞌoꞌqꞌol te nenacheꞌ, ¿u bꞌaꞌnla qꞌan chꞌichꞌ tzik, oj ayaꞌ viqꞌanalil u totztioxh vaꞌl niaqꞌon bꞌens tioxhla kam u bꞌaꞌnla qꞌan chꞌichꞌ? ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Tan nipajetal ech tzaꞌ majte: «Abꞌil vaꞌl taꞌn nitoksa u nachbꞌal tuul tiꞌ vaꞌl nitalaꞌtziꞌi, ela koꞌxh tuchꞌ yeꞌxhkam nitalaꞌtziꞌi. Pek abꞌil vaꞌl aꞌ nitoksa u txakunsaꞌm tuul, vaꞌl atil viꞌ u nachbꞌal tiꞌ vaꞌl nitalaꞌtziꞌi, aa txꞌoj tekuꞌen.» Cheꞌex. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Pek ¡taꞌxh bꞌanloj etetz, paat ech ex moy! ¿Abꞌiste maas ibꞌoꞌqꞌol te nenacheꞌ, u txakunsaꞌm tzik, oj u nachbꞌal vaꞌl aꞌ niaqꞌon bꞌens tioxhla kam u txakunsaꞌm? ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Tan abꞌil vaꞌl nitoksa u nachbꞌal tiꞌ vaꞌl nitalaꞌtziꞌi, yitꞌ taꞌn koꞌnkoxh u nachbꞌal nitoksa, pek antu nitok tuul majte kajay vaꞌl atil jeꞌ siiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Utz abꞌil vaꞌl nitoksa u totztioxh tiꞌ vaꞌl nitalaꞌtziꞌi, yitꞌ taꞌn koꞌnkoxh u totztioxh nitoksa, pek antu nitoksa majte u Tioxh vaꞌl atil tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Utz abꞌil vaꞌl nitoksa u Amlika tiꞌ vaꞌl nitalaꞌtziꞌi, antu nitoksa tuul u qꞌesal chꞌuxhlebꞌal tetz u Tioxh utz, tuchꞌ u Tioxh vaꞌl chꞌuxhlel siiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Tiira tilayol sayaꞌkꞌex kaꞌvatzla chaj aa txumbꞌal tetz u oꞌtla mantaar tuchꞌ ex fariseo! Tan kꞌuxh netaqꞌ idiesmoil u aanis, u eneeldo utz, tuchꞌ komino, aꞌ yeꞌ nenima qꞌuꞌl tiira ibꞌoꞌqꞌol tu u oꞌtla mantaar. Ayaꞌ vijikomal. Ayaꞌ vitxumax iatz aanima. Ayaꞌ vikꞌujeꞌ ekꞌuꞌl tiꞌ u Tioxh. Aꞌ vibꞌoꞌqꞌol sebꞌaneꞌ. Loqꞌ yitꞌ tiꞌ tekoj majte aas seyaꞌsa ibꞌanax vaꞌl ninalebꞌan tiꞌ qꞌu diesmo. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Moyla chaj iqꞌon bꞌey! Taꞌxh bꞌaꞌn sete tilax qꞌu talaj kam niꞌan qꞌu aanima sevatz. Echaꞌ ikꞌaul u tal us nebꞌaneꞌ. Pek yeꞌxhat niꞌenku qꞌu mamaj paav sete qꞌuꞌl nebꞌaneꞌ echaꞌ ichꞌii camello. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Tiira tilayol sayaꞌkꞌex kaꞌvatzla chaj aa txumbꞌal tetz u oꞌtla mantaar tuchꞌ ex fariseo! Tan tiira bꞌaꞌn nebꞌensav etibꞌ setiꞌ eluꞌl. Pek kaana elaqꞌ nital etaanima. Utz yeꞌk eyaꞌebꞌal tiꞌ ibꞌanax qꞌuꞌl yitꞌ inujul. Ech ex aꞌ u vaaso tuchꞌ u puraato vaꞌl taꞌxh txꞌaael u tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Moyla chaj fariseo! Aꞌ bꞌaxal sebꞌan bꞌaꞌn tu vetaanima, ech yitꞌ yannaj koj vetiꞌ eluꞌl majte. Aꞌ bꞌaxal setxꞌaa u tuul u vaaso tuchꞌ u puraato, ech setxꞌaa u tiꞌ majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Tiira tilayol sayaꞌkꞌex kaꞌvatzla chaj aa txumbꞌal tetz u oꞌtla mantaar tuchꞌ ex fariseo! Ech ex aꞌ qꞌu pantioon aas nojchit txꞌanel itzꞌakal u tiꞌ. Pek aatz u tuul tan, vitzuꞌl utz; bꞌajil kamnaj yojlel tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Utz ech ex tan, nojchit ex jikom tilon vatz aanima, pek kaꞌvatzil atil tetaanima tuchꞌ paav. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Tilayol sayaꞌkꞌex kaꞌvatzla chaj aa txumbꞌal tetz u oꞌtla mantaar tuchꞌ ex fariseo! Vaꞌl chit motx ebꞌantu pantioon tetz qꞌu alol tetz u yolbꞌal Tioxh. Utz nevij qꞌu tzꞌach qꞌuꞌl atil jeꞌ viꞌ u mujbꞌal tetz qꞌu jikomla chaj aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Utz nimotxetal ech tzaꞌ: «Atichtekojoꞌ tikuenta qꞌu kukꞌuy kumam, yeꞌt kuloch tiꞌ iyatzꞌax qꞌu alol tetz u yolbꞌal Tioxh koj atziꞌ.» Cheꞌex. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ech ex atkoꞌxh nialon eluꞌl etibꞌ aas ex ituꞌxh ixalam qꞌuꞌl yatzꞌon qꞌu alol tetz u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Tiꞌex! ¡Bꞌantaj vibꞌanon qꞌul ekꞌuy emam majte! ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Txokop, tiil txꞌiꞌla chaj aanima! ¿Kaniꞌch bꞌoj etel vatz u choobꞌal paav vaꞌl saꞌalax ikuꞌ setiꞌ nenacheꞌ? Ayaꞌ u xamal vaꞌl yeꞌk iyaꞌeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ech tokeꞌ nunchajuꞌl alol tetz u yolbꞌal Tioxh texoꞌl, tuchꞌ aa txumbꞌal utz, tuchꞌ chusul tetz u oꞌtla mantaar. Pek atia nikoꞌneyatzꞌeꞌ. At netaqꞌ jeꞌ vatz kurus. At netzꞌuꞌma tu qꞌu atibꞌal chusbꞌal tetz u oꞌtla mantaar. Utz atia junun tenam ebꞌen tiꞌ tojchaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ech kajay u choobꞌal paav sakuꞌl setiꞌ, tiꞌ iyatzꞌax qꞌu jikomla chaj aanima tu u vatz txꞌavaꞌ tzaꞌ. Ayaꞌ qꞌuꞌl kami; nixeꞌt tiꞌ vikamebꞌal u Abeel, u jikomla vinaj utz, ulyu koꞌxh tiꞌ vikamebꞌal u Zacarias, vikꞌaol u Berequias vaꞌl yatzꞌax tu qꞌul ekꞌuy emam tixoꞌl u totztioxh tuchꞌ u nachbꞌal Tioxh qꞌanal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Utz niꞌxhtekꞌval sete, sakuꞌ u choobꞌal paav setiꞌ tziꞌ jankꞌal ex itzꞌlelex tu u tiempo tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Aa chaj Jerusaleen, aa chaj Jerusaleen, nikoꞌneyatzꞌ qꞌu alol tetz u yolbꞌal Tioxh, qꞌuꞌl nichajax tzexeꞌ tu u Tioxh. Utz nikoꞌnepaqꞌ sivan majte. Jatpax unbꞌan yaꞌl emolax sekajayil. Echaꞌ niꞌan u txutx tꞌel aas nimoloꞌk qꞌu tal jaqꞌ ixichꞌ. Pek aatz ex, yeꞌ koꞌn esaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ech aatz cheel, setootzaji tan, saꞌnaltzꞌineꞌka vaꞌl tatibꞌal etioxh netaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tan nojchit nivaleꞌ, aatz cheel, sayaꞌ etiltꞌin. Utz analen paj letilin aas letal ech tzaꞌ: «Techal axh tan, tibꞌii u kuBꞌaals Amlika vetꞌulkꞌaxh.» Chajex.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Uncheeꞌ aatz kꞌasuꞌl u Jesuus tu viqꞌanalil u totztioxh, aꞌ tek ibꞌenaꞌ, xaan opon qꞌul ichusulibꞌ kꞌatza utz, nichisaji qꞌu mamaj atibꞌal tikuenta u totztioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Aatz u Jesuus tan, tal te ech tzaꞌ: —Niꞌxhtekꞌval sete. Aatz kajay qꞌu kam netileꞌ tziꞌ, saꞌnalnilpi. Nikoꞌxh vaꞌtoj sivan sakaa tibꞌa imol aas yeꞌk koj sanilpeꞌl.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Uncheeꞌ kꞌujlich u Jesuus viꞌ u muunte vaꞌl Olivo. Opon qꞌu chusulibꞌ kꞌatza utz, ichꞌoti te ech tzaꞌ aas taꞌxhich imol: —¿Al qe jatu suꞌuch qꞌu kam naaleꞌ tziꞌ? Utz ¿kam xheenya siꞌaneꞌ tetz val uulebꞌal utz, tetz u motxebꞌal qꞌii saj?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tzaqꞌbꞌu u Jesuus ech tzaꞌ: —Abꞌitaj, abꞌilich subꞌunex. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tan sibꞌal koꞌxh sauli, sikꞌam tiꞌ vunbꞌii. Utz satal ech tzaꞌ: «In viTxaaom u Tioxh vaꞌl saꞌchitꞌuli.» Chaj. Utz sibꞌal aanima sisubꞌeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Saꞌnaletabꞌi tuch chꞌaꞌo. Setabꞌi iyolax chꞌaꞌo. Pek sotziꞌch ekꞌuꞌl taqꞌo tan, ministeer chit suꞌuch qꞌu kam tziꞌ. Loqꞌ yitꞌ aꞌ koj u motxebꞌal qꞌii saj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tan saꞌnalmotxiꞌan chꞌaꞌo qꞌu mamaj tenam tibꞌilaj. Siꞌan chꞌaꞌo qꞌu qꞌesal mamaj tenam tibꞌilaj. Utz til chaj koꞌxh saulku mamaj yaabꞌil. Til chaj koꞌxh saꞌatinku vaꞌy. Utz til chaj koꞌxh sapaalku mamaj kabꞌnaano. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Loqꞌ aatz kajay qꞌu kam tziꞌ, ixeꞌtebꞌal koꞌn u motxebꞌal qꞌii saj. Echaꞌ ixeꞌt ichiꞌon maꞌl ixoj aas saꞌtektil titzꞌin. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Pek aatz ex, saꞌnalpaasalex tu kꞌaxkꞌo. Saixvalex tu kajay aanima viꞌ. Utz sayatzꞌaxex. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ech sibꞌal koꞌxh saelka kꞌatz Tioxh siꞌaneꞌ. Saꞌtexhmotxitxay jeꞌ imol utz, sichiꞌkꞌula jeꞌ tibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Sibꞌal koꞌxh sibꞌensa tibꞌ alol tetz u yolbꞌal Tioxh siꞌaneꞌ utz, sateesa aanima tu bꞌey titxubꞌaꞌleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Utz tu takꞌbꞌu u paav tu u vatz txꞌavaꞌ, sayaꞌ ibꞌantu tii qꞌu aanima tibꞌilaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pek abꞌiste vaꞌl tiira siqꞌiꞌeꞌ simaj tibꞌ tiꞌ ibꞌanax u paav, aꞌ vaꞌl soꞌopon tu bꞌenqꞌii bꞌensaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ech saꞌnaltzojp eloꞌp itziiul u bꞌaꞌnla chusbꞌal tetz viQꞌesalail u Tioxh tu kajay u vatz amlika txꞌavaꞌ tzaꞌ, satabꞌi qꞌu tenam kajayil. Ech suꞌul u motxebꞌal qꞌii saj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","Utz aatz letil tuch u txaaꞌla kam tu u tioxhla atibꞌal, oojoj bꞌen tulaj muunte qꞌuꞌl atil tikuenta Judea. Tan aꞌ vaꞌl tal u Danieel atziꞌ, u alol tetz u yolbꞌal Tioxh, aas suꞌuchi. Ech abꞌil nisikꞌlen, paaloj itxumbꞌal tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Utz abꞌil atil jeꞌop viꞌ tatibꞌal, kuꞌichꞌul tereꞌn toꞌotzotz tiꞌ paal tiqꞌol maꞌj kam. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Utz abꞌil ayeꞌn jaꞌjtzeꞌ, qꞌaaviꞌchtereꞌnul tiꞌ ul tiqꞌol ichakeꞌt. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Pek tiira tilayol sayaꞌk qꞌu ixoj siꞌan tu qꞌu qꞌii tziꞌ qꞌuꞌl atil tu tiichajla yaabꞌil utz, tuchꞌ qꞌuꞌl nichꞌuꞌn titzꞌin. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Qꞌilataj sikꞌletaj Tioxh ech yitꞌ titiempoil koj cheꞌv laoojex utz, nikoꞌxh tu u ilanbꞌal qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tan nojchit mamala kꞌaxkꞌo vaꞌl suꞌuli. Yeꞌsaj tuch unpajoj jatvaꞌx tiempo ichee u vatz amlika txꞌavaꞌ ulyu koꞌxh tzaꞌ tuul. Utz yitꞌ saꞌkojul vaꞌte echi. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ech abꞌil koj vaꞌtoj sitxaaka tibꞌ. Pek iqꞌaqꞌal koꞌn qꞌu aanima niman tetz u Tioxh, qꞌul itxaaom, sakꞌolax u tiempo kꞌaxkꞌo tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ech tokeꞌ enimachi oj abꞌil laꞌalon sete ech tzaꞌ: «Sajitaj etileꞌ, atil viTxaaom u Tioxh tzaꞌ vaꞌl saꞌchitꞌuli.» Chaj. Utz oj: «Atil tzuta.» Chaj eteꞌl majte; enimachi. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tan saꞌnalmotxchee bꞌensanibꞌ itxaaom Tioxh utz, tuchꞌ bꞌensanibꞌ alol tetz u yolbꞌal Tioxh. Utz kaana mamaj xheenya, tuchꞌ txaichil sichuli. Aal bꞌaꞌn siꞌaneꞌ at qꞌu nojla itxaaom u Tioxh sisubꞌeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pek atoj sekꞌuꞌl tan, vetvallukeꞌl sete. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ech oj laꞌalax sete ech tzaꞌ: «Sajitaj etileꞌ. Atil viTxaaom u Tioxh tu tzꞌinlich tzaji txꞌavaꞌ.» Chaj; bꞌeniꞌch etileꞌ. Utz oj: «Atil tu u atibꞌal yeꞌ naꞌl tatineꞌ.» Chaj eteꞌl majte; enimachi. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Pek aatz u nojla tulebꞌal u Kꞌaola vaꞌl bꞌennaj koꞌn aanima, nimnaꞌl. Echaꞌ u itzꞌnaꞌbꞌ aas niripkabꞌin tikuenta aal telaꞌ utz, yak paqꞌunoj opon tikuenta aal tokeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Echat koꞌxh u vulebꞌal, yitꞌ mujel koj siꞌaneꞌ. Tan echaꞌ vaꞌl aas til atilku vichiꞌl u kamnaj, vaꞌl yitꞌ mujel koj, latziꞌ nimolvu tibꞌ qꞌu quꞌs. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Uncheeꞌ taꞌxh sapaal u mam kꞌaxkꞌo tu qꞌu qꞌii tziꞌ, saok aqꞌbꞌal vatz u qꞌii. Yeꞌkan satxijtxun u ichꞌ. Sachajpu qꞌu txꞌumiꞌl tu amlika. Utz sayikun kajay qꞌu kam tu u vatz amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ech sachee u xheenya tu amlika tetz u tulebꞌal u Kꞌaola vaꞌl bꞌennaj koꞌn aanima. Utz kajay qꞌu aanima tu u vatz txꞌavaꞌ tzaꞌ sailon. Ech sikꞌaxa jeꞌ tibꞌ, tiꞌ qꞌul ipaav. Utz soꞌoqꞌi aas satil tul u Kꞌaola vaꞌl bꞌennaj koꞌn aanima tu sutzꞌ tu amlika. Tan toxhqꞌebꞌal tul tu u mam itechalil tu u tijleꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Xoꞌvebꞌal ijeꞌ iviꞌ u trompeta siꞌaneꞌ. Ech sichajuꞌl qꞌu aanjel, seꞌnimol qꞌu niman tetz u Tioxh tu kaa tanul vikuentail u vatz amlika txꞌavaꞌ. Kꞌuxh til chaj koꞌxh atilku tijuꞌaj u vatz amlika txꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Pek atoj bꞌenku sete u chusbꞌal tiꞌ u viikuxh. Tan aꞌ nital tul u saqꞌi aas nichaꞌxbꞌu viqꞌabꞌ utz, niteluꞌl talaj ixaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Echat koꞌxh majte, etootzajitaj aas tiira najabꞌyu u tulebꞌal u Kꞌaola vaꞌl bꞌennaj koꞌn aanima aas luꞌuch kajay qꞌu kam tziꞌ. Echaꞌ atil tek vatz jubꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tan niꞌxhtekꞌval sete, yeꞌsajen koꞌxh isotz untanul qꞌu aanima itzꞌlel tu tiempo tzaꞌ, tuul suꞌuch kajay qꞌu kam tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Sakoꞌnpaal u vatz amlika txꞌavaꞌ tzaꞌ, pek aatz vunyolbꞌal tan, jatu koj sapaali. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ech koj u qꞌii tuchꞌ u oora u tulebꞌal tan, abꞌil koj ootzajin tetz. Nikoꞌxh qꞌu aanjel tu Amlika, nikoꞌxh u Kꞌaola vaꞌl bꞌennaj koꞌn aanima, pek taꞌxh vunTat. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Tan kam chit echaꞌ vaꞌl iꞌan qꞌu aanima tu qꞌu qꞌii tikuenta u Noee aas yeꞌk talcheꞌ ul u sotzchil tiꞌ, echat tul u Kꞌaola vaꞌl bꞌennaj koꞌn aanima majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tan taꞌxh nichtitzꞌa u tatin qꞌu aanima iꞌan tu qꞌu qꞌii aas yeꞌsajich ikuꞌ u mam jabꞌal tikuenta u Noee. Vaꞌlich motx techbꞌuneꞌ, vaꞌl iqꞌabꞌaneꞌ. Vaꞌlich koꞌn tuch okchil tiꞌ ixoj. Utz vaꞌlich koꞌn motx itzumeꞌaꞌ, tuul opon u qꞌii aas ok tek u Noee tu u mam arca atibꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Utz at koj motx bꞌenku te; yeꞌt motx inima. Pek analen aas ul u mam jabꞌal. Utz yakich sotz kajay qꞌu aanima taqꞌo. Echat u tulebꞌal u Kꞌaola siꞌan majte vaꞌl bꞌennaj koꞌn aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Aatz liꞌana, kaꞌvaꞌl aanima ela nitaqꞌonin jaꞌjtzeꞌ. Maꞌl saiqꞌol bꞌen utz, vaꞌt sakaaka. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kaꞌvaꞌl ixoj nicheꞌn tu maꞌl cheꞌbꞌal siꞌaneꞌ. Maꞌl saiqꞌol bꞌen utz, vaꞌt sakaaka. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ech tokeꞌ, tiira nachnoj etatineꞌ tan, yeꞌ etootzaj kam oora suꞌul u kuBꞌaal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pek abꞌitaj. Tootzajlu koj u bꞌaal atibꞌal kam chit oora seꞌnelqꞌoj u elqꞌom tzixeꞌ, saxeeni atziꞌ. Utz saꞌkojtaqꞌ tzii soꞌok toꞌotzotz. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Echat koꞌxh ex majte. Chꞌianojex tan, yeꞌk u oora sekꞌuꞌl vaꞌl suꞌulku u Kꞌaola vaꞌl bꞌennaj koꞌn aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Pek abꞌiste sete ech siꞌaneꞌ u tzakꞌkin jikomla aqꞌonom saoksalka qꞌesala tiꞌ tilax qꞌu aqꞌonom tu atibꞌal utz, tu chit u oora sataqꞌvu techbꞌubꞌal qꞌuꞌl atil tu atibꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Chiꞌbꞌebꞌal tetz u aqꞌonom oj ech siꞌan tziꞌ, tuul loꞌopon u bꞌaal taqꞌon. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tan niꞌxhtekꞌval sete aal saꞌtektoksa kajay vimeꞌbꞌiꞌl tikuenta atziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pek yeꞌxtxoj koj itxumbꞌal u aqꞌonom tziꞌ, sakoꞌntal tu taanima ech tzaꞌ: «Yeꞌsaj koꞌxh suꞌul u bꞌaal vaqꞌon atziꞌ.» Chaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Utz sakoꞌnxeꞌtiqꞌos qꞌu tetz aqꞌonomil. Satxꞌaꞌni utz, saqꞌabꞌan tuchꞌ qꞌu qꞌabꞌareel. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tuul yeꞌk talcheꞌ suꞌul u bꞌaal taqꞌon u aqꞌonom tziꞌ tu u qꞌii vaꞌl yeꞌ tootzaj utz, tu u oora vaꞌl yeꞌxhkam nichꞌian tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ech techal chit iveet sabꞌanax tu u bꞌaal taqꞌon. Sataqꞌ bꞌen xoꞌl qꞌu kaꞌvatz utz, aꞌ saoqꞌku tziꞌ, aꞌ sajarachꞌunku tee tziꞌ.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Uncheeꞌ tal paj u Jesuus ech tzaꞌ: —Aatz viQꞌesalail u Tioxh tu Amlika, ela tuchꞌ laval qꞌu ixviak. Motx kꞌasuꞌl. Tiqꞌo itxijtxubꞌal utz, ex ikꞌul u xiak vaꞌl satzumeꞌi. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Oꞌvaꞌl tzakꞌkin qꞌu ixviak tziꞌ utz, oꞌvaꞌt txoxkin. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Aatz qꞌu txoxkin, motx tiqꞌo itxijtxubꞌal, pek yeꞌt tiqꞌo bꞌen tereꞌn iaseite tetz qꞌul itxijtxubꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pek ech koj qꞌu tzakꞌkin, inoosa bꞌen qꞌul itxijtxubꞌal tu aseite utz, tiqꞌo bꞌen tereꞌn tetz. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Pek bꞌatz tul u xiak vaꞌl satzumeꞌi. Ech motx xeꞌt ixhutꞌuꞌpan qꞌu ixviak tu vataꞌm sikajayil. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Uncheeꞌ aatz nikꞌa aqꞌbꞌal, motx tabꞌi maꞌl u qetuꞌm, tal ech tzaꞌ: «¡Tul u xiak vaꞌl satzumeꞌi, uloj ekꞌuleꞌ!» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ech motx lakpu qꞌu ixviak sikajayil utz, motx xeꞌt ibꞌan tuch qꞌul itxijtxubꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Pek aatz qꞌu txoxkinla chaj ixviak, motx tal tu qꞌu tzakꞌkin ech tzaꞌ: «Aqꞌtaj bꞌoj qetz veaseite tziꞌ tan, toj tzaaoj qꞌu kutxijtxubꞌal.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Aatz qꞌu tzakꞌkin tan, motx tzaqꞌbꞌu ech tzaꞌ: «Yeꞌka, pek aal bꞌaꞌn bꞌenoj eloqꞌ etetz xeꞌ aa kꞌaꞌy tetz tan, yoꞌj takꞌa qetz. Utz yoꞌj takꞌa etetz oj saqaqꞌ etetz.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ech motx bꞌeni. Tuul koꞌxh ayeꞌnich tiꞌ iloqꞌaxeꞌ, tuul ul u xiak vaꞌl satzumeꞌi. Utz aatz qꞌuꞌl bꞌanich nal tucheꞌ, motx okoꞌp toꞌotzotz tu u tzumbꞌaꞌa utz, jupax eluꞌl u jubꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ech xamtel tek tuul opon oꞌvaꞌt qꞌu ixviak utz, motx uqꞌay vatz qꞌanal ech tzaꞌ: «¡Kubꞌaal, kubꞌaal jaj okoꞌpꞌoꞌ!» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pek tzaqꞌbꞌel koꞌn eluꞌl tu u xiak ech tzaꞌ: «Niꞌxhtekꞌval sete, yeꞌ vootzaj abꞌil ex.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ech tokeꞌ nachnoj etatineꞌ. Tan yeꞌ etootzaj u qꞌii utz, nikoꞌxh u oora tetz u tulebꞌal u Kꞌaola vaꞌl bꞌennaj koꞌn aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Aatz paj viQꞌesalail u Tioxh tu Amlika, ela tuchꞌ maꞌl u vinaj siꞌchbꞌen tzian utz, isikꞌle qꞌu taqꞌonom. Ech taqꞌka qꞌu txꞌiibꞌal iqꞌii tikuenta. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Loqꞌ aꞌ nichbꞌenku tiꞌ jankꞌal soꞌoleꞌ tiꞌ taqꞌoninsaleꞌ sijununil nichtileꞌ. Aatz tu maꞌl, ijaꞌmel 30,000 qꞌii aqꞌon puaj taqꞌka te. Aatz tu vaꞌte, ijaꞌmel 12,000 qꞌii aqꞌon taqꞌka te. Utz aatz paj tu vaꞌte, ijaꞌmel 6,000 qꞌii aqꞌon taqꞌka te. Ech tek bꞌen tzian. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ech aatz vaꞌl ijaꞌmel 30,000 aqꞌonibꞌal qꞌii ikꞌula, yakich xeꞌt ilakon tiꞌ. Utz vaꞌt 30,000 paj tala vichiꞌl u puaj tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Echat paj iꞌan vaꞌl 12,000 ikꞌula. Vaꞌt paj 12,000 u tal itxꞌaka. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pek ech koj vaꞌl 6,000 ikꞌula tan, ex koꞌn ikꞌot jul utz, ex imuj vipuaj u bꞌaal taqꞌon tu txꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Uncheeꞌ sibꞌ tiempo maꞌtich ipaal tuul, ul tek u bꞌaal taqꞌon qꞌu aqꞌonom tziꞌ. Utz ela iꞌan tiꞌ vipuaj tuchꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ech opon siatz vaꞌl 30,000 ikꞌula utz, iqꞌomich vaꞌt 30,000 u tal taqꞌo. Tal te ech tzaꞌ: «Unbꞌaal, atil u 30,000 tzuta vaꞌl vetaaqꞌ ve. Utz il vaꞌt 30,000 tzaꞌ majte. Aꞌ tek u tal vetuntxꞌakka tiꞌ.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ech alax te tu u bꞌaal taqꞌon ech tzaꞌ: «Techal vaꞌl vetaꞌana bꞌaꞌnla aqꞌonom. Kꞌujlebꞌal kꞌuꞌl axh. Tan kꞌujlebꞌal kꞌuꞌl vetaꞌan tiꞌ bꞌiil vaꞌl vetvaqꞌ see. Ech sibꞌal tek savoksa takuenta. Pek chuukuꞌl tzunxeꞌ utz, chiꞌbꞌojoꞌ tiꞌ.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ech opon paj vaꞌl 12,000 ikꞌula utz, tal ech tzaꞌ: «Unbꞌaal, atil u 12,000 tzuta vaꞌl vetaaqꞌ ve. Utz il vaꞌt 12,000 tzaꞌ. Aꞌ tek u tal vetuntxꞌakka tiꞌ.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ech alax te tu u bꞌaal taqꞌon ech tzaꞌ: «Techal vaꞌl vetaꞌana bꞌaꞌnla aqꞌonom. Kꞌujlebꞌal kꞌuꞌl axh. Tan kꞌujlebꞌal kꞌuꞌl vetaꞌan tiꞌ bꞌiil vaꞌl vetvaqꞌ see. Ech sibꞌal tek savoksa takuenta. Pek chuukuꞌl tzunxeꞌ utz, chiꞌbꞌojoꞌ tiꞌ.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ech opon vaꞌl 6,000 ikꞌul majte utz, tal tu u bꞌaal taqꞌon ech tzaꞌ: «Unbꞌaal, vootzajnale aas yeꞌxhkam tzꞌejel tel saatz. Aal nachok iatz qꞌu chikobꞌeꞌm qꞌuꞌl yitꞌ achikoꞌm koj utz, namol iatz qꞌu chikobꞌeꞌm vaꞌl yitꞌ axh koj niaqꞌon kuꞌ tu txꞌavaꞌ, nikoꞌxhtitzꞌpu junal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ech tiꞌ vetxoꞌvikꞌin utz, vetkoꞌnunkol vapuaj tu txꞌavaꞌ. Pek ila. Aꞌ vichiꞌl vapuaj aaqꞌ ve tzuta.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Tzaqꞌbꞌel tek tu u bꞌaal taqꞌon ech tzaꞌ: «¡Qꞌeayla aanima! ¡Yitꞌ axh koj bꞌaꞌnla aqꞌonom! Oj ootzaj nal vuntxumbꞌal aas nunchok iatz qꞌu chikobꞌeꞌm qꞌuꞌl yitꞌ unchikoꞌm koj utz, nunmol iatz qꞌu chikobꞌeꞌm qꞌuꞌl yitꞌ in koj niaqꞌon kuꞌ tu txꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Aal tek bꞌaꞌn maꞌkojaaqꞌ kꞌam vunpuaj. Utz aatz vetꞌulin vetunkꞌul tuchꞌ u tal koj.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ech tal u bꞌaal aqꞌon ech tzaꞌ tu qꞌuꞌl atich tziꞌ: «Maataj el u puaj te tziꞌ utz, aqꞌtaj tu vaꞌl 60,000 tetz atile. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tan abꞌil vaꞌl nikanon taqꞌoninsaleꞌ, aal saꞌaqꞌax tereꞌn tetz. Ech sibꞌal tetz siꞌaneꞌ. Pek abꞌil vaꞌl yeꞌ nikanon taqꞌoninsaleꞌ, aal samaaleꞌl te jankꞌal vantziꞌ aqꞌel te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Utz aatz u aqꞌonom vaꞌl yeꞌk itxaꞌk tziꞌ, aqꞌtaj eloꞌp tu mam uken. Ech aꞌ soꞌoqꞌku tziꞌ utz, aꞌ sajarachꞌunku tee tziꞌ.» ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Uncheeꞌ suꞌul u Kꞌaola vaꞌl bꞌennaj koꞌn aanima tu u mam tijleꞌm, tuchꞌ kajay qꞌu aanjel. Sakꞌujeꞌ tu u qꞌesal chꞌuxhlebꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ech samolax opon kajay qꞌu aanima siatz, jankꞌal qꞌuꞌl atil tu u vatz amlika txꞌavaꞌ tzaꞌ. Utz samotxijatx iatz. Echaꞌ niꞌan u xeen karneꞌl aas niteesa el qꞌu karneꞌl xoꞌl qꞌu tentzun. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Satoksa qꞌu bꞌaꞌnla aanima tisebꞌal utz, aatz qꞌu yeꞌxtxoj, timax. Echaꞌ niꞌan u xeen karneꞌl aas nitaqꞌ bꞌen qꞌu karneꞌl tisebꞌal. Pek nitaqꞌ bꞌen qꞌu tentzun timax. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ech aatz u ijlenal tan, satal tu qꞌuꞌl atil tisebꞌal ech tzaꞌ: «Niꞌextaj tan, chiꞌbꞌebꞌal vetetz ex ikꞌaol imeꞌal vunTat. Okojex tu viQꞌesalail u Tioxh tzaꞌ. Vetetz vaꞌl nichꞌianeꞌ; ayaꞌxchen ichꞌianeꞌ xeꞌ qꞌii xeꞌ saj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tan nichunvaꞌyeꞌ utz, etaqꞌ vechbꞌubꞌal. Nichitzaj untziꞌ utz, etaqꞌ vaaꞌ. Nichvabꞌi vatibꞌal utz, ekꞌulin. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nichisav voksaꞌm utz, etaqꞌ vetz. Yaꞌvichꞌin utz, ex eqeeꞌin. Kuꞌin tu tzeꞌ utz, ex eqꞌilaꞌin.» Chaj te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ech aatz qꞌu jikomla aanima tan, satal ech tzaꞌ: «KuBꞌaal, ¿jatut qilaxh aas nichavaꞌyeꞌ utz, qaqꞌ eechbꞌubꞌal? ¿Jatut qilaxh aas nichitzaj atziꞌ utz, qaqꞌ avaaꞌ? ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Jatut qilaxh aas nichaabꞌi aatibꞌal utz, kukꞌulaxh quxeꞌ? ¿Jatut qilaxh aas nichasavsa ooksaꞌm utz, qaqꞌ eetz? ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Utz ¿jatut qilaxh aas axhich yaꞌv utz, ex kuqeeꞌaxh? Utz ¿jatut kuꞌaxh tu tzeꞌ utz, ex kuqꞌilaꞌaxh?» Chaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Pek satzaqꞌbꞌel tu u ijlenal, satal te ech tzaꞌ: «Niꞌxhtekꞌval sete, aatz vetebꞌan qꞌu bꞌaꞌnil tu qꞌu chꞌooal niman vetz tziꞌ, ve a vetebꞌanva tziꞌ.» Chaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ech saꞌpajtal tu qꞌuꞌl atil timax ech tzaꞌ: «Elojbꞌenex sunkꞌatza aanima bꞌanol onkonil. Bꞌenojex tu u xamal yeꞌk itzaaeꞌ tziꞌ. Ayaꞌ u choobꞌal paav vaꞌl veetinaj tetz u txꞌiꞌliꞌinaj tuchꞌ qꞌul iaanjel. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tan nichunvaꞌyeꞌ utz, yeꞌt etaqꞌ vechbꞌubꞌal. Nichitzaj untziꞌ utz, yeꞌt etaqꞌ vaaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nichvabꞌi vatibꞌal utz, yeꞌt ekꞌulin. Nichunsavsa voksaꞌm utz, yeꞌt etaqꞌ vetz. Yaꞌvichꞌin utz, yeꞌt ex eqeeꞌin. Kuꞌin tu tzeꞌ utz, yeꞌt ex eqꞌilaꞌin.» Chaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ech samotxtzaqꞌbꞌi utz, satal ech tzaꞌ: «¿KuBꞌaal, jatut qilaxh aas nichavaꞌyeꞌ; nichitzaj atziꞌ; nichaabꞌi aatibꞌal; nichasavsa ooksaꞌm; axhich yaꞌv; atich kuꞌaxh tu tzeꞌ utz, yeꞌt qilbꞌeꞌaxh?» Chaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ech satzaqꞌbꞌel ech tzaꞌ: «Niꞌxhtekꞌval sete tan, yeꞌn ebꞌan qꞌu bꞌaꞌnil tu qꞌu chꞌooaj niman vetz tziꞌ utz, ve a yeꞌn ebꞌanva tziꞌ.» Chaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ech samotxbꞌen qꞌuꞌl tu u choobꞌal paav tziꞌ vaꞌl yeꞌk iyaꞌeꞌ. Utz aatz qꞌu jikomla chaj aanima, aꞌ seꞌenku tu u atinchil vaꞌl bꞌenqꞌii bꞌensaj tatineꞌ.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Uncheeꞌ aatz tzojpu u Jesuus tiꞌ talax qꞌu yol tzaꞌ, tal tek tu qꞌul ichusulibꞌ ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Etootzajle aas tu kaꞌvaꞌt qꞌii cheel, saxeꞌt u nimla qꞌii tiꞌ u Elchil Vatz Kamchil Tu Egipto. Utz satxaypu u Kꞌaola vaꞌl bꞌennaj koꞌn aanima. Ech saꞌaqꞌax jeꞌ vatz kurus.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Anchituꞌ. Aatz qꞌu qꞌesal oksan yol vatz Tioxh tan, motx imol tibꞌ tuchꞌ qꞌu aa txumbꞌal tetz u oꞌtla mantaar utz, tuchꞌ qꞌu qꞌesal qꞌatol tzii. Aꞌ imolvu tibꞌ tiqꞌanal u bꞌanbꞌal topiisyo u qꞌesal oksan yol vatz Tioxh vaꞌl Caifaas ibꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Utz motx inukꞌ tibꞌilaj aas kam koꞌn sichuli tiꞌ itxaypu u Jesuus ech siyatzꞌeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pek loqꞌ nichmotxtal ech tzaꞌ: —Yitꞌ tu koj u nimla qꞌii sakubꞌan te, ech yeꞌk txabꞌkin liꞌan qꞌu tenam.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Uncheeꞌ atich u Jesuus tu Betaania tu otzotz xeꞌ u Xhim vaꞌl chꞌaꞌkꞌiꞌich. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tuul kꞌujlich u Jesuus vatz meexha, opon maꞌl u ixoj kꞌatza, iqꞌomich maꞌl tal bꞌaꞌnla tzꞌaj taqꞌo. Txꞌumqꞌixsabꞌal atil kuꞌ tuul. Tiira sibꞌ ijaꞌmel. Utz taqꞌ jeꞌ u txꞌumqꞌixsabꞌal tiviꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ech taꞌxh til u kam qꞌu chusulibꞌ tziꞌ, motx lakp iviꞌ tiꞌ. Utz motx tal ech tzaꞌ: —¿Kantuꞌ atziꞌ aas maꞌkoꞌxhibꞌuchleꞌl? ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Aal bꞌaꞌn maꞌkojikꞌayi. Jeꞌnaj sabꞌenka. Ech saꞌaqꞌax vijaꞌmel tu qꞌu meꞌbꞌaꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Pek aatz u Jesuus, tootzaji utz, tal tek te ech tzaꞌ: —¿Kam tokeꞌ aas kam koꞌxh netal tiꞌ vaꞌl vetiꞌan u ixoj tziꞌ? Tan maꞌl bꞌaꞌnil vetiꞌanlu ve atziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Aatz qꞌu meꞌbꞌaꞌ netaleꞌ tziꞌ, bꞌenamen koꞌxh atil texoꞌl atziꞌ. Pek aatz in tan, bꞌenamen koj saꞌatinin texoꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tan aatz vaꞌl vetiꞌan u ixoj tziꞌ, aas vettaqꞌ jeꞌ u txꞌumqꞌixsabꞌal tunviꞌ, aꞌ vetiꞌanlu bꞌen vuch tu mujbꞌal vetz aas lakamin. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Utz niꞌxhtekꞌval sete, til chit sapaxsalik itziiul u bꞌaꞌnla chusbꞌal tu u vatz amlika txꞌavaꞌ tzaꞌ, sayolax kꞌasuꞌl vaꞌl vetiꞌan u ixoj tziꞌ; nachbꞌal taanima.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Uncheeꞌ aatz maꞌl xoꞌl kabꞌlaal qꞌu chusulibꞌ, ayaꞌ u Judas aa Cariote, bꞌen xeꞌ qꞌu qꞌesal oksan yol vatz Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Utz tal te ech tzaꞌ: —¿Kam vetz setaqꞌeꞌ utz, savoksa u Jesuus teqꞌabꞌ?— Texhtuꞌ. Ech motx taqꞌ 30 saj chꞌichꞌ puaj te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ech aatz u Judas tan, yakich texh xeꞌt ichok txumbꞌal tiꞌ aas kaniꞌch toksal u Jesuus tiqꞌabꞌ siꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Uncheeꞌ aatz iꞌan tu u bꞌaxa qꞌii tetz u nimla qꞌii, u Txꞌaꞌbꞌal Kaxhlaan Txꞌix Yeꞌk Itxꞌamil, opon qꞌu chusulibꞌ kꞌatz u Jesuus. Tal te ech tzaꞌ: —¿Til asaꞌ sakubꞌanvu tuch u echbꞌubꞌal tetz kuꞌebꞌal qꞌii vaꞌl nitechbꞌul tu u nimla iqꞌii tiꞌ u Elchil Vatz Kamchil Tu Egipto? Ech laqechbꞌu.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tal u Jesuus te ech tzaꞌ: —Bꞌenojex tu tenam xeꞌ maꞌl u vinaj latziꞌ utz, letal te ech tzaꞌ: «Nital u chusul: Najabꞌyu vuntiempo. Utz tu val ootzotz satxꞌaꞌnkꞌin tuchꞌ qꞌul unchusulibꞌ tu u nimla qꞌii tiꞌ u Elchil Vatz Kamchil Tu Egipto. Chia.» Chajex te.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Anchituꞌ. Ech iꞌan qꞌu chusulibꞌ kam vaꞌl tal u Jesuus te utz, iꞌan tuch u echbꞌubꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Uncheeꞌ aatz tek sotzsaj, ok u Jesuus vatz meexha tuchꞌ kabꞌlaal qꞌul ichusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Utz tuul nichmotxtechbꞌuneꞌ, tal u Jesuus ech tzaꞌ: —Niꞌxhtekꞌval sete aas maꞌl sete soꞌoksanin tiqꞌabꞌ qꞌu txayol vetz.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ech tiira motx txumun qꞌu chusulibꞌ tiꞌ u yol tziꞌ. Utz junun nichichꞌoti tu u Jesuus ech tzaꞌ: —¿Yitꞌ tzik in unBꞌaal?— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tzaqꞌbꞌu u Jesuus utz, tala: —Ayaꞌ vaꞌl nikuꞌ unqꞌabꞌ tuchꞌ tu u puraato tzaꞌ. Aꞌ vaꞌl soꞌoksanin tiqꞌabꞌ qꞌu txayol vetz. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tan nojchit aꞌ sapaalku u Kꞌaola vaꞌl bꞌennaj koꞌn aanima tu qꞌu kam qꞌuꞌl tzꞌibꞌamalka tiꞌ tu u Yolbꞌal Tioxh. Pek tilayol sayaꞌk u vinaj vaꞌl soꞌoksan u Kꞌaola vaꞌl bꞌennaj koꞌn aanima tiqꞌabꞌ qꞌu txayol. Aal tek bꞌaꞌn atziꞌ yeꞌt koj itzꞌpi.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ech tzaqꞌbꞌu tek u Judas, vaꞌl soꞌoksan u Jesuus tiqꞌabꞌ qꞌu txayol, tal ech tzaꞌ: —¿Chusul, untzꞌoj in?— Texh te. —Eeꞌ, ayaꞌ vaꞌl naaleꞌ tziꞌ.— Texh u Jesuus te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ech tuul koꞌxh nichmotxitxꞌaꞌneꞌ, itxay u kaxhlaan txꞌix u Jesuus. Utz tal bꞌaꞌnil tiꞌ. Ipixh tuul. Utz taqꞌ tu qꞌul ichusulibꞌ utz, tal te ech tzaꞌ: —Tiꞌextaj utz, txꞌaꞌtaj tan, aꞌ vunchiꞌl atziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ech paj itxay u ukꞌabꞌal. Ikꞌamabꞌe Tioxh tiꞌ utz, taqꞌ tu qꞌul ichusulibꞌ. Tal ech tzaꞌ: —Tiꞌextaj. Ukꞌataj u taꞌl uuva kajay ex tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Tan aꞌ vunkajal atzaꞌ vaꞌl sael tiꞌ u akꞌ nukꞌuꞌm tetz kuybꞌal ipaav sibꞌal aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Utz nival sete cheel, aas yeꞌxhjatu veꞌt savukꞌa u taꞌl ivatz u uuva taabꞌaꞌbꞌen tzaꞌ. Pek analen tu maꞌl u qꞌii vaꞌl ela lavukꞌa u akꞌ taꞌl uuva setuchꞌ tu viQꞌesalail vunTat.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ech taꞌxh veet motx ibꞌitzat maꞌl u bꞌitzal, motx bꞌen viꞌ u muunte Olivo. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Uncheeꞌ tal paj u Jesuus tu qꞌu chusulibꞌ ech tzaꞌ: —Kajay ex samotxsotz ekꞌuꞌl viꞌ tu u aqꞌbꞌal cheel tzaꞌ. Tan tzꞌibꞌamal ech tzaꞌ: «Sayatzꞌax u xeen karneꞌl utz, saꞌtexhmotxpalun qꞌu karneꞌl.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pek aatz maꞌt qꞌaav vitzꞌpeꞌ, sabꞌaxabꞌbꞌenin sevatz tu Galilea.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ech tzaqꞌbꞌu u Luꞌ utz, tal ech tzaꞌ: —Kꞌuxh kajay samotxelabꞌenkaꞌaxh, aatz in tan, ¡jatu koj savelabꞌekaꞌaxh!— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Tal u Jesuus te ech tzaꞌ: —Niꞌxhtekꞌval see, tu u aqꞌbꞌal cheel tzaꞌ, ox pajul saaleꞌ aas yootzajin, tuul yeꞌsajen toqꞌ u bꞌaal tꞌel.— Texh u Jesuus te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tal paj u Luꞌ te: —¡Kꞌuxh sakamin saiꞌ, jatu koj saveesa vibꞌ tuul aas vootzajaxh!— Texh te. Echat chit motx tala sikajayil. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Uncheeꞌ opon tek u Jesuus tuchꞌ qꞌu chusulibꞌ tu u chikonbꞌal vaꞌl Getsemanii utz, tal te ech tzaꞌ: —Kaaojkaꞌex tzaꞌ tan, seꞌnunqꞌila sikꞌle Tioxh latziꞌ tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ech tiqꞌo bꞌen u Luꞌ tiꞌ. Aꞌ imol kaꞌvaꞌl qꞌul ikꞌaol u Zebedeo. Ech xeꞌt tul maꞌl mam txumuꞌm tu taanima u Jesuus utz, oks il. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ech tal tek u Jesuus te ech tzaꞌ: —Techal bꞌoj itxumun vaanxelal. Saꞌtekkamin taqꞌo nunnacheꞌ. Pek kaaojkaꞌex tzaꞌ utz, itzꞌlojex sunkꞌatza.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ech xaan bꞌen bꞌiil utz, pecheꞌi. Taqꞌ kuꞌ ivatz vatz txꞌavaꞌ utz, iqꞌila sikꞌle Tioxh. Tal ech tzaꞌ: —Tateey ¿yetz saveeti aas yeꞌk sapaalin tu u mam tzaꞌl tziꞌ? Loqꞌ aꞌ saꞌan vatxumbꞌal, yitꞌ aꞌ koj sapaal u vetz.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ech tek ul kꞌatz qꞌul ichusulibꞌ utz, jolol koꞌn vatchiche. Utz tal tu u Luꞌ ech tzaꞌ: —¿Yeꞌxh eqꞌiꞌ itzꞌeꞌchil maꞌj oora sunkꞌatza tzik? ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Pek itzꞌlojex utz, qꞌilataj sikꞌletaj Tioxh. Ech yeꞌk sakuꞌex tu paav. Tan nojchit vatz ikꞌuꞌl iqꞌilal sikꞌlel Tioxh u aanxelal; pek aatz u kuchiꞌl tan, yiꞌsaꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Bꞌen paj unpate. Ex iqꞌila sikꞌle Tioxh tikaꞌpaj. Utz tal ech tzaꞌ: —¡Tateey chiꞌin! ¿Yetz saveeti aas yeꞌk sapaalin tu u mam tzaꞌl tziꞌ? ¡Bꞌan vatxumbꞌal!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ech qꞌaavuꞌl utz, vatchich koꞌn paj qꞌul ichusulibꞌ. Tan axhibꞌi tiira techalich motx ikam tu vataꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Pek aqꞌaxkoꞌnpajka tu u Jesuus. Utz ex iqꞌila sikꞌle Tioxh titoxpaj. Utz echat chit qꞌu yol tala qꞌuꞌl tal bꞌaxa. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ech ul paj kꞌatz qꞌu chusulibꞌ utz, tal te ech tzaꞌ: —¿Ankoꞌxh vatchelex utz, nikoꞌnetilan tzik? Pek kꞌasojtajex tan, oponyu u oora soꞌoksal u Kꞌaola vaꞌl bꞌennaj koꞌn aanima tiqꞌabꞌ qꞌu aa paav. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pek ¡lakpojex utz, koꞌtaj! Tan tul vaꞌl saꞌaqꞌonin tu qꞌu txayol.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ech ankoꞌxh nichiyolon u Jesuus, tuul opon u Judas. Ayaꞌ maꞌl xoꞌl kabꞌlaal qꞌu chusulibꞌ. Sibꞌal aanima imol, ichaj qꞌu qꞌesal oksan yol vatz Tioxh, tuchꞌ qꞌu qꞌesal qꞌatol tzii. Jolol iqꞌomal ichꞌichꞌ tuchꞌ itzeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ech aatz u Judas, vaꞌl aqꞌon u Jesuus tu qꞌu txayol tan, maꞌtich taltaꞌ kam u xheenya siꞌan tiꞌ ikꞌuchlu u Jesuus. Tal ech tzaꞌ: —Abꞌiste vaꞌl luntzꞌutzꞌa, letxaya tan, aꞌ i.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ech xaan opon u Judas kꞌatz u Jesuus, tal te ech tzaꞌ: —Cheentzikꞌaxh chusul.— Texh te. Ech itzꞌutzꞌa. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Pek tal u Jesuus te ech tzaꞌ: —¿Kam ul aꞌaneꞌ vamiigo?— Texh te. Ech xaan opon qꞌu aanima utz, itxay u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Pek aatz iꞌan maꞌl qꞌul ichusulibꞌ u Jesuus tan, ijuu ichꞌichꞌ. Utz ech itzokꞌteꞌl ixichin maꞌl u taqꞌonom u qꞌesal oksan yol vatz Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ech yakich tal u Jesuus te ech tzaꞌ: —Qꞌaavixsa koꞌp vachꞌichꞌ tu totzotz tziꞌ. Tan abꞌil qꞌuꞌl sayatzꞌon tuchꞌ chꞌichꞌ, tu chꞌichꞌ sayatzꞌlik majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Yetz ootzaj tzik aas saveeti sunjajuꞌl aanjel tu vunTat yeꞌ achebꞌe ixaaneꞌ? Sataqꞌuꞌl atziꞌ oj sakꞌulelanin sunnacheꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tan ¿kam tek ech itzojpu u yolbꞌal Tioxh satzojpi oj ech sunbꞌaneꞌ? Pek ministeer ech chit siꞌaneꞌ atziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Uncheeꞌ aatz tu u muꞌkꞌul tziꞌ, tal u Jesuus tu qꞌu txayol tetz ech tzaꞌ: —Ayaꞌl aꞌ itxayax maꞌj elqꞌom nuꞌlebꞌan ve; iqꞌomal echꞌichꞌ tuchꞌ etzeꞌ. Tan aal jun qꞌii nichunkꞌujeꞌ texoꞌl tu viqꞌanalil u totztioxh. Nichunchusuneꞌ. Utz yeꞌt etxayin. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pek ech chit siꞌaneꞌ tan, aꞌ nitzojpu qꞌu yol qꞌuꞌl tzꞌibꞌamalka tu qꞌu alol tetz u yolbꞌal Tioxh.— Texhtuꞌ. Ech yakich oojoj qꞌu chusulibꞌ kajayil; motx telabꞌeka. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Uncheeꞌ aatz qꞌuꞌl txayon u Jesuus, tiqꞌo bꞌen vatz u qꞌesal oksan yol vatz Tioxh vaꞌl Caifaas ibꞌii, tu vaꞌl molichku tibꞌ qꞌu aa txumbꞌal tetz u oꞌtla mantaar tuchꞌ qꞌu qꞌesal qꞌatol tzii. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pek xamtichka u Luꞌ tiꞌ u Jesuus tzian. Opon koꞌxh vatz qꞌanal xeꞌ u qꞌesal oksan yol vatz Tioxh. Utz okoꞌp. Kꞌujeꞌ ok xoꞌl qꞌu polesiꞌy. Aꞌ isaꞌ siꞌchtileꞌ kam chit sayaꞌk u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ech aatz qꞌu qꞌesal oksan yol vatz Tioxh tuchꞌ qꞌu qꞌesal qꞌatol tzii, nichmotxichok txubꞌaꞌl tiꞌ u Jesuus. Aꞌ isaꞌ sayatzꞌaxi. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Loqꞌ yeꞌ nichmotxteloꞌp tuul, kꞌuxh jankꞌal txakbꞌaꞌn txubꞌaꞌl nichitxakbꞌaꞌ tibꞌ. Pek tiyaꞌtebꞌal tekuꞌen, opon kaꞌvaꞌl qꞌuꞌl taꞌn aꞌ itxakbꞌaꞌ txubꞌaꞌl tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Utz motx tal tiꞌ ech tzaꞌ: —Aatz u vinaj tziꞌ vettala: «Soꞌoleꞌin tiꞌ inilax kuꞌ vikuentail totztioxh tziꞌ. Utz tu koꞌn oxvaꞌl qꞌii soꞌoleꞌkꞌin tiꞌ qꞌaav inukꞌaxeꞌ.» Chia.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ech lakpu tek u qꞌesal oksan yol vatz Tioxh utz, tal tu u Jesuus ech tzaꞌ: —¿Yeꞌxh natzaqꞌbꞌu bꞌoj tiꞌ qꞌu kam nitalchu saiꞌ tziꞌ tzik?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pek aatz u Jesuus tan, tiira yeꞌ nichitzaqꞌbꞌeꞌ. Ech tal tepaj u qꞌesal oksan yol vatz Tioxh te ech tzaꞌ: —Sakoꞌnaꞌan bꞌaꞌnil, al vinujul qe tibꞌii u itzꞌlich Tioxh, ¿axh tzik viTxaaom u Tioxh, ayaꞌ vikꞌaol?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tal u Jesuus te ech tzaꞌ: —Ayaꞌ vaꞌl naaleꞌ tziꞌ. Utz nival sete majte aas saꞌnaletil u Kꞌaola vaꞌl bꞌennaj koꞌn aanima kꞌujlel tisebꞌal u Tioxh tu u mam tijleꞌm. Setil tul tu sutzꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Uncheeꞌ aatz tek u qꞌesal oksan yol vatz Tioxh, iqꞌix jeꞌ toksaꞌm kꞌatza tu kꞌaꞌnal utz, tal ech tzaꞌ: —¡Vetiyoqꞌlu Tioxh! ¡Kam tereꞌn texhtiigo kusaꞌ! ¡Matz etabꞌil viyoqꞌon cheel tzaꞌ! ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Pek ¿aatz ex, kam setal tiꞌ?— Texhtuꞌ. Ech motx tal ech tzaꞌ: —¡Kamchil tetz atziꞌ!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ech tek motx itzubꞌa ivatz u Jesuus. Nichmotxipaqꞌoꞌk ivatz. Utz atia mutxꞌimal iqꞌabꞌ nichiqꞌos majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Tuul nichmotxtal te ech tzaꞌ: —Ala qabꞌi, iTxaaom Tioxh, ¿abꞌil vaꞌl niqꞌosonaxh cheel tzaꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Uncheeꞌ aatz u Luꞌ tan, kꞌujlich eluꞌl qꞌanal. Ech xaan opon maꞌl u kꞌulanal kꞌatza utz, tal te ech tzaꞌ: —Ant axh majte atichꞌokꞌaxh tiꞌ u Jesuus u aa Galilea.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pek aatz u Luꞌ tan, teesa koꞌn tibꞌ tuul vatz kajay qꞌu aanima utz, tala: —Yeꞌ vootzaj kam vaꞌl naaleꞌ tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ech ichok teluꞌl tziꞌ jubꞌal. Utz ilax koꞌn paj tu vaꞌt u kꞌulanal. Utz tal tu qꞌu aanima ech tzaꞌ qꞌuꞌl atich tziꞌ: —Antu vaꞌl atich ok tiꞌ u Jesuus aa Nazareet atziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pek teesa koꞌn paj tibꞌ u Luꞌ tuul. Nichtoksa Tioxh tuul. Nichtal ech tzaꞌ: —Vatz Tioxh nivaleꞌ, yeꞌ vootzaj u vinaj naaleꞌ tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ech bꞌiil koꞌxh paj tuul, xaan opon unjot aanima kꞌatza, ayaꞌ qꞌuꞌl atich tziꞌ. Motx tal tu u Luꞌ ech tzaꞌ: —Nojchit tiira ant axh imol majte. Tan nimnaꞌl koꞌxh tu vayoloneꞌ tziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Aatz tek u Luꞌ tan, xeꞌt tal tzꞌejbꞌal yol tiꞌ utz, nichtoksa Tioxh tuul. Tal ech tzaꞌ: —Vatz Tioxh nivaleꞌ, yeꞌ vootzaj u vinaj netaleꞌ tziꞌ.— Texhtuꞌ. Ech tuul oqꞌ u bꞌaal tꞌel. ");
INSERT INTO ixlCNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ech ul tek viyol u Jesuus sikꞌuꞌl u Luꞌ vaꞌl tal te ech tzaꞌ: —Aatz yeꞌsajen toqꞌ u tꞌel, ox pajul maꞌt aaltaꞌ aas yootzajin.— Texhich te. Ech ipaal eluꞌl u Luꞌ utz, itzꞌejeꞌl maꞌl mam oqꞌel. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Uncheeꞌ aatz tek iꞌan qꞌalaꞌm, kuꞌ tibꞌeyil tu qꞌu qꞌesal oksan yol vatz Tioxh, tuchꞌ qꞌu qꞌesal qꞌatol tzii aas kaniꞌch ikam u Jesuus siꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ech iqitza utz, ex taqꞌ tiqꞌabꞌ u governadoor aa Roma vaꞌl Pooncio Pilato. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Uncheeꞌ tabꞌi u Judas aas yatzꞌel u Jesuus sabꞌanli. Ech ikꞌaxa jeꞌ ikꞌuꞌl tiꞌ vaꞌl iꞌana aas toksa u Jesuus tiqꞌabꞌ qꞌu txayol. Iqꞌaavixsa u 30 saj chꞌichꞌ puaj tu qꞌu qꞌesal oksan yol vatz Tioxh tuchꞌ qꞌu qꞌesal qꞌatol tzii. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Tal u Judas te ech tzaꞌ: —Maꞌxh paavinyin tan, vetvoksal aanima vatz kamchil aas yeꞌk ipaav.— Texhtuꞌ. Pek alax koꞌn te ech tzaꞌ: —Axh niꞌilon. Yeꞌ qootzaj.— Texh koꞌn teꞌleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ech imakꞌtuka qꞌu saj chꞌichꞌ puaj u Judas tu viqꞌanalil u totztioxh utz, kꞌasuꞌl. Ex ijulkꞌaai jeꞌ iqul. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Aatz tek qꞌu qꞌesal oksan yol vatz Tioxh tan, motx tek isikꞌ qꞌu saj chꞌichꞌ puaj utz, tal ech tzaꞌ: —Yeꞌk siꞌaneꞌ aas saqoksa u puaj xoꞌl u kutxu tetz Tioxh tziꞌ tan, ijaꞌmel maꞌl aanima kꞌayili tu kamchil.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ech motx inukꞌa utz, iloqꞌ maꞌl txꞌavaꞌ tiꞌ u puaj tziꞌ. Mujbꞌal tetz qꞌu puera aanima qꞌuꞌl nikam tziꞌ tala. Aꞌ ibꞌii, Itxꞌavaꞌ Qꞌu Tzꞌajol. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ech tokeꞌ “Jaꞌmel Kaj” tek ibꞌii u txꞌavaꞌ cheel tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ech itzojpu u yol vaꞌl alich tu u Jeremias u alol tetz u yolbꞌal Tioxh aas tala: —Motx ex tiqꞌo u 30 saj chꞌichꞌ puaj, ayaꞌ vijaꞌmel maꞌl u jikomla aanima. Tan u jaꞌmel toksa qꞌu qꞌesala xoꞌl qꞌu Israeel. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ech motx iloqꞌ u txꞌavaꞌ tiꞌ vaꞌl, itxꞌavaꞌ qꞌu tzꞌajol. Tan ech tal u kuBꞌaal ve.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Uncheeꞌ aatz txaklich u Jesuus vatz u governadoor utz, chꞌotil te ech tzaꞌ: —¿Axh tzik u tijlenal qꞌu Israeel tzaꞌ?— Texh teꞌleꞌ. Tal u Jesuus te ech tzaꞌ: —Ayaꞌ vaꞌl naaleꞌ tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pek paat yeꞌ nichitzaqꞌbꞌe kꞌuxh xochax tu qꞌu qꞌesal oksan yol vatz Tioxh tuchꞌ tu qꞌu qꞌesal qꞌatol tzii. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Aatz u Pilato, tal tek te ech tzaꞌ: —¿Yetz naabꞌi tzik aꞌxh bꞌoj qꞌu kam nitalax saiꞌ tziꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pek aatz u Jesuus tan, nikoꞌxh maꞌj yol tala. Ech nichtexhisotz ikꞌuꞌl u governadoor taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pek aatz nichibꞌanax jun yaꞌbꞌ tu u nimla qꞌii tiꞌ u Elchil Vatz Kamchil Tu Egipto, nichichajpu maꞌl preexhu u governadoor. Loqꞌ qꞌu tenam nichjajon abꞌiste visaꞌ sachajpi. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Uncheeꞌ aatz tu qꞌu qꞌii tziꞌ, atich ok maꞌl preexhu tu tzeꞌ, Barrabaas ibꞌii. Atich talcheꞌ aas tiira onkonla aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ech imol tibꞌ qꞌu tenam. Utz tal u Pilato tixoꞌl ech tzaꞌ: —¿Abꞌiste preexhu esaꞌ sunchajpu, aꞌ tzik aꞌ u Barrabaas oj ayaꞌ u Jesuus vaꞌl, iTxaaom u Tioxh, chu teꞌleꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Tan tootzajich u Pilato aas chiꞌikꞌuꞌl nichmotxiꞌan tiꞌ. Echtzixeꞌt tiqꞌo opon siatz. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Tuul kꞌujlich u Pilato tu qꞌatbꞌal tzii, tal talax opon u tixoj te ech tzaꞌ: —Ooksach iibꞌ tu u kam tiꞌ u vinaj tziꞌ tan, jikomla vinaj. Utz tilayol maꞌl vatzikꞌ vetunbꞌan tiꞌ maꞌit.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pek aatz qꞌu qꞌesal oksan yol vatz Tioxh tuchꞌ qꞌu qꞌesal qꞌatol tzii, motx oleꞌ tiꞌ ichajtziꞌl qꞌu tenam. Aꞌ sijaj ichajpu u Barrabaas. Pek aꞌ satal ikam u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Aatz u governadoor tan, ichꞌoti paj tu qꞌu tenam ech tzaꞌ: —¿Abꞌiste maꞌl tu kaꞌvaꞌl qꞌu vinaj esaꞌ sunchajpu tziꞌ?— Texhtuꞌ. Motx tal ech tzaꞌ: —¡Aꞌ sachajpu u Barrabaas!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Tal paj u Pilato te ech tzaꞌ: —¿Kam sunbꞌan tu u Jesuus tziꞌ uncheeꞌ vaꞌl, iTxaaom u Tioxh?— Texhtuꞌ. Kajay motx alon ech tzaꞌ: —¡Jeꞌoj vatz kurus!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ech tal tek u governadoor ech tzaꞌ: —¿Kam chit mam onkonil vetiꞌanlaꞌ uncheeꞌ?— Texhtuꞌ. Pek aal koꞌn maas tiqꞌo iyakꞌil qꞌu aanima qꞌeqꞌun taltu ech tzaꞌ: —¡Jeꞌoj vatz kurus!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Til tek u Pilato aas yeꞌxhkam maꞌj tiqꞌo tibꞌ, pek aal koꞌn maas nichtuch txabꞌalkabꞌinchil. Tal tek topon taaꞌ. Utz itxꞌaa iqꞌabꞌ vatz qꞌu tenam. Tal ech tzaꞌ: —Yitꞌ in koj siꞌijlen ikam u jikomla vinaj tziꞌ, pek ex aa paav tiꞌ vikameꞌ. Utz lakoꞌnmotxetila.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tzaqꞌbꞌu kajay qꞌu tenam utz, motx tal ech tzaꞌ: —Qijan u choobꞌal paav tiꞌ vikameꞌ tuchꞌ qꞌu kukꞌaol kumeꞌal.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Uncheeꞌ ech ichajpu u Barrabaas vatz qꞌu tenam. Utz tal itzꞌuꞌmal u Jesuus. Ech taqꞌ bꞌen tiqꞌabꞌ qꞌu sol seꞌntaqꞌ jeꞌ vatz kurus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ech iqꞌol bꞌen u Jesuus tu qꞌul isol u governadoor, tu u qꞌesal qꞌatbꞌal tzii. Utz molax ok qꞌu sol tiꞌ, qꞌuꞌl atich tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ech motx teesat u toksaꞌm. Utz toksa maꞌl u kaj oksaꞌm kꞌatza, echaꞌ tetz ijlenal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Utz motx iꞌan maꞌl chꞌiꞌx koroona. Taqꞌ jeꞌ tiviꞌ. Toksa maꞌl tzeꞌ tu sebꞌal iqꞌabꞌ, ibꞌaara aas nitaleꞌ. Ech motx pecheꞌ kuꞌ siatz, bꞌanbꞌal vatz. Utz nichteesa iqꞌii ech tzaꞌ: —¡Techal axh, axh tijlenal qꞌu Israeel!— Chu te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nichmotxitzubꞌa utz, nichipaqꞌ tzeꞌ iviꞌ tu u tzeꞌ vaꞌl toksa tiqꞌabꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Aatz veet teesat iqꞌii, teesa tek u kaj oksaꞌm kꞌatza utz, iqꞌaavixsa ok qꞌu toksaꞌm. Ech motx tiqꞌo bꞌen, ex taqꞌ jeꞌ vatz kurus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Uncheeꞌ tuul nichmotxteluꞌl tziꞌ tenam, ikꞌul maꞌl u vinaj, Xhim ibꞌii, aa Cirene. Taꞌxh alax te tu qꞌu sol aas satiqꞌo u kurus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Motx tek opon tu u txꞌavaꞌ vaꞌl Goolgota, “Tatibꞌal Bꞌajil Iviꞌ Kamnaj” chu u tokebꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Aqꞌax minaagre tu u Jesuus, yuuel tuchꞌ vaꞌt u kꞌayla tzꞌak, sichtixsabꞌal. Pek inacha, ech yeꞌt koꞌn isaꞌa tukꞌaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ech taqꞌtu jeꞌ u Jesuus vatz kurus utz, motx iꞌan maꞌl saach qꞌu sol tiꞌ u toksaꞌm aas abꞌil lasuertiin tala. Ech ijatxtu vatz qꞌuꞌl suertiin. Tan aꞌ tzojpu u yol alel tiꞌ ech tzaꞌ: —Motx ijatx qꞌu voksaꞌm siatzaj. Iꞌan maꞌl saach tiꞌ isuertiileꞌ.— Chia.  ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ech motx kꞌujeꞌ tiꞌ ixeeleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Utz itzꞌibꞌa maꞌl yol taqꞌ jeꞌ vatz u kurus, tibꞌa u Jesuus, ayaꞌ vipaav aas nichmotxtaleꞌ. Ech nichtal tzaꞌ. “Aꞌ U JESUUS TZAꞌ, U TIJLENAL QꞌU ISRAEEL.” Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Utz taqꞌ jeꞌ kaꞌvaꞌl elqꞌom vatz kurus kꞌatz u Jesuus majte; maꞌl tisebꞌal, vaꞌt timax. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ech nichipaal qꞌu aanima vatz u Jesuus. Utz nichiyiku iviꞌ tuul niyoqꞌeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Utz nichtal te ech tzaꞌ: —Axh vaꞌl sanilon kuꞌ vikuentail u totztioxh. Utz tu koꞌn oxvaꞌl qꞌii saoleꞌkꞌaxh tiꞌ qꞌaav inukꞌaxeꞌ naaleꞌ. Pek eesa iibꞌ tu u tzaꞌl sajunal tziꞌ. Oj nojchit axh iKꞌaol Tioxh, ¡kuꞌenul vatz u kurus tziꞌ!— Chu te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Echat koꞌxh iꞌan qꞌu qꞌesal oksan yol vatz Tioxh tu u Jesuus majte, nichteesa iqꞌii. Aꞌ imol qꞌu aa txumbꞌal tetz u oꞌtla mantaar tuchꞌ qꞌu qꞌesal qꞌatol tzii. Nichmotxtal tiꞌ ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Eesan aanima tu tzaꞌl nitaleꞌ, pek yeꞌ nitxꞌol teesat tibꞌ. Tan oj nojchit aꞌ u tijlenal qꞌu Israeel siꞌaneꞌ, teesa tibꞌ vatz u kurus cheel tziꞌ, ech sakunima. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Aꞌ kꞌujlelk ikꞌuꞌl tiꞌ u Tioxh nitaleꞌ. Ech eesaloj tu u Tioxh cheel oj nojchit nisaꞌleꞌ. Tan nitaleꞌ: «In iKꞌaol Tioxh.» Chia.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Echat koꞌxh nichiꞌan qꞌu elqꞌom te qꞌuꞌl atich jeꞌ vatz kurus txala. Nichteesa iqꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ech aatz iꞌan chaqꞌaal qꞌii, ok aqꞌbꞌal tu u vatz amlika txꞌavaꞌ kajayil. Oxvaꞌl oora ok uken. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ech aatz siꞌchtexhiꞌan alas 3 kuꞌqꞌii, qꞌeqꞌun u Jesuus. Jankꞌal iyakꞌil, tal ech tzaꞌ: —¡Elii, Elii! ¿Lama sabactani?— Texhtuꞌ. Aatz u tokebꞌal utz: —¡UnTioxh chiꞌin, unTioxh chiꞌin! ¿Kantuꞌ vetaaqꞌlukaꞌin sunjunal?— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ech aatz unjolol tixoꞌl qꞌuꞌl atich tziꞌ, taꞌxh tabꞌi u yol tal u Jesuus, motx tal ech tzaꞌ: —U Elias nisikꞌle vaꞌl tziꞌ.— Texh tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ech aatz maꞌl tixoꞌl, oora tꞌasp ibꞌenaꞌ. Ex tiqꞌo maꞌl esponja. Iqitzoꞌk tiꞌ maꞌl tzeꞌ utz, ijilu tu minaagre. Ech taqꞌ jeꞌop titziꞌ u Jesuus. Siꞌchitzꞌutzꞌeꞌl u minaagre tiꞌ tala. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pek aatz unjolte, tal ech tzaꞌ: —Kam asaꞌ te. Saqileꞌ qabꞌi satz ul eesaloj tu u Elias.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pek qetun unpat u Jesuus jankꞌal iyakꞌil, ech el ikꞌuꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Uncheeꞌ yakich tzilmoj u mam liikin bꞌuꞌj vaꞌl liiumich paal tu u totztioxh. Kaꞌvaꞌl el tuul. Aal ikuꞌl itzilmeꞌ iꞌana. Utz paal maꞌl mam kabꞌnaano. Motx pax qꞌu sivan taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ech jajp itziꞌ qꞌu mujbꞌal kamnaj. Utz qꞌaav itzꞌpu sibꞌal qꞌu kamnaj qꞌuꞌl nimanich tetz Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Aꞌ chit maꞌtich qꞌaav titzꞌpu u Jesuus, motx lakpu kꞌasuꞌl tu qꞌu mujbꞌal tetz. Utz motx ul tu u tioxhla tenam Jerusaleen. Utz sibꞌal aanima ilon. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Uncheeꞌ aatz u qꞌesal sol tuchꞌ qꞌul isol qꞌuꞌl nichxeen u Jesuus, tiira motx xoꞌvi aas paal u mam kabꞌnaano. Utz xoꞌv tu qꞌu kam uchi. Utz motx tek tal ech tzaꞌ: —¡Nojchit aꞌ viKꞌaol u Tioxh atziꞌ!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Utz sibꞌal ixoj atich tziꞌ. Nichmotxisajin kꞌasuꞌl tzian. Ayaꞌ qꞌu ixoj kꞌasuꞌl tiꞌ u Jesuus tu Galilea utz, nichiloch u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Utz atich u Liꞌ tixoꞌl, u aa Magdala. Antu u Liꞌ, vinan u Jacobo tuchꞌ u Xhep. Utz antu vinan qꞌul ikꞌaol u Zebedeo majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Uncheeꞌ aatz nichtekxeꞌtisotz saj, ul maꞌl u vinaj txꞌiiol iqꞌii, aa Arimatea, Xhep ibꞌii. Nimanich tetz u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Utz bꞌen xeꞌ u Pilato. Aꞌ ex ijaj vichiꞌl u Jesuus te. Ech teesa mantaar u Pilato aas saꞌaqꞌax vichiꞌl u Jesuus te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ech ex iqꞌoloj vichiꞌl u Jesuus tu u Xhep. Utz ibꞌach tu maꞌl saj bꞌuꞌj. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Utz ex imuj tu maꞌl u akꞌ jul, joyom sivan analich koꞌxh iveeteꞌ. Ijupka itziꞌ tu maꞌl penkin sivan. Ech kꞌasuꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Motx kꞌujeꞌka kaꞌvaꞌl qꞌu ixoj vatz u jul. Ayaꞌ u Liꞌ u aa Magdala, tuchꞌ vaꞌt u Liꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Uncheeꞌ aatz evtich ibꞌantuchkeꞌl tuch qꞌu aanima tiꞌ u ilanbꞌal qꞌii, motx imol tibꞌ qꞌu qꞌesal oksan yol vatz Tioxh xeꞌ u Pilato. Ant imol qꞌu fariseo. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Motx tal ech tzaꞌ: —Qꞌesal, nitul viyol u eesanal tu bꞌey sukukꞌuꞌl, aas tal ech tzaꞌ: «Aatz maꞌt tel oxvaꞌl qꞌii voksal tu jul, saqꞌaavitzꞌpꞌin.» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Pek al ixeel u jul bꞌaꞌnil paal nal oxvaꞌl u qꞌii vaꞌl tala. Tan noj topon qꞌul ichusulibꞌ tu aqꞌbꞌal seꞌntiqꞌo eluꞌl vichiꞌl. Utz saꞌtekmotxtal tu kajay aanima ech tzaꞌ: «Qꞌaav itzꞌpi xoꞌl qꞌu kamnaj.» Chaj. Utz paal tek iviꞌ isubꞌtu aanima liꞌan vatz vaꞌl bꞌaxa.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Tal tek u Pilato te ech tzaꞌ: —Aꞌtzii. Iqꞌotaj bꞌen untanul esol. Xeepoj bꞌaꞌnil echaꞌ vaꞌl netaleꞌ tziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ech motx elkꞌasuꞌl. Ex tzꞌapulojkoꞌk maꞌl echlal tiꞌ u penkin sivan tziꞌ u jul; techlal aas yeꞌxhabꞌil koꞌxh maꞌj sajajon ok. Utz toksaka sol tiꞌ ixeeleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Uncheeꞌ aatz iꞌan tu u bꞌaxa qꞌii tetz u xhemaana, tiira kuꞌsaj, bꞌen u Liꞌ aa Magdala tuchꞌ vaꞌt u Liꞌ. Ex til vaꞌl mujlik u Jesuus aas evtich ipaal u ilanbꞌal qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Utz yeꞌk talcheꞌ paal maꞌl mam kabꞌnaano. Maꞌl u aanjel kuꞌl tu Amlika. Utz teesa u sivan tziꞌ u jul utz, kꞌujeꞌ siiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Aatz tilon u aanjel tziꞌ, echaꞌ iribꞌun itzꞌnaꞌbꞌ. Utz tiira saj qꞌu toksaꞌm, echaꞌ saj sutzꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ech tiira motx xoꞌv qꞌu xeen tetz u jul taqꞌo. Techal motx itꞌuntꞌuꞌlaneꞌ. Tiira motx sotz ikꞌuꞌl. Ech tekuꞌen aꞌ kamnaj motx kaaka. ");
INSERT INTO ixlCNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pek aatz u aanjel, tal tu qꞌu ixoj, ech tzaꞌ: —Yeꞌ koꞌxh xoꞌvex. Vootzajle aꞌ nechok u Jesuus vaꞌl aqꞌax jeꞌ vatz kurus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Pek yeꞌkan tek tzaꞌ. Tan qꞌaav itzꞌpia, echaꞌ vaꞌl tala. Niꞌextaj etileꞌ. Utz bꞌenoj esaji okoꞌp vaꞌl aqꞌaxku vichiꞌl u kuBꞌaal. ");
INSERT INTO ixlCNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Pek cheel bꞌenoj etal tu qꞌul ichusulibꞌ ech tzaꞌ: «¡Qꞌaav itzꞌpi xoꞌl qꞌu kamnaj! Utz ¡bꞌaxabꞌyu bꞌen sevatz tu Galilea! Utz aꞌ setilvu tziꞌ.» Chajex te. Aꞌ vaꞌl nival sete.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","9","Uncheeꞌ motx tek jutzin ikꞌasuꞌl qꞌu ixoj tziꞌ u jul. Echil xoꞌval, echit txuqꞌtxunchil nichmotxbꞌanon. Ul tal u bꞌaꞌnla yol tu qꞌu chusulibꞌ. Ech yeꞌk talcheꞌ, ok u Jesuus tibꞌey. Tal te ech tzaꞌ: —Chajlentzikꞌex. Bꞌaꞌnil koj at sekꞌatza.— Texh te. Ech xaan opon qꞌu ixoj kꞌatza, motx pecheꞌ siatz. Utz iqꞌalu tajan; ech motx toksa iqꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Aatz u Jesuus tan, tal te ech tzaꞌ: —Yeꞌ koꞌxh xoꞌvex. Pek bꞌenoj etal tu qꞌul unchusulibꞌ aas samotxbꞌen tu Galilea. Tan latziꞌ satilvin.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ech tuul kꞌasuꞌl qꞌu ixoj, aatz untxꞌajul qꞌu sol xeenal, bꞌen tu tenam. Ex tal tu qꞌu qꞌesal oksan yol vatz Tioxh kam qꞌuꞌl uchi. ");
INSERT INTO ixlCNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ech imol tibꞌ qꞌu qꞌesal oksan yol vatz Tioxh tuchꞌ qꞌu qꞌesal qꞌatol tzii. Utz motx inukꞌa aas sataqꞌ sibꞌal ipuaj qꞌu sol. ");
INSERT INTO ixlCNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Utz tal tu qꞌu sol ech tzaꞌ: —Aatz setaleꞌ: «Vetꞌopon qꞌul ichusulibꞌ tu aqꞌbꞌal. Vetmotxꞌultiqꞌo eluꞌl vichiꞌl u Jesuus tuul vatcheloꞌ.» Chajex. ");
INSERT INTO ixlCNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Pek oj latabꞌi u governadoor kam qꞌuꞌl uchi, toj kubꞌan talax te. Sakutxakbꞌaꞌ qibꞌ setiꞌ.— Texh tu qꞌu sol. ");
INSERT INTO ixlCNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ech ikꞌultu kꞌasuꞌl vipuaj qꞌu sol tziꞌ. Utz ech chit motx tala kam vaꞌl alax te. Aatz u txubꞌaꞌl tziꞌ, pax paal itziiul xoꞌl qꞌu Israeel. Utz ankoꞌxh nitalaxeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Uncheeꞌ aatz junlaal qꞌu chusulibꞌ, motx bꞌen tu Galilea viꞌ u muunte vaꞌl alichnalka te tu u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Utz anchituꞌ. Til u Jesuus; motx toksa iqꞌii. Pek atich unjolol tixoꞌl nichikaꞌtziiuneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ech xaan opon u Jesuus kꞌatza utz, tal te ech tzaꞌ: —Aqꞌaxyu vijleꞌm tiꞌ kajay qꞌu kam tu Amlika tuchꞌ tu kajay u vatz txꞌavaꞌ tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ech tokeꞌ bꞌenojex tu kajay u vatz amlika txꞌavaꞌ. Utz oksataj qꞌu aanima niman vetz. Bꞌantaj vautisaar qꞌu niman vetz tibꞌii vunTat, tu vibꞌii u Kꞌaola utz, tuchꞌ tibꞌii u Tioxhla Espiiritu. ");
INSERT INTO ixlCNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Utz chustaj te aas samotxinima kajay qꞌu kam qꞌuꞌl vetvalluka sete. Utz aatz in tan, atil in sekꞌatza jun qꞌii, motx nal qꞌii saj. Aꞌi.— Texh u Jesuus.");
INSERT INTO ixlCNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Aꞌ vixeꞌtebꞌal u bꞌaꞌnla chusbꞌal tetz u Jesucristo tzaꞌ, viKꞌaol u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Echaꞌ vaꞌl itzꞌibꞌaka u Isaias, u alol tetz u yolbꞌal Tioxh aas tal ech tzaꞌ: — «In sabꞌaxabꞌsan bꞌen vunchaj saatz. Aꞌ saxaansan itziiul u bꞌaꞌnla yol, echaꞌ ibꞌanax tuch bꞌey saatz siꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Sajeꞌ iviꞌ tu yol tu u tzꞌinlich tzaji txꞌavaꞌ. Satal ech tzaꞌ: Jikomtixsataj etxumbꞌal vatz Tioxh; echaꞌ ijikomtixsal bꞌey siatz sebꞌaneꞌ. Chaj.» Chia.— Texh u Isaias. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Utz aꞌ nital u Xhan. Tan ipaxsa u yolbꞌal Tioxh tiꞌ ikꞌaxal paav tu u tzꞌinlich tzaji txꞌavaꞌ. Utz tal tu qꞌuꞌl ikꞌaxa ipaav aas siꞌan ivautiismo. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ech opon qꞌu aanima kꞌatza qꞌuꞌl tikuenta jankꞌal u Judea tuchꞌ qꞌu aa Jerusaleen. Utz motx ikꞌaxa qꞌul ipaav. Ech bꞌanax vautisaar tu u Xhan tu u nimaꞌ Jordaan. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Uncheeꞌ aatz u toksaꞌm u Xhan tan, chemich xiꞌl camello; tzꞌuꞌm u qitzbꞌal xeꞌaj tuul. Utz sakꞌ tuchꞌ taꞌl kabꞌ u techbꞌubꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Utz ipaxsa talax ech tzaꞌ: —Aatz vaꞌl tulka viꞌ, tiira paalchu tijleꞌm sunviꞌ. Aal yeꞌk sikꞌuloꞌk viꞌ soꞌokꞌins chitol el ixaabꞌ tu tajan. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Aatz in tan, nojchit tu aꞌ koꞌn nunbꞌanvu vautisaarex. Pek aatz vaꞌl tuleꞌ, aꞌ saoksan u Tioxhla Espiiritu sekꞌatza.— Texh u Xhan. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Uncheeꞌ aatz iꞌan tu qꞌu qꞌii tziꞌ, kꞌasuꞌl u Jesuus tu Nazareet tikuenta Galilea. Opon kꞌatz u Xhan. Utz bꞌanax vautisaar tu u nimaꞌ Jordaan. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ech aatz jeꞌul u Jesuus tu aꞌ, aꞌ tek til ijajpu u amlika. Utz til ikuꞌl u Tioxhla Espiiritu tibꞌa, echaꞌ paroomaxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ech uch kꞌasuꞌl maꞌl u yol tu Amlika, tal ech tzaꞌ: —Axh vunKꞌaol vaꞌl tiiꞌin saiꞌ. Utz axh u kꞌujlebꞌal unkꞌuꞌl.— Texh u yol. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Uncheeꞌ iqꞌol bꞌen u Jesuus tu u Tioxhla Espiiritu tu u tzꞌinlich tzaji txꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","40 qꞌii iꞌan tziꞌ. Utz bꞌanax provaal isubꞌax tu u txꞌiꞌliꞌinaj. Aꞌ atichku xoꞌl qꞌu jaqꞌaj tzeꞌil txokop. Utz nichtaqꞌax techbꞌubꞌal tu qꞌu aanjel. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Uncheeꞌ aatz maꞌtich ikuꞌ u Xhan tu tzeꞌ, bꞌen u Jesuus tu Galilea tiꞌ ipaxsal talax u bꞌaꞌnla chusbꞌal tetz viQꞌesalail u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Utz tal ech tzaꞌ: —Tzojpi tek u tiempo, najabꞌy ul viQꞌesalail u Tioxh. Ech kꞌaxataj qꞌul epaav utz, nimataj u bꞌaꞌnla chusbꞌal.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Uncheeꞌ aatz paal u Jesuus tziꞌ u choo tu Galilea, til u Xhim. Aꞌich imol u Lixh, vitzaꞌqꞌ. Nichmotxtaqꞌ koꞌp u kꞌach tu aꞌ, eesabꞌ txay. Tan jolol eesan txayich. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ech tal u Jesuus te ech tzaꞌ: —Niꞌextaj viꞌ. Utz yitꞌ txay tereꞌn koj seteesa tu aꞌ, pek aꞌ savoksavex tiꞌ ichokax aanima.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ech yakich motx taqꞌka qꞌul ikꞌach, eesabꞌ txay utz; xambꞌu tiꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Bꞌiit koꞌxh paj xaan bꞌen siatz, til qꞌul ikꞌaol u Zebedeo. Ayaꞌ u Jacobo tuchꞌ u Xhan, vitzaꞌqꞌ. Nichmotxikꞌooa ikꞌach tu jukubꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ech sikꞌlel tu u Jesuus utz, motx taqꞌka vitat tuchꞌ qꞌu aqꞌonom tu u jukubꞌ. Utz motx xambꞌu tiꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Uncheeꞌ opon u Jesuus tu Capernauum tuchꞌ qꞌul ichusulibꞌ. Utz nichichusuneꞌ. Nichibꞌen tu u atibꞌal chusbꞌal tetz u oꞌtla mantaar tu qꞌu ilanbꞌal qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ech vaꞌlich itzꞌejx ikꞌuꞌl qꞌu aanima tiꞌ u tokebꞌal vichusbꞌal tan, nimnaꞌl atil tijleꞌm tu vichusuneꞌ. Txayoꞌm niꞌan qꞌul iyol. Yitꞌ ech koj aꞌ qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Utz atich okoꞌp maꞌl u vinaj tu u atibꞌal chusbꞌal tetz u oꞌtla mantaar, atoꞌk tioxhil txꞌiꞌliꞌinaj kꞌatza. Utz qꞌeqꞌuni. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Tal ech tzaꞌ: —¡Aay! ¿Kam asaꞌ qe Jesuus aa Nazareet? Kꞌuxh ulyaxh, oꞌ ul ayansa qatineꞌ. Tan vootzajle abꞌil axh. Axh viTxaaom u Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Pek yaal tu u Jesuus, tal te ech tzaꞌ: —¡Cha atziꞌ! Utz elen kꞌatz u vinaj tziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ech aatz u tioxhil txꞌiꞌliꞌinaj, techal itꞌuntꞌuꞌlansal u vinaj iꞌana. Qꞌeqꞌuni; ech el kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ech kajay aanima motx tzꞌejx ikꞌuꞌl taqꞌo. Utz motx tek tal tibꞌilaj ech tzaꞌ: —¿Kam tek tokeꞌ atziꞌ? ¿Kam tek akꞌ chusbꞌalil vichusbꞌal tziꞌ? Tan tu koꞌn iyolon tu u tijleꞌm nitel qꞌu tioxhil txꞌiꞌliꞌinaj utz, niꞌxhinimaleꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ech oora koꞌxh pax itziiul talchu u Jesuus tu kajay vikuenta u Galilea. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Uncheeꞌ aatz motx kꞌasuꞌl tu u atibꞌal chusbꞌal tetz u oꞌtla mantaar, motx bꞌen tu u tatibꞌal u Xhim tuchꞌ u Lixh. Aꞌ imol u Jacobo tuchꞌ u Xhan. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Utz tzanlich vi-ixoj jiꞌ u Xhim vatz txꞌach; tajinnajich tu xamal. Utz alax tu u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ech xaan tek opon u Jesuus kꞌatza. Itxay siqꞌabꞌ utz, ilak jeꞌ. Utz yakich koꞌxh eloj u xamal tiꞌ. Ech xeꞌt iꞌan echbꞌubꞌal tetz u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Aatz tek qꞌu aanima, motx tiqꞌo opon kajay qꞌul iyaꞌv vatz u Jesuus tuchꞌ qꞌuꞌl atich ok tioxhil txꞌiꞌliꞌinaj kꞌatza. Aꞌ chit maꞌt tek isotz saj. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ech sibꞌla aanima tu u tenam tziꞌ, motx mulin topon vatz jubꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Utz aatz u Jesuus, iꞌan bꞌaꞌn tu sibꞌal aanima, kꞌuxh chukchaj iyaabꞌil. Utz tojcheꞌl qꞌu tioxhil txꞌiꞌliꞌinaj majte. Yeꞌt taqꞌ tzii tu qꞌu tioxhil txꞌiꞌliꞌinaj sayoloni tan, jolol tootzajich abꞌil u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Uncheeꞌ tiira qꞌalaꞌm chit lakpu u Jesuus. Ankoꞌxh toktoich tereꞌn, bꞌen tu maꞌl u txꞌavaꞌ tzꞌintzꞌochi. Ex iqꞌila isikꞌle Tioxh tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ech chokax tu u Xhim tuchꞌ tu tereꞌn qꞌul imol atich kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Utz aatz ichabꞌa, tal te ech tzaꞌ: —Sibꞌal aanima nichokonaxh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Aatz u Jesuus tan, tal te ech tzaꞌ: —Koꞌtaj tu tereꞌn qꞌu talaj tenam qꞌuꞌl najaꞌ tziꞌ. Ech sunpaxsa talax u bꞌaꞌnla chusbꞌal tziꞌ. Tan aꞌ chit vaꞌl ul unbꞌaneꞌ.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ech ipaxsa talax u bꞌaꞌnla chusbꞌal tu qꞌu atibꞌal chusbꞌal tetz u oꞌtla mantaar tu kajay vikuenta u Galilea. Utz tojcheꞌl qꞌu tioxhil txꞌiꞌliꞌinaj kꞌatz aanima majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Uncheeꞌ opon maꞌl u chꞌaꞌkꞌiꞌ vinaj kꞌatz u Jesuus. Pecheꞌ kuꞌ siatz. Ijaj maꞌl bꞌaꞌnil te ech tzaꞌ: —¿Yetz asaꞌ saꞌan bꞌaꞌn ve?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ech txumax iatz tu u Jesuus. Taqꞌ opon viqꞌabꞌ. Ikanoꞌk utz, tal te ech tzaꞌ: —Eeꞌ, sunsaꞌa. Bꞌan bꞌaꞌn.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ech tu koꞌxh unmuꞌkꞌul, sotz u chꞌaꞌk kꞌatz u vinaj. Utz yakich iꞌan bꞌaꞌn. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Utz tal bꞌen u Jesuus te bꞌaꞌnil ech tzaꞌ: —Loqꞌ abꞌi iileꞌ. Bꞌaxalich koꞌxh aal tu aanima. Pek kuxh kꞌuch iibꞌ tu u oksan yol vatz Tioxh, ech satileꞌ aas bꞌaꞌntꞌaxh. Iqꞌo bꞌen u txakunsaꞌm tzixeꞌ vaꞌl sakꞌachlu viꞌ u nachbꞌal vaꞌl talka u Moisees tu u oꞌtla mantaar.— Texh te. Ech ichajtu bꞌen. ");
INSERT INTO ixlCNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pek taꞌxh kꞌasuꞌl, xeꞌt ipaxseꞌl itziiul u txaichil tziꞌ. Echixeꞌat nichtereꞌnkojtokoꞌp u Jesuus tu qꞌu tenam taqꞌo. Pek nichtexhikaa tiꞌ eluꞌl tenam tu qꞌuꞌl tzꞌinliche. Loqꞌ taꞌxh bꞌanel nichtopon aanima kꞌatza. Til koꞌn nichkꞌaskuꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Uncheeꞌ kaꞌxvaꞌlich qꞌii tuul, qꞌaavpajopon u Jesuus tu Capernauum. Utz abꞌil itziiul aas atich tu otzotz. ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ech oora chit imol tibꞌ mam tenam. Utz nichtereꞌnkojveet tokoꞌp aanima tziꞌ otzotz. Utz nichipaxsa talax u yolbꞌal Tioxh u Jesuus te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Aatz kaavaꞌl qꞌu vinaj, siꞌchokoꞌp tzixeꞌ tala. Chelemich maꞌl vinaj taqꞌo, numtzꞌinaj iqꞌabꞌs tajan. ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pek yeꞌt veet ixaan opon kꞌatz u Jesuus tu qꞌu mam tenam. Ech aꞌ tek xeꞌt teesa bꞌiil iviꞌ u atibꞌal vaꞌl atichku u Jesuus. Ech iꞌantu maꞌl kuꞌebꞌalop. Aꞌ taqꞌvu koꞌp u numtzꞌinaj tuul vaꞌl tzꞌanlich jeꞌ viꞌ chelebꞌ tetz. ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ech til u Jesuus aas kꞌujlel ikꞌuꞌl qꞌu chelenal tiꞌ ibꞌantu bꞌaꞌn u yaꞌv. Tal tek tu u numtzꞌinaj ech tzaꞌ: —Kajay qꞌul apaav kuyel bꞌaal.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Utz kꞌujlich opon unjolol qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar tziꞌ. Nichmotxtal tiꞌ taanima ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—¿Kam tokeꞌ aas ech nital u vinaj tziꞌ? ¡Paasaibꞌ aꞌ niꞌan viꞌ Tioxh tziꞌ aas nital ech tziꞌ! Abꞌil koj sakuyun paav. Taꞌxh u Tioxh.— Chu tu taanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pek aatz u Jesuus tan, paal itxumbꞌal tuul tu taanxelal aas ech nichmotxtal tiꞌ taanima tziꞌ. Tal tek te ech tzaꞌ: —¿Kantuꞌ netal tetaanima aas paasaibꞌ nunbꞌan viꞌ Tioxh? ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Abꞌiste tek u yol yitꞌ tzaꞌl koj telaꞌ uncheeꞌ? ¿Aꞌ tzik aꞌ vaꞌl: «Kuyel tek qꞌul apaav kajayil.» Chiꞌin te? ¿Oj ayaꞌ vaꞌl: «Lakpen, iqꞌo bꞌen u chelebꞌ eetz tziꞌ utz, xaan.» Chajin te? ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pek sunkꞌuch bꞌoj sevatz aas nojchit atil tijleꞌm u Kꞌaola vaꞌl bꞌennaj koꞌn aanima tiꞌ ikuyax paav tu u vatz amlika txꞌavaꞌ tzaꞌ.— Texhtuꞌ. Ech tal tu u numtzꞌinaj ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Axh nivalaxh, lakpen. Iqꞌo bꞌen u chelebꞌ eetz tziꞌ utz, kuxh taatibꞌal.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ech vatz qꞌu tenam kajayil lakpu u vinaj tziꞌ. Tiqꞌo kꞌasuꞌl u chelebꞌ tetz. Utz eluꞌl. Ech kajay motx tzꞌejx ikꞌuꞌl taqꞌo. Utz motx toksa iqꞌii Tioxh. Tal ech tzaꞌ: —¡Yeꞌkax qil kam ech tziꞌ!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Uncheeꞌ xamtel tuul bꞌen paj u Jesuus tziꞌ u choo. Utz mam tenam opon kꞌatza. Ech ichus qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Utz tuul nichipaaleꞌ, til maꞌl u vinaj Levii ibꞌii, ikꞌaol u Alfeo. Kꞌujlich tu u bꞌanbꞌal topiisyo vaꞌl nikꞌulchik jaꞌmel alkavaar. Tal u Jesuus te ech tzaꞌ: —Xambꞌen viꞌ.— Texh te. Ech lakpu u Levii, xambꞌu tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Utz aatz iꞌan u Jesuus, ex txꞌaꞌn xeꞌ u Levii, ok vatz meexha. Utz motx opon sibꞌat qꞌu subꞌulla chaj jajol jaꞌmel alkavaar. Ant imol unjot qꞌu aanima tiira aa paav tatin vatz qꞌu Israeel. Jolol atich ok kꞌatz u Jesuus vatz meexha utz, kꞌatz qꞌuꞌl ichusulibꞌ. Tan nojchit sibꞌal qꞌuꞌl maꞌtich tok tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Aatz til qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar tuchꞌ qꞌu fariseo aas nichitxꞌaꞌn u Jesuus tuchꞌ qꞌu aa paav tziꞌ, motx tal tu qꞌu chusulibꞌ ech tzaꞌ: —¿Kam tokeꞌ aas nitechbꞌun u Jesuus tuchꞌ qꞌu subꞌulla chaj jajol jaꞌmel alkavaar utz, tuchꞌ qꞌu aa paavla chaj aanima tziꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ech taꞌxh tabꞌi u yol u Jesuus tziꞌ, tal te ech tzaꞌ: —Aatz qꞌu tiichajla aanima, yeꞌxhkam nisavsa aa tzꞌak; pek aꞌ nisavsan qꞌu yaꞌv. Tan yitꞌ aꞌ koj ul unchok jikomla aanima, pek aꞌ ul unchok aa paav.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Uncheeꞌ aatz qꞌul ichusulibꞌ u Xhan tuchꞌ qꞌu fariseo, nichmotxikuy ivaꞌy tiꞌ iqꞌilal isikꞌlel Tioxh. Pek aatz qꞌul ichusulibꞌ u Jesuus, yeꞌxhkam. Ech motx opon xeꞌ u Jesuus, ichꞌoti te ech tzaꞌ: —¿Kam tokeꞌ nimotxikuy ivaꞌy tiꞌ iqꞌilal isikꞌlel Tioxh qꞌul ichusulibꞌ u Xhan tuchꞌ qꞌu fariseo, pek aatz qꞌul achusulibꞌ, yeꞌxhkam?— Texh tu u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Aatz u Jesuus, tal te ech tzaꞌ: —Oj tzik siꞌaneꞌ aas sikuy ivaꞌy qꞌu aanima qꞌuꞌl nisavsal tiꞌ tilax tzumbꞌaꞌa, tuul atil u xiak tixoꞌl vaꞌl tzumeꞌya. Yeꞌka. Yitꞌ saꞌkojikuy ivaꞌy aas ankoꞌxh atil u xiak tixoꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pek toj nal uloj maꞌl qꞌii aas, saeesal bꞌen u xiak. Ech nal sikuy ivaꞌy. Tan saꞌnaliꞌaneꞌ aas saeesalbꞌenin xoꞌl qꞌul unchusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Aatz u bꞌaꞌnla chusbꞌal, saꞌkojikꞌul tibꞌ tuchꞌ u oꞌtla kostuumbre nenima. Echaꞌ u akꞌ kꞌoo, yeꞌxhabꞌil nioksan tiꞌ maꞌl qꞌaꞌl oksaꞌm. Tan nikꞌolon u akꞌ kꞌoo. Utz aal maas siyakꞌinsa iqꞌixmu u qꞌaꞌl oksaꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Echat majte yeꞌxhabꞌil niaqꞌon kuꞌ tu qꞌaꞌl tzꞌuꞌm u taꞌl uuva vaꞌl anal telaꞌ. Tan aatz u taꞌl uuva anal telaꞌ, sasipkꞌi utz, sikꞌux u qꞌaꞌl tzꞌuꞌm. Ech nipeqꞌxu u taꞌl uuva utz, nitel u qꞌaꞌl tzꞌuꞌm titxaꞌk majte. Pek aꞌ saꞌaqꞌaxku u taꞌl uuva vaꞌl anal telaꞌ tu akꞌ tzꞌuꞌm.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Aatz iꞌan u Jesuus tu maꞌl u ilanbꞌal qꞌii, paal xoꞌl unjolol qꞌu chikobꞌeꞌm. Utz motx itxꞌup vatz triigo qꞌu chusulibꞌ tuul koꞌxh nichipaaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ech aatz qꞌu fariseo, tal tek tu u Jesuus ech tzaꞌ: —¿Kam tok qꞌul achusulibꞌ tziꞌ, aas niꞌan tu ilanbꞌal qꞌii vaꞌl yitꞌ bꞌaꞌn koj bꞌanaxi? Aꞌ niqel u kukostuumbre tzꞌibꞌamal tiꞌ u ilanbꞌal qꞌii atziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Tal tek u Jesuus te ech tzaꞌ: —¿Yetz sikꞌlemal tu u Yolbꞌal Tioxh setaqꞌo tiꞌ kam vaꞌl iꞌan u Daviid tuchꞌ qꞌuꞌl xamich tiꞌ? Tan motx iyaꞌta techbꞌubꞌal utz, kam tu vaꞌy. ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ech motx okoꞌp tu u totztioxh utz, itxꞌaꞌ tetz u txaaꞌla kaxhlaan txꞌix tetz Tioxh vaꞌl yitꞌ aqꞌich koj tzii aas abꞌil koꞌxh satxꞌaꞌon, pek taꞌxh qꞌu oksan yol vatz Tioxh. Pek itxꞌaꞌ tetz u Daviid utz, taqꞌ tetz qꞌul imol. Aꞌ iꞌantaꞌ aas aꞌ chit qꞌesal oksan yolich vatz Tioxh u Abiataar.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Tal paj u Jesuus te ech tzaꞌ: —Aatz u ilanbꞌal qꞌii, tiꞌ qꞌu aanima bꞌanaxka, pek yitꞌ tiꞌ koj u ilanbꞌal qꞌii bꞌanaxku qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ech tokeꞌ aatz u Kꞌaola vaꞌl bꞌennaj koꞌn aanima, paalchu vatz u ilanbꞌal qꞌii.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Uncheeꞌ bꞌenpajok unpat u Jesuus tu u atibꞌal chusbꞌal tetz u oꞌtla mantaar. Utz atich maꞌl u vinaj latziꞌ yeꞌ nichiyikun unpaqꞌil iqꞌabꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ech aatz qꞌu fariseo, tii nichikꞌaabꞌa u Jesuus. Aꞌ isaꞌ samotxtileꞌ satz iꞌan bꞌaꞌn tu u vinaj tu u ilanbꞌal qꞌii tziꞌ; ech samotxixoch tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Pek aatz u Jesuus, tal tu u vinaj vaꞌl yeꞌ nichiyikun unpaqꞌil iqꞌabꞌ ech tzaꞌ: —Lakpen utz, oken tu kuxoꞌl.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ech yolon u Jesuus tu qꞌu aanima ech tzaꞌ: —¿Abꞌiste vaꞌl bꞌaꞌn vatz u mantaar tetz u ilanbꞌal qꞌii? ¿Aꞌ tzik aꞌ vaꞌl sabꞌanax maꞌj bꞌaꞌnil, pek oj ayaꞌ maꞌj maaloil? Utz ¿aꞌ tzik aꞌ vaꞌl saꞌaqꞌax tiichajil, pek oj aal saꞌeesal tiichajil?— Texhtuꞌ. Ech aatz qꞌu aanima tan, yeꞌxhkam tzaqꞌbꞌi. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ech aatz u Jesuus, sajin tiꞌaj chaj tuchꞌ kꞌaꞌnal. Loqꞌ nichitxumun majte tan, tila aas taꞌxh motx okoj tetz qꞌul itxumbꞌal. Ech tal tek tu u vinaj ech tzaꞌ vaꞌl yeꞌ nichiyikun unpaqꞌil iqꞌabꞌ: —Yuj vaqꞌabꞌ tziꞌ.— Texh te. Ech iyuj viqꞌabꞌ u vinaj. Utz yakich iꞌan bꞌaꞌn. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pek motx kꞌasuꞌl qꞌu fariseo tziꞌ; motx ex inukꞌ tuchꞌ qꞌuꞌl oknajich tiꞌ u Herodes aas kaniꞌch iyatzꞌax u Jesuus siꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Aatz u Jesuus, bꞌen tziꞌ u choo tuchꞌ qꞌul ichusulibꞌ. Utz mam tenam chit xambꞌu bꞌen tiꞌ. At aa Galilea, tuchꞌ aa Judea, ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","tuchꞌ aa Jerusaleen, tuchꞌ aa Idumea, tuchꞌ qꞌu aa sala bꞌen u Jordaan. Utz antu qꞌu aanima majte qꞌuꞌl atich tikuenta Tiro tuchꞌ Sidoon. Tan tabꞌi aas sibꞌal mamaj kam nichiꞌaneꞌ. Ech mam tenam xambꞌu bꞌen tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ech tal tek u Jesuus tu qꞌul ichusulibꞌ aas liistooj koꞌxh u jukubꞌ taqꞌo tan, noj ijaqꞌil tu qꞌu mam tenam xamich tiꞌ tala. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Sibꞌal yaꞌv maꞌtich iꞌantu bꞌaꞌn te. Utz sibꞌat tereꞌn yaꞌv taꞌxh nichikꞌon opon tibꞌ tiꞌ ikanax ok. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Utz aatz qꞌuꞌl atich ok tioxhil txꞌiꞌliꞌinaj kꞌatza, taꞌxh nichtil u Jesuus, nichipecheꞌ kuꞌ siatz. Utz nichiqꞌeqꞌun taltu te ech tzaꞌ: —Axh viKꞌaol u Tioxh.— Chu te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pek nichkoꞌniyaal tu u Jesuus. Aꞌ isaꞌ yeꞌk saꞌaqꞌax eluꞌl itziiul. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Uncheeꞌ xamtel tek tuul, bꞌenjeꞌ u Jesuus viꞌ maꞌl u muunte. Utz itxaa unjolol vinaj, abꞌiste qꞌuꞌl siꞌan te tila. Utz motx ul kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ech toksa kabꞌlaal vinaj u Jesuus aas saꞌatin kꞌatza utz, sichaj bꞌen tiꞌ ipaxsal talax u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Utz taqꞌ tijleꞌm tiꞌ ibꞌantu bꞌaꞌn tu qꞌu yaꞌv utz, tiꞌ tojchal el tioxhil txꞌiꞌliꞌinaj kꞌatz aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Aꞌ qꞌuꞌl itxaa tzaꞌ. U Xhim, ayaꞌ vaꞌl Luꞌ ibꞌii toksa majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Antu u Jacobo tuchꞌ u Xhan, vitzaꞌqꞌ, qꞌul ikꞌaol u Zebedeo, qꞌuꞌl oksal vaꞌt ibꞌii tu u Jesuus. Boanergees tekuꞌen. “Ikꞌaol tininunchil” chu u tokebꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Antu u Lixh, u Felipe, u Bartolomee, u Tio, u Maxh, u Jacobo, vikꞌaol u Alfeo. Antu u Tadeo. Antu u Xhim, vaꞌl atich ok xoꞌl qꞌu cananista. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Utz antu u Judas, u aa Cariote vaꞌl aqꞌon u Jesuus tiqꞌabꞌ qꞌu txayol. Uncheeꞌ opon u Jesuus tu atibꞌal tuchꞌ qꞌul ichusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Utz motx paj noo topon aanima kꞌatza. Aal nikoꞌxh nichtereꞌnkojitxꞌolpeꞌ satxꞌaꞌn bꞌoj tu qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ech taꞌxh tabꞌi qꞌu titzꞌin tatzik u Jesuus, siꞌchmotxultiqꞌo tala tan: —Elyu tu bꞌey atziꞌ.— Texhich tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pek aatz unjolol qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar, aꞌ kꞌaskuꞌl tu Jerusaleen, motx tal tiꞌ u Jesuus aas u Belzebuu atil kꞌatza. Ayaꞌ u qꞌesal tioxhil txꞌiꞌliꞌinaj. Utz aꞌ vaꞌl niaqꞌon tijleꞌm tiꞌ tojchal el qꞌu tioxhil txꞌiꞌliꞌinaj nichtaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ech aatz u Jesuus, isikꞌle okoꞌp qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar kꞌatza. Utz ikꞌam tiꞌ kam tal te ech tzaꞌ: —¿Kam tokeꞌ sakoꞌxhtojcha jeꞌ tetz txꞌiꞌliꞌinajil u txꞌiꞌliꞌinaj? ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tan echaꞌ maꞌj ijlenal oj jatxel tibꞌ iatz tuchꞌ qꞌul imol tu viqꞌesalail, sakoꞌnjinkꞌi. Saꞌkojveet iꞌantu maꞌl iatz. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ech pajeꞌ untanoj itzꞌin atzik tu maꞌj atibꞌal, oj jatxel tibꞌ iatz, saꞌkojveet iꞌantu maꞌl iatz. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ech oj aatz u txꞌiꞌliꞌinaj sakoꞌxhiꞌan jeꞌ timol, sakoꞌnijatx tibꞌ atziꞌ. Saꞌkojveet tatineꞌ aas maꞌl iatz. Pek sotzchil siꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Abꞌil koj maꞌj saveet tokoꞌp toꞌotzotz xeꞌ maꞌl aanima aa yakꞌil utz, seꞌnelqꞌoj oj yitꞌ bꞌaxa koj siqitzeꞌ. Pek bꞌaxal siqitzeꞌ, ech soꞌoleꞌ tiꞌ ijolonsal bꞌen qꞌu tetz. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Utz niꞌxhtekꞌval sete, kajay vipaav qꞌu aanima sakuyli. Utz sakuylu kajay qꞌu yoqꞌoꞌm sajeꞌul titziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pek abꞌil sayoqꞌon utz, saqelon u Tioxhla Espiiritu, yeꞌxhjatu sakuyli. Pek aꞌ texh sichꞌia okchil tu u choobꞌal paav vaꞌl yeꞌk iyaꞌeꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Tal u Jesuus ech tziꞌ tan, nichtal qꞌu fariseo: —Tioxhil txꞌiꞌliꞌinaj atil kꞌatza.— Chu tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Bꞌiilen koꞌxh tuul, opon qꞌul itzaꞌqꞌ u Jesuus tuchꞌ vinan. Motx koꞌn atin qꞌanal. Utz tal isikꞌleleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ech aatz qꞌu aanima qꞌuꞌl kꞌujlich tiꞌaj u Jesuus, tal te ech tzaꞌ: —Atil vanan tuchꞌ qꞌul atzaꞌqꞌ qꞌanal; nichokꞌaxh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ech tzaqꞌbꞌel tu u Jesuus utz, tal ech tzaꞌ: —¿Abꞌil vunnan utz, abꞌil qꞌul untzaꞌqꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ech isajit qꞌu aanima jolol kꞌujlich tiꞌaj utz, tala: —Aꞌ vunnan tzuta utz, aꞌ qꞌuꞌl untzaꞌqꞌ tzui. ");
INSERT INTO ixlCNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tan kajay qꞌuꞌl nibꞌanon vitxumbꞌal u Tioxh tu Amlika, aꞌ untzaꞌqꞌ, aꞌ vanabꞌ utz, aꞌ vunnan atziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Uncheeꞌ xeꞌt paj ichusun u Jesuus tziꞌ choo. Utz mam tenam chit imol tibꞌ kꞌatza. Ech jeꞌtekꞌop tu maꞌl u jukubꞌ utz, kꞌujeꞌ tuul viꞌ u choo. Pek aatz kajay qꞌu aanima, aꞌ atichku vatz txꞌavaꞌ tziꞌ aꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ech sibꞌ koꞌxh kam ikꞌam tiꞌ u Jesuus tu vichusuneꞌ. Utz nichtal tu vichusbꞌal ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Abꞌitaj etileꞌ. Aatz iꞌan maꞌl u chikol, bꞌen tu chikoꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Imakꞌ paal u ia tu u aqꞌonibꞌal. Utz atia aꞌ kuꞌk tu bꞌey. Utz motx koꞌn ex tzotiloj tu qꞌu tzꞌichin qꞌuꞌl nipaal tu amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Atia aꞌ kuꞌk viꞌaj sivan aas bꞌiil koꞌxh txꞌavaꞌ atil siiꞌ. Utz oora itzꞌpu u ia tan, xax koꞌn u txꞌavaꞌ atil jeꞌ siiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pek tzꞌaꞌbꞌ u qꞌii, lumin u chikobꞌeꞌm tu vitzꞌaꞌl. Utz tzaji tan, bꞌiil koꞌn bꞌennaj u taqꞌil. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","At u ia aꞌ kuꞌk xoꞌl chꞌiꞌx. Pek chꞌii qꞌu chꞌiꞌx utz, isotzsa u chikobꞌeꞌm. Yeꞌt vatzini. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pek aatz untante, aꞌ kuꞌk tu bꞌaꞌnla txꞌavaꞌ. Itzꞌpi utz, chꞌii. Ech vatzini. Utz atia 30 ivatz taqꞌa tiꞌ junun tajan. Atia 60 ivatz taqꞌa. Utz atia 100 ivatz taqꞌa.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Utz tal paj u Jesuus ech tzaꞌ: —Abꞌiste ex niabꞌin qꞌu yol tzaꞌ, nimataj.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Uncheeꞌ aatz ijunalich tek u Jesuus, atich unjolol aanima xaannajich ok kꞌatza. Utz ichꞌoti u tokebꞌal qꞌu yol te. Aꞌ imol kabꞌlaal qꞌu chusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Utz tal u Jesuus te ech tzaꞌ: —Bꞌaꞌn ex tan, aqꞌel tzii sete aas setootzaji u tokebꞌal qꞌu kam tiꞌ viQꞌesalail u Tioxh qꞌuꞌl yeꞌ ootzajimal. Pek aatz qꞌu aanima yeꞌ oknaj tan, tu kꞌamich kam saꞌalaxku te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ech satzojpu qꞌu yol bꞌaxabꞌsamal talaxeꞌ tzaꞌ aas: «Kꞌuxh nisajineꞌ tiloneꞌ, yeꞌxhat niꞌenku te. Utz kꞌuxh samotxabꞌini, saꞌkojikan tabꞌil tokebꞌal qꞌu kam. Ech yeꞌk samotxok kꞌatz Tioxh utz; yeꞌk samotxkuyax qꞌul ipaav.» Chia.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Utz tal paj u Jesuus te ech tzaꞌ: —¿Yeꞌ nitel etxumbꞌal tu u kꞌamich kam tziꞌ tzik? ¿Oj yeꞌxhkam utz, kam tek ech tel etxumbꞌal tu tereꞌn qꞌu kꞌamich kam uncheeꞌ? ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Aatz u chikol, aꞌ nikꞌam tiꞌ u paxsan paal tetz u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Aatz u ia vaꞌl kuꞌ tu bꞌey, aꞌ nikꞌam tiꞌ u yolbꞌal Tioxh vaꞌl nitabꞌi u aanima. Pek taꞌxh niveet tabꞌi, aatz u txꞌiꞌliꞌinaj, nikoꞌnulisotzsa u yolbꞌal Tioxh sikꞌuꞌl vaꞌl maꞌt tabꞌitaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aatz qꞌu ia qꞌuꞌl aꞌ kuꞌk viꞌaj sivan, aꞌ nikꞌam tiꞌ u aanima vaꞌl nitabꞌi u yolbꞌal Tioxh utz, kaana itxuqꞌtxuneꞌ nikꞌul tu u muꞌkꞌul tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pek yeꞌ bꞌennaj taqꞌil. Bꞌiil koꞌn niꞌaneꞌ. Tan echaꞌ tziꞌ, nitul maꞌj tzaꞌlla kam oj maꞌj txaypichil tiꞌ u yolbꞌal Tioxh, sibꞌ niꞌenku te. Utz yeꞌ koꞌxh tiil ikuꞌeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Aatz u ia vaꞌl aꞌ kuꞌk xoꞌl chꞌiꞌx, aꞌ nikꞌam tiꞌ qꞌu aanima qꞌuꞌl niabꞌin u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pek nikoꞌnisotzsal bꞌen sikꞌuꞌl tu qꞌu elaꞌokchil tiꞌ vimeꞌbꞌiꞌl tu u vatz amlika txꞌavaꞌ tzaꞌ. Utz antu u elaꞌokchil tiꞌ tachval ok qꞌu txꞌiibꞌal qꞌii, tuchꞌ tereꞌn kam. Aꞌ nitokoꞌp xeꞌ taanima, ech yeꞌxhkam niyolonku u yolbꞌal Tioxh kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pek ech koj qꞌu ia qꞌuꞌl aꞌ kuꞌk tu bꞌaꞌnla txꞌavaꞌ, aꞌ nikꞌam tiꞌ u aanima vaꞌl niabꞌin u yolbꞌal Tioxh utz, nimnaꞌl kꞌatza. Echaꞌ u ia aas nivatzineꞌ. Atia 30 ivatz nitaqꞌeꞌ; atia 60 nitaqꞌeꞌ utz; atia 100 nitaqꞌ majte.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Tal paj u Jesuus ech tzaꞌ: —Aatz nimatxlu maꞌj txijtxubꞌal, aal koj nimujlu tu maꞌj kaaxha. Pek aal nixaansal jeꞌ u txijtxubꞌal ech sapaqꞌuni. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tan kajay mujich kam yeꞌ koj saꞌabꞌili. Utz kajay qꞌu kam sajutxil ibꞌanaxeꞌ, yeꞌ koj saeluꞌl itziiul. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Abꞌiste ex niabꞌin qꞌu yol tzaꞌ, nimataj.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Utz tal paj u Jesuus ech tzaꞌ: —Nachtaj bꞌen etibꞌ nitzikenima u chusbꞌal vaꞌl netabꞌi. Tan kam chit vaꞌl sebꞌaneꞌ, echat chit sabꞌanax sete. Pek sapaal bꞌiit vaꞌl sataqꞌ u Tioxh sete oj u bꞌaꞌnil sebꞌaneꞌ, jankꞌal ex niabꞌin qꞌu yol tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tan abꞌil atil nal tetz, saꞌaqꞌax tereꞌn tetz. Pek abꞌil vaꞌl bꞌiil koꞌn tetz, aal samaaleꞌl te jankꞌal u tetz atile.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Utz tal paj u Jesuus ech tzaꞌ majte: —Aatz viQꞌesalail u Tioxh, ela tuchꞌ maꞌl u vinaj aas chikel tiil triigo tu u txꞌavaꞌ taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Utz nititzꞌpu u ia. Ech chꞌiichil tek niꞌan qꞌiils aqꞌbꞌal kꞌuxh vatchel u chikol tetz utz, kꞌuxh kꞌasnaj. Loqꞌ yeꞌxhat niꞌenku te kaniꞌch ichꞌii nichꞌiieꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tan u txꞌavaꞌ nichꞌiisan. Bꞌaxal nal nibꞌens xajtzeꞌ. Ech nichee talaj ivatz. Utz xamtel tekuꞌen kaana ivatz u triigo mulchele. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Utz aatz maꞌt iqꞌanbꞌeꞌ, nitekentzokꞌloj tu u tiempo tzokꞌbꞌal tetz.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Tal paj ech tzaꞌ: —¿Kam maꞌj kam sakukꞌam tiꞌ, tiꞌ talax viQꞌesalail u Tioxh vatzsaj bꞌaꞌnil? ¿Kam maꞌj ibꞌii sakukꞌam tiꞌ? ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ela viQꞌesalail u Tioxh tuchꞌ maꞌl bꞌaqꞌ iatz muxhtaansa. Tan aꞌ u ia vaꞌl nojchit tiira tal chꞌoo vatz tereꞌn qꞌu ia nichikax tu u txꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Utz aatz nichꞌiieꞌ, paalch ichꞌii vatz tereꞌn qꞌu itza niꞌaneꞌ. Sibꞌ ichꞌii qꞌul iqꞌabꞌ. Aal nitekꞌuliꞌan isok qꞌu tzꞌichin siiꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Uncheeꞌ aatz u Jesuus, nichtal u yolbꞌal Tioxh tu qꞌu aanima. Loqꞌ sibꞌal kam nichikꞌam tiꞌ echaꞌ vaꞌl tzaꞌ. Loqꞌ ayaꞌ jankꞌal vaꞌl nichipaal itxumbꞌal qꞌu aanima tuul tila. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Utz yeꞌxhkam nichichusuneꞌ oj yeꞌ nichikꞌam tiꞌ kam. Pek ech koj tu qꞌul ichusulibꞌ, xamtel nichtal u tokebꞌal te aas ijunal texh tuchꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Uncheeꞌ ankoꞌxh tu u qꞌii tziꞌ, aꞌ tek nichixeꞌtisotz saj, tal u Jesuus ech tzaꞌ: —Qꞌexpojbꞌenoꞌ sala bꞌen u choo tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ech ok u Jesuus tu jukubꞌ. Utz ech talka ibꞌen tu qꞌu mam tenam. Iqꞌol bꞌen tu qꞌul ichusulibꞌ. Utz xambꞌu bꞌen unjot jukubꞌ tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Pek yeꞌk talcheꞌ xeꞌt maꞌl mam kajiqꞌ viꞌ u choo. Utz nichtekikoꞌp aꞌ tu u jukubꞌ tu vipilqꞌaꞌtxan u choo. Ech nichtekxeꞌtikoꞌp u jukubꞌ jaqꞌ aꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pek aatz u Jesuus tan, vatchich tiꞌ iqul u jukubꞌ viꞌ maꞌl viꞌtzꞌ. Ech kꞌasal tu qꞌul ichusulibꞌ utz, tal te ech tzaꞌ: —Chusul, ¿yeꞌxh naqeon tiꞌ tzik aas toj sotzojoꞌ tu u aꞌ tziꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ech ilakpu u Jesuus. Tal tu u mam kajiqꞌ jabꞌal aas sayaꞌi. Utz tal tu u choo ech tzaꞌ: —Yaꞌen, jutzach.— Texh te. Ech yakich yaꞌoj. Ech vaꞌlich texh tachavan ikalkoch u aꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tal tek tu qꞌul ichusulibꞌ ech tzaꞌ: —¿Kam tokeꞌ aꞌxh bꞌoj exoꞌveꞌ tziꞌ? ¿Kantuꞌ yeꞌ kꞌujlel ekꞌuꞌl viꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tan techalich motx ixoꞌveꞌ. Utz nichtexhtal sivatzaj ech tzaꞌ: —¡Abꞌil techit u vinaj tziꞌ aas ninimal tu u kajiqꞌ jabꞌal tziꞌ utz, ninimal tu u choo majte tziꞌ!— Texh tibꞌilaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ech tek opon u Jesuus tuchꞌ qꞌul ichusulibꞌ tunpaqꞌit itziꞌaj u choo tikuenta u txꞌavaꞌ Gaadara. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Utz yakich ul kꞌulaxoj tel u Jesuus tu jukubꞌ tu maꞌl u vinaj, aꞌ kꞌaskuꞌl viꞌ kamnaj. Atich ok tioxhil txꞌiꞌliꞌinaj kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tiira aꞌ tatibꞌal viꞌ kamnaj. Utz abꞌil tereꞌn koj nichtoleꞌ tiꞌ, kꞌuxh nichiqitzpu tu kadeena. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tan jatpajul koꞌn maꞌtich iqitzpu tu chꞌichꞌ tuchꞌ tu kadeena. Pek nichkoꞌnitzut tuul qꞌu kadeena. Utz bꞌoono koꞌn itxꞌajax qꞌu chꞌichꞌ nichiꞌaneꞌ, qꞌu qitzbꞌal tetz. Ech yeꞌxhabꞌil maꞌj nichtoleꞌ tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Utz kexhich iqꞌeqꞌun ipaal viꞌaj muunte, qꞌiils aqꞌbꞌal majte, tuchꞌ viꞌaj kamnaj. Utz vaꞌl takꞌonsat jeꞌ tibꞌ tu sivan. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ech taꞌxh til itoop u Jesuus tzian, yakich jutzin toponeꞌ. Utz ex pecheꞌoj kuꞌ siatz. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Qꞌeqꞌun taltu te ech tzaꞌ: —¡Kam asaꞌ ve Jesuus iKꞌaol Tꞌankin Tioxh! ¡Nunjaj see tuchꞌ Tioxh aas yeꞌ koꞌxh uulebꞌeꞌin!— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Tan nichtal u Jesuus te ech tzaꞌ: —Elen kꞌatz u vinaj tziꞌ, tioxhil txꞌiꞌliꞌinaj.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Uncheeꞌ chꞌotil te tu u Jesuus ech tzaꞌ: —¿Kam abꞌii?— Texh te. Tzaqꞌbꞌi utz, tala: —Yeꞌ achebꞌe kubꞌii. Tan sibꞌal kuxaaneꞌ.— Texh u txꞌiꞌliꞌinaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ech aatz qꞌu tioxhil txꞌiꞌliꞌinaj tan, kaanaich ijajabꞌet u Jesuus aas yeꞌk soꞌojchal el tikuenta u txꞌavaꞌ tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Uncheeꞌ atich unjolol qꞌu bꞌoch tziꞌ, nichtechbꞌun xeꞌ maꞌl muunte, tiira sibꞌal ixaaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ech aatz qꞌu tioxhil txꞌiꞌliꞌinaj tan, ijajabꞌe u Jesuus; tal te ech tzaꞌ: —Aqꞌ tzii qe aas soꞌokꞌoꞌ kꞌatz qꞌu bꞌoch tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Aqꞌax tzii te tu u Jesuus. Utz el tek qꞌu tioxhil txꞌiꞌliꞌinaj kꞌatz u vinaj. Utz ok kꞌatz kajay qꞌu bꞌoch qꞌul 2,000 ixaaneꞌ. Ech yakich motx ex ikꞌon bꞌen tibꞌ qꞌu bꞌoch tziꞌ peepu taqꞌo. Bꞌen tu choo. Utz ech motx ijiqꞌmu tu aꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Uncheeꞌ aatz tek qꞌu xeen bꞌoch, motx tꞌaspi kꞌasuꞌl. Ex tal tu tenam qꞌu kam uchi tziꞌ, tuchꞌ tu qꞌu jaꞌjtzeꞌ. Ech ul ilaxoj tu qꞌu aanima kam vaꞌl maꞌtich tucheꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Utz taꞌxh motx opon qꞌu aanima kꞌatz u Jesuus, yakich til u vinaj vaꞌl maꞌtich tulevansal tu qꞌu tioxhil txꞌiꞌliꞌinaj. Tan sibꞌla tioxhil txꞌiꞌliꞌinaj atich ok kꞌatza bꞌanel. Chꞌuxhlich tekuꞌen. Atich tek ok toksaꞌm. Tiira bꞌaꞌn tekuꞌen. Ech motx xoꞌvi. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Uncheeꞌ aatz tek qꞌu aanima, qꞌuꞌl ilon qꞌu kam tziꞌ, motx tek tal tu unjot qꞌuꞌl anal motx oponi, aas kam vaꞌl iꞌan u vinaj, vaꞌl atich ok tioxhil txꞌiꞌliꞌinaj kꞌatza. Utz tal majte kam vaꞌl iꞌan qꞌu bꞌoch. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ech aatz qꞌu aanima, xeꞌt tek motx ijaj bꞌaꞌnil tu u Jesuus aas saelbꞌen tikuenta qꞌul itxꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Uncheeꞌ tuul tek ok u Jesuus tu jukubꞌ, xaan opon u vinaj kꞌatza vaꞌl atich ok u tioxhil txꞌiꞌliꞌinaj kꞌatza bꞌanel. Ijaj bꞌaꞌnil te aas taꞌn saxambꞌu tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pek aatz u Jesuus tan, yeꞌt taqꞌ tzii te. Tal koꞌn te ech tzaꞌ: —Kuxh taatibꞌal xeꞌ qꞌul iitzꞌin aatzik utz, al te kam u mam bꞌaꞌnil vetiꞌanlu u Tioxh see. Utz al te aas kaniꞌch mitxumt aatz.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ech bꞌeni. Utz xeꞌt ipaxsa itziiul tu vikuenta qꞌu tenam Decaapolis aas kam u mam bꞌaꞌnil iꞌan u Jesuus te. Motx tzꞌejx ikꞌuꞌl aanima taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Uncheeꞌ okkꞌasuꞌl u Jesuus tu jukubꞌ. Ul tunpaqꞌit itziꞌaj u choo. Utz mam tenam imoloꞌk tibꞌ tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ech opon maꞌl u vinaj qꞌesala tu u atibꞌal chusbꞌal tetz u oꞌtla mantaar, Jairo ibꞌii. Ech taꞌxh tila, pecheꞌ kuꞌ vatz u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Utz ech vaꞌlich ijajtu bꞌaꞌnil tu u Jesuus ech tzaꞌ: —¡Bꞌan bꞌaꞌnil seꞌenaxh viꞌ tan, tiira tajinnaj vunmeꞌal tu yaabꞌil cheel! Seꞌnaaqꞌ jeꞌ vaqꞌabꞌ tibꞌa, ech siꞌan bꞌaꞌn utz, saꞌatin itiichajil.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ech bꞌen u Jesuus tiꞌ. Mam tenam xambꞌu bꞌen tiꞌ. Utz kexhich ipitax xoꞌl aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Uncheeꞌ tuul atich ok u Jesuus tiꞌ bꞌey, xamich maꞌl u ixoj tiꞌ. Yaꞌvich. Kaj nichtel kꞌatza. Utz yeꞌ nichiyaꞌeꞌ. Kabꞌlaalich yaꞌbꞌ ixeꞌteꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tiira maꞌtich ipaal tu kꞌaxkꞌo tiqꞌabꞌ sibꞌal aa tzꞌak. Utz maꞌtich isotzsat kajay qꞌu tetz atiche tiꞌ itzꞌakat tibꞌ. Pek kam koj yolonka. Aal koꞌn nichitajineꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ech aatz tabꞌi itziiul qꞌu txaichil nichiꞌan u Jesuus, oponi. Xambꞌu tiꞌ. Ok xoꞌl qꞌu mam tenam. Utz ikanoꞌk ijuꞌ u toksaꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Tan nichnaltal u ixoj tiꞌ taanima ech tzaꞌ: —Saꞌxhunbꞌan bꞌaꞌn atziꞌ kꞌuxh taꞌxh sunkan vijuꞌ u toksaꞌm.— Texhich. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ech yaꞌ tel u kaj kꞌatza. Utz yakich inacha aas bꞌaꞌntich tek tu tzaꞌlla yaabꞌil vaꞌl nichbꞌanon. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ech tu u muꞌkꞌul tziꞌ, yakich inach u Jesuus aas maꞌl txaichil iꞌana aas kanax ok u toksaꞌm. Isuchqꞌi tibꞌ xoꞌl u mam tenam. Tal ech tzaꞌ: —¿Abꞌil vaꞌl vetkanon ok u voksaꞌm tziꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Aatz qꞌul ichusulibꞌ tan, tal te ech tzaꞌ: —Qꞌu mam tenam nipitonaxh tziꞌ utz, naaleꞌ: «¿Abꞌil vaꞌl vetkanonokꞌin?» Chaꞌaxh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pek sajin paal u Jesuus tiꞌaj. Aꞌ isaꞌ tiltaꞌ abꞌil vaꞌl kanon ok. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Uncheeꞌ aatz u ixoj, vaꞌlich tek itꞌuntꞌuꞌlan tu xoꞌval tan, nichichokax tu u Jesuus. Utz atich tek sikꞌuꞌl u ixoj, aas maꞌt tel u yaabꞌil kꞌatza. Ech ul pecheꞌoj kuꞌ vatz u Jesuus, tiꞌ talax kajay vinujul te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Aatz u Jesuus tan, tal te: —Tiꞌ koꞌn vikꞌujeꞌ akꞌuꞌl vetaꞌanlu bꞌaꞌn txutx. Pek kuxh, txꞌanel abꞌenaꞌ. Taꞌn vetaꞌanlu bꞌaꞌn tu vayaabꞌil tziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ech tuul ankoꞌxh nichiyolon u Jesuus, opon unjolol aanima. Aꞌ kꞌaskuꞌl tu atibꞌal xeꞌ u Jairo, u qꞌesala tu atibꞌal chusbꞌal tetz u oꞌtla mantaar. Utz tal ech tzaꞌ: —¡Kamyu vameꞌal! Yeꞌ koꞌxh akalabꞌtziiu veꞌt u chusul tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pek yeꞌt toksa tetz u yol u Jesuus vaꞌl ex alchoj. Tal tek tu u Jairo ech tzaꞌ: —Yeꞌ koꞌxh qeonaxh. Kꞌujeꞌoj koꞌn akꞌuꞌl.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Uncheeꞌ ech ibꞌenaꞌ. Loqꞌ yeꞌt taqꞌ tzii abꞌil koꞌxh seꞌen tiꞌ. Pek taꞌxh bꞌen u Luꞌ, u Jacobo, tuchꞌ u Xhan, vitzaꞌqꞌ u Jacobo. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ech opon u Jesuus tu atibꞌal xeꞌ u Jairo, u qꞌesala tu u atibꞌal chusbꞌal tetz u oꞌtla mantaar. Utz tila aas vaꞌlich tuch qꞌeqꞌelkabꞌinchil. Atia vaꞌlich iqꞌeqꞌun tu oqꞌel. Utz atia kaana txumumla chaj yol nichtal tu oqꞌel. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ech taꞌxh okoꞌp u Jesuus tal ech tzaꞌ: —¿Kam tokeꞌ aas vaꞌl eqꞌeqꞌelkabꞌineꞌ utz, vaꞌl etoqꞌeꞌ? Tan yitꞌ kamnaj koj u ixviak tziꞌ. Vatchel koꞌn atziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pek nichkoꞌnteesal iqꞌii tiꞌ vaꞌl tala. Ech ipaasa eluꞌl kajay qꞌu aanima qꞌanal. Utz taꞌxh tiqꞌoꞌk tiꞌ vitat u ixviak, tuchꞌ vinan utz, tuchꞌ qꞌuꞌl xamich tiꞌ. Ech motx tokoꞌp tu vaꞌl atichku u ixviak. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ech aatz u Jesuus, itxay iqꞌabꞌ u ixviak. Utz tal te ech tzaꞌ: —Talita cumi.— Texh te. —Ixviak axh nivalaxh. Lakpen.— Chu tokebꞌal u yol tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Utz yakich lakpoj u ixviak. Nichtekipaaleꞌ. Tan kabꞌlaalich tek iyaꞌbꞌ. Utz motx tzꞌejxu ikꞌuꞌl taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ech tiira tal bꞌaꞌnil aas yeꞌxhabꞌil koꞌxh tereꞌn soꞌootzajin u kam tziꞌ. Utz tal taqꞌax techbꞌubꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Uncheeꞌ elkꞌasuꞌl u Jesuus tziꞌ utz, opon tu vitenam tuchꞌ qꞌul ichusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ech aatz iꞌan tu u ilanbꞌal qꞌii, xeꞌt ichusun tu u atibꞌal chusbꞌal tetz u oꞌtla mantaar. Utz sibꞌal aanima nichabꞌin. Vaꞌlich itzꞌejx ikꞌuꞌl taqꞌo. Utz motx tal ech tzaꞌ: —¿Til tek neꞌntiqꞌov qꞌu kam nitaleꞌ tziꞌ, tuchꞌ vitxumbꞌal tziꞌ utz, tuchꞌ qꞌu mamaj txaichil qꞌuꞌl niꞌaneꞌ tziꞌ? ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Yitꞌ tzik aꞌ u kꞌoxol vaꞌl tziꞌ tzik, u titzꞌin u Liꞌ? ¿Yitꞌ tzik aꞌ u tatzik u Jacobo, u Xhep, u Judas utz, tuchꞌ u Xhim? Aal jejlel qꞌu tanabꞌ tzaꞌ atziꞌ.— Texhtuꞌ. Ech nichtekmotxteesa iqꞌii tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pek tal tek u Jesuus te ech tzaꞌ: —Aatz qꞌu alol tetz u yolbꞌal Tioxh, taꞌxh yeꞌ oknajk iqꞌii titenam, tuchꞌ xoꞌl titzꞌin tatzik utz, tuchꞌ tu tatibꞌal.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ech yitꞌ sibꞌal koj txaichil iꞌan tziꞌ. Kaꞌxvaꞌl koꞌxh yaꞌv iꞌan bꞌaꞌn te aas taqꞌ jeꞌ iqꞌabꞌ tibꞌa. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ech nichtexhisotz ikꞌuꞌl u Jesuus taqꞌo tan, yeꞌt nimal tu qꞌu aanima. Utz bꞌen u Jesuus tu qꞌu talaj tenam sinajaꞌch. Nichipaal tiꞌ ichusax u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Uncheeꞌ isikꞌle opon kabꞌlaal qꞌul ichusulibꞌ kꞌatza. Ech ichaj bꞌen. Kaꞌkaꞌbꞌil ixaan iꞌana. Utz taqꞌ tijleꞌm tiꞌ tojchal el qꞌu tioxhil txꞌiꞌliꞌinaj kꞌatz aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Utz tal bꞌen te bꞌaꞌnil aas yeꞌxhkam koꞌxh samotxtiqꞌo bꞌen tetz ibꞌey. Pek taꞌxh satiqꞌo bꞌen ibꞌaara. Yeꞌk satiqꞌo bꞌen techbꞌubꞌal. Yeꞌk satiqꞌo bꞌen itxim. Utz yeꞌk satiqꞌo bꞌen ipuaj tu qꞌu kolbꞌal ipuaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Utz yeꞌk satiqꞌo bꞌen untzumtu toksaꞌm. Taꞌxh satoksa bꞌen ipel xaabꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Tal te ech tzaꞌ: —Til loꞌoponkꞌex tu maꞌj atibꞌal, vatojex tziꞌ. Utz anal leꞌelkꞌasuꞌlex aas lakꞌasuꞌlex. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Pek oj yeꞌ lakꞌulaxex tu maꞌj tenam utz, yeꞌk likꞌulviꞌex tiꞌ qꞌul eyol, kꞌasojulex tziꞌ. Utz pujitajka el u pojoj te tajan. Techlal aas lakoꞌntila. Ech niꞌxhtekꞌval sete aas mam choobꞌal paav sakuꞌ tiꞌ qꞌu aanima tziꞌ aas laul u choobꞌal paav, paalchu vatz vaꞌl kꞌu tiꞌ qꞌu aa Sodoma tuchꞌ qꞌu aa Gomorra.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ech ikꞌasuꞌl qꞌu chusulibꞌ utz, xeꞌt ipaxsa itziiul tu qꞌu aanima aas samotxikꞌaxa qꞌul ipaav. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ech sibꞌal tioxhil txꞌiꞌliꞌinaj nichtojcha el. Nichtaqꞌ jeꞌ aseite tiviꞌ sibꞌal yaꞌv. Utz nichiꞌan bꞌaꞌn te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Uncheeꞌ aatz u ijlenal Herodes, tabꞌi iyolchu u Jesuus. Tan tiira maꞌtich ipax paal itziiul. Utz tal ech tzaꞌ: —U Xhan aꞌ qꞌaav itzꞌpi xoꞌl qꞌu kamnaj tziꞌ, ayaꞌ u bꞌanol vautiismo. Echixeꞌat atil mam tijleꞌm tiꞌ ibꞌanax txaichil.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pek aatz unjoltu qꞌu aanima, nichtal ech tzaꞌ: —Aꞌ qꞌaav itzꞌpi u Elias atziꞌ.— Chia. Utz at nichalon: —Maꞌj alol tetz u yolbꞌal Tioxh atziꞌ, echaꞌ qꞌuꞌl oꞌtene.— Texhich tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pek aatz tabꞌi qꞌu kam u Herodes tziꞌ, tal ech tzaꞌ: —U Xhan aꞌ qꞌaav itzꞌpia atziꞌ, vaꞌl val ikutil el iviꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Tan u Herodes maꞌtich alon itxaypu u Xhan. Utz tal iqitzpu tu kadeena. Utz taqꞌ kuꞌ tu tzeꞌ tiꞌ koꞌn u Herodias, u tixojich u Felipe, vitzaꞌqꞌ u Herodes. Tan aatz u Herodes tziꞌ, tiqꞌo jeꞌ u tixoj vitzaꞌqꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Utz nichtal u Xhan tu u Herodes ech tzaꞌ: —Yitꞌ bꞌaꞌn koj vaꞌl naꞌaneꞌ aas iqꞌomal u tixoj vatzaꞌqꞌ saaqꞌo tziꞌ.— Texhich te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ech tokeꞌ nichichiꞌon taanima u Herodias tiꞌ u Xhan. Utz nichiꞌan ikꞌuꞌl tiꞌ siyatzꞌeꞌ. Loqꞌ yeꞌ nichveet iꞌantu te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Tan nichixoꞌveꞌl u Herodes tiꞌ u Xhan. Tan tootzajich aas nojchit jikomla vinaj utz, xaannaj el kꞌatz paav. Ech tokeꞌ yeꞌ nichtaqꞌ tzii tiꞌ. Utz chajpaj nichtabꞌi iyolon u Xhan nichitzꞌejx ikꞌuꞌl taqꞌo. Vatzich ikꞌuꞌl tabꞌileꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pek opon maꞌl u qꞌii aas saveet iyatzꞌax u Xhan tu u Herodias. Aꞌ chit iꞌan tu u paalebꞌal iqꞌii u Herodes tetz tzꞌajebꞌal iyaꞌbꞌ. Taqꞌ maꞌl ibꞌaꞌnla echbꞌubꞌal qꞌu chꞌooal qꞌesala kꞌatza, tuchꞌ qꞌu qꞌesal sol utz, tuchꞌ qꞌu chꞌooal qꞌesala tu Galilea. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Utz opon u ixviak, u titzꞌin u Herodias. Ech bꞌixi. Utz txꞌanel chit til u Herodes tuchꞌ qꞌul imol atich vatz meexha. Ech tal tek u ijlenal tu u ixviak ech tzaꞌ: —Jaj ve kam asaꞌ utz, savaqꞌ see.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Utz talaꞌtziꞌi te tibꞌii qꞌul itioxh ech tzaꞌ: —Jankꞌal chit vaꞌl sajaj ve, savaqꞌ see, kꞌuxh nikꞌamil u txꞌiibꞌal qꞌii tetz u vijlenalil.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Uncheeꞌ elkꞌasuꞌl u ixviak, ex tabꞌi tu vinan ech tzaꞌ: —¿Kam sunjaj te nanacheꞌ?— Texh te. —Jaj viviꞌ u Xhan te, u bꞌanol vautiismo.— Texh teꞌleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ech oora bꞌenoꞌk u ixviak xeꞌ u ijlenal utz, tal te ech tzaꞌ: —Aatz cheel, aꞌ unsaꞌ saaqꞌ viviꞌ u Xhan ve tu maꞌl puraato, u bꞌanol vautiismo.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Uncheeꞌ txumun chit u Herodes tiꞌ vaꞌl jajax te. Loqꞌ yeꞌxhkaniꞌch taltaꞌ aas yeꞌka chaj koj tan, vatz qꞌul imol atich vatz meexha talaꞌtziꞌi. Utz toksa ibꞌii qꞌul itioxh tuul tiꞌ itzojpit viyol vaꞌl tala. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ech oora ichaj bꞌen maꞌl qꞌul isol. Utz tal te aas satiqꞌo ul viviꞌ u Xhan. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ech ibꞌen u sol. Ex ikuti el iviꞌ u Xhan tu tzeꞌ. Utz tiqꞌo ul viviꞌ tu maꞌl puraato. Ech taqꞌ tu u ixviak. Utz aatz tek u ixviak, ex taqꞌ tu vinan. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Aatz tabꞌi u kam qꞌul ichusulibꞌ u Xhan tziꞌ, motx oponi. Ex tiqꞌo vinimal utz, imuja. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Uncheeꞌ qꞌaav tek imol tibꞌ u Jesuus, tuchꞌ qꞌul ichaj aas qꞌaavuꞌl. Utz motx tal te kam motx iꞌana utz, kam qꞌuꞌl maꞌtich en ichustuka. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Aatz u Jesuus tal te: —Niꞌextaj. Koꞌtaj tu maꞌj tzꞌinlich txꞌavaꞌ ech sailanbꞌojoꞌ.— Texh te. Tan sibꞌla chit aanima nichtul ibꞌen tzixeꞌ. Aal nikoꞌxh nichtereꞌnkojitxꞌolpeꞌ aas saechbꞌun bꞌioj. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ech motx okbꞌen tu maꞌl jukubꞌ. Bꞌen tu maꞌl u tzꞌinlich txꞌavaꞌ xaanaj el. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pek sibꞌal aanima ilon ibꞌenaꞌ. Utz ootzajili til maꞌtka. Ech tꞌaspi bꞌen qꞌu aanima tu tajan. Aꞌ elkubꞌen tu qꞌu tenam. Utz bꞌaxal motx opon siatz. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ech el u Jesuus tu u jukubꞌ. Til qꞌu mam tenam utz, itxum iatz tan, tila aas echaꞌ karneꞌl yeꞌk xeen tetz. Ech sibꞌal kam xeꞌt ichuseꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Aatz iꞌana aas maꞌtich techit ikuꞌ qꞌii bꞌaꞌnil, xaan opon qꞌul ichusulibꞌ kꞌatza utz, tal te ech tzaꞌ: —Maꞌxh kuꞌy qꞌii utz, yeꞌxhkam bꞌoj atil tu vaꞌl atilkꞌoꞌ tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Pek chaj bꞌen qꞌu aanima tziꞌ. Ech samotxeniloqꞌ techbꞌubꞌal xeꞌ qꞌu aanima tu qꞌu jaꞌjtzeꞌ, tuchꞌ tu qꞌu talaj tenam tziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tzaqꞌbꞌu u Jesuus ech tzaꞌ: —Aqꞌtaj techbꞌubꞌal tzexeꞌ.— Texh te. Ech motx tzaqꞌbꞌi utz, tala: —Kꞌuxh sibꞌal kaxhlaan txꞌix siloqꞌ 200 jaꞌmel qꞌii aqꞌon utz, saqaqꞌ techbꞌubꞌal saqaleꞌ, saꞌkojtakꞌa.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Aatz u Jesuus tan, tala: —¿Jatvaꞌl kaxhlaan txꞌix atil tzexeꞌ? Bꞌenoj etileꞌ.— Texh te. Ech aatz veet ex tileꞌ, motx tala: —Oꞌvaꞌl koꞌxh kaxhlaan txꞌix tuchꞌ kaꞌvaꞌt txay atile.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ech talt ikꞌujeꞌ kuꞌ qꞌu aanima tiꞌ tanul viꞌ u chaꞌxla chꞌim. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ech motx ikꞌujeꞌ qꞌu aanima tiꞌ tanul tiꞌ 100 ixaaneꞌ utz, tiꞌ 50 ixaaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Uncheeꞌ aatz u Jesuus, itxay oꞌvaꞌl u kaxhlaan txꞌix tiqꞌabꞌ tuchꞌ kaꞌvaꞌt u txay. Ech sajin jeꞌ tu amlika. Ijaj bꞌaꞌnil tiꞌ. Utz ipixh qꞌu kaxhlaan txꞌix. Taqꞌ tu qꞌul ichusulibꞌ. Utz aatz qꞌul ichusulibꞌ, taqꞌ tek tu qꞌu aanima. Ijatx paal kaꞌvaꞌl u txay siatzaj majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ech motx echbꞌuni sikajayil utz, motx nooi. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ech molax u kaxhlaan txꞌix tuchꞌ qꞌu txay qꞌuꞌl chanani. Kabꞌlaat txakatx elkoꞌp. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Utz 5,000 ixaan qꞌu vinaj qꞌuꞌl echbꞌuni. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Uncheeꞌ aatz u Jesuus, oora tal tok bꞌen qꞌul ichusulibꞌ tu jukubꞌ. Aꞌ isaꞌ aas samotxbꞌaxabꞌ bꞌen siatz tunpaqꞌit itziꞌaj u choo tu Betsaida, tuul nichtalka ibꞌen tu qꞌu mam tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ech bꞌen tek viꞌ maꞌl u muunte tiꞌ iqꞌilal isikꞌlel Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ech aatz iꞌan sotzsaj, atich tek qꞌu chusulibꞌ tinikꞌa u choo. Utz ijunalich koꞌn u Jesuus atichka eluꞌl vatz txꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Utz til u Jesuus aas tuchꞌ chit peena nichtiqꞌo u jukubꞌ qꞌul ichusulibꞌ tan, ok maꞌl u mam kajiqꞌ tibꞌey. Ech aalich texh isajbꞌu saj ul u Jesuus kꞌatza; xaaom tul viꞌ u choo. Utz iꞌana echaꞌ siꞌchkoꞌnpaal yakloj siatz tilon tu vaꞌl iꞌana. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ech aatz qꞌu chusulibꞌ tan, taꞌxh motx tila nichixaan viꞌ u choo, motx titzꞌa aas poyinalich. Ech motx qꞌeqꞌun taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Motx kꞌaybꞌ ikꞌuꞌl. Pek aatz u Jesuus yakich tal te ech tzaꞌ: —Yeꞌ koꞌxh qeonex. Tan in atziꞌ. Yeꞌ koꞌxh xoꞌvex.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ech ijeꞌop u Jesuus kꞌatza tu u jukubꞌ. Utz kuꞌ tek ivatz u mam kajiqꞌ. Ech tiira motx tzꞌejx ikꞌuꞌl taqꞌo utz, xoꞌvi. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Tan aal ankoꞌxh yeꞌsajich motx ipaal itxumbꞌal tuul kam tok u txaichil vaꞌl uch tiꞌ qꞌu kaxhlaan txꞌix. Yeꞌ nichtok qꞌu kam tiviꞌ tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Taꞌxh motx iranka u choo, ul tek tu u txꞌavaꞌ Genesareet. Utz motx ikꞌalka u jukubꞌ tziꞌ choo. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ech motx el tu u jukubꞌ. Utz aatz qꞌu aanima, yakich motx tila aas u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ech motx paal tikuenta kajay u txꞌavaꞌ tziꞌ. Utz iqꞌol ul qꞌu yaꞌv siatz. Til koꞌn nichkꞌaskuꞌl. Kꞌuxh tu chelebꞌ tetz niiqꞌolik kꞌasuꞌl. Utz neꞌntaqꞌ tu vaꞌl atichku u Jesuus nichtabꞌi. ");
INSERT INTO ixlCNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ech til chit nichoponku u Jesuus, nichtaqꞌax kuꞌ qꞌu yaꞌv tibꞌey, kꞌuxh tulaj tenam, oj tu jaꞌjtzeꞌ. Utz nichijajabꞌeleꞌ aas sataqꞌ tzii tu qꞌu yaꞌv aas taꞌxh sikan vitziꞌaj u toksaꞌm. Uncheeꞌ ech nichiꞌaneꞌ. Kajay qꞌuꞌl nichmotxkanon, nichiꞌanka bꞌaꞌn. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Uncheeꞌ opon qꞌu fariseo kꞌatz u Jesuus. Ant imol unjolol qꞌu aa txumbꞌal tetz u oꞌtla mantaar. Aꞌ kꞌaskuꞌl tu Jerusaleen. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Utz motx tila aas xeꞌt itxꞌaꞌn qꞌul ichusulibꞌ u Jesuus utz, yeꞌt motx iꞌan u kostuumbre tiꞌ itxꞌaal qꞌabꞌ. Ech taqꞌtu bꞌens aa paav. Tan, txaaꞌ vatz qꞌul ikostuumbre tzꞌibꞌamal vaꞌl iꞌana. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Tan aatz qꞌu fariseo tziꞌ tuchꞌ qꞌu qꞌesala xoꞌl qꞌu Israeel, jatpajul koꞌxh nichitxꞌaa iqꞌabꞌ bꞌaxa, ech tek nimotxitxꞌaꞌneꞌ. Tan tiira aꞌ chit nimotxtoksa tetz vikostuumbre qꞌul ikꞌuy imam tzꞌibꞌamal. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Utz echaꞌ tziꞌ oj anal koꞌn iqꞌaav tu kꞌayibꞌal, jatu koj satxꞌaꞌni oj yeꞌxhkam nitxꞌaa iqꞌabꞌ. Utz taꞌn koꞌn koj. Pek sibꞌ tereꞌn koꞌxh kostuumbre nichmotxinima. Echaꞌ tiꞌ itxꞌaal qꞌul ivaaso, tuchꞌ itxeꞌn utz, tuchꞌ kaniꞌch itxꞌaat qꞌul ichꞌichꞌ kambꞌal niꞌan majte utz, tuchꞌ qꞌul itxꞌach. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ech aatz qꞌu fariseo tuchꞌ qꞌu aa txumbꞌal tetz u oꞌtla mantaar, ichꞌoti tu u Jesuus ech tzaꞌ: —¿Kam tokeꞌ yeꞌ ninima vikostuumbre qꞌu kukꞌuy kumam tzꞌibꞌamal qꞌul achusulibꞌ tziꞌ? Tan yeꞌ nitxꞌaa iqꞌabꞌ nitxꞌaꞌneꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ech tzaqꞌbꞌu u Jesuus utz, tal ech tzaꞌ: —¡Kaꞌvatz! Ekꞌul el chit vaꞌl tal u Isaias setiꞌ ech tzaꞌ: «Aatz qꞌu tenam tziꞌ, tu koꞌxh qꞌul itziꞌ nitoksa unqꞌii. Pek tzian elnaj qꞌu taanima sunkꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ech yeꞌk koꞌxh tokebꞌal kꞌuxh nitoksa unqꞌii. Tan aꞌ nichus ikostuumbre aanima. Nibꞌensas echaꞌ vunmantaar.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Tan aꞌ nimotxetaqꞌka vimantaar u Tioxh. Pek aꞌ tii nebꞌan inimal kostuumbre tzꞌibꞌamal aas imantaar koꞌn aanima. Echaꞌ vekostuumbre tiꞌ txꞌaal txeꞌn tuchꞌ kambꞌal utz, vekostuumbre tiꞌ tereꞌn kam.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Utz tal paj u Jesuus te ech tzaꞌ: —Etelabꞌal iqelax vimantaar u Tioxh tan, aꞌ esaꞌ yeꞌ koj chit sotz qꞌul ekostuumbre netaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tan echaꞌ vimantaar u Tioxh talka u Moisees ech tzaꞌ: «Atoj tatin atxutx abꞌaal saatz.» Chia. Utz nital majte: «Abꞌil vaꞌl yeꞌk itxaꞌk itxutx ibꞌaal siatz, yatzꞌel sabꞌanli.» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pek aatz ex, netaleꞌ: «Yeꞌxhkantuꞌ kꞌuxh satal maꞌj aanima titat inan ech tzaꞌ: Kuyin, vetvalaꞌtziꞌil tu u Tioxh kajay vapuaj savaqꞌeꞌ bꞌanel. Ech yeꞌxhkam veꞌt eetz savaqꞌeꞌ. Chaj.» Cheꞌex. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Utz aatz tu vaꞌl netaleꞌ tziꞌ, yeꞌkan tek niloch itxutx ibꞌaal setaqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ech aꞌ neyakꞌinsa vikostuumbre qꞌul ekꞌuy emam tzꞌibꞌamal utz, neqel u Yolbꞌal Tioxh. Utz sibꞌ tereꞌn koꞌxh kam nebꞌaneꞌ echaꞌ qꞌuꞌl tziꞌ.— Texh u Jesuus te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ech aatz u Jesuus, isikꞌle tek ul u mam tenam kꞌatza. Utz tal te ech tzaꞌ: —Abꞌitaj bꞌaꞌnil vaꞌl nivaleꞌ tzaꞌ kajay ex. Utz paaloj etxumbꞌal tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Yeꞌk maꞌj echbꞌubꞌal saꞌaqꞌon bꞌens aa paav u aanima kꞌuxh yeꞌ siꞌan u kostuumbre tiꞌ itxꞌaal iqꞌabꞌ. Pek aꞌ niaqꞌon bꞌens aa paav qꞌu yeꞌxtxojla yol nijeꞌul titziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Abꞌiste ex niabꞌin qꞌu yol tzaꞌ, nimataj.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Uncheeꞌ elbꞌen u Jesuus kꞌatz qꞌu tenam, bꞌenoꞌk tu maꞌl otzotz. Aatz qꞌul ichusulibꞌ, motx ichꞌoti te aas kam tok u yol vaꞌl tala. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ech tal u Jesuus ech tzaꞌ: —Utz ¿ant ex yeꞌxh bꞌoj etxumbꞌal tzik? ¿Yeꞌ nekan tabꞌil tokebꞌal? Tan yeꞌxhkam nikuꞌ u aanima tu paav tu vaꞌl nitechbꞌu, kꞌuxh yeꞌ sitxꞌaa iqꞌabꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tan yeꞌxhkam niyansa u taanima tu paav. Pek tu koꞌn tuul nikoꞌkoꞌp. Utz nibꞌen tu xaanbꞌal.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Utz tal ech tzaꞌ majte: —Pek aꞌ niaqꞌon bꞌen u aanima tu paav qꞌu yeꞌxtxojla chaj yol nijeꞌul titziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tan tu taanima qꞌu aanima nikꞌaskuꞌl qꞌu yeꞌxtxojla chaj txumbꞌal. Echaꞌ u eesaibꞌ tu bꞌey tuchꞌ aanima, u yatzꞌoꞌm, ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","u elaqꞌ, qꞌu kam yeꞌk nooebꞌal tiꞌ, qꞌu yeꞌxtxoj, u subꞌuꞌm, u tzuꞌkin pabꞌaꞌl, u chiꞌkꞌulaꞌm, u chuli yol, u tꞌeꞌsil utz, tuchꞌ vaꞌl taꞌxh okoj tetz. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tan aatz kajay qꞌu paav tziꞌ, aꞌ nicheek tu taanima u aanima. Utz aꞌ vaꞌl niaqꞌon kuꞌ tu paav.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Uncheeꞌ kꞌastekꞌul u Jesuus tu vaꞌl atichka utz, bꞌen tikuenta u tenam Tiro tuchꞌ tikuenta Sidoon. Utz okoꞌp tu maꞌl u atibꞌal. Loqꞌ yeꞌich isaꞌ aas abꞌil saꞌabꞌin. Pek yitꞌ ech koj elka. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Tan tabꞌi maꞌl u ixoj aas atich u Jesuus tziꞌ. Oponi utz, ex pecheꞌoj ok siatz. Tan atich maꞌl titzꞌin ixviak atich ok tioxhil txꞌiꞌliꞌinaj kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Utz ijaj bꞌaꞌnil u ixoj tu u Jesuus aas satojcha el u tioxhil txꞌiꞌliꞌinaj kꞌatz u titzꞌin. Loqꞌ puera aanima; yitꞌ Israeel koj. Aa tenam tu Feniicia tikuenta Siiria. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Aatz u Jesuus tan, tal te: —Aꞌ bꞌaxal sunbꞌan bꞌaꞌn tu qꞌu Israeel tziꞌ. Yitꞌ saꞌkojiꞌaneꞌ saqeesa u bꞌaꞌnil vatz qꞌu Israeel utz, saqaqꞌ tu qꞌu puera aanima. Echaꞌ u kaxhlaan txꞌix saꞌkojiꞌaneꞌ saqeesa vatz qꞌu kꞌaol meꞌala utz, aꞌ savaqꞌvu tu qꞌu txꞌiꞌ.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tzaqꞌbꞌu u ixoj ech tzaꞌ: —Aꞌ chituꞌ unBꞌaal. Pek loqꞌ aal aatz qꞌu txꞌiꞌ, nimotxtechbꞌu qꞌu juyaj txꞌix qꞌuꞌl nichajpu koꞌp jaqꞌ u meexha tetz qꞌu kꞌaol meꞌala.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ech tal u Jesuus te ech tzaꞌ: —Kuxh, elyu u tioxhil txꞌiꞌliꞌinaj kꞌatz val iitzꞌin tan, kꞌujlel akꞌuꞌl viꞌ tu u yol vetaallaꞌ tziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Uncheeꞌ opon u ixoj tu totzotz. Utz anchituꞌ. Xoklich u titzꞌin viꞌ txꞌach. Maꞌtich tel u tioxhil txꞌiꞌliꞌinaj kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Uncheeꞌ kꞌasuꞌl u Jesuus tikuenta Tiro, paal tu Sidoon, tuchꞌ tikuenta Decaapolis utz, opon tziꞌ u choo tu Galilea. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ech iqꞌol opon maꞌl u vinaj siatz, chakan. Utz kꞌabꞌ tziꞌ majte. Ech jajax bꞌaꞌnil tu u Jesuus aas sataqꞌ jeꞌ iqꞌabꞌ tibꞌa. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Uncheeꞌ aatz u Jesuus, ixaanseꞌl u vinaj xoꞌl qꞌu tenam. Utz taqꞌ okoꞌp qꞌu viꞌ iqꞌabꞌ tixichin u yaꞌv. Takꞌsa viꞌ iqꞌabꞌ titzubꞌ majte utz, ikanoꞌk u taqꞌ u vinaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ech sajin jeꞌ tu amlika utz, ixijxoꞌlansa tibꞌ. Utz tal tu u vinaj ech tzaꞌ: —Efata.— Texh te. —Jajpen.— Chia niyolonka. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Yakich abꞌinoj u vinaj. Utz iꞌan bꞌaꞌn u taqꞌ. Ech tiira bꞌaꞌnich tek iyoloneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Uncheeꞌ aatz u Jesuus, tal tu qꞌu aanima aas yeꞌxhabꞌil koꞌxh e saꞌalaxku u kam tziꞌ. Pek kꞌuxh tzukꞌel nichtaleꞌ, aal koꞌn maas nichipaxsal itziiul. ");
INSERT INTO ixlCNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ech techalich itzꞌejx ikꞌuꞌl qꞌu aanima taqꞌo. Utz nichtekmotxtal tiꞌ ech tzaꞌ: —¡Techal kajay qꞌuꞌl niꞌaneꞌ tziꞌ! Tan nitabꞌin qꞌu chakan taqꞌo utz, niyolonsa qꞌu mem majte.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Aatz iꞌan tu qꞌu qꞌii tziꞌ, mam tenam paj molich tibꞌ kꞌatz u Jesuus. Utz yeꞌkanich techbꞌubꞌal qꞌu aanima. Ech aatz u Jesuus, isikꞌle ul qꞌul ichusulibꞌ utz, tal te ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Nuntxum iatz qꞌu tenam tziꞌ. Tan oxvaꞌx qꞌii cheel tatin sunkꞌatza utz, yeꞌkan techbꞌubꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Utz oj sakoꞌxhunchaj bꞌen tulaj tatibꞌal ech tziꞌ, sajochpu tu bꞌey atziꞌ. Tan atia tzian vetmotxkꞌaskuꞌl.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Utz tal qꞌul ichusulibꞌ ech tzaꞌ: —Til koj saelku techbꞌubꞌal u mam tenam tziꞌ tan, tzꞌinlich txꞌavaꞌ atzaꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ech ichꞌoti u Jesuus te ech tzaꞌ: —¿Jankꞌat kaxhlaan txꞌix atil tzexeꞌ?— Texhtuꞌ. Motx tzaqꞌbꞌu ech tzaꞌ: —Jujvaꞌl.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ech aatz u Jesuus, tal ikꞌujeꞌ qꞌu aanima vatz txꞌavaꞌ. Utz itxay jujvaꞌl u kaxhlaan txꞌix tiqꞌabꞌ. Ijaj bꞌaꞌnil tiꞌ. Ipixh tuul utz, taqꞌ tu qꞌul ichusulibꞌ. Aꞌ tek motx jatxon paal vatz qꞌu mam tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Atich kaꞌxvaꞌl txay tzixeꞌ majte. Utz ijaj bꞌaꞌnil u Jesuus tiꞌ. Ech paj talt ijatxax paal vatz qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ech motx txꞌaꞌni. Motx nooi. Utz molax tek qꞌuꞌl chanani. Jujvaꞌt txakatx elkoꞌp. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Utz kamal 4,000 ixaan qꞌuꞌl txꞌaꞌni. Ech tek chajax bꞌen tu u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Oktekbꞌen u Jesuus tu jukubꞌ tuchꞌ qꞌul ichusulibꞌ utz, motx bꞌen tikuenta u txꞌavaꞌ Dalmanuta. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Uncheeꞌ opon unjolol qꞌu fariseo kꞌatz u Jesuus. Utz ikalabꞌtziiu tibꞌ tuchꞌ. Vet sikꞌuꞌl motx iꞌana. Motx ijaj xheenya te sikꞌuch tu amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ech xijxoꞌlan u Jesuus tiꞌ utz, tal te ech tzaꞌ: —¿Kam tokeꞌ nejaj xheenya, ex itzꞌlelex tu u tiempo tzaꞌ? Niꞌxhtekꞌval sete, yeꞌk xheenya sakꞌuchax tu qꞌu aanima tu tiempo tzaꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ech taqꞌaxka tu u Jesuus. Utz qꞌaavoꞌk tu jukubꞌ. Bꞌen sala bꞌen u choo. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Uncheeꞌ aatz qꞌu chusulibꞌ, yeꞌt motx inach tiqꞌol kaxhlaan txꞌix. Maꞌl koꞌn kaxhlaan txꞌix iqꞌomich taqꞌo tu jukubꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Utz tal u Jesuus te ech tzaꞌ: —Kuentaꞌex tiꞌ vaꞌl nichus qꞌu fariseo utz, tuchꞌ vichusbꞌal u Herodes. Tan echaꞌ txꞌamil kaxhlaan txꞌix, paxinchil niꞌaneꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ech nichtekmotxiyol qꞌu chusulibꞌ sivatzaj ech tzaꞌ: —Kꞌuxh nital ech tziꞌ, tiꞌ atziꞌ tan, yeꞌn kunach tiqꞌol kukaxhlaan txꞌix.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Pek paal itxumbꞌal u Jesuus tu vaꞌl nichmotxiyoleꞌ utz, tal ech tzaꞌ: —¿Kam tokeꞌ nimotxeyoleꞌ aas tiꞌ yeꞌ netiqꞌo kaxhlaan txꞌix kꞌuxh vetval ech tziꞌ netaleꞌ? ¿Ankoꞌxh yeꞌ nitok teviꞌ? ¿Yeꞌxh nipaal etxumbꞌal tu qꞌu kam tziꞌ tzik? Utz ¿ankoꞌxh yeꞌxhat niokku qꞌul unyol tetaanima tzik? ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Tan kꞌuxh atil bꞌaqꞌ evatz, ¿yeꞌ netilon tzik? Kꞌuxh atil exichin, ¿yeꞌ netabꞌin tzik? Utz ¡yeꞌ nenach qꞌu kam majte! ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Aatz unjatxtu oꞌvaꞌl u kaxhlaan txꞌix xoꞌl u 5,000 aanima, ¿jatvaꞌt txakatx noonaj tu chan emola?— Texhtuꞌ. Motx tal ech tzaꞌ: —Kabꞌlaal.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Tal paj u Jesuus ech tzaꞌ: —Utz aatz unjatxtu jujvaꞌl u kaxhlaan txꞌix xoꞌl 4,000 aanima, ¿jatvaꞌl txakatx noonaj tu chan emola?— Texhtuꞌ. Motx tal ech tzaꞌ: —Jujvaꞌl.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Utz tal u Jesuus te ech tzaꞌ: —¿Kam tokeꞌ ankoꞌxh yeꞌ nipaal etxumbꞌal tuul?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Uncheeꞌ motx tek opon tu Betsaida. Utz iqꞌol opon maꞌl u moy siatz. Ech jajax bꞌaꞌnil te aas sikaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ech ichꞌiji eluꞌl u moy u Jesuus siqꞌabꞌ tziꞌ u tenam. Takꞌsa u bꞌaqꞌ iatz titzubꞌ. Ech taqꞌ jeꞌ iqꞌabꞌ tibꞌa. Utz ichꞌoti te ech tzaꞌ: —¿Ni tetzik iilon bꞌioj?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ech sajin tekuꞌen utz, tala: —¡Nivil qꞌu aanima, loqꞌ echaꞌ tzeꞌ nivileꞌ! Nixaan nivileꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Toksa paj iqꞌabꞌ u Jesuus tu bꞌaqꞌ iatz u moy. Utz yakich tek iꞌan bꞌaꞌn. Paqꞌumalich tek isajin bꞌen tzian. Tiira bꞌaꞌnich tek tiltu qꞌu kam kajayil. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ech ichajtu bꞌen tu tatibꞌal. Tal te ech tzaꞌ: —Oponichꞌaxh tu tenam utz, apaxsach itziiul u kam tziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Uncheeꞌ bꞌen tek u Jesuus tuchꞌ qꞌul ichusulibꞌ tu qꞌu talaj tenam sinajaꞌch u Cesarea Filipo. Utz ichꞌoti tu qꞌul ichusulibꞌ tu bꞌey ech tzaꞌ: —¿Abꞌil in nital qꞌu aanima tziꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Motx tzaqꞌbꞌu ech tzaꞌ: —At nialon aas axh u Xhan, u bꞌanol vautiismo. At nialon aas axh u Elias. Utz at nialon aas axh maꞌj qꞌu alol tetz u yolbꞌal Tioxh nitaleꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ech tal paj u Jesuus te ech tzaꞌ: —Pek aatz ex, ¿abꞌil in netaleꞌ?— Texh te. Tzaqꞌbꞌu u Luꞌ utz, tal ech tzaꞌ: —Axh viTxaaom u Tioxh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ech tal tu qꞌul ichusulibꞌ aas yeꞌxhabꞌil koꞌxh tereꞌn saootzajin u kam tiꞌ tziꞌ aas aꞌ viTxaaom u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Uncheeꞌ xeꞌt tek ichus qꞌul ichusulibꞌ u Jesuus aas ministeer saꞌxhpaasal u Kꞌaola vaꞌl bꞌennaj koꞌn aanima tu kꞌaxkꞌo tu qꞌu qꞌesal qꞌatol tzii. Saixval tu qꞌu qꞌesal oksan yol vatz Tioxh utz, tuchꞌ qꞌu aa txumbꞌal tetz u oꞌtla mantaar. Ech sakami, loqꞌ sakoꞌnqꞌaavitzꞌpu titoxvaꞌ qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Utz aatz u kam tziꞌ, vatzsaj chit nichtal te. Pek aatz u Luꞌ tan, isikꞌle bꞌen u Jesuus echil tziꞌ. Utz xeꞌt imaj iatz tiꞌ vaꞌl tala. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ech isuchqꞌika tibꞌ u Jesuus. Isaji qꞌul ichusulibꞌ utz, iyaa u Luꞌ ech tzaꞌ: —¡Xaaneꞌl sunvatz, txꞌiꞌliꞌinaj! Tan aꞌ koj niitzꞌa qꞌu kam tetz Tioxh. Pek aꞌ niitzꞌa qꞌu kam tetz qꞌu aanima.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ech isikꞌlet qꞌu tenam tuchꞌ qꞌul ichusulibꞌ utz, tal te ech tzaꞌ: —Oj abꞌil sisaꞌa xambꞌichil viꞌ, imaj tibꞌ tiꞌ toksal tetz vitxumbꞌal. Pek iqꞌiꞌ paalchil tu mam il tzaꞌl viꞌ utz, xamoj viꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tan abꞌil qꞌuꞌl taꞌxh nititzꞌa u vatz iqꞌii saj tu u vatz txꞌavaꞌ tzaꞌ, sitzꞌej u bꞌenchil tu u bꞌenqꞌii bꞌensaj. Pek abꞌil qꞌuꞌl kꞌuxh litzꞌej u vatz iqꞌii saj viꞌ utz, tiꞌ u bꞌaꞌnla chusbꞌal, aꞌ vaꞌl sichabꞌa u bꞌenchil tu bꞌenqꞌii bꞌensaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tan ¿kam bꞌoj siꞌan kanaal u aanima kꞌuxh satetza u vatz amlika txꞌavaꞌ kajayil tzaꞌ, untzꞌoj aꞌ seꞌenku u taanxelal tu choobꞌal paav? ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tan kam koj choobꞌal sataqꞌ u aanima tiꞌ itool u taanxelal. ");
INSERT INTO ixlCNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Utz abꞌil vaꞌl sachꞌixveꞌl viꞌ utz, sachꞌixveꞌl tiꞌ vunyolbꞌal vatz qꞌu qelolla chaj aa paav tu u tiempo tzaꞌ, sakoꞌnchꞌixveꞌl u Kꞌaola tiꞌ majte vaꞌl bꞌennaj koꞌn aanima majte aas luꞌul tu u mam itechalil viTat. Aꞌ imol qꞌul iaanjel xaannaj el kꞌatz paav.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Tal paj ech tzaꞌ: —niꞌxhtekꞌval sete, atil kaꞌvoꞌj oxvoꞌjex cheel atziꞌ, atilex tzaꞌ aas yeꞌsaj ekameꞌ setil tul viQꞌesalail u Tioxh tu u mam tijleꞌm.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Uncheeꞌ maꞌtich tel vaajil qꞌii tuul, aatz u Jesuus tiqꞌo bꞌen u Luꞌ, u Jacobo, tuchꞌ u Xhan viꞌ maꞌl u tꞌankin muunte. Ech ijalpixsa tilon u Jesuus siatz. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Aatz qꞌu toksaꞌm, bꞌens ribꞌkin; tiira poloxh saj tekuꞌen, echaꞌ saj sutzꞌ. Yeꞌxhabꞌil koꞌxh maꞌj txꞌaaol tu u vatz amlika txꞌavaꞌ tzaꞌ, saꞌkojoleꞌ tiꞌ ipoloxhtixsal maꞌj oksaꞌm aas echi. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ech aꞌ tek til ichee u Elias tuchꞌ u Moisees. Utz nichtekiyolon tuchꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ech aatz tek u Luꞌ, tal tu u Jesuus ech tzaꞌ: —¡Chusul, qeꞌl atiloꞌ tzaꞌ, vetqil u kam tziꞌ! Pek sakubꞌan oxvaꞌl muuabꞌal nachpixsabꞌal. Maꞌl eetz, vaꞌt tetz u Moisees utz, vaꞌt tetz u Elias.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Yeꞌt texh inacha kam vaꞌl nichtaleꞌ tan, tiira jonal xoꞌvinajich. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Uncheeꞌ aatz tek iꞌana, kuꞌl maꞌl u sutzꞌ tu amlika. Utz yakich motx okojka timuu. Ech tabꞌi maꞌl u yol tu u sutzꞌ. Ech tal tzaꞌ: —Aꞌ vunKꞌaol, tiiꞌin tiꞌ atziꞌ. Aꞌ vaꞌl setabꞌi tetz.— Texh u yol. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ech motx tek sajin tiꞌaj chaj. Utz yeꞌxhabꞌil tereꞌn tila. Aꞌ texh atichka u Jesuus junal. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Aatz tuul tek nichmotxikuꞌl viꞌ u muunte, tal u Jesuus te bꞌaꞌnil aas yeꞌxhabꞌil koꞌxh e satalvu qꞌu kam tila tziꞌ. Pek analen samotxtaleꞌ aas maꞌt qꞌaavtitzꞌpu u Kꞌaola vaꞌl bꞌennaj koꞌn aanima, xoꞌl qꞌu kamnaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ech nojchit atin koꞌn qꞌu yol sikꞌuꞌl tziꞌ. Loqꞌ vaꞌlich motx iyoltu sivatzaj aas kan chaj tok u qꞌaavtitzꞌpu xoꞌl qꞌu kamnaj nichtaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Uncheeꞌ ech motx ichꞌoti tu u Jesuus ech tzaꞌ: —¿Kam tok vaꞌl nital qꞌu aa txumbꞌal tetz u oꞌtla mantaar? aas: «Aꞌ bꞌaxal suꞌul u Elias.» Chia.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Nojchituꞌ. Aꞌ suꞌul u Elias bꞌaxal. Utz aꞌ saqꞌaaviꞌanvu bꞌaꞌn qꞌu kam tikuenta. Pek ¿kam chaj tok nital u Yolbꞌal Tioxh majte? aas: «Saꞌxhpaal tu tzaꞌl u Kꞌaola vaꞌl bꞌennaj koꞌn aanima utz, yeꞌk itxaꞌk tu qꞌu aanima siꞌaneꞌ.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pek ootzajitaj tan, ulnaj tek u Elias. Utz aatz qꞌu aanima, motx koꞌn iꞌan te kam tal qꞌu taanima tiꞌ. Ech iꞌan te kam vaꞌl tzꞌibꞌamalka tiꞌ tu u Yolbꞌal Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Aatz tek qꞌaavopon tu vaꞌl atichkuka tereꞌn qꞌu chusulibꞌ, til u mam tenam molich ok tibꞌ tiꞌ. Antich unjolol aa txumbꞌal tetz u oꞌtla mantaar. Vaꞌlich motx itxaytu tibꞌ tu yol tuchꞌ qꞌu chusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pek ilax u Jesuus tu qꞌu tenam utz, motx chit tzꞌejx ikꞌuꞌl tiꞌ. Ech oora tek motx tꞌaspu topon siatz, ex tal ichajlichil. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Utz ichꞌoti tu qꞌu chusulibꞌ ech tzaꞌ: —¿Kam tiꞌ netxayvu etibꞌ tu yol?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ech tzaqꞌbꞌu maꞌl u vinaj xoꞌl qꞌu mam tenam, tala: —Chusul, vetviqꞌo ul vunkꞌaol saatz tzaꞌ tan, oknaj maꞌl tioxhil txꞌiꞌliꞌinaj kꞌatza. Memtinaj taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Utz chajpaj nikꞌuch tibꞌ u tioxhil txꞌiꞌliꞌinaj kꞌatza, niꞌxhtulebꞌe. Nibꞌaj kuꞌ vatz txꞌavaꞌ. Vaꞌl tel vutx itziꞌ. Utz kaana ijarachꞌun tee taqꞌo. Ech tiira nitzeꞌ tibꞌ taqꞌo. Vetvallu tu qꞌul achusulibꞌ tziꞌ aas satojcha el u tioxhil txꞌiꞌliꞌinaj kꞌatza, pek yeꞌn oleꞌ tiꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ech tzaqꞌbꞌu u Jesuus utz, tal te ech tzaꞌ: —Tiira yeꞌxh bꞌoj kꞌujlel ekꞌuꞌl tiꞌ u Tioxh, ex itzꞌlelex tu tiempo tzaꞌ. ¿Ech koꞌn chixh vatin texoꞌl tzaꞌ? ¿Ech koꞌn chixh unqꞌiꞌtꞌex tziꞌ? ¡Iqꞌotaj ul tzaꞌ!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ech iqꞌol opon siatz. Pek aatz ilax u Jesuus tu u tioxhil txꞌiꞌliꞌinaj, ikꞌuch tibꞌ kꞌatza. Xeꞌt itꞌuntꞌuꞌlansa u xiak. Ibꞌaj kuꞌ vatz txꞌavaꞌ. Vaꞌlich tek isiltꞌut tibꞌ taqꞌo utz, vaꞌl tel vutx itziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Aatz u Jesuus tan, ichꞌoti tu vitat u xiak ech tzaꞌ: —¿Jatvaꞌx tiempo xeꞌt iꞌantu ech tziꞌ?— Texh te. Tzaqꞌbꞌi utz, tala: —Ayaꞌxchen tichꞌooil. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Jatpax koꞌxh taqꞌ bꞌen tu xamal tuchꞌ tu aꞌ. Yatzꞌel chit siꞌan nitxumeꞌ. Pek ¿yetz saveeti kam maꞌj saꞌan te? Utz ¡lochꞌoꞌ! ¡Txum kuvatz!— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ech aatz u Jesuus, tal te ech tzaꞌ: —¿Kantuꞌ? aas: «Yetz saveeti.» Chaꞌaxh. Tan abꞌil vaꞌl kꞌujlel ikꞌuꞌl, kajay kam saveet siatz.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Uncheeꞌ aatz tek vitat u xiak tziꞌ, jeꞌ iviꞌ tiꞌ talax ech tzaꞌ: —Eeꞌ. Nunnima siꞌan bꞌaꞌn. Pek ¡lochꞌin ech yeꞌk sakaꞌtziiunin!— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ech til u Jesuus aas vaꞌlich tek imoltu tibꞌ qꞌu tenam kꞌatza, tojcha tek el u tioxhil txꞌiꞌliꞌinaj. Tal te ech tzaꞌ: —¡Tioxhil txꞌiꞌliꞌinaj memtixsanal chakantixsanal, taꞌxh nival see, elen! Utz ¡yeꞌ koꞌxh okveꞌtꞌaxh kꞌatz u xiak tziꞌ!— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Aatz u tioxhil txꞌiꞌliꞌinaj tan, qꞌeqꞌuni. Techal itꞌuntꞌuꞌlansal u xiak iꞌana. Ech eli. Ech tekuꞌen aꞌ kamnaj kaak u xiak. Utz tal tek qꞌu aanima ech tzaꞌ: —¡Kamya atziꞌ!— Texh tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pek aatz u Jesuus tan, itxay u xiak siqꞌabꞌ. Ilak jeꞌ. Ech txakeꞌi. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Uncheeꞌ bꞌen tek u Jesuus tu atibꞌal. Utz tabꞌi tek qꞌul ichusulibꞌ te ech tzaꞌ sijunal: —¿Kantuꞌ aas yeꞌn oleꞌoꞌ tiꞌ tojchal el u tioxhil txꞌiꞌliꞌinaj?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Alax te tu u Jesuus ech tzaꞌ: —Yeꞌn chituꞌ tan, aatz unjolol qꞌu tioxhil txꞌiꞌliꞌinaj tziꞌ, sakoꞌnkoxheli. Pek saeli, loqꞌ tuchꞌ chit iqꞌilal isikꞌlel Tioxh tuchꞌ ikuyax vaꞌy.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Uncheeꞌ aatz tek motx elbꞌen tu vaꞌl atichka, motx koꞌn paal yakloj tikuenta Galilea. Utz yeꞌich isaꞌ u Jesuus aas saootzajili. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Nichichus qꞌul ichusulibꞌ. Nichtal te ech tzaꞌ: —Aatz u Kꞌaola vaꞌl bꞌennaj koꞌn aanima, soꞌoksal tiqꞌabꞌ qꞌu onkonla chaj aanima utz, siyatzꞌeꞌ. Pek kꞌuxh maꞌt ikameꞌ, saqꞌaavitzꞌpu titoxvaꞌ qꞌii.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pek aatz qꞌu chusulibꞌ tan, yeꞌ nichmotxipaal itxumbꞌal tu u yol tziꞌ. Utz yeꞌt ichꞌoti te tan, nichmotxixoꞌva. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Uncheeꞌ motx tek opon tu atibꞌal tu Capernauum utz, ichꞌoti u Jesuus te ech tzaꞌ: —¿Kam tiꞌ vetmotxetxay etibꞌ tu yol tu bꞌey bꞌatzꞌi?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pek motx koꞌn jutzeꞌi. Yeꞌxhabꞌil maꞌj tzaqꞌbꞌi. Tan maꞌtich motx itxaytu tibꞌ tu yol tu bꞌey, tiꞌ aas abꞌil u qꞌesala tixoꞌl nichmotxtaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ech kꞌujeꞌ u Jesuus utz, isikꞌle ul kabꞌlaal qꞌul ichusulibꞌ sikꞌatza. Utz tal te ech tzaꞌ: —Abꞌil qꞌesalail isaꞌ, taqꞌ bꞌens tibꞌ chꞌooala. Aꞌ vaꞌl maas salochon texoꞌl siꞌaneꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ech tiqꞌo opon maꞌl tal nitxaꞌ kꞌatza, toksa tixoꞌl. Ijele utz, tal ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Abꞌil sakꞌulun maꞌl tal nitxaꞌ tunbꞌii, echaꞌ vaꞌl tzaꞌ, in aꞌ nikꞌulin tziꞌ. Utz abꞌil vaꞌl nikꞌulunin, yitꞌ in koj nikꞌulin, pek aꞌ nikꞌul vaꞌl vetchajonkꞌasuꞌlin.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Uncheeꞌ aatz u Xhan, tal tu u Jesuus ech tzaꞌ: —Chusul, vetqil maꞌl u vinaj nitojcheꞌl tioxhil txꞌiꞌliꞌinaj tu vabꞌii. Utz tiira vetkumaj ivatz aas yeꞌk siꞌan ech tziꞌ. Tan oj tzik antu xamel qiꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Alax tek te tu u Jesuus ech tzaꞌ: —Yeꞌ koꞌxh emaj iatz tiꞌ. Tan abꞌil koj siꞌan txaichil tu vunbꞌii oj siyoqꞌin. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tan abꞌil qꞌuꞌl yeꞌ nichiꞌkꞌulanoꞌ, kumol atziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Utz niꞌxhtekꞌval sete, saꞌkojyaꞌtziꞌ ikꞌult ijaꞌmel abꞌil silochꞌex, kꞌuxh maꞌj koꞌxh vaaso etaaꞌ sataqꞌeꞌ tan, nenima viTxaaom u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Pek abꞌil vaꞌl saꞌaqꞌon bꞌen maꞌj qꞌu chꞌooal niman vetz tu paav, aal tek bꞌaꞌn saqitzax ok maꞌl mam sivan cheꞌbꞌal siqul; ech seꞌnkꞌonaxoj bꞌen tu u mar. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ech yaaqꞌ tzii sataqꞌbꞌenaxh vaqꞌabꞌ tu paav. Aal tek bꞌaꞌn seesa. Tan kꞌuxh axh kutqꞌabꞌ, taꞌxhtzii soꞌokoꞌpꞌaxh tu bꞌenqꞌii bꞌensaj. Pek kꞌuxh tzꞌajel axh oj taꞌn seꞌenkꞌaxh tu choobꞌal paav, vaꞌl yeꞌk itzaa u xamal atil tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Utz yeꞌk ikam qꞌu noꞌy atil tuul utz, jatu koj satzaa u xamal atil tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Utz yaaqꞌ tzii sataqꞌbꞌenaxh val aajan tiꞌ ibꞌanax u paav. Aal tek bꞌaꞌn seesa. Tan kꞌuxh axh koꞌx, taꞌxhtzii soꞌokoꞌpꞌaxh tu bꞌenqꞌii bꞌensaj. Tan kꞌuxh tzꞌajel axh oj aꞌ yakkꞌaxh tu choobꞌal paav vaꞌl yeꞌk itzaa u xamal atil tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Utz yeꞌk ikam qꞌu noꞌy atil tuul utz, jatu koj satzaa u xamal atil tuul majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Yaaqꞌ tzii sataqꞌbꞌenaxh u bꞌaqꞌ avatz tu paav. Aal tek bꞌaꞌn seesa. Tan kꞌuxh maꞌl koꞌn bꞌaqꞌ avatz, taꞌxhtzii soꞌokoꞌpꞌaxh tu u bꞌanbꞌal iQꞌesalail u Tioxh. Pek kꞌuxh tzꞌajel kaꞌvaꞌl bꞌaqꞌ avatz oj aꞌ yakkꞌaxh tu choobꞌal paav, ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","vaꞌl yeꞌk itzaa u xamal atil tuul utz, yeꞌk ikam qꞌu noꞌy atil tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tan kajay maꞌl ipaal tu xamal. Utz kajay txakunsaꞌm soꞌok tu atzꞌam. ");
INSERT INTO ixlCNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Bꞌaꞌn u atzꞌam aas chiꞌ. Pek oj sasotz vichiꞌlil, ¿kam tek sachiꞌbꞌixsan? Echixeꞌat bꞌantajex echaꞌ u atzꞌam. Utz atoj ok u bꞌaꞌnil texoꞌl.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Uncheeꞌ kꞌastekꞌul u Jesuus tu Capernauum, ikꞌaj bꞌen tikuenta Judea vatz bꞌen u Jordaan. Ech imol paj tibꞌ qꞌu tenam kꞌatza. Utz xeꞌt paj ichuseꞌ tan, ech chit nichiꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ech xaan opon qꞌu fariseo kꞌatza. Utz vet sikꞌuꞌl motx ichꞌoti te: —¿Bꞌaꞌn tzik satojcha tixoj maꞌj vinaj?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ech tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —¿Kam mantaar taqꞌka u Moisees?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Motx tal ech tzaꞌ: —Aatz u Moisees tan, taqꞌ tzii aas saojchal u ixoj. Sakoꞌnaqꞌax maꞌl tuꞌ tetz jatxbꞌalibꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ech tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Kꞌuxh itzꞌibꞌaka u mantaar u Moisees ech tziꞌ, tiꞌ atziꞌ tan, taꞌxh okoj tetz qꞌul ekꞌuy emam. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pek yitꞌeꞌch koj bꞌanel tu u Tioxh xeꞌ qꞌii xeꞌ saj tiꞌ tatin u vinaj tuchꞌ u tixoj. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ech tokeꞌ sataqꞌka itxutx ibꞌaal u vinaj utz, saꞌtekatin tuchꞌ u tixoj. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Utz maꞌl tekoꞌn saelkoꞌp vatz Tioxh. Ech yitꞌ kaꞌvaꞌl tereꞌn koj. Pek maꞌl tekoꞌn saelka sikaꞌbꞌil. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ech tokeꞌ abꞌil vaꞌl titxumbꞌal Tioxh nikꞌul tibꞌ, yeꞌxhabꞌil koꞌxh maꞌj aanima sajatxon.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Uncheeꞌ aatz tek atich tu atibꞌal, echat koꞌxh paj chꞌotil te tu qꞌu chusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ech tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Abꞌil u vinaj vaꞌl nikoꞌxhtaqꞌan tojchat tixoj utz, nikꞌul tibꞌ tuchꞌ vaꞌte, eesaibꞌ tu bꞌey niꞌan tuchꞌ u ixoj vaꞌl yitꞌ ikꞌulel koj tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Utz oj u ixoj, sataqꞌka vivinaj utz, nikꞌul tibꞌ tuchꞌ vaꞌte, eesaibꞌ paj tu bꞌey niꞌan tuchꞌ u vinaj yitꞌ ikꞌulel koj tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Uncheeꞌ nichenoksaloj talaj nitxaꞌ vatz u Jesuus. Aꞌ isaꞌ qꞌul itxutx ibꞌaal aas sataqꞌ jeꞌ iqꞌabꞌ tibꞌa. Pek nichkoꞌniyaal tu qꞌu chusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ech taꞌxh til u kam u Jesuus tziꞌ, yitꞌ bꞌaꞌn koj bꞌenku te. Utz tal ech tzaꞌ: —Aqꞌtaj tzii suꞌul qꞌu talaj nitxaꞌ sunkꞌatza tziꞌ. Yeꞌ koꞌxh emaj iatz. Tan aatz viQꞌesalail u Tioxh, tetz qꞌu aanima ech itxumbꞌal qꞌu talaj nitxaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tan niꞌxhtekꞌval sete, oj yitꞌ ech koj ikꞌulax viQꞌesalail u Tioxh sebꞌaneꞌ echaꞌ niꞌan maꞌl tal nitxaꞌ, saꞌkojokoꞌpꞌex tuul.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ech ijele qꞌu talaj nitxaꞌ. Utz taqꞌ jeꞌ iqꞌabꞌ tibꞌa. Tal bꞌaꞌnla yol tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Uncheeꞌ tuul okkꞌasuꞌl u Jesuus tiꞌ ibꞌey, jutzin topon maꞌl u vinaj kꞌatza utz, pecheꞌ kuꞌ siatz. Ech ichꞌoti te ech tzaꞌ: —Bꞌaꞌnla chusul ¿kam sunbꞌaneꞌ ech soꞌokoꞌpꞌin tu u bꞌenqꞌii bꞌensaj?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Tal u Jesuus te ech tzaꞌ: —¿Kam tokeꞌ aas bꞌaꞌn chaꞌaxh viꞌ? Tan yeꞌxhabꞌil koꞌxh maꞌj bꞌaꞌn. Taꞌxh maꞌl bꞌaꞌn u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Utz ootzaj nal qꞌu mantaar nital ech tzaꞌ: «Yeꞌ yatzꞌonaxh. Eesach iibꞌ tu bꞌey tuchꞌ aanima yitꞌ akꞌulel koj. Elqꞌiꞌchꞌaxh. Aꞌanchil txubꞌaꞌlla texhtiigoil tiꞌ amol. Subꞌunichꞌaxh. Atoj tatin atxutx abꞌaal saatz.» Chia.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Tal tek u xiak ech tzaꞌ: —Chusul, ninalunnima tunxiakil kajay qꞌu kam naaleꞌ tziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Uncheeꞌ aatz tek u Jesuus, isaji utz, itxum iatz. Tal te ech tzaꞌ: —Atil vaꞌt kam yeꞌ naꞌaneꞌ. Pek kuxh kꞌayi kajay qꞌul eetz. Utz aqꞌ vijaꞌmel tu qꞌu meꞌbꞌaꞌ. Ech saꞌatin txꞌiibꞌal aqꞌii tu Amlika. Qꞌiꞌ qꞌu paalchil tu tzaꞌl viꞌ. Utz niꞌaxh, xambꞌen viꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ech aatz u vinaj tziꞌ, qꞌeon ikꞌuꞌl tu u yol alax te. Utz txumun iqꞌaaveꞌ tan, mam txꞌiibꞌal qꞌii atich tzixeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Aatz u Jesuus tan, isaji qꞌul ichusulibꞌ utz, tal te ech tzaꞌ: —Tiira tzaꞌl soꞌok qꞌu txꞌiiol iqꞌii tu viQꞌesalail u Tioxh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ech sotz ikꞌuꞌl qꞌu chusulibꞌ tu qꞌul iyol tziꞌ. Ech tal paj u Jesuus ech tzaꞌ: —Unkꞌaol, tiira tzaꞌl soꞌokoꞌp tu viQꞌesalail u Tioxh qꞌuꞌl kꞌujlel ikꞌuꞌl tiꞌ txꞌiibꞌal qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Aal yitꞌ tzaꞌl koj tokoꞌp u camello tixeꞌ u tzꞌisbꞌal bꞌaj vatz u tokoꞌp maꞌl txꞌiiol iqꞌii tu viQꞌesalail u Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ech aatz qꞌu chusulibꞌ tan, tiira aal paj motx sotz ikꞌuꞌl taqꞌo. Nichtexhmotxtal sivatzaj ech tzaꞌ: —¿Abꞌil tek sachitpu tu paav uncheeꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ech aatz u Jesuus tan, isaji utz, tal te ech tzaꞌ: —Yeꞌ chit saveet vatz qꞌu aanima, pek saveet vatz u Tioxh. Tan kajay niveet tu u Tioxh.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Uncheeꞌ tal u Luꞌ te ech tzaꞌ: —Aatz oꞌ, vetqaqꞌluka kajay qꞌu qetz utz, xameloꞌ saiꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Tzaqꞌbꞌu u Jesuus utz, tal ech tzaꞌ: —Niꞌxhtekꞌval sete, abꞌil qꞌuꞌl sataqꞌka tetz viꞌ, tuchꞌ tiꞌ u bꞌaꞌnla chusbꞌal, mam bꞌaꞌnil sikꞌuleꞌ. Utz 100 tanul sikꞌul vatz vaꞌl sataqꞌka tu u vatz iqꞌii isaj. Utz saetzan tiꞌ u bꞌenqꞌii bꞌensaj. Echaꞌ qꞌuꞌl sataqꞌka tatibꞌal. Sataqꞌka tatzik, itzaꞌqꞌ, tanabꞌ, itat, inan, tixoj, ikꞌaol imeꞌal, itxꞌavaꞌ utz, saojchal viꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pek sibꞌal koꞌxh qꞌuꞌl kꞌuxh sibꞌ tatin vatz Tioxh ninach cheel, aal bꞌiil koꞌn tatin toj iꞌaneꞌ. Pek sibꞌal qꞌuꞌl kꞌuxh aal bꞌiil koꞌn tatin vatz Tioxh ninach cheel, sibꞌ tatin toj iꞌaneꞌ.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Uncheeꞌ aatz atich ok tiꞌ u bꞌey maꞌtjeꞌ tu Jerusaleen, bꞌaxaich u Jesuus siatz. Utz sotznajich ikꞌuꞌl qꞌu chusulibꞌ tiꞌ qꞌu yol. Utz vaꞌlich motx ixoꞌveꞌ. Ech aatz u Jesuus tan, ixaanseꞌl qꞌul ichusulibꞌ echil tziꞌ. Utz xeꞌt tal te kam qꞌuꞌl sapaalka. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Tal te ech tzaꞌ: —Aatz cheel, maꞌttekꞌoꞌ tu Jerusaleen. Utz soꞌoksal u Kꞌaola vaꞌl bꞌennaj koꞌn aanima tiqꞌabꞌ qꞌu qꞌesal oksan yol vatz Tioxh utz, tuchꞌ tiqꞌabꞌ qꞌu aa txumbꞌal tetz u oꞌtla mantaar. Ech tek satoksa tiqꞌabꞌ qꞌu puera aanima. Utz samotxtal iyatzꞌleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Utz saeesal iqꞌii. Satzubꞌali. Satzꞌuꞌmali. Utz sayatzꞌpi. Pek loqꞌ titoxvaꞌ qꞌii, saqꞌaavitzꞌpi.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Uncheeꞌ aatz u Jacobo tuchꞌ u Xhan, qꞌul ikꞌaol u Zebedeo, motx xaan opon kꞌatz u Jesuus. Utz tal te ech tzaꞌ: —Chusul, aꞌ kusaꞌ aas saaqꞌ qe kam vaꞌl sakujaj see.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Alax te ech tzaꞌ: —¿Kam esaꞌ sunbꞌaneꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Motx tzaqꞌbꞌu ech tzaꞌ: —Aatz loꞌokꞌaxh tu u mam iijleꞌm, aqꞌ tzii aas maꞌl qe sakꞌujeꞌ tasebꞌal utz, vaꞌt tamax.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tzaqꞌbꞌu u Jesuus ech tzaꞌ: —Yeꞌ etootzaj kam nejajeꞌ. ¿Satz etxꞌakeꞌ sapaalex tu u mam il tzaꞌl vaꞌl sapaalkꞌin? Utz ¿satz etxꞌakeꞌ aas ech ekameꞌ vunkameꞌ?— Texh u Jesuus te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Motx tal ech tzaꞌ: —Eeꞌ, saꞌi.— Texhtuꞌ. Alax te ech tzaꞌ: —Uncheeꞌ nojchit setxꞌakeꞌ aas aꞌ sapaalkꞌex tu u mam il tzaꞌl vaꞌl sapaalkꞌin. Utz setxꞌakeꞌ aas ech ekam sakamex vunkameꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pek ech koj vekꞌujeꞌ tunsebꞌal netaleꞌ tziꞌ tuchꞌ tunmax tan, yitꞌ in koj aa yol tiꞌ taqꞌaxeꞌ. Pek aꞌ saetzan qꞌuꞌl kꞌajel nal tiꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Uncheeꞌ taꞌxh tabꞌi u kam lavat qꞌu chusulibꞌ tziꞌ, motx xeꞌt ilakp iviꞌ tiꞌ u Jacobo tuchꞌ tiꞌ u Xhan. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ech aatz u Jesuus tan, isikꞌle ul siatz utz, tal te ech tzaꞌ: —Etootzajle, aatz qꞌu ijlenal tetz qꞌu puera aanima, niꞌxhibꞌensa tibꞌ qꞌesala viꞌ qꞌuꞌl jaqꞌ imantaar. Utz aatz qꞌuꞌl atil tijleꞌm, vatz ikꞌuꞌl ikꞌuchax u tijleꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pek aatz texoꞌl, yitꞌ ech koj siꞌaneꞌ. Tan abꞌiste vaꞌl qꞌesalail isaꞌ, aal aꞌ vaꞌl saelaꞌ ok texoꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Utz aatz vaꞌl aꞌ isaꞌ paalchu tijleꞌm sevatz, aal aꞌ vaꞌl maas salochon texoꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tan echaꞌ niꞌan u Kꞌaola vaꞌl bꞌennaj koꞌn aanima, kꞌuxh vetꞌuli, aal koj vetilbꞌeli. Pek aal vetꞌelaꞌok tiꞌ qꞌu aanima. Utz ul kamoj tiꞌ taqꞌax itiichajil mam tenam.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Uncheeꞌ motx tek opon tu Jericoo. Utz aatz kꞌasuꞌl tziꞌ, molomich tibꞌ tuchꞌ qꞌul ichusulibꞌ utz, mam tenam xamich tiꞌ. Tuul kꞌujlich kuꞌ maꞌl u moy tu bꞌey. Nichijoyoneꞌ. Bar Timeo ibꞌii. Ikꞌaol maꞌl u vinaj Timeo ibꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ech taꞌxh tabꞌi u moy aas u Jesuus aa Nazareet vaꞌl nichtoponeꞌ, oora chit xeꞌt iqetun taltu ech tzaꞌ: —¡Jesuus, ituꞌxh ixalam Daviid, txum unvatz!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Utz sibꞌal aanima nichmajon iqꞌeqꞌuneꞌ. Pek aal koꞌn maas nichiqꞌeqꞌuneꞌ: —¡Ituꞌxh ixalam Daviid, txum unvatz!— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Aatz u Jesuus tan, txakeꞌ tekuꞌen. Utz tala: —Sikꞌletaj ul.— Texhtuꞌ. Ech isikꞌlel opon u moy. Utz alax te ech tzaꞌ: —Kꞌujeꞌoj akꞌuꞌl tiꞌ. Lakpen tan, nisikꞌleꞌaxh.— Texh teꞌleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ech aatz u moy, oora tek ikꞌonka vikaapa. Yuqꞌpu jeꞌ utz, txakeꞌi. Ech tek opon kꞌatz u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Aatz u Jesuus, ichꞌoti te ech tzaꞌ: —¿Kam asaꞌ sunbꞌan see?— Texh te. Tzaqꞌbꞌu u moy ech tzaꞌ: —¡Chusul, aꞌ unsaꞌ sailon qꞌu bꞌaqꞌ unvatz tzaꞌ!— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Tal paj u Jesuus te ech tzaꞌ: —Aꞌtzii. Kuxh. Tan tu koꞌn ikꞌujeꞌ akꞌuꞌl viꞌ, bꞌaꞌntꞌaxh.— Texh te. Ech tu koꞌxh unmuꞌkꞌul iꞌan bꞌaꞌn qꞌu bꞌaqꞌ iatz u moy. Utz xambꞌu tek bꞌen tiꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Uncheeꞌ motx najabꞌ opon tu Jerusaleen tuchꞌ xeꞌ u muunte vaꞌl Olivo. Utz aatz siꞌchtexhopon tu Betaania tuchꞌ tu Betfagee, ichaj bꞌen kaꞌvaꞌl qꞌul ichusulibꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Utz tal te ech tzaꞌ: —Bꞌenojex tu u tal tenam sukuvatz bꞌen tziꞌ. Utz aatz loꞌoponex, setil maꞌl u chelem bꞌuuro qitzel. Yeꞌsaj tok tijbꞌal. Chittaj, ech iqꞌotaj ul tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Untzꞌoj abꞌil laꞌalon sete: «¿Kam tokeꞌ aas nechiteꞌ?» Chaj. «U kuBꞌaal satxakunsan utz, oora koꞌxh suꞌliqꞌaavixsaka.» Chajex te.— Texh u Jesuus te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ech motx bꞌen qꞌul ichusulibꞌ utz, til u bꞌuuro qitzich tziꞌ bꞌey tu maꞌl u tziꞌ peꞌ tetz maꞌl u otzotz. Ech motx ichita. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Anchituꞌ. Atich unjolol qꞌu aanima tziꞌ, motx tal te ech tzaꞌ: —¿Kam nebꞌaneꞌ atziꞌ, ech nechit u bꞌuuro tziꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ech motx tzaqꞌbꞌi. Aꞌ motx tal qꞌu yol alax bꞌen te tu u Jesuus. Ech aqꞌax tzii te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Uncheeꞌ ech motx tiqꞌot ul u bꞌuuro tu vaꞌl atichkuka u Jesuus. Motx taqꞌ jeꞌ qꞌul ikaapa tiꞌ. Ech jeꞌ u Jesuus tiꞌ u bꞌuuro. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ech sibꞌal aanima motx iliiu kuꞌ qꞌul ikaapa tu bꞌey. Utz atia ichok xaj qꞌabꞌaj tzeꞌ majte. Taqꞌ kuꞌ tibꞌey u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Utz motx qꞌeqꞌun qꞌu tenam, qꞌuꞌl bꞌaxaich siatz, tuchꞌ qꞌuꞌl xamich tiꞌ iqul. Utz motx tal ech tzaꞌ: —¡Bꞌan bꞌaꞌnil eesaꞌoꞌ tu tzaꞌl tzaꞌ! ¡Techal axh! Tan tibꞌii u kuBꞌaals Amlika vetꞌulkꞌaxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Techal viQꞌesalail vituꞌxh ixalam u kukꞌuy kumam Daviid vaꞌl tuleꞌ tziꞌ! ¡Techal u Tioxh tu Amlika, u kolol qetz!— Texh qꞌu tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ech aatz tek opon u Jesuus tu Jerusaleen, bꞌenoꞌk tu viqꞌanalil u totztioxh. Utz isaji kajay qꞌu kam atich tziꞌ. Ech kꞌasuꞌl tuchꞌ kabꞌlaal qꞌul ichusulibꞌ tan, maꞌtich tek ikuꞌ qꞌii. Motx tek qꞌaavbꞌen tu Betaania. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Uncheeꞌ ech tek qꞌejal tuul, motx kꞌasuꞌl tu Betaania. Utz kam u Jesuus tu vaꞌy. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Utz til bꞌen maꞌl u tzeꞌil viikuxh tzian aas jinlich ixaj. Ech bꞌeni, ex tileꞌ. Kamal siꞌchichabꞌa maꞌj ivatz tala. Pek aatz opon kꞌatz u viikuxh, yeꞌt ichabꞌa maꞌj ivatz. Taꞌxh atich ixaj tan, yitꞌ itiempoich koj viikuxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ech tal tek u Jesuus tu u viikuxh ech tzaꞌ: —Vetaꞌanlaꞌ, yeꞌxhabꞌil koꞌxh vaꞌtoj saloꞌn avatz.— Texhtuꞌ. Utz aatz qꞌu chusulibꞌ, motx tabꞌi kam vaꞌl tala. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Uncheeꞌ ech motx opon tu Jerusaleen. Utz bꞌenoꞌk u Jesuus tu viqꞌanalil u totztioxh. Ech xeꞌt tojchat eluꞌl kajay qꞌul nichikꞌayineꞌ, tuchꞌ qꞌuꞌl nichiloqꞌon tziꞌ. Ixhutꞌpi qꞌul imeexha qꞌu chꞌexun puaj utz, tuchꞌ vikꞌujlebꞌal qꞌu aa kꞌaꞌy paroomaxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Utz nichtereꞌnkojtaqꞌ tzii sapaal aanima tuchꞌ tiqꞌoꞌm tu vikuentail u totztioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ech ichus tu qꞌu aanima ech tzaꞌ: —Tzꞌibꞌamalka tu u Yolbꞌal Tioxh aas: «Qꞌilabꞌ sikꞌlebꞌ vetz u votzotz tetz kajay aanima siꞌaneꞌ.» Chia. Pek aatz ex, vetetaqꞌlu bꞌens tatibꞌal elqꞌom.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ech taꞌxh tabꞌi u yol qꞌu qꞌesal oksan yol vatz Tioxh, tuchꞌ qꞌu aa txumbꞌal tetz u oꞌtla mantaar, xeꞌt motx titzꞌa kaniꞌch iyatzꞌax u Jesuus siꞌaneꞌ. Tan nichmotxixoꞌv taqꞌo tan, mam tenam nichitzꞌejx ikꞌuꞌl tiꞌ vichusbꞌal u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pek aatz tek sotzsaj, elkꞌasuꞌl u Jesuus tu u tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Uncheeꞌ aatz tek iꞌan qꞌalaꞌm tu tek vaꞌt qꞌii, motx paal kꞌatz u viikuxh vaꞌl tzꞌejax yol tiꞌ tu u Jesuus. Utz motx tila aas maꞌtich tek itzaj tuchꞌ taqꞌil. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ech ul u yol sikꞌuꞌl u Luꞌ, tal tu u Jesuus ech tzaꞌ: —Chusul, saji iileꞌ. Tzajyu u viikuxh vaꞌl atzꞌej yol tiꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ech tzaqꞌbꞌel tu u Jesuus, ech tzaꞌ: —Kꞌujloj ekꞌuꞌl tiꞌ Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tan niꞌxhtekꞌval sete, abꞌil saꞌalon tu u muunte tziꞌ: «Elenbꞌen tziꞌ, kꞌon bꞌen iibꞌ tu mar.» Chaj te, satzojpu vaꞌl sataleꞌ. Taꞌxhtzii oj yeꞌk sakaꞌtziiun tu taanima, pek nojchit sinima aas sabꞌanlu vaꞌl nitaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ech tok nival sete, kajay vaꞌl sejaj tu veqꞌilat esikꞌlet Tioxh, nimataj aas sekꞌuleꞌ utz, ministeer ekꞌultaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Utz aatz neqꞌila esikꞌle Tioxh, kuytaj u aanima oj atoꞌk exoꞌl tuchꞌ, ech sikuyex u kuTat tu Amlika tiꞌ qꞌul epaav majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Tan oj yeꞌk sakuyunex, nikoꞌxh u kuTat tu Amlika saꞌkojikuyex majte.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Uncheeꞌ ech motx qꞌaavopon tu Jerusaleen. Utz tuul nichipaal u Jesuus tu viqꞌanalil u totztioxh, opon qꞌu qꞌesal oksan yol vatz Tioxh kꞌatza. Aꞌ imol qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar utz, tuchꞌ qꞌu qꞌesal qꞌatol tzii. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Utz motx tal tu u Jesuus ech tzaꞌ: —¿Kam iijleꞌm naꞌan qꞌu kam tzaꞌ? Utz ¿abꞌil vetaqꞌon iijleꞌm tiꞌ ibꞌanaxeꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Atil maꞌl kam savabꞌi sete majte. Tzaqꞌbꞌetajin, ech saval sete kam vijleꞌm nunbꞌan qꞌu kam tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿U Tioxh tzik oksan u Xhan tiꞌ ibꞌanax vautiismo? ¿Oj aanima koꞌn oksan? Tzaqꞌbꞌetajin.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ech motx tek tal sivatzaj ech tzaꞌ: — «Tioxh chajon.» oj chajoꞌ: «¿Kantuꞌ yeꞌt enima?» Chaj qe atziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Utz oj: «Aanima koꞌn.» saqaleꞌ; yeꞌk siꞌaneꞌ.— Texhtuꞌ. Tan nichmotxixoꞌva qꞌu tenam. Tan kajay nichniman aas nojchit alol tetz yolbꞌal Tioxh u Xhan. ");
INSERT INTO ixlCNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ech motx itzaqꞌbꞌe u Jesuus, ech tzaꞌ: —Yeꞌ qootzaj.— Texh te. Ech tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Yitꞌ saꞌkojval sete majte kam vijleꞌm aas nunbꞌan qꞌu kam tzaꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Uncheeꞌ ech xeꞌt tal u Jesuus ech tzaꞌ, ikꞌam tiꞌ kam: —Aatz maꞌl u vinaj, ichik untanul iuuva. Utz ipeꞌi tiꞌ. Ikꞌot maꞌl pachꞌbꞌal tetz uuva tuul. Ech inukꞌ maꞌl tꞌankin xeebꞌ tetz u chikobꞌeꞌm. Ech tek taqꞌtuka kꞌam tunjolol kꞌamol. Utz bꞌen tzian. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Utz aatz opon u tiempo tetz iqꞌanbꞌebꞌal u uuva, ichaj opon maꞌl u taqꞌonom xeꞌ qꞌu kꞌamol tiꞌ ul tiqꞌol untanul ivatz vichikobꞌeꞌm, ayaꞌ u kꞌambꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pek aatz qꞌu kꞌamol tziꞌ, motx koꞌn itxay u aqꞌonom vaꞌl chajaxi, iqꞌosa. Utz nikoꞌxh bꞌioj kꞌasuꞌl tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ech ichaj paj chit bꞌen vaꞌt taqꞌonom u bꞌaal txꞌavaꞌ tziꞌ. Utz paqꞌax koꞌn sivan. Akꞌonsal iviꞌ. Utz motx koꞌn iyoqꞌ kꞌasuꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ichaj paj chit bꞌen vaꞌte. Utz aatz vaꞌt vaꞌl tziꞌ, yatzꞌax kuꞌen. Ech sibꞌ tereꞌn koꞌxh ichaj oponi. Pek atia qꞌosax kuꞌen. Utz atia yatzꞌaxi. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ech tiyaꞌtebꞌal tekuꞌen, aꞌ tek ichaj vikꞌaol u bꞌaal txꞌavaꞌ, vaꞌl tiira tii tiꞌ. Utz tal u bꞌaal txꞌavaꞌ ech tzaꞌ: «Atil tek bꞌoj tatin vunkꞌaol siatz siꞌaneꞌ atziꞌ.» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pek aatz qꞌu kꞌamol tziꞌ, motx tal sivatzaj ech tzaꞌ: «Aꞌ vaꞌl soꞌokka tu vimeꞌbꞌiꞌl vitat atziꞌ. Pek ¡kuyatzꞌtaj, ech oꞌ tek soꞌokkaꞌoꞌ tu qꞌu tetz!» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ech motx itxaya, iyatzꞌa utz; ikꞌon eluꞌl tiꞌ eluꞌl u chikobꞌeꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ech ¿kam tek bꞌoj siꞌan u bꞌaal txꞌavaꞌ nenacheꞌ? Aatz siꞌaneꞌ tan, suꞌuli utz, sisotzsa qꞌu kꞌamol. Ech sataqꞌ u chikobꞌeꞌm tunjoltu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Pek ¿yetz sikꞌlemal u Yolbꞌal Tioxh setaqꞌo vaꞌl tzꞌibꞌamalka nital ech tzaꞌ?: «Aatz u Sivan vaꞌl taqꞌka eloꞌp qꞌu bꞌanol otzotz echil tziꞌ, aal aꞌ u Sivan vaꞌl tiira ibꞌoꞌqꞌol tetz xoobꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","U kuBꞌaals Amlika vetbꞌanon u kam tziꞌ utz, techal sukuvatz.» Chia.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Uncheeꞌ aatz tek qꞌu qꞌesala, motx el itxumbꞌal tuul aas tiꞌ alaxku u yol tziꞌ aas kꞌamax tiꞌ qꞌu kꞌamol. Siꞌchtekitxay u Jesuus motx tala, pek ixoꞌva u mam tenam. Ech taqꞌka u Jesuus utz, motx kꞌasuꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Uncheeꞌ aatz tek iꞌana, motx opon unjolol fariseo kꞌatz u Jesuus tuchꞌ unjolol qꞌuꞌl oknaj tiꞌ u Herodes. Aꞌich isaꞌ siꞌchitxay u Jesuus tiꞌ maꞌj yol sataleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ech motx tal te tzaꞌ: —Chusul, qootzajle aas axh maꞌl vinaj inujul naaleꞌ. Yitꞌ aꞌ koj nibꞌenkꞌaxh tiꞌ qꞌuꞌl nital qꞌu aanima. Tan yitꞌ aꞌ koj nasaji kam tatin qꞌu aanima, pek tu chit inujul nichusunkꞌaxh tiꞌ u bꞌenchil xeꞌ u Tioxh. Pek al qe ¿bꞌaꞌn tzik aas nikuchoo jaꞌmel alkavaar tu u Cesar, oj yeꞌka?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ech aatz u Jesuus tan, yakich til vikaꞌvatzil qꞌu vinaj tziꞌ utz, tal te ech tzaꞌ: —¿Kam tokeꞌ aas vet sekꞌuꞌl nechꞌoti ok kam ve? Aqꞌtaj ul maꞌj puaj qabꞌi, savileꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ech aqꞌax maꞌl puaj te utz, tal ech tzaꞌ: —¿Abꞌil etz vatzibꞌal vaꞌl atoꞌk vatz u puaj tzaꞌ utz, abꞌil etz u bꞌii tzꞌibꞌamal ok siatz majte?— Texhtuꞌ. Utz motx tal ech tzaꞌ: —Tetz u Cesar atziꞌ, u ijlenal.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tzaqꞌbꞌel tu u Jesuus, tal ech tzaꞌ: —Aqꞌtaj tu u ijlenal Cesar kam tiꞌ vaꞌl nichoonkꞌex te. Utz aqꞌtaj tu u Tioxh abꞌiste u tetz Tioxh.— Texh te. Ech motx tzꞌejx ikꞌuꞌl tiꞌ u yol vaꞌl tal u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Uncheeꞌ opon qꞌu saduceo kꞌatz u Jesuus qꞌuꞌl yeꞌxhkam nimotxniman u qꞌaavtitzꞌpu qꞌu kamnaj. Utz motx ichꞌoti te ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Chusul, aatz u Moisees, itzꞌibꞌaka: «Oj sakam maꞌj vinaj utz, sakaa tixoj yeꞌk initxaꞌa, sikꞌulka tibꞌ vitzaꞌqꞌ u kamnaj tuchꞌ u tixoj. Ech sachee ichꞌexel.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Pek atich jujvaꞌl qꞌu vinaj itzaꞌqꞌ tibꞌ. Utz aatz iꞌan u bꞌaxa, ikꞌul tibꞌ tuchꞌ ixoj. Pek kam kuꞌen, yeꞌk initxaꞌa kaai. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ech aatz vikaꞌbꞌ, ikꞌul tibꞌ tuchꞌ u ixoj. Pek kam koꞌn pajeꞌ, yeꞌk paj initxaꞌa kaai. Echat koꞌxh iꞌan u toxvaꞌ majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Opon koꞌxh tijujvaꞌ, yeꞌk initxaꞌa motx kaai. Ech aatz maꞌtich ikam jujvaꞌl qꞌu vinaj tziꞌ, kam u ixoj majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Utz aatz tek tu u qꞌaavitzꞌpichil, ¿abꞌil tek ivinaj u ixoj liꞌana tziꞌ? Tan vetikꞌul tibꞌ tuchꞌ jujvaꞌl qꞌu vinaj.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Tzaqꞌbꞌu tek u Jesuus utz, tala: —Junal yolpinajex. Tan yeꞌ etootzaj u Yolbꞌal Tioxh tuchꞌ vitxumbꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tan aatz lauch u qꞌaavitzꞌpichil xoꞌl qꞌu kamnaj, yeꞌkan kꞌuliꞌbꞌ suꞌuchi. Tan ela tek qꞌu aanima tuchꞌ qꞌul iaanjel u Tioxh tu Amlika siꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Pek aatz tiꞌ u qꞌaavtitzꞌpu qꞌu kamnaj netaleꞌ tziꞌ, ¿yetz sikꞌlemal setaqꞌo tu u uꞌ vaꞌl itzꞌibꞌa u Moisees aas kaniꞌch viqꞌilal bꞌanax tu u Tioxh kꞌatz u chꞌiꞌx? Tan tal te ech tzaꞌ: «In viTioxh u Abrahaam. In viTioxh u Isaac. Utz in viTioxh u Jacoob.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tan aatz u Tioxh, yitꞌ iTioxh koj kamnaj, pek iTioxh itzꞌlich. Ech tiira sibꞌ yolpinajex.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Uncheeꞌ xaan opon maꞌl qꞌu aa txumbꞌal tetz u oꞌtla mantaar kꞌatza. Tan tabꞌi tuch u yol tziꞌ utz, bꞌaꞌn itzaqꞌbꞌu u Jesuus tabꞌi. Ech ichꞌoti te ech tzaꞌ: —¿Abꞌiste chit u qꞌesal mantaar viꞌ kajay qꞌu mantaar?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Aatz u qꞌesal mantaar viꞌ kajay qꞌu mantaar, ayaꞌ vaꞌl nital ech tzaꞌ: «Abꞌitaj ex Israeel, aatz u Tioxh u kuBꞌaal, maꞌl kuꞌen. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Utz tzꞌej avaanima tiꞌ vaTioxh, tuchꞌ avaanxelal, tuchꞌ atxumbꞌal utz, tuchꞌ ayakꞌil.» Chia. Tan aꞌ u qꞌesal mantaar. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Aatz u kaꞌbꞌ, ela koꞌn tuchꞌ. Nital ech tzaꞌ: «Tiiꞌaxh tiꞌ kajay aanima kꞌuxh kam koꞌxh aanimail echat koꞌxhtuꞌ aꞌ naꞌan saiꞌ.» Chia. Ech yeꞌk vaꞌt mantaar paalchu koj vatz qꞌuꞌl tziꞌ.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Uncheeꞌ tzaqꞌbꞌu tek u aa txumbꞌal tetz u oꞌtla mantaar, tal ech tzaꞌ: —Bꞌaꞌn vaꞌl naaleꞌ chusul. Aꞌ inujul vaꞌl naaleꞌ tziꞌ, aas maꞌl koꞌn Tioxh. Utz yeꞌk vaꞌt tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Aꞌ inujul majte vaꞌl naaleꞌ aas sakutzꞌej qaanima tiꞌ u Tioxh tuchꞌ kutxumbꞌal, tuchꞌ qaanxelal tuchꞌ kuyakꞌil. Utz aꞌ inujul aas sakubꞌan tiiꞌoꞌ tiꞌ kajay aanima echaꞌ nikubꞌan qiꞌ. Techal vatz jankꞌal qꞌu txꞌoloꞌm tuchꞌ qꞌu oya nitok vatz Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Uncheeꞌ aatz u Jesuus, tila aas tzakꞌumal itzaqꞌbꞌu u vinaj tziꞌ. Tal tek te ech tzaꞌ: —Yitꞌ tzian koj axh kꞌatz viQꞌesalail u Tioxh.— Texh te. Ech yeꞌxhabꞌil koꞌxh vaꞌtoj txꞌakon ichꞌotil kam te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Uncheeꞌ aatz nichichusun u Jesuus tu viqꞌanalil u totztioxh, tal ech tzaꞌ: —¿Kan chaj tok nital qꞌu aa txumbꞌal tetz u oꞌtla mantaar aas, ituꞌxh ixalam Daviid koꞌn viTxaaom u Tioxh nitaleꞌ? ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tan u Tioxhla Espiiritu yolon titziꞌ u Daviid aas taltu ech tzaꞌ: «Aatz u Tioxh, tal tu vunBꞌaal ech tzaꞌ: Kꞌujach tunsebꞌal tan, saꞌnalvaqꞌka qꞌul akoontra satzeqꞌlebꞌal. Chia.» Texh u Daviid. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Anat koꞌxh u Daviid alon aas “unBꞌaal”, chu tiꞌ viTxaaom u Tioxh. Ech ¿kam tokeꞌ oj ituꞌxh ixalam kuꞌen?— Texhtuꞌ. Ech mam tenam ayaꞌl ikꞌuꞌl nichabꞌin. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Nichpajtal u Jesuus tu vichusun ech tzaꞌ: —Bꞌantaj kuenta etibꞌ tiꞌ qꞌu aa txumbꞌal tetz u oꞌtla mantaar. Tan vatz ikꞌuꞌl paalchil tuchꞌ chelkin oksaꞌm. Utz aꞌ chit isaꞌ saꞌalax ichajlichil tu kꞌayibꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Utz aꞌ chit nichok qꞌu bꞌaxa chaj kꞌujlebꞌal tu qꞌu atibꞌal chusbꞌal tetz u oꞌtla mantaar. Utz aꞌ chit nikuꞌk tu qꞌu bꞌaxa kꞌujlebꞌal til niꞌuchku txꞌaꞌom tu nimla qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nimotxisubꞌ tzaj txakay ixoj tiꞌ qꞌu tetz. Vet chit sikꞌuꞌl niꞌaneꞌ. Nimuj qꞌul ibꞌanoneꞌ nimotxtaleꞌ. Tan sibꞌ chit tuul qꞌul iqꞌilat sikꞌlet Tioxh. Pek sibꞌ u choobꞌal paav saꞌalax ikuꞌ tiꞌ tu qꞌul ipaav niꞌaneꞌ.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Uncheeꞌ ex kꞌujeꞌoj u Jesuus kꞌatz u kaaxha, u molbꞌal kutxu tu viqꞌanalil u totztioxh. Utz nichisaji qꞌu aanima qꞌuꞌl nichentaqꞌ koꞌp puaj tu kaaxha. Utz sibꞌ txꞌiiol iqꞌii mam puaj nichentaqꞌ koꞌp. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Utz opon maꞌl u txakay ixoj tiira meꞌbꞌiꞌlich tetz. Utz ex taqꞌ koꞌp kaꞌvaꞌl puaj tiira chꞌoo tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ech aatz u Jesuus, isikꞌle qꞌul ichusulibꞌ utz, tal te ech tzaꞌ: —Niꞌxhtekꞌval sete, sibꞌal puaj vettaqꞌ koꞌp u txakay ixoj tziꞌ, kꞌuxh meꞌbꞌiꞌl tetz viꞌ tereꞌn qꞌuꞌl vetmotxtaqꞌ koꞌp tetz tu u kaaxha tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tan kajay qꞌuꞌl vetmotxtaqꞌ ikutxu, taꞌxh vetmotxtaqꞌa qꞌu chan ipuaj. Pek ech koj u txakay ixoj tziꞌ, kꞌuxh meꞌbꞌiꞌl tetz tan, nojchit aꞌ vetimoxsaka jankꞌal vatz tetz atile.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Uncheeꞌ aatz eluꞌl u Jesuus tu viqꞌanalil u totztioxh, alax te tu maꞌl qꞌul ichusulibꞌ ech tzaꞌ: —Chusul, saji ileꞌ. ¡Aꞌxh bꞌoj qꞌu sivan oknaj atziꞌ! Utz ¡aꞌxh bꞌoj ichꞌii qꞌu otzotz atziꞌ!— Texh tiꞌ u totztioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Alax te tu u Jesuus ech tzaꞌ: —¿Ni tzik etil qꞌu mamaj otzotz tziꞌ? Saꞌnaliꞌaneꞌ aas nikoꞌxh vaꞌtoj sivan sakaa tibꞌa imol. Yeꞌ koj sabꞌajax el.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Uncheeꞌ motx tek bꞌen viꞌ u muunte vaꞌl Olivo, tinujul iatz u totztioxh. Utz chꞌuxheꞌ u Jesuus tziꞌ. Ech motx chꞌotil te tu u Luꞌ, u Jacobo, u Xhan, tuchꞌ u Lixh aas ijunalich tuchꞌ. Tal te ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Al qe ¿jatu suꞌuch u kam tiꞌ u totztioxh naaleꞌ tziꞌ? Utz ¿kam xheenya saꞌatini aas laxeꞌti?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Tzaqꞌbꞌu u Jesuus utz, xeꞌt tek tal te ech tzaꞌ: —Letila tan, abꞌilich koꞌxh subꞌunex. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tan sibꞌal koꞌxh suꞌuli, sikꞌam tiꞌ vunbꞌii. Utz satal ech tzaꞌ: «In viTxaaom u Tioxh.» Chaj. Utz sibꞌal aanima sisubꞌeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pek aatz letabꞌi aas vaꞌl texh tuch chꞌaꞌo utz, setabꞌi iyolax chꞌaꞌo, xoꞌvichkoꞌxhex. Tan ministeer chit suꞌuch qꞌu kam ech tziꞌ. Loqꞌ yitꞌ aꞌ koj u motxebꞌal qꞌii saj. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tan saꞌnalmotxiꞌan chꞌaꞌo qꞌu mamaj tenam tibꞌilaj. Utz siꞌan chꞌaꞌo qꞌu qꞌesal mamaj tenam tibꞌilaj. Til chaj koꞌxh sapaalku mamaj kabꞌnaano. Saꞌatin vaꞌy. Sauch mamaj txabꞌkin. Loqꞌ aatz kajay qꞌu kam tziꞌ, ixeꞌtebꞌal koꞌn u motxebꞌal qꞌii saj. Echaꞌ ixeꞌt maꞌl mam kꞌaxkꞌo vaꞌl siꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Pek kuentaꞌex sejununil. Tan saꞌnaliqꞌolbꞌenex vatz qꞌu qꞌatbꞌal tzii. Utz saꞌnaltzꞌuꞌmalex tu qꞌu atibꞌal chusbꞌal tetz u oꞌtla mantaar. Saiqꞌolbꞌenex vatz gobernadoor, vatz ijlenal. Loqꞌ viꞌ kuꞌen. Ech setal u yolbꞌal Tioxh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tan ministeer aas bꞌaxa sapaxsalka el itziiul u bꞌaꞌnla chusbꞌal tiꞌ u chitpichil tu paav tu kajay qꞌu tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Aatz liqꞌolbꞌenex utz, loꞌoksalex tiqꞌabꞌ qꞌu qꞌatbꞌal tzii, elaꞌokiꞌch koꞌxh etaanima tiꞌ aas kaniꞌch etzaqꞌbꞌeꞌ. Etitzꞌachi. Pek aꞌ letala kam vaꞌl loꞌoksal sekꞌuꞌl tu u muꞌkꞌul tziꞌ. Tan ex koj vaꞌl sayolonex, pek u Tioxhla Espiiritu sayolon tetziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Toj nal iꞌaneꞌ, sixoch jeꞌ tibꞌ aanima. Kꞌuxh itzaꞌqꞌ tibꞌ satal ikameꞌ. Utz ech siꞌan u tat majte, sixoch vikꞌaol. Utz aatz qꞌu kꞌaol meꞌala, salakpu kꞌatz qꞌul itxutx ibꞌaal utz, siyatzꞌeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Utz saꞌnalixvalex tu kajay aanima, viꞌ kuꞌen. Pek abꞌiste vaꞌl saꞌxhtxꞌakon qꞌu kam tziꞌ utz, tii atoꞌk viꞌ, aꞌ vaꞌl soꞌopon tu bꞌenqꞌii bꞌensaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Utz aatz letila aas saꞌaqꞌlu u txaaꞌla kam, u telabꞌal qꞌii, tu u atibꞌal vaꞌl yitꞌ aꞌ koj saꞌatinka, oojojbꞌenex tulaj muunte abꞌil ex atilex tikuenta Judea. Tan aꞌ vaꞌl tal u Danieel, u alol tetz u yolbꞌal Tioxh. Abꞌil nisikꞌlen u kam tzaꞌ, paaloj itxumbꞌal tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Utz abꞌil atil jeꞌop viꞌ atibꞌal, kuꞌichtereꞌnop toꞌotzotz tiꞌ paal tiqꞌol maꞌj kam. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Utz abꞌil ayeꞌn jaꞌjtzeꞌ, qꞌaaviꞌchtereꞌnul tiꞌ ul tiqꞌol ichakeꞌt. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Pek tiira tilayol sayaꞌk qꞌu ixoj siꞌan tu qꞌu qꞌii tziꞌ, qꞌuꞌl atil tu tiichajla yaabꞌil, tuchꞌ qꞌuꞌl nichꞌuꞌn titzꞌin. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Echixeꞌat qꞌilataj sikꞌletaj Tioxh ech yitꞌ titiempoil koj txuncheꞌv liꞌan tu vetelabꞌal bꞌen. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tan aatz tu qꞌu qꞌii tziꞌ, mam kꞌaxkꞌo vaꞌl saꞌatini. Yeꞌsaj tuch unpajoj, jatvaꞌx tiempo ichee u vatz amlika txꞌavaꞌ ulyu koꞌxh tzaꞌ tuul. Utz yitꞌ saꞌkojuch vaꞌte. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Utz oj yeꞌk sikꞌol u tiempo u Tioxh tetz u kꞌaxkꞌo, abꞌil koj vaꞌtoj sitxaaka tibꞌ. Pek iqꞌaqꞌal koꞌn qꞌu aanima qꞌuꞌl itxaaom Tioxh kꞌuxh sakꞌolax u tiempo. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ech tokeꞌ oj abꞌil laꞌalon sete ech tzaꞌ: «Sajitaj etileꞌ, atil viTxaaom u Tioxh tzaꞌ.» Chaj. Enimachi. Utz oj: «Sajitaj, atil tziꞌ.» Chaj majte. Enimachi. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tan saꞌnalmotxchee bꞌensanibꞌ itxaaom Tioxh tuchꞌ bꞌensanibꞌ alol tetz u yolbꞌal Tioxh. Utz sikꞌuch xheenya tuchꞌ txaichil. Subꞌuꞌm siꞌan tuchꞌ. Utz bꞌaꞌn liꞌana, antu lisubꞌ qꞌu nojla itxaaom u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pek kuentaꞌex tan, vetvalluka el sete bꞌaxa kajayil. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Pek aatz liꞌan tu qꞌu qꞌii tziꞌ aas maꞌt ipaal u mam kꞌaxkꞌo, saok aqꞌbꞌal vatz u qꞌii. Utz yeꞌkan satxijtxun u ichꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Sachajpu qꞌu txꞌumiꞌl tu amlika. Utz sayikun kajay qꞌu kam atil tu amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ech sailax tul tu sutzꞌ u Kꞌaola vaꞌl bꞌennaj koꞌn aanima. Toxhqꞌebꞌal tul tu u mam tijleꞌm tuchꞌ tu vipaqꞌun siꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ech sichaj kꞌasuꞌl qꞌul iaanjel utz, simol qꞌul itxaaom u Tioxh tu kaa tanul vikuentail u vatz amlika txꞌavaꞌ. Kꞌuxh til chaj koꞌxh atilku tijuꞌaj. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Pek atoj bꞌenku sete u kꞌamich yol tiꞌ u viikuxh tzaꞌ. Tan aatz nichaꞌxbꞌu viqꞌabꞌ u viikuxh, niteluꞌl talaj ixaj utz, etootzaj tekuꞌen aas ninajabꞌ u saqꞌi. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Echat koꞌxh ex majte, aatz letil kajay qꞌu kam tziꞌ, etootzajitaj aas tiira najabꞌyu ul u tulebꞌal viTxaaom u Tioxh vaꞌl bꞌennaj koꞌn aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tan niꞌxhtekꞌval sete, yeꞌsajen koꞌxh isotz qꞌu aanima itzꞌlel tu tiempo tziꞌ, tuul suꞌuch kajay qꞌu kam tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Sakoꞌnpaal u vatz amlika txꞌavaꞌ tzaꞌ, pek aatz vunyolbꞌal tan, jatu koj sapaali. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Pek ech koj u qꞌii tuchꞌ u oora tan, abꞌil koj ootzajin tetz. Nikoꞌxh qꞌu aanjel ootzajin tetz qꞌuꞌl atil tu Amlika. Utz nikoꞌxh viKꞌaol u Tioxh. Pek taꞌxh ootzajin tetz vunTat. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Pek iltaj, nachnoj etatineꞌ. Utz qꞌilataj sikꞌletaj Tioxh tan, yeꞌ etootzaj kam tuul suꞌuli. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Tan ech siꞌaneꞌ vaꞌl niꞌan maꞌl u vinaj aas bꞌen tzian. Taqꞌka qꞌu tetz tiqꞌabꞌ qꞌu taqꞌonom utz, taqꞌka tijleꞌm qꞌu taqꞌonom. Talka taqꞌon sijununil. Utz tii talka tu u xeen okebꞌalop aas liistaoj koꞌxhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ech tokeꞌ tiira liistaojkoꞌxhex tan, yeꞌ etootzaj jatu suꞌul u bꞌaal otzotz. Matz sotzsaj, oj nikꞌa aqꞌbꞌal. Matz tu toqꞌ tꞌel, oj kꞌasuꞌl saj. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Tan bꞌaꞌn liꞌana yeꞌk talcheꞌ luꞌuli. Ech yitꞌ vatchelkojex luꞌuli. ");
INSERT INTO ixlCNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Utz kam vaꞌl nival sete tzaꞌ, sekajayil nivalva aas nachnoj etatineꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Uncheeꞌ kaꞌvaꞌtich koꞌn qꞌii topon qꞌu nimla qꞌii, tiꞌ u Elchil Vatz Kamchil Tu Egipto tuchꞌ u Txꞌaꞌbꞌal Kaxhlaan Txꞌix Yeꞌk Itxꞌamil, nichmotxichok onkonla txumbꞌal qꞌu qꞌesal uqꞌaybꞌal, tiꞌ kaniꞌch itxaytu u Jesuus, ech siyatzꞌeꞌ. Aꞌ nichbꞌanon u kam, qꞌu oksan yol vatz Tioxh, tuchꞌ qꞌu aa txumbꞌal tetz u oꞌtla mantaar. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Loqꞌ nichmotxtal ech tzaꞌ: —Yitꞌ tu koj u nimla qꞌii sakubꞌan te, ech yeꞌk txabꞌkin liꞌan qꞌu tenam.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Uncheeꞌ atich u Jesuus tu Betaania tu otzotz xeꞌ u Xhim, vaꞌl chꞌaꞌkꞌiꞌich. Atich ok vatz meexha, tuul opon maꞌl u ixoj iqꞌomich maꞌl tal bꞌaꞌnla tzꞌaj taqꞌo, atich txꞌumqꞌixsabꞌal tuul. Tiira bꞌaꞌnla nardo, sibꞌ ijaꞌmel. Ech iqꞌipeꞌl itziꞌ u tal tzꞌaj utz, taqꞌ jeꞌ u txꞌumqꞌixsabꞌal tiviꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ech motx lakp iviꞌ unjolol tiꞌ utz, tal tu taanima ech tzaꞌ: —¿Kantuꞌ atziꞌ aas maꞌkoꞌxhibꞌuchleꞌl u txꞌumqꞌixsabꞌal tziꞌ? ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Aal bꞌaꞌn vetkojikꞌayi. Utz saꞌaqꞌax vijaꞌmel tu qꞌu meꞌbꞌaꞌ. Tan maas 300 jaꞌmel qꞌii aqꞌon seꞌenku koj atziꞌ.— Texhtuꞌ. Ech vaꞌlich motx teesat iqꞌii u ixoj tiꞌ vaꞌl iꞌana. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pek tal u Jesuus ech tzaꞌ: —Kam esaꞌ te. Kantuꞌ nikoꞌxhekalabꞌtziiu tan, maꞌl bꞌaꞌnil vetiꞌanlu ve atziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Aatz qꞌu meꞌbꞌaꞌ netaleꞌ tziꞌ, bꞌenamen koꞌxh atil texoꞌl atziꞌ. Utz lebꞌan u bꞌaꞌnil te jatu. Pek aatz in tan, bꞌenamen koj saꞌatinin texoꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Tan aatz u ixoj tziꞌ, vetiꞌanlaꞌ jankꞌal vatz ipuunto. Vetibꞌaxabꞌsa el itxꞌumqꞌixsal vunchiꞌl tzaꞌ tiꞌ u mujbꞌal vetz aas lakamin. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Utz niꞌxhtekꞌval sete, til chit sapaxsalik itziiul u bꞌaꞌnla chusbꞌal tu u vatz amlika txꞌavaꞌ tzaꞌ, sayolax kꞌasuꞌl vaꞌl vetiꞌan u ixoj tziꞌ; nachbꞌal taanima.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Uncheeꞌ aatz u Judas aa Cariote vaꞌl atich ok xoꞌl kabꞌlaal qꞌu chusulibꞌ, bꞌen xeꞌ qꞌu qꞌesal oksan yol vatz Tioxh tiꞌ toksal u Jesuus tiqꞌabꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ech motx chit txuqꞌtxun qꞌu qꞌesal oksan yol vatz Tioxh aas tabꞌitaꞌ. Utz talaꞌtziꞌi tek ipuaj u Judas tiꞌ vaꞌl siꞌaneꞌ. Ech aatz u Judas tan, nichtekiꞌan tiꞌ kaniꞌch toksal u Jesuus tiqꞌabꞌ siꞌchiꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Uncheeꞌ aatz iꞌan tu u bꞌaxa qꞌii tetz u nimla qꞌii, ayaꞌ u Txꞌaꞌbꞌal Kaxhlaan Txꞌix Yeꞌk Itxꞌamil, tal qꞌu chusulibꞌ tu u Jesuus ech tzaꞌ: —¿Til asaꞌ sakubꞌanvu tuch u echbꞌubꞌal tetz kuꞌebꞌal qꞌii? Ech saqechbꞌu vaꞌl ninalchittechbꞌul tu u nimla qꞌii.— Texh te. Tan aꞌ u qꞌii vaꞌl niyatzꞌvu qꞌu karneꞌl qꞌu Israeel vaꞌl satechbꞌu kuꞌqꞌii tiꞌ u Elchil Vatz Kamchil Tu Egipto. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ech aatz u Jesuus, ichaj bꞌen kaꞌvaꞌl qꞌul ichusulibꞌ utz, tal bꞌen te ech tzaꞌ: —Bꞌenojex tu tenam utz, letila tan, loꞌok maꞌl u vinaj tebꞌey iqꞌomal maꞌl txeꞌn aꞌ taqꞌo. Utz laxambꞌubꞌenex tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Utz til vaꞌl loꞌokku u vinaj tziꞌ, leqꞌila u bꞌaal otzotz. Letal te ech tzaꞌ: «Nital u chusul: ¿Keꞌch u atibꞌal vaꞌl savechbꞌuv u echbꞌubꞌal tuchꞌ qꞌul unchusulibꞌ vaꞌl nitechbꞌul tu u nimla qꞌii? Chia.» Chajex te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ech likꞌuch maꞌl u nimla tuul otzotz sete tikaꞌ chupul, bꞌanel tek tucheꞌ. Utz ech chꞌiansataj qechbꞌubꞌal tziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ech bꞌen qꞌu chusulibꞌ tu u tenam. Utz til u atibꞌal ech chituꞌ vaꞌl tal u Jesuus te. Ech ibꞌantu tuch u echbꞌubꞌal tziꞌ vaꞌl nitechbꞌul tu u nimla qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Aatz tek sotzsaj, opon u Jesuus tuchꞌ kabꞌlaal qꞌul ichusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Utz tuul atich vatz meexha, nichmotxitxꞌaꞌneꞌ, tal u Jesuus ech tzaꞌ: —Niꞌxhtekꞌval sete aas maꞌl sete netxꞌaꞌn sunkꞌatza cheel tzaꞌ, soꞌoksanin tiqꞌabꞌ qꞌu txayol vetz.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ech xeꞌt itxumun qꞌu chusulibꞌ. Utz junun ichꞌoti tu u Jesuus ech tzaꞌ: —¿Yitꞌ tzik in?— Chu te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ech tal u Jesuus ech tzaꞌ: —Maꞌl sete ex unchusulibꞌ tziꞌ, ayaꞌ vaꞌl ela nunchaaon tuchꞌ tu puraato. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tan aatz u Kꞌaola vaꞌl bꞌennaj koꞌn aanima, sakami. Utz nojchit aꞌ nipaalku tu qꞌu kam qꞌuꞌl tzꞌibꞌamalka tiꞌ tu u Yolbꞌal Tioxh. Pek tilayol sayaꞌk u vinaj, vaꞌl soꞌoksan tiqꞌabꞌ qꞌu txayol. Aal tek bꞌaꞌn atziꞌ yeꞌt koj itzꞌpi.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ech tuul koꞌxh nichmotxtechbꞌuneꞌ, itxay u kaxhlaan txꞌix u Jesuus utz, ijaj bꞌaꞌnil tiꞌ. Ipixh tuul utz, taqꞌ tu qꞌu chusulibꞌ. Utz tal ech tzaꞌ: —Tiꞌextaj. Aꞌ vunchiꞌl atziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ech paj itxay u ukꞌabꞌal. Utz taqꞌ tu qꞌul ichusulibꞌ aas maꞌtich ikꞌamabꞌet Tioxh tiꞌ. Ech motx tukꞌa tetz tuul sikajayil. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Tal u Jesuus te ech tzaꞌ: —Aꞌ vunkajal atziꞌ vaꞌl nitel tiꞌ u akꞌ nukꞌuꞌm vaꞌl tetz kuybꞌal ipaav sibꞌal aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Utz niꞌxhtekꞌval sete aas yeꞌxhjatu veꞌt savukꞌa u taꞌl ivatz uuva tzaꞌ. Pek analen savukꞌa u akꞌ taꞌl uuva tu maꞌl u qꞌii tu viQꞌesalail u Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ech taꞌxh veet ibꞌitzat u bꞌitzal, motx bꞌen viꞌ u muunte vaꞌl Olivo. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Utz tal u Jesuus tu qꞌu chusulibꞌ ech tzaꞌ: —Kajay ex samotxsotz ekꞌuꞌl viꞌ tu aqꞌbꞌal cheel. Tan tzꞌibꞌamalka ech tzaꞌ: «Sayatzꞌax u xeen karneꞌl utz, saꞌtexhmotxpalun qꞌu karneꞌl.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pek loqꞌ aatz maꞌt qꞌaav vitzꞌpeꞌ, sabꞌaxabꞌbꞌenin sevatz tu Galilea.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ech alax te tu u Luꞌ ech tzaꞌ: —Kꞌuxh kajay samotxsotz ikꞌuꞌl saiꞌ, aatz in tan, jatu koj sasotz unkꞌuꞌl saiꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Niꞌxhtekꞌval see, aatz yeꞌsaj toqꞌ kaꞌpajul u bꞌaal tꞌel tu u aqꞌbꞌal cheel, ox pajul maꞌt aaltaꞌ aas yootzajin.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pek aatz u Luꞌ, taꞌxh txumel taqꞌo nichtal ech tzaꞌ: —¡Aꞌtzii sunqꞌiꞌeꞌ kꞌuxh sakamin saiꞌ! ¡Jatu koj savelabꞌekaꞌaxh!— Texh te. Echat chit motx tal qꞌu chusulibꞌ sikajayil. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Uncheeꞌ motx opon tu u chikonbꞌal Getsemanii. Utz tal u Jesuus tu qꞌul ichusulibꞌ ech tzaꞌ: —Kꞌujeꞌojkaꞌex tzaꞌ, taꞌn tuul sunqꞌila sikꞌle Tioxh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ech tiqꞌot bꞌen u Luꞌ tiꞌ. Antu u Jacobo tuchꞌ u Xhan. Utz xeꞌt tul maꞌl mam txumun tu taanima. Tiira oks il. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ech tal tek u Jesuus te ech tzaꞌ: —¡Techal itxumun vaanxelal! ¡Saꞌtexhkamin taqꞌo nunnache! Pek kaaojkaꞌex tzaꞌ utz, itzꞌlojex.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ech xaan bꞌen bꞌiil. Pecheꞌ kuꞌ vatz txꞌavaꞌ. Utz iqꞌila sikꞌle Tioxh. Utz ijaja aas yetz siꞌchveeti yeꞌk sapaal tu u mam il tzaꞌl vaꞌl sapaalka. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tal ech tzaꞌ: —Tateey, kajay kam niveet saatz. Pek ¡eesaꞌin tu u mam il tzaꞌl! Loqꞌ aꞌ saꞌan vatxumbꞌal; yitꞌ aꞌ koj sapaal u vetz.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ech ul kꞌatz qꞌul ichusulibꞌ. Utz tila jolol koꞌn vatchiche. Utz tal tu u Luꞌ ech tzaꞌ, vaꞌl Xhim ibꞌii majte: —¿Xhim, vataꞌm koꞌn naꞌan tzik? ¿Yeꞌxh aqꞌiꞌ itzꞌeꞌchil maꞌj oora tzik? ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Itzꞌlojex. Utz qꞌilataj sikꞌletaj Tioxh, ech yeꞌk sakuꞌex tu paav. Tan aatz u aanxelal, nojchit vatz ikꞌuꞌl iqꞌilal sikꞌlel Tioxh; pek aatz u chiꞌl tan, yiꞌsaꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ech bꞌen pajeꞌ, ex iqꞌila sikꞌle Tioxh. Ankoꞌxh tal qꞌu yol qꞌuꞌl tal bꞌaxa. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ech qꞌaavuꞌl utz, tila vatchich koꞌn paj qꞌul ichusulibꞌ. Tan axhibꞌi tiira techalich motx ikam tu vataꞌm. Ech yeꞌ nichmotxikan tel tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Titoxpaj tek iqꞌaavuꞌl u Jesuus, tal tu qꞌul ichusulibꞌ ech tzaꞌ: —¿Ankoꞌxh vatchelex utz, ilannajkoꞌnex tzik? Vetiꞌanlaꞌ. Oponyu u oora aas soꞌoksal u Kꞌaola vaꞌl bꞌennaj koꞌn aanima tiqꞌabꞌ qꞌu aa paav. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pek ¡lakpojex! Utz ¡koꞌtaj! Tan tul vaꞌl saꞌaqꞌonin tu qꞌu txayol.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Uncheeꞌ ankoꞌxh nichiyolon u Jesuus, tuul opon u Judas; ayaꞌ maꞌl xoꞌl kabꞌlaal qꞌu chusulibꞌ. Sibꞌal aanima imol. Jolol iqꞌomal ichꞌichꞌ tuchꞌ itzeꞌ. Ichaj qꞌu qꞌesal oksan yol vatz Tioxh, tuchꞌ qꞌu aa txumbꞌal tetz u oꞌtla mantaar utz, tuchꞌ qꞌu qꞌesal qꞌatol tzii. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ech aatz u Judas, vaꞌl aqꞌon u Jesuus tu qꞌu txayol tan, maꞌtich taltaꞌ kam u xheenya siꞌan tiꞌ ikꞌuchleꞌ. Tal ech tzaꞌ: —Abꞌiste vaꞌl luntzꞌutzꞌa, letxaya tan, aꞌ i. Utz letiqꞌo bꞌen. Bꞌoono ixeel lebꞌana.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ech opon u Judas kꞌatz u Jesuus, tal te ech tzaꞌ: —Chusul.— Texh te. Ech itzꞌutzꞌa. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ech yakich opon qꞌu aanima utz, itxay u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pek aatz maꞌl tixoꞌl qꞌuꞌl atich tziꞌ, ijuu ichꞌichꞌ utz, ech itzokꞌeꞌl ixichin maꞌl u taqꞌonom qꞌu qꞌesal oksan yol vatz Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ech tzaqꞌbꞌu u Jesuus tala: —Ayaꞌl aꞌ itxayax maꞌj elqꞌom nebꞌan ve, iqꞌomal echꞌichꞌ tuchꞌ etzeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Jun qꞌii atichꞌin texoꞌl tu viqꞌanalil u totztioxh. Nichunchusuneꞌ utz, yeꞌt etxayin. Pek loqꞌ ech chit siꞌaneꞌ. Tan aꞌ nitzojpu u Yolbꞌal Tioxh tzꞌibꞌamalka.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ech kajay qꞌu chusulibꞌ motx elabꞌenka. Motx tek ooji. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Utz antu txaypu maꞌl u xiak xamich tiꞌ. Liikin bꞌuꞌj koꞌn atich ok tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pek aatz iꞌan u xiak tziꞌ, itxꞌol elchil. Ichajpuka u liikin bꞌuꞌj utz, tꞌuꞌlich tekuꞌen aas bꞌeni. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Uncheeꞌ ech iqꞌol bꞌen u Jesuus xeꞌ u qꞌesal oksan yol vatz Tioxh. Utz imol tibꞌ tereꞌn qꞌu oksan yol vatz Tioxh majte qꞌuꞌl atil tijleꞌm. Antu qꞌu aa txumbꞌal tetz u oꞌtla mantaar tuchꞌ qꞌu qꞌesal qꞌatol tzii. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Utz xamtichka u Luꞌ tiꞌ u Jesuus tzian. Yakich okoꞌp vatz qꞌanal xeꞌ u qꞌesal oksan yol vatz Tioxh. Utz kꞌujeꞌ xoꞌl qꞌu xeen tetz vikuentail u totztioxh. Ilee tibꞌ tziꞌ xamal. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ech aatz qꞌu qꞌesal oksan yol vatz Tioxh, tuchꞌ kajay qꞌu qꞌesala, nichmotxichok ipaav aas kam tiꞌ satxaypik u Jesuus. Aꞌ isaꞌ sayatzꞌaxi. Loqꞌ yeꞌ nichmotxteloꞌp tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tan kꞌuxh sibꞌal txakbꞌaꞌn txubꞌaꞌl jeꞌ iyol tiꞌ u Jesuus, yeꞌ nichikꞌul tibꞌ qꞌul iyol. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Pek chee unjolte, itxakbꞌaꞌ paj txubꞌaꞌl tiꞌ u Jesuus ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Aatz oꞌ, vetmotxqabꞌi taltaꞌ: «Sunnil kuꞌ vikuentail u totztioxh vaꞌl bꞌanoꞌm koꞌn aanima tziꞌ. Utz tu koꞌn oxvaꞌl qꞌii sunbꞌanvu vaꞌte, yitꞌ ibꞌanoꞌm tereꞌn koj aanima.» Chia.— Texh tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pek nikoꞌxh tu vaꞌl tala tziꞌ, nichkojikꞌul tibꞌ qꞌul iyol. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Uncheeꞌ aatz tek u qꞌesal oksan yol vatz Tioxh, txakeꞌ tu xoꞌl utz, ichꞌoti tu u Jesuus ech tzaꞌ: —¿Yeꞌxh natzaqꞌbꞌu bꞌoj tiꞌ qꞌu kam nitalchu saiꞌ tziꞌ tzik?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Aatz u Jesuus tan, tiira yeꞌ nichitzaqꞌbꞌeꞌ. Ech alax paj te tu u qꞌesal oksan yol vatz Tioxh ech tzaꞌ: —¿Axh tzik viTxaaom u Techalla Tioxh, ayaꞌ vikꞌaol?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Tal tek u Jesuus ech tzaꞌ: —In chituꞌ. Utz saꞌnaletil u Kꞌaola vaꞌl bꞌennaj koꞌn aanima kꞌujlel tisebꞌal u Tioxh tu u mam tijleꞌm. Utz setil tul tu sutzꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Aatz tek u qꞌesal oksan yol vatz Tioxh, iqꞌix jeꞌ toksaꞌm kꞌatza tu kꞌaꞌnal utz, tala: —¡Kam tereꞌn texhtiigo kusaꞌ! ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","¡Matz etabꞌi viyoqꞌtu u Tioxh! Pek ¿kam setal tiꞌ?— Texhtuꞌ. Ech kajay qꞌu aanima alon ikameꞌ. Kamchil tetz motx tala. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ech atia xeꞌt tzubꞌan u Jesuus. Utz itxꞌut iatz tu bꞌuꞌj. Ech nichiqꞌoseꞌ. Utz nichichꞌoti te ech tzaꞌ: —¡Ala, abꞌil vetqꞌosonaxh!— Chu te. Ech paqꞌax ok ivatz tu qꞌu xeen tetz vikuentail u totztioxh majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Uncheeꞌ aatz u Luꞌ, atich kuꞌl tu qꞌanal, tuul opon maꞌl vikꞌulanal u qꞌesal oksan yol vatz Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Utz nichilee tibꞌ u Luꞌ tziꞌ xamal. Tii chit isaji utz, tal te ech tzaꞌ: —Ant axh majte, atichꞌokꞌaxh tiꞌ u Jesuus aa Nazareet.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pek aatz u Luꞌ tan, teesa koꞌn tibꞌ tuul. Utz tala: —Yeꞌ vootzaj abꞌil naaleꞌ. Kam nabꞌ koꞌxh naal bꞌa.— Texhtuꞌ. Ech eluꞌl tziꞌ u okebꞌalop vatz qꞌanal, tuul oqꞌ u bꞌaal tꞌel. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Aatz u kꞌulanal, taꞌxh paj til u Luꞌ, tal tu qꞌu aanima qꞌuꞌl atich tziꞌ ech tzaꞌ: —Aatz vaꞌl tziꞌ, imol atziꞌ.— Texh tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pek aatz u Luꞌ tan, teesa koꞌn paj tibꞌ tuul. Ech bꞌiil koꞌxh tuul, aatz qꞌu aanima atich tziꞌ, tal tu u Luꞌ ech tzaꞌ: —Nojchit axh imol atziꞌ tan, axh aa Galilea. Utz ela vayolon tuchꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ech aatz u Luꞌ, xeꞌt koꞌn tal tzꞌejbꞌal yol. Vaꞌlich toksat Tioxh tuul nichtal ech tzaꞌ: —Yeꞌ vootzaj abꞌil u vinaj netaleꞌ tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ech tuul oqꞌ u bꞌaal tꞌel tikaꞌpaj. Utz ul tek qꞌul iyol u Jesuus sikꞌuꞌl u Luꞌ vaꞌl alax te ech tzaꞌ: —Aatz yeꞌsajen toqꞌ kaꞌpajul u tꞌel, ox pajul maꞌt aaltaꞌ aas yootzajin.— Texhich te. Ech ul qꞌu yol sikꞌuꞌl u Luꞌ tziꞌ utz, itzꞌejeꞌl oqꞌel. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Uncheeꞌ tiira qꞌalaꞌm, motx imol tibꞌ qꞌu qꞌesala xoꞌl qꞌu Israeel. Ayaꞌ qꞌu qꞌesal oksan yol vatz Tioxh, tuchꞌ qꞌu aa txumbꞌal tetz u oꞌtla mantaar, tuchꞌ qꞌu qꞌesal qꞌatol tzii. Ech qitzel ibꞌen u Jesuus iꞌana. Ex taqꞌ tiqꞌabꞌ u gobernadoor aa Roma vaꞌl Pilato ibꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ech aatz u Pilato, ichꞌoti tu u Jesuus ech tzaꞌ: —¿Axh tzik u tijlenal qꞌu Israeel tzaꞌ?— Texh te. Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Ayaꞌ vaꞌl naaleꞌ tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Vaꞌlich motx ixochtu u Jesuus qꞌu qꞌesal oksan yol vatz Tioxh, tiꞌ sibꞌal kam vatz u Pilato. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ech aatz u Pilato, ichꞌoti paj tu u Jesuus ech tzaꞌ: —¿Kantuꞌ yeꞌ natzaqꞌbꞌeꞌ? ¿Yetz niil tzik kam koꞌn tiꞌ nixochpikꞌaxh?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pek aatz u Jesuus, nikoꞌxh tzaqꞌbꞌu koj pajeꞌ. Ech nichtexhisotz ikꞌuꞌl u Pilato taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pek aatz nichibꞌanax tu u nimla qꞌii, jun yaꞌbꞌ nichichajpul maꞌl preexhu. Loqꞌ qꞌu tenam nichjajon abꞌiste visaꞌ sachajpi. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ech atich maꞌl u vinaj, Barrabaas ibꞌii. Atich kuꞌ tu preexhuil tuchꞌ unjot imol tan, motx iꞌan maꞌl txabꞌkin utz, motx yatzꞌoni. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ech opon qꞌu tenam vatz u Pilato. Utz xeꞌt motx ijajeꞌ aas sachajpul maꞌl preexhu echaꞌ ninalibꞌanaxeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Utz tzaqꞌbꞌel tu u Pilato ech tzaꞌ: —¿Aꞌ tzik esaꞌ aꞌ sunchajpu u tijlenal qꞌu Israeel tziꞌ?— Texh tiꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tan tootzajich u Pilato, aas chiꞌikꞌuꞌl nichmotxiꞌan qꞌu qꞌesal oksan yol vatz Tioxh tiꞌ, kꞌuxh tiqꞌo opon siatz. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pek aatz qꞌu qꞌesal oksan yol vatz Tioxh, motx ichajtziꞌi qꞌu tenam aas aꞌ sijaj ichajpu u Barrabaas. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ech aatz u Pilato tan, tal paj ech tzaꞌ: —¿Kam sunbꞌan tu vaꞌl tijlenal qꞌu Israeel cheꞌex tiꞌ tziꞌ uncheeꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ech motx qetun taltu ech tzaꞌ: —¡Jeꞌoj vatz kurus!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Tal paj u Pilato ech tzaꞌ: —¿Kam mam onkonil vetiꞌana uncheeꞌ?— Texhtuꞌ. Pek aal koꞌn techal iqetun motx iꞌana. Motx koꞌn paj tal ech tzaꞌ: —¡Jeꞌoj vatz kurus!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ech aatz u Pilato, ipaasa chit ikꞌuꞌl qꞌu tenam. Ichajpu u Barrabaas. Utz tal tek itzꞌuꞌmal u Jesuus. Ech taqꞌtu tzii sajeꞌ vatz kurus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ech aatz qꞌu sol tan, tiqꞌo bꞌen u Jesuus tu u vatz iqꞌanalil u qꞌesal qꞌatbꞌal tzii. Utz ech imol tibꞌ kajay qꞌu sol atich tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Utz motx toksa maꞌl u bꞌaꞌnla liikin kaj oksaꞌm kꞌatza. Utz motx taqꞌ jeꞌ maꞌl chꞌiꞌx koroona tiviꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ech xeꞌt motx taqꞌ ichajlichil u Jesuus; loqꞌ telabꞌal iqꞌii nichiꞌaneꞌ. Tal te ech tzaꞌ: —¡Techal axh, axh tijlenal qꞌu Israeel!— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Utz motx ipaqꞌ tzeꞌ iviꞌ. Itzubꞌa ivatz. Utz pecheꞌ siatz. Atil tatin siatz tilon tu qꞌul nichmotxiꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Uncheeꞌ aatz tek veet teesat iqꞌii u Jesuus, motx teesa u kaj oksaꞌm kꞌatza utz, iqꞌaavixsaꞌok u toksaꞌm. Ech tiqꞌo eluꞌl tiꞌ u tenam. Taqꞌ jeꞌ vatz kurus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Utz ikꞌul maꞌl u vinaj, Xhim ibꞌii aa Cirene; aalich tul jaꞌjtzeꞌ. Itat u Alejandro tuchꞌ u Rufo. Utz taꞌxh iyaꞌlu tiꞌ tiqꞌol vikurus u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ech iqꞌol bꞌen u Jesuus tu u txꞌavaꞌ Goolgota. Tatibꞌal bꞌajil iviꞌ kamnaj, chu u tokebꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Utz aqꞌax taꞌl uuva te yuuel tuchꞌ u kꞌayla taꞌl tzeꞌ mirra. Pek yeꞌt koꞌn isaꞌ tukꞌaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ech taqꞌ jeꞌ u Jesuus vatz kurus. Utz iꞌan maꞌl saach qꞌu sol tiꞌ qꞌu toksaꞌm aas abꞌil lasuertiin tala; kam satiqꞌo sijununil. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Aꞌ chit a las 9 tetz qꞌalaꞌm aas motx taqꞌ jeꞌ u Jesuus vatz kurus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ech motx itzꞌibꞌa jeꞌ tiviꞌ u kurus vipaav u Jesuus aas nichmotxtaleꞌ. “TIJLENAL QꞌU ISRAEEL.” Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Utz taqꞌ jeꞌ kaꞌvaꞌt elqꞌom vatz kurus kꞌatza majte. Maꞌl tisebꞌal utz, vaꞌt timax. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ech itzojpu u yol vaꞌl tzꞌibꞌamalka nital ech tzaꞌ: —Aꞌ okku xoꞌl qꞌu aa paav.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ech nichipaal aanima vatz u Jesuus. Utz nichiyiku iviꞌ; nichiyoqꞌeꞌ. Nichtal ech tzaꞌ: —Eeꞌ, ¿axh tzik vaꞌl sanilon kuꞌ vikuentail u totztioxh utz, tu koꞌn oxvaꞌl qꞌii soꞌolekꞌaxh tiꞌ qꞌaav inukꞌaxeꞌ naaleꞌ? Qileꞌ qabꞌi. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ech ¡eesa iibꞌ tu u tzaꞌl sajunal tziꞌ! Kuꞌenul vatz u kurus tziꞌ.— Chu te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Echat koꞌxh iꞌan qꞌu qꞌesal oksan yol vatz Tioxh tu u Jesuus majte. Nichteesa iqꞌii. Utz nichtal sivatzaj tuchꞌ qꞌu aa txumbꞌal tetz u oꞌtla mantaar ech tzaꞌ: —Teesa unjot aanima tu tzaꞌl, pek yeꞌ nitxꞌol teesat tibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kuꞌojul viTxaaom u Tioxh vatz kurus tziꞌ qabꞌi, u tijlenal qꞌu Israeel. ¡Ech saqileꞌ utz, sakunima!— Texhtuꞌ. Utz nichmotxiyoqꞌon qꞌuꞌl atich jeꞌ kꞌatz u Jesuus vatz kurus majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ech aatz iꞌan chaqꞌaal qꞌii, ok aqꞌbꞌal tu u vatz amlika txꞌavaꞌ kajayil. Anal eli iꞌan alas 3 kuꞌqꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Utz aatz iꞌan tu alas 3 tziꞌ, jankꞌal iyakꞌil u Jesuus qetun tal tu ech tzaꞌ: —Eloi, Eloi, ¿lama savaktani?— Texhtuꞌ. Aatz u tokebꞌal utz: —¡UnTioxh chiꞌin! ¡UnTioxh chiꞌin! ¿kantuꞌ vetaaqꞌlukaꞌin sunjunal?— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ech aatz unjolol tu qꞌuꞌl atich najaꞌch, taꞌxh tabꞌi u yol, motx tal ech tzaꞌ: —Matz etabꞌi; u Elias nisikꞌle.— Texh tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ech aatz iꞌan maꞌl qꞌu aanima tziꞌ, jutzini; ex ijilu maꞌl esponja tu minaagre. Iqitzoꞌk tiꞌ maꞌl tzeꞌ. Ech taqꞌ jiꞌop titziꞌ u Jesuus. Sitzꞌutzꞌeꞌl u minaagre tiꞌ tala. Tuul nichtal ech tzaꞌ: —¡Kam esaꞌ te! Saqileꞌ qabꞌi satzuleesaloj tu u Elias.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Pek aatz u Jesuus tan, jankꞌal iyakꞌil qetuni utz, kami. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ech aatz u mam liikin bꞌuꞌj vaꞌl jatxonnaj tetz tuul u totztioxh, tzilmi. Kaꞌvaꞌl el tuul. Aal ikuꞌl itzilmeꞌ iꞌana. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ech aatz u qꞌesal sol, txaklich vatz u Jesuus, tila aas ech iqetun u Jesuus tziꞌ el ikꞌuꞌl. Tal tek ech tzaꞌ: —Aatz u vinaj tziꞌ, ¡nojchit aꞌ viKꞌaol u Tioxh atziꞌ!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Atich unjolol ixoj tixoꞌl majte: u Liꞌ aa Magdala, tuchꞌ u Liꞌ vinan u Jacobo u chꞌooala, tuchꞌ vinan u Xhep utz, tuchꞌ u Salomee. Nichkoꞌxhmotxisajin kꞌasuꞌl tzian. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Aꞌ qꞌu ixoj nichiloch u Jesuus aas atich tu Galilea. Utz sibꞌal tereꞌn ixoj atich majte qꞌuꞌl xamich tiꞌ u Jesuus, opon tiꞌ tu Jerusaleen. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Uncheeꞌ siꞌchtekxeꞌt u ilanbꞌal qꞌii. Nichxeꞌtisotz saj. Aꞌ chit nichibꞌankeꞌl tuch qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Aatz maꞌl u jikomla vinaj, Xhep ibꞌii aa Arimatea, bꞌenoꞌk xeꞌ u Pilato. Utz yeꞌk ixoꞌval ijaj vichiꞌl u Jesuus te. Atich ok u Xhep xoꞌl qꞌu qꞌesal tenam. Antu nichchꞌian u tulebꞌal viQꞌesalail u Tioxh majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Sotzel ikꞌuꞌl u Pilato aas tabꞌi maꞌtich tel ikꞌuꞌl u Jesuus. Ech isikꞌle ul u qꞌesal sol, tabꞌi te nojchixh kamya. Utz jankꞌalich ikameꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Utz ech tal u qꞌesal sol tu u Pilato aas nojchit maꞌtich ikam u Jesuus. Ech taqꞌ tek vichiꞌl tu u Xhep. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Iloqꞌ tek maꞌl bꞌaꞌnla bꞌuꞌj u Xhep. Utz ex tiqꞌo kuꞌl vichiꞌl u Jesuus vatz kurus. Ibꞌach ok tu u bꞌuꞌj. Utz ex toksa tu maꞌl u mujbꞌal tu sivan vatz peepu bꞌanichnale. Utz toksaka vaꞌt sivan, jupibꞌ itziꞌ u jul. ");
INSERT INTO ixlCNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Aatz u Liꞌ aa Magdala, tuchꞌ u Liꞌ vinan u Xhep, nichisaji bꞌaꞌnil til vaꞌl aqꞌlikka vichiꞌl u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Uncheeꞌ taꞌxh paal u ilanbꞌal qꞌii, aatz u Liꞌ aa Magdala, tuchꞌ u Salomee, tuchꞌ u Liꞌ vinan u Jacobo, motx iloqꞌ txꞌumqꞌixsabꞌal satoksa tiꞌ vichiꞌl u Jesuus tuul tala. ");
INSERT INTO ixlCNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Utz tiira kuꞌsaj, anal nichitoop qꞌii tu u bꞌaxa qꞌii tetz u xhemaana, motx bꞌen qꞌu ixoj tu u mujbꞌal tetz u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Utz nichmotxtal sivatzaj ech tzaꞌ: —¿Abꞌil chaj bꞌoj laeesan u sivan, jupibꞌ itziꞌ u mujbꞌal atziꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pek taꞌxh motx oponi, aꞌ tek tila aas maꞌtich teesal u mam sivan tziꞌ u mujbꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Yakich motx okoꞌp tuul. Utz aꞌ tek til maꞌl u xiak kꞌujlich tu sebꞌal. Chelkin saj oksaꞌm atich ok taqꞌo. Utz yakich motx xoꞌvoj. ");
INSERT INTO ixlCNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pek alax te tu u xiak ech tzaꞌ: —Yeꞌ koꞌxh xoꞌvex. ¿Aꞌ tzik nechok u Jesuus aa Nazareet vaꞌl aqꞌax jeꞌ vatz kurus? Yeꞌkan tzaꞌ. ¡Qꞌaav itzꞌpi tikaꞌpaj! Sajitaj vaꞌl aqꞌaxkuka vichiꞌl etileꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Pek aatz cheel, bꞌenoj etal tu u Luꞌ tuchꞌ tu qꞌul ichusulibꞌ, aas bꞌaxabꞌyu bꞌen sevatz tu Galilea. Utz aꞌ setilvu tziꞌ, echaꞌ vaꞌl alelnalka sete taqꞌo.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ech atiyeꞌka chit kꞌasuꞌl qꞌu ixoj tziꞌ u mujbꞌal tziꞌ tan, techalich motx itꞌuntꞌuꞌlan tu xoꞌval. Loqꞌ yeꞌxhabꞌil maꞌj e talva tan, techalich motx ixoꞌveꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Aatz qꞌaav itzꞌpu u Jesuus qꞌalaꞌm, tu u bꞌaxa qꞌii tetz u xhemaana, aꞌ chit bꞌaxa ilon u Liꞌ aa Magdala, vaꞌl eesal jujvaꞌl tioxhil txꞌiꞌliꞌinaj kꞌatza tu u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ech aatz u Liꞌ, ex tal u yol tu qꞌuꞌl xambꞌu tiꞌ u Jesuus. Tan vaꞌlich motx itxumuneꞌ utz, nichmotxtoqꞌeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ech kꞌuxh motx tabꞌi aas itzꞌlel u Jesuus utz, maꞌt tilax tu u Liꞌ, yeꞌt koꞌn motx inima. ");
INSERT INTO ixlCNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pek xamtich paj tuul ilax u Jesuus tu kaꞌvaꞌl qꞌu chusulibꞌ. Aꞌ chit atich ok tiꞌ maꞌl u bꞌey maꞌt jaꞌjtzeꞌ. Loqꞌ ijal tiloneꞌ aas chee siatz. ");
INSERT INTO ixlCNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ech motx paj qꞌaav qꞌu vinaj tziꞌ; ex tal tu tereꞌn qꞌul imol. Pek yeꞌt koꞌn paj nimal majte. ");
INSERT INTO ixlCNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Uncheeꞌ tiyaꞌtebꞌal tekuꞌen, aꞌ tek cheek vatz junlaal qꞌu chusulibꞌ. Aꞌ chit kꞌujlich ok vatz meexha. Utz yaal tu u Jesuus tan, yeꞌt koꞌn motx inima qꞌuꞌl ilon aas maꞌt qꞌaav titzꞌpeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ech aatz u Jesuus tan, tal te ech tzaꞌ: —Bꞌenojex tu u vatz amlika txꞌavaꞌ kajayil. Utz paxsataj itziiul u bꞌaꞌnla chusbꞌal tu kajay aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ech abꞌil lanimani utz, libꞌan ivautiismo tu aꞌ, sachitpu tu vipaav. Pek abꞌil yeꞌ laniman tan, saꞌalax ikuꞌ u choobꞌal paav tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Utz aꞌ qꞌu xheenya siꞌan qꞌuꞌl saniman u Tioxh tzaꞌ: satojcha el tioxhil txꞌiꞌliꞌinaj tu vunbꞌii utz, sayolon tunjot akꞌ yolbꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kꞌuxh samotxitxay txꞌiꞌla txokop tiqꞌabꞌ utz, kꞌuxh satukꞌa veneno, yeꞌxhkam siꞌan taqꞌo. Sataqꞌ jeꞌ iqꞌabꞌ tibꞌa yaꞌv utz, siꞌan bꞌaꞌn u yaꞌv taqꞌo.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Uncheeꞌ taꞌxh veet yolon u kuBꞌaal Jesuus, iqꞌol jeꞌ tu Amlika. Utz chꞌuxheꞌ tisebꞌal u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ech bꞌen qꞌu chusulibꞌ. Til chaj koꞌxh motx ex ipaxsav paal u yolbꞌal Tioxh. Utz aꞌ chit imol u kuBꞌaal tan, kaana txaichil nichiꞌaneꞌ. Ech nichikꞌucheꞌ aas aꞌ vinujul vaꞌl nichmotxtaleꞌ. Aꞌi.");
INSERT INTO ixlCNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Sibꞌax koꞌxh aanima motx tzꞌibꞌan qꞌu kam qꞌuꞌl nojchit uchnaj tu kuxoꞌl. Tziꞌtzoch talax niꞌaneꞌ, ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","kam chit echaꞌ talax qe iꞌan qꞌuꞌl ilon tixeꞌtebꞌal. Tan antu motx alon paal u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Pek aatz cheel bꞌaꞌnla vinaj Teoofilo, vetvitzꞌa majte aas bꞌaꞌn tziꞌtzoch itzꞌibꞌal talax qꞌu kam sunbꞌan see tziꞌ. Tan maꞌxh unchokl inujul bꞌaꞌnil. Kuentachitꞌin tiꞌ ichꞌotileꞌ aas kam qꞌu kam qꞌuꞌl uch tixeꞌtebꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ech sootzaji vinujul qꞌu kam bꞌaꞌnil qꞌuꞌl chusel see. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Uncheeꞌ aatz iꞌana, aas atich ok u Herodes tu ijlenalil tikuenta Judea, atich maꞌl u oksan yol vatz Tioxh, Zacarias ibꞌii. Aꞌ atichk ok xoꞌl untanul qꞌu oksan yol vatz Tioxh qꞌuꞌl “Abias” chu teꞌleꞌ. Atich tixoj u Zacarias tziꞌ; Xheꞌp ibꞌii, ituꞌxh ixalam u Aroon. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Utz tiira jikomich tatin vatz Tioxh sikaꞌbꞌil. Yeꞌxhkam nichiyolpu tiꞌ inimal qꞌul imantaar u kuBꞌaals Amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pek jolol yeꞌkich initxaꞌa. Tan yeꞌ nichtitzꞌnan u Xheꞌp. Utz sibꞌich tek iyaꞌbꞌ sikaꞌbꞌil. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Uncheeꞌ aatz atich ok u Zacarias titurno tiꞌ toksal yol vatz Tioxh tuchꞌ qꞌul imol, ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","kavaal kuꞌ tiꞌ u Zacarias tziꞌ aas aꞌ sabꞌenoꞌk tu tuul u totztioxh vatz u kuBꞌaals Amlika tiꞌ en ikꞌachax u kaxhlaan pom. Tan ech u kostuumbre nichibꞌanaxeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ech tuul nichitzꞌeꞌ u kaxhlaan pom, nichiqꞌila sikꞌle Tioxh qꞌu mam tenam qꞌanal. Tan echich u oora nitzꞌeꞌsal u kaxhlaan pom vatz Tioxh jun qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Utz chee maꞌl viaanjel u kuBꞌaals Amlika vatz u Zacarias. Txakeꞌ tisebꞌal u nachbꞌal Tioxh tu vaꞌl nikꞌachlik u kaxhlaan pom. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ech taꞌxh til u aanjel u Zacarias, yakich sotzoj ikꞌuꞌl. Utz techalich tek ixoꞌveꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pek aatz u aanjel, tal te ech tzaꞌ: —Zacarias, yeꞌ koꞌxh xoꞌvaxh. Tan vettabꞌilaxh u Tioxh tiꞌ vaqꞌilat asikꞌletaꞌ. Ech aatz u Xheꞌp, val iixoj, sachee maꞌl tal titzꞌin. Utz Xhan ibꞌii looksa. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ech sachiꞌbꞌaxh, satxuqꞌtxunaxh. Utz sibꞌal aanima satxuqꞌtxun tiꞌ u titzꞌpebꞌal majte. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tan sibꞌ tatin vatz Tioxh siꞌaneꞌ. Yitꞌ saꞌkojtukꞌa txꞌamla taꞌl uuva tuchꞌ qꞌabꞌansabꞌal. Pek aꞌ saok u Tioxhla Espiiritu kꞌatza bꞌaꞌnil tuul ankoꞌxh atil tu tuul vinan. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Utz sibꞌal qꞌu Israeel saok kꞌatz u kuBꞌaals Amlika taqꞌo. Ayaꞌ viTioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ech sabꞌaxabꞌ vatz u Tioxh. Utz ech tijleꞌm, ech itxumbꞌal u Elias siꞌaneꞌ, u alol tetz u yolbꞌal Tioxh. Tan saok ibꞌaꞌn qꞌu txutxa bꞌaala tuchꞌ qꞌul ikꞌaol imeꞌal taqꞌo. Utz saok qꞌu qelol tu jik taqꞌo. Sinima vitxumbꞌal qꞌuꞌl jikom. Ech sichꞌiansa maꞌl tenam aas nojchit tiira ayaꞌl ikꞌuꞌl tiꞌ u kuBꞌaals Amlika.— Texh u aanjel. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ech tal tek u Zacarias tu u aanjel ech tzaꞌ: —¿Kam techlal aas satiqꞌo tibꞌ u kam naaleꞌ tziꞌ? Tan in tek qꞌes utz, qꞌestu u vixoj majte.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tzaqꞌbꞌu u aanjel utz, tal te ech tzaꞌ: —In Kap. Bꞌenamen atilin vatz u Tioxh. Utz vetichajin tiꞌ talax u bꞌaꞌnla yol see tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pek yeꞌn koꞌn anima. Ech aatz cheel, samemtꞌaxh. Utz yeꞌkan satxꞌol yol. Analen sayolonaxh aas latiqꞌo tibꞌ u kam tziꞌ tan, yeꞌn koꞌn anima vunyol vaꞌl nojchit satzojpu titiempoil.— Texh u aanjel. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tuul aatz qꞌu tenam tan, nichmotxichꞌia teluꞌl u Zacarias. Utz nichtekmotxisotz ikꞌuꞌl tan, yeꞌxh nichteluꞌl tu u totztioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ech aatz eluꞌl u Zacarias, yeꞌ nichitxꞌol veꞌt yol. Tu xheenya texh nichiqꞌilav qꞌu aanima. Tan memich tekuꞌen. Ech motx el itxumbꞌal qꞌu aanima tuul aas visioon til tu u totztioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Utz taꞌxh tzojpu u taqꞌon vatz Tioxh, bꞌen tek tu tatibꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Uncheeꞌ xamtich tek tiꞌ qꞌu qꞌii tziꞌ, iꞌan tek tiichajla yaabꞌil u Xheꞌp, u tixoj u Zacarias. Utz oꞌvaꞌl ichꞌ atich koꞌxh tu atibꞌal. Yeꞌxhat nichelka. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Utz tal ech tzaꞌ: —¡Ech vuntzaqꞌbꞌel vetiꞌan u kuBꞌaal atziꞌ! Yaꞌy tek tel unqꞌii xoꞌl qꞌu aanima. Tan saꞌtekatin vitzꞌin.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Uncheeꞌ taꞌxh el vaajil ichꞌ tuul, chajax paj bꞌen u Kap viaanjel u Tioxh, tu maꞌl u tenam Nazareet tikuenta Galilea. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Opon xeꞌ maꞌl u ixviak yeꞌ tootzaj vinaj, Liꞌ ibꞌii. Oknajich maꞌl u xiak tiꞌ, Xhep ibꞌii, ituꞌxh ixalam u Daviid. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ech taꞌxh okoꞌp u aanjel tu vaꞌl atichku u Liꞌ, tal te ech tzaꞌ: —Cheentzikꞌaxh ixviak. Atil u kuBꞌaal sakꞌatza. Utz chiꞌbꞌebꞌal eetz vatz tereꞌn qꞌu ixoj. Tan vetitzꞌal maꞌl bꞌaꞌnil u Tioxh saiꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Pek taꞌxh tabꞌi u yol u Liꞌ tziꞌ, xaan taanima taqꞌo. Utz nichtektitzꞌa aas kan chaj tokeꞌ ech alax te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ech aatz u aanjel, tal te ech tzaꞌ: —Liꞌ yeꞌ koꞌxh xoꞌvaxh tan, vetitzꞌal maꞌl bꞌaꞌnil u Tioxh saiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ech saꞌan tiichajla yaabꞌil. Sachee maꞌl iitzꞌin, tal xiak. Utz Jesuus ibꞌii looksa. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tan techal talcheꞌ siꞌaneꞌ. IKꞌaol u Tꞌankin Tioxh saꞌalchi. Tan ijlenal saꞌaqꞌaxku bꞌen tu u Tioxh u kuBꞌaals Amlika, echaꞌ u tijleꞌm u Daviid tan, ikꞌuy imam. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Utz bꞌenamen saꞌatin tu viQꞌesalail xoꞌl qꞌul ituꞌxh ixalam u Jacoob. Yeꞌk iyaꞌebꞌal viQꞌesalail siꞌaneꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ech aatz u Liꞌ tan, tal tek tu u aanjel ech tzaꞌ: —¿Kam tokeꞌ tan, aal yeꞌ vootzaj vinaj?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Tzaqꞌbꞌel tu u aanjel ech tzaꞌ: —U Tioxhla Espiiritu suꞌul saiꞌ utz, visulich u tijleꞌm u Tꞌankin Tioxh sakuꞌ saiꞌ. Ech tokeꞌ xaannaj el kꞌatz paav u tal nitxaꞌ vaꞌl saitzꞌeꞌi. Utz iKꞌaol Tioxh siꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Tan echaꞌ val iitzꞌin aatzik u Xheꞌp, vaꞌl yeꞌ nititzꞌnaneꞌ chu teꞌleꞌ, sachee maꞌl titzꞌin majte, kꞌuxh qꞌeste. Vaajix ichꞌ tatin tu tiichajla yaabꞌil. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tan kam koj yeꞌ saveet vatz u Tioxh.— Texh u aanjel. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ech tal tek u Liꞌ ech tzaꞌ: —Aꞌtzii. Uchoj sunkꞌatza vaꞌl naaleꞌ tziꞌ. Txꞌajaꞌm koꞌxh vetz tan, atilin tiqꞌabꞌ u kuBꞌaals Amlika.— Texhtuꞌ. Ech eltekbꞌen u aanjel siatz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Uncheeꞌ aatz iꞌan tu qꞌu qꞌii tziꞌ, oojeꞌl chit ibꞌen u Liꞌ, bꞌen tu maꞌl u tenam tikuenta Judea xoꞌlaj muunte. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Utz opon tu totzotz u Zacarias. Ech tal ichajlichil u Xheꞌp. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Pek taꞌxh tabꞌi u Xheꞌp u chajlichil, yakich yuqꞌuꞌpanoj u tal nitxaꞌ vaꞌl atich kꞌatza. Ech ok u Tioxhla Espiiritu kꞌatza bꞌaꞌnil. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ech qetun taltu u Xheꞌp ech tzaꞌ: —Chiꞌbꞌebꞌal eetz vatz tereꞌn qꞌu ixoj. Utz chiꞌbꞌebꞌal tetz val iitzꞌin vaꞌl saala. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Kam vijleꞌm aas nuꞌlaqꞌilaꞌin tan, axh inan vunBꞌaal? ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Tan taꞌxh vetvabꞌi vetaal unchajlichil, yakich vetyuqꞌuꞌpanoj u tal nitxaꞌ sunkꞌatza tu txuqꞌtxunchil. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ech techal axh tan, nimanyaxh aas saꞌnaltzojpi kam vaꞌl vettallu u kuBꞌaals Amlika see.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Aatz u Liꞌ tan, tal tek ech tzaꞌ: —Nuntꞌanbꞌaꞌ vunBꞌaals Amlika tu vaanxelal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Utz nitxuqꞌtxun vaanima tiꞌ vunTioxh u Chitol vetz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Tan vettillin u Tioxh aas in niman tetz. Ech chiꞌbꞌebꞌal vetz satal kajay qꞌu aanima qꞌuꞌl saꞌatin taabꞌaꞌbꞌen. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tan sibꞌ mamaj bꞌaꞌnil vetiꞌanlu u Mam Tioxh sunkꞌatza. Techal vibꞌii tan, tzian kꞌatz paav. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tan ibꞌenaꞌ ibꞌen koꞌxh vitxumt iatz qꞌu aanima qꞌuꞌl atil tatin u Tioxh siatz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Mamala chaj kam bꞌanel taqꞌo. Sotzsamal ikꞌuꞌl qꞌu aanima taqꞌo qꞌuꞌl tꞌeꞌsunibꞌ tiꞌ qꞌu kam nititzꞌa tu taanima. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Bꞌajel el taqꞌo qꞌu jeꞌsanibꞌ qꞌuꞌl atil mamaj tijleꞌm. Utz tꞌanbꞌaꞌmal taqꞌo qꞌuꞌl yitꞌ jeꞌsanibꞌ koj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tzꞌajel iatz tetz taqꞌo qꞌuꞌl nivaꞌyeꞌ. Utz maalieꞌl tetz qꞌu txꞌiiol iqꞌii taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Lochel vitenam taqꞌo, qꞌu niman tetz, ayaꞌ oꞌ Israeel. Aꞌ nitzojpi vaꞌl tala aas saꞌchititxum kuvatz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Tan ech vaꞌl alel nal tu u kukꞌuy kumam Abrahaam taqꞌo, tuchꞌ tu qꞌul ituꞌxh ixalam yeꞌk iyaꞌebꞌal.— Texh u Liꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Utz kamal oxvaꞌl ichꞌ iꞌan u Liꞌ xeꞌ u Xheꞌp. Ech qꞌaavtekbꞌen tu tatibꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Uncheeꞌ aatz tek tzꞌaj u tiempo aas sachee u titzꞌin u Xheꞌp, itzꞌpu maꞌl tal titzꞌin, xiak. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Utz motx chit txuqꞌtxun qꞌu titzꞌin tatzik tuchꞌ qꞌu tetz tzꞌalol aas tabꞌi u mam bꞌaꞌnil iꞌan u Tioxh kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Utz aatz tek tzꞌaj vaaxajil qꞌii titzꞌpeꞌ, motx tiqꞌo bꞌen u tal nitxaꞌ tu viqꞌanalil u totztioxh, tiꞌ satzokꞌax el bꞌiil ichiꞌl. Utz aꞌ siꞌchtaqꞌvu bꞌen sichꞌexel vitat. Zacarias ibꞌii siꞌchiꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pek tal vinan u tal nitxaꞌ ech tzaꞌ: —Yeꞌka, Xhan ibꞌii soꞌoki atziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Utz ech alax te tzaꞌ: —¿Kam tokeꞌ tan, keꞌch koj maꞌj iitzꞌin aatzik aas ech ibꞌii tziꞌ?— Texh qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Uncheeꞌ bꞌanax tek xheenya tu vitat. Chꞌotil te aas kam ibꞌii isaꞌ satoksa. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ech ijajtu maꞌl tal aqꞌen u Zacarias. Utz itzꞌibꞌa kuꞌ siatz ech tzaꞌ: —Xhan ibꞌii atziꞌ.— Texhtuꞌ. Ech kajay qꞌu aanima nichtexhisotz ikꞌuꞌl taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Utz tu koꞌxh u muꞌkꞌul tziꞌ, yakich tepaj itxꞌol yol u Zacarias. Aꞌ bꞌaxa toksa iqꞌii u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Yakich xoꞌvoj qꞌu tetz tzꞌalol. Utz pax chit itziiul qꞌu kam vatz qꞌu aanima tziꞌ qꞌuꞌl jejlel tulaj muunte tikuenta Judea. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Aatz kajay qꞌu aanima qꞌuꞌl abꞌin, nichtekipensaarin taqꞌo. Utz nichtal ech tzaꞌ: —¿Kam tek tijleꞌm u tal xiak siꞌaneꞌ nitaleꞌ tziꞌ?— Chia. Tan Tioxh chit atil kꞌatz u tal nitxaꞌ tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Aatz u Zacarias, vitat u tal nitxaꞌ, ok u Tioxhla Espiiritu kꞌatza bꞌaꞌnil. Ech tal unjolol yol taqꞌo ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Techal u kuBꞌaals Amlika, u kuTioxh oꞌ Israeel. Tan vetꞌuliqꞌilaloꞌ, oꞌ itenam; vetꞌulteesaloꞌ tu tzaꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Vettaqꞌluꞌl maꞌl Mam Chitol qetz, maꞌl ituꞌxh ixalam u Daviid, u niman tetz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kam chit echaꞌ vaꞌl alel nal taqꞌo titziꞌ qꞌu alol tetz viyolbꞌal koꞌxtene qꞌuꞌl txaael el taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Tala aas aꞌ saeesanoꞌ vatz qꞌu kukoontra utz, vatz qꞌuꞌl nichiꞌnaꞌn ikꞌuꞌl qiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Tala aas saꞌchititxum kuvatz. Ech sitzojpixsa viyol iꞌan tu u tioxhla nukꞌuꞌm alel nal taqꞌo tu qꞌu kukꞌuy kumam. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tan aꞌ vaꞌl talaꞌtziꞌi tu u Abrahaam u kukꞌuy kumam. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Silochꞌoꞌ tala. Saeloꞌ vatz qꞌu kukoontra taqꞌo. Ech yeꞌk kuxoꞌval sakunima saqoksa. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Sakubꞌan vijikomal siatz. Utz xaannajeloꞌ kꞌatz paav sakubꞌaneꞌ jatvaꞌl vatz kuqꞌii kusaj saꞌatini. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Pek aatz axh tal neꞌ tan, axh alol tetz viyol u Tꞌankin Tioxh siꞌaneꞌ. Sabꞌaxabꞌaxh vatz u kuBꞌaal. Seꞌnapaxsa itziiul u tulebꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ech satabꞌi vitenam aas saꞌatin chitpichil tu paav, saꞌatin kuybꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ech tu vimam bꞌaꞌnil nitxum kuvatz u Tioxh, kꞌuxh nitaqꞌuꞌl maꞌl u txijtxubꞌal quxeꞌ vaꞌl aꞌ vetkꞌaskuꞌl tu Amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ech sitxijtxu qꞌuꞌl atil tu elqꞌej tuchꞌ qꞌuꞌl atil texh ok vatz kamchil. Ech sitxijtxu kubꞌey, bꞌey tetz u paas sukuvatzaj.— Texh u Zacarias. ");
INSERT INTO ixlCNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Uncheeꞌ aatz u tal xiak, chꞌiichil chit nichiꞌaneꞌ. Yakꞌinchil chit niꞌan itxumbꞌal kꞌatz Tioxh. Aatz chꞌii tekuꞌen, aꞌ atinku tu u tzꞌinlich tzaji txꞌavaꞌ. Anal kꞌasuꞌl tziꞌ aas xeꞌt ul tal u yolbꞌal Tioxh xoꞌl qꞌu Israeel. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Uncheeꞌ aatz iꞌan tu qꞌu qꞌii tziꞌ, teesa maꞌl u mantaar u ijlenal Augusto Cesar aas kajay qꞌu aanima seꞌel tachul. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Aꞌ chit bꞌaxa tel u tachul tziꞌ, aas governadoorich u Cireenio tikuenta Siiria. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ech kajay aanima nichentaqꞌ tibꞌ tzꞌibꞌaloj tu qꞌul itenam itzꞌpinajka. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ech kꞌasuꞌl u Xhep tu Nazareet tikuenta Galilea. Utz bꞌen tu vitenam Beleen tikuenta Judea, vaꞌl itzꞌeꞌk u Daviid. Tan axhibꞌi ituꞌxh ixalamich. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ech ex taqꞌ tibꞌ tzꞌibꞌaloj tziꞌ. Aꞌich imol u Liꞌ, u tixoj. Utz atich tu tiichajla yaabꞌil. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ech tuul atich tziꞌ, opon u qꞌii aas saꞌtekatin u titzꞌin. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ech itzꞌpu u bꞌaxa titzꞌin. Ibꞌach tu bꞌuꞌj utz, taqꞌ kuꞌ tu maꞌl u jukubꞌ. Tan yeꞌt motx chee veꞌt tatibꞌal tu vatbꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Uncheeꞌ atich unjolol xeen karneꞌl tu maꞌl u jaꞌjtzeꞌ ankoꞌxh tikuenta u txꞌavaꞌ tziꞌ. Nichixee ikarneꞌl tu aqꞌbꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Utz chee maꞌl viaanjel u kuBꞌaals Amlika siatz. Utz yakich sutiloj tiꞌ qꞌu xeen karneꞌl tu vipaqꞌun vitechalil u kuBꞌaals Amlika. Ech motx xoꞌvi. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pek aatz u aanjel tan, tal te ech tzaꞌ: —Yeꞌ koꞌxh xoꞌvex. Tan bꞌaꞌnla yol saval sete. Sitxuqꞌtxunsa tenam kajayil. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tan aatz cheel, itzꞌpi tu u Beleen vitenam u Daviid, u Chitol etetz; ayaꞌ kuBꞌaal, viTxaaom u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Utz aꞌ u xheenya tzaꞌ aas aꞌ i. Sechabꞌa maꞌl u tal nitxaꞌ bꞌachel tu bꞌuꞌj. Utz atil kuꞌ tu maꞌl jukubꞌ.— Texh u aanjel. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Utz yeꞌk talcheꞌ chee sibꞌat aanjel kꞌatz u aanjel tziꞌ. Aꞌ kꞌaskuꞌl tu Amlika. Utz nichtoksa iqꞌii u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Nichtal ech tzaꞌ: —Techal u Tioxh tu Amlika. Utz atoj paas tu taanima qꞌu aanima vatz txꞌavaꞌ qꞌuꞌl satxuqꞌtxun tu u tok ibꞌaꞌn tuchꞌ u Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ech taꞌxh bꞌenjeꞌ qꞌu aanjel tu Amlika, tal tek qꞌu xeen karneꞌl tibꞌilaj ech tzaꞌ: —¡Koꞌtaj tu Beleen! Utz saqileꞌ kam vaꞌl uchya vaꞌl vettallu u kuBꞌaal qe.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ech oojeꞌl chit motx ibꞌenaꞌ. Utz taꞌxh oponi, til u tal neꞌ atich kuꞌ tu jukubꞌ. Atich u Liꞌ kꞌatza tuchꞌ u Xhep. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ech motx tek tala kam vaꞌl maꞌtich talax te tu u aanjel tiꞌ u tal neꞌ tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ech tzꞌejx ikꞌuꞌl kajay qꞌu aanima tiꞌ vaꞌl tal qꞌu xeen karneꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pek aatz u Liꞌ tan, nichkoꞌntitzꞌa qꞌu kam tziꞌ. Utz nichkoꞌnikol tu taanima. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ech qꞌaavkꞌasuꞌl qꞌu xeen karneꞌl tziꞌ. Utz vaꞌlich motx toksat iqꞌii u Tioxh tiꞌ qꞌu kam tila tabꞌi. Tan ech chit elka vaꞌl alax te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Aatz tzꞌaj vaaxajil qꞌii titzꞌpu u tal nitxaꞌ, tzokꞌax el bꞌiil ichiꞌl. Ech oksal ibꞌii. Jesuus bꞌii oki; kam chit echaꞌ vaꞌl tal u aanjel aas yeꞌsajenich ichee kꞌatz vinan. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Utz taꞌxh tzꞌaj qꞌu qꞌii tiꞌ ibꞌanax u kostuumbre tetz txꞌaatxꞌochil vaꞌl nital u oꞌtla mantaar, motx bꞌen tu Jerusaleen. Ech toksa u tal nitxaꞌ vatz u kuBꞌaal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Motx iꞌana kam chit echaꞌ vaꞌl tzꞌibꞌamalka tu u oꞌtla mantaar vaꞌl tal u Tioxh ech tzaꞌ: —Kajay bꞌaxa nitxaꞌ xiak sabꞌens tetz u Tioxh.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ech motx toksat u txꞌoloꞌm vaꞌl nital u oꞌtla mantaar ech tzaꞌ: —Untzumul muꞌkuy oj kaꞌvaꞌl txul paroomaxh.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ech atich maꞌl u vinaj tu Jerusaleen, Xhim ibꞌii. Jikomla vinaj vatz Tioxh. Tiira nachol Tioxh. Nojchit atich u Tioxhla Espiiritu kꞌatza. Utz nichichꞌia u tulebꞌal u lochol tetz qꞌu Israeel. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Tan maꞌtich nal itꞌoyax tu u Tioxhla Espiiritu aas yitꞌ saꞌkojkami untzꞌoj yeꞌsajen tiltu viTxaaom u kuBꞌaals Amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ech tꞌokax taanima u Xhim tu u Tioxhla Espiiritu aas sabꞌen tu viqꞌanalil u totztioxh. Utz tiempo opon qꞌul itxutx ibꞌaal u Jesuus tziꞌ majte tiꞌ toksal u kostuumbre echaꞌ vaꞌl nital u oꞌtla mantaar. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ech aatz u Xhim, ijele u tal nitxaꞌ. Utz toksa iqꞌii u Tioxh ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—Aatz cheel unBꞌaal, saꞌtekiꞌaneꞌ sakamin saaqꞌo; vaꞌl tachavan unkam sakamin. Tan nojpi vayol alel. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Tan vetvillu tuchꞌ unvatz u Chitol tu tzaꞌl, ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","vaꞌl vetaaqꞌuꞌl vatz qꞌu tenam kajayil. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Txijtxun ibꞌey qꞌu puera aanima tiꞌ tootzajitꞌaxh. Ech soꞌok iqꞌii vatenam Israeel taqꞌo.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ech aatz u Xhep tuchꞌ u Liꞌ, vinan u Jesuus, nichtexhitzꞌejx ikꞌuꞌl tiꞌ qꞌu yol nichtal tiꞌ u tal nitxaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ech tal bꞌaꞌnla yol u Xhim tiꞌ majte. Tal tu u Liꞌ ech tzaꞌ: —Sibꞌal aanima sasotz ikꞌuꞌl tu u xheenya tiꞌ u tal nitxaꞌ tzaꞌ. Sibꞌal silak tibꞌ taqꞌo tu u Israeel tzaꞌ majte. Utz sibꞌal aanima sitxay tibꞌ tu yol tiꞌ viTxaaom u Tioxh tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ech saeluꞌl vatzsaj kam nititzꞌa taanima junun aanima tiꞌ. Pek aatz axh, sakꞌaxbꞌu avaanima tu vaꞌl sabꞌanax te. Ayaꞌl chituꞌ aꞌ maꞌj chꞌichꞌ sapaal tavaanima sanacheꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Utz atich paj vaꞌt u ixoj tziꞌ majte, An ibꞌii. Alolich yol tetz u Tioxh. Imeꞌal u Fanueel, ituꞌxh ixalam u Aseer. Tiira qꞌestich tekuꞌen. Utz txakay ixojich. Jujvaꞌl koꞌxh yaꞌbꞌ iꞌan tuchꞌ vivinaj aas maꞌtich itzumeꞌaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Utz 84 iyaꞌbꞌ. Ech bꞌenamen nichtopon tu viqꞌanalil u totztioxh. Aꞌ chit nichikꞌula inachax Tioxh qꞌiils aqꞌbꞌal. Nichikuy ivaꞌy tiꞌ iqꞌilal isikꞌlel Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ech tiempo chit opon u An tu viqꞌanalil u totztioxh tuul atich u tal nitxaꞌ tziꞌ. Vaꞌlich ikꞌamabꞌet Tioxh u An tiꞌ. Utz nichiyolon tiꞌ tu qꞌu aanima majte qꞌuꞌl nichchꞌian u tulebꞌal u Chitol tetz qꞌu aa Jerusaleen. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Uncheeꞌ aatz tek maꞌtich itzojpit u Xhep tuchꞌ u Liꞌ vimantaar u kuBꞌaals Amlika, motx tek qꞌaavbꞌen tu Nazareet tikuenta Galilea. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ech chꞌiichil techit nichiꞌan u tal nitxaꞌ. Yakꞌinchil chit nichiꞌaneꞌ. Cheechil chit nichiꞌan itxumbꞌal. Utz atich chit ibꞌaꞌnil u Tioxh tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Utz aatz qꞌul itxutx ibꞌaal u Jesuus, jun chit yaꞌbꞌ nichibꞌenjeꞌ tu u nimla qꞌii tu Jerusaleen. Ayaꞌ vaꞌl nichipaasal tiꞌ u Elchil Vatz Kamchil Tu Egipto. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ech aatz kabꞌlaalich tek iyaꞌbꞌ u Jesuus, motx paj bꞌen tu Jerusaleen. Tan ech nal chit nichmotxiꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Aatz yaꞌ u nimla qꞌii, motx tek kꞌasuꞌl. Pek kaaka u tal Jesuus tu Jerusaleen. Loqꞌ yeꞌich tootzaj u Xhep tuchꞌ u Liꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Kamal atich xoꞌl qꞌu aanima tala. Utz maꞌlich tek qꞌii xaaom maꞌtich iꞌantaꞌ, ech ichok tek xoꞌl qꞌu titzꞌin tatzik tuchꞌ xoꞌl qꞌuꞌl tootzaj tibꞌ tuchꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pek yeꞌt ichabꞌa. Ech motx tek qꞌaavbꞌen tu Jerusaleen tiꞌ ichokaxeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Aatz maꞌtich tek ipaal oxvaꞌl qꞌii ichoktaꞌ, ichabꞌa tek tu viqꞌanalil u totztioxh. Kꞌujlich ok xoꞌl qꞌu qꞌesal ootzajin tetz u oꞌtla mantaar. Nichtabꞌi qꞌul iyol utz, nichꞌoti kam te majte. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ech kajay nichmotxitzꞌejx ikꞌuꞌl tiꞌ vitxumbꞌal u tal Jesuus tziꞌ. Tan aqꞌel iviꞌ utz, telabꞌal tzaqꞌbꞌichil majte. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ech tzꞌejx ikꞌuꞌl qꞌul itxutx ibꞌaal aas tiltaꞌ. Utz tal vinan te ech tzaꞌ: —¡Vitzꞌin, kantuꞌ aas ech naꞌan qe tziꞌ! Tiira il atoꞌkꞌoꞌ tiꞌ achokleꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Uncheeꞌ tal u Jesuus ech tzaꞌ: —¿Kam tokeꞌ nechokꞌin? ¿Yetz etootzaj tzik aas ministeer aꞌ saꞌatinkꞌin tu u taqꞌon vunTat?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pek yeꞌt motx el itxumbꞌal tu u yol tal te tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ech bꞌen tek tiꞌ qꞌul itxutx ibꞌaal utz, qꞌaavkuꞌ tu Nazareet. Utz nimamich chit qꞌul itxutx ibꞌaal taqꞌo. Aatz vinan tan, nichkoꞌnikol kajay qꞌu kam tu taanima tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ech chꞌiichil chit nichiꞌan u Jesuus tu vichiꞌl, tu vitxumbꞌal tuchꞌ tu u bꞌaꞌnil vatz Tioxh utz, vatz aanima majte. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Uncheeꞌ qꞌilal u Xhan vikꞌaol u Zacarias tu u Tioxh tu tzꞌinlich txꞌavaꞌ. Aꞌ chit 15 yaꞌbꞌ tok tu tijlenalil u mam ijlenal Tibeerio Cesar. Utz governadoorich u Pooncio Pilato tikuenta Judea. Governadoorich u Herodes tikuenta Galilea majte. Utz governadoorich u Felipe vitzaꞌqꞌ u Herodes tikuenta Iturea tuchꞌ tu Traconite. Governadoorich u Lisanias tikuenta Abiliinia. Utz aꞌ chit qꞌesal oksan yol vatz Tioxh xoꞌl qꞌu Israeel u Anaas tuchꞌ u Caifaas. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ech aatz u Xhan, xeꞌt ipaxsa itziiul u yolbꞌal Tioxh tikuenta kajay qꞌu txꞌavaꞌ najaꞌch u nimaꞌ Jordaan. Nichtal tu qꞌu aanima aas sikꞌaxa qꞌul ipaav utz; ech sakuyax ipaav. Siꞌan ivautiismo majte, techlal ikꞌaxat qꞌul ipaav. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kam chit echaꞌ vaꞌl tzꞌibꞌamalka tu u Isaias, u alol tetz u yolbꞌal Tioxh, aas tal ech tzaꞌ: —Sajeꞌ iviꞌ tu yol tu tzꞌinlich tzaji txꞌavaꞌ. Satal ech tzaꞌ: «Jikomtixsataj etxumbꞌal vatz u kuBꞌaal, echaꞌ ijikomtixsal bꞌey siatz sebꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Echaꞌ ibꞌuchꞌax tuul kajay qꞌu xoꞌliꞌitz. Ech siꞌan maꞌl iatz qꞌu muunte tuchꞌ qꞌu peepu. Utz soꞌok tijikomal qꞌu koykin bꞌey. Utz sabꞌanax bꞌaꞌn tu u xopkin bꞌey. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ech kajay aanima sailon u chitpichil tu paav vaꞌl siꞌan u Tioxh.» Chaj.— Texh u Isaias. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ech aatz qꞌu aanima nichtopon kꞌatz u Xhan. Aꞌ isaꞌ sabꞌanax vautisaar. Tal u Xhan te ech tzaꞌ: —¡Tiil txꞌiꞌla chaj aanima! ¡Abꞌil koj nichusunex te aas tu koꞌxh vebꞌant evautiismo, setxꞌol etel vatz vikꞌaꞌnal u Tioxh vaꞌl tuleꞌ! ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Pek kꞌuchtaj tu vebꞌanoneꞌ aas nojchit vetekꞌaxal qꞌul epaav. Ech ex sebꞌaneꞌ maꞌl u tzeꞌ vaꞌl txꞌanel ivatzineꞌ. Utz yeꞌ koꞌxh etal tetaanima aas: «Aꞌ kutat u Abrahaam. Kam koj sabꞌanonoꞌ.» Chajkojex. Tan nojchit nival sete, aas yeꞌ koj saveeti aas sabꞌen ikꞌaol Abrahaam qꞌu sivan tu u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tan chꞌiam texh niꞌan vikꞌaꞌnal u Tioxh kꞌatz qꞌuꞌl yeꞌ nikꞌuch u bꞌaꞌnil. Echaꞌ ichꞌiansal u kꞌoxbꞌal tiꞌ itzokꞌpu u tzeꞌ tu taqꞌil. Tan abꞌiste u tzeꞌ vaꞌl yitꞌ bꞌaꞌn koj ivatz siꞌaneꞌ, satzokꞌpi. Utz sakꞌachpu tu xamal.— Texh u Xhan. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ech nichichꞌotil te tu qꞌu aanima ech tzaꞌ: —¿Kam tek sakubꞌaneꞌ uncheeꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tzaqꞌbꞌel tu u Xhan ech tzaꞌ: —Abꞌil kaꞌvaꞌl toksaꞌm atile, taqꞌ tetz vaꞌl yeꞌk tetz. Utz abꞌil atil techbꞌubꞌal, echat koꞌxh siꞌan majte.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Utz antu opon unjolol qꞌu jajol jaꞌmel alkavaar majte. Antu sabꞌanax vautisaar tala. Utz ichꞌoti tu u Xhan ech tzaꞌ: —Chusul aatz oꞌ, ¿kam sakubꞌaneꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tzaqꞌbꞌel tu u Xhan ech tzaꞌ: —Yitꞌ saꞌkojetaqꞌ jeꞌop u jaꞌmel alkavaar. Taꞌxh sejajeꞌ jankꞌal vaꞌl alel sete aas sejajeꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Antu unjolol qꞌu sol chꞌotin te ech tzaꞌ majte: —Utz aatz oꞌ, ¿kam sakubꞌaneꞌ?— Texh te. Utz alax te ech tzaꞌ: —Yeꞌ koꞌxh epoyi aanima. Utz yeꞌ echuli ipaav aanima aas sakoꞌnkoxhexochoꞌk tiꞌ teesal puaj tiꞌ. Pek kuꞌoj ekꞌuꞌl tiꞌ qꞌul ejaꞌmel.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ech nichmotxichꞌian qꞌu aanima. Tan vaꞌl motx ichokon taanima tiꞌ. Tan kamal aꞌ viTxaaom u Tioxh u Xhan nichtaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pek aatz u Xhan, tal te ech tzaꞌ: —Aatz in, nojchit tu koꞌn aꞌ nunbꞌanvu vautisaarex. Pek ech koj vaꞌl tulka viꞌ, tiira paalchu tijleꞌm sunviꞌ. Aal yeꞌk sikꞌuloꞌk viꞌ soꞌokꞌins chitol el ixaabꞌ. Utz aꞌ vaꞌl saoksan u Tioxhla Espiiritu sekꞌatza. Utz satoksaꞌex tu jik tuchꞌ vixamlil. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Utz echaꞌ iqꞌomal chꞌilibꞌ itriigo tiqꞌabꞌ. Ech satam u paqꞌbꞌal el itriigo. Sichꞌili el ichꞌimil vitriigo. Ech simol okoꞌp u triigo tu u tatibꞌal. Pek aatz vichꞌimil, sikꞌachoꞌk tu u xamal vaꞌl yeꞌk iyaꞌeꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ech sibꞌ tereꞌn koꞌxh yol tal tu qꞌu aanima tiꞌ toksal tu jik. Aꞌ nichipaxsa itziiul u bꞌaꞌnla chusbꞌal tu qꞌu tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Pek oksal u Xhan tu tzeꞌ tu u governadoor Herodes. Tan tiira tal u Xhan te aas yeꞌxtxoj iqꞌomal u Herodias taqꞌo, u tixoj u Felipe, vitzaꞌqꞌ u Herodes. Utz tal te majte kam tereꞌn qꞌu kam yeꞌxtxoj nichiꞌaneꞌ. Pek aal koꞌn paj itzꞌajsa ok vipaav u Herodes aas toksat u Xhan tu tzeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Uncheeꞌ sibꞌal aanima bꞌanax vautisaar tu u Xhan. Utz antu u Jesuus iꞌan ivautiismo majte. Utz tuul nichiqꞌila isikꞌle Tioxh u Jesuus tu u vautiismo, jajpu u amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Utz ok u Tioxhla Espiiritu kꞌatza. Echaꞌ paroomaxh kuꞌ tibꞌa. Utz uch kꞌasuꞌl maꞌl u yol tu Amlika tal ech tzaꞌ: —Axh vunKꞌaol vaꞌl tiiꞌin saiꞌ. Utz axh u kꞌujlebꞌal unkꞌuꞌl.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Aatz ixeꞌt u Jesuus tiꞌ talax u bꞌaꞌnla chusbꞌal, kamal 30 iyaꞌbꞌ. Utz ikꞌaol u Xhep nichtalaxeꞌ, ayaꞌ vikꞌaol u Elii. Aatz u Xhep, Elii ibꞌii vitat. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Aatz u Elii, Mataat ibꞌii vitat. Aatz u Mataat, Levii ibꞌii vitat. Aatz u Levii, Melqui ibꞌii vitat. Aatz u Melqui, Jana ibꞌii vitat. Aatz u Jana, Xhep ibꞌii vitat. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Aatz u Xhep, Matatias ibꞌii vitat. Aatz u Matatias, Amoos ibꞌii vitat. Aatz u Amoos, Nahuum ibꞌii vitat. Aatz u Nahuum, Esli ibꞌii vitat. Aatz u Esli, Nagai ibꞌii vitat. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Aatz u Nagai, Maat ibꞌii vitat. Aatz u Maat, Matatias ibꞌii vitat. Aatz u Matatias, Semei ibꞌii vitat. Aatz u Semei, Xhep ibꞌii vitat. Aatz u Xhep, Judaa ibꞌii vitat. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Aatz u Judaa, Joana ibꞌii vitat. Aatz u Joana, Resa ibꞌii vitat. Aatz u Resa, Zorobabeel ibꞌii vitat. Aatz u Zorobabeel, Salatieel ibꞌii vitat. Aatz u Salatieel, Neri ibꞌii vitat. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Aatz u Neri, Melqui ibꞌii vitat. Aatz u Melqui, Adi ibꞌii vitat. Aatz u Adi, Cosaam ibꞌii vitat. Aatz u Cosaam, Elmodaam ibꞌii vitat. Aatz u Elmodaam, Er ibꞌii vitat. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Aatz u Er, Josuee ibꞌii vitat. Aatz u Josuee, Eliezeer ibꞌii vitat. Aatz u Eliezeer, Joriim ibꞌii vitat. Aatz u Joriim, Mataat ibꞌii vitat. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Aatz u Mataat, Levii ibꞌii vitat. Aatz u Levii, Xhim ibꞌii vitat. Aatz u Xhim, Judaa ibꞌii vitat. Aatz u Judaa, Xhep ibꞌii vitat. Aatz u Xhep, Jonaan ibꞌii vitat. Aatz u Jonaan, Eliaquiim ibꞌii vitat. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Aatz u Eliaquiim, Melea ibꞌii vitat. Aatz u Melea, Mainaan ibꞌii vitat. Aatz u Mainaan, Matata ibꞌii vitat. Aatz u Matata, Nataan ibꞌii vitat. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Aatz u Nataan, Daviid ibꞌii vitat. Aatz u Daviid, Isaii ibꞌii vitat. Aatz u Isaii, Obeed ibꞌii vitat. Aatz u Obeed, Booz ibꞌii vitat. Aatz u Booz, Salmoon ibꞌii vitat. Aatz u Salmoon, Nasoon ibꞌii vitat. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aatz u Nasoon, Aminadaab ibꞌii vitat. Aatz u Aminadaab, Araam ibꞌii vitat. Aatz u Araam, Esroom ibꞌii vitat. Aatz u Esroom, Fares ibꞌii vitat. Aatz u Fares, Judaa ibꞌii vitat. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Aatz u Judaa, Jacoob ibꞌii vitat. Aatz u Jacoob, Isaac ibꞌii vitat. Aatz u Isaac, Abrahaam ibꞌii vitat. Aatz u Abrahaam, Taree ibꞌii vitat. Aatz u Taree, Nacoor ibꞌii vitat. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Aatz u Nacoor, Seruug ibꞌii vitat. Aatz u Seruug, Ragau ibꞌii vitat. Aatz u Ragau, Peleeg ibꞌii vitat. Aatz u Peleeg, Hebeer ibꞌii vitat. Aatz u Hebeer, Sala ibꞌii vitat. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Aatz u Sala, Cainaan ibꞌii vitat. Aatz u Cainaan, Arfaxaad ibꞌii vitat. Aatz u Arfaxaad, Sem ibꞌii vitat. Aatz u Sem, Noee ibꞌii vitat. Aatz u Noee, Lameec ibꞌii vitat. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Aatz u Lameec, Matusaleen ibꞌii vitat. Aatz u Matusaleen, Enooc ibꞌii vitat. Aatz u Enooc, Jareed ibꞌii vitat. Aatz u Jareed, Mahalaleel ibꞌii vitat. Aatz u Mahalaleel, Cainaan ibꞌii vitat. ");
INSERT INTO ixlCNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Aatz u Cainaan, Enoos ibꞌii vitat. Aatz u Enoos, Set ibꞌii vitat. Aatz u Set, Adaan ibꞌii vitat. Aatz u Adaan, aꞌ itat u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Uncheeꞌ atich ok u Tioxhla Espiiritu kꞌatz u Jesuus bꞌaꞌnil aas kꞌasuꞌl tziꞌ u nimaꞌ Jordaan. Utz iqꞌol bꞌen tu tzꞌinlich tzaji txꞌavaꞌ tu u Tioxhla Espiiritu. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Utz 40 qꞌii iꞌan latziꞌ. Ech bꞌanax provaal isubꞌax tu u txꞌiꞌliꞌinaj. Utz yeꞌk echbꞌuꞌm iꞌan tu qꞌu qꞌii tziꞌ. Ech aatz tzojpi, vaꞌyi. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ech aatz u txꞌiꞌliꞌinaj, tal te ech tzaꞌ: —Oj nojchit axh iKꞌaol Tioxh, bꞌensas kaxhlaan txꞌix u sivan tziꞌ qabꞌi.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Tzꞌibꞌamalka tu u Yolbꞌal Tioxh aas: «Taꞌn koꞌnkoxh u kaxhlaan txꞌix saitzꞌpixsan qꞌu aanima, pek tu kajay qꞌu yol alel tu u Tioxh majte.» Chia.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ech aatz iꞌan u txꞌiꞌliꞌinaj, tiqꞌo bꞌen u Jesuus viꞌ maꞌl u tꞌankin muunte. Utz tu koꞌxh unmuꞌkꞌul ikꞌuch qꞌu mamaj tenam te tu u vatz txꞌavaꞌ tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ech tal tek u txꞌiꞌliꞌinaj te ech tzaꞌ: —Savaqꞌ kajay qꞌu tenam tu u vatz txꞌavaꞌ see tzaꞌ tuchꞌ qꞌu mamaj txꞌiibꞌal qꞌii tuul. Tan vetz aqꞌel. Utz savaqꞌeꞌ abꞌil e savaqꞌva. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Utz eetz kajayil oj sapecheꞌaxh sunvatz utz, sooksa unqꞌii.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ech tzaqꞌbꞌu u Jesuus tal te ech tzaꞌ: —Elenbꞌen sunvatz, txꞌiꞌliꞌinaj. Tan tzꞌibꞌamalka tu u Yolbꞌal Tioxh ech tzaꞌ: «Taꞌxh u Tioxh, u kuBꞌaals Amlika saoksa iqꞌii. Utz taꞌxh maꞌl sanima.» Chia.— Texh u Jesuus te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ech iqꞌol paj bꞌen u Jesuus tu u txꞌiꞌliꞌinaj tu Jerusaleen. Utz jeꞌop taqꞌo viꞌ maꞌl u tꞌankin ixoobꞌal iqꞌanalil u totztioxh. Utz tal te ech tzaꞌ: —Oj nojchit axh iKꞌaol Tioxh, kꞌon koꞌp iibꞌ tzaꞌ qabꞌi. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tan tzꞌibꞌamalka majte aas: «Atil qꞌu aanjel tetz u Tioxh saiꞌ. Sikolaxh, satilbꞌeꞌaxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Suꞌlikꞌulaxh tiqꞌabꞌ, ech yeꞌk sapaqꞌoꞌk iibꞌ tiꞌ sivan.» Chia.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ech tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Alelka tu u Yolbꞌal Tioxh majte aas: «Sakoꞌnkoxhayaꞌlu u Tioxh u kuBꞌaals Amlika tiꞌ ibꞌanax kam.» Chia.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ech yaꞌ texh u txꞌiꞌliꞌinaj tiꞌ ibꞌanax provaal isubꞌax u Jesuus. Xaan tek el kꞌatza maꞌl tiempo. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Uncheeꞌ qꞌaavopon u Jesuus tu Galilea. Utz tiira atich viyakꞌil u Tioxhla Espiiritu kꞌatza. Utz pax chit itziiul u talchu tikuenta kajay qꞌu txꞌavaꞌ tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ech nichichusun tu qꞌu atibꞌal chusbꞌal tetz u oꞌtla mantaar. Utz techalich toksal iqꞌii tu qꞌu aanima kajayil. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ech bꞌen tu Nazareet majte, tu vaꞌl chꞌiika. Utz bꞌenoꞌk tu u atibꞌal chusbꞌal tetz u oꞌtla mantaar tu u ilanbꞌal qꞌii. Tan ech nal chit nichiꞌaneꞌ. Ech chꞌineꞌi, isikꞌle u Yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tan aqꞌax u uꞌ te tetz u Isaias, u alol tetz u yolbꞌal Tioxh. Ijaj tuul utz, ichabꞌa vaꞌl tzꞌibꞌamichku qꞌu yol nital ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","—Atil u Tioxhla Espiiritu tetz u kuBꞌaals Amlika sunkꞌatza. Tan aꞌ vetoksanin tiꞌ ipaxsal itziiul u bꞌaꞌnla chusbꞌal tu qꞌu meꞌbꞌaꞌ, tiꞌ tulsal ikꞌuꞌl qꞌuꞌl jochpinaj, tiꞌ talax ichajpu qꞌu aanima qꞌuꞌl echaꞌ preexhu tatineꞌ, tiꞌ isajinsal qꞌu moy, tiꞌ teesal qꞌuꞌl atil tu kꞌaxkꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Utz vetichajuꞌlin tiꞌ talax ixeꞌt u Bꞌaꞌnla Yaꞌbꞌ tetz chitpichil vaꞌl siꞌan u kuBꞌaal.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ech ibꞌolqꞌi u uꞌ utz, taqꞌ tu u kolol tetz. Ech kꞌujeꞌi. Utz tii chit nichisajil tu kajay qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Utz xeꞌt tal u Jesuus ech tzaꞌ: —Cheel tzojpi u yol sevatz vaꞌl tzꞌibꞌamal tu u Yolbꞌal Tioxh tzaꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ech bꞌaꞌnich chit iyol kajay aanima tiꞌ. Utz nichmotxitzꞌejx ikꞌuꞌl tu qꞌu bꞌaꞌnla chaj yol qꞌuꞌl nichtaleꞌ. Loqꞌ nichmotxtal tiꞌ ech tzaꞌ: —¿Yitꞌ tzik aꞌ vikꞌaol u Xhep tziꞌ?— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Uncheeꞌ tal u Jesuus te ech tzaꞌ: —Sebꞌanbꞌeꞌin cheel atziꞌ. Toj nal etal maꞌl u yol ve vaꞌl nitaleꞌ: «Aa tzꞌak, tzꞌaka jeꞌ iibꞌ majte.» Chia. «Tan niqabꞌi aas sibꞌal kam vetaꞌan tu Capernauum. Pek bꞌan tu vatenam tzaꞌ majte.» Chajex. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Tan niꞌxhtekꞌval sete aas nikoꞌxh maꞌj alol tetz u yolbꞌal Tioxh bꞌaꞌn koj ikꞌulchu titenam. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Echtzixeꞌt yitꞌ aꞌ koj chajlik u Elias tu u Tioxh xeꞌ maꞌj qꞌu txakay ixoj tu Israeel, tetz aa tenamil. Pek aꞌ chajlik xeꞌ maꞌl u txakay ixoj puera aanima tu Sarepta tikuenta Sidoon, kꞌuxh sibꞌ koꞌxh txakay ixoj atich tikuenta Israeel titiempo u Elias. Aꞌ chituꞌ aꞌ vaꞌl paat yeꞌt kuꞌ jabꞌal tu oxvaꞌl yaꞌbꞌ tuchꞌ vaajit ichꞌ. Utz ul mam vaꞌy tikuenta kajay u txꞌavaꞌ tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ech pajeꞌ u Eliseo, u alol tetz u yolbꞌal Tioxh. Taꞌxh iꞌan bꞌaꞌn te u Namaan, maꞌl u puera aanima tikuenta Siiria, kꞌuxh sibꞌ koꞌxh chꞌaꞌkꞌiꞌ atich tu Israeel majte. Pek nikoꞌxh maꞌj iꞌan bꞌaꞌn te.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Taꞌxh tabꞌi qꞌu kam qꞌu aanima tziꞌ, motx pultu taanima tu kꞌaꞌnal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ech motx lakpi. Motx ipaasa eluꞌl u Jesuus tiꞌ eluꞌl u tenam. Tiqꞌo bꞌen tziꞌ u peepu vaꞌl atichku jeꞌ vitenam tan, siꞌchmotxikꞌon kꞌasuꞌl tziꞌ nichtaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pek paal koꞌn u Jesuus tixoꞌl utz, bꞌeni. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Uncheeꞌ opon u Jesuus tu Capernauum tikuenta Galilea. Utz nichichus qꞌu aanima tu qꞌu ilanbꞌal qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ech nichmotxitzꞌejx ikꞌuꞌl qꞌu aanima tiꞌ vichusbꞌal. Tan nojchit nikꞌucheꞌ aas atil tijleꞌm tu qꞌul iyol. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Utz atich opon maꞌl u vinaj tu u atibꞌal chusbꞌal tetz u oꞌtla mantaar tziꞌ. Atich ok tioxhil txꞌiꞌliꞌinaj kꞌatza. Utz qꞌeqꞌuni, tal ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Aqꞌkaꞌoꞌ Jesuus aa Nazareet! ¿Kam asaꞌ qe? Kꞌuxh ulyaxh tan, aꞌ ul ayoo qatineꞌ. Vootzajle abꞌil axh. Axh viTxaaom u Tioxh yeꞌk paav sakꞌatza.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ech yaal tu u Jesuus tal te ech tzaꞌ: —¡Cha atziꞌ! ¡Elen kꞌatz u vinaj tziꞌ!— Texh te. Aatz u txꞌiꞌliꞌinaj, ibꞌaj tek kuꞌ u vinaj tu xoꞌl. Utz el kꞌatza. Yeꞌxhkam ikꞌaxbꞌixsa. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Utz kajay qꞌu aanima tzꞌejxinajich tek ikꞌuꞌl taqꞌo. Nichmotxtal tibꞌilaj ech tzaꞌ: —¡Aꞌxh bꞌoj qꞌul iyol atziꞌ; tiira aqꞌel iviꞌ! Utz ¡tuchꞌ tijleꞌm tuchꞌ ixamlil Tioxh nitojcheꞌl qꞌu tioxhil txꞌiꞌliꞌinaj tziꞌ utz, yak eloj!— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ech tiira pax itziiul u talchu u Jesuus tikuenta qꞌu txꞌavaꞌ tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Uncheeꞌ kꞌasuꞌl u Jesuus tu u atibꞌal chusbꞌal tetz u oꞌtla mantaar utz, bꞌen tu otzotz xeꞌ u Xhim. Pek yaꞌvich vi-ixoj jiꞌ u Xhim tu maꞌl mam xamal. Ech jajax bꞌaꞌnil tu u Jesuus aas siꞌan bꞌaꞌn te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ech kꞌoꞌeꞌ kuꞌ bꞌiil u Jesuus kꞌatza utz, teesa u xamal kꞌatza. Tu koꞌxh unmuꞌkꞌul lakpi utz, iꞌan tek techbꞌubꞌal qꞌuꞌl atiche. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Aatz tek kuꞌqꞌii, iqꞌol ul kajay qꞌu yaꞌv vatz u Jesuus. Ech nichtaqꞌ jeꞌ iqꞌabꞌ u Jesuus tibꞌa junun qꞌu yaꞌv. Utz nichiꞌan bꞌaꞌn kꞌuxh chukchaj yaabꞌil nichmotxbꞌanon. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nichtel qꞌu tioxhil txꞌiꞌliꞌinaj kꞌatz sibꞌal qꞌu aanima yaꞌv majte. Vaꞌl iqꞌeqꞌun telaꞌ nital ech tzaꞌ: —¡Axh viKꞌaol u Tioxh!— Chia. Pek nichiyaal tu u Jesuus. Yeꞌ nichtaqꞌ tzii te samotxyoloni. Tan tootzajich qꞌu tioxhil txꞌiꞌliꞌinaj aas aꞌ viTxaaom u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Uncheeꞌ aatz qꞌiilich tekuꞌen, kꞌasuꞌl u Jesuus tziꞌ. Utz bꞌen tu maꞌl u txꞌavaꞌ tzꞌintzꞌochi. Loqꞌ ex chokloj tu qꞌu aanima. Ech imaj iatz u Jesuus aas yeꞌk saelbꞌen tixoꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pek tal u Jesuus te ech tzaꞌ: —Ministeer sabꞌenin tu tereꞌn qꞌu tenam. Seꞌnval u bꞌaꞌnla chusbꞌal tetz viQꞌesalail u Tioxh. Tan ech tiꞌ vetchajlikꞌulin.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ech nichtal u bꞌaꞌnla chusbꞌal tu qꞌu atibꞌal chusbꞌal tetz u oꞌtla mantaar. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Uncheeꞌ aatz iꞌana, aas atich u Jesuus tziꞌ u choo Genesareet, mam tenam ipochꞌ tibꞌ kꞌatza tiꞌ tabꞌil u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Utz til kaꞌvaꞌl jukubꞌ u Jesuus tziꞌ u choo. Maꞌtich tel qꞌu eesan txay tuul. Aꞌ tek nichitxꞌaa qꞌul ikꞌach eesabꞌ txay. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ech ok u Jesuus tu maꞌl qꞌu jukubꞌ tziꞌ; ayaꞌ vaꞌl tetzich u Xhim. Utz ijaj bꞌaꞌnil te aas sixaansa okoꞌp bꞌitoj u jukubꞌ viꞌ u choo. Ech kꞌujeꞌ u Jesuus tu jukubꞌ utz, xeꞌt ichus eluꞌl qꞌu tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Aatz tek yaꞌ ichusun u Jesuus, tal tu u Xhim ech tzaꞌ: —Iqꞌoꞌk u jukubꞌ tinaabꞌil u choo tziꞌ. Utz kꞌontaj bꞌen qꞌul ekꞌach tuul. Ech seteesa txay.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Tzaqꞌbꞌu u Xhim, tal te ech tzaꞌ: —¡Chusul, maꞌx aqꞌbꞌal qaqꞌonineꞌ utz, yeꞌxh maꞌj txay vetqeesa! Pek tiꞌ tan, axh nialon, sunkꞌon koꞌp qꞌu kꞌach tziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ech taꞌxh veet taqꞌ koꞌp vikꞌach, sibꞌal txay imooi tuul. Aal nichtekxeꞌtiqꞌixmeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ech motx tek iꞌan bꞌen xheenya tu unjot qꞌul imol qꞌuꞌl atich tu vaꞌt u jukubꞌ tiꞌ aas suꞌlilocheꞌ. Utz oponi. Ech inoosa kaꞌvaꞌl qꞌu jukubꞌ tu txay. Utz nichtekxeꞌtikoꞌp qꞌu jukubꞌ jaqꞌ aꞌ tu u talal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Uncheeꞌ taꞌxh til u kam u Xhim tziꞌ, vaꞌl Luꞌ ibꞌii majte, pecheꞌ vatz u Jesuus. Tal te ech tzaꞌ: —Xaaneꞌl sunkꞌatza unBꞌaal tan, in aa paav.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Tzꞌejx ikꞌuꞌl utz, xoꞌv tuchꞌ qꞌul imol tiꞌ sibꞌal qꞌu txay motx teesa. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Antich u Jacobo tuchꞌ u Xhan, qꞌul ikꞌaol u Zebedeo. Pek aatz u Jesuus, tal tu u Xhim ech tzaꞌ: —Yeꞌ koꞌxh xoꞌvaxh. Tan yitꞌ txay tereꞌn koj sachok tu aꞌ, pek aꞌ tek sachok aanima. Soꞌok tiꞌ inimal u bꞌaꞌnla chusbꞌal.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ech tiqꞌo eluꞌl qꞌu jukubꞌ vatz txꞌavaꞌ qꞌu vinaj tziꞌ. Utz motx tek iyaꞌsa u eesa txay. Motx tek xambꞌu tiꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Uncheeꞌ atich u Jesuus tu maꞌl qꞌu tenam tziꞌ. Utz atich maꞌl u vinaj tziꞌ majte vaꞌlich chꞌaꞌk tiꞌ. Ech taꞌxh til u Jesuus, pecheꞌ kuꞌ siatz. Taqꞌ kuꞌ ivatz vatz txꞌavaꞌ. Utz ijaj bꞌaꞌnil te ech tzaꞌ: —UnBꞌaal, ¿yetz asaꞌ saꞌan bꞌaꞌn ve?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ech taqꞌ opon viqꞌabꞌ u Jesuus, ikanoꞌk. Utz tal te ech tzaꞌ: —Eeꞌ, sunsaꞌa. Bꞌan bꞌaꞌn.— Texh te. Ech tu koꞌxh unmuꞌkꞌul iꞌan bꞌaꞌn; el u chꞌaꞌk kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Utz tiira tal bꞌen u Jesuus tu u vinaj iꞌan bꞌaꞌn aas yeꞌxhabꞌil koꞌxh e satalva. Tal te ech tzaꞌ: —Kuxh kꞌuch tu u oksan yol vatz Tioxh aas bꞌaꞌntꞌaxh. Ech iqꞌo bꞌen u txakunsaꞌm tzixeꞌ vaꞌl sakꞌachlu viꞌ u nachbꞌal. Echaꞌ vaꞌl alelka tu u oꞌtla mantaar tu u Moisees. Ech saootzajili aas bꞌaꞌntꞌaxh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kꞌuxh ech tal u Jesuus, aal koꞌxh maas techalich ipax itziiul. Utz mam tenam nichimol tibꞌ tiꞌ tabꞌileꞌ utz; tiꞌ sabꞌanax bꞌaꞌn te tu qꞌul iyaabꞌil majte. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pek aatz u Jesuus, nichixaansa bꞌen tibꞌ tu qꞌu txꞌavaꞌ tzꞌintzꞌochi tiꞌ iqꞌilal isikꞌlel Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Uncheeꞌ aatz iꞌan tu maꞌl u qꞌii, nichichusun u Jesuus. Utz tiira atich iyakꞌil vixamlil u kuBꞌaal kꞌatza tiꞌ ibꞌanax bꞌaꞌn tu qꞌu yaꞌv. Kꞌujlich opon unjolol qꞌu fariseo tuchꞌ unjolol qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar. Aꞌ motx kꞌaskuꞌl tu kajay qꞌu tenam tikuenta Galilea, tikuenta Judea utz, tuchꞌ tu Jerusaleen. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Uncheeꞌ aatz iꞌana, opon unjolol qꞌu vinaj chelemich maꞌl u vinaj taqꞌo viꞌ chelebꞌal tetz. Tan yaꞌv; numtzꞌinaj ichiꞌl. Utz nichmotxiꞌan yaꞌl tiqꞌol okoꞌp vatz u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pek yeꞌt veet tokoꞌp tu u mam tenam. Ech motx bꞌenjeꞌ viꞌ u otzotz utz, teesa bꞌiil viviꞌ. Ech aꞌ tek taqꞌvu koꞌp u yaꞌv viꞌ qaqꞌal tuchꞌ u chelebꞌ tetz. Ech toksa tu xoꞌl vatz u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ech taꞌxh til u Jesuus aas kꞌujlel ikꞌuꞌl qꞌu chelenal tiꞌ ibꞌantu bꞌaꞌn u yaꞌv, tal u Jesuus tu u yaꞌv ech tzaꞌ: —Vinaj, kajay qꞌul apaav kuyel.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ech aatz qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar tuchꞌ qꞌu fariseo, xeꞌt motx tal tiꞌ taanima ech tzaꞌ: —¡Abꞌil vaꞌl ninacheꞌ tziꞌ aas nipaasa tibꞌ viꞌ Tioxh! Tan abꞌil koj sakuyun paav, pek taꞌxh u Tioxh.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Aatz u Jesuus tan, paal itxumbꞌal tu qꞌuꞌl nichtal tiꞌ taanima. Utz ichꞌoti te ech tzaꞌ: —¿Kam netal tetaanima? ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Abꞌiste tek u kam yitꞌ tzaꞌl koj tel sevatz uncheeꞌ? ¿Aꞌ tzik aꞌ vaꞌl: «Kuyel tek qꞌul apaav kajayil.» Chajin? ¿Oj ayaꞌ vaꞌl: «Lakpen utz, xaan.» Chajin te? ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pek sunkꞌuch sevatz cheel aas nojchit atil tijleꞌm u Kꞌaola vaꞌl bꞌennaj koꞌn aanima tiꞌ ikuyax paav tu u vatz amlika txꞌavaꞌ tzaꞌ.— Texhtuꞌ. Ech tal tu u numtzꞌinaj ech tzaꞌ: —Axh nival axh, lakpen. Iqꞌo bꞌen u chelebꞌ eetz tziꞌ utz, kuxh taatibꞌal.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ech tu koꞌxh u muꞌkꞌul tziꞌ, lakpu u vinaj vatz qꞌu aanima. Tiqꞌo kꞌasuꞌl u chelebꞌ tetz vaꞌl tzanlichka. Ech bꞌen tu tatibꞌal. Utz vaꞌlich toksat iqꞌii Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ech kajay aanima motx tzꞌejx ikꞌuꞌl tu xoꞌval. Utz vaꞌlich tek motx toksat iqꞌii Tioxh ech tzaꞌ: —¡Mam txaichil vetqillu cheel!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Xamtich tek tiꞌ qꞌu kam tzaꞌ, kꞌasuꞌl u Jesuus. Utz til maꞌl u jajol jaꞌmel alkavaar, Levii ibꞌii. Kꞌujlich tu vaꞌl nijajlik jaꞌmel alkavaar. Utz tal te ech tzaꞌ: —Xambꞌen viꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ech lakpu u Levii tziꞌ. Taqꞌka kajay qꞌu kam utz, xambꞌu tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ech iꞌan maꞌl mam txꞌix u Levii tu totzotz tiꞌ u Jesuus. Utz sibꞌal tereꞌn jajol jaꞌmel alkavaar atich opon majte tuchꞌ sibꞌat aanima. Kajay motx ok vatz meexha kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pek nichteesal iqꞌii tu qꞌu fariseo tuchꞌ qꞌu qꞌesal aa txumbꞌal tiꞌ u oꞌtla mantaar. Utz tal tu qꞌu chusulibꞌ ech tzaꞌ: —¿Kam tokeꞌ aas netechbꞌun tuchꞌ qꞌu jajol jaꞌmel alkavaar utz, tuchꞌ qꞌu aa paavla chaj aanima tziꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Utz tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Aatz qꞌu tiichajla aanima, yeꞌxhkam nisavsa aa tzꞌak. Pek aꞌ nisavsan qꞌu yaꞌv. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Tan yitꞌ aꞌ koj ul unchok jikomla aanima. Pek aꞌ ul unchok aa paav sikꞌaxa qꞌul ipaav. Tan aꞌ qꞌuꞌl nisavsan kuybꞌal.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Uncheeꞌ tal qꞌu vinaj tu u Jesuus ech tzaꞌ: —¿Kam tokeꞌ aas tzukꞌel nikuy ivaꞌy qꞌul ichusulibꞌ u Xhan utz, tuchꞌ qꞌu fariseo tiꞌ iqꞌilal isikꞌlel Tioxh? Pek aatz qꞌul achusulibꞌ tziꞌ, yeꞌ nikuy ivaꞌy. Vaꞌl koꞌn motx techbꞌuneꞌ utz, vaꞌl koꞌn motx tukꞌaꞌeꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Aatz u Jesuus tan, tal te ech tzaꞌ: —Yeꞌkax ikuy ivaꞌy qꞌu aanima qꞌuꞌl nisavsal tiꞌ tilax tzumbꞌaꞌa tuul atil u xiak tixoꞌl vaꞌl tzumeꞌya. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pek toj nal uloj u tiempo aas saeesal bꞌen u xiak tixoꞌl. Ech analen tu u tiempo tziꞌ sikuy ivaꞌy tiꞌ iqꞌilal sikꞌlel Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ech ikꞌam tiꞌ maꞌl kam u Jesuus utz, tal te ech tzaꞌ: —Yeꞌxhabꞌil nibꞌanon aas satoksa akꞌ kꞌoo kꞌatz qꞌaꞌl oksaꞌm. Tan oj ech sabꞌanax tziꞌ, sakoꞌnbꞌuchax u akꞌ bꞌuꞌj. Utz saꞌkojikꞌuloꞌk tiꞌ u qꞌaꞌl oksaꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Utz yeꞌxhabꞌil niaqꞌon kuꞌ tu qꞌaꞌl tzꞌuꞌm u taꞌl uuva majte vaꞌl anal telaꞌ. Tan oj ech sabꞌanaxi, saqꞌixmu u tzꞌuꞌm tu visipkꞌu u taꞌl uuva. Utz sapeqꞌxeꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pek aꞌ saꞌaqꞌaxku kuꞌ u taꞌl uuva vaꞌl anal telaꞌ tu akꞌ tzꞌuꞌm. Ech ela koꞌxh bꞌaꞌn saelka. ");
INSERT INTO ixlCNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Utz yeꞌxhabꞌil atix bꞌanon majte aas taꞌxh maꞌt veet tukꞌat u txꞌamla taꞌl uuva, saꞌtepajtachva u taꞌl uuva vaꞌl anal telaꞌ. Tan nitaleꞌ: «Aꞌ techal u txꞌamla taꞌl uuva.» Chaj.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Aatz iꞌan u Jesuus tu maꞌl u ilanbꞌal qꞌii, paal xoꞌl unjolol qꞌu chikobꞌeꞌm. Utz motx xeꞌt itxꞌup vatz itriigo qꞌu chusulibꞌ. Nichisoleꞌl tiꞌ tiqꞌabꞌ utz, nichtechbꞌu. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pek alax te tu unjolol qꞌu fariseo ech tzaꞌ: —¿Kam tokeꞌ aas nebꞌan tu ilanbꞌal qꞌii vaꞌl yitꞌ bꞌaꞌn koj vatz u kukostuumbre tzꞌibꞌamal?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Utz tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —¿Yetz sikꞌlemal tu u Yolbꞌal Tioxh setaqꞌo kam vaꞌl iꞌan u Daviid tuchꞌ qꞌuꞌl xamich tiꞌ aas motx kam tu vaꞌy? ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tan okoꞌp tu u totztioxh utz, ex tiqꞌo qꞌu txaaꞌla kaxhlaan txꞌix. Itxꞌaꞌ tetz utz, taqꞌ tetz qꞌul imol, kꞌuxh yitꞌ aqꞌich koj tzii aas abꞌil koꞌxh satxꞌaꞌon. Pek taꞌxh qꞌu oksan yol vatz Tioxh satxꞌaꞌon.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Utz tal paj ech tzaꞌ: —Aatz u Kꞌaola vaꞌl bꞌennaj koꞌn aanima, qꞌesala tatin vatz u ilanbꞌal qꞌii majte.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Uncheeꞌ aatz paj iꞌan tu vaꞌt ilanbꞌal qꞌii, okoꞌp u Jesuus tu u atibꞌal chusbꞌal tetz u oꞌtla mantaar. Nichichusuneꞌ. Utz atich maꞌl u vinaj tziꞌ, yeꞌ nichiyikun u sebꞌal iqꞌabꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ech aatz qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar tuchꞌ qꞌu fariseo, nichmotxikꞌaabꞌa u Jesuus. Aꞌ isaꞌ samotxtileꞌ satzibꞌan bꞌaꞌn tu u vinaj tu ilanbꞌal qꞌii tziꞌ. Ech sacheei kam tiꞌ siꞌchmotxixochva tala. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pek aatz u Jesuus tan, tootzajich kam vaꞌl nichtitzꞌa qꞌu vinaj tziꞌ. Utz tal tu u vinaj vaꞌl yeꞌ nichiyikun unpaqꞌil iqꞌabꞌ ech tzaꞌ: —Lakpen utz, oken tu kuxoꞌl.— Texh te. Ech ilakpu u vinaj tziꞌ, txakeꞌi. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Utz tal tek u Jesuus tu qꞌu aanima ech tzaꞌ: —Sunchꞌoti maꞌl kam sete. ¿Abꞌiste vaꞌl bꞌaꞌn vatz u mantaar tetz u ilanbꞌal qꞌii? ¿Aꞌ tzik aꞌ vaꞌl sabꞌanax maꞌj bꞌaꞌnil oj maꞌj maaloil? ¿Aꞌ tzik aꞌ vaꞌl saꞌaqꞌax tiichajil, pek oj aal saeesal tiichajil?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ech isaji kajay qꞌu aanima qꞌuꞌl atich tiꞌaj chaj utz, tal tu u vinaj ech tzaꞌ: —Yuj vaqꞌabꞌ tziꞌ.— Texh te. Ech iyuj viqꞌabꞌ u vinaj utz, yakich iꞌan bꞌaꞌn. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ech motx pultu taanima qꞌu fariseo tu kꞌaꞌnal, tuchꞌ qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar. Utz nichtekmotxiyol tibꞌilaj aas kam siꞌan tu u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Uncheeꞌ aatz iꞌan tu qꞌu qꞌii tziꞌ, bꞌenjeꞌ u Jesuus viꞌ maꞌl muunte. Ex iqꞌila isikꞌle Tioxh. Maꞌl aqꞌbꞌal ipaasa tiꞌ iqꞌilal isikꞌle Tioxh tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Utz aatz qꞌiilich tekuꞌen, isikꞌle ul kajay qꞌul ichusulibꞌ kꞌatza. Ech itxaa el kabꞌlaal tixoꞌl. “Chaj” ibꞌii toksa. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Itxaa u Xhim, vaꞌl Luꞌ chu teꞌl majte, tuchꞌ u Lixh vitzaꞌqꞌ. Ant aꞌ u Jacobo, u Xhan, u Felipe, u Bartolomee, ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","u Tio, u Maxh, u Jacobo, vikꞌaol u Alfeo, u Xhim, vaꞌl atich ok xoꞌl qꞌu cananista. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Antu u Judas, vitzaꞌqꞌ u Jacobo utz, tuchꞌ u Judas, u aa Cariote vaꞌl kꞌayin u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ech kꞌasuꞌl tuchꞌ qꞌuꞌl itxaa tziꞌ. Utz motx ilan tu maꞌl u chaqꞌaala. Aꞌ imol sibꞌal qꞌu niman tetz tuchꞌ tereꞌn mam tenam. Atia aa Judea. Atia aa Jerusaleen. Antich aa Tiro tuchꞌ aa Sidoon tziꞌ mar. Ayaꞌ qꞌuꞌl maꞌtich tul tiꞌ tabꞌil u Jesuus utz, tiꞌ sabꞌanax bꞌaꞌn te tu qꞌul iyaabꞌil. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Antu opon qꞌuꞌl nichtulebꞌel tu qꞌu tioxhil txꞌiꞌliꞌinaj majte. Utz motx bꞌanax bꞌaꞌn te tu u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ech kajay qꞌu aanima nichbꞌanon yaꞌl itꞌokax ok u Jesuus tan, nojchit atil viyakꞌil vixamlil u Tioxh kꞌatza. Utz nichibꞌan bꞌaꞌn kajay qꞌu yaꞌv taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Uncheeꞌ isaji opon qꞌul ichusulibꞌ u Jesuus utz, tal ech tzaꞌ: —Chiꞌbꞌebꞌal etetz abꞌiste ex, ex meꞌbꞌaꞌ tan, etetz viQꞌesalail u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Chiꞌbꞌebꞌal etetz abꞌiste ex nevaꞌy cheel tan, saꞌnalpaalex tu vetachaꞌv. Chiꞌbꞌebꞌal etetz abꞌiste ex netoqꞌeꞌ tan, saꞌnaltzeꞌnex tu txuqꞌtxunchil. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Chiꞌbꞌebꞌal etetz oj sakoꞌxhtaqꞌan ichiꞌnaꞌn ikꞌuꞌl aanima setiꞌ utz; satelabꞌekaꞌex; yeꞌk etxaꞌk te siꞌaneꞌ; siyoqꞌex. Utz tiira yeꞌxtxoj ex sataleꞌ. Loqꞌ tiꞌ koꞌn etatin kꞌatz u Kꞌaola vaꞌl bꞌennaj koꞌn aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Pek txuqꞌtxunojex, chiꞌbꞌojex tu qꞌu qꞌii tziꞌ. Tan mam choobꞌal sekꞌul tu Amlika. Tan echat koꞌxh nichiꞌan qꞌul ikꞌuy imam tu qꞌu alol tetz u yolbꞌal Tioxh oꞌtene atziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pek ech koj ex txꞌiiol iqꞌii, tilayol sayaꞌkꞌex tan, nekꞌul etetz cheel. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Tilayol sayaꞌkꞌex abꞌiste ex nepaal tu vetachaꞌv cheel tan, saꞌnalvaꞌyex. Tilayol sayaꞌkꞌex abꞌiste ex netxuqꞌtxun cheel tan, saꞌnaletal txumlebꞌalla chaj yol utz, soꞌoqꞌex. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Tilayol sayaꞌkꞌex untzꞌoj niꞌxhtoksa eqꞌii u tenam kajayil tan, echat chit nichiꞌan qꞌul ikꞌuy imam tu qꞌu chulin alol tetz u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Pek nival sete abꞌiste ex, netabꞌiꞌin cheel tzaꞌ. Tiiojex tiꞌ qꞌul ekoontra sebꞌaneꞌ. Bꞌantaj bꞌaꞌnil tu qꞌuꞌl nichiꞌkꞌulanex. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Altaj bꞌaꞌnla yol tiꞌ qꞌuꞌl nialon tzꞌejbꞌal tzii yol setiꞌ. Utz qꞌilataj sikꞌletaj Tioxh tiꞌ qꞌuꞌl kam koꞌxh nichuli setiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Abꞌil sapaqꞌon ok unpaqꞌil txala etziꞌ, pilqꞌutaj ok vaꞌt siatz. Utz abꞌil lamaaon vechakeꞌt, aqꞌtajka vekamiisa te majte. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Abꞌil sijaj maꞌj kam sete, aqꞌtajka te. Utz abꞌil kam maꞌj etetz simaaeꞌ, yeꞌ koꞌxh etal te aas siqꞌaavixsa sete. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Tan kam kajay qꞌu bꞌaꞌnil esaꞌ siꞌan qꞌu aanima sete, echat sebꞌan te majte. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Tan oj taꞌxh tiiꞌex tiꞌ qꞌuꞌl tii setiꞌ, techal koj chit vaꞌl nebꞌaneꞌ tziꞌ. Tan echat koꞌxh ibꞌanon qꞌu aa paavla chaj aanima, nibꞌan tii tiꞌ qꞌuꞌl bꞌaꞌn te majte. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Utz oj taꞌxh nebꞌanvu bꞌaꞌnil tu qꞌuꞌl nibꞌanon bꞌaꞌnil sete, techal koj chit vaꞌl nebꞌaneꞌ. Tan echat koꞌxh ibꞌanon qꞌu aa paavla chaj aanima. Taꞌxh bꞌaꞌn tu qꞌuꞌl bꞌaꞌn te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Utz oj taꞌxh netaqꞌ ikꞌam qꞌuꞌl soꞌoleꞌ tiꞌ iqꞌaavixsaleꞌ netileꞌ, techal koj chit vaꞌl nebꞌaneꞌ tziꞌ. Tan echat koꞌxh niꞌan qꞌu aa paavla chaj aanima tibꞌilaj majte. Taꞌxh nitaqꞌ ikꞌam qꞌuꞌl nitileꞌ aas saveeti siqꞌaavixsa. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pek aatz ex, tiiꞌex tiꞌ qꞌuꞌl nikoontrainex. Bꞌantaj bꞌaꞌnil te. Utz aqꞌtaj kꞌam majte. Loqꞌ yitꞌ aꞌ koj sechꞌia ekꞌultu maꞌj kam tiꞌ. Ech nim vejaꞌmel siꞌaneꞌ. Utz nojchit ex ikꞌaol imeꞌal u Tꞌankin Tioxh siꞌaneꞌ. Tan tiira jik u Tioxh tu qꞌuꞌl yeꞌxh bꞌoj nikꞌamabꞌen qꞌu kam. Utz bꞌaꞌn tu qꞌu onkonla chaj aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Bꞌantajex txumul vatz, echaꞌ u kuTat. Tan tiira txumul vatz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yeꞌ koꞌxh eyol aanima oj niyolpu sevatz, ech yeꞌk sitxꞌol enujul u Tioxh. Yeꞌ koꞌxh etzꞌej paav tiꞌ emol, ech yeꞌk satzꞌejax paav setiꞌ majte. Kuyunojex, ech sakuylex. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Utz noj ichajpeꞌl etetz, ech saꞌaqꞌax etetz majte. Bꞌaꞌnla paabꞌal soꞌok setiꞌ; bꞌoono inooeꞌ; tiira jeꞌnaj iviꞌ. Tan kam chit vaꞌl setaqꞌeꞌ, echat saꞌaqꞌax sete.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Uncheeꞌ tal maꞌl u kꞌamich yol u Jesuus tu qꞌu chusulibꞌ majte. Tal te ech tzaꞌ: —¿Satz iꞌaneꞌ saiqꞌol ibꞌey maꞌl moy tu vaꞌt moy? Tan oj ech siꞌaneꞌ, ela sachajpu bꞌen tu jul atziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Utz yitꞌ paalnaj koj tijleꞌm u chusulibꞌ vatz u chusul tetz. Pek anal sitxꞌak u chusul tetz aas tiira maꞌt ichusax bꞌaꞌnil. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Utz ¿kam tokeꞌ aas aꞌ chit tii nasaji iyolpu amol saatz tiꞌ maꞌj tal kam? Utz yeꞌxhat niꞌenku see aas paalchu qꞌu kam niyolpikꞌaxh siatz. Echaꞌ maꞌl juy chꞌis niil tu bꞌaqꞌ iatz amol. Pek aal yeꞌ niil u mam tzeꞌ atil tu val eetz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Yeꞌk siꞌaneꞌ setal temol ech tzaꞌ: «Aqꞌ tzii saveesa eluꞌl maꞌl u juy chꞌis taatz tziꞌ.» Chajex. Tuul aal maꞌl mam tzeꞌ at okoꞌp tevatz. Utz yeꞌ niveet esajin taqꞌo. ¡Kaꞌvatz! Eesataj eluꞌl u mam tzeꞌ tevatz bꞌaxa, ech siꞌan bꞌaꞌn esajineꞌ. Ech nal saꞌtekveeti setal teluꞌl u juy chꞌis tivatz vemol. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Utz yeꞌxh bꞌoj siꞌaneꞌ aas yeꞌxtxoj ivatz u bꞌaꞌnla vatzomla tzeꞌ sataqꞌeꞌ. Utz yeꞌk siꞌan majte aas bꞌaꞌn ivatz u yeꞌxtxojla vatzomla tzeꞌ sataqꞌeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tan aꞌ niꞌilchik u tzeꞌ tu vivatz. Echaꞌ u viikuxh. Saꞌkojiꞌaneꞌ sachee tiꞌ u paal chꞌiꞌx. Utz saꞌkojiꞌaneꞌ sachee uuva tiꞌ u vainiꞌx. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Echat u bꞌaꞌnla aanima. Aꞌ nikꞌuchvu tu vibꞌanoneꞌ aas atil u bꞌaꞌnil xeꞌ taanima. Pek aatz u onkonla aanima, tu vibꞌanoneꞌ nikꞌuchvu majte aas u onkonil atil xeꞌ taanima. Tan kam vaꞌl atil tu taanima u aanima, aꞌ vaꞌl nijeꞌul titziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Kam tokeꞌ netal ve?: «unBꞌaal, unBꞌaal» cheꞌex. Pek yeꞌ nebꞌan qꞌuꞌl nival sete. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Tan aatz kajay qꞌuꞌl nitul sunkꞌatza, nitabꞌi vunyol utz, nibꞌan bꞌanol tetz. Utz ech bꞌanel taqꞌo vaꞌl iꞌan maꞌl u vinaj atziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Iꞌan totzotz. Ikꞌot vikuꞌebꞌal. Sibꞌ bꞌeni iꞌana. Utz aꞌ taqꞌvu jeꞌ vitzꞌachil viꞌ maꞌl mam sivan. Ech kꞌuxh el nimaꞌ, ipaqꞌoꞌk tibꞌ tiꞌ u otzotz tziꞌ, yeꞌt oleꞌ tiꞌ iyikuneꞌ. Tan axhibꞌi bꞌoono ijeꞌ viꞌ u mam sivan. ");
INSERT INTO ixlCNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pek aatz qꞌuꞌl yeꞌ niꞌan bꞌanol tetz qꞌul unyol, ela tuchꞌ vaꞌt u vinaj atziꞌ vaꞌl viꞌ txꞌavaꞌ koꞌn taqꞌvu jeꞌ u totzotz. Yeꞌt taqꞌ bꞌen itzꞌachil tu txꞌavaꞌ. Ech aatz el u nimaꞌ, ipaqꞌoꞌk tibꞌ tiꞌ utz, kuꞌi. Bꞌoono isotz sotzi.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Uncheeꞌ aatz yaꞌ iyolon u Jesuus tu qꞌu aanima, bꞌen tek tu Capernauum. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Utz atich maꞌl u vinaj tziꞌ siꞌchtexhel ikꞌuꞌl tu yaabꞌil. Taqꞌonomich maꞌl u qꞌesal sol. Ayaꞌ maꞌl u taqꞌonom vaꞌl tiira tiich chit tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ech aatz tabꞌi itziiul u Jesuus u qꞌesal sol, oora ichajuꞌl unjolol qꞌul iqꞌesal qꞌu Israeel tzixeꞌ. Ul ijaj bꞌaꞌnil te aas suꞌlibꞌan bꞌaꞌn tu u taqꞌonom. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Ech motx ul qꞌul iqꞌesal qꞌu Israeel xeꞌ u Jesuus. Utz tiira ijaj chit bꞌaꞌnil te ech tzaꞌ: —Tiira bꞌaꞌn ikꞌuꞌl u capitaan tiꞌ u kutenam tzaꞌ. Aal aqꞌel jeꞌ maꞌl atibꞌal taqꞌo, chusbꞌal tetz u oꞌtla mantaar. Ech niꞌxhikꞌuloꞌk tiꞌ aas saaqꞌ te kam vaꞌl nijaj see.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ech bꞌen u Jesuus tiꞌ. Utz aatz nichtekinajabꞌ kꞌatz u atibꞌal, ichajuꞌl unjolol tamiigo u qꞌesal sol xeꞌ u Jesuus. Ul tal te ech tzaꞌ: —UnBꞌaal, yeꞌ koꞌxh chiinaxh tu ulchil. Tan yeꞌ nikꞌuloꞌk viꞌ aas soꞌokoꞌpꞌaxh tu votzotz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Echtzixeꞌt yeꞌn oponin tzaxeꞌ tan, yeꞌ nikꞌuloꞌk viꞌ. Pek al koꞌn vayol. Ech siꞌan bꞌaꞌn u vaqꞌonom. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tan echaꞌ in. Atilkoꞌnokꞌin jaqꞌ imantaar unqꞌesal. Utz atoꞌk sol jaqꞌ unmantaar majte. Utz aatz nival tu maꞌj: «Kuxh tzaꞌ.» Chiꞌin te. Utz nibꞌenaꞌ. «Niꞌaxh tzaꞌ.» Chiꞌin tu vaꞌtioj utz, nituleꞌ. Utz nival tu vaꞌt vaqꞌonom: «Bꞌan vaꞌl tzaꞌ.» Chiꞌin te. Utz niꞌaneꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ech techal chit u yol tabꞌi u Jesuus tziꞌ. Utz yakich tzꞌejxoj ikꞌuꞌl taqꞌo. Ech ipilqꞌu tibꞌ, isaji qꞌu aanima qꞌuꞌl xamich tiꞌ. Tal te ech tzaꞌ: —Nojchit nival sete aas yeꞌsaj viltu maꞌj aanima Israeel, aas tiira kꞌujlel ikꞌuꞌl viꞌ echaꞌ u puera vinaj tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ech aatz tek qꞌaavopon qꞌu chaj tu atibꞌal, bꞌaꞌnich tek u aqꞌonom vaꞌl yaꞌvich. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Xamtich tek tuul, bꞌen u Jesuus tu u tenam Naiin. Aꞌich imol qꞌu chusulibꞌ. Utz mam tenam xamtich tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Aatz motx opon najaꞌch u jubꞌal, u okebꞌal tu u tenam, tuul nichtiqꞌol eluꞌl maꞌl u kamchil. Seꞌnmujaxoj. Titzꞌinich maꞌl u txakay ixoj. Utz taꞌxhich maꞌl vatz titzꞌin atiche. Utz sibꞌal aanima xamich tiꞌ, qꞌuꞌl tu u tenam tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ech txumax iatz u txakay ixoj tu u Jesuus aas tiltaꞌ. Ech iqꞌila utz, tal te ech tzaꞌ: —Yeꞌ koꞌxh oqꞌaxh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ech ixaan opon u Jesuus utz, itꞌok u chelebꞌ tetz u kamchil. Ech txakeꞌ tek qꞌu chelen tetz. Tal u Jesuus tu u kamnaj ech tzaꞌ: —Xiak, axh nivalaxh, lakpen.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ech qꞌaav itzꞌpu u xiak vaꞌl maꞌtich ikameꞌ. Xeꞌt tek iyoloneꞌ. Ech aqꞌax tek tu vinan. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ech motx xoꞌv aanima kajayil. Utz xeꞌt motx toksa iqꞌii Tioxh. Nichtal ech tzaꞌ: —¡Nojchit maꞌl techalla alol tetz u yolbꞌal Tioxh cheey tu kuxoꞌl! ¡Ulyu quxeꞌ tu u Tioxh oꞌ itenam!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ech pax chit paal itziiul u Jesuus tikuenta kajay u Judea tuchꞌ qꞌu tenam sinajaꞌch. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Uncheeꞌ alax tek kajay qꞌu kam tu u Xhan tzaꞌ. Qꞌul ichusulibꞌ alon te. Ech isikꞌle kaꞌvaꞌl ichusulibꞌ u Xhan. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Utz ichaj bꞌen xeꞌ u Jesuus tiꞌ ichꞌotil te ech tzaꞌ: — «¿Axh tzik viTxaaom u Tioxh vaꞌl saꞌchitꞌuli? Pek oj yitꞌ axh koj utz, sakuchꞌia vaꞌte.» Chia.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ech aatz motx opon xeꞌ u Jesuus, tal te ech tzaꞌ: —Vetichajuꞌloꞌ u Xhan tzaxeꞌ, u bꞌanol vautiismo. Ul kuchꞌoti see taqꞌo: «¿Axh tzik viTxaaom u Tioxh vaꞌl saꞌchitꞌuli? Pek ¿oj yitꞌ axh koj? Utz sakuchꞌia vaꞌte.» Chia.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Uncheeꞌ aatz u Jesuus, sibꞌal yaꞌv iꞌan bꞌaꞌn te tu u muꞌkꞌul tziꞌ. Iꞌan bꞌaꞌn tu qꞌuꞌl atich ok tioxhil txꞌiꞌliꞌinaj kꞌatza. Utz sibꞌla moy isajinsa. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ech tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Bꞌenoj etal tu u Xhan kam qꞌu kam netileꞌ etabꞌi tzaꞌ: «Tan nitekisajin qꞌu moy. Nitekixaan qꞌu koꞌx. Nitekiꞌan bꞌaꞌn qꞌu chꞌaꞌkꞌiꞌ. Nitektabꞌin qꞌu chakan. Niqꞌaavtitzꞌpixsal kamnaj. Utz nitektabꞌi u bꞌaꞌnla chusbꞌal qꞌu meꞌbꞌaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Utz chiꞌbꞌebꞌal tetz vaꞌl yeꞌ nikaꞌtziiun viꞌ.» Chajex te.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Uncheeꞌ aatz tek kꞌasuꞌl qꞌul ichaj u Xhan, xeꞌt iyolon u Jesuus tiꞌ u Xhan tu qꞌu tenam ech tzaꞌ: —¿Kam bꞌanel titxumbꞌal u vinaj vaꞌl ex etil tu tzꞌinlich tzaji txꞌavaꞌ bꞌatzꞌi? ¿Ech tzik aꞌ maꞌj aa aas vaꞌl koꞌxh ibꞌen sunchaj jalil tu kajiqꞌ? Yeꞌka. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Pek ¿kam chit ex etileꞌ? ¿Aꞌ tzik ex etil maꞌj vinaj aas toksaꞌm ijlenal atoꞌk taqꞌo? Yeꞌka. Tan aatz qꞌuꞌl bꞌaꞌnla chaj oksaꞌm atoꞌk taqꞌo, techal tatineꞌ. Ayeꞌn tu qꞌu tatibꞌal ijlenal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Loqꞌ ¿kam chit ex etileꞌ? ¿Maꞌj tzik alol tetz u yolbꞌal Tioxh? Bꞌaꞌntan aꞌ i. Utz nival sete aas aal nim tatin vatz tereꞌn qꞌu alol tetz u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tan aꞌ vaꞌl tzꞌibꞌamalka u yol tiꞌ ech tzaꞌ: «Sunbꞌaxabꞌsa bꞌen vunchaj saatz. Aꞌ sapaxsan itziiul val ooponbꞌal. Echaꞌ ibꞌanax tuch bꞌey saatz siꞌaneꞌ.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Tan nival sete aas yeꞌxhabꞌil koꞌxh vaꞌtoj paalchu tijleꞌm viꞌ u Xhan, u bꞌanol vautiismo xoꞌl kajay qꞌu aanima alamal. Pek loqꞌ kꞌuxh echi, aatz qꞌuꞌl chꞌoo koꞌn u tijleꞌm tu viQꞌesalail u Tioxh, paalchu tijleꞌm viꞌ u Xhan tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ech taꞌxh tabꞌi u kam qꞌu tenam tzaꞌ, tuchꞌ qꞌu jajol jaꞌmel alkavaar, motx txuqꞌtxuni tan, motx inima vinujul tal u Tioxh. Tan maꞌt motx iꞌan ivautiismo echaꞌ vaꞌl tal u Xhan. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pek aatz qꞌu fariseo tuchꞌ qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar, motx koꞌn teesa iqꞌii vitxumbꞌal u Tioxh tziꞌ. Yeꞌt motx inima kam vaꞌl titzꞌa u Tioxh tiꞌ. Tan yeꞌt koꞌn motx iꞌan ivautiismo, echaꞌ vaꞌl tal u Xhan. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Tal tek u Jesuus ech tzaꞌ: —¿Kam bꞌoj sunkꞌam tiꞌ aas ela tuchꞌ qꞌu aanima tu u tiempo tzaꞌ? ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ela tuchꞌ qꞌu talaj nitxaꞌ atziꞌ aas chꞌuxhlel tu kꞌayibꞌal. Utz niqetunsa bꞌen talax timol ech tzaꞌ: «Vetkuxuli aa, pek yeꞌn bꞌixex. Txumumbꞌal kubꞌitz vetbꞌitzꞌoꞌ, pek yeꞌn oqꞌex tu txumuꞌm.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tan ul u Xhan, u bꞌanol vautiismo, yeꞌt itxꞌaꞌ kaxhlaan txꞌix utz, yeꞌt tukꞌa taꞌl uuva. Utz netal tiꞌ: «Atil tioxhil txꞌiꞌliꞌinaj kꞌatza.» Cheꞌex. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Utz aatz cheel, ulyu u Kꞌaola vaꞌl bꞌennaj koꞌn aanima utz, nitechbꞌuneꞌ, nitukꞌa taꞌl uuva. Utz netal tiꞌ: «Ulyu maꞌl u vinaj yeꞌk chit iyaꞌebꞌal tu echbꞌuꞌm utz, tiꞌ tukꞌal taꞌl uuva. Nimolo tibꞌ tuchꞌ aa paav utz, tuchꞌ jajol jaꞌmel alkavaar.» Cheꞌex. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pek aatz vitxumbꞌal u Tioxh, aꞌ niꞌilchik tu vibꞌanon qꞌul ikꞌaol imeꞌal.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Uncheeꞌ aatz iꞌana, savsal u Jesuus tu maꞌl u fariseo. Tal te seꞌntxꞌaꞌn tzixeꞌ. Ech bꞌen u Jesuus otzotz tzixeꞌ utz, ok vatz meexha. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ech opon maꞌl u ixoj kꞌatz u Jesuus, maꞌl aa paavla ixoj tu u tenam tziꞌ. Iqꞌomich maꞌl tal bꞌaꞌnla tzꞌaj taqꞌo. Txꞌumqꞌixsabꞌal atil tuul. Tan tabꞌi aas nichitxꞌaꞌn u Jesuus xeꞌ u fariseo. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Utz atin tiꞌ iqul u Jesuus xeꞌaj tajan. Ech xeꞌt toqꞌeꞌ. Takꞌsa qꞌu tajan u Jesuus tu qꞌu taꞌl bꞌaqꞌ iatz. Utz nichisuu tu xiꞌl iviꞌ. Nichitzꞌutzꞌ qꞌu tajan. Utz iqook u txꞌumqꞌixsabꞌal tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ech taꞌxh til u kam u fariseo tziꞌ, tal tu taanima ech tzaꞌ: —Oj nojchit alol yolbꞌal Tioxh vaꞌl tziꞌ, satootzaji koj atziꞌ aas aa paav u ixoj vaꞌl nikanon ok tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ech tal tek u Jesuus tu u fariseo ech tzaꞌ: —Xhim, atil maꞌl kam saval see.— Texhtuꞌ. Tal u Xhim ech tzaꞌ: —Ala chusul.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Tal u Jesuus te: —Atich maꞌl u vinaj atich itxꞌoj kaꞌvaꞌl aanima tzixeꞌ. Maꞌl, ijaꞌmel 500 aqꞌonibꞌal qꞌii itxꞌoj atiche. Aatz vaꞌt, ijaꞌmel 50 aqꞌonibꞌal qꞌii itxꞌoj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Aatz kaꞌvaꞌl qꞌu vinaj tziꞌ tan, yeꞌt motx oleꞌ tiꞌ icheeaꞌ kaniꞌch ichool qꞌuꞌl itxꞌoj siꞌaneꞌ. Utz kuyax qꞌul itxꞌoj sikaꞌbꞌil. Pek ala, ¿abꞌiste maꞌl tu kaꞌvaꞌl qꞌu vinaj tziꞌ saꞌxhikꞌama tu u bꞌaal itxꞌoj?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tzaqꞌbꞌu u Xhim, tal ech tzaꞌ: —Aꞌ chit maas sakꞌamabꞌeni vaꞌl sibꞌal itxꞌoj vetkuyli.— Texhtuꞌ. Utz tal tek u Jesuus te ech tzaꞌ: —Eeꞌ, echi. Ayaꞌ vaꞌl naaleꞌ tziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tuul ipilqꞌu bꞌen tibꞌ tinujul u ixoj utz, tal tu u Xhim ech tzaꞌ: —¿Matz iillu vaꞌl vetiꞌan u ixoj tziꞌ? Tan kꞌuxh taatibꞌal vetꞌulkꞌin utz, aal yeꞌn aaqꞌ vaaꞌ txꞌaabꞌal vajan. Pek aatz u ixoj tziꞌ, vettakꞌsal vajan tu u taꞌl bꞌaqꞌ iatz utz, nisuu tu u xiꞌl iviꞌ tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yeꞌxhkam vetatzꞌutzꞌin. Pek aatz u ixoj tziꞌ, yeꞌsaj iyaꞌ tiꞌ itzꞌutzꞌax vajan jankꞌax vukuꞌl tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Yeꞌxhkam vetaqoo jeꞌ aseite tunviꞌ. Pek aatz u ixoj tziꞌ, vettoksal txꞌumqꞌixsabꞌal tiꞌ vajan. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ech tokeꞌ nival see aas kuyel kajay qꞌul ipaav kꞌuxh sibꞌal. Ech sibꞌal nikꞌamabꞌeneꞌ. Pek ech koj vaꞌl bꞌiil koꞌn ipaav nikuyaxeꞌ, bꞌiil koꞌn nikꞌamabꞌeneꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Utz tal tek tu u ixoj ech tzaꞌ: —Kajay qꞌul apaav kuyel.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ech aatz tereꞌn qꞌu aanima qꞌuꞌl oknajich tuchꞌ vatz meexha, xeꞌt motx tal tibꞌilaj ech tzaꞌ: —¿Kam tek tijleꞌm vaꞌl tziꞌ nitaleꞌ aas nikuy paav majte?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pek tal paj u Jesuus tu u ixoj ech tzaꞌ: —Tiꞌ vikꞌujeꞌ akꞌuꞌl viꞌ vetchitpꞌaxh tu qꞌul apaav. Kuxh, txꞌanel abꞌenaꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Uncheeꞌ xamtich tek tuul, nichipaal u Jesuus tu qꞌu tenam tuchꞌ tu qꞌu talaj tenam tiꞌ ipaxsal paal u bꞌaꞌnla chusbꞌal tetz viQꞌesalail u Tioxh. Aꞌ imol kabꞌlaal qꞌul ichusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Utz antu kaꞌxvaꞌl ixoj xamich tiꞌ majte. Ayaꞌ qꞌuꞌl maꞌtich iꞌantu bꞌaꞌn tu yaabꞌil. Utz atia maꞌtich tel tioxhil txꞌiꞌliꞌinaj kꞌatza. Atich u Liꞌ tixoꞌl, u aa Magdala, vaꞌl maꞌtich tel jujvaꞌl tioxhil txꞌiꞌliꞌinaj kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Antu u Xhiv, u tixoj u Chuza. Aatz u Chuza tziꞌ, atich tijleꞌm kꞌatz u ijlenal Herodes. Antich u Xhuxh utz, tuchꞌ unjot ixoj, aqꞌolich tetz u Jesuus kam nichisavsa tan, atich imeꞌbꞌiꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Uncheeꞌ mam tenam imol tibꞌ tiꞌ u Jesuus. Til chaj koꞌxh tenam motx kꞌaskuꞌl. Utz ikꞌam tiꞌ kam u Jesuus tu vichusun ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Aatz iꞌan maꞌl u chikol, bꞌen tu chikoꞌm. Ex ichik u tia. Utz tuul nichimakꞌ paal u triigo tu aqꞌonibꞌal, atia aꞌ kuꞌk tu bꞌey. Ech tzeqꞌeꞌyulka. Utz motx koꞌn ex tzotiloj tu qꞌu tzꞌichin tu amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","At u ia aꞌ kuꞌk viꞌ sivan. Utz taꞌxh itzꞌpi, tzaji. Tan yitꞌ loꞌlochich koj tatineꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Utz at u ia, aꞌ kuꞌk xoꞌl chꞌiꞌx. Ech aatz qꞌu chꞌiꞌx qꞌuꞌl ela itzꞌpu tuchꞌ, isotzsa. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pek aatz untante, aꞌ kuꞌk tu bꞌaꞌnla txꞌavaꞌ. Utz itzꞌpi, ech vatzini. 100 ivatz taqꞌa.— Texh u Jesuus. Ech taꞌxh tal qꞌu yol tziꞌ, qꞌeqꞌuꞌm chit talax iꞌan ech tzaꞌ: —¡Abꞌiste ex niabꞌin qꞌu yol tzaꞌ, nimataj!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ech chꞌotil te tu qꞌul ichusulibꞌ ech tzaꞌ: —¿Kam u tokebꞌal qꞌu kam vetakꞌam tiꞌ tziꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Bꞌaꞌn ex tan, aqꞌel tzii sete aas setootzaji u tokebꞌal qꞌu kam qꞌuꞌl yeꞌ ootzajimal tiꞌ viQꞌesalail u Tioxh. Pek ech koj qꞌu aanima tziꞌ, yitꞌ vatzsaj koj saꞌalax te. Unjolol kam sakꞌamax tiꞌ, tiꞌ talchu te. Ech kꞌuxh sasajini, saꞌkojikan tilaxeꞌ kam nisaji. Utz kꞌuxh satabꞌi, saꞌkojpaal itxumbꞌal tuul kam vaꞌl satabꞌi. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Pek aꞌ u tokebꞌal u yol tzaꞌ vaꞌl vetunkꞌam tiꞌ talax u chikol. Aatz u ia, aꞌ nikꞌam tiꞌ u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ech aatz u ia kuꞌ tu bꞌey, aꞌ nikꞌam tiꞌ u aanima vaꞌl nitabꞌi u yolbꞌal Tioxh. Pek nikoꞌnulsotzsaloj sikꞌuꞌl tu u txꞌiꞌliꞌinaj. Ech yeꞌk sinima utz, yeꞌk sachitpi tu paav. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Aatz u ia vaꞌl aꞌ kuꞌk viꞌ sivan, aꞌ nikꞌam tiꞌ u aanima vaꞌl nitabꞌi u yolbꞌal Tioxh utz, tuchꞌ txuqꞌtxunchil nikꞌuleꞌ. Pek yeꞌ bꞌennaj taqꞌil. Maꞌl koꞌxh tiempo ninima u yolbꞌal Tioxh. Utz aatz nitul maꞌj tzaꞌlla kam tiꞌ, nitelka. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Aatz u ia vaꞌl kuꞌ xoꞌl chꞌiꞌx, aꞌ nikꞌam tiꞌ u aanima vaꞌl niabꞌin u yolbꞌal Tioxh. Pek nikoꞌnisotzsa bꞌen sikꞌuꞌl tiꞌ qꞌu elaꞌokchil, tiꞌ qꞌu txꞌiibꞌal qꞌii, tiꞌ qꞌu achva kam tu u vatz txꞌavaꞌ tzaꞌ. Ech yeꞌ niqꞌanbꞌu tu u tatin kꞌatz u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pek ech koj vaꞌl kuꞌ tu bꞌaꞌnla txꞌavaꞌ, aꞌ nikꞌam tiꞌ qꞌu aanima qꞌuꞌl bꞌaꞌn taanima. Jikom nikꞌul u yolbꞌal Tioxh vaꞌl nitabꞌi. Ech bꞌenamen nikꞌucheꞌ aas kolel taqꞌo. Echaꞌ u ia aas bꞌenamen nivatzin vitzeꞌil. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yeꞌxhabꞌil nibꞌanon aas nimatx txijtxubꞌal utz, sakoꞌnijupi tu maꞌj kam. Yeꞌkax bꞌanli aas saꞌaqꞌax okoꞌp u txijtxubꞌal jaqꞌ txꞌach. Pek aꞌ niaqꞌaxku jeꞌ viꞌ u tatibꞌal. Ech satil u tuul otzotz qꞌu aanima qꞌuꞌl nitokoꞌp, txijtxumal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tan yeꞌk maꞌj mujich kam aas yeꞌ koj saꞌabꞌili. Utz yeꞌk maꞌj kam sajutxil ibꞌanaxeꞌ aas yeꞌ koj saeluꞌl itziiul. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ech tokeꞌ at noj bꞌenku sete kaniꞌch tabꞌil u chusbꞌal nebꞌaneꞌ tzaꞌ. Tan abꞌil atil nal tetz, saꞌaqꞌax tereꞌn tetz. Pek abꞌiste vaꞌl yeꞌk tetz, loqꞌ atil bꞌiil tetz aas nitaleꞌ, sakoꞌnmaaleꞌl te.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Uncheeꞌ opon vinan u Jesuus tuchꞌ qꞌul itzaꞌqꞌ. Pek yeꞌt veet ixaan opon kꞌatza tiꞌ u mam tenam atiche. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ech alax opon te ech tzaꞌ: —Atil vanan tuchꞌ qꞌul atzaꞌqꞌ qꞌanal. Nisaꞌa satilaxh chi.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Tzaqꞌbꞌu tek u Jesuus ech tzaꞌ: —Nojla aꞌ unnan utz, nojla aꞌ untzaꞌqꞌ qꞌuꞌl niabꞌin u yolbꞌal Tioxh utz, niꞌan bꞌanol tetz.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Uncheeꞌ aatz iꞌan tu maꞌl u qꞌii, okbꞌen u Jesuus tu jukubꞌ tuchꞌ qꞌul ichusulibꞌ utz, tal te ech tzaꞌ: —Paalojbꞌenoꞌ sala bꞌen u choo tziꞌ.— Texhtuꞌ. Ech motx bꞌeni. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Pek vat u Jesuus tuul nichixaan viꞌ u aꞌ. Utz xeꞌt maꞌl mam kajiqꞌ jabꞌal viꞌ u choo. Utz vaꞌlich tek ikoꞌp aꞌ tu jukubꞌ. Xoꞌvebꞌalich tekuꞌen. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ech xaan opon qꞌu chusulibꞌ kꞌatz u Jesuus, ikꞌassa. Tal te ech tzaꞌ: —¡Chusul, chusul, toj bꞌenojoꞌ tu aꞌ!— Texh te. Ech kꞌas tek u Jesuus utz, iyaa u mam kajiqꞌ jabꞌal tuchꞌ vipilqꞌaꞌtxan u choo. Ech yaꞌi. Vaꞌlich tek tachavan ikalkoch u aꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Utz tal tek u Jesuus tu qꞌu chusulibꞌ ech tzaꞌ: —¿Kantuꞌ yeꞌ kꞌujlel ekꞌuꞌl?— Texh te. Aatz qꞌu chusulibꞌ, vaꞌlich tek ixoꞌveꞌ. Utz tzꞌejx ikꞌuꞌl taqꞌo. Nichtektal tibꞌilaj ech tzaꞌ: —¡Abꞌil techit u vinaj tziꞌ nitaleꞌ! ¡Tan nikoꞌniyaa u mam kajiqꞌ jabꞌal tuchꞌ u choo tziꞌ utz, nimalia!— Texh tibꞌilaj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Uncheeꞌ opon tek tu vitxꞌavaꞌ qꞌu aa Gaadara, tinujul unpaqꞌit itziꞌaj u choo tu Galilea. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ech taꞌxh eluꞌl u Jesuus vatz txꞌavaꞌ, ul kꞌulaxoj tu maꞌl u vinaj tu u tenam tziꞌ. Atich ok tioxhil txꞌiꞌliꞌinaj kꞌatza. Utz sibꞌalich tek tiempo tuul aas yeꞌ nitoksa toksaꞌm. Utz yitꞌ aꞌ koj nichatinku tu otzotz, pek xoꞌl mujbꞌal kamnaj atichka. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Utz ech taꞌxh til u Jesuus qꞌeqꞌuni. Pecheꞌ kuꞌ siatz. Utz qetun taltu ech tzaꞌ: —¿Kam asaꞌ ve Jesuus iKꞌaol Tꞌankin Tioxh? ¡Nunjaj bꞌaꞌnil see, yeꞌ koꞌxh uulevansaꞌin!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Tan nichtojcheꞌl u tioxhil txꞌiꞌliꞌinaj u Jesuus kꞌatz u vinaj tziꞌ. Tan sibꞌich tek tiempo maꞌtich tok kꞌatza. Utz kꞌuxh nichiqitzax tu kadeena utz, nixeeleꞌ; nikoꞌniratꞌ qꞌu qitzbꞌal tziꞌ. Utz nitiqꞌol bꞌen tu tzꞌinlich txꞌavaꞌ tu u txꞌiꞌliꞌinaj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Utz chꞌotil te tu u Jesuus ech tzaꞌ: —¿Kam abꞌii?— Texh te. Tal ech tzaꞌ: —Yeꞌ achebꞌe unbꞌii.— Texhtuꞌ tan, sibꞌla tioxhil txꞌiꞌliꞌinaj atich ok kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Utz kaanaich motx ijajtu qꞌu tioxhil txꞌiꞌliꞌinaj tu u Jesuus aas yeꞌk saꞌalax ibꞌen tu u mam jolobꞌtxan. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Utz kavaal chit nichichokobꞌe tibꞌ unjolol bꞌoch viꞌ maꞌl u muunte tziꞌ. Tiira sibꞌal ixaan nichixeel tziꞌ. Ech ijajabꞌe u Jesuus qꞌu tioxhil txꞌiꞌliꞌinaj aas sataqꞌ tzii te soꞌok kꞌatz qꞌu bꞌoch. Utz aqꞌax tzii te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ech el qꞌu tioxhil txꞌiꞌliꞌinaj kꞌatz u vinaj tziꞌ utz, ok kꞌatz kajay qꞌu bꞌoch. Utz yeꞌk chit talcheꞌ, motx ex ikꞌon bꞌen tibꞌ qꞌu bꞌoch tziꞌ peepu taqꞌo, yakich tu choo. Ech motx jiqꞌmu tu aꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ech taꞌxh til qꞌu xeen bꞌoch, kam vaꞌl maꞌtich tucheꞌ, motx tꞌaspi kꞌasuꞌl. Utz ex tal u yol tu tenam tuchꞌ tu qꞌu jaꞌjtzeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ech ul til qꞌu aanima kam vaꞌl maꞌtich tucheꞌ. Ul kꞌatz u Jesuus. Utz motx til u vinaj vaꞌl maꞌtich tel qꞌu tioxhil txꞌiꞌliꞌinaj kꞌatza. Kꞌujlich txala tajan u Jesuus. Tiira bꞌaꞌnich tekuꞌen. Atich tek ok toksaꞌm. Ech motx xoꞌvi. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Aatz qꞌu aanima qꞌuꞌl ilon qꞌu kam tziꞌ, motx tek tal tunjot qꞌu aanima qꞌuꞌl anal toponeꞌ, kaniꞌch vibꞌantu bꞌaꞌn u vinaj vaꞌl atich ok tioxhil txꞌiꞌliꞌinaj kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Uncheeꞌ aatz tek qꞌu aanima qꞌuꞌl tikuenta u txꞌavaꞌ Gaadara tziꞌ, motx ijaj bꞌaꞌnil tu u Jesuus aas saelkꞌasuꞌl tikuenta qꞌul itxꞌavaꞌ. Tan techalich motx ixoꞌveꞌ. Ech ok u Jesuus tu jukubꞌ. Qꞌaavkꞌasuꞌl tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Pek aatz u vinaj vaꞌl maꞌtich tel qꞌu tioxhil txꞌiꞌliꞌinaj kꞌatza, ijajabꞌe u Jesuus aas sataqꞌ tzii te taꞌn saxambꞌu tiꞌ. Pek chajax koꞌn kꞌasuꞌl tu u Jesuus. Tal te ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Kuxh taatibꞌal. Utz ala kam u mam bꞌaꞌnil vetiꞌanlu u Tioxh see.— Texh te. Ech bꞌeni utz, xeꞌt ipaxsa itziiul tu kajay u tenam aas kam u mam bꞌaꞌnil iꞌan u Jesuus te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Uncheeꞌ aatz tek qꞌaavuꞌl u Jesuus, mam tenam kꞌulun toponeꞌ. Vaꞌl motx itxuqꞌtxuneꞌ tan, kajay nichmotxchꞌian. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ech ul maꞌl u vinaj kꞌatza, Jairo ibꞌii. Qꞌesala tu u atibꞌal chusbꞌal tetz u oꞌtla mantaar. Pecheꞌ kuꞌ vatz u Jesuus. Ijaj bꞌaꞌnil te aas seꞌen tiꞌ tu totzotz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Tan yaꞌvich vimeꞌal vaꞌl taꞌxh maꞌl. Kamal kabꞌlaal iyaꞌbꞌ vimeꞌal tziꞌ. Utz siꞌchtexhkami. Ech bꞌen u Jesuus tiꞌ. Utz vaꞌlich ipitax tu u mam tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Utz atich maꞌl u ixoj xoꞌl u mam tenam tziꞌ, yaꞌvich. Kaj nichtel kꞌatza utz, yeꞌ nichiyaꞌ veꞌteꞌ. Kabꞌlaalich yaꞌbꞌ ixeꞌteꞌ. Utz maꞌtich isotzsat kajay qꞌu tetz atiche tiꞌ itzꞌakat tibꞌ. Pek abꞌil koj nichtoleꞌ tiꞌ itzꞌakaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ech xaan opon tiꞌ iqul u Jesuus. Utz ikanoꞌk ijuꞌ u toksaꞌm. Ech yakich ibꞌan bꞌaꞌn; yaꞌ tel u kaj kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Uncheeꞌ tal tek u Jesuus ech tzaꞌ: —¿Abꞌil vaꞌl vetkanon ok u voksaꞌm?— Texhtuꞌ. Loqꞌ yeꞌxhabꞌil maꞌj nichalon untzꞌoj vetitꞌoka. Ech tal tek u Luꞌ te ech tzaꞌ: —Chusul, «¿Abꞌil vaꞌl vettꞌokonin?» Chaꞌaxh. Utz, u mam tenam nipitonaxh tziꞌ. Tan vaꞌl pochꞌiꞌbꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pek tal u Jesuus ech tzaꞌ: —Atil maꞌl vetkanonokꞌin. Tan vetunnachlaꞌ aas elyu xamlil sunkꞌatza; vetiꞌanlu bꞌaꞌn tu maꞌl aanima.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ech taꞌxh til u ixoj, aas eluꞌl vatzsaj kam vaꞌl iꞌana, ul tek vatz u Jesuus. Vaꞌl itꞌuntꞌuꞌlan tuleꞌ. Pecheꞌ kuꞌ siatz. Utz vatz tenam talva aas kam tokeꞌ ikanoꞌk u toksaꞌm. Utz tala aas tu koꞌxh unmuꞌkꞌul iꞌan bꞌaꞌn. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ech tal tek u Jesuus te ech tzaꞌ: —Tiꞌ koꞌn vikꞌujeꞌ akꞌuꞌl viꞌ vetaꞌanlu bꞌaꞌn txutx. Kuxh, txꞌanel abꞌenaꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Uncheeꞌ tuul ankoꞌxh nichiyolon u Jesuus, ul maꞌl aanima. Aꞌ kꞌaskuꞌl tu otzotz xeꞌ u Jairo, u qꞌesala tu u atibꞌal chusbꞌal tetz u oꞌtla mantaar. Ul tal te ech tzaꞌ: —Kamyu vameꞌal. Yeꞌ koꞌxh akalabꞌtziiu veꞌt u chusul tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tabꞌi u Jesuus utz, tal tu u Jairo ech tzaꞌ: —Yeꞌ koꞌxh qeonaxh. Kꞌujeꞌoj koꞌn akꞌuꞌl viꞌ tan, siꞌan bꞌaꞌn vameꞌal.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ech aatz opon u Jesuus tu atibꞌal, taꞌxh taqꞌ tzii bꞌenoꞌk tiꞌ toꞌotzotz u Luꞌ, u Jacobo, u Xhan, vitat tuchꞌ vinan u ixviak. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tuul nichmotxtoqꞌ kajay qꞌu ilol tiꞌ. Vaꞌl ijiqꞌjoꞌlan tiꞌ. Tal u Jesuus ech tzaꞌ: —Yeꞌ koꞌxh oqꞌex. Tan yitꞌ kamnaj koj. Vatchel kuꞌen atziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Utz nichkoꞌnteesal iqꞌii tiꞌ vaꞌl tala. Tan tootzaj qꞌu aanima aas maꞌt ikameꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pek aatz u Jesuus, itxay iqꞌabꞌ u ixviak utz, tal te ech tzaꞌ: —Ixviak, lakpen.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ech qꞌaavuꞌl taanxelal utz, oora lakpi. Tal tek u Jesuus aas saꞌaqꞌax techbꞌubꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ech tiira tzꞌejx ikꞌuꞌl qꞌul itxutx ibꞌaal u ixviak. Utz tal u Jesuus te aas yeꞌxhabꞌil koꞌxh e satalvu u kam tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Uncheeꞌ isikꞌle opon kabꞌlaal qꞌul ichusulibꞌ u Jesuus kꞌatza. Utz taqꞌ tijleꞌm tuchꞌ iyakꞌil tiꞌ tojchal el tioxhil txꞌiꞌliꞌinaj kꞌatz aanima utz, tiꞌ teesal yaabꞌil. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Utz ichaj bꞌen tiꞌ ipaxsal itziiul viQꞌesalail u Tioxh utz, tiꞌ ibꞌanax bꞌaꞌn tu qꞌu yaꞌv. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Tal bꞌen te ech tzaꞌ: —Yeꞌxhkam setiqꞌo bꞌen tetz ebꞌey. Yeꞌk setiqꞌo ebꞌaara. Yeꞌk setiqꞌo etxim. Nikoꞌxh etechbꞌubꞌal. Nikoꞌxh epuaj. Utz yeꞌk setiqꞌo untzumt etoksaꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Utz til loꞌoponkꞌex tu maꞌj atibꞌal, kaaojex tziꞌ. Analen leꞌelkꞌasuꞌlex aas lakꞌasuꞌlex. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Pek oj til maꞌj tenam yeꞌ lakꞌulaxkꞌex, kꞌasojulex tziꞌ. Pujitajkeꞌl u pojoj tetajan. Techlal aas lakoꞌntila kam layaꞌka.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ech motx kꞌasuꞌl qꞌu chusulibꞌ. Utz motx paal tu kajay qꞌu talaj tenam tiꞌ ipaxsal itziiul u bꞌaꞌnla chusbꞌal. Utz til koꞌxh nichibꞌanvu bꞌaꞌn tu qꞌu yaꞌv. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Uncheeꞌ aatz u Herodes, u governadoor, nichtexhisotz ikꞌuꞌl aas tabꞌi qꞌu kam nichiꞌan u Jesuus. Tan atia nichalon: —U Xhan qꞌaav itzꞌpi xoꞌl qꞌu kamnaj.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","At nichalon: —U Elias cheeya.— Chia. Utz at nichalon: —Maꞌj tu qꞌu oꞌtla alol tetz u yolbꞌal Tioxh aꞌ qꞌaav itzꞌpia tziꞌ.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Utz tal u Herodes ech tzaꞌ: —Kutil el iviꞌ u Xhan vaqꞌo. Pek ¿abꞌil tek vaꞌl nivabꞌi qꞌu kam tiꞌ tziꞌ?— Texhtuꞌ. Ech nichiꞌan yaꞌl satileꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Uncheeꞌ aatz tek qꞌaavuꞌl qꞌu chusulibꞌ tu qꞌul ichaj, motx chit tal tu u Jesuus kajay qꞌu kam qꞌuꞌl iꞌana. Ech ixaanseꞌl tibꞌ u Jesuus tuchꞌ. Motx bꞌen tu maꞌl u tzꞌintzꞌochla txꞌavaꞌ tikuenta Betsaida. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pek taꞌxh tabꞌi qꞌu aanima aas til atilka, motx xambꞌu bꞌen tiꞌ. Ech kꞌulax tu u Jesuus. Utz tal viQꞌesalail u Tioxh te. Utz nichibꞌan bꞌaꞌn tu qꞌu yaꞌv. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Uncheeꞌ aatz tek kuꞌqꞌii, xaan opon qꞌu chusulibꞌ kꞌatza utz, tal te tzaꞌ: —Chaj bꞌen qꞌu aanima tziꞌ. Bꞌenoj ichok techbꞌubꞌal tuchꞌ ivatbꞌal tu qꞌu talaj tenam, tuchꞌ tulaj jaꞌjtzeꞌ tzian chaj bꞌen tziꞌ. Tan tu tzꞌinlich txꞌavaꞌ atilkꞌoꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Loqꞌ tal u Jesuus te ech tzaꞌ: —Aqꞌtaj techbꞌubꞌal tzexeꞌ.— Texhtuꞌ. Utz motx tal ech tzaꞌ: —Yeꞌxhjankꞌal echbꞌubꞌal atil quxeꞌ. Oꞌvaꞌl koꞌxh kaxhlaan txꞌix tuchꞌ kaꞌvaꞌt txay atile. Ech taꞌxhtuꞌ, oj yeꞌk seꞌenoꞌ tiꞌ iloqꞌax echbꞌubꞌal tetz qꞌu tenam tziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tan kamal 5,000 ixaan qꞌu vinaj tziꞌ. Utz tal tek u Jesuus tu qꞌul ichusulibꞌ ech tzaꞌ: —Altaj ikꞌujeꞌ qꞌu aanima tiꞌ tanul tziꞌ. 50 ixaan unchaj tanul sebꞌaneꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ech chit motx iꞌana. Tal ikꞌujeꞌ qꞌu aanima kajayil. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ech itxaytu oꞌvaꞌl qꞌu kaxhlaan txꞌix u Jesuus tiqꞌabꞌ tuchꞌ kaꞌvaꞌt qꞌu txay. Utz sajin jeꞌ tu amlika. Taqꞌ taꞌntioxh tiꞌ. Ech ijatx qꞌu kaxhlaan txꞌix. Taqꞌ tu qꞌul ichusulibꞌ. Utz aatz qꞌu chusulibꞌ, taqꞌ tek tu qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ech motx echbꞌuni sikajayil utz, motx nooi. Ech molax qꞌuꞌl chanani. Kabꞌlaal txakatx elkoꞌp. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Uncheeꞌ aatz iꞌana, nichiqꞌila sikꞌle Tioxh u Jesuus xaannaj el. Utz atich qꞌul ichusulibꞌ kꞌatza. Ech ichꞌoti te ech tzaꞌ: —¿Abꞌil in nital qꞌu aanima tziꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Motx tzaqꞌbꞌu ech tzaꞌ: —At nialon aas axh u Xhan, u bꞌanol vautiismo. At nialon aas axh u Elias. Utz at nialon majte aas aꞌ qꞌaav itzꞌpi maꞌj qꞌu oꞌtla alol tetz u yolbꞌal Tioxh nitaleꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tal u Jesuus te ech tzaꞌ: —Pek aatz ex, ¿abꞌil in netaleꞌ?— Texh te. Tzaqꞌbꞌu u Luꞌ utz, tal ech tzaꞌ: —Axh viTxaaom u Tioxh vaꞌl suꞌuli.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ech tiira tal u Jesuus tu qꞌu chusulibꞌ aas yeꞌxhabꞌil koꞌxh e satalvu u kam tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Utz tal te ech tzaꞌ: —Ministeer sapaal u Kꞌaola vaꞌl bꞌennaj koꞌn aanima tu kꞌaxkꞌo. Saixval tu qꞌu qꞌesal qꞌatol tzii tuchꞌ tu qꞌu qꞌesal oksan yol vatz Tioxh utz, tuchꞌ tu qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar. Ech sakam taqꞌo. Loqꞌ saqꞌaavitzꞌpu titoxvaꞌ qꞌii.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Utz tal te sikajayil ech tzaꞌ: —Oj abꞌil sisaꞌa saok viꞌ, imaj tibꞌ tiꞌ toksal tetz vitxumbꞌal. Siqꞌiꞌ paalchil tu mam il tzaꞌl viꞌ jun qꞌii. Utz xambꞌoj viꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tan abꞌil qꞌuꞌl taꞌxh nititzꞌa u vatz iqꞌii saj tu u vatz txꞌavaꞌ tzaꞌ, tiira aꞌ sitzꞌej u atinchil tu bꞌenqꞌii bꞌensaj. Pek abꞌil qꞌuꞌl kꞌuxh sitzꞌej u vatz iqꞌii saj viꞌ, aꞌ vaꞌl saꞌatin vatz iqꞌii saj tu bꞌenqꞌii bꞌensaj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tan kam koj siꞌan kanaal u aanima kꞌuxh satetza u vatz txꞌavaꞌ kajayil tzaꞌ, untzꞌoj aꞌ sitzꞌej u tatin tu u bꞌenqꞌii bꞌensaj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tan abꞌil vaꞌl sachꞌixveꞌl viꞌ utz, sachꞌixveꞌl tiꞌ vunyolbꞌal, sakoꞌnchꞌixveꞌl u Kꞌaola tiꞌ majte, vaꞌl bꞌennaj koꞌn aanima, aas luꞌul tu u techalla tijleꞌm utz, tu u techalla tijleꞌm viTat tuchꞌ qꞌul iaanjel. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Utz niꞌxhtekꞌvaꞌl sete, atil kaꞌvoꞌj oxvoꞌj ex cheel atziꞌ, atilex tzaꞌ, setil tul viQꞌesalail u Tioxh aas yeꞌsaj ekameꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Uncheeꞌ aatz maꞌtich ipaal vaaxajil qꞌii taltu qꞌu kam u Jesuus tziꞌ, bꞌenjeꞌ u Jesuus viꞌ muunte tiꞌ iqꞌilal isikꞌlel Tioxh. Tiqꞌo bꞌen u Luꞌ tiꞌ, u Xhan, tuchꞌ u Jacobo. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Utz tuul nichiqꞌila isikꞌle Tioxh tziꞌ, jalpu tilon vivatz. Utz bꞌens ribꞌkin saj qꞌu toksaꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Utz yeꞌk talcheꞌ chee kaꞌvaꞌl vinaj kꞌatza. Ayaꞌ u Moisees tuchꞌ u Elias. Utz nichiyolon tuchꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Techalich ipaqꞌun tiꞌaj tu vitechalil u Tioxh. Utz aꞌ nichiyol vikamebꞌal u Jesuus siꞌan tu Jerusaleen. Utz kaniꞌch vitzojpu qꞌu kam siꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Utz kaanaich ikam u Luꞌ tu vataꞌm tuchꞌ qꞌul imol. Loqꞌ motx til vipaqꞌun vitechalil u Jesuus tuchꞌ kaꞌvaꞌl qꞌu vinaj qꞌuꞌl txaklel kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ech tuul nichtelbꞌen kaꞌvaꞌl qꞌu vinaj kꞌatz u Jesuus, tal tek u Luꞌ te ech tzaꞌ: —¡Chusul, aal bꞌaꞌn atiloꞌ tzaꞌ! Ech sakubꞌan oxvaꞌl muuabꞌal nachpixsabꞌal. Maꞌl eetz, vaꞌt tetz u Moisees utz, vaꞌt tetz u Elias.— Texh te. Loqꞌ yeꞌ tootzaj kam nichtaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ech tuul ankoꞌxh nichtal u kam tziꞌ, kuꞌl maꞌl u sutzꞌ tu amlika. Utz yakich motx okojka timuual; isuti tiꞌaj. Utz motx xoꞌvi aas kaa tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ech abꞌil maꞌl u yol tu u sutzꞌ, tal ech tzaꞌ: —Aꞌ vunKꞌaol tiiꞌin tiꞌ atziꞌ. Aꞌ vaꞌl setabꞌi.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Aatz tek yaꞌ u yol tziꞌ, aꞌ texh atinka u Jesuus sijunal. Pek aatz qꞌu chusulibꞌ, motx koꞌn ikol qꞌu kam tziꞌ. Yeꞌxhabꞌil koꞌxh maꞌj e talva. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tu tek vaꞌt qꞌii tuul, aꞌ chit evtich ikꞌasuꞌl viꞌ u muunte, mam tenam ul kꞌulun u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Utz yolon maꞌl u vinaj xoꞌl u tenam, tal ech tzaꞌ: —Chusul, nunjaj bꞌaꞌnil see aas saꞌan bꞌaꞌn tu vunkꞌaol tziꞌ. Tan tiira taꞌxh maꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Utz nikꞌuch tibꞌ maꞌl u tioxhil txꞌiꞌliꞌinaj kꞌatza. Yeꞌk talcheꞌ niqꞌeqꞌun taqꞌo. Nibꞌaj kuꞌ vatz txꞌavaꞌ, yak ikꞌaxbꞌixsa. Nitel vutx itziꞌ taqꞌo. Utz kaana itꞌuntꞌuꞌlan taqꞌo. Peena nitul ikꞌuꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Vetunjaj bꞌaꞌnil tu qꞌul achusulibꞌ tziꞌ aas satojcheꞌl u tioxhil txꞌiꞌliꞌinaj kꞌatza, loqꞌ yeꞌn oleꞌ tiꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Utz tzaqꞌbꞌu u Jesuus, tal ech tzaꞌ: —¡Tiira ex kaꞌtziiunnajla chaj aanima, ex aa paav itzꞌlelex tu u tiempo tzaꞌ! ¿Ech koꞌn chixh vatin texoꞌl tzaꞌ? Utz ¿ech koꞌn chixh unqꞌiꞌtꞌex tziꞌ? Iqꞌo ul vakꞌaol tzaꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ech aatz nichixaan opon u xiak, bꞌajax kuꞌ vatz txꞌavaꞌ tu u tioxhil txꞌiꞌliꞌinaj. Vaꞌl itꞌuntꞌuꞌlan taqꞌo. Pek aatz u Jesuus tan, tojcheꞌl u tioxhil txꞌiꞌliꞌinaj. Ech iꞌan bꞌaꞌn u xiak. Utz taqꞌ tu vitat. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ech kajay aanima motx tzꞌejx ikꞌuꞌl tiꞌ vimam bꞌaꞌnil u Tioxh. Utz kꞌuxh kaana tel taanima qꞌu aanima tiꞌ qꞌu kam nichiꞌan u Jesuus, tal tek tu qꞌul ichusulibꞌ ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Tekꞌ kaaoj u yol sekꞌuꞌl vaꞌl savaleꞌ tzaꞌ. Aatz u Kꞌaola vaꞌl bꞌennaj koꞌn aanima, saoksal tiqꞌabꞌ qꞌu onkonla chaj aanima.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pek nichkojtel itxumbꞌal qꞌu chusulibꞌ tu qꞌu yol tziꞌ. Tan mujel siatz, ech yeꞌk satootzaji u tokebꞌal. Utz nichmotxixoꞌva ichꞌotil u tokebꞌal te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Uncheeꞌ aatz iꞌana tan, xeꞌt motx itxay tibꞌ qꞌu chusulibꞌ tu yol tiꞌ aas abꞌil vaꞌl maas tijleꞌm tixoꞌl nichtaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pek aatz u Jesuus tan, paal itxumbꞌal tu qꞌu kam nichtitzꞌa tu taanima. Ech isikꞌle maꞌl tal nitxaꞌ utz, toksa kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Utz tal tu qꞌul ichusulibꞌ ech tzaꞌ: —Abꞌil aꞌ sakꞌulun u tal nitxaꞌ tunbꞌii tzaꞌ, in aꞌ nikꞌulin tziꞌ. Utz abꞌil vaꞌl nikꞌulunin, aꞌ nikꞌul vaꞌl vetchajonulin. Tan abꞌil vaꞌl sataqꞌ bꞌens tibꞌ chꞌooala texoꞌl, aꞌ vaꞌl maas tijleꞌm siꞌaneꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Uncheeꞌ tzaqꞌbꞌu u Xhan utz, tal te ech tzaꞌ: —Chusul, vetqil maꞌl u vinaj aas nitojcheꞌl txꞌiꞌliꞌinaj tu vabꞌii. Utz vetkumaj iatz tan, yitꞌ xamel koj qiꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Tal u Jesuus te ech tzaꞌ: —Yeꞌ koꞌxh emaj iatz tiꞌ tan, abꞌil qꞌuꞌl yeꞌ nichiꞌkꞌulanoꞌ, kumol atziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Uncheeꞌ aatz nichtekinajabꞌ u tiempo aas saqꞌaavjeꞌ u Jesuus tu Amlika, taꞌn aꞌ itxakbꞌaꞌ, yeꞌk ixoꞌval bꞌen tu Jerusaleen. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ech ibꞌaxabꞌsa bꞌen qꞌul ichaj seꞌnichok ivatbꞌal u Jesuus tala. Utz okoꞌp tu maꞌl u tal tenam tikuenta Samaaria. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Loqꞌ yeꞌt koꞌn kꞌulax tziꞌ. Tan tootzaji qꞌu aa Samaaria aas aalich ibꞌen u Jesuus tu Jerusaleen. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ech taꞌxh til u kam u Jacobo tuchꞌ u Xhan, tal tek ech tzaꞌ: —KuBꞌaal, ¿satz asaꞌ aas saqal ikuꞌl xamal tu amlika? Ech sisotzsa qꞌu aanima tziꞌ, echaꞌ vaꞌl iꞌan u Elias.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ech ipilqꞌu tibꞌ u Jesuus utz, iyaa. Tal te ech tzaꞌ: —Aatz ex, yeꞌ etootzaj kam tioxhil nipitonex tiꞌ vaꞌl netaleꞌ tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Tan yitꞌ aꞌ koj ul isotzsa qꞌu aanima u Kꞌaola vaꞌl bꞌennaj koꞌn aanima, pek aꞌ ul taqꞌ vatz iqꞌii isaj.— Texhtuꞌ. Ech tek motx ibꞌen tu vaꞌt tal tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Uncheeꞌ aatz atich ok u Jesuus tiꞌ bꞌey, alax te tu maꞌl u vinaj ech tzaꞌ: —Unbꞌaal, saxambꞌin saiꞌ kꞌuxh til koꞌxh ech abꞌenaꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Alax te tu u Jesuus ech tzaꞌ: —¿Satz atxꞌakeꞌ? Tan aal atil ijul qꞌu yak sunvatz. Utz atil isok qꞌu tzꞌichin qꞌuꞌl nipaal tu amlika. Pek aatz u Kꞌaola vaꞌl bꞌennaj koꞌn aanima, yeꞌk tatibꞌal tinujul.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Aatz u Jesuus, tal tu vaꞌt u aanima ech tzaꞌ: —Xambꞌen viꞌ cheel.— Texh te. Tzaqꞌbꞌel ech tzaꞌ: —UnBꞌaal, aqꞌ tzii ve analen laxambꞌin saiꞌ kam nal vuntat. Laꞌnalunmujka bꞌaxa.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Utz tal u Jesuus te: —Niꞌaxh viꞌ cheel. Tan aꞌ samujun qꞌu kamchil qꞌuꞌl kamnaj tatin vatz Tioxh. Pek aatz axh, kuxh paxsa itziiul viQꞌesalail u Tioxh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Atil paj vaꞌt alon tu u Jesuus ech tzaꞌ: —Saxambꞌin saiꞌ unBꞌaal. Pek aqꞌ tzii seꞌnunqꞌilaka qꞌu vitzꞌin vatzik tu vatibꞌal bꞌaxa.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Tal u Jesuus te: —Yitꞌ bꞌaꞌn koj tetz viQꞌesalail u Tioxh qꞌuꞌl aꞌ nititzꞌa qꞌaavichil tiꞌ, nisajinka tiꞌ iqul. Echaꞌ u vinaj vaꞌl nitaqꞌonin tu arado. Oj nisajinka tiꞌ iqul, yitꞌ bꞌaꞌnla aqꞌonom koj.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Xamtich tek tiꞌ qꞌu kam tzaꞌ, ichaj paj vaꞌt 70 chusulibꞌ u kuBꞌaal Jesuus. Kaꞌkaꞌbꞌil ixaan ichaj bꞌen. Ibꞌaxabꞌsa bꞌen siatz tu kajay qꞌu tenam tuchꞌ tu kajay qꞌuꞌl siꞌchpaalka. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Utz tal te ech tzaꞌ: —Nojchit tiira sibꞌal qꞌu aanima chꞌiam texh niꞌaneꞌ soꞌok tiꞌ viQꞌesalail u Tioxh. Pek bꞌiil koꞌxh qꞌu paxsan tetz u yolbꞌal Tioxh tixoꞌl. Ech tokeꞌ jajtaj tu u Tioxh, aas sichajuꞌl tereꞌn paxsan itziiul u bꞌaꞌnla chusbꞌal tixoꞌl. Echaꞌ vaꞌl niꞌan u bꞌaal chikobꞌeꞌm aas nitoksa taqꞌonom chokol tetz ivatz qꞌul ichikobꞌeꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ech bꞌenojex. Aꞌ nunchajvubꞌenex xoꞌl chiꞌkꞌulan etetz, echaꞌ ichajax bꞌen karneꞌl xoꞌl lobo. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Etiqꞌoch bꞌen kolbꞌal epuaj. Nikoꞌxh etxim. Nikoꞌxh untzumt epel xaabꞌ. Utz bꞌatziꞌchkoꞌxhex tu yol tu bꞌey. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Abꞌiste koꞌxh maꞌj atibꞌal laꞌokkoꞌpꞌex, aꞌ bꞌaxal letala: «Atinoj u paas xoꞌl qꞌu aanima tu u atibꞌal tzaꞌ.» Chajex. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ech oj atil maꞌj bꞌaꞌn ikꞌuꞌl setiꞌ, saꞌatin u paas kꞌatza. Pek oj yeꞌ nikꞌulviꞌex, saqꞌaavkꞌasuꞌl u bꞌaꞌnil setiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Utz til vaꞌl lakꞌulaxkꞌex, atinojex tuul. Junun koꞌnkoxh atibꞌal ebꞌenaꞌ. Utz kꞌultaj kam etechbꞌubꞌal saꞌaqꞌaxi. Tan aatz u aqꞌonom, aꞌ satxꞌaꞌnku tiꞌ u taqꞌon. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Utz abꞌiste koꞌxh maꞌj tenam loꞌoponkꞌex tu vaꞌl lakꞌulaxkꞌex, echbꞌutaj kam latoksa sevatz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Utz bꞌantaj bꞌaꞌn tu qꞌu yaꞌv qꞌuꞌl atil tu u tenam tziꞌ. Altaj te ech tzaꞌ: «Najabꞌyu tul viQꞌesalail u Tioxh tu Amlika texoꞌl.» Chajex te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pek oj yeꞌ lakꞌulaxex tu maꞌj u tenam loꞌoponkꞌex, elojulex tu qꞌul ibꞌeyil utz, altaj ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","«Nikupujika el u pojoj vaꞌl vetkutzeqꞌ tu vetenam tzaꞌ, techlal aas lakoꞌnetila kam layaꞌkꞌex. Pek etootzajitaj tan, najabꞌy ul viQꞌesalail u Tioxh tu Amlika texoꞌl.» Chajex. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Tan nival sete aas paalchu u choobꞌal paav vaꞌl sakuꞌ tiꞌ qꞌu aanima tu maꞌl u qꞌii tziꞌ, viꞌ vaꞌl kuꞌ tiꞌ u tenam Sodoma oꞌtene. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","¡Tilayol! sayaꞌkꞌex aa Coraziin tuchꞌ ex aa Betsaida. Tan yeꞌ nenima qꞌu mamaj txaichil uch texoꞌl. Pek xoꞌl koj qꞌu puera aanima aa Tiro tuchꞌ qꞌu aa Sidoon vetuchka, koꞌxten ikꞌaxa qꞌul ipaav koj atziꞌ. Samotxtoksa qꞌej oksaꞌm, techlal txumuꞌm. Simakꞌ jeꞌ tzaꞌa tiviꞌ tiꞌ qꞌul ipaav. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ech tok nival sete aatz luꞌul u qꞌii aas satxꞌolpu inujul kajay qꞌu aanima, paalchu u choobꞌal paav sakuꞌ setiꞌ vatz qꞌu aa Sidoon tuchꞌ qꞌu aa Tiiro. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Echat ex majte aa Capernauum. Kamal netaleꞌ aas tiira saoksal eqꞌii. ¡Yeꞌxhjatu! Pek ¡aal aꞌ satzꞌejlikkoꞌpꞌex tu u choobꞌal paav! ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ech abꞌil qꞌuꞌl laꞌabꞌinex, in aꞌ nitabꞌiꞌin tziꞌ. Abꞌil vaꞌl yeꞌk etxaꞌk te, in aꞌ yeꞌk untxaꞌk te tziꞌ. Utz abꞌil vaꞌl yeꞌk untxaꞌk te, aꞌ yeꞌk itxaꞌk te vaꞌl vetchajonkꞌasuꞌlin.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Uncheeꞌ aatz tek qꞌaavuꞌl qꞌu 70 chaj, techalich itxuqꞌtxuneꞌ. Tal tu u Jesuus ech tzaꞌ: —¡KuBꞌaal, ninimaꞌoꞌ qꞌu tioxhil txꞌiꞌliꞌinaj tu vabꞌii!— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tal u Jesuus te ech tzaꞌ: —Vil ichajpu kuꞌl u txꞌiꞌliꞌinaj tu amlika, echaꞌ tel itzꞌnaꞌbꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Pek aatz cheel, vetvaqꞌ etijleꞌm paalchu viꞌ u txꞌiꞌliꞌinaj. Ech sakoꞌnetzeqꞌlebꞌe txꞌiꞌla txokop tuchꞌ chꞌit jee. Utz soꞌoleꞌex tiꞌ isubꞌax u txꞌiꞌliꞌinaj, ayaꞌ u kukoontra. Ech yeꞌxhkam maꞌj siꞌan sete. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pek yeꞌ koꞌxh txuqꞌtxunex tiꞌ aas ninimaꞌex qꞌu tioxhil txꞌiꞌliꞌinaj. Pek aꞌ satxuqꞌtxunkꞌex tiꞌ aas tzꞌibꞌamal qꞌul ebꞌii tu Amlika.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Uncheeꞌ aatz iꞌan tu u oora tziꞌ, txuqꞌtxun u Jesuus tu u Tioxhla Espiiritu. Utz tal ech tzaꞌ: —Nivaqꞌ taꞌntioxh see Tat, axh iBꞌaal u Amlika tuchꞌ u txꞌavaꞌ tziꞌ. Tan vetakꞌuch vatxumbꞌal tu qꞌuꞌl yeꞌk tootzajibꞌal, echaꞌ talaj nitxaꞌ. Utz vetamuj vatz qꞌuꞌl nitoksa jeꞌ iqꞌii tiꞌ qꞌul itxumbꞌal itzakꞌkinil. Aꞌ i Tat tan, aꞌ vasaꞌ tu vabꞌaꞌnil. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Kajay qꞌu kam vettoksal vunTat tunqꞌabꞌ. Utz abꞌil koj tekꞌ ootzajin tetz vitxumbꞌal viKꞌaol u Tioxh, pek taꞌxh vunTat. Utz yeꞌxhabꞌil koꞌxh ootzajin tetz vunTat, pek taꞌxh viKꞌaol. Utz antu saootzajin majte qꞌu aanima abꞌiste isaꞌ viKꞌaol u Tioxh sataqꞌ eluꞌl vatzsaj te.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ech ipilqꞌu tibꞌ. Iqꞌila qꞌul ichusulibꞌ utz, tal te ech tzaꞌ: —Chiꞌbꞌebꞌal tetz qꞌu aanima qꞌuꞌl niꞌilon vaꞌl netileꞌ tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nojchit nival sete aas sibꞌal koꞌxh qꞌu alol tetz u yolbꞌal Tioxh tuchꞌ qꞌu ijlenal, motx tachva tilaxeꞌ tabꞌileꞌ kam vaꞌl netileꞌ etabꞌi cheel tzaꞌ. Pek yeꞌk motx tabꞌi.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Uncheeꞌ aatz iꞌan maꞌl u aa txumbꞌal tiꞌ u oꞌtla mantaar, txakeꞌi. Utz vet sikꞌuꞌl tal tu u Jesuus ech tzaꞌ: —Chusul ¿kam sunbꞌaneꞌ ech soꞌokꞌin tu u atinchil tu bꞌenqꞌii bꞌensaj?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tal u Jesuus te ech tzaꞌ: —¿Kam nital vaꞌl tzꞌibꞌamalka tu u oꞌtla mantaar nasikꞌle?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tzaqꞌbꞌu u vinaj tziꞌ utz, tala: —«Tzꞌejoj avaanima tiꞌ u kuBꞌaal Tioxh, tuchꞌ avaanima, tuchꞌ avaanxelal, tuchꞌ atxumbꞌal utz, tuchꞌ ayakꞌil. Utz tiiꞌaxh tiꞌ vamol saꞌaneꞌ echaꞌ naꞌan saiꞌ.» Chia.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Tal u Jesuus te ech tzaꞌ: —Bꞌaꞌn matzaqꞌbꞌeꞌ vettzaqꞌbꞌaxh. Pek bꞌan axh bꞌanol tetz u kam tziꞌ, ech saꞌatin atiichajil tu bꞌenqꞌii bꞌensaj.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pek aatz u vinaj tziꞌ tan, aꞌ chit isaꞌ taqꞌtu bꞌen tibꞌs bꞌaꞌn. Tal tu u Jesuus ech tzaꞌ: —Utz ¿abꞌil vunmol?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Aatz iꞌan maꞌl u vinaj, aꞌ kꞌaskuꞌl tu Jerusaleen aalich ibꞌen tu Jericoo. Utz txaypu tu elqꞌom. Maaleꞌl qꞌu tetz. Ech akꞌonsalka. Bꞌiit koꞌxh kul ikamsaka. Utz bꞌen qꞌu elqꞌom. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Utz aatz iꞌana, paal maꞌl u oksan yol vatz Tioxh tiꞌ u bꞌey tziꞌ. Til u vinaj kꞌaxbꞌinaj, loqꞌ ijalikoꞌnka tiꞌ paal yakloj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Echat paj vaꞌt u levita majte. Opon najaꞌch vaꞌl atichka. Utz tila, pek paal koꞌn paj yakloj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pek aatz maꞌl u aa Samaaria, atich ok tiꞌ u bꞌey. Opon najaꞌch u vinaj. Utz taꞌxh tila, itxum iatz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ech xaan opon kꞌatza utz, itzꞌaka qꞌu takꞌonbꞌeꞌm. Toksa aseite tiꞌ tuchꞌ taꞌl uuva. Utz ibꞌach u takꞌonbꞌeꞌm. Ech taqꞌ jeꞌ tiꞌ vibꞌuuro. Utz tiqꞌo bꞌen tu vatbꞌal, ech tilbꞌe. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Aatz tek tu vaꞌt qꞌii, taqꞌka puaj u aa Samaaria tu u xeen vatbꞌal, ijaꞌmel kaꞌvaꞌl qꞌii aqꞌon. Utz tal te ech tzaꞌ: «Ilbꞌe vetz. Utz jankꞌit lasotzsa tiꞌ lunchoo see aas laqꞌaavuꞌlin.» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ech ¿abꞌiste maꞌl tu oxvaꞌl qꞌu vinaj tziꞌ nanacheꞌ, aas imol tetz aanimail u vinaj vaꞌl kuꞌ tiqꞌabꞌ elqꞌom?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tal u aa txumbꞌal tiꞌ u oꞌtla mantaar ech tzaꞌ: —Ayaꞌ vaꞌl txumun iatz atziꞌ.— Texhtuꞌ. Aatz u Jesuus, tal te ech tzaꞌ: —Uncheeꞌ kuxh utz, ech saꞌan majte.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Uncheeꞌ aatz atich ok u Jesuus tiꞌ bꞌey tuchꞌ qꞌul ichusulibꞌ, okoꞌp tu maꞌl u tal tenam vaꞌl atichku maꞌl u ixoj Taa ibꞌii. Utz opon tu otzotz tziꞌ xeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Atich maꞌl itzaꞌqꞌ u Taa tziꞌ, Liꞌ ibꞌii. Utz kꞌujeꞌ kuꞌ u Liꞌ xeꞌ tajan u Jesuus tiꞌ tabꞌil qꞌul iyol. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pek aatz u Taa tan, aꞌ vaꞌlich telaꞌ tokku tiꞌ sibꞌal qꞌu taqꞌon. Utz ech xaan opon, tala: —UnBꞌaal, ¿yetz natxum unvatz aas unjunal koꞌxh nivaqꞌonin tu vuntzaꞌqꞌ tziꞌ? Pek al te aas silochꞌin.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tzaqꞌbꞌu u Jesuus utz, tal te ech tzaꞌ: —Taa, Taa, tiira bꞌennaj akꞌuꞌl. Utz vaꞌl eelaꞌ ook tiꞌ sibꞌal kam. ");
INSERT INTO ixlCNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pek maꞌl koꞌn u kam vaꞌl tiira ministeer sabꞌanaxi. Utz ayaꞌ vaꞌl niꞌan u Liꞌ tziꞌ. Utz yeꞌk saveet imaaleꞌl te.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Uncheeꞌ aatz iꞌana, nichiqꞌila sikꞌle Tioxh u Jesuus tu maꞌl u tal txꞌavaꞌ. Utz aatz yaꞌi, alax te tu maꞌl qꞌul ichusulibꞌ ech tzaꞌ: —KuBꞌaal, chus qe kaniꞌch iqꞌilal isikꞌlel Tioxh sakubꞌaneꞌ. Echaꞌ iꞌan u Xhan, ichus qꞌul ichusulibꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Alax te tu u Jesuus ech tzaꞌ: —Aatz seqꞌila esikꞌle Tioxh, ech setal tzaꞌ: «KuBꞌaals Amlika tioxhla bꞌii tatin vabꞌii. Uloj abꞌan vaQꞌesalail. Utz bꞌan vatxumbꞌal tu u vatz txꞌavaꞌ tzaꞌ, echaꞌ naꞌan tu Amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Aqꞌ u qechbꞌubꞌal tetz jun qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Utz kuy qꞌu kupaav, echaꞌ oꞌ nikukuy qꞌu aanima qꞌuꞌl kam niꞌan qe. Yaaqꞌ tzii sakuꞌoꞌ tu qꞌu paav qꞌuꞌl nitok sukuvatz. Pek eesaꞌoꞌ vatz u txꞌiꞌliꞌinaj.» Chajex.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Utz tal paj ech tzaꞌ: —Sakukꞌam tiꞌ aas atil maꞌl sete atil maꞌl tamiigo. Utz sabꞌen tzixeꞌ nikꞌa aqꞌbꞌal. Satal te ech tzaꞌ: «Vamiigo, unchꞌex oxvoꞌj unkaxhlaan txꞌix see. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Tan ulyu koꞌn maꞌl vamiigo tzunxeꞌ. Tzian vetkꞌaskuꞌl utz, yeꞌxhkam bꞌoj savaqꞌ te.» Chaj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Pek sakoꞌntzaqꞌbꞌu eluꞌl u vinaj toꞌotzotz ech tzaꞌ: «Yeꞌxh saveeti. Utz yeꞌ koꞌxh akalabꞌtziiuꞌin tan, vatchelin tuchꞌ unnitxaꞌa. Katxꞌumal tek kujubꞌal. Utz ech yeꞌk saveet unlakpu tiꞌ en taqꞌax see.» Chaj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ech kꞌuxh yeꞌk salakpi sataleꞌ, salakpi atziꞌ. Utz sataqꞌ te kam nisavsa. Kamal yitꞌ tiꞌ koj aas tamiigo; pek tiꞌ tan, chꞌixvebꞌal oj yeꞌk sataqꞌeꞌ tan, niyaꞌluleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ech tok nival sete aas jajtaj tu u Tioxh kam nesavsa utz, sataqꞌ sete. Choktaj utz, sechabꞌa. Sichꞌinojex vatz jubꞌal utz, sajajaxex. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tan abꞌil vaꞌl kam nijajeꞌ, nikꞌuleꞌ. Abꞌil nichokoneꞌ, nichabꞌa kam nichokeꞌ. Utz abꞌil vaꞌl nisichꞌineꞌ, nijajax u jubꞌal siatz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Echaꞌ maꞌj tat. Jatu koj siꞌaneꞌ aas sivan koꞌn sataqꞌ tu vikꞌaol vaꞌl nijaj ikaxhlaan txꞌix te. Utz oj chiꞌo txay sijajeꞌ, ¿tzꞌoj tzik txꞌiꞌla txokop sataqꞌ te? ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Oj maꞌj kꞌolobꞌ sijajeꞌ, ¿tzꞌoj tzik chꞌit jee sataqꞌ te? ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tan kꞌuxh ex chit maalola chaj aanima, etootzajle kam bꞌaꞌnla chaj oya netaqꞌ tu qꞌul enitxaꞌa utz; ¿aꞌ chixh u kuTat tu Amlika nenacheꞌ tziꞌ aas yeꞌ koj sataqꞌ u Tioxhla Espiiritu tu qꞌuꞌl sajajon te?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Uncheeꞌ tojcheꞌl maꞌl tioxhil txꞌiꞌliꞌinaj u Jesuus kꞌatz maꞌl u vinaj, memtixsamich taqꞌo. Utz taꞌxh el u tioxhil txꞌiꞌliꞌinaj tziꞌ, yakich yolon u vinaj. Utz motx chit tzꞌejx ikꞌuꞌl qꞌu tenam tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pek at unjolol qꞌu aanima alon tiꞌ ech tzaꞌ: —U Belzebuu, viqꞌesal qꞌu txꞌiꞌliꞌinaj, nilochon tiꞌ tojchal el qꞌu tioxhil txꞌiꞌliꞌinaj atziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Utz atia vet sikꞌuꞌl nichiꞌaneꞌ nichijaj xheenya te tu amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pek paal itxumbꞌal u Jesuus tu vaꞌl nichtitzꞌa qꞌu aanima tziꞌ. Tal tek ech tzaꞌ: —Kajay ijlenal, oj jatxel tibꞌ iatz tuchꞌ qꞌul imol tu viqꞌesalail, sakoꞌnjinkꞌi. Echaꞌ unjolol itzꞌin atzik tu atibꞌal majte. Oj jatxel tibꞌ iatz, saꞌkojveet tatin tinujul tibꞌilaj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nival u kam sete tziꞌ tan, netaleꞌ aas aꞌ nilochonin u Belzebuu, u qꞌesal txꞌiꞌliꞌinaj. Tan oj atoꞌk ixoꞌl u txꞌiꞌliꞌinaj tibꞌilaj, saꞌkojveet iqꞌesalain tinujul. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ech oj u Belzebuu qꞌesal txꞌiꞌliꞌinaj, nilochonin tiꞌ tojchal el qꞌu tioxhil txꞌiꞌliꞌinaj netaleꞌ, ¿aꞌ paj tzik nilochon qꞌu aanima tiꞌ tojchal el majte qꞌuꞌl nechuseꞌ? Ech aꞌ samotxalon atziꞌ aꞌ tzik nilochonin. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pek oj tu vitxumbꞌal u Tioxh nivojchav el qꞌu tioxhil txꞌiꞌliꞌinaj, aꞌ u techlal atziꞌ aas nojchit ulyu viQꞌesalail u Tioxh texoꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Echaꞌ maꞌj xeen otzotz aa yakꞌilla vinaj iqꞌomal bꞌanbꞌal ichꞌaꞌo nixee tatibꞌal, bꞌaꞌn koꞌxh tatin qꞌu tetz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pek aatz niqꞌilal ok tu vaꞌte aas maas aqꞌel iviꞌ siiꞌ utz, nisubꞌeꞌ. Nimaa qꞌu bꞌanbꞌal ichꞌaꞌo vaꞌl kꞌujlelk ikꞌuꞌl. Ech nitoleꞌ tiꞌ qꞌu tetz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ech abꞌiste a yitꞌ oknaj koj viꞌ, koontraimalin niꞌaneꞌ. Utz abꞌiste vaꞌl yitꞌ antu koj sunkꞌatza tiꞌ vaꞌl nunbꞌaneꞌ, tzꞌejoꞌm niꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Aatz nitel u tioxhil txꞌiꞌliꞌinaj kꞌatz maꞌl aanima, nichok tilanbꞌal tu tzaji txꞌavaꞌ. Utz aatz yeꞌ nichabꞌa, nital ech tzaꞌ: «Saqꞌaavbꞌenin tu u vatibꞌal vaꞌl vetkꞌaskuꞌlin.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ech aatz nipajtoponeꞌ, nitileꞌ echaꞌ bꞌaꞌnla chꞌisel utz, vijel tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ech nitiqꞌo opon jujvaꞌt imol tiꞌ aas aqꞌel iviꞌ siiꞌ. Ech taꞌn oponya. Aꞌ tek nimotxatinku tziꞌ. Ech maas nitel u aanima tu bꞌey taqꞌo vatz u tatin bꞌaxa.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Tuul koꞌxh nichtal qꞌu kam tzaꞌ, aatz maꞌl u ixoj xoꞌl u mam tenam, qetun taltu ech tzaꞌ: —¡Chiꞌbꞌebꞌal tetz u ixoj vaꞌl alannaj eetz tuchꞌ u chꞌuꞌ vaꞌl achꞌuꞌa!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Tal u Jesuus ech tzaꞌ: —Aal aꞌ chiꞌbꞌebꞌal tetz qꞌuꞌl niabꞌin u yolbꞌal Tioxh utz, niꞌaneꞌ kam vaꞌl nitaleꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Pochꞌiꞌbꞌich chit tatin qꞌu mam tenam. Xeꞌt tal u Jesuus tixoꞌl ech tzaꞌ: —Aatz ex, itzꞌlelex tu u tiempo tzaꞌ, ex aa paav. Aꞌ nimotxechok xheenya tu amlika. Pek taꞌxh xheenya setileꞌ echaꞌ vaꞌl tiꞌ u Jonaas. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tan aꞌich xheenya vatz qꞌu aa Niinive u Jonaas. Echat siꞌan u Kꞌaola majte vaꞌl bꞌennaj koꞌn aanima. Aꞌ u xheenya tetz qꞌu aanima itzꞌlel tu u tiempo tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Aatz u ixoj ijlenal tikuenta aal ikuꞌeꞌ, toj nal tal ebꞌen tu choobꞌal paav, ex itzꞌlelex tu u tiempo tzaꞌ. Tan yaꞌviloꞌm kꞌaskuꞌl tiꞌ ul tabꞌil vimam txumbꞌal u Salomoon. Pek paalchu vijleꞌm vatz u Salomoon atilin tzaꞌ utz, yeꞌ nenimaꞌin. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Echat qꞌu aa Niinive majte, toj nal tal ebꞌen tu choobꞌal paav, ex itzꞌlelex tu u tiempo tzaꞌ aas latxꞌolax inujul qꞌu aanima. Tan motx ikꞌaxa qꞌul ipaav tu u yolbꞌal Tioxh vaꞌl ex tal u Jonaas tixoꞌl. Pek aatz ex, yeꞌ nekꞌaxa qꞌul epaav tiꞌ qꞌu yol nival sete tzaꞌ. Utz paalchu vijleꞌm vatz u Jonaas. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yeꞌxhabꞌil nibꞌanon aas nikoꞌnkojimuj u txijtxubꞌal vaꞌl nimatxeꞌ. Utz saꞌkojijupi. Pek nitꞌanbꞌaꞌ jeꞌ. Ech satil qꞌu aanima qꞌuꞌl nitokoꞌp toꞌotzotz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Aatz u bꞌaqꞌ evatz, aꞌ nikꞌuchun qꞌu kam tu vechiꞌl. Utz oj jikom isajil qꞌu kam nebꞌan tuchꞌ u bꞌaqꞌ evatz, yeꞌxhkam netitzꞌa onkonil tiꞌ. Echaꞌ vatz maꞌj txijtxubꞌal atilkꞌex. Pek oj yitꞌ jikom koj isajil qꞌu kam nebꞌaneꞌ, aꞌ chit netitzꞌa onkonil tiꞌ. Echaꞌ tu uken atilkꞌex. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ech kuentaꞌex tan, bꞌaꞌn siꞌaneꞌ aas yitꞌ bꞌaꞌn koj isajil qꞌu kam nebꞌaneꞌ utz, tu uken atilkꞌex. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Oj tiira jikom etatineꞌ, bꞌaꞌn isajil qꞌu kam nebꞌaneꞌ atziꞌ. Echaꞌ itxijtxutꞌex maꞌj txijtxubꞌal. Yeꞌxh bꞌoj uken sekꞌatza.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Aatz tek yaꞌ iyolon u Jesuus, savsal tu maꞌl u fariseo aas seꞌntxꞌaꞌn tzixeꞌ. Ech bꞌen u Jesuus tu totzotz utz, ok vatz meexha. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Pek sotz ikꞌuꞌl u fariseo aas tila yeꞌt iꞌan u kostuumbre u Jesuus tiꞌ itxꞌaal iqꞌabꞌ aas yeꞌsajich itxꞌaꞌneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ech aatz u kuBꞌaal Jesuus tal te ech tzaꞌ: —Aatz cheel, ex fariseo, tiira bꞌaꞌn nebꞌensav etibꞌ setiꞌ eluꞌl, echaꞌ u vaaso tuchꞌ u puraato aas taꞌxh txꞌaael u tiꞌ. Pek aatz tetaanima, taꞌxh elaqꞌ atile utz, yeꞌk eyaꞌebꞌal tiꞌ ibꞌanax qꞌu kam qꞌuꞌl yitꞌ inujul koj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Ex txoxkin! ¡Yetz etootzaj tzik aas taꞌn koꞌn koj u kuchiꞌl iꞌan u Tioxh, pek iꞌan u qaanima majte! ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pek cheeoj qꞌu bꞌaꞌnil te taanima, lochtaj meꞌbꞌaꞌ. Aꞌ u oya setaqꞌ tu u Tioxh. Ech txꞌaatxꞌoch etatin vatz u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Tilayol sayaꞌkꞌex, ex fariseo! Tan netaqꞌ idiesmoil u ruda, u meenta utz, tuchꞌ kajay qꞌu itza. Loqꞌ aꞌ netaqꞌka qꞌuꞌl tiira ibꞌoꞌqꞌol. Ayaꞌ vijikomal tuchꞌ vetzꞌejtu etaanima tiꞌ u Tioxh. Aꞌ vibꞌoꞌqꞌol sebꞌaneꞌ tziꞌ. Loqꞌ yitꞌ tiꞌ koj aas seyaꞌsa ibꞌanax qꞌu kam qꞌuꞌl ninalebꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Tilayol sayaꞌkꞌex, ex fariseo! Tan aꞌ chit nechok qꞌu bꞌaxa chaj kꞌujlebꞌal tu u atibꞌal chusbꞌal tetz u oꞌtla mantaar. Utz vatz chit ekꞌuꞌl saꞌxhkalaman taqꞌax echajlichil tulaj kꞌayibꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Tilayol sayaꞌkꞌex, ex fariseo tuchꞌ ex aa txumbꞌal tetz u oꞌtla mantaar! Ex kaꞌvatz tan, ech ex qꞌu mujbꞌal kamnaj aas yeꞌ naꞌl kam qꞌeꞌnaꞌj atil tuul. Kꞌuxh nipaal aanima siiꞌ, yeꞌ tootzaj aas yansaibꞌ niꞌan taqꞌo.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ech tzaqꞌbꞌu tek maꞌl u aa txumbꞌal tiꞌ u oꞌtla mantaar ech tzaꞌ: —Chusul, aatz naal qꞌu kam ech tziꞌ, ant oꞌ nayaaꞌoꞌ majte.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ech tal u Jesuus te ech tzaꞌ: —¡Tilayol sayaꞌkꞌex majte, ex aa txumbꞌal tiꞌ u oꞌtla mantaar! Tan kaana bꞌoj mantaar netal tu aanima aas tiira tii nimali. Taꞌxhtuꞌ netaleꞌ aas sabꞌanli. Echaꞌ iqitzax maꞌj mam ijatz aas taꞌn aꞌ netaqꞌ jeꞌ tiꞌ iviꞌ aanima, pek jatu koj seloch bꞌoj tiꞌ tijaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Tilayol sayaꞌkꞌex! Tan vaꞌl chit ebꞌantu pantioon tetz qꞌu alol tetz u yolbꞌal Tioxh qꞌuꞌl kamnaj, qꞌul ekꞌuy emam yatzꞌon. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ech netxakbꞌaꞌ utz, nekꞌucheꞌ aas ant ex tiꞌ vibꞌanon qꞌul ekꞌuy emam. Tan nojchit aꞌ motx yatzꞌon utz, aatz ex, nebꞌan ipantioonil qꞌu mujbꞌal tetz majte. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ech tokeꞌ tal u Tioxh tu u mam itxumbꞌal: «Sunchaj bꞌen alol tetz vunyolbꞌal tixoꞌl tuchꞌ unchaj. Atia satojcha utz, atia sakoꞌnmotxiyatzꞌeꞌ.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Utz saꞌanaltxꞌolax inujul qꞌu aanima qꞌuꞌl itzꞌlel tu u tiempo tzaꞌ tan, ech itxumbꞌal qꞌul ikꞌuy imam, tiꞌ iyatzꞌax sibꞌal qꞌu alol tetz vunyolbꞌal, jatvaꞌx tiempo ichee u vatz amlika txꞌavaꞌ tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Aꞌ saxeꞌtik u choobꞌal paav tiꞌ vikam u Abeel utz, sayaꞌ tu vikamebꞌal u Zacarias, vaꞌl yatzꞌax tu qꞌul ekꞌuy emam tixoꞌl u totztioxh tuchꞌ u nachbꞌal Tioxh qꞌanal. Ech nojchit vaꞌl nivaleꞌ tzaꞌ. Aꞌ vaꞌl sichoo qꞌu aanima itzꞌlel tu tiempo tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Tilayol sayaꞌkꞌex, ex aa txumbꞌal tiꞌ u oꞌtla mantaar! Tan yeꞌ netal vinujul u tokebꞌal u yolbꞌal Tioxh tu qꞌu aanima. Nikoꞌnemujeꞌ. Echaꞌ imaal maꞌl laave tetz okebꞌal nebꞌaneꞌ. Pek nikoꞌxh aꞌ koj ex netokoꞌp. Utz nemaj tok qꞌuꞌl nichok tokoꞌp.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Aatz tek yaꞌ iyolon u Jesuus tziꞌ, motx ichok ixeꞌt qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar kꞌatza tuchꞌ qꞌu fariseo. Utz nichmotxiyaꞌlu u Jesuus. Aꞌ isaꞌ aas kam texh yolpichil siꞌan u Jesuus tu yol. ");
INSERT INTO ixlCNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ech liistaich tiꞌ oj sayolpi, ech sixoch jeꞌ tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Uncheeꞌ tuul atich u Jesuus tziꞌ, mam tenam imol tibꞌ tiꞌ. Jatvaꞌl koꞌn mil ixaaneꞌ. Vaꞌlich motx ipittu tibꞌ. Utz xeꞌt iyolon u Jesuus bꞌaxa, tu qꞌul ichusulibꞌ ech tzaꞌ: —Kuentaꞌex tiꞌ vichusbꞌal qꞌu fariseo tziꞌ. Tan tiira jolol kaꞌvatz. Nibꞌoy aanima echaꞌ ibꞌoyon u txꞌamtixsabꞌ kaxhlaan txꞌix. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tan kam vaꞌl sajutzil ibꞌanaxeꞌ saeluꞌl vatzsaj. Utz kajay vaꞌl mujich kam, saꞌabꞌili. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Echaꞌ qꞌu kam qꞌuꞌl tu mujich netalva, vatzsaj tek tabꞌil saꞌabꞌili. Utz kam vaꞌl jas koꞌn talax nebꞌan tu atibꞌal, qetumal tek talax saꞌalax vatz tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Pek nival sete kajay ex vamiigo, yeꞌ koꞌxh exoꞌva qꞌu yatzꞌol tetz u chiꞌl. Tan kꞌuxh maꞌt iyatzꞌoneꞌ, kam tereꞌn koj vaꞌt siꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pek saval sete abꞌil vaꞌl sexoꞌva. Aꞌ sexoꞌva u Tioxh vaꞌl yitꞌ taꞌn koꞌn koj atil tijleꞌm tiꞌ teesal u vatz qꞌii saj, pek atil tijleꞌm tiꞌ taqꞌax bꞌen u taanxelal u aanima tu xamal, ayaꞌ u choobꞌal paav. ¡Ech aꞌ vaꞌl sexoꞌva! ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Echaꞌ qꞌu talaj tzꞌichin. Kꞌuxh tiira varaato ijaꞌmel, oꞌvaꞌl tiꞌ kaꞌl sentaavo, nikoꞌxh maꞌj sotznaj tekoj sikꞌuꞌl u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Aal tootzajle jatvaꞌl tachul u xiꞌl eviꞌ. Ech tokeꞌ yeꞌ koꞌxh xoꞌvex tan, paalchu ejaꞌmel vatz sibꞌal talaj tzꞌichin. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Utz nival sete, abꞌil qꞌuꞌl saꞌalon tu qꞌu aanima aas niman vetz, aꞌ qꞌuꞌl saꞌalax vatz qꞌul iaanjel u Tioxh majte tu u Kꞌaola vaꞌl bꞌennaj koꞌn aanima aas aꞌ qꞌu niman vetz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pek aatz qꞌuꞌl niteesa tibꞌ tuul vatz aanima aas tootzajin, saveesa vibꞌ tuul vatz qꞌul iaanjel u Tioxh majte aas vootzajle. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Utz abꞌil vaꞌl sayoqꞌon u Kꞌaola vaꞌl bꞌennaj koꞌn aanima, sakuyli. Pek ech koj qꞌuꞌl saqelon sayoqꞌon u Tioxhla Espiiritu, yitꞌ saꞌkojkuyli. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Utz aatz latxaypꞌex viꞌ, liꞌiqꞌoloponex tu qꞌu atibꞌal chusbꞌal tetz u oꞌtla mantaar, elaꞌ okiꞌch koꞌxh etaanima tiꞌ aas kam ech etzaqꞌbꞌeꞌ utz, kam setaleꞌ. Echat koꞌxhtuꞌ aas liꞌiqꞌoloponex vatz juees tuchꞌ vatz qꞌu qꞌatol tzii. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tan u Tioxhla Espiiritu sacheesan eyol tu u muꞌkꞌul tziꞌ aas kam setaleꞌ.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Alax tu u Jesuus tu maꞌl u aanima xoꞌl qꞌu tenam ech tzaꞌ: —Chusul, al tu vatzik sijatx u meꞌbꞌiꞌl vaꞌl aqꞌaxka qe. Sataqꞌ u vetz.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Tal u Jesuus te ech tzaꞌ: —Vinaj, abꞌil koj nioksanin qꞌatol tziil texoꞌl utz, jatxol tetz kam.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tal paj u Jesuus ech tzaꞌ: —Kuentaꞌex, yeꞌ koꞌxh ebꞌana aas yeꞌk enooebꞌal tiꞌ qꞌu kam. Tan yitꞌ aꞌ koj niaqꞌon u vatz iqꞌii saj u aanima qꞌu txꞌiibꞌal iqꞌii atile.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ech ikꞌam tiꞌ maꞌl kam tal ech tzaꞌ: —Atich maꞌl u vinaj txꞌiiol iqꞌii. Sibꞌal chit vatz ichikobꞌeꞌm teesa tu vitxꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ech nichtitzꞌa tiꞌ taanima ech tzaꞌ: «¿Kam sunbꞌaneꞌ? Tan yeꞌ nichee veꞌt kolbꞌal tetz vivatz qꞌul unchikobꞌeꞌm tziꞌ.» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Itzaqꞌbꞌe jeꞌ tibꞌ tal ech tzaꞌ: «Aatz sunbꞌaneꞌ. Sunyoo qꞌu kolbꞌal ivatz qꞌul unchikobꞌeꞌm qꞌuꞌl atilnale utz, paalchu tek ichꞌii ichꞌexel siiꞌ sunbꞌaneꞌ. Ech tuul sunkolvu kajay qꞌul ivatz qꞌul unchikobꞌeꞌm utz, qꞌu vetz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Utz laꞌtekval tu u vaanxelal ech tzaꞌ: Vaanxelal, sibꞌal txꞌiibꞌal aqꞌii kolel tetz sibꞌal yaꞌbꞌ. Ech ilan, echbꞌun, ukꞌaꞌen utz, txuqꞌtxunen. Chajin.» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pek tal u Tioxh te ech tzaꞌ: «¡Txoxkin! Tu u aqꞌbꞌal cheel tzaꞌ sakamaxh. Utz ¿abꞌil tek etz qꞌu kam siꞌaneꞌ qꞌuꞌl vetachokluka tziꞌ?» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ech sayaꞌk u aanima tziꞌ vaꞌl nikoꞌxhimolbꞌaꞌ txꞌiibꞌal iqꞌii, loqꞌ yitꞌ txꞌiiol iqꞌii koj kꞌatz Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Tal u Jesuus tu qꞌu chusulibꞌ ech tzaꞌ: —Ech tokeꞌ yeꞌ koꞌxh elaokꞌex tiꞌ u vatz eqꞌii esaj. Echaꞌ tziꞌ aas kam setechbꞌu. Utz yitꞌ sakoꞌnkoxhelaꞌokꞌex tiꞌ ivijax vechiꞌl, tiꞌ aas kam setoksa. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tan aatz u vatz qꞌii saj, paalchu vatz u echbꞌubꞌal. Utz paalchu vechiꞌl vatz u oksaꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pek sajitaj qꞌu joo etileꞌ. Tan yeꞌkax chikoni. Yeꞌkax imol vatz ichikobꞌeꞌm. Utz yeꞌk kolbꞌal titzꞌlebꞌal. Pek u Tioxh nitzujbꞌen. Utz ¿yitꞌ tzik paalchꞌex vatz qꞌu tzꞌichin tziꞌ tzik? ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Tan kꞌuxh saꞌxhelaꞌok maꞌj aanima, saꞌtekojveeti sataqꞌ jeꞌop bꞌitoj u tatin tu u vatz iqꞌii saj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tan oj yeꞌ netxꞌol qꞌu kam qꞌuꞌl talaj chꞌoo, ¿kam tokeꞌ sakoꞌxhelaꞌokꞌex tiꞌ tereꞌn qꞌu kam? ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Sajitaj qꞌu xuꞌm etileꞌ, kaniꞌch ichꞌiieꞌ. Tan yeꞌkax aqꞌonini, yeꞌkax chemoni. Pek nival sete aas nikoꞌxh u ijlenal Salomoon ech koj ivijtu tibꞌ u tilon qꞌu xuꞌm tziꞌ, kꞌuxh mam txꞌiiol iqꞌiich. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Echat koꞌxh paj qꞌu xajtzeꞌ jaꞌjtzeꞌ. U Tioxh nivijon kꞌuxh atil cheel utz, ech tek qꞌejal nikꞌachpu tu xamal. Ech ¿yitꞌ tzik ech taqꞌax etoksaꞌm siꞌan u Tioxh nenacheꞌ? ¡kꞌuxh bꞌioj koꞌxh kꞌujlel ekꞌul tiꞌ! ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ech yeꞌ koꞌxh elaꞌokꞌex tiꞌ qꞌu kam. Echaꞌ tiꞌ kam setechbꞌu utz, kam setukꞌa. Yitꞌ maas koj saxaan etaanima tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tan kajay qꞌu kam ech tziꞌ, nitelaꞌ tok qꞌu aanima tiꞌ qꞌuꞌl yeꞌk Tioxh kꞌuꞌl tu u vatz txꞌavaꞌ tzaꞌ. Pek ech koj ex tan, tootzajle u kuTat tziꞌ aas nesavsa kajay qꞌu kam tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Pek aꞌ saelaꞌokkꞌex tiꞌ viQꞌesalail u Tioxh, ech toj texh taqꞌ tul tereꞌn qꞌu kam nesavsa. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yeꞌ koꞌxh qeonex niman vetz tan, kꞌuxh bꞌiil koꞌxh ex, vettitzꞌal u kuTat aas saꞌxhekꞌul viQꞌesalail. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ech tokeꞌ kꞌayitaj kam etetz atile. Utz oyataj tetz meꞌbꞌaꞌ. Bꞌantaj kolbꞌal txꞌiibꞌal eqꞌii aas yeꞌk saqꞌaꞌlbꞌi. Ayaꞌ u txꞌiibꞌal qꞌii tu Amlika vaꞌl yeꞌk imotxeꞌ. Tan yeꞌ nitokoꞌp elqꞌom tziꞌ. Nikoꞌxh pokꞌ sayansan. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tan til vaꞌl atilku u txꞌiibꞌal eqꞌii, ayeꞌn vetaanima tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Pek aatz ex utz, itzꞌoj koꞌxh etatineꞌ. Bꞌanoj koꞌxh etucheꞌ. Echaꞌ bꞌanel koꞌxh tuch etxijtxubꞌal. Bꞌantajex echaꞌ qꞌu aqꞌonom qꞌuꞌl chꞌiam koꞌxh nimotxiꞌaneꞌ. Aꞌ nichꞌia iqꞌaavuꞌl u bꞌaal taqꞌon tu maꞌj tzumbꞌaꞌa. Utz taꞌxh luꞌuli, lasikꞌleni, yak koꞌxh sajajaxoj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ech chiꞌbꞌebꞌal tetz qꞌu aqꞌonom qꞌuꞌl chꞌiam chit niꞌaneꞌ aas luꞌul u bꞌaal taqꞌon. Utz niꞌxhtekꞌval sete, aatz u bꞌaal aqꞌon, satal ikꞌujeꞌ qꞌu taqꞌonom vatz meexha utz, ech aꞌ saꞌaqꞌon techbꞌubꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Tan kꞌuxh yeꞌsaj inikꞌat aqꞌbꞌal utz, kꞌuxh paal nikꞌat aqꞌbꞌal luꞌuli, taꞌxhtzii nichꞌianeꞌ. Chiꞌbꞌebꞌal tetz u aqꞌonom siꞌaneꞌ tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pek abꞌitaj. Tootzajle koj u bꞌaal atibꞌal aas kam chit oora seꞌnelqꞌoj u elqꞌom tzixeꞌ, saxeeni atziꞌ. Utz saꞌkojtaqꞌ tzii aas soꞌok toꞌotzotz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Echat koꞌxh ex majte. Chꞌianojex. Tan yeꞌk u oora sekꞌuꞌl, u tulebꞌal u Kꞌaola vaꞌl bꞌennaj koꞌn aanima.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Aatz u Luꞌ, tal te ech tzaꞌ: —KuBꞌaal, ¿qe koꞌn chixh naalvu qꞌu kam nakꞌam tiꞌ tziꞌ, pek oj tu kajay qꞌu aanima majte?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","43","Tal u kuBꞌaal te ech tzaꞌ: —Chiꞌbꞌebꞌal tetz u aqꞌonom oj ech siꞌaneꞌ kam vaꞌl alaxka te tu u bꞌaal taqꞌon. Tzakꞌkin utz, kꞌujlebꞌal kꞌuꞌlla aqꞌonom atziꞌ oj tu chit oora sataqꞌvu techbꞌubꞌal qꞌuꞌl atil tu u atibꞌal. Jikom niꞌaneꞌ aas loꞌopon u bꞌaal taqꞌon. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tan nojchit nival sete, aal saꞌtektoksa kajay vimeꞌbꞌiꞌl tikuenta atziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pek yeꞌxtxoj koj itxumbꞌal u aqꞌonom tziꞌ, oj laꞌkoꞌntal tu taanima ech tzaꞌ: «Sabꞌatz tul u bꞌaal vaqꞌon atziꞌ.» Chaj. Utz sakoꞌnxeꞌtiqꞌos qꞌu aqꞌonom, vinajs ixoj. Sakoꞌnechbꞌuni saukꞌai. Utz saqꞌabꞌani. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Tuul yeꞌk talcheꞌ suꞌul u bꞌaal taqꞌon u aqꞌonom tziꞌ, tu u qꞌii vaꞌl yeꞌ tootzaj utz, tu u oora vaꞌl yeꞌxhkam nichꞌianeꞌ. Techal iveet sabꞌanax tu u bꞌaal taqꞌon. Sataqꞌ bꞌen xoꞌl qꞌu qelol, qꞌuꞌl yitꞌ kꞌujlebꞌal kꞌuꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Aatz u aqꞌonom, sibꞌal tzꞌuꞌm saꞌaqꞌax te. Tan tootzaj nal itxumbꞌal u bꞌaal taqꞌon, loqꞌ yeꞌ nichꞌianeꞌ. Yeꞌt iꞌana kam vaꞌl isaꞌ u bꞌaal taqꞌon. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pek ech koj u aqꞌonom vaꞌl yeꞌ tootzaj itxumbꞌal u bꞌaal taqꞌon, bꞌiil koꞌn tzꞌuꞌm saꞌaqꞌax te tiꞌ qꞌu kam vetiꞌana kꞌuxh sikꞌuloꞌk tiꞌ aas sibꞌla tzꞌuꞌm saꞌaqꞌax te. Tan abꞌil vaꞌl sibꞌ aqꞌax te tu u Tioxh, sibꞌal sijaj u Tioxh te majte. Echat koꞌxhtuꞌ, oj abꞌil sibꞌal kam nitaqꞌaxka tikuenta, saꞌxhjajax te majte kam tiꞌ vettoksav vaꞌl vetaqꞌax te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Xamal ul unmatx tu u vatz amlika txꞌavaꞌ tzaꞌ. Utz aꞌ unsaꞌ aꞌ tekoj cheel vaꞌl toyveꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Sapaalin tu maꞌl mam tzaꞌl. Utz il atilin taqꞌo, tiqꞌo nal tibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kamal aꞌ netitzꞌa aas taꞌxh ul voksa paas xoꞌl qꞌu aanima tu u vatz txꞌavaꞌ tzaꞌ. Yeꞌka. Pek xoꞌl ul voksa. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tan aatz taabꞌabꞌen tzaꞌ, soꞌok ixoꞌl qꞌu aanima viꞌ. Oꞌvaꞌl aanima titzꞌin tatzik tibꞌ samotxok ixoꞌl; oxvaꞌl tok tiꞌ kaꞌvaꞌl utz, kaꞌvaꞌl tok tiꞌ oxvaꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Soꞌok ixoꞌl u tata tuchꞌ u kꞌaola utz, u kꞌaola tuchꞌ u tat majte. Soꞌok ixoꞌl u nana tuchꞌ u titzꞌin ixviak utz, u ixviak tuchꞌ vinan majte. Soꞌok ixoꞌl u txutxa tuchꞌ u alibꞌa utz, u alibꞌa tuchꞌ vitxutx majte.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Uncheeꞌ tal paj u Jesuus tu qꞌu tenam ech tzaꞌ: —Aatz netil ichee u sutzꞌ tikuenta aal tokeꞌ, yak netal ech tzaꞌ: «Tul jabꞌal atziꞌ.» Cheꞌex. Utz ech chit niꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Utz aatz nixumkabꞌin ipaal u kajiqꞌ tikuenta aal ikuꞌeꞌ, netaleꞌ: «Mam tzꞌaꞌ siꞌaneꞌ.» Cheꞌex. Utz nojchit niꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Kaꞌvatz! Etootzajlu tilax qꞌu xheenya nichee vatz amlika tuchꞌ vatz txꞌavaꞌ, pek yeꞌ netxꞌol tilax qꞌu xheenya tiꞌ qꞌu kam niꞌan u Tioxh tu u tiempo tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Pek ¿kantuꞌ yitꞌ jikom koj itxꞌolax inujul qꞌu kam nebꞌan setibꞌilaj, qꞌu kam bꞌaꞌn utz, qꞌu jik? ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tan ech koꞌn tiꞌ nebꞌen vatz u juees tuchꞌ vekoontra. Pek aal bꞌaꞌn saꞌanyaꞌl abꞌantu bꞌaꞌn axh tuchꞌ. Tan bꞌaꞌn siꞌaneꞌ, liqiniokoꞌpꞌaxh vatz u juees utz, satoksabꞌenaxh tiqꞌabꞌ polesiꞌy. Ech sataqꞌkuꞌaxh tu tzeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Utz nival see aas taꞌn kuꞌchil saꞌan tu tzeꞌ. Saꞌtereꞌnkojeluꞌlaxh oj yeꞌk sachoo kajay vatxꞌoj.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Uncheeꞌ aatz iꞌan tu u tiempo tziꞌ, opon unjolol qꞌu aanima nichtal tu u Jesuus, vaꞌl iꞌan u Pilato. Tan tal ikam unjolol qꞌu aa Galilea tuul nichmotxtoksa itxꞌoloꞌm tu viqꞌanalil u totztioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Pek tzaqꞌbꞌu u Jesuus utz, tal te ech tzaꞌ: —¿Kamal netitzꞌa aas maas aa paavich unjolol qꞌu aa Galilea vatz tereꞌn qꞌu aa Galilea tan, ech bꞌanax te tziꞌ? ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nival sete aas yitꞌ aꞌ koj. Pek oj yeꞌ samotxekꞌaxa qꞌul epaav, ela sasotzꞌex sekajayil. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Utz ech pajeꞌ u 18 aanima qꞌuꞌl kuꞌ u tꞌankin tzꞌach tiꞌ tu Siloee. ¿Kamal aꞌ nimotxetitzꞌa aas maas aa paavich vatz tereꞌn qꞌu aanima qꞌuꞌl jejlich tu Jerusaleen? ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nival sete aas yitꞌ aꞌ koj. Pek oj yeꞌk samotxekꞌaxa qꞌul epaav, ela sasotzꞌex sekajayil.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yolon u Jesuus; ikꞌam tiꞌ maꞌl kam. Tal ech tzaꞌ: —Aatz maꞌl u vinaj, atich maꞌl iviikuxh chikich tu chikbꞌal iuuva. Utz ex ichok ivatz tala. Pek yeꞌt chee maꞌj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Utz tal tek tu u ilol ichikobꞌeꞌm ech tzaꞌ: «Oxvaꞌx yaꞌbꞌ xeꞌt ul unchoktu maꞌj ivatz u viikuxh tziꞌ utz, yeꞌxhkam nunchabꞌa maꞌj. Pek tzokꞌ el tan, aal koꞌxh nibꞌuutixsa u txꞌavaꞌ tziꞌ.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ech itzaqꞌbꞌu u ilol chikobꞌeꞌm tal ech tzaꞌ: «Unbꞌaal, aqꞌ tzii atojnu bꞌitoj tu u yaꞌbꞌ tzaꞌ. Tan sunpilu ixeꞌ ech savoksa iqꞌaenal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Utz kamal tu vaꞌt yaꞌbꞌ cheel laꞌtekvatzini. Pek oj yeꞌxh lavatzini, laꞌtekatzokꞌa.» Chia.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Uncheeꞌ nichichusun u Jesuus tu atibꞌal chusbꞌal tetz u oꞌtla mantaar tu maꞌl u ilanbꞌal qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Utz atich maꞌl u ixoj tziꞌ aas 18 yaꞌbꞌ tok maꞌl yaabꞌil kꞌatza tu tioxhil txꞌiꞌliꞌinaj; kꞌoꞌkinich tek taqꞌo. Utz yeꞌxh koꞌxh kaniꞌch aas nichkojijikomteꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ech taꞌxh ilax tu u Jesuus, isikꞌle. Utz tal te ech tzaꞌ: —Ixoj, chitpiꞌaxh, elyaxh tu vayaabꞌil tziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Taqꞌ jeꞌ iqꞌabꞌ u Jesuus tibꞌa, ech oora jikomti. Ech tek toksa iqꞌii Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pek aatz u qꞌesala tu u atibꞌal chusbꞌal tetz u oꞌtla mantaar tziꞌ, lakp iviꞌ tiꞌ. Tan tu u ilanbꞌal qꞌii iꞌan bꞌaꞌn u Jesuus tu u yaꞌv. Utz tal tu qꞌu tenam ech tzaꞌ: —Vaajil aqꞌonibꞌal qꞌii atile. Utz ulojex tu qꞌu qꞌii tziꞌ ech sabꞌanax bꞌaꞌn sete. Pek yitꞌ tu ilanbꞌal qꞌii koj.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Uncheeꞌ tzaqꞌbꞌu tek u kuBꞌaal Jesuus utz, tala: —¡Kaꞌvatz! ¿tzꞌoj tzik yeꞌ nechit vevaakaxh utz, vebꞌuuro tu ilanbꞌal qꞌii? Neteesa tu u tatibꞌal tiꞌ en taqꞌax taaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Pek aꞌ tzik vituꞌxh ixalam u Abrahaam tziꞌ, ¿yeꞌ sachitpul el tu u qitzbꞌal tetz tu u txꞌiꞌliꞌinaj, kꞌuxh tu ilanbꞌal qꞌii? ¡Tan maꞌx 18 yaꞌbꞌ iqitztaꞌ!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ech taꞌxh tal qꞌu kam u Jesuus tzaꞌ, motx chꞌixvu kajay qꞌu koontrain tetz. Pek aatz qꞌu tenam tan, vaꞌlich motx itxuqꞌtxun tiꞌ qꞌu techalla chaj kam nichiꞌan u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Tal paj u Jesuus ech tzaꞌ: —¿Kam maꞌj kam aas ela viQꞌesalail u Tioxh tuchꞌ? ¿Kam maꞌj ela tuchꞌ sunbꞌaneꞌ? ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ela tuchꞌ maꞌl u bꞌaqꞌ muxhtaansa vaꞌl ichik maꞌl u vinaj tipeꞌ. Ech chꞌii utz, bꞌens mam tzeꞌ. Ech motx iꞌan isok qꞌu tzꞌichin siiꞌ qꞌul iqꞌabꞌaj.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Tal paj u Jesuus ech tzaꞌ: —¿Kam ela viQꞌesalail u Tioxh tuchꞌ sunbꞌaneꞌ? ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ela tuchꞌ u txꞌamtixsabꞌ kaxhlaan txꞌix vaꞌl taqꞌ bꞌen maꞌl u ixoj xoꞌl oxvaꞌl paabꞌal ariina. Ech itxꞌamtixsa kajay viqꞌotail u kaxhlaan txꞌix.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Nichipaal u Jesuus tu qꞌu tenam tuchꞌ tu qꞌu talaj tenam. Utz nichichusuneꞌ, tuul aalich ibꞌen tu Jerusaleen. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ech tal maꞌl u aanima te ech tzaꞌ: —UnBꞌaal, ¿bꞌiil koꞌn chixh qꞌuꞌl soꞌok tu viQꞌesalail u Tioxh?— Texhtuꞌ. Tal u Jesuus te ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Bꞌantaj yaꞌl etokoꞌp tu u okebꞌal vaꞌl chꞌoo ivatz. Tan nival sete aas sibꞌal koꞌxh sichok tokoꞌp, loqꞌ yitꞌ saꞌkojveeti. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ech iꞌanchil u Tioxh sete, echaꞌ vaꞌl niꞌan u bꞌaal atibꞌal aas nijup u jubꞌal. Utz xamtel soꞌoponex; sayolonokoꞌpꞌex qꞌanal. Setal ech tzaꞌ: «KuBꞌaal, kuBꞌaal, jajoꞌ.» Chajex. Pek sakoꞌntzaqꞌbꞌu ech tzaꞌ: «Yeꞌ vootzaj til unkꞌaskuꞌlex.» Chaj kuꞌen. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Utz aatz ex, saxeꞌtetal te ech tzaꞌ: «Chuseloꞌ saaqꞌo tu kꞌayibꞌal. Utz txꞌaꞌnnajoꞌ ukꞌaꞌnajoꞌ sakꞌatza.» Chajex. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pek sakoꞌntal sete ech tzaꞌ: «Nival sete aas yeꞌ vootzaj til aanimailex. ¡Xaanojelex sunkꞌatza tan, ex bꞌanol paav!» Chaj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ech latziꞌ saoqꞌkꞌex utz, latziꞌ sajarachꞌunku etee. Tan setil u Abrahaam aas atil tu viQꞌesalail u Tioxh tuchꞌ u Isaac, u Jacoob, tuchꞌ kajay qꞌu alol tetz u yolbꞌal Tioxh. Pek aatz ex, yeꞌk ex tixoꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tan til koꞌn sakꞌaskuꞌl aanima. Atia sakꞌasuꞌl tikuenta aal telaꞌ, tikuenta aal tokeꞌ, tikuenta aal ijeꞌaꞌ utz, tuchꞌ tikuenta aal ikuꞌeꞌ. Utz sakꞌujeꞌ vatz meexha tu viQꞌesalail u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Pek atil qꞌuꞌl yaꞌtebꞌal tatin cheel. Loqꞌ bꞌaxa tatin toj iꞌaneꞌ. Utz atil unjolte, bꞌaxa u tatin cheel, loqꞌ tu u yaꞌtebꞌal toj motx kaakka.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Uncheeꞌ ankoꞌxh tu u qꞌii tziꞌ, opon unjolol qꞌuꞌl fariseo utz, tal tu u Jesuus ech tzaꞌ: —Oraꞌxh, elenbꞌen tzaꞌ. Tan siyatzꞌaxh u Herodes nitxumeꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Pek tal u Jesuus te ech tzaꞌ: —Bꞌenoj etal tu u onkonla vinaj tziꞌ aas: «Cheel tuchꞌ qꞌejal nivojcheꞌl tioxhil txꞌiꞌliꞌinaj. Nunbꞌan bꞌaꞌn tu qꞌu yaꞌv. Utz titoxvaꞌ qꞌii, suntzojpixsa u vaqꞌon tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pek ministeer saꞌatinokꞌin tiꞌ vunbꞌey cheel, qꞌejal tuchꞌ kabꞌi, oponnalin tu Jerusaleen. Tan yeꞌk siꞌaneꞌ aas aꞌ sakamku maꞌl alol tetz u yolbꞌal Tioxh tu vaꞌt tenam tiꞌ eluꞌl u Jerusaleen.» Chajex te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","¡Aa Jerusaleen, aa Jerusaleen! ¡Nikoꞌneyatzꞌ qꞌu alol tetz u yolbꞌal Tioxh! Utz ¡nepaqꞌ sivan qꞌuꞌl nichajax ul tzexeꞌ! Jatpax koꞌn unbꞌan yaꞌl emolax sekajayil. Echaꞌ niꞌan u txutx tꞌel aas nimoloꞌk qꞌu tal jaqꞌ ixichꞌ. Pek ¡yeꞌ koꞌn esaꞌ! ");
INSERT INTO ixlCNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ech aatz cheel, setootzaji tan, saꞌnaltzꞌineꞌka vetotztioxh. Utz nival sete aas yeꞌxhjatu veꞌt setilin. Pek analen paj letilin aas loꞌopon u tiempo letal ech tzaꞌ: «¡Techal axh tan, tibꞌii u kuBꞌaals Amlika vetꞌulkꞌaxh!» Chajex.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Aatz iꞌan tu maꞌl u ilanbꞌal qꞌii, ex txꞌaꞌn u Jesuus otzotz xeꞌ maꞌl u vinaj atil tijleꞌm. Utz fariseoich majte. Utz vaꞌlich chit motx ikꞌaabꞌat u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Utz tiempo atich maꞌl u vinaj tziꞌ, ichiꞌl sipkꞌinajich tu yaabꞌil. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ech yolon u Jesuus tu qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar tuchꞌ tu qꞌu fariseo, tal te ech tzaꞌ: —¿Bꞌaꞌn tzik sabꞌanax bꞌaꞌn tu yaꞌv tu ilanbꞌal qꞌii, oj yeꞌxtxoj?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pek motx koꞌn jutzeꞌi, yeꞌt tzaqꞌbꞌi. Ech txayax iqꞌabꞌ u yaꞌv tu u Jesuus tziꞌ. Iꞌan bꞌaꞌn te. Ech ichaj kꞌasuꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ech iqꞌilat paj qꞌu vinaj u Jesuus, tal te ech tzaꞌ: —Kꞌuxh tu ilanbꞌal qꞌii, yeꞌ koj seꞌnetiqꞌo jeꞌul vebꞌuuro oj vevaakaxh, untzꞌoj sachajpu koꞌp tu jul. ¡Abꞌil koj maꞌj sete aas yeꞌk sabꞌanon!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pek yeꞌt motx itxꞌol itzaqꞌbꞌeleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Uncheeꞌ nichisaji qꞌu aanima u Jesuus, qꞌuꞌl savsamich tu txꞌaꞌom. Tan tila aꞌ chit nichitxaa qꞌu bꞌaxa chaj kꞌujlebꞌal vatz meexha. Ech ikꞌam tiꞌ maꞌl kam, tal ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Untzꞌoj sasavsalex tu txꞌaꞌom tiꞌ maꞌj tzumbꞌaꞌa, yeꞌ koꞌxh kuꞌex tu qꞌu bꞌaxa chaj kꞌujlebꞌal. Tan bꞌaꞌn siꞌaneꞌ savsamoj vaꞌt aanima aas maas tijleꞌm sevatz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Utz loꞌopon sakꞌatza vaꞌl vetsavsanaxh, aꞌ tek imol vaꞌt vaꞌl vetsavsali. Utz latal see ech tzaꞌ: «Aqꞌ u atibꞌal tu u vinaj tziꞌ.» Chaj. Utz aatz axh, tu texh chꞌixaꞌv lenkuꞌojaxh tu u yaꞌtebꞌal kꞌujlebꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Pek oj sasavsalaxh, aꞌ sakꞌujeꞌkꞌaxh tu u yaꞌtebꞌal kꞌujlebꞌal. Ech loꞌopon vaꞌl vetsavsanaxh latal see ech tzaꞌ: «Vamiigo, niꞌaxh. Xaan ukuꞌl.» Chaj. Ech soꞌok aqꞌii vatz qꞌuꞌl ela kꞌujlelaxh tuchꞌ vatz meexha. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tan abꞌiste vaꞌl nitꞌanbꞌaꞌ tibꞌ, sakoꞌnel iqꞌii. Pek abꞌil vaꞌl yeꞌ sitꞌanbꞌaꞌ tibꞌ, soꞌok iqꞌii.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tal paj u Jesuus tu u vinaj ech tzaꞌ majte vaꞌl savsan: —Aatz sasavsa aanima tiꞌ maꞌj txꞌaꞌom, aal bꞌaꞌn yitꞌ aꞌ koj sasavsa qꞌul avamiigo, nikoꞌxh qꞌul iitzꞌin aatzik, nikoꞌxh qꞌul eetz tzꞌalol txꞌiiol iqꞌiil. Tan bꞌaꞌn siꞌaneꞌ aas lakoꞌnpajisavsaꞌaxh. Ech sakoꞌnakꞌul ichꞌexel. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pek oj saꞌan nimla qꞌii, aꞌ sasavsa qꞌu meꞌbꞌaꞌ. Aꞌ sasavsa qꞌuꞌl yeꞌk iqꞌabꞌ, qꞌu koꞌx tuchꞌ qꞌu moy. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ech chiꞌbꞌebꞌal eetz xeꞌ Tioxh siꞌaneꞌ. Tan yitꞌ saꞌkojmotxoleꞌ tiꞌ taqꞌax ichꞌexel see. Pek loqꞌ sakꞌul achoobꞌal aas laqꞌaavitzꞌpu qꞌu jikomla chaj aanima.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Uncheeꞌ taꞌxh tabꞌi qꞌu yol maꞌl u vinaj tziꞌ, vaꞌl ela kꞌujlich tuchꞌ u Jesuus vatz meexha, tal te ech tzaꞌ: —Chiꞌbꞌebꞌal tetz vaꞌl saechbꞌun tu viQꞌesalail u Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tal tek u Jesuus ech tzaꞌ: —Aatz maꞌl u vinaj, iꞌan maꞌl mam echbꞌubꞌal utz, sibꞌal chit aanima isavsa. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ech aatz opon u oora tetz u txꞌaꞌom, ichaj maꞌl taqꞌonom tiꞌ en isikꞌlel qꞌuꞌl savsamich taqꞌo. Ech tal u chaj tzaꞌ: «Niꞌextaj tan, chꞌiam texh niꞌan qꞌu echbꞌubꞌal.» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pek aatz kajay qꞌu aanima tziꞌ, maꞌl chit itzii xeꞌt koꞌn motx toksa kam tuul. Aatz u bꞌaxa, tal ech tzaꞌ: «Vetunloqꞌlu untxꞌavaꞌ utz, saꞌxhenvileꞌ. Pek kuyin, yeꞌk saveet unbꞌenaꞌ.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Aatz vaꞌte tal ech tzaꞌ: «Vetunloqꞌlu oꞌ tzumul unvaakaxh utz, seꞌnvileꞌ. Pek kuyin, yeꞌk saveet unbꞌenaꞌ.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Utz aatz vaꞌte tal koꞌn paj ech tzaꞌ: «Anal koꞌxh tzumeꞌyin. Ech yeꞌxh saveeti soꞌoponin.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ech qꞌaav u chaj utz, tal qꞌu kam tu u bꞌaal taqꞌon. Ech lakp iviꞌ u bꞌaal aqꞌon. Utz tal tek tu vichaj ech tzaꞌ: «¡Oraꞌxh! Kuxh tu kꞌayibꞌal utz, tulaj bꞌey tu u tenam tzaꞌ. Ech iqꞌo ul qꞌu meꞌbꞌaꞌ, qꞌu kut qꞌabꞌ, qꞌu koꞌx utz, kꞌuxh moy.» Chu te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ech xamtel tekuꞌen, tal u chaj ech tzaꞌ: «Unbꞌaal, vetunbꞌanlu vaꞌl naaleꞌ. Utz taꞌxh bꞌanel atil tereꞌn atibꞌal.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tal u bꞌaal taqꞌon te ech tzaꞌ: «Kuxh tu tereꞌn qꞌu bꞌey utz, tu qꞌu xoꞌliꞌitz, ech yaꞌlu tukuꞌl tereꞌn aanima. Ech sanoo u votzotz tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tan nival see, nikoꞌxh maꞌj qꞌu aanima savsamal vaqꞌo bꞌaxa satxꞌaꞌn tzunxeꞌ.» Chia.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ech mam tenam xamich tiꞌ u Jesuus. Utz ipilqꞌu tibꞌ, tal te ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Abꞌil vaꞌl nitok sunkꞌatza utz, sabꞌens unchusulibꞌ. Siqꞌiꞌeꞌ sataqꞌka itat, inan, tixoj, ikꞌaol imeꞌal, itzaꞌqꞌ, tatzik, tanabꞌ. Utz aal siqꞌiꞌ taqꞌax u vatz iqꞌii isaj. Oj yeꞌk siqꞌiꞌeꞌ, unchusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Utz abꞌil vaꞌl sisaꞌa saxambꞌu viꞌ, ministeer siqꞌiꞌ paalchil tu il tzaꞌl viꞌ. Utz siqꞌiꞌ paalchil tu vunpaalebꞌal. Oj yeꞌk siqꞌiꞌeꞌ, yeꞌk siꞌaneꞌ sabꞌens unchusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tan echaꞌ tziꞌ abꞌil koj maꞌj sabꞌanon sete aas silak maꞌj tꞌankin atibꞌal oj yitꞌ bꞌaxal koj satitzꞌa bꞌaꞌnil. Utz siꞌan tiꞌ jankꞌal puaj soꞌok tuul. Ech satileꞌ satz oleꞌ tiꞌ itzojpeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tan oj yeꞌk siꞌan tiꞌ, sakaa tinikꞌa. Yeꞌk loꞌoleꞌ tiꞌ itzojpixsaleꞌ. Bꞌaꞌn siꞌaneꞌ aas taꞌxh soꞌoleꞌ tiꞌ ikuꞌ u tzꞌach tixeꞌ. Ech saxeꞌtibꞌanbꞌel tu qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Satal tiꞌ ech tzaꞌ: «Vetxeꞌtibꞌan totzotz u vinaj tziꞌ utz, yeꞌn oleꞌ tiꞌ itzojpeꞌ.» Chaj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ech pajeꞌ aꞌ maꞌj ijlenal atil 10,000 sol tiqꞌabꞌ utz, siꞌan chꞌaꞌo tuchꞌ vaꞌt ijlenal aas 20,000 isol atile. Bꞌaxal nal satitzꞌa bꞌaꞌnil atziꞌ, satz oleꞌ tiꞌ siꞌan chꞌaꞌo tuchꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tan oj yeꞌk soꞌoleꞌi sinacheꞌ, seꞌntal tok ibꞌaꞌn tuchꞌ. Sichaj bꞌen ichaj atziꞌ aas atil tereꞌn tul vikoontra siatz utz, seꞌntal tok ibꞌaꞌn tuchꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Echat koꞌxh ex majte. Nachtaj bꞌaꞌnil tan, oj yeꞌk setaqꞌka kajay qꞌul etetz viꞌ, yeꞌk siꞌanel sabꞌenex unchusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Bꞌaꞌn u atzꞌam aas chiꞌ. Pek oj sasotz vichiꞌlil, kaniꞌch koj paj ichee vichiꞌlil tikaꞌpaj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nikoꞌxh saꞌkojtxakun tetz qꞌaen. Pek saꞌtexhkꞌonax el. Abꞌiste ex niabꞌin qꞌu yol tzaꞌ, nimataj.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Uncheeꞌ nichixaan opon sibꞌal qꞌu jajol jaꞌmel alkavaar tuchꞌ qꞌu aa paav kꞌatz u Jesuus tiꞌ tabꞌileꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pek aatz qꞌu fariseo tuchꞌ qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar tan, teesa koꞌn iqꞌii u Jesuus sivatzaj. Motx tal ech tzaꞌ: —Nikꞌul aa paav vaꞌl tziꞌ utz, nitxꞌaꞌn tuchꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ech aatz u Jesuus tan, ikꞌam tiꞌ maꞌl kam tiꞌ talax maꞌl u yol ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Yeꞌ koj sebꞌaneꞌ echaꞌ maꞌl u vinaj atil maꞌl 100 ikarneꞌl. Pek satzꞌejxu maꞌl te. ¿Tzꞌoj tzik yeꞌ sataqꞌka u 99 karneꞌl utz, seꞌnichok vaꞌl tzꞌejxia, ichabꞌanale? ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Utz taꞌxh sichabꞌa, saꞌxhtxuqꞌtxun tiꞌ. Sataqꞌ jeꞌ viꞌ ichelebꞌ, satiqꞌo kꞌasuꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Utz aatz soꞌopon tu tatibꞌal, simol qꞌu tamiigo tuchꞌ qꞌu tetz tzꞌalol. Satal te ech tzaꞌ: «Txuqꞌtxunojex sunkꞌatza tan, vetunchabꞌal vunkarneꞌl vaꞌl maꞌtich itzꞌejxeꞌ.» Chaj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ech nival sete. Kaana chiꞌbꞌichil atil tu Amlika majte aas nikꞌaxa vipaav maꞌl aa paav, vatz 99 aanima aas yeꞌxhkam nisavsa sikꞌaxa ipaav tan, jikom ninacheꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ech pajeꞌ maꞌj ixoj aas atil laval isaj chꞌichꞌ puaj. Pek sitzꞌej maꞌj. ¿Tzꞌoj tzik yeꞌ sichokeꞌ? Sataqꞌ jeꞌ itxijtxubꞌal atziꞌ utz, sateesa chꞌis tiꞌ. Bꞌoono ichokax siꞌaneꞌ, ichabꞌanale. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Utz aatz sichabꞌa, simol kajay qꞌu tamiigo utz, tuchꞌ qꞌu tetz tzꞌalol. Satal te ech tzaꞌ: «¡Txuqꞌtxunojex sunkꞌatza! tan, vetunchabꞌal vunpuaj vaꞌl maꞌtich untzꞌejtaꞌ.» Chaj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ech nival sete aas echat qꞌul iaanjel u Tioxh tu Amlika majte, saꞌxhmotxtxuqꞌtxun tiꞌ aas sikꞌaxa ipaav maꞌl aa paav.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Tal paj u Jesuus ech tzaꞌ: —Aatz maꞌl u vinaj, atich kaꞌvaꞌl ikꞌaol. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Utz aatz u chꞌooala, tal tu vitat ech tzaꞌ: «Tat, aqꞌ tek vunmeꞌbꞌiꞌl vaꞌl saaqꞌeꞌ.» Texhtuꞌ. Ech aatz vitat, ijatx vimeꞌbꞌiꞌl. Taqꞌ u tetz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Utz yeꞌxh koꞌxh jatvaꞌl qꞌii tuul, imol kajay qꞌu tetz u chꞌooal kꞌaol utz, bꞌen tzian tu vaꞌt tenam xaannaj el. Ech latziꞌ ibꞌuchvu vipuaj. Tiira teesa jeꞌ tatin tu bꞌey. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Utz aatz tek maꞌtich imotx vipuaj kajayil, tiempo ul maꞌl mam vaꞌy tu u tenam vaꞌl atichka. Ech xeꞌt tek iyaꞌta tetz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ech tek ex okoj kꞌatz maꞌl u vinaj aa tenam nal tziꞌ. Utz ichaj bꞌen titxꞌavaꞌ tiꞌ en ixeel bꞌoch. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ech tu tek u vaꞌy, nichtachva satechbꞌu tetz qꞌu vatz tzeꞌ qꞌuꞌl nichtechbꞌu qꞌu bꞌoch. Pek abꞌil koj nichaqꞌon tetz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ech tek itxakbꞌaꞌt itxumbꞌal utz, tal ech tzaꞌ: «Jatvaꞌl koꞌn aqꞌonom atil tu atibꞌal xeꞌ vuntat. Utz tzꞌanlel koꞌxh techbꞌubꞌal. Aal nichanan tereꞌn. Pek aatz in utz, toj tek kamojin tu vaꞌy. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Pek sabꞌenin; saqꞌaavoponin xeꞌ vuntat. Utz saval te: Tat paavinyin vatz u Tioxh tu Amlika tziꞌ utz, saatz majte. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Yeꞌkan sikꞌuloꞌk viꞌ aas in tereꞌn akꞌaol saꞌalchi. Pek aqꞌtexhbꞌenins echaꞌ maꞌj qꞌul aaqꞌonom tziꞌ. Chajin te.» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ech ikꞌasuꞌl. Bꞌen xeꞌ vitat. Pek aatz atileꞌnich tuleꞌ, ilax bꞌen tu vitat. Ech itxumt iatz. Tꞌaspu ibꞌenaꞌ. Ex iqꞌalu utz, itzꞌutzꞌa. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Utz tal vikꞌaol te ech tzaꞌ: «Tat, paavinyin vatz u Tioxh tu Amlika tziꞌ utz, saatz majte. Yeꞌkan nikꞌuloꞌk viꞌ aas in tereꞌn akꞌaol saꞌalchi.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pek aatz vitat, tal tu qꞌu taqꞌonom ech tzaꞌ: «¡Oora koꞌxh ex! Iqꞌotaj eluꞌl qꞌu techalla oksaꞌm utz, oksataj kꞌatza. Aqꞌtaj kuꞌ tixkol qꞌabꞌ. Utz oksataj ixaabꞌ tu tajan. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Utz bꞌenoj etiqꞌo u tzaqꞌal vaakaxh utz, yatzꞌtaj. Tan sakubꞌan maꞌl txꞌaꞌom. Ech sachiꞌbꞌoꞌ satxuqꞌtxunoꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tan aatz vunkꞌaol tziꞌ, ¡kamnaj tekuꞌen nivaleꞌ, pek qꞌaaviul! ¡Maꞌtich itzꞌejxeꞌ, pek cheeya!» Chia. Ech xeꞌt motx ichiꞌbꞌeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Pek aatz u atzika, ayeꞌnich jaꞌjtzeꞌ. Utz taꞌxh uli, najabꞌ opon kꞌatz atibꞌal, tabꞌi u son tuchꞌ bꞌixal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ech isikꞌlet maꞌl qꞌu taqꞌonom. Utz ichꞌoti te kam nichtucheꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Utz tal u aqꞌonom te ech tzaꞌ: «Vatzaꞌqꞌ qꞌaaviul utz, tiira tiichaj mutuleꞌ. Ech tiꞌ vetiyatzꞌ u tzaqꞌal vaakaxh vatat.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ech lakp iviꞌ u atzika. Utz yeꞌ nichikꞌul veꞌt okoꞌp toꞌotzotz. Eltekꞌul vitat utz, iyaꞌlu ibꞌenoꞌk. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pek tzaqꞌbꞌi utz, tal tu vitat ech tzaꞌ: «Jatvaꞌx koꞌn yaꞌbꞌ vaqꞌonin sakꞌatza, yeꞌxh bꞌoj nikojunqelaxh. Utz yeꞌxhjatu maꞌkojaaqꞌ maꞌj untentzun aas savaqꞌ kuꞌ utz, sachiꞌbꞌbꞌojin tuchꞌ qꞌu vamiigo. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pek aatz vetꞌul vakꞌaol tziꞌ, vaꞌl ex ibꞌuchluka qꞌul ameꞌbꞌiꞌl tuchꞌ cheela chaj ixoj, ¡yakich vetaaqꞌ kuꞌ u tzaqꞌal vaakaxh tiꞌ!» Chu te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tal tek vitat te ech tzaꞌ: «Unkꞌaol, bꞌenamen atilaxh sunkꞌatza. Utz eetz kajay qꞌul unmeꞌbꞌiꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pek ministeer vetchiꞌbꞌoꞌ vettxuqꞌtxunoꞌ. Tan aatz vatzaꞌqꞌ tziꞌ, ¡kamya nivaleꞌ, pek qꞌaaviul! ¡Maꞌtich itzꞌejxeꞌ, pek cheeya!» Chia.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Tal paj u Jesuus tu qꞌul ichusulibꞌ ech tzaꞌ: —Atich maꞌl u vinaj txꞌiiol iqꞌii. Utz atich maꞌl qꞌesal taqꞌonom, ilol tetz imeꞌbꞌiꞌl. Pek xochax u qꞌesal taqꞌonom te. Tan nichibꞌucheꞌl qꞌul imeꞌbꞌiꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ech aatz u txꞌiiol iqꞌii, isikꞌle u qꞌesal taqꞌonom siatz. Utz tal te ech tzaꞌ: «¿Kam tok vaꞌl nivabꞌi saiꞌ tziꞌ? Pek motxoj aal ve til nimotxaaqꞌvu bꞌen qꞌu vetz. Tan yeꞌkan siꞌaneꞌ aas axh tereꞌn sailon vunmeꞌbꞌiꞌl.» Chu te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Uncheeꞌ aatz u ilol meꞌbꞌiꞌl tziꞌ, tal tu taanima ech tzaꞌ: «¿Kam sunbꞌaneꞌ? Tan saelin tu u vijleꞌm. Utz yeꞌk unyakꞌil oj aꞌ tek sunkꞌot txꞌavaꞌ. Utz sachꞌixvin oj sunjoy vetz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Pek ¡vetunnachlaꞌ kam sunbꞌaneꞌ! ech sikꞌulin qꞌu aanima tu tatibꞌal aas leꞌelin tu u vijleꞌm.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ech isikꞌle ul qꞌu aanima qꞌuꞌl atich itxꞌoj xeꞌ u bꞌaal taqꞌon. Utz tal tu vibꞌaxa ech tzaꞌ: «¿Jatvaꞌl atxꞌoj xeꞌ u bꞌaal vaqꞌon?» Chu te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tal u vinaj ech tzaꞌ: «Maꞌl 440 galoon aseite.» Chia. Alax te tu u ilol meꞌbꞌiꞌl ech tzaꞌ: «¡Oraꞌxh bꞌan tiꞌ utz, maꞌl koꞌn 220 galoon satzꞌibꞌa!» Chu te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Xamtel pajeꞌ, tal tu vaꞌt ech tzaꞌ: «¿Aatz axh, jatvaꞌl atxꞌoj?» Chu te. Tal u vinaj ech tzaꞌ: «Maꞌl 100 quintaal triigo.» Chia. Tal u ilol meꞌbꞌiꞌl te ech tzaꞌ: «Bꞌan tiꞌ utz, maꞌl koꞌn 80 satzꞌibꞌa.» Chu te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Uncheeꞌ aatz u bꞌaal aqꞌon tan, til tekuꞌen aas telabꞌal iveet u kam iꞌan u subꞌulla ilol imeꞌbꞌiꞌl tziꞌ. Ech niꞌan qꞌu aa paav itzꞌlel tu u tiempo tzaꞌ, telabꞌal iveet qꞌu kam niꞌan tibꞌilaj. Pek yitꞌ telabꞌal koj niꞌan qꞌu niman tetz u Tioxh tibꞌilaj kꞌuxh aal atil tu u txijtxubꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Echtzixeꞌt nival sete, txakunsataj qꞌu txꞌiibꞌal qꞌii qꞌuꞌl tu u vatz amlika txꞌavaꞌ tzaꞌ tiꞌ qꞌu kam tetz u Tioxh. Ech sataqꞌ etatibꞌal u Tioxh tu bꞌenqꞌii bꞌensaj taqꞌo. Tan aatz lakamex, kam tereꞌn koj satxakunku qꞌu txꞌiibꞌal qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Abꞌil vaꞌl inujul niꞌan qꞌu kam, kꞌuxh bꞌiil koꞌxhtuꞌ, inujul siꞌan qꞌu kam majte qꞌuꞌl sibꞌal. Utz abꞌil vaꞌl yitꞌ inujul koj niꞌan qꞌu kam qꞌuꞌl bꞌiil koꞌxhtuꞌ, yitꞌ inujul koj siꞌan tiꞌ sibꞌal kam majte. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Echtzixeꞌt oj yitꞌ inujul koj ibꞌanbꞌel qꞌu yeꞌxtxojla txꞌiibꞌal qꞌii nebꞌan tu u vatz amlika txꞌavaꞌ tzaꞌ, ¿abꞌil sakꞌujeꞌ ikꞌuꞌl setiꞌ tiꞌ qꞌu nojla bꞌaꞌnla txꞌiibꞌal qꞌii tu Amlika? ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Utz oj yitꞌ jikom koj nebꞌan tiꞌ qꞌu kam aqꞌelka tzexeꞌ, oj tzik sataqꞌ sete u Tioxh qꞌu kam taabꞌaꞌbꞌen, ¿abꞌil tek saꞌaqꞌon etetz? ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Echaꞌ maꞌj aqꞌonom, saꞌkojiꞌaneꞌ aas kaꞌvaꞌl bꞌaal taqꞌon siꞌaneꞌ. Tan maꞌl yeꞌk itxaꞌk te siꞌaneꞌ atziꞌ. Utz vaꞌt tiira tii tiꞌ siꞌaneꞌ. Satoksa iqꞌii maꞌl atziꞌ. Utz sateesa iqꞌii vaꞌte. Echat ex majte. Saꞌkojiꞌaneꞌ senima kaꞌvaꞌl etioxh. Ayaꞌ u nojla Tioxh tuchꞌ u txꞌiibꞌal qꞌii.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Utz nichtabꞌi kajay qꞌu kam qꞌu fariseo tziꞌ. Ech nichkoꞌnibꞌanbꞌe u Jesuus tan, yeꞌk chit inooebꞌal tiꞌ puaj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Uncheeꞌ tal u Jesuus te ech tzaꞌ: —Ex qꞌuꞌl nikoꞌxhmotxetaqꞌ bꞌen etibꞌs bꞌaꞌn vatz aanima. Pek u Tioxh ootzajin tetz qꞌul etaanima. Tan aatz qꞌu kam qꞌuꞌl techal chit tilon vatz aanima, tzuꞌkin vatz u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Aatz u oꞌtla mantaar tuchꞌ qꞌu yol tzꞌibꞌamalka tu qꞌu alol tetz u yolbꞌal Tioxh, taꞌn yaꞌkka tikuenta u Xhan. Utz ayaꞌxchen xeꞌt talax u bꞌaꞌnla chusbꞌal tetz viQꞌesalail u Tioxh tikuenta u Xhan. Utz sibꞌal aa paavla aanima niꞌan yaꞌl okchil tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Aatz vimantaar u Tioxh, kꞌuxh tiira chꞌoo texh tabꞌileꞌ, jatu koj sayaꞌ itzojpeꞌ. Aal sapaal u vatz amlika txꞌavaꞌ tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Abꞌil vaꞌl sakoꞌxhtaqꞌan tojchat tixoj utz, sichok vaꞌt tixoj, eesaibꞌ tu bꞌey niꞌan tuchꞌ vaꞌt u ixoj tziꞌ. Utz abꞌil u vinaj siꞌiqꞌon u ixoj vaꞌl jatxel tibꞌ tziꞌ, eesaibꞌ paj tu bꞌey niꞌan tuchꞌ.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Tal paj u Jesuus ech tzaꞌ: —Atich maꞌl u vinaj txꞌiiol iqꞌii, bꞌaꞌnla chit kajko qꞌej oksaꞌm nichtoksa, tuchꞌ bꞌaꞌnla lino bꞌuꞌj. Utz jun chit qꞌii nichiꞌan techalla nimla qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Atich vaꞌt u vinaj majte, nichkoꞌxhijoy tetz. Laazaro ibꞌii. Kaanaich bꞌoj toy tiꞌ. Nichtatin vatz jubꞌal xeꞌ u txꞌiiol iqꞌii tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Utz nichtachva techbꞌul qꞌu juyaj echbꞌubꞌal qꞌuꞌl nichichajpu kuꞌl viꞌ vimeexha u txꞌiiol iqꞌii tziꞌ. Utz nichtopon qꞌu txꞌiꞌ majte, nichileqꞌu vitoy. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Pek aatz iꞌana, kam u meꞌbꞌaꞌ tziꞌ. Utz iqꞌol bꞌen u taanxelal tu qꞌu aanjel. Utz ex taqꞌ kꞌatz u Abrahaam. Utz kam u txꞌiiol iqꞌii majte tziꞌ. Utz mujaxi. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Loqꞌ tu choobꞌal paav bꞌenka. Ech tuul txumbꞌal tatin tu mam kꞌaxkꞌo, sajin kꞌasuꞌl. Utz til u Abrahaam tzian; atoꞌk u Laazaro txala. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Qꞌeqꞌun kꞌasuꞌl utz, tala: «¡Tateey Abrahaam, bꞌan bꞌaꞌnil! ¡Txum unvatz! Chaj u Laazaro tziꞌ. Seꞌntakꞌsa u viꞌ iqꞌabꞌ tu chiꞌul aꞌ, ech suꞌlilotzꞌixsa u viꞌ vaqꞌ. ¡Tan techal bꞌoj vulebꞌel tu u xamal tzaꞌ!» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pek tal u Abrahaam te ech tzaꞌ: «Kꞌaol, ulsa sakꞌuꞌl aas tu bꞌaꞌnil paalkꞌaxh, aꞌ chit atichꞌaxh tu u vatz aqꞌii asaj tu u vatz amlika txꞌavaꞌ. Pek aatz u Laazaro, tu tzaꞌl paalka. Pek atil tek tu bꞌaꞌnil cheel. Utz aatz axh, atilaxh tu mam kꞌaxkꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Utz kꞌuxh abꞌil koj satachva elchil bꞌen tzaꞌ, soꞌopon tzexeꞌ, saꞌkojveeti. Tan atil maꞌl u mam jankin tu kuxoꞌl. Utz abꞌil koj saveeti kꞌasuꞌl tzexeꞌ tziꞌ utz, suꞌul tzaꞌ majte.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ech tal paj u txꞌiiol iqꞌii ech tzaꞌ: «Nunjaj see uncheeꞌ, tateey Abrahaam aas sachaj bꞌen tu atibꞌal xeꞌ qꞌul untxutx unbꞌaal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Tan atil oꞌvaꞌl untzaꞌqꞌ. Pek seꞌnalaxoj vinujul te. Ech yeꞌk saul tu u choobꞌal paav tzaꞌ.» Chu te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Tal u Abrahaam te ech tzaꞌ: «Tootzaj tek vaꞌl talka u Moisees tuchꞌ qꞌu alol tetz u yolbꞌal Tioxh, aꞌ samotxtabꞌi.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tal paj chit u txꞌiiol iqꞌii ech tzaꞌ: «Yeꞌka tateey Abrahaam, saꞌxhmotxikꞌaxa qꞌul ipaav atziꞌ oj aꞌ seꞌen tzixeꞌ maꞌj qꞌu aanima kamnaj tekuꞌen.» Chu te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pek aatz u Abrahaam tan, tal te ech tzaꞌ: «Oj yitꞌ saꞌkojinima u Yolbꞌal Tioxh alel tu u Moisees tuchꞌ qꞌu alol tetz u yolbꞌal Tioxh, ¿aꞌ chixh sinima maꞌj aanima salakpu xoꞌl qꞌu kamnaj seꞌntal te?» Chu u Abrahaam te.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Tal u Jesuus tu qꞌu chusulibꞌ ech tzaꞌ: —Yeꞌxh bꞌoj yeꞌ koj soꞌok bꞌoyol uchchil tu paav. Pek tilayol sayaꞌk u aanima vaꞌl sataqꞌ bꞌen imol tu paav. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Aal tek bꞌaꞌn sakami; saqitzax ok maꞌl mam sivan siqul, cheꞌbꞌal triigo, ech sakꞌonax bꞌen tu mar. Bꞌaꞌn tek vatz vaꞌl niꞌaneꞌ aas nitaqꞌ bꞌen maꞌj qꞌu chꞌooal niman vetz tu paav. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Pek bꞌantaj kuenta etibꞌ. Echaꞌ tziꞌ oj kam siꞌan maꞌj vehermano sete, altaj te. Ech oj likꞌaxa, kuytaj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Utz oj jujpajul kam siꞌan sete tu maꞌl qꞌii, loqꞌ jujpajul saqꞌaavuꞌl tzexeꞌ majte tiꞌ ijajax kuybꞌal, kuytaj.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tal tek qꞌu chusulibꞌ tu u kuBꞌaal Jesuus ech tzaꞌ: —¡Lochꞌoꞌ! Ech saꞌxhkꞌujeꞌ kukꞌuꞌl tiꞌ Tioxh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tal u kuBꞌaal Jesuus te ech tzaꞌ: —Kꞌuxh bꞌiil koꞌxh vikꞌujeꞌ ekꞌuꞌl sebꞌaneꞌ, ech koꞌxhtuꞌ aꞌ ichꞌii maꞌl bꞌaqꞌ iatz muxhtaansa, mamaj kam sebꞌaneꞌ. Echaꞌ tziꞌ, saveeti setal tu u tzeꞌ sicoomoro ech tzaꞌ: «Bꞌuqꞌxen bꞌen tzaꞌ utz, kuxh chik iibꞌ tu mar.» Chajex te. Sinimaꞌex atziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Abꞌil koj maꞌj bꞌaal aqꞌon nibꞌanon texoꞌl aas satal tu taqꞌonom ech tzaꞌ: «Niꞌaxh tekuꞌen tan, satxꞌaꞌnaxh.» Chaj koj te, kꞌuxh anal nitul u aqꞌonom jaꞌjtzeꞌ tziꞌ, tiꞌ ipilul txꞌavaꞌ, oj tu xee karneꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Pek aal nikoꞌnpajtaqꞌ taqꞌon. Nital te ech tzaꞌ: «Oraꞌxh, bꞌan vechbꞌubꞌal tetz kuꞌqꞌii. Ech laaqꞌuꞌl vetz. Tan txꞌaꞌnnalin, ukꞌaꞌnalin, ech nal tek latxꞌaꞌnaxh, luꞌukꞌaꞌaxh.» Chu te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Utz oj tzik niꞌxhikꞌamabꞌe tu u aqꞌonom vaꞌl vettal te utz, vetiꞌana. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Utz echat koꞌxh ex majte. Aatz maꞌt etzojpit qꞌu kam qꞌuꞌl alel sete tu u Tioxh, setal ech tzaꞌ: «Yeꞌ nikꞌuloꞌk vibꞌaꞌnil u Tioxh qiꞌ. Tan taꞌxh vetkubꞌana kam vaꞌl ministeer sakubꞌaneꞌ.» Chajex.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Uncheeꞌ aatz iꞌana, paal u Jesuus tixoꞌl vikuentail u Galilea tuchꞌ u Samaaria. Aꞌ chit aalich ibꞌen tu Jerusaleen. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Utz aatz okoꞌp tu maꞌl u tal tenam, ul kꞌulaxoj tu laval qꞌu vinaj; jolol chꞌaꞌkꞌiꞌ. Utz motx txakeꞌ kꞌasuꞌl tzian. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Motx qꞌeqꞌun kꞌasuꞌl ech tzaꞌ: —¡Jesuus, chusul, txum kuvatz!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ech taꞌxh ilax tu u Jesuus, tal tek te ech tzaꞌ: —Bꞌenojex. Kꞌuchtaj etibꞌ tu u oksan yol vatz Tioxh aas bꞌaꞌntꞌex.— Texh te. Utz tuul koꞌxh atich ok tiꞌ bꞌey, motx iꞌan bꞌaꞌn. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ech aatz iꞌan maꞌl te, taꞌxh tila aas maꞌtich iꞌantu bꞌaꞌn, qꞌaavuꞌl. Vaꞌlich iqꞌeqꞌun toksat iqꞌii Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Utz pecheꞌi. Taqꞌ kuꞌ ivatz vatz txꞌavaꞌ vatz u Jesuus. Vaꞌlich ikꞌamabꞌetaꞌ. Utz aal aa Samaaria u vinaj tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yolon tek u Jesuus utz, tal te ech tzaꞌ: —¿Yitꞌ tzik laval qꞌuꞌl vetiꞌan bꞌaꞌn? Utz ¿keꞌch bꞌeluvate? ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Yeꞌn qꞌaav maꞌj qꞌu Israeel tzik, suꞌltoksa iqꞌii Tioxh? Pek taꞌxh u puera aanima tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Utz tal tu u vinaj ech tzaꞌ: —Tiꞌ koꞌn ikꞌujeꞌ akꞌuꞌl viꞌ vetaꞌanlu bꞌaꞌn tu vayaabꞌil tziꞌ. Lakpen utz, kuxh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Chꞌotil itziꞌ u Jesuus tu qꞌu fariseo aas jatu suꞌul viQꞌesalail u Tioxh. Tzaqꞌbꞌu u Jesuus utz, tal te ech tzaꞌ: —Aatz viQꞌesalail u Tioxh tan, at koj talchu tuleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Utz yitꞌ saꞌkojalaxi aas: «Atil tzuyta.» Chaj. Utz: «Atil tek tziꞌ.» Chaj koj teꞌleꞌ. Tan aatz viQꞌesalail u Tioxh, atil nal texoꞌl.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ech tal tu qꞌul ichusulibꞌ ech tzaꞌ: —Saꞌnalul maꞌl tiempo aas saꞌteketachva tilax u Kꞌaola vaꞌl bꞌennaj koꞌn aanima. Loqꞌ yitꞌ saꞌkojetileꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Pek atil aanima saꞌalon sete ech tzaꞌ: «Atil tzaꞌ.» Chaj. Utz: «Atil tzuta.» Chaj eteꞌleꞌ. Loqꞌ txubꞌaꞌl. Bꞌeniꞌch etileꞌ. Utz xambꞌiꞌchꞌex tiꞌ qꞌuꞌl nialon. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tan echaꞌ u itzꞌnaꞌbꞌ aas niripkabꞌin tikuenta aal telaꞌ utz, yak paqꞌunoj opon tikuenta aal tokeꞌ, ech u tulebꞌal u Kꞌaola siꞌaneꞌ tu viqꞌiilil vaꞌl bꞌennaj koꞌn aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pek ministeer saꞌxhpaal tu sibꞌla kꞌaxkꞌo bꞌaxa. Utz saeesal iqꞌii tu qꞌu aanima itzꞌlel tu tiempo tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tan kam chit vaꞌl uch tikuenta u Noee, echat siꞌan tu u qꞌii tu u tulebꞌal u Kꞌaola vaꞌl bꞌennaj koꞌn aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tan taꞌxh nichtitzꞌa u tetz qꞌu aanima qꞌuꞌl ninaliꞌaneꞌ. Ayaꞌ u techbꞌuneꞌ, u tukꞌaꞌeꞌ, u okchil tiꞌ ixoj tuchꞌ u tzumeꞌchil, tuul opon u qꞌii aas ok tek u Noee tu u arca. Ech ul u mam jabꞌal utz, isotzsa kajay qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Echat koꞌxh paj iꞌan tikuenta u Lot majte. Taꞌxh paj nichmotxtitzꞌa u tetz qꞌu aanima. Ayaꞌ u echbꞌuꞌm, ukꞌaꞌa, loqꞌoꞌm, kꞌaꞌy, chikoꞌm, tuchꞌ bꞌano otzotz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pek taꞌxh kꞌasuꞌl u Lot tu Sodoma, jabꞌal chit ikuꞌl xamal tu amlika iꞌana, tuchꞌ qꞌol. Utz isotzsa qꞌu aanima kajayil. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Echat koꞌxh siꞌan tu u qꞌii majte aas luꞌul u Kꞌaola vaꞌl bꞌennaj koꞌn aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Utz aatz liꞌan tu u qꞌii tziꞌ, abꞌil aꞌ atil jeꞌop viꞌ atibꞌal, kuꞌichul tiꞌ tiqꞌol qꞌu tetz atil toꞌotzotz. Utz abꞌil ayeꞌn jaꞌjtzeꞌ, qꞌaaviꞌchtereꞌnul. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ulsataj sekꞌuꞌl kam vaꞌl iꞌan u tixoj u Lot. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tan abꞌil qꞌuꞌl taꞌxh nititzꞌa u vatz iqꞌii isaj tu u vatz txꞌavaꞌ tzaꞌ, tzꞌejoꞌm siꞌaneꞌ. Pek abꞌil vaꞌl kꞌuxh sitzꞌej u vatz iqꞌii saj, aꞌ sichabꞌa u bꞌenqꞌii bꞌensaj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Utz nival sete, aatz siꞌan tu u aqꞌbꞌal tziꞌ, kaꞌvaꞌl aanima atil viꞌ txꞌach. Maꞌl siꞌiqꞌol bꞌen utz, vaꞌt, saꞌaqꞌaxka. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kaꞌvaꞌl ixoj ela nicheꞌneꞌ siꞌaneꞌ. Maꞌl siꞌiqꞌol bꞌen utz, vaꞌt saꞌaqꞌaxka. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Kaꞌvaꞌl aanima ela nitaqꞌonin jaꞌjtzeꞌ siꞌaneꞌ. Maꞌl siꞌiqꞌol bꞌen utz, vaꞌt saꞌaqꞌaxka.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ech tzaqꞌbꞌeli, alax te ech tzaꞌ: —¿Til siꞌanvu qꞌu kam tziꞌ kuBꞌaal?— Texh te. Tal u Jesuus te ech tzaꞌ: —Nimnaꞌl siꞌaneꞌ. Tan echaꞌ tziꞌ til atik maꞌj kamnaj, nimol tibꞌ qꞌu quꞌs tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ikꞌam paj tiꞌ vaꞌt kam u Jesuus tiꞌ talaxeꞌ aas tzukꞌel saqꞌilal isikꞌlel Tioxh. Yeꞌk suꞌuch jochpichil. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Tal ech tzaꞌ: —Atich maꞌl u juees tu maꞌl u tenam. Nichkojixoꞌva Tioxh. Utz keꞌch koj tatin aanima siatz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Utz atich maꞌl u txakay ixoj tu u tenam majte. Tzukꞌel nichtopon vatz u juees. Utz nichtal te ech tzaꞌ: «Txꞌol vetz inujul vaꞌl niꞌan vunkoontra ve.» Chu te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Loqꞌ sibꞌal tiempo yeꞌt koꞌn isaꞌa. Xamtich tek tuul tal tu taanima ech tzaꞌ: «Kꞌuxh yeꞌxhkam nunnima Tioxh utz, yeꞌk koꞌxh tatin aanima sunvatz, ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","suntxꞌol inujul vixochoꞌm u ixoj tziꞌ. Tan oj yeꞌka, bꞌaꞌn siꞌaneꞌ laꞌtekpaal unkꞌuꞌl taqꞌo. Tan tzukꞌel chit nituleꞌ.» Chia.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tal paj u kuBꞌaal ech tzaꞌ: —Itzꞌataj kam vaꞌl iꞌan u juees vaꞌl yeꞌ nixoꞌva Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ech ¿oj chixh u Tioxh, yitꞌ jikom koj itxꞌolax inujul qꞌul ikꞌaol imeꞌal siꞌaneꞌ qꞌuꞌl niqꞌilan sikꞌlen qꞌiils aqꞌbꞌal? Oj tzik sabꞌatz tiꞌ itzaqꞌbꞌeleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nival sete aas oora koꞌxh sitxꞌol inujul atziꞌ kam sajajax te. Pek aatz luꞌul u Kꞌaola vaꞌl bꞌennaj koꞌn aanima, ¿matz ankoꞌxh kꞌujlel ikꞌuꞌl qꞌu aanima tiꞌ u Tioxh?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ikꞌam paj tiꞌ vaꞌt kam u Jesuus tiꞌ talax tu qꞌu aanima qꞌuꞌl nikꞌujbꞌaꞌ jeꞌ ikꞌuꞌl aas jikomla chaj aanima nimotxtaleꞌ utz, nichteesa iqꞌii unjote. Tal ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Iꞌan unpajul, bꞌen kaꞌvaꞌl vinaj tu viqꞌanalil u totztioxh. Ex iqꞌila sikꞌle Tioxh. Maꞌl, fariseoich. Utz vaꞌt, jajol jaꞌmel alkavaar. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ech aatz u fariseo tan, txakliche iqꞌila sikꞌle jeꞌ Tioxh tiꞌ. Tal ech tzaꞌ: «Nivaqꞌ taꞌntioxh see unTioxh, qeꞌl tan, yitꞌeꞌch koj in tereꞌn qꞌu aanima qꞌuꞌl nitelqꞌeꞌ, qꞌuꞌl yeꞌ niꞌan vinujul, qꞌu eesanibꞌ tu bꞌey tuchꞌ aanima yitꞌ ikꞌulel koj. Utz yitꞌeꞌch koj in u subꞌulla jajol jaꞌmel alkavaar tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Pek aatz in tan, kaꞌpajul nunkuy unvaꞌy tiꞌ aqꞌilal asikꞌlel tu maꞌl xhemaana. Utz nivaqꞌ undiesmo tiꞌ kajay vaꞌl nuntxꞌakeꞌ.» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pek aatz u jajol jaꞌmel alkavaar tan, txaklich tzian. Nikoꞌxh nikojisajin jeꞌ tu amlika. Utz nichilaa taanima tu kꞌaxa kꞌuꞌlil. Nichtal ech tzaꞌ: «UnTioxh txum unvatz tan, in aa paav.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ech nival sete aas aꞌ aqꞌax bꞌen bꞌaꞌn vatz u Tioxh u jajol jaꞌmel alkavaar aas bꞌen tu u totzotz, vatz u fariseo. Tan abꞌil vaꞌl nitꞌanbꞌaꞌ tibꞌ, sakoꞌnel iqꞌii. Pek abꞌil vaꞌl yeꞌ sitꞌanbꞌaꞌ tibꞌ, aꞌ vaꞌl soꞌok iqꞌii.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Uncheeꞌ nichenoksaloj talaj nitxaꞌ vatz u Jesuus. Aꞌ isaꞌ qꞌul itxutx ibꞌaal aas sataqꞌ jeꞌ iqꞌabꞌ tiꞌ. Pek taꞌxh til u kam qꞌu chusulibꞌ tziꞌ, motx iyaa. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ech aatz u Jesuus, isikꞌle ul qꞌu talaj nitxaꞌ utz, tal tu qꞌul ichusulibꞌ ech tzaꞌ: —Aqꞌtaj tzii suꞌul qꞌu talaj nitxaꞌ sunkꞌatza tziꞌ. Utz yeꞌ koꞌxh emaj iatz. Tan aatz viQꞌesalail u Tioxh, tetz qꞌuꞌl echaꞌ talaj nitxaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tan niꞌxhtekꞌval sete, oj yitꞌ ech koj ikꞌulax viQꞌesalail u Tioxh sebꞌaneꞌ, echaꞌ niꞌan maꞌl tal nitxaꞌ, saꞌkojokoꞌpꞌex tuul.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Aatz maꞌl u vinaj atil tijleꞌm xoꞌl qꞌu Israeel, ichꞌoti tu u Jesuus ech tzaꞌ: —Bꞌaꞌnla chusul, ¿kam sunbꞌaneꞌ ech soꞌokoꞌpꞌin tu u bꞌenqꞌii bꞌensaj?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Tal u Jesuus te ech tzaꞌ: —¿Kam tokeꞌ aas: «Bꞌaꞌn.» Chaꞌaxh ve? Tan yeꞌxhabꞌil koꞌxh bꞌaꞌn. Taꞌxh maꞌl bꞌaꞌn u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Utz ootzaj nal qꞌu mantaar tzaꞌ: «Eesach iibꞌ tu bꞌey tuchꞌ aanima yitꞌ akꞌulel koj. Yatzꞌoniꞌchꞌaxh. Elqꞌiꞌchꞌaxh. Txubꞌaꞌlichꞌaxh tiꞌ isuyax kam tiꞌ amol. Utz nima atxutx abꞌaal.» Chia.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tal u vinaj ech tzaꞌ: —Ninalunnima tunxiakil kajay qꞌu kam naaleꞌ tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Taꞌxh tabꞌi u kam u Jesuus tziꞌ, tal te ech tzaꞌ: —Atil vaꞌt kam yeꞌ naꞌaneꞌ. Pek kuxh kꞌayi kajay qꞌul eetz atile utz, jatx vatz qꞌu meꞌbꞌaꞌ. Ech saꞌatin txꞌiibꞌal aqꞌii tu Amlika. Utz niꞌaxh xambꞌen viꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ech taꞌxh tabꞌi u kam u vinaj tziꞌ, tiira txumun tiꞌ. Tan nojchit mam txꞌiiol iqꞌiich. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ech sajil u vinaj tu u Jesuus utz, tal tek ech tzaꞌ: —Tiira tzaꞌl soꞌok tu viQꞌesalail u Tioxh qꞌuꞌl atil txꞌiibꞌal iqꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Aal yitꞌ tzaꞌl koj tokoꞌp u camello tixeꞌ u bꞌaj, vatz u tokoꞌp maꞌl txꞌiiol iqꞌii tu viQꞌesalail u Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ech tal tek qꞌu aanima ech tzaꞌ qꞌuꞌl abꞌin: —¿Abꞌil tek tech tu chitpichil tu qꞌul ipaav uncheeꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Pek tal u Jesuus ech tzaꞌ: —Kam qꞌu kam yeꞌk saveet vatz qꞌu aanima, saveet vatz u Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Uncheeꞌ aatz u Luꞌ, tal te ech tzaꞌ: —Aatz oꞌ, vetqaqꞌluka kajay qꞌu qetz utz, xameloꞌ saiꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Tal u Jesuus te ech tzaꞌ: —Niꞌxhtekꞌval sete, abꞌil qꞌuꞌl nitaqꞌka qꞌu tetz tiꞌ viQꞌesalail u Tioxh, saꞌnaltil iqꞌaqꞌal. Ech oj nitaqꞌka totzotz; nitaqꞌka tixoj, itzaꞌqꞌ, tatzik, itxutx ibꞌaal, tuchꞌ ikꞌaol imeꞌal, sikꞌul sibꞌal iqꞌaqꞌal tu u tiempo tzaꞌ. Utz satil iqꞌaqꞌal tu u atinchil tu bꞌenqꞌii bꞌensaj taabꞌaꞌbꞌen majte.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Isikꞌle el kabꞌlaal qꞌul ichusulibꞌ u Jesuus utz, tal te ech tzaꞌ: —Aatz loꞌoponoꞌ tu Jerusaleen, satzojpu kajay qꞌu kam tiꞌ u Kꞌaola vaꞌl bꞌennaj koꞌn aanima vaꞌl tzꞌibꞌamalka tu qꞌu alol tetz u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tan soꞌoksal tiqꞌabꞌ qꞌu puera aanima. Utz saꞌxhbꞌanbꞌeli. Saeesal iqꞌii. Utz satzubꞌali. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Utz aatz maꞌt itzꞌuꞌmaleꞌ, sayatzꞌaxi. Loqꞌ sakoꞌnqꞌaavitzꞌpu titoxvaꞌ qꞌii.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pek aatz qꞌu chusulibꞌ tan, nikoꞌxh bꞌoj el koj itxumbꞌal tu qꞌu kam tziꞌ. Yeꞌ tootzaj u tokebꞌal tan, mujel siatz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Aatz iꞌana, aꞌ chit nichinajabꞌ opon u Jesuus tu Jericoo, kꞌujlich maꞌl u moy tziꞌ bꞌey. Nichijoy tetz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Utz taꞌxh tabꞌi aas mam tenam nichipaaleꞌ, ichꞌoti tekuꞌen aas kam nichtucheꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ech alax te aas nichipaal u Jesuus aa Nazareet. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ech qꞌeqꞌun taltu ech tzaꞌ: —¡Jesuus ituꞌxh ixalam Daviid, txum unvatz!— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Pek aatz qꞌu aanima qꞌuꞌl bꞌaxaich, nichkoꞌnmotxiyaaeꞌ. Aꞌ isaꞌ sayaꞌ iqꞌeqꞌuneꞌ. Pek aal koꞌn maas nichiqꞌeqꞌuneꞌ: —¡Ituꞌxh ixalam Daviid, txum unvatz!— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ech txakeꞌ tek u Jesuus. Utz tal tiqꞌol ul siatz. Taꞌxh oponi, ichꞌoti te ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Kam asaꞌ sunbꞌan see?— Texh te. Tal ech tzaꞌ: —UnBꞌaal, aꞌ unsaꞌ sailon qꞌu bꞌaqꞌ unvatz tzaꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Tal u Jesuus te ech tzaꞌ: —Sajin. Tan tu koꞌn vikꞌujeꞌ akꞌuꞌl viꞌ, bꞌaꞌntꞌaxh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ech tu koꞌxh unmuꞌkꞌul iꞌan bꞌaꞌn qꞌu bꞌaqꞌ iatz. Sajin tekuꞌen. Utz xambꞌu tek tiꞌ u Jesuus. Vaꞌl toksat iqꞌii u Tioxh. Utz taꞌxh ilax u kam tu qꞌu mam tenam tziꞌ, toksa tek iqꞌii Tioxh majte. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Uncheeꞌ opon u Jesuus tu Jericoo. Nichtekipaal tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Utz atich maꞌl u vinaj tziꞌ txꞌiiol iqꞌii, qꞌesal jajol jaꞌmel alkavaar; Zaqueo ibꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nichiꞌan yaꞌl tilaxeꞌ abꞌil u Jesuus. Pek yeꞌ nichveet tiltu tu u mam tenam. Tan chꞌooich koꞌn itxakeꞌaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ech jutzin ibꞌaxabꞌeꞌ. Ex jeꞌoj viꞌ maꞌl u tzeꞌ sicoomoro tiꞌ tilax u Jesuus. Tan aalich ipaal tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Utz taꞌxh opon u Jesuus tziꞌ, sajin jeꞌ utz, tila. Ech tal te ech tzaꞌ: —Zaqueo, nal akuꞌl. Tan ministeer aꞌ savatkꞌin tzaxeꞌ cheel.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ech oojeꞌl chit kuꞌl u Zaqueo. Utz techalich itxuqꞌtxuneꞌ ikꞌul u Jesuus tu tatibꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Pek motx eesal iqꞌii u Jesuus tu qꞌu aanima tiꞌ vaꞌl iꞌana tziꞌ. Nichtal tiꞌ ech tzaꞌ: —Aꞌ savatku xeꞌ maꞌl aa paavla vinaj.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Pek aatz u Zaqueo tan, txakeꞌi utz, tal tu u kuBꞌaal ech tzaꞌ: —Aatz cheel unBꞌaal, nikꞌamil u txꞌiibꞌal unqꞌii savaqꞌ tu qꞌu meꞌbꞌaꞌ. Utz oj abꞌil maꞌj subꞌel vaqꞌo, kaa tanul tek iqꞌaav ichꞌexel sunbꞌaneꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Tal u Jesuus ech tzaꞌ: —Aatz cheel, ulyu u chitpichil tu paav tu u atibꞌal tzaꞌ. Tan nojla ituꞌxh ixalam Abrahaam u vinaj tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tan aatz u Kꞌaola vaꞌl bꞌennaj koꞌn aanima, aꞌ ul ichokeꞌ utz, aꞌ ul ichit tu paav qꞌuꞌl maꞌtich itzꞌejxeꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tuul nichtekinajabꞌ opon tu Jerusaleen utz, nichtabꞌi qꞌu yol qꞌu aanima tziꞌ. Loqꞌ nichmotxtitzꞌa aas kamal yak koꞌxh satoksa viQꞌesalail u Tioxh nichtaleꞌ. Echtzixeꞌt ikꞌam tiꞌ vaꞌt kam u Jesuus tu viyol. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Tal ech tzaꞌ: —Aatz iꞌan maꞌl u vinaj qꞌesala, bꞌen tzian tu vaꞌt tenam. Ex ikꞌul kꞌasuꞌl tijleꞌm. Utz qꞌaavuꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Utz aatz yeꞌsajich ibꞌenaꞌ, isikꞌle laval qꞌu taqꞌonom. Utz taqꞌka laval puaj te sijununil, ijaꞌmel 1,000 qꞌii aqꞌon. Utz tal te ech tzaꞌ: «Aqꞌoninojex tiꞌ u puaj tzaꞌ. Anal layaꞌex aas laqꞌaavuꞌlin.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pek aatz qꞌu aanima, qꞌuꞌl saꞌatin jaqꞌ imantaar, yeꞌt koꞌn motx isaꞌa u qꞌesala. Utz ichaj bꞌen ichaj xeꞌ u qꞌesala vaꞌl siꞌchaqꞌon tijleꞌm. Ex tal te ech tzaꞌ: «¡Yeꞌ kusaꞌ siꞌan qꞌesalail u vinaj tu kuxoꞌl tziꞌ!» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pek kꞌuxh echi, ikꞌul u tijleꞌm. Utz aatz qꞌaavuꞌl, tal isikꞌlel opon qꞌu taqꞌonom siatz qꞌuꞌl maꞌtich taqꞌtu puaj te. Ech satileꞌ jankꞌal vetiꞌan kanaal tiꞌ sijununil. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ech ul u bꞌaxa utz, tal te ech tzaꞌ: «Unbꞌaal, aatz u puaj vetaaqꞌka ve, vettalal lavate.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Tal tek u qꞌesala te ech tzaꞌ: «Aꞌtzii bꞌaꞌnla aqꞌonom. Tiira jikom vetaꞌana kꞌuxh bꞌiil koꞌxhtuꞌ. Ech aatz cheel, saꞌatin iijleꞌm viꞌ laval tenam.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ul vikaꞌbꞌ. Tal te ech tzaꞌ: «Unbꞌaal, aatz u puaj vetaaqꞌka ve, vettalal oꞌvaꞌte.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Echat koꞌxh tal te ech tzaꞌ: «Ant axh majte, saꞌan qꞌesalail viꞌ oꞌvaꞌl tenam.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Pek ul vaꞌte utz, tal ech tzaꞌ: «Unbꞌaal, atil vapuaj tzuta vaꞌl vetaaqꞌka ve. Kolel koꞌn vaqꞌo tu maꞌl suꞌt. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Vetunxoꞌvaꞌaxh. Tan vootzajle aas axh maꞌl vinaj yeꞌ chit kam chajpeꞌl saaqꞌo. Aal niiqꞌo qꞌu kam kꞌuxh yitꞌ eetz koj. Utz nachok iatz qꞌu chikobꞌeꞌm kꞌuxh yitꞌ axh koj nichikon.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Uncheeꞌ tal tek u qꞌesala te ech tzaꞌ: «¡Yeꞌxtxojla aqꞌonom! Vatziꞌ nixochonjeꞌaxh. Oj ootzajle aas in maꞌl vinaj yeꞌ chit kam chajpeꞌl vaqꞌo. Aal niviqꞌo vaꞌl yitꞌ vetz koj. Utz nunchok iatz u chikobꞌeꞌm vaꞌl yitꞌ in koj nichikon. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Kantuꞌ uncheeꞌ, yeꞌn aaqꞌ vunpuaj tu kꞌam? Ech aꞌ tek imol tal sunkꞌul koj aas suꞌulin.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ech tal u qꞌesala tu qꞌu aanima qꞌuꞌl atich opon ech tzaꞌ: «Maataj el u puaj te tziꞌ. Utz aqꞌtaj tu vaꞌl laval ipuaj atile.» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Pek aatz qꞌu aanima tan, motx tal te ech tzaꞌ: «¡Kubꞌaal, atil nal laval ipuaj atziꞌ!» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Tal u qꞌesala ech tzaꞌ: «Nival sete aas kꞌuxh atil nal tetz maꞌl u aanima, aal saꞌaqꞌax tereꞌn tetz. Pek aatz vaꞌl yeꞌk tetz, aal samaaleꞌl te jankꞌal vaꞌl atil tzixeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pek aatz qꞌul unkoontra qꞌuꞌl yeꞌt isaꞌ vunqꞌesalail, iqꞌotaj ul sunvatz tzaꞌ. Utz sunvatz seyatzꞌeꞌ.» Chia.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Aatz veet taltu u kam u Jesuus tziꞌ, bꞌaxabꞌ vatz qꞌu aanima aal ibꞌen tu Jerusaleen. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Utz aatz opon viꞌ u muunte Olivo kꞌatz qꞌu tenam Betfagee tuchꞌ Betaania, ichaj bꞌen kaꞌvaꞌl qꞌul ichusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Tal te ech tzaꞌ: —Bꞌenojex tu u tal tenam sukuvatz bꞌen tzuta. Utz taꞌxh loꞌoponex tuul, setil maꞌl u chelem bꞌuuro qitzel. Yeꞌsaj ijeꞌ maꞌj aanima tiꞌ. Ech chittaj utz, iqꞌotaj kꞌasuꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Utz oj abꞌil maꞌj laꞌalon: «¿Kantuꞌ nechiteꞌ?» Chaj. Letal te ech tzaꞌ: «Tan nisavsa u kuBꞌaal.» Chajex.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ech bꞌen qꞌuꞌl chajaxi utz, til u bꞌuuro kam chit echaꞌ vaꞌl tal u Jesuus te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Utz tuul nichmotxichiteꞌ, alax te tu qꞌul ibꞌaal ech tzaꞌ: —¿Kantuꞌ nechit u bꞌuuro tziꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Motx tal ech tzaꞌ: —Tan u kuBꞌaal nisavsan.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ech tiqꞌo ul vatz u Jesuus. Taqꞌ jeꞌ qꞌul ikaapa tiꞌ. Utz motx taqꞌ jeꞌ u Jesuus tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tuul nichixaan u Jesuus tiꞌ u bꞌuuro, nichmotxiliiu kuꞌ qꞌul ikaapa qꞌu aanima tibꞌey. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Utz aatz nichinajabꞌ opon tu u kuꞌnaj, vatz u muunte Olivo, kajay qꞌu niman tetz xamich tiꞌ. Vaꞌl motx iqꞌeqꞌuneꞌ, techal motx itxuqꞌtxuneꞌ. Nichtoksa iqꞌii u Tioxh tiꞌ kajay qꞌu mamala chaj txaichil qꞌuꞌl maꞌt tiltaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nichtal ech tzaꞌ: —¡Techal u ijlenal vaꞌl tibꞌii u kuBꞌaals Amlika vetꞌulka! Tan ¡satoksa ibꞌaꞌn qꞌu aanima tuchꞌ u Tioxh tu Amlika! ¡Techal u Tioxh tu Amlika!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ech aatz unjolol qꞌu fariseo qꞌuꞌl atich xoꞌl tenam, tal tu u Jesuus ech tzaꞌ: —Chusul, yaꞌsa iqetun qꞌul achusulibꞌ tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Nival sete, oj sayaꞌ iqetun qꞌu aanima tziꞌ, aꞌ tek saqetun qꞌu sivan tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Aatz tek opon najaꞌch u Jerusaleen, isaji bꞌen utz; oqꞌ tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Tal ech tzaꞌ: —Bꞌaꞌn atziꞌ maꞌkojetootzaji kaniꞌch tok ebꞌaꞌn tuchꞌ u Tioxh. Tan aꞌ u tiempo tzaꞌ; pek mujel sevatz cheel. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tan saꞌnalul tiempo aas sisuti etiꞌ qꞌul ekoontra. Sichok jeꞌabꞌalop tiꞌ vitzꞌachil u tenam. Sipeꞌi etiꞌ. Utz til chaj koꞌxh siꞌanvu sete. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Sibꞌaj kuꞌ vetenam. Utz sanilpu vitzꞌachil. Yeꞌk vaꞌtoj sivan saꞌkojkaa tibꞌa imol. Ech siyatzꞌex tuchꞌ enitxaꞌa tan, yeꞌn paal etxumbꞌal tuul aas ex vetꞌuliqꞌilaꞌex viTxaaom u Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ech opon u Jesuus tu viqꞌanalil u totztioxh. Utz xeꞌt tojcha eluꞌl kajay qꞌuꞌl nichikꞌayin tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Tal ech tzaꞌ: —¡Tzꞌibꞌamalka tu u Yolbꞌal Tioxh: «Qꞌilabꞌ sikꞌlebꞌ Tioxh viqꞌanalil u totztioxh!» Chia. Pek aatz ex, ¡vetetaqꞌlu bꞌen tatibꞌal elqꞌom!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Utz jun qꞌii nichichusun tu viqꞌanalil u totztioxh. Pek aatz qꞌu qꞌesal oksan yol vatz Tioxh, nichikꞌaj tiꞌ siyatzꞌeꞌ. Antu qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar tuchꞌ qꞌu qꞌesal tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pek yeꞌ nichichee sikꞌuꞌl kaniꞌch iveet siꞌaneꞌ tan, kajay aanima bꞌennajich ikꞌuꞌl tiꞌ tabꞌil vichusbꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Aatz iꞌan tu maꞌl u qꞌii, nichichus qꞌu aanima u Jesuus tu viqꞌanalil u totztioxh. Nichipaxsa itziiul u bꞌaꞌnla chusbꞌal. Tuul opon qꞌu qꞌesal oksan yol vatz Tioxh, tuchꞌ qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar utz, tuchꞌ qꞌu qꞌesal qꞌatol tzii. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Utz motx tal te ech tzaꞌ: —Al qe, ¿kam iijleꞌm aas naꞌan qꞌu kam tziꞌ? Utz ¿abꞌil vetaqꞌon val iijleꞌm tiꞌ ibꞌanaxeꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Tzaqꞌbꞌu u Jesuus ech tzaꞌ: —Sunchꞌoti maꞌl kam sete majte. Utz tzaqꞌbꞌetajin. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿U Tioxh tzik chajon u Xhan aas ul iꞌan vautisaar aanima, oj itxumbꞌal koꞌn aanima toksa?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ech nichmotxtal sivatzaj ech tzaꞌ: —«Tioxh chajon.» Oj chajoꞌ: «¿Kantuꞌ yeꞌt enima?» Chaj qe atziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Utz oj: «Itxumbꞌal koꞌn aanima.» Chajoꞌ, kajay qꞌu aanima sapaqꞌon sivan oꞌ atziꞌ. Tan nimotxtaleꞌ aas nojchit alol yolbꞌal Tioxh u Xhan.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ech motx tzaqꞌbꞌi utz, tala: —Yeꞌ qootzaj abꞌil chajon.— Texh kuꞌen. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ech tek tal u Jesuus te ech tzaꞌ: —Uncheeꞌ yitꞌ saꞌkojval sete majte abꞌil aqꞌon vijleꞌm tiꞌ qꞌu kam nunbꞌaneꞌ tzaꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ech ikꞌam tiꞌ maꞌl kam u Jesuus, xeꞌt tal tu qꞌu aanima ech tzaꞌ: —Aatz iꞌan maꞌl u vinaj, ichik untanul iuuva. Utz taqꞌka kꞌam tunjolol aqꞌonom. Ech bꞌeni. Sibꞌal tiempo ulka. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Utz aatz opon u tiempo qꞌanbꞌebꞌal uuva, ichaj opon maꞌl taqꞌonom xeꞌ qꞌu kꞌamol, tiꞌ ul tiqꞌol u kꞌambꞌal. Ayaꞌ untanul vivatz u chikobꞌeꞌm. Pek aatz qꞌu kꞌamol tziꞌ, motx iqꞌosa. Utz ichaj kꞌasuꞌl. Nikoꞌxh bꞌoj taqꞌ kꞌasuꞌl tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ichaj paj chit bꞌen vaꞌt taqꞌonom u bꞌaal chikobꞌeꞌm tziꞌ. Utz motx koꞌn paj iqꞌosa. Iyoqꞌa. Ech iqꞌaavixsa kuꞌen. Yeꞌxhkam maꞌj taqꞌ kꞌasuꞌl tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ichaj paj chit vaꞌte, u toxvaꞌ tekuꞌen. Pek motx koꞌn ipaaseꞌluꞌl vaꞌt vaꞌl tziꞌ. Takꞌonsa kꞌasuꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Uncheeꞌ aatz u bꞌaal chikobꞌeꞌm, tal tek ech tzaꞌ: «¿Kam sunbꞌaneꞌ? Aꞌ tek sunchaj bꞌen vunkꞌaol vaꞌl tiira tiiꞌin tiꞌ. Kamal atil tek bꞌoj tatin siatz liꞌana.» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pek taꞌxh motx til qꞌu kꞌamol, xeꞌt motx iyol sivatzaj ech tzaꞌ: «Aꞌ vaꞌl saokka tu vimeꞌbꞌiꞌl vitat atziꞌ. Pek niꞌextaj, kuyatzꞌtaj. Ech oꞌ tek saokkaꞌoꞌ tu u tetz.» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ech motx ipaasat eluꞌl tiꞌ u chikobꞌeꞌm tziꞌ utz, iyatzꞌa. Ech ¿kam tek bꞌoj siꞌan u bꞌaal txꞌavaꞌ nenacheꞌ? ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Aatz siꞌaneꞌ tan, suꞌlisotzsa qꞌu kꞌamol. Ech sataqꞌ u chikobꞌeꞌm tunjot aanima.— Texh u Jesuus. Ech taꞌxh tabꞌi u yol qꞌu aanima tziꞌ, paal itxumbꞌal tuul. Utz motx tal ech tzaꞌ: —¡Yeꞌ koj jatu iꞌan u kam tziꞌ!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pek sajil tu u Jesuus utz, tal te ech tzaꞌ: —¿Kam tok u yol nenacheꞌ vaꞌl tzꞌibꞌamalka nital ech tzaꞌ?: «Aatz u Sivan vaꞌl taqꞌka eloꞌp qꞌu bꞌanol otzotz echil tziꞌ, aal aꞌ u Sivan tiira ibꞌoꞌqꞌol tetz xoobꞌal.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ech abꞌil qꞌuꞌl sakuꞌ viꞌ u Sivan tziꞌ, sakꞌaxbꞌi. Pek abꞌil qꞌuꞌl lakuꞌ u Sivan tiꞌ tziꞌ, bꞌaꞌntan sajuyajti.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ech aatz qꞌu qꞌesal oksan yol vatz Tioxh tuchꞌ qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar, siꞌchtekitxay u Jesuus tu u muꞌkꞌul tziꞌ. Tan el itxumbꞌal tuul aas aꞌ qꞌuꞌl nichtalax tu u kam ikꞌam tiꞌ. Pek motx ixoꞌva qꞌu tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ech motx ichajtu bꞌen unjolol eesan yol qꞌu fariseo aas vet sikꞌuꞌl taqꞌ bꞌen tibꞌ jikomla aanima. Aꞌ isaꞌ tabꞌit iyolpu u Jesuus tiꞌ maꞌj yol. Ech samotxixoch tu u governadoor. Utz satoksa tiqꞌabꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ech vet sikꞌuꞌl motx ichꞌoti te ech tzaꞌ: —Chusul, qootzale aas tinujul nachusuneꞌ, nayoloneꞌ. Yeꞌk tel aanima saatz. Pek tuchꞌ chit inujul nichusunkꞌaxh tiꞌ u bꞌenchil xeꞌ Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Pek al qe ¿bꞌaꞌn tzik aas nikuchoo jaꞌmel alkavaar tu u ijlenal Cesar, pek oj yeꞌka?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Aatz u Jesuus, paal itxumbꞌal tuul aas eesa yol niꞌan qꞌu vinaj tziꞌ; jolol subꞌul. Utz tal te ech tzaꞌ: —¿Kam tokeꞌ aas vet sekꞌuꞌl nechꞌoti kam ve? ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Kꞌuchtaj u puaj ve. ¿Abꞌil etz u vatzibꞌal atoꞌk siatz tziꞌ utz, abꞌil etz u bꞌii tzꞌibꞌamal ok siatz majte tziꞌ?— Texhtuꞌ. Motx tzaqꞌbꞌu ech tzaꞌ: —Tetz u Cesar.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tal u Jesuus te ech tzaꞌ: —Aqꞌtaj tu u Cesar kam tiꞌ vaꞌl nichoonkꞌex te. Utz aqꞌtaj tu u Tioxh abꞌiste u tetz u Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ech yeꞌt yolpu u Jesuus tiꞌ maꞌj yol vatz qꞌu tenam kam tiꞌ sitxayva. Pek aal motx texh sotz ikꞌuꞌl tu vitzaqꞌbꞌu u Jesuus. Utz motx texh jutzeꞌi. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Uncheeꞌ aꞌ tek opon unjolol qꞌu saduceo. Ayaꞌ qꞌuꞌl yeꞌxhkam nimotxinima u qꞌaavtitzꞌpu qꞌu kamnaj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Utz ichꞌoti te ech tzaꞌ: —Chusul, aatz u Moisees, itzꞌibꞌaka aas: «Oj sakam maꞌj vinaj utz, sakaa tixoj, loqꞌ yeꞌk initxaꞌa sakaai, sikꞌulka tibꞌ u tzaꞌqꞌa tuchꞌ u tixoj tziꞌ. Ech sachee ichꞌexel u tatzik tziꞌ.» Texh u Moisees. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pek atich jujvaꞌl qꞌu vinaj itzaꞌqꞌ tibꞌ. Aatz iꞌan u bꞌaxa, tzumeꞌi. Pek kam kuꞌen, yeꞌk initxaꞌa kaai. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ech iqꞌol u ixoj tu u kaꞌbꞌ vinaj tziꞌ. Utz kam koꞌn pajeꞌ, yeꞌk initxaꞌa kaai. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ech iqꞌol u ixoj tu u toxvaꞌ vinaj tziꞌ. Pek kam koꞌn pajeꞌ. Utz ech koꞌxh iꞌan jujvaꞌl. Yeꞌk initxaꞌa kaai. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Utz tiyaꞌtebꞌal, aꞌ tek kam u ixoj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Pek aatz tu u qꞌaavitzꞌpichil, ¿abꞌil tek etz ixoj u ixoj liꞌana tziꞌ? Tan tixojich jujvaꞌl qꞌu vinaj.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ech tek itzaqꞌbꞌu u Jesuus utz, tal te ech tzaꞌ: —Aatz qꞌu aanima tu u tiempo tzaꞌ tan, nimotxtok tiꞌ ixoj utz, nitzumeꞌaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pek aatz siꞌan tu u bꞌenqꞌii bꞌensaj, yeꞌkan satzumeꞌ qꞌu aanima qꞌuꞌl likꞌuloꞌk tiꞌ soꞌok tu vaꞌt u atinchil tziꞌ, aas laqꞌaavitzꞌpu xoꞌl qꞌu kamnaj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Saꞌtereꞌnkojveeti sakami. Tan ech tekuꞌen aꞌ qꞌu aanjel siꞌaneꞌ aas maꞌt iqꞌaavtitzꞌpeꞌ tan, ikꞌaol imeꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Pek aatz tiꞌ u qꞌaavtitzꞌpu qꞌu kamnaj netaleꞌ tziꞌ, chusun u Moisees tu u yol tiꞌ u chꞌiꞌx aas tal tu u kuBꞌaal ech tzaꞌ: «ITioxh u Abrahaam, iTioxh u Isaac utz, iTioxh u Jacob.» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Tan aatz u Tioxh, yitꞌ iTioxh koj kamnaj, pek iTioxh itzꞌlich. Utz yeꞌxhkam nisotz qꞌu aanima siatz qꞌuꞌl nikameꞌ.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ech tzaqꞌbꞌel tu unjolol qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar ech tzaꞌ: —Chusul, bꞌaꞌn vaꞌl naaleꞌ tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ech yeꞌxhabꞌil veꞌt nichqꞌiꞌon ichꞌotil kam tu u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Uncheeꞌ tal u Jesuus te ech tzaꞌ: —¿Kan chaj tok netaleꞌ aas ituꞌxh ixalam Daviid viTxaaom u Tioxh? ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tan u Daviid atkoꞌxh tzꞌibꞌanka tu u Salmos ech tzaꞌ: «Tal u Tioxh tu vunBꞌaal: Kꞌujach tunsebꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Tan saꞌnalvoksa qꞌul akoontra satzeqꞌlebꞌal. Chia.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ech oj “unBꞌaal” chu u Daviid tiꞌ, ¿kam tek tokeꞌ untzꞌoj ituꞌxh ixalam kuꞌen?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tuul nichtabꞌil tu kajay qꞌu aanima, tal tu qꞌul ichusulibꞌ ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Kuentaꞌex tiꞌ qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar. Tan vatz chit ikꞌuꞌl paalchil tuchꞌ chelkin oksaꞌm. Utz aꞌ chit isaꞌ vaꞌl kalaman taqꞌax ichajlichil tu qꞌu kꞌayibꞌal. Utz vatz chit ikꞌuꞌl kuꞌchil tu qꞌu bꞌaxa chaj kꞌujlebꞌal tu qꞌu atibꞌal chusbꞌal tetz u oꞌtla mantaar, tuchꞌ tu qꞌu bꞌaxa chaj kꞌujlebꞌal til niꞌuchku txꞌaꞌom. ");
INSERT INTO ixlCNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Utz nimotxisubꞌ tzaj txakay ixoj. Nimotximaa tzaj tetz. Ech vet chit sikꞌuꞌl niꞌaneꞌ, sibꞌ chit tuul qꞌul iqꞌilat isikꞌlet Tioxh. Pek loqꞌ sibꞌ u choobꞌal paav saꞌalax ikuꞌ tiꞌ tu qꞌuꞌl niꞌaneꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Uncheeꞌ sajin bꞌen u Jesuus utz, til qꞌu txꞌiiol iqꞌii aas nichmotxtaqꞌ kuꞌ ipuaj tu u kaaxha molbꞌal kutxu. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ech til maꞌl u txakay ixoj majte, tiira meꞌbꞌiꞌl tetz. Taqꞌ kuꞌ kaꞌvaꞌl puaj tiira chꞌoo tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ech tal tek u Jesuus ech tzaꞌ: —Nojchit nival sete, sibꞌal puaj vettaqꞌ koꞌp u txakay ixoj tziꞌ, kꞌuxh meꞌbꞌiꞌl tetz viꞌ tereꞌn qꞌuꞌl vettaqꞌ koꞌp tetz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tan kajay qꞌuꞌl vettaqꞌ ikutxu, taꞌxh vettaqꞌa qꞌu chan puaj. Pek ech koj u ixoj tziꞌ, kꞌuxh meꞌbꞌiꞌl tetz, nojchit aꞌ vetimoxsaka jankꞌal vantziꞌ nitiloꞌk tetz techbꞌubꞌal.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Aatz iꞌan unjolol qꞌu aanima, nichmotxiyolon tiꞌ u totztioxh, tiꞌ vivijax viqꞌanalil tu bꞌaꞌnla chaj sivan utz, tiꞌ jankꞌal kutxu puaj oknaj tiꞌ iveeteꞌ. Tal tek u Jesuus te ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Aatz qꞌu kam qꞌuꞌl netileꞌ tziꞌ tan, saꞌnalul tiempo aas sanilaxi. Nikoꞌxh vaꞌtoj sivan sakaa tibꞌa imol; kajay sakuꞌi.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ech chꞌotil te ech tzaꞌ: —Chusul, ¿jatu suꞌuch u kam naaleꞌ tziꞌ? Utz ¿kam xheenya saꞌatini aas saꞌtexhuch qꞌu kam tziꞌ?— Texh teꞌleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Tal u Jesuus ech tzaꞌ: —Kuentaꞌex, abꞌilich eesanex tu bꞌey. Tan sibꞌal koꞌxh sauli sikꞌam tiꞌ vunbꞌii. Satal ech tzaꞌ: «In viTxaaom u Tioxh. Ulyu u tiempo.» Chaj. Loqꞌ xambꞌiꞌchꞌokꞌex tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Utz xoꞌvichkoꞌxhex tiꞌ aas letabꞌi vaꞌl texh tuch chꞌaꞌo. Utz setabꞌi iyolax chꞌaꞌo. Tan ministeer chit suꞌuch qꞌu kam bꞌaxa tziꞌ. Loqꞌ yitꞌ yak koj suꞌul u motxebꞌal qꞌii saj tiꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tal paj ech tzaꞌ: —Saꞌnalmotxiꞌan chꞌaꞌo qꞌu mamaj tenam tibꞌilaj. Utz siꞌan chꞌaꞌo qꞌu ijlenal tibꞌilaj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Til chaj koꞌxh sapaalku mamaj kabꞌnaano, mam vaꞌy, mam yaabꞌil. Mamaj xoꞌvebꞌalla kam sauchi. Utz mamaj xheenya sachee tu amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pek aatz yeꞌsajen tuch kajay qꞌu kam tziꞌ, soꞌojchalex, satxaypꞌex tiꞌ inimal vunbꞌii. Siꞌiqꞌolbꞌenex tu qꞌu atibꞌal chusbꞌal tetz u oꞌtla mantaar. Soꞌoksalex tu tzeꞌ. Saxochpꞌex vatz ijlenal tuchꞌ vatz governadoor. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ech tu qꞌu kam tziꞌ, saveeti sepaxsa itziiul u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pek txakbꞌaꞌtaj tetaanima aas yeꞌk setitzꞌa kaniꞌch etzaqꞌbꞌu tiꞌ qꞌu xochbꞌal etetz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tan in saꞌaqꞌon eyol. Utz in saoksan etxumbꞌal aas yeꞌxhabꞌil koꞌxh tech tiꞌ. Utz saꞌkojoleꞌ qꞌu xeꞌkꞌulan etetz tiꞌ iqꞌatl evatz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Tan antu qꞌul etxutx ebꞌaal, saꞌaqꞌonex tu txaypichil; qꞌul etatzik etzaꞌqꞌ tuchꞌ qꞌul etitzꞌin etatzik utz, tuchꞌ qꞌul etamiigo. Utz sayatzꞌpu unjololex taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Utz kajay aanima sachiꞌkꞌulanex. Loqꞌ viꞌ kuꞌen. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pek nikoꞌxh maꞌj xiꞌl eviꞌ satzꞌejxi. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tan tu koꞌn vetxꞌaktu qꞌu kam tziꞌ, seꞌel qꞌul etaanxelal vatz tzaꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Pek taꞌxh letila aas sutimal tek tiꞌ u Jerusaleen tu sol, paaloj etxumbꞌal tuul aas u sotzchil oponyu tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ech aatz qꞌuꞌl atil tikuenta Judea, oojoj bꞌen tulaj muunte. Abꞌil qꞌuꞌl atil tu Jerusaleen, eloj bꞌen. Utz uliꞌch tereꞌn tu tenam qꞌuꞌl ayeꞌn tulaj jaꞌjtzeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tan mamala choobꞌal paav sataqꞌuꞌl u Tioxh tu qꞌu qꞌii tziꞌ. Ech satzojpu kajay qꞌu kam qꞌuꞌl tzꞌibꞌamalka. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Pek tilayol sayaꞌk qꞌu ixoj siꞌan tu qꞌu qꞌii tziꞌ, qꞌuꞌl atil tu tiichajla yaabꞌil, tuchꞌ qꞌuꞌl nichꞌuꞌn titzꞌin. Tan mamala kꞌaxkꞌo suꞌuch tu vatz txꞌavaꞌ. Sakuꞌ vikꞌaꞌnal u Tioxh tiꞌ u tenam tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Atia tzokꞌel ikam sakami. Atia preexhu ibꞌenaꞌ. Til koꞌn tenam samotxiqꞌolik bꞌen. Utz saokebꞌel u Jerusaleen tu qꞌu puera aanima, tzojpu nal chit u tiempo jankꞌal siꞌan qꞌu puera aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Utz saꞌatin xheenya tu u qꞌii, tu u ichꞌ utz, tuchꞌ tu qꞌu txꞌumiꞌl. Sijal tiloneꞌ. Utz saꞌxhkꞌaybꞌu qꞌu aanima taqꞌo tu vatz amlika txꞌavaꞌ. Utz saꞌxhmotxxoꞌvi, sakaa taanima tu vijelun u mar tuchꞌ tu vipilqꞌaꞌtxaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Utz sanumtzꞌu kuꞌ aanima tu xoꞌval tu poyqꞌichil tiꞌ kajay qꞌu kam suꞌuch tu u vatz amlika txꞌavaꞌ. Tan aal sayikun kajay qꞌu kam atil tu amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ech sailax tul tu sutzꞌ u Kꞌaola vaꞌl bꞌennaj koꞌn aanima tu u techalla tijleꞌm tuchꞌ vixamlil. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Pek taꞌxh laxeꞌttuch qꞌu kam tzaꞌ, tii ekꞌuꞌl. Utz sajinojjeꞌex tu amlika tan, aꞌ najabꞌyu vetel vatz qꞌu tzaꞌl.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Tal maꞌl u yol u Jesuus; ikꞌam tiꞌ kam tal ech tzaꞌ: —Etootzajnale kam vaꞌl niꞌan qꞌu viikuxh tuchꞌ tereꞌn qꞌu tzeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tan taꞌxh nichee talaj ixaj, yak at niꞌenku sete aas u saqꞌi ninajabꞌeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Echat koꞌxh majte, aatz letil kajay qꞌu kam tziꞌ, ootzajitaj aas najabꞌyu tul viQꞌesalail u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Tan niꞌxhtekꞌval sete, aas yeꞌsajen koꞌxh isotz untanul qꞌu aanima itzꞌlel tu tiempo tzaꞌ, suꞌuch kajay qꞌu kam tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Sakoꞌnpaal u vatz amlika txꞌavaꞌ kajayil; pek aatz vunyolbꞌal, jatu koj sapaali. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Pek kuentaꞌex sejununil. Eteesach koꞌxh etxumbꞌal tu bꞌey tiꞌ tachval qꞌu kam. Echaꞌ tziꞌ yeꞌk enooebꞌal tiꞌ tuchꞌ tiꞌ qꞌabꞌaꞌm utz, tiꞌ qꞌu elaꞌokchil tu u atinchil tzaꞌ. Tan yeꞌk talcheꞌ noj tul u qꞌii utz, paarten netitzꞌa. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Noj iꞌaneꞌ sakuꞌ setiꞌ echaꞌ ikuꞌ kꞌaa. Tan maꞌl ikuꞌ tiꞌ qꞌu aanima kajayil tu u vatz amlika txꞌavaꞌ tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ech nachnoj etatin bꞌenamen. Utz qꞌilataj sikꞌletaj Tioxh. Ech leꞌelex tu qꞌu tiila chaj kam qꞌuꞌl suꞌuchi tziꞌ. Utz ech loꞌoponex vatz u Kꞌaola vaꞌl bꞌennaj koꞌn aanima.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nichichusun u Jesuus tu viqꞌanalil u totztioxh qꞌiil. Pek nichikꞌasuꞌl sotzsaj. Aꞌ nichkaak viꞌ u muunte Olivo. ");
INSERT INTO ixlCNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Utz sibꞌla aanima nichtopon tu viqꞌanalil u totztioxh qꞌalaꞌm tiꞌ tabꞌileꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Uncheeꞌ nichtekinajabꞌ u nimla qꞌii vaꞌl nichipaasal tiꞌ u Elchil Vatz Kamchil Tu Egipto, vaꞌl nitxꞌaꞌl u kaxhlaan txꞌix yeꞌk itxꞌamal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Utz aatz qꞌu qꞌesal oksan yol vatz Tioxh tuchꞌ qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar, nichmotxichokeꞌ aas kaniꞌch iyatzꞌax u Jesuus siꞌaneꞌ. Loqꞌ nichmotxixoꞌva u mam tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Pek ok u txꞌiꞌliꞌinaj kꞌatz u Judas aa Cariote vaꞌl atich ok xoꞌl kabꞌlaal qꞌu chusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ech bꞌen xeꞌ qꞌu qꞌesal oksan yol vatz Tioxh tuchꞌ qꞌu qꞌesal xeen tetz vikuentail u totztioxh. Ex tal te aas kaniꞌch toksal u Jesuus tiqꞌabꞌ siꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ech motx chit txuqꞌtxuni. Utz motx iꞌan maꞌl iatz aas sataqꞌ ipuaj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ech taqꞌt iqul u Judas tuul. Utz ichok tek txumbꞌal kaniꞌch toksal u Jesuus tiqꞌabꞌ siꞌaneꞌ aas yeꞌk siꞌilax tu u mam tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Uncheeꞌ opon tek u nimla qꞌii Txꞌaꞌbꞌal Kaxhlaan Txꞌix Yeꞌk Itxꞌamil. Utz nichiyatzꞌax maꞌl karneꞌl tu u qꞌii tziꞌ majte, tiꞌ u Elchil Vatz Kamchil Tu Egipto. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ech aatz u Jesuus tan, ichaj bꞌen u Luꞌ tuchꞌ u Xhan. Tal te ech tzaꞌ: —Bꞌenoj ebꞌan tuch u echbꞌubꞌal vaꞌl nitechbꞌul tu u nimla qꞌii. Ech laqechbꞌu.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Motx tzaqꞌbꞌu ech tzaꞌ: —¿Til asaꞌ sakubꞌanvu tucheꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tal u Jesuus te ech tzaꞌ: —Aatz cheel, taꞌxh soꞌokoꞌpꞌex tu u tenam, soꞌok maꞌl u vinaj tebꞌey. Iqꞌomal maꞌl txeꞌn aꞌ taqꞌo. Utz laxambꞌubꞌenex tiꞌ til u atibꞌal loꞌokka. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Utz letal tu u bꞌaal atibꞌal ech tzaꞌ aas loꞌoponex: «Nital u Chusul aas: ¿Keꞌch u atibꞌal vaꞌl savechbꞌuv u echbꞌubꞌal tuchꞌ qꞌul unchusulibꞌ tiꞌ u nimla qꞌii? Chia.» Chajex te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ech sikꞌuch maꞌl u nimla tuul otzotz sete tikaꞌ chupul. Bꞌanel tek tucheꞌ. Ech lechꞌiansa qetz tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ech motx bꞌeni. Utz ichabꞌa u atibꞌal kam chit echaꞌ vaꞌl alax te. Utz ech motx iꞌan tuch u echbꞌubꞌal tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Uncheeꞌ opon tek u oora tetz u txꞌaꞌnbꞌal, kꞌujeꞌ u Jesuus vatz meexha tuchꞌ qꞌul ichusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Utz tal te ech tzaꞌ: —Tiira nuntxuqꞌtxuneꞌ aas saꞌtekvechbꞌu u echbꞌubꞌal setuchꞌ vaꞌl nitechbꞌul cheel aas yeꞌsaj unpaal tu kꞌaxkꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Tan nival sete aas yitꞌ saꞌtereꞌnkojvechbꞌu u echbꞌubꞌal nibꞌanaxeꞌ tzaꞌ, pek analen aas latzojpu viQꞌesalail u Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ech itxay u ukꞌabꞌal tuchꞌ u taꞌl uuva utz, taqꞌ taꞌntioxh tiꞌ. Ech tal tzaꞌ: —Ukꞌataj utz, jatxtaj paal sevatz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Tan nojchit nival sete, yeꞌxhjatu veꞌt savukꞌa u taꞌl uuva tzaꞌ, pek analen luꞌul viQꞌesalail u Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ech itxay maꞌl kaxhlaan txꞌix utz, taqꞌ taꞌntioxh tiꞌ. Ech ijatxa. Taqꞌ tetz qꞌul ichusulibꞌ. Tal te ech tzaꞌ: —Aꞌ vunchiꞌl atziꞌ vaꞌl aqꞌel setiꞌ. Utz lebꞌan u kam majte tziꞌ, ech senachpixsa vaꞌl sunbꞌan setiꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Echat koꞌxh iꞌana aas veet motx itxꞌaꞌneꞌ, itxay u ukꞌabꞌal. Tal ech tzaꞌ: —Aatz u aꞌ atil tu u ukꞌabꞌal tzaꞌ, aꞌ vunkajal nikuꞌ setiꞌ sekajayil atziꞌ. Aꞌ u akꞌ nukꞌuꞌm nunbꞌan setuchꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pek aatz vaꞌl sakꞌayinin, atil sunkꞌatza vatz meexha cheel. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tan aatz u Kꞌaola vaꞌl bꞌennaj koꞌn aanima, nojchit aꞌ nipaalku tu qꞌu kam qꞌuꞌl kꞌajel tiꞌ tu u Tioxh. Pek tilayol sayaꞌk u vinaj vaꞌl saoksan tiqꞌabꞌ qꞌu txayol.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ech xeꞌt motx iyol qꞌu chusulibꞌ sivatzaj aas abꞌiste chaj sabꞌanon u kam tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ech xeꞌt motx itxay tibꞌ tu yol majte, tiꞌ aas abꞌil chaj saꞌatin tijleꞌm tixoꞌl nichmotxtaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pek tal u Jesuus te ech tzaꞌ: —Aatz qꞌu ijlenal tetz qꞌu puera aanima, nimotxibꞌensa tibꞌ qꞌesal viꞌ qꞌu aanima. Utz aatz qꞌuꞌl atil tijleꞌm tziꞌ “bꞌanol bꞌaꞌnil” chu teꞌleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pek yitꞌeꞌch koj sebꞌaneꞌ. Tan aal sataqꞌ bꞌens tibꞌ chꞌooala abꞌiste vaꞌl qꞌesala texoꞌl. Utz aatz vaꞌl qꞌesala tiꞌ tiqꞌol qꞌu kam, aal aꞌ vaꞌl maas salochon texoꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Tan ¿abꞌil vaꞌl maas tijleꞌm nenacheꞌ? ¿Aꞌ tzik aꞌ vaꞌl nikꞌujeꞌ vatz meexha, oj ayaꞌ vaꞌl nikꞌulaneꞌ? Aꞌ atil tijleꞌm vaꞌl nikꞌujeꞌ vatz meexha. Pek aatz u vatin texoꞌl, echaꞌ kꞌulanal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Pek jatvaꞌl ex atilex sunkꞌatza, ela vetetxꞌak qꞌu tzaꞌl viꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Savaqꞌ etijleꞌm, maꞌl eqꞌesalail, echaꞌ u vijleꞌm vettaqꞌ vunTat. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ech seꞌechbꞌunex suꞌukꞌaꞌex sunkꞌatza vatz meexha tu vunQꞌesalail. Utz sakꞌujeꞌex tu qꞌu kꞌujlebꞌal qꞌesala. Aꞌ seqꞌat tzii xoꞌl kabꞌlaa tanul qꞌu Israeel.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Tal paj u kuBꞌaal ech tzaꞌ: —Xhim, Xhim nijajaxh u txꞌiꞌliꞌinaj aas saꞌxhtulebꞌeꞌaxh, echaꞌ ichꞌilil triigo siꞌan see. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pek vetunjajlu tu u Tioxh saiꞌ aas tii sakꞌujeꞌ akꞌuꞌl viꞌ. Tan aatz maꞌt aqꞌaavoꞌk sunkꞌatza, aal saaqꞌ nimal ikꞌuꞌl qꞌul amol.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Tal u Luꞌ ech tzaꞌ: —¡UnBꞌaal, kꞌajel vibꞌ seꞌenin saiꞌ, kꞌuxh tu tzeꞌ utz, kꞌuxh tu kamchil!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Tal u Jesuus te ech tzaꞌ: —Luꞌ, tuul yeꞌsaj toqꞌ u bꞌaal tꞌel cheel, ox pajul saaleꞌ aas yootzajin.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tal paj u Jesuus tu qꞌu chusulibꞌ ech tzaꞌ: —¿Kam maꞌj eyaꞌta aas unchajtubꞌenex? Tan yeꞌk etxim etiqꞌo bꞌen. Yeꞌk iqꞌobꞌ epuaj. Utz yitꞌ kaꞌ tzumul koj epel xaabꞌ etiqꞌo.— Texhtuꞌ. Motx tal ech tzaꞌ: —Yeꞌxhkam maꞌj kuyaꞌta.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Tal u Jesuus te ech tzaꞌ: —Pek aatz cheel, abꞌiste ex atil etxim, iqꞌotaj. Iqꞌotaj tatibꞌal epuaj. Utz oj yeꞌk echꞌichꞌ, kꞌayitaj vechakeꞌt utz, loqꞌtaj maꞌl etetz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tan nival sete aas ministeer itzojpu u kam viꞌ vaꞌl tzꞌibꞌamal nital ech tzaꞌ: «Aꞌ vetkamku xoꞌl aa paav.» Chia. Tan kajay qꞌu kam qꞌuꞌl tzꞌibꞌamalka viꞌ nitzojpeꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Motx tal qꞌu chusulibꞌ te ech tzaꞌ: —KuBꞌaal, atil kaꞌvaꞌl chꞌichꞌ tzaꞌ.— Texhtuꞌ. Tal u Jesuus te: —Aꞌtzii, chuspia.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Motx tek kꞌasuꞌl. Bꞌen viꞌ u muunte vaꞌl Olivo, ech nal chituꞌ nichiꞌaneꞌ. Antu qꞌu chusulibꞌ xamich tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Aatz opon tziꞌ, tal u Jesuus ech tzaꞌ: —Qꞌilataj sikꞌletaj Tioxh, ech yeꞌk laꞌokꞌex vatz u paav.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ech elbꞌen kꞌatz qꞌul ichusulibꞌ. Najaꞌ koꞌn yaꞌka. Echil el kꞌatza jankꞌal sayaꞌk maꞌl sivan kꞌonel bꞌen tu qꞌabꞌ. Ech pecheꞌi. Utz iqꞌila isikꞌle Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Tal ech tzaꞌ: —Tateey, oj sasaꞌa yeꞌk sapaalin tu u mam tzaꞌl tzaꞌ. Bꞌan vatxumbꞌal, yitꞌ aꞌ koj sapaal u vetz.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ech ul maꞌl aanjel kꞌatza. Aꞌ kꞌaskuꞌl tu Amlika utz, ul taqꞌ ixamlil. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tan atich tu txumuꞌm tu peena u Jesuus. Utz tiira atich chit ok yakꞌil taqꞌo tiꞌ iqꞌilal isikꞌlel Tioxh. Kaana ichꞌaap itzꞌaꞌ, echaꞌ ichꞌaap kuꞌ kaj vatz txꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Taꞌxh yaꞌ iqꞌilat isikꞌlet Tioxh, ul kꞌatz qꞌul ichusulibꞌ. Utz vatchich koꞌn tu txumuꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tal tek te ech tzaꞌ: —¿Kantuꞌ nevateꞌ? ¡Lakpojex utz, qꞌilataj sikꞌletaj Tioxh! Ech yeꞌk laokꞌex vatz paav.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Tuul ankoꞌxh nichiyoloneꞌ, opon unjolol tenam. Aꞌ bꞌaxaich siatz vaꞌl Judas ibꞌii, maꞌl tu kabꞌlaal qꞌu chusulibꞌ. Ech xaan opon kꞌatz u Jesuus, itzꞌutzꞌa. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Utz tal u Jesuus te ech tzaꞌ: —Judas, ¿tu maꞌl tzꞌutzꞌ nokksav u Kꞌaola vaꞌl bꞌennaj koꞌn aanima tiqꞌabꞌ qꞌu txayol?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ech taꞌxh til qꞌu chusulibꞌ kam vaꞌl siꞌchbꞌanlu te, motx tal te ech tzaꞌ: —KuBꞌaal, ¿satz kutzokꞌ tu chꞌichꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ech aatz maꞌl te, itzokꞌeꞌl sebꞌal ixichin maꞌl u taqꞌonom u qꞌesal oksan yol vatz Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tal tek u Jesuus te ech tzaꞌ: —¡Aqꞌtajka, yeꞌxhkam sebꞌan te!— Texh te. Ech ikanoꞌk vixichin u aqꞌonom, iꞌan bꞌaꞌn te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Utz ech tal tek u Jesuus tu qꞌuꞌl opon tiꞌ tiqꞌoleꞌ, ayaꞌ qꞌu qꞌesal oksan yol vatz Tioxh, qꞌu qꞌesal sol xeen tetz vikuentail u totztioxh utz, tuchꞌ tu qꞌu qꞌesal qꞌatol tzii. Tal ech tzaꞌ: —Ayaꞌl kala itxayax maꞌj elqꞌom nebꞌan ve. Tan iqꞌomal echꞌichꞌ tuchꞌ etzeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kꞌuxh jun qꞌii nichvatin texoꞌl tu viqꞌanalil u totztioxh, nichunchusex utz, yeꞌt ok eqꞌabꞌ viꞌ tiꞌ untxayleꞌ. Pek anal cheel tan, ech chit sebꞌaneꞌ. Tan ulyu u tiempo, tiꞌ tiqꞌot tibꞌ iyakꞌil u tioxhil maalo.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ech motx itxaytaꞌ. Tiqꞌo kꞌasuꞌl. Utz aꞌ tiqꞌov bꞌen tu atibꞌal xeꞌ u qꞌesal oksan yol vatz Tioxh. Tuul aatz u Luꞌ tan, xamich tiꞌ tzian. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Utz motx toksa xamal vatz qꞌanal; kꞌujeꞌ ok sitziꞌ. Antu u Luꞌ kꞌujeꞌ tixoꞌl majte. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ech ilax iatz u Luꞌ tu maꞌl u kꞌulanal aas kꞌujlich tziꞌ xamal. Tii isaji utz, tal tu xoꞌl ech tzaꞌ: —Antu atich ok kꞌatz u Jesuus vaꞌl tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pek aatz u Luꞌ tan, teesa tibꞌ tuul. Tal ech tzaꞌ: —Ixoj, yeꞌ vootzaj abꞌil naaleꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Bꞌiil koꞌxh paj tuul, ilax tu vaꞌte. Utz tal ech tzaꞌ: —Ant axh imol majte.— Texhtuꞌ. Tal u Luꞌ ech tzaꞌ: —Vinaj, yitꞌ in koj.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ech kamal maꞌl oora tuul, vaꞌt paj aanima nichtxakbꞌaꞌn talax ech tzaꞌ: —Nojchit antu vaꞌl atich ok kꞌatz u Jesuus atziꞌ. Tan aa Galilea.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tal u Luꞌ ech tzaꞌ: —Vinaj, yeꞌ vootzaj kam naaleꞌ.— Texhtuꞌ. Ech tuul ankoꞌxh tereꞌn nichiyoloneꞌ, oqꞌ u bꞌaal tꞌel. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Uncheeꞌ aatz u kuBꞌaal Jesuus, ipilqꞌu tibꞌ; isaji u Luꞌ. Utz aatz u Luꞌ tan, ul viyol u kuBꞌaal sikꞌuꞌl vaꞌl tal te ech tzaꞌ: —Aatz yeꞌsaj toqꞌ u bꞌaal tꞌel, ox pajul maꞌt aaltaꞌ aas yootzajin.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ech ipaal eluꞌl u Luꞌ tiꞌ eluꞌl u qꞌanal utz, itzꞌejeꞌl maꞌl mam oqꞌel. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ech aatz qꞌu vinaj qꞌuꞌl nichxeen u Jesuus, xeꞌt motx iꞌanbꞌe. Utz nichiqꞌoseꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Motx itxꞌut iatz tu bꞌuꞌj. Utz motx ipaqꞌoꞌk ivatz. Ech nichichꞌoti te ech tzaꞌ: —¿Ala abꞌil vetpaqꞌonokꞌaxh?— Chu te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ech sibꞌ tereꞌn koꞌxh kam nichtal te. Yoqꞌel nichiꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Aatz qꞌiilich tekuꞌen, motx imol tibꞌ qꞌu qꞌesal qꞌatbꞌal tzii xoꞌl qꞌu Israeel, tuchꞌ qꞌu qꞌesal oksan yol vatz Tioxh utz, tuchꞌ qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar. Ech tiqꞌo ul u Jesuus tu vaꞌl molichku tibꞌ qꞌu qꞌesala. Tal te ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—¿Axh tzik viTxaaom u Tioxh? Al qe.— Texh te. Tal u Jesuus te ech tzaꞌ: —Kꞌuxh: «In chituꞌ.» Chajin sete, saꞌkojenima tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Utz kꞌuxh kam sunchꞌoti sete, saꞌkojetzaqꞌbꞌeꞌin tziꞌ. Utz saꞌkojechajpuꞌin majte. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pek aatz taabꞌaꞌbꞌen tzaꞌ, saꞌnalkꞌujeꞌ u Kꞌaola vaꞌl bꞌennaj koꞌn aanima, tisebꞌal u Mam Tioxh tu u tijleꞌm.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ech sikajayil motx tal ech tzaꞌ: —Loqꞌ ¿axh chixh vikꞌaol u Tioxh?— Texhtuꞌ. Tal u Jesuus te ech tzaꞌ: —Ayaꞌ vaꞌl netaleꞌ tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Motx tek tal ech tzaꞌ sikajayil: —¡Kam tereꞌn yol nikusavsa! Tan ¡vetqabꞌilaꞌ! ¡Titziꞌ vetelka!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Uncheeꞌ ech tek motx ikꞌasuꞌl qꞌu aanima sikajayil. Utz tiqꞌo bꞌen u Jesuus vatz u Pilato. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ech xeꞌt motx ixoch te ech tzaꞌ: —Maꞌxh qillu u vinaj tziꞌ aas niteesa u kutenam tu bꞌey. Utz nimaj ichool jaꞌmel alkavaar tu u ijlenal Cesar. ITxaaom u Tioxh aas nitaleꞌ. Utz ijlenal aas nital majte.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Aatz u Pilato tan, ichꞌoti tek tu u Jesuus ech tzaꞌ: —¿Axh tzik vaꞌl soꞌokꞌaxh ijlenal xoꞌl qꞌu Israeel tzaꞌ?— Texh te. Tzaqꞌbꞌu u Jesuus ech tzaꞌ: —Ayaꞌ vaꞌl naaleꞌ tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tal tek u Pilato tu qꞌu qꞌesal oksan yol vatz Tioxh, tuchꞌ tu qꞌu tenam ech tzaꞌ: —Yeꞌk maꞌj paav nunchabꞌa kꞌatz u vinaj tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pek taꞌxh txumich tu qꞌu tenam tal ech tzaꞌ: —Niꞌan txabꞌkin qꞌu aanima taqꞌo. Aꞌ xeꞌtik kꞌasuꞌl ichusun tikuenta Galilea utz, ulyu ichusun tu kajay ikuenta u Judea majte tzaꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Uncheeꞌ taꞌxh tabꞌi u Pilato aas ok u Galilea tuul, ichꞌoti tekuꞌen aas aa Galileaich tzik u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Utz taꞌxh tabꞌit inujul aas aa Galileaich, ech ichaj bꞌen xeꞌ u governadoor tu Galilea vaꞌl Herodes. Tiempo chit atich opon tu qꞌu qꞌii tu Jerusaleen tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ech txuqꞌtxun chit u Herodes aas tiltu u Jesuus. Tan ootich koꞌxh tuul aas nichtachva tilaxeꞌ. Tan maꞌtich tabꞌit sibꞌal kam tiꞌ u Jesuus. Ech nichisaꞌa aas siꞌan maꞌj txaichil u Jesuus siatz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ech sibꞌ koꞌxh kam nichichꞌoti u Herodes tu u Jesuus. Loqꞌ nichkojitzaqꞌbꞌe. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tuul atich qꞌu qꞌesal oksan yol vatz Tioxh, tuchꞌ qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar. Techalich motx ixochtaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ech tek eesal iqꞌii u Jesuus tu u Herodes. Aꞌ imol qꞌul isol. Utz xeꞌt motx ibꞌanbꞌe. Motx toksa maꞌl u techalla oksaꞌm kꞌatza, tetz ijlenal. Utz qꞌaav ichaj bꞌen vatz u Pilato. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Uncheeꞌ iꞌan tek bꞌaꞌn u Pilato tuchꞌ u Herodes tu qꞌu qꞌii tziꞌ. Tan jolol atich ok ixoꞌl bꞌanel. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Aatz tek u Pilato, motx imol qꞌu qꞌesal oksan yol vatz Tioxh. Ant imol qꞌu qꞌatol tzii utz, tuchꞌ qꞌu tenam majte. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Tal te ech tzaꞌ: —Vetetiqꞌo ul u vinaj sunvatz tziꞌ. Bꞌanol txabꞌkin aas netaleꞌ. Pek vetunchꞌotil itziꞌ sevatz utz, yeꞌk ipaav nivil tiꞌ vaꞌl vetexochva tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nikoꞌxh u Herodes maꞌkojchabꞌan tu paav tan, vetiqꞌaavixsaluꞌl. Yeꞌxhkam maꞌj vetiꞌanlaꞌ aas sikꞌuloꞌk tiꞌ sakami. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Pek sakoꞌnval itzꞌuꞌmaleꞌ, ech sunchajpu.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ech nichichajpu maꞌl preexhu u Pilato tu qꞌu tenam chajpaj nimla qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ech aatz qꞌu mam tenam tan, maꞌl chit motx ijeꞌ iviꞌ tal ech tzaꞌ: —¡Paaloj el u vinaj tziꞌ! Utz ¡aꞌ sachajpu u Barrabaas!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Aatzich u Barrabaas tziꞌ, atich kuꞌ tu tzeꞌ tiꞌ ilakax txabꞌkin tu tenam utz, tiꞌ yatzꞌoꞌm majte. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ech qꞌilal paj unpat qꞌu tenam tu u Pilato. Aꞌich isaꞌ sichajpu u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pek motx koꞌn paj qꞌaav qꞌeqꞌuni, tal ech tzaꞌ: —¡Aqꞌ jeꞌ vatz kurus! ¡Aqꞌ jeꞌ vatz kurus!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Titoxpaj tekuꞌen tal u Pilato te ech tzaꞌ: —¿Kantuꞌ? ¿Kam paav vetiꞌanlaꞌ? Tan yeꞌk maꞌj paav nivil kꞌatza aas sikꞌuloꞌk tiꞌ sakami. Pek sakoꞌnval itzꞌuꞌmaleꞌ, ech sunchajpu.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Aatz qꞌu aanima tan, taꞌxh txumel taqꞌo niqꞌeqꞌuneꞌ. Aꞌ imol qꞌu qꞌesal oksan yol vatz Tioxh nichijaj ijeꞌ vatz kurus. Ech paal chit tetz tu qꞌul iqꞌeqꞌuneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ech taqꞌ tek tzii u Pilato tiꞌ u Jesuus tan, aꞌ vaꞌl nichijaj qꞌu tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Utz ichajpu u preexhu vaꞌl atich kuꞌ tu tzeꞌ tiꞌ ilakax txabꞌkin utz, tiꞌ yatzꞌoꞌm. Tan aꞌ vaꞌl alax ichajpul tu u tenam. Pek taqꞌka u Jesuus tiqꞌabꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ech tiqꞌot bꞌen. Utz tiempo chit ikꞌul maꞌl u vinaj tu bꞌey aalich tul jaꞌjtzeꞌ, Xhim ibꞌii, aa Cirene. Ech tijat u kurus taqꞌo. Xamich ok tiꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mam tenam xamich tiꞌ tuchꞌ ixoj majte. Vaꞌlich toqꞌeꞌ utz, vaꞌl tal tu txumumla chaj yol tiꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pek aatz u Jesuus tan, ipilqꞌu tibꞌ utz, tal tu qꞌu ixoj ech tzaꞌ: —Ixoj aa Jerusaleen, yeꞌ koꞌxh oqꞌex viꞌ. Pek aꞌ setoqꞌle jeꞌ etibꞌ. Utz aꞌ setoqꞌle qꞌul etitzꞌin. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tan saꞌnalul tiempo tzaꞌl. Utz setal ech tzaꞌ: «Chiꞌbꞌebꞌal tetz qꞌu ixoj qꞌuꞌl yeꞌk titzꞌin nicheeaꞌ, qꞌuꞌl yeꞌk nitxaꞌ nichee kꞌatza utz, yeꞌn chꞌuꞌl ichꞌuꞌ.» Chajex. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Utz tu tek u mam tzaꞌl saꞌteketal tu qꞌu muunte ech tzaꞌ: «Kuꞌojex qiꞌ.» Chajex te. Utz setal tu qꞌu peepu: «Mujtajoꞌ.» Chajex te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tan oj ech iveet u jikomla vinaj niꞌan qꞌu aanima tziꞌ vaꞌl echaꞌ chaxa tzeꞌ, aꞌ chixh yitꞌ techal iveet qꞌu qelolla chaj aanima saveeti, qꞌuꞌl echaꞌ tzaji tzeꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Antu iqꞌol bꞌen majte kaꞌvaꞌl aa paav. Ela sayatzꞌpu tuchꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ech aatz motx opon tu u lugaar vaꞌl Tatibꞌal Bꞌajil Viꞌ, taqꞌ jeꞌ u Jesuus vatz kurus. Aꞌ imol qꞌu aa paav. Maꞌl tisebꞌal utz, vaꞌt timax. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tal tek u Jesuus ech tzaꞌ: —Tateey, kuya tan, yeꞌ tootzaj kam nimotxiꞌaneꞌ.— Texhtuꞌ. Ech iꞌan maꞌl saach qꞌu sol tiꞌ u toksaꞌm aas abꞌil lasuertiin tala. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Aatz qꞌu tenam nichmotxisajineꞌ. Utz antu qꞌu qꞌatol tzii nicheesan iqꞌii, tal ech tzaꞌ: —¡Teesa unjot aanima tu tzaꞌl, pek teesa tibꞌ majte qabꞌi, oj nojchit aꞌ u Cristo, viTxaaom u Tioxh!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Aatz qꞌu sol, taqꞌ minaagre te. Utz nichteesa iqꞌii majte. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Motx tal te ech tzaꞌ: —¡Oj nojchit axh u tijlenal qꞌu Israeel, eesa jeꞌ iibꞌ sajunal qabꞌi!— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Utz tzꞌibꞌamich jeꞌ maꞌl u yol tibꞌa iviꞌ tu yolbꞌal griego, tu yolbꞌal latiin, tuchꞌ tu yolbꞌal hebreo. “Aꞌ U IJLENAL XOꞌL QꞌU ISRAEEL TZAꞌ.” Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Aatz maꞌl tu qꞌu aa paav, qꞌuꞌl atich jeꞌ vatz kurus, nichteesa iqꞌiiꞌ u Jesuus ech tzaꞌ: —¡Oj axh viTxaaom u Tioxh, eesa jeꞌ iibꞌ vatz u kurus tziꞌ qabꞌi! Utz ¡eesaꞌoꞌ majte!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tzaqꞌbꞌu vaꞌt u aa paav. Iyaa bꞌen vimol. Tal ech tzaꞌ: —Yeꞌxh bꞌoj nikojaxoꞌva Tioxh kꞌuxh ant axh atoꞌkꞌaxh tu u choobꞌal paav tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Aatz oꞌ, nojchit tinujul nikuchooeꞌ kam vaꞌl bꞌanel qaqꞌo. Pek aatz aꞌ tziꞌ tan, yeꞌk maꞌj paav vetiꞌana.— Texh tu vimol. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ech ankoꞌxh u aa paav tziꞌ tal tu u Jesuus ech tzaꞌ: —Jesuus, luulsaꞌin sakꞌuꞌl aas loꞌokꞌaxh tu vaQꞌesalail.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Tal u Jesuus te ech tzaꞌ: —Niꞌxhtekꞌval see, cheel saꞌatinaxh sunkꞌatza tu u techalla atinbꞌal.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ech aꞌ chit chaqꞌaannajich qꞌii, ok aqꞌbꞌal tu kajay u vatz amlika txꞌavaꞌ. Anal eli aas iꞌan alas 3 kuꞌqꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Yaꞌ vitxijtxun u qꞌii tziꞌ. Utz tzilmu tuul u liikin bꞌuꞌj tinikꞌa vaꞌl liiumich paal tu u totztioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ech qꞌeqꞌun u Jesuus, tal ech tzaꞌ: —¡Tateey, nivaqꞌka u vaanxelal taqꞌabꞌ tzaꞌ!— Texhtuꞌ. Ech taꞌxh veet tala, kami. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Taꞌxh tek til u qꞌesal sol aas kam vaꞌl tal u Jesuus aas ikameꞌ, toksa tek iqꞌii Tioxh. Tal ech tzaꞌ: —¡Nojchit jikomla vinaj u vinaj atziꞌ; yeꞌk ipaav!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ech aatz u mam tenam opon tiꞌ isajil u kam uchi tziꞌ, motx ilaa taanima tu txumuꞌm. Ech motx qꞌaavkꞌasuꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pek aatz kajay qꞌuꞌl tootzajich tibꞌ tuchꞌ u Jesuus, nichisaji kꞌasuꞌl qꞌu kam tzian qꞌuꞌl uchi tziꞌ. Antu qꞌu ixoj qꞌuꞌl aꞌ xeꞌtik ixambꞌu tiꞌ tu Galilea. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Uncheeꞌ atich maꞌl u vinaj, Xhep ibꞌii. Utz aa Arimateaich tikuenta Judea. Jikom utz, bꞌaꞌnla vinaj. Antu atich tijleꞌm xoꞌl qꞌu qꞌesal qꞌatbꞌal tzii xoꞌl qꞌu Israeel. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Nichichꞌia u tulebꞌal viQꞌesalail u Tioxh. Utz yitꞌ antu koj tal iyol tiꞌ inukꞌax vikam u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ech bꞌen xeꞌ u Pilato, ex ijaj vichiꞌl u Jesuus te aas simujeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ech ex tiqꞌo kuꞌl vichiꞌl u Jesuus vatz kurus. Ibꞌachoꞌk tu maꞌl u liikin bꞌuꞌj. Utz toksa tu maꞌl u jul vatz sivan bꞌanichnale. Yeꞌsajich tok maꞌj kamnaj tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Aꞌ chit iꞌan tu u qꞌii aas nichiꞌankeꞌl tuch qꞌu aanima tan, ech tekoꞌn qꞌejal u ilanbꞌal qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ech aatz qꞌu ixoj qꞌuꞌl aꞌ xeꞌtik ixambꞌu kꞌasuꞌl tiꞌ u Jesuus tu Galilea, xambꞌu bꞌen tiꞌ u Xhep majte. Utz tila kaniꞌch tatinka vichiꞌl u Jesuus bꞌanax tu u mujbꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ech qꞌaavkꞌasuꞌl qꞌu ixoj tziꞌ. Motx ex iꞌan tuch txꞌumqꞌixsabꞌal tuchꞌ tzꞌakabꞌal. Utz motx ilan tu ilanbꞌal qꞌii, kam echaꞌ nital u oꞌtla mantaar. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Pek aatz iꞌan tu u bꞌaxa qꞌii tetz u xhemaana, tiira qꞌalaꞌm motx bꞌen qꞌu ixoj tu u mujbꞌal tetz u Jesuus. Iqꞌomich u txꞌumqꞌixsabꞌal taqꞌo vaꞌl aꞌ motx bꞌanon tucheꞌ. Utz bꞌen unjot ixoj tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Utz aꞌ tek motx tila aas maꞌt iyikul u sivan, u jupbꞌal itziꞌ u jul vaꞌl mujichku u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ech motx okoꞌp tu u mujbꞌal, pek yeꞌkanich vichiꞌl u kuBꞌaal Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tuul sotznajich ikꞌuꞌl tu u kam tziꞌ, yeꞌk talcheꞌ chee kaꞌvaꞌl vinaj siatz txakliche. Ribꞌkin saj oksaꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ech xoꞌv qꞌu ixoj taqꞌo. Motx tek taqꞌ kuꞌ ivatz vatz txꞌavaꞌ. Alax te ech tzaꞌ: —¿Kam tokeꞌ nechok xoꞌl kamnaj u Jesuus vaꞌl itzꞌlele? ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tan yeꞌxhkaꞌt tzaꞌ. ¡Qꞌaav itzꞌpia! Ulsataj sekꞌuꞌl vaꞌl tal sete aas atich tu Galilea. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Tan tal ech tzaꞌ: «Ministeer chit saꞌaqꞌax kuꞌ tiqꞌabꞌ qꞌu aa paav u Kꞌaola vaꞌl bꞌennaj koꞌn aanima. Ech sataqꞌ jeꞌ vatz kurus. Loqꞌ saqꞌaavitzꞌpu titoxvaꞌ qꞌii.» Chia.— Texh qꞌu vinaj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ech ul viyol u Jesuus sikꞌuꞌl qꞌu ixoj tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Utz motx kꞌasuꞌl. Yakich ex tal u bꞌaꞌnla yol tu junlaal qꞌu chusulibꞌ utz, tuchꞌ tu tereꞌn qꞌu aanima imol majte. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Aꞌ qꞌu ixoj tzaꞌ qꞌuꞌl ex alon qꞌu yol tu qꞌul ichaj u Jesuus: u Liꞌ aa Magdala, u Xhiv, u Liꞌ vinan u Jacobo utz, tuchꞌ tereꞌn ixoj. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pek yeꞌt koꞌn nimal viyol qꞌu ixoj. Tan echaꞌ iyol elnaj tu bꞌey siatz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pek aatz u Luꞌ, jutzin ibꞌen tu vaꞌl mujlik u Jesuus. Utz sajin okoꞌp tuul. Aꞌ texh til qꞌu bꞌuꞌj atichka. Ech tiira sotz ikꞌuꞌl tu vaꞌl maꞌtich tucheꞌ. Qꞌaavbꞌen otzotz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Pek aatz iꞌan kaꞌvaꞌl qꞌu niman tetz u Jesuus tu u qꞌii tziꞌ, aalich ibꞌen tu u tal tenam Emauus, vaꞌl junlaal kiloometro ixoꞌl tuchꞌ u Jerusaleen. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nichmotxiyol kajay qꞌu kam tibꞌilaj qꞌuꞌl maꞌtich tuch tiꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ech tuul koꞌxh nichmotxitxay tibꞌ tu yol tiꞌ qꞌu kam, xaan opon u Jesuus kꞌatza. Utz elaich tek ibꞌen tuchꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pek yeꞌt til iatz oj aꞌ u Jesuus. Mujax iatz tu u Tioxh. Yeꞌt aqꞌax tzii te satootzaji. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tal u Jesuus te ech tzaꞌ: —¿Kam qꞌuꞌl neyol setibꞌilaj, tuul nexaaneꞌ utz, kantuꞌ netxumuneꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Utz aatz maꞌl te, ayaꞌ vaꞌl Cleofas ibꞌii, tal tu u Jesuus ech tzaꞌ: —¿Kamal axh texh u puera aanima tu u Jerusaleen tzaꞌ aas yootzaj kam vaꞌl uch tu u tenam tu qꞌu qꞌii tzaꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Tal tek u Jesuus te ech tzaꞌ: —¿Kam uchi?— Texhtuꞌ. Motx tal ech tzaꞌ: —U kam tiꞌ u Jesuus aa Nazareet. Tan maꞌl techalla vinaj alol tetz u yolbꞌal Tioxh, aas aqꞌel iviꞌ qꞌu kam niꞌaneꞌ. Utz aqꞌel iviꞌ itxumbꞌal tu u Tioxh tiyolon vatz qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pek alax ikam tu qꞌu qꞌesal oksan yol vatz Tioxh, tuchꞌ qꞌu kuqꞌatbꞌal tzii. Taqꞌ jeꞌ vatz kurus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Oxvaꞌx qꞌii cheel tuch qꞌu kam tzaꞌ. Utz kꞌujlich kukꞌuꞌl tiꞌ aas aꞌ vaꞌl saꞌeesan qꞌu Israeel tikuenta qꞌu puera aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Utz aal vetpajisotzsal kukꞌuꞌl unjolol qꞌu ixoj tu kuxoꞌl. Tan motx bꞌen tu u mujbꞌal tetz maꞌit tiira qꞌalaꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Pek tila yeꞌkanich vichiꞌl, motx qꞌaavi. Utz tala aas motx til unjolol aanjel majte. Utz alax te tu qꞌu aanjel aas itzꞌlel u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ech bꞌen tek unjolol qꞌu kumol tu u mujbꞌal tetz majte. Utz echat koꞌxh motx tila kam vaꞌl tal qꞌu ixoj tziꞌ. Loqꞌ yeꞌt motx til u Jesuus.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Uncheeꞌ tal tek u Jesuus te ech tzaꞌ: —¡Txoxkin! ¿Tiira yeꞌxh nenima tzik jankꞌal qꞌu kam alel tu qꞌu alol tetz u yolbꞌal Tioxh? ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Tan ministeer chit sapaal viTxaaom u Tioxh tu qꞌu kam bꞌaxa tziꞌ. Ech nal soꞌok tu u techalla tijleꞌm.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ech xeꞌt tal inujul te kam vaꞌl nichtal u Yolbꞌal Tioxh tiꞌ. Aꞌ xeꞌtik kꞌasuꞌl tu vaꞌl alich tu u Moisees. Utz tal kajay qꞌuꞌl alich tu qꞌu alol tetz u yolbꞌal Tioxh majte. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ech motx tek opon tu u tal tenam. Utz iꞌan u Jesuus aas siꞌchkoꞌnpaal yakloj tiloneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pek motx iꞌan yaꞌl aas sakaa tzixeꞌ. Tal te ech tzaꞌ: —Kaaen quxeꞌ. Tan kuꞌy qꞌii, sotzyu texh saj.— Texh te. Ech atinka tzixeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Utz aatz atich tek vatz meexha tuchꞌ, itxay u kaxhlaan txꞌix u Jesuus tiqꞌabꞌ. Ijaj bꞌaꞌnil tu u Tioxh tiꞌ. Ijatxa utz, motx taqꞌ tetz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ech nal tek til iatz aas aꞌ u Jesuus. Pek isotzsa koꞌn tibꞌ u Jesuus siatz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nichtekmotxtal tibꞌilaj ech tzaꞌ: —¡Nojchit aꞌ i atziꞌ! ¡Nimnaꞌl tan, tiira itxay qaanima qꞌul iyol nichtal qe tu bꞌey aas nichtal u Yolbꞌal Tioxh vaꞌl tzꞌibꞌamalka!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ech ankoꞌxh tu u oora tziꞌ, motx qꞌaavbꞌen tu Jerusaleen. Utz til junlaal qꞌu chusulibꞌ molich tibꞌ tziꞌ tuchꞌ tereꞌn aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Nichmotxtal ech tzaꞌ: —¡Nojchit qꞌaav itzꞌpi u kuBꞌaal atziꞌ! Tan ¡ilaxyu tu u Xhim tziꞌ!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ech aatz kaꞌvaꞌl qꞌu vinaj, qꞌuꞌl ilon u Jesuus tu bꞌey, motx tala kaniꞌch motx tiltaꞌ aas aꞌ i, aꞌ chituꞌ aꞌ ijatx u kaxhlaan txꞌix. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tuul koꞌxh nichmotxiyolon tiꞌ qꞌu kam tzaꞌ, yeꞌk talcheꞌ txakeꞌ u Jesuus tixoꞌl. Utz tal ichajlichil ech tzaꞌ: —At koj u paas tetaanima.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ech motx kaa taanima utz, xoꞌvi. Tan kamal tioxhil kam nichtileꞌ tala. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pek tal u Jesuus te ech tzaꞌ: —¿Kam tokeꞌ aas nexoꞌveꞌ? Utz ¿kantuꞌ nekaꞌtziiun tetaanima? ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Pek sajitaj qꞌul unqꞌabꞌ tzaꞌ etileꞌ, tuchꞌ qꞌu vajan tziꞌ. Tan in atkoꞌxhtuꞌ. Kantajokꞌin utz, sajitajin. Tan aatz maꞌl tioxhil kam, yeꞌk ichiꞌl utz, yeꞌk ibꞌajil, echaꞌ qꞌu vetz atile tzaꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ech tuul nichtal qꞌu kam tzaꞌ, ikꞌuch qꞌu takꞌonbꞌeꞌm te qꞌul tiqꞌabꞌ tuchꞌ tu tajan. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pek yeꞌ nichmotxinima tu txuqꞌtxunchil; tzꞌejxinajich ikꞌuꞌl. Ech tal tek u Jesuus ech tzaꞌ: —¿Atil tzik bꞌoj echbꞌubꞌal tzexeꞌ tzaꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ech aqꞌax bꞌiil bꞌolich txay te tuchꞌ unpeꞌlel taꞌl kabꞌ tu tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ikꞌula utz, techbꞌu siatz. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tal paj chit u Jesuus te ech tzaꞌ: —Aꞌ qꞌu yol qꞌuꞌl val sete atziꞌ aas yeꞌsajich unkameꞌ. Tan ministeer chit satzojpu qꞌu kam tzꞌibꞌamal viꞌ tu vimantaar u Moisees, tuchꞌ qꞌu kam tzꞌibꞌamalka tu qꞌu alol tetz u yolbꞌal Tioxh utz, tuchꞌ qꞌuꞌl tzꞌibꞌamal tu u Salmos Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ech paxsal tek itxumbꞌal tu u Jesuus. Ech tootzaji vatzsaj kam u tokebꞌal u Yolbꞌal Tioxh tzꞌibꞌamalka. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Tal te ech tzaꞌ: —Ech chit vaꞌl tzꞌibꞌamalka tiꞌ viTxaaom u Tioxh aas saꞌchitkami. Loqꞌ saqꞌaavitzꞌpu xoꞌl qꞌu kamnaj titoxvaꞌ qꞌii alel. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Utz tu vibꞌii sapaxk itziiul aas samotxikꞌaxa qꞌul ipaav kajay tenam. Kajay aanima samotxabꞌin u kuybꞌal paav. Aꞌ saxeꞌtik bꞌen tu Jerusaleen. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ech setxakbꞌaꞌ etibꞌ tiꞌ talax qꞌu kam tziꞌ tan, etila etabꞌi. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Utz sunchaj kꞌasuꞌl u Tioxhla Espiiritu setiꞌ vaꞌl alel sete tu vunTat. Pek atojex tu Jerusaleen tzaꞌ. Analen labꞌenex aas maꞌt ekꞌultu veyakꞌil vetijleꞌm vaꞌl sakꞌasuꞌl tu Amlika.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ech tiqꞌot kꞌasuꞌl qꞌu chusulibꞌ u Jesuus tu Jerusaleen. Tiqꞌo bꞌen tu Betaania. Utz taqꞌ jeꞌ qꞌul iqꞌabꞌ tibꞌa, ijaj bꞌaꞌnil tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Pek tuul koꞌxh nichtaqꞌ kuꞌ u bꞌaꞌnil tiꞌ, elbꞌen kꞌatza; iqꞌol jeꞌ tu Amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Uncheeꞌ motx toksa iqꞌii u Jesuus. Ech motx tek qꞌaavuꞌl tu Jerusaleen. Techalich motx itxuqꞌtxuneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ech tzukꞌel nichimol tibꞌ tu viqꞌanalil u totztioxh. Vaꞌlich toksat iqꞌii Tioxh. Aꞌi.");
INSERT INTO ixlCNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","2","Atich nal u Aqꞌol Tiichajil kꞌatz u Tioxh xeꞌ qꞌii xeꞌ saj. Tioxh tatineꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tiꞌ kꞌuxh chee qꞌu kam kajayil qꞌuꞌl atile. Utz yeꞌt chee qꞌu kam koj tziꞌ aas yitꞌ koj tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ayeꞌn u tiichajil tzixeꞌ. Utz aatz u tiichajil tziꞌ, echaꞌ txijtxubꞌal. Aꞌ nikꞌuchun u bꞌey tu qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","U txijtxubꞌal nitxijtxun xoꞌl qꞌu aanima qꞌuꞌl atil tu uken vatz Tioxh tu u vatz amlika txꞌavaꞌ tzaꞌ. Utz yeꞌxhkam nitxꞌolax imajax itxijtxun tu u uken. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Uncheeꞌ atich maꞌl u vinaj Xhan ibꞌii. Chajax tu u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Utz aꞌ ul taleꞌ aas aꞌ u txijtxubꞌal u Jesuus kꞌasuꞌl xeꞌ Tioxh. Ech kajay saniman u Jesuus tiꞌ qꞌul iyol. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Utz aꞌ koj u txijtxubꞌal u Xhan; pek alol koꞌn tetz itziiul u txijtxubꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tan ul u Jesuus tu u vatz amlika txꞌavaꞌ tzaꞌ. Ayaꞌ u nojla txijtxubꞌal tetz kajay qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Utz atin tu u vatz amlika txꞌavaꞌ tzaꞌ. Utz tiꞌ kuꞌen kꞌuxh veet u vatz amlika txꞌavaꞌ. Pek aatz qꞌu aanima tu u vatz amlika txꞌavaꞌ, yeꞌt tootzaji aas aꞌ vaꞌl uli. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tiꞌ qꞌu tetz ulka. Pek yeꞌt koꞌn kꞌulax tu vitenam. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pek taqꞌ tijleꞌm kajay qꞌuꞌl kꞌulun, qꞌuꞌl motx niman vibꞌii. Bꞌens kꞌaol imeꞌal Tioxh taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Utz yitꞌ tiqꞌaqꞌal koj kajal aanima vibꞌen qꞌu aanima kꞌaol imeꞌal Tioxh tziꞌ. Yitꞌ titxumbꞌal koj chiꞌl kꞌuxh itzꞌpi utz, yitꞌ titxumbꞌal koj aanima. Pek itxumbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Bꞌen koꞌn aanima u aqꞌol tiichajil. Atin tu kuxoꞌl. Utz qil u mam itechalil, echaꞌ tijleꞌm maꞌl kꞌaola aas taꞌxh maꞌl kꞌatz itat. Techal qꞌu mam bꞌaꞌnil tzixeꞌ tuchꞌ vinujul. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Uncheeꞌ yolon u Xhan tiꞌ u Jesuus ech tzaꞌ: —Aꞌ vaꞌl val sete atziꞌ aas val ech tzaꞌ: «Aatz vaꞌl tul viꞌ, bꞌaxaich sunvatz. Atichnale aas cheeꞌin.» Texhin.— Texh u Xhan. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Utz kajay oꞌ niqetzan kꞌatza tiꞌ u mam bꞌaꞌnil vaꞌl ech koꞌxh ibꞌenaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tan aatz u Moisees, aꞌ taqꞌ u oꞌtla mantaar qe. Pek ech koj u bꞌaꞌnil tuchꞌ vinujul, aꞌ vetiqꞌon ul quxeꞌ u Jesucristo. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Paat yeꞌxhabꞌil ilonnaj tetz u Tioxh. Pek u Kꞌaola nialon inujul kam bꞌanel tu u Tioxh. Tan taꞌxh u Jesuus vaꞌl meero atil kꞌatza. Utz aꞌ ootzajin tetz viTat. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Uncheeꞌ aatz iꞌan qꞌu qꞌesal uqꞌaybꞌal xoꞌl qꞌu Israeel, ichaj unjolol oksan yol vatz Tioxh tuchꞌ unjolol qꞌu levita. Motx kꞌasuꞌl tu Jerusaleen tiꞌ en ichꞌotil tu u Xhan ech tzaꞌ: —¿Abꞌil axh?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Utz tzaqꞌbꞌel tu u Xhan, jik chit tala. Yeꞌt txubꞌaꞌli. Tal ech tzaꞌ: —Yitꞌ in koj viTxaaom u Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Utz abꞌil paj te ech tzaꞌ: —¿Abꞌil axh uncheeꞌ? ¿Axh tzik u Elias?— Texh teꞌleꞌ. Tzaqꞌbꞌu u Xhan utz, tala: —Yitꞌ in koj.— Texhtuꞌ. Utz alax paj te: —¿Axh tzik u alol tetz u yolbꞌal Tioxh vaꞌl saꞌchitꞌuli?— Texh teꞌleꞌ. —Yitꞌ iꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Utz alax paj te ech tzaꞌ: —¿Abꞌil axh uncheeꞌ? Ech seꞌnqal tu qꞌuꞌl vetchajonoꞌ. ¿Abꞌil axh saaleꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Utz tal u Xhan ech tzaꞌ: —In vaꞌl tal u Isaias, u alol tetz u yolbꞌal Tioxh, aas tal ech tzaꞌ: «Sajeꞌ iviꞌ tiꞌ talax u yolbꞌal Tioxh tu u tzꞌinlich tzaji txꞌavaꞌ. Utz sataleꞌ: Jikomtixsataj etxumbꞌal vatz u kuBꞌaal Tioxh, echaꞌ ijikomtixsal bꞌey siatz sebꞌaneꞌ. Chaj.» Texhtuꞌ.— Texh u Xhan. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Aatz qꞌu chaj oponi tziꞌ, ichaj qꞌuꞌl fariseo u tuqꞌaybꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Utz ichꞌoti paj tu u Xhan ech tzaꞌ: —Untzꞌoj yitꞌ axh koj viTxaaom u Tioxh, ¿kam tokeꞌ naꞌan vautisaar aanima tu aꞌ uncheeꞌ? Tan nikoꞌxh axh koj u Elias utz; nikoꞌxh axh koj u alol tetz u yolbꞌal Tioxh vaꞌl sauli.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Tzaqꞌbꞌel tu u Xhan ech tzaꞌ: —Tu koꞌn aꞌ nunbꞌanvu vautisaar aanima. Pek atil maꞌl texoꞌl aas yeꞌ etootzaj. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ayaꞌ vaꞌl tul viꞌ. Loqꞌ bꞌaxal sunvatz tan, atilnale. Utz sibꞌ tijleꞌm sunvatz. Aal yeꞌ nikꞌuloꞌk viꞌ aas in chitol el ixaabꞌ tu tajan.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Aatz qꞌu kam tziꞌ aꞌ uchku tu Betaabara, sala bꞌen u nimaꞌ Jordaan tu vaꞌl nichiꞌanvu vautisaar aanima u Xhan. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Uncheeꞌ tu tek vaꞌt qꞌii tuul, ilax u Jesuus tu u Xhan. Aalich tul kꞌatza. Utz tal tiꞌ ech tzaꞌ: —¡Atil viTxaaom u Tioxh tzuta! vaꞌl aꞌ nikꞌam tiꞌ maꞌl chelem karneꞌl tan, sakam tiꞌ teesal vipaav qꞌu aanima tu u vatz amlika txꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Aꞌ vaꞌl val sete atziꞌ aas val ech tzaꞌ: «Tul vaꞌt u vinaj viꞌ vaꞌl atil nal sunvatz. Tan atichnale aas cheeꞌin.» Texhin. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Utz yeꞌich vootzaj iatz. Pek vetꞌulin tiꞌ ibꞌanax vautisaar aanima tu aꞌ tiꞌ. Ech satootzaji qꞌu Israeel.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Utz tal paj u Xhan tiꞌ ech tzaꞌ: —Vil ikuꞌl u Tioxhla Espiiritu tu Amlika. Echaꞌ paroomaxh tiloneꞌ. Utz atin tibꞌa u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Utz yeꞌich vootzaj. Pek aatz vaꞌl chajonkꞌasuꞌlin tiꞌ ibꞌanax vautisaar aanima, tal ve: «Abꞌil iꞌ liilv ikuꞌ vunTioxhla Espiiritu utz, laꞌatin tibꞌa, aꞌ vaꞌl saoksan u Tioxhla Espiiritu kꞌatz qꞌu aanima.» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ech vila. Utz ech tok nivaleꞌ aas aꞌ viKꞌaol u Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Uncheeꞌ tu tek vaꞌt qꞌii tuul, atich paj u Xhan tziꞌ. Aꞌich imol kaꞌvaꞌl qꞌul ichusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Utz isaji bꞌen u Jesuus nichipaaleꞌ. Utz tal ech tzaꞌ: —¡Atil viTxaaom u Tioxh tzuta, vaꞌl aꞌ nikꞌam tiꞌ maꞌl chelem karneꞌl!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ech taꞌxh tabꞌi viyol u Xhan kaꞌvaꞌl qꞌu chusulibꞌ, xambꞌu tek tiꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ech sajinka u Jesuus tiꞌ iqul utz, tila aas xamich tiꞌ. Tal tek te ech tzaꞌ: —¿Kam nechokeꞌ?— Texh te. Motx tal ech tzaꞌ: —Rabii ¿til atilkꞌaxh?— Texh te. Aatz u yol “Rabii” tu u yolbꞌal hebreo, “chusul” chu u tokebꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Utz tal u Jesuus ech tzaꞌ: —Niꞌextaj, uloj etileꞌ.— Texh te. Ech ibꞌen tiꞌ utz, tila til atichka. Utz motx atinka tzixeꞌ tu u qꞌii tziꞌ. Tan maꞌtich tek ikuꞌ qꞌii; alas 4 ich tekuꞌen. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Aatz maꞌl tu qꞌuꞌl abꞌin iyolon u Xhan, xambꞌu tiꞌ u Jesuus; aꞌich aꞌ u Lixh. Ayaꞌ vitzaꞌqꞌ u Xhim vaꞌl Luꞌ ibꞌii majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ech aatz u Lixh, aꞌ bꞌaxal ex til u Xhim, u tatzik. Utz tal te ech tzaꞌ: —¡Atil tek viTxaaom u Tioxh vaꞌl alaꞌtziꞌimal kꞌasuꞌl! ¡Vetqillaꞌ! Ayaꞌ u Cristo.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ech tiqꞌot ul u Xhim vatz u Jesuus. Sajil tu u Jesuus utz, tal te ech tzaꞌ: —Aatz axh, axh Xhim, ikꞌaol Jonaas. Cefas tek abꞌii siꞌaneꞌ. Ankoꞌxhtuꞌ u bꞌii Luꞌ majte.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Uncheeꞌ aatz tu vaꞌt u qꞌii, titzꞌa bꞌenchil u Jesuus tu Galilea. Utz bꞌeni. Til u Felipe. Utz tal te ech tzaꞌ: —Xambꞌen viꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Aatz u Felipe tziꞌ, aa Betsaidaich, vitenam u Lixh tuchꞌ u Luꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ech aatz u Felipe, ex til u Natanaeel utz, tal te ech tzaꞌ: —¡Ulyu vaꞌl yolon u Moisees tiꞌ tu u oꞌtla mantaar, vaꞌl yolon qꞌu alol tetz u yolbꞌal Tioxh tiꞌ majte! ¡Vetqillaꞌ! Ayaꞌ u Jesuus vikꞌaol u Xhep tu Nazareet.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Utz tal u Natanaeel tu u Felipe ech tzaꞌ: —Oj tzik salakpu maꞌj mam vinaj tu Nazareet.— Texh te. Tzaqꞌbꞌu u Felipe utz, tal ech tzaꞌ: —¡Niꞌaxh tul ila iileꞌ!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Uncheeꞌ aatz ilax topon u Natanaeel tu u Jesuus, tal tiꞌ ech tzaꞌ: —Aatz cheel, tul maꞌl u Israeel tzuta aas nojchit yeꞌk subꞌuꞌm kꞌatza.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Utz tal u Natanaeel te ech tzaꞌ: —¿Kam anachbꞌeꞌin; til ootzajivin?— Texh te. Utz tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Vilaxh aas yeꞌsajich isikꞌletꞌaxh u Felipe. Atichꞌaxh jaqꞌ u viikuxh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ech sotz ikꞌuꞌl u Natanaeel taqꞌo utz, tal ech tzaꞌ: —Chusul, ¡noj peꞌxh axh viKꞌaol u Tioxh! Axh u tijlenal qꞌu Israeel vaꞌl saꞌchitꞌuli.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Tzaqꞌbꞌel paj tu u Jesuus ech tzaꞌ: —Nanima tan, vetval see aas: «Vetvilaxh jaqꞌ u viikuxh.» Chiꞌin. Utz mamaj kam tereꞌn koꞌxh siil vatz vaꞌl tzaꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Utz tal pajeꞌ: —Niꞌxhtekꞌval sete, saꞌnaletil ijajeꞌ u amlika taabꞌaꞌbꞌen tzaꞌ. Utz setil qꞌul iaanjel u Tioxh sakuꞌl sabꞌenjeꞌ kꞌatz u Kꞌaola vaꞌl bꞌennaj koꞌn aanima.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Uncheeꞌ tu tek itoxvaꞌ qꞌii tuul, bꞌanax maꞌl tzumbꞌaꞌa tu u tenam Canaa tikuenta Galilea. Utz antu atich opon tziꞌ vinan u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Utz antu savsal u Jesuus tuchꞌ qꞌul ichusulibꞌ majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Utz yeꞌt takꞌa u taꞌl uuva vaꞌl nichtaqꞌaxeꞌ. Ech aatz vinan u Jesuus, tal te ech tzaꞌ: —Motxyu u taꞌl uuva.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Tal u Jesuus te ech tzaꞌ: —Ixoj, ¿kam tokeꞌ aas naal ve? Tan yeꞌsaj topon u oora.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Pek aatz vinan, tal tu qꞌu xekol ech tzaꞌ: —Lenima tiꞌ kajay vaꞌl satal sete.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Utz atich vaajil mamaj sivan txeꞌn tziꞌ. Kaꞌvaꞌl oj oxvaꞌl txeꞌn aꞌ nichaav tuul. Tan aꞌ vaꞌl nitxakunsa qꞌu Israeel tiꞌ u kostuumbre tetz txꞌaatxꞌochil. ");
INSERT INTO ixlCNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Anchituꞌ. Tal u Jesuus tu qꞌu xekol ech tzaꞌ: —Noosataj qꞌu txeꞌn tu aꞌ tziꞌ.— Texh te. Utz bꞌoono inoosal motx iꞌana. ");
INSERT INTO ixlCNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tal tepaj te ech tzaꞌ: —Aatz cheel, lektaj jeꞌul bꞌioj utz, iqꞌotaj bꞌen xeꞌ u qꞌesal ilol tetz u nimla qꞌii.— Texhtuꞌ. Ech tiqꞌot bꞌen. ");
INSERT INTO ixlCNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Utz inach u aꞌ u qꞌesal ilol tetz u nimla qꞌii. Taꞌl uuvaich tekuꞌen. Loqꞌ yeꞌ tootzaj til cheek u tal uuva tziꞌ. Taꞌxh ootzajinich tetz qꞌu xekol til cheeka. Ech aatz u qꞌesal ilol tetz u nimla qꞌii, isikꞌle tek u xiak vaꞌl tzumeꞌi. ");
INSERT INTO ixlCNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Tal te ech tzaꞌ: —Kajay aanima nibꞌanon aas aꞌ bꞌaxal nitaqꞌ u bꞌaꞌnla taꞌl uuva. Utz anal nitukꞌal vaꞌl bꞌiit nitaleꞌ aas maꞌt tukꞌal sibꞌal u bꞌaꞌn. Pek aatz axh, vetatxaakeꞌl u bꞌaꞌnla taꞌl uuva; anal naaqꞌ cheel.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Uncheeꞌ aꞌ u bꞌaxa txaichil iꞌan u Jesuus tu Canaa tziꞌ, tikuenta Galilea. Utz ikꞌuch u mam itechalil u Tioxh kꞌatza. Ech nimal tu qꞌul ichusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ech aatz maꞌtich ipaal u kam tzaꞌ, motx bꞌen tu u tenam Capernauum. Bꞌen u Jesuus tuchꞌ vinan, qꞌul itzaꞌqꞌ utz, tuchꞌ qꞌul ichusulibꞌ. Utz iꞌan kaꞌxvaꞌl qꞌii tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Uncheeꞌ nichtekinajabꞌ vinimla qꞌii qꞌu Israeel, tiꞌ u Elchil Vatz Kamchil Tu Egipto. Utz bꞌenjeꞌ u Jesuus tu Jerusaleen. ");
INSERT INTO ixlCNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Utz aatz opon tu viqꞌanalil u totztioxh, til qꞌu aa kꞌaꞌy vaakaxh, qꞌu aa kꞌaꞌy karneꞌl, tuchꞌ qꞌu aa kꞌaꞌy paroomaxh. Antu qꞌu chꞌexun puaj. Jolol kꞌujlich tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ech iꞌan maꞌl itzꞌuꞌm u Jesuus. Utz ipaasa eluꞌl kajay qꞌu aa kꞌaꞌy atich tu viqꞌanalil u totztioxh. Maꞌl teluꞌl tuchꞌ qꞌu karneꞌl, tuchꞌ qꞌu vaakaxh. Imakꞌeꞌl vipuaj qꞌu chꞌexun puaj utz, ixhutꞌpika qꞌul imeexha. ");
INSERT INTO ixlCNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Utz tal tu qꞌu aa kꞌaꞌy paroomaxh ech tzaꞌ: —¡Eesataj qꞌu kam tziꞌ! Yeꞌ koꞌxh etaqꞌ bꞌens kꞌayibꞌal u totzotz vunTat tzaꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ech ul sikꞌuꞌl qꞌu chusulibꞌ u yol vaꞌl tzꞌibꞌamichka ech tzaꞌ: —Yeꞌ nunqꞌiꞌ tiꞌ val ootzotz aas kam koꞌxh nibꞌanax tuul.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Aatz tek qꞌu qꞌesal uqꞌaybꞌal tetz qꞌu Israeel, tal te ech tzaꞌ: —¿Kam xheenya sakꞌuch qe aas atil iijleꞌm tiꞌ qꞌu kam naꞌaneꞌ tziꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Utz tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Aqꞌtaj kuꞌ u totztioxh tzaꞌ utz, tu koꞌn oxvaꞌl qꞌii saqꞌaavunlakvu jeꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tal tek qꞌu qꞌesala te ech tzaꞌ: —Maꞌl 46 yaꞌbꞌ veetik vikuentail u totztioxh tzaꞌ. Utz aatz axh, ¿tu koꞌn oxvaꞌl qꞌii saqꞌaavalakvu jeꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Loqꞌ aatz u Jesuus tan, aꞌ koj chit nichtal vikuentail u totztioxh te. Pek aꞌ nichtal vichiꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ech ul u yol sikꞌuꞌl qꞌu chusulibꞌ tal u Jesuus tziꞌ aas qꞌaav itzꞌpu u Jesuus xoꞌl qꞌu kamnaj. Ech inima u yol vaꞌl tzꞌibꞌamichka tuchꞌ qꞌu yol tal u Jesuus majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Uncheeꞌ atich u Jesuus tu Jerusaleen tu u nimla qꞌii tiꞌ u Elchil Vatz Kamchil Tu Egipto, sibꞌal aanima niman tan, nichtil qꞌu txaichil nichiꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pek aatz u Jesuus tan, nichkojikꞌujeꞌ ikꞌuꞌl tiꞌ qꞌu aanima. Tan tootzajich kam bꞌanel taqꞌo sikajayil. ");
INSERT INTO ixlCNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Utz yeꞌk ministeer aas abꞌil sayolon ok qꞌu aanima te. Tan tootzajich kam atil tu taanima qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Uncheeꞌ atich maꞌl u vinaj, Nicodemo ibꞌii. Imol qꞌu fariseo. Utz atich tijleꞌm xoꞌl qꞌu Israeel. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ech opon xeꞌ u Jesuus tu maꞌl u aqꞌbꞌal. Utz tal te ech tzaꞌ: —Chusul, qootzajle aꞌ vetkꞌaskuꞌlaxh xeꞌ Tioxh tu vachusuneꞌ. Tan abꞌil koj sabꞌanon qꞌu txaichil naꞌaneꞌ tziꞌ, oj yeꞌk Tioxh kꞌatza.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Utz tal u Jesuus te ech tzaꞌ: —Niꞌxhtekꞌval see aas abꞌil vaꞌl yitꞌ saꞌkojitzꞌpu tikaꞌpaj, saꞌkojtil viQꞌesalail u Tioxh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Utz tal u Nicodemo te ech tzaꞌ: —¿Kaniꞌch titzꞌpu maꞌl vinaj aas qꞌestu tekuꞌen? ¿Satz veeti saqꞌaavokoꞌp tu tuul inan tzik utz, siꞌitzꞌpi?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Tzaqꞌbꞌu u Jesuus ech tzaꞌ: —Niꞌxhtekꞌval see aas abꞌil vaꞌl yeꞌk siꞌitzꞌpu tu aꞌ utz, tu u Tioxhla Espiiritu, saꞌkojok tu viQꞌesalail u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Tan aatz vaꞌl nititzꞌpu tu u chiꞌl, chiꞌl kuꞌen. Pek aatz vaꞌl nititzꞌpu tu u Tioxhla Espiiritu, tetz u Tioxh atziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Utz yeꞌ koꞌxh sotz akꞌuꞌl tiꞌ vaꞌl nivaleꞌ aas: «Ant ex, ministeer siꞌitzꞌpꞌex kꞌatz Tioxh majte.» Chiꞌin. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tan echaꞌ u kajiqꞌ tziꞌ. Til koꞌxh nixuminku ipaaleꞌ. Naabꞌi toqꞌ tuul. Loqꞌ yootzaj til ech tuleꞌ utz, til ech ibꞌenaꞌ. Utz ech bꞌanel tu qꞌuꞌl nititzꞌpu tu u Tioxhla Espiiritu.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tzaqꞌbꞌu paj u Nicodemo utz, tal ech tzaꞌ: —¿Kaniꞌch tek iveet u kam tziꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Utz tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —¿Yeꞌ nitel atxumbꞌal tuul tzik kꞌuxh axh chusul tetz qꞌu Israeel? ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Niꞌxhtekꞌval see aas taꞌxh nivaleꞌ kam vaꞌl vootzaj utz, kam vaꞌl ilel vaqꞌo xeꞌ Tioxh. Pek yeꞌ nenima kam vaꞌl nivaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Utz yeꞌ nenima qꞌu vatz txꞌavaꞌil kam nival sete tziꞌ, ¿aꞌ chixh senima oj Amlikail kam saval sete? ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Tan yeꞌxhabꞌil maꞌj jeꞌnajop tu Amlika. Pek taꞌxh u Kꞌaola vaꞌl bꞌennaj koꞌn aanima kuꞌnajul tu Amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Utz kam ech itꞌanbꞌaꞌl jeꞌ u tzꞌajich vatzibꞌal txꞌiꞌla txokop iꞌan u Moisees tu tzꞌinlich tzaji txꞌavaꞌ, ministeer echat chit itꞌanbꞌaꞌl jeꞌ u Kꞌaola vaꞌl bꞌennaj koꞌn aanima sabꞌanax majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ech yeꞌk satzꞌejxu kajay qꞌu aanima saniman. Pek saꞌatin itiichajil tu bꞌenqꞌii bꞌensaj. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Tan aatz u Tioxh, tiira tii tiꞌ qꞌu aanima tu u vatz amlika txꞌavaꞌ. Aal vettaqꞌ viKꞌaol tiꞌ vaꞌl taꞌxh maꞌl. Tan aꞌ isaꞌ yitꞌ saꞌkojtzꞌejxu kajay qꞌuꞌl saniman. Pek saꞌatin itiichajil tu bꞌenqꞌii bꞌensaj. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tan aatz u Tioxh, maꞌkojichaj kꞌasuꞌl viKꞌaol tiꞌ ul itzꞌejax yol tiꞌ qꞌu aanima tu u vatz amlika txꞌavaꞌ. Pek vetichajuꞌl, tiꞌ ichitpul qꞌu aanima tu qꞌul ipaav. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Utz abꞌil vaꞌl niniman viKꞌaol u Tioxh, yeꞌk soꞌok tu u choobꞌal paav. Ech koj vaꞌl yeꞌ niniman, tzꞌejel nal yol tiꞌ aas tu choobꞌal paav seꞌenka. Tan yeꞌ ninima viTxaaom u Tioxh vaꞌl taꞌxh maꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ech suꞌul choobꞌal paav tiꞌ qꞌu aanima. Tan yeꞌ ninima viTxaaom u Tioxh vaꞌl ul tu u vatz amlika txꞌavaꞌ tzaꞌ; ayaꞌ u txijtxubꞌal. Pek aꞌ koꞌn motx bꞌenk ikꞌuꞌl tiꞌ u paav; ayaꞌ u uken. Ech motx iꞌan tziꞌ tan, yeꞌxtxoj qꞌul ibꞌanoneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tan aatz kajay qꞌuꞌl yeꞌxtxoj niꞌaneꞌ, yeꞌk itxaꞌk u txijtxubꞌal te. Utz yeꞌxhkam nitul kꞌatza. Yeꞌxhkam nichokeꞌ tan, yiꞌsaꞌ sachee eluꞌl tu qꞌul ibꞌanoneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pek ech koj qꞌuꞌl atoꞌk tiꞌ ibꞌanax vinujul, nitul kꞌatz u txijtxubꞌal tiꞌ ikꞌuchtaꞌ aas titxumbꞌal Tioxh niꞌan qꞌu kam.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Uncheeꞌ xamtich tek tiꞌ qꞌu kam tziꞌ, bꞌen u Jesuus tikuenta Judea tuchꞌ qꞌul ichusulibꞌ. Utz atin tziꞌ. Nichibꞌan vautisaar aanima tuchꞌ qꞌul ichusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Echat u Xhan majte, nichibꞌan vautisaar aanima tu Enoon, najaꞌch u txꞌavaꞌ Saliim. Tan kaanaich aꞌ tziꞌ. Ech nichtopon aanima utz, nichibꞌanax vautisaar. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tan yeꞌsajich taqꞌax kuꞌ u Xhan tu tzeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Uncheeꞌ atin yaayoliꞌbꞌ xoꞌl qꞌul ichusulibꞌ u Xhan tuchꞌ unjolol qꞌu qꞌesal uqꞌaybꞌal xoꞌl qꞌu Israeel. Nichiyaayoli tibꞌ tiꞌ u kostuumbre tiꞌ u txꞌaatxꞌochil vatz Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ech ul xeꞌ u Xhan utz, tal te ech tzaꞌ: —Chusul, aatz u vinaj vaꞌl atich sakꞌatza sala bꞌen u Jordaan vaꞌl yolonaxh tiꞌ, nibꞌan vautisaar aanima. Utz vaꞌl tok aanima tiꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Utz tzaqꞌbꞌel tu u Xhan ech tzaꞌ: —Yeꞌxhabꞌil maꞌj saꞌatin tijleꞌm oj yitꞌ u Tioxh koj saꞌaqꞌon te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Utz ex texhtiigo tiꞌ vaꞌl val sete aas: «Yitꞌ in koj viTxaaom u Tioxh, in koꞌn chaj bꞌaxabꞌsamal ulin siatz.» Texhin. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","In koꞌn tamiigo atilin kꞌatza. Tan echaꞌ vaꞌl nituch tu maꞌl tzumbꞌaꞌa aas ayeꞌn u ixviak kꞌatz u xiak vivinaj. Pek atil u tamiigo u xiak najaꞌch majte. Nitabꞌi kam chaj siꞌaneꞌ utz, techal itxuqꞌtxun tiꞌ. Utz echat u vetzaneꞌ; tiira techal unchiꞌbꞌeꞌ aas nivabꞌi qꞌu kam tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Tan ministeer aas saꞌxhtꞌanbꞌaꞌli. Pek aatz in, sakuꞌl u vijleꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Tan aꞌ aa yol tiꞌ qꞌu kam kajayil vaꞌl aꞌ vetkꞌaskuꞌl tu Amlika. Pek aatz vaꞌl atil tu u vatz txꞌavaꞌ tzaꞌ, vatz txꞌavaꞌ atilka. Utz aꞌ niyol qꞌu kam tu u vatz txꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ech aatz vaꞌl kꞌasuꞌl tu Amlika, aꞌ nitaleꞌ kam vaꞌl tila tabꞌi. Pek yeꞌxhabꞌil niniman qꞌul iyol. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pek abꞌil vaꞌl niniman qꞌul iyol, nitxakbꞌaꞌ aas aꞌ inujul vaꞌl nital u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tan aatz vaꞌl Tioxh vetchajon, yolbꞌal Tioxh nitaleꞌ. Utz aatz u Tioxh, tzꞌajel taqꞌax u Tioxhla Espiiritu niꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Aatz u Tata, tiira tii tiꞌ viKꞌaol. Ech kajay qꞌu kam vettaqꞌluka tiqꞌabꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ech abꞌil vaꞌl niniman u Kꞌaola, saꞌatin tu u tiichajil kꞌatza bꞌenqꞌii bꞌensaj. Pek abꞌiste vaꞌl yeꞌ isaꞌ inimal u Kꞌaola, saꞌkojatin tu u tiichajil tu u bꞌenqꞌii bꞌensaj. Pek sakuꞌ vikꞌaꞌnal u Tioxh tiꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Uncheeꞌ, nichtal qꞌu fariseo tiꞌ u Jesuus ech tzaꞌ: —Aatz u Jesuus, nitoksa tereꞌn chusulibꞌ tiꞌ. Paalchu tek aanima nibꞌan vautisaar vatz u Xhan.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Utz tabꞌi itziiul u Jesuus vaꞌl nichtalaxeꞌ tziꞌ. Kꞌuxh aal yitꞌ u Jesuus koj nichbꞌanon vautisaar aanima, pek qꞌul ichusulibꞌ nichbꞌanon. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Echixeꞌat eltekkꞌasuꞌl tikuenta Judea utz, bꞌen paj tikuenta Galilea. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Utz ministeer aalich ipaal tikuenta Samaaria. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ech opon tu maꞌl u tenam tikuenta Samaaria, Sicaar ibꞌii. Aꞌ atichku tu u txꞌavaꞌ vaꞌl taqꞌ u Jacoob tu u Xhep koꞌxtene, vikꞌaol. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Utz atich maꞌl u julil aꞌ tziꞌ vaꞌl kꞌotax tikuenta u Jacoob. Ech kꞌujeꞌ u Jesuus sitziꞌ tan, maꞌtich ikool tu xaaom. Utz siꞌchtexhchaqꞌaan qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Uncheeꞌ opon maꞌl u ixoj aa Samaaria; ex tiqꞌo taaꞌ. Utz tal u Jesuus te ech tzaꞌ: —Aqꞌ bꞌioj vaaꞌ savukꞌa.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Tuul aatz qꞌul ichusulibꞌ, maꞌtich motx ibꞌen tu tenam tiꞌ en iloqꞌax echbꞌubꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ech aatz u ixoj aa Samaaria, tal tu u Jesuus ech tzaꞌ: —¿Kam tokeꞌ najaj avaaꞌ ve suukꞌa? Tan axh aa Judea. Utz in aa Samaaria. Utz aatz qꞌu aa Judea, yitꞌix iqꞌila tibꞌ tuchꞌ qꞌu aa Samaaria.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ech tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Nikojootzaji kam u oya nitaqꞌ u Tioxh utz, abꞌil vaꞌl nialon see aas: «Aqꞌ vaaꞌ.» Chia. Aal sajaj avaaꞌ te atziꞌ. Utz aal viꞌal aꞌ sataqꞌ see.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Utz tal u ixoj te ech tzaꞌ: —UnBꞌaal ¿kam koj tuul siiqꞌov jeꞌul u aꞌ tan, sibꞌ bꞌennaj u jul tziꞌ? Utz ¿til siiqꞌov u viꞌal aꞌ naal majte tziꞌ? ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tan ¿tzꞌoj tzik paalchꞌaxh vatz u kukꞌuy kumam Jacoob vaꞌl aqꞌonka u julil aꞌ qe tzaꞌ? Tan aꞌ u julil aꞌ vaꞌl tiqꞌov taaꞌ tukꞌa tuchꞌ qꞌul ikꞌaol imeꞌal utz, tuchꞌ qꞌu tavan.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Utz tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Abꞌil qꞌuꞌl suꞌukꞌan u aꞌ tzaꞌ, sakoꞌnpajtzaj itziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pek abꞌil vaꞌl suꞌukꞌan u aꞌ vaꞌl savaqꞌeꞌ, jatu tereꞌn koj satzaj itziꞌ. Tan echaꞌ iyuqꞌpu viꞌal aꞌ u tatin kꞌatza siꞌaneꞌ tan, tetz u tiichajil tu bꞌenqꞌii bꞌensaj.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Utz tal u ixoj te ech tzaꞌ: —UnBꞌaal, aqꞌ vetz u aꞌ naaleꞌ tziꞌ; ech yeꞌkan satzaj untziꞌ. Utz yeꞌkan suꞌlviqꞌo aꞌ tzaꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Tal u Jesuus te ech tzaꞌ: —Kuxh sikꞌle vavinaj, ech luꞌulaxh tzaꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tzaqꞌbꞌu u ixoj utz, tal te ech tzaꞌ: —Yeꞌk unvinaj.— Texhtuꞌ. Tal u Jesuus te ech tzaꞌ: —Nojchit naaleꞌ aas: «Yeꞌk unvinaj.» Chaꞌaxh. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Tan oꞌvaꞌx avinaj atini. Utz aatz vamol cheel, yitꞌ avinaj koj. Ech inujul vaꞌl vetaallaꞌ tziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Tal u ixoj te ech tzaꞌ: —UnBꞌaal, nojchit axh alol tetz u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Pek saabꞌi tan, aatz qꞌu kukꞌuy kumam, motx toksa iqꞌii Tioxh tu u muunte tzaꞌ. Utz aatz ex, ex aa Judea taꞌxh soꞌokk iqꞌii u Tioxh tu Jerusaleen netaleꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Utz tal u Jesuus te ech tzaꞌ: —Ixoj, nima vaꞌl nivaleꞌ tzaꞌ. Tan toj nal uloj tiempo aas nikoꞌxh tu u muunte tzaꞌ utz, nikoꞌxh tu Jerusaleen soꞌokk iqꞌii u kuTat tu Amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Tan aatz ex cheel, yeꞌ etootzaj abꞌil netoksa iqꞌii. Pek aatz oꞌ, qootzajle abꞌil niqoksa iqꞌii. Tan aꞌ niulku u chitpichil tu paav xeꞌ qꞌu aa Judea. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Utz ulyu texh u tiempo. Cheel tek vaꞌl soꞌoksal iqꞌii u kuTat tu Amlika tu qꞌu aanima qꞌuꞌl nojchit ayaꞌl ikꞌuꞌl tiꞌ. Utz saꞌxhtoksa iqꞌii tu taanima majte. Tan ech qꞌu aanima isaꞌ u kuTat; aꞌ isaꞌ siqꞌila isikꞌle tu taanima. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tan tioxhla aanxel u Tioxh. Utz ministeer tu taanxelal u aanima satoksav iqꞌii majte; tinujul chit siꞌaneꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Tal u ixoj te ech tzaꞌ: —Vootzajle saꞌchitꞌul u Cristo, viTxaaom u Tioxh. Ech aꞌ toj alon kajay qꞌu kam qe atziꞌ aas luꞌuli.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Tal u Jesuus te ech tzaꞌ: —In vaꞌl suꞌuli naaleꞌ tziꞌ, vaꞌl niyolon sauchꞌ cheel tzaꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tuul opon qꞌul ichusulibꞌ u Jesuus. Utz motx sotz ikꞌuꞌl aas tila nichiyolon tuchꞌ maꞌl u ixoj. Loqꞌ yeꞌxhabꞌil maꞌj chꞌotin te aas: —¿Kam naabꞌi te utz, kam nayol tuchꞌ?— Texh koj. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ech aatz u ixoj, taqꞌka vitxeꞌn. Bꞌen tu u tenam. Ex tal tu qꞌu aanima ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—¡Niꞌextaj! Uloj etil maꞌl u vinaj. Tan maꞌxh motx tallu ve kam chit bꞌanel vaqꞌo. ¿Matz yitꞌ aꞌ viTxaaom u Tioxh?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ech motx kꞌasuꞌl aanima tu u tenam utz, ul kꞌatz u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tuul aatz qꞌu chusulibꞌ, nichiꞌan yaꞌl u Jesuus ech tzaꞌ: —Chusul, txꞌaꞌn tekuꞌen.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pek tal koꞌn u Jesuus te ech tzaꞌ: —Atil maꞌl vechbꞌubꞌal savechbꞌu aas yeꞌ etootzaj.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Utz motx tek tal qꞌu chusulibꞌ tibꞌilaj ech tzaꞌ: —¿Kamal iqꞌoli ul techbꞌubꞌal?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Tal u Jesuus te: —Aatz u vechbꞌubꞌal, ayaꞌ vaꞌl sunbꞌan vitxumbꞌal vaꞌl vetchajonkꞌasuꞌlin utz, suntzojpi u taqꞌon majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nimotxetaleꞌ aas: «Kaavaꞌt ichꞌ topon u chokbꞌal triigo.» Cheꞌex. Pek nival sete sajinojbꞌenex viꞌ qꞌu chikobꞌeꞌm triigo etileꞌ. Qꞌanqꞌo tek tiloneꞌ tan, tzajya. Oponyu u tiempo chokbꞌal tetz. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Utz nikꞌul jaꞌmel iqꞌii u chokol tetz. Tan aatz vaꞌl niꞌaneꞌ, tetz atinchil tu bꞌenqꞌii bꞌensaj. Ech ela sachiꞌbꞌ u chikol tuchꞌ u chokol. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Utz ech sanojpu u yol vaꞌl nital ech tzaꞌ: «Paarten vaꞌl nichikoneꞌ utz, paarten vaꞌl nichokoneꞌ.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Utz nojchituꞌ. Tan nunchajbꞌenex, echaꞌ tiꞌ en ichokax vatz chikobꞌeꞌm aas yitꞌ ex koj aqꞌonin. Pek paarten aqꞌonin. Saꞌtexhenechok vaꞌl paarten vetok tu tzaꞌl tiꞌ taqꞌonileꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Uncheeꞌ sibꞌal qꞌu aa Samaaria motx niman u Jesuus tiꞌ viyol u ixoj vaꞌl tal ech tzaꞌ: —Maꞌxh tallu ve kajay chit qꞌu kam bꞌanel vaqꞌo.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ech opon qꞌu aa Samaaria kꞌatz u Jesuus. Utz motx ijaj bꞌaꞌnil te aas sakaaka bꞌitoj tzixeꞌ. Ech kaa chit kaꞌvaꞌl qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Utz sibꞌal paj aanima niman u Jesuus tu viyol vaꞌl tala. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Utz nichtekmotxtal qꞌu aanima tu u ixoj ech tzaꞌ: —Yitꞌ taꞌn tekoꞌnkoxh sakunimav u Jesuus tiꞌ vayol aala. Tan vetqabꞌilaꞌ utz, vetmotxqootzajilaꞌ aas nojchit aꞌ u Chitol aanima tipaav tu u vatz amlika txꞌavaꞌ tzaꞌ. Aꞌ viTxaaom u Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Uncheeꞌ aatz paal kaꞌvaꞌl qꞌii, elkꞌasuꞌl u Jesuus tu Samaaria utz, bꞌen tu Galilea. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Utz u Jesuus atkoꞌxh alon aas yeꞌkax oksal iqꞌii maꞌl alol tetz u yolbꞌal Tioxh titenam. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pek bꞌen tu Galilea. Utz bꞌaꞌn ikꞌulax bꞌanaxi. Tan maꞌtich tiltu kajay qꞌu kam qꞌu aa Galilea qꞌuꞌl iꞌan u Jesuus tu u nimla qꞌii tu Jerusaleen. Tan antu atich opon qꞌu aa Galilea tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Uncheeꞌ opon paj u Jesuus tu Canaa tikuenta Galilea tu vaꞌl taqꞌvu bꞌens taꞌl uuva u aꞌ. Utz atich maꞌl u vinaj tziꞌ, qꞌesal isol u ijlenal. Yaꞌvich maꞌl ikꞌaol. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ech tabꞌi u vinaj tziꞌ aas maꞌtich ikꞌasuꞌl u Jesuus tu Judea utz, atich tek tu Galilea. Ech ex ikꞌuleꞌ. Ijaj bꞌaꞌnil te aas sabꞌen tiꞌ; seꞌniꞌan bꞌaꞌn tu vikꞌaol. Tan siꞌchtexhkami. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Loqꞌ tal u Jesuus ech tzaꞌ: —Saꞌkojnimanex aas yeꞌ koj netil qꞌu xheenya tuchꞌ qꞌu txaichil nunbꞌaneꞌ tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Utz aatz u qꞌesal sol tan, tal ech tzaꞌ: —UnBꞌaal, kuxh il vunkꞌaol tan, noj ikameꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Utz tal u Jesuus te ech tzaꞌ: —Kuxh il vakꞌaol tan, bꞌaꞌnte.— Texh te. Aatz u vinaj, inima vaꞌl tal u Jesuus te utz, bꞌeni. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ech ul kꞌulaxoj tu qꞌu taqꞌonom aas aalich tek ibꞌen tu tatibꞌal. Utz tal te ech tzaꞌ: —¡Bꞌaꞌntu vakꞌaol!— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Uncheeꞌ ichꞌoti tek tu qꞌu taqꞌonom aas kam oora xeꞌt iꞌan bꞌaꞌn. Utz alax te ech tzaꞌ: —Eeten kuꞌqꞌii ala 1 tzaa u xamal tiꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Utz el tek itxumbꞌal vitat u xiak tuul aas aꞌich u oora tziꞌ vaꞌl tal u Jesuus te: —Bꞌaꞌntu vakꞌaol.— Texh te. Ech inima u Jesuus u qꞌesal sol tuchꞌ ikꞌaol imeꞌal kajayil. ");
INSERT INTO ixlCNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Uncheeꞌ aꞌ u kaꞌbꞌ txaichil iꞌan u Jesuus tziꞌ aas kꞌasuꞌl tu Judea utz, opon tikuenta Galilea. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Xamtich tek tiꞌ qꞌu kam tzaꞌ, bꞌen u Jesuus tu Jerusaleen tu maꞌl u nimla qꞌii tetz qꞌu Israeel. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Utz atil maꞌl u molbꞌal aꞌ tu Jerusaleen, Betesda ibꞌii tu yolbꞌal hebreo. Najaꞌch u okebꞌalop tu u tenam vaꞌl Tokebꞌalop Karneꞌl. Utz atil oꞌvaꞌl piraal sitziꞌ u molbꞌal aꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Utz sibꞌal yaꞌv atich kꞌatza. At moy. Utz at koꞌx. Utz atia ichiꞌl numtzꞌinaj. Nichmotxichꞌia iyikul u aꞌ tu u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Tan atkoꞌxh tuul nichtul maꞌl aanjel tziꞌ u aꞌ tziꞌ. Utz nichꞌuliyiku u aꞌ. Ech yak nichiꞌanka bꞌaꞌn u yaꞌv vaꞌl bꞌaxal nikoꞌp tu u aꞌ aas maꞌt iyikuleꞌ, kꞌuxh kam koꞌxh yaabꞌilil nichbꞌanon. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Utz atich maꞌl u vinaj tziꞌ aas maꞌtich tel 38 yaꞌbꞌ tok iyaabꞌil. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ilax tu u Jesuus aas xoklich tziꞌ. Utz tabꞌi aas sibꞌich tek tiempo tok viyaabꞌil. Ech iqꞌila tal te ech tzaꞌ: —¿Satz asaꞌa saꞌan bꞌaꞌn?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tzaqꞌbꞌu u yaꞌv ech tzaꞌ: —UnBꞌaal, yeꞌxhabꞌil niꞌaqꞌonkoꞌpꞌin tu aꞌ tziꞌ, aas niyikunsaleꞌ. Anal koꞌxh nixeꞌtunbꞌenaꞌ, tuul vaꞌlen bꞌaxal nikoꞌp sunvatz.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Tal u Jesuus te ech tzaꞌ: —Lakpen. Iqꞌo bꞌen u chelebꞌ eetz tziꞌ utz, xaan.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ech tu koꞌxh unmuꞌkꞌul iꞌan bꞌaꞌn u vinaj. ¡Tiqꞌo kꞌasuꞌl u chelebꞌ tetz utz, xaan tekuꞌen! Utz tuich ilanbꞌal qꞌii iꞌana. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ech aatz qꞌu qꞌesal uqꞌaybꞌal, tal tu u vinaj vaꞌl maꞌtich iꞌantu bꞌaꞌn ech tzaꞌ: —Ilanbꞌal qꞌii atzaꞌ. Yeꞌk siꞌaneꞌ siiqꞌo bꞌen u chelebꞌ eetz tziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Pek itzaqꞌbꞌe koꞌn ech tzaꞌ: —Aatz vaꞌl vetbꞌanon bꞌaꞌn ve, anat vetalon ve: «Iqꞌo bꞌen u chelebꞌ eetz tziꞌ utz, xaan.» Chia.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Utz chꞌotil te ech tzaꞌ: —¿Abꞌil vaꞌl vetꞌalon see aas: «Iqꞌo u chelebꞌ eetz tziꞌ utz, xaan.» Chia?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Loqꞌ yeꞌich tootzaj u vinaj iꞌan bꞌaꞌn tziꞌ abꞌil vaꞌl bꞌanon bꞌaꞌn te. Tan aatz u Jesuus, maꞌtich ikꞌasuꞌl xoꞌl qꞌu aanima tziꞌ u aꞌ tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Uncheeꞌ xamtel tek tuul ilax u vinaj tu viqꞌanalil u totztioxh tu u Jesuus. Utz tal te ech tzaꞌ: —Abꞌi iileꞌ, vetaꞌanlu bꞌaꞌn. Pek paavinichtereꞌnaxh tan, noj akꞌul vaꞌt yaabꞌil paalchu viꞌ vaꞌl vetbꞌanonaxh tziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ech kꞌasuꞌl u vinaj, ex tal tu qꞌu qꞌesal uqꞌaybꞌal aas u Jesuus vaꞌl bꞌanon bꞌaꞌn te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ech tiꞌ u kam tziꞌ, nichtekiꞌan ikꞌuꞌl qꞌu qꞌesal uqꞌaybꞌal tiꞌ u Jesuus aas siyatzꞌeꞌ tan, tu ilanbꞌal qꞌii iꞌan u kam tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pek tal u Jesuus te ech tzaꞌ: —Ankoꞌxh nitaqꞌonin vunTat cheel. Utz nivaqꞌonin majte.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ech aatz qꞌu qꞌesal uqꞌaybꞌal xoꞌl qꞌu Israeel, aal chit tiira titzꞌa iyatzꞌaxeꞌ. Yitꞌ tiꞌ koꞌnkoxhtuꞌ aas nichiqel u ilanbꞌal qꞌii siatz, pek tiꞌ majte aas Tioxh iTat nichtaleꞌ. Nitaqꞌ bꞌens tibꞌ echaꞌ Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Uncheeꞌ tzaqꞌbꞌu u Jesuus utz, tal ech tzaꞌ: —Niꞌxhtekꞌval sete aas yeꞌxhkam maꞌj kam niꞌan u Kꞌaola sijunal. Pek aꞌ niꞌaneꞌ vaꞌl nitileꞌl kꞌatz viTat. Tan kajay vaꞌl niꞌan u Tata, niꞌan u Kꞌaola majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tan tii u Tata tiꞌ u Kꞌaola. Utz nikꞌuch kajay qꞌu kam te qꞌuꞌl niꞌaneꞌ. Utz paalchu tereꞌn koꞌxh kam sikꞌuch te vatz qꞌu kam tzaꞌ. Ech satzꞌejx ekꞌuꞌl taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tan aatz u Tata, niqꞌaavtitzꞌpixsa qꞌu kamnaj utz, nitaqꞌ vatz iqꞌii isaj. Utz echat u Kꞌaola majte. Utz sataqꞌ vatz iqꞌii isaj abꞌil sisaꞌa sataqꞌ vatz iqꞌii isaj sinacheꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Utz aatz u Tata, yeꞌxhabꞌil koꞌxh nitxꞌol inujul ipaav. Pek vettaqꞌluka tiqꞌabꞌ viKꞌaol vitxꞌolax inujul qꞌu kam. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ech soꞌok iqꞌii u Kꞌaola tu kajay aanima, echaꞌ tok iqꞌii u Tata niꞌaneꞌ. Utz abꞌil vaꞌl yeꞌk soꞌoksan iqꞌii u Kꞌaola, aꞌ yeꞌ nitoksa iqꞌii u Tata atziꞌ vaꞌl vetchajon ul. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Niꞌxhtekꞌval sete aas saꞌatin tu u bꞌenqꞌii bꞌensaj abꞌil aꞌ niabꞌin qꞌul unyol tzaꞌ utz, ninima vaꞌl vetchajonkꞌasuꞌlin. Utz yitꞌ saꞌkojbꞌen tu u choobꞌal paav. Pek elyu vatz u kamchil utz, aqꞌaxyu itiichajil. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Niꞌxhtekꞌval sete, tul u tiempo utz, cheel texhtuꞌ aas saqꞌaavitzꞌpu qꞌu kamnaj taꞌxh satabꞌi viviꞌ viKꞌaol u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Utz aatz u Tata, nitaqꞌ jeꞌ itiichajil sijunal. Echat u Kꞌaola majte, aqꞌel tijleꞌm aas sataqꞌ jeꞌ itiichajil sijunal. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Utz aqꞌel tijleꞌm tiꞌ itxꞌolax inujul kam majte. Tan nojchit aꞌ viKꞌaol u Tioxh vaꞌl ulnaj xoꞌl qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Utz yeꞌ koꞌxh tzꞌejx ekꞌuꞌl tu qꞌu kam nivaleꞌ tzaꞌ. Tan toj nal uloj tiempo aas kajay qꞌu kamnaj atil tu jul satabꞌi viyol viKꞌaol u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Utz aatz qꞌuꞌl ijikomal iꞌana aas itzꞌliche, saqꞌaavitzꞌpi. Yak tu atinchil tu bꞌenqꞌii bꞌensaj. Pek aatz qꞌuꞌl yeꞌxtxoj motx iꞌana, saqꞌaavitzꞌpi. Loqꞌ yak tu u choobꞌal paav. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yeꞌxhkam nunbꞌan qꞌu kam sunjunal. Pek kam vaꞌl nital vunTat, ech itxꞌolax inujul qꞌu kam nunbꞌaneꞌ. Utz jikom vitxꞌolax inujul nunbꞌaneꞌ. Tan yitꞌ aꞌ koj nivitzꞌa toksal untxumbꞌal. Pek aꞌ nivitzꞌa ibꞌanax vitxumbꞌal vunTat vaꞌl vetchajonkꞌasuꞌlin. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Utz yeꞌxhkam nivoksa jeꞌ unqꞌii tiꞌ vaꞌl nunbꞌaneꞌ. Tan oj ech sunbꞌaneꞌ, saꞌkojnimalin tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pek atil maꞌl nioksan unqꞌii. Utz vootzajle aas inujul vaꞌl nital viꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Aatz ex, echaj bꞌen echaj xeꞌ u Xhan tiꞌ ichꞌotil te aas abꞌil in. Utz tal vinujul sete. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Loqꞌ yitꞌ aꞌ koj nivoksa tetz abꞌil in nital qꞌu aanima. Pek aꞌ unsaꞌ sachitpꞌex tu qꞌul epaav kꞌuxh nival u kam tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Tan aatz u Xhan, echaꞌ maꞌl txijtxubꞌal nichtoyveꞌ utz, nichitxijtxuneꞌ. Utz ebꞌan koꞌxh ok aas txuqꞌtxun maꞌl tiempo ex kꞌatza tu vitxijtxuneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pek atil kam nikꞌuch tinujul aas abꞌil in; paalchu viꞌ vaꞌl tal u Xhan. Utz ayaꞌ qꞌu txaichil qꞌuꞌl taqꞌ vunTat ve aas sunbꞌaneꞌ. Aꞌ qꞌuꞌl nikꞌucheꞌ aas nojchit vunTat vetchajonkꞌasuꞌlin. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Utz aatz vunTat majte vaꞌl vetchajonkꞌasuꞌlin, aꞌ nialon abꞌil in, kꞌuxh yeꞌxhkam netileꞌ etabꞌi. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Yeꞌk viyolbꞌal vunTat sekꞌatza tan, yeꞌ nenima vaꞌl vetichajuꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nixhepichꞌu u Yolbꞌal Tioxh vaꞌl tzꞌibꞌamalka. Tan aꞌ netal echabꞌat u tiichajil tetz bꞌenqꞌii bꞌensaj tuul. Bꞌaꞌn. Loqꞌ aꞌ niyolonku u Yolbꞌal Tioxh viꞌ majte. Nitaleꞌ abꞌil in. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pek aatz ex, yeꞌsaꞌ okchil sunkꞌatza tiꞌ etok tu atinchil kꞌatz Tioxh utz, aal in aqꞌol tetz u atinchil tu bꞌenqꞌii bꞌensaj. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Aatz in, yeꞌxhkam nunkꞌul qꞌu tokebꞌal qꞌii qꞌuꞌl aanima koꞌn saꞌalon viꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Tan vootzajlex aas yitꞌ tzꞌejel koj etaanima tiꞌ Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yeꞌ nekꞌulin utz, aal tibꞌii vunTat vetꞌulkꞌin. Pek sekꞌuleꞌ atziꞌ aas nikojtul vaꞌte aas tibꞌii atkoꞌxh suꞌulka. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Loqꞌ yeꞌxhkaniꞌch enimataꞌ tan, naqꞌbꞌinajex tiꞌ etoksat jeꞌ eqꞌii sevatzaj. Pek aꞌ yeꞌ nechok u tokebꞌal qꞌii vaꞌl nikꞌasuꞌl xeꞌ u Tioxh vaꞌl taꞌxh maꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Utz etitzꞌachi aas nunxochꞌex vatz vunTat. Tan atil nal xochol etetz. Ayaꞌ u Moisees vaꞌl taꞌxh kꞌujlel ekꞌuꞌl tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tan noj koj chit nenima u Moisees, senimaꞌin majte koj atziꞌ. Tan viꞌ itzꞌibꞌavka qꞌu kam. ");
INSERT INTO ixlCNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pek untzꞌoj yeꞌ nenima qꞌuꞌl tzꞌibꞌamalka taqꞌo, ¿aꞌ chixh senima vunyolbꞌal?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Uncheeꞌ aatz xamtich tek tiꞌ qꞌu kam tziꞌ, bꞌen u Jesuus sala bꞌen u choo tu Galilea, vaꞌl Tibeerias. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Utz mam tenam xamich tiꞌ tan, nichtil qꞌu txaichil tiꞌ ibꞌaꞌnixsal qꞌu yaꞌv. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ech bꞌenjeꞌ u Jesuus viꞌ maꞌl u muunte. Kꞌujeꞌ tziꞌ tuchꞌ qꞌul ichusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Utz nichtekinajabꞌ vinimla qꞌii qꞌu Israeel, tiꞌ u Elchil Vatz Kamchil Tu Egipto. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ech sajin paal u Jesuus utz, til u mam tenam xamich tiꞌ. Tal tek tu u Felipe ech tzaꞌ: —¿Til sakuloqꞌvu kaxhlaan txꞌix ech seechbꞌun qꞌu aanima tziꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Loqꞌ provaal koꞌn iꞌan te kꞌuxh tal u kam ech tziꞌ. Ech satileꞌ kam bꞌioj satal u Felipe tiꞌ. Tan atich tek kꞌuꞌl kam vaꞌl siꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tzaqꞌbꞌel tu u Felipe ech tzaꞌ: —Saꞌkojtakꞌa 200 jaꞌmel aqꞌonibꞌal qꞌii tziꞌ aas sakuloqꞌ kaxhlaan txꞌix tiꞌ. Saꞌkojtakꞌa kꞌuxh bꞌioj koꞌxh tetz qꞌu aanima satechbꞌu sijununil tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ech aatz maꞌl tu qꞌu chusulibꞌ vaꞌl Lixh ibꞌii, vitzaꞌqꞌ u Xhim, vaꞌl Luꞌ majte, tal tu u Jesuus ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Atil maꞌl u xiak tzaꞌ aas atil oꞌvaꞌl kaxhlaan txꞌix sebada tzixeꞌ, tuchꞌ kaꞌvaꞌt txay. Loqꞌ kam koj sayolonku vantziꞌ tziꞌ. Saꞌkojtakꞌa tetz sibꞌal aanima.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Pek tal u Jesuus ech tzaꞌ: —Altaj ikꞌujeꞌ qꞌu aanima vatz txꞌavaꞌ tziꞌ.— Texhtuꞌ. Tan vaꞌlich chꞌim latziꞌ. Ech motx ikꞌujeꞌ kuꞌ qꞌu aanima. Utz kamal 5,000 ixaaneꞌ, taꞌxh qꞌu vinaj. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ech itxaytu qꞌu kaxhlaan txꞌix u Jesuus. Ikꞌamabꞌe Tioxh tiꞌ. Utz ijatx paal vatz qꞌul ichusulibꞌ. Aatz qꞌu chusulibꞌ, ijatx tek paal vatz qꞌu aanima qꞌuꞌl kꞌujliche. Echat koꞌxh iꞌan u Jesuus tu qꞌu txay majte. Ijatxa jankꞌal isaꞌ qꞌu aanima sijununil. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Uncheeꞌ aatz maꞌtich tek motx inoo qꞌu aanima, tal u Jesuus tu qꞌul ichusulibꞌ ech tzaꞌ: —Moltaj qꞌu echbꞌubꞌal chananya tziꞌ, ech yeꞌk sabꞌuchli.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ech motx imol qꞌu chan utz, kabꞌlaat txakatx inoosa. Aꞌ vichan u oꞌvaꞌl kaxhlaan txꞌix sebada vaꞌl motx techbꞌu. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Aatz tek qꞌu aanima qꞌuꞌl ilon u txaichil iꞌan u Jesuus tziꞌ, motx tal ech tzaꞌ: —¡Nojla aꞌ u alol tetz u yolbꞌal Tioxh atziꞌ vaꞌl saꞌnalchitꞌul tu u vatz amlika txꞌavaꞌ tzaꞌ!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pek paal itxumbꞌal u Jesuus tuul aas taꞌxh siꞌchuliqꞌoloj bꞌen tu qꞌu aanima. Utz satoksas ijlenalil nichmotxtaleꞌ. Ech qꞌaavbꞌen viꞌ u muunte sijunal. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Uncheeꞌ aatz tek nichisotz saj, bꞌen qꞌul ichusulibꞌ u Jesuus tziꞌ choo. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Utz motx okbꞌen tu maꞌl u jukubꞌ. Paalbꞌen viꞌ u choo. Aalich ibꞌen tu Capernauum, tuul ukenich tekuꞌen. Utz yeꞌsajich topon u Jesuus tixoꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ech vaꞌlich ipilqꞌaꞌtxan u choo tu maꞌl u mam kajiqꞌ nichipaaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Utz motx til u Jesuus aas maꞌtich ixaan okoꞌp viꞌ u choo. Kamal maꞌt tel oꞌvaꞌl oj vaajil kiloometro tokoꞌp. Nichixaan u Jesuus viꞌ u aꞌ. Aalich topon kꞌatz u jukubꞌ. Ech motx chit xoꞌvi. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pek tal u Jesuus te ech tzaꞌ: —In atziꞌ. Yeꞌ koꞌxh xoꞌvex.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Aatz tek qꞌu chusulibꞌ, ayaꞌl chit ikꞌuꞌl ikꞌul u Jesuus sikꞌatza tu u jukubꞌ. Ech yakich opon tu u txꞌavaꞌ vaꞌl yakichka. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Uncheeꞌ tu tek vaꞌt qꞌii tuul, at bꞌenku tu qꞌu aanima qꞌuꞌl atichka tunpaqꞌit itziꞌaj u choo, aas maꞌl koꞌn jukubꞌ atich tziꞌ. Utz yeꞌt okbꞌen u Jesuus tuul. Pek taꞌxh motx til tokbꞌen qꞌu chusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Utz atich unjot aanima opon tziꞌ tuchꞌ ijukubꞌ; tu Tibeerias kꞌaskuꞌl. Opon tu vaꞌl txꞌaꞌlik u kaxhlaan txꞌix, vaꞌl ikꞌama Tioxh u kuBꞌaal Jesuus tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Pek til qꞌu aanima aas yeꞌkich u Jesuus tziꞌ; nikoꞌxh qꞌul ichusulibꞌ. Ech motx tek okbꞌen tu qꞌu jukubꞌ utz, bꞌen tu Capernauum tiꞌ en ichokax u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Aatz motx ichabꞌat sala bꞌen u choo, motx tal te ech tzaꞌ: —Chusul, ¿jatut ulaxh tzaꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Tzaqꞌbꞌu u Jesuus utz, tal te ech tzaꞌ: —Niꞌxhtekꞌval sete, kꞌuxh nechokꞌin, yitꞌ tiꞌ koj u txaichil unbꞌana, pek tiꞌ u kaxhlaan txꞌix etxꞌaꞌa utz, inoosaꞌex. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ech aqꞌoninojex, loqꞌ yitꞌ tiꞌ koꞌnkoxh u echbꞌubꞌal vaꞌl nikoꞌnipaaleꞌ. Pek aqꞌoninojex tiꞌ u echbꞌubꞌal vaꞌl bꞌenqꞌii bꞌensaj tatineꞌ. Ayaꞌ vaꞌl sataqꞌ sete u Kꞌaola vaꞌl bꞌennaj koꞌn aanima. Tan aꞌ vaꞌl aqꞌel tijleꞌm tu u Tioxh, u kuTat.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Motx tek tal qꞌu aanima te ech tzaꞌ: —¿Kam sakubꞌaneꞌ uncheeꞌ, ech sakubꞌan oꞌ bꞌanol tetz qꞌu kam isaꞌ u Tioxh?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tzaqꞌbꞌu u Jesuus, tal te ech tzaꞌ: —Aꞌ u kam isaꞌ u Tioxh aas senima vaꞌl vetichajuꞌl.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Motx tal te ech tzaꞌ: —¿Kam maꞌj xheenya sakꞌuch sukuvatz uncheeꞌ, ech saqileꞌ utz, sakunimaꞌaxh? Saqileꞌ kam chit qꞌuꞌl naꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Tan aatz qꞌu kukꞌuy kumam, motx techbꞌu u echbꞌubꞌal manaa tu u tzaji txꞌavaꞌ. Echaꞌ u yol tzꞌibꞌamalka aas: «Kaxhlaan txꞌix tu Amlika taqꞌs techbꞌubꞌal.» Chia.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Utz tal u Jesuus te ech tzaꞌ: —Niꞌxhtekꞌval sete aas aꞌ koj u nojla kaxhlaan txꞌix tu Amlika vaꞌl taqꞌ u Moisees sete. Tan vunTat niaqꞌon u nojla kaxhlaan txꞌix vaꞌl tu Amlika vetkuꞌkuꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tan aatz u kaxhlaan txꞌix vaꞌl nitaqꞌ u Tioxh, ayaꞌ vaꞌl kuꞌl tu Amlika. Nitaqꞌ itiichajil qꞌu aanima vatz Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Alax te ech tzaꞌ: —KuBꞌaal, aqꞌ u kaxhlaan txꞌix qe bꞌenamen tziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Utz tal u Jesuus te ech tzaꞌ: —In u kaxhlaan txꞌix tetz tiichajil vatz Tioxh. Ech abꞌil vaꞌl suꞌul sunkꞌatza, jatu koj savaꞌyi. Utz jatu koj satzaj itziꞌ vaꞌl sanimanin. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pek vetvallu sete aas kꞌuxh vetetillin, yeꞌ nenimaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tan jatvaꞌl qꞌu aanima nitaqꞌ vunTat ve, saul sunkꞌatza. Utz abꞌil vaꞌl nitul sunkꞌatza saꞌkojvaqꞌka eloꞌp echil tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Tan yitꞌ untxumbꞌal koj ul unbꞌaneꞌ kꞌuxh vetkuꞌlin tu Amlika. Pek aꞌ ul unbꞌan vitxumbꞌal vaꞌl vetchajonin. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Utz aꞌ vitxumbꞌal vunTat vaꞌl vetchajonin aas jatvaꞌl qꞌu niman vetz sataqꞌ ve, jatu koj suntzꞌej maꞌj te. Pek saqꞌaavitzꞌpixsa xoꞌl qꞌu kamnaj tu u motxebꞌal qꞌii saj. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Aꞌ paj vitxumbꞌal u chajol vetz aas saꞌatin itiichajil tu bꞌenqꞌii bꞌensaj kajay qꞌu aanima qꞌuꞌl sailon u Kꞌaola utz, sinima. Ech saitzꞌpixsal jeꞌ xoꞌl qꞌu kamnaj tu u motxebꞌal qꞌii saj.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ech chiꞌon taanima qꞌu qꞌesal uqꞌaybꞌal xoꞌl qꞌu Israeel, tiꞌ u Jesuus. Nichtekmotxiyol vaꞌl tal u Jesuus aas: —In u echbꞌubꞌal vaꞌl vetkuꞌl tu Amlika.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Utz nichtekmotxtal qꞌu qꞌesala ech tzaꞌ: —¿Yitꞌ tzik aꞌ u Jesuus tziꞌ vikꞌaol u Xhep? Tan qootzajle vitat tuchꞌ vinan atziꞌ. Pek kam tek tok nitaleꞌ aas: «Aꞌ vetkuꞌkuꞌlin tu Amlika.» Chia.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Utz tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Yeꞌ koꞌxh chiꞌon etaanima viꞌ tuul neyolin sevatzaj. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tan yeꞌxhabꞌil koꞌxh maꞌj suꞌul sunkꞌatza oj yitꞌ aꞌ koj saiqꞌon ul vunTat vaꞌl vetchajonin. Ech saqꞌaavitzꞌpu vaqꞌo xoꞌl qꞌu kamnaj tu u motxebꞌal qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tan tzꞌibꞌamalka tu qꞌu alol tetz u Yolbꞌal Tioxh aas: «Kajay aanima sachusax tu u Tioxh.» Chia. Ech tokeꞌ kajay qꞌuꞌl niabꞌin vunTat utz, nichabꞌa el tetz kꞌatza, nitul sunkꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Loqꞌ yitꞌ tiꞌ koj aas abꞌil maꞌj ilonnaj tetz vunTat. Tan taꞌxh in ilonnaj tetz; in vetkꞌasuꞌlin tzixeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ech niꞌxhtekꞌval sete aas abꞌil vaꞌl ninimanin, atil itiichajil tu bꞌenqꞌii bꞌensaj. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Tan in u kaxhlaan txꞌix tetz tiichajil vatz u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Aatz qꞌul ekꞌuy emam, techbꞌu u echbꞌubꞌal vaꞌl manaa tu u tzꞌinlich tzaji txꞌavaꞌ utz, motx koꞌn kami. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pek in u nojla kaxhlaan txꞌix vaꞌl nojchit vetkuꞌlin tu Amlika. Utz abꞌil vaꞌl satechbꞌu tetz yitꞌ saꞌkojkami. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","In vaꞌl vetkuꞌlin tu Amlika. Utz nivaqꞌ tiichajil bꞌenamen. Utz abꞌil maꞌj saechbꞌun u echbꞌubꞌal tzaꞌ, saꞌatin itiichajil bꞌenamen. Tan aatz u echbꞌubꞌal savaqꞌeꞌ, ayaꞌ vunchiꞌl. Aꞌ vaꞌl savaqꞌ tiꞌ vitiichajil qꞌu aanima tu u vatz amlika txꞌavaꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ech xeꞌt motx iyol qꞌu qꞌesala sivatzaj ech tzaꞌ: —¿Kam tok nital vaꞌl tziꞌ sataqꞌ vichiꞌl qe, saqechbꞌu nital tzik?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Utz tal u Jesuus te ech tzaꞌ: —Niꞌxhtekꞌval sete aas yeꞌk etiichajil tu bꞌenqꞌii bꞌensaj oj yeꞌk setechbꞌu vichiꞌl u Kꞌaola vaꞌl bꞌennaj koꞌn aanima utz, oj yeꞌk setukꞌa vikajal. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Tan atil itiichajil tu bꞌenqꞌii bꞌensaj vaꞌl niechbꞌun vunchiꞌl utz, niukꞌan vunkajal. Utz saqꞌaavvitzꞌpixsa xoꞌl qꞌu kamnaj tu u motxebꞌal qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tan nojla echbꞌubꞌal vunchiꞌl utz, nojla ukꞌam aꞌ vunkajal. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Abꞌil vaꞌl niechbꞌun vunchiꞌl utz, niukꞌan vunkajal, tiira atil sunkꞌatza atziꞌ. Utz atilin kꞌatza majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Aꞌ vetchajonin vunTat vaꞌl bꞌenqꞌii bꞌensaj tatineꞌ. Utz tiqꞌaqꞌal atilin. Echat vaꞌl seechbꞌun vunchiꞌl majte, unqꞌaqꞌal kuꞌen saitzꞌeꞌ sunkꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Aatz u nojla echbꞌubꞌal vaꞌl vetkuꞌl tu Amlika, yitꞌ ela koj tuchꞌ u manaa vaꞌl techbꞌu qꞌul ekꞌuy emam. Utz motx kuꞌen kami. Pek abꞌil seechbꞌun u echbꞌubꞌal tzaꞌ, saꞌatin itiichajil bꞌenqꞌii bꞌensaj.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Aatz qꞌu kam tzaꞌ, aꞌ talvu Jesuus tu u atibꞌal chusbꞌal tetz u oꞌtla mantaar aas nichichusun tu Capernauum. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ech aatz tabꞌi u yol qꞌu niman tetz tziꞌ, sibꞌal motx alon ech tzaꞌ: —Tii tek qꞌu yol atziꞌ. ¿Abꞌil sakanon tiqꞌoleꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ech paal itxumbꞌal u Jesuus tuul aas nichiyolaxeꞌ. Ech tal te tzaꞌ: —¿Nisotz ekꞌul tu qꞌu kam tziꞌ tzik? ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Pek ¿kam tek setaleꞌ aas setil ibꞌenjeꞌ u Kꞌaola vaꞌl bꞌennaj koꞌn aanima tu vaꞌl atichnalku bꞌaxa? ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Tan u qaanxelal vaꞌl niaqꞌon u tiichajil kꞌatz u Tioxh. Aatz u chiꞌl tan, sakoꞌnyaꞌi. Pek aatz qꞌu yol qꞌuꞌl nival sete tzaꞌ tan, itzꞌlich yol tetz aanxelal utz, tetz tiichajil tu bꞌenqꞌii bꞌensaj. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pek atil unjolol sete aas yeꞌ ninimaneꞌ.— Texhtuꞌ. Tan tootzajich u Jesuus tixeꞌtebꞌal abꞌil qꞌuꞌl yeꞌ nichmotxniman. Utz tootzajle abꞌil vaꞌl saoksan tiqꞌabꞌ qꞌu txayol. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Utz tal u Jesuus ech tzaꞌ: —Echixeꞌat alel sete vaqꞌo aas yeꞌxhabꞌil koꞌxh maꞌj suꞌul sunkꞌatza oj yitꞌ vunTat saoksan sikꞌuꞌl.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ech sibꞌal qꞌuꞌl nichniman, motx tek elka aas tabꞌi qꞌu kam tziꞌ. Yeꞌt xambꞌu veꞌt tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Utz tal tek u Jesuus tu kabꞌlaal qꞌu chusulibꞌ ech tzaꞌ: —¿Satz esaꞌa sabꞌenex majte?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tzaqꞌbꞌel tu u Xhim, vaꞌl Luꞌ majte. Tal te ech tzaꞌ: —KuBꞌaal, ¿abꞌil iꞌ seꞌenkꞌoꞌ? Tan taꞌxh maꞌl axh aas tetz tiichajil tu bꞌenqꞌii bꞌensaj qꞌul ayol. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Utz vetkunimalaꞌ. Qootzajle aas axh viTxaaom u Tioxh, viKꞌaol u Tioxh vaꞌl bꞌenqꞌii bꞌensaj tatineꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Uncheeꞌ tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —In vettxaaonex kabꞌlaal ex tziꞌ. Loqꞌ atil maꞌl sete atil u txꞌiꞌliꞌinaj kꞌatza.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Loqꞌ aꞌ nichtaleꞌ u Judas aa Cariote, vikꞌaol u Xhim. Tan aꞌ vaꞌl siꞌchoksan tiqꞌabꞌ qꞌu txayol kꞌuxh antich tixoꞌl kabꞌlaal qꞌu chusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Uncheeꞌ xamtich tek tiꞌ qꞌu kam tzaꞌ, taꞌxh nichpaalku u Jesuus tikuenta Galilea. Yeꞌ nichisaꞌa bꞌenchil tu Judea tan, nichiꞌan ikꞌuꞌl qꞌu qꞌesal uqꞌaybꞌal tu Israeel tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Utz nichtekinajabꞌ vinimla qꞌii qꞌu Israeel tetz Qꞌu Pel Pach. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Utz alax tu u Jesuus tu qꞌul itzaꞌqꞌ ech tzaꞌ: —Elenbꞌen tzaꞌ. Kuxh tu Judea. Ech satil qꞌu niman eetz qꞌu kam naꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tan yeꞌxhabꞌil maꞌj nibꞌanon aas tu tzꞌitzꞌoꞌn koꞌn siꞌanvu qꞌu mamaj kam oj aꞌ isaꞌ sapax itziiul. Pek kꞌuch tu kajay qꞌu aanima tu u vatz txꞌavaꞌ tzaꞌ qꞌu kam naꞌaneꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tan nikoꞌxh qꞌul itzaꞌqꞌ nichkojniman. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Uncheeꞌ tal tek u Jesuus te ech tzaꞌ: —Yeꞌsaj topon u tiempo vaꞌl qꞌatel tiꞌ aas ech sunbꞌaneꞌ. Pek aatz ex tan, bꞌenamen koꞌxh atil etiempo utz, saveeti kam sebꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tan yeꞌxhkam nichiꞌkꞌulaꞌex qꞌu aanima tu u vatz txꞌavaꞌ tzaꞌ. Pek nichiꞌkꞌulaꞌin. Tan nival te aas yeꞌxtxoj qꞌul ibꞌanoneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ech bꞌenojex tu u nimla qꞌii tziꞌ. Pek aatz in, yeꞌsaj sabꞌenin. Tan yeꞌsaj topon u tiempo qꞌatel tiꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Utz ech chit iꞌana vaꞌl tala, kaaka tu Galilea. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pek aatz maꞌtich ibꞌen qꞌul itzaꞌqꞌ tu u nimla qꞌii tu Jerusaleen, bꞌen tek u Jesuus majte. Loqꞌ yeꞌt pax itziiul. Ijutzi koꞌn bꞌenchil. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Utz nichichokax tu qꞌu qꞌesal uqꞌaybꞌal tu u nimla qꞌii. Nichmotxtal ech tzaꞌ: —¿Keꞌch vaꞌl atziꞌ?— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Utz kaanaich iyolax xoꞌl u mam tenam. Atia nichalon: —Bꞌaꞌn.— Chu tiꞌ. Utz at nichalon majte: —Yeꞌka, yitꞌ bꞌaꞌn koj. Tan niteesa qꞌu aanima tu bꞌey.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pek yeꞌxhabꞌil maꞌj nichalon eluꞌl inujul vatzsaj. Tan nichixoꞌva qꞌu qꞌesal uqꞌaybꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pek opon u Jesuus tu viqꞌanalil u totztioxh aꞌ chit inikꞌat u nimla qꞌii. Utz xeꞌt ichusuneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Utz motx tzꞌejx ikꞌuꞌl qꞌu qꞌesal uqꞌaybꞌal taqꞌo. Nichtal tiꞌ ech tzaꞌ: —¿Kam tek ech tootzajit sibꞌal kam vaꞌl tziꞌ utz, yeꞌt ichus uꞌ?— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Utz tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Aatz u chusbꞌal nivaqꞌeꞌ tzaꞌ, yitꞌ vetz koj. Pek tetz vaꞌl vetchajonkꞌasuꞌlin. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ech oj abꞌil maꞌj nojchit nitachva ibꞌanax vitxumbꞌal u Tioxh, toj paaloj itxumbꞌal tuul atziꞌ tetz tzik Tioxh u chusbꞌal nivaqꞌeꞌ tzaꞌ, oj vetz koꞌxh sunjunal. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Tan abꞌil aꞌ anat koꞌxh niyolonku jeꞌ tiꞌ, aꞌ isaꞌ soꞌok iqꞌii. Pek abꞌil vaꞌl aꞌ nioksan iqꞌii vaꞌl vetchajon ul, aꞌ vaꞌl inujul nitaleꞌ atziꞌ. Utz yeꞌk subꞌuꞌm kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Utz aqꞌel u oꞌtla mantaar sete tu u Moisees. Pek nikoꞌxh maꞌj sete niniman u mantaar tziꞌ tan, nebꞌan ekꞌuꞌl tiꞌ unyatzꞌpeꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Tzaqꞌbꞌu qꞌu mam tenam ech tal tzaꞌ: —Txꞌiꞌliꞌinaj atil sakꞌatza tan, yeꞌxhabꞌil niitzꞌan ayatzꞌpeꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Tzaqꞌbꞌu u Jesuus utz, tal ech tzaꞌ: —Maꞌl koꞌxh txaichil vetunbꞌan sevatz utz, niꞌxhitzꞌejx ekꞌuꞌl taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Netzokꞌeꞌl bꞌiil ichiꞌl qꞌu talaj xiak kꞌuxh tu ilanbꞌal qꞌii tan, u Moisees aqꞌon u mantaar sete tiꞌ itzokꞌax el bꞌiil chiꞌl. Pek yitꞌ tiꞌ koj aas chee koꞌn kꞌuꞌl u Moisees, pek ikꞌul koꞌn tetz kꞌatz qꞌul ekꞌuy emam. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Echaꞌ nebꞌaneꞌ, kꞌuxh tu ilanbꞌal qꞌii, netzokꞌeꞌl bꞌiil chiꞌl. Tan aꞌ nexoꞌva iqelax vimantaar u Moisees tiꞌ itzokꞌax el bꞌiil chiꞌl. Nebꞌaneꞌ kꞌuxh tu ilanbꞌal qꞌii. Pek ¿kantuꞌ uncheeꞌ nilakp eviꞌ viꞌ tan, unbꞌaꞌnixsa maꞌl u vinaj tu u ilanbꞌal qꞌii? ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Yeꞌ koꞌxh etal yeꞌxtxoj tiꞌ qꞌu kam tu koꞌxh vesajitaꞌ. Pek tuchꞌ chit ijikomal utz, tinujul setil qꞌu kam.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ech nichtal unjolol qꞌu aa Jerusaleen tiꞌ ech tzaꞌ: —¿Yitꞌ tzik aꞌ vaꞌl nichokleꞌ tziꞌ, sayatzꞌaxi? ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pek sajitaj etileꞌ. Vatz tenam niyoloneꞌ utz, yeꞌxhkam maꞌj nitalax te. ¿Matz vetchittootzajil qꞌu qꞌesal uqꞌaybꞌal bꞌaꞌnil aas nojchit aꞌ viTxaaom u Tioxh? ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Tan qootzajle atziꞌ til aanimail. Pek aatz luꞌul u nojla iTxaaom u Tioxh, yeꞌxhabꞌil koꞌxh soꞌootzajin til sakꞌaskuꞌl.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Nichichusun u Jesuus tu viqꞌanalil u totztioxh. Utz jeꞌ iviꞌ tu yol tal ech tzaꞌ: —Aatz ex, etootzajin utz, etootzaj til atilkꞌin. Utz maꞌkoꞌnkoxhtaqꞌen vul sunjunal. Pek yeꞌ etootzaj vaꞌl vetchajonin. Ayaꞌ vinujul. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Pek ech koj in tan, vootzajle. Aꞌ vetkꞌaskuꞌlin tzixeꞌ utz, aꞌ vetchajonin.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ech nichtekmotxiꞌan ikꞌuꞌl tiꞌ itxaypeꞌ. Loqꞌ yeꞌxhabꞌil maꞌj ok iqꞌabꞌ tiꞌ tan, yeꞌsaj topon u tiempo. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Utz sibꞌal aanima xoꞌl u mam tenam, motx niman. Utz nichtal ech tzaꞌ: —Aatz luꞌul viTxaaom u Tioxh, ¿paalchu paj qꞌu xheenya siꞌan vatz u vinaj tziꞌ tzik?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Uncheeꞌ tabꞌi qꞌu fariseo aas nichiyolon u mam tenam tiꞌ u Jesuus. Ech motx tek ichaj bꞌen txayol tetz u Jesuus. Ant imol qꞌu qꞌesal oksan yol vatz Tioxh iꞌana. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Utz tal u Jesuus ech tzaꞌ: —Saꞌatin bꞌiit tiempo in texoꞌl, ech nal saqꞌaavbꞌenin xeꞌ vaꞌl vetchajonulin. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Utz saꞌnalechokꞌin. Loqꞌ saꞌkojechabꞌaꞌin. Tan saꞌkojveet etopon tu vaꞌl saꞌatinkꞌin.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Uncheeꞌ tal tek qꞌu qꞌesal uqꞌaybꞌal xoꞌl qꞌu Israeel tibꞌilaj ech tzaꞌ: —¿Til seꞌenku vaꞌl tziꞌ nitaleꞌ aas yeꞌk sakuchabꞌa? Kamal sabꞌen xoꞌl qꞌu Israeel qꞌuꞌl paximal bꞌen tibꞌ xoꞌl griego. Utz ¿kamal sichus qꞌu griego? ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Kam tok vaꞌl vettala tziꞌ? aas: «Sechokꞌin utz, saꞌkojechabꞌaꞌin. Saꞌkojveet etopon tu vaꞌl saꞌatinkꞌin.» Chia.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Uncheeꞌ aatz iꞌan tu u yaꞌtebꞌal qꞌii tetz u nimla qꞌii, vaꞌl tiira chiꞌbꞌebꞌal siatz, txakeꞌ u Jesuus utz, qetun taltu ech tzaꞌ: —Abꞌil nitzaj itziꞌ, ¡uloj sunkꞌatza utz, ukꞌaꞌoj! ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Abꞌil ninimanin, ech siꞌaneꞌ vaꞌl nital u Yolbꞌal Tioxh aas: «Itzꞌlich nimaꞌ sayuqꞌpu tu taanima.» Chia.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Utz aꞌ tal u Tioxhla Espiiritu vaꞌl sikꞌul qꞌuꞌl saniman aas tal ech tziꞌ. Tan yeꞌsajich tul u Tioxhla Espiiritu. Axhibꞌi yeꞌsajich titzꞌpixsal u Jesuus tikaꞌpaj utz, yeꞌsaj ibꞌenjeꞌ tu Amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Uncheeꞌ aatz tek unjolol aanima xoꞌl u mam tenam, taꞌxh tabꞌi qꞌu yol tziꞌ, tal tek ech tzaꞌ: —Nojchit aꞌ u alol tetz u yolbꞌal Tioxh vaꞌl sauli atziꞌ.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Utz at nichalon: —Aꞌ viTxaaom u Tioxh atziꞌ.— Chia. Pek at nichalon majte: —¿Aꞌ tzik sakꞌaskuꞌl viTxaaom u Tioxh tu Galilea? ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tan nital u Yolbꞌal Tioxh tzꞌibꞌamalka aas aꞌ sacheek vituꞌxh ixalam u Daviid tu tenam Beleen vaꞌl atichku u Daviid. Aꞌ sakꞌaskuꞌl viTxaaom u Tioxh tziꞌ.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Uncheeꞌ ok tek ixoꞌl qꞌu tenam tiꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Utz atich unjolol nichitzꞌan itxaypeꞌ. Loqꞌ yeꞌxhabꞌil ok iqꞌabꞌ tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Uncheeꞌ aatz qꞌuꞌl chajax tiꞌ itxaypeꞌ, qꞌaavopon xeꞌ qꞌu qꞌesal oksan yol vatz Tioxh tuchꞌ qꞌu fariseo. Utz abꞌil te ech tzaꞌ: —¿Kantuꞌ yeꞌn etiqꞌo ul?— Texh teꞌleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Tzaqꞌbꞌu qꞌuꞌl siꞌchtxayon ech tzaꞌ: —¡Yeꞌk maꞌj vinaj aas ech koj iyoloneꞌ u vinaj tziꞌ!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tzaqꞌbꞌu qꞌu fariseo ech tzaꞌ: —Utz ¿ant ex vetteesalex tu bꞌey tzik? ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Tan ¿tzꞌoj tzik abꞌiste maꞌj qꞌu qꞌesal uqꞌaybꞌal niniman, nikoꞌxh qꞌu fariseo? ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pek kam itxaꞌk qꞌu aanima qꞌuꞌl yeꞌ ootzajin tetz u mantaar. Kam tootzaj. ¡Kuꞌnaj tzꞌejbꞌal yol tiꞌ!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Uncheeꞌ aatz maꞌl tu qꞌul imol, ayaꞌ u Nicodemo vaꞌl opon xeꞌ u Jesuus tu aqꞌbꞌal, tal ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Yeꞌxhkam nital u mantaar aas sakoꞌxhtxayax maꞌj aanima oj yeꞌsajen ichꞌotil itziꞌ utz, satootzaji kam maꞌt iꞌantaꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Tzaqꞌbꞌeli. Alax te ech tzaꞌ: —¿Kamal axh aa Galilea? Pek ¡chok inujul iileꞌ utz, siileꞌ aas yeꞌk maꞌj alol tetz u yolbꞌal Tioxh cheenaj koj tziꞌ!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ech junun texh kꞌasuꞌl. Motx bꞌen tu tatibꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pek aatz u Jesuus, bꞌen viꞌ u muunte Olivo. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Utz tu tek vaꞌt qꞌii, qꞌaavuꞌl tu viqꞌanalil u totztioxh qꞌalaꞌm. Utz mam tenam ul kꞌatza. Ech kꞌujeꞌ u Jesuus; xeꞌt ichusuneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ech aatz qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar tuchꞌ qꞌu fariseo, motx tiqꞌo ul maꞌl u ixoj siatz. Aꞌ motx ichabꞌav tiꞌ teesat tibꞌ tu bꞌey tuchꞌ vinaj yitꞌ ikꞌulel koj. Utz ech toksa tu xoꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Motx tal te ech tzaꞌ: —Chusul, aatz u ixoj tziꞌ, niteesa tibꞌ tu bꞌey tuchꞌ vinaj yitꞌ ikꞌulel koj tuul vetchabꞌali. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Utz aatz tu u oꞌtla mantaar alelka tu u Moisees tan, sapaqꞌax sivan qꞌu ixoj qꞌuꞌl ech niꞌan tziꞌ. Pek ¿aatz axh, kam saaleꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Loqꞌ vet sikꞌuꞌl motx iꞌana. Kꞌuxh motx tal ech tziꞌ, aꞌ isaꞌ sacheei kaniꞌch ixochax u Jesuus siꞌaneꞌ. Pek aatz u Jesuus tan, taqꞌ koꞌn kuꞌ ivatz, tzꞌibꞌan kuꞌ vatz txꞌavaꞌ tu viꞌ iqꞌabꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pek yeꞌxh nichmotxiyaꞌ tiꞌ ichꞌotil te. Ech iꞌan jikom tatin u Jesuus utz, tal te ech tzaꞌ: —Abꞌiste sete tiira yeꞌk ipaav, aꞌ bꞌaxal seꞌel isivan, sipaqꞌ bꞌen tiꞌ u ixoj tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ech qꞌaavkoꞌnpajkꞌoꞌeꞌ kuꞌ, tzꞌibꞌan kuꞌ vatz txꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Uncheeꞌ taꞌxh motx tabꞌi u kam qꞌu vinaj tziꞌ, junun texh motx xeꞌt itxakpu kꞌasuꞌl. Tan motx inach bꞌen aas jolol aa paav. Aꞌ bꞌaxal motx txakpu kꞌasuꞌl qꞌu qꞌes, ech tek qꞌu chꞌooaj. Ech aꞌ texh kaaka u Jesuus sijunal tuchꞌ u ixoj vaꞌl iqꞌol opon. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ech iꞌan jikom tatin u Jesuus. Utz yeꞌxhabꞌil vaꞌtoj tila. Pek aꞌ texh atich u ixoj. Utz tal te ech tzaꞌ: —Ixoj, ¿keꞌch qꞌuꞌl nixochonaxh ve? ¿Yeꞌxhabꞌil tzik vetpaqꞌon sivan axh?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tzaqꞌbꞌu u ixoj ech tzaꞌ: —Yeꞌxhabꞌil unBꞌaal.— Texh te. Tal tek u Jesuus te ech tzaꞌ: —Nikoꞌxh in saꞌkojxochonaxh. Pek kuxh utz, yeꞌ koꞌxh paavinveꞌtꞌaxh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Uncheeꞌ yolon paj u Jesuus tu qꞌu tenam ech tzaꞌ: —In u txijtxubꞌal tetz qꞌu aanima tu u vatz amlika txꞌavaꞌ tzaꞌ. Abꞌil vaꞌl xamel viꞌ, yitꞌ saꞌkojpaal tu uken. Pek saꞌatin u txijtxubꞌal kꞌatza vaꞌl tetz tiichajil tu bꞌenqꞌii bꞌensaj.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ech alax tek te tu qꞌu fariseo ech tzaꞌ: —Yitꞌ inujul koj qꞌul ayol atziꞌ. Tan axh atkoꞌxh naal jeꞌ iibꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Utz tzaqꞌbꞌu u Jesuus ech tzaꞌ: —Kꞌuxh in atkoꞌxh nival jeꞌ vibꞌ tan, inujul qꞌul unyol. Utz vootzajle til unkꞌaskuꞌlin utz, tiꞌch voponeꞌ. Pek aatz ex tan, yeꞌ etootzaj til unkꞌaskuꞌlin utz, til soꞌoponkꞌin. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Utz netxꞌol inujul qꞌu kam kam echaꞌ niꞌan qꞌu aanima. Pek aatz in, yeꞌxhabꞌil nuntxꞌol inujul. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Utz inujul nunbꞌaneꞌ oj nuntxꞌol inujul maꞌj aanima. Tan yitꞌ unjunal koꞌn koj, pek aꞌ unmol vaꞌl vetchajonkꞌasuꞌlin. Ayaꞌ vunTat. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Utz tzꞌibꞌamalka tu vemantaar aas satxꞌolax inujul u aanima nixochleꞌ oj kaꞌvaꞌl nitxakbꞌaꞌn inujul yol tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Utz aatz in, nunyolon jeꞌ viꞌ. Utz niyolon vunTat viꞌ, vaꞌl vetchajonkꞌasuꞌlin.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ech motx tzaqꞌbꞌu qꞌu vinaj ech tzaꞌ: —Utz ¿keꞌch vatat?— Texh te. Tzaqꞌbꞌu Jesuus utz, tala: —Yitꞌ etootzajkojin utz, yitꞌ etootzaj koj vunTat. Tan etootzajkojin, setootzaji vunTat majte atziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Aatz qꞌu yol tzaꞌ, aꞌ talvu u Jesuus kꞌatz u kaaxha, tatibꞌal kutxu, aas nichichusun tu viqꞌanalil u totztioxh. Utz yeꞌxhabꞌil maꞌj txayon tan, yeꞌsajich topon u tiempo. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Uncheeꞌ tal paj unpat u Jesuus ech tzaꞌ: —Sabꞌenin utz, sechokꞌin. Loqꞌ saꞌkojechabꞌaꞌin tan, aꞌ sakamkꞌex tu qꞌul epaav. Utz saꞌkojveet etopon tu vaꞌl seꞌenkꞌin.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Utz nichtektal qꞌu qꞌesal uqꞌaybꞌal xoꞌl qꞌu Israeel tiꞌ ech tzaꞌ: —Tzꞌoj tzik saꞌtekiyatzꞌ jeꞌ tibꞌ sijunal aas nitaleꞌ: «Yitꞌ saꞌkojveet etopon tu vaꞌl seꞌenkꞌin.» Chia.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Utz tal u Jesuus te ech tzaꞌ: —Aatz ex, ayeꞌnex aal ikuꞌl tu u vatz txꞌavaꞌ tzaꞌ. Pek aatz in, ayeꞌnin aal ijeꞌaꞌ. Yitꞌ ayeꞌnkojin tu u vatz txꞌavaꞌ tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Echixeꞌat vetvallu sete aas aꞌ sakamkꞌex tu qꞌul epaav. Tan oj yeꞌ senima aas abꞌil in, aꞌ samotxkamkꞌex tu qꞌul epaav.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Utz alax tek te ech tzaꞌ: —¿Abꞌil axh uncheeꞌ?— Texh teꞌleꞌ. Tal u Jesuus ech tzaꞌ: —In vaꞌl val sete bꞌaxa. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Sibꞌal koꞌxh kam saval sete. Utz sibꞌal koꞌxh kam suntxꞌolv enujul. Pek loqꞌ aꞌ nivaleꞌ kam vaꞌl vetvabꞌi kꞌatz vaꞌl vetchajonin. Tan aꞌ vinujul. Ech aꞌ vaꞌl nival tu qꞌu aanima tu u vatz amlika txꞌavaꞌ tzaꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pek yeꞌt motx el itxumbꞌal tuul aas aꞌ nichyolonku tiꞌ viTat. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Utz tal paj chit u Jesuus te ech tzaꞌ: —Aatz maꞌt ilakax jeꞌ u Kꞌaola vaꞌl bꞌennaj koꞌn aanima, anal setootzaji abꞌil in. Anal sapaal etxumbꞌal tuul aas yeꞌxhkam nunbꞌan sunjunal. Pek aꞌ nunbꞌaneꞌ kam vaꞌl vetichusvin vunTat. Aꞌ vaꞌl nivaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tan atil vunTat sunkꞌatza vaꞌl vetchajonkꞌasuꞌlin. Yeꞌxhkam nitaqꞌkaꞌin sunjunal. Tan aꞌ chit nunbꞌan vaꞌl bꞌaꞌn niꞌenku te.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Sibꞌal aanima niman tiꞌ qꞌu kam tala tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Uncheeꞌ tal tek u Jesuus tu qꞌu qꞌesal uqꞌaybꞌal xoꞌl qꞌu Israeel qꞌuꞌl maꞌtich niman ech tzaꞌ: —Nojchit ex unchusulibꞌ siꞌaneꞌ untzꞌoj sebꞌan ex niman tetz vunyolbꞌal bꞌenamen. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ech setootzaji vinujul. Utz vinujul sachitpunex tu qꞌu epaav.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Motx tzaqꞌbꞌu ech tzaꞌ: —Oꞌ ituꞌxh ixalam u Abrahaam. Utz abꞌil koj kꞌayimal ok qibꞌ jaqꞌ imantaar. Pek ¿kam tokeꞌ naaleꞌ? aas: «Sachitpꞌex.» Chaꞌaxh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Utz alax te tu u Jesuus ech tzaꞌ: —Niꞌxhtekꞌval sete aas kajay qꞌuꞌl niꞌan paav, jaqꞌ iyakꞌil u paav nikꞌayiv ok tibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Utz aatz vaꞌl kꞌayimal tibꞌ jaqꞌ mantaar sakoꞌnkoxhatinka tu atibꞌal bꞌenamen. Ech koj vikꞌaol u bꞌaal atibꞌal, bꞌaꞌntan atil tu atibꞌal bꞌenamen. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ech tokeꞌ oj aꞌ sachitpunex tu paav viKꞌaol u Tioxh, nojchit qꞌalpiꞌex atziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Vootzajle aas ex ituꞌxh ixalam Abrahaam. Pek loqꞌ nebꞌan ekꞌuꞌl tiꞌ unyatzꞌpeꞌ. Tan yeꞌxhat niokku vunyolbꞌal sete. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Tan aꞌ nivaleꞌ kam ilel kꞌatz vunTat vaqꞌo. Pek aatz ex, aꞌ nebꞌan vibꞌanon vetat.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Motx tzaqꞌbꞌi utz, tal te ech tzaꞌ: —Aꞌ kukꞌuy kumam u Abrahaam.— Texhtuꞌ. Tal u Jesuus te ech tzaꞌ: —Untzꞌoj ex ituꞌxh ixalam Abrahaam, aꞌ nebꞌan qꞌuꞌl nichiꞌan u Abrahaam koj atziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Tan yeꞌxhkam yatzꞌon u Abrahaam. Pek aatz ex, nebꞌan ekꞌuꞌl tiꞌ unyatzꞌpu tiꞌ vinujul nival sete. Ayaꞌ vaꞌl abꞌimal xeꞌ Tioxh vaqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Aꞌ neꞌnetiqꞌo vitxꞌiꞌla txumbꞌal vetat.— Texh te. Motx tal ech tzaꞌ: —¡Maꞌl koꞌn kuTat atile, ayaꞌ u Tioxh! Utz ¡yitꞌ sikꞌelkoꞌnkojoꞌ iꞌan kunan!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Tal paj u Jesuus te: —Bꞌaꞌn ex ve koj atziꞌ aas noj koj aꞌ etat u Tioxh. Tan xeꞌ Tioxh vetkꞌaskuꞌlin. Utz maꞌkoꞌnkojel tunviꞌ aas vetꞌulin, pek aꞌ vetchajonulin. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Utz ¿kam tokeꞌ yeꞌ nitel etxumbꞌal tu vaꞌl nivaleꞌ? ¿Kantuꞌ yeꞌ nekan tabꞌil qꞌul unyol? ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Tiꞌ tan, aꞌ etat u txꞌiꞌliꞌinaj. Utz aꞌ esaꞌ ibꞌanax u tachaꞌv. Tan yatzꞌol nal tixeꞌtebꞌal. Utz yitꞌ atil koj tu vinujul. Keꞌch koj vinujul tzixeꞌ. Aatz nital txubꞌaꞌl, taꞌxh nital eluꞌl tibꞌ. Tan txubꞌaꞌlom utz, itat qꞌu txubꞌaꞌlom. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pek yeꞌ nenimaꞌin kꞌuxh aꞌ nival vinujul. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Kantuꞌ yeꞌ nimotxenimaꞌin? Tan inujul nival sete. Pek oj atil maꞌj texoꞌl sataleꞌ kam unpaav, taleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tan abꞌil vaꞌl tetz Tioxh, aꞌ nitabꞌi u yol tetz u Tioxh. Pek aatz ex, yeꞌ netabꞌi tan, yitꞌ ex koj tetz Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Uncheeꞌ tzaqꞌbꞌu qꞌu qꞌesal uqꞌaybꞌal xoꞌl qꞌu Israeel ech tzaꞌ: —Nojchit inujul vaꞌl niqaleꞌ. Atil tioxhil txꞌiꞌliꞌinaj sakꞌatza. Utz axh aa Samaaria majte.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Utz tzaqꞌbꞌu u Jesuus ech tzaꞌ: —Yeꞌk tioxhil txꞌiꞌliꞌinaj sunkꞌatza. Tan aꞌ nivoksa iqꞌii vunTat. Pek aatz ex, neteesa unqꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Loqꞌ yitꞌ aꞌ koj nivoksa jeꞌ unqꞌii. Pek atil maꞌl vaꞌl aꞌ isaꞌ soꞌok iqꞌii. Ayaꞌ u txꞌolol tetz inujul qꞌu kam. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Niꞌxhtekꞌval sete aas jatu koj sakami abꞌil vaꞌl saniman qꞌul unyol.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","53","Utz tzaqꞌbꞌel tu qꞌu qꞌesal uqꞌaybꞌal xoꞌl qꞌu Israeel ech tzaꞌ: —Vetqootzajil cheel aas atoꞌk tioxhil txꞌiꞌliꞌinaj sakꞌatza. Tan naaleꞌ aas: «Abꞌil saniman vunyolbꞌal jatu koj sakami.» Chaꞌaxh. Utz kamnaj u Abrahaam. Kamnaj tek qꞌu oꞌtla alol tetz u yolbꞌal Tioxh majte. ¿Tzꞌoj tzik paalchꞌaxh vatz u kukꞌuy kumam Abrahaam vaꞌl kamnaj tekuꞌen? Pek ¿abꞌil axh nanache?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Tzaqꞌbꞌu u Jesuus tal ech tzaꞌ: —Oj nivoksa jeꞌ unqꞌii sunjunal, yeꞌk itxaꞌk u tokebꞌal unqꞌii atziꞌ. Pek aꞌ nioksan unqꞌii vunTat vaꞌl eTioxh netaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Loqꞌ yeꞌ etootzaj. Pek vootzajle. Utz in tek txubꞌaꞌlom atziꞌ echaꞌ ex tziꞌ aas oj: «Yeꞌ vootzaj.» Chikojin. Pek vootzajle tan, nunnima qꞌul iyol. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Aatz vekꞌuy emam u Abrahaam, txuqꞌtxun tiꞌ ichꞌial u vul tu u vatz unqꞌii unsaj. Utz aal chit txuqꞌtxuni aas tila.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Tal paj qꞌu qꞌesal uqꞌaybꞌal tu u Jesuus ech tzaꞌ: —¿Kaniꞌch iiltu u Abrahaam? Tan aal yeꞌsaj tel 50 ayaꞌbꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Utz tal u Jesuus te ech tzaꞌ: —Niꞌxhtekꞌval sete, atichnalin aas yeꞌsajich titzꞌpu u Abrahaam.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ech motx itxaytu sivan qꞌu vinaj tziꞌ. Siꞌchmotxipaqꞌ bꞌen tiꞌ. Pek aatz u Jesuus, isotzsa tibꞌ tixoꞌl. Elkꞌasuꞌl tu viqꞌanalil u totztioxh. Taꞌn aꞌ paaleluꞌl tixoꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Uncheeꞌ aatz nichipaal u Jesuus, til maꞌl u vinaj moy tu titzꞌebꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ech chꞌotil tek tu u Jesuus tu qꞌul ichusulibꞌ ech tzaꞌ: —Chusul, ¿abꞌil etz paav aas moy u vinaj tziꞌ; qꞌul itxutx ibꞌaal tzik, pek oj ipaav atkoꞌxhtuꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Tzaqꞌbꞌu u Jesuus utz, tala: —Yitꞌ tiꞌ koj ipaav u vinaj tziꞌ, kꞌuxh moy. Nikoꞌxh ipaav koj qꞌul itxutx ibꞌaal. Pek tiꞌ sailax u tokebꞌal iqꞌii u Tioxh kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ech ministeer sunbꞌan u taqꞌon vunTat vaꞌl vetchajonulin tuul atil qꞌii saj. Tan tul u aqꞌbꞌal utz, yeꞌxhabꞌil veꞌt saveet taqꞌonineꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Utz in u txijtxubꞌal tetz qꞌu aanima tu u vatz amlika txꞌavaꞌ tzaꞌ, tuul atilin tixoꞌl.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ech taꞌxh tal u kam tzaꞌ, tzubꞌan kuꞌ vatz txꞌavaꞌ. Iꞌan tal xoqꞌol tu vitzubꞌ. Utz toksa tu bꞌaqꞌ iatz u moy. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Utz tal te ech tzaꞌ: —Kuxh txꞌaa vavatz tu u molbꞌal aꞌ Siloee.— Texh te. Aatz u Siloee, aꞌ tokeꞌ “chaj el”. Ech ibꞌenaꞌ. Ex itxꞌaa vivatz. Utz nichtektiloneꞌ aas qꞌaavi. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ech aatz qꞌu tetz tzꞌalol u vinaj tuchꞌ qꞌuꞌl nichilon aas nojchit moyich, nichmotxtal ech tzaꞌ: —¿Yitꞌ tzik aꞌ u vinaj tziꞌ vaꞌl nichikꞌujeꞌ tiꞌ ijoyax tetz?— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","At unjote nichalon: —Aꞌ i atziꞌ.— Chia. Utz at nichalon: —Ech aꞌ i tiloneꞌ.— Chia. Pek nichtal u vinaj ech tzaꞌ: —¡In chituꞌ!— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Utz chꞌotil tek te ech tzaꞌ: —¿Kaniꞌch misajin qꞌu bꞌaqꞌ aatz tziꞌ?— Texh teꞌleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tzaqꞌbꞌu u vinaj utz, tala: —Nitekviloneꞌ tan, aatz u vinaj vaꞌl Jesuus ibꞌii, vetiꞌan xoqꞌol. Vettoksa tu bꞌaqꞌ unvatz. Utz vettal ve ech tzaꞌ: «Kuxh tu u molbꞌal aꞌ Siloee. Utz txꞌaa avatz tziꞌ.» Texh ve. Ech bꞌenin. Untxꞌaa. Utz anchituꞌ, ¡ilontekꞌin!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Utz alax te ech tzaꞌ: —Keꞌch u vinaj naaleꞌ tziꞌ.— Texh teꞌleꞌ. Tal ech tzaꞌ: —Yeꞌ vootzaj.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ech iqꞌol bꞌen u vinaj vaꞌl moyich vatz qꞌu fariseo. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Utz tuich ilanbꞌal qꞌii iꞌan u xoqꞌol u Jesuus tziꞌ utz, isajinsa vivatz u vinaj. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ech chꞌotil paj te tu qꞌu fariseo aas kaniꞌch iꞌantu bꞌaꞌn vivatz. Utz tal u vinaj vaꞌl moyich ech tzaꞌ: —Toksa xoqꞌol tunvatz utz, untxꞌaa el. Ech nitekvilon cheel.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Uncheeꞌ tal tek unjolol qꞌu fariseo ech tzaꞌ: —Yitꞌ xeꞌ Tioxh koj vetkꞌaskuꞌl u vinaj atziꞌ tan, niqel u ilanbꞌal qꞌii.— Chia. Utz at nichalon majte: —Kaniꞌch koj iꞌantu txaichil maꞌj vinaj oj aa paav.— Texhtuꞌ. Ech ok ixoꞌl qꞌu fariseo tibꞌilaj. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Utz qꞌaav paj chꞌotil tu u vinaj vaꞌl moyich ech tzaꞌ: —¿Kam bꞌoj naal tiꞌ vaꞌl vetjajpixsan qꞌu bꞌaqꞌ aatz tziꞌ?— Texh te. Tal u vinaj ech tzaꞌ: —Alol tetz u yolbꞌal Tioxh atziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Loqꞌ yeꞌxhkam nichmotxinima qꞌu qꞌesal uqꞌaybꞌal aas oj moyich. Utz yeꞌxhkam nichmotxinima oj sajinsal ivatz. Pek anal inima aas isavsa qꞌul itxutx ibꞌaal u vinaj vaꞌl maꞌtich ijajpixsal iatz. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Tan ichꞌoti tu qꞌul itxutx ibꞌaal ech tzaꞌ: —¿Aꞌ tzik vetitzꞌin tziꞌ vaꞌl moyich aas itzꞌpi netaleꞌ? Utz ¿kam tokeꞌ aas nitektilon cheel?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tzaqꞌbꞌu qꞌul itxutx ibꞌaal, tal ech tzaꞌ: —Qootzajle aas aꞌ u qitzꞌin tziꞌ utz, moyich aas titzꞌpeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pek yeꞌ qootzaj kam tokeꞌ nitektilon cheel. Utz yeꞌ qootzaj majte abꞌil vetsajinsan vivatz tziꞌ. Chꞌotitaj te tan, atil tek iyaꞌbꞌ atziꞌ; sayolon sijunal.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ech koꞌn motx tal qꞌul itxutx ibꞌaal tziꞌ tan, aꞌ nichmotxixoꞌva qꞌu qꞌesal uqꞌaybꞌal. Tan maꞌtich motx taqꞌtu kuꞌ tibꞌeyil qꞌu qꞌesala tziꞌ aas abꞌil saꞌalon aas aꞌ viTxaaom u Tioxh u Jesuus, tiira sayaꞌsal topon tu atibꞌal chusbꞌal tetz u oꞌtla mantaar. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Echixeꞌat tal qꞌul itxutx ibꞌaal aas: —Atil tek iyaꞌbꞌ atziꞌ; chꞌotitaj te.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Uncheeꞌ qꞌaav sikꞌlel opon u vinaj vaꞌl moyich. Utz tal te ech tzaꞌ: —Vatz Tioxh saal vinujul qe. Tan qootzajle aas aa paav u vinaj tziꞌ.— Texh teꞌleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tzaqꞌbꞌu u vinaj utz, tala: —Yeꞌ vootzaj oj aa paav. Pek taꞌxh maꞌl kam vootzaj. ¡Inich moy, pek aatz cheel, nitekviloneꞌ!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Utz qꞌaav paj alax te ech tzaꞌ: —¿Kam vetiꞌan see? ¿Kaniꞌch misajinsat vavatz?— Texh teꞌleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Itzaqꞌbꞌe ech tzaꞌ: —Vetvallu sete utz, yeꞌ koꞌn esaꞌ tabꞌileꞌ. Pek ¿kantuꞌ aas nipajechꞌoti unpate? ¿Oj sesaꞌa sabꞌenex niman tetz majte?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ech motx koꞌn teesal iqꞌii. Utz motx tal te ech tzaꞌ: —Axh niman tetz majte atziꞌ. Pek aatz oꞌ, oꞌ niman tetz u Moisees. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tan qootzajle aas yolon u Tioxh tiꞌ u Moisees. Pek ech koj u vinaj tziꞌ tan, yeꞌ qootzaj til unkꞌaskuꞌl.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tzaqꞌbꞌu u vinaj utz, tala: —Aꞌ u kam tzꞌejxebꞌal kꞌuꞌl tziꞌ yoꞌo, aas yeꞌ etootzaj til unkꞌaskuꞌl loqꞌ vetijajpixsa vunvatz. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Utz qootzajle aas yitꞌix abꞌil qꞌu aa paav tu u Tioxh. Pek bꞌaꞌntan aꞌ nitabꞌi abꞌil nixoꞌvan utz, niꞌan vitxumbꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Yeꞌxhjatu abꞌimal talaxeꞌ aas nijajpixsal ivatz maꞌj aanima aas moy tu titzꞌpebꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Utz kam koj sitxꞌol iveet u vinaj tziꞌ, oj yitꞌ xeꞌ Tioxh koj nikꞌaskuꞌl.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ech tzaqꞌbꞌeli utz, alax te ech tzaꞌ: —Tiira aꞌ itzꞌpinajkꞌaxh tu paav utz, ¿sachusoꞌ naal tzik?— Texh te. Ech tojchal kꞌasuꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Uncheeꞌ tabꞌi tek u Jesuus aas maꞌtich tojchal kꞌasuꞌl tziꞌ. Utz aatz tila, tal te ech tzaꞌ: —¿Ni tzik anima viKꞌaol u Tioxh?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tzaqꞌbꞌi utz, tal ech tzaꞌ: —¿Abꞌil viKꞌaol u Tioxh unBꞌaal? ech sunnima.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Tal u Jesuus te: —Vetiillaꞌ. Ayaꞌ vaꞌl niyolon sauchꞌ tzaꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tal u vinaj ech tzaꞌ: —Nunnima unBꞌaal.— Texhtuꞌ. Ech toksat iqꞌii u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Tal u Jesuus te ech tzaꞌ: —Kꞌuxh vetꞌulin tu u vatz amlika txꞌavaꞌ tzaꞌ, aꞌ ul untxꞌol inujul qꞌu kam. Ech abꞌiste qꞌuꞌl yeꞌ nitiloneꞌ, sailoni. Utz aatz qꞌuꞌl nitiloneꞌ, sabꞌens echaꞌ moy.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ech aatz unjolol qꞌu fariseo qꞌuꞌl atich kꞌatza, taꞌxh tabꞌi u kam tzaꞌ, tal te ech tzaꞌ: —¿Tzꞌoj tzik oꞌ moy majte?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Ex koj moy, yeꞌk epaav koj atziꞌ. Pek aatz ex tan: «Niqiloneꞌ.» Cheꞌex. Echixeꞌat atilex tu qꞌul epaav.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Uncheeꞌ tal paj u Jesuus ech tzaꞌ: —Niꞌxhtekꞌval sete, abꞌil aꞌ yitꞌ aꞌ koj niokkoꞌp tu u okebꞌalop tu u tatibꞌal qꞌu karneꞌl, elqꞌom atziꞌ. Subꞌul atziꞌ. Tan paarten nichokvu tokoꞌp. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Tan aꞌ u xeen tetz qꞌu karneꞌl vaꞌl aꞌ niokkoꞌp tu u okebꞌalop. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ech nijajax okoꞌp tu u taqꞌonom. Utz ootzajimal iviꞌ u xeen karneꞌl tu qꞌul ikarneꞌl majte. Tan nisikꞌle qꞌu karneꞌl tibꞌii utz, nitiqꞌo eluꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Utz aatz maꞌt tiqꞌot eluꞌl kajay qꞌu tetz, nibꞌaxabꞌ siatz. Utz nixambꞌoꞌk qꞌu karneꞌl tiꞌ. Tan tootzaj iviꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Tan saꞌkojxambꞌoꞌk qꞌu karneꞌl tiꞌ vaꞌt aanima. Pek aal satꞌaspu siatz. Tan yeꞌ tootzaj iviꞌ paartenla aanima qꞌu karneꞌl.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Aꞌ qꞌu kꞌamich yol tal u Jesuus tziꞌ. Loqꞌ yeꞌt paal itxumbꞌal qꞌu aanima tuul kam vaꞌl nichtal te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Uncheeꞌ tal paj u Jesuus te: —Niꞌxhtekꞌval sete aas in u tokebꞌalop qꞌu karneꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Utz jolol elqꞌom qꞌuꞌl bꞌaxal ul sunvatz; subꞌul atziꞌ. Utz yeꞌt motx nimal tu qꞌu karneꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","In u okebꞌalop. Ech abꞌil vaꞌl sapaaloꞌk tuul, sakolaxi. Echaꞌ karneꞌl soꞌokoꞌp saeluꞌl utz, sichabꞌa titza taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Aatz nitul u elqꞌom, elaqꞌ, yatzꞌoꞌm utz, yuchꞌuꞌm ul iꞌaneꞌ. Pek aatz in, vetꞌulin tiꞌ taqꞌax etiichajil. Ech tiira yeꞌk iyaꞌebꞌal vetatin siꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","In u bꞌaꞌnla xeen karneꞌl. Tan aatz u bꞌaꞌnla xeen karneꞌl, nitaqꞌ tibꞌ sakam tiꞌ qꞌul ikarneꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pek aatz vaꞌl aqꞌonom kuꞌen taꞌxh nitiloꞌk vijaꞌmel, nitꞌaspeꞌ nitil tul u lobo. Nitaqꞌka qꞌu karneꞌl tan, yitꞌ ibꞌaal koj. Ech aatz u lobo, niqini eluꞌl qꞌu karneꞌl. Utz nitilun ibꞌen tereꞌn taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nitooj u lochol xeen karneꞌl. Tan axhibꞌi vijaꞌmel koꞌn nitiloꞌk. Yeꞌxh koꞌxh kam itxaꞌk qꞌu karneꞌl te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","In u bꞌaꞌnla xeen karneꞌl. Utz kam echaꞌ tootzajitꞌin vunTat, echat vootzajit vunTat majte. Utz kam echaꞌ vootzajit vunTat, echat vootzajit qꞌul unkarneꞌl majte. Utz tootzajin. Tan savaqꞌ vibꞌ tu kamchil tiꞌ qꞌu karneꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Utz atil unjot unkarneꞌl aas paarten atilka. Yitꞌ atil koj xoꞌl qꞌu vetz tzaꞌ. Loqꞌ saꞌnalimolo tibꞌ sunkꞌatza. Satabꞌi vunviꞌ atziꞌ. Ech untanul tekoꞌn karneꞌl saꞌatini. Utz maꞌl koꞌn xeen tetz saꞌatini. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ech tokeꞌ tii vunTat viꞌ. Tan savaqꞌ vibꞌ tu kamchil. Loqꞌ saqꞌaavitzꞌpꞌin. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Jik chit in savaqꞌ vibꞌ tu kamchil. Tan yeꞌxhabꞌil soꞌoleꞌ tiꞌ tel u vatz unqꞌii unsaj. Pek atil tunqꞌabꞌ savaqꞌ vibꞌ tu kamchil utz, atil tunqꞌabꞌ saqꞌaavitzꞌpꞌin. Aꞌ u vijleꞌm unkꞌul xeꞌ vunTat tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ech qꞌaavpajok ixoꞌl qꞌu qꞌesal uqꞌaybꞌal tu qꞌu yol tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Tan sibꞌal nichalon tiꞌ ech tzaꞌ: —Txꞌiꞌliꞌinaj atoꞌk kꞌatza. Elnaj tu bꞌey atziꞌ. ¿Kantuꞌ netabꞌi ok?— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Utz at unjot nichalon ech tzaꞌ: —¿Abꞌil sayolon ech tziꞌ oj atoꞌk tioxhil txꞌiꞌliꞌinaj kꞌatza? Utz saꞌkojoleꞌ tioxhil txꞌiꞌliꞌinaj sijajpixsa ivatz maꞌj moy.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Uncheeꞌ aatz titiempoich cheꞌv, nichipaasal u nimla qꞌii tu Jerusaleen tetz u totztioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Utz nichipaal u Jesuus tu viqꞌanalil u totztioxh vatz u okebꞌal vaꞌl Salomoon. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ech sutil tiꞌ tu qꞌu qꞌesal uqꞌaybꞌal utz, tal te ech tzaꞌ: —¿Jatu tek sayaꞌ kukaꞌtziiun saaqꞌo? Untzꞌoj axh viTxaaom u Tioxh, al inujul qe; vatzsaj saaleꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Vetvallu sete abꞌil in. Utz yeꞌ nenima. Tan aatz qꞌu kam nunbꞌan tibꞌii vunTat, aꞌ techlal abꞌil in. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pek yeꞌ nenima. Kꞌuxh alel nal sete vaqꞌo. Axhibꞌi antu koj ex xoꞌl qꞌul unkarneꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Tan nitabꞌi unviꞌ qꞌul unkarneꞌl. Utz jolol vootzajle majte. Ech nixambꞌu viꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Utz savaqꞌ itiichajil tu bꞌenqꞌii bꞌensaj. Ech jatu koj samotxsotzi. Utz abꞌil koj saeesan tunqꞌabꞌ majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tan aatz vunTat vaꞌl vetaqꞌon ve, paalchu vatz u koontra. Ech yeꞌxhabꞌil koꞌxh samaaon el tiqꞌabꞌ vunTat. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Aatz in tuchꞌ vunTat, maꞌl koꞌn oꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Uncheeꞌ motx itxay isivan qꞌu qꞌesal uqꞌaybꞌal; siꞌchipaqꞌoꞌk tiꞌ tala. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Loqꞌ tal Jesuus te ech tzaꞌ: —Sibꞌal bꞌaꞌnla chaj kam tetz vunTat vetunbꞌanlu sevatz. Pek ¿abꞌiste tiꞌ sepaqꞌvu sivan in?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Utz tzaqꞌbꞌu qꞌu qꞌesal uqꞌaybꞌal ech tzaꞌ: —Saꞌkojkupaqꞌ sivan axh tiꞌ bꞌaꞌnla kam, pek tiꞌ vayoqꞌoneꞌ. Tan axh koꞌn vinaj utz, naaqꞌ bꞌen iibꞌs Tioxh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Tzꞌibꞌamalka tu vemantaar ech tzaꞌ: «Alel sete vaqꞌo aas jolol tioxh etatin vaqꞌo.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","36","Utz oj: «Tioxh tatineꞌ.» Chu u Tioxh tiꞌ qꞌu aanima, tiꞌ vitenam qꞌuꞌl kꞌulun viyolbꞌal, uncheeꞌ ¿kam tatin vatz u Tioxh u Vinaj nenacheꞌ vaꞌl iTxaaom u Tioxh, ichajuꞌl tu u vatz amlika txꞌavaꞌ tzaꞌ? ¿Kantuꞌ yeꞌk tatin sevatz? Nikoꞌneteesa iqꞌii. Netal tiꞌ aas: «Niyoqꞌ Tioxh.» Cheꞌex. Tiꞌ tan, nivaleꞌ aas: «In viKꞌaol u Tioxh.» Chiꞌin. Utz aal ex qꞌuꞌl niqelon u Yolbꞌal Tioxh kꞌuxh nenima netaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Aal bꞌaꞌn yeꞌ senimaꞌin oj yeꞌxhkam nunbꞌan qꞌu txaichil qꞌuꞌl nital vunTat. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pek kꞌuxh yeꞌ senimaꞌin, nimataj aas atil vunTat sunkꞌatza utz, atilin kꞌatz vunTat tiꞌ qꞌu kam qꞌuꞌl nunbꞌaneꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ech siꞌchpajmotxitxayeꞌ tala, pek el u Jesuus siatz. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ech bꞌen u Jesuus sala bꞌen u Jordaan tu vaꞌl nichiꞌanvu vautisaar aanima u Xhan bꞌaxa. Utz atin tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Utz sibꞌal aanima nichtul tzixeꞌ. Nichtal ech tzaꞌ: —Kꞌuxh yeꞌxh maꞌj txaichil iꞌan u Xhan, nojchit inujul qꞌu kam tal tiꞌ u vinaj tziꞌ.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ech sibꞌal aanima niman u Jesuus latziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Uncheeꞌ yaꞌvich maꞌl u vinaj Laazaro ibꞌii. Aa tenam tu Betaania, vitenam u Liꞌ tuchꞌ u Taa u tatzik. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Aatz u Laazaro tziꞌ vaꞌl yaꞌvich, aꞌ vixibꞌen u Liꞌ, vaꞌl oksan txꞌumqꞌixsabꞌal tiꞌ tajan u kuBꞌaal Jesuus utz, isuu tu xiꞌl iviꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ech ichaj bꞌen ichaj qꞌu tanabꞌ xeꞌ u Jesuus tiꞌ talax te ech tzaꞌ: —KuBꞌaal, yaꞌv vaꞌl tiichitꞌaxh tiꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Uncheeꞌ taꞌxh tabꞌi u kam u Jesuus tziꞌ, tal ech tzaꞌ: —Yitꞌ taꞌn koj sakam u Laazaro tu u yaabꞌil tziꞌ. Pek tokebꞌal iqꞌii u Tioxh kꞌuxh nituch u kam tziꞌ. Utz soꞌok iqꞌii viKꞌaol u Tioxh tiꞌ majte.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Aatz u Jesuus tan, tiich chit tiꞌ u Taa tuchꞌ tiꞌ vitzaꞌqꞌ utz, tuchꞌ tiꞌ u Laazaro majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ech kꞌuxh tabꞌi u Jesuus aas yaꞌvich, iꞌankoꞌnka kaꞌvaꞌt qꞌii tu vaꞌl atichka. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Xamtich tek tiꞌ u kam tzaꞌ, tal tu qꞌul ichusulibꞌ ech tzaꞌ: —Koꞌtaj unpat tu Judea.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Utz alax te tu qꞌul ichusulibꞌ ech tzaꞌ: —Chusul, siꞌchipaqꞌ sivan axh qꞌu qꞌesal uqꞌaybꞌal tziꞌ cheenale utz, ¿maꞌtpajaxh tziꞌ tzik?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Tzaqꞌbꞌu u Jesuus ech tzaꞌ: —¿Yitꞌ tzik kabꞌlaal koj oora tuul maꞌl qꞌii? Tan abꞌil vaꞌl nipaal qꞌiil, yeꞌxhkam tiꞌ nipaqꞌvoꞌk tibꞌ tan, nitil u txijtxubꞌal atil tu u vatz amlika txꞌavaꞌ tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pek abꞌil vaꞌl tu aqꞌbꞌal nipaaleꞌ, kam koꞌn tiꞌ nipaqꞌvoꞌk tibꞌ tan, yeꞌk txijtxubꞌal kꞌatza.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Aatz maꞌtich taltu qꞌu kam tziꞌ, tal paj ech tzaꞌ: —Vatyu u Laazaro, u qamiigo. Pek maꞌt unkꞌassa.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Tal tek qꞌul ichusulibꞌ ech tzaꞌ: —KuBꞌaal, untzꞌoj vatchel koꞌn, siꞌan bꞌaꞌn atziꞌ uncheeꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Loqꞌ aꞌ nichtal u Jesuus te aas kamya. Pek aꞌ titzꞌa qꞌu chusulibꞌ aas nojla vataꞌm nichbꞌanon. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Uncheeꞌ vatzsaj tek tal u Jesuus te ech tzaꞌ: —Kamyu u Laazaro. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Utz nuntxuqꞌtxuneꞌ tan, qeꞌl yeꞌk oꞌ tziꞌ aas vetkami. Pek koꞌtaj tzixeꞌ. Ech senima maas in.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Aatz u Maxh, vaꞌl Diidimo ibꞌii majte, tal tu qꞌu tetz chusulibꞌil ech tzaꞌ: —Koꞌtaj tiꞌ kꞌuxh sakamoꞌ kꞌatza majte.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ech opon u Jesuus aas maꞌtich tek tel kaavaꞌl qꞌii tok u Laazaro tu jul. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Aatz u Betaania tan, najaꞌ koꞌn kꞌatz u Jerusaleen. Kamal oxvaꞌl koꞌn kiloometro ixoꞌl tuchꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ech sibꞌal qꞌesal uqꞌaybꞌal maꞌtich tul xeꞌ u Taa tuchꞌ u Liꞌ tiꞌ iqeel tiꞌ vixibꞌen. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Utz aatz tabꞌi u Taa aas topon u Jesuus, ech ul ikꞌuleꞌ. Pek aatz u Liꞌ tan, kaaka tu u atibꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ech tal u Taa tu u Jesuus ech tzaꞌ: —UnBꞌaal, atichkojaxh tzaꞌ, yeꞌn kam vunxibꞌen koj atziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pek kꞌuxh anal ulyaxh cheel, vootzajle aas kajay vaꞌl sajaj tu u Tioxh, sataqꞌ see.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Tal u Jesuus te ech tzaꞌ: —Saqꞌaavitzꞌpu vaxibꞌen.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Tal u Taa te ech tzaꞌ: —Vootzajle saqꞌaavitzꞌpu tu u qꞌaavitzꞌpichil tu u motxebꞌal qꞌii saj.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Tal paj u Jesuus te ech tzaꞌ: —In u qꞌaavitzꞌpixsanal. Utz in u aqꞌol tiichajil tu bꞌenqꞌii bꞌensaj. Ech abꞌil vaꞌl ninimanin, kꞌuxh sakami, saqꞌaavitzꞌpi. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Utz kajay qꞌuꞌl itzꞌlele utz, ninimaꞌin, yitꞌ saꞌkojkam vatz Tioxh bꞌenqꞌii bꞌensaj. ¿Ni tzik anima vaꞌl nivaleꞌ tzaꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Tal u Taa ech tzaꞌ: —Eeꞌ unBꞌaal. Nimamal vaqꞌo aas axh viTxaaom u Tioxh; axh viKꞌaol u Tioxh ulyaxh tu u vatz amlika txꞌavaꞌ tzaꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ech taꞌxh tal u kam tziꞌ, bꞌenoꞌk. Ex isikꞌle u Liꞌ, vitzaꞌqꞌ. Ijutzi talax te ech tzaꞌ: —Atil u chusul tziꞌ. Nisikꞌleꞌaxh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ech taꞌxh tabꞌi u Liꞌ, oojeꞌl chit kꞌasuꞌl utz, bꞌen tzixeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Tan yeꞌsajich tokoꞌp u Jesuus tu u tal tenam. Pek aꞌ atichku tu vaꞌl ex kꞌulaxojku tu u Taa. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Utz til qꞌu qꞌesal uqꞌaybꞌal aas oojeꞌl chit kꞌasuꞌl u Liꞌ. Ayaꞌ qꞌu qeeol tetz niyolonka, qꞌuꞌl atich tu u atibꞌal tzixeꞌ. Ech motx xambꞌu kꞌasuꞌl tiꞌ u Liꞌ. Tan motx tal ech tzaꞌ: —Maꞌt oqꞌoj tu u mujbꞌal kamnaj atziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Uncheeꞌ opon u Liꞌ tu vaꞌl atichku u Jesuus; pecheꞌ kuꞌ siatz. Taꞌxh tila utz, tal te ech tzaꞌ: —UnBꞌaal, atichkojaxh tzaꞌ, yeꞌn kam vunxibꞌen koj atziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ech tiira ok txumuꞌm tu taanima u Jesuus aas tila nichtoqꞌ u Liꞌ. Utz nichtoqꞌ qꞌu qeeol majte qꞌuꞌl xamich tiꞌ. Ech yakꞌil chit xijxoꞌlan u Jesuus tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Utz ichꞌoti ech tzaꞌ: —¿Til ex emujva?— Texhtuꞌ. Alax te ech tzaꞌ: —KuBꞌaal, niꞌaxh tul saji iileꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ech oqꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Utz tal tek qꞌu qꞌesal uqꞌaybꞌal ech tzaꞌ: —Sajitaj etileꞌ, nitoqꞌ tiꞌ. Tiira tiich peꞌxh tiꞌ.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Utz at nichalon majte: —Nichijajpixsa iatz moy atziꞌ. Ech ¿kan chaj tokeꞌ yeꞌxhkam maꞌj vetiꞌana? Yeꞌn koj taqꞌ tzii vetkam u Laazaro tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ech tiira ok txumuꞌm tu taanima u Jesuus aas opon tu u mujbꞌal kamnaj. Ayaꞌ u mujbꞌal vaꞌl tu maꞌl u joyom sivan atichka. Utz sivan u jupibꞌ itziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Tal u Jesuus ech tzaꞌ: —Eesataj u sivan tziꞌ.— Texhtuꞌ. Utz tal u Taa, u tanabꞌ u kamnaj, ech tzaꞌ: —¡UnBꞌaal, vaꞌl tek itzuꞌl cheel atziꞌ! Tan kaavaꞌx qꞌii ikameꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Tal u Jesuus te ech tzaꞌ: —¿Yeꞌn val see tzik aas siil vitechalil Tioxh oj sakoꞌnanima?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ech eesal u sivan tziꞌ u jul vaꞌl mujichku u kamnaj. Utz sajin jeꞌ u Jesuus tu amlika. Tal ech tzaꞌ: —Tateey, taꞌntioxh see tan, naabꞌiꞌin. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Vootzajle aas ninalchitaabꞌiꞌin. Pek tiꞌ u mam tenam seplel ok viꞌ tzaꞌ, kꞌuxh nival ech tziꞌ. Ech samotxinima aas axh vetchajonulin.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Utz aatz veet tal ech tziꞌ, qꞌeqꞌuꞌm chit taltu ech tzaꞌ: —¡Laazaro cheeluꞌl!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","¡Ech eluꞌl u Laazaro vaꞌl maꞌtich ikameꞌ! Qitzich iqꞌabꞌ tajan tu bꞌuꞌj, bꞌachbꞌal tetz. Utz kutxich ivatz tu maꞌl u liikin bꞌuꞌj. Utz tal u Jesuus ech tzaꞌ: —Chittaj utz, chajputaj.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ech sibꞌal qꞌu qeeol qꞌuꞌl motx opon tiꞌ u Liꞌ, motx tek inima u Jesuus. Ayaꞌ qꞌu qꞌesal uqꞌaybꞌal xoꞌl qꞌu Israeel. Tan tila kam vaꞌl iꞌana. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pek at unjolte, motx bꞌen xeꞌ qꞌu fariseo. Utz ex tal u kam te vaꞌl iꞌan u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Uncheeꞌ aatz tek qꞌu qꞌesal oksan yol vatz Tioxh tuchꞌ qꞌu fariseo, motx imol u conciilio. Utz tal ech tzaꞌ: —¿Kam sakubꞌaneꞌ? Tan sibꞌax xheenya iꞌan u vinaj tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Utz mam tenam saniman atziꞌ oj sakoꞌxhqaqꞌka ech tziꞌ. Utz suꞌul qꞌu aa Roma. Suꞌlisotzsa u kutioxhla totztioxh tzaꞌ. Utz sisotzsa u kutenam majte tzaꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Uncheeꞌ aatz tek maꞌl te, ayaꞌ u Caifaas, vaꞌl qꞌesal oksan yolich tu u yaꞌbꞌ tziꞌ, tal ech tzaꞌ: —Atileꞌn kam yeꞌ etootzaj. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Yeꞌxhat niꞌenku sete aas nojchit aal bꞌaꞌn sakam maꞌl vinaj tiꞌ qꞌu aanima kajayil. Ech yitꞌ kajay koj u tenam lasotz tiꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Loqꞌ tiyakꞌil koj chit itxumbꞌal tal u kam tziꞌ. Pek axhibꞌi qꞌesal oksan yolich vatz Tioxh tu u yaꞌbꞌ tziꞌ. Ech aꞌ ibꞌaxabꞌsa el talaxeꞌ aas aal bꞌaꞌn sakam u Jesuus tiꞌ kajay u tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Utz yitꞌ tiꞌ koꞌnkoxh u tenam sakamka. Pek tiꞌ imolax qꞌu niman tetz u Tioxh majte. Ech siꞌan maꞌl iatz tan, paximich tibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ech motx inukꞌ qꞌu qꞌesala tu u qꞌii tziꞌ aas siyatzꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ech nichtereꞌnkojipaal u Jesuus vatz qꞌu qꞌesal uqꞌaybꞌal. Pek xaan bꞌen tu u tenam Efraiin, kꞌatz u tzꞌinlich tzaji txꞌavaꞌ. Utz aꞌ atinkuka tziꞌ tuchꞌ qꞌul ichusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Uncheeꞌ nichtekinajabꞌ u nimla qꞌii vaꞌl nipaasa qꞌu Israeel tiꞌ u Elchil Vatz Kamchil Tu Egipto. Utz sibꞌal aanima tikuenta u txꞌavaꞌ tziꞌ, motx bꞌen tu Jerusaleen tiꞌ ibꞌanax u kostuumbre tetz txꞌaatxꞌochil. Aꞌ chit yeꞌsajich ixeꞌt u nimla qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ech nichmotxichok u Jesuus. Utz nichmotxichꞌoti sivatzaj tu viqꞌanalil u totztioxh ech tzaꞌ: —¿Kantal nenacheꞌ? ¿Matz saul tu u nimla qꞌii?— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Aatz qꞌu qꞌesal oksan yol tuchꞌ qꞌu fariseo tan, maꞌtich taltaꞌ aas oj abꞌil maꞌj soꞌootzajin til atilka, sataleꞌ. Ech satxaypi. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Uncheeꞌ vaajitich koꞌn qꞌii topon u nimla qꞌii tiꞌ u Elchil Vatz Kamchil Tu Egipto, bꞌen u Jesuus tu Betaania tu tatibꞌal u Laazaro, vaꞌl kami. Loqꞌ qꞌaav itzꞌpixsal xoꞌl qꞌu kamnaj. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ech bꞌanax techbꞌubꞌal u Jesuus tetz kuꞌebꞌal qꞌii. U Taa nichiꞌkꞌulaneꞌ. Utz kꞌujlich ok u Laazaro vatz meexha kꞌatz u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ech aatz u Liꞌ, ex tiqꞌo maꞌl libra txꞌumqꞌixsabꞌal, nardo ibꞌii. Sibꞌ ijaꞌmel. Ech iqoo kuꞌ tiꞌ qꞌu tajan u Jesuus. Utz itzajsa tu qꞌu xiꞌl iviꞌ. Ech tiira pax paal itxꞌumqꞌu u txꞌumqꞌixsabꞌal tu u tuul otzotz bꞌaꞌnil. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ech yolon maꞌl tu qꞌul ichusulibꞌ, ayaꞌ u Judas aa Cariote vaꞌl siꞌchꞌoksan u Jesuus tiqꞌabꞌ qꞌu txayol, vikꞌaol u Xhim. Tal ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Kantuꞌ maꞌkojkꞌayil u txꞌumqꞌixsabꞌal tu 300 jaꞌmel aqꞌonibꞌal qꞌii tziꞌ? Utz saꞌaqꞌax vijaꞌmel tu qꞌu meꞌbꞌaꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kꞌuxh tal u kam tziꞌ, tiꞌ koj aas nojchit nitxum iatz qꞌu meꞌbꞌaꞌ. Pek tiꞌ tan, elqꞌomich. Utz aꞌ atichku u txꞌuꞌy tzixeꞌ, kolbꞌal puaj. Utz nichtelqꞌa el tetz u puaj nichikoꞌp tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ech aatz u Jesuus tal ech tzaꞌ: —Kam esaꞌ te. Tan tiꞌ itzꞌakal vunchiꞌl tu mujbꞌal vetz kꞌuxh vetikoleꞌl u txꞌumqꞌixsabꞌal tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Utz aatz qꞌu meꞌbꞌaꞌ, ech koꞌxh tatin texoꞌl bꞌenamen atziꞌ. Pek aatz in tan, ech koꞌn koj vatin texoꞌl tzaꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Uncheeꞌ sibꞌal qꞌu qꞌesal uqꞌaybꞌal abꞌin aas atich u Jesuus tu Betaania. Ech motx bꞌen tziꞌ. Yitꞌ tiꞌ koꞌnkoxh en tilax u Jesuus, pek tiꞌ en tilax u Laazaro majte vaꞌl qꞌaav itzꞌpu xoꞌl qꞌu kamnaj. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ech taqꞌ kuꞌ tibꞌeyil qꞌu qꞌesal oksan yol vatz Tioxh aas antu tek siyatzꞌ u Laazaro majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Tan tiꞌ koꞌn u qꞌaavtitzꞌpu u Laazaro nichtelka qꞌu qꞌesal uqꞌaybꞌal tiꞌ qꞌu tuqꞌaybꞌal utz, nichinima u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Uncheeꞌ tu tek vaꞌt qꞌii tuul, atich opon u mam tenam tu u nimla qꞌii. Utz motx tabꞌi aas siꞌchopon u Jesuus tu Jerusaleen. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ech motx ichok qꞌabꞌaj paalma utz, motx ul ikꞌuleꞌ. Nichmotxiqꞌeqꞌun taltu ech tzaꞌ: —¡Lochꞌoꞌ! ¡Techal axh tan, tibꞌii u kuBꞌaals Amlika niulkꞌaxh, viQꞌesal qꞌu Israeel!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ech chee maꞌl u chelem bꞌuuro utz, jeꞌ u Jesuus tiꞌ. Echaꞌ vaꞌl tzꞌibꞌamalka nital ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","—Yeꞌ koꞌxh xoꞌvex Israeel; ex aa tu Sioon. Tan tul vetijlenal; atil jeꞌ tiꞌ maꞌl chelem bꞌuuro.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Utz yeꞌt paal itxumbꞌal qꞌu chusulibꞌ tu qꞌu kam tzaꞌ. Pek analen paal itxumbꞌal tuul aas bꞌentekjeꞌ u Jesuus tu Amlika. Motx tek ul sikꞌuꞌl aas tzꞌibꞌamichnalka qꞌu kam tiꞌ qꞌuꞌl uchi. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ech antu xamich tiꞌ u Jesuus qꞌu aanima qꞌuꞌl ilon aas isikꞌle eluꞌl u Laazaro tu jul utz, qꞌaav titzꞌpixsa. Vaꞌlich motx taltu tu tereꞌn qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ech mam tenam motx ul tiꞌ ikꞌulaxeꞌ. Tan maꞌtich tabꞌitaꞌ aas iꞌan u txaichil tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pek aatz qꞌu fariseo tan, nichmotxtal tibꞌilaj ech tzaꞌ: —¿Matz etillaꞌ? ¡Kam koj ech qoleꞌ tiꞌ! Tan mam tenam niniman utz, nixambꞌu tiꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Uncheeꞌ atich unjolol puera aanima xoꞌl qꞌu nachol Tioxh qꞌuꞌl motx opon tu u nimla qꞌii, griego viyolbꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Aatz qꞌu griego tziꞌ, motx xaan opon kꞌatz u Felipe, u aa Betsaida tikuenta Galilea. Utz ijaj bꞌaꞌnil te ech tzaꞌ: —Bꞌaal nitxaꞌ, niqachva saqil u Jesuus.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ech ibꞌen u Felipe utz, ex tal tu u Lixh. Ech kaꞌl tek ixaaneꞌ, motx ex tal tu u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Utz tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Oponyu u tiempo aas saꞌtekkam u Kꞌaola vaꞌl bꞌennaj koꞌn aanima. Loqꞌ saqꞌaavitzꞌpixsali. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Niꞌxhtekꞌval sete aas oj yitꞌ saꞌkojxalamtu u tiil triigo nikuꞌ tu txꞌavaꞌ, kam koj saitzꞌpi. Sakoꞌxhkaa u ia ech tziꞌ. Pek oj saxalamtu tu u txꞌavaꞌ utz, saitzꞌpi. Sibꞌal ivatz sataqꞌeꞌ atziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Abꞌil vaꞌl tii chit tiꞌ u vatz iqꞌii isaj tzaꞌ, aal sitzꞌejeꞌ. Pek abꞌiste vaꞌl yitꞌ taꞌxh koj nititzꞌa vitiichajil tu u vatz amlika txꞌavaꞌ tzaꞌ, aal aꞌ nikol tiꞌ vitiichajil tu bꞌenqꞌii bꞌensaj. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Abꞌil qꞌuꞌl ninimanin, xambꞌoj viꞌ. Utz til saꞌatinkꞌin, aꞌ saꞌatinku u niman vetz tziꞌ majte. Tan abꞌil vaꞌl sanimanin, saꞌatin tatin vatz vunTat. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Aatz cheel, tiira kꞌaybꞌinaj vaanima. Utz ¿kam chaj savaleꞌ? ¿Satz unjaj tu vunTat aas sateesaꞌin tu tzaꞌl tziꞌ? Tan ech chit u vetz ul unbꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","¡Tateey, taꞌxh saꞌan vatxumbꞌal! Ech oksa iqꞌii vabꞌii.— Texhtuꞌ. Ech uch kꞌasuꞌl maꞌl u yol tu Amlika, tal ech tzaꞌ: —Vetvoksal iqꞌii vunbꞌii utz, saꞌpajvoksa unpate.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Aatz u mam tenam atich opon tziꞌ, tabꞌi u viꞌ tziꞌ. Utz atia nichmotxtaleꞌ aas maꞌl tininunchil uchi. Utz at nichalon majte aas: —Maꞌl aanjel qꞌilan.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Pek tzaqꞌbꞌu u Jesuus utz, tal ech tzaꞌ: —Yitꞌ viꞌ koj vetꞌul u yol tziꞌ, pek setiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Tan oponyu tek u tiempo tiꞌ vitxꞌolax inujul u vatz amlika txꞌavaꞌ tzaꞌ. Sabꞌajleꞌl u qꞌesala tu u vatz amlika txꞌavaꞌ, ayaꞌ u txꞌiꞌliꞌinaj. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Aatz latꞌanbꞌaꞌljeꞌin vatz kurus, sibꞌla aanima sanimanin; soꞌok sunkꞌatza.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Loqꞌ aꞌ nichtal inujul kaniꞌch ikam sakami aas nichtal qꞌu kam tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Utz tzaqꞌbꞌu qꞌu aanima ech tzaꞌ: —Abꞌimal qaqꞌo tu u oꞌtla mantaar aas taꞌn atinchil siꞌan viTxaaom u Tioxh. Pek ¿kam tok naaleꞌ aas ministeer saelbꞌen u Kꞌaola vaꞌl bꞌennaj koꞌn aanima tu u vatz amlika txꞌavaꞌ tzaꞌ? Utz ¿abꞌil u Kꞌaola vaꞌl bꞌennaj koꞌn aanima naaleꞌ uncheeꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tzaqꞌbꞌu u Jesuus utz, tal ech tzaꞌ: —Bꞌiit koꞌxh tiempo saꞌatinin texoꞌl; echaꞌ txijtxun etetz u vatineꞌ. Utz paalojex, tuul atil u txijtxubꞌal tziꞌ. Ech yeꞌk koj enachloꞌm luꞌul u uken. Tan abꞌil vaꞌl tu aqꞌbꞌal nipaaleꞌ, yeꞌ tootzaj tiꞌch ibꞌenaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nimataj u txijtxun etetz tuul atil texoꞌl. Ech setiqꞌo tetz vitxumbꞌal tan, ex ikꞌaol imeꞌal u txijtxubꞌal tziꞌ.— Texhtuꞌ. Uncheeꞌ taꞌxh tal qꞌu kam u Jesuus tziꞌ, bꞌeni; imuj tibꞌ siatz. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Pek yeꞌt koꞌn nimal tu qꞌu aanima, kꞌuxh maꞌtich iꞌantu sibꞌla txaichil siatz. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Loqꞌ itzojpu chit u Yolbꞌal Tioxh vaꞌl alelka tu u Isaias u alol tetz u yolbꞌal Tioxh, aas tal ech tzaꞌ: —KuBꞌaal, yeꞌxhabꞌil niniman qꞌu kam niqaleꞌ. Utz ¿abꞌil kꞌatza nikꞌuchvu tibꞌ viyakꞌil u kuBꞌaal?— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ech tokeꞌ yeꞌ nichmotxinimaneꞌ. Utz tal paj u Isaias ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","—U Tioxh jupun iatz qꞌu aanima. Utz itiibꞌixsa qꞌu taanima. Ech yeꞌk samotxilon tuchꞌ bꞌaqꞌ iatz. Utz yeꞌk sael bꞌoj itxumbꞌal tuul tu taanima. Ech yeꞌk soꞌok sunkꞌatza utz, yeꞌk sunbꞌan bꞌaꞌn te.— Chu u Isaias. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aꞌ taltu u kam u Isaias tziꞌ aas tiltu vitechalil u Tioxh. Ech yolon tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Sibꞌal motx niman u Jesuus. Antu qꞌu qꞌesala xoꞌl qꞌu Israeel. Pek yeꞌ nichmotxiyoleꞌl. Aꞌ nichmotxixoꞌva qꞌu fariseo. Tan oj samotxtaleꞌ, sayaꞌsal topon tu qꞌu atibꞌal chusbꞌal tetz u oꞌtla mantaar. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Tan aꞌ bꞌennajku ikꞌuꞌl tiꞌ u toksal iqꞌii xoꞌl qꞌu aanima, vatz u tok iqꞌii tu u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Utz qetun taltu u Jesuus ech tzaꞌ: —Abꞌil ninimanin, yitꞌ in koj ninimaꞌin. Pek aꞌ ninima vaꞌl vetchajonulin. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Utz abꞌil niꞌilonin, aꞌ nitil vaꞌl vetchajonkꞌasuꞌlin. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","In u txijtxubꞌal ulyin tu u vatz amlika txꞌavaꞌ. Utz abꞌil qꞌuꞌl ninimaꞌin, yitꞌ tu uken tereꞌn koj saꞌatinka. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Utz yitꞌ in koj satxꞌolon inujul abꞌil aꞌ niꞌabꞌin qꞌul unyol tzaꞌ utz, yeꞌ ninima. Tan yitꞌ aꞌ koj ul untxꞌol inujul qꞌu aanima tu u vatz amlika txꞌavaꞌ tzaꞌ. Pek aal ul unchitpu. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Abꞌil yeꞌ nikꞌulin utz, yeꞌ nikꞌul qꞌul unyol, atil vaꞌl satxꞌolon inujul. Aꞌ satxꞌolon inujul tu u motxebꞌal qꞌii saj qꞌu yol qꞌuꞌl vetvallaꞌ tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tan yitꞌ unyol koj sunjunal qꞌu yol vetvallaꞌ. Pek aꞌ vetaqꞌon u mantaar ve vunTat vaꞌl vetchajonkꞌasuꞌlin. Aꞌ aqꞌon unyol tiꞌ kam savaleꞌ utz, kaniꞌch talax sunbꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Utz vootzajle aas tetz tiichajil tu bꞌenqꞌii bꞌensaj vimantaar. Ech tokeꞌ kam chit echaꞌ talax ve vetiꞌan vunTat, echat chit talax kajay nunbꞌaneꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Uncheeꞌ atich tek sikꞌuꞌl u Jesuus aas maꞌt topon vitiempo, aꞌ chit yeꞌsajich ixeꞌt u nimla qꞌii tiꞌ u Elchil Vatz Kamchil Tu Egipto. Tootzaj tekuꞌen saelbꞌen vatz txꞌavaꞌ utz, seꞌen xeꞌ viTat. Utz tiich u Jesuus tiꞌ qꞌul ichusulibꞌ utz, ankoꞌxh tiich tiꞌ tiyaꞌtebꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Uncheeꞌ ela nichmotxtechbꞌu u echbꞌubꞌal tuchꞌ tetz u nimla qꞌii. Utz maꞌtich toksal tu taanima u Judas tu u txꞌiꞌliꞌinaj aas aꞌ vaꞌl saoksan u Jesuus tiqꞌabꞌ qꞌu txayol. Ayaꞌ u Judas aa Cariote, vikꞌaol u Xhim. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Utz tootzajleich u Jesuus aas maꞌt toksal kajay qꞌu kam tiqꞌabꞌ tu viTat. Tan aꞌ kꞌaskuꞌl xeꞌ Tioxh utz, aꞌ seꞌenku xeꞌ Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ech txakeꞌ u Jesuus tu vaꞌl atichku kꞌatz u meexha. Teesa vichakeꞌt utz, itxay maꞌl toalla. Iqitzoꞌk xeꞌaj tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ech taqꞌ kuꞌ aꞌ tu maꞌl u kambꞌal utz, xeꞌt itxꞌaa tajan qꞌul ichusulibꞌ. Utz isuu tu u toalla vaꞌl qitzich ok xeꞌaj tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Pek aatz opon kꞌatz u Xhim vaꞌl Luꞌ majte, tal te ech tzaꞌ: —UnBꞌaal, ¿nojchit satxꞌaa vajan?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Tzaqꞌbꞌu u Jesuus tal te ech tzaꞌ: —Aatz cheel, saꞌkojel atxumbꞌal tu vaꞌl nunbꞌaneꞌ. Pek xamtel sael atxumbꞌal tuul kam tokeꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Tal u Luꞌ te ech tzaꞌ: —Yeꞌxhjatu satxꞌaa vajan.— Texh te. Tzaqꞌbꞌu u Jesuus ech tzaꞌ: —Yeꞌk ookebꞌal sunkꞌatza untzꞌoj yeꞌk suntxꞌaa aajan.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Tal paj u Xhim te ech tzaꞌ, vaꞌl u Luꞌ majte: —UnBꞌaal, yitꞌ taꞌn koꞌn koj satxꞌaa qꞌu vajan tziꞌ, pek antu satxꞌaa unqꞌabꞌ tuchꞌ unviꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Tal u Jesuus te ech tzaꞌ: —Abꞌil vaꞌl txꞌaatxꞌoch tatineꞌ, aꞌ texh satxꞌaal qꞌu tajan. Ech txꞌaatxꞌoch tek kajayil siꞌaneꞌ. Utz aatz ex, txꞌaatxꞌochtekꞌex, kꞌuxh yitꞌ kajay koj ex.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Kꞌuxh tal ech tziꞌ tan, tootzajich tekuꞌen abꞌil vaꞌl soꞌoksan tiqꞌabꞌ qꞌu txayol. Echixeꞌat tala aas: —Yitꞌ kajay koj ex txꞌaatxꞌochꞌex.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Uncheeꞌ toksa paj vichakeꞌt aas veet itxꞌaat qꞌu tajan utz, qꞌaavopon vatz meexha. Utz tal tu qꞌu chusulibꞌ ech tzaꞌ: —¿Matz paaly etxumbꞌal tu vaꞌl vetunbꞌanlu sete tziꞌ? ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Tan “Chusul” utz, “Bꞌaal” cheꞌex viꞌ. Utz nojchit netaleꞌ tan, in. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Utz kꞌuxh in Bꞌaal utz, in Chusul, vetuntxꞌaal etajan, echat sebꞌan majte. Sitxꞌaa tibꞌ etajan setibꞌilaj. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Maꞌl kꞌuchbꞌal vetunbꞌanlu sevatz. Ech kam chit echaꞌ vetunbꞌanlu sete, echat samotxebꞌan majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Tan niꞌxhtekꞌval sete aas yitꞌ paalchu koj tijleꞌm u aqꞌonom vatz u bꞌaal taqꞌon. Utz yitꞌ paalchu koj tijleꞌm u bꞌanol chaj, vatz vaꞌl nichajon. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Utz chiꞌbꞌebꞌal etetz siꞌaneꞌ untzꞌoj etootzaj qꞌu kam tzaꞌ utz, sebꞌan ex bꞌanol tetz. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Loqꞌ yitꞌ kajay koj ex nivalex. Tan vootzajle abꞌil txaael vaqꞌo. Utz saꞌnaltzojpu u Yolbꞌal Tioxh vaꞌl nital ech tzaꞌ: «Aatz vaꞌl ela nuntxꞌaꞌ kaxhlaan txꞌix tuchꞌ, aꞌ sabꞌanon jeꞌ ve.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nival qꞌu kam sete tzaꞌ tuul yeꞌsaj tucheꞌ. Ech aatz lauchi, senima abꞌil in. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Tan niꞌxhtekꞌval sete, abꞌil sakꞌulun vaꞌl nunchajeꞌ, in aꞌ nikꞌulin tziꞌ. Utz abꞌil vaꞌl nikꞌulin, aꞌ nikꞌul vaꞌl vetchajonkꞌasuꞌlin.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Uncheeꞌ txumun u Jesuus tu taanxelal aas maꞌtich taltu qꞌu kam tziꞌ. Tal ech tzaꞌ: —Niꞌxhtekꞌval sete aas maꞌl sete soꞌoksanin tiqꞌabꞌ qꞌu txayol.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ech xeꞌt motx isaji tibꞌ qꞌu chusulibꞌ tibꞌilaj utz, nichmotxisotz ikꞌuꞌl. Tan abꞌiste chaj te nichtalaxeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Utz chꞌuxhlich kꞌatz u Jesuus u chusulibꞌ vaꞌl tiira bꞌaꞌnich u Jesuus te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ech bꞌanax bꞌen xheenya te tu u Xhim, ayaꞌ u Luꞌ, aas sichꞌoti tu u Jesuus abꞌil nichtaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Aatz tek u chusulibꞌ tziꞌ, aal chit ijetzꞌoꞌk tibꞌ kꞌatz u Jesuus. Utz jutzuman tabꞌi te ech tzaꞌ: —UnBꞌaal, ¿abꞌil?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Tzaqꞌbꞌu u Jesuus ech tzaꞌ: —Ayaꞌ vaꞌl savaqꞌ u kaxhlaan txꞌix te chaael tu chibꞌ.— Texhtuꞌ. Ech ichaat u kaxhlaan txꞌix tu u chibꞌ. Taqꞌ tu u Judas aa Cariote, vikꞌaol u Xhim. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ech ok u txꞌiꞌliꞌinaj tu taanima u Judas aas maꞌtich taqꞌax bꞌiil u kaxhlaan txꞌix te. Utz tal tek u Jesuus te ech tzaꞌ: —Nal koꞌxh aꞌaneꞌ kam vaꞌl saꞌaneꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pek yeꞌxhabꞌil koꞌxh maꞌj tu qꞌuꞌl atich vatz meexha, el itxumbꞌal tuul kam tok vaꞌl tala. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Tan aatz nichitzꞌan aas kamal siloqꞌeꞌ kam nisav tetz u nimla qꞌii nichtaleꞌ. Oj aꞌ sataqꞌ bꞌoj tetz qꞌu meꞌbꞌaꞌ nichtaleꞌ. Tan axhibꞌi aꞌich kolol puaj u Judas. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ech taꞌxh techbꞌu u kaxhlaan txꞌix u Judas tziꞌ, kꞌasuꞌl. Utz tu aqꞌbꞌalich tekuꞌen. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Uncheeꞌ aatz maꞌtich tek ikꞌasuꞌl, tal u Jesuus ech tzaꞌ: —Aatz cheel, oponyu u tiempo aas saok iqꞌii u Kꞌaola vaꞌl bꞌennaj koꞌn aanima. Utz soꞌok iqꞌii u Tioxh tiꞌ majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Tan oj nitok iqꞌii u Tioxh tiꞌ, saoksal iqꞌii tu u Tioxh majte. Utz saꞌtexhiꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Unchusulibꞌ tiiꞌin setiꞌ, bꞌiit koꞌxh sunbꞌan texoꞌl. Tan sabꞌenin. Utz sechokꞌin. Loqꞌ saꞌkojveet etopon tu vaꞌl seꞌenkꞌin. Echat chit nival sete kam vaꞌl vetval tu qꞌu qꞌesal uqꞌaybꞌal xoꞌl qꞌu Israeel. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nunchus vaꞌt u mantaar sete jalel tekuꞌen. Utz ayaꞌ vaꞌl sebꞌan tiiꞌex setibꞌilaj sejununil. Kam echaꞌ munbꞌantu tiiꞌin setiꞌ, echat koꞌxh ebꞌantu tiiꞌex setibꞌilaj sebꞌan majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Tan untzꞌoj sebꞌan tiiꞌex setibꞌilaj, satootzaji kajay qꞌu aanima aas ex niman vetz.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Aatz u Xhim vaꞌl Luꞌ, tal tek te ech tzaꞌ: —UnBꞌaal, ¿til seꞌenkꞌaxh?— Texh te. Ech tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Saꞌkojveet abꞌen viꞌ cheel tu vaꞌl maꞌtkꞌin. Pek xamtel labꞌenaxh viꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Utz tal u Luꞌ te ech tzaꞌ: —UnBꞌaal, ¿kantuꞌ yeꞌk saveet unbꞌen saiꞌ cheel? ¡Tan aal sunqꞌiꞌ kamchil saiꞌ!— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —¿Saqꞌiꞌ kamchil viꞌ naaleꞌ? Niꞌxhtekꞌval see aas yeꞌsajen toqꞌ u bꞌaal tꞌel tuul, ox pajul maꞌt eesat iibꞌ tuul aas ootzajin. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yeꞌ koꞌxh ilin etaanima. Kꞌujlel nal ekꞌuꞌl tiꞌ u Tioxh utz, kꞌujloj ekꞌuꞌl viꞌ majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Tan aatz tu vaꞌl atilku vunTat tu Amlika, sibꞌal atibꞌal atile. Vetvallu sete koj atziꞌ aas yitꞌ koj echi. Pek maꞌt unbꞌan tuch etatibꞌal sekajayil. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Seꞌenin utz, maꞌt unbꞌan tuch etatibꞌal. Loqꞌ vul unpate. In chit suꞌliqꞌonbꞌenex viꞌ. Ech til vaꞌl saꞌatinkꞌin saꞌatinex tziꞌ majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Etootzajle til maꞌtkꞌin utz, etootzajle u bꞌey.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Loqꞌ alax te tu u Maxh ech tzaꞌ: —KuBꞌaal, yeꞌ qootzaj til maꞌtkꞌaxh. ¿Kaniꞌch qootzajit u bꞌey uncheeꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Utz tal u Jesuus te ech tzaꞌ: —In u bꞌey xeꞌ Tioxh. In vinujul. Utz in u tiichajil tetz bꞌenqꞌii bꞌensaj. Abꞌil koj soꞌopon xeꞌ vunTat untzꞌoj yitꞌ viꞌ koj. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Oj nojchit etootzajin, etootzajle vunTat majte atziꞌ. Utz cheel nixeꞌtetootzaji tan, ninaletileꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Uncheeꞌ tal u Felipe te ech tzaꞌ: —KuBꞌaal, chuspi koꞌxhtuꞌ sakꞌuch u kuTat qe.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Tal u Jesuus te ech tzaꞌ: —¿Yootzajin tzik Felipe kꞌuxh sibꞌax tiempo vatin texoꞌl? Tan abꞌil vaꞌl vettillin, vettillu vunTat majte atziꞌ. Ech ¿kam tok naaleꞌ? aas: «Kꞌuch u kuTat qe.» Chaꞌaxh. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Yetz nanima tzik aas maꞌl koꞌn in tuchꞌ vunTat utz; maꞌl koꞌn vunTat vuchꞌ majte? Aatz qꞌu yol qꞌuꞌl nivaleꞌ tzaꞌ, yitꞌ vetz koj sunjunal. Pek tetz vunTat vaꞌl atil sunkꞌatza. Tan aꞌ nibꞌanon qꞌu kam. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nimataj aas maꞌl koꞌn in tuchꞌ vunTat utz; maꞌl koꞌn vunTat vuchꞌ. Aꞌ u techlal u vatin tuchꞌ vunTat qꞌu txaichil nunbꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Niꞌxhtekꞌval sete aas abꞌil vaꞌl ninimanin, siꞌan qꞌu kam majte qꞌuꞌl nunbꞌaneꞌ tzaꞌ. Utz paalchu koꞌxh tereꞌn siꞌaneꞌ tan, maꞌtꞌin xeꞌ vunTat. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Utz kajay qꞌu kam qꞌuꞌl sejaj tu vunTat tunbꞌii, sunbꞌaneꞌ. Ech soꞌok iqꞌii u Tata kꞌatz u Kꞌaola. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kam sejaj tunbꞌii, savaqꞌeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Oj nojchit tzꞌejel etaanima viꞌ, nimataj qꞌul unmantaar. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Utz sunjaj tu vunTat, sataqꞌ vaꞌt moxbꞌen etetz aas tiira saꞌatin texoꞌl bꞌenamen. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ayaꞌ u Tioxhla Espiiritu, u iqꞌon tetz vinujul, vaꞌl yeꞌk saveet ikꞌulax tu qꞌu aanima qꞌuꞌl ayeꞌn tu paav. Tan nikojtileꞌ utz, yeꞌ tootzaj. Pek ech koj ex tan, etootzajle. Atil sekꞌatza utz, saꞌatin sekꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Yitꞌ saꞌkojvaqꞌkaꞌex echaꞌ ikaa tal nitxaꞌ yeꞌk itxutx ibꞌaal. Pek saqꞌaavuꞌlin tzexeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Bꞌiit koꞌxh siꞌaneꞌ utz, yeꞌkan satilin qꞌu aanima qꞌuꞌl ayeꞌn tu u paav. Pek aatz ex, setilin. Tan itzꞌlelin bꞌenqꞌii bꞌensaj. Utz saꞌatinex tu bꞌenqꞌii bꞌensaj majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Aatz siꞌan tu u qꞌii tziꞌ, setootzaji aas nojchit maꞌl koꞌn in tuchꞌ vunTat. Utz setootzaji aas atilin sekꞌatza utz; atilex sunkꞌatza majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Abꞌil vaꞌl atil qꞌul unmantaar sikꞌuꞌl utz, ninima, aꞌ vaꞌl tzꞌejel taanima viꞌ atziꞌ. Utz abꞌil vaꞌl tzꞌejel taanima viꞌ, siꞌan tii vunTat tiꞌ. Sunbꞌan tiiꞌin tiꞌ utz, saꞌatinin kꞌatza majte.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Uncheeꞌ alax te tu u Judas ech tzaꞌ, vaꞌl yitꞌ aa Cariote koj: —KuBꞌaal, ¿kam tokeꞌ aas oꞌ koꞌxh sailonaxh utz, yitꞌ saꞌkojtilaxh unjot qꞌu aanima tu u vatz txꞌavaꞌ tzaꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Tzaqꞌbꞌu u Jesuus ech tzaꞌ: —Abꞌil sitzꞌej taanima viꞌ, sinima vunyolbꞌal atziꞌ. Utz siꞌan tii vunTat tiꞌ. Ech saꞌatinoꞌ kꞌatza. Taꞌn saꞌatinoꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Pek abꞌil vaꞌl yitꞌ tzꞌejel koj taanima viꞌ, yeꞌ niniman vunyolbꞌal atziꞌ. Utz aatz qꞌu yol vetetabꞌilaꞌ tzaꞌ, yitꞌ vetz koj, pek tetz vunTat vaꞌl vetchajonkꞌasuꞌlin. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nival qꞌu kam sete tzaꞌ, tuul atilin texoꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pek toj ichaj kꞌasuꞌl u moxbꞌen etetz vunTat tunbꞌii. Ayaꞌ u Tioxhla Espiiritu. Aꞌ vaꞌl sachusun kajay qꞌu kam sete. Utz sinachpixsa kajay qꞌu kam sete qꞌuꞌl vetvallaꞌ tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Savoksa u paas tetaanima. Ayaꞌ vaꞌl atil sunkꞌatza, vaꞌl yitꞌ ech koj aꞌ vaꞌl atil tu u vatz amlika txꞌavaꞌ. Yeꞌ koꞌxh ilin etaanima utz, yeꞌ koꞌxh xoꞌvex. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Vetetabꞌilaꞌ, vetvallu sete aas sabꞌenin. Loqꞌ suꞌulin texoꞌl. Utz oj nojchit tzꞌejel etaanima viꞌ, satxuqꞌtxunex koj atziꞌ tiꞌ aas maꞌtꞌin xeꞌ vunTat. Tan paalchu vunTat sunviꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nivalka el qꞌu kam sete cheel tzaꞌ aas yeꞌsaj unbꞌenaꞌ. Ech lenima aas maꞌt unbꞌenaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Uncheeꞌ yitꞌ jankꞌal tereꞌn koj sayolonin setuchꞌ. Tan tul vaꞌl niqꞌesalain tu u vatz amlika txꞌavaꞌ tzaꞌ. Utz yeꞌxh bꞌoj tokebꞌal sunkꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pek ministeer nunbꞌan qꞌu kam vettal vunTat ve. Ech satootzaji qꞌu aanima tu u vatz amlika txꞌavaꞌ aas nojchit kꞌonel vaanima tiꞌ vunTat. Pek koꞌtaj, elojbꞌenoꞌ tzaꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Uncheeꞌ tal tepaj u Jesuus tu qꞌul ichusulibꞌ ech tzaꞌ: —Ech in u nojla mukanil uuva. Utz aatz vunTat, echaꞌ aqꞌin tetz. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Utz sateesa kajay qꞌu qꞌabꞌaj nitel sunkꞌatza qꞌuꞌl yeꞌ nivatzineꞌ. Pek satilbꞌe abꞌiste vaꞌl nitaqꞌ ivatz. Ech saꞌxhtaqꞌ tereꞌn ivatz. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Utz aatz ex, txꞌaaeltekꞌex tu qꞌul unyol vetvallu sete. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Tii atojex sunkꞌatza. Utz saꞌatinin sekꞌatza majte. Echaꞌ u qꞌabꞌ uuva sakoꞌnkoxhvatzin sijunal oj yitꞌ atil koj kꞌatz vimukanil. Utz echat koꞌxh ex majte. Saꞌkojekꞌuch u bꞌaꞌnil oj yitꞌ atilkojokꞌex sunkꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Aatz in, echaꞌ in vimukanil u uuva. Utz ech ex qꞌul iqꞌabꞌaj. Tan abꞌil vaꞌl atoꞌk sunkꞌatza, atilin kꞌatza. Utz sibꞌal ivatz nitaqꞌeꞌ. Pek kam koj setxꞌol iveeteꞌ oj xaannajelex sunkꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Tan abꞌil vaꞌl yitꞌ atil koj ok sunkꞌatza, saeesal sunkꞌatza. Echaꞌ itzokꞌleꞌl qꞌu qꞌabꞌ uuva. Ech nitzajeꞌ. Utz nimolaxeꞌ saꞌaqꞌax okoꞌp tu xamal tiꞌ itzꞌeꞌaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Pek oj tii etatin sunkꞌatza utz, tii nenima vunyol, jajtaj kam kajay vaꞌl esaꞌ. Utz saꞌaqꞌax sete. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nitok iqꞌii vunTat setaqꞌo oj nekꞌuch u bꞌaꞌnla txumbꞌal, echaꞌ bꞌaꞌnla vatz tzeꞌ. Utz oj nimnaꞌl aas ex unchusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kam chit echaꞌ ibꞌantu tii vunTat viꞌ, echat unbꞌantu tiiꞌin setiꞌ. Ech tii atojex sunkꞌatza tu vunbꞌantu tiiꞌin setiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Saꞌatinex sunkꞌatza oj senima qꞌul unmantaar. Tan tiiꞌin setiꞌ. Echaꞌ nunbꞌaneꞌ aas nunnima qꞌul imantaar vunTat utz, atilin kꞌatza. Tan tii viꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Kꞌuxh nival qꞌu kam sete tziꞌ tan, aꞌ unsaꞌ senach u txuqꞌtxunchil vaꞌl nunnacheꞌ. Ech tzꞌajel u txuqꞌtxunchil sekꞌatza siꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Utz aꞌ vunmantaar tzaꞌ; ayaꞌ vaꞌl sebꞌan tiiꞌex setibꞌilaj, echaꞌ unbꞌantu tiiꞌin setiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tan nojchit taꞌxh maꞌl aanima sibꞌ tii tiꞌ imol vaꞌl sataqꞌ tibꞌ tu kamchil tiꞌ qꞌu tamiigo. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Utz jolol ex vamiigo siꞌaneꞌ oj sebꞌan qꞌul vetvallu sete. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Tan “aqꞌonom” chajkoꞌnkojin setiꞌ. Tan aatz vaꞌl aqꞌonom kuꞌen, yeꞌ tootzaj kam niꞌan u bꞌaal taqꞌon. Pek “vamiigo” chajin setiꞌ tan, vetvallu kajay qꞌu kam sete qꞌuꞌl vetvabꞌi xeꞌ vunTat. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Utz yitꞌ ex koj vettxaaonin, pek in vettxaaonex. Utz aꞌ vetetz cheel sekꞌuch vitxumbꞌal u Tioxh sekꞌatza, echaꞌ bꞌaꞌnla vatz tzeꞌ. Ech vaꞌl sebꞌan bꞌenamen. Ech kajay qꞌu kam qꞌuꞌl sejaj tu vunTat tunbꞌii, sataqꞌ sete. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ech nunbꞌan mantaar talax sete aas sebꞌan tiiꞌex setibꞌilaj sejununil. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Oj nichiꞌkꞌulaꞌex qꞌu aanima tu u vatz amlika txꞌavaꞌ tzaꞌ, aꞌtzii. Tan ootzajitaj, in aꞌ bꞌaxal nichiꞌkꞌulaꞌin tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Utz siꞌan tii setiꞌ koj aas ex koj bꞌanol tetz qꞌu paav tu u vatz amlika txꞌavaꞌ tzaꞌ. Pek yitꞌ ex koj bꞌanol tetz paav. Echixeꞌat nichiꞌkꞌulaꞌex tereꞌn qꞌu aanima. Tan txaaeltekꞌelex xoꞌl qꞌu aanima vaqꞌo tu u vatz a txꞌavaꞌ tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ulsataj u yol sekꞌuꞌl vaꞌl alel sete vaqꞌo aas yitꞌ paalchu koj tijleꞌm u aqꞌonom vatz u bꞌaal taqꞌon. Tan oj nivixvaleꞌ, saixvalex majte. Oj nimali vunyol, sanimal veyol majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Loqꞌ tiꞌ koꞌn vunbꞌii kꞌuxh sichiꞌkꞌulaꞌex qꞌu aanima. Tan axhibꞌi yeꞌ tootzaj abꞌil vaꞌl vetchajonkꞌasuꞌlin. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Yeꞌn koj ulin, yeꞌn koj ul yolonin xoꞌl qꞌu aanima, yeꞌ tootzaj koj atziꞌ aas atil ipaav. Pek aatz cheel, saꞌtereꞌnkojchee iyol tiꞌ imujax qꞌul ipaav. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Tan abꞌil vaꞌl nichiꞌkꞌulaꞌin, antu nichiꞌkꞌula vunTat majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Yeꞌ tootzaj qꞌu aanima koj atziꞌ aas atil ipaav aas yeꞌn koj ul unbꞌan qꞌu kam tixoꞌl qꞌuꞌl yeꞌxhabꞌil koꞌxh vaꞌt nibꞌanon. Pek nikoꞌntixvaꞌin kꞌuxh vettillu qꞌu kam nunbꞌaneꞌ. Utz aꞌ nitixva vunTat majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Loqꞌ itzojpu chit u yol vaꞌl tzꞌibꞌamalka tu vimantaar nital ech tzaꞌ: «Yeꞌk koꞌxh tokebꞌal nitixvaꞌin qꞌu aanima.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Pek suꞌul u moxbꞌen etetz vaꞌl sunchaj kꞌasuꞌl xeꞌ vunTat. Ayaꞌ u Tioxhla Espiiritu, u iqꞌon tetz vinujul. Aꞌ tek sayolon viꞌ; satal qꞌu kam sete. ");
INSERT INTO ixlCNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Utz aatz ex, setxakbꞌaꞌ qꞌu kam viꞌ majte. Tan atilex sunkꞌatza tixeꞌtebꞌal. Ilel qꞌu kam setaqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Uncheeꞌ vetvallu qꞌu kam sete tzaꞌ tan, aꞌ unsaꞌ aas yeꞌxhkam saeesankaꞌex viꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tan saꞌnalojchalkꞌasuꞌlex tu qꞌu atibꞌal chusbꞌal tetz u oꞌtla mantaar. Utz saꞌnalopon maꞌl tiempo aas abꞌil sayatzꞌonex, iqꞌii u Tioxh nitoksa sataleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Utz ech siꞌan tziꞌ tan, yeꞌ tootzaj abꞌil vunTat utz, yeꞌ tootzaj abꞌil in. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Vetvallu kaael qꞌu kam sete tzaꞌ. Ech aatz loꞌopon u tiempo, letulsa sekꞌuꞌl aas alel tek sete vaqꞌo. Kꞌuxh yeꞌt val u kam sete tixeꞌtebꞌal tzaꞌ tan, atilin texoꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pek aatz cheel, seꞌenin xeꞌ vunTat vaꞌl vetchajonulin. Ech yeꞌxhabꞌil sachꞌotin ve aas: «¿Til maꞌtkꞌaxh?» Chaj koj. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Tan txumuꞌm okyu tetaanima cheel atziꞌ. Netxumun tu vaꞌl vetvalluka el sete tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pek vinujul nival sete aas bꞌaꞌn sabꞌenin. Tan oj yeꞌk sabꞌenin, yeꞌk suꞌul u moxbꞌen etetz. Ech sabꞌenin tan, seꞌnunchajuꞌl tzexeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Utz aatz lauli, sinach bꞌen vipaav qꞌu aanima taqꞌo tu u vatz amlika txꞌavaꞌ. Ech satootzaji abꞌiste vijikomal, abꞌiste yeꞌxtxoj utz, abꞌiste vinujul. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Satabꞌi vipaav qꞌu aanima tan, yeꞌ nimotxinimaꞌin. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Utz satabꞌi vijikomal tan, maꞌtꞌin xeꞌ vunTat utz, saꞌtereꞌnkojetil unvatz. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Utz satabꞌi vitxꞌolpu inujul qꞌu kam tu u vatz amlika txꞌavaꞌ tzaꞌ tan, tzꞌejaxyu yol tiꞌ u qꞌesalain tetz. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Sibꞌ tereꞌn koꞌxh kam siꞌchval sete, pek saꞌtereꞌnkojetii tiqꞌoleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pek aatz luꞌul u Tioxhla Espiiritu tetz vinujul, aꞌ saiqꞌon ebꞌey tiꞌ kajay vinujul. Tan yitꞌ iyol koj sijunal sataleꞌ. Pek aꞌ satal kajay vaꞌl satabꞌi kꞌatz vunTat. Utz aꞌ saꞌalon qꞌu kam sete qꞌuꞌl suꞌul taabꞌabꞌen. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Satoksa unqꞌii tan, vetz qꞌu yol sataleꞌ. Utz setootzaji taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Vetz qꞌu yol sataleꞌ tan, vetz kajay qꞌuꞌl atil xeꞌ vunTat. Ech tok vetvala aas setootzaji taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Utz bꞌiit koꞌxh siꞌaneꞌ, ech yeꞌkan setilin. Loqꞌ bꞌiit koꞌxh paj tuul saꞌpajetilin. Tan maꞌtꞌin xeꞌ vunTat.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Uncheeꞌ motx tek tal unjolol qꞌu chusulibꞌ sivatzaj ech tzaꞌ: —¿Kam tok vaꞌl nital qe tziꞌ? aas: «Bꞌiit koꞌxh siꞌaneꞌ, ech yeꞌkan setilin. Loqꞌ bꞌiit koꞌxh paj tuul saꞌpajetilin. Tan maꞌtꞌin xeꞌ vunTat.» Chia.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Utz nichmotxtal ech tzaꞌ: —¿Kan chaj tok vaꞌl nitaleꞌ tziꞌ? aas: «Bꞌiit koꞌxh setilin.» Chia. Yeꞌ tek qootzaj kam tok vaꞌl nitaleꞌ tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Uncheeꞌ tootzaji u Jesuus aas nichmotxtachva ichꞌotil te. Tal tek te ech tzaꞌ: —¿Ni tzik eyol sevatzaj vaꞌl vetval sete aas: «Bꞌiit koꞌxh siꞌaneꞌ, yeꞌkan setilin. Utz bꞌiit koꞌxh paj tuul saꞌpajetilin.» Chiꞌin? ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Niꞌxhtekꞌval sete aas saoqꞌex utz, satxumunex. Tuul sakoꞌntxuqꞌtxun qꞌu aanima tu u vatz amlika txꞌavaꞌ tzaꞌ. Loqꞌ aꞌtzii. Kꞌuxh satxumunex tan, saꞌnalbꞌen vetxumuꞌms txuqꞌtxunchil. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Echaꞌ maꞌl ixoj aas saꞌtekatin titzꞌin, atil tu chiꞌom. Tan oponyu vitiempo aas saitzꞌpu u titzꞌin. Pek aatz maꞌt tatin u tal titzꞌin, yeꞌkan nititzꞌa u chiꞌom tu txuqꞌtxunchil. Tan, itzꞌpi vaꞌt aanima tu u vatz amlika txꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Echat koꞌxh ex cheel majte. Atilex tu txumuꞌm. Loqꞌ saqꞌaavulvilex. Ech satxuqꞌtxun etaanima. Utz abꞌil koj sayaꞌsan vetxuqꞌtxunchil tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Utz aatz siꞌan tu u qꞌii tziꞌ, kam tereꞌn koj sechꞌoti ve. Tan niꞌxhtekꞌval sete aas sataqꞌ vunTat sete kajay vaꞌl sejaj te tunbꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tan ulyukoꞌxhex tzaꞌ tuul, yeꞌxhkam maꞌj nejaj tunbꞌii. Pek jajtaj utz, sekꞌuleꞌ. Ech tiira saꞌxhtxuqꞌtxunex. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Aatz cheel, kalabꞌ kam vetunkꞌam tiꞌ, tiꞌ talax qꞌu kam sete tzaꞌ. Pek saꞌnalul u tiempo aas yeꞌkan sunkꞌam tiꞌ kam tiꞌ talax qꞌu yol saval sete. Pek vatzsaj saval qꞌu kam sete tiꞌ vunTat. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Aatz siꞌan tu u qꞌii tziꞌ, jik techit ex sajajon qꞌu kam tu vunTat tu vunbꞌii. Yitꞌ in tereꞌn koj sajajon qꞌul ekam tu vunTat. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Utz tii vunTat setiꞌ majte tan, tiiꞌex viꞌ. Utz vetenimalaꞌ aas aꞌ vetkꞌaskuꞌlin xeꞌ u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Xeꞌ vunTat vetkꞌasuꞌlin, vetꞌulin tu u vatz amlika txꞌavaꞌ tzaꞌ. Pek saꞌtekvaqꞌka u vatz amlika txꞌavaꞌ tzaꞌ. Utz maꞌttepajin xeꞌ vunTat.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Uncheeꞌ alax te tu qꞌul ichusulibꞌ ech tzaꞌ: —Aatz cheel vatzsaj tek nayoloneꞌ. Yeꞌkan nakꞌam tiꞌ kam tayoloneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Elyu kutxumbꞌal tuul cheel aas nojchit ootzaj qꞌu kam kajayil. Utz yitꞌ ministeer koj sachꞌotil u tokebꞌal see. Echixeꞌat nikunima aas aꞌ vetkꞌaskuꞌlaxh xeꞌ u Tioxh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —¿Anal nenimaꞌin cheel? ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Aatz cheel tan, tul u tiempo utz, oponyu texhtuꞌ aas sepaxi etibꞌ. Til chaj texh sekꞌaj sejununil. Ech setaqꞌkaꞌin sunjunal. Pek loqꞌ yitꞌ unjunal koj atilin. Tan atil vunTat sunkꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Vetvallu qꞌu kam sete tziꞌ tan, aꞌ unsaꞌ aas saꞌatin paas tetaanima viꞌ. Kꞌuxh sapaalex tu kꞌaxkꞌo tu u vatz amlika txꞌavaꞌ tzaꞌ, kꞌujeꞌoj ekꞌuꞌl viꞌ tan, oleꞌyin tiꞌ isubꞌax u maalo tu u vatz amlika txꞌavaꞌ tzaꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Uncheeꞌ sajin jeꞌ u Jesuus tu amlika utz, tal ech tzaꞌ: —Tateey, oponyu u tiempo, sooksa unqꞌii, in aKꞌaol. Ech savoksa aqꞌii majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tan vetaaqꞌlu vijleꞌm tiꞌ taqꞌax itiichajil tu bꞌenqꞌii bꞌensaj qꞌu aanima qꞌuꞌl vettaqꞌ ve sinimaꞌin. ");
INSERT INTO ixlCNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Utz aꞌ u tiichajil tu bꞌenqꞌii bꞌensaj vaꞌl satootzajiꞌaxh qꞌu aanima. Tan taꞌxh maꞌl axh, axh nojla Tioxh. Utz satootzaji aas in u Jesucristo majte vaꞌl vetachajuꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Vetvoksal aqꞌii tu u vatz amlika txꞌavaꞌ tzaꞌ. Utz vetuntzojpixsal u aqꞌon vaꞌl vetaal ve sunbꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Pek aatz cheel Tateey, oksa unqꞌii sakꞌatza, echaꞌ u tok unqꞌii sakꞌatza aas yeꞌsajich iveet u vatz amlika txꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Vetvallu vabꞌii tu qꞌu aanima qꞌuꞌl vetaaqꞌ ve tu u vatz amlika txꞌavaꞌ tzaꞌ. Tan eetz nale utz, vetaaqꞌ ve. Ech vetmotxinimal vayolbꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Vetmotxtootzajil cheel aas aꞌ nikꞌaskuꞌl kajay qꞌu kam tzaxeꞌ qꞌuꞌl vetaaqꞌ ve. ");
INSERT INTO ixlCNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Utz vetvallu qꞌu yol te qꞌuꞌl vetaal ve utz, vetmotxikꞌula. Vetmotxtootzajil bꞌaꞌnil aas aꞌ vetkꞌaskuꞌlin tzaxeꞌ. Utz vetinimalaꞌ aas axh vetchajonin. ");
INSERT INTO ixlCNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ech nunqꞌila sikꞌleꞌaxh tiꞌ qꞌuꞌl vetaaqꞌ ve. Yitꞌ tiꞌ koj qꞌuꞌl tu u vatz amlika txꞌavaꞌ tzaꞌ, pek tiꞌ qꞌuꞌl eetz. ");
INSERT INTO ixlCNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tan eetz kajay qꞌu vetz. Utz vetz kajay qꞌuꞌl eetz. Utz tiꞌ vetok unqꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Yeꞌkan saꞌatinin tu u vatz amlika txꞌavaꞌ tzaꞌ tan, maꞌttexhin tzaxeꞌ. Pek saꞌatin qꞌu niman vetz tu u vatz amlika txꞌavaꞌ. Utz kola Tateey; xaannajelaxh kꞌatz paav. Kol tu vabꞌii jatvaꞌl qꞌuꞌl vetaaqꞌ ve. Ech maꞌl koꞌn iatz samotxiꞌaneꞌ, echaꞌ oꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Tan nichunkol tu vabꞌii aas ela atichꞌin tuchꞌ tu u vatz amlika txꞌavaꞌ tzaꞌ. Utz nikoꞌxh maꞌj tu qꞌuꞌl vetaaqꞌ ve, maꞌkojtzꞌejxi. Pek taꞌxh satzꞌejxi vaꞌl aꞌ chit tetz tzꞌejxichil. Loqꞌ itzojpu chit vayol tzꞌibꞌamalka. ");
INSERT INTO ixlCNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Pek aatz cheel tan, saꞌtekqꞌaavbꞌenin tzaxeꞌ. Utz siiꞌ nival qꞌu kam tu u vatz amlika txꞌavaꞌ tzaꞌ, ech tzꞌajel u txuqꞌtxunchil kꞌatza siꞌaneꞌ, echaꞌ vuntxuqꞌtxuneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Vetvallu vayolbꞌal te. Pek nikoꞌnmotxteesal iqꞌii tiꞌ tu qꞌu aanima tu u vatz amlika txꞌavaꞌ tzaꞌ. Axhibꞌi yitꞌ tetz tereꞌn koj u vatz amlika txꞌavaꞌ tzaꞌ. Echaꞌ in, yitꞌ in koj tetz u vatz txꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Loqꞌ aꞌ koj nunjaj see aas seesa bꞌen tu u vatz txꞌavaꞌ tzaꞌ. Pek aꞌ nunjajeꞌ aas sakol vatz u txꞌiꞌliꞌinaj. ");
INSERT INTO ixlCNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Tan yitꞌ tetz koj u vatz amlika txꞌavaꞌ tzaꞌ. Echaꞌ in aas in koj tetz u vatz amlika txꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Xaanseꞌl kꞌatz paav tiꞌ inimal vayolbꞌal. Tan aꞌ vinujul. ");
INSERT INTO ixlCNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kam echaꞌ machajtuꞌlin tu u vatz txꞌavaꞌ tzaꞌ, echat unchajtu bꞌen tu u vatz txꞌavaꞌ majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Utz tiꞌ qꞌu niman vetz tziꞌ, savaqꞌ vibꞌ tu kamchil. Ech saxaaneꞌl kꞌatz paav taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Loqꞌ yitꞌ taꞌn koꞌnkoxh nunqꞌila sikꞌleꞌaxh tiꞌ qꞌu niman vetz. Pek nunqꞌila sikꞌleꞌaxh tiꞌ tereꞌn qꞌuꞌl saꞌnalnimanin tu qꞌul iyol majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ech maꞌl koꞌn iatz siꞌaneꞌ sikajayil. Echaꞌ axh tuchꞌ in Tateey. Utz echaꞌ in sauchꞌ majte. Maꞌl koꞌn saelku sukukꞌatza. Ech sinima qꞌu aanima tu u vatz amlika txꞌavaꞌ tzaꞌ aas axh vetchajonkꞌasuꞌlin. ");
INSERT INTO ixlCNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Utz vetvaqꞌlu tetz u tokebꞌal unqꞌii vetaaqꞌa. Ech maꞌl koꞌn iatz samotxiꞌaneꞌ. Echaꞌ in sauchꞌ aas maꞌl koꞌn oꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","In tiꞌ utz, axh viꞌ. Ech tiira tzꞌajel tu vibꞌantu maꞌl iatz siꞌaneꞌ. Utz samotxtootzaji qꞌu aanima tu u vatz amlika txꞌavaꞌ aas axh vetchajonin utz, tiiꞌaxh tiꞌ. Echaꞌ aꞌantu tii viꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tateey, aꞌ unsaꞌ aas aꞌ samotxatinku sunkꞌatza tu vaꞌl saꞌatinkꞌin, jatvaꞌl qꞌuꞌl vetaaqꞌ ve. Ech samotxtil u tokebꞌal unqꞌii aqꞌel saaqꞌo. Tan kꞌonel nal avaanima viꞌ ayaꞌxchen yeꞌsajich ichee u vatz amlika txꞌavaꞌ tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Unjikomla Tat, yeꞌ tootzajaxh qꞌu aanima tu u vatz amlika txꞌavaꞌ tzaꞌ. Pek ootzajimalaxh vaqꞌo. Utz aatz qꞌuꞌl nimanyin tziꞌ, vetmotxtootzajilaꞌ aas axh vetchajonkꞌasuꞌlin. ");
INSERT INTO ixlCNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Vettootzajil vabꞌii vaqꞌo. Utz saꞌtereꞌntootzaji vaqꞌo majte. Ech kam ech aꞌantu tiiꞌaxh viꞌ, echat koj iꞌantu tii tibꞌilaj. Ech saꞌatinin kꞌatza.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Uncheeꞌ kꞌasuꞌl u Jesuus aas maꞌtich taltu qꞌu kam tziꞌ. Motx bꞌen salabꞌen u tal aꞌ Cedroon, tu vaꞌl atichku untanul chikobꞌeꞌm. Ech okoꞌp tuul tuchꞌ qꞌul ichusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Utz tootzajich u chikobꞌeꞌm u Judas vaꞌl siꞌchkꞌuchun u Jesuus tu qꞌu txayol tetz. Tan jatpajul koꞌn maꞌtich topon u Jesuus tziꞌ tuchꞌ qꞌul ichusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ech kꞌasuꞌl untanul sol tiꞌ u Judas tuchꞌ unjolol xeen tetz vikuentail u totztioxh. Aꞌ chajon kꞌasuꞌl tiꞌ qꞌu qꞌesal oksan yol vatz Tioxh tuchꞌ qꞌu fariseo. Ech jolol iqꞌomich itzaa txijtxubꞌal aas opon tziꞌ. Utz jolol iqꞌomich ichꞌichꞌ majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Aatz u Jesuus tan, tootzajich tekuꞌen kam vaꞌl siꞌchuchi. Ech bꞌaxal ul ikꞌuleꞌ. Tal te ech tzaꞌ: —¿Abꞌil nechokeꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Utz tzaqꞌbꞌel ech tzaꞌ: —Aꞌ nikuchok u Jesuus aa Nazareet.— Texh teꞌleꞌ. Tal u Jesuus te: —In.— Texhtuꞌ. Utz atich ok u Judas tixoꞌl vaꞌl oksan tiqꞌabꞌ qꞌu txayol tetz. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ech taꞌxh veet taltu te aas: —In.— Texh u Jesuus, motx bꞌijbꞌoch iqꞌaav tiꞌ iqul. Utz motx tꞌiꞌp kuꞌ vatz txꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Uncheeꞌ qꞌaav paj chꞌotil te tu u Jesuus ech tzaꞌ: —¿Abꞌil nechokeꞌ?— Texh te. Motx tzaqꞌbꞌu ech tzaꞌ: —Aꞌ nikuchok u Jesuus aa Nazareet.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Utz tal u Jesuus te ech tzaꞌ: —Vetvallu sete aas in. Oj in koꞌxh nechokꞌin, aqꞌtaj tzii aas sabꞌen qꞌul unchusulibꞌ tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tal ech tziꞌ tan, itzojpu chit viyol vaꞌl tala aas: —Yeꞌxhkam vetuntzꞌej maꞌj tu qꞌuꞌl vetaaqꞌ ve.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Utz iqꞌomich maꞌl ichꞌichꞌ u Xhim, val Luꞌ majte. Utz ijuu jeꞌul tu u totzotz. Tzokꞌoni; itzokꞌeꞌl sebꞌal ixichin u taqꞌonom u qꞌesal oksan yol vatz Tioxh. Malco ibꞌii u aqꞌonom tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pek tal u Jesuus tu u Luꞌ ech tzaꞌ: —Aqꞌ koꞌp vachꞌichꞌ tu totzotz tziꞌ. Tan ministeer unpaal tu u il tzaꞌl vaꞌl vettaqꞌuꞌl vunTat viꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Uncheeꞌ txayax u Jesuus tu qꞌu qꞌesal sol tuchꞌ qꞌul isol utz, tuchꞌ qꞌu xeen totztioxh qꞌuꞌl chajax tu qꞌesal uqꞌaybꞌal. Utz iqitza. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ech aꞌ bꞌaxal motx tiqꞌov bꞌen vatz u Anaas, vijiꞌ u Caifaas vaꞌl qꞌesal oksan yolich vatz Tioxh tu u yaꞌbꞌ tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","U Caifaas vaꞌl maꞌtich alon tu qꞌu qꞌesal uqꞌaybꞌal aas aal bꞌaꞌn maꞌl koꞌn vinaj sakam tiꞌ qꞌu tenam kajayil. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Uncheeꞌ aatz u Xhim, vaꞌl Luꞌ ibꞌii majte, xamich tiꞌ u Jesuus. Aꞌich imol vaꞌt u chusulibꞌ vaꞌl tootzajich tibꞌ tuchꞌ u qꞌesal oksan yol vatz Tioxh. Ech aqꞌax tzii okoꞌp tiꞌ u Jesuus vatz qꞌanal. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pek aatz u Luꞌ, atichka tiꞌ eluꞌl u qꞌanal vatz jubꞌal. Ech teluꞌl u chusulibꞌ vaꞌl tootzajich tibꞌ tuchꞌ u qꞌesal oksan yol vatz Tioxh. Utz iqꞌila u xeen tziꞌ peꞌ. Tal te aas sichaj okoꞌp u Luꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Utz aatz u ixoj kꞌulanal vaꞌl nichxeen u tziꞌ peꞌ, tal tu u Luꞌ ech tzaꞌ: —¿Yitꞌ tzik ant axh, axh ichusulibꞌ u vinaj majte tziꞌ?— Texhtuꞌ. Utz tal u Luꞌ ech tzaꞌ: —¡Yitꞌ antu koj in!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ech jolol txaklich ok tziꞌ xamal qꞌu aqꞌonom tuchꞌ qꞌu xeenal. Nichmotxilee tibꞌ. Maꞌtich motx toksat maꞌl xamal tan, kaanaich cheꞌv. Ech antu txaklich ok tixoꞌl u Luꞌ. Nichilee tibꞌ majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Aatz u qꞌesal oksan yol vatz Tioxh, ichꞌoti itziꞌ u Jesuus tiꞌ qꞌul ichusulibꞌ utz, tiꞌ vichusbꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Loqꞌ tzaqꞌbꞌu koꞌn u Jesuus ech tzaꞌ: —Vatzsaj nunyolon vatz tenam kajayil. Chajpaj nunchusuneꞌ, aꞌ nunbꞌanvu tu viqꞌanalil u totztioxh tuchꞌ tu qꞌu atibꞌal chusbꞌal tetz u oꞌtla mantaar vaꞌl nimolvu tibꞌ qꞌu qꞌesal uqꞌaybꞌal. Ech yeꞌxhkam maꞌj kam jutzimal koj talax nunbꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ech ¿kam tokeꞌ nachꞌoti ve? Aal bꞌaꞌn aꞌ sachꞌotiv tu qꞌu aanima qꞌuꞌl abꞌinnaj unyoloneꞌ. Tan tootzajle kam alel vaqꞌo.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Taꞌxh veet tal u kam u Jesuus tziꞌ, paqꞌax ok txala itziꞌ tu maꞌl qꞌu xeenal atich tziꞌ. Utz tal te ech tzaꞌ: —¿Kam tokeꞌ aas ech itzaqꞌbꞌel u qꞌesal oksan yol vatz Tioxh naꞌaneꞌ tziꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Oj yeꞌxtxoj maꞌj kam tu vaꞌl vetvala, ala kam u yeꞌxtxoj. Pek oj bꞌaꞌn utz, ¿kantuꞌ naqꞌosin?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ech chajax tek bꞌen u Jesuus tu u Anaas xeꞌ u Caifaas, vaꞌl qꞌesal oksan yolich. Qitzel ibꞌen iꞌana. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Uncheeꞌ txaklich u Luꞌ tziꞌ xamal, nichilee tibꞌ. Utz alax paj te ech tzaꞌ: —¿Yitꞌ tzik ant axh, axh ichusulibꞌ?— Texh teꞌleꞌ. Loqꞌ teesa koꞌn tibꞌ u Luꞌ tuul ech tzaꞌ: —Yitꞌ antu koj in.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Pek atich maꞌl tu qꞌu taqꞌonom u qꞌesal oksan yol vatz Tioxh tixoꞌl. Titzꞌin tatzikich u vinaj vaꞌl tzokꞌax el ixichin tu u Luꞌ. Tal te ech tzaꞌ: —¿Oj tzik yeꞌn vilaxh? tan, aꞌ amol xoꞌl u chikobꞌeꞌm.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Loqꞌ teesa koꞌn paj tibꞌ u Luꞌ tuul. Tuul oqꞌ tek u bꞌaal tꞌel. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Uncheeꞌ aatz qꞌalaꞌmich tekuꞌen, iqꞌol kꞌasuꞌl u Jesuus tu u totzotz u Caifaas. Utz ex aqꞌaxoj tu u bꞌanbꞌal topiisyo u governadoor. Loqꞌ yeꞌt okoꞌp qꞌu qꞌesal uqꞌaybꞌal toꞌotzotz. Tan txaaꞌ vatz qꞌul imantaar, yeꞌt motx iyansa tibꞌ. Ech saveeti satechbꞌu u echbꞌubꞌal vaꞌl nitechbꞌul tiꞌ u Elchil Vatz Kamchil Tu Egipto. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ech eluꞌl u Pilato siatz, tal te ech tzaꞌ: —¿Kam tiꞌ nexochvu u vinaj tziꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Motx tzaqꞌbꞌu ech tzaꞌ: —Yeꞌk koj maꞌj ipaav u vinaj tziꞌ, yeꞌn qiqꞌo ul tzaꞌ koj atziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ech tal tek u Pilato ech tzaꞌ: —Iqꞌotaj bꞌen utz, txꞌoltaj inujul tu vemantaar.— Texh te. Pek alax te tu qꞌu qꞌesal uqꞌaybꞌal ech tzaꞌ: —Yitꞌ aqꞌel koj tzii qe aas sakuyatzꞌ maꞌj aanima.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Kꞌuxh motx tal ech tziꞌ tan, itzojpu chit viyol u Jesuus vaꞌl tala aas kaniꞌch ikam sakami. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ech qꞌaavpajokoꞌp u Pilato tu u bꞌanbꞌal topiisyo. Isikꞌle ok u Jesuus tiꞌ utz, tal te: —¿Axh tzik u tijlenal qꞌu Israeel siꞌaneꞌ tziꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —¿Sakꞌuꞌl chixh nicheek vaꞌl nachꞌoti ve tziꞌ, pek oj alel u kam see viꞌ tziꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Tzaqꞌbꞌel tu u Pilato ech tzaꞌ: —¿Tzꞌoj tzik in Israeel? Pek qꞌul eetz aa tenamil tuchꞌ qꞌu qꞌesal oksan yol nixochonaxh sunvatz. ¿Kam paav vetaꞌana?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Yitꞌ aꞌ koj sunbꞌanvu vunQꞌesalail tu u vatz amlika txꞌavaꞌ tzaꞌ. Tan samotxchꞌaꞌoin qꞌu niman vetz viꞌ atziꞌ aas aꞌ koj sunbꞌanva. Yeꞌk sataqꞌ tzii sakuꞌin tiqꞌabꞌ qꞌu qꞌesal uqꞌaybꞌal koj. Ech yitꞌ aꞌ koj sunbꞌanvu vunQꞌesalail tu u vatz amlika txꞌavaꞌ tzaꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Tal paj u Pilato te ech tzaꞌ: —Uncheeꞌ ¿axh u ijlenal siꞌaneꞌ?— Texh te. Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Axh nialon aas in ijlenal. Pek aꞌ untxaꞌk vetitzꞌpꞌin. Utz ech untxaꞌk vetꞌulin tu u vatz amlika txꞌavaꞌ, tiꞌ ul talax vinujul. Utz abꞌil vaꞌl atil tu vinujul, nitabꞌi qꞌu kam nivaleꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Tal u Pilato te ech tzaꞌ: —Utz ¿kam vinujul?— Texhtuꞌ. Ech taꞌxh tala, elpajul vatz qꞌu qꞌesal uqꞌaybꞌal. Tal te ech tzaꞌ: —Yeꞌk maꞌj paav nivil kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pek kostuumbre nal texoꞌl aas nichajpul maꞌl preexhu tu u nimla qꞌii tiꞌ u Elchil Vatz Kamchil Tu Egipto. Ech ¿aꞌ tzik esaꞌ aas aꞌ sunchajpu vaꞌl ijlenal texoꞌl ex Israeel?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ech kajay qꞌu mam tenam qetun taltu ech tzaꞌ: —¡Yeꞌka, yitꞌ aꞌ koj sachajpu vaꞌl tziꞌ! Pek ¡aꞌ sachajpu u Barrabaas!— Texhtuꞌ. Utz aatz u Barrabaas tan, elqꞌomich. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Uncheeꞌ aatz u Pilato, tal itzꞌuꞌmal u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Utz motx ipaꞌtxꞌu maꞌl chꞌiꞌx koroona qꞌu sol majte. Taqꞌ jeꞌ tiviꞌ u Jesuus. Utz toksa vaꞌt qꞌej kaj oksaꞌm kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ech nichmotxtal tu u Jesuus ech tzaꞌ: —¡Techal axh, ijlenal tetz qꞌu Israeel!— Chu te. Tuul nichipaqꞌoꞌk. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Uncheeꞌ elpajul unpat u Pilato vatz qꞌu qꞌesal uqꞌaybꞌal utz, tal te ech tzaꞌ: —Iltaj bꞌaꞌnil etileꞌ. Vetviqꞌol eluꞌl sevatz utz, ootzajitaj tan, yeꞌk maꞌj paav bꞌanel taqꞌo nivileꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ech eluꞌl u Jesuus. Atich jeꞌ u chꞌiꞌx koroona tiviꞌ. Utz atoꞌk u qꞌej kaj oksaꞌm taqꞌo. Utz tal u Pilato ech tzaꞌ: —Aatz cheel, nivaqꞌka u vinaj teqꞌabꞌ tzaꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Utz taꞌxh ilax u Jesuus tu qꞌu qꞌesal oksan yol tuchꞌ qꞌu xeenal, motx qꞌeqꞌun tal tu ech tzaꞌ: —¡Jeꞌoj vatz kurus! ¡Jeꞌoj vatz kurus!— Texhtuꞌ. Pek tal u Pilato te ech tzaꞌ: —Iqꞌotaj bꞌen. Utz ex saꞌaqꞌon jeꞌ vatz kurus. Pek ech koj tan, yeꞌxhkam niꞌan nivileꞌ; yeꞌk ipaav.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Utz tzaqꞌbꞌel tu qꞌu qꞌesal uqꞌaybꞌal ech tzaꞌ: —Aatz oꞌ, atil maꞌl kumantaar. Utz kamchil siꞌaneꞌ echaꞌ nital u kumantaar. Tan kam tokeꞌ aas nitaqꞌ bꞌens tibꞌ ikꞌaol Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ech aal chit xoꞌv u Pilato aas tabꞌi u yol tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ech qꞌaavoꞌk u Pilato tu u bꞌanbꞌal topiisyo utz, tal tu u Jesuus ech tzaꞌ: —¿Til aanimail axh?— Texh te. Pek yeꞌt tzaqꞌbꞌel tu u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Uncheeꞌ alax paj te tu u Pilato ech tzaꞌ: —¿Kantuꞌ yeꞌ natzaqꞌbꞌeꞌin? ¿Yetz ootzaj tzik aas atil vijleꞌm saval ajeꞌ vatz kurus utz; atil vijleꞌm sunchajpuꞌaxh?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Tzaqꞌbꞌu u Jesuus utz, tala: —Kam koj iijleꞌm saꞌatin viꞌ oj yitꞌ u Tioxh koj saꞌaqꞌon tzii see. Pek aꞌtzii. Tan aꞌ maas ataj paav qꞌuꞌl vetoksanin taqꞌabꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ech aatz u Pilato, titzꞌa kaniꞌch ichajpul siꞌan tu u muꞌkꞌul tziꞌ. Pek nichmotxiqꞌeqꞌun taltu qꞌu tenam ech tzaꞌ: —¡Untzꞌoj sachajpu vaꞌl tziꞌ, yitꞌ axh koj tamiigo u ijlenal Cesar! Tan abꞌiste vaꞌl nitektaqꞌ bꞌen tibꞌs ijlenal, aꞌ niqel u Cesar.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ech taꞌxh tek tabꞌi u kam u Pilato tzaꞌ, taqꞌ eluꞌl u Jesuus qꞌanal. Utz kꞌujeꞌ u Pilato tu u qꞌatbꞌal tzii, vaꞌl Gaabata ibꞌii tu yolbꞌal hebreo, vaꞌl nukꞌel kuꞌ sivan tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Aꞌ chit ibꞌanax u kam tziꞌ, aas siꞌchtexhxeꞌt u nimla qꞌii. Aꞌ chit nichtekiꞌankeꞌl tuch tibꞌ qꞌu aanima. Utz chaqꞌaal qꞌiich tekuꞌen. Tal u Pilato tu qꞌu qꞌesal uqꞌaybꞌal ech tzaꞌ: —Aatz cheel, atil vetijlenal tzuta.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pek motx koꞌn xeꞌt iqꞌeqꞌun ech tzaꞌ: —¡Paaloj el! ¡Paaloj el! ¡Jeꞌoj vatz kurus!— Texhtuꞌ. Tal tek u Pilato te ech tzaꞌ: —¿Savaqꞌ jeꞌ vetijlenal vatz kurus?— Texhtuꞌ. Tzaqꞌbꞌu qꞌu qꞌesal oksan yol vatz Tioxh ech tza: —Yeꞌk vaꞌt qijlenal tiꞌ u Cesar.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Uncheeꞌ taqꞌka u Jesuus tikuenta; sataqꞌ jeꞌ vatz kurus. Ech iqꞌol kꞌasuꞌl u Jesuus tu qꞌu aanima tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Uncheeꞌ ijamich maꞌl u kurus tu u Jesuus aas kꞌasuꞌl. Aalich ibꞌen tu u txꞌavaꞌ Tatibꞌal Bꞌajil Viꞌ; Goolgota tu u yolbꞌal hebreo. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tan latziꞌ motx taqꞌvu jeꞌ u Jesuus vatz kurus. Ant imol kaꞌvaꞌt vinaj jeꞌ vatz kurus. Jununil sitxala u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ech tal itzꞌibꞌal maꞌl u yol u Pilato vatz vikurus u Jesuus. Nichtal ech tzaꞌ: “JESUUS AA NAZAREET TIJENAL QꞌU ISRAEEL.” Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Utz sibꞌal qꞌu Israeel siꞌklen qꞌu yol tziꞌ tan, axhibꞌi najaꞌch koꞌn u tenam aqꞌlik jeꞌ u Jesuus vatz kurus. Utz oxvaꞌl yolbꞌal tzꞌibꞌalik u yol majte tziꞌ: tu u yolbꞌal hebreo, tu u yolbꞌal griego, tuchꞌ tu u yolbꞌal latiin. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ech motx tek tal qꞌu qꞌesal oksan yol vatz Tioxh xoꞌl qꞌu Israeel tu u Pilato ech tzaꞌ: —Yeꞌ koꞌxh atzꞌibꞌa aas: “Tijlenal Qꞌu Israeel,” chaꞌaxh. Pek aꞌ satzꞌibꞌa aas: “Aꞌ Koꞌxh Nialon Aas Tijlenal Qꞌu Israeel,” chajaxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Tzaqꞌbꞌu u Pilato ech tzaꞌ: —Taꞌxhtuꞌ vetuntzꞌibꞌalaꞌ kam vetuntzꞌibꞌalaꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Uncheeꞌ taꞌxh tek veet ijeꞌ u Jesuus vatz kurus tu qꞌu sol, motx tiqꞌo kꞌasuꞌl qꞌu toksaꞌm. Kaavaꞌl taqꞌ kuꞌ tuul. Jununil tetz junun sol iꞌana. Antu motx tiqꞌo kꞌasuꞌl u toksaꞌm vaꞌl chemich chelkin bꞌuꞌj, yitꞌ tzꞌisel koj. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ech motx tek tal sivatzaj ech tzaꞌ: —Yeꞌk sakuqꞌix tuul. Pek kubꞌantaj saach tiꞌ. Ech saqileꞌ abꞌil bꞌoj etz liꞌana.— Texhtuꞌ. Loqꞌ itzojpu chit u yol vaꞌl tzꞌibꞌamalka ech tzaꞌ: —Motx ijatx qꞌu voksaꞌm siatzaj. Iꞌan bꞌul tiꞌ.— Chia. Utz anchituꞌ. Ech motx iꞌan qꞌu sol. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Uncheeꞌ atich opon vinan u Jesuus kꞌatz u kurus, tuchꞌ vitzaꞌqꞌ vinan. Antu u Liꞌ, u tixoj u Cleofas, tuchꞌ u Liꞌ aa Magdala. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ech sajin kuꞌl u Jesuus; til vinan. Utz til u chusulibꞌ majte vaꞌl tiich chit tiꞌ. Tan atich opon. Utz tal tek u Jesuus tu vinan ech tzaꞌ: —Nan, aꞌ tek iitzꞌin vaꞌl tzuta.— Texh tiꞌ u chusulibꞌ vaꞌl tiich chit tiꞌ u Jesuus ti. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Utz tal tu u chusulibꞌ ech tzaꞌ majte: —Aꞌ tek anan vunnan tziꞌ.— Texh te. Ech aatz u chusulibꞌ tziꞌ, yakich tiqꞌo bꞌen vinan u Jesuus tiꞌ tu tatibꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Uncheeꞌ xamtich tek tiꞌ u kam tzaꞌ, tootzajich u Jesuus aas maꞌt tek itzojpu kajay qꞌu kam ul iꞌaneꞌ. Tal tek ech tzaꞌ: —Nitzaj untziꞌ.— Texhtuꞌ. Loqꞌ itzojpu chit qꞌu yol tzꞌibꞌamalka. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Utz atich maꞌl u xhaaro tziꞌ, noonaj minaagre tuul. Ech jilul maꞌl u nuqꞌkin bꞌuꞌj tuul, qitzax ok tiꞌ maꞌl u tzeꞌ hisopo. Ech taqꞌ jiꞌop titziꞌ u Jesuus, sitzꞌutzꞌeꞌl taaꞌ tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ech taꞌxh veet itzꞌutzꞌteꞌl u minaagre u Jesuus tziꞌ, tal ech tzaꞌ: —¡Kajay vettiqꞌol tibꞌ!— Texhtuꞌ. Ech inakbꞌaꞌ kuꞌ iviꞌ utz, kami. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Uncheeꞌ bꞌen qꞌu qꞌesal uqꞌaybꞌal xeꞌ u Pilato. Ex ijajabꞌe aas sapaxil vatz tajan qꞌuꞌl atich jeꞌ vatz kurus. Oora sakamsali, ech saeesal vatz kurus. Tan aꞌ isaꞌ yeꞌk sakaa vatz kurus tu u ilanbꞌal qꞌii vaꞌl siꞌchtexhxeꞌti. Tan nichtekiꞌankeꞌl tuch tibꞌ qꞌu aanima tan, sibꞌ tatin u ilanbꞌal qꞌii siatz vaꞌl nichipaal tiꞌ u Elchil Vatz Kamchil Tu Egipto. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Anchituꞌ. Motx opon qꞌu sol. Utz ipaxi vatz tajan u bꞌaxa vaꞌl aqꞌax jeꞌ vatz kurus kꞌatz u Jesuus. Tan yeꞌsajich ikameꞌ. Utz echat iꞌan tu vaꞌt vaꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pek aatz motx opon kꞌatz u Jesuus, tila maꞌtich ikameꞌ. Yeꞌt ipaxi veꞌt vatz tajan. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Loqꞌ aatz maꞌl u sol, itzokꞌ txala tuul u Jesuus tu maꞌl lanza. Utz oora eluꞌl kaj tuul tuchꞌ aꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Utz aꞌ nialon qꞌu kam tzaꞌ vaꞌl ilon. Utz noj vaꞌl nitaleꞌ. Tekꞌ tootzajle aas inujul vaꞌl nitaleꞌ. Ech motxoj enima majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Tan kꞌuxh yeꞌt paxil vatz tajan u Jesuus, aꞌ tzojpi u yol tzꞌibꞌamalka ech tzaꞌ: —Yitꞌ saꞌkojpaxil ibꞌajil.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Utz echat nital vaꞌt u yol majte vaꞌl tzꞌibꞌamalka aas: —Saꞌnalilax vaꞌl paasal chꞌichꞌ txala tuul.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Uncheeꞌ xamtich tek tuul, ex ijaj bꞌaꞌnil u Xhep aa Arimatea tu u Pilato aas satiqꞌo bꞌen vichiꞌl u Jesuus. Ech aqꞌax tzii te tu u Pilato. Utz bꞌeni, ex teesa kuꞌl vichiꞌl u Jesuus vatz kurus. Aatz u Xhep tziꞌ tan, nimanich tetz u Jesuus. Pek yeꞌ koꞌn naꞌl nichiꞌaneꞌ. Tan aꞌ nichixoꞌvaꞌ qꞌu qꞌesal uqꞌaybꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Antu opon u Nicodemo majte, vaꞌl opon xeꞌ u Jesuus tu aqꞌbꞌal. Iqꞌomich txꞌumqꞌixsabꞌal taqꞌo, mirra tuchꞌ aaloe. Kamal maꞌj kintaal. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ech motx tiqꞌo kꞌasuꞌl vichiꞌl u Jesuus. Utz ibꞌachoꞌk tu bꞌaꞌnla bꞌuꞌj. Toksa vichiꞌl tu qꞌu bꞌaꞌnla chaj txꞌumqꞌixsabꞌal. Tan ech u kostuumbre xoꞌl qꞌu Israeel tiꞌ imujax kamchil. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Uncheeꞌ atich maꞌl u chikobꞌeꞌm tu u lugaar vaꞌl aqꞌaxku jeꞌ u Jesuus vatz kurus tziꞌ. Utz atich maꞌl akꞌ jul vatz sivan xoꞌl u chikobꞌeꞌm. Yeꞌsajich tok maꞌj kamnaj tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ech mujax texh u Jesuus tziꞌ tan, siꞌchtexhxeꞌt u nimla qꞌii. Utz najaꞌ u mujbꞌal majte. Tan aꞌ tek nichiꞌankeꞌl tuch tibꞌ qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Uncheeꞌ aatz iꞌan tu u bꞌaxa qꞌii tetz u xhemaana, kuꞌsaj chit bꞌen u Liꞌ aa Magdala tu u mujbꞌal tetz u Jesuus. Ankoꞌxh ukenich tereꞌn. Utz aꞌ tek tila elnajich u sivan, u jupibꞌ itziꞌ u jul. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ech tꞌaspu ibꞌenaꞌ, bꞌen xeꞌ u Xhim, vaꞌl Luꞌ ibꞌii majte, tuchꞌ xeꞌ u chusulibꞌ vaꞌl tiich chit u Jesuus tiꞌ. Utz tal te ech tzaꞌ: —¡Eesali bꞌen u kuBꞌaal tu mujbꞌal tetz utz, yeꞌ qootzaj til chaj ex aqꞌlojka!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ech elbꞌen u Luꞌ tuchꞌ vaꞌt u chusulibꞌ, bꞌen tu u mujbꞌal tetz. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ela tꞌaspu ibꞌen sikaꞌbꞌil. Pek maas tꞌaspu vaꞌt u chusulibꞌ vatz u Luꞌ. Ayaꞌ vimol. Ech bꞌaxal opon tu u mujbꞌal tetz u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Loqꞌ yeꞌt okoꞌp tu u jul. Pek ikꞌoꞌbꞌaꞌ kuꞌ tibꞌ, sajin okoꞌp tuul. Utz taꞌxh til qꞌu bꞌuꞌj atichka tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ech opon tek u Xhim, vaꞌl Luꞌ ibꞌii majte utz, bꞌenoꞌk tu u jul. Til qꞌu bꞌuꞌj atichka tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Loqꞌ aatz u bꞌuꞌj vaꞌl bꞌachichku iviꞌ u Jesuus, yitꞌ atich koj ok xoꞌl qꞌu liikin bꞌuꞌj. Pek paarten tek bꞌochichku bꞌen. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ech okoꞌp u chusulibꞌ tu u jul majte, vaꞌl bꞌaxal oponi. Utz tila aas yeꞌkanich tek u Jesuus. Ech nal tek inima vaꞌl alax te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tan yeꞌsajich tel itxumbꞌal tu u yol tzꞌibꞌamalka aas ministeer saqꞌaavitzꞌpu u Jesuus xoꞌl qꞌu kamnaj. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ech qꞌaavtekbꞌen qꞌu chusulibꞌ tu tatibꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pek aatz u Liꞌ, nichtoqꞌ tziꞌ u jul aal teluꞌl. Utz ikꞌoꞌbꞌaꞌ kuꞌ tibꞌ, sajin okoꞌp tu u jul, tuul nichtoqꞌeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Utz til kaꞌvaꞌl aanjel; saj oksaꞌm. Kꞌujlich maꞌl tiviꞌ vaꞌl atichku vichiꞌl u Jesuus utz; vaꞌt tu tajan. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ech tal tu u Liꞌ ech tzaꞌ: —Ixoj, ¿kantuꞌ nooqꞌeꞌ?— Texh teꞌleꞌ. Tal u Liꞌ ech tzaꞌ: —Nivoqꞌeꞌ tan, iqꞌol ibꞌen vunBꞌaal. Utz yeꞌ vootzaj til ex aqꞌlojka.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Taꞌxh veet tal u kam tziꞌ, sajin tiꞌ iqul. Utz aꞌ tek tila atich u Jesuus tziꞌ. Loqꞌ yeꞌich tootzaj oj u Jesuusich. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Uncheeꞌ tal u Jesuus te ech tzaꞌ: —Ixoj, ¿kantuꞌ nooqꞌeꞌ? ¿Abꞌil nachokeꞌ?— Texh te. Aatz u Liꞌ tan, aꞌ titzꞌa aas u xeen chikobꞌeꞌm vaꞌl nichqꞌilan. Tal te ech tzaꞌ: —Bꞌaal nitxaꞌ, untzꞌoj axh vetiqꞌon bꞌen vunBꞌaal, al ve til ex aaqꞌva. Ech seꞌnviqꞌo.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —¡Liꞌ!— Texh te. Ipilqꞌu tek tibꞌ u Liꞌ. Utz tal te ech tzaꞌ: —¡Raboni!— Texh te. “Chusul” chu u tokebꞌal tu u yolbꞌal hebreo. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Tal u Jesuus te ech tzaꞌ: —Chajpuꞌin. Tan yeꞌsaj unbꞌenjeꞌ xeꞌ vunTat tu Amlika. Pek kuxh xeꞌ qꞌu vitzꞌin vatzik, qꞌul unchusulibꞌ utz, al te ech tzaꞌ: «Maꞌtjeꞌin xeꞌ vunTat, ayaꞌ u kuTat; xeꞌ vunTioxh, ayaꞌ u kuTioxh. Chia.» Chajaxh te.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ech ibꞌen u Liꞌ, u aa Magdala utz, ex tal u bꞌaꞌnla yol tu qꞌu chusulibꞌ aas maꞌtich tiltu u kuBꞌaal. Utz tal te kam tal u Jesuus te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Uncheeꞌ ankoꞌxh tu u bꞌaxa qꞌii tetz u xhemaana tziꞌ, sotzsaj tekuꞌen, katxꞌumich tibꞌ qꞌu chusulibꞌ tu vaꞌl molichku tibꞌ. Tan aꞌ nichixoꞌva qꞌu qꞌesal uqꞌaybꞌal. Utz ¡aꞌ texh til txaklich u Jesuus tixoꞌl! Tal ech tzaꞌ: —¡Atoj paas tetaanima!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ech taꞌxh veet tal u kam tziꞌ, ikꞌuch qꞌul iqꞌabꞌ te tuchꞌ u txala tuul vaꞌl akꞌoni. Ech motx chit txuqꞌtxun qꞌu chusulibꞌ aas tiltu u kuBꞌaal tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Utz tal paj u Jesuus te ech tzaꞌ: —¡Atoj paas tetaanima! Utz kaniꞌch michajtukꞌasuꞌlin vunTat, echat echajax bꞌen nunbꞌaneꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Taꞌxh veet taltu u kam tziꞌ, ixuli ok kajiqꞌ kꞌatza. Utz tal te ech tzaꞌ: —Kꞌultaj u Tioxhla Espiiritu. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Utz abꞌil sekuy ipaav, sakuylu vipaav. Pek abꞌil aꞌ yeꞌk sekuy ipaav, yeꞌk sakuyax majte.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Pek aatz u Maxh, yeꞌkich xoꞌl qꞌu chusulibꞌ aas opon u Jesuus bꞌaxa. Ayaꞌ maꞌl tu kabꞌlaal qꞌu chusulibꞌ vaꞌl Diidimo ibꞌii majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ech alax te tunjot qꞌu chusulibꞌ ech tzaꞌ: —¡Vetqillu u kuBꞌaal!— Texh te. Pek tal ech tzaꞌ: —Yitꞌ saꞌkojunnima aas qꞌaav itzꞌpia, untzꞌoj yeꞌk savil qꞌu echlal tiqꞌabꞌ u tokebꞌal qꞌu laauxh utz, savoksa viꞌ unqꞌabꞌ tuul. Saꞌkojunnima oj yeꞌk savaqꞌ okoꞌp u viꞌ unqꞌabꞌ tu u txala tuul vaꞌl tzokꞌli.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Uncheeꞌ vaaxajilich tek qꞌii tuul, atich paj qꞌu chusulibꞌ toꞌotzotz. Utz atich tek u Maxh tixoꞌl. Tuul aqꞌbꞌu u Jesuus kꞌuxh jupich otzotz. Utz toksa tibꞌ tixoꞌl. Tal te ech tzaꞌ: —¡Atoj paas tetaanima!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tal tek tu u Maxh ech tzaꞌ: —Il qꞌul unqꞌabꞌ tzaꞌ. Oksa u viꞌ aqꞌabꞌ tu u bꞌenabꞌal laauxh. Utz aqꞌ okoꞌp vaqꞌabꞌ tu u tzokꞌbꞌeꞌm txala vuul. Ech yeꞌ koꞌxh kaꞌtziiunaxh. Pek nima aas qꞌaavitzꞌpꞌin.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Uncheeꞌ tzaqꞌbꞌu tek u Maxh utz, tala: —¡Noj peꞌxh axh, unBꞌaal, unTioxh!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Utz tal u Jesuus te ech tzaꞌ: —Anal nanima Maxh, aas vetiilin. Pek chiꞌbꞌebꞌal tetz qꞌu aanima qꞌuꞌl ninimaꞌin kꞌuxh yeꞌxhkam nitilin.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Uncheeꞌ sibꞌ tereꞌn koꞌxh txaichil iꞌan u Jesuus vatz qꞌul ichusulibꞌ aas yeꞌ tzꞌibꞌamal tu u uꞌ tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pek kꞌuxh vettzꞌibꞌalka qꞌuꞌl tzaꞌ tan, tiꞌ sanimali aas aꞌ viTxaaom u Tioxh u Jesuus, viKꞌaol u Tioxh. Ech tu koꞌn vinimaleꞌ saꞌatin tiichajil tu bꞌenqꞌii bꞌensaj. ");
INSERT INTO ixlCNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Uncheeꞌ xamtich tek tiꞌ qꞌu kam tzaꞌ, icheesa unpat tibꞌ u Jesuus vatz qꞌul ichusulibꞌ tziꞌ u choo tu Tibeerias. Ech vicheesat tibꞌ siatz iꞌana tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ech molich tibꞌ qꞌu chusulibꞌ tzaꞌ: u Xhim, vaꞌl Luꞌ ibꞌii majte, u Maxh, vaꞌl Diidimo ibꞌii majte; u Natanaeel, vaꞌl aa Canaa tikuenta Galilea; tuchꞌ qꞌul ikꞌaol u Zebedeo utz, tuchꞌ kaꞌvaꞌt chusulibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Utz tal u Xhim, vaꞌl Luꞌ ibꞌii majte: —Seꞌnveesa txay.— Texhtuꞌ. Utz tal qꞌul imol te ech tzaꞌ: —Sabꞌenoꞌ saiꞌ majte.— Texhtuꞌ. Ech motx ibꞌenaꞌ. Ok tu maꞌl u jukubꞌ. Loqꞌ nikoꞌxh maꞌj txay teesa tu u aqꞌbꞌal tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ech aalich texh isajbꞌeꞌ, opon u Jesuus tziꞌ u choo vaꞌl atichka. Pek yeꞌich tootzaj qꞌu chusulibꞌ oj u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Utz tal u Jesuus te ech tzaꞌ: —Xiak, ¿atil tzik bꞌoj echbꞌubꞌal tzexeꞌ?— Texh te. Motx tzaqꞌbꞌi utz, tala: —¡Paat yeꞌxhkam!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Tal u Jesuus te ech tzaꞌ: —Aqꞌtaj koꞌp vekꞌach tisebꞌalil u jukubꞌ tziꞌ. Ech seteesa jeꞌul etxay.— Texh te. Ech motx taqꞌtu koꞌp u kꞌach tu aꞌ. Utz sibꞌla txay ok tuul. Aal yeꞌ nichmotxitii veꞌt tiqꞌol jeꞌul u kꞌach tu aꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Uncheeꞌ aatz tek u chusulibꞌ vaꞌl tiich chit u Jesuus tiꞌ, tal tu u Luꞌ ech tzaꞌ: —¡U kuBꞌaal atziꞌ!— Texh tiꞌ u Jesuus. Ech taꞌxh tabꞌi u Xhim, vaꞌl Luꞌ majte, aas u kuBꞌaal vaꞌl oponi, itxꞌenku tek jeꞌ toksaꞌm. Tan chelpumich taqꞌo. Ech taqꞌtu koꞌp tibꞌ tu aꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Pek aatz unjot qꞌu chusulibꞌ, tu jukubꞌ elkuꞌl tziꞌ aꞌ, qinimal u kꞌach taqꞌo vaꞌl sibꞌla txay ok tuul. Tan yitꞌ tzian koj chit txꞌavaꞌ tu vaꞌl atichka; kamal maꞌj koꞌxh 100 metro oknajop. ");
INSERT INTO ixlCNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ech motx opon vatz txꞌavaꞌ. Utz tila aas atich ok maꞌl xamal. Nichitxoobꞌ maꞌl txay siiꞌ tuchꞌ kaxhlaan txꞌix. ");
INSERT INTO ixlCNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Utz tal u Jesuus te ech tzaꞌ: —Chabꞌataj ul untxꞌajoj qꞌu txay qꞌuꞌl anal veteteesalaꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Aatz u Xhim, ayaꞌ u Luꞌ, jeꞌop tu u jukubꞌ. Utz tiqꞌo eluꞌl vatz txꞌavaꞌ u kꞌach eesabꞌ txay. Noonaj ok mamaj txay tuul. Maꞌl 153. Loqꞌ kꞌuxh sibꞌla txay, yeꞌt qꞌixmu u kꞌach eesabꞌ tetz. ");
INSERT INTO ixlCNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Utz tal tek u Jesuus te ech tzaꞌ: —Niꞌextaj utz, echbꞌunojex.— Texh te. Utz nikoꞌxh maꞌj qꞌu chusulibꞌ aas sakoꞌxhtaqꞌan tabꞌit te aas: —¿Abꞌil axh?— Chaj te. Tan tootzajich aas ayaꞌ u kuBꞌaal Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ech xaan opon u Jesuus. Itxay u kaxhlaan txꞌix utz, taqꞌ tetz. Echat iꞌan tu u txay majte. ");
INSERT INTO ixlCNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Uncheeꞌ aꞌich tek vitoxpaj ichee u Jesuus vatz qꞌul ichusulibꞌ aas maꞌtich qꞌaav titzꞌpu xoꞌl qꞌu kamnaj. ");
INSERT INTO ixlCNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Uncheeꞌ aatz maꞌtich tek motx veet itxꞌaꞌneꞌ, tal u Jesuus tu u Xhim ech tzaꞌ, ayaꞌ u Luꞌ: —Xhim, ikꞌaol Jonaas, ¿tiira tzꞌejel chixh avaanima viꞌ vatz qꞌuꞌl tziꞌ?— Texh te. Utz tzaqꞌbꞌel tu u Luꞌ ech tzaꞌ: —Eeꞌ unBꞌaal, ootzajle tiira nunsaꞌaxh.— Texh te. Tal u Jesuus te ech tzaꞌ: —Liil qꞌu chꞌooaj niman vetz tziꞌ uncheeꞌ; xee echaꞌ karneꞌl.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Qꞌaav paj chit tal te ech tzaꞌ: —Xhim ikꞌaol Jonaas, ¿tzꞌejel chixh avaanima viꞌ?— Texh te. Tzaqꞌbꞌel tu u Luꞌ ech tzaꞌ: —Eeꞌ unBꞌaal, ootzajle tiira nunsaꞌaxh.— Texh te. Tal te ech tzaꞌ: —Liil qꞌu chꞌooaj niman vetz tziꞌ uncheeꞌ; xee echaꞌ karneꞌl.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Utz tal tepaj u Jesuus te titoxpaj ech tzaꞌ: —Xhim ikꞌaol Jonaas, ¿ni tzik asaꞌin?— Texh te. Pek aatz u Luꞌ, txumun tek tiꞌ tan, itoxpaj tek ichꞌotil te aas nojchixh nisaꞌa. Ech itzaqꞌbꞌe tek u Jesuus ech tzaꞌ: —UnBꞌaal, axh ootzajin tetz qꞌu kam kajayil utz, ootzajle aas nojchit nunsaꞌaxh.— Texh te. Utz tal u Jesuus te: —Liil qꞌu chꞌooaj niman vetz tziꞌ uncheeꞌ; xee echaꞌ karneꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Tan niꞌxhtekꞌval see aatz axhich txul aanima, taꞌn aꞌ nabꞌan uucheꞌ utz, nabꞌenaꞌ til asaꞌ. Pek aatz saqꞌesbꞌaxh, paarten tek sabꞌanon uucheꞌ. Utz siꞌiqꞌolbꞌenaxh tu vaꞌl kꞌuxh yaꞌsaꞌ bꞌenchil tuul.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kꞌuxh tal u kam ech tziꞌ tan, aꞌ talvu tiꞌ aas satoksa iqꞌii tu vikamebꞌal. Ech taꞌxh tal u kam te tziꞌ, tal paj te: —Xambꞌen viꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Uncheeꞌ ipilqꞌu tibꞌ u Luꞌ utz, aꞌ tek tila xamich u chusulibꞌ tiꞌ vaꞌl tiich chit u Jesuus tiꞌ. Ayaꞌ vaꞌl ijetzꞌoꞌk tibꞌ kꞌatz u Jesuus tuul nichtechbꞌuneꞌ aas yeꞌsajich ikameꞌ utz, vaꞌl tal te: —UnBꞌaal, ¿abꞌil vaꞌl soꞌoksanaxh tiqꞌabꞌ qꞌu txayol?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ech taꞌxh ilax u chusulibꞌ tu u Luꞌ tziꞌ aas xamich tiꞌ, tal tu u Jesuus ech tzaꞌ: —UnBꞌaal, pek ¿kam sayaꞌk vaꞌl tziꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Utz tal u Jesuus te ech tzaꞌ: —Kam koj ookebꞌal oj aꞌ unsaꞌ ankoꞌxh itzꞌlele laqꞌaavuꞌlin. Pek niꞌaxh xambꞌen viꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ech kꞌuxh tal u Jesuus aas: —Kam koj ookebꞌal tiꞌ oj aꞌ unsaꞌ ankoꞌxh itzꞌlele saqꞌaavuꞌlin.— Texhtuꞌ. Yitꞌ aꞌ koj tala aas yeꞌk sakam u chusulibꞌ tziꞌ. Pek yeꞌt kanax tootzajil u tokebꞌal tu qꞌu niman tetz u Jesuus. Utz nichtekipax itziiul tixoꞌl aas yeꞌk sakam u chusulibꞌ tziꞌ nichtaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","In u chusulibꞌ vaꞌl nialon qꞌu kam tzaꞌ. Utz in tzꞌibꞌan tan, qootzajle aas inujul qꞌu kam nival tiꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Utz sibꞌ tereꞌn koꞌxh kam iꞌan u Jesuus aas yeꞌt tzꞌibꞌali. Tan kꞌuxh tzꞌibꞌal koj chit junun qꞌu kam kajayil, tech tereꞌn koj uchchil tiꞌ ikolax qꞌu uꞌ satzꞌibꞌalika. Aꞌi.");
INSERT INTO ixlCNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teoofilo, aatz tu u bꞌaxa uꞌ vaꞌl untzꞌibꞌa bꞌen tzaxeꞌ, aꞌ yolonkꞌin tiꞌ kajay qꞌu kam qꞌuꞌl iꞌan u Jesuus utz, qꞌu kam ichusa aas ixeꞌteꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Aꞌ tzojpik tiꞌ qꞌu kam qꞌuꞌl iꞌan, tu u qꞌii aas bꞌenjeꞌ tu Amlika. Tan aatz yeꞌsajich ibꞌenaꞌ, taqꞌka mantaar titxumbꞌal u Tioxhla Espiiritu tu qꞌul ichaj qꞌuꞌl itxaa. ");
INSERT INTO ixlCNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Utz kꞌuxh maꞌtich ikameꞌ, qꞌaav itzꞌpi. Utz nichichee siatz. Kam koꞌn xheenya iꞌana, techlal aas nojchit itzꞌlele. 40 qꞌii iꞌan ech tziꞌ. Aꞌ nichtal viQꞌesalail u Tioxh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Utz aatz molomich tibꞌ tuchꞌ qꞌul ichusulibꞌ, tal u Jesuus te aas yeꞌk samotxelbꞌen tu Jerusaleen. Tal te ech tzaꞌ: —Saꞌnalmotxechꞌia tul u Tioxhla Espiiritu vaꞌl alaꞌtziꞌimal sete tu vunTat utz, alel sete vaqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Tan tu koꞌn aꞌ ibꞌanvu vautisaar qꞌu aanima u Xhan, pek ech koj ex tan, tu u Tioxhla Espiiritu sabꞌanaxku vautisaarex tu koꞌxh kaꞌxvaꞌt qꞌii cheel.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Uncheeꞌ aatz qꞌuꞌl molich tibꞌ tuchꞌ u Jesuus, motx ichꞌoti te ech tzaꞌ: —KuBꞌaal ¿satz qꞌaav ooksa ijlenal tu kuxoꞌl cheel aas qetz Israeelil?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Yeꞌk etokebꞌal tiꞌ tootzajileꞌ jatu utz, kam tuul soꞌoki tan, ayeꞌn tiqꞌabꞌ vunTat. ");
INSERT INTO ixlCNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pek aatz ex, sekꞌul examlil aas maꞌt ikuꞌ u Tioxhla Espiiritu setibꞌa. Ech seꞌnetal paal kajay vaꞌl netileꞌ etabꞌi sunkꞌatza tzaꞌ tu Jerusaleen, tikuenta kajay u Judea, tuchꞌ tikuenta kajay u Samaaria utz, oponnalex tijuꞌtebꞌal u vatz amlika txꞌavaꞌ.— Texh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ech taꞌxh veet tal qꞌu yol tziꞌ, siatz chit qꞌul ichusulibꞌ iqꞌol bꞌen tixoꞌl. Bꞌenjeꞌ tu Amlika. Ok tu maꞌl u sutzꞌ. Ech sotzka ivatz tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ech tuul ankoꞌxh tii nichmotxisajin jeꞌ tu amlika tiꞌ isajil bꞌen, yeꞌk talcheꞌ til ichee kaꞌvaꞌl vinaj sikꞌatza, poloxh saj oksaꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ech qꞌilal tu qꞌu vinaj tziꞌ, tal te ech tzaꞌ: —Vinaj aa Galilea, ¿kantuꞌ ankoꞌxh nesajin jeꞌ tu amlika? Tan tu Amlika maꞌtku u Jesuus vaꞌl eesali bꞌen texoꞌl atziꞌ. Utz echat chit iqꞌaavuꞌl saqꞌaavuꞌl echaꞌ mutelbꞌen tziꞌ.— Texh kaꞌvaꞌl qꞌu vinaj te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Uncheeꞌ motx tek kꞌasuꞌl qꞌu chusulibꞌ viꞌ u muunte vaꞌl Olivo utz, ul tu Jerusaleen. Tan inajaꞌchich koꞌn u Jerusaleen. Kamal maꞌj kiloometro ixoꞌl tuchꞌ. Tan ayaꞌl vaꞌl saveeti sixaa tu ilanbꞌal qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ech taꞌxh motx oponi, motx bꞌenjeꞌ tu u kaꞌ chupul otzotz vaꞌl jolol atichka sikajayil. Utz aꞌ qꞌul ibꞌii tzaꞌ: u Luꞌ, u Jacobo, u Xhan, u Lixh, u Felipe, u Maxh, u Bartolomee, u Tio, u Jacobo, vikꞌaol u Alfeo, u Xhim vaꞌl atich ok xoꞌl qꞌu cananista utz, tuchꞌ u Judas, vikꞌaol u Jacobo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ech maꞌlich chit iatz qꞌu chusulibꞌ sikajayil. Nichimolo tibꞌ tiꞌ iqꞌilal sikꞌlel Tioxh. Ant aꞌ u Liꞌ, vinan u Jesuus utz, tuchꞌ qꞌul itzaꞌqꞌ u Jesuus, tuchꞌ unjoltu qꞌu ixoj. ");
INSERT INTO ixlCNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Uncheeꞌ aatz iꞌan tu qꞌu qꞌii tziꞌ, txakeꞌ u Luꞌ xoꞌl qꞌu niman tetz u Jesuus molich tibꞌ; maꞌlich 120 ixaaneꞌ. Utz tal ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Hermanos, ministeer chit itzojpu u yol tzꞌibꞌamalka. Ayaꞌ vaꞌl tal u Tioxhla Espiiritu titziꞌ u Daviid, tiꞌ u Judas, vaꞌl kꞌuchun u Jesuus tu qꞌu txayol, ");
INSERT INTO ixlCNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","kꞌuxh aꞌich kumol utz, antu atich tijleꞌm tu u aqꞌon tiꞌ Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Aatz vetiꞌana, iloqꞌ untanul itxꞌavaꞌ tiꞌ u puaj, u jaꞌmel tonkonil. Utz ex iyatzꞌ jeꞌ tibꞌ tuul. Aꞌ kuꞌ iviꞌ vatz txꞌavaꞌ utz, yakich qꞌixmoj tuul. Ech nilp eluꞌl tuul tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Utz pax chit itziiul xoꞌl kajay qꞌu aa Jerusaleen vaꞌl iꞌana tziꞌ. Ech tek taqꞌax bꞌen Aceeldama u txꞌavaꞌ tziꞌ. “Jaꞌmel kaj” chu u tokebꞌal tu yolbꞌal arameo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Utz ech chit iꞌana u yol tzꞌibꞌamalka tu u Salmos vaꞌl nital ech tzaꞌ: «Tzꞌineꞌojka u tatibꞌal. Abꞌilich tereꞌn atin tuul.» Chia. Utz nital majte: «Okoj ichꞌexel tu u tijleꞌm.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ech ministeer saok ichꞌexel u Judas. Aꞌ soꞌok maꞌl tu qꞌu vinaj qꞌuꞌl aꞌ kumol tu jatvaꞌl u tiempo iꞌan u kuBꞌaal Jesuus tu kuxoꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Aꞌ nal kumol ayaꞌxchen ibꞌanax vautisaar u Jesuus tu u Xhan utz, ankoꞌxh aꞌ kumol aas eesal bꞌen u Jesuus tu kuxoꞌl bꞌenjeꞌ tu Amlika. Ech aꞌ vaꞌt tu kuxoꞌl sitxakbꞌaꞌ tibꞌ tiꞌ talax u qꞌaavtitzꞌpebꞌal u Jesuus.— Texh u Luꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ech motx itxaateꞌl kaꞌvaꞌl vinaj. Maꞌl, Xhep, Justo ibꞌii majte, ikꞌaol maꞌl u vinaj Sabaas ibꞌii. Utz vaꞌt, Yaxh ibꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ech motx iqꞌila sikꞌle Tioxh. Motx tal ech tzaꞌ: —KuBꞌaal, axh ootzajin tetz taanima junun aanima. Ech kꞌuch qe abꞌiste atxaaom tu kaꞌvaꞌl qꞌu vinaj tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Ech soꞌoks achaj. Saꞌaqꞌonin saiꞌ tu u aqꞌon tzaꞌ vaꞌl vettelabꞌeka u Judas. Tan maꞌt tu vaꞌl saꞌchitbꞌenku tiꞌ ichool vipaav.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Uncheeꞌ motx iꞌan tiꞌ vatz Tioxh, tiꞌ tiltaꞌ abꞌil soꞌoki. Utz aꞌ kuꞌk tiꞌ u Yaxh. Ech yakich koꞌxh okoj tu u tijleꞌm xoꞌl junlaal qꞌul ichaj u Jesuus tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Uncheeꞌ aatz iꞌan tu u nimla qꞌii vaꞌl Pentecostees, maꞌl iatz kajay qꞌu niman tetz u Jesuus molich tibꞌ tu maꞌl u atibꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Utz yeꞌk talcheꞌ, ul maꞌl xumkabꞌinchil tu amlika. Echaꞌ ixumkabꞌin mam kajiqꞌ. Yakich jumkabꞌinoj tokoꞌp tu u otzotz vaꞌl molichku tibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Utz echaꞌ taqꞌ xamal chee tibꞌa. Motx ijatx tibꞌ utz, jeꞌ tiviꞌ sijununil. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ech tiira ok u Tioxhla Espiiritu kꞌatza bꞌaꞌnil. Utz motx tek xeꞌt iyolon tunjolt yolbꞌal. Loqꞌ u Tioxhla Espiiritu nichyolonsan tunjolt qꞌu yolbꞌal qꞌuꞌl yeꞌ tootzaj. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Uncheeꞌ kaana aanima Israeel atich opon tu Jerusaleen, xoꞌvan Tioxh. Til chaj koꞌxh motx kꞌaskuꞌl tu u vatz amlika txꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ech aatz abꞌil u xumkabꞌinchil tziꞌ, mam tenam imol tibꞌ tiꞌ qꞌu niman tetz u Jesuus. Utz tiira motx sotz ikꞌuꞌl qꞌu aanima taqꞌo tan, tabꞌi aas nichiyolbꞌel viyolbꞌal tu qꞌu niman tetz u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tiira motx tzꞌejx ikꞌuꞌl. Utz sotz ikꞌuꞌl. Ech motx tek tal tibꞌilaj ech tzaꞌ: —Jolol aa Galilea qꞌuꞌl niyoloneꞌ atziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Utz ¿kan chaj tokeꞌ aas nimotxitxꞌol yol tu qꞌu kuyolbꞌal qitzꞌpebꞌal? ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nimotxiyolon tu yolbꞌal aa Paartia, aa Meedia, aa Elam, aa Mesopotaamia, aa Judea, aa Capadoocia, aa Ponto tuchꞌ aa tikuenta Aasia, ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","11","aa Friigia, aa Panfiilia, aa Egipto, aa tikuenta Liibia najaꞌch Cirene utz, tiyolbꞌal qꞌu aa Roma jejlel tzaꞌ. At niyolon tu yolbꞌal aa Creta tuchꞌ yolbꞌal aa Araabia. Utz ela niqabꞌi taltu qꞌu mamaj kam tiꞌ u Tioxh tu qꞌu kuyolbꞌal. Niqabꞌi oꞌ Israeel tu u qitzꞌpebꞌal utz, kꞌuxh oknajkoꞌnoꞌ tiꞌ u tuqꞌaybꞌal qꞌu Israeel.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ech tiira tzꞌejxinajich ikꞌuꞌl utz, sotznaj ikꞌuꞌl nichmotxtal sivatzaj ech tzaꞌ: —¿Kam tek tok u kam tziꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pek at unjolte, nichkoꞌnteesa iqꞌii. Nichtal ech tzaꞌ: —Qꞌabꞌaꞌm aꞌ nimotxbꞌanon tziꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Uncheeꞌ txakeꞌ tek u Luꞌ, tuchꞌ junlaat qꞌul ichaj u Jesuus utz, jankꞌal iyakꞌil tal ech tzaꞌ: —Vinaj Israeel, tuchꞌ ex jejlelex tu u Jerusaleen tzaꞌ, abꞌitaj vaꞌl savaleꞌ tzaꞌ. Ootzajitaj bꞌaꞌnil. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Aatz qꞌu aanima tzaꞌ, yitꞌ qꞌabꞌareel koj atziꞌ, echaꞌ netaleꞌ. Tan qꞌalaꞌm cheel, anal alas 9. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Pek aatz vaꞌl nitucheꞌ tziꞌ, aꞌ nitzojpeꞌ qꞌu yol tal u Joeel u alol tetz u yolbꞌal Tioxh, aas tal ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","«Aatz siꞌan tu qꞌu motxebꞌal qꞌii, savaqꞌ kuꞌ vunTioxhla Espiiritu tibꞌa kajay qꞌu aanima. Chu u Tioxh. Ech aatz qꞌul ekꞌaol emeꞌal, samotxtaleꞌl qꞌul unyol. Aatz qꞌu xiak tuchꞌ qꞌu ixviak, sunkꞌuch kam te tu visioon. Utz aatz qꞌu qꞌesla chaj aanima, sunkꞌuch kam te tu vatziꞌkꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Saꞌatin vunTioxhla Espiiritu kꞌatz qꞌu vinaj tuchꞌ kꞌatz qꞌu ixoj niman vetz. Ech samotxtaleꞌl qꞌul unyol. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Utz sunkꞌuch txaichil tu amlika, sunkꞌuch xheenya vatz txꞌavaꞌ. Sunkꞌuch xheenya tiꞌ kajal, xheenya tiꞌ xamal utz, xheenya tiꞌ ibꞌukin ijeꞌ sibꞌ. Chu u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Utz aatz siꞌaneꞌ aas yeꞌsajen tul u kuBꞌaal tu u mam techalla tulebꞌal, saok aqꞌbꞌal vatz u qꞌii utz, sabꞌens echaꞌ kajal u ichꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ech kajay qꞌuꞌl laqꞌilan sikꞌlen vibꞌii u Tioxh, sael vatz u choobꞌal paav.» Chu u Joeel.— Texh u Luꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Tal paj ech tzaꞌ: —Vinaj Israeel, abꞌitaj qꞌu yol tzaꞌ. Aatz u Jesuus aa Nazareet, nojchit iTxaaom u Tioxh. Tan kam koꞌn bꞌaꞌnil iꞌana, kam koꞌn txaichil tuchꞌ xheenya. Utz tiqꞌaqꞌal u Tioxh kꞌuxh ech iꞌan texoꞌl. Ech ootzajimal qꞌu kam setaqꞌo tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Loqꞌ kꞌuxh ech qꞌu bꞌaꞌnil vetikꞌucha, txayax setaqꞌo. Ech ex alon iyatzꞌpu tiqꞌabꞌ qꞌu onkonla aanima vatz kurus. Ayaꞌl kala mam aa paavla aanima sevatz. Loqꞌ titxumbꞌal u Tioxh kꞌuxh ech vetpaalka tan, ech vaꞌl kꞌajel tiꞌ taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pek kꞌuxh kami tan, qꞌaav koꞌn itzꞌpixsal tu u Tioxh xoꞌl qꞌu kamnaj. Vetteesa vatz u kamchil. Yeꞌn oleꞌ u kamchil tiꞌ aas taꞌn soꞌokka tikuenta. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ech tok vaꞌl tal u Daviid aas tal ech tzaꞌ: «Bꞌenamen nivil vunBꞌaals Amlika sunvatz. Atil tunsebꞌal, ech yeꞌxhabꞌil koꞌxh saꞌaqꞌonkuꞌin. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Echtzixeꞌt techal itxuqꞌtxun vaanima, kaana ichiꞌbꞌ unbꞌitzeꞌ. Kꞌujlel ikꞌuꞌl vunchiꞌl saiꞌ kꞌuxh lakamin. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Tan saꞌkojaaqꞌ tzii aas taꞌn sakaaꞌin tu jul xoꞌl qꞌu kamnaj. Utz saꞌkojaaqꞌ tzii aas saqꞌee vichiꞌl vaTxaaom. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Tan vetvootzajil u bꞌey tetz tiichajil saaqꞌo. Ech tiira taꞌn satxuqꞌtxunin aas laꞌatinin tzaxeꞌ.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Uncheeꞌ tinujul saval sete aas yitꞌ u Daviid koj nital jeꞌ tibꞌ. Tan aatz u kukꞌuy kumam Daviid, kami utz, mujli. Ankoꞌxh atil u mujbꞌal tetz tu kuxoꞌl cheel. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pek axhibꞌi alolich tetz iyol u Tioxh. Tootzajich tekuꞌen aas soꞌok ijlenalil maꞌl tu qꞌul ituꞌxh ixalam; ayaꞌ viTxaaom u Tioxh. Tan maꞌtich talaꞌtziꞌil te tu u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ech maꞌtich ikꞌuchax el tu u Daviid u qꞌaavtitzꞌpebꞌal u Jesuus. Tan yolon tiꞌ u qꞌaavtitzꞌpebꞌal viTxaaom u Tioxh. Tala aas yeꞌk sakaa u taanxelal tu u tatibꞌal qꞌu kamnaj. Utz tal majte aas yeꞌk saqꞌee vichiꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ech nojchit u Tioxh qꞌaav itzꞌpixsan u Jesuus. Tan nojchit qila qabꞌi utz, nikutxakbꞌaꞌ talax u qꞌaavtitzꞌpeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ech iqꞌoli jeꞌ tu Amlika. Kꞌujeꞌy tisebꞌal u Tioxh. Vetikꞌullu u Tioxhla Espiiritu vaꞌl alel te tu viTat. Ech vettaqꞌ kuꞌ qibꞌa. Ayaꞌ vaꞌl netileꞌ netabꞌi tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Yitꞌ u Daviid koj bꞌenjeꞌ tu Amlika aas tal ech tzaꞌ: «Aatz u Tioxh, tal tu vunBꞌaal ech tzaꞌ: Kꞌujach tunsebꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Saꞌnalvaqꞌka qꞌul akoontra satzeqꞌlebꞌal. Texh te.» Chu u Daviid. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ech etootzajitaj bꞌaꞌnil jankꞌal ex, ex Israeel tan, aatz u Jesuus, vaꞌl etal ijeꞌ vatz kurus, aqꞌaxyu tijleꞌm tu u Tioxh. Aꞌ tek kuBꞌaal utz, iTxaaom u Tioxh.— Texh u Luꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Uncheeꞌ aatz tek tabꞌi qꞌu yol qꞌu aanima, motx ilin taanima taqꞌo. Utz motx tek tal tu u Luꞌ tuchꞌ tu tereꞌn qꞌul ichaj u Jesuus ech tzaꞌ: —Qitzꞌin qatzik, ¿kam sakubꞌaneꞌ uncheeꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ech aatz u Luꞌ, tal te ech tzaꞌ: —Kꞌaxataj qꞌul epaav. Utz tibꞌii u Jesucristo sebꞌan evautiismo sejununil. Ech sakuyax qꞌul epaav. Utz saok u Tioxhla Espiiritu sekꞌatza majte vaꞌl ayaꞌl ikꞌuꞌl u Tioxh nitaqꞌeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tan etetz u Tioxhla Espiiritu vaꞌl alel. Tetz qꞌul ekꞌaol emeꞌal. Utz tetz qꞌuꞌl kꞌuxh tzian atilku cheel, yeꞌsaj inimat u Jesuus. Tetz jankꞌal qꞌuꞌl nisikꞌlel tu u Tioxh, u kuBꞌaal.— Texh u Luꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Utz sibꞌ koꞌxh tereꞌn yol nichtal te, oksabꞌ tetz tu jik utz, moxbꞌebꞌ tetz. Nichtal ech tzaꞌ: —Xaanojelex kꞌatz qꞌu aanima qꞌuꞌl eesanal tu bꞌey tu u tiempo tzaꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Uncheeꞌ motx ibꞌan ivautiismo kajay qꞌu aanima qꞌuꞌl niman qꞌu yol tal u Luꞌ. Kamal 3,000 ixaan qꞌu aanima qꞌuꞌl anal ok tiꞌ u Jesuus iꞌan tu u qꞌii tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ech tiira jonal atich ok tiꞌ inimal u chusbꞌal vaꞌl nichtaqꞌ qꞌul ichaj u Jesuus. Tiira maꞌl chit itzii tibꞌilaj sivatzaj, tuul molmochil tatineꞌ. Nichijatx u kaxhlaan txꞌix. Utz maꞌlich chit iatz tiꞌ iqꞌilal isikꞌlel Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Uncheeꞌ kajay qꞌu aanima chee tek maꞌl xoꞌval kꞌatza tiꞌ qꞌu mamaj txaichil tuchꞌ qꞌu xheenya nichmotxiꞌan qꞌul ichaj u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Pek aatz qꞌu niman tetz u Jesuus, tiira molmoch tatineꞌ. Utz komon tatin kajay qꞌu kam sivatzaj. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Atia nichikꞌayi untanoj itxꞌavaꞌ; oj kam koꞌxh maꞌj tetz nichikꞌayi majte. Utz nichijatx vijaꞌmel xoꞌl qꞌul niyaꞌta tetz. Aꞌ niꞌenku tiꞌ vimeꞌbꞌiꞌl sijununil. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Utz maꞌl chit itzii nichibꞌen tu viqꞌanalil u totztioxh. Utz nichmotxijatx u kaxhlaan txꞌix tu qꞌu atibꞌal. Chiꞌbꞌebꞌalich itxꞌaꞌn tibꞌilaj nimotxiꞌaneꞌ. Yeꞌk jeꞌchil vatz xeꞌ taanima sivatzaj. ");
INSERT INTO ixlCNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Techal toksat iqꞌii Tioxh. Utz tiira bꞌaꞌnich ikꞌuꞌl aanima tiꞌ. Atich chit iatz Tioxh tiꞌ tan, jun qꞌii nichtakꞌbꞌu qꞌuꞌl nichtok tixoꞌl. Ayaꞌ qꞌuꞌl saꞌchitchitpu tu qꞌul ipaav. ");
INSERT INTO ixlCNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Uncheeꞌ aatz u Luꞌ tuchꞌ u Xhan, motx bꞌen tu viqꞌanalil u totztioxh tiꞌ iqꞌilal isikꞌlel Tioxh alas 3 kuꞌqꞌii. Tan aꞌ u oora nituch oponchil tiꞌ iqꞌilal isikꞌlel Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Utz atich maꞌl u vinaj koꞌx tu titzꞌebꞌal. Jun qꞌii nichtiqꞌol opon tziꞌ u okebꞌalop vaꞌl “Txꞌanel” chu teꞌleꞌ. Nijoyon tu qꞌu aanima qꞌuꞌl nitopon tu viqꞌanalil u totztioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ech taꞌxh til u koꞌx aas aalich tek tokoꞌp u Luꞌ tuchꞌ u Xhan tu viqꞌanalil u totztioxh, ijaj ipuaj te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Aatz u Luꞌ tuchꞌ u Xhan, tii isaji utz, tal te ech tzaꞌ: —Sajiꞌoꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ech tii sajil tu u koꞌx. Aꞌ nichtitzꞌa kam maꞌj tetz saꞌaqꞌaxi. ");
INSERT INTO ixlCNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pek aatz u Luꞌ, tal te ech tzaꞌ: —Yeꞌk bꞌaꞌnla saj chꞌichꞌ puaj tzunxeꞌ. Nikoꞌxh bꞌaꞌnla qꞌan chꞌichꞌ puaj. Pek kam vaꞌl atil sunkꞌatza savaqꞌ eetz. Tibꞌii u Jesucristo aa Nazareet lakpen utz, xaan.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ech itxay sebꞌal iqꞌabꞌ u koꞌx. Ilak jeꞌ. Utz yakich cheeoj iyakꞌil qꞌu tajan tuchꞌ qꞌu chupbꞌal tibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Utz yuqꞌpu jeꞌ. Yakich txakeꞌoj. Ech xeꞌt ixaaneꞌ. Bꞌenoꞌk tiꞌ u Luꞌ tuchꞌ u Xhan tu viqꞌanalil u totztioxh. Xaaom tek ibꞌenoꞌk. Vaꞌlich iyuqꞌpeꞌ. Utz techal toksat iqꞌii u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ech til kajay qꞌu aanima atich opon, aas nitekixaaneꞌ utz, vaꞌl toksat iqꞌii u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Tiira motx tzꞌejx ikꞌuꞌl utz, motx xoꞌv tu u kam tziꞌ. Tan til iatz aas aꞌ u koꞌx vaꞌl nichikꞌujeꞌ tiꞌ ijoyax ipuaj tziꞌ u okebꞌalop tu viqꞌanalil u totztioxh vaꞌl “Txꞌanel” chu teꞌleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Uncheeꞌ aatz u koꞌx, vaꞌl maꞌtich ibꞌantu bꞌaꞌn, tii techit txayelich u Luꞌ tuchꞌ u Xhan taqꞌo. Ech aatz qꞌu aanima qꞌuꞌl tzꞌejxinajich ikꞌuꞌl tiꞌ, motx imol tibꞌ. Motx opon kꞌatz qꞌu chusulibꞌ tu vaꞌl “Xoꞌl Piraal Tetz Salomoon”. ");
INSERT INTO ixlCNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ech aatz til qꞌu aanima u Luꞌ, tal te ech tzaꞌ: —Aanima Israeel, ¿kantuꞌ nitzꞌejx ekꞌuꞌl tiꞌ u kam tziꞌ? Utz ¿kantuꞌ aas tii nesajiꞌoꞌ tiꞌ. Ayaꞌl kala oꞌ tuchꞌ kuyakꞌil utz, tuchꞌ kubꞌaꞌnil vetkuxaansa u koꞌx tilon tu qꞌuꞌl nebꞌaneꞌ tziꞌ? ");
INSERT INTO ixlCNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Tan iqꞌaqꞌal u Jesuus atziꞌ, vaꞌl etoksa tiqꞌabꞌ u Pilato utz, yeꞌt koꞌn motx esaꞌa aas siꞌchchajpuli. Aꞌ viTxaaom u Tioxh vaꞌl taqꞌ tijleꞌm, vaꞌl nimamal tu qꞌu kukꞌuy kumam, u Abrahaam, u Isaac tuchꞌ u Jacoob. ");
INSERT INTO ixlCNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yeꞌt koꞌn esaꞌa siꞌchchajpul u Tioxhla Vinaj, u Jikomla Vinaj. Utz taꞌn ejaj ichajpul maꞌl u yatzꞌol aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ech ex yatzꞌon u aqꞌol tetz u vatz kuqꞌii kusaj vaꞌl qꞌaav itzꞌpixsali xoꞌl qꞌu kamnaj tu u Tioxh. Utz oꞌ texhtiigo aas itzꞌlel tek tikaꞌpaj. ");
INSERT INTO ixlCNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Utz tiꞌ koꞌn vikꞌujeꞌ kukꞌuꞌl tiꞌ vibꞌii u Jesuus kꞌuxh vetibꞌanlu bꞌaꞌn u koꞌx sevatz sekajayil tziꞌ, vaꞌl netileꞌ utz, etootzaj. Ech tiꞌ koꞌn inimal u Jesuus, tiira vetiꞌanlu bꞌaꞌn u vinaj tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Loqꞌ vitzꞌin vatzik, ipaav yeꞌ etootzaj tuchꞌ qꞌu qꞌatol tzii kꞌuxh kam vetebꞌan tu u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Tan ech chit itzojpu viyol u Tioxh tziꞌ vaꞌl bꞌaxabꞌsamal talax taqꞌo tu qꞌu alol tetz viyol, aas ministeer chit ikam viTxaaom u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Echtzixeꞌt kꞌaxataj qꞌul epaav. Chꞌexputaj qꞌul etxumbꞌal. Ech sasotzsal qꞌul epaav. Ech laul u bꞌaꞌnla tiempo tzexeꞌ tu u Tioxh. Ech silochꞌoꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Utz sichajuꞌl u Jesucristo tikaꞌpaj. Ayaꞌ vaꞌl alel nal taqꞌo, sauli. ");
INSERT INTO ixlCNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Loqꞌ ministeer taꞌn aꞌ saꞌatinku u Jesuus tu Amlika. Anal sauli aas saꞌtektoksa kajay qꞌu kam u Tioxh tu jik tu u vatz amlika txꞌavaꞌ. Echaꞌ vaꞌl tal titziꞌ qꞌu alol tetz viyol xaanaj el kꞌatz paav atich oꞌtene. ");
INSERT INTO ixlCNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Utz antu u Moisees alon tu qꞌu kukꞌuy kumam ech tzaꞌ: «Saꞌnalicheesa maꞌl alol tetz viyolbꞌal u kuBꞌaal Tioxh texoꞌl echaꞌ in tzaꞌ. Utz lamotxenima kajayil kam vaꞌl latala. ");
INSERT INTO ixlCNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tan oj abꞌil yeꞌ laniman, sotzchil siꞌan xoꞌl vitenam u Tioxh.» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ech antu tereꞌn qꞌu alol tetz u yolbꞌal Tioxh taabꞌaul tzaꞌ, motx yolon tiꞌ qꞌu kam nituch cheel. Aꞌ bꞌaxal xeꞌt alon u Samueel. ");
INSERT INTO ixlCNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Utz ex vetilon itzojpu qꞌu kam tal qꞌu alol tetz u yolbꞌal Tioxh tiꞌ koꞌxtene. Ex vetilon iqꞌaqꞌal u nukꞌu vaꞌl iꞌan u Tioxh tuchꞌ qꞌu kukꞌuy kumam u Abrahaam. Tan tal te ech tzaꞌ: «Kajay qꞌu aanima tu u vatz amlika txꞌavaꞌ, sikꞌul u bꞌaꞌnil kꞌatz vatuꞌxh axalam.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Echtzixeꞌt aꞌ bꞌaxa vetichajvu kꞌasuꞌl viTxaaom tzexeꞌ aas maꞌtich qꞌaav titzꞌpeꞌ. Tan aꞌ isaꞌ ekꞌultu qꞌu mamaj bꞌaꞌnil. Ech junun ex sechꞌexpu qꞌul etxumbꞌal, setaqꞌka qꞌu onkonil.— Texh u Luꞌ tu qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Uncheeꞌ ankoꞌxh nichiyolon u Luꞌ tuchꞌ u Xhan xoꞌl qꞌu tenam, tuul opon unjolol qꞌu oksan yol vatz Tioxh. Aꞌich imol u qꞌesal xeen tetz vikuentail u totztioxh tuchꞌ qꞌu qꞌesala xoꞌl qꞌu saduceo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Utz vaꞌlich ichiꞌon ikꞌuꞌl tiꞌ u Luꞌ tuchꞌ tiꞌ u Xhan. Tan nichichus tu qꞌu aanima aas maꞌtich iqꞌaav titzꞌpu u Jesuus xoꞌl qꞌu kamnaj. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ech motx itxay u Luꞌ tuchꞌ u Xhan. Ex taqꞌ kuꞌ tu tzeꞌ. Tan maꞌtich tek ikuꞌ qꞌii. Ech qꞌejaleen tek siꞌchmotxtxꞌolax inujul. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Loqꞌ mam tenam niman u yolbꞌal Tioxh vaꞌl tal u Luꞌ xoꞌl qꞌu aanima. 5,000 qꞌuꞌl niman. Utz aal taꞌxh qꞌu vinaj ok tu ach. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Uncheeꞌ aatz evtalich tek ikuꞌ qꞌu chusulibꞌ tu tzeꞌ, imol tibꞌ qꞌu qꞌatol tzii qꞌuꞌl tu Jerusaleen. Antich imol qꞌu qꞌesal qꞌatol tzii tuchꞌ qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Antich imol u qꞌesal oksan yol vatz Tioxh, vaꞌl Anaas ibꞌii. Antu u Caifaas tuchꞌ kaꞌvaꞌt vinaj maꞌl, Xhan utz; vaꞌt Alejandro utz, tuchꞌ qꞌu titzꞌin tatzik u qꞌesal oksan yol vatz Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ech motx tal tiqꞌol ul u Luꞌ tuchꞌ u Xhan. Toksa tu xoꞌl utz, motx ichꞌoti te ech tzaꞌ: —¿Kam etijleꞌm bꞌatzꞌi? Utz ¿abꞌil vetaqꞌon tzii sete aas nebꞌan qꞌu kam tziꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Uncheeꞌ aatz u Luꞌ tan, tiira atich u Tioxhla Espiiritu kꞌatza bꞌaꞌnil, tal te ech tzaꞌ: —Chajlentzikꞌex qꞌesal qꞌatol tzii tuchꞌ ex qꞌesal tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Aatz cheel nechꞌoti qe kaniꞌch mikꞌultu u bꞌaꞌnil u koꞌx tziꞌ. Aꞌ esaꞌ setootzaji kaniꞌch miꞌantu bꞌaꞌn. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ech ootzajitaj bꞌaꞌnil utz, tootzaji kajay u Israeel tzaꞌ aas tu vibꞌii u Jesucristo aa Nazareet vetibꞌanvu bꞌaꞌn u koꞌx vaꞌl atil sevatz tziꞌ. Tibꞌaꞌnil koꞌn niyolonka kꞌuxh bꞌaꞌntu tekuꞌen. Tiqꞌaqꞌal koꞌn u Jesuus vaꞌl etaqꞌ jeꞌ vatz kurus utz, qꞌaav itzꞌpixsal tu u Tioxh xoꞌl qꞌu kamnaj. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Aatz u Jesuus vaꞌl niqal sete tzaꞌ, tiira yeꞌk itxaꞌk sete. Ech koꞌn ikꞌonax el maꞌl Sivan tu qꞌu bꞌanol otzotz. Utz aal aꞌ u Sivan vaꞌl tiira ibꞌoꞌqꞌol tetz xoobꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Tan abꞌil koj vaꞌt Chitol tu paav atile. Yeꞌk maꞌj aanima aqꞌel tijleꞌm tu u vatz amlika txꞌavaꞌ tzaꞌ aas Chitol qetz tu paav.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ech motx tzꞌejx ikꞌuꞌl qꞌu qꞌesala aas tila yeꞌkich ixoꞌval u Luꞌ tuchꞌ u Xhan tu yol kꞌuxh yitꞌ tekꞌ koj elnaj tiꞌ tzꞌibꞌ. Yakich til majte aas antu xoꞌl qꞌuꞌl xambꞌu tiꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ech kam tereꞌn koj yaaom iꞌana tan, txaklich ok u vinaj tixoꞌl vaꞌl maꞌtich ibꞌaꞌnixeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ech motx ichaj eluꞌl u Luꞌ tuchꞌ u Xhan, kꞌasuꞌl xoꞌl qꞌu qꞌatol tzii. Utz motx yolonka sivatzaj. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Nichmotxtal ech tzaꞌ: —¿Kam sakubꞌan tu qꞌu vinaj tziꞌ? Tan nojchit vetiꞌanlu txaichil. Utz ilaxyu tu qꞌu aanima jejlel tu Jerusaleen tzaꞌ. Utz yeꞌxh koꞌxh kaniꞌch veꞌt imujax qꞌu kam tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pek aatz sakubꞌaneꞌ, sakupoyi tu kamchil. Ech yeꞌk sipaxsa paal tereꞌn itziiul vibꞌii u Jesuus xoꞌl tenam; cheel utz, taabꞌabꞌen majte.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ech motx paj isikꞌle qꞌul ichaj u Jesuus. Utz tiira motx tal te aas yeꞌkan siyoleꞌ utz, yeꞌkan sachusun tibꞌii u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pek aatz u Luꞌ tuchꞌ u Xhan, motx tzaqꞌbꞌu ech tzaꞌ: —Nachtaj bꞌaꞌnil. ¿Ijikomal tzik vatz Tioxh nenacheꞌ aas aal ex bꞌaxa sakunimaꞌex siatz u Tioxh? ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tan yeꞌxhkaniꞌch kuyaꞌsat talax qꞌu kam qꞌuꞌl ilel abꞌimal qaqꞌo.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Loqꞌ motx paj ipoyi tu kamchil, ech motx ichajpu. Yeꞌxhkam maꞌj motx iꞌan te tan, nichixoꞌva qꞌu tenam. Tan sibꞌla aanima vaꞌlich toksat iqꞌii Tioxh tu u txaichil uchi. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Tan maasich tek 40 iyaꞌbꞌ u vinaj vaꞌl bꞌanax u txaichil te tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Uncheeꞌ taꞌxh chajpul u Luꞌ tuchꞌ u Xhan, motx bꞌen xoꞌl qꞌul imol. Utz motx chit tala kam qꞌu yol alax te tu qꞌu qꞌesal oksan yol vatz Tioxh tuchꞌ tu qꞌu qꞌesal qꞌatol tzii. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ech taꞌxh motx tabꞌi qꞌu yol tala tziꞌ, maꞌl chit itzii motx jeꞌ iviꞌ tiꞌ iqꞌilal isikꞌlel Tioxh. Motx tal ech tzaꞌ: —Taꞌxh maꞌl axh kuBꞌaal. Axh u Tioxh bꞌanol tetz u amlika tuchꞌ u txꞌavaꞌ tzaꞌ tuchꞌ u mar utz, tuchꞌ kajay qꞌu kam atil tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Axh yolonaxh titxumbꞌal u Tioxhla Espiiritu titziꞌ u Daviid, u niman eetz, ech tzaꞌ: «¿Kam tokeꞌ nimotxipaasa tibꞌ qꞌu tenam tziꞌ? Utz ¿kantuꞌ nimotxtitzꞌa ibꞌanax kam aas yeꞌk itxaꞌk? ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Nimotximol tibꞌ qꞌu ijlenal tu u vatz txꞌavaꞌ. Nimotxiꞌan maꞌl iatz qꞌu qꞌesal tenam. Aꞌ nimotxinukꞌ iꞌantu tu u Tioxh tuchꞌ tu viTxaaom u Tioxh.» Texhichꞌaxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Utz nojchit imol tibꞌ qꞌu qꞌesala tu u tenam tzaꞌ. Inukꞌa aas kaniꞌch ibꞌanax tu u Tioxhla aTxaaom vaꞌl axh aqꞌon tijleꞌm. Aꞌ bꞌanon u Herodes, u Pooncio Pilato, ant imol qꞌu puerala aanima utz, tuchꞌ unjoltu qꞌu Israeel tu u tenam tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Motx iꞌan kajay qꞌu kam qꞌuꞌl alichnalka saaqꞌo aas siꞌaneꞌ. Aꞌ tzojpu vayol. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Pek aatz cheel kuBꞌaal, ila tan, nibꞌanax qiꞌ oꞌ niman eetz. Pek aqꞌ tzii aas tiira yeꞌk kuxoꞌval samotxqal paal vayolbꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Utz bꞌan atxumbꞌal ech siꞌan bꞌaꞌn qꞌu yaꞌv qaqꞌo. Utz kam koꞌn xheenya tuchꞌ txaichil satiqꞌo tibꞌ tu vibꞌii u Tioxhla aKꞌaol u Jesuus.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Uncheeꞌ taꞌxh veet motx iqꞌilat isikꞌlet Tioxh, yakich yikunoj u atibꞌal vaꞌl molichku tibꞌ. Utz ok u Tioxhla Espiiritu kꞌatza bꞌaꞌnil sikajayil. Ech yeꞌkich tek ixoꞌval, tuchꞌ techit xamlil nichmotxtal paal u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Uncheeꞌ tiira maꞌlich tekoꞌn itxumbꞌal kajay qꞌu aanima qꞌuꞌl nimanich tek tetz u Jesuus. Utz maꞌl iatz. Abꞌilich koj maꞌj aas: —Vetz sunjunal atziꞌ.— Chaj tiꞌ qꞌu tetz. Pek tiira junal komon tatin kajay qꞌu kam siatzaj. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ech tiira iqꞌomich iyakꞌil qꞌul ichaj u Jesuus tiꞌ ipaxsal itziiul u qꞌaavtitzꞌpu u kuBꞌaal Jesuus. Utz techal mamaj bꞌaꞌnil atich kꞌatza tu u Tioxh sikajayil. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ech yeꞌxhabꞌil koꞌxh maꞌj nichiyaꞌta tetz tixoꞌl. Tan abꞌil aꞌ atich untanoj itxꞌavaꞌ, oj maꞌj totzotz, nichikꞌayi utz, nichtiqꞌo ul vijaꞌmel. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Nichtaqꞌ tu qꞌul ichaj u Jesuus. Ech nichipaxsa el. Aꞌ nichmotxbꞌenku tiꞌ isav tetz sijununil. ");
INSERT INTO ixlCNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Echat iꞌan maꞌl u vinaj Xhep ibꞌii, vaꞌl Bernabee tek ibꞌii oksal tu qꞌul ichaj u Jesuus. Ikꞌayi untanul itxꞌavaꞌ. Utz tiqꞌo ul vijaꞌmel vatz qꞌul ichaj u Jesuus. Aatz u bꞌii Bernabee tziꞌ utz, “aqꞌol nimal kꞌuꞌl” chu u tokebꞌal. Aatzich u vinaj tziꞌ, ituꞌxh ixalamich u Levii utz, aa Chipreich. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Uncheeꞌ aatz iꞌan maꞌl u vinaj majte, Ananias ibꞌii utz, Safira u tixoj. Ikꞌayi untanul itxꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Loqꞌ inukꞌ tuchꞌ u tixoj tziꞌ aas sateesaka untxꞌajul vijaꞌmel vitxꞌavaꞌ. Ech untxꞌajtu koꞌn ex taqꞌ tu qꞌul ichaj u Jesuus. Loqꞌ tzꞌajel aas nichtaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ech aatz u Luꞌ tan, tal te ech tzaꞌ: —Ananias ¿kam tokeꞌ aas maꞌxh okyu u txꞌiꞌliꞌinaj tavaanima? Tan vetatxubꞌaꞌli u Tioxhla Espiiritu. Veteesalka untxꞌajul vijaꞌmel u txꞌavaꞌ vetakꞌayi. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tan eetz u txꞌavaꞌ. Utz kꞌuxh vetakꞌayi, ¿yitꞌ tzik eetz koj u puaj tzik? Pek ¿kantuꞌ vetiitzꞌa u onkonil tavaanima tziꞌ? Tan yitꞌ aanima koj vetatxubꞌaꞌlilaꞌ, pek u Tioxh.— Texh u Luꞌ te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ech taꞌxh tabꞌi qꞌu yol u Ananias tziꞌ, yakich nettzꞌoj kuꞌ vatz txꞌavaꞌ utz, kami. Ech yakich motx xoꞌvoj kajay qꞌu aanima taqꞌo qꞌuꞌl motx ilon abꞌin. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ech opon qꞌu xiak. Motx ibꞌach vichiꞌl. Motx teesa kꞌasuꞌl utz, ex imujka. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kamal oxvoꞌj oora tuul, opon u Safira, u tixojich u Ananias. Yeꞌich tootzaj kam vaꞌl maꞌtich tucheꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Aatz u Luꞌ, tal te ech tzaꞌ: —Al ve, ¿echil tzik vetekꞌayiv bꞌen vetxꞌavaꞌ tzaꞌ?— Texh te. —Eeꞌ. Echil aꞌ vaꞌl naaleꞌ tziꞌ.— Texh u Safira. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Tzaqꞌbꞌel tu u Luꞌ ech tzaꞌ: —¿Kam tokeꞌ aas nukꞌu vetebꞌan tiꞌ itxubꞌaꞌlil u Tioxhla Espiiritu tetz u kuBꞌaal? Pek saji iile; tul qꞌu xiak qꞌuꞌl ex mujunyuka vavinaj. Utz axh tek ul tiqꞌobꞌenaxh majte.— Texh u Luꞌ te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ech tu koꞌxh unmuꞌkꞌul, nettzꞌu kuꞌ u ixoj vatz tajan u Luꞌ utz, yakich kamoj. Ech taꞌxh okoꞌp qꞌu xiak, tila aas maꞌtich ikameꞌ. Utz tiqꞌo paj bꞌen. Ex imujka kꞌatz vivinaj. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ech techalich tek ixoꞌv qꞌu niman tetz u Jesuus taqꞌo tuchꞌ qꞌu aanima qꞌuꞌl abꞌin qꞌu kam tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Uncheeꞌ kaana xheenya tuchꞌ txaichil nichmotxiꞌan qꞌul ichaj u Jesuus xoꞌl qꞌu tenam. Molmochich chit tatin tu viqꞌanalil u totztioxh tu vaꞌl Xoꞌl Piraal Tetz Salomoon. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Pek aatz unjoltu qꞌu aanima, yeꞌich isaꞌ moloibꞌ tuchꞌ tu xoꞌval, kꞌuxh aal tiira techalich tok iqꞌii tu tereꞌn qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ech akꞌbꞌichil chit nichiꞌan qꞌuꞌl niman u kuBꞌaal Jesuus, sibꞌal vinajs ixoj nichtokeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Aal nichtekichelel eluꞌl qꞌu yaꞌv tu bꞌey viꞌ talaj txꞌach tuchꞌ viꞌ chelebꞌ yaꞌv. Nichmotxichꞌia ipaal u Luꞌ tu bꞌey. Ech tuchꞌ koꞌxhtuꞌ sakuꞌ visulich tibꞌa qꞌu yaꞌv, siꞌan bꞌaꞌn. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Utz sibꞌ aanima nichikꞌasuꞌl tu qꞌu tenam najaꞌch u Jerusaleen, iqꞌomal qꞌul iyaꞌv taqꞌo. Atia techalich tujlixsal tu u tioxhil txꞌiꞌliꞌinaj. Utz maꞌl chit iꞌantu bꞌaꞌn sikajayil. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Uncheeꞌ aatz u qꞌesal oksan yol vatz Tioxh, lakp iviꞌ tuchꞌ qꞌuꞌl atich kꞌatza. Ayaꞌ qꞌuꞌl saduceo ibꞌii u tuqꞌaybꞌal. Motx koꞌxh taqꞌan ichiꞌon taanima. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ech motx ul itxay qꞌul ichaj u Jesuus utz, motx ex taqꞌ kuꞌ tu tzeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pek aatz iꞌan tu aqꞌbꞌal, ul maꞌl u aanjel tetz Tioxh utz, ex ijaj vijubꞌalil u tzeꞌ. Ech tiqꞌo eluꞌl qꞌu chusulibꞌ utz, tal te ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Bꞌenojex tu viqꞌanalil u totztioxh. Paxsataj itziiul u bꞌaꞌnla yol tetz tiichajil.— Texh u aanjel. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ech inima. Qꞌalaꞌm chit motx bꞌen tu viqꞌanalil u totztioxh. Nichtekoꞌnpajmotxichusun tiꞌ u yolbꞌal Tioxh. Tuul aatz u qꞌesal oksan yol vatz Tioxh tuchꞌ qꞌul imol, motx imol tibꞌ tuchꞌ qꞌu qꞌesal qꞌatbꞌal tzii. Ayaꞌ kajay qꞌu qꞌesal qꞌatol tzii tu Israeel. Ech tal tiqꞌol opon qꞌu chusulibꞌ siatz. Ex iqꞌoloj tu tzeꞌ taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pek aatz okoꞌp qꞌu polesiꞌy tu u tzeꞌ, yeꞌkanich veꞌt qꞌu chusulibꞌ. Ech oora motx qꞌaavi. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Motx ex tal ech tzaꞌ: —Bꞌaꞌnla katxꞌumal u tzeꞌ vetoponoꞌ. Utz liista chit qꞌu xeen tzeꞌ vatz jubꞌal. Pek aatz vetkujaj u tzeꞌ, vetokoꞌpꞌoꞌ tuul utz, ¡abꞌil koj vaꞌtioj atile! ¡Yeꞌxhabꞌil!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Uncheeꞌ taꞌxh motx tabꞌi u yol u qꞌesal oksan yol vatz Tioxh, sotz chit ikꞌuꞌl taqꞌo. Ant imol u qꞌesal xeen tetz vikuentail u totztioxh utz, tuchꞌ unjoltu qꞌu qꞌesal oksan yol vatz Tioxh. Motx tek tal tibꞌilaj: —¿Kam sayaꞌk u kam tziꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ech tuul ankoꞌxh nichmotxiyoleꞌ, opon maꞌl u vinaj utz, tal te ech tzaꞌ: —Aatz qꞌu vinaj qꞌuꞌl etoksa tu tzeꞌ, atil tekoꞌn paj tu viqꞌanalil u totztioxh. Nipajmotxichus tenam.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Uncheeꞌ bꞌen u qꞌesal xeen tetz vikuentail u totztioxh, ant imol qꞌu polesiꞌy. Jik koꞌxh motx ex tiqꞌo kꞌasuꞌl qꞌul ichaj u Jesuus. Yeꞌt motx ikꞌaxbꞌixsa tan, nichmotxixoꞌva ipaqꞌax sivan tu qꞌu tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Uncheeꞌ taꞌxh motx oponi, motx ex taqꞌ vatz qꞌu qꞌesal qꞌatbꞌal tzii molich tibꞌ. Utz chꞌotil itziꞌ tu u qꞌesal oksan yol vatz Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Tal te ech tzaꞌ: —¿Yeꞌn qal sete tzik aas yeꞌkan sachusunex tiꞌ u bꞌii tziꞌ? Tan maꞌxh motx epaxsal itziiul vechusbꞌal tu u Jerusaleen tzaꞌ. Utz oꞌ tek netaqꞌbꞌenoꞌ ataj paav tiꞌ vikam u vinaj tziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Uncheeꞌ tzaqꞌbꞌel tu u Luꞌ tuchꞌ tu tereꞌn qꞌul ichaj u Jesuus. Motx tal tzaꞌ: —Ministeer aꞌ bꞌaxal sakunima u Tioxh vatz qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Tan aatz u Tioxh, viTioxh qꞌu kukꞌuy kumam, aꞌ qꞌaav itzꞌpixsan u Jesuus vaꞌl etal ijeꞌ vatz kurus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Utz vetikꞌujbꞌaꞌl u Jesuus sikꞌatza tu Amlika. Vettaqꞌlu bꞌens qꞌesala. Utz vettaqꞌlu tijleꞌm tiꞌ ichitpul aanima tipaav. Aꞌ isaꞌ saqꞌaavoꞌk qꞌu Israeel kꞌatza ech sikuy vipaav. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Utz nojchit oꞌ ilon abꞌin qꞌu kam niqaleꞌ tzaꞌ. Antu u Tioxhla Espiiritu majte vaꞌl vettaqꞌlu u Tioxh tu qꞌu niman tetz.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ech taꞌxh tabꞌi qꞌu yol tziꞌ, yakich motx pultoj taanima tu kꞌaꞌnal taqꞌo. Utz siꞌchtekmotxiyatzꞌeꞌ tala. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pek txakeꞌ maꞌl u fariseo tu xoꞌl, Gamalieel ibꞌii, aa txumbꞌal tiꞌ u oꞌtla mantaar. Tiira atil tatin vatz kajay qꞌu tenam. Txakeꞌi utz, tal teluꞌl unmuꞌkꞌul qꞌul ichaj u Jesuus qꞌanal. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Tal tek ech tzaꞌ: —Vinaj Israeel, nachtaj bꞌaꞌnil kam sebꞌan tu qꞌu vinaj tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Tan atich maꞌl u vinaj koꞌxten majte, Teudes ibꞌii. Nichtaqꞌ bꞌens tibꞌ mam vinaj. Atil tijleꞌm nichtaleꞌ. Utz nojchit mam tenam ok tiꞌ. Kamal 400. Pek yatzꞌaxi utz, motx texh ipaxi tibꞌ qꞌuꞌl maꞌtich tok tiꞌ. Taꞌn sotzchil iꞌana. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pek xamtel paj tuul, chee koꞌn paj vaꞌte, Judas ibꞌii, aa Galilea; aꞌ chit nichtel tachul kajay qꞌu aanima. Utz tenam paj chit ok tiꞌ. Pek yatzꞌaxi utz, motx koꞌn paj ipaxika tibꞌ qꞌuꞌl ok tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ech tok nival sete cheel. Sajitaj koꞌn qꞌu vinaj tziꞌ. Yeꞌ eqꞌila ok. Tan oj tetz koꞌn vinaj qꞌu chusbꞌal tuchꞌ qꞌu kam niꞌaneꞌ tziꞌ, toj koꞌxh sotzoj atziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pek oj nojchit tetz Tioxh, tech koj ex tiꞌ isotzsaleꞌ. Aal bꞌantaj kuenta etibꞌ tan, maꞌl siꞌaneꞌ aas aꞌ oj emol Tioxh nebꞌan chꞌaꞌo tu qꞌuꞌl nebꞌaneꞌ tziꞌ.— Texh u Gamalieel te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Utz ech chit motx iꞌana. Qꞌaav isikꞌle okoꞌp qꞌul ichaj u Jesuus utz, tzꞌuꞌmamal texh motx iꞌana. Aatz veet motx itzꞌuꞌmataꞌ, tiira tal te aas taꞌn samotxiyaꞌsa talax paal qꞌu yol tu vibꞌii u Jesuus. Ech ichajputaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ech ikꞌasuꞌl qꞌul ichaj u Jesuus tu u molbꞌal tibꞌ qꞌu qꞌatol tzii. Utz vaꞌlich koꞌn motx itxuqꞌtxun tiꞌ tan, u Tioxh aqꞌon tzii te aas eesal iqꞌii tiꞌ vibꞌii u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Utz jun chit qꞌii nichmotxichusun tu viqꞌanalil u totztioxh tuchꞌ tulaj atibꞌal. Nichipaxsa itziiul u bꞌaꞌnla chusbꞌal tiꞌ u Jesuus, ayaꞌ u Cristo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Uncheeꞌ akꞌbꞌichil chit nichiꞌan u tachul qꞌu niman tetz u Jesuus tu u tiempo tziꞌ. Ech aatz iꞌana, xochon qꞌu Israeel qꞌuꞌl griego iyolbꞌal vatz qꞌul ichaj u Jesuus. Motx ixoch qꞌuꞌl hebreo iyolbꞌal tan, yitꞌ ela koj ivatz nichibꞌancheꞌ. Utz yitꞌ tzꞌajel koj teloꞌp techbꞌubꞌal qꞌu txakay ixoj qꞌuꞌl griego iyolbꞌal nichibꞌanax tu qꞌu hebreo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ech aatz tek kabꞌlaal qꞌul ichaj u Jesuus, motx imol qꞌu niman tetz u Jesuus. Utz motx tal te ech tzaꞌ: —Yitꞌ ijikomal koj aas sakuyaꞌsa talax u yolbꞌal Tioxh tiꞌ ijatxax echbꞌubꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Pek aatz cheel, txaataj jujvaꞌl vinaj texoꞌl aas nojchit bꞌaꞌn talcheꞌ. Utz atil u Tioxhla Espiiritu kꞌatza bꞌaꞌnil utz, tekꞌ atil itxumbꞌal. Ech saqaqꞌ u aqꞌon te tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Tan aatz oꞌ, aꞌ tzukꞌel sakuqꞌila sikꞌle Tioxh utz, sakupaxsa itziiul u yolbꞌal Tioxh.— Texh qꞌul ichaj u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Utz tiira bꞌaꞌn bꞌenku qꞌu yol tu qꞌu niman tetz u Jesuus tziꞌ. Ech motx itxaal u Esteban. Maꞌl vinaj aas tiira kꞌujlel ikꞌuꞌl tiꞌ Tioxh bꞌaꞌnil utz, atil u Tioxhla Espiiritu kꞌatza bꞌaꞌnil. Utz ant itxaael majte qꞌu vinaj tzaꞌ: u Felipe, u Proocoro, u Nicanoor, u Timoon, tuchꞌ u Parmenas utz, tuchꞌ u Laxh aa Antioquia, vaꞌl oknajich tiꞌ u tuqꞌaybꞌal qꞌu Israeel, kꞌuxh yitꞌ Israeel koj tu titzꞌpebꞌal. Pek nimanich tek tetz u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ech motx tiqꞌo opon vatz qꞌul ichaj u Jesuus. Motx taqꞌ jeꞌ iqꞌabꞌ tibꞌa utz, motx iqꞌila isikꞌle Tioxh tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Utz kaanaich ipax paal itziiul u yolbꞌal Tioxh. Techalich takꞌbꞌu u tachul qꞌu niman tetz u Jesuus tu Jerusaleen. Utz sibꞌal qꞌu oksan yol vatz Tioxh nichniman majte. ");
INSERT INTO ixlCNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Aatz u Esteban tan, techalich ixamlil aqꞌel tu u Tioxh. Utz atich vibꞌaꞌnil u Tioxh kꞌatza majte. Techal bꞌoj txaichil tuchꞌ xheenya nichiꞌan xoꞌl qꞌu tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pek motx lakp iviꞌ unjolol qꞌu Israeel tiꞌ. Ayaꞌ qꞌu aanima qꞌuꞌl “qꞌu chajpumal” chu teꞌleꞌ. Ant unjolol aa Cirene, aa Alejandria, aa Ciliicia tuchꞌ unjot aa Aasia. Nichmotxiyaa yoli tibꞌ tuchꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pek nichkojisubꞌ u Esteban tu yol tan, techal itxumbꞌal aqꞌich tu u Tioxhla Espiiritu. ");
INSERT INTO ixlCNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Uncheeꞌ aatz tek motx iꞌana, ipuaji ivatz unjolol vinaj; aꞌ isaꞌ satal ech tzaꞌ: —Vetqabꞌi tuchꞌ kuxichin aas niteesa iqꞌii Tioxh u Esteban utz, niteesa iqꞌii qꞌul imantaar u Moisees majte.— Chaj. ");
INSERT INTO ixlCNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ech motx ilak qꞌu tenam tuchꞌ qꞌu qꞌesal qꞌatol tzii, tuchꞌ qꞌu aa txumbꞌal tiꞌ u oꞌtla mantaar. Utz motx ex itxay u Esteban. Motx tiqꞌo bꞌen vatz qꞌu qꞌatol tzii molich tibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Utz motx paj toksa txakbꞌaꞌn txubꞌaꞌl majte. Motx tal ech tzaꞌ: —Aatz u vinaj tziꞌ, yeꞌxh niyaꞌ tiꞌ iyoqꞌax u mantaar tuchꞌ u totztioxh tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Vetqabꞌi taltaꞌ aas suꞌlaqꞌaxoj kuꞌ vikuentail u totztioxh tu u Jesuus u aa Nazareet tzaꞌ. Nital majte aas siyaꞌsa qꞌu kostuumbre qꞌuꞌl aqꞌelka tu u Moisees.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Uncheeꞌ aatz qꞌu qꞌesala qꞌuꞌl chꞌuxhlich opon tu u molbꞌalibꞌ tziꞌ, tii nichmotxisaji u Esteban. Utz tila aas ech tek ivatz aanjel vivatz u Esteban. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Uncheeꞌ aatz u qꞌesal oksan yol vatz Tioxh, ichꞌoti tek tu u Esteban ech tzaꞌ: —¿Nojchixh qꞌu yol nitalax saiꞌ tziꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Tzaqꞌbꞌu u Esteban utz, tal ech tzaꞌ: —Vitzꞌin vatzik, tuchꞌ ex qꞌesal tenam, tzꞌinbꞌaꞌtaj exichin etileꞌ. Tan aatz iꞌan u kutechalla Tioxh, chee vatz u kukꞌuy kumam u Abrahaam, aꞌ chit atich tikuenta u txꞌavaꞌ Mesopotaamia, yeꞌsajenich en jejeꞌoj tu u txꞌavaꞌ vaꞌl Haraan. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Utz tal u Tioxh te ech tzaꞌ: «Elenbꞌen tu vatxꞌavaꞌ vaꞌl atilkꞌaxh tziꞌ. Aqꞌka qꞌul iitzꞌin aatzik utz, aꞌ seꞌenkꞌaxh tu u txꞌavaꞌ vaꞌl sunkꞌuch see.» Texh u Tioxh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Uncheeꞌ ech ikꞌasuꞌl u Abrahaam tikuenta vitxꞌavaꞌ qꞌu caldeo utz, ex jejeꞌoj tu u txꞌavaꞌ Haraan. Aꞌ kamku vitat tziꞌ. Ech u Tioxh paj alon tul tu u txꞌavaꞌ vaꞌl atilkꞌoꞌ cheel tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Loqꞌ yeꞌt aqꞌax itxꞌavaꞌ tu u Tioxh. Nikoꞌxh bꞌoj kuꞌebꞌal tajan. Pek bꞌaꞌntan tal te aas sataqꞌeꞌ analen maꞌt ikameꞌ. Loqꞌ tetz qꞌuꞌl ituꞌxh ixalam siꞌaneꞌ aas lakami tala, kꞌuxh aal yeꞌkich maꞌj initxaꞌa tu u tiempo tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Tal u Tioxh te ech tzaꞌ: «Aatz qꞌul atuꞌxh axalam saꞌatin tu maꞌl u txꞌavaꞌ, yitꞌ tetz koj. Puera koꞌn tatin tuul siꞌaneꞌ. Utz saꞌxhoksal tu aqꞌon. Txumbꞌal iveet sabꞌanax tu maꞌl 400 yaꞌbꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Loqꞌ xamtel sichoo qꞌu tenam vaqꞌo qꞌuꞌl saoksan tu aqꞌon. Utz samotxelkꞌasuꞌl qꞌul atuꞌxh axalam tziꞌ. Samotxꞌul tu u txꞌavaꞌ tzaꞌ. Utz samotxꞌulinachꞌin tzaꞌ.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Uncheeꞌ aatz u Tioxh tan, taqꞌ maꞌl u echlal tu u Abrahaam tetz u nukꞌuꞌm iꞌan tuchꞌ. Ayaꞌ vaꞌl satzokꞌax el bꞌiil ichiꞌl qꞌu vinaj. Ech aatz u Abrahaam tan, inima. Aatz itzꞌpu vikꞌaol vaꞌl Isaac, itzokꞌeꞌl bꞌiil ichiꞌl aas tzꞌaj vaaxajil qꞌii titzꞌpeꞌ. Echat koꞌxh iꞌan u Isaac tu vikꞌaol majte vaꞌl Jacoob. Utz echat paj iꞌan u Jacoob majte, motx itzokꞌeꞌl bꞌiil ichiꞌl kabꞌlaal qꞌul ikꞌaol. Ayaꞌ qꞌu kukꞌuy kumam, oꞌ Israeel. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Pek aatz iꞌan qꞌu kukꞌuy kumam, qꞌul ikꞌaol u Jacoob, motx chiꞌon taanima tiꞌ vitzaꞌqꞌ, ayaꞌ u Xhep. Ech motx ikꞌayi bꞌen tu Egipto. Loqꞌ atich Tioxh kꞌatz u Xhep. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ech u Tioxh eesan tu qꞌu tzaꞌl paalka utz, taqꞌ itxumbꞌal. Ech tiira bꞌaꞌn u Xhep til u ijlenal faraoon tu Egipto. Ech toksat kaꞌbꞌ ijlenalil kꞌatza utz, ilol tetz qꞌul imeꞌbꞌiꞌl tu tatibꞌal majte. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Uncheeꞌ ul mam vaꞌy tu jankꞌal u txꞌavaꞌ tikuenta Egipto tuchꞌ tikuenta u txꞌavaꞌ Canaan majte. Motx ok tu mam il tzaꞌl. Yeꞌ nichichee veꞌt titzꞌlebꞌal qꞌu kukꞌuy kumam. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ech aatz tabꞌi u Jacoob aas atich itzꞌlebꞌal tu Egipto, ichaj bꞌen qꞌul ikꞌaol tiꞌ tiqꞌol triigo. Ayaꞌ qꞌu kukꞌuy kumam. Aꞌ u bꞌaxa ibꞌen tu Egipto tiꞌ echbꞌubꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ech tu tek ikaꞌpaj ibꞌenaꞌ, tal tek u Xhep tu qꞌu tatzik aas aꞌ u tzaꞌqꞌa. Ech tootzaji u faraoon majte aas kam aanimail u Xhep. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Uncheeꞌ aatz u Xhep, tal tek tiqꞌol opon u Jacoob. Ant imol kajay qꞌu titzꞌin tatzik. 75 ixaaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ech ibꞌenoꞌk u Jacoob tu Egipto. Xamtel tuul, aꞌ tek kamku tziꞌ tuchꞌ qꞌul ikꞌaol ayaꞌ qꞌu kukꞌuy kumam. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Loqꞌ iqꞌol bꞌen vichiꞌl u Jacoob tu Siqueem tikuenta Canaan. Aꞌ ex mujlojku tu u mujbꞌal vaꞌl iloqꞌ u Abrahaam tu qꞌul ikꞌaol maꞌl u vinaj Hamoor ibꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Uncheeꞌ aatz tek nichinajabꞌ u tiempo tiꞌ itzojpu viyol u Tioxh vaꞌl tal tu u Abrahaam, akꞌbꞌichil chit nichiꞌan qꞌu Israeel tu Egipto. Chꞌiichil chit nichiꞌan tachul. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ech ok koꞌxh vaꞌt u ijlenal tu Egipto tuul. Utz tootzajich koj abꞌilich u Xhep. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ech aatz u ijlenal tziꞌ, iꞌan onkonil tu qꞌu kukꞌuy kumam. Nichiyaꞌlu tiꞌ toksat qꞌu talaj neꞌ vatz kamchil. Ech yeꞌk saꞌakꞌbꞌi. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Loqꞌ aatz tu u tiempo tziꞌ, itzꞌpu maꞌl u tal xiak, Moisees ibꞌii. Utz tiira txꞌanelich vatz Tioxh. Pek oxvaꞌl koꞌn ichꞌ iꞌan kꞌatz itxutx ibꞌaal. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Tan aatz yeꞌt veet veꞌt imujleꞌ, oksal tek vatz kamchil. Pek sikꞌax tu vimeꞌal u faraoon. Utz aꞌ tek chꞌiisan. Taqꞌ bꞌens titzꞌin. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ech chusax u Moisees tu kajay qꞌu tootzajibꞌal qꞌu aa Egipto. Aqꞌelich iviꞌ qꞌul iyol utz, aqꞌel iviꞌ vibꞌanoneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Uncheeꞌ aatz tzꞌaj 40 iyaꞌbꞌ, ul qꞌu tetz aa tenamil sikꞌuꞌl, ayaꞌ qꞌu Israeel. Ech ex tileꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Utz tila aas nichiqꞌosax maꞌl qꞌu Israeel tu maꞌl u aa Egipto. Ech toksa tibꞌ tiꞌ, yakich iyatzꞌ u aa Egipto tziꞌ. Aꞌ ichoo taqꞌo kam vaꞌl nichiꞌan tu u Israeel. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Tan nichtitzꞌa u Moisees aas sapaal itxumbꞌal qꞌu tetz aa tenamil tuul aas u Tioxh nichajon u Moisees tiꞌ teesal tu tzaꞌl. Loqꞌ yeꞌt motx paal itxumbꞌal tuul. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Uncheeꞌ aatz evtich tek tuul, opon paj u Moisees tixoꞌl. Utz tila aas nichmotxiꞌan chꞌaꞌo kaꞌvaꞌl qꞌu Israeel tibꞌilaj. Ech siꞌchtoksa ibꞌaꞌn tibꞌilaj tala. Tal te ech tzaꞌ: «Emol etibꞌ utz, ¿kantuꞌ nikoꞌxheqꞌos etibꞌ?» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ech aatz vaꞌl xeꞌtixsan u chꞌaꞌo tan, ikꞌoꞌpi koꞌn u Moisees utz, tal te ech tzaꞌ: «¿Abꞌil vetoksanaxh qꞌesalail tu kuxoꞌl bꞌatzꞌi? ¿Suꞌlatxꞌol kunujul naal tzik? ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Sayatzꞌin tzik echaꞌ iyatzꞌax u aa Egipto aꞌan eet?» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ech taꞌxh tabꞌi u Moisees qꞌu yol alax te tziꞌ, yakich tek oojoj. Aꞌ ex jejeꞌojku tu maꞌl u txꞌavaꞌ Madiaan ibꞌii. Puera aanima koꞌn tatin tziꞌ. Utz atin kaꞌvaꞌl ikꞌaol latziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Uncheeꞌ aatz paal 40 yaꞌbꞌ tuul, chee maꞌl u aanjel siatz tu u tzꞌinlich tzaji txꞌavaꞌ najaꞌch u muunte Sinaii. Chee siatz tu u xamal nichtoyvu tiꞌ maꞌl u jinkin chꞌiꞌx. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Utz tzꞌejxu chit ikꞌuꞌl u Moisees tu vaꞌl nichtileꞌ tziꞌ. Tan yeꞌxhkam nichitzꞌeꞌ u chꞌiꞌx. Ech ixaan opon kꞌatza. Aꞌ isaꞌ siꞌchisaji bꞌaꞌnil. Utz aꞌ tek tabꞌi iqꞌilal tu u Tioxh. Tal te ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","«In viTioxh qꞌul akꞌuy amam. In iTioxh u Abrahaam, iTioxh u Isaac utz, iTioxh u Jacoob.» Texh u Tioxh te. Ech vaꞌlich tek itꞌuntꞌuꞌlan u Moisees tu xoꞌval. Yeꞌt iqꞌiꞌ veꞌt isajileꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Utz tal paj u Tioxh te ech tzaꞌ: «Eesa vapel xaabꞌ taajan tziꞌ tan, viꞌ tioxhla txꞌavaꞌ atikꞌaxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Saabꞌi tan, nojchit maꞌxh villaꞌ aas tiira txumbꞌal iatz vuntenam atil okoꞌp tu Egipto. Vetvabꞌil qꞌul ixochon sunvatz. Ech tokeꞌ kuꞌyuꞌlin tu Amlika. Ul veesa tu qꞌu tzaꞌl atilka. Pek oraꞌxh tan, saqꞌaavbꞌenaxh tu Egipto. Sunchajaxh tiꞌ teesal kꞌasuꞌl tziꞌ.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ech ichajax bꞌen u Moisees tu u Tioxh bꞌanaxi. Ichaj tiꞌ ibꞌanax qꞌesalail xoꞌl qꞌu tetz aa tenamil utz, tiꞌ teesal kꞌasuꞌl tu Egipto. Aꞌ lochon u aanjel vaꞌl chee siatz kꞌatz u jinkin chꞌiꞌx. Aꞌ qꞌesalain, kꞌuxh maꞌtich koꞌn talax te tu maꞌl qꞌu tetz aa tenamil ech tzaꞌ: «¿Abꞌil unchajonaxh aas suꞌlaꞌan qꞌesalail tu kuxoꞌl utz, suꞌlatxꞌol kunujul?» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ech u Moisees iqꞌon eluꞌl qꞌu kukꞌuy kumam tu Egipto. Utz mamaj txaichil tuchꞌ xheenya ikꞌuch tu Egipto tuchꞌ tu u Kaj Mar. 40 yaꞌbꞌ ikꞌuch txaichil tu u tzꞌinlich tzaji txꞌavaꞌ vaꞌl motx paalka. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Utz u Moisees vaꞌl alon tu qꞌu Israeel ech tzaꞌ: «Aatz u Tioxh, saꞌnalicheesa maꞌl alol tetz viyolbꞌal texoꞌl, echaꞌ in tzaꞌ aꞌ vaꞌl senima.» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Utz anchit u Moisees qꞌesalain xoꞌl qꞌu Israeel tu tzꞌinlich tzaji txꞌavaꞌ. Antu atich viꞌ u muunte Sinaii. Aꞌ kꞌulun qꞌu yol tetz tiichajil taqꞌ u aanjel. Aꞌ chit aꞌich imol qꞌu kukꞌuy kumam. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Pek aatz qꞌu kukꞌuy kumam, yeꞌt koꞌn inima. Motx koꞌn taqꞌka eloꞌp echil tziꞌ. Utz taꞌn tii motx titzꞌa u Egipto. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Aal motx koꞌn tal tu u Aroon ech tzaꞌ: «Bꞌan kutioxh, iqꞌon kubꞌey. Tan yeꞌ qootzaj kam nabꞌ vetiꞌanlu u Moisees bꞌa vaꞌl iqꞌoneluꞌloꞌ tu Egipto.» Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ech motx itzꞌaj maꞌl vatzibꞌal vaakaxh. Utz motx chit toksa txꞌoloꞌm vatz vibꞌanich tioxh tziꞌ. Kaana motx itxuqꞌtxun tiꞌ kꞌuxh itzꞌajoꞌm koꞌn tuchꞌ iqꞌabꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Echtzixeꞌt elabꞌeltekka tu u Tioxh. Taqꞌ texh tzii te aas aꞌ tek siqꞌila isikꞌle qꞌu txꞌumiꞌl tu amlika tuchꞌ tereꞌn qꞌu txijtxubꞌal. Echaꞌ vaꞌl tzꞌibꞌamalnalka tu qꞌu alol tetz u yolbꞌal Tioxh aas tal ech tzaꞌ: «Aatz ex Israeel, oj tzik in veteqꞌila esikꞌleꞌin tuchꞌ qꞌul etxꞌoloꞌm tu u tzꞌinlich tzaji txꞌavaꞌ tu 40 yaꞌbꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Pek aꞌ atil tetaanima vebꞌanich tioxh Moloc tuchꞌ vitxꞌumiꞌlil vaꞌt vetioxh vaꞌl Refaan. Utz ela koꞌxh tuchꞌ chelemal u nachbꞌal tetz setaqꞌo. Aꞌ qꞌu vatzibꞌal ebꞌana tziꞌ utz, eqꞌila esikꞌle. Echtzixeꞌt sunyakeꞌsa bꞌenex tzian, yaklel ex vatz bꞌen u Babiloonia.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Uncheeꞌ aatz nichipaal qꞌu kukꞌuy kumam tu u tzꞌinlich tzaji txꞌavaꞌ, atich u bꞌuꞌj totztioxh tzixeꞌ, u techlal u nukꞌuꞌm vaꞌl iꞌan u Tioxh tuchꞌ. Ayaꞌ vaꞌl u Tioxh alon tu u Moisees kaniꞌch iveet siꞌaneꞌ. Utz ech chit iveet iꞌana. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Utz ikꞌul qꞌu kukꞌuy kumam u bꞌuꞌj totztioxh tziꞌ. Ech aꞌ motx iqꞌon opon tu qꞌu txꞌavaꞌ oponku u Josuee. Iqꞌomich taqꞌo aas bꞌajax el qꞌu puera aanima tu u Tioxh vatz qꞌu kukꞌuy kumam. Utz ankoꞌxh atich u bꞌuꞌj totztioxh tikuenta u Daviid. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Uncheeꞌ bꞌaꞌn bꞌenku u Daviid vatz u Tioxh. Pek kꞌuxh tachva sataqꞌ jeꞌ maꞌl otzotz, tatibꞌal u Tioxh, viTioxh u Jacoob, yeꞌt iꞌana. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pek u Salomoon aqꞌon jeꞌ u totztioxh tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Kꞌuxh aatz u Tꞌankin Tioxh, aꞌ koj chit atilku tu otzotz ibꞌanoꞌm aanima. Tan echaꞌ vaꞌl alelka tu u alol tetz u yolbꞌal Tioxh aas nital ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","«Aꞌ unkꞌujlebꞌal u Amlika. Utz aꞌ kuꞌebꞌal vajan u vatz txꞌavaꞌ. Ech ¿kam tek bꞌanel tu vaꞌt vatibꞌal setaqꞌ jeꞌ? Utz ¿abꞌiste tek u atibꞌal vaꞌl sailankꞌin netaleꞌ? ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Tan ¿yitꞌ tzik in koj unbꞌanon kajay qꞌu kam tziꞌ tzik? Chu u Tioxh.» Texh u alol tetz u yolbꞌal Tioxh.— Texh u Esteban. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Utz tal paj u Esteban tu qꞌu qꞌatbꞌal tzii ech tzaꞌ: —Aatz ex, jolol ex txokop txumbꞌal tuchꞌ qꞌul etaanima. Ayaꞌl kala yeꞌ netabꞌi qꞌu kam tetz u Tioxh tiloneꞌ. Yeꞌ nenima viyol tuchꞌ etaanima. Echaꞌ ex puera aanima kꞌatza. Echaꞌ yitꞌ tzokꞌel el bꞌiil echiꞌl tu vetxumbꞌal netoksa tziꞌ. Sakoꞌnchitpaal etetz vatz u Tioxhla Espiiritu netxumeꞌ. ¡Aꞌ vetmotxexetiqꞌo viqelon qꞌul ekꞌuy emam! ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Tan aatz qꞌul ekꞌuy emam, motx tojcha kajay qꞌu alol tetz u yolbꞌal Tioxh. Motx koꞌn iyatzꞌ qꞌuꞌl yolon tiꞌ u tulebꞌal u Jesuus, ayaꞌ vijikomal. Vaꞌl vetkoꞌnexocha utz, ex unyatzꞌon. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Tan kꞌuxh titziꞌ chit aanjel nekꞌulvu qꞌu mantaar Tioxh, nikoꞌxh maꞌkojekola utz, maꞌkojenima.— Texh u Esteban. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Uncheeꞌ taꞌxh motx tabꞌi qꞌu kam qꞌu qꞌatbꞌal tzii tzaꞌ, motx pultu taanima tu kꞌaꞌnal tiꞌ. Tiira motx ikꞌux tibꞌ tee taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pek ech koj u Esteban tan, tiira atich u Tioxhla Espiiritu kꞌatza. Ech taꞌxh sajin jeꞌ tu Amlika, til u mam itechalil u Tioxh. Utz til u Jesuus majte atich tisebꞌal u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ech taꞌxh tila, tal ech tzaꞌ: —¡Sajitaj etileꞌ, nivil u Amlika jajlele! Utz ¡nivil u Jesuus, u Kꞌaola vaꞌl bꞌennaj koꞌn aanima, atil tisebꞌal u Tioxh!— Texh u Esteban. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Uncheeꞌ aatz tek qꞌuꞌl molich tibꞌ, motx ijup ixichin. Motx qꞌeqꞌun sikajayil. Ech maꞌl chit motx ex itxaytu u Esteban. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Motx iqini eluꞌl tiꞌ eluꞌl u tenam ech motx ipaqꞌ sivan. Utz aatz qꞌu xochol tetz, qꞌu txakbꞌaꞌn txubꞌaꞌl, motx taqꞌka qꞌul ikaapa kꞌatz maꞌl u xiak, Saulo ibꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Pek aatz u Esteban tan, nichkoꞌniqꞌila isikꞌle Tioxh tuul nichipaqꞌax sivan. Utz tal ech tzaꞌ: —UnBꞌaal Jesuus, kꞌul topon u vaanxelal tzaꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ech pecheꞌi utz, qetun taltu ech tzaꞌ: —UnBꞌaal ooksach tetz vipaav qꞌu aanima tziꞌ.— Texhtuꞌ. Ech taꞌxh veet tala, kami. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Utz antu u Saulo tal iyol tiꞌ vikam u Esteban. Uncheeꞌ aatz tu u qꞌii tziꞌ xeꞌt maꞌl mam txayoꞌm. Aꞌ nichichokax qꞌu niman tetz u Jesuus qꞌuꞌl atich tu Jerusaleen. Ech ipaxi tek bꞌen tibꞌ tu unjot tenam. At bꞌen tikuenta Judea. Utz at bꞌen tikuenta Samaaria. Pek ech koj qꞌul ichaj u Jesuus tan, yeꞌt motx bꞌeni. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Uncheeꞌ unjolol qꞌu bꞌaꞌnla chaj vinaj mujun vichiꞌl u Esteban. Utz mam oqꞌel motx iꞌan tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ech koj u Saulo tan, vaꞌlich ichoktu qꞌu niman tetz u Jesuus. Sisotzsa tala. Jun otzotz ibꞌenaꞌ. Utz nichijuxu eluꞌl vinajs ixoj. Ech nichentaqꞌ kuꞌ tu tzeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Tuul aatz qꞌu niman tetz u Jesuus qꞌuꞌl motx ipaxi bꞌen tibꞌ. Til koꞌxh nichipaxsav itziiul u bꞌaꞌnla chusbꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Aatz u Felipe, bꞌen tu maꞌl u tenam tikuenta Samaaria. Nichipaxsa paal itziiul u Jesuus viTxaaom u Tioxh tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ech vaꞌlich chit ibꞌen ikꞌuꞌl qꞌu aanima tiꞌ tabꞌil qꞌu kam nichtal u Felipe. Tan nichmotxtil qꞌu txaichil nichiꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Sibꞌal qꞌu aanima atich tioxhil txꞌiꞌliꞌinaj kꞌatza nichiꞌan bꞌaꞌn. Nichiqetun tel qꞌu tioxhil txꞌiꞌliꞌinaj. Utz sibꞌal qꞌuꞌl numtzꞌinajich ichiꞌl tuchꞌ qꞌu koꞌx nichiꞌan bꞌaꞌn majte. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ech techalich bꞌoj itxuqꞌtxun qꞌu aanima tu u tenam tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Utz atich maꞌl u vinaj tu u tenam tziꞌ, Xhim ibꞌii. Aꞌ nichiꞌan aa qꞌiil. Utz tzꞌejxinaj chit qꞌu aa Samaaria tiꞌ. Tan nichtaqꞌ bꞌen tibꞌ mam vinaj. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Utz kajay aanima nichabꞌin u Xhim, chꞌooajs nimaj. Nichmotxtal tiꞌ ech tzaꞌ: —Aꞌ u mam yakꞌil tetz u Tioxh atziꞌ.— Chu tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Utz bꞌennajich chit ikꞌuꞌl tiꞌ tan, oꞌtenich koꞌxh isubꞌtu qꞌu aanima tu viqꞌiianeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pek aatz qꞌu aanima, motx inima u bꞌaꞌnla chusbꞌal vaꞌl nichipaxsa itziiul u Felipe tiꞌ viQꞌesalail u Tioxh tuchꞌ tiꞌ vibꞌii u Jesucristo. Utz motx tek iꞌan ivautiismo vinaj ixoj. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Utz antu tek u Xhim, ok niman u Jesuus majte. Ibꞌan ivautiismo. Utz xamich techit tiꞌ u Felipe. Utz tzꞌejx ikꞌuꞌl tiꞌ qꞌu mamaj txaichil tuchꞌ qꞌu xheenya nichiꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Utz tabꞌi qꞌul ichaj u Jesuus qꞌuꞌl atich tu Jerusaleen aas maꞌtich tok unjolol qꞌu aa Samaaria tiꞌ inimal u yolbꞌal Tioxh. Ech ichaj bꞌen u Luꞌ tuchꞌ u Xhan latziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Taꞌxh motx oponi, motx iqꞌila isikꞌle Tioxh tiꞌ qꞌu niman tetz u Jesuus, ech saok u Tioxhla Espiiritu kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tan yeꞌsajich tok u Tioxhla Espiiritu kꞌatz maꞌj. Pek taꞌxh maꞌtich motx ibꞌant ivautiismo tibꞌii u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Uncheeꞌ motx taqꞌ jeꞌ iqꞌabꞌ qꞌu chusulibꞌ tiviꞌ qꞌu niman tetz u Jesuus. Ech ok u Tioxhla Espiiritu kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Utz aatz til u Xhim aas nichtok u Tioxhla Espiiritu kꞌatz qꞌu niman tetz u Jesuus tu koꞌxh u taqꞌtu jeꞌ iqꞌabꞌ qꞌul ichaj u Jesuus tiviꞌ, talaꞌtziꞌi tek ipuaj. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Tal te ech tzaꞌ: —Aqꞌtaj vetz u yakꞌil atil sekꞌatza tziꞌ. Ech abꞌil iꞌ savaqꞌvu jeꞌ unqꞌabꞌ, yak sikꞌul u Tioxhla Espiiritu majte.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Aatz tek u Luꞌ tan, tal te ech tzaꞌ: —Aꞌ amol vatz apuaj sasotzꞌaxh tziꞌ. Tan aꞌ niitzꞌa aas tuchꞌ puaj sakꞌul u oya nitaqꞌ u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ech yeꞌk ookebꞌal tiꞌ u kam tziꞌ utz, yeꞌk saꞌaqꞌax see tan, yitꞌ jikom koj vavaanima vatz u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Pek kꞌaxa akꞌuꞌl tiꞌ vapaav utz, jajabꞌe u Tioxh tiꞌ. Ech kamal likuyaxh tiꞌ vaꞌl niitzꞌa tavaanima tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Tan nivileꞌ aas tiira kꞌay val aatineꞌ utz, txayelaxh tu onkonil.— Texh u Luꞌ te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Uncheeꞌ tzaqꞌbꞌu tek u Xhim utz, tala: —Qꞌilataj sikꞌletaj u kuBꞌaal viꞌ ech yeꞌk sakuꞌ qꞌu kam viꞌ qꞌuꞌl vetetallu ve tziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Uncheeꞌ aatz veet ichustu u yolbꞌal Tioxh qꞌul ichaj u Jesuus, eltekbꞌen. Utz paal tal itziiul u bꞌaꞌnla chusbꞌal tunjot talaj tenam tikuenta Samaaria majte. Ech qꞌaavtekbꞌen tu Jerusaleen. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Uncheeꞌ qꞌilal u Felipe tu maꞌl viaanjel u Tioxh. Tal te ech tzaꞌ: —Kuxh. Aal abꞌen tikuenta aal ikuꞌeꞌ tiꞌ u bꞌey nitelbꞌen tu Jerusaleen yak tu Gaza. Ayaꞌ u bꞌey vaꞌl nipaal tu tzꞌinlich tzaji txꞌavaꞌ.— Texh u aanjel te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ech ibꞌenaꞌ. Utz aatz atich ok tiꞌ vibꞌey, til maꞌl u vinaj aa Etiopia; qꞌesala kꞌatz u ixoj ijlenal tu Etiopia vaꞌl Candase ibꞌii. Kololich puaj kꞌatza. Aꞌ atichku kajay qꞌu txꞌiibꞌal qꞌii tiqꞌabꞌ. Utz Tioxh ul inach u vinaj tu Jerusaleen. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Aalich tek iqꞌaavbꞌen tu vitenam kꞌujlich tu vikareꞌt, tuul nichisikꞌle u Yolbꞌal Tioxh vaꞌl alich tu u Isaias. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Uncheeꞌ qꞌilal u Felipe tu u Tioxhla Espiiritu, tal te ech tzaꞌ: —Xaan opon kꞌatz u vinaj atoꞌk tu u kareꞌt tziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ech ixaan opon u Felipe. Utz tabꞌi aas nichisikꞌle untanul u Yolbꞌal Tioxh vaꞌl bꞌaxabꞌsamal talax tu u Isaias. Utz ichꞌoti u Felipe te ech tzaꞌ: —¿Ni tzik ipaal atxumbꞌal tu vaꞌl nasikꞌle tziꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tzaqꞌbꞌel tu u vinaj ech tzaꞌ: —Kaniꞌch ipaal untxumbꞌal tuul tan, abꞌil koj nichusunin te kam u tokebꞌal.— Texh te. Ech ijaj bꞌaꞌnil tu u Felipe aas sajeꞌop kꞌatza tu vikareꞌt. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Utz aatz u Yolbꞌal Tioxh vaꞌl nichisikꞌle, ayaꞌ vaꞌl nital ech tzaꞌ: —Echaꞌ tiqꞌol bꞌen karneꞌl tu yatzꞌbꞌal tetz bꞌanaxi. Echaꞌ chelem karneꞌl aas yeꞌxhkam niqꞌeqꞌun tu qꞌu eesan tetz ixiꞌl. Itxꞌajmi koꞌxhtuꞌ. Tan yeꞌxhkam ijaj itziꞌ tu yol. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Eesal iqꞌii. Utz yitꞌ jikom koj itxꞌolax inujul bꞌanaxi. Eesal kuꞌen u vatz iqꞌii isaj tu u vatz txꞌavaꞌ tzaꞌ. Utz yeꞌk yol tiꞌ ituꞌxh ixalam.— Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ech aatz u aa Etiopia, tal tu u Felipe ech tzaꞌ: —Bꞌan bꞌaꞌnil, al ve abꞌil nital u alol tetz u yolbꞌal Tioxh tziꞌ. ¿Aꞌ tzik nital jeꞌ tibꞌ, pek oj abꞌil iꞌ nitalva?— Texh tu u Felipe. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ech xeꞌt iyolon u Felipe. Aꞌ xeꞌtik tiꞌ vaꞌl alich nal tu u Isaias. Utz motx chit tal u bꞌaꞌnla chusbꞌal te majte tiꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Uncheeꞌ tuul atich ok tiꞌ bꞌey, opon kꞌatz maꞌl u aꞌ. Ech tal tek u aa Etiopia te ech tzaꞌ: —¿Kam samajon unbꞌant unvautiismo? Atil aꞌ tzaꞌ uyta.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Tzaqꞌbꞌel tu u Felipe ech tzaꞌ: —Oj nanima u Tioxh tuchꞌ avaanima, saveeti saꞌan avautiismo.— Texh te. Ech tzaqꞌbꞌi utz, tala: —Eeꞌ nunnima aas nojchit iKꞌaol Tioxh u Jesucristo.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ech tal itxakeꞌ u kareꞌt u aa Etiopia utz, motx kuꞌl sikaꞌbꞌil. Bꞌenkuꞌ tu aꞌ utz, ech bꞌanax vautisaar tu u Felipe. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Utz taꞌxh motx jeꞌul tziꞌ u aꞌ, iqꞌol bꞌen u Felipe tu u Tioxhla Espiiritu. Ech yeꞌt ilax veꞌt tu u aa Etiopia. Pek techalich itxuqꞌtxuneꞌ okbꞌen tiꞌ vibꞌey. ");
INSERT INTO ixlCNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Uncheeꞌ aatz u Felipe, aꞌ ex aqꞌbꞌojku tu Azoto. Utz nichtal u bꞌaꞌnla chusbꞌal tu qꞌu talaj tenam nichpaalka oponnalich koꞌxh tu Cesarea. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Uncheeꞌ aatz u Saulo, aꞌ chit nichiꞌan ikꞌuꞌl tiꞌ iyatzꞌax qꞌu niman tetz u kuBꞌaal Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Aal ex ijaj maꞌl tuꞌ xeꞌ qꞌu qꞌesal oksan yol vatz Tioxh. Satiqꞌo bꞌen xeꞌ qꞌu qꞌesala tu qꞌu atibꞌal chusbꞌal tetz u oꞌtla mantaar tu Damasco. Utz aqꞌax te. Aꞌ nichtal tuul aas oj sichabꞌa maꞌj aanima tziꞌ ninima u bꞌaꞌnla chusbꞌal tiꞌ u Bꞌaꞌnla Bꞌey, sitxayeꞌ utz, suꞌltaqꞌ tu tzeꞌ tu Jerusaleen. Maꞌl itxaypeꞌ siꞌaneꞌ kꞌuxh vinaj oj ixoj. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Uncheeꞌ aatz atich ok tiꞌ vibꞌey, yeꞌk talcheꞌ sutil tiꞌ tu maꞌl u ribꞌkin xamal kuꞌl tu Amlika. Aꞌ chit nichtekinajabꞌ topon tu Damasco. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Utz yakich kuꞌoj u Saulo vatz txꞌavaꞌ taqꞌo. Utz aꞌ tek tabꞌi tuch maꞌl u yol tal te ech tzaꞌ: —Saulo, Saulo, ¿kantuꞌ naꞌan akꞌuꞌl viꞌ, nachokꞌin?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ech tzaqꞌbꞌu u Saulo tal ech tzaꞌ: —UnBꞌaal, ¿abꞌil axh?— Texhtuꞌ. Tzaqꞌbꞌel ech tzaꞌ: —In u Jesuus. In vaꞌl naꞌan akꞌuꞌl viꞌ, nachokꞌin. Loqꞌ nikoꞌnabꞌan jeꞌ iibꞌ. Ech naꞌaneꞌ vaꞌl niꞌan u vaakaxh aas nikoꞌnipaqꞌka ajan u tochꞌbꞌal tetz utz; yeꞌxhat niꞌenku te aas kꞌaxbꞌixsaibꞌ niꞌaneꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ech techalich tek itꞌuntꞌuꞌlan u Saulo tu xoꞌval. Utz tal ech tzaꞌ: —UnBꞌaal ¿kam asaꞌ sunbꞌaneꞌ uncheeꞌ?— Texh te. Tzaqꞌbꞌel ech tzaꞌ: —Aatz cheel, lakpen utz, kuxhoꞌk tu u tenam tziꞌ. Tan latziꞌ saꞌalaxku see kam saꞌaneꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ech jolol texh txaklich qꞌu vinaj xamich tiꞌ u Saulo. Tiira sotz ikꞌuꞌl. Tan nojchit tabꞌi u yol tziꞌ, loqꞌ yeꞌxhabꞌil maꞌj til iatz. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Uncheeꞌ lakpu tek jeꞌ u Saulo vatz txꞌavaꞌ. Ijaj iatz tala, loqꞌ yeꞌt ilon veꞌteꞌ. Ech chꞌijimich tek ibꞌen siqꞌabꞌ bꞌanli. Iqꞌol okoꞌp tu Damasco. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Oxvaꞌl qꞌii atin tziꞌ. Utz yeꞌ nichtiloneꞌ. Yeꞌt txꞌaꞌni; yeꞌt ukꞌai. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Uncheeꞌ atich maꞌl u niman tetz u Jesuus tu Damasco, Ananias ibꞌii. Utz qꞌilal tu u kuBꞌaal tu maꞌl visioon. Tal te ech tzaꞌ: —Ananias.— Texh te. Tzaqꞌbꞌi utz, tala: —Atilin tzaꞌ, unBꞌaal.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Utz tal u kuBꞌaal te ech tzaꞌ: —Kuxh, aal abꞌen tu u bꞌey vaꞌl Jikom. Aꞌ seꞌnachok maꞌl u vinaj Saulo ibꞌii aa Tarso. Atil xeꞌ u Judas. Niqꞌila sikꞌleꞌin tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Utz vettillu topon maꞌl u vinaj tzixeꞌ tu visioon. Ananias ibꞌii. Nitaqꞌ jeꞌ iqꞌabꞌ tibꞌa ech sailoni nitileꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ech tzaqꞌbꞌu tek u Ananias utz, tala: —UnBꞌaal, sibꞌax alon ve tiꞌ u vinaj tziꞌ aas kaana kꞌaxkꞌo nipaasav qꞌu niman eetz qꞌuꞌl atil tu Jerusaleen. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Utz kꞌuxh ulyu tzaꞌ tan, aꞌ ul itxay bꞌen abꞌil niqꞌilan sikꞌlen vabꞌii. Aꞌ niaqꞌon tijleꞌm qꞌu qꞌesal oksan yol vatz Tioxh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Tzaqꞌbꞌel tu u Jesuus ech tzaꞌ: —Taꞌxh sabꞌenaxh tan, aatz u vinaj tziꞌ, untxaaom. Utz suntxakunsa tiꞌ en talax vunbꞌii xoꞌl qꞌu puera aanima. Satal vatz qꞌu qꞌesal tenam tixoꞌl utz, xoꞌl qꞌu Israeel majte. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ech satil u tzaꞌl vaqꞌo vaꞌl sapaalku tiꞌ vunbꞌii.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Uncheeꞌ ech bꞌen u Ananias. Aatz okoꞌp tu u atibꞌal, taqꞌ jeꞌ iqꞌabꞌ tibꞌa u Saulo. Utz tal te ech tzaꞌ: —Hermano Saulo, vetichajin u kuBꞌaal tzaxeꞌ. Ayaꞌ u Jesuus, vaꞌl vetqꞌilanaxh tu bꞌey. Aꞌ isaꞌ aas saqꞌaavilonaxh. Utz tiira saꞌatin u Tioxhla Espiiritu sakꞌatza.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ech tu koꞌxh u muꞌkꞌul tziꞌ, solkꞌeꞌl maꞌl u kam tu bꞌaqꞌ iatz utz, qꞌaav tek iloni. Ech lakpi utz, ibꞌan ivautiismo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Txꞌaꞌn tekuꞌen, ech chee iyakꞌil. Utz atin kaꞌxvaꞌl qꞌii xoꞌl qꞌu niman tetz u Jesuus qꞌuꞌl atich tu Damasco. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ech xeꞌt u Saulo tiꞌ ipaxsal itziiul u Jesuus viTxaaom u Tioxh tu qꞌu aanima qꞌuꞌl nichimol tibꞌ tu qꞌu atibꞌal chusbꞌal tetz u oꞌtla mantaar aas aꞌ viKꞌaol u Tioxh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ech motx sotz ikꞌuꞌl kajay qꞌu aanima taqꞌo qꞌul motx abꞌin. Utz motx tal ech tzaꞌ: —¿Yitꞌ tzik aꞌ u vinaj atziꞌ vaꞌl nichiꞌan ikꞌuꞌl tiꞌ qꞌu qꞌilan sikꞌlen tetz Jesuus tu Jerusaleen? Tan aal aꞌ paj ul iꞌan tzaꞌ. Ul itxay bꞌen. Utz seꞌntaqꞌ vatz qꞌu qꞌesal oksan yol vatz Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pek aal koꞌn maas nichtiqꞌo iyakꞌil u Saulo. Nichitxakbꞌaꞌ aas aꞌ viTxaaom u Tioxh u Jesuus. Ech nichisotz ikꞌuꞌl qꞌu Israeel taqꞌo qꞌuꞌl atich tu Damasco. Yeꞌt itxꞌol itzaqꞌbꞌeleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Uncheeꞌ aatz paal sibꞌal qꞌii tuul, motx inukꞌ qꞌu Israeel tibꞌilaj aas siyatzꞌ u Saulo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Utz nichtekmotxixeen qꞌiils aqꞌbꞌal vatz qꞌul ijubꞌalil u okebꞌalop tu u tenam, tiꞌ iyatzꞌaxeꞌ. Pek opon itziiul vatz u Saulo vaꞌl nichtitzꞌa qꞌu vinaj tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ech aatz iꞌan qꞌu niman tetz u Jesuus, ipaasa eluꞌl u Saulo tu aqꞌbꞌal viꞌ u mam tzꞌach tetz u tenam. Tu maꞌl mam txakatx ichꞌunpiv kuꞌl. Ech eli. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Uncheeꞌ opon tek u Saulo tu Jerusaleen. Utz siꞌchimolo tibꞌ tuchꞌ qꞌu niman tetz u Jesuus tala. Pek kajay nichixoꞌv te. Yeꞌ nichmotxinima aas oj niman tek tetz u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ech iqꞌol tek bꞌen tu u Bernabee. Ex ikꞌuch vatz qꞌul ichaj u Jesuus. Utz tala kaniꞌch ikꞌulax u Saulo bꞌanax tu bꞌey tu u Jesuus utz, kaniꞌch iyolon te. Utz tal majte aas yeꞌk chit ixoꞌval u Saulo yolon tiꞌ vibꞌii u Jesuus tu Damasco. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ech atin tek u Saulo tixoꞌl tu Jerusaleen. Utz nichtelaꞌ tok tiꞌ talax u yolbꞌal Tioxh tuchꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Utz yeꞌk ixoꞌval tiꞌ talax u yolbꞌal Tioxh tibꞌii u Jesuus. Techal txayiꞌbꞌ nichiꞌan tu yol tuchꞌ qꞌu Israeel qꞌuꞌl griego iyolbꞌal. Pek aatz qꞌu Israeel tziꞌ, aꞌ nichmotxtitzꞌa iyatzꞌleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ech aatz tabꞌi qꞌu niman tetz u Jesuus, motx tek tiqꞌo bꞌen u Saulo tu Cesarea. Utz ichaj bꞌen tu Tarso. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ech tiira bꞌaꞌnich chit tatin qꞌu niman tetz u Jesuus qꞌuꞌl tikuenta Judea, Galilea tuchꞌ Samaaria. Chꞌiichil chit nichmotxiꞌan tiꞌ tootzajil u yolbꞌal Tioxh. Xoꞌvamal chit Tioxh tipaaleꞌ. Yakꞌinchil utz, akꞌbꞌichil chit nichmotxiꞌan tu u Tioxhla Espiiritu. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Uncheeꞌ aatz u Luꞌ, nicheniqꞌila qꞌu niman tetz u Jesuus. Utz opon xeꞌ unjolol tu maꞌl u tenam Lida. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Utz til maꞌl u vinaj, Eneas ibꞌii, numtzꞌinajich ichiꞌl. Maꞌtich tel vaaxajil yaꞌbꞌ ikuꞌ vatz txꞌach taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Utz tal u Luꞌ te ech tzaꞌ: —Eneas, u Jesucristo sabꞌanon bꞌaꞌn see. Ech txakpen utz, lak vatxꞌach tziꞌ.— Texh te. Ech yakich lakpi. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Utz kajay qꞌu aanima ilon qꞌuꞌl jejlich tu Lida tuchꞌ qꞌuꞌl atich tu Saroon. Ech motx tek inima u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Uncheeꞌ aatz tek iꞌan tu maꞌl u tenam Jope, atich maꞌl u ixoj niman tetz u Jesuus. Tabita ibꞌii tu yolbꞌal hebreo utz, Dorcas tu yolbꞌal griego. Aatz u ixoj tziꞌ, sibꞌla chit lochoꞌm nichiꞌan tu qꞌu meꞌbꞌaꞌ. Mamaj bꞌaꞌnil nichiꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Pek aatz iꞌan tu qꞌu qꞌii tziꞌ, yaꞌvbꞌixi utz, kami. Ech txꞌaal tiꞌ utz, iqꞌol bꞌen tikaꞌ chupul u otzotz. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Utz aatz qꞌu niman tetz u Jesuus, tabꞌi aas atich u Luꞌ tu Lida. Ech ichaj bꞌen kaꞌvaꞌl vinaj tiꞌ en eloj. Tan inajaꞌchich koꞌn tibꞌ u tenam Lida tuchꞌ u Jope. Ex ijaj bꞌaꞌnil te ech tzaꞌ: —Niꞌaxh quxeꞌ. Utz bꞌatziꞌch uuleꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ech oora lakpu u Luꞌ. Yakich kꞌasojul tiꞌ qꞌu chaj. Utz taꞌxh oponi, yakich iqꞌoloj jeꞌ tu vaꞌl atichku u kamchil. Utz isepoꞌk tibꞌ qꞌu txakay ixoj tiꞌ tuul kaana toqꞌeꞌ. Motx ikꞌuch qꞌu toksaꞌm te qꞌuꞌl taqꞌonibꞌalich u Dorcas. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ech aatz u Luꞌ tan, tal teluꞌl kajay qꞌu aanima toꞌotzotz. Utz pecheꞌi, iqꞌila sikꞌle Tioxh. Ech tek ipilqꞌu tibꞌ tal te ech tzaꞌ: —Tabita, lakpen.— Texh te. Ech yakich qꞌaavojul taanima u Dorcas. Ech yakich sajinoj. Til u Luꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ech itxayax siqꞌabꞌ tu u Luꞌ, ilak jeꞌ. Utz isikꞌle okoꞌp qꞌu niman tetz u Jesuus tuchꞌ qꞌu txakay ixoj. Itxakbꞌaꞌ ok siatz, ¡itzꞌlel tekuꞌen! ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kajay qꞌu aa Jope abꞌin itziiul qꞌu kam uchi tziꞌ. Ech sibꞌal tek niman u kuBꞌaal Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Utz sibꞌal qꞌii iꞌanka u Luꞌ tu Jope. Aꞌ atinku tu atibꞌal xeꞌ maꞌl u vinaj Xhim ibꞌii, txikol tzꞌuꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Aatz tu Cesarea, atich maꞌl u vinaj Corneelio ibꞌii. Qꞌesala tetz u 100 sol vaꞌl “Italiana” ibꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Aatz u Corneelio tan, suula vinaj, xoꞌvan Tioxh tuchꞌ ikꞌaol imeꞌal. Utz lochol tetz meꞌbꞌaꞌ tu Israeel. Bꞌenamen chit nichiqꞌila isikꞌle Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Uncheeꞌ aatz iꞌana, kꞌuchax maꞌl visioon te, tiira vatzsaj. Kamal alas 3 kuꞌqꞌii til maꞌl u aanjel tetz Tioxh. Til tokoꞌp tu vaꞌl atichka utz, tal te ech tzaꞌ: —Corneelio.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Utz tii chit sajil tu u Corneelio. Ech tuchꞌ xoꞌval tal ech tzaꞌ: —¿Kiimbꞌi unBꞌaal?— Texh te. Alax te ech tzaꞌ: —Aatz valochtu qꞌu meꞌbꞌaꞌ tuchꞌ vaqꞌilat asikꞌlet Tioxh, atil kꞌuꞌl u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ech aatz cheel, chaj bꞌen achaj tu Jope. Seꞌntiqꞌo maꞌl u vinaj Xhim ibꞌii, vaꞌl Luꞌ chu teꞌl majte. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Aꞌ atilku xeꞌ vaꞌt u vinaj Xhim paj ibꞌii, txikol tzꞌuꞌm. Aꞌ atik tatibꞌal tziꞌ mar. Ech aꞌ saꞌalon see kam saꞌaneꞌ.— Texh u aanjel. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Uncheeꞌ taꞌxh elbꞌen u aanjel, yakich isikꞌle kaꞌvaꞌl taqꞌonom u Corneelio. Antu vaꞌt sol, nacholich Tioxh majte utz, kꞌujlebꞌal kꞌuꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Utz tal qꞌu yol te, ech ichaj bꞌen tu Jope. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Uncheeꞌ tu tek vaꞌt qꞌii tuul, siꞌchtekchaqꞌaan qꞌii, bꞌenjeꞌ u Luꞌ viꞌ atibꞌal. Ex iqꞌila isikꞌle Tioxh. Aꞌ chit nichtekinajabꞌ topon qꞌul ichaj u Corneelio. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Utz ul maꞌl mam vaꞌy kꞌatz u Luꞌ. Txꞌaꞌomich tek isaꞌ. Pek tuul koꞌxh nichibꞌanax tuch techbꞌubꞌal, kꞌuchax maꞌl visioon te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Tila aas jajlich u amlika. Utz aꞌ tek til ikuꞌl maꞌl u mam liikin bꞌuꞌj qitzich junun qꞌuꞌl ixoobꞌal. Aal ikuꞌl vatz txꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Utz kajay vatzul txokop atich tu u liikin bꞌuꞌj tziꞌ. Atich txokop kaavaꞌl ikꞌoꞌlebꞌal. Atil txokpil aꞌ. Utz atich xichꞌomla txokop majte, ayaꞌ qꞌuꞌl nipaal tu amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Utz tabꞌi maꞌl u yol tal te ech tzaꞌ: —Luꞌ, yatzꞌ qꞌu txokop tziꞌ utz, chiꞌa.— Texh teꞌleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Aatz tek u Luꞌ tan, tala: —Yeꞌka unBꞌaal tan, yeꞌxhjatu nivechbꞌu tzuꞌkin kam. Tan txaaꞌ.— Texh u Luꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Uncheeꞌ qꞌaav paj qꞌilal tikaꞌpaj. Alax te ech tzaꞌ: —Yeꞌ koꞌxh aal txaaꞌ tiꞌ qꞌu kam qꞌuꞌl txꞌaatxꞌoch tek tu u Tioxh.— Texh teꞌleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ox pajul chit til u kam u Luꞌ tziꞌ utz, nichiqꞌaavjolax jeꞌ u mam liikin bꞌuꞌj tu amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Uncheeꞌ tuul nichichokon taanima u Luꞌ tiꞌ u tokebꞌal u visioon vaꞌl kꞌuchax te tziꞌ, opon qꞌu chaj vatz jubꞌal qꞌuꞌl chajax tu u Corneelio. Tan maꞌtich ichꞌotitaꞌ til atilku tatibꞌal u Xhim. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ech motx uqꞌay qꞌu chaj. Utz motx ichꞌoti atil tzik maꞌl u vinaj tu u atibꞌal tziꞌ, Xhim ibꞌii, vaꞌl Luꞌ chu teꞌl majte. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ech ankoꞌxh nichtitzꞌa u kam u Luꞌ tziꞌ vaꞌl til tu visioon, qꞌilal tu u Tioxhla Espiiritu tal te ech tzaꞌ: —Nichokꞌaxh oxvaꞌl qꞌu vinaj. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Kuxh kuꞌ utz, labꞌenaxh tiꞌ. Kaꞌtziiunichꞌaxh tan, in vetchajon.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Uncheeꞌ kuꞌtekꞌul u Luꞌ vatz qꞌu vinaj utz, tal te ech tzaꞌ: —In vaꞌl nechokꞌin. ¿Kam echaj aas ulyex tzaꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ech motx tal qꞌu vinaj te ech tzaꞌ: —Oꞌ ichaj u Corneelio, u qꞌesala tetz 100 sol. Maꞌl vinaj xoꞌvan Tioxh utz, jikom. Tiira bꞌaꞌn talchu vatz kajay qꞌu Israeel. Pek vetalax te tu maꞌl u tioxhla aanjel aas satal oopon otzotz tzixeꞌ. Utz satabꞌi qꞌul ayol.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ech motx tal tokoꞌp qꞌu vinaj toꞌotzotz utz, aꞌ vatku tzixeꞌ. Uncheeꞌ ech tek qꞌejal tuul, kꞌasuꞌl u Luꞌ tiꞌ. Utz kꞌasuꞌl unjot niman tetz u Jesuus aa Jope majte. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ech tu tek vaꞌt qꞌii tuul, motx opon tu Cesarea. Utz nichichꞌial tu u Corneelio. Maꞌtich imoltu qꞌu titzꞌin tatzik tuchꞌ qꞌuꞌl tiira tamiigo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Utz taꞌxh opon u Luꞌ, oora ul kꞌulaxoj tu u Corneelio. Yakich pecheꞌoj kuꞌ siatz utz, toksa iqꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pek tal u Luꞌ te ech tzaꞌ: —Lakpen tan, in koꞌn vinaj echaꞌ axh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ech yolon u Luꞌ tuchꞌ. Bꞌenoꞌk toꞌotzotz. Utz tila aas sibꞌal chit aanima molich tibꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ech yolon u Luꞌ, tal ech tzaꞌ: —Etootzajle aas tiira yeꞌxtxoj vatz u kumantaar aas simolo tibꞌ qꞌu Israeel tuchꞌ puera aanima. Utz yeꞌxtxoj soꞌokoꞌp toꞌotzotz tzixeꞌ. Pek Tioxh vetkꞌuchun ve aas kꞌuxh puera qꞌu aanima, yeꞌk savaqꞌ bꞌens yeꞌxtxoj utz, tzuꞌkin. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Echtzixeꞌt aatz vetꞌexsikꞌlelojin, vetkꞌasuꞌlin. Yeꞌn unbꞌan kaꞌl unkꞌuꞌl. Pek aatz cheel, nivabꞌi sete, ¿kam tokeꞌ vetetal vuleꞌ?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Uncheeꞌ tal tek u Corneelio te ech tzaꞌ: —Kaavaꞌx qꞌii cheel echat koꞌxh oora tzaꞌ, alas 3, atichkuꞌin tiꞌ ikuyax unvaꞌy, tiꞌ iqꞌilal sikꞌlel Tioxh. Utz aatz iꞌana, tuul nichunqꞌila sikꞌle Tioxh toꞌotzotz. Aꞌ tek vil itxakeꞌ maꞌl u vinaj sunvatz, ribꞌkin poloxh saj oksaꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Utz ech tal ve tzaꞌ: «Corneelio, aatz u Tioxh, vettabꞌil vaqꞌilat asikꞌletaꞌ utz, atil sikꞌuꞌl kajay vaꞌl naꞌan tiꞌ ilochax qꞌu meꞌbꞌaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Pek aatz cheel, chaj bꞌen achaj tu Jope. Utz al tul maꞌl u vinaj Xhim ibꞌii, vaꞌl Luꞌ chu teꞌl majte. Aꞌ atilku xeꞌ vaꞌt u vinaj Xhim ibꞌii, txikol tzꞌuꞌm. Aꞌ atik u tatibꞌal tziꞌ mar. Ech aatz luꞌuli, sayolon see.» Texh ve. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Echtzixeꞌt vetunchaj savsan eetz. Utz taꞌntioxh qeꞌl ulyaxh. Ech kajay oꞌ atiloꞌ vatz Tioxh cheel tzaꞌ utz, saqabꞌi kam vaꞌl saal qe tu u Tioxh.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Uncheeꞌ aatz u Luꞌ, xeꞌt iyoloneꞌ utz, tal ech tzaꞌ: —Anal cheel paalyu untxumbꞌal tuul aas nojchit yeꞌk peꞌk tel aanima vatz u Tioxh tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Tan kꞌuxh til koꞌxh itenam u aanima, nikꞌulax tu u Tioxh oj xoꞌvamal Tioxh taqꞌo utz, niꞌan vijikomal vatz u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Tan aatz u Tioxh tziꞌ, taqꞌuꞌl viyol xoꞌl qꞌu Israeel; ayaꞌ u bꞌaꞌnla chusbꞌal tiꞌ u Jesucristo. Tan aꞌ u oksan kubꞌaꞌn tuchꞌ u Tioxh. Utz taꞌxh maꞌl Bꞌaala tetz kajay qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Utz etootzajle kam qꞌu kam uch tu vikuenta u Judea. Aꞌ xeꞌtik kꞌasuꞌl tikuenta Galilea aꞌ chit maꞌtich iyaꞌ u Xhan tiꞌ ipaxsat itziiul u vautiismo tu qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Etootzaj majte aas toksa viTioxhla Espiiritu u Tioxh kꞌatz u Jesuus aa Nazareet bꞌaꞌnil. Utz taqꞌ mam tijleꞌm. Ech kam koꞌn mamaj bꞌaꞌnil paal iꞌana. Iꞌan bꞌaꞌn tu kajay qꞌu aanima qꞌuꞌl nichtulebꞌel tu u txꞌiꞌliꞌinaj tan, nojchit Tioxh atich kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Utz nojchit oꞌ ilon abꞌin qꞌu kam iꞌan u Jesuus tziꞌ. Qila qabꞌi qꞌuꞌl iꞌan tikuenta Judea tuchꞌ tu Jerusaleen. Pek yatzꞌax kuꞌen; aqꞌax jeꞌ vatz kurus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Loqꞌ itzꞌpixsal koꞌn u Jesuus tu u Tioxh titoxvaꞌ qꞌii. Utz chee sukuvatz. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Loqꞌ kajay koj aanima ilon. Pek taꞌxh cheek vatz qꞌuꞌl txaaich nal el tu u Tioxh, qꞌuꞌl ilon abꞌin. Ech txꞌaꞌnoꞌ ukꞌaꞌoꞌ tuchꞌ aas maꞌtich qꞌaavtitzꞌpu tikaꞌpaj xoꞌl qꞌu kamnaj. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Utz talka qe bꞌaꞌnil aas sakupaxsa itziiul tu kajay aanima aas aꞌ vaꞌl oknaj tijleꞌm tu u Tioxh tiꞌ itxꞌolax inujul qꞌu aanima qꞌuꞌl itzꞌlele tuchꞌ qꞌu kamnaj. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Tan tiꞌ u Jesuus yolonku kajay qꞌu alol tetz u yolbꞌal Tioxh. Tala aas abꞌil qꞌuꞌl saniman, sikꞌul kuybꞌal tiꞌ qꞌul ipaav tu vibꞌii.— Texh u Luꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Uncheeꞌ tuul ankoꞌxh nichtal qꞌu yol u Luꞌ tziꞌ, ok u Tioxhla Espiiritu kꞌatz kajay qꞌu aanima qꞌuꞌl nichabꞌin qꞌu yol. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ech sotz chit ikꞌuꞌl qꞌu Israeel, niman tetz u Jesuus. Ayaꞌ qꞌul imol u Luꞌ oponi, aas motx til tok u Tioxhla Espiiritu kꞌatz qꞌu puera aanima, u toya u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Tan nichmotxtabꞌi iyolon qꞌu puera aanima tunjot yolbꞌal utz, nichtoksa iqꞌii u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Uncheeꞌ yolon tek u Luꞌ, tala: —Yeꞌxhkaniꞌch imajax ibꞌant ivautiismo qꞌu niman tetz u Jesuus tzaꞌ, qꞌuꞌl okyu u Tioxhla Espiiritu kꞌatza, echaꞌ oꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ech tal tek u Luꞌ tu qꞌu aanima aas siꞌan ivautiismo tibꞌii u kuBꞌaal Jesuus. Uncheeꞌ aatz tek qꞌu aanima, motx ijaj bꞌaꞌnil tu u Luꞌ aas sakaa kaꞌxvaꞌtoj qꞌii tzixeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Uncheeꞌ tabꞌi qꞌul ichaj u Jesuus tuchꞌ qꞌu niman tetz u Jesuus qꞌuꞌl atich tu Judea aas antu qꞌu puera aanima niman u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ech aatz opon u Luꞌ tu Jerusaleen, yaal tu unjolol qꞌu Israeel qꞌuꞌl niman tetz u oꞌtla mantaar tiꞌ itzokꞌax el bꞌiil chiꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Motx tal tu u Luꞌ ech tzaꞌ: —¿Kam tokeꞌ vetꞌokoꞌpꞌaxh toꞌotzotz xeꞌ puera aanima yeꞌ tzokꞌel el bꞌiil chiꞌl? Utz ¿kantuꞌ vettxꞌaꞌnaxh tuchꞌ?— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Uncheeꞌ aatz u Luꞌ tan, tziꞌtzoch chit talax te iꞌan ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Aatz unbꞌana, aꞌ chit atichꞌin tu Jope. Nichunqꞌila sikꞌle Tioxh utz, yeꞌk talcheꞌ kꞌuchax maꞌl u kam ve tu visioon. Vil ikuꞌl maꞌl u kam tu amlika. Echaꞌ maꞌl mam liikin bꞌuꞌj. Qitzel junun qꞌul ixoobꞌal. Aalich ikuꞌl sunvatz vila. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ech unsaji chit bꞌaꞌnil utz, aꞌ tek vila atich unjolol txokop tuul. Atia kaavaꞌl ikꞌoꞌlebꞌal vatz txꞌavaꞌil txokpil. At chiꞌolla txokop. At txokpil aꞌ. Utz at xichꞌomla txokop tu amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Utz aꞌ tek vabꞌi tuch maꞌl u yol, tal ve ech tzaꞌ: «Luꞌ, yatzꞌ qꞌu txokop tziꞌ utz, chiꞌa.» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Aatz in tan, val te ech tza: «Yeꞌka unBꞌaal tan, yeꞌxhjatu nivechbꞌu tzuꞌkin kam. Tan txaaꞌ.» Texhin te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Uncheeꞌ iqꞌilapajkꞌasuꞌlin tu Amlika tikaꞌpaj utz, tal ech tzaꞌ: «Yeꞌ koꞌxh aal txaaꞌ tiꞌ qꞌu kam qꞌuꞌl txꞌaatxꞌoch tek tu u Tioxh.» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ech ox pajul chit vil u kam tziꞌ. Utz qꞌaav iqꞌol jeꞌ tu amlika. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ech tuul tek opon oxvaꞌl vinaj tzunxeꞌ tu u otzotz vaꞌl atichkꞌin. Aꞌ chajlik kꞌasuꞌl tu Cesarea. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Utz tal u Tioxhla Espiiritu ve aas yeꞌk sakaꞌtziiun unbꞌen tiꞌ. Ech antu bꞌen vaajil niman tetz u Jesuus viꞌ tzuta. Utz okoꞌpꞌoꞌ toꞌotzotz xeꞌ maꞌl u vinaj. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Aatz okoꞌpꞌoꞌ, tal qe kaniꞌch tiltu maꞌl u aanjel tu tatibꞌal. Txakeꞌ ok u aanjel siatz chi utz, tal te ech tzaꞌ: «Chaj bꞌen achaj tu Jope, seꞌntiqꞌo u Xhim, vaꞌl Luꞌ chu teꞌl majte. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Tan aꞌ saꞌalon see kaniꞌch eel tu qꞌul apaav tuchꞌ akꞌaol ameꞌal kajayil.» Texh tu u vinaj chi. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Uncheeꞌ aatz analich koꞌxh xeꞌt unyolon tixoꞌl, ok u Tioxhla Espiiritu kꞌatza, echaꞌ tok sukukꞌatza bꞌaxa majte. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ech ul tek sunkꞌuꞌl vaꞌl tal u kuBꞌaal Jesuus aas tal ech tzaꞌ: «Tu koꞌn aꞌ niꞌanvu vautisaar aanima u Xhan. Pek aatz ex tan, u Tioxhla Espiiritu saok sekꞌatza.» Texhich. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ech ¿kam vijleꞌm aas sakoꞌxhunmaj iatz u Tioxh? Tan u Tioxh vetꞌoksan u Tioxhla Espiiritu kꞌatza, echaꞌ vaꞌl toksa sukukꞌatza jatvaꞌl oꞌ, oꞌ Israeel niman tetz u kuBꞌaal Jesucristo.— Texh u Luꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ech aatz motx tabꞌi qꞌu kam tziꞌ, yeꞌxhkam veꞌt motx tala. Aal motx tek toksa iqꞌii Tioxh. Ech motx tal tzaꞌ: —¡Antu peꞌk qꞌu puera aanima aqꞌel tzii te tu u Tioxh aas samotxikꞌaxa ikꞌuꞌl tiꞌ qꞌul ipaav! Ech samotxopon tu u atinchil tu u bꞌenqꞌii bꞌensaj.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Uncheeꞌ aatz maꞌtich ikam u Esteban, xeꞌt ichokax qꞌu niman tetz u Jesuus, satxayli. Ech motx tek ipaxi tibꞌ. Atia bꞌen tikuenta Feniicia. At tikuenta Chipre. Utz at tu Antioquia. Nichipaxsa talax u yolbꞌal Tioxh. Loqꞌ abꞌil koꞌnkoxh e nichtalva, pek taꞌxh nichtalvu tu qꞌuꞌl Israeel. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pek atich ok unjolol vinaj tixoꞌl aa Chipre tuchꞌ aa Cirene. Utz kajay e nichtalva. Tan taꞌxh opon tu Antioquia, xeꞌt motx tal u bꞌaꞌnla chusbꞌal tetz u kuBꞌaal Jesuus tu qꞌu aanima qꞌuꞌl griego iyolbꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ech atich chit u kuBꞌaal Jesuus tiꞌ ilochaxeꞌ. Utz sibꞌ chit u tachul qꞌu aanima qꞌuꞌl motx nimani. Ok tiꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Uncheeꞌ opon itziiul qꞌu kam vatz qꞌu niman tetz u Jesuus qꞌuꞌl atich tu Jerusaleen. Ech ichaj tek bꞌen u Bernabee tu Antioquia. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Utz taꞌxh opon u Bernabee, yakich til vibꞌaꞌnil u Tioxh vaꞌl maꞌtich iꞌantu tixoꞌl qꞌu aanima. Ech txuqꞌtxuni. Utz taqꞌ nimal ikꞌuꞌl qꞌu niman tetz u Jesuus. Tal te aas tuchꞌ chit taanima saꞌtereꞌnxaanoꞌk kꞌatz u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ech sibꞌla paj chit tenam ok tiꞌ u Jesuus tan, nojchit bꞌaꞌnla vinaj u Bernabee. Tiira atil u Tioxhla Espiiritu kꞌatza. Utz tekꞌ kꞌujlel ikꞌuꞌl tiꞌ u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Uncheeꞌ xamtel tekuꞌen, bꞌen u Bernabee tu Tarso; ex ichok u Saulo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Aatz ichabꞌa, tiqꞌo ul tu Antioquia. Utz maꞌl yaꞌbꞌ motx iꞌan xol qꞌu niman tetz u Jesuus tziꞌ. Sibꞌal aanima nichichuseꞌ. Ech aꞌ chit bꞌaxa xeꞌtik talaxku Cristiano tu qꞌu niman tetz u Jesuus tu Antioquia tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Uncheeꞌ aatz iꞌan tu qꞌu qꞌii tziꞌ, elbꞌen unjolol qꞌu alol tetz u yolbꞌal Tioxh tu Jerusaleen utz, opon tu Antioquia. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Utz aatz maꞌl te, Agabo ibꞌii, yolon u Tioxhla Espiiritu kꞌatza. Utz tala aas suꞌul maꞌl mam vaꞌy tikuenta kajay u txꞌavaꞌ vaꞌl atich ok tikuenta Roma. Ech nojchit ul u mam vaꞌy tziꞌ. Aꞌ chit ijlenalich u Claudio. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ech aatz tek qꞌu niman tetz u Jesuus, qꞌuꞌl tu Antioquia, motx taqꞌ kuꞌ tibꞌeyil sijununil aas salochon bꞌen. Sataqꞌeꞌ kam sachee tzixeꞌ. Utz sataqꞌ bꞌen tu qꞌu niman tetz u Jesuus qꞌuꞌl jejlel tu Judea. ");
INSERT INTO ixlCNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ech nojchit ech motx iꞌana. Aꞌ taqꞌvu bꞌen xeꞌ qꞌu ansiano. Aꞌ iqꞌon bꞌen u Bernabee taqꞌo tuchꞌ u Saulo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Uncheeꞌ aatz tu u tiempo tziꞌ, aatz u ijlenal Herodes, itxay unjolol qꞌu niman tetz u Jesuus. Motx chit tulebꞌe. ");
INSERT INTO ixlCNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Utz tal iyatzꞌax u Jacobo tu chꞌichꞌ, vitzaꞌqꞌ u Xhan. ");
INSERT INTO ixlCNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Utz tila aas bꞌaꞌn bꞌenku u kam tu qꞌu qꞌesal uqꞌaybꞌal tziꞌ, ech aꞌ tek itxay u Luꞌ. Aꞌ chit tuich u nimla qꞌii Txꞌaꞌbꞌal Kaxhlaan Txꞌix Yeꞌk Itxꞌamil. ");
INSERT INTO ixlCNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Itxaya utz, taqꞌ kuꞌ tu tzeꞌ. Utz toksaka tikuenta kaa tanul sol. Kaavaꞌl sol atoꞌk tunchaj tanul. Utz paalnalich u nimla qꞌii tiꞌ u Elchil Vatz Kamchil Tu Egipto siꞌchtiqꞌo eluꞌl nichtaleꞌ. Anal siꞌchtoksa vatz qꞌu tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ech atich u Luꞌ tu tzeꞌ, bꞌoono ixeeleꞌ. Tuul tzukꞌel nichiqꞌila sikꞌle Tioxh qꞌu niman tetz u Jesuus tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Uncheeꞌ aatz u Luꞌ, vatchich koꞌn tu aqꞌbꞌal. Aꞌ chit ech tek qꞌejal siꞌchiqꞌol eluꞌl vatz qꞌu tenam. Atich ok xoꞌl kaꞌvaꞌl sol, xeen tetz. Utz bꞌaꞌnla qitzel tu kaꞌvaꞌl kadeena. Utz atich paj xeenal vatz ijubꞌalil u tzeꞌ majte. ");
INSERT INTO ixlCNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ech yeꞌk talcheꞌ chee maꞌl viaanjel u kuBꞌaal utz, yakich itxijtxu tuul u tzeꞌ. Ech itꞌok txala tuul u Luꞌ. Ikꞌassa utz, tal te ech tzaꞌ: —Lakpen cheel.— Texh te. Ech yakich chajpoj el qꞌu kadeena tiqꞌabꞌ u Luꞌ, u qitzbꞌal tetz. ");
INSERT INTO ixlCNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Utz tal u aanjel te ech tzaꞌ: —Bꞌan tok ooksaꞌm utz, oksa vapel xaabꞌ taajan tziꞌ.— Texh te. Uncheeꞌ iꞌan u Luꞌ kam vaꞌl alax te. Utz alax paj te tu u aanjel: —Oksa vachakeꞌt tziꞌ utz, xambꞌen viꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ech eluꞌl utz, xamich u Luꞌ tiꞌ. Loqꞌ yeꞌxh bꞌoj sikꞌuꞌl u Luꞌ aas oj nojchit vaꞌl nichiꞌan u aanjel. Kamal visioon nichtileꞌ aas tala. ");
INSERT INTO ixlCNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Pek paal vatz u bꞌaxa tuchꞌ vatz u kaꞌbꞌ xeenal. Ech opon tek vatz u chꞌichꞌ jubꞌal; ayaꞌ u elabꞌalul tu bꞌey. Utz jajpu koꞌxh u chꞌichꞌ jubꞌal sijunal. Ech motx ipaal eluꞌl. Utz taꞌxh maꞌtich ixaabꞌet maꞌl xoꞌl bꞌey, elabꞌelka tu u aanjel. ");
INSERT INTO ixlCNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ech nal tek nachon u Luꞌ bꞌaꞌnil utz, tala: —¡Anal tek cheel elyu untxumbꞌal tuul aas nojchit u kuBꞌaal Jesuus vetchajon viaanjel tiꞌ ul veesal tiqꞌabꞌ u Herodes! Utz ¡vetteesalin vatz qꞌu kam majte qꞌuꞌl bꞌanich tek tiꞌ tu qꞌu qꞌesal uqꞌaybꞌal aas siꞌan ve!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Taꞌxh tek til u Luꞌ bꞌaꞌnil tziꞌ aas maꞌtich ichajpeꞌ, yakich tek bꞌen otzotz xeꞌ u Liꞌ, vinan u Xhan, vaꞌl Kuxh chu teꞌl majte. Sibꞌal qꞌu niman tetz u Jesuus molich tibꞌ latziꞌ tiꞌ iqꞌilal isikꞌlel Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Uncheeꞌ opon u Luꞌ vatz jubꞌal qꞌanal, sikꞌleni. Utz eluꞌl maꞌl u ixviak, Rode ibꞌii. Ul tileꞌ abꞌil. ");
INSERT INTO ixlCNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Utz taꞌxh tabꞌi aas iviꞌ u Luꞌ, tu tek txuqꞌtxunchil yeꞌt ijaj okoꞌp, pek tꞌaspi ibꞌenoꞌk toꞌotzotz. Ex tal okoꞌp aas atich u Luꞌ vatz jubꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Pek alax koꞌn te ech tzaꞌ: —¡Kamal neel bꞌoj tu bꞌey!— Texh koꞌn teꞌleꞌ. Pek aatz u ixviak tan, taꞌxh tala: —¡Nojchit aꞌ i!— Chia. Pek alax te: —Viaanjel atziꞌ.— Texh teꞌleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Tuul nichkojiyaꞌ u Luꞌ tu sikꞌleꞌm. Ech ijajax okoꞌp. Utz tiira motx tzꞌejx ikꞌuꞌl aas motx tila. ");
INSERT INTO ixlCNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ech iꞌan tek xheenya u Luꞌ te tiqꞌabꞌ aas samotxjutzeꞌi. Ech motx chit tal te kaniꞌch teesal eluꞌl tu tzeꞌ bꞌanax tu u kuBꞌaal Jesuus. Utz tal paj ech tzaꞌ: —Altaj qꞌu kam tu u Jacobo tzaꞌ tuchꞌ tu tereꞌn qꞌu niman tetz u Jesuus.— Texhtuꞌ. Ech ikꞌasuꞌl utz, bꞌen sunjalite. ");
INSERT INTO ixlCNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Uncheeꞌ aatz tek sajbꞌi, mam txabꞌkin uch xoꞌl qꞌu sol tan, yeꞌkanich u Luꞌ tu tzeꞌ. Yeꞌ tootzajich kan chaj vetiꞌana. ");
INSERT INTO ixlCNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ech aatz u Herodes tan, tal ichokpu u Luꞌ. Loqꞌ yeꞌt cheei. Utz motx ichꞌoti itziꞌ qꞌu xeenal bꞌaꞌnil. Loqꞌ yeꞌxhabꞌil maꞌj tu qꞌu xeenal ootzajin tetz. Ech alax tek iyatzꞌpeꞌ. Xamtel tek tiꞌ u kam tziꞌ, elbꞌen u Herodes tu Judea utz, bꞌen tu Cesarea. Aꞌ tek atinku tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Uncheeꞌ aatz iꞌana tan, tiira lakpinajich iviꞌ u ijlenal Herodes tiꞌ qꞌu aanima tikuenta Tiro tuchꞌ u Sidoon. Pek aatz motx iꞌan qꞌu aanima tziꞌ, motx imolo ul tibꞌ vatz u Herodes tiꞌ ijajax tok ibꞌaꞌn tuchꞌ. Tan aatzich kaꞌvaꞌl qꞌu tenam tziꞌ, aꞌ nichmotxoponku techbꞌubꞌal tikuenta vitenam u ijlenal tziꞌ. Ech ichok maꞌl oksan iyol vatz u ijlenal, Blasto ibꞌii. Qꞌesal taqꞌonomich u ijlenal Herodes. ");
INSERT INTO ixlCNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ech aatz iꞌan tu u qꞌii vaꞌl qꞌatich tekuꞌen, ayaꞌ u toponbꞌal qꞌu aanima, aatz u Herodes, toksa bꞌaꞌnla oksaꞌm tetz ijlenal utz, kꞌujeꞌ tu u bꞌanbꞌal topiisyo. Ech xeꞌt iyoloneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Utz maꞌl chit ijeꞌ iviꞌ qꞌu tenam tal ech tzaꞌ: —¡Iyolon tioxh niꞌaneꞌ, yitꞌ iyolon koj vinaj niꞌaneꞌ!— Texh qꞌu tenam tiꞌ u Herodes. ");
INSERT INTO ixlCNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ech tu u muꞌkꞌul tziꞌ, ul maꞌl u aanjel tetz u kuBꞌaal. Toksa maꞌl yaabꞌil kꞌatza tan, yeꞌt toksa iqꞌii u Tioxh. Ech motx chee noꞌy tiꞌ utz, kam taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Pek aatz u yolbꞌal u Tioxh tan, til chaj koꞌxh nichpaxk itziiul. Utz chꞌiichil chit nichiꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Uncheeꞌ taꞌxh motx tzojpu u Bernabee tuchꞌ u Saulo tiꞌ vichaj tu Jerusaleen, motx qꞌaavbꞌen tu Antioquia. Imolo bꞌen u Xhan tiꞌ, vaꞌl Kuxh chu teꞌleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Uncheeꞌ aatz xoꞌl qꞌu niman tetz u Jesuus qꞌuꞌl atich tikuenta Antioquia, atich alol tetz u yolbꞌal Tioxh tuchꞌ chusul. Utz ayaꞌ qꞌu vinaj tzaꞌ: u Bernabee, u Xhim, vaꞌl Qꞌej chu teꞌleꞌ, u Luucio, vaꞌl aa Cirene, u Saulo, tuchꞌ u Manaeen majte, u tetz chꞌiiel u Herodes, u governadoor tikuenta Galilea. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ech aatz qꞌu vinaj tziꞌ, jolol atich kuꞌ tiꞌ ikuyax ivaꞌy. Utz tuul nichiqꞌila isikꞌle Tioxh, yolon u Tioxhla Espiiritu tixoꞌl, tal ech tzaꞌ: —Txaataj u Bernabee tuchꞌ u Saulo tziꞌ tan, siꞌan u aqꞌon vaꞌl nivitzꞌa tiꞌ.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Uncheeꞌ taꞌxh tek maꞌtich motx ikuyt ivaꞌy utz, maꞌtich motx iqꞌilat sikꞌlet Tioxh, motx taqꞌ jeꞌ iqꞌabꞌ tibꞌa u Saulo tuchꞌ u Bernabee. Ech motx ichajtu bꞌen tiꞌ talax u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ech motx bꞌeni. Aꞌ chajon bꞌen u Tioxhla Espiiritu. Aalich motx ibꞌen tu Seleucia. Latziꞌ motx elkubꞌen tu vaarko. Aꞌ yakichku tu u sepkin txꞌavaꞌ nikꞌa aꞌ vaꞌl Chipre ibꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Uncheeꞌ aatz opon tu Salamina, tikuenta Chipre, motx ipaxsa talax u yolbꞌal Tioxh tu qꞌu atibꞌal chusbꞌal tetz u oꞌtla mantaar tetz qꞌu Israeel. Antich u Xhan, lochol tetz bꞌeni. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Uncheeꞌ motx isoli tuul qꞌu tenam, yaꞌ opon tu Pafos. Utz motx til maꞌl u vinaj latziꞌ, istan. Barjesuus ibꞌii. Chulin alol tetz u yolbꞌal Tioxh utz, Israeelich. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Aatz u istan tziꞌ, aꞌ atichku xeꞌ u governadoor, Seerjio Paulo, u tzakꞌkin vinaj. Aatz u governadoor tziꞌ, tal isikꞌlel opon u Bernabee tuchꞌ u Saulo tzixeꞌ. Aꞌ isaꞌ tabꞌit u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pek aatz u istan Barjesuus tziꞌ vaꞌl Elimas ibꞌii majte, nichimaj iatz u Pablo tuchꞌ u Bernabee. Aꞌ isaꞌ aas yeꞌk soꞌok u governadoor tiꞌ inimal u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ech aatz u Saulo vaꞌl Pablo ibꞌii majte, tiira atich u Tioxhla Espiiritu kꞌatza. Utz tii chit isaji u istan tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Utz tal te ech tzaꞌ: —¡Kꞌaol txꞌiꞌliꞌinaj, tiira axh mam eesanal tu bꞌey! ¡Tiira axh bꞌanol onkonil alol txubꞌaꞌl! Utz ¡axh koontrain tetz vijikomal majte! ¿Jatu sayaꞌ atxubꞌaꞌl tiꞌ vijikomla bꞌey u Tioxh? ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Pek aatz cheel, satzottꞌaxh; u kuBꞌaal Jesuus sabꞌanon see. Yeꞌk siil u qꞌii u saj tu maꞌl tiempo.— Texh te. Ech tu koꞌxh unmuꞌkꞌul, ok aqꞌbꞌal tiatz. Utz nichtexhichokon tiꞌaj chaj. Aꞌ nijaj bꞌaꞌnil abꞌil sachꞌijin bꞌen siqꞌabꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Uncheeꞌ taꞌxh til u kam u governadoor tziꞌ, yakich inima u yolbꞌal Tioxh. Utz tzꞌejxu chit ikꞌuꞌl tiꞌ u bꞌaꞌnla chusbꞌal tiꞌ u kuBꞌaal Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Uncheeꞌ elbꞌen u Pablo tuchꞌ qꞌul imol tu Pafos. Okbꞌen tu vaarko utz, motx ikꞌaj bꞌen tu Perge tikuenta Panfiilia. Pek aatz u Xhan tan, teesaka tibꞌ tiꞌ utz, qꞌaavbꞌen tu Jerusaleen. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ech paj elbꞌen tu Perge utz, aꞌ tek motx oponku tu Antioquia tikuenta Pisiidia. Motx okoꞌp tu u atibꞌal chusbꞌal tetz u oꞌtla mantaar tu ilanbꞌal qꞌii. Utz motx kꞌujeꞌi. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Uncheeꞌ sikꞌlel untanul u mantaar, tuchꞌ untanul Qꞌul Iyol Qꞌu Alol Tetz U Yolbꞌal Tioxh Tzꞌibꞌamal. Utz taꞌxh veet isikꞌleleꞌ, aatz qꞌu qꞌesala tu u atibꞌal chusbꞌal tetz u oꞌtla mantaar, motx tal opon tu u Pablo tuchꞌ tu u Bernabee ech tzaꞌ: —Hermanos, oj atil maꞌj eyol tiꞌ taqꞌax nimal ikꞌuꞌl u tenam tziꞌ, altaj.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ech aatz u Pablo, chꞌineꞌ jeꞌ. Iꞌan koꞌn xheenya tiqꞌabꞌ aas sauch jutzeꞌchil utz, xeꞌt tal ech tzaꞌ: —Vinaj Israeel tuchꞌ ex puera aanima xoꞌvan Tioxh, abꞌitaj. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Aatz u Tioxh tetz qꞌu Israeel, aꞌ txaaonnaj el tetz qꞌu kukꞌuy kumam oꞌte. Utz aꞌ akꞌbꞌixsan qꞌul ikꞌaol imeꞌal majte, kꞌuxh aal pueraich koꞌn tatin tikuenta u txꞌavaꞌ Egipto. Utz u Tioxh at chit ex eesan kꞌasuꞌl latziꞌ tu u mam tijleꞌm. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Utz tu koꞌn vimamala bꞌaꞌnil kꞌuxh itxꞌak qꞌul iqelbꞌalil 40 yaꞌbꞌ tu u tzꞌinlich tzaji txꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Utz aatz maꞌtich isotzsat jujvaꞌl qꞌu mam tenam tikuenta u mam txꞌavaꞌ Canaan, taqꞌ qꞌu txꞌavaꞌ te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Tu 450 yaꞌbꞌ iꞌanvu u Tioxh u kam tziꞌ. Utz toksa qꞌatol tzii u Tioxh tixoꞌl, oponnalich koꞌxh titiempo u Samueel, u alol tetz u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ech motx tek ijaj tok tijlenal qꞌu Israeel. Utz toksa u Sauul u Tioxh vikꞌaol u Cis vituꞌxh ixalam u Benjamiin. 40 yaꞌbꞌ iꞌanoꞌk. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ech aatz tek eesal u Sauul tu u Tioxh, aꞌ tek toksas ijlenalil u Daviid. Utz tal u Tioxh tiꞌ ech tzaꞌ: «Vetvillu u Daviid bꞌaꞌnil, vikꞌaol u Isaii, aas nojchit aꞌ maꞌl vinaj echaꞌ vaꞌl nital u vaanima. Tan saꞌxhiꞌan kajay vaꞌl unsaꞌ.» Texh tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ech aatz xoꞌl qꞌul ituꞌxh ixalam u Daviid, itzꞌpu u Jesuus. Ayaꞌ vaꞌl alich nal tu u Tioxh aas aꞌ u Chitol tetz qꞌu Israeel tu paav. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Utz aatz yeꞌsajich tul u Jesuus, nichipaxsa talax u kꞌaxa paav u Xhan xoꞌl qꞌu Israeel, tuchꞌ vibꞌanax u vautiismo techlal ikꞌaxal paav. Utz techlal qꞌaavich ok kꞌatz Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ech aatz tzojpu tek u Xhan, tal ech tzaꞌ: «Aatz vaꞌl netitzꞌa aas in iTxaaom u Tioxh, yitꞌ in koj. Pek tulka viꞌ utz, sibꞌ u tijleꞌm. Tan aal yeꞌ nikꞌuloꞌk viꞌ soꞌokꞌins chitol el ixaabꞌ tu tajan.» Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Echtzixeꞌt hermanos, ituꞌxh ixalam u Abrahaam tuchꞌ ex puera aanima xoꞌvan tetz u Tioxh, sete niqalvu u yol tzaꞌ tetz chitpichil tu paav. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Pek yeꞌt paal itxumbꞌal qꞌu aa Jerusaleen tuul, tuchꞌ qꞌu qꞌatbꞌal tzii aas abꞌil u Jesuus. Utz yeꞌt paal itxumbꞌal tu qꞌul iyol qꞌu alol tetz u Yolbꞌal Tioxh tzꞌibꞌamal majte, vaꞌl nisikꞌlel jun ilanbꞌal qꞌii. Tan aal anat koꞌxh tzojpin jeꞌ u Yolbꞌal Tioxh tiꞌ iyatzꞌax u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Taꞌxh motx ijaj tu u Pilato aas sakami, kꞌuxh yeꞌk maꞌj paav ichabꞌa kꞌatza aas sikꞌuloꞌk tiꞌ sakami. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ech taꞌxh tzojpu kajay qꞌu kam qꞌuꞌl tzꞌibꞌamalichka tiꞌ u Jesuus tziꞌ, iqꞌol kuꞌl vatz u kurus utz, ex mujloj. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pek aatz u Tioxh tan, titzꞌpixsa koꞌn jeꞌ xoꞌl qꞌu kamnaj. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Utz sibꞌat qꞌii chee vatz qꞌuꞌl ichusulibꞌ. Utz ela elbꞌen tuchꞌ tu Galilea, aas ibꞌen tu Jerusaleen. Ech aꞌ ilon utz, aꞌ tek qꞌu alol tetz vatz tenam cheel. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Utz echat oꞌ majte, niqal u bꞌaꞌnla chusbꞌal sete vaꞌl talaꞌtziꞌi u Tioxh tu qꞌu kukꞌuy kumam. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Utz vetitzojpil u Tioxh qe, oꞌ ituꞌxh ixalam qꞌu kukꞌuy kumam tan, vetqꞌaavtitzꞌpixsal u Jesuus. Ayaꞌ vaꞌl tzꞌibꞌamal tu u uꞌ Salmos tu u kaꞌbꞌ kꞌujul ech tzaꞌ: «Axh unKꞌaol; vetvitzꞌpixsaꞌaxh cheel.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Utz vetqꞌaavitzꞌpixsal u Jesuus tu u Tioxh xoꞌl qꞌu kamnaj. Ech jatu tereꞌn koj saqꞌaavkami. Tan nipajtal u Yolbꞌal Tioxh ech tzaꞌ: «Nojchit savaqꞌ u mam bꞌaꞌnil see vaꞌl alel tu u Daviid vaqꞌo.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ech tokeꞌ aas nipajtal tu u Salmos tu untantu ech tzaꞌ: «Saꞌkojaaqꞌ tzii saqꞌee vichiꞌl vaTioxhla Txaaom.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Tan aatz u Daviid tziꞌ, kami. Imolo tibꞌ tuchꞌ qꞌul ikꞌuy imam. Utz qꞌee vichiꞌl, kꞌuxh inima vitxumbꞌal u Tioxh tu u tiempo, xoꞌl qꞌu aanima tziꞌ qꞌuꞌl ela paal tu u vatz iqꞌii saj tuchꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pek ech koj u Jesuus vaꞌl qꞌaav itzꞌpixsal tu u Tioxh tan, yeꞌt qꞌee vichiꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ech ootzajitaj qꞌu kam niqaleꞌ tzaꞌ hermanos. Tan tiꞌ koꞌn vibꞌaꞌnil u Jesuus tziꞌ kꞌuxh atil u kuybꞌal paav niqal sete tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Tiꞌ vinimat u Jesuus, nitaqꞌax bꞌens bꞌaꞌn vatz Tioxh qꞌu aanima aa paav. Tan yeꞌxhkam nibꞌens bꞌaꞌn vatz Tioxh qꞌu aanima kꞌuxh sinima u oꞌtla mantaar. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ech nachtaj, bꞌantaj kuenta etibꞌ tan, kuꞌich qꞌu kam setiꞌ qꞌuꞌl alel tu qꞌu alol tetz u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Tan tal ech tzaꞌ: «Abꞌitaj vaꞌl tzaꞌ, ex eesan iqꞌii Tioxh. Tzꞌejxoj ekꞌuꞌl tan, sasotzꞌex. Sunbꞌan maꞌl u akꞌ kam sevatz tu u vatz eqꞌii esaj. Maꞌl mam kam aas saꞌkojenima kꞌuxh abꞌil saꞌalon sete.» Chia.— Texh u Pablo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Uncheeꞌ aatz tek eluꞌl u Pablo tuchꞌ u Bernabee tu u chusbꞌal tetz u oꞌtla mantaar, jajax bꞌaꞌnil te tu qꞌu puera aanima qꞌuꞌl yitꞌ Israeel aas laꞌpajtal qꞌu kam te tu vaꞌt ilanbꞌal qꞌii tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ech motx tek ipaxi tibꞌ qꞌu aanima. Utz sibꞌal qꞌu Israeel tuchꞌ qꞌu puera aanima oknaj nal tiꞌ u tuqꞌaybꞌal qꞌu Israeel, bꞌen tiꞌ u Pablo tuchꞌ u Bernabee. Utz nichtaqꞌax nimal ikꞌuꞌl tu u Pablo. Tal te aas tii atoj tu u bꞌaꞌnil vaꞌl vetsikꞌlelik ok tu u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Uncheeꞌ tu tepaj vaꞌt ilanbꞌal qꞌii tuul, jankꞌat koꞌxh yeꞌt motx opon kajay qꞌu aanima tu u tenam tiꞌ tabꞌil u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pek taꞌxh motx til qꞌu Israeel aas mam tenam imol tibꞌ, motx chiꞌon taanima. Utz tzaqꞌabꞌ koꞌn xeꞌt motx itzaqꞌbꞌet u Pablo tiꞌ qꞌul iyol. Nichiyoqꞌ majte. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Uncheeꞌ aatz tek u Pablo tuchꞌ u Bernabee tan, iqꞌomich iyakꞌil, tal ech tzaꞌ: —Nojchit ministeer aꞌ bꞌaxa saqalvu u yolbꞌal Tioxh sete bꞌanel, ex Israeel. Pek yeꞌ koꞌn esaꞌ. Nikoꞌxhetaqꞌka eloꞌp u bꞌenchil tu u bꞌenqꞌii bꞌensaj echil tziꞌ. Ech aatz cheel, sabꞌenoꞌ xoꞌl qꞌu puera aanima. Aꞌ seꞌnqalvu u yolbꞌal Tioxh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tan ech chit alel qe tu u Tioxh aas tal ech tzaꞌ: «In vetoksanaxh txijtxubꞌal vatz qꞌu puera aanima. Axh seꞌnaqꞌon vunyol tetz chitpichil tu paav tu kajay u vatz txꞌavaꞌ.» Chia.— Texh u Pablo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ech aatz tabꞌi qꞌu yol qꞌu puera aanima, motx chit txuqꞌtxuni. Utz motx tek toksa iqꞌii viyolbꞌal u Tioxh. Motx tek inima u kuBꞌaal qꞌuꞌl kꞌajel nal tiꞌ aas sabꞌen tu bꞌenqꞌii bꞌensaj. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ech paxinchil chit nichiꞌan itziiul u yolbꞌal u Tioxh tikuenta u txꞌavaꞌ Pisiidia. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pek aatz qꞌu Israeel, motx ichok unjolol qꞌu ixoj yitꞌ Israeel koj. Ayaꞌ qꞌuꞌl atil tijleꞌm. Antu qꞌu qꞌesal tenam ichoka. Utz ichajtziꞌi. Ech motx tojcha kꞌasuꞌl u Pablo tuchꞌ u Bernabee taqꞌo tikuenta vitxꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ech aatz tek u Pablo tuchꞌ u Bernabee, motx ipujika el pojoj tu tajan, tiꞌ qꞌu aanima qꞌuꞌl ixvan. Utz aꞌ tek motx bꞌenku tu vaꞌt u tenam Icoonio. ");
INSERT INTO ixlCNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pek ech koj qꞌu niman tetz u Jesuus, techal motx itxuqꞌtxuneꞌ. Utz tiira atich u Tioxhla Espiiritu kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Uncheeꞌ aatz iꞌan u Pablo tuchꞌ u Bernabee, motx bꞌenoꞌk tu u atibꞌal chusbꞌal tetz u oꞌtla mantaar tetz qꞌu Israeel tu Icoonio. Tan ech nal nichiꞌaneꞌ. Xeꞌt tal u bꞌaꞌnla chusbꞌal latziꞌ. Ech sibꞌla chit aanima motx niman. At Israeel utz, at griego, puera aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pek aatz unjot qꞌu Israeel qꞌuꞌl yeꞌt motx nimani, motx ichajtziꞌi qꞌu puera aanima. Toksa ixaꞌv sikꞌuꞌl tiꞌ qꞌu niman tetz u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pek kꞌuxh echi, sibꞌal tiempo iꞌan u Pablo tuchꞌ u Bernabee latziꞌ. Iqꞌomal iyakꞌil tiꞌ talax u yolbꞌal Tioxh. Ech kaana xheenya tuchꞌ txaichil nichiꞌan taqꞌo tiꞌ viyolbꞌal, techlal aas aꞌ imol Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Loqꞌ jolol tek jatxich tibꞌ iatz qꞌu aanima tu u tenam tziꞌ. Untanul a ayeꞌn kꞌatz qꞌu Israeel. Utz untante ayeꞌn kꞌatz qꞌul ichaj u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ech aatz qꞌuꞌl yeꞌ nichniman u Jesuus, ayaꞌ qꞌu Israeel tuchꞌ unjolol qꞌu puera aanima, motx iꞌan maꞌl iatz tuchꞌ qꞌul iqꞌatbꞌal tzii. Siꞌchmotxibꞌan tu u Pablo tuchꞌ u Bernabee tala. Siꞌchmotxipaqꞌ sivan. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pek tabꞌi u kam u Pablo tuchꞌ u Bernabee tziꞌ, ech motx ooji. Aꞌ ikꞌaj tu Listra tuchꞌ tu Derbe, tikuenta Licaoonia. Utz motx paal tu qꞌu tenam sinajaꞌch chaj majte. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Motx ipaxsa itziiul u bꞌaꞌnla chusbꞌal tu qꞌu tenam tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Uncheeꞌ aatz tu Listra, atich maꞌl u vinaj, koꞌx tu titzꞌebꞌal. Kꞌujliche. Paat yeꞌ nichixaaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Nichtabꞌi iyolon u Pablo. Utz aatz u Pablo, tii isaji utz, at bꞌenku te aas kꞌujlich ikꞌuꞌl tiꞌ Tioxh siꞌan bꞌaꞌn. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ech qetun taltu te ech tzaꞌ: —¡Lakpen utz, bꞌan jikom atxakeꞌaꞌ!— Texh te. Ech yuqꞌpu jeꞌ u vinaj utz, yakich xeꞌtoj ixaaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Uncheeꞌ taꞌxh til qꞌu aanima kam vaꞌl iꞌan u Pablo, qetuni. Motx tal tu yolbꞌal Licaoonia ech tzaꞌ: —¡Ulyu unjolol tioxh tu kuxoꞌl! ¡Aqꞌel koꞌn bꞌen tibꞌs vinaj!— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ech motx oksal vaꞌt ibꞌii tu qꞌu aanima. Aatz u Bernabee utz, Juupiter motx taqꞌvu bꞌen. Pek aatz u Pablo utz, Mercuurio ibꞌii toksa tan, aꞌ vaꞌl nichiyoloneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Uncheeꞌ aꞌ atichku u totztioxh tetz u Juupiter tu u tenam tziꞌ. Ech aatz u oksan yol vatz u bꞌanich tioxh tziꞌ, tuchꞌ qꞌu tenam, tiqꞌo ul tooro vaakaxh tuchꞌ vijbꞌal bꞌaꞌnla chaj xuꞌm vatz qꞌu okebꞌalop tu u tenam. Siꞌchtekmotxtoksa txꞌoloꞌm vatz u Pablo tuchꞌ u Bernabee tala. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pek aatz tabꞌi qꞌu kam u Pablo tuchꞌ u Bernabee, qꞌul ichaj u Jesuus, motx ibꞌitꞌ jeꞌ toksaꞌm kꞌatza. Utz motx jutzin tok xoꞌl qꞌu tenam. Motx qetuni. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Motx tal ech tzaꞌ: —Kam ech ebꞌana. Tan oꞌ koꞌn vinaj, echaꞌ ex tziꞌ. Pek taꞌn niqal sete aas setaqꞌka qꞌu kam qꞌuꞌl yeꞌk itxaꞌk nebꞌaneꞌ utz, soꞌokꞌex kꞌatz u itzꞌlich Tioxh, u bꞌanol tetz u vatz amlika txꞌavaꞌ, u mar utz, tuchꞌ kajay qꞌu kam atile. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Tan aatz tu qꞌu tiempo paalnajka, itxꞌajmi koꞌxh u Tioxh aas sakoꞌxhiꞌaneꞌ kam siꞌan qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pek yeꞌt iyaꞌsa ikꞌuchax vibꞌaꞌnil. Tan nichaj kuꞌl u jabꞌal tu amlika utz, nitatin bꞌaꞌnla vatz chikobꞌeꞌm taqꞌo. Ech nitaqꞌ tzujbꞌebꞌ etetz u Tioxh. Utz nichiꞌbꞌixsa etaanima.— Texh u Pablo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ech peena chit oleꞌ tiꞌ imajax iatz qꞌu tenam tiꞌ aas yeꞌk satoksa u txꞌoloꞌm siatz. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Uncheeꞌ tuul opon unjolol qꞌu Israeel, qꞌuꞌl jejlich tu Antioquia tuchꞌ tu Icoonio. Motx ex ichajtziꞌi qꞌu tenam. Utz motx ipaqꞌ sivan u Pablo. Ech taꞌxh veet iꞌantu te, ijuxu eloꞌp tziꞌ tenam. Kamya nichmotxtaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pek sepich tek tibꞌ qꞌu niman tetz u Jesuus kꞌatza. Ech lakpi utz, bꞌenoꞌk tu u tenam. Ech tu tek vaꞌt qꞌii tuul, elbꞌen tuchꞌ u Bernabee, bꞌen tu Derbe. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Utz ipaxsa itziiul u bꞌaꞌnla chusbꞌal tu Derbe. Sibꞌal aanima toksaka niman tetz u Jesuus tziꞌ. Ech motx qꞌaavbꞌen tu Listra, tu Icoonio utz, tuchꞌ tu Antioquia. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Aꞌ nichtaqꞌ nimal ikꞌuꞌl qꞌu niman tetz u Jesuus. Nichmotxtal te aas tii ikꞌujeꞌ ikꞌuꞌl tiꞌ Tioxh. Ech tal te tzaꞌ: —Ministeer tuchꞌ chit sibꞌla tzaꞌl sapaalkꞌoꞌ, ech soꞌokoꞌpꞌoꞌ tu viQꞌesalail u Tioxh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ech motx toksaka ansiano tu junun totztioxh tu qꞌu tenam paalka. Motx ikuy ivaꞌy, motx iqꞌilal isikꞌle Tioxh tiꞌ, ech motx taqꞌka tiqꞌabꞌ u kuBꞌaal Jesuus vaꞌl nimamalich tek taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ech motx paal tikuenta Pisiidia utz, motx opon tikuenta Panfiilia. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Utz motx ipaxsa itziiul u yolbꞌal Tioxh tu u tenam Perge. Ech bꞌen tu Ataalia. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Uncheeꞌ motx elbꞌen tu u tenam Ataalia utz, motx okbꞌen tu jukubꞌ. Motx qꞌaavopon tu Antioquia tikuenta Siiria. Ayaꞌ u tenam vaꞌl chajlik kꞌasuꞌl, vaꞌl qꞌilalik sikꞌlelik Tioxh tiꞌ utz, aqꞌax tiqꞌabꞌ u Jesuus, tiꞌ en itzojpil u aqꞌon vaꞌl alax te tu u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Utz aatz motx opon tu Antioquia, motx imol kajay qꞌu niman tetz u Jesuus. Utz motx chit tal kajay qꞌu mamala chaj kam qꞌuꞌl iꞌan u Tioxh kꞌatza. Utz tala kaniꞌch tok qꞌu puera aanima tiꞌ u Tioxh; kaniꞌch ikꞌujeꞌ ikꞌuꞌl tiꞌ u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ech sibꞌ tiempo iꞌan u Pablo tuchꞌ u Bernabee xoꞌl qꞌu niman tetz u Jesuus tu Antioquia. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Uncheeꞌ aatz iꞌan unjolol qꞌu aanima aꞌ kꞌaskuꞌl tu Judea, motx opon xoꞌl qꞌu niman tetz u Jesuus tu Antioquia. Utz ech nichtal tu qꞌul ichusuneꞌ tzaꞌ: —Yeꞌk kuybꞌal tetz qꞌul epaav, oj yeꞌk satzokꞌax el bꞌiil echiꞌl. Echaꞌ vaꞌl nital u mantaar tetz u Moisees.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ech aatz tek u Pablo tuchꞌ u Bernabee, kaana txayiꞌbꞌ iꞌan tu yol tuchꞌ qꞌu aanima tziꞌ. Ech tek motx titzꞌa aas samotxbꞌen tu Jerusaleen tiꞌ iyolax qꞌu kam tuchꞌ qꞌul ichaj u Jesuus utz, tuchꞌ qꞌu ansiano. Ech aꞌ bꞌen u Pablo. Ant imol u Bernabee tuchꞌ kaꞌxvaꞌt qꞌu niman tetz u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Uncheeꞌ motx ex chajpulojka tu qꞌu niman tetz u Jesuus. Aalich ipaal tikuenta Feniicia tuchꞌ tikuenta Samaaria. Utz nichpaaltal tu qꞌu niman tetz u Jesuus aas kaana tok qꞌu puera aanima tiꞌ inimal u Jesuus. Ech kaana itxuqꞌtxun taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Uncheeꞌ opon u Pablo tuchꞌ u Bernabee tu Jerusaleen. Utz bꞌaꞌnla kꞌulich topon tu qꞌu niman tetz u Jesuus tuchꞌ tu qꞌu ansiano tuchꞌ tu qꞌul ichaj u Jesuus. Ech motx tal kajay qꞌu kam qꞌuꞌl maꞌtich iꞌantu u Tioxh kꞌatza. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pek aatz iꞌan unjolol qꞌu niman tetz u Jesuus qꞌuꞌl fariseoich, motx lakpu tu xoꞌl utz, tal ech tzaꞌ: —Ministeer satzokꞌax el bꞌiil ichiꞌl qꞌu puera aanima qꞌuꞌl nimanya tziꞌ. Samotxꞌalchu te bꞌaꞌnil aas sikol u mantaar aqꞌel tu u Moisees.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ech imol tek tibꞌ qꞌul ichaj u Jesuus tuchꞌ qꞌu ansiano tiꞌ iyolaxeꞌ kam saelku qꞌu kam tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Aatz tek sibꞌal maꞌtich motx iyoltaꞌ, lakpu u Luꞌ tu xoꞌl utz, tal ech tzaꞌ: —Hermanos, etootzaj bꞌaꞌnil aas anaxh tabꞌi bꞌaxa u bꞌaꞌnla chusbꞌal qꞌu puera aanima vaqꞌo. Tan u Tioxh chajonin tiꞌ ipaxsal itziiul tixoꞌl. Utz motx inimalaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Utz aꞌ u techlal aas kꞌulaxyu tu u Tioxh tan, ok u Tioxhla Espiiritu kꞌatza majte, echaꞌ oꞌ. Tan u Tioxh ootzajin tetz u taanima qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Yeꞌxhkam jalbꞌal qibꞌ oꞌ Israeel tuchꞌ qꞌu puera aanima vatz u Tioxh. Ela vetichꞌexu qꞌu qaanima tiꞌ vikꞌujeꞌ kukꞌuꞌl tiꞌ u Jesuus. Txꞌaatxꞌoch tek tatin siatz. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Pek aatz cheel, ¿kantuꞌ sepaasa etibꞌ viꞌ u Tioxh? Netaqꞌ jeꞌ mam ijatz tiꞌ qꞌu niman tetz u Jesuus. Maꞌl ijatz aas nikoꞌxh qꞌu kukꞌuy kumam tuchꞌ oꞌ, nikojqoleꞌ tiꞌ inimaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Tan aatz oꞌ, aꞌ nikunima aas tu koꞌn u mam ibꞌaꞌnil u kuBꞌaal Jesuus chitpꞌoꞌ tu qꞌu paav. Utz echat qꞌu puera aanima majte.— Texh u Luꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ech itzꞌinbꞌaꞌ tek tibꞌ kajay qꞌu aanima. Aꞌ tek nichtabꞌi u Bernabee tuchꞌ u Pablo. Tan nichmotxtaleꞌ kam qꞌu mamaj xheenya tuchꞌ qꞌu txaichil nichiꞌan u Tioxh kꞌatza xoꞌl qꞌu puera aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Taꞌxh yaꞌ iyolon u Pablo tuchꞌ u Bernabee, aꞌ tek yolon u Jacobo. Tal ech tzaꞌ: —Hermanos, abꞌitaj vaꞌl saval sete tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Vettallu u Luꞌ tziꞌ aas kaniꞌch chit mutaqꞌtu tzii u Tioxh aas soꞌopon viyolbꞌal xoꞌl unjolol qꞌu puera aanima bꞌaxa. Tan antu nitxaa tiꞌ ibꞌens niman tetz. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Utz aatz u kam tziꞌ, nikꞌul tibꞌ tuchꞌ qꞌul iyol qꞌu alol tetz u yolbꞌal Tioxh. Ayaꞌ vaꞌl tzꞌibꞌamalka ech tzaꞌ: ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","«Aatz maꞌt ipaal qꞌu kam tzaꞌ, saqꞌaavuꞌlin utz, saqꞌaavunlak u ijlenalil vaꞌl echaꞌ u tetz u Daviid. Tan echaꞌ maꞌj kuꞌnaj otzotz aas sunsikꞌ qꞌul ichanaj utz, saqꞌaavvaqꞌ bꞌens vatinbꞌal tixoꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ech samotxichokꞌin untxꞌajtu qꞌu aanima tuchꞌ kajay qꞌu puera aanima qꞌuꞌl niqꞌila isikꞌle vunbꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Chu u kuBꞌaals Amlika vaꞌl alel nal viyol taqꞌo koꞌxtene.» Chu u alol tetz u yolbꞌal Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ech tok nivaleꞌ aas yeꞌk siꞌaneꞌ saqaqꞌ jeꞌ ijatz tiꞌ qꞌu puera aanima qꞌuꞌl nimotxtok tiꞌ u Tioxh tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Pek taꞌxh samotxtzꞌibꞌal bꞌen talax te aas samotxiꞌan kuenta tibꞌ tiꞌ inachax qꞌu bꞌanich tioxh; yeꞌk satechbꞌu qꞌu echbꞌubꞌal qꞌuꞌl nipaasal vatz bꞌanich tioxh niyolonka. Yeꞌk sateesa tibꞌ tu bꞌey tuchꞌ aanima. Utz saꞌalax bꞌen te majte aas yeꞌk sichiꞌ qꞌu txokop qꞌuꞌl chumimal iqul, yeꞌ elnaj ikajal. Utz yeꞌk satechbꞌu kaj majte. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Pek ech koj tu kuxoꞌl tan, jun koꞌxh ilanbꞌal qꞌii nisikꞌlel vimantaar u Moisees. Qootzaj nal koꞌxhtuꞌ tan, koꞌxten nal atin qꞌu atibꞌal chusbꞌal tetz u oꞌtla mantaar tu junun tenam. Aꞌ nialaxku tuul.— Texh u Jacobo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Uncheeꞌ bꞌaꞌn bꞌenku qꞌu kam te tziꞌ. Maꞌl chit iatz qꞌul ichaj u Jesuus tuchꞌ qꞌu ansiano utz, tuchꞌ tu qꞌu niman tetz u Jesuus tala aas samotxitxaa unjot vinaj tixoꞌl. Ech sabꞌen tiꞌ u Pablo tuchꞌ u Bernabee tu Antioquia. Utz aꞌ txaaleꞌl u Judas, vaꞌl Barsabaas ibꞌii, tuchꞌ u Silas. Tan aꞌ qꞌu vinaj qꞌesala tatin xoꞌl qꞌu niman tetz u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ech taqꞌtu bꞌen maꞌl uꞌ tiꞌ qꞌu vinaj tziꞌ. Ech nichtal tuul tzaꞌ: —Aatz oꞌ, oꞌ ichaj u Jesuus tuchꞌ qꞌu ansiano utz, tuchꞌ qꞌu niman tetz u Jesuus tzaꞌ, niqaqꞌ opon echajlichil, jatvaꞌl ex, ex hermanos xoꞌl qꞌu puera aanima atilex tu Antioquia tuchꞌ ex tunjot qꞌu tenam tikuenta Siiria utz, tuchꞌ tikuenta Ciliicia, bꞌaꞌn aꞌ bꞌaꞌn koj ex. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Aatz cheel saqal sete aas vetqabꞌilaꞌ vetmotxexisotzsa ekꞌuꞌl unjolol aanima tu yol aas vetmotxibꞌan yaꞌlex tiꞌ etzokꞌteꞌl bꞌiil echiꞌl. Utz nitaleꞌ aas senima qꞌul imantaar u Moisees majte. Aꞌ vetmotxelkubꞌen tu kuxoꞌl loqꞌ, yitꞌ kutzii koj te ech sataleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Pek bꞌaꞌn nikunacheꞌ vetkutxaa el unjolol vinaj tu kuxoꞌl. Ech seꞌntilex; samotxbꞌen tiꞌ u kuhermanos Pablo tuchꞌ u Bernabee, qꞌuꞌl tiichitꞌoꞌ tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Tan aatz u Pablo tuchꞌ u Bernabee, junal vinaj aas nojchit kꞌayimal tibꞌ tu kamchil tiꞌ talax paal vibꞌii u kuBꞌaal Jesucristo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ech aꞌ nikuchaj u Judas tuchꞌ u Silas. Aꞌ saꞌalon sete tuchꞌ itziꞌ majte kam qꞌuꞌl tzꞌibꞌamal tu uꞌ tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Tan bꞌaꞌn niꞌenku tu u Tioxhla Espiiritu utz, bꞌaꞌn niꞌenku qe majte aas yeꞌk vaꞌt ijatz saqaqꞌ jeꞌ setiꞌ. Pek taꞌxh saqal sete aas ministeer sebꞌan qꞌu kam tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Semaj etibꞌ tiꞌ techbꞌul qꞌu echbꞌubꞌal qꞌuꞌl nipaasal vatz bꞌanich tioxh. Yeꞌk setechbꞌu kaj. Yeꞌk sechiꞌ qꞌu chiꞌo txokop oj yeꞌ elnaj ikajal. Utz yeꞌk seteesa etibꞌ tu bꞌey tuchꞌ aanima. Ech oj setxꞌol inimal qꞌu kam tziꞌ, tiira bꞌaꞌn nebꞌaneꞌ. Laqil qibꞌ, bꞌaꞌn koj paalkꞌex.— Texh tu u uꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Uncheeꞌ motx tek bꞌen qꞌu vinaj qꞌuꞌl motx chajaxi. Bꞌen tu Antioquia. Ech imol kajay qꞌu niman tetz u Jesuus. Utz taqꞌ u uꞌ te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ech motx isikꞌle. Utz techal itxuqꞌtxun qꞌu niman tetz u Jesuus taqꞌo tan, aqꞌax nimal ikꞌuꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Aatz u Judas tuchꞌ u Silas, taqꞌ nimal ikꞌuꞌl majte utz, imoxbꞌe tu bꞌaꞌnla chaj yol. Tan axhibꞌi jolol alolich tetz u yolbꞌal Tioxh sikaꞌbꞌil. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Uncheeꞌ aatz maꞌtich tel bꞌiil tiempo tatin u Judas tuchꞌ u Silas tziꞌ, motx tek qꞌaavuꞌl xeꞌ qꞌuꞌl motx chajon tu Jerusaleen. Ech motx chajax kꞌasuꞌl tuchꞌ bꞌaꞌnil Tioxh tu qꞌu niman tetz u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Loqꞌ tachva kaachil u Silas tu Antioquia. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Aatz u Pablo tuchꞌ u Bernabee tan, taꞌxh bꞌanel motx atin tu Antioquia. Nichichus u bꞌaꞌnla chusbꞌal tetz u kuBꞌaal Jesuus utz, nichipaxsa itziiul tuchꞌ sibꞌat imol. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ech aatz paal kaꞌxvaꞌl qꞌii tuul, tal u Pablo tu u Bernabee ech tzaꞌ: —Saqꞌaavenkuqꞌila qꞌu niman tetz u Jesuus tu kajay qꞌu tenam qꞌuꞌl vetpaalqalvu viyolbꞌal u kuBꞌaal Jesuus. Seꞌnqileꞌ kam bꞌanel taqꞌo.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Utz aatz u Bernabee tan, aꞌ isaꞌ siꞌchtiqꞌo bꞌen u Xhan tiꞌ, vaꞌl Kuxh ibꞌii majte. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pek yeꞌt iꞌan tu u Pablo. Tan qꞌaavkoꞌnka u Xhan tu Panfiilia. Yeꞌt bꞌen tiꞌ ibꞌanax u aqꞌon tiꞌ u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Utz ech motx ok ixoꞌl utz, motx tek ijatx tibꞌ iatz. Aatz u Bernabee, tiqꞌo bꞌen u Kuxh tiꞌ. Okbꞌen tu vaarko. Aal ibꞌen tu Chipre bꞌeni. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Aatz u Pablo tan, aꞌ itxaa u Silas. Ech aatz qꞌu niman tetz u Jesuus tu Antioquia tan, iqꞌila isikꞌle Tioxh tiꞌ. Toksa bꞌen tiqꞌabꞌ u kuBꞌaal. ");
INSERT INTO ixlCNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ech bꞌeni. Aalich ipaal u Pablo tuchꞌ u Silas tikuenta Siiria tuchꞌ tu Ciliicia. Nimotxpaaltaqꞌ nimal ikꞌuꞌl qꞌu niman tetz u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Uncheeꞌ xamtich tek tuul opon u Pablo tuchꞌ u Silas tu Derbe tuchꞌ tu Listra. Utz atich maꞌl u niman tetz u Jesuus tziꞌ, Timoteo ibꞌii. Titzꞌinich maꞌl u ixoj Israeel, niman tetz u Jesuus; pek griego vitat. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Utz aatz qꞌu niman tetz u Jesuus qꞌuꞌl jejlich tu Listra tuchꞌ tu Icoonio, tiira bꞌaꞌn chit iyol tiꞌ u Timoteo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Ech bꞌaꞌn til u Pablo aas simolo bꞌen u Timoteo tiꞌ. Loqꞌ bꞌaxal nal tzokꞌax el bꞌiil ichiꞌl. Aꞌ isaꞌ aas yeꞌxhkam samotxtal qꞌu Israeel qꞌuꞌl atil tu qꞌu tenam qꞌuꞌl siꞌchmotxpaalka. Tan jolol tootzajich aas ikꞌaol griego u Timoteo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Utz aatz nichipaal tu qꞌu tenam, nichtal tu qꞌu niman tetz u Jesuus qꞌu mantaar qꞌuꞌl aqꞌax kuꞌ tibꞌeyil tu qꞌul ichaj u Jesuus. Aꞌ imol qꞌu ansiano aas imoltu tibꞌ tu Jerusaleen. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ech aatz qꞌu niman tetz u Jesuus, niꞌxhichtaqꞌax nimal ikꞌuꞌl tiꞌ inimal u Jesuus. Utz akꞌbꞌichil chit nichiꞌan u tachul jun qꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Uncheeꞌ elbꞌen u Pablo tuchꞌ u Silas tu vaꞌl atichka, motx paal iqꞌexpuka vikuenta u Galaacia tuchꞌ u Friigia. Siꞌchmotxpaaltal u yolbꞌal Tioxh tikuenta Aasia tala. Pek yeꞌt koꞌn aqꞌax tzii te tu u Tioxhla Espiiritu. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ech opon tu u txꞌavaꞌ Miisia. Utz siꞌchbꞌen tikuenta Bitiinia tala. Pek yeꞌt koꞌn paj aqꞌax tzii te tu u Tioxhla Espiiritu tetz u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ech motx tekoꞌn paal iqꞌexpuka u Miisia utz, bꞌenkuꞌ tu u tenam Troas. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Utz aatz iꞌan tu maꞌl u aqꞌbꞌal, kꞌuchax maꞌl visioon tu u Pablo. Til maꞌl u vinaj txaklich siatz, aa tu Macedoonia. Utz nichijaj bꞌaꞌnil te ech tzaꞌ: —Paalen tu Macedoonia utz, lochꞌoꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ech taꞌxh veet til u visioon u Pablo tziꞌ, kubꞌan tek tiꞌ aas sabꞌenoꞌ tu Macedoonia. Tan nojchit u Tioxh nisikꞌlenbꞌenoꞌ tiꞌ en talax u bꞌaꞌnla chusbꞌal tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Uncheeꞌ eltekbꞌenoꞌ tu Troas. Okbꞌenoꞌ tu vaarko yakichꞌoꞌ tu Samotraacia. Ech tu vaꞌt qꞌii tuul, aꞌ tek oponkꞌoꞌ tu Neaapolis. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Elbꞌenoꞌ tziꞌ, aꞌ tek oponkꞌoꞌ tu Filipos, u qꞌesal tenam tikuenta Macedoonia vaꞌl jejlelku qꞌu aa Roma. Utz kaa kaꞌxvaꞌl qꞌii oꞌ tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Uncheeꞌ aatz kubꞌan tu maꞌl u ilanbꞌal qꞌii, eluꞌloꞌ tiꞌ eluꞌl u okebꞌalop tu u tenam utz, bꞌenoꞌ tziꞌ u nimaꞌ. Tan nichiqꞌilal isikꞌlel Tioxh tziꞌ. Kꞌujeꞌoꞌ utz, qal u yolbꞌal Tioxh tu qꞌu ixoj qꞌuꞌl molich tibꞌ tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Utz atich maꞌl u ixoj tixoꞌl, Liidia ibꞌii, aa Tiatira; kꞌayin bꞌaꞌnla kaj bꞌuꞌj. Utz oksan iqꞌii Tioxh. Ech tꞌokax taanima tu u kuBꞌaal. Itzꞌich techit ixichin tiꞌ vaꞌl nichtal u Pablo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ech ibꞌan ivautiismo u ixoj tuchꞌ kajay qꞌu titzꞌin tatzik. Utz tal tek qe ech tzaꞌ: —Untzꞌoj nojchit in tek niman tetz u kuBꞌaal Jesuus netileꞌ. Koꞌtaj votzotz. Atinojex quxeꞌ.— Texhtuꞌ. Ech bꞌoꞌtziꞌmal chit kubꞌen iꞌana. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Uncheeꞌ aatz kubꞌana, aꞌ chit kubꞌen tu vaꞌl niqꞌilalik sikꞌlelik Tioxh. Ok maꞌl u ixviak tu kubꞌey. Atich ok tioxhil txꞌiꞌliꞌinaj kꞌatza. Nichiqꞌiian taqꞌo. Mam puaj nichitxꞌak qꞌu bꞌaal taqꞌon tu viqꞌiianeꞌ tan, aqꞌonomich tzixeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Utz xambꞌu bꞌen u ixviak qiꞌ tziꞌ. Vaꞌl iqetun taltu ech tzaꞌ: —¡Aatz qꞌu vinaj tziꞌ, jolol taqꞌonom utz, niman tetz u Tꞌankin Tioxh atziꞌ! Aꞌ nital paal texoꞌl u bꞌey tetz chitpichil tu paav.— Texhich. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Utz jatvaꞌl koꞌn qꞌii ech nichiꞌan tziꞌ. Ech tiira paal tek ikꞌuꞌl u Pablo taqꞌo. Ech isuchqꞌit tibꞌ utz, tal tu u tioxhil txꞌiꞌliꞌinaj ech tzaꞌ: —¡Tu vibꞌii u Jesucristo nival see aas saelaxh kꞌatz u ixviak tziꞌ!— Texh te. Ech tu koꞌxh unmuꞌkꞌul eli. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Uncheeꞌ aatz til qꞌu bꞌaal taqꞌon u ixviak tziꞌ aas yeꞌxhkaniꞌch veꞌt itxꞌak tipuaj tu viqꞌiianeꞌ, motx tek itxay u Pablo tuchꞌ u Silas. Utz motx tiqꞌo opon vatz qꞌul iqꞌatol tzii tu kꞌayibꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Motx toksa vatz qꞌu qꞌatol tzii utz, motx tal tiꞌ ech tzaꞌ: —¡Aatz qꞌu vinaj Israeel tzaꞌ, nikoꞌxhmotxilak txabꞌkin tu kutenam tzaꞌ! ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Vaꞌl motx ipaxsat itziiul unjot chusbꞌal aas yitꞌ saꞌkojiꞌaneꞌ sakukꞌuleꞌ utz, sakunima. Tan oꞌ aa Roma.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ech imoltu tibꞌ qꞌu tenam tiꞌ u Pablo tuchꞌ u Silas. Utz qꞌixax el toksaꞌm kꞌatza tu qꞌu qꞌatol tzii tziꞌ. Ech tal itzꞌuꞌmaleꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Aatz maꞌtich tek itzꞌuꞌmat bꞌaꞌnil, motx ex taqꞌ kuꞌ tu tzeꞌ. Utz talka tu u xeen tzeꞌ aas bꞌoono ixeel siꞌaneꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Aatz tabꞌi u xeen tzeꞌ tziꞌ aas ech alax te, tiira aꞌ tek ex taqꞌv okoꞌp tu tuul okoꞌp u tzeꞌ. Utz toksaka qꞌu qul tajan tiqopoꞌlil u seepo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pek aatz nikꞌatnajich aqꞌbꞌal, nichmotxiqꞌila isikꞌle Tioxh u Pablo tuchꞌ u Silas tu tzeꞌ. Utz nichibꞌitza u Tioxh. Tuul nichtabꞌin tereꞌn qꞌu preexhu. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Utz yeꞌk talcheꞌ paal maꞌl mam kabꞌnaano. Techalich bꞌoj itꞌanaꞌpun u tzeꞌ taqꞌo tuchꞌ vixeꞌ. Ech yakich jajpu kajay qꞌul ijubꞌalil u tzeꞌ. Utz chitmeꞌl qꞌu kadeena, qitzbꞌal tetz kajay qꞌu preexhu. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Uncheeꞌ kꞌas u xeen tzeꞌ taqꞌo. Utz aatz tila aas jajlich tek qꞌul ijubꞌalil u tzeꞌ, ijuu vichꞌichꞌ. Siꞌchtekiyatzꞌ jeꞌ tibꞌ tala. Tan aꞌ titzꞌa aas maꞌt tooj kajay qꞌu preexhu. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pek qetun eluꞌl u Pablo, tal te ech tzaꞌ: —¡Kamich aꞌana! ¡Ayatzꞌchil jeꞌ iibꞌ tan, atiloꞌ tzaꞌ sukukajayil!— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ech aatz tek u xeen tzeꞌ, tal ijeꞌ txijtxubꞌal utz, bꞌenoꞌk tu u tzeꞌ. Tuul techal iyikyoꞌlan tu xoꞌval. Pecheꞌ kuꞌ vatz u Pablo tuchꞌ u Silas. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Utz tiqꞌo eluꞌl tu tzeꞌ. Tal te ech tzaꞌ: —Chaj vinaj, ¿kam sunbꞌaneꞌ ech sachitpꞌin tu qꞌul unpaav?— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Tal u Pablo tuchꞌ u Silas te ech tzaꞌ: —Nima u kuBꞌaal Jesucristo, ech sachitpꞌaxh tu qꞌul apaav. Echat qꞌul iitzꞌin aatzik atil taatibꞌal majte.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ech tal u yolbꞌal Tioxh te tuchꞌ tu kajay qꞌu titzꞌin tatzik tu tatibꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Utz aatz iꞌan u xeen tzeꞌ tu u aqꞌbꞌal tziꞌ, itxꞌaa qꞌu takꞌonbꞌeꞌm u Pablo tuchꞌ u Silas vaꞌl akꞌon tu qꞌu tokebꞌal tzꞌuꞌm. Ech yakich tek ibꞌan ivautiismo tuchꞌ qꞌu titzꞌin tatzik tu tatibꞌal. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Uncheeꞌ toksa vatz meexha utz, taqꞌ techbꞌubꞌal u Pablo tuchꞌ u Silas tu totzotz. Techalich itxuqꞌtxun tuchꞌ kajay qꞌu titzꞌin tatzik tu tatibꞌal tan, inima u Tioxh. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Uncheeꞌ aatz tek qꞌalaꞌm, ichaj bꞌen unjolol polesiꞌy qꞌu qꞌatol tzii xeꞌ u xeen tzeꞌ. Ex tal te ech te tzaꞌ: —Chajpu qꞌu vinaj chi.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Aatz tek u xeen tzeꞌ tan, tal tu u Pablo ech tzaꞌ: —Ulyu iyol qꞌu qꞌatol tzii aas sachajpꞌex. Ech saꞌtekveeti sabꞌenex. Bꞌaꞌn ebꞌenaꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pek aatz u Pablo, tal koꞌn tu qꞌu polesiꞌy ech tzaꞌ: —Vatz tenam tzꞌuꞌmaloꞌ eet utz, yeꞌxhkam bꞌoj alax qe kam chaj tiꞌ. Yeꞌt txꞌolax kunujul taqꞌkuꞌoꞌ tu tzeꞌ utz, aal bꞌennajoꞌ aa Roma. Ech kantuꞌ sakoꞌxhijutzi kuchajpeꞌ nitxumeꞌ. Pek uloj oj echi utz, aꞌ suꞌleesanoꞌ.— Texh u Pablo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Uncheeꞌ aatz tek qꞌu polesiꞌy, ex tal qꞌu yol tu qꞌu qꞌatol tzii. Utz aatz tabꞌitaꞌ aas bꞌennaj peꞌks aa Roma u Pablo tuchꞌ u Silas, motx xoꞌv jeꞌ tiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ech opon tek vatz u Pablo tuchꞌ u Silas. Motx ex ijaj bꞌaꞌnil te. Tiqꞌo eluꞌl tu tzeꞌ utz, tal te aas samotxelbꞌen tu u tenam tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Uncheeꞌ aatz eluꞌl u Pablo tuchꞌ u Silas tu tzeꞌ, motx bꞌen otzotz xeꞌ u Liidia. Utz imol tibꞌ tuchꞌ qꞌu niman tetz u Jesuus. Taqꞌ nimal ikꞌuꞌl, ech eltekbꞌen tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Uncheeꞌ motx paal tu qꞌu tenam, u Amfiipolis tuchꞌ Apoloonia, ech tek opon tu Tesaloonica. Tan atich maꞌl atibꞌal chusbꞌal tetz u oꞌtla mantaar tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Utz bꞌen u Pablo tu u atibꞌal tziꞌ tan, ech nal chit nichiꞌaneꞌ. Utz oxvaꞌl ilanbꞌal qꞌii nichiyol u yolbꞌal Tioxh latziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Nichikꞌuch vinujul te, kam vaꞌl nital u Yolbꞌal Tioxh. Nichtaleꞌ aas ministeer chit ikam viTxaaom u Tioxh. Pek saqꞌaavitzꞌpu jeꞌ xoꞌl qꞌu kamnaj. Ech nichtal te tzaꞌ: —Aatz u Jesuus vaꞌl nunpaxsa talax itziiul sete tzaꞌ tan, aꞌ u viTxaaom u Tioxh.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ech inima u Jesuus unjolol aanima. Utz imolo tek tibꞌ tuchꞌ u Pablo tuchꞌ u Silas. Sibꞌal qꞌu griego qꞌuꞌl xoꞌvan Tioxh, niman majte. Antu sibꞌla ixoj, ayaꞌ qꞌuꞌl atich talcheꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Uncheeꞌ aatz unjot qꞌu Israeel qꞌuꞌl yeꞌt nimani, motx chiꞌon taanima. Ech imolo tibꞌ tuchꞌ unjolol qꞌu vinaj qꞌuꞌl taꞌxh tatibꞌal tulaj bꞌey, tulaj kꞌayibꞌal; yiꞌsaꞌ aqꞌon. Jolol maalola chaj aanima. Ech imol maꞌl mam tenam. Utz ilak maꞌl mam txabꞌkin. Motx ex tokebꞌe otzotz xeꞌ maꞌl u vinaj, Jasoon ibꞌii. Aꞌ siꞌchentiqꞌo eluꞌl u Pablo tuchꞌ u Silas vatz qꞌu tenam tala. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Pek yeꞌt motx ichabꞌa. Ech aꞌ tek tiqꞌo kꞌasuꞌl u Jasoon tuchꞌ unjot qꞌu niman tetz u Jesuus. Utz ex taqꞌ vatz qꞌu qꞌatol tzii. Qetuꞌm chit motx taltu ech tzaꞌ: —¡Motx ulyu qꞌu vinaj tzaꞌ qꞌul til koꞌxh niteesav aanima tu bꞌey tu u vatz txꞌavaꞌ tzaꞌ! ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Kꞌulaxyu tu u Jasoon tziꞌ. Utz sikajayil chituꞌ yeꞌ motx isaꞌ qꞌu mantaar aqꞌel tu u ijlenal Cesar. Aꞌ nimotxtaleꞌ aas atil vaꞌt ijlenal, Jesuus ibꞌii chi.— Texhtuꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ech ilak tibꞌ qꞌu qꞌatbꞌal tzii tuchꞌ qꞌu aanima tu u tenam aas tabꞌi qꞌu kam tziꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Pek aatz u Jasoon tuchꞌ qꞌul imol, ichooka ifianza. Ech motx ichajpeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Uncheeꞌ aatz qꞌu niman tetz u Jesuus, oora tek ichaj bꞌen u Pablo tuchꞌ u Silas tu u aqꞌbꞌal tziꞌ. Ichaj bꞌen tu Berea. Aatz motx opon tu Berea, motx bꞌen tu u atibꞌal chusbꞌal tetz u oꞌtla mantaar tetz qꞌu Israeel. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Utz maasich tzakꞌkin qꞌu aa Berea vatz qꞌu aa Tesaloonica tan, ayaꞌl chit ikꞌuꞌl motx ikꞌul u yolbꞌal Tioxh. Jun chit qꞌii nichipichꞌu u Yolbꞌal Tioxh. Aꞌ nichmotxisaji nojchixh ech nitaleꞌ vaꞌl maꞌtich talax te tu u Pablo tuchꞌ u Silas. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ech sibꞌal qꞌu Israeel niman u Jesuus. Antu qꞌu ixoj griego qꞌuꞌl atich talcheꞌ tuchꞌ sibꞌal vinaj. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Pek tabꞌi qꞌu Israeel qꞌuꞌl atich tu Tesaloonica aas atich u Pablo tu Berea tiꞌ talax u yolbꞌal Tioxh. Motx bꞌen tziꞌ. Ex paj ilak txabꞌkin xoꞌl tenam. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ech aatz qꞌu niman tetz u Jesuus tan, oora ichaj bꞌen u Pablo tziꞌ mar. Pek aꞌ texh kaaka u Silas tuchꞌ u Timoteo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Aatz qꞌu vinaj qꞌuꞌl iqꞌon bꞌen u Pablo, aꞌ ex taqꞌvuka tu u tenam Atenas. Ech motx qꞌaavi. Utz tal kꞌasuꞌl u Pablo tiꞌ aas nal koꞌxh topon u Silas tuchꞌ u Timoteo tzixeꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Uncheeꞌ tuul koꞌxh nichichꞌian u Pablo tu Atenas, tila aas aꞌ chit ninima qꞌu bꞌanich tioxh u mam tenam. Ech tiira txumun taanxelal taqꞌo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ech jun qꞌii nichitxay tibꞌ tu yol tuchꞌ qꞌu Israeel tu qꞌu atibꞌal chusbꞌal tetz u oꞌtla mantaar tuchꞌ qꞌu griego xoꞌvan Tioxh majte. Utz echat koꞌxh nichiꞌan tu kꞌayibꞌal xoꞌl qꞌu aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Uncheeꞌ xeꞌt itxay tibꞌ u Pablo tu yol tuchꞌ unjolol qꞌu mamaj aa txumbꞌal majte. Ayaꞌ qꞌuꞌl epicuureos vichusbꞌal. Utz atia estooico. Ech at tixoꞌl nichalon tiꞌ u Pablo ech tzaꞌ: —¿Kan tal vantziꞌ tuchꞌ tzaj iyol atziꞌ?— Chia. Utz at nichalon: —Texh paxsan itziiul unjot qꞌu tioxh aas anal cheeya.— Texhtuꞌ. Tan axhibꞌi aꞌ nichipaxsa talax itziiul u bꞌaꞌnla chusbꞌal te tiꞌ u Jesuus tuchꞌ tiꞌ u qꞌaavitzꞌpichil tikaꞌpaj. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Uncheeꞌ ech tiqꞌot bꞌen u Pablo tu maꞌl u estaadio Aeroopago ibꞌii. Ayaꞌ vaꞌl nichmotximolvu tibꞌ. Ech ichꞌotit te ech tzaꞌ: —¿Satz veeti saqabꞌi bꞌioj kam chit bꞌanel tu u chusbꞌal vaꞌl naaleꞌ tziꞌ? ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Tan aatz qꞌu kam naaleꞌ tziꞌ, tiira paarten anaxh niqabꞌi. Echtzixeꞌt aꞌ kusaꞌ saqootzaji u tokebꞌal.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Tan kam koj vaꞌt nichmotxtitzꞌa qꞌu aa Atenas tuchꞌ qꞌu puera aanima atich tziꞌ, pek taꞌxhich isaꞌ tabꞌil vaꞌtoj akꞌ kam. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Uncheeꞌ txakeꞌ tek u Pablo tixoꞌl tu u Aeroopago utz, tal te ech tzaꞌ: —Vinaj aa Atenas, vetvillaꞌ aas tiira ex aa uqꞌaybꞌal sekajayil. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Tan vetpaalvillu qꞌul enachbꞌal. Utz vetvil maꞌl u nachbꞌal tzꞌibꞌamal maꞌl u tzꞌibꞌ siatz ech tzaꞌ: «NACHBꞌAL TETZ U TIOXH VAꞌL YEꞌ OOTZAJIMAL.» Chia. Neqꞌila esikꞌle kꞌuxh yeꞌ etootzaj. Utz aꞌ u Tioxh vaꞌl nival sete cheel tzaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ayaꞌ u Tioxh vaꞌl bꞌanonnaj tetz u vatz amlika txꞌavaꞌ tzaꞌ tuchꞌ kajay qꞌu kam atil tuul. Aꞌ viBꞌaal u vatz amlika txꞌavaꞌ. Echtzixeꞌt saꞌkojjejeꞌ tu maꞌj otzotz aas ibꞌanoꞌm aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Taqꞌonibꞌal koj iqꞌabꞌ maꞌj aanima soꞌoksan iqꞌii. Kam koj nisavsa. Tan aal aꞌ vaꞌl niaqꞌon kutiichajil sukukajayil. Aꞌ niaqꞌon quulabꞌ. Utz aꞌ niaqꞌon qꞌu kam kajayil. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Aꞌ tzꞌajon u bꞌaxa vinaj. Kꞌatz koꞌn maꞌl vinaj vetꞌelku tiil kajay qꞌu aanima qꞌuꞌl atil tu u vatz amlika txꞌavaꞌ tzaꞌ. Utz aꞌ oksan itxolbꞌalil qꞌu tenam. Aꞌ alonnaj tetz jankꞌal samotxpaaliꞌaneꞌ utz, til samotxjejeꞌka. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ech samotxichok Tioxh. Kꞌuxh echaꞌ matxumal ichokleꞌ siꞌaneꞌ, loqꞌ sichabꞌa. Tan tzian koj elnaj u Tioxh sukukꞌatza sukujununil. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Tan iqꞌaqꞌal u Tioxh kꞌuxh itzꞌleloꞌ, nikuyikuneꞌ utz, atiloꞌ. Nojchit echi vaꞌl nital maꞌl u yol alel tu qꞌul e aa txumbꞌal ech tzaꞌ: «Oꞌ ituꞌxh ixalam u Tioxh.» Chia. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Utz aꞌ chituꞌ. Oꞌ ituꞌxh ixalam Tioxh. Ech yeꞌ koꞌxh qitzꞌa aas ech u Tioxh aꞌ qꞌu bꞌanich tioxh qꞌuꞌl bꞌaꞌnla qꞌan chꞌichꞌ. Tan yitꞌ aꞌ koj. Bꞌaꞌnla saj chꞌichꞌ koj. Bꞌaꞌnla kꞌoxich sivan koj. Utz ech koꞌn koj aꞌ maꞌj kam aas cheesamal koꞌn iveet titxumbꞌal maꞌj aanima. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Tan aatz u Tioxh vetipaasalka u tiempo echil tziꞌ, vaꞌl yeꞌt ootzajil u Tioxh tuul. Pek aatz cheel, nitektaleꞌ aas samotxikꞌaxa qꞌul ipaav kajay qꞌu aanima tu kajay u vatz amlika txꞌavaꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Tan bꞌanel tek tiꞌ maꞌl u qꞌii taqꞌo aas tu chit ijikomal suꞌlitxꞌol inujul kajay qꞌu aanima tu u vatz amlika txꞌavaꞌ. Aꞌ sabꞌanon taqꞌo u Vinaj vaꞌl aꞌ oksan tijleꞌm. Tan toksa iqꞌii vatz tenam tiꞌ u qꞌaavtitzꞌpu jeꞌ xoꞌl qꞌu kamnaj.— Texh u Pablo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Uncheeꞌ taꞌxh tabꞌi aas saqꞌaavitzꞌpu qꞌu kamnaj tikaꞌpaj, atia nichtekoꞌnmotxbꞌanbꞌen tiꞌ. Utz atia alon te ech tzaꞌ: —Tunpat laqabꞌi qꞌuꞌl naaleꞌ tziꞌ.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ech eltekkꞌasuꞌl u Pablo tixoꞌl. ");
INSERT INTO ixlCNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pek atich unjolol majte, inima u Jesuus. Ech imolo tek tibꞌ tuchꞌ u Pablo. Utz atich maꞌl u vinaj tixoꞌl qꞌuꞌl nimani tziꞌ, Dioniisio ibꞌii, maꞌl tu qꞌu qꞌatol tzii tu Atenas. Utz antich vaꞌt u ixoj majte Daamaris ibꞌii. ");
INSERT INTO ixlCNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Uncheeꞌ xamtich tek tiꞌ qꞌu kam tziꞌ, elbꞌen u Pablo tu Atenas utz, bꞌen tu Corinto. ");
INSERT INTO ixlCNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Utz ichabꞌa tibꞌ tuchꞌ maꞌl u Israeel tziꞌ, Aquila, aa tikuenta Ponto. Analich koꞌxh ikꞌasuꞌl tu Itaalia. Aꞌich imol u Priscila, u tixoj. Tan aatz u Claudio, u ijlenal tu Roma, teesa maꞌl mantaar aas saelkꞌasuꞌl qꞌu Israeel tu vitenam. Ech opon u Pablo tzixeꞌ. Ex iqꞌila. ");
INSERT INTO ixlCNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Utz yakich atinojka tzixeꞌ. Elaich koꞌn qꞌu taqꞌon. Ech ela tek nichmotxtaqꞌonineꞌ. Tan bꞌano atibꞌal nichiꞌaneꞌ ayaꞌ qꞌuꞌl bꞌuꞌjiꞌ. ");
INSERT INTO ixlCNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Utz jun ilanbꞌal qꞌii, nichichus u yolbꞌal Tioxh u Pablo tu u atibꞌal chusbꞌal tetz u oꞌtla mantaar. Aꞌ nichibꞌan yaꞌl tok u bꞌaꞌnla chusbꞌal tiviꞌ qꞌu Israeel tuchꞌ qꞌu griego. ");
INSERT INTO ixlCNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Uncheeꞌ eltekkꞌasuꞌl u Silas tuchꞌ u Timoteo tu Macedoonia utz, opon tu Corinto. Taꞌxh uli utz, tila aas tiira oknaj u Pablo tiꞌ ipaxsal itziiul u yolbꞌal Tioxh. Nichiꞌan yaꞌl tok tiviꞌ qꞌu Israeel aas aꞌ viTxaaom u Tioxh u Jesuus. ");
INSERT INTO ixlCNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pek aatz qꞌu Israeel, motx koꞌn iqꞌeꞌbꞌaꞌ tibꞌ. Utz nichiyoqꞌoneꞌ. Ech ilitꞌiꞌyu toksaꞌm u Pablo siatz. Utz tal te ech tzaꞌ: —Ex atkoꞌxh ataj paav oj lakuꞌ u choobꞌal paav setiꞌ. Yeꞌk loꞌok vijtzil setiꞌ. Pek aatz cheel, maꞌtꞌin xoꞌl qꞌu puera aanima.— Texh te. ");
INSERT INTO ixlCNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ech elkꞌasuꞌl u Pablo tu u atibꞌal chusbꞌal tetz u oꞌtla mantaar utz, bꞌen otzotz xeꞌ maꞌl u vinaj, Tiicio Justo ibꞌii, xoꞌvan Tioxh. Ankoꞌxh atichku tatibꞌal txala u atibꞌal chusbꞌal tetz u oꞌtla mantaar. ");
INSERT INTO ixlCNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Uncheeꞌ aatz u Crispo, u qꞌesala tu u atibꞌal chusbꞌal tetz u oꞌtla mantaar, inima u kuBꞌaal, tuchꞌ tixoj ikꞌaol imeꞌal kajayil. Utz sibꞌal qꞌu aa Corinto abꞌin u bꞌaꞌnla chusbꞌal utz, nichinima. Utz nichmotxibꞌan ivautiismo. ");
INSERT INTO ixlCNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Uncheeꞌ aatz u kuBꞌaal, iqꞌila u Pablo tu maꞌl visioon tu aqꞌbꞌal. Tal te ech tzaꞌ: —Yeꞌ koꞌxh xoꞌvaxh. Al u bꞌaꞌnla chusbꞌal. Yeꞌ yaꞌaxh tiꞌ talaxeꞌ. ");
INSERT 