﻿USE sofia;
DROP TABLE IF EXISTS sofia.iws_vpl;
CREATE TABLE iws_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES iws_vpl WRITE;
INSERT INTO iws_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Tɨ kara wɨnkiyɨm yɨm Jisɨs siir yɨdiwi wanwiyaeyɨm sɨmiir inɨg ɨma. Jisɨs siya yɨo inkam komiiyɨn nu kɨgrɨraowiyɨn Devid siir isidgɨn mɨ yɨo Devidɨn Ebrahamni isidɨn siirgɨn. ");
INSERT INTO iws_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ebraham yɨo Aisakni adgɨn mɨ Aisakɨn yɨo Jekopni adgɨn mɨ Jekopɨn yɨo Judani adgɨn mɨ siir nomousɨsɨm ɨkɨm, yɨo sɨmiir yao adgɨn. ");
INSERT INTO iws_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judaɨn yɨo Peres Sira sowiir adgɨn. Mɨ sowiir yopiiya Temaka. Mɨ Peresɨn yɨo Hesroni adgɨn. Mɨ Hesronɨn yɨo Ramni adgɨn. ");
INSERT INTO iws_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Mɨ Ramɨn yɨo Aminadapni adgɨn mɨ Aminadapɨn yɨo Nasoni adgɨn mɨ Nasonɨn yɨo Salmoni adgɨn. ");
INSERT INTO iws_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Mɨ Salmonɨn yɨo Boasni adgɨn mɨ Boas siir apua Rehapka. Mɨ Boasɨn yɨo Obetni adgɨn mɨ siir apua Rutga mɨ Obetɨn yɨo Jesini adgɨn. ");
INSERT INTO iws_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Mɨ Jesiyɨn inkam komiiyɨn nu kɨgrɨraowiyɨn Devid siir adgɨn mɨ Devidɨn yɨo Solomoni adgɨn mɨ siir apua bɨiya Yuraiani wig nikɨ oka. ");
INSERT INTO iws_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Mɨ Solomonɨn yɨo Riaboamni adgɨn mɨ Riaboamɨn yɨo Abaisani adgɨn. Mɨ Abaisaɨn yɨo Esani adgɨn. ");
INSERT INTO iws_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Mɨ Esanɨn yɨo Jehosapetni adgɨn mɨ Jehosapetɨn yɨo Joramni adgɨn. Mɨ Joramɨn yɨo Asaiani adgɨn. ");
INSERT INTO iws_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Mɨ Asaiaɨn yɨo Jotamni adgɨn mɨ Jotamɨn yɨo Ehasni adgɨn. Mɨ Ehasɨn yɨo Hesekaiani adgɨn. ");
INSERT INTO iws_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Mɨ Hesekaiaɨn yɨo Manasani adgɨn mɨ Manasaɨn yɨo Emosni adgɨn. Mɨ Emosɨn yɨo Josaiani adgɨn. ");
INSERT INTO iws_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Mɨ Josaiaɨn yɨo Jekonaia mɨ siir nomou yaowae ɨkɨm sɨmiir adgɨn. Mɨ taka ɨiya saeya Isrel sɨmiir sauan omomɨn sɨma nɨkɨunama om komii Babilon siir nu ɨiir ninɨ prɨimɨriinakiya whɨsarii mɨi. ");
INSERT INTO iws_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Mɨ ɨiya sɨma om komii Babilon siir nu ɨiirar nikɨ prɨimɨriiyɨm whɨsarii mɨi mɨ Jekonaia siya Sialtiel siir ad nwokɨn. Mɨ Sialtiel yɨo Serababelni adgɨn. ");
INSERT INTO iws_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Mɨ Serababelɨn yɨo Abiatni adgɨn mɨ Abiatɨn yɨo Elaiakim siir adgɨn. Mɨ Elaiakimɨn yɨo Esoni adgɨn. ");
INSERT INTO iws_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Mɨ Esoɨn yɨo Sedokni adgɨn mɨ Sedokɨn yɨo Ekimni adgɨn. Mɨ Ekimɨn yɨo Elaiatni adgɨn. ");
INSERT INTO iws_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Mɨ Elaiatɨn yɨo Eliesani adgɨn mɨ Eliesanɨn yɨo Matani adgɨn. Mɨ Matanɨn yɨo Jekopni adgɨn. ");
INSERT INTO iws_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Mɨ Jekopɨn yɨo Josepni adgɨn mɨ Josepɨn yɨo Mariani kamkɨn. Mɨ Jisɨs siirɨn Maria saeya naokainakɨn. Sɨma siirɨn ha dapikɨm Krais, inkam Adi Komii siya nɨkropkiyɨn. ");
INSERT INTO iws_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Mɨ yɨnɨeyɨm Ebraham siir hɨrankɨn nɨtyokiyokɨiyɨm Devid siir nakiyanguniyɨm isidɨm ɨuur whiigɨm mɨ Devid siir hɨrankɨn nɨtyokiyokɨiyɨm yɨnɨeyɨm ɨni ɨiya sɨma om komii Babilon siir nu ɨiir mɨriiya whɨsarii mɨi ɨni saiirar yadɨgniya, yɨm ɨriipɨ hɨriinan ɨuur whiigɨm. Mɨ ɨiya sɨma whɨsarii mɨi prɨimɨriiya om komii Babilon sɨmiir nu ɨiir mɨ ha nɨtiyokiyokɨiyɨm mɨ ɨni Krais siya nɨmbiyama ɨiya saiirar yakiyanguniyɨm inkamɨn Adi Komii siya nɨkropkiyɨn mɨ yɨm ɨriipɨ hɨriinan isidɨm ɨuur whii. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Niwiiyɨn Jisɨs Krais siir naokainan yɨo hɨnɨngɨn, siir yopiiya Maria saiirɨn Josep siiram bɨdi boɨrɨtmaiya siya nonkwonam. Mɨ siya ɨrɨpa pɨu saɨka nikɨ o karamaeyar nikɨ owɨn mɨ ɨni saeyar yɨnoknɨnkɨnkiya, saeya Adi Komii siir naeyɨu ɨiirsiyar nwokika yɨnkak. ");
INSERT INTO iws_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Mɨ Josepɨn kamɨn saiiram boɨrɨtmaiyɨn, siya inkam wadɨekɨn. Siir ɨga hɨnda tɨnda bɨ nokwowikɨn. Nɨɨngaka. Mɨ siya Maria saiirɨn iikam whwonkam ɨda kiyopsɨbgi haigɨnɨuwɨm pɨ boriisopi. Mɨ siya hindara nɨmprɨo sopkiyam tɨri mɨ saeya wɨ nɨdidgak nwowisi. ");
INSERT INTO iws_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josep siya ta saiir saiira naɨngwokwonanaekɨn mɨ Adi Komii siir paekwosɨmɨn siirɨn nhwo siya yɨkɨumauu. Paekwosɨm siya boɨn, Josep Devidni yɨnɨeyɨm sɨm yɨnisɨmɨn, ta kɨriir wiga Maria yɨnkak nwowa kɨra saiir nonkwonasi kɨpi nɨdid. Wakɨ yɨnisɨmɨn saiir mhɨinau hɨr nwokaiyɨn, yɨo Adi Komii siir naeyɨu mɨiyɨkɨn siyar haigiyɨumauugɨn. ");
INSERT INTO iws_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Saeya wɨ yɨnisɨm yɨnkamiyɨn naokainaei, siya wɨ Isrel sɨmiir iikamɨm sɨmiir dimɨn biyɨe ɨmiir haiyoprimdiyɨumiigi mɨ wɨ sɨmiir nanmaiwarkainaei. Mɨ kɨra siir inɨgɨn wɨ Jisɨs asi nokdap haigɨnɨuwi. ");
INSERT INTO iws_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tɨ digworaekwo whɨekakɨm nɨmbɨibɨiyamɨm ɨni tɨ yaiyɨm bɨdi bɨdiniya Adi Komii siya boɨnkiyɨm profet inkamɨn siir boɨnmɨmauuwam mɨ sɨmiir swokɨ boɨnɨurwokaigikɨn. Profet inkamɨn siya hɨnɨɨna boɨnkikɨn. ");
INSERT INTO iws_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Wakae, wig kopaksɨm nɨɨnga ɨra inkamaka ɨrɨpa pɨu nwo karam nwowa, saeya wɨ yɨnkak nwowi mɨ wɨ yɨnisɨm yɨnkamiyɨn naokainaei. Mɨ sɨma siir inɨgɨn wɨ Emanyuel nokdap haigɨnɨuwi. Mɨ tɨ paekwosɨm siir yaiya ɨni dɨg ywokiya. Mɨ tɨ inɨgɨn siir inɨg mwokɨmwowɨn yɨo hɨnɨɨngɨn, Adi Komii krɨmiir Wanɨn siya ɨni krɨmakar nwowɨn. ");
INSERT INTO iws_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Mɨ Josep siya ha kaknanaokaigiyɨn mɨ siya ɨni Bɨiyan Inkam Komiiyɨn siir paekwosɨmɨn siya boɨngikɨn yaiyɨm ɨni sɨmiir hɨriinanar swokɨ tɨrɨn. Mɨ siya siir wiga saiirɨn ɨna yonkwonan. ");
INSERT INTO iws_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mɨ Josep siya ɨrɨpa pɨu saɨka bɨ nwomɨmɨnkɨn mɨ ɨni saeyar yaokaina budgiyɨn yɨnisɨm ɨiirar. Mɨ Josep siya siir inɨgɨn Jisɨs yokdap haigɨnɨu. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maria saeya Jisɨs siirɨn omisɨm Bethlehem nu Judia hɨr naokainakɨn, ɨiya Herot siya nu kɨgrɨraowan inkam komii nwowa. Mɨ mhoɨiya saeya siir naokainakiyɨn mɨ kam nhɨrɨm nauuni siyɨuɨn si nɨnoknɨnkɨniyɨm, bɨekɨ nɨmbiidniyɨn hɨranɨm om komii Jerusalema hɨriir yɨt. ");
INSERT INTO iws_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Mɨ sɨma inɨ srɨini, ɨiya krɨma tɨ nauun wɨn komii ɨiir kɨgɨm tɨ yɨnisɨm wɨnɨn naokainan siirɨn Judami inkam komiiyɨn sɨmiir nu kɨgrɨraowanɨn ɨni papi nwowɨn? Nɨm krɨma ɨna yɨnoknɨnkɨniyɨm tɨ yɨnisɨmɨn bɨdi yaokainakiyɨn. Mɨ krɨma siir inɨg ɨiir ninɨ hainaniyam nɨtkɨm. ");
INSERT INTO iws_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mɨ ɨiya inkam komiiyɨn Herot siya ta yai aiir wakaewɨnɨn mɨ siya ɨni hɨkakar ywokiyɨn. Dimusi rani, siya hɨnɨɨna naɨngwokɨn tɨ yɨnisɨmɨn wɨ siyar nokwokairinanaowidi siir ɨgsopa. Om komii Jerusalem hɨrɨn iikam nhɨrɨm yɨm ɨriipɨ hɨriinan ɨni hɨkakar mɨ okiyɨm. Dimusi rani, Herot siya ɨo komiigakɨn. ");
INSERT INTO iws_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Mɨ Herot siya prismi bɨiyan inkamɨm sɨmiiram yɨkɨuna, yɨpɨkɨ Adi Komii siir inɨg hainaniyɨm omakam sɨmiir dimɨn taemɨn ɨmiir kɨgrɨraowiyɨm mɨ kamɨm siyɨu komii nɨnoknɨnkɨni ɨkɨm. Mɨ siya sɨmiirɨn ha nɨkɨuna dɨgɨn mɨ siya sɨmiir srɨi, inkamɨn siya nɨmbingiyɨn Krais siya wɨ pɨkɨ hɨnɨɨn omɨn si naokainaei? ");
INSERT INTO iws_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Sɨma siirɨn hɨnɨɨna boɨn, om Bethlehem nu Judia hɨrɨn profet inkamɨn siya hɨnɨɨna boɨnkikɨn, ta yaiya siya hɨnɨɨna wɨn boɨnkikɨn, ");
INSERT INTO iws_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","omisɨm Betlehem nu Judia hɨranɨn, kɨra inɨg karamae omisɨm tani. Nɨɨngakɨ nɨɨngakɨɨnga. Mɨ inkam komii nwɨrɨn wɨ kɨriir waraur nɨmbiyami mɨ siya wɨ kariir isidɨn Isrel hɨranɨn wɨ sɨmiir nu kɨgrɨraowan inkam komii nwowi. ");
INSERT INTO iws_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mɨ Herot siya tɨ kamɨm bɨekɨ nɨmbiidniyɨn hɨrankɨ nɨtɨm, sɨmiirɨn hindara asi nɨmprɨo ɨkɨunakɨn, nɨmprɨo yai boɨnam. Mɨ siya sɨmiirɨn ɨna srɨiyɨn, tɨkɨ nauunɨ pakɨ hɨnɨɨn ɨiya sae nɨmbiyamkɨn, ha? ");
INSERT INTO iws_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Mɨ ɨiya sɨma siir boɨnmɨmauu dɨgiyɨm mɨ siya sɨmiirɨn ɨna yɨkropkiyɨn om Betlehem hɨriir mɨ ɨna boɨnkiyɨn, kɨma ha dam! Mɨ kɨma tɨ yɨnisɨmɨn siirɨmɨn pranae pranae kɨpi hansran. Mɨ kɨma pɨ siir hansran yɨskaii pa swokɨ ɨt kariir swokɨnɨ boɨnmauuni. Mɨ an kara ɨriipɨ hɨriinan, wɨ siir inɨg ɨiir minɨ hainanɨuwi. ");
INSERT INTO iws_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mɨ sɨma Herot siir yai aiir wakae dɨgnamɨm mɨ sɨma ɨna yamɨm. Mɨ tɨ nauunɨn bɨiya sɨma nikɨ kɨgnaniyɨn bɨekɨ nɨmbiidniyɨn hɨr mɨ siya ha hɨoraraowamɨn sɨmiir bɨiyar mɨ ɨni omaka yɨnisɨm ɨeyar nwowa ɨni saiirgɨ saiir akou kouwar yakaigɨkɨuwɨuwɨn. ");
INSERT INTO iws_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Mɨ sɨma tɨ nauun ɨiir kɨgɨm mɨ sɨma ɨni maɨrgɨmaɨrga komiikakar ywonamɨm. ");
INSERT INTO iws_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mɨ sɨma ha napnɨnopkainamɨm omaka hɨriir mɨ ɨni Maria sowiirbugar youapnɨnopkai kɨgɨm. Mɨ sɨma ogmwo ha ninɨ waisi hɨuwɨuwɨm mɨ ɨni yɨnisɨmɨn siir inɨg ɨiirar inɨ hainanɨuwɨm. Mɨ sɨma sɨmiir mɨiya sɨsɨmsɨsɨmɨm ha haiwaokiyɨm mɨ sɨma dimɨn kɨbi nhɨrɨm umɨr komii saɨniyɨm kɨmɨdiniya siir prɨihauu. Dimɨnɨm sɨma prɨihauuwɨm hɨnɨɨn hɨnɨɨngɨm, gold mɨ pauraɨn pɨuii mɨiyɨk nɨusiin whakiyɨn mɨ sandaɨn namswopaini pɨuii mɨiyɨknan whaki ɨkɨn. ");
INSERT INTO iws_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mɨ mhoɨiya sɨmiirɨn Adi Komii siya kɨmɨdiniya nhwo yɨkɨumauuwɨi. Mɨ tɨ nhwo ɨiirɨn Adi Komii siya hɨnɨɨna boɨnki, kɨma wɨ Herot siiram kɨpi swokɨ am mɨ tɨ digworaekwowɨm kɨma kɨgɨm siir kɨpi boɨnmauuwɨu. Nɨɨngaka. Mɨ sɨma yaeya siyɨu whɨra asi namkɨm sɨmiir oma hɨriirɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mɨ ta sɨma haiburgika saiir mhoɨiya mɨ Adi Komii siir paekwosɨmɨn siya hɨnɨɨna boɨnki, kɨra dɨnsiingi mɨ kɨriir wigyɨnɨm sɨmiir dɨkɨunam. Mɨ kɨra pɨ nu Isiba hɨriir dɨdamki mɨ hɨr tinɨ owou mɨ wɨ karar swokɨ ɨkɨugi kɨriiramɨn. Herot siya warɨ yɨnisɨm ɨiiram hansɨri tɨri siir nɨsomaowɨm. ");
INSERT INTO iws_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Mɨ Josep siya tɨ yai ɨmiir wakaekiyɨn mɨ siya ɨna yɨnsiingiyɨn. Mɨ siya siir wigyɨn ɨmiirɨn nɨiya whɨnɨdamkiwɨi nu Isiba hɨriirɨn. Mɨ sɨma ɨi kasa bɨ napɨwaiyamkɨm hɨriirɨn. ");
INSERT INTO iws_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Mɨ Josep siya nu Isib hɨrar nwowɨn mɨ ɨni Herot siyar yaobudgiyɨn. Mɨ sɨma ta yaiya bɨikɨ Bɨiyan Inkam Komiiyɨn siya boɨnkiya profet inkam nwɨrɨn si mɨ saiir swokɨ boɨnɨurwokaigikɨm. Saeya hɨnɨɨna boɨnkika, kariir yɨnisɨm yɨnkamiyɨnɨn nu Isib hɨr nwowɨn, kara siiram swokɨ ɨkɨugi siya swokɨ ɨtɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Mɨ ɨiya Herot siya hɨnɨɨna nɨnoknɨnkɨnkiyɨn tɨ kamɨm bɨekɨ nɨmbiidniyɨn hɨrankɨ nɨtɨm, sɨma siir nɨksɨsaegigɨm. Mɨ siir kwoɨnɨn ɨna iwɨtpaomaigiyɨn mɨ siya kam nhɨrɨm yai kɨrɨe sɨmiir boɨnki, sɨma om Betlehem mɨ omisɨsɨm nhɨrɨm siir kingiin nwo ɨkɨm sɨmiir hɨran yɨnisɨsɨm yɨnkamiyɨn whɨekakɨm, bɨewi whwowɨsa nwowɨm mɨ nua tɨriir nwonainiyɨm sɨmiir nɨsomsom aowam. Siya digworaekwowɨm nauun nɨnoknɨnkɨni kamɨm sɨma boɨngigɨm mɨ sɨmiir swokɨ aɨngwowoknakikɨn ɨiya Jisɨs siir naokaina. Mɨ sɨma asi nɨsomsom aokaokɨm yɨnkamiyɨnɨm bɨewi whwowɨsa nwowɨm nua tɨriir nɨtɨm. ");
INSERT INTO iws_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Mɨ tɨkɨ digworaekwowɨm bɨigɨ Bɨiyan Inkam Komiiyɨn profet Jeremaia siya boɨnkiyɨm sɨmiir swokɨ boɨnɨurwokaigikɨn. Siya hɨnɨɨna boɨnkikɨn, ");
INSERT INTO iws_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","sɨma wakaeki yaiya om Rama hɨran iikamɨm sɨma nouubopon prasae bɨ kɨnkɨm. Rachel saeya saiir yɨnisɨsɨm ɨmiirsi kaouuboponka. Mɨ iikamɨm sɨma saiir hiirwokmaiyɨm dɨg bɨ nwokɨm. Nɨɨngaka. Dimusi rani, saiir yɨnisɨsɨmɨm nwɨrmɨn nwɨrmɨnkɨn bɨ swokɨ okikɨm. Nɨɨngakɨ, nɨɨngaka. Mɨ tɨ dimɨnɨm nɨmbiyamɨm ɨiya Herot siya nɨsomsom aokaowɨm Rachel saiir isidɨn sɨmiir yɨnisɨm yɨnkamiyɨn ɨmiir omisɨm Betlehem hɨr. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mɨ mhoɨiya Herot siya ɨna yaonamɨn. Mɨ nu Isib hɨrɨn Bɨiyan Inkam Komiiyɨn siir paekwosɨmɨn nhwo siya yɨkɨumauu Josep siirɨn. ");
INSERT INTO iws_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Siya hɨnɨɨna boɨnkikɨn, kɨra dɨnsiingi mɨ kɨra kɨriir wigyɨnɨm sɨmiir dɨkɨunam mɨpi nu Isrel hɨriir swokɨ am. Iikamɨm tɨ yɨnisɨm ɨiir nɨsomaowam boɨnɨm sɨma bɨdi yaokaoswowamɨm. ");
INSERT INTO iws_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Mɨ Josep siya ha kaknanaokaigiyɨn mɨ siya ɨni siir wigyɨnɨm sɨmiir yɨkɨunamɨm mɨ sɨma ɨna swokɨ amɨm nu Isrel hɨriir. ");
INSERT INTO iws_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mɨ siyar wakaewɨn Akeleas siya siir adɨn Herot siir mɨi aiir bɨdi swokɨ hainaowidɨn nu Judia siir nu kɨgrɨraowan inkam komii nwowam. Mɨ Josep siya asi nɨdidgɨn hɨriir namsiyɨn. Mɨ nhwo whɨrɨn Josep siya whɨnɨn, Adi Komii siya siirɨn hɨnɨɨna boɨnki, kɨra wɨ hɨriir kɨpi nam. Mɨ siya nu Galiliya hɨnda asi namkɨn. ");
INSERT INTO iws_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Mɨ siya kɨmɨdiniya om whɨrɨn Nasaret nɨkɨuwiyɨn siir inɨ ɨdwoɨu. Mɨ sɨma ta yaiya bɨiya profet inkamɨn siya boɨnkiya saiir swokɨ boɨnɨurwokaigigɨm. Sɨma siirɨn wɨ om Nasaretan inkam nɨkɨuwi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mɨ bɨewi nhɨrɨm bɨdi yamkiyɨm ɨiya Josep Maria Sɨmani om Nasaret hɨr nwowa. Mɨ mhoɨiya Jonɨn op baptaisiyɨn siya ha nɨtɨn mɨ kɨmɨdiniya nu Judia hɨran nu siiyɨn apaɨn siir hɨr inɨ boɨnmɨmauu bwakainani, Adi Komii siir yaiya. ");
INSERT INTO iws_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Mɨ siya hɨnɨɨna boɨnki, kɨma dimɨn biyɨe biyɨeyɨm sɨmiirɨn digɨumii haimriyɨugig. Dimusi rani, ɨiya Adi Komii siya siir digworaekwowɨm sɨmiir kɨgɨrkakana ɨni kingiin nwowa. ");
INSERT INTO iws_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jonɨn tɨ siya inkamɨn Adi Komii siya boɨnkiyɨn profet Aisaiani. Bɨdi bɨdiniyarɨn profet Aisaia siya hɨnɨɨna wɨnboɨnkikɨn, maeyau siiyɨn nu apaɨn inkam karamaeyɨn, inkam nwɨrɨn siir yaiya hɨnɨɨna kauwok boɨnkikɨn, Bɨiyan Inkam Komiiyɨn siir siyɨuɨn sɨbgu kisɨsop dirɨraerarkwokɨn. Siir siyɨupai siyɨupaiyɨm sɨbgu dirɨraerarkwokɨn siya napnaniyam. ");
INSERT INTO iws_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon siya niiya yɨuɨsa mɨiyɨk rani, kamelni pɨokɨm. Mɨ siya pɨuwopa ha mɨ kikog mɨ naeyɨm siya naeiyɨm kokmwo graeyɨs mɨnɨm mɨ mhwɨɨni yɨn ɨkɨm. Siya yaeya dimɨn whɨr bɨ swokɨ aeikɨn, siya inkam paeprikabnankɨn. ");
INSERT INTO iws_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Mɨ taka ɨiya, iikamɨm om komii Jerusalem hɨranɨm mɨ nu Judian ɨkɨm mɨ iikam whɨekakɨm omom ɨe Jodan kingiin nwo ɨkɨm sɨmar yɨtswo Jon siiramɨn. ");
INSERT INTO iws_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Mɨ sɨma sɨmiir dimɨn biyɨe biyɨeyɨm ha nomboɨnɨnɨskiyɨm mɨ Jon siya sɨmiirɨn ɨe Jodan hɨr baptais haigɨnɨu. ");
INSERT INTO iws_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mɨ Jon siyar kɨg Farisi Sadyusimi kam isid komiiyɨn pɨ nɨti siirɨm op sɨmiir baptais haigɨnɨuwam. Mɨ siya sɨmiir boɨnki, kɨma kam mɨiyɨknankɨ mɨ ɨuwi, ɨni wrakɨwranan ywowɨm. Kɨmiirɨn nhɨɨnga boɨnkikɨm kɨma kariiram nɨdamnaniyɨm op kɨmiir baptais haigɨnɨuwam, ha? Mɨ Adi Komii krɨmiir Wanɨn siya wɨ kɨmiir nonkwonɨɨnwɨɨmwɨɨrnɨnkɨn tani ɨiya siya iikamɨm sɨmiir hɨdi, aniya? ");
INSERT INTO iws_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mɨ kɨma iikam whɨekakɨm sɨmiirɨn hɨnɨɨna dɨisiimauu, kɨmiir dimɨn biyɨeyɨm bɨdi haiyoprimdiyɨumiigiyɨm. ");
INSERT INTO iws_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kɨmiir kwoɨnɨn hɨnɨɨna kɨpi naɨngwo Ebrahamɨn krɨmiir brougaekɨn mɨ kɨma wɨ kɨgugu rani. Nɨɨngaka. Kara kɨmiirɨn yaimwowar boɨnki, Adi Komii siya siiyam sɨmiir mɨ tɨrki, Ebraham siir yɨnisɨsɨm nɨmbiyamam wɨ dɨgar mɨ owi. ");
INSERT INTO iws_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mɨ siir ua ɨni paimɨi hɨrar haigɨn taohaigɨna mɨ pae whɨekakɨm nae mɨiyɨk bud karamae nwowɨm, yɨm wɨ paenau sɨma nɨiyɨtkaigaigii. ");
INSERT INTO iws_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ta op ara kara baptais haigɨnɨuwa ya mɨn nɨsiimauuga kɨmiir dimɨn biyɨeyɨm bɨdi haiyoprimdiyɨumiigiyɨm. Mɨ inkamɨn kariir mhoɨiya nɨtɨn, kouwɨn ɨni siyar ywowɨn. Mɨ siya ɨni yaowae adnan ywowɨn mɨ an kara ɨni yɨnisɨmnan ywowɨn. Mɨ kara siir mɨisɨsɨmɨm wɨ sɨbgu ɨnomoknɨnkɨn mɨrii rani. Nɨɨngaka. Kara kɨmiirɨn op arar baptais haigɨnɨuwi mɨ Adi Komii siir naeyɨuɨn wɨ siya haɨnɨuae haigɨnɨuwi mɨ siir paeya nɨuyaeiya warar. Kara inkam mɨiyɨk rani, siir ɨga siya niiya saiir uridɨn wɨ kara waisi hak rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Mɨ Siya iikamɨm sɨmiirɨn wɨ inkamɨn twonidɨm twonau haigiyɨm sɨmiir hɨriinan hɨdi mɨ ha nokwobrombropiyɨn, ɨni siir hɨriinan ywowɨn. Mɨ ɨiya ɨkɨ twonid ɨmiir nikwobrombrop dɨgiiyɨm mɨ kasɨm pa kwuubrugiki. Mɨ twonid nɨɨngam pɨ sɨmasɨma namwokaiyɨuwi. Mɨ kas ɨmiirɨn pa nhɨsopkɨninaka mɨ sɨmiirɨn pɨ paeya nhɨsopkɨn namgɨnkii. Mɨ ta paeya wɨ nɨutɨɨngii rani. Nɨɨngaka. Saeya wɨ hɨriiyar nɨuyokiyokɨikaeyami. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mɨ taka ɨiya Jisɨs siya nu Galili hɨr haiburgigɨn mɨ ɨna yɨtɨn ɨe Jodan tɨriir. Jon siirɨm, siirɨn op siya baptais haigɨnɨuwɨm. ");
INSERT INTO iws_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Mɨ Jon siya Jisɨs siir kwoɨn ɨiir kisɨna haigigiyam tɨrkɨn mɨ siya ɨna boɨnɨn, Jisɨs, ambi kɨra baptais haigɨnɨuwi. Mɨ kɨra kariiram dimusi nɨtkɨn, ha? Kara inkam mɨiyɨk rani. ");
INSERT INTO iws_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mɨ Jisɨs siya siir yai anaka hɨnɨɨna yowarkɨi boɨn, kiya, panao kɨra pɨ ta kara boɨna yaiya pɨ saiir hɨriinanar tɨr. Ɨni ywokiyɨn krɨma swokɨ boɨnɨurwokaigiyɨn Adi Komii siir siyɨu mɨiyɨkɨn siya boɨnkiyɨn siirar wakaeyokna dirɨraerar. Mɨ Jon siya siir yai aiir asi wakaeyokna dirɨraerarkɨn. ");
INSERT INTO iws_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Mɨ siirɨn ha baptais haigɨnɨugiyɨn mɨ siya ɨna iyɨɨg apnaidamɨn op hɨrankar. Mɨ nɨnomora ɨna haiwaokiya omaka anonan siiram. Mɨ siya kɨgwɨn Adi Komii siir naeyɨuɨn ɨɨnmabnan siinanaiiniyɨn mɨ ɨni siir yaunɨ oniyɨn. ");
INSERT INTO iws_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Mɨ yai kwɨra nɨnomor kou hɨr kauwok boɨnkiya, saeya hɨnɨɨna kauwok boɨnkika, tɨriigɨnɨn yɨo kariirgɨ kariir yɨnisɨm ɨeya. Kariir kwoɨnɨn ɨni siirgɨ siiramar naɨngwo ɨskiyɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Mɨ taka ɨiya Jisɨs siya op baptaisa saiir mhoɨiya siirɨn Adi Komii siir naeyɨu ɨeya yɨkɨunam maeyau nu siiyɨn apa saiir hɨriir Setan siya kɨnankɨuwam. ");
INSERT INTO iws_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Mɨ ɨiyɨm mhɨirɨma siya mwowɨm nabɨeyɨm kamnwɨs mɨ nɨiyɨm ɨriipɨ hɨriinan kamnwɨs. Mɨ siya naemɨn dimɨn bɨ naekɨn mɨ mhoɨiya siya mhɨi komiiya ɨna yaowɨn. ");
INSERT INTO iws_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Mɨ Setan siya kɨnankɨuwan inkamɨn ha nɨtɨn Jisɨs siiram mɨ ɨna yaboɨniyɨn mɨ kɨra Adi Komii siir yɨnisɨmkɨn nɨuwi mɨ kɨra tɨ siiyam sɨmiir boɨnki mɨ sɨma pɨ bret nwokɨ ɨmbiyamɨm. ");
INSERT INTO iws_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mɨ Jisɨs siya siir yai aka hɨnɨɨna yowarkɨi boɨnki, Yokwo Komii saeya hɨnɨɨna boɨnka, inkamɨn kwoɨnbudɨn omwai sɨbgu waiyayokiyokɨiiyɨn naesi bɨ haiigɨn. Nɨɨngaka. Inkamkɨ sɨbgu haiiyɨn kwoɨnbudɨn ya Adi Komii krɨmiir Wanɨn siir hɨrankɨ nɨta yai mɨiyɨka sasarga. ");
INSERT INTO iws_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mɨ siya ha boɨn dɨgiyɨn mhoɨiya Setan siya siirɨn om komii Jerusalem hɨriir yɨkɨunam mɨ siirɨn omaka Adi Komii siira saiir akou yamɨ okmwɨn okwoki. ");
INSERT INTO iws_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Mɨ siya ɨna boɨnkiyɨn siirɨn, kɨra Adi Komii siir yɨnisɨmkɨ nɨuwi mɨpi waraur ankar tamɨ iswɨt natkiigi. Mɨ kɨra pɨ naonam tani. Dimusi rani, Yokwo Komii saeya hɨnɨɨna boɨnka, Adi Komii siya wɨ ɨgao yai siir paekwosɨm ɨmiir boɨnki kɨriir haiwɨnam. Mɨ kɨriir ɨga wɨ siiya mɨnkɨ haɨnwɨn tani. ");
INSERT INTO iws_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Mɨ Jisɨs siya siir yai akan hɨnɨɨna swokɨ owarkɨi boɨnki, kara pɨ hɨnɨɨna tɨr tani. Dimusi rani, Yokwo Komii saeya hɨnɨɨna swokɨ boɨnkika, kɨra kɨriir Bɨiyan Inkam Komiiyɨn siiram whɨsarii kɨpi kɨnankɨu siya kɨriir Adi Komiigɨn mɨ yaiya yaimwo karamaeya saiir kɨpi prɨi boɨn siya kariir whɨndirɨraeram. ");
INSERT INTO iws_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Siya ha boɨn dɨgiyɨn mɨ Setan siya Jisɨs siirɨn kɨmɨdiniya mhɨu komii whɨrɨn siir mhɨu kɨugɨ kɨua hɨriir yɨkɨunam. Mɨ siya siirɨn ɨna yɨisiimauuyokiyokɨigiyɨn nupai nupaiyɨm hɨnda tɨndanɨm tɨ nu ɨiir nwowɨm sɨmiirɨn mɨ dimɨn mɨiyɨk mɨiyɨk ɨkɨm siya tɨ digworaekwo ɨmiir ha nɨisiisimauu dɨgiyɨn, ");
INSERT INTO iws_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Mɨ siya ɨna boɨnkiyɨn mɨ kɨra pɨ ogmwo kariiram waisi hɨuwi mɨ kariir inɨg ɨiir hainani mɨ tɨ digworaekwowɨm kɨra kɨgɨm kara wɨ kɨriirarar hauuswoki kɨra kɨgrɨraowɨm. ");
INSERT INTO iws_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Mɨ Jisɨs siya siir yai akan hɨnɨɨna yowarkɨi boɨn, Setan, damki! Yokwo Komii saeya hɨnɨɨna boɨnka, Bɨiyan Inkam Komiiyɨn siir inɨg ɨiirara hainan ɨski, siya kɨriir Adi Komiigɨn mɨ kɨra siir mɨi aiirar donkworɨnu krɨpkai. ");
INSERT INTO iws_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Mɨ siya ha boɨn dɨgiyɨn, setan siya siirɨn ha haiburgigɨn mɨ ɨna yamɨn mɨ Adi Komii siir paekwosɨmɨm ha nɨtɨm, siirɨn kɨmɨdiniya sɨma yaunɨ whɨnkɨnsiisni. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Mɨ mhoɨiya Jisɨs siya hɨnɨɨna wakaewɨn sɨma Jon siirɨn omaka hɨuyokiyokaiya mɨi biyɨe mɨriiya saiir bɨdi hɨugrɨpkɨikikaiyɨn. Dimusi rani, siya ɨgao yai Inkam Komii Herot siir boɨnkɨn. Mɨ siya tɨ om ɨiir haiburgik mɨ nu Galili hɨriir yam. ");
INSERT INTO iws_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Mɨ siya om Nasaret hɨr bɨ sɨbgu owɨpɨsuwikɨn mɨ siya om Nasaret siir haiburgikɨn mɨ siya kɨmɨdiniya om Kapaneam hɨr inɨ owou. Tɨ omɨn whɨi Galili whɨigbida waiyɨn, tɨ iikamɨm Sebyulan Naptalai sowiir isidɨn sɨma nwowa maeyau saiir hɨr ");
INSERT INTO iws_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jisɨs siya ha nɨtɨn ta maeyau aiir mɨ ɨni dɨga ywokiya yai bɨiya Bɨiyan Inkam Komiiyɨn siya boɨnkiya profet Aisaiani mɨ siya boɨnkiya ya saiir swokɨ boɨnɨurwokaigika. Ta yaiya siya wɨnkiya saeya hɨnɨɨnga, ");
INSERT INTO iws_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","mɨ nu Sebyulan mɨ nu Naptalai sowiir hɨran siyɨuɨn whɨi komii Solwara namɨn mɨ ɨna yɨuguskiyɨn ɨe Jodan ɨegbid mɨrmiiya mɨ nu Galili Juda iikam tani mɨ Juda iikam nhɨrɨm hɨr nwowɨm sɨmiir hɨriir yam. ");
INSERT INTO iws_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mɨ iikamɨm tɨ maeyau owiir nwowɨm nɨibwomambwonan mɨ tariinanɨn sɨma nokiya dimɨn komii siir bɨdi haiyɨm mɨ tɨ hɨran iikamɨm dimɨn biyɨe tɨrɨm ɨni hapi inkam wɨɨrnan ywowɨm mɨ tariinanɨn bɨenan sɨmiir bɨdi yokiyakiyɨm. ");
INSERT INTO iws_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mɨ taka ɨiya Jisɨs siya nu Galili hɨr nwowɨn siya yaiya saiir boɨnmɨmauu bwakainakɨn. Siya hɨnɨɨna boɨn, kɨmiir dimɨn biyɨe biyɨeyɨm sɨmiirɨn tɨ haiyoprimdiyɨumiigi. Dimusi rani, ɨiya Adi Komii siya siir digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana ɨni kingiin nwowa. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Mɨ ɨiya Jisɨs siya Galili whɨigbid whɨigbida hɨriir nouapamɨn mɨ siya iwɨnyaowo anasu mɨi mɨriiyo sowiir yao youap kɨgam Saimon mɨ siir inɨg whɨrɨn wɨ Pita dapi mɨ siir nomousɨm ɨeya Endru, yo sowa yaowɨn haɨmna nɨtmaigo whɨi hɨr. Mɨ ta anasu haii mɨiya ya sowiir yao umɨr mɨiga. ");
INSERT INTO iws_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Mɨ Jisɨs siya sowiir yao boɨnki, bɨiya kowa anasu mɨi mɨriiko mɨ tariinanɨn kowa kanakar wɨt mɨ kowiirɨn wɨ kara nɨisiimauuwi siyɨuɨn iikamɨm sɨm mhɨi kwoɨnɨm sɨm nɨnkpɨt haigiyɨm mɨ sɨm nanmaiwarkainaeiyɨn. ");
INSERT INTO iws_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Mɨ bɨri kɨmɨmɨnkikɨn, sowiir haɨmnan ɨni hɨrar kwomaimiigiyɨn mɨ sowa ɨni siir mhoɨiya yamwo. ");
INSERT INTO iws_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mɨ siya ha swokɨ kwapnamɨn mɨ ɨni iwɨnyao nwɨswo sowiirar swokɨ kwakɨgo, Jems Jon sowiirar, Sebedini yɨnisɨm nwɨswo. Yo sowa i hɨrar nɨdwokaii sowiir adɨn Sebedi saɨkar. Yɨm sɨmaniyɨn sɨmiirni haɨmna ɨiir mɨ kisɨsok dirɨraerari. Mɨ sowiirɨn kɨmɨdiniya Jisɨs siya yɨkɨuna. ");
INSERT INTO iws_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Mɨ sowa bɨ kɨmɨmɨnkiko, sowiir adɨn siirɨn ɨni i hɨrar kwaewɨsrimiigigo mɨ sowa ɨni Jisɨs siir mhoɨiyar yamwo. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisɨs siya nu Galili siirar yapyokɨi ɨrkak. Mɨ siya iikam ɨmiirɨn Juda sɨmiir maeyauwa yaimɨn dimɨn nɨdwokai wakaeiyɨm sɨmiir hɨr yomwɨmwarkaiyɨu mɨ siya yai wɨn kɨrɨe kɨbiya saiirɨn ɨiya Adi Komii siya siir digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana saiir warar mɨ boɨnmɨmauu. Mɨ siya iikamɨm mapai mapaigɨ niiyɨm sɨmiirɨn warar mɨ haiswonɨmnɨskɨiyam. ");
INSERT INTO iws_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Mɨ siir yaiya ɨna yɨnyokɨigiya nu Siria siirar. Mɨ sɨma sɨmiir iikamɨm mapai mapaigɨ niiyɨm mɨ yɨu bibiyɨekɨ nii whwonkaiyɨm mɨ iikamɨm whaowa pɨugɨ nwo ɨkɨm mɨ iikamɨm ɨga ɨɨnɨm nɨnsɨmsɨrɨunakaeyamɨm siya sɨmiir yɨnɨmnɨskiswo. ");
INSERT INTO iws_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mɨ iikam whɨe komiiya nu Galiliyankɨn nɨtɨm mɨ omisɨsɨm nhɨrɨm maeyau Dekapolis hɨranɨm sɨmiir hɨrankɨ nɨt ɨkɨm mɨ om komii Jerusalemankɨ nɨt ɨkɨm mɨ om nhɨrɨm nu Judiankɨ nɨt ɨkɨm mɨ ɨe Jodan siir kingiin hɨndankɨ mɨ ɨt ɨkɨm sɨma ɨni siir mhoɨiyar yamɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Mɨ Jisɨs siya iikam whɨe komii sɨmiir kɨgɨn siir mhoɨiya namɨm mɨ siya kɨmɨdiniya mhɨu whɨrɨn siir hɨriir iiyam. Mɨ siya hɨr ha ninɨ ii ɨdwo ɨuwɨn mɨ kamɨm siir kɨgna mɨriiyɨm ɨna yɨtɨn siirɨm saɨka nɨdwowɨm. ");
INSERT INTO iws_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Sɨma hɨrar nɨdwowɨm mɨ Jisɨs siya sɨmiirɨn hɨnɨɨna yowɨmwarkaiyɨu. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Mɨ iikamɨm ha naɨngwowɨm sɨma Adi Komii siirɨmɨn mɨigakɨm mɨ maɨrgɨmaɨrga wadɨeyar nwowi. Dimusi rani, sɨmiirɨn Adi Komii siyar kɨgrɨraowi. ");
INSERT INTO iws_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mɨ iikamɨm nɨnounɨnki kaeyamɨm mɨ wadɨe nwowɨm mɨ wɨ maɨrgɨmaɨrga whɨsarii nwo rani, sɨmiirɨn wɨ op Adi Komii siyar hauukwiyae haigɨnɨuwi. ");
INSERT INTO iws_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mɨ iikamɨm yai mɨn nɨnkisɨmsɨo boɨn karam nwowiyɨm mɨ sɨmama naɨngwona karam nwowiyɨm, yɨm sɨma wadɨeya dwo mɨ ha maɨrgɨmaɨrga. Dimusi rani, sɨmiirɨn wɨ Adi Komii siyar hauuwi nuɨn. ");
INSERT INTO iws_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Yɨpɨkɨ iikamkɨm mhɨigɨ naoni hɨnɨɨn Adi Komii siir yai aiir wakaeyoknamɨn wadɨeyar dwo. Sɨma ha sɨbgu maɨrgɨmaɨrga. Dimusi rani, siya wɨ sɨmiir whɨndirɨraerari wɨ wadɨeyar nwowi mɨ wɨ siir mhoɨiyar nami. ");
INSERT INTO iws_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Iikamɨm, iikam nhɨrmisi naɨngwobumbuwiyɨm sɨma wadɨeyar dwo mɨ ha maɨrgɨmaɨrga. Dimusi rani, Adi Komii siya wɨ sɨmiirsiyar mɨ ɨnkɨn aɨngwobumbuwi. ");
INSERT INTO iws_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mɨ iikamɨm mhɨi kwoɨnɨm rɨrmiya nwowiyɨm sɨma wadɨeya dwo mɨ sɨma ha maɨrgɨmaɨrga. Dimusi rani, sɨma wɨ Adi Komii saɨkar nwowi. ");
INSERT INTO iws_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mɨ kamɨm yaii mɨn nɨnii nansaowi siyɨuɨn siir mɨnwokmaiyɨm ɨrɨpa nongwomamaɨr aeyam sɨma wadɨeya dwo mɨ ha maɨrgɨmaɨrga. Dimusi rani, mhoɨiya Adi Komii siya wa boɨni, sɨma kariir yɨnisɨmkɨm. ");
INSERT INTO iws_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mɨ iikamɨm Adi Komii siir yaiya saiir wakaeyoknam hɨk saiirsi haii sɨma wadɨeya timɨ o mɨ ha maɨrgɨmaɨrga. Whɨsarii rani, ɨiya Adi Komii siya siir digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana, ya sɨmiir wararga. ");
INSERT INTO iws_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Mɨ sɨma kɨmiirɨn ha kɨgii, kɨma ɨni kariir siyɨu ɨiir napɨm mɨ ɨni kɨmiir tɨoɨm mɨ ɨni yai bibiyɨe kɨmiir kinaop ɨtkaigaiyɨuɨm mɨ kɨmiirɨn wɨ sɨma nɨksɨsaei. Mɨ kɨma wadɨeya sɨbgu ɨdwowi mɨ wa maɨrgɨmaɨrgaei. ");
INSERT INTO iws_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mɨ bɨiya sɨma profet inkamɨm sɨmiirɨn hɨriinanar mɨ tɨonanaekɨm. Kɨma ɨrɨpar dɨngwomamaɨr ae. Dimusi rani, mhoɨiya tɨ digworaekwo mɨiyɨk mɨiyɨkɨm nɨnomor kou hɨr nwokwokɨnɨm yɨm kɨmiirgɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Wɨm kɨma iikamɨm sɨmiir whwonkam ɨdan ɨni wa nan ywowɨm iikamɨm sɨmiir whɨnkɨnsiisɨm. Mɨ wa siir hiiya saeya dɨgiiyɨm mɨ wɨ panɨɨna swokɨ tɨri siir hiiya saiir swokɨ haiyɨm? Nɨɨngaka. Tɨkɨ hɨnɨɨn waɨn yɨo mɨi karamaekɨn. Mɨ sɨma siirɨn pɨ hindara kabɨtkaigi ɨski mɨ ɨga wɨ siirar nɨnkɨn okwowi. ");
INSERT INTO iws_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Wɨm kɨma ɨni nu tɨran pae nɨuyanan ywowɨm. Mɨ kɨma siyɨu mɨiyɨk napiyɨn iikamɨm sɨmiir nɨisiimauuwi kɨma om komiiyɨn mhɨu kɨugɨkɨu nwowiyɨn siir hɨriinan ywowɨm yɨo bɨ swokɨ kimɨrkaiigɨn. Nɨɨngaka. Iikamɨm arugɨ aruwanɨm sɨma wa kɨgi. ");
INSERT INTO iws_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Inkamɨn yɨukɨd hangɨmuwiiyɨn, siya siirɨn twoni bɨ higrɨnɨu haigɨnikɨn. Nɨɨngaka. Siya siirɨn pɨ romiyasni ninankɨi mɨ iikamɨm ta omaka aiir nwowɨm, sɨmiirɨn pɨ siyar nɨuya ɨrkaki. ");
INSERT INTO iws_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mɨ ɨriipɨ hɨriinan kɨmiir siyɨuɨn iikamɨm sɨmiir whwonkam ɨdan paenan timɨ ɨuya ɨrkak. Mɨ sɨma siyɨu mɨiyɨkɨn kɨma tɨriyɨn siir kɨgii mɨ sɨma wɨ kɨmiir Adi Komiiyɨn nɨnomor kouanɨn wɨ siir inɨg ɨiir nwokɨ hainan praprasɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Kɨma ha kɨpi naɨngwo kara Moses siir siyɨu komiiyɨn mɨ profet kamɨm sɨm yai ɨkɨm, sɨmiir kɨɨndiyɨmdiyɨuwam nɨtkɨn. Nɨɨngaka. Kara sɨmiir kɨɨndiyɨuwam bɨ nɨtkɨn. Kara ɨdwo sɨmiir swokɨ ɨnkɨn boɨnourwokaiyam nɨtkɨn. ");
INSERT INTO iws_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kara kɨmiirɨn yaimwowar boɨni, tɨ siyɨu komiiyɨn Moses siirɨn mɨ profet sɨmiir yaisɨsɨmɨm mɨ sowiir dimɨnsɨsɨmɨm hɨumamakɨuwɨm mɨ kiyɨprɨmprɨnɨuwɨm wɨ wara dɨg rani. Nɨɨngaka. Nɨnomor nu sowa wa dɨgii mɨ tɨ Moses siir siyɨu komiiyɨn siir siyɨupai siyɨupaiyɨm mɨ siir yaipai yaipaiyɨm, yɨm wa nɨmbini. ");
INSERT INTO iws_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mɨ inkam nwɨrkɨ Moses siir siyɨu komii siir dimɨnsɨm whɨr nɨinɨkrɨpi mɨ profet kamɨm sɨmiir ɨkɨm mɨ siya iikam ɨmiirɨn hɨriinan siyɨu ɨiirar swokɨ owomwarkaiyɨuwi mɨ tɨ hɨriinan inkamɨn siya wɨ inɨgak nwo rani. Nɨɨngaka. Ɨiya Adi Komii siya siir digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana saiirɨn. Mɨ inkamɨn Moses siir siyɨu komii siir siyɨumwokɨ siyɨumwowɨn mɨ profet kam ɨkɨm sowiir sɨbgu api mɨ iikam ɨmiirɨn hɨriinanar swokɨ owomwarkaiyɨuwi mɨ siya wɨ inɨg komiigaka nwowi ɨiya Adi Komii siya siir digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana. ");
INSERT INTO iws_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mɨ hɨriinankɨnɨuwi kara kɨmiirɨn yaimwowar boɨnkii mɨ kɨmiir siyɨu mɨiyɨkɨn tɨ kamɨm siyɨu komii nɨnoknɨnkɨniyɨm mɨ Farisi sɨmiir siyɨu ɨiirɨn haibur karamae nwowi, ɨiya Adi Komii siya siir digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana saiirɨn kɨma wɨ wara nwo rani. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Kɨma bɨdi wakaeyɨm Adi Komii siir yaiyɨm, bɨiya Moses siya wɨn boɨngikɨm, saeya hɨnɨɨna boɨnka, kɨra inkam kɨpi nɨsomao mɨ inkam nwɨrɨn inkam nwɨrni nɨsomaowi mɨ siya wɨ yaigak nwowi. ");
INSERT INTO iws_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mɨ kara yai kwɨra pɨ saiir warar nɨnkɨn boɨnki mɨ inkamɨn siir nomiiyauɨn ɨo siir nwowi mɨ tɨ inkamɨn wɨ yaigak nwowi mɨ inkamɨn nwɨrɨn siir nomiiyau ɨiir nɨgbumbuwi mɨ tɨ inkamɨn siya wɨ yaigak nwowi kaunselmi bɨiyan kamɨm sɨmakaɨn. Mɨ inkamɨn hɨnɨɨna boɨni kɨra hab whaowaekɨn mɨ tɨ inkamɨn siirɨn sɨma wɨ paeya nɨkropki. ");
INSERT INTO iws_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Mɨ kɨra dimɨnɨm Adi Komii krɨmiir Wanɨn siir prɨihauuanɨm siir hɨiya saiir kingiin ninɨ haigɨngigi mɨ kɨra ha naɨngwowarkaigi kɨriir nomiiyauɨn siya kɨnaka ɨokakɨnɨuwi, whɨsarii rani, dimɨnɨn kɨrar tɨrkɨn siirɨn siya kɨriirɨn ɨo asi nwokɨn. ");
INSERT INTO iws_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Mɨ kɨra dimɨnɨm kɨra prɨihauuam tɨrɨm Adi Komii siir, yɨm siir hɨiya saiir kingiina tikɨnɨ haigɨngig. Mɨ kɨra ha tikɨ am, kɨriir nomiiyauwɨn ɨo kɨnaka nwowɨn siiram yai saɨka ninɨ kisɨsop boɨnɨuwam. Mɨ kɨra saɨka ninɨ kisɨsop boɨngigi, ɨrɨpa nongwomamaɨr aeyam mɨ kɨra wɨ haɨni swokɨ am mɨ kɨriir dimɨnɨm kɨra prɨihauuwam tɨrɨm Adi Komii siir mɨ siirɨn haɨni tinɨ hauuɨu. ");
INSERT INTO iws_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mɨ inkam nwɨrɨn kɨriirɨn inkam komiiyɨn yai hɨdiyɨn yai saɨka boɨnam tɨri, ɨiya kowa siyɨu hɨrar nikɨ apamiya saiirɨn mɨ kɨra kɨpi kɨmɨmɨn, saɨka yai ha kisɨsop boɨnsasaugi ɨrɨpa nongwomamaɨr aeyamɨn. Ni wɨ tɨ inkamɨn si pɨ boɨnmauugiyɨuwisi inkamɨn yai hɨdiyɨn si mɨ yɨo wɨ polismi ɨɨn hauugi, sɨma ninɨ hɨugrɨpkɨikikaigikɨm maeyauwa hɨuyokiyokaiya mɨi biyɨe mɨriiya saiir. ");
INSERT INTO iws_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kara kɨriirɨn yaimwowar boɨni mɨ kɨra ta kɨriir hɨk saiir umɨr ɨiir saɨnsɨsau karamae nwowi mɨ ni kɨra omaka hɨuyokiyokaiya mɨi biyɨe mɨriiya saiir hɨrankɨ wɨ aisiima nikɨ haiburgig rani. Nɨɨngaka. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Kɨma bɨdiya ikɨ wakaeyɨm yaiyɨm bɨiya Adi Komii siya boɨnkiyɨm Mosesni siyɨuɨm sɨm, siya hɨnɨɨna boɨnkikɨn, kɨra nonkwonani siyɨuɨn siir kɨpi tɨrbu. ");
INSERT INTO iws_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mɨ kara kɨmiirɨn pɨ yai kwɨra saiir warar nɨnkɨn boɨnki. Inkamɨn siya nhwo ara kɨgɨkɨigi wig ɨramɨn mɨ tɨkɨ hɨriinan inkamɨn siir kwoɨnɨn yɨo nonkwonani siyɨuɨn siir bɨdi tɨrbuɨn. ");
INSERT INTO iws_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Mɨ kɨriir ɨɨnigan nhwonaɨn kɨriirɨn siya nɨpiyaokɨinami siyɨu biyɨe tɨram mɨ kɨra siirɨn habɨtkɨigi. Yɨo mɨiyɨk rani, kɨriir pɨu haɨmiya saeya mɨ kɨguguwi mɨ ɨriipɨ hɨriinan yɨo mɨiyɨkɨ mɨiyɨk rani, kɨriir pɨu ɨrkaka saiirɨn paeya nɨtkaigi. ");
INSERT INTO iws_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Mɨ kɨriir ɨɨna ɨɨniga kɨriirɨn saeya kiyapiyaokɨinami siyɨu biyɨe tɨram mɨ saiirɨn kaigrɨp ɨtkaigi. Yɨo mɨiyɨk rani, kɨriir pɨu haɨmiya saeya mɨ kɨguguwi, ɨriipɨ hɨriinan mɨiyɨkɨ mɨiyɨk rani, kɨriir pɨu ɨrkaka saiirɨn paeya nɨtkaigi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Bɨiya Moses siya hɨnɨɨna wɨn boɨnkikɨn mɨ inkam nwɨrɨn siya siir wig aiir sopkiyam naɨngwowi mɨ siya saiir sopkiyamɨn yokwo wɨtisɨm kwɨra wɨn hauugi. ");
INSERT INTO iws_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mɨ kara yai kwɨra kɨmiirɨn pɨ warar nɨnkɨn boɨnkii, inkamɨn siir wiga aiir sopkii mɨ siir wig saeya hɨi bɨ nanaemɨmɨnka. Tɨ inkamɨn siya tɨrbugikɨn ta wig aiirɨn ɨiya saeya kam nwɨr ninɨ onkwonaɨuwa mɨ saeya hɨi asi nanaeka. Tɨ mhoɨiyan kamɨn saeya swokɨnɨ owɨuwɨn siya ɨriipɨ hɨriinan sowawaiyɨn hɨi asi nanaeko, tɨ hɨriinan siyɨuɨn yɨo bɨiyan kam ɨeyar tɨrbugikɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Mɨ yai nhɨrɨm bɨiya brougae Moses siya wɨnɨm yokwoni Adi Komii siir hɨrankɨn, siya hɨnɨɨna boɨnkikɨn, ɨiya kɨra Adi Komii siir inɨgɨn siir nɨkopaisɨsɨri mɨ kɨra kɨpi nɨkopaisasae. ");
INSERT INTO iws_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mɨ kara yai kwɨra kɨmiirɨn pɨ warar nɨnkɨn boɨnkii, kɨma dimɨn nhɨrɨm nɨmbinam tɨriiyɨm mɨ mhoɨiya kɨpi swokɨ ɨkopaisɨsɨr. Nɨɨngaka. Mɨ kɨma nɨnomor saiirɨn whɨsarii kɨpi nɨkopwaisɨsɨr. Whɨsarii rani, nɨnomora ya Adi Komii siir maeyauga. ");
INSERT INTO iws_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mɨ kɨma dimɨn whɨram nɨmbiniyɨm nu ɨiirɨn whɨsarii kɨpi nɨkopwaisɨsɨr. Dimusi rani, nuɨn yɨo Adi Komii siir ɨga aiir nokwosiisika. Mɨ om komii Jerusalemɨn ɨriipɨ hɨriinan kɨpi mɨ tɨr. Dimusi rani, yɨo Inkam Komiiyɨn Adi Komii siya nu kɨgrɨraowiyɨn, yɨo siir om komiigɨn. ");
INSERT INTO iws_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mɨ kɨra kɨriir mwoɨn siir kɨpi dapboɨn ɨkopaisɨsɨr dimɨn whɨram nɨmbiniyɨm. Nɨɨngaka. Dimusi rani, kɨra kɨriir kana saiir kanmai whɨr tɨrɨm wɨ dɨg nwo rani, whɨsinan yhɨuwinan nwowamɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ɨiya kɨma iikamɨm sɨmiirɨn dimɨn mɨni, kɨma hɨnɨɨna boɨn, ɨhɨ kara wa tɨri, iyɨe? Kara wɨ tɨr tani. Tɨ siyɨu hɨnɨɨnɨn yɨo wadɨekɨn mɨ kɨra yaeya yai kwɨr swokɨ boɨni ya saeya Setan siir yaiga. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Kɨma bɨdi wakaeyɨm bɨiya Adi Komii siir yaiyɨm Moses siya hɨnɨɨna wɨn boɨnkɨm, inkam nwɨrkɨ kɨriir nhwo ɨiir mɨntɨbugii mɨ ni kɨra siir nhwoɨn yamdiyar tɨ swokɨ hoprɨpugi. Mɨ inkam nwɨrkɨ kɨriir bigmɨu ɨiir nɨnouhai mɨ kɨra siir bigmɨuwɨn wɨ yamdiyar tɨ swokɨ ɨnouhai. ");
INSERT INTO iws_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mɨ kara kɨmiirɨn yai kwɨra pɨ warar mɨ ɨnkɨn boɨnkii, kɨma iikamɨm kɨmiir tɨrbumbuwiyɨm sɨmiirɨn yamdi kɨpi swokɨ tɨrbu. Nɨɨngaka. Mɨ kɨmiir yaeka inkam nwɨrkɨ tɨokii mɨ kɨra yaeka yarmi kwɨra ha tɨ swokɨ ɨnkpɨt okwoki, siya swokɨ ɨnkɨn tɨokiyam. ");
INSERT INTO iws_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mɨ inkam nwɨrkɨ kɨriirɨn inkam komii yai hɨdiyɨn saɨka boɨni kɨriir yɨuɨsa kou ana saiir haiyam mɨni mɨ kɨra siirɨn yɨuɨs prɨeiya pɨu ɨrkak aiirar nii ɨrkakiya warar dɨnkɨn hauugi. ");
INSERT INTO iws_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mɨ inkam komii nwɨrkɨ kɨriir boɨni kingiin niimau siir digworaekwo ɨmiir hainamɨm mɨ kɨra saɨka ha tɨ swokɨ haɨnɨs apnam arurɨg mɨ kɨra maɨrgɨmaɨrga dwonam. ");
INSERT INTO iws_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mɨ inkam nwɨrkɨ kɨriiram srɨii dimɨn whɨr siir hauuam mɨ kɨra siirɨn ha hauugi. Mɨ inkam nwɨrkɨ kɨriir waraurankɨn prɨihainami dimɨn whɨr mɨ siirɨn ha prɨi hauugi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Kɨma bɨdiyar ikɨ wakaeyɨm yaiya bɨiya kam nhɨrɨm sɨma boɨnkiya saeya hɨnɨɨna boɨnka, kɨma kɨmiir nomiiyauwɨm sɨmiiram daɨngwo mɨ kɨma ɨo kɨmiir sau omomɨm sɨmiir dwo. ");
INSERT INTO iws_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mɨ kara yai kwɨra kɨmiirɨn pɨ warar nɨnkɨn boɨnkii, kɨma kɨmiir sau omomɨn siirsi daɨngwobuna mɨ iikamɨm kɨmiir tɨrbumbu nɨnkɨn haigɨnɨuwiyɨm kɨma Adi Komii siiramɨn sɨmiiram kwɨsboɨnki sɨmiir whɨnkɨnsiis haigɨnɨuwam. ");
INSERT INTO iws_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mɨ kɨma tɨ hɨriinan siyɨuɨn siir tɨri mɨ kɨma wɨ kɨmiir Adi Komiiyɨn nɨnomor kouanɨn wɨ siir yɨnisɨm nwowi. Mɨ siya bɨeyɨn wɨ siir tɨrki, iikam biyɨe biyɨeyɨm mɨ iikam wadɨe wadɨe ɨkɨm sɨmiir koua nɨuyaɨm. Mɨ siya nao pa mɨ tɨrkii, iikam biyɨe biyɨeyɨm mɨ iikam mɨiyɨk mɨiyɨk ɨkɨm sɨmiiramɨn. Mɨ hɨriinanɨn kɨma iikam whɨekakɨm sɨmiirɨm daɨngwokwonanaei. ");
INSERT INTO iws_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mɨ kɨma iikam kɨmiiram naɨngwowiyɨm sɨmiiramar timɨ naɨngwo. Mɨ kɨma wɨ pɨkɨ hɨnɨɨn dimɨnɨn siir haii? Nɨɨngaka. Adi Komii siya kɨmiirɨn wɨ dimɨn whɨr hauu rani, yɨo tɨ hɨriinanɨn dimɨn komii rani. Mɨ kam biyɨeyɨm omom omomi umɨr haiiyɨm yɨm ɨriipɨ hɨriinanar mɨ tɨrikɨm kamɨm sɨmiiram naɨngwowiyɨm. Tɨ hɨriinan dimɨnɨn yɨo dimɨn komii rani. ");
INSERT INTO iws_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mɨ kɨma kɨmiir nomiiyauwɨm sɨmiiraramar hɨnɨɨna boɨni, akamɨe mɨ kɨma wɨ dimu dimɨn haii? Adi Komii siya wɨ dimɨn whɨr swokɨ hauu rani. Nɨɨngaka. Yɨo tɨ hɨriinanɨn yɨo dimɨn komii rani. Iikamɨm naɨngwo tɨbmii karamaeyɨm sɨma hɨriiyar mɨ tɨrikɨm, yɨo dimɨn komii rani. ");
INSERT INTO iws_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kɨma sɨbgu dwowɨpɨsu iikamɨm sɨmiir whwonkam ɨdan, kɨmiir Adi Komiiyɨn nɨnomor kou hɨranɨn siya sɨbgu owɨpɨsuwiya saiir hɨriinan. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Kɨma sɨbgu mɨntarao, kɨma ha kɨpi naɨngwo kɨmiir inɨg ɨmiir hainanɨm mɨ kɨma mɨi mɨiyɨk mɨiyɨkɨm Adi Komii siirɨm, iikamɨm sɨmiir whwonkam ɨda nɨisiimauɨm sɨma nwokɨ kɨgɨm. Nɨɨngaka. Mɨ kɨma hɨriinan tɨri mɨ kɨma wɨ kɨmiir Adi Komiiyɨn nɨnomor kouanɨn, wɨ siir digworaekwowɨm sɨmiir hai rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Mɨ hɨriinankɨ nɨuwi kɨra iikam paeprikabɨm umɨr digworaekwo sɨmiir hauuwi, kɨra kamɨm kɨd masiyɨm bɨi sɨmiir kɨpi nɨkropki kɨmiir bɨi namkwokɨnamɨn, tɨ kamɨm nɨksɨsaeiyɨm sɨmiir hɨriinan mɨ ɨiya sɨma dimɨnɨm paeprikab iikamɨm sɨmiir hauuwiyɨm ɨkɨ siyɨuɨm sɨm sɨma hɨriinan mɨnam tɨri iikamɨm sɨma nwokɨ hainanɨm sɨmiir inɨg ɨmiir. Kara kɨmiirɨn yaimwowar boɨnki sɨmiir dimɨnɨm, yɨm sɨma bɨdi haigiyɨm mɨ Mhoɨiya Adi Komii siya sɨmiirɨn wɨ dimɨn whɨr swokɨ hauu rani. ");
INSERT INTO iws_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mɨ kɨra iikam paeprikabɨm sɨmiir whɨnkɨnsiis haigɨnɨuwi mɨ kɨma digworaekwowɨm wɨ iikam nhɨrɨm sɨmiir whwonkam ɨda kɨpi hauu o iikam nhɨrɨm sɨmiir kɨpi boɨnmauu. ");
INSERT INTO iws_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kɨra hindara haigiprakai hauu mɨ mhoɨiya kɨriir Adi Komiiyɨn siya kɨgi kɨra siyɨu mɨiyɨk tɨrɨn mɨ siya wɨ dimɨn mɨiyɨk mɨiyɨk ɨmiirar mɨ hauugi mɨiya kɨra mɨriiya saiirsiyɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Mɨ ɨiya kɨma nhwo kwɨsboɨniyɨm, kɨra ɨkɨ kamɨm nɨksɨsaeiyɨm sɨmiir hɨriinan kɨpi tɨr, yɨm sɨmiir kwoɨnɨm mɨnaramar naɨngwowikɨm nhwo ɨkɨ omakaɨm yaimɨn dimɨn nɨdwokai wakaeiyɨm mɨ ɨkɨ siyɨu komiiyɨm sɨm siyɨumɨg siyɨumɨgɨm sɨm kwɨsboɨnamɨm ɨkɨ iikam sɨmiir whwonkam ɨda mɨ sɨma sɨmiir inɨg nwokɨ hainanɨm. Kara kɨmiirɨn yaimwowar boɨnkii. Yɨm sɨmiir dimɨnɨm bɨdiyar haiyɨm bɨiyar. Mɨ Mhoɨiya Adi Komii siya sɨmiirɨn wɨ dimɨn whɨr hauu rani. ");
INSERT INTO iws_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mɨ kɨma nhwo kwɨsboɨnam mɨni kɨmiir Adi Komii ɨiirɨm, kɨra kɨriir yapa maeyau krakra damwowɨu, pɨ inkamkɨ kɨg karamae kɨmiir ywo mɨ mhoɨiya kɨmiir Adi Komiiyɨn inkamkɨ kɨgmɨmɨn karamae nwowɨn mɨ ta maeyau krakra aiirɨn wɨ siya siyar kɨgi. Mɨ siya kɨriirɨn wɨ siyɨu mɨiyɨk ɨiirar nɨisiimauuwi. ");
INSERT INTO iws_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Mɨ ɨiya kɨra nhwo kwɨsboɨniyɨm mɨ yai nhɨrɨm kɨriir kwoɨnaɨrgar kɨpi naɨngwo kiyaiyokiyokɨiyam, iikam biyɨeyɨm naɨngwo tɨbmii karamaeyɨm sɨmiir hɨriinan. Nɨɨngaka. Sɨma hɨnɨɨna naɨngwokɨm tɨkɨ yai prɨe prɨeiyɨm sɨma kwɨsboɨniyɨm mɨ sɨmiir uruwai siyaowaiyɨm sɨmiirɨn pa wakaei. ");
INSERT INTO iws_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kɨma sɨmiir siyɨu ɨiir kɨpi nap. Whɨsarii rani mɨ ɨiya kɨma siiram nikɨ srɨiboɨn karamaeyar nikɨ owiyɨm mɨ kɨmiir Adi Komiiyɨn siya bɨdiyar yonkwokikaiwɨnɨn, dimɨnɨn kɨma haɨnguguɨn siirɨn. ");
INSERT INTO iws_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ɨiya kɨma nhwo kwɨsboɨniyɨm kɨma hɨnɨɨna kwɨsboɨn, krɨmiir Adi Komiiyɨn nɨnomor kouanɨn: krɨma kɨriiram kwɨs boɨni kɨriir inɨgɨn siirɨn dimɨn whɨrkɨ bɨ kɨbukɨn. ");
INSERT INTO iws_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ɨiya kɨra digworaekwo whɨekakɨm sɨmiir kɨgɨrkakan aeya wɨtsɨsau, mɨ krɨma nu tɨrɨn, warɨ nɨnomor kouanɨm Adi Komii siir paekwosɨmɨm sɨma mɨ wakaeyokna dirɨraerariyɨm sɨmiir hɨriinan mɨ wakaeyokna dirɨraeraram tɨri. ");
INSERT INTO iws_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kɨra panaowɨn krɨmiirɨn naeyɨm pɨ taka ɨiya saiir naeyɨriya whaugi. ");
INSERT INTO iws_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kɨra krɨmiir dimɨn biyɨe biyɨeyɨm sɨmiir haiyoprimdiyɨumiigi, iikamɨm krɨmiir tɨrbuɨm krɨma haiyoprimdiyɨumiigiyɨm sɨmiir hɨriinan. ");
INSERT INTO iws_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mɨ kɨra dimɨn biyɨeyɨm krɨmiirɨm kɨpi kɨgnɨnkɨnki krɨmiir kɨnankɨuwam mɨ kɨra krɨmiirɨn yɨu biyɨemi bɨiyan inkam komiiyɨn siirsi tɨ haiyapyok haigɨnɨu! ");
INSERT INTO iws_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Wakae mɨ kɨma iikamɨm dimɨn biyɨe kɨmiir tɨrbumbu haigɨnɨuwɨm, sɨmiir dimɨn biyɨe ɨmiir haiyoprimdiyɨumiigi mɨ kɨmiir Adi Komiiyɨn nɨnomor kouanɨn, kɨmiirɨn wɨ hɨriiyar mɨ tɨri. ");
INSERT INTO iws_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mɨ kɨma iikam nhɨrmi dimɨn biyɨeyɨm sɨmiir haiyoprimdiyɨumiigi karamae nwowi mɨ kɨmiir Adi Komiiyɨn nɨnomor kouanɨn, kɨmiirɨn wɨ hɨriiyar mɨ tɨri. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Mɨ ɨiya kɨma nae mɨn haiyaeiyɨm mɨ Adi Komii siirɨm kwɨsboɨniyɨm, kɨmiir whwonkamɨm ɨkɨ kamɨm nɨksɨsaeiyɨm sɨm nɨnkikɨiyɨm, hɨriinan kɨpi nɨnkikɨi. Sɨmiir whwonkamɨm mɨnam nɨnkikɨi ɨkɨ iikam nhɨrɨm sɨma nwokɨ boɨnɨm, yɨm nae haiyaeikɨm mɨ sɨmiir inɨg nwokɨ hainanɨm. Kara kɨmiirɨn yaimwowar boɨnkii, yɨm sɨma sɨmiir digworaekwowɨm bɨdi haiyɨm. ");
INSERT INTO iws_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mɨ ɨiya kɨra nae mɨn haiyaei mɨ kɨriir whwonkamɨn sɨbgu whausok tatao mɨ kana ha timɨ sɨbgu hopsɨn. ");
INSERT INTO iws_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Mɨ sɨma kɨriirɨn wa nɨnoknɨnkɨn tani kɨra mhɨigɨ naowi. Nɨɨngaka. Kɨriir Adi Komiiyɨn inkamkɨ kɨg karamae nwowiyɨn, kɨriirɨn wɨ sasar nɨnoknɨnkɨni. Tɨ digworaekwowɨm kɨra nɨmprɨo dirɨraerarɨm. Mɨ mhoɨiya siya wɨ siyɨu mɨiyɨk ɨiirar tɨri kɨriirɨn wa hauu kɨiyɨuwi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Digworaekwo mɨiyɨk mɨiyɨkɨm kɨramaɨr kɨpi hangiriyɨu haigɨna tɨ nu ɨiirɨn. Yɨo tɨkɨ nuɨn kɨkom tapɨn aii mɨnɨm wɨ sɨma tɨrbumbugiyami. Mɨ kamɨm hɨi tauaeiyɨm pɨ omaka aiirar nɨinɨkirɨmtɨo nɨnopkainami tɨ digworaekwowɨm sɨmiir haiyam. ");
INSERT INTO iws_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mɨ kɨma nu tɨrɨn mɨi mɨiyɨk mɨiyɨkɨm nɨnomor kou hɨrɨn wɨ Adi Komii siyar hauuwi yɨo kɨkom tapɨn aii mɨnkɨ bɨ tɨrbuwikɨm mɨ hɨiyan kamɨm wɨ nɨinɨkirɨmtɨo nɨnopkainam tani digworaekwo tauaehaiyamɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mɨ maeyauwa kɨriir dimɨn mɨiyɨk mɨiyɨkɨm sɨma nwowɨn mɨ kɨriir kwoɨnbudɨn omwai waiyayokiyokɨiiyɨn wɨ tɨ om ɨiirar minɨ owouwi. Mɨ kɨra nuan dimɨnɨm sɨmiiram kɨpi naɨngwokwonanae. Kɨra Adi Komii siir dimɨn ɨmiiraram daɨngwo ɨski. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Nhwowɨn yɨo pɨu saiir nɨuya haigɨnɨuwikɨn. Mɨ kɨriir nhwowɨn wadɨeyar nikɨ owi mɨ kɨriir nhwowɨn digworaekwo whɨekakɨm sɨmiirɨn ɨna kɨgomok ɨrkakɨn nhwowɨn yɨo pɨu ɨrkaka saiirar nɨuya ɨrkakikɨn, kwoɨnɨn yɨo nhwonakɨn mɨ kɨra sɨbgu aɨngwowi mɨ kɨra wadɨeyar nwowi. ");
INSERT INTO iws_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mɨ kɨriir nhwowɨn siya biyɨe nwowi mɨ ni wɨ hindara natɨsɨr whaowae ɨuwi. Mɨ kɨriir kwoɨnɨn dimɨn biyɨeyam naɨngwowi mɨ siya wɨ nɨibwomambwo komiiyar namwowɨuwi mɨ tɨ dimɨnɨm kɨriir waraur nwowɨm yɨm mɨiyɨkɨ mɨiyɨkɨ mɨ ɨuwi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Mɨ inkamɨn bɨiyan inkam nwɨswo sowiir mɨi mɨiyɨk kwɨso sowiirar sɨbgu mɨrii swowi mɨ siya wɨ kwɨra saiir sɨbgu mɨrii mɨ kwɨra wɨ digɨumii haigɨngiki mɨ ta ɨi aiirarɨn siya umɨr mɨi aiiramar naɨngwo tɨbmii ɨski mɨ siya Adi Komii siir mɨi mɨiyɨkɨ saiirɨn wɨ panɨɨna sɨbgu mɨrii, ha? Nɨɨngaka. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Mɨ kara kɨmiir asi boɨnki mɨ kɨma kɨmiir kwoɨnbudɨn siirsi kɨpi naɨngwoyɨmiyok boɨn mɨ ha kɨpi boɨn, krɨma wɨ dimu dimɨn naei? Mɨ wɨ dimu dimɨn kwiyaei? Mɨ kɨma kɨmiir pɨu aiirsi kɨpi naɨngwoyɨmiyok boɨn, krɨma wɨ dimu dimɨn mɨ haigiprakai. Mɨ tari kɨriir kwoɨnbudɨn omwai waiyayokiyokɨiiyɨn, ɨni nae siir haiburɨn mɨ kɨriir pɨua ɨni yɨuɨs saiir haibura. Adi Komii siya tɨrkikɨn kɨriir pɨu kwoɨnbudɨn mɨ kɨra siirar wakaeyokna ɨski mɨ tɨ dimɨnɨm kɨra whaowaeyɨm wɨ siyar hauuwi. ");
INSERT INTO iws_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kɨma ɨpiyɨn ɨmiir kɨgnɨnoknɨnkɨnki, yɨm sɨma nae mɨn bɨ nɨnkɨkɨn aeikɨm mɨ naeyɨm omakanau bɨ mɨ mɨrii haigiikɨm. Nɨɨngaka. Mɨ kɨmiir Adi komiiyɨn nɨnomor kou hɨr nwowɨn, sɨmiirɨn nae siyar hauu aeyɨski. Mɨ wɨm kɨma ɨni ɨpiyɨn sɨmiir haiburɨm mɨ siya kɨmiirɨn wa sɨbgu kɨgrɨraowi. ");
INSERT INTO iws_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mɨ kɨmiir nwɨrkɨ ha naɨngwowi, siya bɨewi nhɨrɨm wɨ omwaiyar swokɨ haɨnɨs waiyayokiyokɨi, aniya? Nɨɨngakɨ nɨɨngakɨɨnga. ");
INSERT INTO iws_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Mɨ kɨma yɨuɨs digworaekwowam dimusi naɨngwokwonanaei? Kɨma kɨpɨm numɨr nwowiyɨm sɨmiir kɨg, yɨm sɨma panɨɨn panɨɨna nɨmbiyami. Yɨm sɨma mɨinan mɨrii rani. Nɨɨngaka. Mɨ yɨm sɨma yɨuɨs mɨn bɨ nonkwokwowikɨm. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mɨ kara kɨmiirɨn yaimwowar boɨnki, bɨiya inkam komii Solomon siya pɨuaiyɨm siir pɨuaipai pɨuaipaiyɨm, ta kɨpa saiir hɨriinan pɨuai mɨiyɨk bɨ nwoka. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ta kowa saeya mɨ kɨp aka Adi Komii siyar sɨbgu tɨrki mɨpi mɨiyɨka nɨmbiyami. Tapa ko kɨp sowa wadɨeyar nwowi mɨ waka sowa waigi mɨ wɨ paeya sɨma nɨtkaigii. Mɨ wɨm kɨma ɨni ko kɨp sowiir haiburo. Mɨ Adi Komii siya wɨ kɨmiirar mɨ sɨbgu kɨgrɨraowi. Mɨ kɨmiir naɨngwo tɨbmiiya Adi Komii siirɨmɨn kɨrɨe nwo karamae dimusi nwowi, ha? ");
INSERT INTO iws_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Mɨ hɨriinankɨ nɨuwi kɨma hɨnɨɨna kɨpi naɨngwoyɨmiyok boɨn, krɨma wɨ dimu dimɨn naei mɨ wɨ dimu mɨ haigiprakai sasaei pɨua kɨma hɨriinan kɨpi naɨngwo. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Yɨo tɨkɨ hɨriinan digworaekwowɨm sɨmiiramɨn ɨkɨ iikamɨm naɨngwo tɨbmii karamae nwowiyɨm, sɨm nɨnaɨngwoyɨmiyok boɨnikɨm. Mɨ kɨma sɨmiir hɨriinan kɨpi naɨngwoyɨmiyok. Mɨ kɨmiir Adi Komiiyɨn nɨnomor kou hɨr nwowɨn, siya ɨna nɨnoknɨnkɨnɨn tɨ digworaekwowɨm kɨma haɨnguguwɨm sɨmiirɨn. ");
INSERT INTO iws_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kɨmiir bɨiyan kwoɨnɨn ta ɨiya Adi Komii siya siir digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana mɨ siir siyɨu mɨiyɨk ɨeya mɨinan siiram tɨ mɨrii. Mɨ mhoɨiya siya tɨ digworaekwo nhɨrɨm wɨ kɨmiirarar swokɨ ɨnkɨn hauu mɨmɨrki. ");
INSERT INTO iws_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mɨ hɨriinankɨ nɨuwi kɨma digworaekwowɨm waka nɨmbiyamanɨm sɨmiirsi kɨpi naɨngwoyɨmiyok. Mɨ ɨigwɨr ɨigwɨrɨn dimɨn hɨkak hɨkakɨm ha nɨmbiyamikɨm. Mɨ tapan dimɨn hɨkak hɨkakɨm nɨmbiyamiyɨm sɨmiirarar hai, wakanɨm sɨmiir wara kɨpi nɨnkɨn hai. Ta ɨiya saiir digworaekwowɨm yɨm sɨmiiraramar timɨ naɨngwo. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Kɨma inkam nwɨrni kɨpi hɨd wɨm wɨ Adi Komii siya mɨ hɨdisi. ");
INSERT INTO iws_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mɨ ta hɨriinan yaiya kɨma boɨn hɨuriyɨuwa iikam nhɨrɨmi mɨ Adi Komii krɨmiir Wanɨn siya kɨmiirɨn wɨ hɨriinanar mɨ boɨn hɨuriyɨuwi. Mɨ kɨma iikam ɨmiirɨn hɨriga mɨ hauuwi mɨ Adi Komii siya kɨmiirɨn wɨ hɨriinan ɨiirar swokɨ iyopkɨiyɨuwi. ");
INSERT INTO iws_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mɨ kɨra paeka sɨma kɨriir nomiiyauwɨn siir nhwo ɨiir nwokaiya saiir dimusi kɨgi mɨ kɨra wara paemɨr komiiya kɨriir nhwo ɨiirar nwowa saiir bɨ naɨngwowarkainakɨn, aniya? ");
INSERT INTO iws_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Mɨ kɨra kɨriir nomiiyauwɨn siirɨn hɨnɨɨn dimusi mɨ prɨiboɨni, nomiiyau, kara wara paeka kɨriir nhwo ɨiir nwowa saiir haiyam tɨri mɨ wara paemɨr komiiya kɨriir nhwo ɨiir kiikirɨnɨua ya dimuga, ha? ");
INSERT INTO iws_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kɨra nɨksɨsaeyakɨ waiwigɨn! Kɨra bɨiyɨn wara paemɨr komiiya kɨriir nhwo ɨiir nɨrɨpua saiir tikɨ ɨinɨkiibwaeki. Mɨ mhoɨiya kɨra wa nwokɨ kɨgomok ɨinɨkrae haiyɨm kɨriir nomiiyauwɨn siir nhwo hɨr nwokaiya paeka sɨma saiirɨn. ");
INSERT INTO iws_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kɨma dimɨn mɨiyɨk mɨiyɨkɨm Adi Komii siirɨm dimɨn whɨrkɨ kɨmbu karamaeyɨm inkam biyɨeyɨm wrananɨm sɨmiir kɨpi hauugi. Dimusi rani, mhoɨiya kɨmiirɨn wɨ sɨmar swokɨ kwaenɨniyokna pii. Kɨmiir dimɨn mɨiyɨk mɨiyɨkɨm iikamɨm hunanɨm sɨmiir kɨpi hauu. Dimusi rani, sɨma tɨ dimɨn ɨmiirɨm bɨ naɨngwokɨm mɨ tɨ dimɨnɨm wɨ ɨgani sɨma nɨnkɨn okwonami. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Mɨ kɨma Adi Komii krɨmiir Wanɨn siiram kwɨsboɨni dimɨnam mɨ siya wa hauuwi kɨmiirɨn. Mɨ kɨma dimɨnam hansɨri mɨ kɨma siirɨn wa kɨgi. Mɨ kɨma ano ɨiir kaigakani mɨ Adi Komii siya wa haiwaokii. ");
INSERT INTO iws_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mɨ kara kɨmiirɨn yaimwowar boɨni, inkamɨn Adi Komii siiram kwɨsboɨniyɨn sɨma pɨ dimɨna mɨ haii. Mɨ inkamɨn ɨkɨ dimɨnam mɨ hansɨriyɨn yɨo siya siirɨn wa hauuwi mɨ inkamɨn ano kaigakanii mɨ Adi Komii siya siiramɨn wa haiwaokii. ");
INSERT INTO iws_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Mɨ kɨmiir inkam nwɨrɨn siir yɨnisɨmɨn siya siir ad ɨiiramɨn nipuam boɨni mɨ adɨn siirɨn wɨ siiya hauugi, aniya? Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Mɨ yɨnisɨmɨn ad ɨiiramɨn anasuam boɨni siir hauuam mɨ adɨn siirɨn wɨ mɨpug biyɨe siir hauugi, aniya? Nɨɨngaka. Siya wɨ hɨriinan tɨr tani. ");
INSERT INTO iws_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mɨ kɨma tɨ iikam bibiyɨeyɨm, hɨi mɨn tauaeiyɨm sɨma sɨmiir yɨnisɨsɨmɨm sɨmiirɨn dimɨn mɨiyɨk mɨiyɨk ɨmiirar mɨ hauuwikɨm. Kɨmiir Adi Komiiyɨn nɨnomor kou hɨr nwowɨn siya ɨni nuan ad ɨmiir haiburɨn, siya dimɨn biyɨekak rani, yɨo siya wɨ hɨriinan digworaekwo mɨiyɨk mɨiyɨk ɨmiirar mɨ sɨbgu hauuwi iikamɨm siiram srɨi. ");
INSERT INTO iws_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kara kɨmiirɨn yaimwowar boɨni, tɨ yaiyɨm sɨmiir yaimwokɨyaimwowa bɨiya Moses mɨ profet kamɨm sɨma wɨnkiyɨm yokwoni sɨma. Siyɨu mɨiyɨk dirɨraerar iikam nhɨrɨm sɨmiirɨn kɨra naɨngwowiyɨm sɨma dirɨraeraram kɨriir saiir hɨriinan. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Kɨma ano sapɨsapɨn siirgɨ siirar dapnɨnopkainam. Dimusi rani, anowɨn maeyauwa paekaka saiir hɨriir namiyɨn, yɨo prasae rani, bwaeya komiigɨn. Mɨ siyɨuɨn siir namiyɨn bɨmbɨuwi rani mɨ iikam whɨekakɨm wɨ siirar nami. ");
INSERT INTO iws_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mɨ anowɨn kwoɨnbudɨn omwai waiya yokiyokɨiyɨn siir hɨriir namiyɨn yɨo kabigɨkabi rani. Mɨ iikamɨm tɨ siyɨuɨn siiram namiyɨm mɨinan mɨriinamikɨm. Mɨ siirɨn nwɨnwɨra ɨrɨrakɨ hansɨryɨskaii. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Kɨma profet nɨksɨsaeyɨm sɨmiirsi mɨntarao yɨm sɨma kɨmaka wɨ yai iyop ninɨ onii. Mɨ wɨm kɨma wa naɨngwowi sɨma inkam mɨiyɨkɨm yaimwowar boɨnikɨm. Nɨɨngaka. Mɨ sɨmiir kwoɨnɨm yɨm mɨiyɨkɨ mɨiyɨkɨ mɨ ɨuwi, ɨni wranan ywowɨn, kɨmiir nɨksɨsaeyam mɨ sɨma kɨmiir naɨngwo tɨbmii aiir warar mɨ tɨrbuwi. ");
INSERT INTO iws_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kɨma bɨdiya yɨnoknɨnkɨnɨm sɨmiir siyɨuɨn sɨma tɨriyɨn. Mɨ tɨ pae sɨnɨn siya wɨ tab bud rani mɨ nɨowɨn ɨriipɨ hɨriinan siya wɨ am mɨ bud rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Mɨ hɨrii hɨriinankɨna pae mɨiyɨk mɨiyɨkɨm yɨmbi paenid mɨiyɨk mɨiyɨk ɨmiirar mɨ budi mɨ pae bibiyɨeyɨm yɨmbi paenid biyɨe biyɨe ɨmiirar mɨ budi. ");
INSERT INTO iws_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Pae mɨiyɨkɨn siya paenid biyɨe bɨ budigɨn. Nɨɨngaka. Mɨ pae biyɨeyɨn yɨo paenid mɨiyɨk bɨ swokɨ budigɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Mɨ paeyɨm nae mɨiyɨk bud karamae nwowiyɨm yɨm wɨ paeya sɨma nɨiyɨtkaigaigii. ");
INSERT INTO iws_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Mɨ kɨma wa nɨnoknɨnkɨni profet nɨksɨsae sɨmiir siyɨuɨn sɨma tɨriyɨn. ");
INSERT INTO iws_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Mɨ kɨma hɨnɨɨna daɨngwo iikam whɨekakɨm sɨma kariirɨn hɨnɨɨna dapɨkɨuwi, kariir Bɨiyan Inkam Komii, sɨma Adi Komii siir yɨnisɨm tani. Nɨɨngaka. Sɨma wɨ nhɨrkɨmaka nami ɨiya digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana nɨnomor koua hɨriirɨn. Mɨ inkamɨn kariir Adi Komiiyɨn nɨnomor kou hɨr nwowɨn siir kwoɨn ɨiirar sɨbgu api mɨ siya wɨ siir kɨgrɨraowi. ");
INSERT INTO iws_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mɨ taka ɨi komiiya Adi Komii siya iikam whɨekakɨm sɨmiir hɨdi, wɨ kariirar dapboɨn wɨni, Bɨiyan Inkam Komii, Bɨiyan Inkam Komii, nɨm krɨma kɨriir inɨg ɨiir mɨriigɨm! Adi Komii siir yaiya iikam sɨmiir. Mɨ ɨkɨ uridyɨu biyɨe biyɨeyɨm sɨmiirɨn krɨma kɨriir inɨg ɨiirar haiswonɨmnɨskɨigɨm! Mɨ krɨma dimɨn kɨrɨe komii komiiyɨm kɨriir inɨg ɨiirɨn kasakasa bɨ tɨrkɨm! ");
INSERT INTO iws_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mɨ taka ɨi aiirɨn kara sɨmiirɨn wɨ hɨnɨɨna boɨnmauu wakaei, kara kɨmiir bɨ swokɨ ɨnoknɨnkɨn mɨmɨnkɨn. Nɨɨngaka. Kɨma siyɨu bibiyɨe tɨrakɨ waiwigɨm, kɨma damki! Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Mɨ inkamɨn kariir yai aiir wakaeyokna dirɨraerari, yɨo tɨkɨ hɨriinan inkamɨn kwoɨn mɨiyɨkakɨn, yɨo ɨni inkamɨn omaka siiya ɨdwo mɨriiyɨn ɨni siir hɨriinan ywowɨn. ");
INSERT INTO iws_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mɨ ta ɨiya opud nao owɨe komiiyɨn ha nɨtɨn ta omaka aiir namɨtɨunii mɨ saeya bɨ nakainamka. Nɨɨngaka. Dimusi rani, ta omaka ɨni siiya kɨrɨe kɨrɨeyɨm nu aowa nwokaiyɨm sɨmakar yaunɨ owɨuwɨm. ");
INSERT INTO iws_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Mɨ inkamɨn ta kariir yai aiir wakaeyokna karamae nwowiyɨn, yɨo ɨni tɨ inkamɨn omaka aowi maeyau mɨriiyɨn ɨni siir hɨriinan ywowɨn. ");
INSERT INTO iws_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mɨ ɨiya opud nao komiigɨ nɨtiyɨm mɨ owɨe komiiyɨn ha mɨ ɨtɨn mɨ digworaekwo hɨriinanɨm ta omaka aiir namɨtɨuniyɨm mɨ saeya ɨna yakainama. Ɨhɨ, saeya ɨna yakai ɨɨmɨk ɨuguskiya. ");
INSERT INTO iws_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jisɨs siya tɨ dimɨnɨn siirɨn ha boɨn dɨgiyɨn mɨ iikam whɨe komiiya ɨni hindara yanaakiyɨm tɨ yai hɨriinanɨm siya boɨnmɨmauuwɨm sɨmiirsiyɨn. ");
INSERT INTO iws_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Dimusi rani, siya sɨmiirɨn kamɨm siyɨu komii nɨnoknɨnkɨniyɨm sɨmiir hɨriinan bɨ boɨnmɨmauugɨn. Nɨɨngaka. Siya sɨmiirɨn inkamɨn inɨgakɨn siir hɨriinan boɨnmɨmauugɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Mɨ Jisɨs siya mhɨu hɨrankɨ nɨunaiiniyɨn mɨ iikam whɨe komiiya ɨni siir mhoɨiyar sɨdkaenamɨm. ");
INSERT INTO iws_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Mɨ inkam nwɨrɨn paowai mɨnkɨ pɨsɨkomkopouwɨn ha nɨtɨn siiram mɨ siya ogmwo ɨni siir whwonkam ɨdaɨr inɨ akaihɨuniyɨn. Mɨ siya ɨna boɨnɨn, Bɨiyan Inkam Komii, kɨra kariirsi naɨngwobumbuwi mɨ kɨra kariirɨn pa haiswonɨskiigi. ");
INSERT INTO iws_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jisɨs siir ɨɨna siir ha nonkwokiyɨn mɨ siya ɨna boɨnkiyɨn, kara ha naɨngwowi, kɨra wadɨeyar dwoki! Mɨ paowai mɨnɨm siir pɨsɨkomkopouwɨm ha dɨgiyɨm mɨ bɨri kɨmɨmɨnkikɨn siya ɨni wadɨeyar ywokiyɨn. ");
INSERT INTO iws_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Mɨ Jisɨs siya siir boɨnki, kɨra sɨbgu wakae! Kɨra wɨ inkam nwɨrni kɨpi swokɨ boɨnmauumɨmɨn. Nɨɨngakɨ, nɨɨngaka. Mɨ kɨra kɨriir pɨua pris inkamɨm sɨmiir tinɨ ɨisiimauuɨu. Mɨ kɨra wɨ naemɨn dɨnkɨn ɨmiiyaeki, bɨiya Moses siya boɨna saiir hɨriinan. Mɨ iikamɨm sɨma wa nwokɨ ɨnoknɨnkɨnɨm kɨriir ma Adi Komii siya bɨdi dɨgiya. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Mɨ mhoɨiya Jisɨs siya om Kapaneam hɨriir napnɨnopkainamɨn mɨ om komii Rom hɨran kamɨm yaii nɨniiyɨm sɨmiir bɨiyan inkamɨn ha nɨtɨn mɨ siya siirɨn hɨnɨɨna yasrɨini, ");
INSERT INTO iws_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Bɨiyan Inkam Komii, kariir mɨiyan inkamɨn siya makakɨn, ɨni omaka hɨrar whwonkaiyɨn. Mɨ siir ɨga ɨɨn mɨnɨm bɨdi yaowɨguskiyɨm mɨ siir pɨua kɨmpɨpɨsu prasae kɨn tani. ");
INSERT INTO iws_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Mɨ Jisɨs siya siirɨn hɨnɨɨna boɨnki, siirɨn pɨ kara ninɨ haiswo nɨskiiyɨuwi mɨ siya pɨ wadɨeyar nwokii. ");
INSERT INTO iws_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mɨ kamɨm yaii nɨniiyɨm sɨmiir bɨiyan inkam ɨeya boɨn, Bɨiyan Inkam Komii, kara inkam paii rani mɨ kɨra kariir omaka pa nɨt rani. Kɨra hinda yaiyarar boɨnki mɨ kariir mɨiyan inkamɨn pɨ wadɨeyar nwokɨ okiyɨm. ");
INSERT INTO iws_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mɨ an kara ɨriipɨ hɨriinan ɨni ɨkɨ kam nhɨrɨm inɨgakɨm kariir kɨgrɨraowiyɨm, ɨni sɨmiir aowa mɨ owɨn. Mɨ karakɨ karar kɨgrɨraowiyɨm, kamɨm yaii nɨniiyɨm sɨmakɨsɨmaɨrgɨm. Mɨ kara nwɨrni boɨnkii, kɨra dam! Mɨ siya pa mɨ ami. Mɨ kara nwɨrni, hɨnɨɨna mɨ boɨnkii, kɨra wɨt! Mɨ siya pa mɨ ɨti. Mɨ ɨkɨ kariir mɨiyan inkam ɨiir boɨnkiyɨm, kɨra ta mɨi aiir tɨ mɨrii mɨ siya pa dirɨraerarii. Kara bɨdi yɨnoknɨnkɨnɨn kɨra pɨ yaiyara boɨnki, kariir mɨiyan inkamɨn pɨ wadɨeyar nwoki. ");
INSERT INTO iws_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Mɨ Jisɨs siya ta yai aiir wakaeyɨn mɨ siya ɨni hindarar yanaakiyɨn. Mɨ siya kɨmɨdina iikamɨm siir mhoɨiyar namɨm sɨmiir boɨnki, kara kɨmiirɨn yaimwowar boɨnkii, kara iikamɨm Isrel mɨ iikam nhɨrɨm sɨmiir hɨrɨn inkam nwɨrɨn tɨ inkamɨn siir naɨngwo tɨbmiiya saiir hɨriinan naɨngwo tɨbmii inkam nwɨr bɨ kɨgɨn. Nɨɨngakɨ, nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kara kɨmiirɨn yamwowar boɨnkii, iikam ombud komiiyɨn bɨekɨ nɨtiyɨn mɨ bɨekɨ nɨkiiyami ɨkɨn, wɨ hɨrankɨ nɨti mɨ sɨma wɨ krɨmiir brougaeyɨm Ebraham Aisak mɨ Jekop, wɨ sɨmakar ninɨ ɨdwo aeyɨuwi, maeyauwa Adi Komii siya iikamɨm mɨ digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana saiir. ");
INSERT INTO iws_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Mɨ yɨnɨe whɨekakɨm nu Isrel hɨr niyɨonɨnkɨnɨm sɨmiirɨn wɨ Adi Komii siya nhɨnɨkrɨropkii, maeyau ɨɨmɨrɨɨma saiirɨm. Mɨ ta maeyauwa sɨma kauu prasae kɨn tani. Mɨ wɨ sɨmiir big ɨmiirar naegiyɨmkiyɨkaeyami. ");
INSERT INTO iws_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Siya ha boɨn dɨgiyɨn mɨ Jisɨs siya yaii nɨnii kamɨm sɨmiir bɨiyan inkamɨn siir boɨnki, kɨra omaka dam! Kara ha naɨngwowi, tɨ digworaekwowɨm, wɨ ta kɨriir naɨngwo tɨbmiiya wadɨe saeyar swokɨ ɨmbiyami. Mɨ ta yaiya saiir mhoɨiya bɨri kɨmɨmɨnkikɨn, ta ɨi aiirarɨn, siir mɨi mɨrii inkamɨn ɨni wadɨeyar ywokiyɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Mɨ mhoɨiya Jisɨs siya ha namɨn Pita siir omaka hɨriir mɨ siyar kɨg, Pita siir nɨua hɨi hɨrar whwonkaii. Ya ma pɨu huuwa kɨniya saeya niiga. ");
INSERT INTO iws_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Mɨ siya saiir ɨɨna aiirarar ninɨ onkwokiyɨn mɨ ta ma pɨu huuwa kɨniya saiir nwowa ɨna dɨgiya. Mɨ saeya ha nɨnsiin ɨdwowa, ɨni siir nae ɨmiirar swokɨ kwɨnsiin dirɨraerara. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mɨ mhoɨiya naɨowaka sɨma, sɨmiir iikamɨm uridyɨu biyɨekɨ nɨtkiiyɨm, ɨna yɨtɨm Jisɨs siiram. Mɨ siya iikamɨm uridyɨugɨ nɨtkiiyɨm sɨmiirɨn hinda yaiyarar boɨnkiyɨn mɨ tɨ iikamɨm ɨni wadɨeyar ywokiyɨm. Mɨ siya iikamɨm makɨ niiyɨm sɨmiirɨn warar yɨnkɨn haiswonɨmnɨskɨigi. ");
INSERT INTO iws_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Mɨ siya ha boɨn dɨgiyɨn mɨ yai kwɨra bɨiya Adi Komii siya boɨnkiya profet Aisaiani, saiir swokɨ boɨnourwokaigikɨn. Siya hɨnɨɨna boɨnkɨn, siya bɨdi haiyoprimdiyɨumiigiyɨm krɨmiir ma biyɨe biyɨeyɨm mɨ krɨma mɨiyɨk asi nwowi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisɨs siya iikam whɨe komiiya sɨmiir kɨgɨn, siir nakaeyokainiyɨm mɨ siya kamɨm siir kɨgna mɨriiyɨm sɨmiir boɨnki, nɨmbi hɨnda whɨigbid mɨrmiiya nɨnɨdnaidami. ");
INSERT INTO iws_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mɨ inkam nwɨrɨn siyɨu komii nɨnoknɨnkɨniyɨn ha nɨtɨn mɨ kɨmɨdina siya yaboɨni siirɨn, hae! Tɨ nowomwarkaiyɨuan inkamɨn kara ɨkɨ omom omomɨm kɨra namɨm tɨriiyɨm kara kɨnaka warar kainanaowamar tɨri. ");
INSERT INTO iws_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Mɨ Jisɨs siya siir boɨnki, ɨni wakaeyɨn, niimauan wra biyɨeyɨm, yɨm nu tɨrɨn nokakargɨm. Mɨ ɨpiyɨnɨm ɨriipɨ hɨriinan, omakakak. Mɨ Yaowae Adɨn nɨmomor kouankɨ nɨtɨn, yɨo pɨu kikɨnsiisan maeyau karamaeyaɨrgɨn. Nɨɨngakɨ, nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mɨ siir kɨgna mɨrii inkam nwɨrɨn siya boɨn, Bɨiyan Inkam Komii, kara bɨiyɨn kariir ad ɨiir ninɨ haɨngikaigiki. Mɨ kara pɨ kɨriir mhoɨiya nɨti. ");
INSERT INTO iws_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jisɨs siya ɨna yowarkɨi boɨnɨn. Nɨɨngaka. Kɨra kanaka tariinanar kwɨt! Warɨ inkam wɨɨrɨn, yɨo inkamɨm naɨngwo tɨbmii karamaeyɨm inkam wɨɨrnanɨm yɨm sɨma, sɨmar tɨ swokɨ haɨngikai. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisɨs siya ha boɨn dɨgiyɨn mɨ siya i aiir nani kwɨriiyɨn mɨ siir kɨgna mɨriiyɨm kamɨm, yɨm ɨni warar mani kwɨriiyɨm. ");
INSERT INTO iws_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mɨ sɨma ɨna yɨnɨdnaidamɨm yarmiiya mɨ opud whoɨmwɨɨni rani, whɨi hɨr hugnatmairɨba. Mɨ hɨnɨna pariiparii i aiir niswɨtnatkaiyɨm. Mɨ siya ɨni inau hɨrar whwonkai taowɨn. ");
INSERT INTO iws_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Mɨ kamɨm siir kɨgna mɨriiyɨm, ha namɨm, ɨna yamɨ ɨnɨdguwɨm siir. Mɨ sɨma boɨn, Bɨiyan Inkam Komii, kɨra krɨmiirsi daɨngwoyɨmyok mɨ krɨmiir whɨndirɨraerarki, krɨma pa nokwomwainaiinami. ");
INSERT INTO iws_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Mɨ siya sɨmiirɨn hɨnɨɨna yowarkɨi boɨnki, kɨma dimusi nɨdidi, ha? Warɨ kɨmiir naɨngwo tɨbmiiya saeya komiigɨ mɨ ɨuwi! Mɨ siya ha boɨndɨgiyɨn ɨna yɨnsiin ɨdwokaigiyɨn mɨ kɨmɨdina ɨo opud hɨnɨn sowiir ywoki. Mɨ bɨri kɨmɨmɨnkika opuda ɨna yɨnkisanakiya mɨ opa ɨni mokmokwaiya ywomaimiigiya. ");
INSERT INTO iws_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Mɨ siya hɨriinan tɨrkiyɨn sɨma ɨni hindara yanaakiyɨm. Mɨ ɨni sɨma sɨmar yomboɨn amboɨnkiyɨm, siya tɨ inkamɨn dimu naeikɨsae. Opud hɨnɨno ɨni siir yaiyar mɨ wakaeyoknakiyo, ha? Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Mɨ Jisɨs siya whɨigbid mɨrmii kwɨra saiir hɨriir ha nɨmbiyamɨn, Gadarani nu siir mɨ inkam nwɨso uridyɨu biyɨekɨ nɨtkiiyo ɨna yɨtwo siiram. Mɨ tɨ inkam nwɨso sowa maeyauwa inkam haɨngikaiiya saiir hɨrankɨ nɨtko. Mɨ inkam nwɨso, sowa uridyɨu biyɨenan bɨdi ywokiyo. Mɨ iikamɨm tɨ siyɨu ɨiir panɨɨnsi yapsi, sowa tɨowisi sɨma hɨriinansi nɨdidgɨm. ");
INSERT INTO iws_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Mɨ sowa ɨna kauwok boɨnamnankiyo, tɨ Yaowae Adɨn nɨnomor kouankɨ nɨtɨn, kɨra krɨmiirɨn dimu dimɨn tɨram nɨtkɨn, ha? Mɨ ɨiya dɨgana ɨna nikɨ owa kɨra maeyau biyɨeya saiir nɨkropkiyana krɨmiir tɨrbumbuamɨn. ");
INSERT INTO iws_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Mɨ tɨ hu isid komii whɨrɨn arurɨg hɨrar nokwo aekɨn. ");
INSERT INTO iws_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Mɨ tɨ uridyɨu isid komiiyɨn ha nhɨnkii kaugiyɨm mɨ ɨna boɨnkiyɨm Jisɨs siirɨn mɨ kɨra krɨmiir nhɨnɨkrɨropkii mɨ kɨra krɨmiirɨn warɨ hu isid komiiyɨn siirɨm dɨkropki. ");
INSERT INTO iws_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Mɨ Jisɨs siya sɨmiirɨn ɨna boɨnkiyɨn, kɨma damki! Mɨ tɨ uridyɨu biyɨeyɨm sowiir ha haiburgiko mɨ sɨma ɨna yamkiyɨm tɨ hu isid komii ɨiiram. Mɨ tɨ hu isid komiiyɨn ha niwɨtamɨm, ɨni siiyɨeno whɨrɨn siirarar iwɨt ɨugugusamɨm. Mɨ sɨma ɨni mhɨuno whɨi kwɨra saiir kwiyae haɨngrɨmkrɨkɨu aokaonamɨm. ");
INSERT INTO iws_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mɨ kamɨm hu ɨmiir waikaowiyɨm, sɨma ɨna yɨdamkiyɨm. Mɨ sɨma om komiiya hɨriir ha niwɨt nɨmbimbɨiyamɨm mɨ ɨna inɨ boɨnmɨmauuɨuwɨm dimɨn sɨma kɨgnaniyɨm sɨmiirɨn. Sɨma dimɨnɨn inkam nwɨso, uridyɨu biyɨekɨ nɨtkiiyo, sowiir nɨmbiyamɨn, siir warar inɨ boɨnmɨmauuwɨu. ");
INSERT INTO iws_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mɨ saiir mhoɨiya iikam whɨekakɨm tɨ om komiiyɨn siir hɨranɨm ɨna yɨtɨm Jisɨs siir kɨgam mɨ sɨma ɨna yɨdidɨm. Mɨ ɨna nhɨnɨkrɨropkiyɨm siirɨn, nu maeyau kwɨra namɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Mɨ Jisɨs siya igopsɨm ɨra saiir nani kwɨriiyɨn mɨ ɨna swokɨ iyɨkɨdamɨn whɨigbid mɨrmiiya hɨriir. Mɨ siya ɨni siir omkɨ om ɨiirar swokɨ amɨn. ");
INSERT INTO iws_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mɨ sɨma sɨmiir inkam nwɨrɨn kɨumɨnkɨ naonɨnsɨmsɨrɨuwɨn ɨna hainaniyɨn, Jisɨs siiram. Mɨ siya ɨni hɨi aiirar whɨnaniyɨn. Mɨ siya sɨmiirɨn hɨriinan kɨgiyɨn, sɨma siiram naɨngwo tɨbmii, siya siir haiswonɨskiiyɨm mɨ siya tɨ inkamɨn kɨumɨnkɨn naonɨsɨmsɨrɨuwɨn siir boɨnki. Nomiiyau, kɨriir kwoɨnɨn kɨrɨe tɨ oki. Kɨriir dimɨn biyɨeyɨm kara bɨdi haiyoprimdiyɨumiigiyɨm. ");
INSERT INTO iws_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Mɨ mhoɨiya kamɨm siyɨu komii nɨnoknɨnkɨniyɨm sɨma sɨmar yɨmboɨn amboɨn. Mɨ tari tɨ inkamɨn siya nɨgbumbuwi. Mɨ siir ɨgsop aiir nokwokairinaɨm mɨni. ");
INSERT INTO iws_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Mɨ Jisɨs siya sɨmiir kwoɨn ɨiir bɨdi yɨnoknɨnkɨnkiyɨn mɨ siya ɨna boɨnkiyɨn, kɨma warɨ kwoɨn biyɨe hɨnɨɨnɨn kɨmiir kwoɨnau dimusi nwokaii, ha? ");
INSERT INTO iws_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Pakɨ hɨnɨɨn yai akɨ kariir kɨrɨe komiiya saiir nɨisiimauua? Kara ha boɨni, kɨriir dimɨn biyɨeyɨm kara bɨdi haiyoprimdiyɨumiigiyɨm, aniya? Mɨ kara ha boɨni kɨra ha dɨnsiin aprɨrɨrki, saeya, aniya? ");
INSERT INTO iws_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ta saeyar nɨisiimauuga mɨ ankara ha naɨngwowi kɨma dɨnoknɨnkɨn. Kara Yaowae Adɨn nɨnomor kouankɨn nɨtɨn siya tɨ nu ɨiirɨn inɨg kɨrɨe kakargɨn mɨ siya wɨ dɨgar mɨ owi dimɨn biyɨe biyɨeyɨm sɨmiir mɨ haiyoprimdiyɨumiiyɨm. Mɨ siya tɨ inkamɨn ɨga ɨɨn nɨnsɨmsɨrɨuwɨn siir asi boɨnkikɨn. Kɨra dɨnsiingi mɨpi kɨriir hɨi aiirar dɨnsiin hainam mɨpa damɨgusam kɨriir omaka hɨriiyar. ");
INSERT INTO iws_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mɨ siya ha nɨnsiingiyɨn mɨ ɨni siir omakar yamɨgusamɨn. ");
INSERT INTO iws_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mɨ iikamɨm sɨma tɨ dimɨn hɨriinanɨn siir kɨgiyɨn sɨma ɨni nɨdidkakar yokiyɨm mɨ sɨma ɨni Adi Komii siir inɨg ɨiirar hainankiyɨm. Dimusi rani, Adi Komii siya hauugɨn ta hɨriinan kɨrɨeya Jisɨs siirɨn tɨ inkamɨn siir haiswonɨskiiyɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Mɨ Jisɨs siya ta maeyauwa saiir haiburgikɨn mɨ ha napnamɨn mɨ siya youapkɨgam kariirɨn kara omom omomi umɨr nɨdwokai haiiya omaka saiir nɨdwokaii tɨ inkamɨn Matyu karargɨn. Mɨ Jisɨs siya kariir boɨnki, kɨra kariir mhoɨiyar wɨt. Mɨ kara ha nɨnsiingiyɨn mɨ kariir digworaekwowɨm ɨni hɨrar iyopnɨsugigɨm. Mɨ kara ɨni Jisɨs siir mhoɨiyar yamɨn. ");
INSERT INTO iws_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mɨ saiir mhoɨiya Jisɨs siya omaka hɨr nɨdwokai aeyɨn mɨ kam nhɨrɨm omom omomi umɨr haiiyɨm mɨ kam bibiyɨeyɨm dimɨn biyɨe biyɨe tɨrkiyami ɨkɨm sɨma ha nɨtɨm, Jisɨs siya mɨ siir kɨgna mɨrii ɨkɨm kamɨm ɨni sɨmakar inɨ ɨdwo aeniyɨm. ");
INSERT INTO iws_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mɨ Farisi kamɨm sɨma tɨ hɨriinan siyɨu ɨiir kɨgɨm mɨ sɨma kɨmadiniya Jisɨs siir kɨgnamɨriiyɨm kamɨm sɨmiir boɨn, warɨ inkamɨn kɨmiir nowomwarkaiyɨuwiyɨn, siya warɨ kamɨm omom omomi umɨr haiiyɨm mɨ inkam biyɨe ɨkɨm sɨmaka dimusi nɨdwokai aei, ha? ");
INSERT INTO iws_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Mɨ Jisɨs siya hɨriinan wakaeyɨn mɨ siya ɨna yowarkɨi boɨnɨn, iikamɨm ɨkɨ mamɨn karamaeyɨm yɨm sɨma inkamɨn paowai mɨn widiyɨn siirɨm bɨ namikɨm. Nɨɨngaka. Siiramɨn iikamɨm mamɨnkɨ niiyɨm sɨma sɨmar namikɨm. ");
INSERT INTO iws_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kɨma ha dam yaiyɨm kara boɨnɨm sɨmiir tikɨnɨ aɨngwonaki Yokwo Komii saiir nwowɨm, ta yaiya Adi Komii siya hɨnɨɨna boɨnkɨn, kara wraisu mɨn nɨnkɨn ɨmiiyaeyɨm pɨ boriisopi. Nɨɨngaka. Kara ha naɨngwowi, kɨma ɨkɨ iikam nhɨrɨm sɨmiirsi daɨngwobumbu. Kara ɨkɨ iikamɨm ha naɨngwowɨm krɨma iikam mɨiyɨk mɨiyɨkɨm sɨmiiram bɨ nɨtkɨn, sɨmiir nɨkɨunaɨm. Nɨɨngaka. Kara ɨkɨ iikamɨm ha naɨngwowɨm krɨma iikam biyɨe biyɨekɨm sɨmiir nɨkɨunam nɨtkɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Mɨ taka ɨiya Jon siir kɨgna mɨriiyɨm kamɨm sɨma ha nɨtɨm mɨ Jisɨs siir ya srɨini mɨ Farisi kam ɨkɨm mɨ krɨma, nɨm krɨma nae mɨna mɨ haiyaei mɨpi mhɨirɨma mɨ owi nhwo kwɨsboɨnam mɨ wara kɨriir kɨgna mɨriiyɨm kamɨm yɨm sɨma hɨriinan tɨr karamae dimusi nwowi, ha? Dimusika? ");
INSERT INTO iws_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Mɨ Jisɨs siya ɨna yowarkɨi boɨnkiyɨn mɨ inkamɨn wig wɨn nonkwonaei mɨ siya siir nomiiyau ɨmakar nwowi mɨ ta ɨiya maɨrgɨmaɨrgani ɨiga, iyɨe? Hɨkak nwoni ɨiga. Mɨ nae mɨnɨm pa haiyakii, aniya? Nɨɨngaka. Mɨ mhoɨiya tɨ inkamɨn wig nokwonaɨn, inkam nhɨrkɨm inɨ ɨkɨunakii, siir nomiiyauɨm, sɨmiir hɨrankar mɨ taka ɨiya kɨma wɨ hɨkak saiir dwo mɨ nae mɨnɨm saiir haiyakii. ");
INSERT INTO iws_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Inkam nwɨrkɨ yɨuɨs wɨn mɨrmiiya yɨuɨs kaba saiir no ɨiir bɨ swokɨ ɨtkɨn pankɨn. Nɨɨngaka. Mɨ siya hɨriinan tɨri mɨ ta yɨuɨs kaba saiir no ɨiir mɨ ta yɨuɨs kaba wɨ saeya swokɨ mɨmbɨmbɨɨraraokii. Mɨ nowɨn wɨ komiiyar nasae owɨguskii. ");
INSERT INTO iws_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Inkam nwɨrkɨ wain wɨni opa meme kab ɨsa saiir bɨ naokaigɨn. Mɨ siya hɨriinan tɨri ta op wain wɨna saeya niwɨt iyopiinaini mɨ ta meme ɨs kaba wa nɨmbɨriyamkii. Mɨ wainɨn wɨ nu arar naokiinonkwokwonam swokii. Mɨ meme ɨsa ya wɨ warar nɨnkɨn ɨguskii. Mɨ yɨm sɨma wain wɨni opa pɨ meme ɨs wɨn aiirar naokaii. Mɨ sowa pɨ wadɨeyar naokaii. Mɨ sowa pɨ wadɨeyar ninan oswowi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mɨ Jisɨs siya yai hɨrar nikɨ boɨnmɨmauuwɨn sɨmiir mɨ Juda sɨmiir bɨiyan inkam nwɨrɨn ha nɨtɨn mɨ siya ogmwo ɨni Jisɨs siir whwonkam ɨdaɨr inɨ hɨuboɨniyɨn. Mɨ siya siirɨn hɨnɨɨna boɨn, kariir yɨnisɨm yɨnugiyɨna saeya tariinanar kwaonamka. Kɨra wɨt mɨ kɨriir ɨɨna saiir winɨ onkwoni mɨ pɨ omwaiyar swokɨ waiyaɨm. ");
INSERT INTO iws_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Mɨ Jisɨs siya ha nɨnsiingiyɨn mɨ ɨni siir mhoɨiyar yamɨn. Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma ɨni saɨkar yɨnkɨn amɨm. ");
INSERT INTO iws_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mɨ wig ɨra hɨr nwoka ya nhɨekɨ mɨ apɨdwodwomaimiiga bɨewiyɨm ɨuur whɨs. Mɨ ta wiga saeya kɨmɨdiniya Jisɨs siir yɨuɨs mwɨs aiir yaka apiyokna onkwoki. ");
INSERT INTO iws_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Mɨ saiir kwoɨnararɨn saeya hɨnɨɨna naɨngwoka mɨ kara pɨ siir yɨuɨs aiirar nonkwokii mɨ ta nhɨeya pa nɨnkipraenakii. ");
INSERT INTO iws_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Mɨ Jisɨs siya ha haiyɨug okwokaokiyɨn mɨ ɨna boɨnkiyɨn yɨnisɨm yɨnugiyɨn kɨriir kwoɨnɨn hiisɨma tɨ oki. Kɨra kariiram naɨngwo tɨbmiiga mɨ kɨriirɨn wadɨe saeyar swokɨ okika. Mɨ bɨri kɨmɨmɨnkika ta ɨi aiirarɨn ta wiga ɨni wadɨeyar ywokiya. ");
INSERT INTO iws_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Mɨ Jisɨs siya napnamɨn mɨ Juda sɨmiir bɨiyan inkamɨn siir omaka aiir nɨmbiyamɨn mɨ siyar kɨgam kamɨm tɨdiyɨu kuuwi. Mɨ iikamɨm yaiya hɨnɨɨn nɨnkɨnɨu rani, hapi anaupaekɨnɨuwi ta yɨnisɨm aiirɨm nouwi. ");
INSERT INTO iws_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Mɨ Jisɨs siya ɨna boɨnkiyɨn, kɨma damki! Ta yɨnisɨm yɨnugiyɨna bɨ naonamka. Nɨɨngaka. Saeya nhwo whɨni. Ɨiya iikamɨm sɨma hɨriinan wakaekiyɨm mɨ sɨma yaibu siirɨn haɨnɨngɨn bu. ");
INSERT INTO iws_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mɨ sɨma iikam ɨmiirɨn ha nhɨnɨkrɨropkiyɨm mɨ Jisɨs siya ha napnɨnopkainamɨn, maeyauwa yɨnisɨm yɨnugiyɨn aeya whwonkaiya saiir mɨ siya ha ninɨ onkwo ɨuwɨn saiir ɨɨna aiir mɨ saeya ɨna yɨnsiin ɨdwokiya. ");
INSERT INTO iws_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mɨ ta yaiya hɨnda tɨnda ɨna yɨnyokwɨigiya. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Mɨ Jisɨs siya ta maeyau aiir haiburgigɨn mɨ siya ɨna yapnamɨn. Mɨ ɨiya siya nikɨ apamɨn, inkam nhwokwɨsae nwɨso siir mhoɨiyar napnamo, sowa siiramɨn, hɨnɨɨna kauwok boɨnam, tɨ Devidni isidɨn siir yɨnisɨmɨn, Adi Komii siya nɨkropkiyɨn kɨra krɨriirsi timɨ aɨngwobuna. ");
INSERT INTO iws_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Mɨ Jisɨs siya omaka ha napnɨnopkainamɨn mɨ tɨ inkam nhwokwɨsae nwɨso ha nɨtwo siirɨm mɨ siya ɨna srɨiwɨnɨn sowiirɨn. Mɨ tari kowa ha naɨngwowi kara wɨ dɨgar nwowi tɨ hɨriinan dimɨn ɨiirɨn, aniya? Mɨ sowa siir yai aka hɨnɨɨna yowarkɨi boɨn. Ɨhɨ, Bɨiyan Inkam Komii. ");
INSERT INTO iws_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Mɨ siir ɨɨna sowiir nhwo owiir ha nonkwokiyɨn mɨ siya ɨna boɨnkiyɨn, kowa kariirɨm naɨngwo tɨbmiigo mɨ kowa wɨ wadɨe asi nwowi. ");
INSERT INTO iws_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mɨ sowiir nhwonao ɨni bɨimiyar kɨnkiyo. Mɨ Jisɨs siya sowiirɨn hɨnɨɨna yowarkɨi boɨnki, kowa sɨbgu wakaenam. Tɨ dimɨn ɨiirɨn wɨ inkam nwɨrni kɨpi boɨnmauu. Wɨ sɨma pɨ nɨnoknɨnkɨnisi. ");
INSERT INTO iws_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mɨ sowa idowɨiya ha namwo mɨ tɨ dimɨnɨn Jisɨs siya tɨrkiyɨn ɨna haigirɨrɨramɨn hɨnda tɨnda. ");
INSERT INTO iws_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mɨ sowiir mhoɨiyarɨn inkam waeyaimɨkrɨm nwɨrɨn uridyɨugɨ nɨtkiiyɨn siirɨn kam nhɨrɨm sɨma hainani Jisɨs siirɨm. ");
INSERT INTO iws_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mɨ tɨ uridyɨu biyɨeyɨn tɨ inkamɨn siir nɨtkiiyɨn, siirɨn kɨmɨdiniya Jisɨs siya yɨnɨskɨigi. Mɨ tɨ inkam waeyaimɨkrɨmɨn yai ɨna boɨnaikiyɨn. Mɨ iikam ombud komiiyɨn ha nanaakiyɨm mɨ sɨma ɨna boɨnɨm, bɨiya tɨ hɨriinan dimɨnɨn nu Isrel tɨrɨn bɨ swokɨ ɨmbiyamkɨn. Nɨɨngakɨ, nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mɨ Farisi kamɨm sɨma boɨn, warɨ kɨrɨeya uridyɨu biyɨe siya nɨnɨmnɨskiiya ya uridyɨu biyɨeyɨm sɨmiir bɨiyanɨn siir kɨrɨe aeya. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Mɨ tɨ sɨmiir mhoɨiya Jisɨs siya om komii komiiyɨm mɨ omisɨsɨmɨm, sɨmiirar yapyokɨi ɨrkak. Mɨ siya iikam ɨmiirɨn, sɨmiir omakaɨm yaimɨn dimɨn nɨdwokai wakaeiyɨm sɨmiir hɨrar yowomwarkaiyɨu. Siya sɨmiirɨn yai wɨn kɨbiya, ɨiya Adi Komii siya digworaekwowɨm sɨmiir kɨgɨrkakana saiir nowomwarkaiyɨugɨn. Mɨ siya iikamɨm mapai mapaigɨ niiyɨm mɨ ɨga ɨɨn nɨnsɨmsɨrɨuwɨm, sɨmiir warar yɨnkɨn ɨnɨmnɨskiiyam. ");
INSERT INTO iws_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mɨ siya iikam isid komiiyɨn siir kɨgɨn mɨ siir kwoɨnɨn sɨmiirsiyɨn naɨngwoyɨmyok pranae bɨ kɨnkɨn. Dimusi rani, sɨmiir kwoɨnɨm bɨdi whrɨewhrɨekiyɨm. Mɨ sɨma ɨni sibsibɨm inkamkɨ kɨgrɨrao karam nwowiyɨm hinda sɨma sɨma sɨbap whaowaeyamiyɨm, ɨni sɨmiir hɨriinan ywowɨm. ");
INSERT INTO iws_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Mɨ siya kɨmɨdiniya siir kɨgna mɨriiyɨm kamɨm sɨmiir boɨnki, tɨ iikamɨm sɨma ɨni numɨran sasaeyɨm wai nwowɨm, sɨmiir hɨriinankɨm mɨ mɨiyan inkam homgak karamkɨm sɨmiir nɨngugu haiyɨm. ");
INSERT INTO iws_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mɨ kɨma wɨ numɨran adɨn siiram srɨi. Mɨ iikam nhɨrɨm wɨ siyar nwokɨ ɨkropkiyɨm, tɨ iikamɨm sɨma siirɨm nwokɨ amɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Mɨ Jisɨs siya siir kɨgna mɨriiyɨm kam ɨuur nwɨso sɨmiiram yɨkɨuna mɨ sɨma ɨrɨpa ha nwowɨm mɨ siya sɨmiirɨn kɨrɨeya uridyɨu bibiyɨeyɨm sɨm nɨnɨmnɨskiiya mɨ mapai mapai mɨnɨm sɨm mɨ haiswonɨmnɨskɨiiya ɨna hauugiya sɨmiir. ");
INSERT INTO iws_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aposel kam ɨuur kwɨso sɨmiir inɨgɨm hɨnɨɨn hɨnɨɨngɨm. Bɨigɨ bɨiyanɨn Saimonkɨn mɨ siir inɨg whɨrɨn, Pitakɨn mɨ siir nomousɨmɨn Andrugɨn mɨ Jems Sebedini yɨnisɨmɨn mɨ siir nomousɨm ɨeya, Jon ");
INSERT INTO iws_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","mɨ Pilip Batolomiyu mɨ Tomas mɨ Matyu mɨ kara, inkamɨn omom omomi umɨr haiiyɨn mɨ Jamisɨn Alfiasni yɨnisɨm ɨkɨn mɨ Tadias ");
INSERT INTO iws_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","mɨ Saimonɨn bɨiya ta yaiya saiir boɨnmamauugɨn nu whɨran inkam komiiyɨm krɨmiir kɨpi kɨgrɨrao. Judas Iskariot, inkamɨn wɨr Jisɨs siir napwouwɨn, siir sau omomɨn siir. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisɨs siya tɨ kam ɨuur nwɨso sɨmiir nɨkropkiyɨm mɨ siya sɨmiirɨn hɨnɨɨna boɨnki, kɨma wɨ ɨkɨ Juda iikam tani sɨmiir nu maeyau ɨmiir kɨpi nam. Mɨ kɨma wɨ Sameria sɨmiir om komii komii ɨmiir kɨpi nam. Nɨɨngaka! ");
INSERT INTO iws_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kɨma wɨ ɨkɨ Isrel sɨmiir iikamɨm sɨmiirgɨ sɨmiiramar dam! Sɨma ɨni sibsibɨm inkamkɨ kɨgrɨrao karam nwowiyɨm sɨma sɨma prɨiyap whaowaekaeyamiyɨm ɨni sɨmiir hɨriinan ywowɨm. ");
INSERT INTO iws_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kɨma nami mɨ kɨma wɨ hɨnɨɨna dowomwarkaiyɨuwam sɨmiirɨn, ɨiya Adi Komii siya siir digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana kingiin bɨdi yɨnyaniya. ");
INSERT INTO iws_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Kɨma ɨkɨ makak makak iikamɨm sɨmiir dɨnɨmnɨskiiyam mɨ iikamɨm naokaowɨm, sɨmiir warar hɨdnɨnsiin ɨdwowam mɨ iikamɨm paowaigɨ pɨskomkopouwɨm sɨmiir wara haiswonɨmnɨskɨiyam. Mɨ uridyɨu bibiyɨeyɨm sɨmiir warar dɨnɨmnɨskiiyam. Ta kɨrɨeya whɨsarii kara hauuwa mɨ kɨma iikamɨm sɨmiirɨn nɨɨnga nɨɨnga prɨidirɨraerar haigɨnɨu. Mɨ kɨma wɨ umɨr kɨpi swokɨ hai saiirsiyɨn. ");
INSERT INTO iws_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mɨ kɨma umɨrɨm nɨbnau kɨpi haiginam. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mɨ ɨiya kɨma napnami mɨ naeyɨm wɨ nɨbnau kɨpi haiginam. Kɨma yaeya yɨuɨs kɨpi hainam! Nɨɨgaka, nɨɨngar dam! Kɨma iikamɨm sɨmiir whɨndiraeraram nami, kɨmiirɨn nae mɨnɨm wɨ sɨmar hauuwi. ");
INSERT INTO iws_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Mɨ kɨma om komii mɨ omisɨm whɨr napnɨnopkainami mɨ kɨma wɨ sɨbgu kɨgrɨrao hɨran iikam mɨiyɨk mɨiyɨk ɨmiirɨn, kɨmiirɨn wɨ sɨma kɨgrɨraowi mɨ kɨma tɨ hɨriinan kamɨm sɨmakar dwokrɨpkai. Mɨ tɨ om ɨiirɨn wɨ sɨmiir hɨrankar nhɨɨnam. ");
INSERT INTO iws_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mɨ kɨma omaka ɨra nami mɨ kɨma omakaɨn iikamɨm sɨmiirɨn hɨnɨɨna boɨn kɨmiir mhɨi kwonɨm hiinsɨma dwo. Adi Komii siya wɨ kɨmakar nwowi. ");
INSERT INTO iws_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mɨ ta omaka saiir hɨran iikamɨm sɨma kɨmiirɨn wadɨe nwowɨni mɨ Adi Komii siya wɨ kɨmiirar whɨndirɨraerari. Sɨma kɨmiirɨn wadɨe nwo karamae nwowi mɨ ta yai mɨiyɨka wa swokɨ ɨti kɨmiiramar mɨ Adi Komii siya wɨ sɨmiir whɨndirɨraerar tani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mɨ inkam nwɨrkɨ kɨmiir nɨkɨunam karamae nwowi siir omaka. Mɨ siya kɨmiir yai mɨiyɨk aiir wakaeyona karamae nwowi mɨ kɨma ta omaka mɨ om ɨkɨn, siirɨn ha timɨ haiburgig. Mɨ nusɨnɨm kɨmiir ɨgaɨm kɨma niiyɨm sɨmiir nwowɨm, yɨm hɨrar dɨkrɨmkrɨnkiigig sɨmiir nɨisiimauuwam Adi Komii siya hɨkakɨn. ");
INSERT INTO iws_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kara kɨmiirɨn yai mwowar boɨnkii ta ɨiya tɨ iikamɨm tɨ om komii siirɨm kɨmiir boɨnwokiyop natkaigiyana, wɨ om komii Sodom mɨ om Gomora sowiir hɨriinan hɨk hauuwi rani. Nɨɨngaka. Ya ta hɨriinana ya wɨ komiigɨ komii nwowi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Wakae, kara kɨmiirɨn wɨ sibsibnan nɨkrɨropkii, ɨkɨ niimauan wra biyɨeyɨm sɨmiir hɨndaɨm. Mɨ wra biyɨeyɨm sɨma wɨ kɨmiir naeyamar mɨ naɨngwowi. Mɨ dimɨnɨm kɨma tɨram naɨngwowɨm kɨma sɨbgu hɨdnam, ɨtɨn wraisuɨm kikaikaowiyɨn siir hɨriinan kɨmiir siyɨuɨm ɨkɨ iikamɨm sɨmakan hiinsɨm hiinsɨma dwo. ");
INSERT INTO iws_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kɨma ɨkɨ iikam biyɨeyɨm sɨmiirsi ha timɨ mɨntarao. Kɨmiirɨn wɨ sɨma boɨnwokiyopnatkaigi sɨmiir kaunsil ɨmaka. Mɨ sɨma kɨmiirɨn omakam yaimɨn dimɨn nɨdwokai wakaeiyɨm, wɨ sɨmiir hɨr nɨpɨmpari ɨdgɨuni. ");
INSERT INTO iws_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mɨ wɨ sɨma nɨkɨunami kɨmiirɨn inkam komiiyɨm omom omom nhɨrɨm sɨm kɨgrɨraowiyɨm sɨmiiram. Dimusi rani, kɨma kariir yai aiir wakaeyoknakɨm. Kɨma kariir yaiya ɨkɨ inkam komii komiiyɨm mɨ iikamɨm Juda iikam tani sɨmiir warar boɨnmɨmauugɨm. ");
INSERT INTO iws_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mɨ ɨiya sɨma kɨmiir boɨnwokiyopnatkaigiyɨm nɨkɨunami. Mɨ kɨma wɨ hɨnɨɨna kɨpi naɨngwoyɨmiyok ɨdid boɨn. Krɨma yai mɨnɨm wɨ panɨɨn panɨɨna boɨni? Nɨɨngaka. Mɨ ta ɨi aiirarɨn yaiya kɨma boɨnam tɨrɨm, kɨmiirɨn yaiyɨm wɨ Adi Komii siya boɨnmamauu haigɨnɨugi. ");
INSERT INTO iws_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mɨ tɨ yaiyɨm wɨ kɨmar boɨn tani. Nɨɨngaka. Kɨmiir Adi Komiiyɨn siir naeyɨuɨn kɨmiirɨn wɨ siyar hɨurworwokai boɨnkii. ");
INSERT INTO iws_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Mɨ yaowaeyɨn wɨ siir nomousɨm ɨiirar kɨnmauuwi mɨ siirɨn wɨ sɨma nɨsomaowi. Mɨ adɨn wɨ ɨriipɨ hɨriinana mɨ kɨnmauuwi siir yɨnisɨm ɨiirɨn kam nhɨrɨm sɨma nɨsomaowɨm. Mɨ yɨnisɨmɨm yɨm wɨ sɨmiir yopii ad ɨmiirar mɨ kɨnmauuwi mɨ kam nhɨrɨm sɨma mɨ ɨsomsom aokaokiyɨm. ");
INSERT INTO iws_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mɨ iikam whɨekakɨm wɨ kwoɨn biyɨe kɨmiiram naɨngwowi. Dimusi rani, wɨm kɨma kariirgɨm mɨ inkamɨn kariir mɨi aiirar nikɨ mɨriikrɨpkaii. Mɨ saiir haiburgig karamae nwowi mɨ dimɨn taemɨnɨm kɨmiir nɨbiyami mɨ mhoɨiya kɨmiirɨn wɨ Adi Komii siya nanmaiwarkainaei. Mɨ siyakar nwoyokiyokɨikaiyami, ɨinokɨinokɨn. ");
INSERT INTO iws_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mɨ ɨiya iikam biyɨeyɨm om whɨranɨm sɨma hɨk kɨmiir hauuwi mɨ wɨm kɨma om whɨra timɨ ɨdamki. Mɨ ɨiya iikam biyɨeyɨm tɨ omɨn siir hɨranɨm, sɨma hɨk kɨmiir hauuwii mɨ kɨma ha timɨ ɨdamki om whɨra. Kara kɨmiirɨn yai mwowar boɨnkii, kɨma kɨmiir mɨiyɨm wɨ nikɨ dɨgi rani, Isrel sɨmiir om ɨmiirɨn. Nɨɨngaka. Wɨ hɨriiyar kɨgwɨni. Ɨiya kara Yaowae Adɨn nɨnomor kauankɨ nɨtɨn siya nɨtana saiirɨn. ");
INSERT INTO iws_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Yɨnisɨmɨn siya inkamɨn siir nɨisiisiimauuwiyɨn siir bɨ haiburikɨn. Mɨ mɨiyan inkamɨn siya siir bɨiyan inkamɨn siir bɨ taouugaeikɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Mɨ yɨnisɨmɨn siya siir nɨisiisiimauuwiyɨn inkamɨn siir hɨriinanar timɨ maɨrgɨmaɨrga. Mɨ ɨriipɨ hɨriinan mɨi mɨrii inkamɨn siya siir bɨiyan inkamɨn siir hɨriinanar timɨ maɨrgɨmaɨrga. Mɨ sɨma kariirɨn tɨ hɨriinan inɨg biyɨe ɨiir dapi Bielsebul mɨ kara wɨ kɨmiir adnan nwowi. Mɨ wɨm kɨma wɨ kariir yɨnisɨmnan nwowi mɨ sɨma kɨmiirɨn wɨ tɨ hɨriinan inɨg biyɨe ɨiirar mɨ dapi, Bielsebul. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Mɨ kɨma tɨ iikam biyɨeyɨm sɨmiirsi kɨpi nɨdid. Digworaekwo whɨekakɨm ɨkɨ aowa aowa nwokiyamɨm, mhoɨiya wɨ idowɨiyar nwokii. Mɨ nɨmprɨo yaiyɨm mhoɨiya iikam whɨekakɨm wɨ sɨmar wakaei mɨ ta yaiya wa haigirɨrɨrami. ");
INSERT INTO iws_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mɨ yaiyɨm nɨiyɨɨm nɨiyɨɨm kara boɨnɨm tariinanɨn iikamɨm sɨma wakae karam nwowi mɨ mhoɨiya kɨma sɨmiirɨn wɨ idowiya boɨnmɨmauuwi. Mɨ sɨma wa wakaei. Mɨ yaiyɨm, wɨɨnara kɨma wakaeyɨm kɨma sɨmiirɨn wɨ omaka akou hɨr tamɨ okwo boɨnmɨmauugi hɨnda tɨnda. ");
INSERT INTO iws_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mɨ kɨma ɨkɨ iikamɨm pɨu aiirara nɨsomaowiyɨm sɨmiirsi kɨpi naɨngwo ɨdid. Dimusi rani, sɨma kɨmiir kwoɨnbudɨn wɨ siir wara nonkwobumbunɨnkɨn tani. Nɨɨngaka. Mɨ kɨma Adi Komii krɨmiir Wanɨn siirsi arar daɨngwoyɨmyok. Siya kɨrɨekakɨn, maeyauwa paeya nɨutɨngi karamaeya saeya nwowa, ya nɨkrani, pɨu mɨ kwoɨnbudɨn wɨ saeya nonkwonɨɨnwomwɨɨrnɨnkɨni. ");
INSERT INTO iws_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Mɨ kɨma iikamɨm ɨpiyɨn yɨnisɨsɨm ɨso umɨr kwɨruwa, sɨma pɨ saiirarar saɨni. Mɨ ɨpiyɨn sɨm ɨra saeya nɨkii ɨsomaowi. Adi Komii siya kwoɨnkakaɨrgɨn siirɨn, siya ɨna nɨnoknɨnkɨnɨn. ");
INSERT INTO iws_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Mɨ wara kɨmiir kanmaiyɨm yɨm Adi Komii siya bɨdi mwan dɨgɨm. Siya ɨna nɨnoknɨnkɨnɨn sɨmiirɨn. Mɨ dimɨn sɨsɨmɨm sɨmiirɨn ɨni warar mɨ ɨnoknɨnkɨnɨn. ");
INSERT INTO iws_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mɨ kɨma wɨ hɨriinanɨm sɨmiirsi kɨpi nɨdid. Kɨma ɨni ɨpiyɨn sɨsɨm whɨekakɨm sɨmiir haiburɨm. Mɨ Adi Komii siya kɨmiirɨn wɨ hɨriinasi kɨgrɨraowi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Mɨ inkamɨn kariir inɨgɨn ɨkɨ iikam nhɨrɨm sɨmiir whwonkam ɨda boɨnmɨmauuwi mɨ an kara wɨ hɨriiyar mɨ tɨri sɨmiir inɨgɨm wɨ kara mɨ boɨnmauuwi kariir Adi Komiiyɨn nɨnomor kou hɨr nwowɨn siir whwonkam ɨda. ");
INSERT INTO iws_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mɨ iikamɨm kariirɨn digɨumii haimriyɨuwi ɨkɨ iikam nhɨrɨm sɨmiir whwonkam ɨdaɨn. Mɨ an kara sɨmiirɨn wɨ hɨriiyar mɨ tɨri, kariir Adi Komiiyɨn nɨnomor kou hɨr nwowɨn siir whwonkam ɨdaɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Kɨmiir kwoɨnɨm ha naɨngwokɨm kara tɨ yaii digworaekwowɨm iikam sɨmiirɨm nu tɨranɨm sɨmiir nauunɨ mɨnwokmainiyam nɨtkɨn ɨrɨpa sɨma nongwomamaɨr aeyam, ha? Nɨɨngaka. Mɨ ta kara nɨt aiirsiyɨn isidɨn wɨ whɨsa nɨnkibɨɨrnaei. ");
INSERT INTO iws_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kara wɨ ɨo nɨnwo anwowi siyɨuɨn siirɨm nɨti. Mɨ yɨnisɨm yɨnkamiyɨnɨn yɨo wɨ ɨo siir ad ɨiirar swokɨ kwowi. Mɨ yɨnisɨm yɨnugiyɨna ya wɨ ɨo saiir yopii aiirar swokɨ kwowi. Mɨ yɨniwignana ya wɨ ɨo saiir giwai aiirar swokɨ kwowi. ");
INSERT INTO iws_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mɨ omaka ɨruwan iikamɨm, wɨ ɨo sɨma sɨma swokɨ ɨnwo anwowi. ");
INSERT INTO iws_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Mɨ iikamɨm sɨmiir bɨiyan kwoɨnɨn yopii ad mɨ yɨnisɨsɨm sɨmiiraramar naɨngwowi mɨ sɨma kariiram naɨngwo karamae nwowi mɨ sɨma wɨ kariir yai aiir wakaeyokna wao rani. Mɨ sɨma wɨ kariir mɨi kɨgna mɨriiyan nwo rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Yɨpɨkɨ iikamkɨm kariirɨm nwokwokɨn karamae nwowɨm mɨ kariir mhoɨiya nɨt karamae nwowɨm mɨ sɨma paeyɨn hɨiniya nɨrɨonɨnkɨnɨn siir nao karamae nwowi o siir naoka wɨndi sɨma kariir mhoɨiya nɨt karamae nwowi mɨ sɨma wɨ kariir mɨi kɨgna mɨriiyan iikam nwo rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mɨ iikamɨm sɨma sɨmiir pɨu aiirsiyar haiyɨdid naɨngwoyɨmiyoknaeyɨm tɨ hɨriinan iikamɨm sɨma wɨ Adi Komii saɨka nwo rani. Nɨɨngaka, nɨɨngaka. Yɨpɨkɨ iikamkɨ inkamkɨ nɨsomaowi sɨmiirɨn dimusi rani, sɨma kariir yai aiir wakaeyoknakɨm. Mhoɨiya sɨma wɨ Adi Komii saɨka nwowi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Mɨ inkamɨn kɨriir sɨbgu kɨgrɨraowi, yɨo siya kariir warar mɨ kɨgrɨraowi. Mɨ inkamɨn kariir kɨgrɨraowi mɨ yɨo siya Adi Komiiyɨn kariir nɨkropkiyɨn siir warar mɨ ɨnkɨn kɨgrɨraowi. ");
INSERT INTO iws_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mɨ inkamɨn profet inkamɨn siir whɨndiraerari. Dimusi rani, siya ɨna nɨnoknɨnkɨnɨn siya profet inkamkɨn. Mɨ wɨ Adi Komii siya hauuwi dimɨn mɨiyɨk siirɨn. Mɨ tɨ profet inkam ɨiir warar. Yɨpɨkɨ inkamkɨ, inkam mɨiyɨkɨn Adi Komii siir yai aiir wakaeyoknaeiyɨm. Dimusi rani, siya inkam mɨiyɨkɨn. Mɨ wɨ Adi Komii siya hauuwi dimɨn mɨiyɨkɨn siir mɨ tɨ inkam mɨiyɨkɨn siir warar. ");
INSERT INTO iws_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kɨma ta yaiya saiirɨn daɨngworɨnukrɨpkai, yɨpɨkɨ inkamkɨn kariir kɨgna mɨriiyɨm kamɨm inɨg karamaeyɨm sɨmiirɨn dimɨn sɨm whɨra whɨndirɨraerar haigɨnɨuwi op mobsɨmnan. Whɨsarii rani, sɨma kariir yai mɨiyɨk aiir wakaeyoknaeikɨm. Mhoɨiya siirɨn wɨ Adi Komii siya hauuwi dimɨn mɨiyɨkɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisɨs siya tɨ mɨini yaiyɨm siir kɨgna mɨriiyɨm kam ɨuur nwɨswo sɨmiir boɨnmɨmauu dɨgiyɨm mɨ siya sɨmiirɨn ɨna yɨkropkiyɨn hɨnda tɨnda. Mɨ mhoɨiya siya ta maeyau aiir haiiburgik mɨ siya iikamɨm sɨmiir boɨnmɨmauuwam omom siir om kingiin nwowɨm sɨmiir. ");
INSERT INTO iws_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Mɨ ta ɨi aiirɨn Jon siya maeyauwa hɨuyokyokaiya mɨi biyɨe mɨriiya saiir hɨrar nikɨ owɨn mɨ siyar wakaewɨn mɨi whɨekakɨm Krais inkamɨn Adi Komii siya nɨkropkiyɨn siya mɨriiyɨm. Mɨ Jon siir mɨi kɨgna mɨrii kam nhɨrɨm Jisɨs siiramɨn hɨriinansi nɨkropkikɨn. ");
INSERT INTO iws_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Mɨ sɨma ha napnɨmbiyamɨm Jisɨs siir hɨriir sɨma siir srɨigi mɨ kɨra tari tɨ inkamɨn nɨtam boɨnɨn Jon siya, siya, iyɨe? Krɨma yaeya inkam nwɨram tɨ okwokɨn, aniya? ");
INSERT INTO iws_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jisɨs siya sɨmiir yai aiir yowarkɨi boɨn, kɨma Jon siir boɨnɨu digworaekwo whɨekakɨm kɨma wakaeyɨm mɨ kɨma kɨgɨm sɨmiir. ");
INSERT INTO iws_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nhwokwɨsae iikam sɨmiir nhwowɨm ɨna swokɨ kaowɨrɨrkiyɨm mɨ ɨga biyɨeyɨm ɨna swokɨ aprɨrɨrkiyɨm. Mɨ ma biyɨeya ɨga ɨɨn naonɨnsɨmsɨrɨuwiya ɨni wadɨeya swokɨ okiyɨm. Mɨ wɨɨngɨrwɨi nwowɨm ɨna swokɨ wakae omokiyɨm mɨ iikamɨm paowaigɨ pɨskomkopou aokaowɨm mɨ iikam paeprikabɨm. Adi Komii siir yaiwɨn kɨbi aiirɨn ɨna wakaeyɨm. ");
INSERT INTO iws_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mɨ yɨpɨkɨn inkam nwɨrkɨn siya kariiram naɨngwo tɨbmii inkamɨn Adi Komii siya nɨkropkiyɨn karaɨrgɨn Yaowae Adɨn. Mɨ siya sɨbgu okworɨnu krɨpkaii mɨ ha sɨbgu ɨdwowi siya ha maɨrgɨmaɨrga Adi Komii siir yaiwɨn kɨbi aiirɨn ɨna wakaeyɨm. ");
INSERT INTO iws_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Mɨ Jisɨs siya yai ha boɨn dɨgiyɨn, Jon siir kɨgna mɨrii kamɨm ɨna yamkiyɨm. Mɨ mhoɨiya Jisɨs siya iikamɨm sɨmiirɨn hɨnɨɨna boɨn Jon siirɨn, bɨiya kɨma maeyau nu siin apa nɨɨnga saiir namɨm mɨ kɨma dimu dimɨn ninɨ kɨgɨukɨm, ha? Mɨ kɨma inkamɨn yai krɨpiinaniikiigiyɨn au whɨrɨn opudgɨ hugswoswowiyɨm siir kɨgɨm, iyɨe? Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mɨ nɨɨngaka nɨuwi kɨma dimu dimɨn komii kɨgam namkɨm, ha? Mɨ kɨma tari inkam nwɨrɨn yɨuɨs mɨiyɨk niiyɨn siir kɨgam namkɨm, ha? Iyɨe? Nɨɨngaka. Mɨ iikamɨm hɨriinan yɨuɨs mɨiyɨk mɨiyɨkɨm sɨmiir niiyɨm yɨm inkam komiiyɨm nu kɨgrɨraowiyɨm sɨmiir omaka hɨrar nwowikɨm. ");
INSERT INTO iws_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mɨ nɨɨngakɨnɨuwi kɨma dimu dimɨn kɨgam namkɨm, ha? Kɨma profet inkam siir kɨgam namkɨm, aniya? Ɨhɨ, kara kɨmiir boɨnmauuwi siya inkam komiikɨn inɨgkakɨn mɨ siya ɨni profet kamɨm sɨmiir haiiburɨm. ");
INSERT INTO iws_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tɨ inkamɨn siyaɨrgɨn Yokwo Komii saeya boɨnɨn, wakae, kara Adi Komiiyɨn wɨ inkam nwɨrɨn siir nɨkropki kariir yaiya saiir boɨnmɨmauuwam mɨ kɨriir bɨiyɨn wɨ siya namkwokɨni. Mɨ kɨriir kwoɨn ɨiirɨn wɨ siyar kisɨsop haigikwokɨni iikamɨm sɨmiirɨn. ");
INSERT INTO iws_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kara kɨmiirɨn yaimwo aiirar boɨnki, Jonɨn op baptais haiigɨnɨuanɨn ɨni kam whɨekakɨm nu tɨr nɨmbiyamɨm ɨni sɨmiir haiiburɨm. Bɨiyan ɨkɨm mɨ tariinanan ɨkɨm yɨpɨkɨn iikamkɨm kariiram naɨngwo tɨbmiiyɨm mɨ iikamɨm Adi Komii siya kɨgrɨraowiyɨn sɨma nwowɨn siya paeprigab inkamɨn inɨg karamaeyɨn siir hɨriinan ywowɨn. Tɨ hɨriinan inkamɨn siya ɨni Jon siir haiiburɨn. ");
INSERT INTO iws_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Mɨ ɨiya Jonɨn op baptais haiigɨnɨuanɨn siya boɨnmɨmauuwa ha nɨtyokiyokɨiya mɨ tɨsi tariinanar nadɨgniya. Maeyauwa Adi Komii siya siir digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana saiir. Mɨ ta ɨiya iikamɨm yaii nɨnii nansaowɨm mɨ ɨni yaii komiiyar ywowɨm mɨ ɨna yɨnɨnswomswo ta hɨriinan saiirsi, sɨma Adi Komii siyar kɨgrɨraowɨm iikamɨm sɨmaka ɨrɨpa nwowɨm. ");
INSERT INTO iws_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mɨ profet kam whɨekakɨm Moses siya bɨiya sɨma wɨnɨm Yokwo Komii saiir, Jonɨn wɨ sɨpi nɨti. ");
INSERT INTO iws_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Mɨ kɨma ta yaiya saiirɨm daɨngwo tɨbmii, wakae, Jonɨn Ilaija siya sɨma boɨnɨn tɨ inkamɨn wɨ siya swokɨ ɨti. ");
INSERT INTO iws_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Inkamɨn wɨɨngakaɨrgɨn siya wakae ta yai aiirɨn. ");
INSERT INTO iws_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Kara iikamɨm ta ɨii aiir nwowɨm tariinan tɨ nu ɨiir wɨ dimu dimɨn nɨkrii, ha? Sɨma ɨni yɨnisɨm sapɨsapɨm maeyauwa nae haigɨniya saiir nɨdwowiyɨm mɨ ha gwowiyɨm ɨni sɨmiir hɨriinan yowɨm mɨ sɨma yɨnisɨm nhɨrɨm sɨmiirɨm pɨ hɨnɨɨna kauwoki, ");
INSERT INTO iws_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","krɨma kɨdɨɨbɨm kɨmiirɨmar huni, kɨma mwai wao rani, krɨma tɨsa nouuboponɨm mɨ kɨma wara nou rani. ");
INSERT INTO iws_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jon siya ha nɨtɨn mɨ siya nae mɨ op wainmɨn bɨ naekwiyaekɨn mɨ sɨma boɨn, uridyɨu biyɨeyɨn ɨni siir hɨr nwowɨn. Mɨ kɨma siyaka bɨ maɨrgɨmaɨrgakɨm. ");
INSERT INTO iws_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mɨ kara Yaowae Adɨn nɨnomor kouanɨn ha nɨtɨn mɨ kara nae op mɨnɨm ɨna inɨ aekwiyaeniyɨm mɨ sɨma ɨna boɨnɨm, kɨgi inkamɨn naenanaeiyɨn hɨnɨɨngɨn mɨ siya op wain whɨekak kwiyae kɨrɨekɨn. Kamɨm omom omomi umɨr haii ɨkɨm mɨ dimɨn biyɨe tɨri ɨkɨm siya sɨmiir nomiiyaugɨn, Adi Komii siir mɨiyɨm siya krɨriir nɨisiimauuɨm, krɨra bɨdi mɨriiyɨm mɨ kɨma krɨraka maɨrgɨmaɨrga nwo rani, Adi Komii siya digworaekwo whɨekakɨm sɨmiir bɨdi yɨnoknɨnkɨn dɨgɨm mɨ krɨmiir warar, tɨ dimɨnɨm krɨma boɨnmɨmauuwɨm sɨmiirsi. ");
INSERT INTO iws_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Mɨ om komii nhɨrɨm Jisɨs siya dimɨn kɨrɨe komii komii nhɨrɨm sɨmiir haiswonɨmnɨskɨigɨn mɨ sɨmiir mhɨi kwoɨnɨm bɨ kisɨna haiigigɨm. Mɨ ta ɨi aiirɨn Jisɨs siya ɨo sɨmiir asi nwokɨn. Dimusi rani, sɨma siir mhoɨiya bɨ namkɨm mɨ siir yai aiir bɨ wakaeyoknakɨm. ");
INSERT INTO iws_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Mɨ siya ɨna kauwaeyɨmiyok boɨnɨn. Haei! Om Korasinan mɨ om Betsaidan iikamɨm kɨmiirsi naɨngwoyɨmiyoki. Mɨ tɨ dimɨn kɨrɨe komiiyɨm krɨra tɨrɨm kɨmiir. Mɨ krɨra om Taia mɨ om Saidon sowiir hɨran iikamɨm sɨmiirɨn hɨriinan haiswonɨskigɨswo sɨma sɨnɨn bɨdi bɨdiniyar pɨ masɨn, sɨma ha pɨmɨ aɨngwo tɨbmii Adi Komii siir nɨisiimauuɨm sɨma dimɨn biyɨekakɨm. Mɨ wɨm nɨɨngaka, hɨriinan siyɨu bɨ tɨrkɨm. Nɨɨngakɨ, nɨɨngakɨɨnga. ");
INSERT INTO iws_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mɨ kara kɨmiirɨn yaimwowar boɨni, iikamɨm sɨmiir boɨnwokiyop natkaigi Adi Komii siya, om Taia mɨ om Saidon sowiir hɨran iikamɨm wɨ hɨk komiiya hai. Mɨ kɨmiirɨn wɨ hɨk komiigɨ komii aiirar hauuwi. ");
INSERT INTO iws_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mɨ kɨma iikamɨm om Kapaneamanɨm, kɨma hɨnɨɨna naɨngwowi Adi Komii siya kɨmiirɨn iikam mɨiyɨka kɨgɨm, aniya? Nɨɨngaka. Adi Komii siya kɨmiirɨn wɨ dimɨn biyɨe tɨran iikam nɨkɨuwi. Mɨ siya kɨmiirɨn wɨ maeyau paekaka saiir nɨtkaigi mɨ kara om Sodom siir iikamɨm sɨmiir hɨriinan kɨrɨe komii komiiyɨm sɨmiir tɨrkɨswo tɨ dimɨn hɨriinanɨm sɨmiir, iikamɨm sɨma wa pɨ kisɨna haigi mɨ tɨ omɨn wa pikɨ owɨn. ");
INSERT INTO iws_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kara kɨmiirɨn yaimwowar boɨni, mhoɨiya Adi Komii siya iikamɨm sɨmiir boɨnwokiyop natkaiyana wɨ taka hɨka Sodom siya haiya saiir haiburi mɨ wɨm kɨma wɨ hɨk komiigɨkomii aiirar haii. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mɨ ta ɨi aiirɨn Jisɨs siya hɨnɨɨna kwɨs boɨnkɨn, Adi Komii kɨra nu mɨ nɨnomor sowiir bɨiyan inkamkɨn. Kara kɨriir boɨn wadɨeki, kɨra tɨ kɨriir dimɨn taemɨnɨm sɨmiir haiigiprakaigi inkamɨm nɨnoknɨnkɨn komiikakɨm sɨma nɨnoknɨnkɨnisi. Kɨra ta nɨnoknɨnkɨna iikamɨm inɨg mɨ nɨnoknɨnkɨn komii karamaeyɨm sɨmiir hauuga. ");
INSERT INTO iws_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ɨhɨ, Adi Komii, kɨriir kwoɨnɨn hɨriinanargɨn. ");
INSERT INTO iws_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kariir Adɨn siya digworaekwo whɨekakɨm kariir ɨɨn bɨdi yonkwo hauugiyɨn. Kara kɨgrɨraowɨm. Mɨ siir Yɨnisɨmɨn kariir kwoɨn ɨiirɨn inkam nwɨrkɨn nɨnoknɨnkɨn tani, kɨra kariir Adɨn kɨnakɨna nɨnoknɨnkɨn ɨski. Mɨ kariir Adɨn siir kwoɨn ɨiirɨn inkam nwɨrkɨn mɨ nɨnoknɨnkɨn tani, siir Yɨnisɨmɨn kanakana nɨnoknɨnkɨn ɨski mɨ iikamɨm siir yɨnisɨm ɨeyar nɨisiimauuwiyɨm, sɨmasɨma asi nɨnoknɨnkɨni kariir Adɨn siir kwoɨn ɨiirɨn. ");
INSERT INTO iws_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Kɨma iikam whɨekakɨm hɨk kɨmpɨpɨsu haiiyɨm kɨma whɨekak kariirarama wɨt mɨ kɨmiirɨn wɨ mhɨi kwoɨn hiinsɨma mɨ nɨngwomamaɨr wɨ kara nwowaigɨnɨuwi. ");
INSERT INTO iws_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mɨ kɨma kariiram nɨti mɨ kariir yai whɨekak ɨmiir wakaeyoknaei mɨ kara dimɨn mɨiyɨk mɨiyɨkɨm wɨ kɨriir dirɨraerari. Kara inkamɨn yai iikamɨm sɨmiir yai mɨiyɨk ɨmiirɨn hiinsɨma boɨnikɨn. Inkamɨn sau nikwowaisiinaeiyɨn siir hɨriinan. Mɨ kɨma wɨ mhɨi hiinsɨma nwowi nɨngwomamaɨr aei mɨ wɨ wadɨeyar sɨbgu owi. ");
INSERT INTO iws_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Dimɨnɨn kara srɨiiyɨm kɨma tɨrɨm mɨ sɨmiir wakaeyoknam, yɨo hɨkak tani. Mɨ wɨ hɨkak nwo rani, tɨ dimɨn ɨiir tɨrsiyɨn. Nɨɨngaka. Kɨra wɨ maɨrgɨmaɨrgaka nwowi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mhoɨiya Judami ɨi komii kwɨra Sabat pɨu siisiya dimɨn taemɨn tɨr karamae nwowiya Jisɨs siya wit numɨra saiir bopwo hɨriir naprɨokɨinamkɨn. Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma mhɨigɨ naokɨm mɨ witnid nhɨrɨm sɨmiir haii mɨ sɨma ɨna yɨinɨbrombrop aeyɨm. ");
INSERT INTO iws_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mɨ Farisi kam nhɨrɨm sɨma tɨ hɨriinan kɨgɨm mɨ sɨma Jisɨs siirɨn hɨnɨɨna boɨn. Kɨgi, tɨ siyɨu hɨriinanɨn kamɨm kɨriir mɨi kɨgna mɨriiyɨm sɨma tɨrɨn ya Judami ɨi komiiya Sabat dimɨn taemɨn tɨr karamae nwowiya igbid kamiyaugak nwowiya saiir taouugakɨm. ");
INSERT INTO iws_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jisɨs siya sɨmiir boɨn, kɨma niwiiyɨm bɨiya Devid siya tɨrɨm sɨmiir bɨ mwaɨngɨm siir isidɨn sɨma mhɨigɨ naowɨm, aniya? ");
INSERT INTO iws_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Devid siya Adi Komii siir omaka aiir yapnɨnopkainam mɨ naeyɨm Adi Komii siir nɨnkɨn ɨmiiyaeyɨm siya siir kam nhɨrɨm sɨmiir warar yɨnkɨn hauu ae. Moses siir yaiya bɨiya Yokwo Komiini wɨna saiir hɨriinan, prismi bɨiyan kamɨm sɨma sɨma naeikɨm mɨ sɨma yaigak bɨ nwokɨm tɨ naeyɨm sɨma naeyɨm sɨmiirsiyɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mɨ kɨma tɨ yaiyɨm yokwowa Moses siya wɨna saiir nwowɨm sɨmiir siyɨu ɨmiir bɨ mwaɨngɨm mɨ pris sɨmiir mɨiyɨm mɨ maeyauwa hɨuyokiyokaiya nae nɨnkɨn ɨmiiyaeiya Judami ɨi komiiya Sabat pɨu siisiya dimɨn taemɨn tɨr karamae nwowiya saiir, aniya? Judami ɨi komiiya Sabat pɨu siisiya dimɨn taemɨn tɨr karamae nwowiya pris kamɨm sɨma wara bɨ siisikɨm mɨ sɨma dimɨn biyɨe bɨ tɨrkɨm. Nɨɨngaka. Pɨu siisiya dimɨn taemɨn tɨr karamae nwowiya pris sɨma pɨu bɨ siiskɨm mɨ sɨma dimɨn biyɨe bɨ tɨrbugɨm. Nɨɨngaka. Adi Komii siir digworaekwowɨm yɨm ɨni ta Judami ɨi komiiya Sabat pɨu siisiya dimɨn taemɨn tɨr karamae nwowiya ɨni saiir haibura. ");
INSERT INTO iws_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kara kɨmiirɨn yaimwowar boɨni. Tɨ dimɨnɨn nwowɨn ɨni omaka Adi Komii siir inɨg hainaniya ɨni saiir haiburɨn. ");
INSERT INTO iws_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mɨ kɨra tɨ yaiyɨm Adi Komii siir Yokwo Komii saeya boɨnɨm sɨmiir sɨbgu nɨnoknɨnkɨni mɨ kɨma wɨ ɨkɨ iikamɨm dimɨn biyɨe tɨrbu karamaeyɨm ɨo sɨmiir kɨpi nwo. Adi Komii siir yaiya hɨnɨɨna boɨnka, kara hɨnɨɨna naɨngwowi kɨma iikamɨm sɨmiirsi daɨngwobumbu. Tɨ hɨriinan siyɨuɨn ɨni wraisuɨm kɨma nɨnkɨn ɨmiiyaeiyɨm kariir ɨni sɨmiir haiburɨn. ");
INSERT INTO iws_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kɨmiirɨn hɨriinan dimusi boɨn tani, kara Yaowae Adɨn nɨnomor kouwonɨn Judami ɨi komiiya Sabat pɨu siisiya dimɨn taemɨn tɨr karamae nwowiya saiir Bɨiyan Inkamɨn karargɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Mɨ Jisɨs siya ha boɨn dɨgiyɨn mɨ siya ta maeyau aiir haiburgigɨn mɨ ɨna yamɨn sɨmiir omaka Adi Komii siir yai nɨdwo wakaeiya saiiram. ");
INSERT INTO iws_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mɨ inkam nwɨrɨn hɨr nwokɨn mɨ siir nɨimwo waeyaowɨm bɨdi yaonɨnsɨmsɨrɨuwɨm. Kam nhɨrɨm sɨma Jisɨs siir boɨnwokiyop natkaigiyam naɨngwowi, Moses siya wɨnɨm dimɨnɨm bɨiya sɨmiirsi. Mɨ sɨma siirɨn hɨnɨɨna srɨi, Moses siir siyɨuɨn igbid kamiyaugak bɨdi ywowɨn makak inkamɨn siirɨn wɨ ɨi komiiya pɨu siisiya Sabat saiirar haiswonɨski, aniya? Iyɨe? ");
INSERT INTO iws_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Mɨ Jisɨs siya sɨmiir boɨnki mɨ inkam nwɨrɨn kɨmiir bopwo waraur nwowɨn siya sibsib ɨrkakɨ nɨuwi mɨ tɨ sibsibɨn Judami ɨi komiiya pɨu siisiya Sabat dimɨn taemɨn tɨr karamae nwowiya ɨenau saiir ninɨwarkainami mɨ tɨ inkamɨn siir sibsibɨn pɨ koua tɨriirar nonkwokiyɨtkɨnki, iyɨe? Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mɨ iikamɨm krɨma ɨni sibsibɨm sɨmiir haiburɨm, sibsibɨm yɨm dimɨn komii rani. Mɨ Judami ɨi komiiya pɨu siisiya Sabat dimɨn taemɨn tɨr karamae nwowiya krɨma saiirɨn wɨ hɨriiyar whɨndirɨraerari iikamɨm makakɨm sɨmiirɨn. ");
INSERT INTO iws_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Mɨ Jisɨs siya tɨ inkam ɨiir boɨnki, kɨriir ɨɨnib waeyaowɨm kɨnanwomwokaigi mɨ siir ɨɨnib waeyaowɨm ɨna kɨnanwomwokaigiyɨn mɨ siir ɨɨnib waeyaowɨm ɨni wadɨeyar swokɨ sɨbgu okiyɨn ɨɨna kwɨra saiir hɨriinan. ");
INSERT INTO iws_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mɨ siya hɨriinan tɨrkiyɨn Farisi kamɨm ɨna nhɨɨnamɨm mɨ maeyau kwɨrua yahaɨngiriyɨu ɨmprɨo boɨnaiyɨu Jisɨs siir nɨsomaowam. ");
INSERT INTO iws_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisɨs siya tɨ dimɨnɨn sɨma tɨram mɨnɨm siir, sɨmiir bɨdi yɨnoknɨnkɨnɨn mɨ tɨ omɨn siirɨn hɨriinansi haiburgigɨn mɨ siya ɨna yamɨn. Mɨ iikam whɨekakɨm makakɨm sɨma ɨni siir mhoɨiyar yamɨm, sɨmiir haiswonɨmnɨskɨiyamɨn. ");
INSERT INTO iws_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Mɨ Jisɨs siya sɨmiir yɨkɨduki siir inɨgɨn ɨkɨ iikam nhɨrɨm sɨmiir kɨpi boɨnmɨmauu, dimɨnɨm siya tɨrkiyɨm sɨmiirɨn. ");
INSERT INTO iws_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Mɨ siya tɨ dimɨnɨm ta Adi Komii siir yaiya bɨiya profet Aisaia siya wɨna saiir nɨnkɨn boɨnourwokaigikɨn. Ta yaiya saeya hɨnɨɨna boɨnka, ");
INSERT INTO iws_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","tɨ inkamɨn yɨo kara nɨmbingɨn kariirgɨ kariir mɨiyan inkamkɨn, kara siir bɨdi yɨmbinɨn. Kara siirɨmar naɨngwo ɨski mɨ kariirɨn maɨrgɨmaɨrga siyar hauwi. Mɨ kariir naeyɨuɨn wɨ siir hauugi mɨ wɨ siir whɨnkɨnsiis haigɨnɨuwi. Mɨ siya wɨ iikamɨm hɨnda tɨndaɨnɨm sɨmiir boɨnmɨmauuwam nami kariir kwoɨn mɨiyɨk ɨiir. ");
INSERT INTO iws_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mɨ siya wɨ ɨo yai boɨn tani mɨ ɨɨg yai boɨn tani sɨma siir yaiya wɨ hɨnɨɨna wakae rani mɨ siya wɨ ɨkɨ siyɨuɨm sɨmiir bopwo nokwo kauwokam tani. ");
INSERT INTO iws_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mɨ siya siir iikamɨm kɨrɨe karamaeyɨm auwɨm opudgɨ hugswoswowiyɨm siir hɨriinan nwowi wɨ sɨmiir tɨrbu rani. Nɨɨngaka. Mɨ iikamɨm yɨpɨkɨ dimɨnsi nɨɨmɨmɨɨni yɨm paridsɨmɨn tɨngiyam kingiin nwowɨn siir hɨriinan ywowɨm tɨ hɨriinanɨn Adi Komii siya sɨmiirɨn wɨ paenan nɨuwao rani. Mɨ wɨ ɨiya kariir kwoɨn mɨiyɨkɨn dimɨn biyɨe ɨmiir nikwowaisii ana saiirar nadɨgɨuwi. ");
INSERT INTO iws_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mɨ iikam nhɨrɨm nu whɨekakɨm sɨmiir hɨranɨm sɨma wɨ siirɨm naɨngwo tɨbmii mɨ wɨ siirɨma nwokwokɨni sɨmiir nanmaiwarkainaɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mɨ ta ɨi aiirɨn sɨma inkamɨn nwɨra yɨkɨunani siirɨm mɨ tɨ inkamɨn uridyɨu biyɨeyɨn siir hɨrar nwokɨn. Mɨ siya nhwokwɨsaekɨn mɨ siya ɨni waeyaiya mɨ owɨn. Mɨ siirɨn Jisɨs siya haiswonɨski haigɨnɨugɨn mɨ siya yai ɨna boɨnaigiyɨn mɨ siir nhwoɨn ɨna swokɨ kaowɨrɨrkiyɨn. ");
INSERT INTO iws_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mɨ iikam isid komii whɨekakɨm sɨma ɨni hindara yanaakiyɨm mɨ sɨma boɨn, tɨ inkamɨn Divid siir isidankɨn. Bɨiya, Bɨiyan Inkam Komiiyɨn siya nɨmbinɨn nɨtam tari siya, aniya? ");
INSERT INTO iws_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mɨ Farisi kam nhɨrɨm sɨma tɨ hɨriinan yai wakaeyɨm mɨ sɨma tɨ iikam isid komiiyɨn ɨo sɨmiir ywoki, tɨ inkamɨn siya uridyɨu biyɨe ɨmiirɨn Bielsebul siir kɨrɨe aiirar haiswonɨmnɨskɨii, siya uridyɨu biyɨeyɨm sɨmiir bɨiyan inkamkɨn. ");
INSERT INTO iws_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Mɨ sɨmiir kwoɨnɨm Jisɨs siya ɨna nɨnoknɨnkɨnɨm mɨ siya sɨmiir boɨnki mɨ om whɨruwan iikamɨm sɨma isido whɨsa nɨnkibɨrnaki mɨ yaii sowa sowa nɨnii mɨ tɨ omɨn wɨ mɨiyɨka nwoki, aniya? Nɨɨngaka. Mɨ iikamɨm pɨugan kwɨruwanɨm sɨma isido whɨsa nwowi mɨ yaii sowa sowa nɨnii mɨ ta pɨugana wɨ mɨiyɨka nwowi, aniya? Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Mɨ Setan siya kariir whɨndirɨraerar haigɨnɨuwi uridyɨu biyɨeyɨm sɨmiir haiswonɨskiyam. Mɨ siir isidɨn wɨ whɨsa nɨnkibɨrnaki. Mɨ siya wɨ pakɨ hɨnɨɨn kɨrɨeya sae haiswonɨski, ha? Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mɨ Bielsebul siya kariir whɨndirɨraerari mɨ kara uridiyɨu biyɨeyɨm siir kɨrɨe aiir haiswonɨski mɨ kɨmiir isidɨn sɨmiirɨn wɨ nhɨnga whɨndirɨraerar haigɨnɨuwi, uridyɨu biyɨeyɨm sɨm, aniya? Mɨ Bielsebul? Nɨɨngaka. Mɨ kɨmiirɨn Bielsebul siya whɨndirɨraerar tani uridyɨu biyɨeyɨm sɨmiir haiswonɨskiyɨm. Nɨɨngaka. Tɨ dimɨnɨn Bielsebul siir nɨisiimauugɨn siya kariir bɨ whɨndirɨraerarkɨn. ");
INSERT INTO iws_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Mɨ Adi Komii krɨmiir Wanɨn siir naeyɨuɨn siyar whɨndiraerari mɨ kara uridyɨu biyɨeyɨm sɨmiir asi haiswonɨmnɨskɨi, tɨ digworaekwowɨm kɨmiir nɨisiimauuwi mɨ kɨma wa dɨnoknɨnkɨn ɨiya Adi Komii siya siir digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana saeya bɨdi yamwoniya. ");
INSERT INTO iws_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Mɨ yai kwɨra kara kɨmiir boɨnmauuwi inkam nwɨrɨn siya inkam Setan kɨrɨekakɨn siir omaka hɨriir nami mɨ wɨ siir digworaekwo ɨmiir tauae haii, aniya. Siya tɨ inkam kɨrɨe ɨiirɨn wɨeyɨnsopni tikɨ ɨnɨrkaikikɨngik, siir ɨɨga ɨɨnɨm hɨriinan tɨri mɨ siir digworaekwowɨm omakanau hɨr nwokaiyɨm wɨ siya hainaki. ");
INSERT INTO iws_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Inkamɨn nomiiyau kanaka nwo karam nwowi mɨ siya ɨo kariir nwowikɨn. Mɨ yɨpɨkɨn kariir whɨndirɨraerar karam nwowi iikam sɨmiir kwoɨnɨm Adi Komii siirɨm nɨnkpɨt haigiyɨm, sɨma ɨni iikamɨm dimɨn biyɨekakɨm sɨma nhɨnɨkrɨropkiyɨm hɨnda tɨnda ɨni sɨmiir hɨriinan ywowɨn. ");
INSERT INTO iws_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kara kɨmiirɨn pɨ hɨnɨɨna boɨni, Adi Komii siya wɨ dɨgar nwowi kɨmiir digworaekwo biyɨe whɨekakɨm sɨmiirar haiyoprimdiyɨumiigi mɨ iikam whɨekakɨm sɨma nɨgbumbu boɨnɨm sɨmiir warar mɨ inkamɨn Adi komii siir naeyɨu ɨiir nɨgbumbu boɨni mɨ Adi Komii siya ta yaiya siya nɨgbumbu boɨna wɨ saiir wara haiyoprimdiyɨumiigi rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Inkamɨn Yaowae Adɨn nɨnomor kouan kariir nɨgbumbu boɨni mɨ Adi Komii siya siir dimɨn biyɨe ɨmiirɨn wa haiyoprimdiyɨumiigi. Mɨ inkamɨn Adi Komii siir naeyɨu ɨiir nɨgbumbu boɨni mɨ Adi Komii siya siir nɨgbumbu boɨna wɨ saiir haiyoprimdiyɨumiigi rani. Mɨ tariinanɨn, ɨriipa hɨriinan mɨ mhoɨiya ɨriipa hɨriinan. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Paeyɨn mɨiyɨk nwowiyɨn mɨ siir naeyɨm pɨ wadɨeya mɨ owi, pae biyɨe mɨ owiyɨn mɨ siir naeyɨm pɨ biyɨeya mɨ owi. Inkamɨm sɨma bɨi nae ɨmiirar nikɨ kɨgi mɨ sɨma pa nɨnoknɨnkɨni, pae mɨiyɨkɨn, iyɨe? Pae mɨiyɨk rani. ");
INSERT INTO iws_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kɨma tɨ iikam biyɨeyɨm, kɨma ɨni mɨpug biyɨeyɨm sɨmiir hɨriinan ywowɨm. Mɨ kɨma wɨ pɨkɨ hɨnɨɨn yai mɨiyɨkɨm sɨmiir nɨmboboɨni, ha? Yai panɨɨn panɨɨn kwoɨnkɨm iikam krɨmiir mhɨi kwoɨnau nwokaiiyɨm pɨ sɨmiirar prɨi boɨnɨnɨsami. ");
INSERT INTO iws_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Inkam mɨiyɨkɨn mɨ kwoɨn mɨiyɨkɨm ɨni siir mhɨi kwoɨnau hɨrar nwokaiyɨm. Mɨ siya siyɨu mɨiyɨk mɨiyɨk asi tɨri. Inkam biyɨeyɨn siir kwoɨnauɨn yɨo yai bibiyɨe kasakɨ nwokai rani. Mɨ mhoɨiya siya wɨ yai biyɨe ɨmiirar boɨni. ");
INSERT INTO iws_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Kara kɨmiirɨn pɨ tɨ dimɨn taemɨn hɨnɨɨnɨm sɨm boɨnki, boɨnwokiyopnatkaini ɨiya Adi Komii siya wɨ iikamɨm sɨmiir hɨdi yai bibiyɨeyɨm sɨma prɨiboɨn prɨiboɨnɨm sɨmiirsi. ");
INSERT INTO iws_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mhoɨiya Adi Komii siya wɨ krɨmiir srɨi yai whɨekakɨm bɨiya krɨmiir yai aeya boɨnɨm. Mɨ tɨ kɨmiir yai whɨekakɨm wɨ sɨmar nɨisiimauuwi. Kɨra mɨiyɨkɨ pɨ yamisi owɨn, iyɨe? Kɨra inkam mɨiyɨk rani. Mɨ siya kɨmiirɨn wa hɨdi dimɨn taemɨn whɨekakɨm kɨma boɨnɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ta ɨi aiirɨn kam nhɨrɨm siyɨu komii nɨnoknɨnkɨniyɨkɨm mɨ Farisi kam nhɨrɨm sɨma boɨn, inkamɨn iikam nowomwarkaiyɨuwiyɨn, krɨma ha naɨngwowi kɨra dimɨn kɨrɨe komiiyɨn whɨra dɨisiimauu haigɨnɨu mɨ krɨma wa nwokɨ ɨnoknɨnkɨnɨm kɨra Adi Komii siir yɨnisɨmkɨn. ");
INSERT INTO iws_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Mɨ Jisɨs siya sɨmiir yai aka hɨnɨɨna ywowarkɨi boɨn, kɨma iikamɨm kariiram kauwokɨm dimɨn komii kɨrɨe kɨmiir nɨisiimauuɨm, kɨma iikam mɨiyɨk rani. Kɨma Adi Komii siirɨm bɨ swokɨ aɨngwo tɨbmiigɨm. Kara dimɨn kɨrɨe komii pɨ kɨmiir swokɨ ɨisiimauu rani. Dimɨnɨn whɨrɨn kara kɨmiirɨn pɨ siirarar nɨisiimauuwi ɨiya bɨiya profet Jona siya tɨra tɨ nu ɨiir. ");
INSERT INTO iws_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Bɨiya Jona siir hɨriinan, siya nwokaiyɨn anasu komiiya saiir mhɨinau, nabɨeyɨm kwoɨm mɨ nɨiyɨm kwoɨm. Mɨ Yaowae Adɨn nɨnomor kouanɨn wɨ ɨriipa hɨriinan, nabɨeyɨm kwoɨm mɨ nɨiyɨm kwoɨm ɨenau hɨr nwokaii. ");
INSERT INTO iws_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mhoɨiya ɨiya Adi Komii siya iikamɨm sɨmiir hɨdi. Mɨ iikamɨm bɨiya om Niniva hɨr nwowɨm mɨ wɨ tɨ iikamɨm sɨmaka nɨnkɨn okwowi. Mɨ sɨma wɨ hɨnɨɨna boɨni. Kɨma iikam biyɨekɨɨngɨm. Mɨ sɨma wɨ hɨnɨɨna boɨni. Dimusi rani, bɨiya Jona siya Adi Komii siir yai aiir boɨnmɨmauuɨn mɨ iikam whɨekakɨm sɨma Adi Komii siiram bɨdiya yaɨngwo tɨbmiiyɨm. Inkamɨn nwɨra nwowi tɨrɨn, yɨo ɨni Jona siir haiburɨn mɨ kɨma siirɨm bɨ naɨngwo tɨbmiikɨm. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mhoɨiya Adi Komii siya iikamɨm sɨmiir hɨdi, bɨiyan wig komii ɨra nu nhɨrɨm sɨmiir kɨgrɨraowiya saeya bɨiya iikamɨm nu Sivanɨm sɨmiir kɨgrɨraoka. Mɨ saeya wɨ tɨ iikamɨm tariinan nwowɨm wɨ sɨmaka nokwowi. Mɨ saeya wɨ hɨnɨɨna boɨni, kɨma iikam biyɨekɨ biyɨe kɨɨngɨm. Mɨ saeya wɨ hɨnɨɨna boɨni. Dimusi rani, bɨiya saeya saiir nu ɨiirar mɨ haiburgigi mɨpi aru maeyauwar mɨ rɨmtɨoki inkam komii Solomon siir yai wakaeyam. Tɨ inkamɨn tɨr nwowɨn siya ɨni Solomon siir haiburɨn mɨ kɨma iikamɨm siir yai bɨ wakaeyoknakɨm. Nɨɨngaka. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Mɨ ɨiya uridyɨu biyɨeyɨn siya inkam nwɨrni haiburgigiyɨn mɨ maeyau nɨɨnga nɨɨngaɨm op karamaeyɨm pɨ sɨmiir prɨiyam prɨiyamki siya saiir ninɨ owouwɨm. Mɨ siya maeyaukwɨr bɨ kɨgɨn. ");
INSERT INTO iws_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Mɨ siya hɨnɨɨna yaɨngwo, kara pa swokɨ ami maeyaua bɨiya kara nwonaniya saiiram. Mɨ siya ha swokɨ amɨn mɨ siya kɨg ta maeyaua sɨma bɨdi nhɨskiya mɨ bɨdi pɨuaiya mɨ maeyau nhɨrkɨm nɨɨnga bɨ nwokɨm mɨ uridyɨu biyɨe nwɨrkɨ hɨr nwo rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Mɨ siya hɨriinan kɨgnamɨn mɨ ɨna swokɨ amɨn mɨ uridyɨu biyɨe ɨriiyar nwɨso sɨmiir swokɨ ɨkɨuna mɨ siyɨu bibiyɨeyɨm sɨma tɨriyɨm ɨni tɨ siir haiburɨm. Mɨ sɨma saɨka yam mɨ sɨma ɨna yapnɨnopkainamɨm mɨ ta maeyaua saiir inɨ owou. Bɨiya tɨ inkamɨn uridyɨu biyɨe whɨrɨn siya nwowɨn bɨiya siya biyɨe wao bɨ nwokɨn. Mɨ tariinanɨn ɨni tɨ uridyɨu biyɨe ɨriiyar nwɨso sɨmar yonkwobumbunɨnkɨn ɨuguskiyɨn tɨ inkamɨn siirɨn. Mɨ wɨ hɨriinan kɨnar nɨmbiyamswowi iikam biyɨeyɨm tariinan nwowɨm sɨmiirɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Mɨ Jisɨs siya yai, iikam ɨmiirar nikɨ boɨnmɨmauuɨn mɨ siir apu aeya mɨ siir nomousɨsɨm ɨkɨm sɨma yaba yaka okwoni. Sɨma yai saɨka boɨnaiyam nɨtkɨm. ");
INSERT INTO iws_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mɨ inkam nwɨrɨn Jisɨs siir boɨnki, wakae, kɨriir apu aka mɨ kɨriir nomousɨsɨm ɨkɨm sɨma ɨsi yaba hɨrar nokwowɨm mɨ sɨma yai kɨnaka boɨnaiyam nɨtkɨm. ");
INSERT INTO iws_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Mɨ Jisɨs siya tɨ inkamɨn siir yai aka hɨnɨɨna yowarkɨi boɨnki, siya Adi Komii siir isidɨn sɨmiir nowomwarkaiyɨuɨm siya hɨnɨɨna boɨnkɨn. Yɨpɨkɨ kariir apua? Mɨ yɨpɨkɨ kariir nomousɨsɨmɨm, ha? ");
INSERT INTO iws_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Mɨ Jisɨs siya siir mɨi kɨgna mɨriiyan kamɨm ɨɨna sɨmiir yɨisiimauugi, kɨgi! Kariir apua mɨ kariir nomousɨsɨmɨm tɨ sɨmargɨm. ");
INSERT INTO iws_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Inkamɨn kariir Adi Komiiyɨn nɨnomor kou hɨr nwowɨn siir kwoɨn ɨiirara napi, yɨm kariir apu mɨ kariir nomousɨsɨm mɨ kariir yokmankɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ta ɨi aiirɨn Jisɨs siya omaka hɨr haiburgikɨn mɨ ɨna yapnaniyamɨn yaba hɨriir. Mɨ siya whɨigbid hɨr yani ɨdwoɨu. ");
INSERT INTO iws_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mɨ iikam whɨekakɨm siir yani kaeyokaiyɨu. Mɨ siya i ɨra saiir yani kwɨrii ɨdwokaiyɨu mɨ siya i hɨr nɨdwokaiyɨn mɨ iikam whɨekakɨm opmaiga hɨr yani okwomaiyɨu. ");
INSERT INTO iws_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mɨ siya boɨniyɨo yai kasa bɨ boɨnkɨn. Siya boɨn, wakae mɨ inkam nwɨrɨn siya siir numɨra witnid saiir nɨtkɨnam namkɨn. ");
INSERT INTO iws_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mɨ siya witnidɨm ha nɨtkɨnamɨm mɨ nhɨrɨm siyɨu nɨkɨigɨiyɨm mɨ ɨpiyɨn nhɨrɨm ha nɨtɨm sɨma inɨ atkɨn ɨdwo aeni. ");
INSERT INTO iws_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Mɨ witnid nhɨrɨm maeyau siiyakaka saiir nɨkɨiyɨm mɨ nuɨn aowa bɨ namkɨn mɨ tɨ hɨriinan witnidɨm ɨna whakiyɨm. ");
INSERT INTO iws_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Mɨ bɨeyɨn ha whwonaidniyakwokɨn mɨ ɨni sɨmiirar yawhwoniyɨn. Mɨ tɨ witɨm sɨmiir mɨiyɨm haɨmii bɨ namkɨm sɨmiirɨn ɨni bɨe siyar whwowaigiyɨm. ");
INSERT INTO iws_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mɨ witnid nhɨrɨm urid nɨmrɨdgakɨn siir bopwo nakaigaiyɨm mɨ urid nɨmrɨdgakɨn ha nɨisikiyɨn mɨ ɨni siya yɨisirɨmdɨɨnugiyɨn. Mɨ sasaenidɨm bɨ sɨbgu whakɨm. ");
INSERT INTO iws_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mɨ witnid nhɨrɨm nu mɨiyɨkɨn siir nɨkɨigɨiyɨm, yɨm nae ɨna budgiyɨm. Mɨ nhɨrɨm yɨm hɨnɨɨna bud nhɨrɨm kamaɨrɨm ɨriiyar mɨ nhɨrɨm yɨm hɨnɨɨna mɨ bud, kam nwoɨm mɨ nhɨrɨm yɨm hɨnɨɨna mɨ bud, kam nwɨr ɨuur. ");
INSERT INTO iws_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Inkamɨn wɨɨngakaɨrgɨn mɨ siya tɨ kariir yai ɨmiirar wakae mɨ ha sɨbgu daɨngwo. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jisɨs siya ta yai aiir boɨn dɨgiyɨn mɨ kamɨm siir kɨgna mɨriiyɨm sɨma Jisɨs siirɨm nɨtɨm mɨ siirɨn hɨnɨɨna inɨ boɨni, hae! Kɨra sɨmiirɨn boɨniyɨo yai dimusi boɨni, ha? ");
INSERT INTO iws_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Siya hɨnɨɨna yowarkɨi boɨn, Adi Komii siya bɨdi yɨisiimauuwɨm nɨmprɨo yaiyɨm ɨi Adi Komii siya siir digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana. Mɨ siya iikam nhɨrɨm sɨmiir wara bɨ nɨisiimauugɨn. ");
INSERT INTO iws_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tɨ dimɨnɨm inkam nwɨrɨn siya nɨnoknɨnkɨn komiigakɨnɨuwi mɨ Adi Komii siya wa swokɨ ɨnkɨn hauugi mɨ siir nɨnoknɨnkɨna wɨ komiiyar nwowi. Mɨ inkam nwɨrɨn siir digworaekwo sɨmɨm kwɨsuwakɨnɨuwi mɨ wɨ Adi Komii siyar swokɨ haii. ");
INSERT INTO iws_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Mɨ kara tɨ hɨriinanɨn sɨmiirɨn boɨniyɨo yai boɨni. Dimusi rani, sɨmiir nhwowɨm ɨna kaowɨm mɨ sɨma dimɨn kɨg rani. Sɨmiir wɨɨnɨm ɨna mauɨm mɨ sɨma yaimwo aiir wakae nɨnoknɨnkɨnkɨn tani. ");
INSERT INTO iws_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kɨma tɨ iikamɨm yai kwɨra profet Aisaia siya boɨna bɨiya saeya bɨdi yɨmbiniya saeya hɨnɨɨna boɨnka. Kɨma yai aiirɨn wa wakaei mɨ kɨma saiir yaimwo aiirɨn wɨ nɨnoknɨnkɨn tani. Mɨ kɨma wa kɨgi mɨ kɨma wɨ siir siirara kɨgnanaei. Mɨ kɨma wɨ nɨnoknɨnkɨn tani kɨma dimu dimɨn kɨgɨm. ");
INSERT INTO iws_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tɨ iikamɨm sɨmiir mhɨi kwoɨnɨm ɨni hindara hɨugɨmkɨkɨugiyɨm. Mɨ sɨmiir wɨɨnɨm tɨ yai ɨmiir wakaeyɨm pɨ piyaowi mɨ sɨmiir nhwowɨm ɨna kwɨsnamɨm. Mɨ sɨmiir nhwowɨm pɨ dimɨn whɨr kɨgisi. Mɨ sɨma kariir yai aiir sɨbgu wakaekɨɨni mɨ sɨmiir kwoɨnɨm wa sɨbgu nɨnoknɨnkɨnki. Mɨ sɨmiir mhɨi kwoɨnɨm wa kisɨna haigii mɨ wa naɨngwo tɨbmii mɨ kara sɨmiirɨn wa haiswonɨmnɨskɨi haigɨnɨuwi. ");
INSERT INTO iws_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Mɨ kɨma hɨriiyar maɨrgɨmaɨrga. Mɨ kɨmiir nhwowɨm dimɨn taemɨn ɨmiirar sɨbgu kɨgikɨm. Mɨ kɨmiir wɨɨnɨm yaimɨn dimɨn ɨmiirɨn ha sɨbgu wakaeyomokikɨm. ");
INSERT INTO iws_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kara kɨmiirɨn yaimwo aiirar boɨni, bɨiya profet kam whɨekak ɨkɨm mɨ iikamɨm dimɨn whɨrkɨ kɨmbu karamae nwo ɨkɨm sɨma tɨ dimɨnɨm kɨma kɨgam naɨngwowɨm sɨmiir kɨgama naɨngwokɨm mɨ sɨma sɨmiir bɨ kɨgɨm. Mɨ sɨma tɨ yaiyɨm kɨma wakaeyam tɨrɨm, sɨmiir wakaeyamar naɨngwokɨm mɨ sɨma sɨmiir bɨ sɨbgu wakaekɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Tariinanɨn kɨma inkamɨn sasaeya nɨnkɨnɨn numɨr siir boɨniyɨo yaimwokɨyaimwo aiir wakae. ");
INSERT INTO iws_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Iikam whɨekakɨm sɨma yai wɨn kɨbi aiir wakaei, ɨiya Adi Komii siya siir digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana, saiir wakaei. Mɨ sɨma saiir yaimwokɨyaimwo aiir bɨ sɨbgu nɨnoknɨnkɨnkɨm. Mɨ Setan siya sɨmiir mhɨi kwoɨnau hɨriir namɨn mɨ ta Adi Komii siir yaiya bɨiya sɨmiir hɨr nwowa saiir haɨnɨknatki. Iikam whɨekakɨm sɨma yaiwɨn kɨbi aiir wakaei nɨnomor kouana mɨ saiir yai aiir nɨnoknɨnkɨn karamae nwowi ya hɨnɨɨnga witnidɨm siyɨu nɨkɨigɨiyɨm mɨ Setan siya sɨmiirɨm nɨti mɨ sɨmiir boɨni kɨma ta yai aiir kɨpi wakae Adi Komii siya nɨnkɨna kɨmiir mhɨi kwoɨn ɨmiir waraur. ");
INSERT INTO iws_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mɨ witnid nhɨrɨm nu maeyauwa siiyakaka saiir nɨkɨigɨiyɨm, yɨm ɨni iikamɨm yai aiirɨn wɨnwɨnarar sɨbgu wakaeiyɨm mɨ maɨrgɨmaɨrga ha nwowiyɨn ɨni sɨmiir hɨriinan ywowɨm. ");
INSERT INTO iws_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mɨ yɨm ɨni witnidɨm mɨi grɨnkii karamae nwowiyɨm ɨni sɨmiir hɨriinan ywowɨm. Mɨ sɨma wɨ ɨi prɨei nokwo rani. Mɨ wa swokɨ kwaowainami. Mɨ iikam nhɨrɨm sɨmiir naɨngwo tɨbmiiya ɨni tɨ witnidɨm sɨmiir hɨriinan ywowɨm mɨ sɨma ɨi prɨei naɨngwo tɨbmii rani. Mɨ ɨiya sɨmiirɨn hɨk kɨmpɨpɨsukɨ nɨmbiyami, ta sɨma naɨngwo tɨbmiiya Adi Komii siiram, wɨ digɨumii haimriiyɨugigi mɨ wa nɨkɨi ɨuguskii. ");
INSERT INTO iws_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mɨ witnid nhɨrɨm urid nɨmrɨdgakɨn siir bopwo nakaigaiyɨm yɨm ɨni iikamɨm Adi Komii siiram naɨngwo tɨbmiiyɨm mɨ sɨmiir hɨriinan ywowɨm. Mɨ tɨ nuan dimɨn biyɨeyɨm sɨmiirɨm naɨngwoyɨmiyoki, umɨr mɨn hɨnɨɨnɨm, sɨmiiraram naɨngwowiyɨm, tɨ hɨriinanɨn ya Adi Komii siir yai aiir higrɨnɨuwi wa nɨkɨi ɨuguskii. Mɨ sɨma wɨ digɨumii Adi Komii siir haimriyɨugigi. Mɨ sɨmiir mɨiya sɨma mɨriiya, sɨma saiirɨn mɨiyɨk panisi mɨriisi. ");
INSERT INTO iws_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mɨ tɨ witnidɨm nu mɨiyɨk nɨtkɨnɨm, yɨm ɨni iikamɨm Adi Komii siir yai sɨbgu wakaeiyɨm mɨ sɨmiir yaimwokɨyaimwo sɨbgu ɨnomoknɨnkɨniyɨm, ɨni sɨmiir hɨriinan ywowɨm. Mɨ tɨ iikam hɨriinanɨm sɨma wɨ mɨi mɨiyɨkar mɨrii, tɨ sasaenidɨm kamaɨrɨm ɨriiyara budiyɨm mɨ kamnwoɨma mɨ budiyɨm mɨ kam nwɨr ɨuura mɨ budiyɨm ɨni sɨmiir hɨriinan ywowɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisɨs siya yaeya boɨniyɨo yai kwɨra saiirɨn hɨnɨɨna boɨn sɨmiirɨn, Adi Komii siya digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana, ya ɨni tɨ inkamɨn witnid nɨnkɨnɨn siir numɨr aiir ɨni siir hɨriinan ywowɨn. ");
INSERT INTO iws_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mɨ ɨiya iikamɨm ha whwonkai aokaokiwiiyɨm mɨ siir sau omomɨn siir inkam nwɨrɨn ha nɨtwiiyɨn mɨ siya ko biyɨeya kɨmɨdiniya siir numɨr aiir inɨ ɨtkɨngig. Mɨ siya ɨna swokɨ ɨdamkiwiiyɨn. ");
INSERT INTO iws_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mɨ mhoɨiya tɨ sasaenidɨm ha ninan iigiyɨm mɨ sasaeyɨm wai ha nwokiyɨm mɨ siyar kɨgi ta ko biyɨeya warar nɨnkɨn whakiya. ");
INSERT INTO iws_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Mɨ mɨiyan kamɨm ɨna yamɨm numɨran adɨn siiram. Mɨ sɨma boɨn, bɨiyan inkam, krɨmiir kwoɨnɨm ha naɨngwokɨm kɨra numɨr hɨrɨn sasaeya mɨiyɨkɨm sɨmiirara nɨnkɨni mɨ ta hɨriinan ko biyɨeya saeya panɨɨna nɨmbiyamka, ha? ");
INSERT INTO iws_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Mɨ siya sɨmiir boɨnki, kɨmiir sauan inkam nwɨrkɨ nɨtkɨngikɨn ta ko biyɨeya! Mɨ siir mɨiyan inkamɨn siir boɨnki, kɨriir kwoɨnɨn panɨɨna naɨngwowi krɨma ɨkɨ ko biyɨeyɨm sɨmiir pinɨ akɨu, aniya? ");
INSERT INTO iws_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mɨ siya sɨmiir boɨnki. Nɨɨngaka. Sasaeyɨm wɨ ko biyɨeya saɨka kɨma nɨnkɨn akisi. ");
INSERT INTO iws_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kɨma sowiirɨn hɨriiyar kɨgnɨnkɨn whakii mɨ wɨ ɨiya sasae nɨngugu haiyana, wɨ saiirar nadɨgɨuwi. Mɨ ɨiya sasae ɨmiir nɨngugu haiyana mɨiyan kam ɨmiirɨn wɨ kara boɨni, ko ɨmiirɨn maeyau kwɨruwa dak haigɨn mɨmɨr. Mɨ sɨmiirɨn wɨ ɨrɨpa kog hainami mɨ wɨ pae namgɨnki. Mɨ sasaeyɨm, yɨm wɨ kariir omaka nae haigiiya wɨ saiir hɨr haigii. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisɨs siya yaeya boɨniyɨo yai kwɨra sɨmiirɨn hɨnɨɨna boɨnki, Adi Komii siir digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana ɨni mastetnidɨn siir hɨriinan ywowa. Mɨ inkam nwɨrɨn siirɨn siya hainam siir numɨr aiir inɨ ɨnkɨn ɨu. ");
INSERT INTO iws_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mastetnidɨn siya nae whɨrni nidnan bɨ nwokɨn. Nɨɨngaka. Siya komii rani. Mɨ mhoɨiya siya wɨ komiiya nɨmbiyamki mɨ numɨr hɨran naeyɨm sɨmiirɨn siyar mwrɨi haiburigigi. Siya pae komii nwokiiyɨm mɨ ɨpiyɨnɨm pɨ siir kwiya ɨmiirar mɨ atkɨkɨni mɨ whɨe mɨnɨm pɨ hɨrar mɨ haigii. Mɨ ɨiya Adi Komii siya siir digworaekwo whɨekak ɨmiir kɨgɨrkakana, siir iikamɨm sɨma wɨ tɨ mastetɨn siir hɨriinan nwowi mɨ wɨ komiiyar nasae owɨguskii. ");
INSERT INTO iws_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisɨs siya yaeya boɨniyɨo yai kwɨra ɨna swokɨ boɨnkiyɨn. Adi Komii siya digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana ɨni yisnan iyopin bwaembwaekɨn howoknamɨn. Ɨiya wig ɨra saeya tɨ yis ɨiir haiiya, praua aka kaipridgiyam mɨ tɨ prauaɨn pa niyopin bwaembwaekɨi howopnami. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisɨs siya tɨ yaiyɨm bɨiya siya boɨnɨm digworaekwo whɨekakɨm iikam ɨmiirɨn boɨniyɨo yai ara boɨnkɨn. Siya sɨmiirɨn yai whɨr wara bɨ boɨnkɨn. Nɨɨngaka. Siya sɨmiirɨn boɨniyɨo yai arar boɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Siya sɨmiirɨn boɨniyɨo yaiyɨm hɨnɨɨna boɨnkɨn, siya profet inkamɨn siir yai aiir swokɨ boɨnurwokaigikɨn, bɨiya yokwoni siya wɨn boɨnkiya yaiya saiir. Ta yaiya saeya hɨnɨɨnga, kariir yaiya wɨ boɨniyɨo yai ɨmiirara kaonɨsboɨni. Adi Komii siya tɨ nu ɨiir nonkwokwo karamaeya nikɨ owa mɨ kara tɨ dimɨnɨm bɨiya haigipraprakaiyɨm mɨ tariinan namwoniyɨm wɨ sɨmiirarar boɨnɨnkɨigi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisɨs siya ha boɨn dɨgiyɨn mɨ siya iikamɨm sɨmiir haiburgigɨn mɨ siya omaka saiir yapnɨnopkainam. Mɨ kamɨm siir mɨi kɨgna mɨriiyɨm, sɨma ɨna yɨtɨm siirɨm mɨ ɨna boɨnɨm, kɨra ta boɨniyɨo yaiya ko biyɨe saiira numɨr whaka krɨmiir unkɨ boɨnmɨmauu. ");
INSERT INTO iws_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jisɨs siya ɨna yowarkɨi boɨnɨn sɨmiir yai aka, inkamɨn sasaeya mɨiyɨk nɨnkɨniyɨn numɨr, yɨo karargɨn, bɨiyan Yaowae Adɨn nɨnomor kouankɨ nɨtɨn. ");
INSERT INTO iws_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Mɨ numɨra ya tɨ nu ɨeya mɨ sasaeya mɨiyɨkɨm yɨm iikamɨm Adi Komii siir yai aiir wakaeyoknaeiyɨm, ya sɨmiir nɨkri boɨnka. Mɨ ko biyɨeya ya iikamɨm Setan siir yai aiir wakaeyoknaeiyɨm ya sɨmiir nɨkrii boɨnka. ");
INSERT INTO iws_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Sauan omomɨn siir inkamɨn ko biyɨe aiir nankaiyɨn yɨo Setan siya. Mɨ ɨiya sasae ɨmiir nɨngugu haiyana, ya ta ɨiya Adi Komii siya iikam ɨmiir hɨdana ya saiir boɨnka. Mɨ kamɨm numɨran sasae ɨmiir nɨngugu haiyɨm, yɨm Adi Komii siir paekwosɨm ɨma. ");
INSERT INTO iws_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Mɨ ko biyɨeyɨm maeyau kwɨruwa sɨma haɨngiriyɨu haigɨnɨm mɨ ha namgɨnkiyɨm paeya mɨ mhoɨiya wɨ hɨriinanar tɨri. Iikamɨm dimɨn biyɨe biyɨekakɨm, sɨmiirɨn wɨ hɨriinan hɨdi. ");
INSERT INTO iws_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mɨ kara Yaowae Adɨn nɨnomor kouankɨ nɨtɨn, wɨ kariir paekwosɨmɨm sɨmiir nɨkropkii hɨnda tɨnda. Mɨ sɨma wɨ tɨ nuɨn siir dimɨnpai dimɨnpai whɨekakɨm iikamɨm sɨmiir naɨngwo tɨbmii aiir kiyopsɨmsɨbgiyɨm mɨ ɨriipɨ hɨriinan, sɨma wɨ iikamɨm dimɨn biyɨe tɨrɨm, sɨmiirɨn wɨ Adi Komii siir isidɨn sɨmiir hɨrankɨ nhɨnɨkrɨropki. ");
INSERT INTO iws_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Mɨ sɨmiirɨn wɨ pae komiiya saiir hɨriir nɨtkaigaigi mɨ sɨma wɨ paenau hɨrar kaouubopboɨnkaeyami mɨ wɨ sɨmiir big ɨmiirar naegɨmgiyɨkaeyami. ");
INSERT INTO iws_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mɨ ta ɨi aiirɨn iikamɨm dimɨn whɨrkɨ kɨmbu karam nwowɨm wɨ bɨenan sɨmiir whwoyaei. Adi Komii siir ɨiya digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana saiir. Inkamɨn wɨɨngakaɨrgɨn siya ta yai aiirɨn ha timɨ wakae. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Adi Komii siir digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana, saeya ɨni ta umɨr mɨiya numɨra saiir haigiprakaiya inkam nhɨrkɨm bɨiyar, ɨni saiir hɨriinan ywowa. Mɨ mhoɨiya inkam nwɨrɨn ha swokɨ hansɨr haiyɨn mɨ ɨna swokɨ haigiprakaigigɨn ta maeyau aiirar mɨ siya ɨni maɨrgɨmaɨrga ywonamɨn. Mɨ siir digworaekwo whɨekakɨm ɨna hauugiyɨm inkam nhɨrmi sɨma saɨnam. Mɨ tɨ umɨrɨm siya haiyɨm wɨ ta maeyau aiir nwokɨ saɨnɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Mɨ boɨniyɨo yai kwɨra ya hɨnɨɨnga, Adi Komii siya siir digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana ya ɨni tɨ inkamɨn umɨr mɨiyɨk mɨiyɨk haiyam hansraniyɨn ɨni siir hɨriinan ywowɨn. ");
INSERT INTO iws_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Mɨ siya umɨr mɨiyɨk kɨgiyɨm mɨ tɨ siir umɨr digworaekwo whɨekakɨm wɨ ɨkɨ inkam nhɨrɨm sɨmiir umɨr digworaekwo mɨiyɨk mɨiyɨkɨm sɨmaka nɨnowana haii. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Mɨ boɨniyɨo yai kwɨra ya hɨnɨɨnga. Adi Komii siya siir digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana ya ɨni inkamɨn haɨmna whɨinau kwɨra sae hɨumii ɨkouwiyɨn, wraisupai wraisupai sɨmiiram, ɨni siir hɨriinan ywowɨn. ");
INSERT INTO iws_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Mɨ ɨiya haɨmnan, wraisukɨ naokɨngugunɨnkɨniyɨm mɨ siirɨn pa kinaidami nupaiga hɨriir. Mɨ sɨma pa nɨdwowi mɨ anasu mɨiyɨk mɨiyɨkɨm pɨ two nhɨrmi kɨgmamak ɨsɨtnoudnankaigii. Mɨ biyɨe biyɨeyɨm yɨmbi paeya nɨsɨtnoudnankaigi. ");
INSERT INTO iws_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ɨiya Adi Komii siya iikam whɨekakɨm sɨmiir hɨdana, ya wɨ tɨ anasuwɨm sɨmiir hɨda wɨ hɨriinan nwowi. Mɨ ɨiya paekwosɨm ɨma nɨtana mɨ wɨ sɨma kɨgmamak haii, pɨkɨ hɨnɨɨn iikam ɨkɨm wadɨeyɨm mɨ pɨkɨ hɨnɨɨn iikam ɨkɨm biyɨeyɨm. ");
INSERT INTO iws_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Mɨ sɨma sɨmiirɨn wɨ pae komiiya saiir hɨriir nɨtkaigaigi. Mɨ ta ɨiya, sɨma wɨ kaouu ou prasae kɨn tani. Mɨ sɨmiir big ɨmiirar ninɨn aekiyɨmkiyɨkaeyami. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Mɨ Jisɨs siya sɨmiir srɨigi mɨ kɨma tɨ yai whɨekakɨm, sɨmiir yaimwowɨm sɨmiirɨn ɨna nɨnoknɨnkɨnɨm, aniya? Mɨ sɨma ɨna boɨnkiyɨn siirɨn, ɨhɨ. ");
INSERT INTO iws_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Siya sɨmiirɨn hɨnɨɨna boɨnki mɨ kam siyɨu komii nɨnoknɨnkɨniyɨm yɨpɨkɨ kariir kɨgna mɨriiyan inkam nwowɨm sɨma Adi Komii siir digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana, sɨma saiir bɨdiyar haiyɨm. Mɨ sɨma ɨni omakaɨn inkamɨn siir hɨriinan ywowɨn. Mɨ siya omaka siir digworaekwo haigiiya pɨ saiir napnɨnopkainami mɨ siya dimɨn mɨiyɨk mɨ dimɨn biyɨe, pa ninɨ hainakinaka mɨpa sɨoɨtkɨn hauunami iikamɨm sɨmiir whɨnkɨnsiisam. Mɨ tɨ hɨriinan siyɨuɨn, wɨ sɨma boɨnmɨmauuami Adi Komii siir yaiya bɨiya profet inkamɨm sɨma boɨna mɨ ta yaiwɨn kɨbiya saiir warar. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisɨs siya tɨ boɨniyɨo yaiyɨm sɨmiir boɨn swokiyɨm mɨ siya tɨ om ɨiirɨn ɨna haiburgigɨn mɨ ɨna yamɨn. ");
INSERT INTO iws_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Mɨ siya siir omkɨ om ɨiirar swokɨ amɨn mɨ siya iikamɨm sɨmiir inɨ boɨnmɨmauuɨu, Adi Komii siir yai aiir omaka yaimɨn dimɨn nɨdwokai wakaeiya sɨmiira saiir. Mɨ sɨma wakae dɨgiyɨm, sɨma ɨni hinda yanaakiyɨm. Mɨ sɨma ɨna yomboɨn amboɨnɨm, ta nɨnoknɨnkɨna dimɨn kɨrɨe kɨrɨe iikamɨm sɨm haiswonɨmnɨskɨiiya siya papi haigɨn, ha? Siya krɨmiir hɨriinan inkamaɨrgɨn. ");
INSERT INTO iws_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Mɨ tɨ yɨnisɨmɨn siya inkamɨn omaka mɨriiyɨn, siir yɨnisɨm tani, aniya? Mɨ tari siir apua Maria saeya rani, aniya? Mɨ tari Jems, Josep Saimon mɨ Judas, yɨm tari siir nomousɨsɨm tani, aniya? ");
INSERT INTO iws_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Mɨ tari siir yokman whɨekak rani, tɨ krɨmakar nwowɨm, aniya? Mɨ tɨ digworaekwo whɨekakɨm siya papi haigɨn, ha? ");
INSERT INTO iws_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Sɨma hɨriinan yai boɨnɨm mɨ sɨmiir mhɨi kwoɨnɨm ɨni hɨkaka ywokiyɨm. Dimusi rani, sɨma nɨnoknɨnkɨn tani, siya ta kɨrɨeya papiyanka haiga. Mɨ Jisɨs siya sɨmiir boɨnki, profet kamɨm sɨma inɨgakɨm ɨkɨ om whɨekak ɨmiirɨn mɨ siir omkɨ om hɨrɨn mɨ siir pɨugana saiir hɨran iikam ɨkɨm, siya sɨmaka inɨgak bɨ nwokɨn. ");
INSERT INTO iws_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Mɨ siir om hɨrɨn siya dimɨn kɨrɨe whɨekak bɨ haiswonɨmnɨskɨigɨm iikam ɨmiirɨn. Nɨɨngaka. Dimusi rani, sɨma siiram ha bɨ naɨngwo tɨbmiigɨm, siya tɨ inkamɨn Adi Komii siya nɨkropkiyɨn. Nɨɨngaka. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ta ɨiya Herot siya nu kɨgrɨraowan inkam komii nwokɨn Galili hɨr mɨ siya dimɨnɨm Jisɨs siya tɨrɨm sɨmiir wakaewɨn, ");
INSERT INTO iws_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Mɨ siya siir mɨiyan kamɨm sɨmiir boɨn, kara ha naɨngwowi, tɨ Jon siyakɨ siyaɨrgɨn inkamɨn iikamɨm sɨmiir baptais haigɨnɨuɨn op, aniya? Bɨiya kara siir nɨmbinkɨn inkamkɨ nɨsomaowɨm. Siya ɨe hɨranka swokɨ ɨnsiin ɨdwokɨn mɨ tɨ hɨriinan kɨrɨe komiiya siir hɨr asi nwowi. ");
INSERT INTO iws_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Mɨ bɨiya Herot siir kamɨm sɨma Jon siirɨn hɨriinansi nonkworɨnugɨn mɨ siirɨn wɨeyɨnsopni yɨnɨrkai mɨ maeyauwa hɨuyokiyokaiya mɨi biyɨe mɨriiya hɨr inɨ haigigik. Dimusi rani, Jon siya maɨrgɨmaɨrga bɨ nwokɨn, Herodias saeya Filip siirar wiga mɨ ɨni yaowae biyɨeyɨn Herot siya swokɨ haɨnɨkɨionkwonan. ");
INSERT INTO iws_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Bɨiya Jonɨn op baptais haigɨnɨuwan inkamɨn, siya Herot siir boɨnainanaekɨn tɨ dimɨn siir, siya hɨnɨɨna boɨnkɨn, kɨra ta wig aiir haɨnɨkɨinonkwonan kɨra nonkwonani siyɨu komii ɨiir nɨkrɨpkɨn yɨo tɨ hɨriinan siyɨuɨn mɨiyɨk rani. ");
INSERT INTO iws_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herot siir kwoɨnɨn Jon siir nɨsomaowamar naɨngwokɨn mɨ siya ɨni Juda iikamɨm sɨmiirsi yɨdidɨn. Dimusi rani, sɨma ha naɨngwokɨm Jon siya profet inkamkɨnɨuwi. ");
INSERT INTO iws_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mhoɨiya ɨigwɨra iikam nhɨrɨm sɨma ɨna yɨtɨm, ɨiya Herot siirɨn siir yopiiga naokaina saiir naemɨrsɨm aiiram mɨ taka ɨiya Herodias saiir yɨnisɨm kopaka saeya ɨg sɨmiir bopwo hɨr inɨ swaeyɨu mɨ Herot siya maɨrgɨmaɨrga komiika saiirɨmɨn. ");
INSERT INTO iws_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Mɨ siya saiirɨn hɨnɨɨna yɨmbinki, kara kɨriirɨn yaimwowar boɨni, dimɨnɨn kɨra kariirɨm srɨii mɨ kara kɨriirɨn wa hauuwi. ");
INSERT INTO iws_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mɨ saiir apua Herodias saeya saiir yɨn kopak aiirɨn hɨnɨɨna boɨnmɨmauugi Herot siirɨmɨn mɨ saeya ɨna boɨna, kɨra Jonɨn op baptais haigɨnɨuwiyɨn siir nɨi ɨiir kaigrɨpki mɨ siirɨn mobmɨr kwɨrni haigɨnki mɨ kɨra kariirɨm tɨriir whauugi mɨ kara wa nɨnoknɨnkɨnɨm siya bɨdi yaowɨn. ");
INSERT INTO iws_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mɨ saeya hɨriinan yai aiir boɨn dɨgiya mɨ inkam komii Herotɨn siir kwoɨnɨn ɨni hɨkaka ywokiyɨn. Dimusi rani, siya iikamɨm saɨkar nɨdwokai aeyɨm mɨ siya sɨmiir whwonkam ɨda nɨmbingɨn mɨ siya sɨmiirsi asi nɨdidgɨn. Mɨ siya siir kamɨm sɨmiir boɨnki, ha tɨ hauugi saiirar tɨ dimɨnɨn. ");
INSERT INTO iws_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Mɨ Herot siya inkam nwɨrɨn maeyauwa hɨuyokiyokaiya mɨi biyɨe mɨriiya saiir hɨriir namam yɨkropki Jon siir nɨi ɨiir kaigrɨphainakiyɨm. ");
INSERT INTO iws_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mɨ sɨma Jon siir mwo kaigrɨphaii dɨgɨn mɨ sɨma siir mwoɨn mobmɨr kwɨra saiir haigɨnki mɨ sɨma ta yɨn kopaka saiir hauugi. Mɨ saeya saiir apu aiirɨm hainam. ");
INSERT INTO iws_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Mɨ kamɨm Jon siir kɨgna mɨriiyɨm sɨma wakaewɨnɨm mɨ sɨma ɨna yamɨm siir pɨuɨs aiir inɨ hainaki mɨ sɨma saiirɨn ɨna haɨngikaiyɨm. Sɨma kikai dɨgigɨm mɨ sɨma Jisɨs siir inɨ boɨnmauuɨu. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ɨiya Jisɨs siya ta yai aiir wakaeyɨn mɨ siya tɨ om ɨiir haiburgik mɨ i ɨra saiir kwɨriinam mɨ maeyau iikam karamaeya mɨrmiiya hɨriir yam. Siya siya namkɨn. Iikamɨm sɨma hɨriinan wakaeyɨm mɨ sɨma om ɨiir haiburgik mɨ sɨma ɨni siir mhoɨiya yapnamɨm. ");
INSERT INTO iws_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Mɨ Jisɨs siya ha namasukuɨn mɨ i aiirɨn ɨna haiburgigɨn mɨ siyar yapkɨgidam iikam isid komiiyɨn hɨrar nwowi. Mɨ siya sɨmiirsi yaɨngwoyɨmiyokɨn mɨ iikamɨm makakɨm ɨni siyar haiswonɨmnɨskɨiyɨm. ");
INSERT INTO iws_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mɨ naɨowaka kamɨm siir mɨi kɨgna mɨriiyɨm sɨma ɨna yɨtɨm siirɨm mɨ ɨna boɨnɨm, ta maeyauwa iikam karamaeka ɨiya ɨni namkirɨba. Mɨ haɨnɨɨngɨn nɨuwi kɨra tɨ iikamɨm sɨmiir dɨkropki mɨ sɨma tɨ omi sɨsɨmɨm kingiin nwowɨm sɨmiir damtɨb mɨ naemɨn tɨ saɨnaeyam tɨb. ");
INSERT INTO iws_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Mɨ Jisɨs siya sɨmiirɨn hɨnɨɨna boɨnki, sɨma whɨsarii pɨ dimusi nami? Kɨma hauu ae sɨmiirɨn. ");
INSERT INTO iws_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Mɨ sɨma siirɨn hɨnɨɨna boɨn, krɨmiir tɨrɨn nae homgakɨ nwo rani. Nɨɨngaka. Bretɨm ɨriiyar mɨ anasu whɨs ha nwowi. ");
INSERT INTO iws_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jisɨs siya ɨna boɨnkiyɨn, naeyɨm kariirɨm hainaki. ");
INSERT INTO iws_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mɨ iikamɨm sɨmiir boɨnki, kɨma ko aiir dɨdwoki mɨ siya tɨ bret ɨriiyarɨm mɨ anasu whɨswo sɨmiir hai mɨ nɨnomor koua hɨriir kaoki mɨ Adi Komii siir boɨn wadɨeki mɨ siya anasu bretɨm ɨna yɨmbɨmbɨr yɨnop hauugiyɨm kamɨm siir mɨi kɨgna mɨriiyɨm sɨmiir. Mɨ kamɨm siir mɨi kɨgna mɨriiyɨm sɨmiir hauugi mɨ sɨma iikam ɨmiir hauunam. ");
INSERT INTO iws_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mɨ sɨma ha naeyɨm mɨ sɨmiir mhɨiyɨm ɨni dɨgar ywokiyɨm mɨ kamɨm siir mɨi kɨgna mɨriiyɨm sɨma nae haɨmiihaɨmiiyɨm sɨma naepɨpɨru haigɨnɨm sɨmiir swokɨ haɨngiriyɨu haiginam mɨ nɨbɨm sɨma haigiyɨm nae haɨmiihaɨmii ɨmiir pariig ɨuur ɨs. ");
INSERT INTO iws_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kamɨm tɨ nae ɨmiir naeyɨm 5,000 kɨm, sɨma wigyɨn ɨmiir wara bɨ mwaɨngɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mɨ Jisɨs siya nae sɨmiir hauuwae dɨgikɨn mɨ siya kamɨm siir mɨi kɨgna mɨriiyɨm sɨmiir boɨnki, kɨma i ɨra saiir kwɨriinam mɨ kariir bɨiya damkwokɨn whɨiya saiir mɨrmiiya hɨriir. Mɨ iikamɨm sɨmiirɨn siyar yɨkropki. ");
INSERT INTO iws_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Mɨ siya iikamɨm sɨmiirɨn ha nɨkropkiyɨn mɨ mhɨuisɨm whɨr ɨiirɨn Adi Komii siirɨm siya siyar inɨ kwɨsboɨnɨu. Mɨ naɨowaka Jisɨs sasa ywokairɨb mhɨuisɨm ɨiirɨn. ");
INSERT INTO iws_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Mɨ ta ɨi aiirɨn siir mɨi kɨgna mɨriiyɨm sɨma ɨni igak whɨi idopwoniya hɨrar yakirɨrɨr mairɨbɨm mɨ opuda ɨni irɨb hɨranka hugnaniya mɨ hɨnɨn komiiya ɨni i aiirar kaibombokɨigiya. ");
INSERT INTO iws_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Pɨunok nugakɨn bɨe ha nɨiyok naidniyakwokɨn ɨiya pɨrkɨn kingiin nwoyakwoka Jisɨs siya ɨni nunan ta whɨiya ɨni saiir op ɨda yapamyakwokɨn mɨ kamɨm siir mɨi kɨgna mɨriiyɨm sɨmiir hɨriir yapnɨmbɨiyam. ");
INSERT INTO iws_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Sɨma kɨgwɨn siya opa saiir ɨdwowar napni mɨ sɨma nɨdid pranae bɨ kɨnkɨm. Sɨma boɨn, warɨ napniyɨn wraigɨn mɨ ha nɨdidɨm mɨ ɨna yɨnkau ankauɨm. ");
INSERT INTO iws_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Mɨ Jisɨs siya bɨ kɨmɨmɨnkikɨn ɨni sɨmiirar boɨnkiyɨn, kɨma kɨrɨe dwo! Karargɨn, kɨma kɨpi nɨdid! ");
INSERT INTO iws_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita siya siir yai aka hɨnɨɨna yowarkɨi boɨn, Bɨiyan Inkam Komii kɨrargɨn nɨuwi mɨ kɨra kariir boɨnki mɨ kara pɨ opa saiir ɨdwowa napnani kɨriirɨm. ");
INSERT INTO iws_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jisɨs siya ɨna yowarkɨi boɨnki, kɨra ha wɨt! Mɨ Pita siya iya saiir haiburgik mɨ ɨni nunan opa saiir ɨdar kwaewɨskɨn apamɨn Jisɨs siirɨm. ");
INSERT INTO iws_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Siya opuda saiir kɨnaɨnkɨuwɨnɨn siya ɨna yɨdidwɨnɨn mɨ siya op aowa hɨriirɨn ɨna yokwokwomairaraonainamɨn. Mɨ siya hɨnɨɨna kauwoki, Bɨiyan Inkam Komii kɨra kariir kibokiinawid! ");
INSERT INTO iws_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jisɨs siir ɨɨna bɨ kɨmɨmɨnkika ɨni Pita siirar yanka nonkwo sasaugiya mɨ siya siir boɨn, kɨriir naɨngwo tɨbmiiya kabi rani, kɨriir kwoɨnɨn dimusi naɨngwo yɨsyɨskɨn. ");
INSERT INTO iws_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Mɨ sowa iya saiir inɨ kwɨrii mɨ opuda ɨna hugwokmaigiya. ");
INSERT INTO iws_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Mɨ kamɨm siir mɨi kɨgna mɨriiyɨm i hɨr nwowɨm sɨma tɨ dimɨn ɨiir kɨgiyɨm, sɨma ɨni Jisɨs siir inɨg ɨiir hainanɨm mɨ sɨma hɨnɨɨna boɨn, kɨbɨe idwai kɨra Adi Komii siir yɨnisɨmkɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Mɨ sɨma whɨi aiir niyɨkrɨonaidamɨm mɨ sɨma maeyau kwɨra nu Genesaret hɨrana saiir yamamasu kuɨu. ");
INSERT INTO iws_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Iikamɨm ta maeyau aiiranɨm sɨma ɨna yɨnoknɨnkɨnɨm, Jisɨs siya tɨo. Mɨ sɨma yaiya ɨna hauu nɨnkɨkɨnkiya om whɨekakɨm kingiin nwowɨm sɨmiiram mɨ sɨma ɨna hainaniyɨm iikam whɨekakɨm makakɨm Jisɨs siiram. ");
INSERT INTO iws_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Mɨ sɨma siir srɨinanae, ɨni mɨ owɨn iikamɨm makakɨm sɨma kɨriir pɨu aiir nonkwokiyɨn mɨ nɨɨngakɨ mɨ ɨuwi mɨ yɨuɨs mwɨs ɨiirarar timɨ onkwoki ɨɨnara, aniya? Mɨ iikamɨm siir yɨuɨs pɨu owiir nonkwowɨm sɨma ɨni wadɨeyar swokɨ okiyɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mɨ Farisi kam nhɨrɨm mɨ kam nhɨrɨm siyɨu komii nɨnoknɨnkɨniyɨm, sɨma om komii Jerusalem hɨr haiburgigɨm mɨ sɨma ɨni Jisɨs saɨka yamwoniyɨm mɨ sɨma siirɨn hɨnɨɨna srɨigi. ");
INSERT INTO iws_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Kamɨm kɨriir kɨgna mɨriiyɨm sɨma yɨdiwi wanwiyaemi siyɨuɨm sɨmiir bɨri napkɨm. Moses siya boɨna mɨ ɨɨna mɨn sɨmiirɨm bɨiyɨn hɨisok rani, ɨiya sɨma naeiyɨm krɨmiir yɨdiwi wanwiyaemi siyɨuɨn kɨrɨeyɨn siir hɨriinan. ");
INSERT INTO iws_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jisɨs siya sɨmiir yai aka ɨna yowarkɨi boɨnɨn, kɨma tɨ yɨdiwi wanwiyaeyɨm sɨmiir siyɨuɨm sɨmiir, dimusi napkrɨpkaii. Mɨ Adi Komii krɨmiir Wanɨn siir siyɨu ɨiir dimusi nikwo waisigɨm, ha? ");
INSERT INTO iws_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Bɨiya Adi Komii siya hɨnɨɨna boɨnkɨn. Kɨra, kɨriir yopii adwo sowiirwai yai aiirar sɨbgu wakaeyokna mɨ kɨra sowiirɨn siyɨu mɨiyɨk ɨiirar dɨisiimauu. Mɨ dimɨn whɨrɨn siya sɨmiir boɨnɨn, nwɨrkɨ siya sowiirwai nɨkbumbu boɨni mɨ sɨma wɨ siir nɨsomaowi. ");
INSERT INTO iws_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mɨ kɨma ta yai aiir bɨ wakaeyoknakɨm, kɨma hɨnɨɨna boɨnkɨm. Inkam nwɨrɨn siya umɨr digworaekwo kakɨnɨuwi yopii ad owiir whɨnkɨnsiisɨm. Mɨ kɨra yopii ad owiirɨn hɨnɨɨna kɨpi boɨn, tɨ umɨrɨm Adi Komiini umɨrkɨm. Mɨ kara bɨdi yɨmbinɨn tɨ umɨrɨm Adi Komii siirgɨn mɨ kara pɨ kowiirwai hauu rani. Nɨɨngaka, nɨɨngakɨɨnga. ");
INSERT INTO iws_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mɨ tɨkɨ hɨriinan siyɨuɨn siir tɨri mɨ ɨni mɨ owɨn kɨma sowiirwai mɨ kɨgrɨrao karamae mɨ owi mɨ kɨma Adi Komii siir siyɨu ɨiir bɨdi haigɨn ikworɨnugigɨm mɨ kɨmiir wanmi siyɨu ɨiiramar yɨkpɨtkɨi namɨm. ");
INSERT INTO iws_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kɨma tɨ iikamɨm nɨksɨsaeyan iikamkɨm. Ta yaiya Adi Komii siya boɨna bɨiya profet Aisaia siya kɨmiiram nɨmbina ɨni kaimwowa ywowa mɨ siya kɨmiirɨn hɨnɨɨna boɨnkikɨn. ");
INSERT INTO iws_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Tɨ iikamɨm sɨma kariir inɨg ɨiir hainaniyɨm sɨma yai ara nhɨnkɨni, sɨmiir mhɨi kwoɨnɨm kanaka namasu rani. ");
INSERT INTO iws_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Sɨma kariir inɨgɨn whɨsariiyar prɨihainani tɨ dimɨnɨm sɨma boɨnmɨmauuɨm iikamɨm sɨmiir, ya kariir yai rani, sɨmiirar yaiga. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Mɨ Jisɨs siya sɨmiir boɨnmɨmauu dɨgiyɨn mɨ siya iikamɨm sɨmiir yɨkɨuna, sɨma siirɨm namɨm. Mɨ siya sɨmiirɨn hɨnɨɨna boɨn, kɨma sɨbgu wakae nonkworɨnugi, tɨ dimɨnɨm sɨmiirɨn. ");
INSERT INTO iws_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Dimɨnɨn inkam ɨeya nonkwo haiiyɨn mɨ ha naeiyɨn, yɨo iikamɨm ɨokɨ siya bɨ hɨo haigɨnɨuwigɨn. Nɨɨngaka. Mɨ kwoɨn biyɨe yɨo nɨkrani ɨo pɨ siya hɨowi mɨ inkamɨn pɨ siya kiyainami siyɨu biyɨe tɨramɨn. ");
INSERT INTO iws_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Mɨ siya tɨ dimɨn ɨmiir boɨn dɨgiyɨm. Mɨ siya kamɨm siir kɨgna mɨriiyɨm sɨma ha nɨtɨm mɨ ɨna yaboɨniyɨm kɨra ɨna nɨnoknɨnkɨnɨn tɨ Farisi kamɨm sɨma tɨ dimɨnɨm kɨra boɨnɨm sɨmiirar wakaekiyɨm. Mɨ sɨma kɨnaka ɨo komiiga? ");
INSERT INTO iws_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Mɨ Jisɨs siya ɨna yowarkɨi boɨnɨn. Adi Komiiyɨn nɨnomor kou nwowɨn, siya numɨrkakɨn. Digworaekwo whɨekakɨm siya nɨnkɨkɨn karamae nwowɨm mɨ siirɨn wɨ mɨigakar kiyop haigi. Mɨ wa nɨtkaigi. ");
INSERT INTO iws_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kɨma Farisi inkamɨm sɨmiirsi kɨpi naɨngwoyɨmiyok, sɨma ɨni nhwokwɨsae inkamnan ywowɨm. Nhwokwɨsae inkam nwɨrɨn siirɨn siyɨu bɨ nɨisiimauuwikɨn. Mɨ siya nhwokwɨsae inkam nwɨrɨn siir nɨisiimauuwi mɨ sowa wɨ ɨeno ɨiirar napnatkaigai namswowi. ");
INSERT INTO iws_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita siya Jisɨs siirɨn hɨnɨɨna boɨnki, ta boɨniyɨo yaiya kɨra saiir yaimwo aiirar boɨnɨski mɨ krɨma saiir nwokɨ ɨnoknɨnkɨnɨm. ");
INSERT INTO iws_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jisɨs siya sɨmiir boɨn kɨma ɨni inkam whaowaeyar nikɨ owɨm ɨkɨ iikam nhɨrɨm sɨmiir hɨriinan, aniya? ");
INSERT INTO iws_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kɨma nɨnoknɨnkɨn tani, tɨ hɨnɨɨn dimɨnɨn yaiya naekiyɨm pɨ mhɨi kwoɨna nam tani, pɨ dini siyɨuɨn pɨ siir namki. Mɨ mhoɨiya pɨ waisi hɨr ninɨ ɨugik rani, aniya? ");
INSERT INTO iws_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Mɨ dimɨnɨm inkamni mhɨi kwoɨnau nwokaiiyɨm, mhoɨiya wɨ yai saeyar boɨnɨnkɨigi mɨ tɨ dimɨnɨn inkam ɨiirɨn wɨ siyar nwowaigɨnɨuwi dimɨn biyɨekak. ");
INSERT INTO iws_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Mɨ digworaekwowɨm kwoɨnau nwokaiiyɨm yɨm hɨnɨɨngɨm. Kwoɨn biyɨe nwowi ɨkɨn mɨ inkam nwɨrni nɨsomaoni siyɨu ɨkɨn. Mɨ inkam nwɨrni wig haɨnɨkɨi nonkwonani siyɨu ɨkɨn. Mɨ hɨi inkam nwɨraka nanaeni siyɨu ɨkɨn. Mɨ hɨi tauaeni siyɨu ɨkɨn mɨ nɨksɨsaeni ɨkɨn mɨ nɨkbumbuni siyɨu ɨkɨn. ");
INSERT INTO iws_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tɨ digworaekwo biyɨe biyɨe hɨnɨɨnɨm inkamɨn biyɨe sɨma nwowi. Mɨ siyɨuɨn inkamɨn ɨɨna hɨisok ae karamae nwowiyɨn, tɨ hɨnɨɨn dimɨnɨn yɨo inkamɨn ɨo siya bɨ hɨowikɨn. Adi Komii siir whwonkam ɨdaɨn. Nɨɨngaka. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Mɨ Jisɨs siya tɨ omɨn siir haiburgik mɨ om Taia mɨ om Saidon sowiir hɨriir yam. ");
INSERT INTO iws_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mɨ wig ɨra Juda wig rani, nu Kenan hɨrana saeya ta maeyau aiir nwowika mɨ saeya ha nɨta mɨ siirɨm inɨ kauwokni. Kɨra Devid siir isidan inkamkɨn, inkamɨn Adi Komii siya nɨkropkiyɨn kɨra kariirsi daɨngwoyɨmiyok. Uridyɨu biyɨeyɨn siya tɨrbumbugɨn kariir yɨnisɨm yɨnugiyɨna. ");
INSERT INTO iws_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Mɨ Jisɨs siya saiirɨn yaimɨrsɨm kwɨr bɨ swokɨ owarkɨi boɨnmɨmɨnkɨn. Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma siirɨm nɨtɨm mɨ ɨna boɨnɨm, ta wiga saeya krɨmiir mhoɨiya nɨtka mɨ yai saeya sisinanaei. Mɨ kɨra saiir whɨndirɨraerarki mɨ saiir dɨkropki. ");
INSERT INTO iws_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jisɨs siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨn. Nɨɨngaka. Adi Komii siya nɨkropkikɨn kariirɨn Isrel sɨmiir iikamɨm sɨmiiraramar sibsibnan kɨgugu ɨuguskiyɨm sɨmiiram. ");
INSERT INTO iws_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mɨ ta wiga ha nɨta mɨ ɨna inɨ waisii hɨuniya siir ɨgmiiga kingiin mɨ saeya ɨna boɨna. Bɨiyan Inkam Komii kɨra kariir whɨndirɨraerarki! ");
INSERT INTO iws_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Mɨ Jisɨs siya ɨna yaɨngwowɨn krɨma Juda iikamɨm Juda iikam tani sɨmiirɨn wranan naɨngwokɨm mɨ Jisɨs siya boɨniyɨo yai kwɨra saiirɨn hɨnɨɨna boɨnkɨn, yɨo siyɨu mɨiyɨk rani krɨma yɨnmi naeyɨm sɨmiir kɨpi hai mɨ wrami kɨpi nɨtkɨnɨu aeki. ");
INSERT INTO iws_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mɨ ta wiga saeya ɨna boɨna Bɨiyan Inkam Komii wara yaiya kɨra boɨna kaimwoka. Krɨma wra biyɨe nankɨm. Wra sɨma naemɨrsɨsɨmɨm yɨn ɨma naekrɨmkrɨnkiiyɨm pɨ sɨmiirar mɨ ɨumɨmɨn aei. ");
INSERT INTO iws_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Mɨ Jisɨs siya saiir yai aka ɨna yowarkɨi boɨnɨn, wigra, kɨriir naɨngwo tɨbmiiya ɨni komii ywowa! Dimɨnɨn kɨra naɨngwowɨn siya wɨ kɨriirar nɨmbiyami! Mɨ ta ɨi aiirarɨn bɨ kɨmɨmɨnkɨn saiir yɨnisɨm yɨnugiyɨna ɨni wadɨeyar ywokiya. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Mɨ Jisɨs siya om Taia mɨ om Saidon sowiir haiburgik mɨ whɨikbid Galili saiir hɨriir yapam mɨ siya mhɨuisɨmɨn siir hɨriir iiyam mɨ hɨr inɨ ɨdwowɨu. ");
INSERT INTO iws_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mɨ iikam whɨekakɨm ɨni saɨka yamwoniyɨm mɨ sɨma ɨga ɨɨn biyɨe biyɨekakɨm mɨ nhwokwɨsae mɨ kɨu mɨnɨm nɨnsɨmsɨrɨuɨm mɨ waeyai mɨkrɨm ɨkɨm mɨ makak iikam nhɨrɨm sɨma Jisɨs siir ɨgmiiga inɨ kikɨnɨuni. Mɨ siya sɨmiir haiswonɨmnɨskɨi haigɨnɨugig. ");
INSERT INTO iws_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Iikamɨm sɨma hɨriinan kɨgɨm mɨ sɨma ɨna yanaakiyɨm. Dimusi rani, sɨma kɨgi waeyai mɨkrɨmɨm sɨma yai ɨna swokɨ boɨnaikiyɨm mɨ kɨu nɨnsɨmsɨrɨuwɨm ɨni wadɨeya ywokiyɨm. Mɨ ɨga ɨɨn biyɨe biyɨeyɨm ɨna sɨbgu aprɨrɨrkiyɨm mɨ nhwokwɨsaeyɨm sɨmiir nhwowɨm ɨna kaokiyɨm. Sɨma Isrel sɨmiir Adi Komiiyɨn siir inɨg ɨiir asi hainankɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Mɨ Jisɨs siya sɨmiir haiswonɨski dɨgiyɨn mɨ siya kamɨm siir kɨgna mɨriiyɨm sɨmiir yɨkɨuna. Mɨ siya sɨmiir boɨnki, kara tɨ iikamɨm sɨmiirsi naɨngwoyɨmiyoki ɨiyɨm kwoɨm sɨma kanaka nwokaigiyɨm. Mɨ sɨma nae bɨ naemɨmɨnkɨm kara pɨ boriisopi sɨmiirɨn mhɨirɨma nɨkropkiyɨm mɨ sɨma pɨ siyɨu hɨr naokaowi mhɨigɨ. ");
INSERT INTO iws_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Mɨ kamɨm siir kɨgna mɨriiyɨm ɨna yowarkɨi boɨnkiyɨm siir yai aka, ta maeyaua iikam karamaeka mɨ krɨma naeyɨm pɨ papiyankɨ mɨ ɨnkɨguna haii, ha? Tɨ iikamɨm sɨmiir hauu aeyamɨn. ");
INSERT INTO iws_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jisɨs siya sɨmiir srɨigi, kɨma bretɨm pariiga nwokaii? Mɨ yɨm ɨna boɨnkiyɨm, krɨma bretɨm ɨriiyar mɨ antousɨsɨm ɨkɨm ɨna mɨ okaiyɨm. ");
INSERT INTO iws_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Mɨ Jisɨs siya iikamɨm sɨmiir boɨnki, kɨma nu ɨiir grɨnkɨn ɨdwoki. ");
INSERT INTO iws_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Mɨ siya tɨ bret ɨriiyar nhɨswo sɨmiir haiyɨn mɨ tɨ anasuɨm sɨmiir warar yɨnkɨn hai mɨ Adi Komii siir boɨn wadɨeki mɨ ɨna yɨmbɨmbɨr yɨnoop prɨigɨkiyɨm. Mɨ siir kɨgna mɨriiyɨm kamɨm sɨmiir hauugi mɨ yɨm ɨna yapnɨnkwokwo hauunamɨm iikam ɨmiir. ");
INSERT INTO iws_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mɨ sɨma ha nae dɨgiyɨm. Mɨ tɨ nae haɨmii haɨmiiyɨm sɨma naepɨpɨru haigɨnaowidɨm. Mɨ kamɨm siir kɨgna mɨriiyɨm nɨbɨm sɨmiir swokɨ tau haigiyɨm ɨriiyar ɨs. ");
INSERT INTO iws_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tɨ kamɨm tɨ nae ɨmiir naeyɨm sɨma 4,000 kɨm. Mɨ sɨma wig yɨn ɨmiirɨn wara bɨ nɨnkɨn mwaɨngɨm. ");
INSERT INTO iws_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Sɨma nae dɨgiyɨm mɨ Jisɨs siya iikam ɨmiir nɨkropkiyɨn mɨ siya ɨna kwɨriiyɨn i kopsɨm ɨra saiir kamɨm siir kɨgna mɨriiyɨm sɨma warar mɨ ɨna yamɨm whɨigbid yarmiya hɨriir, nu Magadan hɨran maeyau aiiram. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mɨ Farisi mɨ Sadyusi kamɨm sɨma Jisɨs siir kɨnankɨuwam nɨtkɨm. Mɨ sɨma siiram srɨigi. Kɨra nɨnomor kouan kɨrɨe komii komii nhɨrɨm Adi Komii siirɨm krɨmiir wɨisiimauu krɨma nwokɨ kɨgɨm. ");
INSERT INTO iws_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jisɨs siya sɨmiir yai aka yowarkɨi boɨn. Naɨowaka kɨma pɨ hɨnɨɨna boɨn tɨbi, nɨnomora ɨni pariidnan maskwonaiinamtɨba waka ɨi mɨiyɨk sapi nɨkɨii. ");
INSERT INTO iws_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Mɨ nugakɨn kɨma pɨ hɨnɨɨna boɨnyakwoki. Bɨeyɨn ɨiyaka bɨ maskwonaidniyakwokɨn mɨ ɨiya pa swokɨ ɨmɨɨmgi, panao ɨi mɨiyɨk nwo rani, pɨ naokak nwowi. Ɨhɨ, kɨma kɨgnɨnoknɨnkɨnikɨm nɨnomor saiirɨn. Mɨ kɨma tɨ hɨriinan ɨiyɨm ɨna nɨnoknɨnkɨnɨm mɨ kɨma Adi Komii siir dimɨnɨm tɨ tariinan nɨmbiyamɨm sɨmiir kɨgnɨnoknɨnkɨn tani, aniya? ");
INSERT INTO iws_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kɨma iikam bibiyɨeyɨm ta ɨi aiir nwowɨm Adi Komii siiram nam karam nwowɨm kɨma kariiram kɨrɨe komii dirɨraeraram srɨigɨm mɨ kɨma Adi Komii siiramɨn mhoɨiya bɨ namkɨm. Nɨɨngaka. Kara kɨmiirɨn wɨ dimɨn kɨrɨe nɨisiimauu rani. Nɨɨngaka. Kara kɨmiirɨn wɨ dimɨn kɨrɨe komii whɨruwan ɨiya Jona siya nwowa pɨ siirarar nɨisiimauuwi bɨiya Jonah siya anasu komiiya saiir mhɨinau nwokaiyɨn ɨiyɨm kwoɨm mɨ siya ɨni omwaiyar swokɨ waiyaɨn. Mɨ kɨma wɨ Jonah siir kɨrɨe komiiya saiirara kɨgi. Mɨ siya tɨ yaiyɨm sɨmiir boɨn dɨgiyɨn mɨ Jisɨs siya sɨmiir haiburgik mɨ siya ɨna yamɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kamɨm siir kɨgna mɨriiyɨm sɨma whɨiya saiir nɨnɨdnamkɨm i kopsɨm ɨra saiir mɨ bret nhɨrɨm ɨni sɨma yaɨngwo owougikɨm sɨmiir wara bɨ hainamkɨm. ");
INSERT INTO iws_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Mɨ Jisɨs siya sɨmiir boɨnki kɨma sɨbgu mɨntarao mɨ aru dwo Farisi Sadyusi sɨmiir yisɨn siirsi. ");
INSERT INTO iws_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Sɨma, sɨmasɨma yɨmboɨn amboɨn. Siya hɨnɨɨna boɨnkɨn siya ta yaiya krɨmiir boɨna dimusi rani, krɨma bret bɨri hainanikɨm. ");
INSERT INTO iws_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisɨs siya sɨmiir yaiya bɨdiya yɨnoknɨnkɨnɨnkiyɨn mɨ siya sɨmiirɨn hɨnɨɨna srɨi. Kɨma tɨ kamɨm kɨmiir naɨngwo tɨbmiiya tari kabi rani. Kɨma hɨnɨɨna dimusi boɨnkɨm. Krɨma bret karamaeka, ha? Kariir kɨrɨeya kɨmiir whɨnkɨnsiisɨm wɨ dɨg nwo rani, aniya? ");
INSERT INTO iws_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kɨma ɨni nɨnoknɨnkɨn karamaeyar nikɨ owɨm, aniya? Mɨ kɨma bɨ naɨngwokɨm ɨiya kara nɨmbɨmbɨr hauuwɨm bret ɨriiyarɨm 5,000 iikamɨm sɨma naeyɨm mɨ kɨma ɨni yaɨngwo owouwɨm, aniya? Mɨ kɨma nae haɨmiihaɨmiiyɨm nɨbɨm pariiga haigi, ha? ");
INSERT INTO iws_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Mɨ kɨma tɨ bret ɨriiyar nhɨswo 4,000 kamɨm kara hauu aeiyɨm sɨmiir bɨ naɨngwokɨm mɨ kɨma ɨni yaɨngwo owouwɨm, aniya? Mɨ kɨma nae haɨmiihaɨmiiyɨm nɨbɨm pariiga haigi, ha? ");
INSERT INTO iws_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mɨ kɨma nɨnoknɨnkɨn karamae dimusi nwowi, ha? Kara kɨmiirɨn bret bɨ boɨnkɨn nɨɨngaka. Kara hɨnɨɨna boɨnkikɨn, kɨma Farisi mɨ Sadyusi sɨmiir yisɨn siirsi mɨntɨrao. ");
INSERT INTO iws_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Mɨ kamɨm siir mɨi kɨgna mɨriiyɨm sɨma ɨna yɨnoknɨnkɨnkiyɨm, siya sɨmiirɨn yisɨn bret aka haiigiyɨn siirsi mɨntɨraosi bɨ boɨnkɨn. Nɨɨngaka. Siya Farisi, Sadyusi sɨmiir yai biyɨeyɨn yisnanɨm sɨmiirsi mɨntɨraosi boɨnkɨn. Sɨma sɨmiir yai kɨpi wakaeyokna. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Mɨ ɨiya Jisɨs siya om komiiyɨn Sisaria Filipai nɨkɨuwiyɨn siir kingiin hɨriir nɨmbiyamɨn mɨ ta ɨiya siya kamɨm siir mɨi kɨgna mɨriiyɨm sɨmiir srɨi ɨkɨ iikam sɨma panɨɨna boɨni, kara Yaowae Adɨn nɨnomor kouankɨn nɨtɨn siya yɨpɨkɨn, ha? ");
INSERT INTO iws_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Mɨ sɨma hɨnɨɨna yowarkɨi boɨn. Nhɨrɨm ha boɨni, kɨra tɨ Jon op baptais haigɨnɨuan inkamɨn siya mɨ nhɨrɨm ha boɨni. Ilaijakɨn mɨ nhɨrɨm ha boɨni. Jeremaiakɨn mɨ yaeya profet inkam nhɨrɨm bɨiya naonamɨm sɨma. ");
INSERT INTO iws_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Mɨ Jisɨs siya sɨmiir boɨnki. Mɨ wɨm kɨmarɨn kariirɨn panɨɨna dapikɨm, ha? Kara yɨpɨkɨn, ha? ");
INSERT INTO iws_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Mɨ Saimon Pita siya ɨna yowarkɨi boɨnɨn. Kɨra tɨ inkamɨn Krais Adi Komii siya nɨkropkiyɨn siya. Mɨ siya Adi Komiiyɨn kwoɨnbudɨn omwai waiyayokiyokɨiyɨn ɨinokɨinok mɨ siir yɨnisɨmkɨn. ");
INSERT INTO iws_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Mɨ Jisɨs siya yowarkɨi boɨn, saimon Joni yɨnisɨm, Adi Komii siya kɨriiramar maɨrgɨmaɨrgaei. Kɨriirɨn ta yaimwowa nuan inkam nwɨrkɨn bɨ nɨisiimauugɨn. Nɨɨngaka. Kariir Adi Komiiyɨn nɨnomor kou nwowɨn kɨriirɨn siyar nɨisiimauugɨn. ");
INSERT INTO iws_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kara kɨriir boɨnki, kɨra Pitakɨn mɨ tɨ kɨriir inɨgɨn siir inɨgmwokɨmwoɨn siiyakɨn. Mɨ kariir iikamɨm naɨngwo tɨbmiiyɨm wɨ tɨ siiya siir ɨdwo nwowi. Setan siir kɨrɨeya wɨ tɨ iikamɨm naɨngwo tɨbmiiyɨm sɨmiir nikwowaisii rani. Mɨ wɨ nao rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mhoɨiya kara tɨdiyɨnɨn wɨ kɨriir hauuwi Adi Komii siir maeyauwa digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana saiir haiwaowam. Dimɨnɨn kɨra nu tɨr kɨgnɨnkɨnkikɨn mɨ Adi Komii siya nɨnomor kou hɨrɨn wɨ hɨriinanar mɨ kɨgnɨnkɨnki siirɨn. Dimɨnɨn kɨra naɨngwowɨn nu tɨr kɨgnɨnkɨn owɨm mɨ Adi Komii siya nɨnomor kou hɨrɨn wɨ hɨriinanar mɨ kɨgnɨnkɨn owi siirɨn. ");
INSERT INTO iws_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Mɨ siya kamɨm siir mɨi kɨgna mɨriiyɨm yai kɨrɨe sɨmiir boɨnɨkɨduki, kɨma tɨ inkamɨn Krais Adi Komii siya nɨkropkiyɨn kariirɨn iikamɨm sɨmiir nanmaiwarkainam nɨtɨn, kariirɨn inkam nwɨrni kɨpi boɨnmauu. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mɨ Jisɨs siya ha boɨnmɨmauu bwakainamɨn kamɨm siir mɨi kɨgna mɨriiyɨm sɨmiir. Mɨ ɨi kara om Jerusalem hɨriir nami mɨ kara wɨ hɨk kɨmpɨpɨsu kasa hai rani. Mɨ inkam komiiyɨm Adi Komii siir mɨi kɨgrɨraowi ɨkɨm mɨ prismi bɨiyan inkam ɨkɨm mɨ kamɨm siyɨu komii ɨiir nɨnoknɨnkɨni ɨkɨm. Mɨ wɨ hɨk kɨmpɨpɨsu kariir hauuwi mɨ kariirɨn wɨ sɨma nɨsomaoki. Mɨ ɨi kwoɨmaka kara wa swokɨ ɨnsiin ɨdwowi ɨe hɨrankɨn. ");
INSERT INTO iws_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Mɨ Pita siya siir yɨkɨunam mɨ siirɨn ɨgao yai yanɨ boɨnɨu. Bɨiyan Inkam Komii kɨbɨe idwai tɨ dimɨnɨn wɨ kɨriir kɨpi swokɨ ɨmbini mɨmɨn. Adi Komii siya wɨ hɨnɨɨna boɨni. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Mɨ Jisɨs siya ha haiyɨug kaokiyɨn mɨ Pita siir boɨnki, Setan kɨra tɨ amki! Kɨra kariir mɨi aiir kɨpi kiyopsɨbgi. Kɨra Adi Komii siir kwoɨnɨn siir bɨri nɨnoknɨnkɨnkɨn. Nɨɨngaka. Kɨra inkami kwoɨnɨn siirara nɨnoknɨnkɨni. ");
INSERT INTO iws_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Mɨ siya tɨ dimɨnɨm sɨmiir boɨn dɨgiyɨm. Mɨ Jisɨs siya kamɨm siir kɨgna mɨriiyɨm sɨmiir boɨnki. Mɨ inkamɨn kariir siyɨu ɨmiir napam nɨti mɨ siya siir kwoɨn ɨiir hɨdnani mɨ ha haiburgigi mɨ kariir mhoɨiya wɨt inkamɨn kariir mɨi ɨmiir mɨrii. Mɨ siya hɨk mɨ naosi kɨpi nɨdid. Kara naowi paeyɨn hɨiniya nɨrɨonɨnkɨnɨn siir hɨriinan. ");
INSERT INTO iws_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Inkamɨn kariir siyɨu ɨiir nap karamae nwowiyɨn siya siir kwoɨnaɨrgar prɨinaɨngwo dirɨraeraramar naɨngwowi. Mɨ siya naosi nɨdidiyɨn mɨ mhoɨiya siir kwoɨnbudɨn omwai waiyayokiyokɨiyɨn wɨ hindara kɨgugu ɨuguski wɨ omwai Adi Komii saɨka waiyayokiyokɨi rani, ɨinokɨinokɨn mɨ yɨpɨkɨ inkamkɨn saama naɨngwo karamae nwowiyɨn, inkamɨn siya kariir mhoɨiya nɨti mɨ yɨo siya naosi bɨ nɨdidkɨn mɨ mhoɨiya tɨ inkamɨn siir kwoɨnbudɨn wɨ Adi Komii saɨka nwoyokyokɨi kaeyami ɨinokɨinokɨn. ");
INSERT INTO iws_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mɨ inkam nwɨrɨn digworaekwo whɨekakakɨ nɨuwi tɨ nu ɨiirɨn mɨ siya Adi Komii siir mhoɨiya nam karamae nwowi mɨ siir kwoɨnbudɨn wɨ hindara kɨgugu ɨuguski mɨ tɨ siir dimɨn taemɨn whɨekakɨm nu tɨranɨm wɨ siirar whɨnkɨnsiisi, aniya? Nɨɨngaka. Mɨ siya wɨ dimu dimɨn haii kwoɨnbud ɨiir whɨnkɨnsiisamɨn ɨinokɨinokɨn Adi Komii saɨka nwowamɨn, ha? Nɨɨngaka. Siya siyɨu karamaeka. ");
INSERT INTO iws_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mhoɨiya kara Yaowae Adɨn nɨnomor kouanɨn, kara wɨ Adi Komii siir kɨrɨeyɨm sɨmaka nɨti mɨ saeya wɨ paenan nɨuya haigɨnɨuwi krɨmiirɨn. Mɨ Adi Komii siir paekwosɨmɨm wɨ kanaka nɨnkɨn ɨti. Mɨ taka ɨi aiirarɨn kara wɨ nu tɨran iikamɨm sɨmiir mɨi ɨmiir hɨdi mɨi mɨiyɨka kara wɨ dimɨn mɨiyɨk ɨiirar hauuwi mɨi biyɨeya kara wɨ dimɨn biyɨe ɨiirar mɨ hauuwi. ");
INSERT INTO iws_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kara kɨmiirɨn yaimwowar boɨni tɨ iikam nhɨrɨm tɨrar nwowɨm kɨma wɨ nikɨ ao rani, kɨma wa kɨgwɨni ɨiya Yaowae Adɨn nɨnomor kouanɨn mɨ dimɨn taemɨn komiiyɨm mɨ ɨiya siya iikamɨm sɨmiir kɨgɨrkakana saiirɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mɨ ɨi ɨriiyar kwɨra yamki mɨ Jisɨs siya ɨna yɨkɨunamɨn Pita mɨ Jems mɨ Pita siir nomousɨmɨn Jon siir warar. Mɨ siya sɨmiir yɨkɨunam mɨ sɨma sɨmar iinaiinam mhɨu whɨrɨn siir. Tɨ mhɨuwɨn haruwa rani, ɨni kougɨkou hɨrar nwowɨn mɨ sɨma siir inɨ owɨu tɨ mhɨu ɨiirɨn sɨma sɨmar. ");
INSERT INTO iws_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Sɨma hɨrar nwowa mɨ Jisɨs siir pɨua ɨna kisɨnakiya sɨmiir whwonkamɨdar mɨ siya ɨni yaeya pɨu ywokiyɨn. Mɨ siir whwonkamɨn ɨni bɨenanar whwoyakiyɨn mɨ siir yɨuɨsa ɨni paenanar yɨuyakiya mɨ ɨni whɨsinanar ywokiyɨn. ");
INSERT INTO iws_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Moses, Ilaija sowa Adi Komii siir om ɨiir haiburgiko mɨ sowa Jisɨs saɨka nokwo boɨnaiko. Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma ɨna kɨgɨm sɨma boɨnaiyɨm. ");
INSERT INTO iws_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Mɨ Pita siya hɨriinan kɨgiyɨn mɨ Jisɨs siir boɨnki, Bɨiyan Inkam Komii krɨma tɨr nwowɨm ɨni wadɨeyar mɨ owɨm mɨ kɨra naɨngwowi mɨ kara amɨrɨm pɨ kwoɨma mɨrii, ɨra kɨriirga mɨ ɨra Moses siiram mɨ ɨra Ilaija siiram? ");
INSERT INTO iws_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mɨ siya hɨrar nikɨ boɨnaiyɨn mɨ wau kwɨra ɨni paenana yɨuyakiya ɨni sɨmiirar yakikirɨnuniya. Mɨ yai kwɨra ɨni ta waua saiir hɨrankar yɨmbiniya, saeya boɨnki. Tɨkɨnɨn kariir yɨnisɨmkɨn, kara siirɨmar naɨngwo nanaeikɨn mɨ kariir mhɨi kwoɨnɨm siirɨmɨn wadɨeya nwowi mɨ kɨma siir yai aiir wakae! ");
INSERT INTO iws_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma ta yai aiir wakaekiyɨm mɨ ogmwo nua hɨriir waisi kaiyɨrou hɨunainam mɨ sɨma nɨdid prasae bɨ kɨnkɨm. ");
INSERT INTO iws_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Mɨ Jisɨs siya sɨmiir kingiin ha nɨtɨn mɨ sɨmiir yonkwoni mɨ siya sɨmiir boɨni, kɨma dɨnsiingi, kɨma kɨpi nɨdid! ");
INSERT INTO iws_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Mɨ sɨma ha nɨnsiingiyɨm mɨ koua ha ninansiin kaokiyɨm mɨ sɨma yaeya inkam nwɨr bɨri kɨgɨm. Nɨɨngaka. Sɨma Jisɨs siirarar kɨgi. ");
INSERT INTO iws_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mɨ sɨma tɨ mhɨu ɨiir haiburgigɨm mɨ ha nɨuunaiinamɨm mɨ Jisɨs siya ɨgao yai sɨmiir boɨnki, kɨma inkam nwɨr kɨpi boɨnmauu tɨ dimɨnɨn kɨma kɨgɨn. Nɨɨngaka. Ɨiya Yaowae Adɨn nɨnomor kouanɨn siya nɨtana mɨ siya ɨe hɨrankɨ nɨnsiin ɨdwowi mɨ wɨ saiirar nhɨnkigi. ");
INSERT INTO iws_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tɨ dimɨnɨm sɨmiir mhoɨiya mɨ kam nwoɨmɨm siir kɨgna mɨriiyɨm sɨma srɨigi. Mɨ kamɨm siyɨu komii nɨnoknɨnkɨniyɨm, sɨma hɨnɨɨna dimusi boɨnkɨm, bɨiyɨn wɨ Ilaija siya nɨti, ha? Mɨ tɨ inkamɨn Adi Komii siya nɨkropkiyɨm wɨ mhoɨiya nɨti. ");
INSERT INTO iws_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Mɨ Jisɨs siya ɨna yowarkɨi boɨnɨn. Ɨhɨ, kaimwoka, bɨiyɨn wɨ Ilaija siya nɨti mɨ digworaekwo whɨekakɨm wɨ siyar dirɨraerar kwokɨni. ");
INSERT INTO iws_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Jisɨs siya sɨmiir boɨn, kara kɨmiirɨn, pɨ hɨnɨɨna boɨnki Ilaija siya bɨdi yɨtɨn mɨ iikamɨm sɨma siir bɨ nɨnoknɨnkɨnkɨm nɨɨngaka, sɨma sɨmiir siyɨu ɨmiir napama naɨngwokɨm mɨ sɨma siirɨn siyɨu biyɨe asi tɨraigɨnɨugikɨm mɨ kariirɨn Yaowae Adɨn nɨnomor kou hɨrankɨ nɨtɨn siirɨn wɨ hɨriinanar mɨ tɨrbumbuwi. ");
INSERT INTO iws_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Mɨ Jisɨs siya kam nwoɨmɨm siir kɨgna mɨriiyɨm sɨmiirɨn hɨnɨɨna boɨnki mɨ sɨma ɨna yɨnoknɨnkɨnkiyɨm, siya sɨmiirɨn Jonɨn op baptais haigɨnɨuwanɨn siir boɨni, Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mɨ sɨma ha swokɨ apamɨm mɨ ɨni maeyauwa iikam isid komiiyɨn siya nwowa saiir yɨmbiyam. Mɨ inkam nwɨrɨn ogmwo siirɨm inɨ hɨuɨu. ");
INSERT INTO iws_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Mɨ siya ɨna boɨnɨn, Bɨiyan Inkam Komii, kɨra kariir yɨnisɨm ɨiirsi daɨngwoyɨmyok, kariir yɨnisɨm yɨnkamiyɨn ɨiir kɨgi siya mɨiyɨkɨ mɨiyɨk rani, whaowa pɨunan nwowi mɨ nopnopa mɨ kɨni. Ɨinokɨinokɨn siya paenau nakaigainanaei mɨ ɨi nhɨrɨm pɨ opa mɨ amainami. ");
INSERT INTO iws_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mɨ kara siirɨn kamɨm kɨriir kɨgna mɨriiyɨm sɨmiirɨm nɨkɨunamɨn mɨ sɨma siir haiswo nɨskiyɨm dɨg bɨ nwokɨm. ");
INSERT INTO iws_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jisɨs siya sɨmiir yaiyaka ɨna yowarkɨi boɨnɨn. Kɨma tɨ hɨnɨɨn kam isidɨn naɨngwo tɨbmii karamaekɨm mɨ kɨmiir mhɨi kwoɨnɨm wadɨe sɨbgu o rani! Ɨiya kara kɨmaka nikɨ owɨm pariigɨm, ha? Mɨ kɨma Adi Komii siir yai aiir mɨ sɨbgu wakaeyɨm, kara kɨmiirɨn wɨ pariig ɨiya swokɨ boɨni, kɨma naɨngwo tɨbmiiyɨm kɨma wara yɨnisɨm ɨiirɨn kariiram wɨkɨunani. ");
INSERT INTO iws_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Mɨ Jisɨs siya tɨ uridyɨu biyɨeyɨn ɨgao yai siir boɨnki, uridyɨu biyɨe kɨra damki mɨ siya tɨ uridyɨu biyɨeyɨn bɨri kɨmɨmɨnkikɨn, ɨna yamkiyɨn mɨ siya tɨ yɨnisɨm ɨiirɨn ɨna haiswonɨski haigɨnɨugiyɨn. ");
INSERT INTO iws_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mɨ mhoɨiya kamɨm siir kɨgna mɨriiyɨm sɨmasɨmar yɨt, omaka hɨriir, Jisɨs siir inɨ srɨini. Mɨ siir inɨ boɨnɨu mɨ krɨma tɨ hɨriinan uridyɨu biyɨeyɨn tɨ siir nwowɨn siir haiswonɨski karamae dimusi nwokɨm, ha? ");
INSERT INTO iws_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Mɨ Jisɨs siya sɨmiir boɨnki, kɨmiir naɨngwo tɨbmiiya kabi rani. Mɨ kɨma hɨriinanɨm wɨ dɨg nwo rani. Ɨhɨ, kara kɨmiirɨn yaimwowa boɨni, kɨmiir naɨngwo tɨbmiiya kabi rani, mastet nidisɨmɨn siir hɨriinan nwowi mɨ kɨma wɨ tɨ mhɨuwɨn siir boɨnki, kɨra pɨ hɨnda dɨnsiin apnam! Mɨ siya wa nami mɨ kɨma Adi Komii siirɨm naɨngwo tɨbmii mɨ dimɨnɨn kɨma boɨni sɨma wa nɨmbiyami. ");
INSERT INTO iws_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Tɨ hɨriinan uridyɨu biyɨeyɨn siir haiswonɨskiyɨm yɨo yaeya siyɨu whɨr karamaeka. Nɨɨngaka. Mɨ siyɨu whɨruwan siirar haiswo nɨskiiyɨn mɨ nhwo kwɨs boɨni siyɨu ɨkɨn mɨ nae haiyani siyɨu ɨkɨn mɨ sowa sowaɨrgo.) Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Mhoɨiya Jisɨs siya mɨ kamɨm siir kɨgna mɨriiyɨm sɨma nu Galili hɨr nɨdwo boɨnaigɨm mɨ Jisɨs siya sɨmiir boɨnmɨmauu. Mɨ kara Yaowae Adɨn nɨnomor kou hɨrankɨ nɨtɨn siirɨn wɨ wɨr sauan kam nhɨrɨm sɨmiir napwouwi. ");
INSERT INTO iws_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Mɨ wɨ sɨma nɨsomaowi siirɨn mɨ ɨi kwoɨmaka kara wa swokɨ ɨnsiin ɨdwowi mɨ wɨ omwaiya swokɨ waiyaei mɨ ɨiya kamɨm siir kɨgna mɨriiyɨm sɨma tɨ dimɨn ɨiir wakaekiyɨm sɨma hɨk prasae bɨri haigɨm. ");
INSERT INTO iws_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ɨiya Jisɨs siya mɨ kamɨm siir kɨgna mɨriiyɨm sɨma om Kapeneam hɨriir nɨmbiyamɨm mɨ inkamɨm umɨr haiiyɨm Adi Komii siir omaka saiir mɨ sɨma Pita siir hɨriir yɨmbiyam mɨ sɨma siirɨn hɨnɨɨna srɨi, kɨmiir inkamɨn inkam nowomwarkaiyɨuwiyɨn siya takis umɨra hauuwigɨn omaka Adi Komii siira saiirɨn, aniya? ");
INSERT INTO iws_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Mɨ siya hɨnɨɨna yowarkɨi boɨnɨn, ɨhɨ, umɨrɨm omaka Adi Komii siira saiirar hauuwikɨn. Mɨ siya omaka hɨriir yapnɨnopkainam mɨ yaiya bɨiyɨn Jisɨs siya boɨnkɨnkina mɨ Pita siir srɨi, Pita kɨra panɨɨna naɨngwowi, ha? Mɨ yɨpɨkɨn inkam komiiyɨn nu kɨgrɨraowiyɨn sɨmiir hauuwi, ha? Sɨma pɨ sɨmiir om komii whɨruwan isidan inkam ɨkɨm mɨ om komii whɨran ɨkɨm pɨ sɨmiir takis umɨr namisi haii? ");
INSERT INTO iws_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Mɨ Pita siya hɨnɨɨn yowarkɨi boɨn, iikamɨm om komii whɨranɨm. Mɨ Jisɨs siya siir boɨnki mɨ inkam komii nu kɨgraraowiyɨn iikamɨm. Mɨ nɨm krɨma Adi Komii siir yɨnisɨsɨmkɨm. Mɨ ta omaka siirga mɨ takis umɨrɨm siirɨn pɨ hau rani. Nɨɨngaka! ");
INSERT INTO iws_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Mɨ krɨma sɨmiirɨn hɨriinan tɨri umɨr hau karamae nwowi mɨ sɨma wɨ ɨo krɨmiir nwowi, kɨra whɨiya saiir dam mɨ sɨr tinɨ kimaiyɨu. Mɨ anasuɨn bɨigɨ bɨi kɨra kikaii kɨra pɨ siir yai aiirar dɨinɨsakwo kɨg mɨ kɨra pa kɨgi umɨr kwɨra ɨni siir yainau hɨrar nwokaiya. Mɨ kɨra ta umɨra anasuɨn siir yainau nwokaiya saiirar saɨn kamɨm takis umɨr haiiyɨm sɨmiirɨn. Mɨ ta takis umɨra Adi Komii siir omaka saiir saɨna ya krɨriirga. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mɨ ta Ɨiya kamɨm Jisɨs siir kɨgna mɨriiyɨm sɨma siir hɨriir yɨmbiyam mɨ ɨna srɨiyɨm, yɨpɨkɨn Adi Komii siir iikamɨm sɨmiir kɨgrɨraowiyɨm sɨmiir kou nwowɨn? ");
INSERT INTO iws_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Mɨ Jisɨs siya yɨnisɨm nwɨrɨn siir yɨkɨuna okwo sɨmiir bopwoniya hɨrɨn. ");
INSERT INTO iws_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Mɨ siya ɨna boɨnɨn, kara kɨmiirɨn yaimwowa boɨni, kɨma tɨ yɨnisɨm sapɨsapɨn siir hɨriinan nwowi, digworaekwosi naɨngwoyɨmiyok karamae nwowi mɨ kɨma Adi Komii siya siir iikam whɨekakɨm sɨmiir kɨgɨrkakana saiirɨn wɨ wara nwo rani. ");
INSERT INTO iws_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Inkamɨn siyamar naɨngwona karamae nwowi mɨ inɨg karamae tɨ yɨnisɨm sapɨsapɨn siir hɨriinan mɨ tɨ inkam hɨriinanɨn bɨi wɨ siya nwowi, Adi Komii siya siir iikam whɨekakɨm sɨmiir kɨgɨrkakana. ");
INSERT INTO iws_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yɨpɨkɨ kariir yai aiir wakaeyoknaei mɨ siya iikam nhɨrɨm sɨmiirɨn siyɨu mɨiyɨk tɨri, tɨ yɨnisɨm sapɨsapɨn siir tɨrɨn saiir hɨriinan. Mɨ tɨ hɨriinanɨn yɨo siyɨu mɨiyɨk kariirar tɨrhaigɨnɨuwi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Mɨ inkamɨn, inkam nwɨrɨn inɨg karamaeyɨn siir naɨngwo tɨbmiiya saiir tɨrbumbuwi, yɨo ɨni tɨ yɨnisɨmɨn siir hɨriinan ywowɨn. Mɨ siya siyɨu biyɨe tɨrnami. Mɨ kɨma yɨɨbsiiya komii saɨka kogi tɨ hɨriinan inkamɨn mɨ whɨi solwara saiir bopwoniya hɨr kimai whɨridgi mɨ siya pɨ hɨr kwiyae haɨngrɨkɨu aonamɨm. Ta hɨriinan hɨka ɨni wadɨe ywowa mɨ Adi Komii siya hauukɨswo wɨ biyɨekɨ biyɨe pɨ ywowɨn. ");
INSERT INTO iws_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mɨntarao tɨ nu ɨiirɨn digworaekwo biyɨe biyɨe whɨekakɨm ɨni tɨrar nwowɨm mɨ sɨma tɨrbumbuwi kɨmiirɨn mɨ tɨ dimɨn biyɨe whɨekakɨm sɨma wɨ hɨriiyar nwoyokiyowɨi. Mɨ mhoɨiya wɨ Adi Komii siya tɨrbu ɨguski inkamɨn, inkam nwɨrni naɨngwo tɨbmii tɨrbuwɨn. ");
INSERT INTO iws_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Mɨ ɨga ɨɨna sowa siyɨu biyɨe tɨram mɨni mɨ kɨra sowiir kaigrɨp ɨtkiki mɨ kɨriir ɨga ɨɨna kwokwɨra nwowi mɨ ɨni mɨ owɨn kɨra ɨga kwɨr mɨ ɨɨna kwɨra namɨm omwai waiyae yokiyokɨiyɨm. Yɨo wɨ mɨiyɨk mɨiyɨk nwo rani, kɨra paeya nɨuyokiyokwɨiya saiir hɨriir nami ɨga ɨɨn kwiiyarar. ");
INSERT INTO iws_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mɨ kɨriir nhwoɨn siya dimɨn biyɨe tɨram mɨni mɨ kɨra siir habɨtkɨigi mɨ ɨni mɨ owɨn kɨra nhwona nhɨruwa mɨ ami omɨn omwai waiya yokiyokɨiyɨn. Yɨo wɨ mɨiyɨkɨ mɨiyɨk nwo rani, kɨra paeya nɨuyokiyokwɨiiya saiir hɨriir nami nhwona nhɨsar. ");
INSERT INTO iws_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Kɨma mɨntarao! Kɨma ha kɨpi naɨngwo tɨ iikam sɨma kariir siyɨu ɨiir napɨn sɨma iikam nɨɨngakɨ nɨuwi. Nɨɨngaka. Kara kɨmiirɨn pɨ hɨnɨɨna boɨni, Adi Komii siir paekwosɨmɨm sɨma kɨgrɨraowi sɨmiirɨn. Mɨ sɨma ɨni siir om hɨrar nwowɨm. Mɨ sɨmiirɨn wɨ siya boɨni. ");
INSERT INTO iws_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kara Yaowae Adɨn nɨnomor kouanɨn siya iikam biyɨeyɨm nu tɨranɨm sɨmiir nanmaiwarkainam nɨtkɨn. Ɨriig ");
INSERT INTO iws_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Kɨma panɨɨna naɨngwowi, ha? Inkam nwɨrɨn siir sibsibɨm kamararɨm ɨriiyarkɨm (100) mɨ sɨmiir ɨrɨn ɨni niimau whaowaekiyɨn mɨ siya wɨ siirɨm hansɨram tani, aniya? Iyɨe? Nɨɨngaka. Mɨ siya tɨ kamnwii ɨuur ɨriiyar ɨdiyɨm (99) wɨ mhɨuisɨmɨn siir hɨr haiburgigi mɨ siya sibsib ɨrɨn whaowaekiyɨn wɨ siirɨm ninɨ hansɨrɨuwi. ");
INSERT INTO iws_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kara kɨmiirɨn yaimwowa boɨni, ɨiya siya pɨ siir hansɨr haii mɨ maɨrgɨmaɨrga tɨ ɨrua siirɨm nwowa mɨ ɨni tɨ kam nwii ɨuur ɨriiyar ɨdiyɨm (99) sɨmiir haibura. ");
INSERT INTO iws_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mɨ ɨriipa hɨriinan nɨnomor kouanɨn siya hɨnɨɨnɨm naɨngwo rani, siir yɨnisɨm nwɨrkɨ wɨ kɨpi swokɨ whaowae ɨuguski paeya hɨriir. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Mɨ kɨriir nomiiyauɨn siya siyɨu biyɨe kɨnaka tɨrbugɨn mɨ kɨra siirɨm dam mɨ kowa maeyauu kwɨruwa dɨdwo mɨ siyɨu biyɨe siya kɨriir tɨrbuɨn mɨ kɨra siir boɨnmauu. Mɨ siya kɨriir yai aiir wakae tɨ hɨriinan siyɨu biyɨe siya tɨrɨn wɨ digɨumii siir haimriiyɨugigi mɨ siirɨn kɨrar whɨndirɨraerar haigɨnɨu mɨ siya wɨ wadɨeya sɨbgu owɨm. ");
INSERT INTO iws_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mɨ siya kɨriir yai aiir sɨbgu wakaeyokna karam nwowi mɨ kɨma Moses siir yaiya saiir hɨriinan dirɨraerar mɨ kɨra inkamo naɨngwo tɨbmiiyo nwɨsa dɨnkɨn ɨkɨuna mɨ sowa kɨnaka dam, yai kɨriir whɨnboɨnaiyɨm. ");
INSERT INTO iws_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mɨ siya kam nwoɨmɨm kɨmiir yai wakae karam nwowi mɨ kɨra iikam nhɨrɨm Adi Komii siirɨm naɨngwo tɨbmiiyɨm sɨmiir dɨkɨuna mɨ kɨma ɨrɨpa hangiriyɨu boɨnai mɨ siya sɨmiir yai wakae karam nwowi mɨ kɨra siirɨn hɨnɨɨna daɨngwo siya naɨngwo tɨbmiiyan inkam tani siya siyɨu biyɨeyɨm sɨmiir tɨriikɨm mɨ kɨma siirɨn hindara hɨuriyɨumi ɨuguski. ");
INSERT INTO iws_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Kara kɨmiirɨn yaimwo aiirar boɨni, dimɨnɨn kɨra nu tɨr kɨgnɨnkɨnkikɨn, mɨ Adi Komii siya nɨnomor kou hɨrɨn wɨ hɨriinanar mɨ kɨgnɨnkɨnki siirɨn. Dimɨnɨn kɨra naɨngwowɨn nu tɨr kɨgnɨnkɨn owam mɨ Adi Komii siya nɨnomor kou hɨrɨn wɨ hɨriinana mɨ kɨgnɨnkɨn owi siirɨn. ");
INSERT INTO iws_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mɨ kara kɨmiirɨn pɨ hɨnɨɨna swokɨ boɨni inkam nwɨswo nu tɨrano sowiir kwoɨnɨn whɨruwa nwowi mɨ ha kwɨsboɨni dimɨnam mɨ kariir Adɨn nɨnomor kou hɨr nwowɨn siya sowiirɨn wa wakaei. ");
INSERT INTO iws_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ɨhɨ. Dimusi rani, inkam nwɨs o nwoɨm sɨma sɨma nwowi maeyau kwɨr mɨ hangiriyɨu owi kariir inɨg ɨiirɨm mɨ kara wɨ sɨmaka hɨrar mɨ ɨnkɨn owi mɨ sɨmiirɨn wɨ karar whɨndirɨraerar haigɨnɨuwi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita siya Jisɨs siir hɨriir yɨmbiyam mɨ ɨna srɨiyɨn, Bɨiyan Inkam Komii, kariir nomiiyauɨn siya kariirɨn siyɨu biyɨe tɨrbuwi mɨ siir dimɨn biyɨeyɨm wɨ pariig ɨiya haiyoprimdiyɨumiigi tɨ dimɨn ɨmiirɨn mɨ ɨi ɨriiyar kwɨswo ɨni dɨgar mɨ owɨm, aniya? ");
INSERT INTO iws_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Mɨ Jisɨs siya siirɨn hɨnɨɨna yowarkɨi boɨnki, kara kɨriirɨn ha boɨn tani ɨiyɨm ɨriiyar kwɨs. Nɨɨngaka. Kara ha boɨnki kɨra haiyoprimdiyɨumiigi ɨiyɨm kam nwoɨm ɨuur ɨriiyar kwɨs (77). ");
INSERT INTO iws_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kara kɨmiir boɨni tɨ siyɨuɨn dimɨn biyɨe haiyoprimdiyɨumiiyɨm. Dimusi rani, Adi Komii siya siir iikamɨm sɨmiir kɨgɨrkakana ɨni inkam komii nu kɨgrɨraowiyɨn siya umɨrɨm siir mɨiyan kamɨm whɨsarii sɨma prɨihaiyɨm sɨmiir swokɨ hauu kɨiyɨuwam tɨri, ɨni saiir hɨriinan ywowɨm. ");
INSERT INTO iws_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Siya kamɨm umɨrɨm whɨsarii prɨihaiyɨm sɨmiirar kwamɨrii bwakainamɨn sɨmiir hauukɨiyɨuwam mɨ sɨma inkam nwɨrɨn siirɨm yɨkɨuna mɨ umɨrɨm siya haiyɨm 10 milionkɨm mɨ siya yamdi siir swokɨ hauuwɨm. ");
INSERT INTO iws_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mɨ siya tɨ umɨrɨm siya prɨihaiyɨm sɨmiir umɨr ɨmiir swokɨ hauukɨiyɨuwɨm dɨg rani. Mɨ inkam komii ɨna boɨnɨn kɨma wara inkamɨn mɨ siir wig yɨnɨm mɨ siir digworaekwo whɨekakɨm sɨmiir wɨkropki iikam nhɨrɨm sɨma saɨnɨm mɨ tɨ umɨrɨm wɨ ɨkɨ dimɨnɨm siya prɨi haiyɨm sɨmiir nwokɨ hauukɨiyɨuwɨm. ");
INSERT INTO iws_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Mɨ tɨ mɨiyan inkamɨn siya inkam komii ogmwo saɨka kingiina inɨ hɨuni mɨ ɨna boɨnɨn, kɨra kariirsi daɨngwoyɨmyok mɨ ha tikɨ o! Umɨr whɨekakɨm kara prɨihai prɨihaiyɨm wɨ kɨriir swokɨ hauukɨiyɨu dɨgi. ");
INSERT INTO iws_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mɨ inkam komiiyɨn tɨ siir mɨiyan inkam ɨiirsi yaɨngwoyɨmyok mɨ siirɨn ɨna swokɨ ɨkropkiyɨn mɨ umɨrɨm siya prɨihaiyɨm sɨmiir warar yɨnkɨn ɨuguski. ");
INSERT INTO iws_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Mɨ tɨ mɨiyan inkamɨn yaba hɨriir napniyamɨn mɨ siir nomiiyau nwɨrɨn ɨrɨpa mɨi sowa mɨriiyɨn siir yani kɨgɨu mɨ umɨrɨm siya siir hɨrankɨn prɨihaiyɨm paeyarɨn haɨrkɨn mɨ siya siir nɨi ɨiir yonkwo nhɨowomwan mɨ siirɨn ɨna boɨnɨn, umɨrɨm whɨsarii kɨra haiyɨm kariir tɨrɨnkɨn, kɨra kariir swokɨ hauugi. ");
INSERT INTO iws_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mɨ siir nomiiyauɨn ogmwo ha hɨuɨn mɨ hɨnɨɨna kauwok boɨnanae, kɨra kariirsi daɨngwoyɨmyok mɨ ha tikɨ o, umɨrɨm whɨsarii kara haiyɨm sɨmiirɨn wɨ yamdiya swokɨ hauuwi. ");
INSERT INTO iws_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Mɨ siya ɨni boriisop waeyaoɨn mɨ siirɨn maeyaua hɨuyokiyokaiya mɨi biyɨe mɨriiya saiir hɨr inɨ whɨnap kinɨsugik mɨ siya siir umɨr yamdi swokɨ hauu dɨgi mɨ siya yaba wa nɨti. ");
INSERT INTO iws_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Mɨ siir nomiiyauɨm tɨ hɨriinan siyɨu ɨiir kɨgɨm mɨ sɨmiir kwoɨnɨm mɨiyɨk bɨ naɨngwokikɨm mɨ sɨma ɨni inkam komii ɨiirɨma yamɨm, tɨ siyɨu hɨriinan siya sɨmiir nomiiyau ɨiir tɨrgigɨn siir inɨ boɨnmɨmauɨu. ");
INSERT INTO iws_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mɨ inkam komiiyɨn siya asi nɨkɨunakikɨn tɨ siir mɨiyan inkam ɨiirɨm mɨ siirɨn hɨnɨɨna boɨnki, kɨra inkam mɨiyɨk rani, bɨiya kɨra kariirɨma nikɨ kauwok boɨnanaekɨn. Kɨra kariirsi daɨngwobumbugi mɨ kara kɨriirsiyɨn ɨna yaɨngwobumbugiyɨn mɨ kara kɨriirɨmɨn ha bɨ nɨkɨunanaekɨn kɨra kariirɨn tɨ umɨr komiiyɨn siirɨn yamdiya whauukɨiyɨu sasau. ");
INSERT INTO iws_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Dimusi rani, kɨra kɨriir nomiiyauɨn ɨrɨpa mɨi kowa mɨriiyɨn siirsi bɨ naɨngwoyɨmiyokɨn kara kɨriirsi naɨngwoyɨmiyoka saiir hɨriinan, ha? ");
INSERT INTO iws_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mɨ inkam komiiyɨn siir kwoɨnɨn haugɨhauga whwiyɨeyɨn mɨ kam nhɨrɨm sɨmiir yɨkropki mɨ sɨma siir yɨnɨmnan ɨtkɨn mɨ sɨma siirɨn maeyaua hɨuyokiyokaiya mɨi biyɨe mɨriiya saiir hɨr inɨ whɨnap kinɨsugik ɨiya siya umɨr hauukɨiyɨuwi wɨ saiir dɨgi. ");
INSERT INTO iws_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Mɨ kara kɨmiirɨn pɨ hɨnɨɨna boɨnki. Mɨ kɨmiir kwoɨnɨm dimɨn biyɨe whɨekakɨm kɨmiir nomiiyauɨm sɨma tɨrbumbuɨm mɨ sɨmiir haiyoprimdiyɨumiigi karamae nwowi mɨ kariir Adɨn nɨnomor kou hɨr mɨ owɨn siya ɨriipa hɨriinan, kɨmiir dimɨn biyɨeyɨm wɨ sɨmiir mɨ haiyoprimdiyɨumiigi rani. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisɨs siya tɨ siir yaiyɨm sɨmiir ha boɨn dɨgiyɨm mɨ nu Galili siir haiburgik mɨ nu Judia mɨ yabɨe komii Jodan siir yarmiiya hɨriir swokɨ haiyɨug nam. ");
INSERT INTO iws_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mɨ iikam whɨekakɨm ɨni siir mhoɨiya kaikwokwo namɨm. Mɨ ta maeyau aiirɨn iikamɨm makakɨm sɨmiirɨn hɨr haiswonɨmnɨskɨigɨm. ");
INSERT INTO iws_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mɨ Farisi kam nhɨrɨm ɨna yɨtɨm siirɨm mɨ sɨma siirɨm inɨ boɨnkɨnankɨuni mɨ siirɨn ɨna srɨiyɨm, Moses siir siyɨuɨn tɨ krɨma napɨn siya mɨiyɨkargɨn, siya hɨriinan bɨdi boɨnɨn inkamɨn siya siir wig aiirɨn ha sopki, aniya? ");
INSERT INTO iws_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jisɨs siya hɨnɨɨna yowarkɨi boɨn mɨ kɨma tɨ yaiyɨm Yokwo Komiiya saiir nwowɨm, sɨmiir bɨ mwaɨngɨm, ha? Siya hɨnɨɨna boɨn, bɨdi bɨdiniyarɨn Adi Komii siya digworaekwo whɨekakɨm sɨmiirar nonkwokwowɨn mɨ siya wigkam warar yɨnkɨn onkwokwoki. ");
INSERT INTO iws_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Mɨ Adi Komii krɨmiir Wanɨn siya hɨnɨɨna boɨnkɨn, tɨ hɨriinan siyɨuɨn, kamɨm siir yopii ad owiir haiburgigi mɨ siir wig anaka namwoɨuwi mɨ sowa ɨni ɨrɨpa pɨu kwɨruwa ywokiywo! ");
INSERT INTO iws_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Mɨ kɨra hɨriinan tɨri. Mɨ sowa ɨni pɨu kwɨruwa ywokiywo. Dimɨnɨn Adi Komii siya nokiyopmasugiyɨn inkamkɨ siir nɨkrɨpɨm dɨg nwo rani. ");
INSERT INTO iws_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mɨ Farisi kamɨm sɨma siirɨn hɨnɨɨna srɨi boɨn Moses siya tɨ hɨriinan yaiya krɨmiir dimusi hauugigɨm, kamɨn siya yokwowa ha wɨnki, ta wig aiirɨm sowiir nonkwona aiir nɨkrɨpam mɨ siya hɨriinan dimusi wɨnkɨn, ha? ");
INSERT INTO iws_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Mɨ Jisɨs siya sɨmiir yai aka yowarkɨi boɨnki. Dimusi rani, kɨma pɨ nantamyɨriyɨrkɨm Adi Komii siir yai aiir. Mɨ Moses siya kɨmiirɨn asi kɨgnɨnkɨnkikɨn. Wigkam sopni siyɨuɨn mɨ bɨdi bɨdiniyarɨn Adi Komii siya wig sopni siyɨuɨn siirɨm bɨ naɨngwokɨn. ");
INSERT INTO iws_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kara kɨmiirɨn pɨ hɨnɨɨna boɨnmauugi. Mɨ kam nwɨrɨn siir wiga saeya hɨi kam nwɨr aka bɨ nanae mɨmɨnka mɨ tɨ hɨriinan kamɨn siya saiirɨn whɨsariiyar sopkikɨn mɨ siya yaeya wig ɨr yonkwonaɨu, tɨ hɨriinan inkamɨn siya nonkwonani siyɨuɨn siir tɨrbugɨn. ");
INSERT INTO iws_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kamɨm siir kɨgna mɨriiyɨm sɨma hɨnɨɨna boɨnki mɨ siya hɨnɨɨna boɨnkɨswo wig nonkwonani siyɨuɨn yɨo ɨni kɨrɨe ywowɨn mɨ inkamɨn siya ɨɨndɨma mɨ owi ɨni mɨ owɨn. ");
INSERT INTO iws_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Mɨ Jisɨs siirɨn hɨnɨɨna yowarkɨi boɨn, iikam whɨekakɨm sɨma ta yaiya saiir wakaeyokna apam pɨ boriisopi. Nɨɨngaka. Mɨ iikamɨm Adi Komii siya nɨmbinɨm sɨma sɨmargɨm tɨ siyɨuɨn siir wakaeyoknaei. ");
INSERT INTO iws_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Wakae, kam nhɨrɨm sɨma wig nonkwona dɨg nwo rani. Dimusi rani, ɨiya sɨmiir yopiiga naokainɨnkɨnkiyɨn yɨm ɨsi hɨriinanar mɨ owɨn, sɨma wig aka ɨrɨpa pɨu nwowɨm wɨ dɨg nwo rani. Dimusi rani, sɨma wɨ dɨg nwo rani, wiga aka ɨrɨpɨ pɨu nwowɨm mɨ kɨma nhɨrɨm kɨmiir mɨomaiyɨm bɨdi kɨntɨowɨm mɨ kɨma wig aka ɨrɨpa pɨu wa nwowi mɨ kɨma wɨ yɨnɨekak nwo rani. Mɨ nhɨrɨm sɨma Adi Komii siir mɨiya saiir mɨriiyamar naɨngwowi. Dimusi rani, siya digworaekwo whɨekakɨm sɨmiirar kɨgrɨraowikɨn mɨ sɨma wig nonkwonam pɨ boriisopi. Inkamɨn ta yaiya saiirɨm naɨngwowi mɨ maɨrgɨmaɨrga nwowi mɨ siya wɨ saiirar wakaeyoknaei. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ta ɨi aiirɨn iikam nhɨrɨm sɨma yɨnisɨsɨm nhɨrɨm Jisɨs siirɨm hainamkɨm mɨ sɨma hɨnɨɨna naɨngwokɨm, Jisɨs siir ɨɨna sɨmiir nonkwo okboɨnmamaɨrɨm. Mɨ Adi Komii siirɨm kwɨsboɨnɨm. Mɨ tɨ kamɨm siir mɨi kɨgna mɨriiyɨm sɨma ɨo sɨmiir ywoki. ");
INSERT INTO iws_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Mɨ Jisɨs siya boɨn, kɨma yɨnisɨsɨmɨm sɨmiir kɨgnɨnkɨnki sɨma kariiram wit, kɨma sɨmiir kɨpi nɨkɨdu. Nɨɨngaka. Adi Komii siya tɨ iikamɨm sɨmiirar kɨgrɨraowi mɨ ɨni tɨ yɨnisɨsɨmɨm sɨmiir hɨriinan ywowɨm. ");
INSERT INTO iws_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Mɨ siir ɨɨna sɨmiir mwo ɨdwo yonkwo. Mɨ siya sɨmiirɨn ɨna yokboɨnmamaɨrɨn. Mhoɨiya siya ta maeyau aiir haiburgigɨn mɨ ɨna yamɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mɨ inkam nwɨrɨn Jisɨs siir hɨriir yɨmbiyam mɨ ɨna srɨi boɨnɨm. Inkamɨn iikam nowamwarkaiyɨuwiyɨn, kara wɨ panɨɨn dimɨn mɨiyɨkɨn siir tɨri mɨ kariir inɨgɨn wɨ kwoɨnbudɨn omwai waiyayokiyokɨiyɨn ɨinokɨinokɨn siir haiyamɨn, ha? ");
INSERT INTO iws_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Mɨ Jisɨs siir yowarkɨi boɨnki, kariiram dimusi srɨi pɨkɨ hɨnɨɨn dimɨn mɨiyɨkɨn siir haiyam srɨigɨn, ha? Adi Komii siyaɨrgɨn inkam mɨiyɨk nwowiyɨn. Mɨ kɨra kwoɨnbudɨn omwai waiyaiyɨn siiram naɨngwowi mɨ kɨra siyɨu komiiyɨn Moses siirɨn siya wɨnɨn bɨiya siirarar dapkrɨpkai. ");
INSERT INTO iws_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mɨ tɨ inkamɨn Jisɨs siirɨn ɨna srɨiyɨn, pɨkɨ hɨnɨɨn siyɨu ɨkɨm, Moses siirɨm, ha? Mɨ Jisɨs siya ɨna yowarkɨi boɨnɨn, tɨ sɨma. Kɨra inkam nwɨr kɨpi nɨtkikai mɨ kɨra hɨi kɨpi nanae, kɨra hɨi kɨpi tauae, kɨra inkam nwɨrni kɨpi nɨksɨsae boɨn hɨuriyɨu. ");
INSERT INTO iws_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Kɨra yopii adɨm sɨmiir yai ɨmiirar wakaeyokna mɨ sowiirwaiyɨn siyɨu mɨiyɨk ɨiirar tɨr. Mɨ kɨra iikam nhɨrɨm sɨmiirɨm naɨngwoyɨmiyokiyɨm mɨ kɨram naɨngwoyɨmiyoknaeiya mɨ saiir hɨriinana daɨngwoyɨmiyok. ");
INSERT INTO iws_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mɨ whranisɨmɨn siya siir boɨnki, tɨ siyɨu whɨekakɨm, kara sɨmiirarar mɨ apikɨn. Kara whaowaeyɨn pɨkɨ hɨnɨɨn dimɨn ɨkɨn? ");
INSERT INTO iws_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Mɨ Jisɨs siya siir boɨnki, kɨra wadɨe nwowi kɨriir digworaekwo whɨekakɨm iikam nhɨrɨm sɨmiir hauu sɨma saɨnɨm mɨ tɨ umɨrɨm kɨra ɨkɨ iikam paeprikabɨm sɨmiir hauugi. Mɨ kɨra hɨriinan tɨri, nɨnomor kou hɨrɨn kɨra wɨ digworaekwo whɨekaka nwowi. Mɨ tɨ kɨra tɨrɨm sɨmiir mhoɨiya kɨra wɨ kariir mhoɨiya wɨt. ");
INSERT INTO iws_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Mɨ ɨiya tɨ whranisɨmɨn ta hɨriinan yai aiir wakaeyɨn siir kwoɨnɨn ɨni hɨkaka ywonamɨn mɨ siya Jisɨs siir haiburgikɨn mɨ ɨna yamɨn. Dimusi rani, siya digworaekwo whɨekakakɨn. ");
INSERT INTO iws_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Mɨ Jisɨs siya kamɨm siir kɨgna mɨriiyɨm sɨmiir boɨnki, kara kɨmiirɨn yaimwo aiirar boɨnki. Inkamɨn umɨr digworaekwo whɨekakakɨn siya Adi Komii siir mhoɨiya namamɨn wɨ mɨinan mɨrii nami yɨpɨkɨ siir digworaekwo whɨekakɨm sɨmiir kɨgrɨraowiyɨm siirɨm. ");
INSERT INTO iws_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kara kɨmiirɨn pɨ hɨnɨɨna swokɨ boɨnki hab saeya tɨdiyɨnɨn digworaekwo paniyɨn siir no ɨiir nɨnopkai namamɨn wɨ dɨg nwo rani, inkamɨn umɨr digworaekwo whɨekakɨn siya ta haba mɨinan saeya mɨriiya saiir hɨriinan mɨi mɨrii rani. Nɨɨngaka. Yɨo wɨ mɨi kamiigɨkomii mɨriinami mɨ siya Adi Komiiyɨn digworaekwo whɨekakɨm sɨm kɨgɨrkakiyɨn wɨ saɨka namasu rani. Nɨɨngaka. Dimusi rani, siya umɨr digworaekwo ɨmiirɨmar naɨngwokwowi mɨ siirɨn wɨ sɨmar nɨkɨduwi. ");
INSERT INTO iws_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kamɨm siir mɨi kɨgna mɨriiyɨm sɨma ta yai aiir wakaeyɨm mɨ sɨma ɨna yanaakiyɨm. Mɨ sɨma boɨn mɨ siya tɨ hɨriinan inkamɨm siya dɨg nwo karam nwowi mɨ yɨpɨkɨn kwoɨnbudɨn omwai waiyayokiyokɨiyɨn siirɨn dɨg nwowi, ha? Nɨm krɨma ha naɨngwowi inkam nwɨrkɨ namɨm wɨ dɨg nwo rani. ");
INSERT INTO iws_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Mɨ Jisɨs siya sɨmiirar kao hɨrɨrɨukiyɨn mɨ ɨna yowarkɨi boɨnɨn. Iikamɨm sɨma sɨma whɨndirɨraerarna sɨmiir kwoɨnbudɨn omwai waiyayokiyokɨiyɨn wɨ dɨg nwo rani, Adi Komii siya tɨ dikworaekwo whɨekak ɨmiir dirɨraerari wɨ dɨga nwowi. ");
INSERT INTO iws_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pita siya Jisɨs siir boɨnmauugi Kɨgi! Krɨma krɨmiir digworaekwo whɨekakɨm sɨmiir hɨriinansi haiburgigɨm. Mɨ wɨ kɨriir mhoɨiyar nɨti. Mɨ mhoɨiya krɨma wɨ pɨkɨ hɨnɨɨn dimɨnɨn siir haii, ha? ");
INSERT INTO iws_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Mɨ Jisɨs siya sɨmiir yowarkɨi boɨnki, kara kɨmiirɨn yaimwo aiirar boɨnki. Tɨ nu wɨnɨn kara Yaowae Adɨn nɨnomor kou hɨrankɨ nɨtɨn mɨ kara wɨ ipiiya Inkam Komii nu kɨgrɨraowiyɨn siira wɨ saiir nɨdwokaii. Mɨ wɨ paenana nɨuyaei mɨ tɨ nu wɨnɨn kɨma kam ɨuur nwɨso kariir mhoɨiya nɨtɨm kɨma wɨ ipiiyɨm sɨmiir nɨdwokaii, kariir hɨriinan. Mɨ Isrel sɨmiir iikam isid ɨuur whɨso wɨ sɨmiir siyɨu ɨmiirar hɨdi. ");
INSERT INTO iws_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Mɨ iikam whɨekakɨm sɨma sɨmiir omaka mɨ sɨmiir yɨnisɨsɨm mɨ sɨmiir yokman mɨ sɨmiir yopii adɨm mɨ sɨmiir nu digworaekwo whɨekak ɨkɨm, sɨmiir bɨdi haiburgigɨm. Dimusi rani, sɨma kariir mhoɨiya nɨtam bɨdi yaɨngwowɨm. Mɨ mhoɨiya kara sɨmiirɨn wɨ yaeya digworaekwo whɨekakar swokɨ ɨnkɨn hauugi mɨ sɨma kwoɨnbudɨn omwai waiyayokiyokɨiyɨn wɨ siir haii. ");
INSERT INTO iws_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mɨ iikamɨm inɨg komiigakɨm tariinan nwowɨm yɨm wɨ mhoɨiya hɨsprɨprɨkɨini mɨ iikamɨm tariinan sɨma inɨg komii karamaeyɨm mhoɨiya sɨma wɨ inɨg komiigak nwowi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Adi komi siya iikam whɨekakɨm sɨmiir kɨgɨrkakana saeya ɨni numɨr waina saiir adɨn ɨni siir hɨriinan ywowɨn. Mɨ nugak ɨɨmumaɨn siya ɨna yamyakwokɨn kam nhɨrɨm sɨmiir nɨkɨunakiyɨm siir numɨr waina saiir mɨriiyam. ");
INSERT INTO iws_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mɨ siya kam nhɨrɨm sɨmiir haiyɨm sɨma ɨni wadɨeya ywokiyɨm ta wain numɨra saiir mɨriiyam. Sɨma saiir mɨriiyɨm umɨrɨm pɨ ɨi kwokwɨrani umɨrɨm sɨmiirara mɨrii haii. Mɨ siya sɨmiir asi nɨkropkikɨn siir numɨr waina saiiramɨn. ");
INSERT INTO iws_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Mɨ ɨiya 9 klok nwowa siya saiir yapnɨnopkainam siir numɨr waina hɨriirɨn mɨ siya yap kɨgam kam nhɨrɨm maeyauwa nae haigɨniya hɨrar sɨbokwowi. ");
INSERT INTO iws_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Siya sɨmiir boɨnki, kɨma ɨriipa hɨriinan kariir numɨr waina saiir tinɨ mɨriiyɨu mɨ kara umɨrɨm pɨ kɨmiirar hauu dɨgi. Mɨ ta mɨi aiirsiyɨn umɨrɨm wɨ kwokwɨrani umɨr maɨra hauuwi. ");
INSERT INTO iws_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Mɨ sɨma asi namkɨm. Mɨ ɨi bɨe mwo kou nokwoniyɨn 12 klok mɨ 3 klok bɨe nad nwowɨn siya ha swokɨ amɨn mɨ siya kɨgam kam nhɨrɨm sɨma hindara sɨbokwowi mɨ siya bɨiya siya tɨra mɨ saiir hɨriinana swokɨnɨ tɨrɨuwɨn. ");
INSERT INTO iws_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mɨ 5 klok naɨowaka siya ha swokɨ amtɨbɨn mɨ siyar kɨgamtɨb kam nhɨrɨm hindara sɨb okworɨbi. Mɨ siya sɨmiir srɨigi mɨ tɨ bɨewi komiiyɨn kɨma ta maeyau aiirɨn whɨsarii dimusi nokwo kaoɨkɨigirɨbgɨm, ha? ");
INSERT INTO iws_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Mɨ sɨma siir yai aka yowarkɨi boɨnɨn, inkam nwɨrɨn mɨi krɨmiir bɨ swokɨ hauu mɨriigɨn. Mɨ siya sɨmiir boɨnki, kɨma kariir wain numɨra saiir tinɨ mɨriiyɨu. ");
INSERT INTO iws_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ɨiya bɨdi kakauugirɨba mɨ adɨn numɨr wainanɨn siya inkamɨn siir mɨi ɨmiir kɨgrɨraowiyɨn siirɨn hɨnɨɨna boɨnki, kɨra ɨkɨ mɨiyan kamɨm sɨmiir dɨkɨunaki mɨ sɨmiirɨn umɨr hauugi. Inkamɨn mhoɨi nɨtɨn mɨ umɨrɨn siirar hauu bwakainam mɨ hɨriinanar hauuyokiyokɨiyam mɨ inkamɨn bɨi nɨtɨn nugak ɨɨmuma siirar tina hauu dɨgɨu. ");
INSERT INTO iws_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Mɨ kamɨm ɨiya 5 klok nwowa ha namɨriiniyɨn bɨi sɨma yɨt mɨ sɨma umɨrɨm ɨikwokwɨrani umɨr maɨrɨn siirar hainamɨm. ");
INSERT INTO iws_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mɨ sɨmiir mhoɨiya kamɨm bɨigɨ bɨiya namɨriiniyɨm sɨma ɨna yɨtɨm mɨ ɨna yaɨngwowɨm, krɨma pɨ umɨr komiiya hai. Mɨ sɨma umɨr komii bɨ haiigɨm mɨ sɨma hɨriihɨriinankɨnar hai. ");
INSERT INTO iws_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Mɨ sɨma hai dɨgiyɨm mɨ sɨma ɨo ɨna ywowɨm numɨr wainan ad ɨiirɨn. ");
INSERT INTO iws_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Mɨ sɨma ɨna boɨnɨm, tɨ kamɨm naɨowaka namɨriiniyɨm mɨ sɨma tɨ umɨrɨn krɨma haiyɨn siir hɨriinan dimusi haigɨm, sɨma ɨi prɨei bɨ ninɨ mɨriinikɨm. Mɨ krɨra nugakiya mɨriibumbuyakwokɨm mɨ ɨni bɨe ɨeyar yɨkiyamkirɨbɨn mɨ bɨeyɨn krɨmiirar whwonanaewakɨn. ");
INSERT INTO iws_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Mɨ numɨr wainan adɨn siya yaiya kwɨra yowarkɨi boɨn sɨmiir nwɨr ɨnakan. Siya hɨnɨɨna boɨnkɨn, nomiiyau kara kɨriir bɨ tɨrbugɨn. Mɨ krɨma tari tɨ umɨr ɨuurɨm sɨmiirɨmɨn ɨrɨpa kwoɨn whɨruwa bɨ nwoko, aniya? ");
INSERT INTO iws_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kɨra kɨriir umɨr ɨiir bɨdi haiyɨn mɨ ha dam. Tɨ umɨrɨn kara kɨriir hauuwɨn kariirar kwoɨnkɨn tɨ inkamɨn mhoɨiya nɨtɨn siirɨn hɨriinan umɨrɨn kara siirar mɨ hauuwi. ");
INSERT INTO iws_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kariirar dimɨnkɨn. Kara kariir umɨr ɨmiir mɨ dirɨraerari yɨo kariirar kwoɨnkɨn. Kɨra kanaka dimusi nɨnkinɨmpɨsuwi, ha? Kara siyɨu mɨiyɨk ɨiirar tɨrkɨn. ");
INSERT INTO iws_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yɨo hɨnɨɨngɨn mɨ iikamɨm mhoɨigɨ mhoɨiyanɨm yɨm wɨ bɨigɨ bɨiyɨn sɨma nwowi. Mɨ iikamɨm bɨi nwowɨm yɨm wɨ mhoɨigɨ mhoɨiya nwoki. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisɨs siya om komii Jerusalem hɨriir niinaiinamɨn mɨ kam ɨuur nwɨso siir kɨgna mɨriiyɨm sɨma warar yɨnkɨn am. Mɨ siyɨu hɨrar napamɨm mɨ Jisɨs siya sɨmiirɨn siyɨu mɨg hɨriir yɨkɨunam. Mɨ siya sɨmiirɨn ɨna boɨnɨn. ");
INSERT INTO iws_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Wakae, panaowɨn krɨma pɨ om komii Jerusalem hɨriir nami. Kara Yaowae Adɨn nɨnomor kouanɨn kam nhɨrɨm sɨma kariirɨn wɨ prismi yaowae adɨm mɨ kamɨm siyɨu komii nɨnoknɨnkɨniyɨm sɨmiir kɨnmauu ɨti. Mɨ sɨma bɨdi yɨmboɨn tɨbmiiyɨm kariir nɨsomaowɨm. ");
INSERT INTO iws_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Mɨ sɨma kariirɨn wɨ Juda iikam tani wɨ sɨmiir ɨɨn nonkwo hauugi mɨ sɨma kariirɨn wa nɨgbumbu boɨni mɨ ɨdgɨu mɨni nɨpɨmpari mɨ paeyɨn hɨiniya nɨrɨonɨnkɨnɨn wɨ saɨka nɨnkɨn ɨrɨnugi. Mɨ ɨi kwoɨmaka kara wa swokɨ ɨnsiin ɨdwowi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Mɨ taka ɨiya Sebedi siir wiga saeya yɨnisɨm nwɨso Jisɨs siirɨm yɨkɨunam. Mɨ saeya ogmwo ɨna inɨ akai hɨuwɨuwa siir kingiin hɨr mɨ ɨna srɨiya siirɨm, Jisɨs siya saiirɨn dimɨn mɨiyɨk whɨr tɨrɨm. ");
INSERT INTO iws_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Mɨ Jisɨs siya saiir boɨnki, kɨra pɨ hɨnɨɨn dimɨn siirɨm naɨngwowi. Mɨ saeya siir boɨnki, kɨra kariir boɨnki tɨ kariir yɨnisɨm nwɨso sowa ɨni mɨ owo, sowa kɨriir ɨɨn ɨnig yaɨoyae owiir mɨ ɨdwowi mɨ nwɨrɨn ɨniga mɨ nwɨrɨn yaɨoyaeya, ɨiya kɨra inkam komii nwowi, aniya? ");
INSERT INTO iws_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Saeya hɨriinan yai boɨna mɨ Jisɨs siya ɨna yowarkɨi boɨnɨn, tɨ dimɨnɨn kɨma srɨiyɨn kɨma siir bɨ sɨbgu ɨnoknɨnkɨnkɨm. Ta hɨk hɨriinana kara haiiya kowa saiir haiyɨm wɨ dɨgar nwowi, aniya? Mɨ sowa siirɨn hɨnɨɨna yowarkɨi boɨnki, ɨhɨ. Krɨra wɨ dɨgar nwowi. ");
INSERT INTO iws_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Mɨ Jisɨs siya sowiir boɨnki, kaimwoka ta hɨka kara haiiya kowa saiirɨn hɨriinana mɨ haii. Mɨ yɨpɨkɨn kariir ɨɨna ɨnig yaɨoyaeyo sowiir nɨdwokaii, yɨo kariir dimɨn tani. Nɨɨngaka. Tɨ kamɨm sɨmiir ipiiyɨm sɨma nɨdwokaiiyɨm, yɨm kariir Adɨn siyar bɨdi dirɨraerarkwokɨnɨn. ");
INSERT INTO iws_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Mɨ kam ɨuurɨm siir kɨgna mɨriiyɨm sɨma hɨriinan yai wakaeyɨm tɨ iwɨnyaowo sowiir apua saeya tɨrɨn mɨ sɨma ɨo sowiir ywoki. ");
INSERT INTO iws_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jisɨs siya sɨmiirɨn ɨna yɨkɨunan mɨ siya sɨmiir boɨn, kɨma ɨna nɨnoknɨnkɨnɨm inkam komii nu kɨgrɨraowiyɨn siya ɨkɨ Juda iikam tani sɨmiira nikwowaisiigɨm. Mɨ sɨma tɨ inkam komiiyɨm sɨmiirɨn yai kɨrɨe aiir yɨkwao boɨn, sɨmiirɨn wɨ sɨma nikɨ sɨbgu kɨgrɨraowɨm. Mɨ sɨma wɨ sɨmiir yai ɨmiirar wakaeyoknam. Mɨ inkam komiiyɨm sɨma ɨkɨ iikamɨm sɨmiirar nɨkwao boɨnɨnaeikɨm, sɨma sɨmiir yai ɨmiirar wakaeyoknaɨm. ");
INSERT INTO iws_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tɨ hɨriinan siyɨuɨn kɨmiir tɨr kɨpi nikɨ o. Nɨɨngaka. Inkamɨn siya kɨmiir inkam komii nwowam naɨngwowi mɨ siya kɨmiir mɨiyan inkam nɨɨnganan dwo, siyɨu mɨiyɨk kɨmiir tɨrhaigɨnɨuwɨm. ");
INSERT INTO iws_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Mɨ inkamɨn siya kɨmiir bɨi nwowam naɨngwowi mɨ siya kɨmiir mɨi prɨimɨriiyan inkamnan dwo. ");
INSERT INTO iws_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kara Yaowae Adɨn nɨnomor kouanɨn kara mɨnam bɨ nɨtkɨn iikam whɨekakɨm kɨma kariir whɨndirɨraerar haigɨnɨuwɨm. Nɨɨngaka. Kara kɨmiir whɨndirɨraerar haigɨnɨuwam nɨtkɨn. Kara iikam whɨekakɨm dimɨn biyɨekakɨm sɨmiirɨm naowɨm mɨ sɨmiir dimɨn biyɨe haiyoprimdiyɨumiigiyam. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Mɨ sɨma om komii Jeriko siir haiburgigɨm mɨ ɨna yamɨm. Mɨ iikam whɨekakɨm sɨma Jisɨs siir mhoɨiyar yamɨm. ");
INSERT INTO iws_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Mɨ inkam nhwokwɨsae nwɨso sowa siyɨu mɨg kingiin hɨrar yɨdwokwokɨn. Mɨ sowar wakaewɨn Jisɨs siya tɨriir napni mɨ ɨna kauwoknanaekiyo, Bɨiyan Inkam Komii, kɨra Devidni isidɨn siir yɨnisɨmkɨn, inkamɨn Adi Komii siya nɨkropkiyɨn, krɨriirsi daɨngwobumbu. ");
INSERT INTO iws_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mɨ iikamɨm sowiir boɨnainanaeki, kowa yai tanki. Mɨ sowa ɨna swokɨ kauwoknanaekiyo, Bɨiyan Inkam Komii, kɨra Devid siir yɨnisɨmkɨn, kɨra krɨriirsi daɨngwobumbu! ");
INSERT INTO iws_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Mɨ Jisɨs siya ha namɨkwowɨuɨn mɨ sowiir yɨkɨuna mɨ ɨna boɨnɨn, kowa panɨɨna naɨngwowi kara kowiirɨn pɨ hɨnɨɨn dimɨnɨn siir tɨrki, ha? ");
INSERT INTO iws_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Mɨ sowa siir boɨnki, Bɨiyan Inkam Komii, krɨra ha naɨngwowi kɨra krɨriir nhwo owiir haiswonɨskiigi. ");
INSERT INTO iws_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Mɨ Jisɨs siya sowiirsi naɨngwoyɨmyokɨn mɨ siir ɨɨna ɨna yonkwokiya sowiir nhwo nhɨs owiir mɨ sowiir nhwowo ha kaokiyo mɨ ɨni Jisɨs siir mhoɨiyar yapnamo. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Mɨ sɨma om komii Jerusalem kingiin nwowamɨn mɨ sɨma omisɨm Betfasi hɨriir yɨmbiyam mhɨu whɨrɨn Oliv siir kingiin. Mɨ Jisɨs siya inkam nwɨswo siir mɨi kɨgna mɨriiyo sowiir yɨkropki bɨi sowar namkwokɨnɨm. ");
INSERT INTO iws_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Mɨ siya sowiir boɨnki, kowa ɨkɨ omɨn krɨma kɨgiyɨn siir dam mɨ kowa kingiin tɨrar kwakɨg. Mɨ kowa wɨ kɨmɨmɨnki rani, donki ɨrɨn uridni sɨma nɨmburuwɨn paeyaka pɨ siir kɨgi mɨ saiir yɨnisɨm ɨi ɨiirɨn wara mɨ kowa pɨ sowiir whro hainani mɨ kariirɨm kiyainani. ");
INSERT INTO iws_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mɨ inkam nwɨrɨn siya yai kwɨr kowiir boɨnki mɨ kowa siirɨn hɨnɨɨna boɨnki, krɨmiir Bɨiyan Inkam Komiiyɨn siya sowiirɨn mɨigakɨn mɨ mhoɨiya siir mɨiya dɨg nwoki mɨ siya wɨ kɨriirar swokɨ hauugi mɨ siya wa nami. ");
INSERT INTO iws_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tɨ dimɨn hɨriinanɨm nɨmbɨibɨiyamɨm mɨ yaiyɨm bɨiya profet sɨma boɨnɨm ɨni sɨmiirar boɨnourwokaiyɨm mɨ sɨma hɨnɨɨna boɨnkɨm, ");
INSERT INTO iws_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","kɨma iikamɨm om Saion hɨranɨm sɨmiirɨn hɨnɨɨna boɨn, kɨgi! Kɨmiir Inkam Komiiyɨn nu kɨgrɨraowiyɨn ɨsirɨn kɨmiiram nɨti. Siya inkam mɨuungɨn mɨ siya donki haomɨm siir nɨdwo namkɨn mɨ donki ɨiyɨn yopii aeya naokainan siir! Mɨ ɨiya Jisɨs siya om Jerusalem hɨriir nɨmbiyamɨn, tɨ dimɨnɨm sɨma ɨna yɨmbiyamɨm. ");
INSERT INTO iws_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Mɨ inkam nwɨswo Jisɨs siir kɨgna mɨriiywo mɨ yaiyɨm siya boɨnkiyɨm sɨmiir hɨriinana inɨ tɨrɨu. ");
INSERT INTO iws_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Mɨ sowa donki iwɨnbugao sowiir hakainamwo mɨ sowiir yɨuɨsɨm siir ɨdwo yɨtɨmwanɨu mɨ Jisɨs siya yɨuɨs ɨdwowa yɨdwonam donki yɨnɨn siir. ");
INSERT INTO iws_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mɨ iikam whɨekakɨm sɨmiir yɨuɨsɨm ɨni siyɨu ɨiirar haknamɨn siir bɨiyar mɨ nhɨrɨm paekwowɨm sikwonanɨm sɨmiirar krɨphaknam siyɨu ɨiirar. ");
INSERT INTO iws_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mɨ iikam nhɨrɨm bɨiya napnam ɨkɨm mɨ nhɨrɨm mhoɨiya saɨka nɨnkɨn apnam ɨkɨm sɨma ɨna kauwok boɨnamɨm, Devid siir isidan yɨnisɨmɨn Adi Komii siya nɨkropkiyɨn siya wadɨekɨ wadɨekɨn, siir inɨg ɨiir dokboɨnmamaɨrgi! Adi Komii siya tɨ Bɨiyan Inkam Komiiyɨn nɨtɨn siir whɨnkɨnsiis haigɨnɨugɨn, siya inkam mɨiyɨkɨn krɨma Adi Komii siir inɨg ɨiir hainan prapraskikɨn. ");
INSERT INTO iws_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jisɨs siya om komii Jerusalem hɨriir napnɨnopkainamɨn mɨ iikam whɨekakɨm om komii hɨr nwowɨnɨm sɨma hɨriinan dimɨn ɨiir kɨgwɨnɨm ɨni hindara yanaawɨnɨm mɨ ɨna boɨnɨm, tɨ inkamɨn siya yɨpɨkɨn? ");
INSERT INTO iws_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tɨ iikamɨm napnaniyɨm sɨma boɨn, Jisɨs siyaɨrgɨn profet inkamɨn om Nasaret nu Galili hɨranɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisɨs siya Adi Komii siir omaka komiiya hɨuyokiyokaiya siir inɨg nɨdwokai hainaniya saiir hɨriir napnɨnopkainamɨn mɨ kam nhɨrɨm umɨr hɨr nɨnwowana haiyɨm mɨ nhɨrɨm pɨ saɨngɨm, siya sɨmiir nhɨnɨtnowidnɨnkiigi. Mɨ siya umɨr hɨiyɨm sɨmiir inankrɨmkrɨnkɨigi mhoɨiya sɨma Adi Komii siir nɨnkɨnɨmiyaei. Mɨ ipii mɨnɨm kamɨm umɨr mɨi mɨriiyɨm sɨma nɨdwokaiyɨm sɨmiir warar. ");
INSERT INTO iws_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Mɨ siya sɨmiir boɨnki, Adi Komii krɨmiir Wanɨn siir yaiya Yokwo Komii saeya hɨnɨɨna boɨnka, kariir omaka iikamɨm hɨnda tɨnda nwowɨm sɨma saiirɨn hɨnɨɨna dapi, nhwo kwɨs boɨni omakaka! Mɨ kara kɨmiir boɨnki, kɨma kariir omaka ɨni hɨi tauae inkamɨn siir hɨriinan omaka biyɨenan ywonama. ");
INSERT INTO iws_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mɨ Jisɨs siya Adi Komii siir omaka saiir hɨrar nikɨ owɨn mɨ kam nhɨrɨm nhwo kwɨsaeyɨm mɨ ɨga biyɨe ɨkɨm sɨma ɨna yɨmbiniyɨm siirɨm mɨ siya ɨni sɨmiirar haiswonɨmnɨskɨiyɨn. ");
INSERT INTO iws_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Prismi bɨiyan kamɨm mɨ kamɨm siyɨu komii nɨnoknɨnkɨni ɨkɨm sɨma Jisɨs siya haiswonɨmnɨskɨiya saiir kɨgɨm mɨ sɨma wakae yɨnisɨmɨm hɨnɨɨna nɨnɨkɨu anɨkɨuwi krɨma Devid siir isidɨn siir yɨnisɨmɨn siir inɨg ɨiir hainan prapraski. Mɨ sɨma ɨo hɨriinansi nwokɨm. ");
INSERT INTO iws_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Mɨ sɨma ɨo ha nwowɨm mɨ sɨma mɨnam naɨngwokɨm tɨ yɨnisɨsɨmɨm sɨma kauwoknanaeyɨm pɨ tankiyɨm mɨ sɨma hɨnɨɨna boɨn, kɨra ta yaiya yɨnisɨsɨmɨm sɨma boɨna ɨna wakaeyɨm, ha? Mɨ Jisɨs siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨnki, ɨhɨ, kara tɨsa wakaeyɨn. Kɨma Yokwo Komiiya saiir yai ɨmiir bɨ mwaɨngɨm. Saeya hɨnɨɨna boɨnka, Adi Komiiyɨn yɨnisɨm budɨrɨg ɨkɨm mɨ yɨnpraigak ɨkɨm sɨmiir bɨdi yɨisiisimauuɨn mɨ sɨma Adi Komii siir inɨg ɨiirɨn hɨriinan asi sɨbgu hainan prapraskɨm, aniya? ");
INSERT INTO iws_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Mɨ siya sɨmiirɨn ha boɨn dɨgiyɨn mɨ siya sɨmiir haiburgik mɨ om Betani hɨriir yam mɨ hɨrar whwonkaowi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mɨ nugak ɨmumarɨn Jisɨs siya ɨna swokɨ haiyɨug apam yakwokɨn om Komii Jerusalema hɨriir mɨ siya mhɨiya ɨna yapaowamɨn. ");
INSERT INTO iws_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Mɨ siya pae fig whɨrɨn siyɨu mɨg hɨr nokwoɨn siir kɨgam mɨ siya siirɨm ha namɨn mɨ siya hɨnɨɨna bɨ kɨgamkɨn nae bɨdi budɨn. Nɨɨngaka. Paekwo nɨɨnga nwowi mɨ siya tɨ pae figɨn siirɨn hɨnɨɨna boɨn, kɨra wɨ nae swokɨ budmɨmɨn tani, nɨɨngakɨɨnga. Mɨ tɨ pae figɨn bɨ kɨmɨmɨnkikɨn ɨna wainamɨn. ");
INSERT INTO iws_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kamɨm siir kɨgna mɨriiyɨm tɨ hɨriinan dimɨn ɨiir kɨgɨm mɨ ɨna yanaakiyɨm. Sɨma boɨn, tɨ pae figɨn siya dimusi wai sasaunamkɨn, ha? ");
INSERT INTO iws_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Mɨ Jisɨs siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨn, kara kɨmiirɨn yaimwo aiirar boɨni, kɨma naɨngwo tɨbmii kɨɨni mɨ kɨma wɨ dɨga nwowi tɨ pae figɨn kara mɨnkiyɨn siir hɨriinan. Mɨ dimɨn whɨrɨn kɨra wɨ dɨga mɨ owi. Mɨ kɨra tɨ mhɨu ɨiir boɨnki, kɨra whɨi solwara hɨriir diswɨtnatmainam mɨ siya wɨ hɨriinana mɨ tɨri. ");
INSERT INTO iws_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mɨ kɨma Adi Komii siirɨm naɨngwo tɨbmii mɨ ha srɨii digworaekwo whɨekakɨm kɨma haiyam srɨi boɨni, siya kɨmiirɨn wa hauuwi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisɨs siya Adi Komii siir omaka saiir swokɨ haiyɨug apnɨnopkainam mɨ iikamɨm sɨmiir yowomwarkaiyɨu siir yai ɨmiir. Mɨ siya ha nikɨ boɨnɨn, prismi bɨiyan kamɨm sɨma mɨ Isrel sɨmiir bɨiyan inkam komii komiiyɨm sɨma siir hɨriir yɨmbiyam mɨ sɨma siirɨm srɨigi mɨ yɨpɨkɨn inɨg komiigak kɨriir nwowaigɨnɨuɨn mɨ kɨriir nɨmbinɨn yɨpɨkɨn tɨ digworaekwo sɨmiirɨn kɨra pɨkɨ hɨnɨɨn inɨgɨn siir dirɨraerari, ha? ");
INSERT INTO iws_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Mɨ Jisɨs siya sɨmiir yai aiirɨn ɨna yowarkɨi boɨnɨn, kara ɨriipa hɨriinan kɨmiirɨn pɨ dimɨn whɨrɨn siir srɨiyɨm mɨ tɨri. Mɨ kɨma saiir sɨbgu owarkɨi boɨni mɨ kara ɨriipa hɨriinan wɨ kɨmiirar boɨnmauuwi inkamɨn inɨg komiigak kariir nwowaigɨnɨuɨn ta mɨiya saiir mɨriiyam. ");
INSERT INTO iws_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yɨpɨkɨn Jon siir nwowaigɨnɨuɨn inɨg komiigak iikamɨm op sɨmiir baptais haigɨnɨuwam Adi Komii siya, iyae inkamkɨn, aniya? Mɨ sɨma, sɨmasɨma hɨnɨɨna yɨmboɨn amboɨna krɨma siirɨn pɨ panɨɨn yaiya saiir boɨni, ha? Mɨ krɨma siirɨn hɨnɨɨna boɨni, Adi Komii siya hauugɨn mɨ siya krɨmiirɨn pɨ hɨnɨɨna boɨni, kɨma Jon siir yai wakaeyokna dirɨraerar karamae dimusi nwokɨm. ");
INSERT INTO iws_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mɨ krɨma ha boɨni tɨ dimɨnɨn inkamkɨ hauugɨn mɨ krɨma hɨriinan yai boɨni mɨ wɨ iikamɨm sɨmiirsi nɨdidi. Mɨ sɨma wɨ krɨmiir tɨowi. Dimusi rani, sɨma hɨnɨɨna naɨngwo tɨbmii Jon siya profet inkam komiigɨn. ");
INSERT INTO iws_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Mɨ sɨma Jisɨs siir yai aka hɨnɨɨna yowarkɨi boɨn, krɨma nɨnoknɨnkɨn tani yɨpɨkɨn inɨg komii Jon siir hauuwɨn tɨ dimɨnɨm sɨmiir tɨram. Jisɨs siya sɨmiir boɨnki. Dimusi rani, kɨma kariirɨn bɨ sɨbgu boɨnkikɨm Jon siirɨn. Mɨ kara ɨriipa hɨriinan wɨ kɨmiir mɨ boɨnmauu rani, yɨpɨkɨn inɨg komii kariir hauuwɨn tɨ dimɨn taemɨnɨm sɨmiir tɨram. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kɨma panɨɨna naɨngwowi, ha? Bɨiya inkam nwɨrɨn siir yɨnisɨmo nwɨsko mɨ mhoɨiya ɨiya sowa inɨkamae nwokiyo mɨ adɨn siya siir yɨnisɨm yaowaeyɨn siirɨm yam mɨ siir inɨ boɨnɨu, yɨnisɨm, panaoɨn kɨra kariir numɨr waina saiir kɨgrɨraowam dam. ");
INSERT INTO iws_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mɨ yɨnisɨmɨn adɨn siir yai aka yowarkɨi boɨn. Nɨɨngaka. Kara pɨ boriisopi. Mhoɨiya siir kwoɨnɨn ɨna swokɨ kisɨna haigiyɨn mɨ ɨni adɨn siir wain numɨra saiir swokɨnɨ mɨriiyɨuɨn. ");
INSERT INTO iws_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Mɨ adɨn ɨna swokɨ apnamɨn siir yɨnisɨm nwɨrɨn siirɨm mɨ siya ta hɨriinan yai aiirar swokɨ boɨnɨu siirɨn mɨ kɨra kariir wain numɨra saiir tɨram dam. Mɨ yɨnisɨmɨn hɨnɨɨna yowarkɨi boɨnki, kara pɨ kapi nami mɨ siya numɨra hɨriir bɨ swokɨ amɨmɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Mɨ siya sɨmiirɨn hɨnɨɨna srɨigi, tɨkɨ yɨnisɨm nwɨso yɨpɨkɨn adɨn siir kwoɨn ɨiir napɨn, ha? Mɨ sɨma ɨna boɨnɨm Bɨiyan ɨiya mɨ Jisɨs siya sɨmiir boɨnki, kara kɨmiirɨn yaimwo aiirar boɨnki mɨ iikam biyɨeyɨm omom omomi umɨr takis haiyanɨm mɨ wigɨm hɨi nanaei ɨkɨm sɨmiir mhɨi kwoɨnɨm bɨdi kisɨna haigiyɨm mɨ sɨma Adi Komii siir yai aiiram bɨdi yaɨngwo tɨbmiiyɨm mɨ kɨmiir bɨiyɨn wɨ sɨmar nami iikamɨm Adi Komii siya kɨgrɨraowiyɨm kɨmiiramɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Dimusi rani, Jon siya kɨmiir waraur nɨmbinikɨn siyɨu mɨiyɨk mɨiyɨkɨm sɨmiir nɨisiisimauugɨm kɨmiirɨn mɨ kɨma siir yai aiir bɨ naɨngwo tɨbmiigɨm. Mɨ kamɨm omom omomi umɨr haii ɨkɨm mɨ wigɨm hɨi nanaei ɨkɨm sɨma siir yai ɨmiir bɨdi yaɨngwo tɨbmiiyɨm. Mɨ kɨma tɨ hɨriinan dimɨnɨm sɨmiir bɨdi kɨgɨm mɨ kɨmiir kwoɨnɨm bɨri kisɨna haiigikɨm mɨ siir siyɨu ɨiir napam bɨ naɨngwo tɨbmiigɨm. Nɨɨngaka. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisɨs siya sɨmiirar nikɨ boɨnɨn, kɨma wakae, boɨniyɨo yai kwɨra hɨnɨɨnga. Inkam komii nwɨrɨn siya nu komiigakɨn mɨ wain numɨr yɨnkɨn mɨ ɨna hɨuyokiyokaiyɨn mɨ numɨr hɨrɨn ɨe whɨra yop mɨ nantwo komiiya ɨenau hɨr haigi mɨ sɨma wain nidɨm ɨna whɨnɨtkaigaiyɨm mɨ sɨmiirɨn ɨna yokwobrombropɨm sɨmiir hii ɨmiirɨm mɨ saiir mhoɨiya numɨran adɨn siya omaka pada ɨra mɨrii ta wain numɨra saiir kɨgrɨraowam. Mɨ siya ta numɨra inkam nhɨrɨmi hauugi sɨma kɨgrɨraowam mɨ umɨr mɨi saiir warar mɨ mɨriiyɨm. Mɨ numɨran adɨn ɨna yamɨn aru maeyau kwɨra. ");
INSERT INTO iws_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Mhoɨiya ɨiya wain nidɨm sɨmiir haiyana ɨni kingiin nwowa mɨ numɨran adɨn siya whɨsarii mɨi prɨi mɨriiyan kam nhɨrɨm sɨmiir yɨkrop amki wain nidɨm sɨmiir nɨnguguhainakiyam. ");
INSERT INTO iws_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Mɨ kamɨm ta numɨr aiir kɨgrɨraowiyɨm mɨ sɨma siir mɨiyan kam ɨmiirɨn siyɨu mɨiyɨk bɨ tɨrkɨm. Mɨ sɨma nwɨrɨn hindara tɨoki mɨ nwɨrɨn hindara yɨsomaoki mɨ nwɨrɨn hindara kaigromkrorki siiyani. ");
INSERT INTO iws_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mɨ numɨran adɨn kam nhɨrɨm mɨiyanɨm sɨmiir yɨkropki, siya hoɨmgakrɨga yɨkroki, bɨiyana saiir hɨriinan tani. Mɨ kamɨm numɨr aiir kɨgrɨraowiyɨm hɨriinan siyɨu ɨiirar swokɨ tɨrwɨn sɨmiirɨn. ");
INSERT INTO iws_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Mɨ mhoɨigɨ mhoɨiyan siya siir yɨnisɨmkɨ yɨnisɨm yɨnkamiyɨnɨn siirgɨsiirar yɨkropki sɨmiiramɨn. Adɨn siya hɨnɨɨna yaɨngwo, sɨma wɨ kariir yɨnisɨmɨn wɨ siir yaiyar wakae yoknaei. ");
INSERT INTO iws_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mɨ kamɨm ta numɨr aiir kɨgrɨraowiyɨm sɨma tɨ yɨnisɨm ɨiir kɨgwɨnɨm mɨ sɨma sɨma hɨnɨɨna boɨnaiwɨn, tɨkɨ yɨnisɨm hɨnɨɨnɨn siya wɨ siir adni digwraekwowɨm wɨ siya haii. Humbae! Nɨm siir dɨsom aoki mɨ ta siir adni numɨra wɨ krɨma haii. ");
INSERT INTO iws_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Mɨ sɨma siirɨn ha kiyainaniyamɨm numɨr yaba hɨriir mɨ sɨma siirɨn ɨna yɨsomaowɨn. ");
INSERT INTO iws_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Mɨ Jisɨs siya sɨmiir boɨnki, kɨma panɨɨna mɨ aɨngwokiyɨm? Mhoɨiya ɨiya numɨr wainaɨn adɨn siya nɨti wɨ panɨɨn siyɨuɨn siir natɨrni ta numɨr aiir kɨgrɨraowan kamɨm sɨmiirɨn? ");
INSERT INTO iws_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Mɨ sɨma siir boɨnki mɨ siya tɨ inkam biyɨeyɨm siir numɨr aiir kɨgrɨraowɨm wɨ sɨmiir nɨsomsom aokii. Mɨ siya numɨr waina wɨ iikam isid mɨiyɨk nhɨrmi hauugi sɨma kɨgrɨraowɨm mɨ nae haiyan ɨiya mɨ sɨma nae haɨmii, siirɨn wa hauu aei. ");
INSERT INTO iws_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Mɨ Jisɨs siya sɨmiir boɨnki, tari kɨma yai haɨmii kwɨra profet kamɨm bɨiya sɨma wɨna Yokwo Komii saiir nwowɨm sɨmiir bɨri sɨbgu mwaɨnɨnoknɨnkɨnkɨm, aniya? Saeya hɨnɨɨna boɨnka, tɨ yɨn mɨiyɨkɨn omaka mɨriiyɨn kamɨm sɨma boriisop waeyaowɨn tariinanɨn ɨni bɨiyan yɨn yamwowɨuɨn. Siya ɨni bopwonauan kougouwɨn siir hɨriinan yamwowɨuɨn. Bɨiyan Inkam Komiiyɨn siyar dirɨraerarkikɨn tɨ dimɨnɨn, siya ɨna yɨmbiyamɨn mɨ krɨma siir kɨgɨn ɨni wadɨeyar ywokiyɨn. ");
INSERT INTO iws_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Mɨ kara kɨmiirɨn pɨ hɨriinan asi boɨnki, tɨ dimɨn mɨiyɨk mɨiyɨkɨm Adi Komii siya kɨgrɨraowan iikamɨm sɨmaka nwowɨm wɨ kara swokɨ haii, Juda iikamɨm kɨmiir waraurankar. Mɨ kara wɨ ɨkɨ iikam nhɨrɨm om whɨranɨm siir mɨi sɨbgu mɨriiyɨm wɨ sɨmiir hauugi. ");
INSERT INTO iws_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Yɨpɨkɨn inkamkɨn kariiram naɨngwo tɨbmii karamae nwowɨn mɨ siya wɨ hindara nonkwobumbunɨnkɨn ɨuguski, hauwa nɨkɨi ɨswomswokiya mɨmɨrmɨmɨr yɨnɨn siir ɨdwo saiir hɨriinan. Mɨ inkamkɨn digɨumii kariir haimriyɨuwi mɨ siya wɨ hindara nɨkrɨmkrɨp ɨuguski yɨn siir hɨriinan nɨsɨɨmtl sɨɨni. ");
INSERT INTO iws_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Mɨ ɨiya prismi bɨiyan inkam komii ɨma mɨ Farisi sɨma ta hɨriinan boɨniyɨo yai aiir wakaekiyɨm Jisɨs siya boɨnɨm mɨ sɨma ɨna yɨnoknɨnkɨnkiyɨm ta yaiya sɨmiirar nɨkrɨiga. ");
INSERT INTO iws_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Mɨ sɨma siir nonkworɨnuwama naɨngwokɨm omaka hɨuyokiyokaiya saiir hɨriir hainamɨm. Mɨ sɨma iikamɨm sɨmiirsi nɨdidgɨm Jisɨs siir yai wakaeyɨm. Dimusi rani, sɨma ha naɨngwo tɨbmiikɨm Jisɨs siya profet inkam komiigɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisɨs siya yaeya boɨniyɨo yaiya ɨna swokɨ boɨnɨn sɨmiirɨn mɨ siya hɨnɨɨna boɨnkɨn, ");
INSERT INTO iws_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Adi Komii siir digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana, saeya ɨni inkam komii nu kɨgrɨraowiyɨn, nae komii siir yɨnisɨm yɨnkamiyɨnɨn wig nonkwonaɨn siirɨm dirɨraerariyɨn ɨni saiir hɨriinan ywowɨn. ");
INSERT INTO iws_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Bɨiya kam nhɨrɨm sɨmiir nɨmbina ta wigwas naeya saiir naeyam. Mɨ naeni ɨiya siya siir kam nhɨrɨm sɨmiir yɨkropki. Mɨ sɨma nɨtɨm pɨ boriisopi. ");
INSERT INTO iws_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Mɨ siya siir mɨiyan kam nhɨrɨm ɨna swokɨ ɨkropkiyɨm mɨ sɨmiir boɨnmauu, kɨma kamɨm kara nɨmbingigɨm sɨmiir dɨkɨunaki mɨ kɨma sɨmiirɨn hɨnɨɨna boɨn, wakae, kariir naeyɨm bɨdi dirɨraerar haigɨngigɨm. Mɨ bulmakau ɨi ɨkɨm mɨ wraisu hɨkae hɨkaeyɨm kara bɨdi yɨsomsom haigɨngigɨm. Mɨ digworaekwo whɨekakɨm bɨdi dirɨraerar haiigɨngigɨm. Kɨma ta wigwas naeya saiirɨm wɨt. ");
INSERT INTO iws_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Siya siir mɨiyan kamɨm tɨ yai ɨmiir boɨnmɨmauu dɨgɨn mɨ sɨma ha namɨm, sɨma, sɨmiir yai ɨmiir wakaeyɨm pɨ boriisop mɨ sɨma ɨna nhɨnoopkiyɨm. Nwɨrɨn siir numɨram yam mɨ nwɨrɨn ɨni umɨr mɨi mɨriiyam yamɨn. ");
INSERT INTO iws_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Mɨ nhɨrɨm inkam komii nu kɨgrɨraowiyɨn siir mɨiyan kam ɨmiir yapiyɨskai kɨgwɨn mɨ sɨma sɨmiir yonkwobumbunɨnkɨn haiigɨnɨugi mɨ sɨmiirɨn ɨna yɨsomsom aokaokiyɨm. ");
INSERT INTO iws_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mɨ tɨ hɨriinanɨn inkam komii nu kɨgrɨraowiyɨn siir kwoɨnɨn haugɨ hauga ha whiyɨekiyɨn mɨ siir kamɨm sau nɨnɨtiyɨm sɨmiir yɨkropki. Mɨ sɨma inkam biyɨeyɨm sɨmiir yɨsomao mɨ om ɨiir warar yɨnkɨn haɨngɨmugig. ");
INSERT INTO iws_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Mɨ sɨma hɨriinan tɨrɨm, inkam komiiyɨn siir mɨiyan kam ɨmiir boɨnmɨmauugi, wigwas naeya bɨdi dirɨraerar haigɨn dɨga, kamɨm kara nɨmbinɨm sɨma mɨiyɨkɨ waeyao panɨɨnsi yɨtsi. ");
INSERT INTO iws_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mɨ hɨriinankɨ nɨuwi kɨma ɨkɨ siyɨu whɨekakɨm sɨmiirar dap kɨg yokiyokɨiyam mɨ kam whɨekakɨm kɨma sɨmiir kɨgi mɨ kɨma sɨmiir wɨkɨunani ta wigwas nae aiirɨm. ");
INSERT INTO iws_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Siya hɨriinan yai boɨnkiyɨn mɨ mɨiyan kamɨm ɨna nhɨnoopkiyɨm. Mɨ siyɨu whɨekakɨm sɨmiir nwowɨm iikamɨm sɨmiir yapboɨnmamauu iikam biyɨe biyɨe ɨkɨm mɨ iikam mɨiyɨk mɨiyɨk ɨkɨm sɨmiir yɨkɨunani wigwas nae aiirɨm. Mɨ sɨma ha nɨtɨm ta omaka wigwas nae dirɨraerara ɨni iikamkɨna yɨnkɨnɨugiya. ");
INSERT INTO iws_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Iikamɨm sɨma ha nɨdwodwokai dɨgiyɨm mɨ inkam komii sɨmiir napnɨnopkai kɨgam namkɨn. Mɨ siyar kɨgi inkam nwɨrɨn yɨuɨs mɨiyɨk bɨ pɨuainanikɨn wigwas naeya saiir nɨdwokai aeyamɨn. ");
INSERT INTO iws_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Mɨ inkam komiiyɨn siir boɨnki, akam, kɨra yɨuɨs mɨiyɨk pɨuainani karamae dimusi nwokɨn ta wigwas nae aiiramɨn, ha? Mɨ siya ɨni yai mɨkrɨma ywowɨn. Mɨ ɨna yɨdidkiyɨn. ");
INSERT INTO iws_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Inkam komiiyɨn siya siir mɨiyan kamɨm sɨmiirɨn hɨnɨɨna boɨnki, kɨma siir ɨga ɨɨnɨm sɨmiir kogrɨmdɨɨnugi. Mɨ maeyauwa nɨiyɨm nɨiyɨm nwowa saiir hɨriir dɨtkaigi. Ta maeyau nɨiyɨm nɨiyɨm aiirɨn siya wɨ kauu ouu prasae kɨn tani. Mɨ siya wɨ hɨk komiigɨkomii aiir haii. Mɨ wɨ siir big ɨiirar mɨ aegiyɨmgiyɨkaeyami. ");
INSERT INTO iws_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jisɨs siya ta boɨniyɨo yai aiir boɨn dɨgiyɨn mɨ siya sɨmiir boɨnki, ɨhɨ, Adi Komii siya iikam whɨekakɨm sɨmiirar nɨkɨunaei. Mɨ sɨmiirɨn wɨ ɨrɨra nwɨnwɨra nɨkɨuna apnɨnopkainani. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mɨ Farisi kamɨm sɨma yaiya ɨna haɨngiriyɨu hɨd boɨnaiyɨm, Jisɨs siir kɨnankɨuwam. ");
INSERT INTO iws_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Mɨ sɨma sɨmiir kɨgna mɨriiyɨm kam nhɨrɨm mɨ inkam komii Herot siir kamɨm sɨmiir warar yɨnkɨn ɨkropki. Mɨ sɨma Jisɨs siir hɨriir yɨmbiyam mɨ ɨna inɨ srɨiyɨuɨm yai nhɨrɨm sɨmiiram. Inkam yaimɨn dimɨn nowomwarkaiyɨuwiyɨn, krɨma ɨna nɨnoknɨnkɨnɨn kɨra yaimwo boɨnan inkamkɨn. Mɨ kɨra yaimwowa saiirar sɨbgu owomwarkaiyɨu boɨnikɨn dimɨnɨm Adi Komii siir iikamɨm sɨmiirɨm. Kɨra inkam nwɨrni bɨ nwowikɨn kou mɨ nwɨrni bɨ nwowikɨn nua. Nɨɨngaka. Kɨra iikam whɨekakɨm sɨmiirɨn whɨruwar nwowaigɨnɨuwikɨn. ");
INSERT INTO iws_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kɨra krɨmiirɨn sɨbgu boɨnmauugi, kɨra panɨɨna naɨngwowi, ha? Moses siir siyɨu komiiyɨn siya boɨnɨn ɨni wadɨeya mɨ owɨn krɨma omom omomi takis umɨrɨm inkam komii Sisa Romanɨn siir hauuwɨn, aniya? Iyɨe? Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jisɨs siya sɨmiir kwoɨn biyɨe biyɨe ɨmiir bɨdi yɨnoknɨnkɨnɨn mɨ siya sɨmiir boɨnki, kɨma nɨksɨsaeyan inkamkɨm. Kɨma kariirɨm dimusi kɨnankɨunikɨm, ha? ");
INSERT INTO iws_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kɨma umɨrɨm omom omomiyɨm kɨma haiiyɨm mɨ mɨiya umɨra saiir nwowa inkam komii Sisa siir hauuwiya kariir wɨisiimauugi. Mɨ sɨma umɨra siirɨm asi hainakikɨm, siir nɨisiimauuɨm. ");
INSERT INTO iws_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Mɨ siya sɨmiir srɨigi, tɨ whwonkamɨn mɨ tɨ inɨg ɨkɨn umɨr aiir nwowɨn siya nhɨnirgɨn. ");
INSERT INTO iws_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Mɨ Jisɨs siya sɨmiir yowarkɨi boɨnki, inkam komii Sisa. Mɨ siya sɨmiir boɨnki, dimɨn Sisa nikɨn, yɨo kɨma Sisa siirar hauu. Mɨ dimɨnɨn Adi Komii krɨmiir Wanɨn siirgɨn yɨo kɨma siirar timɨ hauugi. ");
INSERT INTO iws_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Sɨma ta hɨriinan yai aiir wakaekiyɨm mɨ sɨma ɨna yanaakiyɨm. Mɨ sɨma siir ɨna haiburgigɨm mɨ ɨna yamɨm. Mɨ sɨma Jisɨs siir kɨnankɨuan yai karamaekɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ta ɨi aiirarɨn Sadyusi kam nhɨrɨm Jisɨs siir hɨriir yɨmbiyam. Tɨ kamɨm sɨma hɨnɨɨna boɨnikɨm, inkamɨn naonamiyɨn sɨma wɨ swokɨ ɨnsiin ɨdwo rani. Sadyusi kamɨm sɨma ha nɨmbiyamɨm mɨ sɨma Jisɨs siir inɨ srɨiyɨu, ");
INSERT INTO iws_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","inkamɨn nowomwarkaiyɨuwiyɨn, Moses siya hɨnɨɨna boɨnkɨn, inkam nwɨrɨn siya yɨnɨe niyɨo karam nwowi mɨ siya ha naonami mɨ siir wig igabaeya siir nomousɨm ɨeyar swokɨ ɨtkɨn ɨdwokai naowid. Mɨ yɨnɨekakɨn wɨ siya nwo haigɨnɨuwi siir yaowae ɨiirɨn. ");
INSERT INTO iws_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Mɨ kam ɨriiyar nwɨskɨnɨuwi mɨ sɨmiir yaowaeyɨn wig siya yonkwona mɨ siya ɨna yaonamɨn mɨ siya yɨnɨekak bɨ nwogigɨn. Mɨ siir wig igabaeya ɨni siir nomousɨm ɨeyar swokɨ ɨtkɨn ɨdwokainaowida. ");
INSERT INTO iws_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Mɨ siir nomousɨmɨn ɨriipa hɨriinanar mɨ tɨr, yɨnɨe karamaeyar mɨ aowɨn. Mɨ nwoɨmaka ɨriipa hɨriinanar mɨ tɨr mɨ ɨni hɨrii hɨriinanar tɨr yokiyokɨiyamɨn. Mɨ tɨ iwɨniyao ɨriiyar nwɨso ɨni yɨnɨe karamaeyar yaowɨm. ");
INSERT INTO iws_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Sɨma yaowɨn naokao dɨgiyɨm mɨ mhoɨigɨ mhoɨiya sɨmiir yao wig igabae aeyar yaonam. ");
INSERT INTO iws_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kɨra boɨnki, ɨiya iikamɨm naokaowɨm sɨma nɨnsiin ɨdwowi. Tɨ iwɨnyao ɨriiyar nwɨswo ta wiga saiir kamkɨ kamɨn wɨ nhɨnga nwowi? Kɨra ɨna nɨnoknɨnkɨnɨn, sɨma yaowɨn saiirara nonkwona swokɨm. ");
INSERT INTO iws_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Mɨ Jisɨs siya sɨmiir yai aka ɨna yowarkɨi boɨnɨn, kɨma Yokwo Komii saiir yai ɨmiir bɨ nɨnoknɨnkɨnkɨm, ha? Mɨ kɨma Adi Komii siir kɨrɨe aiir bɨ nɨnoknɨnkɨnkɨn, ha? Mɨ kɨma hɨriinanɨn whaowaeya prɨiboɨn, aniya? ");
INSERT INTO iws_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Mɨ ɨiya iikamɨm sɨma nɨnsiin ɨdwowi mɨ sɨma wɨ nonkwona rani. Nɨɨngaka. Mɨ sɨma wɨ Adi Komii siir oman paekwosɨmɨm nɨnomor kou hɨr nwowɨn wɨ sɨmiir hɨriinan nwowi, nɨɨnga nɨɨngar. ");
INSERT INTO iws_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tɨ iikamɨm naonamɨm mɨ ha swokɨ ɨnsiin ɨdwowi. Kara kɨmiir srɨiyɨm mɨni. Adi Komii siir yaiyɨm Moses siir hauuwɨm, kɨma sɨmiir bɨ mwaɨngɨm, aniya? Siya hɨnɨɨna boɨnkɨn, ");
INSERT INTO iws_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","kara Ebraham mɨ Aisak mɨ Jekop sɨmiir Adi Komiigɨn. Adi Komii siya iikamɨm naonamɨm sɨmiir Adi Komii rani. Iikamɨm kwoɨnbudɨn omwai waiyayokiyokɨiiyɨn sɨmiir Adi Komiigɨn. ");
INSERT INTO iws_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Iikamɨm kingiin nokwoɨm sɨma ta hɨriinan yai aiir wakaekiyɨm mɨ sɨma ɨni hindara yanaakiyɨm Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ta hɨriinan yaiya Jisɨs siya Sadyusi sɨmiir yai aiir boɨn tankaigikɨn. Mɨ Farisi kamɨm sɨma ta yai aiir wakaekiyɨm mɨ sɨma ɨna haɨngiriyɨu boɨnainamɨm. ");
INSERT INTO iws_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Mɨ sɨmiir bopwo hɨrɨn inkam nwɨrɨn siyɨu ɨmiir nɨnoknɨnkɨniyɨn ɨni hɨrar nwowɨn. Siya Jisɨs siir srɨikɨnankɨuwam namkɨn. ");
INSERT INTO iws_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Iikam nowomwarkaiyɨuan inkam pɨkɨ hɨnɨɨn siyɨu ɨkɨn, siyɨu whɨekakɨm Moses siya wɨnɨm sɨmiir bɨi nwowɨm, ha? ");
INSERT INTO iws_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Mɨ Jisɨs siya siir boɨnki, Bɨiyan Inkam Komiiyɨn siya kɨriir Adi Komiigɨn. Mɨ kɨriir mhɨi kwoɨnɨm mɨ kɨriir kɨrɨeya wɨ saiirar hauu ɨuguski mɨ kɨriir digworaekwo whɨekakɨm sɨmiir warar. ");
INSERT INTO iws_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tɨ siyɨuɨn siya ɨni siyɨu nhɨrɨm Moses siya wɨnɨm sɨmiir kou ywowɨn. ");
INSERT INTO iws_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mɨ mhoɨiyan siyɨu whɨrɨn yɨo hɨnɨɨna boɨnkɨn, kɨra inkam nhɨrɨm sɨmiirɨm naɨngwowiyɨm mɨ kɨramar naɨngwonaeiyɨn saiir hɨriinanar daɨngwo. ");
INSERT INTO iws_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tɨ siyɨuwo sowa boɨnkiywo ɨni Moses mɨ profet kamɨm sɨmiir siyɨu ɨmiirar higrɨnɨu ɨrkakiyɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisi kamɨm sɨma ɨrɨpa nikɨ haɨngiriyɨu owɨm mɨ Jisɨs siya sɨmiir srɨi, ");
INSERT INTO iws_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","kɨma Krais siirɨn ɨni panɨɨna naɨngwowɨm tɨ inkamɨn Adi Komii siya nɨkropkiyɨn, ha? Siya nhɨnir pɨugan ankɨn, ha? Mɨ sɨma siirɨn hɨnɨɨna yowarkɨi boɨnki, Devid siir pɨuganankɨn. ");
INSERT INTO iws_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Mɨ Jisɨs siya sɨmiirɨn ɨna swokɨ srɨiyɨn. Dimusika? Mɨ Adi Komii siir naeyɨuɨn Devid siir nwowɨn siirɨn siya nɨisiimauugɨn mɨ Devid siya siirɨn Bɨiyan Inkam Komii dimusi dapkɨn, ha? Siya hɨnɨɨna boɨnkɨn, ");
INSERT INTO iws_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Devid siya hɨnɨɨna boɨnkɨn Adi Komii siya, kariir Bɨiyan Inkam Komiiyɨn siirɨn hɨnɨɨna boɨnkɨn, kɨra kariir ɨɨna ɨɨniga saiir dɨdwo. Mɨ mhoɨiya kɨriir sau omomɨn wɨ kara kɨntɨokɨi sɨmiirɨn. Mɨ wɨ kɨriir aowa nwokaii. ");
INSERT INTO iws_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Kɨma kɨgi Devid siya dapkikɨn Inkamɨn Adi Komii siya nɨkropkiyɨn Bɨiyan Inkam Komii siya mɨ siya tɨ inkamɨn Devid siir isid panɨɨna nwokɨn, ha? Nɨɨngaka. Siyɨu karamaekɨn. ");
INSERT INTO iws_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mɨ inkam nwɨrkɨn bɨ nowarki boɨnmɨmɨnkɨn ta Jisɨs siir yaiya. Nɨɨngaka. Mɨ ta ɨi aiirɨn sɨma ɨna yɨdidbwakainamɨm siirsiyɨn mɨ mhoɨiya sɨma siirɨmɨn dimɨn whɨram bɨ swokɨ srɨi mɨmɨnkɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Mhoɨiya Jisɨs siya yaiyɨm iikam whɨekakɨm mɨ kamɨm siir kɨgna mɨriiyɨm sɨmiir boɨnmɨmauugɨn. Jisɨs siir yaiya hɨnɨɨna boɨnkɨn, ");
INSERT INTO iws_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","kamɨm siyɨu komii nɨnoknɨnkɨniyɨm mɨ Farisi kam ɨkɨm, sɨma kɨmiirɨn Moses siir siyɨu ɨmiir nowamwarkaiyɨugɨm. ");
INSERT INTO iws_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mɨ hɨriinankɨnɨuwi yɨm tɨ hɨriinan digworaekwowɨm, sɨmiir boɨnmɨmauuwiyɨm, yɨm kɨma sɨmiirɨn ha wakaeyokna ap. Mɨ sɨmiir siyɨu ɨiirɨn, yɨo kɨpi kɨgna ap. ");
INSERT INTO iws_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tɨ yaiyɨm sɨma kɨmiir boɨnmɨmauuwiyɨm, yɨm ɨni dimɨn hɨkakɨm kɨma nɨtyɨskai apiyɨm, kɨmiir waeyao ɨni hɨriinan ywowɨm. Mɨ sɨma wɨ kɨmiir whɨnhai rani, tɨ dimɨn hɨkak ɨmiirɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Dimɨn taemɨnɨm sɨma mɨriiyɨm, sɨma mɨnam mɨni, iikamɨm sɨmiir nwokɨ kɨgɨm sɨma tɨ ɨɨnmi op mɨnɨm mɨnam niigɨm sɨma Adi Komii siir yaiyɨm sɨmiir hopkaiyam. Mɨ sɨmiir mwowɨm haɨs ha mɨ kikog nhwo kwɨsboɨni digworaekwowɨm, sɨmiir haigiyam. Mɨ iikamɨm sɨmiir kɨgii, sɨma wa nwokɨ aɨngwowɨm, sɨma inkam wadɨekɨm. Mɨ yɨuɨs prɨei prɨeiyɨm sɨma niiyɨm yɨm ha mɨ pɨuai haigɨnɨu. Sɨma nhwo Adi Komii siiram kwɨsboɨniyɨm mɨ iikamɨm sɨmiir kɨgi, sɨma wa boɨni, hɨe wara inkamɨm, sɨma inkam wadɨekɨm. ");
INSERT INTO iws_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mɨ ɨiya sɨma yaewou komii komiiyɨm sɨmiiram namiyɨm sɨma ɨkɨ mhoɨiyan ipiiyɨm sɨmiir bɨ nɨdwokaiigɨm. Nɨɨngaka. Sɨma ɨkɨ ipiiyɨm bɨiyar nwowɨnɨm pɨ sɨmiirar nɨdwokai omaka Adi Komii siir yai nɨdwokai wakaeiya saiirɨn ɨriipa hɨriinan. ");
INSERT INTO iws_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Sɨma ha naɨngwowi, iikamɨm maeyaua nae haigɨniya saiirɨn sɨma sɨmiir nwokɨ boɨn maɨrgɨmaɨrgam. ");
INSERT INTO iws_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Iikamɨm sɨma kɨmiirɨn hɨnɨɨna kɨpi dap iikam nowomwarkaiyɨuwan inkam komii komiigɨm. Nɨɨngaka. Inkamɨn nwɨruwaɨrgɨn kɨmiir nowomwarkaiyɨuwiyɨn, Adi Komii sasaɨrgɨn. Mɨ kɨma whɨekakɨm ɨni nomiiyaukɨna yoswowɨm. ");
INSERT INTO iws_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mɨ nu tɨrɨn kɨma inkam nwɨrniyɨn hɨnɨɨna kɨpi dap, krɨmiir Adi Komiigɨn. Nɨɨngaka. Adi Komiiyɨn nwɨruwaɨrgɨn, krɨmiir Adɨn. Mɨ siya ɨni nɨnomor kou hɨrar nwowɨn. ");
INSERT INTO iws_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mɨ sɨma kɨmiirɨn hɨnɨɨna kɨpi dap, inkam komii. Nɨɨngaka. Kɨmiir Bɨiyan Inkamɨn nwɨruwaɨrgɨn, yɨo karargɨn, inkamɨn Adi Komii siya nɨkropkiyɨn. ");
INSERT INTO iws_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yɨpɨkɨ inkamkɨn kɨmiir bɨi inɨgak nwowɨn. Siya bɨiyɨn hinda whɨsarii mɨi prɨimɨriiyan inkam dwo ");
INSERT INTO iws_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","inkamɨn siir inɨg ɨiirar hainanaeiyɨn mɨ mhoɨiya siir inɨgɨn wɨ aokɨ aowa namɨguskii. Mɨ inkamɨn siir inɨg ɨiirar hainana karamae nwowiyɨn, mhoɨiya siya wɨ inɨg komiigak nwowi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Tɨ siyɨu komii nɨnoknɨnkɨniyɨm kamɨm mɨ Farisi kam ɨkɨm. Kɨma mɨntarao! Kɨma nɨksɨsaeyan inkamkɨm. Mɨ kɨma yaiyaɨrga nhɨnkɨni. Iikamɨm Adi Komii siya kɨgrɨraowiyɨm sɨma nwowam naɨngwowiyɨm, sɨmiirɨn kɨma nɨksɨsaei mɨ tɨ iikamɨm sɨmiir anowɨn kɨmar haigɨnɨkouwi. Mɨ sɨmiir kwoɨnɨm sɨmaka nwowam wara naɨngwo rani, sɨmiir siyɨuɨn kɨmar haigɨnɨkouwi. Mɨ kɨma Adi Komii siir iikamɨm siya kɨgrɨraowiyɨm sɨmaka bɨ namasugɨm. Mɨ iikam nhɨrɨm sɨmiiram namam tɨriyɨm, sɨmiir siyɨuɨn kɨmar haigɨnɨkouwi. ");
INSERT INTO iws_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Kɨma kamɨm siyɨu komii nɨnoknɨnkɨniyɨm mɨ Farisi kam ɨkɨm, kɨma mɨntarao! Mhoɨiya kɨmiirɨn wɨ Adi Komii siya nonkwobumbunɨnkɨn ɨuguskii kɨma yai aɨrgar nhɨnkɨni. Kamɨm naonamiyɨm sɨmiir wig igabaeyɨm pɨ kɨma mɨ ɨksɨsaei. Mɨ sɨmiir omakaɨn digworaekwowɨm pɨ kɨma mɨ tauae haii. Mɨ kɨma iikamɨm sɨmiir whwonkam ɨdaɨn nhwo pɨ prɨeiyar mɨ kwɨsboɨni, sɨmiir dimɨn biyɨeyɨm sɨmiir higrɨnɨuwam. Mɨ iikamɨm sɨma wa nwokɨ aɨngwowɨm, kɨma inkam mɨiyɨkɨm. Mɨ Adi Komii siya kɨmiirɨn wɨ hɨriinansi hauuwi. ");
INSERT INTO iws_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Kɨma kamɨm siyɨu komii nɨnoknɨnkɨniyɨm mɨ Farisi kam ɨkɨm, kɨma mɨntarao! Mhoɨiya Adi Komii siya kɨmiirɨn wa nonkwobumbunɨnkɨn ɨguskii. Kɨma yaiyaɨrga nhɨnkɨni. Mɨ kɨma whɨi komiiya mɨ nu ɨkɨm sɨmiirar napboɨnmɨmauuwi Adi Komii siir yai aiirɨn iikamɨm sɨmiir kwoɨn ɨmiir hɨurworwokaiyam. Mɨ sɨma kɨmiir yaiyar bɨdi wakaeyoknaɨm. Siyɨu biyɨe sɨma dirɨraerarɨm ɨni kɨmiir ɨmiir haiburɨm. ");
INSERT INTO iws_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Mhoɨiya Adi Komii kara iikam biyɨe kɨmiirɨn wɨ hindara nonkwobumbu ɨuguski. Kɨma ɨni iikam nhwokwɨsaeyɨm sɨmiir nɨnkikwona apiyɨn ɨni sɨmiir hɨriinan ywowɨm mɨ kɨma wɨ dɨg nwo rani. Nɨɨngaka. Mɨ sɨma panɨɨnsi sɨbgu wakaeyokna apsi. Mɨ kɨma iikamɨm sɨmiirɨn hɨnɨɨna boɨnikɨm kara wa dirɨraerari, kara nɨksɨsae rani, kara yaimwowar boɨni. Tɨ kariir yaiyɨm, kara Adi Komii siir hɨnɨɨna boɨni, ɨni mɨ owɨn yɨo dimɨn komii rani. Mɨ kɨra hɨnɨɨna boɨni, kara wa dirɨraerari. Kara tɨ yaiyɨm sɨmiirɨn pɨ golɨn Adi Komii siir omaka hɨr nwokaiyɨn pɨ siir nɨkopaisɨsɨrki. Mɨ siya tɨ hɨriinan yaiyɨm sɨmiir boɨni mɨ kɨma siirɨn wa boɨn, siya ha dirɨraerar. ");
INSERT INTO iws_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kɨma whaowae inkamkɨm mɨ inkam nhwokwɨsaeyɨm! Dimu dimɨnkɨm bɨi nwowiyɨm mɨ dimu dimɨnkɨm mhoɨi nwowiyɨm, ha? Ɨhɨ, adi Komii siir omaka bɨiyɨn ɨni saeyar ywowa. ");
INSERT INTO iws_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Krɨma hɨnɨɨna boɨnkɨm, inkamɨn hɨiya nae haigɨn ɨnkɨn ɨmiiyaeiya Adi Komii siira saiir dapɨkopsɨsɨrki mɨ mhoɨiya siya tɨr karamae nwowi yɨo dimɨn kaimwo rani mɨ inkamɨn nae Adi Komii siir nɨkɨn ɨmiiyae ɨkopsɨsɨr hauuwi. Ɨhɨ, yɨo siya ha dirɨraerar. ");
INSERT INTO iws_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kɨma tɨ nhwokwɨsae inkam whaowaeyɨm dimu dimɨnkɨn bɨi nwowiyɨn, ha? Inkamɨn nae nɨnkɨn ɨmiiyaeiyɨn siya, iyɨe? Hɨiya saeyar mɨnkɨn tɨ naeyɨm dimɨn whɨrkɨ panɨɨnsi kɨmbusi. Ɨhɨ, hɨiya nae haigɨn nɨnkɨn ɨmiiyaeiya bɨiyɨn ɨni saeyar ywowa. ");
INSERT INTO iws_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Inkamɨn hɨiya nae haigɨn nɨnkɨn ɨmiiyaeiya saiir inɨg ɨiir dapɨkopsɨsɨri, siya digworaekwo saiir ɨdwo nwowɨm sɨmiir warar nɨnkɨn ɨkopsɨsɨrkikɨm. ");
INSERT INTO iws_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mɨ inkamɨn Adi Komii siir omaka mɨiyɨka saiir dapɨkopsɨsɨri mɨ siya Adi Komii siir omaka hɨr nwowɨn naeyɨu digworaekwowɨm sɨmiir wara nɨnkɨn ɨkopaisɨsɨri. ");
INSERT INTO iws_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Mɨ inkamɨn nɨnomor kou saiir dapɨkopsɨsɨri mɨ siya Adi Komii siya mɨ siir ipiiya sowiir warar nɨkopaisɨsɨri. ");
INSERT INTO iws_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Kɨma kamɨm siyɨu komii nɨnoknɨnkɨni ɨkɨm mɨ Farisi kam ɨkɨm. Kɨma mɨntarao mhoɨiya Adi Komii siya kɨmiirɨn wɨ hindara nonkwobumbunɨnkɨn ɨuguski. Dimusi rani, kɨma yai kiyɨmiyok boɨn kɨrɨekɨm. Mɨ kɨma dimɨn sɨsɨmɨm pɨ sɨmiirar mɨ sɨoɨtkɨni mɨ haɨmiiyɨn pa mɨ hauuwi mɨ tɨ hɨriinan dimɨn sɨsɨmɨm kɨma ɨna wakaeyokna dirɨraerarɨm mɨ bɨigɨ bɨiyan dimɨnɨn Adi Komii siir yaiya kɨma hɨriinan tɨr tani. Mɨ bɨiyan dimɨn komiiyɨn Adi Komii siir yaiya kɨma digɨumii saiirar haimriiyɨugigi. Mɨ siyɨu mɨiyɨk tɨri ɨkɨm iikam nhɨrɨm sɨmiir mɨ naɨngwobumbuni siyɨu mɨ naɨngwo tɨbmiini siyɨu ɨkɨm, kɨma tɨ hɨriinan dimɨn komii komiiyɨm digɨumii sɨmiir haimriiyɨugigɨm. Mɨ kɨma dimɨn komii mɨ Adi Komii siir dimɨn sɨmɨm sɨmiir wara wakaeyokna kɨswo mɨ siya kɨmiiramɨn wɨ maɨrgɨmaɨrga komiiya pɨ ywokiyɨn mɨ kɨma sɨmiir tɨrɨm pɨ boriisopkɨm. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kɨma inkam mɨiyɨk rani, ɨni nhwokwɨsaenan ywowɨm mɨ kɨma iikamɨm sɨmiirɨn Adi Komii siir siyɨu ɨiir nɨisiimauuamar naɨngwowi mɨ kɨma wɨ dɨg nwo rani. Mɨ Adi Komii siir yaiisɨsɨmɨm kɨma sɨmiirar nikwowaisii mɨ wakaeyokna rani. Mɨ kɨma Adi Komii siir bɨiyan yai komiiyɨm sɨmiir wakaeyoknaɨm naɨngwo rani. Mɨ kɨma pɨ boriisopi. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Kɨma kamɨm siyɨu komii nɨnoknɨnkɨniyɨm mɨ Farisi kam ɨkɨm, kɨma mɨntarao! Mhoɨiya Adi Komii siya wɨ kɨmiir nonkwobumbunɨnkɨn ɨuguski. Kɨma yaiyara nhɨnkɨni kɨmiir mhɨi kwoɨnɨm ɨni mobmor mob mɨnɨm ɨdanara kɨma sɨbgu hɨisokiyɨm mɨ aowa ɨokaka nwowiyɨm mɨ ɨni sɨmiir hɨriinan ywowɨm. Kɨmiir kwoɨnɨm ɨni inkam nwɨrni dimɨnam kɨgmaɨri siyɨuɨn mɨ pɨu saeya nɨpiyaokɨinami siyɨu ɨkɨn ɨni sɨma yɨnkɨnɨuɨm. ");
INSERT INTO iws_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisi kamɨm kɨma ɨni inkam whaowae nhwokwɨsaenan ywowɨn mɨ bɨiyɨn kɨma mobmɨr mobɨm sɨmiir aowa tikɨ hɨisok mɨ ɨdana wɨ wadɨeya mɨ oki. Mɨ ɨriipa hɨriinan kɨmiir kwoɨnɨm hɨriinana timɨ tɨr. Mɨ kɨra siyɨu mɨiyɨkɨn siir tɨram naɨngwowi kɨra wa tɨri. ");
INSERT INTO iws_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Kɨma kamɨm siyɨu komii nɨnoknɨnkɨniyɨm mɨ Farisi kam ɨkɨm, mhoɨiya Adi Komii siya wɨ kɨmiir nonkwobumbu ɨuguski. Kɨma mɨntarao! Kɨma yaiyarga nhɨnkɨni. Kɨmiir kwoɨnɨm ɨni maeyauwa inkam haɨngikaiiya ɨni saiir hɨriinan ywowɨm. Mɨ ɨdwowɨn wadɨeya sɨbgu kɨgi mɨ ɨenau hɨrɨn ɨni inkam mwokɨugɨ yɨnkɨnɨuɨn. Iikam kɨmiir mhɨi kwoɨnɨm hɨriinan ywowɨm. Mɨ ɨda wadɨeyar sɨbgu kɨgi mɨ kɨmiir aowan kwoɨnɨn mɨiyɨknan nwoki rani. ");
INSERT INTO iws_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kɨma ɨni ɨriipa hɨriinana mɨ owɨm, iikamɨm sɨma kɨmiir yaimwo whwonkam ɨmiirɨn wadɨeya kɨgi sɨma hɨnɨɨna naɨngwowi, kɨma iikam wadɨekɨm. Mɨ kɨmiir mhɨi kwoɨnɨm ɨni nɨksɨsaeni siyɨu ɨkɨn mɨ dimɨn bibiyɨeyɨm ɨni sɨmasɨmar nwokaiyɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Kɨma kamɨm siyɨu komii nɨnoknɨnkɨniyɨm mɨ Farisi kam ɨkɨm. Kɨma mɨntarao! Mhoɨiya Adi Komii siya wɨ kɨmiir nonkwobumbunɨnkɨn ɨuguski. Kɨma yaiyarga nhɨnkɨni. Kɨma profet kamɨm bɨiya naonamɨm sɨmiir kɨu mwowɨm ɨe ɨmiirar pɨuai haigɨnɨugɨm. Mɨ ɨiya sɨma omwaiya nikɨ waiyaɨm, sɨma siyɨu mɨiyɨk ɨiirar tɨrkɨm. ");
INSERT INTO iws_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mɨ kɨma boɨn, ɨiya krɨmiir yɨdiwi wanwiyaeyɨm sɨma nwowa krɨma saiir nwokɨswo mɨ krɨma wɨ sɨmiir di whɨnɨɨnii profet kamɨm sɨmiir nɨsom aowamɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ta yai hɨriinana kɨma kɨmar nɨisiimauunaei, kɨma tɨ kamɨm profet kamɨm sɨmiir nɨsomsom aowam, sɨmiir hɨran inkamkɨm. ");
INSERT INTO iws_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kara kɨmiirɨn yaimwowar boɨni, kara kɨmiirɨn bɨdi yɨnoknɨnkɨnɨn kɨma wɨ kɨmiir yɨdiwi wanwiyaeyɨm, sɨmiir siyɨu biyɨe ɨmiirar swokɨ tɨri, bɨiya sɨma tɨrɨm saiir hɨriinan mɨ kɨma wɨ hɨriinana swokɨ tɨri mɨ wɨ sɨmiir hɨriinana swokɨ ɨmbiyami. ");
INSERT INTO iws_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kɨma kam biyɨekɨm, kɨma mɨpugnankɨm. Kɨma kam biyɨeyɨm kɨma kam isid biyɨeyɨm sɨmiir hɨrankɨ nɨtkɨm mɨpugnan. Adi Komii siya kɨmiirɨn wɨ maeyauwa paekaka saiir hɨriir boɨnwokiyopnatkaigi, kɨma wɨ panɨɨna nɨdami, ha? ");
INSERT INTO iws_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mɨ kɨma wakae mhoɨiya kara wɨ profet kam nhɨrɨm nɨnoknɨnkɨn mɨiyɨkakɨm, Adi Komii siir Yokwo Komiiya saiir mɨ kamɨm nowomwarkaiyɨuwiyɨm wɨ kɨmiirɨm nɨkropki mɨ sɨma kɨmiir waraur nɨmbini. Mɨ nhɨrɨm wɨ kɨma nɨsomsom aokaowi mɨ paeyɨn hɨiniya nɨrɨonɨnkɨnɨn saɨka nɨrɨnuwi mɨ nhɨrɨm omaka, yaimɨn dimɨn nɨdwokai wakaeiya saiir hɨrar nɨpɨmpari. Mɨ nhɨrɨm kɨma sɨmiirɨn wɨ om komii whɨrɨn siir hɨrankɨ nhɨnɨkrɨropki mɨ sɨmiirɨn wɨ hɨnda tɨnda nɨnkɨn aeyokiyoki. ");
INSERT INTO iws_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Mɨ tɨ hɨriinanɨn kara wɨ saiirsi nɨkropki kam nhɨrɨm hɨk kɨmiir hauuwɨm, kam mɨiyɨk nhɨrɨm nuanɨm bɨiya kɨma nɨsom aowɨm sɨmiirsi. Inkam mɨiyɨk Ebel siir hɨranka nɨsomao bwakainamkɨm mɨ ɨni profet Sekaraia siirar yadɨgɨuwɨn Berekaia siir yɨnisɨmɨn. Sɨma siirɨn Adi Komii siir omaka yai nɨdwokai wakaeiya mɨ maeyaua hɨuyokiyokaiiya nae nɨnkɨn ɨmiiyaeiya dimɨn whɨrkɨ kɨmbu karam nwowa siirɨn hɨr nɨsom aokɨn. Dimusi rani, tɨ dimɨn hɨnɨɨnɨn mɨ Adi Komii siya kɨmiirɨn wɨ hɨriinansi nonkwobumbunɨnkɨn ɨuguski. ");
INSERT INTO iws_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kara kɨmiirɨn yaimwo aiirar boɨni. Dimɨn biyɨeyɨm sɨmiir hɨk kɨmpɨpɨsuɨm tɨ iikam isid whɨekakɨm kɨma tɨ nwowɨm wɨ krɨmiirar nɨmbiyami. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusaleman iikam!! Jerusaleman iikam!! Kɨma profet kamɨm kɨmiir waraur nɨtɨm sɨmiirar nɨsomsom aokaowikɨm mɨ iikam nhɨrɨm Adi Komii siya nɨkropkiyɨm sɨmiirɨn ɨni siiyani kɨma kaiyɨmɨk aokaokiyɨm. Ɨinokɨinokɨn kara kɨmiirɨn dimɨn biyɨeyɨm sɨmiir hɨrankar nɨkɨunama naɨngwowi kanaka nwowɨm kɨmiir whɨndirɨraerarɨm. Kakaruk yopiiya saiir yɨnɨm saiir kpɨdga aowa namiyɨm saiir hɨriinan tɨrama mɨni mɨ kɨmar boriisopi. ");
INSERT INTO iws_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kɨma wakae! Mhoɨiya kɨmiir omɨn wɨ iikam karamaeyar nwoki. ");
INSERT INTO iws_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ɨhɨ, kara kɨmiirɨn hɨnɨɨna boɨni mɨ kɨma wɨ kariir kɨgmɨmɨn tani mɨ ɨiya kɨma ta yai hɨnɨɨna saiir boɨni mɨ wɨ saiirar nadɨgɨuwi. Adi Komii siya kɨnsiishaigɨnɨuwi tɨ inkamɨn. Bɨiyan Inkam Komii siir inɨg ɨiir nɨtɨn siir. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisɨs siya Adi Komii siir inɨg hainaniya omaka komiiya yai nɨdwokai wakaeiya saiir haiburgikɨn mɨ ɨna yapnaniyamɨn mɨ kamɨm siir kɨgna mɨriiyɨm sɨma siiram yɨt. Sɨma siir nɨisiimauuam naɨngwokɨm omaka mɨiyɨkɨm Adi Komii siirɨm sɨmiir. ");
INSERT INTO iws_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Mɨ siya sɨmiir boɨnki, kɨma tɨ digworaekwowɨm sɨmiir bɨdi kɨgiyɨm, aniya? Ɨhɨ, kara kɨmiirɨn yaimwo aiirar boɨnki, tɨ siiyaɨm Adi Komii siir omaka saiirɨm sɨma wɨ siiya kwɨrni ɨdwo nwo rani. Nɨɨngaka. Mɨ kam nhɨrɨm sɨma nɨti, wɨ tɨ Adi Komii siir omakaɨm sɨmiir nɨinɨkinhɨɨmnhɨnkigi mɨ wɨ nu saɨka dɨga swokɨ amwowɨuwi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisɨs siya mhɨu Oliv hɨr nɨdwokɨn mɨ kamɨm siir kɨgna mɨriiyɨm sɨma sɨmar yɨt siirɨmɨn mɨ sɨma siir inɨ boɨni, kɨra krɨmiir boɨnmauugi, tɨ dimɨn hɨriinanɨm wɨ pakɨ hɨnɨɨn ɨiya saiir nɨmbiyami krɨmiir nɨisiimauuamɨn, ha? Pɨkɨ hɨnɨɨn dimɨnɨn wɨ bɨi siya nɨmbiyami mɨ krɨma wɨ siir nwokɨ ɨnoknɨnkɨnɨm ɨiya kɨra swokɨ haiyɨug ɨtana saeya nɨmbiyami mɨ tɨ nuɨn wa dɨgi, ha? ");
INSERT INTO iws_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jisɨs siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨn, kɨma kɨma kɨmasiyar sɨbgu mɨntɨraona wɨ inkam nhɨrkɨm nɨksɨsaesi kɨmiirɨn. ");
INSERT INTO iws_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kam nhɨrɨm sɨma nɨti mɨ sɨma wɨ kariir inɨg ɨiir ninɨ ɨksɨsae dapboɨni, karargɨn Kraisɨn Adi Komii siya nɨkropkiyɨn mɨ sɨma wɨ iikam whɨekakɨm sɨmiir nɨksɨsae ɨrkaki. ");
INSERT INTO iws_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mɨ mhoɨiya kɨma wɨ yaiini yaiyɨm sɨmiir wakaemɨmɨkwɨni. Yaiiya hɨnda tɨnda ɨna nɨniiya, kingiin mɨ aru ɨriipɨ hɨriinan mɨ kɨma wɨ kɨpi nanaawɨn. Tɨ digworaekwowɨm sɨma wa nɨmbiyami mɨ ɨiya kara nɨtana tɨ nu ɨeya dɨgana ya ɨna nikɨ owa. ");
INSERT INTO iws_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nu whɨran kamɨm wɨ nu whɨran kamɨm yaii sɨmaka nɨnii. Mɨ inkam komiiyɨn nu kɨgrɨraowiyɨn wɨ nu whɨranɨn siir isidɨn yaii wɨ inkam komii nwɨrɨn siir isid ɨnaka nɨnii. Mɨ nu maeyau nhɨrɨm wɨ mhɨi prasae nao rani mɨ nu maeyau nhɨrɨm wɨ nɨɨn prasae nɨt rani. ");
INSERT INTO iws_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tɨ digworaekwo whɨekakɨm wɨ wiga yɨnisɨmɨn hɨukrɨmkrɨpɨn naokainam wɨ saiir hɨriinan hɨk kɨmpɨpɨsu haii, bɨiya saeya haiyɨm wɨ saiir hɨriinan nɨmbiyami. Ta ɨi aiirɨn sɨma hɨk kɨmpɨpsu wɨ kɨmiir hauuwi mɨ sɨma wɨ kɨmiir nɨsomsom aokaowi. Mɨ iikam whɨekakɨm hɨnda tɨnda nwowɨm wɨ ɨo nhwo kɨmiir nanaowi. Dimusi rani, kɨma kariir yai aiir wakaeyoknakɨm. Tɨ digworaekwo whɨekakɨm wɨ wiga yɨnisɨmɨn hɨukrɨmkrɨpɨn naokainaɨm wɨ saiir hɨriinan hɨk kɨmpɨpɨsu haii bɨiya saeya haiyɨm wɨ saiir hɨriinan nɨmbiyami. ");
INSERT INTO iws_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ta ɨi aiirɨn sɨma hɨk kɨmpɨpɨsu wɨ kɨmiir hauuwi mɨ sɨma wɨ kɨmiir nɨsomsom aokaowi. Mɨ iikam whɨekakɨm hɨnda tɨnda nwowɨm sɨma wɨ ɨo nhwo kɨmiir nanaowi. Dimusi rani, kɨma kariir yai wakaeyoknaeikɨm. ");
INSERT INTO iws_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mɨ ta ɨi aiirɨn iikam whɨekakɨm sɨma wɨ sɨmiir naɨngwo tɨbmii aiir haiburgigi. Mɨ sɨma sɨmiir nomiiyauɨm wɨ sɨmiir sau omomɨn siir kɨnmauu ɨti mɨ sɨmiir nhɨrɨm wɨ ɨo sɨma sɨma nɨnwo anwowi. ");
INSERT INTO iws_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mɨ ta ɨi aiirarɨn nɨksɨsae profet kam whɨekakɨm sɨma nhɨnani mɨ wɨ iikam whɨekakɨm sɨmiir nɨksɨsaei. ");
INSERT INTO iws_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mɨ ta ɨi aiirarɨn dimɨn biyɨeni siyɨuɨn wɨ komiiya nɨmbiyami mɨ iikam whɨekakɨm sɨma wɨ inkam nwɨrnisi naɨngwokwonanae rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Iikamɨm sɨma sɨmiir naɨngwo tɨbmiiya kɨrɨeya nwoyokiyokɨii mɨ mhoɨigɨ mhoɨiyana saiirar namwoɨuwi mɨ tɨ iikamɨm sɨmiirɨn wɨ Adi Komii siyar swokɨ anmaiwarkainaei. ");
INSERT INTO iws_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Mɨ sɨma wɨ nu maeyau maeyau whɨekakɨm hɨnda tɨndanɨm sɨmiir napboɨnmamauu ɨrkaki maeyauwa Adi Komii siya kɨgɨrkakana siir digworaekwo whɨekakɨm saiir mɨ iikam isid whɨekakɨm sɨma wa wakae, dimɨn mɨiyɨkɨm Adi Komii siya dirɨraerarɨm. Mɨ wɨ ɨi aeya nadɨgɨuwi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Inkamɨn ta yaiya saiir mwaɨnɨn siya sɨbgu daɨngworɨnu, Jisɨs siya boɨnki mɨ mhoɨiya kɨma wɨ tɨ dimɨn biyɨekɨ biyɨeyɨn Adi Komii siir omaka ɨo saiir hɨoanɨn wɨ siirar kɨgi, dimɨnɨn Adi Komii siir omaka bopwo nwowɨn igbid kamiyaugakɨn bɨiya profet Daniel siya boɨnɨn nɨmbiyamɨm mɨ siya. ");
INSERT INTO iws_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Mɨ ta ɨi aiirɨn iikam whɨekakɨm nu Judia hɨr nwowɨm sɨma mhɨua hɨriir yɨdam nɨnopkainam. ");
INSERT INTO iws_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mɨ iikamɨm yaba hɨr grɨnkɨn okwowɨm mɨ sɨma sɨmiir digworaekwo ɨmiirɨm kɨpi swokɨ iwɨt nɨnopkainam omaka hɨriirɨn sɨmiir haiyɨm sɨma mhɨua hɨriirar dɨdam ɨugugusamki. ");
INSERT INTO iws_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Mɨ yɨpɨkɨ inkamkɨm sɨma numɨr nwowi mɨ sɨma sɨmiir oma hɨriir kɨpi swokɨ haiyɨug am, sɨmiir yɨuɨs ɨmiir hainakiyɨm. Sɨma hindara dɨdam ɨugusam. ");
INSERT INTO iws_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mɨ wigɨm yɨnpɨugak nwowɨm sɨmiirsi naɨngwoyɨmiyoki mɨ wigɨm yɨnpraigakakɨm sɨmiirsi warar mɨ timɨ aɨngwoyɨmiyoki ta ɨi aiir nwowɨm. Sɨma wɨ nɨdam sasau rani, sɨma wɨ hɨkak nwowi mɨ wa kɨguguwi. ");
INSERT INTO iws_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kɨma Adi Komii siiram srɨi boɨn mɨ ɨi kɨma nɨdami saiirɨn wɨ naokɨ kɨpi kɨn mɨ wɨ Judami ɨi komiiya Sabat pɨu siisiya dimɨn taemɨn tɨr karamae nwowiya saiir mɨ ɨdami ya wɨ mɨiyɨk mɨ o rani, tɨ ɨi hɨriinanɨm kɨma wɨ nɨdam sasauni siyɨuɨm whaowaei. ");
INSERT INTO iws_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Mɨ ta ɨi aiirɨn wɨ hɨk kɨmpɨpɨsu prasae hai rani. Ɨiya nuɨn siya wɨna nikɨ owɨn mɨ ɨni tariinana yamwoniyɨn, tɨ hɨk hɨriinanɨm bɨiya sɨma bɨ nikɨ ɨmbinikɨm. Mɨ mhoɨiya wɨ hɨriinan hɨkɨ mɨ ɨmbiyam tani. ");
INSERT INTO iws_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Mɨ Adi Komii siya tɨ dimɨn biyɨeyɨm sɨmiir ɨiya saiir nikwokrɨpna karam nwokɨswo mɨ iikam whɨekakɨm sɨma wɨ hɨriiyar pɨ whaowae ɨuguskiyɨn. Adi Komii siya siir kamɨm siya nɨmbinɨm sɨmiirsi naɨngwoyɨmiyokiyɨn mɨ siya tɨ ɨi hɨriinana saiir asi nikwokrɨpnakɨn, tɨ dimɨnɨm sɨma nɨmbiyamam. ");
INSERT INTO iws_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Mɨ ta ɨi aiirɨn inkam nwɨrɨn siya wɨ kɨmiir boɨni. Kɨgi, inkamɨn Adi Komii siya nɨkropkiyɨn siya tɨsi tɨrar nwowɨn, siya ɨsi hapi nwowɨn, kɨma wɨ siir yai kɨpi naɨngwo tɨbmii. ");
INSERT INTO iws_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ta hɨriinana kara kɨmiirɨn saiir boɨnki mhoɨiya kam nhɨrɨm sɨma nɨti mɨ wɨ hɨnɨɨna ninɨ ɨksɨsae boɨni, Kraisɨn karargɨn. Mɨ kara profet inkam nwɨrkɨn. Mɨ sɨma wɨ dimɨn kɨrɨe komii komii nhɨrɨm sɨmiirar dirɨraerari, iikamɨm Adi Komii siya nɨmbinɨm sɨmiirɨn wɨ sɨma nhɨnprɨiginam kɨnankɨugɨuwi mɨ tɨ iikamɨm sɨma wɨ sɨmiir yai wakaeyokna rani. ");
INSERT INTO iws_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Wakae, kara kɨmiirɨn bɨi tɨ digworaekwo ɨmiirar boɨnmauugɨm mɨ bɨi wɨ digworaekwowɨm sɨma nɨmbiyami mɨ mhoɨiya kɨma sɨmiir kɨgi mɨ kɨma wɨ hanɨɨngɨ kɨgnɨnoknɨnkɨni. ");
INSERT INTO iws_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Sɨma kɨmiir hɨnɨɨn yai boɨni, kɨgi. Siya maeyauwa inkam karamaeya nu siiyɨn apa saiir nwowɨn, kɨma wɨ taka maeyauwa saiir kɨpi nam. Mɨ sɨma hɨnɨɨna boɨni, kɨgi, siya ta omaka maeyauwa hɨuyokiyokai saiir hɨr nwokaiyɨn. Kɨma wɨ sɨmiir yai kɨpi naɨngwo tɨbmii. ");
INSERT INTO iws_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kɨma ɨna kɨgɨm, sinana bɨekɨ nɨmbiidniyɨn siir hɨrar sinankiyɨm mɨpi bɨekɨ nɨkiiyamiyɨn siir hɨrar namwoɨuwi mɨ mhoɨiya ɨiya Yaowae Adɨn nɨnomor kouanɨn kara swokɨ ɨti kɨma kariirɨn wɨ hɨriinanar kɨgwɨni. ");
INSERT INTO iws_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Maeyauwa inkam whɨigɨ nwowiya mɨ wakikiyao wabɨm pɨ sɨmiir pɨu ɨmiirar natkɨkɨn ɨdwo aei. Mɨ mhoɨiya kara swokɨ ɨti iikam whɨekakɨm sɨma wɨ kariirar kɨgwɨni. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Hɨk komiiya ta ɨiya saiir haiya saeya dɨg nwoki mɨ bɨeyɨn wa kakauu ɨuguski mɨ bwana wɨ mɨ whwo rani mɨ nauunɨm wɨ nɨnomor kou hɨranka nɨkɨigɨiki. Mɨ nɨnomor kou hɨran dimɨn komii komiiyɨm, sɨma wɨ nɨɨni hanɨɨna nɨtki. ");
INSERT INTO iws_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Mɨ ta ɨi aiirɨn digworaekwo nhɨrɨm nɨnomor kou hɨranɨm mhoɨiya wɨ iikamɨm wɨ sɨmiir nɨisiimauuwi ta ɨiya. Kara Yaowae Adɨn nɨnomor kouanɨn wɨ saiir swokɨ ɨti mɨ iikam isidɨn hɨnda tɨndanɨm nu tɨranɨm sɨma wɨ nou prasae kɨn tani. Mɨ Yaowae Adɨn nɨnomor kouanɨn sɨma wɨ kariirar kɨgwɨni waumɨrsɨma kariir dimɨn kɨrɨe komiiyɨm paenan nɨuyaeiyɨm wɨ sɨmaka nɨnkɨn ɨti. ");
INSERT INTO iws_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ɨiya kara nɨti, kɨdɨn wa maski. Mɨ ɨiya siya kɨd maski mɨ kariir paekwosɨmɨm sɨma wa namki omom omomɨm hɨda tɨnda nwowɨm sɨmiir, iikamɨm kara nɨmbinɨm sɨma wɨ kariiram nɨkɨunani. ");
INSERT INTO iws_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Kɨma whrou siir bɨdi yɨnoknɨnkɨnɨm. Ɨiya pɨ whrou siya woki tɨ hɨriinanɨn krɨma pa nɨnoknɨnkɨni opɨn wɨ sɨpi nɨuwi. Mɨ opud naowo wa mɨ ɨkii kɨni. Ta hɨriinan ɨiya saeya opkɨ nɨuwi aeya. ");
INSERT INTO iws_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ɨni mɨ owɨn, mhoɨiya kɨma ha kɨgi tɨ dimɨn taemɨn whɨekakɨm kara boɨnɨm ɨni nɨmbiyamɨm, kɨma ha dɨnoknɨnkɨnki, ɨiya kara nɨtana ɨni kingiin nwowa. ");
INSERT INTO iws_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Kara kɨmiirɨn yaimwo aiirar boɨni, iikamɨm sɨma ta ɨi aiirar nikɨ owɨm sɨma wɨ nikɨ aonam tani mɨ tɨ digworaekwo whɨekakɨm wa nɨmbiyami. ");
INSERT INTO iws_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nu nɨnomor sowa wa dɨgi mɨ kariir yaiya wɨ swokɨ dɨgi rani. Nɨɨngaka. Saeya wɨ hɨriiyar nwoyokiyokɨi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Inkam nwɨrkɨn ta ɨi aiirɨn nɨnoknɨnkɨn mɨmɨn tani. Mɨ paekwosɨmɨm nɨnomor kou hɨranɨm sɨma ɨriipa hɨriinan sɨma saiir mɨ ɨnoknɨnkɨn tani. Kara Yaowae Adɨn saiir mɨ ɨnoknɨnkɨn tani. Nɨɨngaka. Adi Komii sasa nɨnoknɨnkɨni ta ɨiya kara nɨtana. ");
INSERT INTO iws_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ɨiya Noa siya nwowa mɨ siyɨuɨm saiir tɨrɨm, hɨriinan siyɨu kaimwowɨm wɨ saiirar swokɨ tɨri ɨiya kara Yaowae Adɨn nɨnomor kouanɨn kara swokɨ ɨti. ");
INSERT INTO iws_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ɨiya op komiiyɨn siya nɨuunani karamaeya nikɨ owɨn, sɨma tɨ hɨriinan siyɨuɨm sɨmiir tɨrkɨm opmɨn kwiyae mɨ naemɨn nongwomamaɨr aeikiyam mɨ wigmɨn prɨinonkwonakaeyam. Mɨ ɨni Noa siya yambudkiyɨn siyaiiya hɨriir. ");
INSERT INTO iws_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Iikamɨm sɨma bɨ nɨnoknɨnkɨnkɨm mɨ sɨma ɨni hɨriinana mɨ prɨi ywowɨm. Sɨma ha bɨ naɨngwokɨm tɨ dimɨnɨm wɨ sɨmbi nɨmbiyami. Nɨɨngaka. Mɨ op komiiyɨn ha nɨuunaniyɨn mɨ ɨni iikam whɨekakɨm sɨmiirar kaipri hainamɨm mɨ sɨma ɨna yaonamɨm. Kara Yaowae Adɨn nɨnomor kouanɨn kara nɨti wɨ hɨriinanar mɨ tɨri. Sɨma wɨ nɨnoknɨnkɨn tani mɨ wɨ ha nwokwokɨn tani ɨiya kara nɨtana saiiram. ");
INSERT INTO iws_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mɨ ɨiya kara swokɨ ɨti sɨma wɨ nɨnoknɨnkɨnwɨn tani. Mɨ inkam nwɨsko sowa ɨrɨpa mɨi mɨriiguwaki mɨ wɨ nwɨruwaniya nɨkɨunami mɨ nwɨrɨn siirɨn wɨ hɨrar haiburgigi. ");
INSERT INTO iws_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Mɨ wig ɨso sowa ɨrɨpa mɨi mɨriiguwaki mɨ ɨra wa nami mɨ ɨra wɨ hɨrar haiburgigi. Mɨ hɨriinankɨnɨuwi ");
INSERT INTO iws_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","kɨma, kɨma kɨmasiyar mɨntɨraowɨn. Kɨma nɨnoknɨnkɨn tani, pakɨ hɨnɨɨn ɨiya wɨ sae swokɨ ɨti kara kɨmiir Inkam Komiiyɨn. ");
INSERT INTO iws_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kɨma tɨ dimɨn ɨmiir daɨngwo, omakaɨn adɨn siya ha nɨnoknɨnkɨni hɨi tauaean inkamɨn pɨ sɨpi nɨti mɨ siya pa nɨdwo kaowi mɨ hɨiyan inkamɨn pɨ hɨriir napnɨnopkainam tani ");
INSERT INTO iws_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kɨma ɨriipa hɨriinan ha nhɨnkaokwokɨn, kara Yaowae Adɨn nɨnomor kouanɨn ɨigwɨra kara nɨti ɨna nwowa. Mɨ kɨma wa nɨnoknɨnkɨn tani kara wɨ ta hɨnɨɨn ɨiya saiir nɨti. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Pɨkɨ hɨnɨɨn mɨiyan inkam ɨkɨn kwoɨn mɨiyɨkakɨn mɨ siir mɨi ɨmiir sɨbgu kɨgrɨraowiyɨn, ha? Bɨiyan inkamɨn siya mɨnam nɨmbingɨn siya siir mɨiyan kam nhɨrɨm sɨmiir kɨgrɨraowɨm mɨ nae sɨmiir mɨ ɨnkɨn hauu aeyɨm naeni ɨi aiir. Ɨiya tɨ inkam hɨriinanɨn siya tɨ dimɨnɨm sɨmiir wakaeyokna dirɨraerari mɨ siya inkam mɨiyɨk ɨeya. ");
INSERT INTO iws_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mɨ mhoɨiya siir bɨiyan inkamɨn ha nɨtɨn mɨ siya ɨna inɨ kɨgniyɨn tɨ mɨiyan inkam ɨiir mɨ mɨiyɨm bɨiya siya boɨngigɨm ɨni hɨriinanar mɨriikwokɨnɨm mɨ tɨ bɨiyan inkamɨn siya wɨ maɨrgɨmaɨrga nwowi siirɨn. ");
INSERT INTO iws_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Kara kɨmiirɨn yaimwowar boɨni, mhoɨiya tɨ bɨiyan inkamɨn, wɨ siir nɨmbini, siir dimɨn komii komiiyɨm siya kɨgrɨraowɨm. ");
INSERT INTO iws_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mɨ tɨ mɨiyan inkam biyɨeyɨn siir kwoɨnɨn ha naɨngwowi, kariir bɨiyan inkamɨn siya wɨ nɨtsɨsau rani ");
INSERT INTO iws_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","mɨ siya siir ɨrɨpa mɨi mɨriiyɨm kamɨm sɨmiirɨn ɨna tɨo bwakainanamɨn mɨ siya op biyɨe kwiyaeyɨm kamɨm sɨmaka mɨ aekwiyaeikɨn. ");
INSERT INTO iws_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mhoɨiya tɨ mɨiyan inkamɨn siir bɨiyan inkamɨn siya nɨti mɨ tɨ mɨiyan inkamɨn ɨiya siya nɨtana saiir nɨnoknɨnkɨn tani. ");
INSERT INTO iws_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mɨ bɨiyan inkamɨn siya nɨti wɨ tɨ mɨiyan inkamɨn siirar tɨrbumbunɨnkɨnki mɨ siya siirɨn kamɨm nɨksɨsaeiyɨm sɨmaka nɨkmwɨn owaigɨnɨuwi. Ta maeyau aiirɨn iikamɨm sɨma wɨ nou prasae kɨn tani mɨ sɨma wɨ sɨmiir big ɨmiirar ninan aekiyɨmkiyɨki. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Adi Komii siya siir digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana mɨ ɨni mwɨigak kopak ɨuurɨm sɨmiir hɨriinan ywowɨn. Inkam nwɨrɨn wiga tariinanar kwonkwonakɨn mɨ tɨ mwɨigak kopakɨm sɨmiir yɨukɨdɨm warar hainam, sɨma siirɨn siyɨu hɨr napyɨskaiwɨnam namkɨm mɨ siir nɨkɨunaniyɨm. ");
INSERT INTO iws_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Mɨ ɨriiyarɨm nɨnoknɨnkɨn mɨiyɨkakɨm mɨ ɨriiyarɨm nɨnoknɨnkɨn mɨiyɨk karamaekɨm. ");
INSERT INTO iws_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Mɨ wigɨm nɨnoknɨnkɨn karamaeyɨm sɨma yɨugɨd nhɨɨngam sɨmiirara hainam mɨ sɨma yaeya op (kerosin) haɨmiiyɨm sɨmiir wara bɨ hainamkɨm. ");
INSERT INTO iws_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Mɨ wigɨm nɨnoknɨnkɨn mɨiyɨkakɨm, sɨmiir opɨm (kerosinɨm) aimwoniya yaokai hainam sɨmiir yɨukɨd ɨmakar. ");
INSERT INTO iws_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tɨ wig nonkwonaɨn inkamɨn siya bɨ nikɨ ɨtsɨsaugɨn. Mɨ tɨ wig ɨuurɨm sɨmiir nhwowɨm ɨna yɨridɨm mɨ sɨma ɨna whwonkainamɨm. ");
INSERT INTO iws_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Mɨ yai kwɨra ɨni nɨibwopwo komiiya saiirar kauwok boɨniwɨiya wigkam wɨno nonkwonao ɨni nɨtwɨiyo. Kɨma siirɨn siyɨu hɨr dapyɨskaiwɨn mɨ siirɨn wɨkɨunani. ");
INSERT INTO iws_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tɨ mwɨigak kopak ɨuurɨm ɨna nhɨɨngiwɨiyɨm mɨ sɨma sɨmiir yɨugɨd ɨmiirar dirɨraerar hainamɨm. ");
INSERT INTO iws_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Mɨ wigɨm nɨnoknɨnkɨn karamaeyɨm sɨma boɨnki, nɨnoknɨnkɨn mɨiyɨkak wig ɨmiir, kɨma op (kerosin) haɨmiiya krɨmiir whauugi. Krɨmiir yɨugɨdɨm pɨ sɨmbi tɨngiyami. Mɨ krɨma diriiyar nami. ");
INSERT INTO iws_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Mɨ wigɨm nɨnoknɨnkɨn mɨiyɨkakɨm sɨmiirɨn hɨnɨɨna yowarkɨi boɨnki. Nɨɨngaka. Ta op (kerosin) haɨmiisɨma, kɨma mɨ krɨma saiirararɨn pɨ dɨg nwo rani, kɨma omaka digworaekwo saɨniya saiir hɨr saɨnaki kɨmamar. ");
INSERT INTO iws_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mɨ sɨma op (kerosin) saɨnam bɨdi yamɨm mɨ wig nonkwonan inkamɨn siya ɨna yɨtɨn. Mɨ wigɨm siirɨm waikaokwokɨnɨm ɨna yamɨm omaka hɨriir wigwas nae komii aiirɨm mɨ sɨma anowɨn ɨna haigɨnɨkougiyɨn. ");
INSERT INTO iws_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Mhoɨiya mwɨigak kopak ɨriiyarɨm ɨna swokɨ ɨtɨm mɨ sɨma inɨ kauwok boɨni, Bɨiyan Inkam Komii kɨra anowɨn krɨmiirɨm haiwaoki. ");
INSERT INTO iws_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mɨ siya ɨna yowarkɨi boɨnɨn, kara kɨmiirɨn yaimwo aiirar boɨni, kara kɨmiir bɨ nɨnoknɨnkɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Mɨ Jisɨs siya sɨmiir boɨnki, kɨma mɨntarao. Dimusi rani, kɨma nɨnoknɨnkɨn tani, ɨiya mhoɨiya kara nɨtana. ");
INSERT INTO iws_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Adi Komii siya siir digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana saeya ɨni bɨiyan inkamɨn aru maeyau namam mɨnɨn mɨ siya siir mɨiyan kam nwoɨmɨm sɨmiirɨn ha nɨkɨunaɨn mɨ siir digworaekwo whɨekakɨm sɨmiir ɨɨn yɨnkwo hauugik sɨma kɨgrɨraowɨm mɨ ɨni saiir hɨriinan ywowɨn. ");
INSERT INTO iws_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Siya siir mɨiyan kamɨm sɨmiir siyɨu ɨkɨm mɨ sɨmiir kɨrɨe ɨkɨm sɨmiirar kɨgɨn mɨ siya umɨrɨm sɨmiirɨn yapayapa maɨr asi hɨd hauugɨn. Mɨ nwɨrɨn umɨrɨm 5,000 kɨm siir mɨ nonkwo hauugikɨm mɨ nwɨrɨn 2,000 kɨm siir mɨ nonkwo hauugikɨm mɨ nwɨrɨn 1,000 kɨm siir mɨ nonkwo hauugikɨm. Siya sɨmiirɨn hɨriinan tɨrgikɨn mɨ siya ɨna yamɨn. ");
INSERT INTO iws_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mɨ siya aru maeyau bɨdi yamkiyɨn mɨ bɨ kɨmɨmɨnkikɨn inkamɨn 5,000 umɨr haiyɨn ɨna mɨriinamɨn tɨ umɨr ɨmiirar mɨ yaeya 5,000 nhɨrɨm ɨna swokɨ mɨrii haiyɨn. ");
INSERT INTO iws_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mɨ tɨ inkamɨn 2,000 umɨr hainaowidɨn, yɨo ɨriipa hɨriinan siya ɨna mɨ mɨrii namɨn mɨ 2,000 umɨra swokɨ mɨrii hai. ");
INSERT INTO iws_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mɨ inkamɨn 1,000 umɨr hainaowidɨn, siya ɨe inɨ opɨuɨn umɨrɨm siir Bɨiyan Inkam Komii ɨeya hauugikɨm sɨmiir haigiprakaiyam. ");
INSERT INTO iws_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Bwan whɨekakɨm bɨdi yamkiyam mɨ mhoɨiya tɨ mɨiyan kamɨm sɨmiir bɨiyan inkamɨn ɨna yɨtɨn mɨ umɨrɨm siya hauugikɨm sɨmiir kitɨbmii boɨnam nɨtkɨn. ");
INSERT INTO iws_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mɨ inkamɨn umɨr 5,000 hainaowidɨn siya ɨna yɨtɨn mɨ umɨr 5,000 nɨm siya mɨrii haiyɨm sɨmiir warar hainam mɨ siya boɨn, inkam komii kɨra umɨrɨm 5,000 na hauugikɨm mɨ kɨgi mɨ kara ha mɨrii nanaeyɨn mɨ 5,000 umɨra swokɨ ɨnkɨn mɨrii hai. ");
INSERT INTO iws_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Inkam komiiyɨn siirɨn hɨnɨɨna boɨn, kɨra mɨiyan inkam mɨiyɨkɨn, kɨra mɨi mɨiyɨka sɨbgu mɨriigɨn, kɨra mɨiya sɨbgu kɨgrɨraowikɨn, kɨra dimɨn sɨsɨmɨm sɨmiirar sɨbgu kɨgrɨraowɨn. Kara hɨnɨɨna naɨngwowi kɨra digworaekwo whɨekakɨm sɨmiirar kɨgrɨrao ɨrkak. Mɨ kɨra kanakar unɨ maɨrgɨmaɨrgani: ");
INSERT INTO iws_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mɨ inkamɨn 2,000 umɨr hainaowidɨn mɨ siya ɨna yɨtɨn mɨ siya ɨna yaboɨniyɨn, inkam komii kɨra kariirɨn 2,000 umɨra hauugigɨn, kɨgi. Kara ha swokɨ mɨrii nanaeyɨn mɨ umɨrɨm 2,000 na swokɨ ɨnkɨn mɨrii hai. ");
INSERT INTO iws_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Siir bɨiyan inkam komiiyɨn siir boɨnki, kɨra mɨiyan inkam mɨiyɨkɨn, kɨra mɨi mɨiyɨka sɨbgu mɨriigɨn, kɨra dimɨn sɨsɨmɨm sɨmiirar sɨbgu kɨgrɨraowikɨn mɨ kariir digworaekwo whɨekakɨm wɨ kɨra kɨgrɨraowi mɨ kɨra kanakar unɨ maɨrgɨmaɨrgani. ");
INSERT INTO iws_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Mɨ inkamɨn 1,000 hainaowidɨn yɨo siya ɨna mɨ ɨtɨn mɨ siya ɨna boɨnɨn, inkam komii, kara bɨdi yɨnoknɨnkɨnɨn, kɨra inkampaii rani, sasae digworaekwowɨm inkam nwɨrni numɨranɨm kɨra pɨ sɨmiirar prɨinɨngugu hai. Mɨ kɨra twonid ɨsɨm inkam nhɨrmi nikɨ okmwɨn whrami, ɨsɨm sɨma, haigɨnki mɨ twonidgɨɨnɨm sɨma. Mɨ twonidgɨɨnɨm kɨra pɨ kɨriir omaka hɨriirar swokɨ hainami. ");
INSERT INTO iws_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kara pɨ nɨdidgɨn kɨriirsi mɨ kara ha namɨn mɨ kɨriir umɨrɨm nunau ɨe inɨ ophaigiyɨu. Mɨ kɨgi! Ha tɨsi kɨriir 1,000 umɨrɨm. ");
INSERT INTO iws_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Inkam komii siirɨn ɨna yowarkɨi boɨnɨn, kɨra mɨiyan inkampaii rani! Kɨra nhakɨu kɨrɨekɨn! Kɨra kariirɨn ɨna nɨnoknɨnkɨnɨn kara inkam nwɨrni nokmwɨn ɨnkɨni numɨran sasaeyɨm mɨpi kara swokɨ ɨngugu haiyɨrkaki mɨ ɨriipɨ hɨriinan kara inkam nhɨrmiya nokmwɨn hai twonidɨm numɨr hɨrankɨn mɨ tɨ twonid ɨmiirɨn pɨ kara swokɨ haiyɨrkaknami omaka hɨriir. Kɨra tɨ sɨmiirɨn ɨna nɨnoknɨnkɨn, aniya? ");
INSERT INTO iws_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kɨra kariir umɨrɨm omaka umɨr haigiya saiir haigi karamae dimusi nwokɨn, saeya yaeya umɨr swokɨ ɨnkɨn mɨrii haiyɨm, ha? Mɨ ɨiya kara swokɨ ɨtkɨswo mɨ kariir yaeya (profit) umɨrɨm sɨmiir wara pɨ swokɨ hainiyɨn. ");
INSERT INTO iws_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Mɨ kɨma tɨ umɨr 1,000 nɨm sɨmiirɨn siir ɨɨnankɨn tɨ swokɨ hai mɨ inkamɨn 10,000 umɨrkakɨn siir tɨ swokɨ ɨnkɨn hauugi. ");
INSERT INTO iws_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Dimusi rani, kam nhɨrɨm dimɨn taemɨn whɨekakɨm sɨma sɨmiirɨn mɨi mɨiyɨk sɨbgu mɨiriiyɨm mɨ kara sɨmiirɨn wɨ ɨdwowa swokɨ ɨnkɨn hauugi digworaekwo nhɨrɨm. Mɨ inkam nwɨrɨn siya siir digworaekwowɨm kwɨsuwakɨnɨuwi mɨ siya sɨmiirɨn mɨi sɨbgu mɨrii karam nwowi mɨ siir dimɨn sɨsɨmɨm siya nonkwowɨn mɨ wɨ siir ɨɨnankar swokɨ hai. Mɨ siya wɨ nɨɨnga nwoki. ");
INSERT INTO iws_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mɨ tɨ mɨiyan inkam biyɨeyɨn siir kiyɨtkaigi maeyauwa nɨibwomambwo nwowiya saiir hɨriir. Ta maeyau aiirɨn sɨma hɨk kɨmpɨpɨsu haii mɨ sɨma wɨ sɨmiir big ɨmiirar naekiyɨmkiyɨki. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Mhoɨiya kara Yaowae Adɨn nɨnomor kouanɨn siya wɨ inkam komiiyɨn nu kɨgrɨraowiyɨn siir hɨriinan nwowi mɨ siir paekwosɨm whɨekakɨm mɨ siya dimɨn mɨiyɨkɨm paenan nɨuyaeiyɨm sɨmaka warar nɨnkɨn ɨti, ta ɨi aiirɨn siya wɨ inkam komiiyɨn nu kɨgrɨraowiyɨn digworaekwo whɨekakɨm sɨmiir wɨ siir ipii aiirar nɨdwokaii. ");
INSERT INTO iws_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Mɨ iikam isid whɨekakɨm hɨda tɨndanɨm wɨ kariir whwonkam ɨdar nwomɨmɨri mɨ kara sɨmiirɨn wɨ isid whɨsa hɨdaigɨni mɨ inkamɨn sibsib, meme kɨgrɨraowiyɨn siir hɨriinan hɨdi. Sibsibɨm maeyau kwɨra mɨ memeyɨm maeyau kwɨra. ");
INSERT INTO iws_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mɨ kara wɨ hɨnɨɨna hɨdaigɨnɨuwi. Iikam mɨiyɨkɨm sibsib nanɨm wɨ kariir ɨɨna ɨɨniga namki mɨ iikam biyɨeyɨm meme nanɨm wɨ kariir ɨɨna yaɨoyaeya saiir namki. ");
INSERT INTO iws_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Mɨ kara inkam komiiyɨn nu kɨgrɨraowiyɨn digworaekwo whɨekakɨm sɨmiir, kara iikamɨm kariir ɨɨna ɨɨniga nokwoɨm wɨ sɨmiir boɨnki, kɨma iikamɨm Adi Komii siya tɨrhaigɨnɨuwɨm wadɨe, kɨma ha dam digworaekwo mɨiyɨk mɨiyɨkɨm bɨiya kariir Adɨn siya nɨmbinɨm ɨiya tɨ nu ɨiir nonkwokwowa saiir, sɨmiir tinɨ haiyɨu. ");
INSERT INTO iws_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Dimusi rani, ɨiya kara mhɨirɨma nwowa mɨ kariirɨn kɨma hauu aekɨn mɨ ɨiya kariir kwoɨnɨn opam haɨeyɨn mɨ kariirɨn opa kɨma hauu kwiyaekɨn. Kara om whɨran inkamnanargɨn mɨ kariirɨn kɨmiir omaka hɨriirar mɨ whɨnam. ");
INSERT INTO iws_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kara yɨuɨs karamae nwowɨn mɨ kariirɨn yɨuɨs kɨma hauu iigɨn. Mɨ kara makɨ niiyɨn mɨ kariirɨn kɨma kɨgrɨraokɨn mɨ ɨni kariir ma aeyar dɨgiyɨn. Mɨ kara omaka hɨuyokiyokaiya mɨi biyɨe mɨriiya saiir nwowɨn mɨ kɨma kariirar nap kɨgraraonakikɨm. ");
INSERT INTO iws_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Mɨ inkam mɨiyɨk mɨiyɨkɨm sɨma wɨ siir yai aka nowarkɨi boɨni. Bɨiyan Inkam Komii, pɨkɨ hɨnɨɨn ɨiya krɨma saiir kɨgɨn kɨra mhɨigɨ naowɨn, krɨma naeyɨm pakɨ hɨnɨɨn ɨiya saiir hauu aekɨn, ha? Mɨ kɨriir kwoɨnɨn pakɨ hɨnɨɨn ɨiya saiir haɨekɨn opamɨn mɨ krɨma op kɨriirɨn ha hauu kwiyaekɨn, ha? ");
INSERT INTO iws_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Pakɨ hɨnɨɨn ɨiga krɨma kɨriir kɨgɨn kɨra om whɨran inkamnan nwowɨn mɨ krɨma kɨriirɨn krɨmiir omaka hɨriir whɨnamɨn, ha? Mɨ pakɨ hɨnɨɨn ɨi aka kɨra yɨuɨs karamae nwowa mɨ krɨma yɨuɨs kɨriir hauu iiyɨn, ha? ");
INSERT INTO iws_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Pakɨ hɨnɨɨn ɨi aka krɨma kɨriir kɨgɨn mɨ kɨra makak nwowɨn mɨ kɨra omaka hɨuyokiyokaiya mɨi biyɨe mɨriiya saiir nwowɨm mɨ krɨma ninɨ ap kɨgrɨraonakiyɨn, ha? ");
INSERT INTO iws_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mɨ kara Yaowae Adɨn siya sɨmiirɨn wɨ hɨnɨɨna nowarkɨi boɨni, kara yaimwowar boɨni: Mɨ digworaekwo whɨekakɨm kɨma tɨrɨm tɨ kariir nomiiyauɨn inɨg sɨm karamaeyɨn siir mɨ yɨo hɨriinan siyɨuɨn kɨma kariirar whɨndirɨraerarkɨm. ");
INSERT INTO iws_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Mɨ mhoɨiya siya sɨmiir boɨn dɨgiyɨn mɨ iikamɨm siir yaɨoyaeya nwowɨm sɨmiir boɨnki, kɨma kɨgugu ɨugusan iikamkɨm! Kɨma damki, paeya ɨinokɨinok nɨuyokiyokiya hɨk kɨmpɨpɨsu haiiya saiiram. Mɨ ɨinokɨinokɨ hɨrar nwokaeyami mɨ ta paeya Adi Komii siya Setan mɨ siir paekwosɨsɨmɨm sɨmiirɨm dirɨraerar namgɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Dimusi rani, bɨiya kara mhɨigɨ naoɨn mɨ kɨma kariir bɨ hauu aekɨm mɨ kariir kwoɨn opam haɨeiyɨn mɨ kɨma op kariir bɨ hauu kwiyaekɨm. ");
INSERT INTO iws_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Kara om whɨran inkamkɨn mɨ kɨma kariirɨn bɨ nɨkɨunamkɨm kɨmiir omaka hɨriirɨn. Mɨ ɨiya kara yɨuɨs karamae nwowa mɨ kɨma yɨuɨs kariir bɨ hauugɨm. Mɨ ɨiya kara makak nwowɨn mɨ omaka hɨuyokiyokaiya mɨi biyɨe mɨriiya saiir hɨr nwowɨn mɨ kɨma kariir bɨ ninɨ aprɨrɨr kɨgnakikɨm. ");
INSERT INTO iws_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Mɨ kara tɨ yai hɨriinanɨm sɨmiir boɨn dɨgii mɨ sɨma kariir yai aiirɨn wɨ hɨnɨɨna nowarkɨi boɨni, Bɨiyan Inkam Komii, pakɨ hɨnɨɨn ɨi aka kɨra mhɨigɨ naowɨn mɨ krɨma kɨriir kɨgɨn mɨ kɨriir kwoɨnɨn opam haɨeyɨn, kɨra om whɨran inkamkɨn, kɨra yɨuɨs karamaekɨn mɨ kɨra pakɨ hɨnɨɨn ɨi aka makɨ kɨra niiyɨn mɨ omaka hɨuyokiyokaiya mɨi biyɨe mɨriiya kɨra saiir nwowɨn. Mɨ krɨma kɨriir kɨgɨm, ha? Mɨ krɨma dimɨnɨm sɨmiir bɨ kɨgɨm mɨ krɨma kɨriir panɨɨnsi whɨndirɨraerarsi. ");
INSERT INTO iws_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Mɨ kara inkam komiiyɨn sɨmiir yai aka wɨ hɨnɨɨna nowarkɨi boɨnki, kara kɨmiirɨn yaimwo aiirar boɨni, kɨma kariir nomiiyau nwɨrɨn inɨgsɨm karamae nwowɨn siir sɨbgu grab karamae nwowi mɨ tɨ hɨriinan siyɨuɨn yɨo kɨma kariir bɨ sɨbgu grabgɨm. ");
INSERT INTO iws_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jisɨs siir yaiyɨm hɨnɨɨna inɨ boɨn dɨgi. Mɨ tɨ hɨriinan iikam isidɨn sɨma wɨ paeya nami, sɨma wɨ hɨk kɨmpɨpɨsu prasae ninɨ haiyɨu rani, ɨinokɨinokɨn. Mɨ iikam mɨiyɨk mɨiyɨkɨm sɨma wɨ omwaiya waiyayokiyokɨii. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisɨs siya tɨ siir yai whɨekakɨm iikamɨm sɨmiir boɨnmɨmauu dɨgiyɨn mɨ ta ɨi aiirɨn siya siir mɨi kɨgna mɨriiyɨm sɨmiir boɨnki, ");
INSERT INTO iws_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","kɨma ɨna nɨnoknɨnkɨnɨm, ɨi komiiya wou nikwo aeniya, ɨi kwɨsuwa nwowi krɨma wɨ saiir naei. Mɨ ta ɨiya kara Yaowae Adɨn nɨnomor kouankɨn nɨtɨn sɨma kariirɨn wɨ sauan omomɨn siir kɨnmauu ɨti mɨ paeyɨn hɨiniya nɨrɨonɨnkɨnɨn saɨka nɨrɨnugi. ");
INSERT INTO iws_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mɨ ta ɨi aiirɨn prismi yaowae ad ɨkɨm mɨ Isrel sɨmiir bɨiyan inkam komii ɨkɨm, sɨma prismi yaowae adɨn, siir inɨgɨn Kaiafaskɨn, sɨma siir omaka komiiya saiirara ywomɨmɨrɨu. ");
INSERT INTO iws_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Mɨ sɨma yai mɨnam haɨngiriyɨu boɨnaigɨm, siyɨuɨn Jisɨs siir nɨmprɨo nonkworɨmdɨɨnu haɨnɨm. ");
INSERT INTO iws_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Sɨma ɨna boɨnɨm, krɨma tɨ dimɨn hɨriinanɨn ɨiyɨm wou nikwo aeiyɨm sɨmiir kɨpi dirɨraerar. Dimusi rani, iikam sɨma yaii wɨ krɨmaka nɨniisi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisɨs siya om Betani hɨr nwokɨn, inkam nwɨrɨn ma biyɨeya paowagɨ pɨsɨkomkopouɨn siir omaka hɨr, siir inɨgɨn Saimonkɨn. ");
INSERT INTO iws_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ɨiya Jisɨs siya omaka hɨrar nwowɨn mɨ wig ɨra siirɨm yɨt mɨ wa mobɨn pɨui mɨiyɨk whakiyɨn, umɨr kasaka bɨ saɨnikɨn, ɨra hainani. Ɨiya Jisɨs siya hɨiya saiirar nikɨ ɨdwo aeyɨn mɨ tɨ siiya mob wakakɨn, pɨui mɨiyɨk whakiyɨn Jisɨs siir mwo ɨiirar yaokɨnki. ");
INSERT INTO iws_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kamɨm siir kɨgna mɨriiyɨm sɨma hɨriinan kɨgiyɨm mɨ ɨo ɨna ywowɨm, sɨma boɨn, tɨ waɨn whɨsarii dimusi naoki ɨuguskikɨn, ha? ");
INSERT INTO iws_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Krɨma tɨ siiya mob wakakɨn inkam nwɨrni hauuwi, siya saɨnɨm mɨ krɨma siirɨn wɨ umɨr prasae dihaii mɨ ɨkɨ iikam paeprikabɨm wɨ sɨmiir pɨ hauuwi. ");
INSERT INTO iws_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisɨs siya sɨmiir yaiya ɨna yɨnoknɨnkɨnkiyɨn mɨ siya sɨmiir boɨnki, kɨma ta wiga saiirɨn hɨriinan dimusi tɨri saeya nɨdidamɨn, ha? Saeya tɨ hɨriinan siyɨu mɨiyɨkɨn kariirar tɨrka. ");
INSERT INTO iws_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Iikam paeprikabɨm sɨma wɨ kɨmakar nwoyokyokɨi mɨ kara kɨmaka wɨ ɨi prɨei nwo rani. ");
INSERT INTO iws_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mɨ ta wiga saeya tɨ waɨn kariir pɨu naokɨnkiyɨn saeya kariir naoni siyɨuɨn siirɨm dirɨraerarka Juda krɨmiir siyɨuɨn hɨriinana tɨriikɨn. ");
INSERT INTO iws_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mɨ sɨma wɨ saiirar naɨngwo yokiyokɨi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mɨ ta ɨi aiirarɨn kamɨm siir kɨgna mɨriiyɨm ɨuur nwɨsko, sɨmiir nwɨrɨn siir inɨgɨn Judas Iskariotkɨn, siya prismi bɨiyan kamɨm sɨmiirɨm yam. ");
INSERT INTO iws_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Mɨ siya boɨn, kɨma kariirɨn wɨ dimu dimɨn hauuwi mɨ kara Jisɨs siirɨn wɨ kɨmiir kɨnmauu ɨti, ha? Mɨ sɨma siirɨn umɨr silvaɨm kamnwɨr ɨuura hauu. ");
INSERT INTO iws_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Mɨ ta ɨi aiirɨn siya ɨna yap haɨnsran bwakaiyɨn, Jisɨs siirɨn sɨmiir kɨnmauu ɨtɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Bɨigɨ bɨiyan ɨiya bretɨn yis karamaeyɨn siir naeiya mɨ kamɨm Jisɨs siir kɨgna mɨriiyɨm sɨma ɨna yɨtɨm mɨ sɨma ɨna boɨnɨm, kɨra paɨnɨɨna naɨngwowi krɨma digworaekwowɨm papi dirɨraerar haigɨni mɨ kɨra wou krɨmaka papi nikwo aei, ha? ");
INSERT INTO iws_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Mɨ Jisɨs siya sɨmiir boɨnki, kɨma om komii Jerusalem hɨriir dapnɨnopkainam mɨ kɨma inkam nwɨrɨn siya krɨmiir bɨdi yɨnoknɨnkɨnɨn siirɨn hɨnɨɨna tinɨ boɨnɨu, inkam yai krɨmiir nowomwarkaiyɨuwiyɨn siya hɨnɨɨna boɨnkikɨn, ɨi kariira naowana ɨni kingiin nwowa kara kamɨm kariir mɨi kɨgna mɨriiyɨm wou sɨmaka nikwo aeyam naɨngwowi kɨriir omaka waraur. ");
INSERT INTO iws_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kamɨm Jisɨs siir kɨgna mɨriiyɨm yaiyɨm siya boɨnkiyɨm sɨmiir hɨriinanar mɨ tɨr mɨ sɨma wou nikwo aeyamɨn ɨna dirɨraerarɨm. ");
INSERT INTO iws_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Mɨ ta ɨiya saiir naɨoka Jisɨs siya mɨ siir mɨiyan kam ɨuur nwɨswo sɨmaka yɨdwokai aekairɨb. ");
INSERT INTO iws_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Sɨma nikɨ ɨdwo aeyɨm mɨ siya sɨmiir boɨn, kara kɨmiirɨn yaimwo aiirar boɨni, kariirɨn wɨ kɨmiir nwɨrkar nap wouwi wɨr kam biyɨeyɨm ɨo kariir nwowi sɨmiir. ");
INSERT INTO iws_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Mɨ ɨiya siya hɨriinan boɨn dɨgiyɨn mɨ sɨma hɨk prasae bɨ haigɨm mɨ siirɨn sɨma nwonɨra nwonɨra srɨii, Bɨiyan Inkam Komii mɨ tari kara, aniya? ");
INSERT INTO iws_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Mɨ Jisɨs siya ɨna yowarkɨi boɨnɨn, kɨmiir nwɨrɨn ɨɨn siira kanaka nɨnkɨn ɨnopmai two saiir mɨ kariirɨn wɨ siyar kɨnmauu ɨti. ");
INSERT INTO iws_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ɨhɨ, kara Yaowae Adɨn nɨnomor kouankɨn nɨtɨn naowam, bɨiya ywokwo komii saeya kariir boɨna saiir hɨriinan. Tɨ inkamɨn kara Yaowae Adɨn nɨnomor kouankɨn nɨtɨn wɨr siir napwouwi siirsi naɨngwo yɨmiyokii. Ɨni mɨ owɨn siirɨn yopiigɨ mɨ aokaina karamaekɨswo tɨ inkam ɨiirɨn. Dimusi rani, ta ɨiya siya wa kɨgugu ɨuguski. ");
INSERT INTO iws_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Mhoɨiya Judasɨn, inkamɨn Jisɨs siir sauan kam ɨmiir kɨnmauu ɨtɨn siya Jisɨs siirɨn hɨnɨɨna srɨi, iikam nowomwarkaiyɨuɨn inkam mɨ tari kara, aniya? Jisɨs siya siir boɨnki, wa kɨra boɨna ɨni kaimwowar ywowa. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Sɨma ha nikɨ aeyɨm mɨ Jisɨs siya bretɨn ɨna haiyɨn mɨ Adi Komii siir boɨn wadɨeki mɨ ɨna yɨnopkiyɨn mɨ kamɨm siir kɨgna mɨriiyɨm sɨmiir hauugi sɨma naeyɨm mɨ siya ɨna boɨnɨn, kɨma hai mɨ ha dae, takɨna kariir kɨp aeya. ");
INSERT INTO iws_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Mɨ mhoɨiya siya op mob wainɨn ɨra hai mɨ Adi Komii siir boɨn wadɨeki mɨ siya sɨmiir hauugi mɨ ɨna boɨnɨn, kɨma whɨekakɨm tɨ op wain mob ɨiir kwiyaeki. ");
INSERT INTO iws_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Tɨ dimɨnɨn kɨma kwiyaeyɨn siya kariir nhɨeka. Kara wɨ mɨnam naokiki Adi Komii siir nɨmbina wa nɨmbiyami iikam whɨekakɨm sɨmiir dimɨn biyɨe ɨmiir haiyoprimdiyɨumiigiyɨm. ");
INSERT INTO iws_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kara kɨmiirɨn yaimwowa boɨni, kara wɨ op wain saiir swokɨ kwiyae mɨmɨn tani. Mɨ kara ta op wain wɨna saiirɨn wɨ kɨmaka swokɨ ɨnkɨn kwiyaei kariir adɨn siir om hɨr. ");
INSERT INTO iws_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Sɨma ha nae dɨgiyɨm mɨ mwai kwɨra saiir wao mɨ wao dɨgiyɨm mɨ sɨma yaba hɨriir yapniyam mɨ sɨma mhɨu Oliv hɨriir yam. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Sɨma mhɨu Oliv siirɨn ha nɨmbiyamɨm Jisɨs siya sɨmiir boɨnki, kɨma whɨekakakarɨn ta nɨi aiirɨn kɨma wa nɨdam nɨnopki, ta hɨriinana Adi Komii siir Ywokwo Komiiya saeya hɨnɨɨna boɨnka, kara inkamɨn sibsib kɨgrɨraowiyɨn siir nɨsomaoki mɨ sibsib isidɨn wa nɨdam nɨnopki. ");
INSERT INTO iws_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Mɨ kara wɨ ɨe hɨrankar swokɨ ɨnsiin ɨdwowi mɨ kɨmiir bɨiyɨn wɨ kara nam kwokɨni nu Galili hɨriirɨn. ");
INSERT INTO iws_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita siya siir yai aka ɨna yowarkɨi boɨnɨn, sɨma nɨdamamkɨ wɨndi kara wɨ wara nɨdamam tani. ");
INSERT INTO iws_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jisɨs siya siir boɨnki, kara kɨriirɨn yaimwo aiirar boɨnki, ta nɨi aiirɨn ɨuumɨn wɨ nikɨ ɨk rani mɨ kariir inɨg ɨiirɨn kɨra wɨ kwoɨma mɨisɨsaei mɨ kɨra wa boɨni, kara siir bɨ nɨnoknɨnkɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita siya boɨn, kara kɨnaka naonamɨm mɨnkɨ wɨndi mɨ kara wɨ hɨnɨɨna boɨn tani, kara kɨriir bɨ nɨnoknɨnkɨnkɨn. Nɨɨngakɨɨnga. Mɨ kam nhɨrɨm kɨgna mɨriiyɨm sɨma hɨriihɨriinan yaigɨna boɨn dɨgi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jisɨs siya sɨmaka warar yam numɨr kwɨra saiir, sɨma ha dapikɨm Getsemani. Mɨ siya kamɨm siir kɨgna mɨriiyɨn sɨmiir boɨnki, kɨma tɨrar dɨdwo, kara hɨnda nami nhwo kwɨs boɨnɨuwi. ");
INSERT INTO iws_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Mɨ Pita siya mɨ Sebedi siir yɨnisɨm nwɨs owa sɨmiir yɨkɨunam mɨ ɨni sɨma yamɨm. Tariinanɨn siya ɨni hɨkaka ywowɨn mɨ siya hɨk kɨmpɨpɨsu prasae bɨ kɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Mɨ siya sɨmiir boɨnki, kariir mhɨi kwoɨnɨm ɨni hɨkaka nwowɨm, kariirɨn wɨ ta hɨk aeya nɨsom aowi, kɨma tapaiir dwo mɨ kariirsi whɨn naɨngwoyɨmiyok. ");
INSERT INTO iws_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Mɨ siya haɨmiisɨma ha namkiyɨn mɨ siya ɨtwaomiya yakainam nua hɨriir. Mɨ hɨnɨɨna srɨi boɨn, Adi ɨni mɨ owɨn, kɨra ta hɨka saiir haigi, kɨra kariir kwoɨn ɨiir kɨpi naɨngwo ap. Nɨɨngaka. Kɨra kɨriir kwoɨn ɨiirar daɨngwo ap. ");
INSERT INTO iws_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Mɨ siya ha kwɨsboɨn dɨgiyɨn mɨ siya kamɨm siir kɨgna mɨriiyɨm sɨmiiram swokɨ am mɨ ɨna inɨ kɨgɨuɨn sɨma nhwo hɨrar whwonkaii mɨ siya sɨmiir yɨnɨdgu. Mɨ siya Pita siir boɨnki, kɨma kanaka nɨnkɨn aɨngwoyɨmiyok ɨdwo waikao karamae dimusi nwokɨm ta ɨi haɨmiisɨma aiirɨn, ha? ");
INSERT INTO iws_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kɨma kɨmasiyar mɨntarao mɨ nhwo ha kwɨs boɨn, dimɨn biyɨekɨ kɨmiir kɨnaɨnkɨuwi kɨma wɨ kɨrɨekak nwo rani, kaimwo kɨɨnga. Kwoɨnɨn ɨna naɨngwowɨn mɨ pɨu saeya kɨrɨekak nwo rani. ");
INSERT INTO iws_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Mɨ mhoɨiya siya ha swokɨ amɨn mɨ hɨnɨɨna swokɨ srɨi boɨnɨu, Adi, tɨkɨ hɨk hɨriinanɨm kɨra saiir nikwo waisi ɨuguski karamae nwowi mɨ ta hɨk hɨriinana kara saiirɨn wa haii mɨ kɨra kɨriir kwoɨn ɨiirar daɨngwo apɨski mɨ ha dirɨraerar. ");
INSERT INTO iws_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Mɨ mhoɨiya siya ha swokɨ ɨtɨn mɨ siyar yap kɨgni sɨma nhwo hɨrar swokɨ grɨnkɨn whɨni, sɨma nhwokɨ nɨridgɨm mɨ sɨma nhwo asi whwɨnkɨm. ");
INSERT INTO iws_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Mɨ Jisɨs siya sɨmiir swokɨ haiburgigɨn mɨ kwoɨmaka ɨna swokɨnɨ kwɨs boɨnɨuɨn, dimɨnɨm bɨiya siya nikɨ kwɨs boɨnɨm mɨ sɨmiir hɨriinana swokɨnɨ kwɨs boɨnɨu. ");
INSERT INTO iws_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Mhoɨiya siya kamɨm siir mɨi kɨgna mɨriiyɨm sɨmiirɨm swokɨ ɨtɨn mɨ sɨmiirɨn ɨna yaboɨniyɨn, kɨma ɨna nikɨ whɨnɨm, aniya? Wakae! Kara Yaowae Adɨn nɨnomor kouankɨn nɨtɨn kariir nonkwoniyana ɨiya, kamɨm ɨo kariir nwowiyɨm sɨma, saeya kingiin bɨdi yɨniyaniya. ");
INSERT INTO iws_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kɨma dɨnsiingi mɨ krɨma pɨ nami, kɨgi, inkamɨn wɨr kariir napwouwanɨn siya ɨni kingiina nɨtɨn. ");
INSERT INTO iws_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisɨs siya ha nikɨ boɨnaiyɨn mɨ Judasɨn sɨmiir inkam nwɨrɨn ɨuur nwɨsaka kɨgna mɨriiyɨn siya ɨna yɨtɨn. Mɨ inkam isid komiiyɨn ɨni saɨka yɨnkɨn ɨtɨn, sɨma kamkɨu mɨnɨm mɨ dan mɨnɨm ɨni warar hainaniyɨm. Prismi bɨiyan kam ɨkɨm mɨ Isrelmi bɨiyan inkam komii komiiyɨm sɨmiirɨn sɨma nɨkropkikɨm. ");
INSERT INTO iws_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Mɨ Judasɨn inkamɨn wɨr siir napwouwanɨm siya sɨmiirɨn hɨnɨɨna boɨnmauu nam, kara pɨ inkam nwɨrɨn siir nakɨ aepirɨmdɨɨnɨuwi mɨ kɨma pa dɨnoknɨnkɨnki tɨ inkamɨn Jisɨs siyarkɨn. Mɨ kɨma pɨ siir donkworɨmdɨɨnu. ");
INSERT INTO iws_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Mɨ bɨ kɨmɨmɨnkikɨn ɨni Jisɨs siiramar yɨtɨn mɨ ɨna boɨnɨn, akamɨe, iikam nowomwarkaiyɨuwɨn inkam. Mɨ siya siir yakɨ aepirɨmdɨɨnɨu. ");
INSERT INTO iws_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jisɨs siya siir boɨnki, nomiiyau, dimɨnɨn kɨra mɨnam nɨtɨn mɨ siirɨn ha mɨnsasau. Sɨma ɨna yɨtɨm mɨ sɨmiir ɨɨnɨm Jisɨs siir inɨ onkworɨmdɨɨnuni. ");
INSERT INTO iws_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Inkam nwɨrɨn Jisɨs saɨka nwokɨn mɨ siir kamkɨuɨn ɨna kiwok haiyɨn. Mɨ prismi bɨiyan inkamɨn siir mɨiyan inkam nwɨrɨn siir wɨɨn aiir yakɨ haɨngrɨp ɨtkigi. ");
INSERT INTO iws_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jisɨs siya siir boɨnki, kɨriir kamkɨuɨn siir maeyau aiirar swokɨ hopkrɨkɨugi. Kam biyɨe whɨekakɨm sɨma kamkɨu ɨmiir hainanii yaii nɨniiyɨm mɨ wɨ yamdi kwɨruwa sɨma sɨma haɨnuwɨɨr wɨɨr haigɨnɨuwi ");
INSERT INTO iws_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Panopi kɨra ɨna nɨnoknɨnkɨnɨn, kara kariir Adɨn siirɨm srɨikɨso dɨga pɨ ywowɨn mɨ di kɨmɨmɨnki siir paekwosɨmɨm kariiramɨn kasa kasa di nɨkropki kariir whɨnkɨnsiisɨm. Inkam sɨmiir mwɨanɨm dɨg rani. ");
INSERT INTO iws_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mɨ kara hɨriinan tɨri mɨ tɨ dimɨnɨm bɨiya Ywokwo Komii saeya boɨnɨm sɨma wɨ paɨnɨɨna nɨmbiyami, ha? Adi Komii siya bɨdi boɨnɨn tɨ dimɨnɨm sɨma wa nɨmbiyami. ");
INSERT INTO iws_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Mɨ ta ɨi aiirɨn Jisɨs siya tɨ kam isid ɨiirar boɨnki, kɨma kariir unɨ onkworɨmdɨɨnu haini mɨ kɨma wasi kamkɨu dan mɨnɨm sɨmiirar nonkwowɨm, inkam nwɨrɨn hɨi tauaeiyɨn siir hɨriinan, aniya? Ɨinokɨinokɨn kara Adi Komii siir omaka iikam sɨmiir nowomwarkaiyɨuwiyɨn mɨ kɨma kariirɨn saiirar bɨ nonkworɨmdɨɨnugɨn. ");
INSERT INTO iws_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tɨ dimɨn taemɨn whɨekakɨm nɨmbiyamɨm profet kamɨm sɨma wɨnboɨnkiyɨm yokwoni sɨmaɨrgɨm. Mɨ kam whɨekakɨm siir kɨgna mɨriiyɨm sɨma Jisɨs siir haiburgik mɨ ɨna yɨdamkiyɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Sɨma kamɨm Jisɨs siir yonkworɨmdɨɨnu mɨ sɨma prismi bɨiyan inkam komiiyɨn Kaiafas siir omaka saiir hɨriir hainam mɨ kam whɨekakɨm siir haiburgigɨm mɨ kamɨm siyɨu nɨnoknɨnkɨni ɨkɨm mɨ Isrelmi inkam komii ɨkɨm sɨma sɨma nwomɨmɨrkɨm hapaiirɨn. ");
INSERT INTO iws_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita siya siir mhoɨiyar yam mɨ siya arurɨg hɨrar inɨ owou. Mɨ siya prismi bɨiyan inkam komiiyɨn siir omaka maeyauwa hɨuyokyokaiya saiir yapnɨnopkainam mɨ kamɨm yaii nɨniiyɨm ta maeyau aiir kɨgrɨraowiyɨm sɨmaka inɨ ɨdwoɨu. Mɨ siya kɨg nɨnoknɨnkɨnam namkɨn, pɨ dimu dimɨnkɨn nɨmbiyami. ");
INSERT INTO iws_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Prismi bɨiyan inkamɨm mɨ Judami inkam komii kaunsil ɨkɨm sɨma ɨna haɨnsɨrɨm inkamɨn Jisɨs siir nɨksɨsae boɨn hɨuriiyɨuɨm mɨ sɨma siir kɨgi mɨ wa nwokɨ ɨsomaowɨm. ");
INSERT INTO iws_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Mɨ kam whɨekakɨm ha nɨmbiniyɨm mɨ nɨksɨsae yaiyɨm sɨma sɨma inɨ apkaina boɨni siirɨn. Mɨ sɨma siirɨn dimɨn biyɨe whɨr bɨ swokɨ haɨnsɨr yɨskaigɨm siir nɨsomaowɨm mɨ mhoɨiya inkam nwɨswo ɨna yɨmbiniyo. ");
INSERT INTO iws_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Mɨ sowa ɨna yaboɨniyo, tɨ inkamɨn siya ha boɨnkɨn mɨ siya Adi Komii siir omaka komiiya saiirɨn wa nɨinɨnkɨigi mɨ siya saiirɨn wɨ ɨi kwoɨmuwar swokɨ mɨrii nɨnokougi. ");
INSERT INTO iws_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mɨ prismi bɨiyan inkam komiiyɨn siya siir yokwao boɨnki, kɨra yai kwɨr nowarki boɨnam naɨngwo rani, aniya? Tɨ hɨriinan yaiyɨm sɨma kɨriir dimusi boɨnɨuriyɨuwi, ha? ");
INSERT INTO iws_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mɨ Jisɨs siya yai bɨ swokɨ boɨn mɨmɨnkɨn mɨ prismi bɨiyan inkam komiiyɨn siya siir boɨnki, kara kɨriirɨn Adi Komiiyɨn omwai waiya yokiyokɨiyɨn siir inɨgɨn siir nɨkwao boɨnki! Kɨra krɨmiir boɨnmauugi kɨra Kraiskɨn inkamɨn Adi Komii siya nɨkropkiyɨn, aniya? ");
INSERT INTO iws_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jisɨs siya prismi bɨiyan inkam komiiyɨn siir boɨnki, kɨra bɨdiya boɨnkiyɨn. Mɨ kara kɨmiirɨn pɨ hɨnɨɨna boɨnki, mhoɨiya wɨ kɨma kɨgi, kara Yaowae Adɨn nɨnomor kouankɨn nɨtɨn kara wɨ Adi Komii siir ɨɨna ɨɨniga saiir nɨdwowi mɨ kara wɨ kɨrɨe whɨekakar nwowi. Mhoɨiya kara swokɨ ɨti kara wɨ nɨnomor kou hɨran waumɨra wɨ saɨka nɨnkɨn onaiini kɨrɨe komiigak. ");
INSERT INTO iws_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jisɨs siya hɨriinan yai boɨnkiyɨn mɨ prismi bɨiyan inkam komiiyɨn siir yɨuɨsa ɨna yɨinɨkiwɨtkiyɨn siya iikamɨm sɨmiir nɨisiimauugɨn siya ɨokakɨn mɨ siya ɨna boɨnɨn. Siya Adi Komii siir yai aiir nɨgbumbu boɨnkɨn mɨ krɨma kam nhɨrɨm whɨnboɨnam kɨpi swokɨ ɨkɨuna kɨma bɨdi wakaeyɨm siya nɨgbumbuwa Adi Komii siir. ");
INSERT INTO iws_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kɨma panɨɨna naɨngwowi, ha? Mɨ sɨma siir yai aka hɨnɨɨna yowarkɨi boɨn siya yaigakɨn mɨ siya hɨriiyar daonam. ");
INSERT INTO iws_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Mɨ sɨma tɨ yai ɨmiir boɨn dɨgiyɨm sɨma Jisɨs siir whwonkam ɨiirɨn yaeyopni yaskɨnpapaki mɨ sɨma siir yɨbwambwaeki mɨ kam nhɨrɨm sɨma yɨuɨsa siir whwonkam ɨiir kikogrɨnugi mɨ sɨma siirɨn ɨna yobombwaeyɨn. ");
INSERT INTO iws_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Mɨ sɨma boɨnki mɨ kɨra Kraiskɨ nɨuwi, inkamɨn Adi Komii siya nɨkropkiyɨn Mɨ kɨra profet yai krɨmiir boɨnki, kɨriirɨn nhɨnga tɨowi, ha? Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita siya hiira omaka saiir hɨuyokiyokaiya saiir yainau hɨrar nɨdwokɨn. Mɨ mɨiyan wig ɨra saeya kingiin ha nɨta siir kɨgam mɨ saeya siir boɨn. Kɨra ɨriipa hɨriinan Jisɨsɨn nu Galilianɨn saɨka warar nwokɨn. ");
INSERT INTO iws_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mɨ Pita siya kam whɨekakɨm sɨmiir whwonkamɨda kɨntɨɨrgi, kara warɨ yaiya kɨra boɨna saiir nɨnoknɨnkɨn tani. ");
INSERT INTO iws_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Mɨ Pita siya yaba ha namɨn mɨ siya aru hɨr yanɨ ɨdwowɨu ano kingiin hɨr. Mɨ wig ɨra saeya siir kɨga mɨ saeya iikamɨm siir kingiin nwowɨn sɨmiirɨn hɨnɨɨna boɨnki, tɨ inkamɨn siya Jisɨsɨn om Nasaretanɨn saɨka warar nɨnkɨn okɨn. ");
INSERT INTO iws_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Mɨ Pita siya ɨna swokɨ kɨntɨɨr boɨnkiyɨn, kara Adi Komii siir inɨg ɨiirar nɨkopaisɨsɨrki, kara tɨ inkam ɨiir bɨ nɨnoknɨnkɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mɨ mhoɨiyarɨn kam nhɨrɨm hɨrar nokwokɨm, sɨma Pita siir boɨnki, kaimwokɨ kaimwokɨɨnga kɨra Jisɨs siir isidɨn siir hɨriinanar inkam nwɨrkɨn kɨriir yaiya sɨmiir yainana wakaei. ");
INSERT INTO iws_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mɨ tariinanɨn Pita siya ɨna yɨkopaisɨsɨrkiyɨn, kaimwokɨ kaimwokɨɨnga. Kara tɨ inkamɨn siir bɨ nɨnoknɨnkɨnkɨn. Nɨɨngakɨ, nɨɨngakɨɨnga. Mɨ kariir yaiya kaimwo karamaekɨ nɨuwi mɨ Adi Komii siya kariirɨn hɨk pa hauuwi hɨriinan yai boɨnkiyɨn mɨ ɨuumɨn ɨna yɨkiyɨn. ");
INSERT INTO iws_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ɨuumɨn nɨk dɨgiyɨn mɨ Pita siya yaiya Jisɨs siya boɨna ɨni saiirar swokɨ aɨngwowarkainakiyɨn mɨ ɨuumɨn wɨ nikɨ ɨkrani mɨ kɨra kariir inɨg ɨiirɨn wɨ kwoɨma mɨisɨsaei, kara siir bɨ nɨnoknɨnkɨnkɨn mɨ Pita siya yaba hɨriir namɨn mɨ ɨna yani ouwouwɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ɨiya pɨrkɨnyakwoka mɨ prismi bɨiyan inkam whɨekak ɨkɨm. Mɨ Isrel sɨmiir isidɨm sɨmiir hɨran inkam komii komii ɨkɨm sɨma yaiyɨm ɨna yɨdwo kitɨbmii boɨnɨm, Jisɨs siir nɨsomaowam. ");
INSERT INTO iws_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mɨ sɨma siirɨn wɨeyɨnsopni yomboru mɨ sɨma siirɨn ɨna kiwowɨtnamɨm mɨ sɨmiir bɨiyan inkam komiiyɨn nu Romanɨn Pailat, inkam komiiyɨn nu Judia hɨran omɨm sɨmiir kɨgrɨraowiyɨn siir inɨ hauugik. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Mɨ tariinanɨn Judas siya inkamɨn Jisɨs siir kɨnmauu ɨtɨn, sauan kamɨm sɨmiir, siya bɨdi yɨnoknɨnkɨnɨn, inkam komiiyɨm sɨma Jisɨs siir hainamɨm inkam komii Pailat siirɨm siya nɨsomaowɨm mɨ siya naɨngwoyɨmyok ɨdid prasae bɨ kɨnkɨn, tɨ dimɨnɨn siya tɨrɨn siirsiyɨn. Mɨ siya tɨ umɨr silva paeyar haoumɨm ɨna swokɨ hainamɨn, prismi bɨiyan inkamɨm sɨmiiram. ");
INSERT INTO iws_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Mɨ siya umɨr ha swokɨ hauuwɨn. Mɨ siya sɨmiir boɨnki, kara dimɨn biyɨe bɨdi tɨrɨn. Kara inkamɨn dimɨn biyɨe tɨr karamae nwowiyɨn siirɨn, sau omomɨn siir kɨnmauugɨn mɨ siya wa naonami. Mɨ sɨma siir boɨnki, siya krɨmiir dimɨn tani. Yɨo siya kɨriirar dimɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Mɨ Judas siya umɨr silvaɨm Adi Komii siir omaka komiiya yai nɨdwokai wakaeiya saiir hɨr inankrɨmkrɨn ɨtkɨngikɨn mɨ siya ha haiburgikɨn mɨ ha namɨn mɨ yɨo ɨna sasar diyankrɨkɨu aonamɨn. ");
INSERT INTO iws_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Prismi bɨiyan inkamɨm sɨma tɨ umɨr ɨmiir haiyɨm mɨ sɨma boɨn, tɨ umɨrɨn mɨnam saɨngɨn inkam nwɨr nɨsomaowankɨn. Krɨmiir siyɨuɨn hɨnɨɨna boɨnkɨn Krɨma Adi Komii siir omaka saiir umɨrɨn sɨmaka kɨpi nɨnkɨn haigi. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Mɨ sɨma yai kwɨra yɨmboɨn tɨbmiikimai mɨ tɨ umɨrɨn ɨni nu haɨmiiyɨn Jerusalem hɨr nwowɨn hau nonkwokwowiyɨn inkamɨn ɨni siir saɨnɨn. Sɨma ha naɨngwowi ta nu maeyaua iikamɨm om aruwanɨm sɨmiir haɨngikaiyan maeyau nwowɨm ");
INSERT INTO iws_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","mɨ tɨ nuɨn tɨ umɨr ɨiir saɨnɨn mɨ sɨma ta nu maeyaua saiir inɨgɨn hɨriinansi dapkɨn, nuɨn nhɨekakɨn. Mɨ tɨ inɨgɨn ɨna nwokrɨpkaiyɨn. ");
INSERT INTO iws_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ya ta saeya, yai kwɨra bɨiya Adi Komii siya boɨnkiya mɨ profet Jeremaia siya wɨnkiya yokwoni, saeya ɨna yɨmbiyam kɨɨna. Saeya boɨn, sɨma tɨ umɨr silva kam nwɨr ɨuur ɨmiir hai. Isrel sɨmiir iikamɨm sɨma bɨdi yɨmbinɨm tɨ umɨr hɨriinanɨm tɨ inkam ɨiir saɨnam. ");
INSERT INTO iws_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Tɨ umɨrɨn sɨma ɨni nuɨn inkam ɨeya nonkwokwowiyɨn hau, ɨni siir saɨnɨn, Bɨiyan Inkam Komiiyɨn siya boɨnkiyɨn kariir saiir hɨriinan mɨ kara hɨriinan asi tɨrkɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Sɨma Jisɨs siirɨn inkamɨn nu Judian omom omomɨm sɨmiir kɨgrɨraowiyɨn siir whwonkam ɨda yokmwɨn okwo haigɨnɨu. Mɨ inkam komiiyɨn omom omom kɨgrɨraowiyɨn siya siir srɨigi, kɨra iikamɨm nu Judia hɨranɨm sɨmiir kɨgrɨraowan inkam komiigɨn, aniya? Mɨ Jisɨs siya boɨn, ɨhɨ, wasi kɨra boɨnki ɨskiyɨn. ");
INSERT INTO iws_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mɨ prismi bɨiyan inkamɨm mɨ Isrelmi inkam komii komii ɨkɨm, sɨma Jisɨs siir boɨn hɨuriyɨu boɨnkɨm, siya dimɨn biyɨe kasaka bɨ tɨrkɨn. Mɨ siya dimɨn biyɨe bɨ tɨrkɨn mɨ siya yai kwɨrmɨn kwɨrmɨn bɨ swokɨ owarkɨi boɨnkɨn, tɨ yai ɨmiirɨn. ");
INSERT INTO iws_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mɨ Pailat siya siirɨn hɨnɨɨna boɨnki, kɨra tɨ yai whɨekakɨm sɨma kɨriir boɨn hɨuriyɨu boɨnɨm sɨmiir wakae rani, aniya? ");
INSERT INTO iws_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mɨ Jisɨs siya yai kwɨr bɨ swokɨ owarkɨi boɨnkɨn Pailat siirɨn. Mɨ inkam komiiyɨn omomom kɨgrɨraowiyɨn siya asi nanaakikɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bɨewi whɨekakɨm ta ɨiya komiiya wou nikwo aeiya pasova mɨ bɨiyan inkam komiiyɨn omom omomɨm sɨm kɨgrɨraowiyɨn siya inkamɨn omaka hɨuyokiyokaiya mɨi biyɨe mɨriiya saiir hɨr nwowiyɨm, sɨmiirɨn pɨ nwɨra ninɨ ɨkɨunaki. Iikamɨm sɨma kauwokiyɨm inkam nwɨramɨn mɨ inkam komiiyɨn siya tɨ inkamɨn pɨ siirar nɨkropki. ");
INSERT INTO iws_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mɨ ta ɨi aiirɨn sɨma inkam biyɨe nwɨrɨn omaka hɨuyokiyokaiya mɨi biyɨe mɨriiya saiir hɨr nwokɨn, siir inɨgɨn Barabaskɨn, sɨma ombudɨm siir bɨdi yɨnoknɨnkɨnɨm. ");
INSERT INTO iws_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Mɨ ɨiya iikamɨm sɨma maeyau kwɨruwa hangiriyɨu omɨmɨrɨm mɨ Pailat siya sɨmiir srɨigi, kɨma panɨɨna naɨngwowi, kara kɨmiirɨmɨn pɨkɨ hɨnɨɨn inkamɨn siir haiwao hauugi, ha? Kara Barabas siir pɨ ɨkropki, aniya? Iyɨe, kara Jisɨs siir nɨkropki sɨma dapiyɨn Krais inkamɨn Adi Komii siya nɨkropkiyɨn, aniya? ");
INSERT INTO iws_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat siya bɨdi yɨnoknɨnkɨnɨn, prismi bɨiyan kamɨm mɨ Isrelmi inkam komii komiiyɨm sɨma ɨo Jisɨs siir nwowi. Dimusi rani, iikamɨm sɨma ɨni Jisɨs siiraramar yamɨm. Mɨ sɨma siirɨn Pailat siiram asi nɨkɨunamkɨm siya siirɨn kam nhɨrɨm sɨmiir nwokɨ ɨkmwɨn ɨsom aowɨm. Mɨ siya ta srɨiya sɨmiir asi srɨigɨn. ");
INSERT INTO iws_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat siya inkamɨn yai hɨdiyɨn siir ipii aiirar nikɨ nɨdwokaiyɨn mɨ siir wiga saeya yaiyɨm hɨnɨɨna boɨnmɨmauugi yokwoni. Kɨra dimɨn whɨr kɨpi swokɨ tɨrmɨntɨrmɨn, tɨ inkam ɨiirɨn, siya dimɨn biyɨe bɨ tɨrkɨn. Mɨ ta nɨiyaka kara nhwoɨn whɨra whɨnkɨgmɨmɨkwɨi mɨ kara hɨk prasae bɨ haiga. ");
INSERT INTO iws_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Prismi bɨiyan inkamɨm mɨ Isrelmi inkam komii komii ɨkɨm sɨma iikamɨm sɨmiir kwoɨn ɨmiir boɨnswoswo. Mɨ sɨma Pailat siirɨm kauwok boɨnki. Siya Barabas siir dɨuguski mɨ Jisɨs siir dɨsomao. ");
INSERT INTO iws_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Mɨ inkam komiiyɨn omom omomɨm sɨmiir kɨgrɨraowiyɨn siya sɨmiir srɨigi. Kɨma panɨɨna naɨngwowi kara tɨ inkam nwɨswo sowiirɨn pɨ nhɨni nɨuguski, ha? Sɨma ɨna yowarkɨi boɨnɨm Barabas. ");
INSERT INTO iws_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Mɨ Pailat siya sɨmiir boɨnki, kara wɨ panɨɨna tɨri Jisɨs siirɨn, sɨma dapiyɨn Krais Adi Komii siya nɨkropkiyɨn kara siirɨn wɨ panɨɨna tɨri, ha? Mɨ sɨma kauwok boɨnki, paeyɨn hɨiniya nɨrɨonɨnkɨnɨn saɨka dɨrɨnugi! ");
INSERT INTO iws_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Mɨ Pailat siya ɨna srɨigiyɨn. Dimusika siya dimu dimɨn tɨrbugɨn, ha? Mɨ sɨma ɨna kauwoknanaeyɨm, paeyɨn hɨiniya nɨrɨonɨnkɨnɨn saɨka dɨrɨnugi! ");
INSERT INTO iws_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailat siya bɨdi yɨnoknɨnkɨnɨn, sɨma yaiyɨm kara boɨniyɨm sɨmiir wakaeyokna dɨg nwo rani mɨ ɨna nhɨnkii boɨnaigiyɨm yaii nɨniiyam. Mɨ siya opa ɨna haiyɨn mɨ siir ɨɨna aiir hɨisoki. Mɨ iikamɨm sɨmiir nhwowɨm ɨni siirar kaokiyɨm sɨmiir nɨisiimauugɨn, siya Jisɨs siir nɨsomaowam pɨ boriisopi. Mɨ siya hɨriinana nikɨ tɨrɨn mɨ siya sɨmiir boɨnki, kara siirɨn dimɨn whɨr bɨ kɨgɨn mɨ kara siirɨn wa nɨsomaoki rani. Kɨmiirar dimɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Mɨ iikam whɨekakɨm sɨma hɨnɨɨna yowarkɨi boɨn mɨ siir naowa saiir mwokankwowa ɨni mɨ owa wɨ krɨmiiramar swokɨ ɨti mɨ krɨmiir yɨnisɨsɨm ɨmiiram warar. Kɨra siir nɨsomaoki Adi Komii siya wɨ ɨo kɨriir nwo rani. ");
INSERT INTO iws_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Mɨ Pailat siya Barabas siirɨn hɨriinansi nɨuguskikɨn sɨmiiramɨn. Mɨ siya Jisɨs siirɨn kam nhɨrɨm sɨmiir yokmwɨn tɨo mɨ ɨdni ha kogrɨmdɨnugiyɨn mɨ siya siirɨn ɨna yɨkropkiyɨn Rom hɨran sauan kamɨm sɨmiiram. Paeya hɨiniya nɨrɨonɨnkɨnɨn saɨka nɨnkɨn ɨrɨnugiyam. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Mɨ sauan kamɨm Bɨiyan Inkam Komii siirɨm, sɨma Jisɨs siirɨn sɨmiir Bɨiyan Inkam Komiiyɨn siir omaka hɨriir yɨkɨuna apnɨnopkainam mɨ sɨma whɨekakɨm saɨkar yangiriyɨuni. ");
INSERT INTO iws_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Mɨ sɨma siir yɨuɨsa saiir nɨsaiyɨm mɨ sɨma siirɨn yaeya yɨuɨs pariidnan kwɨra saiir ii haigɨnɨu. Ta yɨuɨs hɨriinana inkam komii inɨgakɨn siira saiir nɨkrika. ");
INSERT INTO iws_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Mɨ sɨma urid amrɨdnanɨn siir hɨurokikɨn mɨ sɨma siir mwo ɨiir yakɨ kaigrɨsɨugi. Mɨ sɨma paekopɨn whɨra yonkwo haigɨnɨu siir ɨɨna ɨnig aiir inkam komii nu kɨgrɨraowiyɨn siir hɨriinan. Mɨ sɨma ogmwo siirɨm hɨu mɨ sɨma siir yɨgbumbu boɨn, kɨra inkam mɨiyɨkɨn, Juda iikamɨm sɨmiir nu kɨgrɨraowan inkam komiikɨn. ");
INSERT INTO iws_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Mɨ sɨma siir yaswaiyɨugi mɨ sɨma tɨ paekop ɨiir hai mɨ siir mwo ɨiir tɨonanae. ");
INSERT INTO iws_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Sɨma siir yɨgbumbu boɨn mɨ ta siir yɨuɨs pariidnan aiir yɨsaigi mɨ sɨma siir yɨuɨskɨ yɨuɨs aiirar ii haigɨnɨu. Mɨ sɨma siirɨn paeyɨn hɨiniya nɨrɨonɨnkɨniyɨn siirɨm whɨnapnam saɨka nɨnkɨn ɨrɨnuɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Sɨma ha napnamɨm mɨ sɨma om Sairini hɨran inkam nwɨrɨn siir kɨg, siir inɨgɨn Saimonkɨn, sɨma siir nɨkwao boɨnkɨm siya Jisɨs siir paeyɨn hɨiniya nɨrɨonɨnkɨnɨn siir hainamam. ");
INSERT INTO iws_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Sɨma maeyau kwɨra saiir yɨmbiyam, saiir inɨgɨn Golgotaka saiir inɨg mwokɨmwoɨn hɨnɨɨngɨn mwokɨuni mwokɨn. ");
INSERT INTO iws_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Sɨma Jisɨs siirɨn op wain biyɨeya kausrɨriya dimɨn biyɨe whɨr aka prɨdgiya saiir hauu, siya kwiyaeyam siya hinda kɨnankɨugiyɨn mɨ siya bɨ kwiyaekɨn. ");
INSERT INTO iws_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sɨma siirɨn paeyɨn hɨiniya nɨrɨonɨnkɨnɨn saɨka nɨrɨnu dɨgiyɨn mɨ sɨma gwo kwɨra satu dapiya saiir gwo siir yɨuɨs digworaekwo ɨmiir haiyam. ");
INSERT INTO iws_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Mɨ sɨma ta maeyaua saiira yɨdwo mɨ sɨma saiir hɨrar waikao. ");
INSERT INTO iws_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Mɨ yaiya sɨma wɨna paemɨra Jisɨs siir mwo koua nɨnkɨn ɨrɨnuwa saeya hɨnɨɨna boɨnka. Tɨriigɨnɨn Jisɨskɨn, Juda iikam sɨmiir nu kɨgrɨraowan inkamkɨn. ");
INSERT INTO iws_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jisɨs siir kingiinɨn sɨma inkamwo hɨitauaeiyo nwɨsa yɨnkɨn ɨrɨnu inankɨi mɨ nwɨrɨn ɨniga mɨ nwɨrɨn yaɨoyaeya. ");
INSERT INTO iws_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Mɨ iikamɨm sɨma ha nɨtɨm mɨ sɨma siir yɨgbumbu boɨn mɨ sɨma mwo ara kɨntɨɨr ɨski mɨ sɨma yaebu ɨna buwɨm siirɨn. ");
INSERT INTO iws_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Mɨ sɨma boɨn, kɨra tɨ inkamɨn Adi Komiini omaka saiir nɨinhɨnkɨigi mɨ ɨi kwoɨmaka wɨ saiir swokɨ mɨrii nɨnokougi mɨ kɨnakɨna dirɨraerarna. Mɨ kɨra Adi Komii siir yɨnisɨmkɨnɨuwi, kɨra paeyɨn hɨiniya nɨrɨonɨnkɨnɨn siir haiburgig mɨ ha wɨuwini! ");
INSERT INTO iws_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mɨ ɨriipa hɨriinan prismi bɨiyan inkamɨm mɨ kamɨm siyɨu nɨnoknɨnkɨni ɨkɨm mɨ Isrelmi inkam komii komiiyɨm sɨma siir mɨ ɨnkɨn ɨgbumbu boɨnkɨm. ");
INSERT INTO iws_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Mɨ sɨma hɨnɨɨna boɨn, siya iikam nhɨrɨm sɨmiirara whɨndirɨraeri mɨ siya siya whɨndirɨraerarnam dɨg nwo rani. Mɨ siya hɨriinan boɨni siya Isrel iikamɨm sɨmiir nu kɨgrɨraowan inkamkɨnɨuwi mɨ siya paeyɨn hɨiniya nɨrɨonɨnkɨnɨn siir haiburgig mɨ ha wɨuuni mɨ krɨma wɨ siirɨma naɨngwo tɨbmiiyɨm. ");
INSERT INTO iws_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Siya Adi Komii siirɨma naɨngwo tɨbmii mɨ ha boɨni, kara Adi Komii siir yɨnisɨmkɨ yɨnisɨmkɨn. Mɨ Adi Komii siya siirɨm naɨngwowi mɨ siya wɨ siirar swokɨ anmaiwarkainaei. ");
INSERT INTO iws_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Inkam nwɨswo hɨitauaeywo Jisɨs saɨka kingiina nɨnkɨn ɨrɨnuwo mɨ sowa ɨriipa hɨriinan ta hɨriinan nɨgbumbu yaiya saiirara mɨ boɨn siirɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mɨ ɨiya hɨriir tɨriir nabɨe bopwo nwowa mɨ hɨnda tɨnda ɨiya ɨna kakauu ɨuguskiya mɨ hɨriinana nwokiya mɨ bɨeyɨn nad nworɨbɨn saiirar yadɨg ɨuwɨn. ");
INSERT INTO iws_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Mɨ ta ɨi aiirarɨn bɨeyɨn nad nworɨbɨn Jisɨs siya ɨna kauwoknamnankiyɨn, Eli, Eli, lema sabaktani? Ta yaiya saiir yaimwokɨyaimwowa hɨnɨɨnga. Kariir Adi Komii krɨmiir Wanɨn kɨra kariir dimusi nɨuguskikɨn? ");
INSERT INTO iws_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kam nhɨrɨm kingiin hɨrar nokwoɨm sɨma ta yai aiir wakaeyɨm mɨ sɨma boɨnki, tɨ inkamɨn siya Ilaija siirɨm kauwok boɨnki. ");
INSERT INTO iws_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mɨ sɨmiir inkam nwɨrɨn ɨna iwɨtnamɨn mɨ hamganɨn siir yani hainaki mɨ siirɨn op waina kausrɨriya saiir hougɨnki paekop whɨrɨn saɨka yɨnkɨn widgi mɨ Jisɨs siir yakɨ hauugi siya kwiyaeyam. ");
INSERT INTO iws_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Mɨ iikam nhɨrɨm sɨma boɨn, ha tikɨ o krɨma tikɨ kɨgrɨrao. Mɨ siirɨn wɨ Ilaija siya namisi whɨndirɨraerarki, iyɨe? ");
INSERT INTO iws_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Mɨ Jisɨs siya ɨna swokɨ kauwok nanaekiyɨn mɨ siir naeyɨuɨn siir haiburgigɨn mɨ siya ɨna yaonamɨn. ");
INSERT INTO iws_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Mɨ ɨiya siya naonamɨn mɨ ta yɨuɨs komiiya Adi Komii siir omaka saiir yainau hɨr kiburɨkouwa bopwoniya yɨnwɨtamki, kou hɨrarkar nɨuguskiya ɨni nu hɨrar yadɨgɨuwa mɨ mɨrkwɨsa yɨmbiyam. Saeya mɨnam nɨisiimauuga, iikamɨm sɨma Adi Komii siiram nwokɨ kwɨsboɨnɨm, Jisɨs siya siyɨu wɨn bɨdi tɨrkiyɨn inkamɨm sɨma Jisɨs siirɨm nwokɨ kwɨsboɨnɨm, nɨɨnɨn ɨna yɨtkiyɨn mɨ siiya komii komiiyɨm ɨna pampamkɨigiyɨm. ");
INSERT INTO iws_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mɨ maeyaua inkam haɨngikaiiya ɨna pɨigikiya mɨ Adi Komii siir iikam whɨekakɨm bɨiya naonamɨm mɨ sɨma ɨna swokɨ ɨnsiingiyɨm. ");
INSERT INTO iws_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Sɨma maeyaua inkam haɨngikaiiya saiir bɨdi haiburgigɨm mɨ Jisɨs siya mhoɨiya yɨnsiinɨdwonam mɨ sɨma om mɨiyɨkɨn Jerusalem siir yam. Mɨ iikam whɨekakɨm sɨmiirar kaowɨnɨm. ");
INSERT INTO iws_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mɨ kamɨm sau nɨnɨtiyɨm sɨmiir bɨi nwowiyɨn mɨ sauan kam ɨma sɨma Jisɨs saɨka nɨnkɨn okɨm mɨ sɨma Jisɨs siiram waigaokɨm mɨ sɨma kɨgi nuɨn, nɨɨnɨn nɨtkiyɨn mɨ digworaekwowɨm ɨna yɨmbiyamɨm mɨ sɨma nɨdid prasae bɨ kɨnkɨm. Sɨma boɨn, kaimwokɨ kaimwokɨɨnga, tɨ inkamɨn siya Adi Komii siirar yɨnisɨmkɨn. ");
INSERT INTO iws_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Wig whɨekakɨm sɨma hɨrar nwokɨm sɨma Jisɨs siir mhoɨiya nɨtkɨm mɨ nu Galili siir haiburgigɨm mɨ siir ninɨ whɨndirɨraerarniyam nɨtkɨm naemɨn. Sɨma tɨ wigɨm arurɨg hɨrar nokwo kaokɨm. ");
INSERT INTO iws_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Wig ɨra sɨmaka hɨrar nɨnkɨn owa saeya Mariaka, om Makdala hɨranka. Mɨ ɨra Maria saeyaɨrga Jems Josep sowiir apua. Mɨ ɨra Sebedi siir yɨnisɨm nwɨso Jems Jon sowiir apua saeyaɨrga. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mɨ bɨeyɨn nadnworɨbɨn inkam nwɨrɨn umɨr digworaekwokakɨn om Arimatiankɨn siir inɨgɨn Josepkɨn siya ɨna yɨtɨn. Mɨ siya ɨriipɨ hɨriinan Jisɨs siir kɨgna mɨriiyan inkamkɨn, siya maeyaua Jisɨs siya naowa saiirɨm nɨtkɨn. ");
INSERT INTO iws_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Mɨ siya Pailat siir hɨriir yɨmbiyam mɨ siir inɨ srɨiyɨu Jisɨs siir pɨuɨs biyɨe nɨɨnga saiiram mɨ siya saiir inɨ hɨunɨs haiyɨu. Mɨ Pailat siya siir sauan kamɨm sɨmiir boɨnki, sɨma Jisɨs siir pɨuɨs biyɨeya Josep siir hɨunɨs hauugiyɨm. ");
INSERT INTO iws_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Mɨ Josep siya siir pɨuɨs biyɨeya saiir hɨunɨs haiyɨn mɨ yɨuɨs whɨsinana saiir whrɨnhainam. ");
INSERT INTO iws_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Mɨ yɨuɨs aiirɨn ha whrɨn dɨgiyɨn siya siir pɨuɨs biyɨeya ɨni siir siyano wɨnɨn siirar kikaigikɨn bɨiya inkam nwɨr bɨ haɨngikai mɨmɨnkɨn mɨ siya siir kamɨm sɨmiir boɨnki, sɨma siiya komii kwɨra saiir warkɨkɨugiyɨm. Mɨ sɨma hɨriinan tɨrgigɨm mɨ sɨma ɨna yamɨm. ");
INSERT INTO iws_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mɨ sɨma hɨriinan tɨrɨm mɨ Maria om Makdalan aka mɨ Maria ɨraka sowa hɨrar nwoko. Sowa ɨeyɨn siir haɨngikaiyɨn siir kingiin hɨrar nɨdwo kaoko, Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mɨ ɨigwɨra Judami ɨi komiiya pɨu siisiya dimɨn taemɨn tɨr karamae nwowiya mɨ prismi bɨiyan inkam ɨkɨm mɨ Farisimi kam ɨkɨm sɨma Pailat siir kɨgam namkɨm mɨ sɨma saɨka yahangiriyɨu omɨmɨrɨu. ");
INSERT INTO iws_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Sɨma siir boɨnki. Inkam komii krɨma yai kwɨra tɨ nɨksɨsae inkamɨn siya boɨna krɨma saiirar naɨngwokwowi. Siya ha boɨnkɨn mɨ mhoɨiya ɨi kwoɨmaka kara wa swokɨ ɨnsiin ɨdwowi. Mɨ wɨ omwaiya swokɨ waiyaei. ");
INSERT INTO iws_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Mɨ kɨra kɨriir sauan kamɨm sɨmiirɨn hɨnɨɨna boɨn mɨ sɨma siiyan tɨ ɨeyɨn siir no ɨiir warkɨkɨukikɨnɨn siir waikao. Mɨ wɨ siir kɨgna mɨriiyɨm kamɨm sɨma ninɨ tauae hainakisi mɨ iikamɨm wɨ sɨma nɨksɨsae boɨni, siya ɨe hɨrankɨn bɨdi yɨnsiin ɨdwonamɨn. Mɨ sɨma hɨriinan tɨri, ta nɨksɨsaeya siya ɨe hɨrankɨ nɨnsiin ɨdwowa saeya wɨ ta nɨksɨsaeya bɨiya sɨma tɨ inkamɨn Adi Komii siya nɨkropkiyɨn siya boɨna wɨ saiir haiburi. ");
INSERT INTO iws_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailat siya sɨmiir boɨnki, kɨma sauan kam nhɨrɨm sɨmiir dɨkɨunam sɨma tɨ inkam ɨe ɨiir waikaowɨm. ");
INSERT INTO iws_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Mɨ sɨma ɨe ɨiirɨn diyɨoɨn ɨna inɨ haigɨngikɨn. Mɨ kam nhɨrɨm sau nɨnɨtiyɨm ɨni nɨi nabɨe hɨrar waigaowɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ɨi Komiiya pɨu siisiya bɨdi yamkiya mɨ ɨigwɨr nugaka Sande bɨeyɨn ha nɨmbidniyakwokɨn mɨ Maria om Makdalana mɨ Maria ɨr aka sowa yam maeyauwa Jisɨs siir pɨuɨs biyɨe aiir kikaiya saiiram sowa saiir kɨgnakiyam. ");
INSERT INTO iws_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Mɨ bɨ kɨmɨmɨnkikɨn nɨɨn komiiyɨn ɨna yɨtkiyɨn Adi Komii siir paekwosɨmɨn nɨnomor kou hɨr haiburgigɨn mɨ ɨna yɨuniyɨn mɨ siiya komiiyɨn ɨna warnamɨn mɨ ɨeyɨn siir hɨrankɨn mɨ siya ɨni siiya ɨiirar yɨdwowɨn. ");
INSERT INTO iws_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mɨ siir whwonkamɨn ɨni sinana nɨnomɨr kou hɨr sinaniya ɨni saiir hɨriinan yɨuyakiya mɨ siir yɨuɨsa ɨni waumɨra bɨekɨ kainankiya ɨni saiir hɨriinan whɨsnan siingiya. ");
INSERT INTO iws_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Mɨ sauan kamɨm waigaowɨm sɨma siirsiyɨn nɨdid prasae bɨ kɨnkɨm mɨ sɨma ɨni nopnopa kɨnkiyɨm mɨ sɨma inkamɨn naonamiyɨn ɨni siir hɨriinan ywokiyɨm. ");
INSERT INTO iws_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mɨ paekwosɨmɨn siya wig ɨswo sowiir boɨnmauugi. Kowa kɨpi nɨdid! Kara ɨna nɨnoknɨnkɨnɨn, kowa Jisɨs siirɨm ninɨ hansɨrniko tɨ inkamɨn paeyɨn hɨiniya nɨrɨonɨnkɨnɨn sɨma nɨnkɨn ɨrɨnugiyɨn siirɨm. ");
INSERT INTO iws_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Siya tapi nwo rani, siya bɨdi yɨnsiin ɨdwo namɨn, yaiya bɨiya siya boɨna ɨni saiir hɨriinana swokɨ tɨrɨn! Kowa maeyauwa siir kikaiya saiir unkɨnɨ kɨgni. ");
INSERT INTO iws_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Mɨ kowa ha damsasau mɨ kamɨm siir kɨgna mɨriiyɨm sɨmiirɨn hɨnɨɨna tinɨ boɨnmauuɨu, siya ɨe hɨrankɨ bɨdi swokɨ ɨnsiin ɨdwoɨn. Mɨ siya ɨni kɨmiir bɨiyar yamkwokɨnɨn nu Galili hɨriir mɨ kɨma siirɨn wɨ ta maeyau aiir ninɨ kɨgɨuwi. Kara kowiirɨn tɨsa boɨnkiyɨn! ");
INSERT INTO iws_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Mɨ wig ɨswo ha nanaakiyo mɨ ɨni maɨrgɨmaɨrga ywonamwo mɨ maeyauwa inkam haɨngikaiiya saiir haiburgik mɨ ɨna iwɨtnamwo kamɨm siir kɨgna mɨriiyɨm sɨmiiram. ");
INSERT INTO iws_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mɨ sowa ha nikɨ iwɨtamwo mɨ Jisɨs siya sowirɨn siyɨu hɨr yapyɨskaiwɨn mɨ ɨna boɨnɨn. Kowa bɨdi yɨto? Mɨ sowa kingiin ha namwo mɨ ogmwo ɨna yakai hɨunaiinamwo mɨ siir ɨga aiir inɨ onkwoɨu mɨ siir inɨ hainan. ");
INSERT INTO iws_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jisɨs siya sowiir boɨnki, kowa kɨpi nɨdid! Kowa kariir nomiiyauɨm sɨmiir tinɨ boɨnmauuɨu mɨ sɨma nu Galili hɨriir dam, kariir kɨgniyɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wig ɨswo ha nikɨ amwo mɨ sauan kam nhɨrɨm ɨe ɨiir waikaowɨm sɨma ɨni om Komii Jerusalem hɨriir yapnɨnopkainamɨm mɨ sɨma prismi bɨiyan kamɨm sɨmiir inɨ boɨnɨu digworaekwo whɨekakɨm nɨmbiyamɨm sɨmiir. ");
INSERT INTO iws_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Mɨ prismi bɨiyan kamɨm sɨma Isrel sɨmiir bɨiyan inkamɨm sɨmaka yahangiriyɨu owɨu mɨ sɨma yaiya kwɨra hangiriyɨu boɨnai. Sɨma umɨr whɨekakɨm sauan kamɨm sɨmiir hauugi. ");
INSERT INTO iws_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Mɨ sɨma sɨmiir boɨnki, kɨma wɨ hɨnɨɨn yaiya saiir boɨn. Kamɨm siir kɨgna mɨriiyɨm sɨma nɨiyaka nɨtwɨigɨm mɨ krɨma nhwo bɨdi whɨnamɨm mɨ sɨma siir pɨuɨs biyɨeya saiir inɨ tauae hainakiwɨi. ");
INSERT INTO iws_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mɨ Bɨiyan Inkam Komiiyɨn omom omom kɨgrɨraowiyɨm ta yaiya saiir wakaeyɨn mɨ krɨma yai nhɨrɨm sɨmiirɨn wara swokɨ ɨnkɨn boɨnmauugi mɨ kɨma wɨ yaigak nwo rani. ");
INSERT INTO iws_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Mɨ sauan kamɨm sɨma umɨr hɨriinansi haigɨm mɨ sɨma ɨni sɨmiir yai ɨmiirar mɨ wakaeyoknaɨm. Mɨ ta yaiya ɨni nu Judia siirar yɨniyokɨigiya mɨ bɨiya mɨ tariinanɨm Juda iikam whɨekakɨm sɨma tɨ dimɨnɨm sɨmiir yaɨngwo tɨbmiiyɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Mɨ wig ɨswo sowa sɨmiir boɨn dɨgiywo, kamɨm siir kɨgna mɨriiyɨm ɨuur nwɨrkɨm sɨma nu Galili hɨriir yapnamɨm. Mɨ sɨma tɨ mhɨuisɨmɨn siir yɨmbiyam, Jisɨs siya boɨnkiyɨn sɨmasɨma namam. ");
INSERT INTO iws_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mɨ sɨma Jisɨs siir kɨgɨuwɨm mɨ sɨma siir inɨg ɨiir hainan mɨ kam nhɨrɨm sɨmiir kwoɨnɨm ɨni whɨsa ywowɨm. Mɨ ha naɨngwokɨm siya bɨ nɨnsiin ɨdwokɨn siir aknaɨn aeya nɨuwi. ");
INSERT INTO iws_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Mɨ Jisɨs siya kingiin ha nɨtɨn mɨ sɨmiirɨn hɨnɨɨna boɨnki Adi Komii siya kariirɨn inɨgak nu nɨnomor sowiir digworaekwo ɨmiiram nwowaigɨnɨugikɨn. ");
INSERT INTO iws_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kɨma hɨnda tɨnda asi namkɨm ɨkɨ iikam isid whɨekakɨm hɨnda tɨnda nwowɨm sɨmiir ninɨ boɨnmɨmauuwɨuɨm sɨma kariir kɨgna mɨriiyan iikam nwowɨm. Kɨma sɨmiirɨn kariir Adɨn mɨ kara Adi Komii siir yɨnisɨmɨn mɨ Adi Komii siir naeyɨu ɨkɨm wɨ sɨmiir inɨg ɨmiirar tinɨ baptais haigɨnɨuwɨu. ");
INSERT INTO iws_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mɨ kɨma sɨmiirɨn dimɨn whɨekakɨm kara kariir nowomwarkaiyɨuwɨm sɨmiir tinɨ boɨnmɨmauuɨu. Sɨma wakaeyokna dirɨraeraram, wakae, mɨ tariinan mɨ ɨinokɨinokɨn kara wɨ kɨmaka nwoyokiyokɨi mɨ ɨi aeya dɨgi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ta Yokwo Komiiya Adi Komii krɨmiir Wanɨn siir yɨnisɨmɨn Jisɨs Krais siirga, siir yaiga. ");
INSERT INTO iws_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Mɨ ta yaiya bɨdi bɨdiniya profet inkamɨn Aisaia siya wɨnkiya mɨ ɨni saiir hɨriinana yɨmbiyama. Mɨ bɨdi bɨdiniyarɨn Adi Komii siya siir yɨnisɨmɨn siirɨn hɨnɨɨna boɨnkikɨn, wakae! Kara inkamɨn wɨ nwɨra nɨkropkii kariir yai aiir boɨnmɨmauuwamam. Mɨ siya ɨni kariir bɨiyar yamkwokɨnɨn mɨ siya wɨ kariir siyɨu ɨiir kisɨsop haigɨnkwokɨni. ");
INSERT INTO iws_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Inkam nwɨrɨn maeyau siiyɨn nu apa saiir hɨr kauwok boɨnamnankikɨn. Siya hɨnɨɨna boɨnkikɨn, Bɨiyan Inkam Komiiyɨn siir siyɨuɨn sɨbgu kisɨsop dirɨraerarkwokɨn, siya napnaniyam. ");
INSERT INTO iws_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jon siya iikam ɨmiir baptaisam nɨtkɨn niimau siiyɨn nu apa siir. Mɨ tɨ niimau siiyɨn apaɨn siirɨn inkamkɨ bɨ whwonkaiigɨn. Nɨɨngaka. Mɨ siya iikamɨm haɨmii tamii hɨr napɨm sɨmiir boɨnmauugi ta yaiwɨn kɨbiya. Mɨ sɨmiir kwoɨnɨm wɨ nwokɨ aɨngwo tɨbmiiyɨm. Mɨ sɨmiir dimɨn biyɨeyɨm wɨ Adi Komii siya haiyoprimdiyɨumiigi. ");
INSERT INTO iws_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Mɨ iikamɨm tɨ nu komiiyɨn Judia hɨranɨm mɨ om komii Jerusalem siir hɨran iikam ɨkɨm sɨma Jon siir boɨnmauugi digworaekwo biyɨeyɨm sɨma tɨrɨm. Mɨ Jon siya sɨmiirɨn ɨna baptais haigɨnɨuwɨn Jodan ɨe hɨr. ");
INSERT INTO iws_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Mɨ Jon siya niiya yɨuɨsa, kamelni pɨokɨm. Mɨ siya pɨuwop ha mɨ kikogikɨn mɨ naeyɨm siya naeiyɨm kokmwo graeyɨs mɨnɨm mɨ mhwɨɨna nae nwowiya saiir yɨn ɨkɨm, siya sɨmiir naekɨn. ");
INSERT INTO iws_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Mɨ Jon siya ɨna boɨnmauugiyɨn sɨmiirɨn, inkam nwɨrɨn kariir mhoɨiya nɨtɨn siir kɨrɨeya ɨni kariir kɨrɨeya saiir haiburgika, kariir kɨrɨeya ɨni aowa saeya ywowa. Kara inkam mɨiyɨk rani, siir ɨga siya niiya saiir uridɨn wɨ kara waisi hak rani. Nɨɨngaka. Kara inkam biyɨeyɨn ɨni siir aowa ywokaiyɨn. ");
INSERT INTO iws_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Kara kɨmiirɨn opni baptais haigɨnɨuwi mɨ inkamɨn mhoɨiya nɨtɨn kɨmiirɨn wɨ siya nɨuae haigɨnɨuwi naeyɨuniyɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mɨ ta ɨiya Jisɨs siya omisɨmɨn Nasaret nɨkɨuwiyɨn nu Galili hɨr nwowɨn siir haiburgigɨn mɨ siya ɨna yɨtɨn. Mɨ Jon siya siirɨn ɨe Jodan hɨr baptais haigɨnɨu. ");
INSERT INTO iws_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Mɨ siya op hɨr haiburgigɨn mɨ ha nɨɨg apnaidamɨn nua hɨriir mɨ siya kɨgi, nɨnomora omaka anonan haiwaokiya. Mɨ Adi Komii siir naeyɨuɨn ɨpiyɨni hanɨɨna siinɨnaiiniyɨn siiram. Ta ɨpiyɨna krɨma dapiya ɨɨnmab mɨ saiir hɨriinanar siinanaiinika. ");
INSERT INTO iws_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Mɨ sɨmar wakaeki yai kwɨra nɨnomor kou hɨr kauwok boɨnkiya, kɨra kariir yɨnisɨm yɨnkamiyɨnkɨn, kara kɨriiramɨn ɨni maɨrgɨmaɨrgar ywowɨnɨn. Kariir kwoɨnɨn kɨriiramɨn ɨni wadɨekɨ wadɨeyar ywokiyɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Mɨ bɨri kɨmɨmɨnkikɨn Adi Komii siir naeyɨuɨn siya yɨkropki Jisɨs siirɨn maeyau siiyɨn nu apa siir hɨriir. ");
INSERT INTO iws_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ɨiyɨm Jisɨs siya maeyau siiyɨn nu apa siir nwowɨm kamnwɨs. Mɨ Setanɨn, bɨikɨ bɨiyan yɨu biyɨeyɨn ɨna kɨnankɨuɨn siirɨmɨn. Mɨ siya ɨni mwanhunan ywowɨn. Mɨ Adi Komii siir paekwosɨmɨn ha nɨtɨn siirɨm, ɨni saɨkar yaunɨ oniyɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ɨiya Jon siya maeyauwa hɨuyokiyokaiya mɨi biyɨe mɨriiya saiir hɨrar nikɨ okaiyɨn mɨ ta ɨiya Jisɨs siya nu Galili hɨriirɨn saiir yɨmbinikɨn. Mɨ Adi Komii siir Yokwo Komiiya saiir yaiyɨm, siya sɨmiir inɨ boɨnmɨmauuni iikam ɨmiirɨn. ");
INSERT INTO iws_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Siya boɨn, ta ɨiya bɨdi yɨmbiniya, ta ɨiya Adi Komii siya iikamɨm tɨ nu komiiyɨn siirɨm wɨ sɨmiir kɨgrɨraowi. Mɨ taka ɨiya ɨni kingiin nwowa krɨmiirɨn wɨ siyar kɨgrɨraowi. Krɨmiir kwoɨnɨm tɨ kisɨna haigi mɨ Yokwo Komii saiir yaiyɨm sɨmiiraramar daɨngwo tɨbmii ɨski. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisɨs siya nu Galili whɨigbida hɨriir napamɨn mɨ siya Saimon, Endru sowiiryao yapkɨgam, sowa haɨmna whɨi hɨr nɨtmaii. Ta mɨiya sowa mɨriiya anasu kikaiiya, sowa umɨr mɨi mɨrii. ");
INSERT INTO iws_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Mɨ Jisɨs siya boɨnki, kowayao kariir mhoɨiya wɨt mɨ wɨ kara nɨisiimauuwi kariir mɨiya kowiiryao. Mɨ kowayao ta mɨiya kara mɨriiya saiir hɨriinan siyɨu ɨiirar sɨbgu ap. Mɨ iikam hoɨmgakɨm sɨmiir nwokɨ ɨkɨunam. ");
INSERT INTO iws_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Mɨ sowiir haɨmna ɨni hɨrar kwaiburgigɨn. Mɨ sowa bɨri kɨmɨmɨnko ɨni Jisɨs siir mhoɨiyar yamo. Mɨ sowa ɨni siir mɨi aiirar inɨ mɨriiyɨuwo. ");
INSERT INTO iws_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Mɨ siya ha swokɨ apnamɨn prɨei bɨri napkikɨn mɨ siya youap kɨgam, Sebedini yɨnisɨm nwɨso Jems mɨ siir nomousɨm ɨeya Jon, sowa i hɨr hɨinomaii. Mɨ yo sowa, sowiir haɨmna ɨiir kisɨsok dirɨraerari. ");
INSERT INTO iws_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Mɨ siya sowiirɨm yɨkɨuna. Mɨ sowiir adwai biyɨeyɨn mɨ sowiir adɨn siir mɨi mɨriiyɨm kamɨm sɨmiirɨn i hɨrar kwaiburgig. Mɨ yɨo sowa ɨni Jisɨs siir mhoɨiyar yapnamo mɨ siir mɨi aiir yamɨriiyɨu. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Sɨma om Kapeneam hɨriir yam sɨmiir ɨi komii aiirɨm. Jisɨs siya ta sɨmiir ɨi komiiya sɨmiir omaka komiiya yai nɨdwokai wakaenakiiya saiir yapnɨnopkainam. Mɨ iikamɨm sɨmiirɨn Adi Komii siir yai aiir inɨ boɨnmɨmauu haigɨnɨuɨu. ");
INSERT INTO iws_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ɨiya sɨma siir yai aiir wakaeyɨm, ɨni hindara yanaakiyɨm. Siya sɨmiirɨn kamɨm siyɨu komii nɨnoknɨnkɨniyɨm sɨmiir hɨriinan bɨri boɨnmɨmauugɨn. Nɨɨngaka. Siir yaiya ɨni inkamɨn inɨg komiigakɨn, siir hɨriinan ywowɨn. ");
INSERT INTO iws_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mɨ ta ɨiya inkam nwɨrɨn sɨmiir omaka komiiya yai nɨdwokai wakaeiya saiir nwokɨn. Mɨ yɨu biyɨeyɨn siir pɨu hɨr nii okaiyɨn mɨ siya ɨna kauwok boɨnkiyɨn. ");
INSERT INTO iws_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Jisɨs om Nasaretanɨn! Kɨra dimuam nɨtkɨn, dimu tɨrniyam? Mɨ kɨra tari krɨmiir tɨrbumbuam nɨtkɨn? Kara kɨriir bɨdi yɨnoknɨnkɨnɨn, ni kɨra Adi Komii krɨmiir Wanɨn siir hɨrankɨ nɨt ɨeya inkam wadɨeyɨn. ");
INSERT INTO iws_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Mɨ Jisɨs siya tɨ yɨu biyɨe siir nɨkiyɨn mɨ siya ɨna boɨnkiyɨn, yɨu biyɨe ɨiirɨn, kɨra yaiya tɨ tanki mɨpa dɨnkinɨmnɨsnaki. ");
INSERT INTO iws_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Mɨ tɨ inkamɨn siya ha kaunanaekiyɨn mɨ siirɨn siya haɨniyop whaowagig. Mɨ yɨu biyɨe siya tɨ inkamɨn siir pɨu hɨrankɨ yɨuun iwɨskɨinam mɨ ɨna yamɨn. ");
INSERT INTO iws_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mɨ iikam hoɨmgakɨm hɨriinan dimɨnɨn siir kɨgɨm, sɨma ɨni kakakar ywokiyɨm. Mɨ sɨma ha nanaakiyɨm mɨ ɨni sɨma sɨmar yomboɨn amboɨnamɨm, tɨkɨ hɨnɨɨn dimɨnɨn tari dimu dimɨnkɨn, ha? Taka yaiya saeya yai wɨnka. Mɨ tari tɨ inkamɨn siya inɨg komiigakɨn. Ɨiya siya yɨu biyɨe ɨmiir boɨnkiyɨn mɨ sɨma ɨni siir yai aiirar mɨ wakaeyoknaɨm. ");
INSERT INTO iws_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mɨ tɨ dimɨnɨn siya tɨrɨn bɨri kɨmɨmɨnkɨn, ɨna haigirɨrɨr boɨnamɨn nu Galili hɨran omɨm sɨmiir hɨriir. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Sɨma omaka komiiya yai nɨdwokai wakaeiya saiir haiburgigɨm mɨ ha woknaniyamɨm, sɨma Saimon Endru sowiiryao omaka saiir woknɨnopkainam. Mɨ Jems Jon sowayao warar yɨnkɨn am. ");
INSERT INTO iws_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Mɨ Saimon Pita siir nɨua hɨi hɨrar whwonkaiga, saeya pɨu huuwa kɨni ma saeya niiga. Mɨ sɨma bɨri kɨmɨmɨnkɨm ta wiga maka niiya saiirɨn, Jisɨs siir inɨ boɨnmauuɨu. ");
INSERT INTO iws_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Mɨ Jisɨs siya saiiram ha namɨn mɨ saiir ɨɨn aiir inɨ onkwoɨu mɨ ɨna kinɨnsiin ɨdwokiya saiirɨn. Mɨ ta pɨu huuwa kɨni ma saiir niiya, ɨna dɨgiya. Mɨ saeya ɨni sɨmiir naeyɨm sɨmiir swokɨ dirɨraerarɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ɨiya bɨe nɨkiiyamtɨbɨn mɨ sɨmiir iikamɨm makakmakakɨm ɨni sɨmar swokɨ ɨkɨunaniyɨm Jisɨs siirɨm. Mɨ iikamɨm yɨugɨ nonkwowɨm yɨm ɨni warar mɨ ɨnkɨn ɨkɨunaniyɨm. ");
INSERT INTO iws_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mɨ tɨ om komiiyɨn siir hɨran iikam hoɨmgakɨm, sɨma ta omaka Saimon, Endru sowiira saiir anoka kingiin hɨrar inɨ okwoɨu. ");
INSERT INTO iws_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Mɨ Jisɨs siya haiswonɨmnɨskɨiyɨm mapai mapaiyɨm sɨmiir niiyɨm mɨ yɨu biyɨeyɨm siya nɨnɨmnɨskɨiyɨm kasa rani, sɨmiir nwowɨm. Mɨ sɨma tɨ yɨu biyɨeyɨm Jisɨs siir bɨdi yɨnoknɨnkɨnɨm mɨ siya sɨmiir asi nɨkɨdugɨn kɨma kariir inɨgɨn siir kɨpi dap. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mɨ ɨigwɨra Jisɨs siya nugak ɨmumar yɨnsiin apnamyakwok, maeyau kwɨra inkam karamaeya saiirɨm. Mɨ siya Adi Komii siirɨmɨn nhwo hɨr inɨ kwɨsboɨnɨu. ");
INSERT INTO iws_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Mɨ mhoɨiya Saimon siya mɨ siir nomiiyau ɨma, sɨma ɨni siir mhoɨiyar yapansrɨnamɨm siirɨmɨn. ");
INSERT INTO iws_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ɨiya sɨma siir ninɨ kɨgɨuɨn sɨma ɨna boɨnɨm, tɨ iikam isid komiiyɨn kɨriirɨm hansrananikɨm. ");
INSERT INTO iws_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Mɨ siya sɨmiirɨn ɨna boɨnɨn, kiya! Nɨmbi tɨ omɨm kingiin nwowɨm pɨ sɨm nami. Kara Adi Komii siir yaiyɨm sɨmiir warar mɨ boɨnmɨmauuam mɨ aɨngwowi. Kara ta mɨi aiirɨmar nɨtkɨn, dimɨn mɨi mɨriiyam bɨ nɨtkɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Mɨ siya nu Galili hɨran omɨm sɨmiir asi namkɨn. Mɨ siya omakam yai nɨdwokai wakaeiyɨm sɨmiirar yapnɨnopkai boɨnmɨmauuam, Adi Komii siir yai aiirɨn. Mɨ siya yɨu biyɨeyɨm sɨmiir nwowɨm ɨni sɨmiir warar yɨnɨmnɨskiiyamɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mɨ inkam nwɨrɨn paowaigɨ pɨskɨmkopouɨn, siya ha nɨtɨn, ɨni Jisɨs siir ɨgmiiga kingiina inɨ akai hɨu ouniyɨn. Mɨ siya siir boɨnki mɨ kɨra ha naɨngwowi, kara kɨriirɨn wɨ dɨgar nwo haigɨnɨugii. ");
INSERT INTO iws_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Mɨ Jisɨs siya siirsi yaɨngwobumbu mɨ siir ɨɨna ɨna yonkwokiyɨn siir. Mɨ Jisɨs siya ɨna boɨnkiyɨn, kara ha naɨngwowi kɨra wadɨe dwoki. ");
INSERT INTO iws_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mɨ tɨ paowaiyɨm siir pɨskɨmkopouɨm bɨri kɨmɨmɨnkikɨm ɨna wɨskiyɨm mɨ siya ɨni wadɨeyar ywokiyɨn. ");
INSERT INTO iws_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Mɨ Jisɨs siya yai kɨrɨe aiirar boɨnki siirɨn. Mɨ bɨri kɨmɨmɨnkɨn siirɨn ɨna yɨkropki sasaugiyɨn. ");
INSERT INTO iws_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Jisɨs siya siir boɨnki, kɨra sɨbgu mɨntarao! Kɨra wɨ inkam nwɨrni kɨpi boɨnmauu tɨ dimɨnɨn. Nɨɨngaka. Mɨ kɨra pa dam mɨ kɨriir pɨua pɨ inkamɨn naemɨn krɨmiirsi nɨnkɨn ɨmiiyaeiyɨn Adi Komii siirɨm pris, pɨ siir tinɨ ɨisiimauuɨu. Mɨ kɨra Adi Komii siirɨn nae pa dɨnkɨn ɨmiiyaeki. Mɨnsi dɨnkɨn ɨmiiyaeki! Kɨriir pɨua wadɨe nwowa saiirsi, yaiya krɨmiir brougaeyɨn Moses siya boɨna saiir hɨriinan. Mɨ sɨma tɨ kamɨm wɨ nwokɨ nɨnoknɨnkɨnwɨni kɨriir paowaiyɨm bɨdi wɨskiyɨm. ");
INSERT INTO iws_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mɨ inkamɨn ha namɨn mɨ bɨri ninɨ haigiprakai boɨnɨugɨn tɨ yaiyɨm. Nɨɨngaka. Ɨni hɨriiyar boɨnɨskiyɨn tɨ dimɨnɨn. Mɨ siya tɨ dimɨnɨn ɨni niiwiinan siir boɨnyokiyokɨiyamɨn omom omomɨm sɨmiirɨn. Mɨ Jisɨs siya om komiiya hɨriir panɨɨnsi yamsi iikamɨm sɨmiir whwonkam ɨdan. Iikamɨm ɨni homgak ywoɨm, siya sɨmiir ma ɨmiir nɨnɨskɨiyɨm wɨ dɨg nwo rani. Mɨ siya om komiiyɨm sɨmiir yaba nwowɨm omɨm iikam homgak karamaeyɨm, ɨni sɨmiir hɨrɨrar ywowɨn. Mɨ maeyau maeyauan iikamɨm ɨni Jisɨs siiraramar yɨtswoɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ɨi nhɨrɨm bɨdi yamkiyɨm mɨ Jisɨs siya ɨni om Kapaneam hɨriiyar swokɨ amɨn. Mɨ iikamɨm sɨma hɨnɨɨna wakaewɨn, siya ɨni omaka hɨr nwowɨn. ");
INSERT INTO iws_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Mɨ iikam hoɨmgakɨm hanɨɨngɨ yanɨnkɨnɨuɨu mɨ omaka ɨni dɨgar ywokiya. Mɨ anoka kingiinɨn, maeyau kwɨrkɨ nɨɨnga bɨ swokɨ oka. Nɨɨngaka. Mɨ Adi Komii siir yaiya Jisɨs siya sɨmiirɨn saiir boɨnmɨmauugɨn. ");
INSERT INTO iws_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ɨiya Jisɨs siya yaiyar nikɨ okwo boɨnɨn mɨ sɨma ɨna hainaniyɨm tɨ inkamɨn ɨga ɨɨn nɨnsɨmsɨruɨn Jisɨs siirɨm. Mɨ kam nwiiyɨm sɨma hainani tɨ inkam ɨiirɨn. ");
INSERT INTO iws_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mɨ omaka yainaua ɨni iikamɨm sɨma yɨdwokaisɨsɨrkiya mɨ sɨma Jisɨs siir kingiin paninsi haigɨnsi tɨ inkamɨn ɨga ɨɨn nɨnsɨmsɨrɨuɨn. Mɨ sɨma akouwa hɨrii iiyam mɨ akou haɨmii ɨiir inɨ pɨrakɨu maeyaua siyar nokwo hɨrɨrɨuwa saiirar. Mɨ sɨma akou haɨmiiyɨn ha pɨrak grirgigiyɨn mɨ ta hɨiya tɨ inkamɨn siya whɨna mɨ sɨma ɨdmɨrɨm kwiiya borɨtkɨkɨn mɨ ɨna yonkwokiikiiraraokiya. Mɨ ɨni Jisɨs siir ɨgmiiga yaunɨ kikɨnɨuwa. ");
INSERT INTO iws_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Mɨ Jisɨs siya sɨmiir naɨngwo tɨbmiiya saiir kɨgiyɨn mɨ siya tɨ inkamɨn siir boɨnki, yɨnisɨm! Kara kɨriir dimɨn biyɨeyɨm sɨmiir bɨdi haiyoprimdiyɨumiigiyɨm. ");
INSERT INTO iws_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mɨ kamɨm siyɨu komii nɨnoknɨnkɨniyɨm yɨm sɨma hɨr warar nɨnkɨn ɨdwokaigɨm mɨ sɨmiir kwoɨnɨm aowa aowa ɨni ta yaiya Jisɨs siya boɨna saiir saiira yaɨngwokwonanaeyɨm. ");
INSERT INTO iws_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Siya tɨ hɨnɨɨn yai boɨnɨn mɨ siya tari Adi Komii siir nɨgbumbui. Inkam nwɨrkɨn bɨri swokɨ haiyoprimdiyɨumii srankɨn dimɨn biyɨeyɨm. Nɨɨngaka. Adi Komii siirar mɨiga. ");
INSERT INTO iws_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mɨ sɨmiir kwoɨnɨm Jisɨs siya bɨdi yɨnoknɨnkɨnkiyɨm mɨ siya sɨmiir asi boɨnkɨn, kɨma wara hɨnɨɨn kwoɨnɨn kɨmiir waraur dimusi nwowi? ");
INSERT INTO iws_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Pɨkɨ hɨnɨɨn dimɨn ɨkɨn hinsɨma nwowiyɨn? Mɨ kara ha boɨni kɨriir dimɨn biyɨeyɨm kara bɨdi haiyoprimdiyɨumiigiyɨm mɨ tɨkɨ hɨnɨɨn dimɨnɨn kara wɨ dɨga nwowi? Mɨ tari wɨ dɨg nwo rani? Mɨ kara ha boɨni, kɨra kɨriir hɨi aiir hainam mɨ hɨnɨɨnɨn kara wɨ dɨgar nwowi, iyɨe? Wɨ dɨg nwo rani, aniya? ");
INSERT INTO iws_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kɨma dɨnoknɨnkɨn, Adi Komii siir yɨnisɨmɨn nɨnomor kou hɨrankɨn nɨtɨn karaɨrgɨn. Kariir kɨrɨeya wɨ dɨgar nwowi kɨmiir dimɨn biyɨeyɨm sɨmiir haiyoprimdiyɨumiigiyɨm. Mɨ Jisɨs siya tɨ inkamɨn ɨga ɨɨn nɨnsɨmsɨrɨuɨn siir asi boɨnkikɨn. ");
INSERT INTO iws_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Kara kɨriir boɨnkii, kɨra dɨngsingi! Mɨ kɨriir hɨi aiir hainam mɨ kɨra pɨ kɨriir omaka damɨgusam. ");
INSERT INTO iws_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Mɨ siya ɨni iikamɨm sɨmiir whwonkam ɨdar yɨnsiingiyɨn. Mɨ siya ɨni siir hɨi aiirar hainamɨn. Mɨ siya bɨri kɨmɨmɨnkɨn, ɨna yɨnsiin apnamɨn. Mɨ sɨma hɨriinan kɨgiyɨm mɨ sɨma ɨni hindara yanaakiyɨm mɨ sɨma ɨni Adi Komii siir inɨg ɨiirar hainankiyɨm. Mɨ sɨma ɨna boɨnkiyɨm, bɨiya nɨm krɨma tɨ hɨnɨɨn dimɨnɨn siir bɨri kɨgɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Mɨ Jisɨs siya whɨigbid hɨriiyar swokɨ apnamɨn mɨ iikam isid komiiyɨn sɨma ɨni siir mhoɨiyar yamɨm. Mɨ siya Adi Komii siir yaiya ɨni sɨmiir yowɨmwarkai haigɨnɨuwɨm. ");
INSERT INTO iws_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Mɨ siya ha napnamɨn Livai siir kɨg, Alfias siir yɨnisɨmɨn. Mɨ siya omaka omom omoman umɨr nɨdwokai haiiya, yɨo saiir nɨdwokaii. Mɨ Jisɨs siya yɨkɨugi, kɨra kariir mhoɨiya wɨt! Livai siya ha nɨnsiingiyɨn mɨ ɨni siir mhoɨiyar yamɨn. ");
INSERT INTO iws_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ɨiya Jisɨs siya Livai siir omaka hɨr nikɨ ɨdwokai aeyɨn mɨ kam hoɨmgakɨm umɨr haiiyɨm, nhɨrɨm siyɨu biyɨe tɨri kam ɨma mɨ kamɨm Jisɨs siir kɨgna mɨriiyɨm, sɨma sɨmar yɨdwokai aemɨmɨr Jisɨs saɨkan. Tɨ hɨriinan kamɨm kasaka rani, Jisɨs saɨka nap mɨriiyɨm. ");
INSERT INTO iws_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mɨ Farisi kam nhɨrɨm siyɨu komii nɨnoknɨnkɨniyɨm sɨma kɨg Jisɨs siya kamɨm siyɨu biyɨe tɨriyɨm mɨ kamɨm umɨr mɨn haiiyɨm sɨmaka nɨdwokai aei. Mɨ Farisi kamɨm sɨma srɨigi kamɨm Jisɨs siir kɨgna mɨriiyɨm sɨmiir, Jisɨs siya kamɨm siyɨu biyɨe tɨriyɨm mɨ kamɨm umɨr mɨn haiiyɨm sɨmaka dimusi nɨdwokai aei? ");
INSERT INTO iws_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Mɨ Jisɨs siya ta yai aiir wakaeyɨn mɨ siya ɨna boɨnkiyɨn, inkamɨn ma karamaeyɨn yɨo siya paowai widi inkamɨn siiram bɨri swokɨ amikɨn. Nɨɨngaka. Mɨ ɨkɨ makak iikamɨm pɨ sɨma sɨmar nami kamɨm paowai widiyɨm sɨmiiramɨn. Kara iikam mɨiyɨk mɨiyɨkɨm sɨmiir nɨkɨunam ara bɨri nɨtɨn. Nɨɨngaka. Kara iikam biyɨeyɨm sɨmiir nɨkɨunam nɨtkɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mɨ ɨigwɨra Jon siir kɨgna mɨriiyɨm kamɨm mɨ Farisi sɨma, sɨma nae haiyakɨm. Mɨ kam nhɨrɨm sɨma ɨna yɨtɨm, Jisɨs siir inɨ srɨini mɨ Jon siir kɨgna mɨriiyɨm kamɨm mɨ Farisimi mɨi kɨgna mɨrii ɨkɨm, sɨma nae dimusi haiyaei? Mɨ kamɨm kɨriir kɨgna mɨriiyɨm yɨm nae haiya karamae dimusi nwowi? ");
INSERT INTO iws_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Mɨ Jisɨs siya sɨmiirɨn boɨniyɨo yaiya kwɨra boɨnki, ɨiya inkam nwɨrɨn siir wig aiir saɨnam tɨri mɨ siir nomiiyauɨm mɨ iikam nhɨrɨm sɨma wa nɨti ta nae aiirɨmɨn. Mɨ sɨma ta ɨiya wigwas naeya saiir naei mɨ sɨma wa haiyaei? Nɨɨngaka. Sɨma wa naei. Mɨ siir nomiiyauɨm mɨ iikam yaisi yaisiyɨm sɨma wɨ maɨrgɨmaɨrgar nwonami siir whɨnsaɨn haigɨnɨuwamɨn. Mɨ taka ɨiya sɨma wɨ nae mɨnar haiyaei. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ɨiya tɨkɨ inkamɨn wig nonkwonaɨn siya om whɨra nami mɨ krɨma hɨkak saiir dwoki mɨ nae mɨnɨm saiir haiyaki. Mɨ ɨiya kara kɨmiir haiburgigana mɨ kɨma wɨ hɨriinanar timɨ tɨrki. ");
INSERT INTO iws_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Jisɨs siya boɨniyɨo yai kwɨra ɨna swokɨ boɨnɨn, dimɨn wɨnɨn dimɨn biyɨe aka kɨpi nɨtapiyok. Inkamɨn yɨuɨs wɨn haɨmii bɨri kɨntɨo haigɨn yɨuɨs kwɨra saiir noɨn siir nɨtkɨn panam mɨ siya hɨriinan tɨri, siya saiir nɨtkɨn pani mɨ saeya wa swokɨ ɨmbɨryami. Mɨ wɨna wɨ kaba saiir mɨmbɨrgi mɨ noɨn wɨ komiiyar swokɨ okii. ");
INSERT INTO iws_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Inkam nwɨrkɨn wain wɨni opa wraisu ɨs kaba op two biyɨenana saiir bɨri swokɨ aokaiiga. Nɨɨngaka. Mɨ siya hɨriinan tɨrkɨswo mɨ tɨ wain wɨnɨn siir opa saeya niyopiingi mɨ ta wraisu ɨs kaba saeya wa nɨmbɨryamkii mɨ wain wɨni opa wa naokiyamki. Mɨ wraisu ɨsa wa mɨ ɨmbɨryamki. Mɨ inkamɨn wain wɨni opa saiir naokaii siya wɨ hɨnɨɨna tɨr, wɨ wraisu ɨs wɨna wɨ saiir daokai. Ɨriig ");
INSERT INTO iws_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mɨ Adi Komii siir ɨi komii kwɨra Sabat Jisɨs siya numɨra wid nɨnkɨna saiir napnamkɨn mɨ kamɨm siir kɨgna mɨriiyɨm sɨma saɨka warar yɨnkɨn apnam. Ɨiya sɨma napama, sɨma witnidɨm ha kiwromwrɨs haiyamɨm mɨ ɨna yɨinɨbrombrop apaeyamɨm. ");
INSERT INTO iws_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mɨ Farisi kam nhɨrɨm sɨma Jisɨs siir boɨnki, wakae! Kɨma ta Juda sɨmiir ɨi komiiya pɨu siiskuwakiya mɨi mɨn saiir dimusi mɨriigɨm mɨ nae mɨnɨm saiir dimusi mɨ haigɨm. Mɨ kɨma tɨ siyɨu ɨiir bɨ sɨbgu apkɨm. ");
INSERT INTO iws_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jisɨs siya ɨna yowarkɨi boɨnkiyɨn sɨmiir yai aiir mɨ kɨma tari dimɨn whɨrɨn bɨiya kɨmiir brougaeyɨn Devid siya tɨrɨn siir bɨri mwaɨngɨm? Mɨ taka ɨiya Devid siya mɨ siir isid ɨeya sɨma nae karamaekɨm mɨ sɨmiir mhɨiyɨm ɨna yaowɨm. ");
INSERT INTO iws_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ɨiya tɨkɨ dimɨn ɨeya nɨmbiyamɨn Abaiata siya nwokɨn pris inkamɨn nae Adi Komii siir nɨnkɨn ɨmiiyaeiyɨn. Mɨ Devid siya mɨ siir isid ɨeya sɨmar yapnɨnopkainam Adi Komii siir omaka aiir. Mɨ Devid siya paimɨr ɨiir naeyɨn mɨ siya paimɨr haɨmiiyɨm siir isid ɨiir yae hauu. Tɨkɨ naeyɨm inkam nɨɨngakɨ bɨ naeikɨn. Nɨɨngaka. Pris sɨmiiraraɨrgɨn. Mɨ sɨma yai bɨri swokɨ boɨnkikɨm tɨ dimɨnɨn Devid siya tɨrɨn. Mɨ kɨma yai krɨmaka dimusi boɨni. ");
INSERT INTO iws_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jisɨs siya boɨnki, ta ɨi komiiya Juda sɨmiira pɨu siiskuwakiya Sabat, saeya iikamɨm hɨk sɨmiir hauuwɨm bɨri nwoka. Nɨɨngaka. Ta ɨi komiiya mɨnam nwoka iikam hoɨmgakɨm sɨmiir whɨndirɨraerar haigɨnɨuwam. ");
INSERT INTO iws_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yaowae Adɨn nɨnomor kou hɨrankɨ nɨtɨn ta ɨi komiiya Juda sɨmiira pɨu siiskuwakiya dimɨn taemɨn tɨr karamae nwowiya Sabat saiir Bɨiyan Inkam Komii siya asi nwowi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Mɨ Jisɨs siya ha swokɨ apnɨnopkainamɨn Juda sɨmiir omaka yai nɨdwokai wakaeiya saiir mɨ inkam nwɨrɨn hɨr nwokɨn siir ɨnib waeyaowɨm ɨni paeyarwainan ywokiyamɨm. ");
INSERT INTO iws_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mɨ Farisi kam nhɨrɨm Jisɨs siiram hɨrar kaonanae. Sɨma bɨri nɨnoknɨnkɨnkɨm siya tɨ inkamɨn siirɨn pɨ ɨi komiiya saiir namisi haiswonɨskii mɨ ta hɨriinana saiirsi boɨnɨuriyɨu boɨnam mɨnkɨm siirɨn. ");
INSERT INTO iws_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Mɨ Jisɨs siya tɨ inkamɨn ɨɨna paeyarwainan nwowɨn siir boɨnki, kɨra sɨmiir bopwoniya dɨnsiin okwoki. ");
INSERT INTO iws_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Mɨ Jisɨs siya sɨmiir srɨigi, krɨma wɨ pɨkɨ hɨnɨɨn siyɨuɨn si tɨri Juda sɨmiir ɨi komii aiirɨn mɨ krɨma siyɨu mɨiyɨk tɨ tɨr. Iyɨe!? Farisi sɨma yai bɨri wakae boɨnkɨm. ");
INSERT INTO iws_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Mɨ Jisɨs siya sɨmiir kaoyokiyokɨigiyɨn mɨ siir kwoɨnɨn ɨni haugɨhauga whiyɨekiyɨn. Mɨ siya sɨmiir mhɨi kwoɨn ɨmiir kɨgiyɨn mɨiyɨk bɨri nwokɨm, sɨma tɨ inkam ɨiirsi bɨ naɨngwoyɨmyokɨm. Mɨ Jisɨs siya hɨkak asi nwonamkɨn, tɨ hɨriinan siyɨu ɨiirsiyɨn. Mɨ siya tɨ inkamɨn siir boɨnki, kɨriir ɨɨndɨbɨn ha dɨnkiyɨnyɨnki. Mɨ siir ɨɨna ɨni wadɨeyar ywokiya. ");
INSERT INTO iws_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mɨ Farisi kamɨm sɨma Juda sɨmiir omaka yaimɨn dimɨn nɨdwokai wakaeiya saiir haiburgigɨm mɨ sɨma bɨri kɨmɨmɨnkɨm ɨna yɨnsiin apnamɨm Herot siiram mɨ siir nomiiyau nhɨrɨm sɨmiiram warar. Mɨ sɨma yaiyɨm ɨrɨpa mɨnam kitɨbmii boɨnkɨm Jisɨs siir nɨsomaokiyɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Mɨ Jisɨs siya mɨ kamɨm siir kɨgna mɨriiyɨm sɨma tɨ omon nu Judia hɨranɨn sɨma siir haiburgigɨm mɨ whɨi Galiliya hɨriir yam. Mɨ iikam isid komiiyɨn sɨma ɨni siir mhoɨiyar yamɨm. ");
INSERT INTO iws_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Mɨ iikamɨm tɨ omom omomɨm hɨranɨm nu Galili nu Judia mɨ om komii Jerusalem mɨ nu Idumia mɨ tɨ om whɨso Taia mɨ Saidon yo ɨni yab komiiyɨn Jodan, ɨni siir gɨmiya waiywo. Sɨma omom omomankɨn nɨtkɨm. Mɨ tɨ isid komiiyɨn Jisɨs siir yaiya sɨma wakae wɨnkɨm digworaekwowɨm siya tɨrɨm sɨmiir mɨ sɨma ha nɨtkɨm siiramɨn. ");
INSERT INTO iws_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Mɨ Jisɨs siya kamɨm siir kɨgna mɨriiyɨm sɨmiir boɨnki, iikam isid komiiyɨn tɨsa nwowɨn ambi sɨma haigɨn ikwokromkwɨrisi. I ɨra pɨ kariiram dwomaigi, kara pɨ saiir kwɨrii nami. ");
INSERT INTO iws_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Bɨiya siya i aiir nikɨ apni kwɨriinam karamae nikɨ owɨn mɨ siya iikam kasa bɨ haiswonɨmnɨskɨigɨn. Mɨ tariinanɨn iikam whɨekak nhɨrɨm makak makakɨm sɨma ɨna yapiyaonamɨm siiram, sɨmiir ɨɨnam siir pɨu aiir ninɨ onkwoɨuɨm. Mɨ sɨma iikam nhɨrɨm sɨmiir asi napkɨnyamya amkɨm. ");
INSERT INTO iws_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mɨ kamɨm yɨu bibiyɨekɨn nii whwonkaiyɨm sɨma Jisɨs siir kɨgiyɨm mɨ sɨma ɨni siir ɨgmiigar inɨ akaigai hɨuniyɨm. Mɨ sɨma ɨna kauwok boɨnkiyɨm. Kɨra Adi Komii siir yɨnisɨmkɨn. ");
INSERT INTO iws_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mɨ Jisɨs siya yɨu biyɨe ɨmiir nɨnɨmnɨskɨigiyɨn mɨ siya iikam ɨmiirɨn ɨna boɨnɨkɨdugiyɨn. Kɨma kariir inɨgɨn wɨ kɨpi haigirɨrɨr boɨnam. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Mɨ Jisɨs siya mhɨu ɨiir niinainamɨn mɨ siya ɨna dapɨkɨuna kamɨm siya naɨngwowɨm sɨmiir inɨgɨm. Mɨ kamɨm siya dapɨkɨunam sɨma ɨna yamɨm siiram. ");
INSERT INTO iws_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Mɨ siya aposel kamɨm ɨuur nwɨsa yɨmbingi hɨnda tɨnda saɨka nap mɨriiyam, Adi Komii siir yai aiir nap boɨnmamauuam. ");
INSERT INTO iws_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Mɨ siya aposel kamɨm sɨmiirɨn ɨni inɨgakar ywowaigɨnɨugiyɨm, yɨu biyɨeyɨm iikamɨm sɨmiir pɨu nii whwonkaiyɨm, sɨmiir nɨnɨmnɨskiiyamamɨn. ");
INSERT INTO iws_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Mɨ Jisɨs siya aposel kamɨm ɨuur nwɨsa yɨmbingi. Mɨ Saimon siir inɨg whɨrɨn Jisɨs siya nokdap haigɨnɨuɨn, Pitakɨn. ");
INSERT INTO iws_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Mɨ Sebedi siir yɨnisɨm nwɨso Jems, Jon sowiirɨn Jisɨs siya yaeya inɨgar swokɨ kisɨna okdap haigɨnɨu, Boanesis. Tɨkɨ inɨgɨn siir inɨg tɨpmwokɨ tɨpmwowɨn, ta diya tɨowiya saiir yɨnisɨmkɨn. Sowiir yaiya ɨni hɨriinan ywowa. ");
INSERT INTO iws_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Mɨ Endru, Filip, Batolomiyu, Matyu, Tumas mɨ Jems Arpias siir yɨnisɨm ɨeya mɨ Taitias. Mɨ Saimonɨn bɨiya ta yaiya saiir boɨnmɨmauugɨn nu whɨran inkam komiiyɨm krɨmiir kɨpi kɨgrɨrao. ");
INSERT INTO iws_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Mɨ nwɨrɨn Judas Iskariotkɨn. Mɨ tɨ inkamɨn mhoɨiya wɨ wɨr siya napwouwi, kam nhɨrɨm ɨo Jisɨs saɨka nwowiyɨm siir nɨsomaowam naɨngwowɨm sɨmakan. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Mɨ Jisɨs siya ɨna swokɨ amɨn omaka hɨriir. Mɨ iikam isid komiiyɨn ɨni Jisɨs saɨkar swokɨ amwoniyɨm. Mɨ Jisɨs siya mɨ siir kɨgna mɨriiyɨm kamɨm sɨma nae nɨdwosiis aeni ɨi karamaeka. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Mɨ Jisɨs siya siir ɨrɨpa o nhɨeyɨm mɨ siir yopii ad owa, sɨma hɨriinan ninɨ wakaeniyɨm, Jisɨs siya mɨ kamɨm siir kɨgna mɨriiyɨm, sɨma nae mɨn nɨngugu ae karamaeyar nwowi mɨ sɨma ɨna yɨtɨm siir nɨkɨunakiyam. Mɨ sɨma siir boɨn mɨ tari siir kwoɨnɨn pɨ whaowaekɨn, siya tɨ nae mɨn nɨngugu ae karamae nwowɨn. ");
INSERT INTO iws_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mɨ kamɨm siyɨu komii nɨnoknɨnkɨniyɨm sɨma om komii Jerusalem hɨr haiburgigɨm mɨ ɨna yɨtɨm. Mɨ sɨma ɨna boɨnɨm mɨ tari bɨigɨ bɨiyan yɨu biyɨeyɨn Biesebulɨn ɨni saɨka nwoɨn. Mɨ nhɨrɨm ɨna boɨnɨm mɨ tari Jisɨs siirɨn Biesebul siya hauuga ta kɨrɨeya yɨu biyɨeyɨm inkam pɨu nii okwokaiiyɨm sɨmiir nɨnɨmnɨskiiya. ");
INSERT INTO iws_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Mɨ Jisɨs siya sɨmiiram yɨkɨuna, sɨma siir kingiin nɨtɨm. Mɨ siya sɨmiirɨn boɨniyɨo yai arar boɨn. Mɨ siya boɨn, yɨu biyɨe sɨmiir apu budɨn Setanɨn, siya wɨ yɨu sɨma sɨmar swokɨ ɨnɨmnɨskɨinaei, aniya? ");
INSERT INTO iws_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mɨ tɨ om komiiyɨn siir hɨran iikamɨm sɨma isidɨn whɨsa nɨnkibɨrnakii mɨ sɨma wɨ kɨrɨekakar sɨbgu owi, aniya? Nɨɨngaka. Sɨma wa nɨdam nɨnoopki. ");
INSERT INTO iws_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Mɨ iikam nhɨrɨm omaka ɨruwanɨm sɨma isidɨn whɨsa nɨnkibɨrnaei, yaii nɨniyam mɨ sɨma wa sɨbgu owi ɨrɨpar, aniya? Nɨɨngaka. Sɨma wa nɨnoopki. ");
INSERT INTO iws_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Mɨ yɨu biyɨe Setan siir isidɨn sɨma sɨman isidɨn whɨsa nwowi mɨ siir isidɨn sɨma sɨma wɨ kɨrɨekakar nwowi, aniya? Nɨɨngaka. Sɨma wa nɨnoop ɨuguski. Mɨ hɨriinan tɨri, Setan siirɨn, wɨ Setan siya swokɨ haiswonɨskiinae, aniya? Nɨɨngaka. Siir kɨrɨeya ɨni kariir kɨrɨeya saeya haibura. Mɨ siir mɨiya wɨ kara tɨrbugi. ");
INSERT INTO iws_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ɨiya inkam nwɨrɨn inkam kɨrɨeni omaka napnɨnopkainami mɨ siir digworaekwowɨm sɨmiir ninɨ tauae hainakiyam mɨ siya wɨ dɨgar nwowi, siir digworaekwo ɨmiir tauae haiyamɨn, aniya? Nɨɨngaka. Mɨ siya inkam kɨrɨe ɨiirɨn bɨi ɨdni tikɨ kogrɨmdɨnugig. Mɨ siya hɨriinan tɨri siirɨn mɨ ɨkɨ siir digworaekwowɨm, ɨkɨ siir omaka nwokaiyɨm, sɨmiirɨn wa ninɨ tauae hainaki. ");
INSERT INTO iws_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Kara kɨmiirɨn yaimwowa boɨni, digworaekwo biyɨe biyɨeyɨm iikam hoɨmgakɨm kɨmiir waraur nwokaiyɨm, wɨ Adi Komii siyar haiyoprimdiyɨumii swoki. Mɨ yai bibiyɨeyɨm kɨma mɨ boɨnbumbuwiyɨm sɨmiirɨn wɨ warar mɨ ɨnkɨn haiyoprimdiyɨumiigi. ");
INSERT INTO iws_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mɨ inkam nwɨrɨn Adi Komii siir naeyɨuɨn siir nɨgbumbuwi mɨ Adi komii siya tɨkɨ inkamɨn siir dimɨn biyɨeyɨm, sɨmiirɨn wɨ warar nɨnkɨn haiyoprimdiyɨumiigi rani. Nɨɨngaka. Tariinan mɨ mhoɨiya ɨriipɨ hɨriinan, wɨ nɨɨngar mɨ owi. Jisɨs siya hɨnɨɨna boɨnkɨn, tɨkɨ inkamɨn, Adi Komii siir naeyɨuɨn siir nɨgbumbuɨn mɨ tɨkɨ siir dimɨn biyɨeyɨm siya ɨinokɨinokɨn wɨ hɨk sɨmiirsiyar hainanaei. ");
INSERT INTO iws_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jisɨs siya tɨ yai whɨekakɨm hɨnɨɨn dimusi bɨ boɨnkɨn, sɨmiir kwoɨnɨm ha naɨngwokɨm, Jisɨs siya yɨu biyɨe siir kɨrɨeya saiir mɨrii. Mɨ siya tɨ yaiyɨm hɨnɨɨn asi boɨnkɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mɨ ta ɨiya Jisɨs siir apu aeya mɨ siir nomousɨm ɨma, sɨma ɨna yɨmbiniyɨm. Mɨ sɨmaɨnii omaka akpitga hɨr yaka okwoniyɨm. Kɨra unkɨ ɨt krɨmiiram. ");
INSERT INTO iws_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Mɨ iikam isid komiiyɨn siir nɨdwo ywokaiyɨm sɨma boɨnki siirɨn, ha? Wakae! Kɨriir apu aeya mɨ kɨriir nomousɨm ɨkɨm mɨ kɨriir yokman ɨma, sɨma ɨsi kɨriirɨm idwowɨiya hɨrar nɨdwo kaowɨm, kɨriiramɨn sɨma nɨkɨugikɨm. ");
INSERT INTO iws_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Mɨ siya ɨni sɨmiir yai aka yowarkɨi boɨnkiyɨn, yɨpɨkɨ iikamkɨm kariir pɨugana saiir hɨriinan nwowɨm? ");
INSERT INTO iws_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Mɨ iikamɨm siir nɨdwoyokaiyɨm siya ɨni sɨmiirar kaoyokiyokɨikiyɨn. Mɨ siya ɨna boɨnkiyɨn sɨmiirɨn, kɨgi! Kariir apu mɨ kariir nomousɨm, tɨ kɨmargɨm, tɨ tɨrar kwowɨm. ");
INSERT INTO iws_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Iikam hoɨmgakɨm Adi Komii siir yai aiirɨm naɨngwo tɨbmiiyɨm mɨ siir mɨiya saiir mɨriiyɨm sɨma wara. Mɨ sɨma wɨ kariir apu mɨ kariir pomou yokman nwowi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisɨs siya sɨmiirɨn Galili whɨigbid hɨr swokɨ owomwarkaiyɨuɨu. Mɨ iikam isid komiiyɨn saɨka nwowɨm kasa rani. Mɨ Jisɨs siya i aiir asi kwɨriigɨn. Mɨ siya saiir kwɨrii ɨdwokaiyɨn mɨ iya ɨni whɨigbid hɨrar ywowa. Mɨ iikamɨm ɨni whɨigbid hɨrar yokwowɨm mɨ siya sɨmiirɨn i hɨrar yɨdwokai owɨmwarkaiyɨugi. ");
INSERT INTO iws_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Dimɨn taemɨnɨm siya nowɨmwarkaiyɨuwɨm sɨmiir, siya boɨniyɨo yai arar nowomwarkaiyɨugɨm. ");
INSERT INTO iws_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Mɨ Jisɨs siya boɨn, kɨma wakae! Inkam nwɨrɨn witnid numɨr hɨr bɨdi yɨtkɨngikɨn. ");
INSERT INTO iws_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mɨ ɨiya siya ha nɨtkɨnamɨn mɨ witnid nhɨrɨm siyɨu nɨkiigɨinaowidɨm, yɨm ɨni ɨpiyɨnkɨ sɨm inɨ ɨugi aeniyɨm. ");
INSERT INTO iws_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mɨ witnid nhɨrɨm siiyakak maeyauwa saiir nɨkiigɨiyɨm, maeyauuwa nuɨn ɨdar nwowa, nugɨnɨn aowa nam karamae nwowa saiir. Mɨ tɨ witnidɨm bɨri briprigɨm ɨna whakɨdudugiyɨm. ");
INSERT INTO iws_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Mɨ ɨiya bɨeyɨn ha whwokiyɨn mɨ ɨni witnid ɨbaɨrɨm sɨmiirar yaowhwoniyɨm. Mɨ tɨ witnid ɨbaɨrɨm sɨmiir mɨiyɨm aowa nam karam nwowɨm yɨm ɨna wainamɨm. ");
INSERT INTO iws_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mɨ witnid nhɨrɨm urid nɨmrɨdgakɨn siir bopwo yakaigai. Mɨ tɨ urid amrɨdnanɨn ha whakiyɨn mɨ tɨ witnid ɨbaɨrɨm sɨmiirɨn ɨni siya yɨisiwamwarkaigiyɨm mɨ tɨ witnidɨm nae bɨ budgɨn. ");
INSERT INTO iws_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mɨ witnid ɨbaɨr nhɨrɨm nu maeyau mɨiyɨk nɨkiigɨiyɨm, yɨm ɨni komiiyar ywokiyɨm mɨ yɨm nae hɨnɨɨna hɨnɨɨna bud, nhɨrɨm kamaɨrɨm ɨriiyar mɨ nhɨrɨm yɨm hɨnɨɨna mɨ bud, kam nwoɨm mɨ nhɨrɨm yɨm hɨnɨɨna mɨ bud, kam nwɨr ɨuur. ");
INSERT INTO iws_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Mɨ Jisɨs siya sɨmiir boɨnki, inkamɨn wɨɨngakaɨrgɨn mɨ siya tɨ kariir yai ɨmiirar wakae mɨ ha sɨbgu daɨngwo omok. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mɨ ɨigwɨr mhoɨiya Jisɨs siya sasaɨr ywoki hɨrɨn. Mɨ mhoɨiya kam ɨuur nwɨso siir kɨgna mɨriiyɨm mɨ iikam nhɨr ɨkɨm sɨma ɨna yɨtɨm Jisɨs siirɨm. Mɨ sɨma inɨ srɨini siirɨn boɨniyɨo yaiyɨm sɨmiir yaimwokɨyaimwoɨm sɨmiiram. ");
INSERT INTO iws_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Mɨ Jisɨs siya sɨmiir yowɨmwarkaiyɨugi. Mɨ ta Adi Komii siir oman yaiya kara kɨmiir bɨdiyar ikɨ owomwarkaiyɨugiyɨm. Mɨ iikam nhɨrɨm saiir wakaeyɨm, sɨma bɨri nɨnoknɨnkɨnkɨm sɨma boɨniyɨo yaiarar wakae. Mɨ sɨma saiir yaimwowɨn siir bɨri nɨnoknɨnkɨnkɨm, sɨma pɨ whaowaekɨm. ");
INSERT INTO iws_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Mɨ sɨma wa kɨgi tɨ dimɨnɨn mɨ sɨma wɨ sɨbgu kɨgsɨb rani. Mɨ sɨma wa wakaei mɨ sɨma ta yaiya saiirɨn wɨ sɨbgu wakaesɨb rani. Nɨɨngaka. Mɨ sɨmiir kwoɨnɨn bɨ kisɨna haigikɨm mɨ sɨma Adi Komii siiram panɨɨnsi yaɨngwo tɨbmiisi. Mɨ Adi Komii siya sɨmiir dimɨn biyɨeyɨm sɨmiir panɨɨnsi haiyoprimdiyɨumiigisi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Mɨ Jisɨs siya sɨmiir boɨnki, kɨma ta boɨniyɨo yai kwɨra saiir bɨ nɨnoknɨnkɨnkɨm, aniya? Mɨ kɨma wɨ panɨɨna sɨbgu owomwarkai boɨn haigɨnɨuwi tɨ boɨniyɨo yai whɨekakɨm sɨmiir yaimwowɨm, ha? ");
INSERT INTO iws_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kara kɨmiir nikɨ boɨnmauu wakaeki, tɨkɨ inkamɨn witnid nɨtkɨnɨn ɨni tɨkɨ inkamɨn Adi Komii siir yai boɨnmɨmauuwiyɨn ɨni siir hɨriinan ywowɨn. ");
INSERT INTO iws_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Iikam nhɨrɨm sɨma Adi Komii siir yaiya pa wakae nami mɨpi sɨma siyɨu hɨr napami mɨpa naɨngwo ouwouami Adi Komii siir yaiya. Sɨma Adi Komii siir yaiya panaowar wakaenaki mɨ Setan siya panaowar swokɨ kwɨtkigi Adi Komii siir yaiya sɨmiir kwoɨnau haiginama. Mɨ tɨkɨ iikamɨm ɨni tɨ witnidɨn siyɨu nɨkɨiyɨm, sɨbgu whak karamae nwowiyɨm, ɨni sɨmiir hɨriinan ywowɨm. ");
INSERT INTO iws_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Iikam nhɨrɨm sɨma ɨni tɨ witnidɨn siiyakak nuɨn, siir nakaigaiyɨm mɨ sɨma tɨ iikamɨm ɨni hɨriinan ywowɨm. Yaiyɨm sɨma wakaeyɨm pa wakae nɨngruramsasaugi, ta Adi Komii siir yaiya sɨmiir mhɨi kwoɨnau. Mɨ sɨma pɨ maɨrgɨmaɨrgar nwo nami, ta yai aiiramɨn. ");
INSERT INTO iws_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tɨkɨ iikamɨm ɨni witnidni mɨiyɨm aowa nam karamae nwowiyɨm, ɨni sɨmiir hɨriinan ywowɨm. Mɨ sɨma panɨɨnsi ywokwo bripriisi. Mɨ ɨiya hɨkɨn nɨmbiniiyɨm sɨmiir kɨnankɨuwam mɨ sɨma wɨ ɨi prɨei nokwo rani. Mɨ sɨma Adi Komii siir yai aiirɨn wɨ digɨumii haigɨngigi. Mɨ sɨma whɨekakɨm wa nɨkiiyam ɨuguskii. ");
INSERT INTO iws_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mɨ iikam nhɨrɨm ɨni tɨ witnidɨn maeyauwa urid amrɨdkakɨn siya nwowa saiir nakaigaiiyɨm ɨni sɨmiir hɨriinan ywowɨm sɨma wakaeiyɨm Adi Komii siir yaiya. ");
INSERT INTO iws_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Mɨ sɨmiir kwoɨnɨn ɨni umɨrmɨnɨm mɨ nuan digworaekwowɨm ɨni sɨma kiyainamɨm. Mɨ ta Adi Komii siir yai kɨbiya ɨni tɨ digworaekwo ɨmar higrɨnɨugiya. Mɨ Adi Komii siir siyɨuɨn siir panɨɨnsi sɨbgu apsi. ");
INSERT INTO iws_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mɨ iikam nhɨrɨm ɨni tɨ witnidɨn nu maeyau mɨiyɨk nɨkiiyɨn, ɨni siir hɨriinan ywowɨm. Sɨma ɨna sɨbgu wakaeyɨm Adi Komii siir yaiya. Mɨ sɨmiir nhɨrɨm kam nwɨr ɨuura mɨ budi mɨ nhɨrɨm pɨ kam nwoɨma mɨ budi mɨ nhɨrɨm pɨ kamaɨrɨm ɨriiyara mɨ budi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Mɨ Jisɨs siya sɨmiir boɨnki mɨ ɨiya inkamɨn yɨukɨdɨn nɨuyaiyɨn siir hangɨmunanii mɨ siya wɨ two aowa haigiprakaii, iyɨe? Wɨ hɨi aowa haigiprakaii, aniya? Nɨɨngaka. Kɨra bopwonauan romyasɨn siir dinankɨi! Mɨ yɨukɨdɨn pa sɨbgu ɨuyakii. ");
INSERT INTO iws_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tɨkɨ inkamɨn siir kwoɨnpai kwoɨnpaiyɨm tariinanɨn tɨkɨ idowɨiya nwo karam nwowɨm mɨ mhoɨiya sɨma wɨ idowɨiya nwo ɨuguskii mɨ wɨ dimɨn whɨrkɨn swokɨ haigiprakai rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kɨma tɨ iikam whɨekakɨm kɨma wɨɨngakaɨrgɨm, kɨma timɨ wakae. ");
INSERT INTO iws_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Mɨ siya sɨmiirɨn ɨna swokɨ boɨnkiyɨn, yaiyɨm kɨma wakaeiyɨm kɨma sɨbgu daɨngworɨnukrɨpkai. Siyɨuɨn inkam nwɨrni kɨma tɨriyɨn mɨ Adi Komii siya kɨmiirɨn wɨ hɨriinan siyɨu ɨiirar swokɨ ɨnkɨn tɨri. ");
INSERT INTO iws_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mɨ inkam nwɨrɨn siya nɨnoknɨnkɨn mɨiyɨkakɨ nɨuwi mɨ mhoɨiya Adi Komii siya siirɨn wɨ hɨriinan nɨnoknɨnkɨn aiirar swokɨ ɨnkɨn ɨdu hauuraraokii. Mɨ inkamɨn nɨnoknɨnkɨn haɨmiisɨmakakɨ nɨuwi wɨ Adi Komii siya swokɨ haii. Mɨ siya wɨ nɨnoknɨnkɨn karamaeyar nwoɨuguski, wɨ haɨmii sɨma hai naowid rani. Nɨɨngakɨ nɨɨngakɨɨnga. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisɨs siya hɨnɨɨna boɨnkɨn, ɨiya Adi Komii siya iikamɨm mɨ digworaekwo whɨekakɨm sɨmiir bɨiyan nwowɨn, siya ɨni tɨ inkamɨn witnid nɨtkɨnamɨn mɨ siir numɨr aiir sɨbgu kɨgrɨraowɨn ɨni siir hɨriinan ywowɨn. Mɨ Adi Komii siya kɨmiirɨn wɨ hɨriinanar mɨ sɨbgu kɨgrɨraowi. Mɨ siir numɨran naeyɨm wɨ hoɨmgakar nɨmbiyami. ");
INSERT INTO iws_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mɨ ɨinokɨinokɨn tɨ inkamɨn nɨiyaka pɨ nhwo nɨb whwonkaowi mɨ nugakɨn siya pa nɨnsiin aprɨrɨramyakwoki. Tɨ inkamɨn siya kɨgiyɨn mɨ siya ɨni siya siyar yaɨngwowɨn, tɨ witnidɨn siya komii panɨɨna nwokikɨn, siya bɨri nɨnoknɨnkɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nu siya mɨnki mɨ tɨ witnidɨn pa kɨnan grɨmgrɨnkɨigi mɨ siya mhoɨiya pɨ nae kakar namwo ɨuwi. Bɨi pɨ kwo aeyar nɨmbiyami mɨ mhoɨiya nae pa budgi. ");
INSERT INTO iws_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ɨiya sasaeyɨm wai nwowiyɨm mɨ tɨ inkamɨn pa nɨngugu haii. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Mɨ Jisɨs siya boɨnki, krɨma Adi Komii siir iikamɨm mɨ siir digworaekwo whɨekakɨm sɨmiir bɨiyan iikam nwowi mɨ krɨma wɨ paka hɨnɨɨn boɨniyɨo yaiya sae nɨkri boɨni siirɨn. ");
INSERT INTO iws_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mɨ tɨ mastetnidɨn siir hɨriinan tɨ ɨkrii boɨn. Mɨ mastetnidɨn siya ɨkɨ paenid nhɨrɨm sɨmiir hɨriinan tani. Nɨɨngaka. Siya sapkɨsapisɨmkɨn komii rani, ara krɨnankɨn. Mɨ siir nidɨm kasa rani, hoɨmgakɨm. Mɨ Adi Komii siir isidɨn ɨni tɨ mastetnidɨn siir hɨriinan ywowɨn kasa rani, hoɨmgakɨm. ");
INSERT INTO iws_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mɨ inkamɨn tɨ mastetnidɨn siir nɨnkɨn dɨgiyɨn mɨ siya pa whakii mɨpi komiiyar namwo ɨuwi. Mɨ siya ɨkɨ sasae hoɨmgakɨm pɨ sɨmiira mrwɨi haiburgigi. Mɨ siya kwiya komii kakargɨn mɨ ɨpiyɨn mɨnɨm sɨmiir whɨeyɨm pɨ siir kwiya ɨmiirar mɨ haigii. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ɨiya sɨma Jisɨs siir boɨniyɨo yai ɨmiir nɨnoknɨnkɨnɨm mɨ mhoɨiya siya iikam ɨmiirɨn boɨniyɨo yai kasa bɨri boɨnkɨn, Adi Komii siir yaiyɨm. ");
INSERT INTO iws_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Dimɨnɨm siya boɨniyɨm pɨ sɨmiir boɨnɨnkɨi ɨuguski rani. Nɨɨngaka. Siya pɨ boɨniyɨo yai ara boɨnkii. Mɨ ɨiya siir kɨgna mɨriiyɨm kamɨm pɨ sɨma sɨma nwoki saɨkaɨn mɨ Jisɨs siya yaimwokɨyaimwowɨm pɨ hanɨɨngɨ boɨnɨski. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mɨ naɨowaka ta ɨiya aiirarɨn siir kɨgna mɨriiyɨm kamɨm siya sɨmiir boɨnki, krɨma pɨ whɨi yarmiya kigidamtɨbi. ");
INSERT INTO iws_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Mɨ sɨma ta iya Jisɨs siya nɨdwokaiya saiir kwɨriinam mɨ sɨma siir wara yɨuginam. Mɨ sɨma i nhɨrɨm ɨni warar yɨnkɨn kwɨrii namɨm. Mɨ iikam isid komiiyɨn sɨma siir haiburgigɨm mɨ sɨma ɨna yamɨm. ");
INSERT INTO iws_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mɨ opud komiiya ha hugnaniya mɨ hɨnɨn komiiya ha mɨ ɨt mɨ sɨmiir iyɨn ɨni wara kaibombokiigiyɨn, hɨnɨn aeya. Taka hɨnɨn opud komiiya prasaekɨ mɨ ɨuwi. Mɨ iya opa mɨrkɨmɨrkɨ nɨnkɨnɨm pariiparii. ");
INSERT INTO iws_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Mɨ Jisɨs siya iya saiir idao hɨr kikɨnanɨu whwonkaigɨn nhwo mɨpiyɨnanɨn siir. Mɨ sɨma siir yɨnɨdgu ɨnsiin mɨ sɨma ɨna boɨnɨm, hɨe! Tɨ krɨmiir Adɨn, krɨma pɨ inɨgak nwo rani, pɨ tɨrar nwomainainami. Mɨ tari kɨra krɨmiirsi naɨngwoyɨmiyok rani, aniya? ");
INSERT INTO iws_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Mɨ Jisɨs siya ha nɨnsiingiyɨn mɨ siya ɨo opud hɨnɨn sowiir ywoki. Mɨ siya ɨna boɨnkiyɨn, kowa dɨg dwoki! Mɨ Jisɨs siya hɨriinan boɨnkiyɨn, opuda ɨna dɨgiya mɨ opa hɨnɨn sɨmkɨ bɨri swokɨ ɨtkika, ɨni nɨɨngar ywomaigiya mokmokwaiga. ");
INSERT INTO iws_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Mɨ Jisɨs siya kamɨm siir kɨgna mɨriiyɨm sɨmiir boɨnki. Kɨma hɨnɨɨn dimusi nɨdidnanaekɨm, ha? Mɨ kɨma tari naɨngwo tɨbmii karamaekɨm ɨni nɨɨngar ywowɨm, aniya? ");
INSERT INTO iws_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Mɨ sɨma ɨni mounana siinkaokiyɨm mɨ nɨdid prasae bɨri kɨnkikɨm. Mɨ sɨmasɨmar yomboɨn amboɨna. Tɨkɨ inkamɨn siya yɨpɨkɨn tɨkɨ hɨnɨɨna tɨrɨn? Opud hɨnɨno ɨni siir yaiyar mɨ wakaeyoknakiyo? Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Sɨma whɨi yarmiiya hɨriir yɨmbiyam Garasa sɨmiir nu ɨiir. ");
INSERT INTO iws_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Mɨ ɨiya Jisɨs siya i aiir haiburgigɨn mɨ inkam nwɨrɨn uridyɨu biyɨekakɨn siya bɨri kɨmɨmɨnkikɨn ɨna yamɨn siirɨm mɨ tɨkɨ inkamɨn uridyɨu biyɨekakɨn siya maeyauwa inkam hangikaiiya saiir hɨr nwowikɨn. Siya saiir hɨrankɨ nɨtkɨn. ");
INSERT INTO iws_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Siya inkam haɨngikaiiya maeyauwa saiir whwonkaiigɨn. Inkam nwɨrkɨn siir nonkworɨnu dɨg nwo rani. Mɨ wɨeyɨn sopni siir mɨ udkikɨni wɨ ɨriipɨ hɨriinan, wɨ dɨg mɨ o rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ɨi kasa rani, sɨma siir ɨga ɨɨn ɨmiir udɨm wɨeyɨn sopni mɨ tɨdop mɨni ha mɨ kurɨmdɨnu. Mɨ tɨ dimɨn whɨso siir kogo, pɨ sowiirar mɨ ankabɨmbɨɨrnami. Siir kɨrɨeya prasae rani. Inkamkɨ siir nonkworɨnu mɨ siir udrɨnu dɨg nwo rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ɨinokɨinokɨn siya nɨi nabɨe pɨ inkam haɨngikaiiya maeyauwa mɨ mhɨu, pɨ hɨrar nwowi. Ɨkɨ siya kauwaryɨmyoknamiyɨm mɨ siiya pa hai pɨ siir pɨu aiirar nɨkrɨmkrɨpi. Mɨ siir pɨua nhɨe aunawaigɨ nwowi. ");
INSERT INTO iws_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Siya kɨgi Jisɨs siya aru hɨrar nwowɨn mɨ siya ɨna iwɨtnaniyɨn. Mɨ siya ɨni Jisɨs siir ɨgmiiga kingiina inɨ akai hɨuniyɨn. ");
INSERT INTO iws_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Siya ɨna kauwok boɨnkiyɨn, Jisɨs! Kɨra Adi Komii siir yɨnisɨmkɨn nɨnomor kouankɨn nɨtɨn kɨra kariirɨn dimu tɨram mɨni? Kara kɨriir nɨkopwaisɨsɨrki Adi Komii siir inɨg ɨiir, kɨra wɨ kariir kɨpi dirɨraerar bumbugi. ");
INSERT INTO iws_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Mɨ Jisɨs siya tɨ yɨu biyɨeyɨn siir pɨu nii okwokaiyɨn siir boɨnki, yɨu biyɨe, kɨra tɨ ɨuguski siir pɨu hɨrii kɨpi nwo. ");
INSERT INTO iws_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Mɨ Jisɨs siya srɨi, kɨriir inɨgɨn yɨpɨkɨn? Mɨ siya ɨna yowarkɨi boɨnɨn, krɨma hoɨmgakɨm. Mɨ kariir inɨgɨn siirɨn hɨnɨɨn asi dapkɨn, hoɨmgakɨm. ");
INSERT INTO iws_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Mɨ siya Jisɨs siiram kauwok boɨnanaeki, kɨra krɨmiir kɨpi nɨkropki ta nu maeyau aiir haiburgigɨm. ");
INSERT INTO iws_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Hu isid komiiyɨn mhɨusɨmɨn kingiin nwowɨn ɨni siir mhaeiyɨm. ");
INSERT INTO iws_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Mɨ yɨu biyɨe sɨma Jisɨs siirɨm kauwok boɨnanae, kɨra krɨmiirɨn tɨ huɨm sɨmiiram dɨkropki. Mɨ krɨma pɨ sɨmiir nii whwonkainami. ");
INSERT INTO iws_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Mɨ Jisɨs siya ɨni wadɨeya ywokiyɨn sɨmiirɨn. Mɨ tɨ yɨu biyɨeyɨm tɨ inkam ɨiir haiburgikɨn, ɨni hu sɨmiir pɨu ii whwonkainamɨm. Mɨ tɨ hu isid komiiyɨn sɨma mhɨu ɨiir haiburgigɨm mɨ sɨma ɨna iwɨt inɨwamwɨrkɨinaniyamɨm siiyɨenan ɨiir. Mɨ sɨma ɨg hɨnɨɨn bɨri niwɨt namkɨm, nhwo bɨdi kwɨsnamɨm. Mɨ sɨma ɨna iwɨt natatamɨm opa hɨriir. Tɨ hu whɨekakɨm hɨriigɨm, 2,000 kasaka rani, hoɨmgakɨm. Mɨ sɨma ɨni op aiir kwiyae aokaonamɨm. ");
INSERT INTO iws_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mɨ hu ɨmiir kɨgrɨraowiyɨm kamɨm sɨma ɨna yɨdamkiyɨm. Mɨ sɨma ha niwɨt amɨm mɨ ɨna boɨnmɨmauuamɨm om komii hɨran iikam ɨmiir mɨ omisɨsɨsmɨm tɨ om komii siir yaba nwowɨm sɨmiir hɨran iikamɨm sɨmiirɨn warar mɨ iwɨt boɨnmɨmauuam. Mɨ iikam whɨekakɨm ta maeyauwa hu ɨma nwowa saiir inɨ kɨgnaki mɨ dimɨnɨn Jisɨs siya tɨrɨn ta maeyau aiir. ");
INSERT INTO iws_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mɨ sɨma Jisɨs siir hɨriir yɨmbiyam mɨ sɨma tɨ inkam ɨiir inɨ kɨgɨu bɨiya yɨu biyɨe isid komiiyɨn siya nwowɨn. Bɨiya tɨ inkamɨn yɨuɨskak bɨri nwokɨn mɨ tariinanɨn siya yɨuɨs bɨdi kaiyɨn. Mɨ siir kwoɨnɨn ɨni hanɨɨngɨ yaɨngwo omokiyɨn. Mɨ siya hɨrar nɨdwowi mɨ iikamɨm sɨma siir kaowɨm mɨ sɨma ɨna yɨdidɨm siirsiyɨn. ");
INSERT INTO iws_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Mɨ iikam whɨekakɨm tɨ dimɨnɨn siir kɨgɨm mɨ sɨma ɨna yapboɨnmamauuamɨm tɨ dimɨnɨn tɨ inkamɨn Jisɨs siya haiswonɨskigiyɨn yɨu biyɨe bɨiya tɨ inkam ɨiir nwowɨn. Mɨ sɨma hu ɨmiir warar mɨ ɨkɨn boɨnmɨmauu. ");
INSERT INTO iws_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Mɨ iikamɨm sɨma Jisɨs siir boɨnki, kɨra tɨ krɨmiir nuɨn siir kɨpi nwo. Kɨra maeyau kwɨra damki! ");
INSERT INTO iws_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ɨiya Jisɨs siya i aiir kwɨriiyɨn mɨ inkamɨn bɨiya yɨu biyɨekɨ nwokaiyɨuɨn siya srɨi Jisɨs siir, Jisɨs, kara kɨnaka namam naɨngwowi? ");
INSERT INTO iws_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mɨ Jisɨs siya wadɨe bɨri nwokɨn siirɨn. Nɨɨngaka. Siya tɨ inkamɨn siir boɨnki, kɨra kɨriir omaka dam, kɨriir yopii yokman ɨmiiram. Mɨ kɨra sɨmiir tinɨ boɨnmɨmauuɨu digworaekwo hoɨmgakɨm Bɨiyan Inkam Komiiyɨn Jisɨs siya tɨrkiyɨm. Mɨ siya kɨriirsi naɨngwobumbugɨn. ");
INSERT INTO iws_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mɨ tɨ inkamɨn siya tɨ om ɨiir haiburgikɨn mɨ siya ɨna yamɨn. Mɨ siya nu Dikapolis hɨriir yɨmbiyam. Mɨ siya hɨran iikamɨm sɨmiir inɨ boɨnmɨmauuɨu dimɨnɨn Jisɨs siya tɨrkiyɨn siir. Mɨ iikamɨm sɨma hɨriinan wakaekiyɨm ɨni mouni hanɨɨna siinkaokiyɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Mɨ Jisɨs siya ha swokɨ iyɨkɨdamɨn whɨi saiir mɨrmiiya hɨriir mɨ iikam isid komiiyɨn sɨma ɨni saɨkar yamwomɨmɨrniyɨm whɨigbid hɨr. ");
INSERT INTO iws_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Inkam komii nwɨrɨn Adi Komii siir inɨg hainaniya omaka saiir kɨgrɨraowiyɨn mɨ siya ɨna yɨtɨn. Siir inɨgɨn Jairaskɨn. Mɨ siya Jisɨs siir kɨgɨn mɨ ɨna yamɨn mɨ ɨni ogmwo Jisɨs siir ɨgmiiga kingiinar inɨ hɨuniyɨn. ");
INSERT INTO iws_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Mɨ siya tɨ inkamɨn Jisɨs siirɨm srɨinanae. Kariir yɨnisɨm yɨnugiyɨna ɨni nao kingiinar nwowa. Kɨriir ɨɨna saiir winɨ hainiini saeya pɨ naonamisi mɨ saeya wadɨe nwokɨ owɨm. ");
INSERT INTO iws_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Mɨ Jisɨs siya Jairas saɨka asi namkɨn. Mɨ iikam isid komiiyɨn ɨni siir mhoɨiyar woknamɨm. Mɨ nhɨrɨm ɨni siir prɨska prɨska mɨiya yapamɨm. Mɨ Jisɨs siir wara bɨri kɨgwɨnkɨn, ɨni sɨmiirara kɨgwɨn ɨskiyɨn. ");
INSERT INTO iws_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mɨ wig ɨra hɨr nwowa saeya nhɨekɨ mɨ napɨdwodwomaimiiya, saiir bɨewiyɨm ɨuurwhɨs nhɨekɨ saeya napɨdwodwomaimiiya. ");
INSERT INTO iws_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Naeyɨugak inkamɨm kasaka rani, saiiram nankabgugunanaeyɨm. Mɨ ta wiga saiir umɨrɨm whɨsariiyar nɨuguguskɨm sɨmiirɨn. Mɨ saiir ma wadɨe bɨ swokɨ okika. Nɨɨngaka. Ma saiira ɨni komiiya yasae owɨuguskiya. ");
INSERT INTO iws_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ta wiga saeya Jisɨs siir yai aiir wakaewɨna mɨ saeya ha nɨtka siiramɨn. Mɨ saeya tɨ iikam isid komiiyɨn sɨmaka nɨtka. Mɨ saeya Jisɨs siir mhoɨiya yɨt mɨ saiir ɨɨna siir yɨuɨs aiir yaka onkwoki. ");
INSERT INTO iws_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Mɨ saeya saiir kwoɨn arar yaɨngwokwokai mɨ kariir ɨɨna pɨ siir yɨuɨs aiirara maka onkwokii mɨ kara pɨ wadɨeyar nwoki. ");
INSERT INTO iws_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mɨ bɨri kɨmɨmɨnkika saiir nhɨeya ɨna yɨnkisaenakiya mɨ saiir pɨua ɨni saeyar kɨnankɨugiya nɨsmikɨnkiya. ");
INSERT INTO iws_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mɨ Jisɨs siya ɨna yɨnoknɨnkɨnkiyɨn siir kɨrɨe nhɨrɨm namkiyɨm. Mɨ siya iikamɨm sɨmiir bopwoniya haimisiyao okwokaokiyɨn mɨ ɨna boɨnkiyɨn, yɨpɨkɨn kariir yɨuɨs aiir nonkwokiyɨn? ");
INSERT INTO iws_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Mɨ Jisɨs siir kɨgna mɨriiyɨm kamɨm sɨma boɨnki siir, kɨra kɨgi! Iikam isid komiiyɨn wasi kɨriirar nokwoyokaiyɨm mɨ krɨma wɨ panɨɨna nɨnoknɨnkɨni? Kɨra hɨnɨɨn dimusi boɨnkɨn, yɨpɨkɨn kariir nonkwokiyɨn? ");
INSERT INTO iws_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mɨ Jisɨs siya ɨna kaoyokiyokɨiyɨn tɨ inkamɨn siir nonkwokiyɨn siir kɨgsɨbgiyam. ");
INSERT INTO iws_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mɨ ta wiga saeya ɨna yɨnoknɨnkɨnkiya dimɨnɨn saiir tɨrkiyɨn mɨ saeya ɨni nɨdidkakar ywokiya, saiir kɨuɨm kɨrɨe bɨri nwokɨm. Mɨ saeya ha nɨta ogmwo ɨni Jisɨs siir ɨgmiiga kingiina inɨ akai kaiyɨrou hɨuniya. Mɨ saeya ɨna boɨnmauugiya digworaekwo hoɨmgakɨm siir. ");
INSERT INTO iws_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Mɨ Jisɨs siya ta wig aiir boɨnki, yɨnisɨm! Kɨriir naɨngwo tɨbmiiya kariir kɨrɨe aiiram naɨngwo tɨbmiiya, kɨriirɨn wadɨe saeya nwowaigɨnɨugika. Mɨ kɨra ha dam! Kɨriir kwoɨnɨn sɨbgu dwowɨpɨsunam mɨ kɨriir ma dɨg nwokɨ oki. ");
INSERT INTO iws_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Mɨ Jisɨs siir yaiya ha nikɨ boɨnɨn mɨ kam nhɨrɨm Jairas siir omaka hɨrankɨ nɨtkɨm mɨ sɨma yaboɨni siir, kɨriir yɨnisɨma bɨdi yaonama. Kɨra kɨigi wara inkamɨn nowamwarkaiyɨuwiyɨn saɨka hɨrii kɨpi nɨnkinanae. ");
INSERT INTO iws_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mɨ siya ta yaiya sɨma boɨna saiirɨn ɨni hindara wakaemumuɨn. Mɨ siya Jairas siir boɨnki, kɨra kɨpi nɨdid! Kɨra kariirɨmɨn hindarar daɨngwo tɨbmii ɨski. ");
INSERT INTO iws_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Mɨ Jisɨs siya iikamɨm sɨmiir yɨkɨdugig, sɨma pɨ saɨka kɨpi nam. Pita, Jems mɨ siir nomiiyau ɨeya Jon, Jisɨs saɨka sɨmasɨmar yɨnkɨn am. ");
INSERT INTO iws_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Mɨ sɨma Jairas siir omaka saiir nɨmbiyamɨm mɨ Jisɨs siya kɨgɨu, sɨma pɨ nankanɨnouwi, sɨma hɨnɨɨn bɨri nougɨm, wamkɨ kimaii, nhwokou nhwokouɨm ɨni warar youwonikiyɨm. ");
INSERT INTO iws_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Mɨ Jisɨs siya ha napnɨnopkainamɨn omaka apɨnaua hɨriir mɨ siya sɨmiir inɨ boɨnɨu, kɨma dimusi nankanɨnouwi ta yɨnisɨm aiirsiyɨn? Ta yɨnisɨma saeya bɨri naonamka. Nɨɨngaka. Saeya nhwo whɨni. ");
INSERT INTO iws_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mɨ sɨma yaibu siir yɨewaiyɨugi, Jisɨs siya iikam hoɨmgakɨm omakanau hɨr nwowɨm siya sɨmiir yɨkrop apniki. Mɨ Jisɨs siya mɨ saiir yopii ado sowawai mɨ kam nwoɨmɨm siir kɨgna mɨrii ɨkɨm, hɨriirɨn sɨmasɨmar youapnɨnopkainam maeyauwa yɨnisɨm aeya nwo aiirɨn. ");
INSERT INTO iws_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Mɨ Jisɨs siya saiir ɨɨna aiir yonkwoki mɨ ɨna boɨnkiyɨn saiirɨn, Talita kumi! Krɨma ta yaiya saiirɨn hɨnɨɨna boɨnkɨm, yɨnisɨm yɨnugiyɨn. Kara kɨriir boɨnki, kɨra dɨnsiingi! ");
INSERT INTO iws_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Mɨ bɨri kɨmɨmɨnkika ta yɨnisɨm yɨnugiyɨna ha nɨnsiin ɨdwokiya ɨna yaprɨrɨrama. Saiir bɨewiyɨm ɨuurwhɨsko. Mɨ sɨma tɨ dimɨnɨn siir kɨgɨm mɨ sɨma ɨni mouni hanɨɨna siinkaokiyɨm. ");
INSERT INTO iws_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Mɨ Jisɨs siya ɨna boɨnɨkɨdugiyɨn kɨma inkam nwɨr kɨpi boɨnmauu tɨ dimɨnɨn. Mɨ siya sɨmiir boɨnki, ta yɨnisɨm yɨnugiyɨna nae saiir tɨ hauu ae. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisɨs siya tɨ omɨn siir haiburgigɨn mɨ ɨni siir omkɨ om ɨiirar swokɨ amɨn. Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma ɨni saɨkar yɨnkɨn amɨm. ");
INSERT INTO iws_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Mɨ Juda sɨmiir ɨi komiiya Sabat, Jisɨs siya omaka yaimɨn dimɨn nɨdwokai wakaeiya saiir yapnɨnopkainam. Mɨ Adi Komii siir yaiya sɨmiirɨn hɨr inɨ boɨnmɨmauuɨu. Mɨ iikam kasa rani, siir yai wakaeyɨm mɨ sɨma mounan asi siinkaokikɨm. Mɨ sɨma boɨn, tɨkɨ inkamɨn ta nɨnoknɨnkɨna siir hɨr nwowa mɨ siya papi haigɨn, ha? Mɨ tɨ hɨnɨɨn dimɨn komiiyɨn siya panɨɨna tɨrkɨn, ha? ");
INSERT INTO iws_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Mɨ tari tɨ inkamɨn omaka mɨriiyɨn mɨ siya, aniya? Mɨ siya ɨni iikamɨm nuanɨm krɨmiir hɨriinan ywowɨn, aniya? Mɨ siya Jems siir yaowaekɨn, aniya? Mɨ Josis, Judas mɨ Saimon mɨ siir yokmanɨm sɨma ɨni krɨmaka tɨrar nwowɨm, aniya? Mɨ sɨma hɨriinan kwoɨn naɨngwowɨm mɨ ɨni sɨmasɨmar prɨiɨdwo boɨnaiyamɨm. ");
INSERT INTO iws_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Mɨ Jisɨs siya sɨmiir boɨnki, profet inkamɨn ɨkɨ siya hɨnda tɨnda namiyɨm sɨma siirɨn pɨ ha kɨgi, siya inkam komiigɨn. Mɨ siir omkɨ om hɨrɨn siir yopii adɨm mɨ siir ɨrɨpa o nhɨeyɨm yɨm sɨma pɨ ha kɨgi, siya inkam komii rani. ");
INSERT INTO iws_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mɨ siya dimɨn komii komii bɨ swokɨ mɨriigɨn siir om hɨrɨn. Nɨɨngaka. Mɨ siir ɨɨna sɨmiirɨn wɨ nhɨrmi arar hainiiwokmaigi, siya iikam homgak wao bɨri hainiiwokmaiigɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Mɨ Jisɨs siya iikamɨm sɨmiir kɨgiyɨn sɨma bɨri naɨngwo tɨbmiigɨm mɨ siya ɨni ɨɨngas arar pikrɨmgrɨbgiyɨn. Mɨ siya ɨni omɨm siir omɨn siir kingiin nwowɨm, ɨni sɨmiir yamɨn. Mɨ siya hɨran iikamɨm sɨmiir boɨnmɨmauuwam Adi Komii siir yaiya saiir. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Mɨ Jisɨs siya aposel kam ɨuur nwɨso sɨmiiram yɨkɨuna. Mɨ siya sɨmiirɨn nwonɨsa nwonɨsa yɨkropki. Mɨ siya sɨmiirɨn kɨrɨe ɨni warar yɨnkɨn hauugiyɨn, yɨu biyɨeyɨm sɨmiir nɨnɨmnɨskiiyam. ");
INSERT INTO iws_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Mɨ Jisɨs siya sɨmiir boɨnki, kɨma nae digworaekwo homgak kɨpi hainam. Kɨma pɨ paekopɨn hɨugwokwo apiyɨn siirara hainam. Mɨ umɨr mɨnɨm onau kɨpi haiginam. Nɨɨngaka. Kɨma pɨ kɨmiir pɨu nɨɨnga nɨɨnga dam! ");
INSERT INTO iws_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kɨma ɨga pa diyopkɨmkɨkɨunam. Mɨ kɨma yɨuɨsa koua niiya saiirɨn pɨ kwokwɨsa kɨpi niinam. Nɨɨngaka. Kwokwɨra diinam. ");
INSERT INTO iws_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mɨ Jisɨs siya yai kwɨra ɨna swokɨ boɨnkiyɨn aposel kamɨm sɨmiir, ɨiya nwɨsko mɨ apnɨmbɨiyami om hɨr mɨ inkam nwɨrkɨn ha boɨnwɨni, kowa ta omaka saiir unɨ oni mɨ yaeya omaka ɨram kɨpi swokɨ amɨmɨn. Nɨɨngaka. Ta omaka ɨrua kowa nwowa saiirara dwo krɨpkai kɨpi kisae kimrae. Mɨ ɨiya kowiir mɨiya dɨg nwokii tɨ om ɨiir mɨ kowa wɨ hanɨɨngɨ dam. Mɨ ta omaka aiirɨn wɨ hanɨɨngɨ haiburgig mɨ kowa wa dam. ");
INSERT INTO iws_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mɨ ɨiya kɨma om whɨr napnɨmbɨiyamiyɨm mɨ sɨma kɨmiir yai bɨri wakaekɨm mɨ kɨma tɨ om ɨiirɨn ha timɨ haiburgik mɨ yaeya om whɨram timɨ am. Mɨ sɨnɨm kɨmiir ɨga ɨmiir nwowɨm sɨmiirɨn wa dɨkrɨmkrɨnkiigig. Mɨ sɨma wa nwokɨ aɨngwowoknakiyɨm sɨmiir siyɨuɨn mɨiyɨk rani. ");
INSERT INTO iws_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Mɨ aposel kamɨm sɨma Jisɨs siir yai aiir wakae namɨm mɨ sɨma ɨna yamɨm. Mɨ sɨma ɨna yapboɨnmamauuwamɨm Adi Komii siir yaiya saiir, ɨkɨ omom omom ɨmiir. Mɨ sɨma boɨn, kɨmiir mhɨi kwoɨnɨm tɨ kisɨna haigi, hɨriiyar kɨpi nwokrɨpkai. ");
INSERT INTO iws_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mɨ sɨma yɨu biyɨe hoɨmgakɨm iikam ɨmiir nwowɨm sɨmiirɨn hanɨɨngɨ haiswonɨmnɨskɨiyam. Mɨ sɨma wa waekɨɨmnanɨn pɨ siirar mɨ iyopi iikam makak ɨmiirɨn mɨ sɨma pɨ wadɨeyar mɨ okii. Tɨ wa waekɨɨmnanɨn siir kɨrɨe rani, Adi Komii siir kɨrɨeya wadɨe saeyar nwowaigɨnɨuwi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tariinanɨn inkam komiiyɨn nu kɨgrɨraowiyɨn Herot siyar wakaewɨn, ta yaiya Jisɨs siir inɨgɨn omom omomɨm bɨdi yɨniyokɨiyɨn. Iikam nhɨrɨm sɨma boɨnki, Jonɨn op baptais haigɨnɨuwiyɨn iikam ɨmiir, siya bɨdi yɨnsiin ɨdwowɨn ɨe hɨrankɨn. Mɨ tɨ siya dimɨn komii komiiyɨm sɨmiir asi mɨ ɨnɨmnɨskii. ");
INSERT INTO iws_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mɨ nhɨrɨm sɨma boɨn mɨ tari Ilaijakɨn, aniya? Mɨ nhɨrɨm yɨm ɨna boɨnɨm mɨ tari tɨ profet inkamɨn bɨiyanɨn siya, aniya? ");
INSERT INTO iws_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ɨiya Herot siya Jisɨs siir inɨg ɨiir wakaewɨnɨn haigirɨrɨrniyɨn mɨ siya ɨna boɨnkiyɨn, bɨiya Jon siir nɨiyɨn kara bɨdi ikɨ kaigrɨp haiyɨn mɨ tariinanɨn siya ɨna swokɨ ɨnsiin ɨdwokiyɨn, aniya? ");
INSERT INTO iws_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Bɨiyɨn Herot siya kam nhɨrɨm sɨmiir nɨkropkikɨn Jon siir nonkworɨnuwam mɨ wɨeyɨnsopni kogrɨnukikaiyam omaka hɨuyokiyokaiya saiir hɨr hɨugrɨpkɨikikaiyam. Mɨ Herot siya tɨ dimɨnɨn dimusi bɨ tɨrkɨn, Herodias saiirsi tɨrkɨn. Mɨ Herodias saeya ɨo Jon saɨka nwoka. Saeya Filip siir wiga. Herot siir nomousɨmɨn. Mɨ ta Filip siir wiga ɨni Herot siya haɨnɨkɨi onkwona. ");
INSERT INTO iws_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Mɨ Jon siya Herot siir boɨnki, kɨra tɨ kɨriir nomousɨmɨn siir wiga saiir haɨnɨkɨi nonkwonaɨn yɨo tɨ hɨriinan siyɨuɨn mɨiyɨk rani. ");
INSERT INTO iws_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Mɨ Herodias saeya kwoɨn biyɨe Jon siiram ywo siir nɨsomaowam mɨ saeya dɨg bɨ nwoka. Nɨɨngaka. Dimusi rani, Jon siya ɨni omaka hɨuyokiyokaiya saiir nwokaiyɨn. ");
INSERT INTO iws_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herot siya Jon siirsi nɨdidigɨn. Siya ɨna nɨnoknɨnkɨnɨn Jon siya inkam wadɨekɨn, siya dimɨn whɨr bɨ swokɨ tɨrbusrankɨn. Nɨɨngaka. Siya inkam komiiyɨm sɨmiir siyɨu aka bɨ nantamyɨryɨrikɨn. Nɨɨngaka. Mɨ siya Jon siir asi kɨgrɨraokɨn. Mɨ siya siir yai aiir wakaeyɨn mɨ siya ɨna yaɨngwoyɨmiyokiyɨn. Siir kwoɨnɨn mɨiyɨk bɨri nwokɨn, siya ɨni hɨkak ywokiyɨn. ");
INSERT INTO iws_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herot siya nae komiiya kwɨra dirɨraerarkwokɨn ɨiya siir apugɨ naokainakiya saiir naɨngwokikɨn. Siya ta naeya inkam komiini mɨi mɨriiyɨm kamɨm mɨ inkam komiiyɨm omom omomɨm sɨm kɨgrɨraowiyɨm mɨ yaii nɨniiyɨm sɨmiir bɨiyan kamɨm mɨ nu Galiliyan inkam komii ɨkɨm sɨmiiram dirɨraerarkɨn. Herodias saeya Jon siiramɨn ɨi mɨiyɨk amar nikɨ oka Jon siir nɨsomaoamɨn. ");
INSERT INTO iws_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mɨ Herodias saiir yɨnisɨm yɨnugiyɨna ha napnɨnopkainaniya ta omaka nae naeya saiir mɨ saeya ɨni ɨg inɨ swaeniya. Mɨ Herot siya mɨ inkam komii komii nhɨrɨm saɨka naeyɨm sɨma ɨni maɨrgɨmaɨrga ywokiyɨm saiirɨmɨn. Mɨ inkam komii Herotɨn nu kɨgrɨraowiyɨn siya ta yɨnisɨm yɨnugiyɨna saiir srɨigi, kɨra dimuam naɨngwowi, ha? Kɨra kariir tɨ boɨnmauugi mɨ kara kɨriir nwokɨ hauugi. ");
INSERT INTO iws_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mɨ Herot siya ɨna yokopaisɨsɨrkiyɨn ad isao! Tɨ dimɨnɨn kara nɨmbinɨn mɨ kɨra kariiram boɨni dimɨn whɨr kɨriir hauuwam mɨ kara kɨriirɨn wa hauugii. Mɨ kɨra kariir nu mɨ kariir digworaekwowɨm sɨmiirɨm boɨni, bopwoniya kikɨntɨokiyam haɨmii kɨriir hauugiyɨm mɨ kara kɨriirɨn wa mɨ hauugi. ");
INSERT INTO iws_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mɨ ta yɨnisɨma ha napnaniyama mɨ ɨni saiir yopii aiir yani srɨinakiiya, kɨra pɨ dimu haiyam boɨni, ha? Mɨ yopiiya ɨna boɨnkiya, kɨra pɨ tɨ Jonɨn op baptais haigɨnɨuiyɨn pɨ siir mwo ɨiir kaigrɨp haiyam tinɨ boɨnɨu. Mɨ kɨra pa whainani kariirɨm. ");
INSERT INTO iws_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mɨ bɨri kɨmɨmɨnkika ta yɨnisɨm yɨnugiyɨna, tɨ inkam komiiyɨn nu kɨgrɨraowiyɨn Herot mɨ saeya siir boɨnki, kara mɨnam naɨngwowi, kɨra pɨ Jonɨn iikam baptais haigɨnɨuiyɨn siir mwowɨn pɨ mobmɨrni kaigrɨp haigɨnki mɨpi kariir whauugi. ");
INSERT INTO iws_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mɨ saeya hɨriinan boɨna mɨ tɨ inkam komii Herotɨn nu kɨgrɨraowiyɨn siir kwoɨnɨn ɨni hɨkakar ywokiyɨn. Mɨ siyar yaɨngwowarkaigi, kara bɨdi ikɨ ɨmbinkiyɨn mɨ iikamɨm saɨka nɨdwo aeyɨm sɨmiirsi warar mɨ aɨngwokɨn. Mɨ siya ta wiga saiir yai panɨɨnsi yɨriyɨu boɨnsi. ");
INSERT INTO iws_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Mɨ bɨ kɨmɨmɨnkɨn tɨ inkam komiiyɨn nu kɨgrɨraowiyɨn Herotɨn, siya ɨna yɨkropkiyɨn, inkam nwɨrɨn yaii nɨniiyɨn siir Jon siir mwo ɨiir ninɨ kaigrɨphainakiyɨm. Mɨ tɨ inkamɨn yaii nɨniiyɨn ɨna yamɨn, maeyauwa siir hɨugrɨpkɨikikaiya saiir. Mɨ Jon siir nɨi ɨiir inɨ kaigrɨphainaki. ");
INSERT INTO iws_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Mɨ Jon siir mwoɨn mobmorni haigɨnam. Mɨ siya ha hainaniyɨn mɨ ta yɨnisɨm yɨnkopaka saiir inɨ hauuni. Mɨ ta yɨn kopaka ya ɨni saiir apu aiir inɨ hauuɨua, saeya kɨgam. ");
INSERT INTO iws_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mɨ kamɨm Jon siir kɨgna mɨriiyɨm sɨma ta yai aiir wakaekiyɨm mɨ sɨma ɨna yɨtɨm Jon siir pɨuɨs biyɨeya saiir hainakiyam. Mɨ sɨma ɨe inɨ kikaiyɨu saiirɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mɨ Jisɨs siir aposel kamɨm ha swokɨ haiyɨug apnaniyɨm, sɨma ɨni saɨkar swokɨ amwoniyɨm. Mɨ sɨma siir inɨ boɨnmauuni mɨiyɨm sɨma mɨriinaniyɨm mɨ yaiyɨm sɨma boɨnmɨmauuɨm iikamɨm sɨmiir. ");
INSERT INTO iws_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Iikam kasa rani, haɨmii tamii nɨnap anapɨm. Mɨ Jisɨs siir aposel kamɨm mɨ Jisɨs siyar, sɨma naeni ɨi karamaeka. Mɨ Jisɨs siya sɨmiir asi boɨnkɨm, humbae! Krɨma nami maeyauwa iikam karamaeya saiir. Krɨma pɨu haɨmiisɨma nwokɨ siisi. ");
INSERT INTO iws_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Mɨ sɨma i aiir kwɨriiyɨm mɨ ɨna yamɨm sɨmasɨmar maeyaua iikam karamaeya saiir. ");
INSERT INTO iws_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mɨ iikam kasa rani sɨmiir kɨgwo kwɨriigiyɨm. Mɨ sɨma ɨna yɨnoknɨnkɨnkiyɨm sɨmiirɨn. Mɨ iikamɨm om komii komiiyanɨm ɨni ta maeyauwa saiirɨm yamɨm. Mɨ bɨi ɨni sɨmar iwɨt okwokwokɨnɨm. Jisɨs siya mɨ siir aposel kam ɨma, yɨm mhoɨiya yɨmbiyam. ");
INSERT INTO iws_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Mɨ Jisɨs siya mɨ siir aposel kam ɨma, sɨma ha nakuɨuɨm mɨ Jisɨs siya iikam hoɨmgakɨm sɨmiir kɨgɨn mɨ siya sɨmiirsiyɨn naɨngwoyɨmyok prasae bɨri kɨnkɨn. Sɨma sibsibnankɨm inkamkɨ bɨ kɨgrɨraowikɨm sɨmiirɨn. Nɨɨngaka. Mɨ siya sɨmiirɨn digworaekwo kasa bɨri nowɨmwarkaiyɨugɨn. ");
INSERT INTO iws_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ɨiya bɨeyɨn nɨkiiyamtɨbɨn mɨ siir aposel kamɨm sɨma saɨkar inɨ boɨnɨu, ta maeyaua inkam karamaeka, bɨe ɨsi nɨkiiyam kingiin nwowamtɨbɨn. ");
INSERT INTO iws_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kɨra iikamɨm sɨmiir dɨkropki sɨma pɨ hɨnda tɨnda nwokɨ amtɨbɨm ɨkɨ omɨm sɨmiir. Mɨ sɨma pɨ nae nwokɨ saɨn aeyamtɨbɨm. ");
INSERT INTO iws_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jisɨs siya sɨmiirɨn ɨna yowarkɨi boɨnkiyɨn, sɨmiirɨn nae kɨmar hauu ae. Mɨ sɨma Jisɨs siir boɨnki, kɨra mɨnam naɨngwowi krɨma umɨrɨm kamarɨm kam nwɨra K400.00 hainamɨm nae sɨmiir saɨn hauu aeyɨm, aniya? ");
INSERT INTO iws_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Mɨ siya sɨmiir srɨigi, kɨmiir waraurɨn naeyɨm pariiga nwowi, ha? Kɨma tikɨna kɨgnaki. Sɨma ninɨ kɨgnɨnoknɨnkɨnakiyɨm mɨ sɨma boɨn, krɨma bretɨm ɨriiyar mɨ anasu whɨs ha nwowi. ");
INSERT INTO iws_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Mɨ Jisɨs siya siir aposel kamɨm sɨmiir boɨnki, kɨma tɨ iikam isid komiiyɨn sɨmiir boɨnki sɨma maeyau maeyau dɨdwowam tɨb, ta ko kɨbi aiir. ");
INSERT INTO iws_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Mɨ sɨma hɨnɨɨn hɨnɨɨna yɨdwonam, nab whɨrɨn kamarɨm ɨriiyar (100) mɨ whɨrɨn, kam nwɨs ɨuur (50). ");
INSERT INTO iws_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Mɨ Jisɨs siya tɨ bret ɨriiyarɨm mɨ anasu whɨs ɨko, siya sɨmiir haiyɨn mɨ siya nɨnomor koua hɨriir kaoki mɨ ɨna boɨn wadɨekiyɨn. Mɨ siya bretɨn hanɨɨngɨn yɨinɨbɨmbɨr prɨigɨnki mɨ siya siir aposel kamɨm sɨmiir hauugi. Mɨ iikam ɨmiirɨn sɨma nwokɨ hɨd hauunamɨm. Mɨ anasu whɨso ɨriipɨ hɨriinanar mɨ tɨrki ɨna mɨ ɨnspɨmspak ɨnoop prɨigɨnkiyɨm. Mɨ ɨni iikamɨm sɨmiir swokɨ hɨd hauunamɨm. ");
INSERT INTO iws_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mɨ sɨma nae dɨg nwokiyɨm mɨ sɨmiir mhɨiyɨm ɨna yaekɨnɨugiyɨm. ");
INSERT INTO iws_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Mɨ sɨma bret anasu haɨmii haɨmiiyɨm ɨna yaepɨpɨru haigɨnkiyɨm. Mɨ nae haɨmii haɨmiiyɨm sɨma naepɨpɨru haigɨnkiyɨm, nɨbɨm ɨuur ɨsa swokɨ haiginam. ");
INSERT INTO iws_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Kamɨm tɨ bret anasu ɨmiir naeyɨm 5,000kɨm. Kasa rani. Hoɨmgakɨm. Mɨ wig yɨnɨm hɨr warar nɨnkɨn okɨm mɨ sɨma sɨmiir wara bɨri mwaɨngɨm. Kamɨm sɨmiirarar mwaɨngɨm. Jisɨs siir kɨrɨeya naeyɨm homgak saeya nwokikɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Mɨ Jisɨs siya kamɨm siir kɨgna mɨriiyɨm sɨmiir yɨkrop kwɨriigi sɨma i aiir kwɨriinamɨm. Mɨ sɨma siir bɨiya yamkwokɨn whɨi mɨrmiiya om Betsaida hɨriir iyɨkɨdam. Mɨ siya iikam isid komiiyɨn sɨmiir nɨkropkiyam warar mɨ aɨngwo. ");
INSERT INTO iws_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Siya iikamɨm sɨmiir nɨkropkiyɨn mɨ yɨo siya mhɨua hɨriir iiyam, siya nhwo hɨr inɨ kwɨsboɨnɨu. ");
INSERT INTO iws_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mɨ naɨowaka kamɨm siir kɨgna mɨriiyɨm ɨni whɨi hɨrar yakirɨrɨr mairɨbɨm. Mɨ Jisɨs siya ɨni whɨigbid hɨrar yokworɨbɨn. ");
INSERT INTO iws_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Mɨ siya kɨgi opud komiiya sɨmiir i aiir namɨtɨuwɨua, sɨma igwɨr hɨnɨɨn bɨri kignamkɨm mɨinan mɨrii idamkɨm. Mɨ ɨiya ɨmɨɨmar nikɨ oyakwoka bɨri nikɨ pɨrkɨn ɨuguskika mɨ Jisɨs siya opa saiir ɨda yapamyakwok sɨmiirɨmɨn. Siya mɨnam naɨngwokɨn, sɨmiir nap haiburgikam. ");
INSERT INTO iws_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Mɨ kamɨm siir kɨgna mɨriiyɨm sɨmar kɨgwɨn, siya whɨi aiirɨn op ɨdwowar nouwapniyakwoki. Mɨ sɨmiir kwoɨnɨm ha naɨngwokɨm, siya wraigɨ mɨ ɨuwi. Mɨ sɨma hanɨɨngɨ yɨnkau ankau siirsiyɨn. ");
INSERT INTO iws_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ɨiya sɨma siir kɨgwɨnɨm mɨ sɨma ɨna yɨdidwɨnɨm. Mɨ Jisɨs siya bɨri kɨmɨmɨnkɨn siya ɨna yanka boɨnkiyɨn, kɨma kɨpi nɨdid! Kɨma kɨrɨe dwowɨn! Karaɨrgɨn tɨ nɨtɨn. ");
INSERT INTO iws_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Mɨ siya i aiir kwɨriiɨuɨn mɨ siya ɨni sɨmakar ywowɨn. Mɨ bɨri kɨmɨmɨnkika opud komiiya ɨna dɨgiya. Mɨ sɨma ɨni mouni hanɨɨna siinkaokiyɨm. Mɨ sɨmiir kwoɨnɨm ɨni warar whrɨewhrɨekiyɨm. ");
INSERT INTO iws_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Sɨma bɨri naɨngwowoknakɨm tɨ bret anasuɨm Jisɨs siya hɨd hauuɨm iikam ɨmiir. Nɨɨngaka. Sɨmiir kwoɨnɨm ɨna nikɨ whrɨewhrɨe krɨpkaiyɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Mɨ sɨma whɨi aiir iyɨkɨdnaidam mɨ ɨni om Genesaret hɨran maeyau aiir yaka kuɨu. Mɨ sɨmiir iya hɨr yaka kunɨmborugig. ");
INSERT INTO iws_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ɨiya sɨma i aiir haiburgika mɨ tɨ omɨn siir hɨran iikamɨm sɨma bɨri kɨmɨmɨnkɨm, Jisɨs siirɨn ɨna kɨgnɨnoknɨnkɨnwɨnɨm. ");
INSERT INTO iws_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Mɨ sɨmiir iikamɨm ɨna yɨtɨkrɨnkiyɨm om Genesaret siirar. Ta maeyaua sɨma kua saiirar bɨri nwokɨm. Mɨ ɨiya sɨma wakaekiya Jisɨs siya ɨni hapi nwowɨn mɨ sɨmiir iikamɨm makakɨm sɨmiirɨn hɨini yɨohaigɨnam. Mɨ sɨma ɨna hainamɨm siiram. ");
INSERT INTO iws_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Mɨ omisɨsɨm whɨekakɨm mɨ om komii ɨma mɨ tɨ omom omomɨm Jisɨs siya bɨdi yapyokɨi dɨgɨm. Mɨ sɨmiir makak iikamɨm maeyauwa iikam homgakɨ nɨnkɨnɨuwiya maket pɨ saiir hɨrar ninɨ haigɨnɨuwi. Mɨ iikamɨm tɨ makak iikam ɨmiir hainaniyɨm sɨma Jisɨs siiram yɨkɨugi, kɨra wadɨe sɨmiir nwokii mɨ tɨ iikam makakɨm sɨmiir ɨɨnɨm kɨriir yɨuɨs aiirarar pikɨ onkwokii mɨ sɨma pɨ wadɨeyar nwokɨ okiyɨm, aniya? Mɨ iikam hoɨmgakɨm siir yɨuɨs aiir nonkwowɨm, sɨma ɨni wadɨeyar ywowɨm. Mɨ sɨma whɨekakarɨn, ɨni wadɨekɨnar ywokiyɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisi kamɨm sɨma mɨ kam nhɨrɨm siyɨu komii nɨnoknɨnkɨni ɨkɨm, sɨma om komii Jerusalem hɨr haiburgigɨm mɨ sɨma ɨni Jisɨs saɨka yamwoniyɨm. ");
INSERT INTO iws_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Mɨ sɨma kɨg, kamɨm siir kɨgna mɨriiyɨm sɨma pɨ naei. Sɨma ɨɨna mɨn sɨmiirɨm bɨi bɨri hɨisokɨm mɨ sɨma krɨmiir yɨdiwi wanwiyaeyɨm sɨmiir siyɨu ɨiir bɨ sɨbgu apkɨm. Mɨ sɨmiir ɨɨnam mɨiyɨk bɨri nwokɨm. ");
INSERT INTO iws_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mɨ Farisi kamɨm mɨ Juda hɨran iikam homgak ɨkɨm, sɨma sɨmiir yɨdiwi wanwiyae sɨmiir siyɨu ɨmiirar nikɨ tɨrkrɨpkaiiyɨm. Ɨiya sɨmiir ɨɨna op hɨisok karamae nwowiyɨm, sɨma pɨ nae nikɨ ae rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ɨiya sɨma maeyaua nae haigɨniya maket saiir namiyɨm mɨpi sɨma nae saɨnaki mɨpa swokɨ ɨti. Mɨ naeyɨm sɨma hainaniyɨm sɨma pɨ op ninɨ hɨisokni karamae nwowi mɨ sɨma pɨ nae rani. Siyɨuɨm sɨma tɨriyɨm sɨma siyɨu whɨruwani bɨri tɨrikɨm. Nɨɨngaka. Sɨma sɨmiir yɨdiwi wanwiyaemi siyɨu ɨmiirar tɨrikɨm sɨmiir digworaekwowɨm. Mɨ sɨmiir digworaekwo whɨekakɨm hɨriiyar hɨisok dɨgikɨm. Mobmɨr mob mɨ yhɨi two ɨkɨm sɨma sɨmiirɨn bɨ swokɨ kɨmbuwikɨm. ");
INSERT INTO iws_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Farisi kamɨm sɨma mɨ kamɨm siyɨu komii nɨnoknɨnkɨni ɨkɨm mɨ sɨma Jisɨs siir asi srɨigɨm mɨ sɨma tɨ kamɨm kɨriir kɨgna mɨriiyɨm, sɨma krɨmiir yɨdiwi wanwiyaemi siyɨuɨm sɨmiir nap karamae dimusi nwowi? Sɨmiir ɨɨnam mɨiyɨk bɨri nwokɨm, sɨma ɨsi hɨriinanar nonkwo aeyɨm. ");
INSERT INTO iws_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Mɨ Jisɨs siya sɨmiir boɨnki, bɨiya Aisaia, profet inkamɨn siya ta yai aiirar nikɨ wɨn boɨnkikɨn kɨmiiramɨn. Kɨma nɨksɨsaeyakawaiwigɨm. Siir yokwowa hɨnɨɨna wɨn boɨnkika, tɨ iikam isidɨn sɨma kariir inɨg ɨiir hainanam boɨniyɨm, sɨma yai ara nhɨnkɨni. Sɨmiir kwoɨnɨm kanaka bɨri namasugɨm. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mɨ kamɨm sɨmiir siyɨu ɨmiirara boɨnmɨmauuwiyɨm mɨpa boɨni ta yaiya Adi Komii siirga. Mɨ sɨma kariir inɨgɨn whɨsariiya hainani mɨ sɨma kariir inɨg ɨiirɨm naɨngwo tɨbmii rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mɨ Jisɨs siya sɨmiir boɨnki, kɨma Adi Komii siir siyɨuɨn bɨdi haiburgigɨm mɨ ɨni kɨmiir yɨdiwi wanwiyaemi siyɨu ɨmiirar napɨm. ");
INSERT INTO iws_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Mɨ siya ɨna boɨn taraowamɨn sɨmiirɨn, kara ɨna nɨnoknɨnkɨnɨn kɨmiir nɨksɨsae siyɨuɨn. Mɨ kɨma hɨriiya naɨngwowi, tɨ sɨmiir siyɨuɨn siyɨu wadɨeyaɨrgɨn. Mɨ wɨm kɨma Adi Komii krɨmiir Wanɨn siir siyɨuɨn digɨumii siir haimriyɨugigi. ");
INSERT INTO iws_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mɨ panao kara pɨ kɨmiir siyɨu ɨiir boɨnmauu wakae haigɨnɨuwi. Bɨiya Moses siya hɨnɨɨna boɨnkɨn, kɨra, kɨriir yopii ado sowiirwai yai sɨbgu wakaeyokna. Mɨ inkamɨn siir yopii ad owiir nɨgbumbuwi mɨ siirɨn wɨ hindara dɨsomaokɨɨngi. ");
INSERT INTO iws_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mɨ panao kara pɨ kɨmiir siyɨu ɨiir boɨnmauu wakae haigɨnɨuwi. Bɨiya Moses siya hɨnɨɨna boɨnkɨn, wɨm kɨma hɨnɨɨna boɨnkɨm, inkamɨn umɨr digworaekwokakɨn mɨ siya wa hauuwi siir yopii ad owiirɨn. Nɨɨngaka. Siya wɨ hauu rani. Mɨ siya ha boɨni, tɨ umɨrɨn Adi Komiini umɨrkɨn kara pɨ kowiirwai swokɨ hauu rani. Nɨɨngakɨ, nɨɨngakɨɨnga. ");
INSERT INTO iws_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Mɨ siya tɨ inkamɨn wɨ sowiirwai whɨndirɨraerar haigɨnɨu rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mɨ kɨma kɨmiir yɨdiwi wanwiyaemi siyɨuɨm sɨmiirar napi mɨ kɨma Adi Komii siir yaiya saiir wakaeyɨm pɨ boriisopi. Mɨ kɨmiir siyɨu ɨmiirara napama naɨngwowi. Mɨ kɨma tɨ hɨriinan tɨrɨm mɨ kɨmiir kwoɨnɨm hɨnɨɨna naɨngwowi, kɨmiir siyɨuɨn kɨma tɨriyɨn wadɨeyaɨrgɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Mɨ Jisɨs siya iikam ɨmiir yɨkɨuna mɨ siya sɨmiir boɨnki, kɨma ta kariir yaiya saiirar wakae nonkworɨnugi. ");
INSERT INTO iws_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Dimɨnɨn inkam ɨeya nonkwo haiiyɨn mɨ ha naeiyɨn, yɨo inkamɨn ɨo siya bɨri hɨohaigɨnɨuwikɨn. Nɨɨngaka. Mɨ kwoɨn biyɨeyɨn inkam siir kwoɨnau nwokaiiyɨn yɨo nɨk rani, pɨ siya tɨrbumbugi inkam ɨiirɨn. ");
INSERT INTO iws_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Inkamɨn wɨɨnwo rino kakaɨrgɨn, siya yaimɨn dimɨnɨm ha wakaeyɨmok. ");
INSERT INTO iws_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Mɨ siya ha haiburgigɨn iikam isid komiiyɨn siir mɨ siya ɨna yamɨn omaka. Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma siir srɨi bɨiyan boɨniyɨo yaiya siya boɨna saiirɨm. ");
INSERT INTO iws_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Mɨ siya boɨnki sɨmiirɨn, wɨm kɨma wɨndi kɨmiir kwoɨnɨm bɨri naɨngwo omokikɨm, aniya? Mɨ kɨma tari bɨri nɨnoknɨnkɨnkɨm, dimɨnɨn inkam ɨeya nonkwo haiiyɨn mɨ ha naeiyɨn, yɨo inkamɨn ɨo siya bɨri hɨohaigɨnɨuwikɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tɨ hɨnɨɨn dimɨnɨm mhɨi kwoɨnan tani. Nɨɨngaka. Pɨ dini siyɨu siir namki. Mɨ mhoɨiya pɨ waisi hɨr ninɨ ɨugigi. Ta yaiya Jisɨs siya boɨna saiir yaimwokɨyaimwowa ya hɨnɨɨnga, ɨkɨ naepai naepaiyɨm dimɨn karamaekɨm kɨma sɨmiirɨn hɨriiya sɨbae sɨbae. ");
INSERT INTO iws_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Mɨ Jisɨs siya ɨna boɨntɨraowɨn, dimɨnɨn inkam siir mhɨi kwoɨnau nwokaiyɨm mɨpi idowɨiya nɨtinaka mɨ tɨ hɨnɨɨn inkamɨn pɨ mɨiyɨk nwo rani. ");
INSERT INTO iws_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Mɨ kwoɨn biyɨeyɨm inkamni mhɨi kwoɨnau nwokaiiyɨm mɨpi hɨranka hɨugrɨmkrɨpnanini mɨ inkam ɨiirɨn pɨ sɨmar tɨrbumbugi. Mɨ sɨma tɨ siyɨu biyɨeyɨm hɨnɨɨn hɨnɨɨngɨm, kwoɨn biyɨe naɨngwo, hɨi nanae mɨ hɨi tauae mɨ inkam nɨnɨtkikaigai aokao mɨ inkam siyamar naɨngwona. ");
INSERT INTO iws_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Wig haɨnɨkɨi nonkwona, kɨgmaɨr mɨ digworaekwo biyɨe biyɨe ɨkɨm mɨ nɨksasae mɨ hindara mwrakboɨn mɨ inkamɨn siyamar naɨngwonaeiyɨn mɨ nwɨrni dimɨn mɨ boɨnbu mɨ nantamyɨriyɨr mɨ whaowae dirɨraerar. ");
INSERT INTO iws_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tɨ digworaekwo biyɨe biyɨeyɨm inkam siir kwoɨnau hɨr nwokaiyɨm mɨ ɨiya sɨma idowɨiya nɨtiyɨm mɨpa boɨnɨski. Mɨ tɨ hɨriinan siyɨuɨn inkamɨn pɨ biyɨe sɨma nwowi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jisɨs siya ha nhɨɨngiyɨn mɨ tɨ om ɨiir haiburgig mɨ siya nu Taia hɨr nwowɨm omɨm sɨmiir yam. Mɨ siya omaka ɨra saiir yapnɨnopkainam. Mɨ siya pɨ boriisopi inkam nwɨrkɨn siir kɨpi nɨnoknɨnkɨn. Mɨ siya asi mɨ aguprakaiyɨm wɨ dɨg mɨ owi. Nɨɨngaka. Siya wɨ dɨg nwo rani. ");
INSERT INTO iws_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mɨ wig ɨra saeyar wakae Jisɨs siya ɨni tɨr nwowɨn mɨ ta wiga saiir yɨnisɨm yɨnugiyɨna yɨu biyɨeyɨn ɨni saiir hɨr nwokaiyɨn. Mɨ saiir apua bɨri kɨmɨmɨnkika ɨna yɨtsɨsaua Jisɨs siirɨm. Mɨ saeya ɨni siir ɨgmiiga kingiinar inɨ akai hɨuniya. ");
INSERT INTO iws_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Saeya ta wiga nu whɨranka saeya Juda wig rani. Saeya nu sɨm Finisia nu komii Siria hɨr nwowɨn mɨ siir hɨranka. Mɨ ta wiga saeya Jisɨs siirɨm srɨinanae saiir yɨnisɨm yɨnugiyɨna saiir nwowɨn yɨu biyɨeyɨn siir haiswonɨskigiyam. ");
INSERT INTO iws_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Mɨ Jisɨs siya saiirɨn boɨniyɨo yaiya saiir boɨnki, krɨma bɨiyɨn yɨnisɨmɨm sɨmiir naeyɨm sɨmiir tikɨ hauu ae. Krɨma krɨmiir yɨnɨm sɨmiir naeyɨm sɨmiir kɨpi haii mɨ wra kɨpi nɨtkɨnɨugi. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mɨ saeya ɨni siir yaiyaka yowarkɨi boɨna, Bɨiyan Inkam Komii kɨriir yaiya yaimwowaɨrga. Ɨkɨ wra sɨma kingiin nwowiyɨm mɨ naeyɨm pɨ yɨn ɨma nae krɨmkrɨnkiigii mɨpi wra ɨma nɨumɨmɨn aei. ");
INSERT INTO iws_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Mɨ Jisɨs siya saiir boɨnki mɨ kɨra ta hɨnɨɨna boɨna mɨ kɨra ha tɨ swokɨ am kɨriir oma hɨriir. Mɨ yɨu biyɨeyɨn kɨriir yɨnisɨma saiir nwowɨn diyɨo kara bɨdi hugɨtkɨigiyɨn. Mɨ kariir kɨrɨe aeyar nwo haigɨnɨugika kɨriir yɨnisɨma wadɨe asi nwokika. Mɨ kɨriir naɨngwo tɨbmiiya ɨni kɨrɨe ywowaowa. ");
INSERT INTO iws_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mɨ saeya ha swokɨ ama saiir omaka hɨriirɨn mɨ saeya inɨ kɨgɨu saiir yɨnisɨma hɨi hɨrar whɨni. Mɨ tɨ yɨu biyɨe saiir nwowɨn bɨdi yamɨgusamɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Mɨ Jisɨs siya ha haiburgigɨn nu Taia hɨran om ɨiirɨn mɨ siya om Saidon siir om bopwowar yapam. Mɨ siya ɨna swokɨ amɨn nu haɨmii komii whɨrɨn Dikapolis hɨriir. Mɨ siya whɨi Galilia hɨriir yapnɨmbɨiyam. ");
INSERT INTO iws_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mɨ sɨma inkam nwɨrɨn Jisɨs siirɨm yɨnkikwona apnam. Siya tɨ inkamɨn wɨɨngɨrwɨi waeyaigɨn. Mɨ sɨma Jisɨs siirɨm srɨinɨnae, siir ɨɨna tɨ inkam ɨiir hainiwokmaigiyɨm. ");
INSERT INTO iws_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Mɨ Jisɨs siya siir nɨkɨunamɨn mɨ iikam ɨmiirɨn hɨrar haiburgig. Mɨ ɨni sowa sowar inɨ owouwo. Mɨ Jisɨs siir ɨɨnan tɨ inkamɨn siir wɨɨn aiir yaka hopkaigi. Mɨ yaeyapa ha pɨbgɨnkiyɨn siir ɨɨna ɨiir mɨ ɨni tɨ waeyaiyɨn siir kwɨryae aiir yaka hougwokiyɨn. ");
INSERT INTO iws_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Mɨ Jisɨs siya nɨnomor kou hɨriir kaoki mɨ siya ɨna iyaenɨskiigiyɨn. Mɨ siir kwoɨnɨn ha naɨngwoyɨmiyokiyɨn mɨ siya siir boɨnki, Efata, ta yaiya Jisɨs siirar yaigɨnka. Mɨ krɨmiir yaiya hɨnɨɨna boɨnika, kɨra wakaeki! ");
INSERT INTO iws_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mɨ bɨri kɨmɨmɨnkɨn tɨ inkamɨn siir wɨɨna ɨna wakaeomokiya. Mɨ siir yaiya ɨna mɨ boɨnomokiya. ");
INSERT INTO iws_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Mɨ Jisɨs siya sɨmiir boɨnɨkɨdukikɨnki, kɨma tɨ dimɨnɨn inkam nwɨr kɨpi swokɨ boɨnmauumɨmɨn. Mɨ yɨm sɨma ta yaiya siya boɨn nɨkɨdukiya sɨmiir saiir bɨri swokɨ wakaekɨm. Nɨɨngaka. Yɨm sɨma tɨ dimɨnɨn ɨni siirar swokɨ haigirɨrɨr boɨnamɨm. ");
INSERT INTO iws_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mɨ sɨma ɨni hindara yanaakiyɨm mɨ ɨna boɨnɨm, digworaekwo hoɨmgakɨm siya tɨriiyɨm pɨ wadɨe kɨnar nwowi. Mɨ siya inkamɨn wɨɨngɨrwɨi nwowiyɨn siir mɨ dirɨraerari mɨ wɨ wadɨeyar mɨ okii. Mɨ siya inkamɨn waeyai nwowiyɨn siir mɨ dirɨraerari wɨ dɨgar mɨ owi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mɨ ta ɨiya iikam isid komiiyɨn ɨna swokɨnɨ oniyɨm mɨ sɨma nae karamaekɨm. Mɨ Jisɨs siya kamɨm siir kɨgna mɨriiyɨm sɨmiirɨm yɨkɨuna. Mɨ siya sɨmiir boɨnki, ");
INSERT INTO iws_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","kara tɨ iikamɨm sɨmiirsi naɨngwoyɨmiyoki ɨiyɨm kwoɨm sɨma kanaka nwokaigiyɨm. Mɨ sɨma nae karamae asi nwokɨm. ");
INSERT INTO iws_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mɨ sɨma mhɨirɨɨma nwowi mɨ kara sɨmiirɨn ha nɨkropki sɨmiir oma hɨriirɨn mɨ nhɨrɨm kingiinankɨ nɨtkɨ waeyao, yɨm wɨ siyɨu hɨr pɨ napakaigai yamisi. ");
INSERT INTO iws_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Mɨ kamɨm siir kɨgna mɨriiyɨm ɨna yowarkɨi boɨnkiyɨm siir yai aka, ta maeyauwa inkam karamaeka mɨ krɨma naeyɨm pɨ papiyankɨn mɨ ɨnkɨguna haii, tɨ iikamɨm sɨmiir hauu aeyamɨn? ");
INSERT INTO iws_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jisɨs siya sɨmiir srɨigi, kɨma bretɨm pariiga nwokaii? Mɨ yɨm ɨna boɨnkiyɨm, krɨma bretɨm ɨriiyar nhɨsa nwokaii. ");
INSERT INTO iws_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Mɨ siya iikamɨm sɨmiir boɨnki, nu ɨiir grɨnkɨn ɨdwokiyɨm. Mɨ siya tɨ bret ɨriiyar nhɨswo sɨmiir haiiyɨn mɨ Adi Komii krɨmiir Wanɨn siirɨm boɨn wadɨeki mɨ ɨna yɨinɨbɨmbɨrprɨigɨnkiyɨm. Mɨ siir kɨgna mɨriiyɨm kamɨm sɨmiir hauugi mɨ yɨm sɨma ɨna yapnɨnkwokwo hauuwamɨm iikam ɨmiir. ");
INSERT INTO iws_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mɨ sɨmiir antɨou sɨsɨmɨm ha mɨ haiyɨm mɨ Jisɨs siya Adi Komii siirɨmɨn sɨmiirɨm wara mɨ boɨn wadɨeki. Mɨ siya kamɨm siir kɨgna mɨriiyɨm sɨmiir boɨnki, sɨma antɨousɨsɨmɨm sɨmiirɨn warar mɨ hɨdnɨnkwokwo hauunamɨm. ");
INSERT INTO iws_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mɨ sɨma ha nae dɨgiyɨm mɨ sɨmiir mhɨiyɨm ɨna yaekɨnɨugiyɨm. Mɨ tɨ nae haɨmii haɨmiiyɨm sɨma naepɨpɨru haigɨnaowidɨm, nɨbɨm sɨmiir swokɨ haigiyɨm ɨriiyar ɨs. ");
INSERT INTO iws_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tɨ iikamɨm sɨma ɨrɨparɨn 4,000 kɨm kasaka rani. Mɨ Jisɨs siya sɨmiir yɨkropki mɨ sɨma ɨna yamɨm. ");
INSERT INTO iws_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Mɨ siya bɨri kɨmɨmɨnkɨn siir kɨgna mɨriiyɨm kamɨm sɨmaka kwɨrii namɨn i aiirɨn. Mɨ sɨma nu Dalmanuta hɨran maeyau aiirɨm yam. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mɨ Farisi kamɨm sɨma yai Jisɨs saɨkar yɨnkɨnwaomwarkɨi boɨn. Mɨ sɨma siirɨm boɨnki, kɨra nɨnomoran dimɨn komii komii nhɨrɨm krɨmiir wɨisiimauu mɨ krɨma nwokɨ ɨnoknɨnkɨni kɨra Adi Komii siir yɨnisɨmkɨn. Mɨ sɨma siiram kɨnankɨugɨm. ");
INSERT INTO iws_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Mɨ Jisɨs siya ha niyɨenɨskiigiyɨn mɨ siir pɨua ɨni hɨkak warar ywokiya. Mɨ siya ɨna boɨnɨn sɨmiirɨn, tɨ iikamɨm ta ɨi aiir nwowɨm, kɨma tɨ dimɨn komii komiiyɨm sɨmiir kɨgam dimusi kauwok boɨnanaekɨm, ha? Kara kɨmiirɨn tɨsa boɨnkiyɨn, kara wɨ yaeya dimɨn komii komii nhɨrɨm sɨmiir swokɨ dirɨraerarki rani, tɨ iikamɨm ta ɨi aiir nwowɨm sɨmiiramɨn. Nɨɨngakɨ, nɨɨngakɨɨnga. ");
INSERT INTO iws_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Mɨ siya sɨmiir haiburgikɨn, ɨni i aiir swokani apni kwɨrii namɨn whɨi yarmiiya hɨriir swokɨ iyɨkɨdnaidamɨm mɨnkɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma pɨ naɨngwo owouugikɨm. Mɨ sɨma bretɨm wara bɨri nɨnkɨn hainanikɨm. Nɨɨngaka. Mɨ sɨma bretɨn hara nwokai twonau hɨrɨn. ");
INSERT INTO iws_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Mɨ Jisɨs siya sɨmiir boɨniyɨokɨn, kɨma sɨbgu mɨntɨrao! Farisi kamɨm sɨmiir dimɨnɨn bret niyopiiniyɨn yisɨn wɨ siir kɨpi kɨgna dirɨraerar. Mɨ Herot siirɨn ɨriipɨ hɨriinan. Mɨ kɨma tɨ sɨmiir hɨriinan siyɨuɨn siir kɨpi nap! ");
INSERT INTO iws_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Mɨ sɨma sɨma whrɨe boɨnam, krɨma bret karamaekɨm mɨ siya ta yai hɨnɨɨna krɨmiir asi boɨnkikɨn. ");
INSERT INTO iws_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisɨs siya ɨna nɨnoknɨnkɨnɨn siyɨu biyɨeyɨn inkam nhɨrɨm sɨma tɨriyɨn. Mɨ siya sɨmiir boɨnki, kɨma hɨnɨɨn yai dimusi whrɨe boɨni, krɨma bret karamaekɨm? Mɨ kɨma tari bɨri naɨngwowoknakɨm? Mɨ tari kɨmiir kwoɨnɨm ɨni hu habni kwoɨnan ywowɨm, aniya? ");
INSERT INTO iws_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kɨma nhwokakaɨrgɨm mɨ kɨmiir nhwoɨm tɨ digworaekwo ɨmiir kɨg rani, aniya? Kɨma wɨɨngakaɨrgɨm kɨmiir wɨɨnɨm wakae rani, aniya? Mɨ tari kɨmiir kwoɨnɨm ɨni yaɨngwo owouu ɨuguskiyɨm, aniya? ");
INSERT INTO iws_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Mɨ ɨiya kara nɨinɨbɨmbɨr prɨigɨnɨm bret ɨriiyarɨm 5,000 iikamɨm sɨmiirɨm mɨ kɨma nɨbɨm pariiga haigii tɨ bret haɨmii haɨmiiyɨm kɨma naepɨpɨru haigɨnɨm? Mɨ sɨma boɨn, nɨm krɨma nɨbɨm ɨuur ɨsa yae haigi. ");
INSERT INTO iws_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Mɨ ɨiya kara nɨinɨbɨmbɨr prɨigɨnɨm bret ɨriiyar nhɨswo 4,000 iikamɨm sɨmiirɨm, kɨma nɨbɨm pariiga yɨu haigi tɨ nae haɨmii haɨmiiyɨm kɨma naepɨpɨru haigɨnɨm? Mɨ yɨm ɨna boɨnɨm, krɨma nɨbɨm ɨriiyar ɨsa yae pɨpɨru haigi. ");
INSERT INTO iws_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Mɨ Jisɨs siya sɨmiir boɨn mɨ kɨma tari kariir kɨrɨe aiir bɨri nɨnoknɨnkɨnkɨm, aniya? Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Mɨ sɨma om whɨrɨn Betsaida hɨriir yɨmbiyam. Mɨ hɨran inkam nhɨrɨm sɨma inkam nhwokwɨsae nwɨrɨn Jisɨs siiram yɨnkikwona apnam. Mɨ sɨma Jisɨs siirɨm boɨnki, kɨriir ɨɨna tɨ inkam nhwo kwɨsaeyɨn siir donkwoki. ");
INSERT INTO iws_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Mɨ Jisɨs siya siirɨn om mwɨsa hɨriir yɨnkikwona apnam. Mɨ siirɨn hanɨɨngɨn yasaigɨnɨugi Jisɨs siya. Mɨ siya siir ɨɨna siir yaka onkwoki mɨ siya ɨna srɨigiyɨn siirɨn, kɨra digworaekwowɨm ɨna kɨgomokiyɨm iyɨe? Nɨɨngaka. Aniya? ");
INSERT INTO iws_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mɨ tɨkɨ inkamɨn siir nhwonaɨn ɨna kɨgomokiyɨn. Mɨ siya boɨn, kara inkam nhɨrɨm sɨmiirɨn ɨna kɨgɨm. Mɨ siya boɨn, kara sɨmiirɨn paenan kɨgi mɨ sɨma ɨna naprɨrɨrɨm. ");
INSERT INTO iws_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Mɨ Jisɨs siya ɨɨna ɨna swokɨnɨ onkwoniyɨn tɨ inkamɨn siir nhwo ɨiir. Mɨ taka ɨiya tɨ inkamɨn ɨni hanɨɨngɨ sɨbgu anaokɨgomokiyɨn. Mɨ siir nhwonaɨn ɨni bɨimiyakɨnkiyɨn. Mɨ digworaekwo hoɨmgakɨm siya kɨgiyɨm waugɨ bɨri kimɨrkaigikɨm. Nɨɨngaka. Ɨni idowɨiyar ywokiyɨm. ");
INSERT INTO iws_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Mɨ Jisɨs siya ɨna yɨkropkiyɨn siir omaka hɨriir. Mɨ siya ɨna boɨnkiyɨn, kɨra pɨ om hɨr kɨpi swokɨnɨ aprɨrɨr ɨu. Pɨ kɨra namkɨn mɨpi kɨriir omaka dapiiyam ɨuguski. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisɨs siya kamɨm siir kɨgna mɨriiyɨm sɨmaka nhɨɨnam, tɨ omisɨsɨmɨm tɨ om komii sowiir kingiin nwowɨm, Sisaria Filipai sɨmiirɨm yam. Mɨ Jisɨs siya siyɨu hɨrar yap srɨi yam kamɨm siir kɨgna mɨriiyɨm sɨmiir, iikamɨm sɨma kariirɨn panɨɨna naɨngwokɨm, ha? ");
INSERT INTO iws_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Mɨ sɨma siirɨn ɨna boɨnkiyɨm, nhɨrɨm kɨriirɨn hɨnɨɨna dapikɨm, kɨra Jonɨn baptaisiyɨn siya. Mɨ nhɨrɨm hɨnɨɨna dapikɨm Ilaija mɨ nhɨrɨm sɨma hɨnɨɨna boɨni, kɨra profet inkamkɨn. ");
INSERT INTO iws_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Mɨ Jisɨs siya sɨmiir srɨi mɨ wɨm kɨma kariirɨn panɨɨna naɨngwowi? Mɨ Pita siya siir yai aka hɨnɨɨna yowarkɨi boɨnki, ni kɨra Kraiskɨn, inkamɨn inkam whɨnkɨnsiis haigɨnɨuwiyn mɨ siya. ");
INSERT INTO iws_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Mɨ Jisɨs siya sɨmiir boɨnɨkɨdukikɨnki, kɨma tɨ dimɨnɨn inkam nwɨrɨn kɨpi swokɨ boɨnmauusran. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Mɨ Jisɨs siya hanɨɨngɨn boɨnmɨmauubwakainam kamɨm siir kɨgna mɨriiyɨm sɨmiirɨn. Mɨ siya boɨn, nɨnomor kou hɨrankɨ nɨtɨn inkamɨn karaɨrgɨn. Mɨ kara wɨ hɨk kɨmbɨpɨsu kasa hai rani. Mɨ inkam adiyaowaeyɨn siyɨu komii kɨgrɨraowiyɨm mɨ inkamɨn naemɨn krɨmiirsi nɨnkɨn ɨmiiyaeiyɨn Adi Komii siir pris mɨ kamɨm Adi Komii siir siyɨu komii ɨiir nɨnoknɨnkɨn ɨkɨm. Mɨ sɨma wɨ digɨumii kariir haimriyɨugigi. Mɨ kariirɨn wɨ sɨma nɨsomaoki. Mɨ ɨi kwoɨmaka kara wa swokɨ ɨnsiin ɨdwowi ɨe hɨrankɨn. Kara ɨni kɨmiir inkam komii yaunɨ oniyɨn mɨ ɨni inkam kɨɨnar swokɨ owɨn. Jisɨs siya hɨnɨɨna boɨnkikɨn. ");
INSERT INTO iws_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yaiyɨm Jisɨs siya boɨnɨm, siya bɨri nɨmprɨo boɨnkɨn. Nɨɨngaka. Siya ɨni idowɨiyar boɨnmauu wakaekiyɨn, siya bɨri nɨmprɨo boɨnkɨn. Nɨɨngaka. Mɨ Pita siya siir yɨkɨunanam mɨ siya ɨni siir yani ɨkɨuɨn. ");
INSERT INTO iws_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Mɨ Jisɨs siya ha haiyɨug kaokiyɨn kamɨm siir kɨgna mɨriiyɨm sɨmiir mɨ siya Pita siir ywo ɨo. Mɨ ɨna boɨnkiyɨn, Setan kɨra kariir digɨuwa damki! Kɨra Adi Komii siir bɨ nɨnoknɨnkɨnkɨn. Nɨɨngaka. Kɨra inkami kwoɨnɨn siirarar nɨnoknɨnkɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Mɨ Jisɨs siya iikam whɨekakɨm sɨmiirɨm yɨkɨuna, sɨma siirɨm nɨtɨm. Mɨ kamɨm siir kɨgna mɨriiyɨm sɨmiirɨm warar yɨnkɨn ɨkɨuna. Mɨ siya sɨmiir boɨnki, inkam nwɨrɨn kanakar nɨti mɨ siya siir digworaekwowɨm sɨmiiram kɨpi naɨngwokwonanae tɨ aɨngwo owou. Mɨ siya siir pɨu aiirsi kɨpi naɨngwoyɨmiyok mɨ siir pɨu hɨk kɨmpɨpɨsukak dwo. Mɨ siya tɨ paeyɨn hɨiniya nɨrɨo nɨnkɨnɨn kara haiyɨn siir hɨriinan hɨk aiir haii mɨ siya kariir mhoɨiya wɨ haɨni wɨt. ");
INSERT INTO iws_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mɨ inkamɨn siir pɨu aiirsiya naɨngwoyɨmiyoknanaeiyɨn mɨ tɨkɨ inkam hɨriinanɨn siya wɨ omwai waiya rani, siya wa kɨgugu ɨuguskii. Mɨ inkamɨn siyama naɨngwona karam nwowiyɨn mɨ naonam mɨnsi nɨdid karamae nwowiyɨn yɨo wɨ hɨriiyar nokwoyokiyokɨii. ");
INSERT INTO iws_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mɨ inkamɨn tɨ nuɨn siir digworaekwo hoɨmgakɨm sɨmiir haii mɨ siya ha nao nami mɨ tɨ digworaekwo whɨekakɨm siirɨn wɨ sɨmar whɨn dirɨraerar naowidi, aniya? ");
INSERT INTO iws_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tɨ inkamɨn digworaekwo hoɨmgakakɨn mɨ siirɨn wɨ sɨma swokɨ saɨniniyoknanaowidi omwai waiyamɨn? Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tɨ iikamɨm tɨkɨ nwowɨm sɨma siyɨu mɨiyɨk tɨr tani, sɨmiir ɨga hɨnda tɨnda nokwowikɨm mɨ sɨma Adi Komii siir yaiya digɨumii haigɨngigi. Mɨ inkam nwɨrɨn krɨmaka nwowi mɨ siya yaewan kɨndiyɨu wani mɨ siya kariir yai aiirɨn warar mɨ kɨndiyɨu wani. Karaɨrgɨn tɨ inkamɨn nɨnomor kouanɨn bɨiya kɨmiir tɨr nikaunɨ onakiyɨn. Mɨ mhoɨiya kara swokɨ ɨti nua tɨriir mɨ kara wɨ yamdiyar swokaunɨ kɨndiyɨu wani tɨ inkam ɨiirɨn. Mɨ ɨiya kara swokɨ ɨti mɨ wɨ kariir Adi Komiiyɨn siir dimɨn kɨrɨe komiiyɨn paenan nɨuwiyaiyɨn, wɨ saɨkar nɨnkɨn ɨti. Mɨ Adi Komii siir paekwosɨmɨn kɨntɨd kɨntɨdnanɨm nɨnomor kou hɨranɨm wɨ saɨkar nɨnkɨn owi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Mɨ Jisɨs siya sɨmiir boɨnki, kara kɨmiirɨn yaimwowa boɨnkii, tɨ kam nhɨrɨm krɨmaka nokwoɨm, sɨma wɨ nikɨ ao rani. Nɨɨngaka. Wa nikɨ owi. Mhoɨiya wa kɨgwɨni Adi Komii siya wɨ iikam hoɨmgakɨm sɨmiir Bɨiyan Inkam Komii nwowi sɨmiir kɨgrɨraowam. Mɨ siir kɨrɨeya wɨ warar nɨnkɨn ɨti. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Mhoɨiya ɨiyɨm ɨriiyar kwɨra yamki mɨ Jisɨs siya ɨna yɨkɨunamɨn Pita Jems mɨ Jon sɨmiirɨn. Mɨ sɨma mhɨu whɨrɨn siir iinainam. Tɨ mhɨuɨn haruwa rani, ɨni kougɨ kou hɨrar nwowɨn. Mɨ sɨmasɨmar inɨ owɨu tɨ mhɨu ɨiirɨn. Mɨ Jisɨs siir pɨua ɨna kisɨnakiya sɨmiir whwonkam ɨdar. Mɨ siya ɨni yaeya pɨu ywokiyɨn. ");
INSERT INTO iws_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Mɨ siir yɨuɨs mɨnɨm ɨni whɨsinan ywowɨm mɨ sɨma ɨni namnamiinan ywowɨm. Inkamkɨn hɨisokiyɨm yɨuɨsɨm hɨriinan whɨsinan bɨri swokɨ ɨmbiyamikɨm. Nɨɨngakɨ, nɨɨngakɨɨnga. ");
INSERT INTO iws_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mɨ Ilaija Moses sowa bɨdi bɨdinan inkamko mɨ sowa warar yɨmbiyam. Mɨ sowar inɨ kɨgɨu sowa Jisɨs saɨka boɨnai. ");
INSERT INTO iws_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita siya tɨ hɨriinan dimɨnɨn siir kɨgɨn mɨ siya ɨna boɨnkiyɨn Jisɨs siir, dimɨn taemɨn nowomwarkaiyɨuan inkam! Wadɨeka, krɨma tɨrɨrar nwowɨm mɨ krɨma amɨrɨm kwoɨma mɨrii ɨra Mosesnika mɨ ɨra Ilaijanika mɨ ɨra kɨriirga. ");
INSERT INTO iws_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Sɨma tɨkɨ kam nwoɨmɨm ɨni nɨdidkakar ywokiyɨm. Mɨ Pita siya taka yaiya nhɨɨn nhɨɨn asi boɨnkikɨn. ");
INSERT INTO iws_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Mɨ wau kwɨra ha nɨta sɨmiir yaunɨ kiikiirɨnuni. Mɨ yai kwɨra waunau hɨrar yɨmbiyamki ɨna boɨnkiya, tɨkɨnɨn kariir yɨnisɨmkɨn kariir kwoɨnɨn ɨni siiramar naɨngwokwonanaeyɨn, kɨma siir yaiya saiir wakae. ");
INSERT INTO iws_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma ɨna dikaoraekaokiyɨm mɨ sɨma inkam nwɨr bɨri nɨnkɨn kɨgɨm. Nɨɨngaka. Sɨma Jisɨs siirar kɨg, sɨmaka saɨsar nwowi. ");
INSERT INTO iws_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mɨ mhɨukɨu hɨr haiburgigɨm mɨ ha nɨuunaiiniyɨm mɨ Jisɨs siya ɨna swokɨ kauwok boɨn taraokiyɨn. Tɨ dimɨnɨn kɨma kɨgnamɨn wɨ inkam nwɨrni kɨpi swokɨ boɨnmauumɨmɨn. Nɨɨngaka. Kɨma kariirama tikɨ o. Inkamɨn nɨnomor kouankɨ nɨtɨn kariiram. Ɨiya siya naonami mɨ siya swokɨ ɨnsiin ɨdwowi ɨe hɨrankɨn mɨ wɨ hanɨɨngɨ boɨnɨnkɨi tɨ dimɨnɨn kɨma kɨgɨn. ");
INSERT INTO iws_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Mɨ sɨma ɨni ta yaiya saiirar yaɨngwokwokaiyɨm. Mɨ sɨmasɨmar boɨn, saeya ta yaiya ɨe hɨrankɨ nɨnsiin ɨdwonaniya saeya dimu yaiga, ha? ");
INSERT INTO iws_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Mɨ sɨma Jisɨs siir srɨi, sɨma tɨ kamɨm siyɨu komii nɨnoknɨnkɨnɨniyɨm sɨma hɨnɨɨn dimusi boɨnkɨm, bɨiyɨn wɨ Ilaija siya nɨti, ha? Mɨ inkamɨn krɨmiir whɨnkɨnsiisiyɨn Mesaia yɨo wɨ mhoɨiya nɨti, ha? ");
INSERT INTO iws_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jisɨs siya sɨmiir boɨnki, hɨiipa! Kaimwoaɨrga. Mɨ bɨi wɨ Ilaija siya nɨti digworaekwo hoɨmgakɨm sɨmiir dirɨraerarkwokɨnam. Yokwo Komiiya ya hɨnɨɨna boɨnka, tɨ inkamɨn nɨnomor kou hɨrankɨ nɨtɨn siya ɨriipɨ hɨriinan yaigakɨn. Ta Yokwo Komiiya saeya hɨnɨɨna boɨnkika, tɨ inkamɨn nɨnomor kouankɨ nɨtɨn, wɨ hɨkpai hɨkpai kasa hai rani. Mɨ sɨma siirɨn wɨ yai mɨiyɨk swokɨ boɨn tani, aniya? ");
INSERT INTO iws_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kara kɨmiirɨn tɨsa boɨnkiyɨn, Ilaija siya bɨdi yɨtɨn. Mɨ kamɨm sɨmiir kwoɨn ɨmiirarar napɨm mɨ sɨma siirɨn siyɨupai siyɨupai hanɨɨngɨ tɨrbumbunɨnkɨn haigɨnɨu. Mɨ Yokwo Komii saeya hɨnɨɨna boɨnka Ilaija siirɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mɨ tɨ kam nwoɨmɨm ɨna swokɨ ɨtɨm, tɨ kam nhɨrɨm Jisɨs siir kɨgna mɨriiyɨm sɨmiiram. Mɨ sɨma ɨni sɨmaka swokɨnɨ owɨuwɨm. Mɨ sɨma kɨg, iikam isid komiiyɨn sɨmakar nwowi. Mɨ kam nhɨrɨm Adi Komii siir yai nɨnoknɨnkɨniyɨm sɨma Jisɨs siir kɨgna mɨriiyɨm kamɨm, sɨmakar nɨnkɨnwamwarkɨi boɨni. ");
INSERT INTO iws_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mɨ tɨ iikam hoɨmgakɨm sɨma Jisɨs siir kɨgwɨnɨm mɨ sɨma ɨna yanaawɨnɨm. Mɨ sɨma siirɨm iwɨtnam. Mɨ sɨma siir inɨ boɨnɨu, hɨe! Akamwai! ");
INSERT INTO iws_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Mɨ Jisɨs siya kamɨm siir kɨgna mɨriiyɨm sɨmiir srɨigi, kɨma tɨ kamɨm Adi Komii siir yai nɨnoknɨnkɨniyɨm sɨmaka dimu yai boɨnaikɨm, ha? ");
INSERT INTO iws_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mɨ inkam nwɨrɨn tɨ iikam isid komiiyɨn sɨmakar nwowɨn mɨ siya Jisɨs siir yai aiir wakae boɨnki, hae, dimɨn taemɨn nowomwarkaiyɨuan inkam! Yɨnisɨmɨn yɨu biyɨe waeyai mɨkrɨmɨn ɨni siir nwowɨn. Mɨ kara siirɨn kɨriirɨm asi nɨkɨunanikɨn. ");
INSERT INTO iws_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ɨinokɨinokɨn tɨ yɨu biyɨeyɨn pɨ siir pɨu iiyam mɨ siirɨn pɨ siya nɨtɨrɨmtɨowi. Mɨ siir yaiya yaeyopa hapi whopiigɨ nakii ɨbɨrgɨni. Mɨ siya siir big ɨmiirar swokɨ aegiyɨmgiyɨki. Mɨ siir pɨua ɨkɨ kɨrɨe namwoɨuwiyɨm, swokɨ onkwo sɨpkaiyɨm. Nɨɨngaka. Mɨ kara kɨriir kɨgna mɨriiyɨm kamɨm sɨmiirɨm boɨnkɨn, tɨ yɨu biyɨe ɨiirɨn sɨma mɨ haiswonɨskiigiyɨm. Mɨ sɨma dɨg bɨri nwokɨm. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jisɨs siya ta yai aiir wakaeyɨn mɨ siya iikamɨm sɨmiir yaiyaka yowarkɨi boɨnki, kɨma tɨ iikamɨm naɨngwo tɨbmii karamaekɨm! Nɨɨngaka. Wɨm kɨma tɨ hɨnɨɨn hɨkɨm kariir hauuwi. Kara ɨiyɨm kɨmaka wɨ pariiga nwowi tɨ hɨk ɨmiir haiyɨm, ha? Kɨma yɨnisɨmɨn kariirɨm wɨkɨu nanani. ");
INSERT INTO iws_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Mɨ sɨma tɨ yɨnisɨmɨn Jisɨs siirɨm yɨkɨunani. Mɨ yɨu biyɨeyɨn Jisɨs siir kɨgɨn mɨ tɨ yɨnisɨm ɨiirɨn hanɨɨngɨ haigiɨtɨrɨmtɨo. Mɨ yɨnisɨmɨn nu ɨiirar yɨkiiwariyɨmiyokɨn mɨ ɨna diwartaewarnamɨn. Mɨ yaeyop biyɨeya hapi whopiigɨ nakii ɨbɨrgɨnkɨn siir yaiya. ");
INSERT INTO iws_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Mɨ Jisɨs siya siir ad ɨiir srɨigi, ɨiyɨm pariigɨm siya hɨriinan nwokaiyɨm, ha? Mɨ siir adɨn ɨna boɨnkiyɨn, ɨiya siya yɨnisɨm sapɨsapar nwowɨn saiirar nwobwakainakɨn. ");
INSERT INTO iws_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ɨinokɨinokɨn tɨ yɨu biyɨeyɨn siya haigiɨtɨrɨmtɨo nanaei siirɨn mɨ pɨ paeya mɨ ɨtkaigi mɨ pɨ opa mɨ ɨtmaigi siya siir tɨo aokiyamar tɨrkɨn. Mɨ kɨra dɨg nwowi mɨ kɨra krɨmiirsi daɨngwoyɨmiyok mɨ krɨmiir whɨndirɨraerar haigɨnɨu! ");
INSERT INTO iws_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jisɨs siya boɨnki siirɨn, hɨipa! Kaimwoka! Mɨ kɨra ɨna naɨngwo tɨbmiiyɨn siiramɨn, aniya? ");
INSERT INTO iws_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Mɨ tɨ yɨnisɨmɨn siir adɨn bɨri kɨmɨmɨnkikɨn ɨna kauwokiyɨn kara bɨdi yaɨngwo tɨbmiiyɨn mɨ kariir naɨngwo tɨbmiiya komii rani! Kɨra kariir naɨngwo tɨbmiiya saiir kɨnsiis haigɨnɨugi kɨrɨe nwokiyam! ");
INSERT INTO iws_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Mɨ Jisɨs siya kɨg iikam isid komiiyɨn namwoniyɨn. Mɨ siya tɨ yɨu biyɨeyɨn siir asi nɨkwao boɨnkikɨn, kɨra tɨ yɨu biyɨe waeyai wɨɨngɨrwɨi tɨrbumbu haigɨnɨuwiyɨn kara kɨriir boɨnki, kɨra tɨ yɨnisɨmɨn siir dɨuguski. Yɨo hɨnɨɨn kɨpi tɨrbumbu haigɨnɨu. Mɨ kɨra siir pɨu kɨpi swokɨ omɨmɨn. ");
INSERT INTO iws_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Mɨ yɨu biyɨeyɨn ɨna dikauraekaukiyɨn. Mɨ siya tɨ yɨnisɨm ɨiir haigiɨtɨrɨmtɨogig. Mɨ siir pɨua ɨna yɨnkinɨmnɨsnakiya mɨ siya ɨna yamɨn. Mɨ tɨ yɨnisɨmɨn siir pɨua ɨni naoni pɨunan ywokiyɨn. Mɨ iikam nhɨrɨm sɨma boɨn, siya bɨdi yaonamɨn. ");
INSERT INTO iws_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mɨ Jisɨs siya siir ɨɨna aiir nonkwo kinɨnsiin okwokiyɨn mɨ siya ɨna yɨnsiin okwokiyɨn. ");
INSERT INTO iws_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mhoɨiya Jisɨs siya omaka namɨn mɨ kamɨm siir kɨgna mɨriiyɨm sɨma ɨna srɨiyɨm siirɨn, krɨma dɨg nwo karamae dimusi nwowi? Yɨu biyɨe sɨmiir nɨnɨmnɨskɨiyɨm, ha? ");
INSERT INTO iws_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Mɨ siya sɨmiir boɨnki, Adi Komii siirɨm srɨi boɨna sasaɨrga tɨ yɨu biyɨe siir nɨnɨskɨigiyɨn, dimɨn whɨrɨn dɨg nwo rani. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Mɨ sɨma tɨ om ɨiir haiburgigɨm mɨ nu Galili hɨriir yaprɨokɨinam. Mɨ Jisɨs siya pɨ boriisopi inkam nwɨrkɨn siir nɨnoknɨnkɨnɨm, maeyauwa siya nwowa. ");
INSERT INTO iws_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Mɨ siya kamɨm siir kɨgna mɨriiyɨm sɨmiirɨn hanɨɨngɨ sɨbgu siboboɨnɨu haigɨnɨu, inkamɨn nɨnomor kouankɨ nɨtɨn siirɨn wɨ siya nɨkropki sɨmiiram, sɨma nɨsom aokiyam. Mɨ siya ɨiyɨm wɨ kwoɨma nwokwowaki ɨenau hɨrɨn. Mɨ siya wa swokɨ ɨnsiin ɨdwowi. ");
INSERT INTO iws_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Mɨ sɨma bɨri nɨnoknɨnkɨnkɨm ta yaiya siya boɨna. Mɨ sɨma siir srɨiyam tɨrkɨm mɨ sɨma ɨni siirsi swokɨ ɨdidɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Mɨ sɨma om Kapeneam hɨriir yɨmbiyam. Mɨ sɨma omaka bɨdi yapnɨnopkainamɨm mɨ Jisɨs siya kamɨm siir kɨgna mɨriiyɨm sɨmiir inɨ srɨiyɨu, kɨma siyɨu hɨrɨn dimu yai napboɨnainikɨm, ha? ");
INSERT INTO iws_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mɨ sɨma ɨni yai mɨkrɨmar yokwonaɨnmɨmɨkɨm. Yɨm sɨma siyɨu hɨrɨn mɨn napboɨnainikɨm, yɨpɨkɨn krɨmiir kou nwowɨn, ha? ");
INSERT INTO iws_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Mɨ Jisɨs siya ha nɨdwowɨn mɨ siya kam ɨuurnwɨso siir kɨgna mɨriiyɨm sɨmiirɨm yɨkɨuna, sɨma nɨtɨm siirɨm. Mɨ siya ɨna boɨnkiyɨn, inkamɨn kɨmiir kou nwowam naɨngwowi mɨ siya wɨ siyamar kɨpi naɨngwona. Siya hɨnɨɨna daɨngwo, an kara iikamɨm sɨmiir aowa dwo. ");
INSERT INTO iws_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Mɨ siya yɨnisɨm sapɨsapɨn nwɨra yɨnkikwona apnani mɨ sɨmiir bopwoniya hɨrar inɨ okmwɨn okwoni. Mɨ Jisɨs siya yɨnisɨmɨn siir ɨɨna aiir yonkwo mɨ siya sɨmiir boɨnki, ");
INSERT INTO iws_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Inkamɨn kariirɨm naɨngwowi mɨ siya yɨnisɨm nwɨr kɨgrɨraowi mɨ siya kariirarar kɨgrɨrao haigɨnɨu rani. Nɨɨngaka. Siya Adi Komii siirɨn wara mɨ kɨgrɨraowi, siya nɨkropkikɨn kariirɨn mɨ kara ha nɨtkɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon siya Jisɨs siir boɨnki, dimɨn taemɨn nowamwarkaiyɨuan inkam! Krɨma inkamɨn nwɨra kɨgi, yɨu biyɨeyɨm sɨmiir nɨnɨmnɨskɨiyɨn kɨriir inɨgɨn siir kɨrɨe aiir. Mɨ siya krɨmaka bɨri namasugɨn mɨ krɨma siirɨn asi boɨnɨkɨdugɨn siya wɨ yɨu biyɨe pɨ nɨnɨmnɨskɨiisi. ");
INSERT INTO iws_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jisɨs siya Jon siir boɨnki, krɨma siir kɨpi nɨkɨdu! Inkam nwɨrɨn kariir inɨg ɨiir tɨri dimɨn komii whɨr mɨ siya kariirɨn wɨ yai biyɨe wara nɨnkɨn boɨn tani. ");
INSERT INTO iws_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Inkamɨn ɨo krɨmiir nwo karamae nwowiyɨn yɨo siya krɨmiir nomiiyaugɨn. ");
INSERT INTO iws_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kara kɨmiirɨn yaimwowar boɨnki, wɨm kɨma Kraisni isidgɨm mɨ inkam nwɨrkɨn kɨmiir hauu kwiyaei op mɨ tɨ inkamɨn digworaekwo wɨ ta mɨi aiirsi haii. Mɨ ta yaiya, ya yaimwoka. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Mɨ inkamɨn tɨ yɨnisɨmɨn siir whɨnkiyopsɨbgi haigɨnɨuwi, ta naɨngwo tɨbmiiya Adi Komii siiram saiirɨn mɨ bɨi siya mɨ aonami yai karamaeka. Mɨ tɨ hɨriinan inkamɨn siiramɨn siiya komii nhɨra hai siir nɨi ɨiir nomborugiyam. Mɨ siirɨn wɨ whɨi komii solwara hɨr tani omboru kimai whɨridgi. ");
INSERT INTO iws_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mɨ kɨra ha naɨngwowi ɨɨn kɨriira saiirɨn siyɨu biyɨe tɨ tɨrhaigɨnɨu mɨ kɨra saiirɨn kaigrɨp ɨtkiigi. Mɨ kɨra ɨɨna kwɨruwa sasa mɨ onami tɨ omɨn Adi Komii siya kɨgrɨraowiyɨn siir iikam whɨekak ɨmiir siirɨn wɨ wadɨeyar mɨ owi. Mɨ kɨriir ɨɨna kwɨso hɨriiyar nwokrɨpkaii mɨ wɨ siyɨu biyɨe sowa tɨri. Yɨo tɨ hɨriinan siyɨuɨn, siyɨu mɨiyɨk rani. Mɨ kɨriirɨn wɨ sowa nɨpiyaokɨinami maeyauwa paeya nɨutɨngi karamae nwowiya saiir hɨriirɨn. Mɨ tariigɨna ya mɨiyɨk rani. ");
INSERT INTO iws_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Mɨ ta maeyauwa saiir hɨran ɨiyɨm bɨri swokɨ aokaowikɨm. Nɨɨngaka. Mɨ wɨ inkami kɨp sɨma naei. Mɨ paeya hɨr mɨ ɨuiya, bɨri swokɨ ɨutɨngimɨmɨnika. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Mɨ kɨra ha naɨngwowi ɨga kɨriira saiirɨn siyɨu biyɨe tɨ tɨr haigɨnɨu mɨ kɨra saiirɨn kaigrɨp ɨtkaigi. Mɨ kɨra ɨga kwɨruwa sasa mɨ onami tɨ omɨn Adi Komii siya kɨgrɨraowiyɨn siir iikam whɨekakɨm sɨmiir mɨ siirɨn wɨ wadɨeyar mɨ owi. Mɨ kɨriir ɨga kwɨso hɨriiyar nwokrɨpkaii mɨ wɨ siyɨu biyɨe sowa tɨri. Yɨo tɨ hɨriinan siyɨuɨn, siyɨu mɨiyɨk rani. Mɨ kɨriirɨn wɨ sowa nɨpiyaokɨinami, maeyauwa paeya nɨutɨngi karamae nwowiya saiir hɨriirɨn. Mɨ tariigɨna ya mɨiyɨk rani. ");
INSERT INTO iws_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Mɨ ta maeyauwa saiir hɨran ɨiyɨm bɨri swokɨ aokaowikɨm. Nɨɨngaka. Mɨ wɨ inkam kɨp sɨma naei. Mɨ paeya hɨr mɨ ɨuiya, bɨri swokɨ ɨutɨngimɨmɨnika. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mɨ kɨra ha naɨngwowi nhwona kɨriirɨn siirɨn siyɨu biyɨe tɨ tɨr haigɨnɨu mɨ kɨra siirɨn habɨtkɨigi. Mɨ kɨra nhwona nhɨruwa sasar mɨ o nami, omɨn Adi Komii siya kɨgrɨraowiyɨn digworaekwo whɨekakɨm sɨmiir, wɨ wadɨeyar mɨ owi. Mɨ kɨriir nhwona nhɨswo hɨriiyar nwokrɨpkaii mɨ wɨ siyɨu biyɨe sowa tɨri. Yɨo tɨ hɨriinan siyɨuɨn mɨiyɨk rani. Kɨriirɨn wɨ sowa nɨpiyaokɨinami maeyauwa paeya nɨutɨngi karamae nwowiya saiir hɨriirɨn. Mɨ tariigɨna ya mɨiyɨk rani. ");
INSERT INTO iws_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mɨ ta maeyauwa saiir hɨran ɨiyɨm bɨri swokɨ aokaowikɨm. Nɨɨngaka. Mɨ wɨ inkam kɨp sɨma naei. Paeya hɨr mɨ ɨuiya, ɨriipɨ hɨriinan bɨ swokɨ ɨutɨngimɨmɨnika. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Paeya wɨ iikamɨm sɨmiir ɨdwowar nɨkrɨmkrɨnkɨnami wa krɨma nɨkrɨmkrɨnkɨniyɨn siir hɨriinan. ");
INSERT INTO iws_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Wa siya dimɨn wadɨekɨn. Mɨ wa siir hiiya dɨg nwokiiyɨm mɨ kɨma wɨ panɨɨna swokɨ tɨri tɨ waɨn siya hiigak swokɨ okiyɨm? Kɨmiir kwoɨnɨn hii karamae nwowiyɨn waɨn siir hɨriinan kɨpi nwo. Nɨɨngaka. Kɨma tɨ wa kɨbiyɨn hiigak nwowiyɨn naemɨn sɨbgu prɨdaeiyɨn mɨ krɨmiir kwoɨnɨm hɨriinan dwo. Mɨ kɨma, kɨmiir nomiiyauɨm sɨmaka kwoɨn hiinsɨma nwokɨ owi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jisɨs siya ta maeyau aiir haiburgigɨn mɨ siya ɨna yamɨn Judia sɨmiir nu komii ɨiir. Mɨ siya Jodan ɨe mɨrmii hɨran om ɨmiir yam hɨr nwo ɨmiir. Mɨ iikam hoɨmgakɨm ɨna swokɨ ɨtɨm ɨni saɨkar swokɨ amwoniyɨm. Mɨ siya ɨinokɨinokɨn sɨmiirɨn Adi Komii siir yaiyɨm bɨiya siya nikɨ owomwarkaiyɨuɨm mɨ ɨni sɨmiirar swokɨ owomwarkaiyɨuɨn. Siir siyɨuɨn hɨriiyar tɨrikɨn. ");
INSERT INTO iws_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Farisi sɨma ha nɨtɨm mɨ sɨma Jisɨs siiram inɨ ɨkɨunani. Mɨ sɨma siir srɨi, krɨmiir siyɨuɨn wadɨekɨ pɨ yamisi owɨn siir wig aiir sopkiiyɨm, aniya? Mɨ sɨma Jisɨs siiram kɨnankɨuwam tɨrkɨm. ");
INSERT INTO iws_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Mɨ Jisɨs siya ɨna yowarkɨi boɨnkiyɨn sɨmiir yai aiirɨn, siyɨu komiiyɨn bɨiya krɨmiir brougaeyɨn Moses siya hauugiyɨn krɨmiir mɨ siya panɨɨna boɨnkikɨn, ha? ");
INSERT INTO iws_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Mɨ sɨma boɨn, Moses siya wadɨe bɨdi ywokiyɨn. Inkamɨn yokwo wɨn hauugi siir wiga saiir sopkiyam mɨ saeya wa swokɨ ami saiir pomou adɨm. ");
INSERT INTO iws_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Mɨ Jisɨs siya sɨmiir boɨnki, kɨma pɨ nantamyɨriyɨrkɨm kɨmiir siyɨu ɨnakar. Mɨ Moses siya tɨ siyɨu komiiyɨn kɨmiirɨn yokwo hɨriinansi wɨn hauugikɨn. Siya Adi Komii siir siyɨukɨɨn tani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Bɨdi bɨdiniyarɨn Adi Komii siya nonkwokwokiyɨm digworaekwo hoɨmgakɨm mɨ siya ɨna yɨnkɨn onkwokwokiyɨm wigkam sowiirwai warar. ");
INSERT INTO iws_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Mɨ kamɨn siir yopii ad owiir asi haiburgigi mɨ siya siir wigaka asi namasu krɨpkaii. ");
INSERT INTO iws_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Mɨ sowa wɨ pɨu kwɨruwar nwowi. Mɨ sowa wɨ yapa yapa nwo rani. Nɨɨngaka. Siya mɨ saeya sowa wɨ hɨnɨɨna nwo rani, yapa yapa. Nɨɨngaka. Sowa wɨ pɨu kwɨruwar nwoɨski. ");
INSERT INTO iws_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Dimɨnɨn Adi Komii siya nokiyopmasugiyɨn inkamkɨ siir nɨkrɨpɨm wɨ dɨg nwo rani. ");
INSERT INTO iws_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Mɨ mhoɨiya sɨma omaka hɨriir swokɨ amɨm mɨ siir kɨgna mɨriiyɨm kamɨm sɨma srɨi siirɨn ta yai aiiramɨn. ");
INSERT INTO iws_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Mɨ siya sɨmiir boɨnki mɨ tɨ inkamɨn siir wig aiir sopkii mɨ siya yaeya wig nonkwonaei, yɨo tɨ kamɨn siir wig aiir sopgigɨn. Mɨ siya siir bɨiyan wig aiirɨn siyɨu mɨiyɨk bɨri tɨrkikɨn. ");
INSERT INTO iws_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mɨ wig ɨra saeya saiir kam ɨiir sopgigi mɨ yaeya kam ninɨ owɨuwi mɨ ta wiga saeya pɨ sopgika saiir kam ɨiirɨn. Mɨ ta wiga saeya saiir bɨiyan kam ɨiirɨn siyɨu mɨiyɨk bɨri tɨrgika. ");
INSERT INTO iws_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mɨ sɨma yɨnisɨm sapɨsap nhɨrɨm Jisɨs siirɨm yɨnkikwona apnani. Sɨma mɨnam naɨngwokɨm, siir ɨɨna sɨmiir nonkwokiyɨm. Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma ɨo sɨmiir ywoki. ");
INSERT INTO iws_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jisɨs siya hɨriinan kɨgiyɨn siir kwoɨnɨn mɨiyɨk bɨri naɨngwokikɨn. Mɨ siya sɨmiir boɨnki, kɨma tɨ yɨnisɨsɨmɨm sɨmiirɨn kariirɨm kɨgnɨnkɨnki yɨmbi nɨti kariiram. Kɨma sɨmiir kɨpi nɨkɨdu naowid. Adi Komii siir omɨn digworaekwo whɨekakɨm sɨmiir kɨgrɨraowiyɨn tɨ hɨriinan yɨnisɨsɨmɨm sɨmiirgɨn. ");
INSERT INTO iws_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kara kɨmiirɨn yaimwowa boɨni, inkamɨn Adi Komii siir omɨn digworaekwo whɨekakɨm sɨmiir kɨgrɨraowiyɨn siir namɨm naɨngwowi mɨ siir naɨngwo tɨbmiiya yɨnisɨm praigakni kwoɨnan dwo. Mɨ Adi Komii siya wɨ siirar sɨbgu kɨgrɨraowi. Mɨ siir kwoɨnɨn hɨriinan nwo karamae nwowi mɨ siya wɨ tɨ omɨn siir napnɨnopkainam tani. Nɨɨngakɨ. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Mɨ Jisɨs siir ɨɨna sɨmiir yonkwo. Mɨ siir ɨɨna ha nonkwowa mɨ siya sɨmiirɨn ɨna whɨnkɨnsiis haigɨnɨuɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jisɨs siya ha napnamɨn mɨ inkam nwɨrɨn siirɨm iwɨt nani. Mɨ siya ogmwo siir ɨgmiiga kingiina inɨ akai hɨuni. Mɨ siya siir srɨigi, dimɨn taemɨn nowomwarkaiyɨuwan inkam kɨbi! Kara wɨ panɨɨna tɨri kwoɨnbudɨn omwai waiyayokiyokɨiiyɨn ɨinokɨinok siir haiyamɨn, ha? ");
INSERT INTO iws_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jisɨs siya siir boɨnki, kɨra kariirɨn inkam wadɨe dimusi nɨkɨugɨn, kɨriir kwoɨnɨn ha naɨngwokɨn kanakanaɨrgɨ nɨuwi inkam wadɨeyɨn, aniya? Adi Komii sasaɨrgɨn inkam wadɨeyɨn. ");
INSERT INTO iws_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kɨra tɨ siyɨu komiiyɨn siir bɨdi yɨnoknɨnkɨnɨn: Kɨra inkam kɨpi nɨt mɨ wig kɨpi sop mɨ kɨra hɨi kɨpi tauae mɨ kɨra inkam nwɨrni kɨpi nɨksɨsae boɨn hɨuriyɨu. Mɨ kɨra kɨriir yopii adwo sowiirwai aowa dwo. ");
INSERT INTO iws_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mɨ tɨ inkamɨn siya Jisɨs siir boɨnki, dimɨn taemɨn nowomwarkaiyɨuwan inkam! Kara yɨnisɨm sapɨsapar nwonaniyɨn mɨ tɨsa nadɨgniyɨn. Kara tɨ siyɨu komiiyɨn siirar napikɨn. ");
INSERT INTO iws_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jisɨs siya siir kɨgɨn mɨ siir kwoɨnɨn ɨna yaɨngwo bunan siirsi. Mɨ siya siir boɨnki, dimɨnɨn whɨr tɨr karam kɨra nwowɨn. Kɨra kɨriir digworaekwo hoɨmgakɨm tinɨ hainaki inkam nhɨrɨm sɨma saɨnɨm. Mɨ kɨra umɨr sɨmiir haii mɨ wɨ inkam paeprikabɨm sɨmiir hauu. Mɨ mhoɨiya kɨra Adi Komii siir omɨn siya kɨgrɨraowiyɨn digworaekwo hoɨmgakɨm sɨmiir, siir hɨrɨn wɨ dimɨn mɨiyɨkakar mɨ owi. Mɨ kɨra kariir mhoɨiya wɨt. ");
INSERT INTO iws_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tɨ inkamɨn ta yai aiir wakaeyɨn mɨ siir whwonkamɨn mɨiyɨk bɨri swokɨ onamkɨn. Mɨ siir kwoɨnɨn ɨni hɨkakar ywokiyɨn. Mɨ siya hɨkak dimusi bɨri nwokɨn siir digworaekwowɨm kasakɨ waeyao. ");
INSERT INTO iws_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Mɨ Jisɨs siya ɨna kaoyokiyokɨigiyɨn. Mɨ siya kamɨm siir kɨgna mɨriiyɨm sɨmiir boɨnki, inkamɨn digworaekwo hoɨmgakakɨn siya wɨ mɨinan mɨriinami Adi Komii siir omɨn siya kɨgrɨraowiyɨn digworaekwo hoɨmgakakɨm siir napnɨnopkainamɨm. Whɨsarii rani, sɨmiir kwoɨnɨm ɨni sɨmiir digworaekwo ɨmar nwowɨm. Sɨma pɨ boriisopi inkam nwɨr hauuwɨm. ");
INSERT INTO iws_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma ta yai aiir wakaeyɨm, sɨma ɨni hinda yanaakiyɨm. Mɨ Jisɨs siya ɨna swokɨ owarkɨi boɨnkiyɨn sɨmiir yai aiirɨn, tɨ yɨnisɨsɨmɨm inkamɨn Adi Komii siir omɨn siya kɨgrɨraowiyɨn digworaekwo hoɨmgakakɨn sɨmiir kɨgrɨraowiyɨn siir hɨriir nami, siya wɨ mɨinan mɨrii nami. ");
INSERT INTO iws_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mɨ hab saeya tɨdiyɨnɨn yɨuɨs paniyɨn siir no ɨiir nɨnopkainamɨm wɨ dɨg nwo rani mɨ inkamɨn umɨr digworaekwo whɨekakakɨn siya wɨ ta haba mɨinan saeya mɨriiya saiir hɨriinan mɨi mɨrii rani. Nɨɨngaka. Siya wɨ mɨi komiigɨ komii mɨrii nami Adi Komii siir omɨn digworaekwo whɨekakɨm sɨmiir kɨgrɨraowiyɨn siir hɨriir namamɨn. ");
INSERT INTO iws_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma ɨni hindara yanaakiyɨm. Mɨ sɨma, sɨma sɨma yomboɨn amboɨnam mɨ hɨriinankɨ nɨuwi mɨ wɨ nhɨnga haii kwoɨnbudɨn omwai waiyayokiyokɨiiyɨn ɨinokɨinok, ha? ");
INSERT INTO iws_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Mɨ Jisɨs siya sɨmiir kaokiyɨn mɨ ɨna boɨnkiyɨn, inkam wɨ dɨg nwo rani. Adi Komii krɨmiir Wanɨn siya wɨ dɨgar nwowi. Adi Komii sasar whɨnkɨnsiis haigɨnɨuwi siirɨn, tɨ dimɨn taemɨnɨm. ");
INSERT INTO iws_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Mɨ Pita siya Jisɨs siir boɨnki, wakae! Krɨma digworaekwo hoɨmgakɨm bɨdi haiburgigɨm mɨ krɨma tɨsi kɨriir mhoɨiya nɨtɨm. ");
INSERT INTO iws_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Mɨ Jisɨs siya boɨn, kara kɨmiirɨn yaimwowa boɨni iikam whɨekakɨm kariirɨm naɨngwo tɨbmii mɨ ha haiburgigi tɨ digworaekwo hɨriinanɨm, omaka, nomiiyau yokman, apu, adi, yɨnisɨm mɨ numɨr ");
INSERT INTO iws_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","mɨ Adi Komii siya kɨmiirɨn wɨ hɨriinan, digworaekwo homgak ɨmiirar swokɨ hauu kɨiyɨuwi, kamɨm kariir kɨgna mɨriiyɨm kɨmiirɨn. Mɨ kɨma wɨ dimɨn kasa hai rani. Wɨ tɨ hɨnɨɨn digworaekwowɨm sɨmiir hai. Omaka nomiiyau, yopii, yokman, yɨnisɨm mɨ numɨr, taka ɨiya kam nhɨrɨm siyɨu biyɨe wɨ kɨmiirar mɨ tɨrbumbugi. Mhoɨiya kɨma wɨ kwoɨnbudɨn omwai waiyayokiyokɨiiyɨn wɨ siir haii. ");
INSERT INTO iws_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mɨ tariinanɨn kam nhɨrɨm inɨgak nwowɨm mɨ sɨma mhoɨiya sɨmiirɨn wɨ aowa nikworɨnugigi. Mɨ tɨ kamɨm aowa nwowɨm, mhoɨiya wɨ inɨgak sɨma nwowi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Sɨma om komii Jerusalem hɨriiram yapnam mɨ Jisɨs siya sɨmiir bɨiya yamkwokɨn. Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma ɨna yanaakiyɨm. Mɨ ɨni sɨma sɨmar yomboɨn ɨdidnamɨm. Mɨ iikamɨm sɨmiir mhoɨiya napkiyɨm sɨma ɨni nɨdidkakar mɨ owɨm. Mɨ Jisɨs siya kam ɨuur nwɨswo siir kɨgna mɨriiyɨm sɨmiir yɨkɨuna. Mɨ siya sɨmiirɨn hanɨɨngɨ boɨnmɨmauu dimɨnɨn mhoɨiya siir tɨranɨn. ");
INSERT INTO iws_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Mɨ siya boɨn, wakae! Tariinanɨn krɨma om komii Jerusalem siir niiyami. Mɨ prismi yaowae adɨm mɨ kamɨm siyɨu komii nɨnoknɨnkɨni ɨkɨm mɨ sɨma inkamɨn nɨnomor kouankɨ nɨtɨn saɨkan wɨ yaigaka mɨ owi. Mɨ sɨma wɨ siir nɨsomaowama boɨnaii. Mɨ sɨma wɨ Juda iikam tani wɨ sɨmiiram nɨkropki sɨma nɨsomaowam siirɨn. ");
INSERT INTO iws_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Mɨ sɨma siirɨn yai bibiyɨe wɨ hanɨɨngɨ mɨ boɨnaigɨnɨuwi. Mɨ yaeyop wɨ siir mɨ yasi mɨ siirɨn wa mɨ tɨowi mɨ siirɨn wa mɨ ɨtaoki. Mɨ siya ɨiyo wɨ kwɨsa nwokwowaki ɨenau hɨrɨn. Mɨ ɨi kwoɨmaka siya wa swokɨ ɨnsiin ɨdwowi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Mɨ Sebedi siir yɨnisɨm nwɨswo Jems Jon sowa Jisɨs siirɨm yɨt mɨ siir inɨ boɨni, dimɨn taemɨn nowomwarkaiyɨuwan inkam! Mɨ krɨra dimɨn whɨrɨn kɨriir srɨiyam mɨni. Mɨ nɨkrɨra mɨnam naɨngwowi tɨ dimɨnɨn kɨra krɨriir tɨrkiyɨm. ");
INSERT INTO iws_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Mɨ siya sowiir boɨnki, kowa dimuam naɨngwowi, kara kowiirɨn dimu mɨnkiyɨm? ");
INSERT INTO iws_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Mɨ sowa siir boɨnki, ɨiya kɨra Adi Komii siir om hɨran digworaekwo hoɨmgakɨm sɨmiir kɨgrɨraowi mɨ kɨra krɨriirɨn wɨ hanɨɨngɨn dɨmbingi, nwɨrɨn wɨ ɨɨniga dɨkmwon ɨdwo mɨ nwɨrɨn wɨ yaɨoyaeya timɨ okmwɨn ɨdwo. ");
INSERT INTO iws_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Mɨ Jisɨs siya sowiir boɨnki, kowa tari bɨri sɨbgu nɨnoknɨnkɨnko tɨ dimɨnɨn kowa srɨiyɨn kariir? Mɨ kowa ta hɨka kara haiya saiir hɨriinan hɨka wa haii? Mɨ kowa wɨ dɨgar nwowi tɨ mob opkakɨn kara kwiyaeyɨn siir kwiyaeyɨm? Mɨ kowa wɨ dɨgar nwowi kariir hɨriinan op baptaisɨm, aniya? ");
INSERT INTO iws_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Mɨ sowa siir boɨnki, nɨkrɨra wɨ dɨgar nwowi. Mɨ Jisɨs siya sowiir boɨnki, kaimwoka tɨ op mobɨn kara kwiyaeyɨn mɨ wo kowa wa timɨ kwiyae. Mɨ ta opa kara baptaisa, wo kowa hɨriinan wa timɨ baptais. ");
INSERT INTO iws_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Wɨ nhɨnga namisi ɨdwowi kariir ɨɨniga mɨ kariir yaɨoyae aka. Tɨ dimɨnɨn yɨo kariir dimɨn tani. Nɨɨngaka. Wɨ Adi Komii krɨmiir Wanɨn siyar hɨdi sɨmiirɨn. Mɨ wɨ nhɨnga namisi ɨdwowi ɨɨniga yaɨoyaeya. ");
INSERT INTO iws_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Mɨ kam ɨuurɨm Jisɨs siir kɨgna mɨriiyɨm sɨma ta yai aiir wakaeyɨm mɨ sɨma ɨo prasae bɨ swokɨ okɨm Jems, Jon sowakan. ");
INSERT INTO iws_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jisɨs siya sɨmiirɨm yɨkɨuna, sɨma siirɨm nɨtɨm. Mɨ siya sɨmiir boɨnki, kɨma bɨdi yɨnoknɨnkɨnɨm inkam komiiyɨn omom omom kɨgrɨraowiyɨn sɨma nikworɨnuwi wɨ dɨgar nwowi. Mɨ sɨma ɨinokɨinokɨn mɨi wa hauunanaei. ");
INSERT INTO iws_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mɨ tɨ siyɨu hɨnɨɨnɨn yɨo kɨmiir tɨr kɨpi nwo. Nɨɨngaka. Mɨ inkam nwɨrɨn kɨmiir yaowae nwowɨm naɨngwowi mɨ siya whɨsarii mɨi prɨi mɨriiyan inkam dwo. Kɨmiir mɨi ɨmiir whɨnmɨriiyam. ");
INSERT INTO iws_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Mɨ inkam nwɨrɨn kɨmiir bɨiyan inkam nwowam naɨngwowi mɨ siya inkam nɨnganan dwo wigkam whɨekakɨm sɨmiir mɨi ɨmiir whɨnmɨriiyam. ");
INSERT INTO iws_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mɨ tɨ hɨriinan inkamɨn nɨnomor kou hɨrankɨ nɨtɨn siya mɨnam bɨri nɨtkɨn kam nhɨrɨm siir mɨi ɨmiir mɨriiyɨm. Nɨɨngaka. Siya hɨnɨɨnam bɨri nɨtkɨn. Siya mɨnam nɨtkɨn sɨmiir mɨiyan inkam nwowam. Mɨ siya bɨri naɨngwoyɨmyokɨn naosiyɨn. Nɨɨngaka. Siya naowamar nɨtkɨn iikam whɨekakɨm sɨmiir nanmaiwarkananaowidam. Mɨ sɨmiir dimɨn biyɨeyɨm siya bɨdi haiyoprimdiyɨumiigiyɨm mɨ sɨma ɨni rɨrmiiyar ywokiyɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Mɨ sɨma om komii Jeriko hɨriir yɨmbiyam. Mɨ ɨiya sɨma om komii Jeriko hɨr haiburgigɨm mɨ ɨna yamɨm. Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma mɨ iikam isid komii ɨkɨn, sɨma ɨni saɨka yɨnkɨn amɨm. Mɨ sɨma kɨg Batimiasɨn Timiasni yɨnisɨmɨn siya siyɨugbid hɨrar nɨdwowɨni mɨ siya nhwokwɨsaekɨn. Mɨ siya ɨkɨ iikamɨm sɨmiiramar prɨikau prɨikauwikɨn umɨr mɨnamɨn. ");
INSERT INTO iws_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mɨ siya wakae Jisɨsɨn om Nasaretanɨn ɨni tɨr nwowɨn. Mɨ siya ɨna kauwok boɨnkiyɨn, Jisɨs Inkam Komii! Devidni isidɨn siirɨn kɨra kariirsi timɨ aɨngwobuna! ");
INSERT INTO iws_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Iikam hoɨmgakɨm sɨma siir yɨk, kɨra yai tanki. Mɨ siya yai ɨni komiiyar swokɨ kauwok boɨnkiyɨn, kɨra tɨ Devidni yɨnɨeyɨm sɨmiir yɨnisɨmɨn, kɨra kariirsi timɨ aɨngwobumbu. ");
INSERT INTO iws_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Mɨ Jisɨs siya ɨna yamokwo naɨngwoyokiyokɨiyɨuɨn. Mɨ siya ɨna boɨnkiyɨn, siirɨn wɨkɨu nani. Mɨ sɨma tɨ nhwokwɨsae inkamɨn siirɨm yɨkɨunam mɨ sɨma siirɨn ɨna boɨnmauu wakaekiyɨm kɨriir kwoɨnɨn kɨrɨeya dwonam mɨ kɨra dɨnsiin siya kɨriiram nɨkɨunaei. ");
INSERT INTO iws_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Mɨ siir yɨuɨsa ɨna kiwhro ɨtkɨngiga. Mɨ siya bɨri kɨmɨmɨnkɨn, ɨna yɨnsiin iwɨtnamɨn Jisɨs siirɨm. ");
INSERT INTO iws_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Mɨ Jisɨs siya siir boɨnki, kɨra dimuɨm naɨngwowi, kara kɨriirɨn pɨ dimu mɨnki? Mɨ tɨ nhwokwɨsae inkamɨn siya Jisɨs siir boɨnki, dimɨn taemɨn nowomwarkaiyɨuwan inkam, kara mɨnam naɨngwowi, kariir nhwonan pɨ nanaokɨgɨmokiyɨm. ");
INSERT INTO iws_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Mɨ Jisɨs siya siir boɨnki, kɨra ha dam! Kɨriir naɨngwo tɨbmiiya saeya nwowaigɨnɨugikɨn, wadɨe kɨriirɨn. Mɨ bɨri kɨmɨmɨnkɨn siir nhwonan ɨni wadɨeyar ywokiyɨn mɨ ɨna kɨgɨmokiyɨn. Mɨ siyɨu hɨrɨn siya ɨni siir mhoɨiya yapnamɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Mɨ sɨma omisɨm whɨswo om komii Jerusalem siir kingiin hɨr nwowo sowiir hɨrii yɨmbiyam. Mɨ sɨma tɨ om whɨswo Betfasi Betani mhɨu Oliv kingiin hɨr nwowo sowiir hɨriir bɨdi yɨmbiyamɨm mɨ Jisɨs siya kamɨm siir kɨgna mɨriiyɨm sɨmiir nwɨsni yɨkropki. ");
INSERT INTO iws_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Mɨ siya sowiir boɨnki, kowa tɨ omɨn kingiin tɨrar kwowɨn siir dam! Mɨ ɨiya kowa tɨ omisɨm ɨiir napnɨmbɨiyami mɨ kowa pɨ donki haomisɨmɨn siirar napkɨgami. Siirɨn sɨma bɨdi yɨmborunɨnkɨnɨn bɨiya inkam nwɨrkɨn siir bɨri nikɨ ɨdwokɨn mɨ siya wa wakaeyokna rani. Nɨɨngaka. Mɨ uridɨn siir nɨmborunɨnkɨnɨn pɨ hɨrar hakaigɨngig. Mɨ siirɨn pa whainani kara nɨdwonamam. ");
INSERT INTO iws_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mɨ inkam nwɨrkɨ srɨigii, kowa dimuam nɨkɨunami siirɨn, ha? Mɨ kowa wɨ hɨnɨɨna dowarkɨi boɨn, Yaowae Komii siya mɨigakɨn siirɨn. Mɨ siya pɨ kɨmɨmɨn tani pa swokɨ ɨkropki kɨriiramar. ");
INSERT INTO iws_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Mɨ sowa ɨna yamwo. Sowa kɨg donki haomɨn omaka ɨra saiir anoka hɨr nɨmborunɨnkɨni mɨ siya ɨni idowɨiya hɨrar nwowɨn siyɨuka kingiin hɨr mɨ sowa siir hakainam. ");
INSERT INTO iws_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Mɨ kam nhɨrɨm kingiin hɨr nwowɨm sɨma boɨnki sowiirɨn, kowa tɨ donki haomɨn siirɨn dimusi hakainami, ha? ");
INSERT INTO iws_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Mɨ sowa sɨmiirɨn Jisɨs siya boɨnmauugiya yaiya saiir hɨriinanar boɨnki. Mɨ sɨma ɨni wadɨeyar ywokiyɨm sowiirɨn. ");
INSERT INTO iws_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Mɨ sowa tɨ donki haomɨn Jisɨs siirɨm hainani. Mɨ sowiir yɨuɨso siir ɨdwo hɨr haigɨn mɨ Jisɨs siya siir ɨdwowar yɨdwo. ");
INSERT INTO iws_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mɨ iikamɨm sɨmiir yɨuɨsɨm siyɨu ɨiirar hakɨnwɨn mɨ nhɨrɨm paeya kwiya undɨmtɨo hainaki siyɨu ɨiir haigɨnwɨnam. Sɨma siirɨn hɨriinan mɨnam tɨrkɨm, siir inɨgɨn siir hainanwɨnam inkam komiiyɨn nu kɨgrɨraowiyɨn siir hɨriinan. ");
INSERT INTO iws_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Iikam nhɨrɨm bɨi ywo mɨ nhɨrɨm mhoɨi ywo. Mɨ sɨma ɨna kauwok boɨnkiyɨm, Hosana! Kɨra tɨ inkamɨn Adi Komii krɨmiir Wanɨn siir kɨrɨeni nɨtɨn siir kɨnsiis haigɨnɨu. ");
INSERT INTO iws_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Siya krɨmiir kɨgrɨraowam nɨtkɨn bɨiya krɨmiir brougaeyɨn Devid siya kɨgrɨraowa saiir hɨriinan. Krɨma ɨni maɨrgɨmaɨrga nwowɨnɨm mɨ kɨra siir kɨnsiis haigɨnɨu, kɨra inkam komii kɨɨngɨn. ");
INSERT INTO iws_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Mɨ Jisɨs siya ha namɨn om komii Jerusalem hɨriir yɨmbiyam. Mɨ siya ɨna yapnɨnopkainamɨn omaka Adi Komii siir inɨg hainaniya saiir mɨ siya ɨna yapkɨgyokiyokɨiyɨn omaka yainau hɨr mɨ omaka akpɨtga warar. Mɨ siya digworaekwo hoɨmgakɨm sɨmiir napkɨg dɨgiyɨn mɨ siya mɨi nhɨrɨm sɨmiir mɨriiyɨm naɨngwokɨn. Mɨ bɨeyɨn ɨna yɨkɨiyamtɨbɨn. Mɨ kam ɨuur nwɨso siir kɨgna mɨriiyɨm sɨma mɨ siya, sɨma om Betani hɨriir asi nam tɨbgɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mɨ ɨigwɨr nugakɨn sɨma om Betani hɨr haiburgikyakwokɨm mɨ ɨna swokɨ amyakwokɨm om komii Jerusalem hɨriir. Mɨ Jisɨs siir mhɨiya ɨna yaokiya. ");
INSERT INTO iws_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Jisɨs siya pae fikɨn wɨra kɨgi, arurɨg hɨrar nokwowɨni mɨ kwo saeyara nopkɨ kaisɨsi. Mɨ siya siir kɨgiyɨn mɨ ɨna yamɨn hɨriir siir yɨnɨm inɨ hansɨrɨu siya naeyam. Mɨ siya ɨni nɨɨnga yaka kɨgɨuɨn, yɨn bɨri budgɨn, nhɨruwa sɨm karamaeyar ywowɨn. Nɨɨngaka. Siya kwo ara nɨnkɨnɨugɨn. Mɨ tɨ pae fikɨn siir ɨiya yɨn siya budiya saeya waeyao ");
INSERT INTO iws_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mɨ Jisɨs siya tɨ paeyɨn siir boɨnki, kɨra wɨ yɨn kɨpi swokɨ bud mɨmɨn. Nɨɨngakɨɨnga. Mɨ kamɨm siir kɨgna mɨriiyɨm ɨna wakaekiyɨm ta yaiya siya boɨnkiya. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Mɨ sɨma om komii Jerusalem hɨriir nɨmbiyamɨm mɨ Jisɨs siya omaka Adi Komii siir inɨg hainaniya saiir hɨriir yapnɨnopkainam. Mɨ siya kamɨm digworaekwo haigɨnɨm ta omaka aiir mɨ kamɨm tɨ nae digworaekwo ɨmiir saɨn ɨkɨm, siya sɨmiir inɨ nhɨnɨkrɨropnatnouwidnɨnkiigi. Mɨ siya kamɨm umɨr nɨnowana haiiyɨm sɨmiir hɨiyɨm sɨmiir wara yɨinakinhɨɨmnhɨɨn ɨtkiigɨigi. Mɨ kamɨm ɨpiyɨn mɨ haigɨnɨm sɨmiir hɨiyɨm warar mɨ ɨnkɨn ɨinakinhɨmnhɨn ɨtkigɨigi. ");
INSERT INTO iws_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Mɨ Jisɨs siya sɨmiir boɨnɨkɨdugi, sɨma nae digworaekwowɨm tɨ siyɨuɨn Adi Komii siir inɨg hainaniya omaka saiirɨm naprɨokɨinamiyɨn siir pɨ haigɨnisi. ");
INSERT INTO iws_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Mɨ siya sɨmiir boɨnki, Adi Komii siir yaiya hɨnɨɨna boɨnka, kariir omaka wɨ hɨnɨɨna dapi, iikam hoɨmgakɨm sɨmiir omakaka Adi Komii siirɨm kwɨsboɨnika. Mɨ ta omaka nae mɨn kɨma ninɨ haigɨniya mɨ kɨma ɨni inkamɨn hɨi tauaeiyɨn si ninɨ ɨdam oniiyɨm inkamkɨ kɨgsi mɨ siir hɨriinan ninɨ tɨrnikɨm. ");
INSERT INTO iws_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Mɨ prismi inkam komii komiiyɨm mɨ kamɨm siyɨu komii nɨnoknɨnkɨni ɨkɨm, sɨma ta yai aiir wakaewɨnɨm mɨ sɨmar kɨg iikam whɨekakɨm Jisɨs siir siyɨu ɨiirara napɨm mɨ sɨma ɨni nɨdidkakar ywowɨm. Dimusi rani, iikam whɨekakɨm sɨma siir siyɨu ɨiirar napi mɨ sɨma siir nɨsomaoni siyɨuam asi hansɨrkɨm. ");
INSERT INTO iws_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Mɨ naɨowaka kamɨm siir kɨgna mɨriiyɨm sɨma mɨ siyar, sɨma om komii Jerusalem hɨr haiburgikrɨb mɨ sɨma ɨni om Betani hɨriirar swokɨ am tɨbɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mɨ ɨigwɨr nugakɨn sɨma ha napnamyakwokɨm mɨ ɨna kɨgamɨm tɨ pae fikɨn bɨdi waiyɨugusamɨn. ");
INSERT INTO iws_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita siya ta yaiya Jisɨs siya boɨna saiir swokɨ aɨngwokiyɨn mɨ siya ɨna boɨnkiyɨn, dimɨn taemɨn nowomwarkaiyɨuan inkam, kɨra kɨgi tɨ pae fikɨn ii kɨra boɨngikɨn, siya bɨdi waiyɨugusamɨn. ");
INSERT INTO iws_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Mɨ Jisɨs siya sɨmiir yai aiir yowarkɨi boɨnki, kɨma Adi Komii siirɨm naɨngwo tɨbmii mɨ tɨ hɨriinan dimɨnɨn kɨma wɨ siirar mɨ tɨri. ");
INSERT INTO iws_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mɨ kɨma tɨ mhɨu ɨiir boɨnkii hɨnɨɨn, kɨra damki, whɨi komiiya saiir hɨr damɨkwomaiyɨu. Mɨ tɨ inkamɨn siya kwoɨn whɨsaɨr naɨngwo karamae nwowi, siya hindara naɨngwo tɨbmii ɨski mɨ ha boɨni, ta kariir yaiya wɨ kaimwowar nwowi. Kara kɨmiirɨn yaimwowa boɨni, dimɨnɨn tɨ inkamɨn siya boɨni mɨ wɨ siir hɨriinanar nɨmbiyami. ");
INSERT INTO iws_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Mɨ ɨiya kɨra nhwo kwɨsboɨnkii dimɨn whɨr haiyam mɨ kɨra naɨngwo tɨbmii mɨ ha boɨni mɨ wɨ kaimwowar nwowi kɨra wɨ tɨ dimɨn ɨiirar haii. Kara kɨmiirɨn yaimwowa boɨni, tɨ dimɨnɨm kɨma kwɨsboɨnkiyɨm mɨ wɨ sɨmar swokɨ ɨmbini. ");
INSERT INTO iws_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ɨiya kɨma Adi Komii siirɨm kwɨsboɨniyɨm mɨ inkam nwɨrkɨn kɨmiir tɨrbugɨn mɨ kɨma kwoɨn biyɨe siirɨm kɨpi nwo ɨo saɨka nwowam. Nɨɨngaka. Kɨma nae saɨkar dombudnɨnkɨn ae. Mɨ kɨma hɨriinan tɨri mɨ Adi Komii siya kɨmiirɨn wɨ hɨriinan siyɨu ɨiirar swokɨ tɨr haigɨnɨuwi. ");
INSERT INTO iws_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mɨ kɨma tɨ inkamɨn kɨmiir tɨrbuɨn saɨka nongwomamaɨr ae karamae nwowi mɨ Adi Komii siya kɨmiir dimɨn biyɨeyɨm wɨ sɨmiir haiyoprimdiyɨumiigi rani. Mɨ siya wɨ kɨmaka mɨ ɨngwomamaɨr ae rani. Nɨɨngaka. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Mɨ sɨma ɨna swokɨ amɨm om komii Jerusalem hɨriir. Mɨ Jisɨs siya ɨna yapnɨnopkai namɨn omaka Adi Komii siir inɨg hainaniya saiir. Mɨ kam nhɨrɨm pris nwowɨm mɨ kam nhɨrɨm Adi Komii siir siyɨu komii ɨiir kɨgrɨraowi ɨkɨm mɨ Judami kam adiyaowaeyɨm siyɨu komii kɨgrɨraowiyɨm, sɨma yɨtswo Jisɨs siiramɨn. ");
INSERT INTO iws_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Mɨ sɨma siir inɨ srɨini, kɨriirɨn kɨrɨe nhɨnga hauugɨn, ta mɨiya saiir Bɨiyan Inkam Komii nwowɨn? ");
INSERT INTO iws_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Mɨ Jisɨs siya ɨna yowarkɨi boɨnkiyɨn, kara ɨriipɨ hɨriinan pɨ kɨmiir mɨ kwasrɨi dimɨn whɨrɨn siirɨm. Mɨ kɨma kariir yai aiir wakae boɨni mɨ kara kɨmiirɨn pa mɨ boɨnmauuwi inkamɨn ta mɨiya kara mɨriiya saiir boɨnkiyɨn. ");
INSERT INTO iws_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Mɨ yɨpɨkɨn Jon siir nɨkropkiyɨn iikamɨm sɨmiir baptais haigɨnɨuwam? Adi Komiiyɨn nɨnomor kouanɨn siya piyamisi ɨkropkiyɨn, iyɨe? Mɨ tari nuan inkamkɨn piyamisi ɨkropkiyɨn, aniya? ");
INSERT INTO iws_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Mɨ sɨma ɨo sɨmasɨmar yɨnwo anwo mɨ krɨma ha boɨni, tɨ dimɨnɨn nɨnomor kou hɨrankɨn mɨ siya wa boɨni mɨ kɨma dimusi nwokɨm siirɨm bɨri naɨngwo tɨbmiigɨm, ha? ");
INSERT INTO iws_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mɨ krɨma ha boɨni, siya inkami dimɨnkɨn, ta yaiya wɨ dɨg nwo rani. Nɨɨngaka. Mɨ sɨma iikamɨm sɨmiirsi swokɨ ɨdidi. Iikam hoɨmgakɨm ɨna nɨnoknɨnkɨnɨm Jon siya profet inkamkɨɨngɨn. ");
INSERT INTO iws_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mɨ sɨma Jisɨs siir yai aiir asi wakae boɨnkɨm, krɨma nɨnoknɨnkɨn tani. Mɨ Jisɨs siya sɨmiir boɨnki, kara ɨriipɨ hɨriinan pɨ kɨmiir mɨ boɨnmauu rani. Nɨɨngaka. Inkamɨn kariir boɨnkiyɨn ta mɨi aiirɨmɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Mɨ Jisɨs siya boɨniyɨo yai nhɨrɨm sɨmiir boɨnki, siya boɨn, inkam nwɨrɨn numɨr waina ha yɨiyoknɨnkɨnam mɨ ɨna yɨtkii nɨnkɨn ɨuɨn. Mɨ siya ɨe komiiyɨn ɨna yopɨn. Mɨ diyamɨr komiiya ɨra yopkikaigi tɨ ɨe ɨiir, wain ɨmiir warbrompropnamɨm. Mɨ pada bripriya haɨni mɨriinainam koua hɨriir, kamɨm saiir kɨgrɨraowɨm sɨmiirɨm. Mɨ siya sɨmiir boɨnki ta numɨra kɨma sɨbgu kɨgrɨrao. Mɨ ɨiya tɨ paeyɨm sɨma budgɨn mɨ sɨma hɨgi mɨ nhɨrɨm wɨ kɨmar whɨn haii mɨ nhɨrɨm wɨ kariir whɨn hauugi. Mɨ ɨiya siya sɨmiir boɨngigɨn mɨ siya ɨna haiburgigɨn siir om ɨiirɨn. Mɨ siya ɨna yamɨn aru maeyauwa. ");
INSERT INTO iws_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mɨ ɨiya ta wain numɨra saeya hɨgiya mɨ numɨran inkamɨn siya yɨkropki inkamɨn whɨsarii mɨi prɨimɨriiyɨn siir, kamɨm wain numɨra saiir mɨriiyɨm sɨmiirɨm. Siya mɨnɨm nɨkropkikɨn ta numɨra saiir nae nhɨrɨm siir hauugiyɨm. ");
INSERT INTO iws_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mɨ kamɨm numɨr kɨgrɨraowiyɨm sɨma tɨ inkamɨn whɨsarii mɨi prɨimɨriiyɨn siir yankabrɨmdɨnu okwo mɨ sɨma siirɨn ɨna yɨpɨmpar haigɨnɨugiyɨm. Mɨ siirɨn ɨni nɨɨngar swokɨ ɨkropkiyɨn. ");
INSERT INTO iws_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mɨ siya whɨsarii prɨimɨriiyɨn inkamɨn nwɨra swokɨ ɨkropki sɨmiiram. Mɨ siirɨn sɨma mwo ɨiir yɨkɨrki mɨ siirɨn haɨni yɨgbumbu haigɨnɨugi. ");
INSERT INTO iws_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mɨ siya whɨsarii prɨimɨriiyɨn inkam nwɨrɨn nwoɨmaka ɨna swokɨ ɨkropkiyɨn. Mɨ tɨ inkamɨn yɨo hɨriinan, ɨna mɨ ɨsomaokiyɨn, sɨma mɨ siya kamɨm whɨsarii mɨi prɨimɨriiyɨn sɨmiirɨn hoɨmgakar yɨkropki. Mɨ sɨma nhɨrɨm hindara mɨ tɨoki mɨ nhɨrɨm ɨna yɨsomsom aokiyɨm. Mɨ sɨma tɨ hɨriinan siyɨuɨn nwɨruwani bɨri tɨrkɨn. ");
INSERT INTO iws_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mɨ siir hɨrɨn nwɨruwar nwowi siya siirar yɨnisɨmkɨn, siir kwoɨnɨn siirɨmar naɨngwokwonanaeikɨn. Mhoɨigɨ mhoɨiya ɨni siir yɨnisɨm ɨiirar yɨkropkiyɨn tɨ kamɨm numɨr aiir kɨgrɨraowiyɨm sɨmiiram. Siya hɨnɨɨna boɨnkikɨn, sɨma wɨ kariir yɨnisɨmɨn wɨ siir yaiyar wakaeyoknaei. ");
INSERT INTO iws_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mɨ tɨ kamɨm ta numɨr aiir kɨgrɨraowiyɨm sɨma, sɨma sɨmar yomboɨn amboɨn, tɨ inkamɨn siir adni digworaekwo whɨekakɨm wɨ siya hai. Hundɨe! Krɨma siir nɨsomaoki. Mɨ ta numɨra wɨ krɨma krɨmar nwoki. ");
INSERT INTO iws_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mɨ sɨma siir nɨsom aowam kauwok boɨnkikɨm mɨ siirɨn numwowa hɨriir yɨsom ɨtkaigi. ");
INSERT INTO iws_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Mɨ Jisɨs siya ɨna swokɨ srɨiyɨn, ta wain numɨra saiir adɨn wɨ panɨɨna tɨri? Mɨ ɨiya siya nɨti mɨ wɨ ta numɨr aiir kɨgrɨraowɨm kamɨm wɨ sɨmiir nɨsomsom aoki. Mɨ ta numɨra wɨ inkam nhɨrɨm sɨmiir boɨnki, sɨma kɨgrɨraowɨm saiirɨn. ");
INSERT INTO iws_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mɨ kɨma tari Adi Komii siir yaiya Yokwo Komii saiir nwowɨm sɨmiir bɨri mwangɨm? Siya hɨnɨɨna boɨnkikɨn, tɨ kougouwɨn yaewan kɨma kɨndiyɨu wangigɨn mɨ tariinanɨn siya ɨni bopwonauan kougou yamwoɨuɨn. ");
INSERT INTO iws_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Siirɨn bɨikɨ bɨiyɨn, Bɨiyan Inkam Komiiyɨn siya tɨrkɨn mɨ tɨ dimɨnɨn ha nɨmbiyamkɨn. Mɨ krɨma siir kɨgiyɨm ɨni wadɨeyar ywokiyɨm. ");
INSERT INTO iws_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Mɨ tɨ Judami inkam adiyaowae komii komiiyɨm sɨma bɨdi yɨnoknɨnkɨnɨm Jisɨs siya ta boɨniyɨo yaiya sɨmiirar kwaboɨnka. Mɨ sɨma Jisɨs siir nonkworɨmdɨnu hainamɨm tɨrkɨm omaka hɨuyokiyokaiya saiir hɨugrɨpkɨikikaigigɨm mɨ sɨma ɨni iikamɨm sɨmiirsi yɨdidɨm. Mɨ sɨma siir haiburgigɨm mɨ sɨma ɨna yamɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mɨ sɨma Farisi sɨmiir nhɨr ɨma mɨ Herot siir kam nhɨr ɨma sɨmiir yɨkropki mɨ sɨma yam Jisɨs siirɨmɨn. Mɨ sɨma Jisɨs siirɨn mɨnam kɨnankɨugɨm siya yai biyɨe boɨnɨm. Sɨma bɨdi yɨnoknɨnkɨnɨm, siya hɨnɨɨna boɨnkɨswo, ɨhɨ Farisi kamɨm Judami isidɨn sɨma wɨ ɨo pɨ ywowɨn siirɨn. Iyɨe? Siya ha boɨnkɨswo. Nɨɨngaka. Mɨ Herotni isidɨn sɨma wɨ ɨo sɨmiir pɨ mɨ owɨn. ");
INSERT INTO iws_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Sɨma ha nɨtɨm mɨ siir inɨ boɨni, inkamɨn nowomwarkaiyɨuwiyɨn, krɨma bɨdi yɨnoknɨnkɨnɨm yaiyɨm kɨra boɨniyɨm kaimwowaɨrgɨm. Kɨra inkam nwɨruwaniyɨm bɨri naɨngwowikɨn mɨ kɨra inkamɨn inɨgakɨn yaeya yai bɨri swokɨ boɨnikɨn mɨ inkamɨn inɨg karamaeyɨn yai whɨrni. Nɨɨngaka. Mɨ kɨra iikamɨm sɨmiirɨn Adi Komii siir siyɨuɨn siir yaimwo ɨmiirarar boɨnmɨmauuwi. Kɨra panɨɨna naɨngwowɨn? Mɨ krɨma takis inkam komii Sisa siir hauuwi mɨ wɨ wadɨeyar nwowi. Iyɨe? Nɨɨngaka. Wɨ hauu rani, aniya? ");
INSERT INTO iws_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mɨ Jisɨs siya bɨdi yɨnoknɨnkɨnɨn, sɨmiir nɨksɨsaeya. Mɨ siya sɨmiir boɨnki, kɨma kariiram dimusi kɨnankɨuwi, kariir nɨksɨsaeyɨm? Kɨma umɨra kwɨra whainani kara kɨgam. ");
INSERT INTO iws_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Mɨ sɨma umɨra kwɨra hainani siirɨmɨn. Mɨ siya srɨi taka hɨnɨɨn umɨr whwonkama nhɨniir inɨgɨn nwoka, ha? Mɨ yɨm sɨma ɨna boɨnkiyɨm, inkam komii Sisa siirga. ");
INSERT INTO iws_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Mɨ Jisɨs siya ɨna wakae boɨnɨn sɨmiir yai aka, Sisa siir dimɨnɨn kɨma Sisa siirar hauu. Mɨ Adi Komii krɨmiir Wanɨn siir dimɨnɨn yɨo Adi Komii siirar timɨ hauu. Mɨ sɨma ɨni siir siirara yaɨngwokwowɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Mɨ mhoɨiya Sadyusi nhɨrɨm Jisɨs siirɨm yɨt. Sadyusi sɨma hɨnɨɨna naɨngwokɨm, inkamɨn naonamiyɨn wɨ swokɨ ɨnsiin ɨdwo rani. Mɨ sɨma siir inɨ srɨini. ");
INSERT INTO iws_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Inkamɨn iikam nowɨmwarkaiyɨuwiyɨn Moses siya hɨnɨɨna wɨnkikɨn yai kwɨra krɨmiirɨmɨn, ɨiya inkam nwɨrɨn siya naonami mɨ siya yɨnisɨmkak bɨri nwogigɨn mɨ wiga ɨna ywokiya mɨ tɨ kamɨn siir nomousɨmɨn wɨ siya swokɨ onkwonaei ta wiga? Mɨ mhoɨiya siya yɨnɨekak nwowi siir yaowaeyɨn siir ɨgsopa wɨ siya nwokɨ okwokairinanaowidi? ");
INSERT INTO iws_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mɨ sɨmayao ɨriiyar nwɨskɨnɨuwi, yaowae wig siya yonkwona mɨ mhoɨiya siya ɨna yaonamɨn. Mɨ siya yɨnɨe bɨri niyɨogigɨn, ɨni nɨɨngar yaoiyopnɨsugika siir wiga. ");
INSERT INTO iws_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mɨ yaowae saɨka nwokaiyɨn mɨ ɨni siya swokɨ onkwona ta wiga, yɨo ɨriipɨ hɨriinan ɨna mɨ aonamɨn. Mɨ siya ɨni yɨnisɨm karamaeyar mɨ ogigɨn, yɨnɨe bɨ mɨ iyɨogigɨn. Mɨ nwoɨmakan ɨriipɨ hɨriinanar mɨ tɨr. ");
INSERT INTO iws_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Hɨrii hɨriinankɨna tɨ kamiyao ɨriiyar nwɨswo ta wig ɨrua saiirara nonkwonakɨm. Mɨ sɨma yɨnɨe bɨri swokɨ iyɨogigɨm. Mɨ mhoɨiya ta wiga ɨna mɨ aonama ");
INSERT INTO iws_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","mɨ mhoɨiya tɨ kamiyaowɨm naonamɨm sɨma swokɨ ɨnsiin ɨdwodwo dɨgi ɨeyankɨn mɨ ta ɨiya, ta wiga wɨ nhɨniir wig nwowi? Kɨra bɨdi yɨnoknɨnkɨnɨn ta wiga simiiryao wigar nikɨ oka, Sadyusi sɨma hɨnɨɨna srɨigɨm siirɨn. ");
INSERT INTO iws_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jisɨs siya sɨmiir boɨnki, kɨma Yokwo Komiiya saiir yai bɨri nɨnoknɨnkɨnkɨm. Mɨ kɨma Adi Komii siir kɨrɨeya saiir bɨri mɨ ɨnoknɨnkɨnkɨm? Mɨ kɨma yaimwoni bɨ mɨ ɨnoknɨnkɨnkɨm? Mɨ kɨmiir kwoɨnɨm mɨiyɨk panɨɨnsi yaɨngwosi. ");
INSERT INTO iws_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ɨiya kamɨm naonamɨm sɨma nɨnsiin ɨdwowi ɨe hɨrankɨn, sɨma wɨ wig nonkwonakak nwo rani. Nɨɨngaka. Sɨma wɨ nɨnomor kouan paekwosɨmɨm sɨmiir hɨriinan nwowi. ");
INSERT INTO iws_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mɨ ta yaiya sɨma kamɨm naonamɨm sɨmiir boɨna, sɨma wa swokɨ ɨnsiin ɨdwowi, ɨe hɨrankɨn. Mɨ kɨma tari yokwowa Moses siya wɨnkiya saiir bɨri mwaɨngɨm, tɨ niiwiiyɨn paeya paekɨkopɨm sɨmiir nɨuwa. Mɨ Adi Komii krɨmiir Wanɨn siya Moses siirɨn saiir boɨnmauukɨn, siya hɨnɨɨna boɨnkikɨn, kara Ebraham, Aisak, Jekop omwai waiyayokiyokɨiyɨm sɨmiir Adi Komiigɨn. ");
INSERT INTO iws_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Adi Komii siya tɨ kamɨm naonamɨm sɨmiir Adi Komii rani. Nɨɨngaka. Siya kamɨm omwai waiyayokiyokɨiyɨm sɨmiir Adi Komiigɨn. Warɨ kɨmiir kwoɨnɨn mɨiyɨk rani, ɨni biyɨe ywowɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Inkam nwɨrɨn siyɨu komii nɨnoknɨnkɨniyɨn siya ɨna yɨtɨn. Mɨ siya wakaeni sɨma yaiinan nɨnii. Mɨ siya wakae Jisɨs siya boɨniyɨm yaiyɨm sɨmiir, siya yai wadɨe ɨmiirara boɨni. Mɨ siya Jisɨs siir asi srɨigɨn, pɨkɨ hɨnɨɨn siyɨu ɨkɨn, siyɨu whɨekakɨm sɨmiir bɨi nwowɨn? ");
INSERT INTO iws_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jisɨs siya siir yai yamdi hɨnɨɨna yowarkɨi boɨn, bɨiyan siyɨuɨn sɨma hɨnɨɨna wɨn boɨnkikɨn. Wakae! Kɨma tɨ iikamɨm Isrelanɨm, kɨma tɨ bɨiyan siyɨuɨn siir sɨbgu wakae! Krɨmiir Adi Komii nwɨruwan siyaɨrgɨn Bɨigɨ Bɨiyan Inkam Komiiyɨn ");
INSERT INTO iws_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","kɨra kɨriir Bɨiyan Inkam Komiiyɨn siirɨm daɨngwo. Mɨ kɨriir mhɨi kwoɨnɨm mɨ kɨriir kɨrɨeya siirara hauu ɨuguski. ");
INSERT INTO iws_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mɨ mhoɨiyan siyɨuɨn yɨo hɨnɨɨngɨn kɨra inkam whɨekakɨm sɨmiiramar daɨngwo ɨrkak, kɨra naɨngwokwonanaeiya kɨriir pɨu aiisi saiir hɨriinan. Siyɨu whɨrkɨn tɨ siyɨu whɨswo sowiir kou bɨri nwokɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mɨ tɨ inkamɨn siyɨu komii nɨnoknɨnkɨniyɨn siya Jisɨs siir boɨn, inkamɨn iikam nowɨmwarkaiyɨuwiyɨn! Kɨra yai wadɨeya boɨni. Hɨipa, kaimwoka! Adi Komii siyaɨrgɨn Bɨiyan Inkam Komiiyɨn, inkam nwɨr karamaeka. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Mɨ krɨmiir mhɨi kwoɨnɨm mɨ krɨmiir kɨrɨeya siiraramar daɨngwokwonanaei. Krɨma naɨngwokwonanaeiya krɨmiir pɨu aiiram saiir hɨriinan. Krɨma tɨ siyɨu whɨswo sowiirar dap ɨski. Mɨ tɨ siyɨuɨn ɨni tɨ Adi Komii krɨmiir Wanɨn siiram nanag hauuwiyɨn siyɨuɨn wraisu mɨnɨm sɨm mɨ ɨni siir kou ywowɨn. ");
INSERT INTO iws_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Mɨ Jisɨs siya ta siya wakae boɨnkiya saiir wakaekiyɨn mɨ siya ɨna yaɨngwokiyɨn tɨ inkamɨn nɨnoknɨnkɨn wadɨekakɨn. Mɨ Jisɨs siya siir boɨnki, kɨra aru nwo rani, ɨni kingiinar nwowɨn kariiram nɨtɨm mɨ kariir aowa nwowɨm. Mɨ kara wɨ kɨriir Bɨiyan Inkam Komii nwowi kɨriir kɨgrɨraowam. Mɨ iikam hoɨmgakɨm sɨma Jisɨs siirsi yɨdid mɨ siirɨmɨn yai nhɨrɨm panɨɨnsi swokɨ srɨisi Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisɨs siya Adi Komii siir omaka saiir nwowɨn mɨ siya yaiyɨm iikam ɨmiirɨn hɨrar yowomwarkaiyɨu. Mɨ siya sɨmiir srɨi mɨ sɨma tɨ kamɨm siyɨu komii nɨnoknɨnkɨniyɨm, sɨma hɨnɨɨn dimusi boɨnkɨm, Kraisɨn Devidni yɨnɨeyɨm sɨmiir yɨnisɨmkɨn, ha? Mɨ ta yai hɨriinana sɨma boɨna, kɨma panɨɨna naɨngwokɨm? ");
INSERT INTO iws_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Adi Komii siir naeyɨuɨn Devid siir nɨisiimauugɨn. Mɨ Devid siya hɨnɨɨna wɨn boɨnkikɨn, Adi Komii siya kariir Bɨiyan Inkam Komiiyɨn siirɨn hɨnɨɨna boɨnkikɨn, kɨra kariir ɨɨna ɨɨnig aiir dɨdwo. Mɨ mhoɨiya kara kɨriir sau omomɨn wɨ siir waorɨmtɨokiigi. Mɨ sɨma kɨnaka wɨ kɨrɨe nwo rani, wɨ kɨriir aowa nwowi. ");
INSERT INTO iws_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Mɨ ta yaiya yokwoni siya wɨn boɨnkika. Devid siya siirɨn hɨnɨɨna dapɨkɨuwi Krais siya Bɨiyan Inkam Komiigɨn. Mɨ siya Devid siir apu dimusi nwokɨn? Tɨ inkamɨn Adi Komii siya nɨmbingiyɨn Mesaia mɨ iikam isid komiiyɨn ɨni maɨrgɨmaɨrgar ywokiyɨm, siir yai wakaeyamɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mɨ Jisɨs siya sɨmiir nowɨmwarkaiyɨuwɨm mɨ siya ɨna boɨnɨn, kɨma sɨbgu mɨntarao siyɨu komii nɨnoknɨnkɨniyɨm kamɨm sɨmiirsiyɨn. Mɨ sɨma yɨuɨs bripri kaiiyɨm mɨpa nouaptatao ami. Sɨma mɨnam naɨngwowi, iikamɨm maeyau kwɨruwa nɨdwowiyɨm sɨma sɨmiir nwokɨ boɨn wɨnɨm, akamnaei. ");
INSERT INTO iws_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Sɨma mɨnam naɨngwowi Juda sɨmiir omaka yai nɨdwokai wakaeiya iikamɨm sɨmiir whwonkam ɨda mɨnam nɨdwokaii, ɨiya nae komii aiir naei mɨ nae mɨiyɨk mɨiyɨkɨm wɨ sɨmiirar nwokɨ hauuɨm bɨiyɨn. ");
INSERT INTO iws_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Sɨma wig igabaeyɨm sɨmiir omaka ɨmiir kɨnɨnbɨmbɨramikɨm sɨmiir kamɨm naonamɨm. Mɨ sɨma nhwo kwɨsboɨniyɨm mɨ yai prɨei boɨniyɨm, sɨma pɨ nɨksɨsaei. Mɨ mhoɨiya sɨma inkam komiiyɨn yai hɨdiyɨn saɨka nokwo boɨni mɨ sɨma wɨ hɨk hɨriinansi haii. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisɨs siya mɨiya umɨr haiigiya Adi Komii siir omaka hɨr nwokaiya saiir kingiin hɨrar nɨdwokɨn. Mɨ siya ɨna nɨdwo kɨgrɨraowɨn iikamɨm umɨr nɨtkaigaiyɨuwɨm umɨr haigi mɨiya saiir. Mɨ umɨrkak kamɨm yɨm umɨr hoɨmgakar mɨ ɨtkaigaiyɨu. ");
INSERT INTO iws_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mɨ wig igabae ɨra digworaekwo karamaeya saiir kamɨn bɨdi yaowɨn, saeya ha nɨta saiir umɨr mɨrmiisɨm kwɨswo ɨna minɨ ɨtkaigaiyɨugiga. Mɨ tɨ umɨr mɨrmii mɨrmii kwɨswo saeya nɨtkaiyɨugigo ɨrɨparɨn ɨni kwɨruwar ywowa. ");
INSERT INTO iws_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Mɨ Jisɨs siya kamɨm siir kɨgna mɨriiyɨm sɨmiiram yɨkɨuna, sɨma siirɨm nɨtɨm. Mɨ siya sɨmiir boɨnki, kara kɨmiirɨn yaimwowa boɨni, ta wig igabɨeya digworaekwo karamaeya saiir kamɨn bɨdi yaowɨn, saeya umɨr prasae bɨri ninɨ ɨtkaiyɨugiga ta umɨr mɨiya saiirɨn. Mɨ iikamɨm umɨr saiir nɨtkaigaiyɨuwɨm ɨni ta wiga saeya taouugam. ");
INSERT INTO iws_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tɨ iikam omkakɨm sɨma umɨrkakɨm, sɨmiir umɨrɨm ɨna nwokaiyɨm. Mɨ sɨma nhɨrɨm umɨr mɨiya aiir haigigi. Mɨ ta wiga saeya nɨɨngakɨɨnaɨrga mɨ saiir umɨrɨm ɨna yɨtkaiyɨu swokiyɨm. Mɨ saeya ɨni nɨɨngar ywokiya. Nhɨrɨm nae saɨnaeyɨm bɨri swokɨ onaowidgɨm. Nɨɨngaka. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisɨs siya Adi Komii siir omaka saiir haiburgigɨn mɨ siya ɨna yapamɨn. Mɨ inkam nwɨrɨn siir kɨgna mɨriiyɨn siya boɨnki siirɨn, dimɨn taemɨn nowɨmwarkaiyɨuwan inkam! Tɨ siiya komii komiiyɨm sɨmiir kɨgi. Mɨ omaka mɨiyɨk mɨiyɨkɨm Adi Komii siir omaka kingiin nwowɨm sɨmiir kɨgi! ");
INSERT INTO iws_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Mɨ Jisɨs siya siir yai aiirɨn hɨnɨɨna yowarkɨi boɨnki, kɨra ɨna kɨgɨn tɨ omaka komii komiiyɨm, aniya? Mɨ kɨra wa kɨg rani, siiya nhɨrɨm ɨni siiya nhɨrɨm sɨmiir ɨdwo haigɨnɨm. Nɨɨngaka. Mɨ sɨma wa nhɨmnhɨnkɨinaiinami. Mɨ nhɨrɨm wa nɨki ɨpɨmpamki. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jisɨs siya mhɨu Oliv siir nɨdwokɨn mɨ siya yɨdwo kɨgi yarmiya hɨriir, Adi Komii siir omaka komiiya hapi nwowi mɨ Pita, Jems, Jon mɨ Endru sɨmasɨmar yɨt Jisɨs siirɨmɨn. Mɨ sɨma siir inɨ srɨini, ");
INSERT INTO iws_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","kɨra krɨmiir boɨnmauugi, wɨ paka hɨnɨɨn ɨiya saiir nɨmbinii tɨ digworaekwowɨm. Wɨ pɨkɨ hɨnɨɨn dimɨn ɨkɨ nɨmbinii bɨiyɨn krɨma nɨnoknɨnkɨnamɨn. Mɨ tɨ digworaekwowɨm ɨni kingiin nwowɨm wɨ sɨmbi nɨmbini, ha? ");
INSERT INTO iws_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Mɨ Jisɨs siya sɨmiir boɨnki, kɨma ha hiirtarao, kɨmiirɨn wɨ inkam nwɨrkɨn pɨ nɨksɨsaeisi. ");
INSERT INTO iws_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kam nhɨrɨm sɨma wɨ kariir inɨg ɨiir ninɨ kinsɨna dapnii. Mɨ sɨma wa boɨni, tɨ inkamɨn yɨo karaɨrgɨn. Mɨ sɨma wɨ iikam hoɨmgakɨm sɨmiir nɨksɨsaei mɨ sɨma wa nwokɨ aɨngwo tɨbmiiyɨm. ");
INSERT INTO iws_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mɨ ɨiya kɨma ha wakaei yaiiya ɨni kingiin tɨrar kwɨniiya mɨ yaii kwɨra ɨni hɨndankɨn mɨ kirɨrɨrniya mɨ kɨma wɨ kɨpi naɨngwoyɨmyokwɨn, takɨna ya wɨ bɨi nɨmbinii. Mɨ ɨiya dɨgiyana ya ɨna nikɨ owa. ");
INSERT INTO iws_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kam nhɨrɨm om whɨranɨm wɨ om whɨraka ninɨ ɨniiyɨuwi. Mɨ nu whɨran kamɨm wɨ nu whɨran kamɨm yaii sɨmaka ninɨ ɨniiyɨuwi. Mɨ maeyau nhɨrɨm nɨɨnɨn wa mɨ ɨti mɨ mhɨi wa mɨ aowi. Mɨ tɨkɨ hɨnɨɨn dimɨnpai dimɨnpaiyɨm sɨma nɨmbiyami, mhoɨiya wɨ komiiya nasae owɨuguski wɨ gwo rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Kɨma kɨmasiyar timɨ mɨntɨrao, kɨmiirɨn wɨ sɨma nonkworɨmdɨnu hainami kamɨm yai hɨdwɨniyɨm sɨmiirɨm. Mɨ sɨma kɨmiirɨn wɨ omaka yai nɨdwokai wakaeiya hɨrar tɨoki. Mɨ sɨma kɨmiirɨn wɨ inkam komii komiiyɨm omom omom kɨgrɨraowiyɨm mɨ inkam komiiyɨm nu kɨgrɨraowi ɨkɨm, wɨ sɨmiir whwonkam ɨda ninɨ okmwɨn okwoɨuwi. Mɨ kɨma wɨ kariir yaiwɨn kɨbiya saiir nikɨ boɨnmɨmauuwɨm sɨmiirɨn. ");
INSERT INTO iws_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ɨiya dɨgiyana wɨ aisiima nikɨ dɨgi rani, iikamɨm omom omomanɨm hɨnda tɨnda nwowɨm sɨma ta yaiwɨn kɨbiya saiir tikɨ wakae dɨgi. ");
INSERT INTO iws_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mɨ ɨiya sɨma kɨmiir nonkworɨmdɨnu hainami inkam komiiyɨn yai hɨdwɨniyɨn siirɨm mɨ kɨma wɨ kɨpi nɨdid mɨ wɨ ha kɨpi naɨngwo, krɨma wɨ panɨɨn yaiyɨm sɨm boɨni, ha? Nɨɨngaka. Yai hoɨmgakɨm Adi Komii siya wɨ ta ɨi aiirar boɨnmɨmauugi. Mɨ yaiyɨm kɨma boɨni mɨ wɨ kɨma boɨn tani. Nɨɨngaka. Wɨ Adi Komii siir naeyɨuɨn siyar boɨni. ");
INSERT INTO iws_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mɨ yaowae wɨ siir nomousɨm ɨiirar nɨkropkii kamɨm sau nɨnɨtiyɨm sɨmiirɨm, sɨma nɨtɨm siirɨn. Mɨ adɨn siir yɨnisɨm ɨiirɨn wɨ tɨ hɨriinan siyɨu ɨiirar mɨ tɨri. Mɨ yɨnisɨmɨm yɨm wɨ sɨmiir yopii adɨm sɨmaka nɨnii yaii. Mɨ sɨmiirɨn wa nɨkropki kamɨm sau nɨnɨtiyɨm sɨmiirɨm, sɨma nɨtkikɨkɨnɨm sɨmiirɨn. ");
INSERT INTO iws_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mɨ iikam hoɨmgakɨm sɨma kɨmaka ɨo wɨ whɨsarii nwo rani, kɨma kariir siyɨu ɨiir napikɨm. Mɨ sɨma wɨ tɨ hɨriinan siyɨuɨn siir asi tɨri kɨmiirɨn. Ɨiya dɨgiyana saeya dɨgi mɨ tɨ inkamɨn hɨkpai hɨkpaisi nɨkii karam nwowɨn mɨ siirɨn wɨ Adi Komii siya nanmaiwarkainaei. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Mɨ ɨiya kɨma tɨ dimɨn biyɨekɨ biyɨeyɨn om kopbumbuwiyɨn siir kɨgi, siya wɨ maeyauwa haiyaeiya wɨ saiir nokwowɨni. Mɨ inkamɨn ta yaiya saiir mwaɨni, siya wɨ sɨbgu dɨnoknɨnkɨn mwaɨn. Mɨ ta ɨiya iikamɨm nu Judia hɨr nwowɨm, sɨma wɨ mhɨua hɨriir nɨdamami. ");
INSERT INTO iws_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mɨ inkamkɨn pɨu aeyɨn hɨi hɨr nɨdwo siiswaki, siya wɨ siir omaka hɨri swokɨ iwɨt iiyam tani, siir digworaekwo ɨmiir hainakiyɨm. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ɨiya inkamɨn siya siir numɨr aiir tɨrkwowaki, siya wɨ swokɨ haiyɨug am tani, siir yɨuɨs aiir hainakiyɨmɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mɨ yɨmbisɨmɨm wigɨm yɨnpɨugak nwowɨm mɨ nhɨrɨm yɨnisɨmɨm mwɨiyar nikɨ aeyɨm mɨ sɨma wɨ hɨk prasae hai rani. ");
INSERT INTO iws_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mɨ kɨma nhwo kwɨsboɨn tɨ dimɨnɨn ta ɨiya nao komiigɨ kɨniya saiir kɨpi nɨmbini. ");
INSERT INTO iws_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mɨ ta ɨiya wɨ hɨk prasae hai rani. Mɨ ɨiya Adi Komii krɨmiir Wanɨn siya tɨ digworaekwo whɨekakɨm sɨmiir nonkwokwowɨn mɨ ta hɨriinan hɨka bɨ nɨmbiyamka, tariinanɨn tasa nikɨ oyokiyokwɨiya. Mɨ mhoɨiya ɨriipɨ hɨriinan, ta hɨk hɨnɨɨna wɨ nɨmbiyam tani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mɨ Adi Komii siya ta ɨi aiirɨn haruwa nikwonɨnkikrɨpna karamae nwowi mɨ iikam whɨekakɨm sɨma wɨ hinda prɨiyop ɨtkaigii. Mɨ siya iikamɨm siya nɨmbingiyɨm sɨmiirsi naɨngwoyɨmiyokɨn mɨ siya ta ɨiya haruwa asi nikwonɨnkikrɨpnakika. ");
INSERT INTO iws_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Mɨ ta ɨiya inkam nwɨrɨn kɨmiir boɨnkɨn, kɨgi! Kraisɨn tɨsi tapi nwowɨn. Mɨ nwɨrɨn yɨo wa mɨ kwaboɨni, kɨgi! Krais siya ɨsi hapi nwowɨn. Mɨ kɨma wɨ kaimwo kɨpi nwo ta yai aiirɨn. ");
INSERT INTO iws_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mɨ mhoɨiya kam nhɨrɨm wɨ ha nɨksɨsaei, kara Kraiskɨn mɨ kara profet inkam nwɨrɨn, wɨ sɨmiir hɨriinan nwonanii. Mɨ sɨma dimɨn komii komiiyɨm mɨ mɨipai mɨipaiyɨm wa mɨ kɨnɨnankɨuwi iikamɨm Adi Komii siya nɨmbingiyɨm sɨmiir nɨksɨsaeyam. ");
INSERT INTO iws_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mɨ kɨma sɨbgu mɨntarao, tɨ digworaekwowɨm tapa kara boɨnmɨmauu dɨgiyɨm kɨmiir, mhoɨiya wɨ sɨmar swokɨ ɨmbiyami. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Mɨ ɨiya ta hɨk komiiya saeya dɨgi mɨ taka ɨiya bɨeyɨn wɨ hindara kakauu ɨuguskii. Mɨ bwana wɨ mɨ who rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Mɨ nauunɨm wɨ nɨnomor hɨranka nɨkɨikɨi nainii. Mɨ digworaekwo kɨrɨe kɨrɨeyɨm nɨnomor kouanɨm wa kiisɨskii. ");
INSERT INTO iws_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Mɨ wɨ sɨma kɨgwɨni Yaowae Adɨn nɨnomor kouanɨn wau mɨrsɨma saɨka nɨnkɨn ɨti. Mɨ siir kɨrɨe komiiya mɨ siir dimɨn mɨiyɨkɨn paenan nɨuyaeiyɨn wɨ warar nɨnkɨn ɨti. ");
INSERT INTO iws_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Mɨ ta ɨiya siya wɨ siir paekwosɨmɨm sɨmiir nɨkropki. Mɨ siya wɨ iikam whɨekakɨm nuanɨm siya nɨmbinkiyɨm hɨnda tɨnda nwowɨm, wɨ sɨmiir nɨkɨuna dɨgi, maeyau kwɨruwa nangiriyɨuniyɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Kɨma whrou siirar dɨnoknɨnkɨn, ɨiya pɨ whrou siya woki tɨ hɨriinanɨn krɨma pa nɨnoknɨnkɨni opɨn wɨ sɨpi nɨuwi. Mɨ opud naowɨn wa mɨ ɨkii kɨni. Ta hɨriinan ɨiya saeya opkɨ nɨuwiya. ");
INSERT INTO iws_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mɨ hɨriinankɨnɨuwi mhoɨiya wɨ kɨmar kɨgi tɨ dimɨnɨn ɨni yɨmbiyamɨn. Mɨ kɨma wɨ nwokɨ ɨnoknɨnkɨnkiyɨm, ɨiya Yaowae Adɨn nɨnomor kouanɨn siir ɨiya tɨriir nɨtana kingiin bɨdi ywowa. ");
INSERT INTO iws_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kara kɨmiirɨn yaimwowa boɨni, tɨ iikamɨm nwowɨm sɨma wɨ nikɨ ao rani mɨ tɨ digworaekwo hoɨmgakɨm wa nɨmbiyami. ");
INSERT INTO iws_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mɨ nu nɨnomorwo yo wa dɨgii mɨ kariir yaiya wɨ wara dɨgi rani. Nɨɨngaka. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Inkam nwɨrkɨn nɨnoknɨnkɨn tani ta ɨi aiirɨn nugak, nabɨe mɨ naɨowaka. Nɨɨngaka. Mɨ paekwosɨmɨm nɨnomor kouanɨm yɨm hɨriinan ta ɨiya saiir mɨ ɨnoknɨnkɨn tani. Mɨ Adi Komii siir yɨnisɨmɨn ɨriipɨ hɨriinan ta ɨi aiirɨn wara mɨ ɨnoknɨnkɨn tani. Nɨɨngaka. Adɨn sasar nɨnoknɨnkɨn ɨski ta ɨi aiirɨn. ");
INSERT INTO iws_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kɨma mɨntarao mɨ kɨma wɨ nhwo kɨpi whwonkai kɨma nɨnoknɨnkɨn tani, tɨkɨnɨn wɨ paka hɨnɨɨn ɨiya sae nɨmbinii. ");
INSERT INTO iws_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Siya inkam nwɨrɨn siir hɨnɨɨngɨn siir omaka saiir haiburgikɨn mɨ ɨna yapnamɨn maeyau gwɨra. Mɨ kamɨm whɨsarii mɨi prɨimɨriiyɨm siir mɨi ɨmiir, siya mɨiyɨm sɨmiirɨn yapa yapa yonkwo dɨgig. Mɨ siya inkamɨn ano ɨiir kɨgrɨraowiyɨn siir boɨngig, kɨra sɨbgu kɨgrɨrao nhwo kɨpi whwonkai. Jisɨs siir boɨniyɨo yaiya dɨg ywokiya. ");
INSERT INTO iws_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jisɨs siir yaiya tasa nikɨ ama. Mɨ kɨma wɨ asi kɨgrɨraowi kɨma nɨnoknɨnkɨn tani, ɨiya omakan inkamɨn siya nɨti. Siya wɨ paka hɨnɨɨn ɨiya sae namisi ɨti, siya nɨibopwo namisi ɨti, iyɨe? Wɨ ɨuumaka namisi ɨti, iyɨe? Wɨ nugak namisi ɨtyakwoki kɨma nɨnoknɨnkɨn tani. ");
INSERT INTO iws_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mɨ kɨma sɨbgu kɨgrɨrao, siya kɨmiirɨn wɨ hindara nhɨngaknisi. Siya wa kɨgnisi, ɨna nikɨ whwonkaiyɨm. ");
INSERT INTO iws_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ta yaiya kara kɨmiir boɨnmauugiya, kara iikam hoɨmgakɨm sɨmiir warar boɨnkika, kɨma mɨntarao! Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mɨ ta ɨi komiiya Pasova dimɨn whɨrkɨn kɨmbu karam nwowiya, bretɨn waisikaiyɨn yis karamaeyɨn siir nikwo aeiya ɨiya mɨ ta nae komiiya uga nikwo aebwakainami. Mɨ prismi yaowae adɨm mɨ kamɨm siyɨu komii nɨnoknɨnkɨni ɨkɨm sɨma boɨn, krɨma Jisɨs siirɨn wɨ panɨɨna nonkworɨmdɨnu haɨnprakaii? ");
INSERT INTO iws_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Mɨ sɨma boɨn, krɨma wɨ ta ɨi komiiya Pasova wɨ saiir kɨpi nɨsɨkɨina nɨm wɨ tɨ iikamɨm siir whɨn nwowɨm wɨ sɨma pɨ whɨnɨniisi siirsiyɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisɨs siya om Betani hɨr nwokɨn Saimon siir omaka aiir. Tɨ inkamɨn paowaigɨ pɨskɨmkopouɨn. Mɨ ɨiya Jisɨs siya ha nikɨ ɨdwo aeyɨn mɨ wig ɨra ɨna yapnɨnopkainaniya siirɨm. Mɨ tɨ wa mobɨn umɨr prasae bɨ saɨngɨn. Mɨ saeya kwaigwowa ɨna kinɨs haigiya tɨ wa mobɨn siir kɨbokouwa. Mɨ tɨ wa mobɨn pɨuii mɨiyɨkakɨn ɨni Jisɨs siir mwo ɨiirarar yaokɨn swokiyɨn. ");
INSERT INTO iws_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mɨ iikam nhɨrɨm ta omaka saiir nwowɨm, sɨmiir kwoɨnɨm mɨiyɨk bɨri naɨngwokikɨm ɨni ɨo kwoɨn yaɨngwokiyɨm. Mɨ sɨma, sɨma sɨmar yomboɨn amboɨn, saeya tɨ wa kɨbiyɨn siirɨn whɨsarii dimusi prɨidirɨraerarkikɨn, ha? ");
INSERT INTO iws_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mɨ tɨkɨ wa krɨmiir tɨrankɨn saɨnakikɨswo mɨ siya pɨ umɨr prasae di saɨni. Mɨ siya umɨr paeyarɨm kamaɨrɨm pɨ ɨuur ɨriiyar K300.00 nanar pɨ saɨnɨn. Mɨ siir umɨrɨm pɨ ɨkɨ iikamɨm digworaekwo umɨr mɨnam whaowaeiyɨm sɨmiir pɨ hauuɨn. Mɨ sɨma ɨo ta wig aiir ywoki. ");
INSERT INTO iws_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mɨ Jisɨs siya boɨnki, kɨma ta wiga saiirɨn hindara kɨg nɨnkɨnki. Mɨ kɨma saiirɨn yai whɨsarii dimusi boɨni? Saeya kariirɨn siyɨu wadɨekɨ wadɨeyɨn siirar tɨrkika. ");
INSERT INTO iws_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mɨ iikam paeprikabɨm ɨinokɨinokɨn sɨma wɨ kɨmakar nwokrɨpkaii tɨ nu ɨiirar. Mɨ kɨma digworaekwo sɨmiir hauuwi, wɨ hɨriiyar tɨ hauu. Mɨ ankara kɨmaka wɨ ɨi prɨei nwo rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Dimɨnɨn wig aeya tɨram naɨngwowi, saeya wa tɨri. Saeya tɨ wa wadɨeyɨn kariir pɨu naokɨnkiyɨn, ɨe haɨngikaiyam naokɨn haigɨnɨugikɨn. ");
INSERT INTO iws_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kara kɨmiirɨn yaimwowa boɨni mɨ tɨ nuɨm hɨnda tɨnda nwowɨm wɨ yai wɨn kɨbiya saiirar mɨ boɨnmɨmauuwi. Mɨ tɨ omom omomɨm wɨ tɨ dimɨnɨn siirar mɨ haigirɨrɨr boɨniyokiyokɨii, ta wiga saeya tɨrkiyɨn. Mɨ sɨma wɨ siirɨmar naɨngwokwowi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Mɨ Judas Iskariot siya kam ɨuur nwɨso sɨmiir nwɨrkɨn. Mɨ siya prismi yaowae adɨm sɨmiirɨm yam, wɨr sɨmiir ninɨ apwougigɨm. ");
INSERT INTO iws_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Sɨma ta yaiya saiir wakaewɨnɨm, sɨma ɨni maɨrgɨmaɨrga ywowɨm. Mɨ sɨma ɨna yɨmbingiyɨm umɨr siir hauuwam. Mɨ ta ɨi aiirarɨn Judas siya ɨna yap hansɨr bwakaiyɨn, Jisɨs siirɨn sɨmiir kɨnmauu ɨtɨm. ");
INSERT INTO iws_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mɨ bɨikɨ bɨiyan ɨiya bret waisikaiyɨn yis karamaeyɨn siir naeiya ɨna yɨmbiniya. Mɨ sɨma sibsib yɨnisɨmɨm saiir yɨsomsom aokao ta nae komiiya Pasova saiirɨm, saiir naekwowakam. Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma siir srɨi, krɨma nae pɨ papi ninɨ dirɨraerarɨuwi, ta nae komiiya saiir naeyɨm, kɨra naeyamɨn, ha? Mɨ sɨma Jisɨs siirɨn hɨnɨɨna srɨigɨm. ");
INSERT INTO iws_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Mɨ Jisɨs siya kamɨm siir kɨgna mɨriiyɨm nwɨsa yɨkropki. Mɨ siya sowiir boɨnki, kowa om komii ɨiirar dapnɨnopkainam. Mɨ inkam nwɨrɨn op two komiiya opkaka saiir hainani mɨ siya kowiirɨn pɨ om komii hɨr napyɨskaigɨn mɨ kowa wɨ siir mhoɨiya dam. ");
INSERT INTO iws_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mɨ siya omaka ɨr napnɨnopkainamkɨn mɨ kowa saɨkar dɨnkɨn apnɨnopkainam. Mɨ kowa ta omaka saiir adɨn siirɨn pɨ hɨnɨɨna tinɨ boɨnɨu: Dimɨn taemɨn nowomwarkaiyɨuwan inkamɨn siya hɨnɨɨna boɨnkikɨn, kariir maeyaua ɨni papi nwowa ta nae komiiya Pasova kamɨm kariir kɨgna mɨriiyɨm sɨmaka naeyana, ha? ");
INSERT INTO iws_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mɨ kowiirɨn wɨ siya nɨisiimauuwi, maeyau kwɨra omaka anauwa kouana saiir nwowa. Mɨ ta maeyaua hɨi ipii saiirara. Mɨ kowa krɨmiir naeyɨm wɨ ta maeyau aiir tinɨ dirɨraerar kwokɨn, krɨma naeyam. Siya sowiirɨn hɨnɨɨna boɨnkikɨn. ");
INSERT INTO iws_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Mɨ inkam nwɨso siir kɨgna mɨriiyo ɨna yamwo. Mɨ sowa om komii hɨriir yɨmbiyam. Mɨ digworaekwowɨm Jisɨs siya boɨnkiyɨm sowa ɨni sɨmiirar inɨ kɨgɨuwɨm. Mɨ sowa nae komiiya ɨna dirɨraerar kwokɨno ta Pasova nae komii aiiram. ");
INSERT INTO iws_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mɨ naɨowaka Jisɨs siya siir kɨgna mɨriiyɨm kam ɨuur nwɨso sɨma yɨtrɨb. ");
INSERT INTO iws_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mɨ ɨiya sɨma hɨiya nae haigɨn aeiya saiir hɨrar nɨdwoyokai aeyɨm mɨ Jisɨs siya boɨn, kara kɨmiirɨn yaimwowa boɨni, inkam nwɨrɨn krɨmaka tɨr nɨdwokai aeyɨn kariirɨn wɨ wɨr siya napwouwi. ");
INSERT INTO iws_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma ɨni hɨkakar ywokiyɨm. Mɨ sɨma, sɨma sɨma yɨnsrɨi ansrɨi siirɨn mɨ tari kara, aniya? ");
INSERT INTO iws_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Mɨ Jisɨs siya ɨna yowarkɨi boɨnkiyɨn, kɨma tɨ kam ɨuur nwɨso kɨmiir nwɨrkɨn nɨuwi ɨni tɨrar nwowɨn. Mɨ tɨ inkamɨn ɨɨn kanakar nɨnkɨn ɨnopkai haiiyɨn ta twowa nae haigiiya mɨ wɨ siyar napwouwi wɨra kariirɨn. ");
INSERT INTO iws_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Hɨipa! Tɨ inkam yaowae adɨn nɨnomor kouankɨn nɨtɨn siya wɨ sɨpi naowi. Siya karaɨrgɨn. Adi Komii siir Yokwo Komiiya saeya hɨnɨɨna boɨnkika mɨ wɨ mɨntarao tɨ inkamɨn wɨr kariir napwouwɨn sau omomɨn siir, siirɨn wɨ hɨk prasaekɨ nɨmbiyam tani. Mɨ tɨ inkamɨn siir yopiiya siir naokaina karamae nwokɨswo, ɨni wadɨekɨ wadɨeya mɨ owɨn. Dimusi rani, tɨ inkamɨn siya wɨ hɨk prasae hai rani. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mɨ sɨma ha nikɨ aeyɨm mɨ Jisɨs siya bretɨn nhɨra hai mɨ siya Adi Komii siir boɨn wadɨeki. Mɨ siya ɨna yɨinɨbɨmbɨr hauugiyɨn kamɨm siir kɨgna mɨriiyɨm sɨmiir. Mɨ siya boɨn, kɨma hai, tɨkɨnɨn yɨo kariir kɨpka. ");
INSERT INTO iws_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mɨ siya mob wainɨn ɨra mɨ hai. Mɨ siya ɨna mɨ boɨn wadɨekiyɨn Adi Komii siirɨm. Mɨ siya ɨna hauugiyɨn sɨmiir, sɨma kwiyaeyam. ");
INSERT INTO iws_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Mɨ siya sɨmiir boɨnki, takɨna ya kariir nhɨeka Adi Komii siya nɨmbingig aeya. Mɨ kariir nhɨeya wa naokiinaiinami iikam whɨekakɨm sɨmiir whɨndirɨraerar haigɨnɨuwam. ");
INSERT INTO iws_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kara kɨmiirɨn yaimwowar boɨnkii, tɨ op wainɨn kara wɨ ɨdɨp ɨdɨp swokɨ kwiyae rani. Nɨɨngaka. Mɨ hɨriiyar namiyokiyokɨii mɨ wɨ ɨiya kara wainɨn Adi Komii siir omɨn digworaekwo whɨekakɨm sɨmiir kɨgrɨraowiyɨn wɨ siir hɨrar ninɨ kwiyaeyɨu ɨski. Jisɨs siya hɨnɨɨna boɨnkikɨn. ");
INSERT INTO iws_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Mɨ sɨma mwai kwɨra wao. Mɨ sɨma mhɨu Oliv hɨriir yam. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Mɨ Jisɨs siya sɨmiir boɨnki, kɨma wa nɨdamgrirgigi wɨ kanaka nwo rani. Adi Komii siir yaiya Yokwo Komii saiir nwowa hɨnɨɨna boɨnka, inkamɨn sibsib kɨgrɨraowiyɨn Adi Komii siya nɨsomaokii mɨ siir sibsibɨm wa nɨdam nɨnoopkii. ");
INSERT INTO iws_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Mɨ kara wa swokɨ ɨnsiin ɨdwowi ɨe hɨrankɨn. Mɨ bɨiyɨn wɨ karar namkwokɨni nu Galiliya hɨriirɨn. Mɨ wɨm kɨma wɨ kariir mhoɨiya nɨti. ");
INSERT INTO iws_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita siya ɨna yowarkɨi boɨnkiyɨn siir yai aiirɨn, yɨm sɨma kɨriirɨn wa nɨdamgrirmiigigi mɨ ankara nɨɨngaka. Kɨriirɨn wɨ kinɨsu rani. Nɨɨngakɨ, nɨɨngakɨɨnga. ");
INSERT INTO iws_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Mɨ Jisɨs siya siir boɨnki, kara kɨriirɨn yaimwowa boɨni mɨ ta nɨiyaka ɨuumɨn kwɨsaka wɨ nikɨ ɨk rani mɨ kɨra kariir inɨgɨn wɨ hɨriiyar mɨisɨsaei krɨpkaii. Mɨ kwoɨmaka wɨ kɨra wakaeki ɨuumɨn ɨni nɨkiyakwokɨn. ");
INSERT INTO iws_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mɨ Pita siya ɨni ɨgao yaiyar boɨnkiyɨn, kara kɨriirɨn wɨ swokɨ ɨmprɨo rani. Nɨɨngakɨ! Nɨɨngaka! Mɨ kara kɨnakar nɨnkɨn aowama mɨni mɨ kara kɨriir inɨgɨn wɨ mɨ ɨmprɨo rani. Mɨ kam nhɨrɨm siir kɨgna mɨriiyɨm yɨm ɨriipɨ hɨriinan yai aiirar mɨ boɨnki. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Mɨ sɨma maeyau kwɨra saiir yɨmbiyam Getsemani. Mɨ Jisɨs siya kamɨm siir kɨgna mɨriiyɨm sɨmiir boɨngig, kɨma tapaiir dɨdwoki, kara nhwo nikɨnɨ kwɨs boɨnɨuwi. ");
INSERT INTO iws_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Mɨ siya Pita Jems mɨ Jon sɨmiirarar yɨkɨunam, saɨka namam. Mɨ siya ɨni hɨkakar ywokiyɨn. Mɨ siir kɨuɨn kɨugak bɨ nwokikɨn. ");
INSERT INTO iws_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Mɨ siya sɨmiir boɨnki, kɨma whaowae nwowi kariir kwoɨn siyarɨn ɨni wara yɨiyɨuamwankiyɨn. Mɨ kariir pɨua ɨni warar yɨnkisɨmsɨbnakiya. Kɨma tɨrar dwoki mɨ kɨma sɨpgu mɨntarao. ");
INSERT INTO iws_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Mɨ siya ha kwapnamɨn mɨ ɨni hindara yakai whɨnamɨn nu hɨrar. Mɨ siya ɨna kwɨsboɨnkiyɨn Adi Komii siirɨm. Adi Komii, kɨra dɨgar mɨ owi mɨ ta hɨka wɨ kariir mɨ ɨmbini rani. ");
INSERT INTO iws_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Mɨ siya boɨnki, adiyo! Ɨiya kɨra digworaekwo hoɨmgakɨm sɨmiir tɨramar naɨngwowi, kɨra wɨ dɨgar mɨ owi. Mɨ ankara hɨnɨɨna naɨngwowi, ta kariir hɨka kɨra saiir hainaowid. Mɨ kɨra kariir kwoɨn ɨiirara kɨpi nwo, kɨriir kwoɨn ɨiirar timɨ o. ");
INSERT INTO iws_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Mɨ siya ha swokɨ ɨtɨn mɨ ɨna kɨgniyɨn, sɨma nhwo ara grɨnkɨn whɨni. Mɨ siya Pita siir inɨ boɨni, Saimon! Kɨra nhwo whɨni, aniya? Mɨ kɨra pɨ haɨmiisɨma nɨdwo kao rani, aniya? ");
INSERT INTO iws_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kɨma dɨdwo kao mɨ kɨma nhwo mɨn timɨ srɨiboɨn. Mɨ dimɨn whɨrkɨn kɨmiiram kɨnankɨuwi, wɨm wɨ nɨkiisi. Kwoɨnɨn ɨna naɨngwowɨn dimɨn taemɨn tɨramɨn mɨ pɨu saeya kɨnɨi rani. ");
INSERT INTO iws_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Mɨ siya ɨna swokɨ amɨn nhwo ɨna swokɨnɨ kwɨsboɨnɨuɨn. Mɨ siya yaiyɨm bɨiya siya nikɨnɨ srɨiboɨnɨuɨm, sɨmiirar swokɨnɨ srɨiboɨnɨu. ");
INSERT INTO iws_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Mɨ siya ɨna swokɨ ɨtɨn kamɨm siir kɨgna mɨriiyɨm sɨmiiram. Mɨ yɨm sɨma nhwokɨ nɨridnanaekɨm mɨ sɨma nhwo asi grɨnkɨnwhɨnkɨm. Mɨ sɨma siirɨn ɨni yai kaonɨs boɨnam whaowaeyɨm. ");
INSERT INTO iws_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Mɨ siya kwoɨmaka ha swokɨ ɨtɨn sɨmiiram mɨ siya ɨna inɨ boɨniyɨn sɨmiirɨn, kɨma ɨna nikɨ grɨnkɨnwhɨnkrɨpkaiyɨm, aniya? Ɨni dɨg ywoki, kɨma tɨ kɨgi, ɨiya tɨ inkam yaowae adɨn nɨnomor kou hɨrankɨn nɨtɨn siir nonkwonakiyana kam bibiyɨeyɨm sɨma, bɨdi yɨmbiniya. ");
INSERT INTO iws_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kɨma dɨnsiin, krɨma pɨ nami. Tɨ kɨgwɨn, inkamɨn wɨr kariir napwougigɨn ɨsi nɨtɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisɨs siir yaiya bɨri nikɨ dɨgika mɨ Judasɨn kam ɨuur nwɨso sɨmiir nwɨrɨn siya ɨna yɨtɨn. Mɨ kam isid komiiyɨn saɨka yɨnkɨn ɨt. Mɨ sɨma kamkɨu mɨnɨm mɨ dan mɨnɨm sɨmiir warar yɨnkɨn hainani. Mɨ prismi yaowae adɨm mɨ kamɨm siyɨu komii nɨnoknɨnkɨni ɨkɨm mɨ kam adi yaowaeyɨm siyɨu komii kɨgrɨraowi ɨkɨm sɨmiirɨn sɨma nɨkropkikɨm siir nonkworɨmdɨnu hainakiyam. ");
INSERT INTO iws_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Mɨ inkamɨn wɨr Jisɨs siir napwouwɨn mɨ siya hɨnɨɨna boɨnɨrargig kɨma pa kɨgɨn, inkamɨn pɨ kara ninɨ aepirɨmdɨnɨuwi mɨ tɨ inkamɨn siyaɨrgɨn. Mɨ kɨma pɨ siir donkworɨmdɨnu hainam. ");
INSERT INTO iws_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mɨ Judas siya ha namɨn mɨ siya ɨni Jisɨs siirɨmar youap hɨrɨrɨu namɨn. Mɨ siya ɨna inɨ boɨnɨuwɨn, dimɨn taemɨn nowomwarkaiyɨuwan inkam. Mɨ siya ɨna yaka aepirɨmdɨnɨuɨn siirɨn. ");
INSERT INTO iws_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Mɨ sɨma Jisɨs siirɨn ɨna yonkworɨmdɨnu kihainamɨm. ");
INSERT INTO iws_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mɨ Jisɨs siirar inkam nwɨrɨn siir kingiinar nokwoɨn siir kamkɨuɨn ha kwakiwokhaiyɨn mɨ ɨni tɨ prismi yaowae adɨn siir mɨi whɨsarii prɨi mɨriiyan inkamɨn siir wɨɨn aiir yaka haɨngrɨp ɨtkigiyɨn. ");
INSERT INTO iws_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Mɨ Jisɨs siya sɨmiir boɨnki, kɨma tɨ kariirɨm nɨtɨm mɨ kɨma tɨ kamkɨu mɨnɨm mɨ dan mɨnɨm sɨmiirɨn wara dimusi hainanikɨm, kariir nonkworɨmdɨnuwamɨn, ha? Kɨma ha naɨngwokɨm kara kɨmiir hɨiyan inkamkɨn, aniya? ");
INSERT INTO iws_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ɨi kasa rani, kara kɨmiir nowomwarkaiyɨuwɨn Adi Komii siir omaka saiir hɨr. Mɨ kɨma kariir bɨ nonkworɨmdɨnugɨm. Mɨ Yokwo Komii saiir yaiya ɨni kaimwowar ywowa. ");
INSERT INTO iws_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma ha haiburgigɨm siirɨn mɨ yɨm sɨma ɨna yɨdamkiyɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mɨ whran nwɨrɨn Jisɨs siir mhoɨiya namɨn siya yɨuɨs arar kainamkɨn. Mɨ sɨma siir nonkworɨmdɨnu haiyam tɨrkɨm. ");
INSERT INTO iws_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Mɨ ta siir yɨuɨsa ɨni sɨma yɨinɨkiwhro hainaowida. Mɨ siya ɨni parurar iwɨt amɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Mɨ sɨma Jisɨs siirɨn prismi bɨikɨ bɨiyan yaowae adɨn siir omaka hɨriir yɨkɨunam. Mɨ prismi yaowae adɨm mɨ inkam adiyaowaeyɨm siyɨu komii kɨgrɨraowiyɨm mɨ kamɨm siyɨu komii nɨnoknɨnkɨni ɨkɨm mɨ sɨma ɨna yɨtɨm ta omaka aiirara namwoniyam. ");
INSERT INTO iws_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Mɨ Pita siya Jisɨs siir mhoɨiya yam. Mɨ siya kingiin bɨ nwokɨn, ɨni aru hɨrar ywokiyɨn. Mɨ siya ɨna yapnɨnopkainamɨn hira saiir ano ɨiir, prismi bɨigɨ bɨiyan yaowae adɨn siir omaka maeyau hɨriir. Mɨ siya kamɨm waikaowiyɨm pae sɨmaka inɨ ɨdwo oniyɨu. ");
INSERT INTO iws_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mɨ prismi yaowae adɨm mɨ inkam komiiyɨm yai hɨdiyɨm mɨ sɨma kam nhɨrɨm sɨmiir yɨkɨuna sɨma boɨnmauuwɨm siyɨu biyɨeyɨm Jisɨs siya tɨrɨm sɨmiir. Mɨ sɨma siirɨn wɨ hɨriinansi nwokɨ ɨsomsomɨm. Mɨ sɨma ha kɨgɨm siirɨn mɨ siya dimɨn biyɨe whɨr bɨ tɨrkɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mɨ tɨ kamɨm sɨma yaimwoni bɨ boɨnkɨm, sɨma hindara prɨiboɨnkɨm. Mɨ sɨmiir yaiyɨm ɨrɨpa bɨ nwokɨm ɨni yapa yapa ywowɨm. ");
INSERT INTO iws_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mɨ kam nhɨrɨm siirɨn pɨ whɨsariiya prɨinɨnsiin okwo boɨnki. Mɨ sɨma hɨnɨɨna boɨnkɨm. ");
INSERT INTO iws_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Nɨm krɨma ha wakaekɨm siya hɨnɨɨna boɨnkɨn, ta Adi Komii siir omaka inkamkar nonkwo mɨriiya saiirɨn wɨ kara nɨipɨrgigi. Mɨ ɨi kwoɨmɨm dɨg nwoki mɨ kara saiirɨn wa swokɨ haɨninansiin mɨrii nami. Saiirɨn wɨ inkamkɨ nonkwo mɨrii rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mɨ ta yaiya tɨ kamɨm sɨma boɨna, yɨm sɨma ɨriipa hɨriinan yaimwoni bɨ mɨ boɨnkɨm. Sɨmiir yaiyɨm ɨrɨpa bɨ namasugɨm, ɨni yapa yapa ywowɨm. ");
INSERT INTO iws_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mɨ prismi bɨikɨ bɨiyan yaowae adɨn siya sɨmiir whwonkam ɨda yɨnsiin okwoki. Mɨ siya ɨna srɨiyɨn Jisɨs siirɨn mɨ kɨra tɨ yaiyɨm sɨma prɨiboɨn prɨiboɨnɨm sɨmiir yai yamdi nowarkɨi boɨn tani, aniya? ");
INSERT INTO iws_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mɨ Jisɨs siya yaimɨn yaimɨnkɨn, ɨni hindara yokwo tanɨn. Siya yaimɨrsɨm bɨ nowarkɨi boɨnkɨn. Mɨ tɨ prismi bɨikɨ bɨiyan yaowae adɨn siya ɨna swokɨ srɨiyɨn mɨ kɨra tɨ inkamɨn Adi Komii siya nɨmbingiyɨn mɨ siya aniya, iyɨe? Mɨ kɨra tɨ yɨnisɨmɨn Adi Komiiyɨn dimɨn whɨrkɨ kɨmbu karam nwowɨn siir ɨeya, aniya? ");
INSERT INTO iws_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Mɨ Jisɨs siya ɨna boɨnɨn, ɨhɨ, karargɨn. Mɨ kɨma wɨ kariirar kɨgi tɨ Inkam Yaowae Adɨn nɨnomor kouankɨn nɨtɨn, ɨni Adi Komiiyɨn kɨrɨekakɨn siir ɨɨna ɨɨniga saiir nɨdwowɨn. Mɨ kara nɨti, kara wɨ waumɨrsɨsɨm whɨsinanɨm nɨnomor kou hɨranɨm, sɨmakar nɨnkɨn onaiinii. Mɨ kɨma wɨ kariirar kɨgwɨni. ");
INSERT INTO iws_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mɨ prismi bɨikɨ bɨiyan yaowae adɨn siya yɨinakiwomwɨtki siir yɨuɨs bripriya siya niiya saiirɨn. Siya whɨsarii bɨ nɨinɨkiwomwɨtka, siya ɨokakɨn. Mɨ siya ɨna boɨnkiyɨn, krɨma pɨ inkam nhɨram kɨpi swokɨ ɨkɨuna yai whɨnboɨnamɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kɨma bɨdi wakaekiyɨm yai bibiyɨeyɨm siya boɨnkiyɨm Adi Komii siir mɨ kɨma ɨni panɨɨna yaɨngwokiyɨm? Mɨ sɨma hoɨmgakarɨm ɨni yai kwɨruwar kɨrɨtkɨn boɨnkiyɨm, siya siyɨu biyɨe bɨdi tɨrɨn, siya wa dao. ");
INSERT INTO iws_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mɨ kam nhɨrɨm yaeyop siir yaswaiyɨugi mɨ sɨma siir yaimwo whwonkamɨm yɨuɨsni kogrɨnugi mɨ siirɨn ɨna tɨoɨm. Mɨ sɨma boɨn, kɨra profet yai tɨ boɨnki, kɨriirɨn nhɨnga tɨowi, ha? Mɨ kamɨm waikaowiyɨm sɨma yɨkɨunam siirɨn. Mɨ sɨma siirɨn hanɨɨngɨ yɨpɨmpar. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Mɨ ɨiya Pita siya omaka maeyau akpitga nu hɨrar nikɨ okɨn mɨ wig ɨra prismi bɨigɨ bɨiyan yaowae adɨn siir mɨi mɨriiya saeya ɨna yɨta. ");
INSERT INTO iws_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Mɨ ɨiya saeya Pita siir kɨga siya pae hɨr nɨdwo oniyɨn mɨ saeya siir whwonkam ɨiirar inɨ kɨgsɨb boɨnɨu. Ni kɨra ɨriipɨ hɨriinan Jisɨsɨn om Nasaretanɨn saɨka mɨ okɨn. ");
INSERT INTO iws_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mɨ Pita siya ɨni hindara mɨisɨsaekiyɨn. Nɨɨngaka. Kara nɨnoknɨnkɨn tani siirɨn, kara ta yaiya kɨra boɨna saiirɨm warar whaowaei. Mɨ siya ɨna youapnaniyamɨn hira saiir ano kingiin hɨriir. Mɨ ɨuumɨn ɨna yɨkiyakwokɨn. ");
INSERT INTO iws_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mɨ ta wiga mɨi mɨriiya saeya Pita siir swokɨ kɨga mɨ saeya kam nhɨrɨm saiir kingiin hɨr nwowɨm sɨmiir boɨnki, tɨkɨ inkamɨn Jisɨs siir kɨgna mɨrii inkam nwɨr ɨeyaɨrgɨn. ");
INSERT INTO iws_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mɨ Pita siya ɨna swokɨ mɨisɨsaekiyɨn. Nɨɨngaka. Mɨ mhoɨiya kam nhɨrɨm saɨkar nokwowɨm sɨma swokɨ boɨnhɨuriyɨugi siirɨn, kaimwokɨ kaimwowaɨrga kɨra kɨpi nɨksɨsae ni kɨra ɨriipɨ hɨriinan Jisɨs siir mɨi kɨgna mɨriiyan inkam nwɨrkɨn, nu Galili hɨran inkamkɨn. Sɨma hɨnɨɨna boɨnkikɨm. ");
INSERT INTO iws_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Mɨ Pita siya ɨna yɨkopaisɨsɨrkiyɨn, kaimwokɨ kaimwo kɨɨnga! Kara tɨ inkamɨn kɨma boɨnɨn siir bɨ nɨnoknɨnkɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Mɨ bɨri kɨmɨmɨnkikɨn, ɨuumɨn kwɨsaka ɨna yɨkiyɨn. Mɨ Pita siya ɨna swokɨ aɨngwowoknakiyɨn yaiya bɨiya Jisɨs siya boɨna siir. Jisɨs siya hɨnɨɨna boɨnkɨn, ɨuumɨn kwɨsaka nikɨ ɨk karam nwowi mɨ kɨra kariir inɨgɨn wɨ kwoɨma mɨisɨsaei. Mɨ Pita siya nou prasae bɨ kɨnkɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mɨ prismi yaowae adɨm sɨma nugak ɨmumar yamyakwok adiyaowaeyɨm siyɨu komii kɨgrɨraowiyɨm mɨ kamɨm siyɨu komii nɨnoknɨnkɨniyɨm mɨ inkam komiiyɨm yai hɨdi ɨkɨm sɨmiiram, sɨma yai ɨrɨpa hangiriyɨu boɨnai. Mɨ sɨma Jisɨs siirɨn wɨeyɨn sopni yɨmboru kinam Pailat siirɨmɨn. ");
INSERT INTO iws_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Mɨ Pailat siya Jisɨs siir srɨi, kɨra Juda iikamɨm sɨmiir nu ɨiir kɨgrɨraowan inkam komiigɨn, aniya? Mɨ Jisɨs siya ɨna yowarkɨi boɨnkiyɨn, wa yaiya kɨra boɨna ɨni mɨ owa. ");
INSERT INTO iws_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mɨ Pailat siya yaowae adɨm sɨmiir wakaeyɨn sɨma yai whɨekakɨm siirara boɨn hɨuriyɨugi. ");
INSERT INTO iws_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Mɨ Pailat siya Jisɨs siirɨn ɨna swokɨ srɨigiyɨn, kɨra yai wakae boɨn tani, aniya? Wakae! Sɨma yai whɨekakɨm ɨni kɨriirarar boɨn hɨuriyɨuɨm. ");
INSERT INTO iws_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mɨ Jisɨs siya yai kwɨr bɨri swokɨ wakae boɨn srankɨn. Nɨɨngaka. Mɨ Pailat siya asi kɨntɨɨrgikɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bɨewi bɨewiyɨm ɨi komiiya Pasova wou nikwo aeiya mɨ Pailat siir siyɨuɨn hɨriiyar tɨrikɨn, siya maeyauwa mɨi biyɨe mɨriiya kamɨm hɨugrɨpkɨikikaiyɨm sɨmiirɨn pɨ nwɨra nokmwɨn apniki. Iikamɨm sɨmiir kwoɨnkɨn naɨngwowɨn inkamɨn siir. Mɨ Pailat siya sɨmiirɨmɨn pɨ siirar nɨkropki. ");
INSERT INTO iws_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mɨ ta ɨiya inkam nwɨrɨn Barabas nɨkɨuwiyɨn, omaka hɨuyokiyokaiya saiir nwokaiyɨn mɨ kamɨm wra nwowiyɨm inkam komii komiiyɨm omom omom kɨgrɨraowiyɨm ɨo sɨmaka nwowɨm mɨ sɨmiir nhɨr ɨmiir nɨsomsom aokaowɨm siya sɨmakar nwokaigɨn. ");
INSERT INTO iws_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mɨ iikamɨm ha nanɨnkɨnɨuniyɨm mɨ sɨma Pailat siir boɨnki, tɨkɨ siyɨuɨn, bɨiya kɨra tɨrɨn bɨewi nhɨrɨm dɨgiyɨm mɨ kɨra pa nɨkrop apniki ta maeyauwa mɨi biyɨe mɨriiya hɨuyokiyokaiya saiir nwowɨn sɨmiir inkam nwɨrni. Mɨ tariinanɨn kɨra siira tɨ swokɨ tɨr. ");
INSERT INTO iws_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Mɨ Pailat siya sɨmiir yai yaka yowarkɨi boɨnki, kɨma mɨnam naɨngwowi kara Juda sɨmiir inkam komiiyɨn nu kɨgrɨraowiyɨn siir nɨuguskiyɨm, aniya? ");
INSERT INTO iws_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Mɨ Pailat siya hɨnɨɨn asi boɨnkikɨn. Dimusi rani, siya bɨdi yɨnoknɨnkɨnɨn prismi yaowae adɨm sɨmiir kwoɨnɨm. Sɨma Jisɨs saɨka whwokwoka nwo rani, sɨmiir kwoɨnɨn i ɨeyar kwaewaowi bɨi sɨma nwowɨm. Mɨ sɨma siirɨm asi nɨkɨunanikɨm siirɨn. ");
INSERT INTO iws_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mɨ iikamɨm sɨmiir kwoɨnɨm prismi yaowae adɨm sɨma inɨ boɨnɨurwokaiyɨu. Mɨ sɨma pɨ hɨnɨɨn nwokɨ boɨnkiyɨm Pailat siya Barabas siir dɨkrop apniki. ");
INSERT INTO iws_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Mɨ Pailat siya sɨmiirɨn ɨna swokɨ boɨnkiyɨn mɨ kara pɨ panɨɨna tɨri tɨ inkamɨn kɨma boɨniyɨn Judami iikam sɨmiir inkam komiiyɨn nu kɨgrɨraowiyɨn, ha? ");
INSERT INTO iws_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Mɨ sɨma siir yai yamdi ɨna kauwok boɨnkiyɨm, siirɨn paeyɨn hɨiniya nɨrɨonɨnkɨnɨn saɨka dɨnkɨn ɨrɨnugi! ");
INSERT INTO iws_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Mɨ Pailat siya sɨmiir srɨigi, dimusika, ha? Siya dimu dimɨn tɨrbukɨn, ha? Mɨ sɨma ɨna kauwok boɨnamnankiyɨm, siirɨn tɨ paeyɨn hɨiniya nɨrɨonɨnkɨnɨn saɨkar dɨnkɨn ɨrɨnugi! ");
INSERT INTO iws_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Mɨ Pailat siya iikam isidɨn sɨmiirɨm hiirgɨn mɨ siya Barabas siir asi kɨgnɨnkɨn apnikikɨn. Mɨ siya Jisɨs siirɨn kamɨm yaii nɨniiyɨm sɨmiirɨm iyopmauugi, sɨma nɨpɨmparɨm siirɨn. Mɨ mhoɨiya sɨma siirɨn ɨna yɨkropkiyɨn paeyɨn hɨiniya nɨrɨonɨnkɨnɨn saɨka nɨnkɨn ɨrɨnugiyɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Mɨ kamɨm ɨrɨm haiiyɨm sɨma Jisɨs siirɨn inkam komiiyɨn omom omom kɨgrɨraowiyɨn siir omaka maeyauwa hɨriir yɨnkikwona apnam. Mɨ sɨma kam nhɨrɨm yaii nɨniiyɨm sɨmiirɨm yɨkɨuna, sɨma ta maeyau kwɨruwa saiirarar nanɨnkɨnɨuniyɨm ");
INSERT INTO iws_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","mɨ sɨma Jisɨs siirɨn yɨuɨs paridnana kwɨra yɨtomwanɨu haigɨnɨu. Mɨ sɨma urid nɨmrɨdgakɨn whɨra hopwhro mɨ sɨma siir mwo ɨiir kaigrɨsɨugi. ");
INSERT INTO iws_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Mɨ sɨma siir yɨgbumbu, akamɨe! Juda iikamɨm sɨmiir nu kɨgrɨraowi inkam komiigɨn! ");
INSERT INTO iws_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Mɨ sɨma siir mwowɨn paekopɨn hougwokwo apiyɨn siir yɨkrɨmkrae. Mɨ sɨma siirɨn yaeyop haɨni mɨ yaswaiyɨu mɨ sɨma ogmwo ha hɨuɨm mɨ ɨna kaiyɨrou kisɨsanaɨm siir inɨg ɨiir hainanam. ");
INSERT INTO iws_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mɨ sɨma siir mɨngigin dɨgiyɨm mɨ ta yɨuɨs pariidnan bripriya ɨna swokɨ ɨsaiya. Mɨ sɨma siirɨn ɨni siir yɨuɨs aiirar swokɨ ii haigɨnɨugiyɨm. Mɨ sɨma Jisɨs siirɨn ɨna yɨkɨunamɨn paeyɨn hɨiniya nɨrɨonɨnkɨnɨn saɨkar nɨnkɨn ɨrɨnugiyam. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Inkam nwɨrɨn Saimonkɨn siya om Sairini ankɨn Aleksanda Rufas sowiir yaowae adgɨn. Mɨ siya omisɨsɨmɨm om komii siir yaba nwowɨm sɨmiir haiburgigɨm mɨ siya ɨna yapamɨn siyɨu maeyau nɨɨnga aiir. Mɨ sɨma siyɨu bopwo hɨr yɨnapyɨskai om komii siir kingiin. Mɨ sɨma kɨmɨdiniya ɨgao yai siir boɨnwɨn paeyɨn hɨiniya nɨrɨonɨnkɨnɨn Jisɨs siirɨn siya haiyam. ");
INSERT INTO iws_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mɨ sɨma Jisɨs siirɨn maeyau kwɨra saiir hɨriir yɨkɨunam ta maeyauwa saiir inɨga Golgota. Mɨ ta maeyauwa saiir inɨg mwowɨn inkam mwo kɨuni maeyauga. ");
INSERT INTO iws_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mɨ sɨma op wain sɨmiir naba saɨkar yɨnkɨn aepɨbmigiya siir hauuwam mɨnkɨn mɨ siya bɨri kwiyaekɨn. ");
INSERT INTO iws_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Mɨ sɨma paeyɨn hɨiniya nɨrɨonɨnkɨnɨn siirɨn saɨkar yɨnkɨn ɨrɨnugi. Mɨ siir yɨuɨsɨm ɨni sɨma hɨdnonkwokwo hainamɨm. Mɨ sɨma gwo kwɨra sae gwo satu, sɨma mɨnɨm gwokɨm tɨ hɨnɨɨn dimɨnɨn pɨ nhɨnga haii. ");
INSERT INTO iws_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ɨiya nugakar nikɨ oyakwoka 9:00 klok mɨ sɨma paeyɨn hɨiniya nɨrɨonɨnkɨnɨn siirɨn saiirar yɨnkɨn ɨrɨnugiyakwok. ");
INSERT INTO iws_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mɨ siir mwo kouga ta yaiya siir boɨna saiir wɨnki yokwoni. Sɨma hɨnɨɨna wɨn boɨnkikɨm, Juda iikamɨm sɨmiir nu kɨgrɨraowi inkam komiigɨn. ");
INSERT INTO iws_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Mɨ sɨma Jisɨs siir kingiinɨn inkam nwɨso hɨi tauaeiyo sowiirɨn warar yɨnkɨn ɨrɨmdɨnugik paeyɨn hɨiniya nɨrɨonɨnkɨnɨn siir. Mɨ nwɨrɨn ɨɨniga mɨ nwɨrɨn yaɨoyaeya. ");
INSERT INTO iws_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Mɨ Adi Komii siir Yokwo Komii saiir yaiya ɨni kaimwowa ywowa bɨdi bɨdinan sɨma wɨna mɨ tariinanɨn saeya bɨdi yɨmbiniya. Mɨ ta yaiya hɨnɨɨnga, sɨma siirɨn kamɨm hɨi tauaeiyɨm sɨmaka yɨnkɨn hɨuwiyopmasugi. ");
INSERT INTO iws_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mɨ iikamɨm haɨmii tamii napɨm siir yapɨkbumbu mɨ sɨma mwo ɨna yapkɨntɨɨrɨm. Mɨ sɨma siir boɨnki, bɨiya kɨra hɨnɨɨna boɨnkɨn, Adi Komii siir omaka wɨ kara nɨipɨɨrgi mɨ ɨi kwoɨmɨm dɨg nwokii mɨ wa swokɨ haɨninansiin okwoki. ");
INSERT INTO iws_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Mɨ kɨra kɨnakɨna tamɨ dirɨraerarna mɨ kɨra pa nwokɨ ɨuuniyɨm warɨ paeyɨn kɨriir nɨrɨonɨnkɨnɨn siir waraurankɨn! ");
INSERT INTO iws_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mɨ prismi yaowae adɨm mɨ kamɨm siyɨu komii nɨnoknɨnkɨni ɨkɨm, sɨma Jisɨs siirɨn warar yapɨkbumbu. Mɨ sɨma, sɨmasɨmar yomboɨn amboɨn, siya inkam nhɨrɨm sɨmiirɨn bɨdiyar whɨndirɨraerar haigɨnɨuɨn. Mɨ siya, siya siyar dirɨraerar namɨm panopi, ha? ");
INSERT INTO iws_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mɨ tɨ inkamɨn siya nɨmbinkiyɨn siya Israel sɨmiir inkam komiigɨn, sɨmiir nu kɨgrɨraowikɨn. Mɨ siya paeyɨn hɨiniya nɨrɨo nɨnkɨnɨn siir hɨrankɨn krɨmar kɨgwokwoɨuungi. Mɨ krɨma wa nwokɨ aɨngwo tɨbmiikiyɨm kɨriiramɨn. Mɨ inkam nwɨso Jisɨs saɨkar nɨnkɨn ɨrɨmdɨnugiyo paeyɨn hɨiniya nɨrɨonɨnkɨnɨnsi yo sowa ɨriipɨ hɨriinan siirɨn warar mɨ ɨnkɨn ɨgbumbu. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mɨ ɨiya nabɨe bopwo nwowa mɨ ɨiya ɨna kakauugiya. Mɨ hɨnda tɨnda ɨni nɨiyar ywokiyɨm. Mɨ ɨiya bɨe nad nwowamtɨbɨn, ɨiya ɨi kwoɨm nwowiya saiir yadɨg ɨurɨb. ");
INSERT INTO iws_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Mɨ ɨi kwoɨm namwoɨuwiya mɨ Jisɨs siya ɨna kauwok boɨnkirɨbɨn, Eloe, Eloe, lema sabaktani? Ta yaiya saiir yaimwokɨyaimwowa hɨnɨɨnga, kariir Adi Komii, kariir Adi Komii kɨra kariirɨn digɨumii dimusi haimriiyɨugigɨn, ha? ");
INSERT INTO iws_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Mɨ kam nhɨrɨm kingiin hɨr nokwowɨm sɨma siir yai wakaeyɨm mɨ sɨma ɨna boɨnɨm, wakae! Siya Ilaija krɨmiir wanwiyaeyɨn siirɨm nɨkɨuwi. ");
INSERT INTO iws_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mɨ inkam nwɨrɨn ɨna iwɨtnamɨn hamgan hainakiyɨm. Mɨ ta op kausrɨra siir ɨdwo yaokɨnki. Mɨ kɨmɨdiniya paekop ɨnakar yɨnkɨn udgi mɨ Jisɨs siir yaiga yaka onkwo mauugi siya kwiyaeyɨm. Mɨ tɨ inkamɨn siya boɨn, ha tikɨ o. Krɨma nikɨ kɨgrɨraowi siirɨn pɨ Ilaija siya nasi whɨndirɨraerar ɨuungi paeyɨn hɨiniya nɨrɨonɨnkɨnɨn siir hɨrankɨn. ");
INSERT INTO iws_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mɨ Jisɨs siya ha kauwankɨi boɨnkirɨbɨn mɨ siya ɨna iyɨe hɨkainamtɨbɨn. ");
INSERT INTO iws_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ɨiya Jisɨs siya naowa ta yɨuɨs komiiya Adi Komii siir omaka saiir nɨtiyɨsɨuwa saeya ɨni bopwoniyar yɨnwɨtamnaiiniya. Mɨ ɨna yɨugusnaiinama nua hɨriir. Mɨ ta yɨuɨs prɨeiya ɨni kwɨsa ywokiya. ");
INSERT INTO iws_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mɨ kamɨm yaii nɨniiyɨm sɨmiir bɨi nwowi inkamɨn siya Jisɨs siir whwonkam ɨda nokwokɨn mɨ siya kɨgiyɨn siya hɨriinan niyae hɨkainamtɨbɨn mɨ ɨni siya siyar boɨnkiyɨn, kaimwokɨ kaimwokɨɨnga! Tɨriigɨnɨn Adi Komii siirar yɨnisɨmkɨn. ");
INSERT INTO iws_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Mɨ wig nhɨrɨm hɨrar mɨ ɨnkɨn okɨm mɨ sɨma arurɨg hɨrar nokwo kaokikɨm. Mɨ nhɨrɨm sɨmaka hɨr nɨnkɨn okwo kaokɨm. Ɨra Maria om Makdalanka mɨ ɨra Maria Jems sapɨsapɨn mɨ Josis sowiir apu aeya. Mɨ ɨra Solomonika. ");
INSERT INTO iws_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Bɨiya Jisɨs siya nu Galili hɨr nwowɨn mɨ ta ɨiya tɨ wigɨm siir mhoɨiya namkɨm. Mɨ sɨma siir nae dirɨraerarɨm mɨ wig isid komii whɨrɨn yɨm sɨma ɨriipɨ hɨriinan Jisɨs saɨkar yɨnkɨn am om komii Jerusalema hɨriirɨn. Mɨ sɨma hɨr inɨ owou. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Mɨ naɨowaka Josepɨn om Arimatianɨn ɨna yɨtrɨbɨn. Siya yai hɨdan inkam wadɨekɨn. Mɨ yɨo siya ɨriipɨ hɨriinan ɨiya Adi Komii siya iikam sɨmiir kɨgrɨraowana ɨiya saiirɨmar mɨ owɨni. ");
INSERT INTO iws_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Mɨ Juda sɨmiir ɨi komiiya waka nwokwowaki mɨ tapa ya nae dirɨraerar haigigik ni ɨiga mɨ Josep siya asi napnɨnopkainamkɨn Pailat siir kɨgam. Siya bɨri nɨdid namkɨn. Nɨɨngaka. Siya Jisɨs siir pɨuɨs biyɨeya saiir hainakiyɨm srɨiyɨugɨn. ");
INSERT INTO iws_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Mɨ Pailat siya ɨni hindara yanaawɨnɨn ta yaiya saiir wakaewɨnɨn, Jisɨs siya naonama. Mɨ siya kamɨm yaii nɨniiyɨm sɨmiir bɨiyan inkamɨn siirɨm yɨkɨuna mɨ siya siir srɨii, Jisɨs siya bɨdinanar naonamkɨn, iyɨe? Tariinanar kwaokɨn. ");
INSERT INTO iws_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mɨ ɨiya siya yaii nɨnii kamɨm sɨmiir bɨi nwowiyɨn siir yai aiir wakaeyɨn mɨ siya Josep siir boɨnki siya Jisɨs siir pɨuɨs biyɨeya saiirɨn hatɨ hainam. ");
INSERT INTO iws_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Mɨ Josep siya yɨuɨs whɨsinana kwɨra saɨnam. Mɨ siya Jisɨs siir pɨuɨs biyɨeya ɨna inɨ hɨunɨs hainakiya paeyɨn hɨiniya nɨrɨonɨnkɨnɨn siir hɨrankɨn. Mɨ siya siirɨn yɨuɨs whɨsinana saiir whrɨnainam mɨ siirɨn siya siyano whɨrɨn siir inɨ haigigik. Mɨ tɨ siyanowɨn inkamkar nopkikɨnkɨn. Mɨ siya siiya komiiya kwɨra warnani ɨe ɨiir warkɨn tɨnugigam. ");
INSERT INTO iws_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria om Makdalana mɨ Maria Josisni yopi aka, sowa kogwokwo haigikigo maeyauwa Jisɨs siir pɨuɨs biyɨeya saiir haigigiya. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mɨ Juda sɨmiir ɨi komiiya dɨg nwokiya mɨ Maria om Makdalana mɨ Maria Jemsni yopii aka mɨ Salomi saeya sɨma waɨm pɨuii mɨiyɨk whakiyɨm sɨmiir saɨnam. Sɨma Jisɨs siir pɨu aiir naokɨnam saɨnamkɨm. ");
INSERT INTO iws_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Mɨ ɨigwɨra sɨma bɨeyɨn bɨdi maskwokiyakwokɨn mɨ saiirar yamyakwok Sandeya, siyanowɨn inkam haigigigiyɨn siirɨm. ");
INSERT INTO iws_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Mɨ sɨmasɨmar yapboɨnaiyam, krɨmiirɨn pɨ nhɨnga whɨn mɨrii ta siiya komiiya saiir warɨtkɨnkiyɨm, ha? ");
INSERT INTO iws_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mɨ ɨiya sɨma siyanowɨn siir ninɨ kɨgɨuwɨm mɨ sɨmar kɨgi siiya komiiya hɨr nwo rani. Nɨɨngaka. Bɨdi inabaki ɨtkɨnkiya ɨemɨga. Taka siiya, siiya prasae rani. ");
INSERT INTO iws_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Mɨ sɨma siyano ɨiir napnɨnopkainamɨn mɨ sɨma kɨgam whranisɨm nwɨrɨn sɨmiir ɨɨna ɨɨnig mɨiya nɨdwokai. Siya yɨuɨs whɨsinan bripriya kwɨra nii ɨdwokai. Mɨ sɨma siir ninɨ kɨgɨuɨm mɨ ɨni hindara inɨ anaaɨuwɨuwɨm. ");
INSERT INTO iws_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mɨ siya sɨmiir boɨnkaiwɨn, kɨma kɨpi kɨgnanae kara bɨdi yɨnoknɨnkɨnɨn, wɨm kɨma Jisɨsɨn om Nasaretanɨn siirɨm hansɨri paeyɨn hɨiiniya nɨrɨonɨnkɨnɨn sɨma nɨnkɨn ɨrɨnugiyɨn siirɨn. Mɨ siya tapaiir nwo rani, bɨdi yɨnsiin ɨdwonamɨn! Mɨ ɨni omwaiyar swokɨ waiyan! Kɨma ta maeyauwa sɨma haigigiga saiir tɨ kwakɨg siya hɨr nwokaii. ");
INSERT INTO iws_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kɨma dam! Mɨ kɨma pɨ kamɨm siir mɨi kɨgna mɨriiyɨm pɨ sɨmiir tinɨ boɨnɨu mɨ Pita siirɨn warar. Mɨ kɨma pɨ hɨnɨɨna tinɨ boɨnɨu, Jisɨs siya kɨmiir bɨiya bɨdi yamkwokɨnɨn nu Galilia hɨriir. Mɨ kɨma siirɨn wɨ hɨr ninɨ kɨgɨuwi. Bɨiya kɨmaka siya nikɨ boɨna saiir hɨriinan! ");
INSERT INTO iws_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Mɨ tɨ wig oumɨm ɨna yɨdamniyamɨm idowɨiya hɨriir, tɨ siyano ɨiirsi. Mɨ sɨma ɨna yɨdam ɨugusamɨm, kɨugak bɨ nwonamkɨm sɨmiir kɨuɨm ɨni hindara yɨinɨrkɨinamɨm. Mɨ sɨma inkam nwɨraka yai panɨɨnsi yɨmboboɨnamsi. Nɨɨngaka. Sɨma pɨ nɨdidnamkɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jisɨs siya Sande nugak ɨmumar yɨnsiin ɨdwonamyakwok. Mɨ siya bɨigɨ bɨiyɨn Maria om Makdalana saiir hɨriir yɨmbiyam. Mɨ ta wiga, bɨiya Jisɨs siya nɨnɨskɨigiya yɨu biyɨe ɨriiyar nwɨso sɨma nwokaiya saiir mɨ saeyaɨrga. ");
INSERT INTO iws_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maria saeya inɨ kɨgɨu tɨ siir nomiiyauɨm naɨngwoyɨmiyok ou prasae bɨri kɨnkɨm siirsiyɨn. Maria saeya bɨiyɨn siir nomiiyauɨm bɨiya saɨka nwokaiyɨuɨm sɨmiir inɨ boɨnmauuɨu. ");
INSERT INTO iws_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mɨ Maria saeya sɨmiir boɨnki Jisɨsɨn ɨni omwaiyar swokɨ waiyan kara siir bɨdi kɨgnaniyɨn. Mɨ sɨma ta yaiya saiir wakaeyɨm mɨ sɨma bɨri naɨngwo tɨbmiigɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mɨ ta saiir mhoɨiya inkam nwɨso siir kɨgna mɨriiywo sowa om komii hɨr haiburgigo mɨ ha napamwo mɨ sowa siirɨn siyɨu hɨr yapiyɨskai. Mɨ Jisɨs siya sowiir hɨriirɨn yaeya pɨu kwɨr yam. ");
INSERT INTO iws_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Mɨ sowa ha swokɨ amwo mɨ kɨmɨdiniya kam nhɨrɨm sɨmiir inɨ boɨnmauuɨu. Mɨ yɨm sɨma sowiir yai aiirɨm bɨ swokɨ aɨngwo tɨbmiigɨm. Nɨɨngaka. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mɨ kam ɨuur nwɨrɨm siir mɨi kɨgna mɨriiyɨm ɨiya sɨma naeyar nikɨ ɨdwo aeyɨm mɨ Jisɨs siya ɨna yɨmbiyamɨn sɨmiir hɨriir. Mɨ siya sɨmiir inɨ ɨkɨu whɨsarii rani, sɨma bɨ naɨngwo tɨbmiigɨm. Mɨ kam nhɨrɨm sɨma pɨ nantamyɨriyɨrkɨm kam nhɨrɨm sɨma naboɨniyɨm Jisɨs siya bɨdi yɨnsiin ɨdwowɨn ɨeyankɨn mɨ siya ɨni omwaiyar swokɨ waiyan. ");
INSERT INTO iws_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Mɨ siya sɨmiir boɨnki, kɨma ɨkɨ omom omomɨm hɨnda tɨnda nwowɨm sɨmiir dam mɨ Yai Wɨn Kɨbiya saiir dapboɨnmamauuam iikamɨm sɨmiir. ");
INSERT INTO iws_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mɨ inkamɨn naɨngwo tɨbmii mɨ siya ha baptais mɨ siirɨn wɨ Adi komii siyar kaoprigiokwowi. Mɨ yɨpɨkɨ inkamkɨn naɨngwo tɨbmii karam nwowi, yɨm wɨ siya grirɨtkaigi. ");
INSERT INTO iws_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Mɨ iikam whɨekakɨm naɨngwo tɨbmiiyɨm sɨmiirɨn kɨrɨe wɨ Adi Komii siya hauuwi dimɨn komii komiiyɨm sɨmiir dirɨraeraram. Mɨ sɨma wɨ kariir inɨg ɨiirar nɨnɨmnɨskiiyami uridyɨu bibiyɨeyɨm sɨmiirɨn. Mɨ sɨma wɨ yaeya yaigɨn kwɨra boɨni. ");
INSERT INTO iws_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Mɨ sɨmiir ɨɨnam mɨpugɨn biyɨu dapiyɨn siir nonkwowi mɨ op biyɨeya kwiyae aokaowiya saiir kwiyae mɨ tɨ hɨriinan dimɨnɨm wɨ sɨmiirsi nao rani, sɨma. Mɨ sɨmiir ɨɨnam makak inkamɨm sɨmiir mɨ hainii mɨ sɨma wɨ wadɨeyar mɨ oki. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Mɨ mhoɨiya krɨmiir Bɨiyan Inkam Komiiyɨn Jisɨs siya siir yaiyɨm sɨmiirɨn dɨg nwogigɨm mɨ Adi Komii krɨmiir Wanɨn siya ɨna yɨkɨunamɨn siirɨn nɨnomor koua hɨriir. Mɨ tariinanɨn siya ɨni siir ɨɨna ɨɨnigmɨiya inɨ ɨdwoɨuɨn. ");
INSERT INTO iws_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Mɨ kamɨm siir kɨgna mɨriiyɨm, sɨma ɨna yamɨm hɨnda tɨnda. Bɨiyan Inkam Komiiyɨn siya ɨni sɨmakar yɨnkɨn mɨriiyamɨn. Mɨ siya sɨmiir yai ɨmiirɨn warar mɨ whɨnkɨnsiis haigɨnɨuwam dimɨn komii komiiyɨm sɨma tɨr ɨmiirɨn. Mɨ tɨ dimɨnɨn iikamɨm sɨmiir nɨisiimauugɨn. Mɨ ta sɨmiir yaiya kaimwokɨkaimwowaɨrga, Adi Komii krɨmiir Wanɨn siir yaiga. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Bɨiya iikam whɨekakɨm sɨma sɨmiir yapa yapa kwoɨn ɨmiirar wɨnkɨnankɨugɨugikɨm inkam komii Tiofilas siiramɨn, dimɨn taemɨnɨm krɨmiir tɨriir nɨmbiniyɨm. ");
INSERT INTO iws_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Yɨm sɨma dimɨn taemɨnɨm yɨpɨkɨ aposel kamɨm sɨma kɨgɨm mɨ iikam nhɨrkɨm, sɨma mɨ boɨnmɨmauuɨm sɨmiir mɨ wakaeyokna apikɨm. Mɨ tɨ niiiwiiyɨm. Yɨm tariinanɨn ɨni krɨmar nonkwowɨm. ");
INSERT INTO iws_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kara Lukgɨn, niiwii whɨekakɨm bɨiyanɨm mɨ tariinanan ɨkɨm sɨmiirɨn kara bɨdi sɨbgu hɨdgiyɨm. Mɨ kara tɨ niiwiiyɨm bɨigɨ bɨiyanɨm mɨ tariinanan ɨkɨm, sɨmiirɨn kara kɨriiram bɨdi wɨnkiyɨn inkam komii Tiofilas kɨriiram. ");
INSERT INTO iws_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Mɨ kɨra wɨ hɨnɨɨna nɨnoknɨnkɨnɨm, ta yaiya sɨma nowomwarkaiyɨuwa kɨriir, saeya kaimwo kɨɨnga. ");
INSERT INTO iws_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mɨ ɨiya Herot siya nu kɨgrɨraowan inkam komii nwowɨn, nu Judia hɨrɨn pris inkamɨn nwɨra nwokɨn, siir inɨgɨn Sekaraiakɨn. Siya Abaisani pris isidɨn siirgɨn. Mɨ siir wiga, ya Eroni isidɨn siirga, saiir inɨgɨn Ilisabetka. ");
INSERT INTO iws_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Mɨ sowawaiyɨn Adi Komii siir whwonkam ɨdan dimɨn whɨrkɨ bɨ kɨmbugo ɨni wadɨekɨ wadɨeyar ywowo. Mɨ sowa Bɨiyan Inkam Komiiyɨn siir siyɨupai siyɨupai whɨekakɨm sɨmiirar napiko. Mɨ siir yaiyɨm sɨmiirɨn ha mɨ wakaeyoknaeikɨm. ");
INSERT INTO iws_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mɨ sowawaiyɨn yɨɨnɨe bɨ niyɨo mɨmɨnko. Dimusi rani, Ilisabet saeya wig pɨoa nɨɨngaka. Mɨ sowawaiyɨn wai bɨdi ywowo. ");
INSERT INTO iws_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ya Sekaraia siir isidɨn siya mɨriiya ɨiya saeya. Mɨ Sekaraia siya pris inkamɨn krɨmiir kaoprigi okwowiyɨn siir mɨiya Adi Komii siir whwonkam ɨda mɨriigɨn. ");
INSERT INTO iws_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Mɨ siirɨn sɨma yɨmbingi maeyauwa hɨuyokiyokaiya dimɨn whɨrkɨ kɨmbu karamae nwowa Bɨiyan Inkam Komii siira dimɨn taemɨn mɨn nɨnkɨn ɨmiiyaeiya siirɨn hɨriir yokmwɨn apnɨnopkaigi. ");
INSERT INTO iws_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mɨ ta ɨi aiirɨn iikam isid komiiyɨn sɨma idowɨiya hɨrar ywo. Mɨ yɨo siya dimɨn taemɨn ɨmiirar nikɨ ɨnkɨn ɨmiiyaeiyɨn mɨ yɨm sɨma ɨni idowɨiya hɨrar kwɨsboɨnɨm. ");
INSERT INTO iws_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mɨ Bɨiyan Inkam Komii siir paekwosɨmɨn ɨna yɨmbiyamɨn siir hɨriir. Mɨ ɨni hɨiya dimɨn taemɨn haigɨn nɨnkɨn ɨmiiyaeiya ɨni saiir kingiin hɨrar yamɨkwoniyɨn. ");
INSERT INTO iws_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Mɨ ɨiya siya Bɨiyan Inkam Komii siir paekwosɨmɨn siir kɨgiiyɨn mɨ siya ɨni hindara yanaakiyɨn mɨ siya ɨni nɨdidkakar ywowɨn. ");
INSERT INTO iws_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mɨ Adi Komii siir paekwosɨmɨn, siya siir boɨnki, Sekaraia, kɨra kɨpi nɨdid. Adi Komii krɨmiir Wanɨn siiram kɨra kwɨs boɨna, siya bɨdi wakaewɨnɨn. Mɨ kɨriir wiga Ilisabet saeya yɨnisɨm yɨnkamiyɨnɨn wɨ nwɨra naokainaei. Mɨ siir inɨgɨn wɨ Jon dokdap haigɨnɨu. ");
INSERT INTO iws_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mɨ kɨra wɨ maɨrgɨmaɨrga taokɨtaoka siirɨm nwowi. Mɨ iikam whɨekakɨm ɨriipɨ hɨriinan, wɨ maɨrgɨmaɨrga taokɨtaoka siiramar mɨ owi. ");
INSERT INTO iws_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mɨ siya Adi Komii siir whwonkam ɨdan wɨ inɨg komiigak nwowi. Mɨ siya wɨ op wain mɨ ɨkɨ op bibiyɨe nhɨrɨm, kwiyae whaowaeiyɨm, wɨ sɨmiir wara kwiyae rani. Mɨ ɨiya siir naokainaei, Adi Komii siir naeyɨuɨn wɨ siirar nanɨnkɨnɨuɨuwi. ");
INSERT INTO iws_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mɨ Isrel sɨmiir iikam nhɨrɨm, wɨ siya nɨkɨunami Bɨiyan Inkam Komiiyɨn, sɨmiir Adi Komii krɨmiir Wanɨn siirɨm. ");
INSERT INTO iws_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Mɨ siya Adi Komii siir naeyɨuwɨn mɨ siir kɨrɨeya bɨiya Ilaijani nwowa wɨ saiir hɨriinankak nwowi. Mɨ siya wɨ Bɨiyan Inkam Komii siir bɨiya namkwokɨni. Mɨ adɨm sɨmiir kwoɨnɨm wɨ siya kisɨna haigii mɨ sɨma wɨ sɨmiir yɨn ɨmiiram nwokɨ aɨngwowɨm. Mɨ iikamɨm nantamyɨriyɨrɨm, sɨmiir kwoɨnɨm wɨ siya kisɨna haigii. Mɨ sɨma wɨ iikamɨm dimɨn whɨrkɨ kɨmbu karamae nwowɨm, nɨnoknɨnkɨn komiigakɨm wɨ sɨmiir kwoɨn hɨriinan kɨnar nwowi. Mɨ iikamɨm sɨmiir kwoɨnɨm wɨ siya kisɨsop haigiwɨni Bɨiyan Inkam Komii siiram. Adi Komii siir paekwosɨmɨn hɨnɨɨna boɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Mɨ Sekaraia siya paekwosɨmɨn siir yai aka hɨnɨɨna yowarkɨi boɨn mɨ ta yaiya saeya kaimwokɨ nɨuwi mɨ kara wɨ panɨɨna nɨnoknɨnkɨni, kara waibiyɨe bɨdi ywowɨn mɨ kariir wiga ya ɨriipɨ hɨriinan waibiyɨe bɨdi mɨ owa. Siya hɨnɨɨna boɨnkikɨn. ");
INSERT INTO iws_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mɨ Adi Komii krɨmiir Wanɨn siir paekwosɨmɨn siir yai aka hɨnɨɨna yowarkɨi boɨn, kara Gebrielkɨn, kara Adi Komii siir whwonkam ɨda nokwowikɨn. Kariirɨn siya nɨkropkikɨn kɨriir nauunɨ boɨnmauuniyam. Kara ta yaiwɨn kɨbiya kɨriir boɨnmauuniyam hainanikɨn. ");
INSERT INTO iws_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kɨra wakae! Dimusi rani, kɨra kariir yai aiir naɨngwo tɨbmii rani. Mɨ panao kɨriir yaiya pɨ kara tɨrbugii mɨ kɨra pɨ waeyaimɨkrɨm nwowi. Mɨ wɨ ɨiya tɨ digworaekwo whɨekakɨm sɨma nɨmbiniyana wɨ saiirar nadɨgɨuwi mɨ ta kariir yaiya wɨ kaimwowa nwowi. Adi Komii siir paekwosɨmɨn hɨnɨɨna boɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mɨ iikamɨm Sekaraia siiram nwowɨm sɨma ɨna yɨnaɨngwoyɨmiyok boɨnɨm, siya dimu dimɨn mɨnkɨmɨmɨni, maeyaua hɨuyokiyokaiya dimɨn whɨrkɨ kɨmbu karamae nwowa saiir hɨrɨn? ");
INSERT INTO iws_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mɨ ɨiya siya idowɨiya ha napnaniniyɨn mɨ siya yai sɨmaka bɨ nani boɨnikɨn. Mɨ sɨma ɨna yɨnoknɨnkɨnkiyɨm mɨ tari siya yaeya dimɨn wɨn bɨdi kɨgnaniyɨn maeyaua dimɨn whɨrkɨ kɨmbu karamae nwowa saiir hɨrɨn. Mɨ siya sɨmiirɨn ɨni ɨɨnarar yanɨ kɨnmɨmauuɨuɨn mɨ siya ɨni waeyaimɨkrɨmar ywokrɨpkaiyɨn. ");
INSERT INTO iws_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Mɨ siir mɨini ɨiyɨm dɨg nwokiyɨm mɨ siya ɨna swokɨ amɨn siir omaka hɨriir. ");
INSERT INTO iws_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mɨ taka ɨi aiirarɨn siir wiga Ilisabet saeya ɨni yɨnpɨugakar ywokiya. Mɨ idowɨiya naprɨrɨr karamae saeya nwowɨm bwanɨm ɨriiyar. Saeya hɨnɨɨna boɨnka, ");
INSERT INTO iws_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","mɨ Bɨiyan Inkam Komiiyɨn siya kariirsi naɨngwobumbugɨn mɨ siya kara nɨdidnanaekaigiya iikam whɨekakɨm sɨmiir whwonkam ɨda, siya bɨdi yɨtkiigiya. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mɨ bwan ɨriiyar whɨr aka, paekwosɨm Gebriel siirɨn Adi Komii siya yɨkropki nu Galili hɨran omisɨm whɨrɨn Nasaret siirɨm. ");
INSERT INTO iws_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Mɨ kopaksɨm ɨra, saiir yopiigar whausoknɨnkɨn prapraskiya, saeya hɨi mɨn bɨ nanaeka, sɨma saiirɨn whran nwɨrɨn siiram boɨrɨtmaiga siya nonkwonaɨm siir inɨgɨn Josepkɨn, siya Devidni isidɨn siir hɨrankɨn. Mɨ ta kopaka saiir inɨgɨn Mariaka. ");
INSERT INTO iws_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mɨ paekwosɨmɨn saiiram ha namɨn mɨ siya saiir inɨ boɨnɨu, Akam, Adi Komii siya kɨriirsi naɨngwobumbugɨn. Mɨ siya ɨni kɨnakar nwowɨn. ");
INSERT INTO iws_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mɨ Maria saeya ta yai aiir wakaeya saeya ɨni hindara yanaakiya. Taka yaiya saeya panɨɨn, panɨɨn yaiga. ");
INSERT INTO iws_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mɨ paekwosɨm siya saiir boɨnki, Maria, kɨra kɨpi nɨdid. Adi Komii siya kɨriirsi naɨngwobumbugɨn. ");
INSERT INTO iws_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Wakae! Kɨra wɨ yɨnpɨugak kɨpi nwowi. Mɨ kɨra yɨnisɨm yɨnkamiyɨnɨn wɨ nwɨra naokainaei mɨ kɨra siir inɨgɨn wɨ Jisɨs nokdap haigɨnɨu. ");
INSERT INTO iws_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mɨ siya wɨ inɨg komiigak nwowi. Mɨ siirɨn wɨ hɨnɨɨna boɨni, Adi Komii nɨnomor kouanɨn siir yɨnisɨmkɨn. Mɨ Bɨiyan Inkam Komii Adi Komii siirɨn wɨ siir brougaeyɨn Devid nu kɨgrɨraowiyɨn wɨ siir hɨriinan nokmwɨn okwo haigɨnɨuwi. ");
INSERT INTO iws_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Mɨ siya ɨinokɨinokɨn wɨ Judami inkam komii nwowi. Mɨiya inkam komii nu kɨgrɨraowiyɨn wɨ siir hɨriiyar nwoyokiyokɨikaeyami. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mɨ Maria saeya paekwosɨm siir yai aka hɨnɨɨna yowarkɨi boɨn, tɨriigɨnɨn wɨ panɨɨna nɨmbiyami? Kara kamkak rani. Kara inkam nwɨr aka bɨ nwoka mɨ kara wɨ yɨnkak ha nwo rani. ");
INSERT INTO iws_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mɨ paekwosɨm siya saiir yai aka hɨnɨɨna yowarkɨi boɨn, Adi Komii krɨmiir Wanɨn siir naeyɨuɨn wɨ kɨriir nanɨnkɨnɨuni mɨ siir kɨrɨeya kɨriirɨn wɨ saeya kɨnsiis haigɨnɨuwi. Mɨ mhoɨiya kɨra wɨ tɨ yɨnisɨmɨn siir naokainaei. Mɨ sɨma wɨ ha boɨni siirɨn dimɨn whɨrkɨ bɨ kɨmbugɨn. Siya Adi Komii siir yɨnisɨmkɨn. ");
INSERT INTO iws_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Wakae! Bɨiya kɨriir yopiiya Ilisabet saeya wai bɨdiyar ywowa mɨ saeya ɨni yɨnkakar swokɨ owa. Saeya bwanɨm ɨriiyar whɨra ywo Bɨiya sɨma ha boɨnkɨm saeya wɨ yɨnpɨugak nwo rani. ");
INSERT INTO iws_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Dimɨn whɨrkɨn Adi Komii siya tɨr karamae bɨ nwokɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mɨ Maria saeya siir yai aka hɨnɨɨna yowarkɨi boɨn, wakae! Kara Bɨiyan Inkam Komiiyɨn siir mɨiyan wiga. Wa kɨra boɨna siya kariirɨn wɨ hɨriiyar mɨ tɨri. Mɨ paekwosɨmɨn siya saiir haiburgigɨn mɨ siya ɨna yamɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mɨ ɨi nhɨrɨm bɨdi yamkiyɨm mɨ Maria saeya bɨ kɨmɨmɨnka, ɨna nhɨɨnama, mhɨu nhɨrɨm om whɨrɨn nu Judia hɨr nwowɨm sɨmiir hɨriir. ");
INSERT INTO iws_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mɨ saeya Sekaraia siir omaka aiir napnɨnopkainama mɨ saeya kɨmɨdiniya Ilisabet saiir inɨ boɨnɨu, akam. ");
INSERT INTO iws_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mɨ ɨiya Ilisabet saeya ta akam Maria saeya boɨna saiir wakaeya mɨ tɨ yɨnisɨmɨn ɨna kaknɨnaokaigiyɨn. Mɨ Adi Komii siir paekwosɨmɨn ɨni saiirar yanɨnkɨnɨuɨuwɨm. ");
INSERT INTO iws_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Mɨ saeya ha kauiyɨkiya mɨ ɨna boɨnkiya, kɨra ɨni kɨna wigar ywowa. Mɨ ɨkɨ wig nhɨrɨm sɨmiir kouwɨn ɨna kɨrar ywowa. Mɨ warɨ yɨnisɨmɨn kɨriir mhɨinau nwokaiyɨn, yɨo ɨni sakɨsar mɨ owɨn. ");
INSERT INTO iws_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kara panɨɨn wiga, tɨ Bɨiyan Inkam Komiiyɨn siir apua ta kariiram nɨta? ");
INSERT INTO iws_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Wakae! Kariir wɨɨna, kɨriir yai aiir wakaekiya, akam, kɨra boɨnkiya mɨ tɨ yɨnisɨmɨn kariir mhɨinau nwokaiyɨn ɨna kaknanaokaigiyɨn mɨ siya ɨni maɨrgɨmaɨrgar ywokiyɨn. ");
INSERT INTO iws_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kɨra Adi Komii siiram naɨngwo tɨbmii wiga kɨra maɨrgɨmaɨrga ha dwo. Mhoɨiya kɨriirɨn wɨ Bɨiyan Inkam Komiiyɨn siya boɨna wɨ saiir hɨriinan tɨri. Ilisabet saeya hɨnɨɨna boɨnka. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria saeya mwai waowa saeya hɨnɨɨna boɨnka, Kariir mhɨi kwoɨnɨm ɨni Bɨiyan Inkam Komiiyɨn siiramar naɨngwo ɨrkakɨm. ");
INSERT INTO iws_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Kara Adi Komii siiram maɨrgɨmaɨrgaei, kariir nanmaiwarkainaɨn inkamkɨn. ");
INSERT INTO iws_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kara mɨiyan wig nɨɨngaka. Mɨ siya ɨni kariirsiyar swokɨ aɨngwo bunan. Mɨ Tariinanɨn mɨ mhoɨiya ɨriipɨ hɨriinan, iikamɨm sɨma kariirɨn wɨ hɨnɨɨna boɨni, kara wig bɨmbɨuwi rani. ");
INSERT INTO iws_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Dimusi rani, Adi Komiiyɨn kɨrɨekɨ kɨrɨekakɨn, siya kariirɨn dimɨn komiigɨ komii ɨiirar tɨrkɨn. Mɨ siir inɨgɨn dimɨn whɨrkɨ bɨ kɨmbugɨn. ");
INSERT INTO iws_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yaɨoyae yaɨoyaeyɨm hɨrii hɨriinan kɨnaɨrgɨm. Sɨma pɨ inan ii okwoki mɨ Adi Komii siya iikamɨm siirsi naɨngwo ɨdidɨm wɨ sɨmiisi naɨngwobumbuwi. ");
INSERT INTO iws_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Adi Komii siir ɨɨna mɨi kɨrɨe kɨrɨeyɨm saeyar nonkwo mɨriigɨm. Mɨ iikamɨm sɨmamar naɨngwonaeiyɨm, sɨmiirɨn siya bɨdi nhɨnɨkrɨropkiyɨm hɨnda tɨnda. ");
INSERT INTO iws_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mɨ inkam komii komiiyɨm nu kɨgrɨraowiyɨm, sɨmiir mɨiyɨm wɨ Adi Komii siya nɨkrɨpkii mɨ iikamɨm inɨg karamaeyɨm, sɨmiirɨn wɨ siya hainanpraprasi ");
INSERT INTO iws_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Siya dimɨn mɨiyɨk mɨiyɨkɨm wɨ iikamɨm mhɨigɨ naowɨm wɨ sɨmiir hauuwi. Mɨ iikamɨm ɨkɨ digworaekwokɨ naokɨngugunɨnkɨnɨm sɨmiirɨn wɨ pɨu nɨɨnga nɨɨnga siya nhɨnɨkrɨropkii. ");
INSERT INTO iws_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Mɨ siya ɨni naɨngwobumbuwa bɨiya siya nɨmbina ɨni saiirar swokɨ aɨngwowoknakiyɨn. Mɨ siya Isrel sɨmiir iikamɨm sɨmiir whɨnkɨnsiis haigɨnɨugɨn. ");
INSERT INTO iws_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Siya krɨmiir brougaeyɨn Ebraham saɨka bɨdi yɨmbinɨn mɨ siya siir yɨnɨeyɨm mhoɨiya nɨti, sɨmiirsi naɨngwobumbuwi. Maria saeya hɨnɨɨna waoboboɨnka. ");
INSERT INTO iws_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria saeya Ilisabet saɨkan bwanɨm whwoɨma ywo. Mɨ saeya ɨna swokɨ ama saiir oma hɨriir. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ilisabet saeya naokainani ɨiya yɨnisɨm ɨiir, ɨna yɨmbiyama. Mɨ saeya yɨnisɨm yɨnkamiyɨn ɨiir yaokaina. ");
INSERT INTO iws_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mɨ saiir inkamnanɨm, saiir omaka kingiin nwowɨm, sɨmiir hɨranɨm mɨ saiir nomiiyau ɨkɨm, sɨma ta yai aiir wakaeyɨm Bɨiyan Inkam Komii siya Ilisabet saiirsi naɨngwobumbuwɨn mɨ sɨma ɨni maɨrgɨmaɨrga wara mɨ ɨnkɨn owɨm saɨkan. ");
INSERT INTO iws_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mɨ ɨi ɨriiyar kwoɨmaka sɨma yɨnisɨmɨn siir mɨo ɨsa ɨna kɨtiyopnɨr haiyɨm. Mɨ sɨma mɨnam namkɨm siir adɨn Sekaraia siir inɨg ɨiirar swokɨ okdap haigɨnɨuwɨm. ");
INSERT INTO iws_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mɨ siir apua saeya boɨn. Nɨɨngaka! Siir inɨgɨn Jon dokdap haigɨnɨu. ");
INSERT INTO iws_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mɨ sɨma saiir boɨn, krɨmiir brougae wanwiyaeyɨm bɨiya tɨ hɨriinan inɨg ɨiir bɨ nokdapkɨm. ");
INSERT INTO iws_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Mɨ sɨma siir adɨn siiram kɨnmɨmauu srɨi, krɨma yɨnisɨm siir inɨgɨn wɨ panɨɨna dapi? ");
INSERT INTO iws_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Mɨ mhoɨiya Sekaraia siya sɨmiir boɨnki, yokwo siir hauugiyɨm pɨ wɨnmauugiyɨm. Mɨ siya hɨnɨɨna wɨnmauugi, siir inɨgɨn Jonkɨn. Mɨ sɨma ɨni hindarar yanaakiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Mɨ bɨ kɨmɨmɨnkikɨn, Sekaraia siya yai ɨna swokɨ kaonɨs boɨnkiyɨn. Mɨ siya ɨni Adi Komii siir inɨg ɨiirar hainanprapraskiyɨn. ");
INSERT INTO iws_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Mɨ sɨmiir inkam inkamnanɨm sɨmiir omaka kingiin nwowɨm sɨma nɨdid prasae bɨ kɨnkɨm. Mɨ ta yaiya ɨni mhɨuɨm nu Judia hɨranɨm ɨni sɨmiirar yɨniyokɨigiya. ");
INSERT INTO iws_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Mɨ iikamɨm ta yai aiir wakaeyɨm, sɨma ɨni sɨma sɨmar yɨnaɨngwoyɨmyok boɨnɨm. Tɨ yɨnisɨmɨn siya wɨ panɨɨn panɨɨna nwowi. Sɨma ɨna yɨnoknɨnkɨnkiyɨm, Bɨiyan Inkam Komiiyɨn siir kɨrɨeya ɨni saɨka nwowa. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jon siir adɨn, Sekaraian Adi Komii siir paekwosɨmkɨn bɨdi yɨnkɨnɨukikaiyɨn. Mɨ siya dimɨnɨn mhoɨiya nɨmbiyamanɨm sɨmiirɨn ɨna kauwok boɨnkiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Krɨma Bɨiyan Inkam Komiiyɨn, krɨmiir Adi Komiiyɨn siir inɨg ɨiir hainanprapraskii. Mɨ siya siir iikamɨm, Isrel hɨranɨm sɨmiir whɨnkɨnsiisɨm nɨtkɨn. Mɨ sɨma ɨni rɨrmiiya ywokiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Siya ninansiin okwokikɨn nanmaiwarkainan inkam komiiyɨn, krɨmiir nanmaiwarkainam Devidni isidɨn siir inkam nwɨrɨn siir. Siir mɨiyan inkam nwowam. ");
INSERT INTO iws_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Siya siir profet inkamɨn dimɨn whɨrkɨ kɨmbu karame nwowɨn siirɨn bɨdi bɨdiniyarɨn hɨnɨɨna boɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Siya krɨmiirɨn, krɨmiir sau omomɨn sɨmiir hɨrankɨ nanmaiwarkainaei. Mɨ siya krɨmiirɨn wɨ kamɨm krɨmaka nomboɨn ii ae karam nwowɨm, wɨ sɨmiir ɨɨn kɨrɨeya saiir hɨrankar nɨspɨmspaki hainakii. ");
INSERT INTO iws_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Siya nɨmbina krɨmiir brougae wanwiyaeyɨm sɨmaka mɨ saeya. Mɨ siya ta naɨngwobumbuwa krɨmiir nɨisiimauuga. Ta nɨmbin kɨbiya siya haiyaprapraskiya, siya saiir swokɨ aɨngwowoknakikɨn. ");
INSERT INTO iws_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ta siir nɨmbin kɨbiya krɨmiir brougaeyɨn Ebraham saɨkar nɨmbinkɨn. ");
INSERT INTO iws_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Mɨ siya krɨmiirɨn krɨmiir sauan omomɨn siir ɨɨn hɨrankar nanmaiwarkainaei. Mɨ krɨma siir mɨi aiir mɨrii, krɨma wɨ nɨdidgak nwo rani. ");
INSERT INTO iws_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Mɨ krɨma siir whwonkam ɨdan wɨ dimɨn whɨrkɨ kɨmbu rani, wɨ wadɨeyar haiyaprapras okwowi. Mɨ wɨ rɨrmiiya dwo. Mɨ ɨigwɨr ɨigwɨrɨn krɨma wɨ hɨriiyar nwoyokiyokɨii. ");
INSERT INTO iws_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Mɨ kɨra tɨ kariir yɨnisɨm yɨnkamiyɨnɨn mhoɨiya sɨma kɨriirɨn wɨ Adi Komiiyɨn nɨnomor kougɨkouanɨn siir profet inkam dapi. Mɨ kɨra wɨ Bɨiyan Inkamɨn siir bɨiya namkwokɨni. Siir siyɨu ɨiir kisɨsop dirɨraerarkwokɨnɨm. ");
INSERT INTO iws_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Mɨ siya yaiyɨm wɨ siir iikam ɨmiir boɨnmɨmauuɨm. Mɨ sɨmiirɨn wɨ siya nanmaiwarkainaei. Mɨ sɨmiirɨn dimɨn biyɨeyɨm igbid kamyau siya bɨdi haiyoprimdiyɨumiigiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Whɨsarii rani, Adi Komii siir kwoɨnɨn krɨmiirsi naɨngwobumbugɨn mɨ hiinsɨma krɨmiirsi nwokɨn. Mɨ siya wɨ tɨ siir nɨkropkii, bɨenan krɨmiir whwoyakiyam. ");
INSERT INTO iws_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Mɨ siya wɨ iikamɨm nɨibwomambwo nwokaeyamɨm mɨ naokao kingiin nwowɨm, wɨ sɨmiir nokya haigɨnɨuwi. Mɨ krɨmiirɨn wɨ siyar nɨisiisiimauu api kwoɨn mɨiyɨkɨn hiinsɨma nwowiyɨn siirɨn. Sekaraia siya hɨnɨɨna boɨnkikɨn. ");
INSERT INTO iws_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mɨ yɨnisɨmɨn ɨna mwrɨiyɨn mɨ siir kwoɨnɨn mɨ siir pɨu aka ɨni kɨrɨe warar yɨnkɨn okiyɨm. Mɨ siya maeyau siiyɨn nu apa nɨɨnga saiir hɨrar nwonɨnaeyɨn mɨ ɨni Isrel sɨmiir iikamɨm sɨmiir hɨriiyar yɨmbiyamɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mɨ taka ɨiya Sisa Ogastasɨn nu komii Rom hɨran inkam komii nwokɨn. Mɨ siya siir bɨiyan inkam komii komiiyɨm sɨmiir boɨnki tɨ omisɨsɨmɨm siir hɨr nwowɨm siya kɨgrɨraowiyɨm sɨmiir hɨran iikamɨm sɨmiir inɨg ɨmiir ninɨ wɨnakiyam. ");
INSERT INTO iws_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Mɨ siyɨuɨn inɨg haiyɨn iikamɨm omom omanɨm sɨmiir mɨ ta ɨi aiir haibwakainakɨm. Mɨ taka ɨiya Sairinias siya nu Siria hɨran omom sɨmiir bɨiyan inkam komii nwokɨn. ");
INSERT INTO iws_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mɨ iikam whɨekakɨm sɨma ɨni sɨmiir yapayapa omamar swokɨ amɨm. Mɨ sɨmiir inɨgɨm sɨmiir om hɨrar inɨ wɨnaki yokwoni. ");
INSERT INTO iws_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Mɨ Josep siya om Nasaretɨn, nu Galili hɨr nwowɨn siir haiburgigɨn mɨ siya ɨna yamɨn siir brougaeyɨn Devid siir om ɨiiram, Betlehem nu Judia hɨr nwowɨn siirɨm. ");
INSERT INTO iws_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Josep siya mɨ wiga siya borɨtmaiya Maria, sowar yam. Sowa mɨnam namkwo, inɨg ninɨ dapmauuwɨuwam. Mɨ taka ɨiya Maria saeya yɨnpɨugakar nwonamka. ");
INSERT INTO iws_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Mɨ ɨiya sowa om Betlehem hɨrar nwowa mɨ yɨnisɨmɨn ɨna kaknanaokaiyɨn. ");
INSERT INTO iws_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mɨ taka ɨiya sowiir yɨnisɨm yɨnaomiyɨnɨn ɨni saiirar yaokainan. Mɨ saeya yɨnisɨm ɨiirɨn yɨuɨs mɨrmiiya saiir higrɨnɨu. Mɨ siirɨn bulmakaumi twowa nae haigiya saiir kikaiyɨu whwonkai. Mɨ sɨmani bulmakauni omaka saiir whwonkaigɨm. Dimusi rani, omakam inkamkɨ whwonkaiiyɨm inkam kɨna bɨdi dɨgiyɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mɨ kam nhɨrɨm sibsib kɨgrɨraowiyɨm, nɨiyaka sɨma omɨn siir kingiin hɨr waikaowɨigɨm, maeyauwa sibsib ɨma naeiya saiir. ");
INSERT INTO iws_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mɨ Bɨiyan Inkam Komii siir paekwosɨmɨm sɨmiir hɨriir yɨmbiyam. Mɨ Bɨiyan Inkam Komii siir paeya namnamiinan ha wokiinaiiniyɨn mɨ ɨni sɨmiirar yamɨtkɨnɨuwɨn. Mɨ sɨma nɨdid prasae bɨ kɨnwɨnkɨm. ");
INSERT INTO iws_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mɨ paekwosɨmɨn ɨna boɨnɨn sɨmiirɨn, wakae! Kɨma kɨpi nɨdid. Kara yaiwɨn kɨbiya kɨmiir nauunɨ boɨnmauugigam nɨtkɨn. Mɨ ta yaiya iikam whɨekakɨm sɨmiir kwoɨnɨm wɨ maɨrgɨmaɨrga komii saeya nwowaigɨnɨuwi. ");
INSERT INTO iws_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mɨ taka ɨiya brougae Devid siir om hɨrɨn wig ɨra yɨnisɨm yɨnkamiyɨnɨn nwɨra yaokaina. Mɨ tɨ inkamɨn kɨmiir nanmaiwarkainankɨn. Adi Komii siyar nɨmbinkikɨn siirɨn, Bɨiyan Inkam Komii Krais nwowam. ");
INSERT INTO iws_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Mɨ kɨma siirɨn hɨnɨɨna ninɨ kɨgnɨnoknɨnkɨnɨuwi mɨ siyaɨrgɨn. Mɨ kɨma wɨ yɨnisɨm nwɨrɨn yɨuɨs mɨrmini saeya higrɨnɨuɨn wɨ siir ninɨ kɨgɨuwi. Mɨ siya ɨni bulmakaumi twowa nae haigiiya, ɨni saiir whwonkaiyɨn. Adi Komii siir paekwosɨmɨn siya hɨnɨɨna boɨnkikɨn. ");
INSERT INTO iws_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Mɨ bɨ kɨmɨmɨnkikɨn nɨnomor kou hɨran paekwosɨm whɨekakɨm ɨna yɨuunaiiniyɨm mɨ sɨma ɨni tɨ paekwosɨmɨn saɨkar yaunɨ oniyɨm. Mɨ sɨma ɨni Adi Komii siir inɨg ɨiir hainan prapraskiyɨm. Mɨ sɨma mhoɨiya hɨnɨɨna boɨnki, ");
INSERT INTO iws_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Adi Komii krɨmiir Wanɨn nɨnomor kou hɨranɨn siir inɨg ɨiir hainanki. Dimusi rani, Adi Komii siya big nasmɨrwaiya bɨdi ywokiyɨn sɨmiirɨn mɨ iikam whɨekakɨm nuanɨm sɨma ɨrɨpa dɨngwomamaɨr aeikiyam. ");
INSERT INTO iws_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mɨ ɨiya Adi Komii siir paekwosɨmɨm mɨ sɨma swokɨ ama nɨnomor kou hɨriir, sɨmiir haiburgigɨm mɨ kamɨm sibsib kɨgrɨraowiyɨm sɨma sɨma yomboɨn amboɨnki, humbae! Krɨma om Betlehem hɨriir nami. Tɨ dimɨnɨn hɨr nɨmbiyamɨn siir ninɨ kɨgnaki. Bɨiyan Inkam Komii siya boɨnkiyɨn krɨmiir. ");
INSERT INTO iws_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mɨ sɨma bɨri kɨmɨmɨnkɨm ɨna yamsauwɨm mɨ sɨma Maria, Josep mɨ yɨnisɨmɨn twowa bulmakaumi nae haigiiya saiir kikaiyɨu whwonkaiyɨn, sɨmiirni inɨ kɨgɨu. ");
INSERT INTO iws_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mɨ ɨiya tɨ kamɨm sibsib kɨgrɨraowiyɨm sɨma siir ninɨ kɨgɨuwɨm mɨ sɨma tɨ yaiyɨm Adi Komii siir paekwosɨmɨm sɨma boɨnmɨmauugigɨm sɨmiir tɨ yɨnisɨmɨn siirɨm mɨ sɨma ɨni sowiirwai boɨnmɨmauuniyɨm. ");
INSERT INTO iws_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mɨ iikamɨm tɨ kamɨm sibsib kɨgrɨraowiyɨm sɨmiir yai aiir wakaeyɨm mɨ sɨma ɨni hinda yanaakiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria saeya tɨ yaiyɨm saeya wakaeyɨm sɨmiir sɨmiira naɨngwokwokaigika. Mɨ saiir kwoɨnau hɨrar haigi okai, saeya bɨri naɨngwo owouga. ");
INSERT INTO iws_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mɨ kamɨm sibsib kɨgrɨraowiyɨm sɨma ha swokɨ apamɨm mɨ sɨma mwai ɨna yapwowaowamɨm Adi Komii siir inɨg ɨiir hainanam digworaekwowɨm sɨma wakaeyɨm mɨ sɨma kɨgɨm sɨmiir. Mɨ digworaekwo whɨekakɨm Adi Komii siir paekwosɨmɨm sɨma boɨnmamauugikɨm bɨdi yɨmbiyamkiyɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mɨ mhoɨiya ɨi ɨriiyar kwoɨmɨm namkiyɨm mɨ siir mɨoɨsa ɨna kɨtiyopnɨr haiya. Mɨ sɨma siir inɨgɨn Jisɨs yokdap haigɨnɨu. Mɨ Adi Komii siir paekwosɨmɨm sɨma bɨiyar dapkikɨnkɨn, ɨiya siya siir yopiiya saiir mhɨinau hɨr nikɨ okai karamaeyar nikɨ owɨn saiirar. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ta ɨiya sowa buga niyɨoprɨkmaiya sowa buga siyɨuɨn bɨiya Moses siya wɨnboɨnkiyɨn mɨ siir hɨriinanar mɨ tɨr. Mɨ siir ad yopiiyo ɨna hainamwo siirɨn om komii Jerusalem hɨriir, Bɨiyan Inkam Komii siir ɨɨn ninɨ onkwo hauugiyam. ");
INSERT INTO iws_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Yai komii kwɨra Adi Komii siir Yokwo Komiiya saiir nwowa, saeya hɨnɨɨna wɨnboɨnkika, bɨikɨ bɨiyan yɨnisɨm yɨnhaomiyɨnɨn, yɨo mɨnɨm nɨmbingɨn, Bɨiyan Inkam Komiiyɨn siir hauugiyam, siir yɨnisɨmar nwowɨm. ");
INSERT INTO iws_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Yokwo Komii saiir yai kɨrɨe kwɨra saeya hɨnɨɨna boɨnkika, ɨiya wigkamwo sowa yɨnisɨm yɨnkamiyɨn yɨnhaomiyɨnɨn, Adi Komii siir omaka komiiya saiir hainam mɨ yo sowawaiyo ɨriipɨ hɨriinan ɨɨnmab haomwo ɨsa timɨ ɨsom hainam. Mɨ ɨɨnmab aiiram mɨ whaowaekɨn, mhautam haomwo ɨsa timɨ ɨsom hainam. Mɨ Josep, Maria sowawaiyɨn om komii Jerusalem hɨriir asi namkwo. ");
INSERT INTO iws_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Mɨ inkam nwɨrɨn om komii Jerusalem hɨr nwokɨn, siir inɨgɨn Simion. Mɨ tɨ inkamɨn siya dimɨn whɨrkɨ bɨ kɨmbugɨn. Nɨɨngaka. Siya inkam wadɨekɨn. Siya Adi Komii siiramar mɨ kwɨsboɨnikɨn mɨ siya ɨi aiirɨmar nikɨ owi, ɨiya Adi Komii siya inkam nwɨrɨn siir nɨkropki, Isrel hɨran iikamɨm sɨmiir mhɨi kwoɨn ɨmiir kɨrɨe haigɨnɨuwam. Mɨ Adi Komii siir naeyɨuɨn ɨni saɨkar nwowɨn. ");
INSERT INTO iws_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Adi Komii siir naeyɨuɨn siir bɨdi yɨisimauuɨn mɨ siya wɨ nikɨ aosau rani. Nɨɨngaka. Siya Bɨiyan Inkam Komiiyɨn Krais ɨiya siya nɨtana saiiramar nikɨ owi. ");
INSERT INTO iws_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Adi Komii siir naeyɨuɨn siyar hɨurworwokai ɨnsiingikɨn mɨ siya Adi Komii siir omaka saiir hɨriir yapnɨnopkainam mɨ yopii adwo yɨnisɨm Jisɨs siirɨn ɨna hainaniyɨn Adi Komii siir omaka saiirɨm, Adi Komii siir hauugiyɨm, sɨmiir siyɨu ɨeya boɨnɨn siir hɨriinan. ");
INSERT INTO iws_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Mɨ Simion siir ɨɨna tɨ yɨnisɨm ɨiirar yɨnkwo mɨ siya Adi Komii siir inɨg ɨiirɨn hɨnɨɨna hainan prapras boɨnki, ");
INSERT INTO iws_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Bɨiyan Inkam Komii dimɨnɨn bɨiya kɨra nɨmbinɨn, kara siir bɨdi kɨgɨn. Mɨ tariinanɨn kara naonami, kɨra kariirɨn ha kɨgnɨnkɨnki. Tariinanɨn kara kɨriir mɨiyan inkamɨn wɨ maɨrgɨmaɨrgar nwowi. ");
INSERT INTO iws_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Inkamɨn krɨmiir nanmaiwarkainaɨnɨn kara siir bɨdi kɨgɨn. ");
INSERT INTO iws_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Kɨra tɨ dimɨn ɨiirɨn iikam whɨekakɨm hɨnda tɨndanɨm sɨmiir whwonkam ɨda dirɨraerarkɨn. ");
INSERT INTO iws_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Siya paenan mɨnam nɨuyakɨn iikam whɨekakɨm Juda iikam tani, sɨmiir kwoɨn ɨmiir nanaaknɨnki haigɨnɨuwam. Isrel kɨriir iikamɨm inɨg komii sɨmiir hauu haigɨnɨuwam. ");
INSERT INTO iws_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Mɨ ɨiya siir yopii adwo sowawaiyɨn hɨriinan wakaeywo tɨ hɨriinan yaiyɨm Simion siya boɨnɨm sowiirwai yɨnisɨm ɨiir mɨ sowawaiyɨn naɨngwoyɨmyok pranae bɨ kɨnkwo. ");
INSERT INTO iws_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Mɨ Simion siya sɨmiirniiyɨn hanɨɨngɨ yɨgboɨnmamaɨr haigɨnɨu. Mɨ siya Maria Jisɨs siir apua saiirɨn hɨnɨɨna boɨnki, wakae, tɨ kowiirwai yɨnisɨmɨn, Isrel sɨmiir iikamɨm wɨ higa siya nɨnɨuwi. Mɨ nhɨrɨm wɨ siya swokɨ anmaiwarkainaei. Tɨ inkamɨn siya, Adi Komii siya nɨmbinɨn. Mɨ siir siyɨu ɨiirɨn wɨ siya nɨisiimauuwi mɨ nhɨrɨm wɨ saɨkar nɨnkɨnwamwarkɨi boɨni. Mɨ nhɨrɨm wɨ yaewan siir kɨndiyɨuwangigi. ");
INSERT INTO iws_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Mɨ iikam whɨekakɨm sɨmiir kwoɨn aowa aowanɨm wɨ idowɨiyar nwoki. Mɨ mhoɨiya sɨma siirɨn wɨ siyɨu mɨiyɨk mɨiyɨknan tɨr tani. Mɨ kɨra siirɨn hɨriinan kɨgi mɨ kɨriir kwoɨnɨn wɨ hindara hɨugɨmkɨkɨugi, siirsiyɨn. Mɨ ta hɨk hɨriinana wɨ sauɨn, inkam pɨu nɨtiyɨn mɨ ha kɨmpɨpɨsugiiyɨn, wɨ hɨriinan kɨmpɨpɨsugi. Simion siya hɨnɨɨna boɨnkikɨn. ");
INSERT INTO iws_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Mɨ profet wig ɨra om komii Jerusalem hɨr nwoka, saiir inɨgɨn Anaka, saeya Fanyuel siir yɨnisɨmka. Asa siir isidɨn siir hɨranka, saeya waibiyɨe bɨdi yowa. Bɨiya saeya kam pɨua nikɨ owa, saeya bɨewiyɨm pariiga ywo, ɨriiyar whɨs (7). ");
INSERT INTO iws_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Mɨ mhoɨiya saiir kamɨn ɨna yaonamɨn mɨ wig igabae nhɨɨnga saiir bɨewiyɨm pariig, kamnwii whii (84). Mɨ saeya ɨinokɨinokɨn Adi Komii siir inɨg hainanɨm bɨ siisika, saeya Adi Komii siir inɨg ɨiirɨn nɨi nabɨe nɨi nabɨe hainanika. Mɨ ɨi nhɨrɨm, saeya nae mɨnɨm pa mɨ haiyaei ɨiyɨm saeya nhwo Adi Komii siiram kwɨsboɨniyɨm Adi Komii siir omaka komiiya saiir. ");
INSERT INTO iws_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mɨ ɨiya Josep Maria sowawaiyɨn ta omaka Adi Komii siira saiir hɨrar nikɨ owo, Adi Komii siir nɨnkɨn ɨmiiyaeyɨm mɨ Ana saeya ha nɨmbiniya mɨ saeya ɨni Adi Komii siir inɨg ɨiir inɨ ɨgboɨnmamaɨrniya. Mɨ saeya kɨmɨdiniya tɨ yɨnisɨmɨn siir yai ɨmiir boɨnmɨmauu, iikam whɨekakɨm om komii Jerusalem hɨranɨm, siirɨm nwokwokɨnɨm, Isrelan iikamɨm hɨr nwowɨm sɨmiir nanmaiwarkainam. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Sɨma digworaekwo whɨekakɨm dirɨraerar dɨgiyɨm, Bɨiyan Inkam Komiiyɨn siir siyɨu ɨeya boɨnɨn siir hɨriinan mɨ sɨma ɨna swokɨ amɨm nu Galili, sɨmiir oma Nasareta hɨriir. ");
INSERT INTO iws_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mɨ tɨ yɨnisɨmɨn ha mwrɨigiyɨn mɨ siirɨn ma mɨnkɨn bɨ nɨpiyaokɨimɨmɨnkɨn siya ɨni kɨrɨekakar ywokiyɨn mɨ siya ɨni nɨnoknɨnkɨn mɨiyɨk whɨekakar mɨ okiyɨn. Mɨ Adi Komii siir naɨngwoyɨmyoka ɨni saɨkar nwowa. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Mɨ bɨewii bɨewiiyɨm ta ɨi komiiya wou nikwo aeiya Pasova Jisɨs siir yopii adwo, sowawaiyɨn om komii Jerusalem hɨriiyar namnanaeiko, sowawaiyɨn bɨ nwokaigiiko. ");
INSERT INTO iws_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jisɨs siir bɨewiyɨm ɨuur whɨsa namwo ɨuwɨm mɨ siya wara yɨnkɨn am, siir yopii ad owakan, ta ɨi komiiya wou nikwo aeiya saiirɨm. Bɨewii bɨewiiyɨm bɨiya sowawai nikɨ tɨrkiyɨm sɨmiir hɨriinan. ");
INSERT INTO iws_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Mɨ wou nikwo aeni ɨiya dɨg nwokiya mɨ sɨma ɨna swokɨ amɨm mɨ yɨnisɨm Jisɨs siya om komii Jerusalem hɨrar ywoki. Mɨ siir yopii adwo sowawaiyɨn ha bɨ naɨngwoko siya ɨni hɨrar ywokiyɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Mɨ sowawaiyɨn ha naɨngwoko siya tɨ iikam whɨekakɨm sowaka waiyar napamɨm sɨmaka napami mɨ ta nabɨe kɨrɨeya sowa sowa asi napamko. Mɨ sowa sowiir nomiiyauɨm mɨ sowiir ad igrɨmɨm sɨmiirɨm hansɨram siya sɨmaka mɨ owi. ");
INSERT INTO iws_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mɨ sowawaiyɨn ha hansɨrnanaeyo siir bɨ swokɨ kɨgɨn. Nɨɨngaka. Mɨ sowawaiyɨn, om komii Jerusalema hɨriir asi swokɨ haiyɨug hansranamko siirɨmɨn. ");
INSERT INTO iws_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ɨiyɨm sowawai siirɨm hansɨro, kwɨsa hansɨr mɨ kwoɨmaka saiir inɨ kɨgɨu, omaka Adi Komii siira saiir hɨr nwowi siya, Juda sɨmiir inkamɨm siyɨupai, siyɨupaiyɨm sɨm nowomwarkaiyɨuwiyɨm sɨmiir bopwoniya hɨr nɨdwokai wakaemɨmɨki, sɨmiir yai mɨn dimɨn ɨmiir mɨ siya sɨmiirɨn ɨna mɨ kɨnawaomwarkɨi srɨiyɨn. ");
INSERT INTO iws_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Mɨ kamɨm siir yai ɨmiir wakaekiyɨm mɨ sɨma ɨni hindarar yanaakiyɨm tɨ yai whɨekakɨm siya nɨnomoknɨnkɨn boɨnkiyɨm sɨmiirɨn. ");
INSERT INTO iws_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mɨ sowawaiyɨn siir ninɨ kɨgɨuwɨn mɨ sowa ɨni hindara yanaakiyo. Mɨ siir yopiiya saeya siirɨn hɨnɨɨna inɨ boɨnɨu, yɨnisɨm! Kɨra krɨriirwaiyɨn hɨnɨɨn dimusi tɨrgikɨn, ha? Krɨrawaiyɨn kɨriirsiyɨn pranae pranae bɨ naɨngwoyɨmyok hansɨrko. ");
INSERT INTO iws_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mɨ siya sowiirwai yai aka hɨnɨɨna yowarkɨi boɨn, kowawaiyɨn kariirɨm dimusi hansɨrko? Mɨ kowa bɨ nɨnoknɨnkɨnko, kara pɨ kariir Adɨn siir omaka tɨrar nwowi, ha? ");
INSERT INTO iws_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mɨ sowawaiyɨn bɨ nɨnoknɨnkɨnko ta yaiya siya boɨna saiir yaimwokɨyaimwo aiirɨn. ");
INSERT INTO iws_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Mɨ siya ɨni sowakawai warar swokɨ ɨnkɨn amɨn om Nasareta hɨriirɨn. Mɨ siya ɨni yopii ado sowiirwai yaiyar mɨ wakaeyoknan. Mɨ tɨ yaimɨn dimɨnɨm siya boɨnɨm, ɨni yopiiya saiir kwoɨnau hɨrar haigi okaiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Mɨ Jisɨs siya komii namwoɨuwɨn mɨ siir nɨnoknɨnkɨna ɨni warar mɨ ɨnkɨn opnɨrtaraokiya. Mɨ iikam ɨkɨm sɨma ɨni siiramar yaɨngwokɨɨnɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Taibirias Sisa siya kɨgrɨraokiyɨm omom omom nhɨrɨm nu Rom hɨranɨm, bɨewiyɨm ɨuur ɨriiyar (15). Mɨ Pontias Pailat siya nu Judia siir kɨgrɨraowan inkam nwokɨn. Mɨ ta ɨi aiirɨn Herot siya iikamɨm nu Galili hɨranɨm, sɨmiirɨn saiir kɨgrɨraokɨn. Mɨ siir akamɨn Filip siya nu Itaria mɨ nu Trakonaitis sowiir kɨgrɨraowan inkam komii nwokɨn. Mɨ Laisenias siya nu Abilini siir kɨgrɨraowan inkam nwokɨn. ");
INSERT INTO iws_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anas, Kaiafas sowa prismi bɨiyan inkam nwoko. Mɨ ta ɨiya Jonɨn Sekaraiani yɨnisɨmɨn maeyau siiyɨn nu apa saiir hɨr nwowɨn mɨ Adi Komii siir yaiya siir hɨriirɨn, saiirar nɨmbiyamkɨn. ");
INSERT INTO iws_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Mɨ Jon siya omom omom whɨekakɨm ɨe Jodan siir kingiin hɨr nwowɨm, sɨmiir hɨran iikamɨm sɨmiirɨn siya hɨnɨɨna boɨn, kɨma kɨmiir dimɨn biyɨeyɨm digɨumii sɨmiir haimriiyɨugigi mɨ op wa nwokɨ baptais haigɨnɨuɨm mɨ Adi Komii siya kɨmiir dimɨn biyɨe biyɨeyɨm bɨiya kɨma tɨrkaiyɨuɨm wɨ hanɨɨngɨn haiyoprimdiyɨumiigi. ");
INSERT INTO iws_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jon siya hɨnɨɨna boɨn profet inkamɨn siir yai aiirɨn. Yai nhɨrɨm profet Aisaia siya wɨnboɨnkiyɨm Yokwo Komii saiir, yɨm hɨnɨɨngɨm, mɨ inkam nwɨrɨn maeyau siiyɨn nu apa nɨɨnga, hɨr kauwok boɨnkiyɨn siya hɨnɨɨna kauwok boɨnkikɨn, Bɨiyan Inkam Komiiyɨn siir siyɨuɨm sɨmiir kisɨsop dirɨraerarkwokɨn. Siir siyɨu ɨiir sɨbgu dirɨraerarkwokɨn. Profet Aisaia siya hɨnɨɨna boɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mɨ maeyauwɨm ɨeno ɨeno whɨekakakɨm yɨm ha timɨ haɨnkrɨmkrɨnkɨnkwokɨn. Mɨ mhɨu komii komiiyɨm mɨ mhɨuisɨsɨm ɨkɨm, wɨ sɨma dopkiyɨmɨkɨina mɨ siyɨuɨm mɨpugnan wrɨeyokɨm yɨm timɨ oprɨmtɨoki mɨ siyɨuɨm haigi ɨnamnaniyɨm, yɨm timɨ iyɨohɨmɨkmai dirɨraerarkwokɨn. ");
INSERT INTO iws_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Mɨ iikam whɨekakɨm wa nwokɨ kɨgnɨnoknɨnkɨnkiyɨm, inkamɨn Adi Komii siya nɨmbinɨn krɨmiir nanmaiwarkainanɨn siirɨn. Profet Isaia siya hɨnɨɨna boɨnkikɨn. ");
INSERT INTO iws_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jon siya iikam isid komiiyɨn siiram nɨtɨm saɨka nwowɨm sɨmiirɨn hɨnɨɨna boɨnki, kɨma iikam mɨiyɨknankɨ mɨ ɨuwi, ɨni wrakɨwranan ywowɨm. Mɨ kɨmiirɨn nhɨnga boɨnkikɨm kariirɨm nɨdamnaniyɨm, op kɨmiir baptais haigɨnɨugiyɨm? Mɨ Adi Komii siya wɨ kɨmiir nonkwonɨɨnwomwɨɨrnɨnkɨn tani, aniya? ");
INSERT INTO iws_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mɨ kɨma iikam whɨekakɨm sɨmiirɨn hɨnɨɨna dɨisiimauu, kɨma kɨmiir dimɨn biyɨe whɨekakɨm, sɨmiirɨn bɨdi haiyoprimdimiigiyɨm. Mɨ kɨma, kɨma kɨma hɨnɨɨna kɨpi nɨnkɨnwamwarkɨi boɨn, nɨm krɨma Ebraham krɨmiir brougaeyɨn siir iikamkɨm mɨ siya wɨ dɨgar nwowi mɨ krɨma wɨ iikam mɨiyɨkar nwowi. Nɨɨngaka. Mɨ Adi Komii siya naɨngwowi mɨ tɨkɨ siiyam siyar mɨ dirɨraerarii, siya wɨ dɨgar mɨ owi mɨ sɨma wɨ Ebraham siir yɨnisɨmar namwoɨuwi. ");
INSERT INTO iws_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ua ɨni paemɨi hɨrar haigɨn taowaigɨna mɨ pae whɨekakɨm nae mɨiyɨk bud karamae nwowɨm yɨm wɨ paenau sɨma nɨiyɨtkaigaiki. Mɨ wɨm kɨma ɨni tɨ paeyɨm sɨmiir hɨriinan ywowɨm. ");
INSERT INTO iws_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mɨ sɨma siirɨn hɨnɨɨna srɨi, krɨma wɨ panɨɨna tɨri. Sɨmiirɨn hɨnɨɨna nɨisiimauuɨm, krɨmiir dimɨn biyɨeyɨm bɨdi haiyoprimdiyɨmiigiyɨm, ha? ");
INSERT INTO iws_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Mɨ Jon siya sɨmiirɨn boɨniyɨo yaiya hɨnɨɨn boɨnki, inkamɨn yɨuɨs kwɨsaɨrgakɨnɨuwi mɨ siya kwɨra, inkamɨn nɨɨnga nwowɨn, siir timɨ hauu. Mɨ inkamɨn naemɨnkɨn naokɨngugunankaiyɨn yɨo ɨriipa hɨriinanar timɨ tɨr. ");
INSERT INTO iws_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mɨ kamɨm omom omomi umɨr haiiyɨm, yɨm ɨriipɨ hɨriinan ɨna mɨ ɨtɨm Jon siirɨm, op sɨmiir baptais haigɨnɨuɨm. Mɨ sɨma siirɨn hɨnɨɨna srɨi, iikam nowamwarkaiyɨuan inkam, krɨma wɨ panɨɨna tɨri, sɨmiirɨn hɨnɨɨna nɨisiimauuɨm, krɨmiir kwoɨn biyɨeyɨm, bɨdi haiyoprimdiyɨumiigiyɨm? ");
INSERT INTO iws_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Mɨ Jon siya sɨmiirɨn hɨnɨɨna boɨnmauugi, kɨma umɨrmaɨrɨn gavman siya boɨnkiyɨn siirarar hai. Yaeya umɨr nokii kɨpi swokɨ ɨnkɨn hai. ");
INSERT INTO iws_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mɨ kamɨm yaii nɨniiyɨm yɨm ɨriipɨ hɨriinan siirɨn ɨna mɨ srɨiyɨm, krɨma wɨ panɨɨn panɨɨna tɨri? Mɨ siya sɨmiirɨn hɨnɨɨna boɨnki, kɨma inkam nhɨrmi hindara kɨpi prɨitɨoprɨitɨo mɨ kɨma sɨmiirɨn whɨsarii kɨpi prɨiboɨn hɨuriyɨu mɨ sɨmiir umɨrɨm whɨsarii kɨpi prɨiyɨksasae hai. Mɨ kɨmiir kwoɨnɨn hiinsɨma dwo tɨ umɨrsɨmɨn kɨma haiiyɨn kɨmiir mɨi aiirsi. ");
INSERT INTO iws_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mɨ iikam whɨekakɨm sɨma ɨna yɨnaɨngwoyɨmiyok boɨnɨm, tɨ inkamɨn siya Kraisɨn Adi Komii siya nɨkropkiyɨn iikamɨm sɨm nanmaiwarkainam, aniya? ");
INSERT INTO iws_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jon siya sɨmiir yaiyaka hɨnɨɨna yowarkɨi boɨn kara kɨmiirɨn op ara baptais haigɨnɨuwi, inkamɨn kariir mhoɨiya nɨtɨn kariir kouwɨn ɨni siyar ywowɨn mɨ siya ɨni yaowae adnan ywowɨn, kara ɨni yɨnisɨmnan ywowɨn. Mɨ kara siir mɨiyɨm wa sɨbgu ɨnomoknɨnkɨn mɨrii rani. Kara inkam mɨiyɨk rani. Nɨɨngaka. Mɨ kara op arar baptais haigɨnɨuwi mɨ Adi Komii siir naeyɨuɨn siirɨn wɨ siyar haɨnɨuae haigɨnɨuwi mɨ tɨ dimɨn biyɨe ɨmiirɨn wɨ paenan siyar nɨu ɨuguski. ");
INSERT INTO iws_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Siya ɨni inkamɨn twonidɨm twonau haigiiyɨn mɨ ha nokwobrombropiyɨn, ɨni siir hɨriinan ywowɨn. Mɨ ɨiya ɨkɨ twonid ɨmiir nokwobrombrop dɨgiyɨm mɨ kasɨm pa kuubrukigi. Mɨpi twonid nɨɨngam sɨmasɨma namwokaiyɨuwi mɨ sɨmiirɨn pɨ omaka nae haigiiya hɨr ninɨ haigiyɨuwi. Mɨ siya kas ɨmiirɨn pa nhɨsopkɨninaka mɨ sɨmiirɨn pɨ pae nhɨsopkɨn namgɨnki. Mɨ ta paeya saeya wɨ nɨutɨngi rani. Nɨɨngaka. Saeya wɨ hɨriiyar nɨuyokiyokɨikaeyami. ");
INSERT INTO iws_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mɨ Jon siya tɨ hɨriinanɨm sɨmiir boɨnmauu dɨgiyɨn mɨ siya Yaiwɨn Kɨbiya saiir yai kɨrɨekɨrɨe kɨbi whɨekakɨm sɨmiir warar yɨnkɨn boɨnmɨmauu. ");
INSERT INTO iws_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Jon siya gavmanɨn siir bɨiyan inkamɨn Herot ɨo siir nwokɨn. Dimusi rani, siya siir nomousɨmɨn Filip siir wiga Herodias saiir haɨnɨkɨi nonkwonan mɨ siyɨu biyɨe nhɨrɨm siya tɨrɨm ɨo sɨmiirsi wara mɨ ɨnkɨn okɨn. ");
INSERT INTO iws_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Mɨ Herot siya siyɨu biyɨe komii whɨrɨn ha swokɨ tɨrɨn mɨ ɨni tɨ bɨiyanɨm sɨmakar swokɨ ɨnkɨn haigɨnkiyɨn. Whɨsarii rani, Jon siirɨn siya hɨugrɨpkɨikikaigɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ɨiya Jon siya iikamɨm sɨmiir baptais haigɨnɨuɨn mɨ siya Jisɨs siirɨn ɨni warar mɨ ɨnkɨn baptais haigɨnɨuɨn mɨ ɨiya Jisɨs siya nhwowar nikɨ kwɨsboɨnɨn mɨ nɨnomora ɨni omaka anonanar haiwaokiya. ");
INSERT INTO iws_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Mɨ Adi Komii siir naeyɨuɨn ɨna yɨuwiniyɨn. Mɨ sɨma kɨgwɨn siir naeyɨuɨn ɨɨnmabnan siinaini siiram. Mɨ yai kwɨra nɨnomor kou hɨr kauwok boɨnkiya saeya hɨnɨɨna kauwok boɨnkika, kɨra kariir yɨnisɨm wadɨekɨ wadɨe kɨɨngɨn. Mɨ kariir kwoɨnɨn ɨni kɨriiramar naɨngwokwonanaeyɨn. Mɨ kariir mhɨi kwoɨnɨm, kɨriirɨmɨn ɨni maɨrgɨmaɨrga ywokiyɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ɨiya Jisɨs siya siir bɨewiyɨm, kamnwɨr ɨuura nwowɨn mɨ siya ha mɨrii bwakainakɨn. Iikamɨm sɨmiir kwoɨnɨm ha naɨngwokɨm, Jisɨs siya Josep siirgɨsiir nhɨekɨnɨuwi. Nɨɨngaka. Siya Adi Komii siirgɨsiir yɨnisɨmkɨn. Mɨ Josep siya Hilai siir yɨnisɨmkɨn. ");
INSERT INTO iws_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Mɨ Hilaiyɨn, yɨo Matatni yɨnisɨmkɨn. Mɨ Matatɨn, yɨo Livaini yɨnisɨmkɨn. Mɨ Livaiyɨn, yɨo Melkaini yɨnisɨmkɨn. Mɨ Melkaiyɨn yɨo Janaini yɨnisɨmkɨn. Mɨ Janaiyɨn, yɨo Josepni yɨnisɨmkɨn. ");
INSERT INTO iws_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Mɨ Josepɨn yɨo, Matataiasni yɨnisɨmkɨn. Mɨ Matataiasɨn, yɨo Emosni yɨnisɨmkɨn. Mɨ Emosɨn, yɨo Neamni yɨnisɨmkɨn. Mɨ Neamɨn, yɨo Eslaini yɨnisɨmkɨn. Mɨ Eslaiyɨn, yɨo Nagaini yɨnisɨmkɨn. ");
INSERT INTO iws_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Mɨ Nagaiyɨn, yɨo Meatni yɨnisɨmkɨn. Mɨ Meatɨn, yɨo Matataiasni yɨnisɨmkɨn. Mɨ Matataiasɨn, yɨo Semeni yɨnisɨmkɨn. Mɨ Semenɨn, yɨo Josekni yɨnisɨmkɨn. Mɨ Josekɨn, yɨo Jodani yɨnisɨmkɨn. ");
INSERT INTO iws_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Mɨ Jodanɨn, yɨo Joanani yɨnisɨmkɨn. Mɨ Joananɨn yɨo, resani yɨnisɨmkɨn. Mɨ Resanɨn, yɨo Serababelni yɨnisɨmkɨn. Mɨ Serababelɨn, yɨo Sialtielni yɨnisɨmkɨn. Mɨ Sialtielɨn, yɨo Neraini yɨnisɨmkɨn. ");
INSERT INTO iws_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Mɨ Neraiyɨn, yɨo Melkaini yɨnisɨmkɨn. Mɨ Melkaiyɨn, yɨo Edaini yɨnisɨmkɨn. Mɨ Edaiyɨn, yɨo Kosanamani yɨnisɨmkɨn. Mɨ Kosanamaɨn, yɨo Elmadamni yɨnisɨmkɨn. Mɨ Elmadamɨn, yɨo Erni yɨnisɨmkɨn. ");
INSERT INTO iws_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Mɨ Erniyɨn, yɨo Josuani yɨnisɨmkɨn. Mɨ Josuaɨn, yɨo Eliesani yɨnisɨmkɨn. Mɨ Eliesaɨn, yɨo Jorimni yɨnisɨmkɨn. Mɨ Jorimɨn, yɨo Matatni yɨnisɨmkɨn. Mɨ Matatɨn, yɨo Livaini yɨnisɨmkɨn. ");
INSERT INTO iws_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Mɨ Livaiyɨn, yɨo Simioni yɨnisɨmkɨn. Mɨ Simionɨn, yɨo Judani yɨnisɨmkɨn. Mɨ Judanɨn, yɨo Josepni yɨnisɨmkɨn. Mɨ Josepɨn, yɨo Jonamni yɨnisɨmkɨn. Mɨ Jonamɨn, yɨo Elaiakimni yɨnisɨmkɨn. ");
INSERT INTO iws_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Mɨ Elaiakimɨn, yɨo Meliani yɨnisɨmkɨn. Mɨ Melianɨn, yɨo Menani yɨnisɨmkɨn. Mɨ Menanɨn, yɨo Matatani yɨnisɨmkɨn. Mɨ Matatanɨn, yɨo Netani yɨnisɨmkɨn. Mɨ Netanɨn, yɨo Devidni yɨnisɨmkɨn. ");
INSERT INTO iws_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Mɨ Devidɨn, yɨo Jesini yɨnisɨmkɨn. Mɨ Jesiyɨn, yɨo Obetni yɨnisɨmkɨn. Mɨ Obetɨn, yɨo Boasni yɨnisɨmkɨn. Mɨ Boasɨn, yɨo Salmoni yɨnisɨmkɨn. Mɨ Salmonɨn, yɨo Nasoni yɨnisɨmkɨn. ");
INSERT INTO iws_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Mɨ Nasonɨn, yɨo Aminadapni yɨnisɨmkɨn. Mɨ Aminadapɨn, yɨo Atmini yɨnisɨmkɨn. Mɨ Atminɨn, yɨo Anaini yɨnisɨmkɨn. Mɨ Anaiyɨn, yɨo Hesroni yɨnisɨmkɨn. Mɨ Hesronɨn, yɨo Peresni yɨnisɨmkɨn. Mɨ Peresɨn, yɨo Judani yɨnisɨmkɨn. ");
INSERT INTO iws_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Mɨ Judaɨn, yɨo Jekopni yɨnisɨmkɨn. Mɨ Jekopɨn yɨo Aisakni yɨnisɨmkɨn. Mɨ Aisakɨn, yɨo Ebrahamni yɨnisɨmkɨn. Mɨ Ebrahamɨn, yɨo Tirani yɨnisɨmkɨn. Mɨ Tiraɨn, yɨo Nehoni yɨnisɨmkɨn. Mɨ Nehoɨn yɨo Serakni yɨnisɨmkɨn. ");
INSERT INTO iws_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Mɨ Serakɨn, yɨo Reuni yɨnisɨmkɨn. Mɨ Reunɨn, yɨo Pelekni yɨnisɨmkɨn. Mɨ Pelekɨn, yɨo Ebeni yɨnisɨmkɨn. Mɨ Ebenɨn, yɨo Selani yɨnisɨmkɨn. ");
INSERT INTO iws_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Mɨ Selaɨn, yɨo Kenani yɨnisɨmkɨn. Mɨ Kenanɨn, yɨo Apaksatni yɨnisɨmkɨn. Mɨ Apaksatɨn, yɨo Siemni yɨnisɨmkɨn. Mɨ Siemɨn, yɨo Noani yɨnisɨmkɨn. Mɨ Noaɨn, yɨo Lemekni yɨnisɨmkɨn. ");
INSERT INTO iws_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Mɨ Lemekɨn, yɨo Matusalani yɨnisɨmkɨn. Mɨ Matusalaɨn, yɨo Inokni yɨnisɨmkɨn. Mɨ Inokɨn, yɨo Jaretni yɨnisɨmkɨn. Mɨ Jaretɨn, yɨo Mahalalelni yɨnisɨmkɨn. Mɨ Mahalalalelɨn, yɨo Kenani yɨnisɨmkɨn. ");
INSERT INTO iws_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Mɨ Kenanɨn, yɨo Inosni yɨnisɨmkɨn. Mɨ Inosɨn, yɨo Setni yɨnisɨmkɨn. Mɨ Setɨn, yɨo Adamni yɨnisɨmkɨn. Mɨ Adamɨn, yɨo Adi Komiini yɨnisɨmkɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Adi Komii siir naeyɨuɨn ɨni Jisɨs siir yanɨnkɨnɨuniyɨn mɨ siya ɨe Jodan siir haiburgigɨn mɨ ɨna swokɨ amɨn. Mɨ Adi Komii siir naeyɨuɨn siya yɨkɨunam maeyau siiyɨn apa nɨɨnga inkam karamaeya saiir hɨriir yam. ");
INSERT INTO iws_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Mɨ siya ta maeyau siiyɨn apa inkam karamaeya saiir nwowɨn, ɨiyɨm kam nwɨsa ywo (40). Mɨ ta ɨiya Setan siya Jisɨs siirɨmɨn saiir kɨnankɨukɨn. Mɨ ta ɨi aiirɨn Jisɨs siya nae bɨ naekɨn nɨɨngaka. Siya mhɨirɨma nwokɨn. ");
INSERT INTO iws_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Mɨ Setan siya siir boɨnki, kɨra Adi Komii siir yɨnisɨmkɨnɨuwi mɨ kɨra pɨ tɨ siiyaɨn siir boɨnki mɨ siya pɨ bret nwokɨ ɨmbiyamɨm. ");
INSERT INTO iws_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Mɨ Jisɨs siya siir yai anaka hɨnɨɨna yowarkɨi boɨnki. Yokwo Komii saeya hɨnɨɨna boɨnka inkamɨn nae aram naɨngwowiyɨn siya wɨ kɨrɨekak nwo rani. Nɨɨngaka. Inkamɨn bret ara naeyam naɨngwowiyɨn siya siirɨn wɨ kwoɨnbudɨn omwai waiyayokiyokɨiiyɨn siir hauu rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Mɨ Setan siya siirɨn ɨna yɨkɨunaiinamɨn mhɨukɨua hɨriir mɨ bɨ kɨmɨmɨnkikɨn, siya ɨna yɨisiimauuwɨm nu tɨran omom omom whɨekakɨm sɨmiir. ");
INSERT INTO iws_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Mɨ siya boɨnki, kara tɨ kariir omom omomɨm mɨ kariir dimɨn taemɨn whɨekakɨm wɨ kɨriir hauuwi. Mɨ kɨra wɨ nu kɨgrɨraowan inkam komii nwowi, whɨsarii rani, yɨm tɨ digworaekwowɨm kariirargɨm mɨ kara inkam nwɨr mɨ hauuwi kara wa mɨ hauuwi, kariirar kwoɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kɨra ogmwo kariiram hɨui mɨ kariir inɨg ɨiir hainani, tɨ digworaekwo whɨekakɨm yɨm kɨriirgɨm. ");
INSERT INTO iws_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jisɨs siya siir yai aka hɨnɨɨna yowarkɨi boɨnki, Yokwo Komii saeya hɨnɨɨna boɨnka. Kɨra Bɨiyan Inkam Komiiyɨn siir inɨg ɨiirarar hainan siya kɨriir Adi Komiikɨn mɨ kɨra siir mɨi aiirarar donkwo ɨski. ");
INSERT INTO iws_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Mɨ Setan siya Jisɨs siirɨn om komii Jerusalem hɨriir yɨkɨunam. Mɨ Jisɨs siirɨn omaka Adi Komii siir inɨg hainaniya saiir akou hɨr inɨ okmwɨn okwoɨu. Mɨ siya siir boɨnki mɨ kɨra Adi Komii siir yɨnisɨm kɨɨngɨnɨuwi mɨ kɨra pa diswɨt natkinaiinam. ");
INSERT INTO iws_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Yokwo Komii saeya hɨnɨɨna boɨnka mɨ Adi Komii siya wɨ siir paekwosɨmɨm sɨmiir boɨnki. Sɨma kɨriirar sɨbgu kɨgrɨraowɨm mɨ kɨra wɨ nao rani. ");
INSERT INTO iws_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Mɨ sɨma wɨ kɨriir nonkwowɨni sɨmiir ɨɨnam mɨ kɨriir ɨga wɨ siiya kwɨrkɨ swokɨ haɨn tani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Mɨ Jisɨs siya siir yai aka hɨnɨɨna yowarkɨi boɨn, Yokwo Komii saiir yaiya saeya hɨnɨɨna boɨnka, kɨra Bɨiyan Inkam Komiiyɨn siirɨm kɨpi kɨnankɨu mɨ siirɨm kɨpi srɨi, tɨ hɨriinan dimɨn biyɨeyɨn siya kɨriir whɨndirɨraerarkiyɨm. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Mɨ ɨiya Setan siya siirɨm kɨnankɨuguguwɨn, tɨ dimɨn taemɨn whɨekakɨm sɨmiir mɨ Jisɨs siya bɨ wakaeyoknakɨn. Mɨ Setan siya Jisɨs siirɨn ɨna haiburgigɨn mɨ ɨna inɨ sɨnsɨn wokmainakiyɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Mɨ Jisɨs siya nu Galili hɨriir namɨn mɨ Adi Komii siir naeyɨu mɨiyɨkɨn siir kɨrɨeya ɨni siyakar ywowɨn mɨ dimɨn taemɨn whɨekakɨm Jisɨs siya dirɨraerarɨm sɨmiir yaiya ɨna haigirɨrɨr boɨnama omom omomɨm sɨmiir. ");
INSERT INTO iws_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Mɨ siya iikam whɨekakɨm sɨmiirɨn, sɨmiir omaka yai nɨdwokai wakaeiya saiir hɨr boɨnmɨmauugɨn mɨ sɨma ɨni siir inɨg ɨiirar hainan prapraskiyɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Mɨ Jisɨs siya omɨn yɨnisɨm sapɨsap siyar naemrwɨi okwonaniyɨn Nasaret siirɨmar swokɨ am. Mɨ Jisɨs siya Judami ɨi komiiya pɨu siisiya dimɨn taemɨn tɨr karamae nwowiya ta omaka yai nɨdwokai wakaeiya saiir yapnɨnopkainam. Ɨinokɨinokɨn siya tɨriya saiir hɨriinan mɨ siya ɨni Yokwo Komiiya saiirar yokwo mwaɨngiyɨn. ");
INSERT INTO iws_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Mɨ sɨma siirɨn profet Aisaia siya wɨna yokwowa bɨdi bɨdiniyar saiir hauu mɨ siya mɨi kwɨra hɨnɨɨna boɨna saiiram hansɨrkɨn, ");
INSERT INTO iws_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Adi Komii siir naeyɨuɨn ɨni kariir tɨr nwowɨn. Mɨ siya kɨrɨe kariirɨn mɨnam hauugɨn mɨ ha nɨmbinkɨn, siir yaiwɨn kɨbiya iikamɨm sɨma sɨma sɨpiyɨmiyokmaeyamiyɨm sɨmiir boɨnmɨmauuɨm. Siya kariirɨn mɨnam nɨkropkikɨn kara ta hɨriinan yaiya iikam sɨmiirɨn hɨnɨɨna boɨnmauuɨm mɨ digworaekwowɨm uridnan kɨmiir nɨtkiyɨm mɨ kɨmiirɨn wɨ rɨrmiiya kara nwowaigɨnɨuwi mɨ iikamɨm nhwokwɨsae nwowɨm sɨmiir nhwowɨm wɨ wadɨe kara nwowaigɨnɨugi. Mɨ iikamɨm hɨkak nwowɨm sɨmiirɨn wɨ rɨrmiiya kara nwowaigɨnɨugi. ");
INSERT INTO iws_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Siya kariirɨn mɨnam nɨkropkikɨn. Ɨiya Adi Komii siya nanmaiwarkainana iikamɨm sɨmiir kara saiir boɨnmɨmauukɨn. ");
INSERT INTO iws_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Mɨ siya ha mwaɨn dɨgiyɨn mɨ yokwowa ɨna swokɨ haigɨnɨkougiya. Mɨ ɨna swokɨ hauugiya inkamɨn yokwo ɨmiir kɨgrɨraowiyɨn siir. Mɨ siya ha swokɨ ɨdwowɨn mɨ ta omaka yai nɨdwokai wakaeiya saiir nwowɨm iikamɨm sɨmiirɨn ta ɨi aiir nowomwarkaiyɨu bwakainamkɨn mɨ sɨmiir nhwowɨm siirara kaonanaekiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Mɨ siya sɨmiir boɨnki, yaiya tariinan kɨma kwawakaekiya Yokwo Komii saeya boɨna, tariinanɨn saeya tasi nɨmbiniraraowa. ");
INSERT INTO iws_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Mɨ sɨma siirɨn ɨna boɨn wadɨeyɨn mɨ sɨma naɨngwoyɨmiyok prasae bɨ kikɨnkɨm yai mɨiyɨk mɨiyɨkɨm siir yai hɨranka nɨmbiniyɨm sɨmiirsiyɨn mɨ sɨma boɨn. Tɨ yɨnisɨmɨn siya tari Josep siir yɨnisɨmkɨn, aniya? Mɨ siya krɨmiir hɨriinanargɨn mɨ siya tɨ hɨriinan yai mɨiyɨk mɨiyɨkɨm papiyankɨ haigɨm? ");
INSERT INTO iws_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Mɨ siya sɨmiir boɨnki, kara kɨmiirɨn pɨ boɨniyɨo yai kwɨra saiir yaimwokɨyaimwo aiir boɨnmauugi, inkam iikam nhɨrmi whɨndirɨraerariyɨn yɨo tɨ hɨriinan inkamɨn sasar timɨ whɨndirɨraerarna. Siyɨu hɨnɨɨnɨn Kapaneam kɨra tɨrnaniyɨn mɨ tɨ kɨriir ombud om ɨiirɨn hɨriinan siyɨu ɨiirar timɨ tɨr. ");
INSERT INTO iws_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Mɨ siya boɨn, kara kɨmiirɨn yaimwowar boɨni, iikamɨm sɨma sɨmiir omkɨ oman profet inkamɨn siir yai bɨ wakaeyoknaeikɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Wakae! Kara kɨmiirɨn yaimwokɨyaimwowa boɨni, bɨdi bɨdiniyarɨn Ilaija siya nwowa mɨ wig igabae nɨɨnga nhɨrɨm nu Isrel hɨr nwokɨm. Mɨ taka ɨiya naokɨ bɨ swokɨ kɨnmɨmɨnka bɨewiiyɨm whwoɨm haɨmii (3 ½ yia). Mɨ iikam whɨekakɨm tɨ nu ɨiir nwowɨm sɨma mhɨi prasae bɨ naokɨm. ");
INSERT INTO iws_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Mɨ Adi Komii siya Ilaija siirɨn ɨkɨ wig igabae nɨɨngam nu Isrel hɨr nwowɨm sɨmiirɨm bɨ nɨkropkikɨn. Nɨɨngaka. Siya siirɨn, wig igabae nɨɨnga ɨrua om Sarefat nu Saidon hɨrana saiiram nɨkropkikɨn nae saiir hauu aeyɨm. Mɨ ya saeya nu Isrel hɨran wig rani. ");
INSERT INTO iws_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Mɨ profet Ilaija siir ɨiya ɨriipɨ hɨriinan mɨ siya iikam nhɨrɨm nu Isrel hɨranɨm paowaigɨ pɨskomkopouwɨm, sɨmiir nwɨrni mɨiyɨk bɨ nwokɨn. Nɨɨngaka. Mɨ nɨɨnga nwokiyɨn Neman sasargɨn. Neman siya Isrelan tani, siya Sirian inkamkɨn. Jisɨs siir yaiya hɨriinanka. ");
INSERT INTO iws_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Mɨ ta ɨiya iikam whɨekakɨm sɨma ta omaka yai nɨdwokai wakaeiya saiir hɨr nwowɨm sɨma ta yai aiir wakaekiyɨm mɨ sɨma bɨdi yɨnoknɨnkɨnkiyɨm ta yaiya Jisɨs siya sɨmiirar hɨuriyɨu boɨnkɨn. Mɨ sɨmiir mhɨi kwoɨnɨm haugɨhauga asi whwiyɨekikɨm. ");
INSERT INTO iws_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Mɨ sɨma ha nɨnsiin okwokwokiyɨm mɨ Jisɨs siirɨn ɨna kiyaiwowɨtnaniyamɨn omɨn siir yaba hɨriir. Mɨ sɨma siirɨn mhɨuisɨm whɨrɨn sɨmiir om ɨeya nwowɨn mɨ sɨma siirɨn hɨrankɨ nɨtkiigiyɨm tɨrkɨm. ");
INSERT INTO iws_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mɨ sɨma dɨg bɨ nwokɨm whɨsarii rani, Adi Komii siyar nɨkɨdukɨn sɨmiir kwoɨnɨm mɨ sɨma asi nɨdidkɨm. Mɨ Jisɨs siya ɨni sɨmiir bopwowar yapnamɨn. Mɨ siya ɨna yɨugusamɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Mɨ Jisɨs siya om komii Kapaneam nu Galili hɨranɨn siir namkɨn. Mɨ Juda sɨmiir ɨi komiiya pɨu siisiya dimɨn taemɨn tɨr karamae nwowiya siir iikam nhɨrɨm saiirar mɨ owomwarkaiyɨugɨn Adi Komii siir yai aiir. ");
INSERT INTO iws_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mɨ sɨma ta siir yai aiir wakaeyɨm mɨ sɨma ɨni hindara yanaakiyɨm. Dimusi rani, siir yaiya inkamɨn inɨg komiigakɨn siir hɨriinan boɨnkɨn ta yaiya kɨrɨe komiigaka. ");
INSERT INTO iws_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mɨ omaka yaimɨn dimɨn nɨdwokai wakaekiya, inkam nwɨrɨn yɨu biyɨekakɨn hɨr nwokɨn. Mɨ siya ɨna kauwok boɨnamnankiyɨn, ");
INSERT INTO iws_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","hɨe! Jisɨs om Nasaretanɨn, kɨra dimu dimɨn tɨram nɨtkɨn, ha? Kɨra krɨmiir nonkwonɨɨnwomwɨɨrnɨnkɨnam nɨtkɨn, ha? Kara kɨriirɨn ɨna nɨnoknɨnkɨnɨn kɨrargɨn Adi Komii siir yɨnisɨmɨn dimɨn whɨrkɨ kɨmbu karamae nwowɨn mɨ iikam whɨekakɨm krɨmiir nanmaiwarkainanɨn. ");
INSERT INTO iws_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Mɨ Jisɨs siya ɨgao yai tɨ yɨu biyɨe siir yɨkwao boɨnki, kɨriir yaiya tɨ tanki! Mɨ yɨu biyɨeyɨn siya tɨ inkam ɨiirɨn iikam whɨekakɨm sɨmiir whwonkam ɨdar haigi ɨrɨmtɨogigɨn mɨ siya ɨna yamɨn. Mɨ siya siir bɨ nonkwonɨɨnwomwɨɨrnɨnkɨngigɨn. ");
INSERT INTO iws_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mɨ iikam whɨekakɨm sɨma hɨriinan kɨgiyɨm mɨ sɨma ɨni hindara yanaakiyɨm. Mɨ sɨmasɨmarɨn hɨnɨɨna yɨmboɨn amboɨn, ae! Ta yai hɨnɨɨna saeya panɨɨn panɨɨn yaiga. Mɨ siya yɨu biyɨeyɨm sɨmiirɨn wɨ inkamɨn kɨrɨe komiigakɨn mɨ inɨgak ɨkɨn mɨ siir hɨriinan boɨnmɨmauuwi. Mɨ sɨma hɨriinan wakaeyɨm mɨ sɨma tɨ inkam ɨiirɨn ɨna haiburgigɨm mɨ sɨma ɨna yamɨm. ");
INSERT INTO iws_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Mɨ tɨ dimɨn hɨriinanɨn Jisɨs siya tɨrkiyɨn ɨna haigirɨrɨrkiyɨn, omom omom ɨmiirɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Mɨ Jisɨs siya ta omaka yaimɨn dimɨn nɨdwokai wakaeiya saiir haiburgigɨn mɨ Saimon siir omaka aiir yam. Mɨ Saimon siir nɨua saeya ma pɨu huua kɨniya saeya niiga. Mɨ kamɨm sɨma inɨ ɨkɨunaki Jisɨs siirɨn saiir ninɨ kɨgniyam. ");
INSERT INTO iws_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Mɨ siya ha namɨn, kɨmɨdiniya hɨiya saeya whɨna saiir kingiinar inɨ okwowɨuwɨn mɨ siya ta ma huua kɨniya ɨgao yai saiir boɨnki mɨ ta ma pɨu huua kɨniya ɨna haiburgiga. Mɨ saeya bɨri kɨmɨmɨnkika saeya ɨna yɨnsiin ɨdwo sasaugiya mɨ saeya ɨni sɨmiir nae ɨmiirar swokɨ ɨnsiin dirɨraerara. ");
INSERT INTO iws_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Mɨ ɨiya bɨeyɨn nɨkiiyamki tɨbɨn, iikamɨm nomiiyaugakɨm, sɨma sɨmiir nomiiyauɨm mapai mapaigɨ niiyɨm sɨmiirɨn ɨna yɨkɨunaniyɨm, Jisɨs siirɨm. Mɨ siir ɨɨna tɨ iikamɨm makak makakɨm sɨmiir pɨu ɨmiir nonkwokiyɨm mɨ siya sɨmiirɨn ɨna yɨnɨmnɨskigiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mɨ tɨ uridyɨu bibiyɨeyɨm iikam whɨekakɨm sɨmiir hɨr nwowɨm sɨma ɨni warar yɨnkɨn amkiyɨm mɨ sɨma ɨgao yaigak hɨnɨɨna ywonamɨm. Hɨe! Kɨra Adi Komii siir yɨnisɨmkɨn. Mɨ Jisɨs siya ɨgao yaigak sɨmiir ywoki mɨ siya yai sɨmiir bɨ kɨgnɨnkɨn boɨnaikɨn. Dimusi rani, sɨma ɨna nɨnoknɨnkɨnɨm siya inkamɨn Mesaia Adi Komii siya nɨmbinɨn siya krɨmiir nanmaiwarkainanɨn. ");
INSERT INTO iws_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mɨ bɨenaɨnakarɨn siya tɨkɨ om ɨiir haiburgigɨn mɨ siya maeyauwa inkam karamaeya saiir yam, nhwo Adi Komii siirɨm kwɨsboɨnɨm. Mɨ iikam whɨekakɨm sɨma ɨna yamɨm Jisɨs siirɨm hansɨram. Mɨ ɨiya sɨma siir hansɨryɨskaiyɨn mɨ siir kwoɨnɨn kɨmɨdiniya sɨma yɨkpɨtmaiyɨm tɨ sɨmiir om ɨiir haiburgigsi, siya pɨ om whɨra namisi. ");
INSERT INTO iws_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mɨ siya sɨmiir boɨnki, kara yaiwɨn kɨbiya ɨiya Adi Komii krɨmiir Wanɨn siya digworaekwo whɨekakɨm mɨ iikam ɨkɨm, sɨmiir kɨgɨrkakana saiirɨn pɨ ɨkɨ omom omom nhɨrɨm sɨmiir mɨ boɨnmɨmauuwi. Kariirɨn Adi Komii siyar nɨkropkikɨn mɨ kara hɨriinan asi tɨri. ");
INSERT INTO iws_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Mɨ siya ha boɨn dɨgiyɨn mɨ siya ɨna haiburgigɨn sɨmiirɨn mɨ siya ɨna yamɨn Adi Komii siir yaiya saiirɨn ɨkɨ omakam, yaimɨn dimɨn, nɨdwokai wakaeiyɨm nu Judia hɨranɨm sɨmiir asi boɨnmɨmauuwamkɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Mɨ ɨigwɨra Jisɨs siya Genesaret whɨigbid hɨr nwokɨn. Mɨ iikam whɨekakɨm sɨma ha nɨtɨm, ɨni saɨkar yanɨnkɨnɨuniyɨm. Adi Komii krɨmiir Wanɨn siir yai aiir wakaeyam. ");
INSERT INTO iws_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Mɨ siya igopsɨm ɨswo sowiir kɨgi sowa whɨigbid hɨr nwowi. Mɨ kamɨm anasu haiiyɨm sɨma tɨ i ɨswo sowiir bɨdi haiburgigo. Mɨ sɨma haɨmna hɨisoki. ");
INSERT INTO iws_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Mɨ Jisɨs siya iisɨm ɨra saiir kwɨrii, ta iya Saimon Pita siirga. Mɨ siya Saimon Pita siir boɨnki siya i aiirɨn hamiisɨma wokiyopkiyɨm yaba hɨriir mɨ siya ta ikopsɨm aiir yɨdwokai boɨnmɨmauugi Adi Komii siir yai aiirɨn, iikam whɨekakɨm sɨmiir. ");
INSERT INTO iws_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mɨ Jisɨs siya yai ha boɨn dɨgiyɨn mɨ siya Saimon Pita siir boɨnki, iya whɨidopwoniya kinaniyam, kɨra mɨ kɨriir isidɨn kɨma haɨmna dɨtmai anasu kikaiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimon Pita siya ɨna yowarkɨi boɨnɨn, inkam komii ta nɨi kɨrɨeya krɨma whɨsariiyar mɨriinanaemaowikɨm, anasu whɨrmɨn whɨrmɨn bɨ swokɨ ɨigimɨmɨnkɨn. Mɨ kɨra pɨ boɨnkɨn, kara pɨ asi nɨtmai. ");
INSERT INTO iws_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Mɨ sɨma ha nɨtmaikiyɨm mɨ sɨmiir haɨmna anasu kasa bɨ nɨigikɨm mɨ haɨmnaɨn pɨ hɨriiyar pɨ inanbɨrgiyɨn. ");
INSERT INTO iws_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Mɨ sɨma sɨmiir ɨrɨpa mɨiyan kamɨm i ɨra saiir nwowɨm sɨmiirɨm kɨnkina, sɨmiir whɨnmɨriiyɨm mɨ sɨma ha nɨtɨm mɨ anasuɨm ɨna yɨskaina haigimɨmɨrkiyɨm. Mɨ i ɨso ɨni hindara iyɨmɨmɨnkiywo. ");
INSERT INTO iws_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon Pita siya hɨriinan kɨgiyɨn mɨ ogmwoɨn Jisɨs siir kingiina inɨ hɨuɨu mɨ ɨna boɨnɨn, Bɨiyan Inkam Komii, kɨra kariir haiburgik mɨ kɨra ha dam! Dimusi rani, kara dimɨn biyɨe tɨran inkamkɨn. ");
INSERT INTO iws_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Siyar mɨ kamɨm saɨkar nwowɨm, sɨma tɨ anasu whɨe komiiyɨm sɨma haiyɨm sɨmiir kɨgiyɨm ɨni hindara yanaakiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sebedi siir yɨnisɨm nwɨso Jems, Jon sowa Saimon Pita sɨma ɨrɨpa mɨi kwɨruwa mɨriigɨm. Sowa ɨriipa hɨriinan ɨni warar mɨ ɨnkɨn anaakiywo. Mɨ Jisɨs siya Saimon Pita siir boɨn, kɨra kɨpi nɨdid tɨ anasu kɨra haiyɨm, mhoɨiya kɨra iikamɨm sɨmiirɨn wɨ hɨriinan haii, kariir mhoɨiya nɨtamɨn. ");
INSERT INTO iws_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Mɨ sɨma i ɨso ha nadu hɨuwamasukuniyɨm mɨ sɨmiir digworaekwo whɨekakɨm ɨni hɨrar iyopnɨsugikɨm mɨ sɨma ɨni Jisɨs siir mhoɨiyar yamɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ɨigwɨra Jisɨs siya om whɨrɨn inkamɨn paowaigɨ pɨskomkopouɨn siya nwowɨn siir inɨ owou. Mɨ tɨ inkamɨn siir pɨua paowaigɨ bɨdi yɨnkɨnɨua mɨ ɨiya siya Jisɨs siir kɨgwɨnɨn mɨ siya ɨni Jisɨs siir ɨgmiiga whwonkam ɨda kingiinar yakai kaiyɨrou whɨnaiinamɨn. Mɨ ɨna boɨnaiyɨn, Inkam Komii kɨra naɨngwowi mɨ kariirɨn wɨ dɨg kɨrar nwowaigɨnɨugi. ");
INSERT INTO iws_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Mɨ Jisɨs siir ɨɨna ha nɨnkikiya mɨ siir yanonkwowɨuɨn mɨ siya boɨn, kara ha naɨngwowi, kɨriir ma ha dɨgi! Mɨ ta ma bɨ kɨmɨmɨnkika ɨna dɨgiya. ");
INSERT INTO iws_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jisɨs siya ɨgao yai siir boɨnki, kɨra sɨbgu mɨntarao! Kɨra wɨ inkam nwɨrni kɨpi boɨnmauu tɨ dimɨnɨn. Nɨɨngaka. Mɨ pa dam inkamɨn naemɨn kɨmiirsi nɨnkɨn ɨmiiyaeiyɨn Adi Komii siirɨm pris inkamɨn kɨmiir kaoprigi okwowiyɨn siir tinɨ boɨnmauuɨu. Mɨ kɨra Adi Komii siirɨn nae pa dɨnkɨn ɨmiiyaeki! Kɨriir pɨu wadɨe nwowa saiirsi. Mɨ yaiya krɨmiir brougae Moses siya wɨnkiya saiir hɨriinan. Mɨ tɨ kamɨm nwokɨ ɨnoknɨnkɨn wɨni kɨriir paowaiyɨm bɨdi wɨskiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mɨ dimɨnɨm Jisɨs siya tɨrɨm sɨmiir yaiya ɨna yɨniyokɨigiya. Mɨ iikam whɨekakɨm siir yai wakaenakiyɨm nɨtkɨm mɨ maɨm sɨmiir pɨu nwokaiyɨm sɨmiir warar haiswonɨskɨigiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mɨ ɨi nhɨrɨm siya maeyaua inkam karamae pɨ saiir napnɨnopkainami mɨpi nhwo hɨr ninɨ kwɨsboɨnɨuwi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Mɨ ɨigwɨr nabɨe Jisɨs siya iikam nhɨrɨm sɨmiir nɨisiimauugɨn mɨ Farisi kam ɨkɨm mɨ kamɨm siyɨu komii komiiyɨm sɨm nɨnoknɨnkɨniyɨm sɨma hɨr warar nɨnkɨn ɨdwokɨm. Sɨma tɨ omom omom whɨekakɨm nu Galili mɨ nu Judia mɨ om komii Jerusalem sɨmiir hɨrankɨm nɨtkɨm. Mɨ Bɨiyan Inkam Komiiyɨn siir kɨrɨeya ɨni Jisɨs saɨkar nwowa, makak iikamɨm sɨmiir haiswonɨskɨiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kam nhɨrɨm sɨma ha nɨtɨm, inkam nwɨrɨn ɨga ɨɨna nɨnsɨmsɨrɨunɨnkɨnɨn siirɨn hɨigakar hainamɨn, sɨma siirɨn omakanau hɨriir hainɨnopkainamɨm tɨrkɨm, Jisɨs siir ɨgmiiga ninɨ haigɨnɨuɨm. ");
INSERT INTO iws_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Dimusi rani, ɨni iikamkɨ yɨnkɨnɨu waowɨm, sɨma ɨni siyɨuɨm yɨnkɨnyaeyaonamɨm, tɨ makak inkamɨn siir hainɨnopkainamɨm. Mɨ sɨma siirɨn akoua hɨriir hainaiinam mɨ sɨma maeyau kwɨra saiir yamɨ ɨinɨkinɨɨngi. Ta hɨiya saiir dɨgar mɨ tɨ inkamɨn ta hɨi aiir whwonkaiyɨn sɨma siirɨn hɨigakar yonkwosiisiisnaiinam iikam ɨma nwowa maeyaua saiir bopwoniya. Mɨ sɨma Jisɨs siir whwonkam ɨda yauunɨ kikɨnɨu. ");
INSERT INTO iws_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ɨiya Jisɨs siya sɨmiir naɨngwo tɨbmii kɨrɨe saiir kɨgiyɨn mɨ siya ɨna boɨnɨn, nomiiyau, kɨriir dimɨn biyɨeyɨm kara bɨdi haiyoprimdiyɨumiigiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mɨ kamɨm siyɨu komii nɨnoknɨnkɨniyɨm mɨ Farisi kam ɨkɨm sɨmasɨmarɨn ɨna yomboɨn amboɨnɨm. Yɨpɨkɨn tɨ inkamɨn Adi Komii siir hɨriinan boɨnɨn? Inkam nwɨrkɨn bɨ swokɨ haiyoprimdiyɨumii srankɨn dimɨn biyɨeyɨm. Nɨɨngaka. Adi Komii siirarar mɨiga. ");
INSERT INTO iws_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Mɨ sɨmiir kwoɨnɨm Jisɨs siya bɨdi yɨnoknɨnkɨnkiyɨm mɨ siya sɨmiir boɨn, dimugɨn? Tɨ hɨnɨɨn kwoɨnɨn kɨmiir waraur nwokaiyɨn, ha? ");
INSERT INTO iws_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Pɨkɨ hɨnɨɨn dimɨn kɨrɨe ɨkɨm kara mɨrii karamae nwowiyɨm mɨ pɨkɨ hɨnɨɨn dimɨn ɨkɨm hiinsɨma nwowiyɨm kara mɨrii karame nwowiyɨm? Mɨ kara ha boɨni kɨriir dimɨn biyɨeyɨm kara bɨdi haiyoprimdiyɨumiigiyɨm ta mɨi hɨriinana ya mɨi kɨrɨe, o mɨi komii rani, aniya? Mɨ kara ha boɨnki, kɨra dɨnsiingi mɨ kɨriir hɨi aiir hainam ya mɨi komiiga, iyɨe? Mɨi komii rani, aniya? ");
INSERT INTO iws_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yaowae Adɨn nɨnomor kou hɨrankɨn nɨtɨn karargɨn. Mɨ kɨmiirɨn wɨ karar nɨisiimauuwi kɨrɨeya dimɨn biyɨeyɨm sɨmiir haiyoprimdiyɨumiigiyɨm mɨ Jisɨs siya tɨ inkamɨn ɨga ɨɨna nɨnsɨmsɨrɨuɨn siir asi boɨnkikɨn. Kara kɨriir boɨnki, kɨra dɨnsiingi! Mɨ kɨriir hɨi aiir dɨnsiin hainam mɨ kɨra pɨ kɨriir omaka damɨgusam! ");
INSERT INTO iws_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mɨ siya bɨri kɨmɨmɨnkikɨn ɨna yɨnsiin hainamɨn siir hɨiya mɨ siya ɨni iikamɨm sɨmiir whwonkam ɨdar yapnamɨn mɨ siya mwai ɨni Adi Komii siir inɨg ɨiirar hainan ap waowaowamɨn. ");
INSERT INTO iws_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Mɨ sɨma ɨna yanaakiyɨm mɨ sɨma naɨngwoyɨmiyok prasae bɨ kikɨnkɨm mɨ sɨma ɨni Adi Komii siir inɨg ɨiirar hainanprapraskiyɨm mɨ ɨna boɨnɨm, ae! Dimɨn prasae rani, tapa krɨma kwakɨgiyɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Mɨ tɨ dimɨnɨn siir mhoɨiya, Jisɨs siya napnamɨn mɨ siya kɨgi inkam nwɨrɨn omom omomi umɨr haiiyɨn siir inɨgɨn Livaikɨn, siya omaka siya nɨdwokai mɨriiya saiir hɨr nɨdwokaii. Mɨ Jisɨs siya siir boɨnki, kɨra kariir mhoɨiya wɨt. Mɨ Livai siya ha nɨnsiingiyɨn mɨ siir digworaekwowɨm ɨni hɨrar grirgɨngikɨm mɨ siya ɨni Jisɨs siir mhoɨiya yamɨn. ");
INSERT INTO iws_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Livai siya ha nɨnsiingiyɨn mɨ siir digworaekwowɨm ɨni hɨrar yɨnsiin haiburgigɨn mɨ siya ɨni Jisɨs siir mhoɨiyar yamɨn. ");
INSERT INTO iws_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Mɨ Livai siya nae komiiya ɨna dirɨraerarɨn siir omaka hɨrar, Jisɨs siiram. Mɨ kam hoɨmgakɨm omom omomi umɨr haiiyɨm mɨ kam nhɨr ɨkɨm, sɨma warar yɨnkɨn ɨdwokai ae sowakan. ");
INSERT INTO iws_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mɨ Farisi kamɨm mɨ kamɨm siyɨu komii komii nɨnoknɨnkɨniyɨm sɨma Farisi sɨmiirar isid whɨrkɨn. Kamɨm Jisɨs siir kɨgna mɨriiyɨm, sɨmiirɨn hɨnɨɨna yɨniinansao boɨn, kɨma warɨ kamɨm omom omomi umɨrɨm yaeya swokɨ ɨnkɨn haiiyɨm mɨ kamɨm siyɨu biyɨe tɨriyɨkɨm, nae op mɨn sɨmaka dimusi nɨdwokai ae kwiyae, ha? ");
INSERT INTO iws_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Mɨ Jisɨs siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨn, inkamɨn ma karamaeyɨn, yɨo siya inkamɨn paowai widiyɨn siiram bɨ swokɨ amikɨn. Nɨɨngaka. Mɨ ɨkɨ makak iikamɨm pɨ sɨmasɨmar nami kamɨm paowai widiyɨm sɨmiiramɨn. ");
INSERT INTO iws_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kara inkamɨn paowai widiyɨn siir hɨriinankɨn, kara iikam mɨiyɨk mɨiyɨkɨm sɨma ha naɨngwowɨm krɨma iikam mɨiyɨkɨm sɨmiir mhɨi kwoɨn nɨnkpɨt haigi aram bɨ nɨtkɨn. Nɨɨngaka. Kara iikam biyɨeyɨm hɨnɨɨna naɨngwowɨm krɨma mɨiyɨk rani, sɨmiir mhɨi kwoɨn ɨmiir nɨnkpɨt haigiyɨm nɨtkɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Mɨ Ferisi iikam nhɨrɨm sɨma Jisɨs siir boɨn, Jon siir kɨgna mɨriiyɨm kamɨm, sɨma ɨi kasakasa bɨ haiyaeikɨm mɨ nhwo pranaepranae bɨ kwɨsboɨnikɨm. Mɨ Farisi sɨmiir kɨgna mɨriiyɨm kamɨm yɨm ɨriipɨ hɨriinan. Mɨ kamɨm kɨriir kɨgna mɨriiyɨm, yɨm hɨriinan bɨ tɨrkɨm, yɨm sɨma nae pa mɨ aei mɨ opa pa mɨ kwiyaei. ");
INSERT INTO iws_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Mɨ Jisɨs siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨnki, kɨma ha naɨngwowi, ɨiya iikamɨm tɨ inkamɨn wig nonkwonaɨn siir wigwas nae aiiram nɨti, saiir naeyam mɨ kɨma wɨ saiir haiyaki, aniya? Nɨɨngakɨ, nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mɨ mhoɨiya iikam biyɨe nhɨrɨm sɨma nɨnkaknan nwowi siir nɨkɨunakiyɨm. Mɨ siya siir inkam inkamnanɨm sɨmiir haiburgigi mɨ taka ɨiya ya nɨkrani sɨma nae wɨ saiir haiyaki. ");
INSERT INTO iws_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jisɨs siya mɨn boɨniyɨokɨn, inkamɨn, yɨuɨs wɨn haɨmiiya saiir kɨpi kɨntɨo hai, yɨuɨs kaba saiir nɨtkɨn panɨm. Mɨ siya hɨriinan tɨri mɨ ta yɨuɨs mɨiyɨka wɨ saeya nonkwobumbuwi. Mɨ ta yɨuɨs wɨna saeya wɨ yɨuɨs biyɨeya saɨka wɨ mɨiyɨk kɨg rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Inkamɨn wain opa wraisu ɨs kaba saiir bɨ naokaiigɨn. Nɨɨngaka. Mɨ siya hɨriinan tɨri mɨ tɨ wain opa saeya niyopiinaiinii mɨ wɨ ta wraisu ɨs kaba saiir mɨmbɨmbɨrgi mɨ ta wain opa wa naokinɨnkwokwo ɨuguski. ");
INSERT INTO iws_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nɨɨngakɨ, nɨɨngakɨɨnga. Mɨ kɨra ta wain opa wraisu ɨs mɨiyɨk aiirar daokai. ");
INSERT INTO iws_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ta yaiya saiir yaimwokɨyaimwowa saeya hɨnɨɨnga. Iikamɨm Moses siir siyɨu ɨiir napiyɨm sɨma boriisopi Jisɨs siir siyɨu ɨiir swokɨ apɨm mɨ sɨma wɨ hɨnɨɨna boɨni tɨ siyɨuɨn siyɨu paii rani. Mɨ sɨma siyɨu wɨnɨn digɨumii siir haimriyɨugigɨm mɨni mɨ sɨma siyɨu bɨiyanɨn siiramar naɨngwowi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Mɨ Juda sɨmiir ɨi komii kwɨra pɨu siisiya dimɨn taemɨn tɨr karam nwowiya Jisɨs siya witnid numɨrɨm sɨmiir bopwowa naprɨokɨinamkɨn. Mɨ kamɨm siir kɨgna mɨriiyɨm witnid nhɨrɨm sɨmiir kigrimgrirgi haiyamɨm mɨ sɨma ɨna yɨinɨbromprop yonkwomromrok apaeiyamɨm. ");
INSERT INTO iws_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mɨ Ferisi nhɨrɨm sɨma boɨn mɨ kɨma Moses siir siyɨu komii ɨiir dimusi taouga dirɨraerarkɨm, tɨ dimɨnɨm Judami ɨi komiiya pɨu siisiya dimɨn taemɨn tɨr karamae nwowiya saiir haiyam mɨ kɨma sɨmiir dimusi tɨrkɨm, ha? ");
INSERT INTO iws_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jisɨs siya sɨmiirɨn hɨnɨɨna yowarkɨi boɨn, kɨma tɨ dimɨnɨn bɨiya Devid siya tɨrɨn Adi Komii siirɨn, siir bɨ nwankɨm, ɨiya siir isidɨn sɨma mhɨigɨ naowɨm mɨ sɨma naeyɨm, aniya? ");
INSERT INTO iws_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Mɨ Devid siya omaka komiiya Adi Komii siira saiir napnɨnopkainamɨn mɨ siya kɨmɨdiniya bretɨn Adi Komii siir nɨnkɨn ɨmiiyaeyɨn siir haiyɨn mɨ siya ɨna yaeyɨn. Mɨ haɨmiiyɨn, kɨmɨdiniya siir isid ɨiir hauu ae. Mɨ kɨma tari siir bɨri mwaɨnɨnoknɨnkɨnkɨm, siyɨu komii siir siyɨuɨn, hɨnɨɨn boɨnkɨn. Tɨkɨ bretɨn inkam nɨɨngakɨ bɨ swokɨ aeikɨn. Nɨɨngaka. Yɨo pris sɨmiiraraɨrgɨn. ");
INSERT INTO iws_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Mɨ Jisɨs siya ɨna swokɨ boɨn, kara Yaowae Adɨn nɨnomor kou hɨrankɨ nɨtɨn siya, ta Judami ɨi komiiya pɨu siisiya dimɨn taemɨn tɨr karamae nwowiya saiir Bɨiyan Inkam Komii asi nauunɨ onikɨn. Mɨ kɨma ɨo kariir dimusi nwowi, ha? Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mɨ Juda sɨmiir ɨi komii kwɨra pɨu siiskuwakiya, dimɨn taemɨn tɨr karamae nwowiya Jisɨs siya sɨmiir omaka yaimɨn dimɨn nɨdwokai wakaeiya, saiir yapnɨnopkainam. Mɨ siya sɨmiir yowomwarkaiyɨu. Mɨ inkam nwɨrɨn hɨr warar nɨnkɨn okɨn, siir ɨɨna ɨɨniga bɨdi yɨnsɨmsɨrɨunamɨm ɨni paeyaryaowainan ywokiyama. ");
INSERT INTO iws_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mɨ kamɨm siyɨu komii nɨnoknɨnkɨniyɨm mɨ Farisi kam ɨkɨm, sɨm Jisɨs siirɨm hɨrar kaonanae. Sɨma bɨri nɨnoknɨnkɨnkɨm, siya tɨ inkamɨn siirɨn pɨ Judami ɨi komiiya pɨu siisiya dimɨn taemɨn tɨr karamae nwowiya saiir nasi haiswo nɨskii mɨ ta hɨriinana saiirsi hɨuriiyɨu boɨnam mɨnkɨm siirɨn. ");
INSERT INTO iws_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mɨ Jisɨs siya bɨdi yɨnoknɨnkɨnɨn sɨmiir kwoɨn ɨmiirɨn mɨ siya tɨ inkamɨn ɨɨnakɨn naonɨnsɨmsɨrɨuwɨn siir boɨnki, kɨra tɨriir wɨnsiin apnani. Mɨ tɨkɨ inkamɨn siya ɨna inɨ okwowɨuwɨn. ");
INSERT INTO iws_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Mɨ Jisɨs siya sɨmiir boɨnki, kara kɨmiir srɨii, siyɨu komiiyɨn siya panɨɨna boɨnkikɨn, Judami ɨi komiiya pɨu siisiya dimɨn taemɨn tɨr karamae nwowiya saiirɨn? Mɨ krɨma siyɨu mɨiyɨk tɨ tɨr iyɨe? Mɨ siyɨu biyɨe tɨ tɨr, aniya? Mɨ krɨma siir tɨ haiswonɨski haigɨnɨu, ta ɨi komii aiirɨn, iyɨe? Mɨ krɨma siirɨn hɨriiyar tɨ kɨgnɨsu ao, iyɨe? ");
INSERT INTO iws_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Mɨ Jisɨs siya iikam ɨmiir kaoyokiyokɨigiyɨn mɨ siya tɨ inkam ɨiir boɨnki, kɨriir ɨɨndɨbɨn tɨ ɨnkiyɨnyɨnki. Mɨ tɨ inkamɨn hɨriinan tɨrkiyɨn mɨ siir ɨɨna ɨni wadɨeyar swokɨ okiya. ");
INSERT INTO iws_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mɨ sɨmiir kwoɨnɨm ɨni haugɨ haugar whwiyɨekikaigiyɨm. Mɨ ɨni sɨma sɨmar whrɨeboɨnamɨm mɨ krɨma Jisɨs siirɨn wɨ panɨɨn panɨɨna tɨri? Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mɨ taka ɨiya Jisɨs siya ɨna iiyamɨn mhɨuwisɨm whɨrɨn siir, nhwo Adi Komii siiram kwɨsboɨnam. Mɨ ta nɨi kɨrɨeya siya ɨni hɨrar kwɨsboɨn pɨrkɨnkaiyɨn, Adi Komii siiram. ");
INSERT INTO iws_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mɨ bɨeyɨn ha maskwonaidniyakwokɨn mɨ siya kamɨm saɨka mɨriiyɨm sɨmiiram yɨkɨugi mɨ siya tɨ kam ɨuurnwɨso sɨmiir yɨmbin. Mɨ siya sɨmiir inɨgɨm ɨna dap haigɨnɨuɨm aposel. ");
INSERT INTO iws_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Sɨmiir inɨgɨm hɨnɨɨn hɨnɨɨngɨm. Mɨ Saimon siir inɨgɨn Pita yokdap haigɨnɨu mɨ siir nomousɨmɨn yɨo Endrugɨn mɨ nhɨrɨm yɨm sɨm inɨgɨm hɨnɨɨn hɨnɨɨngɨm Jems, Jon, Filip mɨ Bataromiu. ");
INSERT INTO iws_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu, Tumas mɨ Jems Alpiasni yɨnisɨmɨn mɨ Saimon siir inɨg whɨrɨn Selot. Tɨ inɨg Selotɨn siir yaimwokɨyaimwowa hɨnɨɨngɨn mɨiya siya mɨriiya bɨ mɨrii kikrɨpikɨn. ");
INSERT INTO iws_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, Jemsni yɨnisɨmɨn mɨ Judas Iskariot inkamɨn wɨr Jisɨs siir napwouwɨn siir sau omomni. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Mɨ siya ha dɨgikɨn mɨ Jisɨs siya ɨni sɨmakar yɨnkɨn apniyamɨn mɨ siya maeyau hɨkmainana saiir yokwo iikam isid whɨekakɨm sɨmakar. Mɨ iikam whɨekakɨm nu Judianɨm mɨ om komii Jerusalem, an ɨkɨm mɨ omom om komii Taia mɨ om komii Saidon sowiir hɨriir wainam ɨkɨm. Whɨigbid whɨigbida wainamɨm, sɨmiir hɨran iikamɨm sɨma warar yɨnkɨn ɨt. ");
INSERT INTO iws_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Mɨ sɨma siir yai aiir wakaeyam nɨtkɨm mɨ siya sɨmiir ma ɨmiir mɨ haiswonɨmnɨskɨiyɨm mɨ iikam nhɨrɨm uridyɨu biyɨekɨ nɨnkɨnɨuwɨm sɨmiir warar. Mɨ siya ɨna haiswonɨskɨi haigɨnɨuwɨn. ");
INSERT INTO iws_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Mɨ iikam whɨekakɨm sɨma ɨɨna Jisɨs siir nonkwowɨm mɨnkɨm. Dimusi rani, siir kɨrɨeya sɨma bɨdi kɨgiyɨn, iikam whɨekakɨm makakɨm siya haiswonɨmnɨskɨigɨm. Mɨ sɨma ɨni wadɨeyar ywokiyɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Mɨ Jisɨs siya kamɨm siir kɨgna mɨriiyɨm sɨmiir kaoki mɨ ɨna boɨnkiyɨn, kɨma tɨ iikam paeprigabɨm kɨma maɨrgɨmaɨrga dwo. Dimusi rani, Adi Komii siya digworaekwo whɨekakɨm kɨma mɨriiyɨm sɨmiirar kɨgrɨraowikɨm. ");
INSERT INTO iws_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kɨma tɨ iikamɨm tariinanɨn mɨigɨ naowɨm kɨma maɨrgɨmaɨrga dwo. Dimusi rani, mhoɨiya kɨma wɨ digworaekwokɨ naokɨngugunankaii. Mɨ kɨma iikamɨm tɨ tariinan nɨnounɨnkiyɨm, mhoɨiya kɨma digworaekwo whɨekakak nwowi mɨ kɨma wɨ yaibu sɨmiir grɨnkɨn ɨei. ");
INSERT INTO iws_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kɨra iikamɨm kɨnaka nombopboɨn ae karam nwowiyɨm mɨ ɨo kɨnaka nwowiyɨm mɨ yai biyɨe kɨriir nɨgbumbu boɨniyɨn mɨ digɨumii kɨriir haimriiyɨugigiyɨn kɨra siiramɨn maɨrgɨmaɨrga dwo. Sɨma tɨ dimɨnɨn kɨriir whɨsarii tɨr tani ni kɨra tɨ Yaowae Adɨn nɨnomor kouankɨn nɨtɨn kariir siyɨu ɨiir napkɨn. ");
INSERT INTO iws_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Bɨiya krɨmiir brougae wanwiyaeyɨm, hɨriinanar mɨ tɨrkɨm, profet inkam ɨmiirɨn. Mɨ kɨra tɨ hɨriinan dimɨnɨn siya nɨmbiyami kɨra maɨrgɨmaɨrga prasae kɨpi nwo, ogmwo warar dɨnwomwokam. Dimusi rani, mhoɨiya kɨra wɨ digworaekwo mɨiyɨk mɨiyɨkak nwowi mɨ tɨ digworaekwowɨm ɨni Adi Komii siyar nikɨ onkwo ɨdwowɨm, nɨnomor kou hɨr. ");
INSERT INTO iws_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kɨma tɨ iikamɨm umɨr digworaekwokɨ naokɨngugunankaiyɨuwiyɨm mɨ wadɨe sɨbgu owɨpɨsukaeyamɨm, kɨma sɨbgu mɨntɨrao, mhoɨiya kɨma wɨ hɨk whoɨmoni hai rani. Dimusi rani, kɨma wɨ nɨnomor kouan digworaekwowɨm sɨmiir hai rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kɨma mɨntɨrao kɨma wɨ mhɨi naekak nwo rani, mhoɨiya wɨm wɨ mhɨigɨ naowi. Mɨ kɨma mɨntarao tɨ iikamɨm yaibu nɨnɨemamaɨrɨm kɨma wɨ nɨnounɨnki prasae kɨn tani. ");
INSERT INTO iws_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mɨ kɨma sɨbgu mɨntarao ɨiya iikamɨm sɨma kɨmiir nɨkboɨn praprasi mɨ bɨiya krɨmiir brougaeyɨm, ɨriipɨ hɨriinanar mɨ tɨrkɨm, profet nɨksɨsae ɨmiirɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Mɨ kara kɨmiirɨn pɨ hɨnɨɨna boɨnmauugii, iikamɨm kariir yai aiir wakaeiyɨm sɨmiiram dapiyao. Mɨ iikamɨm ɨo nhwo nanaowiyɨm, kɨma sɨmiirɨn siyɨu mɨiyɨk ɨiirar swokɨ tɨr haigɨnɨu. ");
INSERT INTO iws_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mɨ iikamɨm yaibiyɨe kɨmiir nɨkbumbuwi mɨ kɨma sɨmiirɨn yai mɨiyɨk aiirarar boɨnaigɨnɨu mɨ iikamɨm sɨma siyɨu biyɨe kɨmiir tɨrhaigɨnɨuwi mɨ kɨma sɨmiiramɨn Adi Komii siiram srɨii, siya sɨmiir whɨnkɨnsiis haigɨnɨuwɨm. ");
INSERT INTO iws_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mɨ inkam nwɨrkɨn kɨriir yaeka aiir naka tɨoki mɨ ha tɨ swokɨ ɨnkpɨt okwoki, yaeka kwɨra saiir swokɨ tɨokiyɨm. Mɨ inkam nwɨrkɨ kɨriir yɨuɨs prɨeiya saiir nɨshaii mɨ kɨra siirɨn hɨriiyar kɨgnɨnkɨn haigi. Mɨ kɨra yɨuɨs haruwa kwɨra, saiir warar swokɨ ɨnkɨn hauugi. ");
INSERT INTO iws_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mɨ inkam nwɨrkɨn dimɨn whɨram srɨii mɨ kɨra siirɨn ha hauugi. Mɨ inkam nwɨrkɨ dimɨnɨn kɨriir maeyau hɨrankɨ ninɨ hainaki mɨ kɨra ha kɨpi swokɨ boɨn, kariir swokɨ hauugi. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Dimɨnɨn kɨra naɨngwowiyɨn sɨma kɨriir tɨram mɨ kɨra sɨmiirɨn hɨriinan dimɨn ɨiirar swokɨ tɨr. ");
INSERT INTO iws_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Mɨ iikamɨm kɨriiram naɨngwowiyɨm sɨmiiram naɨngwowi, yɨo dimɨn komii rani. Mɨ Adi Komii siya kɨriirɨn wɨ hɨnɨɨna boɨn tani kɨra inkam wadɨekɨn. Nɨɨngaka. Mɨ iikamɨm dimɨn biyɨekakɨm yɨm sɨma iikamɨm sɨmiiram naɨngwowiyɨm, sɨmiiramar naɨngwowikɨm. ");
INSERT INTO iws_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mɨ iikamɨm siyɨu mɨiyɨk kɨriir tɨriiyɨm mɨ kɨra sɨmiirɨn siyɨu mɨiyɨk mɨ tɨri, yɨo dimɨn komii rani mɨ Adi Komii siya kɨriirɨn wɨ hɨnɨɨna boɨn tani, kɨra inkam wadɨekɨn. Nɨɨngaka. Mɨ iikamɨm dimɨn biyɨekakɨm yɨm sɨma ɨriipɨ hɨriinanar mɨ tɨrikɨm. ");
INSERT INTO iws_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mɨ kɨriir dimɨnɨn inkam nwɨrni hauugi, hindara haisasae mɨriinakiyam, siya kariirɨn wa swokɨ hauuwi, yɨo tɨriigɨnɨn yɨo dimɨn komii rani, Adi Komii siya kɨriirɨn wɨ yaigak saiirsi nwo rani. Nɨɨngaka. Mɨ iikamɨm dimɨn biyɨekakɨm yɨm sɨma iikamɨm dimɨn biyɨekakɨm sɨmiir dimɨn ɨmiirar mɨ hauu mɨriisasaeikɨm mɨpa swokɨ hainani. Mɨ yɨm sɨma ɨriipɨ hɨriinan dimɨn ɨmiirar mɨ ɨngigir haiigɨm. ");
INSERT INTO iws_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nɨɨngaka! Kɨra iikamɨm ɨo kɨnakar nwowiyɨm sɨmiiram dapiyao mɨ sɨmiirɨn siyɨu mɨiyɨkar timɨ tɨr. Mɨ dimɨnɨn hindara haisasae mɨriiyɨn, siirɨn haiyɨm kɨpi swokɨ aɨngwo. Nɨɨngaka. Mɨ kɨra hɨriinan tɨri mɨ Adi Komii siya kɨriirɨn wɨ dimɨn mɨiyɨk mɨiyɨk ɨmiira hauuwi. Mɨ kɨra wɨ Adi Komiiyɨn nɨnomor kouanɨn siir yɨnisɨmkɨɨn nwowi. Dimusi rani, Adi Komii siya ɨkɨ iikam bibiyɨeyɨm siirɨm naɨngwo karam nwowiyɨm sɨmiiramar naɨngwobunaekɨn. Mɨ wɨm kɨma hɨriinanar timɨ tɨr. ");
INSERT INTO iws_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mɨ kɨma sɨmiiramɨn Adi Komii siya naɨngwobumbuwa saiir hɨriinanar timɨ aɨngwobumbu. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Mɨ kɨma iikamɨm sɨmiirɨn kamɨm yai hɨdiyɨm sɨmiir hɨriinan hɨd karamae nwowi mɨ Adi Komii krɨmiir Wanɨn siya kɨmiirɨn wɨ mɨ hɨd rani. Nɨɨngaka. Mɨ kɨma iikamɨm sɨmiir dimɨn biyɨeyɨm sɨmiir haiyoprimdiyɨumiigi mɨ Adi Komii siya kɨmiir dimɨn biyɨeyɨm sɨmiirɨn wɨ hɨriiyar mɨ haiyoprimdiyɨumiigii. ");
INSERT INTO iws_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mɨ kɨma digworaekwowɨm iikamɨm sɨmiir hauuwi mɨ Adi Komii siya digworaekwo kɨmiir wa mɨ iyopkɨiyɨuwi mɨ siya wɨ yaeya digworaekwo mɨiyɨk whɨekak nhɨrɨm warar swokɨ ɨnkɨn iyopkɨiyɨugi kɨmiirɨn. Mɨ kɨma tɨ hɨnɨɨn dimɨnɨn siir hauugɨn iikamɨm sɨmiir. Mɨ Adi Komii siya kɨmiirɨn wɨ tɨ hɨriinan dimɨn ɨiirar swokɨ hauuwi. ");
INSERT INTO iws_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Mɨ Jisɨs siya boɨniyɨo yaiya kwɨra boɨn sɨmiirɨn, inkam nhwokwɨsae nwɨrɨn, siya wɨ inkam nhwokwɨsae nwɨrɨn siir swokɨ ɨisiisiimauu ap rani. Nɨɨngaka. Mɨ siya hɨriinan tɨri mɨ sowa nwɨsaɨrarɨn wɨ ɨeyar napnatkaigai swonami. ");
INSERT INTO iws_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Yɨnisɨmɨn ɨkɨ nɨnoknɨnkɨnam namiyɨn, siya inkamɨn ɨkɨ siir nowomwarkaiyɨuwiyɨn siir nɨnoknɨnkɨn aiir bɨri swokɨ haiburikɨn. Nɨɨngaka. Mɨ ɨiya yɨnisɨmɨn siya nɨnoknɨnkɨn komiigak nwowi mɨ mhoɨiya siya wɨ inkamɨn siir nowomwarkaiyɨuwiyɨn wɨ siir hɨriinana swokɨ owi. ");
INSERT INTO iws_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Mɨ kɨra paeka sɨma kɨriir nomiiyauwɨn siir nhwo ɨiir nwowa saiir dimusi boɨnkɨn mɨ kɨra warɨ paemɨr komiiya saiir bɨri kɨgɨn kɨriir nhwo ɨiir nwokaiya, aniya? ");
INSERT INTO iws_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Mɨ kɨra, kɨriir nomiiyauwɨn siirɨn panɨɨn panɨɨna nɨnoknɨnkɨnkɨn? Nomiiyau, kara paekasɨma kɨriir nhwo siir nwowa saiir haiyam mɨni. Mɨ kɨra paemɨr komiiya kɨriir nhwo ɨiir nwowa saiir bɨri nɨnoknɨnkɨnkɨn, aniya? Kɨra nɨksɨsaeyan inkamkɨn! Bɨiyɨn kɨra, kɨriir nhwo ɨiir nwowa paemɨr komiiya saiir tikɨ hai. Mɨ kɨriir nhwowɨn wadɨe nwowi mɨ mhoɨiya kɨra paekasɨma kɨriir nomiiyauɨn siir nhwo ɨiir nwowa saiirɨn wɨ hanɨɨngɨ haii. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Pae mɨiyɨkɨn siya nae biyɨe bɨ budikɨn. Mɨ ɨriipɨ hɨriinan pae biyɨeyɨn siya nae mɨiyɨk bɨ budikɨn. ");
INSERT INTO iws_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ɨiya inkamɨn siya bɨdi kɨgnɨnoknɨnkɨnɨn tɨ paenid hɨnɨɨnɨn tabgɨn o amka. Inkamɨn amɨn nɨo siir hɨranka bɨ nɨrkuuwigɨn. Mɨ inkamɨn tabnidɨm pae twaa siir hɨranka bɨri whɨnaigɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Iikamɨm paenankɨm. Mɨ inkamɨn kwoɨn mɨiyɨkakɨn, siya mɨi mɨiyɨk mɨriiyɨn mɨ inkamɨn kwoɨn biyɨekakɨn yɨo wɨ mɨi biyɨe mɨrii. Tɨ hɨnɨɨn dimɨnɨm. Yai aeya boɨnɨnkɨiigiyɨm mɨ kɨma dɨnoknɨnkɨnki tɨ inkamɨn siir mhɨi kwoɨnɨm tɨ dimɨn hɨnɨɨnɨn bɨdi yɨnkɨnɨukikaiyɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Mɨ kɨma kariirɨn hɨnɨɨna dimusi nɨkɨuwi, Bɨiyan Inkam Komii Bɨiyan Inkam Komii mɨ kɨma kariir yai wakaeyokna karamae dimusi nwowi? ");
INSERT INTO iws_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Yɨpɨkɨ iikamkɨm kariir yai aiirɨm nɨtɨm mɨ kariir yai aiir wakaeyam nɨtɨm. Mɨ ha wakaeyoknaɨm, tɨ iikam hɨnɨɨnɨm yɨm hɨnɨɨngɨm. ");
INSERT INTO iws_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Tɨ iikamɨm yɨm sɨma tɨ inkamɨn omaka mɨriiyɨn siir hɨriinankɨn. Bɨiya siya ɨe komii ɨiir ikɨ opnaiinam mɨ yɨnɨm ɨna inansiingiyɨm mɨ op komiiyɨn siya ha nɨunaniyɨn mɨ owɨe komiiyɨn ha mɨ aikinani mɨ ta omaka gobmi wanmi bɨ swokɨ kɨnmɨmɨnka. Nɨɨngaka. Dimusi rani, siya omaka mɨiyɨk bɨdi sɨbgu mɨriiyɨn. ");
INSERT INTO iws_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mɨ inkamɨn kariir yai bɨdi wakaeyɨn. Mɨ siya bɨri wakaeyoknakɨn mɨ yɨo ɨni tɨ inkamɨn ɨe ɨda haɨmbwaenaeiyɨn mɨ ɨe mɨ sɨbgu prɨigi karamae nwowiyɨn, ɨni siir hɨriinan ywowɨn. Mɨ mhoɨiya op komiiyɨn ha nakiinamainiyɨn mɨ ɨni omaka aiirar kaihɨomai namiyamɨn. Jisɨs siya sɨmiirɨn hɨriinan boɨnkɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisɨs siya ha boɨn dɨgiyɨn iikamɨm sɨmiirɨn mɨ siya sɨmiir haiburgigɨn mɨ om Kapaneam hɨriir yɨmbiyam. ");
INSERT INTO iws_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mɨ nu Rom hɨran sauan isidɨn sɨmiir bɨiyan inkamɨn siya, siir mɨiyan inkamɨn siirɨma naɨngwonanaeikɨn mɨ siya niiya ma komiika, siya nao kingiina nwokɨn. ");
INSERT INTO iws_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tɨ sɨmiir bɨiyan inkamɨn siya Jisɨs siir yai bɨdi ikɨ wakaeyɨn mɨ siya ɨkɨ Juda sɨmiir bɨiyan inkamɨm sɨmiir yɨkropki sɨma Jisɨs siir nɨkɨunakiyɨm. Mɨ siir mɨiyan inkamɨn siir haiswonɨski haigɨnɨuwɨm. ");
INSERT INTO iws_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Mɨ sɨma Jisɨs siir hɨriir nɨmbiyamɨn mɨ kɨmɨdiniya sɨma yɨkɨuwɨrwɨrna siirɨn. Tɨkɨ inkamɨn siir bɨiyan inkamɨn siya inkam biyɨekɨ mɨ ɨuwi. Nɨɨngaka. Inkam wadɨe ɨeyargɨn mɨ kɨra siirɨn sɨbgu tɨrhaigɨnɨu. ");
INSERT INTO iws_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Siya Juda krɨmiir iikamɨm sɨmiiramar naɨngwokwonanaeikɨn mɨ krɨmiir omaka yaimɨn dimɨn nɨdwokai wakaeiya saiirɨn siyar mɨriiga. ");
INSERT INTO iws_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Mɨ sɨma ta yaiya ha boɨndɨgiyɨm mɨ Jisɨs siya ɨni sɨmakar yɨnkɨn amɨn. Mɨ ɨiya sɨma tɨ inkam makakɨn siir omaka kingiin namwowɨuɨm mɨ bɨiyan inkamɨn siya siir nomiiyau nhɨrɨm sɨmiir yɨkropki Jisɨs siiram siyɨu hɨr napiyɨskai boɨnwɨnam. Mɨ sɨma hɨnɨɨna yaboɨni, Inkam Komii! Kɨra yakɨ prɨi ɨt, an kara inkam mɨiyɨk rani mɨ kɨra kariir omaka aiirɨn pa nɨt rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Mɨ an kara ɨriipa hɨriinan kɨriiram panɨɨnsi mɨ ɨtsi. Kara ha naɨngwowi, kɨra yaiarar boɨnki mɨ kariir mɨiyan inkamɨn pɨ wadɨe nwokɨ okiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Dimusi rani, an kara ɨni inkamɨn inɨg komiigakɨn mɨi kariir hauuwiyɨn, ɨni siir aowa ywowɨn. Mɨ an kararɨn ɨni sauan isidɨn kara kɨgrɨraowiyɨn ɨni sɨmiir kou ywowɨn. Mɨ kara ɨkɨ nwɨrni boɨnkiyɨm mɨ siya pa mɨ ami mɨ kara nwɨrniyɨn ɨkɨ hɨnɨɨna boɨnkiyɨm, kɨra wɨt mɨ siya pa mɨ ɨti mɨ kara kariir mɨiyan inkamɨn siirɨn ha boɨniyɨm, kɨra ta mɨi hɨnɨɨna saiir mɨrii mɨ siya pa mɨ mɨrii. ");
INSERT INTO iws_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Mɨ ɨi Jisɨs siya ta yai aiir wakaeyɨn mɨ siya ɨni hindara yanaakiyɨn. Mɨ siya tɨ iikam isid komiiyɨn siir mhoɨiya nwokiyɨm sɨmiir haiyɨugkaokiyɨn mɨ hɨnɨɨna boɨnki mɨ Isrel hɨran iikamɨm kara ta hɨriinan naɨngwo tɨbmii saiir bɨri kɨgɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mɨ tɨ bɨiyan inkamɨn siya nɨkropkiyɨm kamɨm sɨma ɨna swokɨ amɨm sɨmiir omaka hɨriir mɨ sɨma kɨgni tɨ siir mɨiyan inkamɨn wadɨekɨ wadɨe bɨdi swokɨ okiyɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mɨ mhoɨiya Jisɨs siya om komii whɨrɨn siir yam, siir inɨgɨn Nen. Mɨ kamɨm siir kɨgna mɨriiyɨm mɨ iikam isid komiiyɨn saɨka nɨnkɨn amkɨn. ");
INSERT INTO iws_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Mɨ ɨi siya om komii siir omwoɨs kingiin nwowamɨn mɨ iikam isid komiiyɨn sɨma tɨ isidɨn inkam wɨɨrɨn siir nɨo haigɨnamɨm sɨma om komii siir omwoɨs hɨrankɨ napnɨmbinani. Ta igabaeya saiir yɨnisɨm nwɨrkɨnwɨruwan sisiyaɨrgɨn. Mɨ om komii hɨran iikam whɨekakɨm saɨka nɨnkɨn ɨtkɨm. ");
INSERT INTO iws_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mɨ ta ɨiya Bɨiyan Inkam Komii siya saiir kɨgiyɨn mɨ siir kwoɨnɨn saiirsiyɨn naɨngwoyɨmiyok pranae bɨri swokɨ kɨnkɨn. Mɨ siya saiir boɨnki, kɨra kɨpi nou. ");
INSERT INTO iws_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Mɨ siya kingiin ha namɨn mɨ ta hɨiya inkam wɨɨrɨn siya whɨna saiir yonkwoki. Mɨ ta hɨi aiir hainamɨm kamɨm sɨma ɨni hindara yamɨkwoɨuɨm. Mɨ siya siir boɨnki, whranisɨm, kara kɨriir boɨnki, kɨra dɨnsiin okwoki. ");
INSERT INTO iws_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mɨ whranisɨmɨn nikɨ aonamɨn siya ɨna yɨnsiin ɨdwokiyɨn mɨ siya ɨna boɨnaikiyɨn. Mɨ Jisɨs siya siirɨn ɨna swokɨ boɨnkiyɨn siir apu aiiram. ");
INSERT INTO iws_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Mɨ iikamɨm sɨma asi nɨdidgɨm. Mɨ sɨma ɨna yomboɨn ɨdidnamɨm, amburii, tɨkɨ profet inkamkɨn. Mɨ sɨma ɨni Adi Komii krɨmiir Wanɨn siir inɨg ɨiirar hainanɨm mɨ sɨma boɨn, profet inkam komii nwɨrɨn krɨmiir bopwoniya tɨr bɨdi yɨmbiniyɨn, Adi Komiiyɨn bɨdi yɨmbiniyɨn siir iikamɨm sɨmiir nanmaiwarkainam. ");
INSERT INTO iws_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mɨ tɨ dimɨnɨn Jisɨs siya tɨrkiyɨn siya ɨni nu Judia siirar haigirɨrɨr boɨnamɨm mɨ nu maeyau nu Judia siir kingiin hɨr nwowɨm sɨmiir warar. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Mɨ Jon siir kɨgna mɨrii kamɨm sɨma dimɨn whɨekakɨm Jisɨs siya tɨrɨm, Jon siir boɨnmauu mɨ siya inkam nwɨso sowiirɨm boɨnki, sowa siirɨm nɨtɨm. ");
INSERT INTO iws_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Mɨ Bɨiyan Inkam Komii siirɨm yɨkropki mɨ siirɨn hɨnɨɨna tinɨ srɨiyɨu mɨ kɨra tɨ profet inkamɨn nɨtɨm boɨnɨn siya mɨ krɨma kɨriirɨm dwokwokɨn, iyɨe? Siya rani, nwɨrkɨn? ");
INSERT INTO iws_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Mɨ ɨiya sowa Jisɨs siir hɨriir nɨmbiyamo. Mɨ sowa hɨnɨɨna boɨn, Jonɨn op baptais haigɨnɨuwiyɨn krɨriirɨn siya nɨkropkikɨn kɨriirɨm nɨtɨm mɨ siya boɨn mɨ kɨra tɨ inkamɨn profet inkamɨn sɨma boɨnɨn nɨtam siya. Iyɨe? Krɨma wɨ yaeya inkam nwɨrɨm dwokwokɨn? ");
INSERT INTO iws_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mɨ takɨ ɨiya Jisɨs siya iikamɨm mapai mapaikakɨm kasaka bɨri haiswonɨskikɨn. Mɨ iikamɨm uridyɨu biyɨekakɨm ha haiswonɨmnɨskɨigi mɨ iikam nhwokwɨsae kasaka bɨri dirɨraerarkikɨn mɨ sɨma ɨna swokɨ kɨgomokiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Mɨ Jisɨs siya Jon siir kɨgna mɨrii inkam nwɨso sowiirɨn hɨnɨɨna yowarkɨi boɨn, kowa ha dam, Jon siir tinɨ boɨnmɨmauuɨu tɨ dimɨnɨm kowa kɨg namɨm mɨ kowa wakaeyɨm sɨmiir mɨ nhwo kwɨsaeyɨm ha swokɨ kaokiyɨm mɨ iikamɨm ɨga bibiyɨe nwowɨm ɨna swokɨ sɨbgu aprɨrɨramɨm. Mɨ iikamɨm paowaigɨ pɨskomkopouwɨm sɨma ɨni wadɨeyar swokɨ okiyɨm. Mɨ inkam wɨɨrɨm ɨna swokɨ ɨnsiin ɨdwowɨm mɨ inkam paeprikabɨm sɨma ɨni Adi Komii siir yokwo yaiwɨn mɨiyɨka saiirar wakaeyɨm. ");
INSERT INTO iws_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Yɨpɨkɨ inkamkɨn siya ɨo kariir nwo karamae nwowiyɨn siya ha maɨrgɨmaɨrga. Mɨ siir naɨngwo tɨbmii kɨɨna mɨ siya hɨriiyar maɨrgɨmaɨrga yokiyokɨi. ");
INSERT INTO iws_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Mɨ inkam nwɨso Jon siya nɨkropkiyo mɨ sowa ɨna swokɨ amo mɨ Jisɨs siya Jon siirɨn iikamɨm sɨmiir boɨnmauu. Mɨ siya ɨna boɨnɨn, kɨma maeyau nu siin apa saiirɨn dimu dimɨn kɨgam namkɨm? Mɨ kɨma tari au whɨrɨn opudgɨ hugswoswowɨn siir kɨgam namkɨm. Aniya? Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kɨma dimu dimɨn komii kɨgam namkɨm? Mɨ kɨma tari inkam nwɨrɨn yɨuɨs mɨiyɨk mɨiyɨk niiyɨn siir kɨgam namkɨm, aniya? Mɨ inkamɨm yɨuɨs mɨiyɨk niiyɨm mɨ dimɨn taemɨn mɨiyɨk mɨiyɨkakɨm sɨma tɨ hɨriinan inkamɨm yɨm ɨni inkam komiiyɨm nu kɨgrɨraowiyɨm sɨmiir omaka hɨrar nwowɨm. Jon siya tɨ hɨriinan inkamɨn siya rani. ");
INSERT INTO iws_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kariir boɨnmauu, kɨma dimu dimɨn kɨgam naɨngwowi profet inkam? Ɨhɨ kara kɨmiir boɨnmauuwi, siya profet inkamaɨrgɨn mɨ siya ɨni profet nhɨrɨm sɨmiir haiburɨn. ");
INSERT INTO iws_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tɨ inkamɨn Jon, Yokwo Komii saeya hɨnɨɨna boɨnkɨn siirɨn, wakae, kara inkamɨn kariir yaiya saiir boɨnmɨmauuwanɨn wɨ siir nɨkropki mɨ siya wɨ kariir bɨiyar namkwokɨni. Mɨ kariir siyɨuɨn wɨ siyar kisɨsop haigikwokɨni. ");
INSERT INTO iws_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kara kɨmiir boɨnmauuwi Jon siya inkam komiikɨn mɨ siya ɨni inkam komiiyɨm yopiigɨm naokainam ɨni sɨmiir haiburɨm mɨ tɨkɨ isidɨn ɨiya Adi Komii siya siir digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana saiir sɨma inɨg komiigag wao rani. Nɨɨngaka. Siya ɨni sɨmiir aowa ywowɨn. ");
INSERT INTO iws_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Mɨ iikam whɨekakɨm mɨ kamɨm omom omomi umɨr haiiyɨm sɨma ta Jisɨs siir yai aiir bɨdi wakaeyɨm mɨ sɨma Adi Komii siir inɨg ɨiirar hainanprapraskiyɨm mɨ sɨma ɨni siir yai aiirar wakaeyoknam mɨ sɨma op Jon siir hɨrankɨ baptais. ");
INSERT INTO iws_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mɨ Farisi kamɨm mɨ kamɨm siyɨu komii komiiyɨm sɨmiir nɨnoknɨnkɨniyɨm mɨ siyɨu mɨiyɨkɨn Adi Komii siya hauuwɨn, digɨumii siir haimriyɨugig. Mɨ Jon siya sɨmiirɨn op panɨɨnsi baptais haigɨnɨusi. ");
INSERT INTO iws_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Mɨ Jisɨs siya sɨmiir boɨnki, tɨ iikamɨm nuanɨm tapa digɨumii Adi Komii siir haimriyɨugigɨm, kara sɨmiirɨn panɨɨn panɨɨn iikam nɨmbin haigɨnɨuwi, sɨma panɨɨn panɨɨn iikamkɨm? Mɨ kara pɨ kɨmiir boɨnmauugi. ");
INSERT INTO iws_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Sɨma ɨni yɨnisɨmnan ywowɨm maeyaua nae haigɨniya sɨmiir yopii ad aka namiyɨm saiir hɨriinan. Mɨ ɨiya sɨma maeyaua nae haigɨniya saiir nwowɨm mɨ sɨma yɨnisɨm nhɨrɨm sɨmiirɨn hɨnɨɨna boɨnki. Mɨ krɨma kɨd ɨna masɨm kɨmiiramɨn mɨ kɨma mwai wao rani. Mɨ krɨma tɨsa nouuboponɨm mɨ kɨma krɨma nouuɨm pɨ boriisopi. ");
INSERT INTO iws_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jonɨn op baptais haigɨnɨuwiyɨn ha nɨtɨn mɨ nae op wain mɨnɨm ɨna haiyakiyɨm. Mɨ kɨma hɨnɨɨna boɨnkɨm, uridyɨu biyɨeyɨn ɨni siir pɨu hɨr nwowɨn. ");
INSERT INTO iws_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kara Yaowae Adɨn nɨnomor kou hɨranɨn bɨdi yɨtɨn. Mɨ kara nae op wain mɨna mɨ kwiyae aeikɨn. Mɨ kɨma boɨn, kɨgi! Tɨkɨ inkamɨn siya hunan naeikɨn. Mɨ siya waina mɨ kwiyaeikɨn. Tɨkɨ inkamɨn kamɨm omom omomi umɨr haiyɨm mɨ kamɨm dimɨn biyɨekakɨm sɨmiir nomiiyaugɨn kɨma hɨnɨɨna boɨnkɨm. ");
INSERT INTO iws_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Iikamɨm Adi Komii siir siyɨu ɨmiir napɨm mɨ iikam nhɨrɨm sɨma hɨriinan kɨgiyɨm mɨ sɨma ɨna yaɨngwokiyɨm Adi Komii siir siyɨuɨn mɨ siir yaiyɨm sɨma wadɨekɨ wadɨe kɨɨngɨm. Jisɨs siir yaiya hɨriinanka ɨni dɨg ywokiya. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mɨ Farisi inkam nwɨrɨn Jisɨs siirɨm yɨkɨugi nae siir omaka hɨr nɨdwokai aeyɨm mɨ siya ɨna iiyamɨn mɨ nae ɨni saɨka inɨ ɨdwokai aeyɨuɨn. ");
INSERT INTO iws_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mɨ wig ɨra dimɨn biyɨekaka tɨ om ɨiir nwoka. Saeya wakaewɨn Jisɨs siya Farisi inkam nwɨrɨn siir omaka hɨr naei. Mɨ ta wiga saeya wa mobɨn pɨuii mɨiyɨkakɨn ɨra hai mɨ saeya ɨna yɨta. ");
INSERT INTO iws_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mɨ wa mobɨn ha hainaniyɨn mɨ saeya Jisɨs siir ɨgmii kingiin ha ninɨ ɨdwowɨua mɨ saeya ɨna youa. Mɨ saiir ouwobɨm ɨni siir ɨga aiirar yaunɨ hougɨn ɨuɨm. Mɨ ɨni saiir mwowan kana saiirar yɨinak whwosɨnkiya. Mɨ ha nɨinak dɨgiya ɨni siir ɨgrɨb ɨiirar yankabmamaɨra. Mɨ saeya hɨriinan tɨr dɨgiya mɨ wa ɨni siir ɨga aiirar iyopa. ");
INSERT INTO iws_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mɨ tɨ Farisi inkamɨn Jisɨs siir nɨkɨuna aeyɨn nae, siya tɨ dimɨnɨn siir kɨgiyɨn mɨ siya hɨnɨɨna yaɨngwo mɨ tɨ inkamɨn siya profet inkam kɨɨngɨnɨuwi mɨ siya pa nɨnoknɨnkɨni ta wiga ɨɨn siir nokwowa saiirɨn mɨ saiir siyɨu ɨiir warar. Ta wiga saeya dimɨn biyɨe tɨran wiga. ");
INSERT INTO iws_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Mɨ Jisɨs siya hɨnɨɨna boɨn, saimon, kara yai nhɨrɨm kɨriir boɨnmauuwam mɨni. Mɨ Saimon siya boɨn, inkamɨn iikam nowomwarkaiyɨuwiyɨn kɨra kɨriir yaiyɨm ha boɨnki. ");
INSERT INTO iws_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Mɨ Jisɨs siya boɨn, inkamo nwɨsa nwowi sowa umɨrɨm hindara nikɨ prɨihainaniko inkam nwɨrɨn siir hɨrankɨn. Mɨ nwɨrɨn paeyarɨm ɨuur mɨ nwɨrɨn paeyarɨn hara mɨ hai. ");
INSERT INTO iws_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Sowa tɨkɨ umɨr ɨiir swokɨ hauukɨiyɨu dɨg nwo rani. Mɨ tɨkɨ inkamɨn siya ɨna kisɨna boɨnɨn, kowa umɨr kariir kɨpi swokɨ hauukɨiyɨu, yɨo dimɨn komii rani. Yɨpɨkɨ sowiir nwɨrkɨ wɨ maɨrgɨmaɨrga komiigak nwowi tɨ inkamɨn siirɨm? ");
INSERT INTO iws_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Mɨ Saimon siya hɨnɨɨna yowarkɨi boɨn, kariir kwoɨnɨn hɨnɨɨna naɨngwowi tɨ inkamɨn umɨr komii haiyɨn wɨ siyar nwowi maɨrgɨmaɨrga komiigakɨn. Jisɨs siya boɨn, wa kɨriir yaiya kaimwoka. ");
INSERT INTO iws_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Siya ha boɨn dɨgiyɨn, Jisɨs siya ta wig aiir kwakaowɨn mɨ siya Saimon siir boɨnki, kɨra ta wiga tɨr nwowa saiir kɨgi. Kara kɨriir omaka napnɨnopkainaniyɨn mɨ op kariir ɨga aiir hɨisokɨm bɨ swokɨ hauugɨn. Nɨɨngaka. Mɨ ta wiga saeya kariir ɨga saiir ouwob aiirar hɨisoka mɨ ɨni saiir kan aiirar yɨinak waisɨnkiya. ");
INSERT INTO iws_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mɨ ɨiya kara kɨriiram nɨtɨn, kɨra kariir bɨ nankabmamarwɨnkɨn. Nɨɨngaka. Karar napnɨnopkainaniyɨn mɨ saeya ɨni kariir ɨgrɨb ɨiir yankabmamarnanaeya. ");
INSERT INTO iws_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mɨ kɨra wa pɨuii mɨiyɨkakɨm kariir mwo bɨri swokɨ aokɨn haigɨnɨugɨn. Nɨɨngaka, ta wiga saeya wa mɨiyɨkni saeyar hɨisok haigɨnɨugɨn kariir ɨga. ");
INSERT INTO iws_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kara kɨriir boɨnki, saeya kariirɨmar naɨngwo kɨɨni. Ta wiga saeya aknaɨnan nɨisiimauuga iikam whɨekakɨm sɨmiir. Dimusi rani, saiir kwoɨn komiiyɨn kariiramar naɨngwo kɨɨnga mɨ kara saiir dimɨn biyɨe biyɨe whɨekakɨm sɨmiir asi haiyoprimdiyɨumiigi swokikɨm. Mɨ kara inkamɨn dimɨn biyɨe sɨm tɨrɨn siir haiyoprimdiyɨmiigi, tɨ inkam hɨriinanɨn siya kariiramɨn haɨmiisɨma naɨngwowi. Mɨ siya ta yai aiir ha boɨn dɨgiyɨn. ");
INSERT INTO iws_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Mɨ Jisɨs siya wig aiir boɨnki, kara kɨriir dimɨn biyɨe ɨmiir bɨdi haiyoprimdiyɨumiigiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Mɨ iikam nhɨrɨm ta hɨiya siya nɨdwokaiya saiir nwowɨm sɨma sɨma yomboɨn amboɨnɨm Yɨpɨkɨ siya pɨ krɨmiir dimɨn biyɨe biyɨeyɨm pɨ sɨmiir haiyoprimdiyɨumiigii? ");
INSERT INTO iws_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mɨ Jisɨs siya ta wig aiir boɨnki, kɨriir naɨngwo tɨbmiiya kɨriir dimɨn biyɨe biyɨeyɨm saeyar haiyoprimdiyɨumiigi, kɨra ha dam mɨ kɨriir mhɨi kwoɨnɨm hiinsɨma dwonam. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Mɨ mhoɨiya Jisɨs siya om komii komii ɨkɨm mɨ omisɨsɨm ɨkɨm sɨmiir hɨriir yapnam. Siya Adi Komii siir yaiwɨn kɨbi aiir boɨnmɨmauugɨn ɨiya Adi Komii siya digworaekwo whɨekakɨm nuanɨm sɨmiir kɨgɨrkakana mɨ kam ɨuur nwɨso ɨni saɨkar yɨnkɨn amɨm. ");
INSERT INTO iws_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Mɨ wig nhɨrɨm bɨiya Jisɨs siya haiswonɨskiyɨm uridyɨu biyɨekakɨm mɨ makak makak ɨkɨm sɨma saɨka yɨnkɨn apnam. Ɨra Mariaka, Makdalanka. Bɨiya Jisɨs siya uridyɨu biyɨeyɨm saiirɨn ɨriiyar nwɨsa haiswonɨski. ");
INSERT INTO iws_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joana saeya inkam nwɨrɨn Susa inkam komiiyɨn Herot siir yaimɨn dimɨn wɨniyɨn siir wig aeya mɨ Susana saeya mɨ wig nhɨrɨma sɨma ɨni saɨka yɨnkɨn amɨm. Tɨ wigɨm sɨma Jisɨs mɨ kamɨm siir kɨgna mɨriiyɨm sɨmiir nae digworaekwo ɨmiir whɨndiraerar hauu aekɨm sɨmiir yapayapa umɨr ɨmiirar. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Iikam nhɨrɨm ha nikɨ woknaniyɨm om komii komii nhɨrɨm sɨmiir hɨrankɨn, Jisɨs mɨ iikam whɨekakɨm ha nahaɨngiriyɨuniyɨm. Mɨ Jisɨs siya boɨniyɨo yai kwɨra sɨmiir boɨn, ");
INSERT INTO iws_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Inkam nwɨrɨn witnidɨm siir numɨr hɨr nɨtkɨnɨm namkɨn mɨ siya ha nonkwo krɨmkrɨnkɨi ɨtkɨnamɨn mɨ nhɨrɨm siyɨu hɨr yamɨkɨigɨiyɨu mɨ ɨni iikamkɨm yɨnkɨn okwo brombrop namɨm mɨ ɨpiyɨn mɨnɨm sɨm yatkɨkɨn ɨdwo aenamɨm. ");
INSERT INTO iws_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Mɨ witnid nhɨrɨm maeyau siiyakaka saiir nakaiyɨm, yɨm ha whakiyɨm mɨ nuɨn opkak bɨ nwokɨn mɨ tɨ witnidɨm ɨna waiyɨugusnamɨm. ");
INSERT INTO iws_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mɨ witnid nhɨrɨm urid nɨmrɨdgakɨn siir bopwoniya nakaiyɨm, yɨm ɨni sɨma yɨisirɨmdɨnunamɨm. ");
INSERT INTO iws_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mɨ tɨkɨ witnid nhɨrɨm nu mɨiyɨkni nɨkɨiyɨm mɨ sɨma ɨni wadɨeyar whaknaiinamɨm mɨ ɨni nae hoɨmkakar budkiyɨm mɨ sɨmiir nhɨrɨm wowɨra wowɨra kamarɨm ɨriiyar ɨriiyara bud. Siir yaiyɨm ha dɨgiyɨm mɨ Jisɨs siya ɨna swokɨ boɨnkiyɨn, kɨra inkamɨn wɨɨngakaɨrgɨn ta kariir yai aiir wakae, kɨra sɨbgu daɨngworɨnu krɨpkai. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma Jisɨs siir srɨi, warɨ boɨniyɨo yaiya saiir yaimwokɨyaimwowa panɨɨnga? ");
INSERT INTO iws_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Mɨ siya sɨmiirɨn hɨnɨɨna yowarkɨi boɨnki, Adi Komii siya sɨmiir yaimwok yaimwoɨm aowa aowan yaiyɨm kɨmiir bɨdi boɨnmɨmauuwɨn, ɨiya Adi Komii siya digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana, kɨmiir bɨdi boɨnmamauuwɨn ɨkɨ boɨniyɨo yai ara kara boɨniyɨm sɨmiir nhwowɨm ɨsa kɨgɨm mɨ wɨɨnɨm ɨsa wakaeyɨm, sɨma nɨnoknɨnkɨn wao rani, tɨ dimɨn ɨiirɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Taka boɨniyɨo yaiya saiir yaimwok yaimwowa hɨnɨɨnga, tɨkɨ witnidɨn Adi Komii krɨmiir Wanɨn siir yai aeyarga. ");
INSERT INTO iws_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mɨ tɨ witnidɨm siyɨu nɨkɨiyɨm, yɨm ɨni iikamɨm Adi Komii siir yai wakaeyɨm sɨmiir hɨriinan ywowɨm mɨ mhoɨiya Setan siya ɨna swokɨ ɨtnoutnɨnkɨikiyɨm, sɨmiir naɨngwo tɨbmiini siyɨuɨn siir kikɨnokou mɨ Setan siya ha naɨngwokɨn sɨmiirɨn wɨ Adi Komii siya nanmaiwarkainaeisi. ");
INSERT INTO iws_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mɨ witnid nhɨrɨm maeyau siiyakaka saiir nɨkɨiyɨm yɨm ɨni Adi Komii siir yai wakaeyoknam mɨ sɨma ɨni maɨrgɨmaɨrga ywowɨm mɨ ta yaiya sɨmiir kwoɨna bɨ nɨngruramka sɨmiir naɨngwo tɨbmiiya komii bɨ nwoka sɨma haɨmiisɨma naɨngwo tɨbmiigɨm, ɨiya sɨmiirɨn dimɨn whɨrkɨn kɨnankɨuwiyɨm mɨ sɨmiir naɨngwo tɨbmiiya asi nɨki ɨuguski. ");
INSERT INTO iws_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mɨ witnidɨm uridɨn nɨmrɨdgakɨn siir bopwoniya nakaigaiyɨm, yɨm ɨni iikamɨm Adi Komii siir wakaeiyoknaeiyɨm sɨmiir hɨriinan yowɨm mɨ ɨiya sɨma ha napnamɨm mɨ hɨkpai hɨkpaiyɨm mɨ maɨrgɨmaɨrgaɨm umɨr digworaekwowɨm nu tɨranɨm ɨni sɨmar yɨisirɨmdɨnu waigiyɨm mɨ sɨmiir naeyɨm mɨiyɨk panɨɨnsi budsi. ");
INSERT INTO iws_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mɨ witnidɨm nu maeyau mɨiyɨk nɨkiyɨm yɨm ɨni iikamɨm Adi Komii siir yai aiir wakaeyokna nonkworɨnukrɨpkaiyɨm mɨ sɨmiir mhɨi kwoɨnɨm hiinsɨma nwowɨm ɨni sɨmiir hɨriinan ywowɨm. Mɨ sɨmiir kwoɨnɨm Adi Komii siirɨm naɨngwo tɨbmii kɨɨngɨm mɨ sɨma siir yai aiirar wakaeyokna dirɨraerar yokiyokɨiyɨm. Yɨm ɨni tɨ nae whɨekakɨm numɨran sasaeyɨm wai sɨbgu okiyɨm sɨmiir hɨriinan ywowɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Mɨ inkamɨn sɨma yɨukɨdɨn nɨuyaeiyɨn siirɨn twoni bɨri higrɨnɨuwikɨn mɨ hɨi aowa bɨri haigiprakaiigɨm. Nɨɨngaka. Siya romiyasɨn bopwoniya nwowɨn siir ninankɨigɨn. Mɨ iikamɨm sɨma omaka hɨriir napnɨnopkainami mɨ sɨma pɨ pae aiirar kɨgami. ");
INSERT INTO iws_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tariinanɨn dimɨn nhɨrɨm aowa aowa nwowɨm mɨ sɨma mhoɨiya wɨ idowɨiyar nɨmbiyami. Mɨ digworaekwo nhɨrɨm inkamkɨ higrɨnɨuɨm mɨ mhoɨiya wɨ Adi Komii siyar haigɨnki idowɨiya mɨ iikamɨm sɨma siirɨn wa kɨgi. ");
INSERT INTO iws_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kɨma mɨntarao mɨ kɨma yaiyɨm sɨbgu wakaeyokna. Yɨpɨkɨ inkamkɨn nɨnoknɨnkɨn mɨiyɨkak nwowɨn mɨ Adi Komii siya siirɨn wɨ hɨriinan nɨnoknɨnkɨn mɨiyɨk aiirar swokɨ ɨnkɨn hauugi. Mɨ yɨpɨkɨ inkamkɨn siya kwoɨnarar naɨngwowi siir kwoɨnau hɨrar ta yai saiir nonkwowɨm mɨ ha wakaeyoknaei mɨ hɨriinan inkamɨn yai mɨiyɨkɨm siir kwoɨnau hɨrɨra nwokaiyɨm, tɨ yaiyɨm sɨmiirɨn wɨ Adi Komii siyar swokɨ hai siir hɨrankɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ta ɨiya Jisɨs siir apua mɨ siir nomousɨsɨmɨm sɨma siir kɨgam nɨtkɨm mɨ iikamɨm ɨni yɨnkɨnɨukikɨnɨm mɨ sɨma siir kingiin panɨɨnsi yamsi. ");
INSERT INTO iws_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mɨ inkam nwɨrɨn siir boɨnki, kɨriir apua mɨ kɨriir nomousɨsɨmɨm sɨma ɨni yab hɨr nokwowɨm, sɨma kɨriir kɨgam mɨni. ");
INSERT INTO iws_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mɨ Jisɨs siya ɨna yowarkɨi boɨnɨn, yɨpɨkɨ iikamkɨm Adi Komii siir yai mɨiyɨka saiirɨm naɨngwo tɨbmiiyɨm mɨ ha wakaeyoknam, yɨm tɨ hɨriinan iikamɨm yɨm kariir apu mɨ nomousɨsɨmkɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Mɨ ɨigwɨra Jisɨs siya mɨ kamɨm siir kɨgna mɨriiyɨm sɨma ɨna kwɨriinamɨm i kopsɨm ɨra saiir. Mɨ siya sɨmiir boɨnki, krɨma pɨ whɨigbid yarmiiya nami. Mɨ sɨma ɨna yamɨm. ");
INSERT INTO iws_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Mɨ isɨma ha hugainama mɨ Jisɨs siya nhwo bɨdi whwonkaiyɨn mɨ opud komii kwɨra ha hugnatmaiya mɨ opa pariiparii mɨrkɨmɨrka nɨnkɨnɨm ta i aiirɨn. Mɨ sɨma nwomainaiinamɨm pariipariisɨm. ");
INSERT INTO iws_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Mɨ kamɨm siir kɨgna mɨriiyɨm, sɨma Jisɨs siir yamɨ ɨnɨdguwɨu mɨ sɨma ɨna boɨnɨm, Bɨiyan Inkamti, Bɨiyan Inkamti, hae, nɨmbi nwomainaiinamiri. Mɨ siya ha nɨnsiin ɨdwokaiyɨn mɨ ɨo tɨ opud hɨnɨn komiiya saiir ywoki. Mɨ opud hɨnɨn komiiya ɨna dɨgiya mɨ opa ɨni mokmokwaiyar yomaikiya. ");
INSERT INTO iws_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Mɨ siya sɨmiir boɨnki, kɨmiir naɨngwo tɨbmiiya ɨni pɨnda yama? Mɨ sɨma ha nɨdidɨm mɨ ɨna yɨnaɨngwoyɨmiyokɨm. Mɨ sɨma sɨma yɨmboɨn amboɨnɨm, tɨ yɨpɨkɨn? Tɨ opud hɨnɨno sowiir boɨnkiyɨn mɨ sowa ɨni siir yai aiirar wakaeyoknakiyo. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Mɨ mhoɨiya sɨma ɨna kignaidamɨm Gegesan iikamɨm sɨmiir oma hɨriir. Tɨkɨ omɨn ɨni nu Galili siir whɨigbid yarmiiya nwowɨn. ");
INSERT INTO iws_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Mɨ Jisɨs siya isɨma saiir haiburgigɨn mɨ ha kunamɨn mɨ inkam nwɨrɨn tɨ omɨn siir hɨrankɨn, siya ɨna yɨtɨn siirɨm. Mɨ uridyɨu biyɨe nhɨrɨm tɨ inkamɨn siir nwokɨm. Ɨi haruwa rani tɨ inkamɨn siya yɨuɨs bɨri kaigɨn mɨ siya siir omaka bɨri nwowikɨn. Nɨɨngaka. Mɨ siya siyanowɨm inkam kikaiiyɨm sɨmiir nwokɨn. ");
INSERT INTO iws_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Mɨ ɨiya siya Jisɨs siir kɨgiyɨn mɨ siya ha kauwaeyɨmiyok ougiyɨn mɨ siya ogmwo ɨni siir ɨgmiiga kingiinar inɨ hɨuwɨuɨn mɨ siya ɨna kauwok boɨnkiyɨn, Jisɨs o! Adi Komii nɨnomor kouanɨn siir yɨnisɨmɨn, kɨra kariirɨn dimu tɨram mɨni? Wakae! Kɨra kariirɨn hɨk kɨpi hauu. ");
INSERT INTO iws_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Mɨ Jisɨs siya tɨ uridyɨu biyɨeyɨn siir boɨnki, siya tɨ inkam ɨiir haiburgigɨn. Ɨi kasa rani, tɨ uridyɨu biyɨeyɨn siya nonkwowɨn tɨ inkamɨn siir. Mɨ kamɨm ɨinokɨinok siir kɨgrɨraowiyɨm, sɨma siirɨn wɨeyɨnsopni (sen) mɨ tɨdop (hankap) kurɨmdɨnuwikɨm siir ɨga ɨɨn ɨmiirɨn. Mɨ siya tɨ wɨeyɨnsop mɨnɨm pɨ sɨmiirar mɨ anka bɨmbɨɨr nami. Mɨ uridyɨu biyɨeyɨn siya siirɨn maeyau siin apa nɨɨnga inkam karamaeya siirɨn pɨ hɨriir mɨ ɨnkɨn aeyokiyok nami tɨ inkamɨn siirɨn. ");
INSERT INTO iws_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Mɨ Jisɨs siya siir srɨigi, kɨriir inɨgɨn yɨpɨkɨn? Mɨ siya boɨn, kariir inɨgɨn uridyɨu biyɨe whɨekakɨm. Dimusi rani, uridyɨu biyɨe whɨekakɨm ɨni siir yanɨnkɨnɨuwɨuɨm. ");
INSERT INTO iws_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mɨ tɨ uridyɨu biyɨeyɨm sɨma ɨni Jisɨs siirɨma kauwoknanaekiyɨm, kɨra krɨmiirɨn ɨe biyɨeyɨn paekakɨn siirɨm kɨpi niyopriyɨugi. ");
INSERT INTO iws_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Hu isid komii whɨrɨn tɨ mhɨu kopsɨm whɨrɨn kingiina kwowɨn siir naekɨm. Mɨ tɨ uridyɨu biyɨe whɨekakɨm sɨma Jisɨs siirɨm asi kauwok boɨnɨnaekɨm. Kɨra krɨmiirɨn tɨ hu isid komiiyɨn siirɨm dɨkropki. Mɨ Jisɨs siya sɨmiirɨn asi kɨgnɨnkɨn amkikɨn. ");
INSERT INTO iws_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Mɨ tɨ uridyɨu biyɨeyɨm tɨ inkamɨn siir haiburgigɨn mɨ tɨ huɨm sɨmiir pɨuar yamkiyɨm. Mɨ tɨ hu isid komiiyɨn mhɨukɨu hɨrankɨ niwɨtnaniniyɨm mɨ ɨni siyapai amounana saiirar yamɨm. Mɨ sɨma ɨni ta whɨi aiirar yani amaimaiyɨuwɨm mɨ sɨma opa ha kwiyaeyɨm mɨ sɨma ɨna yaonamɨm. ");
INSERT INTO iws_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mɨ kamɨm tɨ hu ɨmiir waikaowiyɨm sɨma tɨ dimɨn ɨiir kɨgiyɨm mɨ sɨma ɨna yɨdam namɨm. Mɨ ta yaiya sɨma ɨna haigirɨrɨr boɨnama iikam whɨekakɨm hɨnda tɨndanɨm sɨmiir. ");
INSERT INTO iws_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mɨ iikamɨm sɨma tɨ dimɨnɨn siir inɨ kɨgɨu. Mɨ sɨma Jisɨs siir hɨriir nɨmbiyamɨm mɨ tɨ inkam ɨiir kɨg uridyɨu biyɨeyɨm siir bɨdi haiburgigɨm. Mɨ siya yɨuɨs bɨdi kaiyɨn mɨ siir kwoɨnɨn ɨni wadɨeya nwowɨn mɨ siya Jisɨs siir ɨgmiɨiga kingiinar nɨdwowi. Mɨ iikamɨm sɨma hɨriinan kɨgɨm mɨ sɨma ɨna yɨdidgiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mɨ iikamɨm tɨ dimɨnɨn siir kɨgnakiyɨm sɨma iikam nhɨrɨm sɨmiir boɨnmamauu siyɨuɨn Jisɨs siya haiswonɨskiyɨn tɨ inkamɨn siir. ");
INSERT INTO iws_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Mɨ iikam whɨekakɨm Gegesa hɨran nu maeyauwɨm sɨma Jisɨs siir boɨnki, kɨra krɨmiir haiburgik mɨ ha dam. Sɨma nɨdid prasae bɨ kikɨnkɨm mɨ sɨma hɨriinan asi boɨnkɨm mɨ Jisɨs siya isɨm aiir kwɨrii mɨ siya namɨm swokɨ mɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tɨ inkamɨn uridyɨu biyɨeyɨm sɨma haiburgigɨn, siya Jisɨs siirɨm kauwok boɨnanaeki, kara kɨnaka nami. Mɨ Jisɨs siya siirɨn ɨna swokɨ ɨkropkiyɨn mɨ ɨna boɨnkiyɨn, ");
INSERT INTO iws_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Kɨra kɨriir oma hɨriirar swokɨ am. Mɨ dimɨn whɨekakɨm Adi Komii siya tɨrkiyɨm sɨmiir tinɨ boɨnmamauuwɨu. Mɨ tɨ inkamɨn siya ha namɨn mɨ tɨ yaiyɨm iikam whɨekakɨm om komii siir hɨranɨm ɨni sɨmiirar boɨnmamauuwɨuwɨn dimɨn whɨekakɨm Jisɨs siya tɨrɨm sɨmiir. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Mɨ ɨiya Jisɨs siya ha swokɨ amɨn whɨigbid yarmiiya hɨriir mɨ iikam whɨekakɨm sɨma hɨrar nwowɨnɨm mɨ sɨma siirɨn ɨna boɨn maɨrgɨmaɨrga wɨnɨm. ");
INSERT INTO iws_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mɨ inkam nwɨrɨn ɨna yɨmbiniyɨn siir inɨgɨn Jairaskɨn. Siya maeyauwa ɨrɨpa yai boɨnaiya hɨuyokiyokaiya saiir bɨiyan inkamkɨn. Mɨ siya ɨgmwowɨn Jisɨs siir ɨgmiiga kingiinar inɨ hɨuɨu mɨ ɨna kauwok boɨnɨnaekikɨn, kɨra kariir omaka wit. ");
INSERT INTO iws_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Mɨ siir yɨnisɨma ɨrkɨ ɨruwaka mɨ saeya yɨnkopaka. Mɨ saiir bɨewiyɨm ɨuur whɨsko. Mɨ saeya naowamar tɨri. Mɨ Jisɨs siya ha napnamɨn mɨ iikam isid komiiyɨn sɨma ɨni Jisɨs siir mhoɨiyar yamɨm. Mɨ sɨma ɨni ɨrɨpa ɨrɨpa yonamɨm. ");
INSERT INTO iws_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mɨ wiga ɨra nwowi, ɨinokɨinokɨn saeya pɨu biyɨeka napɨdwodwomaimiiga bɨewiyɨm ɨuur whɨs, kamɨm paowai udiyɨm sɨmiir nwɨrkɨn saiir ma aiir bɨ swokɨ owaigɨnɨukɨn mɨiyɨk. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mɨ ta wiga saeya Jisɨs siir digɨuwa kingiin ha nɨta mɨ saeya ɨni siir yɨuɨs prɨeiya saiir mwoɨs ɨiirar yaka onkwokiya mɨ saeya hɨriinan tɨrkiya mɨ bɨ kɨmɨmɨnkika ta pɨu biyɨeya saeya nwowa ɨna yɨnkisanakiya mɨ mhoɨiya saeya bɨ swokɨ ɨmbiyamka. ");
INSERT INTO iws_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Mɨ Jisɨs siya srɨigi, yɨpɨkɨn ɨɨna kariir naka onkwokiyɨn? Mɨ iikam whɨekakɨm ɨna boɨnkiyɨm, an nɨɨnga, an nɨɨnga. Mɨ Pita siya ɨna boɨnkiyɨn, inkam Komii iikam isid komiiyɨn wasi kɨriirar nokwoyokaiyɨm, sɨmar kwakikɨn namkɨm. ");
INSERT INTO iws_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mɨ Jisɨs siya boɨnki, ɨɨna kariirɨn nwɨrka nonkwokikɨn. Mɨ kara ɨna kɨnankɨugiyɨn, kɨrɨe nhɨrɨm kariir bɨdi haiburgigɨm. ");
INSERT INTO iws_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mɨ ta wiga saeya nɨnoknɨnkɨnkiya mɨ saeya ɨni nɨdid komiigakar yowa mɨ saeya siirsi bɨ swokɨ ɨmprɨoka mɨ saeya ɨgmwo ɨni Jisɨs siir ɨmiiga inɨ hɨuwɨuwa. Mɨ iikam whɨekakɨm sɨmiir whwonkam ɨda saeya ɨna boɨna, ɨiya kara Jisɨs siir yɨuɨs aiir nonkwokiya, kariir ma bɨri kɨmɨmɨnkika saeya ɨna dɨgiya. ");
INSERT INTO iws_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jisɨs siya boɨnki, kariir yɨnisɨm yɨnkopak, kɨriirɨn kɨriir naɨngwo tɨbmii mɨiyɨka saeyar nwowaigɨnɨugika mɨ kɨra ha dam mɨ kɨriir mhɨi kwoɨnɨm hiinsɨma dwonam. ");
INSERT INTO iws_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Mɨ Jisɨs siya ha nikɨ boɨnaiyɨn mɨ bɨiyan inkamɨn Jairas, siir omaka hɨran inkamɨn siya ha nɨtɨn mɨ ɨna inɨ boɨnɨuwɨn siirɨn, kɨriir yɨnisɨm yɨnkopaka bɨdi yaonama. Kɨra inkamɨn dimɨn taemɨn nowɨmwarkaiyɨuwiyɨn kɨigi siir kɨpi nɨnki. ");
INSERT INTO iws_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mɨ Jisɨs siya ta yaiya aiir wakaekiyɨn mɨ siya Jairas siir yai anaka hɨnɨɨna yowarkɨi boɨn, kɨra kɨpi nɨdid. Mɨ kɨra hindara daɨngwo tɨbmii ɨski mɨ kɨriir yɨnisɨm yɨnkopaka saeya wɨ mɨiyɨka nwokɨ owɨm. ");
INSERT INTO iws_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Mɨ Jisɨs siya Jairas siir omaka hɨriir yam mɨ siya iikam whɨekakɨm sɨmiirɨn omakanau hɨriirɨn saɨka bɨri kɨgnɨnkɨn apnɨnopkai namkɨm. Nɨɨngaka. Pita, Jon, Jems mɨ ta yɨnisɨm yɨnkopaka saiir yopii ad owa sɨmasɨmar yapnɨnopkainam saɨkan. ");
INSERT INTO iws_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Mɨ iikam whɨekakɨm sɨma ta yɨnisɨm yɨnkopaka saiirɨmar nanka nɨnougɨm mɨ sɨma hɨrar nounanaekɨm. Mɨ Jisɨs siya sɨmiir boɨnki, kɨma kɨpi nou, saeya bɨri naoka, saeya nhwo whwonkaii. ");
INSERT INTO iws_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Mɨ sɨma siirɨn yaibu prasae bɨri nɨekɨm. Dimusi rani, sɨma bɨdi yɨnoknɨnkɨnɨm, saeya bɨdiya yaonama. ");
INSERT INTO iws_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mɨ Jisɨs siya ta yɨnisɨm yɨnkopaka saiir ɨɨn aiir yonkwoki mɨ ɨna boɨnkiyɨn, yɨnisɨm yɨnkopak, kɨra dɨnsiingi. ");
INSERT INTO iws_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Mɨ ta yɨnisɨm yɨnkopaka saiir pɨugɨna ɨna swokɨ ɨta saiirɨm. Mɨ bɨri kɨmɨmɨnkika saeya ɨna yɨnsiin ɨdwokiya. Mɨ Jisɨs siya sɨmiir boɨnki, kɨma nae nhɨrɨm saiir hauu ae. ");
INSERT INTO iws_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Mɨ ta yɨnisɨm yɨnkopaka saiir yopii ado sowa ɨni mounana sinkaokiyo. Mɨ Jisɨs siya sowiirɨn ɨna boɨnkiyɨn, tɨ dimɨnɨn siirɨn kowa inkam nwɨrni kɨpi swokɨ boɨnmauu mɨmɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisɨs siya kam ɨuur nwɨso siir kɨgna mɨriiyɨm sɨmiir yɨkɨuna ɨrɨpa haɨngiriyɨuɨm mɨ siya kɨrɨe komii mɨ inɨg komii sɨmiir hauuwɨm. Uridyɨu biyɨe biyɨeyɨm mɨ mapai mapaiyɨm sɨmiir haiswonɨmnɨskɨiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Mɨ siya sɨmiirɨn ɨna yɨkropkiyɨm ɨiya Adi Komii siya siir digworaekwowɨm sɨmiir kɨgɨrkakana saiir boɨnmɨmauuam mɨ makak iikamɨm sɨmiir mɨ ɨnɨmnɨskiiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Mɨ siya sɨmiir boɨnki, kɨma digworaekwo wara kɨpi hai apnam mɨ kɨma nae mɨnɨm mɨ umɨr hoknɨbɨm mɨ paekopɨm hogwokwo apiyɨm sɨmiir wara kɨpi hainam. Mɨ kɨma yɨuɨso kwokwɨsa kɨpi hainam. ");
INSERT INTO iws_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mɨ omaka kɨma napnɨnopkainami mɨ sɨma wadɨe kɨmiir nwowɨni mɨ kɨma ta omaka aiirar dwokrɨpkai. Mɨ tɨ om ɨiirɨn wɨ ta omaka saiir hɨrankar haiburgig. ");
INSERT INTO iws_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mɨ sɨma kɨmiirɨn sɨmiir omaka hɨriir namamɨn wadɨe nwowɨn karamae nwowi mɨ kɨma tɨ om ɨiir haiburgik. Mɨ nusɨn ɨmiir dɨkrɨmkrɨnkiigig sɨma wa nɨnoknɨnkɨnkiyɨm, krɨma mɨiyɨk rani. ");
INSERT INTO iws_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Mɨ kamɨm Jisɨs siir kɨgna mɨriiyɨm sɨma ɨna yɨtɨkrɨnkiyɨm omom omomɨm sɨmiir mɨ Adi Komii siir yaiwɨn kɨbiya saiir yapboɨnmamauuam mɨ iikam makakɨm omom omomanɨm hɨnda tɨndanɨm sɨmiir warar mɨ ɨnkɨn haiswonɨmnɨskɨiyam. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Mɨ inkam komiiyɨn Herot nu Galili kɨgrɨraowiyɨn tɨ yai whɨekakɨm sɨmiir wakaekiyɨn mɨ siir kwoɨnɨn ɨni hindara whrɨewhrɨekiyɨn. Dimusi rani, nhɨrɨm ha boɨni, Jonɨn op baptais haigɨnɨuwiyɨn ɨeyankɨn bɨdi swokɨ ɨnsiin ɨdwowɨn. ");
INSERT INTO iws_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Mɨ nhɨrɨm hɨnɨɨna boɨn, Ilaija bɨdi yɨmbiyamɨn. Mɨ nhɨrɨm hɨnɨɨna boɨni, bɨiyan profet inkam nwɨrɨn bɨdi swokɨ ɨnsiin ɨdwowɨn. ");
INSERT INTO iws_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mɨ Herot siya hɨnɨɨna boɨnki, Jon siir nɨiyɨn karar bɨdi kaigrɨpkiyɨn. Mɨ tɨ inkamɨn siya yɨpɨkɨn kara tɨ siir yaiya hɨnɨɨna wakaewɨnɨn, ha? Mɨ siya Jisɨs siir kɨgam mɨni. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Mɨ aposel kamɨm ha swokɨ ɨtɨm mɨ dimɨn whɨekakɨm sɨma tɨrɨm sɨma Jisɨs siir inɨ boɨnmɨmauuni. Mɨ siya sɨmiirɨn warar yɨnkɨn ɨkɨunam mɨ sɨma iikam nhɨrɨm sɨmiirɨn hɨrar haiburgik mɨ sɨmasɨmar yam om whɨrɨn siirɨn. Mɨ tɨ omɨn siir inɨgɨn Betsaidakɨn. ");
INSERT INTO iws_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mɨ ɨiya iikamɨm sɨma wakae dɨgiyɨm mɨ sɨma ɨni siir mhoɨiyar yamɨm. Mɨ sɨma siirɨm ha namɨm mɨ siya ɨni maɨrgɨmaɨrga ywowɨnɨn sɨmiirɨn. Mɨ siya Adi Komii siya siir iikamɨm sɨmiir kɨgɨrkakana saiir yowomwarkaiyɨu sɨmiirɨn mɨ iikamɨm makakɨm, sɨmiir warar mɨ ɨnkɨn haiswonɨmnɨskɨi haigɨnɨu. ");
INSERT INTO iws_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mɨ ɨiya bɨeyɨn ha nɨkiiyamtɨbɨn, kam ɨuur nwɨso siir kɨgna mɨriiyɨm sɨma ha nɨtɨm siirɨm mɨ sɨma boɨn, kɨra iikamɨm sɨmiir dɨkropki sɨma ɨkɨ om nhɨrɨm hɨnda tɨnda nwowɨm pɨ sɨmiirɨm nwokɨ amɨm mɨ sɨma pɨ hɨr nwokɨ whwonkaowiyɨm mɨ nae mɨnɨm pɨ hɨr nwokɨ ɨnkɨguna aeyamwiyɨm. Whɨsarii rani, ta maeyauwa krɨma nwowa om karamaeka. ");
INSERT INTO iws_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mɨ Jisɨs siya sɨmiirɨn ɨgao yaigakar ywoki, sɨmiirɨn nae kɨmar hauu. Mɨ sɨma ɨna boɨnɨm, krɨma nae hɨrii hɨrii karamaekɨm. Krɨma bretɨm ɨriiyar mɨ anasu whɨs sɨmasɨmar nwowi. Mɨ kɨra hɨnɨɨna naɨngwowi tɨ iikam whɨekakɨm nwowɨm, krɨma naeyɨm sɨmiir dɨgar pinɨ saɨnaki, aniya? ");
INSERT INTO iws_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kamɨm hɨr nwowɨm 5,000kɨm mɨ Jisɨs siya kamɨm siir kɨgna mɨriiyɨm sɨmiir boɨnki, kɨma sɨmiir boɨnki, sɨma kam nwɨs ɨuur ɨuura kiiyop ɨdwodwoam. ");
INSERT INTO iws_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma ɨni hɨriinanar mɨ tɨrɨm mɨ sɨma iikam ɨmiirɨn ɨna yokmwɨn ɨdwowɨm. ");
INSERT INTO iws_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jisɨs siya tɨ bret ɨriiyarɨm mɨ tɨ anasu whɨs ɨko ha haiyɨn mɨ siir nhwowɨn nɨnomor koua hɨriir ha kaokiyɨn mɨ siya ɨna boɨn wadɨekiyɨn Adi Komii siirɨm. Mɨ siya ɨna yɨnop hauugiyɨm kamɨm siir kɨgna mɨriiyɨm sɨmiir mɨ iikam sɨmiirɨn ɨni sɨmar hɨd nonkwokwo hauunamɨm. ");
INSERT INTO iws_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mɨ iikam whɨekakɨm ha naekɨnɨu dɨgiyɨm mɨ nae haɨmii haɨmiiyɨm sɨma naepɨpɨru okiyɨm mɨ nɨbɨm sɨma haigimɨrnɨnkɨnkiyɨm ɨuur ɨs. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ɨi gwɨra Jisɨs siya Adi Komii siirɨmɨn nhwo sasar inɨ kwɨsboɨnɨu. Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma ɨna yamɨm siirɨm. Mɨ siya sɨmiir srɨigi, iikamɨm kariirɨn panɨɨn nɨkɨuwigɨm? ");
INSERT INTO iws_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Mɨ nhɨrɨm yɨm hɨnɨɨna boɨnikɨm, Jonɨn op baptais haigɨnɨuwiyɨn siya. Mɨ nhɨrɨm yɨm hɨnɨɨna boɨni, kɨra Ilaijakɨn mɨ nhɨrɨm yɨm hɨnɨɨna boɨni, profet inkam nwɨrɨn bɨdi yɨnsiin ɨdwowɨn. ");
INSERT INTO iws_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Mɨ siya sɨmiir srɨigi boɨnki, wɨm kɨma panɨɨna dapikɨm? Mɨ Pita siya ɨna ywowarkɨi boɨnɨn, kɨra tɨ inkamɨn Adi Komii siya nɨmbingiyɨn Mesaia siya. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Mɨ Jisɨs siya sɨmiir boɨnki, ta yaiya inkam nwɨrni kɨpi swokɨ boɨnmauumɨmɨn. ");
INSERT INTO iws_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Mɨ Jisɨs siya ɨna swokɨ boɨnkiyɨn kara Yaowae Adɨn nɨnomor kouanɨn kara wɨ hɨk kɨmpɨpɨsu prasae hai rani. Mɨ bɨiyan inkamɨm omaka Adi Komii siir inɨg hainaniya saiir kɨgrɨraowiyɨm mɨ prismi bɨiyan inkam mɨ kamɨm siyɨu komii komiiyɨm sɨm nɨnomoknɨnkɨniyɨm, sɨma wɨ digɨumii siir haimriyɨuwi mɨ sɨma siirɨn wa nɨsomaowi mɨ siya ɨi kwoɨmaka wa swokɨ ɨnsiin ɨdwowi ɨe hɨrankar. ");
INSERT INTO iws_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Mɨ siya sɨmiir boɨnki mɨ inkamɨn kariir siyɨu ɨmiir napam nɨti mɨ siya dimɨnɨm siir kwoɨnau hɨr nwokaiyɨm digworaekwowɨm sɨmiir haiburgigi mɨ siya kariir mɨi ɨmiir mɨrii mɨ kariir siyɨu ɨmiir dap ɨski. Mɨ siya kariir mɨi aiirarar mɨriiyokiyokɨi mɨ kariir siyɨu ɨmiirarar timɨ apiyokiyokɨi. Mɨ siya tɨ paeyɨn hɨiniya nɨrɨonɨnkɨnɨn siirɨn hɨriiyar haiyokiyokɨi kariir hɨriinan. ");
INSERT INTO iws_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mɨ yɨpɨkɨ inkamkɨn digɨumii siir digworaekwo mɨ dimɨnɨm siir kwoɨnau nwokaiyɨm sɨmiir haimriiyɨu karamae nwowi mɨ siir kwoɨnɨn omwai waiyaiyɨn wɨ mɨiyɨk nwo rani. Mɨ siya wɨ hindara kɨgugu ɨskii. Mɨ yɨpɨkɨ inkamkɨn digɨumii siir digworaekwo mɨ dimɨnɨm siir kwoɨnau nwokaiyɨm sɨmiir haimriyɨuwi mɨ siya wɨ omwai hɨriiya waiyayokiyokɨi. ");
INSERT INTO iws_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mɨ yɨpɨkɨ inkamkɨn tɨ nu siir digworaekwo whɨekakɨm sɨmiir haɨngiriyɨu haigɨn mɨmɨri siyamar mɨ inɨg komiigak ha mɨ owi mɨ tɨ digworaekwowɨm wɨ sɨma whɨnkɨnsiis haigɨnɨuwi siirɨn omwai waiyayokiyokɨikaeyamɨm, aniya? Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mɨ yɨpɨkɨ inkamkɨm kariiram maɨrgɨmaɨrga karamae nwowi mɨ digɨumii kariir yai aiir haimriyɨuwi mɨ mhoɨiya kara Yaowae Adɨn nɨnomor kouanɨn siya swokɨ ɨti digworaekwo whɨekakɨm Adi Komii siya kariir hauuwɨm paenan nɨuyaeiyɨm mɨ Adi Komii siir paekwosɨmɨm sɨmaka nɨti mɨ taka ɨiya kara kɨriirɨn wɨ digɨumii saiir swokɨ haimriyɨuwi. Mɨ mhoɨiya siya wɨ Adi saɨka nwo rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kara kɨmiirɨn yaimwowar boɨni, tɨ iikam nhɨrɨm tɨrar nwowɨm, kɨma wɨ nikɨ ao rani. Mɨ dimɨnɨm ɨiya Adi Komii siir dimɨn taemɨn ɨmiir kɨgɨrkakana wɨ saiirar nɨmbiyami. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mɨ Jisɨs siya tɨ yaiyɨm ha boɨn dɨgiyɨm mhoɨiya ɨi ɨriiyar kwoɨmɨm namkiyɨm mɨ siya Pita Jon mɨ Jems sɨmiir yɨkɨunam mhɨuisɨm whɨrɨn siir kɨua hɨriir, nhwo Adi Komii siirɨm kwɨsboɨnɨm. ");
INSERT INTO iws_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mɨ siya hɨrar kwɨsboɨnɨn mɨ siir whwonkamɨn ɨna yɨgiyɨn mɨ siir yɨuɨsa paenan ha nɨuyakiya mɨ saeya ɨni whɨsinana ywokiya. ");
INSERT INTO iws_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Mɨ bɨri kɨmɨmɨnkikɨn inkam nwɨso ɨni saɨkar yamokwo boɨnainiyo. Moses, Ilaija so. ");
INSERT INTO iws_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Mɨ sowa Adi Komii siir dimɨnɨn paenan nɨuyaiyɨn saɨka nɨnkɨn ɨmbinikɨn. Mɨ sowa ɨiya Jisɨs siya naonama saiir nɨmbiyami dimɨnɨn Jerusalem hɨr, Adi Komii siya nɨmbinɨn bɨdi bɨdiniyar sɨmiir boɨnmɨmauugɨm. ");
INSERT INTO iws_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mɨ Pita siya mɨ siir nomiiyau nwɨs owa sɨma nhwo whwonkaigɨm mɨ sɨma ha nɨnsiingiyɨm mɨ sɨmar kɨgi paeya Jisɨs mɨ inkam nwɨso saɨka nokwowo sɨmiir hɨr nɨuyaki. ");
INSERT INTO iws_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mɨ sowa Jisɨs siir haiburgigɨm mɨnko mɨ Pita siya siir boɨnki, Bɨiyan Inkam Komii, krɨma tɨr nwowɨm wadɨeka. Mɨ krɨma omaka amɨrɨm wɨ ouuma mɨrii, ɨra kɨriirga mɨ ɨra Moses mɨ ɨra Ilaija Pita siya ta yai aiirɨn whaowaeya prɨiboɨnkɨn, siya bɨ nɨnoknɨnkɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mɨ siya yai aiirar nikɨ boɨnɨn mɨ waua ɨni sɨmiira yaunɨ kikirɨnuniya, sɨma ɨna yɨdidgiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Mɨ yai kwɨra ta wau aiir kauwok boɨnkiya, saeya hɨnɨɨna kauwok boɨnkika, warɨ yɨnisɨmɨn kariir yɨnisɨmkɨn. Mɨ kara siir bɨdi yɨmbinɨn. Kɨma siir yai aiirar wakaeyokna. ");
INSERT INTO iws_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Mɨ ta yaiya ha boɨnkiya mɨ sɨma kɨgi, Jisɨs sasar nwoki. Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma yai ha nɨnkɨn tankiyɨm mɨ ta ɨiya tɨ dimɨnɨn sɨma kɨgnamɨn, sɨma inkam nwɨr bɨ swokɨ boɨnmauumɨmɨnkɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mɨ ɨigwɨra sɨma mhɨuisɨm whɨrɨn siir haiburgigɨm mɨ ha nɨuunamɨm mɨ iikam isid komii whɨrɨn, sɨma Jisɨs siirɨn siyɨu hɨr yapyɨskaiwɨn. ");
INSERT INTO iws_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mɨ tɨ iikam isid komiiyɨn sɨmiir hɨran inkam nwɨrɨn siya ɨna kauwok boɨnamnankiyɨn, iikam nowomwarkaiyɨuan inkamɨn mɨ kara kariirɨmar kwɨsboɨnki. Kɨra kariir yɨnisɨm yɨnkamiyɨn ɨiir kɨgi, siya kariir yɨnisɨm yɨnkamiyɨn nwɨrkɨ nwɨruwa ɨeyaɨrgɨn. ");
INSERT INTO iws_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Mɨ uridyɨu biyɨe whɨrɨn siya nonkwokɨn siirɨn. Mɨ bɨ kɨmɨmɨnkikɨn, siya ha kauwok boɨnkiyɨn mɨ tɨ uridyɨu biyɨe ɨeyar haigi ɨtɨwamwakikɨngig. Mɨ yaeyopa pa nɨmbinaniyami siir yai hɨrankar mɨ siya tɨ yɨnisɨmɨn siir pɨu aiirar nonkwobumbunɨnkɨnikɨn mɨ siya siir bɨ swokɨ haibur sranikɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mɨ kara kamɨm kɨriir kɨgna mɨriiyɨm sɨmiiram bɨdiyar kauwok boɨnanaeyɨn tɨ uridyɨu biyɨe siir haiswonɨskiyɨm mɨ sɨma dɨg bɨ nwokɨm. ");
INSERT INTO iws_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Mɨ Jisɨs siya ɨna yowarkɨi boɨnɨn mɨ tɨ iikamɨm tariinananɨm kɨma naɨngwo tɨbmii karamaekɨm. Kɨmiir mhɨi kwoɨnɨm mɨiyɨk nwo rani. Mɨ kara kɨmaka wɨ pariig ɨiya nwowi, ha? Mɨ kara kɨmiirɨn wɨ pariig ɨiya whɨndirɨraerar haigɨnɨuwi mɨ kɨma wa nwokɨ aɨngwo tɨbmiiyɨm, ha? Mɨ siya tɨ inkam ɨiir boɨnki. Yɨnisɨmɨn tɨriir whainani. ");
INSERT INTO iws_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mɨ siir yɨnisɨmɨn ha nikɨ apnaniyɨn mɨ tɨ uridyɨu biyɨeyɨn ɨni siyar haigi owomwak ɨnamnaniyɨn. Mɨ Jisɨs siya ɨgao yaigak tɨ uridyɨu biyɨeyɨn siir boɨnki mɨ siya tɨ yɨnisɨm ɨiirɨn ɨna haiswonɨski haigɨnɨugiyɨn. Siya ɨni siir ad ɨiiramar swokɨ ɨkropkiyɨn. ");
INSERT INTO iws_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mɨ iikam whɨekakɨm sɨma Adi Komii siir kɨrɨe komiiya saiir kɨgiya sɨma ɨni hindara yanaakiyɨm. Ɨriig. Mɨ iikam whɨekakɨm ɨna nikɨ aɨngwoyɨmyokrɨpkaiyɨm, tɨ dimɨnɨm siya tɨrɨm sɨmiirsiyɨn mɨ siya kamɨm siir kɨgna mɨriiyɨm sɨmiir boɨnki, ");
INSERT INTO iws_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","kɨmiir wɨɨnɨm sɨbgu mauugi. Mɨ mhoɨiya Yaowae Adɨn nɨnomor kou hɨrankɨ nɨtɨn siirɨn wɨ wɨr nhɨrɨm sɨma napwouwi. ");
INSERT INTO iws_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mɨ sɨma ta yaiya siya boɨna saiir bɨ nɨnoknɨnkɨnkɨm, ta yaiya saiir yaimwokɨyaimwowa sɨmiirsi nɨmprɨoka mɨ sɨma saiir panɨɨnsi sɨbgu yɨnoknɨnkɨnsi. Mɨ sɨma pɨ nɨdidgɨm ta yai aiiramɨn siir panɨɨnsi srɨisi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Mɨ kamɨm Jisɨs siir kɨgna mɨriiyɨm sɨma yaiya kwɨra yɨniinansao boɨn, yɨpɨkɨn sɨmiir kougɨkou nwowɨn. ");
INSERT INTO iws_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mɨ Jisɨs siya bɨdiya yɨnoknɨnkɨnɨn kwoɨnɨn sɨmiir hɨr nwowɨn. Mɨ siya yɨnisɨm sapɨsap nwɨrɨn siir asi nɨkɨunakɨn. ");
INSERT INTO iws_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Mɨ siya sɨmiir boɨnki, inkamɨn tɨ yɨnisɨm sapɨsapɨn siirɨn kariir inɨg ɨiir kɨgrɨraowi yɨo siya kariir kɨgrɨraokɨn. Mɨ inkamɨn kariir kɨgrɨraowi mɨ siya inkamɨn kariir nɨkropkiyɨn siirɨn warar nɨnkɨn kɨgrɨraowi. Mɨ inkamɨn yɨnisɨm sapɨsapnan kɨmiir waraur nwowi mɨ kɨmiir kougɨkouɨn ɨni siyar ywowɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon siya ɨna yowarkɨi boɨnɨn, Bɨiyan Inkam Komii, krɨma inkam nwɨra kɨg, uridyɨu biyɨeyɨm sɨmiirɨn kɨriir inɨg ɨiir haiswonɨmnɨskɨigɨn. Mɨ siya krɨmiir yai bɨ wakaeyoknakɨn mɨ krɨma siirɨn hɨriinansi nɨkɨdugɨm. Dimusi rani, siya krɨmiir isid rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Mɨ Jisɨs siya siir boɨnki mɨ kam nhɨrɨm siir kɨgna mɨriiyɨm sɨma, kɨma siir kɨpi nɨkɨdu. Inkamɨn ɨo nhwo kɨmiir nanao karamae nwowiyɨn yɨo siya kɨmiir nomiiyaugɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ɨiya Adi Komii siya Jisɨs siir swokɨ ɨkɨunamana nɨnomor koua hɨriir saeya ɨni kingiin nwowa. Mɨ Jisɨs siir kwoɨnɨn om komii Jerusalema namɨm asi naɨngwokɨn. ");
INSERT INTO iws_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Mɨ siya kam nhɨrɨm sɨmiir yɨkropki, yai siir bɨiyɨn sɨma nwokɨ haigirɨrɨramɨm mɨ sɨma ha namɨm nu Sameria hɨrɨn om whɨrɨn siir yapnɨnopkainam. Mɨ sɨma siir digworaekwo nhɨrɨm sɨmiir dirɨraerarɨm mɨnkɨm. ");
INSERT INTO iws_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mɨ omɨn siir hɨran inkam nhɨrɨm sɨma siir bɨri nɨkɨunamkɨm sɨmiir omaka hɨriir. Dimusi rani, Sameria iikam sɨma ɨrɨpa mhɨi kwoɨn bɨri nwowikɨm Judami iikam sɨmakan sɨma ɨna nɨnoknɨnkɨnɨm siya pɨ om komii Jerusalem hɨriir nami. ");
INSERT INTO iws_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Inkam nwɨso siir kɨgna mɨriiyo Jems, Jon sowa, sowa hɨriinan siyɨuɨn siir kɨgɨn mɨ sowa siir boɨnmauu, Bɨiyan Inkam Komii, krɨma paeya nɨnomor kou hɨrana saiirɨm nɨkɨugi, saeya tɨ iikamɨm tɨranɨm sɨmiir nwokɨ ɨuniyɨm, aniya? ");
INSERT INTO iws_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mɨ Jisɨs siya ha haiyɨug okwokiyɨn mɨ siya ɨo sowiir ywoki. ");
INSERT INTO iws_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Mɨ sɨma om whɨra yapnam. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Mɨ sɨma siyɨu hɨrar nikɨ apamɨm mɨ inkam nwɨrɨn siir boɨnki, kɨra omom omomɨm kɨra nami mɨ kara wɨ kɨriir mhoɨiya nɨnkɨn apiyokiyokɨii. ");
INSERT INTO iws_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Mɨ Jisɨs siya siir boɨnki, niimauan wraɨm yɨm ɨeno kakargɨm mɨ ɨpiyɨnɨm yɨm ɨriipɨ hɨriinan whɨe kakargɨm. Mɨ Yaowae Adɨn nɨnomor kouanɨn yɨo omaka maeyau whwonkai karamaekɨn. ");
INSERT INTO iws_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Mɨ siya inkam nwɨrɨn siir boɨnki, kɨra kariir mhoɨiyar wɨt. Mɨ siya boɨn mɨ kɨra kariirɨn wadɨe tikɨ oki. Kariir adɨn siir pɨuɨs biyɨeya saiir nikɨ hangikaigigi. ");
INSERT INTO iws_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Mɨ Jisɨs siya siir yowarkɨi boɨnki mɨ inkam wɨɨrɨm yɨm inkamɨm kariir mhoɨiya nɨt karamae nwowiyɨm sɨma haɨngikai. Mɨ ni kɨra ɨiya Adi Komii siya siir digworaekwowɨm mɨ siir iikamɨm sɨmiir kɨgɨrkakana saiir yai ɨmiir tinɨ boɨnmɨmauuwɨu. ");
INSERT INTO iws_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Inkam nwɨrɨn siya siir boɨnki, Bɨiyan Inkam Komii, kara kɨriir mhoɨiya nɨtam mɨni mɨ kɨra kariirɨn pɨ wadɨe dwoki. Kara yai mɨnɨm kariir isidɨn sɨmaka ninɨ ɨdwo boɨnaigigi. ");
INSERT INTO iws_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Mɨ Jisɨs siya siir boɨnki, inkam i kigrɨrɨriyɨn, siir nhwowɨn idaowa hɨri hɨriiya kaonanaei mɨ tɨ hɨriinan inkamɨn siya wɨ Adi Komii siya kɨgrɨrao tani. Nɨɨngaka. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Mɨ mhoɨiya Bɨiyan Inkam Komiiyɨn siya ɨna swokɨ ɨmbinɨn kamɨm kam nwoɨm ɨuur nwɨso. Mɨ siya sɨmiirɨn nwɨnnwɨsa yɨkropki mɨ sɨma siir bɨiyar yamkwokɨn. Mɨ siya sɨmiirɨn om komii komiiyɨm mɨ omisɨsɨmɨm mhoɨiya siya namanɨm sɨmiirɨn sɨmiir hɨriir yɨkropki. ");
INSERT INTO iws_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Mɨ siya sɨmiir boɨnki, iikam whɨekakɨm sɨmiir kwoɨnɨm wadɨe bɨdi ywowɨm sasaeyɨm wai nwowɨm sɨmiir hɨriinan. Mɨ iikam whɨekakɨm sɨma ta yai aiir wakaeyama tɨri. Mɨ iikam whɨekak rani, sɨmiirɨm namɨm mɨ sɨmiir nɨkɨunakiyɨm mɨ sɨma bɨdi grirgigiyɨm. Mɨ numɨran adɨn, Adi Komii siyaɨrgɨn, siirɨm srɨigi siya kam nhɨrɨm sɨmiir nɨkropkiyɨm mɨ sɨmiir kwoɨn ɨmiir hɨurworwokaiyɨm mɨ sɨma siir mhoɨiya nwokɨ amɨm. Tɨ hɨriinan inkamɨn siya numɨra sasaeyɨm wai nwowiyɨm sɨmiirɨm namiyɨn mɨ ha nɨngugu haiswonaniyɨm ɨni siir hɨriinan ywowɨn. ");
INSERT INTO iws_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kɨma dam! Kara kɨmiirɨn huyɨnsɨm prɨkɨprɨknan nɨkropkikɨn niimau mɨe komii komiiyɨm wra bibiyɨekɨ nwowɨm sɨmiir hɨriir. Mɨ kɨmiirɨn wɨ kɨgrɨraowan inkam kakar nwowi. ");
INSERT INTO iws_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mɨ kɨma umɨr hoknɨbɨm wara kɨpi hainam mɨ ɨga nii aka mɨ kɨma siyɨu bopwo hɨrɨn inkam napkɨgami mɨ sɨmiirɨn yai kɨpi kainanam. Hindarar daparkaknam, ɨi naeisi. ");
INSERT INTO iws_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Mɨ kɨma omaka ɨr napnɨnopkainami mɨ bɨiyɨn kɨma wɨ hɨnɨɨna tinɨ boɨnɨu, kɨma ha maɨrgɨmaɨrga iikamɨm tɨ omaka aiir nwowɨm. ");
INSERT INTO iws_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mɨ inkam nwɨrɨn kwoɨn hinsɨma nwowiyɨn siya ta omaka aiir nwowi mɨ siya wɨ kɨmiir yaiyar wakaeyoknaei mɨ siir kwoɨnɨn wɨ hinsɨma nwowi. Mɨ hɨriinan inkam karamaekɨ nɨuwi mɨ kɨra hɨkak nwowi mɨ ta yaiya hɨriiyar swokɨ okainani. ");
INSERT INTO iws_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mɨ kɨma ta omaka ɨrua aiirar dwokrɨpkai. Mɨ kɨma nae op mɨnɨm sɨma hauuwi sɨmiir dae kwiyae. Mɨ kɨma tɨ nae ɨmiirsiyɨn umɨr kɨpi hauu sɨmiirɨn. Dimusi rani, kɨma dimɨn mɨiyɨk mɨiyɨkɨm sɨmiir bɨdi hauuwɨm. Mɨ sɨma kɨmiirɨn hɨriinansi hauu aei. Kɨma omaka ɨrni ɨrni kɨpi whwonkaiyam. ");
INSERT INTO iws_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Mɨ kɨma om komii whɨra napnɨnopkainami mɨ inkam nwɨrkɨn kɨmiirɨn wadɨe nwowɨni, siir omaka hɨriir namɨm mɨ nae mɨnɨm siya hauu wɨni mɨ kɨma wɨ kɨpi boriisop wa dae. ");
INSERT INTO iws_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mɨ kɨma tɨ om komii hɨran inkamɨm makakɨm sɨmiir warar timɨ haiswonɨmnɨskɨi haigɨnɨu mɨ kɨma sɨmiirɨn hɨnɨɨna boɨnki, ɨiya Adi Komii siya siir dimɨn taemɨnɨm mɨ siir iikamɨm sɨmiir kɨgɨrkakana, saeya kɨmiir kingiin bɨdi yamwoniya. ");
INSERT INTO iws_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mɨ kɨma om komii whɨrɨn siir napnɨnopkainami mɨ sɨma kɨmiir bɨ boɨn wadɨe wɨnkɨm sɨmiir omaka hɨriir namamɨn mɨ kɨma tɨ om komii siir siyɨuɨn siir yaba hɨr dɨkwowɨn kɨma hɨnɨɨna boɨn, ");
INSERT INTO iws_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","tɨ kɨmiir om komiiyɨn siir nu sɨnɨm sɨma ɨni krɨmiir ɨga ɨmiir nwowɨm mɨ krɨma pɨ kɨmiirarar swokɨ hauugigi. Mɨ kɨma sɨbgu daɨngworɨnu. Dimusi rani, kɨma krɨmiir yai ɨmiir bɨ wakaeyoknakɨm, ɨiya Adi Komii siya siir digworaekwo whɨekakɨm, sɨmiir kɨgɨrkakana ɨni kingiin yamwoniya mɨ kɨma ta yaiya digɨumii saiir haimriiyɨugɨm. ");
INSERT INTO iws_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kara kɨmiirɨn pɨ hɨnɨɨna boɨnki, mhoɨiya ɨiya Adi Komii siya iikamɨm dimɨn biyɨekakɨm sɨmaka boɨnaini ɨiya saeya nɨmbiyami mɨ ta hɨka wɨ hɨka om komii biyɨekɨbiyɨeyɨn Sodom hɨran iikamɨm dimɨn biyɨe tɨrɨm wɨ sɨmiir haiburi. Tɨ omɨn Isrel siir omkɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jisɨs siya ha nikɨ boɨnɨn mɨ siya boɨnki, kɨma Juda iikamɨm om Kolosiyanɨm Adi Komii siya kɨmiirɨn wɨ hɨk prasae hauu rani mɨ om Betsaidan Juda iikamɨm kɨma ɨriipa hɨriinan, Adi Komii siya kɨmiirɨn wɨ hɨk prasae mɨ hauu rani. Dimusi rani, dimɨn mɨiyɨk mɨiyɨk whɨekakɨm Adi Komii siya kɨmiir tɨrɨm mɨ kɨma sɨmiir bɨri kɨgɨm mɨ kɨma sɨmiir bɨri wakaeyoknakɨm. Nɨɨngaka. Kɨma ɨni digɨumii sɨmiirar haimriyɨukrɨpkaiyɨm. Mɨ bɨiya Adi Komii siya dimɨn mɨiyɨk mɨiyɨkɨm iikamɨm Juda iikam tani om Taia om Saidon sowiir hɨranɨm sɨmiirɨn hɨriinan hauugɨso mɨ sɨma ha kɨgɨso mɨ sɨma sɨnɨn wa pɨ masɨn mɨ aknaɨnan bɨdi pɨ yɨisiimauuɨn Adi Komii siirɨn, dimɨn biyɨe biyɨeyɨm sɨma tɨrɨm sɨmiirsiyɨn mɨ sɨma ha pɨ yaɨngwo tɨbmiiyɨn Adi Komii siirɨmɨn. ");
INSERT INTO iws_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mɨ ta ɨiya Adi Komii siya iikamɨm sɨmiir hɨdi mɨ hɨka kɨmiir nɨmbiyami saeya wɨ komiigɨ komii nwowi. Wɨ hɨka om Taia mɨ om Saidon sowiir nɨmbiyama saiir haiburi. ");
INSERT INTO iws_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kɨma tɨ iikamɨm om Kapaneamanɨm, nu Isrel hɨranɨm kɨmiir kwoɨnɨn ha naɨngwowi, Adi Komii siya kɨmiirɨn ɨni kougɨkou haigɨnɨn, aniya? Nɨɨngaka. Adi Komii siya kɨmiirɨn iikam mɨiyɨkɨ mɨiyɨknan mɨ ɨkɨuwi. Mɨ kɨma wɨ inkam biyɨenan nwowi. Mɨ siya kɨmiirɨn wɨ maeyau biyɨeya paekaka wɨ saiir nɨtkaigi. ");
INSERT INTO iws_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Mɨ siya kamɨm siir kɨgna mɨriiyɨm sɨmiir boɨnki. Yɨpɨkɨ inkamkɨn kɨmiir yai aiir wakaeyoknaei. Mɨ yɨpɨkɨ inkamkɨn digɨumii kɨmiir haimriyɨuwi. Mɨ yɨpɨkɨ inkamkɨn digɨumii kariir haimriyɨuwi mɨ siya inkamɨn kariir nɨkropkiyɨn digɨumii siir warar mɨ ɨnkɨn haimriiyɨuwi, yɨo Adi Komii siyaɨrgɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Mɨ mhoɨiya tɨ kam, kam nwoɨm ɨuur nwɨso ha swokɨ ɨtɨm mɨ sɨma ɨni maɨrgɨmaɨrga komiigakar inɨ oniyɨm. Mɨ sɨma hɨnɨɨna boɨn, Bɨiyan Inkam Komii, krɨma kɨriir inɨg ɨiirar boɨnkiyɨm mɨ uridyɨu biyɨeyɨm sɨma ɨni krɨmiir yai aiirar mɨ wakaeyoknam. ");
INSERT INTO iws_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Mɨ siya sɨmiir boɨnki, kara bɨdi kɨgiyɨn Setanɨn diyanan tɨonaiiniyɨn nɨnomor kou hɨrankɨn. ");
INSERT INTO iws_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Wakaei! Kara kɨrɨe komiiya kɨmiir bɨdi hauugiya mɨ owɨniyai mɨpug mɨnɨm kɨma wɨ sɨmiirar nɨnkɨn okwo mɨrii nami mɨ sɨma wɨ kɨmiir pi rani. Mɨ Setan siir kɨrɨeya wɨ kɨmar nikwowaisii. Mɨ kɨmiirɨn wɨ dimɨn whɨrkɨ swokɨ tɨrbu rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mɨ kɨma hɨnɨɨna kɨpi boɨn maɨrgɨmaɨrga. Uridyɨu bibiyɨeyɨm ɨni krɨmiir yai ɨmiirar wakaeyoknam. Nɨɨngaka. Kɨma Adi Komii siiramar maɨrgɨmaɨrga kɨmiir inɨgɨm siya bɨdi wɨn haigɨnɨm nɨnomor kou hɨr. Mɨ sɨma wa nwokɨ ɨnoknɨnkɨnɨm kɨma Adi Komii siir yɨnisɨmkɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mɨ taka ɨiya Adi Komii siir naeyɨuɨn Jisɨs siir mhɨi kwoɨn ɨmiir hɨurworwokai mɨ siya ɨni maɨrgɨmaɨrga ywowɨn. Mɨ Jisɨs siya boɨn, Adi Komii, kɨra nu nɨnomor sowiir Bɨiyan Inkam Komiigɨn. Kara kɨriir boɨn wadɨeki, kɨra dimɨn nhɨrɨm kamɨm nɨnoknɨnkɨnkakɨm mɨ kwoɨn mɨiyɨk mɨiyɨkakɨm sɨmiirsi nɨmprɨokɨn nu tɨranɨm mɨ kɨra inkamɨm naɨngwo omok karamaeyɨm sɨmiir yɨisiimauu. Ɨhɨ, Adi Komii, kɨriir kwoɨnɨn siya hɨriiyar nwowikɨn. ");
INSERT INTO iws_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Kariir Adi Komiiyɨn siya digworaekwo whɨekakɨm, kariir ɨɨna bɨdi hauu dɨgɨm. Inkam nwɨrkɨn kariir bɨri nɨnoknɨnkɨnkɨn, Adi Komii sasar nɨnoknɨnkɨni kariirɨn. Mɨ inkam nwɨrkɨn Adi Komii siir nɨnoknɨnkɨn tani. Kara siir Yɨnisɨmɨn kanakanar nɨnoknɨnkɨni siirɨn. Mɨ iikamɨm kara boɨnmɨmauuɨm yɨm ɨna nɨnoknɨnkɨnɨm Adi Komii siirɨn. ");
INSERT INTO iws_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Mɨ kamɨm Jisɨs siir kɨgna mɨriiyɨm sɨmasɨmar nwokɨm mɨ siya ɨna haiyɨug boɨnkiyɨn. Iikam nhɨrɨm sɨma dimɨn kɨrɨe kɨrɨeyɨm warɨ bɨ kɨgɨm. Adi Komii siya kɨmiirɨm naɨngwokwonanaeikɨn mɨ siya dimɨn kɨrɨe kɨrɨeyɨm kɨmiir asi nɨisiimauugɨm. Mɨ kɨma nhɨrɨm sɨmiir kou asi nwowi. ");
INSERT INTO iws_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kara pɨ kɨmiir boɨnki. Bɨiya profet kamɨm mɨ inkam komiiyɨm nu kɨgrɨraowiyɨm, sɨma tɨ dimɨnɨm tariinan kɨgɨm, sɨmiir kɨgamar naɨngwokɨm mɨ sɨma bɨ kɨgɨm. Mɨ sɨma tɨ yaiyɨm tariinan kɨma wakaeyɨm, sɨmiir wakaeyamar naɨngwokɨm mɨ sɨma sɨmiir bɨ wakaekɨm. Nɨɨngaka. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mɨ inkam nwɨrɨn siyɨu komii nɨnoknɨnkɨniyɨn, siya Jisɨs siirɨm kɨnankɨugɨn. Mɨ siya boɨn, iikam nowomwarkaiyɨuwan inkam, kara wɨ panɨɨna tɨri kwoɨn budɨn ɨinokɨinok omwai waiya yokiyokɨiiyɨn siirɨn, ha? ");
INSERT INTO iws_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Mɨ Jisɨs siya siir yai aka ɨna yowarkɨi boɨnɨn, Yokwo Komii saeya panɨɨna boɨnka? Kɨra panɨɨna mwaɨngɨn saiir yaimwokɨyaimwowa, ha? ");
INSERT INTO iws_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mɨ siya hɨnɨɨna yowarkɨi boɨn, Yokwo Komii saeya hɨnɨɨna boɨnka, Bɨiyan Inkam Komiiyɨn siya kɨriir Adi Komiigɨn mɨ kɨriir mhɨi kwoɨnɨm siiramar daɨngwo ɨrkak mɨ kɨriir pɨugɨɨna mɨ kɨriir kɨrɨeya mɨ kɨriir kwoɨnbud ɨeya sɨmiirar hauu ɨrkak siirɨn. Kɨra kɨriir nomiiyau ɨiirɨmɨn hɨnɨɨna daɨngwo kɨra kɨramar naɨngwonaeiyɨn saiir hɨriinan. ");
INSERT INTO iws_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Mɨ Jisɨs siya siir boɨnki, ɨhɨ, kɨra ɨni wadɨeya yowarkɨi boɨnɨn. Mɨ kɨra hɨriinan tɨri mɨ kɨra wɨ omwaiya waiya yokiyokɨii. ");
INSERT INTO iws_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mɨ inkamɨn siyɨu komii nɨnoknɨnkɨniyɨn siya siir inɨg ɨiirar sɨbgu dirɨraeraramar naɨngwowi. Mɨ siya Jisɨs siirɨn hɨnɨɨna srɨii, Yokwo Komii saeya boɨna yaiya kɨra hɨnɨɨna boɨnkɨn kɨra nomiiyau nwɨrniyam naɨngwowiyɨm, kɨra kɨramar naɨngwonaeiya saiir hɨriinan daɨngwo. Mɨ tɨ nomiiyau nwɨrɨn kɨra boɨnɨn siya yɨpɨkɨn, ha? ");
INSERT INTO iws_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Mɨ Jisɨs siya hɨnɨɨna yowarkɨi boɨn, inkam nwɨrɨn om Jerusalem hɨr haiburgigɨn. Mɨ om Jeriko hɨriir yapnam. Mɨ siyɨu hɨrɨn siirɨn inkam biyɨe nhɨrɨm sɨma yapiyɨskaiwɨn mɨ sɨma siir digworaekwo whɨekakɨm sɨmiir haii mɨ sɨma siirɨn ɨna yɨpamparɨn. Mɨ sɨma hɨriinan tɨrgikɨm mɨ ɨna yamɨm. Mɨ siya ɨni siyɨu hɨrar ywokiyɨn mɨ siya naowɨm pariiparii. ");
INSERT INTO iws_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Mɨ taka ɨiya pris inkam nwɨrɨn krɨmiir kaoprigi okwowiyɨn tɨ siyɨu ɨiir napniyamkɨn. Mɨ siya tɨ inkam ɨiir kɨgɨn mɨ siya kɨmɨdiniya siirsi yapiyoknam mɨ siya siyɨu mɨga hɨriir yapnam. ");
INSERT INTO iws_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Mɨ ɨriipɨ hɨriinan Livai inkam nwɨrɨn nu Judianɨn ta maeyau kaimwo aiir mɨ ɨmbiniyɨn mɨ siya tɨ inkam ɨiir kɨgɨn mɨ siya ɨna mɨ apiyoknamɨn siyɨu mɨga hɨriir. ");
INSERT INTO iws_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Mɨ inkam nwɨrɨn nu Sameria hɨrankɨn. Sɨmiir sau omomɨn siya tɨ siyɨu ɨiir mɨ apnam mɨ tɨ inkamɨn siir hɨriir yɨmbiyam mɨ siya siir kɨgɨn mɨ siir kwoɨnɨn siirsiyɨn naɨngwoyɨmiyok prasae bɨ kikɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Mɨ siya siir kingiin ha namɨn mɨ wa op wain mɨnɨm siir paowai ɨmiir yaokɨnki, wadɨe sɨmiir nwowaigɨnɨugiyɨm mɨ siya ɨna udgiyɨm siir paowaiyɨm. Mɨ siya tɨ inkamɨn siirɨn ha kinɨnsiin ɨdwokiyɨn mɨ siirɨn siir donkiyɨn siir ɨdwo yakɨ kikɨnɨu ɨdwoki. Mɨ siya siirɨn omaka ɨra inkamkɨ saɨn whwonkaiiya saiir hɨriir yɨkɨunam mɨ siirɨn ɨna sɨbgu kɨgrɨraowɨn. ");
INSERT INTO iws_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mɨ ɨigwɨr nugakɨn siya tɨ inkamɨn omakanɨn siirɨn umɨrɨm kam nwɨra hauugik mɨ siirɨn hɨnɨɨna boɨnmauugi, tɨ inkamɨn siirɨn kɨra sɨbgu kɨgrɨrao. Mɨ kɨriir umɨr nhɨrɨm siir hauu saɨni mɨ ɨiya kara swokɨ ɨti wa swokɨ hauukɨiyɨuwi kɨriirɨn. ");
INSERT INTO iws_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jisɨs siya boɨn mɨ tariinanɨn kɨra panɨɨna naɨngwowi, yɨpɨkɨn tɨ inkam nwoɨmɨm sɨmiir nwɨrɨn tɨ inkamɨn, kamɨm hɨi tauaeiyɨm sɨm nonkwobumbu nɨnkɨngikɨn siirsi naɨngwoyɨmiyokɨn, ha? ");
INSERT INTO iws_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mɨ inkamɨn siyɨu komii nɨnoknɨnkɨniyɨn siya boɨn, tɨ inkamɨn siirsi naɨngwoyɨmiyokɨn mɨ siir whɨndirɨraerɨn siya. Mɨ Jisɨs siir boɨnki mɨ kɨra ha dam mɨ hɨriinanar tinɨ tɨrɨu. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Mɨ Jisɨs siya mɨ kamɨm siir kɨgna mɨriiyɨm sɨma ha napnamɨm mɨ sɨma om komii whɨrɨn siir yapnɨnopkainam. Mɨ wig ɨra saiir inɨgɨn Mataka, siirɨn saeya yɨkɨuna apnɨnopkainam saiir omaka hɨriir nae hauu aeyɨm. ");
INSERT INTO iws_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mata saeya nomousɨma ɨra nwowi, saiir inɨga Mariaka, Maria saeya Bɨiyan Inkam Komiiyɨn siir ɨgmiiga kingiina inɨ ɨdwoni, saeya siir yai ɨmiir wakaemɨmɨka. ");
INSERT INTO iws_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mɨ Mata ya ɨni nae dirɨraerarnanaeya mɨ saiir kwoɨnɨn ɨni haugɨhauga whiyɨekiyɨn. Mɨ Mata saeya Jisɨs siiram yam mɨ ɨna boɨna, Bɨiyan Inkam Komii kariir nomousɨma kariir bɨdi haiburgika mɨ naeyɨm kanakana dirɨraerarnanaei. Mɨ kɨra saiirɨm naɨngwo rani, aniya? Kɨra saiir boɨnki, saeya kariir whɨndirɨraerarniyɨm. ");
INSERT INTO iws_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mɨ Bɨiyan Inkam Komiiyɨn siya hɨnɨɨna yowarkɨi boɨn Matara, Mata! Kɨriir kwoɨnɨn haugɨhauga kɨpi whiyɨeki mɨ kɨpi naɨngwoyɨmiyok. Warɨ dimɨn whɨekakɨm kɨra mɨriiyɨm sɨmiirsiyɨn. ");
INSERT INTO iws_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kariir yai aiir nɨnoknɨnkɨnɨm mɨriiyɨm, saeya ɨni mɨi nhɨrɨm sɨmiir haibura, ta mɨiya Maria saeya nɨmbina saeya ɨni mɨi nhɨrɨm sɨmiir haibura. Mɨ kara saiirɨn pɨ nɨkropki rani. Nɨɨngaka. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Mɨ ɨigwɨra Jisɨs siya maeyau kwɨra saiir kwɨsboɨnkɨn Adi Komii siirɨm. Mɨ mhoɨiya siya ha kwɨsboɨn dɨgiyɨn mɨ inkam nwɨrɨn siir kɨgna mɨriiyɨn siir boɨnki, Bɨiyan Inkam Komii, kɨra krɨmiir dowomwarkai haigɨnɨu Adi Komii siiram kwɨsboɨniya bɨiya Jon siya kamɨm siir kɨgna mɨriiyɨm sɨmiir nowomwarkaiyɨuɨn saiir hɨriinan. ");
INSERT INTO iws_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Mɨ Jisɨs siya kamɨm siir kɨgna mɨriiyɨm sɨmiir boɨnki, ɨiya kɨma Adi Komii siirɨm kwɨsboɨniyɨm kɨma hɨnɨɨna kwɨsboɨn, krɨmiir Adi Komiiyɨn krɨma ha naɨngwowi iikamɨm sɨma kɨriir inɨg ɨiir hainanam daɨngwo. Mɨ ɨiya kɨra kɨriir iikam whɨekakɨm sɨmiir kɨgɨrkana ɨiya saeya nɨmbiyamana krɨma saiirɨm naɨngwowi. ");
INSERT INTO iws_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mɨ ɨinokɨinokɨn krɨma naeyɨm whaowaeiyɨm mɨ krɨma kɨriiram srɨiiyɨm mɨ kɨra naeyɨm pɨ krɨmiir dɨgar mɨ hauuwi. ");
INSERT INTO iws_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mɨ kɨra krɨmiir dimɨn biyɨeyɨm ɨriipɨ hɨriinan wa timɨ ɨnkɨn haiyoprimdiyɨumiigii. Mɨ ɨriipa hɨriinan krɨma haiyoprimdiyɨumiigiyɨm iikam krɨmiir tɨrbuwiyɨm sɨmiir dimɨn biyɨeyɨm sɨmiir hɨriinan. Mɨ kɨra hɨk komii krɨmiiram kɨpi kɨgnɨnkɨnki krɨmiir kɨnankɨuwam. ");
INSERT INTO iws_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Mɨ siya kamɨm siir kɨgna mɨriiyɨm sɨmiir boɨnki mɨ kɨmiir inkam nwɨrkɨn siya nomiiyau mɨiyɨkakɨ nɨuwi mɨ kɨra siir omaka hɨriir nami hɨrii tɨrii nɨibopwo kɨra kɨriir nomiiyau ɨiirɨmɨn hɨnɨɨna ninɨ kauwɨuwi, nomiiyau kɨra kariirɨn bretɨm nhouma whauugi. ");
INSERT INTO iws_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Dimusi rani, kariir nomiiyau nwɨrɨn siya siyɨu hɨr napniyɨn mɨ kariir omaka tɨriir yɨmbini, kara nae siir hauugi karamaeka. ");
INSERT INTO iws_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Mɨ tɨ inkamɨn omaka hɨranɨn siya ɨna yowarkɨi boɨnɨn, kɨra kɨigi kariir kɨpi nɨnki. Anowɨn bɨdi haigɨnɨkouwɨn. Kariir yɨnɨm krɨma nɨb bɨdi whwonkaiyɨm. Kara pɨ nɨni rani, dimɨn kɨriir hauugiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kara kɨmiir boɨnki, ta omaka saiir adɨn siya hɨnɨɨna naɨngwokɨn, ɨhɨ, siya kariir nomiiyau topmwokɨn mɨ kara nae siirɨn pɨ hɨriinan nɨi komiiya pɨ saiir hauu rani. Nɨɨngaka. Mɨ siya tɨ inkamɨn kɨra kauwoknanaeyɨn saiirsi nhakɨugɨn. Mɨ siya tɨ inkamɨn pa nɨnsiini mɨ siir naeyɨm pa hauugi. ");
INSERT INTO iws_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kara kɨmiir boɨnki mɨ kɨma Adi Komii siirɨm kwɨsboɨni mɨ siya kɨmiirɨn dimɨnɨn wa hauuwi. Mɨ kɨma dimɨnɨm hansɨri mɨ kɨma siirɨn wa kɨgi. Mɨ kɨma ano kaigakani mɨ Adi Komii siya anoɨn kɨmiiramɨn wa haiwaoki. ");
INSERT INTO iws_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mɨ iikam whɨekakɨm sɨma Adi Komii siirɨm kwɨsboɨniyɨm, sɨma dimɨnɨn wa hai. Mɨ inkamɨn dimɨnɨm hansɨriyɨn mɨ siya wa kɨgi. Mɨ inkamɨn ano kaigakani mɨ Adi Komii siya anoɨn siirɨmɨn wa haiwaoki. ");
INSERT INTO iws_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Mɨ kɨmiir inkam nwɨrkɨn, siir yɨnisɨmɨn anasuɨm siir ad ɨiirɨm kauwi mɨ adɨn siirɨn wɨ mɨpug biyɨeyɨn siir nama hauugi, aniya? Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Mɨ yɨnisɨmɨn ad ɨiirɨmɨn ɨpiyɨn yɨn kaskakam srɨi mɨ adɨn siirɨn pɨ owɨnyai biyɨeyɨn siir nama hauugi, iyɨe? Yɨo ɨriipa hɨriinan. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mɨ krɨma iikamɨm dimɨn biyɨeyar tɨrikɨm krɨma dimɨn mɨiyɨkɨn hindara mɨ prɨihauuwikɨm, krɨmiir yɨnisɨm ɨmiirɨn mɨ krɨma hɨriinanar dɨnoknɨnkɨn, Adi Komiiyɨn nɨnomor kouanɨn siya naeyɨu mɨiyɨkɨn, pɨ iikamɨm siirɨm kwɨsboɨniyɨm pɨ sɨmiirar swokɨ ɨnkɨn hauuwi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Uridyɨu biyɨeyɨn inkam waeyaiyɨn siir nwokaiyɨn Jisɨs siya haiswonɨskiigɨn tɨ inkamɨn siya waeyaigɨn. Mɨ uridyɨu biyɨeyɨn siya ha namɨn mɨ tɨ inkam waeyaiyɨn siya ɨna swokɨ boɨnaigiyɨn. Mɨ iikamɨm sɨma ɨni hindara yanaakiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mɨ kam nhɨrɨm sɨma boɨn, siya uridyɨu biyɨe biyɨeyɨm sɨmiirɨn Bielsebul siir kɨrɨeya saiir haiswonɨskiigɨn. Uridyɨu biyɨe sɨmiir bɨiyan inkamɨn siir inɨg whɨrɨn Setankɨn. ");
INSERT INTO iws_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Mɨ kam nhɨrɨm sɨma siirɨm kɨnankɨuwam naɨngwokɨm mɨ sɨma siirɨm asi kauwoknanaekikɨn kɨrɨepai kɨrɨepaiyɨm nɨnomor kou hɨranɨm sɨmiirɨm, sɨmiir nɨisiimauuam. Mɨ sɨma wa nwokɨ ɨnoknɨnkɨnɨm Adi Komii siya nɨmbinkɨn iikamɨm sɨmiir whɨndirɨraerarɨm. ");
INSERT INTO iws_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mɨ siya sɨmiir kwoɨn ɨmiir bɨdiyar yɨnoknɨnkɨnkiyɨn mɨ siya sɨmiir boɨnki mɨ nu whɨruwan iikamɨm sɨma isido whɨsa nwowi, yaii nɨniiyam mɨ tɨ iikamɨm sɨma wɨ mɨiyɨk nwo rani mɨ ad nwɨrni yɨnisɨmɨm sɨmani isido whɨsa nwoki, yai nɨniiyam mɨ sɨmani wɨ mɨiyɨk nwo rani. ");
INSERT INTO iws_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Mɨ Setan siir isidɨn whɨsa nwowi mɨ yaii sowa swokɨ ɨnii mɨ siir isidɨn wɨ kɨrɨe panɨɨn panɨɨna nwowi, ha? Kɨma hɨnɨɨna boɨnkɨm kara uridyɨu biyɨeyɨm Bielsebul siir kɨrɨeya saiir haiswonɨskigɨn. Ta yaiya saiir yaimwowa hɨnɨɨnga, Setan siir isidɨn whɨsa ywoki mɨ yaii ɨna yɨniiyɨm. Mɨ Setan siir isidɨn hɨriinan tɨri mɨ sɨma wɨ kɨrɨe nwo rani. Nɨɨngaka. Sɨma wɨ hindara kɨgugu ɨuguskii. ");
INSERT INTO iws_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mɨ kaimwokɨnɨuwi, Bielsebul siya kariir whɨnkɨnsiisi mɨ kara uridyɨu biyɨeyɨm sɨmiirɨn ha haiswonɨskii mɨ kɨmiir kamɨm sɨmiirɨn nɨɨnga whɨndirɨraerarkɨm mɨ uridyɨu biyɨeyɨm ha haiswonɨskikigɨm, ha? Nɨɨngaka. Kɨriir isidɨn sɨma bɨdi yɨnoknɨnkɨnɨm sɨmiirɨn Adi Komii siir kɨrɨeya saeyar haiswonɨskigɨm, Bielsebul siir kɨrɨeya sae rani. Nɨɨngaka. Warɨ yai hɨriinana kɨma kariir boɨnkiya, kɨma pɨ nɨksɨsaekɨɨngɨm. ");
INSERT INTO iws_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nɨɨngaka. Adi Komii siir kɨrɨeya saeyar haiswonɨskigɨn uridyɨu biyɨeyɨm. Mɨ ɨiya Adi Komii siya siir digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana saiir nɨisiimauuwi saeya kɨmiir bɨdi yɨmbiyama. ");
INSERT INTO iws_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Mɨ inkam kɨrɨe nwɨrɨn siya sau mɨnɨm siir omaka hɨrar sɨbgu hai okwokaowi mɨ siir digworaekwo whɨekakɨm wɨ wadɨeyar sɨbgu owi. ");
INSERT INTO iws_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mɨ inkam nwɨrɨn siya kɨrɨe komiigakɨn ɨni tɨ inkamɨn omaka hai okwokaowɨn siir kɨrɨe aiir haiburɨn mɨ siya siir sau kamkɨu mɨnɨm siir kɨnsiisiyɨm sɨmiir siinaiyɨn mɨ tɨ siir digworaekwo mɨnɨm ɨna hɨd hauugiyɨm, siir nomiiyau nhɨrɨm sɨmiir. ");
INSERT INTO iws_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Inkamɨn kariir whɨndiraerariyɨn yɨo kariir ɨoan inkam tani. Inkamɨn kariir whɨndirɨraerar karamae nwowiyɨn yɨo siya kariir ɨoan inkam ɨeya. Mɨ tɨ inkamɨn iikamɨm kariirɨm naɨngwo tɨbmiiyɨm sɨmiir tɨrbumbuwiyɨn mɨ tɨ hɨriinan inkamɨn yɨo siya iikamɨm sɨmiir kwoɨn ɨmiir whrɨewhrɨe haigɨnɨuwiyɨn mɨ ha nɨnoopamiyɨm ɨni sɨmiir hɨriinan ywowɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Mɨ ɨiya uridyɨu biyɨeyɨn siya inkam nwɨrni haiburgigiyɨm mɨpi maeyau kwɨra nami pɨu ninɨ siisnakiyam. Mɨ siya hɨriinan kɨg karamae nwowi mɨ siya pa boɨni, amba swokɨ ami omaka bɨiya kara haiburgiga saiiramar. ");
INSERT INTO iws_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Mɨ siya ɨna swokɨ amɨn tɨ inkamɨn bɨiya siya nikɨ owɨn siiramar mɨ siya ɨna inɨ kɨgɨuwɨn tɨ inkamɨn siya nɨɨnga nɨɨnga nwowi. Mɨ siya ɨni omaka inkamkɨ nhɨsiya mɨ ha pɨuaiiya inkamkɨ nɨtam ɨni saiir hɨriinan ywowa. ");
INSERT INTO iws_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Mɨ siya ha namɨn, uridyɨu biyɨe ɨriiyar nwɨso sɨmiir siyɨu biyɨeyɨn ɨni sɨmiir siyɨu biyɨe ɨmiir haiburɨm mɨ siya sɨmiir warar yɨnkɨn ɨkɨunam. Mɨ sɨma omakanan tɨ inkamɨn siir mhɨinau hɨriiyar yapnɨnopkainam. Tɨ inkamɨn bɨiya biyɨe nwowɨn mɨ tariinanɨn siya ɨni biyɨekɨ biyɨeyar yasae owoguskiyɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisɨs siya ta yai aiirɨn iikam isid komiiyɨn sɨma nwowa saiir boɨnkɨn. Mɨ wig ɨra sɨmaka hɨr nɨnkɨn owa saeya ɨna kauwok boɨnanaekiya, ta wiga bɨiya kɨriir naokaina mɨ mwoɨi kɨriir haigiyɨu ɨmiiyaeya, saeya ɨna maɨrgɨmaɨrga. ");
INSERT INTO iws_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Mɨ Jisɨs siya boɨnki, ɨhɨ mɨ iikamɨm Adi Komii siir yai wakaeyɨm mɨ siir mhoɨiya namɨm, sɨma ha maɨrgɨmaɨrga. Mɨ sɨma ɨni wadɨe nwowɨm, sɨmiir maɨrgɨmaɨrga ɨni kariir apua saiir maɨrgɨmaɨrga aiir haiburɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Mɨ iikam whɨekakɨm siir nokwoyokaiyɨm mɨ siya sɨmiirɨn ɨna boɨnmɨmauuwɨn, kɨma tɨ iikamɨm tɨr nwowɨm, kɨma dimɨn biyɨekakɨm. Iikamɨm kɨrɨepai kɨrɨepaiyɨm nɨkɨuɨm sɨmiir nɨisiimauuwam, Adi Komii siir kɨrɨeya kara boriisopi kɨmiir nɨisiimauuɨm. Mɨ kara dimɨn komii whɨrɨn pɨ kɨmiir nɨisiimauuwi, Jona siyaɨrgɨn. ");
INSERT INTO iws_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Bɨiya Jona siya anasu komiiya saiir mhɨinau namkiyɨn mɨ mhɨinau hɨrar yokai mɨ tɨ dimɨnɨn Adi Komii siya nɨisiimauugɨn, siir kɨrɨeya iikamɨm om komii Niniva hɨranɨm sɨmiir. Mɨ ɨriipɨ hɨriinan, kara Yaowae Adɨn nɨnomor kouanɨn tɨ iikamɨm tariinananɨm kɨmiir nɨisiimauuwi Adi Komii siir kɨrɨeya. Dimɨnɨn wɨ kariirar dirɨraerari mɨ kɨma Adi Komii siir kɨrɨe aiirɨn wɨ hanɨɨngɨ kɨgi. ");
INSERT INTO iws_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Bɨdi bɨdiniyarɨn wig ɨra inɨg komiigaka saeya nu Siva hɨrankɨn napiyokiyokɨinika saeya ɨi kasa bɨ napka. Saeya yai mɨiyɨk mɨiyɨkɨm inkam komiiyɨn nu kɨgrɨraowiyɨn Solomon siya boɨnɨm sɨmiir wakaeyɨm nɨtka. Kariir yaiyɨm ɨni Solomon siir yai ɨmiir haiburɨm mɨ kɨma kariir yai bɨ wakaeyoknakɨm. Mɨ ta hɨriinan ɨiya, Adi Komii siya siir iikamɨm sɨmiir hɨdni mɨ ta wig komiiya inɨgaka saeya kɨmiirɨn wɨ hɨnɨɨna nɨnsiin okwo boɨni, Adi Komii siya kɨmiirɨn wɨ hɨk komii hauuwi. Dimusi rani, kɨma siir yai mɨiyɨk mɨiyɨk ɨmiir bɨ wakaekɨm. ");
INSERT INTO iws_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ɨiya Jona siya Adi Komii siir yai kɨrɨeya saiir boɨnmɨmauuɨn mɨ om Niniva hɨran iikamɨm sɨmiir mhɨi kwoɨnɨm bɨdiyar kisɨna haigiiyɨm. Mɨ kariir yai kɨrɨeya saeya ɨni Jona siir yai kɨrɨe aiir haibura mɨ kɨmiir mhɨi kwoɨnɨm bɨ swokɨ kisɨna haigikɨm. Mhoɨiya Adi Komii krɨmiir Wanɨn siya iikamɨm sɨmiir hɨdɨm nɨti mɨ om Ninivan iikamɨm sɨma wɨ hɨnɨɨna nɨnsiin okwo boɨni, Adi Komii siya kɨmiirɨn wɨ hɨk prasae hauu rani. Dimusi rani, kɨma siir yai kɨrɨe aiir bɨ wakaeyoknakɨm mɨ kɨmiir mhɨi kwoɨnɨm bɨ kisɨna haigikɨm. Nɨɨngaka. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Mɨ iikamɨm paeya nɨuyaeiya ɨenau mɨ twonau mɨn bɨ haigiika. Nɨɨngaka. Mɨ sɨma romiyas ɨiirar ninankɨii mɨ iikamɨm sɨma napnɨnopkainami mɨ sɨma wɨ pae aiirar nwokɨ kɨgɨm. ");
INSERT INTO iws_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kɨmiir nhwoɨm paenan sɨmar nɨuya haigɨnɨuwi kwoɨn ɨiirɨn mɨ kɨmiir nhwoɨn dimɨn mɨiyɨk kɨgi mɨ kwoɨnɨn ɨriipa hɨriinan pɨ wadɨeyar mɨ naɨngwowi mɨ ɨni yɨukɨdɨn omaka bopwoniya hangomu haigɨniyɨn mɨ omaka ɨrkak aiirar nɨuya ɨrkakiya ɨni siir hɨriinan ywowɨn. Mɨ kɨriir nhwoɨn siya dimɨn biyɨe kɨgi mɨ kɨriir kwoɨnɨn wɨ biyɨeyar mɨ ɨnkɨn owi, omaka yɨukɨd haɨngɨmu haigɨn karamae nwowiya saiir hɨriinan mɨ omaka ɨrkaka wɨ saiir nɨuya rani. ");
INSERT INTO iws_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Mɨ kɨma sɨbgu wakaeyok, kɨmiir nhwoɨm omaka anonan kɨpi haiwaoki, wɨ dimɨn biyɨekɨ wara nɨnkɨn amisi. Mɨ wɨ kɨriir kwoɨn ɨiir tɨrbumbuwi. ");
INSERT INTO iws_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mɨ kɨriir kwoɨnɨn siya mɨiyɨk nwowi mɨ kɨriir siyɨuɨn ɨni wadɨeyar mɨ ɨnkɨn owɨn. Tɨ hɨriinan inkamɨn siir kwoɨnɨn paeya inkam nɨuya haigɨnɨuwiya ɨni saiir hɨriinan ywowɨn. Siya digworaekwo whɨekakɨm sɨmiir sɨbgu kɨgomokɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Mɨ Jisɨs siya ta yaiya saiir ha boɨn dɨgiyɨn mɨ Farisi inkam nwɨrɨn siya yɨkɨuna siirɨn saɨka naeyɨm. Mɨ siya ha napnɨnopkainamɨn siir omaka hɨriir mɨ hɨi aiir yɨdwokai. ");
INSERT INTO iws_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mɨ tɨ Farisi inkamɨn siya Jisɨs saɨka nɨdwokai aeyɨn siya ɨni nanaakakar yokiyɨn. Mɨ siyar kɨg Jisɨs siya op bɨ whaugɨn, Juda sɨmiir siyɨuɨn siya boɨna saiir hɨriinan mɨ siya nae ha bɨ naekɨn mɨ siya ɨna yaɨngwoyɨmiyokɨn. ");
INSERT INTO iws_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mɨ Bɨiyan Inkam Komiiyɨn siya siir boɨnki, kɨma Farisi kamɨm, kɨma kɨmiir pɨu aiirɨn ɨdananar hɨisokpraprasi mɨ kwoɨn kɨmiirɨn yɨo mɨiyɨk nwo rani. Mɨ kɨma ɨni inkamɨn mobmor mob mɨnɨm ɨdanara hɨisokiyɨn mɨ aowa ɨokakar nwowiyɨm mɨ kɨmiir mhɨi kwoɨnɨm ɨni sɨmiir hɨriinan ywowɨm. Inkam nwɨrniyɨm kɨgmar mɨ hɨi tauae tɨ hɨriinan siyɨuɨm. ");
INSERT INTO iws_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kɨma habwhaowaenankɨm! Adi Komii siya pɨu kwoɨn sowiirar nonkwokwokikɨn. Kɨma tɨ dimɨnɨn siir bɨ nɨnoknɨnkɨnkɨn, aniya? ");
INSERT INTO iws_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mɨ kɨmiir dimɨnpai dimɨnpaiyɨm inkam paeprikabɨm sɨmiir hauuwi, naeyɨm mobmor mobnau nwokaiyɨm sɨmiir hɨriinan mɨ kɨmiir mhɨi kwoɨnɨm Adi Komii siir whwonkam ɨda wɨ wadɨekɨ wadɨeyar nwowɨrkaki. ");
INSERT INTO iws_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Farisi kamɨm kɨma mɨntarao! Dimusi rani, digworaekwo whɨekakɨm kɨma haiiyɨm haɨmii pɨ Adi Komii siirar mɨ hauuwi. Tɨ siyɨu hɨriinanɨn yɨo wadɨeyaɨrgɨn. Mɨ kɨma iikam nhɨrɨm sɨmiir swokɨ haimriiyɨugii mɨ kɨma Adi Komii siirɨm bɨ naɨngwowaokɨm. Bɨiya kɨma siyɨu mɨiyɨk ɨiir tikɨ tɨr mɨ Adi Komii siiram daɨngwo mɨ tɨ dimɨn komii komiiyɨm sɨmiir tɨr, tɨ hɨriinan siyɨuɨn siya wadɨeyɨn. Tɨ siyɨuɨn kɨma tɨrɨn dimɨn haɨmiiyɨm Adi Komii siir hauuɨm yɨo siyɨu wadɨekɨn siir kɨpi haiburgik. Mɨ tɨ dimɨn komii whɨrɨn Adi Komii siirɨm naɨngwonanaeyɨn siir warar dɨnkɨn tɨr. ");
INSERT INTO iws_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Farisi kamɨm, kɨma mɨntarao! Kɨma omaka Adi Komii siir yai nɨdwokai wakaeiya, pɨ iikamɨm sɨmiir whwonkam ɨda hɨrar nɨdwokaiyamar maɨrgɨmaɨrgaeikɨm sɨma kɨmiir boɨn maɨrgɨmaɨrgam. Mɨ kɨma mɨnam mɨ aɨngwowikɨm maeyaua ɨrɨpa yai nɨdwo boɨnaiiya iikamɨm sɨma kɨmiir inɨg ɨmiir nwokɨ hainanɨm. ");
INSERT INTO iws_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kɨma mɨntarao! Kɨma ɨni ɨeyɨn inkam whɨigɨ nwokaiyɨn owainɨe krɨn karamae nwowiyɨn mɨ iikamɨm sɨma siir ɨdwowar nɨnap anapi, sɨma nɨnoknɨnkɨn tani. Mɨ iikamɨm sɨma kɨmiirɨn hɨnɨɨna kɨgi kɨma mɨi mɨiyɨka mɨrii mɨ ta mɨi mɨiyɨka ɨni nuɨn inkam whɨi prɨigɨntɨmdɨɨnuiyɨn siir hɨriinan ywowɨn. Mɨ kɨmiir mhɨi kwoɨnɨm ɨni biyɨekɨ biyɨe ywowɨm mɨ sɨma nɨnoknɨnkɨn tani mɨ sɨma kɨmiir yai ɨmiir asi naɨngwo tɨbmiigɨm. ");
INSERT INTO iws_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mɨ inkam nwɨrɨn siyɨu komii nɨnoknɨnkɨniyɨn siya siir yai aka hɨnɨɨna yowarkɨi boɨn, inkamɨn yaimɨn dimɨnɨm sɨm nowomwarkaiyɨuwiyɨn, wara yaiya kɨra boɨnkiya kɨra hɨk krɨmiir wara nɨnkɨn hauugii. ");
INSERT INTO iws_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jisɨs siya ɨna yowarkɨi boɨnɨn, kɨma kamɨm siyɨu komii nowomwarkaiyɨuwiyɨm kɨma ha timɨ ɨnkɨn mɨntarao! Dimusi rani, kɨma siyɨu kasaka bɨ haigɨnkɨm Adi Komii siir siyɨuɨn saɨka nɨnkɨn owɨm mɨ inkamɨm sɨmiirɨn wɨ wakaeyokna dɨg rani. Kɨma siyɨupai siyɨupai ɨmiirar haigɨni mɨ sɨma kam nhɨrɨm siyɨu komii siir sɨbgu nɨnoknɨnkɨn karamae nwowiyɨm sɨmiir bɨ whɨndirɨraerikɨm. Nɨɨngaka. Mɨ sɨmiirɨn hɨk komii komii ɨmiirar hauuwi. ");
INSERT INTO iws_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kɨma mɨntarao! Bɨiya kɨmiir yɨdiwi wanwiyaeyɨm sɨma profet inkamɨn Adi Komii siir yai aiir boɨnmɨmauuɨm sɨmiir nɨsom aowɨm mɨ sɨmiir ɨeyɨm kɨmar pɨuai haigɨnɨu. Mhoɨiya sɨma nwokɨ kɨgnɨnoknɨnkɨnɨm. ");
INSERT INTO iws_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Tɨ siyɨuɨn, kɨma kam nhɨrɨm sɨmiir mhɨi kwoɨn ɨmiirɨn hɨnɨɨna nɨisiimauugɨn mɨ kɨma siyɨuɨm bɨiya krɨmiir yɨdiwi wanwiyaeyɨm sɨma tɨrɨm sɨmiiramar maɨrgɨmaɨrgaei mɨ tɨ hɨriinan kwoɨnɨn ɨni sɨmiir hɨrar nwowɨn. Mɨ profet inkamɨm kɨma nɨsomsom aokaokɨm mɨ ɨeyɨm sɨmiir haɨngikaiyɨm ɨni kɨmar pɨuaiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Mɨ Adi Komiiyɨn bɨdiya yɨnoknɨnkɨnɨn bɨiyan Yokwo Komiiya siya hɨnɨɨna wɨn boɨnkikɨn, kara wɨ profet kamɨm mɨ aposel kamɨm sɨmiirɨn wɨ iikamɨm Isrelanɨm sɨmiiram nɨkropki mɨ sɨmiirɨn wɨ kam nhɨrɨm sɨma nɨnkɨnaeyokiyok ɨsomsom aokaowi. Mɨ nhɨrɨm hɨk kɨmpɨpɨsu ara hauugigi. ");
INSERT INTO iws_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Mɨ tariinanɨn kara wɨ iikamɨm nu Isrel tɨranɨm wɨ hɨk kɨmiir hauuwi, bɨiya kɨmiir yɨdiwi wanwiyaeyɨm sɨma nɨsomsom aokaowɨm profet kamɨm sɨmiir. Mɨ kara kɨmiirɨn wɨ saiirsi swokɨ ɨtrinaei. Mɨ Adi Komii siya bɨdi bɨdinana nɨdwo kɨgiyokiyokɨigɨn tɨ nu ɨeyar whɨuwɨnɨuna kɨma profet kamɨm sɨmiir nɨsomsom aokaowɨm mɨ ɨni tarinana yamwoniyɨn. ");
INSERT INTO iws_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Bɨikɨ bɨiyan profetɨn Ebel siir yɨsomao mɨ ɨni mhoɨigɨ mhoɨiyan profetɨn Sekaraia siirar yadɨgniyɨn. Sɨma siirɨn Adi Komii siir omaka saiir bopwo hɨrar nɨsomaokɨn. Ɨhɨ, kara kɨmiir boɨnki, tɨ iikamɨm nu tɨr nwowɨm. Kara kɨmiirɨn wɨ dimɨn biyɨe ɨiirar nonkwobumbunɨnkɨn haigɨnɨuwi, tɨ siyɨu biyɨeyɨn bɨiya kɨma tɨrɨn siirsiyɨn! ");
INSERT INTO iws_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Kɨma kamɨm siyɨu komii nowomwarkaiyɨuwiyɨm kɨma mɨntarao! Kɨma siyɨuɨn Adi Komiiniyɨm namiyɨn siirɨn ɨna nɨnoknɨnkɨnɨn. Mɨ kɨma tɨ siyɨu ɨiir wakaeyoknam naɨngwo rani. Mɨ inkam nwɨrkɨn Adi Komii siir siyɨu ɨiir napɨm naɨngwowi. Sɨma wɨ dɨg nwo rani. Dimusi rani, kɨma siyɨu kasaka bɨ haigɨnkɨm mɨ sɨmiir siyɨuɨn ɨni kɨma haigɨnokouwɨn. Kɨma inkam biyɨe kɨɨngɨm. Kɨma ɨni inkamɨn omaka nae haigiiya saiir anowɨn siir haigɨnokougigiyɨn ɨni siir hɨriinan ywowɨn. Mɨ kɨma nae sɨmiir bɨ hauugɨn mɨ sɨma yaba hɨrar nwowɨm ɨna yaonamɨm. ");
INSERT INTO iws_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Mɨ Jisɨs siya ta omaka aiir haiburgigɨn mɨ ha napniyamɨn mɨ kamɨm siyɨu komii sɨm nowomwarkaiyɨuwiyɨm sɨma yai siir boɨn hɨuriiyɨuɨm yɨnkɨnyaeyaowɨm. Mɨ sɨma siir yai aiirɨm mɨ kɨnɨnkɨu siya yai bibiyɨe boɨnɨm, dɨg bɨ nwokɨm. ");
INSERT INTO iws_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Mɨ sɨma ɨni siiramar kaowɨm, yai biyɨe kwɨrkɨ pɨ siir yai hɨranka kwɨmbini mɨ sɨma siirɨn wa nwokɨ ɨsomaowɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Iikam kasaka rani, hɨr nwomɨmɨrɨm. Sɨma ɨni ɨrɨpa ɨrɨpa ywonamɨm. Mɨ nhɨrɨm sɨmiir ɨga ɨdwowar nɨnkɨn okwo nami. Mɨ takɨ ɨiya Jisɨs siya kamɨm siir kɨgna mɨriiyɨm bɨi sɨmiir ikɨ boɨnmɨmauugig, kɨma sɨbgu mɨntarao Farisi sɨmiir yis ɨiirsiyɨn. Kara sɨmiir siyɨuɨn yaiyaɨrgɨ nhɨnkɨniyɨm sɨmiir boɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mɨ Farisi sɨmiir yaiyɨm mɨ siyɨu biyɨe whɨekakɨm tariinanɨn aowa aowa nwowɨm mɨ mhoɨiya sɨma wɨ idowɨiyar nɨmbiyami. Mɨ nɨmprɨo yai whɨekakɨm mhoɨiya sɨmiirɨn wɨ inkamkar nɨnoknɨnkɨn ɨuguskii. ");
INSERT INTO iws_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Mɨ yai whɨekakɨm bɨiya nɨiyɨɨm nɨiyɨɨm kɨma nɨmprɨo boɨnɨm mɨ mhoɨiya iikamɨm sɨma sɨmiirɨn wɨ idowɨiyar kɨgɨrkaki nabɨenan. Mɨ yai whɨekakɨm hiinsɨm hiinsɨma kɨma boɨnɨm omakanau hɨr mɨ mhoɨiya wɨ Adi Komii siyar nɨisiimauu ɨuguski mɨ wɨ iikam whɨekakɨm wɨ sɨmar wakae ɨrkaki. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Kariir nomiiyauwɨm, kara kɨmiirɨn pɨ hɨnɨɨna boɨnkii kɨma inkamkɨ kɨmiir nɨsomaosi kɨpi nɨdid. Mhoɨiya sɨma kɨmiirɨn dimɨn whɨr swokɨ tɨrbu rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mɨ inkamɨn kɨma nɨdidanɨn mɨ kara kɨmiirɨn wɨ siir nɨisiimauuwi. Kɨma siirsi dɨdid Adi Komii siiyaɨrgɨn sɨma kɨmiir nɨsom aowi. Mɨ Adi Komii siya kɨrɨekakaɨrgɨn mɨ mhoɨiya siya inkamɨm sɨmiir pɨugɨna wɨ maeyau biyɨeya paekaka saiir mɨ ɨtkaigi. Ɨhɨ, kara kɨmiir boɨnki, kɨma Adi Komii siirsiyar dɨdid. ");
INSERT INTO iws_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Kɨma dɨnoknɨnkɨn, inkamɨm sɨma ɨpiyɨn sɨsɨm ɨriiyarɨm umɨrsɨm kwɨso (02 toea) sowiir saɨngɨn. Mɨ Adi Komii siya tɨ hɨriinan ɨpiyɨn sɨm ɨra saiir bɨ swokɨ aɨngwowowouwika ɨiya saeya naowiya. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Mɨ kanɨm kɨmiir mwo nwowɨm siya bɨdi mwaɨnɨm mɨ nuan iikamɨm kɨma sɨmiirsi kɨpi nɨdid, kɨma ɨni ɨpiyɨn sɨsɨm whɨekakɨm sɨmiir haiiburɨm mɨ Adi Komii siya wɨ kɨmiirar kɨgrɨraowi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Kara kɨmiir boɨnkii mɨ inkam nwɨrkɨn kariir inɨgɨn iikam whɨekakɨm sɨmiir whwonkam ɨda boɨnmɨmauuwi mɨ ɨriipa hɨriinan, Yaowae Adɨn nɨnomor kouanɨn kara kɨriir inɨgɨn wɨ Adi Komii siir paekwosɨmɨm sɨmiir whwonkam ɨda mɨ boɨnmɨmauuwi. ");
INSERT INTO iws_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mɨ inkamɨn kariir inɨgɨn iikam whɨekakɨm sɨmiir whwonkam ɨda nɨmprɨowi mɨ ɨriipɨ hɨriinan kara siir inɨgɨn wa mɨ ɨmprɨowi Adi Komii siir paekwosɨmɨm sɨmiir whwonkam ɨdaɨn. ");
INSERT INTO iws_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Mɨ inkam nwɨrkɨn Yaowae Adɨn nɨnomor kouanɨn yai biyɨe kwɨr siir boɨni mɨ Adi Komii siya siir dimɨn biyɨeyɨm wa haiyoprimdiyɨumiigi. Mɨ inkamɨn Adi Komii siir naeyɨuɨn siir nɨkbumbuwi mɨ Adi Komii siya siir dimɨn biyɨeyɨm sɨmiirɨn wɨ haiyoprimdiyɨumiigi rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Mɨ sɨma kɨmiir nɨkɨu nami omaka Adi Komii siir yai nɨdwokai wakaeiya saiir hɨriir. Mɨ inkam komii komiiyɨm gavmaniyɨm mɨ kamɨm inɨgakɨm sɨmiir whwonkam ɨda hɨriir mɨ kɨma kɨpi nɨdid mɨ ha kɨpi naɨngwo. Mɨ krɨma sɨmiir yai aka wɨ panɨɨna nowarkɨi boɨni, ha? Mɨ krɨma wɨ paka hɨnɨɨn yaiya saiir boɨni sɨmiirɨn? ");
INSERT INTO iws_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mɨ tariinanɨn kɨmiirɨn pɨ Adi Komii siir naeyɨuɨn siyar kwɨisiimauuwi, yaiya kɨma ninɨ boɨnɨuwi sɨmaka. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Inkam nwɨrɨn tɨ iikam isid komiiyɨn siir hɨranɨn, siya Jisɨs siir boɨnki, iikam nowomwarkaiyɨuwiyɨn kɨra kariir yaowaeyɨn siirɨn pɨ hɨnɨɨna boɨn, siya krɨriir adɨn siir digworaekwowɨm pɨ kwɨsa sɨoɨtkɨn hɨd. Mɨ kwɨra pɨ kariir whauu. ");
INSERT INTO iws_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mɨ Jisɨs siya siir yai aka hɨnɨɨna yowarkɨi boɨnki, pɨ panɨɨna tɨri, yɨpɨkɨ kariir nɨmbinɨn kɨmiir digworaekwo mɨnɨm sɨmiir hɨdam, ha? ");
INSERT INTO iws_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Mɨ siya sɨmiirɨn ɨna swokɨ boɨnkiyɨn, kɨma mɨntarao! Kɨma sɨbgu kɨgrɨraowi mɨ kɨma wɨ dimɨn whɨrɨm kɨgmaɨr tani. Mɨ inkamɨn digworaekwo whɨekakakɨn siirɨn kwoɨn mɨiyɨk wɨ tɨ digworaekwowɨm sɨma hauu rani. Nɨɨngaka, nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Mɨ Jisɨs siya boɨniyɨo yaiya kwɨra boɨn sɨmiirɨn mɨ umɨr digworaekwo whɨekakak, inkamɨn mɨ siir nuɨn sasae mɨiyɨkar niigɨn. ");
INSERT INTO iws_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mɨ siya siir kwoɨnau hɨrɨn hɨnɨɨna yaɨngwokai, kara pɨ panɨɨna tɨri? Kariir numɨran sasae whɨekakɨm sɨmiirɨn omaka haigi dɨg karamaeka mɨ sɨmiirɨn wa haigi dɨg rani. ");
INSERT INTO iws_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Mɨ siya boɨn, kara wɨ hɨnɨɨna tɨri. Kara wɨ kariir omakaɨm nae haigiiyɨm wɨ sɨmiir nɨinɨmnhɨnkiigi mɨ wɨ komii komii ara mɨrii. Mɨ kariir wit whɨekakɨm mɨ sasae mɨiyɨk mɨiyɨk whɨekak ɨkɨm, wɨ tɨ omaka ɨmiir haigii. ");
INSERT INTO iws_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mɨ mhoɨiya kara wɨ hɨnɨɨna nwokɨ boɨnɨm, kara dimɨn mɨiyɨkak inkamkɨn. Tɨ kariir nae dimɨn mɨiyɨk whɨekakɨm wɨ bɨewii kasaka nwo rani. Mɨ kara nae opmɨn kwiyaei mɨ kara wɨ hiinsɨmhiinsɨma maɨrgɨmaɨrga nwowi. ");
INSERT INTO iws_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mɨ Adi Komii siya siir boɨnki, kɨra inkam habwowhaekɨn, ta nɨiyaka kɨra pɨ saiirar nao nami mɨ digworaekwo whɨekakɨm kɨra dirɨraerargikɨm wɨ nhɨnga haii? ");
INSERT INTO iws_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Mɨ Jisɨs siya ɨna swokɨ boɨnkiyɨn ɨriipɨ hɨriinan inkamɨn siya digworaekwo whɨekak ɨmiir haɨngiriyɨu haigɨnmɨmɨriiyɨn siyamar mɨ siya Adi Komii siir whwonkam ɨda wɨ digworaekwokak nwo rani. Nɨɨngaka. Siya wɨ inkam paeprikabnan nwowi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Mɨ Jisɨs siya kamɨm siir kɨgna mɨriiyɨm sɨmiir boɨnki, kara kɨmiirɨn pɨ hɨnɨɨna boɨnki, kɨma kɨmiir pɨu aiirsi kɨpi naɨngwoyɨmiyok mɨ hɨnɨɨna kɨpi boɨn, krɨma wɨ dimu naei? Mɨ kɨma kɨmiir pɨu aiirsi kɨpi naɨngwoyɨmiyoknanae. Mɨ hɨnɨɨna kɨpi boɨn, krɨma krɨmiir pɨua wɨ dimu dimɨn nɨtɨmwanɨuwi? ");
INSERT INTO iws_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kwoɨn budɨn yɨo nae siir hɨriinan tani. Mɨ pɨua ya yɨuɨs saiir hɨriinan tani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kɨma ɨpiyɨnɨm sɨmiir kɨgnɨnoknɨnkɨnki sɨma sasae bɨ nɨnkɨnikɨm mɨ sɨma sasae bɨ nɨngugu haiigɨm mɨ sɨma nae bɨri haɨngiriyɨu haigɨnikɨm. Mɨ sɨma nae digworaekwo mɨnɨm, sɨmiir omaka karamaekɨm. Mɨ sɨmiirɨn naeyɨm Adi Komii siyar hauuwikɨm. Adi Komii siir kwoɨnɨn hɨnɨɨna naɨngwowi, kɨma ɨni ɨpiyɨn ɨmiir haiburɨm! ");
INSERT INTO iws_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mɨ yɨpɨkɨ inkamkɨn siya bɨewii nhɨrɨm omwai swokɨ haɨnɨs waiyayokiyokɨiyɨm swokɨ aɨngwowɨn, ha? ");
INSERT INTO iws_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mɨ kɨma hɨriinan dimɨnsɨm whɨr tɨr karamae nwowi mɨ kɨmiir kwoɨnɨm tɨ hɨriinan dimɨn whɨr ɨiirsi dimusi naɨngwoyɨmiyokɨm, ha? Mɨ kɨma hɨriinan kɨpi tɨr. ");
INSERT INTO iws_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Kɨma kɨp ɨmiir kɨgi sɨma mwrɨiyɨm mɨ sɨma yɨuɨs mɨnɨm sɨma sɨma bɨ mɨriinanaeikɨm. Nɨɨngaka. Bɨiya Solomon siya pɨuai mɨiyɨk whɨekakaɨrgɨn. Mɨ siir pɨuaiyɨm tɨ kɨpɨm sɨmiir bɨ haiburgɨm. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ɨhɨ, digworaekwo whɨekakɨm Adi Komii siya nonkwokwowɨm wadɨekɨwadɨeyaɨrgɨm. Kowɨm panaoɨn sɨma pɨ numɨr hɨr whaki mɨ ko ɨmiirɨn wakar swokɨ akɨtkaigaigi paenau hɨriir. Mɨ tɨ kɨp hɨriinanɨm yɨm Adi Komii siya pɨuaiigɨm mɨ kɨpa ya dimɨn komii rani. Mɨ kɨmiir naɨngwo tɨbmiiya komii rani mɨ iikam kɨma ɨni kou ywowɨm. Mɨ kɨma hɨriinana timɨ ɨnoknɨnkɨnkɨɨn. Adi Komii siya wɨ kɨmiirar mɨ sɨbgu kɨgrɨraowi mɨ kɨmiir digworaekwo whɨekak ɨkɨm. ");
INSERT INTO iws_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Mɨ kɨma hɨnɨɨna kɨpi naɨngwoyɨmyok boɨn, krɨma wɨ dimu dimɨn naei mɨ wɨ papiyan op mɨ kwiyaei. ");
INSERT INTO iws_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Sɨma kamɨm naɨngwo tɨbmii karamaeyɨm tɨ nuɨn siir tɨranɨm, sɨmiir kwoɨnɨm tɨ dimɨn hɨriinanɨm sɨmiirɨmar naɨngwokwo nanaeikɨm. Mɨ kɨmiir Adɨn siya bɨdi yɨnoknɨnkɨnɨn, kɨma wɨ pɨkɨ hɨnɨɨn dimɨnɨn siir haii. ");
INSERT INTO iws_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mɨ kɨma Adi Komii siya siir iikamɨm sɨmiir kɨgɨrkakana kɨmiir kwoɨnɨm saiirɨm naɨngwokɨɨni mɨ tɨ dimɨn hɨriinanɨm siya wɨ kɨmiirar nɨnkɨn hauuwi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kɨma kariir iikamɨm sibsib nanɨm kɨma kɨpi nɨdid. Dimusi rani, kɨmiirɨn Adi Komii siya bɨdi yɨmbinɨn siir digworaekwo whɨekakɨm yɨm wɨ kɨma kɨgrɨraowi. ");
INSERT INTO iws_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mɨ kɨma digworaekwo whɨekakɨm kam nhɨrɨm sɨmiir hauuwi mɨ sɨma saɨni mɨ tɨ umɨrɨm inkam paeprikabɨm sɨmiir hauu. Tɨ hɨriinan siyɨuɨn mhoɨiya wɨ siya whɨndirɨraerar haigɨnɨuwi dimɨn mɨiyɨk mɨiyɨkɨm. Adi Komii siir omɨn dimɨn biyɨe whɨrkɨ bɨ swokɨ tɨrbuwikɨn. Mɨ nɨnomor kou hɨrɨn dimɨnkɨ bɨ swokɨ kɨguguwikɨn mɨ hɨiyan inkam karamaekɨn mɨ dimɨn ɨmiirɨn kɨkomkɨ bɨ swokɨ krɨpikɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mɨ maeyauwa kɨriir dimɨn mɨiyɨk mɨiyɨkɨm sɨma nwowɨm mɨ kɨriir kwoɨnbudɨn omwai waiyayokiyokɨiyɨn wɨ tɨ om ɨiirar minɨ owouwi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Mɨ kɨma yɨuɨsɨm haruwa kisɨna kainam mɨ pɨuwop aka kigoknam. Mɨ yɨukɨdɨn kɨma hangumuwi mɨ ha dwo, dimɨnɨn mhoɨiya nɨmbiniyanɨn siirɨm. ");
INSERT INTO iws_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Kɨma ɨni kamɨm sɨmiir bɨiyan inkam ɨiirɨm nwokwokɨniyɨm sɨmiir hɨriinan ywowɨm. Sɨma wigwas naeya saiir naenakiyɨm mɨ ɨna swokɨ ɨtɨm. Mɨ siya nɨnmiga hɨr naka okwo kɨekɨkomni mɨ sɨma anowɨn wa haiwao sasaugi. Mɨ Adi Komii siiramɨn hɨriinana sɨbgu okwokɨn. ");
INSERT INTO iws_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mɨ bɨiyan inkamɨn siya nɨti, siya siir mɨiyan kam ɨmiirɨn hɨnɨɨna ninɨ kɨgɨuwi sɨma nhwo bɨ whwonkaigɨm mɨ tɨ mɨiyan kamɨm sɨma ha maɨrgɨmaɨrga. Kara kɨmiirɨn yaimwowar boɨni mɨ bɨiyan inkamɨn siyarɨn wɨ yɨuɨsa mɨiyana wɨ saiir kisɨna kaii pɨuwopaka mɨ siya wɨ kɨmiir boɨnki, kɨma hɨiya saiir dɨdwo mɨ kɨmiirɨn nae wɨ siyar hauu aei. ");
INSERT INTO iws_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mɨ siya nɨibopwo nɨti mɨ bɨiyan ɨuumɨn haigigi mɨ siya ha kɨgi sɨma ɨni siir mɨiyar mɨriiyɨm mɨ tɨ mɨiyan kamɨm sɨma ha maɨrgɨmaɨrga. ");
INSERT INTO iws_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kɨma tɨ dimɨn ɨiir daɨngwo. Mɨ omakaɨn adɨn siya bɨiya nɨnoknɨnki hɨiyan inkamɨn pɨ kariir omaka nɨti mɨ siya tɨ hɨiyan inkamɨn siirɨn wɨ kɨgnɨnkɨn apnɨnopkai rani, siir omaka hɨriirɨn, siir digworaekwo ɨmiir haiyam. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kɨma ɨriipɨ hɨriinan ha timɨ o kɨugɨu kariiram. Dimusi rani, kara Yaowae Adɨn nɨnomor kouanɨn ɨiya kara nɨti kɨma wɨ saiir nɨnoknɨnkɨn tani. Nɨɨngaka. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Mɨ Pita siya Jisɨs siir srɨi, Bɨiyan Inkam, kɨra ta boɨniyɨo yaiya krɨmiirarar hauuwi, iyɨe? Mɨ inkam nhɨrɨm sɨmiir wara rani. Aniya? ");
INSERT INTO iws_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mɨ Jisɨs siya ɨna yowarkɨi boɨnɨn, panɨɨn bɨiyan inkam ɨkɨm, kwoɨn mɨiyɨkakɨn siir mɨiyan kamɨm sɨmiir sɨbgu kɨgrɨraowiyɨn? Tɨ hɨriinan inkamɨn yɨo siya bɨiyan inkamɨn siya nɨmbinkɨn siir mɨiyan kamɨm sɨmiir kɨgrɨraowɨm. Sɨmiir naeni ɨi aiirɨn wɨ siyar nwokɨ ɨnoknɨnkɨn haigɨnɨuwɨm. ");
INSERT INTO iws_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mɨ mhoɨiya Bɨiyan Inkam Komiiyɨn siya wɨ sɨpi swokɨ ɨti. Mɨ siya tɨ mɨiyan inkamɨn siirɨn hɨnɨɨna ninɨ kɨgni, bɨiya siya boɨngigɨn saiir hɨriinana swokɨ mɨriiyɨn mɨ siya wɨ siir boɨni Kɨriir mɨiya wadɨeka, tɨ hɨriinan mɨiyan inkamɨn siya wɨ maɨrgɨmaɨrga komiigaka mɨ owi. ");
INSERT INTO iws_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Kara kɨmiirɨn yaimwowar boɨni, Bɨiyan Inkam Komii siya siir mɨiyan inkamɨn wɨ siir digworaekwo whɨekakɨm sɨmiir kɨgrɨraowan bɨiyan inkam nokmwɨn owaigɨnɨuwi. ");
INSERT INTO iws_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mɨ tɨ mɨiyan inkam nwɨrɨn siir kwoɨnɨn tari wɨ hɨnɨɨna naɨngwowi, kariir Bɨiyan Inkam Komiiyɨn nikɨ ɨtsɨsau rani. Mɨ siya siir mɨiyan iikamɨm sɨmiirɨn ha tɨoɨn mɨ siya nae op mɨnɨm mɨ opa kwiyae whaowaeiya mɨ siya saiirɨn ɨna kwiyaeyɨn. ");
INSERT INTO iws_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Mɨ siya hɨriinan tɨri mɨ tɨ inkamɨn siir bɨiyan inkamɨn siya nɨti, ɨiya tɨ mɨiyan inkam ɨeya nwowɨn karamae nwowa saiir mɨ siya wɨ nɨnoknɨnkɨnwɨn tani ɨiya siya hindara kɨnkak ɨti. Mɨ siir bɨiyan inkamɨn, siirɨn wɨ hanɨɨngɨ nonkwobumbunɨnkɨn haigɨnɨuwi. Mɨ siya siirɨn wɨ ɨkɨ siir mɨiyan kam nhɨrɨm siir yai aiir wakaeyokna karamae nwowɨm, wɨ sɨmakar nɨnkɨn ɨkropkii. ");
INSERT INTO iws_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Mɨ inkamɨn siya siir bɨiyan inkamɨn siir yai ɨmiirɨn bɨdiyar yɨnoknɨnkɨnɨn mɨ siya bɨiyan inkamɨn siya boɨnɨn sɨmiir bɨ wakaeyokna dirɨraerarkɨn mɨ siirɨn bɨiyan inkamɨn siya ɨdgɨuni wɨ kasaka nɨpɨmpar tani. ");
INSERT INTO iws_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mɨ mɨiyan inkamɨn siya bɨiyan inkamɨn siir kwoɨn ɨiir nɨnoknɨnkɨn karamae nwowi mɨ siya mɨi mɨiyɨk mɨrii karamae ha nwowi mɨ siirɨn ɨdgɨuɨn wɨ komii nɨpɨmpar tani, bɨiyan inkamɨn siya. Mɨ yɨpɨkɨ iikamkɨm digworaekwo whɨekak Adi Komii siya hauuwɨm mɨ sɨma hoɨmgak mɨrii digworaekwowɨm sɨmiir swokɨ iyopkɨiyɨuwɨm yamdi. Mɨ yɨpɨkɨ iikamkɨm digworaekwo Adi Komii siya swokɨ ɨnkɨn hauuwɨm mɨ tɨ iikamɨm sɨma tɨ digworaekwowɨm sɨmiir swokɨ iyopkɨiyɨuwamɨn, kɨma mɨi nhami nhami kɨpi mɨrii. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Mɨ Jisɨs siya boɨn, kara iikamɨm sɨmiir nɨinɨkibɨrɨm nɨtkɨn inkamɨn pae nɨkrɨmtɨowiyɨn haɨmii haɨmiiya siir hɨriinan. Kara hɨnɨɨna naɨngwowi tɨ dimɨnɨn siya dɨmbiyamki. ");
INSERT INTO iws_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Bɨiyɨn kara hɨk mɨ kɨmpɨpɨsu mɨ wa naonami, wɨ sɨmiir nikɨ haii. Mɨ tɨ dimɨnɨn siya nɨmbinisiyɨn ta kariir hɨka wɨ hɨriiya nikɨ oyokiyokwɨii. ");
INSERT INTO iws_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mɨ kɨmiir kwoɨnɨm ha naɨngwowi, kara nu tɨrɨn yaiiyɨm sɨmiir nikwowaisiiyɨm nɨtkɨn. Nɨɨngaka. Kara kɨmiir boɨnki. Kara iikamɨm sɨmiir nɨinɨkibɨrɨm nɨtkɨn. ");
INSERT INTO iws_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mɨ tariinan mɨ mhoɨiya ɨriipɨ hɨriinan iikam ɨriiyarɨm sɨma omaka ɨrni nwowi mɨ isidɨn wɨ whɨsa nwowi ouumɨm wɨ ɨso sowaka nɨnii mɨ ɨso wɨ ouumɨm sɨmaka nɨnii. ");
INSERT INTO iws_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mɨ iikamɨm sɨma wɨ yapayapa nwoki. Mɨ adɨn wɨ siir yɨnisɨm yɨnkamiyɨnɨn saɨka swokɨ kwɨnii mɨ yɨnisɨm yɨnkamiyɨnɨn wɨ siir adɨn saɨkar swokɨ ɨnii. Mɨ yopiiya wɨ saiir yɨnisɨm yɨnugiyɨna saɨka swokɨ kwɨnii mɨ yɨnisɨm yɨnugiyɨna wɨ saiir yopi anakar swokɨ kwɨnii. Mɨ giwaiya wɨ saiir yɨniwig anakar kwɨnii mɨ yɨniwiga wɨ saiir giwai anakar mɨ nɨnii. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Mɨ Jisɨs siya ha boɨn dɨgiyɨn, siya iikamɨm sɨmiir boɨnki, kɨma ha kɨgikɨm waua maeyaua bɨekɨ nɨkiiyamtɨbiyɨn hɨrankɨ nɨmbiniya mɨ kɨma bɨ kɨmɨmɨnkikɨm pa boɨnki, naoɨn kɨnɨm mɨni? Mɨ kaimwowaɨrga naowɨn ha kɨnikɨn. ");
INSERT INTO iws_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Mɨ kɨma hɨnɨɨna kɨgiwɨi ɨiya krakrarwaiga mɨ kɨma pɨ hɨnɨɨna boɨni waka bɨewii prasae nɨkii rani. Mɨ saeya wɨ hɨriinana mɨ ɨmbiyami. ");
INSERT INTO iws_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kɨma yaiyaɨrgɨ nhɨnkɨni inkamɨm! Kɨma nu nɨnomor sowiir dimɨnɨm sɨmiirar bɨdi sɨbgu kɨgnɨnoknɨnkɨnɨm. Mɨ kɨma ta mɨiya Adi Komii siya mɨriiya saiir nɨnoknɨnkɨn karamae dimusi nwowi, ha? Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Mɨ kɨma siyɨu mɨiyɨkɨn siir sɨbgu naɨngwo hɨd karamae dimusi nwokɨm mɨ ha dirɨraerarɨm, ha? ");
INSERT INTO iws_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ɨiya kɨra boɨnam nami inkamɨn kɨriir boɨnhɨuriyɨu boɨnɨn saɨka boɨnɨm, kowa siyɨu hɨrar nikɨ owamiywo mɨ ta ɨiya kowa ɨrɨpa yai saiirar sɨbgu boɨnam. Mɨ kowa hɨriinan tɨr karamae nwowi mɨ siya kɨriirɨn wɨ inkamɨn yai hɨdiyɨn siirɨm nɨkɨu namisi mɨ inkamɨn yai hɨdiyɨn siya wɨ poris inkamɨn siir ɨɨn hauugiisi mɨ poris inkamɨn kɨriirɨn wɨ maeyaua hɨuyokiyokaiya mɨi biyɨe mɨriiya saiirɨm nɨkropkisi. ");
INSERT INTO iws_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kara kɨmiir boɨnkii, kɨra maeyauwa hɨuyokiyokaiya saiirɨn wɨ nikɨ haiburgig sasau rani. Bɨi kɨra digworaekwo whɨekakɨm kɨra nikɨ prɨi haiyɨm, sɨmiir tikɨ hauukɨiyɨu dɨg. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mɨ ta ɨi aiirɨn iikam nhɨrɨm hɨrar nwokɨm mɨ sɨma Jisɨs siirɨn kam nhɨrɨm Galiliyanɨm sɨmiir boɨnmauu. Mɨ kamɨm wraisu Adi komii siir nɨnkɨn ɨmiiyaeyɨm, Adi Komii siir omaka aiir sɨma ha namɨm mɨ Pailat siir isidɨn warar yɨnkɨn apnɨnopkainam. Mɨ sɨmiirɨn ɨni sɨmar yɨsomaowɨm mɨ sɨmiir nhɨeyɨm ɨni wraisu nhɨeyɨm sɨmaka yɨnkɨn okiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Mɨ Jisɨs siya sɨmiir boɨnki, kɨmiir kwoɨnɨm ha naɨngwowi, tɨ Galiliyan inkam nhɨrɨm hɨnɨɨna naowɨm, sɨmiir dimɨn biyɨeyɨm ɨni iikam nhɨrɨm Galiliyanɨm sɨmiir dimɨn biyɨe ɨmiir haiburɨm, aniya? Nɨɨngaka, nɨɨngakɨɨnga. ");
INSERT INTO iws_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kara kɨmiirɨn pɨ hɨnɨɨna boɨni. Nɨɨngaka, nɨɨngakɨɨnga! Mɨ kɨmiir mhɨi kwoɨnɨm kisɨna haigi karamae nwowi mɨ kɨma wɨ hindara kɨgugu ɨuguski sɨmiir hɨriinan. ");
INSERT INTO iws_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Mɨ bɨiya tɨ iikam ɨuur ɨriiyar nwoɨmɨm om Siloam siir hɨran omaka bripriya saeya nɨrɨmdɨnu aokaowɨm, kɨma panɨɨna naɨngwowi tɨ iikamɨm sɨmiir dimɨn biyɨeyɨm ɨni iikam nhɨrɨm om komii Jerusalem hɨranɨm sɨmiir dimɨn biyɨe ɨmiir haiburɨm, aniya? Nɨɨngakɨ, nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kara kɨmiirɨn pɨ hɨnɨɨna boɨni. Nɨɨngaka, nɨɨngakɨɨnga! Kɨmiir mhɨi kwoɨnɨm kisɨna haigi karamae nwowi mɨ kɨma wɨ hindara kɨgugu ɨuguski. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Mɨ Jisɨs siya boɨniyɨo yai kwɨra ɨna swokɨ boɨnɨn, inkam nwɨrɨn siya swapwo wɨra yɨnkɨn siir wain numɨra saiirɨn mɨ mhoɨiya siir paenid ɨiirɨm yɨt. Mɨ ɨni nɨɨnga ywowɨn. ");
INSERT INTO iws_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Mɨ siya numɨran mɨiyan inkamɨn siir asi boɨnkikɨn, kɨgi. Mɨ bɨiya bɨewii whoɨmɨm kara tɨ swapwoɨn siirɨn hɨnɨɨna bɨ kɨgɨn. Siya naekak bɨdi ywowɨn. Nɨɨngaka. Siya ɨni hɨriinana swokɨ okrɨpkaiyɨn. Mɨ kɨra siirɨn dɨigi. Mɨ siya nu siir hiiya whɨsariiyar nɨugugusi. ");
INSERT INTO iws_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mɨ numɨr hɨran mɨiyan inkamɨn siya ɨna yowarkɨi boɨnɨn siir yai anakan, Bɨiyan Inkam Komii, kɨra siirɨn tɨ bɨewii ɨiirara tikɨ kɨgnɨnkɨn osasae. Kara siir mɨiyɨn wa hambɨmbɨri mɨ whrɨnɨm wa krɨnkɨnki. ");
INSERT INTO iws_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mɨ nae wɨ ɨkɨ bɨewii whɨrɨn siir budi. Mɨ nɨɨngakɨnɨuwi mɨ kɨra wa dɨigi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mɨ Juda sɨmiir ɨi komiiya pɨu siisiya dimɨn taemɨn tɨr karamae nwowiya Jisɨs siya iikamɨm sɨmiirɨn maeyauwa Adi Komii krɨmiir Wanɨn siir yai nɨdwokai wakaeiya saiir hɨr nowamwarkaiyɨugɨn. ");
INSERT INTO iws_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mɨ wig ɨra hɨr nwoka mɨ uridyɨu biyɨe whɨrɨn saiir nwokɨn mɨ tɨ uridyɨu biyɨeyɨn siya ma saiir hauuwɨn bɨewiyɨm ɨuur ɨriiyar whoɨmgɨm. Mɨ ta wiga saiir digɨukɨuɨn asi nɨnsɨmsɨrɨugɨn mɨ saeya panɨɨnsi sɨbgu okwosi. ");
INSERT INTO iws_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Mɨ Jisɨs siya saiir kɨgɨn mɨ saiirɨn ɨna yɨkɨunan mɨ siya saiir boɨnki, ta wiga kɨriir dimɨn biyɨeyɨm kara bɨdi haiyoprimdiyɨumiigiyɨm. Mɨ kɨra ɨni wadɨeyar sɨbgu okiya. ");
INSERT INTO iws_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Mɨ siir ɨɨna ta wiga saiir yonkwoki mɨ bɨ kɨmɨmɨnkika saeya ɨna sɨbgu okwo tɨdwokiya. Mɨ saeya ɨni Adi Komii siir inɨg ɨiirar hainankiya. ");
INSERT INTO iws_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mɨ prismi bɨiyan inkam komiiyɨn maeyauwa Adi Komii siir yai nɨdwokai wakaeiya saiir bɨi nwowiyɨn, siir mhɨi kwoɨnɨm ɨni haugɨhauga whiyɨekiyɨn Jisɨs siya ta wiga Judami ɨi komiiya Sabat pɨu siisiya dimɨn taemɨn tɨr karamae nwowiya ɨni saiir haiswonɨskiyɨn. Mɨ siya sɨmiirɨn hɨnɨɨna boɨnki. Mɨi mɨrii ɨiyɨm ɨriiyar kwɨrkɨm. Mɨ kɨma mɨnam naɨngwowi inkamkɨ kɨmiir ma ɨmiir haiswonɨskiyɨm. Mɨ kɨma mɨini ɨi ɨmiirar wɨt. Kɨma tɨ dimɨn hɨnɨɨnɨn Judami ɨi komiiya pɨu siisiya dimɨn taemɨn tɨr karamae nwowiya saiir kɨpi nɨt. ");
INSERT INTO iws_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mɨ Jisɨs siya siir yaiyaka hɨnɨɨna yowarkɨi boɨn, kɨma yai aɨrga nhɨnkɨnɨn inkamkɨm! Judami ɨi komiiya pɨu siisiya dimɨn taemɨn tɨr karamae nwowiya Sabat saiirɨn, kɨma whɨekakɨm pa nami omaka bulmakaumiya saiir mɨ sɨmiirɨn pa mɨ ɨkɨunami sɨma op ninɨ kwiyaeyɨuwɨm. ");
INSERT INTO iws_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mɨ taka wiga saeya, Ebraham siir isidɨn sɨmiir yɨnisɨmka. Bɨewiyɨm Setan siya nonkwowɨm saiir ɨuur ɨriiyar whoɨmgɨm. Mɨ ɨni wadɨeyar mɨ owa, ta wiga saeya ɨni tɨ bulmakauwɨm sɨmiir haiburɨm mɨ kara ta wiga Judami ɨi komiiya Sabat saiir asi haiswonɨskigɨn. ");
INSERT INTO iws_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Mɨ Jisɨs siya hɨriinan boɨnɨn mɨ kamɨm ɨo siir nwowɨm sɨma nɨdid prasae bɨ kɨnkɨm mɨ sɨma ɨni yai mɨkrɨma ywokiyɨm. Mɨ iikam whɨekakɨm sɨma ɨni maɨrgɨmaɨrga ywokiyɨm tɨ dimɨn komii komiiyɨm siya tɨrkiyɨm sɨmiiramɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Mɨ Jisɨs siya ɨna swokɨ owarkɨi boɨnɨn, Adi Komii siya siir iikamɨm sɨmiir kɨgɨrkakana, saeya ɨni dimu dimɨnan ywowa? Kara saiirɨn pɨ dimu nɨkrii, ha? ");
INSERT INTO iws_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Adi Komii siir isidɨn sɨma ɨni tɨ paenid whɨrɨn siir hɨriinan ywowɨn, krɨma dapiyɨn mastet. Mɨ mhoɨiya siya wɨ pae komiinan namwoɨuwɨn mɨ siya ɨni pae nhɨrɨm sɨmiir haiburɨn. Mɨ ɨpiyɨn whɨeyɨm ɨni siir kwiya ɨmiir haigiiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Mɨ siya ɨna swokɨ boɨnɨn, kara Adi Komii siya siir iikamɨm sɨmiir kɨgɨrkakana wɨ dimu dimɨn nɨkrii, ha? ");
INSERT INTO iws_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tɨ iikamɨm sɨma yisnankɨm. Mɨ wig ɨra yisɨn plaua two komii saɨka prɨdgika. Mɨ mhoɨiya tɨ plauan ɨna iyopingiyɨn mɨ ɨni saa yɨmbiiyamɨn. Mɨ Adi Komii siir iikamɨm wɨ hɨriinan nɨmbiyami. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Mɨ ɨiya Jisɨs siya om komii Jerusalem hɨriir namɨn mɨ om komii komii mɨ omisɨsɨmɨm sɨmiir hɨran iikamɨm sɨmiir warar yowɨmwarkaiyɨuam Adi Komii siir yai aiir. ");
INSERT INTO iws_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mɨ inkam nwɨrɨn siir srɨigi, Bɨiyan Inkam Komii, Adi Komii siya krɨmiirɨn wɨ nhɨrmiyarar nanmaiwarkainaei saɨka ninɨ owouwam iyɨe? Nɨɨngaka, aniya? Mɨ Jisɨs siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨnki, ");
INSERT INTO iws_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","kɨma kɨmasiyar mɨntaraona. Mɨ kɨma mɨinan mɨrii tɨ nɨnomor kouan anosɨmɨn siir napnɨnopkainamamɨn. Anoɨn karargɨn, iikam whɨekakɨm sɨma hɨriir namamar naɨngwowi mɨ sɨma wɨ dɨg nwo rani. ");
INSERT INTO iws_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mɨ omakan Adɨn saiir anoɨn wɨ siyar nɨnsiin haigɨnɨkouwi. Mɨ kɨma wɨ yaba hɨrar ninɨ okwo kaigakan boɨni, Bɨiyan Inkam Komii, kɨra anoɨn krɨmiiram haiwaoki! Mɨ kɨmiirɨn wɨ hɨnɨɨna nowarkɨi boɨni, kara kɨmiir nɨnoknɨnkɨn tani, kɨma papiyan omankɨ nɨtkɨm? ");
INSERT INTO iws_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mɨ krɨma siir yai aiirɨn wɨ hɨnɨɨna nowarkɨi boɨni, bɨiya krɨma nae op mɨnɨm kɨnakar nae kwiyaekɨn. Mɨ kɨra krɨmiir oman siyɨu ɨiir nokwoɨn mɨ krɨmiirɨn ɨni kɨrar yowomwarkaiyɨuɨn dimɨn taemɨn ɨmiirɨn. ");
INSERT INTO iws_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mɨ siya wɨ kɨmiir swokɨ boɨnki, kara nɨnoknɨnkɨn tani kɨma papiyankɨm, kɨma siyɨu biyɨe tɨran iikamkɨm, kɨma dimɨn biyɨekak kamkɨm kariir haiburgik mɨ ha dam! ");
INSERT INTO iws_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Mɨ kɨma wɨ Ebraham, Aisak, Jekop mɨ profet inkam whɨekakɨm Adi Komii siya siir iikamɨm sɨmiir kɨgɨrkakana saiir nwowɨm mɨ wɨm kɨma damki yab hɨrar dwoki! Mɨ kɨma wa kauwaeyɨmiyok ouwi mɨ kɨmiir bigmɨuɨm wɨ kɨkiyɨkɨkiyɨka kɨni ɨo nwowɨmɨn. ");
INSERT INTO iws_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Mɨ iikam bɨekɨ nɨmbiniyɨn mɨ bɨekɨ nɨkiiyamiyɨn mɨ maeyau kwɨran ɨkɨm, sɨma wɨ ɨiya Adi Komii siya siir dimɨn taemɨnɨm mɨ siir iikamɨm sɨmiir kɨgɨrkakana wɨ saiirar nɨnkɨn ɨdwokai aei. ");
INSERT INTO iws_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ɨhɨ, iikamɨm tariinan inɨg komii karamae nwowɨm mɨ mhoɨiya inɨg komiigak wɨ sɨma nwowi. Mɨ iikamɨm tariinan inɨg komiigak nwowɨm mhoɨiya sɨma wɨ inɨg komiigak nwo rani. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mɨ bɨ kɨmɨmɨnkikɨn ta ɨi aiirarɨn Farisi kam nhɨrɨm sɨma ɨna yɨtɨm mɨ siir boɨnmauu, kɨra tɨ omɨn siir haiburgik mɨ maeyau kwɨra dam. Herotɨn kɨriir nɨsomaowam tɨri. ");
INSERT INTO iws_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Mɨ Jisɨs siya sɨmiir boɨnki, kɨma wra biyɨeyɨn siirɨn hɨnɨɨna tinɨ boɨnɨu. Wakae, panao waka kara pɨ uridyɨu biyɨeyɨm mɨ kamɨm makakɨm pɨ sɨmiir nikɨ haiswonɨmnɨskɨi. Mɨ mhoɨiya kariir mɨiyɨm dɨgi mɨ kara pɨu wa siisi. Herot siya wɨ kariir nɨsomao rani mɨ wɨ kariir mɨi aeyar nadɨgɨuwi. ");
INSERT INTO iws_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Mɨ panao waka uga kara wa napnami. Dimusi rani, sɨma profet inkamɨn kariirɨn om whɨr kɨpi nɨsomao. Nɨɨngaka. Sɨma kariirɨn Jerusalem hɨrar dɨsomao ɨski. ");
INSERT INTO iws_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalem, Jerusalem, profet inkamɨm kɨrar nɨsomsom aokaowikɨn mɨ kamɨm Adi Komii siya kɨmiiram nɨkropkiyɨm, kɨma siiyani sɨmiirar mɨ kaiyɨmɨkikɨm. Mɨ ɨi kasa rani, kara kɨriir yɨnisɨsɨmɨm sɨmiirɨn ɨrɨpa haɨngiriyɨu kɨgrɨraowama tɨri, kakaruk yopiiya saiir hɨriinan ywowɨn saeya saiir yɨnɨm saiir pɨdga aowa hopkrɨmkrɨkɨuwiyɨm. Mɨ kɨma pɨ boriisopi. ");
INSERT INTO iws_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Wakae! Tariinanɨn Adi Komii siya digɨumii kɨmiir om ɨiir bɨdi haimriiyɨugiyɨn kɨmiir omɨn kɨmar kɨgrɨrao, kara kɨmiir boɨnki. Mɨ kɨma wɨ kariir kɨg rani mɨ tɨ ɨi aeya nadɨgɨuwi ɨiya kɨma hɨnɨɨna boɨni, Adi Komii kɨra tɨ inkamɨn kɨriir inɨgɨ nɨtɨn siir whɨnkɨnsiis mɨ wadɨe siir dwowaigɨnɨu! Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Mɨ Juda sɨmiir ɨi komii kwɨra Sabat pɨu siisiya dimɨn taemɨn tɨr karamae nwowiya Jisɨs siya Farisimi bɨiyan inkamɨn siir omaka hɨr ninɨ aeyɨugɨn. Iikamɨm sɨma ɨni siiramar kaoraraowɨm, siya inkam haiswonɨskiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mɨ inkam nwɨrɨn siir pɨua noni aokaowɨn, Jisɨs siir kingiinar nwokɨn. ");
INSERT INTO iws_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Mɨ Jisɨs siya tɨ inkam ɨiir kɨgɨn mɨ kamɨm siyɨu komii nɨnoknɨnkɨniyɨm, Farisi kamɨm siya sɨmiir srɨigi mɨ ɨna boɨnɨm, Moses siir siyɨuɨn wadɨe bɨdi ywokiyɨn. Mɨ krɨma inkam makakɨn ta Judami ɨi komiiya pɨu siisiya Sabat dimɨn taemɨn tɨr karamae nwowiya saiirar haiswonɨski, iyɨe? Nɨɨngaka? ");
INSERT INTO iws_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mɨ sɨma ɨni wakaemumuɨm. Mɨ Jisɨs siya tɨ inkamɨn siirɨn ɨna yɨkɨunan mɨ ɨna haiswonɨskiyɨn mɨ siirɨn ɨna yɨkropkiyɨn. ");
INSERT INTO iws_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Mɨ Jisɨs siya sɨmiir boɨnki mɨ inkam nwɨrɨn kɨmiir bopwoniya waraurɨn, siir yɨnisɨmɨn mɨ siir bulmakauɨn siya ɨe whɨra namai whɨriidami mɨ tɨ inkamɨn siya siirɨn wɨ Judami ɨi komiiya pɨu siisiya dimɨn taemɨn tɨr karamae nwowiya wɨ saiir haisasauki rani, iyɨe? Nɨɨngaka? ");
INSERT INTO iws_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mɨ sɨma ta yaiya siya boɨna, saiirɨn yai kwɨr bɨ nowarki boɨnkɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisɨs siya ta nae aiiram nɨtɨm kamɨm sɨmiir kɨgɨn sɨma bɨiyan ipiiyɨm sɨmiir nɨdwokaigɨm. Mɨ siya boɨniyɨo yai kwɨra sɨmiir asi boɨnkɨn, siya ɨna boɨnɨn. ");
INSERT INTO iws_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Mɨ inkam nwɨrkɨ kɨriir nɨkɨunami, wigwas nae komiiya saiirɨm. Mɨ kɨra ipiiya bɨiyana saiir kɨpi nɨdwokai. Dimusi rani, tɨ inkamɨn siya wɨ inkam inɨg komiigakɨn kɨriir haiburɨn siir nɨkɨunaeisi. ");
INSERT INTO iws_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Mɨ hɨriinankɨ nɨuwi, tɨ inkamɨn kɨriir nɨkɨunaɨn siya kɨriirɨn wɨ hɨnɨɨna boɨni, kɨra ta bɨiyan ipiiya tɨ inkamɨn siir hauugi mɨ kɨra wɨ nɨdid komiigakar nwowi kɨra mhoɨigɨ mhoɨiyan ipiiya saiir ninɨ ɨdwoɨuwi. ");
INSERT INTO iws_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mɨ kɨra hɨriinan kɨpi tɨr mɨ ɨiya inkam nwɨrɨn kɨriiram nɨkɨugi naeyam kɨra mhoɨiyan ipiiya saiirar tinɨ ɨdwoɨu. Kɨra hɨriinan tɨri mɨ tɨ inkamɨn kɨriir nɨkɨunaɨn siya nɨti mɨ siya wɨ kɨriir boɨni, nomiiyau kɨra ta bɨiyan ipiiya saiir winɨ ɨdwokaini. Mɨ siya hɨriinan tɨri. Mɨ kɨra wɨ inɨg komiigakar nwowi tɨ iikamɨm kɨnaka nɨdwokai aeyɨm sɨmiir whwonkam ɨda. ");
INSERT INTO iws_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Inkamɨn siir inɨg ɨiirar hainanaeiyɨn, siirɨn wɨ Adi Komii siya nikwowaisii. Mɨ inkamɨn siyamar naɨngwona karam nwowiyɨn mɨ siir inɨgɨn wɨ Adi Komii siya haigɨnki kougɨkou. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Mɨ Jisɨs siya tɨ inkamɨn naeyɨm siirɨm nɨkɨunaɨn sɨmiir boɨnki mɨ kɨra nae kwɨr dirɨraeri, kɨra kɨriir nomiiyau nomousɨm mɨ kɨriir ɨrɨpa isidɨn sɨmiir kɨpi nɨkɨuna mɨ kɨriir ɨrɨpa omom umɨr hoɨmgakakɨm. Mɨ mhoɨiya wɨ sɨma nɨkɨunaeisi kɨra sɨmiir omaka hɨr ninɨ aeyɨuɨm mɨ sɨma wɨ nae kɨriir swokɨ hauukɨiyɨusi. ");
INSERT INTO iws_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nɨɨngaka. Kɨra nae komii dirɨraerari mɨ kɨra wɨ inkam paeprikabɨm mɨ iikamɨm pɨu sɨmiirɨm biyɨe nwowɨm mɨ ɨga biyɨekakɨm mɨ nhwokwɨsaeyɨm sɨmiir dɨkɨuna. ");
INSERT INTO iws_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tɨ hɨriinan iikamɨm sɨma naei wɨ kɨriir swokɨ ɨkɨuna hauu ae rani mɨ kɨra wa maɨrgɨmaɨrga. Dimusi rani, mhoɨiya nae kɨriirɨm, wɨ Adi Komii siya swokɨ hauuwi dimɨn mɨiyɨkɨm kɨmiir, ɨiya iikam mɨiyɨk mɨiyɨkɨm sɨma swokɨ ɨnsiin ɨdwowi ɨe hɨrankɨn saiir. Sɨma ɨinokɨinokɨn wɨ saɨkar nwoyokiyokɨii. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tɨ iikam nae saɨka naeyɨm sɨmiir nwɨrɨn siya ta yai aiir wakaekiyɨn mɨ siya Jisɨs siir boɨnki, inkamɨn Adi Komii siir iikamɨm sɨmiir maeyaua kɨgɨrkakana, saiir nɨdwokai aei siya ha maɨrgɨmaɨrga. ");
INSERT INTO iws_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mɨ Jisɨs siya siir boɨnki, inkam nwɨrɨn nae komii bɨdi dirɨraerarɨn. Mɨ siya iikam whɨekakɨm sɨmiir bɨdi yɨmbinɨn ta naeya saiirɨm nɨtɨmɨn. ");
INSERT INTO iws_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mɨ naeni ɨiya ha nɨmbiyama mɨ siya siir mɨiyan inkam ɨiir yɨkropki, siya iikamɨm bɨiya siya nɨmbinɨm sɨmiir nɨkɨunakiyɨm. Siya sɨmiirɨn hɨnɨɨna boɨn: Kɨma wɨt. Digworaekwo whɨekakɨm bɨdi dirɨraerar dɨgɨm. ");
INSERT INTO iws_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Mɨ iikamɨm sɨma sɨma hɨnɨɨna yomboɨn amboɨn, krɨma wɨ nam tani. Inkam nwɨrɨn siya mɨiyan inkamɨn siir boɨn, kara numɨra kwɨra saɨn, kara pɨ saiir ninɨ kɨgɨuwi. Kaimwoka kara pɨ nam tani naeyɨmɨn. Kara kɨriir naeyam bɨ nɨtkɨn mɨ kara pɨ boriisopi kɨra ɨo saiirsi kɨpi nwo. ");
INSERT INTO iws_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mɨ nwɨrɨn ɨna mɨ boɨnkiyɨn, kara mɨi mɨriiyɨm bulmakauɨm ɨuura saɨn mɨ kara sɨmiir ninɨ kɨgɨuwam mɨni. Wakae! Kara pɨ nam tani. Kara kɨriir naeyam bɨ nɨtkɨn mɨ kɨra pɨ ɨo kariir kɨpi nwo kara pɨ boriisopi. ");
INSERT INTO iws_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Mɨ nwɨrɨn ɨna mɨ boɨnɨn, kariir wiga tapa nonkwonaka kara pɨ nam tani, kɨriir nae aiiramɨn. ");
INSERT INTO iws_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Mɨ tɨ mɨiyan inkamɨn ha swokɨ amɨn siir bɨiyan inkam ɨiiram mɨ tɨ yaiyɨm sɨmiir inɨ boɨnmɨmauuɨu. Mɨ omakaɨn adɨn siir kwoɨnɨn ɨni haugɨhauga whiyɨekiyɨn mɨ siir mɨiyan inkam ɨiir boɨnki, kɨra ha damsɨsauu siyɨusɨsɨmɨm tɨ omɨn siirɨm mɨ kɨra kam paeprikabɨm mɨ kamɨm pɨu sɨmiirɨm biyɨe nwowɨm mɨ nhwokwɨsaeyɨm mɨ ɨga biyɨe ɨkɨm. Kɨra sɨmiirɨn kariir omaka tɨriir wɨkɨunani. ");
INSERT INTO iws_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mɨ mhoɨiya tɨ mɨiyan inkamɨn siya boɨn, bɨiyan inkam, kara kɨriir yai aiirar bɨdi wakaeyoknan mɨ ipii nhɨrɨm ɨni nɨɨnga nikɨ owɨm. ");
INSERT INTO iws_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Bɨiyan inkamɨn mɨiyan inkam ɨiir boɨn, kɨra siyɨu komii sɨmiir omisɨsɨm whɨekakɨm sɨmiir dam. Mɨ iikamɨm sɨmiir wɨkɨuna nɨnopkainani. Kara mɨnam naɨngwowi kariir omaka mɨrnɨnkɨnkiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kara kɨriir boɨni. Tɨ iikam whɨekakɨm bɨiya kara nikɨ ɨkɨunam, sɨma wɨ kariir naeya saiir swokɨ ae rani. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Iikam isid komiiyɨn Jisɨs saɨkar napnamkɨm mɨ siya ha haimasiyao kaowɨn mɨ sɨmiir boɨnki. ");
INSERT INTO iws_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Mɨ inkamɨn kariirɨm nɨti mɨ siya siir ad yopii wig mɨ yokman mɨ siir nomousɨsmɨm digɨumii sɨmiir haimriiyɨugig mɨ digworaekwowɨm siir kwoɨnkɨ naɨngwo ɨkɨm mɨ hɨriinan tɨr karamae nwowi sɨma wɨ kariir mhoɨiya nɨt rani. ");
INSERT INTO iws_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yɨpɨkɨ inkamkɨn kariir mhoɨiya nɨti mɨ siya paeyɨn hɨiniya nɨrɨonɨnkɨnɨn siir haisi nɨdidi mɨ tɨ hɨriinan inkamɨn siya wɨ kariir mhoɨiya sɨbgu ɨt rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Mɨ kɨmiir nwɨrkɨn siya omaka bripri ɨra mɨriinaiinamɨm mɨni koua hɨriir mɨ bɨi siya pɨ nikɨ sɨbgu ɨdwo hɨdi, ta omaka saiir mɨriiyan naemar ɨmiiram siya nikɨ ɨnoknɨnkɨnɨm siir naeyɨm wɨ ta omaka saiirar dɨgi, iyɨe? Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mɨ siya bɨi hɨriinan tɨr karamae nwowi mɨ mhoɨiya sɨma yɨn ninansiingiyɨm mɨ siya ta omaka saiir mɨrii nɨnokou karamae nwowi. Mɨ iikamɨm sɨma wɨ siir nɨewaeyɨuwi. Mɨ sɨma wɨ hɨnɨɨna boɨni, ");
INSERT INTO iws_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","tɨ inkamɨn ta omaka saiir mɨriiyɨn, siya wɨ saiir mɨrii nɨnokougik rani. ");
INSERT INTO iws_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Mɨ inkam komiiyɨn nu kɨgrɨraowiyɨn, siya inkam komii nwɨrɨn nu kɨgrɨraowiyɨn yaii saɨka nɨnii mɨ siya pa nikɨ ɨdwo hɨdnami. Mɨ siyarɨn siir sauan kamɨm (10 Tausen) hoɨmgak karamaekɨ nɨuwi mɨ inkam komii nwɨrɨn siir sauan kam ɨma ywo hoɨmgak (20 tausen) mɨ siya bɨi tikɨ sɨbgu hɨd mɨ siirɨn wɨ tɨ inkam komii nwɨrɨn siir isid ɨeya niyopakaiyɨuwi, iyɨe? Nɨɨngaka? ");
INSERT INTO iws_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mɨ siya hɨnɨɨna naɨngwowi, kara wɨ dɨg nwo rani mɨ siir sauan omomɨn aru hɨrar nikɨ owɨm, kam nhɨrɨm saiirar nɨkropki, tɨ ɨo aiir nokwowaisiiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mɨ ɨriipɨ hɨriinan mɨ kɨmiir nwɨrkɨn siya siir digworaekwo whɨekakɨm digɨumii sɨmiir haimriiyɨuwi mɨ siya sɨbgu naɨngwo karamae nwowi mɨ siya wɨ kariir kɨgna mɨriiyan inkam nwo rani. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Wa siya dimɨn mɨiyɨkɨn. Mɨ wa siya hii karamae nwowi mɨ tɨ wa siirɨn wɨ panɨɨna swokɨ tɨri, siya wadɨe swokɨ amwoɨuuwamɨn, ha? ");
INSERT INTO iws_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tɨ hɨriinan waɨn naeyaka siir bɨ prɨdikɨn. Mɨ krɨma siirɨn nu mɨiyɨk nɨtkiigi numɨran sasaeyɨm wɨ mɨiyɨk sɨbgu ii rani. Wakae, kɨma hindarar prɨi ɨtkaigi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Mɨ ɨigwɨra kamɨm omom omomi umɨr haiiyɨm mɨ kam nhɨrɨm dimɨn biyɨe tɨriyɨm mɨ kam nhɨr ɨkɨm, sɨma Jisɨs siir kingiina yɨt siir yai ɨmiir wakaeyam. ");
INSERT INTO iws_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mɨ Farisi kamɨm mɨ kamɨm siyɨu komii nɨnoknɨnkɨniyɨm sɨma ɨo nwokɨm Jisɨs siirɨn mɨ sɨma hɨnɨɨna boɨn, tɨ inkamɨn kamɨm dimɨn biyɨe tɨriyɨm nae sɨmaka nɨdwokai aekɨn. ");
INSERT INTO iws_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mɨ Jisɨs siya ta boɨniyɨo yaiya sɨmiir asi boɨnkɨn ");
INSERT INTO iws_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","mɨ kɨmiir inkam nwɨrkɨ siir sibsibɨm kamaɨrɨm ɨriiyarkɨ nɨuwi, (100) mɨ siir sibsib ɨrɨn whaowaei mɨ siir adɨn wɨ panɨɨna tɨri? Mɨ siya tɨ sibsib kamnwii ɨuur ɨriiyar ɨdiyɨm (99) wɨ hɨrar haiburgigi mɨ yɨm wɨ hɨrar nokwo aekii. Mɨ siya wɨ tɨ sibsib ɨrɨn siirɨm ninɨ hansɨr ɨuwi. ");
INSERT INTO iws_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mɨ siya siir hansɨr haii mɨ siya siirɨn wɨ siir waeyao niwouu apnami. Mɨ siya pɨ maɨrgɨmaɨrga nwonami. ");
INSERT INTO iws_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Mɨ ɨiya siya siir omaka hɨriir swokɨ ɨmbiyami mɨ siya wa kauwok boɨnami siir nomiiyauɨm mɨ siir inkamnanɨm, sɨmiiramɨn, ɨrɨpa saɨka haɨngiriyɨu owɨm. Mɨ siya wɨ sɨmiir boɨnki, kɨma kanaka timɨ maɨrgɨmaɨrga! Dimusi rani, kariir sibsib ɨrɨn nikɨ whaowaekiyɨn kara siir bɨdi hansɨryɨskai haiyɨn. ");
INSERT INTO iws_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kara kɨmiir boɨnkii mɨ nɨnomor kou hɨran iikamɨm yɨm ɨni, ɨriipɨ hɨriinanar mɨ owɨm. Mɨ iikam kamnwii ɨuur ɨriiyar nwiiyɨm, (99) sɨma ha naɨngwowi, sɨma dimɨn biyɨe bɨ tɨrkɨm mɨ sɨma tɨ hɨriinan iikam ɨmiirɨn maɨrgɨmaɨrga wao kɨntani. Mɨ dimɨn biyɨe inkam nwɨruwakar tɨri mɨ siir kwoɨnɨn ha kisɨna haigii mɨ nɨnomor kou hɨrɨn wɨ maɨrgɨmaɨrga komiiya nwowi siiramɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Mɨ wiga umɨr ɨuurgakɨ nɨuwi mɨ mhoɨiya kwɨra ɨna swokɨ whaowaekiya mɨ saeya wɨ panɨɨna tɨri, ha? Saeya wɨ ɨriiyasmɨr pae bignaei. Mɨpa bigna nhɨskɨg kaeyami, saiir bɨdi mɨ kɨga. ");
INSERT INTO iws_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Mɨ saeya hansɨr haii mɨpa kauwok boɨnki saiir nomiiyauɨm mɨ saiir inkam inkamnanɨm, sɨma ɨrɨpɨ nwowɨm. Mɨ saeya ɨna boɨnkiya, kɨma maɨrgɨmaɨrga kanaka dwo! Kariir umɨr kwɨra nikɨ whaowaekiya bɨdi swokɨ hansɨryɨskaiya! ");
INSERT INTO iws_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kara kɨmiir boɨnkii mɨ ɨriipɨ hɨriinan Adi Komii siir paekwosɨmɨn siya inkamɨn dimɨn biyɨekakɨn naɨngwo tɨbmiiyɨn siirɨmar maɨrgɨmaɨrgaeikɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jisɨs siya boɨn, inkam nwɨrɨn siir yɨnisɨm yɨnkamiyɨno nwɨsko. ");
INSERT INTO iws_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mɨ nomousɨmɨn ad ɨiir boɨn, adi, kara mɨnam naɨngwowi, kɨra digworaekwo whɨekakɨm krɨriir yao whɨd hauu kariirɨn panaowar whauu. Mɨ adɨn ɨna hɨdgiyɨn siir digworaekwo whɨekakɨm siir yɨnisɨm nwɨs owiiram. ");
INSERT INTO iws_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mɨ bɨ kɨmɨmɨnkɨn, tɨ nomousɨmɨn siir umɨr digworaekwo whɨekakɨm ɨna hauugiyɨm, inkam nhɨrkɨm saɨnɨm. Mɨ siya om whɨrɨn kingiin tani, siir inɨ owou. Mɨ siya tɨ om ɨiir nwowɨn mɨ siir umɨr digworaekwo whɨekakɨm ɨni siyɨu biyɨeyɨm siya tɨrɨm sɨmiir yɨuguguskiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Mɨ siya siir digworaekwo whɨekakɨm hɨriinan nɨuguguskiyɨm mɨ mhoɨiya tɨ omɨn siirɨn mhɨi komiiya ɨna yamaoɨua. Mɨ siya ɨni dimɨn whɨrmɨn whɨrmɨn karamaeyar yamwo ɨuwɨn. ");
INSERT INTO iws_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Mɨ siya tɨ om whɨrɨn siir hɨran inkamɨn siir mɨi asi ninɨ mɨriiyɨugɨn. Mɨ tɨ inkamɨn siya yɨkropki siirɨn, maeyaua hu nɨmiiyaeiya saiirɨm, siya kɨgrɨraowɨm sɨmiirɨn. ");
INSERT INTO iws_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Siya mɨnam naɨngwowi siir mhɨiya tɨ binɨm sɨmiir ɨsɨm hugɨ sɨm naemɨmɨn ɨtkɨkɨnɨm sɨmiir naeyɨm. Mɨ siirɨn nae mɨnɨm, inkam nwɨrkɨ bɨ swokɨ hauugɨn. ");
INSERT INTO iws_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Mɨ mhɨinae karamae siya nwowa mɨ siya ha naɨngwoyɨmyokɨn mɨ siya ɨna boɨnkiyɨn, kariir adɨn siir mɨiyan kamɨm yɨm sɨma naeyɨm wara whaowae rani. Mɨ kara tɨr namwoniyɨn mhɨi ɨna yamaoniyɨn. Mɨ kara hɨriirnanar nwowi, an wɨ kapi naowi. ");
INSERT INTO iws_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mɨ hanɨɨngɨ nɨuwi, an tɨ swokɨ am kariir adɨn siirɨm. Mɨ kara siirɨn wɨ hɨnɨɨna boɨni, adi kara siyɨu biyɨe Adi Komii mɨ kɨra kowiir whwonkam ɨda bɨdi tɨrɨn. ");
INSERT INTO iws_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Kara inkam mɨiyɨk rani mɨ kɨra kariirɨn kɨriir yɨnisɨm kɨpi nɨkɨu. Mɨ kɨra kariirɨn, kɨriir mɨiyan inkamnan boɨn. ");
INSERT INTO iws_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Mɨ siya hɨriinan boɨnkiyɨn mɨ siya ɨna swokɨ amɨn siir ad ɨiiramar. Mɨ siya aru tɨrar nwowamɨn, siir adɨn saiirar kɨgwɨnɨn. Mɨ siir adɨn siirsiyɨn naɨngwoyɨmyok prasae bɨ kɨnkɨn. Mɨ siya niwɨtnamɨn mɨ ɨni yɨnisɨm ɨiir yaka iwɨt ankabmamaɨrɨuwɨn. ");
INSERT INTO iws_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mɨ yɨnisɨmɨn ɨna boɨnkiyɨn Adi, kara dimɨn biyɨe Adi Komii mɨ kɨra, kowiir whwonkam ɨda tɨrkɨn. Mɨ kara inkam mɨiyɨk rani, kɨra kariirɨn, kɨriir yɨnisɨm kɨpi nɨkɨu. ");
INSERT INTO iws_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mɨ adɨn siir mɨiyan kam ɨmiir boɨnki, kɨma bɨiyan yɨuɨs prɨeiya saiir whainanisasau mɨpi siir winɨ kaiyaigɨnɨuni. Mɨ siirɨn ɨɨndɨhop ha timɨ iyopkɨkɨu haigɨnɨu. Mɨ siirɨn su ha timɨ ii haigɨnɨu. Mɨ siya siiramɨn pranaepranae bɨ maɨrgɨmaɨrgakɨm. ");
INSERT INTO iws_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Bulmakau ɨrpakiyɨnɨn ɨra tinɨ hainaki mɨpa dɨsomao. Mɨpi krɨmar nongwomamaɨr aei. ");
INSERT INTO iws_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Dimusi rani, tɨ kariir yɨnisɨmɨn siya naonamnan bɨdi yowɨn. Mɨ tariinanɨn siya ɨni omwaiya swokɨ waiyaɨn siya bɨdiyar ikɨ whaowaekiyɨn. Mɨ kara siir bɨdi swokɨ kɨgɨn mɨ sɨma nae komii asi naekɨm. ");
INSERT INTO iws_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Mɨ yaowaeyɨn numɨr nwokɨn mɨ mhoɨiya siya ha nɨtɨn omaka kingiin hɨriir mɨ siyar wakaeni, ɨi kɨdɨm, pɨ nɨnkɨnɨuwi. Yɨm sɨma mwai waowi. ");
INSERT INTO iws_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Mɨ siya siir mɨiyan inkam nwɨr ɨiir yɨkɨuna mɨ ɨna srɨiyɨn, sɨma dimu dimɨn tɨri? ");
INSERT INTO iws_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mɨ siir mɨiyan inkamɨn siirɨn ɨna boɨnɨn, kɨriir nomousɨmɨn bɨdi swokɨ ɨtɨn. Mɨ kɨriir adɨn siya kao ɨrpakiyɨnɨn ɨra yɨsomao siirɨm. Dimusi rani, siya siir yɨnisɨm ɨiir bɨdi swokɨ kɨgɨn. Mɨ siir dimɨn whɨrkɨ bɨ kɨmbugɨn. ");
INSERT INTO iws_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mɨ yaowae siir kwoɨnɨn ɨni haugɨhauga whiyɨekiyɨn. Mɨ siya omaka hɨriir panɨɨnsi yapnɨnopkainamsi. Mɨ siir adɨn ha napnaniniyɨn mɨ siirɨn yai mɨiyɨk ɨmiirar yani boɨni siya napnɨnopkainamɨm. ");
INSERT INTO iws_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Mɨ siya adɨn siir yaiyaka hɨnɨɨna yowarkɨi boɨn, bɨewii kasaka rani, kara kɨriir mɨiyan inkamnan nwowɨn mɨ kara kɨriir yaiyaka ɨigwɨr bɨ nantamyɨriyɨrkɨn. Mɨ kɨra meme ɨi kariir bɨ swokɨ hauugɨn. Kara kariir nomiiyauɨm maɨrgɨmaɨrga sɨmaka mɨ owɨm. Nɨɨngakɨ, nɨɨngakɨɨnga. ");
INSERT INTO iws_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mɨ tɨ kɨriir yɨnisɨmɨn siya kɨriir digworaekwo whɨekakɨm ɨni ɨkɨ wigɨm hɨi nanaeiyɨm, sɨmiir yɨugugusgikɨn mɨ siya ha swokɨ ɨtɨn mɨ kɨra ɨni siirsi yaɨngwoyɨmyokɨn. Mɨ kɨra bulmakau yɨnisɨm ɨrpakiyɨnanɨn ɨna mɨ ɨsomɨn siirɨm. ");
INSERT INTO iws_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Mɨ adɨn siir boɨnki, yɨnisɨm, ɨinokɨinokɨn kɨra kanaka nwokɨn mɨ kariir digworaekwo whɨekakɨm, yɨm kɨriirgɨm. ");
INSERT INTO iws_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mɨ tariinanɨn krɨma ha maɨrgɨmaɨrga mɨ krɨmiir mhɨi kwoɨnɨm, wadɨeyar dwo. Tɨ kɨriir nomousɨmɨn siya naonamnan bɨdiyar ikɨ owɨn. Mɨ tariinanɨn siya ɨni omwaiyar swokɨ waiyaɨn. Siya bɨdiyar ikɨ whaowaekiyɨn mɨ tariinanɨn krɨma siir bɨdi swokɨ hansɨryɨskaiyɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Mɨ Jisɨs siya kamɨm siir mɨi kɨgna mɨriiyɨm sɨmiir boɨnki mɨ inkam nwɨrɨn umɨr digworaekwokakɨn siya bɨiyan inkam bɨdi yɨmbinɨn, siir digworaekwo whɨekakɨm sɨmiir kɨgrɨraowɨm. Mɨ inkam nhɨrɨm sɨma inɨ boɨni tɨ inkamɨn digworaekwo whɨekakɨn siir, tɨ kɨriir bɨiyan inkamɨn siya kɨriir umɨr digworaekwowɨm kasaka bɨ nɨuguguskikɨm mɨ ɨiya ɨni kingiina nwowa kɨriir digworaekwowɨm sɨma dɨgi. ");
INSERT INTO iws_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Mɨ bɨiyan inkamɨn siir hɨriinan wakaeyɨn mɨ siya bɨiyan inkamɨn siiram yɨkɨugi mɨ ɨna boɨnɨn siirɨn, panɨɨn panɨɨna tɨrkɨn ta yaiya kara wakaeya kɨriir? Kɨra kariir digworaekwo whɨekakɨm kɨriir ɨɨn nwowɨm sɨmiir tinɨ wɨn naki. Kɨra wɨ kariir bɨiyan inkam nwo rani. ");
INSERT INTO iws_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Mɨ tɨ bɨiyan inkamɨn siir kwoɨnɨn aowa aowa hɨnɨɨna yaɨngwo. Kara pɨ panɨɨna tɨri? Bɨiyan Inkam Komiiyɨn siya kariir hɨuriiyɨumigiyɨm tɨri. Mɨ kara kɨrɨekak rani, nu wa nop rani. Kara inkam nwɨrni nae umɨr digworaekwo kaugiki aeyɨm pɨ nɨdidi. ");
INSERT INTO iws_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mɨ tariinanɨn kara bɨdi yɨnoknɨnkɨnkiyɨn, dimɨnɨn kara tɨranɨn mɨ ɨiya inkamɨn siya kariir hɨuriiyɨumigi siir mɨi saiir hɨrankɨn mɨ ta hɨriinana saiirsiyɨn kariirɨn wɨ inkam nhɨrɨm sɨma nɨkɨunami, sɨmiir omaka hɨriirɨn. ");
INSERT INTO iws_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Mɨ siya inkamɨm siir bɨiyan inkamɨn siir dimɨn prɨihaiyɨm sɨmiirɨn nwɨnwɨra yɨkɨuna mɨ siirɨmɨn ɨna yamɨm. Mɨ bɨiyɨn nwɨra ɨeya yam mɨ mɨi kɨgrɨraowan inkamɨn ɨna srɨiyɨn siirɨn. Dimɨnɨm kɨra prɨihaiyɨm kariir bɨiyan inkamɨn siir hɨrankɨn pariigɨm? ");
INSERT INTO iws_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Mɨ siya boɨn, wel twowɨm kamaɨrɨm ɨriiyarkɨm. Mɨ mɨi kɨgrɨraowi inkamɨn ɨna boɨnɨn, kɨra tɨ dimɨnɨm kɨra prɨihaiyɨm sɨmiir yokwo aiir hai mɨ kɨra kamnwɨs ɨuurɨuwa 50 sɨmiirar kwɨdwo wɨnki. ");
INSERT INTO iws_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Mɨ mhoɨiya inkam nwɨrɨn ɨna swokɨ ɨtɨn, bɨiyan inkamɨn mɨi kɨgrɨraowiyɨn siya ɨna srɨiyɨn, dimɨnɨm kɨra prɨihaiyɨm pariigɨm? Mɨ siya ɨna boɨnɨn, wit nɨbɨm kamaɨrɨm ɨriiyarkɨm 100 mɨ siya siir boɨnki, kɨra ta yokwowa kɨra wɨna dimɨnɨm kɨra prɨihaiyɨm saiirɨm pɨ kam nwiiyɨuwa wɨnki. ");
INSERT INTO iws_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Mɨ mhoɨiya bɨiyan inkamɨn siya ɨni tɨ inkamɨn mɨi kɨgrɨraowiyɨn siir inɨg ɨiir hainankiyɨn. Dimusi rani, siya inkamɨn kwoɨn mɨiyɨkakɨn, siir siyɨuɨn siir hɨriinan tɨrkɨn. Mɨ Jisɨs siya ha nikɨ boɨnɨn mɨ nu tɨran iikamɨm sɨmiir kwoɨnɨm umɨr dirɨraerar saɨniyɨm ɨni Adi Komii siir iikamɨm sɨmiir haiburɨm, sɨma nɨnoknɨnkɨn mɨiyɨkakɨm. ");
INSERT INTO iws_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Mɨ Jisɨs siya hɨnɨɨna boɨnki sɨmiirɨn. Mɨ umɨr digworaekwo whɨekakɨm kɨma nonkwowɨm kɨma iikam nhɨrɨm umɨr digworaekwowɨm whaowaeyɨm sɨmiir hauu. Mɨ sɨma wɨ kɨmiir nomiiyau kɨɨn nwokɨ owɨm. Mhoɨiya kɨma naonami mɨ kɨma wɨ Adi Komii siir om mɨiyɨkɨn siir nami. Mɨ siya kɨmiirɨn wɨ hɨnɨɨna boɨni, kɨma siyɨu mɨiyɨk bɨdi tɨrɨm. Mɨ ɨinokɨinokɨn kɨma wɨ kanaka nwoyokiyokɨi. ");
INSERT INTO iws_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mɨ inkam nwɨrɨn siya dimɨn sɨmɨm sɨmiir sɨbgu kɨgrɨraowi mɨ siya wɨ dimɨn komii komiiyɨm sɨmiir warar mɨ sɨbgu ɨnkɨn kɨgrɨraowi. Mɨ inkamɨn mɨisɨmɨm sɨmiir sɨbgu mɨrii karamae nwowi mɨ siya mɨi komii komiiyɨm sɨmiirɨn wɨ mɨ sɨbgu mɨrii rani. ");
INSERT INTO iws_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mɨ kɨma umɨrɨm nu tɨranɨm sɨmiir sɨbgu kɨgrɨrao karamae nwowi mɨ kɨma Adi Komii siir dimɨn mɨiyɨk ɨmiirɨn wɨ panɨɨna sɨbgu kɨgrɨraowi, ha? Nɨɨngaka, kɨma inkam wɨ dɨg nwo rani. ");
INSERT INTO iws_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mɨ kɨma inkam nwɨrni dimɨn sɨbgu kɨgrɨrao karamae nwowi mɨ Adi Komii siya dimɨn mɨiyɨkɨn wɨ panɨɨna hauuwi, ɨinokɨinok nwoyokiyokɨiyɨn, ha? ");
INSERT INTO iws_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Mɨ mɨiyan inkam nwɨrɨn siya, bɨiyan inkam nwɨso sowiir mɨiyɨm ɨikwɨruwa bɨ swokɨ mɨriikɨn. Nɨɨngaka. Mɨ siya kwoɨn biyɨe wɨ nwɨrɨn siir nwowi mɨ nwɨrɨn wɨ mɨiyɨk siir nwowi. Mɨ siya wɨ nwɨrɨn siir wakaeyoknaei mɨ nwɨrɨn wɨ digɨumii haimriyɨuwi. Mɨ kɨma Adi Komii krɨmiir Wanɨn siirɨm mɨriiyɨm, umɨr saiirɨm wara kɨpi naɨngwo. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisi sɨma umɨrɨm naɨngwokwowikɨm. Mɨ sɨma tɨ hɨriinan yai whɨekakɨm Jisɨs siya boɨnkiyɨm sɨmiir wakaekiyɨm mɨ sɨma siir yɨkbumbu boɨn. ");
INSERT INTO iws_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Mɨ Jisɨs siya sɨmiir boɨnki mɨ kɨma kɨmiir siyɨu mɨiyɨkɨn iikam whɨekakɨm sɨmiir whwonkam ɨda hɨnɨɨna nɨisiimauuwi kɨma iikam mɨiyɨkɨm. Mɨ Adi Komii siya kɨmiir kwoɨn ɨmiir bɨdi yɨnoknɨnkɨnɨm. Dimɨnɨm inkamkɨ hainaniyɨm, yɨm Adi Komii siir whwonkam ɨdaɨn dimɨn komii rani. ");
INSERT INTO iws_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Moses siir siyɨu komiini yai mɨ profet kamɨm sɨmiir yai aka sowa ɨiya Jonɨn op baptaisiyɨn siya nwowa saiirar yadɨgɨuwa. Mɨ Jon siir ɨiya tasi tariinana namwoniya mɨ Adi Komii siya siir iikam whɨekakɨm sɨmiir kɨgɨrkakana mɨ saiir yaiwɨn kɨbiya omom omom whɨekakɨm sɨmiir nɨmbiyami. Mɨ iikam whɨekakɨm sɨma Adi Komii siya siir iikam whɨekakɨm sɨmiir kɨgɨrkakana saiir namamar naɨngwokwowi. ");
INSERT INTO iws_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nɨnomor nu sowa wa dɨgi. Mɨ Moses siir siyɨu komii siir yaisɨsɨmɨm sɨma wɨ wara swokɨ kɨgugu rani. ");
INSERT INTO iws_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Mɨ kamɨn siya siir wig aiir sopki mɨ ɨrni swokɨ ɨnkwonaei, yɨo wig nonkwonani siyɨugɨ siyɨu ɨiirar nɨkrɨpkikɨn. Mɨ inkam nwɨrɨn siya wig ɨra inkam nwɨrkɨ sopkiya saiir nonkwonaei, yɨo wig nonkwonani siyɨuɨn siir taouugakɨn mɨ siya hɨi nanaenanaei. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Bɨiya inkam nwɨrɨn umɨrkɨ naokɨngugunankaiyɨn, siya tɨr nwokɨn mɨ ɨinokɨinokɨn siya yɨuɨs mɨiyɨk mɨiyɨk ɨmiirar niigɨn. Mɨ ɨinokɨinokɨn siya nae mɨiyɨk ɨmiirar haiikɨn mɨ sɨmiirar naeikɨn siya wadɨe nwowɨm. ");
INSERT INTO iws_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Mɨ inkam paeprikab nwɨrɨn hɨrar mɨ ɨnkɨn okɨn siir inɨgɨn Lasaraskɨn, siir pɨua paowai biyɨeya. Mɨ siirɨn siir isid ɨeyar hainam umɨrkak inkamɨn siir omaka anoka kingiin hɨr inɨ kikɨnɨugik. ");
INSERT INTO iws_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Mɨ siya tɨ umɨrkak inkamɨn naeyɨm siir hɨi aowa naekrɨmkrɨnkiiyɨm sɨmiir nɨumɨmɨn aeyamar naɨngwowi mɨ ɨiya tɨ umɨrkak inkamɨn siir mɨiyan kamɨm sɨma nhɨskiyɨm naemɨmɨn prɨigɨnɨm naeyɨm sɨmiir mɨ tɨ inkam paeprikabɨn siir mhɨiya ɨni sɨmiirar yaekɨnɨuɨn. Mɨ wraɨm sɨma nɨtiyɨm pɨ siir paowai ɨmiir taowaei. ");
INSERT INTO iws_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Mhoɨiya tɨ inkam paeprikabɨn ha naonamɨn mɨ siirɨn Adi Komii siir paekwosɨmɨm sɨma hainam mɨ siya Ebraham saɨka inɨ owou. Mɨ tɨ inkam umɨrkakɨn ɨna mɨ aowɨn mɨ siirɨn ɨna haɨngikaiyɨn. ");
INSERT INTO iws_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mɨ siya ɨni maeyau paekaka saiir nwowɨn mɨ hɨk kɨmpɨsu komii hɨr haiyɨn. Mɨ siya koua hɨriir kaokiiyɨn mɨ siya kɨgi Ebraham siya kingiin nwo rani mɨ Lasaras siya saɨka nɨnkɨn owi. ");
INSERT INTO iws_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Mɨ umɨrkak inkamɨn ɨna kauwokiyɨn, adi Ebraham kɨra kariirsi daɨngwoyɨmiyok mɨ kɨra Lasaras siir dɨkrop ɨuungi siir ɨɨnaɨn op hopmaiyɨm mɨ opa kariir kworiyaeya saiir hougɨn noksɨsaekiyɨm. Kara ta pae aiirɨn hɨk kɨmpɨpɨsu prasae hai rani. ");
INSERT INTO iws_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Mɨ Ebraham siya boɨn, yɨnisɨm tariinanɨn kɨra dimɨn whɨrɨn ɨna naɨngwokiyɨn. Bɨiya kɨra omwaiya nikɨ waiyan mɨ kɨra digworaekwo whɨekakakar nwokɨn. Mɨ Lasaras siya dimɨn biyɨe biyɨeyɨm sɨmiir haiigɨn. Mɨ tariinanɨn siir kwoɨnɨn tɨ om ɨiirɨn ɨni wadɨeyar yamwoniyɨn mɨ ni kɨra ɨni hɨk kɨmpɨpɨsu yama haiyɨuɨn. ");
INSERT INTO iws_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Mɨ dimɨn whɨrɨn Adi Komii siya bɨdi haigɨnɨn, ɨe komii whɨrɨn kɨmiir mɨ krɨmiir bopwoniya tɨr. Mɨ iikamɨm tɨr nwowɨm sɨma tɨ ɨeyɨn siir niyapidnaidamɨm sɨma dɨg nwo rani. Mɨ iikamɨm yarmiiya mɨ owi, krɨmiir tɨriir niyapidnaidniyɨm sɨma wɨ dɨg mɨ o rani. ");
INSERT INTO iws_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Mɨ umɨrkak inkamɨn siya boɨn, adi kara kɨriirɨn hɨriinansi srɨi, kɨra Lasaras siirɨn kariir adɨn siir omaka hɨriir dɨkropki. ");
INSERT INTO iws_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Kariir nomousɨmɨm ɨriiyarkɨm. Mɨ Lasaras siya sɨmiirɨn yai kɨrɨe aiirar tinɨ boɨnɨu. Mɨ sɨma wɨ tɨ om biyɨeyɨn hɨk kɨmpɨpɨsu kara haiiyɨn siirar swokɨ ɨnkɨn ɨtisi. ");
INSERT INTO iws_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Mɨ Ebraham siya ɨna boɨnɨn, sɨma Moses mɨ profet kam ɨkɨm sɨmiir yaigakargɨm. Sɨma sɨmiirɨn ɨgao yai bɨdiya boɨnɨm sɨma ta yai aiirar wakaeyokna. ");
INSERT INTO iws_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mɨ umɨrkak inkam ɨeya boɨn. Nɨɨngaka. Adi Ebraham ta yaiya saeya sɨmiirɨn wɨ dɨg nwo rani. Mɨ inkam wɨɨr nwɨrɨn siya ɨe hɨrankɨ nɨnsiin ɨdwowi mɨ sɨmiiramɨn ha nami mɨ sɨmiir mhɨi kwoɨnɨm wa nɨnkpɨt haigii. ");
INSERT INTO iws_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Mɨ Ebraham siya ɨna boɨnkiyɨn siirɨn mɨ sɨma Moses mɨ profet kamɨm sɨmiir yai ɨmiir wakaeyokna karamae nwowi mɨ inkam nwɨrɨn ɨe ankɨn nɨnsiin ɨdwowi mɨ sɨma ɨriipɨ hɨriinan wɨ siir swokɨ aɨngwo tɨbmii rani. Nɨɨngaka. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Aiyo, aiyo mɨ Jisɨs siya kamɨm siir kɨgna mɨriiyɨm sɨmiir boɨnki, dimɨnpai dimɨnpaiyɨm wa nɨmbiyami iikam whɨekakɨm sɨmiir kwoɨn ɨmiir nɨpiyaokɨiyam mɨ sɨma dimɨn biyɨe tɨram. Mɨ sɨmiir naɨngwo tɨbmiiya wa whaowae ɨuguskii. Aiyo, aiyo mɨ inkamɨn, inkam nwɨrni naɨngwo tɨbmiiya saiir tɨrbuwiyɨn kɨra mɨntarao mhoɨiya kɨra wɨ hɨk komiigɨ komii haii. ");
INSERT INTO iws_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mɨ siya tɨ yɨnisɨm sapɨsapɨm sɨmiir nwɨr ɨiir tɨrkii, siyɨu biyɨe tɨram mɨ hɨriinankɨnɨuwi, ɨni mɨ owɨn kam nhɨrɨm sɨma siir nɨiyɨn siiya komiiya saɨka dɨnkɨn kog. Mɨ siirɨn whɨi komii solwara saiir dɨtmai whɨridgi, yɨpi nwokɨ aeyɨkrɨkɨu whɨridamɨm. ");
INSERT INTO iws_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kɨmakɨmasiyar mɨntaraona! Mɨ kɨmiir nomiiyauɨn, siya siyɨu biyɨe tɨri, kɨma ɨo saiir dwo mɨ siya siir kwoɨnɨn kisɨna haigii mɨ kɨra siir dankabmamaɨr boɨn. ");
INSERT INTO iws_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mɨ siya dimɨn biyɨe kɨriirɨn ɨi kwɨruwa saiirararɨn ɨdɨp ɨdɨpɨn ɨriiyar kwɨsa tɨri mɨ siya kɨriiramɨn ɨdɨp ɨdɨpɨn ɨriiyar kwɨsa nɨti mɨ ha ninɨ boɨni, kara pɨ naɨngwoyɨmyoki kɨra kariir dimɨn biyɨeyɨm sɨmiir haiyoprimdiyɨumiigiyɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aposel kamɨm sɨma Bɨiyan Inkam Komiiyɨn siir boɨnki, kɨra krɨmiir naɨngwo tɨbmiiya saiirɨn komii swokɨ ɨnkɨn hauugi. ");
INSERT INTO iws_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mɨ Bɨiyan Inkam Komii siya sɨmiir boɨn mɨ kɨriir naɨngwo tɨbmiiya saeya mastɨd nidni hanɨɨn sapɨsapkɨ nɨuwi mɨ Adi Komii siya kɨriirɨn wɨ dimɨn komii ɨiirar tɨrhaigɨnɨuwi. Mɨ kɨra paeyɨn siirɨn ha boɨnkii, kɨra, wara kɨriir mɨiyɨm tɨ ophainam whɨi komii solwara hɨriir! Mɨ siya wɨ kɨriir yai aiirar mɨ wakaeyoknaei. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Mɨ kɨmiir inkam nwɨrkɨ siya mɨiyan inkamkakɨ nɨuwi, siir numɨr aiir haɨnopam mɨ siir sibsib ɨmiir kɨgrɨraowam mɨ mhoɨiya siya ha swokɨ ɨti mɨ siir bɨiyan inkamɨn siirɨn wɨ hɨnɨɨna boɨni, kɨra ha wɨtsɨsau, nae kanaka winɨ ɨdwokai aeni. Mɨ kɨra wɨ hɨnɨɨna boɨni, aniya? ");
INSERT INTO iws_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nɨɨngakɨ, nɨɨngakɨɨnga. Mɨ kɨra wɨ siir boɨnmauuwi, kɨra kariir nae ɨmiir dirɨraerar mɨ kɨra yaeya pɨuwopa ha kikognani mɨ naeyɨm ha dirɨraerar hainani. Bɨi op nae mɨnɨm pɨ kara nikɨ ae kwiyae mɨ mhoɨiya kɨra op nae mɨnɨm pa timɨ ae kwiyae. ");
INSERT INTO iws_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Mɨ siya tɨ siir mɨiyan inkamɨn siirɨn pa boɨn wadɨe ta siya siir yai aiir wakaeyokna dirɨraerara saiirsiyɨn, aniya? Nɨɨngakɨ, nɨɨngaka. Ya siirar mɨiga. ");
INSERT INTO iws_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mɨ kɨma ɨriipɨ hɨriinan digworaekwo whɨekakɨm Adi Komii siya boɨnɨm, kɨma sɨmiir dirɨraerari mɨ kɨma wɨ hɨnɨɨna boɨn, krɨma mɨiyan iikam mɨiyɨk rani. Dimɨnɨm krɨma dirɨraerariyɨm krɨma Adi Komii siir kwoɨn ɨiirar dirɨraerari. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisɨs siya siyɨuɨn om komii Jerusalem hɨriir namiyɨn siir namkɨn mɨ siya nu Sameria nu Galili sowiir bopwowar napnamkɨn. ");
INSERT INTO iws_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Mɨ siya om whɨrɨn siir nɨmbiyamɨn mɨ kam ɨuurɨm paowaigɨ pɨskɨmkopouwɨm siirɨn siyɨu hɨr yapyɨskaiwɨn. Mɨ sɨma aru hɨrar nikɨ okwowɨm ");
INSERT INTO iws_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","mɨ sɨma ɨna kauwok boɨnɨnaekiyɨm, Bɨiyan Inkam Komii, Jisɨs kɨra krɨmiirsi daɨngwoyɨmiyok. ");
INSERT INTO iws_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Mɨ Jisɨs siya sɨmiir kɨgɨn mɨ siya ɨna kauwok boɨnkiyɨn sɨmiirɨn, kɨma ha dam, wara kɨmiir pɨuɨm prismi tinɨ ɨisiimauuɨu. Mɨ sɨma ha napnamɨm mɨ sɨmiir pɨuɨm ɨni mɨiyɨkar ywokiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mɨ sɨmasɨmar yɨnkɨg ankɨgna sɨmiir pɨuɨm wadɨe nwokiyɨm. Mɨ sɨmiir nwɨrɨn sasa swokɨ iwɨtamɨn. Mɨ siya ɨna kauwok boɨn hainan praprasamɨn Adi Komii siir inɨg ɨiir. ");
INSERT INTO iws_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Mɨ siya Jisɨs siir ɨgmiiga whwonkam ɨda inɨ hɨuɨu. Mɨ siya ɨna boɨn wadɨekiyɨn siirɨn. Tɨ inkamɨn siya nu Samerian inkamkɨn. ");
INSERT INTO iws_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Mɨ Jisɨs siya hɨriinan kɨgiyɨn mɨ siya ɨna boɨnkiyɨn, tɨ kam ɨuurɨm paowaigɨ pɨskɨmkopouwɨm, sɨmiirɨn kara haiswonɨskiigiyɨm mɨ ɨriiyar nwiiyɨm ɨni papi nwowɨm? ");
INSERT INTO iws_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Mɨ tɨ ɨriiyar nwiiyɨm Adi Komii siir inɨg ɨiir hainanam bɨ nɨtkɨm, aniya? Mɨ tɨ inkam nwɨruan om whɨranɨn sasar yɨt Adi Komii siir inɨg ɨiir hainanamɨn. Mɨ tɨ kam ɨriiyar nwiiyɨm Isrelmiyɨm, yɨm ɨni panɨɨna tɨrɨm, ha? ");
INSERT INTO iws_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Mɨ mhoɨiya Jisɨs siya boɨnki, kɨra dɨnsiingi mɨ ha dɨnsiin apnam, kɨra naɨngwo tɨbmiiya kariiram, kɨriirɨn wadɨe saeyar nwowaigɨnɨugɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mɨ Farisi kamɨm sɨma Jisɨs siir srɨigi, ɨiya Adi Komii siya siir iikam whɨekakɨm sɨmiir kɨgɨrkakana wɨ paka hɨnɨɨn ɨiya sae nɨmbini? Mɨ Jisɨs siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨn, ɨiya Adi Komii siya siir iikam whɨekakɨm, sɨmiir kɨgɨrkakana saeya nɨmbiyami, iikamɨm sɨmiir nhwowɨm wɨ dimɨn kɨrɨe kɨrɨe komii komii kɨg rani. ");
INSERT INTO iws_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mɨ sɨma wɨ hɨnɨɨna boɨn tani, kɨgi, siya tɨsi tapi nwowɨn. Nɨɨngaka. Wakae, ɨiya Adi Komii siya siir iikam whɨekakɨm sɨmiir kɨgɨrkakana saeya ɨni kɨmiir mhɨi kwoɨnau waraurar nwowa kɨma wɨ saiir kɨg rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Mɨ siya ha boɨn dɨgiyɨn mɨ siya kamɨm siir kɨgna mɨriiyɨm, sɨmiir boɨnki, mhoɨiya ɨiya wa nɨmbiyami mɨ kɨmiir mhɨi kwoɨnɨm Yaowae Adɨn nɨnomor kouanɨn kara nɨtana ɨiya, saiir kɨgamar naɨngwowi mɨ kɨma wɨ siir kɨg rani. ");
INSERT INTO iws_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mɨ mhoɨiya kam nhɨrɨm wɨ sɨma boɨni kɨmiirɨn, kɨgi, siya ɨsi hɨnda nwowɨn, kɨgi siya tɨsi tɨnda nwowɨn. Mɨ wɨm kɨma wɨ hɨriinan inkamɨm sɨmiir yai kɨpi wakaeyokna yɨm sɨma kɨmiir nɨksɨsaei. ");
INSERT INTO iws_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kɨma ɨna nɨnoknɨnkɨnɨm ɨiya nɨnomora yakii mɨ ta nɨnomor kwɨrkaka wa yaarkakii. Mɨ Yaowae Adɨn nɨnomor kouanɨn siya nɨmbini, wɨ hɨriinanar tɨri. Mɨ iikam whɨekakɨm sɨma siirɨn wa kɨgɨrkakwɨni. ");
INSERT INTO iws_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mɨ bɨi kara wɨ hɨk kɨmpɨpɨsuwar nikɨ haii mɨ iikamɨm ta ɨi aiirar nikɨ owɨm, sɨma digɨumii wɨ kariir haimriyɨuwi. ");
INSERT INTO iws_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Siyɨuɨn bɨiya Noakɨ nwowa ɨiya saiir tɨrɨn. Mɨ Yaowae Adɨn nɨnomor kouanɨn siir ɨiya siya nɨtana yɨo wɨ ɨriipɨ hɨriinanar mɨ tɨri. ");
INSERT INTO iws_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mɨ sɨma nae hɨrar nikɨ aeyɨm mɨ op mɨnɨm hɨrar nikɨ kwiyaeyɨm mɨ wigkamɨm ha nonkwonam ɨiya Noa siya siyaiiya hɨriir napnɨnopkainamɨn mɨ op komiiyɨn ha nɨtɨn, sɨmiirɨn ɨni siya yakiirɨmdɨpugiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Mɨ Lot siir ɨiya, ya ɨriipɨ hɨriinanar mɨ tɨr. Mɨ sɨma naemɨn hɨrar nikɨ aeyɨm mɨ opmɨn hɨrar nikɨ kwiyaeyɨm mɨ digworaekwo mɨnɨm hɨrar nikɨ saɨnɨm mɨ digworaekwo nhɨrɨm, inkam nhɨrmi hauuwɨm sɨma saɨnɨm mɨ numɨr sasae ha nɨnkɨkɨnɨm mɨ omaka mɨnɨm ha mɨ mɨrii. ");
INSERT INTO iws_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Mɨ Lot siya om komii Sodom siir haiburgigɨn mɨ ha namɨn mɨ ta ɨi aiirɨn Adi Komii siya pae aiir yɨkropki. Mɨ siiya komii komiiyɨm paekak paekakɨm, ɨna kɨnanaiiniyɨm nɨnomor kouankɨn iikamɨm sɨmiir tɨoɨdwomaiyam. ");
INSERT INTO iws_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Mɨ ɨriipɨ hɨriinan ɨiya Yaowae Adɨn nɨnomor kouanɨn siya swokɨ ɨti, wɨ idowɨiyar nɨmbini, iikamɨm sɨmiir whwonkam ɨdar. Mɨ sɨma wɨ digworaekwo kasa tɨr tani. ");
INSERT INTO iws_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Mɨ ta hɨriinan ɨiya inkam nwɨrɨn siya omakanau hɨr nwowi mɨ siir digworaekwowɨm, nu hɨr nwowi mɨ siya wɨ siir digworaekwo ɨmiiram nɨuunaiinam tani, sɨmiir hainakiyam. Mɨ siya wɨ hindara nɨdam ɨuguski. Mɨ ɨriipɨ hɨriinan inkam nwɨrɨn siya numɨr hɨr nwowi mɨ siya wɨ omaka tɨriir swokɨ ɨt rani, yɨuɨsmɨn ɨmiir hainankiyam. Nɨɨngaka. Siya wɨ hindara nɨdam ɨuguski. ");
INSERT INTO iws_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mɨ kɨma Lot siir wig aiir dɨnoknɨnkɨnki, saeya om komii Sodom siir swokɨ haiyɨug kaokiya mɨ saiirɨn Adi Komii siya dirɨraerarki mɨ saeya sol ha nwokiya mɨ yɨnpae yamwoɨua. Mɨ ɨriipɨ hɨriinan, kɨma kɨpi swokɨ haiyɨug kao hindara dɨdam ɨugusam. ");
INSERT INTO iws_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mɨ inkamɨn siyamar naɨngwonaeiyɨn, Adi Komii siiram naɨngwo karamae nwowiyɨn, yɨo wɨ hindara kɨgugu ɨuguskii. Mɨ inkamɨn siyamar naɨngwo karam nwowiyɨn mɨ Adi Komii siir yai aiir wakaeyoknaeiyɨn mɨ siir kwoɨnɨn wɨ hɨriiyar nwoyokiyokɨikaeyami, Adi Komii saɨkar. ");
INSERT INTO iws_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kara kɨmiir boɨnkii, ta nɨi aiirarɨn, inkam nwɨso hɨi kwɨruwa saiirarar whwonkai mɨ Adi Komii siya sowiir nwɨrɨn siir hainami mɨ siir nwɨrɨn, yɨo wɨ hɨrar nwokii. ");
INSERT INTO iws_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Mɨ wig ɨso sowa mɨi ɨrɨpa mɨriiguwaki mɨ Adi Komii siya sowiir ɨr aiir nɨkɨunami mɨ ɨra, ya wɨ hɨrar nwokii. ");
INSERT INTO iws_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Mɨ inkam nwɨso sowa numɨr hɨr nwowi mɨ Adi Komii siya wɨ nwɨr ɨiirara nɨkɨunami mɨ nwɨrɨn yɨo wɨ hɨrar haiburgigi. ");
INSERT INTO iws_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Mɨ kamɨm siir kɨgna mɨriiyɨm, sɨma ta yai aiir wakaeyɨm mɨ sɨma ɨna srɨiyɨm, Bɨiyan Inkam Komii tɨ dimɨnɨn wɨ papi nɨmbiyami? Mɨ Jisɨs siya sɨmiirɨn boɨniyɨo yai boɨnkɨn, maeyauwa inkam whɨigɨ nwowa, wakikiyao wabɨm saiir nwowikɨm mɨ inkam whɨiyɨm pɨ sɨmar mɨ aei. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisɨs siya boɨniyɨo yai kwɨra sɨmiir boɨn sɨmiir nɨisiisiimauugɨn sɨma ɨinokɨinokɨn nhwo Adi Komii siirɨm kwɨsboɨnɨm mɨ sɨma kɨpi nhakɨu. ");
INSERT INTO iws_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Siya hɨnɨɨna boɨn mɨ om komii whɨrɨn yai hɨdi inkam nwɨrɨn hɨr nwokɨn. Tɨ yai hɨdi inkamɨn siya Adi Komii siirsi bɨ swokɨ ɨdidikɨn. Mɨ ɨriipɨ hɨriinan inkam ɨmiirsi bɨ mɨ aɨngwoyɨmiyokikɨn. ");
INSERT INTO iws_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mɨ wig igabae ɨra tɨ om ɨiir nwoka. Ɨinokɨinokɨn saeya tɨ inkamɨn yai hɨdiyɨn siirɨn hɨnɨɨna ninɨ boɨnɨuwika, kariir ɨoan inkamɨn siya kariir nonkwobumbuwam tɨri mɨ kɨra siir boɨn hɨuriiyɨunatkaigi. ");
INSERT INTO iws_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Bɨiya tɨ inkamɨn yai hɨdiyɨn saiir whɨndirɨraeraram bɨ naɨngwokɨn. Mɨ mhoɨiya siya siir mhɨi kwoɨnauɨn hɨnɨɨna yaɨngwo, kara Adi Komii siirsi nɨdid rani mɨ kara iikam ɨmiirsi bɨ mɨ aɨngwo ɨdidkɨn. ");
INSERT INTO iws_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Mɨ taka wig igabaeya kariirɨn kɨigi saeya nɨnkinanaei. Kiya saiirɨn yai pɨ kara whɨnboɨni mɨ ɨinokɨinokɨn saeya wɨ kariiram nɨtnanaeisi mɨ kariir pɨua mhoɨiya wa nhakɨu ɨuguski. ");
INSERT INTO iws_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Mɨ Bɨiyan Inkam Komii siya ɨna boɨnɨn, kɨma tɨ yai hɨdan inkam biyɨeyɨn siir yai ɨmiir wakaeki mɨ tɨ yai hɨdan inkam biyɨeyɨn, siya ta wiga saiir yai bɨdi whɨndirɨraerarɨn. ");
INSERT INTO iws_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Mɨ wɨ panɨɨna tɨri? Mɨ iikamɨm Adi Komii siya nɨmbinɨm siirɨm mɨ nɨi nabɨe siirɨm nouɨm mɨ tari Adi Komii siya yai wɨ sɨmiir whɨnboɨn tani, aniya? Mɨ siya kaoguguwi mɨ tari wɨ sɨmiir whɨndirɨraerar tani, aniya? Nɨɨngaka. Adi Komii siya yai hɨdan inkam mɨiyɨkɨɨngɨn. ");
INSERT INTO iws_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kara kɨmiir boɨnki mɨ siya sɨmiirɨn siyɨu wa whɨndirɨraerar sasaugi. Mɨ mhoɨiya Yaowae Adɨn nɨnomor kouanɨn siir ɨiya, siya wɨ saiir kɨgi iikamɨm sɨmiirɨn sɨma bɨdi yamsi aɨngwo tɨbmiiyɨm, iyɨe? Nɨɨngaka? Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Kam sɨma hɨnɨɨna naɨngwowi, sɨma inkam mɨiyɨkɨm mɨ sɨma hɨnɨɨna naɨngwowi inkam nhɨrɨm sɨma inkam mɨiyɨk rani. Tɨ hɨriinan inkamɨm Jisɨs siya boɨniyɨo yaiya sɨmiir boɨnkɨn, ");
INSERT INTO iws_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","inkam nwɨso nhwo kwɨsboɨnɨm namko omaka Adi Komii siira saiir hɨriir. Mɨ nwɨrɨn inkamɨn omom omomi umɨr haii ɨkɨn mɨ nwɨrɨn Farisi inkamkɨn. ");
INSERT INTO iws_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mɨ tɨ Farisi inkamɨn sasa ha nokwokiyɨn mɨ siir mhɨi kwoɨnau hɨrɨn hɨnɨɨna kwɨsboɨnki, Adi Komii kara tɨ inkam nhɨrɨm sɨmiir hɨriinan tani, kara tɨ kɨriirɨm srɨiyɨn. Mɨ sɨma hɨiya tauaeikɨm mɨ siyɨu biyɨeyar mɨ tɨrikɨm mɨ wiga mɨ sopikɨm. An kara, nɨɨngaka. Kara tɨ inkamɨn omom omomi umɨr haiiyɨn siir hɨriinan tani. ");
INSERT INTO iws_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mɨ wik whɨekakɨm sɨmiirɨn kara ɨi kwokwɨsa haiyaeikɨn nae karamae. Mɨ digworaekwo whɨekakɨm kara haiiyɨm, kara ɨuura sɨoɨtkɨnikɨn mɨ haɨmii pɨ kɨriir mɨ hauuwi. ");
INSERT INTO iws_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Mɨ inkamɨn omom omomi umɨr haiiyɨn siya arurɨg ha nokwokiyɨn mɨ siya nɨnomor koua hɨriir kaowɨm pɨ boriisopi. Nɨɨngaka. Mɨ siir nɨiyɨn ɨna kaiyɨrounaiinamɨn mɨ siya ɨna boɨnɨn, Adi Komii kara dimɨn biyɨeyan inkamkɨn. Kɨra kariirsi daɨngwobumbu! ");
INSERT INTO iws_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kara kɨmiir boɨnki, tɨ inkamɨn omom omomi umɨr haiiyɨn, Adi Komii siya siirɨn inkam mɨiyɨk yɨkɨuwɨn. Mɨ siya siir omaka hɨriirar swokɨ amɨn. Mɨ tɨ inkam nwɨrɨn yɨo. Nɨɨngaka. Mɨ inkam saama naɨngwonaeiyɨn, yɨo wɨ Adi Komii siya nikwowaisii. Mɨ inkamɨn saam naɨngwo karamae nwowiyɨn mɨ Adi Komii siya siir inɨgɨn wɨ kougɨkou haigɨnki. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Mɨ sɨma yɨnisɨm sapɨsapɨm Jisɨs siirɨm nɨkɨunanikɨm. Sɨma mɨnam naɨngwokɨm, Jisɨs siya ɨɨn sɨmiir nonkwowɨm. Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma tɨ hɨriinan kɨgiyɨm mɨ sɨma ɨo sɨmiir ywoki. ");
INSERT INTO iws_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mɨ Jisɨs siya yɨnisɨm sapɨsapɨm sɨmiirɨn ɨna yɨkɨunan siir kingiin hɨriir mɨ siya ɨna boɨnɨn kɨma yɨnisɨmɨm kariirɨm kɨgnɨnkɨnki, kɨma sɨmiir kɨpi nɨkɨdu. Dimusi rani, Adi Komii siya siir iikam whɨekakɨm sɨmiir kɨgɨrkakana tɨ hɨriinan iikamɨm sɨmiirgɨm. ");
INSERT INTO iws_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Kara kɨmiirɨn yaimwowar boɨni, inkamɨn ɨiya Adi Komii siya siir digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana saiir nɨtam naɨngwowi mɨ siya tɨ yɨnisɨm sapɨsapɨm sɨmiir hɨriinan dwo mɨ hɨriinan karamkɨ nɨuwi mɨ siya wɨ saiir napnɨnopkainam tani. Nɨɨngakɨ, nɨɨngakɨɨnga. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mɨ Judami bɨiyan inkam nwɨrɨn siya Jisɨs siirɨn hɨnɨɨna srɨi nowomwarkaiyɨuwan inkam mɨiyɨk mɨ kara wɨ panɨɨna tɨri. Kwoɨnbudɨn omwai waiyayokiyokɨiyɨn ɨinokɨinok siir haiyamɨn, ha? ");
INSERT INTO iws_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Mɨ Jisɨs siya siir boɨnki, kɨra kariirɨn inkam mɨiyɨk dimusi dapkɨn, ha? Adi Komii sasaɨrgɨn inkam mɨiyɨkɨn. ");
INSERT INTO iws_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kɨra siyɨu komii ɨiir bɨdiyar yɨnoknɨnkɨnɨn. Kɨra wig kɨpi haɨnɨkɨi nonkwona. Mɨ inkam kɨpi mɨ ɨsom ao. Mɨ hɨi kɨpi mɨ tauae mɨ kɨra inkam nwɨrni kɨpi mɨ ɨksɨsae boɨnhɨuriyɨu, kɨra kɨriir yopii ado sowiirwai yai ɨmiirar wakaeyokna. ");
INSERT INTO iws_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mɨ bɨiyan inkamɨn ɨna boɨnɨn, ɨiya kara yɨnisɨma nwonaniyɨn mɨ ɨni tariinanar yamwoniyɨn kara tɨ siyɨu ɨiirar wakaeyoknakɨn. ");
INSERT INTO iws_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jisɨs siya ta yai aiir wakaekiyɨn mɨ siya siir boɨnki, dimɨnɨn whɨra nikɨ whaowaei. Kɨra kɨriir digworaekwo whɨekakɨm inkam nhɨrɨm sɨmiir hauu sɨma saɨnɨm mɨ kɨra tɨ umɨrɨm inkam paeprikabɨm sɨmiir hauu. Mɨ kɨra hɨriinan tɨri mɨ nɨnomor kou hɨrɨn kɨra wɨ digworaekwo whɨekakakar nwowi. Mɨ kɨra kariir mhoɨiyar wɨt. ");
INSERT INTO iws_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Mɨ tɨ bɨiyan inkamɨn ta yai aiir wakaekiyɨn mɨ siya ɨni hɨkakar ywokiyɨn. Dimusi rani, siya umɨr digworaekwo whɨekakak inkam kɨɨngɨn. ");
INSERT INTO iws_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisɨs siya tɨ inkamɨn siir mhɨi kwoɨnɨm hɨkak nwokiyɨm sɨmiir kɨgiyɨn mɨ ɨna boɨnɨn, inkamɨn digworaekwo hoɨmgakakɨn, siya Adi Komii siir omɨn siya kɨgrɨraowiyɨn dimɨn taemɨn ɨmiir siir namɨmɨn wɨ mɨinan mɨrii. ");
INSERT INTO iws_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mɨ haba tɨ tɨdiyɨnɨn yɨuɨs paniyɨn siir no ɨiir nɨnopkainamɨmɨn wɨ mɨinan mɨrii. Mɨ inkamɨn umɨr digworaekwo whɨekakɨn siya wɨ ta haba mɨinan saeya mɨriiya saiir hɨriinan mɨi mɨrii rani. Nɨɨngaka. Yɨo wɨ mɨi komiigɨ komii mɨrii nami Adi Komii siir omɨn digworaekwo whɨekakɨm sɨmiir kɨgrɨraowiyɨn siir namɨmɨn. ");
INSERT INTO iws_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Mɨ kamɨm sɨma hɨriinan wakaekiyɨm mɨ sɨma ɨna boɨnɨm mɨ hɨriinankɨ nɨuwi mɨ kwoɨnbudɨn ɨinokɨinokɨn omwai waiyayokiyokɨiyɨn wɨ nhɨnga haii? ");
INSERT INTO iws_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Mɨ Jisɨs siya ɨna boɨnɨn, dimɨnɨn inkamkɨ tɨr karamae nwowiyɨn yɨm wɨ Adi Komii krɨmiir Wanɨn siyar dirɨraerari. ");
INSERT INTO iws_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Mɨ Pita siya ɨna boɨnɨn, wakae, krɨma krɨmiir omɨn mɨ krɨmiir digworaekwowɨm sɨmiir bɨdi haiburgigɨm mɨ krɨma tɨsi kɨriir mhoɨiya nɨtɨm. ");
INSERT INTO iws_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Mɨ Jisɨs siya sɨmiir boɨnki, ɨhɨ, kara kɨmiirɨn yaimwowar boɨni mɨ yɨpɨkɨ inkamkɨn Adi Komii siya siir iikam whɨekakɨm sɨmiir kɨgɨrkakɨna saiirɨm sɨbgu naɨngwowɨn mɨ siya omaka mɨ wig mɨ nomiiyau mɨ yopii ad yɨnisɨsɨm, sɨmiir haiburgik ");
INSERT INTO iws_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","mɨ tɨ ɨiyɨm Adi Komii siya wɨ hɨriinan ɨi ɨmiirar swokɨ ɨnkɨn hauukɨiyɨuwi. Mhoɨiya ɨiya saeya nɨmbiyami mɨ sɨma kwoɨnbudɨn ɨinokɨinok omwai waiyayokiyokɨiyɨn wɨ siir haii. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Mɨ Jisɨs siya kam ɨuur nwɨso siir kɨgna mɨriiyɨm sɨmiir yɨkɨuna mɨ sɨmiir boɨnmauu, wakae, panao krɨma om komii Jerusalem hɨriir nami. Mɨ yai whɨekakɨm profet kamɨm sɨma wɨn boɨnɨm, Yaowae Adɨn nɨnomor kouanɨn kariiram, sɨma wa nɨmbiyamkɨɨni. ");
INSERT INTO iws_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Mɨ sɨma kariirɨn wɨ kam nhɨrɨm isid whɨranɨm Juda inkam tani sɨmiir hauugi. Mɨ sɨma wɨ kariir nɨgbumbu tɨrbumbu haigɨnɨuwi mɨ wɨ yaeyop kariir mɨ yaswaiyɨuwi ");
INSERT INTO iws_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","mɨ sɨma kariirɨn wɨ ɨdgɨu mɨni nɨpɨmpari mɨ wɨ kariir nɨsomaoki mɨ sɨma kariirɨn hɨriinan tɨri mɨ ɨi kwoɨmaka kara wa swokɨ ɨnsiin ɨdwowi ɨe hɨrankɨ. ");
INSERT INTO iws_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma ta yai aiir bɨ nɨnoknɨnkɨnkɨm. Ta yaiya saiir yaimwokɨyaimwowa saeya sɨmiirsi nɨmprɨoka mɨ sɨma ta yaiya siya boɨna saiir bɨ sɨbgu naɨngwokɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Mɨ Jisɨs siya om komii Jeriko kingiin ha nɨmbiyamɨn mɨ inkam nhwokwɨsae nwɨrɨn siya siyɨu mɨg hɨrar nɨdwowikɨn. Mɨ siya inkamɨm sɨmiiramar mɨ prɨikau prɨikauwikɨn umɨr digworaekwoɨm. ");
INSERT INTO iws_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mɨ siyar wakaewɨn iikam isid komiiyɨn napnaniyɨm mɨ siya kam nhɨrɨm sɨmiir srɨiwɨn, sɨma dimu mɨni? ");
INSERT INTO iws_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Mɨ sɨma siir boɨnki, Jisɨsɨn omisɨm Nasaretanɨn ɨsi napnaniyɨn. ");
INSERT INTO iws_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mɨ siya ɨna kauwok boɨnɨnaekiyɨn, Jisɨs kɨra Devidni isidɨn siir yɨnisɨmkɨn, kɨra kariirsi daɨngwobumbu! ");
INSERT INTO iws_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Mɨ kamɨm bɨi napnamɨm sɨma ɨo siir ywoki, kɨra yai tanki. Mɨ siya ɨna swokɨ kauwok boɨnanaekiyɨn, kɨra Devidni isidɨn siir yɨnisɨmkɨn kɨra kariirsi daɨngwobumbu! ");
INSERT INTO iws_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Mɨ Jisɨs siya ha namɨkwoniyɨn mɨ sɨmiirɨn ɨna boɨnkiyɨn, siirɨn kariiram wɨkɨunani. Mɨ siya kingiin ha nɨtɨn mɨ Jisɨs siya siir srɨigi. ");
INSERT INTO iws_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Kɨra panɨɨna naɨngwowi, kara kɨriirɨn pɨ dimu tɨri, ha? Mɨ siya boɨn, Bɨiyan Inkam Komii kariir nhwoɨn wadɨe swokɨ okiyɨm tɨri. ");
INSERT INTO iws_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Mɨ Jisɨs siya siir boɨnki, kɨriir nhwoɨn ha kaoki, kɨriir naɨngwo tɨbmiiya, kɨriir nhwoɨn mɨiyɨk saeya nwowaigɨnɨugikɨn. ");
INSERT INTO iws_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mɨ bɨ kɨmɨmɨnkikɨn siir nhwoɨn ɨna swokɨ kaokiyɨn. Mɨ siya ɨni Jisɨs siir mhoɨiyar yamɨn mɨ ɨni Adi Komii siir inɨg ɨiirar boɨn wadɨekiyɨn. Mɨ iikam isid komiiyɨn sɨma hɨriinan kɨgiyɨm mɨ sɨma ɨni Adi Komii siir inɨg ɨiirar hainankiyɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisɨs siya om komii Jeriko siir yapnɨnopkainam mɨ ɨna yapnamɨn. ");
INSERT INTO iws_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mɨ inkam nwɨrɨn hɨr nwokɨn, siir inɨgɨn Sakiaskɨn. Siya kamɨm omom omomi umɨr haiiyɨm sɨmiir bɨiyan inkamkɨn mɨ siya umɨr hoɨmgakakɨn. ");
INSERT INTO iws_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Siya Jisɨs siir kɨgsɨbɨm mɨnkɨn, siya yɨpɨkɨn. Mɨ iikam isid komiiyɨn sɨma hɨrar nwokɨm mɨ Sakias siya inkam prɨei rani. Mɨ siya Jisɨs siir panɨɨnsi kɨgsi. ");
INSERT INTO iws_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Mɨ siya bɨiya iwɨtamkwokɨn mɨ pae wɨrɨn siir iiyam, Jisɨs siir kɨgwɨnam. Siya bɨdi yɨnoknɨnkɨnɨn Jisɨs siya pɨ tɨ siyɨu ɨiir napnani mɨ siya tɨ pae ɨiir asi nii wɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Mɨ Jisɨs siya ta maeyauwa saiir nɨmbiyamɨn mɨ siya koua hɨriir kaokiyɨn mɨ siya siir boɨnki, Sakias, kɨra ha wɨuuni. Panao kara pɨ kɨriir omaka hɨr nwowi. ");
INSERT INTO iws_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Mɨ siya ha nɨuun ɨdudunaiiniyɨn mɨ siir mhɨi kwoɨnɨm maɨrgɨmaɨrga ha nwonaiiniyɨn mɨ siya Jisɨs siirɨn siir omaka hɨriir yɨkɨunam. ");
INSERT INTO iws_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mɨ iikam whɨekakɨm sɨma hɨriinan kɨgiyɨm mɨ sɨma ɨo siir ywo. Siya inkamɨn dimɨn biyɨekakɨn siir omaka whwonkaiyam dimusi namkɨn? ");
INSERT INTO iws_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Mɨ Sakias siya ha nɨnsiin okwokiyɨn mɨ siya Bɨiyan Inkam Komii siir boɨnki, Bɨiyan Inkam Komii kɨra wakae! Kara panaoɨn digworaekwo whɨekakɨm pɨ bopwoniya tɨr haigɨn mɨmɨri mɨ kara haɨmii pɨ kam paeprikabɨm sɨmiir hauuwi. Mɨ kara inkam nwɨrni dimɨnɨm kara nɨksɨsae haiiyɨm mɨ kara siirɨn ɨdɨp ɨdɨpɨn wɨ kwiya swokɨ hauukɨiyɨuwi. ");
INSERT INTO iws_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Mɨ Jisɨs siya siir boɨnki, tapa Adi Komii siya bɨdi swokɨ anmaiwarkainam iikamɨm ta omaka saiir nwowɨm sɨmiirɨn. Tɨ inkamɨn siya ɨriipɨ hɨriinan Ebraham siirar yɨnisɨmkɨn. ");
INSERT INTO iws_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Yaowae Adɨn nɨnomor kouanɨn siya iikamɨm kɨguguwɨm sɨmiirɨm hansɨrikɨn sɨmiir nanmaiwarkainam. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Iikamɨm sɨma ta yai aiir wakaekiyɨm mɨ Jisɨs siya boɨniyɨo yai kwɨra sɨmiir warar mɨ ɨnkɨn boɨn. Mɨ siya om komii Jerusalem siir kingiin bɨdi ywowamɨn, sɨma hɨnɨɨna naɨngwokɨm Adi Komii siya siir iikam whɨekakɨm sɨmiir kɨgɨrkakana, saeya wɨ kingiina kwombini. ");
INSERT INTO iws_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Mɨ siya ɨna boɨnɨn, inkam komii nwɨrɨn siya hɨr nwowɨn om whɨr nami mɨ sɨma siirɨn wɨ nu kɨgrɨraowan inkam komii dɨkmwon owaigɨnɨu. Mɨ mhoɨiya siya wa swokɨ ɨti siir oma tɨriir. ");
INSERT INTO iws_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Mɨ siya mɨiyan kamɨm sɨmiir haiburgigɨm tɨrɨn mɨ siya siir mɨiyan kam ɨuurɨm sɨmiirɨm yɨkɨugi mɨ siya umɨrɨm sɨmiirɨn paeyarɨm hasɨsa hɨd hauugi. Mɨ siya sɨmiirɨn ɨna boɨnkiyɨn mɨ kɨma umɨr mɨi sɨmiir mɨrii mɨ kɨma wɨ kariirar mɨrii kɨgwɨn. ");
INSERT INTO iws_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mɨ tɨkɨ inkamɨn siir oman iikamɨm sɨmiir mhɨi kwoɨnɨm ɨni hauugɨ hauuga whiyɨekiyɨm siiramɨn. Mɨ kam nhɨrɨm sɨma kam nhɨr ɨmiir boɨn siir mhoɨiya namɨm. Mɨ sɨma boɨn, krɨma pɨ boriisopi tɨ inkamɨn siya krɨmiir nu kɨgrɨraowan inkam komii kɨpi nwo. ");
INSERT INTO iws_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mɨ sɨma siirɨn ɨni nu kɨgrɨraowan inkam komiiyar yokmwɨn owaigɨnɨuɨn mɨ mhoɨiya siya ɨna swokɨ ɨtɨn. Mɨ siya boɨn, tɨ mɨiyan kamɨm sɨmiirɨm dɨkɨugi, bɨiya umɨr kara nikɨ hauugikɨm. Mɨ kara nɨnoknɨnkɨnɨm tɨri sɨma tɨ umɨrɨm kara hauuwɨm sɨma nwɨnwɨra pariiga swokɨ ɨnkɨn mɨrii hai. ");
INSERT INTO iws_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Mɨ nwɨrɨn bɨi siya yɨt, yɨo hɨnɨɨna boɨn, bɨiyan inkam kara umɨr mɨi tɨ umɨr paeyar haso sowiirɨn, umɨr paeyarɨm kam nwɨra (200 Kina) mɨrii hai. ");
INSERT INTO iws_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mɨ bɨiyan inkam ɨeya boɨnki, kɨra mɨiyan inkam wadɨekɨn mɨ mɨi mɨiyɨkar sɨbgu mɨriikɨn. Mɨ kɨra dimɨn sɨmɨn siirɨn bɨdi sɨbgu kɨgrɨraowɨn. Mɨ kara kɨriirɨn pɨ inɨg komiigak nwowaigɨnɨugi, kɨra wɨ om komii komii ɨuurɨm sɨmiir kɨgrɨraowi. ");
INSERT INTO iws_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Mɨ nwɨsaka ɨna mɨ ɨtɨn, yɨo ɨna mɨ boɨnɨn, bɨiyan inkam kara kɨriir umɨr paeyar haso, sowiirɨn umɨr paeyarɨm ɨuura (100 Kina) swokɨ ɨnkɨn mɨrii hai. ");
INSERT INTO iws_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Mɨ bɨiyan inkamɨn siya siir boɨnki, kara kɨriirɨn om komii ɨriiyarɨm sɨmiir kɨgrɨraowan inkam nɨkmwɨn owaigɨnɨuwi. ");
INSERT INTO iws_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Mɨ nwɨrɨn ɨna mɨ ɨtɨn, yɨo ɨna mɨ boɨnɨn, bɨiyan inkam kɨriir umɨr paeyar haso tɨsi tapi nwowo. Kara sowiirɨn kwankab aka kogɨn. ");
INSERT INTO iws_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kara kɨriirsiyɨn dimusi bɨ nɨdidgɨn, kɨra inkam paii rani. Dimɨnɨn inkam nwɨrkɨ haigɨniyɨn mɨ kɨra siirsi bɨ naɨngwoyɨmiyokikɨn pɨ kɨra mɨ haii. Mɨ sasaeyɨm inkam nwɨrkɨ nɨnkɨniyɨm, ɨriipɨ hɨriinan pɨ kɨra swokɨ ɨngugu haii. ");
INSERT INTO iws_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mɨ bɨiyan inkamɨn siya tɨ mɨiyan inkam ɨiir boɨnki, kɨra mɨiyan inkam biyɨekɨn! Kɨriir yaiya kara kɨriirɨn wɨ saiirsi boɨn wokiyopnatkaigi. Mɨ kɨra hɨriinan nɨnoknɨnkɨni, kara inkam mɨiyɨk rani mɨ kara dimɨnɨm inkam nwɨrkɨ haigɨniyɨm pɨ kara mɨ haii mɨ sasaeyɨm inkam nwɨrkɨ nɨnkɨniyɨm pɨ kara mɨ ɨngugu haii. ");
INSERT INTO iws_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Mɨ kɨra umɨrɨm mɨiyanau haigi karamae dimusi nwokɨn mɨ kara swokɨ ɨtkɨswo wa pinɨ haini, yaeya umɨr nhɨrɨm sɨmiir warar. ");
INSERT INTO iws_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Mɨ siya kamɨm siir kingiin nokwowɨm sɨmiirɨn hɨnɨɨna boɨnki, kɨma wara umɨr paeyar haso sowiir hai, ɨkɨ inkamɨn umɨr paeyarɨm kam nwɨrkakɨn siir hauugi. ");
INSERT INTO iws_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Mɨ sɨma siir boɨnki, bɨiyan inkam, siya umɨr paeyarɨm kam nwɨra bɨdi haiyɨn. ");
INSERT INTO iws_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Mɨ siya ɨna boɨnɨn, kara kɨmiir boɨnki, yɨpɨkɨ inkamkɨn digworaekwo whɨekak nonkwowɨm mɨ mɨi mɨiyɨk mɨriiyɨm kara sɨmiirɨn digworaekwo nhɨrɨm wɨ ɨdwowa swokɨ ɨnkɨn hauugi. Yɨpɨkɨ inkamkɨn digworaekwo hoɨmgak karamae nwowɨn mɨ mɨi mɨiyɨk mɨrii karamae nwowɨn mɨ mhoɨiya siya wɨ nɨɨnga nɨɨnga nwowi, digworaekwowɨm wɨ karar swokɨ hai. ");
INSERT INTO iws_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mɨ yɨpɨkɨ iikamɨm sɨma ɨo kariir nwowiyɨm, sɨma pɨ boriisopi, kara sɨmiir mɨ kɨgrɨraowan inkam komii nwowɨm, kɨma sɨmiirɨn tɨriir wɨkɨu nani mɨ sɨmiirɨn kariir whwonkam ɨda dɨsomaoki. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Mɨ Jisɨs siya sɨmiir yai aiir nowarkɨi boɨn dɨgiyɨn mɨ siya bɨiyar yapnamkwokɨn, siyɨuɨn om komii Jerusalem hɨriir namiyɨn siir. ");
INSERT INTO iws_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Mɨ siya om Betfasi om Betani, mhɨu whɨrɨn sɨma dapiyɨn Oliv siir kingiin nwowamɨn mɨ siya bɨiyɨn inkam nwɨso siir kɨgna mɨriiyo sowiir yɨkropki. ");
INSERT INTO iws_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Mɨ siya sowiir boɨnmauugi, kowa ɨkɨ omɨn hapi nwowɨn siirɨm dam mɨ kowa pɨ donki haom ɨrɨn siir kɨgi, sɨma bɨdi yɨeyok okwowɨn pae aka. Mɨ siirɨn inkam nwɨrkɨn bɨ nɨdwokɨn. Mɨ kowa pɨ siir whakainani. ");
INSERT INTO iws_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mɨ inkam nwɨrɨn siya kowiirɨn hɨnɨɨna srɨi, kowa wara donkiyɨn dimusi hak hai nami? Mɨ kowa hɨnɨɨna dowarkɨi boɨn, Bɨiyan Inkam Komiiyɨn siya mɨigakɨn siirɨn. ");
INSERT INTO iws_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Mɨ Jisɨs siya sowiirɨn ɨna yɨkropkiyɨn mɨ sowa ha namo mɨ sowa tɨ digworaekwo whɨekakɨm siya boɨnkiyɨn sɨmiirar inɨ kɨgɨu. ");
INSERT INTO iws_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Mɨ sowa wɨeyɨnsopɨn tɨ donki haomɨn siir nɨeyokɨn siir houwhroko mɨ siir adɨn siya sowiir srɨi, kowa warɨ donki haomɨn siirɨn whɨsarii dimusi haki, ha? ");
INSERT INTO iws_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Mɨ sowa ɨna boɨno, Bɨiyan Inkam Komii siya siirɨn mɨigakɨn. ");
INSERT INTO iws_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Mɨ sowa donki haomɨn ɨna hainaniyɨn Jisɨs siirɨm. Mɨ sɨmiir yɨuɨsɨm donki siir ɨdwo yɨtɨmwanɨu. Mɨ sɨma Jisɨs siirɨn siir ɨdwo yokmwɨn ɨdwo. ");
INSERT INTO iws_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Mɨ siya donki siir ɨdwo ha nɨdwo namɨn mɨ iikamɨm sɨmiir yɨuɨsɨm ɨni siyɨu ɨiirar pɨuai wɨnɨm. ");
INSERT INTO iws_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Mɨ siya mhɨu Oliv siir haiburgigɨn mɨ ɨna yɨuunamɨn mɨ siyɨuɨn om komii Jerusalem siirɨm namiyɨn, siir kingiin nwoniyɨm mɨ iikam isid komiiyɨn siir kɨgna mɨriiyɨm sɨma ɨna maɨrgɨmaɨrga bwakai namɨm. Sɨma mɨn swokɨ aɨngwokikɨm, kɨrɨepai kɨrɨepaiyɨm bɨiya sɨma kɨgɨm mɨ sɨma ha kauwoknanaekiyɨm mɨ sɨma ɨni Adi Komii siir inɨg ɨiirar hainankiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Mɨ sɨma ɨna kauwokiyɨm, Adi Komii kɨra tɨ inkam komii nu kɨgrɨraowiyɨn Bɨiyan Inkam Komiiyɨn siir inɨgɨ nɨtɨn siir whɨnkɨnsiis haigɨnɨu! Iikamɨm nɨnomor kouanɨm sɨma Adi Komii siiramɨn wɨ wadɨeyar nwowi mɨ wɨ mhɨi hiinsɨma nwowi. Krɨma Adi Komii krɨmiir Wanɨn nɨnomor kouanɨn siiramar daɨngwo ɨski siir inɨg hainanɨm. ");
INSERT INTO iws_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mɨ Farisi kam nhɨrɨm sɨma tɨ iikam isid komiiyɨn saɨka nɨnkɨn okɨm mɨ sɨma Jisɨs siir boɨnki, nowamwarkaiyɨuan inkam, kɨra ɨo kamɨm kɨriir kɨgna mɨriiyɨm sɨmiir dwoki sɨma yai tanki! ");
INSERT INTO iws_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mɨ siya ɨna yowarkɨi boɨnɨn, kara kɨmiir boɨnki mɨ yai mɨkrɨm nwowi mɨ wɨ siiya ɨmar kauwok boɨnki, kariir inɨg hainanam. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Mɨ Jisɨs siya om komii Jerusalem kingiin nwowamɨn mɨ siya om komii ɨiir kɨgɨn mɨ siya ɨni siirsiyar youwɨn. ");
INSERT INTO iws_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Mɨ siya boɨn mɨ ta ɨi aiirɨn kɨra hɨnɨɨna nɨnoknɨnkɨni, siyɨuɨn hiinsɨma kɨriir nwowaigɨnɨuwiyɨn, yɨo wɨ wadɨeyar mɨ owi mɨ tariinanɨn tɨ dimɨnɨm aowa aowa nwowɨm, kɨra sɨmiir bɨ kɨgɨm. Mɨ kɨma wɨ mɨiyɨk nwo rani. ");
INSERT INTO iws_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kɨra wakaeki! Mhoɨiya ɨi kwɨra nɨmbiyami mɨ sɨma wɨ ɨo kɨriir nwowi mɨ sɨma ɨeyɨn wɨ whɨra nopi yaii kɨnaka nɨniiyɨm. Mɨ kɨriirɨn hɨnda tɨnda wɨ sɨmar kaeyokwai ɨrkaki. ");
INSERT INTO iws_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Mɨ sɨma wɨ kɨriir nonkwobumbu nɨnkɨni mɨ iikamɨm ta hiir aiir kɨnaka nwowɨm sɨmiir warar. Mɨ sɨma siiyam wɨ siiya nhɨrni ɨdwo kɨgnɨnkɨngik rani. Nɨɨngaka. Dimusi rani, kɨra ɨiya Adi Komii siya kɨriir nanmaiwarkainanaei saiir bɨ naɨngwokɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Mɨ Jisɨs siya omaka Adi Komii siira saiir napnɨnopkai namɨn mɨ siya iikamɨm umɨr mɨi ta omaka aiir mɨriiyɨm sɨmiirɨn ɨna yɨkrɨrop atkɨigigiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Mɨ siya sɨmiir swokɨ boɨnki, Yokwo Komii saeya hɨnɨɨna boɨnka, kariir omaka Adi Komii siirɨm kwɨsboɨnan omakaka. Kɨma saiirɨn hɨiyan kamɨm sɨmiir omakanan dirɨraerarkɨm. ");
INSERT INTO iws_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Mɨ ɨinokɨinokɨn siya iikamɨm sɨmiirɨn omaka Adi Komii siira saiirar nowomwarkaiyɨuwikɨn. Mɨ prismi yaowae adɨm mɨ siyɨu komii nɨnoknɨnkɨniyɨm mɨ iikamɨm sɨmiir bɨiyan kam ɨkɨm, sɨma Jisɨs siir nɨsomaoni siyɨuɨm noksɨrkɨm. ");
INSERT INTO iws_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Mɨ iikam whɨekakɨm sɨma Jisɨs siir yai wakaeyamar naɨngwokrɨpkaii mɨ kamɨm sɨmiir bɨi nwowiyɨm siir nɨsomaoni siyɨuɨm asi noksɨrgugugɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Mɨ ɨigwɨra Jisɨs siya omaka Adi Komii siira, iikamɨm sɨmiirɨn yai saiir hɨr boɨnmɨmauugɨn mɨ yaiwɨn mɨiyɨka saiir warar mɨ ɨnkɨn ɨisiisiimauugɨn. Mɨ prismi bɨiyan inkamɨm mɨ kamɨm siyɨu komii nɨnoknɨnkɨniyɨm mɨ kamɨm bɨi nwowi ɨkɨm. Sɨma siirɨm nɨtkɨm. ");
INSERT INTO iws_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Mɨ sɨma siir boɨnki, kɨra krɨmiir boɨnmauugi, kɨra inɨg komii papi haigɨn kɨra ta mɨiya saiir mɨriiyɨn? ");
INSERT INTO iws_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Mɨ siya sɨmiirɨn hɨnɨɨna yowarkɨi boɨnki mɨ an kara ɨriipɨ hɨriinan yai kwɨra kɨmiir srɨiyɨm tɨri. Kɨma kariir boɨnmauugi, ");
INSERT INTO iws_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ta baptaisa Jon siya hauuwa ya Adi Komii siirga, iyɨe? Inkamniyar dimɨnka? ");
INSERT INTO iws_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Mɨ sɨma ɨni sɨma sɨma yomboɨn amboɨnɨm mɨ krɨma hɨnɨɨna boɨni siya Adi Komii siir hɨranka nɨtkɨn. Mɨ yɨo siya wɨ hɨnɨɨna kwaboɨni, kɨma Jon siirɨm naɨngwo tɨbmii karamae dimusi nwokɨm, ha? ");
INSERT INTO iws_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Mɨ krɨma ha boɨni, yɨo inkamniyar dimɨnkɨn mɨ iikam whɨekakɨm sɨma wɨ siiyani krɨmiir kaiyɨmɨki whɨsarii rani, sɨma hɨnɨɨna naɨngwo tɨbmiikɨɨni Jon siya profetkɨn. ");
INSERT INTO iws_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Mɨ sɨma Jisɨs siir yai aiir asi nowarkɨi boɨnkɨm, krɨma nɨnoknɨnkɨn tani, Jon siirɨn nhɨnga nɨmbingɨn. ");
INSERT INTO iws_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Mɨ siya sɨmiir boɨnki mɨ ankara ɨriipa hɨriinan kara kɨmiirɨn pɨ hɨnɨɨna mɨ boɨnmauu rani. Kara ta mɨiya saiir mɨriiyɨn tɨ hɨnɨɨn inɨg komiiyɨn nhɨnga hauugɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jisɨs siya ta boɨniyɨo yaiya iikamɨm sɨmiir boɨnka. Inkam nwɨrɨn wain nɨnkɨnkɨn numɨr. Mɨ ta wain numɨra kam nhɨrɨm sɨmiir ɨɨn yonkwo sɨma umɨr mɨi saiir mɨriiyɨm. Mɨ siyarɨn om whɨrɨn aru nwowɨn ɨi haruwa bɨ ninɨ owoukɨn siirɨn. ");
INSERT INTO iws_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Mɨ ɨiya numɨr waina saiir nɨngugu haiyana mɨ siya whɨsarii mɨi prɨimɨriiyan inkam nwɨrɨn siir yɨkropki, tɨ kamɨm numɨr waina saiir mɨriiyɨm sɨmiirɨm. Siya mɨnam naɨngwokɨn ta numɨra saiir nae nhɨrɨm siir hauuwɨm. Mɨ kamɨm sɨma ta numɨr aiir mɨriiyɨm sɨma tɨ whɨsarii mɨi prɨimɨriiyan inkamɨn siir yɨpɨmparki. Mɨ siirɨn ɨni nɨɨnga nɨɨnga swokɨ ɨkropkiyɨn. ");
INSERT INTO iws_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mɨ siya mɨiyan inkam nwɨrɨn ɨna swokɨ ɨkropkiyɨn sɨmiirɨm. Mɨ siirɨn ɨriipɨ hɨriinan ɨna mɨ tɨrbumbu haigɨnɨugiyɨn mɨ sɨma siirɨn ɨni nɨɨnga mɨ ɨkropkiyɨn. ");
INSERT INTO iws_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Mɨ siya mɨiyan inkamɨn nwoɨmaka ɨna mɨ ɨkropkiyɨn. Mɨ sɨma siir tɨrbumbu haigɨnɨugi mɨ siirɨn yaba hɨriir yɨkrɨrop apniki. ");
INSERT INTO iws_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Mɨ numɨran adɨn siya boɨn, kara wɨ panɨɨna tɨri? Kara wɨ kariir yɨnisɨm yɨnkamiyɨnɨn kara naɨngwokwonanaeiyɨn wɨ siirar nɨkropki mɨ sɨma wɨ siir yaiyar nwokɨ wakaeyoknaei. ");
INSERT INTO iws_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Mɨ tɨ kamɨm ta numɨr aiir mɨriiyɨm sɨma kɨgwɨn siir yɨnisɨmɨn namɨn. Mɨ sɨma hɨnɨɨna boɨn, tɨ yɨnisɨmɨn siya numɨran adɨn siir yɨnisɨmkɨn. Humbae, krɨma siir nɨsomaowi mɨ ta numɨra saiirɨn wɨ krɨmar nwokɨ onkwowɨm. ");
INSERT INTO iws_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Sɨma siirɨn numɨra saiir hɨrankɨ kinaniyamɨn mɨ siirɨn numwo hɨr yɨsom ɨtkɨngik. Mɨ Jisɨs siya sɨmiir srɨigi mɨ ta numɨra saiir adɨn siya sɨmiirɨn wɨ panɨɨna tɨri, ha? ");
INSERT INTO iws_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Mɨ siya wa nɨti, tɨ kamɨm ta numɨr aiir mɨriiyɨm wɨ siya nɨsomsom aokaowi. Mɨ siya ta numɨr waina kam nhɨrmi hauugi. Mɨ tɨ iikamɨm sɨma hɨriinan wakaeyɨm mɨ sɨma ɨna boɨnɨm, siya hɨriinan kɨpi tɨrmɨmɨn. ");
INSERT INTO iws_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jisɨs siya sɨmiir kaokiyɨn mɨ ɨna srɨigiyɨn, ta yaiya Yokwo Komii saiir nwowɨm saiir yaimwoka yaimwowa panɨɨna boɨnka? Tɨ yɨnpaeyɨn omaka mɨriiyan kamɨm sɨma nɨtkaigiyɨn tariinanɨn siya ɨni bɨiyan yɨnɨn omaka kougou nwowɨn siir hɨriinan yɨmbiyamɨn. ");
INSERT INTO iws_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Iikamɨm sɨma tɨ yɨnpaeyɨn siir ɨdwo nɨkii, wɨ hindara nɨki ɨkrɨmkrɨp ɨuguguski. Mɨ tɨ yɨnpaeyɨn siya inkam nwɨrni ɨdwo nɨkii mɨ siya wɨ tɨ inkam ɨiir nɨsɨɨmsɨɨn ɨuguski mɨ wɨ dimɨn sɨsɨmnan namwo ɨuwi, Jisɨs siya hɨnɨɨna boɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mɨ kamɨm siyɨu komii nɨnoknɨnkɨniyɨm mɨ prismi bɨiyan inkam ɨkɨm sɨma ɨna nɨnoknɨnkɨnɨm Jisɨs siya ta boɨniyɨo yaiya sɨmiirar boɨni. Mɨ ta ɨi aiirarɨn sɨma ɨna nhɨɨngiyɨm siir nonkwowam mɨ ɨni iikam ɨmiirsi yɨdidɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mɨ sɨma siirɨmɨn ɨna kaowɨm. Mɨ sɨma kam nhɨrɨm sɨmiirɨn umɨr saɨngi mɨ ɨna yɨkropkiyɨm siir kanau kɨgam. Mɨ tɨ kamɨm sɨma inkam mɨiyɨknan nɨksɨsaenamkɨm, sɨma siirɨm kɨnankɨugɨm. Siya pɨ yai biyɨe kwɨr boɨni mɨ sɨma siirɨn wɨ inkam komiiyɨn nu kɨgrɨraowiyɨn wɨ siir ɨɨn hauuwi siya hɨdam mɨ siir wɨ hɨk kɨmpɨpɨsu siya hauuwi. ");
INSERT INTO iws_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Mɨ tɨ kamɨm kanau kaowɨm sɨma Jisɨs siirɨn hɨnɨɨna boɨnki, inkamɨn dimɨn taemɨnɨm sɨm nowamwarkaiyɨuwiyɨm krɨma bɨdi yɨnoknɨnkɨnɨm, kɨriir yaiya saeya ɨni wadɨeyar ywowa, kɨra iikamɨm sɨmiirɨn yai mɨiyɨk ɨmiirar sɨbgu boɨnmamauuwikɨn. Kɨra kamɨm inɨgakɨm sɨmiirsi bɨ nɨdidikɨn. Nɨɨngaka. Kɨra Adi Komii siir siyɨuɨm mɨ siir yaimwokɨyaimwowɨm, iikamɨm sɨmiirɨn saiirar boɨnmamauukɨn. ");
INSERT INTO iws_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kɨra panɨɨna naɨngwowi? Krɨma umɨrɨm takisa inkam komii Sisa om komii Rom kɨgrɨraowiyɨn siir hauu, aniya? Iyɨe? Nɨɨngaka? ");
INSERT INTO iws_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Mɨ Jisɨs siya bɨdi yɨnoknɨnkɨnɨn, ta sɨma siir kɨnankɨua. Mɨ siya sɨmiirɨn hɨnɨɨna asi boɨnkɨn, ");
INSERT INTO iws_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","umɨr kwɨra kariir wɨisiimauugi. Ta aknaɨn inɨg mɨnɨm ta umɨr aiir nwowɨm nhɨniirga? Mɨ sɨma boɨn, Sisa siirga. ");
INSERT INTO iws_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Mɨ siya sɨmiir boɨnki mɨ Sisa siir dimɨnɨn yɨo kɨma om komii Rom siir kɨgrɨraowiyɨn Sisa siirar hauu. Adi Komii krɨmiir Wanɨn siir dimɨnɨm yɨm kɨma Adi Komii siirar timɨ hauu. ");
INSERT INTO iws_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Mɨ ta yaiya saiirɨn iikamɨm sɨmiir whwonkam ɨda wɨ swokɨ kɨnankɨu rani. Dimusi rani, siya yai biyɨe kwɨr bɨ boɨnkɨn mɨ sɨma ta yaiya saiir saiirar yaɨngwokwonanaeiyɨm mɨ sɨma yai bɨ wakae boɨnkɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mɨ kam nhɨrɨm Sadyusini isidɨn sɨmiir hɨranɨm sɨma Jisɨs siirɨm nɨtkɨm. Sadyusi sɨma hɨnɨɨna boɨnikɨm: Inkamɨn naonamiyɨm bɨ swokɨ ɨnsiin ɨdwowikɨm. ");
INSERT INTO iws_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Mɨ sɨma siir srɨigi, inkamɨn dimɨn taemɨn nowomwarkaiyɨuwiyɨn Moses siir yai kwɨra bɨiya krɨmiirɨmɨn hɨnɨɨna wɨnboɨnkika mɨ inkam nwɨrɨn wig nonkwonaei mɨ siya yɨnɨekak bɨ nwokɨn mɨ ha naonami mɨ tɨ inkamɨn siir wiga wɨ siir nomousɨm ɨeyar swokɨ haii. Mɨ siya wɨ siir yaowaeyɨn siir yɨnisɨm ɨmiir nwokɨ iyɨowɨm. ");
INSERT INTO iws_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Mɨ iwɨnyaowɨm ɨriiyar nwɨsa nwowi. Mɨ yaowaeyɨn wig siya yonkwona mɨ siya ɨni yɨnisɨm karamaeyar yaonamɨn. ");
INSERT INTO iws_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mɨ nwɨsaka siya swokɨ onkwona ta wig aiirɨn. ");
INSERT INTO iws_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Mɨ mhoɨiya nwoɨmaka ɨriipɨ hɨriinana mɨ tɨr. Mɨ tɨ iwɨnyaowɨm ta wig aiir nonkwonam sɨma ɨni yɨnɨe niyɨo karamaeyar yaokaowɨm. ");
INSERT INTO iws_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Mɨ mhoɨiya ta wiga ɨriipa hɨriinan ɨna mɨ aonama. ");
INSERT INTO iws_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mɨ ɨiya inkamɨm naonamiyɨm sɨma nɨnsiin ɨdwowi, ta wiga saeya wɨ nhɨniir wig nwowi, tɨ iwɨnyao ɨriiyar nwɨso saiir nonkwonam sɨma? ");
INSERT INTO iws_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Mɨ siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨnki mɨ tariinanɨn tɨ nu ɨiirɨn wigkamɨm wa napnɨnkwonaei. ");
INSERT INTO iws_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Mɨ iikamɨm naokaowɨm sɨma ha swokɨ ɨnsiin ɨdwowi mɨ omwai waiyaei mhoɨiya sɨma wɨ wigkam nɨnap nonkwonani siyɨugak nwo rani. ");
INSERT INTO iws_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Mɨ sɨma wɨ nao rani. Sɨma wɨ Adi Komii siir paekwosɨmɨm sɨmiir hɨriinan nwowi. Adi Komii siyar hɨdnɨnsiin ɨdwokɨn ɨe hɨrankɨn. Mɨ sɨma wɨ siir yɨnisɨm asi nwowi. ");
INSERT INTO iws_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moses siya krɨmiirɨn bɨdiyar sɨbgu boɨnmauuwɨn, iikamɨm ɨe ankɨ swokɨ nɨnsiin ɨdwowiyɨm sɨmiirɨn. Yokwo Komii saeya tɨ paekɨkopɨm, paeya nɨutɨngi karamae nwowi saeya nɨunamɨn sɨmiirɨn hɨnɨɨna boɨnka, Bɨiyan Inkam Komiiyɨn siya Ebraham siir Adi Komiikɨn mɨ Aisak, Jekop sowiir Adi Komii warargɨn. ");
INSERT INTO iws_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Mɨ ɨriipɨ hɨriinan kamɨm naowɨm, Adi Komiiyɨn sɨmiir Adi Komii rani. Nɨɨngaka. Tɨ Adi Komiiyɨn kamɨm omwai waiyayokiyokɨiyɨm ɨeyankɨn nɨnsiin ɨdwowɨm sɨmiir Adi Komiikɨn. Mɨ iikamɨm Adi Komii siya nɨmbinɨm mɨ omwai swokɨ waiyam mɨ sɨma ɨinokɨinokɨn wɨ Adi Komii saɨkar nwoyokiyokɨikaeyami. ");
INSERT INTO iws_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Mɨ siya hɨriinan boɨnɨn, kam nhɨrɨm siyɨu komii nɨnoknɨnkɨniyɨm, sɨma siir yai aka ɨna yowarkɨi boɨnɨm, inkamɨn dimɨn taemɨn nowamwarkaiyɨuwiyɨn, kɨra yai wadɨeyar boɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Mɨ sɨma yai nhɨrɨm siir swokɨ srɨiyamɨn ɨni yɨdidɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Mɨ Jisɨs siya sɨmiir boɨnki mɨ sɨma hɨnɨɨna dimusi boɨnkɨm, kraisɨn Devidni yɨnisɨmkɨn, ha? ");
INSERT INTO iws_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Mɨ yokwo Samɨm Devid siya hɨnɨɨna boɨnkɨn, kariir Bɨiyan Inkam Komiiyɨn siya kariir Bɨiyan Inkam Komii ɨiirɨn hɨnɨɨna boɨnkɨn, kɨra kariir ɨɨna ɨɨniga saiir dɨdwo. ");
INSERT INTO iws_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Devid siya Krais siirɨn hɨnɨɨna boɨnkɨn, mhoɨiya kara kɨriir sau omomɨn wɨ kɨriir aowa nokmwɨn owaigɨnɨuwi. ");
INSERT INTO iws_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Devid siya siirɨn Bɨiyan Inkam Komii dapikɨn. Mɨ siya siir yɨnisɨm dimusi swokɨ kwokɨukɨn mɨ Farisi kamɨm sɨma hɨnɨɨna srɨigɨm, ha? Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mɨ ɨiya iikam whɨekakɨm sɨma hɨrar nwowɨm sɨma Jisɨs siir yaiya saiirar wakaekɨm. Mɨ siya kamɨm siir kɨgna mɨriiyɨm sɨmiir boɨnki, ");
INSERT INTO iws_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","kɨma tɨ kamɨm siyɨu komii nɨnoknɨnkɨniyɨm sɨmiirsi mɨntarao. Sɨma yɨuɨs prɨei ara nii apamar naɨngwowikɨm. Mɨ sɨma mɨnamar mɨ aɨngwowikɨm, iikam whɨekakɨm sɨma sɨmiirɨn maeyauwa ɨrɨpa nwowiya saiir nokboɨnmamarɨm. Mɨ sɨma mɨnamar mɨ aɨngwowikɨm iikam whɨekakɨm sɨmiir whwonkam ɨda omaka Adi Komii siir yai nɨdwokai wakaeiya mɨ saiir bɨiyan ipii ɨmiir nɨdwokaiyɨm. Mɨ bɨiyan ipiiya nae komii nɨdwokai aeiyɨm saiir mɨ ɨdwokaiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Mɨ sɨma wig igabaeyɨm sɨmiirar mɨ ɨksɨsaeikɨm. Sɨmiir omaka ɨmiir nii kɨnɨmbɨmbɨr haiikɨm. Mɨ sɨma nhwo prɨei mɨnam kwɨsboɨni iikamɨm sɨmiir inɨg hainanɨm. Mɨ mhoɨiya Jisɨs siya nɨti sɨma wɨ hɨk tɨ hɨriinan dimɨn ɨmiirsi haii. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisɨs siya ha kaoyokiyokɨigiyɨn mɨ siya kam umɨrkakɨm sɨma umɨr mɨiya Adi Komii siir omaka saiira, saiir nɨtkaikaiyɨuwi. ");
INSERT INTO iws_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Mɨ siya kɨg wig igabae paeprikaba mɨ saeya umɨrsɨm kwɨso Adi Komii siir mɨiyanau hɨriir haigigi. ");
INSERT INTO iws_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Mɨ siya ɨna boɨnkiyɨn, kara kɨmiirɨn yaimwowar boɨnki, wig igabae paeprikaba saeya umɨr komii ɨiirar haigigika mɨ saiir siyɨuɨn saeya hauugiya umɨr ɨni tɨ iikam whɨekak ɨmiir haiburɨm. ");
INSERT INTO iws_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tɨ kara hɨriinan dimusi boɨn tani. Mɨ tɨ iikamɨm sɨma umɨr whɨekakakaɨrgɨm mɨ sɨma haɨmiiyara hauugikɨm, dimɨnɨn Adi Komii siir prɨihauunan. Mɨ ta wiga saeya umɨr karamae kɨɨnga. Mɨ saiir umɨr haɨmiisɨma ɨni sɨmiirar hauuswokiyɨm. Mɨ saeya nae saɨnan umɨr karamaeya ywokiya. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kam nhɨrɨm sɨma hɨnɨɨna boɨnkɨm Adi Komii siir omaka aiirɨn, ta omaka saeya omaka wadɨeka sɨma siiya mɨiyɨkɨm sɨmiir pɨuaigɨm mɨ dimɨnɨm Adi Komii siir prɨihauuwɨm sɨmiir warar mɨ pɨuaigɨm. Mɨ Jisɨs siya boɨn, ");
INSERT INTO iws_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","tɨ digworaekwowɨm tariinan kɨma kɨgɨm, ɨiya nɨmbiyami mɨ sɨma siiya nhɨrɨn wɨ siiya nhɨrni ɨdwo kɨgnɨnkɨn o rani. Mɨ sɨma wa nhɨmnhɨnkɨi ɨuguguski mɨ sɨmiirɨn wa nɨtkaigaiki. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mɨ sɨma siir srɨigi, inkam nowamwarkaiyɨuan inkam, tɨ dimɨnɨn wɨ paka hɨnɨɨn ɨiya sae nɨmbiyami? Mɨ wɨ pɨkɨ hɨnɨɨn dimɨnɨn siya nɨmbiyami bɨiyɨn mɨ krɨma wa nwokɨ ɨnoknɨnkɨnɨm, tɨ dimɨnɨm ɨni kingiina nwowɨm wɨ sɨmbi nɨmbiyami, ha? ");
INSERT INTO iws_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Mɨ Jisɨs siya ɨna boɨnɨn, kɨma mɨntarao, kɨmiirɨn wɨ sɨma nɨksɨsaeisi. Mɨ sɨma whɨekakɨm sɨma wɨ kariir inɨg ɨiir ninɨ dapni mɨ sɨma wa boɨni, tɨ inkamɨn Adi Komii siya nɨkropkiyɨn, yɨo karargɨn! Mɨ sɨma wɨ hɨnɨɨna boɨni, ɨiya kingiin nwowa mɨ kɨma sɨmiir mhoɨi kɨpi nam. ");
INSERT INTO iws_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mɨ mhoɨiya kɨma wɨ hɨnɨɨna wakaei saua ɨni nɨnɨta mɨ yaiiya ɨni mɨ ɨniiya mɨ kɨma kakak kɨpi nwo. Tɨ hɨriinan dimɨnɨm bɨi wɨ sɨma nɨmbiyami mɨ kɨma ɨiya Jisɨs siya nɨtɨna wɨ asiima nikɨ ɨmbiyam tani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Mɨ siya sɨmiirɨn hɨnɨɨna boɨnki, nu whɨran iikam isid whɨrɨn, wɨ nu whɨran iikam isid whɨrɨn yaii sɨma nɨnii. Mɨ inkam komii nwɨrɨn nu kɨgrɨraowiyɨn siir isidɨn, wɨ inkam komii nwɨrɨn ɨriipɨ nu mɨ kɨgrɨraowiyɨn wɨ yaii siir isid ɨnaka mɨ nɨnii. ");
INSERT INTO iws_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mɨ tɨ nu ɨiirɨn nɨɨn komii komiiyɨm wa nɨmbiyami. Mɨ maeyau nhɨrɨm mhɨi komii wa mɨ aowi mɨ naokao komii komiiyɨm wa mɨ ɨmbiyami. Mɨ nɨnomor kou hɨrɨn wa nɨmbiyami dimɨn kɨrɨeyɨm kɨmiir kwoɨn ɨmiir kimainokam. ");
INSERT INTO iws_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Mɨ tɨ digworaekwo whɨekakɨm wɨ nikɨ ɨmbiyam tani mɨ sɨma kɨmiir nonkworɨmdɨnu dirɨraerar bumbuwi. Mɨ sɨma kɨmiirɨn wɨ omaka Adi Komii siira wɨ saiir hɨr boɨnhɨuriyɨu boɨni mɨ sɨma kɨmiirɨn wɨ maeyau biyɨe hɨuyokiyokaiiya mɨi biyɨe mɨriiya wɨ saiir nɨkmwɨn apnɨnopkaigi mɨ sɨma wɨ kariir inɨg ɨiir nikwowaisiyɨm tɨri, whɨsarii rani, kɨma kariir mɨi kɨgna mɨriigɨm mɨ kɨmiirɨn wɨ sɨma nɨkɨunami, inkam komiiyɨn nu kɨgrɨraowiyɨn mɨ kamɨm omom omom kɨgrɨraowiyɨm sɨmiiram. ");
INSERT INTO iws_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tɨ hɨriinan ɨiya saeya wɨ kɨmiir siyɨu mɨiyɨk nwowi kariir yaiwɨn kɨbi aiir boɨnmɨmauuwɨm. ");
INSERT INTO iws_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mɨ kɨma yaiya kɨma nowarkɨi boɨnana sɨmiir saiirsi kɨpi naɨngwoyɨmiyok. ");
INSERT INTO iws_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mɨ yaiya kɨma boɨnana wɨ kara hauuwi mɨ nɨnoknɨnkɨn aka. Omomɨm sɨma ta yaiya kara hauuwa wɨ saɨka nantamyɨriyɨr tani. ");
INSERT INTO iws_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kɨmiir yopii ad mɨ nomousɨsɨm nomiiyau mɨ kɨmiir ɨrɨpa o nhɨeyɨm kɨmiirɨn wɨ sɨma kɨnmauu ɨti kɨmiir sau omomɨn sɨmiirɨn. Kɨmiirɨn nhɨrɨm kɨmaka nwowɨm wɨ sɨmar nɨsomaowi. ");
INSERT INTO iws_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Iikam whɨekakɨm sɨmiir kwoɨnɨn haugɨhauga wɨ dimusi whiyɨe rani kɨmiiramɨn, kɨma kariiram naɨngwo tɨbmiigɨm. ");
INSERT INTO iws_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mɨ kɨma kariiram naɨngwo tɨbmiikɨɨni mɨ kariir mɨi aiir sɨbgu onkworɨnu mɨrii mɨ kɨma wɨ swokɨ kɨgugu rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kɨma kɨrɨeyar sɨbgu o mɨ kɨma kɨmiir kwoɨnbudɨn omwai waiyayokiyokɨiiyɨn wa swokɨ haiyɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Mɨ mhoɨiya kɨma ha kɨgi sauan omomɨn ɨni om komii Jerusalem siir namwokwoyokainiyɨm mɨ kɨma ha dɨnoknɨnkɨn, ɨiya tɨ om komii ɨiir nɨdwomwaiyana ɨni kingiin nwowa. ");
INSERT INTO iws_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mɨ taka ɨiya nu Judia hɨran iikamɨm sɨma wɨ mhɨu ɨiir nɨdamami. Mɨ iikamɨm hɨr nwowɨm sɨma tɨ om komii siir haiburgik mɨ maeyau kwɨra dam. Mɨ iikamɨm om komii siir yaba nwowɨm, sɨma siir hɨriir kɨpi swokɨ am. ");
INSERT INTO iws_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Dimusi rani, taka ɨiya ya saeya Adi Komii siya swokɨ tɨrbuwana iikam whɨekakɨm om komii Jerusalem hɨranɨm sɨmiir dimɨn biyɨe whɨekakɨm sɨmiirsi mɨ yai whɨekakɨm Yokwo Komii saiir hɨr nwowɨm wa nɨmbiyamkɨɨni. ");
INSERT INTO iws_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Mɨ naɨngwoyɨmiyok komiiga wigɨm yɨnpɨugak nwowɨm mɨ wigɨm yɨnisɨm mwɨi haigiyɨu ɨmiiyaeyɨm ta ɨiya saiirɨn! Hɨk komiiya wɨ tɨ nu ɨiir nɨmbiyami mɨ Adi Komii krɨmiir Wanɨn siir kwoɨnɨn haugɨhauga whiyɨeya wɨ tɨ iikam isidɨn siir naeyɨskaiyɨuwi. ");
INSERT INTO iws_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mɨ sɨmiirɨn wɨ kamkɨu ɨeyar nɨuguguski. Mɨ sɨmiirɨn wɨ sɨmiir sauan omom ɨeyar nɨnkɨnɨkou hainami mɨ sɨmiirɨn nu whɨran isidɨn sɨmiir bopwoniya ninɨ hauugigi. Mɨ iikamɨm naɨngwo tɨbmii karamaeyɨm sɨmiir ɨga om komii Jerusalem siir namɨkwoni mɨ tɨ iikam isidɨn sɨma wɨ hɨriiyar dɨgi mɨ om komii Jerusalemɨn wɨ sɨmiir inɨga nwowi mɨ wɨ sɨmiir ɨiya Adi Komii siya nɨmbina sɨmiiram wɨ saiirar dɨgi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Dimɨnpai dimɨnpai wa nɨmbiyami bɨe bwan nauun sɨmiirɨn. Mɨ nu tɨrɨn iikam isid whɨekakɨm sɨmiir kwoɨnɨm wa noki, hɨnɨn komiiya bɨpɨibɨpɨiyakɨna whɨi komii Solwara hɨr saiirsi. ");
INSERT INTO iws_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mɨ iikam whɨekakɨm sɨmiir kwoɨnɨn wa naɨngwowi. Aei! Dimu dimɨn biyɨekɨn krɨmiir nɨmbiyamɨn mɨ sɨmiir kwoɨnɨn wa noki mɨ nhwo wa mɨ aowabrombrokainami. Dimusi rani, dimɨn komii komiiyɨm nɨnomor kouanɨm wɨ nɨɨnanar nɨtki. ");
INSERT INTO iws_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Takana saeya nɨmbiyami ɨiya mɨ wɨ sɨma kɨgwɨni kara Yaowae Adɨn nɨnomor kouanɨn ɨni waumɨrsɨm kwɨra saɨka nɨnkɨn ɨtɨn, siya kɨrɨe komiigakɨn. Mɨ dimɨn komiiyɨn paenan nɨuyaeiyɨn wɨ saɨka nɨnkɨn ɨti. ");
INSERT INTO iws_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mɨ mhoɨiya tɨ dimɨn hɨriinanɨm sɨma nɨmbiyam bwakaii mɨ ta ɨiya kɨma wa dokwo. Mɨ kɨmiir mwowɨm wa kɨnɨnsiina kaoki. Dimusi rani, ɨiya Adi Komii siya kɨmiir nanmaiwarkainana saeya kingiin bɨdi yamwoniya. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Mɨ Jisɨs siya boɨniyɨo yai kwɨra sɨmiir boɨnki. Siya ɨna boɨnɨn, kɨma whrou siir kɨgi mɨ pae nhɨrɨm sɨmiir warar. ");
INSERT INTO iws_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Mɨ kɨma hɨnɨɨna kɨgi auwɨm ɨni nɨisabɨm whrou wokam, kɨma ha dɨnoknɨnkɨn op komiigɨ nɨuni ɨiya ɨni kingiin nwowa. ");
INSERT INTO iws_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mɨ ɨriipɨ hɨriinan kɨma tɨ digworaekwo whɨekakɨm nɨmbiyamɨm sɨmiir kɨgi mɨ kɨma wa dɨnoknɨnkɨnki, ɨiya Adi Komii siya siir digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana ɨni kingiin nwowa. ");
INSERT INTO iws_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Kara kɨmiirɨn yaimwowar boɨnkɨɨni, iikam whɨekakɨm ta ɨi aiir nikɨ owɨm sɨma wɨ nikɨ ao rani mɨ tɨ dimɨn whɨekakɨm sɨma wa nɨmbiyami. ");
INSERT INTO iws_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nu nɨnomoro yo wa dɨgi mɨ kariir yaiya wɨ wara dɨg rani. Nɨɨngaka. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Mɨ kɨma, kɨmasiyar mɨntarao ɨinokɨinokɨn kɨma nae naeyarɨmar kɨpi naɨngwo, kɨma opa kwiyae whaowaeiya saiir kɨpi kwiyae. Mɨ kɨma dimɨn taemɨnɨm pɨu aiir nwowaigɨnɨuwiyɨm wadɨe, sɨmiiram kɨpi naɨngwo. Mɨ siyɨu hɨriinanɨn kɨmiirɨn wɨ siya nikwowaisii, kara Yaowae Adɨn nɨnomor kouankɨn nɨtɨn kariir ɨiya saeya wɨ kɨmiirar nɨmbini, sauɨn wraisu namɨtɨuwiyɨn siir hɨriinan. ");
INSERT INTO iws_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ɨiya kara swokɨ ɨti, ta ɨiya iikam whɨekakɨm mɨ nu haɨmiihaɨmiiyɨm hɨnda tɨnda nwowɨm wɨ sɨmiir nɨmbiyami. ");
INSERT INTO iws_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ɨinokɨinokɨn kɨma hindara waikao. Mɨ ɨinokɨinokɨn kɨma nhwo Adi Komii siirɨmar kwɨsboɨnanae, siya kɨrɨe kɨmiir hauuwɨm. Mɨ tɨ dimɨnɨn siya nɨmbiyami mɨ kɨma wɨ wadɨeyar nwoki mɨ kɨma wɨ Yaowae Adɨn nɨnomor kouanɨn wɨ siir whwonkam ɨda nokwowi. ");
INSERT INTO iws_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Mɨ ɨinokɨinokɨn Jisɨs siya iikamɨm sɨmiirɨn Adi Komii siir omaka saiir hɨr nowamwarkaiyɨugɨn. Mɨ nɨiyaka siya pɨ mhɨu whɨrɨn sɨma dapiyɨn Oliv pɨ siir ninɨ whwonkaowi. ");
INSERT INTO iws_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Mɨ iikam whɨekakɨm sɨma ɨɨmuma nhɨngiyakwokikɨm Jisɨs siir yaiya saiir wakaeyɨm Adi Komii siir omaka saiir hɨr. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Mɨ ɨiya wou nikwo aeiya dimɨn whɨrkɨ kɨmbu karamae nwowiya bretɨn yis karamaeyɨn siira, sɨma saiirɨn Pasova dapikɨm saeya wɨ sapi nɨmbiyami. ");
INSERT INTO iws_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Mɨ prismi yaowae adɨm mɨ kamɨm siyɨu komii nɨnoknɨnkɨniyɨm, sɨma Jisɨs siir nɨsomaoni siyɨuam hansɨrkɨm. Mɨ sɨma ɨni iikam ɨmiirsi yɨdidɨm. Mɨ sɨma ɨna boɨnɨm, krɨma Jisɨs siirɨn wɨ panɨɨna nɨsomaowi? ");
INSERT INTO iws_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Mɨ Setan siya Judas Iskariot, sɨma dapiyɨn, siir kwoɨn ɨiir hɨurworwokaigɨn. Mɨ siya tɨ kam ɨuur nwɨso Jisɨs siir kɨgna mɨriiyɨm sɨmiir nwɨrkɨn. ");
INSERT INTO iws_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Mɨ Judas siya prismi yaowae adɨm mɨ kamɨm Adi Komii siir omakaɨm sɨmiir kɨgrɨraowiyɨm, sɨmaka inɨ boɨnɨu. Siya hɨriinan mɨnam tɨrkɨn, Jisɨs siir nɨsomaoni siyɨuɨn siirɨm hansɨrkɨn sɨmiir ɨɨn hauuɨm. ");
INSERT INTO iws_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Mɨ sɨma ɨni maɨrgɨmaɨrga ywokiyɨm. Mɨ sɨma ɨna kitɨbmii boɨnɨm umɨr siir hauuwɨm. ");
INSERT INTO iws_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Mɨ Judas siya sɨmiir yai aiirɨn ɨni wadɨeya ywokiyɨn. Mɨ siya ɨna hansɨrɨn Jisɨs siirɨn sɨmiir kɨnmauu ɨtɨm. Mɨ siya mɨnam naɨngwokɨn iikamɨm sɨma tɨ dimɨnɨn siir kɨpi nɨnoknɨnkɨn. Jisɨs siir kɨnmauu ɨti. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ɨiya wou nikwoaeiya, dimɨn whɨrkɨ kɨmbu karamae nwowiya, bretɨn yis karamaeyɨn ɨna yɨmbiyama. Mɨ ta ɨiya sɨma sibsib yɨnisɨm ɨiirɨn wɨ saiir nɨsomaowi, ta Pasova nae komiiya saiir naeyam. ");
INSERT INTO iws_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Mɨ Jisɨs siya Pita, Jon, sowiir yɨkropki mɨ siya sowiirɨn, ɨna boɨnmɨmauugiyɨn, kowa dam, krɨmiir naeyɨm wou nikwo aeiyɨm, pasova, pɨ kowa tinɨ dirɨraerarkwokɨn, krɨma naeyam. ");
INSERT INTO iws_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Mɨ siirɨn ɨna yowarkɨi boɨnkiyɨn, kɨra panɨɨna naɨngwowi, krɨra pɨ papi dirɨraerar haigɨn kwokɨni? ");
INSERT INTO iws_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Mɨ siya sowiirɨn ɨna boɨnmauugiyɨn, wakae! Kowa pɨ om komiiya hɨriir napnɨnopkainami mɨ inkam nwɨrɨn op twokak haiyapni, siya kowiirɨn pɨ siyɨu hɨr napyɨskaiwɨni mɨ kowa pɨ siir mhoɨiyar dam. Mɨ omaka siya mɨ apnɨnopkainami, wo kowa pɨ saiir warar timɨ apnɨnopkainam. ");
INSERT INTO iws_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mɨ kowa pɨ ta omaka saiir adɨn siir tinɨ boɨnɨu, inkamɨn dimɨn taemɨn nowomwarkaiyɨuwiyɨn, siya hɨnɨɨna boɨnkikɨn, siir maeyaua hɨuyokiyokaiya, nae dirɨraerarana ɨni papi nwowa? Kara mɨ kariir mɨi kɨgna mɨriiyɨm kamɨm, krɨma nɨdwokai aeyam, ta Pasova aiir. ");
INSERT INTO iws_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kowiirɨn wɨ siya nɨisiimauuwi, maeyau komiiya hɨuyokiyokaiya koua nwowa pɨ saiir nɨisiimauuwi. Ta maeyaua hɨi mɨ ipii digworaekwo whɨekakɨm nae mɨn kowa dirɨraeraranɨm ɨni hɨrar nwokwokɨnɨm. ");
INSERT INTO iws_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Mɨ sowa ha namo mɨ sowar kɨg, digworaekwo whɨekakɨm, Jisɨs siyar boɨnkiyɨm hɨrar nwowi. Mɨ sowa yaewouni naeyɨm Pasova ɨna inɨ dirɨraerarɨuwo. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Mɨ ɨiya ha nɨmbiyama Jisɨs siya, siir aposel kamɨm sɨmaka yɨdwokai hɨiya saiir. ");
INSERT INTO iws_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Mɨ siya sɨmiirɨn ɨna boɨnɨn, kara kɨmaka ta yaewou komiiya Pasova, saiirara gwomamaɨr aenami. Kara wɨ kapi naowi. ");
INSERT INTO iws_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kara kɨmiirɨn yaimwowar boɨnkii, kara ta yaewou komiiya Pasova kara wɨ yaeya yaewou swokɨ ikwonikrɨpna rani. Wɨ ɨiya Adi Komii siya, siir iikam whɨekakɨm sɨmiir kɨgɨrkakana, wɨ saiir nadɨgɨuwi. ");
INSERT INTO iws_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Mɨ Jisɨs siya mobisɨmɨn op wainkakɨn ɨra hai mɨ siya nhwo Adi Komii krɨmiir Wanɨn siiram ha kwɨsboɨnkiyɨn mɨ siya ɨna boɨn wadɨekiyɨn, Adi Komii siirɨn mɨ mhoɨiya siya ɨna boɨnɨn, ha, tɨ hai, kɨma kɨmar tɨ onkwokwo kwiyaeyam. ");
INSERT INTO iws_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kara kɨmiirɨn pɨ hɨnɨɨna boɨnkii, kara pɨ ta wain opa tariinanana pɨ saiir kwiyae rani. Nɨɨngaka. Wɨ ɨiya Adi Komii siya siir iikam whɨekakɨm sɨmiir kɨgɨrkakana wɨ saiirar nadɨgɨuwi. ");
INSERT INTO iws_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Mɨ Jisɨs siya bretɨn ɨna mɨ haiyɨn mɨ siya ɨna mɨ kwɨsboɨnkiyɨn, Adi Komii siiram mɨ siirɨn ɨna boɨn wadɨekiyɨn. Mɨ siya sɨmiirɨn ha nɨnoop hauuwɨn mɨ ɨna boɨnkiyɨn, tariigɨna ya kariir kɨp aeya, kara kɨmiirɨn mɨnam hauugɨn, kɨmiir kɨrɨe haigɨnɨuwam. Mɨ kɨma hɨriinan tɨri mɨ wɨ kariiram nwokɨ aɨngwokiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Mɨ sɨma ha nae dɨgiyɨm mɨ siya op mobɨn ɨriipɨ hɨriinana swokɨ tɨr. Mɨ siya sɨmiir boɨnki, tɨkɨ mobɨn op wainkakɨn, ya kariir nhɨe aeya, ya nɨmbin wɨn aeya. Kara kɨmiir whɨnkɨnsiis haigɨnɨuwam naɨngwokɨn. ");
INSERT INTO iws_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kɨma kaoki! Inkamɨn wɨr kariir napwouwanɨn, ɨni kanaka warar nɨnkɨn ɨdwokaiyɨn ta hɨi aiirɨn. ");
INSERT INTO iws_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Yaowae Adɨn nɨnomor kouanɨn wɨ sɨpi naowi, Adi Komii siya nɨmbina wɨ saiir hɨriinanar tɨri. Mɨ kara mɨnsi naɨngwoyɨmiyoki, tɨ inkamɨn wɨr kariir napwouwɨn, siirɨn wɨ hindara nonkwobumbunɨnkɨn ɨuguskii. ");
INSERT INTO iws_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Mɨ siya hɨriinan boɨnkiyɨn mɨ kamɨm siir kɨgna mɨriiyɨm, sɨma ɨni sɨma, sɨmar yɨnsrɨi ansrɨiyɨm, tɨ hɨriinan siyɨuɨn siirɨn wɨ nhɨnga dirɨraerari? Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kamɨm siir kɨgna mɨriiyɨm sɨma yai kwɨra saiir nɨnkɨnwaomwarkɨi boɨnkɨm. Sɨma boɨn, krɨmiir bɨi nwowan inkamɨn yɨpɨkɨn, ha? ");
INSERT INTO iws_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Mɨ Jisɨs siya sɨmiir boɨn, nu kɨgrɨraowiyɨm inkamɨm yɨm inɨg komiigak bɨdi yowɨm, iikamɨm sɨmiir kɨgrɨraowamɨn. Mɨ sɨma ha naɨngwowi iikamɨm sɨmiirɨn nomiiyau dapɨm. ");
INSERT INTO iws_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kɨma, kɨma kɨma hɨriinan kɨpi tɨr. Nɨɨngaka. Inkamɨn kɨmiir bɨi nwowam tɨri, siya inkamɨn i idao nwowiyɨn siir hɨriinan dwo. Mɨ kɨmiir bɨiyan inkamɨn siya mɨiyan inkamnan dwo. ");
INSERT INTO iws_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Yɨpɨkɨn bɨiyanɨn, ha? Mɨ tari tɨ inkamɨn hindara prɨiyɨdwo aeiyɨn siya, iyɨe? Si rani mɨ tari inkamɨn nae dirɨraerariyɨn mɨ tari siya, aniya? Kɨmiir kwoɨnɨm ha naɨngwowi siyaɨrgɨ nɨuwi, aniya? Nɨɨngaka. Yɨo inkamɨn nae naeiyɨn, siya. Mɨ an kara tɨ kɨmakar mɨ ɨdwokai aeyɨn, ɨni ɨriipɨ mɨiyan inkamar mɨ owɨn, kɨmiir kɨnsiis haigɨnɨuwam. ");
INSERT INTO iws_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ɨiya dimɨn taemɨnɨm, kariir kɨnanankɨuɨm, wɨm kɨma kanakar nwokɨm. Kɨma kariir bɨ haiburgɨm, kɨma ɨni kanakar yɨtɨnakɨukrɨpkaiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Mɨ ɨiya Adi Komii siya digworaekwo whɨekakɨm, sɨmiir kɨgɨrkakana ya kariir bɨdi hauugiya. Mɨ ɨriipɨ hɨriinan kara kɨmiir bɨdi mɨ hauugiyɨn. ");
INSERT INTO iws_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mɨ kariir ɨiya digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana kɨma wɨ kanakar nɨdwo ae kwiyaei, kariir hɨi aiirarar. Mɨ kɨma wɨ ipiiya, inkam komiiyɨm nu kɨgrɨraowiyɨm sɨmiira wɨ saiir nɨdwokaii. Mɨ kɨma wɨ Isrel sɨmiir isid ɨuur whɨso wɨ sɨmiir yai hɨdan inkam nwowi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Mɨ Jisɨs siya Saimon Pita siir boɨnki, saimon, saimon! Wakae! Adi Komii siya wadɨe bɨdi yokiyɨn Setan siirɨn, kɨmiir kɨnankɨuwam. Mɨ siya kɨmiirɨn wɨ widɨm sɨm nɨinɨbrombropiyɨm, wɨ hɨriinan nɨinɨbrombropi, witnidɨm yɨm sɨma mɨ kasɨm yɨm sɨma. ");
INSERT INTO iws_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Mɨ kara nhwo Adi Komii siiram bɨdi kwɨsboɨnɨn kɨriiramɨn. Mɨ kɨriir naɨngwo tɨbmiiya wɨ dɨgi rani. Mɨ mhoɨiya kɨriir kwoɨnɨn kisɨna haigii mɨ wɨ kariirɨm nwokɨ ɨtɨm. Mɨ kɨra wɨ kɨriir nomiiyauɨm. Sɨmiir nwokɨ whɨndirɨraerɨm. ");
INSERT INTO iws_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Mɨ Pita siya siir boɨnki, Bɨiyan Inkam Komii, kara maeyaua hɨuyokiyokaiya kɨnaka nɨkɨn hɨugrɨpkɨikikaiyɨm nɨdid rani mɨ kara wɨ kɨnakar mɨ aowi. ");
INSERT INTO iws_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Mɨ Jisɨs siya ɨna boɨnkiyɨn, Pita, kara kɨriirɨn pɨ hɨnɨɨna boɨnkii, panao nɨiyaka ɨuumɨn pɨ nɨk karama nikɨ owi mɨ kɨra kariir inɨg ɨiirɨn, ɨdɨp ɨdɨpɨn wɨ kwoɨma mɨisɨsaei, hɨnɨɨn, kara Jisɨs siir bɨ nɨnoknɨnkɨnkɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Mɨ Jisɨs siya kamɨm siir kɨgna mɨriiyɨm sɨmiir srɨi, bɨiya kara nɨkropkiya kɨmiir mɨ kɨma umɨr mɨiya mɨ nɨb mɨn, kamkɨu mɨn bɨdi hainamɨm, aniya? Mɨ yɨm sɨma ɨna boɨnɨm. Nɨɨngaka, nɨɨngakɨɨnga. ");
INSERT INTO iws_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Mɨ mhoɨiya Jisɨs siya sɨmiirɨn hɨnɨɨna boɨnki mɨ tariinanɨn inkamɨn umɨr mɨiya mɨ nɨb mɨnkakɨ nɨuwi, yɨm sɨmiir warar timɨ ɨnkɨn hainam. Mɨ inkamɨn kamkɨu karamkɨ nɨuwi, yɨo wɨ siir yɨuɨs aiirar timɨ hainam, inkam nhɨrkɨm sɨm saɨnɨm mɨ yɨo siya, wɨ siir kamkɨu ɨiir nwokɨ saɨnɨm. ");
INSERT INTO iws_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Dimusi rani, Yokwo Komii saeya hɨnɨɨna boɨnkika, sɨma siirɨn wɨ ɨkɨ inkam biyɨeyɨm wɨ sɨmiir ɨɨn hauugii. Kara kɨmiirɨn pɨ hɨnɨɨna boɨni, tɨkɨ dimɨnɨn kariirɨn wa nɨmbiyami. Kaimwoka, tɨkɨ yaiyɨm Yokwo Komii saeya boɨnkiyɨm, tariinanɨn tɨsi bɨdi yɨmbiniyɨm. ");
INSERT INTO iws_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma boɨn, inkamɨn nowomwarkaiyɨuwiyɨn, kɨra kɨgii! Krɨma kamkɨuwo whɨsa nwowi, tɨrɨn. Mɨ siya sɨmiir boɨnki, hindara daɨngwo owougi, kɨma kariir yai aiir nɨnoknɨnkɨn tani. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Mɨ Jisɨs siya ha namɨn mɨ siya mhɨu Oliv hɨriir yam, nugak siya nikɨ tɨryakwokɨn saiir hɨriinan. Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma siir mhoɨiyar yam. ");
INSERT INTO iws_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Mɨ siya ha nɨmbiyamɨn ta maeyau aiir mɨ siya sɨmiir boɨn, wɨm kɨma nhwo tɨr kwɨsboɨn, Adi Komii siiramɨn. Mɨ tɨ dimɨnɨn wɨ kɨmiiram pɨ kɨnankɨuwisi. ");
INSERT INTO iws_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Mɨ siya sɨmiirɨn ha haiburgigɨn mɨ yɨo siya arurɨg sa inɨ owɨu. Siiya Inkamkɨ kabɨtkiya mɨ arurɨg ha namɨkaiyɨuwiya saiir hɨriinan. Mɨ siya Adi Komii siiramɨn ogmwo hɨr inɨ hɨuɨu, nhwo siiram kwɨsboɨnɨm. ");
INSERT INTO iws_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Mɨ siya ɨna boɨnkiyɨn, Adi Komii, dimɨnɨn kɨra tɨrɨmar naɨngwowi, tɨ dimɨn biyɨeyɨm, tɨ kariir nɨpiyaokɨiyɨm, sɨmiir swokɨ haiyam tɨri, yɨo kɨriirar kwoɨnkɨn. Kɨra kariir kwoɨn ɨiir kɨpi nwo. Nɨɨngakɨ, nɨɨngakɨɨnga. Kɨra kɨriir kwoɨn ɨiirar dwo. ");
INSERT INTO iws_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Mɨ Adi Komii siir paekwosɨmɨn ha nɨtɨn siiram, siya yaunɨ kɨnsiis haigɨnɨuni. ");
INSERT INTO iws_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jisɨs siya hɨk prasae bɨ haigɨn mɨ siya nhwo ɨna kwɨsboɨnɨn. Mɨ siir pɨua bidɨu ɨni wara yanka nɨnɨtkiya. Mɨ ta bidɨuwa ɨni nhɨenan nua hɨriir yaokiinaiinama. ");
INSERT INTO iws_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Mɨ siya nhwo ha kwɨsboɨn dɨgiyɨn mɨ siya ɨna swokɨ ɨnsiin apnamɨn kamɨm siir kɨgna mɨriiyɨm sɨmiiram. Mɨ siyar kɨgam sɨma nhwo hɨrar whɨni. Ta hɨka ɨni komii yowa mɨ sɨma nhwo asi whɨnamkɨm. ");
INSERT INTO iws_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Mɨ siya sɨmiir boɨn, kɨma nhwo dimuam grɨnkɨn whɨni, ha? Kɨma dɨnsiin ɨdwoki mɨ nhwo kwɨsboɨn yɨ mɨiyɨk rani, Setan siya kɨmiiram kɨnankɨuɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Mɨ Jisɨs siya ha nikɨ boɨnaiyɨn mɨ iikam isid komiiyɨn ɨna yɨtɨn siirɨm. Mɨ inkamɨn sɨma dapiyɨn Judas, tɨ kam ɨuur nwɨso Jisɨs siir kɨgna mɨriiyɨm sɨmiir nwɨrkɨn. Sɨmiir bɨiyɨn siya nwonanikɨn. Siya siir kingiin mɨnam namkɨn siir nankabmamaɨr boɨnɨm. Yɨo sɨmiir ad wanmi siyɨugɨn. ");
INSERT INTO iws_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Mɨ Jisɨs siya siir boɨnki, Judas, kɨra Yaowae Adɨn nɨnomor kouankɨ nɨtɨn siir dimusi napirɨmdɨni mɨ tɨ hɨriinan siyɨu kɨra siirɨn wɨ sau omomɨn siir ɨɨn asi hauugii, aniya? ");
INSERT INTO iws_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Mɨ kamɨm Jisɨs siir kɨgna mɨriiyɨm sɨma tɨ dimɨnɨn nɨmbiyamɨn siir kɨgɨm mɨ sɨma ɨna boɨnɨm, Bɨiyan Inkam Komii, kɨra hɨnɨɨna naɨngwowi, krɨma siirɨn kamkɨuni tɨ hampɨmpɨt, aniya? ");
INSERT INTO iws_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Mɨ sɨmiir nwɨrɨn, prismi bɨiyan inkamɨn siir mɨi mɨriiyɨn inkamɨn, siir ɨnigan wɨɨna siya haɨngrɨp ɨtkiigi. ");
INSERT INTO iws_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Mɨ Jisɨs siya hɨriinan kɨgiyɨn mɨ siya boɨn, tɨ hɨriinan siyɨuɨn kɨra tɨ ɨtkiigi. Mɨ Jisɨs siir ɨɨna siir wɨɨn aiir ha nonkwokiyɨn mɨ ɨni wadɨeyar swokɨ okiya. ");
INSERT INTO iws_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Mɨ mhoɨiya Jisɨs siya prismi yaowae adɨn mɨ kamɨm omaka Adi Komii siir inɨg hainaniya saiir bɨi nwowiyɨm mɨ kamɨm siyɨu komii nɨnoknɨnkɨni ɨkɨm, kɨma siir nonkworɨnuwam nɨtkɨm, kɨma wara kamkɨu dan mɨnɨm hainaniyɨm, pɨ hɨiyan inkamɨn saɨka nɨntɨowi, aniya? ");
INSERT INTO iws_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ɨinokɨinokɨn, kara kɨmakar nwokɨn Adi Komii siir inɨg hainaniya omaka saiir mɨ kɨma kariirɨn, hɨr bɨ nonkwokɨm. Mɨ ta kɨmiir ɨi aeya Setan siya kariir nikwowaisiiyana. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Mɨ siya ha boɨn dɨgiyɨn mɨ sɨma siirɨn ɨna yonkworɨmdɨnu ɨnkikwona apnamɨn. Mɨ sɨma siirɨn prismi yaowae adɨn siir omaka hɨriir hainam. Mɨ Pita siya sɨmiir mhoɨiyar yaprɨraowam. ");
INSERT INTO iws_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mɨ sɨma paeya hira omaka aiir hɨuyokiyokaiya saiir yainau hɨr yamgɨn oni. Mɨ Pita siya ɨni sɨmaka warar minɨ oniyɨuwɨn. ");
INSERT INTO iws_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mɨ mɨiyan wig ɨra saeya Pita siir kɨga, siya pae hɨr nwoniyɨn mɨ saeya boɨn, tɨ inkamɨn Jisɨs saɨkar nwokɨn. ");
INSERT INTO iws_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Mɨ Pita siya ɨna boɨnɨn. Nɨɨngaka. Wig! Kara Jisɨs siir bɨ nɨnoknɨnkɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mɨ mhoɨiya inkam nwɨrɨn ɨna swokɨ boɨniyɨn, ni kɨra tɨ isidɨn siir inkam nwɨrkɨn. Mɨ Pita siya ɨna boɨnkiyɨn, nhɨnga boɨnkɨn! Ankara wara rani. ");
INSERT INTO iws_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mɨ mhoɨiya bɨ kwamhiimhiigɨn, inkam nwɨrɨn, ha swokɨ kwɨtɨn, ɨgao yai siya inɨ boɨni, kaimwokɨɨnga, tɨ inkamɨn siir inkam nwɨr ɨeyaɨrgɨn. Mɨ siya nu Galili hɨran inkamkɨn. ");
INSERT INTO iws_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Mɨ Pita siya ɨna boɨnkiyɨn, nhɨnga boɨnkɨn! Nɨɨngaka. Kara wara dimɨnɨn kɨra boɨnɨn siir bɨ nɨnoknɨnkɨnkɨn. Mɨ siya hɨriinanar nikɨ boɨnɨn mɨ ɨuumɨn ɨna yɨkiyɨn. ");
INSERT INTO iws_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mɨ Bɨiyan Inkam Komiiyɨn ɨni Pita siirar haiyɨug okwo kaokiyɨn. Mɨ Pita siya, ta yaiya bɨiya Jisɨs siya nikɨ boɨna siir, saiir swokɨ aɨngwokiyɨn, tapa nɨiyaka, ɨuumɨn pɨ nikɨ ɨk karam nwowi mɨ kɨra kariir inɨg ɨiirɨn ɨdɨp ɨdɨpɨn wɨ kwoɨma mɨisasaei, kara Jisɨs siir bɨ nɨnoknɨnkɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Mɨ Pita siya idowɨiya ha napniyamɨn mɨ siir noua hɨr yani iyop bwaemaiyɨu. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Mɨ inkamɨn Jisɨs siir kɨgrɨraowɨn siya siir yɨgbumbu mɨ siirɨn ɨna mɨ ɨpɨmparɨn. ");
INSERT INTO iws_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Mɨ sɨma siir whwonkamɨn, yɨuɨsni kikogropɨkou. Mɨ siirɨn ɨna srɨiyɨn, kɨra profet inkamnankɨ nɨuwi mɨ kɨra krɨmiir boɨnki, kɨriirɨn nhɨnga tɨowi, ha? ");
INSERT INTO iws_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Mɨ sɨma siirɨn yai bibiyɨe nhɨrɨm sɨmiir warar yɨnkɨn ɨgbumbu. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Mɨ mhoɨiya bɨeyɨn ha nɨmbi idniyakwokɨn mɨ Isrelmi bɨiyan inkam komii komiiyɨm mɨ prismi yaowae ad ɨkɨm mɨ kamɨm siyɨu komii nɨnoknɨnkɨniyɨm, sɨma ɨrɨpar yamwoni kaunsel sɨmiir omaka aiirarar. Mɨ sɨma Jisɨs siirɨn sɨmiiram yɨkɨunam. ");
INSERT INTO iws_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Mɨ sɨma boɨn, kɨra krɨmiir boɨnki, kɨra Kraiskɨn, iyɨe? Kɨra Krais rani, aniya? Mɨ siya sɨmiir boɨnki, kara kɨmiirɨn pɨ hɨnɨɨna boɨnkii, pɨ kara kɨmiir mɨ boɨni mɨ wɨm kɨma pɨ kariir yai aiir mɨ aɨngwo tɨbmii rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Mɨ kara, kɨmiiramɨn pɨ dimɨnam srɨi mɨ wɨm kɨma pɨ kariir wakae boɨn tani. ");
INSERT INTO iws_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mɨ tariinanɨn mɨ mhoɨiya ɨriipɨ hɨriinan, kara Yaowae Adɨn, nɨnomor kouanɨn, wɨ Adi Komiiyɨn, kɨrɨe komiikakɨn, siir iikam whɨekakɨm, sɨmiir kɨgɨrkakana wɨ siir ɨɨna ɨɨniga saiir ɨɨnigmɨiya nɨdwowi. ");
INSERT INTO iws_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Mɨ sɨma boɨn, ana, kɨra Adi Komii siir yɨnisɨmkɨn? Ɨhɨ. Yɨo ɨna yowarkɨi boɨnɨn, wasi kɨmar bɨdi boɨnki ɨskiyɨn. Karargɨn. ");
INSERT INTO iws_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Mɨ sɨma ɨna boɨnɨm, krɨma yaeya yai kwɨram dimusi swokɨ hansrani? Krɨma whɨekakarɨn, yaiyɨm siya boɨnkiyɨm bɨdi wakaekiyɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Sɨma Jisɨs siir yai wakae dɨgiyɨm mɨ sɨma whɨekakar nhɨnki mɨ Jisɨs siirɨn ɨna yɨkɨunamɨn inkam komii Pailat Romanɨn siirɨm. ");
INSERT INTO iws_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Mɨ siirɨn hanɨɨngɨn boɨnɨuriyɨu bwakainam, inkam komii Pailat saɨka mɨ sɨma ɨna boɨnɨm, krɨma tɨ inkamɨn siir bɨdi kɨgɨm siya Isrel krɨmiir isidɨm sɨmiir siyɨu ɨmiir bɨdi haiprɨd haigɨnɨuwɨn. Mɨ krɨmiirɨn siya mɨ boɨnkɨn takis umɨrɨm inkam komiiyɨn om komii Romanɨn siir hauusiyɨn. Mɨ siya hɨnɨɨna mɨ boɨnkɨn mɨ Mesaia Kraisɨn karargɨn mɨ nu kɨgrɨraowan inkam komiiyɨn ɨriipɨ karargɨn. ");
INSERT INTO iws_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Mɨ Pailat siya Jisɨs siir srɨi, kɨra Juda iikamɨm sɨmiir nu kɨgrɨraowan inkam komiikɨn, aniya? Mɨ siya Pailat siir yai aiirɨn ɨna yowarkɨi boɨnɨn, kɨrar bɨdi boɨnki ɨskiyɨn. ");
INSERT INTO iws_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Mɨ Pailat siya ha haiyɨug kaowɨn pris sɨmiir bɨiyan kamɨm mɨ iikam ɨkɨm sɨmiir boɨnki, kara tɨ inkam ɨiirɨn dimɨn whɨr bɨ hɨdiyɨskaikɨn siya dimɨn whɨr bɨ tɨrbukɨn. ");
INSERT INTO iws_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mɨ sɨma ɨni komiiya kauwok boɨnkiyɨm mɨ siya ta yai aiirɨn siyar boɨnkɨn iikam whɨekakɨm nu Judianɨm sɨmiir boɨnmɨmauuwɨn mɨ sɨma ɨna yanaakiyɨm. Mɨ siya tɨ hɨriinan siyɨuɨn nu Galili hɨrankɨ dirɨraerar yokiyokɨiniyɨn mɨ tɨsi tɨrar namwoniyɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Mɨ Pailat siya hɨriinan yai aiir wakaekiyɨn mɨ siya sɨmiirɨn ɨna srɨigiyɨn mɨ tɨ inkamɨn siya nu Galili hɨran inkamkɨn, aniya? Mɨ sɨma ɨna boɨnɨm ɨhɨ siya nu Galiliyan inkamkɨn. ");
INSERT INTO iws_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Mɨ ɨiya sɨma hɨriinan boɨnɨm Jisɨsɨn nu haɨmiiyɨn Herot siya kɨgrɨraowiyɨn mɨ siir hɨrankɨn mɨ siya siirɨn Herot siirɨm asi nɨkropkikɨn. Mɨ ta ɨi aiirɨn Herot siya om komii Jerusalem hɨrar mɨ okɨn. ");
INSERT INTO iws_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Mɨ Herot siya Jisɨs siir kɨgɨn mɨ siya ɨni maɨrgɨmaɨrga ywowɨn. Siya siir yai ɨmiir wakaekɨn mɨ ɨi haruwa rani, siya naɨngwokwonanaeiyɨn Jisɨs siir kɨgamɨn. Mɨ siya mɨnam kaokɨn Jisɨs siya dimɨn kɨrɨe komii whɨr dirɨraerarɨm siir whwonkam ɨdan, bɨiya iikamkɨ kɨg karamae nwowɨm sɨmiir. ");
INSERT INTO iws_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Mɨ Herot siya Jisɨs siiramɨn yai kasa bɨ kɨnɨwamwarkɨi srɨinanaekɨn. Mɨ Jisɨs siya siir yaiisɨm kwɨr bɨ swokɨ wakae boɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Mɨ pris sɨmiir bɨiyan kamɨm mɨ kamɨm siyɨu komii nɨnoknɨnkɨni ɨkɨm sɨma Jisɨs siir kingiin hɨrar yamɨkwoni mɨ sɨma siirɨn ɨna boɨn hɨuriyɨu krɨpkaiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Mɨ saiir mhoɨiya Herot siya mɨ siir sauan kamɨm sɨma Jisɨs siir yɨkbumbu. Mɨ siirɨn siyɨu mɨiyɨk bɨ tɨrkɨm mɨ sɨma yɨuɨs wɨn kɨbiya kwɨra hai mɨ sɨma ta yɨuɨsa siir kaihaigɨnɨu mɨ sɨma siirɨn ɨna swokɨ ɨkropkiyɨn Pailat siirɨmar. ");
INSERT INTO iws_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Bɨiya Herot sowa Pailat ɨo sowa sowa nɨnwo anwowiko. Mɨ ta ɨi aiirarɨn sowa ɨo bɨ nwoko ɨna yɨmboɨno. Dimusi rani, Pailat siya Jisɨs siirɨn Herot siirɨm nɨkropkikɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Mɨ Pailat siya ɨna yɨkɨunan prismi yaowae adɨm mɨ kamɨm Isrel sɨmiir bɨi nwowi ɨkɨm mɨ iikam ɨma sɨmiirar yɨkɨuna. Mɨ sɨma maeyau kwɨruwar hangiriyɨu omɨmɨr. ");
INSERT INTO iws_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Mɨ siya sɨmiirɨn ɨna boɨnɨn, tɨ inkamɨn kariiramɨn kɨma nɨkɨunaniyɨn mɨ kɨma siirɨn hɨnɨɨna boɨn, siya iikam whɨekakɨm sɨmiir siyɨu ɨmiir bɨdi haiprɨd haigɨnɨuwɨn. Mɨ kara siirɨn kɨmiir whwonkam ɨda bɨdi srɨiyɨn. Mɨ kɨma wakae, tɨ digworaekwowɨm kɨma boɨn hɨuriyɨu natkaikiyam tɨrɨm siir, kara siirɨn sɨmiir bɨ hɨdiyɨskaikɨn. Siya dimɨn whɨr bɨ swokɨ tɨrbukɨn. ");
INSERT INTO iws_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herot siya ɨriipɨ hɨriinan. Mɨ siya ɨni krɨmiirɨmar swokɨ ɨkropkiyɨn. Wakae, tɨ inkamɨn siya dimɨn whɨr bɨ tɨrbukɨn mɨ krɨma siirɨn wa nɨsomao rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Mɨ kara pɨ kariir kam nhɨrɨm sɨmiir nɨkropki siirɨn ɨdgɨuni nɨpɨmparɨm mɨ kara siirɨn pa swokɨ ɨuguski. ");
INSERT INTO iws_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Mɨ sɨmiir siyɨuɨn hɨnɨɨnkɨn, sɨmiir yaiwou Pasova whɨekakɨm Pailat siya inkamɨn pɨ nwɨra nɨkrop apniki maeyauwa mɨi biyɨe mɨriiya hɨuyokiyokaiya saiir hɨrankɨn. ");
INSERT INTO iws_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Mɨ iikam whɨekakɨm, sɨma hɨnɨɨna kauwok boɨnki komiiyar tɨ inkamɨn Jisɨs, siirɨn dɨsomaoki mɨ Barabas siirɨn dɨuguski krɨmiiram. ");
INSERT INTO iws_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Bɨiya yaii kwɨra Barabas siya nɨniika om komii hɨr bɨiyan kamɨm omom omom kɨgrɨraowiyɨm sɨmarkar mɨ siya inkam nɨsomaokɨn mɨ sɨma siirɨn maeyauwa mɨi biyɨe mɨriiya hɨuyokiyokaiya saiir asi nɨkrop apnɨnopkaikikɨn.) ");
INSERT INTO iws_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Mɨ Pailat siya sɨmiirɨn yai ɨna swokɨ boɨnɨn. Siya Jisɨs siir nɨuguskiyam naɨngwokɨn. ");
INSERT INTO iws_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mɨ iikamɨm sɨma ɨni komiiya kauwok boɨnkiyɨm, siirɨn paeyɨn hɨiniya nɨrɨo nɨnkɨnɨn siir dɨrɨnugi! Siirɨn paeyɨn hɨiniya nɨrɨo nɨnkɨnɨn siir dɨrɨnugi! ");
INSERT INTO iws_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mɨ Pailat siya kwoɨmaka sɨmiirɨn ɨna swokɨ boɨnkiyɨn, dimusika? Tɨ inkamɨn siya dimu tɨrbukɨn? Kara siirɨn dimɨn whɨr bɨ hɨdiyɨskaikɨn mɨ krɨma siirɨn pɨ kariir kam nhɨrɨm sɨmiiram nɨkropki sɨma pɨ nɨpɨmparɨm mɨ siirɨn pa swokɨ ɨuguski. ");
INSERT INTO iws_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Mɨ sɨma ɨna kauwok boɨnanaeyɨm, siya Jisɨs siirɨn pae hɨiniya nɨrɨo nɨnkɨnɨn siir nɨrɨnuɨm. Mɨ tɨ yaiyɨm sɨma kauwok boɨnɨm Pailat siir yaiya aiirɨn ɨni sɨma ikwowaisigiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Mɨ Pailat siya ɨni sɨmiir yai aiirar wakaeyoknan. ");
INSERT INTO iws_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Mɨ iikamɨm sɨma tɨ inkamɨn yaii nɨniiyɨn bɨiyan kamɨm omom omom kɨgrɨraowiyɨm sɨmaka mɨ inkam nɨsomaowɨn siirɨm kauwok boɨn siir swokɨ ɨkrop apnikiyɨm sɨmiiramɨn mɨ Pailat siya siirɨn ɨna yɨuguskiyɨn. Mɨ siya sɨmiir yai aiirar wakaeyokna mɨ siya Jisɨs siirɨn ɨna hauugiyɨn sauan kamɨm sɨmiir ɨɨn mɨ sɨma siir wa nwokɨ ɨsomaowɨm. ");
INSERT INTO iws_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Mɨ om komii Rom hɨrɨn sauan kamɨm sɨma Jisɨs siirɨn ɨna yɨkɨunamɨm mɨ sɨma inkamɨn nwɨra yapyɨskai, Saimonɨn om komii Sairiniyanɨn siir. Mɨ siya om komiiya hɨriir napnɨnopkainamɨm nɨtkɨn mɨ sɨma siir yankabrɨnu mɨ tɨ paeya hɨiniya nɨrɨo nɨnkɨnɨn siir yɨkmwon ɨtiyɨskai mɨ siya ɨni Jisɨs siir mhoɨiya yɨtiyɨskai apamɨn. ");
INSERT INTO iws_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mɨ iikam kasa rani, siir mhoɨiya napnamɨm mɨ wig kasa rani, Jisɨs siiram nɨnou mwamwanamɨm. ");
INSERT INTO iws_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Mɨ Jisɨs siya ɨna haiyɨug boɨnkiyɨn, kɨma tɨ om komii Jerusaleman wigɨm, kɨma kariirɨm kɨpi nou. Kɨma kɨmasiyar douna mɨ kɨmiir yɨnisɨsɨm ɨmiirsi warar. ");
INSERT INTO iws_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Wakae, mhoɨiya ɨigwɨra nɨmbiyami mɨ iikamɨm sɨma wɨ hɨnɨɨna boɨni, wigɨm yɨnisɨm naokaina karamae nwowɨm, yɨnisɨm ɨmiirɨn nwoɨi haigiyɨu ɨmiiyae karamae nwowɨm, sɨma ha maɨrgɨmaɨrga. ");
INSERT INTO iws_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mɨ ta ɨiya sɨma wɨ ɨkɨ mhɨu komii mɨ mhɨuisɨsɨmɨm sɨmiir boɨnki, kɨma krɨmiir ɨdwo winɨ pamkirɨnuni! ");
INSERT INTO iws_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Mɨ om komii Rom hɨran iikamɨm sɨma siyɨu biyɨe kariir tɨri, kara inkamɨn dimɨn biyɨe tɨr karamae nwowɨn mɨ mhoɨiya sɨma tari sɨmiirɨn siyɨu biyɨe komii warar nɨnkɨn tɨri, kamɨm dimɨn biyɨekakɨm. Mɨ sɨma wa dɨgɨuguski. ");
INSERT INTO iws_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Mɨ kamɨm yaii nɨniiyɨm sɨma inkam nwɨswo sowiir warar yɨnkɨn ɨkɨunam, sowa siyɨu biyɨe dirɨraerarko. Mɨ sɨma sowiirɨn Jisɨs saɨka nɨnkɨn ɨsomaowam naɨngwokɨm. ");
INSERT INTO iws_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Mɨ sɨma maeyau kwɨra saiir yɨmbiyam, ta maeyauwa saiir inɨgɨn mwokɨuka. Mɨ ta maeyauwa sɨma Jisɨs siirɨn hɨr nɨrɨnugɨm paeyɨn hɨiniya nɨrɨo nɨnkɨnɨn siir. Mɨ sɨma tɨ inkam biyɨe nwɨswo sowiir warar yɨnkɨn ɨrɨnugi mɨ nwɨrɨn Jisɨs siir ɨɨniga mɨ nwɨrɨn yaɨoyaeya. ");
INSERT INTO iws_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jisɨs siya ɨna boɨnɨn, Adi Komii, kɨra sɨmiir dimɨn biyɨeyɨm sɨmiir haiyoprimdiyɨumiigi. Sɨma nɨnoknɨnkɨn tani tɨ dimɨnɨn sɨma tɨr ɨiirɨn. Mɨ sauan kamɨm sɨma satu ɨna gwowɨm siir yɨuɨs aiirɨm mɨ inkamɨn pɨ kaigrɨnɨuwi mɨ ta yɨuɨsa pɨ siya haii. ");
INSERT INTO iws_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mɨ iikamɨm sɨma ɨni hɨrar yokwowɨm mɨ ɨna kaowɨm. Mɨ bɨiyan kamɨm nu Judianɨm sɨma siirɨn hɨnɨɨna yɨgbumbu, siya iikam nhɨrɨm sɨmiirarar whɨndirɨraerarkɨn. Mɨ Krais kɨɨngɨ nɨuwi siirɨn Adi Komii siya nɨmbingi mɨ siya, sisiyar whɨn dirɨraerarna. ");
INSERT INTO iws_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Mɨ kamɨm sauanɨm yɨm ɨriipa hɨriinan kingiin ha mɨ ɨtɨm siir mɨ ɨgbumbu. Mɨ sɨma op waina kwoɨn kausrɨriya siir yaka hauu. ");
INSERT INTO iws_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Mɨ sɨma ɨna boɨnkiyɨm, kɨra Juda sɨmiir nu kɨgrɨraowan inkam komiikɨ nɨuwi mɨ pɨ kɨnakɨnar whɨndirɨraerarna. ");
INSERT INTO iws_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Mɨ siir mwo koua nwowa yaiya, hɨnɨɨna wɨnboɨnka. Tɨ inkamɨn Juda sɨmiir nu kɨgrɨraowan inkam komiikɨn. ");
INSERT INTO iws_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mɨ tɨ inkam biyɨe nwɨswo Jisɨs saɨka nɨnkɨn ɨrɨmdɨnuwo mɨ nwɨrɨn Jisɨs siir yɨgbumbu. Kɨra Mesaia Kraiskɨn, aniya? Mɨ kɨra kɨnakɨnar dirɨraerarna mɨ pɨ krɨriir warar mɨ whɨndirɨraerar. ");
INSERT INTO iws_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mɨ nwɨrɨn siya ta hɨriinan yai aiir wakaekiyɨn mɨ ɨo siir yo mɨ krɨra ta siir hɨriinan hɨk aiir haii mɨ kɨra Adi Komii siirsi nɨdid rani, ha? ");
INSERT INTO iws_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Sɨma krɨriir nɨsomaowi siyɨu biyɨe krɨra tɨrɨn siirsi, sɨma siyɨu mɨiyɨk ɨiirar mɨ tɨri. Mɨ tɨ inkamɨn siya dimɨn whɨr bɨ tɨrbugɨn, siya wɨ whɨsariiyar naowi. ");
INSERT INTO iws_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Mɨ siya ɨna boɨnɨn, Jisɨs mhoɨiya kɨra kɨriir nu kɨgrɨraowan inkam komii nɨmbiyami mɨ kɨra kariirɨn wɨ timɨ naɨngwo. ");
INSERT INTO iws_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Mɨ Jisɨs siya siirɨn ɨna boɨnɨn, kara kɨriirɨn yaimwowa boɨni, kɨra panaoɨn pɨ kanakar nwowi nɨnomor kou hɨr. Om mɨiyɨkɨn iikam mɨiyɨkɨm omwai sɨm waiya yokiyokɨiyɨn siir. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Mɨ ɨiya hɨriir tɨriir nabɨe bopwo nwowa. Mɨ hɨnda tɨnda ɨiya ɨna kakauu ɨuguskiya mɨ tɨ nu whɨrkakɨn ɨni nɨiya ywokiyɨn. Mɨ bɨeyɨn nad nworɨbɨn ɨi kwoɨm hɨnɨɨn mɨ ɨiya ɨna swokɨ pɨrkɨnkirɨba. ");
INSERT INTO iws_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Mɨ ɨiya nɨiya nikɨ owa ta yɨuɨs komiiya omaka komiiya Adi Komii siira maeyauwa hɨuyokiyokikaiya dimɨn whɨrkɨ kɨmbu karame nwowa siir nɨtomanouwa ɨni bopwoniya yɨnwhɨtamkiya mɨ mɨrkwɨsa yɨmbiyam. Mɨ tɨ siyɨuɨn Adi Komii siya krɨmiir nɨisiimauugikɨn. Mɨ krɨma nhwo siirɨm kwɨsboɨni siyɨugak bɨdi yamwowɨuɨn. ");
INSERT INTO iws_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Mɨ dimɨn taemɨnɨm nɨmbiyam dɨgiyɨm. Mɨ Jisɨs siya ɨni komiiya kauwok boɨnkiyɨn, Adi Komii, krɨmiir Wanɨn kariir inɨgɨn yokiyokɨiiyɨn pɨ kɨriir ɨɨn hauugigi. Siya hɨriinan boɨnkiyɨn mɨ siya ɨna yaonamɨn. ");
INSERT INTO iws_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mɨ sauan kamɨm sɨmiir bɨiyan inkamɨn siya tɨ dimɨn ɨiir kɨgiyɨn mɨ siya ɨni Adi Komii siir inɨg ɨiirar hainankiyɨn, siya ɨna boɨnɨn, ɨhɨ, kaimwokɨ kaimwokɨɨnga, tɨ inkamɨn siya inkam mɨiyɨkɨ mɨiyɨkɨn. ");
INSERT INTO iws_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Mɨ iikam whɨekakɨm sɨma siir kaowam nɨtɨm mɨ sɨma tɨ digworaekwowɨm nɨmbiyamɨm sɨmiir kɨgiyɨm mɨ sɨma ɨni sɨmiir ɨɨngas ɨmiirar pikrɨmgrɨbgiyɨm mɨ ɨna swokɨ amɨm sɨmiir omaka. ");
INSERT INTO iws_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Mɨ Jisɨs siir nomiiyau whɨekakɨm, siir sɨbgu nɨnoknɨnkɨnɨm mɨ wigɨm nu Galiliyanɨm bɨiya Jisɨs siirɨm nɨtɨm, sɨma arurɨga ywokwo mɨ sɨma ɨna kɨgmɨmɨkɨm tɨ digworaekwowɨm nɨmbiyamɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Mɨ inkam nwɨrɨn hɨrar nwokɨn, siir inɨgɨn Josepkɨn. Siya wadɨekɨ wadɨekɨn, siya Juda kaunsel inkamkɨn. ");
INSERT INTO iws_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Mɨ ɨkɨ kaunsel kam nhɨrɨm omisɨm kɨgrɨraowiyɨm sɨmiir kwoɨn aka bɨ nwokɨn, tɨ dimɨnɨm sɨma Jisɨs siir tɨram mɨnɨm. Siya om Arimatia nu Judia hɨran inkamkɨn. Yɨo siya ɨiya Adi Komii siir digworaekwo whɨekakɨm sɨmiir kɨgɨrkakana saiiram nwowikɨn. ");
INSERT INTO iws_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Mɨ tɨ inkamɨn siya ɨna yamɨn inkam komii Pailat siir omaka mɨ ɨna srɨiyɨn, siya Jisɨs siir pɨuɨs nhɨnga saiir hainamɨn mɨ siya ɨni wadɨeya ywokiyɨn. ");
INSERT INTO iws_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Mɨ Jisɨs siir pɨuɨs biyɨeya siya saiir hɨunɨs haiyɨn, pae hɨiniya nɨrɨonɨnkɨnɨn siir hɨrankɨn. Mɨ yɨuɨs whɨsiinana saiir higrɨnɨu mɨ siya siir pɨuɨs biyɨe aiirɨn siyano whɨrɨn siir kikaigik. Mɨ tɨ ɨeyɨn sɨma siiya komiiya saiir nopkikaikɨn. Mɨ bɨiya sɨma tɨ ɨe ɨiirɨn inkam nwɨr bɨ kikai mɨmɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Taka ɨiya Fraideka sɨma Juda sɨmiir ɨi komiiya Sabat pɨu siisiya dimɨn taemɨn tɨr karamae nwowiya saiir nae digworaekwo ɨmiir dirɨraerar haigɨnkɨm saeya wɨ sapi nɨmbiyami. ");
INSERT INTO iws_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Mɨ wigɨm nu Galili hɨrankɨ nɨtɨm Jisɨs saɨka mɨ sɨma Josep siir mhoɨiyar yam. Mɨ sɨma tɨ ɨe ɨiir warar kɨgmɨmɨk. Mɨ sɨma Josep siir warar nɨnkɨn kaokɨm siya Jisɨs siir pɨuɨs biyɨeya wɨ panɨɨna namisi dirɨraerar haigi. ");
INSERT INTO iws_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Mɨ sɨma ha kɨg dɨgikɨm mɨ sɨma ɨna swokɨ amɨm sɨmiir yapa yapa omaka. Mɨ sɨma wa mɨnɨm mɨ digworaekwo mɨiyɨk mɨiyɨkɨm pɨui mɨiyɨk whakiyɨm ɨna dirɨraerar haigɨnɨm. Jisɨs siir pɨuɨs biyɨeya saiir naokɨnɨm, pɨ whɨiisi mɨ sɨmiir ɨi komiiya Sabat nɨkɨuwiya sɨma pɨu siiskuwak, siyɨu komii siya boɨna mɨ saiir hɨriinan. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Mɨ wik kwɨra saiir bɨiyan ɨiya Sande sɨma nugak ɨmumar yamyakwok sɨma maeyauwa Jisɨs siir haɨngikaiya saiir hɨriir yam. Sɨma waɨn pɨuii mɨiyɨk whakiyɨn siir hainam, bɨiya sɨma nikɨ dirɨraerar haigɨnɨn mɨ sɨma ɨna hainamɨm. Mɨ sɨma Jisɨs siir pɨu aiir naokɨnɨm tɨrkɨm. ");
INSERT INTO iws_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Sɨma ta siiya aiir kɨg, sɨma nikɨ warkɨkɨua, saiirɨn sɨma bɨdi warakpɨtkikiya. ");
INSERT INTO iws_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Mɨ sɨma ha napnɨnopkai namɨm mɨ sɨma nɨnomor kouan, Bɨiyan Inkam Komiiyɨn Jisɨs siir pɨuɨs biyɨe aiir bɨ kɨgɨm. ");
INSERT INTO iws_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Sɨma ɨna yangwoyɨmiyokɨm mɨ sɨma inkam nwɨso sowiir kɨg sɨmiir kingiin hɨrar nokwowi sowiir yɨuɨso hindara kɨgnɨniyaei. ");
INSERT INTO iws_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Mɨ tɨ wigɨm sɨma sɨma nɨdid prasae bɨ kikɨnkɨm. Mɨ sɨma ogmwo nɨimwowɨm nua hɨriir kaiyɨrou nam mɨ sɨmiir whwonkamɨm ɨni nua hɨriir kaowɨm. Mɨ tɨ inkam nwɨso sɨmiir boɨn, kɨma inkamɨn omwai waiyokiyokɨiyɨn siiram dimusi hansɨri ta maeyauwa inkam haɨngikaiiya, inkam wɨɨrniya saiir, ha? ");
INSERT INTO iws_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Siya tapair nwo rani. Bɨdi yɨnsiin ɨdwo namɨn! Kɨma yaiya bɨiya siya kɨmiir boɨnmauuwa saiir tɨ swokɨ aɨngwowarkaigi, ɨi siya nu Galili hɨrar nikɨ owɨn. ");
INSERT INTO iws_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Siya kɨmiirɨn hɨnɨɨna boɨnmɨmauugɨn, sɨma Yaowae Adɨn nɨnomor kouanɨn kariirɨn wɨ iikamɨm dimɨn biyɨekakɨm sɨmiir hauuwi mɨ siirɨn wɨ paeyɨn hɨiniya nɨrɨonɨnkɨn saɨka sɨma nɨnkɨn ɨrɨmdɨnu inankɨi. Mɨ ɨi kwoɨmaka kara wa swokɨ ɨnsiin ɨdwowi! ");
INSERT INTO iws_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Sowa hɨriinan boɨno mɨ tɨ wigɨm sɨma ɨna yaɨngwowarkaigiyɨm ta yaiya bɨiya Jisɨs siya boɨna saiir ");
INSERT INTO iws_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","mɨ sɨma ta maeyauwa inkam haɨngikaiya saiir haiburgik mɨ ɨna swokɨ amɨn. Mɨ sɨma kam ɨuur nwɨrɨm siir mɨi kɨgna mɨriiyɨm sɨmiir inɨ boɨnmauuɨu mɨ kam nhɨrɨm sɨmiir warar, tɨ digworaekwo whɨekakɨm sɨma kɨgɨm sɨmiir. ");
INSERT INTO iws_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mɨ Maria om Makdalanaka mɨ Joana mɨ Maria Jemsni yopii aka, sɨmar nwokɨm mɨ wig nhɨrɨm sɨmakar nɨnkɨn okɨm sɨma tɨ yaiyɨm aposel kamɨm sɨmiir boɨnmɨmauuɨu. ");
INSERT INTO iws_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mɨ tɨ aposel kamɨm sɨmiir kwoɨnɨm ha naɨngwokɨm tɨ wigɨm sɨma nɨksɨsaei mɨ sɨmiir yai aiir bɨ naɨngwo tɨbmiigɨm. ");
INSERT INTO iws_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mɨ Pita siya ha nɨnsiinɨn mɨ maeyauwa inkam haɨngikaiya saiir hɨriir iwɨtnam mɨ siya tɨ ɨe ɨiir inɨ waisi kaowɨu mɨ yɨuɨs ɨmiirara kɨg sɨma sɨma nwokai. Mɨ siya omaka hɨriir swokɨ am mɨ ɨni tɨ dimɨn ɨiir inɨ aɨngwoyɨmiyokɨuɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mɨ ta ɨi aiirarɨn inkam nwɨso sɨmiiraɨrgo, sowa omisɨm whɨrɨn sɨma dapiyɨn Emeasa siir hɨriir napnamko. Tɨ omɨn siya om komii Jerusalem siir aru ywowɨn. Mɨ ɨni omisɨm Emeas hɨrar yamwowɨuɨn, siir prɨeiyɨn kilomita ɨuur kwɨrkɨm. ");
INSERT INTO iws_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Sowa ha napnamo mɨ sowa digworaekwo whɨekakɨm tɨ ɨi ɨmiir nɨmbiyamɨm sɨmiir yapboɨnaiyam. ");
INSERT INTO iws_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mɨ sowa ha napboɨnaiyamo mɨ ɨni sowa sowa yɨnsrɨi ansrɨiyamo mɨ Jisɨs siya ɨna yɨmbiyamɨn sowiir kingiin hɨrɨn mɨ ɨni sowaka yapamɨn. ");
INSERT INTO iws_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Mɨ sowiir nhwowo dimɨn whɨrkɨ bɨ kimɨrkaigo mɨ sowa ha bɨ nɨnoknɨnkɨnko, siya Jisɨskɨn. ");
INSERT INTO iws_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Mɨ Jisɨs siya sowiir boɨn, kowa dimu nouapboɨnaiyami, ha? Siya hɨriinan boɨnɨn mɨ sowa ha nokwowo mɨ sowiir mhɨi kwoɨnɨno ɨni hɨkakar ywowo mɨ sowiir whwonkamo mɨiyɨk bɨ nwoko. ");
INSERT INTO iws_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mɨ inkam nwɨrɨn, siir inɨgɨn Kliopaskɨn siya siir yai aka hɨnɨɨan yowarkɨi boɨn mɨ iikamɨm omom omomiyɨm Jerusalem hɨrarar bɨdi yamwomɨmɨrɨuɨm. Mɨ tari kɨnakɨnaɨrgɨn tɨ dimɨnɨn Jerusalem hɨr nɨmbiyamɨn siir nɨnoknɨnkɨn karamae nwowɨn, aniya? ");
INSERT INTO iws_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Siya hɨriinan boɨnkiyɨn mɨ Jisɨs siya sowiir srɨi, dimukɨn, ha? Mɨ sowa siirɨn hɨnɨɨna boɨn, tɨ dimɨnɨn Jisɨsɨn om Nasaretanɨn siir nɨmbiyamkɨn. Siya profet inkamkɨn mɨ siya mɨi mɨiyɨk mɨiyɨk komii komiiyɨm mɨ yai mɨiyɨk mɨiyɨk komii komii ɨkɨm Adi Komii siir whwonkam ɨda mɨ iikamɨm sɨmiir whwonkam ɨda mɨriikɨn. ");
INSERT INTO iws_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mɨ prismi bɨi nwowi kamɨm mɨ kaunselmi bɨiyan kam ɨkɨm, sɨma hauugɨm Jisɨs siirɨn sauan kamɨm sɨmiir ɨɨn, sɨma nɨsomaowɨm, paeyɨn hɨiniya nɨrɨonɨnkɨnɨn siir nɨnkɨn ɨrɨnuwɨm. ");
INSERT INTO iws_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Krɨra bɨiya hɨnɨɨna naɨngwo tɨbmiigo, tɨ inkamɨn siya Isrelmi iikamɨm sɨmiir whɨnkɨnsiis haigɨnɨuwiyɨn. Ɨhɨ, mɨ yai kwɨra hɨnɨɨnga. Tɨ digworaekwo ɨma nɨmbiyama, ɨi kwoɨmɨm bɨdi yamkiyɨm digworaekwo whɨekak nhɨrɨm sɨmaka nɨmbiyamkɨn. ");
INSERT INTO iws_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Mɨ tapa wig nhɨrɨm krɨmiir isid ɨiirɨn sɨma ninɨ boɨnananikɨm krɨmiirɨn. Sɨma nugak ɨmumar namiyakwokɨm maeyauwa inkam haɨngikaiya saiir. ");
INSERT INTO iws_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Mɨ sɨma Jisɨs siir pɨuɨs biyɨe aiir bɨ kɨgɨm. Nɨɨngaka. Mɨ sɨma ɨna swokɨ haiyɨug apnamɨm mɨ sɨma hɨnɨɨna inɨ boɨnɨu, krɨma paekwosɨm nwɨso sowiirɨn nhwonan whɨn kɨgnanikɨm sɨma hɨnɨɨna boɨnkikɨm, Jisɨs siya ɨni omwaiyar swokɨ waiyaɨn. ");
INSERT INTO iws_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Sɨma ha boɨn dɨgiyɨm mɨ krɨmiir kam nhɨrɨm sɨma ha namɨm maeyauwa inkam haɨnkikaiiya saiir mɨ sɨma digworaekwowɨm wig ɨma boɨnɨm sɨmiir hɨriinanar swokɨ kɨgɨu. Mɨ yɨm sɨma Jisɨs siir bɨ kɨgɨm. ");
INSERT INTO iws_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Mɨ Jisɨs siya ɨo sowiir ywoki, kowa kwoɨn karamaeko! Kowiir mhɨi kwoɨnɨm ɨni hiinsɨma ywowaowɨm profetkɨm boɨniyɨm yai whɨekakɨm sɨmiiram naɨngwo tɨbmiiyɨm. ");
INSERT INTO iws_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Pɨ panɨɨna tɨri, ha? Mɨ kowa tari bɨ nɨnoknɨnkɨnko, Mesaia Kraisɨn Adi Komii siya nɨmbinɨn siya wɨ hɨk kɨmpɨpɨsu prasae hai rani, bɨiyɨn mɨ siya mhoɨiya wɨ Adi Komii siir hɨrankɨ haii inɨg komiiyɨn, aniya? ");
INSERT INTO iws_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Mɨ Jisɨs siya Moses siir yaiyɨm sɨmiirar kwaboɨnbwakainam mɨ profet whɨekakɨm sɨmiir ɨma mɨ siya sowiir boɨnmɨmauu. Mɨ siya Yokwo komii saeya boɨnɨm yaiyɨm siir, sɨmiir boɨnmɨmauu. ");
INSERT INTO iws_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Mɨ sɨma tɨ omɨn sowa namɨm tɨrɨn siir kingiin hɨr yɨmbiyam. Mɨ Jisɨs siya hɨriinan tɨrɨn mɨ siya ɨna yapsasaeyamɨn. ");
INSERT INTO iws_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Mɨ sowa siir yɨkɨdu mɨ ɨna boɨno, kɨra krɨraka tɨrar dwo. Bɨeyɨn bɨdi yɨkiyamkiyɨn mɨ ɨiya pɨ sapi kakauui. Mɨ siya ɨna yapnɨnopkainamɨn mɨ ɨni sowakar ywowɨn. ");
INSERT INTO iws_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Mhoɨiya sɨma naeyɨm tɨrɨm mɨ Jisɨs siya sowakar yɨdwo. Mɨ siya bretɨn ha haiyɨn mɨ ɨna boɨn wadɨekiyɨn Adi Komii siir mɨ haɨmiihaɨmiiyo sowiir yɨnop hauu. ");
INSERT INTO iws_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Siya hɨriinan tɨrɨn mɨ sowiir nhwowo ɨni bɨimi siya kɨnkiyo mɨ sowa siirɨn ɨna yɨnoknɨnkɨnkiyo. Mɨ siya hɨr bɨ swokɨ omɨmɨnkɨn ɨna kwakɨgugugiyɨn, sowa siir bɨ swokɨ kɨgmɨmɨnkiko. ");
INSERT INTO iws_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Mɨ sowa boɨn, krɨra siyɨu hɨrar nikɨ apniyo mɨ krɨriirɨn yaiyɨm siyar nikɨ apboɨnmamauunikɨn mɨ Yokwo Komii saiir yaimwowɨm sɨmiirar boɨnmɨmauugɨn, krɨriirɨn. Kaimwoka ta ɨi aiirarɨn krɨriir mhɨi kwoɨnɨm maɨrgɨmaɨrga bɨdiyar ywowo! ");
INSERT INTO iws_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Sowa hɨriinan boɨnaiyo mɨ bɨ kɨmɨmɨnkiko, sowa ta ɨi aiirar swokɨ ɨnsiin haiyɨug apnamo om komii Jerusalem hɨriirɨn. Mɨ sowa tɨ Jisɨs siir kam ɨuur nwɨrɨm sɨmiir inɨ kɨgɨu mɨ nomiiyau nhɨr ɨkɨm, sɨma maeyau kwɨruwa haɨngiriyɨu owi. ");
INSERT INTO iws_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Mɨ sɨma sowiir boɨn, kaimwokɨ kaimwokɨɨnga, Yaowae Adɨn nɨnomor kouanɨn bɨdi swokɨ ɨnsiin ɨdwowɨn. Saimon siya bɨdi kɨgɨn siirɨn. ");
INSERT INTO iws_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Mɨ sowa ɨna mɨ boɨno, digworaekwo whɨekakɨm sowiir nɨmbiyamo siyɨu hɨr. Mɨ sowa boɨn, siya bret ɨiir nɨnopkɨn mɨ krɨra siirɨn ha kɨgnɨnoknɨnkɨnkikɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Sɨma ta yai aiirar nikɨ ɨdwokai boɨnaiyɨm mɨ Jisɨs siya bɨri kɨmɨmɨnkikɨn sɨmiir bopwoniya hɨrar yamɨkwoɨu. Mɨ siya sɨmiir boɨnki, naɨngwobumbua kɨmakar dwo. ");
INSERT INTO iws_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Mɨ sɨma ɨni hindara yanaakiyɨm mɨ ɨni nɨdidkakar ywonamɨm. Sɨmiir kwoɨnɨm ha naɨngwokɨm sɨma aknaɨn kwɨr kɨgi. ");
INSERT INTO iws_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Mɨ siya sɨmiir boɨn, kɨma dimusi nanaai, ha? Mɨ kɨmiir kwoɨnɨm hɨnɨɨna dimusi sɨbnaɨngwoyokiyokɨiyami, ha? ");
INSERT INTO iws_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kariir ɨga ɨɨna owiir kɨgi. Karaɨrgɨn tɨ nokwowɨn, kɨmiir ɨɨnɨm kariir donkwo mɨpa kɨg. Aknaɨna saeya kɨpkak kɨugak rani, ta kɨma kɨga kariirɨn saiir hɨriinan. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Siya hɨriinan boɨnɨn mɨ siya siir ɨga ɨɨnwo sɨmiir yɨisiimauu. ");
INSERT INTO iws_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Mɨ sɨma ɨni maɨrgɨmaɨrga ywowɨm mɨ sɨma bɨ nikɨ aɨngwo tɨbmiigɨm. Mɨ sɨma ɨna yɨnaɨngwoyɨmiyokɨm. Mɨ siya sɨmiir srɨigi mɨ kɨma tari nae nhɨrkakɨm tapaiirɨn, nwo rani, aniya? ");
INSERT INTO iws_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Mɨ sɨma anasu haɨmiiyɨn sɨma nanagɨn siir hauu. ");
INSERT INTO iws_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Mɨ siya ha haiyɨn mɨ ɨni sɨmar kɨgwo aeiyɨn siirɨn. ");
INSERT INTO iws_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Mɨ siya ha nae dɨgiyɨn mɨ siya sɨmiir boɨn, bɨiya kara kɨmaka nikɨ owɨn, kara kɨmiir bɨdi boɨnmauuwɨn. Digworaekwo whɨekakɨm bɨiya kariir wɨnboɨnɨm, Mosesni siyɨu komiiyɨn yokwoni sɨma wɨnɨn mɨ profetmi yokwo aka mɨ yokwo Sam sɨma tɨ digworaekwo whɨekakɨm sɨma wɨ hɨriiyar nɨmbiyam dɨgi. ");
INSERT INTO iws_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Mɨ Adi Komii siir yai ɨmiirɨn siyar nanaaknɨnkii haigɨnɨugikɨn iikam ɨmiirɨn ta omaka aiir nwowɨm. ");
INSERT INTO iws_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Mɨ siya sɨmiir boɨn, Yokwo Komii saeya hɨnɨɨna boɨnka, Mesaia Kraisɨn wɨ hɨk sɨpi hai mɨ ɨi kwoɨmaka wa swokɨ ɨnsiin ɨdwowi ɨe hɨrankɨn. ");
INSERT INTO iws_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Mɨ iikam mɨiyɨkɨm sɨma siir inɨgɨn wɨ iikam isid whɨe komiiyɨm tɨ nu ɨirɨn wɨ sɨmiir boɨnmɨmauuwi mɨ sɨmiir dimɨn biyɨeyɨm wɨ Adi Komii siya nwokɨ haiyoprimdiyɨumiigiyɨm. Kɨma ta mɨi aiirɨn om komii Jerusalem tɨrar mɨrii bwakainam ");
INSERT INTO iws_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","mɨ tɨ digworaekwo ɨmiir boɨnmauuwam. ");
INSERT INTO iws_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ɨni wakaeyɨm, tɨ dimɨnɨn bɨiya Adi Komii siya boɨnɨn kɨmiir hauuwɨm, yɨo tariinanɨn kara kɨmiirɨm nɨkropkiyɨm tɨri. Kɨma tɨ om komii siirar dwo mɨ ɨiya nɨnomor kouan kɨrɨeya saeya nɨti kɨmiirɨm wɨ saiirar dadɨgɨu. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Mɨ Jisɨs siya ha boɨn dɨgiyɨn mɨ siya sɨmiirɨn ɨna yɨkɨunamɨm mɨ om Betani hɨrar yadɨgɨu. Mɨ siir ɨɨna ha ninansiinakiya mɨ nhwo ɨna kwɨsboɨnkiyɨn mɨ siya iikam ɨmiir yɨkboɨnmamaɨrɨn. Adi Komii siya sɨmaka nwowam. ");
INSERT INTO iws_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Siya nhwo sɨmiirar nikɨ kwɨsboɨnmamaɨrɨn mɨ siya sɨmiirɨn ɨni hɨrar iyopnɨsugikɨn mɨ Adi Komii siya siirɨn ɨni hɨrankar yɨkɨunakiyɨn mɨ nɨnomor kou hɨriir yam. ");
INSERT INTO iws_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Mɨ sɨma siir inɨg ɨiir hainan mɨ ɨni om komii Jerusalem hɨriir swokɨ amɨm mɨ sɨma ɨni maɨrgɨmaɨrga komiigakar ywonamɨm. ");
INSERT INTO iws_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Mɨ ɨinokɨinokɨn sɨma Adi Komii krɨmiir Wanɨn siir omaka saiirama nami, siir inɨg ɨiir hainanɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Bɨdi bɨdiniyarɨn ɨiya Adi Komii krɨmiir Wanɨn siya nu ɨiir nonkwokwowɨn mɨ yɨo tɨ inkam nwɨrɨn yɨpɨkɨ yai mɨiyɨk mɨiyɨk krɨmiir boɨnmɨmauuwanɨn yɨo ha nwokɨn. Mɨ yaiya siyaɨrgɨn. Siya Adi Komii saɨka nwokɨn mɨ sowa nwɨsaɨrarɨn nwɨruwar nwowɨskiko mɨ siya ɨni siir hɨriinanar swokɨ owɨn. ");
INSERT INTO iws_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Mɨ bɨdi bɨdiniyarɨn ɨiya dimɨn whɨrkɨ nikɨ ɨmbiyam karamaeyar nikɨ owa mɨ yɨo siya Adi Komii saɨka hɨrɨn saiirar nwokɨn. ");
INSERT INTO iws_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tɨ inkamɨn siyaɨrgɨn digworaekwo whɨekakɨm sɨmiir bwamkɨ bwamɨn. Mɨ Adi Komii siya digworaekwo whɨekakɨm sɨmiirɨn hɨriinan saiirsi nonkwokwokɨn. Dimɨn whɨrkɨ saɨsar bɨ nɨmbiyamkɨn. Nɨɨngakɨ, nɨɨngakɨɨnga. ");
INSERT INTO iws_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tɨkɨ inkamɨn siyaɨrgɨn digworaekwo whɨekakɨm omwai waiyaiyɨm sɨmiir bwamkɨ bwamɨn. Mɨ tɨ omwai waiyaiyɨm yɨm iikam krɨmiir pae nɨuyanan ywowɨm ya iikam ɨmiir whɨnkɨnsiis haigɨnɨuwika, sɨma Adi komii siir nɨnoknɨnkɨnɨm mɨ omwai nwokɨ waiyam. Ya ɨni paeya siyɨu kɨgɨmok apiya ɨni hɨriinan yɨuyakiya. ");
INSERT INTO iws_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mɨ tɨ inkamɨn mɨ siir yai aeya hɨnda tɨnda pɨ paenan sowar nɨuyakii. Mɨ tɨ dimɨn biyɨeyɨm nɨibwomambwonan iikam krɨmiir mhɨi kwoɨnau nwokaiyɨm, tɨ dimɨnɨn paenan nɨuyaiyɨn siir nɨɨmuɨm wɨ dɨg nwo rani. Nɨɨngakɨ, nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Inkam nwɨrɨn Adi Komii siya nɨkropkiyɨn dimɨn taemɨnɨm iikam krɨmiir boɨnmɨmauuwam, siir inɨgɨn Jonkɨn. Siya Adi Komii siir yaiyan inkamkɨn ");
INSERT INTO iws_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Siya mɨnam nɨtkɨn, tɨ inkamɨn siir yai aiir boɨnmɨmauuniyɨm iikam ɨmiir yɨpɨkɨ paenan nɨuyaeiyɨn mɨ sɨma Jon siir yai aiir wakaei mɨ sɨma tɨ inkam ɨiiramɨn wa nwokɨ aɨngwo tɨbmii kɨɨnɨm. ");
INSERT INTO iws_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Mɨ yɨo siyarɨn, tɨ inkamɨn paenan nɨuyaeiyɨn si rani. Nɨɨngaka. Yɨo siya tɨ inkam komiiyɨn dimɨn whɨrkɨ kɨmbu karam nwowɨn, yɨpɨkɨ paenan nɨuyaeiyɨn siir yai aiir boɨnmɨmauuwam nɨtkɨn, iikam whɨekak ɨmiir. ");
INSERT INTO iws_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mɨ tɨ inkamɨn paenan nɨuyaeiyɨn siya nu tɨriir bɨdi yɨtɨn iikam ɨmiir whɨnkɨnsiis haigɨnɨuwam mɨ ta hɨriinana saiirsika yɨpɨkɨm tɨ tɨr nwowɨm sɨma wɨ nwokɨ ɨnoknɨnkɨnɨm Adi Komii siirɨn. ");
INSERT INTO iws_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Mɨ bɨdi bɨdiniyarɨn, Adi Komii siya nu tɨran digworaekwo whɨekakɨm siirsiyar nonkwokwokikɨn. Mɨ siya tɨ nu ɨiir nɨtɨn mɨ iikam whɨekakɨm sɨma tɨ inkam ɨiirɨn ha bɨ naɨngwokɨm, digworaekwo whɨekakɨm siyar nonkwokwokikɨm. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Mɨ siya tɨ nuɨn siyar nonkwokwowɨn siir nɨtɨn mɨ siirgɨsiirar iikamɨm Isrel hɨranɨm, sɨma saɨka bɨ nomboɨnkɨm. ");
INSERT INTO iws_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mɨ iikamɨm yɨpɨkɨ siir yai aiir wakaeyɨm mɨ ha naɨngwo tɨbmii kɨɨnɨm, siya sɨmiirɨn ha boɨni, ɨni ywowɨm sɨma Adi Komii siir yɨnisɨsɨm mɨ owi. ");
INSERT INTO iws_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Sɨma Adi Komii siir yɨnisɨm yopii adɨm sɨmiir naokainakiyɨm sɨmiirsi bɨ nwokɨm. Nɨɨngaka. Sɨma Adi Komii siir yɨnisɨm mɨnkɨ nwokɨm, siir kwoɨnkar tɨrkikɨn mɨ sɨma siir yɨnisɨsɨm asi nwokɨm. ");
INSERT INTO iws_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Mɨ tɨ inkamɨn nua tɨriir nɨtɨn, siya ɨni inkam krɨmiir hɨriinanar yaunɨ oniyɨn. Mɨ krɨma siir dimɨn kɨrɨe kɨrɨeyɨm paenan nɨuyaeiyɨm sɨmiir bɨdi kɨgɨm, siya inkam bɨmbɨuwigɨ bɨmbɨuwi rani. Siya ɨni Adi Komii siir hɨriinanar swokɨ owɨn mɨ siya iikam ɨmiir bɨ kɨmbuwikɨn. Mɨ siya bɨ swokɨ ɨksɨsaemɨmɨnikɨn. Nɨɨngakɨ, nɨɨngaka. Yaimwo boɨnan inkamkɨn. Siya yai iyopan inkam tani. Siya tɨ hɨriinan siyɨu kɨbikɨbiyɨm sɨmiir asi tɨrkɨn. Dimusi rani, Adi Komii siir yɨnisɨm nwɨrkɨ nwɨruwan, ɨiya siir naokaina, siirɨn hɨriinanar naokainakikɨn. ");
INSERT INTO iws_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon siya sɨmiirɨn tɨ inkamɨn siir boɨnmauu wakaekɨn. Siya hɨnɨɨna boɨnkɨn, tɨ inkamɨn bɨi kara boɨnɨn kɨmiir, yɨo siyaɨrgɨn. Mɨ tɨ inkamɨn kariir mhoɨiya nɨtɨn, kariir kouwɨn ɨni siya ywowɨn. Dimusi rani, bɨdi bɨdiniyarɨn siya ha nwokɨn. Kariir bɨ nikɨ aokainakɨn. ");
INSERT INTO iws_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Mɨ iikam krɨma Adi Komii siir dimɨn mɨiyɨk mɨiyɨkɨm sɨmiir asi haigɨm. Dimusi rani, tɨ inkamɨn, Adi Komii siir dimɨn mɨiyɨk mɨiyɨkɨm ɨni siya nonkwowɨn. Mɨ siya tɨ dimɨn mɨiyɨk mɨiyɨkɨm krɨmiirɨn wɨ hɨriiyar hauunanaei. ");
INSERT INTO iws_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Adi Komii krɨmiir Wanɨn siya siyɨu komiiyɨm Mosesni hauugikɨn mɨ yɨo siya kɨmɨdiniya krɨmiir swokɨ kwahauu, krɨma wakaeyokna apam. Mɨ krɨmiirɨn Jisɨs Krais sasar hauu ɨskii naɨngwobumbu komiiya mɨ siyɨuɨn, siyɨu mɨiyɨkɨ mɨiyɨk sɨbgu tɨri ɨkɨn. Mɨ siya krɨmiirɨn siir yai mɨiyɨka saiir warar mɨ ɨnkɨn hauugi. ");
INSERT INTO iws_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Inkam nwɨrmɨn nwɨrmɨnkɨn Adi Komii siir bɨ swokɨ kɨgmɨmɨnkɨn. Nɨɨngakɨ, nɨɨngaka. Inkamɨn nwɨrkɨ nwɨruwaɨrgɨn, saɨka kingiin nwowɨn. Yɨo Adi Komii siir yɨnisɨm ɨeyarɨgɨn mɨ krɨmiirɨn siyar nanaaknɨnkii haigɨnɨugɨn Adi Komii siirɨn hɨnɨɨn, siya panɨɨngɨn? Mɨ krɨma siirɨn wa nwokɨ ɨnoknɨnkɨnɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Isrel sɨmiir bɨiyan kamɨm, pris ɨmiirɨn mɨ Livaimi pɨugana saiir kam ɨkɨm, yɨpɨkɨ pris ɨmiir whɨndiraerariyɨm Adi Komii siir omaka aiir, sɨmiirɨn sɨma yɨkropki, Jon siiram. Mɨ sɨma siir hɨriir ha nɨmbiyamɨm mɨ sɨma siir inɨ srɨiyɨu, kɨra dimu mɨi mɨriigɨn, ha? ");
INSERT INTO iws_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Mɨ siya dimɨn whɨr bɨ nɨmprɨokikɨn. Siya ɨni hɨriiyar haknoudnɨnkɨnswokiyɨn. Mɨ siya boɨn, kara tɨ inkamɨn Adi Komii siya nɨmbingiyɨn Isrel sɨmiir iikamɨm sɨmiir whɨnkɨnsiis haigɨnɨuwam, Mesaia, kara si rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Mɨ sɨma siirɨn hɨnɨɨna srɨi mɨ kɨra tɨ inkamɨn Isrel sɨmiir iikamɨm sɨmiir whɨnkɨnsiis haigɨnɨuwanɨn siya karamaekɨ nɨuwi mɨ kɨra yɨpɨkɨn, ha? Mɨ kɨra tari Ilaijakɨn, ha? Mɨ Jon siya ɨna yowarkɨi boɨnkiyɨn. Nɨɨngaka. Kara Ilaija rani. Mɨ sɨma siirɨn ɨna swokɨ srɨiyɨm mɨ kɨra tɨ profet inkamɨn krɨma nwowɨnɨn nɨtam siya, ha? Mɨ siya ɨna swokɨ owarkɨi boɨnkiyɨn, kara si rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Mɨ sɨma siirɨn ɨna swokɨ srɨigiyɨm mɨ kɨra tari yɨpɨkɨn, ha? Krɨma tɨ kamɨm krɨmiir nɨkropkiyɨm sɨmiirɨn hɨnɨɨna ninɨ boɨnɨuwam tɨri, kɨra tɨ si. Mɨ kɨra krɨmiir boɨnki hɨnɨɨn, kɨra yɨpɨkɨn, ha? ");
INSERT INTO iws_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Mɨ Jon siya sɨmiirɨn hɨnɨɨna boɨnki, Kara tɨ si. Kara inkamɨn maeyau siiyɨn nu apa hɨr kauwok boɨnamnankiyɨn siya hɨnɨɨn, iikam kɨma siyɨuɨn sɨbgu kisɨsop dirɨraerarkwokɨn. Bɨiyan Inkam Komii siiram siya napnaniyam. Bɨiya profet Aisaia siya yokwo komii saiirɨn hɨnɨɨna wɨnboɨnkikɨn. ");
INSERT INTO iws_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Mɨ Farisimi iikamɨm yɨpɨkɨ nɨnoknɨnkɨn komiigakɨm Mosesni siyɨu si nɨnoknɨnkɨnɨm mɨ siir sɨbgu apɨm, tɨ kam ɨmiirɨn sɨma nɨkropkikɨm Jon siiramɨn, ɨkɨ srɨipai srɨipaiyɨm sɨm ninɨ srɨiyɨuwam. ");
INSERT INTO iws_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Mɨ sɨma Jon siirɨn hɨnɨɨna boɨn mɨ kɨra tɨ inkamɨn Adi komii siya nɨmbingiyɨn Isrelmi iikamɨm sɨmiir whɨnkɨnsiis haigɨnɨuwam kɨra siya karamaekɨ nɨuwi mɨ kɨra tɨ inkamɨn Ilaija siya karamaekɨ mɨ ɨuwi mɨ kɨra tɨ profet inkamɨn krɨma nwokwokɨn siya karamaekɨ mɨ ɨuwi mɨ kɨra iikam ɨmiirɨn op dimusi baptais haigɨnɨugɨn, ha? ");
INSERT INTO iws_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Mɨ Jon siya hɨnɨɨna yowarkɨi boɨnki mɨ kara iikam ɨmiirɨn op arar baptais haigɨnɨuwi. Inkam nwɨrɨn ɨni kɨmaka waraurar nɨtapiyokɨn mɨ wɨm kɨma siir mɨ ɨnoknɨnkɨn tani. ");
INSERT INTO iws_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Yɨo siya ɨni kariir mhoɨiya nɨtɨn. Mɨ siya inɨg komiigakɨn, kariir kouwɨn ɨni siya ywowɨn. Mɨ an kara inkam paeprikab nɨɨngakɨn mɨ kara ɨga siya niiya saiir uridɨn wa kara waisi hakrani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Mɨ tɨ dimɨnɨm yɨm om Betani hɨr nɨmbiyamkɨm, Jodan ɨegbid mɨrmiiya maeyauwa op Jon siya baptais haigɨnɨuwa iikam ɨmiir. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mɨ ɨigwɨra, Jon siya Jisɨs siir kɨgwɨnɨn siya siiram napniyɨn mɨ siya iikam ɨmiir boɨnki, kɨma tɨ kɨgwɨn, ɨ inkamɨn nɨtɨn. Siya ɨni sibsibnan ywowɨn siirɨn Adi Komii siya nɨkropkikɨn krɨmiir dimɨn biyɨe biyɨeyɨm krɨma tɨrɨm sɨmiir haiyoprimdiyɨumiigiyam naowɨm. ");
INSERT INTO iws_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yɨo tɨ inkamɨn bɨiya kara kɨmiir nikɨ boɨnɨn hɨnɨɨn, inkamɨn kariir mhoɨiya nɨtɨn kariir kouwɨn ɨni siya ywowɨn. Mɨ tɨ inkamɨn siyaɨrgɨn. Dimusi rani, siya bɨdibɨdiniyar nwokɨn Adi saɨkan kariir apua kariir bɨ nikɨ aokainakɨn. ");
INSERT INTO iws_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Bɨiya kara siirɨn ha bɨ nɨnoknɨnkɨnkɨn, siya pɨndankɨn mɨ kara iikam ɨmiirɨn op baptais haigɨnɨuwɨm. Tɨ tapa kara tɨra saiir hɨriinan, Isrel kɨmiir iikamɨm sɨmiir nɨisiimauuwam. Mɨ kɨma wɨ ha nwokɨ ɨnoknɨnkɨnɨm siya yɨpɨkɨn. ");
INSERT INTO iws_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Mɨ Jon siya digworaekwo whɨekakɨm siya kɨgɨm sɨmiirɨn ɨna boɨnmɨmauu dɨgɨm. Mɨ karar kɨgwɨn Adi Komii siir naeyɨuɨn ɨɨnmabnan siinanaiiniyɨn, Adi Komii siir om hɨrankɨn mɨ ɨni siirar yaunɨ siinatkɨniyɨn. ");
INSERT INTO iws_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mɨ bɨiyarɨn kara tɨ inkam ɨiir bɨ nɨnoknɨnkɨnkɨn, Adi Komii siya nɨmbingiyɨn iikam whɨekakɨm sɨmiir whɨnkɨnsiis haigɨnɨuwam. Nɨɨngaka. Kariirɨn Adi Komii siya nɨmbingikɨn iikam ɨmiirɨn op baptais haigɨnɨuwam. Mɨ siya kariirɨn hɨnɨɨna boɨnki, kɨra wɨ Adi Komii siir naeyɨu ɨiir kɨgwɨni, siya siinanaiini mɨ siya wɨ inkam nwɨrɨn siir pɨu nasiinatkɨnii. Mɨ tɨ inkamɨn yɨo iikam ɨmiirɨn wɨ Adi Komii siir naeyɨu ɨiirarar baptais haigɨnɨuwi. Mɨ siirɨn wɨ siyar tɨrkii, iikamɨm sɨmiir mhɨi kwoɨnau kwɨrii ɨdwokaiyam. ");
INSERT INTO iws_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jon siya hɨnɨɨna boɨnkɨn, an kara siir bɨdi kɨgɨn mɨ kara kɨmiirɨn pɨ ha boɨni, siya Adi Komii siir yɨnisɨmkɨn Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mɨ ɨigwɨr nugakɨn, Jon siya siir kɨgna mɨrii inkam nwɨso sowaka nwoyakwoko Jodan ɨegbid. ");
INSERT INTO iws_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Mɨ ta maeyau aiirarɨn siyar kɨgwɨn Jisɨs siya pɨ napni. Mɨ siya ɨna boɨnɨn tɨ inkamɨn siya ɨni sibsibnan ywowɨn, siirɨn Adi Komii siya nɨkropkikɨn, iikam ɨmiir whɨndirɨraeram naowam. ");
INSERT INTO iws_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Mɨ siir kɨgna mɨriiyo inkam nwɨso sowa hɨriinan wakaeyo mɨ sowa ɨni Jisɨs siir mhoɨiyar yamo. ");
INSERT INTO iws_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Mɨ Jisɨs siya ha niyaekaowɨnɨn mɨ siyar kɨgwɨn sowa siir mhoɨiyar nɨti. Mɨ siya sowiirɨn ɨna srɨiwɨnɨn, kowa dimu dimɨnɨm kɨgi, ha? Mɨ sowa ɨna yowarkɨi boɨno siirɨn, Rabai, kɨra papi nwokaiigɨn. Tɨ inɨgɨn siir inɨg mwokɨ mwowɨn, iikam nowomwarkaiyɨuwigɨn. ");
INSERT INTO iws_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Mɨ siya sowiir yai aka hɨnɨɨna yowarkɨi boɨn, kowai winɨkɨgnaki. Mɨ sowa ɨni saɨkar yɨnkɨn amo, siir maeyauwa siya whwonkaiiya saiir ninɨ kɨgnakiyam. Mɨ sowa saɨka hɨrar nwonɨnaekwowako, ɨni ɨi aeyar dɨgirɨba. Bɨeyɨn nad bɨdi ywowɨn ɨi kwiinanaɨrga. ");
INSERT INTO iws_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Inkam nwɨrɨn siir inɨgɨn Endrukɨn, siya Saimon Pitani nomousɨmkɨn. Tɨ inkam nwɨso Joni yai wakaeyo mɨ Jisɨs siir mhoɨiya ha namo sowiir nwɨr ɨeya. ");
INSERT INTO iws_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Mɨ bɨri kɨmɨmɨnkikɨn Endru siya ɨna yamsauwɨn siir yaowaeyɨn Saimon Pita siiram. Mɨ siya ninɨ kɨgɨuwɨn mɨ siya siir inɨ boɨnɨu, krɨra Mesaia siir bɨdi kɨgo. Mɨ inkamɨn siir inɨg mwokɨmwowɨn, Kraiskɨn, inkamɨn Adi Komii siya nɨkropkiyɨn iikam ɨmiir whɨnkɨnsiis haigɨnɨuwam ");
INSERT INTO iws_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Mɨ tɨ siya boɨna siir saiir mhoɨiya mɨ siya Saimon siirɨn ɨna yɨkɨunamɨn Jisɨs siiram. Mɨ Jisɨs siya siir kɨgwɨnɨn mɨ siya siirɨn hɨnɨɨna boɨn, kɨra Saimonkɨn, kɨra Joni yɨnisɨmkɨn. Mhoɨiya kɨriir inɨgɨn wɨ Sifas kisɨna dapi. Tɨ inɨgɨn siir inɨg mwokɨ mwowɨn Pitaɨn. Grik sɨmiir yaigɨna ha dapikɨn siiya. ");
INSERT INTO iws_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mɨ ɨigwɨra Jisɨs siya nu haɨmii whɨrɨn Galili hɨriir namam tɨrɨn mɨ siya Filip siir kɨgɨn mɨ siya kɨmɨdiniya siir boɨn, kɨra kanakar wɨt. ");
INSERT INTO iws_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipɨn yɨo om Betsaida hɨran inkamkɨn. Endru Pita sɨma ɨrɨpa om whɨruwankɨm. ");
INSERT INTO iws_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip siya ha namɨn mɨ siya Nataniel siir ninɨ kɨgɨuwɨn mɨ siirɨn hɨnɨɨna inɨ boɨnɨu, tɨ inkamɨn bɨiya Moseskɨn si wɨnboɨnkiyɨn, Yokwo Komii saiir, siirɨn krɨra bɨdi kɨgɨn. Mɨ profet kamɨm yɨm ɨriipɨ hɨriinan siirar mɨ wɨn boɨnkikɨn. Yɨo Jisɨskɨn, Josepni yɨnisɨmɨn, om Nasaret hɨranɨn siya. ");
INSERT INTO iws_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Mɨ Nataniel siya siir boɨnki, tɨ om Nasaretɨn dimɨn kɨbi whɨrkɨ bɨ swokɨ ɨmbiyamɨmɨnkɨn. Nɨɨngaka. Mɨ Filip siya siir yai aka hɨnɨɨna yowarkɨi boɨn, kɨra unkɨni kɨgnaki siirɨn. ");
INSERT INTO iws_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Mɨ Jisɨs siya Nataniel siir kɨgwɨnɨn, siya siiram namɨn mɨ siya siirɨn hɨnɨɨna boɨnwɨn, kɨma hoɨmgakɨn tɨ Isrelan inkam kɨbiyɨn siir kɨgwɨn, siya bɨ nɨksɨsaeikɨn mɨ siya yaimɨr bɨ nwowikɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Mɨ Nataniel siya siir yai aka hɨnɨɨna yowarkɨi boɨn, kɨra kariirɨn panɨɨn panɨɨna nɨnoknɨnkɨnkɨn, ha? Mɨ Jisɨs siya siir yai aka hɨnɨɨna swokɨ owarkɨi boɨn, kara kɨnaka nwo karamaekɨ wɨndi, kara kɨriirɨn ɨiya Filip siya nikɨ ɨkɨuna karamaeyar nikɨ owɨn, kara kɨriirɨn pae pigɨn siir mɨi hɨrar nikɨ ɨdwowɨn saiirar nɨnoknɨnkɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Mɨ Nataniel siya siir yai aka hɨnɨɨna yowarkɨi boɨn, inkamɨn iikam nowomwarkaiyɨuwiyɨn, kara kɨriirɨn ɨna nɨnoknɨnkɨnɨn, kɨra Adi Komii siir yɨnisɨmkɨn. Mɨ kɨra wɨ Isrel sɨmiir iikamɨm sɨmiir kɨgɨrkakan inkam nwowi. ");
INSERT INTO iws_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Mɨ Jisɨs siya siir yai aka hɨnɨɨna yowarkɨi boɨnki, kɨra ha naɨngwo tɨbmii kɨɨngɨn, kara Adi Komii siir yɨnisɨmkɨn mɨ ta yaiya kara boɨna kɨriir hɨnɨɨn kara kɨriirɨn pae pigɨn siir mɨi hɨr kɨgɨn, kɨra siir mɨi hɨr nɨdwowɨn mɨ kɨra ha naɨngwo tɨbmiigikɨn, aniya? Ya tariingɨna, ya dimɨn komii rani, mhoɨiya kɨra wɨ dimɨn kɨrɨe komii komii kasa kɨg rani. Yɨm tɨriigɨnɨm ɨni saiir haiburɨm. ");
INSERT INTO iws_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Mɨ siya sɨmiirɨn ɨna swokɨ boɨnkiyɨn, kara kɨmiirɨn yaimwowar boɨni, mhoɨiya wɨ kɨmar kɨgi Adi Komii siir omɨn nɨnomor kou hɨranɨn siir anowɨn haiwaokiyɨn. Mɨ Adi Komii siir paekwosɨmɨm wɨ kɨmar mɨ kɨgi ɨni haɨmii tamii wokɨuun apɨuunɨm kariir kɨgam, Bɨiyan Inkam Komiiyɨn siiram. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Mɨ ɨi kwoɨmaka wigkamwo om Kena nu haɨmii Galili hɨrano pɨ nonkwonam tɨrko. Mɨ Jisɨs siir apua ya hɨr warar nɨnkɨn oka. ");
INSERT INTO iws_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Mɨ sɨma mɨ Jisɨs siya mɨ kamɨm siir kɨgna mɨrii ɨkɨm sɨmiiram warar yɨnkɨn ɨkɨuna. Ta sowa nonkwonaɨna saiir kɨgnakiyɨm. ");
INSERT INTO iws_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mɨ mhoɨiya sɨma wain opa ha kwiyae swokiyɨm mɨ Jisɨs siir apua kɨmɨdiniya siir boɨn. Wain opa sɨma bɨdi kwiyae swokiya, haɨmii sɨmkɨ bɨ swokɨ omaigikɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Mɨ Jisɨs siya saiir yai aka hɨnɨɨna yowarkɨi boɨn, wig, kɨra kariir kɨpi boɨn, hɨriinan tɨramɨn, yɨo kariirar dimɨnkɨn. Kariir ɨiya bɨ nikɨ ɨmbinika, kara kanakana nɨisiimauunana hɨnɨɨn kara yɨpɨkɨn. ");
INSERT INTO iws_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mɨ siir yopiiya tɨ kamɨm tɨ digworaekwo ɨmiir dirɨraerarɨm sɨmiirɨn hɨnɨɨn asi boɨnka, dimɨnɨn pɨ siya boɨni, kɨma tɨram mɨ kɨma pa tɨr. ");
INSERT INTO iws_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Mɨ Isrel sɨmiir iikamɨm sɨma wɨnboɨnkiyɨn, siyɨu whɨrɨn siya hɨnɨɨna boɨnkɨn. Ɨiya sɨma nae naeyam tɨriyɨm, bɨiyɨn ɨɨnop tikɨ dɨu mɨ mhoɨiya dae. Mɨ sɨma kamhau komii komiiyɨm Judamiyɨm ɨriiyar ɨra nwowi mɨ tɨ kamhau ɨriiyar ɨrɨm sɨma ɨrɨra opɨm 20 galans mɨ 30 galans mɨnanar pɨ ywowɨn. ");
INSERT INTO iws_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Mɨ Jisɨs siya sɨmiir boɨnki, wara kamhau ɨmiirɨn op kunaokaigi. Mɨ sɨma ha kunaokaiyɨm ɨni yaigɨyaigɨ yakɨ ɨnkɨkɨniyɨm. ");
INSERT INTO iws_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Mɨ ɨiya sɨma ha kunaokai dɨgiyɨm mɨ siya sɨmiirɨn ɨna boɨnkiyɨm, kɨma op nhɨrɨm tɨ inkamɨn ta wigwas naeya saiir kɨgrɨraowɨn siiram tikɨ tɨbna kunanam. Mɨ ta Jisɨs siya boɨna saiir mhoɨiya sɨma opa ɨna tɨbna kuna hainamɨm siir hauuwam. ");
INSERT INTO iws_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mɨ tɨ inkamɨn siya ta opa Jisɨs siya tɨrkiya wain nɨkpɨtmaigiya saiir kwiyae kɨuwɨn, op wain nɨmbiniyama mɨ siya bɨ nɨnoknɨnkɨnkɨn, sɨma ta opa papi namisi haiga. Mɨ tɨ kamɨm ta op aiir nonkwo dirɨraerarɨm yɨm sɨma ɨna nɨnoknɨnkɨnɨm, maeyauwa sɨma haiya. Mɨ tɨ inkamɨn ta wigwas nae aiir kɨgrɨraowiyɨn, ɨna yɨkɨugiyɨn tɨ inkamɨn wig nonkwonaɨn siiram, ");
INSERT INTO iws_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","nɨm krɨma hɨnɨɨna tɨrikɨm, iikam ɨmiirɨn bɨi pɨ wain kɨbikɨ kɨbi ɨiirar hauu kwiyaei. Mɨ ɨiya sɨma hoɨmgak kwiyaenanaekiiyɨm mɨ ɨkɨ wainɨn biyɨerɨgsɨm nwowiyɨn yɨpi haɨnɨɨngɨ hauu kwiyaei. Mɨ nikɨra hɨriinan bɨ tɨrkɨn. Nikɨra wain kɨbikɨ kɨbiyɨn kɨmɨdiniya mhoɨiya hauu iikam ɨma kwiyaeyamɨn. ");
INSERT INTO iws_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ya tariigɨna ya dimɨn kɨrɨe komiiya Jisɨs siya tɨra bɨigɨ bɨi saeya. Siya ta saiirɨn om Kena nu haɨmii Galili hɨr nwowɨn siir hɨr tɨrkɨn. Mɨ ta ɨiya siya siir kɨrɨe komiiya mɨ siir dimɨn mɨiyɨk mɨiyɨkɨm Adi Komii siya hauuwɨn siir, siya kamɨm siir kɨgna mɨriiyɨm sɨmiirɨn saiir nɨisiimauugɨn. Mɨ wa ha nwokɨ aɨngwo tɨbmii kɨɨnɨm Jisɨs siya Adi Komii siir yɨnisɨmkɨn. ");
INSERT INTO iws_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Mɨ ta saiir mhoɨiya Jisɨs siya mɨ siir apu aeya mɨ siir nomousɨsɨm ɨma mɨ kamɨm siir kɨgna mɨrii ɨkɨm, sɨma ɨna yamɨm om whɨrɨn siir Kapaneam. Mɨ sɨma ɨi nhɨrɨm hɨrar mɨ o. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Mɨ Juda sɨmiir iikamɨm wou sɨma nikwo aeyana Pasova ɨni kingiin nwowa. Mɨ Jisɨs siya om Jerusalem hɨriir asi namkɨn. ");
INSERT INTO iws_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Mɨ ɨiya siya Adi Komii siir omaka aiir nouapnɨnopkainamɨn mɨ siyar kɨg iikamɨm sɨma bulmakau, sibsib mɨ ɨpiyɨn, sɨm haigɨni iikam nhɨrkɨm saɨnɨm. Mɨ yɨm sɨma umɨr pɨ sɨmiirsiyar mɨ haii. Mɨ siyar kɨg, tɨ kamɨm sɨma kam nhɨrɨm nu whɨranɨm sɨmakar nɨdwokaiyokaii, ipii kwɨruwar Isrel sɨmiirgɨ sɨmiir umɨra saiirgɨsaiir nɨnowana haiyam. ");
INSERT INTO iws_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Mɨ siya tɨ hɨriinan digworaekwowɨm sɨmiir kɨgɨn mɨ siya uridɨn ha haiyɨn, kɨmɨdiniya brouwisidnan yonkwokwo mɨ siya ɨna nhɨnkii pɨɨryɨmyoknamɨn sibsib, bulmakau mɨnɨm sɨmiir mɨ kamɨm umɨr nɨnowana haiiyɨm sɨmiir warar. Mɨ siya sɨmiirɨn ɨna yɨnkɨnaeyokiyok pɨɨryɨmyoknaniyamɨn. Mɨ hɨi mɨnɨm sɨmiir warar yɨnkɨn ɨriid nhɨɨmnhɨɨnkɨiyam mɨ sɨmiir umɨrɨm ɨni maeyau maeyau iswapiyar ywowamɨm. ");
INSERT INTO iws_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Mɨ siya iikamɨm yɨpɨkɨ ɨpiyɨn mɨn haigɨnɨm iikam nhɨrɨm sɨma saɨnam siya sɨmiir boɨnki, tɨ kɨmiir ɨpiyɨn mɨnɨm tɨ hainaniyam. Kara pɨ boriisopi kɨma kariir Adɨn siir omaka saiirɨn hɨnɨɨn tɨrɨm. Maeyaua iikamɨm nɨnkɨnɨuwiya dimɨn taemɨn wokiyok saɨniya saiir hɨriinan nwowɨm. ");
INSERT INTO iws_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma yai kwɨra Yokwo Komii sɨma mwan kɨga, saiir swokɨ aɨngwowarkaigi. Saeya hɨnɨɨna boɨnka, Adi Komii, kariir kwoɨn komiiyɨn kɨriir omaka aiir sɨbgu kɨgrɨraowam naɨngwowi, kara ha naɨngwowi, saeya wadɨe hɨriiyar dwo. ");
INSERT INTO iws_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Mɨ ta siya tɨrkiya saiir mhoɨiya Isrel sɨmiir kaunselɨn sɨmiir bɨiyan kamɨm ɨna yɨtɨm. Mɨ sɨma ha nɨtɨm siiram mɨ kɨmɨdina siir inɨ boɨni mɨ kɨriirɨn Adi Komii siya nwowaigɨnɨuwi inɨg komiigak hɨriinan tɨram mɨ panao kɨra pɨ dimɨn kɨrɨe komii whɨr tɨr krɨmiir whwonkam ɨdaɨn, krɨmiir nɨisiimauuwam. ");
INSERT INTO iws_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Mɨ Jisɨs siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨn, kɨma ta Adi Komii siir omaka aiir nɨinɨnkɨii mɨ kara saiirɨn wɨ ɨi kwoɨmuwar swokɨ kwamɨrii nɨnɨkougii. ");
INSERT INTO iws_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Mɨ sɨma siir yai aka hɨnɨɨna yowarkɨi boɨn, ta Adi Komii siir omaka saiir mɨriiya bɨewiyɨm kamnwɨs ɨriiyar whɨra mɨriiga. Mɨ nikɨra ha boɨnkɨn, saiirɨn wɨ ɨi kwoɨmuwar kwamɨrii nɨnɨkougii wɨ dɨg nwo rani. ");
INSERT INTO iws_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jisɨs siya Adi Komii siir omaka saiir bɨ boɨnkɨn. Nɨɨngaka. Siya siir pɨu aiirar boɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Mɨ mhoɨiya kamɨm sɨma Jisɨs siir nɨsomaokiyɨm mɨ siya ha naonamɨn mɨ siirɨn Adi Komii siyar swokɨ hɨdnɨnsiin ɨdwo ɨe hɨrankɨn. Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma yaiya bɨiya Jisɨs siya boɨna saiir swokɨ aɨngwowarkaigiyɨm mɨ sɨma hanɨɨngɨ yaɨngwo tɨbmii kɨɨngi Adi Komii siir yaiyɨm bɨiya sɨma wɨnkiyɨm Yokwo Komiini sɨmiiramɨn. Ya ta yaiya ya Jisɨs siir yaimwo aeyaɨrga. ");
INSERT INTO iws_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Mɨ Jisɨs siya om komii Jerusalem hɨrar nikɨ owɨn, Judami iikamɨm sɨmiir ɨi komiiya wou nikwo aeiya Pasova mɨ ta maeyau aiirarɨn iikam kasa rani, dimɨn kɨrɨe komii komiiyɨm Jisɨs siya tɨrɨm sɨmiir kɨgɨm. Mɨ tɨ dimɨn hɨriinanɨm sɨma kɨgɨm iikam kasa rani, naɨngwo tɨbmii kɨɨngiyɨm siirɨm. ");
INSERT INTO iws_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Mɨ Jisɨs siya sɨmiir naɨngwo tɨbmiikɨɨn aiir bɨ naɨngwo tɨbmiigikɨn. Nɨɨngaka. Mɨ tɨ hɨriinan saiirsika siya, hɨnɨɨn panɨɨnsi yaɨngwosi siirɨn sɨmiir ɨɨn hauuwɨm. Dimusi rani, siya iikam sɨmiir kwoɨn ɨmiir bɨdi yɨnoknɨnkɨn kɨɨnɨn. ");
INSERT INTO iws_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Siya iikamɨm sɨmiir kwoɨn ɨmiirɨn bɨdiyar yɨnoknɨnkɨnɨn. Mɨ siirɨn inkam nwɨrkɨ bɨ haiburgɨn ɨkɨ iikamɨm sɨmiir kwoɨn ɨmiir nɨnoknɨnkɨnɨm mɨ sɨma siirɨn wɨ inkam nwɨrkɨ swokɨ boɨnmauu rani, iikam sɨmiir kwoɨn ɨmiirɨn. Nɨɨngaka. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Inkam nwɨrɨn siir inɨgɨn Nikodimaskɨn, siya Isrel sɨmiir iikamɨm sɨmiir kɨgrɨraowiyɨm bɨiyan inkamɨm sɨmiir nwɨrkɨn siya Farisi inkamkɨn. ");
INSERT INTO iws_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Mɨ ɨigwɨr nɨiyaka siya Jisɨs siiram yamwɨi. Mɨ kɨmɨdiniya siir inɨ boɨnɨu, inkamɨn iikam nowomwarkaiyɨuwiyɨn, krɨma bɨdi yɨnoknɨnkɨnɨm, kɨriirɨn Adi Komii siyar nɨkrop ɨuungikɨn dimɨn kɨrɨe komii komii krɨmiir nɨisiimauuwam. Inkamkɨ sɨmiir tɨrɨm wɨ dɨg nwo rani, Adi Komii siya siir whɨnkɨnsiis haigɨnɨu karamae nwowi tɨ dimɨn ɨiiram. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Mɨ Jisɨs siya siir yai aka hɨnɨɨna yowarkɨi boɨn, kara kɨriirɨn pɨ ha boɨni ta yaiya yaimwowaɨrga. Inkamɨn yɨnisɨmnan yaeya swokɨ aokaina karamae nwowi siya wɨ Adi Komii siya kɨgɨrkakiyɨm digworaekwo whɨekakɨm wɨ sɨmiir kɨg rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Mɨ Nikodimas siya siir yai aka hɨnɨɨna yowarkɨi boɨn, inkamɨn waibiyɨe nikɨ owiyɨn mɨ siya wɨ panɨɨna swokɨ ami siir yopiini mhɨinauwɨn, siir swokɨ aokainakiyɨm, ha? ");
INSERT INTO iws_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Mɨ Jisɨs siya siir yai aka ɨna swokɨ owarkɨi boɨnkiyɨn Kara kɨriirɨn yaimwowar boɨnki, inkamɨn op baptais karamae nwowi mɨ Adi Komii krɨmiir Wanɨn siir naeyɨuɨn siirɨn kwoɨn rɨrmiiya nwowiyɨn siir hauu karamae nwowi siya wɨ dɨg nwo rani, Adi Komii siya kɨgɨrkakiyɨm siir digworaekwo whɨekakɨm sɨmiir kɨgɨm. ");
INSERT INTO iws_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mɨ inkamɨn siir yopiigɨ naokainakiiyɨn yɨo nu tɨranar inkamkɨn mɨ yɨpɨkɨ inkamɨn Adi Komii siir naeyɨuɨn kwoɨn wɨn siya hauuwiyɨn, yɨo siya wɨ inkam wɨn nwowi. ");
INSERT INTO iws_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kɨra ta yaiya kara boɨnkiya kɨriir saiirsi kɨpi nanaaki Adi Komii siir naeyɨuɨn kɨriirɨn wɨ kwoɨn wɨn siyar hauu haigɨnɨuwi. ");
INSERT INTO iws_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Opuda ya hɨndankɨ pa hugnani mɨ tɨndankɨ pa mɨ hugnani. Mɨ kɨra saeya hugiyɨm pa wakaei mɨ kɨra saiirɨn ha nɨnoknɨnkɨn tani saeya pɨndankɨ hugnaniya mɨ ɨni pɨnda hugnama. Adi Komii siir naeyɨuɨn ɨni ta saiir hɨriinan ywowɨn. Krɨma nɨnoknɨnkɨn tani siya dimɨn taemɨn ɨmiirɨn panɨɨn panɨɨna tɨri mɨ iikam ɨmiirɨn panɨɨn panɨɨn whɨnkɨnsiis haigɨnɨuwi. ");
INSERT INTO iws_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Mɨ Nikodimas siya Jisɨs siir swokɨ srɨi, tɨ dimɨn hɨriinanɨn wɨ panɨɨna nɨmbiyami, ha? ");
INSERT INTO iws_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Mɨ Jisɨs siya siir yai aka hɨnɨɨna yowarkɨi boɨnki, kɨra inkam komiiyaɨrgɨn mɨ kɨra iikamar mɨ owomwarkaiyɨuwikɨn mɨ kɨriir nɨnoknɨnkɨna ɨkɨ digworaekwo whɨekakɨm sɨmiir nɨnoknɨnkɨna ɨni Isrel sɨmiir iikamɨm sɨmiir nɨnoknɨnkɨna saiir haibura. Mɨ kɨra tɨ digworaekwo ɨmiir nɨnoknɨnkɨn karamae dimusi nwokɨn, ha? ");
INSERT INTO iws_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kara kɨriirɨn yaimwowar boɨnkii, nɨm krɨma dimɨnɨn krɨmar nɨnoknɨnkɨnɨm mɨ krɨmar kɨgɨm sɨmiirarar boɨnikɨm. Mɨ wɨm kɨma ɨinokɨinokɨn tɨ yaiyɨm krɨma boɨniyɨm pɨ yaewan sɨmiir kɨndiyɨuwani. ");
INSERT INTO iws_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mɨ kɨra tɨ digworaekwoɨm nuanɨm kara kɨriir boɨnmɨmauuɨm tɨ dimɨn hɨnɨɨnɨm yɨnisɨmnan yopiigɨ swokɨ aokainaki mɨ opud kɨra sɨmiiram naɨngwo tɨbmii kɨɨn karamae nwowi mɨ kɨra wɨ panɨɨna naɨngwo tɨbmii kɨɨni kara Adi Komii siir omɨn nɨnomor kou hɨr nwowɨn siir digworaekwowɨm sɨmiir boɨnmɨmauuwi, ha? ");
INSERT INTO iws_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mɨ karaɨrgɨn Adi Komii siir omɨn siir hɨran inkamɨn, karaɨrgɨn inkamɨn Adi Komii siir omɨn nɨnomor kou hɨr nwowɨn siir hɨrankɨ nɨuunaiiniyɨn. Kanakanaɨrgɨn Adi Komii saɨkar nwowɨn siir om ɨiir bɨdi bɨdiniyar. ");
INSERT INTO iws_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ɨni Moseskɨ si nonkwokwowɨn mɨpugɨn mɨ paeyaka ha nɨkɨn koginankiigiyɨn ɨni siir hɨriinan ywowɨn, maeyau siiyɨn nu apa nɨɨnga saiir hɨr. Mɨ tɨ hɨriinan siyɨuɨn iikamɨm sɨma kariirɨn nɨnomor kouan inkamɨn paeyɨn hɨiniya nɨrɨonɨnkɨnɨn saɨkar wɨ hɨriinanar mɨ ɨnkɨn ɨrɨnu inansiingii. ");
INSERT INTO iws_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Mɨ iikam whɨekakɨm kariirɨm naɨngwo tɨbmii kɨɨni sɨma wɨ omwai Adi Komii saɨkar waiyayokiyokɨikaeyami ɨinokɨinokɨn. ");
INSERT INTO iws_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Adi Komii krɨmiir Wanɨn siya iikam whɨekakɨm nuanɨm sɨmiiram naɨngwokwonanaeikɨn mɨ siya siir yɨnisɨm nwɨrkɨnwɨruwan siir asi nɨkropkikɨn. Mɨ yɨpɨkɨ siiram naɨngwo tɨbmii kɨɨni sɨma wɨ nao rani mɨ wɨ kɨgugu ɨguski rani. Nɨɨngaka. Sɨma wɨ omwai hɨriiyar waiyayokiyokɨikaeyami Adi Komii krɨmiir Wanɨn saɨkar ");
INSERT INTO iws_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Adi Komii krɨmiir Wanɨn siya siir yɨnisɨm ɨiirɨn iikamɨm nuanɨm sɨmiir hɨdam bɨ nɨkrop ɨuungikɨn. Nɨɨngaka. Siya mɨnam nɨtkɨn iikamɨm nuanɨm sɨmiir nanmaiwarkainam naowam. ");
INSERT INTO iws_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mɨ yɨpɨkɨ Adi Komii siir yɨnisɨmɨn siiram naɨngwo tɨbmii kɨɨni Adi Komii siya siirɨn wɨ warar nɨnkɨn hɨd rani mɨ siya wɨ maeyaua paekɨ nwowa wɨ saiir wara nam tani. Nɨɨngaka. Mɨ yɨpɨkɨ Adi Komii siir yɨnisɨmɨn siiram naɨngwo tɨbmii kɨɨn karamae nwowɨn siirɨn Adi Komii siya bɨdi hɨdɨn. Dimusi rani, siya tɨ Adi Komii siir yɨnisɨm nwɨrkɨ nwɨruwan siiram bɨ naɨngwo tɨbmiigɨn. ");
INSERT INTO iws_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Adi Komii siya iikam ɨmiirɨn hɨnɨɨna hɨdgɨm, kariir yaiyɨm ɨni bɨekɨ whwoyanan ywowɨm. Kara tɨ nu ɨiirɨn mɨnam nɨtkɨn Adi Komii siir dimɨn taemɨnɨm sɨmiir nɨisiimauuwɨm mɨ sɨma Adi Komii siir dimɨn mɨiyɨk mɨiyɨkɨm sɨmiiram bɨ naɨngwokɨm, sɨma nuan dimɨn biyɨeyɨm sɨmiiramar naɨngwo krɨpkaigɨm. Dimusi rani, sɨma dimɨn biyɨe tɨram naɨngwokɨm. ");
INSERT INTO iws_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mɨ yɨpɨkɨn siyɨu biyɨe tɨriyɨm, yɨm Adi Komii siir yɨnisɨmɨn paenan nɨuyaeiyɨn yɨm siir ɨo omomkɨn. Sɨma Adi Komii siir yɨnisɨmɨn siir siyɨu ɨiir sɨbgu apɨm pɨ boriisopi. Dimusi rani, dimɨn taemɨn biyɨeyɨm sɨma tɨriyɨm wɨ si nhɨnkiisi. ");
INSERT INTO iws_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Mɨ yɨpɨkɨ siyɨu mɨiyɨk tɨram naɨngwowɨm yɨm Adi Komii siir yɨnisɨmkɨm bɨenan whwoyaeiyɨm kariiram wɨt. Mɨ siya iikam ɨmiirɨn siyɨu mɨiyɨkɨn Adi Komii siya naɨngwoɨn siya tɨram wɨ sɨmiir nwokɨ ɨisiimauuɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Mɨ ta saiir mhoɨiya Jisɨs siya mɨ kamɨm siir kɨgna mɨriiyɨm sɨma om komii Jerusalem siir haiburgigɨm mɨ sɨma omisɨm whɨrɨn nu Judia hɨr nwowɨn siir yam. Mɨ sɨma ɨi nhɨrɨm hɨrar ywo mɨ sɨma iikam ɨmiirɨn op ɨna baptais haigɨnɨuwɨm. ");
INSERT INTO iws_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Mɨ Jonɨn yɨo ɨriipɨ hɨriinan iikam ɨmiirɨn op ɨna mɨ baptais haigɨnɨuwɨn om Inon Selim kingiin hɨr. Dimusi rani, ta maeyau aiirɨn op kasa rani mɨ iikamɨm siirɨn mɨnam ninɨ kɨgnikɨm siya op sɨmiir baptais haigɨnɨuwɨm. ");
INSERT INTO iws_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Herot siya Jon siir bɨ nikɨ hɨugrɨpkɨikikaigɨn maeyaua mɨi biyɨe mɨriiya saiir. ");
INSERT INTO iws_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Mɨ Jon siir kɨgna mɨrii kam nhɨrɨm sɨma Judami inkam nwɨrɨn Isrelanɨn saɨkar nɨnkɨnwamwarkɨi boɨnkɨm. Sɨma op baptaisni siyɨuɨn siir nɨnkɨnwamwarkɨi boɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Mɨ sɨma asi nɨtkɨm Jon siir kɨgniyam. Mɨ sɨma siir boɨn, inkamɨn iikam nowomwarkaiyɨuwiyɨn, kɨra ɨna nɨnoknɨnkɨnɨn inkamɨn kɨnaka nwowɨn Jodan ɨegbid mɨrmii hɨrɨn siirɨn kɨra krɨmiir boɨnɨn. Tariinanɨn siya iikam kasa bɨ baptais haigɨnɨugɨn. Mɨ iikam whɨekakɨm ɨni siiramar ninantɨonanamɨm mɨ sɨma krɨmiiram nɨt rani. ");
INSERT INTO iws_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Mɨ Jon siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨn, inkamɨn dimɨn whɨrɨn siir kwoɨn aɨrgɨ bɨ swokɨ haigɨn, kɨriirɨn siyar bɨdi boɨnki pɨ kɨra hai. ");
INSERT INTO iws_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kɨma bɨdiyar wakaeyɨm yaiyɨm kara boɨnɨm, kara tɨ inkamɨn Adi Komii siya nɨkropkiyɨn iikam ɨmiir whɨnkɨnsiis haigɨnɨuwam si rani. Nɨɨngaka. Yɨo siya ɨni kariir mhoɨiya nɨtɨn. An kara bɨiya mɨnam nami, hindara boɨnmɨmauuami sɨma siir nwokɨ ɨnoknɨnkɨnɨm. ");
INSERT INTO iws_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Inkamɨn wig nonkwonaeiyɨn ta wiga ya siirgɨsiiraɨrga. Mɨ Jisɨs siya ɨni tɨ inkamɨn siir hɨriinan ywowɨn mɨ nɨm krɨma iikamɨm yɨpɨkɨ siiram naɨngwo tɨbmiiyɨm nɨm krɨma ɨni siir wignan ywowɨm. Mɨ ɨiya siyar wakaewɨniyɨm siir nwɨrɨn ɨni nɨtɨn mɨ siya pɨ maɨrgɨmaɨrga nwowɨni. Mɨ siya dimɨn taemɨnɨm siya boɨnɨm sɨmiir wakaeiyɨm siya pɨ maɨrgɨmaɨrga nwowi. Kariir hɨriinan ta maɨrgɨmaɨrga komiigak kara mɨ owa saiir hɨriinan. Kara Jisɨs siir nwɨrkɨn. Kara siir yai aiir wakaesɨbwɨnɨn kara hɨkak bɨ nwowɨnkɨn, kara ɨni maɨrgɨmaɨrgar ywowɨnɨn. Kara hɨk karamaeka iikamɨm siiram ninantɨonanamɨm sɨmiiramɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Mɨ kara ha naɨngwowi siir inɨgɨn kougɨkouwa damki mɨ an kara ha mɨ aɨngwowi kariir inɨgɨn yɨo nugɨnuwa dokwokopoukimaigik. ");
INSERT INTO iws_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jisɨs siya Adi Komii siir omɨn siir hɨrankɨ nɨtkɨn mɨ nuan iikamɨm sɨmiirɨn ɨni siyar haiburɨm. Mɨ yɨpɨkɨn nuankɨ nɨtɨm, yɨo ɨni nuan digworaekwowɨm sɨmiiraramar naɨngwowɨn. Mɨ yɨpɨkɨn Adi Komii siir omɨn siir hɨrankɨ nɨti, yɨo wɨ digworaekwo whɨekakɨm sɨmiir haiburi. ");
INSERT INTO iws_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Dimɨn taemɨnɨm siya kɨgɨm mɨ siya wakaeyɨm siya sɨmiir asi boɨnmɨmauugɨn. Mɨ inkam nwɨrkɨn sɨmiir bɨ swokɨ wakaeyokna dirɨraerarkɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mɨ yɨpɨkɨ siir yai aiir sɨbgu wakaeyokna api, yɨo hindara nanaaknɨnkii haigɨnɨuwi ta Adi Komii siir yaiya ya yai kaimwoka. ");
INSERT INTO iws_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Mɨ inkamɨn yɨpɨkɨ Adi Komii siya nɨmbingiyɨn mɨ ha nɨkropkiyɨn, siya wɨ Adi Komii siir boɨnmɨmauuwi. Dimusi rani, Adi Komii siir naeyɨuɨn siirɨn siya bɨdi yɨnkɨnɨukikaiyɨn mɨ siirɨn siyar whɨnkɨnsiis haigɨnɨuwi ta mɨi aiir mɨriiyamɨn. ");
INSERT INTO iws_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Adɨn siya siir yɨnisɨmɨn siiramɨn pranaepranae bɨ naɨngwokwonanaeikɨn. Mɨ siya pɨ siirar mɨ kɨgnɨnkɨni digworaekwo whɨekakɨm sɨmiir kɨgɨrkakamɨn. ");
INSERT INTO iws_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mɨ yɨpɨkɨ Adi Komii siir yɨnisɨmɨn siiram naɨngwo tɨbmii kɨɨni, siya wɨ inɨgakar nwoyokiyokɨii ɨinokɨinokɨn. Mɨ yɨpɨkɨ siiram wakaeyokna karamae nwowiyɨn siya wɨ omwai waiyayokiyokɨi rani, ɨinokɨinokɨn. Nɨɨngaka. Adi Komii siya siirɨn wɨ ɨo prasae nwo rani. Mɨ siya siirɨn wɨ hɨriiyar nonkwonɨɨnwoɨmwɨɨrnɨnkɨn krɨpkaii. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farisi kamɨm Mosesni siyɨu komii siir napiyɨm, sɨmar wakae, iikam whɨekakɨm ɨni Jisɨs siiraramar yamɨm, sɨmiirɨn op siya baptais haigɨnɨuwam. Mɨ Jon siirɨn ɨni siya haiburɨn. ");
INSERT INTO iws_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Sɨmiirɨn Jisɨs siyar bɨ baptais haigɨnɨugɨn. Nɨɨngaka. Sɨmiirɨn kamɨm siir kɨgna mɨriiyɨm sɨma baptais haigɨnɨugɨm. ");
INSERT INTO iws_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Mɨ ɨiya Jisɨs siya hɨriinan wakaeyɨn, Farisi kamɨm sɨma bɨdi yɨnoknɨnkɨnɨm mɨ siya nu haɨmii Judia siir asi haiburgigɨn. Mɨ nu haɨmii Galili hɨriir asi swokɨ amkɨn. ");
INSERT INTO iws_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Mɨ ɨiya siya tɨ siyɨuɨn nu haɨmii Galiliya namiyɨn siirar nikɨ apamɨn mɨ siir kwoɨnɨn Adi Komii siya swokɨ hɨurworwokaigi, siyɨuɨn nu haɨmii Sameria namiyɨn siir naprɨokɨinamɨm. ");
INSERT INTO iws_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Mɨ siya omisɨm whɨrɨn nu haɨmii Sameria hɨranɨn siir yɨmbiyam. Tɨ omɨn siir inɨgɨn Saikakɨn. Tɨ omɨn ɨni nu maeyaua Jekopkɨ si hauuwa siir yɨnisɨm ɨiir Josepni numɨrɨm ɨni saiir kingiin hɨr nwowɨn. ");
INSERT INTO iws_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Mɨ tɨ aeyawɨeyɨn op sɨma kunaeiyɨn ta maeyau aiir nwowɨn, siirɨn Jekop siyar nopgikɨn. Mɨ Jisɨs siya pɨugɨ piyaokɨn mɨ siya tɨ aeyawɨeyɨn saɨka kingiin hɨr inɨ ɨdwo mɨ ta ɨiya ya nabɨebopwoka. ");
INSERT INTO iws_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mɨ Jisɨs siya hɨrar nikɨ ɨdwowɨn mɨ wig ɨra Sameria hɨrana ɨna yɨta op kunanakiyam, tɨ aeyawɨe ɨiir. Mɨ Jisɨs siya kɨmɨdiniya saiir boɨnki, kɨra kariirɨn op kuna hauugi, kara kwiyaeyam. ");
INSERT INTO iws_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Mɨ kamɨm siir kɨgna mɨriiyɨm yɨm ɨni om komiiya hɨriir yamɨm nae saɨnam. ");
INSERT INTO iws_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mɨ Jisɨs siya saiirɨn hɨriinan boɨnkiyɨn mɨ ta Samerian wiga ɨna yowarkɨi boɨna, ni kɨra Isrelan inkamkɨn mɨ ankara Samerian wiga mɨ kɨra kariiramɨn opam dimuam boɨnkɨn, kɨra kwiyaeyam, ha? Isrel sɨmiir iikamɨm mobmɨr mob mɨnɨm Samerian iikamɨm krɨma nae kwiyaeyɨm sɨmiirara bɨ nɨngigir ae kwiyaeikɨm. Sɨma ha naɨngwo tɨbmii kɨɨni wɨ Adi Komii siya pɨ boɨnisi yɨm mɨiyɨk rani. ");
INSERT INTO iws_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Mɨ Jisɨs siya saiir yai aka hɨnɨɨna yowarkɨi boɨn mɨ kɨra dimɨnɨm Adi Komii siya prɨihauuwiyɨm kɨriir mɨ kɨra kariir mɨ ɨnoknɨnkɨni tɨ opam kɨriiram srɨiyɨn mɨ kɨra kariiramɨn pɨ op mɨiyɨka iikam ɨmiir whɨnkɨnsiis haigɨnɨuwiya omwai Adi Komii saɨka waiyayokiyokɨiyam pɨ saiiram nwokɨ srɨiyɨm. ");
INSERT INTO iws_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mɨ ta wiga siir yai aka hɨnɨɨna yowarkɨi boɨn, inkam komii, kɨra two karamaeka mɨ tɨkɨ aeyawɨeyɨn siir opa kingiin kingiin nwomai rani. Mɨ kɨra ta op aiirɨn pɨ panɨɨn panɨɨna haii, iikam ɨmiir hauuwam sɨmiir whɨnkɨnsiis haigɨnɨuwam, omwai sɨma waiyayokiyokɨiyɨm, ha? ");
INSERT INTO iws_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tɨ aeyawɨeyɨn krɨmiir brougaeyɨn Jekop siyar hauugigɨn krɨmiirɨn mɨ siya mɨ siir yɨnisɨsɨm ɨkɨm yɨm sɨma siirar mɨ kwiyae namkɨm. Mɨ siir bulmakau sibsibɨm yɨm ɨriipɨ hɨriinan ta op aiirar mɨ kwiyaekɨm. Mɨ kɨra ha naɨngwowi, kɨra ɨni Jekop siir haiburɨn, ha? ");
INSERT INTO iws_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Mɨ Jisɨs siya saiir yai aka hɨnɨɨna yowarkɨi boɨn, iikamɨm ta op aiir kwiyaeyɨm, yɨm wɨ kwoɨnkar swokɨ haei. ");
INSERT INTO iws_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Mɨ yɨpɨkɨ kara hauuwi ta op aiir, yɨo wɨ kwoɨnkɨ haei rani. Nɨɨngaka. Mɨ taka opa kara hauuwana, siir whɨnkɨnsiis haigɨnɨuwam, ya wɨ sɨnkai rani, ya wɨ hɨriiyar nwoyokiyokɨikaeyami ɨinokɨinokɨn. ");
INSERT INTO iws_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mɨ ta wiga saeya ɨna swokɨ boɨnkiya siirɨn. Inkam komii, kɨra wara op hɨriinana kariir whauugi mɨ mhoɨiya kariir kwoɨnɨn wɨ haei karamae nwokɨ owɨm. Mɨ kara wɨ tɨriir swokɨ ɨt rani, op kunanakiyamɨn. ");
INSERT INTO iws_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Mɨ Jisɨs siya saiir boɨnki, kɨra kɨriir kam ɨiir tinɨ ɨkɨunaki. ");
INSERT INTO iws_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mɨ ta wiga siir yai aka hɨnɨɨna yowarkɨi boɨn, kara kam karamaeka. Mɨ Jisɨs siya saiir yai aka hɨnɨɨna yowarkai boɨn, kɨra kaimwowar boɨni, kɨra kam karamaeka. ");
INSERT INTO iws_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Bɨiya kɨriirɨn kamɨm ɨriiyara ikɨ onkwona mɨ wara kamɨn kɨnaka nwowɨn yɨo kɨriir kamkɨ kam tani. Ta kɨriir yaiya ɨni kaimwowar ywowa. ");
INSERT INTO iws_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mɨ wig saeya siir boɨnki, inkam komii, kara ɨni haɨnɨɨngɨ yɨnoknɨnkɨnkiya, kɨra profet inkamkɨn. ");
INSERT INTO iws_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Krɨmiir brougaeyɨm yɨm sɨma Adi Komii siir inɨg ɨiirɨn ɨrɨpa tɨ mhɨu ɨiir haɨngiriyɨu hainanikɨm. Mɨ wɨm kɨma Isrelan iikamɨm, wɨm kɨma ha boɨni, krɨma Adi Komii siir inɨg ɨiirɨn om komii Jerusalem hɨrarar hainan ɨski. ");
INSERT INTO iws_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Mɨ Jisɨs siya saiir yai aka hɨnɨɨna yowarkɨi boɨnki, wig, kɨra kariir yaiya kaimwo saiir dwoki. Ɨigwɨra saeya nɨmbini, krɨma Adi Komii siir inɨgɨn wɨ tɨ mhɨu ɨiir hainan tani mɨ wɨ om komii Jerusalem hɨr mɨ hainan tani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mɨ wɨm kɨma Samerian iikamɨm, wɨm kɨma dimɨnɨm kɨma kɨg karamae nwowiyɨm sɨmiiram hainanikɨm. Mɨ nɨm krɨma dimɨnɨm krɨma kɨgnɨnoknɨnkɨnɨm sɨmiiram hainanikɨm. Dimusi rani, Adi Komii siir mɨiya iikam nanmaiwarkainaeiya Juda iikam krɨmiir hɨriir nɨmbinika. ");
INSERT INTO iws_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mɨ ɨiya ta ɨi aeya nɨmbiyamana ɨni kingiin nwowa. Mɨ iikamɨm yɨpɨkɨ naɨngwo tɨbmii kɨɨngɨkɨɨnɨm mɨ Adi Komii krɨmiir Wanɨn siir naeyɨuɨn siya sɨmiir whɨnkɨnsiis haigɨnɨuwi mɨ sɨma siir inɨgɨ inɨg ɨiirɨn siyɨu mɨiyɨkɨ mɨiyɨk ɨiirar hainani mɨ Adi Komii siya tɨ hɨriinan iikamɨm siiram naɨngwo tɨbmii kɨɨniyɨm mɨ siir inɨg ɨiirgɨ ɨiir hainaniyɨm sɨmiiram naɨngwowikɨn. ");
INSERT INTO iws_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Adi Komii siya pɨu karamaekɨn, siya ɨni siir naeyɨuɨn siir hɨriinan ywowɨn. Mɨ yɨpɨkɨ siir inɨg ɨiir hainani, sɨma wɨ daɨngwo tɨbmii kɨɨn. Sɨma wɨ pɨu ara kɨpi hainan, sɨma sɨmiir mhɨi kwoɨnɨm warar hauu ɨuguski. ");
INSERT INTO iws_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mɨ wig saeya siir boɨn, kara bɨdi yɨnoknɨnkɨna Mesaia siya wɨ sɨpi nɨti, inkamɨn Adi Komii siya nɨmbingiyɨn krɨmiir whɨnkɨnsiis haigɨnɨuwam, sɨma dapiyɨn Krais. Mɨ ɨiya siya nɨti, siya krɨmiirɨn wɨ dimɨn kasakasa nowomwarkaiyɨu rani. ");
INSERT INTO iws_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Mɨ Jisɨs siya saiir yai aka hɨnɨɨna yowarkɨi boɨn, karaɨrgɨn, kraisɨn, tɨ kɨnakar boɨnɨn. ");
INSERT INTO iws_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Mɨ ɨiya siya saɨka nikɨ boɨnaiyɨn mɨ kamɨm siir kɨgna mɨriiyɨm ɨna yɨmbiniyɨm. Mɨ ɨiya sɨma hɨriinan kɨgɨm sɨma ɨni mouni hanɨɨna siinkaokiyɨm. Dimusi rani, siya ta wig anaka boɨnaigɨn. Mɨ siirɨn inkam nwɨrkɨ bɨ swokɨ boɨnkɨn hɨnɨɨn, kɨra dimu dimɨnɨm naɨngwowi? Mɨ kɨra saɨka dimuam boɨnkɨn? ");
INSERT INTO iws_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Mɨ ta wiga saiir op twowa ɨni hɨrar kwaiburgika. Mɨ saeya ɨna iwɨtama oma hɨriir. Mɨ saeya iikam ɨmiirɨn dimɨn taemɨnɨm siya boɨnɨm saiir sɨmiirar inɨ boɨnoudnɨnkɨnɨu. ");
INSERT INTO iws_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Mɨ saeya kɨmɨdiniya sɨmiir inɨ boɨnɨu, kɨma unkɨ ɨt, ɨkɨ inkamɨn dimɨn taemɨnɨm kara tɨrɨm bɨiya sɨmiir haknoudnɨnkɨnɨn, tari Krais siya piyamisi owɨn? ");
INSERT INTO iws_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Mɨ sɨma om hɨr haiburgigɨm mɨ sɨma ɨna yamɨm Jisɨs siir kɨgnakiyam. ");
INSERT INTO iws_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mɨ ɨiya ta wiga saeya om hɨrar nikɨ owa mɨ kamɨm siir kɨgna mɨriiyɨm sɨma naeyɨm siiram ha nonkwowɨm mɨ ɨna boɨnɨm, inkamɨn nowomwarkaiyɨuwiyɨn, kɨra nae tɨ ae. ");
INSERT INTO iws_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Mɨ siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨn, kara bɨdi yaeyɨn, naeyɨn kɨma nɨnoknɨnkɨn karamae nwowɨn siir. ");
INSERT INTO iws_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma, sɨma sɨmar yɨnsrɨi ansrɨina. Mɨ siiramɨn nae inkam nwɨrkɨ hainanikɨn, ha? ");
INSERT INTO iws_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Mɨ Jisɨs siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨn, kariir naeyɨn yɨo hɨnɨɨngɨn, kara tɨ inkamɨn kariir nɨkropkiyɨn kara siir kwoɨn ɨiirarar dap. Mɨ kara mɨiya siya nɨmbingiya kariir saiir dankabimbid dɨgi. ");
INSERT INTO iws_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Wɨm kɨma hɨnɨɨna boɨnikɨm, bwanɨm pɨ whiiya nwokii mɨ sasaeyɨm pɨ sasae wai hanɨɨngɨn nwokii. Mɨ kɨma pɨ haɨnii nɨngugu haii. Mɨ kara kɨmiirɨn pɨ hɨnɨɨna boɨnkii, kɨma ɨkɨ numɨran sasaeyɨm sɨmiir kɨgi, sɨma sasae wai bɨdi ywowɨm. Kɨma sɨmiirɨn hindara tɨ ɨnguguae. ");
INSERT INTO iws_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mɨ inkamɨn numɨran sasaeyɨm sɨmiir nɨngugu haiiyɨn, iikam nhɨrkɨm sɨm saɨnam yɨo ɨni tɨ inkamɨn, hɨnda tɨnda namiyɨn, ɨkɨ iikamɨm sɨmiir kwoɨn ɨmiir kiyaiyam ɨni siir hɨriinan ywowɨn. Mɨ sɨma ha sɨbgu wakaeyoknaei mɨ wa nwokɨ aɨngwo tɨbmii kɨɨnɨm. Mɨ ɨinokɨinokɨn sɨma wɨ omwaiyar nwokɨ waiyayokiyokɨikaeyamɨm. Mɨ inkamɨn tɨ sasae ɨmiir nɨnkɨnɨn mɨ inkamɨn tɨ sasaeyɨm wai nwowiyɨm sɨmiir nɨngugu haiiyɨn, sowa nwɨsaɨrarɨn pɨ maɨrgɨmaɨrga nwoswowi. Mɨ yɨpɨkɨ Adi Komii siir yai aiir boɨnmɨmauuwiyɨm mɨ yɨpɨkɨ iikamɨm sɨmiir kwoɨn ɨmiir kiyaiiyɨm, Adi Komii siir yai aiir wakaeyɨm, yɨm ɨni tɨ inkam nwɨso sowiir hɨriinan ywowo. ");
INSERT INTO iws_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ta yaiya ya kaimwowaɨrga. Inkam nwɨrɨn yɨo hindɨra nɨiyoknɨnkɨnami mɨ nwɨrɨn yɨo wɨ hindɨra nɨngugu haiyami. ");
INSERT INTO iws_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ta kara nɨkropkiya kɨmiirɨn ya numɨrɨm inkam nhɨrkɨm nɨiyoknɨnkɨnɨm sɨmiir sasae ɨmiir nɨngugu hainan ywowa. Tɨ numɨrɨm yɨm inkam nhɨrkɨm nɨiyoknɨnkɨnkɨm. Ya ɨni bɨigɨ bɨi sɨma boɨnmɨmauuwa kariir yai wɨn kɨbiya ɨkɨ iikam nhɨrɨm sɨmiir, ɨni saiir hɨriinan ywowa. Mɨ wɨm kɨma tɨ yai wɨn kɨbi kɨbiyɨm ɨkɨ iikamɨm bɨiya naɨngwo tɨbmiiyɨm wɨ sɨmiir swokɨ boɨnmɨmauuwami. ");
INSERT INTO iws_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mɨ mhoɨiya nu haɨmii Sameria hɨran iikamɨm sɨma Jisɨs siiramɨn ɨna yaɨngwo tɨbmiiyɨm. Whɨsarii rani, sɨma ta wiga saiir yai aiir wakaekɨm. Saeya hɨnɨɨna boɨnka, siya dimɨn taemɨnɨm bɨiya bɨiya kara tɨrɨm mɨ tariinan mɨ tɨr ɨkɨm, siya sɨmiirɨn ɨni hɨriiyar haknoudnɨnkɨn dɨgiyɨn. ");
INSERT INTO iws_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Mɨ iikam whɨekakɨm om Saika nu haɨmii Sameria hɨranɨm sɨma Jisɨs siiram ha nɨtɨm mɨ sɨma kɨmɨdiniya siir srɨi siya sɨmaka hɨr mɨ owɨm. Mɨ Jisɨs siya sɨma ɨiyɨm kwɨsa ywo. ");
INSERT INTO iws_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mɨ iikam whɨekakɨm siir yai aiir wakaeyɨm sɨma ɨna yaɨngwo tɨbmii kɨɨnɨm. Dimusi rani, sɨma siirgɨsiir yaiyar wakaekɨm. ");
INSERT INTO iws_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mɨ sɨma ta wig aiir boɨn, tariinanɨn krɨma siir yai aiiramɨn bɨdi yaɨngwo tɨbmii kɨɨngiyɨm. Krɨma yaiya kɨra boɨna krɨmiir saiir bɨ naɨngwo tɨbmii kɨɨngɨm. Nɨɨngaka. Krɨma asi naɨngwo tɨbmii kɨɨni krɨma krɨmiir wɨɨngɨ wɨɨngar wakaekɨm. Mɨ krɨma bɨdi yɨnoknɨnkɨnkiyɨm siya Kraiskɨn, nuan iikam whɨekakɨm krɨmiir nanmaiwarkainaɨn inkamɨn siya. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jisɨs siya hapaiirɨn ɨiyo kwɨsa ywo. Mɨ mhoɨiya siya hɨr haiburgigɨn mɨ ɨni nu haɨmii Galili hɨriiyar swokɨ amɨn. ");
INSERT INTO iws_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jisɨs siyarɨn, hɨnɨɨna boɨnkɨn, siir oman iikamɨm sɨma profet inkamɨn siirɨn ha bɨ naɨngwowikɨm siya inkam komiigɨn mɨ inɨgakɨn. Nɨɨngaka. Sɨma hɨnɨɨna bɨ naɨngwowikɨm. ");
INSERT INTO iws_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Mɨ ɨiya Jisɨs siya siir oma hɨriir swokɨ amɨn mɨ Galili hɨran iikamɨm sɨma siiramɨn ɨni maɨrgɨmaɨrga ywowɨnɨm. Dimusi rani, dimɨn taemɨnɨm siya tɨrɨm Judami ɨi komiiya wou nikwo aeiya Pasova om komii Jerusalem hɨr sɨma bɨdi kɨgmɨmɨkɨm. ");
INSERT INTO iws_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Mɨ Jisɨs siya om Kena nu haɨmii Galili hɨriir swokɨ amɨn, omɨn opa siya tɨrkiya wain nɨkpɨtmaigiya siir. Mɨ om Kapaneam hɨr nwowɨn gavmani inkam komii nwɨrɨn siir yɨnisɨm yɨnkamiyɨnɨn makakɨn. ");
INSERT INTO iws_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mɨ siya wakae Jisɨs siya nu Juda hɨr bɨdi haiburgigɨn mɨ siya nu haɨmii Galili tɨrii nɨtam tari. Mɨ siya ha namɨn Jisɨs siiram mɨ kɨmɨdiniya siir inɨ boɨnɨu, saɨka namɨm om Kapaneam hɨriir siir yɨnisɨm ɨiir ninɨ haiswonɨskiiyɨuwɨm. Siir yɨnisɨmɨn ɨni nao kingiin nwowɨn. ");
INSERT INTO iws_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Mɨ Jisɨs siya siir boɨnki mɨ kɨma, kara dimɨn kɨrɨe komii komii tɨr karamae nwowi mɨ kɨma wɨ kariiram naɨngwo tɨbmii kɨɨn tani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mɨ tɨ inkam komiiyɨn siya hɨnɨɨna boɨnki, Bɨiyan Inkam Komii, kɨra kanakar wɨt, kariir yɨnisɨm ɨiir kɨgnakiyam. Yɨnisɨm ɨeya naonamɨn yɨo mɨiyɨk rani. ");
INSERT INTO iws_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Mɨ Jisɨs siya siirɨn ɨna yɨkropkiyɨn, kɨra tɨ am kɨriir yɨnisɨmɨn wɨ omwaiyar swokɨ waiyaei. Mɨ tɨ inkamɨn siya Jisɨs siir yai aiir wakaeyɨn mɨ ɨna yamɨn. ");
INSERT INTO iws_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mɨ ɨiya siya ha swokɨ haiyɨug apnamɨn mɨ kamɨm siir mɨriiyɨm, sɨma siirɨn siyɨu hɨr yapiyɨskaiwɨn. Mɨ sɨma boɨn siirɨn, kɨriir yɨnisɨmɨn ɨni wadɨeyar swokɨ owɨn. ");
INSERT INTO iws_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Mɨ siya kɨmɨdiniya sɨmiir srɨi, pakɨ hɨnɨɨn ɨiya wadɨe sae nwokikɨn kariir yɨnisɨmɨn, ha? Mɨ sɨma siir boɨn, siir pɨu huua kɨniya ii nabɨe bopwo dɨgika. ");
INSERT INTO iws_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Mɨ ta yaiya sɨma boɨna siir, saiir mhoɨiya mɨ siir adɨn ɨna swokɨ aɨngwokiyɨn yaiya Jisɨs siya boɨna ii nabɨe bopwo hɨnɨɨn kɨriir yɨnisɨmɨn wɨ omwaiyar swokɨ waiyaei. Mɨ siya mɨ siir yɨnwig ɨma sɨmaniiyɨn ɨni hɨriiyar yaɨngwo tɨbmii kɨɨn swokiyɨm Jisɨs siiram. ");
INSERT INTO iws_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Mɨ ya tariigɨna ya dimɨn kɨrɨe komii kwɨsaka aeya, Jisɨs siya tɨra iikam ɨmiir nɨisiimauuam, ɨiya siya nu haɨmii Judia hɨr haiburgigɨn mɨ ha napnamɨn nu haɨmii Galiliya hɨriir. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Mɨ tɨriigɨnɨm yɨm dɨg nwokiyɨm mɨ Juda sɨmiir ɨi komii kwɨra nae ɨrɨpa haɨngiriyɨu aeiya ɨna yɨmbiyama. Mɨ Jisɨs siya asi swokɨ amkɨn om komii Jerusalem hɨriirɨn. ");
INSERT INTO iws_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Mɨ om komii Jerusalem hɨrɨn anowɨn napnɨnopkainamiyɨn iikamkɨm sɨm kiyainɨnopkainamiyɨn sibsib siir kingiin hɨrɨn whɨinausɨm kwɨra ɨni hɨr nwowa. Mɨ iikamɨm sɨma Hibru sɨmiir yaigɨna hɨnɨɨna dapikɨm Betesda. Mɨ ta whɨinausɨma saiir kingiin hɨrɨn ɨuruwɨm ɨriiyara nwowi iikamkɨm sɨm nɨdwowam. ");
INSERT INTO iws_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mɨ iikam whɨekakɨm makak makakɨm ɨni hɨrar nɨnɨdwodwokaowɨm. Iikamɨm nhwokwɨsaeyɨm mɨ iikamɨm ɨgrɨb ɨɨndɨb nɨimwowaeyao mɨnkɨn kɨpiiyɨm mɨ iikamɨm kɨu mɨn naonɨnsɨmsɨrɨrɨu ɨkɨm. Sɨma mɨnam nɨnɨdwodwokaowi Adi Komii siir paekwosɨmɨn siya tɨrkiyɨm op aiirɨn imɨgak nwokiyam. ");
INSERT INTO iws_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Mɨ ɨi nhɨrɨm Adi Komii siir paekwosɨmɨn ɨkɨ siya nɨuunaiiniiyɨm mɨ ta whɨinausɨma pɨ imɨg iga siya naunɨ ɨnɨunii. Mɨ inkamɨn ɨkɨ bɨigɨ bɨi natmainamiyɨn ta opa Adi Komii siir paekwosɨm ɨeya tɨriya mɨ ta siir ma pa dɨgi. ");
INSERT INTO iws_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mɨ inkam nwɨrɨn ɨuru hɨr nɨdwowɨn bɨewiyɨm makɨ siya niiyɨm kam nwɨr ɨuur ɨriiyar whoɨmgɨm (38). ");
INSERT INTO iws_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Mɨ Jisɨs siya tɨ inkamɨn siir kɨgɨn siya hɨr whɨnɨn mɨ siya ɨna yɨnoknɨnkɨnkiyɨn siya makɨ kwokiyaeya bɨ niigɨn. Mɨ Jisɨs siya siirɨn hɨnɨɨna boɨnki, kɨra hɨnɨɨna naɨngwowi kɨra wadɨe swokɨ okiyɨm, aniya? ");
INSERT INTO iws_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mɨ tɨ inkamɨn makɨ niinanaekaigiyɨn siya siir yai aka hɨnɨɨna yowarkɨi boɨn, Bɨiyan Inkam Komii, ɨiya Adi Komii siir paekwosɨm ɨeya tɨrkiiyɨm ta op aiirɨn mɨ kariirɨn inkamkɨ haidunamam whaowae ta whɨinausɨma saiir aowa hɨriirɨn. Mɨ kariirɨn pɨ nhɨrkɨm swokɨ haiburi, bɨi pɨ sɨma natmaidunami. ");
INSERT INTO iws_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Mɨ Jisɨs siya siir boɨnki, kɨra dɨnsiin okwoki mɨ kɨriir nɨbmɨr aiir hai mɨpa dapnam. ");
INSERT INTO iws_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Mɨ bɨri kɨmɨmɨnkikɨn, tɨ inkamɨn siir ma ɨna dɨgiya mɨ siya ɨni siir nɨbmɨr aiirar yɨnsiin hainamɨn. Taka ɨiya ya Judami ɨi komiiya pɨu siisiya Sabat, ɨiya dimɨn taemɨn sɨma tɨr karamae nwowiya saeya. ");
INSERT INTO iws_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Mɨ siya nɨbmɨr ha hainamɨn mɨ gavmani inkamɨm sɨma tɨ inkamɨn Jisɨs siya nwowaigɨnɨugiyɨn wadɨe siir srɨiwɨn, tapa Judami ɨi komiiya pɨu siisiya Sabat, dimɨn taemɨn tɨr karam nwowiya saeya mɨ kɨra wara kɨriir nɨbmɨra saiir dimusi hainanikɨn. Moses siir siyɨuɨn hɨriinanɨn siirɨn igbidgak bɨdi ywowɨn. ");
INSERT INTO iws_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Mɨ siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨn, inkamɨn wadɨe kariir nwowaigɨnɨugiyɨn kariirɨn siya nokmwɨn haigikɨn ta kariir nɨbmɨr aiir nɨnsiin hainaniyamɨn. ");
INSERT INTO iws_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Mɨ sɨma kɨmɨdiniya tɨ inkam ɨiir swokɨ kwasrɨi, yɨpɨkɨn kɨriir boɨnkiyɨn ta kɨriir nɨbmɨr aiir hainaniyamɨn, ha? ");
INSERT INTO iws_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mɨ tɨ inkamɨn wadɨe Jisɨs siya nwowaigɨnɨugiyɨn siya bɨ nɨnoknɨnkɨnkikɨn tɨ inkam ɨiirɨn. Dimusi rani, Jisɨs siya siir bɨdi haiburgigɨn mɨ siya panɨɨnsi yɨnoknɨnkɨnkisi, iikam kasakɨwaeyao hɨr nokwowɨm. ");
INSERT INTO iws_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mɨ mhoɨiya Jisɨs siya siirɨn omaka Adi Komii siir inɨg hainaniya saiir hɨr kɨgɨn mɨ siya kɨmɨdiniya siir boɨn, wakae, kɨra mhoɨiya wɨ dimɨn whɨr kɨpi swokɨ tɨr. Nɨɨngaka. Kɨra hɨriinan tɨri mɨ ta hɨka mhoɨiya kɨra haii, ya wɨ hɨka bɨiya kɨra haiya wɨ saiir haiburi. ");
INSERT INTO iws_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mɨ tɨ inkamɨn ha namɨn siya kɨmɨdiniya Juda sɨmiir inkam komii komiiyɨm sɨmiir inɨ boɨnɨu, tɨ inkamɨn wadɨe kariir nwowaigɨnɨugiyɨn yɨo Jisɨs siyaɨrgɨn. ");
INSERT INTO iws_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mɨ tɨ Isrelmi inkam komii komiiyɨm sɨma Jisɨs siirɨn siyɨu biyɨe asi tɨrkɨm. Dimusi rani, iikamɨm makɨ niiyɨm sɨmiirɨn siya Juda sɨmiir ɨi komiiya pɨu siisiya Sabat, dimɨn taemɨn whɨr tɨr karamae sɨma nwowiya siya saiir haiswonɨmnɨskɨigɨn. ");
INSERT INTO iws_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Mɨ Jisɨs siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨn, kariir Adɨn siya ɨinokɨinokɨn hɨriiyar mɨriigɨn. Mɨ an kara ɨriipɨ hɨriinan asi mɨ mɨrii. ");
INSERT INTO iws_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Mɨ ta yai hɨriinana Jisɨs siya boɨna mɨ Isrel sɨmiir bɨiyan inkam komii komiiyɨm siir nɨsomaowam asi tɨrkɨm. Dimusi rani, tɨ makak iikamɨm siya haiswonɨmnɨskɨiyɨm Judami ɨi komiiya pɨu siisiya Sabat, dimɨn taemɨn tɨr karamae nwowiya sasa rani. Nɨɨngaka. Sɨma siirɨn ɨo mɨnsi nwokɨm ta siya boɨna hɨnɨɨn, Adi Komiiyɨn kariir Adgɨn. Mɨ siya ɨni inkam komii siya siyar swokɨ onaɨn Adi Komii siir hɨriinanɨn. Mɨ siirɨn saiirsi nɨsomaowam tɨrkɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Mɨ Jisɨs siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨn, kara kɨmiirɨn yaimwowar boɨni, kara siir yɨnisɨmɨn dimɨn whɨrɨn kariir kwoɨn aɨrgɨ bɨ swokɨ aɨngwo tɨrkɨn. Nɨɨngaka. Kara dimɨnɨm kara kɨgmɨmɨkɨm kariir Adɨn siyar tɨrɨm kara sɨmiirarar tɨri. ");
INSERT INTO iws_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Adi Komii siya kariiramɨn nhami nhami bɨ naɨngwokwowikɨn mɨ siya digworaekwo whɨekakɨm siya mɨriiyɨm kariir asi nɨisiimauugɨm. Mɨ digworaekwowɨm siya nɨisiimauuwi wɨ digworaekwowɨm tɨ kara tɨrɨm wɨ sɨmiir haiburi. Mɨ tɨ dimɨn taemɨnɨm kɨma sɨmiir kɨgi mɨ kɨma wɨ nanaa pranae kɨn tani. ");
INSERT INTO iws_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Adi Komii siya hɨdnɨnsiin ɨdwowiyɨm iikamɨm naokaowɨm omwai swokɨ waiyaɨm siir hɨriinan. Mɨ kara siir yɨnisɨmɨn iikamɨm yɨpɨkɨm kara hauuwam tɨriyɨm kwoɨn mɨiyɨk yɨo kariirar kwoɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Mɨ kariir Adɨn iikam ɨmiirɨn siyar bɨ hɨdikɨn. Nɨɨngaka. Mɨ siir kɨrɨeya siir yɨnisɨmɨn kariir bɨdi hauuwɨn mɨ siirɨn kara bɨdi kisɨna owɨn mɨ iikam ɨmiirɨn wɨ karar hɨdi. ");
INSERT INTO iws_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Mɨ iikam whɨekakɨm wɨ kariir inɨg ɨiir asi hainani, kariir Adɨn siir inɨg ɨiir sɨma hainana saiir hɨriinan. Mɨ yɨpɨkɨn kariir inɨg ɨiir hainan karamae nwowi siir yɨnisɨmɨn kɨma tɨra saiir hɨriinan mɨ sɨma kariir Adɨn yɨpɨkɨn kariir nɨkropkiyɨn wɨ siir inɨg ɨiir mɨ hainan tani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Kara Jisɨskɨn kara kɨmiirɨn yaimwowar boɨnkii mɨ yɨpɨkɨn kariir yai aiir wakaeyoknaei mɨ ha naɨngwo tɨbmii kɨɨni mɨ sɨma wɨ kariir Adɨn yɨpɨkɨn kariir nɨkropkiyɨn wɨ siir yai aiir warar mɨ wakaeyokna aɨngwo tɨbmii kɨɨni. Mɨ yɨpɨkɨn kariir nɨkropkiyɨn siya wɨ siir naeyɨu ɨiir hauu haigɨnɨuwi sɨmiirɨn mɨ kɨma wɨ inɨgak nwoyokiyokɨikaeyami. Adi Komii siya wɨ sɨmiir wara hɨd rani mɨ sɨma wɨ nao rani. Nɨɨngaka. Mɨ sɨma wɨ yaeya kwoɨn wɨn haii omwai waiyayokiyokɨikaeyamɨm. ");
INSERT INTO iws_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kara kɨmiirɨn yaimwowar boɨnkii, ɨiya Adi Komii siya nɨmbina iikamɨm naokaoɨm sɨmiiram ya bɨdi yɨmbiniya. Mɨ sɨma wɨ kariir yai aiirar wakaekii, Adi Komii siir yɨnisɨmɨn. Mɨ sɨma wɨ yaeya kwoɨn wɨn haii omwai waiyayokiyokɨigiyamiyɨn. ");
INSERT INTO iws_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Adi Komii siya bɨ naowikɨn, siya kwoɨnbudɨn omwai waiyayokiyokɨiyɨn siir bwamkɨbwamɨn siyaɨrgɨn. Mɨ tɨ hɨriinan siyɨuɨn siya kariirɨn digworaekwo whɨekakɨm omwai waiyayokiyokɨiyɨm sɨmiir bwamkɨ bwam ɨiir asi mɨ tɨrkikɨn. ");
INSERT INTO iws_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Adi Komii siya ha boɨnkɨn, kara siir yɨnisɨmkɨn mɨ iikam ɨmiirɨn wɨ kara hɨdi. Dimusi rani, kara ɨni inkamnan ywowɨn. Mɨ kara sɨmiir kwoɨnɨm ɨna nɨnoknɨnkɨnɨn. ");
INSERT INTO iws_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mɨ kɨma wɨ ta saiirsi kɨpi nanaaki. Mɨ ɨiya saeya nɨmbiyami mɨ ɨkɨ iikamɨm nikɨ aokaoɨm mɨ sɨmiir ɨenau hɨr nwokaiyɨm sɨma wɨ kariir yai aiir wakaekii, Adi Komii siir yɨnisɨmɨn. ");
INSERT INTO iws_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Mɨ sɨma wɨ ɨe hɨrankar nɨnsiin ɨdwonani. Mɨ yɨpɨkɨ siyɨu mɨiyɨk tɨrɨm yɨm wɨ omwaiyar waiyayokiyokɨigiyami. Mɨ yɨpɨkɨ siyɨu biyɨe tɨrɨm ɨiya sɨma nɨnsiin ɨdwowi wɨ yaigak nwowi. Mɨ sɨma wɨ paeya nami mɨ ɨinokɨinokɨn sɨmiirɨn wɨ hɨriiyar nɨunanaei. ");
INSERT INTO iws_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Kara dimɨn whɨrɨn kariir kwoɨn aɨrgɨ bɨ naɨngwo mɨriigɨn. Nɨɨngaka. Dimɨn taemɨnɨm kara wakaeyɨm Adi Komii krɨmiir Wanɨn siya boɨnɨm kara sɨmiirarar tɨri mɨ kara iikam ɨmiirɨn asi hɨdi. Mɨ kara iikam ɨmiirɨn wadɨeyar sɨbgu hɨdi. Dimusi rani, kara kariir kwoɨn ara naɨngwo dirɨraerar tani. Kara Adi Komii siir kwoɨn ɨiirar napi yɨpɨkɨn kariir nɨkrop ɨuungiyɨn nua tɨriir. ");
INSERT INTO iws_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Mɨ tɨ yaiyɨm kariir kwoɨnkar prɨinaɨngwo boɨnkɨswo mɨ kɨma wɨ ha di nɨnoknɨnkɨni tɨ yaiyɨm kara boɨnɨm kaimwokɨ piyamisi owɨm, iyɨe? Kara hindara prɨiboɨni. ");
INSERT INTO iws_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Mɨ inkam nwɨrɨn yɨo ɨna mɨ owɨn yɨo siya Jonkɨn siirɨn Adi Komii siya nɨmbingikɨn, kariir yaiya saiir sɨbgu boɨnmɨmauuwam. Kara bɨdi yɨnoknɨnkɨnɨn yaiyɨm siya boɨnmɨmauuwɨm kariirɨm yɨm kaimwowaɨrgɨm. ");
INSERT INTO iws_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mɨ wɨm kɨma kam nhɨrɨm kɨmɨdiniya Jon siiram yɨkropki mɨ tɨ inkamɨn siya boɨnkiyɨn sɨmiir yɨo karaɨrgɨn. ");
INSERT INTO iws_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kara kamɨm kariir yai aiir nanaaknɨnki haigɨnɨuwɨm sɨmiirɨn yai karamaeka. Nɨɨngakɨ. Nɨɨngaka. Mɨ tɨ digworaekwowɨm tɨ kara boɨnmɨmauuwɨm kɨmiir, kɨma sɨmiirɨn wɨ nwokɨ sɨbgu ɨnoknɨnkɨnɨm. Mɨ kɨma wɨ kariir yai aiirɨm nwokɨ wakaeyokna aɨngwo tɨbmii kɨɨnɨm. Mɨ kɨmiirɨn wɨ Adi Komii siya nanmaiwarkainaei. ");
INSERT INTO iws_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon siya ɨni pae nɨuyanan ywowɨn kɨmiir nɨuya haigɨnɨuwam. Mɨ Adi Komii siir dimɨn taemɨnɨm sɨmiir nɨisiimauuwam. Mɨ ta ɨiya siya omwaiyar nikɨ waiyaɨn, kɨma siiramɨn nhami nhami bɨ naɨngwo tɨbmii kɨɨngɨm. ");
INSERT INTO iws_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Dimɨn nhɨrɨm ɨni ta yaiya Jon siya boɨna kariir ɨni saiir haiburɨm ya hɨnɨɨnga. Mɨ dimɨn mɨiyɨk mɨiyɨkɨm Adi Komii siya boɨnkiyɨm kara tɨram yɨm iikam kɨmiir nanaaknɨnkii haigɨnɨugɨm kariirɨn hɨnɨɨn, kariirɨn Adi Komii siya nɨkropkikɨn. ");
INSERT INTO iws_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Kariirɨn Adi Komii siyar nɨkropkikɨn mɨ kariirɨn siya boɨnɨnkɨigikɨn mɨ siyar mɨ anaaknɨnkii haigɨnɨugikɨn. Mɨ wɨm kɨma siir yai aiir bɨ wakaekɨm mɨ siir whwonkam ɨiir bɨ kɨgɨm. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Mɨ siir yaiya kɨmiir kwoɨnau bɨ haigi nonkworɨnuga. Nɨɨngaka. Dimusi rani, kɨma kariir yai aiirɨm bɨ naɨngwo tɨbmii kɨɨngɨm, kara tɨ inkamɨn Adi Komii siya nɨkrop ɨuungikɨn. ");
INSERT INTO iws_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Wɨm kɨma Yokwo Komii saiir yaiyɨm sɨmiirɨn ha sɨbgu mwaɨnikɨm. Dimusi rani, kɨma saiir sɨbgu nɨnoknɨnkɨnam mɨ saiir naɨngwo tɨbmii kɨɨnam tɨri. Mɨ kɨmiirɨn wɨ Adi Komii siya nwokɨ hauuwɨm kwoɨn wɨnɨn omwai waiyayokiyokɨigiyamiyɨn. Mɨ wara mɨiyɨm kɨma mwaɨnkɨgmɨmɨkɨm yɨm kariir yai ɨmaɨrgɨm. Mɨ wɨm kɨma hɨnɨɨnam naɨngwo mwananaei, Adi Komii siir mɨiyɨm kɨmiirɨn wɨ omwai sɨmar nwokɨ waiyayokiyokɨi haigɨnɨuwɨm. Mɨ wara mɨiyɨm kɨma mwan kɨgmɨmɨkɨm yɨm kariir mɨigɨm. ");
INSERT INTO iws_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Mɨ wɨm kɨma kariirɨm naɨngwo tɨbmii kɨɨnɨm pɨ boriisopi, kwoɨn wɨnɨn omwai waiyayokiyokɨiiyɨn kara kɨmiir hauuwɨm. ");
INSERT INTO iws_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Kara pɨ boriisopi ɨkɨ iikamɨm kariir inɨg ɨiir hainan praprasɨm. Nɨɨngaka. Ya tariigɨna ya dimɨn komii rani. ");
INSERT INTO iws_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mɨ kara kɨmiirɨn ɨna nɨnoknɨnkɨnɨn kɨmiir kwoɨnɨm Adi Komii siirɨm naɨngwo hɨrɨrɨu kɨɨn tani. ");
INSERT INTO iws_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","An kara kariir Adɨn siir inɨgni nɨtkɨn mɨ ta kara nɨta ya Adi Komii siya nɨtni hanɨɨnaka tɨsi kara nɨtɨskiyɨn. Mɨ wɨm kɨma kariir yai aiir bɨ naɨngwo tɨbmii kɨɨngɨm. Mɨ wɨm kɨma sɨmiirɨn ɨni yɨmiiyɨuwɨm. Mɨ inkam nwɨrkɨ nɨtkɨswo mɨ siya siir yai ɨmiir ninɨ boɨnmɨmauuniyɨm mɨ wɨm kɨma siir yai ɨmiirɨn wa pɨ wakaeyɨn mɨ kariirɨn iyɨe? ");
INSERT INTO iws_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mɨ kɨma kariir yai aiiramɨn wɨ panɨɨna naɨngwo tɨbmii kɨɨni, ha? Kɨma wɨ dɨg nwo rani. Mɨ kɨma, kɨma kɨmar ninan hainanamar tɨri mɨ kɨmiir inɨgɨm Adi Komii siya hainanɨm pɨ boriisopi. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kɨma ha kɨpi naɨngwo kɨmiirɨn kara wɨ kariir Adɨn siir boɨnmauuwi, kɨmiir boɨnwokiyopnatkaigiyɨm. Nɨɨngaka. Mɨ Mosesɨn yɨpɨkɨn naɨngwo tɨbmii komiigak kɨma nwowiyɨn wɨm kɨma ha naɨngwowi kɨmiirɨn wɨ siyar whɨnkɨnsiis haigɨnɨuwi. Mɨ Adi Komii siya kɨmiirɨn wɨ dimɨn whɨrkɨ kɨmbu karamae saiirsi nwokɨ ɨkɨuwɨm. Kɨmiirɨn wɨ siyar boɨnmauuwi kariir Adɨn siya boɨnwokiyopnatkaigiyamɨn. ");
INSERT INTO iws_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mɨ kɨma Moses siir yai ɨmiiram naɨngwo tɨbmii kɨɨni, kɨma tɨra saiir hɨriinan mɨ kɨma kariir yai aiiramɨn wa mɨ aɨngwo tɨbmii kɨɨni. Dimusi rani, yaiyɨm Yokwo Komii hɨr nwowɨm kariirɨm siyar wɨnboɨnkiyɨm mɨ kɨma sɨmiiram bɨ naɨngwo tɨbmii kɨɨngɨm. ");
INSERT INTO iws_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mɨ tɨ yaiyɨm Moses siya wɨnboɨnkiyɨm kɨma sɨmiiram naɨngwo tɨbmii kɨɨn karam nwowi mɨ kɨma kariir yai ɨmiiramɨn wɨ panɨɨna naɨngwo tɨbmii kɨɨni, ha? Yɨ siyɨu karamaeka. Nɨɨngaka. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Mɨ mhoɨiya Jisɨs siya tɨ yaiyɨm ha boɨndɨgiyɨm mɨ siya ɨna iyɨkɨdamɨn Galili whɨigbida hɨriir, saiir inɨg whɨrɨn sɨma dapiyɨn ta whɨi aiirɨn whɨi komii Taibiriaska. ");
INSERT INTO iws_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mɨ iikam whɨekakɨm sɨma ɨni Jisɨs siir mhoɨiyar sɨdkaenamɨm. Dimusi rani, sɨma dimɨn kɨrɨe komii komii kasa bɨ kɨgɨm iikam makak makakɨm siya nɨnɨmnɨskiiyɨm. Mɨ sɨma siir mhoɨiya asi sɨdkaenamkɨm. ");
INSERT INTO iws_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Mɨ Jisɨs siya mhɨuisɨm whɨrɨn siir iiyam. Mɨ siya kɨmɨdiniya siir kamɨm siir kɨgna mɨriiyɨn sɨmakar inɨ ii ɨdwoɨu. ");
INSERT INTO iws_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Mɨ Juda sɨmiir ɨi komiiya wou nikwo aeiya Pasova ɨni kingiin nwowa. ");
INSERT INTO iws_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Mɨ Jisɨs siya ha niyaeyok kaokiyɨn mɨ siyar kɨgwɨn, iikam isid komiiyɨn nɨtɨn siiram. Mɨ siya Pilip siir boɨnki, krɨma bretɨm pɨ papi haii tɨ iikam ɨma naeyamɨn, ha? ");
INSERT INTO iws_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Mɨ Jisɨs siya Pilip siirɨn hɨriinan boɨnkiyɨn mɨ yɨo siyarɨn bɨdi yonkwokiyɨn siyɨuɨn pɨ siya tɨri. Siya Pilip siirɨn mɨnam kɨnankɨugɨn, siir kwoɨnɨn pɨ panɨɨna namisi aɨngwokii. ");
INSERT INTO iws_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Mɨ Pilip siya siir yai aka hɨnɨɨna yowarkɨi boɨn mɨ krɨma bretɨm K200.00 saɨni. Mɨ tɨ hɨriinan iikam isid komiiyɨn krɨma sɨmiirɨn haɨmii haɨmiiya hauuwɨm pɨ dɨgɨ dɨg nwo rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Mɨ siir kɨgna mɨrii inkam nwɨrɨn, Endru nɨkɨuwiyɨn Saimon Pitani nomousɨmɨn, siya Jisɨs siirɨn hɨnɨɨna boɨn, ");
INSERT INTO iws_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","whranisɨm nwɨrɨn tɨr nwowɨn, siya bret baliyɨm ɨriiyara nwowi mɨ anasuwo whɨsa mɨ owi. Mɨ tɨ hɨriinan bret ɨriiyarɨuwam mɨ anasu whɨsuwa ɨko, tɨ hɨriinan iikam isid komiiyɨn pɨ dɨg swokɨ o mɨmɨn tani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Mɨ Jisɨs siya sɨmiir boɨnki, kɨma sɨmiirɨn nab nab dokmwɨn ɨdwo. Mɨ ta maeyaua sɨma nɨdwowa ya kokaka. Mɨ tɨ 5,000 kamɨm ɨni ta maeyaua kokaka ɨni saiirar prɨigrɨnkɨn ɨdwonamɨm. Sɨma wigyɨnɨm sɨmiir warar bɨ mwaɨngɨm. ");
INSERT INTO iws_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Mɨ sɨma ha grɨnkɨn ɨdwokiyɨm mɨ Jisɨs siya tɨ bret ɨriiyarɨm ha haigiyɨn mɨ siya ɨna boɨn wadɨekiyɨn Adi Komii siir. Mɨ mhoɨiya siya ɨna yɨinɨbɨmbɨɨr hauugiyɨm kamɨm siir kɨgna mɨriiyɨm sɨmiir mɨ tɨ bret haɨmiiyɨm sɨmiirɨn kɨmɨdiniya sɨma yap hauuwam iikam ɨmiir sɨma naeyam. Mɨ mhoɨiya siya anasuwo ha mɨ haiyɨn, ɨna mɨ ɨnoop ɨinɨspamspak hauugiyɨn kamɨm siir kɨgna mɨriiyɨm sɨmiir, bret ɨmiir siya nikɨ tɨrkiya saiir hɨriinan. Mɨ iikam ɨmiirɨn ha nonkwokwo hauunamɨm mɨ sɨma ɨni sɨmiir kwoɨnkar prɨigrɨnkɨn ɨdwo aenamɨm. ");
INSERT INTO iws_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Mɨ mhoɨiya sɨmiir mhɨiyɨm dɨg ha nwokiyɨm mɨ Jisɨs siya siir kɨgna mɨriiyɨm kamɨm sɨmiir boɨnki, wara nae haɨmii haɨmiiyɨm sɨma naepɨpɨru okiyɨm tɨ swokɨ tauhaigɨnam ɨrɨpa. ");
INSERT INTO iws_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Mɨ ta siya boɨnkiya saiir mhoɨiya, nae haɨmii haɨmiiyɨm sɨmiir swokɨ taugɨn haiyam mɨrisɨm kwɨrkɨ bɨ swokɨ okikɨn ɨni hɨriiyar taugɨn haiswokiyɨm mɨ sɨma sɨmiirɨn nɨb komii komiiyɨm ɨuur ɨsa tauhaigi. Mɨ tɨ nɨb komii komii ɨuur ɨswo ɨni yaigɨyaiga yakɨ ɨtkɨkɨniyɨm tɨ nae haɨmii haɨmiiyɨm sɨma naepɨpɨru okiyɨm. ");
INSERT INTO iws_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Mɨ tɨ iikamɨm sɨma tɨ dimɨn kɨrɨe komii komiiyɨm siya tɨrɨm sɨmiir kɨgɨm mɨ sɨma ɨna boɨnɨm. Tɨ profet inkamɨn Adi Komii siya boɨnɨn, nua tɨrii nɨtam siyaɨrgɨn. ");
INSERT INTO iws_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Mɨ Jisɨs siya bɨdi yɨnoknɨnkɨnkiyɨn, sɨma siir nonkwonamam tɨri sɨmiir kɨgɨrkakan inkam komii nwowam. Mɨ siya mhɨua hɨriirɨn sasar asi swokɨ amkɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Mɨ mhoɨiya ɨiya bɨeyɨn ha nɨkiiyamtɨbɨn mɨ kamɨm Jisɨs siir kɨgna mɨriiyɨm sɨma ɨna yapniyamtɨbɨm whɨiya hɨriir. ");
INSERT INTO iws_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Mɨ sɨma kɨmɨdiniya i ɨra saiir yani apni kwɨriinam. Mɨ ɨna iyɨkɨdamɨm whɨiya saiir mɨrmiiya hɨriir. Mɨ ɨiya bɨdi kakauu ɨuguskiya mɨ Jisɨs siya sɨmiiram bɨ nikɨ amsɨsaukɨn. ");
INSERT INTO iws_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Mɨ ta ɨiya opud komiiya ha hugnaniya mɨ hɨnɨn komiiya ɨna mɨ ii okwonaniya. ");
INSERT INTO iws_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Mɨ kamɨm Jisɨs siir kɨgna mɨriiyɨm sɨma kignaidamɨm kilomitɨsɨm ɨriiyar kwɨr nanaɨrgɨm. Mɨ sɨmar kɨgwɨn Jisɨs siya op ɨdwowar napnii. Mɨ siya sɨmiir iya saiir kingiin napamɨn mɨ sɨma nɨdid pranae bɨ kɨnwɨnkɨm. ");
INSERT INTO iws_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Mɨ Jisɨs siya sɨmiir boɨnki, kɨma kɨpi nɨdid, tɨ karaɨrgɨn nɨtɨn. ");
INSERT INTO iws_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Mɨ sɨma maɨrgɨmaɨrga siiram ha nwowɨm mɨ siirɨn ɨna yɨnkikwona kwɨriiyɨn. Mɨ bɨri kɨmɨmɨnkɨm, sɨma ɨna yɨmbiyamɨm ta maeyaua sɨma namam tɨra saiirɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mɨ ɨigwɨra iikamɨm sɨma bɨdi yɨnoknɨnkɨnkiyɨm, tapaiir nwomaiya iya ɨruwaɨrga. Mɨ sɨma Jisɨs siirɨn wara bɨ kɨgwo kwɨriigikɨm kamɨm siir kɨgna mɨriiyɨm sɨmakan. Nɨɨngaka. Sɨma siirɨn tɨrar haiburgigɨm. ");
INSERT INTO iws_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mɨ siyaii nhɨrɨm om komii Taibirias hɨrankɨ nɨtiyɨm yɨm ta maeyaua Jisɨs siya boɨn wadɨekiya Adi Komii siiram mɨ bret siya hauu aeya kam 5,000nɨm sɨm saiir kingiin hɨriir nɨtikɨm. ");
INSERT INTO iws_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mɨ iikamɨm sɨma hɨriinan kɨgɨm, Jisɨs siya mɨ kamɨm siir kɨgna mɨrii ɨkɨm, sɨma tɨr nwo rani mɨ sɨma kɨmɨdiniya siyaii sɨm nhɨrɨm sɨm kwɨriinaidam om komii Kapaneama hɨriirɨn Jisɨs siya mɨ kamɨm siir kɨgna mɨrii ɨkɨm sɨmiiram hansɨram. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Mɨ iikamɨm sɨma Jisɨs siirɨn whɨigbid mɨrmiiya hɨr kɨgɨuwɨn mɨ sɨma kɨmɨdiniya siir srɨi, inkamɨn nowomwarkaiyɨuwiyɨn, kɨra tɨriirɨn paka hɨnɨɨn ɨiya sae nɨtkɨn, ha? ");
INSERT INTO iws_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Mɨ Jisɨs siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨn, kara kɨmiirɨn yaimwowar boɨnkii, kɨma kariiramɨn mɨnam swokɨ aɨngwo hansɨrnikɨm bretɨm kara hauu aeyɨm kɨmiir mɨ kɨmiir mhɨiyɨm ha nae kɨnɨugiyɨm sɨmiiram. Mɨ kɨma kariiramɨn dimɨn kɨrɨe komii komiiyɨm kara tɨrɨm kɨma kɨgɨm sɨmiiram bɨ hansɨrnikɨm. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kɨma naeyɨm biyɨe nwowiyɨm sɨmiiram kɨpi mɨrii. Kɨma naeyɨn kwoɨnbud hauu haigɨnɨuwiyɨn omwai waiyayokiyokɨiyam siiram mɨriinanae. Mɨ kara tɨ inkamɨn nɨnomor kouankɨ nɨtɨn, kɨmiirɨn wɨ kara hauuwi siirɨn. Dimusi rani, Adi Komii krɨmiir Wanɨn siya kariirɨn inɨgak bɨdi ywohaigɨnɨugiyɨn. Mɨ kara siir mɨi aiir mɨriiyam nɨtkɨn. ");
INSERT INTO iws_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Mɨ sɨma siir swokɨ srɨi mɨ krɨma wɨ dimu dimɨn tɨ tɨr big nasmɨrwaiya Adi Komii siya nwowamɨn krɨmiiramɨn, ha? ");
INSERT INTO iws_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Mɨ Jisɨs siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨn, tɨkɨ dimɨnɨn kɨma tɨranɨn, big nasmɨrwaiya Adi Komii siya nwowi mɨ maɨrgɨmaɨrga siir nwowaigɨnɨuwi, kɨma kariir yai aiiram daɨngwo tɨbmii kɨɨn, inkamɨn yɨpɨkɨn Adi Komii siya nɨkrop ɨuungiyɨn nua tɨriir. ");
INSERT INTO iws_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Mɨ sɨma siir yai aka hɨnɨɨna swokɨ owarkɨi boɨn, kɨra wɨ pɨkɨ hɨnɨɨn dimɨn kɨrɨe komii komiiyɨm sɨm tɨri, krɨma kɨgamɨn. Mɨ krɨma wa nwokɨ aɨngwo tɨbmiiyɨm kɨriir yai aiiramɨn, ha? ");
INSERT INTO iws_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Krɨmiir yɨdiwi wanwiyaeyɨm ɨiya sɨma nu siiyɨn apaɨn siir hɨr nwowɨm sɨma dimɨn whɨrɨn mana dapiyɨn siirarar naekɨm Yokwo Komii saeya hɨnɨɨna boɨnka, tɨ naeyɨn nɨnomor kouankɨ nɨtkɨn Moses siyar hauu aekɨm sɨmiirɨn. ");
INSERT INTO iws_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Mɨ Jisɨs siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨnki, kara kɨmiirɨn yaimwowar boɨnkii tɨ bretɨn nɨnomor kouankɨ nɨtɨn kɨmiirɨn Moses siyar bɨ hauugɨn. Nɨɨngaka. Kariir Adɨn kɨmiirɨn siya hauugɨn nɨnomor kougɨ kou hɨran bretkɨ bretɨn. Mɨ tɨkɨ hɨriinan naeyɨn kɨmiirɨn wɨ omwai siya waiyayokiyokɨi haigɨnɨu rani. Nɨɨngaka. Kariir Adɨn tɨ hɨriinan nae kɨbiyɨn siir om hɨranɨn siyar hauuwikɨn bretnanɨn omwai kɨma waiyayokiyokɨiyam. ");
INSERT INTO iws_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Mɨ bretɨn Adi Komii siya hauugiyɨn nɨnomor kouwanɨn iikam kɨmiir, yɨo Jisɨs karaɨrgɨn. Mɨ kɨmiirɨn kwoɨn wɨn wɨ karar hauu haigɨnɨuwi omwai waiyayokiyokɨiyam. ");
INSERT INTO iws_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Mɨ sɨma siir boɨnki, Bɨiyan Inkam Komii, warɨ kɨriir bretɨn krɨmiirɨn ɨinokɨinok hɨriiyar whauunanae mɨ nɨm wɨ omwai hɨriiyar nwokɨ waiyayokiyokɨiyɨm. ");
INSERT INTO iws_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Mɨ Jisɨs siya sɨmiirɨn ɨna boɨnkiyɨn, tɨ bretɨn kwoɨn wɨn hauu haigɨnɨuwiyɨn iikam ɨmiir omwai sɨma waiyayokiyokɨiyam, yɨo karaɨrgɨn. Yɨpɨkɨ kariirɨm nɨti yɨo wɨ mhɨigɨ nao rani. Mɨ yɨpɨkɨ kariirɨm naɨngwo tɨbmii kɨɨni, yɨo wɨ kwoɨnkɨ haei rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kara kɨmiirɨn pɨ hɨnɨɨna boɨnkii, kɨma kariir bɨdiyar kɨgɨm mɨ kɨma bɨ naɨngwo tɨbmii kɨɨngɨm. ");
INSERT INTO iws_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Mɨ iikamɨm yɨpɨkɨ Adi Komii siya hauugiyɨm kariir ɨɨn nonkwowɨm, yɨm sɨma wɨ kariir siyɨu ɨiirar napi. Mɨ kara iikamɨm kariirɨm nɨtɨm mɨ kariirɨm naɨngwo tɨbmii kɨɨnɨm, sɨmiirɨn wɨ hɨuyarmai rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kara nɨnomor kou hɨr haiburgigɨn mɨ ha nɨuunaiiniyɨn, kara kariir kwoɨn ɨiirara napam bɨ nɨtkɨn Nɨɨngaka. Kara nua tɨriirɨn mɨnam nɨuunaiinikɨn, tɨ inkamɨn kariir nɨkropkiyɨn siir kwoɨn ɨiirarar napɨm. ");
INSERT INTO iws_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Mɨ tɨ inkamɨn kariir nɨkropkiyɨn siir kwoɨnɨn yɨo hɨnɨɨngɨn. Kara tɨ iikamɨm siya hauugiyɨm kariir, kara sɨmiir nwɨrni kɨpi haiburgig. Nɨɨngaka. Iikam ɨmiirɨn wɨ karar swokɨ hɨdnɨnsiin ɨdwowi, ɨiya Adi Komii siya iikam ɨmiir hɨdana. ");
INSERT INTO iws_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tɨ dimɨnɨn kariir Adɨn siya naɨngwowɨn kara tɨram yɨo hɨnɨɨngɨn mɨ tɨ iikamɨm yɨpɨkɨ kariir yai aiir wakaeyɨm mɨ ha nɨnoknɨnkɨnɨm kariir, siir yɨnisɨmɨn. Mɨ sɨma kariiram naɨngwo tɨbmii kɨɨnɨm mɨ ha mɨ wakaeyoknam kariir yai aiir, sɨmiirɨn wɨ kara hauu haigɨnɨuwi kwoɨnbudɨn omwai waiyayokiyokɨiiyɨn siirɨn. Mɨ sɨmiirɨn wɨ karar swokɨ hɨdnɨnsiin ɨdwowi. Mɨ sɨma wɨ omwaiyar waiyayokiyokɨi ɨiya Adi Komii siya sɨmiir hɨdana. ");
INSERT INTO iws_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Mɨ tɨ yaiyɨm siya boɨnkiyɨm sɨmiir mhoɨiya Isrel sɨmiir kamɨm ɨo ha nwowɨm mɨ ɨna nhɨnkii boɨnainamɨm Jisɨs siir. Dimusi rani, siya hɨnɨɨna boɨnkɨn, bretɨn nɨnomor kouankɨ nɨtɨn yɨo karaɨrgɨn. ");
INSERT INTO iws_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Sɨma hɨnɨɨna boɨn, tɨkɨ inkamɨn siya Jisɨskɨn, Josepni yɨnisɨm ɨkɨn. Krɨma siir yopii ad owiirɨn bɨdiyar ikɨ ɨnoknɨnkɨnɨm. Mɨ siya hɨnɨɨna dimusi boɨnkɨn, kara nɨnomor kou hɨr haiburgigɨn mɨ ha nɨuunaiinikɨn, ha? ");
INSERT INTO iws_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Mɨ Jisɨs siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨnki, kɨma, kɨma kɨmar kɨpi nomboɨnyokaina. ");
INSERT INTO iws_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Inkam nwɨrkɨ siir kwoɨn aɨrgɨ bɨ swokɨ aɨngwo tɨbmii kɨɨngɨn pɨ siya yaɨngwo tɨbmii kɨɨn kariiramɨn siirɨn Adi Komii siyar hɨurworwokaigikɨn. Mɨ siirɨn wɨ siyar swokɨ hɨdnɨnsiin ɨdwowi mɨ siya wɨ yaeya kwoɨn wɨn haii. Mɨ wɨ omwaiyar swokɨ waiyayokiyokɨii. Ya tariigɨna wɨ ɨiya Adi Komii siya iikam ɨmiir hɨdana wɨ saiir nɨmbiyami. ");
INSERT INTO iws_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Yaiya profet kamɨm sɨma wɨnboɨnkiya Yokwo Komii saiir ya hɨnɨɨnga. Adi Komii siya wɨ iikam kasa nowomwarkaiyɨu rani, dimɨn taemɨnɨm wadɨe sɨmiir nwowaigɨnɨuam. Mɨ iikamɨm yɨpɨkɨ kariir Adɨn siir yai aiir wakaeyɨm mɨ ha nɨnoknɨnkɨnɨm, kariiramɨn wɨ sɨma naɨngwo tɨbmii kɨɨni. ");
INSERT INTO iws_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Tɨ iikam whɨekakɨm sɨmiir nwɨrkɨ Adi Komii siir bɨ swokɨ kɨgɨmɨmɨnkɨn. Nɨɨngaka. Kana kanaɨrgɨn siir kɨgɨn tɨ inkamɨn Adi Komii siya nɨkrop ɨuungiyɨn nua tɨriir. ");
INSERT INTO iws_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kara kɨmiirɨn yaimwowar boɨni, inkamɨn kariiram naɨngwo tɨbmii kɨɨniyɨn, yɨo wɨ yaeya kwoɨn wɨn haii. Mɨ siya wɨ omwai hɨriiyar waiyayokiyokɨigiyami. ");
INSERT INTO iws_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","An kararɨn ɨni bretnan ywowɨn, iikam ɨmiirɨn karar whɨnkɨnsiis haigɨnɨuwi omwai waiyayokiyokɨiyamɨn. ");
INSERT INTO iws_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Bɨiya kɨmiir yɨdiwi wanwiyaeyɨm ɨiya sɨma nu siiyɨn apaɨn siir nwowɨm, sɨma manaɨm Adi Komii siya hauuwɨm sɨmiirarar naeyaonamkɨm. ");
INSERT INTO iws_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mɨ an kara tɨ inkamɨn Adi Komii siir om ɨiir haiburgigɨn mɨ ha nɨuunaiiniyɨn nu tɨriir, an kara ɨni bretnan ywowɨn, iikam ɨmiir whɨnkɨnsiis haigɨnɨuam. Mɨ yɨpɨkɨ kariiram naɨngwo tɨbmii kɨɨni, yɨm wɨ nao rani. Nɨɨngaka. Yɨm wɨ omwai hɨriiyar waiyayokiyokɨigiyami. ");
INSERT INTO iws_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","An kara ɨni bretnan ywowɨn, iikam ɨmiir whɨnkɨnsiis haigɨnɨuwam omwai sɨma waiyayokiyokɨiyɨm. Ankara Adi Komii siir omɨn nɨnomor kou hɨranɨn siir hɨrankɨ nɨtkɨn. Mɨ iikamɨm tɨ bret ɨiir naei, yɨm wɨ omwai hɨriiyar waiyayokiyokɨikaeyami. Yɨo tɨ bretɨn nuan iikamɨm sɨma naeyanɨn ya kariir pɨu aeyaɨrga. Mɨ sɨmiirɨn wɨ kara nwokɨ whɨnkɨnsiis haigɨnɨuɨm, yaeya kwoɨn wɨn haiyamɨn omwai waiyayokiyokɨiyamɨn. ");
INSERT INTO iws_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Mɨ tɨ dimɨn taemɨnɨm siya boɨnɨm sɨmiir mɨ Isrel sɨmiir iikamɨm sɨmiir kwoɨnɨm ɨna iwɨtpaomaigiyɨm. Mɨ sɨma ɨni sɨma sɨmar yɨnkɨnwamwarkɨi whrɨe boɨnamɨm. Sɨma hɨnɨɨna boɨn, tɨ inkamɨn siir pɨua krɨmiirɨn wɨ panɨɨna hauuwi, krɨma naeyamɨn, ha? ");
INSERT INTO iws_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Mɨ Jisɨs siya sɨmiirɨn ɨna boɨnkiyɨn, kara kɨmiirɨn yaimwowar boɨni. Mɨ kɨma ta kariir kɨp aiir nae karamae nwowi tɨ inkamɨn nɨnomor kouankɨ nɨtɨn mɨ kɨma kariir nhɨe aiir kwiyae karamae mɨ owi mɨ kɨma wɨ yaeya kwoɨn wɨn hai rani, omwai waiyayokiyokɨiyamɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mɨ inkamɨn kariir kɨp aiir naei mɨ kariir nhɨe aiir mɨ kwiyaei, yɨo wɨ yaeya kwoɨn wɨn haii, omwai waiyayokiyokɨiyamɨn. Mɨ siirɨn wɨ karar swokɨ hɨdnɨnsiin ɨdwokii mɨ siya inkamnan wɨ omwaiyar swokɨ waiyai ɨiya Adi Komii siya iikam ɨmiir hɨdana. ");
INSERT INTO iws_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kariir kɨpa saeyaɨrga dimɨnkɨ dimɨna naeiya. Mɨ kariir nhɨeya saeyaɨrga dimɨnkɨ dimɨna kwiyaeiya. ");
INSERT INTO iws_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mɨ inkamɨn kariir kɨp aiir naei mɨ kariir nhɨe aiir mɨ kwiyaei, yɨm sɨma kanakar nwowi mɨ ankara sɨmaka mɨ owi. ");
INSERT INTO iws_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Adi Komii siyaɨrgɨn digworaekwo whɨekakɨm omwai waiyayokiyokɨiiyɨm sɨmiir Adɨn mɨ yɨo siyarɨn omwai hɨriiyar waiyayokiyokɨikaeyamikɨn. Mɨ kariirɨn siya nɨkropkikɨn mɨ ankara ɨriipɨ hɨriinan omwai asi mɨ waiyayokiyokɨii. Mɨ yɨpɨkɨ kariir kɨp aiir naei, yɨo wɨ omwai hɨriiyar waiyayokiyokɨikaeyami tɨ digworaekwo ɨmiirsi. ");
INSERT INTO iws_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Karaɨrgɨn tɨ bretɨn, Adi Komii siir omɨn nɨnomor kou hɨranɨn siir hɨrankɨ nɨtɨn. Tɨ bretɨn yɨo tɨ bretɨn kɨmiir yɨdiwi wanwiyaeyɨm bɨiya sɨma naeyɨn siir hɨriinan tani. Nɨɨngaka. Sɨma tɨ bret ɨiir naeyɨm mɨ ɨiya sɨma waibiyɨe nwowa mɨ sɨma ɨna yaonamɨm. Mɨ yɨpɨkɨ tɨ bretɨn kara hauuanɨn siir naei, yɨm wɨ omwai hɨriiyar waiyayokiyokɨikaeyami. ");
INSERT INTO iws_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisɨs siya yaiyɨm omaka yaimɨn dimɨn nɨdwokai wakaeiya om Kapaneam hɨrana saiir hɨr boɨnmɨmauugɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Mɨ iikam whɨekakɨm yɨpɨkɨ siir kɨgna mɨriiyɨm sɨma ta yai aiir wakaeyɨm sɨma hɨnɨɨna boɨn warɨ yai hɨriinanɨm kɨra boɨnɨm, krɨma sɨmiirɨn nɨnoknɨnkɨn tani. Mɨ krɨmiirɨn hɨkak sɨma nwowi. Mɨ tɨ hɨriinan yaiyɨm sɨmiiramɨn pɨ nhɨnga nwowi, sɨmiir wakaeyamɨn, ha? ");
INSERT INTO iws_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Mɨ Jisɨs siya bɨdi yɨnoknɨnkɨnkiyɨn tɨ yai hɨriinanɨm sɨma boɨnɨm. Mɨ siya sɨmiir boɨnki mɨ tɨ yaiyɨm kara boɨnɨm sɨmiir mɨiyɨm kɨmiir kwoɨnɨm sɨma haiprɨdkikaigɨm, aniya? ");
INSERT INTO iws_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Mɨ kɨma tɨ inkamɨn Adi Komii siir omɨn nɨnomor kou hɨranɨn kariir kɨgii kara swokɨ ami, tɨ omɨn kara nikɨ ɨtɨn siir mɨ kɨma wɨ panɨɨna naɨngwokii, ha? ");
INSERT INTO iws_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Iikam kɨma, kɨma kɨmar whɨnkɨnsiis ankɨnsiisnaɨm omwai waiyayokiyokɨiyamɨn wɨ dɨg nwo rani. Nɨɨngaka. Adi Komii siir naeyɨuɨn mɨ ta yaiya kara boɨn aka mɨ sowa sowaɨrgo kɨmiir whɨnkɨnsiis haigɨnɨuwano omwai waiyayokiyokɨiyam. ");
INSERT INTO iws_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mɨ kɨmiir nhɨrɨm yɨm kariirɨm bɨ naɨngwo tɨbmiigɨm. Mɨ Jisɨs siya bɨdiyar yɨnoknɨnkɨnkiyɨn ɨiya siya kamɨm siir kɨgna mɨriiyɨm sɨmiir nɨmbinɨm mɨ yɨpɨkɨ inkamkɨn siiram naɨngwo tɨbmii kɨɨn karamae nwowɨn, siirɨn wɨ wɨr siya napwouwi siir sau omomɨn siya haɨnɨm siirɨn. ");
INSERT INTO iws_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Mɨ Jisɨs siya sɨmiirɨn hɨnɨɨna boɨnki, kara kɨmiir bɨdiyar ikɨ boɨnkiyɨn, inkam nwɨrkɨ kariiramɨn siir kwoɨnaɨrga bɨ swokɨ aɨngwo tɨbmii kɨɨnmɨmɨnkɨn. Nɨɨngaka. Pɨ siya yaɨngwo tɨbmii kɨɨn mɨ siir kwoɨnɨn Adi Komii siyar bɨdi hɨurworwokaigiyɨn. ");
INSERT INTO iws_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Mɨ tɨ yaiyɨm siya boɨnɨm sɨmiir mhoɨiya iikam whɨe komiiya bɨiya siir nikɨ kɨgna apɨm mɨ tariinanɨn sɨma siirɨn ɨni digɨumii haimriiyɨugigɨm. Mɨ sɨma siir haiburgigɨm mɨ ɨna yɨnoopamɨm. ");
INSERT INTO iws_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Mɨ mhoɨiya Jisɨs siya siir kɨgna mɨriiyɨm kam ɨuur nwɨso sɨmiir srɨi mɨ wɨm kɨma tari kariir haiburgigam warar mɨ aɨngwowi? ");
INSERT INTO iws_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Mɨ siir yai aka Saimon Pita siya yowarkɨi boɨn, bɨiyan Inkam Komii, krɨma wɨ nhɨniiram nami, ha? Kɨriir yaiya sasaɨrga krɨmiir whɨnkɨnsiis haigɨnɨuwana, omwai krɨma waiyayokiyokɨiyamɨn. ");
INSERT INTO iws_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nɨm krɨmarɨn ɨna nɨnoknɨnkɨnɨm kɨriirɨn, yɨpɨkɨn tɨ krɨma wakaeyokna aɨngwo tɨbmiiyɨn kɨraɨrgɨn tɨ inkamɨn Adi Komii siya nɨmbingiyɨn. ");
INSERT INTO iws_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Mɨ Jisɨs siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨn, kɨmiirɨn kara bɨdi yɨmbinɨn kariir kɨgna mɨriiyan kam ɨuur nwɨs nwowam. Mɨ kɨmiir nwɨrɨn yɨo mɨiyɨk rani, ɨni yɨumi bɨiyan inkamɨn Setan ɨni siir hɨriinan ywowɨn. ");
INSERT INTO iws_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Siya Judas siir boɨnkɨn, Saimon Iskariotni yɨnisɨmɨn. Siya tɨ kam ɨuur nwɨso siir kɨgna mɨriiyɨm sɨmiir nwɨrkɨn. Mɨ mhoɨiya Jisɨs siirɨn wɨ wɨr siya napwouwi ɨkɨ kam biyɨeyɨm sɨmiir, sɨma haɨnɨm siirɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Mɨ tɨriigɨnɨm dɨg nwokiyɨm mɨ Jisɨs siya ɨni nu haɨmii Galili hɨrar yapmɨriiyɨn. Dimusi rani, inkam komii komiiyɨm bɨi nwowiyɨm hɨranɨm sɨma siir nɨsomaowam tɨrkɨm. ");
INSERT INTO iws_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mɨ Isrel sɨmiir iikamɨm sɨmiir ɨiya kingiin nwowa, ɨrɨpa sɨma haɨngiriyɨu owiya yaewou naeya saiir nikwo aeyam amar omaka saiir. Ya ta ɨiya sɨmiir ɨi aeya numɨrɨn sasaeyɨm wai bɨi nwowɨm, sɨmiir nɨnkɨn ɨmiiyaeyam Adi Komii siir. ");
INSERT INTO iws_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Mɨ Jisɨs siir nomousɨsɨmɨm sɨma siir boɨn, kɨra tɨ om ɨiir haiburgik mɨ kɨra nu haɨmii Judia hɨriir dam mɨ iikamɨm yɨpɨkɨ kɨriir yai aiir naɨngwo tɨbmii wɨ sɨma nwokɨ kɨgɨm, dimɨn taemɨnɨm kɨra tɨri. ");
INSERT INTO iws_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mɨ inkamɨn ha naɨngwowi iikamɨm siir dɨnoknɨnkɨn mɨ siya siir dimɨn taemɨnɨm hindara kɨpi nɨmprɨo dirɨraerar. Nɨɨngaka. Mɨ kɨra tɨ hɨriinan dimɨn taemɨnɨm sɨmiir tɨri mɨ bɨiyɨn kɨrar tikɨ ɨisiimauuna hɨnda tɨnda. Mɨ tɨ dimɨn taemɨnɨm iikamɨm sɨma nwokɨ kɨgɨm kɨra dirɨraerarɨm dimɨn mɨiyɨk mɨiyɨkɨm. ");
INSERT INTO iws_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Mɨ siir nomousɨmɨm yɨm sɨmiir hɨriinan yaiyɨm hinda pɨuaɨrga mɨ boɨnkɨm, sɨma bɨ mɨ aɨngwo tɨbmii kɨɨngɨm. ");
INSERT INTO iws_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Mɨ sɨmiir yaiyɨm ha boɨn dɨgiyɨm mɨ Jisɨs siya sɨmiir boɨn, kariir ɨiya bɨ nikɨ ɨmbinika karar nɨisiimauunana hɨnɨɨn, kara tɨ inkamɨn Adi Komii siya nɨkropkiyɨn siya. Mɨ kɨma pakɨ hɨnɨɨn ɨiya sae mɨ ami ta ɨiya Isrel sɨmiir iikamɨm yaewou ɨrɨpa sɨma nɨnkɨn ɨmiiyaeyana, numɨran sasaeyɨm wai bɨi nwowiyɨm sɨm Adi Komiini, yɨo kɨmiirar kwoɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Iikamɨm nu tɨranɨm sɨma ɨo kɨmiir bɨ nwowikɨm Nɨɨngaka. Sɨma ɨo kariir nwowikɨm. Whɨsarii rani, sɨmiir aowa aowan dimɨn taemɨnɨm sɨma tɨriyɨm kara haknoudnɨnkɨnikɨm. ");
INSERT INTO iws_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kɨmar tɨ am sɨmakan, ta yaewou aiiramɨn. Ankara nɨɨngaka pɨ wara nam tani. An kara ɨi nhɨrɨm tɨrar nikɨ owamar naɨngwowi. Kara sɨmiirɨn hɨnɨɨnɨn asiima nikɨ ɨisiimauuwɨm pɨ boriisopi, kara tɨ inkamɨn Adi komii siya nɨkropkiyɨn siya. Nɨɨngaka. Ya ɨna nikɨ owa. ");
INSERT INTO iws_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Mɨ siya sɨmiirɨn hɨriinan boɨnkiyɨn mɨ siya ɨni nu haɨmii Galili hɨrar ywokiyɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Mɨ Jisɨs siir nomousɨsɨmɨm ha namɨm sɨma ta yaewouwa saiir nikwo aeyam mɨ yɨo siya ɨni mhoɨiyar mɨ amɨn. Siya iikam whɨekak aka bɨ namkɨn. Siya sasar yɨmprɨo am. ");
INSERT INTO iws_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Mɨ Isrel sɨmiir iikamɨm ɨiya sɨma ta yaewou aiir nikwo aeya, yɨm sɨma kɨmɨdiniya Jisɨs siiram yoksɨrboɨn. Mɨ sɨma ɨni sɨmasɨmar yɨnsrɨi ansrɨiyɨm siya ɨni papi nwowɨn. ");
INSERT INTO iws_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mɨ Jisɨs siiramɨn sɨmasɨmar whrɨe boɨnam. Nhɨrɨm yɨm hɨnɨɨna boɨn, siya inkam wadɨekɨn. Mɨ nhɨrɨm hɨnɨɨna boɨn, kiya yɨo inkam paii rani, iikam ɨma naɨngwo tɨbmii yamɨn, siir kwoɨnkar prɨinaɨngwo boɨni iikamɨm sɨmiir nɨkpɨtmaiyamɨn. ");
INSERT INTO iws_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Iikam hoɨmgakɨ bɨ boɨnkɨm Jisɨs siir nhɨnkiiyamɨn. Nɨɨngaka. Dimusi rani, sɨma mɨnsi nɨdidkɨm, Isrel sɨmiir bɨiyan inkam komii komiiyɨm pɨ sɨma wakaei mɨ sɨmiirɨn pɨ sɨma nɨki. ");
INSERT INTO iws_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mɨ ɨi kwoɨmɨm yaewou sɨma nikwo aeyɨm sɨmiir mhoɨiya Jisɨs siya iikam ɨmiirɨn omaka Adi Komii siir inɨg hainaniya saiir hɨrɨn, ɨni idowɨiyar boɨnmɨmauuɨn. ");
INSERT INTO iws_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mɨ Isrelmi inkam komii komiiyɨm sɨma hɨriinan kɨgɨm, sɨma ɨni hindara yanaakiyɨm. Mɨ sɨma boɨn, tɨ inkam hɨriinanɨn tɨ dimɨn taemɨnɨm yokwo tɨr nwowɨm, siya sɨmiirɨn panɨɨn panɨɨna nɨnoknɨnkɨnkɨm? Mɨ siya tɨ iikam ɨmiir kwomwarkaiyɨuɨn, inkam nɨnoknɨnkɨn komiigaknan siya skulam bɨ swokɨ amɨmɨnkɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Mɨ Jisɨs siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨn, tɨ dimɨn taemɨnɨm tɨ kara nowomwarkaiyɨuwɨm kɨmiir, yɨm kariir tani. Nɨɨngaka. Tɨ yaiyɨm yɨm Adi Komii siirgɨm, inkamɨn kariir nɨkropkiyɨn. ");
INSERT INTO iws_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mɨ inkamɨn siir kwoɨn komiiyɨn Adi Komii krɨmiir Wanɨn siir yai aiiram naɨngwowi mɨ siya pa nɨnoknɨnkɨnkii ta yaiya kara boɨnmɨmauuwa. Kara kariir kwoɨnkar prɨinaɨngwo boɨni iyɨe? Kara Adi Komii siir yai ɨmiir boɨni. ");
INSERT INTO iws_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mɨ inkamɨn siir kwoɨnkar naɨngwo boɨni, yɨo tɨ hɨriinan inkamɨn yɨo siir inɨg ɨiirar hainanamar tɨri. Mɨ inkamɨn tɨ inkamɨn siya nɨkropkiyɨn mɨ ha nɨtɨn, siir inɨg ɨiir hainani mɨ yai ha boɨnmɨmauuwi mɨ yɨo tɨ inkam hɨriinanɨn, yɨo inkam wadɨekɨn bɨ ɨksɨsaeikɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Bɨiya Moses siya siyɨu komii siir siyɨuɨm kɨmiir hauuwɨn mɨ kɨmiir nwɨrkɨ tɨ siyɨu ɨiir bɨ swokɨ sɨbgu apkɨm. Nɨɨngaka. Mɨ kɨma kariir nɨsomaowam dimuam tɨri, kara tɨ Moses siir siyɨu ɨiir nap karamae nwowɨn, ha? ");
INSERT INTO iws_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mɨ iikam nhɨrɨm siir yai akan sɨma yowarkɨi boɨnki, yɨpɨkɨn kɨriir nɨsomaowam tɨrɨn. Mɨ kɨra tɨ hɨriinan yai boɨnɨn mɨ tari kɨriirɨn uridyɨugɨ bɨdi ii okwokaiyɨn, aniya? ");
INSERT INTO iws_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Mɨ Jisɨs siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨn, kɨma ɨo kariir dimusi nwo rani mɨi kɨbi kwɨra, iikamɨm makɨniiyɨm sɨmiir kara nɨnɨmnɨskiiyɨm, Judami ɨi komiiya pɨu siiskuwakiya dimɨn taemɨn tɨr karamae nwowiya saiir mɨ kɨma kwoɨn bibiyɨe kariiramɨn saiirsi naɨngwowi. ");
INSERT INTO iws_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mɨ bɨiya Moses siya kɨmiirɨn mɨn boɨnkɨn, kɨmiir yɨnisɨm yɨnkamiyɨnɨm sɨmiir mɨoɨs ɨmiir kɨtiyopnɨr haiyɨm. Nɨɨngaka. Yɨo kɨmiir brougae ɨma tɨrkɨn bɨiyɨn. Mɨ wɨm kɨma kɨmiir yɨnisɨm yɨnkamiyɨnɨm sɨmiir mɨoɨsɨm Juda sɨmiir ɨi komiiya pɨu siisiya dimɨn taemɨn tɨr karamae nwowiya, saiirar mɨ kɨtiyopnɨmnɨr haiigɨm. Mɨ Moses siir siyɨuɨn siirar mɨ apkɨn. ");
INSERT INTO iws_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Wɨm kɨma tɨ dimɨnɨm Judami ɨi komiiya Sabat pɨu siiskuwakiya dimɨn taemɨn whɨr tɨr karamae nwowiya saiirɨn ɨni Moses siir siyɨu ɨiirar mɨ apɨm. Mɨ kɨma pɨ ɨo kariir dimusi nwowi, tɨ makak iikamɨm kara nɨnɨmnɨskiiyɨm sɨmiirsiyɨn ta Judami ɨi komiiya pɨu siiskuwakiya Sabat dimɨn taemɨn whɨr tɨr karamae nwowiya saiir, ha? ");
INSERT INTO iws_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Dimɨnɨm kara kɨmiir boɨnɨm kɨma sɨmiirɨn hindara whɨsariiya kɨpi hɨd. Wɨm kɨma ha naɨngwowi kara Moses siir siyɨu ɨiir mɨ ikwowaisii. Kɨma sɨbgu daɨngwo omoki mɨ kɨma pa nwokɨ ɨnoknɨnkɨnɨm kariir yaiyɨm kaimwowaɨrgɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Mɨ iikam nhɨrɨm om komii Jerusalem hɨranɨm sɨma boɨn, tɨ inkamɨn siya sɨma nɨsomaowi. ");
INSERT INTO iws_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kɨma siir kɨgi! Siir dimɨn taemɨnɨm iikam ɨmiir siya boɨnɨm, siya ɨsi hindara krɨnkɨnkiyɨm. Mɨ siirɨn inkam nwɨrkɨ bɨ swokɨ boɨn hɨuriyɨu mɨmɨnkɨn. Mɨ inkam komii komiiyɨm sɨma hɨriiyar yaɨngwo mɨ tari Krais siyaɨrgɨ sae, tɨ inkamɨn Adi Komii siya nɨkrop ɨuugiyɨn, iyɨe? Si rani? ");
INSERT INTO iws_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mɨ tɨ inkamɨn Adi Komii siya siirɨn panɨɨn panɨɨna nɨmbingikɨn. Krɨma ɨna nɨnoknɨnkɨnɨm siir om ɨiirɨn. Mɨ mhoɨiya tɨ inkamɨn Krais nɨkɨuwiyɨn, Adi Komii siya nɨmbingiyɨn, siya swokɨ ɨti mɨ iikamɨm sɨma wɨ ha nɨnoknɨnkɨn tani, siya pɨndankɨ nɨtkɨn. Mɨ hɨriinankɨ nɨuwi siya tari Krais rani. ");
INSERT INTO iws_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Mɨ tɨ dimɨn taemɨnɨm iikam ɨma boɨnkiyɨm sɨmiir mhoɨiya, Jisɨs siya omaka Adi Komii siir inɨg hainaniya saiir hɨrar nikɨ owɨn mɨ siya ɨni komiiyar kauwok boɨnkiyɨn. Wɨm kɨma ha naɨngwowi kara yɨpɨkɨn mɨ kara pɨndankɨn nɨtkɨn. Kara kariir kwoɨnaɨrgɨ bɨ prɨinaɨngwo ɨtkɨn. Kariirɨn Adi Komii siyar nɨkropkikɨn mɨ kara asi nɨtkɨn. Kwoɨnɨm siyar naɨngwowiyɨm yɨm kaimwowaɨrgɨm mɨ kɨma siir nɨnoknɨnkɨn tani. ");
INSERT INTO iws_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","An kara siirɨn ɨna nɨnoknɨnkɨnɨn, whɨsarii rani, kara bɨiya saɨka hɨrar nikɨ okɨn mɨ kariirɨn nua tɨriirɨn siyar nɨkropkikɨn. ");
INSERT INTO iws_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Mɨ tɨ dimɨn taemɨnɨm siya boɨnɨm sɨmiir mhoɨiya, inkam komii komii nhɨrɨm ɨna yamɨm siir hɨugrɨpkɨikikaiyam mɨ siir nonkwonamɨm maeyauwa mɨi biyɨe mɨriiya saiir hɨriir. Mɨ sɨma siir bɨ nonkwokɨm. Dimusi rani, ɨiya siya namana ya kingiin nikɨ o rani. ");
INSERT INTO iws_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Mɨ iikam whɨekakɨm, dimɨn taemɨnɨm siya nowomwarkaiyɨuwɨm sɨmiir wakaeyɨm, sɨma ɨna yaɨngwo tɨbmii kɨɨngiyɨm siiramɨn. Mɨ sɨma boɨn, mhoɨiya tɨ inkamɨn Krais nɨkɨuwiyɨn Adi Komii siya nɨmbingiyɨn tɨriir nɨtam, dimɨn kɨrɨe Komii komiiyɨm siya tɨri wɨ tari tɨ inkamɨn siya tɨrɨm dimɨn kɨrɨe komii komiiyɨm wɨ tari sɨmiir namsi haiburi? Nɨɨngaka. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mɨ Farisi kamɨm sɨma hɨriinan wakaeyɨm, iikamɨm sɨma Jisɨs siir haigirɨrɨr boɨni mɨ sɨma mɨ prismi bɨiyan inkam ɨkɨm, sɨma polis inkamɨm sɨmiir asi nɨkropkikɨm siir nonkwowamɨn. ");
INSERT INTO iws_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Mɨ ɨiya sɨma nɨta Jisɨs siiram mɨ Jisɨs siya ɨna boɨnwɨnɨn sɨmiirɨn, kara kɨmaka tapaiirɨn ɨi prɨei nwo rani mɨ kara wɨ kapi swokɨ ami tɨ inkamɨn kariir nɨkrop ɨuungiyɨn nua tɨriir siiram. Mɨ wɨ saɨkar swokɨnɨ owouwi. ");
INSERT INTO iws_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mɨ mhoɨiya kɨma kariiram hansɨrni, kɨma wɨ kariir kɨg rani. Mɨ tɨ omɨn kara namanɨn kɨma kariiramɨn wɨ mhoɨiya siiram nɨntɨrop ɨt rani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Mɨ tɨ yai hɨriinanɨm siya boɨnkiyɨm sɨmiir mhoɨiya, Isrel sɨmiir bɨiyan inkam komii komiiyɨm sɨma sɨmasɨmar yɨnwhrɨe anwhrɨe boɨnamɨm, siya tɨ hɨriinan boɨnɨn mɨ siya wɨ pɨnda nami krɨma siir kɨg karamae nwowi, ha? Mɨ siya wɨ ɨkɨ omom pɨugan kwɨrniyɨm Isrel sɨmiir pɨugana saeya wara nwo karamae nwowɨm wɨ sɨmiir nami? Mɨ siya wɨ ɨkɨ omom Isrel sɨmiir iikamɨm sɨmiir kam nwonwɨrakɨn nɨnkɨn hopkai waiyɨm wɨ sɨmiir nami? Mɨ siya Adi Komii siir yaiya wɨ Grikmi isidɨn hɨranɨm wɨ sɨmiir ninɨ boɨnmɨmauuwɨuwi, aniya? ");
INSERT INTO iws_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Mɨ siya hɨnɨɨn dimusi boɨnkɨn? Mhoɨiya kɨma kariiram hansɨrni kɨma wɨ kariir kɨg rani, kara wɨ omɨn kɨma nɨntɨrop ɨt karamae nwowɨn wɨ siir nami. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Mɨ iikam ta yaewou naeya saiir nɨkopkaini ɨiya saiirar nikɨ ikwo aeyɨm amar omaka saiir hɨr mɨ Jisɨs siya ha nɨnsiin okwokiyɨn ɨni komiiyar kauwok boɨnamnankiyɨn. Yɨpɨkɨ kwoɨnkɨ haei yɨo kariir winɨ kɨgni mɨ siirɨn wɨ op kara hauu kwiyae haigɨnɨugii. ");
INSERT INTO iws_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ya ɨni Yokwo Komii saeyar boɨna yaiya ɨni saiir hɨriinana ywowa. Mɨ yɨpɨkɨ kariiram naɨngwo tɨbmii kɨɨni, yɨo wɨ Adi Komii siir naeyɨuɨn hɨriiyar namyokiyokɨiiyɨn wɨ siir haii. Yɨo wɨ opa ɨeno ankɨ nɨriidkɨɨnmwɨmoɨnaniniya wɨ saiir hɨriinan nɨriidkɨɨnmwɨmoɨnanini siir kwoɨn hɨrankɨn mɨ wɨ siya whɨnkɨnsiis haigɨnɨuwi iikam nhɨrɨm sɨmiirɨn. ");
INSERT INTO iws_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jisɨs siya ta hɨriinan yaiya Adi Komii siir naeyɨu ɨiir boɨnkɨn. Mɨ yɨpɨkɨ siiram naɨngwo tɨbmii kɨɨni, tɨriigɨnɨn wɨ ini hanɨɨn siir kwoɨn ɨiir kwɨrii ɨdwokaii. Mɨ ta ɨiya Adi Komii siir naeyɨuɨn bɨ nikɨ ɨtkɨn. Dimusi rani, Jisɨs siya bɨ nikɨ aonamkɨn mɨ bɨ nikɨ ɨnsiin ɨdwonamkɨn omwai waiyayokiyokɨiyamɨn. Mɨ Adi Komii siir omɨn nɨnomor kou hɨranɨn siir hɨriir bɨ nikɨ amkɨn, kɨrɨe komii haiyamɨn. Nɨɨngaka. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Mɨ iikam whɨekakɨm hɨr nwomɨmɨrɨm sɨma boɨn, kaimwoka, tɨ profet inkamɨn krɨma nwokwokɨnɨn siyaɨrgɨn. ");
INSERT INTO iws_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Mɨ nhɨrɨm sɨma boɨn mɨ tari Krais siya tɨ inkamɨn krɨma nwokwokɨnɨn Adi Komii siya nɨkropkiyam. Mɨ Jisɨs siya nu Galili hɨrankɨn nɨtkɨn mɨ nhɨrɨm yɨm hɨnɨɨna boɨn, tɨ inkamɨn Adi Komii siya nɨkropkiyanɨn siya wɨ nu haɨmii Galili hɨrii nɨmbiyami. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Adi Komii siya Yokwo Komii saiirɨn hɨriiyar boɨnkikɨn. Tɨ inkamɨn Adi Komii siya nɨkropkiyanɨn yɨo Devidni namougɨn. Siir yopiiya siirɨn wɨ om Betlehem omɨn bɨiya Devid siyar nwowɨn wɨ siir hɨr naokainaei. Mɨ hɨriinankɨ nɨuwi mɨ siya tari Krais rani. ");
INSERT INTO iws_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mɨ iikam whɨekakɨm hɨr nwowɨm kasa rani. Mɨ sɨma isido whɨsa yɨinɨkibɨrnam, nhɨrɨm yɨm sɨma dimɨn mɨ boɨn mɨ nhɨrɨm yɨm sɨma dimɨn mɨ boɨn, Jisɨs siirɨn. ");
INSERT INTO iws_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mɨ tɨ yaiyɨm sɨmiir mhoɨiya, nhɨrɨm kɨmɨdiniya Jisɨs siir yonkwowam tɨr, maeyauwa mɨi biyɨe mɨriiya saiir hɨr hɨugrɨpkɨikikaigiyɨm. Mɨ sɨma siir bɨ nonkwokɨm. Dimusi rani, ta ɨiya siya naowana ya bɨ nikɨ ɨmbinika. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mɨ tɨ dimɨn taemɨnɨm sɨmiir mhoɨiya, polis inkamɨm sɨma Jisɨs siir haiburgigɨm mɨ sɨma ɨna swokɨ amɨm prismi bɨiyan inkamɨm mɨ Farisi kam ɨkɨm sɨmiiram. Mɨ sɨma sɨmiirɨn hɨnɨɨna boɨnwɨn, kɨma siir nonkwonani karamae dimusi nwokɨm, ha? ");
INSERT INTO iws_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Mɨ polis inkamɨm sɨma sɨmiir yaiyaka hɨnɨɨna yowarkɨi boɨnki, bɨiya inkam nwɨrkɨ tɨ inkamɨn siir hɨriinan yai bɨ swokɨ boɨnmɨn boɨnmɨnkɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Mɨ Farisi kamɨm sɨma hɨnɨɨna yowarkɨi boɨn mɨ siya ɨkɨ iikam nhɨrɨm sɨmiir kinsɨnan mɨ tari kɨmiirɨn ɨni warar yɨnkɨn hɨuspak haiyɨn siir siyɨu ɨiir napam, aniya? ");
INSERT INTO iws_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mɨ kɨma hɨriiyar kɨgi, inkam komii komiiyɨm kɨmiir kɨgɨrkakiyɨm mɨ Farisi krɨma, krɨmiir inkam nwɨrkɨn ɨni warar wakaeyoknan siir yai aiiramɨn, aniya? Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Yɨm tɨ iikamɨm, yɨm Moses siir siyɨu komiiyɨm siir siyɨu ɨmiir bɨ nɨnoknɨnkɨnkɨn krɨmiir hɨriinan. Mɨ sɨmiirɨn wɨ Adi Komii siya tɨrbugii, ɨiya siya iikam ɨmiir hɨdana. ");
INSERT INTO iws_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Mɨ Nikodimasɨn tɨ inkamɨn Jisɨs siiram namwɨiyɨn nɨiyaka yɨo tɨ Farisi inkamɨm sɨmiir inkam nwɨrkɨn. Mɨ siya sɨmiir boɨn, ");
INSERT INTO iws_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Krɨmiir siyɨuɨn yɨo ha boɨnkɨn, krɨma kamɨm sɨmiir kɨgɨrkakiyɨm, krɨma inkamɨn yai boɨniyɨn siir yai aiirɨm tikɨ mauugi mɨ dimɨnɨn siya tɨranɨn siiram tikɨ kɨgi mɨ mhoɨiya krɨma wɨ haɨni boɨnɨm, siya wadɨekɨ piyamisi owɨn, iyɨe? Wadɨe rani. ");
INSERT INTO iws_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Mɨ sɨma siir yai aka hɨnɨɨna yowarkɨi boɨn mɨ ni kɨra ɨriipɨ hɨriinan nu haɨmii Galili hɨran inkam paeprikabgɨn, aniya? Kɨra Yokwo Komii saiir sɨbgu mwaɨni mɨ kɨra wa nwokɨ ɨnoknɨnkɨnɨm, profet inkam nwɨrɨn wɨ nu haɨmii Galili hɨr swokɨ ɨmbiyamɨmɨn tani. Nɨɨngaka. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Mɨ ɨiya sɨma sɨmiir yai ɨmiir dɨgiyɨm mɨ tɨ iikamɨm hɨr haɨngiriyɨu owɨm ɨna nhɨnmaigiyɨm sɨmiir yapa yapa oma. Mɨ Jisɨs siya yɨo kɨmɨdina mhɨu whɨrɨn Oliv nɨkɨuwiyɨn siir yam. ");
INSERT INTO iws_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Mɨ ɨigwɨr nugak ɨɨmuma Jisɨs siya ɨna swokɨ amyakwokɨn omaka Adi Komii siir inɨg hainaniya saiir. Mɨ iikam whɨekakɨm ha nɨtɨm ɨni siirar inɨ ɨdwo kaeyokainiyɨm. Mɨ siya ɨni sɨmiir bopwonau hɨrar yɨdwokai owomwarkaiyɨuwɨn. ");
INSERT INTO iws_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Mɨ kamɨm siyɨu komii nɨnoknɨnkɨniyɨm mɨ Farisi kam ɨkɨm sɨma wiga kamkaka wig nhɨrmi kam aka nwowa saiirɨn warar yɨkɨunani. Mɨ sɨma kɨmɨdina saiir boɨnki, saeya iikamɨm sɨmiir whwonkam ɨdar nɨnsiin okwokiyɨm. ");
INSERT INTO iws_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Mɨ sɨma kɨmɨdiniya Jisɨs siir boɨnki, inkamɨn nowomwarkaiyɨuwiyɨn ta wiga, wig nhɨrmi kam aka nwowa krɨma saiir bɨdi kɨgɨm. ");
INSERT INTO iws_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Krɨmiir siyɨu komiiyɨn Moses siya wɨnkiyɨn yɨo hɨnɨɨna boɨnkikɨn, ta hɨriinan wiga krɨma saiirɨn siiyani kaiyɨmɨk aoki. Mɨ ni kɨra pɨ panɨɨna boɨni tɨ hɨriinan siyɨu ɨiirɨn, ha? ");
INSERT INTO iws_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Sɨma tɨ hɨriinan yaiyɨm mɨnam boɨnkɨm sɨrni hanɨɨn siya kiyɨskaiyɨm mɨ siirɨn pa nwokɨ boɨn hɨuriiyɨuɨm. Mɨ siirɨn pa nwokɨ onkwonamɨm maeyauwa mɨi biyɨe mɨriiya saiir hɨugrɨpkɨikikaiyam. Mɨ sɨma siir bɨ swokɨ ɨksɨsaekɨm. Nɨɨngaka. Siya bɨdiyar yɨnoknɨnkɨnɨn. Mɨ Jisɨs siya ha waisiinaiinamɨn mɨ siya kɨmɨdiniya nu ɨiir wɨn. ");
INSERT INTO iws_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Mɨ sɨma hɨrar nikɨ okwowɨm mɨ sɨma siiramɨn ɨna kɨntɨnu srɨiraraokiyɨm. Mɨ Jisɨs siya ha nɨnkiyɨnyɨn okwokiyɨn mɨ siya ɨna boɨnkiyɨn sɨmiirɨn, yɨpɨkɨ kɨmiir nwɨrɨn dimɨn biyɨe tɨr karamae nwowɨn, bɨi pɨ siya dɨt saiirɨn siiyani. ");
INSERT INTO iws_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mɨ siya ha swokɨ waisiinaiinamɨn mɨ siya yai nhɨrɨm ɨna swokɨ wɨnamɨn nu ɨiir. ");
INSERT INTO iws_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Mɨ yaiyɨm Jisɨs siya boɨnɨm sɨmiir mhoɨiya, sɨma ɨna kiwomwokairaraokiyɨm nwonwɨra nwonwɨra sɨmiir oma namɨm. Mɨ bɨiyɨn adiyaowae waibibiyɨeyɨm sɨma haiburgig hɨrɨn. Mɨ mhoɨiya yainan whran, kopak mwɨigak ɨma. Mɨ sɨma ɨna yamɨm sɨmiir oma. Mɨ hapaiirɨn Jisɨs saɨsar ywoki ta wig anakan. ");
INSERT INTO iws_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Mɨ Jisɨs siya ha nɨnsiin okwoyɨnyɨnkiyɨn mɨ siya kɨmɨdina saiir srɨi, wig, sɨma ɨni papi nwowɨm? Tapaiirɨn inkam nwɨrkɨ swokɨ o rani, kɨriir boɨn hɨuriyɨuwamɨn warɨ dimɨn biyɨeyɨm kɨra tɨrɨm sɨmiirsiyɨn, ha? ");
INSERT INTO iws_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mɨ wiga siir yai aka hɨnɨɨna yowarkɨi boɨn, inkam Komii tapaiirɨn inkam nwɨrkɨ swokɨ o rani. Nɨɨngaka. Sɨma bɨdi yamswokiyɨm. Mɨ Jisɨs siya saiir boɨn, an kara ɨriipɨ hɨriinan warɨ siyɨu biyɨeyɨm kɨra mɨ tɨrɨm pɨ sɨmiirsi boɨn hɨuriyɨu rani. Mɨ kɨra tapaiir haiburgig mɨpi tɨ am. Mɨ kɨra wɨ dimɨn biyɨe kɨpi swokɨ tɨrmɨmɨn. Nɨɨngaka. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Mɨ Jisɨs siya yɨpɨkɨ siir kɨgna apɨm, sɨmiirɨn ɨna swokɨ boɨnkiyɨn, kara tɨ nu ɨiirɨn ɨni bɨenan whwoyan. Mɨ yɨpɨkɨ kariirɨm naɨngwo tɨbmii kɨɨni mɨ kariir yai ɨmiir wakaeyoknaei mɨ siya wɨ siyɨu biyɨeyɨn nɨibwomambwonan nwokiyamɨn wɨ siir nap rani. Nɨɨngaka. Siya wɨ yaeya kwoɨnwɨnɨn omwai waiyayokiyokɨiiyɨn wɨ siir haii bɨenan whwoyaeiyɨn. ");
INSERT INTO iws_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mɨ Farisi kamɨm sɨma Jisɨs siir boɨnki, warɨ dɨmɨn taemɨnɨm kɨra boɨniyɨm yɨm kɨriir kwoɨnkar prɨinaɨngwo boɨni. Warɨ dimɨn taemɨnɨm kɨra boɨniyɨm yɨm dimɨn komii rani, yɨm krɨmiirɨn ha nɨisiimauu rani, kɨra yɨpɨkɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jisɨs siya hɨnɨɨna yowarkɨi boɨn. Nɨɨngaka. Tɨ dimɨn taemɨnɨm kanakanar boɨn wakaenam yɨm kaimwowaɨrgɨm. Dimusi rani, kara ɨna nɨnoknɨnkɨnɨn omɨn kara nɨtɨn mɨ omɨn kara namanɨn. Mɨ wɨm kɨma ha nɨnoknɨnkɨn tani kara pɨndankɨ nɨtkɨn mɨ kara wɨ pɨnda nami. ");
INSERT INTO iws_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Wɨm kɨma kariirɨn nuan dimɨn ɨmiirarar hɨdikɨn. Kɨma kariirɨn dimɨn mwoni bɨ boɨnikɨm. Mɨ kɨma kariirɨn ɨni hɨriiyar boɨn hɨuriyɨu krɨpkaiyɨm. Mɨ an kara inkam ɨmiirɨn hɨriinan bɨ hɨdikɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Mɨ kara iikamɨm kariir whwonkam ɨda nokwowɨm sɨmiir dimɨn taemɨnɨm sɨma tɨrɨm sɨmiir hɨdi, kara wɨ wadɨeyar hɨdi. Dimusi rani, kara kariir kwoɨn aɨrgɨ prɨinaɨngwo hɨd rani. Nɨɨngaka. Adi Komiiyɨn yɨpɨkɨ kariir nɨkropkiyɨn siya ɨni kanakar nwowɨn. ");
INSERT INTO iws_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kɨmiir siyɨuɨn yɨo hɨnɨɨna boɨnkɨn, inkamwo pɨ nwɨsa ywoki kwoɨn whɨruwa ɨkɨ dimɨnɨn sowar boɨnɨn pɨ kaimwo siya nwokii. Dimusi rani, sowa kwoɨn whɨruwa bɨdi ywokiyo. ");
INSERT INTO iws_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Kara kɨmiirɨn dimɨn taemɨnɨm kariirarɨm sɨmiir boɨni, kara tɨ inkamɨn Adi Komii siir omankɨ nɨtɨn. Adi Komiiyɨn kariir Adɨn, yɨpɨkɨn kariir nɨkropkiyɨn, siya mɨ kara, krɨra kɨmiir nɨnoknɨnkɨn haigɨnɨuwam tɨri kariirɨn hɨnɨɨn, kara yɨpɨkɨn. ");
INSERT INTO iws_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Mɨ sɨma siirɨn hɨnɨɨna srɨi, kɨriir Adɨn ɨni papi nwowɨn? Mɨ Jisɨs siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨn mɨ kɨma kariirɨn ha nɨnoknɨnkɨn karamae nwowi kara yɨpɨkɨn mɨ kɨma kariir Adɨn siirɨn wɨ wara mɨ ɨnoknɨnkɨn tani. Mɨ kɨma kariir nɨnoknɨnkɨni mɨ kɨma kariir Ad ɨiirɨn wa mɨ ɨnoknɨnkɨni. ");
INSERT INTO iws_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jisɨs siya omaka Adi Komii siir inɨg hainaniya saiir maeyau kwɨra hɨuyokiyokaiya maeyaua umɨrɨm Adi Komiini sɨma hauuwiyɨm, sɨm haigiiya saiir hɨr boɨnmɨmauugɨn. Mɨ sɨma siir bɨ nonkwokɨm maeyaua mɨi biyɨe mɨriiya saiir hɨr hɨugrɨpkɨikikaiyamɨn. Dimusi rani, siir ɨiya naowana ya bɨ nikɨ ɨmbinika. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Mɨ Jisɨs siya sɨmiirɨn ɨni hɨriiyar swokɨ haɨngiyas boɨn taraowamɨn. Kara wɨ kapi namkrɨpkainami. Mɨ mhoɨiya kɨma wɨ kariirɨm hansɨrnanaei. Mɨ mhoɨiya kɨma wa naonami. Dimusi rani, tɨ dimɨn biyɨeyɨm kɨma tɨrɨm sɨmiirsika. Mɨ kɨma omɨn kara namanɨn wɨ siir wara nam tani. Nɨɨngɨ, nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Mɨ Isrel sɨmiir bɨiyan inkam komii komiiyɨm sɨma hɨnɨɨna boɨn mɨ siya hɨnɨɨna dimusi boɨnkɨn, kɨma omɨn siya namanɨn wɨ siir wara nam tani? Mɨ tɨ yaiyɨm tɨ siya kwaboɨnkiyɨm, yɨm tari hɨnɨɨna boɨnkɨm, siya wɨ siya siyar swokɨ ɨsomaonaei. Mɨ krɨma wɨ wara nɨnkɨn am tani, ha? ");
INSERT INTO iws_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Mɨ Jisɨs siya hɨnɨɨna yowarkɨi boɨn, wɨm kɨma nu tɨran iikamkɨm mɨ an kara nɨnomor kouan inkamkɨn wɨm kɨma tɨ nuɨn siir tɨrankar nɨtkɨm, an kara kouankɨ nɨtkɨn. ");
INSERT INTO iws_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kara kɨmiirɨn tɨ hɨriinan siirsi boɨnmauugɨn. Kɨma wa naonami. Dimusi rani, kɨmiir dimɨn biyɨeyɨm kɨma tɨrɨm sɨmiirsika. Mɨ kɨma ha bɨ naɨngwo tɨbmii kɨɨngɨm kara tɨ Inkamɨn Adi Komii siya nɨkropkiyɨn siya. ");
INSERT INTO iws_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Mɨ sɨma siir yai aka ɨna swokɨ owarkɨi boɨnɨm, ɨhɨ mɨ kɨra yɨpɨkɨn? Mɨ Jisɨs siya ɨna swokɨ owarkɨi boɨnɨn, kara tɨ yaiyɨm kɨmiir bɨdiyar ikɨ boɨnmauuɨn, ɨiya kara bɨigɨ bɨi Adi Komii siir yai aiir boɨmɨmauuɨn. ");
INSERT INTO iws_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kara kɨmiirɨn wa pɨ boɨnɨn mɨ wa pɨ mɨ hɨdɨn dimɨn biyɨe biyɨeyɨm kɨma tɨrɨm sɨmiirsiyɨn. Mɨ tariinanɨn iyɨe? Yɨo ɨni nɨɨnga ywowɨn. Mɨ tariinanɨn kara nuan iikamɨm kɨmiirɨn pɨ yaimɨn dimɨnɨm kara hainaniyɨm siir hɨrankɨ, inkamɨn yɨpɨkɨ kariir nɨkropkiyɨn pɨ sɨmiir boɨnmɨmauuwi. Siyaɨrgɨn kaimwokɨ kaimwowɨn. Mɨ ta saeyaɨrga kara boɨnmɨmauuwiya iikamɨm nuanɨm kɨmiir. ");
INSERT INTO iws_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Sɨma ha bɨ nɨnoknɨnkɨnkɨm tɨ dimɨn taemɨnɨm siya boɨnmɨmauuwɨm, yɨm siir Adɨn siirgɨm. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Mɨ Jisɨs siya sɨmiir boɨnki, mhoɨiya ɨiya kɨma kariir hainani, inkamɨn nɨnomor kouankɨ nɨtɨn paeyɨn hɨiniya nɨrɨonɨnkɨnɨn siir mɨ kara ha naonami mɨ kɨma wɨ haɨni nɨnoknɨnkɨni, kara yɨpɨkɨn. Mɨ kɨma wɨ haɨni nɨnoknɨnkɨni, kara tɨ dimɨn taemɨnɨm kanakanar bɨ prɨinaɨngwo boɨnkɨm. Mɨ tɨ yaiyɨm kara boɨnmɨmauuwɨm kɨmiir, yɨm kariir Adɨn Adi Komii siyar hauugikɨm kariirɨn. ");
INSERT INTO iws_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Mɨ kariir Adɨn, Adi Komii siya yɨpɨkɨ kariir nɨkropkiyɨn, siya ɨni kanakar nwowɨn, siya kariirara bɨ kɨgnɨnkɨnkiikɨn. Dimusi rani, siir yaiyɨm karar wakaekɨm mɨ kara siir kwoɨn ɨiirar napikɨn. ");
INSERT INTO iws_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Mɨ iikam whɨekakɨm ta yaiya Jisɨs siya boɨna saiir wakaeyɨm sɨma ɨna yaɨngwo tɨbmii kɨɨngiyɨm siirɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Mɨ mhoɨiya Jisɨs siya Isrel sɨmiir iikamɨm yɨpɨkɨ siir yai aiir wakaeyɨm mɨ sɨma ɨna yaɨngwo tɨbmii kɨɨngiyɨm tɨ yaiyɨm siya boɨnɨm sɨmiiram. Mɨ kɨma tɨ yaiyɨm kara boɨnɨm sɨmiiram naɨngwo tɨbmii kɨɨni mɨ kɨma wɨ kariir kɨgna mɨriiyan inkam nwowi. ");
INSERT INTO iws_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Mɨ mhoɨiya kɨma wɨ haɨni nɨnoknɨnkɨni yaimwokɨyaimwowa. Mɨ ta yaimwokɨyaimwowa kɨmiirɨn wɨ saeya whɨnkɨnsiis haigɨnɨuwi rɨrmiiya dimɨn biyɨeyɨm sɨmiirsi nwowɨm inkamɨn maeyaua mɨi biyɨe mɨriiya saiir hɨr hɨugrɨpkɨikikaiyɨn mɨ ha haiburgigiyɨn, siir hɨriinan. ");
INSERT INTO iws_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Mɨ sɨma ɨna yowarkɨi boɨnɨm, nɨm krɨma Ebrahamni namouwɨm, krɨma bɨiya inkam nwɨrniyɨm nɨɨnga nɨɨnga bɨ swokɨ mɨrii mɨmɨnkɨm. Mɨ kɨra hɨnɨɨn dimusi boɨnkɨn, kɨma wɨ inkamɨn maeyaua mɨi biyɨe mɨriiya saiir hɨr hɨugrɨpkɨikikaiyɨn mɨ hɨr ha haiburgigiyɨn mɨ rɨrmiiya ha nwowiyɨn wɨ siir hɨriinan nwowi. ");
INSERT INTO iws_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Mɨ Jisɨs siya sɨmiir boɨnki, kara kɨmiirɨn yaimwowar boɨnkii, iikam kɨma yɨpɨkɨ dimɨn biyɨe tɨrɨm, yɨm ɨni iikamɨm maeyaua mɨi biyɨe mɨriiya hɨr hɨugrɨpkɨikikaiyɨm dimɨn biyɨeyɨm ini hanɨɨn sɨmiir kwoɨn ɨmiir kwɨrii ɨdwokaiyɨm ɨni sɨmiir hɨriinan ywowɨm. ");
INSERT INTO iws_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Iikamɨm maeyauwa mɨi biyɨe mɨriiya saiir hɨr hɨugrɨpkɨikikaiiyɨm, sɨma dimɨnɨm sɨma naɨngwowiyɨm wɨ tɨr tani. Mɨ inkamɨn yɨpɨkɨ om hɨrar nwowiyɨn yɨo nɨkrani, dimɨnɨn ɨkɨ siya naɨngwowiyɨm tɨram, yɨm wa tɨri. ");
INSERT INTO iws_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Mɨ kara tɨ yɨnisɨmɨn kɨmiirɨn wadɨe tɨr haigɨnɨuwi mɨ kɨma ɨkɨ dimɨn biyɨeyɨm sɨmiirsiyɨn wɨ rɨrmiiyar nwowi mɨ kɨma mhoɨiya wɨ rɨrmiigɨrɨrmiiyar nwoki. ");
INSERT INTO iws_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Kara ɨna nɨnoknɨnkɨnɨn, kɨma Ebraham siir namougɨm. Wɨm kɨma kariir nɨsomaowam tɨri. Dimusi rani, kɨma yaiyɨm kara boɨnmɨmauuɨm sɨmiiram naɨngwo tɨbmii kɨɨn tani. ");
INSERT INTO iws_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Kara kɨmiirɨn yaiyɨm kariir Adɨn bɨiya siya nɨisiisiimauuɨm kariir, sɨmiir boɨnmɨmauuwi. Mɨ wɨm kɨma ɨni dimɨn taemɨnɨm bɨiya kɨmiir ad ɨma boɨnmɨmauuɨm ɨni sɨmiirar swokɨ tɨrɨm. ");
INSERT INTO iws_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Mɨ sɨma siir yai aka hɨnɨɨna yowarkɨi boɨn, krɨmiir adɨn Ebrahamkɨn. Mɨ Jisɨs siya ɨna swokɨ boɨnkiyɨn mɨ kɨma Ebraham siir yɨnisɨmkɨ nɨuwi mɨ kɨma wɨ dimɨn taemɨnɨm siya tɨrɨm wɨ sɨmiir hɨriinanar tɨ tɨr. ");
INSERT INTO iws_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Mɨ tɨ yaiyɨm kara boɨnmɨmauuwɨm, yɨm yaimwowaɨrgɨm, yɨm tɨ yaiyɨm yɨm kara wakaenani ɨma Adi Komii siirɨm. Mɨ wɨm kɨma ɨni hɨriiyar nɨksɨsae krɨpkaiyɨm kariir nɨsomaowamɨn. Abraham siya tɨ hɨriinan siyɨu ɨiir bɨ swokɨ tɨrmɨmɨnkɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Wɨm kɨma dimɨn taemɨnɨm kɨmiir ad ɨma tɨrɨm sɨmiirarar tɨrkɨm. Mɨ sɨma siirɨn ɨni ɨgao yaiyar boɨnkiyɨm, krɨma hɨiyɨn tani. Krɨma ad nwɨruwani yɨnkɨm Adi Komii siirgɨsiirgɨm. ");
INSERT INTO iws_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Mɨ Jisɨs siya sɨmiirɨn hɨnɨɨna boɨn mɨ Adi Komii siya kɨmiir Adgɨ nɨuwi mɨ kɨma kariiram warar timɨ aɨngwokwo, tɨ inkamɨn yɨpɨkɨn Adi Komii siya nɨkrop ɨuungiyɨn nua tɨriir siir om hɨrankɨ. Kara tɨriirɨn kariir kwoɨn ara napam bɨ nɨtkɨn. Kariirɨn siyar nɨkropkikɨn. ");
INSERT INTO iws_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mɨ kɨma tɨ yaiyɨm kara boɨnɨm sɨmiir nɨnoknɨnkɨn karamae dimusi nwokɨm? Kɨma wɨ nɨnoknɨnkɨn tani. Dimusi rani, kɨma, kɨma nwowa saiir hɨriinan nwo rani mɨ kɨma kariir yai aiirɨn wɨ ha wakaeyoknarani. ");
INSERT INTO iws_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Wɨm kɨma kɨmiir adɨn Setan siir yɨnisɨsɨmkɨm. Mɨ wɨm kɨma dimɨn biyɨe biyɨeyɨm siya naɨngwowiyɨm sɨmiirar mɨ aɨngwowikɨm. Mɨ bɨdi bɨdiniyarɨn, siya inkam nɨsomsom aowakɨ waiwigɨn siya mɨiyɨknansɨm bɨ swokɨ omɨn omɨnkɨn. Dimusika, mɨnsika siya sɨmiir whɨnkɨnsiisamɨn yaimwoni wara bɨ boɨnikɨn. Siya nɨksɨsaeyakɨ waiwigɨn, iikamɨm sɨmiir kwoɨn ɨmiir nɨkpɨtmaiyam. Mɨ ɨiya siya nɨksɨsaeiyɨm, siya siir kwoɨn ɨiirar napikɨn. Dimusi rani, siyaɨrgɨn iikamɨm nɨksɨsaeiyɨm sɨmiir adɨn. ");
INSERT INTO iws_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kara kɨmiirɨn yaimwowar boɨni yaiyɨm kara boɨniyɨm kara yaimwo ɨmiirarar boɨni. Kara bɨ nɨksɨsaeikɨn mɨ kɨma sɨmiiram bɨ naɨngwo tɨbmii kɨɨnikɨm. Dimusi rani, kara kɨmiirɨn Setani dimɨn taemɨnɨm sɨm boɨnkɨn. ");
INSERT INTO iws_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Mɨ kɨmiir nwɨrkɨ hɨriinan boɨn karamae dimusi nwowi, tɨ dimɨn taemɨnɨm kara tɨrɨm yɨm kɨpɨii rani, ha? Kara kɨmiirɨn yaimwowar boɨni mɨ kɨma kariiram naɨngwo tɨbmii kɨɨnɨm payop. ");
INSERT INTO iws_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Mɨ tɨriigɨnɨm yɨpɨkɨ Adi Komii siir yɨnisɨsɨm nwowi, yɨm sɨma dimɨn taemɨnɨm Adi Komii siya boɨnɨm sɨmiir wakaeyoknakɨm. Wɨm kɨma Adi Komii siir yɨnisɨm tani mɨ kɨma dimɨn taemɨnɨm siya boɨniyɨm sɨmiir panisi wakaeyoknasi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Mɨ inkam komii komiiyɨm Isrel sɨmiir iikamɨm sɨmiir kɨgɨrkakiyɨm sɨma siir boɨn, bɨiya krɨma kɨriirɨn yaimwowar boɨnkikɨm, tɨ nu haɨmii Samerian inkamɨn, kɨriirɨn yɨu biyɨekɨ bɨdi ii okwokaiyɨn. ");
INSERT INTO iws_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Mɨ Jisɨs siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨn, kariirɨn uridyɨugɨ bɨ nii okwokaigɨn. Kara, kariir Adɨn siir inɨg ɨiirarar hainan praprasi. Mɨ wɨm kɨma kariir swokɨ ɨgbumbuwi mɨ kɨma kariir inɨg ɨiir bɨ hainanikɨm. ");
INSERT INTO iws_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kara dimɨn taemɨnɨm mɨnam bɨ tɨrkɨm, iikamɨm kɨma kariirɨn hɨnɨɨna boɨnɨm, kara inkam wadɨekɨn. Nɨɨngaka. Adi Komii siya iikam kɨmiirɨn wɨ mhoɨiya nɨisiimauuwi kariirɨn hɨnɨɨn kara inkam wadɨekɨn. Mɨ dimɨn taemɨnɨm kara tɨrɨm, wɨ siyar hɨdi. ");
INSERT INTO iws_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kara kɨmiirɨn yaimwowar boɨni, yɨpɨkɨ kariir yaiyɨm kara boɨnɨm sɨmiir naɨngwo tɨbmii kɨɨnɨn yɨo wɨ nao rani. Nɨɨngakɨ, nɨɨngakɨɨnga. Sɨma wɨ omwai hɨriiyar waiyayokiyokɨigiyami. ");
INSERT INTO iws_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Mɨ Isrel sɨmiir inkam komii komiiyɨm, sɨmiir kɨgɨrkakiyɨm, sɨma siir boɨn, krɨma ɨni haɨni yɨnoknɨnkɨnkiyɨm kɨra asi whaowaei, kɨriirɨn uridyɨugɨ bɨdi yɨtkiiyɨn. Mɨ kɨriir kwoɨnɨn siya kiyɨpiyaokiinaowidi. ");
INSERT INTO iws_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Mɨ inkamɨn Ebraham nɨkɨuwiyɨn mɨ profet inkam ɨkɨm yɨpɨkɨ Adi Komii siir yai aiir nowomwarkai haigɨnɨugigɨm yɨm bɨdi yaonamɨm. Mɨ ni kɨra kɨmɨdiniya hɨnɨɨna boɨn, yɨpɨkɨ kariiram naɨngwo tɨbmii kɨɨni wɨ nao rani. Yɨo wɨ omwai hɨriiyar waiyayokiyokɨii. Mɨ kɨra hɨriiyar naɨngwowi Ebraham siya mɨ profet inkam ɨkɨm, sɨmiir kouwɨn ɨni kɨra ywowɨn, ha? Mɨ kɨra hɨriiyar mɨ naɨngwowi kɨra ɨni Adi Komii siir hɨriinan ywowɨn? ");
INSERT INTO iws_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Mɨ Jisɨs siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨn mɨ kara kariir inɨg ɨiirar swokɨ hainan praprasi, yɨo dimɨn komii rani. Kara wɨ hɨriinan tɨr tani, Adi Komii, kariir Adɨn yɨpɨkɨn kɨma boɨnɨn hɨnɨɨn kɨma siiram naɨngwo tɨbmii kɨɨni, siya siyaɨrgɨn kariir inɨg ɨiir hainan praprasi. ");
INSERT INTO iws_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kɨma ha boɨnkɨm, kɨma siirɨn ɨna nɨnoknɨnkɨnɨn mɨ kɨma siiram naɨngwo tɨbmii kɨɨn tani. Nɨɨngaka. An kara siirɨn ɨna nɨnoknɨnkɨnɨn mɨ kara ɨna mɨ wakaeyokna aɨngwo tɨbmii kɨɨnɨn siiramɨn. Mɨ kara ha boɨni, kara siir bɨ nɨnoknɨnkɨnkɨn. Kara wɨ iikam kɨmiir hɨriinanar pɨ mɨ owɨn nɨksɨsaeyan inkam. Nɨɨngaka. Kara siirɨn ɨna nɨnoknɨnkɨnɨn mɨ kara siiram asi wakaeyokna aɨngwo tɨbmii kɨɨni. ");
INSERT INTO iws_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Kɨmiir brougaeyɨn Ebrahamɨn mɨnam naɨngwokwonanaekɨn, ɨiya kara haiburgigana Adi Komii siir om ɨiir mɨ nua tɨriir nɨtɨm, inkam nauunɨ oniyɨm nuan iikamɨm kɨmakar. Siya bɨdi yɨnoknɨnkɨnɨn mɨ siir kwoɨnɨn maɨrgɨmaɨrga komiigak asi nwokɨn. ");
INSERT INTO iws_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Mɨ Isrel sɨmiir inkam komii komiiyɨm sɨma siir boɨn, kɨra waibiyɨe bɨ nikɨ okɨn mɨ kɨra Ebraham siirɨn ha kɨgɨn, aniya? Kiya, nipi nɨksɨsaei. ");
INSERT INTO iws_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Mɨ Jisɨs siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨn, kara kɨmiirɨn yaimwowar boɨni, bɨiya Ebraham siir yopiiya siir naokaina, ankara hɨriiyar nwokɨn. ");
INSERT INTO iws_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Mɨ tɨ yaiyɨm siya boɨnɨm sɨmiir mhoɨiya, kamɨm siiya ɨna haiyɨm siir kaiyɨmɨk aowam. Mɨ Jisɨs siya idowɨiya bɨ nwokɨn. Mɨ siya omaka Adi Komii siir inɨg hainaniya saiir haiburgigɨn mɨ ɨna yapnaniyamɨn idowɨiya hɨriir. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Mɨ Jisɨs siya ha napnamɨn sasar mɨ siya inkam nhwokwɨsaeyɨn siir kɨg, siir yopiiya siirɨn hɨriinan nhwokwɨsaeyar naokainakika. ");
INSERT INTO iws_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma siir srɨi, inkamɨn nowomwarkaiyɨuwiyɨn, siyɨu biyɨe nhɨnga tɨrkɨn, tɨ inkamɨn siir yopiiya siirɨn hɨriinan nhwokwɨsaeyar naokainaɨn. Siyar, iyɨe? Siir yopii ad owa? ");
INSERT INTO iws_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Mɨ Jisɨs siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨn, tɨ inkamɨn mɨ siir yopii ad owa sɨmani dimɨn biyɨe bɨ tɨrkɨm? Siya nhwokwɨsae hɨriiyar nwokɨn. Dimusi rani, Adi Komii siya siirɨn wɨ dimɨn kɨbikɨ kɨbi ɨiir tɨrhaigɨnɨuwi, iikamɨm sɨmiir nɨisiimauuwam. ");
INSERT INTO iws_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Krɨma Adi Komii siir dimɨn taemɨn ɨmiirar tɨrkrɨpkai, inkamɨn yɨpɨkɨn kariir nɨkropkiyɨn tɨriirɨn. Krɨma tɨ ɨiyɨm siya nɨmbingiyɨm krɨmiir hɨriiyar tɨr. Dimusi rani, mhoɨiya ta ɨi aeya nɨti, iikamɨm sɨma wɨ tɨ hɨriinan dimɨn ɨiir tɨr tani. ");
INSERT INTO iws_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mɨ kara tɨ nu tɨrar nikɨ owɨn, kara ɨni paenan nɨuya haigɨnɨunan ywowɨn, iikamɨm sɨmiir siyɨu ɨiir. Kara sɨmiirɨn Adi Komii siir dimɨn taemɨn ɨmiir nɨisiimauuwi. ");
INSERT INTO iws_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Mɨ tɨ yaiyɨm siya boɨnɨm, sɨmiir mhoɨiya siya yaeyopa nu hɨriir ha yaskiigiyɨn mɨ siya kɨmɨdiniya nu ɨnakar yɨnkɨn hɨubrombropki nu bropaɨr nwokiyam. Mɨ siya kɨmɨdiniya siir nhwo ɨiir yakɨ ɨtɨmakɨugiyɨn. ");
INSERT INTO iws_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Mɨ tɨ siya nɨtɨmakɨugiyɨn inkamɨn siir nhwona ɨiir saiir mhoɨiyaɨn, siya siir boɨnki, kɨra whɨiya Siloam nɨkɨuwiya saiir tani whaunaki. ");
INSERT INTO iws_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mɨ siya ha swokɨ ɨtɨn mɨ iikamɨm saɨka kingiin hɨr nwowɨm mɨ iikam nhɨrɨm yɨpɨkɨ siir kɨgɨm, siya nu hɨr nɨdwowɨn umɨram iikam ɨmiiram kauɨn, sɨma, sɨma sɨmar yɨnsrɨi ansrɨina, tɨ inkamɨn bɨiya hɨr nɨdwowɨn mɨ umɨram iikam ɨmiiram kauɨn siir hauuwam mɨ tari siyaɨrgɨn tɨ inkamɨn, iyɨe? Si rani? ");
INSERT INTO iws_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mɨ iikam nhɨrɨm sɨma boɨn, tɨ inkamɨn siyaɨrgɨn nu hɨr nɨdwowɨn krɨmiiram kauɨn. Mɨ nhɨrɨm sɨma boɨn. Nɨɨngaka. Tɨ inkamɨn si rani, siir whwonkamɨn tɨ inkamɨn nhwokwɨsae nwowɨn siir whwonkamnankɨn. ");
INSERT INTO iws_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Mɨ siya sɨmiir boɨnki, karaɨrgɨn, tɨ inkamɨn bɨiya nhwokwɨsae nikɨ owɨn. Mɨ ta siya boɨnkiya sɨmiir saiir mhoɨiyan, sɨma kɨmɨdiniya siir srɨi, kɨra panɨɨn panɨɨna tɨrkɨn wara kɨriir nhwoɨn wadɨe nwokiyɨn mɨ kɨra hɨnda tɨnda ha kɨgomokiyɨn? ");
INSERT INTO iws_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Mɨ siya sɨmiir boɨnki, inkamɨn Jisɨs nɨkɨuwiyɨn siir yaeyopa nu hɨriir ha yaskiigiya mɨ siya kɨmɨdiniya nu ɨnaka yɨnkɨn hɨubrombropki, brop nwokiyam mɨ mhoɨiya siya kɨmɨdiniya kariir nhwo ɨiir yakɨ ɨtɨmakɨugi. Mɨ siya ɨna boɨnkiyɨn kariirɨn, kɨra kɨriir whwonkamɨn whɨi Siloam saiir tani whausoknaki. Mɨ ta saiir mhoɨiyan, kara ɨna yamɨn kariir nhwo ɨiir whausoknakiyɨm. Mɨ kariir nhwoɨn ɨni ta saiirsiyar kɨgomokiyɨn, hɨnda tɨnda. ");
INSERT INTO iws_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Mɨ ta siya boɨna saiir mhoɨiya, sɨma siir srɨi, siya ɨni papi nwowɨn? Mɨ siya ɨna yowarkɨi boɨnkiyɨn, kara siir nɨnoknɨnkɨn tani. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Mɨ mhoɨiya sɨma tɨ inkamɨn bɨiya nhwokwɨsae nikɨ owɨn siir yɨkɨunam, Farisi kamɨm sɨmiiram yɨpɨkɨ Mosesni siyɨuɨm sɨm sɨbgu ɨnoknɨnkɨniyɨm. ");
INSERT INTO iws_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Mɨ ɨiya Jisɨs siya nu bropaɨrɨn tɨ inkam nhwokwɨsaeyɨn siir nhwo ɨiir nakɨ ɨtɨmakɨugiyɨn mɨ siir nhwoɨn wadɨe ha swokɨ okiyɨn mɨ siya ɨna dikaoraekaokiyɨn hɨnda tɨndaɨn. Siya tɨ dimɨnɨn Juda sɨmiir ɨi komiiya pɨu siiskuwakiya dimɨn taemɨn tɨr karamae nwowiya Sabat saiir tɨrkɨn. ");
INSERT INTO iws_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mɨ siya hɨriirɨn sɨmakar yam Farisi kamɨm sɨmiir kɨgamɨn. Mɨ sɨma kɨmɨdiniya siir srɨi siya sɨmiir swokɨ boɨnmauuɨm, siya wadɨe panɨɨn panɨɨna nwokikɨn, tɨkɨ sɨbgu kɨgomokiyɨn. Mɨ siya ɨna yowarkɨi boɨnɨn, kariir nhwonaɨn inkam nwɨrɨn nu bropaɨrɨn siya nɨtɨmakɨu haigɨnɨugikɨn mɨ kara op ha nani whausoknakiyɨn mɨ kara hɨnda tɨnda ɨna prɨikɨgomokiyɨn. ");
INSERT INTO iws_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mɨ Farisi sɨmiir iikamɨm sɨmiir nhɨrɨma boɨn tɨ inkamɨn Adi Komii siya bɨ nɨkropkikɨn. Nɨɨngaka. Dimusi rani, siya mɨi Juda sɨmiir ɨi komiiya pɨu siisiya dimɨn taemɨn whɨr tɨr karamae nwowiya Sabat saiir mɨriigɨn. Mɨ siya Moses siir siyɨu komii ɨiir bɨ napkɨn. Mɨ nhɨrɨm sɨma boɨn mɨ siya uridyɨugɨswo wɨ tɨ hɨriinan dimɨn mɨiyɨk mɨiyɨk ɨmiirar pɨ tɨrɨn? Mɨ sɨma, sɨma sɨmarɨn isido whɨsa yɨinɨbɨr. Nhɨrɨm yɨm hɨnɨɨna boɨn, Jisɨs siya inkam paii rani mɨ nhɨrɨm sɨma boɨn, siya inkam wadɨekɨn. ");
INSERT INTO iws_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mɨ sɨma inkamɨn bɨiya nhwokwɨsae nikɨ owɨn, siir srɨigi, kɨra panɨɨna naɨngwowi inkamɨn wadɨe kɨriir nhwo ɨiir nwowaigɨnɨugiyɨn, ha? Mɨ siya sɨmiirɨn hɨnɨɨna boɨnki, siya profet inkamkɨn? ");
INSERT INTO iws_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Mɨ Isrel sɨmiir kɨgrɨraowiyɨm inkam komii komiiyɨm, sɨma tɨ inkam ɨiir bɨ nɨnoknɨnkɨnkɨm mɨ sɨma panɨɨnsi yaɨngwo tɨbmii kɨɨnsi hɨnɨɨn, tɨ inkamɨn bɨiya nhwokwɨsae nikɨ okɨn mɨ tariinanɨn siya ɨna sɨbgu kɨgɨmokiyɨn. Mɨ sɨma tɨ yaiyɨm siya boɨnɨm sɨmiir bɨ naɨngwo tɨbmii kɨɨngɨm. Sɨma wɨ siir yopii ad owiirar srɨi ɨski. ");
INSERT INTO iws_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Mɨ sɨma sowiirwai srɨi, ana tɨriigɨnɨn kowiirwai yɨnisɨmkɨn kowawaiyɨn hɨriinan nhwokwɨsaeyar naokainakikɨn siirɨn? Mɨ siya panɨɨn panɨɨna kɨgɨmokikɨn, tariinanɨn tɨ dimɨn taemɨn ɨmiir kɨgomokiyɨn? ");
INSERT INTO iws_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Mɨ siir yopii ado sowawai boɨn sɨmiirɨn, krɨra ɨna nɨnoknɨnkɨno, tɨriigɨnɨn krɨriir yɨnisɨmkɨn yɨpɨkɨn krɨrawai naokainakiyɨn siirɨn hɨriinan nhwokwɨsaeyar naokainakikɨn. ");
INSERT INTO iws_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Krɨrawaiyɨn nɨnoknɨnkɨn tani siya panɨɨna nanao kaowɨrɨrkikɨn, siya tɨ dimɨn taemɨnɨm sɨmiir sɨbgu kɨgomokiyɨn. Krɨra nɨnoknɨnkɨn tani, siirɨn nhɨnga namsi tɨr haigɨnɨugikɨn siya tɨ dimɨn taemɨnɨm sɨmiir sɨbgu kɨgomokiyɨn. Kɨma siir srɨi. Siya inɨkamae bɨdiyar ywowɨn, pɨ siyar nwokɨ boɨnɨm. ");
INSERT INTO iws_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Mɨ siir yopii ado sowa hɨriinan yai asi boɨnko, sowa Isrel sɨmiir inkam komii komiiyɨm sɨmiir iikamɨm sɨmiir kɨgɨrkakiyɨm sɨmiirsi nɨdidgo. Inkam komii komiiyɨm bɨiya sɨma hɨnɨɨna boɨnkɨm, inkam nwɨrkɨ ha boɨni, Jisɨs siya Kraiskɨn, yɨpɨkɨ iikam ɨmiir whɨnkɨnsiis haigɨnɨuuwam nɨtɨn. Mɨ sɨma sowiirɨn omaka yaimɨn dimɨn nɨdwokai wakaeiya wɨ saiir hɨriir kɨgnɨnkɨn apnɨnopkaigi rani. ");
INSERT INTO iws_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Mɨ siir yopii ado sowawaiyɨn bɨdiyar yɨnoknɨnkɨno siirɨn. Mɨ sowawaiyɨn sɨmiir boɨnki, siya inɨkamae bɨdiyar ywowɨn, kɨma siirar srɨi. ");
INSERT INTO iws_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Mɨ sɨma ɨna swokɨ ɨkɨunaɨn tɨ inkamɨn yɨpɨkɨ bɨiya nhwokwɨsae nikɨ owɨn siiram. Mɨ sɨma siirɨn ɨna boɨnɨm, kɨra Adi Komii siir hainanprapraski mɨ mɨpi yaimwowar boɨnki. Krɨma ɨna nɨnoknɨnkɨnɨm tɨkɨ inkamɨn siya Adi Komii siir siyɨugɨ siyɨu ɨiir sɨbgu ap rani. Kɨra hɨnɨɨna dɨnoknɨnkɨn warɨ inkamɨn, yɨo inkam paii rani. ");
INSERT INTO iws_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Mɨ siya sɨmiir boɨn, kara nɨnoknɨnkɨn tani tɨkɨ inkamɨn siya wadɨekɨ piyamisi owɨn, iyɨe? Mɨiyɨk rani. Kara tɨ siirarar nɨnoknɨnkɨni, bɨiya kara nhwokwɨsae nwokɨn mɨ tariinanɨn kara ɨkɨ digworaekwo whɨekakɨm sɨmiirɨn ɨna sɨbgu kɨgomokiyɨm. ");
INSERT INTO iws_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Mɨ sɨma siirɨn ɨna swokɨ srɨiyɨm, siya kɨriirɨn dimu dimɨn tɨrkikɨn? Mɨ siya kɨriir nhwo ɨiirɨn wadɨe panɨɨna nwowaigɨnɨugigɨn? ");
INSERT INTO iws_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Mɨ siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨn, kara kɨmiir bɨdiyar ikɨ boɨnmauuwɨn. Mɨ kɨma bɨ sɨbgu wakaekɨm. Mɨ kɨma pɨ ɨdɨp ɨdɨp wakaeyam dimuam swokɨ tɨri? Mɨ kɨma siir wakaeyokna apam naɨngwowi, aniya? ");
INSERT INTO iws_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Mɨ tɨ siya boɨnkiya hɨriinan saiir mhoɨiyan mɨ sɨma siirɨn yai mɨiyɨkni bɨ boɨnkikɨm, sɨma hɨnɨɨna boɨnki mɨ ni kɨra tari siir yai aiir mɨ wakaeyokna apam mɨ tɨri. Nɨm krɨma nɨɨngaka. Nɨm krɨma Mosesni mɨiyɨm si wɨngikɨm sɨm wakaeyokna apikɨm. ");
INSERT INTO iws_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Krɨma Adi Komii siir mɨiyɨm Mosesni boɨnɨm siya wɨnam sɨmiirarar nɨnoknɨnkɨni. Mɨ warɨ inkam paeprikab hɨriinanɨn krɨma siir nɨnoknɨnkɨn tani, siirɨn nhɨnga nɨkropkikɨn tɨriirɨn. ");
INSERT INTO iws_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mɨ tɨ inkamɨn siya sɨmiir boɨn, tɨ dimɨnɨn yɨo ɨni saɨka sa ywowɨn. Kɨma nɨnoknɨnkɨn tani siirɨn nhɨnga namisi ɨkropkikɨn. Siya nɨtkɨn mɨ kariir nhwoɨn wadɨe siya nwowaigɨnɨugikɨn. ");
INSERT INTO iws_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Krɨma tɨ siirɨn ɨna nɨnoknɨnkɨnɨn, Adi Komii siya tɨ hɨriinan inkam biyɨeyɨm dimɨn taemɨnam siiram srɨiiyɨm sɨmiir yai bɨ swokɨ wakaeikɨn. Siya ɨkɨ iikam mɨiyɨk mɨiyɨkɨm yɨpɨkɨ siir kwoɨn ɨiirara napiyɨm, sɨmiir yai ɨmiirarar wakaeikɨn. ");
INSERT INTO iws_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Mɨ bɨdi bɨdiniyarɨn ɨiya Adi Komii siya nu ɨiir nonkwokwokiyɨn mɨ ɨni tariinanar yadɨgniyɨn, krɨma hɨriinan bɨ swokɨ wakaemɨmɨnkɨm, inkam nwɨrɨn, inkamɨn nhwokwɨsae nwowiyɨn siir bɨ swokɨ whɨndiraerarkɨn, siya sɨbgu kɨgomokiyɨm ɨkɨ dimɨn taemɨnɨm sɨm. ");
INSERT INTO iws_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Mɨ tɨ inkamɨn Adi Komii siya nɨkropki karamaekɨswo siya wɨ tɨ hɨriinan dimɨn mɨiyɨkar pɨ tɨrɨn? Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Mɨ tɨ kamɨm sɨma siir boɨnki, kɨriir yopiiya kɨriir naokainakiya, saeya kɨriirɨn siyɨu biyɨeyan inkam naokainakikɨn. Mɨ tariinanɨn kɨra dimɨn taemɨn krɨmiir nɨisiimauuwam tɨri, aniya? Mɨ ta sɨma boɨna hɨriinan saiir mhoɨiyan sɨma siir yɨkɨdu mɨ sɨma siirɨn omaka yaimɨn dimɨn nɨdwokai wakaeiya saiir hɨrankar yɨkropki. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Mɨ Jisɨs siya hɨriinan wakaewɨnɨn, sɨma siirɨn idowɨiya hɨriir nɨkrop apnikiyɨm mɨ siya kɨmɨdiniya siiram hansɨram. Mɨ mhoɨiya siya siir hansɨryɨskaiyɨn mɨ siya kɨmɨdiniya siir srɨi, kɨra inkamɨn Adi Komii siya nɨkropkiyɨn siir om hɨrankɨn, kɨra siiramɨn ɨna naɨngwo tɨbmii kɨɨnɨn? ");
INSERT INTO iws_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mɨ tɨ inkamɨn ɨna yowarkɨi boɨnɨn Bɨiyan Inkam Komii, kɨra kariir boɨnmauu tɨ inkamɨn siya yɨpɨkɨn mɨ kara pɨ siir yai aiir nikɨ wakaeyokna apɨm. ");
INSERT INTO iws_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Mɨ Jisɨs siya siirɨn hɨnɨɨna boɨn, kɨra siir bɨdiyar ikɨ kɨgɨn tɨ siyaɨrgɨn tɨ kɨnaka boɨnaiyɨn. ");
INSERT INTO iws_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Mɨ tɨ inkamɨn siir yai akan hɨnɨɨna yowarkɨi boɨn, Bɨiyan Inkam Komii, kara ɨna naɨngwo tɨbmii kɨɨnɨn kɨraɨrgɨn inkamɨn Adi Komii siir om hɨranɨn. Mɨ siya ogmwo ha waisii hɨunanaiinamɨn mɨ siya kɨmɨdiniya siir inɨg ɨiir hainan. ");
INSERT INTO iws_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Mɨ mhoɨiya Jisɨs siya ɨna boɨnɨn, kara tɨ nu ɨiirɨn mɨnam nɨtkɨn iikamɨm yɨpɨkɨ Adi Komii siiram naɨngwo tɨbmii kɨɨnɨm mɨ iikamɨm yɨpɨkɨ siiram naɨngwo tɨbmii kɨɨn karamae nwowɨm sɨmiir hɨdam. Kara tɨriirɨn mɨnam nɨtkɨn ɨkɨ iikamɨm yɨpɨkɨ Adi Komii siir nɨnoknɨnkɨn karamae nwowɨm yɨpɨkɨ ɨkɨ iikamɨm nhwokwɨsae nwowɨm sɨmiir hɨriinan nwowɨm sɨmiir whɨnkɨnsiis haigɨnɨuwam nɨtkɨn. Mɨ sɨma wɨ siiram nwokɨ sɨbgu aɨngwo tɨbmii kɨɨnɨm. Kara mɨnam nɨtkɨn iikamɨm yɨpɨkɨ ha naɨngwowɨm, sɨma Moses siir siyɨu komiiyɨn siir yai ɨmiir bɨdi sɨbgu ɨnoknɨnkɨnɨm, iikamɨm sɨbgu kɨgomokiyɨm sɨmiir hɨriinan. Kara sɨmiir nɨisiimauuwam nɨtkɨn. Tɨriigɨnɨm, yɨpɨkɨ Adi siiram naɨngwo tɨbmii karamae nwowɨm ɨkɨ iikamɨm nhwokwɨsae nwowɨm sɨmiir hɨriinan, sɨma nwowa saiir hɨriinan. ");
INSERT INTO iws_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mɨ Farisi kam nhɨrɨm yɨm saɨka hɨr warar nɨnkɨn okwokɨm mɨ sɨma bɨdi wakaekiyɨm dimɨn taemɨnɨm siya boɨnkiyɨm mɨ sɨma kɨmɨdiniya siir boɨn mɨ kɨra hɨriiyar naɨngwowi nɨm krɨma ɨriipɨ hɨriinan nhwokwɨsaekɨm tɨ iikamɨm sɨmiir hɨriinan, aniya? ");
INSERT INTO iws_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Mɨ Jisɨs siya sɨmiir boɨnki, kɨmiir kwoɨnɨm ɨni tɨ iikamɨm nhwokwɨsae nwowɨm ɨni sɨmiir hɨriirnan ywowɨm. Mɨ ta hɨriinan saiirsika, kɨmiirɨn wɨ Adi Komii siya boɨnwokiyopnatkaigi rani. Mɨ wɨm kɨma ɨinokɨinokɨn hɨrii hɨriiyar boɨnɨnaeikɨm, kɨmiir mhɨi kwoɨnɨm dimɨn whɨrkɨ swokɨ kɨnyɨskai rani. Mɨ kɨma ɨna nɨnoknɨnkɨnɨm Adi Komii siirgɨsiir dimɨn taemɨn ɨmiirɨn. Mɨ hɨriinankɨ nɨuwi kɨmiirɨn Adi Komii siya boɨnwokiyopnatkaigiyɨm wɨ dɨgar nwowi. Mɨ kɨmiir dimɨn biyɨeyɨm wɨ haiyoprimdiyɨumiigi rani, sɨma wɨ hɨriiyar nwokrɨpkaii. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Kara kɨmiirɨn yaimwowar boɨnkii, inkamɨn hira sibsib ɨmiir hɨuyokiyokaiiya saiirgɨsaiir ano ɨiir napnɨnopkainam karamae nwowi mɨ siya hinda kaina iiyami hir aiirɨn, yɨo tɨ hɨriinam siyɨuɨn, yɨo ɨni inkamɨn digworaekwo tauaehaiyam namiyɨn ɨni siir hɨriinan ywowɨn. ");
INSERT INTO iws_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Mɨ inkamɨn anokɨ ano ɨiirar napnɨnopkainamiyɨn, yɨo siya inkamkɨ inkamɨn sibsib ɨmiir kɨgrɨraowikɨn. ");
INSERT INTO iws_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mɨ inkamɨn ta hira saiir anowɨn napnɨnopkainamiyɨn siir kɨgrɨraowiyɨn, siya pɨ tɨ inkam ɨiir kɨgwɨni, siya siirɨn pa kɨgnɨnkɨn apnɨnopkaigi. Mɨ sibsibɨm pɨ siir yai aiir wakae sɨbgii mɨ siya sibsibɨm sɨmiir inɨgɨm ɨrɨra ɨrɨra pa dapkii mɨ siya sɨmiirɨn pa whɨnapnaniyami idowɨiya hɨriir. ");
INSERT INTO iws_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Mɨ siya siir sibsib ɨmiirɨn pa nɨkɨunaniyami mɨ sɨmiir bɨiyɨn pɨ siyar nwonami. Mɨ tɨ sibsibɨm siir mhoɨiya asi sɨdkaenamkɨm. Dimusi rani, sɨmiirɨn siya nɨkɨunaɨm mɨ sɨma siir yai aiir wakaesɨbgiyɨm mɨ sɨma ɨni siir mhoɨiyar sɨdkaenamɨm. ");
INSERT INTO iws_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mɨ inkam nwɨrkɨswo, sɨma wɨ siir di wakaeyoknaei mɨ wɨ siir mhoɨiya di mɨ ami. Nɨɨngaka. Sɨma wɨ siirsi pɨ yɨdidɨn mɨ wa pɨ yɨdamɨn. Dimusi rani, sɨma inkamɨn yɨpɨkɨ sɨmiir kɨgrɨraowiyɨn siir yainan wakaeki rani. ");
INSERT INTO iws_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisɨs siya tɨ yaiyɨm Farisi kamɨm sɨmiirɨn boɨniyɨo yai ara boɨnkɨn. Mɨ sɨma sɨmiir bɨ sɨbgu nɨnoknɨnkɨnkɨm siya tɨriigɨnɨm, yɨo siyar boɨnakɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Mɨ tɨ kamɨm sɨma tɨ dimɨn taemɨnɨm Jisɨs siya boɨnɨm sɨmiir bɨ nɨnoknɨnkɨnkɨm. Mɨ siya sɨmiirɨn ɨna swokɨ boɨnkiyɨn, kara kɨmiirɨn yaimwowar boɨnkii, karaɨrgɨn sibsibɨm sɨmiir anowɨn. Iikamɨm yɨpɨkɨ sibsibnan nwowi mɨ Adi Komii siiramɨn ha nɨti sɨmiirɨn wɨ kara whɨnkɨnsiis haigɨnɨuwi. ");
INSERT INTO iws_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Iikamɨm yɨpɨkɨ bɨiya kariiram nikɨ ɨtɨm Isrelmi iikamɨm sɨma kɨgrɨraowɨm, yɨm hɨiyan iikam nikɨ okɨm. Sɨma ɨinokɨinokɨn sibsib ɨmiir tauaehaiyamar nɨtikɨm. Mɨ sibsibɨm sɨmiir yai ɨmiir bɨ swokɨ wakae sɨbgɨm. Mɨ iikamɨm yɨpɨkɨ Adi Komii siir sibsibnan nwowɨm yɨm wɨ tɨ hɨriinan inkamɨm sɨmiiram kɨpi naɨngwo tɨbmii kɨɨn. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Anowɨn karaɨrgɨn. Mɨ yɨpɨkɨ kariiram naɨngwo tɨbmii kɨɨnɨn yɨo ɨni sibsibɨn hira saiirgɨsaiir ano ɨiir napnɨnopkainaniyɨn ɨni siir hɨriinan ywowɨn. Mɨ ta hɨriinan saiirsika, siirɨn wɨ asi nanmaiwarkainaei. Mɨ mhoɨiya siya idowɨiya nami mɨ siya wraisu nae mɨ kɨi mɨnɨm sɨmiir kɨgi mɨ wɨ haɨni naei. ");
INSERT INTO iws_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mɨ yɨo hɨiyan inkamɨn, yɨo dimɨn taemɨn ɨmiir tauaehainaki aramar nɨtikɨn. Mɨ sibsib ɨmiir nɨsomsom aokaogig mɨ digworaekwo ɨmiir nonkwobumbunɨnkɨngig aramar nɨti. Mɨ tɨ kara nɨtɨn sɨma wɨ nao rani, sɨma wɨ omwai waiyayokiyokɨi siyɨuɨn Adi Komii siya naɨngwowɨn siir. ");
INSERT INTO iws_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Kara ɨni inkam mɨiyɨkɨn sibsib sɨbgu kɨgrɨraowiyɨn ɨni siir hɨriinan ywowɨn. Kara wɨ mɨnsi naowi, kariirgɨ kariir sibsibɨm sɨmiir whɨnkɨnsiis haigɨnɨuwam wadɨe sɨma sɨbgu owam. ");
INSERT INTO iws_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mɨ tɨ mɨiyan inkamɨn yɨpɨkɨn umɨr aramar mɨriiyɨn, yɨo inkamɨn sibsibgɨ sibsib kɨgrɨraowiyɨn si rani. Mɨ sɨma wɨ siir sibsib nwo rani. Mɨ siya niimauan wra biyɨeyɨn siir kɨgwɨni mɨ siya siirsi nɨdidwɨni mɨ wa nɨdamnani. Mɨ niimauan wra biyɨeyɨn pɨ sibsib ɨmiir nɨnkɨn aeyokiyoknami. Mɨpi siya sɨmiir ɨrni yonkwo, ɨkɨ nhɨrɨm yɨmba kakɨdamkii hɨnda tɨnda. ");
INSERT INTO iws_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mɨ tɨ inkamɨn tɨ hɨriinan nɨdamamɨn, yɨo siir sibsib ɨmiiram bɨ naɨngwowikɨn. Yɨo siya sibsib ɨmiirɨn umɨraramar kɨgrɨraowi. ");
INSERT INTO iws_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Kara ɨni inkam kɨbiyɨn sibsib sɨbgu kɨgrɨraowiyɨn ɨni siir hɨriinan ywowɨn. Kara tɨ iikamɨm kariir sibsibnan nwowɨm sɨmiirɨn ɨna sɨbgu ɨnoknɨnkɨnɨm mɨ sɨma ɨna mɨ sɨbgu ɨnoknɨnkɨnɨm tɨkɨ iikamɨm yɨpɨkɨ kariir sibsibnan nwowɨm sɨmiirɨn. Mɨ sɨma kariirɨn ɨna nɨnoknɨnkɨnɨm mɨ ɨna naɨngwo tɨbmii kɨɨnɨm kariirɨm. ");
INSERT INTO iws_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Kara mɨ kariir Ad ɨeya krɨraniyɨn, krɨra krɨra ɨna sɨbgu ninan ɨnoknɨnkɨnao. Mɨ krɨra nwɨrni nwɨrniyamɨn ɨna ninan aɨngwokwowo. Mɨ krɨra ɨni nwɨruwar ywowɨskiyo. Mɨ tɨ hɨriinan siyɨuɨn, kara ɨna nɨnoknɨnkɨnɨn tɨriirgɨnɨm yɨpɨkɨ kariir sibsibnan nwowɨm mɨ sɨma kariirɨn ɨna mɨ ɨnoknɨnkɨnɨm. Kara mɨ kariir sibsib ɨma krɨma krɨma ɨrni nwɨrniyamɨn ɨna ninan aɨngwokwonam. Mɨ kara wɨ hɨriirnansi naowi sɨmiir whɨnkɨnsiis haigɨnɨuwam. ");
INSERT INTO iws_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mɨ ɨkɨ iikam nhɨrɨm kariir sibsib nwowɨm, yɨm sɨma kariir pɨugana Isrel sɨmiir iikam tani. Kara sɨmiirɨn wɨ tɨkɨ nhɨr ɨmakar nɨnkɨn kɨgrɨraowi. Mɨ sɨma kariir yai aiir wakaei mɨ sɨma wɨ kariir siyɨu ɨiirar napi. Mɨ mhoɨiya sɨma wɨ pɨugan kwɨruwar nwowi. Mɨ sɨmiirɨn wɨ kanakanar kɨgɨrkaki. ");
INSERT INTO iws_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Kariir Adɨn siya kariiramɨn ɨna naɨngwokwonanaeiyɨn. Dimusi rani, kara iikam ɨmiirsi naowam naɨngwokɨn. Mɨ kara wa swokɨ ɨnsiin ɨdwowi mɨ wɨ omwaiyar swokɨ waiyai. ");
INSERT INTO iws_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kariirɨn wɨ inkam nwɨrkɨ tɨr tani, kara naowamɨn. Nɨɨngaka. Kara kariir kwoɨn ɨiirar nwowi. Tɨ dimɨn taemɨnɨm Adi Komii siyar boɨnkikɨm mɨ kara asi tɨri sɨmiirɨn. Kariirɨn siyar bɨdi boɨnki ɨskiyɨn naowamɨn mɨ kariirɨn wɨ siyar swokɨ kiwaki omwai kara swokɨ waiyayokiyokɨiyamɨn. ");
INSERT INTO iws_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Mɨ Isrel sɨmiir inkam komii komiiyɨm isido whɨsa yɨinɨkibɨr mɨ sɨma ta yai aiir yɨnkɨnyaeyo boɨn. Nhɨrɨm, yɨm sɨma dimɨn whɨr boɨn mɨ nhɨrɨm yɨm sɨma dimɨn whɨr mɨ boɨn. ");
INSERT INTO iws_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mɨ iikam whɨekak ɨma boɨn, siirɨn uridyɨugɨ bɨdi ii okwokaiyɨn mɨ siir kwoɨnɨn siya kiyɨpiyaokii. Mɨ siya tɨ hɨnɨɨn dimɨn taemɨnɨm sɨm asi prɨiwhaowae boɨni. Mɨ kɨma waraur dimusi nokwowi siir yai aiir wakaeyamɨn? ");
INSERT INTO iws_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Mɨ nhɨrɨm sɨma boɨn, siir yaiyɨm siya boɨnɨm, siya ɨkɨ inkamɨn uridyɨugakɨn siir hɨriinan swokɨ boɨn tani. Nɨɨngaka. Uridyɨu biyɨeyɨn tɨ inkam nhwokwɨsaeyɨn siir nhwonaɨn pɨ hɨriinan wadɨe di swokɨ ohaigɨnɨuwi, ɨkɨ dimɨn taemɨnɨm sɨm sɨbgu dikaoraekaokiyamɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jisɨs siya tɨ dimɨnɨm om komii Jerusalem hɨr boɨnkɨn, ɨiya iikamɨm ɨrɨpa sɨma haɨngiriyɨu owa saiir. Ta ɨiya sɨma swokɨ aɨngwokiya kamɨm sɨmiir digworaekwo biyɨe ɨmiir nɨinɨkinhɨmnhɨɨn ɨtkiigɨigiya Adi Komii siir inɨg hainaniya omaka saiir hɨrankɨn mɨ saeya bɨdi swokɨ haiwaokiya Adi Komii siir inɨg ɨiir hainanam. Mɨ ta ɨiya ya naopii ɨiga. ");
INSERT INTO iws_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jisɨs siya omaka Adi Komii siir inɨg hainaniya Solomongɨ si mɨriiya saiir ɨuru aiir naprɨrɨrkɨn. ");
INSERT INTO iws_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Mɨ ɨiya siya hɨrar nikɨ aprɨrɨrɨn mɨ Isrel sɨmiir inkam komii komiiyɨm ha nɨtɨm kɨmɨdiniya siir inɨ kaiyokaini mɨ sɨma ɨna srɨiyɨm mɨ kɨra tɨ hɨriinan yaiyɨm krɨmiirɨn ɨiyɨm wɨ pariga kɨnanankɨuwi? Kɨra krɨmiirɨn hindara boɨnmauu kɨɨn ɨski, kɨra tɨ inkamɨn Adi Komii siya nɨmbingiyɨn iikam krɨmiir whɨnkɨnsiis haigɨnɨuam siya, iyɨe? Si rani? ");
INSERT INTO iws_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Mɨ Jisɨs siya sɨmiir boɨnki, kara kɨmiir bɨdiyar ikɨ boɨnmauuɨm mɨ kɨma kariir yai aiir bɨ naɨngwo tɨbmiigɨm. Tɨ dimɨn mɨiyɨk mɨiyɨkɨm tɨ kara tɨrɨm, kara kariir Adɨn siir kɨrɨe aiirar mɨrii, tɨriigɨnɨm yɨm mɨn nɨisiimauugɨm kara yɨpɨkɨn. ");
INSERT INTO iws_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Mɨ kɨma kariir yai ɨmiirɨm bɨ naɨngwo tɨbmii kɨɨngɨm. Dimusi rani, bɨiya kara kɨmiir bɨdiyar ikɨ boɨnɨm, kɨma kariir sibsib rani. ");
INSERT INTO iws_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Kariir sibsibɨm sɨma kariir yai aiirɨn pa wakaei mɨ ankara sɨmiirɨn ɨrɨra ɨrɨraɨn ɨna nɨnoknɨnkɨnɨn. Mɨ sɨma pɨ kariir yai aiirar mɨ wakaeyoknaei. ");
INSERT INTO iws_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mɨ sɨmiirɨn kara wɨ hɨriinansi whɨnkɨnsiis haigɨnɨuwi. Mɨ sɨma wɨ inɨgak hɨriiyar nwokɨ waiyayokiyokɨikaeyamɨm mɨ sɨma wɨ nao rani. Mɨ kariir iikamɨm sibsibnanɨm, sɨmiirɨn wɨ inkam nwɨrkɨ kariir ɨɨnankɨ nɨspakɨi hainaki rani. Mɨ sɨma kariiram naɨngwo tɨbmii kɨɨn karamae wɨ ha nwo rani. Nɨɨngakɨ, nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Kariir Adɨn yɨpɨkɨn tɨ iikam ɨmiir hauugiyɨn, siyaɨrgɨn ɨkɨ digworaekwo whɨekakɨm sɨmiir kougɨ kou nwowɨn. Mɨ iikamɨm yɨpɨkɨ siir siyɨu ɨiir sɨbgu apɨm sɨmiirɨn wɨ inkam nwɨrkɨ swokɨ ɨspakɨi hai rani, siir ɨɨn ankɨn. Mɨ sɨma siirɨn hɨriinansi nikwowaisiiyɨm wɨ dɨgmɨn dɨgmɨn nwo rani. ");
INSERT INTO iws_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Kara mɨ kariir Ad ɨeya krɨrani ɨni nwɨruwar ywowɨskiyo. ");
INSERT INTO iws_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Mɨ tɨ yaiyɨm siya boɨnkiyɨm sɨmiir mhoɨiyaɨn mɨ Isrel sɨmiir inkam komii komiiyɨm, siiya ɨna yɨuhaiyɨm siir kaiyɨmɨk aowam. ");
INSERT INTO iws_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Mɨ Jisɨs siya sɨmiir srɨigi. Kara tapairɨn dimɨn mɨiyɨk mɨiyɨk kasa bɨ tɨrkɨn, kɨmiir whwonkam ɨdaɨn tɨ dimɨn taemɨnɨm kariir Ad ɨeya nɨmbingiyɨm kara tɨram. Mɨ kɨma siiya kariirɨn pɨkɨ hɨnɨɨn dimɨnɨm sɨmsi kaiyɨmɨkam tɨri? ");
INSERT INTO iws_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Mɨ Isrel sɨmiir kɨgrɨraowiyɨm sɨma siir boɨnki, krɨma siiya tɨ dimɨn kɨbikɨbiyɨm kɨra tɨrɨm sɨmiirsi kaiyɨmɨkam tɨr tani. Nɨɨngaka. Krɨma kɨriirɨn siiya pɨ dimusi kaiyɨmɨk rani, kɨra yai mɨiyɨknan bɨ boɨnkɨn kɨra inkamaɨrgɨn mɨ kɨra hɨnɨɨn dimusi boɨnkɨn, kɨra ɨni Adi Komii siir hɨriinanar swokɨ owɨn. ");
INSERT INTO iws_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Mɨ Jisɨs siya sɨmiir yai akan hɨnɨɨna yowarkɨi boɨn, Adi Komii siir yaiya Yokwo Komii saiir hɨr nwowa hɨnɨɨna boɨnka, iikamɨm sɨma hɨnɨɨna boɨnkɨm, kara hɨnɨɨna boɨnkɨn wɨm kɨma ɨni Adi Komiinan ywowɨm. ");
INSERT INTO iws_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Krɨma ɨna nɨnoknɨnkɨnɨm, Adi Komii krɨmiir Wanɨn siir yaiyɨm Yokwo Komii saiir hɨr nwowɨm yɨm kaimwowaɨrgɨm mɨ sɨma wɨ dɨgmɨn dɨgmɨn nwo rani, sɨmiir kisɨnaɨm. Mɨ Adi Komii siya iikamɨm yɨpɨkɨ siya siiboboɨnɨuɨm siir yai aiir, yɨm sɨma ɨni Adi Komii siir hɨriinan ywowɨm. ");
INSERT INTO iws_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Kariirɨn Adi Komii siyar nɨmbingiyɨn mɨ siya kariirɨn ɨna yɨkropkiyɨn nua tɨriir mɨ kɨma kariirɨn hɨriinan dimusi boɨnkɨm, kara dimɨn biyɨe boɨnmɨmauuwi. Dimusi rani, kara kɨmiirɨn pɨ hɨnɨɨna boɨni, karaɨrgɨn Adi Komii siir yɨnisɨmɨn. ");
INSERT INTO iws_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Mɨ kara dimɨnɨm kariir Adɨn siya nɨmbingiyɨm kariir sɨmiir tɨr karamae nwowi mɨ kɨma wɨ hɨriinan saiirsi nwowi tɨ yaimɨn dimɨnɨm sɨmiiram naɨngwo tɨbmii kɨɨn karamaeyɨn. ");
INSERT INTO iws_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Mɨ kara siir mɨi aiir mɨrii mɨ inkam nwɨrkɨ kariir yai aiirɨm naɨngwo tɨbmii kɨɨn karamae nwowi mɨ kɨra wa tɨ aɨngwo tɨbmii kɨɨn tɨ mɨiyɨm tɨ kara tɨr ɨmiiramɨn. Mɨ kɨma wɨ hɨriinan nwokɨ sɨbgu ɨnomoknɨnkɨnɨm Adi Komii siya mɨ kara krɨra ɨni ɨrɨpar yɨnkiamasuwo. Mɨ krɨra ɨni nwɨruwar ywowɨskiyo. Mɨ krɨriir kwoɨno ɨni whɨruwar ywoki ɨskiyɨn. ");
INSERT INTO iws_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Mɨ sɨma ɨna swokɨ kɨnankɨuɨm siir nonkwoɨm mɨ siirɨn maeyau biyɨeya mɨi biyɨe mɨriiya saiir hɨr hɨugrɨpkɨikikaigigam. Mɨ siya sɨmiir haiburgigɨn mɨ ɨna yamɨn. ");
INSERT INTO iws_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Mɨ siya sɨmiir haiburgigɨn mɨ ɨna swokɨ amɨn. Mɨ siya ɨe Jodan siirar swokɨ iyapidnam mɨ siya kɨmɨdiniya maeyaua bɨiya Jonkɨ si baptais haigɨnɨua iikamɨm sɨm, saiir hɨriir yɨmbiyam. Mɨ siya kɨmɨdiniya hɨr inɨ owou. ");
INSERT INTO iws_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mɨ iikam whɨekakɨm ha nɨtɨm mɨ kɨmɨdiniya sɨma inɨ boɨni, Jon siya iikamɨm makɨniiyɨm sɨmiirɨn hɨriinan dimɨn mɨiyɨk bɨ tɨrkɨn tɨ inkamɨn siir hɨriinan. Mɨ dimɨn taemɨnɨm tɨ inkamɨn siya boɨnmɨmauuwɨm krɨmiir yɨm kaimwowaɨrgɨm. ");
INSERT INTO iws_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Mɨ iikam whɨekakɨm hɨr nwowɨm, sɨma ɨna yaɨngwo tɨbmii kɨɨngiyɨm siyaɨrgɨn Kraisɨn inkamɨn yɨpɨkɨ Adi Komii siya nɨkropkiyɨn, iikam krɨmiir nauunɨ whɨnkɨnsiis haigɨnɨuniyam. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Inkam nwɨrɨn Lasaras nɨkɨuwiyɨn siya om Betani hɨr nwowikɨn mɨ siya makɨniigɨn. Tɨ om Betaniyɨn yɨo omɨn Maria mɨ saiir yaowae aeya Mata sowa nwowi ɨeya. ");
INSERT INTO iws_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ta wiga Maria nɨkɨuwiya bɨiya Bɨiyan Inkam Komii siir ɨga kwɨs owiir naokɨna waɨn pɨuii mɨiyɨk whakiyɨn si mɨ mhoɨiya saeya siir ɨga kwɨs owiirɨn, kɨmɨdiniya saiir kan aiirar swokɨ ɨiyaoki. Mɨ tɨ saiir pomou ɨeya makɨniiyɨn. ");
INSERT INTO iws_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mɨ siir yokmano yaiya ɨna boɨnkiyo Jisɨs siiram, Bɨiyan Inkam Komii, kɨriir nomiiyauɨn kɨra naɨngwokwonanaeiyɨn siya makɨnii. ");
INSERT INTO iws_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Mɨ Jisɨs siya ta yai aiir wakaewɨnɨn mɨ siya ɨna boɨnkiyɨn, Lasaras siya ta ma hɨriinana siya wɨ saiirsi nao rani. Nɨɨngaka. Mɨ tɨ hɨriinan dimɨnɨn siya nɨmbiyami mɨ tɨ iikamɨm wɨ siir inɨg ɨiir hainanprapraskii mɨ sɨma kariir inɨg ɨiirɨn wɨ warar mɨ hainanprapraskii, tɨ Adi Komii siir yɨnisɨmɨn. ");
INSERT INTO iws_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisɨs siya Mata mɨ saiir nomousɨm aeya mɨ Lasaras siya sowiir pomouwɨn sɨmiiram naɨngwokwonanaeikɨn. ");
INSERT INTO iws_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Mɨ Jisɨs siya hɨriinan wakaewɨnɨn, lasaras siya makɨnii mɨ siya bɨ nikɨ amsaugɨn. Mɨ siya maeyaua siya nwowa hɨrarɨn ɨiyɨm kwɨsa swokɨ okɨiyɨunam. ");
INSERT INTO iws_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Mɨ tɨ ɨi kwɨso ha dɨgiyo mɨ siya kɨmɨdiniya kamɨm siir kɨgna mɨriiyɨm sɨmiir boɨn. Humbae, nɨmbi swokɨ ami, Judia nu haɨmii hɨriir. ");
INSERT INTO iws_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Mɨ siir kɨgna mɨriiyɨm kamɨm sɨma siir boɨn, inkamɨn nowomwarkaiyɨuwiyɨn, kɨra tɨ om ɨiir namam swokɨ tɨrɨn, tɨ omɨn siir hɨran kamɨm hɨr nwowiyɨm, sɨma siiyani kɨriir kaiyɨmɨk aowamar nikɨ tɨrkɨm krɨma tɨr mɨ owi pɨ wadɨeyar mɨ owi, aniya? ");
INSERT INTO iws_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Mɨ Jisɨs siya hɨnɨɨna naɨngwokɨn siya paenankɨn mɨ siya sɨmiir boɨnki, aniya ɨigwɨra, ɨi aeya pɨrkɨnkiyɨm mɨ ɨi aeya kakaugiyɨm, aoaɨm ɨuur kwɨskak rani, aniya? Mɨ inkamɨn nabɨe naprɨrɨriyɨn, yɨo bɨ swokɨ akaiikɨn. Mɨ wɨ pa nopi? Dimusi rani, yɨo siya nabɨeyar kɨgomok api. ");
INSERT INTO iws_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Mɨ siya nɨiyaka, napamwii mɨ siya ha nakaii mɨ wɨ pa nopi. Dimusi rani, siirɨn dimɨn whɨkɨ nɨuya haigɨnɨu karamaeka. ");
INSERT INTO iws_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Mɨ tɨ hɨriinan Jisɨs siya boɨnkiya saiir mhoɨiyan, siya sɨmiirɨn ɨna swokɨ boɨnkiyɨn, tariinanɨn Lasaras siya ɨni nhwo whɨnɨn mɨ kara hɨriirɨn, pa nami, siir ninɨ ɨnɨdguɨuwamɨn mɨ siya pa nwokɨ ɨnsiin ɨdwowɨm. ");
INSERT INTO iws_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Mɨ siir kɨgna mɨriiyɨm kamɨm sɨma siir yai akaɨn ɨna swokɨ owarkɨi srɨiyɨm, Bɨiyan Inkam Komii mɨ siya nhwo whɨni mɨ mhoɨiya siya wadɨe ha swokɨ owi mɨ krɨma wɨ tɨrar timɨ o, aniya? ");
INSERT INTO iws_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Mɨ Jisɨs siya hɨnɨɨna boɨnki, lasaras siya bɨdi yaonamɨn mɨ sɨmiir kwoɨnɨn ha naɨngwokɨm siya nhwo whɨni. ");
INSERT INTO iws_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Mɨ dimɨnkɨ dimɨnɨn, Jisɨs siya sɨmiirɨn ɨni haɨni boɨmauunɨskiyɨn. Lasaras siya bɨdi yaonamɨn. ");
INSERT INTO iws_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Mɨ kara maɨrgɨmaɨrga asi nwowɨnkɨn, kara siya naonama kara saɨka hɨr bɨ nwokɨn. Dimusi rani, kɨma wɨ haɨni nɨnoknɨnkɨni kariirɨn Adi Komii siya nɨkropkikɨn tɨriirɨn, ɨiya kara siir whɨnkɨnsiis haigɨnɨuwi. Mɨ tapa krɨma pɨ siiram nami siir ninɨ kɨgɨuwam. ");
INSERT INTO iws_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Mɨ inkamɨn Tumas nɨkɨuwiyɨn, sɨma dapiyɨn siir inɨg whɨrɨn hɨnɨɨngɨn. Ɨtmwoyɨn, siya boɨn, kam nhɨrɨm Jisɨs siir kɨgna mɨriiyɨm sɨmiir, humbae nɨmbi nami inkamɨn nowowarkaiyɨuwiyɨn saɨkar mɨ krɨma pɨ saɨkar nwokɨ aonamɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Mɨ Jisɨs siya ha nɨtɨn mɨ siirɨn hɨran kam ɨma boɨnwɨn, Lasaras siya naonama ɨiyɨm kwiiya yamki. Mɨ krɨma siirɨn ɨni siyano whɨrɨn siir inɨ wokaigigɨn. ");
INSERT INTO iws_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Mɨ om Betaniyɨn, yɨo ɨni om komii Jerusalem siir kingiinar kwowɨn 3 kiromita nanaɨrgɨn. ");
INSERT INTO iws_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Mɨ iikam whɨekakɨm Isrel hɨranɨm ɨna yɨtɨm om Betaniya tɨriir, Mata mɨ Maria sowiir kɨgnakiyam mɨ sowiir ninɨ kɨnsiis haigɨnɨuniyam. Dimusi rani, sowiir pomouwɨn Lasarasɨn bɨdi yaonamɨn. ");
INSERT INTO iws_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mɨ Mata saeya hɨriinan wakaewɨna, Jisɨs siya ɨni nɨtɨn mɨ saeya ha nama, siirɨn siyɨu hɨr yapyɨskaiwɨn. Mɨ Maria saeya ɨni omaka hɨrar ywokiya. ");
INSERT INTO iws_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mɨ Mata saeya Jisɨs siir boɨn, Bɨiyan Inkam Komii, kɨra bɨiya wakaewɨna saiirar nɨtkɨswo mɨ tɨrar ninɨ onikɨswo mɨ kariir pomouwɨn, wɨ di yaowi. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mɨ kara ɨna nɨnoknɨnkɨnɨn, Adi Komii siya dimɨn taemɨnɨm kɨra srɨii siiram, siya wa hauugii kɨriirɨn. ");
INSERT INTO iws_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Mɨ Jisɨs siya saiir boɨnki, kɨriir pomouwɨn siya wa swokɨ ɨnsiin ɨdwowi ɨe hɨrankar mɨ wɨ omwaiyar swokɨ waiyayokiyokɨii. ");
INSERT INTO iws_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mɨ saeya ɨna yowarkɨi boɨna, kara ɨna nɨnoknɨnkɨna, ɨiya dɨg nwokii, ɨiya Adi Komii siya iikam ɨmiir hɨdana, siya wɨ omwaiyar swokɨ waiyai. ");
INSERT INTO iws_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Mɨ Jisɨs siya saiir boɨnki, karaɨrgɨn iikamɨm ɨeyankɨ nɨnsiin ɨdwowiyɨm mɨ omwai ha waiyayokiyokɨiiyɨm sɨmiir bwamkɨ bwamɨn. Mɨ iikamɨm omwai swokɨ waiyayokiyokɨii, sɨma wɨ yaeya kwoɨn wɨn haii. Mɨ yɨpɨkɨ kariir yai aiir wakaeyoknaɨm, sɨma wa naonami mɨ mhoɨiya sɨma wa swokɨ ɨnsiin ɨdwowi ɨe hɨrankar. Mɨ sɨma wɨ omwaiyar swokɨ waiyayokiyokɨii. ");
INSERT INTO iws_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Mɨ yɨpɨkɨ omwaiyar nikɨ waiyai mɨ siya kariiramɨn ha naɨngwo tɨbmii kɨɨni, sɨma wɨ yaeya kwoɨn mɨiyɨk haii mɨ sɨma wɨ omwai hɨriiyar waiyayokiyokɨigiyami. Mɨ kɨra tɨ yai ɨmiiramɨn ɨna naɨngwo tɨbmii kɨɨna? ");
INSERT INTO iws_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mɨ saeya ɨna yowarkɨi boɨna, ɨhɨ, Bɨiyan Inkam Komii, kara kɨriir yai ɨmiiramɨn ɨna naɨngwo tɨbmii kɨɨna. Kara kɨriiramɨn dimusi naɨngwo tɨbmii kɨɨn tani, kara ɨna nɨnoknɨnkɨna, kɨra Adi Komii siir yɨnisɨmkɨn, inkamɨn Adi Komii siya nɨmbingiyɨn tɨ nu ɨiir nɨtam. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mɨ Mata saeya hɨriinan boɨnkiya mɨ saeya ɨna swokɨ ama. Mɨ saeya kɨmɨdiniya saiir nomousɨma Maria saiiram yɨkɨugi. Mɨ sowa sowa ha nwowo mɨ saeya saiir boɨn, Bɨiyan Inkam Komiiyɨn siya ɨni nɨtɨn mɨ siya kariir boɨnkikɨn, kɨriir ninɨ boɨnmauuniyam hɨnɨɨn, siya ɨni papi nwowɨn. Mɨ ta saeya boɨnkiya hɨriinan, saiir mhoɨiyaɨn, saeya ɨna yama tɨ dimɨn ɨiir tɨram. ");
INSERT INTO iws_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mɨ Maria saeya tɨ yai ɨmiir wakae dɨgiya mɨ saeya bɨ kɨmɨmɨnkika, ɨna iwɨtnam sasaua Jisɨs siir kɨgɨuam. ");
INSERT INTO iws_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jisɨs siya oma hɨriir bɨ nikɨ ɨmbiyamkɨn, siya ɨni maeyauwa Mata saeya napyɨskaiwɨna siir, ɨni hɨrar nikɨ owɨn. ");
INSERT INTO iws_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mɨ Isrel sɨmiir iikamɨm Maria saɨka omaka hɨr nwowɨm saiir whɨnkɨnsiisɨm, sɨma hɨriinan kɨgiyɨm saeya nɨnsiin iwɨtnaniyama mɨ sɨma bɨ kɨmɨmɨnkikɨm, ɨni saiir mhoɨiyar yamɨm. Sɨma hɨnɨɨna naɨngwokikɨm, saeya ɨeyɨn siir wokaigikɨn hɨriir nami, hɨr ninɨ ouwouwam. ");
INSERT INTO iws_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mɨ Maria saeya maeyaua Jisɨs siya nwowa hɨriir nɨmbiyama mɨ saeya siir kɨga mɨ saeya ɨni siir ɨgmiigar inɨ akai hɨuɨua. Mɨ saeya siir inɨg ɨiir ha hainana mɨ saeya ɨna boɨnkiya, Bɨiyan Inkam Komii, kɨra bɨiyar nɨtkɨswo tɨriirɨn mɨ kariir pomouwɨn wɨ di naowi. ");
INSERT INTO iws_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mɨ Jisɨs siya saiir kɨgiyɨn, saeya noua mɨ iikamɨm saɨka nɨtɨm sɨmiir mɨ kɨgiyɨm sɨma mɨ ouɨm mɨ Jisɨs siya hɨk prasae bɨ nwokɨn siir pɨua ɨni warar yɨnkɨn whɨridgiyɨn. Mɨ siya maɨrgɨmaɨrga bɨ nwokɨn. ");
INSERT INTO iws_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Mɨ Jisɨs siya ɨna boɨnkiyɨn, kɨma siirɨn ɨni papi haɨngikaiyɨn? Mɨ sɨma siirɨn ɨna boɨnɨm, Bɨiyan Inkam Komii, kɨra unkɨnɨ kɨgni. ");
INSERT INTO iws_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Mɨ Jisɨs siya ɨni hindara iyɨsrɨmsrɨpugiyɨn. ");
INSERT INTO iws_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Mɨ siya ha nouwɨn mɨ Isrel sɨmiir iikam ɨma boɨn, siir kaoki, siya siiramɨn, pranae pranae mɨ aɨngwokwowi. ");
INSERT INTO iws_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Mɨ kam nhɨrɨm sɨma boɨnki, bɨiya siya inkam nhwokwɨsaeyɨn siir nhwonaɨn, siya nikɨ tɨrkiyɨn mɨ siya bɨ kɨgɨmokikɨn aniya, ɨhɨ mɨ siya tɨ inkamɨn Lasaras nɨkɨuwiyɨn mɨ siya siirɨn wɨ naonamsi nɨkɨdu rani, aniya? Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jisɨs siir kwoɨnɨn ɨni hindara wrɨeyɨmyokiyɨn mɨ siya ɨna yamɨn ɨeyɨn sɨma kikaigiyɨn siir, siiram. Mɨ tɨ siyanoɨn sɨma wokaigiyɨn siir, siir ɨiiyɨn siiyani sɨma bɨdi warkɨntopokgigɨn. ");
INSERT INTO iws_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jisɨs siya boɨnki, tɨ siiyaɨn tɨ warnam. Mɨ tɨ inkamɨn naonamɨn siir yokmana Mata saeya wakae boɨnki, Bɨiyan Inkam Komii, siya kwokiyaeya bɨ naokɨn, ɨiyɨm kwiiya yamki mɨ siya tariinanɨn pɨ nhami nhami whak rani. Kɨpi haiwaoki. ");
INSERT INTO iws_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jisɨs siya saiir boɨnki, kara kɨriir boɨnkii, kɨra siir yai ɨmiiram naɨngwo tɨbmii kɨɨni, kɨra wa kɨgi Adi Komii siir kɨrɨe aiirɨn, saeya tɨrkii. ");
INSERT INTO iws_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Mɨ sɨma siiya ha warnama mɨ Jisɨs siya ha kɨgiyɨn mɨ ɨna boɨnkiyɨn, Adi, wadɨeka, kɨra bɨdi wakaeyɨm dimɨn taemɨnɨm kara kɨriiram srɨi boɨnkiyɨm. ");
INSERT INTO iws_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Kara ɨna nɨnoknɨnkɨnɨn, kɨra ɨinokɨinokɨn kariir yai ɨmiirar wakaeikɨn. Mɨ kara tɨ siirɨn pɨ dimusi boɨnki rani, tɨ iikamɨm tɨ tɨr nwowɨm, sɨma wa nwokɨ ɨnoknɨnkɨnɨm kariirɨn kɨra nɨkropkikɨn nua tɨriirɨn. ");
INSERT INTO iws_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Mɨ tɨ dimɨnɨn siya kwɨsboɨnkiyɨn Adi Komii siiram, siir mhoɨiyan mɨ siya ɨni komiiyar kauwok boɨnkiyɨn, Lasaras, kɨra tɨriir idowɨiya wapnanini. ");
INSERT INTO iws_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mɨ tɨ inkamɨn yɨpɨkɨ nikɨ aonamɨn ɨna yapnaniniyɨn idowɨiya. Mɨ siir ɨga ɨɨnɨm yɨuɨsni sɨma bɨdi whrɨnkiyɨm ɨiya sɨma siir haɨngikaigiya. Mɨ yɨuɨsa siir whwonkam ɨiir bɨdi yɨtɨmwanɨugiya. Mɨ Jisɨs siya sɨmiir boɨnki, warɨ yɨuɨsɨm siir nwowɨm haigi. Mɨpi siirarar kɨgnɨnkɨnki. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mɨ iikam whɨekakɨm, yɨpɨkɨ Maria saɨka namɨm, sɨma tɨ dimɨn ɨiir kɨgiyɨm, Jisɨs siya tɨrkiyɨn, sɨma ɨna yaɨngwo tɨbmii kɨɨngiyɨm siiram. ");
INSERT INTO iws_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Mɨ kam nhɨrɨm ha namɨm, kɨmɨdiniya sɨma inɨ boɨnmauuɨu Farisi kam ɨmiirɨn tɨ dimɨnɨn Jisɨs siya tɨrɨn. ");
INSERT INTO iws_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mɨ mhoɨiya Farisi kamɨm mɨ prismi inkam komii komii ɨkɨm mɨ kaunsil inkam ɨkɨm, sɨma ɨrɨpa ha haɨngiriyɨu owɨm mɨ ɨna boɨnɨm, krɨma wɨ panɨɨn panɨɨna tɨri? Siya dimɨn komii kɨrɨe kɨrɨe kasa bɨ tɨrkɨn. ");
INSERT INTO iws_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Mɨ krɨma siirɨn tɨ hɨriinan dɨmɨn ɨiirar kɨgnɨnkɨn tɨrkrɨpkaii mɨ iikam whɨekakɨm wɨ siiraramar nami. Mɨ iikam whɨekakɨm sɨma siiraramar nami mɨ om komii Rom hɨran inkam komii komiiyɨm sɨma sɨmiir kamɨm yaii nɨniiyɨm sɨmiir nɨkropkii mɨ ta omaka Adi Komii siir inɨg hainaniya saiirɨn, wɨ sɨma ninɨ ɨipɨrgɨinii mɨ Isrel krɨmiir iikamɨm wɨ warar nɨnkɨn onkwobumbunɨnkɨngigi. ");
INSERT INTO iws_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Mɨ inkam nwɨrɨn Kaiafas nɨkɨuwiyɨn, yɨpɨkɨ tɨ bɨewi ɨiir nwowɨn prismi bɨigɨ Bɨiyan Inkam Komiiyɨn siya sɨmiir boɨnki, kɨma, dimɨn sɨm whɨr swokɨ ɨnoknɨnkɨnmɨmɨn tani. Nɨɨngaka. ");
INSERT INTO iws_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Kɨma tari ta saiir nɨnoknɨnkɨn tani, tɨ inkam nwɨruwan siya siyar mɨ aowi, yɨo ɨni mɨ owɨn. Mɨ Isrel krɨmiir pɨugana saiir iikamɨm yɨm wɨ wara nao rani. ");
INSERT INTO iws_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Siya tɨ dimɨnɨn siir kwoɨn aɨrgɨ bɨ prɨinaɨngwo boɨnkɨn. Nɨɨngaka. Siya tɨ bɨewiyɨn siir bɨigɨ bɨiyan prismi inkam komii nwokɨn. Mɨ yaiyɨm siya boɨnkiyɨm, siya profet inkamnan boɨnkikɨn, siya hɨnɨɨna boɨnkikɨn, Jisɨs siya wɨ sɨpi naowi Isrel sɨmiir iikamɨm sɨmiir whɨnkɨnsiis haigɨnɨuwam. ");
INSERT INTO iws_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Siya wɨ sɨmiiram ara nao rani. Nɨɨngaka. Siya wɨ ɨkɨ iikamɨm yɨpɨkɨ Adi Komii siir yɨnisɨsɨmnan nwowɨm, ɨkɨ hɨnda tɨnda nwowɨm, wɨ sɨmiir nɨnkiamasuwam warar naowi. Mɨ sɨma ɨrɨpar nahaɨngiriyɨu ɨuwi mɨ wɨ pɨugan komii kwɨruwar nwokii. ");
INSERT INTO iws_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Mɨ taka ɨiya mɨ mhoɨiya ɨriipɨ hɨriinan, Isrel sɨmiir inkam komii komiiyɨm, wɨ Jisɨs siiram kɨnɨnankɨuwi siir nɨsomaowam. ");
INSERT INTO iws_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Mɨ tɨ hɨriinan saiirsika, Jisɨs siya idowɨiya nu haɨmii Judia sɨmiir iikamɨm sɨmiir bopwonau panɨɨnsi yaprɨrɨrsi. Mɨ siya hɨr haiburgigɨn mɨ siya kɨmɨdiniya nu siiyɨn apa nɨɨngaɨn siir hɨriir yam, om komii whɨrɨn sɨma dapiyɨn, Ifrem. Mɨ hɨrɨn siya siir kɨgna mɨriiyɨm kamɨm, sɨmaka inɨ owou. ");
INSERT INTO iws_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Mɨ ɨi komiiya Isrel sɨmiir iikamɨm ɨrɨpa sɨma haɨngiriyɨu owiya yaewou nae komiiya Pasova saiir nikwo aeiya ɨni kingiin nwowa. Mɨ bɨiya ta hɨriinan yaewou nae komiiya pɨ saeya yɨmbiyam mɨ ɨkɨ iikamɨm, sɨmiir yapa yapa om hɨrar nwowɨm, sɨma pɨ om komii Jerusalem hɨriirarar nami. Mɨ sɨmiir dimɨn taemɨnɨm sɨma nɨnkɨn ɨmiiyaeyanɨm Adi Komii siir pɨ prismi inkam ɨmiir ninɨ hauuɨuwi. Mɨ Adi Komii siya wɨ ha nikɨ boɨnɨm, sɨma dimɨn whɨrkɨ bɨ kɨmbugɨm. Moses siir siyɨu komii siir yai aeya boɨnkiya saiir hɨriinan. ");
INSERT INTO iws_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Mɨ iikam whɨekakɨm ha nɨtɨm om komii Jerusalema hɨriir mɨ sɨma kɨmɨdiniya Jisɨs siiram inɨ hansɨrni. Mɨ sɨma omaka Adi Komii siir inɨg hainaniya saiir omaka yainau hɨrɨrar namwo ɨuwɨm mɨ sɨma ɨrni nwɨrniyɨn sɨma, sɨma sɨmar yɨnsrɨi ansrɨina, kɨma panɨɨna naɨngwowi Jisɨs siirɨn? Krɨma hɨnɨɨna naɨngwowi, siya wɨ nɨt rani, nae iikam krɨmaka ninɨ aeniyam. ");
INSERT INTO iws_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Mɨ prismi inkam komii komiiyɨm mɨ Farisi inkam ɨkɨm sɨma iikam ɨmiir boɨnki, yɨpɨkɨ Jisɨs siir kɨgi, siya ɨni papi nwowɨn mɨ sɨma wɨ sɨmiir winɨ boɨnmauuni. Mɨ bɨiyan inkam komii komiiyɨm, wa nwokɨ amɨm siir nonkwowam. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Mɨ ɨiyɨm ɨriiyar kwɨra nikɨ owɨm, iikamɨm ɨrɨpa sɨma haɨngiriyɨu owam, yaewou nae komiiya Pasova dapiya saiir nikwo aeyam mɨ Jisɨs siya ɨni om Betani hɨriiyar swokɨ amɨn, omɨn, Lasaras siya nwowiyɨn siir, inkamɨn yɨpɨkɨ bɨiya Jisɨs siya hɨdnɨnsiin ɨdwowɨn, ɨe hɨrankɨn, ɨiya siya naonama saiir mhoɨiya. ");
INSERT INTO iws_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Mɨ sɨma nae ɨna dirɨraerarɨm Jisɨs siya hɨrar naeyam. Mata sasar yɨnkɨn dirɨraerar kamɨm nae dirɨraerarɨm sɨmakan. Mɨ inkamɨn Lasaras nɨkɨuwiyɨn, yɨo nae Jisɨs saɨkar yɨdwo ae. ");
INSERT INTO iws_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mɨ mhoɨiya wiga Maria nɨkɨuwiya, Lasaras siir yokmana saeya wa yɨukɨdɨn, pɨuii mɨiyɨk whakiyɨn, kɨmɨdiniya Jisɨs siir ɨga kwɨs owiir yaokɨnki mɨ tɨ wa hɨriinanɨn siirɨn umɨr prasae bɨ saɨnikɨn. Mɨ mhoɨiya saeya kɨmɨdiniya saiir kan aiirar swokɨ ɨiyaonam. Mɨ ta siir pɨuiiya omaka ɨni warar yɨtnopkiya mɨ digworaekwo whɨekakɨm ɨni wadɨekɨnar whakiyɨm. ");
INSERT INTO iws_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Mɨ Jisɨs siir kɨgna mɨriiyɨn inkam nwɨrɨn Judas Iskariot nɨkɨuwiyɨn, inkamɨn yɨpɨkɨ mhoɨiya wɨr Jisɨs siir napwouwi Isrelmi inkam komii komiiyɨm sɨmiir ɨɨn hauugi, siya boɨnki siirɨn. ");
INSERT INTO iws_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Mɨ sɨma tɨ hɨriinan waɨn pɨuii mɨiyɨk whakiyɨn siirɨn umɨr hai karamae dimusi nwokɨn? Mɨ sɨma siirɨn umɨrɨm pɨ 300 kina pɨ haiyɨm mɨ tɨ umɨrɨm wɨ ɨkɨ iikam paeprikab nhɨrɨm sɨm pɨ hauuwɨn. ");
INSERT INTO iws_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Siya ɨkɨ iikam paeprikabɨm sɨmiiram bɨ naɨngwokɨn siya hɨiyan inkam nwokɨn. Tɨpnaɨrɨn umɨr Jisɨs siya mɨ kamɨm siir kɨgna mɨrii ɨkɨm sɨma haigiyɨn siyar kɨgrɨraokɨn. Mɨ umɨrɨm siya tauaehaiyɨm, yɨm ɨni siya haigiprakaiyɨm. ");
INSERT INTO iws_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Mɨ Jisɨs siya siir boɨnki, saiirarar kɨgnɨnkɨnki. Tɨ dimɨnɨn tɨ saeya niyopkiyɨn kariir, yɨo mɨnam dirɨraerarkwokɨnka, mhoɨiya ɨiya sɨma kariir kikaigii ɨenau, saiiramka. Dimusi rani, kariir ɨiya ɨni kingiin nwowa. ");
INSERT INTO iws_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Mɨ iikam paeprikabɨm yɨm wɨ kɨmiir bopwo waraurar nwowi ɨinokɨinokɨn. Mɨ ankara nɨɨngaka. Ɨigwɨrkɨ nɨuwi, kara wɨ kɨmiir haiburgigi. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mɨ Isrel sɨmiir iikamɨm hɨriinan wakaeyɨm, Jisɨs siya ɨni om Betani hɨr nwowɨn. Mɨ sɨma ɨna yamɨm hɨriir siir kɨgam. Sɨma siir kɨgam bɨ namkɨm, sɨma Lasaras siir kɨgam namkɨm, yɨpɨkɨn Jisɨs siya swokɨ hɨdnɨnsiin ɨdwowɨn ɨe hɨrankɨn. ");
INSERT INTO iws_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Mɨ prismi Bɨiyan Inkam Komii komiiyɨm, sɨma mɨnam kɨnankɨugɨm Lasaras Jisɨs sowiir nɨmprɨo ɨsomaowɨm. ");
INSERT INTO iws_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Dimusi rani, dimɨn taemɨnɨm Jisɨs siya tɨrɨm mɨ iikam whɨekakɨm sɨma Isrel sɨmiir inkam komii komiiyɨm sɨmiir yaiyɨm, sɨmiirɨn ɨni hindara ikworɨpukimaigikɨm. Mɨ sɨma ɨni siiraramar yɨnmiinɨnkɨnamɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mɨ ɨigwɨr nugakɨn, iikam whɨekakɨm ta yaewou nae komiiya pasova nɨkɨuwiya saiiram nɨtɨm, sɨma ɨrɨpa ha nahaɨngiriyɨuniyɨm mɨ sɨmar wakaewɨn, Jisɨs siya wɨ sɨpi nɨti om komii Jerusalem tɨriirɨn. ");
INSERT INTO iws_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Mɨ sɨma sikwowɨm ha haiyɨm mɨ kɨmɨndiniya siyɨu ɨiirar haiyɨkwokwowɨn. Mɨ mhoɨiya sɨma ɨna kaɨrwao boɨnkiyɨm, Adi Komii kɨra wadɨekɨn. Kɨra tɨ inkamɨn siir inɨg ɨiir hainanprapraski, yɨpɨkɨ tɨ tɨriir nɨtɨn Adi Komii kɨriir ogsop aiir nokwokairinam. Kɨra tɨ inkamɨn siir whɨnkɨnsiis haigɨnɨu, Isrel krɨmiir iikamɨm sɨmiir kɨgrɨraowɨm. ");
INSERT INTO iws_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Mɨ Jisɨs siya donki ha haiyɨn mɨ siya ɨna yɨdwonamɨn siir ɨdwo. Yokwo Komii saiir yai aeya boɨnkiya saiir hɨriinan, ");
INSERT INTO iws_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","iikamɨm yɨpɨkɨ om komii Saion siir hɨr nwowiyɨm, yɨm kɨpi nɨdid! Tariinanɨn kɨriir inkam komiiyɨn nu kɨgrɨraowiyɨn ɨni nɨtɨn, siya ɨni donki haomɨn siir ɨdwo nɨdwonaniyɨn. ");
INSERT INTO iws_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Mɨ kamɨm siir kɨgna mɨriiyɨm, sɨma bɨ nɨnoknɨnkɨnkɨm sɨma tɨ hɨriinan dimɨn tɨrɨm. Mɨ mhoɨiya ɨiya Jisɨs siya swokɨ ɨti, omwai siya waiyai mɨ siya ha nami Adi Komii siir om ɨiir mɨ siya wɨ inɨg komiigak ha nwowi. Mɨ mhoɨiya sɨma ɨna boɨnɨm, krɨma yaiyɨm Yokwo Komii saeya boɨnɨm sɨmiir tɨ swokɨ aɨngwowoknaki mɨ sɨma tɨ hɨriinan dimɨnɨn siir dimusi tɨri. ");
INSERT INTO iws_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mɨ iikam whɨekakɨm yɨpɨkɨ bɨiya Jisɨs saɨka nwowɨm, ɨiya Lasaras siya swokɨ ɨnsiin ɨdwowa ɨe hɨrankɨn mɨ tɨ iikamɨm, sɨma tɨ dimɨn ɨiir kɨgɨm mɨ kɨmɨdiniya sɨma haigirɨrɨr boɨnam tɨ dimɨnɨn siya tɨrɨn. ");
INSERT INTO iws_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Mɨ tɨ hɨriinan siirsi bwaekiinaniyamkɨm iikam whɨekakɨm Jisɨs siir kɨgwɨnamɨn. Sɨma bɨdi wakaewɨnɨm hɨnɨɨn, Jisɨs siya tɨ hɨnɨɨn dimɨn komiiyɨn si tɨrkɨn. ");
INSERT INTO iws_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mɨ Farisi sɨmiir kamɨm, yai sɨma sɨmar yomboɨn amboɨn, sɨmiir kɨgi, dimɨnɨm siya tɨrɨm kɨma kaiyaonaowidi kɨma wɨ dɨg nwo rani, iikam whɨekakɨm tɨ nu ɨiiranɨm, wɨ siiraramar nɨnkirɨonaei. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Mɨ iikam nhɨrɨm Grik sɨmiir pɨugana saiirɨm, sɨma om komii Jerusalem hɨriir nɨtɨm, Isrel sɨmiir iikam nhɨrɨm sɨmaka yɨnkɨn ɨt yaewou nae komiiya Pasova saiir nikwo aeyam. ");
INSERT INTO iws_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Sɨma kɨmɨdiniya inkamɨn Pilip nɨkɨuwiyɨn siiram yam siir ninɨ kɨgɨuwam. Siya om Betsaida hɨrankɨn. Sɨma boɨn, inkam Komii, krɨma mɨnam naɨngwowi, Jisɨs siir kɨgɨm mɨ yai saɨka boɨnɨm. ");
INSERT INTO iws_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Mɨ Pilip siya ha namɨn kɨmɨdiniya Endru siir inɨ boɨnɨu mɨ mhoɨiya kɨmɨdiniya sowar yam, Jisɨs saɨka boɨnamɨn. ");
INSERT INTO iws_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Mɨ Jisɨs siya sowiir boɨnki, ɨiya kingiin bɨdi yɨtkiya, kararɨn tɨ inkamɨn Adi Komii siir om hɨrankɨ nɨtɨn, Adi Komii siya wɨ kariir hauuwi, siir inɨg komiiyɨn mɨ siirɨn wɨ kara haii. ");
INSERT INTO iws_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kara kɨmiirɨn yaimwowar boɨnkii, twonidɨm nua nɨkiigɨiyam karamae nwowi mɨ hapaiirɨn nhɨsuwakar nwokii mɨ kɨra sɨmiirɨn nu ha haɨngikaii mɨ mhoɨiya sɨma wɨ yɨn kasa budgi rani. Mɨ tɨ hɨriinan siyɨuɨn kara naowi mɨ inkamɨm kariirɨn ha haɨngikaii mɨ mhoɨiya kara ha swokɨ ɨnsiin ɨdwowi mɨ wɨ iikam kasa whɨnkɨnsiis haigɨnɨu rani, kariiram naɨngwo tɨbmiiyɨm. ");
INSERT INTO iws_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mɨ yɨpɨkɨ sɨmiir kwoɨn ɨiirar napi, sɨma wɨ sɨma sɨmar swokɨ onkwobumbunɨnkɨnaei. Mɨ yɨpɨkɨ sɨmiir kwoɨn ɨmiirar nap karamae nwowi tɨ nu ɨiirɨn mɨ sɨma Adi Komii siir kwoɨn ɨiiraramar naɨngwo ɨskii, yɨm wɨ omwai hɨriiyar waiyayokiyokɨikaeyami. ");
INSERT INTO iws_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mɨ iikamɨm yɨpɨkɨ kariiram naɨngwowɨm mɨ kariir mɨi aiir mɨriiyɨm, yɨm wɨ maeyaua kara nwowa wɨ saiir warar mɨ owi. Mɨ kariir Adɨn, Adi Komii siya, sɨmiirɨn wɨ inkamɨm inɨgakɨm wɨ sɨmiir hɨriinan nwo haigɨnɨuwi. Mɨ sɨma wɨ inɨg komiigak dimusi nwo rani, sɨma kariir kɨgna apkɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Tariinanɨn kariir kwoɨnɨn mɨiyɨk mɨiyɨk nwo rani, kariir kwoɨnɨn ɨni warar yaowhrɨewhrɨeyɨuwɨn mɨ kara pɨ panɨɨna tɨ boɨn? Mɨ kara hɨnɨɨna boɨni, adi, kara tɨ haiburgik tɨ dimɨnɨn nɨmbiniyɨn kariir nɨsomaowam siirsi? Nɨɨngaka. Dimusi rani, kara tɨ nu ɨiirɨn hɨriinanamar nɨtkɨn. ");
INSERT INTO iws_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Adi Komii, kɨra kɨriir inɨgɨn siir tɨrki, komii nwokiyamɨn. Mɨ Jisɨs siya tɨ hɨriinan yai ɨmiir boɨnkiyɨn mɨ yai kwɨra nɨnomor kouana ɨna kauwok boɨnkiya, kara kariir inɨgɨn, komii bɨdiyar ikɨ okiyɨn mɨ tariinanɨn pɨ komiiyar swokɨ okii. ");
INSERT INTO iws_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Mɨ iikam whɨekakɨm saɨka kingiin hɨr nokwowɨm, sɨma ta yai aiir wakaekiyɨm mɨ sɨma boɨn, nɨnomorka. Mɨ iikam nhɨrɨm yɨm hɨnɨɨna boɨn, paekwosɨmkɨn, Adi Komii siir inkamɨn siya boɨnkii siirɨn. ");
INSERT INTO iws_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Mɨ Jisɨs siya sɨmiir boɨnki, taka yaiya kariiram bɨ boɨnkika, kariir whɨnkɨnsiis haigɨnɨuwam. Nɨɨngaka. Ya kɨmiiram boɨnkika, kɨmiir whɨnkɨnsiis haigɨnɨuwam. ");
INSERT INTO iws_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Mɨ tariinanɨn taka ɨiya nɨta, Adi Komii siya wɨ tɨ iikamɨm tɨ nu ɨiir nwowɨm wɨ sɨmiir dimɨn biyɨe biyɨeyɨm sɨma tɨrɨm wɨ sɨmiirsi hɨdi. Mɨ tariinanɨn siya Setan siirɨn wɨ haɨni nikwowaisiigii, yɨpɨkɨn dimɨn biyɨe biyɨeyɨm tɨ nuɨn siirɨm sɨmiir kɨgɨrkakiyɨn. ");
INSERT INTO iws_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Mɨ mhoɨiya inkamɨm kariirɨn paeyɨn hɨiiniya nɨrɨonɨnkɨnɨn saɨka nɨnkɨn ɨrɨnugii mɨ sɨmiir kwoɨnɨm wɨ kara kiyaii, kariiram naɨngwo tɨbmiiyɨm mɨ kariir mhoɨiya nɨtɨm. ");
INSERT INTO iws_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jisɨs siya tɨ yai hɨriinanɨm mɨnam boɨnkɨn, iikamɨm sɨmiir nɨisiimauuwam hɨnɨɨn, siya wɨ panɨɨna namisi aonami. ");
INSERT INTO iws_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mɨ mhoɨiya iikam whɨekakɨm sɨma siir yai aka hɨnɨɨna yowarkɨi boɨn, Moses siir siyɨu komiiyɨn krɨma napiyɨn, tɨ inkamɨn bɨiya siya wɨnkiyɨn Yokwo Komii aiir, yɨm hɨnɨɨna boɨnkikɨm inkamɨn yɨpɨkɨ Adi Komii siya nɨmbingiyɨn, iikamɨm omwai waiyayokiyokɨiyanɨm sɨmiir whɨnkɨnsiis haigɨnɨuwam. Mɨ kɨra hɨnɨɨn dimusi boɨnkɨn, inkamɨn Adi Komii siir om hɨranɨn, siirɨn wɨ paeyɨn hɨiiniya nɨrɨonɨnkɨnɨn saɨka nɨnkɨn ɨrɨnugi mɨ siya wa naonami, ha? Yɨpɨkɨ siya tɨ inkamɨn Adi Komii siir omɨn siir hɨranɨn? ");
INSERT INTO iws_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Mɨ Jisɨs siya sɨmiir yai aka hɨnɨɨna yowarkɨi boɨn, bɨeyɨn wɨ ɨi prɨei whwoki rani, iikam kɨmiir waraurɨn. Kɨma ɨiya bɨe ɨeya whwokii mɨ kɨma wɨ wadɨe haɨni nwokii. Mɨ nɨiya wɨ tɨ siyɨu ɨiir higrɨnɨu rani. Mɨ kara kɨmiir haiburgigi mɨ kɨma wɨ inkamɨn, nɨiyɨɨm nɨiyɨɨm napiyɨn, siyɨu ɨiir sɨbgu kɨgomok ap karamae nwowiyɨn maeyaua siya namam tɨra saiir hɨriir, ɨni siir hɨriinan ywowɨn. ");
INSERT INTO iws_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kɨma kariiram kɨgna ap mɨ kariiram daɨngwo tɨbmii kɨɨn, karaɨrgɨn bɨenan whwoyaei ɨiya kara tɨ nu ɨiir nwowi. Mɨ mhoɨiya kɨma wɨ dimɨn mɨiyɨkɨmɨiyɨk ɨmiiram naɨngwo tɨbmii kɨɨni. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Mɨ tɨ iikamɨm sɨma dimɨn kɨrɨe komii komiiyɨm siya tɨrɨm, iikamɨm makɨniiyɨm sɨmiir siya haiswonɨmnɨskɨiyɨm sɨmiirɨn bɨdiyar ikɨ kɨgɨm mɨ sɨma siiramɨn hɨnɨɨna bɨ naɨngwo tɨbmiigɨm siya Mesaiakɨn yɨpɨkɨ Adi Komii siya nɨkropkiyɨn. ");
INSERT INTO iws_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Sɨma siiram bɨ naɨngwo tɨbmii kɨɨngɨm ta yaiya profet Aisaiakɨn siya wɨn boɨnkiya ya wɨ kaimwowar nwowi, siya hɨnɨɨna boɨnkikɨn, Bɨiyan Inkam Komii, wɨ nhɨnga naɨngwo tɨbmii kɨɨni, tɨ krɨmiir yai ɨmiiramɨn? Mɨ Bɨiyan Inkam Komiiyɨn siir kɨrɨeya wɨ nhɨnir nɨisiimauuwi? Ɨni inkam karamaeyar ywowɨskiyɨn. ");
INSERT INTO iws_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Mɨ iikamɨm sɨma wɨ siiram naɨngwo tɨbmii kɨɨn tani mɨ wɨ siir mɨ kɨgna ap rani. Dimusi rani, bɨiya yaiya Aisaia siya kaimwowar swokɨ wɨnkiya yai kwɨra yokwoni, ya hɨnɨɨna wɨn boɨnkika, ");
INSERT INTO iws_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","sɨmiir kwoɨnɨm Adi Komii siya bɨdi kɨnkrɨpɨm mɨ sɨma wɨ hindarar nanaɨngwoyɨmiyok ɨuwi. Mɨ sɨma hɨrii hɨriiyar naɨngwo whrɨewhrɨei mɨ sɨma dimɨn taemɨnɨm wɨ sɨbgu naɨngwo omok rani. Mɨ sɨma sɨbgu naɨngwo omoki mɨ sɨmiir nhwowɨm sɨbgu kɨgi mɨ sɨma wɨ haɨni naɨngwo tɨbmii kɨɨni mɨ wɨ haɨni sɨbgu wakaeyokna api siiramɨn mɨ sɨmiirɨn wɨ haɨni haiswonɨmnɨskɨii. Mɨ yɨm sɨma, wɨ dɨg nwo rani. ");
INSERT INTO iws_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia profet inkamɨn siya tɨ hɨriinan dimusi bɨ boɨnkikɨn, siya Jisɨs siir bɨdi kɨgɨn, siya siir inɨg komii ɨiir haiyɨn mɨ siya hɨriinansi boɨnourwokaigikɨn. ");
INSERT INTO iws_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Mɨ tɨkɨ ɨiyɨm inkam komii komiiyɨm Isrel sɨmiirɨm, sɨma ɨni Jisɨs siiramar yamɨm. Sɨma Farisi inkamɨm sɨmiirsi nɨdidgɨm mɨ sɨma hɨnɨɨn panɨɨnsi boɨnsi, sɨma Jisɨs siiram naɨngwo tɨbmii. Mɨ sɨma hɨriinan boɨni, sɨma siiram naɨngwo tɨbmii kɨɨni mɨ sɨmiirɨn wɨ Farisi inkam ɨma kiyɨtkɨkɨnkii idowɨiya hɨriirɨn, omaka yaimɨn dimɨn nɨdwokai wakaeiya saiir hɨrankɨn. ");
INSERT INTO iws_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Mɨ sɨmiir kwoɨn komiiyɨn ha naɨngwowi, iikam nhɨrɨm sɨmiirɨn hɨnɨɨna boɨnɨm, sɨma inkam wadɨekɨm mɨ sɨmiir inɨg ɨmiir hainanprapraski. Mɨ sɨma Adi Komii siiramɨn komiiwao naɨngwo rani mɨ Adi Komii siya wɨ ha nikɨ boɨnɨm, sɨma inkam wadɨekɨm. Mɨ sɨmarɨn, yɨo ɨni nɨɨngakɨ, nɨɨngar ywowɨskiyɨm. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Mɨ Jisɨs siya ɨni komiiyar kauwok boɨnkiyɨn, yɨpɨkɨ kariiram naɨngwo tɨbmii kɨɨni, siya wɨ kariiraramar kɨpi naɨngwo tɨbmii kɨɨn. Siya wɨ tɨ yɨpɨkɨn kariir nɨkropkiyɨn, nua tɨriir wɨ siiram warar tɨ aɨngwo tɨbmii kɨɨn. ");
INSERT INTO iws_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Mɨ tɨ iikamɨm yɨpɨkɨ kariir kɨgɨm mɨ sɨma yɨpɨkɨ kariir nɨkropkiyɨn tɨ nu ɨiir siir warar timɨ kɨg. ");
INSERT INTO iws_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Kara tɨ nu ɨiir nɨtɨn, kara ɨni bɨenan whwoyanan ywokiyɨn. Mɨ ta hɨriinan saiirsika mɨ yɨpɨkɨ kariiram naɨngwo tɨbmii kɨɨni mɨ kariiram nɨti, siya wɨ biyɨe nwo rani, inkamɨn nɨibwomambwo nwowiyɨn siir hɨriinan. ");
INSERT INTO iws_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mɨ yɨpɨkɨ kariir yai ɨmiir wakae karamae nwowi mɨ sɨmiir mɨ wakaeyokna ap karamae mɨ owi mɨ kara siirɨn wɨ hɨd rani. Kara tɨ iikamɨm nu tɨr nwowɨm sɨmiir hɨdam bɨ nɨtkɨn. Nɨɨngaka. Kara sɨmiir whɨnkɨnsiis haigɨnɨuam nɨtkɨn. ");
INSERT INTO iws_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mɨ kɨmiir iikam nhɨrkɨm kariir nikwowaisii mɨ kariir yai ɨmiir mɨ wakae karamae mɨ owi mɨ mhoɨiya inkam nwɨrɨn siirɨn wɨ siya hɨdi. Mɨ yaiyɨm bɨiya kara boɨnmɨmauuɨm, siirɨn wɨ sɨmiirar swokɨ hɨdi, ɨiya Adi Komii siya iikam ɨmiir hɨdi. ");
INSERT INTO iws_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tɨriigɨnɨm yɨm kaimwo dimusi bɨ nwokɨm, kara kariir kwoɨn ara bɨ dirɨraerarkɨn mɨ ha bɨ boɨnmɨmauugɨn. Nɨɨngaka. Adi Komiiyɨn, yɨpɨkɨ kariir nɨkropkiyɨn, kariirɨn siya boɨnkikɨn boɨnamɨn. Mɨ kara sɨmiir asi boɨnourwokai haigɨnɨugɨn. ");
INSERT INTO iws_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Kara ɨna nɨnoknɨnkɨnɨn yaiyɨm siya boɨnkiyɨm, iikamɨm omwai sɨma waiyayokiyokɨigiyamɨm siya tɨrkiyɨm. Mɨ tɨ dimɨn taemɨnɨm tɨ kara boɨnmɨmauuɨm, yɨm kariir Adɨn siya boɨnmɨmauugi ɨma kariir. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Mɨ ɨi komiiya wou nikwo aeiya Pasova, waka nikwo aei. Mɨ Jisɨs siya bɨdiyar yɨnoknɨnkɨnkiyɨn siir ɨiya siya naowana, tɨ nu ɨiir haiburgigna siir Adiyɨn siiram swokɨ amɨm siir swokɨ kɨgɨuwam ya bɨdi yɨmbiniya. Siya ɨinokɨinokɨn yɨpɨkɨ siir iikam nwowɨm, siir iikamɨm tɨ nu ɨiir siya sɨmiiramar naɨngwokwonanaeikɨn mɨ tariinanɨn siya wɨ sɨmiir nɨisiimauuwi, siya pariiga naɨngwokwowi sɨmiiramɨn. ");
INSERT INTO iws_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jisɨs siya mɨ kamɨm siir kɨgna mɨrii ɨkɨm, sɨma nae ɨna yaeyɨm. Setan siya Judas siir kwoɨn ɨiirɨn bɨdinanar kwɨrii ɨdwokaigɨn, Saimon Iskariotni yɨnisɨmɨn wɨr Jisɨs siir napwouwɨn mɨ siirɨn ɨkɨ inkam biyɨeyɨm sɨm ɨɨn hauugiyam. ");
INSERT INTO iws_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisɨs siya bɨdiyar yɨnoknɨnkɨnɨn, tɨ digworaekwowɨm siir Adɨn siir ɨɨnarar nonkwokikɨn. Mɨ siya bɨdiyar mɨ ɨnoknɨnkɨnɨn hɨnɨɨn, siya Adi Komii siir hɨrankɨ nɨtkɨn mɨ siya wɨ siir hɨriiyar swokɨ ami. ");
INSERT INTO iws_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mɨ mhoɨiya Jisɨs siya ha nɨnsiin okwokiyɨn, ipiiya siya nɨdwokaiya maeyauwa nae sɨma nɨdwokai aeya saiir hɨrankɨn mɨ siya siir ɨdan yɨuɨsa ɨna yɨskiya. Mɨ siya siirɨn yɨuɨsa pɨu nɨiyaowiya saiir kaihaigɨnɨu. ");
INSERT INTO iws_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Mɨ siya siirɨn yɨuɨsa pɨu nɨiyaowiya ha kaiyaigɨnɨuɨn mɨ mhoɨiya siya opa kɨmɨdiniya two ɨra saiir yaomaigi. Mɨ siya, siir kɨgna mɨriiyɨn inkam nwɨrɨn siir ɨga kwɨs owiir hɨisoki mɨ mhoɨiya siya sowiirɨn yɨuɨsa pɨu nɨiyaowiya saiir yɨiyaoki. ");
INSERT INTO iws_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Mɨ Jisɨs siya ha namɨn Saimon Pita siir hɨisok haigɨnɨuwam mɨ siya siir boɨnki, Bɨiyan Inkam Komii, kɨra kariir ɨga kwɨso pɨ warar nɨnkɨn hɨisokii? ");
INSERT INTO iws_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jisɨs siya ɨna yowarkɨi boɨnkiyɨn, tariinanɨn kɨra nɨnoknɨnkɨn tani, tɨ dimɨnɨn kara tɨrkiyɨn mɨ mhoɨiya kɨra wɨ haɨni nɨnoknɨnkɨni. ");
INSERT INTO iws_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita siya Jisɨs siir boɨnki, kɨra kariir ɨga owiir kɨpi hɨisok. Nɨɨngaka. Mɨ Jisɨs siya ɨna boɨnkiyɨn mɨ kara kɨriir ɨga kwɨs owiir hɨisok karamae nwowi mɨ kɨra wɨ kariir kɨgna mɨriiyan inkam nwo rani. ");
INSERT INTO iws_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Mɨ Saimon Pita siya ɨna yowarkɨi boɨnkiyɨn, Bɨiyan Inkam Komii, kɨra kariir ɨga owiirara kɨpi hɨisok, kɨra kariir ɨɨna mwo mɨnɨm warar dɨnkɨn hɨisoki. ");
INSERT INTO iws_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jisɨs siya boɨnki, inkamɨn kariiram naɨngwo tɨbmii kɨɨni, yɨo ɨni inkamɨn op whaugiiyɨn mɨ whauriyɨnan ha nwokiiyɨn, yɨo mhoɨiya op whauam bɨ swokɨ naɨngwowikɨn. Nɨɨngaka. Siya wɨ siir ɨga aiirarar hɨisoki. Kɨma ombudarɨn ɨni whauriyɨnkɨnar nwoswowɨm inkamɨn op whauwiyɨn mɨ whauriyɨnan ha nwokiiyɨn siir hɨriinan. Nwɨruwakɨn hɨriinan nwo karamae nwowɨn. Yɨo ɨni inkamɨn op mɨn whauae karamae nwowiyɨn hɨriinan tainakiyɨnar nwowiyɨn ɨni siir hɨriinan ywowɨn. ");
INSERT INTO iws_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jisɨs siya bɨdinanar nɨnoknɨnkɨnkɨn, yɨpɨkɨ wɨr siir napwouwi mɨ siirɨn inkam biyɨeyɨm sɨm ɨɨn hauugi sɨma haɨnam. Siya kamɨm siir kɨgna mɨriiyɨm sɨmiir boɨn, kɨmiir kwoɨnɨm ɨni inkamɨn op whaugiyɨn mɨ whauriyɨnan ha nwokiiyɨn ɨni siir hɨriinan ywowɨm. Mɨ inkam nwɨrɨn siir kwoɨnɨn yɨo mɨiyɨk rani, yɨo ɨni inkamɨn op mɨn whauae karamae nwowiyɨn, hɨriinan tainakiyɨnar nwowiyɨn, ɨni siir hɨriinan ywowɨn. ");
INSERT INTO iws_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Mɨ mhoɨiya Jisɨs siya sɨmiir ɨga ɨmiirɨm ha hɨisok dɨgiyɨm mɨ siya siir yɨuɨsa ha swokɨ iiyɨn mɨ siya ha swokɨ ɨdwokaiyɨn ipii aiir. Mɨ siya sɨmiirɨn ɨna srɨiyɨn, kɨma ɨna nɨnoknɨnkɨnɨm, tɨ kara tɨrkiyɨn hɨriinan? Kara kɨmiirɨn pɨ hɨnɨɨna boɨnkii, ");
INSERT INTO iws_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","wɨm kɨma kariirɨn hɨnɨɨna boɨnikɨm, Bɨiyan Inkam Komii mɨ Inkam Nowomwarkaiyɨuwiyɨn, yɨo ɨni ywowɨn kɨma kariirɨn hɨriinan boɨnɨn yɨo. Dimusi rani, kararɨn, kara ɨni inɨg komiigak ywowɨn. ");
INSERT INTO iws_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kara kɨmiir Bɨiyan Inkam Komiigɨn mɨ kɨmiir Nowomwarkaiyɨuwan Inkamkɨn mɨ kɨmiir ɨgam kara bɨdi hɨisokiyɨm. Mɨ kɨma tɨ dimɨnɨn kara mɨ tɨrɨn wɨ siir hɨriinanar timɨ tɨr. Mɨ kɨma kɨmiir nomiiyauwɨm sɨmiir ɨgam wɨ hɨriinanar timɨ hɨisok haigɨnɨu inkamɨn, inkam nwɨrni mɨi prɨimɨriiyɨn umɨr hai karamae nwowiyɨn. ");
INSERT INTO iws_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kara tɨ dimɨnɨn kɨmiirɨn mɨnam nɨisiimauugikɨn, kɨma wɨ tɨ kara tɨrɨm wɨ sɨmiir hɨriinanar tɨr. ");
INSERT INTO iws_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kara kɨmiirɨn yaimwowar boɨnkii, inkamɨn whɨsarii mɨi prɨimɨriiyɨn siya inkamɨn siir kɨgrɨraowiyɨn siir kou bɨ nwokɨn. Mɨ siya hɨriinanam bɨ namkɨn ɨkɨ digworaekwo whɨekakɨm sɨmiirɨn siir inɨgɨ wara nwowɨm. Nɨɨngaka. Inkamɨn ɨkɨ inkam nwɨrni nɨkropkiyɨn siya siirɨn pa boɨnkii hɨnɨɨn, tɨ inkamɨn yɨpɨkɨ siir nɨkropkiyɨn siya ɨni siir kou ywowɨn. ");
INSERT INTO iws_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mɨ tariinanɨn kɨma bɨdi yɨnoknɨnkɨnkiyɨm tɨ dimɨnɨm kara boɨnɨm mɨ kɨma tɨ dimɨn ɨmiir sɨbgu api mɨ kɨma wɨ maɨrgɨmaɨrga prasae nwo rani. ");
INSERT INTO iws_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Mɨ kara kɨmiir hoɨmgakar boɨn tani. Nɨɨngaka. Kara bɨdi yɨnoknɨnkɨnɨn yɨpɨkɨ kara nɨmbinɨm kariir iikam nwowi. Mɨ Adi Komii siir yaiya Yokwo Komii hɨr nwowa saeya hɨnɨɨna boɨnkika, tɨ dimɨnɨn wɨ sɨpi nɨmbiyami. Inkamɨn nae kara hauuwi mɨ tɨ inkamɨn kariirɨn wɨ siya tɨrbuwi. ");
INSERT INTO iws_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mɨ tɨ dimɨnɨm tɨ kara boɨnmɨmauuwɨm kɨmiir kara mɨnsi boɨnmɨmauugɨn mhoɨiya tɨ dimɨn ɨma nɨmbiyami mɨ kɨma wa nwokɨ ɨnoknɨnkɨn kɨɨnɨm, kara tɨ inkamɨn Adi Komii siir om hɨrankɨ nɨtɨn siya iikam whɨekakɨm tɨ nuɨn siir tɨranɨm sɨmiir whɨnkɨnsiis haigɨnɨuwankɨn. ");
INSERT INTO iws_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kara kɨmiirɨn yaimwowar boɨnkii, iikamɨm yɨpɨkɨ kara nɨkropkiyɨm sɨmiir sɨbgu kɨgrɨraowi, yɨo kɨma ɨni kariir kɨgrɨraowan iikam ywowɨm. Mɨ yɨpɨkɨ kariir sɨbgu kɨgrɨraowi, yɨo ɨni Adi Komii siir boɨn maɨrgɨmaɨrganan ywowɨn, yɨpɨkɨn kariir nɨkropkiyɨn. Ɨriig. ");
INSERT INTO iws_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Mɨ mhoɨiya Jisɨs siya tɨ dimɨn ɨmiir boɨn dɨgiyɨn mɨ siir kwoɨnɨn hɨk prasae bɨ kɨnkɨn. Mɨ siya sɨmiirɨn hɨnɨɨn boɨnmauu wakae, kara kɨmiirɨn yaimwowar boɨnkii, kɨmiir nwɨrɨn, kariirɨn wɨ wɨr siya napwouwi mɨ kariirɨn wɨ ɨkɨ kam biyɨeyɨm sɨmiir ɨɨn nonkwokii sɨma nɨsomaowam. ");
INSERT INTO iws_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Mɨ kamɨm siir kɨgna mɨriiyɨm sɨma, sɨma sɨmar yɨnkao ankaona. Dimusi rani, sɨma bɨ nɨnoknɨnkɨnkɨm siya yɨpɨkɨn. ");
INSERT INTO iws_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mɨ kara inkamɨn Jisɨs siir kɨgna mɨriiyɨn siya naɨngwokwonanaeiyɨn, an kara saɨka kingiinar kɨnmasu ɨdwokɨn. ");
INSERT INTO iws_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Mɨ Saimon Pita siya kɨmɨdiniya kariir kɨnmauugi kɨra siir srɨigi, kɨra siir srɨigi hɨnɨɨn, siya yɨpɨkɨn? ");
INSERT INTO iws_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mɨ ta Pita siya srɨigiya kariir saiir mhoɨiyan, kara ɨna yamasunamɨn Jisɨs siir kingiin mɨ ɨna yakɨ srɨiyɨn, Bɨiyan Inkam Komii, wɨ nhɨnga tɨri hɨriinanɨn, ha? ");
INSERT INTO iws_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Mɨ Jisɨs siya kariirɨn hɨnɨɨna boɨnki, kara pɨ tɨ bret ɨiir haii mɨpi op hopmaigii mɨ pa hauugii mɨ tɨ inkamɨn siya kariir tɨri hɨriinan mɨ ta yaiya siya boɨnkiya saiir mhoɨiyan siya tɨ bretɨn ɨna hauugiyɨn Judas siir siya naeyam. ");
INSERT INTO iws_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Mɨ mhoɨiya Judas siya tɨ bret ɨiirɨn ha naeswokiyɨn mɨ Setan siya kɨmɨdiniya siir kwoɨn ɨiir kiyaigi mɨ Jisɨs siya siir boɨnki, dimɨnɨn kɨra tɨram naɨngwowiyɨn, kɨra kɨpi kɨmɨmɨn, kɨra ha tɨrsaugi. ");
INSERT INTO iws_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Mɨ kamɨm nae hɨr nɨdwokai aeyɨ