﻿USE sofia;
DROP TABLE IF EXISTS sofia.ivb_vpl;
CREATE TABLE ivb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ivb_vpl WRITE;
INSERT INTO ivb_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Do nakapamarswaw ni Āpo Dyos so hanyit kan lobong, ");
INSERT INTO ivb_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","abaw potar no lobongaya, as kan abo paw mimyan na. Oltimo so kasari do dawri, as kan natonep pa tabo do magpapalot a kelsang no ranom. As no Ispirito no Dyos, ki nāw na sinalokoban hapotaw no ranom. ");
INSERT INTO ivb_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ki do dawri, inchirin ni Āpo Dyos a kāna, “Myan pakono sedang.” Ki nyeng a myan sedang a akmas inchirin naw. ");
INSERT INTO ivb_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Do nakaboyaw no Dyos so sedang, naboya na maganay. Sinpangan na, pinaysyay naw sedangaw kan saryaw. ");
INSERT INTO ivb_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Iyaw sedangaya, ki pinangaranan nas “Maraw,” as iyaw saryaya, ki pinangaranan nas “Mahep.” Homnabas mahep kan myan danaw mabekas. Iyaw nyaw manōma araw. ");
INSERT INTO ivb_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Katayokan nawri, inchirin ni Āpo Dyos a kāna, “Myan pakono kademdeman a mapaytawas ranom tan myan dadwa yanan ranom.” ");
INSERT INTO ivb_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Pinarin ni Āpo Dyos kademdeman a mapaytawa so ranom tan myan do tohos kan myan ranom do ibaba. Ki oyod a naparin iyaw inchirin naw. ");
INSERT INTO ivb_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","No mapaytawa so ranom, ki pinangaranan nas “Kademdeman.” Sinpangan na, homnabas mahep kan myan danaw mabekas. Iyaw nyaw chadadwa narana karaw. ");
INSERT INTO ivb_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Inchirin ni Āpo Dyos a kāna, “Mayrarapa sa pakono ranomaya a myan do ohbo no kademdemanaya do asa yanan tan myan mabkoh a yanan.” Ki oyod a naparin. ");
INSERT INTO ivb_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Pinangaranan ni Āpo Dyos so “Tana” iyaw mabkohaw a yanan, as iyaw nayrarapaya a ranom, ki pinangaranan nas “Tāw.” As do nakaboyaw sya no Dyos, naboya na maganay. ");
INSERT INTO ivb_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Sinpangan na, inchirin ni Āpo Dyos a kāna, “Patobohen pakono no tanaw tabo a kita no tomobo a myan so botoh kan kayokayo a omsi.” Ki oyod a naparin. ");
INSERT INTO ivb_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Dawa, pinahtot no tanaw tabo a kitan mohamoha a myan so botoh kan siraw kayokayo a myan so asi. Do nakaboyaw sya no Dyos, naboya na maganay. ");
INSERT INTO ivb_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Homnabas mahep kan myan danaw mabekas. Iyaw nyaw chatatdo narana karaw. ");
INSERT INTO ivb_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Sinpangan na, inchirin ni Āpo Dyos a kāna, “Maparin pakono saw soho do hanyit tan myan mapaysyay so maraw kan mahep tan myan pakailasinan so siknanan araw, bohan, kan awan. ");
INSERT INTO ivb_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Magranyag sa do hanyit tan masedangan lobongaya.” Ki oyod a naparin. ");
INSERT INTO ivb_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Dawa, pinarin ni Āpo Dyos dadwa rarakoh a soho. Iyaw mayīyitaw, ki araw a magranyag an maraw, kan iyaw makapkapsotaw, ki bohan a magranyag an mahep. Pinarin na paw bitohen saw. ");
INSERT INTO ivb_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","On, pinangay sa ni Āpo Dyos do hanyit a mangsedang so lobongaya ");
INSERT INTO ivb_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","tan magranyag sa do maraw kan mahep a mapaysyay so sedang kan sari. As do nakaboyaw sya ni Āpo Dyos, naboya na maganay. ");
INSERT INTO ivb_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Homnabas mahep kan myan danaw mabekas. Iyaw nyaw chapat narana karaw. ");
INSERT INTO ivb_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Minirwa inchirin ni Āpo Dyos a kāna, “Myan pakono do ranom aro a matatarek a kitan mabyay, as kan myan pakono do tohos tabo a kita no manomanok.” ");
INSERT INTO ivb_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Dawa, pinarswa ni Āpo Dyos siraw rarakoh saya a nabyay do tāw kan tabo a parswa a mayhodyihodyi do ranom. Pinarswa na pa saw tabo a kitan manomanok. As do nakaboyaw sya no Dyos, naboya na maganay. ");
INSERT INTO ivb_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Binindisyonan na sa tabo, as nakaibahey na sya dyirad myanaw do ranom a mayparo sa tan apnohen daw tāw. Komwan inbahey na dyirad manomanok saw a mayparo sa. ");
INSERT INTO ivb_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Homnabas mahep kan myan danaw mabekas. Iyaw nyaw chadadima narana karaw. ");
INSERT INTO ivb_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Inchirin ni Āpo Dyos a kāna, “Myan pakono do tanaw tabo a kitan mabyay a maywam kan bolaw kan siraw komayakayab do tana.” Ki naparin nyaya. ");
INSERT INTO ivb_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","On, pinarswa no Dyos bolaw saw a binyay sigon do kita da kan siraw maywam saw a binyay sigon do kita da. Pinarswa na paw komayakayab saw do tana sigon do kita da. As do nakaboyaw sya no Dyos, ki naboya na maganay. ");
INSERT INTO ivb_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Katayoka na, binata ni Āpo Dyos a kāna, “Sichangori, parinen taw tawo, ki parinen ta akma dyaten. Torohan ta sa so toray da do tabo a among do tāw, manomanok do tohos, kan tabo binyay a maywam kan bolaw do hapot no tanaya, as kan siraw tabo komayakayab do tana.” ");
INSERT INTO ivb_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Do dawri, pinarswa ni Āpo Dyos tawo a akma dya. Pinarswa na sa mahakay kan mabakes. ");
INSERT INTO ivb_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ki binindisyonan na sa, as binata na a kāna, “Mayparo kamo tan omyan sanchiw kapotōtan nyo saw do tabo a yanan do lobongaya a mangitoray siras among do tāw, manomanok do tohos, kan kāda mabyay a naparswa a makayam kan komayakayab do tana. ");
INSERT INTO ivb_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Itoroh ko dyinyo tabo a kitan tomobo a manoroh so botoh kan tabo a kitan kayokayo a may-asi a chabyay nyo. ");
INSERT INTO ivb_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ki itoroh ko do tabo binyay a maywam kan bolaw, kan do tabo a manomanok, as kan do tabo komayakayab do tana, iyaw tametamek saya kan bohobohong no tomobo saya a nawriw chabyay da.” Ki naparin nyaya. ");
INSERT INTO ivb_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Do nakaboyaw no Dyos so tabo pinariparin na saya, naboya na a taywara a maganay. Homnabas mahep kan myan danaw mabekas. Iyaw nyaw chanem narana karaw. ");
INSERT INTO ivb_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Do dawri, iyaw hanyitaya kan tanaya kan tabo mimyan da, ki tayoka dana. ");
INSERT INTO ivb_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Do chapapito naw a karaw, naynahah si Āpo Dyos, ta napakabos na tabo nakapamarswa na. ");
INSERT INTO ivb_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Binindisyonan naw chapapito naw a araw, as pinatarek naw nawri a araw a masisita. Ta iyaw nawri a araw, nakapakabos na so tabo a nakapamarswa na. ");
INSERT INTO ivb_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Komwan pakasaritaan nakaparswa no hanyitaya kan tanaya. Do nakaparswa ni Āpo a Dyos so hanyitaya kan tanaya, ");
INSERT INTO ivb_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","abaw tomnobo do tanaya, kan abaw botoh a tomnobo, ta ari na pad pinachimoy, kan ari pa abo magarado so tana. ");
INSERT INTO ivb_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ki myan ranom a tominbod a mapaybabasa so hapot no tana. ");
INSERT INTO ivb_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Katayoka na, nanghap si Āpo a Dyos so tana, as nakapotar na sya a tawo. Sinpangan na, inyalop naw angesaw no byay do momodan naw no pinotar naw, ki nanyeng a natorohan so byay na. ");
INSERT INTO ivb_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Do dāya, pinarin ni Āpo a Dyos asa minoyongan do Eden. Dawriw pinangayan nas nyaya tawo a pinotar na. ");
INSERT INTO ivb_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Pinatobo daw ni Āpo a Dyos tabo a kita no mapipintas a kayokayo a may-asi so magaganay. Ki do hobokaw no minoyongan, myan dadwa kayo. Iyaw asaw, ki manoroh so byay a abos pandan. Iyaw somarono, ki manoroh so kapatak so maganay kan marahet. ");
INSERT INTO ivb_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Myan oksong a minoyog do Eden a mapaybabasa so minoyonganaw. Nawriw mapagla so mohamoha kan kayokayo daw, as iyaw nawri a oksong, ki naysisyay a nayparin dana apat so simang do gaganaw no minoyongan. ");
INSERT INTO ivb_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Iyaw manōmaw a simang na, ki mayngaran so Pison a moyog do omdibon tana a Habila. ");
INSERT INTO ivb_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Do dyaw pakaboyan so kagaganayan a balitok kontodo nyichit a pakayapwan mangingina a bangbanglo, kan myan paw mapapateg saw a bato daw. ");
INSERT INTO ivb_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Iyaw chadadwaw no simang na, ki mayngaran so Gihon a moyog do omdibonaw do tana a Kos. ");
INSERT INTO ivb_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Iyaw chatatdo naw, ki mayngaran so Tigris a moyog do dayāen Asirya, as iyaw chapataw no simang na, ki mayngaran so Oprates. ");
INSERT INTO ivb_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","On, do Minoyongan no Eden, pinangayan ni Āpo a Dyos so nyaya tawo a mahakay tan paganayen na kan aywanan na. ");
INSERT INTO ivb_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Inbilin nad mahakayaw a kāna, “Maparin mo a kanen aran āngo a asin kayokayo do dyaya, ");
INSERT INTO ivb_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","malaksid do asyayan kayo a makaitoroh so kapatak so maganay kan marahet. Ta do arawaw a kakan mo sya, nailonod ka na a madiman.” ");
INSERT INTO ivb_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Sinpangan na, binata ni Āpo a Dyos, “Maganay aba an maychatanyi iyaw mahakayaya. Pamarin kos omno a kasmang a somidosidong sya.” ");
INSERT INTO ivb_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Do dawri, siraw tabon kitan binyay kan manomanok a pinotar ni Āpo a Dyos a yapod tana, ki inyangay na sa do mahakayaw tan chiban na an āngo ipangaran na dyira. Sigon do inbahey naw do katakatayisa, ki nawri danaw ngaran da. Komwan nakapayngaran da tabo. ");
INSERT INTO ivb_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Do dawri, pinangaranan na san mahakayaw tabo a manomanok kan binyay, ki abaw nachichwasan a makasidong do mahakayaw a kasmang na. ");
INSERT INTO ivb_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","As dawa, pinakaycheh ni Āpo a Dyos iyaw mahakayaw a nandad nakapaynepdep na. Sinpangan na, nanghap so asad taglang no mahakayaw, as nakapayamonyit nas nanghapan naw sya. ");
INSERT INTO ivb_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Pinarin na mabakes iyaw taglangaw a inhap nad mahakayaw, as nakayangay na sya di Adan. ");
INSERT INTO ivb_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Sinpangan na, binata no mahakayaw, “Aysa! Ari danayaw kasmang ko. Iyaw tohang na, ki yapod tohang ko. Iyaw asi na, ki yapod asi ko. Dawa, ipangaran ko ‘mabakes,’ ta yapo dyaken a mahakay.” ");
INSERT INTO ivb_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Dawa, nyaw paynamotan na karwan mahakay āmang kan ānang na an machikabahay. Tan komwan, komplito kapayrapa da kan baket na, as kan sira dadwa, ki mayparin dana sa asa bayo a pamilya. ");
INSERT INTO ivb_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Pariho sa nakalābos mahakayaw kan mabakesaw, ki aba dyiraw kasnek. ");
INSERT INTO ivb_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Do dawri, iyaw boday, ki kasisikapan dyirad tabo a nabyay a pinarin ni Āpo a Dyos. Inyahes na do mabakesaw a kāna, “Oyodori a binata no Dyos dyinyo a dyi nyo a kanen aran āngo a kitan asin kayo do minoyonganaya?” ");
INSERT INTO ivb_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ki tominbay mabakesaw a kāna, “Engga, ta pinalobosanaw yamen ni Āpo Dyos a koman so aran āngo a asin kayo do dyaya a minoyongan, ");
INSERT INTO ivb_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","malaksid do kayowaw a myan do hobok naya, ta baywan na. No inbahey ni Āpo Dyos dyamen, ki an koman kamis asin nawri a kayo mana aran tod namen a masalid, madiman kaminchi.” ");
INSERT INTO ivb_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ki initbay no bodayaw a kāna, “Pi! Taywaran madiman kamo? ");
INSERT INTO ivb_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Komwan binata no Dyos dyinyo, ta chapatak na do oras a makakan kamos nawri a asin kayo, ki mayparin kamonchi a masirib a akma dya a makapatak so maganay kan marahet.” ");
INSERT INTO ivb_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Do nakaboyaw no mabakesaw so kapintas no kayowaw kan kaganay no asi naw a kanen, binata na do aktokto na a oyod a maganay an mayparin sa a masirib. As dawa, namoyis so asyaw no kayo, as nakakan na sya. Do nakatayoka naw a komninan, tinorohan naw lakay naw, dawa, kinan na. ");
INSERT INTO ivb_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Do nakatayoka daw a komninan, nanyeng a natorohan sa a dadwa so kapakapatak, kan natonngan da a silalābos sa. Do dawri, napaytatachip sa so bohobohongaw no kayowaw a mayngaran so igos a pinangolib das inawan da. ");
INSERT INTO ivb_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Do kamakoyāb danaw, nadngey daw kayasakasaw ni Āpo a Dyos a mayam do minoyonganaw, ki tomnayo sa do kayokayo saw daw. ");
INSERT INTO ivb_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ki tinawagan Āpo a Dyos mahakayaw a kāna, “Adan, āngo pachichibeng mo daw?” ");
INSERT INTO ivb_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Tominbay mahakayaw a kāna, “On, ata, nadngey kwaw kayasakas mo do minoyonganaya, ki mamo ako dyimo, kan tomnayo ako, ata, silalābos akwaya.” ");
INSERT INTO ivb_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ki inyahes ni Āpo a Dyos dya a kāna, “Sino nangibahey a silalābos ka? Komninan kawris asyaw no kayo a inbilin ko dyimo a dyi mo a kanen?” ");
INSERT INTO ivb_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","“On, ata, iyaw mabakesaya intoroh mo a rarayay ko, iyaw nanoroh dyaken so asin kayo a kinan ko,” initbay no mahakayaw. ");
INSERT INTO ivb_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ki inyahes ni Āpo a Dyos do mabakesaw a kāna, “Āngo ta pinarin mo komwan?” “On, ata, inallilaw naw yaken bodayaw, dawa, komninan ako,” binata no mabakesaw. ");
INSERT INTO ivb_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Sinpangan na, binata ni Āpo a Dyos do bodayaw a kāna, “Dosaen koymo maynamot do dya pinarin mo. Arwaro abay a mangay dyimo kan siraw tabo no binyay a maywam kan bolaw. Dawa, yapo sichangori, bodek mo naw payamen mo, as ahbek danaw kanen mo mandad kadiman mo. ");
INSERT INTO ivb_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Paysin-ipsoken konchinyo kan nyaya mabakes, as nāw danchi a maysin-iipsok no kapotōtan na kan kapotōtan mo. On, padesdesen anchi no kapotōtanaya no mabakes oho mo, ki sonyiten monchiw toben naw.” ");
INSERT INTO ivb_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","As binata na do mabakesaw a kāna, “Paypalidyaten ko kaynyin do kapagpasikal no kapaymanganak mo. On, padidiwan koymo so kaynyin no kapaymangank mo. Ki aran komwan, alit nanchi a katngan mwabaw lakay mwaya, kan itorayan nanchimo.” ");
INSERT INTO ivb_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","As binata na do mahakayaw a kāna, “Inanohdan mo inbaheyaya ni baket mo, kan kinan mo asi no kayo a baywan ko a kanen mo. Maynamot do dya pinarin mo, abayen konchiw tana. Dawa, yapo sichangori a mandad kadiman mo, machita maytarabako ka so marahmet tan myan manawob a chabyay mo. ");
INSERT INTO ivb_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Patobohen nanchin tanaw manolok kan malidyat a yayten a tamek. Koman kanchis dāwa no tametamek a imoha mo. ");
INSERT INTO ivb_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Maynannget kanchi a maytarabako so marahmet do tanaya tan myan chabyay mo mandad kapaybidi mod nakayapwan mo a tana a nakaparinan mo. Yapo kad tana, dawa, maybidi kanchi a tana.” ");
INSERT INTO ivb_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Eba iyaw inpangaran Adan so baket naw, maynamot ta iyaw ānang dan tabo tawotawo. ");
INSERT INTO ivb_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ki namarin si Āpo a Dyos so laylay a yapod lalat no binyay, as pinaylaylay na sa Adan kan Eba. ");
INSERT INTO ivb_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Sinpangan na, binatan Āpo a Dyos a kāna, “Changori, myan danaw kapakapatak no tawo so maganay kan marahet a akma dyaten. Dawa, palobosan ta saba a koman so asin kayo a manoroh so byay tan dyi sa mabyay a abos pandan.” ");
INSERT INTO ivb_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Dawa, binoyaw san Āpo a Dyos sa Adan kan baket na do Minoyongan no Eden, as pinaytarabako na sa do tana a nakapotaran no mahakayaw. ");
INSERT INTO ivb_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Do nakakaro daw do Eden, do mangket do dāya no minoyonganaw, inpabantay ni Āpo a Dyos dyirad sibibyay saw a parswa kan napangay so asa somgesged a apoy a akmay ispada a nāw na somalasalap do aran dino a pakayapwan tan abo makapaypasngen do kayowaw a makaitoroh so byay. ");
INSERT INTO ivb_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Do dawri, do nakapayoknod daw da Adan kan Eba, ki nabogis baket na. Ki do nakapaymanganakaw ni Eba so anak na a mahakay, binata na a kāna, “Maynamot do sidong ni Āpo, ki natorohan ako so anak ko a mahakay.” Dawa, Kain inpangaran na. ");
INSERT INTO ivb_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ki minirwa dana naymanganak si Eba so asa mahakay, as pinangaranan nas Abel. Nayparin si Abel a magpaspastor so binyay, as nayparin si Kain a maymohamoha. ");
INSERT INTO ivb_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Do nakapaypahabas no araw do nakapaytarabakwaw ni Kain, inhap naw kadwanaw a āpit na, as nakaidāton na sya di Āpo. ");
INSERT INTO ivb_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ki si Abel, inhap naw kagaganayan saw a katotonngan a orbon karniro na, as nakaparti na sya, as nakahap nas kagaganayanaw a asi kan taba da, as nakaidāton na sya di Āpo. Nahwahok si Āpo di Abel kan iyaw dāton naw. ");
INSERT INTO ivb_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ki chinahwahok nabas Kain kan iyaw dāton naw. Dawa, naychadangedanget si Kain do oltimo a soli na. ");
INSERT INTO ivb_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Do dawri, binata ni Āpo di Kain a kāna, “Āngo ta makasoli ka? Āngo ta maychadangedanget ka? ");
INSERT INTO ivb_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","An pinarin mo maganay, ki masoyot kabawri? Maynamot ta namarin kas marahet, ki akmas marongsotaw a binyay gatos mo a omdadaan a mangranggas dyimo. Chakey naymo a itorayan, ki machita abāken mo.” ");
INSERT INTO ivb_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Sinpangan na, binata ni Kain di ādi nas Abel a kāna, “May ta do hakawan.” Do kayan daranaw do hakawan, kinelbat na a diniman si Abel. ");
INSERT INTO ivb_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ki do dawri, inyahes ni Āpo di Kain a kāna, “Dino yanan ādi mos Abel?” Initbay ni Kain a kāna, “Katen, mo Āpo. Taywaran yaken mangaywan so ādi kwaw?” ");
INSERT INTO ivb_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ki binatan Āpo dya a kāna, “Taywara marahet pinarin mwaya! Iyaw raya no ādi mo a nachikneb do tanaya, ki akmay machipakpakaāsi dyaken a bahsen koymo. ");
INSERT INTO ivb_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Sichangori, nabay ka na a mabaywan a homakaw so tanaya a pinakneban mo so rayaw ni ādi mo. ");
INSERT INTO ivb_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","An mohan mo tana, abanchiw maapit mo. Nāw monchi a abos bahay, kan tod ka mayadiyadis do hapotaya no tanaya.” ");
INSERT INTO ivb_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ki binata ni Kain di Āpo a kāna, “Ayya! Taywara danaya so karahmet dosa ko, kan marawa kwabaw nawri. ");
INSERT INTO ivb_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ayya! Boyawen mo na yaken do dya tana kan do salapen mo! Tod ako nanchi a mayadiyadis a abos bahay a abos syirto a ngayan do tanaya, kan dimanen danchi yaken aran sino a makaboya dyaken.” ");
INSERT INTO ivb_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ki tominbay si Āpo a kāna, “An myan anchiw mangdiman dyimo, maypapitonchi dyaw dosaya a inbahey ko dyimo.” Dawa, do dawri, pinangayan Āpo so marka na si Kain tan dya dimanen no aran sino a makabayat sya. ");
INSERT INTO ivb_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Komnaro si Kain do salapen ni Āpo, kan minyan do tana a mayngaran so Nod do dayāen no Eden. ");
INSERT INTO ivb_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Do dawri, do nakapayoknod daw da Kain kan baket na, nabogis baket na. Naymanganak so mahakay, ki pinangaranan nas Enok. Do dawri, inrogi ni Kain napatnek so asa idi a pinangaranan nas Enok a ngaran pōtot naw. ");
INSERT INTO ivb_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Myan pōtot ni Enok a mayngaran so Irad, iyaw āmang ni Mehodyael a āmang ni Metosael a āmang ni Lamek. ");
INSERT INTO ivb_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Siraw kabahay ni Lamek, ki dadwa sa, sa Ada kan Silla. ");
INSERT INTO ivb_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Inyanak ni Ada si Jabal a iyaw kapoonan dan magpaspastor saw so binyay, kan minyan sa do tolda. ");
INSERT INTO ivb_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Si Jobal, no ngaran no ādi na mahakay. Ki iyaw kapoonan dan tabo a magtoktokar so arpa kan pīto. ");
INSERT INTO ivb_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","As si Silla, inyanak na paw mahakay a si Tobal Kain. Si Tobal Kain, ki manyichipo so matatarek a kitan riminta a yapod bronsi kan pasek. Si Naama, ki kakteh a mabakes ni Tobal Kain. ");
INSERT INTO ivb_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Inpangas ni Lamek dyirad baket na saw a kāna, “Inyom Ada kan Silla, adngeyen nyo pa yaken. Diniman ko asa baro maynamot ta pinaynyinan naw lang yaken. ");
INSERT INTO ivb_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","An sino mangdiman di Kain, maypapitonchi dyaw dosa, ki no mangdiman dyaken, ki maypapitonchi a poho kan papito dyaw dosa.” ");
INSERT INTO ivb_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Mirwa nayoknod sa Adan kan baket na, ki nabogis baket na. Naymanganak so mahakay, kan binata ni Eba a kāna, “Tinorohan yaken ni Āpo Dyos so anak a mahakay a tadin Abel a diniman ni Kain.” Dawa, pinangaranan nas Set. ");
INSERT INTO ivb_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Myan pōtot ni Set a mahakay a pinangaranan nas Enos. Do dawri, rinogyan tawo maydasal di Āpo do kaidaydāyaw da sya. ");
INSERT INTO ivb_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Nyaw pakasaritaan dan kapotōtan saw ni Adan. Do nakaparswaw ni Āpo Dyos so tawo, pinarswa naw tawo a akma dya. ");
INSERT INTO ivb_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Pinarswa na sa mahakay kan mabakes. Binindisyonan na sa, kan pinangaranan na sas “Tawo.” ");
INSERT INTO ivb_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Do nakapagtawen ni Adan so 130, myan pōtot na mahakay a akma dya a pinangaranan nas Set. ");
INSERT INTO ivb_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Yapod nakaiyanak ni Set, nabyay pas Adan so 800 a tawen. Myan pa saw kadwan a pōtot na mahahakay kan mababakes. ");
INSERT INTO ivb_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Nadiman si Adan do nakapagtawen nas 930. ");
INSERT INTO ivb_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Do nakapagtawen ni Set so 105, myan pōtot na a mahakay a si Enos. ");
INSERT INTO ivb_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Yapod nakaiyanak ni Enos, nabyay pas Set so 807 a tawen. Myan pa saw kadwan a pōtot na mahahakay kan mababakes. ");
INSERT INTO ivb_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Nadiman si Set do nakapagtawen nas 912. ");
INSERT INTO ivb_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Do nakapagtawen ni Enos so 90, myan pōtot na a mahakay a si Kenan. ");
INSERT INTO ivb_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Yapod nakaiyanak ni Kenan, nabyay pas Enos so 815 a tawen. Myan pa saw kadwan a pōtot na mahahakay kan mababakes. ");
INSERT INTO ivb_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Nadiman si Enos do nakapagtawen nas 905. ");
INSERT INTO ivb_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Do nakapagtawen ni Kenan so 70, myan pōtot na a mahakay a si Mahalalel. ");
INSERT INTO ivb_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Yapod nakaiyanak ni Mahalalel, nabyay pa si Kenan so 840 a tawen. Myan pa saw kadwan a pōtot na mahahakay kan mababakes. ");
INSERT INTO ivb_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Nadiman si Kenan do nakapagtawen nas 910. ");
INSERT INTO ivb_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Do nakapagtawen ni Mahalalel so 65, myan pōtot na a mahakay a si Jared. ");
INSERT INTO ivb_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yapod nakaiyanak ni Jared, nabyay pa si Mahalalel so 830 a tawen. Myan pa saw kadwan a pōtot na mahahakay kan mababakes. ");
INSERT INTO ivb_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Nadiman si Mahalalel do nakapagtawen nas 895. ");
INSERT INTO ivb_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Do nakapagtawen ni Jared so 162, myan pōtot na a mahakay a si Enok. ");
INSERT INTO ivb_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Yapod nakaiyanak ni Enok, nabyay pas Jared so 800 a tawen. Myan pa saw kadwan a pōtot na mahahakay kan mababakes. ");
INSERT INTO ivb_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Nadiman si Jared do nakapagtawen nas 962. ");
INSERT INTO ivb_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Do nakapagtawen Enok so 65, myan pōtot na mahakay a si Matosalem. ");
INSERT INTO ivb_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Yapod nakaiyanak ni Matosalem, ki nāw ni Enok a intalek byay na di Āpo Dyos do irahem no 300 a tawen. Myan pa saw kadwan a pōtot na mahahakay kan mababakes. ");
INSERT INTO ivb_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","No bidang no tawen a nakabyay na, ki 365 a tawen. ");
INSERT INTO ivb_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Do dawri, maynamot ta nāw na naybibyay a monot do chakey no Dyos, naychihat a abo daw, ta inhap dana ni Āpo Dyos. ");
INSERT INTO ivb_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Do nakapagtawen Matosalem so 187, myan pōtot na mahakay a si Lamek. ");
INSERT INTO ivb_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Yapod nakaiyanak ni Lamek, nabyay pas Matosalem so 782 a tawen. Myan pa saw kadwan a pōtot na mahahakay kan mababakes. ");
INSERT INTO ivb_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Nadiman si Matosalem do nakapagtawen nas 969. ");
INSERT INTO ivb_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Do nakapagtawen ni Lamek so 182, myan pōtot na mahakay. ");
INSERT INTO ivb_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Pinangaranan nas Noyi, kan binatan Lamek a kāna, “Iyaw nyaya adekey, ki manoroh anchi dyaten so kapangahwahok do marahmet a tarabako ta do tanaya a inabay ni Āpo.” ");
INSERT INTO ivb_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Yapod nakaiyanak ni Noyi, nabyay pas Lamek so 595 a tawen. Myan pa saw kadwan a pōtot na mahahakay kan mababakes. ");
INSERT INTO ivb_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Nadiman si Lamek do nakapagtawen nas 777. ");
INSERT INTO ivb_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Do nakapagtawen ni Noyi so 500, myan pōtot na tatdo a mahahakay: sa Sem, Ham, kan Japet. ");
INSERT INTO ivb_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Do dawri, naypayparo saw tawotawo do intīro a lobong, kan nayparo nayanak a mababakes. ");
INSERT INTO ivb_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ki myan saw naparswa a yapo do hanyit a nakaboya so kapipintas dan nya mababakes a anak no tawo. Dawa, inhap da saw chinakey daw a binaket. ");
INSERT INTO ivb_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ki binatan Āpo a kāna, “No ispirito ko a intoroh ko do tawotawo, ki ipalōbos kwaba a omyan dyira a abos pandan, ta tawo sa lang. Makayapo sichangori, mabyay pa saba so masorsorok kan 120 a katawen.” ");
INSERT INTO ivb_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Do dawri a chimpo kan somarsarono pa, myan saw siganti do tanaya a anak dan mababakes saw a binaket dan naparswaw a yapod hanyit. As siraw nyaya anak da do kaychowa pa, ki nagdindinamag kan matotored sa a tawo. ");
INSERT INTO ivb_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Naboya ni Āpo a taywaraw karahet no tabo tawotawo do tanaya, kan aba polos naktokto da a maganay, an dya maynana marahet. ");
INSERT INTO ivb_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Maynamot do dyaya, chinaliday ni Āpo nakapamarswa nas tawotawo do tanaya, kan oltimo a chinaynyin aktokto na. ");
INSERT INTO ivb_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","As dawa, binata ni Āpo a kāna, “Abohen ko saw nya tawotawo a pinarswa ko do tanaya. Ki tawo aba lang, an dya siraw tabo a kitan binyay, siraw komayakayab do tana, kan siraw manomanok, ta chinaliday ko nakaparswa ko sira.” ");
INSERT INTO ivb_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ki do dawri, do nakaboyaw ni Āpo si Noyi, ki nahwahok. ");
INSERT INTO ivb_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Nyaw pakasaritaan ni Noyi. Tatdo saw pōtot na a mahahakay: sa Sem, Ham, kan si Japet. Do dawri a chimpo, si Noyi lang malinteg a tawo, ta pinarin naw chakeyaw ni Āpo Dyos. ");
INSERT INTO ivb_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ki an maynamot do tawotawo do tanaya, ki oltimo sa so karahet do salapen no Dyos, kan do aran dino, ki matatangsit sa kan abaw linteg dyira. ");
INSERT INTO ivb_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","On, naboya ni Āpo Dyos tabo tawotawo do tanaya, ki malit sa do makabābabaw a dadakay da a nachikneb do marahet. ");
INSERT INTO ivb_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Sinpangan na, binata ni Āpo Dyos di Noyi a kāna, “Naoma ako naya do taywaraya karahet da no tawotawo saya. As dawa, ikeddeng ko na a abohen ko tabo tawotawo do tanaya. On, abohen ko tabo nabyay, ta nakneb danaw tanaya do matatangsit a abos linteg a kaparin da. ");
INSERT INTO ivb_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ki imom Noyi, mamarin kas biray, kan osaren mo saw mahnyi a kayo. Mamarin kas kwarto na sa do irahem, as kolaan mos arkitlan do irahem kan hapot naw. ");
INSERT INTO ivb_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Parinen mo a 133 a kamitro kanaro na, as 22 a kamitro kawbong na, kan 13 a kamitro katohos na. ");
INSERT INTO ivb_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Mamarin kas atep na, kan payan mos 44 a sintimitro do payawan atep kan dyindyin na. As no katohos na, parinen mo a tatdo a kasagonodan, as pangayan mos pantaw na do bakrang naw. ");
INSERT INTO ivb_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Layosen konchiw tanaya tan mabo saw tabo sibibyay a parswa. Madiman sanchiw tabo a omanges do hapotayan tana. ");
INSERT INTO ivb_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ki machitolag ako dyimo. Anchan tayoka danaw birayaw, somakay kamo kan baket mo kan siraw tatdwaw a anak mo kan siraw babbaket da saw. ");
INSERT INTO ivb_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Apen mod birayaw asa magparis a mahakay kan mabakes do tabo a kita no binyay, tabo a kita no manomanok, kan tabo a kita no komayabkayab do tana tan mabyay sa. ");
INSERT INTO ivb_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Manghap ka pas tabo a kita no mākakan a machita monchi a chabyay nyo kan siraw binyay saw,” binata ni Āpo. ");
INSERT INTO ivb_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Pinarin Noyi a tabo inbilinaw ni Āpo dya. ");
INSERT INTO ivb_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Binata ni Āpo di Noyi a kāna, “Somdep kamo na a asa kapamilyaan do birayaya, ta naboya ko a imo lang malinteg do tanaya sichangori a chimpo. ");
INSERT INTO ivb_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Mangyonot kas taypipito a mahahakay kan mababakes do kāda binyay a naibidang a madalos a maparin a idāton, ki asa lang a kaparis iyonot mo a mahakay kan mabakes do kāda binyay a dya naibidang a madalos. ");
INSERT INTO ivb_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Komwan pa a mangyonot kas taypipito a mahahakay kan mababakes do tabo a kita no manomanok. Parinen mo nyaya tan mabyay sanchiw tabo kita no binyay kan manomanok, as maymanganak sanchi do hapotayan tana. ");
INSERT INTO ivb_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ta do chapapito naw anchi a karaw somiknan sichangori, chimoyen konchiw lobongaya do apat a poho a karaw kan apat a poho a kahep tan madiman sa tabo nabyay a pinarswa ko.” ");
INSERT INTO ivb_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Tinongpal ni Noyi iyaw tabo inbilinaw no Āpo dya. ");
INSERT INTO ivb_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nagtawen si Noyi so 600 do kasiknan layos do tanaya. ");
INSERT INTO ivb_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Do dawri, somindep si Noyi kan baket na, siraw anak naw kan siraw babbaket da saw tan maiditchan sad layos. ");
INSERT INTO ivb_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Tabo kita no binyay kan manomanok kan no komayakayab sa do tana, madalos kan dya maibidang a madalos, ki nangay sa di Noyi, as tayisa sa kaparis a nachirayay di Noyi a somindep do birayaw a akmas inbilinaw ni Āpo Dyos. ");
INSERT INTO ivb_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Oyod, do chapapito naw a karaw, somniknan danaw layos do tanaya. ");
INSERT INTO ivb_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Do chanem naranaw a gasot a katawen no kabyay ni Noyi, do chadadwa naw a bohan, do chaasa poho na kan papito a karaw, naychihat sa napaboswang tabo a akbod a rarakoh do tāw kan do irahem no tana. On, akmay napakaro ombalataw so ranom do hanyit, ta nachimoy so mawyas, ");
INSERT INTO ivb_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","as nāw na mayit chimoy do apat a poho a karaw kan mahep. ");
INSERT INTO ivb_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Do dawri a araw, do kasiknan danaw no chimoy, somnakay sa Noyi kan baket na, siraw tatdwaw a anak da a sa Sem, Ham, kan si Japet, kan siraw babbaket da saw do birayaw. ");
INSERT INTO ivb_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Nachirayay dana sa lomnogan tabo a kita no nabyay do hapotayan tana, maywam kan bolaw, tabo a kita no komayakayab do tana, kan tabo a kita no manomanok. ");
INSERT INTO ivb_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Tayisa a kaparis do kāda kita no sibibyay a parswaw, somindep do birayaw a nachirayay di Noyi. ");
INSERT INTO ivb_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Komwan pinarin da akmas inbilin ni Āpo Dyos di Noyi. Somindep dana sa, as katayoka na, inanban Āpo iyaw pantawaw no biray. ");
INSERT INTO ivb_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Do dawri, nalayos so apat a poho a karaw, ki nayparahem ranom a nandad nakaihataw no birayaw. ");
INSERT INTO ivb_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","On, naypayparahem ranomaw do tanaya, as kan nachilyod danaw birayaw do hapotaw no ranom. ");
INSERT INTO ivb_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Nāw na tinongtong no ranomaw naypayparahem mandan natonep dana saw katotohosan saw a tokotokon. ");
INSERT INTO ivb_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Naypayparahem pa a nandad nakarapit nas papito a kamitros so katwatohos kan totok daw no katotohosan saw a tokotokon. ");
INSERT INTO ivb_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Nahmes sa tabo nabyay a parswa do hapotayan tana, siraw manomanok, binyay a maywam kan bolaw, siraw komayakayab do tana, kan tabo a tawotawo. ");
INSERT INTO ivb_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","On, nadiman a tabo myan so anges do hapotayan tana. ");
INSERT INTO ivb_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Inabo ni Āpo tabo sibibyay do hapotayan tana: tawotawo, binyay, siraw komayakayab do tana, kan siraw manomanok. Ki sa Noyi dana lang nabyay kan siraw rarayay naw do birayaw. ");
INSERT INTO ivb_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Nāw na pa natonep no tanaya do irahem no 150 a karaw. ");
INSERT INTO ivb_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Nawayakan aba ni Āpo Dyos sa Noyi kan tabo binyay saw a kinayrayay dad birayaw. Dawa, pinaysasalawsaw ni Āpo Dyos a nawri danaw siniknanan nakain-īnot no ranomaw a minelda. ");
INSERT INTO ivb_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Nagsardeng danaw ranomaw a tominbod do irahem no tana, as kan nahangan dana, ta naseraan danaw pakayapwan naw no ranom. ");
INSERT INTO ivb_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","In-īnot a mineldaw ranomaw a mandan tayokaw no 150 a karaw. ");
INSERT INTO ivb_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ki do nakapakarapit no asa poho kan papito a karaw do chapapito naw a bohan, nakabat birayaw do asa tokon do tokotokon saw do tana no Ararat. ");
INSERT INTO ivb_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Naypaypadekey ranomaw, as do manōmaw a araw no chaasa poho naranaw a bohan, nakachibaw totok saw no tokotokonaw. ");
INSERT INTO ivb_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Napahabas pa so apat a poho a karaw, as nakapanyiwang ni Noyi do pinarin naw a bintan no biray, ");
INSERT INTO ivb_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","as nakapangari na so asa kak, ki naybidi aba, ta nāw na somnayasayap a naydidibon a mangnanaya so kayachi no ranomaw. ");
INSERT INTO ivb_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Sinpangan na, napasayap pas Noyi so boyit tan chiban na an nayachan danaw ranomaw, ");
INSERT INTO ivb_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ki abaw naboyan boyitaw a adnan na, ta natonep pa no ranom iyaw tanaw. Dawa, naybidiw boyitaw do birayaw, as kan pinabidi ni Noyi do irahem. ");
INSERT INTO ivb_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Do dawri, napahabas si Noyi so papito pa karaw, as nakari na minirwa so boyitaw. ");
INSERT INTO ivb_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ki naybidi dya do kapaysarisari, kan nangisem boyitaw so ablak a bohong no olibo. Nyaw nakatonngan Noyi a minelda danaw ranomaw. ");
INSERT INTO ivb_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","As dawa, ninanaya na paw papito pa karaw, as nakapasayap narana minirwa so boyitaw, ki naybidi paba dya. ");
INSERT INTO ivb_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Do chanem naranaw a gasot kan asa a katawen no kabyay ni Noyi, do manōmaw a araw no manōma bohan, nayachan danaw ranom. Rinakrak ni Noyi iyaw atepaw no birayaw a nangtalamadan nas tana, ki naboya na makey dana mabkohan. ");
INSERT INTO ivb_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Do chadadwa naranaw a poho kan papito a araw do chadadwa naw a bohan, nabkohan dana golpiw tana. ");
INSERT INTO ivb_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","16","Binata ni Āpo Dyos di Noyi a kāna, “Mohbot kamo na kan baket mo, as kan siraw anak mwaya kan siraw babbaket da saya. ");
INSERT INTO ivb_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Pahtoten nyo sa tabo manomanok, tabo binyay saya, kan tabo komayakayab saw do tana tan maymanganak sa, kan mayparo sa do hapotayan tana.” ");
INSERT INTO ivb_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Dawa, gominchin si Noyi kan si baket na, as kan siraw anak da saw a mahahakay kan siraw baket da saw. ");
INSERT INTO ivb_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Tabo saw binyay, komayakayab do tana, kan manomanok, ki minohbot sa do birayaw sigon do kapapayngay daw a kita. ");
INSERT INTO ivb_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Napatnek si Noyi so pangidātonan na di Āpo, as nakahap na so tayisa dyirad maibidangaw a madalos a binyay kan manomanok, as nakasosoh na sira do pangidātonanaw tan idāton na di Āpo. ");
INSERT INTO ivb_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ki do nakangotaw sya ni Āpo, chinadaw na. Dawa, binata na do aktokto na, “Abayen ko pabanchi a polos tanaya maynamot do pinariparin no tawo, ta chapatak ko a marahet aktokto da a yapod kadēkey da. Dimanen ko pabanchi a polos a tabo sibibyay a parswa a akmas pinarin kwaya. ");
INSERT INTO ivb_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Mandanchan machipandaw tanaya, nāw narananchi a myan chimpo no kapaymoha kan chimpo no kapagapit. Masaw a myan chimpon kahanebneb kan chimpon kakohat, chimpon rayon kan chimpon ammyan, maraw kan mahep.” ");
INSERT INTO ivb_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ki binindisyonan ni Āpo Dyos sa Noyi kan siraw anak naw a mahahakay. Binata na dyira a kāna, “Mayparo kamo tan omyan sanchiw kapotōtan nyo saw do tabo a yanan do tanaya. ");
INSERT INTO ivb_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Tabo a binyay, manomanok, komayakayab do tana, kan among, ki chamo danchinyo a tawo, ta inyonchiw mangitoray so tabo a nabyay do tanaya. ");
INSERT INTO ivb_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Sichangori, maparin nyo sa ichan a tabo nya, ta itoroh ko dyinyo a chabyay nyo a akmas nakaitoroh kwaw dyinyo so magla saya mohamoha do nakarahan. ");
INSERT INTO ivb_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Maganay sa tabo a ichan malaksid do karni a myan pas raya. Baywan ko, ta no raya, ki nawri danaw yanan byay. ");
INSERT INTO ivb_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Aran sino a mangdiman so tawo, ki madosa anchi. As an mangdiman binyay so tawo, ki machita pa madiman. ");
INSERT INTO ivb_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","On, no aran sino a mangdiman so kapayngay na tawo, ki dimanen anchi no kapayngay na tawo, ta an maynamot do tawo, ki pinarin ko a akma dyaken a Dyos. ");
INSERT INTO ivb_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“As inyo, mayparo kamo tan omyan sanchiw kapotōtan nyo saw do tabo a yanan do tanaya.” ");
INSERT INTO ivb_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Binata pa no Dyos di Noyi kan siraw anak naw a mahahakay a kāna, ");
INSERT INTO ivb_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Sichangori, machitolag ako dyinyo kan siraw kapotōtan nyo saw ");
INSERT INTO ivb_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","kan tabo a sibibyay a parswa, siraw manomanokaw kan binyayaw a siraw tabo a rarayay nyo a minohtot do birayaw. ");
INSERT INTO ivb_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nyayaw tolag ko dyinyo: Ikari ko a pirwahen ko pabanchi a dimanen so layos tabo nabyay, as polos a apabanchiw layos a mangrarayaw so intīro a tana. ");
INSERT INTO ivb_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","On, as kan tan maboya iyaw abos pandan a nakapachitolag ko dyinyo kan siraw sibibyayaya a parswa, ");
INSERT INTO ivb_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ki pangayen ko karirang ko do kademdeman, ta nyaw pakaboyan anchi so nakapachitolag ko dyinyo a myan do tanaya. ");
INSERT INTO ivb_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Kāda paykonemen ko do kademdeman, as mohtot karirangaya, ");
INSERT INTO ivb_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","naknakmen konchi iyaw kari kwaya dyinyo kan siraw binyay saya a iyaw kabo dananchi a polos no layos a mangdiman so tabo nabyay. ");
INSERT INTO ivb_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Kāda mohtot karirangaya do kademdeman, chiban konchi, as manakem konchiw abwayas pandan a nakapachitolag ko do tabo a sibibyay a parswa do tanaya.” ");
INSERT INTO ivb_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Binata pa no Dyos di Noyi a kāna, “Nyaw pakaboyan ko so nakapachitolag ko do tabo a sibibyay a parswa do tanaya.” ");
INSERT INTO ivb_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Siraw anakaw ni Noyi a mahahakay a minohbot do birayaw, ki sa Sem, Ham, kan Japet. Si Ham, ki āmang ni Kanaan. ");
INSERT INTO ivb_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Siraw nya tatdo a anak ni Noyi, ki siraw kapoonan dan tabo a tawo do tanaya. ");
INSERT INTO ivb_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Do dawri, si Noyi, ki asa maymohamoha, as iyaw nanoma a naymoha so aro a obas. ");
INSERT INTO ivb_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Myan naypisa a mininom so palek no obas, ki nabok. Dawa, naybahabahas, as nakapakaycheh na do tolda naw a silalābos. ");
INSERT INTO ivb_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Do dawri, pinakakdekden ni Ham a āmang ni Kanaan si āmang na a silalābos, ki minohtot a yangay na inbahey dyirad dadwaw a kakakteh na. ");
INSERT INTO ivb_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ki do nakadngey daw sya da Sem kan Japet, sigida nanghap sas ayob, as nakapakekeh da sya, kan tomnadyichokod sa a somindep. Do dawri, inayoban da, kan minididit saba tan dyi da maboya si āmang da a silalābos. ");
INSERT INTO ivb_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Sinpangan na, do nakapakaosawaw ni Noyi, natonngan naw pinarinaw dya ni Ham. ");
INSERT INTO ivb_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Dawa, binata na a kāna, “Mabay pakononchiw kapotōtan Kanaan, kan mayparin sa pakononchi a adipen dan kapotōtan kakakteh naw. ");
INSERT INTO ivb_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Maidayaw si Āpo a Dyos ni Sem! As iyaw kapotōtan ni Kanaan, ki adipen danchi no kapotōtan Sem. ");
INSERT INTO ivb_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Payparahawahen pakono no Dyos tana dan kapotōtan saw ni Japet, as omyan sanchi a machisit dyirad kapotōtan ni Sem. Siraw kapotōtan Kanaan, ki mayparin pa adipen no kapotōtan Japet.” ");
INSERT INTO ivb_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Do nakatayokaw no layos, nabyay pa si Noyi so 350 a katawen. ");
INSERT INTO ivb_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nadiman do nakapagtawen nas 950. ");
INSERT INTO ivb_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Siraw anakaw a mahahakay ni Noyi a sa Sem, Ham, kan Japet, ki myan pōtot da a nayanak do nakatayokaw no layos. ");
INSERT INTO ivb_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Siraw kapotōtan ni Japet, ki siraw tawotawo a Gomer, Magog, Maday, Jaban, Tobal, Mesek, kan Tiras. ");
INSERT INTO ivb_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Siraw kapotōtan ni Gomer, ki siraw tawotawowaw no Askenas, Ripat, kan Togarma. ");
INSERT INTO ivb_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Siraw kapotōtan ni Jaban, ki siraw tawotawowaw no Elisa, Tarsis, Sipros, kan Rodes. ");
INSERT INTO ivb_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Siraw nya tabo a kapotōtan ni Japet, ki kapoonan dan omyanaw do payis no kanayan kan siraw porporwaw. Minyan sa do bokod da saw a gropo do matatarek a tana, as kan myan bokod da a kapaychirin. ");
INSERT INTO ivb_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Siraw kapotōtan ni Ham, ki siraw tawotawo no Kos, Egipto, Pot, kan Kanaan. ");
INSERT INTO ivb_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Siraw kapotōtan ni Kos, ki siraw tawotawo no Seba, Habila, Sabta, Raama, kan Sabteka. Siraw kapotōtan a mahahakay ni Raama, ki siraw tawotawowaw no Sheba kan Dedan. ");
INSERT INTO ivb_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Si Nimrod, ki asa kapotōtan ni Kos. Iyaw nanoma a nagdinamag a mabīleg a machigobat do tanaya. ");
INSERT INTO ivb_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Maynamot do sidong ni Āpo, nayparin a maganay a manganop. Dawa, nyaw nakayapwan panyinyirinaya a, “Payparinen pakono ni Āpo a maganay a manganop a akmas Nimrod.” ");
INSERT INTO ivb_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Do dāmo, no pagāryan ni Nimrod, ki nairaman Babel, Erek, kan Akkad. Tabo nya, ki myan do tana no Babilonya. ");
INSERT INTO ivb_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Yapo do dawri a tana, nangay si Nimrod do Asirya, kan iyaw napatnek siras syodadaw a Ninebe, Rehobot-ir, kan Kala. ");
INSERT INTO ivb_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Pinatnek na paw Resen do payawan no Ninebe kan Kala, iyaw rakohaw a syodad. ");
INSERT INTO ivb_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Siraw kapotōtan ni Egipto, ki siraw tawotawo no Lydia, Anam, Lehab, Napto, kan ");
INSERT INTO ivb_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","siraw tawotawo no Patros, Kaptor, kan Kaslo a nakayapwan dan Pilisteo. ");
INSERT INTO ivb_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Siraw kapotōtan saw ni Kanaan, ki sa Sidon, iyaw katotonngan, kan Het a ādi na, ");
INSERT INTO ivb_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","kan siraw tawotawo saw a Jeboseo, siraw Amorreo, siraw Gergeseo, ");
INSERT INTO ivb_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","kan siraw Hebeo, siraw Arkeo, siraw Sineo, ");
INSERT INTO ivb_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","siraw Arbadeo, siraw Semareo, kan siraw Hamateo. Naychawpit saw nyaya do bokod da a gropo a yapod kapotōtan ni Kanaan. ");
INSERT INTO ivb_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","As no tana dan kapotōtan ni Kanaan, ki yapod Sidon a nandad Gerar do abagātan a masngen do Gasa, as kan nandad Sodoma, Gomorra, Adma, kan Seboyim do dāya a masngen do Lasa. ");
INSERT INTO ivb_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Siraw nya kapotōtan Ham, ki minyan sa do bokod da saw a gropo do matatarek a tana, as kan myan bokod da a kapaychirin. ");
INSERT INTO ivb_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Si Sem, ki iyaw ākang ni Japet, as kan iya paw kapoonan dan tabo Eber mana Hebreo saw a tawotawo. ");
INSERT INTO ivb_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Siraw pōtot ni Sem a mahahakay, ki sa Elam, Assor, Arpaksad, Lod, kan Aram. ");
INSERT INTO ivb_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Siraw pōtot a mahahakay ni Aram, ki sa Os, Hol, Gitir, kan si Mesek. ");
INSERT INTO ivb_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Si Arpaksad, ki āmang ni Sela a āmang ni Eber. ");
INSERT INTO ivb_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Siraw pōtot a mahahakay ni Eber, ki dadwa sa. Iyaw asa, ki mayngaran so Peleg, ta do dawri a chimpo, naycharwaw tawotawo do tanaya. As no kakteh na, ki mayngaran so Joktan. ");
INSERT INTO ivb_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Siraw kapotōtan ni Joktan, ki siraw tawotawo no Almodad, Selep, Hasarmabet, Jera, ");
INSERT INTO ivb_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Osal, Dikla, ");
INSERT INTO ivb_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sheba, ");
INSERT INTO ivb_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opir, Habila, kan Jobab. Sira tabo, ki kapotōtan ni Joktan. ");
INSERT INTO ivb_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Iyaw yanan da, ki yapod Mesa a mandad Separ do dāya, kan paytokotokonan nawri a tana. ");
INSERT INTO ivb_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Siraw nyaw kapotōtan ni Sem, ki minyan sa do bokod da saw a gropo do matatarek a tana, as kan myan bokod da a kapaychirin. ");
INSERT INTO ivb_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Siraw nya a naibahey, ki tabo sa, ki kapotōtan sa ni Noyi do bokod da a gropo kan tana. Katayokan layosaw, tabo saw gropo do tanaya, ki nakayapo sad anak saw a mahahaky ni Noyi. ");
INSERT INTO ivb_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Do dawri a chimpo do katayokaw no layos, ki asā paw kapaychirin dan tabo tawotawo do tanaya. ");
INSERT INTO ivb_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Do nakalongo daw do dāya, ki nakarapit sa do asa tanap do tana no Babilonya a do dawri danaw naybahayan da. ");
INSERT INTO ivb_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Sinpangan na, nagtotolag sa, as nakabata da sya a kon da, “Mamarin tas ladrilyo, as kasosoh ta sya mandan matwa.” Dawa, myan ladrilyo da a pamatnek da kan arkitlan a pamagdedeket da so ladrilyowaw a pinarin da. ");
INSERT INTO ivb_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Do dawri, inpangas da, “Ngay, sichangori, mamarin tas asa syodad a myan so atoy a makarapit do hanyit tan magdindinamag tad tabo tawotawo, as kan tan dyi ta maychawpit do tanaya.” ");
INSERT INTO ivb_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Sinpangan na, naypabodis si Āpo a yapod hanyit tan chiban naw syodad daw kan iyaw makarangaw a atoy a pinarin dan nawri a tawotawo. ");
INSERT INTO ivb_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ki binata ni Āpo a kāna, “Asayaw kapagplano dan nyaya tawotawo, ta asayaw chirin da. Nya parinen da, ki kasiknan da pa, as kan mahay aba as maparin darananchiw aran āngo chakey da parinen! ");
INSERT INTO ivb_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ngay, gomchin ta, kan tatarken taw kapaychirin da tan dyi sa magkakaawātan.” ");
INSERT INTO ivb_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Dawa, pinaychawpit sa ni Āpo do intīro a tana, kan natongtong da paba a pinatnek iyaw no syodad daw. ");
INSERT INTO ivb_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Napangaranan nyaya syodad so Babel, ta dyaw pinaychawawan ni Āpo so kapaychirin tawotawo, as kan yapo sa dyaw pinaychawpit naw a tawotawo do tanaya. ");
INSERT INTO ivb_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Nyaw pakasaritaan dan kapotōtan saw ni Sem. Dadwa katawen nakayapod katayokaw no layos, magtawen si Sem so 100 do dawri, ki myan pōtot na a mahakay a si Arpaksad. ");
INSERT INTO ivb_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Yapod nakayanak ni Arpaksad, nabyay pas 500 a katawen. Myan pa saw kadwan a pōtot na mahahakay kan mababakes. ");
INSERT INTO ivb_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Do nakapagtawenaw ni Arpaksad so tatdwa poho kan dadima, myan pōtot na a mahakay a si Shela. ");
INSERT INTO ivb_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Yapod nakayanak ni Shela, nabyay pas 403 a katawen. Myan pa saw kadwan a pōtot na mahahakay kan mababakes. ");
INSERT INTO ivb_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Do nakapagtawen ni Shela so tatdwa poho, myan pōtot na mahakay a si Eber. ");
INSERT INTO ivb_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Yapod nakayanak ni Eber, nabyay pas 403 a katawen. Myan pa saw kadwan a pōtot na mahahakay kan mababakes. ");
INSERT INTO ivb_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Do nakapagtawen Eber so tatdwa poho kan apat, myan pōtot na a mahakay a si Peleg. ");
INSERT INTO ivb_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Yapod nakayanak ni Peleg, nabyay pas 430 a katawen. Myan pa saw kadwan a pōtot na mahahakay kan mababakes. ");
INSERT INTO ivb_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Do nakapagtawen Peleg so tatdo a poho, myan pōtot na a mahakay a si Reo. ");
INSERT INTO ivb_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Yapod nakayanak ni Reo, nabyay pas 209 a katawen. Myan pa saw kadwan a pōtot na mahahakay kan mababakes. ");
INSERT INTO ivb_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Do nakapagtawen Reo so tatdo a poho kan dadwa, myan pōtot na a mahakay a si Serog. ");
INSERT INTO ivb_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Yapod nakayanak ni Serog, nabyay pas 207 a katawen. Myan pa saw kadwan a pōtot na mahahakay kan mababakes. ");
INSERT INTO ivb_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Do nakapagtawen Serog so tatdo a poho, myan pōtot na a mahakay a si Nahor. ");
INSERT INTO ivb_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Yapod nakayanak ni Nahor, nabyay pas 200 a katawen. Myan pa saw kadwan a pōtot na mahahakay kan mababakes. ");
INSERT INTO ivb_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Do nakapagtawen Nahor so dadwa poho kan sasyam, myan pōtot na a mahakay a si Tera. ");
INSERT INTO ivb_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Yapod nakayanak ni Tera, nabyay pas Nahor so 119 a tawen. Myan pa saw kadwan a pōtot na mahahakay kan mababakes. ");
INSERT INTO ivb_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Do nakapagtawen Tera so papito a poho, myan tatdo a pōtot na a mahahakay a sa Abram, Nahor, kan Haran. ");
INSERT INTO ivb_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Nyaw pakasaritaan dan kapotōtan saw ni Tera a āmang ni Abram, Nahor, kan Haran. Si Haran, ki āmang ni Lot. ");
INSERT INTO ivb_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Nadiman si Haran do nakayanakan naw a tana a do syodad a Or do tana a Babilonya do kayan paw a mabyay ni Tera a āmang na. ");
INSERT INTO ivb_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Kinabahay ni Abram si Sarai. Kinabahay ni Nahor kaanakan naw a si Milka a anak ni Haran a āmang pa ni Iska. ");
INSERT INTO ivb_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","As si Sarai, ki hopes, dawa, abaw anak na. ");
INSERT INTO ivb_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","As si Tera, inhap na si Abram a anak na, kan si Lot a apōko na a anak ni Haran, kan si Sarai a manogang na a baket no anak naw a si Abram, as nasa sa a komnaro do Or do Babilonya, ta mangay sa do tana a Kanaan. Ki sakbay a nakarapit sa do Kanaan, narapit daw tana a Haran, as minyan sa daw. ");
INSERT INTO ivb_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Do dawriw nakadimanan ni Tera do nakapagtawen naw so 205. ");
INSERT INTO ivb_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Sinpangan na, binata ni Āpo di Abram a kāna, “Karwan mo tana mwaya kontodo saw kakabagyan mo saya kan bahay ni āmang mo, as kangay mo do tanaw a ipaboya konchi dyimo. ");
INSERT INTO ivb_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Torohan konchimo so aro a kapotōtan, as mayparo sanchi mandan mayparin sa asa rakoh a nasyon. Bindisyonan konchimo, as matonngan anchin tabo a tawotawo ngaran mo tan mabindisyonan sanchiw tawotawo a maynamot dyimo. ");
INSERT INTO ivb_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Bindisyonan konchiw tawo a mangbindisyon dyimo, as abayen konchiw mangabay dyimo. An maynamot dyimo, bindisyonan konchiw tabo tawotawo do tanaya.” ");
INSERT INTO ivb_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Dawa, do nakapagtawen nas papito a poho kan dadima, komnaro si Abram akmas inbaheyaw ni Āpo dya do idi a Haran a niyanan na, ki nachirayay dya si Lot. ");
INSERT INTO ivb_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Inhap ni Abram si Sarai a baket na, si Lot a kaanakan na, kan tabon warawara a chinpeh da, kan siraw adipen da saw a inhap da do Haran, kan insiknan daw nangay do tana no Kanaan. Do nakapakarapit daw do tana a Kanaan, ");
INSERT INTO ivb_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","nayam si Abram a nandad nakapakarapit nad masngen do idi a Sikem do yanan nagdindinamagaw a kayo ni More. Do dawri a chimpo, omyan pa saw Kananeo a tawo do dawri a tana. ");
INSERT INTO ivb_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Do kayan daw do dawri, napaboya si Āpo di Abram, as nakabata na sya a kāna, “Mo Abram, nya tana, ki itoroh konchi dyira do kapotōtan mo saw.” Dawa, namarin si Abram so pangidātonan na di Āpo a napaboya dya. ");
INSERT INTO ivb_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Katayoka no nawri, nayam a nagpaabagatan do paytokotokonanaw do mangket do dāya no idi a Betel. Sinpangan na, nagtolda sa do payawan Betel kan Ai. No Betel, ki mangket do laod, as no Ai, ki mangket do dāya. Do dawri, pinarin ni Abram pangidātonanaw, as nakadaydayaw na si Āpo. ");
INSERT INTO ivb_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Sinpangan na, tinongtong ni Abram mayadiyadis do yanan kan naypakwan do Negeb do abagātanaw no Kanaan. ");
INSERT INTO ivb_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Do dawri a chimpo, myan nakapaychapteng da do Kanaan a tana. Ki maynamot ta naypangay danaw aptengaw, tinongtong ni Abram naypakwan do abagātanaw a mangay do Egipto, kan minyan daw so dēkey a chimpo. ");
INSERT INTO ivb_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Do kasngen naranaw do Egipto, inbahey ni Abram di Sarai a baket na a kāna, “Ay, chapatak ko a asa ka mapintas a mabakes. ");
INSERT INTO ivb_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Anchan maboya daymo no taga Egipto saw, batahen danchi a kabahay koymo, kan dimanen danchi yaken. Ki imo, ki sigorādo a imonchiw mabyay. ");
INSERT INTO ivb_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Dawa, ibahey monchi dyira a maykakteh ta, ah, tan maynamot anchi dyimo, palobosan danchi yaken a mabyay! Tan komwan, maganay anchiw kaparin da dyaken.” ");
INSERT INTO ivb_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Sinpangan na, do nakapakarapit dad Egipto, naboya dan taga Egipto saw a mapintas sawen baketaw ni Abram. ");
INSERT INTO ivb_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Siraw opisyalis saw do palasyo, ki naboya da pa, kan inpadāyaw dad āryaw kapintas naw. Do nakadngeyaw sya no āryaw a matawagan so Paraon, inpahap nas Sarai do palasyo tan kabahayen na. ");
INSERT INTO ivb_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Maganay pinarin no āryaw di Abram maynamot di Sarai. Tinorohan nas aro a karniro kan kalding, baka, asno, kamilyo, kan adipen a mahahakay kan mababakes. ");
INSERT INTO ivb_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ki maynamot ta inhap no āryaw si Sarai, pinaganyit ni Āpo āryaw kan siraw myan saw do palasyo na, kan sinsinan abaw nya ganyit. ");
INSERT INTO ivb_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Dawa, inpatawag no āryaw si Abram, as nakaiyahes na sya a kāna, “Āngo pinarin mo dyaken? Āngo ta dyi mwa inbahey a baket mo? ");
INSERT INTO ivb_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Āngo ta inbahey mo a kakteh mo, kan ninonolay mwa inhap ko baket mwaya? Ni! Cha dyaw baket mwaya. Apen mo na, as komaro kamo na sigida!” ");
INSERT INTO ivb_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Do dawri, binilin no āryaw soldado na saw a rarayayan da sa Abram a komaro do Egipto. Dawa, nanyeng da rinarayayan sa Abram kan baket na a minohbot. Inhap sa tabon Abram warawara naw. ");
INSERT INTO ivb_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","As dawa, nagpaammyānan si Abram do kahtot naw do Egipto kontodo si baket na kan tabo warawara da, as nakakwan dad Negeb do abagātanenaw no Kanaan. Nachirayay dyira si Lot a kaanakan na. ");
INSERT INTO ivb_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Do dawri, oltimos kabaknang si Abram, ta aro saw binyay na kan aro paw pirak na kan balitok na. ");
INSERT INTO ivb_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Komnaro sa Abram kan rarayay na saw do Negeb, kan nayadiyadis sa so yanan do kalongo daw do Betel a nandad nakarapit das logaraw a payawan no Betel kan Ai a nagtoltoldaan da do nakarahan. ");
INSERT INTO ivb_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Dawri paw namarinan naw so nangidātonan na. As dawa, minirwa dana nagdaydayaw di Āpo do dawri a yanan. ");
INSERT INTO ivb_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Do dawri, si Lot a nachirayay di Abram, ki myan bokod na sa karniro, kalding, kan baka, as kan myan bokod na pamilya kan adipen na saw. ");
INSERT INTO ivb_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Mayengay sa dadwa a aros binyay do asaw a yanan. As dawa, nanawob abaw pagpastwan daw an nāw da mayrapa. ");
INSERT INTO ivb_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Nawriw nanghapan na a pirmiw kapaydidiman dan magpaspastor da saw da Abram kan Lot. Do dawri a chimpo, myan pa sa daw tawotawo saw a Kananeo kan Pereseo a omyan do dawri a tana a pagpastwan da Abram. ");
INSERT INTO ivb_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Sinpangan na, binata ni Abram di Lot a kāna, “Imom Lot, magkabagyan ta. Dawa, dyi ta pakono a palobosan a myan kaynyin aktokto ta a maynamot do kapaydidiman dayan adipen ta saya ah. ");
INSERT INTO ivb_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Maganaganay āno an maysyay ta na? Mamidi ka an dino chakey mo a pamangketan, ta marahawayaw tanaya. An chakey mo iyaw myan do kaholi, mangay akod kawanan. Mana an chakey mo kawanan, kaholiw kwanan ko.” ");
INSERT INTO ivb_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Chiniban a mapya ni Lot, ki naboya na maganay kawyog no ranomaw do intīrwaw a marahawa a tanap no Jordan a mandad Soar a akmas plastaraw no minoyonganaw ni Āpo do Eden mana akma do tanaw do Egipto. Komwan plastar no syodad no Sodoma kan Gomorra do sakbayaw no kararayaw syan Āpo. ");
INSERT INTO ivb_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Dawa, pinidi ni Lot intīrwaw a tanap no Jordan, kan kominwan do mangket do dāya. Komwan nakapaysyay da Abram kan Lot. ");
INSERT INTO ivb_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Sa Abram, ki nabidin sa do Kanaan. Ki sa Lot, ki minyan sa do masngenaw do syodad saw a myan do tanapaw, as nagtolda sa do masngen do Sodoma. ");
INSERT INTO ivb_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ki do dawri, oltimo a karahet dan tawotawo saw daw, kan taywaraw kapaygaygatos da do salapen ni Āpo. ");
INSERT INTO ivb_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ki do dawri, do nakakarwaw ni Lot, binata ni Āpo di Abram a kāna, “Yapod yanan mwaya sichangori, chiban mo tabo a tana do omdibon mwaya, iyaw myanaw do ammyānan, do abagātan, as kan iyaw myan do dāya kan do laod. ");
INSERT INTO ivb_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Tabo a tana a maboya mo, ki dyira mo nanchi a abos pandan kan siraw kapotōtan mo saw. ");
INSERT INTO ivb_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Torohan ko panchimo so arwaro a kapotōtan. Abanchiw makabidang so kāro da, ta maydaydamnay anchi a bidangan ahbek do tanaya kan siraw kapotōtan mo. ");
INSERT INTO ivb_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ngay, yangay mwa bidibidyen tan chiban mo iyaw kanaro kan kawbong na, ta iyaw nyaya tana, ki itoroh ko a tabo dyimo.” ");
INSERT INTO ivb_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Do dawri, nayadis si Abram, kan nangay do Hebron a nagtolda do masngenaw do nagdindinamagaw a kayokayo ni Mamre. Dawriw namarinan nas pangidātonan na di Āpo. ");
INSERT INTO ivb_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Do chimpo daw no apat saw a āri, ki myan gobat. Siraw apat saw a āri, ki sa Amrapel do Babilonya, si Aryok do Elasar, si Kedorlaomer do Elam, kan si Tidal do Goyim. ");
INSERT INTO ivb_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Ginobat daw dadima saw a āri a sa Bera do Sodoma, si Birsa do Gomorra, si Sinab do Adma, si Semeber do Seboyim, kan iyaw āri do Bela mana Soar. ");
INSERT INTO ivb_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","4","Siraw dadima saya a āri, ki intorayan sa no gropwaya ni Āri Kedorlaomer so asa poho kan dadwa a katawen. Ki do chaasa poho naranaw kan tatdo a katawen, nagtotolag saw dadima saya a bonggoy a āri a machiribildi do bonggoy daw da Āri Kedorlaomer. As dawa, chinpeh da no dadima saw bōyot daw do Payahosonganaw no Siddim do bīt naw do bata daranayas changori a Nadiman a Tāw. ");
INSERT INTO ivb_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ki do chaasa poho kan apat a katawen, nangay sa Kedorlaomer kan rarayay na saw a āri kontodo bōyot da saw, as inābak da saw tawotawowaw a Repaim do Asterot Karnaim, siraw tawotawo a Sosim do Ham, siraw tawotawo a Emim do Tanap no Kiriataim, ");
INSERT INTO ivb_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","kan siraw tawotawo a Horeo do katokotokonanaw do Edom. Linakatan da sa a nandad Elparan do payis danaw no let-ang. ");
INSERT INTO ivb_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Sinpangan na, naybidi sa do Kades mana Enmispat, ngaran na do kaychowa. Sinakop da tabo tana saw no Amalekita a tawotawo kan siraw Amorreo a tawotawo a minyan do Hasason Tamar. ");
INSERT INTO ivb_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","As dawa, do dawri, rinaparapa da no aāri no Sodoma, Gomorra, Adma, Seboyim, kan Bela siraw bōyot da saw do Payahosongan Siddim. ");
INSERT INTO ivb_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Dawriw nangnanayan das nakagobat daw siras āri saw do Elam, Goyim, Babilonya, kan Elasar. Dawriw nanggobatan das apat saya āri no dadima saya āri. ");
INSERT INTO ivb_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Do payahosonganaw a paggogobatan da, ki aro saw aridos a napno so birya. Do dawri, naābak dadima saya āri. As dawa, do nakapaychapayapayayo daw do dawri a gobat, siraw kadwan saw a soldado dan āri no Sodoma kan Gomorra, nasday sa do aridos saw. Ki siraw soldado dan kadwanaw a āri, ki nakapayayo sa a kominwan do paytokotokonanaw. ");
INSERT INTO ivb_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Sinpangan na, siraw apataw a āri a nangābak, ki inhap da tabo warawara do Sodoma kan Gomorra kontodo chabyay da saw, as nakakaro da. ");
INSERT INTO ivb_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Do dawri, pinachahahap da pas Lot a kaanakan ni Abram, kan tabo warawara naw, ta do Sodomaw yanan na. ");
INSERT INTO ivb_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Do nakakaro daw, myan nakapagtalaw a asa mahakay a nayyayo a nangibahey di Abram a Hebreo so tabo napariparinaw. Do dawri, omyan si Abram do masngenaw do nagdindinamagaw a kayokayo a dyira ni Mamre a Amorreo a kakteh ni Eskol kan Aner. Nagtotolag saw makakaktehaya kan si Abram a maysinsisidong sa. ");
INSERT INTO ivb_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Do nakapatakaw sya ni Abram a natiliw si Lot a kaanakan na, chinpeh na saw 318 saw a tawo a nasanay do gobat a nayanak sa a yapo do partidos na. Sinpangan na, linakatan da saw apataw a āri a nandad tana do Dan. ");
INSERT INTO ivb_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Do kamahep naranaw, pinaychakarwa na saw rarayay naw, as nakadarop das kabōsor da saw, as kan inābak da saw apataw a āri. Dawa, do nakapayayo daw no āri saw, ki linakatan da sa da Abram a nandad nakapakarapit dad Hobah do ammyānan no Damasko. ");
INSERT INTO ivb_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Nahap ni Abram tabo sinamsam daw no apataw a āri, kan winayawayaan na pas Lot a kaanakan na, as pinaybidi naw tabo warawara na. Insalākan na paw mababakes saw kan siraw kadwan paw a tawotawo a nabahod. ");
INSERT INTO ivb_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Do nakapaybidi danaw ni Abram do nakaābak naranaw sa Kedorlaomer kan rarayay na saw a āri, ki binayat no āryaw no Sodoma do Tanap no Sabe a napangaranan pa so Tanap no Āri. ");
INSERT INTO ivb_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Sinpangan na, binayat nas Abram ni Melkisedek a āri no syodad a Salem, kan iya pa, ki padi no Katotohosan a Dyos. Napantad so tinapay kan arak di Abram. ");
INSERT INTO ivb_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Binindisyonan na si Abram, as nakabata na so nya a kāna, “Iya pakono Katotohosan a Dyos a iyaw Namarswa so hanyit kan tana, mangbindisyon dyimo, mo Abram. ");
INSERT INTO ivb_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Madaydayaw pakono iyaw Katotohosan a Dyos a nanoroh dyimo so bīleg a nangābak dyirad kabōsor mo saw.” Sinpangan na, no pinarin ni Abram, ki intoroh na dyaw apagkapolwaw no tabo nahap na a kinabaknang dyirad apataw a āri. ");
INSERT INTO ivb_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sinpangan na, binata no āryaw no Sodoma di Abram a kāna, “Dyira mo na tabo nahap mo saya warawara. Iya lang akdawen ko dyimo, ki pabidyen mo saw tawotawo kwaya.” ");
INSERT INTO ivb_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ki initbay ni Abram do āryaw no Sodoma a kāna, “Ikari ko di Āpo, iyaw Katotohosanaya a Dyos a iyaw Namarswa so hanyit kan tana a ");
INSERT INTO ivb_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","polos a dyi ako a manghap so aran āngo a dyira mo, aran dēkey a akmas asa kakteb no bolabola mana itan no sapatos. Tan komwan, abanchya polos batan mo sya a, ‘Mabaknang si Abram a maynamot do intoroh ko dya.’ ");
INSERT INTO ivb_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","An yaken, hapen ko abaw aran āngo. Iya lang kinan darana saya no rarayay kwayaw dyi ko a mapaybidi. Ki siraw rarayay kwaya a somnidong dyaken, torohan mo sa so dyira da, sa Aner, Eskol, kan Mamre.” ");
INSERT INTO ivb_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Katayoka no nyaya, nagparmata si Abram, kan nadngey na no chirin ni Āpo dya a kana, “Mamo kaba, mo Abram, ta yaken pinakasarapa mo do aran āngo a pakararayawan mo, kan sinsinan abaw bindisyon ko dyimo.” ");
INSERT INTO ivb_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ki tominbay si Abram di Āpo a kāna, “Imom Āpo a Dyos ko, abaw maitoroh no rakohaya bindisyon dyaken an tod ako a madiman a abos pōtot. Ta anchan madiman ako, si Elieser a taga Damasko, iya lang magtawid so warawara ko. ");
INSERT INTO ivb_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abaya ngamin intoroh mo dyaken a pōtot ko. Iyayaw asaya dyirad adipen kwayaw magtawid so warawara ko.” ");
INSERT INTO ivb_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ki nadngey naw atbay ni Āpo dya a kāna, “Si Elieser abanchiw no magtawid, an dyinchya iyaw mismo a pōtot mo a mahakay.” ");
INSERT INTO ivb_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Sinpangan na, inyangay ni Āpo si Abram do gagan, as nakabata na sya dya a kāna, “Tomangay kad tohos, as kapadas mo sya bidangan bitohen saya. Komwan anchiw kāron kapotōtan mo.” ");
INSERT INTO ivb_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Do dawri, nanganohed si Abram do inbaheyaw ni Āpo, kan maynamot do dyaya nakapanganohed na, inbidang ni Āpo a malinteg do salapen na. ");
INSERT INTO ivb_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Sinpangan na, binata ni Āpo dya a kāna, “Yaken iyaw Dyos a nangihtot dyimo do Or do Babilonya. Itoroh ko dyimo nyaya tana a dyira mo.” ");
INSERT INTO ivb_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ki inyahes ni Abram dya a kāna, “Imom Āpo a Dyos ko, maypāngo kapatak ko sya a dyira ko nyaya tana?” ");
INSERT INTO ivb_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ki tinbay ni Āpo a kāna, “Mangyangay ka dyaken so mabakes a baka, mabakes a kalding, kan mahakay a karniro, kan siraw parihwaw a taytotdo so tawen, as kan manoroh ka pas asa adekey a pahaw kan asa adekey a kalapāti.” ");
INSERT INTO ivb_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Sinpangan na, inyangay ni Abram do Dyos tabo naibaheyaya. Do dawri, inidyowan ni Abram binyay na saw, kan ginelegel na saw manomanokaw. Binhabhak na saw binyay saw malaksid do manomanok saw, kan binatobatoy na sa so dadwa kabatoy, as kan pinaysasalap na sa sigon do kakchidaw no kāda binyay tan myan ayaman do hobok naw. ");
INSERT INTO ivb_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ki myan saw rarakoh a manomanok a akmay kangkang a domina do karnyaw, ki binoyaw san Abram. ");
INSERT INTO ivb_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Do kasdep danaw no araw do dawri, pinaynepdep no Dyos si Abram. Ki do nakapaynepdep naw, myan inpaboya no Dyos a oltimos kasari a yanan, kan do dawri, oltimo nakamo na. ");
INSERT INTO ivb_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ki binata no Dyos dya a kāna, “Masigorādo a gan-ganaet sanchiw kapotōtan mo do tana no matarek. Do dawri, mayparin sanchi a adipen, as malidyalidyatan sanchi daw so apat a gasot a katawen. ");
INSERT INTO ivb_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ki dosāen konchiw nawri a nasyon a mangadipen dyira, as kan anchan ikaro ko sa do dawri a nasyon, aronchiw ahapen da a kinabaknang. ");
INSERT INTO ivb_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","As imo, matahaman mwabaw nawri, ta matalna anchiw kadiman mo. Tod ka nanchi a machangangay a machonot dyirad simna aāpong mo saw do oltimo a kamalkem mo. ");
INSERT INTO ivb_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Anchan marapit danaw chapataw a kapotōtan, nawri dananchiw kapaybidi da dya a tana no kapotōtan mo saw, ta dosāen ko sabaw Amorreo a tawo a omyan do dya sichangori a mandad kapaglipyas no angang ko do karahet da. Nawrinchiw kadosa ko sira.” ");
INSERT INTO ivb_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Do nakasdep danaw no araw, do kasari naranaw, naychihat a myan manghonghob a banga kan somdesdeb a ahoten a mayam do ayamanaw do hobokaw no karni saw. ");
INSERT INTO ivb_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Do dawri a naparin, do dawri a araw, nachitolag si Āpo di Abram a kāna, “Ikari ko a itoroh ko nyaya tana dyirad kapotōtan mo saw, yapod oksong naw do Egipto a mandad magdindinamagaw a Oksong a Oprates. ");
INSERT INTO ivb_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Itoroh ko tabo nyaya tana dyira kontodo tana daya no Kineo, Keneseo, kan siraw Kadmoneo, ");
INSERT INTO ivb_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","siraw Heteo, siraw Pereseo, siraw Repaim, ");
INSERT INTO ivb_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","siraw Amorreo, siraw Kananeo, siraw Gergeseo, kan siraw Jeboseo.” ");
INSERT INTO ivb_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Do dawri, abaw pōtot ni Abram, ta hopes pa si Sarai a baket na. Ki myan adipen ni Sarai a asa mabakes a yapod Egipto a mayngaran so Agar. ");
INSERT INTO ivb_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Binata ni Sarai di Abram a kāna, “Abayaw intoroh ni Āpo dyaken a anak ko. Maganay āno an oknoden mo si Agar a adipen ko? Ta an mapaymanganak mo, iyanchiw anak naw, ki ibidang ko a anak ta.” Do dawri, ki nakey si Abram do inbaheyaw ni baket na. ");
INSERT INTO ivb_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","As dawa, do chaasa poho naw a katawen ni Abram do tana naw a Kanaan, ki inhap ni Sarai a baket na si Agar a adipen na a taga Egipto, as kan intoroh na di Abram, kan nayrapa sa. ");
INSERT INTO ivb_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Do dawri, nayoknod sa Abram kan Agar, ki nabogi si Agar. Ki do nakadidiwaw syan Agar a nabogi, ki tod narana dyābat si Sarai. ");
INSERT INTO ivb_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Dawa, binata ni Sarai di lakay na a kāna, “Imo akin gatos do kabwayan anyib dyaken Agar. Yaken mismo a nanoroh dyimo. Sichangori, maynamot do nakapatak naw sya nabogi, ki ipsok na yaken. Si Āpo pakono mangipaboya an sino dyaten kosto, an imo mana yaken.” ");
INSERT INTO ivb_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ki tinbay ni Abram a kāna, “Ara, ta adipen mwaya! Parinen mo chakey mo dya.” Dawa, linidyalidyat ni Sarai si Agar nandad nakapayayo na. ");
INSERT INTO ivb_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Sinpangan na, napaboya iyaw Anghil ni Āpo di Agar do kayan naw do asaw a akbod do let-ang do rarahanaw a mangay do idi a Sor. ");
INSERT INTO ivb_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ki binata na dya a kāna, “Agar a adipen ni Sarai, dino nakayapwan mo, kan dino kwanan mo?” Ki tominbay si Agar a kāna, “On, ata, payayowan ko āmo kwaw a si Sarai.” ");
INSERT INTO ivb_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ki binata no Anghil ni Āpo dya a kāna, “Maybidi ka kan palobosan mwa iyaw mangitoray dyimo.” ");
INSERT INTO ivb_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Binata na pa dya, “Torohan konchimo so aro a kamanganakan mo, kan abanchiw makabidang sira. ");
INSERT INTO ivb_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Mabogi kas changori, as maymanganak kanchis mahakay. Ki pangaranan monchis Ismael, ta inadngey ni Āpo katanyis mwaw do kalidyatan mo. ");
INSERT INTO ivb_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Maybibyay anchi a akmay bolaw a asno a dya makananawo, as kontraen na sanchiw tabo a tawotawo, as komwan a kontraen danchi iya. As maynamot ta machidiman sa dyaw kakabagyan naw, karwan na sanchi.” ");
INSERT INTO ivb_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Dawa, binata ni Agar do aktokto na, “Aysa! Oyodori a naboya ko Dyos a makaboya dyaken, kan aryak paya sibibyay?” Dawa, pinangaranan nas Āpo a naychirin dya so “Dyos a Makaboya.” ");
INSERT INTO ivb_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Nawriw pinangaranan tawotawo so bobonaw a myan do naypayawanaw no Kades kan Bered so “Bobon No Sibibyay A Dyos A Makaboya Dyaken.” ");
INSERT INTO ivb_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Sinpangan na, naymanganak si Agar so asa mahakay, kan pinangaranan Abram pōtot naw so Ismael. ");
INSERT INTO ivb_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Wawaho a poho kan anem a katawen si Abram do dawri. ");
INSERT INTO ivb_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Do nakapagtawen Abram so sasyam a poho kan sasyam, napaboya si Āpo dya, as nakabata na sya a kāna, “Yaken, ki iyaw Dyos a Manakabalin do tābo. Manganohed ka dyaken, kan nāw mo a maybibyay do kinalinteg tan abo pakapilawan mo. ");
INSERT INTO ivb_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Tan iyaw inkari ko dyimo do nakarahan, ki oyod a tongpalen ko, as kan torohan konchimo so aro a kapotōtan.” ");
INSERT INTO ivb_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Nagrokob si Abram do tana, ki binatan Āpo Dyos dya a kāna, ");
INSERT INTO ivb_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Nyaw itolag ko dyimo: Imonchiw pakayapwan aro a nasnasyon. ");
INSERT INTO ivb_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Abram pabaw ngaran mo sichangori, an dya Abraham, maynamot ta payparinen koymo a āmang no aro saw a nasnasyon. ");
INSERT INTO ivb_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","On, torohan koymo so taywara a aro a kapotōtan, as kan siranchiw pakayapwan aro a nasnasyon. Siranchiw kadwanaw, ki payparinen konchi a āri. ");
INSERT INTO ivb_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“Matadyan aba polos nyaya tolag ko dyimo kan sira panchiw somarsaronwaya kapotōtan mo. Nāw na ikari ko dyimo a yaken danaw Dyos mo, as kan Dyos no kapotōtan mo saw. ");
INSERT INTO ivb_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Gan-ganaet kamo do dyaya tana a yanan nyo sichangori, ki itoroh konchi dyimo nyaya kan siraw kapotōtan mwaw. On, tābo nya tana a Kanaan, ki dyira danchi a abos pandan, kan yaken anchiw Dyos da.” ");
INSERT INTO ivb_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Tinongtong no Dyos naychirin di Abraham a kāna, “As imom Abraham kan siraw kapotōtan mo saya a somarsarono, ki machita nāw nyo a magtongpal do tolag kwaya. ");
INSERT INTO ivb_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Nyaw itolag ko dyimo a machita a magtongpal ka kan siraw tabo kapotōtan mo a machisarono dyimo. Kāda mahakay dyinyo, ki basta makogit. ");
INSERT INTO ivb_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","On, machita makogit ka, ta nawri danaw pakaboyan a oyod a manganohed ka dyaken kan tongpalen mo tolag kwaya. ");
INSERT INTO ivb_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Yapo sichangori, kāda maiyanak mahakay a myan danas wawaho a karaw do kāda kapotōtan, machita makogit. Masaw adedekey a mahahakay do adipen mo saw a naiyanak do bahay mo kan siraw adipen a ginatang mod gan-ganaet a dya kapotōtan mo, machita makogit sa. ");
INSERT INTO ivb_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","On, machita makogit tabo mahahakay a aran adipen saw a naiyanak do bahay mo mana nagatang mo tan myan sinyal do inawan nyo a pakaboyan so abos pandan a tolag ko dyinyo. ");
INSERT INTO ivb_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","No mahakay a dya makogit, ki machita nyo a pasyayen, ta mairaman paba tawo ko. Nawriw pakaboyan a dyi na tinongpal tolag ko, iyaw dyi na kapagkogit.” ");
INSERT INTO ivb_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Sinpangan na, minirwa binata no Dyos di Abraham a kāna, “Sarai pabaw panawag mod baket mo. Ta sichangori, Sara danaw ngaran na. ");
INSERT INTO ivb_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Bindisyonan konchi, as maymanganak anchi so asa mahakay a mismo a pōtot mo. On, bindisyonan konchi tan mayparin a ānang no aro a nasnasyon, kan myan panchiw kadwan a mayparin a āri do kamanganakan na saw.” ");
INSERT INTO ivb_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Do dawri, nagrokob si Abraham do tana, as nakamyeng na, ta anohdan naba. Binata na do aktokto na, “Namna! Makapōtotak pawri a asa gasot danayaw tawen ko, kan maymanganak pawri si Sara a sasyam a poho danayaw tawen na?” ");
INSERT INTO ivb_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ki binata ni Abraham do Dyos a kāna, “Si Ismael pakono bindisyonan mom Āpo a magtawid anchi so tabwaya warawara ko!” ");
INSERT INTO ivb_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ki tominbay Dyos a kāna, “Engga, ta maymanganak anchi si Sara a baket mo so asa mahakay a mismo a pōtot mo, as pangaranan monchis Isaak. Tabo a naitolag ko do nakarahan, ki parinen konchi di Isaak kan siraw kapotōtan na saw a abos pandan. ");
INSERT INTO ivb_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","As si Ismael, ki nadngey kwaw inakdaw mwaya maynamot dya. Dawa, bindisyonan ko, as torohan ko so aro a pōtot kan kapotōtan na. Ki iyanchiw āmang no asa poho kan dadwa papangolo, kan payparinen ko sanchi a rakoh a nasyon. ");
INSERT INTO ivb_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ki tongpalen ko kari ko a maynamot di Isaak a iyanak anchin Sara do somaronwaya tawen a akmas nyaya chimpo.” ");
INSERT INTO ivb_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Do nakatayokan Dyos a naychirin di Abraham, komnaro dana dya. ");
INSERT INTO ivb_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Do dawri a araw, kinogit ni Abraham si Ismael a pōtot na. Kinogit na paw tabo mahahakay do bahay na kan siraw adipen na saw a naiyanak do bahay na, as kan siraw ginatang na saw akmas inbaheyaw ni Āpo Dyos dya. ");
INSERT INTO ivb_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ki aran mismo na inawan, ki nagkogit si Abraham do kapagtawen nas sasyam a poho kan sasyam. ");
INSERT INTO ivb_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","As si Ismael, ki nagtawen so asa poho kan tatdo do nakapagkogit na. ");
INSERT INTO ivb_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Do dawri a araw, nakogit sa Abraham kan Ismael a pōtot na a ");
INSERT INTO ivb_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","nakairamanan da tabon adipen naw a mahahakay a naiyanak do bahay na mana nagatang na. ");
INSERT INTO ivb_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Sinpangan na, do asa karaw, do kayegen danaw no araw, minirwa napaboya si Āpo di Abraham. Myan a maydisna a magpariir si Abraham do pantawaw no pinatnek naw a tolda na do masngenaw do nagdindinamag saw a kayokayo a dyiran Mamre. ");
INSERT INTO ivb_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ki do dawri, binangon naw oho naw, ki naboya naw tatdo saw a mahahakay a maytēnek do masngenaw dya. Dawa, nakalyalisto a nachisngen dyira, as nakapagrokob na do tana. ");
INSERT INTO ivb_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Binata nad asaw a kāna, “Imom Āpo, an maganay dyinyo, tod kamo aba homabas dya, an dyi koynyo a rispitaren. ");
INSERT INTO ivb_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Mangay ako pa manghap so ranom a pangoyawyas nyos kokod nyo saya. Katayoka no nawri, maynahah kamo pa do sirokaya no kayowaya. ");
INSERT INTO ivb_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Magpaisagāna ako pa so pangmamabaw nyo tan myan pangyingyit nyo do kwanan nyowaya. Rakoh soyot ko a mangrispitar dyinyo.” Ki tominbay sa a kon da, “Ngay, naon ah. Pagostwan namen awis mwaya.” ");
INSERT INTO ivb_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ki nakalyalisto si Abraham a somindep do toldaw do yananaw ni Sara, as nakabata na sya a kāna, “Makalisto ka manghap so asa kakostal do kagaganayanaw a arina, as kamāsa mo sya, as kapamarin mos tinapay.” ");
INSERT INTO ivb_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Katayoka na nangibahey syaw, nayyayo a nangay do yanan daw no binyay na saw. Nakapamidi nas asa mataba a orbon baka, as nakaitoroh na sya do asaw a adipen na. Inalistwan adipen naw a pinarti, as nakarotong na sya. ");
INSERT INTO ivb_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Do nakaisagāna danaw no tabo, nanghap si Abraham so omnalsemaw a gātas kan matami a gātas kan iyaw karnyaw a inparotong na, as nakaiyangay na sya dyirad mahahakayaw do sirokaw no kayo. Iya mismo nagsirbi dyira do kakan daw. ");
INSERT INTO ivb_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Sinpangan na, inyahes da a kon da, “Dino yanan Sara a baket mo?” Ki tominbay si Abraham a kāna, “Arid irahemayan tolda.” ");
INSERT INTO ivb_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ki inbahey no asaw dyira a kāna, “Anchan marapit no naitoding a chimpo, maybidi akonchi dyimo. Do dawri, ki maymanganak anchi si Sara so mahakay.” Ki myan si Sara do bitaw no aneb do dyichodan daw a mangadngedngey so nawri. ");
INSERT INTO ivb_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Malkem kan baket dana saw maychabahayaw, kan nachipanda dana marodit si Sara. ");
INSERT INTO ivb_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Dawa, namyeng irahem ni Sara do nakadngey naw so nawri, kan binata na do aktokto na, “Pi! Changori, hahawen ko pawri a maparin dyaken komwan a kapagganas do bakbaketan ako naya kan asa pa malkem danayaw rarayay kwaya.” ");
INSERT INTO ivb_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ki inyahes ni Āpo di Abraham a kāna, “Āngo ta namyeng si Sara kan binata na a, ‘Maymanganak ako pawri do koribetbet ako naya?’ ");
INSERT INTO ivb_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Aryoriw dya maparin Āpo? No ibahey ko dyimo, ki oyod. Anchan mapahabas no naitoding a chimpo, maybidi akonchi dyimo, as kan do dawri, masigorādo a maymanganak anchi si Sara so mahakay.” ");
INSERT INTO ivb_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ki maynamot do kāmo ni Sara, naglibak, as nakabata na sya a kāna, “Wā! Enggaw, mo Āpo. Namyeng akwabaw.” Ki binata no bisīta daw, “Taywaran dyi ka oyod a namyeng?” ");
INSERT INTO ivb_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Sinpangan na, nagrobwat saw bisītaw a komaro, as nachirayay si Abraham dyira tan yangay na sa patodahen do rarahanaw a mandad logaraw a pakatalamadan das Sodoma. ");
INSERT INTO ivb_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ki do dawri, binata ni Āpo a kāna, “Itayo ko paro di Abraham plano kwaya parinen? ");
INSERT INTO ivb_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Masigorādo a payparinen konchiw kapotōtan na a asa rakoh kan mayit a nasyon, as kan maynamot dya, bindisyonan ko sanchiw tabo a nasnasyon. ");
INSERT INTO ivb_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Pinidi ko si Abraham tan iyanchiw mangnanawo dyirad anak na saw kan siraw kapotōtan na saw a manganohed dyaken kan maybibyay sa masingpet kan malinteg. Ta an komwan parinen da, tongpalen konchi a tabo inkari kwaw dya.” ");
INSERT INTO ivb_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Sinpangan na, binata ni Āpo di Abraham a kāna, “Romnapit dana dyaken pamagatos a maikontra dyirad tawotawo do Sodoma kan Gomorra a maynamot do palalo a karahet da. ");
INSERT INTO ivb_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Dawa, yaken danaw mismo a mangay a manyideb sya an oyod karahet daya sigon do tabo pamagatosaya a romnapit dyaken tan mapatakan ko an oyod mana engga.” ");
INSERT INTO ivb_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Do dawri, komnaro saw dadwaw a mahahakay a nangay do Sodoma. Ki nabidin si Abraham a maytēnek pa do salapenaw ni Āpo. ");
INSERT INTO ivb_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Naypasngen si Abraham di Āpo, as nakaiyahes na sya a kāna, “Oyodori a payrapahen mo saw malinteg kan siraw marahet a dimanen? ");
INSERT INTO ivb_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kaspangarigan, an myan dadima poho a malinteg do dawri, rarayawen mo pawriw intīrwaw a syodad da? Chāsi mo pakono tawotawo daw tan mabyay pa saw dadimaya poho. ");
INSERT INTO ivb_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Masigorādo ko a iraman mo saba dimanen malinteg saw a tawo dyirad marahetaw. Ta an dyi mo a parinen komwan, sigorādo a mairaman sa madosaw abwaw so gatos, ta malinteg kapangokom no Hwis do intīro a tana.” ");
INSERT INTO ivb_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ki tinbay ni Āpo a kāna, “Sigi, an myan dadima poho a malinteg a maboya ko do Sodoma, patohoden ko pabaw kararayaw ko so intīro a syodad a maynamot dyira.” ");
INSERT INTO ivb_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ki tinbay pa ni Abraham a kāna, “Pakawanen mo yaken, mo Āpo, do katored kwaya machisarita dyimo. Ta yaken, ki asa lang a tawo a yapod ahbek, kan abaw kalintegan kwa maychirin. ");
INSERT INTO ivb_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ki an kaspangarigan, an myan apat a poho kan dadima tawo, as sira lang malinteg, rarayawen moriw intīrwaw a syodad maynamot ta kōrang so dadima?” Ki binata ni Āpo a kāna, “Rarayawen kwabaw syodadaw an myan maboya ko daw a apat a poho kan dadima tawo a malinteg.” ");
INSERT INTO ivb_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Minirwa dana inyahes ni Abraham a kāna, “Ki an myan apat a poho lang malinteg, dimanen mori, mo Āpo?” Ki tominbay si Āpo a kāna, “Parinen kwaba an myan apat a poho a malinteg a tawo.” ");
INSERT INTO ivb_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ki binata danan Abraham a kāna, “Āpo, makasoli kaba ah, ta manahes ako pa dyimo. Angwan tatdo a poho lang malinteg?” Tinbay ni Āpo, “On, rarayawen kwaba maynamot dyira.” ");
INSERT INTO ivb_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ki nakatongtong ni Abraham a nangyahahes a kāna, “Pakawanen mo yaken, mo Āpo, do katored kwaya. Angwan dadwa poho saw maboya mo a malinteg, dimanen mori, mo Āpo?” “Na, rarayawen kwaba an myan maboya ko a dadwa poho a malinteg a tawo,” initbay ni Āpo. ");
INSERT INTO ivb_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","“On, mo Āpo,” binata ni Abraham, “makasoli kaba, ta nya danaw manawdyi a yahes ko. Nan asa poho sa lang malinteg, dimanen mori?” Ki tinbay ni Āpo a kāna, “Alit na, aran myan asa poho lang a malinteg a tawo, ki rarayawen kwaba.” ");
INSERT INTO ivb_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Katayokaw ni Āpo a nangichirin syaw di Abraham, nayam dana, as kan si Abraham, ki somnabat danad tolda naw. ");
INSERT INTO ivb_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Nasaryan dana sa do nakapakarapit daw no dadwa saw a anghil do syodadaw a Sodoma. Myan si Lot a maydisnad rowanganaw no syodad do kawara daw no dadwaw. Do kaboya naw sira, nanyeng a naytēnek a minbayat sira, kan nagrokob do tana do salapen daw. ");
INSERT INTO ivb_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Binata na dyira a kāna, “Inyom Āpo, mangay kamo pa do bahay, kan maparin nyo a lablaban kokod nyo saya, kan misan kamo na daw, ta nakasagāna ako a mapadagos dyinyo. Anchan delak, masapa kamo nanchi a mayokay, as katongtong nyo do kwanan nyo.” Ki tominbay sa dya a kon da, “Nolay mo na yamen, ta tod kami a misan do plasa.” ");
INSERT INTO ivb_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ki komnaro abas Lot, an dyi na sa nahap. Dawa, minonot sa dya a nangay do bahay na. Do nakapakarapit daranaw, binilin naw adipen na saw a bebelan daw manotong so tinapay a abos yapo kan mangisagāna sa so pangmalem da. Do nakapakahoto daranaw, komninan sa. ");
INSERT INTO ivb_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ki sakbay a makaycheh sa, dinibon dan tabo mahahakay saw a babbaro kan mangalkem a yapod intīro a Sodoma iyaw bahayaw ni Lot. ");
INSERT INTO ivb_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Nginengeyan dan tawotawo saw si Lot, as inbahey da dya a kon da, “Dino yanan dan mahahakayaw a misan do bahay mwaya sichahep? Pahboten mo sa, ta chakey dan mahahakay saya dya a oknoden sa a pangmamabaw.” ");
INSERT INTO ivb_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Ki minohtot si Lot, as nakapaneb nas pantawaw. ");
INSERT INTO ivb_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Nachikakaāsi dyira a binata na a kāna, “Kakakteh, adngeyen nyo pa yaken. Parinen nyo abaw marahetaya panggep nyo. ");
INSERT INTO ivb_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Myan saw dadwa babbalāsang ko, as ari pa sad nachoknod do aran sino a mahakay. An chakey nyo, pahtoten ko sa, kan parinen nyo chakey nyo dyira. Basta dyi nyo sa paypariparinan so marahet bisīta ko saya, ta basta aywanan ko sa, ta rinawat ko na sa do bahay kwaya.” ");
INSERT INTO ivb_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ki binata da dya a kon da, “Pi! Komaro kad ayaman namenaya! Gan-ganaet ka, as sichangori, maychapteng kāno a mayparin a hwis namen dya ah? Oy! Magannad ka, ta āngo nchan maraherahet parinen namen dyimo kan siraw bisīta mo saya!” Do dawri, pinadoydoydoy das Lot, as nakapaypasngen da do pantawaw no bahayaw tan rakraken da. ");
INSERT INTO ivb_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ki iniwangan dan dadwaw a mahahakay a bisīta na iyaw anebaw, as nakagoyod da si Lot a pinasdep, as nakapaneb das pantawaw. ");
INSERT INTO ivb_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Do nakapasdep daw sya, pinagkorarat da saw mahahakayaw a myan do gagan tan dyi da machichwasan pantawaw. ");
INSERT INTO ivb_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Sinpangan na, binata dan dadwaw a anghil di Lot a kon da, “Imom Lot, ari pa sawriw kadwan a kabagyan mo do dya syodad a akmas anak mo sa a mahahakay kan mababakes, manogang mo a mahakay, mana kadwan a kabagyan mo? An myan, ikaro mo sa dya, ");
INSERT INTO ivb_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ta īto danaw kararayaw namen so nyaya syodad. On, ta nadngey ni Āpo pamagatos a maikontra dyirad tawotawo saya dya a maynamot do oltimwaya karahet da. Dawa, tinoboy na yamen tan rarayawen namen nyaya logar.” ");
INSERT INTO ivb_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Sinpangan na, nangay si Lot dyirad mahahakay saw a manmanogangen nanchi, as nakabata na sya a kāna, “Barok, makabel kamo a komaro dya, ta īto danaw kararayaw ni Āpo so nyaya syodad!” Ki binata da a sisyabak na lang, dawa, inanohdan daba. ");
INSERT INTO ivb_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Do kakalo naranaw a domadan araw, inbilin dan anghilaw di Lot a kon da, “Makabel ka ah! Hapen mos baket mo kan siraw dadwa saya a babbalāsang mo, as mayyayo kamo na do dya syodad tan dyi kamo a mairaman do kapangdosa no Dyos.” ");
INSERT INTO ivb_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ki naybabalay pa si Lot. Ki maynamot do kāsi ni Āpo di Lot, kinamet dan anghilaw tanorwaw ni Lot, tanorwaw ni baket na kan tanoro saw no dadwaw a babbalāsang na, as nakaihbot da sira do dawri a syodad. ");
INSERT INTO ivb_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Do nakapatodah daw sira do gaganaw no syodadaw, asa dyirad anghilaw naychirin a kāna, “Mayyayo kamo na! Mididit kamo aba, kan magsardeng kamo aba do dya tanap, basbāli a magtaros kamo do katokotokonanaya tan dyi kamo a madiman!” ");
INSERT INTO ivb_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ki tominbay si Lot dyira a kāna, “Chāsi nyo pa yamen, ta ipaparin nyo aba dyamen komwan! ");
INSERT INTO ivb_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Rakoh kāsi nyo dyamen do kaisalākan nyowayas byay namen. Ki taywarayas kabawaw katokotokonanaya. Sigorado a madas na yamen didigraya, kan madiman kami sakbay a makarapit kami daw. ");
INSERT INTO ivb_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Chiban nyo paw nwanaw dēkeyaya a idi a masngen a kamāngen namen. On, dēkey abawri? Chāsi nyo yamen, ta palobosan nyo yamen a komāmang daw tan maisalakan kami?” ");
INSERT INTO ivb_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ki tominbay no anghilaw a kāna, “Sigi, may kamo daw, as kan rarayawen kwabaw nawri a idi. ");
INSERT INTO ivb_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ki makalisto kamo a mayyayo, ta maparin kwaba isiknan, an dyi kamo pa makarapit daw.” Maynamot ta binatan Lot a dēkey a idi, dawa, napangaranan so Soar. ");
INSERT INTO ivb_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Domada danaw araw do nakapakarapitaw ni Lot do Soar. ");
INSERT INTO ivb_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Do dawri, naychihat a pinachimoy ni Āpo so somgesged a asopri a yapod hanyit do syodad saw a Sodoma kan Gomorra. ");
INSERT INTO ivb_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Sinosohan naw dadwaw a syodad kan intīrwaw a tanap, as nasosohan tabo a myan so byay kan tabo a tomnobo do dawri a tana. Araba polos nabidin daw! ");
INSERT INTO ivb_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ki do dawri, naybabalay iyaw baketaw ni Lot do rarahan, as minidit kan chiniban naw somgesgedaw a syodad a kinarwan da. Do dawri, nayparin a asin, kan tominnek a akmay parey. ");
INSERT INTO ivb_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Do kamabekas naw, nasapa naybangon si Abraham, as nakalyalisto a nangay do naytēnekanaw do salapenaw ni Āpo do nakapaysyay daw. ");
INSERT INTO ivb_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Linawngan naw Sodoma kan Gomorra kan do intīro a yanan do tanapaw, ki naboya naw matokpohaw a ahob a akmay ahob no nasosohan a kabyawan. ");
INSERT INTO ivb_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ki do kararayawaw no Dyos so idiidi saya do dawri a tanap a yanan Lot, ninakenakem nas Abraham. Dawa, insalākan nas Lot, as inkaro nad dawri a syodad. ");
INSERT INTO ivb_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Mamo si Lot a omyan do Soar. Dawa, somnonget sad katokotokonanaw kan siraw dadwaw a babbalāsang na. Do dawri, minyan sa do asa aschip. ");
INSERT INTO ivb_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Sinpangan na, do asa karaw, binata no matonetonengaw a anak na mabakes do adyen naw a mabakes, “Malkem danayas āmang, ki abayaw mahakay do intīrwaya a tana a omdibon dya a pachikabahayan ta tan myan anak ta. ");
INSERT INTO ivb_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Boken tas āmang tan maparin ta kaoknod tan myan anchiw anak ta mahakay a kapotōtan na.” ");
INSERT INTO ivb_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","As dawa, do dawri a ahep, binok das āmang da, as kinaoknod no matonetonengaw a mabakes. Maynamot ta taywaraw nakabok ni āmang da, chinapatak nabaw pinarin na. ");
INSERT INTO ivb_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Do somaronwaw a araw, binatan matonetonengaw do adyen naw, “Nachoknod akwaw kahep di āmang. Boken ta pa sichahep, kan imonchiw machoknod dya. Tan komwan, pariho ta myan so anak, kan myan anchiw kapotōtan ni āmang ta.” ");
INSERT INTO ivb_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Dawa, binok das āmang da do dawri a ahep, as nachoknod dya iyaw balāsang naw a adyen matonetonengaw a mabakes. Alit na, chinapatak naba a iyaw balāsang naw kinaoknod naw. ");
INSERT INTO ivb_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Maynamot do dya naparin, nabogi saw dadwaw a anak ni Lot, ki yapod mismo a āmang da. ");
INSERT INTO ivb_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Naymanganak matonetonengaw so mahakay, as pinangaranan nas Moab. Iyaw nakayapwan Moabita saw a tawotawo a aran mandas changori. ");
INSERT INTO ivb_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Naymanganak paw adyen naw so mahakay, as pinangaranan nas Benammi. Iyaw nakayakayapwan Ammonita saw a tawotawo a aran mandas changori. ");
INSERT INTO ivb_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Sinpangan na, komnaro sa Abraham do yanan Mamre, kan lomnongo sad tana Negeb do abagātanen Kanaan. Minyan sa so dēkey a chimpo do naypayawan Kades kan Sor. Somarono, nangay sa do idi a Gerar. ");
INSERT INTO ivb_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Do kayan daw do Gerar, no inbahebahey ni Abraham a maynamot di Sara a baket na, ki maykakteh sa. Dawa, inpatawag ni Āri Abimelek a āri do Gerar si Sara. ");
INSERT INTO ivb_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ki do dawri a mahep, napaboyaw no Dyos di Abimelek do asa tayēnep a kāna, “Masigorādo a madiman ka maynamot ta inhap mo nya mabakes a myan danas kabahay.” ");
INSERT INTO ivb_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ki do dawri, ari na pad kinaoknod ni Abimelek si Sara. Dawa, binata na di Āpo a kāna, “Imom Āpo, chapatak mwa abo marahet a pinarin ko dya. Dimanen mori yaken kan siraw tawotawo kwaya a aran abo gatos ko dya? ");
INSERT INTO ivb_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Nayengayaw inbahey da, da Abraham kan Sara dyaken a maykakteh sa ta dawa. Aba polos marahet a iniktokto ko, kan madalos kaparin ko do kahap kwaw sya.” ");
INSERT INTO ivb_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ki tinbay no Dyos do tayēnep a kāna, “On, chapatak kwa abaw marahet a iniktokto mo a parinen mo. Dawa, inpalōbos kwaba a sinalid mo nya mabakes tan dyi ka maygatos dyaken. ");
INSERT INTO ivb_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Sichangori, pabidyen mo naw nya mabakes do kabahay naw. Ta iyaw nawri a mahakay, ki asa propīta ko, as paydasal nanchimo tan dyi ka madiman. Ki an dyi mwa pabidyen, syirto a madiman ka kan siraw tawotawo mwaya.” ");
INSERT INTO ivb_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Do kamabekasanaw, pinatawag san Abimelek tabo opisyalis na saw, as nakaibahey nas tabo napariparinaw do tayēnep na. Ki do nakadngey daw sya, taywaraw nakamo da. ");
INSERT INTO ivb_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Katayoka na, pinatawag ni Āri Abimelek si Abraham, kan binata na dya a kāna, “Inanghen mo yamen? Āngo gatos ko dyimo tan nangyangay kas pangbakebakel mo dyaken kan do pagāryan kwaya? Pinarin mwaya dyaken, ki rombeng a dya parinen do kapayngay a tawo.” ");
INSERT INTO ivb_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Inyahes na pa, “Samna! Āngo ta pinarin mo nyaya?” ");
INSERT INTO ivb_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ki tominbay si Abraham a kāna, “On, ata, no myan do aktokto ko, ki abaw mamo do Dyos do logar nyowaya. Dawa, namo ako, kan binata ko do inawan kwa, ‘Āngonchan dimanen da yaken, as kahap das baket kwaya?’ ");
INSERT INTO ivb_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","No ibahey kwaya dyimo, mo āpo Āri, ki oyod. Oyod a maykakteh kami do āmang, ki engga do ānang. Ki aran komwan, naychabahay kami. ");
INSERT INTO ivb_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Do nakatoboyaw no Dyos dyaken a karwan ko yanan āmang ko a mangay do matarek a tana, inbahey kod baket kwa, ‘An oyod a chāsi mo yaken, do tabo a ngayan ta, ki ibahey mwa maykakteh ta.’” ");
INSERT INTO ivb_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Sinpangan na, pinaybidi ni Abimelek si Sara di Abraham, as kan tinorohan na pas karniro, baka, kan kadwan dyirad adipen na saw a mahakay kan mabakes. ");
INSERT INTO ivb_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Do dawri, binata ni Abimelek di Abraham a kāna, “Chiban mo tabo tana kwaya. Mamidi kas chakey mwa yanan tan omyan kamo daw.” ");
INSERT INTO ivb_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Binata na pa di Sara a kāna, “Tinorohan ko kakteh mwaw so asa ribo a kapidaso a kwarta. Nyaw pakaboyan dan tabo rarayay nyo saw a abaw naparin dyimo a maddi, as kan paysonongan danan aran āngo a kasnek a rinawat mo.” ");
INSERT INTO ivb_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Maynamot do naparinaya di Sara a baket ni Abraham, inpalōbos aba ni Āpo a myan matorohan so anak do pagāryan ni Abimelek. Sinpangan na, naydasal si Abraham di Āpo, as pinapya ni Āpo si Abimelek kan napalobosan dana mirwa a maymanganak si baket na kontodo mababakes saw a adipen na. ");
INSERT INTO ivb_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Ki do dawri, do nakahabasaw no inkeddeng na chimpo, binindisyonan ni Āpo si Sara, kan tinongpal na akmas inkari naw. ");
INSERT INTO ivb_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","As dawa, nabogi si Sara, kan naymanganak so asa mahakay a aran baket dana kan malkem dana si Abraham. On, naiyanak sigon do chimpwaw a inbahey no Dyos. ");
INSERT INTO ivb_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Pinangaranan ni Abraham so Isaak adekeyaw a pōtot na di Sara, ");
INSERT INTO ivb_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","as kinogit ni Abraham si Isaak a pōtot na do chawawaho naw a araw a akmas bilinaw no Dyos. ");
INSERT INTO ivb_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Do nakaiyanakaw ni Isaak, nagtawen dana si Abraham so asa gasot. ");
INSERT INTO ivb_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Binata ni Sara a kāna, “Tinorohan yaken no Dyos so pakayapwan kwa masoyot kan mamyeng, kan aran sinonchi a tawo a makadngey, mamyeng sanchi a maynamot do soyot da dyaken.” ");
INSERT INTO ivb_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Binata na pa, “Ay samna! Sigorado a abaw manghahaw kan mangibahey di Abraham a mapasoso akos adekey do nakapaymanganak kwaya bakbaketan dana. Ara, ta cha dya inyanak ko nya pōtot na mahakay a aran malkem dana.” ");
INSERT INTO ivb_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Nayparakoh adekeyaw, as naposin. Do dawri a araw a nakaposin na, namarin si Abraham so rakoh a pasken. ");
INSERT INTO ivb_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Do asa karaw, naboya ni Sara si Ismael a anak ni Agar a taga Egipto, ki myan na roroden a pachigtalan si Isaak a anak ni Sara. ");
INSERT INTO ivb_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Dawa, binata ni Sara di Abraham a kāna, “Payayohen mo may-ānang saya a adipen, ta maparin aba machipagtawid anak naya do anak taya a si Isaak.” ");
INSERT INTO ivb_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Taywaraw nakariribok ni Abraham do inbaheyayan Sara maynamot ta pōtot na pas Ismael. ");
INSERT INTO ivb_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ki inbahey no Dyos di Abraham a kāna, “Chabakel mwabaw may-ānang saya a Ismael kan Agar. Parinen mo aran āngo a ibahey ni Sara, ta si Isaak pakayapwan kapotōtan mo saw a inkari ko. ");
INSERT INTO ivb_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","As maynamot ta pōtot mo pas Ismael a anak ni Agar a adipen, parohen konchiw kapotōtan na, as mayparin sanchi a asa nasyon.” ");
INSERT INTO ivb_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Do kamabekasanaw, minhep a naybangon si Abraham, ta pinarobwatan na sa Agar kan Ismael. Tinorohan na si Agar so kanen da kan asa sopot a lalat a napno so ranom, as nakaipakachin na sya di Agar. Sinpangan na, pinayam narana sa. Komnaro sa Agar, as nangay sa minidibidi do let-angaw do Beerseba. ");
INSERT INTO ivb_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Do nakatawosaw no bahon daw a ranom, tinokos naw anak naw do sirokaw no mabodis a kayo, ");
INSERT INTO ivb_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","as naypabawa so asa gasot ngata kamitros, as nakapaydisna na. Binata nad aktokto na, “Maitored kwaba chiban anak kwaya a madiman.” Ki do kayan naw a maydisna, tomnanyis si Agar. Aran si Ismael, ki tomnanyis. ");
INSERT INTO ivb_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ki nadngey no Dyos katanyis no anak naw. Dawa, yapod hanyit naychirin iyaw Anghil no Dyos di Agar, “Āngo chabakel mom Agar? Mamo kaba, ta nadngey no Dyos katanyisayan anak mwaya. ");
INSERT INTO ivb_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Maytēnek ka, ta mangay mwa kadayen kan ahwahoken anak mwaya. Payparinen konchi a rakoh a nasyon kapotōtan na.” ");
INSERT INTO ivb_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Do dawri, inpaboya dya no Dyos asaw a akbod. Dawa, yangay ni Agar a inporanom lalataw, as nakapaynom nas anak naw. ");
INSERT INTO ivb_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Binindisyonan no Dyos anak naw do kayan naw a mayparakoh. Minyan do let-ang a Paran, kan nayparin a maganay a mangosar so bai a panganop. ");
INSERT INTO ivb_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Do kayan naw do Paran, inpakabahay dya ni ānang na iyaw asaw a taga Egipto. ");
INSERT INTO ivb_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Do dawri a chimpo, nangay di Abraham sa Āri Abimelek kan Pikol a iyaw pangolo dan soldado naw. Nakabata na sya a kāna, “Myan Dyos dyimo do tabo parinen mo. ");
INSERT INTO ivb_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Dawa, akdawen ko dyimo a ikari mo do salapen Dyos a dyi mo yaken a loklokwen kan siraw anak ko mana siraw kapotōtan ko. Parinen mo pakono dyaken kan siraw tawotawo ko saya a omyan do tana kwaya a nachiyanan nyo a akmas nakāsi ko dyinyo. ");
INSERT INTO ivb_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","“On, ikari ko,” tinbay ni Abraham. ");
INSERT INTO ivb_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Sinpangan na, nagriklamo si Abraham di Abimelek maynamot do bobon naw a ināgaw dan adipenaw ni Abimelek. ");
INSERT INTO ivb_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ki tinbay ni Abimelek a kāna, “Chapatak kwaba an sino namarin syay. Āngo ta dyi mwa inbahebahey dyaken? Changori paya natonngan ko nya.” ");
INSERT INTO ivb_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Do dawri, tinorohan ni Abraham si Abimelek so kadwan a karniro kan baka na saw, as nakapagkari da. ");
INSERT INTO ivb_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Sinpangan na, napatawa si Abraham so papito a mabinayi a orbon do karniro na saw. ");
INSERT INTO ivb_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ki inyahes ni Abimelek a kāna, “Anghen mo saw pinatawa mwaya a papito a orbon karniro a mabinayi?” ");
INSERT INTO ivb_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ki binata ni Abraham a kāna, “Rawaten mo saw papito saya orbon karniro a mabinayi, as do karawat mwaya sya, paneknekan mwa yaken naychadi so nyaya bobon.” ");
INSERT INTO ivb_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Dawa, napangaranan nawri a tana so Beerseba, ta dawriw naysinkaryan da Abraham kan Abimelek. ");
INSERT INTO ivb_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Katayokan nakapagkari daw do Beerseba, naybidi danas Abimelek kan si Pikol a pangolo dan soldado naw do yanan da do Pilistia. ");
INSERT INTO ivb_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Naymoha si Abraham so tamaris a kayo a pakanaknakman do Beerseba, as nagdaydayaw di Āpo a Abos Pandan a Dyos. ");
INSERT INTO ivb_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Nahay a minyan si Abraham do Pilistia a tana. ");
INSERT INTO ivb_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Napahabas nawri, sinoot no Dyos si Abraham. Tinawagan na a kāna, “Abraham!” Ki tominbay si Abraham, “Ari ako dya, mo Āpo.” ");
INSERT INTO ivb_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Binata no Dyos a kāna, “Apen mo iyaw moybohaya pōtot mwa si Isaak a chadaw mo, as kangay mo do tana a Moria. Idāton mo dyaken si Isaak do asaya tokon a ipaboya konchi dyimo.” ");
INSERT INTO ivb_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Nanganohed si Abraham, dawa, minhep a naybangon do kamabekasanaw. Nangasdasda so kayo a pangorno nas dāton naw, as inkarga na do asno naw a pinasangaan na. Inhap nas Isaak kan siraw dadwaw a adipen na, as nakaisiknan da so kominwan do inbaheyaw ni Āpo dya. ");
INSERT INTO ivb_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Do chatatdo naw a araw, naboya dana ni Abraham kasngen nawri a yanan. ");
INSERT INTO ivb_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Binata na dyirad adipen na saw a kāna, “Myan kamo na dya kontodo asnwaya, ta may kami kan anak kwaya dwa daw a magdaydayaw do Dyos, as maybidi kaminchi dyinyo.” ");
INSERT INTO ivb_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Do dawri, inhap ni Abraham sindasda naw a kayo a pangorno nas dāton naw, as inpaisabhay nad Isaak a pōtot na. Somarono, inhap naw bahayang naw, as nanghap so inmaya a pamyay na, as nakayam da. ");
INSERT INTO ivb_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Do kayan daw a mayam, naychirin si Isaak di āmang na a kāna, “Mo Āmang.” “Āngo yahes mom barok?” binata ni Abraham. “Āngom Āmang, ta myan inmaya kan kayo, ki abayaw idāton ta a orbon karniro?” inyahes ni Isaak. ");
INSERT INTO ivb_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Initbay ni Abraham a kāna, “Iyaw Dyos makatoneng anchi a manoroh dyaten so orbon karniro a idāton ta.” Katayoka na nangibahey syay, tinongtong daw nayam. ");
INSERT INTO ivb_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Do nakapakarapit daw do yananaw no inbaheyaw no Dyos dya, namarin si Abraham so pangidātonan, as nakapaychichipeh nas sindasda naw a kayo do hapotaw no pangidātonan na. Sinpangan na, binahod nas Isaak, as nakapakabat na sya do kayowaw. ");
INSERT INTO ivb_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Do dawri, inhap naw bahayangaw tan dimanen naranaw pōtot naw. ");
INSERT INTO ivb_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ki nanyeng a naychirin iyaw Anghil ni Āpo a yapod hanyit a kāna, “Abraham, Abraham!” Ki tinbay ni Abraham a kāna, “Ari ako dya, mo Āpo.” ");
INSERT INTO ivb_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","“Dimanen mwabaw pōtot mwaya. Paynyinan mwaba. Masigorādo a chapatak ko na a oyod a manganohed ka kan magdayaw ka do Dyos maynamot ta aran iyaw moybohaya a pōtot mo, ki chinaskeh mwaba itoroh dyaken.” ");
INSERT INTO ivb_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Sinpangan na, nanyideb si Abraham, ki naboya na myan mahakay a karniro a nachisadyit so olong do kayowaw a mabodis. Yangay na inhap, as pinarti na a indāton do Dyos a tadin pōtot naw. ");
INSERT INTO ivb_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Pinangaranan Abraham nawri a yanan so “Si Āpo Manoroh.” Aran sichangori, ki batabatahen da pan tawotawo a, “Do tokon ni Āpo, ki maitoroh anchi.” ");
INSERT INTO ivb_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Do dawri, minirwa a naychirin iyaw yapwaw do hanyit a Anghil ni Āpo di Abraham a kāna, ");
INSERT INTO ivb_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Abraham, yaken si Āpo a maychirin dyimo, kan yaken magkari dyimo do mismo a ngaran ko a maynamot do pinarin mwaya, as kan abaw wedwed mo a mangitoroh so pōtot mwaya moyboh, ");
INSERT INTO ivb_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","taywara bindisyonan koymo. On, payparohen ko saw kapotōtan mo a akmas kāron bitohen do tohos mana akmas kāron anay do payis no kanayan. Abāken danchi no kapotōtan mo nasnasyon saya a kabōsor da. ");
INSERT INTO ivb_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","As maynamot do kapotōtan mo, mabindisyonan sanchiw tabo tawotawo do tanaya maynamot do kapagtongpal mwaya so bilin ko.” ");
INSERT INTO ivb_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Sinpangan na, naybidi sa Abraham kan Isaak do yanan daw no adipen na saw. Nakapaybidi darana do Beerseba, kan dawriw niyanan Abraham. ");
INSERT INTO ivb_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Napahabas nyaya, nadamag ni Abraham a myan saw anak ni Milka a baket ni kakteh na Nahor. ");
INSERT INTO ivb_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Siraw mahahakay a anak na, ki si Os, iyaw matoneng, si Bos a adyen na, kan si Kemwel a āmang ni Aram. ");
INSERT INTO ivb_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Myan pa saw anak ni Milka a mahahakay a sa Kesed, Haso, Pildas, Jidlap, kan Betoel. ");
INSERT INTO ivb_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Si Betoel, ki āmang ni Rebekka. Siraw nyaw wawaho a anak ni Milka di Nahor a kakteh ni Abraham. ");
INSERT INTO ivb_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Si Reoma a minabakes ni Nahor, ki myan pa saw anak na mahahakay a sa Teba, Gaham, Taas, kan Maaka. ");
INSERT INTO ivb_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Nabyay si Sara so asa gasot, dadwa poho kan papito a katawen. ");
INSERT INTO ivb_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sinpangan na, nadiman si Sara do Hebron do tana a Kanaan. Nangay si Abraham do yanan bangkay naw, kan dinongdong-awan na a maynamot do kadiman na. ");
INSERT INTO ivb_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Sinpangan na, kinarwan Abraham bangkayaw ni Sara, as nakangay na nachisarita dyirad Heteo saw a tawo. Binata na dyira a kāna, ");
INSERT INTO ivb_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Gan-ganaet ako pa dyinyo do dya tana, ki machiyan ako na dya do tana nyo sichangori. Ki chāsi nyo yaken, ta lakwan nyo pa yaken so tana a pangitanman ko si baket ko.” ");
INSERT INTO ivb_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Tominbay saw Heteo saw di Abraham a kon da, ");
INSERT INTO ivb_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“On, mo Sir, ta ibidang namen imo a asa tawo a binindisyonan ni Āpo Dyos. Dawa, itabon mo do kagaganayanaw a pidyen mo iyaw bangkayaw ni baket mo. Aran sino dya, ki masoyot kami a manoroh so chakey mo.” ");
INSERT INTO ivb_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Nagrokob a nagyaman si Abraham do salapen dan Heteo saw a omidi daw, ");
INSERT INTO ivb_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","as nakabata na sya dyira a kāna, “An oyod a chakey nyo a itabon ko dyaw baket kwaya, yangay nyo pa a iyahes di Epron a Heteo a pōtot ni Sohar. ");
INSERT INTO ivb_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Aryaw aschip na myan do Makpela, iyaw pandanaw no bengkag na. Akdawen nyo pa dya a ilāko na dyaken do gagāngayaw a prisyo no tana, ta bayādan ko, as bayādan ko dya do salapen nyo tan mabokodan ko a pangitanman.” ");
INSERT INTO ivb_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ki myan do dawri si Epron a mismo a maydisna do naychichipehan daw no kapayngay naw a Heteo do rowanganaw no syodad. Initbay na di Abraham do salapen dan tabo tawotawo. ");
INSERT INTO ivb_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Binata na, “Mo Sir, itoroh ko dyimo iyaw aschipaw a inakdaw mo, kan dyira mo pa tabo tana naw daw. Itoroh ko dyimo nya do salapen dan kaidyan kwaya tan itabon mo daw baket mwaw.” ");
INSERT INTO ivb_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Do dawri, minirwa si Abraham a nagrokob do salapen daw no tawotawo saw a omidi daw, ");
INSERT INTO ivb_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","as naychirin di Epron do salapen daw a tabo daw tan aran sira, ki madngey daw nawri a inbahey na. Binata na a kāna, “Adngeyen nyo pa yaken. Bayādan ko tana mwaw, kan rawaten mo pakono nyaya bāyad tan maparin ko a itabon daw kabahay kwaw.” ");
INSERT INTO ivb_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Tominbay si Epron di Abraham a kāna, ");
INSERT INTO ivb_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Aran imom Sir, adngeyen mo pa yaken. Iyaw nawri a tana, ki magbalor so apat a gasot a pirak. Dēkey lang dyaten nawri, dawa, itabon mo na daw baket mwaw.” ");
INSERT INTO ivb_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Do dawri, nakey si Abraham. Dawa, kinilo naw apataw a gasot a pirak a iyaw inakdawaw ni Epron do salapen dan Heteo saw a sigon do gagāngay a rokod da a os-osaren dan magnignigosywaw do dawri a chimpo. ");
INSERT INTO ivb_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Komwan nakahap ni Abraham so bengkagaw ni Epron do Makpela do dayāen logar a Mamre kontodo iyaw aschipaw kan tabo saw kayokayo saw a myan do irahem na. ");
INSERT INTO ivb_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Tabo Heteo saw a nangay do dawri a nakapaychichipeh da do rowanganaw no syodad, ki napatakan darana a dyiran Abraham nawri a tana. ");
INSERT INTO ivb_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Katayoka no nawri, intabon Abraham si Sara a baket na do dawri a aschip do bengkag do Makpela a masngen do tana a Mamre a pinangaranan das Hebron do tana a Kanaan. ");
INSERT INTO ivb_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Komwan nakadyira ni Abraham so bengkagaw a myan so aschip a ginatang na dyirad Heteo saw a nayparin a pagtatanman. ");
INSERT INTO ivb_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Binindisyonan ni Āpo si Abraham do tābo kayayan na a mandad kaoltimo danan kalakay na. ");
INSERT INTO ivb_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Do asa karaw do dawri, binata ni Abraham do katotorayanaw a adipen na a iyaw magaywanaw so tabo a kinabaknang na a kāna, “Igpet mo payawanayan padang ko, as magkari ka. ");
INSERT INTO ivb_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","On, pagkaryen koymo do salapen Āpo a Dyos do hanyit kan tanaya a mamidi kabas kabahayen pōtot kwaya dyirad mababakes sayad Kanaanaya a yanan ko sichangori, ");
INSERT INTO ivb_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","basbāli a mangay ka do tanaw a nakayanakan ko do kakabagyan ko saw, ta dawrinchiw panghapan mos baket ni Isaak a anak ko.” ");
INSERT INTO ivb_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Tominbay adipen naw dya a kāna, “Ki an maskeh mabakesaw a monot dyaken do dyaya tana, hapen koris Isaak do tanaw a nakayanakan mo ah?” ");
INSERT INTO ivb_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Tominbay si Abraham a kāna, “Namna! Komwan aba. Hapen mwabaw anak kwaya dwadaw! ");
INSERT INTO ivb_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Si Āpo a Dyos do hanyit, ki inhap na yaken do yanan āmang ko kan tana a nakayanakan ko, as kan inkari na dyaken a kāna, ‘Itoroh ko nyaya tana dyirad kapotōtan mo.’ Toboyen nanchiw anghil na a manmanma kan imo a mangisagāna so hapen mwaw a kabahay ni Isaak. ");
INSERT INTO ivb_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Amnan maskeh a monot mabakesaw dyimo, maponas dananchiw kari mwaya dyaken. Basta dyi mo a yanay anak kwaya daw.” ");
INSERT INTO ivb_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Katayoka na naychirin, inigpet no adipenaw payawanaw no padang ni Abraham a āmo na, as nakapagkari na a tongpalen naw bilinaw ni Abraham. ");
INSERT INTO ivb_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Sinpangan na, nagrobwat adipenaw ni Abraham. Nakahap nas asa pohwaw a kamilyo no āmo na, kan kinargaan nas aro a kita a mabalor a rigalo a inpahap no āmo naw. Katayoka na, nangay danad idyaw a yanan ni Nahor do Mesopotamya a tana. ");
INSERT INTO ivb_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Do nakapakarapit naw, pinaydogod na saw kamilyo naw do gaganaw no nawri a idi do masngenaw do akbodaw. Do dawri, makoyab dana, ki nawriw oras dan mababakes a mangay a mamoranom. ");
INSERT INTO ivb_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Sinpangan na, naydasal adipenaw a kāna, “Mo Āpo a Dyos a daydayāwen ni Abraham a āmo ko, sidongan mo pa yaken sichangori tan tongpalen ko kari ko di Abraham a āmo ko. ");
INSERT INTO ivb_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ari ako na dya a maytēnek do masngen do akbodaya a pamoranoman dan babbalāsang saya do dya idi. ");
INSERT INTO ivb_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Anchan mawara sa, an myan asa paychirinan ko so, ‘Chāsi mo yaken, ta padisnahen mo paw malabi mwaya, ta machinomak pa,’ as atbayen na yaken so, ‘Minom ka, ta paynomen ko saw kamilyo mwaya,’ iya dana pakonom Āpo pinidi mwaw a kabahay ni Isaak a adipen mo. An komwan maparin, matonngan konchiw kadaw mo kan kāsi mo di Abraham a āmo ko.” ");
INSERT INTO ivb_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ki do dawri, sakbay a tayoka naydasal, naboya na si Rebekka a maysabhay so malabi. Iya, ki pōtot ni Betoel. As si Betoel, ki anak ni Milka a baket ni Nahor a kakteh ni Abraham. ");
INSERT INTO ivb_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Si Rebekka, ki asa mapintas a balāsang, kan ari pa abo nakasalid sya. Minosok do akbodaw a namoranom. Ki do nakapno naw so malabi naw, somonget dana. ");
INSERT INTO ivb_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Do dawri, nanyeng a naypasngen dyaw adipenaw ni Abraham, as nakabata na sya dya a kāna, “Ādi, maparin abawriw machinom so dēkey do malabi mwaya?” ");
INSERT INTO ivb_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ki initbay na, “Minom ka, mo Āpo.” Sigida na pinagchin malabi naw, as nakapaynom na sya. ");
INSERT INTO ivb_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Do nakatayoka naw a mininom, binata no mabakesaw a kāna, “Aran siraw kamilyo mwaya, ki paynomen ko sa mandan makaywaw sa.” ");
INSERT INTO ivb_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Dawa, inalistwan na pinado ranomaw do malabi naw do inoynomanaw no binyay, as nakapayayo na nangay a minirwa a nanghap so ranom. Komwan pinarin na a mandad nakapakaywaw da tabo no kamilyowaw. ");
INSERT INTO ivb_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ki do dawri, naylilyak abaw adipenaw ni Abraham a nangboyboya di Rebekka, ta sintiren na an nawri danaw atbayaw ni Āpo do dasal naw. ");
INSERT INTO ivb_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Do katayoka naw a napaynom siras kamilyo saw, napahtot adipenaw ni Abraham so asa mangina a arītos a balitok a para momodan kan dadwa rarakoh a porsilas a balitok a pinangay na do tanoro naw. ");
INSERT INTO ivb_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Inyahes no adipenaw di Rebekka a kāna, “Ādi, sino āmang mo? Maparin abawri an misan kami kan siraw rarayay ko saya do bahay nyo sichahep?” ");
INSERT INTO ivb_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Initbay na, “No inyapwan ko, ki si Betoel a anak da Milka kan Nahor.” ");
INSERT INTO ivb_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Binata na pa a kāna, “Aro garami kan mākan dan kamilyo do bahay, as kan myan paw yanan nyo a pangpahabasan nyos ahep kan siraw binyay nyo saya.” ");
INSERT INTO ivb_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Do nakadngeyaw sya no adipenaw, nagrokob as nakapagdaydayaw na di Āpo. ");
INSERT INTO ivb_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Binata na a kāna, “Madaydayaw si Āpo a Dyos a daydayāwen ni Abraham a āmo ko, ta inpaboya naw kāsi kan kaoyod na di āmo ko, as kan iyaw nangipaboya so bahay a yanan dan kakakteh saw no āmo kwaw.” ");
INSERT INTO ivb_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Sinpangan na, nayyayo si Rebekka a naybidi do bahay da ānang na, as nakaistorya na tabo so naparinaw. ");
INSERT INTO ivb_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Myan kakteh ni Rebekka a mahakay a mayngaran so Laban. Do nakadngey naw sya, nanyeng a nayyayo a nangay do akbodaw a yanan adipenaw ni Abraham. ");
INSERT INTO ivb_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","On, ta do nakaboya naw so arītosaw no momodan kan porsilas saw do tatchayaw no kakteh naw, kan nadngey na paw inpadāmagaw ni Rebekka a iyaw inbaheyaw no adipenaw, nanyeng a nangay do yananaw no adipenaw. Do nakapakarapit naw do akbodaw, myan a maytēnek iyaw adipenaw ni Abraham do yanan daw no kamilyo na saw. ");
INSERT INTO ivb_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Binata na do adipenaw a kāna, “Mangay ka do bahay, mo Āpo, imo a binindisyonan Āpo! Āngo ta nāw nyo dya? Aryaw pagyanan nyo a naisagāna do bahay, kan myan paw yanan dan kamilyo mo saya.” ");
INSERT INTO ivb_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Dawa, nangay sa do bahay da. Do kawara daw, diniskargaan Laban siraw kamilyo saw, as nakapakan na siras garami, as kan tinorohan nas ranom adipenaw ni Abraham kan siraw rarayay naw tan lablaban daw kokod da. ");
INSERT INTO ivb_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ki do nakaidasar danaw no kanen da, binata no adipenaw ni Abraham a kāna, “Anchi kamo, ta koman akwaba, an dyi ko a ibahey dyinyo ranta ko a mangay dya.” Ki tinbay ni Laban, “Naon, ibahey mo pa dyamen.” ");
INSERT INTO ivb_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Dawa, binata na a kāna, “Yaken, ki adipen ni Abraham. ");
INSERT INTO ivb_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Rakoh bindisyon ni Āpo do āmo kwaw, kan pinayparin na asa mabaknang a tawo. Tinorohan nas aro a karniro kan kalding, baka, pirak kan balitok, aro a adipen a mahahakay kan mababakes, as kan aro a kamilyo kan asno. ");
INSERT INTO ivb_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ki si Sara a kabahay no āmo kwaw, ki nakapaymanganak so asa mahakay a aran baket dana, as kan inpatāwid na tabon āmo kwaw a si Abraham warawara na do dya pōtot na. ");
INSERT INTO ivb_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Masaw a pinagkari na yaken a tongpalen ko bilin na. Binata na dyaken a kāna, ‘Mamidi kabas kabahayen pōtot kwaya dyirad mababakes saya do Kanaan a yanan kwaya sichangori, ");
INSERT INTO ivb_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","basbāli a mangay ka dyirad kakabagyan sayan āmang ko, ta dawrinchiw panghapan mos baket no pōtot kwaya.’ ");
INSERT INTO ivb_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ki inyahes ko dya an āngo parinen ko an maskeh a monot dyaken machichwasan kwaw a balāsang. ");
INSERT INTO ivb_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ki binata na dyaken a kāna, ‘Si Āpo a nāw kwa anohdan, ki toboyen nanchiw anghil na a machirayay dyimo tan mahap monchiw panggep mo. Manghap kanchis kabahayen anak kwaya dyirad kakabagyan ko saw do pamilya ni āmang ko.’ ");
INSERT INTO ivb_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Binata na pa dyaken a, ‘An parinen mo nyaya a kangay mo do kakabagyan ko, as chaskeh da itoroh dyimo balāsangaw, ki maponas dananchiw kari mwaya dyaken.’ ");
INSERT INTO ivb_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Dawa, do kayan kwaw kaychi do yananaw no akbod, naydasal akos akma syay, ‘Mo Āpo a Dyos ni Abraham a āmo ko, sidongan mo pa yaken tan matongpal ko panggep kwaya. ");
INSERT INTO ivb_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ari ako na dya a maytēnek do masngen do akbodaya. An myan pakono balāsang a mangay a mamoranom, as an paychirinan ko so, “Chāsi mo yaken, ta machinomak pa do pinoranom mwaw,” ");
INSERT INTO ivb_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","as atbayen na yaken so, “Minom ka, ta paynomen ko saw kamilyo mwaya,” iya dana pakonom Āpo pinidi mwaw a kabahay no anakaw no āmo kwaw.’ ");
INSERT INTO ivb_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ki dyik paw a tayokaw dasal kwaw kaychi, ki nawara si Rebekka a naysabhay so malabi a mangay a mamoranom. Ki do dawri, binata ko a kon ko, ‘Ādi, chāsim pa yaken, ta machinomak pa.’ ");
INSERT INTO ivb_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ki nanyeng a pinabodis naw malabi naw, as nakabata na sya dyaken a kāna, ‘Minom ka, kan aran siraw kamilyo mwaya, ki paynomen ko sa.’ Dawa, mininom ako, as pinaynom na paw kamilyo ko saw. ");
INSERT INTO ivb_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Sinpangan na, inyahes ko dya, ‘Sino āmang mo?’ Ki inbahey naw a, ‘Si Betoel inyapwan ko a anak ni Nahor kan Milka.’ Do dawri, pinangay ko arītosaw do momodan na, as kan porsilas saw do tatchay na. ");
INSERT INTO ivb_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Nagrokob ako, as nagdaydayaw ako di Āpo, iyaw Dyos ni Abraham a āmo ko, ta iyaw nangipaboya dyaken so kosto a rarahan a mangay do kakabagyan āmo ko. Sichangori, nachichwasan ko balāsangaw a kabahayen pōtot no āmo kwaw. ");
INSERT INTO ivb_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","On, sichangori, nadngey nyo na an āngo panggep ko. Dawa, ibahey nyo an machitonos kamo na do chakeyaw no āmo kwaw. Ta an maskeh kamo, ibahey nyo pa tan chapatak ko pariparinen ko.” ");
INSERT INTO ivb_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ki tominbay sa Laban kan Betoel a kon da, “Maynamot ta aktokto ni Āpo nya, abaw toray namen do dyaya. ");
INSERT INTO ivb_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Cha dya si Rebekka. Hapen mo as mayam kamo na. Iyaw ipakabahay mo do anakaw no āmo mwaw a akmas inbilin ni Āpo.” ");
INSERT INTO ivb_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Do nakadngeyaw no adipenaw ni Abraham so binata daw, nagrokob do tana, as nakaidaydayaw nas Āpo. ");
INSERT INTO ivb_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Katayoka na, napahtot siras pirak kan balitok a alahas, kan ayowayob, as nakaitoroh na syad Rebekka. Tinorohan na paw kakteh naw kan si ānang na so mangingina a sāgot. ");
INSERT INTO ivb_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Sinpangan na, komninan kan mininom sa kan siraw rarayay na saw, as nakaysan das asa kahep daw. Do kamabekas danaw, napakatoneng adipenaw ni Abraham, ta mayam dana sa. Binata na a kāna, “Maybidi kami na do āmo kwaw.” ");
INSERT INTO ivb_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ki binata da Laban a kakteh ni Rebekka kan ānang na a kon da, “Namna! Matokos pas Rebekka ah! Myan pa dya so asa kalawas mana asa poho a karaw, as kangay nanchi.” ");
INSERT INTO ivb_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ki binata no adipenaw dyira a kāna, “Balabalayen nyo aba yaken, ta sinidongan yaken Āpo do panggep kwaya. Dawa, mangtokto kamo pabas pamenpen nyo so kapaybidi ko do yanan ni āmo ko.” ");
INSERT INTO ivb_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","“Naon,” kon da, “ki tawagan tas Rebekka, ta yahes tan āngo bata na.” ");
INSERT INTO ivb_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Dawa, tinawagan das Rebekka, as nakaiyahes da sya dya a kon da, “Chakey moriw machirayay do dya mahakay?” “On, makey ako,” tinbay ni Rebekka. ");
INSERT INTO ivb_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","As dawa, do dawri, pinalobosan das Rebekka a nachirayay do adipenaw ni Abraham kan siraw rarayay na saw, kan pinarayay daw asaw a mabakes a nangtagtagibi sya. ");
INSERT INTO ivb_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ki sakbay a komnaro sa, binindisyonan das Rebekka, as binata da dya a kon da, “Imom Rebekka a kakteh namen, mayparin ka pakono a ānang dan riboribo a tawotawo, as abāken da pakononchi no kamanganakan mo nasnasyon saya a kabōsor da.” ");
INSERT INTO ivb_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Do katayoka naw a nagrobwat, somnakay dana si Rebekka kan siraw kasidong naw a mababakes do kamilyo saw a minonot do adipenaw. Komwan nakayam da. ");
INSERT INTO ivb_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Do dawri, minyan si Isaak do Negeb do abagātanen no Kanaan, ki kawara na pa a yapo do payranswan naw a nangayan na a naginbirnaan do bobon a mayngaran so “Bobon No Sibibyay A Dyos A Makaboya Dyaken.” ");
INSERT INTO ivb_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Asa makoyab, minohbot si Isaak a mangay do bengkag a midibidi. Ki do dawri, naboya na saw kamilyowaw a maypaypasngen dya. ");
INSERT INTO ivb_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Do nakaboyaw ni Rebekka si Isaak, nanyeng a gominchin do kamilyo naw, ");
INSERT INTO ivb_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","as nakaiyahes na sya do adipenaw ni Abraham, “Sino nawri a manakey a machibayat dyaten?” Ki initbay na, “Nawriw āmo kwaw.” Ki insigīda na inhap abongot naw, as nakatalob nas ropa naw. ");
INSERT INTO ivb_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Do nakapaybabayat daw, inistorya no adipenaw di Isaak tabo napariparin do nangayan naw. ");
INSERT INTO ivb_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Dawa, inhap ni Isaak si Rebekka do yanan naw no tolda ni simna ānang na. Do dawri, kinabahay nas Rebekka. Oyod a chadaw nas Rebekka, as nahwahok dana a maynamot do mamayo naw do nakadimanaw ni ānang na. ");
INSERT INTO ivb_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Minirwa nangabahay si Abraham so mayngaran so Ketora, ");
INSERT INTO ivb_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","as inyanak na sa Simran, Joksan, Medan, Midyan, Isbak, kan Swa. ");
INSERT INTO ivb_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Si Joksan, nayparin a āmang ni Sheba kan Dedan. Si Dedan, kapoonan dan Assorim, siraw Letosim, kan siraw Leommim a tawotawo. ");
INSERT INTO ivb_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Siraw mahahakayaw a pōtot ni Midian, ki sa Epa, Eper, Hanok, Abida, kan Eldaa. Yapo sa tabo di Ketora. ");
INSERT INTO ivb_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ki inpatāwid ni Abraham tabo kinabaknang naw di Isaak. ");
INSERT INTO ivb_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ki aran komwan, sinagōtan na saw pōtot naw a mahahakay di Agar kan Ketora do kabyay na paw, as nakatoboy na sira a mangay do tana do dāya tan machibawa sa di Isaak. ");
INSERT INTO ivb_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Nadiman si Abraham do nakapagtawen nas asa gasot, papito poho kan dadima a katawen. ");
INSERT INTO ivb_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ki do nakadiman naw a nachirapa dyirad simna aāpong na saw, taywara danaw kamalkem na, as napnek dana do nakapaybibyay naw do kayayan na do hapotayan tana. ");
INSERT INTO ivb_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Intabon da Isaak kan Ismael do aschipaw do Makpela do bengkag da a dayāen no tana a Mamre a dyira ni Epron do kachwaw a pōtot ni Sohar a Heteo. ");
INSERT INTO ivb_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Iyaw nyaw tanaw a ginatang ni Abraham dyirad Heteo saw. Dawriw nakaitabonan da kan baket na. ");
INSERT INTO ivb_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Do nakadimanaw ni Abraham, binindisyonan Dyos si Isaak a anak na. Minyan si Isaak do masngenaw do bobonaw a mayngaran so “Bobon No Sibibyay A Dyos A Makaboya Dyaken.” ");
INSERT INTO ivb_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Nyaw pakasaritaan dan kapotōtan saw ni Ismael a pōtot ni Abraham di Agar a taga Egipto a adipen ni Sara. ");
INSERT INTO ivb_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Siraw nyaw ngarangaran dan pōtot na saw a mahahakay sigon do nakasarosarono da naiyanak: si Nebayot matoneng, kan si Kedar, Adbeel, Mibsam, ");
INSERT INTO ivb_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Doma, Massa, ");
INSERT INTO ivb_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetor, Napis, kan Kedema. ");
INSERT INTO ivb_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Siraw asa poho kan dadwa mahahakay a pōtot ni Ismael, ki sira danaw kapoonan dan asa poho kan dadwa nasnasyon, as napangaranan idi daw so ngaran da. ");
INSERT INTO ivb_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Nakapagtawen ni Ismael so asa gasot, tatdo a poho kan papito do nakadiman na a nachirapa dyirad simna aāpong na saw. ");
INSERT INTO ivb_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Minyan saw kapotōtan ni Ismael do payawan no Habila kan Sor, do dayāen no Egipto do rarahanaw a mangay do Asirya. Nachisyay sas niyanan kan nāw da naysin-iipsok. ");
INSERT INTO ivb_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Nyaw pakasaritaan dan kapotōtan saw ni Isaak a pōtot ni Abraham. ");
INSERT INTO ivb_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Nagtawen si Isaak so apat a poho do kapaychabahay da kan Rebekka a pōtot ni Betoel a asa Arameo a taga Mesopotamya. Si Rebekka, ki kakteh ni Laban. ");
INSERT INTO ivb_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ki maynamot ta dya mabogi si Rebekka, naydaydasal si Isaak di Āpo, as inakdaw na a matorohan so pōtot. Inadngey ni Āpo dasal naw, as nahay abas nakabogi ni Rebekka. ");
INSERT INTO ivb_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Nabogi si Rebekka so singin. Ki do kayan da paw do irahem no bodek na, ki pirmi sa maydiman. Binata ni Rebekka a kāna, “Āngo nya maparin dyaken?” Dawa, nangay a naydasal di Āpo. ");
INSERT INTO ivb_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Do dawri, binata ni Āpo dya a kāna, “Dadwa nasyon myan do irahem no bodek mo. Iyanak monchiw dadwa tawo a mayparin a dadwa maytarek a nasyon. Mayiyit anchiw asaw. Iyaw adyenaw, ki tobotoboyen nanchiw matonengaw.” ");
INSERT INTO ivb_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Sinpangan na, do nakarapit no arawaw a kapaymanganak na, ki singin sa mahakay. ");
INSERT INTO ivb_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Do nakawara no matonengaw, ki manyibayaw kodit naw kan borboran pa. Dawa, pinangaranan das Esaw. ");
INSERT INTO ivb_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Sinpangan na, naiyanak ādi naw a myan na igpet tobenaw no ākang naw. Dawa, pinangaranan das Jakob. Do dawri a nakapaymanganak ni Rebekka, nagtawen si Isaak so anem a poho. ");
INSERT INTO ivb_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Nayparakoh saw nya mahahakay. Si Esaw, ki nayparin a maganay a manganop, ta chadaw naw midibidi do kakahasan. Ki si Jakob a ādi na, ki maolimek a tawo, as kan makaditchan aba do tolda daw. ");
INSERT INTO ivb_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Chinadaw ni Isaak si Esaw maynamot ta chadaw naw mitchan so maanopanaw ni Esaw. Ki chinadaw ni Rebekka si Jakob. ");
INSERT INTO ivb_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Do asa karaw, nanglaneg si Jakob so agayap a mabaya. Do dawri, nawaras Esaw a yapod panganopan, kan taywaraw kapteng na. ");
INSERT INTO ivb_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Binata na di Jakob a kāna, “Oyod ko nayas kapteng! Torohan mo pa yaken so mabayaya a rotongan mo!” Nyaw nakayapwan na a napangaranan si Esaw so Edom. ");
INSERT INTO ivb_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ki tominbay si Jakob a kāna, “On, torohan koymo an manma mwa itadi dyaken iyaw kalintegan a matoneng a anak.” ");
INSERT INTO ivb_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Binata ni Esaw a kāna, “Ngay na, kadidiman ko nayad kapteng. Āngo paw pateg dyaken nawri a kalintegan?” ");
INSERT INTO ivb_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","“Na, anchi ka! Manma ikarim pa dyaken ah,” binata ni Jakob. Dawa, nagkari dya si Esaw a itadi narana di Jakob iyaw kalintegan naw a matoneng a anak. ");
INSERT INTO ivb_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Sinpangan na, tinorohan Jakob so tinapay kan linaneg naw a mabaya a agayap. Komninan as nakaynom na. Katayoka na, naytēnek as tod a komnaro. Iniktokto na pabaw kalintegan naw a matoneng a anak, ta mapateg aba dya. ");
INSERT INTO ivb_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Do dawri, minirwa myan kapaychapteng do tana no Kanaan akma do kachimpwaw ni Abraham. Dawa, nayadis sa Isaak do Gerar, do tana ni Abimelek a āri dan Pilisteo saw. ");
INSERT INTO ivb_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ki napaboya si Āpo dya, as binata na a kāna, “Mangay kaba do Egipto. Omyan kad tanaya a ibahey konchi a yanan mo. ");
INSERT INTO ivb_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Omyan ka do dyaya tana, ta karwan ko abanchimo, as bindisyonan konchimo. Itoroh konchi a tabo nyaya tana dyimo kan siraw kapotōtan mo. Tongpalen konchiw inkari kwaw di āmang mo a si Abraham. ");
INSERT INTO ivb_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Payparohen ko saw kapotōtan mo a akmas kāron bitohen do tohos, as itoroh ko dyira a tabo nyaya tana. As maynamot do kapotōtan mo, mabindisyonan sanchiw tabo tawotawo do tanaya. ");
INSERT INTO ivb_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Bindisyonan koymo maynamot ta manganohed si āmang mo, kan tinongpal naw tabo inbilin ko kan innanawo ko.” ");
INSERT INTO ivb_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Dawa, minyan sa Isaak do Gerar. ");
INSERT INTO ivb_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Do kaiyahes daw syan mahahakay a taga Gerar an baket nas Rebekka, ki binata na a kakteh na. Inbayataw na, ta mamo an dimanen da, as kahap das baket na. Ta si Rebekka, ki oyod nas kapintas a mabakes. ");
INSERT INTO ivb_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Do kahay daranaw daw da Isaak, naylalawong do bintan si Abimelek a āri dan Pilisteo, ki naboya na a myan a kepkepen ni Isaak si Rebekka a baket na. ");
INSERT INTO ivb_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Dawa, pinatawag nas Isaak, as nakaibahey na sya a kāna, “Namna! Baket mo sawen! Āngo ta batahen mwa kakteh mo?” Ki tinbay ni Isaak a kāna, “On, mo Āri, ata, bata ko an dimanen nyo yaken an ibahey kwa baket ko.” ");
INSERT INTO ivb_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Binata ni Āri Abimelek a kāna, “Ay! Āngo ta komwan pinarin mo dyamen? An myan sawen nangoknod so baket mwaya aket, imo napaygatos dyamen.” ");
INSERT INTO ivb_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Dawa, inbilin ni Abimelek dyirad tawotawo na saw a kāna, “Ipadiman ko aran sino a mamarin so marahet dyirad dyaya maychabahay.” ");
INSERT INTO ivb_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Do dawri a tana, ki naymohamoha si Isaak, as kan do dawri a tawen, nakaapit so aro, ta binindisyonan Āpo. ");
INSERT INTO ivb_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Naypāypābaknang a nandad oltimo naranas kabaknang. ");
INSERT INTO ivb_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Maynamot ta aro karniro kan baka na, as kan aro saw adipen na, inapālan dan Pilisteo saw si Isaak. ");
INSERT INTO ivb_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Dawa, pinonan daw tabo a bobon a kinadyan no adipen saw ni āmang na a si Abraham do kabyay na paw. ");
INSERT INTO ivb_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Sinpangan na, binata ni Abimelek di Isaak a kāna, “Maganaganay an karwan mo naw yanan namenaya, ta matortoray ka naya kan yamen.” ");
INSERT INTO ivb_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Do dawri, komnaro sa Isaak, as nangay a nagtolda do Payahosongan a Gerar. ");
INSERT INTO ivb_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Pinirwa na sa inpakadiw bobon saw a inpakadi ni simna āmang na do kachwaw, ta do nakadiman āmang na, pinonan dan Pilisteo saw. Pinangaranan na saw bobonaw so akmas inpangaranaw ni āmang na. ");
INSERT INTO ivb_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Naychadi saw adipen na saw so bayo a bobon do payahosonganaw, ki nakakadi sa daw so mayit a akbod. ");
INSERT INTO ivb_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Sinpangan na, nachidiman saw magpaspastoraw a taga Gerar dyirad pagpaspastoren saw ni Isaak, as nakabata da sya a kon da, “Dyamen nyaya ranom!” Nawriw paynamotan na a pinangaranan Isaak so bobon a “Nagsosopyatan.” ");
INSERT INTO ivb_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Somarono, naychadi dana saw adipenaw ni Isaak so matarek a bobon. Ki alit na, naydidimanan darana. Nawriw nakayapwan na pinangaranan danan Isaak so “Naydidimanan.” ");
INSERT INTO ivb_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Dawa, komnaro sa Isaak daw, as nakapaychadi nas matarek a bobon na. Do dawri, apabaw nachidiman. Dawa, pinangaranan nas “Marahawa,” ta binata na a kāna, “Ay, changori dana tinorohan na yaten Āpo so marahawa a yanan tan mayparo ta dya.” ");
INSERT INTO ivb_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Komnaro daw sa Isaak, as nakangay da do Beerseba. ");
INSERT INTO ivb_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Do dawri a ahep, napaboya si Āpo di Isaak, as nakabata na sya dya a kāna, “Yaken Dyosaw ni āmang mo a si Abraham. Mamo kaba, ta rarayayan koymo. Bindisyonan koymo, kan payparohen ko saw kapotōtan mwa maynamot do kari ko di adipen ko a si Abraham.” ");
INSERT INTO ivb_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Dawa, namarin daw si Isaak so pangidātonan, as nagdaydayaw di Āpo. Sinpangan na, nagtolda dana sa daw, as naychadi sa daw adipen naw so bobon. ");
INSERT INTO ivb_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Sinpangan na, yapo do Gerar, nangay si Abimelek di Isaak. Rinarayayan da si Abimelek da Ahossat a matalek na a sit a mamagbaga na kan Pikol iyaw pangolo dan soldado naw. ");
INSERT INTO ivb_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ki naychirin si Isaak dyira a kāna, “Āngo ta nangay kamo dya? Chapatak ko a ipsok nyo yaken, ta pinakaro nyo yaken do yanan nyo.” ");
INSERT INTO ivb_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ki initbay da a kon da, “Naon, ata, malawag a naboya namen a oyod a myan dyimo si Āpo. Dawa, no bata namen, ki maganay pakono an myan tolag ta a pagkinaryan ta. On, yamen pakono machitolag dyinyo. ");
INSERT INTO ivb_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Chakey namen a ikari mo a dyi nyo yamen a ranggasan akmas dyi namenaw a nakaranggas dyinyo, ta maynana maganay pinariparin namen dyinyo. On, oyod a pinakaro namen imo, ki aryoriw marahet a pinarin namen dyinyo daw? As sichangori, ki binindisyonan naymo ni Āpo.” ");
INSERT INTO ivb_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Katayoka da nagtotolag, namarin si Isaak so pasken dyirad bisīta naw, as komninan kan mininom sa. ");
INSERT INTO ivb_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Do kamabekasan naw, nagkariw katakatayisa dyira a dyi sa maglalaban. Katayoka no nawri, pinarobwatan san Isaak, as naysisyay dana sa a sikakapya. ");
INSERT INTO ivb_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Do dawri a araw, nangay sad Isaak adipen na saw, as nakaibahey da sya di Isaak so maynamot do kinadi daw a bobon. Binata da a kon da, “Nakakadi kami naw so ranom!” ");
INSERT INTO ivb_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Pinangaranan Isaak nawri a bobon do chirin da so “Seba.” Yapod dawri a araw, nayngaran nawri a syodad so Beerseba. ");
INSERT INTO ivb_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Do nakapagtawen ni Esaw so apat a poho, nangabahay so dadwa mababakes a Heteo a tawo a sa Jodit kan Basemat. Si Jodit, ki pōtot ni Beeri, as si Basemat, ki pōtot ni Elon. ");
INSERT INTO ivb_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Siraw nya dadwa manogang da, ki siraw nanoroh so rakoh a mamayo da Isaak kan Rebekka. ");
INSERT INTO ivb_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Do kamalkem danan Isaak, do dyi naranaw a pakaboyan, inpatawag nas Esaw a matoneng a anak na, as nakabata na sya dya a kāna, “Barok, may ka pa dya.” “Ari ako dya, mo Āmang,” initbay ni Esaw. ");
INSERT INTO ivb_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Do dawri, binata ni Isaak dya a kāna, “Maboya mwa malkem ako na, kan īto danaw kadiman ko. ");
INSERT INTO ivb_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Dawa, hapen mo bai mwaw, ta yangay mo yaken a panganop so ichan ko do kahasan, ");
INSERT INTO ivb_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","as kaimāsen mwa langgen maanopan mwaw iyaw chadaw kwaw a kapanglaneg ah! Anchan tayoka ka manglaneg, yangay mo dya, as kakan ko sya. Ta katayoka kwa koman, bindisyonan koymo sakbay no kadiman ko.” ");
INSERT INTO ivb_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Myan a adngedngeyen Rebekkaw ibahebaheyaw ni Isaak di Esaw. Dawa, do nakapakayamaw ni Esaw a nangay a nanganop do kahasan, ");
INSERT INTO ivb_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","tinawagan ni Rebekka si Jakob. Binata na dya a kāna, “Anak ko, nadngey ko kaychiw nakabilinaw ni āmang mo di ākang mos Esaw a kāna, ");
INSERT INTO ivb_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Yangay mo yaken a panganop, as kaimāsen mwa langgen maanopan mwaw, as kakan ko. Ta katayoka kwa koman, bindisyonan koymo do salapen Āpo sakbay no kadiman ko.’ ");
INSERT INTO ivb_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Dawa, adngeyen mo pa yaken, anak ko, as kan parinen mo ibahey kwaya dyimo. ");
INSERT INTO ivb_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Sichangori, mangay kad yanan binyay ta saw, as mamidi kas dadwa orbon no kalding a matataba, ta langgen ko so chadawaw ni āmang mwa kapanglaneg. ");
INSERT INTO ivb_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Iyangay monchi di āmang mo ah, tan kanen na, as bindisyonan naymo sakbay a madiman.” ");
INSERT INTO ivb_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ki tominbay si Jakob dya a kāna, “Ay, katen mo Ānang, ta borboranaw si ākang Esaw. Yaken, ki enggaya. ");
INSERT INTO ivb_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Āngonchan saliden na yaken Āmang, ki mapatakan na a al-allilawen ko. Samna! An komwan, bindisyon pabanchiw mahap ko, an dya abay.” ");
INSERT INTO ivb_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ki initbay ni ānang na dya a kāna, “Anak ko, mabakel kaba, ta imo abaw ngayan nawri a abay, an dya yaken. Basta magtongpal ka dyaken. Ngay, yay mo na hapen iyaw inbahey kwaya dyimo, ta yangay mo na dyaken.” ");
INSERT INTO ivb_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Dawa, nangay a nanghap si Jakob so inbaheyaw ni ānang na, as nakaitoroh na sya dya. Nilaneg ni Rebekka so maimasaw a akmas chadawaw ni Isaak. ");
INSERT INTO ivb_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Somarono, pinahtot ni Rebekka saw kinapikapya na saw do bahayaw a kagaganayan a laylay ni Esaw a matoneng a anak na, as nakailaylay na syad Jakob. ");
INSERT INTO ivb_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Binedbedan naw tanoro na saw kan lagawaw ni Jakob so koditaw no kaldingaw, ");
INSERT INTO ivb_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","as nakaitoroh na sya di Jakob so maimasaw a linaneg kan tinapay a rinotongan na. ");
INSERT INTO ivb_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Sinpangan na, nangay si Jakob di āmang na, as nakabata na sya a kāna, “Mo Āmang.” Ki tinbay ni āmang na, “On, barok. Sino dyinyo a anak ko nya?” ");
INSERT INTO ivb_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Ki tominbay si Jakob a kāna, “Yaken matonengaw a anak mwa si Esaw. Pinarin kwaw iyaw inbahey mwaw dyaken. Dawa, maybangon ka na a mitchan so karnyaya a insabat ko, as kabindisyon monchi dyaken an tayoka ka koman ah.” ");
INSERT INTO ivb_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ki binata ni Isaak do anak naw a kāna, “Ay samna! Kalistom pa nangay do kahasan, barok!” Tominbay si Jakob, “On, ata, sinidongan naw yaken ni Āpo a Dyos mo.” ");
INSERT INTO ivb_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ki binata na di Jakob a kāna, “Maypasngen ka pa dya, ta kapyasen ko paymo an ara paro a oyod a imos Esaw.” ");
INSERT INTO ivb_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Dawa, naypasngen si Jakob di āmang na, as kinapikapyas ni āmang na, kan binata pa ni Isaak a kāna, “Na, akmayaw si Jakob oni mwaya, ki sirayaw tanoro mwaya, ki si Esawayam na.” ");
INSERT INTO ivb_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Nailasin aba ni Isaak si Jakob, ta siraw tanoro naw, ki borboran a akmas tanoro saw ni Esaw. Do dawri, nakasagāna dana mangbindisyon sya, ki pinirwa na pa inyahes, ");
INSERT INTO ivb_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","“Oyodawri a imo si Esaw a anak ko?” Ki tinbay ni Jakob, “On, yakenaw, mo Āmang!” ");
INSERT INTO ivb_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Dawa, binata ni Isaak a kāna, “Yangay mo dyaw rinotongan mwaw, ta kanen ko na. Anchan tayoka ko, ki nawri dananchiw kabindisyon ko dyimo.” Dawa, pinasngen ni Jakob iyaw rinotongan naw, as kinan ni Isaak. Nakapanghap na pas palek a ininom ni āmang na. ");
INSERT INTO ivb_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Sinpangan na, binata ni Isaak dya a kāna, “Maypasngen ka dyaken, barok, ta dadek mo yaken.” ");
INSERT INTO ivb_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Do dawri, naypasngen si Jakob a mindadek si āmang na. Do nakaangotaw ni Isaak so laylay naw, binindisyonan na a kāna, “Oyod makaay-ayo iyaw āngot no anak kwaya a akmas āngo taw no tana a binindisyonan Āpo. ");
INSERT INTO ivb_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Itoroh pakono no Dyos iyaw apon a yapod hanyit a ombasa so tana tan magla saw mohamoha mo, as kan torohan na pakono imo so aro a āpit kan obas mo tan aro kanen kan inomen mo. ");
INSERT INTO ivb_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Magsirbi pakono sa dyimo nasnasyon saw, as kan siraw tawotawo, ki maydogod sa magdaydayaw dyimo. Itortorayan mo pakono saw kakabagyan mo saw, kan imo āpohen dan kakabagyan saw ni ānang mo. Mabay pakono saw mangabayaw dyimo, as siraw mangbindisyonaw dyimo, ki mabindisyonan pakono sa.” ");
INSERT INTO ivb_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Do katayokaw ni Isaak a nangbindisyon di Jakob, komnaro. As do kakakaro paw ni Jakob do salapenaw ni āmang na, ki nawara si Esaw a yapod nanganopan naw. ");
INSERT INTO ivb_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Nanotong pa si Esaw so maimas a linaneg, as nakaiyangay na sya di āmang na. Binata na dya a kāna, “Āmang, maybangon ka, ta koman ka na so karnyaya a insabat ko tan bindisyonan mo na yaken.” ");
INSERT INTO ivb_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Tominbay si Isaak, “Oy samna! Sino ka?” “Yakenaw si Esaw a matoneng a anak mo,” binata na. ");
INSERT INTO ivb_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Do dawri, taywara naychamirpirpir si Isaak, as binata na dya a kāna, “Ay samna! Sino nangisabat dyaken kaychi so nilanegaw a naanopan? Sakbay no kawara mo, inichan ko na, as intoroh ko na dyaw pamindisyon ko. Ay, matadyan pabaw nawri a bindisyon ko!” ");
INSERT INTO ivb_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Do nakadngeyaw sya ni Esaw so nyaya, tomnanyis so malyak, kan oltimo kaynyin aktokto na, as binata na a kāna, “Chāsi mo pa yaken, mo Āmang, ta bindisyonan mo pa yaken ah!” ");
INSERT INTO ivb_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ki tominbay si Isaak a kāna, “Kawanen! Nangay naya yaken a inallilaw ni ādi mo. Nahap naranaw itoroh kwaw dyimo a bindisyon.” ");
INSERT INTO ivb_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Binata pa ni Esaw a kāna, “Na, kostwaya. Dawa, sawen a nayngaran so Jakob, ta naypirwa narana yaken a niyoban a inallilaw. Inhap naw kalintegan kwa matoneng a anak. Sichangori, inhap na paw bindisyon a itoroh mo dyaken. Āmang, apabawriw bindisyon mo dyaken?” ");
INSERT INTO ivb_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ki tominbay si Isaak di Esaw a kāna, “Na, intoroh ko na dyaw bindisyon, as iya danaw āpohen mo. Masaw dyirad tabo a kakabagyan nyo a magsirbi dya. Inbahey ko pa a mayparo pakononchiw kanen na kan inomen na. Barok, arabaw bindisyon ko dyimo.” ");
INSERT INTO ivb_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ki nakatongtong ni Esaw a nangdaw so kāsi ni āmang na. Binata na a kāna, “Asawriw pamindisyon mo, mo Āmang? Bindisyonan mo pa yaken ah!” Maynamot ta naylilyak abas Isaak, naypalyak dana tomnanyis. ");
INSERT INTO ivb_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Sinpangan na, nyaw inbahey ni Isaak dya a kāna, “Omyan kanchi do tana a dya maganay a paymohan, kan abanchiw apon a ombasa so tana mo. ");
INSERT INTO ivb_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Nawrinchiw kabyayan mo kapachilaban mo maynamot do ispada, as magsirbi kanchid ādi mo. Ki aran komwan, anchan dyi mo na maibtoran kaadipen mo, ki mapenpen nabaymo a mangditchan so toray na.” ");
INSERT INTO ivb_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Yapod dawri, taywara isoli ni Esaw si Jakob a ādi na a maynamot do nakayoba naw so bindisyonaw ni āmang na dya, as nyaw myan do aktokto na, “Ara, ki mahay paba madiman si āmang. Anchan tayokaw arawaw a kapagmamayo, ki dimanen konchi si Jakob.” ");
INSERT INTO ivb_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ki do nakadamagaw ni Rebekka so inbaheyaw ni Esaw, inpatawag nas Jakob, as kan binata na dya a kāna, “Anak ko, inplano na kono imo no ākang mwaw dimanen tan maagasan iyaw kaynyin no aktokto na dyimo. ");
INSERT INTO ivb_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Sichangori, adngeyen mo chirin kwaya, anak ko. Mangay ka sigida do Haran do yananaw ni maraan mos Laban a kakteh ko. ");
INSERT INTO ivb_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Omyan ka daw a mandan mabawan kasoli ni ākang mo dyimo. ");
INSERT INTO ivb_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Anchan mabawan danaw soli na, as kan nawayakan naranaw pinarin mwaya dya, ki manoboy akonchi so mangay a omhap dyimo. Aysa! Marawa kwabaw kapagmamayo ko an mayrayay kamo a dadwa a mabo do asa karaw.” ");
INSERT INTO ivb_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Sinpangan na, binata ni Rebekka di Isaak a kāna, “Ayya! Maanōsan ko pa sabayaw Heteo saya a kabahay ni Esaw. An mangabahay panchi si Jakob so kapayngay dan nyaya a Heteo, ayket, maganaganay dana an madiman ako!” ");
INSERT INTO ivb_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Dawa, maynamot do inchirinaya ni Rebekka, pinatawag ni Isaak si Jakob. Kinablaawan naw anak naw, as nakabilin na sya a kāna, “Barok, mangabahay kaba siras mababakes saya do dya Kanaan ah. ");
INSERT INTO ivb_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Mangay ka na do Mesopotamya do pamilya ni Betoel a āmang ni ānang mo, kan mangabahay ka so asa dyirad mababakes saw a anak ni Laban a maraan mo a kakteh ni ānang mo. ");
INSERT INTO ivb_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Bindisyonan pakono imo no Dyos a Manakabalin, as torohan na pakono imo so aro a pōtot tan mayparin kanchi a āmang no aro a nasnasyon. ");
INSERT INTO ivb_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Bindisyonan pakono no Dyos imo kan siraw kapotōtan mo so bindisyonaw ni simna āpong mos Abraham. Tan komwan, dyira nyonchi iyaw tanaya a yanan tas changori a iyaw inkaryaw no Dyos di āpong mo.” ");
INSERT INTO ivb_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Katayoka na naychirin, tinoboy ni Isaak si Jakob do Mesopotamya a yanan ni Laban a pōtot ni Betoel no Arameo a tawo. As si Laban, ki kakteh na pa ni Rebekka a ānang da Esaw kan Jakob. ");
INSERT INTO ivb_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Sinpangan na, natonngan ni Esaw a binindisyonan ni āmang na si Jakob, as nakatoboy na sya a mangay do Mesopotamya a mangabahay daw. Napatakan na pa a do nakabindisyon naw sya, ki inbilin na a dya mangabahay siras mababakes saya Kananeo. ");
INSERT INTO ivb_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Natonngan pa ni Esaw a tongpalen ni Jakob no inbaheyaw ni āmang kan ānang da, ta nangay dana do Mesopotamya. ");
INSERT INTO ivb_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","As dawa, naawātan na a chakey aban āmang na siraw mababakes saya a Kananeo. ");
INSERT INTO ivb_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Do dawri, nangay si Esaw do yananaw no maraan naw a si Ismael a anak ni simna Abraham. Aran myan danaw dadwa baket ni Esaw, ki alit na pa kinabahay na si Mahalat a pōtot ni Ismael, as kan kakteh ni Nebayot. ");
INSERT INTO ivb_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Do nakakarwaw ni Jakob do yanan da a Beerseba, ki kominwan do Haran. ");
INSERT INTO ivb_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Nakaysan do asa yanan, ta nahpan dana. Ki do nakapaypoktad naw, nanghap so asa bato a nayponganan na, as nakapakaycheh na. ");
INSERT INTO ivb_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Sinpangan na, tinayēnep na a nakaboya so asa ayran a yapo do tana a nakarapit do hanyit. Myan saw anghil no Dyos a nāw da maytotopdis a komayat kan gomchin do dawri a ayran, ");
INSERT INTO ivb_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","kan naboya na si Āpo a maytēnek do anmwaw no ayran. Binata dya ni Āpo a kāna, “Yaken si Āpo a Dyos a dinaydāyaw ni Abraham a simna āpong mo, kan Dyos a daydayāwen ni Isaak a āmang mo. Nyaya tana a pakaychehan mo sichangori, ki itoroh konchi dyimo kan kapotōtan mo. ");
INSERT INTO ivb_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Akma sanchiw kāro no ahbek, kāro no kapotōtan mo. Maychawpit sanchi do tana do laod, dāya, ammyānan, kan abagātan, as kan maynamot dyimo kan kapotōtan mo saw, bindisyonan konchiw tabo tawotawo. ");
INSERT INTO ivb_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Nāw ko na machirayay dyimo, kan aywanan koymo do tabo a ngayan mo, as kan paybidyen konchimo do dya a tana. On, polos a dyi koymo a karwan a mandanchan matongpal ko iyaw kari kwaya dyimo.” ");
INSERT INTO ivb_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Katayoka na, nayokay si Jakob, kan binata na do aktokto na a, “Ay samna! Myan paya dya si Āpo, ki chinapatak kwabaya.” ");
INSERT INTO ivb_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Namo si Jakob, as binata na a kāna, “Ay anyan! Makamwamomo sawen nyaya yanan! Nya danaw bahayaw ni Āpo kan ayaman a mangay do hanyit.” ");
INSERT INTO ivb_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Do kamabekasan naw, minhep a naybangon si Jakob. Inhap naw batwaw a nayponganan na, as pinaytēnek na a pakanaknakman na so naparinaw dya. Somarono, pinadwan na so lana no olibo hapotaw no batwaw. ");
INSERT INTO ivb_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Pinangaranan na so Betel nawri a tana. Ki Los, ngaran na do kachwaw. ");
INSERT INTO ivb_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Sinpangan na, nagkari si Jakob, “An myan ka dyaken mo Āpo Dyos, as aywanan mo yaken do kapagbyahi kwaya, kan torohan mo yaken so kanen kan laylay ko, ");
INSERT INTO ivb_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","as an paybidyen mo yaken a sisasalon-at do bahay ni āmang ko, ayket, imo danaw Āpo a Dyos ko. ");
INSERT INTO ivb_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Iyaw nya bato a pinatnek ko a pakanaknakman, iyanchiw nya logar mayparin a pagdaydayāwan dyimo, kan itoroh konchiw apagkapollo no tabo myan dyaken.” ");
INSERT INTO ivb_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Do katayokaw no nawri, tinongtong ni Jakob kapagbyahi naw, kan nakarapit do tana daw no taga dāya. ");
INSERT INTO ivb_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Do dawri, nakaboya so asa bobon do gagan no asaw a idi. Myan saw nakpeh a maynahah a tatdo a kaarban karniro do masngenaw do bobonaw, ta dawriw pirmi a pamaynoman da, ki nataloban pa so rakoh a bato. ");
INSERT INTO ivb_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","An maychichipeh dana sa tabo karniro daw, balakwangen dan magpaspastoraw iyaw batwaw, as kapaynom da sira. An tayoka sa minom, ki paybidyen daw batwaw a patohongen. ");
INSERT INTO ivb_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Do dawri, nanahahes si Jakob dyirad magpaspastoraw a kāna, “Inyom Sir, taga dino kamo?” Ki tominbay sa dya a kāna, “Na, taga Haran kamyaw.” ");
INSERT INTO ivb_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Inyahes pa ni Jakob dyira a kāna, “Chapatak nyori si Laban a apōko ni Nahor?” “On, chapatak namenaw,” inatbay da. ");
INSERT INTO ivb_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","“Na, komosta?” inyahes ni Jakob. “Na, aryaw a maganay. Chiban mo paw maypasngenaya. Tori danayas Rakel a anak na a mangyangay so karniro saw ni āmang na,” binata da. ");
INSERT INTO ivb_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Binata ni Jakob dyira a kāna, “Makohat payaw araw. Ari na payad oras a ikoral nyo sa. Āngo ta dyi nyo sa paynomen karniro saya, as paybidyen nyo sa a pagaraben?” ");
INSERT INTO ivb_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ki tominbay sa dya, “Aysa! Maparin namen aba, ta nawri dananchiw kabalakwang namen so batwaya an maychichipeh sa tabo, as kapaynom namen sira.” ");
INSERT INTO ivb_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ranan pan kapachisarsaritaw ni Jakob dyirad magpaspastoraw, ki nawara si Rakel kan karniro saw ni āmang na, ta aran iya, ki asa mangay-aywan so karniro. ");
INSERT INTO ivb_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Do dawri a nakaboya ni Jakob si Rakel a anak ni Laban a kakteh ni ānang na, kan siraw karnirwaw ni maraan na, nanyeng na nangay a binalakwang iyaw batwaw a tohong no bobonaw, as nakapaynom na siras karniro saw. ");
INSERT INTO ivb_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Katayoka na, dinadek na si Rakel, kan insiknan naw tomnanyis do kasoyot na. ");
INSERT INTO ivb_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Binata na dya a kāna, “Kaanakanaw yaken ni āmang mo. Yakenaw, ki anak ni Rebekka a kakteh na.” Do nakadngeyaw sya ni Rakel, ki nakalyalisto a nayyayo a nangay a nangibahey sya di āmang na. ");
INSERT INTO ivb_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Dawa, do nakadamagaw sya ni Laban so maynamotaw di Jakob a anak ni kakteh na, nakapayapayayo na a nangay a minbayat sya. Kinepkep nas Jakob, as nakadadek na sya, as inyangay na do bahay na. Do nakawara daw do bahay ni Laban, inistorya ni Jakob tabo a naparin dya. ");
INSERT INTO ivb_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Binata ni Laban di Jakob a kāna, “Oyod sawen a kaanakan koymo!” Do dawri, nakabohan a minyan si Jakob do yanan Laban. ");
INSERT INTO ivb_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Do dawri, napahabas asa kabohan, binata ni Laban di Jakob a kāna, “Maynamot ta kaanakan koymo, āngo ta maytarabako ka abos tangdan? Ay samna! Maparin aba komwan. Ibahey mo na ah, an papiraw chakey mwa tangdan?” ");
INSERT INTO ivb_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Ki myan do dawriw dadwa anak ni Laban a mababakes: si Lea iyaw matoneng kan si Rakel a ādi na. ");
INSERT INTO ivb_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Mapintas iyaw mata ni Lea, ki mapinpintas kan mapostora iyaw inawan ni Rakel. ");
INSERT INTO ivb_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Do dawri, myan nadidiw ni Jakob a ayat na di Rakel. Dawa, binata na di maraan na a kāna, “Maytarabako ako dyimo so papito a tawen an ipakabahay mo dyaken si Rakel a adeadekey a balāsang mo.” ");
INSERT INTO ivb_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Initbay ni Laban dya a kāna, “Naon, chakey ko, ta maganaganay a imo makakabahay sya kan matarek. Dawa, nāw mo na machiyan dyamen.” ");
INSERT INTO ivb_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Dawa, nakapaytarabako ni Jakob so papito a katawen tan makabahay nas Rakel, kan napootan nabaw nakapaypahabas no araw saya maynamot ta taywaraw kadaw na si Rakel. ");
INSERT INTO ivb_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ki do nakatayokaw ni Jakob so papito a tawen, inbahey na di Laban a kāna, “Ay mo Maraan, napakabos ko naw chimpwaw a inkari ko a maytarbako dyimo. Chakey kwa ipakabahay mo na dyaken si Rakel tan myan danaw baket ko.” ");
INSERT INTO ivb_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Do dawri, namarin si Laban so rakoh a pasken, as rinara na sa tabo tawotawo daw a mangay do kasar. ");
INSERT INTO ivb_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Sinpangan na, do dawri a ahep, ki si Rakel abaw pinaoknod ni Laban di Jakob, an dya si Lea. Chapatak aba ni Jakob, dawa, inoknod nas Lea. ");
INSERT INTO ivb_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ki maynamot ta nangabahay dana si Lea, intoroh ni Laban di Lea iyaw adipen naw a si Silpa tan iya danaw adipen na. ");
INSERT INTO ivb_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ki do kamabekasanaw, natonngan ni Jakob a si Lea iyaw kinaoknod naw. Dawa, nangay di Laban, as nakabata na sya dya a kāna, “Āngo ta komwan pinarin mo dyaken, mo Maraan? Nagsirbi ako abawri dyimo so papito a katawen tan makabahay ko si Rakel? Āngo ta inallilaw mo yaken?” ");
INSERT INTO ivb_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Ki tominbay dya si Laban a kāna, “Dāgen namen do dya an manmanma a pakabahayen namen adeadekey a anak namen, an dyi pa makakabahay iyaw matonetonengaw. ");
INSERT INTO ivb_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Patayokahen mo paw asaya kalawas a ragragsak no kasar mo di Lea. Katayoka no nawri, ipakabahay ko pa dyimo si Rakel a ādi na an maytarabako ka pa dyaken so papito a katawen.” ");
INSERT INTO ivb_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Nakey si Jakob, dawa, do katayokaw no asa kalawas a ragragsak no kasar na di Lea, intoroh dya ni Laban si Rakel a nayparin pa baket ni Jakob. ");
INSERT INTO ivb_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Si Bilha a adipen Laban, ki intoroh ni Laban di Rakel tan adipen na. ");
INSERT INTO ivb_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Inoknod pa ni Jakob si Rakel. Ki rakorakoh adaw ni Jakob di Rakel kan si Lea. Sinpangan na, naytarabako si Jakob di Laban so papito pa a katawen. ");
INSERT INTO ivb_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Do kaboyaw sya ni Āpo a dya oyod ni Jakob a chadaw si Lea, tinorohan na so anak, as si Rakel, ki abaw anak na. ");
INSERT INTO ivb_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Do dawri, nabogi si Lea, kan naymanganak so asa mahakay. Pinangaranan na so Ruben, ta binata na, “Naboya ni Āpo iyaw kapagmamayo ko. Sigoro, chadaw na, ngata, yaken lakay ko sichangori.” ");
INSERT INTO ivb_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Sinpangan na, minirwa dana nabogi si Lea, as inyanak naranaw asa mahakay. Pinangaranan naw adekeyaw so Simeon, ta binata na, “Intoroh na pa ni Āpo dyaken nya anak ko, ta nadngey na a dya oyod yaken ni Jakob a chadaw.” ");
INSERT INTO ivb_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Minirwa dana nabogi, as naymanganak dana so asa pa mahakay. Pinangaranan nas Lebi, ta binata na, “Changori, ngata, maypadekket dyaken si lakay ko, ta ari danaw tatdo a mahahakay a anak ko.” ");
INSERT INTO ivb_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Minirwa pa nabogi, kan naymanganak pa so mahakay. Pinangaranan na so Joda, ta binata na, “Changori, dadayen ko Dyos.” Katayoka no nawri, nayhat a naymanganak. ");
INSERT INTO ivb_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Do kadlawaw ni Rakel a dya maymanganak, nangimon di Lea a ākang na, as binata na di Jakob a kāna, “An chaskeh mo a madiman ako, torohan mo yaken so anak ko!” ");
INSERT INTO ivb_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Nakasoli si Jakob di Rakel, dawa, binata na dya a kāna, “Āngo ta komwan ibahey mo dyaken? Dyos akori? An iyaw dya mapaymanganak dyimo, aryoriw maparin ko?” ");
INSERT INTO ivb_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ki inatbay ni Rakel a kāna, “Namna! An komwan bata mo, cha dya si Bilha a adipen ko. Kaoknod mo tan makapaymanganak so ibidang ko a pinakaanak ko kan tan magpamilya akwa maynamot dya.” ");
INSERT INTO ivb_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Dawa, intoroh na si Bilha a adipen na a kinaoknod ni Jakob a akma nay baket. ");
INSERT INTO ivb_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Sinpangan na, nabogi si Bilha, kan naymanganak so mahakay. ");
INSERT INTO ivb_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Binata ni Rakel a kāna, “Ay, chināsi yaken no Dyos. Nadngey na iyaw no inakdakdaw ko, ta tinorohan na yaken so anak.” Dawa, pinangaran na so Dan. ");
INSERT INTO ivb_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Sinpangan na, minirwa a kinaoknod ni Jakob si Bilha a adipen ni Rakel. Minirwa nabogi si Bilha, as naymanganak so chadadwa no anak naw, ki mahakay pa. ");
INSERT INTO ivb_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Binata ni Rakel a kāna, “Inpasnek ko nachilomba di ākang ko, ki nangābak ako.” Dawa, pinangaranan naw adekeyaw so Neptali. ");
INSERT INTO ivb_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Do kadlaw danaw ni Lea a dyi dana maymanganak, intoroh naw adipen naw a si Silpa di Jakob a akma nay baket. ");
INSERT INTO ivb_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Sinpangan na, nabogi si Silpa, as naymanganak so mahakay. ");
INSERT INTO ivb_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Binata ni Lea a kāna, “Ay, magasat akwaya!” Dawa, pinangaranan nas Gad. ");
INSERT INTO ivb_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Sinpangan na, minirwa a kinaoknod ni Jakob si Silpa a adipen ni Lea. Minirwa dana nabogi si Silpa, as naymanganak so chadadwa no anak naw, ki mahakay pa. ");
INSERT INTO ivb_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Binata ni Lea a kāna, “Ay, masoyot ako na! Sichangori, pangaranan da yaken kapayngay ko saw a mababakes so masoyot.” Dawa, pinangaranan na so Aser adekeyaw. ");
INSERT INTO ivb_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Do chimpo no kapagranyi so trigo, nangay si Ruben do hakawan. Ki do dawri, nakaboya so asa kita no asin tamek a mayngaran so mandragoras, ki nangisabat di ānang na a si Lea. As dawa, do kaboyaw sya ni Rakel, binata na di Lea a kāna, “Torohan mo pa yaken so kadwanaya a mandragoras no anak mwaya.” ");
INSERT INTO ivb_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ki tominbay si Lea a kāna, “Namna! Sinodib mo naw kadaw ni lakay ko. Manawob pabawri dyimo nawri? Sichangori, āngo paw sodiban mos mandragoras sayan anak kwaya?” Ki binata ni Rakel dya a kāna, “An torohan mo yaken so mandragoras saya no anak mwaya aket, ipalōbos ko si Jakob a machoknod dyimo anchan mahep.” ");
INSERT INTO ivb_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Do kapaysarisari naw, nawara si Jakob a yapo do hakawan. Binayat ni Lea, as binata na dya a kāna, “Sichahep, yaten mayoknod, ta tinadyan ko so mandragoras sayan anak kwaw kapachoknod mo dyaken.” Dawa, nayoknod sa do dawri a mahep kan Jakob. ");
INSERT INTO ivb_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Inadngey no Dyos iyaw dasal ni Lea. Dawa, nabogi si Lea, as naymanganak so asa pa anak a mahakay. Nyaw chadadima a anak da kan Jakob. ");
INSERT INTO ivb_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Dawa, binata ni Lea a kāna, “Tinorohan na yaken no Dyos so gon-gona maynamot do nakaitoroh kwaw so adipen kwaya di lakay ko.” Dawa pinangaranan nas Issakar. ");
INSERT INTO ivb_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Sinpangan na, minirwa a kinaoknod ni Jakob si Lea. Minirwa nabogi si Lea, as naymanganak dana so asa pa a mahakay. Iyaw nyaw chanem no anak da kan Jakob. ");
INSERT INTO ivb_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Binata ni Lea a kāna, “Tinorohan na yaken no Dyos so asa mapateg a sāgot. Changori, anyiben ngata yaken ni Jakob, ta nakaiyanak ako so anem a mahahakay.” Dawa, pinangaranan naw adekeyaw so Sabolon. ");
INSERT INTO ivb_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Sinpangan na, minirwa dana naymanganak si Lea, ki mabakes a pinangaranan nas Dina. ");
INSERT INTO ivb_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ki do dawri, nawayakan aba no Dyos si Rakel, ta inadngey naw dasal na, kan tinorohan na so chimpo na a maymanganak. ");
INSERT INTO ivb_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Nabogi si Rakel, as naymanganak so asa mahakay. Binata na a kāna, “Changori, pinakaro no Dyos pakasnesnekan ko maynamot do nakaitoroh naya dyaken so anak.” ");
INSERT INTO ivb_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Pinangaranan naw adekeyaw so Jose, ta binata na, “Rakoh hahawen kwa torohan na pa yaken no Dyos so asa pa anak a mahakay.” ");
INSERT INTO ivb_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Do nakaiyanak danaw ni Jose, binata ni Jakob di Laban a kāna, “Palobosan mo na yaken a komaro dya tan maybidi ako do sigod a yanan āmang ko. ");
INSERT INTO ivb_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Aran siraw baket ko kan anak ko saya, ki palobosan mo sa tan komaro kami dya, ta nakabos danaw chimpo a nakaikāro ko sira dyimo. On, chapatak mwaya an maypāngo nakapaytarabako ko dyimo.” ");
INSERT INTO ivb_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ki tominbay si Laban a katogangan na a kāna, “Anchi ka pa. An chāsi mo yaken, omyan ka pa dya. Komaro kaba, ta maynamot do bokod kwa pangancharan, napatakan ko na binindisyonan na yaken ni Āpo a maynamot do nakayan mwaya dyaken. ");
INSERT INTO ivb_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Na, ibahey mo an papiraw chakey mwa tangdan, ta nawriw itoroh ko dyimo.” ");
INSERT INTO ivb_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ki tominbay dya si Jakob a kāna, “Engga. Nawri abaw chakey ko. Chapatak mo na an maypāngo nakapaytarabako ko dyimo, kan mango nakapayparo no binyay mo do kaaywan ko sira. ");
INSERT INTO ivb_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Oyod saba aro binyay mo do kawara kwaw, ki taywara nayparo sa sichangori, ta binindisyonan naymo ni Āpo do aran āngo a ipatarabāko mo dyaken. Changori, oras dana tan chiban ko kaganayan mismo a pamilya ko.” ");
INSERT INTO ivb_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Ki inyahes ni Laban a kāna, “Naon, ki āngo itangdan ko dyimo?” Tominbay si Jakob dya a kāna, “Tangdanan mwaba yaken. Ki an makey ka do asaya lang a ibahey ko dyimo, tongtongen ko sa a chichiban siraw binyay mo saya. ");
INSERT INTO ivb_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Sichangori, ipalōbos mwa mangay ako do yanan daw no binyay saw, ta patarken ko sa tabo karniro a dya maynana maydak, tabo orbon saw a karniro a mababaheng kan tabo kalding a malabalabang kan mabochibochit. Sira lang nyayaw akdawen ko a itangdan mo dyaken. ");
INSERT INTO ivb_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Tan komwan, aran mahay mo sa yangay a bisītaen dyaken saya, ki matonngan monchi an malinteg ako mana engga. Ta an myan anchiw maboya mo a kalding a dya labang mana mabochibochit, iyanchiw nyaw maydamnay a pakalasinan mo an myan tinakaw ko. Masaw dyirad orbon saw a karniro ko an myan maboya mo a maydak.” ");
INSERT INTO ivb_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","“Naon, komwan ah. Parinen ta iyaw no inbahey mwaya,” initbay ni Laban. ");
INSERT INTO ivb_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Dawa, do dawri a araw, no pinarin ni Laban, ki pinatarek na tabo mahahakay saw a kalding a orit-oritan kan malabalabang so maydak kan tabo mababakes a kalding a mabochibochit kan malabalabang a myan so maydaydak. Pinatarek na pa tabo mababaheng saw a karniro, as nakaitoroh na sira dyirad anak na saw a mahakay tan aywanan da sa. ");
INSERT INTO ivb_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Inpaikaro na sa tan pachibawa da sa di Jakob, as inpaiyangay na sa do mateng a yanan a ayamen do tatdo a karaw. Ki siraw nabidinaw a binyay, ki inpaaywan na sa di Jakob. ");
INSERT INTO ivb_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Sinpangan na, nanghap si Jakob so mata a sangasanga no tatdo a kitan kayo a maydamnay a makochichasan. Kinochikochichasan na tan maychanyidanyidak sangasangaw. ");
INSERT INTO ivb_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Pinatēnek na saw nakochichasanaw a sangasanga do salapen daw no arban sa do yanan saw no inoynoman da. Komwan pinarin na tan matoyen sa, ta magdadakep saw nyaya binyay an mangay sa minom. ");
INSERT INTO ivb_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Sinpangan na, do nakapagdadakep daw no binyay saw do salapen daw no sangasanga, natoyen sa, kan naymanganak sa so orit-oritan, mabochibochit, kan malabalabang. ");
INSERT INTO ivb_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Siraw nya orbon no kalding kan karniro, pinatawa sa ni Jakob, as pinasalap na saw pinatawa naw dyirad pangganakan saw a maynana mababaheng kan mayidak tan matoyen sa. Komwan nakaparo na so binyay na, kan pinatarek na sa dyirad binyay saw ni Laban. ");
INSERT INTO ivb_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","An mapagran saw matatabaw a binyay, pangayen ni Jakob iyaw nakochichasanaw a sangasanga do masngenaw do inoman da saw tan maboya da, ta dawriw paydadakpan da. ");
INSERT INTO ivb_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ki pangayen naba dyirad magogolangaw nya saya sanga. Dawa, dyira dana sa ni Laban magogolangaw, as dyira sa ni Jakob masasalon-at saw. ");
INSERT INTO ivb_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Komwan nakapayparin ni Jakob a taywara mabaknang. Aro dyira na a karniro, kalding, kamilyo, asno, kan adipen na saw a mahahakay kan mababakes. ");
INSERT INTO ivb_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Do dawri, nadngeyan ni Jakob iyaw riklamo dan pōtotaw ni Laban a kon da, “Taywara danayas Jakob, ta appīten naranaya tabo dyiran Āmang, as kan si Āmangayaw nakayapwan tabo kinabaknang na!” ");
INSERT INTO ivb_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Nadlaw pa ni Jakob a tomnabang dana dya si Laban, ta akma pabas kasngen na dya do nakarahan. ");
INSERT INTO ivb_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Do dawri, binata ni Āpo di Jakob a kāna, “Maybidi ka na do tana no inyapwan mo kan kakabagyan mo saw, kan myan ako a mangay-aywan dyimo.” ");
INSERT INTO ivb_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","As dawa, nanoboy si Jakob so mangay a mangibahey dyirad dadwaw a baket na a sa Rakel kan Lea a mayboboya sa do pamaaraban naw siras binyay na saw. ");
INSERT INTO ivb_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Do kawara dad yanan naw, binata na dyira, “Natonngan ko a matabang dana si āmang nyo dyaken, ta akma paba do kachwaw. Ki aran komwan, ki nāw na aywanan yaken no Dyosaw a daydayāwen ni āmang ko. ");
INSERT INTO ivb_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Chapatak nyo na an maypāngo kagaget ko do kapaytarabako ko di āmang nyo. ");
INSERT INTO ivb_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ki alit na a kinosit na yaken, kan naypisa aba lang, ta pirmi dana kinosit na yaken do nagtolagan namen a tangdan ko. Ki bāli, ta inpalōbos aban Dyos a rinanggasan na yaken. ");
INSERT INTO ivb_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ta do kaibahey naw a mabochibochit iyaw binyay a dyira ko a tangdan ko, ki naymanganak sa tabo binyay na so mabochibochit. As do kaibahey naw a orit-oritan iyaw binyay a tangdan ko, ki naymanganak dana sa tabo so orit-oritan. ");
INSERT INTO ivb_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Dawa, oyod a sinidongan ni Āpo Dyos yaken, ta inhap na saw pinakadyira kwaw do dyira saw ni āmang nyo a pinabidi dyaken. ");
INSERT INTO ivb_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Do naypisa do chimpon kapagdadakep dan kalding, tinayēnep ko. Ki naboya kwaw do tayēnep ko a siraw tōro a kalding a mangdakep so mababakes saw a kalding, ki maynana orit-oritan, mabochibochit, kan malabalabang. ");
INSERT INTO ivb_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Sinpangan na, do tayēnep ko, nagparang iyaw Anghil no Dyos a nachisarsarita dyaken, as kan naychirin dyaken a kāna, ‘Jakob.’ Ki inatbay ko, ‘Ari ako dya, mo Āpo.’ ");
INSERT INTO ivb_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Binata na pa, ‘Chiban mo saw tabo tōro saya a kalding a mangdakep. Maynana sa orit-oritan, mabochibochit, kan malabalabang. Yaken akin plano so nyaya, ta naboya ko tabo marahet a pinarin Laban dyimo. ");
INSERT INTO ivb_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Yaken iyaw Dyosaw a napaboya dyimo do Betel a napatnekan mo so pakanaknakman a bato a pinadwan mo so lana, as kan do dawriw, nagkaryan mo dyaken. Changori, karwan mo naw tanaya dya, as kan maybidi ka do nakayanakan mo a tana.’” ");
INSERT INTO ivb_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Katayokan nakapaychirin Jakob, tominbay sa Rakel kan Lea a kon da, “Aysa! An komwan, ari pawriw matawid namen di Āmang? ");
INSERT INTO ivb_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Inbidang nabawri yamen a istranghiro sichangori? Pi! Akma naya yamen inlāko, as iyaw kwartaw a pagbayad mo dyamen, ki nagasto narana. ");
INSERT INTO ivb_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","An komwan, masyirto danaw tabo a kinabaknang a inhap no Dyos di āmang namen, ki dyamen dana kan siraw anak namen saya. Dawa, sichangori, parinen mo iyaw inbahey no Dyos dyimo.” ");
INSERT INTO ivb_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Sinpangan na, do nakapakarobwat daranaw da Jakob, pinasakay naw pōtot na saw kan dadwaw a baket na do kamilyo saw. ");
INSERT INTO ivb_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Do dawri, pinanma na sa a tinoyo tabo reprep saw a binyay na, kan inhap na sa tabo warawara naw a nakpeh na do kayan nad Mesopotamya, as kapaybidi narana do Kanaan a tana ni āmang na a si Isaak. ");
INSERT INTO ivb_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Do kakaro daranaw da Jakob, aba daw si Laban, ta nangay na sa a ginogodan naipastor saw a karniro na. Dawa, nangay pas Rakel a nanakaw siras didyosen saw ni āmang na. ");
INSERT INTO ivb_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Asa pa, siniriban Jakob si katogangan na a si Laban a asa Arameo, ta inbahey naba dyaw nakayam na. ");
INSERT INTO ivb_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Dawa, inalyalistwan na sa inhap tabo warawara kan kinabaknang na, as nakapaglibas da. Inabtang da iyaw Oksong a Oprates, kan tinongtong daw nayam a kominwan do katokotokonanaw do tana a Galaad. ");
INSERT INTO ivb_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Do chatatdo naranaw a karaw do nakapakakaro daranaw da Jakob, nadamag ni Laban a naglibas si Jakob. ");
INSERT INTO ivb_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Do dawri, nanyeng na inhap kadwan saw a kakabagyan na, as nakalakat da sa Jakob. Papito a karaw da a nanglakat sira, as nakadas da sira do katokotokonanaw do Galaad. ");
INSERT INTO ivb_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ki do ahepaw a sakbay a kadas da sira, pinaytayēnep no Dyos si Laban a taga Aram a binata na dya a kāna, “Magannad kam Laban, ta salsalyan mwabas Jakob.” ");
INSERT INTO ivb_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Ki do dawri, nagtolda dana sa Jakob do katokotokonanaw do Galaad. As aran sa Laban, do nakapakarapit daw daw, ki nagtolda sa. ");
INSERT INTO ivb_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Do nakapayboya daw, inyahes ni Laban di Jakob a kāna, “Barok, āngo ta pinarin mo komwan? Sinikapan mo yaken a tod mo sa inkaro pōtot ko saya a akma say mababakes a natiliw do paggogobatan. ");
INSERT INTO ivb_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Āngo ta sinikapan mo yaken a inkorimed mo komnaro a dya nagpakada? An inbahey mo dyaken, aysa, siraragsak ako a nangparobwat dyinyo so piknik a makankantaan kan matoktokaran so tamtambor kan gitgitara. ");
INSERT INTO ivb_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Dyi mo paya yaken a tinorohan so chimpo ko a nangiliw siras apōko ko kan siraw anak ko saya. Samna! Oltimo a makkwan nyaya a pinarin mo dyaken! ");
INSERT INTO ivb_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Myan panakabalin ko a mangdosa dyimo. Ki kahep do nakapaytayēnep ko, naychirin dyaken Dyosaw a daydayāwen ni āmang mo a dyi koymo a salsalyan. ");
INSERT INTO ivb_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Chapatak ko a komnaro ka, ta taywara danaw kangsah mo a maybidi do yanan āmang mo. Ki āngo ta tinakaw mo pa saw didyosen ko saw?” ");
INSERT INTO ivb_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Tominbay si Jakob dya a kāna, “On, mo Āmang, nayyayo ako, ata, mamo ako ngamin. Ta no myan do aktokto ko, ki angwan ibabāwi mo saw anak mo saya an matonngan mo a komaro ako. ");
INSERT INTO ivb_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","As no didyosen mo saw, taywaran yaken nanakaw? Do salapen dan kabagyan ta saya a sistigo ta, yay mo a chichwasen dyira mo saya bata mo do dya, as hapen mo, as kan dimanen taw nawri a tawo a pakadongswan mo so didyosen mo saya.” Komwan binata ni Jakob, ta chapatak naba a tinakaw ni Rakel didyosen saw ni Laban a āmang na. ");
INSERT INTO ivb_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Maynamot ta komwan inbahey ni Jakob, nangay si Laban do toldaw ni Jakob a naychichwas. Komwan pa a naychichwas do toldaw ni Lea kan siraw dadwaw a adipen a mababakes, ki abaw nachichwasan na didyosen daw. Do nakahbot naw do toldaw ni Lea, somindep do toldaw ni Rakel. ");
INSERT INTO ivb_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ki nasakbay nakahap ni Rakel so didyosen saw ni āmang na, as nakaitayo na sira do bolsaw no pasangaw no kamilyo na, as nakadisna na sya. Naychahel si Laban do tabo irahemaw no tolda naw, ki abaw naboya na. ");
INSERT INTO ivb_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Binata ni Rakel di āmang na a kāna, “Makasoli kaba, mo Āmang, do dyi kwaya paytēnekan, ta marodit akwaw.” Dawa, tinongtong ni Laban naychichwas, ki abaw naboya na dyirad didyosen na saw. ");
INSERT INTO ivb_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Do dawri, maynamot ta komwan napariparin, nakasoli dana si Jakob di Laban. Dawa, pinaydabdab nas katogangan na a kāna, “Aysa! Āngo marahet a pinarin ko dyimo ta dawa? Āngo nakagatosan ko tan lakatan mo yaken, mo Āmang? ");
INSERT INTO ivb_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Changori a tayoka danaw kapaychahel mo do tabo warawara ko, aryoriw naboya mo a dyira mo? An myan, ngay, pangayen mo do kasalasalapan taya tan maboya da no kakabagyan ta saya an sino kosto dyaten. ");
INSERT INTO ivb_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Dadwa poho a katawen a minyan ako dyimo a nagsirbi. Kinapya ko sa inaywanan karniro kan kalding mo saw tan abo nasday a anak dan pangganakan mo saw, kan abaw inichan ko aran asa maloko a binyay mo. ");
INSERT INTO ivb_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","An myan naw dimanen maranggas a animal a binyay mo, ki tod ko a binayādan. Inyangay kwaba inpaneknek dyimo a abo gatos ko. An myan natakaw aran maraw mana mahep, inpapīlit mo a bayādan ko. ");
INSERT INTO ivb_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Aro napadas ko a lidyat do kapangaywan ko siras binyay mo. An maraw, inanōsan ko iyaw kohat no araw. An mahep, inibtoran ko hanebneb. Abaw īmas no kapakaycheh ko, ta napohaw ako pa. ");
INSERT INTO ivb_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Komwan lidyat ko do dadwa poho a katawen a kayan ko dyimo. Nagikāro ako so asa poho kan apat a katawen tan makabahay ko saw dadwaya anak mo. Anem pa katawen a inaywanan ko saw binyay mo saw tan myan hahawen ko a pinakadyira ko dyirad orbon saw a tangdan ko yapod dyimo. Ki alit na pa pirmi mo a binalbalīwan pinakadyira ko a tangdan. ");
INSERT INTO ivb_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","An dyi na sinidongan yaken no Dyos ni simna Abraham a daydayāwen ni āmang ko a si Isaak, pinayam mo yaken a sibahabahas. Ki naboya ni Āpo Dyos an mango lidyat ko kan kagaget kwa naytarabako. As dawa, kahep pinaydabdab naymo do tayēnep mo.” ");
INSERT INTO ivb_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Do dawri, maynamot ta komwan inbahey ni Jakob, tominbay si Laban a kāna, “Tabo myan saya dya sichangori, ki dyaken saw nawri. Ta siraw baket mo saya, ki anak ko sabawri? Siraw pōtot mo, ki apōko ko. Tabo binyay mo, ki yapod binyay ko. Ki aran komwan, maparin kwaba a tod a ahapen saw anak kwaya a paybidi sichangori. Masaw dyirad apōko ko saya. ");
INSERT INTO ivb_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Sichangori, ki maganay an magtolag ta so bayo, as kan pawpohen taw batobato saya a pangpaneknek ta so dyi ta kapagbabāwi do nagtolagan taya.” ");
INSERT INTO ivb_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Do dawri, nanghap si Jakob so rakoh a bato, as pinaytēnek na. ");
INSERT INTO ivb_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Sinpangan na, inbahey na dyirad rarayay naw a tongtongen daw manghap so bato a pawpohen dad omdibonaw no pinatnek naw a rakoh a bato. Do katayoka daw, naychakakan sa do bitaw no inopo daw a bato. ");
INSERT INTO ivb_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Pinangaranan ni Laban nyaya nawpo a bato so Jegar-Sahadota do chirin na Arameo. As si Jakob, ki pinangaranan na so Galed do chirin na Hebreo. ");
INSERT INTO ivb_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Binata ni Laban di Jakob a kāna, “Magsirbiw nya a mangipaneknek so nagtolagan taya.” Nyaw naynamotan na a napangaranan nya nawpo a bato so Galed. ");
INSERT INTO ivb_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Binata pa ni Laban di Jakob a kāna, “Si Āpo pakono pirmi a omchidechideb dyaten do kapaybawa taya.” Dawa, nayngaran paw nawri a nawpo a bato so Mispa. ");
INSERT INTO ivb_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Tinongtong ni Laban naychirin a kāna, “An ranggasan mo saw pōtot ko saya a baket mo, mana an mangabahay ka pas matarek, aran dyi kwa maboya mana chapatak, naknakmen mo a chichiban na yaten no Dyos a iyaw makapaneknek so nagtolagan taya. ");
INSERT INTO ivb_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Cha dyaw inopo ko saya a bato kan pinatnek ko a rakoh a bato do payawan tayas changori. ");
INSERT INTO ivb_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Dawa, dyi ta pakono a kawayakan nyaya mohon ta a pamaneknek so tolag ta. Nya pakono akmay balat an myan marahet a panggep no katakatayisa dyaten. ");
INSERT INTO ivb_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Iyaw Dyos pakono a dinaydāyaw ni simna Abraham, Nahor, kan āmang daw mangokom dyaten an sino dyaten mangrarayaw so tolag taya.” Sinpangan na, nagkari si Jakob do salapen no Dyos a daydayāwen āmang na a si Isaak. ");
INSERT INTO ivb_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Do katayoka da nagtolag, sinosohan ni Jakob do dawri a tokon asaw a binyay a indāton na do Dyos. Sinpangan na, tinawagan na saw kakabagyan naw a machakan dya. Katayoka da, minisan dana sa daw. ");
INSERT INTO ivb_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Do kamabekasanaw, dinadek ni Laban saw apōko naw kan siraw dadwaw a anak na a mabakes, as binindisyonan na sa. Katayoka na, komnaro dana sa Laban daw a somnabat do tana da. ");
INSERT INTO ivb_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Do nakakaro daranaw da Laban, tinongtong da Jakob nayam, ki do kayam naw, naychihat a myan asa bonggoy no aanghil no Dyos a nangbayat sya. ");
INSERT INTO ivb_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Do nakaboyaw ni Jakob sira, binata na a kāna, “Ari dyaw kampo no Dyos kan siraw bōyot na saw!” Dawa, pinangaranan naw nyaya logar so Mahanaim. ");
INSERT INTO ivb_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Do katayoka no nawri, nanoboy si Jakob so tobotoboyen na saw a nanmanma kan iya a mangay di Esaw a ākang na do tana a Seir mana Edom. ");
INSERT INTO ivb_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Komwan inbilin na dyira: “Ibahey nyonchi di Esaw a ākang ko a kon nyo, ‘Batahenaw ni Jakob a adipen mo a nakayapo do nakakaro na di āmang nyo, ki nāw na a minyan di maraan nyos Laban do Mesopotamya a nanda sichangori. ");
INSERT INTO ivb_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Aro iyaw baka, asno, karniro, kalding, kan adipen na a mahahakay kan mababakes. Ipakatoneng na dyimo a ākang na, ta aram panchi a chāsi.’” ");
INSERT INTO ivb_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ki do dawri, do nakapaybidi daw no tinoboy na saw a yapod Esaw, binata da dya a kon da, “Nangay kami di Esaw a ākang mo, kan ari dana mangay a machibayat dyimo, kan myan nachirayay dya a apat a gasot a tawo.” ");
INSERT INTO ivb_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Do nakadngey naw sya, oltimo danaw kāmo ni Jakob kan nakamikamyaba. Dawa, pinaycharwa na saw tawo naw kan siraw karniro, kalding, baka, kan kamilyo na saw. ");
INSERT INTO ivb_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Komwan pinarin ni Jakob, ta iniktokto na a an gobaten Esaw asaya bonggoy, ayket, maparin a mayyayo paw asaw. ");
INSERT INTO ivb_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Do nakatayoka naw a napaycharwa sira, naydasal si Jakob. As nyaw inakdaw na a kāna, “O, Dyos a dinaydāyaw ni āpong kos Abraham kan daydayāwen ni āmang kos Isaak, adngeyen mo pa yaken. Mo Āpo, imo nangibahey dyaken a maybidi ako na do tana ni āmang ko kan siraw kakabagyan ko, as imonchiw mangbindisyon dyaken. ");
INSERT INTO ivb_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Abaw kaikaryan ko do tabo kadaw kan kāsi saya a inpaboya mo dyaken a adipen mo. Sarokod lang sinahabit ko do nakapamtang kwaw do oksongayan Jordan, ki naybidi ako a dadwa so bonggoy. ");
INSERT INTO ivb_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Dawa, machikakaāsi ako dyimo a isalākan mo yaken di Esaw a kakteh ko. Mamo ako dya, ta āngo nchan yangay na yamen a gobaten, as dimanen na yamen a tabo kontodo siraw mababakes saw kan adedekey da saw. ");
INSERT INTO ivb_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Naknakmen mo pakono iyaw kari mo dyaken a bindisyonan mo yaken kan parohen mo iyaw kapotōtan ko a akmas kāro no anay do kanayan a dya mabidangan.” ");
INSERT INTO ivb_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Do dawri, minisan pa sa Jakob do Mahanaim a logar. Do kamabekasan na, namidi dyirad binyay na saw, as nakapatawa na so isāgot na di Esaw a kakteh na. ");
INSERT INTO ivb_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Siraw nyaw pinidi na: dadwa gasot a mabinayi a kalding kan dadwa poho a maloko a kalding, dadwa gasot a mabinayi a karniro kan dadwa poho a maloko a karniro. ");
INSERT INTO ivb_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Myan paw pinidi na tatdo a poho a mabinayi a kamilyo a kontodo anak, apat a poho a mabinayi a baka kan asa poho a maloko a baka, dadwa poho mabinayi a asno kan asa poho a maloko a asno. ");
INSERT INTO ivb_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Kāda kita do pinatawa na saw a binyay, ki inpaaywan na dyirad adipen na saw, Sinpangan na, binata na dyirad adipen na saw a kāna, “Manma kamo na ah, kan magsasarono kamo, ki mayayateng kamo tan dyi kamo a maysin-aadas.” ");
INSERT INTO ivb_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Binilin naw adipen naw a manma a mangay a kāna, “Anchan mabayat naymo ni Esaw a ākang ko, as iyahes na, ‘Sino āpo mo? Dino ngayan mo, as kan sino akin dyira siras nyaya a binyay a toyohen mo?’ ");
INSERT INTO ivb_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","nyanchiw ibahey mo dya a kon mo, ‘Dyira ni Jakob a adipen mo siraw nyaya binyay. Inpaw-it na a sāgot dyimo mo Āpo Esaw. Ari saw a manawnawdyi kan yamen.’” ");
INSERT INTO ivb_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Masaw inbilin na dyirad chadadwa, chatatdo, kan tabo somarono saw a adipen a manoyo siras kadwan saw a binyay a sāgot nad Esaw. Binata na dyira a kāna, “Anchan mabayat nyo si Esaw, malit ibahey nyo dya ah. ");
INSERT INTO ivb_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Kawayakan nyo aba ibahey a, ‘Ari saw a manawnawdyi kan yamen, sa Jakob a adipen mo.’” Pinarin ni Jakob nyaya, ta iniktokto na a, “Mahwahok ngata si Esaw do sāgot ko saya a pinanma ko. Ta anchan machisalap ako dya, rawaten nanchi ngata yaken.” ");
INSERT INTO ivb_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Dawa, pinanma narana sa a inpapatoyo sāgot na saw a binyay. As iya, ki minisan pa so asa kahep do nagkampwan daw. ");
INSERT INTO ivb_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Do dawri a ahep, naybangon si Jakob, as nakahap na siras dadwaw a baket na kontodo saw dadwaw a mababakes a adipen na kan siraw asa pohwaw kan asa a pōtot na, as nakapamtang na sira do oksongaw a Habok. ");
INSERT INTO ivb_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Pinanma na sa pinabtang, as nakapasarono nas tabo kadwan saw a rarayay na, binyay na, kan warawara da saw. ");
INSERT INTO ivb_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Do katayoka no nawri, namtang abas Jakob, dawa, nabidin a naychatanyi do kabtangaw no oksong. Do dawri, naychihat a myan mahakay a nangay a nachigabbo dya a mandad kakalo narana a maysesedang. ");
INSERT INTO ivb_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ki do kadlawaw sya no mahakayaw a dyi na mapenpen si Jakob, kinorimes naw atangaw ni Jakob. As dawa, nayhabchis atang naw do nakapachigabbo naw do mahakayaw. ");
INSERT INTO ivb_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Binata no mahakayaw di Jakob, “Dā pa! Aryan mo na yaken, ta maysesedang danaya!” Ki tominbay si Jakob dya a kāna, “Ay! Aryan kwabaymo, an dyi mo yaken a bindisyonan!” ");
INSERT INTO ivb_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","“Āngo ngaran mo?” inyahes no mahakayaw. “Jakob,” initbay na. ");
INSERT INTO ivb_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Do dawri, binata no mahakayaw, “Sichangori, Jakob pabaw ngaran mo, an dya Israel, ta nachilaban kad Dyos kan kapayngay mo sa tawo, kan nagballigi ka.” ");
INSERT INTO ivb_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Inbahey ni Jakob a kāna, “Imom Āpo, ibahey mo pa dyaken an sino ka kan dino nakayapwan mo.” Ki tominbay iyaw mahakayaw, “Āngo ta chakey mwa mapatakan?” Do dawri, tod narana binindisyonan, as nakakaro na. ");
INSERT INTO ivb_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Binatan Jakob do aktokto na, “Ay, nachisalap ako do Dyos. Mapya, ata, aryak paya mabyay!” Dawa, pinangaranan ni Jakob nawri a logar so Penyel. ");
INSERT INTO ivb_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Domnada danaw araw do kakaro ni Jakob do Penyel, ki nakaskaspi a nayam maynamot do nayhabchisaw a atang na. ");
INSERT INTO ivb_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Nyaw siniknanan na a dāgen dan kapotōtan saw ni Israel mitchan so oyat a myan do atang no binyay a partyen da maynamot ta nyaw kinorimesaw no mahakayaw di Jakob do nakapaggabo daw. ");
INSERT INTO ivb_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Do kakaro naranaw ni Jakob do Penyel do napabtangan naw siras pamilya naw, naboya na a tominyitinyi sa Esaw a kakteh na a kontodo apat a gasot a rarayay na. As dawa, bininglay na saw pōtot na saw di Lea kan Rakel kan siraw dadwaw a adipen na a mabakes. ");
INSERT INTO ivb_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Pinanma na saw dadwaw a mababakes a adipen kontodo anak da saw, as nakasarono ni Lea kan anak na saw. Kapanawdyan na, ki si Rakel kan Jose a anak na. ");
INSERT INTO ivb_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ki si Jakob, iyaw kapanoman a nangay a minbayat di Esaw. Naypapito a nagrokob do tana do kapaypasngen naw do yananaw ni ākang na. ");
INSERT INTO ivb_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ki do nakaboyaw sya ni Esaw, nakapayapayayo na a nangay a minbayat sya. Kinepkep kan dinadek ni Esaw ādi naw. Tomnanyis sa a dadwa. ");
INSERT INTO ivb_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Do nakabangon naw ni Esaw so oho na, naboya na saw mababakes saw kan siraw adedekeyaw a minonot di Jakob. As dawa, inyahes na di Jakob a kāna “Sino saw nyaya a tawo a nachirayay dyimo?” Ki tominbay si Jakob dya a kāna, “Ay, siraw nya adedekey, ki pōtot ko sa a intoroh no Dyos dyaken a maynamot do kāsi na.” ");
INSERT INTO ivb_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Naypasngen saw dadwaw a adipen kontodo saw anak da saw, as nakapagrokob da a nangipaboya so kapagdayaw da di Esaw. ");
INSERT INTO ivb_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Somnarono, naypasngen sa Lea kan anak na saw, as nakapagrokob da. Nanawdyi sa Jose kan si Rakel a nagrokob a nangipaboya so kapagdayaw da. ");
INSERT INTO ivb_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Sinpangan na, inyahes ni Esaw dya a kāna, “Aysa! Āngo chakey a batahen no bonggoy saw no binyay a pinanma mo a nabayat namen?” Ki nyaw inbahey ni Jakob a kāna, “Na dyira mwaw, aram pa yaken a marawat mo Āpo.” ");
INSERT INTO ivb_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ki initbay ni Esaw a kāna, “Namna, manawob dana saw myanaw dyaken, mo Ādi. Hapen mo na, ta dyira mo na sa.” ");
INSERT INTO ivb_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","“Engga ah!” kāna ni Jakob. “An chasoyot mo na yaken, rawaten mo saw panangpet kwaya dyimo. Ta do nakaboya kos kasoyot mo do ropa mo, ki akma ko nayaw naboyaw parabor no Dyos dyaken do siaadawaya nakarawat mo dyaken. ");
INSERT INTO ivb_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Dawa, rawaten mo pakono panangpet ko saya, ta rakoh kāsi dyaken no Dyos, as kan apabaw pagkorāngan kod machita ko.” Inibhes aba ni Jakob mandan rinawat ni Esaw iyaw sāgot na dya. ");
INSERT INTO ivb_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Do nakatayoka dan may-ākangaw a nagsarita, binata ni Esaw a kāna, “Na, magrobwat kamo na, ata, mayrarayay ta na, ta yaken soro nyo.” ");
INSERT INTO ivb_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ki do dawri, tominbay si Jakob dya a kāna, “Naon, mo Āpo, ki chapatak mo a mabalabalay kami a mayam, ta makakapsot saw adedekey kwaya. Asa pa, mabakel ako an madiman orbon sayan karniro kan baka an makalokalo sa mayam a aran do asa lang a karaw. ");
INSERT INTO ivb_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Dawa, maganaganay danāno an imo manma, mo Āpo? Mononot kami na sigon do kalisto dan binyay kwaya kan siraw anak ko saya. Rapiten namen dananchi imo, mo Āpo, do Edom.” ");
INSERT INTO ivb_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ki binata ni Esaw a kāna, “Na, an komwan, bidinen ko saw kadwan saya a rarayay ko a machirayay dyinyo.” Ki inbahey ni Jakob, “Aran engga dana. Manawob dana dyaken iyaw kāsi mwaya dyaken.” ");
INSERT INTO ivb_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Dawa, do dawri a araw, komnaro sa Esaw a naybidi do Edom. ");
INSERT INTO ivb_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ki sa Jakob, nangay sa a nagkampo do Sokkot. Namarin daw so bahay a panarasan na kan sapaw da no binyay na saw. Nyaw paynamotan na a nayngaran so Sokkot, ta no chakey na batahen, ki sapaw. ");
INSERT INTO ivb_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Naynam saba do Sokkot, as nakatongtong da a nayam. Do dawri, nakarapit sa Jakob a dya naan-ano a yapod Mesopotamya a nandad idi a Sikem do tanaw a Kanaan. Nagtolda sa do mangket do dāya do dawri a idi. ");
INSERT INTO ivb_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Sinpangan na, ginatang naw nawri a tana a nagtoldaan da. Binayādan nas asa gasot a plata a pirak dyirad kapotōtan saw ni Hamor a āmang ni Sikem. ");
INSERT INTO ivb_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Namarin sa Jakob so asa a pangidātonan do Dyos, as pinangaranan na so El-Elohe-Israel. ");
INSERT INTO ivb_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Do asa karaw, nangay a nagpasyar si Dina a balāsang da Jakob kan Lea dyirad babbalāsang saw a omyan do dawri a tana a Kanaan. ");
INSERT INTO ivb_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Do kayan naw a magpasyar ni Dina, ki naboya ni Sikem a baro ni Hamor a asa magtoray do dawri a tana no Hebeo saw a tawo. Do dawri, minanchaan ni Sikem si Dina, ta rinakep na a namarinan so chakey na. ");
INSERT INTO ivb_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Do nakatayoka naw, tomnobo kapagayat ni Sikem di Dina a pōtot ni Jakob, as kan nadidiw ni Sikem a myan danaw ayat na dya. Dawa, naychirin di Dina so makahwahok. ");
INSERT INTO ivb_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Sinpangan na, inbahey ni Sikem di āmang na a kāna, “Āmang, ipamosposan mo pa an maypāngo a makabahay ko nawri a mabakes.” ");
INSERT INTO ivb_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Do dawri, natonngan ni Jakob iyaw pinarinaw ni Sikem di Dina. Ki maynamot ta myan pa saw pōtot naw a mahahakay do pagpaspastoran daw so binyay da, naylilyak aba mandad nakapaybidi da. ");
INSERT INTO ivb_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Sinpangan na, nangay sa Hamor kan Sikem a baro na a nachisarita di Jakob. ");
INSERT INTO ivb_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Do kayan daw a magsasarita, kosto sa mawaraw pōtot saw ni Jakob a mahahakay a yapo do nagpaaraban daw siras binyay da saw. Ki nableg sa do nakadngey daw so pinarinaw ni Sikem do kakteh daw. Taywara danaw kasoli da di Sikem, ta inasnesnekan naw tabo tawotawo no Israel do nakalapos nas dāyaw ni Dina, as kan iyaw kaparin a akma syay, ki rebbeng naba maparin komwan. ");
INSERT INTO ivb_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ki aran komwan, inpapati ni Hamor a kāna, “Oyod nas kadaw ni Sikem a anak ko so balāsang mwaw. Dawa, chāsi nyo yaken, ta ipakabahay nyo dya. ");
INSERT INTO ivb_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Asa pa, maganay āno an maychakabahay saw anak ta saya? Itoroh nyo saw anak nyo saw a mababakes dyamen a kabahay namen, as kan kabahayen nyo saw babbalāsang namen saw. ");
INSERT INTO ivb_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ta an komwan, maparin nyo omyan dyamen do tana namenaya, ta baywan namen abaynyo a omyan dya. On, omyan kamo dya. Magnigosyo kamo dya, kan gomātang kamo dya so bokod nyo a tana.” ");
INSERT INTO ivb_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sinpangan na, binata ni Sikem di āmang ni Dina kan siraw kakakteh na saw a mahahakay a kāna, “An chāsi nyo yaken kan itoroh nyo nyaya balāsang a kabahay ko, aran āngo akdawen nyo, ki itoroh ko. ");
INSERT INTO ivb_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ibahey nyo an papiraw pagbayad ko kan rigalo ko dya, ta itoroh kwa aran āngo iyaw chakey nyo dyaken. Basta ipakabahay nyo dyaken si Dina.” ");
INSERT INTO ivb_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Maynamot do pinarinaw ni Sikem a marahet di Dina a kakteh da, myan sikap dan pōtotaw ni Jakob a mahahakay do initbay daw dyirad may-āmangaw. ");
INSERT INTO ivb_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Binata da dyirad may-āmangaw a kon da, “Mapalobosan aba a machikabahay kakteh namenaya do dya nakogit, ta pakasnesnekan namen nawri an parinen namen. ");
INSERT INTO ivb_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Makey kami an basta mayparin kamo a akma dyamen. Ipakogit nyo sa tabo mahahakay dyinyo. ");
INSERT INTO ivb_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","An parinen nyo nyaya aket, maparin taw maychakabahay. Omyan kami pa dyinyo, kan machichasa kami na dyinyo. ");
INSERT INTO ivb_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","An maskeh kamo a magpakogit aket, hapen namen si Dina, as kan komaro kami do dya logar.” ");
INSERT INTO ivb_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Do nakadngey sya da Hamor kan anak nas Sikem, naktokto da a akmay maganay dyiraw inakdaw daw. ");
INSERT INTO ivb_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Naybabalay aba si Sikem a mangtongpal so tolag daw a maynamot do kapagkogit, ta oyod nas kadaw si Dina. Si Sikem, ki iyaw mabigbigbig do tabo kakakteh na do bahay ni āmang na. ");
INSERT INTO ivb_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Do dawri, nangay sa Hamor kan anak nas Sikem do rowanganaw no idi daw do pagmimitingan konsiho, as nakapachisarita da dyirad kapayngay da saw a omidi do dawri a idi. ");
INSERT INTO ivb_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Nyaw binata no may-āmangaw dyira a kon da, “Makey sa machisit nyaya tawotawo dyamen. Dawa, rawaten ta sa a omidi dya, kan baywan ta saba a magnigosyo so chakey da, ta marahawaw tana taya. As maparin ta pa kabahayen anak da sa, kan komwan maparin da kabahayen anak ta sa. ");
INSERT INTO ivb_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ki chakey daban nyaya tawo omyan dya kan machichasa dyaten, an dya makogit tabo mahahakay dya a akma dyira. Nawriw paglintegan da. ");
INSERT INTO ivb_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Syimpri dyira ta na sanchiw binyay da saw kan tabo a warawara da. Oyod abawri? Dawa, machitonos ta a magpakogit, yaten a tabo a mahahakay tan omyan sa dyaten.” ");
INSERT INTO ivb_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Do dawri, nakey sa tabo mahahakayaw a myan daw do rowanganaw no idyaw do inbahey daw da Hamor kan Sikem. As dawa, do dawri a idi, nagkogit sa tabo mahahakay. ");
INSERT INTO ivb_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Do katayokaw no tatdo a karaw, ki minrakamah danaw kogit daw. Do dawri, siraw mismo kaktehaw ni Dina a sa Simeon kan Lebi a anak ni Jakob, ki sililimed sa somindep do idyaw. Sinpangan na, inasot daw bahayang daw, as kan diniman da tabo mahahakayaw daw. ");
INSERT INTO ivb_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Tinabtaban da pa sa a diniman sa Hamor kan Sikem, as nakahap da si Dina do bahayaw ni Sikem, as nakakaro da. ");
INSERT INTO ivb_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Katayoka da Simeon kan Lebi a nangdiman siras mahahakayaw daw, nagsamsam saw tabo pōtotaw ni Jakob a mahahakay so warawara do dawri a idi tan mabahes daw nakararayawaw no dāyaw ni Dina a kakteh da. ");
INSERT INTO ivb_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Inhap da tabo karniro, baka, kan asno. Inhap da paw tabo myan saw do irahem no idi kan do hakawan da saw. ");
INSERT INTO ivb_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Inkaro da pa sa tabo kinabaknang daw. Inkaro da saw babbaket kan adedekey da saw, as somindep sa do kāda bahay a nangsamsam so tabo chakey da a warawara. ");
INSERT INTO ivb_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Do nakatonengaw ni Jakob so pinarin daw no anak na saw, binata na di Simeon kan Lebi a kāna, “Taywara kamwaya! Inyo pakayapwan riribok kwaya. Changori, maynamot do pinarin nyowaw, ipsok darana yaken no tawotawo saya a Kananeo kan siraw Pereseo saya a omyan dya. Dēkey saw tawo ko saya, as an payrarapahen da tabo tawo da, as gobaten da yaken, syirto a madiman ako kan intīro a pamilya ko.” ");
INSERT INTO ivb_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ki tominbay sa a kon da, “On, mo Āmang, ki maparin namen aba a ibidang kakteh namenaya a akmay asa mapagran a mabakes.” ");
INSERT INTO ivb_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Sinpangan na, binata no Dyos di Jakob a kāna, “Ngay, may ka do Betel kan omyan ka daw. Mamarin ka daw so pangidātonan mo a pagdaydayāwan mo dyaken, ta yaken iyaw Dyosaw a napaboya dyimo do nakapayayo mwaw a machibawa di Esaw a kakteh mo.” ");
INSERT INTO ivb_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Dawa, binata ni Jakob dyirad pamilya na saw kan siraw nachirayayaw dya a kāna, “Ipoha nyo a tabo iyaw myan dyinyo a didyosen a inyonot nyo. Mariyos kamo a pakaboyan so kadalos no aktokto nyo, as kan magsokat kamo a pakaboyan so kapagbaliw no aktokto nyo. ");
INSERT INTO ivb_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Magrobwat ta, ta may ta do Betel. Mamarin akonchi daw so pangidātonan do Dyos, iyaw Dyosaw a somnidong dyaken do araw a kalidyat ko kan nangrarayay dyaken do tabo a kwanan ko.” ");
INSERT INTO ivb_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Dawa, intoroh da tabo di Jakob iyaw didyosen da saw kan siraw arītos da saw. Inkadi ni Jakob nya saya do atngeh no asa kayo a mayngaran so logo a masngen do Sikem. ");
INSERT INTO ivb_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Sinpangan na, nayam sa Jakob. Ki do kayam daw, abaw minlakat sira, ta inamomo sa ni Āpo tawotawo saw do masngen saw a idiidi. ");
INSERT INTO ivb_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Tinongtong da Jakob nayam a nandad nakapakarapit da kontodo tabo tawotawo na saw do idi a Los mana Betel do tanaw a Kanaan. ");
INSERT INTO ivb_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Namarin si Jakob so pangidātonan na do Dyos, as pinangaranan naw tanaw daw so “Dyos no Betel” maynamot ta dawriw napaboyan no Dyos dya do nakarahan do nakaditchan naw si Esaw a kakteh na. ");
INSERT INTO ivb_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Do dawri, nadiman si Debora, iyaw nangtagtagibi di Rebeka. Intabon da do masngen do Betel do atngehaw no kayo a logo. Dawa, nayngaran nawri a logar so “Logo a Nananyisan.” ");
INSERT INTO ivb_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Minirwa napaboya si Āpo Dyos di Jakob, kan binindisyonan na do nyaya kapaybidi na a yapod Mesopatamya. ");
INSERT INTO ivb_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Nyaw binata no Dyos dya a kāna, “Jakob ngaran mo, ki sichangori, Jakob paba, ta mayngaran ka na so Israel.” Dawa, si Āpo Dyos a mismo napangaran sya so Israel. ");
INSERT INTO ivb_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Binata pa ni Āpo Dyos dya a kāna, “Yaken Dyos a Manakabalin do tabo. Mayparo kamo tan mayparonchiw kapotōtan nyo. Yapod dyira, ki tombod aro a nasnasyon, as kan myan sanchiw yapod kapotōtan mo a mayparin a aāri. ");
INSERT INTO ivb_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","As iyaw tanaw a intoroh ko kaychowa di simna āpong mo a si Abraham kan di āmang mo a si Isaak, ki itoroh ko dyimo, as itoroh ko panchi dyirad kapotōtan mo saw a makarwan mo.” ");
INSERT INTO ivb_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Katayoka no Dyos a naychirin di Jakob, komnaro dana. ");
INSERT INTO ivb_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","As si Jakob, ki napatnek so rakoh a bato a pakanaknakman na so logaraw a naychirinan dya ni Āpo. Pinadwan naw batwaw so palek a dāton na do Dyos. Pinadwan na pas lana no olibo, ta nawriw mapayparin so batwaw a pagdaydayāwan na do Dyos. ");
INSERT INTO ivb_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Dawa, pinangaranan naw nawri a logar so Betel. ");
INSERT INTO ivb_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Sinpangan na, komnaro sa Jakob do Betel, as nakatongtong da mayam. Do dyi da pa kapanyino so idi a Eprata, narapit danaw araw no kapaymanganak ni Rakel, kan oltimo a malidyatan do kapagpasikal naw. ");
INSERT INTO ivb_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ki do oltimwaw a kalidyat no kapagpasikal na, binata no partiraw di Rakel a kāna, “Mamo kaba, mo Rakel, ta mahakay dana mirwaw anak mo.” ");
INSERT INTO ivb_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ki do kapaybiybitos danaw no anges ni Rakel, sakbay a nadiman, pinangaranan naw anak naw so Benoni. Ki Benhamin iyaw inpangaran ni Jakob. ");
INSERT INTO ivb_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Do dawri, nadiman si Rakel, as intabon da do bīt no rarahan a mangay do Eprata mana Betlehem. ");
INSERT INTO ivb_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Pinatnek ni Jakob do yananaw no tanem naw asa rakoh a bato a pakanaknakman na. As manda sichangori, ki ari paw pakaboyan so yanan tanemaw ni Rakel. ");
INSERT INTO ivb_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Sinpangan na, tinongtong daw nayam da Jakob a mayngaran dana so Israel. Nakarapit sa do bīt nad Migdal-eder mana pagwanawanan so karniro, kan nagtolda sa daw. ");
INSERT INTO ivb_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Do kayan da Jakob mana Israel do dawri a tana, nangay si Ruben a matoneng a anak na a nachoknod di Bilha, iyaw minabakesaw ni āmang na. Ki natonngan ni Israel nawri. Myan asa poho kan dadwa anak ni Jakob a mahahakay. ");
INSERT INTO ivb_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Siraw nyaw anak da Jakob kan Lea: si Ruben, iyaw matoneng, si Simeon, Lebi, Joda, Isakar, kan Sabolon. ");
INSERT INTO ivb_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Sa Jose kan Benhamin, ki anak da Jakob kan Rakel. ");
INSERT INTO ivb_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Sa Dan kan Neptali, ki iyaw anak da Jakob kan Bilha a adipen ni Rakel. ");
INSERT INTO ivb_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Siraw nyaw anak da kan Silpa a adipen ni Lea: sa Gad kan Aser. Naiyanak saw nyaya a pōtot ni Jakob do Mesopotamya. ");
INSERT INTO ivb_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Do nakakaro da do Migdal-eder, tinongtong da Jakob nangay do Mamre a masngen do idi no Kiriat Arba mana Hebron. Dawriw yanan ni āmang na a Isaak, kan dawri paw yanan ni simna āpong na a Abraham do kaychowa. ");
INSERT INTO ivb_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Do dawri, narapit ni Isaak iyaw tawen na a asa gasot kan wawaho a poho. ");
INSERT INTO ivb_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Naybitos byay na, kan nachirapa dana dyirad aāpong na saw. Taywara danaw kamalkem ni Isaak do nakadiman na. Intabon da Esaw kan Jakob a pōtot na. ");
INSERT INTO ivb_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Nyaw pakasaritaan dan kapotōtan saw ni Esaw. No matarek a ngaran na, ki Edom. ");
INSERT INTO ivb_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Nangabahay si Esaw so tatdo a mababakes a taga Kanaan. Siraw baket na saw, ki si Ada a pōtot ni Elon a Heteo a tawo kan si Oholibama a pōtot ni Ana a pōtot ni Sibeon a Hebeo a tawo, ");
INSERT INTO ivb_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","as kan si Basemat a ādi ni Nebayot no mahakay a pōtot ni Ismael. ");
INSERT INTO ivb_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Si Elipas, ki anak ni Esaw kan Ada. As si Rewel, ki inyanak ni Basemat. ");
INSERT INTO ivb_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","As inyanak ni Oholibama sa Jeos, Jaalam, kan Kora. Siraw nyaw pōtot ni Esaw a nayanak do Kanaan. ");
INSERT INTO ivb_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Do dawri, inhap ni Esaw siraw babbaket na saw, pōtot na saw, tabo rarayay na sa do bahay na, tabo binyay na saw, as kan tabo a warawara na a inakpeh na do Kanaan, as nachisyay di Jakob a ādi na, kan nangay do matarek a tana. ");
INSERT INTO ivb_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","On, komnaro sa Esaw daw, ta malidyatan sa mayrapa do asa yanan do taywara a kāro no binyay da Esaw kan Jakob, as kan manawob pabaw nawri a tana a pamakanan da siras binyay da saw. ");
INSERT INTO ivb_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Dawa, nangay si Esaw mana Edom do katokotokonanaw do Seir. ");
INSERT INTO ivb_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Nyaw pakasaritaan dan kapotōtan saw ni Esaw a kapoonan dan Edomita saw a tawotawo a minyan do katokotokonanaw do Seir. ");
INSERT INTO ivb_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Siraw nyaw pōtot a mahahakay ni Esaw: si Elipas a anak ni Ada a baket ni Esaw, kan si Rewel a anak ni Basemat a baket pa ni Esaw. ");
INSERT INTO ivb_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Myan saw dadima mahahakay a pōtot ni Elipas: sa Teman, Omar, Sepo, Gatam, kan Kenas. ");
INSERT INTO ivb_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Myan paw pōtot ni Elipas a mahakay a mayngaran so Amalek di Timna a minabakes na. Siraw nyaw apōko da mahahakay da Ada kan Esaw. ");
INSERT INTO ivb_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Myan saw apat a mahahakay a pōtot ni Rewel, ki sa Nahat, Sera, Samma, kan Missa. Siraw nyaw apōko a mahahakay da Basemat kan Esaw. ");
INSERT INTO ivb_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Myan saw tatdo a anak a mahahakay da Esaw kan Oholibama a sa Jeos, Jaalam, kan Kora. Si Oholibama, ki pōtot ni Ana a pōtot ni Sibeon. ");
INSERT INTO ivb_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Siraw nyaw nangipangpangolo a yapod mahahakay a kapotōtan ni Esaw: Si Elipas, matoneng a mahakay a pōtot ni Esaw, kan siraw nyaw mahahakay a pangpangolo a pōtot na a sa Teman, Omar, Sepo, Kenas, ");
INSERT INTO ivb_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatam, kan si Amalek. Siraw nyaw pangpangolo a pōtot ni Elipas a minyan do Edom, kan si Ada āpong da a baket. ");
INSERT INTO ivb_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Myan pa saw mahahakay a pōtot ni Rewel a pōtot ni Esaw, kan nayparin kāda asa dyira a pangolo dan gropo da. Sira, ki sa Nahat, Sera, Samma, kan Missa. Siraw nyaw pangpangolo a pōtot ni Rewel a minyan do Edom, kan si Basemat āpong da a baket. ");
INSERT INTO ivb_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Myan paw pangpangolo da a yapod anak da Esaw kan baket na a si Oholibama a pōtot ni Ana. Siraw nyaya a pangpangolo, ki sa Jeos, Jaalam, kan Kora. ");
INSERT INTO ivb_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Siraw nya tabo pangpangolo do kapotōtan ni Esaw mana Edom no matarek a ngaran na. ");
INSERT INTO ivb_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Do dawri a tana ni Edom, myan saw tawotawo a sigod a omyan daw a mayngaran so Horeo a kapotōtan ni Seir. No mahahakay a pōtot ni Seir, ki sa Lotan, Sobal, Sibeon, Ana, ");
INSERT INTO ivb_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Eser, kan Disan. Siraw pangpangolo dan Horeo a tawotawo, kan minyan sa do Edom. ");
INSERT INTO ivb_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Siraw dadwa a mahahakay a pōtot ni Lotan, ki sa Hori kan Heman, as iyaw kakteh a mabakes ni Lotan, ki si Timna. ");
INSERT INTO ivb_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Siraw mahahakay a pōtot ni Sobal, ki sa Alban, Manahat, Ebal, Sepo, kan Onam. ");
INSERT INTO ivb_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Myan saw dadwa a mahahakay a pōtot ni Sibeon, ki sa Aya kan Ana. Si Ana, iyaw nakaboya so makohat a akbod do let-ang do kaaywan naw siras asno saw ni āmang na. ");
INSERT INTO ivb_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Si Ana, myan dadwa pōtot na. Iyaw mahakay, ki si Dison. Iyaw mabakes, ki si Oholibama. ");
INSERT INTO ivb_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Siraw mahahakay a pōtot ni Dison, ki sa Hemdan, Esban, Itran, kan Keran. ");
INSERT INTO ivb_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Siraw mahahakay a pōtot ni Eser, ki sa Bilhan, Saaban, kan Akan. ");
INSERT INTO ivb_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Siraw mahahakay a pōtot ni Disan, ki sa Os kan Aran. ");
INSERT INTO ivb_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Siraw nyaw pangpangolo dan Horeo saw a tawotawo do Edom: sa Lotan, Sobal, Sibeon, Ana, ");
INSERT INTO ivb_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dison, Eser, kan Disan. Siraw nyaw pangpangolo dan kāda gropo no Horeo saw a omnidi do tana a Seir mana Edom. ");
INSERT INTO ivb_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Myan saw aāri do Edom, kan nagsasarono sa a nagtoray daw sakbay a myan āri dan Israelita saw. ");
INSERT INTO ivb_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","No nanoma a āri da, ki si Bela a mahakay a pōtot ni Beor a taga idi a Dinhaba. ");
INSERT INTO ivb_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Do nakadiman ni Bela, nachitadi si Jobab a mahakay a pōtot ni Sera a taga Bosra. ");
INSERT INTO ivb_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Do nakadiman ni Jobab, nachitadi si Hosam a yapod tana no Teman. ");
INSERT INTO ivb_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Do nakadiman ni Hosam, nachitadi si Hadad a mahakay a pōtot ni Bedad kan taga Abit. Inābak na saw Midyanita a tawo do asa gobat do tana Moab. ");
INSERT INTO ivb_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Do nakadiman ni Hadad, nachitadi si Samla a yapod Masrekka. ");
INSERT INTO ivb_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Do nakadiman ni Samla, nachitadi si Saul a yapod Rehobot do bīt no oksong a Oprates. ");
INSERT INTO ivb_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Do nakadiman ni Saul, nachitadi si Baal Hanan a mahakay a pōtot ni Akbor. ");
INSERT INTO ivb_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Do nakadiman ni Baal Hanan, nachitadi si Hadad a taga Paw. No ngaran no baket na, ki Mehetabel a anak ni Matred a anak a mabakes ni Mesaab. ");
INSERT INTO ivb_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","No ngarangaran dan pangolo a kapotōtan Esaw sigon do kāda tribo da kan yanan da, ki sa Timna, Alba, Jetet, ");
INSERT INTO ivb_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","42","Oholibama, Ela, Pinon, Kenas, Teman, Mibsar, ");
INSERT INTO ivb_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel, kan Iram. Tabo saw nya, ki pangpangolo dan Edomita a tawotawo a kapotōtan saw ni Esaw sigon do gropo kan yanan da. ");
INSERT INTO ivb_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Minyan sa Jakob do tana a Kanaan, iyaw tanaw a niyanan āmang na. ");
INSERT INTO ivb_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Nyaw pakasaritaan pamilya ni Jakob. Do naypisa do kapagtawen ni Jose a anak na so asa poho kan papito, minonot dyirad aākang na saw a mahahakay a siraw anakaw ni Bilha kan Silpa a minabakes ni āmang na a somidong a magpastor siras karniro kan kalding da sa. Myan nadlaw na marahet a kaparin dan kakakteh na saya. Dawa, do nakapaybidi naw di āmang na, inbahey na dya. ");
INSERT INTO ivb_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ki mangamangay a adayo adaw ni Jakob di Jose kan siraw kadwanaw a anak na maynamot ta nayanak do kamalkem naranaw. Pinamarin na si Jose so mapintas a laylay a mayid a matatarek so kita kan manaro so tatchay, as kan intoroh na di Jose. ");
INSERT INTO ivb_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Do kaboya daw sya no kakakteh na saw a rakorakoh iyaw adaw ni Jakob di Jose kan sira, inipsok das Jose, as kan aba polos maganay a kapaychirin da dya. ");
INSERT INTO ivb_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Myan asa ahep a naytayēnep si Jose. Kamabekasan na, inbahey naw nyaya dyirad kakakteh na saw, ki naypangay nakaipsok da sya. ");
INSERT INTO ivb_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Binata ni Jose dyira a kāna, “Inyo a aākang ko, adngeyen nyo pa yaken, ta ibahey ko tayēnep kwaw dyinyo. ");
INSERT INTO ivb_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Myan taw a tabo do hakawan a mamosot so trigo. Ki naychihataw a naytēnek pinosot kwaw. Do dawri, dinibon daw no pinosot nyowaw, as nakapaydogod da dya.” ");
INSERT INTO ivb_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ki binata da no kakakteh na saw, “Āngo chakey mwa batahen? Imonchoriw āri a mangitoray dyamen, as kan yamen anchoriw adipen mo ah? Pi!” Naypaypangay nakaipsok da sya maynamot do tayēnep naw a inbahey na dyira. ");
INSERT INTO ivb_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Sinpangan na, minirwa dana naytaytayēnep si Jose, as inbahey narana dyirad kakakteh naw. Binata na dyira a kāna, “Inyom ākang ko, adngeyen nyo pa yaken, ta ari danaw tayēnep ko. Naboya kwaw araw, bohan, kan asa poho kan asa a bitohen a maydoydogod sa dyaken.” ");
INSERT INTO ivb_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ki do kaistorya naw syay di āmang na kan kakakteh na saw, nakadabdab di āmang na. Binata ni āmang na dya a kāna, “Āngo chakey mwa batahen do dawri a tayēnep mo? Ay samna! Yamenori kāda ānang mo kan siraw kakakteh mo saya, ki maydogod kaminchi dyimo?” ");
INSERT INTO ivb_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Taywara a ipsok dan kakakteh na saw maynamot ta chahoho da. As si āmang na, ki tinongtong na iniktokto an āngo chakey na batahen no tayēnep naw. ");
INSERT INTO ivb_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Do naypisa, nangay saw kakaktehaw ni Jose do masngenaw do idi a Sikem, ta dawriw paydisan da a pangipastoran siras karniro saw kan kalding saw ni āmang da. ");
INSERT INTO ivb_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Sinpangan na, binata ni Jakob di Jose a kāna, “Barok, nangay saw kakakteh mo saw do masngenaw do idi a Sikem a mangipaspastor so karniro ta saw daw. Ngay, toboyen koymo a mangay do yanan daw ah.” Ki tominbay si Jose, “On mo Āmang, nakasagāna ako a mangay.” ");
INSERT INTO ivb_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Tinongtong ni āmang na a kāna, “Yangay mo sa chiban an maganay kayayan da ākang mo, as kan siraw binyay saw. Katayoka mo a manyideb sira, maybidi ka, ta ibahey monchi dyaken an maypāngo sa daw.” Dawa, tinoboy ni āmang na si Jose a nangay a yapod Payahosonganaw a Hebron a yanan da nandad nakapakarapit na do Sikem. ");
INSERT INTO ivb_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Do kayan naw a midibidi do pagpaaraban daw a masngen do Sikem, myan mahakay a nakaboya sya, ki inyahes na dya a kāna, “Āngo chichwasen mo?” ");
INSERT INTO ivb_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ki tominbay si Jose dya a kāna, “Chichwasen ko saw kakakteh ko saw. An chapatak mo an dino yanan da a mangipaspastor so binyay namen, ibahey mo pa dyaken?” ");
INSERT INTO ivb_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ki inbahey no mahakayaw a kāna, “Ay on, komnaro dana saw dya. Nadngey kwaw a kominwan sa do Dotan.” Dawa, inonotan sa ni Jose a kominwan do Dotan, as dawriw nakaboyan na sira. ");
INSERT INTO ivb_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Mabawa pa si Jose, ki naboya darana no kakakteh na saw. Do dawri, sakbay a makarapit do yanan daw, nagtotolag sa a dimanen da. ");
INSERT INTO ivb_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Nyaw inbahey dad katakatayisa dyira a kon da, “Toriw maganayaw a maytaytayēnep! ");
INSERT INTO ivb_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Maganay āno an dimanen ta, as kaalasek ta sya do asaya bobon a abos ranom? Ibahey ta nanchi di Āmang a diniman no asa maranggas a binyay. Chiban ta pan āngo mahahap nad tayēnep na saw.” ");
INSERT INTO ivb_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ki do nakadngeyaw sya ni Ruben, chakey na isalākan si Jose do marahetaw a panggep da no kakakteh na saw. Dawa, binata na dyira a kāna, “Ay, engga ah! Parinen tabaw komwan! ");
INSERT INTO ivb_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Dyi ta pakono a dimanen ah. Tod ta alasken do dyaya bobon do let-angaya. Basta dyi ta ranggasan.” Nyaw inbahey na, ta chakey na isalākan anchi si Jose as kapaybidi na sya di āmang da. ");
INSERT INTO ivb_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Dawa, do nakapakarapitaw ni Jose do yanan daw no kakakteh na saw, tiniliw da, as kinalistwan da binahas iyaw mapintasaw a mayid a laylay na. ");
INSERT INTO ivb_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Do nakabahas daw sya, pinagtos da si Jose do asaw a bobon a abos ranom. ");
INSERT INTO ivb_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Sinpangan na, do kadama daw a koman, naboya da saw tominyitinyaw a bonggoy no maglaklakwaw a taga Midyan a kapotōtan Ismael kan kamilyo da saw a homabas daw a yapod Galaad. As no karga dan kamilyo da saw a yangay da do Egipto, ki siraw gom, balm, kan mirra. ");
INSERT INTO ivb_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Do dawri, binata ni Joda dyirad kakakteh na saw a kāna, “An tod ta dimanen ādi taya, as kaitayo ta sya, abayaw magon-gona ta. ");
INSERT INTO ivb_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Maganaganay āno an ilāko ta na dyirad Ismaelita saya? Ta akmay makkwan an dimanen ta, ta kakteh taya kan yapo taya do asa asi kan raya?” Nakey saw kakakteh naw do inbahey naw. ");
INSERT INTO ivb_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Sinpangan na, do kapaypahabas daw no maglaklāko saw a taga Midyan, inawon dan kakakteh naw si Jose, kan inlāko da so dadwa poho a plata a pirak dyirad maglaklāko saw a Ismaelita, kan inyonot daranas Jose do Egipto. ");
INSERT INTO ivb_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ki do kapaybidyaw ni Ruben do bobonaw, naboya na a araba si Jose daw. Dawa, pinirit naw laylay naw do oltimo a nakapagmamayo na. ");
INSERT INTO ivb_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Naybidi si Ruben do yanan daw no kakakteh na saw, as nakabata na sya a kāna, “Arabaw ādi taw! Ayya! Āngo paro parinen ko sichangori?” ");
INSERT INTO ivb_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Dawa, no pinarin da, ki nanghap sa so asa kalding, as nakadiman da sya, as nakapakneb da so raya naw do mayidaw a laylay ni Jose. ");
INSERT INTO ivb_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Sinpangan na, inyangay da di āmang da iyaw laylayaw, as nakabata da sya a kon da, “Nachichwasan namenaw nya. Chiban pam Āmang, an iyaw laylayaw no pōtot mwaw.” ");
INSERT INTO ivb_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Nailasin ni Jakob laylayaw ni Jose. As dawa, binata na a kāna, “Laylayayan Jose! Diniman naya no asa maranggas a binyay. Sigorado a napisapisang inawan na!” ");
INSERT INTO ivb_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Do dawri, pinirit ni Jakob laylay naw, as nakatadi na sya so makersang a laylay tan ipaboya naw oltimo a mamayo na. Tinanyitanyisan naw nakadimanaw ni Jose so nahay a chimpo. ");
INSERT INTO ivb_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Nangay sa tabo anak naw a mahahakay kan mababakes a kakakteh ni Jose di āmang da, ta chakey da ahwahoken, ki chinakey nabaw mahwahok. Binata ni Jakob a kāna, “Katngan kwaba tanyisan anak kwaw a mandanchan rapiten ko do yanan a kwanan nadiman.” Komwan nakatanyis ni Jakob di Jose a anak na. ");
INSERT INTO ivb_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Do dawri, nakarapit dana saw taga Midyan do Egipto. As do dawri, inlāko da si Jose di Potipar a asa dyirad opisyalaw no āri do Egipto, as kan iya paw kapitan dan gwardya saw. ");
INSERT INTO ivb_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Naynam aba do dawri a chimpo, komnaro si Joda do yanan daw no kakakteh na saw a mahahakay, as nangay a nachikaaroba di Hira a asa mahakay a taga Adollam. ");
INSERT INTO ivb_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Dawriw nakaboyan ni Joda so asaw a mabakes a taga Kanaan a pōtot ni Swa. Kinabahay ni Jodaw nawri a mabakes. ");
INSERT INTO ivb_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Sinpangan na, nabogi, kan naymanganak nawri a mabakes so asa mahakay a pinangaranan ni Joda so Er. ");
INSERT INTO ivb_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Minirwa nabogi si baket ni Joda kan nangyanak so mahakay a pinangaranan nas Onan. ");
INSERT INTO ivb_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","As minirwa pa naymanganak so asa mahakay a pinangaranan na so Sela. Do nakayanakaw ni Sela, ki omyan sa Joda do asa yanan a mayngaran so Aksib. ");
INSERT INTO ivb_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Sinpangan na, do nakapaypahabas no aro a tawen, inpakabahay ni Joda si Er a matoneng a anak na do asaw a mabakes a mayngaran so Tamar. ");
INSERT INTO ivb_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ki maynamot do oltimo a karahet no pinarin ni Er, nahwahok aba si Āpo dya. Dawa, binitos naw byay na. ");
INSERT INTO ivb_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Sinpangan na, binata ni Joda di Onan a adyen Er a kāna, “Kabahayen mos Tamar a ipag mo a nabālo. Basta tongpalen mo dadakay taya an āngo rebbeng mo do ipag mo a nabālo a abos anak tan makapōtot ka so mayparin a pōtot no nadimanaw a ākang mo.” ");
INSERT INTO ivb_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ki chapatak ni Onan a maibidang aba pōtot naw maipōtot naw. Dawa, kāda kaoknod na si Tamar a ipag na, ki ipoha naw mayparin naw a adekey tan dya makapōtot so maibidang a pōtot ni simna Er a ākang na. ");
INSERT INTO ivb_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Nahwahok aba si Āpo do nyaya marahet a pinarin ni Onan. Dawa, aran si Onan, ki binitos na paw byay na. ");
INSERT INTO ivb_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Maynamot do dyaya naparin, binata ni Joda di Tamar a manogang na a kāna, “Maybidi ka pa di āmang mo, kan mangabahay kaba mandan makarakoh si Sela a pōtot ko.” Inbahey naw nyaya, ta mamo an madiman si Sela a akma siras anak na saw a dadwa. Dawa, nangay si Tamar di āmang na. ");
INSERT INTO ivb_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Sinpangan na, homnabas aro a chimpo, as nadiman iyaw baketaw ni Joda, iyaw pōtotaw ni Swa. Do katayokaw no kapagmamayo naw, nagrobwat si Joda a mangay do Timnat do panggogogodan daw so karniro na saw. Nayrayay sa kan Hira a sit na a taga Adollam. ");
INSERT INTO ivb_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Do dawri, myan nakaibahey so nyaya di Tamar a kāna, “Nagrobwat kono si katogangan mo a mangay do Timnat a manggogod siras karniro na saw.” ");
INSERT INTO ivb_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Dawa, tinadyan ni Tamar laylay naw a laylay no bālo so laylayaw no maglaklakos asi, as nakaabongot nas oho naw kan ropa naw tan abo makailasin sya. Sinpangan na, nangay a naydisna a nanala do asdepanaw do idi a Enaim, ta dawriw rarahan a mangay do Timnat. Pinarin Tamar akma syay maynamot ta chinapatak na a rakoh dana si Sela, ki inpakabahay aba ni Joda dya. ");
INSERT INTO ivb_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Do nakaboyaw sya ni Joda, bata nan asa mabaybayadan a mabakes maynamot ta nataloban iyaw ropa naw. ");
INSERT INTO ivb_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Dawa, naypasngen do yanan naw do bitaw no rarahan, as nakabata na sya a kāna, “Ngay, mayoknod ta sichahep.” Ki chapatak naba a si Tamar a manogang na. Ki tominbay si Tamar a kāna, “Āngo itoroh mo dyaken tan pagostwan koymo?” ");
INSERT INTO ivb_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","“Paiyangayan konchimo so orbon no kalding ko,” initbay ni Joda. “On, ki maparin an torohan mo yaken so pakaboyan a mandan paiyangay mo nawri a orbon,” binata ni Tamar. ");
INSERT INTO ivb_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Inyahes ni Joda dya a kāna, “Āngo a pakaboyan chakey mo?” Ki binata ni Tamar a kāna, “Iyaw saryo mwaya konso bato kan igpet mwaya sarokod mo.” Dawa, intoroh ni Joda saw nya inakdaw na. Nayoknod sa, as nabogi si Tamar. ");
INSERT INTO ivb_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Katayokan nyaya, naybidi si Tamar do bahay naw, as nakapakaro na so talobaw no ropa na. Nakapirwa na nagsokat so laylayaw no bālo. ");
INSERT INTO ivb_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Do nakapakarapit ni Joda do kwanan naw, ki tinoboy na si Hira a sit na a taga Adollam a mangyangay so kaldingaw a orbon, as kahap na siras pakaboyan naw a binidin nad mabakesaw. Ki nachichwasan paba ni Hira. ");
INSERT INTO ivb_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Dawa, inyahes ni Hira dyirad mahahakayaw daw do idi a Enaim a kāna, “Chapapatak nyo abaw mabakesaw a manorotoroh so asi na a para do pakaidaydayawan no didyosen taw dya, iyaw maydidisnaw do bitayan rarahan?” Ki binata da a kon da, “Namna, abaw komwan a mabakes dya.” ");
INSERT INTO ivb_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Katayoka no nawri, naybidi si Hira do yananaw ni Joda, as binata na a kāna, “Nachichwasan ko pabaw mabakesaw. Inyahes kwaw dyirad mahahakay saw daw, ki binata daw a aba kono komwan a mabakes daw.” ");
INSERT INTO ivb_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Binata ni Joda a kāna, “Nolay mwa kapyahen naw pakaboyan saw a intoroh ko dya. Chakey kwaba chamimyeng da yaten no tawotawo. Bāli, ta pinadas kwaya inpayangayan so orbon a kalding, ki naboya mwabaya.” ");
INSERT INTO ivb_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Katayoka no tatdo a kabohan, myan nakaibahey di Joda so nyaya a kāna, “Nayparin kono si Tamar a iyaw manogang mwaw a akmay mabaybayadan a mabakes, ta ari dana mabogi.” Do nakadngeyaw syaw ni Joda, inbilin na a kāna, “Yangay nyo a hapen, ta sosohan ta a sibibyay a sigon do dadakay ta!” ");
INSERT INTO ivb_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Do kapahtot daw si Tamar, inpaibahey naw nyaya di katogangan na a kāna, “Binogyaw yaken no akin dyiraw so nya saya. Chiban nyo an sino akin dyira siras nyaya a saryo konso bato kan sarokodaya.” ");
INSERT INTO ivb_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Nailasin ni Joda a siraw dyira naw. Binata na a kāna, “Ayya! Malinlintegaya si Tamar kan yaken, ta pinarin kwabaw rebbengen ko dya a inpakabahay ko si Sela a pōtot ko.” Katayokan nawri, polos a dyi dana minirwa nachoknod di Tamar. ");
INSERT INTO ivb_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Do nakarapitaw no araw a kapaymanganak ni Tamar, napatakan a singin saw anak naw. ");
INSERT INTO ivb_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Do kapagpasikal naw, minohtot asaw a tanoro no adekeyaw. Inigpet no partiraw, as nakaytan na sya so mabaya bolabola. Binata na a kāna, “Nyaw pakaboyan sya a nanomaw nya.” ");
INSERT INTO ivb_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Sinpangan na, minisek tanorwaw no adekeyaw. Ki do nakaysek naw, naychihat a nayanak iyaw kasingin naw a mahakay. “Namna! Pinilit mwayaw minohtot!” binata no partiraw. Dawa, napangaranan so Pares adekeyaw. ");
INSERT INTO ivb_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Katayoka na, nachitadi a minohtot kasingin naw, ki mahakay dana. Iyaw nyaw naytananaw so tanoro so mabaya bolabola. Napangaranan nyaya adekey so Sera. ");
INSERT INTO ivb_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","As no naparin di Jose a nailako dyirad Ismaelita saw, ki inyangay dan Ismaelita saw do Egipto. Do nakapakarapit daw daw, inlāko da di Potipar a taga Egipto a asa opisyal no āryaw kan kapitan pa no gwardya na saw. ");
INSERT INTO ivb_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Binindisyonan ni Āpo si Jose do kayan naw a omyan do bahay no āmo naw a taga Egipto. Dawa, maganay a tabo naparin dya. ");
INSERT INTO ivb_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Naboya no āmo naw a si Āpo mangaywan dya, as kan si Āpo somnidong dya a mapaggasat do tabo a parinen na. ");
INSERT INTO ivb_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Maynamot ta komwan, nahwahok si Potipar di Jose. Dawa, pinayparin na si Jose a iyaw magsirbi dya do mismo a pamilya na. Iyaw pinayparin ni Potipar a mangaywan so bahay na kan tabo a warawara na. ");
INSERT INTO ivb_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Yapo do kaaywanaw ni Jose so bahay no āmo na kan tabo warawara na, binindisyonan ni Āpo siraw myan do bahay ni Potipar a maynamot di Jose. On, siraw tabo a omyan do bahay ni Potipar, as kan tabo kinabaknang naw, ki binindisyonan pa ni Āpo. ");
INSERT INTO ivb_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Dawa, intalek ni Potipar tabo di Jose iyaw warawara na. Ta an si Jose iyaw mangaywan, apabaw riribok na, an dyi dana iyaw kakan na. As maynamot di Jose, ki asa mataer a baro. ");
INSERT INTO ivb_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Dawa, nakorsonadaan baketaw no āmo naw. Myan naypisa a binata na dya a kāna, “Ngay, mayoknod ta pa?” ");
INSERT INTO ivb_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ki chinakey aban Jose, as binata na dya a kāna, “Ay, ibahey mwabaw komwan, mo Mam. Chiban mo, abaw pakariribokan no āmo kwaw do dya bahay maynamot ta myan ako dya. Intalek na tabo warawara na dyaken. ");
INSERT INTO ivb_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Myan toray ko do dya bahay a akmas katoray na. Intalek na dyaken tabo a myan dya, malaksid dyimo, ta imo baket na. Ay samna! Parinen kwabaw nyaya marahet, as kan makagatos ako pa do Dyos.” ");
INSERT INTO ivb_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Aran kararaw a akdakdawen no mabakesaw di Jose a mayoknod sa, ki nakey abas Jose kan ditditchanan na. ");
INSERT INTO ivb_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Do asa karaw, somindep si Jose do bahayaw tan parinen naw tarabako naw. Ki do dawri, ki abaw aran asa dyirad kapayngay naw a adipen do irahemaw no bahay. ");
INSERT INTO ivb_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Do dawri, pinalang no mabakesaw laylayaw ni Jose, as nakabata na sya a kāna, “Ngay, mangay ta pa mayoknod!” Ki nakalapsot si Jose, as nakapayayo a minohbot. Ki nabidinaw laylay naw a naigpet no mabakesaw. ");
INSERT INTO ivb_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Do dawri, do nakadlawaw syan mabakesaw a natokos ni Josew pinalang naw a laylay na, ");
INSERT INTO ivb_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ngineyan na saw adipen naw. Do kawara daw, binata na a kāna, “Chiban nyo nyaya. Insabat dyamen ni lakay ko nyaya Hebreo a tawo a mamarin so pakasnesnekan namen. Somindepaw kaychi do kwarto ko, ta chakey na yaken a paypariparinan, ki nangngey akwaw so mayit. ");
INSERT INTO ivb_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Do nakadngey naw a nangngey ako, ki nayyayo a minohbot. Ki chiban nyo, nabidinaw nyaya laylay na.” ");
INSERT INTO ivb_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Kinapya no mabakesaw laylayaw ni Jose mandad kawara ni lakay na. ");
INSERT INTO ivb_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Inbahey na di Potipar a lakay na iyaw naparinaw a akmas inbahey naw dyirad adipen da saw. Binata na a kāna, “Iyaw nyaya a adipen a Hebreo a insabat mo dyamen, ki somindep do kwarto ko, ta chakey naw mamarin so pakasnesnekan ko. ");
INSERT INTO ivb_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ki maynamot do nakadngey naw sya nangngey ako, ki nayyayo a minohbot. Ki nabidinaw nyaya laylay na,” binata no mabakesaw. ");
INSERT INTO ivb_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Do nakadngeyaw no āmwaw ni Jose so inbaheyaw no baket naw a myan marahet a pinarin ni Jose, taywara a nakasoli. ");
INSERT INTO ivb_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Do dawri, nanyeng na pinatiliw, as nakapasdep na sya do nakabahodan daw no binahod saw no āryaw do Egipto. Dawriw niyanan Jose. ");
INSERT INTO ivb_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ki aran komwan naparin, myan si Āpo dya, as maynamot do bindisyon na dya, maganay kayayan na do gwardyaw do pamahodan. ");
INSERT INTO ivb_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Intalek no gwardyaw di Jose tabo kapayngay na saw a nabahod, as iya danaw makatoneng do tabo mapariparin do dawri a bahodan. ");
INSERT INTO ivb_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Yapo do dawri, pinagparikotan paban gwardyaw intalek na saw di Jose, ta no aran āngo a pinarin ni Jose, ki maganay, ta si Āpo somnidong dya a mapaggasat. ");
INSERT INTO ivb_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Do nakapaypahabas danan chimpo, myan dadwa dyirad opisyalis saw no āryaw do Egipto a nakagatos. Iyaw asa, ki katatalkanaw a manorotoroh so palek do āryaw, as kan iyaw asaw, ki iyaw katatalkanaw a mamariparin so tinapay a para do āryaw do Egipto. ");
INSERT INTO ivb_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Taywara nakasoli iyaw āryaw dyirad dadwa saya opisyal na. ");
INSERT INTO ivb_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Dawa, inpopok na sa do bahayaw no kapitanaw no gwardya, do bahodanaw a nakabahodan ni Jose. ");
INSERT INTO ivb_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Si Jose iyaw kinedngan no kapitanaw a magsirbi dyira, as nahay sa do bahodan. ");
INSERT INTO ivb_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Do asa kahep do irahemaw no bahodan, naytayēnep saw dadwaw, iyaw katatalkanaw a manorotoroh so palek do āryaw kan iyaw katatalkanaw a mamariparin so tinapay no āryaw do Egipto. Maytarek tayēnep da, kan maytarek paw chakey da batahen. ");
INSERT INTO ivb_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Do kamabekasanaw, do kangayaw ni Jose a magsirbi dyira, naboya na a mariribokan sa. ");
INSERT INTO ivb_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Dawa, inyahes na dyirad dadwa saw a kapayngay na a nabahod do bahayaw no āmo na a kāna, “Inyom Sit, āngo ta akmay maliday kamo sicharaw?” ");
INSERT INTO ivb_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ki binata da a kon da, “On, ata, kahep, naytayēnep kamyaw a dadwa, ki abaya dyaw makaibahey so chakey na batahen no nya saya tayēnep namen.” Ki tominbay si Jose a kāna, “Si Āpo Dyos, ki iyaw moyboh a manoroh so sirib no tawo tan maibahey naw chakey a batahen no asa tayēnep. Ibahey nyo pa dyaken an āngo tayēnep nyo saw.” ");
INSERT INTO ivb_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Dawa, inbahey no katatalkanaw a manorotoroh so palek do āryaw iyaw tayēnep naw di Jose. Binata na di Jose a kāna, “Do kapaytayēnep kwaw, nakaboya kwaw so asa katngeh a obas do salapen kwaw. ");
INSERT INTO ivb_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Myan tatdo a yangaw na. Do kapaybohong na paw, ki nagbosel kan nay-asi so aro, as kan naynoy sa tabo asyaw no obas. ");
INSERT INTO ivb_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Inigpet kwaw do dawri iyaw bāswaw no āri. Do dawri, namoyis ako, as nakapis ko sya pinatola do bāswaw, as nakaitoroh ko sya di āri.” ");
INSERT INTO ivb_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Binata ni Jose a kāna, “Nyaw no chakey a batahen no tayēnep mwaya: Tatdo a karaw chakey na batahen no tatdwaya a yangaw. ");
INSERT INTO ivb_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Tatdo a karaw a yapo sichangori, pakakarohen nanchimo ni āri, as pabidyen naymo do sigodaw a toray mo. Imonchiw manoroh so bāso na a akmas pariparinen mwaw do kachwaw. ");
INSERT INTO ivb_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ki chāsi mo yaken, ta naknakmen monchi yaken anchan mirwa a maganay kayayan mo. Isarita mo pakononchi yaken di āri, as kan sidongan mo yaken a mohtot do dyaya bahodan. ");
INSERT INTO ivb_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ta no kaoyodan na, ki intālaw da yaken do tana dan Hebreo a tawo. As aran do kayan kwaya dya do tanaya a Egipto, ki aba polos naygatosan ko a nakayapwan nakabahodan ko.” ");
INSERT INTO ivb_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Do kadngeyaw sya no katatalkanaw a mamariparin so tinapay no āryaw a maganay chakey a batahen no tayēnepaw no rarayay naw, binata na di Jose a kāna, “Aran yaken, ki aryaw tayēnep ko. Tinayēnep kwaw a maysoson ako so tatdo a bakag a napno so tinapay. ");
INSERT INTO ivb_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Iyaw mamanyitwaw a bakag do oho ko, ki myan daw tabo a kita no tinapay a dyiran āri, ki kanenaw no manomanok.” ");
INSERT INTO ivb_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Binata ni Jose a kāna, “Mas nyaw chakey na batahen no tayēnep mwaya: Tatdo a karaw chakey na batahen no tatdwaya bakag. ");
INSERT INTO ivb_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Tatdo a karaw yapo sichangori, pahtoten nanchimo ni āri, as kaipapotoh na dyimo. Ipalodyit nanchimo do kayo, as kanen anchi no manomanok iyaw asi no inawan mo.” ");
INSERT INTO ivb_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Iyaw chatatdwaw no araw yapo do dawri, nagkompli iyaw āryaw daw. Namarin so ragragsak a para dyirad tabo saw a opisyalis na. Inpapahtot na saw dadwaw a opisyal a nabahod a iyaw katatalkanaw a manorotoroh dya so palek kan iyaw katatalkanaw a mamariparin so tinapay, as nakapaiyangay na sira do yanan daw no kapayngay daw a opisyalis. ");
INSERT INTO ivb_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Sinpangan na, pinabidi naw katatalkanaw a manorotoroh so palek do sigodaw a tarabako na a kapanorotoroh so palek di āri. ");
INSERT INTO ivb_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ki inpalodyit naw katatalkanaw a mamariparin so tinapay a akmas inbaheyaw ni Jose dyira. ");
INSERT INTO ivb_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ki aran komwan naparin a akmas binataw ni Jose, ki alit na nawayakan no katatalkanaw a manorotoroh so palek si Jose. Nanakem na paba. ");
INSERT INTO ivb_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Sinpangan na, homnabas dadwa katawen. Do asa kahep, naytayēnep āryaw do Egipto. Do tayēnep naw, ki myan a maytēnek do payis no rakoh a oksong a mayngaran so Nile. ");
INSERT INTO ivb_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Do dawri, naboya na saw papitwaw a baka a mawohas a minohtot a yapod oksongaw, as magar-arab sa so tametamek do payis naw daw. ");
INSERT INTO ivb_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Somarono, myan papito a baka a makokwan kan matataglang a minohtot a yapod oksongaw. Naytēnek sa do payisaw no oksong a yanan dan nanomaw a minohtot a kapayngay da baka a mawohas. ");
INSERT INTO ivb_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Sinpangan na, naychihat da hinamon no magogolang saw mawohas saw. Do dawri, nayokay āryaw a maynamot do kakigtot na do naparinaw. ");
INSERT INTO ivb_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Minirwa dana nakaycheh āryaw, ki myan danaw matarek a tayēnep na. Nakaboya danas papito a mararaboy a dāwa a mabibyas a yapo do asa atngeh. ");
INSERT INTO ivb_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Somarono, tomnobo papitwaw a dāwa a mawpayang a hopes, as nahayo sa a maynamot do oltimo a kohat no salawsaw a nakayapo do dāya. ");
INSERT INTO ivb_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Sinpangan na, naychihat a hinamon magogolang saw a dāwa siraw mabibyas saw a dāwa. Do dawri, nayokay danaw āryaw do nakakigtot na, kan natonngan na a tayēnep na sawen. ");
INSERT INTO ivb_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Kamabekasan naw, mariribokan aktokto no āryaw a maynamot do tayēnep na saw. Dawa, pinatawag na sa tabo magsalsalamangkaw kan siraw mamasirib saw do Egipto. Inbahey na dyiraw tayēnep na saw, ki abaw aran asa dyira a makaibahey an āngo chakey a batahen no nawri. ");
INSERT INTO ivb_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Do dawri, binata no katatalkanaw a manorotoroh so palek do āryaw a kāna, “Pakawanen mo yaken, mo āpo Āri, ta sichangori lang a nanakem ko gatos ko, kan machita ko a ipodno dyimo. ");
INSERT INTO ivb_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Do nakapakasoli mwaw dyaken kan iyaw katatalkanaw a mamariparin so tinapay, ki inpabahod mo yamen do bahayaw no kapitanaw no gwardya. ");
INSERT INTO ivb_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Do asa kahep, do kayan namenaw do dawri, ki myan tinayēnep namen a dadwa, ki naytarekaw chakey a batahen no tayēnep namen saw. ");
INSERT INTO ivb_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ki myan asa baro a Hebreo a adipen no kapitanaw no gwardya, as kan rarayay namen do irahemaw no bahodan. Inbahey namenaw dyaw tayēnep namen saw, ki naibahey naw iyaw chakey da batahen no bokod namenaw a tayēnep. ");
INSERT INTO ivb_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Naparinaw a tabo akmas inbahey naw dyamen: Napaybidi ako do sigodaw a toray ko, as kan naipalodyit iyaw talken mwaw a mamariparin so tinapay.” ");
INSERT INTO ivb_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Do nakadngey syay no āryaw, pinatawag nas Jose. In-godes da pinahbot si Jose do bahodanaw. Do nakatayoka naw a napachischis kan napaiminyin, sinokatan da, as nakaiyangay da syad yananaw no āryaw. ");
INSERT INTO ivb_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Do nakawaraw ni Jose do salapenaw no āryaw, binata no āryaw di Jose a kāna, “Myan tinayēnep ko, ki aba polos makaibahey so chakey da batahen. Ki nadngey kwaw a makailawlawag ka so chakey a batahen no tayēnep a madngey mo. Dawa, pinatawag koymo.” ");
INSERT INTO ivb_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ki initbay ni Jose a kāna, “Āpo Āri, yaken abaw masirib a makaibahey so chakey a batahen no tayēnep mo, an dya si Āpo Dyos lang.” ");
INSERT INTO ivb_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Do dawri, inlawlawag no āryaw tayēnep naw di Jose a kāna, “Myan akwaw a maytēnek do payisaw no Oksong a Nile. ");
INSERT INTO ivb_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ki nakaboya kwaw so papito a baka a mawohas a minohtot a yapod oksongaw, as kan nagar-arab sa so tametamek do payis naw daw. ");
INSERT INTO ivb_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Do dawri, myan saw matarek a papito a baka a somnarono a minohtot. Maychatagtaglang saw a taywara so kakokwan. Aryak pad nakaboya so komwan a kakwan baka do intīrwaya a Egipto. ");
INSERT INTO ivb_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Sinpangan na, naychihat da hinamon no magogolang saw siraw mawohas saw a kapayngay da baka a nanoma a minohtot. ");
INSERT INTO ivb_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ki abaw pakaboyan so nakakan daw sira, ta nāw da a mabichid a makkwan. Katayoka na, nayokay ako. ");
INSERT INTO ivb_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Do kapirwa kwaw a nakaycheh, naytayēnep akos matarek. No naboya ko, ki papito a mayid kan nakabyas a dāwa a yapo do asa katngeh. ");
INSERT INTO ivb_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Somnarono, tomnobo papito a matarek a dāwa a mawpayang a hopes, as kan nahayo sa a maynamot do oltimo a kohat no salawsaw a nakayapo do dāya. ");
INSERT INTO ivb_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Sinpangan na, naychihat a hinamon hopes saw a dāwa siraw nakabyas saw a dāwa. Inbahey ko naw nyaya dyirad magsalsalamangka saw, ki abaw makaibahey so chakey na batahen.” ");
INSERT INTO ivb_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Do dawri, binata ni Jose do āryaw a kāna, “Asaw chakey a batahen no tinayēnep mo saya. Inpakatoneng no Dyos dyimo iyaw makalo narana parinen. ");
INSERT INTO ivb_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Papito a katawen iyaw chakey a batahen no papito saw a mawohas a baka kan iyaw papito saw a nakabyas a dāwa. Mayengay chakey a batahen no nya saya. ");
INSERT INTO ivb_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","As no papito saw a matataglang a baka a makokwan kan no papito saw a dāwa hopes a nahayo a maynamot do makohat a salawsaw a yapo do dāya, ki papito a katawen a apteng chakey na batahen. ");
INSERT INTO ivb_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Akmas inbahey ko kaychi dyimo, mo āpo Āri: Inpakatoneng ni Āpo Dyos dyimo iyaw makalo narana parinen. ");
INSERT INTO ivb_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","No chakey na batahen nyaya, ki ītonchiw papito a katawen a aro maapit do tābo a tana no Egipto. ");
INSERT INTO ivb_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Katayoka na, monot anchiw papito a katawen a kapaychapteng. Ki mawayakan anchi no tawotawo papitwaw a katawen a kāro no āpit do Egipto, ta taywara anchi so karanggas kapaychaptengaya. ");
INSERT INTO ivb_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Polos a manakem da pabanchin tawotawo papitwaw a katawen a kāro no āpit do kasaronwaw anchi no kapaychapteng, ta taywara anchi a makamwamomo. ");
INSERT INTO ivb_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Iyaw nakapaypirwaw no tayēnep mo, ki chakey na batahen a oyod a inkeddeng no Dyos a maparin anchiw, kan abaw dwadwa a īto dana. ");
INSERT INTO ivb_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Dawa, sichangori, mo āpo Āri, machita a maychichwas ka so asa tawo a myan so sirib kan kapakaāwat a pinakainawan mo, ta iyaw payparinen mo a mangitoray so tābo a Egipto. ");
INSERT INTO ivb_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","As machita mamidi ka so kadwan saw a opisyalis a mangitoray dyirad mangakpeh saw so apagkalima no tabo maapit do tābo a Egipto do papito saya tawen a kāro no maapit. ");
INSERT INTO ivb_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ipakpeh mo dyiraw nawri a āpit do ītonchi a papito a tawen a kāron āpit. As torohan mo sa pakono so toray a mangapya do agāmang saya do syodad saya, as kagwardya da sya. ");
INSERT INTO ivb_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Siraw nyaw risirba a mangbyay anchi so tawo anchan mangay papito a katawen a kapaychapteng do dya tana a Egipto. Ta an parinen mo komwan, madiman abaw tawo do kapteng.” ");
INSERT INTO ivb_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Do dawri, nakey si āri kan siraw opisyalis naw do inbaheyaw ni Jose. ");
INSERT INTO ivb_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Binata no āryaw dyirad opisyal na saw a kāna, “Aryoriw madongso ta a akmas Jose a myan so ispirito no Dyos?” ");
INSERT INTO ivb_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Dawa, binata na di Jose a kāna, “Maynamot ta inpaboya tabo no Dyos dyimo nya saya, apabaw kapariho mo so kasirib kan kapakaāwat. ");
INSERT INTO ivb_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Dawa, payparinen koymo a pinakainawan ko a mangitoray so tābo a tana no Egipto, kan tongpalen anchi no tabo a tawotawo iyaw bilin mo. Abaw matwatohos so toray kan imo, an dya yaken a āri. ");
INSERT INTO ivb_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","On, itoroh ko dyimo sichangoriw toray a mangitoray so tābo pagāryan ko do Egipto.” ");
INSERT INTO ivb_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Somnarono, pinakaro no āryaw iyaw singsing naw a yanan pangilasinan so toray na, as nakapasingsing na sya di Jose. Pinaylaylay na so maydak a laylay no masisita a tawo, as nakasaryo na pa sya so balitok. ");
INSERT INTO ivb_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Do katayoka naw, pinasakay na si Jose do chadadwaw no kagaganayan a logan na a osaren no makanawanaw a opisyal na tan maipaboya dyirad tawotawo katoray ni Jose. As myan saw soldado a pinanmanma na kan si Jose do kapagparada da a mangingengengey so, “Domitchan kamo do rarahanaya, kan maydogod kamo, ta īto pinakainawan no āri!” Nyayaw naparin do kapayparin no āri si Jose a mangitoray do tābo a Egipto. ");
INSERT INTO ivb_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Sinpangan na, binata no āryaw di Jose a kāna, “Yaken Paraon do dya. Ki alit na, abanchiw mapalobosan a parinen tawotawo do tābo a Egipto, an dyi mo a ipalōbos.” ");
INSERT INTO ivb_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Do dawri, pinangaranan na si Jose so Sapenat Panea, as inpakabahay na dya si Asenat a pōtot ni Potipera. Si Potipera, ki omyan do syodad no Heliopolis, kan iya, ki asa padi daw a magdaydayaw so araw. Do dawri, komnaro si Jose do yanan āri, ta binidibidi naw kāda loglogar do tābo a Egipto. ");
INSERT INTO ivb_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Do kaisiknan ni Jose a magsirbi do āryaw do Egipto, nagtawen so tatdo a poho. Komnaro do palasyowaw, as nakabidibidi na do tābo a Egipto. ");
INSERT INTO ivb_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Do kayanaw no papitwaw a katawen a maganay āpit, oyod a aro naapit. ");
INSERT INTO ivb_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Inpakpeh ni Jose iyaw inkeddeng naw a binglay no āpit, as inpakapya na do kāda asa syodad do papito a katawen do kārwaw no āpit do Egipto. Kāda asa syodad, myan nakpeh a āpit a yapo do omdibonaw a tana. ");
INSERT INTO ivb_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Taywara kāro no irek a inpakapya ni Jose, kan akmas kārwaw no anay do kanayan. Dawa, sinōkat na paba, ta taywara danaw kāro na. ");
INSERT INTO ivb_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Sakbay no kangay no kapaychapteng do Egipto, myan dadwa a anak ni Jose a mahahakay di baket na a si Asenat a pōtot ni Potipera a padi do syodad no Heliopolis. ");
INSERT INTO ivb_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Pinangaranan ni Jose iyaw matonengaw a pōtot na so Manases, ta binata na a kāna, “Sinidongan yaken no Dyos a nangwayawayak so tabo karibok ko kan kangsah ko do pamilya ni āmang ko.” ");
INSERT INTO ivb_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","As pinangaranan naw no somaronwaw so Epraim, ta binata na a kāna, “Si Āpo Dyos pinayparin na yaken a maasi do tanaya nakalidyalidyatan ko.” ");
INSERT INTO ivb_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Do nakapachipanda danaw no papitwaw a katawen a kāro no āpit do Egipto, ");
INSERT INTO ivb_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","somniknan danaw papitwaw a katawen a kapaychapteng a akma so inbaheyaw ni Jose. Siraw tawotawowaw do omdibonaw no Egipto, ki maychapteng dana sa. Ki do tābo a Egipto, ki myan kanen da. ");
INSERT INTO ivb_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Dawa, do nakadidiw daw no tabo tawotawo so kapaychapteng do Egipto, ki nangay sa do āri daw a nachikakaāsi so kanen da. Ki inbahey no āryaw a kāna, “Ngay, may kamo di Jose, as onotan nyo tabo ibahey na dyinyo ah!” ");
INSERT INTO ivb_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Do nakapagwaras danaw no kapaychapteng do tābo a Egipto, nawri danaw nakaywang ni Jose so tabo saw a nakonokon a irek, as kailāko na sya dyirad taga Egipto saw maynamot ta taywara danaw kapaychapteng da. ");
INSERT INTO ivb_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Aran siraw tawotawo saw a yapod matatarek a tana, ki nangay sa do Egipto a gomnātang so kanen da di Jose, ta nagwaras danaw kapaychateng a aran do mateng saw a yanayanan. ");
INSERT INTO ivb_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Do dawri, narapit kapaychapteng a aran do tana a Kanaan, kan nadidiw no kāda pamilya a aran pamilya ni Jakob. Ki do nakatonengaw sya ni Jakob a myan irek do Egipto, inbahey na dyirad anak na saw a kāna, “Āngo ta nāw nyo a magselleng? ");
INSERT INTO ivb_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nadamag kwaw a ari kono irek do Egipto. Mangay kamo a gomātang tan dyi ta madiman do kapteng dya!” ");
INSERT INTO ivb_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Do dawri, nangay saw asa pohwaw a kakakteh ni Jose do Egipto a gomātang so irek. ");
INSERT INTO ivb_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ki pinawnot aban Jakob si Benhamin a mismo a ādi ni Jose dyirad aākang na saw a mangay do Egipto, ta mamo an myan marahet a maparin dya. ");
INSERT INTO ivb_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","As dawa, siraw anakaw ni Jakob, ki nachirayay sa dyirad kadwan saw a taga Kanaan a mangay do Egipto tan gomātang sa so irek da. Ta aran do Kanaan, ki maychapteng sa tabo daw. ");
INSERT INTO ivb_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Do dawri a kangay dan anakaw ni Jakob, ki si Jose iyaw gobirnador do tābo a Egipto, as iya paw maglako so irek do tabo tawotawo do Egipto kan tabo tawotawo a yapod matatarek a logar. Dawa, do nakawara daw daw no kakakteh na saw, ki nangay sa di Jose, as nagrokob sad salapen naw. ");
INSERT INTO ivb_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Do nakaboyaw ni Jose siras kakakteh na saw, nanyeng na sa nailasin. Ki inkaskaso na saba a akmaw dyi na sa chapatak. Midyo na sa kelkelgaen a akmay ipsok na sa. Inyahes na dyira a kāna, “Dino nakayapwan nyo?” Ki tominbay sa a kon da, “Yapo kamyaw do Kanaan, mo Āpo. Mangay kami dya a gomātang so kanen namen.” ");
INSERT INTO ivb_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Oyod a nailasin sa ni Jose a siraw aākang naw. Ki sira, ki polos a dyi da mailasin si Jose a ādi da. ");
INSERT INTO ivb_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ki do dawri, nanakem ni Jose iyaw tinayēnep naw a maynamot dyira. Binata na dyira a kāna, “Bayataw kamo! Ispya kamo āno? Yangay nyo āno a sisiimen tanaya kan pagkapsotan namen tan abāken nyo yamen?” ");
INSERT INTO ivb_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ki initbay da a kon da, “Ay enggaw, mo Āpo. Tod kami a mangay dya a gomātang so kanen namen. ");
INSERT INTO ivb_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Makakakteh kami, ta asaw āmang namen. Yamen a adipen mo, ki mapagtalkan kami. Ispya kami aba!” ");
INSERT INTO ivb_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ki tominbay si Jose a kāna, “Engga! Nangay kamo dya, ta sisiimen nyo tanaya kan pagkapsotan namen tan abāken nyo yamen!” ");
INSERT INTO ivb_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ki initbay da a kon da, “Yamen a adipen mo, ki asa poho kami kan dadwa makakakteh. Asaw āmang namen a omyan do tana a mayngaran so Kanaan. Iyaw boridek namenaw, ki ari a nabidin di Āmang. As no asaw, ki araba.” ");
INSERT INTO ivb_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Ki binata ni Jose dyira a kāna, “Oyod bata kwaya dyinyo a ispya kamo! ");
INSERT INTO ivb_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Tan sigorādo a mapatakan ko a oyod inbahey nyowaya, sintiren ko pa inyo. Ikari ko dyinyo do ngaran ni āri a abaw komaro dyinyo dya, an dya mangay dya iyaw bata nyowaya a boridek nyo. ");
INSERT INTO ivb_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Dawa, manoboy kamo so asa dyinyo a mangay a manghap so bata nyowaya a boridek a kakteh nyo. Mabidin kamo a kadwan do bahodan a mandan mapaneknekan ko an oyod bata nyowaya. Ki an bayataw nyo, ikari ko do ngaran no āri a dawrinchi a mapatakan a oyod a ispya kamo.” ");
INSERT INTO ivb_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Do dawri, binahod na sa so tatdo a karaw do asa a bahodan. ");
INSERT INTO ivb_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Do chatatdo naranaw a karaw, nangay si Jose dyira, as nakabata na sya a kāna, “Asa akwa tawo a manganohed do Dyos. As dawa, abaw pakararayawan nyo an parinen nyo ibahey kwaya dyinyo. ");
INSERT INTO ivb_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","An oyod a mapagtalkan kamo, machita mabidin asa dyinyo do bahodanaya, as maybidi kamo a kadwan tan isabat daw ginatang nyo saya dyirad maptengan saw a pamilya nyo. ");
INSERT INTO ivb_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","As do dawri, machita a isabat nyo dyaw boridekaw a kakteh nyo a bata nyo. Nyaw mangipaboya a oyod iyaw batabatahen nyowaya. Ta an komwan parinen nyo, ipadiman kwaba inyo.” Nakey saw makakaktehaw do dyaya a binata na. ");
INSERT INTO ivb_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ki binata da no katakatayisa dyira a kon da, “Ayya! Nya ngataw dosa ta do marahetaw a pinarin ta do kakteh taw. Ta do kachwaw, do nakaboya taw so oltimo a kāmo kan kaynyin aktokto na, kan nakadngey taw so nakapachikakaāsi na dyaten, inkaskaso taba. As dawa, malidyatan ta sichangori.” ");
INSERT INTO ivb_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Sinpangan na, binata ni Ruben dyira a kāna, “Nyawen! Binata kwaw dyinyo do kachwaw a maygatos kamo abad ādi taya, ki polos a dyi nyo yaken a inadngey. Na, changori nyaw bahes no nakadiman naw a maynamot do pinarin taw dya.” ");
INSERT INTO ivb_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Do dawri, naawātan a tabo ni Jose binatabata daw, ki chapatak daba naawātan na maynamot ta myan ngamin inosar na a nangiyolog so inbahey naw an machisarsarita dyira. ");
INSERT INTO ivb_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Sinpangan na, mapenpen paba ni Jose iyaw kakey naw a tomanyis. Dawa, komnaro do salapen daw a nangay a tomnanyis. Nakapakarahan naranaw, ki naybidi kan naychirin dyira. Do dawri, inhap na si Simeon, as nakaipabahod na sya do kasalasalapan daw. ");
INSERT INTO ivb_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Sinpangan na, inbilin ni Jose do tobotoboyen na saw a apnohen daw kostal dan aākang na saw so irek. Inbilin na pa a sililimed a pabidyen daw kwarta daw do irahemaw no kostal no katakatayisa dyira kan matorohan sa so bahon da. Do dawri, pinarin da tabo nyaya. ");
INSERT INTO ivb_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Katayoka no nawri, pinasakay dan makakaktehaw iyaw ginatang daw a irek do asno da saw, as nakayam da. ");
INSERT INTO ivb_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Do nakaychehan daw do dawri a ahep, asa dyiraw nangiwang so kostal na tan pakanen naw asno naw. Ki do dawri, naboya naw kwarta naw a naposek do hapotaw no irek do irahem no kostal naw. ");
INSERT INTO ivb_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Binata na dyirad kakakteh na saw a kāna, “Samna! Pinaybidi dāya tabo pinagbayad kwaw! Myanaya do irahemayan kostal kwaya!” Do dawri, akmaw nawarwaraw barōkong da do dyaya naparin. Namirpir sa a batabatahen da do katakatayisa dyira a kon da, “Āngo nyaya pinarin no Dyos dyaten?” ");
INSERT INTO ivb_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Do kawara daw di āmang da a si Jakob do Kanaan, inbahey da tabo napariparinaw dyira do kayan dad Egipto. ");
INSERT INTO ivb_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Binata da a kon da, “Kelkelgaen naw yamen no gobirnadoraw do Egipto a batahen naw a ispya kami do tana da. ");
INSERT INTO ivb_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ki tominbay kamyaw a kon namen, ‘Ay engga, mo Āpo. Mapagtalkan kami a tawo. Ispya kami aba! ");
INSERT INTO ivb_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Asa poho kami kan dadwa a makakakteh, as asaw āmang namen. Arabaw asaw a kakteh namen, as arid āmang namen do Kanaan iyaw boridekaw a kakteh namen sichangori.’ ");
INSERT INTO ivb_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ki nyaw binata no gobirnadoraw dyamen a kāna, ‘Nyaw pakaboyan ko an oyod a mapagtalkan kamo a tawo. Mabidin asa dyinyo dyaken. As siraw kadwan, ki maybidi tan isabat nyo irekaya do maptengan saw a pamilya nyo. ");
INSERT INTO ivb_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Yangay nyo a ahapen iyaw bata nyowaya boridek a kakteh nyo, ta yangay nyo dyaken tan chapatak ko a ispya kamo aba, an dya mapagtalkan kamo a tawo. Anchan maybidi kamo, wayawayaan konchiw kakteh nyowaya a pabidyen dyinyo, as kan libri kamonchi a midibidi a magnigosyo do tana namenaya.’ Nyaw binata na dyamen.” ");
INSERT INTO ivb_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Do nakaywang daw so kostal da saw, naboya da no katakatayisa dyira a myan pa tabo iyaw kwarta da saw a pinagbayad da so irekaw. Namo sa may-aāmang a nakaboya so kwarta saw. ");
INSERT INTO ivb_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Binata ni Jakob dyira a kāna, “Yakenayaw pagmamayohen nyo do kabo daranayan anak ko saya. Apaba si Jose. Komwan si Simeon. Changori, chakey nyo pa ikaro dyaken si Benhamin. An komwan, sobra danaw karahmet na dyaken.” ");
INSERT INTO ivb_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Tominbay si Ruben di āmang na a kāna, “Āmang, italek mo dyaken si Benhamin, as pabidyen konchi dyimo. An dyi kwa mapabidi, maparin monchya dimanen dadwa saw a pōtot kwa mahahakay.” ");
INSERT INTO ivb_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Binata ni Jakob a kāna, “Ay, maparin aba pawnoten ko dyinyo iyaw boridekaya. Nadiman danaw mismwaw a kakteh na, as iya danaw nabidin. An myan marahet a maparin dya do kapagbyahi na, inyo manoroh so kapagmamayo ko a pakayapwan kadimanan ko, ta taywara malkem ako na.” ");
INSERT INTO ivb_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Do dawri, taywara danaw kapaychateng do Kanaan. ");
INSERT INTO ivb_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Dawa, do nakapatawos danaw a tabon irek da a insabat da a yapod Egipto, binata ni Jakob dyirad anak na saw a kāna, “Maybidi kamo pa do Egipto a mirwa a gomātang so aran dēkey pa kanen ta.” ");
INSERT INTO ivb_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ki tominbay si Joda a kāna, “Āmang, sinsinan abaw ballāag dyamen no mangitoray daw a dyi kami a mapaboya dya, an dyi namen a kayrayay iyaw ādi namenaya. ");
INSERT INTO ivb_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","An palobosan mo ādi namenaya a machirayay, maybidi kami a gomātang so kanen ta. ");
INSERT INTO ivb_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Amnan maskeh ka, mangay kami aba, mo Āmang, ta binataw no gobirnadoraw a dyi kami a mapaboya dya, an dyi namen a kayrayay iyaw ādi namenaya.” ");
INSERT INTO ivb_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Binata ni Jakob a kāna, “Āngo ta pinasabhayan nyo yaken so komwan a riribok? Āngo ta inbahey nyo pa a myan paw kakteh nyo a asa?” ");
INSERT INTO ivb_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ki tominbay sa a kon da, “On, ata, nawryaw inyahahes na maynamot do pamilya ta. Inyahes naw an sibibyay paw āmang namen kan an myan paw kakteh namen a asa. Tod namenaw a inatbay, ata, aba polos hahawen namen a ipahap naw kakteh namenaya.” ");
INSERT INTO ivb_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Binata ni Joda di āmang na a kāna, “Pawnoten mo dyaken si Benhamin, ta mayam kami na sichangori tan dyi ta madiman do apteng kontodo siraw kamotdehan saya. ");
INSERT INTO ivb_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Yaken mangatbay kan makatoneng do byay na. Ikari ko dyimo, mo Āmang, a aywanan kwa maganay, ta an dyi kwa mapabidi dyimo a sibibyay, yaken anchiw mayrara so pamagatos mo a abos pandan. ");
INSERT INTO ivb_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ta sichangori, ari kami na nakapaypirwa naybidi, an dyi kami a nabalabalay.” ");
INSERT INTO ivb_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Tominbay si Jakob dyira a kāna, “An nyaw machita a mawnotan aket, parinen nyo nya: Manghap kamo so napidi saya a kagaganayan a myan do tana taya dya, as posken nyo do kostal nyo saw, ta isāgot nyo di gobirnador, aran taydedekey pa a gom, balm, kan mirra a pamarin so bangbanglo. Manghap kamo pas mapalet a tagapolot no obas, kan asi sayan piniones kan almendras a kayokayo. ");
INSERT INTO ivb_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Manghap kamo so kwarta a maypirwa akmas inhap nyowaya do nakangay nyowaw tan pabidyen nyo iyaw pinangay daya do kostal nyo saya kwarta. Angwan nagkamali sa. ");
INSERT INTO ivb_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ahapen nyo pas Benhamin a ādi nyo, kan maybidi kamo do dawri a tawo. ");
INSERT INTO ivb_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Si Āpo Dyos pakono a Manakabalin manoroh dyinyo so kāsi na tan chāsi naynyo no tawowaw kan palobosan naw kapaybidi da dyinyo da Simeon kan si Benhamin. Ta an yaken, abaw maparin ko an mabo ko saw anak ko!” ");
INSERT INTO ivb_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Do dawri, inrobwat da saw rigalo kan kwarta da saw a maypirwa so kāro kan inhap daw do dāmwaw, as inhap da si Benhamin. Sinpangan na, nangay sa do Egipto, as napaboya sa di Jose. ");
INSERT INTO ivb_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Do nakaboyaw sya ni Jose a inyonot da si Benhamin, binata na do tinalek naw a mangaywan so bahay na a kāna, “Yangay mo saw nawaraya sichangori do bahay. Ibilin mo dyira do bahay a magparti sas binyay, as karotong da sya, ta koman kaminchi a tabo a mangaldaw do bahay.” ");
INSERT INTO ivb_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Nagtongpal iyaw talkenaw do inbaheyaw dya ni Jose, as inyangay na saw makakaktehaw do bahay ni Jose. ");
INSERT INTO ivb_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Do nakatoneng daw sya a iyangay da sa do bahay ni Jose, namo sa. Binatabata da a kon da, “Nawri ngataw yangayan da dyaten dyaw maynamot do kwartaw a pinaybidi da do kostal taw do dāmo. Chakey na ngata a kelbaten nanchi yaten, as kasamsam na so asno ta saya, as kapayparin na dyaten a adipen da?” ");
INSERT INTO ivb_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Dawa, do kawara daw do asdepanaw do bahay ni Jose, inasngenan da nachisaritaan talkenaw a makatoneng do bahayaw. ");
INSERT INTO ivb_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Binata da dya a kon da, “Chāsi mo yamen, mo Āpo, kan adngeyen mo yamen. Nangay kami do dya do dāmwaw a gomnātang so kanen namen. ");
INSERT INTO ivb_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Do nakaychehan namenaw do rarahan a maybidi do tana namen, iniwangan namen iyaw kostal namen saw, ki naboya namenaw a myan a tabo kwarta namen saw do hapot saw no kostal a aba polos naksay. Dawa, yangay namen sa a pabidyen. ");
INSERT INTO ivb_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Nangyonot kami pa so igātang namen so kanen namen sichangori. Chapatak namen aba an sino napangay siras kwarta namen saw do kostal namen saw do kachwaw.” ");
INSERT INTO ivb_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ki binata no talkenaw dyira a kāna, “Mabakel kamwaba, kan mamo kamwaba ah! Iyaw Dyos nyo a Dyosaw ni āmang nyo ngataw nanoroh dyinyo so kwarta nyo saw do kostal nyo, ta rinawat kwaw do kachwaw pinagbayad nyowaw.” Sinpangan na, pinahtot na si Simeon a pinarapa dyira. ");
INSERT INTO ivb_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Inyangay na sa do irahemaw no bahay ni Jose, as tinorohan na sa so ranom a paybanaw da so kokod daw, as nakapakan na siras asno da saw. ");
INSERT INTO ivb_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Katayoka da no kakaktehaw ni Jose a naybanaw, insagāna da saw rigalo daw do kawaraw ni Jose do kayegen danaw no araw, ta nadngey da a mangay a machisalap a koman dyira a mangaldaw. ");
INSERT INTO ivb_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Do nakawaraw ni Jose, siraw inisdep daw a rigalo da, ki intoroh da dya, as nakapagrokob da do ratagaw do salapen naw. ");
INSERT INTO ivb_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Sinpangan na, kinablaawan sa ni Jose, as nakaiyahes na sya an mango kayayan da. Inyahes na pa a kāna, “Ari pawri a sibibyay si āmang nyo a malkem dana a inbahey nyo dyaken? Mayit pawri?” ");
INSERT INTO ivb_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Tominbay sa a kon da, “Aryaw a sibibyay kan mayit paw adipen mwaw a āmang namen.” Minirwa dana sa nagrokob do salapen naw a mangipaboya so kapagdayaw da dya. ");
INSERT INTO ivb_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Do nakaboyaw sya ni Jose a myan si Benhamin a mismo na kakteh do āmang kan ānang, inyahes na dyira a kāna, “Ah, iyawriw nyaw bata nyowaw dyaken a boridek nyo?” Sinpangan na, binata na di Benhamin a kāna, “Bindisyonan pakono imo ni Āpo Dyos, barok!” ");
INSERT INTO ivb_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Do dawri, naāsot rakoh a adaw ni Jose di Benhamin a ādi na, as makey dana a tomanyis. Insigīda a komnaro a nangay do kwarto na a tomnanyis. ");
INSERT INTO ivb_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Nahay abas dēkey, nangay a nayramon, as nakapaybidi na do yanan daw no kakakteh na saw do nakapagpet naw so madididiw naw. Inbilin na dyirad adipen na saw a kāna, “Mangidasar kamo na.” ");
INSERT INTO ivb_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Naychatanyi si Jose a komninan do asaw a lamisaan. Siraw kakakteh na saw, ki matarek iyaw kinanan da. As masaw a matarek pa dyirad Egipto saw a tawotawo, ta rahten daw machihanghang dyirad Hebreo saw a tawotawo, ta inbidang da sa a makabābaba. ");
INSERT INTO ivb_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Do salapenaw no lamisaan a kanan ni Jose, naornos iyaw nakapaydisna da no kakakteh na saw yapo do katotonngan a mandad kaadedekeyan. Do kadlaw daw so ornos daw, naysinchichideb sa a masmasdaawan. ");
INSERT INTO ivb_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yapo do lamisaanaw ni Jose, iyaw naitorohaw dyira a ichan da. Ki maydadima so kāro iyaw kanenaw ni Benhamin dyirad kakakteh na saw. Siraragsak sa a nachinom kan nachakan di Jose. ");
INSERT INTO ivb_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Katayoka da a komninan, inbilin ni Jose do talkenaw a mangaywan do bahay naw a kāna, “Apnohen mo tabo iyaw kostal dāya no makakaktehaya so irek mandad marawa no asno daw, as kapirwa mo a mapabidi so kwarta da saw do hapotaw no irek do irahem no kostal da saw. ");
INSERT INTO ivb_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Pangayen mo paw bāso kwaw a nasokog do pirak do hapotaw no irek do kostalaw no kaadedekeyan daw kontodo kwarta naw a igātang na so irek.” Pinarin no talkenaw iyaw inbilinaw ni Jose dya. ");
INSERT INTO ivb_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Do kapaysesedang naranaw, napalobosan dana saw makakaktehaw a maybidi kontodo asno da saw a komwan do yanan da. ");
INSERT INTO ivb_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Dyi pa sa makabawa do syodadaw, as nakabilin ni Jose so talkenaw a mangaywan do bahay naw a kāna, “Malisto ka, ta lakatan nyo saw tawo saw a taga Kanaan. Anchan madas nyo sa, nyanchiw ibahey nyo a kon nyo, ‘Āngo ta marahet inbahes nyos maganayaw a kapadagos namen dyinyo? ");
INSERT INTO ivb_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Āngo ta tinakaw nyo iyaw pirakaw a bāso ni āmo ko a bayobaywan na a inoman? Nawri a bāso, ki osaren na pa a pangipadto. Marahmet nyaya a pinarin nyo a maikontra do linteg namen!’” ");
INSERT INTO ivb_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Do nakadas daw sira no talkenaw, inbahey naw nawri a inbilin ni Jose. ");
INSERT INTO ivb_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ki tominbay sa a kon da, “Āngo ta komwan ibahey mo, mo Āpo? Aysa! Mabawa do aktokto namen a adipen mo a dyi namen a parinen komwan! ");
INSERT INTO ivb_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Chapatak mo a pinabidi namen dyimo kwartaw a naboya namen do irahemaw no kostal namen saw a pinakayapo namen do Kanaan nawri. Manakaw kami pawri so pirak mana balitok do bahay ni āmo mo? ");
INSERT INTO ivb_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Imom Āpo, aran sino dyamen iyaw pakaboyan mo so nawri a bāso a inbahey mo, maparin a dimanen mo. As yamen a nabidin, mayparin kami a tabo a adipen nyo.” ");
INSERT INTO ivb_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","“Naon,” initbay no talkenaw dyira. “Aran komwan bata nyo, ki iyaw pakaboyan ko so bāso, iya lang mayparin a adipen ko, as libri a komaro danaw kadwan.” ");
INSERT INTO ivb_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Do dawri, kinalyalisto da no kāda asa dyira a pinagchin kostal da saw, as nakaiwang da sira. ");
INSERT INTO ivb_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Kinapya no talkenaw a chinichwas do kostal da saw, kan pinakayapo nad katotonnganaw a mandad kaadedekeyanaw. Do dawri, naboya naw bāswaw do kostalaw ni Benhamin. ");
INSERT INTO ivb_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Do kaboya daw sya no makakaktehaw, pinirit daw laylay da a maynamot do oltimo a kamamayo da. Pinirwa da a pinasakay kostal da saw, as nakapaybidi da do syodadaw. ");
INSERT INTO ivb_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Do kawara daw da Joda kan siraw kakakteh naw do bahay ni Jose, abo paw nangayan Jose. Nanyeng sa naycharorokob do tana a mangipaboya so kapagdayaw da dya. ");
INSERT INTO ivb_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Binata ni Jose dyira a kāna, “Āngo nyaya pinarin nyo? Chapatak nyo abawri a myan panakabalin ko a mangsomar so pinarin nyowaw.” ");
INSERT INTO ivb_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Tominbay si Joda a kāna, “Āngo maparin namen a ibahey dyimo, mo Āpo? Āngo chirinen namen dyimo? Mango kailawlawag namen sya a dyi namen a tinakaw bāso mwaw? Ayya! Si Āpo Dyos mangdosa dyamen do nakagatosan namenaya! Dawa, cha kami dya a mayparin a adipen mo mairaman iyaw nakaboyan daya so bāso mwaw.” ");
INSERT INTO ivb_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Do dawri, binata ni Jose dyira a kāna, “Engga! Chakey kwabaw komwan! Iyaw nakaboyan daya so bāso, iya lang mayparin a adipen ko. As inyo a kadwan, ki maybidi kamo di āmang nyo, ta abaw pakaan-anwan nyo.” ");
INSERT INTO ivb_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Do dawri, naypasngen si Joda do salapenaw ni Jose, as binata na a kāna, “Chāsi mo pa yaken, mo Āpo, ta torohan mo pa yaken a adipen mo so dēkey a chimpo a maychirin. Isoli mwaba yaken a maynamot do dyaya a aran matan-ok ka a akmas āri nyowaya dya. ");
INSERT INTO ivb_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Imom Āpo, do nakarahan, inyahes mo dyamen a adipen mo an myan pas āmang mana kakteh namen a mahakay. ");
INSERT INTO ivb_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ki inatbay namen imo a myan paw āmang namen a malkem dana kan ādi namen a naiyanak do kamalkem dana ni āmang namen. Iya danaw sibibyay a anak ni ānang na, ta nadiman danaw ākang naw, as oltimo a chadaw ni āmang namen. ");
INSERT INTO ivb_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Sinpangan na, inbahey mwaw do kachwaw, mo Āpo a ahapen namen do salapen mo iyaw ādi namenaya tan maboya mo. ");
INSERT INTO ivb_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","As initbay namenaw dyimo a maparin aba a karwan no adekeyayaw āmang namenaw, ta an komaro, ki madiman si āmang namen. ");
INSERT INTO ivb_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Sinpangan na, inbahey mwaw dyamen a mapaboya kami aba mirwa dyimo an abo iyaw boridekaw a kakteh namen.” ");
INSERT INTO ivb_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Binata pa ni Joda di Jose a kāna, “Do nakapaybidi namenaw do yananaw ni āmang namen, inchirin namen iyaw inbahey mwaw. ");
INSERT INTO ivb_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","As do kadēkey danaw no kanen namen, tinoboy narana yamen a mirwa a mangay dya a gomātang so kanen namen. ");
INSERT INTO ivb_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ki inbahey namen dya a makangay kami aba an abo si Benhamin a boridek a kakteh namen, ta maparin aba a mapaboya kami dyimo, an dyi a monot dyamen. ");
INSERT INTO ivb_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Do dawri, binata dyamen ni Āmang a kāna, ‘Chapatak nyo a dadwa lang iyaw anak namen kan Rakel a baket ko. ");
INSERT INTO ivb_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Arabaw asaw dyaken, kan akmas binata kwaw a sigorādo a pinisapisang no maranggas a binyay, as kan naboyak paba nakayapod dawri. ");
INSERT INTO ivb_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","An ikaro nyo paw ādi nyowaya, as myan marahet a maparin dya, inyo manoroh so kapagmamayo ko a pakayapwan kadimanan ko, ta taywara malkem ako na.’ Nawriw binata ni Āmang.” ");
INSERT INTO ivb_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Sinpangan na, tinongtong ni Joda a kāna, “Changori, mo Āpo, an maybidi kami di Āmang, as tokosen namen ādi namenaya, as dya maboya ni āmang namen, sigorādo a madiman, ta iyaw nyaya adekey, nachitapangan byay na. An komwan, yamen a adipen mo manoroh anchi so kapagmamayo ni Āmang a pakayapwan kadimanan na, ta taywara danaw kamalkem na. ");
INSERT INTO ivb_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Asa pa, inkari kwaw di Āmang a yaken mangatbay kan makatoneng do byay no ādi namenaya. Inbahey kwaw dya a an dyi kwa mapabidiw ādi namenaya dya, ki yaken mapagatos a abos pandan. ");
INSERT INTO ivb_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Dawa, mo Āpo, aran yaken danaw mabidin, ta yaken danaw machitadi di ādi ko a mayparin a adipen mo. Palobosan mo pakono ādi namenaya a machipaybidi do aākang na saya. ");
INSERT INTO ivb_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Maypāngo kapaybidi ko di āmang ko an abo ādi namenaya? Maitored kwaba chiban nyaya kalala a maparin di Āmang.” Nawriw binata ni Joda. ");
INSERT INTO ivb_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Do dawri, mapagpet paba ni Jose iyaw madididiw naw do salapen da tabo. Dawa, inbilin na dyirad tobotoboyen na saw daw a kāna, “Komaro kamo a tabo!” Do nakakaro daw, abaw matarek a rarayay na, an dyi dana siraw kakakteh na saw do nakaibahey naw sya dyira an sino iya. ");
INSERT INTO ivb_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Sinpangan na, tomnanyis so malyak. As dawa, siraw tobotoboyen na saw a taga Egipto a myan do gagan, ki nadngey da. Do dawri, yangay da inpadāmag dyirad myan saw do palasyowaw no āryaw. ");
INSERT INTO ivb_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Sinpangan na, binata ni Jose dyirad kakakteh na saw a kāna, “Yakenaw si Jose. Oyodawri a sibibyay pas āmang ta?” Ki do nakadngey daw sya no kakakteh na saw, nableg sa do taywara nakamo da dya. ");
INSERT INTO ivb_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Sinpangan na, inbahey na a maypasngen sa dya. Do kapaypasngen daranaw dya, binata na dyira a kāna, “Yakenaw si Jose a kakteh nyo a inlāko nyo dyirad nangyangayaw dyaken do Egiptwaya. ");
INSERT INTO ivb_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Mariribokan kamo aba mana isoli nyo abaw inawan nyo do nakailako nyowaw dyaken do kachwaw, ta pinanma na yaken Āpo Dyos dya tan mabyay kamo. ");
INSERT INTO ivb_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Chadadwa pan kapaychapteng nyaya tawen. Myan paw dadima a katawen a abo magarado kan magapit. ");
INSERT INTO ivb_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ki si Āpo Dyos nanoboy dyaken dya a manmanma kan inyo tan maditchanan nyo kadiman nyo kan siraw kapotōtan nyo, as kan tan myan panchiw aro a kapotōtan nyo a mabyay do tanaya. ");
INSERT INTO ivb_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Dawa, inyo abaw nanoboy dyaken do dya, an dya si Āpo Dyos. Pinayparin na yaken a katotohosan dyirad opisyal saw ni āri. Yaken makatoneng do tabo tobotoboyen na saw, kan yaken paw mangitoray do tābo a Egipto.” ");
INSERT INTO ivb_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Binata pa ni Jose a kāna, “Changori, makalisto kamo a mangay do yanan ni āmang ta, ta ibahey nyo dya a kon nyo, ‘Nyaw inbahey ni Jose a anak mo: Pinagtoray yaken no Dyos do tābo a Egipto. Nyeng ka mangay dyaken, kan maybabalay kaba. ");
INSERT INTO ivb_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Omyan kanchi do tana a Gosen tan masngen kamo dyaken, inyo a tabo. Ahapen mo saw pōtot mwaw, siraw apōko mo saw, karniro kan baka mo saw, kan tabo a warawara mo. ");
INSERT INTO ivb_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ta an myan kamo do Gosen, yaken anchiw makatoneng do tabo machita nyo, ta ari paw dadima a katawen no kapaychapteng. Ta an dyi kamo a mangay, malidyatan kamo kan siraw tabo a kapamilyaan nyo, ta mabo nyonchiw tabo kinabaknang nyo.’ Nyaw ibahey nyonchi di āmang ta ah.” ");
INSERT INTO ivb_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Tinongtong ni Jose iyaw naychirin dyira a kāna, “Inyo a aākang ko, kan aran imo, mo Benhamin, naboya nyo yaken a si Jose a mismo a machisarsarita dyinyo. ");
INSERT INTO ivb_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ibahey nyo di āmang ta an mango katoray ko do dya a Egipto, kan ibahey nyo tabo a naboya nyo dya. Ngay, makalisto kamo, ta yangay nyo na hapen dya si āmang ta.” ");
INSERT INTO ivb_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Sinpangan na, kinepkep ni Jose si Benhamin a ādi na, as tomnanyis si Jose. As komwan si Benhamin, tomnanyis a nangepkep di ākang na. ");
INSERT INTO ivb_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Tomnanyitanyis pa si Jose a nangepkep siras aākang na saw, as nakadadek na sira. Do dawri, makapaychirin dana sa di Jose. ");
INSERT INTO ivb_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Katayoka nawri, nakarapit dāmag dyira do palasyo a nawara dana saw kakakteh saw ni Jose, ki nasoyot iyaw āryaw kan siraw opisyal na saw. ");
INSERT INTO ivb_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Binata no āryaw di Jose a kāna, “Ibahey mo dyirad kakakteh mo saw a kargaan daw binyay da saw, ta maybidi sa do Kanaan. ");
INSERT INTO ivb_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Ibahey mo pa dyira a ahapen da si āmang nyo kan tabo a pamilya na tan mangay sa dya. Itoroh konchi dyiraw kagaganayan saya a yapod tana no Egipto, as kanen danchiw aro a maganay a mākan a yapod dyaya tana. ");
INSERT INTO ivb_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ibilin mo pa dyira a mapanawbi sa so karison saw a yapod Egiptwaya tan myan pangiloganan da siras adedekey kan babbaket da saw anchan yangay da si āmang nyo dya. ");
INSERT INTO ivb_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Machita daba iktokto warawara da saw a makarwan danchi, ta matorohan sanchi so kagaganayan a yapod tana do dya Egipto.” ");
INSERT INTO ivb_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Nagtongpal saw pōtotaw ni Jakob do tabwaw a naibahey dyira. Nanoroh si Jose so karison saw a akmas inbilinaw no āri, kan tinorohan na pa sa so bahon da do rarahan. ");
INSERT INTO ivb_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Do katakatayisa dyira, tinorohan na pa sa so bayo a pagsokatan da, ki dadimaw intoroh na di Benhamin kan tatdo a gasot a plata a pirak. ");
INSERT INTO ivb_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Pinaw-itan na pa si āmang na so asa poho a mahahakay a asno a myan so karga do kagaganayan saw a yapo do Egipto kan asa poho pa a mabinayi a asno a myan so rara a irek, tinapay, kan kadwan pa a mākakan a machita no pamilya ni āmang na a komwan do Egipto. ");
INSERT INTO ivb_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Katayoka na, pinayam na saw kakakteh naw. As do kakaro daw, binilin na sa a dyi sa maydidiman do rarahan. ");
INSERT INTO ivb_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Do dawri, komnaro sa do Egipto, as naybidi sa do Kanaan a yanan ni Jakob a āmang da. ");
INSERT INTO ivb_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Do nakapakarapit daw do yanan āmang da, inbahey daw tabo a naparin dyira a kon da, “Sibibyay pa sawen si Jose! Iyaw magtoray do tābo a Egipto.” Ki do dawri, taywara nableg si Jakob, as nagistayan a dya narawan poso na, kan nanganohed aba dyira. ");
INSERT INTO ivb_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ki do kaistorya daw so tabo inbaheyaw ni Jose dyira, kan do nakaboya naw so karison saw a inpaw-it ni Jose a pagloganan na a mangay do Egipto, nagtalna danaw poso naw. ");
INSERT INTO ivb_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Binata ni Jakob a kāna, “Aysa! Anohdan ko na sichangori a sibibyay pa sawen si Jose a anak ko! Apabaw matarek a chakey ko. Basta yangay kwa chiban changori sakbay a madiman ako.” ");
INSERT INTO ivb_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Do dawri, naybabalay aba sa Jakob. Inrobwat da iyaw tabo a myan dyira, as nangay do Beerseba. Dawriw naparawatan na so dāton na saw do Dyos a iyaw dinaydāyawaw ni simna Isaak a āmang na. ");
INSERT INTO ivb_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Do dawri a ahep, naychirinan Dyos si Israel a si Jakob do asa parmata a kāna, “Jakob, Jakob.” Tominbay si Jakob, “On mo Āpo. Cha ako dya.” ");
INSERT INTO ivb_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","“Yaken no Dyosaw a dinaydāyaw ni āmang mo. Mamo kaba a mangay do Egipto, ta payparohen ko sanchiw kapotōtan mo daw a mandan payparinen ko sa rakoh a nasyon. ");
INSERT INTO ivb_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Myan ako dyimo do kangay mwaya do Egipto, ki paybidihen ko sanchiw kapotōtan mo do dya a Kanaan. Myan anchi si Jose do yanan mo anchan madiman ka.” ");
INSERT INTO ivb_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Sinpangan na, komnaro sa Jakob do Beerseba. Insakay dan makakaktehaw si āmang da, siraw pōtot da saw, as kan siraw babbaket da saw do karison saw a intoroh no āri a pagloganan da. ");
INSERT INTO ivb_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Inhap daw binyay da saw kan tabo a warawara a nakpeh da do Kanaan, as nakakwan ni Jakob kan tabo kapotōtan na saw do Egipto. ");
INSERT INTO ivb_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","On, inyonot na saw anak na saw a mahahakay kan mababakes, kan siraw apōko na saw a mahahakay kan mababakes. ");
INSERT INTO ivb_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Siraw nyaw mahahakay a kapotōtan ni Jakob a nachirayay dya do Egipto: si Ruben a matoneng a pōtot ni Jakob. ");
INSERT INTO ivb_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Siraw mahahakay a pōtot ni Ruben, ki sa Hanok, Pallo, Hesron, kan Karmi. ");
INSERT INTO ivb_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Siraw mahahakay a pōtot ni Simeon, ki sa Jemwel, Jamin, Ohad, Jakin, Sohar, as kan si Saul a anak no mabakesaw a taga Kanaan. ");
INSERT INTO ivb_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Siraw mahahakay a pōtot ni Lebi, ki sa Gerson, Kohat, kan Merari. ");
INSERT INTO ivb_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Siraw mahahakay a pōtot ni Joda, ki sa Er, Onan, Sela, Pares, kan Sera. Ki sa Er kan Onan, ki nadiman sa do Kanaan. As siraw mahahakay a pōtot ni Pares, ki sa Hesron kan Hamol. ");
INSERT INTO ivb_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Siraw mahahakay a pōtot ni Issakar, ki sa Tola, Powa, Yob kan Simron. ");
INSERT INTO ivb_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Siraw mahahakay a pōtot ni Sabolon, ki sa Sered, Elon, kan Jaleel. ");
INSERT INTO ivb_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Siraw nya tabo iyaw anak da Jakob kan Lea a mahahakay a naiyanak do Mesopotamya. Ki myan paw anak da a mabakes a si Dina. Tatdo sa poho kan tatdo iyaw bidang no kapotōtan ni Jakob di Lea. ");
INSERT INTO ivb_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Siraw mahahakay a pōtot ni Gad, ki sa Sipyon, Aggi, Soni, Esbon, Eri, Arodi, kan Areli. ");
INSERT INTO ivb_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Siraw mahahakay a pōtot ni Aser, ki sa Jimna, Isba, Isbi, Berya, as kan Serah a kakteh da a mabakes. As siraw mahahakay a pōtot ni Berya, ki sa Heber kan Malkiel. ");
INSERT INTO ivb_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Siraw nyaw kapotōtan ni Jakob di Silpa a iyaw adipen a intoroh ni Laban di Lea a pōtot na. Asa poho sa kan anem a tabo. ");
INSERT INTO ivb_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Sa Jose kan Benhamin, siraw pōtot ni Jakob di Rakel. ");
INSERT INTO ivb_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Siraw mahahakay a pōtot ni Jose, ki sa Manases kan Epraim a inyanak ni Asenat do Egipto. Si Asenat iyaw pōtotaw ni Potipera a iyaw padyaw do syodad a mayngaran so Heliopolis. ");
INSERT INTO ivb_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Siraw mahahakay a pōtot ni Benhamin, ki sa Bela, Beker, Asbel, Gera, Naaman, Ehi, Ros, Moppim, Hoppim, kan Ard. ");
INSERT INTO ivb_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Asa poho sa kan apat iyaw mahahakay a kamanganakan da Rakel kan Jakob. ");
INSERT INTO ivb_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Iyaw mahakay a pōtot ni Dan, ki si Hosim. ");
INSERT INTO ivb_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Siraw mahahakay a pōtot ni Neptali, ki sa Jaseel, Goni, Jeser, kan Sillem. ");
INSERT INTO ivb_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Papito sa tabo mahahakay a kapotōtan ni Jakob di Bilha a iyaw adipenaw a intoroh ni Laban di Rakel a pōtot na. ");
INSERT INTO ivb_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Anem a poho kan anem iyaw kapotōtan ni Jakob a nangay do Egipto. Nairaman abaw babbaket da no pōtot na saw ni Jakob do nya bidang. ");
INSERT INTO ivb_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Dadwaw pōtot ni Jose a naiyanak do Egipto. Dawa, papito a poho siraw tabo a kapotōtan ni Jakob do kangay naw do Egipto. ");
INSERT INTO ivb_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Do dawri, do nakawaraw da Jakob do Egipto, pinanma ni Jakob si Joda di Jose tan mapatakan naw rarahan a mangay do Gosen. Do nakaibahey danaw ni Jose di Joda, naybidi as nakaikwan na sira do tana a Gosen. ");
INSERT INTO ivb_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Do kawara daw daw, nanyeng a napasagāna si Jose so logan na, as nangay do Gosen a mangbayat si āmang na. Do nakawara naw, kinepkep na si āmang na, as nakatanyis nas nahay. ");
INSERT INTO ivb_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Binata ni Jakob di Jose a kāna, “Changori, aran madiman ako na, ta naboya ko na imo, as napatakan ko na a sibibyay ka.” ");
INSERT INTO ivb_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Sinpangan na, binata ni Jose dyirad kakakteh na saw kan tabo a kapamilyaan ni āmang na a kāna, “Yangay kwa ibahey do āryaw a nangay dana dyaken kakakteh ko saya kan tabo a kapamilyaan ni āmang ko a yapo do Kanaan. ");
INSERT INTO ivb_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ibahey ko pa dya a inyo a mahahakay, ki magpaspastor kamo, ta inyonot nyo tabo saw arban saw a karniro, kalding, kan baka nyo, kan tabo a warawara nyo. ");
INSERT INTO ivb_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Anchan tawagan naynyo no āryaw, as iyahes na an āngo tarabako nyo, ");
INSERT INTO ivb_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ibahey nyonchi dya a kon nyo, ‘Yamen a tobotobyen mo, ki magpaspastor kami so binyay a yapo pad kadēkey namen manda sichangori a akma siras kapoonan namen saw.’ An komwan atbay nyo, palobosan na inyo a omyan do dya a Gosen, ta chababa da no taga Egipto saw magpaspastor.” ");
INSERT INTO ivb_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Do nakapaybidyaw ni Jose a yapod Gosen a nangay a nangbayat da āmang kan kakakteh na saw, namidi so dadima dyirad kakakteh na saw a kayrayay na a mangay do yanan no āri. Inbahey ni Jose do āryaw a kāna, “Nawara dana saw sa āmang kan siraw kakakteh ko saw a yapo do Kanaan. Pinanawbi da saw tabo a binyay da kan warawara da. Ari dana saw do Gosen.” ");
INSERT INTO ivb_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Sinpangan na, inyam-ammo na saw dadimaw a kakakteh na do āryaw. ");
INSERT INTO ivb_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Inyahes no āryaw dyira a kāna, “Āngo tarabako nyo?” Tominbay sa, “Yamen a tobotoboyen mo, mo Āpo, ki magpaspastor kamyaw a akma siras kapoonan namen saw.” ");
INSERT INTO ivb_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Binata da pa, “Nangay kamyaw dya a omyan sichangori, mo Āpo, ta taywara danaw kapaychapteng do Kanaan. Nalidyatan kamyaw daw kan aran siraw binyay namen saw, ta apabaw pangipastoran namen dyira. An ara mwa ipalōbos a omyan kami a tobotoboyen mo do Gosen, dawrinchiw yanan namen.” ");
INSERT INTO ivb_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Binata no āryaw di Jose a kāna, “Sichangori, mapatakan ko na a nawara danas āmang mo kan kakakteh mo saw. ");
INSERT INTO ivb_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Cha dyaw tana a Egipto, as imo danaw makatoneng a mamidi so maganay a tana dyira da. Palobosan mo sa a omyan do Gosen. An myan dyiraw chapatak mo a maganay a mangipastor so binyay, siraw pagaywanen mo siras binyay ko saw.” ");
INSERT INTO ivb_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Sinpangan na, inhap ni Jose si Jakob a āmang na do yanan no āri tan iyam-ammo na dya. Kinablaawan ni Jakob āryaw, as nakabindisyon na sya. ");
INSERT INTO ivb_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Inyahes no āryaw di Jakob a kāna, “Papira danaw tawen mo, mo Āmang?” ");
INSERT INTO ivb_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Tominbay si Jakob a kāna, “Asa dana gasot kan tatdo a poho tawen ko. Manyid nawri kan malidyat iyaw nakabyay ko do hapotayan tana. Ta no nakabibyay ko, ki akmabas kanaro no byay no kapoonan ko saw.” ");
INSERT INTO ivb_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ki sakbay a nayam si Jakob, pinirwa na binindisyonan āryaw a nawriw kapadyos na dya. ");
INSERT INTO ivb_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Do dawri, pinachiyan sa ni Jose sa āmang na kan siraw kakakteh na saw do Egipto. Tinorohan na sa so kagaganayan a tana do masngen do syodad a Rameses do Gosen. Pinarin Jose iyaw bilinaw no āri. ");
INSERT INTO ivb_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Tinorohan na pa sa so kanen da āmang na, siraw kakakteh na saw, as kan tabo kapamilyaan saw ni āmang na sigon do kāron adedekey a myan dyira. ");
INSERT INTO ivb_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Do dawri, naypaypataywara danaw apteng, kan apaba polos tomobo do aran dino a yanan do Egipto kan do Kanaan. Dawa, oltimo a malidyatan saw tawotawo daw. ");
INSERT INTO ivb_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Nangay sa di Jose a gomnātang so irek da. Maynamot do dawri, chinpeh a tabo ni Jose iyaw kwarta daw a pagbayad no tawotawo a yapod Egipto kan Kanaan. Inyangay na kinapyaw kwartaw do palasyowaw no āri. ");
INSERT INTO ivb_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Do nakapatawos danaw no kwarta no taga Egipto kan Kanaan, nangay saw taga Egiptwaw di Jose, as nachikakaāsi sa a kon da, “Torohan mo pa yamen so kanen namen. Āngo ta nonolay mo yamen a madiman a maynamot do kabon kwarta namen.” ");
INSERT INTO ivb_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Ki tominbay si Jose dyira a kāna, “An abo danaw kwarta nyo, sira danaw binyay nyo saw yangay nyo dya, ta tadyan ko so kanen nyo.” ");
INSERT INTO ivb_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Dawa, inyangay da saw binyay da saw di Jose a akmas kabalyo, karniro, kalding, baka, kan asno da saw, ta nawriw itadi das kanen da. As do dawri a tawen, tinorohan na sa so kanen da a tadi no binyay da saw. ");
INSERT INTO ivb_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Do somnaronwaw a tawen, nangay dana sa di Jose, as binata da a kon da, “Āpo, chapatak mo a arabaw kwarta namen, as komwan binyay namen, ta dyira mo na a tabo. Araba polos maitoroh namen dyimo, an dyi danaw inawan namen saya kan siraw tana namen saw. ");
INSERT INTO ivb_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","An nonolay mo yamen, madiman kami do kapteng. An komwan, mangbayo tana namen saya, ta apabanchiw tomobo. Sichangori, panadi namen danaw inawan namen kan tana namen saw so kanen. Mayparin kami na adipen no āryaw, as dyira narana saw tana namen saya. Ki torohan mo pakono yamen so irek tan mabyay kami, as kan binyi tan myan paw maimoha namen do tana namen saya.” ");
INSERT INTO ivb_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Sinpangan na, ginatang a tabo ni Jose iyaw tana saya do Egipto tan dyira dana sa no āri. Katayitayisa a taga Egipto, ki pīlit darana sa inlāko iyaw tana da saw, ata, taywara danaw kapaychapteng. Dawa, nayparin a dyira tabo no āryaw siraw tanaw do Egipto. ");
INSERT INTO ivb_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Do dawri, do aran dino do Egipto, siraw tawotawo saw a nayparin a adipen no āri, pinayadis sa ni Jose do masngen saw a syodad a myan so agāmang tan maydaydamnay a binglayen kanen da. ");
INSERT INTO ivb_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","No moyboh a tana a dyi na ginatang ni Jose, ki tana saw no papadi saw. Machita daba ilāko, ta nāw a myan itorotoroh no āri dyira a yapod binglay na a kanen. ");
INSERT INTO ivb_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Sinpangan na, binata ni Jose dyirad tawotawo saw daw a kāna, “Sichangori, ginatang ko naynyo kontodo tana nyo saw a dyira no āri. Cha dyaw binyi nyo a imoha nyo do tana nyo saw a ginatang ni āri. ");
INSERT INTO ivb_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ki anchan magapit kamo, itoroh nyonchi di āri iyaw apagkalima naw. Iyaw mabidinaw, ki dyira nyo a binyi kan dyira nyo a kanen kan pamilya nyo.” ");
INSERT INTO ivb_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Nyaw initbay da a kon da, “Imom Gobirnador, nangisalakan dyamen tan dyi kami a nadiman. Dawa, mayparin kami a adipen no āri, kan chahwahok mo pakono yamen, mo Āpo.” ");
INSERT INTO ivb_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Dawa, pinayparin ni Jose a linteg do Egipto iyaw no apagkalima no tabo a āpit, ki dyira no āri. Aran sichangori, ki komwan paw mawnonotan. Siraw tana lang no papadi saw dya inhap no āri. ");
INSERT INTO ivb_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Siraw Israelita mana siraw kapotōtan ni Jakob, minyan sa do Egipto do tana a mayngaran so Gosen. Bomnaknang sa daw, as taywara nayparo anak da. ");
INSERT INTO ivb_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","As si Jakob, ki minyan so asa poho pa kan papito a katawen do Egipto. Iyaw kanaro no byay na, ki narapit naw asa gasot kan apat a poho, kan papito a katawen. ");
INSERT INTO ivb_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Do kasngen danaw no kadiman na, pinatawag na si Jose a anak na, as nakabata na sya a kāna, “An chakey mo a ipaboyaw kāsi mo dyaken, pangayen mo tanoro mwaya do payawan dayan padang kwaya a pangilasinan a tongpalen monchiw akdawen ko dyimo. Ikari mo a itabon mwaba yaken do dya Egipto. ");
INSERT INTO ivb_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Anchan madiman ako akmas kapoonan ko saw, chakey ko a itabon monchi yaken do nakaitabonan daw. Dawa, ikaro monchi yaken do Egiptwaya tan yangay mo yaken daw a itabon.” Tominbay si Jose a kāna, “On mo Āmang, tongpalen konchiw nawri.” ");
INSERT INTO ivb_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ki binata ni Jakob a kāna, “An komwan, ikari mo a parinen mo.” Dawa, inkari ni Jose. Do dawri, inigpet ni Jakob sarokod naw a pangtengel nas inawan na, as nagdaydayaw do Dyos. ");
INSERT INTO ivb_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Naynam aba, do asa karaw, nadamag ni Jose a maganyit si āmang na. Inhap na saw dadwaw a pōtot na a sa Manases kan Epraim, as nakangay da do yanan āmang na. ");
INSERT INTO ivb_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Do nakadamagaw sya ni Jakob a nawara si Jose a anak na, pinilit naw inawan naw a maydisna do katri naw. ");
INSERT INTO ivb_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Binata ni Jakob di Jose a kāna, “Napaboyaw dyaken iyaw Manakabalin a Dyos do kachwaw do kayan kwaw do Los do tana no Kanaan, as dawriw nangbindisyonan na dyaken. ");
INSERT INTO ivb_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Binata no Dyos dyaken a kāna, ‘Torohan konchimo so aro a pōtot mo tan payparinen ko sanchiw kapotōtan mo a aro a nasyon. Itoroh konchiw nyaya tana a dyira dan kapotōtan mo a abos pandan.’” ");
INSERT INTO ivb_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Tinongtong ni Jakob naychirin a kāna, “Imom Jose, ibidang ko sa a anak ko siraw dadwaya mahahakay a pōtot mo a nayanak do Egiptwaya sakbay a nangay ako dya. On, ibidang ko a dyaken dana sa Epraim kan Manases a akmas Ruben kan Simeon. ");
INSERT INTO ivb_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ki an myan pa sanchiw somarono dyira a maipōtot mo, ki dyira mo. As maynamot do tana a matawid danchi, ki yapo dananchi da Epraim kan Manases iyaw tawid da. ");
INSERT INTO ivb_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Parinen ko nyaya a maynamot di Rakel a ānang mo. Ta do nakapaybidi kwaw a yapod Mesopotamya, taywara nagmamamyo ako do kayam namen, ta nadiman si ānang mo a baket ko do tana a Kanaan a masngen do idi a Eprata. Dawa, intanem ko daw do bitaw no rarahan a komwan do Eprata.” Betlehem dana sichangori iyaw Eprataw do kaychowa. ");
INSERT INTO ivb_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Do nakaboyaw sya ni Jakob siras dadwaw a pōtot ni Jose a mahahakay, inyahes na a kāna, “Sino saw nyaya kamotdehan?” ");
INSERT INTO ivb_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Initbay ni Jose a kāna, “Siraw nya, mo Āmang, intoroh no Dyos a motdeh ko do kayan kwaya do dya.” Binata ni Jakob dya a kāna, “Pasngenen mo sa dyaken tan bindisyonan ko sa.” ");
INSERT INTO ivb_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Binata ni Jakob komwan a maynamot ta makaboya paba do kamalkem na. Dawa, pinasngen sa ni Jose dyaw motdeh na saw. Kinepkep sa ni Jakob, as nakadadek na sira. ");
INSERT INTO ivb_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Binata ni Jakob di Jose a kāna, “Polos a hahawen ko paba mirwa ta mayboya. Ki maynamot do kāsi no Dyos, naboya ko paymo a aran sira paw motdeh mo saya.” ");
INSERT INTO ivb_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Katayoka na, pinabawa ni Jose saw anak naw a yapo do masngenaw do tōd ni Jakob, as nakapagrokob na do ratag do salapenaw ni āmang na a mangipaboya so kapagdayaw na dya. ");
INSERT INTO ivb_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Sinpangan na, pinaydogod ni Jose si Epraim do anmwaw no kaholi a tanoro ni Jakob, as si Manases do kawanan naw. ");
INSERT INTO ivb_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ki pinaytopdis ni Jakob tatchay na saw, as pinalapaw naw kawanan naw do ohwaw ni Epraim a ādi na. As pinalapaw naw kaholyaw a tanoro na do ohwaw ni Manases a matoneng. ");
INSERT INTO ivb_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Katayoka na, binindisyonan san Jakob, as binata na a kāna, “No Dyos pakono a dinaydāyaw da simna āpong ko a si Abraham kan āmang ko a si Isaak, ombindisyon dyinyo. On, iyaw Dyosaya a nangaywan dyaken a nanda sichangori, ");
INSERT INTO ivb_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","iya paw Anghilaw a nangisalakan dyaken do tabo a marahet. Iya pakono ombindisyon siras dadwa saya a anak mo. As maynamot dyirad dadwa saya, polos pakononchi a dya mawayakan ngaran ko kan ngaran da simna āpong kos Abraham kan si Isaak a āmang ko. Mayparo pakononchiw kapotōtan da do hapotayan tana.” ");
INSERT INTO ivb_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Nagmamayo si Jose do kaboya naw a iyaw kawananaw a tonoro ni āmang naw, pinalapaw na do ohwaw ni Epraim. Dawa, inigpet naw tanorwaw ni āmang na tan paydisen na do ohwaw ni Manases. ");
INSERT INTO ivb_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Binata ni Jose a kāna, “Komwan aba, mo Āmang, ta nyaw matoneng. Iyaw machita a palapawan mo so kawananaya tanoro mo.” ");
INSERT INTO ivb_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ki maskeh si āmang na, as binata na a kāna, “On mo anak ko, chapatak ko. Masisita panchiw kapotōtan ni Manases. Ki alit na, mimyan paw kapotōtan no ādi naya, ta mayparin sanchi a aro a nasnasyon.” ");
INSERT INTO ivb_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Binindisyonan na sa do dawri a araw. Binata na pa a kāna, “Siranchiw ngaran nyo a dadwaw, osaren dan Israelita saw a kapotōtan ko an mangbindisyon sa. Batahen danchi a, ‘Payparinen na pakono inyo ni Āpo Dyos a akmas pinarin na da Epraim kan Manases.’” Dawa, pinanoma na si Epraim kan Manases. ");
INSERT INTO ivb_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Katayoka na, binata na di Jose a kāna, “Maboya mo a makey dana mawsep byay ko. Ki aran komwan, myan anchiw Dyos dyinyo, as paybidyen anchinyo do tana a Kanaan a dyira no kapoonan ta saw. ");
INSERT INTO ivb_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ta sirabaw kakakteh mo, an dya imo iyaw panorohan ko so tana a Sikem a inhap ko dyirad Amorreo saw a tawotawo maynamot do bahayang kan pana ko.” ");
INSERT INTO ivb_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Katayoka na, tinawagan sa ni Jakob siraw anak naw a mahahakay, as binata na a kāna, “Maypasngen kamo dyaken, ta ibahey ko iyaw maparin dyinyo do masakbayan. ");
INSERT INTO ivb_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Inyo a anak ko, maypasngen kamo ah. Sichangori, adngeyen nyo yaken a āmang nyo. ");
INSERT INTO ivb_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, imo matoneng. Imo akmay kayit ko, ta imo no dāmo a anak ko a yanan hahawen ko a kayit no kapotōtan ko sa a somarono. Imo iyaw kadadayāwan kan katotorayan dyirad tabo a kamotdehan ko. ");
INSERT INTO ivb_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ki akma kay ranom a dya mabengbeng, ta maigpet mwabaw inawan mo. Inoknod mo iyaw minabakes kwaw. On, linaposan mo iyaw ngaran ni āmang mo. Dawa, imo pabanchiw kasisitaan. ");
INSERT INTO ivb_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","As inyom Simeon kan Lebi, ki mayengay kamo, ta pirmi a asoten nyo bahayang nyo a mamarin so marahet. ");
INSERT INTO ivb_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Aysa! Machibawa ako do marahet saya tolag nyo. Machiraman akwaba do sililimed saya a pagsarsaritaan nyo, ta mangdimdiman kamo so tawo do soli nyo, as kan sisyabaken nyo sa bongbonghwen baka saw do katangsit nyo. ");
INSERT INTO ivb_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Mabay kamo pakono do kasosolihen nyowaya. Mabay kamo pakono do karanggas nyowaya, ta taywara kamwaya so karanggas. Paychawpiten sanchi ni Āpo kapotōtan nyo do tana dan kakakteh nyo, as kan abanchiw mismo a tana nyo. ");
INSERT INTO ivb_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Imom Joda, dayāwen danchimo no kakakteh mo saya. Abāken mo saw kabōsor mo, as rokrokoban danchimo no kakakteh mo saya. ");
INSERT INTO ivb_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Akma kaw bomaro a lion, mo Joda a somnabat a yapod nangdimanan mos kanen mo. On, akma kaw lion a mayyenenet kan maypoktad. Abaw makaitored a mangriribok dyimo. ");
INSERT INTO ivb_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Igpet monchim Jodaw baston no āri, as nāw na magtoray kapotōtan mo saw mandanchan kawara no oyod a Āri, ta iyanchiw tongpalen no tabo a tawotawo do bilbilin na. ");
INSERT INTO ivb_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Igālot monchiw asno mo do atngehaw no obas, as kaigalot monchis orbon naw do kagaganayan a yangaw no obas. Akmanchiw maparin a paybasabasan so laylay mo mabaya a palek a yapod asoy no obas a maynamot do kāronchin asi na. ");
INSERT INTO ivb_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Mabahebaheng anchiw mata mo kan palek, as maydaydak nyipen mo kan gātas maynamot do kāron maganay a kanen mo. ");
INSERT INTO ivb_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Imom Sabolon, ki omyan kanchi do payis no kanayan. Do banwa mo, maganay a pagpondwan danchin gapor. As no tana mo, ki makarapit anchi do Sidon. ");
INSERT INTO ivb_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Imom Issakar, akma kay mayit a asno a pirmi a maypoktad do payapayawan no pagkargaan na. ");
INSERT INTO ivb_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ki an maboya mo a maganay paynaynahahan mwaw kan makaay-ayo tana mwaw daw, maybobokot kanchi a mayrara so marahmet, kan ipaitoray monchiw inawan mo do kapaytarabako a inkapilītan. ");
INSERT INTO ivb_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Imom Dan, itorayan mo sanchiw tawotawo mo a akmas kadwan saw a gropo a kapotōtan ni Israel. ");
INSERT INTO ivb_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Akma kanchiw marem do bīt no rarahan a manonyit so kokod no kabalyo tan masday nakasakayaw a mayhaharag do tana. ");
INSERT INTO ivb_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Imom Āpo, hahawen ko iyaw kapangisalakan mo dyamen. ");
INSERT INTO ivb_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Imom Gad, myan anchiw bonggoy no tolisan a mangraot dyimo, ki lakalakatan mo sanchi a gobaten. ");
INSERT INTO ivb_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Imom Aser, mapahtot anchiw tana mo so aro a maganay a āpit. Yapod āpit saya, maitoroh monchiw maimas a kanen a akmas kanen dan aāri. ");
INSERT INTO ivb_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Imom Neptali, akma kaw ogsa a siwayawaya. Mapipintas sanchiw pōtot mo. ");
INSERT INTO ivb_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Imom Jose, akma kay awat a naimoha do payis no akbod. Maasiw awataw, kan romapit yangayangaw naw do bīt no ahad. ");
INSERT INTO ivb_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Raoten danchi imo no kabōsor mo saw a maranggas, as lakatan danchi imo a panahen, ta taywara ipsok daymo. ");
INSERT INTO ivb_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ki mahodyihodyi abaw bai mwaw a igpet mo, kan mayit tatchay mo a maynamot do sidong no Mabīleg a Dyos ni Jakob a iyaw Mangipaspastor kan iyaw Mangay-aywan so Israel. ");
INSERT INTO ivb_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","On, sidongan anchimo no Dyosaya a dayāwen ko a āmang mo. Iyaw Manakabalin a Dyos, mangbindisyon dyimo. Bindisyonan naymo so chimoy a yapod hanyit kan ranom a yapod irahem no tana. Bindisyonan na paymo do aro a binyay kan kamotdehan mo. ");
INSERT INTO ivb_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ta mabosboslon nakabindisyon na dyaken ni Āpo Dyos kan siraw aāmang ko saw. Masaw a nāw na dyaken bindisyon naya a dya madyiwadyiway a kayarig nad nanoma saya paytoytokonan a dya mabdibdis. On, omyan pakono nya bindisyon dyimom Jose, imo a napidi dyirad tabo a kakakteh mo. ");
INSERT INTO ivb_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Imom Benhamin, akma kay asa binyay a mayngaran so lobo a maranggas. An maraw, pirmi ka maychichwas so dimanen mo a kanen, as an mahep binglayen mo ināgaw mwaw.” Nyaw binata ni Jakob. ");
INSERT INTO ivb_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Siraw nyaw nayparin a asa poho kan dadwa a bonggoy a kapotōtan ni Israel mana Jakob. Nyaw inbahey ni āmang da do kabindisyon naw so katayitayisa dyira sigon do omnwaw a pamakada na a ichirin do katakatayisa dyira. ");
INSERT INTO ivb_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Katayoka na, binilin ni Jakob anak na saw a kāna, “Changori, makey ako na madiman a machasa dyirad kapoonan ko saw. Itabon nyonchi yaken do nakaitabonan daw no kapoonan ko saw do aschipaw do bengkag ni Epron a Heteo. ");
INSERT INTO ivb_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Iyaw nyaya aschip, ki myan do bengkag do Makpela do dayāen logar a Mamre do tana Kanaan. Ginatang ni Abraham nyaya aschip kan bengkag di Epron a Heteo a pangitabonan. ");
INSERT INTO ivb_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Dawriw nakaitabonan da Abraham kan Sara a baket na. As dawri paw nakaitabonan da Isaak kan Rebekka. As dawriw nangitabonan kos Lea. ");
INSERT INTO ivb_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Nagatang nyaya bengkag kan aschip dyirad Heteo saw a tawo kaychowa pa.” ");
INSERT INTO ivb_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Do katayokaw no kapamilbilin ni Jakob, minirwa naypoktad do katri naw, as nawri danaw nakabitosan no anges na. ");
INSERT INTO ivb_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Kinepkep ni Jose si āmang na a tomnanyitanyis, kan dinadek naw ropa naw. ");
INSERT INTO ivb_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Katayoka na, binilin ni Jose siraw mangbalsamar saw tan balsamaren da si āmang na. Dawa, binalsamar da. ");
INSERT INTO ivb_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Apat a poho a karaw iyaw pinarin da, ta nyaw gagāngay a kahay no kapagbalsamar. Nagmanmanto saw taga Egiptwaw so papito a poho a karaw a maynamot do nakadiman ni āmang ni Jose. ");
INSERT INTO ivb_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Do katayokaw no chimpo no nakapagmanto da, binata ni Jose dyirad opisyalis saw no āri a kāna, “Chāsi nyo pa yaken, ta ibahey nyo nya saya chirin ko di āri a kon nyo, ");
INSERT INTO ivb_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Do kakalo a madiman ni āmang ko, pinagkari na yaken a itabon ko do tanem na a inpakadi na do aschipaw do tana a Kanaan. Dawa, palobosan mo pakono yaken a mangay a mangitabon si āmang ko. Ara, ta maybidi akonchi.’” ");
INSERT INTO ivb_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ki nyaw inbahey no āryaw a kāna, “On, yangay mo a itabon si āmang mo a akmas inkari mo dya.” ");
INSERT INTO ivb_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Do dawri, inyangay ni Jose a intabon si āmang na. Minonot sa di Jose a mangay do Kanaan tabo opisyalis saw no āri, siraw panglakayen saw do palasyo na, as kan siraw tabo pangpangolwen saw do Egipto. ");
INSERT INTO ivb_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Minonot saw tabo a pamilya ni Jose, siraw mahahakay a kakakteh na kan tabo a pamilya ni āmang na. Sira danaw adedekey da saw kan siraw karniro, kalding, kan baka da saw nabidin do tana a Gosen. ");
INSERT INTO ivb_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Myan pa saw kadwan a nagkabalyo kan nachisakay do karison a minonot di Jose. Taywaraw kāro no bonggoy da. ");
INSERT INTO ivb_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Do nakapakarapit daw do pangir-irekan daw do Atad do dāya naw do Oksong a Jordan, kinalyak daw nagdongdong-aw. Do dawri, papito a karaw a pinarin ni Jose iyaw dadakay daw a kapagdongdong-aw. ");
INSERT INTO ivb_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Do nakaboya daw no omidiaw do Kanaan so nyaya kapagdongdong-aw da do Atad, binata da a kon da, “Taywaraya makapaynyin nyaya a kapagdongdong-aw no taga Egipto saya.” Dawa, nayngaran nawri a logar do dāya nad Jordan so Abel Misraim. ");
INSERT INTO ivb_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","As dawa, pinarin dan mahahakay saw a anak ni Jakob iyaw inbilin naw dyira, ");
INSERT INTO ivb_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","ta inyangay daw bangkay naw do tana a Kanaan, as intabon da do aschipaw a myan do bengkag do Makpela do dayāen logar a Mamre. Iyaw nya aschip kan bengkag, ginātangaw ni Abraham di Epron a Heteo tan payparinen na pagtatanman. ");
INSERT INTO ivb_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Katayoka ni Jose a nangitabon si āmang na, naybidi do Egipto kontodo siraw kakakteh na saw kan siraw tabo tawotawowaw a minonot dya do kaitabon ni āmang na. ");
INSERT INTO ivb_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Katayoka no nakadimanaw ni āmang da, namo saw mahahakayaw a kakakteh ni Jose. Binatabata da a kon da, “Angwan ari pa yaten ni Jose a ipsok, as bahsen na yaten do marahetaw a pinarin ta dya do kachwaw?” ");
INSERT INTO ivb_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Dawa, nyaw inpaibahey da di Jose, “Sakbay a nadiman si Āmang, ");
INSERT INTO ivb_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","inbilin na dyamen a ibahey namen dyimo nya a kāna, ‘Pakawanen mo pakono saw mahahakay a kakakteh mo do gatos da dyimo kan do marahetaw a pinarin da dyimo do kachwaw.’ Dawa, chāsi mo pa yamen, yamen a tobotoboyen no Dyos ni āmang mo, ta pakawanen mo pa yamen do gatos namen dyimo.” Tomnanyis si Jose do nakadamag naw so nyaya. ");
INSERT INTO ivb_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Sinpangan na, mismo dana siraw kakakteh naw nangay di Jose, as nagrokob sa do tana do salapen na. Binata da a kon da, “Cha kami dya a mayparin a adipen mo.” ");
INSERT INTO ivb_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Binata ni Jose dyira a kāna, “Mamo kamwaba, ta polos a dyi kwa salsalyan chakey no Dyos. ");
INSERT INTO ivb_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Panggep nyo mamarin so marahet dyaken do kachwaw, ki pinayparin no Dyos a maganay a akmas naparinaya changori tan dya madiman riniwriw a tawotawo do kapteng. ");
INSERT INTO ivb_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Dawa, abaw chamo nyo, ta yaken makatoneng dyinyo kan siraw kamotdehan nyo.” Do dawri, napakaro iyaw kāmo da do dyaya inbahey ni Jose dyira do makahwahok saw a chirin na. ");
INSERT INTO ivb_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Tinongtong ni Jose iyaw minyan do Egipto kontodo saw tabo a pamilya ni āmang na. Magtawen so asa gasot kan asa poho do kadiman na. ");
INSERT INTO ivb_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ki sakbay no kadiman na, naboya ni Josew apōko na saw do toben yapod siraw pōtotaw ni Epraim. As do kaiyanak dan apōko naw do tōd a siraw pōtotaw ni Makir a mahakay a pōtot ni Manases, sinapnyi sa ni Jose, ta nawriw dadakay da a rawaten da do pamilya da. ");
INSERT INTO ivb_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Do asa karaw, binata na dyirad kakakteh na saw a kāna, “Makalo danaw kabitos no anges ko. Ki aran komwan, chapatak ko a no Dyos masigorādo a mangaywan dyinyo. Ikaro nanchinyo do dya a tana, as paybidihen nanchinyo do tanaw a inkari na da simna Abraham, Isaak, kan Jakob.” ");
INSERT INTO ivb_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Katayoka na, pinagkari na saw mahahakayaw a kakakteh na a kāna, “Masigorādo ko a no Dyos, ki mangaywan dyinyo, as anchan pabidihen naynyo do dawri a tana, ikari nyo dyaken a panawbi nyonchi iyaw bangkay ko.” ");
INSERT INTO ivb_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Nadiman si Jose do kapagtawen na so asa gasot kan asa poho. Binalsamar da iyaw inawan na, as nakailongon da sya do Egipto. 22:14 Do chirin Hebreo, ki “Jehoba-jireh.”");
INSERT INTO ivb_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Do chimpo dan ok-okom a mangitoray do tana a Israel, myan kapaychapteng do tana daw. Do dāwri, myan asa a mahakay a taga Betlehem do irahem no sākop no Joda a nangay a minyan do tana a Moab kontodo si baket na kan dadwaw a pōtot na a babbaro. ");
INSERT INTO ivb_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Elimelek iyaw ngaran nya mahakay. Noemi iyaw ngaran baket na, kan Mahalon kan Kilion iyaw ngaran dan babbaro da saya. Iyaw nya pamilya, ki yapo do partīdos dan kapoonan ni Eprata a minyan do idi a Betlehem do sākop no Joda. Ki do dāwri a chimpo, nayadis sa Elimelek do tana a Moab kan minyan sa daw. ");
INSERT INTO ivb_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Do dawri, nadiman si Elimelek kan natokos si baket na a si Noemi kontodo dadwa saw a pōtot na a mahahakay. ");
INSERT INTO ivb_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Siraw dadwaw a pōtot na a mahahakay, ki nangabahay sa so mababakes a Moabita. Orpa iyaw ngaran asaw, kan si Roth iyaw ngaran asaw. Minyan sa do Moab so sigoro asa poho a katawen. ");
INSERT INTO ivb_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Sinpangan na, nadiman si Mahalon kan Kilion. Dawa, si Noemi lang a bālo natokos, ta aran siraw dadwaw a anak na a mahahakay, ki nadiman sa. ");
INSERT INTO ivb_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Do dāwri, do kayan paw ni Noemi do Moab, nadāmag na a si ĀPO, ki binindisyonan na saw tawotawo naw do Joda, ta āro danaw āpit daw. Dawa, nagrobwat si Noemi a komaro do Moab a maybidi do mismo na a tana kontodo siraw dadwaw a manōgang na. ");
INSERT INTO ivb_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Komnaro sa yapo do yanan daw, kan nanakey sa a maybidi do tana a Joda. ");
INSERT INTO ivb_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Ki do kayan daw do rarahan, binata ni Noemi dyirad dadwaw a manōgang na a kāna, “Inyo a anak ko, maybidi kamo na do bōkod nyo a inyapwan. Nolay nyo naw machangay dyaken. Sichangori, si ĀPO pakono mangbindisyon dyinyo do maganayaya a pinarin nyo dyaken a akmas pinarin nyowaw dyirad lalakay nyo saw a nadiman. ");
INSERT INTO ivb_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Si ĀPO pakono manoroh so bindisyon dyinyo tan mirwa kamo a makakabahay kan mangnānam so ragsak do bayo a pamilya nyo.” Do dāwri, dinadek na sa ni Noemi a pagpakāda na dyira, ki nakalyak sa a tomnanyis dadwaw a manōgang na, ");
INSERT INTO ivb_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","kan binata da dya a kon da, “Enggam ānang, machangay kami dyimo a maybidi dyirad kakabagyan mo saw.” ");
INSERT INTO ivb_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Ki initbay ni Noemi a kāna, “Inyo a anak ko, maybidi kamo na. Āngo hahawen nyo an machangay kamo dyaken? Maymanganak ako pawri so mahahakay a tādi dan lalakay nyo saw? ");
INSERT INTO ivb_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","On, maybidi kamo na, inyo a anak ko. Aysa, bakbaketan ako naya, kan maparin ako paba mangabahay. Aran myan paw hahawen ko a machoknod sichahep tan maymanganak akos dadwa a mahahakay, ");
INSERT INTO ivb_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","mapanaya nyoriw kapaypabaro da? Baywan nyoriw inawan nyo a mirwa a mangabahay? Maparin abaw komwan anak ko. Makpad danaw byay ko kan chakey kwaba matahaman nyo, ta tinadyichokodan na yaken ni ĀPO.” ");
INSERT INTO ivb_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Do dāwri, minirwa dana sa a tomnanyis. Nakatayoka na, dinadek ni Orpa si katogāngan na, as nakapagpakāda na. As si Roth, ki nāw na nachikepkep di katogāngan na. ");
INSERT INTO ivb_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Ki binata ni Noemi dya a kāna, “Chiban pas abīrat mo. Maybidyaya dyirad kakabagyan na saw kan siraw dyos na saw. Machonot kabawri dya?” ");
INSERT INTO ivb_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Ki initbay ni Roth a kāna, “Pilīten mwaba yaken a mangkaro dyimo mana maybidi a dya machangay dyimo, mo ānang. Aran dino ngayan mo, machangay ako, as aran dino pagyanan mo, dawriw pagyanan ko. Siraw kakabagyan mo, ki mayparin sanchi a kakabaygan ko, as kan iyaw Dyos mo, ki Dyos ko. ");
INSERT INTO ivb_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Aran dino kadimanan mo, dawrinchiw kadimanan ko, kan dawrinchiw pakaitaneman ko. Si ĀPO pakono mangdōsa dyaken an ipalōbos ko a myan mapaysyay dyaten malaksid do kadiman ko.” ");
INSERT INTO ivb_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Do nakaboyaw ni Noemi a dyi dana matadyan kapangtokto ni Roth a machangay dya, ninonolay narana. ");
INSERT INTO ivb_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Dawa, siraw nya dadwa a mababakes, ki tinongtong daw nanakey a manda do Betlehem. Do nakapakarapit daw do Betlehem, nasdaāwan tabo a omidi daw, kan sira danaw yanan dangoy da. As siraw mababakes saw do dawri a idi, ki naysin-iiyahes sa a kon da, “Oyodori a iya si Noemi?” ");
INSERT INTO ivb_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Binata ni Noemi dyira a kāna, “Tawagan nyo paba yaken so Noemi, basbāli tawagan nyo na yaken so Mara, ta iyaw Dyos a Manakabalin do Tābo, ki taywara a pinaypakpad naw byay ko. ");
INSERT INTO ivb_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Do nakakaro ko dya, myan tabo pamilya ko, ki pinaybidi na yaken ni ĀPO kaynaynawan ko na. Āngo ta tawagan nyo pa yaken so Noemi? Si ĀPO, iyaw Dyos a Manakabalin do Tābo, ki pinasabhayan na yaken so taywara a marahmet do byay ko.” ");
INSERT INTO ivb_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Komwan nakapaybidi ni Noemi yapo do tana a Moab kan nachonot dya si manōgang na a si Roth a Moabita. Do nakapakarapit daw do Betlehem, kasiknan pan kapagāpit da so sebāda. ");
INSERT INTO ivb_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Do dawri a idi, myan asa kabagyan ni Noemi a yapo do partīdos ni Elimelek a lakay na. Iyaw nya kabagyan na a mayngaran so Boas, ki mabaknang kan mabigbigbig a tawo. ");
INSERT INTO ivb_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Do asa a karaw, binata ni Roth a Moabita di Noemi a kāna, “Ānang, palobōsan mo pa yaken a mangay do kadwan saya a bengkag dya, ta an myan makey do akin dyiraw so bengkagaw, ki somdep ako a mangabābas.” Initbay ni Noemi dya a kāna, “Na, mangay ka anak ko ah.” ");
INSERT INTO ivb_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Dawa, nangay si Roth do bengkag saw, as kan insiknan naranaw nangabābas do nakayapwan daw no magrānyi saw. No naparin, ki nairana a nangayan naw bengkagaw a dyira ni Boas a yapo do partīdos ni simna Elimelek a katogāngan na. ");
INSERT INTO ivb_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Nahay abas dēkey, nawara si Boas a yapo do Betlehem kan napakatoneng dyirad magrānyi saw daw a kāna, “Si ĀPO pakono myan dyinyo!” Tominbay sa a kon da, “Aran imo, si ĀPO pakono myan dyimo!” ");
INSERT INTO ivb_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Sinpangan na, inyahes ni Boas do pangōlo daw no magrānyi saw a kāna, “Nakayapwan na pamilya no nawri a balāsang?” ");
INSERT INTO ivb_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Inatbay no mangipangōlwaw dyirad magrānyi saw a kāna, “Iyaw nawri a mabakes, ki iyaw Moabitaw a nachangay di Noemi a somnabat a yapo do Moab. ");
INSERT INTO ivb_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Inakdaw naw pamalōbos dyaken a mangabābas do nakayapwan daya no magrānyi saya. Do nakawara naw, dinitā naranaw naytarabāko yapo pa kabekas a mandas changori malaksid do nakapaynahah naw kaychis dēkey do bengbeng.” ");
INSERT INTO ivb_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Do dāwri, nangay si Boas di Roth, kan binata na dya a kāna, “Ādi, adngeyen mo pa yaken. May kaba a mangabābas do matarek a bengkag mana komaro kaba dya. Machikayban ka na dyirad mababakes saya a maytarabāko dya. ");
INSERT INTO ivb_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Kapyahen mo a chiban yanan dan magrānyi saya kan onotan mo sa, as kan machikayban ka dyirad mababakes saw. Binilin ko saw babbarwaw a dyi daymo a ririboken. An mawaw ka, tod ka mangay a minom do pinoranom da saw no babbaro saw.” ");
INSERT INTO ivb_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Do nakadngeyaw ni Roth so nyaya, nagrokob do tana, kan binata na di Boas a kāna, “Āngo naparin ko a kadawan mo dyaken a asa ako lang a gan-ganaet?” ");
INSERT INTO ivb_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Ki initbay ni Boas a kāna, “Nadāmag ko a maynamot do tabo a kaparin mo di katogāngan mo yapo do nakadiman lakay mo. On, nadāmag ko pa an maypāngo nakakaro mo siras inyapwan mo kan mismo a tana mo tan mangay a machiyan do tawotawo a istranghiro dyimo. ");
INSERT INTO ivb_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Si ĀPO pakono manggon-gona dyimo do maganay saw a kaparin mo. On, maboslon pakono gon-gona mo a yapo di ĀPO a Dyos no Israel, ta nachikāmit ka dya a akmay pyek a nagpasalokob do opa.” ");
INSERT INTO ivb_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Tominbay si Roth a kāna, “Myan pakono dyaken pakatongtongan no pakahwahokan mo, mo āpo, ta inahwahok mo yaken, kan naychirin ka dyaken so maganay a aran mabwabodis saad ko kan siraw maytarabākwaya dyimo.” ");
INSERT INTO ivb_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Do oras danaw no kākan, binata ni Boas di Roth a kāna, “Machihanghang ka pa dyamen mo ādi. Manghap ka pas tināpayaya, as kapadinot mo sya do somnokaya a palek.” Dawa, naydisna si Roth a nachitalin dyirad magrānyi saw. Do dāwri, nanoroh si Boas so pilīpig di Roth. Komninan a mandad nakabsoy na, ki myan paw panda na. ");
INSERT INTO ivb_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Do nakakarwaw ni Roth a maybidi a mirwa a mangabābas, inbilin ni Boas dyirad maytarabāko na saw a kāna, “Palobōsan nyo iya a mangpeh so dāwa a aran do yanan naposot saw a rinānyi, kan baywan nyo aba, ");
INSERT INTO ivb_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","basbāli a oyoten nyo kadwan saw a dāwa yapo do naposot saw a rinānyi, kan talnonoyen nyo para dya. Paydabdab nyo aba ah.” ");
INSERT INTO ivb_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","As dawa, nangabābas dana si Roth a manda do kapaysarisari. Katayoka na, inbāot naw inabābas naw, ki nakakpeh so irek a makalo a anem a kasalop. ");
INSERT INTO ivb_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Insoson naw irekaw a insabat do idi. Do nakawara naw, inpaboya naw kāron insabat naw di katongāngan na. Intoroh na paw pilīpigaw a panda na do nakapachakan naw. ");
INSERT INTO ivb_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Inyahes ni katogāngan na a kāna, “Dino nagabābasan mo sicharaw? Sino akin bengkag so naytarabākwan mo? Si ĀPO pakono mangbindisyon so nawri a tawo a nangbigbig dyimo.” Inpadāmag ni Roth di katogāngan naw maynamot do mahakayaw a akin bengkag so naytarabākwan naw a kāna, “Iyaw mahakayaw a akin bengkag so naytarabākwan kwaw sicharaw, ki mayngaranaw so Boas.” ");
INSERT INTO ivb_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Tinbay ni Noemi iyaw manōgang naw a kāna, “Si ĀPO pakono mangbindisyon di Boas! Si ĀPO, ki manginonolay aba, ta tadyichokodan na sabaw sibibyay kan nadiman dana.” Innāyon na pa a kāna, “Nawri a mahakay, ki asa masngen a kabagyan ta. Iya, ki asa dyirad myanaw so rebbeng a mangaywan do pamilya ta.” ");
INSERT INTO ivb_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Do dāwri, binata ni Roth a Moabita a kāna, “Myan paw binata na dyaken a ‘Machikayban ka dyirad maytarabāko ko saya a mandad katayoka tābon kapagrānyi ko,’ kāna.” ");
INSERT INTO ivb_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Tinbay ni Noemi si Roth a kāna, “On mo anak ko, maganaganay an machikayban ka dyirad maytarabāko saw a babbalāsang dya, ta an do matarek a bengkag, angwan myan mangranggas dyimo.” ");
INSERT INTO ivb_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","As dawa, nāw ni Roth a nachipaytarabāko dyirad babbalāsang saw a trabahador ni Boas a mangabābas nanda do katayokaw no kapagrānyi so sebāda kan trigo. Ki kāda mahep somabasabat do yanan katogāngan na. ");
INSERT INTO ivb_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Do asa karaw, binata ni Noemi di Roth a kāna, “Anak ko, rombeng a sidongan koymo a mirwa a mangabahay kan paysonongen ko kayayan mo, tan myan danaw bōkod mo a pamilya. ");
INSERT INTO ivb_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Kabagyan tabawri si Boas a nachipaytarabākwan mo a myan so trabahador a babbalasang? Adngeyen mo yaken. Sichahep mangay anchi si Boas a maytahep so sebāda do pangirkan naw. ");
INSERT INTO ivb_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","May ka mariyos, as kapagbangbanglo mo, as kapaylaylay mos mapintāsaw. Katayoka na, may ka do pangirkan naw, ki mapaboya kaba dya ah, mandad katayoka na koman kan minom. ");
INSERT INTO ivb_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Do oras naw anchi a makaycheh, siimen mo a maganay an dino paypoktadan naw. Anchan nakaycheh dana, takasan mo kokod naw, as kapaypoktad mod tokaran naw. Ibahey nanchi dyimo an āngo parinen mo.” ");
INSERT INTO ivb_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Inatbay ni Roth si katogāngan na a kāna, “On mo ānang, tabo inbahey mo dyaken, parinen ko.” ");
INSERT INTO ivb_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Dawa, nangay do pangirkan naw, kan pinarin naw tabo a akmas inbaheyaw ni katogāngan na dya. ");
INSERT INTO ivb_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Do nakatayokaw ni Boas a komninan kan mininom, nadidiw naw kapnek. Dawa, nangay a naypoktad do payisaw no yananaw no inopo da a rinānyi, as kan nakaycheh daw. Do dāwri, nakanapyek si Roth a nangay do yanan ni Boas kan tinakasan naw kokod naw, as nakapaypoktad na do tokaran naw. ");
INSERT INTO ivb_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Do kaabak no mahep, myan naychihat a nakayokayan ni Boas. As do kapaybadyichid naw, nadlaw naw mabakesaw a naypoktad do tokaran naw. ");
INSERT INTO ivb_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","“Sino ka?” inyahes na. “Yaken si Roth a adipen mo, mo āpo,” inatbay na. “Maynamot ta imo kabagyan lakay ko, imo myan so rebbeng a mangalāngon dyaken. Dawa, kabahayen mo pa yaken.” ");
INSERT INTO ivb_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Binata ni Boas a kāna, “Si ĀPO pakono mangbindisyon dyimo, mo ādi. Mangamangay a adayo nakaipaboya mwaya so kapodno mo dyamen a kakabagyan mo kan pinarin mwaya di katogāngan mo. On, ta linakatan mo saba pachikabahayan babbaro saya a aran mabakbaknang mana mapobpobri sa kan yaken. ");
INSERT INTO ivb_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Sichangori, mo ādi, mabakel kaba. Parinen konchiw tabo inakdaw mo, ta tabo saw kaidyan, ki matonngan a imo, ki asa mabakes a madāyaw. ");
INSERT INTO ivb_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Ki aran oyod a yaken, ki kabagyan mo a masngen, myan paw kabagyan ta a ad-adda so kalintegan a masngesngen kan yaken a mangalāngon dyimo. ");
INSERT INTO ivb_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Myan ka pa dya sichahep. Anchan mabekas, mangay akonchi a machisarīta dya. An alangōnen na imo, ayket, maganay. Iya danaw makatoneng. Ki an chaskeh na a rawaten iyaw nyaya rebbeng dyimo, ikari ko di ĀPO a yaken dananchiw mangrawat so nya rebbeng dyimo. Dawa, maypoktad ka pa dya manda do kapaysesedang.” ");
INSERT INTO ivb_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Dawa, naypoktad si Roth do tokaranaw ni Boas a manda do kaparbangon. Ki sakbay a maysesedang, naybangon dana tan abo tawo a makabigbig dya, ta chakey naba ni Boas a myan makapatak a myan mabakes a nangay do pangirkan naw. ");
INSERT INTO ivb_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Sakbay a komnaro si Roth, binata ni Boas dya a kāna, “Pakarohen mo paw kagay mwaya, kan bolayen mo pa.” Do nakabolay naw sya, nangrokod si Boas so makalo a godwa a kaban a irek no sebāda a pinado na do kagay naw, as kan pinakachin na tan isoson ni Roth. Katayoka na, insabat ni Roth do idi. ");
INSERT INTO ivb_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Do nakasabat naranaw ni Roth, ki inyahes ni katogāngan na a kāna, “Komostaw naparin, mo anak ko?” Ki inpadāmag ni Roth tabo pinarin ni Boas dya. ");
INSERT INTO ivb_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Innāyon na a kāna, “Binata na a ‘Basta dyi ka somabat do katogāngan mo a abo isabat mo.’ Dawa, intoroh naw dyaken tabo nya a sebāda.” ");
INSERT INTO ivb_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Inatbay ni Noemi a kāna, “Panayahen mo anak ko a mandan madngey mo an āngonchiw maparin. Iyaw nya mahakay, ki maynahah abanchi a mandad katongpal nas tābo rebbengen na dyimo.” ");
INSERT INTO ivb_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Do kamabekasanaw, nangay si Boas do bīt naw no rowanganaw no idi a pagmimitingan dan tawotawo, kan naydisna daw. Nahay aba, homnabas iyaw kabagyan naw a naibahey na a mangalāngon sya. Tinawagan ni Boas a kāna, “Hoy! Anchi ka. May ka pa dya maydisna.” Ki nangay a naydisna. ");
INSERT INTO ivb_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Sinpangan na, nangrara si Boas so asa poho dyirad panglakayenaw do dawri a idi, kan inakdaw na dyira a maychadisdisna pa sa daw. ");
INSERT INTO ivb_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Katayoka na, binata ni Boas do dawri a kabagyan na a kāna, “Naybidi danaw si Noemi a yapod tana a Moab, ki maglākwaw so tana a iyaw dyiraw ni simna Elimelek a kabagyan ta. ");
INSERT INTO ivb_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","No myan do aktokto ko, ki rebbeng na a ibahey ko dyimo an chakey mo a isalākan nya tana do salapen dan maychadisdisnaya dya kan do salapen dan panglakayenaya no kaidyan ta a sistīgo ta. Ki an dyi mo a isalākan, ibahey mo dyaken tan chapatak ko. Ta imo lang maparin a manma myan so kalintegan, as kan yaken somarono dyimo.” Inatbay na a kāna, “Na! Isalākan ko ah, ta nawryayaw rebbeng ko.” ");
INSERT INTO ivb_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Ki binata ni Boas a kāna, “Do araw a gatāngen mo bengkagaw a yapod Noemi, machita kabahayen mo pa si ādi Roth a Moabita a iyaw nabālwaw tan myan maipōtot a mahakay a omtongtong so ngaranaw no nadimanaw kan tan dya mabo tanaw a tāwid no pamilya na.” ");
INSERT INTO ivb_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Do nakadngey naw so nya, binata no kabagyanaw a kāna, “Awān! An komwan, maisalākan kwabaw nawri a tana, ta matāwid dabanchi no mismo a pōtot ko.” ");
INSERT INTO ivb_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","(No dadakay da do Israel kaychowa, an myan makey a mapayadis so kalintegan na do matarek a maynamot do asa a bānag, ki itoroh naw kasmangaw no tokap na do katōlag naw.) ");
INSERT INTO ivb_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Dawa, iyaw kabagyanaw a myan so kalintegan, pinakaro naw kasmangaw no tokap na, as nakaitoroh na di Boas. Nakaibahey na sya a kāna, “Imo danaw gomātang so tanaya ah.” ");
INSERT INTO ivb_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Katayoka na, binata ni Boas dyirad panglakayenaw kan do tabo tawotawo a myan daw a kāna, “Sicharaw, inyo a tabo, ki paneknekan nyo a gatāngen ko di ākang Noemi tabo dyiran simna ākang Elimelek kan yapo da simna Kilion kan Mahalon a potōt na. ");
INSERT INTO ivb_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Kabahayen ko pa si ādi Roth a Moabita, iyaw bālwaw ni Mahalon tan myan anchiw pōtot ko a mahakay a omtongtong so ngaran naw no nadimanaw kan mangtāwid so tanaw no kapoonan na. Tan komwan, mabo abanchiw ngaran no nadimanaw do pamilya na kan do idi na. On, sicharaw inyo a tabo mangpaneknek.” ");
INSERT INTO ivb_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Do dāwri, siraw panglakayen kan siraw tabo tawotawowaw a myan do rowanganaw no idi, ki inatbay da a kon da, “On, yamen, ki sistīgo no nya. Si ĀPO pakono mangbindisyon so nawri a mabakes a kabahayen mo kan mayparin pakono a akma sa Rakel kan Lea do kaychowa a myan so āro a anak a napatnek so nasyon a Israel. Bomaknang ka pakononchi do Eprata, kan magdināmag ka pakononchi do idi a Betlehem. ");
INSERT INTO ivb_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Siraw pōtot mo a iyanak no nya mabakes a itoroh ni ĀPO dyinyo, payparinen da pakono pamilya mo akmas pamilya Pares a inyanak ni Tamar di Joda.” ");
INSERT INTO ivb_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Dawa, kinabahay ni Boas si Roth. Do nakapayoknod daw, binindisyonan sa ni ĀPO, kan nabogi si Roth. Naymanganak so mahakay. ");
INSERT INTO ivb_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Siraw mababakes do dawri a idi, binata da di Noemi a kon da, “Maidāyaw si ĀPO, ta sichangori inonolay naba imo do nakaitoroh na dyimo so apōko mo tan matongtong pamilya mo. Magdināmag pakono nya apōko mo do tabo Israel. ");
INSERT INTO ivb_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Paydamnayen nanchiw byay mo, kan aywanan nanchi imo do kabaket mo. On, inyanak no manōgang mwaya a madaw dyimo kan iya, ki mapatpateg pa kan papito a anak mo a mahahakay.” ");
INSERT INTO ivb_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Do dāwri, inhap ni Noemi iyaw apōko naw a kinepkep kan sinalobal. ");
INSERT INTO ivb_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Binata dan mababakes a kaaroba na a kon da, “Ari danaw anak a mahakay do pamilya ni Noemi.” As pinangaranan da so Obed. As si Obed, ki āmang ni Jesse. As si Jesse, ki āmang ni Āri Dabid. ");
INSERT INTO ivb_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Siraw nyaw kapotōtan ni Āri Dabid a mangrogi di Pares. Si Pares, ki āmang ni Hesron. ");
INSERT INTO ivb_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","As si Hesron, ki āmang ni Ram. As si Ram, ki āmang ni Aminadab. ");
INSERT INTO ivb_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","As si Aminadab, ki āmang ni Naason. As si Naason, ki āmang ni Salmon. ");
INSERT INTO ivb_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","As si Salmon, ki āmang ni Boas. As si Boas, ki āmang ni Obed. ");
INSERT INTO ivb_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","As si Obed, ki āmang ni Jesse. As si Jesse, ki āmang ni Āri Dabid.");
INSERT INTO ivb_vpl VALUES ("ET1_1","018_1_1","EST","1","1","1","Siraw nyaw naparin do chimpo ni Ekserses. Iyaw nya Ekserses, ki nangitoray so asa gasot, dadwa poho, kan papito a probinsya makayapod Indya a mandad Etiopya. ");
INSERT INTO ivb_vpl VALUES ("ET1_2","018_1_2","EST","1","2","2","Do dāwri a chimpo no naydisnan no trono ni Āri Ekserses, ki do Sosa a sintro no pagāryan no Persya. ");
INSERT INTO ivb_vpl VALUES ("ET1_3","018_1_3","EST","1","3","3","As do chatatdo naw a katawen nakapagtoray na, namarin so pista a para do tabo a opisyalis na kan kadwan pa a magtotoray na. Nachipista saw totorayen da saw no soldādo do Persya kan Medya kontodo gorbirnador saw kan siraw matotohos saw so saad a yapod probinsya saw. ");
INSERT INTO ivb_vpl VALUES ("ET1_4","018_1_4","EST","1","4","4","Do irahem no anem a kabohan, inpaboya naw kinabaknang no pagtorayan na, dayag, kan kapintas na. ");
INSERT INTO ivb_vpl VALUES ("ET1_5","018_1_5","EST","1","5","5","Sinpangan na, do nakatayoka danaw no nya pista, namarin paw āryaw so pista a para dyirad tābo tawotawo a omidi do Sosa, mabaknang mana mapobri. Iyaw nya pista, ki papito a karaw a naparin do atataw no palasyo. ");
INSERT INTO ivb_vpl VALUES ("ET1_6","018_1_6","EST","1","6","6","Iyaw atataw, ki nabistyan so kortina saw a mapīno a tela, maydak kan asol. Nachipong sa do hobid saw a mapīno a tela, maydak kan obi so kita, kan nailodyit sa yapo do singsing saw a pirak. Marmol saw parey saw a nakaikapetan da. Myan saw manaro a disnan a naparin do balitok kan pirak a napangay do atataw. No nya atat, ki naar-artyan so marmol, perlas, kan matatarek a kita no mangīna a bato. ");
INSERT INTO ivb_vpl VALUES ("ET1_7","018_1_7","EST","1","7","7","Naitawoy palek do bāso saw a balitok kan matatarek nakasokog da, as kan maboslon palek maynamot do kadadam ni āri. ");
INSERT INTO ivb_vpl VALUES ("ET1_8","018_1_8","EST","1","8","8","Sigon do mandar ni āri, abaw mamīlit dyira a minom, ta binilin ni āri siraw katalek naw a magsirsirbi a nolay da a minom kāda asa sigon do chakey da. ");
INSERT INTO ivb_vpl VALUES ("ET1_9","018_1_9","EST","1","9","9","Ranan na, aran si Rēyna Basti, ki namarin met so pista na a para dyirad mababakes saw do palasyo. ");
INSERT INTO ivb_vpl VALUES ("ET1_10","018_1_10","EST","1","10","10","Do chapapito naranaw a araw no pista, taywaraw kasoyot ni āri, ta nadinyat dana. Dawa, tinawagan na saw papitwaw a yonoko na a magsirsirbi dya. Siraw nya sa: Mehoman, Bista, Harbona, Bigta, Abagta, Setar, kan Karkas. ");
INSERT INTO ivb_vpl VALUES ("ET1_11","018_1_11","EST","1","11","11","Inbilin na dyira a yangay da hapen si Rēyna Basti a iparang do salapen na a sikokorona tan ipabōya naw taywaraw a kapintas ni baket na dyirad opisyalis naw kan tabo bisīta na. ");
INSERT INTO ivb_vpl VALUES ("ET1_12","018_1_12","EST","1","12","12","Ki do nakaibahey daw no magsirsirbi saw so inbilin naw ni āri di Rēyna Basti, chinaskeh naw nangay. Do dāwri, oltimo soli ni āri kan mapenpen na paba. ");
INSERT INTO ivb_vpl VALUES ("ET1_13","018_1_13","EST","1","13","13","Maynamot ta dadakay no āryaw, mangdaw so kapangtokto dan mamasirib saw maynamot do linteg kan kapangokom, nachisarīta dyirad mamagbaga naw a makapatak so kosto a maparin. ");
INSERT INTO ivb_vpl VALUES ("ET1_14","018_1_14","EST","1","14","14","No masanyib a pachisngenan āri, ki sa: Karsena, Setar, Admata, Tarsis, Meres, Marsena, kan Memokan. Siraw nyaw papito a katotohosan so saad do pagāryan no Persya kan Medya. ");
INSERT INTO ivb_vpl VALUES ("ET1_15","018_1_15","EST","1","15","15","Binata na dyira a kāna, “Sigon do linteg, āngo maganay a parinen di Rēyna Basti? Inanohdan nabaw yaken a āri do nakaibilin kwaw sya dyirad tinoboy ko saw a magsirsirbi dyaken.” ");
INSERT INTO ivb_vpl VALUES ("ET1_16","018_1_16","EST","1","16","16","Ki tominbay si Memokan di āri do kasalasalapan daw no opisyalis saw a kāna, “Ay pakawanen! Madiw nya pinarin Rēyna Basti. Moyboh aba si āri iyaw inasnesnekan na an dyi pa tabo a opisyalis kan siraw tawotawo do intīro a pagāryan ni āri. ");
INSERT INTO ivb_vpl VALUES ("ET1_17","018_1_17","EST","1","17","17","Ta iyaw nya pinarin ni rēyna, ki komayab anchi do tābo a mababakes kan paynamotan darana dya omanyib siras lalakay da. Batahen danchi a kon da, ‘Inbilin naw ni Āri Ekserses si Rēyna Basti a mangay do salapen na, ki nangay abaw.’ ");
INSERT INTO ivb_vpl VALUES ("ET1_18","018_1_18","EST","1","18","18","Iyaw naparinaya sicharaw, madāmag danchi no mababakes saw a mabigbigbig do Persya kan Medya, as tolāden darananchiw nya pinarin ni rēyna dyirad tabo a opisyalis saya ni āri. An komwan machipandabaw kabon anyib kan kapaysin-iipsok. ");
INSERT INTO ivb_vpl VALUES ("ET1_19","018_1_19","EST","1","19","19","As dawa, an makahwahok dyimo mo āri, mangibilin ka pakono so keddeng a dya mabaliwan a maitolas do linteg no Persya kan Medya tan si Basti, ki maparin na paba polos magparang do salapen mo. As iyaw nawri a saad na rēyna, ki itoroh mo na do matarek a mabakes a mangamangay a maikari kan iya. ");
INSERT INTO ivb_vpl VALUES ("ET1_20","018_1_20","EST","1","20","20","Anchan maipakatoneng keddeng mwaya do intīrwaya pagāryan mo a marahawa, anyiben dananchin tābo mabakes kabahay da makayapod kabobodisan mandad katotohosan.” ");
INSERT INTO ivb_vpl VALUES ("ET1_21","018_1_21","EST","1","21","21","Chinadaw ni āri kan opisyalis na saw nyaya kapangtokto. Dawa, pinarin āryaw akmas inbaheyaw ni Memokan. ");
INSERT INTO ivb_vpl VALUES ("ET1_22","018_1_22","EST","1","22","22","Maynamot do dyaya, nangipaw-it so tolas dyirad tabo probinsya a itorayan na sigon do kapaychirin kan kapaytolas do kāda probinsya. No naibahey, ki kāda mahakay, ki iya pakono magtoray do bōkod na pamilya kan chirin na pakono matongpal. ");
INSERT INTO ivb_vpl VALUES ("ET2_1","018_2_1","EST","2","1","1","Do nakabaw danaw no soli ni Āri Ekserses, nanakem naw pinarin naw ni Basti kan iyaw nakapangikeddeng naw so maikontra dya. ");
INSERT INTO ivb_vpl VALUES ("ET2_2","018_2_2","EST","2","2","2","Sinpangan na, inbahey dan mamagbagaw a masinged di āri a kon da, “Āngo ta dyi ka maychichwas siras mapipintas saya babbalāsang a birhin a para dyimo mo āri? ");
INSERT INTO ivb_vpl VALUES ("ET2_3","018_2_3","EST","2","3","3","Mamidi ka dyirad opisyalis mo saw do kāda probinsya do dya pagāryan a mangyangay siras mapipintas saw a babbalāsang a birhin do pagyanan dayan mababakes do palasyowaya do dya a Sosa a sintro no pagāryan. On, ipaaywan ta sa di Hegay a iyaw yonoko a mangay-aywan siras mababakes mo saw tan papintasen na sa. ");
INSERT INTO ivb_vpl VALUES ("ET2_4","018_2_4","EST","2","4","4","Iyanchiw mabakesaw a kasdayan kapangdidiw mo, hapen mo a rēyna a tādi ni Basti.” Chinadaw ni āri iyaw nya a binata da dya. Dawa, nawriw inonotan na. ");
INSERT INTO ivb_vpl VALUES ("ET2_5","018_2_5","EST","2","5","5","Do dawri do Sosa, myan asa Jodyo a yapo do tribo ni Benhamin a mayngaran so Mardokeo a pōtot ni Hair a pōtot ni Semai a pōtot ni Kis. ");
INSERT INTO ivb_vpl VALUES ("ET2_6","018_2_6","EST","2","6","6","No pinarin Nebokadnesar a āri do Babilonya, ki inakaw na si Kisa nabahod a yapod Jerosalem kontodo si Jekonya a āri do Joda. ");
INSERT INTO ivb_vpl VALUES ("ET2_7","018_2_7","EST","2","7","7","Si Mardokeo, ki myan kasinsin na a mayngaran so Ester. As no ngaran na do Hebreo, ki Hadassah. Si Mardokeo, ki naparakoh si Ester maynamot ta nadiman dana saw inyapwan na kan inbidang narana anak na. Si Ester, ki makadadaw a balāsang kan kakoskostwanaw inaynawan na. ");
INSERT INTO ivb_vpl VALUES ("ET2_8","018_2_8","EST","2","8","8","Do nakaipakatoneng danaw no inkeddengaw ni Āri Ekserses, āro a babbalāsang naiyangay do Sosa kan naipaaywan sa di Hegay. Aran si Ester, ki naiyangay do palasyowaw ni āri, kan naitalek di Hegay a mangay-aywan so pagyanan daw no mababakes. ");
INSERT INTO ivb_vpl VALUES ("ET2_9","018_2_9","EST","2","9","9","Nahwahok ni Ester si Hegay. Dawa, chinadaw na kan nyeng na inrogi a papintasen, kan tinorohan na pa so machitatārek a mākan. Myan saw tinongdo ni Hegay a papito a mababakes a yapod palasyo a magsirbi di Ester, as kan pinayadis nas Ester kan magsirsirbi saw dya do kagaganayanaw a kwarto. ");
INSERT INTO ivb_vpl VALUES ("ET2_10","018_2_10","EST","2","10","10","Inlīmed ni Ester a iya, ki asa a Jodyo maynamot ta nawriw inbilin dya ni Mardokeo. ");
INSERT INTO ivb_vpl VALUES ("ET2_11","018_2_11","EST","2","11","11","Kararaw a homabahabas si Mardokeo do atataw no pagyanan dan mababakes saw tan matonngan na an maypāngo dana si Ester kan an āngo danaw mapariparin dya. ");
INSERT INTO ivb_vpl VALUES ("ET2_12","018_2_12","EST","2","12","12","Sakbay no naibatang a kaiyangay no kāda balāsang do yanan ni Āri Ekserses, machita patayokahen naw asa poho kan dadwa a kabohan a kapagpapintas a naikeddeng para dyirad mababakes. On, kāda balāsang, machita naw anem a kabohan a maptoptosan so lana no mirra kan anem a kabohan iyaw bangbanglo kan pangpapintas saw. ");
INSERT INTO ivb_vpl VALUES ("ET2_13","018_2_13","EST","2","13","13","As no kangay no balāsang a yapod pagyanan daw no mababakes a komwan do palasyo a yanan ni āri, mapalobōsan kāda asa a magpapintas sigon do chakey na. ");
INSERT INTO ivb_vpl VALUES ("ET2_14","018_2_14","EST","2","14","14","Mangay daw an mahep, as an mabekas dana maiyangay do matarekaw a pagyanan dan mababakes do aywan ni Saasgas a iyaw yonokwaw a mangay-aywan siras babbaket saw ni āri. Maybidi paba di āri malaksid an chadaw ni āri kan ipatawag naw mismwaw a ngaran na. ");
INSERT INTO ivb_vpl VALUES ("ET2_15","018_2_15","EST","2","15","15","Si Ester, ki pōtot a mabakes ni Abihail a marāan ni Mardokeo, as pinarakoh ni Mardokeo si Ester a akmay anak na. Do karapit danaw no ka si Ester maiyangay di āri, nawri lang pinaylaylay naw binahey naw ni Hegay a yonoko a mangay-aywan so mababakes saw. As tābo nakaboya dya, ki inanyib da. ");
INSERT INTO ivb_vpl VALUES ("ET2_16","018_2_16","EST","2","16","16","Do dāwri, naiyangay si Ester di Āri Ekserses do palasyo do chapapitwaw a katawen no nakapagāri na do chaasa poho naw a bohan a mapangaranan so Tebet. ");
INSERT INTO ivb_vpl VALUES ("ET2_17","018_2_17","EST","2","17","17","Si āri, ki nakadidiw di Ester so kapateg kan kadaw a mangamangay pa kan kadwan saw a babbalāsang. Dawa, kinoronaan na si Ester kan pinayparin narana a rēyna a tādi ni Basti. ");
INSERT INTO ivb_vpl VALUES ("ET2_18","018_2_18","EST","2","18","18","Sinpangan na, namarin si āri so rakoh a pista a pamadāyaw na di Ester, as nakaāwis na siras opisyalis naw kan tabo mabigbigbig saw a tawo do pagtorayan na. Inpakatoneng na a iyaw nawri, ki araw no kapaynaynahah do tābo probprobinsya, as kan siboboslon si āri a nangibonong dyira so rigrigālo a yapo kadādam na. ");
INSERT INTO ivb_vpl VALUES ("ET2_19","018_2_19","EST","2","19","19","Do kapaychichipeh daranaw a minirwa no babbalāsang saw a birhin, nadotokan narana ni āri si Mardokeo a asa opisyal kan nachidisna dyirad kadwan saw a opisyalis a myan do rowanganaw no palasyo ni āri. ");
INSERT INTO ivb_vpl VALUES ("ET2_20","018_2_20","EST","2","20","20","Ki si Ester, nāw na intayotayo ka-Jodyo na a akmas inbilin naw dya ni Mardokeo. As nāw na inanohdan si Mardokeo a akmas nakapanganohed naw dya do kadēkey na paw. ");
INSERT INTO ivb_vpl VALUES ("ET2_21","018_2_21","EST","2","21","21","Kadama naw ni Mardokeo a maydiydisna do rowanganaw no palasyo, myan saw dadwa a opisyalis ni āri a maggwardya do pantawaw no kwarto ni āri a sa Bigtana kan Teres. Sira dadwa, ki nakasoli sa di āri kan inpangta da dimanen. ");
INSERT INTO ivb_vpl VALUES ("ET2_22","018_2_22","EST","2","22","22","Ki nadngey ni Mardokeo pangta daw kan inbahey na di Rēyna Ester. Otro si Ester, inbahey na di āri a si Mardokeo, ki nadngey na mismo pangta da dya. ");
INSERT INTO ivb_vpl VALUES ("ET2_23","018_2_23","EST","2","23","23","Do nakaosisa naw no nya naipadāmag kan natonngan a oyod, binītay da saw dadwaw. Naitolas nya naparin do salapen āri do librwaw a pakasaritaan pagāryan. ");
INSERT INTO ivb_vpl VALUES ("ET3_1","018_3_1","EST","3","1","1","Katayoka dan nya saya napariparin, pinadayāwan ni Āri Ekserses si Haman a pōtot ni Hammedita a kapotōtan ni Agag. Pinayparin na a iya danaw katotohosan a opisyal do intīro a pagāryan. ");
INSERT INTO ivb_vpl VALUES ("ET3_2","018_3_2","EST","3","2","2","As inbilin ni āri dyirad tabo opisyalis na saw a myan do rowanganaw no palasyo a ipaboya daw anyib di Haman maynamot do kapaydogod da a magdāyaw dya. Pinarin da tabo. Ki si Mardokeo, chaskeh naw maydogod mana magdāyaw dya. ");
INSERT INTO ivb_vpl VALUES ("ET3_3","018_3_3","EST","3","3","3","As dawa, inyahes dan opisyalis saw a myan do rowanganaw no palasyo di Mardokeo a kon da, “Āngo ta nagtongpal kaba do bilin naw āri?” ");
INSERT INTO ivb_vpl VALUES ("ET3_4","018_3_4","EST","3","4","4","Kararaw a paychirinan das Mardokeo, ki akmaw abo tadyinya na. “Yaken, ki Jodyo,” initbay ni Mardokeo dyira. As dawa, inbahey dad Haman, ta chiban da an ipalōbos naw komwanaya pariparinen Mardokeo. ");
INSERT INTO ivb_vpl VALUES ("ET3_5","018_3_5","EST","3","5","5","Do nakaboyaw sya ni Haman a dya maydogod si Mardokeo mana magdāyaw dya, oltimo nakapakasoli na. ");
INSERT INTO ivb_vpl VALUES ("ET3_6","018_3_6","EST","3","6","6","As do nakatoneng naw sya a si Mardokeo, ki Jodyo, chanawob naba do aktokto na a si Mardokeo lang madōsa. Dawa, naychichwas so pamosposan tan ipadiman na sa tabo tawotawowaw a Jodyo do intīro a pagāryan no Persya. ");
INSERT INTO ivb_vpl VALUES ("ET3_7","018_3_7","EST","3","7","7","Do kaasa poho naw kan dadwa a tawen a kapagtoray ni Āri Ekserses, do manōmaw a bohan a mayngaran so Nisan, inbilin ni Haman iyaw kapagbōnot a iyaw pangaranan daw so Porim. Iyaw nyaw mangikeddeng an āngo a araw kan bohan katongpal so panggep naw a kadiman siras Jodyo saw. Napidi iyaw chaasa poho naw kan tatdo a araw, do chaasa poho naw kan dadwa bohan no mayngaran so Adar. ");
INSERT INTO ivb_vpl VALUES ("ET3_8","018_3_8","EST","3","8","8","Sinpangan na, binata ni Haman di Āri Ekserses a kāna, “Ari saw tawotawo a naychawpit a napatawa so inawan da dyirad kadwan saya a tawotawo do tabo probprobinsya do pagāryan mwaya. Sira, ki machitarek sa so dadakay dyirad kadwan saya tawotawo kan dya manganohed do linteg mo saya. An komwan palobōsan moriw nyaya? ");
INSERT INTO ivb_vpl VALUES ("ET3_9","018_3_9","EST","3","9","9","An makahwahok dyimo mo āri, mangikeddeng ka pakono so linteg a maipadiman sa. An parinen mo nya aket, manoroh ako so tatdo a gasot papito a poho kan dadima a tonilāda pirak do pangapyan naw no āri so kwarta a maosar a para do pagāryan.” ");
INSERT INTO ivb_vpl VALUES ("ET3_10","018_3_10","EST","3","10","10","Do dāwri, pinakaro ni āri iyaw pangsilyo naw a singsing do kakamay na, as nakaitoroh na sya do kabōsor daw no Jodyo a si Haman a pōtot ni Hammedata a nakayapo do kapoonan ni Agag. ");
INSERT INTO ivb_vpl VALUES ("ET3_11","018_3_11","EST","3","11","11","Sinpangan na, inbahey ni āri di Haman a kāna, “Sigi, siraw tawotawo saw kan kwarta daw, ki dyira mo na. Parinen mo naw chakey mo dyira.” ");
INSERT INTO ivb_vpl VALUES ("ET3_12","018_3_12","EST","3","12","12","Do chaasa poho naw kan tatdo a karaw no manōma bohan, tinawagan san Haman tagatolas na saw ni āri. As inbahey na dyiraw bilinaw tan maytolas sa dyirad gobirnador saw, opisyalis saw, kan siraw pangpangōlo saw do tabo probprobinsya. Naiyōlog nya bilin do kāda kapaychirin kan sigon do kāda kapaytolas do intīro a pagāryan, as kan naitolas do ngaran ni Āri Ekserses kan nasilyowan so singsing naw. ");
INSERT INTO ivb_vpl VALUES ("ET3_13","018_3_13","EST","3","13","13","Inwaras dan natoboy saw nya bilin dyirad tabo probinsya saw do pagāryan ni āri. Naitolas do bilinaw a maipadiman sa tābo Jodyo, magtotobo kan matotoneng, mababakes kan adedekey. On, maipadiman sa tābo do asa karaw do chaasa poho naw kan tatdo a araw, do chaasa poho naw kan dadwa bohan a mayngaran so Adar. Maipadiman sa a abo kāsi kan masamsam paw dyira da saw. ");
INSERT INTO ivb_vpl VALUES ("ET3_14","018_3_14","EST","3","14","14","Iyaw kopya no nya bilin, ki maitoroh do kāda probprobinsya kan maibahebahey a pamakatoneng do tabo a tawotawo tan makasagāna sa do dāwri a araw. ");
INSERT INTO ivb_vpl VALUES ("ET3_15","018_3_15","EST","3","15","15","Do bilin ni āri, in-godegodes daw nangay no natoboy saw kan inpakatoneng daw nya bilin do Sosa a sintro no pagāryan. Chinariribok dad syodad no Sosa. Ki sa āri kan Haman, ki myan sa minom so palek. ");
INSERT INTO ivb_vpl VALUES ("ET4_1","018_4_1","EST","4","1","1","Do nakatonengaw ni Mardokeo so tābo a napariparin, pinirit naw laylay naw do kapagmamayo na. Naylaylay so makersang, nakapayokpok nas ahbek do oho na, as nakapanakenakey nad irahemaw no syodad a magdongdong-aw so malyak do oltimo a kaliday na. ");
INSERT INTO ivb_vpl VALUES ("ET4_2","018_4_2","EST","4","2","2","Ki tod a nachipanda do rowanganaw no palasyo, ta abaw maylaylay so makersang a mapalobōsan a somdep. ");
INSERT INTO ivb_vpl VALUES ("ET4_3","018_4_3","EST","4","3","3","Do kāda probprobinsya a nakaibaheyan no bilinaw ni āri, myan taywara kapagdongdong-aw dan Jodyo saw parayayan das kapagayonar, katanyis, kan arimbāngaw. Kārwan dyiraw naylaylay so makersang kan nadibadibat sad ahbek. ");
INSERT INTO ivb_vpl VALUES ("ET4_4","018_4_4","EST","4","4","4","Do nakaibahey daw syan magsirsirbi saw ni Ester a mababakes kan yonoko saw so maynamot do pariparinen naw ni Mardokeo, taywara nariribokan. Do dāwri, napaiyangay so laylay ni Mardokeo tan sokatan naw laylay naw a makersang, ki rinawat aba ni Mardokeo. ");
INSERT INTO ivb_vpl VALUES ("ET4_5","018_4_5","EST","4","5","5","Nyaw naynamotan na a pinatawagan ni Ester si Hatach a asa dyirad yonoko saw a tinongdo ni āri a magsirbi do rēyna. Tinoboy na si Hatach a mangay di Mardokeo, ta ipaiyahes na an āngo mapariparin di Mardokeo kan āngo ta parinen naw komwan. ");
INSERT INTO ivb_vpl VALUES ("ET4_6","018_4_6","EST","4","6","6","Dawa, nangay si Hatach do yanan Mardokeo do atataw do salapenaw no rowangan palasyo. ");
INSERT INTO ivb_vpl VALUES ("ET4_7","018_4_7","EST","4","7","7","Ki inbahey ni Mardokeo di Hatach tabo napariparinaw dya, kontodo bidangaw no kwarta a inkari ni Haman a itoroh do pangapyan no āri so kwarta para do kaipadiman da so tabo Jodyo. ");
INSERT INTO ivb_vpl VALUES ("ET4_8","018_4_8","EST","4","8","8","Nanoroh pa si Mardokeo so kopya no bilinaw a naipakatoneng do Sosa a maynamot do kaipadiman na sira. Chindaw na di Hatach a ipaboya na di Ester kan ilawlawag na dyaw mapariparinaw. Inmandar pa ni Mardokeo a mangay a machikakaāsi si Ester di āri tan chāsi na saw Jodyowaw. ");
INSERT INTO ivb_vpl VALUES ("ET4_9","018_4_9","EST","4","9","9","Naybidi si Hatach kan inbahey na di Ester inbaheyaw dya ni Mardokeo. ");
INSERT INTO ivb_vpl VALUES ("ET4_10","018_4_10","EST","4","10","10","Ki pinaybidi dana ni Ester si Hatach, kan binata na dya a ibahey na di Mardokeo nya a kāna, ");
INSERT INTO ivb_vpl VALUES ("ET4_11","018_4_11","EST","4","11","11","“Tabo no opisyalis saw ni āri kan tawotawo saw do probinsya saya, ki chapatak da a no aran sino a mahakay mana mabakes a somdep do makatayrahemaw a paraāngan a maypasngen di āri a dya natawagan, machita maipadiman, ta asa lang linteg. Abaw makadichan do dyaya malaksid an patongdohen dya ni āri iyaw balitokaw a baston na. An komwan, maipadiman aba. Ta an yaken, makabohan danayaw homnabas makayapod nakatawagaw dyaken āri.” ");
INSERT INTO ivb_vpl VALUES ("ET4_12","018_4_12","EST","4","12","12","Do nakapakarapitaw no nya inpaibahey ni Ester di Mardokeo, ");
INSERT INTO ivb_vpl VALUES ("ET4_13","018_4_13","EST","4","13","13","inpapabidi na inpaibahey nya atbay na di Ester a kāna, “Iktokto mwaba a imo lang dya maparoparo do tabo a Jodyo maynamot ta myan ka do palasyo. ");
INSERT INTO ivb_vpl VALUES ("ET4_14","018_4_14","EST","4","14","14","Ta an itmen mo dangoy mo do oras a akma syay, mangay anchi a yapod matarek a yanan pakalmonawan kan pakaisalakānan dan Jodyo saya. Ki imo, madiman kanchi kan mabonchiw kapotōtan āmang mo. Kan sino makapatak? Āngonchan no nayparinan mwa rēyna, ki para do akmas komwanaya chimpo.” ");
INSERT INTO ivb_vpl VALUES ("ET4_15","018_4_15","EST","4","15","15","Sinpangan na, inpaibahey danan Ester nya atbay na di Mardokeo a kāna, ");
INSERT INTO ivb_vpl VALUES ("ET4_16","018_4_16","EST","4","16","16","“Na, akpehen mo sa tabo Jodyo saya a myan do Sosa ah, as kapagayonar nyo kan pangdakdaw nyo yaken. Koman mana minom kamo aba so aran āngo do maraw kan mahep do irahem no tatdo a karaw. Aran yaken kan siraw magsirsirbi saya dyaken a mababakes, ki magayonar kami a akma dyinyo. Katayoka na, mangay akonchi di āri a aran maikontra do linteg. As an nyaw kadimanan ko, sigi, kadimanan ko na.” ");
INSERT INTO ivb_vpl VALUES ("ET4_17","018_4_17","EST","4","17","17","Do dāwri, komnaro si Mardokeo kan tinongpal na tabo inbilin naw ni Ester. ");
INSERT INTO ivb_vpl VALUES ("ET5_1","018_5_1","EST","5","1","1","Do chatatdo naranaw a karaw no kapagayonar ni Ester, pinalaylay daw laylay no rēyna di Ester. As nakangay na naytēnek do makatayrahemaw a paraāngan no palasyo do somalapaw do kwarto a yanan no trono ni āri. Do dāwri, myan a maydisna si āri a somalap do rowanganaw. ");
INSERT INTO ivb_vpl VALUES ("ET5_2","018_5_2","EST","5","2","2","Do nakaboya naw si Rēyna Ester a myan a maytēnek do gagan, chinahwahok na. Dawa, pinatongdo na di Ester baston naw a balitok a inigpet na. Naypasngen si Ester kan sinalid naw tobwanaw no baston ni āri. ");
INSERT INTO ivb_vpl VALUES ("ET5_3","018_5_3","EST","5","3","3","Sinpangan na, inyahes ni āri a kāna, “Āngo akdawen mo, mo Rēyna Ester? Chabābang mwaba ibahey, ta ara pan mandad kagodwa no pagāryan ko, maitoroh dyimo.” ");
INSERT INTO ivb_vpl VALUES ("ET5_4","018_5_4","EST","5","4","4","Tinbay ni Ester a kāna, “An pakahwahokan mo, mo āpo āri, chakey kwaw inyo a awīsen kan Haman sichahep do pasken kwaw a insagāna ko a para dyinyo.” ");
INSERT INTO ivb_vpl VALUES ("ET5_5","018_5_5","EST","5","5","5","Insigīda inbilin ni āri a kāna, “Ibahey nyo a bēbelan Haman mangay dya tan maparin namen chakey ni Ester.” Dawa, nangay sa āri kan Haman do paskenaw a insagāna ni Ester. ");
INSERT INTO ivb_vpl VALUES ("ET5_6","018_5_6","EST","5","6","6","Ki do kadama daw a minom so palek, inyahes danan āryaw di Ester a kāna, “Āngo chakey mo? Maitoroh dyimo. Aran kagodwa pan pagāryan kwaya, itoroh ko.” ");
INSERT INTO ivb_vpl VALUES ("ET5_7","018_5_7","EST","5","7","7","Ki binata ni Ester a kāna, “No chakey ko kan akdawen ko, ki nya: ");
INSERT INTO ivb_vpl VALUES ("ET5_8","018_5_8","EST","5","8","8","An mahwahok ko pa imo mo āri, as kan makahwahok dyimo kaitoroh mos yahes kwaya, māsaw katongpal mos akdawen kwaya a kangay nyo pakono mo āpo āri kan Haman anchan delak do pasken dana a isagāna ko dyinyo. Do dāwri dananchiw kaibahey kos chakey ko.” ");
INSERT INTO ivb_vpl VALUES ("ET5_9","018_5_9","EST","5","9","9","Do dāwri a araw, minohbot si Haman a siraragsak a yapod paskenaw ni Ester, kan mapaw danaw kapangtokto na. Ki do nakaboya naw si Mardokeo do rowanganaw no palasyo a malidyat pa, naytēnek a mangipaboyas kaanyib na sya, taywaraw nakapakasoli na. ");
INSERT INTO ivb_vpl VALUES ("ET5_10","018_5_10","EST","5","10","10","Aran komwan, pinenpen naw oltimwaw a soli na kan somnabat. Sinpangan na, ināwis na saw sīt na saw kan si baket na a si Seres a machirapa dyira. ");
INSERT INTO ivb_vpl VALUES ("ET5_11","018_5_11","EST","5","11","11","Do dāwri, inpangas na dyiraw kāron kinabaknang na kan iyaw kāron pōtot na mahahakay. Inpangas na paw tabo nakaitoroh dya ni āri so pammadāyaw kan maypāngo iyaw nakapatohosaw ni āri so saad na a iya danaw katotohosan dyirad opisyalis na saw. ");
INSERT INTO ivb_vpl VALUES ("ET5_12","018_5_12","EST","5","12","12","Innāyon pa ni Haman a kāna, “Nawri aba lang, ta yaken lang a maychatanyiw ināwis ni Rēyna Ester a rarayay ni āri do insagāna naw a pasken. Tori naranaw yamen a awīsen kan āri anchan delak. ");
INSERT INTO ivb_vpl VALUES ("ET5_13","018_5_13","EST","5","13","13","Ki mararayawaya tabo gānas ko do dawri a Mardokeo a asa Jodyo an maboyaboya ko a maydisna do salapenayan palasyo.” ");
INSERT INTO ivb_vpl VALUES ("ET5_14","018_5_14","EST","5","14","14","Tinbay ni Seres a baket na kan siraw sīt na saw a kon da, “Namna, āngo ngamin ta dyi ka mapaparin so pangbitāyan sya a dadwa poho kan dadima kamitros so katohos? Anchan mabekas, yahes mod āri a ipabītay na daw si Mardokeo. An tayokaw nawri, makapachirayay kad āri a mangay do pasken a siraragsak.” Chinasoyot ni Haman nawri a inbahey da dya kan napaparin so pangbitāyan. ");
INSERT INTO ivb_vpl VALUES ("ET6_1","018_6_1","EST","6","1","1","Do dāwri a mahep, makapakaycheh abas āri. Dawa, inpahap naw librwaw a nakaitolasan mapariparin do pagāryan kan inbāsa da dya. ");
INSERT INTO ivb_vpl VALUES ("ET6_2","018_6_2","EST","6","2","2","As kan nadongso daw yananaw no naitolas maynamot do nakapaybahebahey naw ni Mardokeo so pangta daw a mangdiman si āri. Sa Bigtana kan Teres, dadwaw a yonoko a magbanbantay do rowangan naw no kwarto ni āri a nangipangta sya. ");
INSERT INTO ivb_vpl VALUES ("ET6_3","018_6_3","EST","6","3","3","Inyahes ni āri a kāna, “Āryoriw naitoroh a gon-gona kan pammadāyaw di Mardokeo do dyaya pinarin na?” Ki tinbay dan magsirsirbyaw a kon da, “Abaw naitoroh dya.” ");
INSERT INTO ivb_vpl VALUES ("ET6_4","018_6_4","EST","6","4","4","Inyahes ni āri a kāna, “Sino saw opisyalis ko a myan do atataya no palasyo?” Ki kosto a somdep si Haman do mamangketaw do gagan a paraāngan palasyo tan yangay na akdawen a mabītay si Mardokeo do insagāna naw a pangbitāyan sya. ");
INSERT INTO ivb_vpl VALUES ("ET6_5","018_6_5","EST","6","5","5","Ki tinbay dan magsirsirbi saw a kon da, “Toryayas Haman a maytēnek do gagan a mangnanaya machisarīta dyimo.” “Pasdepen nyo pa dya,” inbilin ni āri. ");
INSERT INTO ivb_vpl VALUES ("ET6_6","018_6_6","EST","6","6","6","Do nakapakasdep naranaw ni Haman, inyahes dya ni āri a kāna, “Āngo paro maganay a parinen do tawowaw a chakey ko a padayāwan?” Ki no iniktokto ni Haman, “Ari pawriw matarek a tawo a iktokto ni āri a padayāwan an dya yaken?” ");
INSERT INTO ivb_vpl VALUES ("ET6_7","018_6_7","EST","6","7","7","Dawa, tinbay ni Haman a kāna, “Para do tawowaw a chakey no āri a padayāwan, ");
INSERT INTO ivb_vpl VALUES ("ET6_8","018_6_8","EST","6","8","8","mapahap kas laylay saw no āri a paylaylaylay mo, kan pabistyan mo kabalyowaw a pagkabkabalyowan mo, as kakorona mo syas koronaw a pangkorkorona mo. ");
INSERT INTO ivb_vpl VALUES ("ET6_9","018_6_9","EST","6","9","9","As kaipahap mos katotohosanaw a opisyal mo, ta iyaw manglaylay so tawowaw a chakey mo a padayāwan. Onotan anchi no nakasakay do kabalyo a mayam do kalsāda saya do irahem no syodad, as kaipaingengengey mo sya do opisyal mwaw so nya: ‘Chiban nyo! Komwan maparin do tawo a chakey ni āri a padayāwan!’” ");
INSERT INTO ivb_vpl VALUES ("ET6_10","018_6_10","EST","6","10","10","Sinpangan na, binata ni āri di Haman a kāna, “Ngay, kabelan mo yangay mwa hapen laylay saw kan kabalyowaw, as kaparin mos binata mwaya di Mardokeo a Jodyo. Ari a maydiydisna dwa rowanganaya no palasyo. Kanakmen mo ah, parinen mwa tabo binata mwaya.” ");
INSERT INTO ivb_vpl VALUES ("ET6_11","018_6_11","EST","6","11","11","Dawa, yay na inhap ni Haman laylay saw kan kabalyowaw. Do dāwri, linaylayan nas Mardokeo, as nakaikwan na sya a sisasakay do kabalyo do kalsādaw do irahem no syodad. Do kayan daw do kalkalsāda, ingengengey ni Haman, “Chiban nyo. Komwan maparin do tawo a chakey ni āri a padayāwan.” ");
INSERT INTO ivb_vpl VALUES ("ET6_12","018_6_12","EST","6","12","12","Katayoka no nya, naybidi danas Mardokeo do rowanganaw no palasyo. As si Haman, binēbelanaw somnabat a naytatalob so ropa na maynamot do asnek na. ");
INSERT INTO ivb_vpl VALUES ("ET6_13","018_6_13","EST","6","13","13","Inistorya na di Seres a baket na kan do tabo sīt na saw daw tabo naparinaw dya. Do dāwri, binata ni Seres kan mamagbaga na saw a sīt na a kon da, “Ayya, tori dana mangrogiw kabo mos toray mo maynamot di Mardokeo a yapo do kapotōtan no Jodyo. Mahomis mo paba, basbāli a rarayawen narana imo.” ");
INSERT INTO ivb_vpl VALUES ("ET6_14","018_6_14","EST","6","14","14","Do kadama da paw a machisarsarīta dya, nawara saw yonoko saw ni āri, kan kinalokalo das Haman a mangay do paskenaw a insagāna ni Ester. ");
INSERT INTO ivb_vpl VALUES ("ET7_1","018_7_1","EST","7","1","1","Dawa, nangay si āri kan si Haman a nachakan di Rēyna Ester. ");
INSERT INTO ivb_vpl VALUES ("ET7_2","018_7_2","EST","7","2","2","Do kadama daw a minom so palek do somaronwaya nakangay da, inyahes dana mirwa ni āri di Rēyna Ester a kāna, “Changori mo Rēyna Ester, āngo chakey mo? Aran manda pad kagodwan pagāryan kwaya maitoroh anchi dyimo.” ");
INSERT INTO ivb_vpl VALUES ("ET7_3","018_7_3","EST","7","3","3","Ki tinbay ni Rēyna Ester, “Mo āpo āri, an makahwahok dyimo, palobōsan mo pa yaken a mabyay kan siraw kapayngay kwaya Jodyo. Nyaw pachikakaāsi ko dyimo. ");
INSERT INTO ivb_vpl VALUES ("ET7_4","018_7_4","EST","7","4","4","Ta nailāko kami naya kan siraw kapayngay ko saya Jodyo a mararayaw, madiman, kan mabo. Amnan tod kami sawen lang a nailāko a para adipen a mahahakay kan mababakes, maylilyak ako paba. Manawob abaw nya kaidadanesan namen a pangistorbo ko dyimo.” ");
INSERT INTO ivb_vpl VALUES ("ET7_5","018_7_5","EST","7","5","5","Ki tominbay si Āri Ekserses di Rēyna Ester a kāna, “Sino nawri a tawo a matored a namarin so komwan? Dino yanan na?” ");
INSERT INTO ivb_vpl VALUES ("ET7_6","018_7_6","EST","7","6","6","Tinbay ni Ester a kāna, “Abaw matarek a mangidadanes kan kabōsor namen an dya iyaw nya marahet a tawo a si Haman.” Do dāwri, oltimo nakāmo ni Haman do salapen ni āri kan rēyna. ");
INSERT INTO ivb_vpl VALUES ("ET7_7","018_7_7","EST","7","7","7","Naychakatkat si āri a makasokasoli a minohtot do pagpaskenanaw, as nakangay nad atataw no palasyo. Ki si Haman, ki natokos a nangikakaāsi so byay na di Rēyna Ester, ta madlaw narana a nakadisisyon āryaw a mangdōsa sya. ");
INSERT INTO ivb_vpl VALUES ("ET7_8","018_7_8","EST","7","8","8","Do nakapaybidyaw ni āri a yapod atataw no palasyo a komwan do pagpaskenanaw, kosto a rinokoban ni Haman paypoktadanaw a yanan ni Ester a machikakaāsi. Nakaboyaw syan āri, inyagay na, “Hoy! Aran si rēyna, chakey nawri no nya tawo a oknoden do salapen ko do mismo a palasyo ko?” Nakaichirinaw sya ni āri, pinongosan das oho si Haman no yonoko saw. ");
INSERT INTO ivb_vpl VALUES ("ET7_9","018_7_9","EST","7","9","9","Sinpangan na, binata ni Harbona a asa dyirad yonoko saw a kāna, “Aryaw pinatnek ni Haman do bahay na a dadwa poho kan dadima kamitros so katohos a pangbitāyan nas Mardokeo a nangisalākan so byay mo, mo āpo āri.” Do dāwri, inmandar ni āri a kāna, “Bitāyen nyo daw si Haman!” ");
INSERT INTO ivb_vpl VALUES ("ET7_10","018_7_10","EST","7","10","10","Dawa, binītay da si Haman do pinarinaw a pangbitāyan di Mardokeo. Do dāwri, nabawan solyaw ni āri. ");
INSERT INTO ivb_vpl VALUES ("ET8_1","018_8_1","EST","8","1","1","Do dāwri a araw, intoroh ni Āri Ekserses di Rēyna Ester tābo tana kan warawara ni Haman a kabōsor dan Jodyo. As si Mardokeo, makangay dana do salapen ni āri maynamot ta inbahey ni Ester a kabagyan na. ");
INSERT INTO ivb_vpl VALUES ("ET8_2","018_8_2","EST","8","2","2","Inakso ni āri do kakamay naw singsing naw a pangsilyo na a inbabāwi na di Haman, as nakaitoroh na sya di Mardokeo. As si Ester, ki tinongdo na si Mardokeo a mangaywan so tana kan warawara naw ni Haman. ");
INSERT INTO ivb_vpl VALUES ("ET8_3","018_8_3","EST","8","3","3","Do dāwri, minirwa dana nachikakaāsi si Ester, kan sinakban naw kokodaw ni āri. Nachikakaāsi a penpenen pakono ni āri iyaw marahetaw a pinanggep ni Haman a kapotōtan ni Agag a maikontra dyirad Jodyo saw. ");
INSERT INTO ivb_vpl VALUES ("ET8_4","018_8_4","EST","8","4","4","Sinpangan na, pinatongdo ni āri di Ester baston naw. Dawa, naytēnek do salapenaw ni āri. ");
INSERT INTO ivb_vpl VALUES ("ET8_5","018_8_5","EST","8","5","5","Binata ni Ester a kāna, “An pakahwahokan mo, mo āpo āri, kan mahwahok ko pa imo, as kan iktokto mo an maganay, maytolas ka pakono so bilin a mamenpen so kaipatongpal no bilinaw ni Haman. On, ta si Haman a potōt ni Hammedata a kapotōtan ni Agag, ki inpaiwaras naw tolas saw a pangipadiman so tabo Jodyo do tābo probprobinsya do intīro a pagāryan. ");
INSERT INTO ivb_vpl VALUES ("ET8_6","018_8_6","EST","8","6","6","Ta maypāngo ko a ibtoran kaboya ko so kararayaw dan kapayngay ko saya Jodyo? Maypāngo ko a itored kadiman das kakabagyan ko saw?” ");
INSERT INTO ivb_vpl VALUES ("ET8_7","018_8_7","EST","8","7","7","Ki binata ni Āri Ekserses di Rēyna Ester kan di Mardokeo a Jodyo a kāna, “Maynamot ta chakey ni Haman a dimanen saw Jodyo, inpabītay ko kan intoroh ko a tābo di Ester tana kan warawara na. ");
INSERT INTO ivb_vpl VALUES ("ET8_8","018_8_8","EST","8","8","8","Sichangori, maparin nyo maytolas so chakey nyo para dyirad Jodyo saw do ngaran ko kan silyowan nyo so singsing kwaw. Ta iyaw naikeddeng dana do ngaran ko a āri kan nasilyowan danas singsing ko, ki maparin ko paba ibabāwi.” ");
INSERT INTO ivb_vpl VALUES ("ET8_9","018_8_9","EST","8","9","9","Do chadadwa naw a poho kan tatdo a karaw, do chatatdo naw a bohan a mayngaran so Siban, pinatawagan sa ni Mardokeo tagatolas na saw ni āri. Intolas da tabo bilinaw ni Mardokeo dyirad Jodyo saw, opisyalis saw, gobirnador saw, kan pangōlo saw no asa gasot, dadwa poho kan papito a probinsya yapo do Indya a mandad Etiopya. Siraw nya bilin, ki naitolas sa do kāda kapaychirin kan kapaytolas no kāda probinsya kan komwan do kapaychirin kan kapaytolas dan Jodyo. ");
INSERT INTO ivb_vpl VALUES ("ET8_10","018_8_10","EST","8","10","10","Pinaitolas ni Mardokeo do ngaran ni Āri Ekserses kan nasilyowan so singsingaw ni āri a pangsilyo. Katayoka na, inpaipaw-it naw tolas saw dyirad natoboy saw a nakasakay do matataray saw a kabalyo a naitatārek a nadām para do kapagsirbi di āri. ");
INSERT INTO ivb_vpl VALUES ("ET8_11","018_8_11","EST","8","11","11","Siraw nya tolas, ki pamalōbos no āryaw dyirad Jodyo saw do kāda syodad a makpekpeh a mangitēnek so byay da. On, mapalobōsan sa mangrarayaw, mangdiman, kan mangbo so aran sino a tawotawo do aran āngo a probinsya a magarmas a mangdarop sira kontodo kabahay mana anak da, as kan masamsaman paw dyira da saw. ");
INSERT INTO ivb_vpl VALUES ("ET8_12","018_8_12","EST","8","12","12","Iyaw nya bilin, ki maipatongpal do intīro a pagāryan no Persya do arawaw a naikeddeng a kadiman siras Jodyo saw. On, nya araw, ki do chaasa poho naw kan tatdo a araw, do chaasa poho naw kan dadwa bohan a mayngaran so Adar. ");
INSERT INTO ivb_vpl VALUES ("ET8_13","018_8_13","EST","8","13","13","Iyaw kopyaw no bilin, ki maitoroh a linteg do kāda probinsya kan maipakatoneng dyirad tabo tawotawo tan nakasagāna saw Jodyo do dāwri a araw a mamahes dyirad kabōsor da saw. ");
INSERT INTO ivb_vpl VALUES ("ET8_14","018_8_14","EST","8","14","14","Do mandar ni āri, siraw natoboyaw a nakasakay do kabalyo saw a dyira ni āri, ki nagpataray sa a nangay do nakatoboyan daw. Aran do sintrwaw a yanan gobyirno do syodad a Sosa, ki naiwaras nawri a bilin. ");
INSERT INTO ivb_vpl VALUES ("ET8_15","018_8_15","EST","8","15","15","Sinpangan na, komnaro a yapod yanan āri si Mardokeo, nakalaylay so asol kan maydak a laylay ni āri kan obi a ayowayob a kāpa, as kan sikokorona so nabistyan so balitok. Do syodad no Sosa, ki magariwāwa sa maynamot do kasoyot da. ");
INSERT INTO ivb_vpl VALUES ("ET8_16","018_8_16","EST","8","16","16","As an maynamot dyirad Jodyo saw, mapaw danaw aktokto da. Masoyot dana sa, as kan myan dana dyiraw ragsak kan dāyaw a yapod tawotawo. ");
INSERT INTO ivb_vpl VALUES ("ET8_17","018_8_17","EST","8","17","17","Do kāda probinsya kan kāda syodad a nakaipakatonngan no bilinaya ni āri, nasoyosoyot sa kan nagragragsak saw Jodyo a nangsilibrar do nakapamarin das pasken. Do dāwri, āro saw tawotawo a dya Jodyo, nayparin a Jodyo maynamot do kāmo da dyirad Jodyo saw. ");
INSERT INTO ivb_vpl VALUES ("ET9_1","018_9_1","EST","9","1","1","Do chaasa poho naw kan tatdo a araw, do chaasa poho naw kan dadwa a bohan no mayngaran so Adar, iyaw nyaw arawaw a kaipatongpal no bilinaw ni āri. Do dāwri a araw, hahawen dan kabōsor saw no Jodyo a rarayawen da sa. Ki basbāli a naybadichid naparin, ta siraw Jodyowaw, nangābak siras mangipsokaw dyira. ");
INSERT INTO ivb_vpl VALUES ("ET9_2","018_9_2","EST","9","2","2","Do kāda syodad do tabo probprobinsya do intīro pagāryan ni Āri Ekserses a yanan dan Jodyo saw, ki naychichipeh sa a mangdarop so aran sino a manghawahaway a mangrarayaw sira. Abaw nakaitored a machilāban dyira, ta chinamo sa no tabo tawotawo saw. ");
INSERT INTO ivb_vpl VALUES ("ET9_3","018_9_3","EST","9","3","3","As siraw tabo opisyalis do kāda probinsya, gobirnador, pangpangōlo, kan pinakainawan saw ni āri, sinidongan da saw Jodyowaw maynamot ta chamo das Mardokeo. ");
INSERT INTO ivb_vpl VALUES ("ET9_4","018_9_4","EST","9","4","4","Magdindināmag dana do intīro pagāryan a nayparin dana mabīleg a tawo si Mardokeo do palasyo kan maypaypabīleg pa. ");
INSERT INTO ivb_vpl VALUES ("ET9_5","018_9_5","EST","9","5","5","Maynamot ta komwan, pinarin dan Jodyo saw no chinakakey da dyirad kabōsor da saw. Diniman da sa a tabo so ispada kan sinapasapad da sa. ");
INSERT INTO ivb_vpl VALUES ("ET9_6","018_9_6","EST","9","6","6","Do syodad a Sosa a sintro no gobyirno, ki dadima gasot a tawotawo diniman da. ");
INSERT INTO ivb_vpl VALUES ("ET9_7","018_9_7","EST","9","7","8","Diniman da sa pa, sa Parsandata, Dalpon, Aspata, Porata, Adalya, Aridata, ");
INSERT INTO ivb_vpl VALUES ("ET9_9","018_9_9","EST","9","9","9","Parmasta, Arisay, Ariday, kan Baysata. ");
INSERT INTO ivb_vpl VALUES ("ET9_10","018_9_10","EST","9","10","10","Siraw nyaw asa pohwaw a mahahakay a pōtot ni Haman a potōt ni Hammedata a kabōsor dan Jodyo saw. Aran komwan, nagsamsam sabaw Jodyowaw. ");
INSERT INTO ivb_vpl VALUES ("ET9_11","018_9_11","EST","9","11","11","Do dāwri pa araw, iyaw bidang dan diniman da saw do Sosa a sintro no gobyirno, ki naipakatoneng do āryaw. ");
INSERT INTO ivb_vpl VALUES ("ET9_12","018_9_12","EST","9","12","12","Ki binata ni āri di Rēyna Ester a kāna, “Do syodadaya lang no Sosa, ki myan dadima gasot a diniman dan Jodyo saw kontodo asa poho saw a pōtot ni Haman. Aysa! An komwan, maparin a mangamangay paw pinarin dad kadwan saya probinsya. Changori, āngo paw chakey mo? Maitoroh anchi dyimo. Āngo paw yahes mo? Madyira mo pa.” ");
INSERT INTO ivb_vpl VALUES ("ET9_13","018_9_13","EST","9","13","13","Ki tominbay si Rēyna Ester a kāna, “An makahwahok dyimo mo āri, palobōsan mo pakono saw Jodyo saya do dya Sosa a mamarin dananchi anchan delak so pinarin daya changori a araw. Akdawen ko pa dyimo a ipalodyit mo pakono saw bangkay daw no asa poho saw a pōtot ni Haman do pangbitāyan.” ");
INSERT INTO ivb_vpl VALUES ("ET9_14","018_9_14","EST","9","14","14","Dawa, inmandar ni āri a maparin nyaya. Naipakatoneng iyaw bilin do Sosa, kan naipalodyit bangkay da saw no pōtot ni Haman. ");
INSERT INTO ivb_vpl VALUES ("ET9_15","018_9_15","EST","9","15","15","Do chaasa poho naw kan apat a araw do bohan no Adar, naychichipeh dana saw Jodyowaw, kan nangdiman dana sa so tatdo a gasot a mahahakay do syodadaw no Sosa. Ki aran do dāwri, ki nagsamsam saba. ");
INSERT INTO ivb_vpl VALUES ("ET9_16","018_9_16","EST","9","16","16","Māsaw a siraw Jodyowaw do probprobinsya saw, naychichipeh pa sa a nangitēnek so byay da. Nakalmonaw sa do kabōsor da saw do nakadiman daw so papito a poho kan dadima ribo, ki nagsamsam saba. ");
INSERT INTO ivb_vpl VALUES ("ET9_17","018_9_17","EST","9","17","17","Naparin nyaya do chaasa poho kan tatdo a karaw do bohan no Adar. As do chaasa poho naw kan apat a karaw, ki naynahah sa, as kan pinarin da a araw no kapagpista kan kapagragragsak. ");
INSERT INTO ivb_vpl VALUES ("ET9_18","018_9_18","EST","9","18","18","Siraw Jodyo saw do Sosa, ki naychichipeh sa do chaasa poho naw kan tatdo kan chaasa poho naw kan apat a karaw. As do chaasa poho naw kan dadima a karaw, ki naynahah sa, as kan iyaw nyaw pinarin da a araw no kapagpista kan kapagragragsak. ");
INSERT INTO ivb_vpl VALUES ("ET9_19","018_9_19","EST","9","19","19","Nyaw naynamotan na a siraw Jodyo saw a omyan do dēdekey saw a idi, magragragsak sa a mangsilibrar kan magpista do chaasa poho naya kan apat a karaw no bohan no Adar. Pistaen daw nya araw, kan maysinririgālo sa do katakatayisa dyira. ");
INSERT INTO ivb_vpl VALUES ("ET9_20","018_9_20","EST","9","20","20","Inpaitolas ni Mardokeo iyaw naparin saya, as kan pinaw-itan na sa so tolas tabo Jodyo saw masngen kan mateng do tābo probinsya saw no pagāryan ni Āri Ekserses. ");
INSERT INTO ivb_vpl VALUES ("ET9_21","018_9_21","EST","9","21","21","Inbilin na dyira a pistaen daw chaasa poho naya kan apat kan chaasa poho naya kan dadima a araw no bohan Adar do kāda tawen. ");
INSERT INTO ivb_vpl VALUES ("ET9_22","018_9_22","EST","9","22","22","Siraw nya araw, nakapakalmonaw dan Jodyo do kabōsor da saw. As nya bohan, nakapaybadichid no liday daw a nayparin a kasoyotan kan nakapaybadichid no kapagdongdong-aw daw a nayparin a kapagragragsak. Intolas na dyira a siraw nya araw, ki pistaen da, magragragsak sa, maysinririgālo sa so makākan, as kan rigālowan da saw mapobri saw. ");
INSERT INTO ivb_vpl VALUES ("ET9_23","018_9_23","EST","9","23","23","Tinongpal da san Jodyo saw nya a bilin ni Mardokeo, kan pinayparin daw nya a pista a silsilibraren da do kāda tawen. ");
INSERT INTO ivb_vpl VALUES ("ET9_24","018_9_24","EST","9","24","24","Si Haman a pōtot ni Hammedata a yapo do kapotōtan ni Agag a kabōsor no tabo Jodyo, inpangta naw kaipadiman na siras Jodyo. Iyaw nagpabōnot so mapangarananaya so Porim a nangikeddeng so araw a kararayaw kan kapatawos da siras Jodyo saw. ");
INSERT INTO ivb_vpl VALUES ("ET9_25","018_9_25","EST","9","25","25","Ki do nakapakarapit naw di āri no nya pangta, nangikeddeng si āri so naitolas sa a bilin a iyaw nya marahet a pinanggep ni Haman a maikontra dyirad Jodyo saw, ki naybidi do mismo na inawan. As iya kontodo pōtot na saw, ki nabītay do pangbitāyan. ");
INSERT INTO ivb_vpl VALUES ("ET9_26","018_9_26","EST","9","26","26","As dawa, Porim naipangaran do dya saya araw a yapo do Hebreo a chirin a “por”. Maynamot do tolasaw ni Mardokeo kan tabo saw napariparinaw do tabo a Jodyo, ");
INSERT INTO ivb_vpl VALUES ("ET9_27","018_9_27","EST","9","27","27","pinayparin daw nya dadakay da para dyira kan dyirad kapotōtan da kan aran siraw machirapaw anchi dyira a Jodyo. As dyi da polos a hātan a silsilibraren nya dadwa karaw do kāda tawen do naikeddeng a chimpo kan akmas nakaitolas naw. ");
INSERT INTO ivb_vpl VALUES ("ET9_28","018_9_28","EST","9","28","28","Siraw nya araw, ki machita nakmen kan ngilīnen no kāda kapotōtan do kāda pamilya kan do kāda probinsya kan do kāda syodad. As nya araw no Porim, ki machita polos a dya katngan a silibraren no Jodyo mana wayaken maypānam pa dyirad kapotōtan da. ");
INSERT INTO ivb_vpl VALUES ("ET9_29","018_9_29","EST","9","29","29","Katayoka na, aran si Rēyna Ester a pōtot ni Abihail kontodo si Mardokeo, ki namarin so tolas a mangipaboya so toray a pangpaneknek na so dāmwaw a tolas ni Mardokeo maynamot do Porim. ");
INSERT INTO ivb_vpl VALUES ("ET9_30","018_9_30","EST","9","30","30","Siraw kopya saw no tolas, ki naipaw-it sa do tabo a Jodyo do asa gasot dadwa poho kan papito a probinsya do intīro a pagāryan ni Āri Ekserses. Naitolas a myan pakono kaydamnayan kapangtokto kan kaoyodan. ");
INSERT INTO ivb_vpl VALUES ("ET9_31","018_9_31","EST","9","31","31","Naitolas pa a magpista sa do araw saw no Porim do kosto a chimpo akmas pariparinen daw a kapangdāg so kapagayonar kan chimpo no kapagdongdong-aw. Inbilin daw nya da Mardokeo kan Rēyna Ester. ");
INSERT INTO ivb_vpl VALUES ("ET9_32","018_9_32","EST","9","32","32","Iyaw nya bilin ni Ester nangipaneknek siras pariparinen maynamot do kasilibrar so Porim, as kan naitolas nyaya do librwaw a pakaitolasan mapariparin do pagāryan. ");
INSERT INTO ivb_vpl VALUES ("ET10_1","018_10_1","EST","10","1","1","Napagbwis si Āri Ekserses so inkapilītan dyirad tawotawo saw do intīro a pagāryan na a aran siraw omyanaw do payis no kanayan. ");
INSERT INTO ivb_vpl VALUES ("ET10_2","018_10_2","EST","10","2","2","Tābo mabibīleg kan makaskasdāaw saw a pinarin na kontodo kakomplito no pakasaritāan nakapatohos naw si Mardokeo do matohos a saad, ki naitolas do librwaw a pakasaritāan dan aāri daw do Persya kan Medya. ");
INSERT INTO ivb_vpl VALUES ("ET10_3","018_10_3","EST","10","3","3","Si Mardokeo a Jodyo, iyaw somarono di Āri Ekserses so saad. Anyiben kan chadaw dan kapayngay na saw a Jodyo. Intarabāko naw kaganayan dan tawotawo na saw, kan iyaw paypaganayan da do masakbayan no tābo Jodyo.");
INSERT INTO ivb_vpl VALUES ("AM1_1","031_1_1","AMO","1","1","1","Nyaw minsāhi a inpakatoneng no Dyos a maynamot do Israel a inpaibahey na di Amos a asa magpaspastor a yapo do idi a Tekowa. Rinawat naw nya minsāhi dadwa a katawen sakbay no gin-ginedaw do kayan pa ni Ossias a āri do Joda, as si Jeroboama pōtot ni Joas, ki āri do Israel. ");
INSERT INTO ivb_vpl VALUES ("AM1_2","031_1_2","AMO","1","2","2","Binata ni Amos a kāna, “Komalebkeb kapaychirin ni ĀPO a yapo do Sion a akmay adey timek na do Jerosalem. Do kasoli no Dyos, nagtīkag saw pagpaspastoran saw, kan nahayo saw tamekaw do Tokon a Karmel.” ");
INSERT INTO ivb_vpl VALUES ("AM1_3","031_1_3","AMO","1","3","3","Binata ni ĀPO a kāna, “Nāw da maygaygatos no tawotawo do idi a Damasko. As dawa, sigorādo a dosāen ko sanchi, ta taywara a makamwamomo karanggas a pinarin da dyirad tawotawowaw do tana a Gilead. ");
INSERT INTO ivb_vpl VALUES ("AM1_4","031_1_4","AMO","1","4","4","Maynamot do dyaya, ipanamay konchiw palasyowaw a pinatnek ni Āri Hasael, kan temtemen ko sanchiw kōta ni Āri Benhada. ");
INSERT INTO ivb_vpl VALUES ("AM1_5","031_1_5","AMO","1","5","5","Rakraken konchiw rowangan saw no Damasko. Ipadiman ko sanchiw tawotawo do Payahosongan no Aben kan iyaw mangigpet so baston a iyaw pangōlo no Bet-eden. On, siraw nya tawotawo no Sirya, ki maakaw sanchi do tana a Kir a mabahod.” ");
INSERT INTO ivb_vpl VALUES ("AM1_6","031_1_6","AMO","1","6","6","Binata ni ĀPO a kāna, “Nāw da maygaygatos no tawotawo do idi a Gasa. As dawa, sigorādo a dosāen ko sanchi, ta inakaw daw tabo tawotawo no asa kanasyon a sibabahod, as nakailāko da sira a tagābo dyirad tawotawowaw do tana a Edom. ");
INSERT INTO ivb_vpl VALUES ("AM1_7","031_1_7","AMO","1","7","7","Maynamot do dyaya, ipanamay konchi iyaw pinakaahad no Gasa, kan temtemen ko sanchiw kōta na. ");
INSERT INTO ivb_vpl VALUES ("AM1_8","031_1_8","AMO","1","8","8","Ipadiman konchiw āri do idi a Asdod. Masaw do mangigpetaw so baston do idi no Askelon. Dosāen ko panchiw tawotawo do idi no Ekron kan siraw nakalāsat a Pilisteo, ki madiman sanchi.” Nyaw binata ni Āpo DYOS. ");
INSERT INTO ivb_vpl VALUES ("AM1_9","031_1_9","AMO","1","9","9","Binata ni ĀPO a kāna, “Nāw da maygaygatos no tawotawo do Tiro. As dawa, sigorādo a dosāen ko sanchi, ta inparawat da tabo tawotawo no asa kanasyon a sibabahod, as nakailāko da sira dyirad tawotawo do tana a Edom do nakainonolay daw so tōlag no kapaysisīt. ");
INSERT INTO ivb_vpl VALUES ("AM1_10","031_1_10","AMO","1","10","10","Maynamot do dyaya, ipanamay konchi iyaw pinakaahad no Tiro, kan temtemen ko sanchiw kōta na.” ");
INSERT INTO ivb_vpl VALUES ("AM1_11","031_1_11","AMO","1","11","11","Binata ni ĀPO a kāna, “Nāw da maygaygatos no tawotawo do Edom. As dawa, sigorādo a dosāen ko sanchi, ta linakatan da saw kakakteh da saw a Israelita so ispada, kan aba polos kāsi da sira. Nāw da makasoli, kan polos sa a dya homanebneb. ");
INSERT INTO ivb_vpl VALUES ("AM1_12","031_1_12","AMO","1","12","12","Maynamot do dyaya, ipanamay konchi iyaw idi a Teman, kan temtemen ko sanchiw kōta no Bosrah.” ");
INSERT INTO ivb_vpl VALUES ("AM1_13","031_1_13","AMO","1","13","13","Binata ni ĀPO a kāna, “Nāw da maygaygatos no tawotawo do Ammon. As dawa, sigorādo a dosāen ko sanchi, ta do kapachigobat da a maynamot do kakey da mayāgom so tana no matarek, binochakan da a iniwangan bodek dan mabogi saw a mababakes a myan do Gilead. ");
INSERT INTO ivb_vpl VALUES ("AM1_14","031_1_14","AMO","1","14","14","Maynamot do dyaya, ipanamay konchi iyaw pinakaahad no idi a Rabbah, kan temtemen ko sanchiw kōta na. Do dāwrinchi a araw no kapaggobat, maychangengengey sanchi, as akmanchi so mayitaw a bagyo iyaw mapasāmak a gobat. ");
INSERT INTO ivb_vpl VALUES ("AM1_15","031_1_15","AMO","1","15","15","Maakaw sanchiw āri na kontodo opisyalis na a sibabahod, kan maiyangay sanchi do matarek a tana.” Nyaw binata ni ĀPO. ");
INSERT INTO ivb_vpl VALUES ("AM2_1","031_2_1","AMO","2","1","1","Binata ni ĀPO a kāna, “Nāw da maygaygatos no tawotawo do Moab. As dawa, sigorādo a dosāen ko sanchi, ta aba polos anyib da do tohatohang naw no nadimanaw a āri do Edom, ta sinosohan da mandan nayahbek. ");
INSERT INTO ivb_vpl VALUES ("AM2_2","031_2_2","AMO","2","2","2","Ipanamay konchiw tana a Moab, kan temtemen ko sanchiw kōta no Keryot. Madiman sanchiw tawotawo do Moab do kayan da magariwāwa do gobat, do kadama da maychangengengey no soldādo kan kaitanggoyob no trompita. ");
INSERT INTO ivb_vpl VALUES ("AM2_3","031_2_3","AMO","2","3","3","Dimanen konchiw magtoray do Moab kontodo opisyalis no nawri a tana.” Nyaw binata ni ĀPO. ");
INSERT INTO ivb_vpl VALUES ("AM2_4","031_2_4","AMO","2","4","4","Binata ni ĀPO a kāna, “Nāw da maygaygatos no tawotawo do Joda. As dawa, sigorādo a dosāen ko sanchi, ta inchipa da saw linteg ko kan tinongpal dabaw bilbilin ko. Napāwaw sa dyirad didyosen a siraw inononotan dan kapoonan da saw. ");
INSERT INTO ivb_vpl VALUES ("AM2_5","031_2_5","AMO","2","5","5","Maynamot do dyaya, ipanamay konchi iyaw tana do Joda, kan temtemen ko sanchiw kōta no Jerosalem.” ");
INSERT INTO ivb_vpl VALUES ("AM2_6","031_2_6","AMO","2","6","6","Binata ni ĀPO a kāna, “Nāw da maygaygatos no tawotawo do Israel. As dawa, sigorādo a dosāen ko sanchi, ta ilāko da saw monot saw do kosto kan panādi da so pirak, as siraw mapopobri saw itādi da do asa lang a kapāris no tokap. ");
INSERT INTO ivb_vpl VALUES ("AM2_7","031_2_7","AMO","2","7","7","Lasalasagan da saw mapopobri, kan tod da sa pawadinen naidadanes saw. Oknoden pan may-āmang asa mabakes, ta dawa, laposan daw masantwan a ngaran ko. ");
INSERT INTO ivb_vpl VALUES ("AM2_8","031_2_8","AMO","2","8","8","Do tabon logar a pagdaydayāwan da, naypoktadan da saw laylayaw a naisalda dyira. Do timplowaw no Dyos da, ininom daw palek a nahap da a molta. ");
INSERT INTO ivb_vpl VALUES ("AM2_9","031_2_9","AMO","2","9","9","“Do salapen nyo a tawotawo ko, inabo ko saw tawotawo a Amorreoa makakarang a akmas kayokayo a sidro kan akma pas kayit no kayokayo a logo. Rinarayaw ko asi na kontodo yamot na saw. ");
INSERT INTO ivb_vpl VALUES ("AM2_10","031_2_10","AMO","2","10","10","Yaken nangihtot dyinyo do Egipto. Inpangōlwan koynyo do let-ang so apat a poho a katawen kan intoroh ko paw tana daw no Amorreo. ");
INSERT INTO ivb_vpl VALUES ("AM2_11","031_2_11","AMO","2","11","11","Tinongdo ko saw kadwan a anak nyo a mahahakay a mayparin a propīta, kan kadwan a babbaro nyo a mayparin a Nasireo. Oyod abawriw nya, inyo a tawotawo no Israel?” inyahes ni ĀPO. ");
INSERT INTO ivb_vpl VALUES ("AM2_12","031_2_12","AMO","2","12","12","“Ki pinaynom nyos palek Nasireo saw, kan binilin nyo saw propītaw a dyi da ibahey inpaltiing ko dyira. ");
INSERT INTO ivb_vpl VALUES ("AM2_13","031_2_13","AMO","2","13","13","Changori, pakaspyen koynyo a akmas karisonaw a napno so irek. ");
INSERT INTO ivb_vpl VALUES ("AM2_14","031_2_14","AMO","2","14","14","Aran siraw matataray saw a mayyayo, makadichan sabanchi a polos! Siraw mayiyit saw, ki komapsot sanchi. As kan siraw soldādo, ki maisalākan dabanchiw mismo da inawan. ");
INSERT INTO ivb_vpl VALUES ("AM2_15","031_2_15","AMO","2","15","15","Siraw magaganay saw a maypāpana, ki pīlit sanchi a magsanod. No matataray saw a mayyayo, ki makaditdit sabanchi. As kan siraw komakabalyowaw, ki maisalākan dabanchiw inawan da. ");
INSERT INTO ivb_vpl VALUES ("AM2_16","031_2_16","AMO","2","16","16","Aran siraw katotordan a soldādo, ki iwarsi danchiw armas da, as kapayyayo da do dāwrinchi a araw,” binata ni ĀPO. ");
INSERT INTO ivb_vpl VALUES ("AM3_1","031_3_1","AMO","3","1","1","Adngeyen nyo nya chirin ni ĀPO a maikontra dyinyo a tawotawo no Israel. On, nya minsāhi, ki maikontra dyirad intīro a nasyon a inihtot na a yapo do Egipto. ");
INSERT INTO ivb_vpl VALUES ("AM3_2","031_3_2","AMO","3","2","2","“Yapo do tabo nasyon do hapotayan tana, inyo lang pinidi ko kan inay-aywanan. Dawa, maynamot do tabo a gatogatos nyo, dosāen konchinyo.” ");
INSERT INTO ivb_vpl VALUES ("AM3_3","031_3_3","AMO","3","3","3","Mayrayay sawri a mayam dadwa tawo an dyi sa manma magtōlag? ");
INSERT INTO ivb_vpl VALUES ("AM3_4","031_3_4","AMO","3","4","4","Mayngerngeroriw lion do kahasan an abo nachichwasan na sangraben na? Mayngerngeroriw bomaro a lion do abab na an abo nahap na? ");
INSERT INTO ivb_vpl VALUES ("AM3_5","031_3_5","AMO","3","5","5","Masdokoriw manomanok an dya mapawkoy asdok? Mabokchitoriw asdok an dya madyiway? ");
INSERT INTO ivb_vpl VALUES ("AM3_6","031_3_6","AMO","3","6","6","An maitanggoyob trompita do syodad a mangipakatoneng so gobat, maychamirpirpir sabawriw tawotawo? Aryoriw didigra do asa syodad an dya ipalōbos ni ĀPO? ");
INSERT INTO ivb_vpl VALUES ("AM3_7","031_3_7","AMO","3","7","7","Masigorādo a panmanmahen aba parinen Āpo a DYOS aran āngo an dyi na manma ipaltiing panggep naw dyirad propīta na sa. ");
INSERT INTO ivb_vpl VALUES ("AM3_8","031_3_8","AMO","3","8","8","Nakapayngerngeraw no lion, aryoriw dya namo? Nakapaychirinaw ni Āpo a DYOS, sino maskeh a mangipakatoneng so inpaltiing na? ");
INSERT INTO ivb_vpl VALUES ("AM3_9","031_3_9","AMO","3","9","9","Ipakatoneng nyo do tawotawo a myan dyirad kōta saw no idi a Asdod kan tana a Egipto a kon nyo, “Maychichipeh kamo do tokotokonaw do omdibon no idi a Samarya, kan saksyan nyo rakoh a riribok do irahem no nawri a syodad kan kaidadanes a mapariparin daw.” ");
INSERT INTO ivb_vpl VALUES ("AM3_10","031_3_10","AMO","3","10","10","Binata ni ĀPO a kāna, “Chapatak daba no nya tawotawo mamarin so kosto. Apnopnohen daw kōta da so kinabaknang a yapo do kasamsam kan karanggas da.” ");
INSERT INTO ivb_vpl VALUES ("AM3_11","031_3_11","AMO","3","11","11","Dawa, nyaw binata ni Āpo a DYOS a kāna, “Myan anchiw kabōsor a mangdibon do tana nyo. Abohen danchiw kayit nyo, as kan samsaman danchiw kōta nyo sa.” ");
INSERT INTO ivb_vpl VALUES ("AM3_12","031_3_12","AMO","3","12","12","Binata ni ĀPO a kāna, “Akmas asa magpaspastor a mangisalākan do dangoy no asa lion so dadwaw lang a kokod no karniro mana bīt danan tadyinya na, komwan anchiw maparin dyirad papere lang a makalāsat a tawotawo no Samarya a maypoypoktad dyirad mapipintasaw a katri da. ");
INSERT INTO ivb_vpl VALUES ("AM3_13","031_3_13","AMO","3","13","13","Mangadngey kamo kan saksyan nyo maikontra do kapotōtan Jakob,” kāna ni Āpo a DYOS a Manakabalin do Tābo. ");
INSERT INTO ivb_vpl VALUES ("AM3_14","031_3_14","AMO","3","14","14","“Anchan araw a kapangdōsa ko dyirad tawotawo no Israel maynamot dyirad gatogatos da, rarayawen ko sanchiw altar do Betel. Makteb anchiw apat saw a sinan olong no kāda aroywan no altaraw, as masday sanchi do tana. ");
INSERT INTO ivb_vpl VALUES ("AM3_15","031_3_15","AMO","3","15","15","Rarayawen konchiw bahay a para do ammyan kan komwan pa do bahay a para do rayon. Siraw bahabahay a nabistyan so sōng saw no elepanti, ki mararayaw sanchi. On, siraw bahabahay dan mabaknang, mararayaw sanchi a tabo.” ");
INSERT INTO ivb_vpl VALUES ("AM4_1","031_4_1","AMO","4","1","1","Adngeyen nyo nya, inyo a mababakes do Samarya a tomaba a akmas siras bāka saw do Basan, inyo a mangidadanes siras mapopobri kan mangtokatokap siras makachitaw, as kan mangbilin siras lallakay nyo saw a iyangayan daynyo so inomen. ");
INSERT INTO ivb_vpl VALUES ("AM4_2","031_4_2","AMO","4","2","2","Maynamot do kasanto ni Āpo a DYOS, insapata na a kāna, “Masyirto a ītonchiw araw a magorogod kamo do sadyit. On, kāda asa dyinyo, ki akmas amongaw a masayrinan a maikaro. ");
INSERT INTO ivb_vpl VALUES ("AM4_3","031_4_3","AMO","4","3","3","Igōyod danchinyo a iyangay a derecho do singit no naloyo a ahad, as kaitapwak da dyinyo.” ");
INSERT INTO ivb_vpl VALUES ("AM4_4","031_4_4","AMO","4","4","4","Binata ni ĀPO dyirad tawotawo no Israel a kāna, “Sīgi! Kangay nyo do Betel a maygatos! Mangay kamo pa maygatos do Gilgal, as iyad-adda nyo daw! Mangyangay kamo so binyay a idāton nyo do kāda mabekas, as kan kapangyangay nyo so apagkapollo nyo daw do kāda tatdo a karaw. ");
INSERT INTO ivb_vpl VALUES ("AM4_5","031_4_5","AMO","4","5","5","Mangidāton kamwaya so tināpay a napangayan so yapo a para do kapagyaman nyo do Dyos, kan ipangas nyo sobsobra dāton a iyangay nyo. Iyaw nyaw chadaw nyo a tawotawo do Israel a parinen,” binata ni Āpo a DYOS. ");
INSERT INTO ivb_vpl VALUES ("AM4_6","031_4_6","AMO","4","6","6","“Yaken napaychapteng do kāda syodad kan kāda idi, ki alit na dyi kamo pa a naybidi dyaken. ");
INSERT INTO ivb_vpl VALUES ("AM4_7","031_4_7","AMO","4","7","7","Pinachimoy kwaba do taywara kachitan mohamoha nyo so ranom. Pinachimoy ko do asa a idi, ki engga do matarek. Nachimoyan asaw a bengkag, ki nayapseng asaw. ");
INSERT INTO ivb_vpl VALUES ("AM4_8","031_4_8","AMO","4","8","8","Siraw tawotawo, mapāpasyaw sa midibidi do kāda idi a maychichwas so ranom a maynom da, ki alit na dyi sa makanawob. Ki aran komwan, alit na dyi kamo pa a naybidi dyaken,” binata ni ĀPO. ");
INSERT INTO ivb_vpl VALUES ("AM4_9","031_4_9","AMO","4","9","9","“Rinarayaw ko mohamoha nyo do hakawan kan kaobasan so ganyit kan domalangdang a salawsaw a yapod dāya. Inkisap no kabaga tabo bohobohong no kayokayo nyo a igos kan olibo. Aran komwan, alit na dyi kamo pa a naybidi dyaken,” binata ni ĀPO. ");
INSERT INTO ivb_vpl VALUES ("AM4_10","031_4_10","AMO","4","10","10","“Pinaganyit koynyo a akmas pinarin kwaw do Egipto. Diniman ko saw babbaro nyo do gobat, kan inpayyayo ko saw kabalyo nyo. Nawri danaw mangwangot nyo pinangyobek ko saw a nahta a bangkay do kampo nyo. Ki aran komwan, alit na dyi kamo pa a naybidi dyaken,” binata ni ĀPO. ");
INSERT INTO ivb_vpl VALUES ("AM4_11","031_4_11","AMO","4","11","11","“Rinarayaw ko kadwan dyinyo akmas nakararayaw kwaw so Sodoma kan Gomorra. Inyo a nakalāsat, akma kamwaya so ahotenaw a masososohan a nalnet do apoy. Ki aran komwan, alit na dyi kamo pa a naybidi dyaken,” binata ni ĀPO. ");
INSERT INTO ivb_vpl VALUES ("AM4_12","031_4_12","AMO","4","12","12","“As dawa, dosāen konchi inyo a tawotawo do Israel. Maynamot ta parinen ko nya dyinyo, saganāan nyo kabayat nyo so kapangokom no Dyos nyo!” ");
INSERT INTO ivb_vpl VALUES ("AM4_13","031_4_13","AMO","4","13","13","No Dyos, iyaw nangpotar so tokotokon kan namarswa so salawsaw. Ipakatoneng naw kapangtokto na do tawotawo. Payparinen na a sari iyaw maraw. Mayam do katotohosan a yanan do tanaya. ĀPO a Dyos a Manakabalin do Tābo iyaw ngaran na! ");
INSERT INTO ivb_vpl VALUES ("AM5_1","031_5_1","AMO","5","1","1","Adngey nyo, inyo a tawotawo do Israel, iyaw pagdongdong-aw kwaya a maynamot dyinyo: ");
INSERT INTO ivb_vpl VALUES ("AM5_2","031_5_2","AMO","5","2","2","“Nabahatog danaw birhin a Israel, kan nakapaybangon paba! Naharaharag dana a nainonolay do tana, kan arabaw mangbangon sya.” ");
INSERT INTO ivb_vpl VALUES ("AM5_3","031_5_3","AMO","5","3","3","Binata ni Āpo a DYOS a kāna, “Iyaw syodad do Israel a manoboy so asa ribo a soldādo a machigobat, ki asa gasot anchi lang makapaybidi. Iyaw asa idi a manoboy so asa gasot a soldādo a machigobat, ki asa poho anchi lang makapaybidi.” ");
INSERT INTO ivb_vpl VALUES ("AM5_4","031_5_4","AMO","5","4","4","Iyaw nyaw binata ni ĀPO dyirad tawotawo do Israel a kāna, “Maybidi kamo dyaken kan mabyay kamo. ");
INSERT INTO ivb_vpl VALUES ("AM5_5","031_5_5","AMO","5","5","5","May kamo aba do Betel a magdaydāyaw siras didyosen, kan mangay kamo aba dyirad bolto saw do Gilgal, mana romapit kamo aba do Beerseba. Ta siraw tawotawo do Gilgal, ki masigorādo a maakaw sanchi, as siraw tawotawo do Betel, ki apabanchiw sinpaspangan da.” ");
INSERT INTO ivb_vpl VALUES ("AM5_6","031_5_6","AMO","5","6","6","Maybidi kamo di ĀPO kan mabyay kamo, ta angwan dalaposen naw kapotōtan ni Jose a akmay apoy a mangabo siras myan do Betel, kan aba polos makasboy sya. ");
INSERT INTO ivb_vpl VALUES ("AM5_7","031_5_7","AMO","5","7","7","Kapakāsi nyo pa, ta dyinido nyo kosto a kapangokom a nayparin a makpad, as kan inpoha nyo kinalinteg a akmay basora. ");
INSERT INTO ivb_vpl VALUES ("AM5_8","031_5_8","AMO","5","8","8","Si ĀPO, namarswa siras bitohen saya, siraw mayngaranaw so Pliyades kan Orion. Iyaw mapaybadiw so sari a mayparin a sedang, kan mapaybadiw so maraw a mahep. Iyaw manghap so ranom do tāw, as padohen na a akmas chimoy do tana. ĀPO iyaw ngaran na. ");
INSERT INTO ivb_vpl VALUES ("AM5_9","031_5_9","AMO","5","9","9","Apagilap, kararayaw nas mabīleg saw kan kōta da saw. ");
INSERT INTO ivb_vpl VALUES ("AM5_10","031_5_10","AMO","5","10","10","Ipsok nyo mangitēnek so kosto do pangokoman, kan idadanes nyo iyaw mangibaheyaw so oyod. ");
INSERT INTO ivb_vpl VALUES ("AM5_11","031_5_11","AMO","5","11","11","Linasalasagan nyo mapopobri saw, kan tinakawan nyo sa so trigo. Dawa, aran mapatnek kamo so bahay nyo a bato a mapipintas, polos a dyi kamonchi a makapagyan daw. Aran maraber saw kaobasan a inmoha nyo, polos anchi a dyi nyo a maynom palek da. ");
INSERT INTO ivb_vpl VALUES ("AM5_12","031_5_12","AMO","5","12","12","Chapatak ko an maypāngo kataywara no kasokir nyo kan maypāngo karahmet no gatos nyo. Lidyalidyaten nyo tawo saw a malinteg do kapangdaw nyos pasoksok, as kan pinenpen nyo kinalinteg dyirad mapopobri saw do pangokoman. ");
INSERT INTO ivb_vpl VALUES ("AM5_13","031_5_13","AMO","5","13","13","Dawa, iyaw tawo a masīrib, ki maganaganay dana an dya maylilyak, maynamot ta mamarahet dana saw nyaya araw. ");
INSERT INTO ivb_vpl VALUES ("AM5_14","031_5_14","AMO","5","14","14","Nāw nyo chichwasen maganay a dya iyaw marahet tan mabyay kamo. Do dāwri, myan anchi si ĀPO Dyos a Manakabalin do Tābo dyinyo a akmas inbahey nyowaw a maynamot dya. ");
INSERT INTO ivb_vpl VALUES ("AM5_15","031_5_15","AMO","5","15","15","Ipsok nyo marahet kan chadaw nyo maganay. Pagāryen nyo kinalinteg do pangokoman. Āngonchan si ĀPO a Manakabalin, maāsot kāsi na do tawotawo no nya nasyon dyirad nakalāsat saw a sibibyay pa. ");
INSERT INTO ivb_vpl VALUES ("AM5_16","031_5_16","AMO","5","16","16","Dawa, nyaw binata ni ĀPO a Manakabalin do Tābo a kāna, “Myan anchiw kapagdongdong-aw do kāda plasa, kan myan saw magarimbāngaw do oltimo a liday da do tabo a kalkalsāda do syodadaya. Matawagan sanchiw homakahakaw a machitanyitanyis kan siraw matangtangdanan saw a magdongdong-aw. ");
INSERT INTO ivb_vpl VALUES ("AM5_17","031_5_17","AMO","5","17","17","Myan kapagdongdong-aw do tabo kaobasan, ta mangay akonchi a midibidi a mangdōsa dyinyo.” Nyaw binata ni ĀPO. ");
INSERT INTO ivb_vpl VALUES ("AM5_18","031_5_18","AMO","5","18","18","Kapakāsi nyo pa a mangahahay so araw a kangay ni ĀPO! Āngo paro maganay a maitoroh na no nawri a araw? Iyanchiw nawri, ki araw no sari a dya sedang. ");
INSERT INTO ivb_vpl VALUES ("AM5_19","031_5_19","AMO","5","19","19","Akma anchis tawowaw a payayowan naw lion, ki myan sawen mabayat na matarek a maranggas a animal. Mana akmas tawowaw a somnabat, do nakapanareng naw so tanoro naw do dyindyinaw, sinbat no boday! ");
INSERT INTO ivb_vpl VALUES ("AM5_20","031_5_20","AMO","5","20","20","Iyaw arawaw a kangay ni ĀPO, ki sari lang a abaw soho. Araw anchiw nawri a makalidliday, kan aba polos chinyel no sedang. ");
INSERT INTO ivb_vpl VALUES ("AM5_21","031_5_21","AMO","5","21","21","Binata ni ĀPO a kāna, “Ipsok ko saw sinsinan saw a pista nyo, kan maibtoran ko sabaw kapaychichipeh nyo. ");
INSERT INTO ivb_vpl VALUES ("AM5_22","031_5_22","AMO","5","22","22","Aran yangay nyo saw dāton saw a masosohan kan dāton saw a irek, rawaten ko sabanchi. Aran siranchiw pinataba nyo saw a binyay a dāton a mapaychachapya, ikaskāso kwabanchi. ");
INSERT INTO ivb_vpl VALUES ("AM5_23","031_5_23","AMO","5","23","23","Aryan nyo naw pakalikalyak nyo saya kanta nyo! Chakey kwaba adngeyen toktokar no arpa nyo! ");
INSERT INTO ivb_vpl VALUES ("AM5_24","031_5_24","AMO","5","24","24","Basbāli, pakono a pagāryen nyo kinalinteg a akmas kawyog naw no ranom do oksong, kan kalinteg a akmas rakohaw a oksong a dya polos a mayachan. ");
INSERT INTO ivb_vpl VALUES ("AM5_25","031_5_25","AMO","5","25","25","“Inyo a tawotawo do Israel, taywaran nangyangay kamo so dāton saw a masosohan dyaken kan siraw dāton saw a mapaychachapya do apat a poho a katawen do kayan nyo do let-ang? ");
INSERT INTO ivb_vpl VALUES ("AM5_26","031_5_26","AMO","5","26","26","Ki sichangori, maykatkat kamo siras dadwa saw a didyosen a pinarin nyo a para dyinyo a mismo a sa Sakkot a āri no didyosen nyo, kan Kaywan a iyaw bitohenaw a didyosen nyo. ");
INSERT INTO ivb_vpl VALUES ("AM5_27","031_5_27","AMO","5","27","27","Dawa, payamen koynyo a sibabahod a akawen do labes no Damasko a syodad.” Nyaw binata ni ĀPO, iyaw Dyos a Manakabalin do Tābo. ");
INSERT INTO ivb_vpl VALUES ("AM6_1","031_6_1","AMO","6","1","1","Kapakāsi nyo pa, inyo a maydamnay dana so kabibyay do Sion kan inyo a omyan do Samarya a maimas danas kayayan. On, kapakāsi nyo pa, inyo a mabigbigbig a pangpangōlo do dyaya a mabīleg a nasyon a napidi kan kwanan da no tawotawo do Israel an makachita sa so sidong. ");
INSERT INTO ivb_vpl VALUES ("AM6_2","031_6_2","AMO","6","2","2","Mangay nyo a chiban syodad no Kalne, as kapaypakwan nyo do mabīleg a syodad no Hamat, kan maypawsok kamo pa do Gat a syodad dan Pilisteo. Maganaganayoriw pagāryan da kan iyaw pagāryan Joda kan Israel? Maraharahawawriw tana da kan tana nyo? ");
INSERT INTO ivb_vpl VALUES ("AM6_3","031_6_3","AMO","6","3","3","Chaskeh nyo a rawaten iyaw ītonchi a kayan didigra. Ki maynamot do kaparin nyo, paypasngenen nyo paw kangay no nawri a araw no kinaranggas. ");
INSERT INTO ivb_vpl VALUES ("AM6_4","031_6_4","AMO","6","4","4","Kapakāsi nyo pa inyo a maylolonat do mangingīna a paydisnan, kan michaychan so karni a nadām a orbon no karniro kan bāka. ");
INSERT INTO ivb_vpl VALUES ("AM6_5","031_6_5","AMO","6","5","5","Chadaw nyo mamarin so kanta, kanta a akmas pinarin ni Dabid do kaychowa, kan tokaran nyo so arpa. ");
INSERT INTO ivb_vpl VALUES ("AM6_6","031_6_6","AMO","6","6","6","Minom kamo so sinabasabak a palek, kan magosar kamo so kangingināan naw a bangbanglo, ki pinagmamayo nyo abaw kararayaw no Israel. ");
INSERT INTO ivb_vpl VALUES ("AM6_7","031_6_7","AMO","6","7","7","Dawa, inyonchiw manma maakaw kan maiyangay do matarek a tana. Machipandanchi iyaw pista kan pasken nyo. ");
INSERT INTO ivb_vpl VALUES ("AM6_8","031_6_8","AMO","6","8","8","Si Āpo DYOS a Manakabalin do Tābo, nangisapata syay do mismo a kinadyos na a kāna, “Ipsok ko kapangas da no tawotawo no Israel kan siraw mangingīna a palasyo da. Itoroh konchi do kabōsor da iyaw syodad da kan tabwa myan daw.” ");
INSERT INTO ivb_vpl VALUES ("AM6_9","031_6_9","AMO","6","9","9","An asa poho a mahahakay nabidin do asa pamilya, madiman pa sanchi. ");
INSERT INTO ivb_vpl VALUES ("AM6_10","031_6_10","AMO","6","10","10","An mawaraw kabagyan naw a myan so rebbeng a mangihtot so bangkay saw a yangay na sosohan, kan manahes do nakalāsataw do bahay an myan paw tomayotayo daw a kāna, “Ariwriw rarayay mo?” Atbayen nanchi a kāna, “Aba!” Do dāwri, batahen no kabagyan naw a kāna, “Maylilyak kaba! Machita dyi ta ichirin ngaran ni ĀPO.” ");
INSERT INTO ivb_vpl VALUES ("AM6_11","031_6_11","AMO","6","11","11","Anchan magmandar si ĀPO, rakraken na sanchiw rarakohaw a bahay, kan homhomken na sanchiw dēdekey saw. ");
INSERT INTO ivb_vpl VALUES ("AM6_12","031_6_12","AMO","6","12","12","Makapayyayo sawriw kabalyo do rarakoh a bato? Ariwriw magarado a bāka do tāw? Aba! Ki pinayparin nyo a binīno iyaw kinalinteg, kan pinayparin nyo a kosto iyaw maddi! ");
INSERT INTO ivb_vpl VALUES ("AM6_13","031_6_13","AMO","6","13","13","Chasoyot nyo nakasākop nyo so idi no Lodebar. Pagpangas nyo a kon nyo, “Sinākop tabawriw Karnaim do bokod ta a ayit?” ");
INSERT INTO ivb_vpl VALUES ("AM6_14","031_6_14","AMO","6","14","14","Si ĀPO Dyos a Manakabalin do Tābo, makabata sya a kāna, “Inyo a tawotawo a Israel, manoboy akonchi so gan-ganaet a nasyon a mangsākop so nasyon nyo. Lidyalidyaten danchinyo a yapo do asdepan do Hamat do ammyānan a manda do dēkeyaw a oksong no Arabah do abagātan.” ");
INSERT INTO ivb_vpl VALUES ("AM7_1","031_7_1","AMO","7","1","1","Nyaw parmata a inpaboya dyaken ni Āpo a DYOS. Naboya ko nakaisagāna na siras kabaga saw do katayoka no kapagparaspas so bīnglay ni āri kan tomohos danaw somaronwaw. ");
INSERT INTO ivb_vpl VALUES ("AM7_2","031_7_2","AMO","7","2","2","Do parmata ko, naboya ko an maypāngo nakapatawos da no kabagaw so tabo a naimoha do tana. Do dāwri, binata ko a kon ko, “Āpo a DYOS, pakawanen mo pa saw tawotawo mo a Israel! Maypāngo pa sa mabyay? Dēkey dana sa kan apabaw ayit da!” ");
INSERT INTO ivb_vpl VALUES ("AM7_3","031_7_3","AMO","7","3","3","Naāsot kāsi ni ĀPO do pinanggep naw, kan binata na a kāna, “Sīgi! Maparin pabanchiw nya.” ");
INSERT INTO ivb_vpl VALUES ("AM7_4","031_7_4","AMO","7","4","4","Myan paw matarek a parmata inpaboya dyaken ni Āpo a DYOS. Naboya ko nakapagsagāna na a mangdosa so tawotawo na maynamot do apoy. Nasosohan iyaw marahemaw a tāw do irahem no tanaya kan inrogi na sosohan iyaw hapot no tana. ");
INSERT INTO ivb_vpl VALUES ("AM7_5","031_7_5","AMO","7","5","5","Binata ko a kon ko, “Āpo a DYOS, machikakaāsi ako dyimo a magsardeng ka na! Maypāngo pa sa mabyay tawotawo mo a Israel? Dēkey dana sa kan apabaw ayit da!” ");
INSERT INTO ivb_vpl VALUES ("AM7_6","031_7_6","AMO","7","6","6","Naāsot danaw kāsi ni Āpo a DYOS do pinanggep naw, kan binata na a kāna, “Sīgi! Aran iyaw nya, ki maparin pabanchi.” ");
INSERT INTO ivb_vpl VALUES ("AM7_7","031_7_7","AMO","7","7","7","Myan paw matarek a parmata dyaken ĀPO. Naboya ko a myan a mayteytēnek si ĀPO do bīt no asa ahad a napatnek a naosar pindōla. Myan na ig-igpet pindōlaw. ");
INSERT INTO ivb_vpl VALUES ("AM7_8","031_7_8","AMO","7","8","8","Inyahes na dyaken a kāna, “Āngo naboya mom Amos?” “Asa a pindōla,” initbay ko. Do dāwri, binata na a kāna, “Osaren ko nya a pangipaboya a mayārig tawotawo ko do asa ahad a napatnek a dya nawnotan iyaw pindōla. Magbaliw pabaw kapangtokto ko a mirwa do kadōsa ko sira. ");
INSERT INTO ivb_vpl VALUES ("AM7_9","031_7_9","AMO","7","9","9","Mararayaw sanchiw logar saw a nagdaydayāwan kapotōtan saw ni Isaak. Marakrak sanchiw masantwan saw a yanan do Israel. Abohen konchi iyaw kapagtoray no pampamilya ni Āri Jeroboam.” ");
INSERT INTO ivb_vpl VALUES ("AM7_10","031_7_10","AMO","7","10","10","Si Amasyas a pādi do Betel, ki nangirapit so dāmag di Jeroboam a āri do Israel, kan binata na a kāna, “Myanaw si Amos a propīta dyirad tawotawo do Israel a mangipangta so maikontra dyimo. Ay! Mararayaw logar taya do ibahebahey na saya. ");
INSERT INTO ivb_vpl VALUES ("AM7_11","031_7_11","AMO","7","11","11","Nyaw binata na a kāna, ‘Madiman anchi si Jeroboam do paggogobatan. Maakaw sanchi a sigorādo tawotawowaw do Israel a maikaro do sīgod a tana da.’” ");
INSERT INTO ivb_vpl VALUES ("AM7_12","031_7_12","AMO","7","12","12","Do dāwri, binata ni Amasyas di Amos a kāna, “Naw danam propīta! Maybidi ka na do Joda, kan dawriw pangipadtwan mo a magpabāyad. ");
INSERT INTO ivb_vpl VALUES ("AM7_13","031_7_13","AMO","7","13","13","Mangipadto ka paba do Betelaya, ta do dyaw logar a pagdaydayāwan āri kan timplo no pagāryanaya.” ");
INSERT INTO ivb_vpl VALUES ("AM7_14","031_7_14","AMO","7","14","14","Tominbay si Amos a kāna, “Taywaran yaken propītaw a magpabāyad an mangipadto ako? Yaken asa magpaspastor, kan mangay-aywan so kayokayo a sikamoro. ");
INSERT INTO ivb_vpl VALUES ("AM7_15","031_7_15","AMO","7","15","15","Ki tinawagan na yaken ĀPO a komaro do kapagpaspastor ko, kan inbilin na dyaken a mangipadto dyirad tawotawo na a Israel. ");
INSERT INTO ivb_vpl VALUES ("AM7_16","031_7_16","AMO","7","16","16","Changori, adngeyen mo minishi naya ni ĀPO. Batahen mo a magsardeng ako a mangipadto a maikontra dyirad tawotawo do Israel. ");
INSERT INTO ivb_vpl VALUES ("AM7_17","031_7_17","AMO","7","17","17","Dawa, mo Amasyas, nyaw binata ni ĀPO dyimo a kāna, ‘Mayparin anchis baket mo a maglaklāko so asi na do syodadaya. Madiman sanchiw pōtot mo do paggogobatan. Paychakarwan danchi no kompormi iyaw tana mo, as madiman kanchi do gan-ganaet a tana a dya mangbigbig si ĀPO Dyos. Maakaw sanchi a sigorādo tawotawowaw a Israel a maikaro do sīgod a tana da.’” ");
INSERT INTO ivb_vpl VALUES ("AM8_1","031_8_1","AMO","8","1","1","Myan paw matarek a parmata dyaken ni Āpo a DYOS. Nakaboya ako so asa kaalat a naynoy a asin kayo. ");
INSERT INTO ivb_vpl VALUES ("AM8_2","031_8_2","AMO","8","2","2","Inyahes ni ĀPO a kāna, “Amos, āngo naboya mo? “Asaya kaalat a naynoy a asin kayo”, initbay ko. Do dāwri, binata ni ĀPO dyaken a kāna, “Īto danaw chimpo a pachipandan no tawotawo ko a Israel a akmay naynoy a asin kayo. Magbāliw paba polos kapangtokto ko maynamot do kadōsa ko sira. ");
INSERT INTO ivb_vpl VALUES ("AM8_3","031_8_3","AMO","8","3","3","Kan do dāwrinchi a araw, siranchiw kankanta do palasyo, ki mayparin anchi a kapagdongdong-aw. Maychaharaharag sanchi a madiman do kāda yanan. Maipoha sanchi a sioolimek.” Nyaw binata ni Āpo a Dyos. ");
INSERT INTO ivb_vpl VALUES ("AM8_4","031_8_4","AMO","8","4","4","Adngeyen nyo nya, inyo a manglasalasag siras makachita kan magpanggep a mangabo siras mapopobryaya do dya tana. ");
INSERT INTO ivb_vpl VALUES ("AM8_5","031_8_5","AMO","8","5","5","No bata nyo do inawan nyo a kon nyo, “Malisto pakono a komabos ibidang daya a masantwan a araw tan mailāko namen irek saya? Aysa, kāngonchi a makabos araw no kapaynaynahah tan mirwa kami na maglāko? On, ta chakey namen a pangināen ilāko namen saya, kan osaren namen anchiw dya kosto a pagsokātan, as kan kosīten namen anchiw kīlo no gatāngen dayan gomatgātang saya. ");
INSERT INTO ivb_vpl VALUES ("AM8_6","031_8_6","AMO","8","6","6","Kangināen namen pangilakwan namen so mahopes a irek. Maychichwas kaminchi so mapobri a tawo a dya makabāyad so ōtang na, kan gatāngen namen pobryaw so balor lang no asa kapāris a tokap a payparinen a adipen.” ");
INSERT INTO ivb_vpl VALUES ("AM8_7","031_8_7","AMO","8","7","7","Nagsapata si ĀPO a Dyos no Israel, “Polos anchi a dyi ko a mawayakan mararahet a kaparin da. ");
INSERT INTO ivb_vpl VALUES ("AM8_8","031_8_8","AMO","8","8","8","Magin-gined anchiw tanaya maynamot do dyaya, kan magdongdong-aw sanchiw tabo tawotawo do tanaya. Magalloallon anchiw tābo tanaya a akmas oksongaw a Nile do Egipto.” ");
INSERT INTO ivb_vpl VALUES ("AM8_9","031_8_9","AMO","8","9","9","Binata ni Āpo a DYOS a kāna, “Do dāwrinchi a araw, pasdepen konchiw araw an mayegen, kan paysaryen ko tanaya an māraw. ");
INSERT INTO ivb_vpl VALUES ("AM8_10","031_8_10","AMO","8","10","10","Payparinen konchiw pispista nyo a dongdong-aw. Payparinen konchiw mararagsak a kankanta nyo a katanyis. Ipalaylay konchi inyo so makekersang saw a laylay, kan ipachischis konchiw oho nyo. Payparinen konchi inyo a akma siras inyaynyapwan saw a magmamayo do kadiman no moyboh a mahakay a anak da. As kan do dāwrinchi a araw, ki mayparin a makpad a nāw na malidyat a manda do tawsan na.” ");
INSERT INTO ivb_vpl VALUES ("AM8_11","031_8_11","AMO","8","11","11","Binata ni Āpo a DYOS a kāna, “Īto danaw chimpo a kapangyangay ko so kapaychapteng do tanaya, ki nawri abanchiw paychaptengan daw mākan. Ranom abanchiw kawawan da, an dya iyaw kadngey da so minsahi ko. Yaken si ĀPO a nangibahey syay. ");
INSERT INTO ivb_vpl VALUES ("AM8_12","031_8_12","AMO","8","12","12","Mapāpasyaw sanchiw tawotawo a midibidi yapo do asa a tāw a komwan do matarek a tāw, kan maypadibon sanchi yapo do ammyānan a maypakwan do dāya a maychichwas so chirin ni ĀPO, ki polos anchi a dyi da madongso. ");
INSERT INTO ivb_vpl VALUES ("AM8_13","031_8_13","AMO","8","13","13","Do dāwrinchi a araw, siraw mapipintas saw a babbalāsang kan siraw mayiyit saw a babbaro, ki mapleng sa do taywara a kawaw da. ");
INSERT INTO ivb_vpl VALUES ("AM8_14","031_8_14","AMO","8","14","14","Siraw mangisapataw do didyosen no Samarya a makabata a kon da, ‘Do Dyos no Dan’ mana ‘Do Dyos no Beerseba’, siraw nawri a tawo, ki malba kan makapaybangon pa sabanchi.” ");
INSERT INTO ivb_vpl VALUES ("AM9_1","031_9_1","AMO","9","1","1","Naboya ko si Āpo a mayteytēnek do bīt naw no altar. Inbilin naw nya a kāna, “Māswen mo totok saya no parey no Timplo tan magon-gon pondasyon na saya. Loyohen mo kan inolay mo a masday do oho dan tawotawo saya. Siraw nabidin saw a tawotawo, ki ipadiman ko sanchi do ispāda. Abanchiw makapayyayo, kan abanchiw makalības. ");
INSERT INTO ivb_vpl VALUES ("AM9_2","031_9_2","AMO","9","2","2","Aran machikolkol sa do yanan no kadiman, alneten ko sanchi. Aran komayat sanchi do hanyit, pagchinen ko sanchi. ");
INSERT INTO ivb_vpl VALUES ("AM9_3","031_9_3","AMO","9","3","3","Aran tomayo sa do totok no Tokon a Karmel, chichwasen ko sanchi kan tiliwen ko sa. Aran taywan da yaken do irahem no tāw, bilinen konchiw rakohaw a boday a mangay a omsonyit dyira. ");
INSERT INTO ivb_vpl VALUES ("AM9_4","031_9_4","AMO","9","4","4","Aran ihtot da san kabōsor da a akawen, ibilin konchi a ipadiman da sa do ispāda. Nawrinchiw chichiban ko iyaw kararayaw da, iyabaw kasidong ko sira.” ");
INSERT INTO ivb_vpl VALUES ("AM9_5","031_9_5","AMO","9","5","5","Si Āpo a DYOS a Manakabalin do Tābo, saliden naw tanaya kan malonag, kan magdong-aw tabo a omyan daw. No tābo tanaya, ki magalloallon a akmas oksong a Nile do Egipto. ");
INSERT INTO ivb_vpl VALUES ("AM9_6","031_9_6","AMO","9","6","6","Mapatnek si ĀPO so bahay na do hanyit, kan pangayen naw pondasyon na do tanaya. Tawagan naw ranom do tāw, kan padohen na do hapotayan tana. Si ĀPO ngaran na. ");
INSERT INTO ivb_vpl VALUES ("AM9_7","031_9_7","AMO","9","7","7","Binata ni ĀPO a kāna, “Inyo a tawotawo do Israel, akma kamo siras taga Etiopyaw dyaken. Inihtot ko saw Pilisteo a yapo do Kreta kan siraw taga Siryaw a yapo do Kir a akmas nakaihtot kwaw dyinyo a yapo do Egipto. ");
INSERT INTO ivb_vpl VALUES ("AM9_8","031_9_8","AMO","9","8","8","Yaken si Āpo a DYOS, mangsipsipot so nya magagatosen a tawotawo do pagāryan no Israel. Rarayawen ko sanchi a abohen do hapotayan tana, ki rarayawen ko abanchi a tabo iyaw kapotōtan Jakob. ");
INSERT INTO ivb_vpl VALUES ("AM9_9","031_9_9","AMO","9","9","9","“Do mandar ko, yokoyoken konchiw tawotawo do Israel. On, yokoyoken ko sanchi a karāman dan tabo saya nasyon tan mapakaro tabo a abo so sirsirbi. ");
INSERT INTO ivb_vpl VALUES ("AM9_10","031_9_10","AMO","9","10","10","Tabo no magagatosen do tawotawo ko, ki madiman sanchi do ispāda. On, tabon makabata sya a kon da, ‘Abanchiw didigra a mangyoba mana makasngen dyaten.’” ");
INSERT INTO ivb_vpl VALUES ("AM9_11","031_9_11","AMO","9","11","11","Binata ni ĀPO a kāna, “Īto danaw araw a pirwahen ko na bangonen pagāryan ni Dabid a mayarig do asa nalasa a bahay. Paysonongen ko sanchiw ahad na, kan pabidyen konchiw plastar naw. Bangonen kan payparinen konchi a akmas sīgod a kayayan na. ");
INSERT INTO ivb_vpl VALUES ("AM9_12","031_9_12","AMO","9","12","12","Tan komwan, sakōpen nanchi no tawotawo a Israel nabidin saw a tana no Edom kan tabo a nasyon a dyaken do nakarahan.” Komwan chirin ni ĀPO a mangparin anchi sira syay. ");
INSERT INTO ivb_vpl VALUES ("AM9_13","031_9_13","AMO","9","13","13","Binata ni ĀPO a kāna, “Īto dana saw araw a dyi sa makagaben magranyi do kāro no āpit, kan dya kadasan no maypaypalek so maynoy a obas. Maytetedted sanchiw bayo a palek a yapo do katokotokonan, kan maychawoyog anchi do paytoytokonan. ");
INSERT INTO ivb_vpl VALUES ("AM9_14","031_9_14","AMO","9","14","14","Pabidyen ko sanchiw naakaw saw a tawotawo ko a Israel do tana da. Patneken da sanchi a mirwaw nararayaw saw a syodad da kan omyan dana sa daw. Maymoha sanchi so obas, kan inomen da panchiw palek naw. Homakaw sanchi, kan kanen danchiw maāpit da. ");
INSERT INTO ivb_vpl VALUES ("AM9_15","031_9_15","AMO","9","15","15","Imoha konchiw tawotawo a Israel do tana a intoroh ko dyira, kan mabagot pa sabanchi a mirwa.” Nyaw binata ni ĀPO a Dyos nyo.");
INSERT INTO ivb_vpl VALUES ("OB1_1","032_1_1","OBA","1","1","1","Nyaw inpaltiing ni ĀPO a Manakabalin do Tābo di Obadyas a maynamot do nasyon a Edom. Tinoboy ni ĀPO iyaw minsahiro naw dyirad nasnasyon saw, kan nadngey namen minsāhi na a kāna, “Magsagāna kamo! Mangay ta machigobat kontra do Edom!” ");
INSERT INTO ivb_vpl VALUES ("OB1_2","032_1_2","OBA","1","2","2","Binata ni ĀPO do Edom a kāna, “Payparinen koymo a sinsinan, as taywara anchiw kaidadanes da dyimo. ");
INSERT INTO ivb_vpl VALUES ("OB1_3","032_1_3","OBA","1","3","3","Inallilaw naymo no kapangas mwaya, imo a machilibeng do kōta a bato. Nya logar mo, ki do katokotokonan. Batahen mo do inawan mo, ‘Aryoriw makarawa a mangalnet tan masday ako?’ ");
INSERT INTO ivb_vpl VALUES ("OB1_4","032_1_4","OBA","1","4","4","Aran tomodem ka akmas katohos no kasayap no kangkang, kan aran maparin mo maybahay do kabitohenan, alit na alneten konchimo a asdayen,” binata ni ĀPO. ");
INSERT INTO ivb_vpl VALUES ("OB1_5","032_1_5","OBA","1","5","5","“An mangay saw manakanakaw an mahep, sira lang hapen daw chakey da. An mamolas saw tawo so obas, myan paw bidinen da. Ki kapakāsi nyo pa, ta hanyiben danchinyo no kabōsor nyo. ");
INSERT INTO ivb_vpl VALUES ("OB1_6","032_1_6","OBA","1","6","6","Inyo a kapotōtan Esaw, pohsen danchiw dyira nyo do aran dino a paytayotaywan nyo, as madongso kan maagaw anchi a tabo kinabaknang nyo. ");
INSERT INTO ivb_vpl VALUES ("OB1_7","032_1_7","OBA","1","7","7","Linipotan daynyo no tabo kayban nyo. Pinaksyat daynyo do bōkod nyo a nasyon. Siraw tawo a nachikapya dyinyo, sakōpen darananchi inyo. Siraw nachisīt a kinahanghang nyo, mapangay sa so pangotap dyinyo, kan mapootan nyo aba polos. ");
INSERT INTO ivb_vpl VALUES ("OB1_8","032_1_8","OBA","1","8","8","“Do dawrinchi a araw a kapangdōsa ko so Edom, dimanen ko sanchiw masisirib a tawo na, kan ponasen konchi a tabo kinasirib no Edom. ");
INSERT INTO ivb_vpl VALUES ("OB1_9","032_1_9","OBA","1","9","9","Mamirpir sanchiw taga darop no Teman, kan kāda soldādo no Edom, ki madiman sa a abos kāsi,” binata ni ĀPO. ");
INSERT INTO ivb_vpl VALUES ("OB1_10","032_1_10","OBA","1","10","10","“Maynamot do nakaranggas mo so kakabagyan mo a kapotōtan ni Jakob, makneb kanchi so asnek, kan mararayaw kanchi a abos pandan. ");
INSERT INTO ivb_vpl VALUES ("OB1_11","032_1_11","OBA","1","11","11","Ta tod ka naytēnek do arawaw a nakarakrak da no kabōsor da sa so rowangan da saw. Maiyarig iyaw karahet mo dyirad gan-ganaet saw a mangsākop a nangipayyayo siras kinabaknang no Jerosalem, kan nagbibingayan da. ");
INSERT INTO ivb_vpl VALUES ("OB1_12","032_1_12","OBA","1","12","12","Dyi ka pakono a masoyosoyot do makasyasi a pinasar no kakabagyan mo sa do Joda. Dyi ka pakono a magragsak do arawaw a nakararayaw da. Dyi ka pakono a magpangas do arawaw a nakadidigra da. ");
INSERT INTO ivb_vpl VALUES ("OB1_13","032_1_13","OBA","1","13","13","Dyi ka pakono a somindep do syodad dan tawotawo ko tan masoyosoyot ka do nakalidyalidyat da, kan nangsamsam siras kinabaknang da do araw no didigra da. ");
INSERT INTO ivb_vpl VALUES ("OB1_14","032_1_14","OBA","1","14","14","Dyi ka pakono a nangay do paykokorosan no rarahan tan tiliwen mo saw maglības. Dyi mo pakono sa inparawat dyirad kabōsor da, do araw a kalidyalidyat da.” ");
INSERT INTO ivb_vpl VALUES ("OB1_15","032_1_15","OBA","1","15","15","“Masngen danaw araw a yaken a ĀPO, ki mangokom anchi so tabo nasnasyon. Imom Edom, maparin anchi dyimo akmas pinarin mo. An āngo intoroh mo nawrinchiw rawaten mo. ");
INSERT INTO ivb_vpl VALUES ("OB1_16","032_1_16","OBA","1","16","16","Akmas nakaynom nyo a siraragsak do yanan masantwan a paytokonan ko. Komwan anchiw kapaynom ko dyinyo kan siraw tabo nasnasyon so makpakpad a kopa no kadōsa. At-atkan nyonchi a mandan mawpas kamo a tabo.” ");
INSERT INTO ivb_vpl VALUES ("OB1_17","032_1_17","OBA","1","17","17","“Ki myan sanchiw makalības do Tokon a Sion, kan mayparin anchi a masantwan a logar. Madyira danchi a mirwa no tawotawo ni Jakob iyaw tana a tawid da. ");
INSERT INTO ivb_vpl VALUES ("OB1_18","032_1_18","OBA","1","18","18","Akma sanchiw apoy tawotawo da Jakob kan Jose. Rarayawen da sanchiw tawotawo ni Esaw a akmas karonot no apoy so garami. Abanchi a polos makalāsat a kapotōtan na. Yaken a ĀPO naychirin so nyaya.” ");
INSERT INTO ivb_vpl VALUES ("OB1_19","032_1_19","OBA","1","19","19","“Siraw tawotawo a yapo do abagātan no Joda, ki sakōpen danchiw tokotokon do Edom; Siraw myan saw do paytoytokonan do lāod, ki sakopen danchiw tana da no Pilistya. Sakōpen danchi iyaw tana dan Epraim kan Samarya, As hapen anchi no kapotōtan ni Benhamin iyaw tana no Gilead. ");
INSERT INTO ivb_vpl VALUES ("OB1_20","032_1_20","OBA","1","20","20","Siraw naakawaw a nabahod a soldādo a yapod ammyānanen no Israel, maybidi sanchi kan sakōpen danchiw tana no Penisia a manda do idi a Sarepat do ammyānan a parti na. Siraw naakawaw a yapo do Jerosalem a myan do Sardis, ki sakōpen danchiw idiidi saw do abagātanen a parti no Joda. ");
INSERT INTO ivb_vpl VALUES ("OB1_21","032_1_21","OBA","1","21","21","Siraw mangab-ābakaw a tawo, somonget sanchi do Tokon a Sion, kan itorayan danchiw tokotokon saw no Edom. Si ĀPO anchi a mismo iyaw magāri!”");
INSERT INTO ivb_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Do asa karaw, inpakatoneng ni ĀPO minsahi na di Jonas a pōtot ni Amittay a kāna, ");
INSERT INTO ivb_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Mangay ka do Ninebe a mabīleg a syodad. Ballaāgan mo saw tawotawo daw a īto danaw kasoli no Dyos dyira, ta chapatak dana sigod no Dyos makabābabaya a karahet da.” ");
INSERT INTO ivb_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Imbes a magtongpal si Jonas, ki basbāli a nagrobwat a nangay do Ispanya, ta chakey na dichanan si ĀPO. In-godes naw minosok do idi a Joppe a nakaboyan na so biray a magrobwat a mangay do Ispanya. Do nakatayoka naw a nagbāyad so plīti na, somnakay do birayaw a nachirayay dyira a kominwan do Ispanya tan payayowan na si ĀPO. ");
INSERT INTO ivb_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Ki nanoboy si ĀPO so mayit a salawsaw do tāw, as kan napahtot so taywaras kayit a bagyo. Dawa, makey dana maysiyay birayaw. ");
INSERT INTO ivb_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Taywaraw nakamo dan tripolanti saw, as kan katakatayisa dyira, ki nangngengengey a nagpakpakaāsi so sidong do bokod na a dyos. Sinpangan na, intapwak daw kadwan saw a karga da tan maypatapaw birayaw. Ki si Jonas, ki myan do makatayrahemaw a ansagan birayaw a naynepdep. ");
INSERT INTO ivb_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Dawriw nakaboyan sya no kapitanaw no birayaw. Pinaydabdab na a kāna, “Āngo ta mapakdoh mo paw makaycheh? Kawanem ka! Maybangon ka daw, as kan maydasal ka pad dyos mwaw, ta arā na yaten a chāsi as dyi ta madiman.” ");
INSERT INTO ivb_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Do dāwri, binatabata dan tripolanti saw do katakatayisa dyira a kon da, “Magbibinonōtan ta tan mapatakan ta an sino naynamotan no nyaya didigra?” Dawa, nagbinonōtan sa, ki nabōnot ngaran ni Jonas. ");
INSERT INTO ivb_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Dawa, inyahes da di Jonas a kon da, “Ngay, ibahey mo pa dyamen an sino nakayapwan nya a didigra. Āngo chabalay mo dya? Taga dino ka? Āngo nasyon a nakayapwan mo, as kan āngo tribo mo?” ");
INSERT INTO ivb_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Ki initbay ni Jonas a kāna, “Asa 'kwaw a Hebreo kan managdaydāyaw di ĀPO, iyaw Dyos no hanyit a iyaw namarswa so tāw kan iyaw tanaya.” ");
INSERT INTO ivb_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Inbahey na pa dyira a madama na payayowan si ĀPO. Do dāwri, siraw tripolanti saw, ki sominryam sa do nakamo da, kan binata da dya, “Ay pakawanem! Marahet abawriw nawri a pinarin mo?” ");
INSERT INTO ivb_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Ki ranan da a mangosisa sya, naypaypāngay paw no bagyowaw. Dawa, inyahes darana di Jonas, “Āngo paro parinen namen dyimo tan mangheteng bagyowaya a mangrarayaw dyaten?” ");
INSERT INTO ivb_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Ki initbay ni Jonas a kāna, “Na! Itapwak nyo na yaken ah, tan magtalnaw bagyowaya, ta chapatak ko a yaken naynamotan nyaya laklak-amen ta.” ");
INSERT INTO ivb_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Ki basbāli a in-godes dan tripolantyaw nangawod tan makapaypayraya sa. Ki alit na kinabaelan daba maynamot ta naypaypataywara paw salawsawaw. ");
INSERT INTO ivb_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Dawa, do dāwri, nangngengengey sa nagpakpakaāsi di ĀPO a kon da, “ĀPO, dyi mo pakono yamen a nonolay a madiman an dimanen namen nya tawo a abos gatos. On, dyi mo pakono yamen a pagatosen, ta imom ĀPO makin plano so tabo as iyaw nya bagyo, ki yapod bokod mo a pagayatan.” ");
INSERT INTO ivb_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Do dāwri, kinatkat das Jonas, as nakapagtos da sya do tāw, ki nānyeng a nandinak. ");
INSERT INTO ivb_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Do dāwri, oltimo nakāmo da no tripolanti saw di ĀPO. Sinpangan na, nangidāton sa di ĀPO, as insapata da a magsirbi dana sa dya. ");
INSERT INTO ivb_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Ki nangmandar si ĀPO so rakoh a among a nanghamon di Jonas. Tatdo a karaw kan tatdo a kahep a minyan si Jonas do bodekaw no nya among. ");
INSERT INTO ivb_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Do kayanaw ni Jonas do bodekaw no rakoh a among, naydasal di ĀPO a Dyos a kāna, ");
INSERT INTO ivb_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","“Nangakdakdaw ako dyimom ĀPO do kayan kwa nalidyatan, kan inatbay mo yaken. Yapod makatayrahem a yanan do ngalab no kadiman, ki nagpaarāyat ako, as kan nadngey mo yaken. ");
INSERT INTO ivb_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Inpaitapwak mo yaken do hobok no kararahman a tāw. Siraw rarakoh a allon mo kan āyos mo, ki pinaned da yaken do kensad no tāw. ");
INSERT INTO ivb_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Iniktokto ko a pinasyay mo na yaken do salapen mo. Aran komwan, mirwa akonchi a maboyaw masantwan a Timplo mo. ");
INSERT INTO ivb_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Tinonep yaken no tāw kan namonyitan ako no ranom. Nachidibedibed tametamek no tāw do oho ko. ");
INSERT INTO ivb_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Minned ako a mandad kensad dan tokotokon, kan akmay nabahod ako do tanaya a nāw ko daw a abos pandan. Ki iyaw nyaya nakaned ko, ki inawon mo yaken mo ĀPO a Dyos ko do kadiman ko. ");
INSERT INTO ivb_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Do kapaytiytinawsan danaw no byay ko, nanakem koymo, mo ĀPO, as kan nagpakpakaāsi ako dyimo. Nakarapit nya pakpakaāsi kod masantwan a Timplo mo. ");
INSERT INTO ivb_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","As siraw managdaydāyaw dyirad abwayas sinpaspangan a didyosen, ki sigod a tinadyichokodan daymo kan iyaw kāsi mo dyira. ");
INSERT INTO ivb_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Ki an yaken, magkansyon akonchi so pagdaydāyaw ko dyimo. Manoroh akonchi dyimo so dāton ko, as kan tongpalen konchiw insapata ko dyimo. Ta kaisalakānan, ki yapo di ĀPO.” ");
INSERT INTO ivb_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Katayokan dasal naw, binilin ni ĀPO rakohaw a among, ki inyota nas Jonas do aptan. ");
INSERT INTO ivb_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Do dāwri, pinirwa dana inpakatoneng ni ĀPO minsahi na di Jonas, kan binata na a kāna, ");
INSERT INTO ivb_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Mangay ka do Ninebe a mabīleg a syodad as iballāag mo dyirad tawotawo saw daw minsahi a ipakatoneng ko dyimo.” ");
INSERT INTO ivb_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Nagtongpal si Jonas do inbaheyaw ni ĀPO dya, as kan nangay do Ninebe. Iyaw Ninebe, ki marahawa a syodad, ta tatdo a karaw a takeyen iyaw karahawa naw. ");
INSERT INTO ivb_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Do nakapakarapitaw ni Jonas, naychasaryan a minidibidi do syodadaw as insiknan na inpakatoneng dyira a kāna, “Apat a poho a karaw somiknan sicharaw, ki mararayaw anchiw syodadaya a Ninebe.” ");
INSERT INTO ivb_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Do dāwri, nanganohed saw taga Ninebe saw do Dyos. Nangikeddeng sa a magayonar kan maylaylay so mapayas a mangipaboya so nakapagbabāwi da. Abaw nahabas yapod mabigbigbig a mandad abos saad. ");
INSERT INTO ivb_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Do nakapakarapitaw no dāmag do āryaw no Ninebe, nānyeng a gominchin do trono naw, binahas naw laylay naw, nakapaylaylay nas mapayas, as kan nakapaydisna na do ahbek. ");
INSERT INTO ivb_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Do dāwri, inpaipakatoneng naw bilin na dyirad tawotawo saw daw do Ninebe. Nyaw no naibahey do bilin na a kāna, “No nyaya a bilin, ki yapod āri kan tabo opisyalis na: Abaw tawo mana binyay a koman so aran āngo. Tabo tawotawo, mairaman bāka kan karniro, ki mabaywan a koman mana minom. ");
INSERT INTO ivb_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Tabo tawotawo, ki machita maylaylay so mapayas. Komwan dyirad binyay saw, ki machita ap-apan sa so mapayas. Machita a igodes daw machikakaāsi no tawotawo saw do Dyos, as kan tadyichokodan daw marahet saw a dadakay da kan karanggas da. ");
INSERT INTO ivb_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Ta aranchi a mabāwan makamwamomwaya kapakasoli no Dyos as magbāliw aktokto na as dyi narana yaten a dimanen.” ");
INSERT INTO ivb_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Do nakaboyaw no Dyos so pinarin daw kan an maypāngo nakatadyichokod da siras marahet saya dadakay da, nagbāliw aktokto na kan dinōsa na pa saba akmas inranta naw dyira. ");
INSERT INTO ivb_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Ki insoli ni Jonas nya a naparin kan pinagmamayo na. ");
INSERT INTO ivb_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Dawa, naydasal di ĀPO a kāna, “O ĀPO, binata ko abawri do kayan ko paw do bahay ko a iyaw nyaw chaamak kwaw a parinen mo? Nyaw naynamotan na a nyeng ako a nayyayo a nangay do Ispanya, ta sigod kwaw a chapatak ngamin a myan dyimo parābor, kan māsisyen ka a Dyos. Masosolihen kaba, kan somawasaway adaw mo. Sisasagāna ka a mangibabāwi so kapangdōsa mo dyira. ");
INSERT INTO ivb_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Dawa, mo ĀPO, sichangori, hapen mo naw byay ko, ta maganaganay dana an madiman ako na kan mabyay pa!” ");
INSERT INTO ivb_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Ki inatbay ni ĀPO a kāna, “Aryoriw kalintegan mo a makasoli?” ");
INSERT INTO ivb_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Sinpangan na, komnaro si Jonas do Ninebe, as nangay do dayāenaw no syodad. Namarin so sāpaw na daw, as nakapaydisna na do sirong naw a omnanaya an āngo maparin do syodadaya. ");
INSERT INTO ivb_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Do dāwri, napatobo si ĀPO a Dyos so asa moha a nangabong si Jonas tan dya komriit. Oltimo a nakasoyot ni Jonas do dawri a moha. ");
INSERT INTO ivb_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Ki do kamabekasan naranaw no somaronwaw a araw, insagāna no Dyos iyaw asaw a ohed a mangrarayaw so nawri a moha. Dawa, nahayo kan nadiman. ");
INSERT INTO ivb_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","As do nakadada danaw no arawaw, pinaysasalawsaw no Dyos so oltimo a makohat a yapo do dāya. As iyaw kohat naw no arawaw a makasosoh, ki chinapleng ni Jonas. Chakey naranaw madiman kan kāna, “Maganaganay dana an madiman ako na.” ");
INSERT INTO ivb_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Ki binata no Dyos di Jonas a kāna, “Aryoriw kalintegan mo a makasoli do naparinaya do mohaya?” “On!” initbay ni Jonas. “Manawob nyaya pakasoliyan ko, as abaw makapenpen dyaken a aran nya danaw kadimanan ko.” ");
INSERT INTO ivb_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Ki binata ni ĀPO a kāna, “Chāsi mo nya moha a tomnobo do asa lang a kahep, as nakadiman na do somaronwaw a ahep. Aryoriw hopag mo a nangpatobo mana nangparakoh sya? ");
INSERT INTO ivb_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Rombeng abawri a chāsi ko tawotawo saw do Ninebe? Do dawri a rakoh a syodad, omyan nasorok 120,000 a tawotawo a dya makapaychapidi so kosto kan madi. As kan nawri aba lang, ta myan sa paw reprep a binyay da.”");
INSERT INTO ivb_vpl VALUES ("MC1_1","034_1_1","MIC","1","1","1","Nyaw minsāhi a inpakatoneng ni ĀPO di Mikyas a taga idi a Moreset a maynamot do kaokom no Samarya kan Jerosalem. Naboya naw nyaya do chimpwaw a nakapagāri da Jotam, Ahas, kan Hesekias do Joda. ");
INSERT INTO ivb_vpl VALUES ("MC1_2","034_1_2","MIC","1","2","2","Mangadngey kamo, inyo a tabo a tawotawo. Adngeyen nyo nyaya, inyo a tabo a omyan do tanaya! Si ĀPO a Manakabalin mangsaksi so maibōsor dyinyo. Adngeyen nyo, ta maychirin a yapo do masantwan a timplo na. ");
INSERT INTO ivb_vpl VALUES ("MC1_3","034_1_3","MIC","1","3","3","Chiban nyo! Īto dana si ĀPO a yapo do masantwan a yanan na. Gomchin anchi kan lasagan na sanchiw matotohos saya a tokotokon do tanaya. ");
INSERT INTO ivb_vpl VALUES ("MC1_4","034_1_4","MIC","1","4","4","Siraw katokotokonan saya, ki malonag sa a akmas nadangdangaw a alid do apoy. Maloyo sanchi do payahosongan saya akmay ranom a gomtos do aphas. ");
INSERT INTO ivb_vpl VALUES ("MC1_5","034_1_5","MIC","1","5","5","Tabo nyaya, maparin anchi maynamot ta nagribīldi saw kapotōtan Jakob. On, maparin nya a maynamot ta naygatos saw kapotōtan Israel. Āngo iyaw gatos dan kapotōtan Jakob? Iyabawriw karahet dan tawotawo no Samarya? Dino sintro no pagdaydayāwan so didyosen do Joda? Do Jerosalem abawri? ");
INSERT INTO ivb_vpl VALUES ("MC1_6","034_1_6","MIC","1","6","6","Binata ni ĀPO a kāna, “Dawa, payparinen konchiw Samarya a bonton a yanan a paymohan so kaobāsan. Paychabadebadedehen konchiw bato na saw do payahosonganaw tan magparang saw pondasyon na. ");
INSERT INTO ivb_vpl VALUES ("MC1_7","034_1_7","MIC","1","7","7","Mapsapsa sanchiw didyosen na. Tabo mapapateg saw a nakpeh da do timplo, ki masosohan sanchi so apoy. Rarayawen ko sanchi a tabo bolto da saw. Maynamot ta nakpeh saw nya a yapo do tangdan daw no maglaklāko saw so asi, tangdan dananchi a mirwa no matarek a maglaklāko so asi do matarek a nasyon.” ");
INSERT INTO ivb_vpl VALUES ("MC1_8","034_1_8","MIC","1","8","8","Binata ni Mikyas a kāna, “Maynamot do dyaya, magāsog kan magdongdong-aw ako. Mayam ako a abos tokap kan silalābos. Maydawo ako a akmas bolawaw a chito kan maylilyak ako a akmay gokgok. ");
INSERT INTO ivb_vpl VALUES ("MC1_9","034_1_9","MIC","1","9","9","Mapya pabaw bigar no Samarya, kan nayadis dana do Joda. Nakarapit dana do rowanganaw no idi dan tawotawo ko a aran do Jerosalem a mismo.” ");
INSERT INTO ivb_vpl VALUES ("MC1_10","034_1_10","MIC","1","10","10","Ibahey nyo aba do kabōsor ta saya do idi a Gat iyaw nakaābak ta. Maychahoho kamo abas aran asa katedted. Inyo a tawotawo do idi a Beth-leapra, maydipodiporis kamo do ahbek do ladingit nyo. ");
INSERT INTO ivb_vpl VALUES ("MC1_11","034_1_11","MIC","1","11","11","Inyo a tawotawo do idi a Sapir, maakaw kamonchi a mabahod, kan mayam kamonchi a silalābos a masnek so kayayan. Inyo a tawotawo do Saanan, makahtot kamo paba do idi nyo. Anchan madngey nyo kapagdongdong-aw da do idi a Bet-esel, matonngan nyonchi a abaw kamāngan daw. ");
INSERT INTO ivb_vpl VALUES ("MC1_12","034_1_12","MIC","1","12","12","Siraw tawotawo do idi a Marot, manghahaw sa so kapakalong-aw da ta iyaw didigraya a yapo di ĀPO, ki narapit narana a manda do rowangan no Jerosalem. ");
INSERT INTO ivb_vpl VALUES ("MC1_13","034_1_13","MIC","1","13","13","Inyo a tawotawo do idi a Lakish, isagāna nyo kabalyo nyo do logan nyo a pachigobat. Inyo nangisongsong so Jerosalem a naygatos, ta tinahatahan nyo gatos daw no Israel. ");
INSERT INTO ivb_vpl VALUES ("MC1_14","034_1_14","MIC","1","14","14","Dawa, manoroh kamos sāgot a pamakāda do idi a Moreset-Gat. Iyaw idi a Aksib, ki inallilaw na saw āri saya no Israel. ");
INSERT INTO ivb_vpl VALUES ("MC1_15","034_1_15","MIC","1","15","15","Inyo a tawotawo do idi a Maresah, manoboy si ĀPO so mangsākop so idi nyo. Siraw pangpangōlo no Israel, mangay sanchi a tomayo do aschip no Adollam. ");
INSERT INTO ivb_vpl VALUES ("MC1_16","034_1_16","MIC","1","16","16","Inyo a tawotawo do Joda, chischisan nyo oho nyo do kapagmamayo nyo maynamot dyirad anak nyo saw a chadaw nyo. Chischisan nyo oho nyo a akmas oho naw no kangkang, maynamot ta maakaw saw anak nyo a sibabahod. ");
INSERT INTO ivb_vpl VALUES ("MC2_1","034_2_1","MIC","2","1","1","Kapakāsi da panchi no magplāno so marahet, kan siraw mangipangtaw do pakaychehan da. Apaman a maysesedang, maychakatekateh sa mangipatongpal maynamot ta myan toray da mamarin sya. ");
INSERT INTO ivb_vpl VALUES ("MC2_2","034_2_2","MIC","2","2","2","An myan saw bengkag a chakey da, tod da sodiben. Masaw do bahabahay, ki tod da agāwen. Sikāpan daw tawo tan madyira daw bahay na, kan takawen daw tāwidaw no pamilya na. ");
INSERT INTO ivb_vpl VALUES ("MC2_3","034_2_3","MIC","2","3","3","Dawa, nyaw binata ni ĀPO a kāna, “Iplāno ko kaiyangay ko so didigra dyinyo a akmanchiw pāko a dya mapakaro do lagaw nyo. Arabanchiw kapangas nyowaw a mayam, ta chimponchi no didigra nyo. ");
INSERT INTO ivb_vpl VALUES ("MC2_4","034_2_4","MIC","2","4","4","Do dāwrinchi a chimpo, oyawen danchinyo do kaikansyon da so nya kanta a kapakaōpay dyinyo: ‘Komplito danaw nakararayaw namen! Inhap dana ni ĀPO iyaw tana namen, kan intoroh naranaw bengkag namen dyirad nanglipot dyamen.’” ");
INSERT INTO ivb_vpl VALUES ("MC2_5","034_2_5","MIC","2","5","5","Dawa, apabanchi dyirad tawotawo ni ĀPO mangibinglay so tana daw. ");
INSERT INTO ivb_vpl VALUES ("MC2_6","034_2_6","MIC","2","6","6","“Mangipadto kaba,” bata dan sinan propīta da saw. “Ikasaba mwabaw komwan. Marapit abanchi yaten pakasnesnekan!” ");
INSERT INTO ivb_vpl VALUES ("MC2_7","034_2_7","MIC","2","7","7","Maparinori a ibahey nya, inyo a kapotōtan ni Jakob? Tomnawos danawriw kaānos ni ĀPO a mapatongtong so nawri? Kosto abawri dyirad mamarinaw so maganay? ");
INSERT INTO ivb_vpl VALUES ("MC2_8","034_2_8","MIC","2","8","8","No atbay ni ĀPO, ki kāna, “Rinaot nyo sabawriw tawotawo ko a akma nyo say kabōsor. Pinalang nyo a binahas laylay daw no homabas saw a sitatalna a akma siras mangliklikaw so gobat. ");
INSERT INTO ivb_vpl VALUES ("MC2_9","034_2_9","MIC","2","9","9","Pinaksyat nyo mababakes saw a bālo do bahabahay a chadaw da. Inkaro nyo abos pandan a inpatāwid ko dyirad anak da. ");
INSERT INTO ivb_vpl VALUES ("MC2_10","034_2_10","MIC","2","10","10","Maytēnek kamo, kan komaro kamo na! Do dyabaw paynahahan nyo, ta linaposan nyo na so gatos nyo, kan rinarayaw nyo na golpi. ");
INSERT INTO ivb_vpl VALUES ("MC2_11","034_2_11","MIC","2","11","11","An myan maybayataw kan mangallilaw a makabata sya a kāna, ‘Ipadto ko a moyog anchi dyinyo palek kan arak,’ iyaw nyaw kombini a propita dan nyaya tawotawo!” ");
INSERT INTO ivb_vpl VALUES ("MC2_12","034_2_12","MIC","2","12","12","Nyaw inkari ni ĀPO a kāna, “Sigorādo a akpehen konchi inyo a Jakob. Sigorādo a akpehen ko sanchi a tabo nakalāsat a yapo do Israel. Paychichipehen ko sanchi a akmay karniro do koral, as kan akmay arban do pasto. Iyaw tana da, ki mirwa dananchi a mapno so tawotawo a maariwāwa.” ");
INSERT INTO ivb_vpl VALUES ("MC2_13","034_2_13","MIC","2","13","13","Manma anchi Si ĀPO a manyiwang a mangihtot a yapo do nakaakawan daw. Mawlot sanchi a mohtot do rowangan naw no syodad. Iyaw āri daw, manma anchi a mohtot. Si ĀPO anchi a mismo mangidaōlo do kahtot da. ");
INSERT INTO ivb_vpl VALUES ("MC3_1","034_3_1","MIC","3","1","1","Sinpangan na, binata ko a kon ko, “Mangadngey kamo, inyo a pangpangōlo ni Jakob, inyo a magtotoray no nasyon a Israel! Rebbeng nabawri a chapatak nyo nainkalintegan? ");
INSERT INTO ivb_vpl VALUES ("MC3_2","034_3_2","MIC","3","2","2","Basbāli a ipsok nyowayaw maganay, kan chadaw nyowayaw marahet. Lalāten nyowayaw kodit dan tawotawo ko saya sibibyay, as kalisalisay nyo so asi a myan do tohatohang da. ");
INSERT INTO ivb_vpl VALUES ("MC3_3","034_3_3","MIC","3","3","3","Akma kamo magparti a koman so asi dan tawotawo ko. Hathaten nyowayaw kodit da, kan potopototen nyo payaw tohatohang da. Sagsagen nyo saya akmay karni a mapangay do palyok, kan akmay asi a myan do kardiro. ");
INSERT INTO ivb_vpl VALUES ("MC3_4","034_3_4","MIC","3","4","4","Ītonchiw chimpo a tomanyis kamo a mapasidong di ĀPO, ki atbayen nabanchi inyo. Ikaskāso nabanchiw dasal nyo, ta marahet pinarin nyo.” ");
INSERT INTO ivb_vpl VALUES ("MC3_5","034_3_5","MIC","3","5","5","Iyaw nyaw binata ni ĀPO a kāna, “Siraw propīta saw a mapawaw siras tawotawo ko, an myan mamakan dyira, ikari daw talna dyira. An myan dya makaitoroh dyira so makan, nakasagāna sa machigobat dyira. ");
INSERT INTO ivb_vpl VALUES ("MC3_6","034_3_6","MIC","3","6","6","Dawa, īto danaw mahep a mangabong dyinyo, kan apabanchiw parmata nyo. On, sari danaw myan dyinyo, kan makapangipadto kamo paba. Somdep danaw araw dyirad dyaya propīta, kan no sedang, ki mayparin dana sari dyira. ");
INSERT INTO ivb_vpl VALUES ("MC3_7","034_3_7","MIC","3","7","7","Masnesneskan sanchiw mamadto, ta maparin sabanchiw ipadto da. Maiperreng dabanchiw ropa da, ta abanchiw atbay no Dyos dyira.” ");
INSERT INTO ivb_vpl VALUES ("MC3_8","034_3_8","MIC","3","8","8","Ki an yaken, napno ako so panakabalin do Ispirito ni ĀPO. Napno ako pa so nainkalintegan kan kabīleg a mangibahey so gatos no Israel. ");
INSERT INTO ivb_vpl VALUES ("MC3_9","034_3_9","MIC","3","9","9","Mangadngey kamo, inyo a kapotōtan ni Jakob, inyo a magtotoray do nasyon no Israel a mangipsok so nainkalintegan kan dyidohen nyo tabo a kosto. ");
INSERT INTO ivb_vpl VALUES ("MC3_10","034_3_10","MIC","3","10","10","Pinatnek nyo Sion do maraya a kapangdiman kan Jerosalem do kinakōsit. ");
INSERT INTO ivb_vpl VALUES ("MC3_11","034_3_11","MIC","3","11","11","Inyo a pangpangōlo, mangokom kamo an myan pasoksok. Inyo a papādi, mangnanawo kamo an myan tangdan. Inyo a propīta, mangipadto kamo an myan kwarta. Ki alit na pachinareng nyo di ĀPO a kon nyo, “Ari abawri dyaten si ĀPO? Aryoriw mangay a didigra dyaten? Polos!” ");
INSERT INTO ivb_vpl VALUES ("MC3_12","034_3_12","MIC","3","12","12","Dawa, maynamot dyinyo, maaradonchiw Sion a akmay tālon. Iyaw Jerosalem, mayparin anchi a bonton, as maysepesepet anchiw paytokonanaw a yanan timplo. ");
INSERT INTO ivb_vpl VALUES ("MC4_1","034_4_1","MIC","4","1","1","Do panawdyan san araw, iyaw tokonaw a naytēnekan no Timplo ni ĀPO, ki mayparin anchi a kasisītaan do tabo tokon, as matwatohos anchi kan tabo a paytokonan. Nāw danchi a arayaten āro a tawotawo. ");
INSERT INTO ivb_vpl VALUES ("MC4_2","034_4_2","MIC","4","2","2","Āronchiw nasyon a mangay kan batahen da, “Ngay, yangay ta songten tokonaya ni ĀPO do Timplowaya no Dyos ni Jakob. Inanawo nanchi dyaten daw rarahan na tan makayam tanchi do ayayaman na.” Ta do Sion pakayapwan no linteg. On, iyaw chirin ni ĀPO, ki yapo do Jerosalem. ");
INSERT INTO ivb_vpl VALUES ("MC4_3","034_4_3","MIC","4","3","3","Iyanchiw mangokom do payawan āro a tawotawo, kan mangngeddeng so pagriridyaran dan mabibīleg saya nasyon a aran do mabawa. Chipohen darananchiw ispāda daw a parinen da lokoy no arādo, kan parinen darananchi a sasadyit chibot da saw. Maggogobat pa sabanchiw nasnasyon, mana machinanawo sa pabanchi a machigobat. ");
INSERT INTO ivb_vpl VALUES ("MC4_4","034_4_4","MIC","4","4","4","Kāda asa, maybibyay dananchi a matalna do mismo a sirong no kaobāsan kan igos na. Apabanchiw mangamomo sira, ta inkari ni ĀPO a Manakabalin do Tābo nyaya. ");
INSERT INTO ivb_vpl VALUES ("MC4_5","034_4_5","MIC","4","5","5","Aran mononot saw nasyon saya do ngaran dyos da sa, yamen, ki mononot kami do ngaran ĀPO a Dyos abo so pachipandan. ");
INSERT INTO ivb_vpl VALUES ("MC4_6","034_4_6","MIC","4","6","6","“Do dāwri a araw”, binata ni ĀPO a kāna, “Akpehen ko saw tawotawowaw a piday, siraw naakaw saw, kan siraw inpadōsa ko. ");
INSERT INTO ivb_vpl VALUES ("MC4_7","034_4_7","MIC","4","7","7","Paybadiwen ko sanchiw piday saw a makalāsat, kan siraw naakaw saw, ki payparinen ko sa mabīleg a nasyon. Yaken a ĀPO, mangitoray anchi dyira do Tokon a Sion a mangrogi do dāwri a araw kan abos pandan.” ");
INSERT INTO ivb_vpl VALUES ("MC4_8","034_4_8","MIC","4","8","8","As imom Jerosalem, akma kay pagwanawanan siras arban, kan akma kay kōta no tawotawo no Dyos do Sion. Iyaw sīgod a kapagtoray mo, ki mapaybidinchi. On, kapagāri, ki mirwa dananchi dyimom Jerosalem. ");
INSERT INTO ivb_vpl VALUES ("MC4_9","034_4_9","MIC","4","9","9","Ki sichangori, āngo ta makalyak ka tomanyis? Arabawriw āri mo? Nadiman dana sawriw masisiribaw a mamagbaga mo, ta dawa, kinemkeman naymo no kaynyin a akmas magpasikalaw? ");
INSERT INTO ivb_vpl VALUES ("MC4_10","034_4_10","MIC","4","10","10","Maypiypisipis kamo a magāsog, inyo a tawotawo no Jerosalem a akmay maymanganak, ta machita nyo naw komaro do syodadaya, kan omyan do bengkag. Maakaw kamonchi a mabahod a maiyangay do Babilonya, ki isalākan nanchi inyo ni ĀPO do dawri a yapo do tanoro dan kabōsor nyo. ");
INSERT INTO ivb_vpl VALUES ("MC4_11","034_4_11","MIC","4","11","11","Changori, āro a nasyon nakpeh a machikontra dyimo. Batahen da a kon da, “Machita payboboyas Jerosalem! Boyaen taw kararayaw no Sion!” ");
INSERT INTO ivb_vpl VALUES ("MC4_12","034_4_12","MIC","4","12","12","Ki chapatak daba no nya sa nasyon iskala ni ĀPO. Maawātan dabaw plāno na. Chinpeh na sa a akmay nagāpas a trigo a maisagāna do kairek da. ");
INSERT INTO ivb_vpl VALUES ("MC4_13","034_4_13","MIC","4","13","13","Binata ni ĀPO, “Inyo a tawotawo no Jerosalem, mangay kamo na manyirek so kabōsor nyo! Payparinen ko a pasek olong nyo. Torohan koynyo so tombaga a koko nyo tan pitapitahen nyo saw āro saya nasyon.” Itoroh nyonchi di ĀPO sinamsam da saw, iyaw kinabaknang daw di Āpo do intīro a lōbong. ");
INSERT INTO ivb_vpl VALUES ("MC5_1","034_5_1","MIC","5","1","1","Tawotawo no Jerosalem, isagāna nyo bōyot nyo saw, ta nadibon ta na no kabōsor. Baōtan danchi so baston iyaw mangitoray no Israel do pisnyi na tan asnesneken da. ");
INSERT INTO ivb_vpl VALUES ("MC5_2","034_5_2","MIC","5","2","2","Binata ni ĀPO a kāna, “Imo a Betlehem Eprata, aran dēkey ka dyirad partīdos no Joda, ki yapo dyimo, mohtot anchiw asa a mangitoray so Israel a no kapoonan na yapo do kaychōwa pa.” ");
INSERT INTO ivb_vpl VALUES ("MC5_3","034_5_3","MIC","5","3","3","Dawa, iparawat nanchi ni ĀPO tawotawo na dyirad kabōsor da a mandan mayanak no mabakesaw iyaw anak naw. Sinpangan na, maybidi sanchiw kakabagyan naw a naakaw, kan machirapa dana sanchi dyirad tawotawo no Israel. ");
INSERT INTO ivb_vpl VALUES ("MC5_4","034_5_4","MIC","5","4","4","Anchan mangay, maytēnek a mangidaōlo dyirad tawotawo na a maynamot do bīleg a yapo di ĀPO kan do dayag no ngaran ni ĀPO a Dyos na. Siraw tawotawo, ki maybibyay dana sanchi a matalna, ta dawrinchi, iyaw dayag na, ki romapit do intīro a lōbong. ");
INSERT INTO ivb_vpl VALUES ("MC5_5","034_5_5","MIC","5","5","5","Iya dananchiw pakayapwan kapya da. Anchan raoten dan taga Asirya iyaw nasyon taya, as tomokap sa do tana taya, mapatēnek ta so papito a mangidaōlo kontra dyira mana wawaho a pangpangōlo no tawotawo. ");
INSERT INTO ivb_vpl VALUES ("MC5_6","034_5_6","MIC","5","6","6","Idaōlwan darananchiw Asirya do tarem no ispāda, kan asdepen daw rowanganaw no tana ni Nimrod. Iyaw āri taya, ki isalākan nanchi yaten dyirad Asirya anchan daropen da yaten kan padasen daw lomasag do yanan taya. ");
INSERT INTO ivb_vpl VALUES ("MC5_7","034_5_7","MIC","5","7","7","Siraw nakalāsat saw do kapotōtan ni Jakob, ki maychawpit sanchi dyirad āro a nasnasyon. Akma sanchiw apon a yapo di ĀPO, kan akma say chimoy a mangsibog so katamtamkan a dya manghahaw do tawo mana mangnanaya so tawotawo. ");
INSERT INTO ivb_vpl VALUES ("MC5_8","034_5_8","MIC","5","8","8","As siraw nakalāsat saw a kapotōtan ni Jakob, ki myan sanchi do payapayawan dan nasnasyon do naychawpitan daw. Akma sanchiw lion do yanan dan animal saw do kahasan, kan akmay bomaro a lion do yanan dan arban a karniro a manggammat an homabas kan piripiriten naw mahap naw, kan aba polos makaisalākan sya. ");
INSERT INTO ivb_vpl VALUES ("MC5_9","034_5_9","MIC","5","9","9","Abāken anchi no Israel kabōsor na, kan tomawos sanchi a tabo mangipsok sya. ");
INSERT INTO ivb_vpl VALUES ("MC5_10","034_5_10","MIC","5","10","10","“Do dāwri a araw,” binata ni ĀPO a kāna, “Dimanen ko sanchiw kabalyo nyowaw, kan rarayawen konchi a tabo logan nyowaw a pachigobat. ");
INSERT INTO ivb_vpl VALUES ("MC5_11","034_5_11","MIC","5","11","11","Rarayawen ko sanchiw syodad do tana nyo, kan lasalasahen ko sanchiw kōta nyo. ");
INSERT INTO ivb_vpl VALUES ("MC5_12","034_5_12","MIC","5","12","12","Akteben ko nanchiw kapanolib nyo kan apabanchiw mamadto nyo. ");
INSERT INTO ivb_vpl VALUES ("MC5_13","034_5_13","MIC","5","13","13","Rarayawen ko sanchiw didyosen nyo saw, kan siraw bata nyo saw a masantwan a parey a bato a pagdaydayāwan nyo tan dyi kamonchi a makapagdaydāyaw a polos do pinarin no bōkod nyo a tanoro. ");
INSERT INTO ivb_vpl VALUES ("MC5_14","034_5_14","MIC","5","14","14","Bagoten konchi dyinyo parey saw a didyosen ni Aserah, kan rarayawen konchiw syodad nyo. ");
INSERT INTO ivb_vpl VALUES ("MC5_15","034_5_15","MIC","5","15","15","Do taywara kasoli ko, bahsen ko sanchiw nasyon a dya magtongpal dyaken.” ");
INSERT INTO ivb_vpl VALUES ("MC6_1","034_6_1","MIC","6","1","1","Adngeyen nyo batahen ni ĀPO a maikontra do Israel! “Maytēnek ka kan irasonan mo darom kwaya tan saksyan dan tokotokon kan siraw paytoytokonanaya tan adngeyen da an āngo ibahey mo.” ");
INSERT INTO ivb_vpl VALUES ("MC6_2","034_6_2","MIC","6","2","2","Inyo a tokotokon, adngeyen nyo daromaya ni ĀPO! Aran inyo a abos pandan a pondasyon no lōbongaya, mangadngey kamo, ta myan darom ni ĀPO dyirad tawotawo na. On, kaswan dana ni ĀPO Israel. ");
INSERT INTO ivb_vpl VALUES ("MC6_3","034_6_3","MIC","6","3","3","Binata ni ĀPO a kāna, “Inyo a tawotawo ko, āngo pinarin ko dyinyo? Maypāngo a nayparin ako a rahmet nyo? Atbayen nyo yaken! ");
INSERT INTO ivb_vpl VALUES ("MC6_4","034_6_4","MIC","6","4","4","Inihtot koynyo a yapo do Egipto, kan insalākan koynyo do nakatagabwan nyo. Tinoboy ko sa Moyses, Aaron kan Miriam a nangipangōlo dyinyo. ");
INSERT INTO ivb_vpl VALUES ("MC6_5","034_6_5","MIC","6","5","5","Inyo a tawotawo ko, nakmen nyo pa an maypāngo pangta a nakaabay dyinyo ni Balak a āri no Moab, kan an maypāngo nakabindisyon dyinyo ni Balaam a pōtot ni Beor. Nakmen nyo paw nakapanakey nyowaw a yapo do Sittim a komwan do Gilgal tan matonngan nyo an āngo saw malinteg a kaparin ni ĀPO.” ");
INSERT INTO ivb_vpl VALUES ("MC6_6","034_6_6","MIC","6","6","6","“Āngo iyangay ko di ĀPO anchan maydogod ako do salapen matan-ok a Dyos? Mapanaybi akori so masosohan a dāton do salapen na a apagtawen a orbon bāka? ");
INSERT INTO ivb_vpl VALUES ("MC6_7","034_6_7","MIC","6","7","7","Rawaten paro ni ĀPO an manoroh ako so rinibo a mahahakay a karniro, mana asa poho a ribo a oksong no moyog a lana no olibo? Idāton kori iyaw matoneng a anak ko a pagbāyad so kasokir ko, iya a asi no inawan ko para do gatos no pahad ko? ");
INSERT INTO ivb_vpl VALUES ("MC6_8","034_6_8","MIC","6","8","8","Namna, inbahey narana dyimo, imo a tawo, an āngo maganay, kan āngo chakey ni ĀPO dyimo. Sira abawriw nya: kapamarin so nainkalintegan, kadaw so kāsi, kan maybibyay a sipapakombaba do salapen no Dyos?” ");
INSERT INTO ivb_vpl VALUES ("MC6_9","034_6_9","MIC","6","9","9","“Adngeyen nyo! Manawag si ĀPO so tawotawo do syodadaya! No masīrib, myan so kāmo do ngaran ĀPO. Annadan nyo, ta īto dana iyaw naikeddeng a dōsa nyo. ");
INSERT INTO ivb_vpl VALUES ("MC6_10","034_6_10","MIC","6","10","10","Mawayakan ko paro tawo saw a maywam do marahet a napno so kinabaknang do bahabahay da a yapo do kosit da? Nonolay ko paro saw mangosaraw so dya kosto a pagkilwan a taywara ipsok ko? ");
INSERT INTO ivb_vpl VALUES ("MC6_11","034_6_11","MIC","6","11","11","Pakawanen ko paro tawo a kōrang so kapagtimbang kan kosit so pagkilwan? ");
INSERT INTO ivb_vpl VALUES ("MC6_12","034_6_12","MIC","6","12","12","Siraw babaknang mwaya, ki taywara sa so karanggas. Siraw omyanaya dyimo, ki dān daw mabayataw kan sabong no rida da. ");
INSERT INTO ivb_vpl VALUES ("MC6_13","034_6_13","MIC","6","13","13","Dawa, isagāna ko kadōsa mo, kan rohnwan koynyo a rarayawen a maynamot do gatogatos mo. ");
INSERT INTO ivb_vpl VALUES ("MC6_14","034_6_14","MIC","6","14","14","Koman kanchi, ki mabsoy kaba. Nāw monchi a saraāwen. Mangapya kanchi, ki abaw makpeh mo, ta tabon chinpeh mo, rarayawen konchi do gobat. ");
INSERT INTO ivb_vpl VALUES ("MC6_15","034_6_15","MIC","6","15","15","Maymoha kanchi, ki imo abanchiw magāpit. Mamis kanchis asi no olibo, ki imo abanchiw mangosar so lana na. Mamitos kanchi so ōbas, ki imo abanchiw minom so palek na. ");
INSERT INTO ivb_vpl VALUES ("MC6_16","034_6_16","MIC","6","16","16","Maparin saw nyaya, ta tinongpal mo saw linteg ni Āri Omri kan tabo kaparin saw no kamanganakan Āri Ahab, kan innonotan mo dadakay da. Dawa, iparawat konchimo do kararayawan, kan siraw omyanaya dyimo, oyawen da sanchi, kan iroromen danchimo no nasnasyon.” ");
INSERT INTO ivb_vpl VALUES ("MC7_1","034_7_1","MIC","7","1","1","Angwa kapakasyāsi ko! Akma akos tawowaw a mangdīdid do namoysan do rayon, kan akma akos mangdīdidaw do kaobāsan. Abaw mawngawngay a ōbas a makan, mana manoma a maynoy a asin igos a oyod kos pakakdekden. ");
INSERT INTO ivb_vpl VALUES ("MC7_2","034_7_2","MIC","7","2","2","Nabo dana saw mapodno do tanaya. Apabaw aran asa malinteg a tawo a natokos. Tabo tawo, ki mangsaneb a mangdiman. Kāda asa, otapan naw aran kakteh na. ");
INSERT INTO ivb_vpl VALUES ("MC7_3","034_7_3","MIC","7","3","3","Masisiglat tanoro da a mamarin so marahet. Siraw opisyal kan siraw hwis, mangdaw sa so pasoksok. Siraw mabibīlegaw, ipapāti daw chakey daw, kan kasan daw magipangta so marahet. ");
INSERT INTO ivb_vpl VALUES ("MC7_4","034_7_4","MIC","7","4","4","Iyaw kagaganayanaw dyira, ki akmay mohamoha a manolok. Iyaw kalilinteganaw dyira, ki akmay kemekemmeng. Īto danaw araw a kadōsa no Dyos 'mas inpadto daw no magbanbantay saw a propita. Changori, maychaychawaw dana sa tabo. ");
INSERT INTO ivb_vpl VALUES ("MC7_5","034_7_5","MIC","7","5","5","Magtalek kaba do karoba mo, mana masaray kaba do sīt mo. Aran si baket mo a kaoknod mo, annadan mo ichirin mo. ");
INSERT INTO ivb_vpl VALUES ("MC7_6","034_7_6","MIC","7","6","6","Anyiben paba no anak a mahakay āmang na. Kontraen dana no anak a mabakes ānang na. As pachidimanan no manōgang a mabakes iyaw katogāngan na mabakes. Siraw kabōsor no asa tawo, ki sira met lang mimbro no mismo na pamilya. ");
INSERT INTO ivb_vpl VALUES ("MC7_7","034_7_7","MIC","7","7","7","Ki an yaken, ahahayen ko si ĀPO. Nanayahen ko Dyos a mangisalākan ko. Adngeyen nanchi yaken Dyos ko. ");
INSERT INTO ivb_vpl VALUES ("MC7_8","034_7_8","MIC","7","8","8","Chamimyeng nyo aba yaken, inyo a kabōsor ko! Aran nalba ako, mirwa konchi a maybangon. Aran myan ako a maydisna do kasaryan, si Āpo anchiw soho ko. ");
INSERT INTO ivb_vpl VALUES ("MC7_9","034_7_9","MIC","7","9","9","Ibtoran ko soli ni ĀPO, ta naygatos ako dya manda do kapaysonong na so kāso ko, kan kaitoroh na so kalintegan ko. Ihtot nanchi yaken do sedang, kan maboya konchiw kinalinteg na. ");
INSERT INTO ivb_vpl VALUES ("MC7_10","034_7_10","MIC","7","10","10","Do dāwri, maboya danchi no kabōsor ko a siraw mangoyawaw dyaken a nangibahey sya a kon da, “Dino yanan ĀPO a Dyos nyo?” Ki sichangori, panyibaya danchiw kasnek da. Maboya konchiw kasday da no kabōsor ko a matokatokapan a akmay hota do kalkalsāda. ");
INSERT INTO ivb_vpl VALUES ("MC7_11","034_7_11","MIC","7","11","11","Tawotawo no Jerosalem, īto danaw araw a kapangbangon nyo a mirwa so ahad no syodad nyo. Do dāwrinchi a araw, mayparahawa anchiw sākop nyo. ");
INSERT INTO ivb_vpl VALUES ("MC7_12","034_7_12","MIC","7","12","12","Do dāwri a araw, mangay sanchiw tawotawo dyinyo yapo do Asirya manda do Egipto, yapo do Egipto manda do Oksong a Oprates, kan yapo do tabo loglogar mangrogi do tāw a manda do totok no tokon. ");
INSERT INTO ivb_vpl VALUES ("MC7_13","034_7_13","MIC","7","13","13","Ki mayparin anchi a let-ang iyaw kadwan a tana maynamot do karahet dan tawotawo a omyan daw. ");
INSERT INTO ivb_vpl VALUES ("MC7_14","034_7_14","MIC","7","14","14","Ipastoran mo sa mo ĀPO akmas mangonongaw a pastor siras arban a dyira mo. Aran maychatanyi sa do kahasan do hobok no Tokon Karmel, ki pagarāben mo sa do magla a pagarāban do Basan kan do Gilead a akma do kaychowa. ");
INSERT INTO ivb_vpl VALUES ("MC7_15","034_7_15","MIC","7","15","15","Batahen ni ĀPO, “Akmas araw saw a nakahtot nyo do tana Egipto, ipaboya konchi dyinyo makaskasdāaw saw a kaparin ko,” kāna no Dyos. ");
INSERT INTO ivb_vpl VALUES ("MC7_16","034_7_16","MIC","7","16","16","Maboya danchi no nasnasyon nya saya, kan tod anchi a makasnesnek bīleg da. Do kaōpay da, bengbengen danchi so tanoro daw dangoy da, kan akma sanchiw bitor. ");
INSERT INTO ivb_vpl VALUES ("MC7_17","034_7_17","MIC","7","17","17","Magōyas sanchi do kahbekan a akmay boday, kan akma sa so komayakayabaw do tana. Maychahohtot sanchi do tinaywan daw a maychamirpir, kan iditen da a chananawa si ĀPO a Dyos. ");
INSERT INTO ivb_vpl VALUES ("MC7_18","034_7_18","MIC","7","18","18","Sino Dyos a akma dyimo a mamakawan so nakagatos, kan mangwayak so karahet dan tawotawo mo a nakalāsat? Nāw mo saba isoli a magnanayon, basbāli a chinasoyot mo a ipaboyaw kāsi mo. ");
INSERT INTO ivb_vpl VALUES ("MC7_19","034_7_19","MIC","7","19","19","Ipadidiw monchi dyamen a mirwaw kāsi mo, kan tokatokapan monchiw gatogatos namen, kan itapwak monchi do kensad no tāw. ");
INSERT INTO ivb_vpl VALUES ("MC7_20","034_7_20","MIC","7","20","20","Ipaboya monchiw kapodno mo di Jakob, kan dya mabdibdis a adaw mo di Abraham, a akmas insapata mwaw dyirad inyaynyapwan namen saw yapo do kaychowa pa.");
INSERT INTO ivb_vpl VALUES ("HG1_1","038_1_1","HAG","1","1","1","Do chadadwa naw a kakawan a nakapagtoray ni Āri Daryo do Persya, do dāmwaw a araw do chanem naw a bohan, inpakatoneng ni ĀPO minsahi naw di propīta Haggeo. Iyaw nya minsahi, ki para do gobirnadoraw do Joda a si Serobbabel a pōtot ni Salatiel. Masaw di Joswe a pōtot ni Jehosadak a iyaw katotohosanaw a pādi. ");
INSERT INTO ivb_vpl VALUES ("HG1_2","038_1_2","HAG","1","2","2","Nyaw batahen ni ĀPO a Manakabalin do Tābo di Haggeo a kāna, “Batahen daw no nya tawotawo a ‘Ari na pad chimpo iyaw mirwa a kapatnek so Timplo.’” ");
INSERT INTO ivb_vpl VALUES ("HG1_3","038_1_3","HAG","1","3","3","Sinpangan na, inpakatoneng ni ĀPO minsahi naw di propīta Haggeo para dyirad tawotawo saw a kāna, ");
INSERT INTO ivb_vpl VALUES ("HG1_4","038_1_4","HAG","1","4","4","“Inyo a tawotawo ko, āngo ta omyan kamo do magaganay a bahabahay nyo, ki tori dana makabakabaw Timplo kwaya?” ");
INSERT INTO ivb_vpl VALUES ("HG1_5","038_1_5","HAG","1","5","5","Inpakatoneng pa ni ĀPO a Manakabalin do Tābo a kāna, “Kapyahen nyo a iktokto pariparinen nyowaya. ");
INSERT INTO ivb_vpl VALUES ("HG1_6","038_1_6","HAG","1","6","6","Kināro nyo naymohamoha, ki dēkey naāpit nyo. Koman kamo, ki chabsoy nyo aba. Minom kamo, ki makaywaw kamwaba. Maylaylay kamo, ki makakekeh aba dyinyo. Naytarabāko kamo a myan so tangdan, ki tod nyo a kinapya do botbot a pitāka nyo.” ");
INSERT INTO ivb_vpl VALUES ("HG1_7","038_1_7","HAG","1","7","7","Nyaw inpakatoneng ni ĀPO a Manakabalin do Tābo a kāna, “Kapyahen nyo a iktokto pariparinen nyowaya. ");
INSERT INTO ivb_vpl VALUES ("HG1_8","038_1_8","HAG","1","8","8","Somonget kamo do paytoytokonan saya, as manongeh kamo so kayo a iyosok nyo, kan patneken nyo Timplo kwaya a mirwa tan mahwahok ako kan maidāyaw ako,” bintata ni ĀPO. Tinongtong a inpakatoneng ni Āpo a kāna, ");
INSERT INTO ivb_vpl VALUES ("HG1_9","038_1_9","HAG","1","9","9","“Āro hinahaw nyo a āpit nyo, ki chiban nyo, nayparin a dēkey. As do kaisabat nyowaw sya, pinasayaw ko pa. Āngo ta pinarin ko nya? Maynamot ta nakabakaba danaw Timplo ko, as katakatayisaya dyinyo mangigodegodes so bokod na bahay. ");
INSERT INTO ivb_vpl VALUES ("HG1_10","038_1_10","HAG","1","10","10","As dawa, maynamot dyinyo, pinenpen no hanyit iyaw apon, as kan pinenpen no tana iyaw tomobo. ");
INSERT INTO ivb_vpl VALUES ("HG1_11","038_1_11","HAG","1","11","11","Pinagtīkag ko tabo tana a paymohan nyo kan nabkohan saw paytoytokonan, taltālon, kaobasan, kan kaolibwan. Maynamot do tīkag, naglak-am a tabo mohamoha, tawotawo, binyay kan tabo nayhohopagan nyo a inmoha.” ");
INSERT INTO ivb_vpl VALUES ("HG1_12","038_1_12","HAG","1","12","12","Do dāwri, si Serobbabel a pōtot ni Salatiel, si Joswe a pōtot ni Jehosadak a katotohosan a pādi, kan tabo tawotawo saw a nakapaybidi yapo do nakaakaw daw do Babilonya, ki tinongpal daw bilinaw ni ĀPO a Dyos da. On, do nakadngey daw so minsahyaw ni propīta Haggeo a tobotoboyen ni ĀPO a Dyos da, chinamo da si ĀPO kan tinongpal da. ");
INSERT INTO ivb_vpl VALUES ("HG1_13","038_1_13","HAG","1","13","13","Sinpangan na, binata ni Haggeo iyaw inpakatoneng ni ĀPO dyirad tawotawowaw a kāna, “‘Yaken, ki myan ako dyinyo,’ kāna ni ĀPO.” ");
INSERT INTO ivb_vpl VALUES ("HG1_14","038_1_14","HAG","1","14","14","Sinalid ni ĀPO gobirnadoraw do Joda a si Serobbabel a pōtot ni Salatiel. Masaw di Joswe a pōtot ni Jehosadak a katotohosan a pādi. Masaw sinalid na a tabo tawotawo saw a nakapaybidi yapo do nakaakaw daw do Babilonya. Nangay sa kan inrogi daw maytarabāko do Timplo naw ni ĀPO a Manakabalin a Dyos da, ");
INSERT INTO ivb_vpl VALUES ("HG1_15","038_1_15","HAG","1","15","15","do chadadwa naw a poho kan apat a karaw, do chanem naw a kabohan, do chadadwaw a katawen no nakapagtoray ni Āri Daryo. ");
INSERT INTO ivb_vpl VALUES ("HG2_1","038_2_1","HAG","2","1","1","Do chadadwaw a kakawan, do chadadwa poho naw kan asa karaw, do chapapito naw a bohan a nakapagtoray ni Āri Daryo, nya danaw inpakatoneng ni ĀPO di propīta Haggeo a kāna, ");
INSERT INTO ivb_vpl VALUES ("HG2_2","038_2_2","HAG","2","2","2","“Maychirin ka di Serobbabel a pōtot ni Salatiel a gobirnador do Joda kan di Joswe a pōtot ni Jehosadak a katotohosan a pādi kan dyirad tawotawo saw a nakapaybidi yapo do nakaakaw daw do Babilonya. Yahes mo dyira a kon mo, ");
INSERT INTO ivb_vpl VALUES ("HG2_3","038_2_3","HAG","2","3","3","‘Aryori dyinyo makanakem pa so nya Timplo do sigodaw a kapintas na? Maypāngo kaboyan nyo na sya changori? Akma abawriw abos sinpaspangan? ");
INSERT INTO ivb_vpl VALUES ("HG2_4","038_2_4","HAG","2","4","4","Ki sichangori, payiten mo kapangtokto mo, imom Serobbabel. Masaw payiten mo kapangtokto mo, imom Joswe a pōtot ni Jehosadak a katotohosan a pādi, as aran inyo tabo a tawotawo a nabidin do tana. Maytarabāko kamo do Timplo, ta myan ako dyinyo,’ binata ni ĀPO a Manakabalin. ");
INSERT INTO ivb_vpl VALUES ("HG2_5","038_2_5","HAG","2","5","5","Tinongtong na a kāna, ‘Akmas nakapachitōlag kwaw dyinyo a dyi koynyo a nonolay do nakahbot nyowaw a yapo do Egipto, nāw ko pa dyinyo. Dawa, mamo kamo aba.’” ");
INSERT INTO ivb_vpl VALUES ("HG2_6","038_2_6","HAG","2","6","6","“Nyaw inpakatoneng ni ĀPO a Manakabalin do Tābo a kāna, ‘Mahay pabaw kagoyogoyon ko so hanyit, lōbong, tana, kan tāw. ");
INSERT INTO ivb_vpl VALUES ("HG2_7","038_2_7","HAG","2","7","7","Gon-gonen konchi a tabo nasnasyon, kan siraw mapapateg saw a warawara dan nasnasyon, ki maiyangay sanchi do dya a Timplo, as kan apnohen konchiw nya Timplo so kinabaknang. ");
INSERT INTO ivb_vpl VALUES ("HG2_8","038_2_8","HAG","2","8","8","Dyaken a tabo pirak kan balitok do dya lōbong. ");
INSERT INTO ivb_vpl VALUES ("HG2_9","038_2_9","HAG","2","9","9","Madaydayag anchiw bayowaya a Timplo kan adanaw. As do dya yanan, itoroh konchi dyirad tawotawo ko kaydamnayan no kapangtokto da.’” ");
INSERT INTO ivb_vpl VALUES ("HG2_10","038_2_10","HAG","2","10","10","Do chadadwa poho kan apat a karaw, do chasasyam naw a kabohan, do chadadwaw a kakawan no nakapagtoray ni Daryo, inpakatoneng dana ni ĀPO minsahi naw di propīta Haggeo a kāna, ");
INSERT INTO ivb_vpl VALUES ("HG2_11","038_2_11","HAG","2","11","11","“Nyaw batahen ni ĀPO a Manakabalin do Tābo a kāna, ‘Iyahes mo dyirad papādi saw an āngo batahen linteg maynamot do nya kapanahes: ");
INSERT INTO ivb_vpl VALUES ("HG2_12","038_2_12","HAG","2","12","12","An kaspangarīgan, mangibolsaw asa tawo so naidāton a karni do mayidaw a laylay na. An mapadnet laylay naw do tināpay mana nahoto a mākan mana palek mana lana mana aran āngo a ibodek, mayparinori a masantwan nakapadnetan naya?’” Ki tominbay saw papādyaw di Haggeo a kon da, “Engga ah.” ");
INSERT INTO ivb_vpl VALUES ("HG2_13","038_2_13","HAG","2","13","13","Inyahes dana ni Haggeo a kāna, “Na, an kaspangarīgan, myan asa tawo a naibidang a nalaposan a maynamot do nakapakasalid nas bangkay. An manalid so aran āngo dyirad nya saya mākan, malaposan pa sawriw kanen saya?” “Naon ah,” tinbay dan papādyaw. ");
INSERT INTO ivb_vpl VALUES ("HG2_14","038_2_14","HAG","2","14","14","Do dāwri, binata ni Haggeo a kāna, “Ipakatoneng ni ĀPO a kāna, ‘Akma syay maparin do tawotawo do dyaya nasyon do salapen ko. Tabo imoha da kan idāton da, naibidang a malapos.’” ");
INSERT INTO ivb_vpl VALUES ("HG2_15","038_2_15","HAG","2","15","15","“Inpakatoneng ni ĀPO a kāna, ‘Karahmen nyo a iktokto naparinaw dyinyo do sakbayaw no nakairogi nyo so kapirwa nyo a mapatnek so Timplowaya. ");
INSERT INTO ivb_vpl VALUES ("HG2_16","038_2_16","HAG","2","16","16","Do nakangay nyowaw do nakawpwanaw no trigo, kan hahawen nyo a makahap kamo so dadwa poho a kasalop, ki asa poho lang a kasalop nahap nyo. Do nakangay nyowaw do pangapyan nyowaw so palek tan makatabo kamo so dadima poho a kagalon, dadwa poho lang natabo nyo. ");
INSERT INTO ivb_vpl VALUES ("HG2_17","038_2_17","HAG","2","17","17","Rinarayaw ko tabo pinādas nyo a inmoha so domalangdang a salawsaw a yapod dāya kan naychahesday a yilo, ki alit na dyi kamo a naybidi dyaken. ");
INSERT INTO ivb_vpl VALUES ("HG2_18","038_2_18","HAG","2","18","18","Makayapo sichangori a araw, do chadadwa naya poho kan apat a araw, do chasasyam naya kabohan, karahmen nyo a iktokto nakapatnek danaya no pondasyonaya no Timplo. ");
INSERT INTO ivb_vpl VALUES ("HG2_19","038_2_19","HAG","2","19","19","Apabaw natokos a binyi do agāmang. Ari pad omsiw obas, igos, granada, kan olibo. Ki aran komwan, makayapo sichangori, bindisyonan ko mohamoha nyo.’” ");
INSERT INTO ivb_vpl VALUES ("HG2_20","038_2_20","HAG","2","20","20","Do dāwri a araw, do chadadwa naw a poho kan apat a karaw no bohan, inpakatoneng ni ĀPO no somarono a minsahi na di Haggeo a kāna, ");
INSERT INTO ivb_vpl VALUES ("HG2_21","038_2_21","HAG","2","21","21","“Nyaw inpakatoneng ni Āpo a kāna, ‘Ibahey mo di Serobbabel a gobirnador do Joda a goyogoyonen konchiw hanyit kan tana. ");
INSERT INTO ivb_vpl VALUES ("HG2_22","038_2_22","HAG","2","22","22","Abohen ko sanchiw pagāryan, kan akteben konchiw panakabalin da. Albahen ko sanchiw karison daw a goyoden kabalyo a pachigobat kontodo nakasakay saw. On, malba sanchiw kabalyo saw kan siraw nakasakayaw, as kan maysintatabtab sanchi pakairamānan kabalyo saw no katakatayisa.’ ");
INSERT INTO ivb_vpl VALUES ("HG2_23","038_2_23","HAG","2","23","23","“Do dāwri a araw, inpakatoneng ni ĀPO a Manakabalin do Tābo a kāna, ‘Ahapen konchi imo mo Serobbabel a adipen ko, imo a pōtot ni Salatiel, kan tongdohen koymo a magtoray do ngaran ko, ta pinidi ko imo’ Nyaw batahen ni ĀPO a Manakabalin do Tābo.”");
INSERT INTO ivb_vpl VALUES ("ZC1_1","039_1_1","ZEC","1","1","1","Do chawawaho naw a kabohan, do chadadwaw a kakawan no kapagtoray ni Daryo a impirador do Persya, inpakatoneng ni ĀPO minsahi naw di propīta Sakaryas a pōtot ni Barakyas a apōko ni Iddo. ");
INSERT INTO ivb_vpl VALUES ("ZC1_2","039_1_2","ZEC","1","2","2","Binata ni ĀPO dya a kāna, “Taywaraw nakapakasoli ko dyirad kapoonan nyo saw. ");
INSERT INTO ivb_vpl VALUES ("ZC1_3","039_1_3","ZEC","1","3","3","Dawa, ibahey mo do tawotawo saya: Nyaw batahen ko a ĀPO a Manakabalin: ‘Maybidi kamo na dyaken tan maybidi ako na dyinyo.’ ");
INSERT INTO ivb_vpl VALUES ("ZC1_4","039_1_4","ZEC","1","4","4","Toladen nyo sabaw kapoonan nyo saw a nangibaheyan dan nanmanma saw a propīta so inpaibahey kwaw a ‘Tadyichokodan nyo naw marahet saya kaparin kan marahet saya dadakay nyo.’ Ki akmaw abo tadyinya da, kan inkaskāso daba yaken. ");
INSERT INTO ivb_vpl VALUES ("ZC1_5","039_1_5","ZEC","1","5","5","Siraw kapoonan nyo saw, yanan darana? As siraw propīta saw, nanayon sawri a sibibyay? ");
INSERT INTO ivb_vpl VALUES ("ZC1_6","039_1_6","ZEC","1","6","6","Ki siraw bilbilin kan balballāag ko saw a inpaibahey ko dyirad pachirawatan ko saw, ki nanayonayon abawri kan siraw kapoonan nyo saw? Sinpangan na, nagbabāwi sa kan inpodno da a yaken a ĀPO a Manakabalin, ki dinōsa ko sa sigon do pinarin daw kan akmas inkeddeng kwaw a parinen.” ");
INSERT INTO ivb_vpl VALUES ("ZC1_7","039_1_7","ZEC","1","7","7","Do chadadwa naw a poho kan apat a karaw, do chaasa poho naw kan asa kabohan, iyaw bohan naw no Sebat, do chadadwa naw a kakawan no kapagtoray ni Daryo, inpakatoneng dana ni ĀPO di propīta Sakaryas a pōtot ni Barakyas a apōko ni Iddo. ");
INSERT INTO ivb_vpl VALUES ("ZC1_8","039_1_8","ZEC","1","8","8","Binata ni Sakaryas do parmata naw a kāna, “Do kamahep, nakaboya akos tawo a nakasakay do mabaya a kabalyo! Myanaw a nagsardeng do bongrwaw do payahosonganaw. Do dichodan naw myan saw nakasakay do kabalyo a mabaya, nahoto so kita, kan maydak.” ");
INSERT INTO ivb_vpl VALUES ("ZC1_9","039_1_9","ZEC","1","9","9","Sinpangan na, inyahes ko a kon ko, “Mo āpo, āngo saw nya?” Binata no anghilaw a machisisirin dyaken a kāna, “Ipaboya ko sa dyimo an āngo chakey a batahen nya saya. ");
INSERT INTO ivb_vpl VALUES ("ZC1_10","039_1_10","ZEC","1","10","10","Tinoboy san ĀPO nya saya magwanawan do intīrwaya lōbong.” ");
INSERT INTO ivb_vpl VALUES ("ZC1_11","039_1_11","ZEC","1","11","11","Do dāwri, inpadāmag dan nakasakayaw do kabalyo saw nya do Anghilaw ni ĀPO: “Winanawanan namenaw intīrwaya lōbong, kan natonngan namenaw a maolimek kan matalna.” ");
INSERT INTO ivb_vpl VALUES ("ZC1_12","039_1_12","ZEC","1","12","12","Sinpangan na, binata no Anghilaw ni ĀPO a kāna, “O ĀPO a Manakabalin, māngo pas kahay sakbay no kaipaboya mos kāsi mo dyirad tawotawo saw do Jerosalem kan do idi saw do Joda, ta papito danaya poho a katawen?” ");
INSERT INTO ivb_vpl VALUES ("ZC1_13","039_1_13","ZEC","1","13","13","Ki naychirin si ĀPO so makahwahok a chirin do anghilaw a machisisirin dyaken. ");
INSERT INTO ivb_vpl VALUES ("ZC1_14","039_1_14","ZEC","1","14","14","Do dāwri, binatan anghilaw a machisisirin dyaken a kāna, “Ipakatoneng mo nya: Iyaw nyaw binata ni ĀPO a Manakabalin a kāna: ‘Oltimo kaipateg ko so Jerosalem kan Sion a yanan Timplo. ");
INSERT INTO ivb_vpl VALUES ("ZC1_15","039_1_15","ZEC","1","15","15","Taywaraw kaisoli ko so nasyon saya a masaray dana. On, insoli ko saw so dēkey tawotawo ko saya, ki pinangāngayan dayan nasyon saya linidyalidyat. ");
INSERT INTO ivb_vpl VALUES ("ZC1_16","039_1_16","ZEC","1","16","16","As dawa, naybidi ako na do Jerosalem a mangipaboya so kāsi. As iyaw Timplo ko, ki mirwanchi a mapatnek, as kan komwan anchi a makapya anchiw syodadaw.’” ");
INSERT INTO ivb_vpl VALUES ("ZC1_17","039_1_17","ZEC","1","17","17","Inbahey no anghilaw a machisisirin dyaken a ipakatoneng ko nya: “Nyaw binata ni ĀPO a Manakabalin a kāna, ‘Siraw syodad ko saya, ki magliplipyas dananchiw kapaypaganay. As yaken a ĀPO, ahwahoken ko na sanchiw tawotawo do Sion, kan pidyen ko naw Jerosalem a mirwa.’” ");
INSERT INTO ivb_vpl VALUES ("ZC1_18","039_1_18","ZEC","1","18","18","Sinpangan na, tomnangay ako, ki nakaboya ako so apat a olong no bāka! ");
INSERT INTO ivb_vpl VALUES ("ZC1_19","039_1_19","ZEC","1","19","19","Do dāwri, inyahes ko do machisisirinaw dyaken a anghil, “Āngo saw nya?” Ki tinbay na a kāna, “Siraw nya olong, pachiparihwan dan mabīleg saya nasyon do lōbong a napaychawpit so tawotawo do Joda, Israel, kan Jerosalem.” ");
INSERT INTO ivb_vpl VALUES ("ZC1_20","039_1_20","ZEC","1","20","20","Do dāwri, inpaboya dyaken ĀPO apat saw a manyichipo. ");
INSERT INTO ivb_vpl VALUES ("ZC1_21","039_1_21","ZEC","1","21","21","Ki binata ko a kon ko, “Āngo parinen dan nya saya?” Ki tinbay na yaken a kāna, “Siraw olong saya, ki pinaychawpit da saw tawotawowaw do Joda tan abo tawo a makaitored. Ki siraw manyichipo saya, yangay da sa amomohen kan paksyaten nasyon saya a nanghomis, as kan napaychawpit so tawotawo saya do Joda.” ");
INSERT INTO ivb_vpl VALUES ("ZC2_1","039_2_1","ZEC","2","1","1","Sinpangan na, tomnangay ako kan do matarek a parmata, nakaboya ako na so tawo a mangigpet so hobid a rorokod. ");
INSERT INTO ivb_vpl VALUES ("ZC2_2","039_2_2","ZEC","2","2","2","Inyahes ko a kon ko, “Kwanan mo?” Ki tinbay na yaken a kāna, “Yangay ko pa rokoden Jerosalem tan matonngan ko kawbong kan kanaro na.” ");
INSERT INTO ivb_vpl VALUES ("ZC2_3","039_2_3","ZEC","2","3","3","Do dāwri, kinarwan yaken anghilaw a kasisirin ko, ki binayat no matarekaw a anghil, ");
INSERT INTO ivb_vpl VALUES ("ZC2_4","039_2_4","ZEC","2","4","4","kan binata na dya a kāna, “Mayyayo ka a mangay do dawri a barīto a mangigpet so hobid a rorokod, kan ibahey mo dya a mahadan abanchiw syodad no Jerosalem maynamot do taywara kāro no tawotawo kan binyay. ");
INSERT INTO ivb_vpl VALUES ("ZC2_5","039_2_5","ZEC","2","5","5","Inbahey ni ĀPO a iyanchiw mayparin a ahad a apoy do omdibonaw no syodad tan mangaywan sya. As iyanchiw machiyan daw do tabo a dayag na.” ");
INSERT INTO ivb_vpl VALUES ("ZC2_6","039_2_6","ZEC","2","6","7","Binata ni ĀPO dyirad tawotawo na saw a kāna, “Pinawpit koynyo do tabo a sōli no lōbong. Ki sichangori, inyo a naakaw, ki payyayowan nyo naw Babilonya kan somabat kamo na do Jerosalem. ");
INSERT INTO ivb_vpl VALUES ("ZC2_8","039_2_8","ZEC","2","8","8","As no aran sino a nasyon a mangsalid a mapaynyin dyinyo, bāli pinaynyinan naw oltimwaw so kapateg dyaken.” Dawa, si ĀPO a Manakabalin, nanoboy dyaken do bōkod na a dayag a mangyangay so nya minsahi dyirad nasyon saw a nangsamsam so warawara dan tawotawo na saw a kāna, ");
INSERT INTO ivb_vpl VALUES ("ZC2_9","039_2_9","ZEC","2","9","9","“Yaken anchi a ĀPO mismo a manggobat dyinyo a nasnasyon, as kan samsaman danchi inyo no tawotawo saw a naakaw a inadipen nyo.” Anchan maparin nya, mapatakan nanchi no kāda asa a si ĀPO a Manakabalin nanoboy dyaken. ");
INSERT INTO ivb_vpl VALUES ("ZC2_10","039_2_10","ZEC","2","10","10","Binata pa ni ĀPO a kāna, “Ikankanta nyo kasoyot nyo, inyo a tawotawo no Jerosalem, ta īto ako na kan machiyan ako dyinyo!” ");
INSERT INTO ivb_vpl VALUES ("ZC2_11","039_2_11","ZEC","2","11","11","Āro sanchiw nasnasyon a machikāmang di ĀPO do dāwri a araw, kan mayparin sanchi a tawotawo na. Machiyan anchi dyinyo kan matonngan nyonchi a tinoboy na yaken dyinyo. ");
INSERT INTO ivb_vpl VALUES ("ZC2_12","039_2_12","ZEC","2","12","12","Payparinen dananchi ni ĀPO tanaw a Joda a itatārek a dyira na do masantwanaw a tana, as kan pidyen narananchi a mirwaw Jerosalem a syodad na. ");
INSERT INTO ivb_vpl VALUES ("ZC2_13","039_2_13","ZEC","2","13","13","Magolimek kamo, inyo a tabo a tawotawo do salapen ni ĀPO, ta īto dana dyaten yapod masantwan a yanan na. ");
INSERT INTO ivb_vpl VALUES ("ZC3_1","039_3_1","ZEC","3","1","1","Do dāwri, do matarek a parmata, inpaboya dyaken ĀPO si Joswe a katotohosan a pādi a myan a maytēnek do salapenaw no Anghil ni ĀPO. Aran si Satanas, ki myan a maytēnek do bīt naw do kawanan a nakasagāna mangidarom sya. ");
INSERT INTO ivb_vpl VALUES ("ZC3_2","039_3_2","ZEC","3","2","2","Sinpangan na, binata no Anghilaw ni ĀPO di Satanas a kāna, “Okomen pakono imo ni ĀPO mo Satanas. On, okomen na pakono imo ni ĀPO a namidi so Jerosalem, ta iyaw nya a tawo a si Joswe, ki insalākan ni ĀPO akmay irotong a nalnet a yapod apoy.” ");
INSERT INTO ivb_vpl VALUES ("ZC3_3","039_3_3","ZEC","3","3","3","Si Joswe, ki nakalaylay so malapos a maytēnek do salapenaw no Anghil ni ĀPO. ");
INSERT INTO ivb_vpl VALUES ("ZC3_4","039_3_4","ZEC","3","4","4","Do dāwri, binata no Anghilaw ni ĀPO dyirad magsirsirbi saw dya a kāna, “Bahasen nyo malapos saya laylay na.” As insarono na a binata di Joswe a kāna, “Chiban mo, pinakaro ko naw gatos mo, kan changori laylayan ko na imo so bayo a dya sinsinan.” ");
INSERT INTO ivb_vpl VALUES ("ZC3_5","039_3_5","ZEC","3","5","5","Sinpangan na, inbilin nad magsirsirbi saw dya a barabādan da si Joswe. Dawa, binarabādan das madalos oho naw, as kan linaylayan das madadas, ki myan a maytēnek do dawriw Anghilaw ni ĀPO. ");
INSERT INTO ivb_vpl VALUES ("ZC3_6","039_3_6","ZEC","3","6","6","Do dāwri, binata no Anghilaw ni ĀPO di Joswe a kāna, ");
INSERT INTO ivb_vpl VALUES ("ZC3_7","039_3_7","ZEC","3","7","7","“Iyaw nyaw binata ni ĀPO a Manakabalin a kāna, ‘An onotan mo saw linteg ko, as kan parinen mo saw itoroh ko saw a pagrebbengan mo, imonchiw mangipangōlo do Timplo ko, as kan aran do pangokoman. Itoroh konchi dyimo kalintegan a machiraman dyirad maytēnek saya dya. ");
INSERT INTO ivb_vpl VALUES ("ZC3_8","039_3_8","ZEC","3","8","8","Mangadngey kam Joswe a katotohosan a pādi kan inyo a rarayay na a papādi. Pangancharan kamo so maparin anchi do masakbayan, ta mahay paba, ki toboyen konchiw pachirawatan kwaw a mayngaran so Sanga. ");
INSERT INTO ivb_vpl VALUES ("ZC3_9","039_3_9","ZEC","3","9","9","On, ta pinadisna ko batwaya do salapenaya ni Joswe. As iyaw nya bato, ki nabalabāla so papito kan mangikitikit akonchi so tolas do dawri a bato. As do asa karaw, ponāsen ko nanchiw gatos no nya tana. ");
INSERT INTO ivb_vpl VALUES ("ZC3_10","039_3_10","ZEC","3","10","10","Do dāwrinchi a araw, maysin-aawis kamo do bōkod nyo a kaobasan kan kaigosan a mangnānam so kaydamnayan kapangtokto a abwa polos so kamwamwan.’ Nyaw binata ni ĀPO a Manakabalin.” ");
INSERT INTO ivb_vpl VALUES ("ZC4_1","039_4_1","ZEC","4","1","1","Do dāwri, nangay dana machisisirin dyaken anghilaw, as kan yinokay na yaken a akma 'koy nakaycheh. ");
INSERT INTO ivb_vpl VALUES ("ZC4_2","039_4_2","ZEC","4","2","2","Inyahes na dyaken a kāna, “Āngo maboya mo?” Ki tinbay ko a kon ko, “Makaboya akwayas paydisnan paysohwan a maynana balitok. Aryayaw sabak do rabaw naya yanan lana. Do omdibonaya no nya sabak myan saw papito sa paysohwan. As kāda asa, ki myan papito a kadopit na a ayaman pabīlo na a komāmang do soho saya. ");
INSERT INTO ivb_vpl VALUES ("ZC4_3","039_4_3","ZEC","4","3","3","Myan payaw dadwa kayo a olibo do maybītaya no paydisnan paysohwan asa do kawanan as asa do kaholi.” ");
INSERT INTO ivb_vpl VALUES ("ZC4_4","039_4_4","ZEC","4","4","4","Do dāwri, inyahes ko do anghilaw a machisisirin dyaken a kon ko, “Āngo saw nyaya mo āpo?” ");
INSERT INTO ivb_vpl VALUES ("ZC4_5","039_4_5","ZEC","4","5","5","Ki binata dyaken anghilaw a kāna, “Chapatak mo sabawriw nya?” Ki initbay ko a kon ko, “Enggaya mo āpo.” ");
INSERT INTO ivb_vpl VALUES ("ZC4_6","039_4_6","ZEC","4","6","10a","(4:14) ");
INSERT INTO ivb_vpl VALUES ("ZC4_10b","039_4_10b","ZEC","4","10b","10b","Do dāwri, binata dyaken no anghilaw a kāna, “Siraw papitwaya paysohwan siraw nawriw akmaw papito a mata ni ĀPO a manyidechideb so tanaya.” ");
INSERT INTO ivb_vpl VALUES ("ZC4_11","039_4_11","ZEC","4","11","11","Ki inyahes ko a kon ko, “Na, āngo chakey a batahen kayo saya no olibo do maybītaya siri no paydisnan paysohwan?” ");
INSERT INTO ivb_vpl VALUES ("ZC4_12","039_4_12","ZEC","4","12","12","Inyahes ko na pinirwa a kon ko, “Āngo chakey a batahen dadwaya sanga no olibo do katangked daya no dadwa balitok a tōbo a oyogan dan lanaya no olibo?” ");
INSERT INTO ivb_vpl VALUES ("ZC4_13","039_4_13","ZEC","4","13","13","“Chapatak mo abawri an āngo saw nya?” inyahes na. “Enggayam āpo,” initbay ko. ");
INSERT INTO ivb_vpl VALUES ("ZC4_14","039_4_14","ZEC","4","14","14","“Siraw nyaw dadwaw a mahahakay a napapotan so lana a maipaboya a pinidi no Dyos a magsirbi dya a Āpo do intīro a tana.” Nyaw binata na. 6 Sinpangan na, binata no anghilaw a machisisirin dyaken a ibahey ko nya minsahi ni ĀPO di Serobabbel: “No manoroh so ballīgi mo, ki yapo aba do bīleg mana panakabalin mo an dya yapo do ispirito a yapo dyaken. 7 Siraw mangbalat a akmas karakohaya no tokon, ki mabo sanchi. Bangonen mo nanchiw Timplo. As anchan pangayen mo manawdyaw a bato, ingengengey danchi no tawotawo, ‘No Dyos bindisyonan na! No Dyos bindisyonan na!’” 8 Do dāwri, inpakatoneng dana ni ĀPO minsahi naw dyaken a kāna, 9 “Si Serobbabel napangay so pondasyon no nya Timplo, kan iyanchiw mapatayoka sya. Anchan maparin nyaya, mapatakan dananchin tawotawo a yaken nanoboy dyimo a mangay dyira. 10a Aran sino a mangiroromen so dēkey a naytarabākwan, ki masoyot sanchi anchan maboya da si Serobbabel a mangtongtong a mapatnek so Timplo.” ");
INSERT INTO ivb_vpl VALUES ("ZC5_1","039_5_1","ZEC","5","1","1","Sinpangan na, tomnangay ako na minirwa, kan nakaboya ako so somayasayap a nahon a pagbasāan! ");
INSERT INTO ivb_vpl VALUES ("ZC5_2","039_5_2","ZEC","5","2","2","Do dāwri, inyahes no anghilaw a machisisirin dyaken a kāna, “Āngo maboya mo?” Ki tinbay ko a kon ko, “Somayasayapaya nahon a pagbasāan a tatdo a poho a karapan so kanaro kan asa poho kan dadima a karapan so kawbong.” ");
INSERT INTO ivb_vpl VALUES ("ZC5_3","039_5_3","ZEC","5","3","3","Ki binata na dyaken a kāna, “Naitolas do dyaya pagbasāan iyaw abay a komayakayab do intīro a lōbong. Sigon do naitolas do bīt naya, ki mapaksyat sanchi a tabo manakanakaw do tanaya. As do bīt naya, ki naitolas a mapaksyat sanchi a tabo mangsaksi so bayataw. ");
INSERT INTO ivb_vpl VALUES ("ZC5_4","039_5_4","ZEC","5","4","4","Binata ni ĀPO a Manakabalin a kāna, ‘Toboyen konchiw nya abay a mohtot kan somdep do bahay no kāda manakanakaw, as kan do kāda bahay no tabo a mangsaksi so bayataw. Omyan anchi dyira kan rarayawen nanchiw bahabahay da.’” ");
INSERT INTO ivb_vpl VALUES ("ZC5_5","039_5_5","ZEC","5","5","5","Do dāwri, iyaw anghilaw a machisisirin dyaken, naypantad kan binata na dyaken a kāna, “Tomangay ka, ta chiban mo ītwaya.” ");
INSERT INTO ivb_vpl VALUES ("ZC5_6","039_5_6","ZEC","5","6","6","Ki inyahes ko a kon ko, “Āngo nawri?” Ki tominbay a kāna, “Asa pagsokātan a bakag. No chakey na batahen, ki karahet no tawotawo do intīro a lōbong.” ");
INSERT INTO ivb_vpl VALUES ("ZC5_7","039_5_7","ZEC","5","7","7","Sinpangan na, nabwang tohong naw a boli, ki myan nachisdot a maydisna mabakes. ");
INSERT INTO ivb_vpl VALUES ("ZC5_8","039_5_8","ZEC","5","8","8","Ki binata no anghilaw a machisisirin dyaken a kāna, “Iyaw nyaw gatos.” Do dāwri, pinagmis na pinabidiw mabakesaw do irahemaw no bakag, as nakapagmis na so bolyaw a tohong na. ");
INSERT INTO ivb_vpl VALUES ("ZC5_9","039_5_9","ZEC","5","9","9","Sinpangan na, tomnangay ako a nanyideb, ki nakaboya ako so dadwa mababakes a somayap a komwan dyaken. Siraw panyid da saw, ki rarakoh kan mayit. Inhap daw bakagaw a insayap. ");
INSERT INTO ivb_vpl VALUES ("ZC5_10","039_5_10","ZEC","5","10","10","“Namna, dino ikwanan das bakagaya?” inyahes ko do anghilaw a machisisirin dyaken. ");
INSERT INTO ivb_vpl VALUES ("ZC5_11","039_5_11","ZEC","5","11","11","Ki tinbay na yaken a kāna, “Iyangay dad Babilonya a pamarinan das timplo na. An mapatayoka dana, padisnahen danchi daw bakagaya a pagdaydayāwan dan tawotawo.” ");
INSERT INTO ivb_vpl VALUES ("ZC6_1","039_6_1","ZEC","6","1","1","Tomnangay ako na. Ki do dāwri, nakaboya ako so apat a karison a pachigobat, kan nayhohtot sa do payawan daw no dadwa tombāga a tokon. ");
INSERT INTO ivb_vpl VALUES ("ZC6_2","039_6_2","ZEC","6","2","2","Iyaw manōmaw a karison a pachigobat, ki goygoyōden dan mababaya a kabalyo. No somaronwaw, ki goygoyōden dan mababaheng a kabalyo. ");
INSERT INTO ivb_vpl VALUES ("ZC6_3","039_6_3","ZEC","6","3","3","No chatatdo daw, ki goygoyōden dan mayidak a kabalyo. As no chapat daw, ki goygoyōden dan labang a kabalyo. Sira tabo, ki mabibīleg sa. ");
INSERT INTO ivb_vpl VALUES ("ZC6_4","039_6_4","ZEC","6","4","4","Do dāwri, inyahes ko na do machisisirinaw dyaken a anghil a kon ko, “Āngo saw nya mo Āpo?” ");
INSERT INTO ivb_vpl VALUES ("ZC6_5","039_6_5","ZEC","6","5","5","Ki tinbay na yaken a kāna, “Siraw nyaw apat saw a salawsaw no kahanyihanyitan kan kayayapo da do salapen Āpo no intīro a lōbong. ");
INSERT INTO ivb_vpl VALUES ("ZC6_6","039_6_6","ZEC","6","6","6","“Iyaw karisonaw a pachigobat a goygoyōden dan mababahengaw a kabalyo, ki mangay do ammyānan a komwan do Babilonya. Iyaw asaw a goygoyōden dan mayidakaw a kabalyo, ki komwan do lāod. As no asaw a goygoyōden dan labangaw a kabalyo, ki komwan do abagātan.” ");
INSERT INTO ivb_vpl VALUES ("ZC6_7","039_6_7","ZEC","6","7","7","Do kahtot daw no mabibīleg saw a kabalyo, makapanapanaya pa saba a mangay do intīro a lōbong. Ki binata no anghilaw a kāna, “Yangay nyo a wanawanan intīro a lōbong!” Do dāwri, nangay sa. ");
INSERT INTO ivb_vpl VALUES ("ZC6_8","039_6_8","ZEC","6","8","8","Katayokan nya, inngengey no anghilaw dyaken a kāna, “Chiban mo saw kabalyowaya a kominwan do ammyānan do Babilonya, ki binawan daw soli ni ĀPO do dawri a tana.” ");
INSERT INTO ivb_vpl VALUES ("ZC6_9","039_6_9","ZEC","6","9","9","Inpakatoneng ni ĀPO minsahi naw dyaken a kāna, ");
INSERT INTO ivb_vpl VALUES ("ZC6_10","039_6_10","ZEC","6","10","10","“Rawaten mo sāgot da saya no naakaw saya a nawara yapod Babilonya a sa Helday, Tobidyas, kan Jedayas. Nyeng mo a yangay do bahay ni Josias a pōtot ni Sepanyas. ");
INSERT INTO ivb_vpl VALUES ("ZC6_11","039_6_11","ZEC","6","11","11","Hapen mo saw sāgot da saya balitok kan pirak, kan parinen mo a korona, as kapangay mo sya do ohwaya ni Joswe a katotohosan a pādi a pōtot ni Jehosadak. ");
INSERT INTO ivb_vpl VALUES ("ZC6_12","039_6_12","ZEC","6","12","12","Ibahey mo di Joswe iyaw nya ibahey ni ĀPO a Manakabalin do Tābo a kāna, ‘Cha dyaw tawowaw a mapangaranan so Sanga ta mayparakoh anchi a akmas sanga do tanaya as kan patneken nanchiw Timplo ni ĀPO. ");
INSERT INTO ivb_vpl VALUES ("ZC6_13","039_6_13","ZEC","6","13","13","On, iyanchiw mismo a mapatnek so Timplo ni ĀPO, as kan rawaten nanchiw pammadāyaw a rombeng do āri, as itorayan na sanchiw tawotawo na. As kan myan panchiw pādi do bīt no trono naya. Do dāwri, myan tōnos kan kapya do nagbaetan da a dadwa.’ ");
INSERT INTO ivb_vpl VALUES ("ZC6_14","039_6_14","ZEC","6","14","14","Iyanchiw korona, ki pakanaknakman anchi do Timplo ni ĀPO da Helday, Tobidyas, Jedayas, kan Josias a pōtot ni Sepanyas. ");
INSERT INTO ivb_vpl VALUES ("ZC6_15","039_6_15","ZEC","6","15","15","“Siranchiw myan saw do mateng, mangay sanchi a somidong a mapatnek so Timplo ni ĀPO. As anchan mirwa a napatnek, ki matonngan nyonchi a yaken a si Sakaryas, ki tinoboy na yaken ni ĀPO a Manakabalin dyinyo. Maparin sanchi a tabo nyaya an sipapasnek kamo a magtongpal di ĀPO a Dyos nyo.” ");
INSERT INTO ivb_vpl VALUES ("ZC7_1","039_7_1","ZEC","7","1","1","Do chapat naw a katawen no kapagtoray ni Āri Daryo, nangipakatoneng si ĀPO so minsahi na di Sakaryas, do chapat naw a karaw, do chasasyam naw a kabohan a mapangaranan so Kisleb. ");
INSERT INTO ivb_vpl VALUES ("ZC7_2","039_7_2","ZEC","7","2","2","Tinoboy da san taga Betel saw sa Sareser kan Regemmelek kontodo tawotawo da saw a mangay do Timplo ni ĀPO a mangdaw so bindisyon ni ĀPO. ");
INSERT INTO ivb_vpl VALUES ("ZC7_3","039_7_3","ZEC","7","3","3","Inpaiyahes da dyirad papādi saw kan aran propīta saw do Timplo ni ĀPO iyaw nya a kon da, “Tongtongen namen pawriw magdongdong-aw kan magayonar do chadadima naya bohan a akmas pinariparin namenaw do nakahabas saya āro a tawtawen a mandas changori?” ");
INSERT INTO ivb_vpl VALUES ("ZC7_4","039_7_4","ZEC","7","4","4","Sinpangan na, inpakatoneng ni ĀPO a Manakabalin minsahi naw dyaken a kāna, ");
INSERT INTO ivb_vpl VALUES ("ZC7_5","039_7_5","ZEC","7","5","5","“Ibahey mo dyirad tawotawo saya do tanaya as kan do papādi saya iyaw nya: ‘Do kapagayonar kan nakapagdongdong-aw nyowaw do chadadima naw kan chapapito naw a kabohan, do kayan papitwaya poho a katawen a nakaakaw nyo a yapod tana nyo, yaken nawriw pinadayāwan nyo? Engga! ");
INSERT INTO ivb_vpl VALUES ("ZC7_6","039_7_6","ZEC","7","6","6","As kan do kapaychakakan kan kapaychaynoynom nyowaw, tod nyo abawri a parinen a para do inaynawan nyo?’ ");
INSERT INTO ivb_vpl VALUES ("ZC7_7","039_7_7","ZEC","7","7","7","“Tinongpal nyo pakono”, kāna ni ĀPO, “iyaw inpaibahey kwaw dyirad propīta saw do nakarahan do chimpwaw a no Jerosalem, ki mabaknang kan āro so tawotawo a aran do omdibon naw a idiidi, do abagātanaw a Negeb kan do paytokonan saw do lāod naw.” ");
INSERT INTO ivb_vpl VALUES ("ZC7_8","039_7_8","ZEC","7","8","8","Inpakatoneng dana ni ĀPO minsahi naw di Sakaryas a kāna, ");
INSERT INTO ivb_vpl VALUES ("ZC7_9","039_7_9","ZEC","7","9","9","“Do kaychowa, intoroh ko saw nya bilbilin dyirad tawotawo ko saw: ‘Ipākat nyo kosto a kapangokom; ipaboya nyo kāsi kan kapachipangdidiw do katakatayisa dyinyo. ");
INSERT INTO ivb_vpl VALUES ("ZC7_10","039_7_10","ZEC","7","10","10","Idadanes nyo sabaw bālo saw mana olila saw aran siraw gan-ganaet saw mana mapopobri saw. Iktokto nyo abaw mangīsad so marahet do kapayngay nyo a tawo.’ ");
INSERT INTO ivb_vpl VALUES ("ZC7_11","039_7_11","ZEC","7","11","11","“Ki chinaskeh dan tawotawo ko saw nangadngey. Do katwaw no oho da, tomnadyichokod sa, as nakabengbeng das tadyinya da. ");
INSERT INTO ivb_vpl VALUES ("ZC7_12","039_7_12","ZEC","7","12","12","Pinatwa daw posposo da akmay bato maynamot ta mangadngey saba so linteg kan inanawo kwaw a inpaipakatoneng ko dyirad propīta ko saya kaychowa. Dawa, nakasoli ako so taywara dyira. ");
INSERT INTO ivb_vpl VALUES ("ZC7_13","039_7_13","ZEC","7","13","13","Maynamot ta akma say bitor do nakapaychirin kwaw dyira, inkaskāso ko sabaw dasal da. ");
INSERT INTO ivb_vpl VALUES ("ZC7_14","039_7_14","ZEC","7","14","14","Akmas bagyo, pinasayaw ko sa a nangay a minyan do gan-ganaet a nasnasyon. Dawa, iyaw nya maganay a tana a kinarwan da, ki nainonolay a makalidliday, kan apabaw aran asa a maparin a omyan daw.” ");
INSERT INTO ivb_vpl VALUES ("ZC8_1","039_8_1","ZEC","8","1","1","Inpakatoneng dana ni ĀPO a Manakabalin minsahi naw di Sakaryas a kāna, ");
INSERT INTO ivb_vpl VALUES ("ZC8_2","039_8_2","ZEC","8","2","2","“Inahahay ko kasidong ko so Jerosalem maynamot do dya matokod a kadaw ko siras tawotawo naya. Maynamot do kadaw ko, insoli ko saw kabōsor na saw. ");
INSERT INTO ivb_vpl VALUES ("ZC8_3","039_8_3","ZEC","8","3","3","Maybidi ako do Sion, iyaw tokonaw a naydisnan Timplo, kan omyan akonchi do Jerosalem. As matawagan anchiw Jerosalem so mapodno a syodad. As no matawagan so Tokon ni ĀPO a Manakabalin, ki matawagan anchi so masantwan a tokon. ");
INSERT INTO ivb_vpl VALUES ("ZC8_4","039_8_4","ZEC","8","4","4","Siraw taywara a mangalkem kan babbaket, ki maydisna sanchi do payis no kalkalsāda do Jerosalem a maynahah, as kan maysarokod sa maynamot do kalalakay kan kababaket da. ");
INSERT INTO ivb_vpl VALUES ("ZC8_5","039_8_5","ZEC","8","5","5","Mapno dananchiw kalkalsāda saw no syodad so adedekey a maychagtagtal. ");
INSERT INTO ivb_vpl VALUES ("ZC8_6","039_8_6","ZEC","8","6","6","“Maparin a dyi da anohdan no naakaw saw a nakalāsat a nakapaybidi a tawotawo ko, ki maydamnay lang dyaken nya. ");
INSERT INTO ivb_vpl VALUES ("ZC8_7","039_8_7","ZEC","8","7","7","Isalākan ko sanchiw tawotawo ko saw do nasyon saw do dāya kan do lāod a nakaiyangayan da. ");
INSERT INTO ivb_vpl VALUES ("ZC8_8","039_8_8","ZEC","8","8","8","Isabat ko sanchi tan omyan dana sanchi do Jerosalem. Siranchiw tawotawo ko kan yaken anchiw Dyos da, itorayan ko sanchi a sipopodno kan abanchiw itatārek ko. ");
INSERT INTO ivb_vpl VALUES ("ZC8_9","039_8_9","ZEC","8","9","9","“Inyo a makadngey siras nya chirin sichangori do inbahey daw no propīta saw a myan do dāwri do nakapangay daw so pondasyon no Timplo kwaya, payiten nyo kapangtokto nyo tan mapatnek danaw Timplo kwaya. ");
INSERT INTO ivb_vpl VALUES ("ZC8_10","039_8_10","ZEC","8","10","10","Sakbay do dāwri a chimpo, abaw makakāya manangdan so tawo mana animal. Abaw tod a makangangay do ngayan na a maynamot do kamo nad kabōsor na, ta pinaysin-iipsok ko sa tabo tawotawo. ");
INSERT INTO ivb_vpl VALUES ("ZC8_11","039_8_11","ZEC","8","11","11","Ki sichangori, akma paba do nakahabas kaparin ko dyirad tawotawo saya a nakalāsat a nakapaybidi.” Nyaw binata ni ĀPO a Manakabalin do a Tābo. ");
INSERT INTO ivb_vpl VALUES ("ZC8_12","039_8_12","ZEC","8","12","12","“Makapaymoha dana sa sitatalna. Tomobo dananchiw botoh, may-asi dananchiw obas da, as āro dananchiw maāpit do tana, as kan asdayen dananchi no hanyit maboslon a apon. Itoroh ko sanchi a tabo nyaya bindisyon do nakalāsat saya tawotawo ko a nakapaybidi. ");
INSERT INTO ivb_vpl VALUES ("ZC8_13","039_8_13","ZEC","8","13","13","Do nakarahan, inyo a tawotawo no Joda kan Israel, inyo pananahan da a naabay no nasyon saya. Ki isalākan konchi inyo, as kan inyo maybadiw a pananahan da a mabindisyonan. Dawa, inyo a tawotawo no Joda kan Israel, mamo kamwaba kan tomored kamo.” ");
INSERT INTO ivb_vpl VALUES ("ZC8_14","039_8_14","ZEC","8","14","14","Tinongtong a binata ni ĀPO a Manakabalin a kāna, “Do nakapasoli daw dyaken kapoonan nyo saw, inkeddeng ko didigra dyira as kan abaw inpaboya ko a kāsi dyira. ");
INSERT INTO ivb_vpl VALUES ("ZC8_15","039_8_15","ZEC","8","15","15","Ki sichangori, inkeddeng ko naw mamarin so maganay do tawotawo no Jerosalem kan no Joda. Dawa, mamo kamwaba. ");
INSERT INTO ivb_vpl VALUES ("ZC8_16","039_8_16","ZEC","8","16","16","Siraw nyaw machita parinen nyo: Ichirin nyo oyod do katakatayisa dyinyo. Masaw ipākat nyo kosto a pangeddeng a mapaychachapya do pangokoman nyo. ");
INSERT INTO ivb_vpl VALUES ("ZC8_17","039_8_17","ZEC","8","17","17","Magpanggep kamo abas marahet a maikontra do kapayngay nyo a tawo, kan chadaw nyo abaw mangipaneknek so bayataw, ta ipsok ko sa tabo nya.” Nyaw binata ni ĀPO. ");
INSERT INTO ivb_vpl VALUES ("ZC8_18","039_8_18","ZEC","8","18","18","Inpakatoneng dana ni ĀPO a Manakabalin minsahi naw dyaken a si Sakaryas a kāna, ");
INSERT INTO ivb_vpl VALUES ("ZC8_19","039_8_19","ZEC","8","19","19","“No kapagayonar nyo do chapat, chadadima, chapapito kan chaasa poho naw a bohan, ki payparinen konchi a maragsak kan makasoyosoyot a pista no tawotawo do Joda. Dawa, machita chadaw nyo kaoyodan kan kapaychapya. ");
INSERT INTO ivb_vpl VALUES ("ZC8_20","039_8_20","ZEC","8","20","20","“Marapit anchiw chimpo a siraw tawotawo saya a yapo do āro saya a syodad, ki mangay sanchi do Jerosalem. ");
INSERT INTO ivb_vpl VALUES ("ZC8_21","039_8_21","ZEC","8","21","21","Siranchiw omyanaw do asa a syodad, ki mangay sanchi do matarekaw a syodad, kan bata da, ‘Mangay kami na insigīda a magdāyaw di ĀPO a Manakabalin kan mangdakdaw so bindisyon. Ngay! May ta!’ ");
INSERT INTO ivb_vpl VALUES ("ZC8_22","039_8_22","ZEC","8","22","22","On, āro sanchi a tawotawo kan mabibīleg a nasnasyon mangay do Jerosalem a magdaydāyaw di ĀPO a Manakabalin kan mangdakdaw so bindisyon na. ");
INSERT INTO ivb_vpl VALUES ("ZC8_23","039_8_23","ZEC","8","23","23","Do dāwri sanchi a araw, asa pohonchi a tawotawo a yapod kāda kapaychirin do kāda nasyon, ki mangay a machikakaāsi do asa Jodyo kan batahen danchi a kon da, ‘Palobosan nyo pa yamen a machirayay dyimo, ta nadāmag namenaw a iyaw Dyos, ki myan dyimo!’” ");
INSERT INTO ivb_vpl VALUES ("ZC9_1","039_9_1","ZEC","9","1","1","Nyaw minsahi ni ĀPO a maikontra do tana a Hadrak kan do syodad no Damasko. Ta dyira na tabo tawotawo do lōbongaya a akmas tabo no tribo no Israel a dyira pa ni ĀPO. ");
INSERT INTO ivb_vpl VALUES ("ZC9_2","039_9_2","ZEC","9","2","2","Masaw do Hamat a myan do payawan Hadrak kan do Damasko. Akma saw do syodad dan Tiro kan Sidon kontodo kasirīban da. ");
INSERT INTO ivb_vpl VALUES ("ZC9_3","039_9_3","ZEC","9","3","3","As no Tiro, ki namarin so kōta na. Nangpeh pa so āro a pirak a tod a akmay ahbek, as kan balitok a tod a akmay hota do kalsāda. ");
INSERT INTO ivb_vpl VALUES ("ZC9_4","039_9_4","ZEC","9","4","4","Ki si Āpo ikaro nanchiw tabo warawaraya no nya Tiro, kan abohen na sanchiw bīleg naya do tāw. As iyanchiw nya syodad, ki sosohan nanchi a payahbeken. ");
INSERT INTO ivb_vpl VALUES ("ZC9_5","039_9_5","ZEC","9","5","5","No Askelon, paybinakel nanchi do kaboya na sya. As do kaboya nanchi sya no syodad no Gaza, ki matotook anchi. As aran do Ekron mabo nanchiw namnama na. As mabonchi no Gaza iyaw āri na, as apabanchiw omyan do Askelon. ");
INSERT INTO ivb_vpl VALUES ("ZC9_6","039_9_6","ZEC","9","6","6","Masagesagel dananchi a gan-ganaet omyan do Asdod, as pachipandahen ko naw pangas dan nya Pilisteo. ");
INSERT INTO ivb_vpl VALUES ("ZC9_7","039_9_7","ZEC","9","7","7","Sodiben konchiw maraya a karni do dangoy da mana kadwan a mabaywan a mākan do payawan no nyepen da. As tabonchi a makalāsat, ki mayparin a tawo ko, kan akma dana sanchiw asa kapartīdos do tribo no Joda. Masaw siranchiw taga Ekron, ki mayparin sanchi a tawo ko a akma siras sīgod saw a Jeboseo do Jerosalem. ");
INSERT INTO ivb_vpl VALUES ("ZC9_8","039_9_8","ZEC","9","8","8","Gwardyaan konchiw naybahayan kwaya tan abanchiw makasākop a soldādo. Palobōsan ko pa sabaw mangidadanes saya so tawotawo ko saya, ta sichangori, nāw ko na sa chichiban. ");
INSERT INTO ivb_vpl VALUES ("ZC9_9","039_9_9","ZEC","9","9","9","Iyoltimo nyo kasoyot nyo, inyo a tawotawo no Sion. On, pangagagay nyo ragsak nyo, inyo a tawotawo do Jerosalem! Chiban nyo, kangay dyinyo no āri nyowaya. Iya, ki malinteg kan myan dyaw kaisalakānan, ki mapakombaba kan nakasakay do orbon no asno. ");
INSERT INTO ivb_vpl VALUES ("ZC9_10","039_9_10","ZEC","9","10","10","Pakarohen konchi do Israel iyaw pachigobat saw a karison a goyōden kabalyo, kan ikaro konchiw kabalyo saw a pachigobat do Jerosalem, kan mararayaw sanchiw bai saw a pachigobat. Machikapya anchiw āri nyo dyirad nasnasyon saw. As no itorayan na, ki sakōpen nanchi yapod tāw a mandad matarek a tāw, as kan yapod oksong a Oprates a mandad pachipandan no tana. ");
INSERT INTO ivb_vpl VALUES ("ZC9_11","039_9_11","ZEC","9","11","11","Binata dana ni ĀPO a kāna, “Maynamot do nakapachitōlag ko dyinyo a nasilyowan so raya no naidāton a animal, wayawayaan ko sanchiw tawotawo nyo saw a akmas nabahodaw do bobon a abos ranom. ");
INSERT INTO ivb_vpl VALUES ("ZC9_12","039_9_12","ZEC","9","12","12","Maybidi kamo do yanan a abos kaparoparwan, inyo a nabahod a myan so namnama. Sichangori, ibahey ko dyinyo a paypirwahen ko a itoroh dyinyo bindisyon a pamabidi ko so tabo nakalidyat nyo. ");
INSERT INTO ivb_vpl VALUES ("ZC9_13","039_9_13","ZEC","9","13","13","Osaren ko Joda kan Israel a pinakabai no soldādo. Osaren ko sanchiw mahahakay do Sion a pinakaispada a machigobat dyirad mahahakay no Gresya.” ");
INSERT INTO ivb_vpl VALUES ("ZC9_14","039_9_14","ZEC","9","14","14","Magparang anchi si ĀPO do tohos do yanan dan tawotawo na, kan gomilap anchi a akmay kimat bai na saw. Si ĀPO a DYOS dananchiw magtrompita, as kan mayam anchi a machirayay do bagyo a yapo do abagātan. ");
INSERT INTO ivb_vpl VALUES ("ZC9_15","039_9_15","ZEC","9","15","15","Si ĀPO anchi a Manakabalin mangaywan so tawotawo na, as kan dimanen da sanchiw kabōsor da. Akma sanchiw nabok a mangengey do paggogobatan, as kan pawyogen danchiw raya dan kabōsor da. On, moyog anchi a akmas rayaw no maidāton do hapot no altar a yapo do palanggana. ");
INSERT INTO ivb_vpl VALUES ("ZC9_16","039_9_16","ZEC","9","16","16","Anchan marapit nawri a araw, isalākan sanchi ni ĀPO tawotawo na akmas parinen magpaspastor dyirad arban saw a karniro na. Komnyaknyay sanchi do tana na a akmas mapapateg saw a bato a naipadket do korona. ");
INSERT INTO ivb_vpl VALUES ("ZC9_17","039_9_17","ZEC","9","17","17","Ay, taywara anchi a mabīleg kaganay kan kapintas da. Iyaw kāro no trigo kan arak, ki mangpayit anchi so maychakatotobo. ");
INSERT INTO ivb_vpl VALUES ("ZC10_1","039_10_1","ZEC","10","1","1","Akdawen nyo di ĀPO chimoy do chimpo no rayon. Ta si ĀPO, iyaw mamarin so konem. Iya, ki manoroh so chimoy do tawotawo kan mohamoha do bengkag a para do katayitayisa. ");
INSERT INTO ivb_vpl VALUES ("ZC10_2","039_10_2","ZEC","10","2","2","Mangalillaw saw didyosen. Siraw mangarobōob, mangparmata sas bayataw. Mangibahey sa so tayēnep da sa a palso. Manoroh sas pangahwahok a abos sirsirbi. Dawa, mapawaw saw tawotawo akmay karniro. Maidadanes sa do kabo no pastor da. ");
INSERT INTO ivb_vpl VALUES ("ZC10_3","039_10_3","ZEC","10","3","3","“Somdeb kasoli ko dyirad dawri a sinpapastor, kan dosāen ko saw nawri a magtotoray. Ta yaken a ĀPO a Manakabalin, ki aywanan ko arban ko a siraw tawotawo no Joda. Payparinen ko sanchi a akmas mabīleg saw a kabalyo do paggogobatan. ");
INSERT INTO ivb_vpl VALUES ("ZC10_4","039_10_4","ZEC","10","4","4","Yaponchi do Joda iyaw bato a panoli. Yaponchi daw parey no tolda, yapo pa dyaw bai a para gobat, kan kāda magtoray. ");
INSERT INTO ivb_vpl VALUES ("ZC10_5","039_10_5","ZEC","10","5","5","Mayparin sanchi a mabibīleg a tawotawo a mangpitapita siras kabōsor da do hota do kalsāda. Maynamot ta si ĀPO, ki myan dyira, machigobat sanchi kan paksyaten da sanchiw kabōsor daw a nakakabalyo. ");
INSERT INTO ivb_vpl VALUES ("ZC10_6","039_10_6","ZEC","10","6","6","“Payiten konchiw tawotawo no Joda, kan isalākan ko sanchiw Israelita Pabidyen ko sanchi a isabat maynamot ta chāsi ko sa. Akma ko na sanchiw dya inpoha, ta yaken ĀPO a Dyos da as kan atbayen ko dasal da. ");
INSERT INTO ivb_vpl VALUES ("ZC10_7","039_10_7","ZEC","10","7","7","Siranchiw tawotawo no Israel, ki mayit sanchi a akmay soldādo, kan masoyot sanchi a akmas tawotawo saw a nakaynom so palek. Maboya danchin anak da sayaw nya kan chasoyot da; magragsak sanchi maynamot do pinarin naya ni ĀPO. ");
INSERT INTO ivb_vpl VALUES ("ZC10_8","039_10_8","ZEC","10","8","8","“Tawagan ko sanchi, as kakpeh ko sira. Sigorādo a isalākan ko sanchi, as kan pārohen ko sanchi a akmas sigodaw a kāro da. ");
INSERT INTO ivb_vpl VALUES ("ZC10_9","039_10_9","ZEC","10","9","9","Aran pinaychawpit ko sa do nasnasyon saya, alit na, manakem da yaken do mateng saya tana. Sira kan anak da saw, ki makalāsat sanchi, as kan maybidi sanchi. ");
INSERT INTO ivb_vpl VALUES ("ZC10_10","039_10_10","ZEC","10","10","10","Isabat ko sanchi a mirwa a yapo do Egipto kan do Asirya, kan paomyanen ko na sanchi do bokod da tana. On, pagyanen ko sanchi do tana a Gilead kan do Lebanon mandad kapnon intīro a tana do tawotawo ko. ");
INSERT INTO ivb_vpl VALUES ("ZC10_11","039_10_11","ZEC","10","11","11","Anchan mamtang sa do tāw no lidyat, yaken a ĀPO abāken konchiw kelsang saw no tāw, as kan mayachan anchiw kensad naw no oksong a Nile. Iyaw pangas no Asirya, ki mapabodis anchi as mabonchi no Egipto kapagtoray na. ");
INSERT INTO ivb_vpl VALUES ("ZC10_12","039_10_12","ZEC","10","12","12","Payiten ko sanchiw tawotawo ko. Magdāyaw kan magtongpal sanchi dyaken.” Nyaw inchirin ni ĀPO. ");
INSERT INTO ivb_vpl VALUES ("ZC11_1","039_11_1","ZEC","11","1","1","Iwangan mo saw pantaw mo, mo Lebanon tan temtemen san apoy kayokayo mo a sidro. ");
INSERT INTO ivb_vpl VALUES ("ZC11_2","039_11_2","ZEC","11","2","2","Magdongdong-aw kamo, inyo a kayokayo a saleng, ta no kayokayo a sidro, ki nalba dana sa. On, siraw madayag saw a kayokayo, ki nararayaw dana sa. Magdongdong-aw kamo, inyo a mapapateg a kayokayo a logo do tana a Basan, ta nakayowan danaw matokpohaw a kakahasan! ");
INSERT INTO ivb_vpl VALUES ("ZC11_3","039_11_3","ZEC","11","3","3","Adngeyen nyo maynyinaya katanyis dan magpaspastor, ta nabo danaw mabaknang a pasto da. Adngeyen nyo ngernger dayan lion, ta nararayaw danaw bongbongro saw do payahosongan do Jordan. ");
INSERT INTO ivb_vpl VALUES ("ZC11_4","039_11_4","ZEC","11","4","4","Nyaw binata no ĀPO a Dyos ko dyaken a kāna, “Mayparin ka pastor dan arban saya a nairanta dana maparti. ");
INSERT INTO ivb_vpl VALUES ("ZC11_5","039_11_5","ZEC","11","5","5","Partyen da san gomātangaw kan madōsa saba. Siraw akin dyiraw a mangilāko sira batahen da, ‘Madaydāyaw si ĀPO, mabaknang kami na!’ Aran siraw mismo a mangipastor dyira, chināsi da saba.” ");
INSERT INTO ivb_vpl VALUES ("ZC11_6","039_11_6","ZEC","11","6","6","Nyaw binata ni ĀPO a kāna, “Apabaw kāsi ko so tawotawo sa do tanaya. Paysin-iipsoken ko saw tawotawo, as ipaitoray ko sa dyirad magtotoray da. Rarayawen danchiw tana no nya sa magtotoray, kan isalākan ko saba yapo do kakamay dan mangpalidyat saya dyira.” ");
INSERT INTO ivb_vpl VALUES ("ZC11_7","039_11_7","ZEC","11","7","7","Siraw gomatgātangaw kan maglaklāko so karniro, tangdanan da yaken a si Sakaryas, kan nayparin ako a pastor dan karniro saw a nairanta a maparti. Nanghap ako so dadwa sarokod. Iyaw asaw, pinangaranan ko so Parābor. As iyaw asaw, ki Tonos, kan inaywanan ko arban saw. ");
INSERT INTO ivb_vpl VALUES ("ZC11_8","039_11_8","ZEC","11","8","8","Do irahem no asa kabohan, pinaksyat ko saw tatdo saw a magpaspastor. Chinaōma ko na sa kan inipsok da pa yaken. ");
INSERT INTO ivb_vpl VALUES ("ZC11_9","039_11_9","ZEC","11","9","9","Dawa, nyaw binata ko dyira a kon ko, “Yaken pabaw mangipastor dyinyo. An myan madiman bāli. An myan mararayaw bāli. An myan makalasat nolay ko sa maysintatabtab.” ");
INSERT INTO ivb_vpl VALUES ("ZC11_10","039_11_10","ZEC","11","10","10","Sinpangan na, inhap ko sarokod kwaw a pinangaranan ko so Parābor, as nakapotot ko sya tan pangipaboyan ko sya a rarayawen ni ĀPO nakapachitōlag na dyirad nasnasyon saw. ");
INSERT INTO ivb_vpl VALUES ("ZC11_11","039_11_11","ZEC","11","11","11","Dawa do dāwri a araw, naibabawi danaw nakapachitōlag kwaw dyira. Siraw gomatgātang saw kan maglaklāko so karniro, ki chiniban da yaken, kan chapatak da chirin a tabo ni ĀPO nyaya. ");
INSERT INTO ivb_vpl VALUES ("ZC11_12","039_11_12","ZEC","11","12","12","Sinpangan na, binata ko dyira a kon ko, “An kosto kan nainkalintegan dyinyo, itoroh nyo dyaken tangdan ko. Ki an engga, kapyahen nyo na.” Dawa, tinangdanan da yaken so tatdo a poho a plata a pirak. ");
INSERT INTO ivb_vpl VALUES ("ZC11_13","039_11_13","ZEC","11","13","13","Binata ni ĀPO dyaken a kāna, “Ipoha mo tatdwaya poho a plata a pirak do pangapyanaw so kwarta do Timplo.” Dawa, iyaw bata daya kakoskostwan na a bāyad ko inhap ko, as nakaipoha ko sya do pangapyanaw so kwarta do Timplo. ");
INSERT INTO ivb_vpl VALUES ("ZC11_14","039_11_14","ZEC","11","14","14","Sinpangan na, pinotot ko chadadwa naw a sarokod a napangaranan so Tōnos tan pangipaboyan ko sya a nararayaw tōnos no kapaylipos no Joda kan Israel. ");
INSERT INTO ivb_vpl VALUES ("ZC11_15","039_11_15","ZEC","11","15","15","Katayoka na binata dana ni ĀPO dyaken a kāna, “Changori, mirwa ka na magpaspastor, ki mayparin ka akmas sigodaw a abo so sirsirbi a pastor. ");
INSERT INTO ivb_vpl VALUES ("ZC11_16","039_11_16","ZEC","11","16","16","Ta mapatnek akonchi so asa magpaspastor so karniro ko a manginonolay sira do pakararayawan da, mana dya maychichwas so orbon mana dya mangāgas so mabigaran mana dya mamakan so masalon-at. Basbāli a michan siras matatabaw, as kakso nas koko daw tan masitsitan na tabo asi daw. ");
INSERT INTO ivb_vpl VALUES ("ZC11_17","039_11_17","ZEC","11","17","17","Kapakāsi pa no nawri a abos sirsirbi a pastor a mangaro so arban na! Matabtaban pakono tachay na kan mahawhaw pakono kawanan a mata na. Magsingkol pakono intīro a tachay na, kan magbolding pakono do kawanan a mata na!” ");
INSERT INTO ivb_vpl VALUES ("ZC12_1","039_12_1","ZEC","12","1","1","Nyaw minsahi a maynamot do Israel a inpakatoneng ni ĀPO. On, nya binata ni Āpo a namolay so hanyit, namarswa so lōbong, kan nanoroh so byay do tawo a kāna, ");
INSERT INTO ivb_vpl VALUES ("ZC12_2","039_12_2","ZEC","12","2","2","“Payparinen konchiw Jerosalem a akmay nairoyoy a palek a pangbōk siras nasnasyon do omdibonaw. Anchan lakoben danchiw Jerosalem, ki mairaman Joda. ");
INSERT INTO ivb_vpl VALUES ("ZC12_3","039_12_3","ZEC","12","3","3","Ki do dāwrinchi a araw, payparinen konchiw Jerosalem a akmay lāyit a dya mahodyihodyi. No tabo a mangpādas a omhodyi sya, tod a maynyinan. Ki aran komwan, kāsan danchi no tabo nasyon saya do tanaya a raoten. ");
INSERT INTO ivb_vpl VALUES ("ZC12_4","039_12_4","ZEC","12","4","4","Do dāwrinchi a araw, itopak konchiw kabakel do kabalyo da saw, kan panganyawen ko sanchiw nakasakayaw. Bantayan konchiw tawotawo no Joda, ki pagbolseken ko sanchi a tabo kabalyo dan kabōsor da saw. ");
INSERT INTO ivb_vpl VALUES ("ZC12_5","039_12_5","ZEC","12","5","5","Do dāwri, batahen danchi no partīdos no Joda do aktokto da a kon da, ‘Siraw tawotawo no Dyos a omyan do Jerosalem, ki mayit sa maynamot ta si ĀPO a Manakabalin Dyos da.’ ");
INSERT INTO ivb_vpl VALUES ("ZC12_6","039_12_6","ZEC","12","6","6","“Do dāwrinchi a araw, payparinen ko sanchiw partīdos no Joda a akmay ahoten do nawpo a irotong mana akmay somdesdeb a paysohwan do kaparayan a naynoy so dāwa. Patawsen da sanchi a tabo tawotawo saw do omdibon daw, ki mabdibdis sabanchiw tawotawo saw a omyan do Jerosalem. ");
INSERT INTO ivb_vpl VALUES ("ZC12_7","039_12_7","ZEC","12","7","7","“Yaken si ĀPO isalākan konchi a manmanma siraw myan do kadwan a yanayanan do Joda sakbay no syodad a Jerosalem tan iyaw dāyawaya no kapotōtan ni Dabid kan siraw omyan saya do Jerosalem, ki matwatohos aba kan iyaw dāyaw no Joda. ");
INSERT INTO ivb_vpl VALUES ("ZC12_8","039_12_8","ZEC","12","8","8","Do dāwrinchi a araw, yaken a ĀPO, ki aywanan ko sanchiw omyan do Jerosalem as aran iyaw kakakapsotanaw dyira, ki mayparin a mayit a akmas Āri Dabid. Siraw kapotōtan saya ni Dabid, ki mangipangōlo dyira a akmas Anghilaw ni ĀPO. On, akmaw Dyos a mismo. ");
INSERT INTO ivb_vpl VALUES ("ZC12_9","039_12_9","ZEC","12","9","9","Do dāwrinchi a araw, rarayawen konchiw kāda nasyon a makey a mangraot so Jerosalem. ");
INSERT INTO ivb_vpl VALUES ("ZC12_10","039_12_10","ZEC","12","10","10","“Apnohen konchiw kapotōtan ni Dabid kan no tawotawo a omyan do Jerosalem so ispirito no kāsisyen kan kapaydasal. Chiban danchi yaken a iyaw binono daw, kan tanyisan danchi yaken a akmas katanyis daw so moyboh a anak a nadiman. Magdongdong-aw sanchi so taywaras kaynyin a akmas kapagdongdong-aw daw no tawotawo so nadiman a matoneng a anak da. ");
INSERT INTO ivb_vpl VALUES ("ZC12_11","039_12_11","ZEC","12","11","11","Do dāwrinchi a araw, taywara anchiw kapagdongdong-aw do Jerosalem akmas kapagdongdong-aw do Hadad Rimmon do tanapaw no Megiddo. ");
INSERT INTO ivb_vpl VALUES ("ZC12_12","039_12_12","ZEC","12","12","14","Kādanchi a partīdos do dawri a tana, ki magdongdong-aw sa a sira lang. As siraw mahahakay, ki magdongdong-aw sa a machitarek dyirad mababakes saw. Iyaw partīdos a yapod kapotōtan Āri Dabid, iyaw partīdos a yapod kapotōtan Natan, iyaw partīdos a yapod kapotōtan Levi, iyaw partīdos a yapod kapotōtan Semei, kan tabo kadwan saw a partīdos, ki magdongdong-aw sa a sira lang.” ");
INSERT INTO ivb_vpl VALUES ("ZC13_1","039_13_1","ZEC","13","1","1","Binata ni ĀPO a Manakabalin a kāna, “Do dāwrinchi a araw, maywangan anchiw akbod a nāw na moyog a para dyirad kapotōtan saya ni Dabid kan tawotawo saya a omyan do Jerosalem. Iyaw nya akbod, ki mangdalos sira do gatos da kan kalapos da. ");
INSERT INTO ivb_vpl VALUES ("ZC13_2","039_13_2","ZEC","13","2","2","“Do dāwrinchi a araw, abohen konchiw ngaran dan didyosen saw a yapo do dawri a tana a Joda tan apabanchiw makanakem so ngaran da. Paksyaten ko sanchiw sinan propīta saw kan ispirito no malapos. ");
INSERT INTO ivb_vpl VALUES ("ZC13_3","039_13_3","ZEC","13","3","3","An myan sanchiw magparang a propīta, batahen danchi no mismwaw a āmang kan ānang na a kon da, ‘Machita madiman ka, ta nangibahey kas bayataw do ngaran ni ĀPO.’ On, an mangipadto, ki siranchiw mismwaw a inyapwan naw, mangbagkong sya. ");
INSERT INTO ivb_vpl VALUES ("ZC13_4","039_13_4","ZEC","13","4","4","“Do dāwrinchi a araw, kāda propīta, ki iyasnek nanchiw parmata na a ipadto. Apabanchiw maylaylay so makersang a laylay no propīta tan makaallilaw. ");
INSERT INTO ivb_vpl VALUES ("ZC13_5","039_13_5","ZEC","13","5","5","Basbāli a ilibak nanchi a kāna, ‘Propīta kwaba. Asa kwaw a homakahakaw, ta yapo pad kadēkey ko a nawriw paybibyayan ko.’ ");
INSERT INTO ivb_vpl VALUES ("ZC13_6","039_13_6","ZEC","13","6","6","As an myan anchiw mangyahes, ‘Na, āngo saw bigar sayan barōkong mo?’ batahen nanchi a kāna, ‘Nahap kwaw do bahayaw no sīt ko saw.’” ");
INSERT INTO ivb_vpl VALUES ("ZC13_7","039_13_7","ZEC","13","7","7","Nyaw batahen ni ĀPO a Manakabalin a kāna, “Mayokay ka, imo a ispada, as kadarop mos magpaspastor kwaya iyaw masingedaya dyaken!” “Dimanen mo tan maychawpit saw karnirwaya. Daropen ko sanchiw orbon a karniro.” ");
INSERT INTO ivb_vpl VALUES ("ZC13_8","039_13_8","ZEC","13","8","8","Tinongtong ni ĀPO a binata a kāna, “Do intīrwaw a tana, dadwa anchi a apagkatlo a tawotawo madiman, as asa dananchi a apagkatlo matokos.” ");
INSERT INTO ivb_vpl VALUES ("ZC13_9","039_13_9","ZEC","13","9","9","“Parahanen ko sanchi do apoy apagkatlwaw tan madalosan sa a akmas kapanyipowaw so pirak kan balitok. Tawagan danchiw ngaran ko, as kan atbayen ko sanchi. Ibahey konchi a sira, ki tawotawo ko, kan ibahey danchi a kon da, ‘Si ĀPO, ki Dyos namen.’” ");
INSERT INTO ivb_vpl VALUES ("ZC14_1","039_14_1","ZEC","14","1","1","Īto danaw araw a kapangokom ni ĀPO. As iyanchiw Jerosalem, ki masamsaman anchi, kan iyaw masamsam daw, ki bingbingāyen danchi do salapen nyo. ");
INSERT INTO ivb_vpl VALUES ("ZC14_2","039_14_2","ZEC","14","2","2","Ta si ĀPO, ki akpehen nanchiw tabo nasnasyon a manggobat so Jerosalem. Abāken danchiw syodadaw, samsaman da sanchiw bahabahay saw, as kan ramesen da sanchiw mababakes saw. Kagodwa danchi no tawotawo saw, maakaw. Ki no kadwan dyira, matokos sanchi do syodadaw. ");
INSERT INTO ivb_vpl VALUES ("ZC14_3","039_14_3","ZEC","14","3","3","Sinpangan na, mangay anchi si ĀPO a manggobat so nawri sa nasnasyon akmas nakapachigobat naw do nakarahan. ");
INSERT INTO ivb_vpl VALUES ("ZC14_4","039_14_4","ZEC","14","4","4","Do dāwrichi a araw, maytēnek anchi si ĀPO do Tokon a Olibo a myan do dayāenaw no Jerosalem. Sinpangan na, mayakchid anchiw Tokonaw a Olibo a yapod dāya a magpalāod kan mamarin so marahawa payahosongan. Iyanchiw kakchid naw no tokonaw, ki magpaammyānan as iyaw kakchid naw, ki magpaabagātan. ");
INSERT INTO ivb_vpl VALUES ("ZC14_5","039_14_5","ZEC","14","5","5","Magtālaw kamonchi a magbalsot do payahosonganaya a machipanda do Asal. On, magtālaw kamonchi a akma siras kapoonan nyo saw do nakapagin-ginedaw do chimpo ni Āri Ossias do Joda. Sinpangan na, mangay anchi si ĀPO a Dyos ko kontodo tabo anghilis naw. ");
INSERT INTO ivb_vpl VALUES ("ZC14_6","039_14_6","ZEC","14","6","6","Anchan marapit nawri a araw, apabanchiw sedang, kahanebneb mana apon a mayparin a yilo. ");
INSERT INTO ivb_vpl VALUES ("ZC14_7","039_14_7","ZEC","14","7","7","Machitatārek anchiw nawri a araw a si ĀPO lang makapatak. Abaw maraw mana mahep, ki do oras a mahep myan anchiw sedang. ");
INSERT INTO ivb_vpl VALUES ("ZC14_8","039_14_8","ZEC","14","8","8","Anchan mangay nawri a araw, sibibyay anchi a ranom moyog a mohtot a yapo do Jerosalem. Iyaw godwa naw moyog do Nadiman a Tāw. As iyaw kagodwa naw, moyog a komwan do Mediterranean a Tāw. Nāw nanchi a moyog a aran do rayon kan do ammyan. ");
INSERT INTO ivb_vpl VALUES ("ZC14_9","039_14_9","ZEC","14","9","9","As si ĀPO, ki mayparin anchi a Āri do intīro a lōbong. Magdaydāyaw anchiw katayitayisa dya a iya lang Dyos, as kan iyanchi lang ngaran naw bigbigen da. ");
INSERT INTO ivb_vpl VALUES ("ZC14_10","039_14_10","ZEC","14","10","10","Malantag dananchiw tabo tanaya do omdibon Jerosalem, makayapo do Geba do ammyānan no Joda mandad Rimon do abagātan no Jerosalem. Ki nāw na matwatohos Jerosalem kan tana saw do omdibon naw. Makarapit anchiw syodad makayapo do Rowanganaw ni Benhamin a mandad Rowangan no Sōli a naytēnekan sigodaw a rowangan, kan makayapo do Pagwanawanan ni Hananel a mandad pangatsanaw so obas a dyira no āri. ");
INSERT INTO ivb_vpl VALUES ("ZC14_11","039_14_11","ZEC","14","11","11","Omyan sanchiw tawotawo saw do Jerosalem, ta apabanchiw pakararayawan a mapaybiybinakel dyira. ");
INSERT INTO ivb_vpl VALUES ("ZC14_12","039_14_12","ZEC","14","12","12","Manoroh anchi si ĀPO so makamwamomo a ganyit do tabo nasyon saw a nanggobat so Jerosalem. Mahta anchiw asi da a aran myan sa pa sitetēnek. Masaw a mahta anchiw mata da do bahay naya. As iyaw rida da, ki mahta anchi do dangoy da. ");
INSERT INTO ivb_vpl VALUES ("ZC14_13","039_14_13","ZEC","14","13","13","Do dāwrinchi a araw, itoroh anchi ni ĀPO rakoh a kāmo kan kapaychawaw do tawotawo. Tan komwan kāda asa a tawo, ki tiliwen naw katangked naw kan maydiman sa. ");
INSERT INTO ivb_vpl VALUES ("ZC14_14","039_14_14","ZEC","14","14","14","Machiggobat sanchiw tawotawo no Joda a mangisakit so Jerosalem. Iyanchiw kinabaknang da saw no tabo myan saw do omdibon a nasnasyon, ki akpehen da sanchiw ārwaw a balitok, pirak kan ayowayob da. ");
INSERT INTO ivb_vpl VALUES ("ZC14_15","039_14_15","ZEC","14","15","15","Parihonchi a makamwamomo a ganyit mangay do kabalyo, molo, kamilyo, asno, kan siraw tabo animal saw do kampo daw no kabōsor. ");
INSERT INTO ivb_vpl VALUES ("ZC14_16","039_14_16","ZEC","14","16","16","Sinpangan na, siraw tabo kabōsoraw a nakalāsat a yapod tābo nasnasyon saw a nachigobat do Jerosalem, tinawen anchi a somonget sa do Jerosalem. On, mangay sanchi a magdaydāyaw di Āri a iyaw ĀPO a Manakabalin kan silibraren danchiw Pistaw no Kapaychabengbengbeng. ");
INSERT INTO ivb_vpl VALUES ("ZC14_17","039_14_17","ZEC","14","17","17","An myan saw tawotawo a yapod nasnasyon a dya somonget do Jerosalem tan mangay a magdāyaw di Āri a ĀPO a Manakabalin, machimoy abanchi do tana daw. ");
INSERT INTO ivb_vpl VALUES ("ZC14_18","039_14_18","ZEC","14","18","18","As an maskeh saw taga Egipto saw a somonget a mangay a mangsilibrar so Pista no Kapaychabengbengbeng, machimoy abanchi do tana daw. Mangay anchi dyiraw machipariho a ganyit do itoroh saw ni ĀPO do kāda nasyon a maskeh a mangay. ");
INSERT INTO ivb_vpl VALUES ("ZC14_19","039_14_19","ZEC","14","19","19","Iyanchiw nyaw dōsa do Egipto kan do tabo a nasnasyon a maskeh a somonget a mangsilibrar so Pistaw no Kapaychabengbengbeng. ");
INSERT INTO ivb_vpl VALUES ("ZC14_20","039_14_20","ZEC","14","20","20","Do dāwrichi a araw, aran siraw dēdekey saw a pātit a pangbisti so olodan do kabalyo saw, ki maitolas anchiw, “Naidāton para di ĀPO.” As siraw banga saw do Timplo, ki akma dana sanchis masantwan saw a sabak do salapen no altar. ");
INSERT INTO ivb_vpl VALUES ("ZC14_21","039_14_21","ZEC","14","21","21","Kāda banga do Jerosalem kan do Joda, ki mapatarek anchi a para do kapagdāyaw di ĀPO a Manakabalin. Siraw tawo saw a mangidāton, ki osaren da sanchiw banga saw a pamakbwalan so asi no dāton da saw. Do dāwrichi a araw, apabanchiw maglaklāko do Timplo ni ĀPO a Manakabalin.");
INSERT INTO ivb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iyaw nyaya, ki pakatonngan so kapoonan ni Jeso-Kristo a yapod kapotōtan ni Āri Dabid a kapotōtan ni Abraham. ");
INSERT INTO ivb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Siraw kapotōtan saya a somniknan di Abraham a nandad Dabid, ki siraw nya: Si Abraham, ki āmang ni Isaak. As si Isaak, ki āmang ni Jakob. As si Jakob, ki āmang ni Joda, magraman dyirad kakakteh na saw. ");
INSERT INTO ivb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","As no somarono, ki sa Pares kan kakteh naw a si Sera a anak da Joda kan Tamar. Siraw kapotōtan a somniknan di Pares, ki si Esron a āmang ni Aram. ");
INSERT INTO ivb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","As si Aram, ki āmang ni Aminadab. As si Aminadab, ki āmang ni Naason. As si Naason, ki iyaw āmang ni Salmon. ");
INSERT INTO ivb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","As si Salmon, ki āmang ni Boas, as kan iyaw ānang ni Boas, ki si Rahab. Binaket ni Boas si Roth, as kan si Obed anak da. As si Obed, ki āmang ni Jesse. ");
INSERT INTO ivb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","As si Jesse, ki āmang ni Āri Dabid. Sinpangan na, naipōtot ni Dabid si Solomon do baketaw ni Orias. ");
INSERT INTO ivb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","As si Solomon, ki āmang ni Rehoboam. As si Rehoboam, ki āmang ni Abias. As si Abias, ki āmang ni Assa. ");
INSERT INTO ivb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","As si Assa, ki āmang ni Jehosapat. As si Jehosapat, ki āmang ni Joram. As si Joram, ki iyaw kapoonan ni Ossias. ");
INSERT INTO ivb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","As si Ossias, ki āmang ni Jotam. As si Jotam, ki āmang ni Ahas. As si Ahas, ki āmang ni Hesekias. ");
INSERT INTO ivb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","As si Hesekias, ki iyaw āmang ni Manases. As si Manases, ki āmang ni Amon. As si Amon, ki āmang ni Josias. ");
INSERT INTO ivb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","As si Josias, ki āpong da Jekonias kan siraw kakakteh naw a mahakay. Iya danaw nyaw chimpwaw a nakaadipen dan taga Babilonya siras Israelita saw, as nakahap da sira do tana da. ");
INSERT INTO ivb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ranan nakaadipen daw do Babilonya, naipōtot ni Jekonias si Salatiel, kan Salatiel, ki si Serobbabel. ");
INSERT INTO ivb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","As si Serobbabel, ki āmang ni Abiod. As si Abiod, ki āmang ni Eliakim. As si Eliakim, ki āmang ni Asor. ");
INSERT INTO ivb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Si Asor, ki āmang ni Sadok. As si Sadok, ki āmang ni Akim. As si Akim, ki āmang ni Eliod. ");
INSERT INTO ivb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","As si Eliod, ki āmang ni Eleasar. As si Eleasar, ki āmang ni Matan. As si Matan, ki āmang ni Jakob. ");
INSERT INTO ivb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","As si Jakob, ki āmang ni Jose a kabahay ni Maria, as kan si Maria danaw ānangaw ni Jesos a iyaw natawagan naya so Kristo. ");
INSERT INTO ivb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Dawa, myan saw asa poho kan apat a kapotōtan a yapod Abraham nandad Āri Dabid. As masaw a asa poho kan apat a kapotōtan nakayapo di Dabid a nandad nakahap daw no taga Babilonya saw siras Israelitaw. As asa poho kan apat a kapotōtan nakayapo do nakapakaro daw a nangay do Babilonya a nandad nakayanak danan Kristo. ");
INSERT INTO ivb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","No pakatonngan nakayanak ni Jeso-Kristo, ki komwan: Si Maria, ki naitolag a maikabahay di Jose a nobyo na. Ki sakbay a naysin-asngen sa, ki natonngan da a mabogi dana sawen si Maria a maynamot do panakabalin no Ispirito Santo. ");
INSERT INTO ivb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ki maynamot ta malinteg a tawo si Jose, inplano na pasyayen si Maria a nobya na a akmas naikeddengaw do dadakay dan Jodyo saw. Ki aran komwan, alit na chakey naba masnesnekan do salapen dan tawotawo. Dawa, inranta na pasyayen so matayo. ");
INSERT INTO ivb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ki do kayan naw a mangiktokto an paypanghen na, napaboyaw asa anghil ni Āpo do tayēnep na, kan binata na dya a kāna, “Jose a kapotōtan ni Āri Dabid, mamo kaba omkabahay si Maria a nobya mo, ta kaparin Masantwan a Ispirito nakabogi naw. ");
INSERT INTO ivb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Iyanak nanchiw asa mahakay, ki pangaranan monchis Jesos maynamot ta isalākan na sanchiw tawotawo na do gatogatos da.” ");
INSERT INTO ivb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Naparin nyaya tabo tan matongpal inpaibaheyaw ni Āpo Dyos do asaw a propīta na a kāna, ");
INSERT INTO ivb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Manginaw anchiw asa balāsang a birhin, as kan iyanak nanchiw asa mahakay, ki mapangaranan nanchis Immanyowel.” No chakey na batahen, ki “Myan dana dyaten Dyos.” ");
INSERT INTO ivb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ki do nakayokay danaw ni Jose, ki pinarin naw binataw no anghilaw ni Āpo dya, kan inkasar nas Maria. ");
INSERT INTO ivb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ki sinalisalid nabas Maria a nandad nakayanak danaw no anak na a mahakay, as pinangaranan ni Jose so Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Do nakayanak danaw ni Jesos do idi a Betlehem do Jodya do kapagāri ni Herodes, myan nawara do Jerosalem a mamasirib a mahahakay yapo do matatarek saw a nasyon do dāya a makapatak so pangancharan a maboya da do bitohen. ");
INSERT INTO ivb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","As no inyahes da, ki “Dino paro a yanan nakayanakan āri daw no Jodyo? Ta naboya namen bitohen naw a domada a pangilasinan so nakayanak narana. Dawa, cha kami dya tan mangay kami a magdaydayaw dya.” ");
INSERT INTO ivb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ki do nakadamagaw ni Āri Herodes so nawri, nakamikamya paba. As aran siraw tabo tawotawowaw do Jerosalem, ki mananawa sa. ");
INSERT INTO ivb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Dawa, inpatawag san Āri Herodes tabo saw matotohosaw a papadi kan siraw mangnanawowaw so linteg, as nakaiyahes na sya dyira an dino kono yanan kaiyanakanaya no Kristwaya. ");
INSERT INTO ivb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ki inatbay da a kon da, “Do Jodya, do idyaw a Betlehem, ta nawri abawriw naitolasaw do tolas no propīta a kāna no Dyos: ");
INSERT INTO ivb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Imo Betlehem do tana a Jodya, sinsinan kaba a idi do Jodya, ta imonchiw pakayapwan asa pangolo a mapawnot siras tawotawo ko saw a Israelita.’” ");
INSERT INTO ivb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Sinpangan na, tinawagan san Āri Herodes so malimed masisirib saw a mahahakay a yapod dāya, as kan natonngan na dyira an kāngo nakapagparang no bitohenaw do nakadāmo daw a nakaboya sya. ");
INSERT INTO ivb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Sinpangan na, tinoboy na sad Betlehem, as nakaibilin na sya dyira a kāna, “Yay nyo a kapyāhen a chichwasen adekeyaw ah, ta anchan madongso nyo, ki yangay nyo a ipakatoneng dyaken tan aran yaken, ki mangay akonchi a magdayaw dya.” ");
INSERT INTO ivb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Do nakadngey daw so nawri a binata na, nayam sa. Ki do kayan daranaw do rarahan, naboya daranaw bitohenaw a napaboya dyira do kayan da paw do dāya. Dawa, taywara a soyot da a nakaboya sya. Iyaw bitohenaw napawnot dyira, kan nangay a nagsardeng do anmwaw no adekeyaw. ");
INSERT INTO ivb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Do nakapakarapit daranaw do Betlehem, somindep sad bahayaw a yanan dan may-ānangaw a sa Maria kan Jesos. Ki do nakaboya daw so adekeyaw, naydogod sa a nagdaydayaw dya, as nakapahtot da siras rigalo da saw a balitok, insinso, kan mabalor a bangbanglo a mayngaran so mirra, as nakaitoroh da sya dya. ");
INSERT INTO ivb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ki do nakapaybidi daranaw do sigod a tana da, matarek danaw nayaman da, ta natayēnep da a binata no Dyos a dyi dana sa maybidi di Āri Herodes. ");
INSERT INTO ivb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Do nakakaro daranaw no mamasirib saw, myan asa anghil ni Āpo a napaboya di Jose do tayēnep na, kan binata no anghilaya dya a kāna, “Mo Jose, maybangon ka, ta yangay mo saw may-ānangaya do Egipto, kan omyan kamo daw, ah, mandad kaibahey ko sya mayadis kamo, ta chichwasen Herodes adekeyaya a dimanen.” ");
INSERT INTO ivb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Dawa, nanyeng a naybangon si Jose do dawri a ahep, as nakaiyangay na siras may-ānangaya do Egipto. ");
INSERT INTO ivb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Minyan sa daw a nandad nakadiman Āri Herodes. Naparin nyaya tan matongpal danaw intolasaw no propīta a binata no Dyos a kāna, “Tinawagan ko anak ko a komaro do Egipto.” ");
INSERT INTO ivb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ki do nakadlawaw ni Āri Herodes a sinikapan dan masisirib saw, oltimo nakasoli na. Dawa, inpadiman na sa tabo adedekey a mahahakay do Betlehem magraman dyirad masngen saw a idiidi do omdibonaw. Inpadiman na saw somiknan do dadwa so tawen a maypābodis, sigon do napatakan na saw a nayanak a adekey do nakapaboyaw no bitohenaw dyirad mamasirib saw a yapod dāya. ");
INSERT INTO ivb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Dawa, naparin inpadtwaw ni propīta Jeremyas a kāna, ");
INSERT INTO ivb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Do Rama a tana, madngey kapagdongdong-aw kan makalidliday a katanyis, ta tanyisanayan Rakel anak na saw. Ari a tomanyis kan chakey nabaw mahwahok, ta nadiman dana sa tabo anak naw.” ");
INSERT INTO ivb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ki do nakadimanaw ni Āri Herodes, napaboyaw no asa anghil ni Āpo di Jose do Egipto do tayēnep na. ");
INSERT INTO ivb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Binata no anghilaw dya a kāna, “Oy, Jose! Maybangon ka na, ta paybidi mo na saw may-ānangaya do tana dan kapotōtan Israel, ta nadiman dana saw mangplanwaw a mangdiman so adekeyaya.” ");
INSERT INTO ivb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","As dawa, naybangon si Jose a nanghap siras may-ānangaw, as nakasabat darana do tana no Israel. ");
INSERT INTO ivb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ki do nakatoneng naw sya a si Arkelaos a anak ni Āri Herodes nachitadi a āri do probinsya no Jodya, namo sa Jose a omyan daw. Sinpangan na, maynamot do tayēnep ni Jose, myan danaw pakatoneng a yapod Dyos a mangay sad probinsya no Galilya. ");
INSERT INTO ivb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nangay sa a minyan do idi a Nasaret do Galilya tan matongpal binata daw no propīta saw a kon da, “Matawagan nanchi so Nasareno.” ");
INSERT INTO ivb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ki do nakapakahabas no awan, nangay si Juan a Mamonyag a do ranranswaw do let-ang do Jodya a nangaskasaba siras tawotawo saw a nangay a nangadngey sya. ");
INSERT INTO ivb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Binatabata na dyira a kāna, “Magbabāwi kamo dyirad gatogatos nyo maynamot ta īto danaw kapagtoray no Dyos.” ");
INSERT INTO ivb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Iyaw nyaya Juan binataw ni propīta Isayas do kaychowa pa a kāna, “Iyanchiw mangingengengey do let-ang a mangibahebahey so nya a kāna, ‘Mamarin kamo so rarahan a para do Āpo, kan paysonongen nyo pakono ayaman na.’” ");
INSERT INTO ivb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ki si Juan, naylaylay so naparinaw do boboh no kamilyo, kan iyaw barikis na, ki tod a nahathat a lalat. Kabaga kan tagapolot no yokan iyaw no chinabyay na. ");
INSERT INTO ivb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ki aran komwan, alit na nangay sa dyaw reprep saw a tawotawo a yapo do Jerosalem kan yapo do intīro a probinsya do Jodya as kan aran sira pa tabo idiidi saw do maybitaw do oksong no Jordan. ");
INSERT INTO ivb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Inpodno daw gatogatos da, as kan binonyagan sa tabon Juan do oksongaw a mayngaran so Jordan. ");
INSERT INTO ivb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ki do kaboyaw ni Juan siras aro saw a Parisyo kan Sadosyo a mangay a magpabonyag dya, binata na dyira a kāna, “Inyo a anak no karasaen! Sino nakabata dyinyo a maditditan nyo ītwaya a soli ni Āpo Dyos an nabonyagan kamo? ");
INSERT INTO ivb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nawri pakono ipaboya nyo do kaparin nyo a nagbabāwi kamo do gatogatos nyo, ah! ");
INSERT INTO ivb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Chasaray nyo abaw kabata nyowaya sya a, ‘Ara, ta kapoonan namen si simna Abraham,’ ta ibahey ko dyinyo a maparin ni Āpo Dyos a payparinen bato saya dya a kapotōtan ni Abraham! ");
INSERT INTO ivb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Annadan nyo okom no Dyos a akmay wasay a nakasagāna dana panongeh so kayowaw a dya omsi so maganay, as kapayongeb na syad apoy. ");
INSERT INTO ivb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","An yaken, ki bonyagan koynyo so ranom a pakaboyan sya a nagbabāwi kamo na, ki myan anchiw manawnawdyi kan yaken a matortoray kan yaken, as kan maikari akwaba a manahabit so tokap na. Bonyagan nanchinyo so Ispirito Santo kan apoy. ");
INSERT INTO ivb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ari dyaw akmay igaw a paytahpan na tan mapaytawa naw hopes kan nakabyasaw. Iyaw matahpanaw, kapyahen nanchi do agāmangaw. As iyaw naytahpanaw, sosohan nas apoy a abos pandan.” ");
INSERT INTO ivb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Sinpangan na, nawaras Jesos do dawri a Oksong a Jordan a yapo do Galilya tan mangay a magpabonyag di Juan. ");
INSERT INTO ivb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ki chakey ni Juan a baywan, kan binata na dya a kāna, “Yaken pakono rebbeng na bonyagan mo ah! Ki āngo ta mangay ka dyaken? Ay samna!” ");
INSERT INTO ivb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ki initbay ni Jesos dya a kāna, “Nolay mo a maparin nya sichangori ah, ta maganay an tongpalen taw tabo pinanggep no Dyos.” Dawa, nakey si Juan. ");
INSERT INTO ivb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Do nakabonyag naranaw sya, nanyeng a nakarayas Jesos. Ki do dawri, insigīda naywangan hanyit, as kan naboya naw Ispirito no Dyos naypabodis a akmay boyit kan nangay a domnina dya. ");
INSERT INTO ivb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Sinpangan na, myan timek a yapod hanyit a nakabata so nya a kāna, “Iyaw nyaw Anak ko a oyod kos chadaw. Oltimo a mahwahok ako a maynamot dya.” ");
INSERT INTO ivb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Do katayoka nabonyagan Jesos, pinalongo no Ispirito Santo do naychabongbongrwaw a let-ang tan sooten Satanas. ");
INSERT INTO ivb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Do kayan naw daw so apat a poho a karaw kan apat a poho a kahep, ki polos a dya komninan si Jesos, as kan do dawri, naptengan. ");
INSERT INTO ivb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Do dawri, nangay si Sairo, as nakabata na sya a kāna, “An oyod a imo Anak no Dyos, mandaran mo paw nya saya bato a mayparin a tinapay.” ");
INSERT INTO ivb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ki initbay ni Jesos a kāna, “Naitolas do Masantwan a Tolas a kāna, ‘Tinapay aba lang manoroh so byay no tawotawo, an dya tabo chirin a inchirin no Dyos.’” ");
INSERT INTO ivb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Sinpangan na, inyangay ni Satanas si Jesos do Jerosalem iyaw masantwanaw a syodad, kan pinaytēnek na si Jesos do katotohosanaw a yanan do Timplo do Jerosalem, ");
INSERT INTO ivb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","as nakabata na sya di Jesos a kāna, “An oyod a imo Anak no Dyos, gomtos ka pa, ta nawryaw naitolasaw do Masantwan a Tolas a kāna, ‘Mandaran sanchi no Dyos anghilis na saw a omaywan dyimo, kan siranchiw mangigpet dyimo tan dyi sa madonggyaran bato kokod mwaya.’” ");
INSERT INTO ivb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ki tinbay ni Jesos a kāna, “Naon, ki naitolas paw do Masantwan a Tolas a, ‘Sooten mwabaw Āpo a Dyos mo.’” ");
INSERT INTO ivb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sinpangan na, pinalongo ni Satanas si Jesos do taywaraw so katohos a tokon, as nakaiparang na dya so tabo saw a pagpagaryan do lobongaya kan aran iyaw no kabibīleg da. ");
INSERT INTO ivb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Binata nad Jesos a kāna, “Ayket na! Itoroh ko sanchi a tabo dyimo nyaya an basta maydogod kad salapen kwaya kan magdayaw ka dyaken.” ");
INSERT INTO ivb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Sinpangan na, tinbay ni Jesos a kāna, “Komaro ka dyam Satanas! Taywaran dya naitolas do Masantwan a Tolas a ‘Pagdayawan mo si Āpo a Dyos mo, kan iya lang pagsirbyan mo’?” ");
INSERT INTO ivb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Sinpangan na, komnaros Satanas. Ki do dawri, nawara saw anghil saw, as kan sinirbyan das Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Do nakadamagaw ni Jesos a nabahod dana si Juan a Mamonyag, naybidi dana do Galilya. ");
INSERT INTO ivb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ki minyan aba do idi Nasaret, an dya do Kapernaom niyanan na, iyaw asaw a idi do payisaw no Minanga a Galilya, no partis do tana do Sabolon kan Neptali. ");
INSERT INTO ivb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Naparin nyaya tan matongpal inpadtwaw ni propīta Isayas a kāna, ");
INSERT INTO ivb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Siraw tawotawo saw do tana da no kapotōtan Sabolon kan Neptali do payisaw no minanga, kan sira do kabtang no Jordan, as kan sira do yanan dan Dya-Jodyo, ");
INSERT INTO ivb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","siraw tawotawo saya, ki aran nahay dana sa do masari a kapangtokto a kominwan do nakararayawan da, ki myan dyira sichangoriw no kasesedangan a soho.” ");
INSERT INTO ivb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nakayapo do dawri, insiknan Jesos nangasaba a kāna, “Magbabāwi kamo do gatogatos nyo, ta īto danaw kapagtoray no Dyos.” ");
INSERT INTO ivb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Do naypisa, do kayamaw ni Jesos do payisaw no Minanga a Galilya, naboya na saw dadwa saw a maykakteh a mangalap a sa Simon a mangaranan so Pedro as kan kakteh na a si Andres. Myan sa magpakat so sigay. ");
INSERT INTO ivb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ki binata ni Jesos dyira a kāna, “Onotan nyo yaken, kan payparinen koynyo a magkalap so tawo.” ");
INSERT INTO ivb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Do nakadngey daw sya, nanyeng da kinarwan sigay da saw, as nakawnot da dya. ");
INSERT INTO ivb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Do dawri, tinongtong ni Jesos nayam, ki naboya na saw dadwa paw a mangalap a sa Santiago kan kakteh na a si Juan a siraw anakaw ni Sebedeo. Myan sa may-aāmang do abang daw a madama mapaysoysonong so sigay da saw, kan tinawagan san Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nanyeng da kinarwan si āmang da kan abang daw, as nakawnot dad Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Do dawri, minidibidi si Jesos do tabo a yanan do probinsya a Galilya a nangnanawo do sinagoga da saw daw kan inkasaba naw Maganay a Dāmag a maynamot do pagtorayan no Dyos. Pinapya na paw tabo matatarek saw a ganyit kan kaynyin dan tawotawo. ");
INSERT INTO ivb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Dawa, nagdinamag si Jesos do tabo tana dan taga Sirya, as kan inyangay da dya no tawotawo saw tabo saw a matatarek so ganyit kan kaynyin, siraw linoganan saw no marahet a ispirito, komsiksiw saw, kan paralitiko saw, ki pinapya na san Jesos a tabo. ");
INSERT INTO ivb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Minonot sa dyaw reprep saw a tawotawo a yapo do probinsya saw a Galilya, Dekapolis, Jodya, do Jerosalem, kan siraw kadwan saw a idiidi do kabtangaw no Oksong a Jordan. ");
INSERT INTO ivb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Do kaboyaw ni Āpo Jesos siras reprep saw a tawotawo, somnonget do asaw a tokon do dawri. Naydisna kan nachisngen sa dyaw nanawhen naw. ");
INSERT INTO ivb_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Dawriw nangnanawan na sira. Binata na a kāna, ");
INSERT INTO ivb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Magasat saw mangrawat a mapobri sa do naispiritwan, ta mairaman sanchi do pagtorayan ni Āpo Dyos do hanyit. ");
INSERT INTO ivb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Magasat saw magmamayo a maynamot do gatos da, ta ahwahoken sanchi no Dyos. ");
INSERT INTO ivb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Magasat saw mapakombabaw, ta dyira danchiw inkari no Dyos dyirad tawotawo na. ");
INSERT INTO ivb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Magasat saw malakamaw a mamarin so chakeyaw no Dyos, ta mapnek sanchi so kinalinteg. ");
INSERT INTO ivb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Magasat saw māsisyen, ta chāsi na sanchi no Dyos. ");
INSERT INTO ivb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Magasat pa saw masingpetaw a nāw da iktokto chakey no Dyos, ta maboya danchiw Dyos. ");
INSERT INTO ivb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Magasat saw mapaychachapya, ta ibidang na sanchi no Dyos a anak na. ");
INSERT INTO ivb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Magasat saw maidadanes maynamot do katongpal das chakey no Dyos, ta mairaman sanchi do pagtorayan no Dyos do hanyit. ");
INSERT INTO ivb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“On, magasat kamo an asnesnekan, iroromen, kan parahrahten daynyo a maynamot do kawnot nyo dyaken. ");
INSERT INTO ivb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Charagsak nyo kasoyot nyo, ta rakkoh anchiw gon-gona nyo do hanyit, ta nairaman kamo do nakaparinan dan propīta saw a nanmanma kan inyo.” ");
INSERT INTO ivb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Tinongtong ni Jesos a kāna, “Mayarig kamo do asin a mapaganay so tabay no ichan, ta mapaganay kamo so kapangtokto dan tawotawo. Ki an tomnabang danaw asin, maybidi pawriw payit naw? Apabaw sirbi na do aran āngo, an dyi dana maipoha a matokatokapan no tawotawo. ");
INSERT INTO ivb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Masaw a inyo akmay soho no lobong a mangsedang so pangtoktwan tawotawo do lobongaya. Maiyarig kamo pa do asa syodad a napatnek do totok no tokon a maboya tabon tawotawo. ");
INSERT INTO ivb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Pasgedan nyoriw soho, as katohong nyo syas bakag? Engga, basbāli a pangayen nyo do nairantaw a pakadatokan na tan masohwan tabo do irahemaw no bahay. ");
INSERT INTO ivb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Komwan pakono parinen nyo do salapen tawotawo tan maboya daw maganay saw a kaparin nyo kan idaydāyaw daw Dyos a Āmang nyod hanyit.” ");
INSERT INTO ivb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Binata pa ni Jesos a kāna, “Iktokto nyo aba yangay kwa pakarohen Lintegaw ni Moyses kan intolas daw no propīta kaychowa. Yay kwaba pakarohen, an dya mangay ako a mangtongpal so chakey naw a batahen. ");
INSERT INTO ivb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","No batahen kwaya dyinyo, ki oyod. Do kayan payan tana kan hanyit, ki abanchi a polos aran kanyinyidan a chirin mana asa katokel no linteg a mainonolay, ta gagāngay a matongpal lintegaya. ");
INSERT INTO ivb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Dawa, aran sino a manginonolay so aran dēkey a yapo dya saya a bilbilin, mana iyaw mangnanawo siras tawotawo tan inonolay da, ki maibidang anchi a kabobodisan so saad do pagtorayan no Dyos. Akma saw a aran sino a mangtongpal kan mangnanawo pa so panganohden na do dya linteg, iyanchiw matohos do pagtorayan no Dyos. ");
INSERT INTO ivb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ta nyaw bata ko dyinyo: Magannad kamo, ta makasdep kamo abanchi a polos do pagtorayan Dyos do hanyit, an dya rakorakoh paw katongpal nyos chakeyaw no Dyos kan no pariparinen daya no Parisyo kan siraw mangnanawo sayas linteg.” ");
INSERT INTO ivb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Nadngey nyo na a naibahey dyirad tawotawo do kaychowa pa a ‘Mangdiman kaba, ta aran sino a mangdiman, ki atbayen na anchan maidarom.’ ");
INSERT INTO ivb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ki sichangori, ibahey ko dyinyo a aran sino a makasoli do rarayay na, ki maidarom anchi do pangokoman. Mana aran sino a makabata do rarayay na a, ‘Abos sirsirbi,’ ki maiparawat anchi do katotohosan a pangokoman. Masaw a aran sino a makabata do rarayay na a, ‘Maymaha ka,’ ki dosāen nanchi no Dyos do impyirno. ");
INSERT INTO ivb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Dawa, an myan dāton mo do Dyos do Timplo, as manakem mo a myan kaynyin aktokto no rarayay mwaw dyimo, ");
INSERT INTO ivb_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","bidinen mo dāton mwaw do salapenaw no altar, as yangay mo pa panmahen machikapya dya sakbay a mangidāton ka. ");
INSERT INTO ivb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“An myan makey a mangidarom dyimo, maganaganay an sakbay a maidarom ka do pangokoman, ki belan mo mangay a machikapya dya an myan paw oras mo. On, ta āngo nchan iparawat naymo do okom, as iparawat naymo no okomaw do polis a mamosek dyimo do bahodan. ");
INSERT INTO ivb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ibahey ko na dyinyo oyod a mabongtot kanchi daw a mandad kaitarkas mo a tabo so ōtang mo.” ");
INSERT INTO ivb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Nadngey nyo na a naibilin do kaychowa pa a, ‘Machikamalala kaba.’ ");
INSERT INTO ivb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ki changori, ibahey ko dyinyo oyod. Aran sino a mangmolmolagat so asa mabakes, as panggep na a laposan, ki nakagatos dana do kapachikamalala do irahem no aktokto na. ");
INSERT INTO ivb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Dawa, an iyaw makanawan a mata mo pakayapwan kapaygatos mo, hawhawen mo, as kaipoha mo sya. Maganaganay an abo asa do inawan mo kan komplitwaw so inawan a maitapwak do impyirno. ");
INSERT INTO ivb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Akma saw an iyaw makanawan a tanoro mo pakayapwan kapaygatos mo, akteben mo, as kaipoha mo sya. Maganaganay an pokol ka kan komplitwaw so inawan a mangay do impyirno.” ");
INSERT INTO ivb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Naibilin pa do kaychowa a aran sino a mapasyay so baket na, machita a torohan naw baket naw so tolas a pakaboyan a sira, ki naysyay sa. ");
INSERT INTO ivb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ki sichangori, ibahey ko dyinyo a no aran sino a mapasyay so baket na, malaksid an machikamalalaw mabakesaw, as nangabahay nawri a baket na so matarek, iyaw napaygatos sya kan iyaw somnaronwaw a kinabahay na do kapachikamalala.” ");
INSERT INTO ivb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Asa pa, nadngey nyo pa a naibilin do kaychowa dyirad kapoonan ta saw a, ‘Tadyichokodan nyo abaw kari nyo, basbāli a tongpalen nyo tabo inkari nyo do Dyos.’ ");
INSERT INTO ivb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ki ibahey ko dyinyo a magkari kamo aba polos. Pagkari nyo abaw hanyit, ta nawriw pagtorayan no Dyos, ");
INSERT INTO ivb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","mana pagkari nyo abaw tana, ta nawriw tokatokapan naw, mana do Jerosalem, ta dawriw syodad no kabibilēgan a Āri. ");
INSERT INTO ivb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Asa pa, pagkari nyo abaw mismo a oho nyo, maynamot ta maparin nyo aba mapanyidak aran asa lang a boboh nyo, as kan mapaybidi nyo aba a akmas gagāngay naw. ");
INSERT INTO ivb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Tod nyo a ibahey ‘On’ mana ‘Engga,’ ta an rapan nyo nawri, ki yapo dana di Satanas.” ");
INSERT INTO ivb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Nadngey nyo pa a naibilin kaychowaw a, ‘An hawhawen daw mata mo, machita mahawhaw mata da. An pakarohen daw nyipen mo, machita mapakaro nyipen da.’ ");
INSERT INTO ivb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ki sichangori, ibahey ko dyinyo a bahsen nyo abaw aran sino a mangranggas dyinyo. An myan mamitpit so makanawan a pisnyi nyo, ki nonolay nyo a pabahsan nad bīt. ");
INSERT INTO ivb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Masaw an myan mangidarom dyinyo maynamot do kakey na manghap so kekeh nyo, nonolay nyo a pachahap na paw kekeh nyowaw. ");
INSERT INTO ivb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","As aran sino a mamilit dyinyo a rarayayan nyo do asa kakilomitro, ki tongtongen nyo a rarayayan do aran dadwa kakilomitro. ");
INSERT INTO ivb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","An myan mangdaw dyinyo, torohan nyo. Masaw a an myan mamohod dyinyo, pabohodan nyo.” ");
INSERT INTO ivb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Nadngey nyo paw naibilinaw do kaychowa a, ‘Chadaw nyo saw sit nyo, ki ipsok nyo saw kabosor nyo.’ ");
INSERT INTO ivb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ki nyaw ibahey ko dyinyo: Chadaw nyo saw kabosor nyo, as paydasal nyo saw mangidadanes dyinyo ");
INSERT INTO ivb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","tan anak naynyo ni Āmang nyo do hanyit. Parinen nyo komwan, ta kāliten na torohan so sedang no araw mamarin so marahet kan mamarin so maganay, as kan kāliten naw kapanoroh nas chimoy dyirad malinteg kan dya malinteg. ");
INSERT INTO ivb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ta an sira lang madaw dyinyo chadaw nyo, aryoriw gon-gona nyo? Taywaran dya komwan parinen dan magsingsingiraw so bwis a sigod a ipsok nyo? ");
INSERT INTO ivb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","As aryoriw nachitarkan nyo dyira an sira lang kakakteh nyo saw sarsaritaen nyo? Ta aran siraw dya manganohed do Dyos, ki parinen daw komwan. ");
INSERT INTO ivb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Dawa, machita a abo pakono pagkorāngan nyo a akmas kabwayan pagkorāngan Āmang nyod hanyit.” ");
INSERT INTO ivb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Tinongtong ni Jesos naychirin a kāna, “Magannad kamo, ah! Ipangas nyo abaw maganay a kaparin nyo do salapen dan tawotawo tan dayāwen daynyo. Ta an komwan parinen nyo, abanchiw rawaten nyo a gon-gona di Āmang nyod hanyit. ");
INSERT INTO ivb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Dawa, an maglimos kamo, kalyaken nyo aba pagpangas a akmas pariparinen daw no maysinsīsingpet saw do irahem no sinagoga da sa kan do kalkalsāda. On, parinen daw komwan tan idāyaw da san tawotawo. Ki ibahey ko dyinyo oyod a siraw mamarin so komwan, ki narawat daranaw komplito a gon-gona da. ");
INSERT INTO ivb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ki an maglimos kamo, parinen nyo a dyi nyo a polos a ibahey a aran iyaw masingedaw a sit nyo ");
INSERT INTO ivb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","tan abo makapapatak. Ta si Āmang nyod hanyit a makaboya so naitayowaw a pariparinen nyo, ki gon-gonaan nanchinyo.” ");
INSERT INTO ivb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Masaw, an maydasal kamo, tahatahan nyo sabaw maysinsīsingpet saw. Chadaw daw maytēnek a maydaydasal do irahem no sinagoga da saw kan naychorosan dan rarahan tan maboya da san tawotawo. Ibahey ko dyinyo oyod a rinawat daranaw gon-gona dan komwan saw a tawotawo. ");
INSERT INTO ivb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ki an maydasal kamo, somdep kamo do kwarto nyo, as kaneb nyo sya, as kan maydasal kamo di Āmang nyo a dyi nyo a maboya. Ta si Āmang nyod hanyit a makaboya so naitaywaw a pariparinen nyo, ki gon-gonaan nanchi inyo. ");
INSERT INTO ivb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“As iyaw kapaydasal nyo, tod kamo aba maychirin so aro kan mananaro a kapaychirin a ari nyo pad iniktokto chakey na batahen. On, parinen nyo abaw a akmas parinen daw no Dya-Jodyo, ta kanarohen daw dasal da, ta batahen da a madngey no Dyos a maynamot do kanaro no dasal da, ki engga. ");
INSERT INTO ivb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Dawa, tahatahan nyo saba, ta sakbay a maydasal kamo, ki sigod a chapapatak ni Āmang nyod hanyit machita nyo. ");
INSERT INTO ivb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Dawa, an maydasal kamo, komwan batahen nyo: ‘Āmang namen do hanyit, madaydayaw iyaw masantwan a ngaran mo. ");
INSERT INTO ivb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mangay pakono kapagtoray mo, as kan maparin pakono chakey mod tanaya a akmas kaparin nad hanyit. ");
INSERT INTO ivb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Torohan mo pa yamen so kanen namen do kararaw, ");
INSERT INTO ivb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","as kan pakawanen mo yamen do naygatosan namen dyimo a akmas kapangpakawan namen siras nakagatos dyamen. ");
INSERT INTO ivb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Palobosan mwaba yamen a masday do pakasolisogan, basbāli a paditchanen mo yamen do marahet!’ ");
INSERT INTO ivb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“An pakawanen nyo saw nakagatos dyinyo, pakawanen nanchinyo ni Āmang nyo do hanyit. ");
INSERT INTO ivb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ki an dyi nyo sa pakawanen nakagatos dyinyo, syimpri, pakawanen nabaynyo ni Āmang nyod hanyit do gatogatos nyo.” ");
INSERT INTO ivb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“An magayonar kamo, ipaboya nyo aba a maliday kapagropropa nyo a akmas pariparinen daw no maysinsīsingpet saw, ta ipaboya dad tawotawo a akmaw makakāsi sa tan mapatakan da a magayonar sa. Ibahey ko dyinyo oyod a siraw mamarin so komwan, ki narawat daranaw komplito a gon-gona da. ");
INSERT INTO ivb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ki an inyo, an madama kamo pa magayonar, mayramon kamo, as soroden nyo boboh nyo a akmas dadakay nyo. ");
INSERT INTO ivb_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ta an komwan parinen nyo, abaw makatoneng so nakapagayonar nyo, malaksid di Āmang nyo do hanyit a dyi nyo a maboya. Ta si Āmang nyod hanyit a makaboya so naitayowaw a pariparinen nyo, ki gon-gonaan nanchinyo.” ");
INSERT INTO ivb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Mangpeh kamo abas warawara a kinabaknang nyod tanaya, ta iyaw myan do tanaya, ki ohden anchi, omrachinchi, kan matakaw anchi. ");
INSERT INTO ivb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Maganaganay an mangpeh kamo so kinabaknang nyonchi do hanyit. Ta do dawri, ki ohden paba, mana omrachi paba, as kan asdepen da paba takawen manakanakaw saw. ");
INSERT INTO ivb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ta an dino yanan hahawen nyo a kinabaknang, dawriw yanan aktokto nyo.” ");
INSERT INTO ivb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Iyaw mata, ki pinakasoho no inawan. Dawa, an maganay kapanyideb mo, masedang a tābo pangtoktwan mo kan inawan mo. ");
INSERT INTO ivb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ki an madiw kapanyideb mo, masari dana tābo inawan nyo. Dawa, no chakey na batahen, an maynana sariw myan do aktokto nyo, syimpri, taywara dana masariw byay nyo!” ");
INSERT INTO ivb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Abaw makapayrayay a magsirbi do dadwa a āmo, ta ipsok naw asaw, as chadaw naw asaw, mana dayawen naw asaw, as pachimadekeyan naw asaw. Masaw a maparin nyo aba pagsirbyan Dyos kan kinabaknang nyo.” ");
INSERT INTO ivb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ki tinongtong ni Jesos nangnanawo a kāna, “Nyaw paynamotan na a ibahey ko dyinyo a chabakel nyo abaw byay a maynamot do kanen kan inomen nyo, mana inawan nyo a maynamot do laylay nyo. Ta iyaw byay nyo, ki mapatpateg abawri kan isobo, as kan iyaw inawan nyo, ki mapatpateg abawri kan laylay? Syimpri! ");
INSERT INTO ivb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Chiban nyo pa saw manomanok. Maymoha kan magranyi sabaya, as kan abaw agāmang da a pangapyan das kanen da. Ki alit na pakanen san Āmang nyod hanyit. Taywaran dyi kamo a mapatpateg kan sira? ");
INSERT INTO ivb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Sino dana dyinyo makapanaro so byay na do asa kaoras a maynamot lang do nakabakel na? Polos! ");
INSERT INTO ivb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“As āngo ta pakariribokan nyo laylay nyo? Chiban nyo saw sabong saya a bakong an maypāngo kapaypararakoh da do katokotokonan saya. Asyo sa maytarabako, kan asyo sa mayrayirayit? ");
INSERT INTO ivb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ki chiban nyo pas Āri Solomon a kababaknangan an myan laylay na a mapinpintas pa kan siraw nya sabong? ");
INSERT INTO ivb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ki an laylayan san Āpo Dyos tametamek sayad lobongaya a magla sichangori kan kahayo nan delak a masosohan, inyo dananchiw dyi na malaylayan a masissisīta kamo a adayo kan siraw nya tamek? Oltimwaya kadēkey no kapanganohed nyo! ");
INSERT INTO ivb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“As dawa, mabakel kamo aba ah! Batahen nyo aba, ‘Namna! Dinonchiw panghapan namen so kanen namen, inomen namen, kan laylay namen?’ ");
INSERT INTO ivb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ta iyaw kapaychichwasaya so tabo nawri, iyaw chabalay dan dyi saya manganohed do Dyos. As dawa, tahatahan nyo saba, ta si Āmang nyod hanyit, ki chapatak na itoroh tabo machita nyo. ");
INSERT INTO ivb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ki nawri pakono manma chichwasen nyo pagtorayan no Dyos kan katongpal nyos chakey na tan tabo masisita saya machita nyo, ki itoroh na sanchi a tabo dyinyo. ");
INSERT INTO ivb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Dawa, mariribokan kamo aba an āngo nchiw kalidyatan nyo an delak. Panayahen nyo mabekas a somalap so kalidyatan a mangay do dawri a araw. Ta iyaw kalidyatan do asa karaw, ki makapnek dana, kan machita nyo paba rapan.” ");
INSERT INTO ivb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Okomen nyo abaw kapayngay nyo a tawo tan dyi naynyo a okomen no Dyos. ");
INSERT INTO ivb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ta an āngo no kapangokom nyo do kapayngay nyo a tawo, komwan anchiw kaokom nyo. Ta no rokod a osaren nyo do kapangokom nyo so kapayngay nyo a tawo, ki nawrinchiw pangrokod no Dyos dyinyo. ");
INSERT INTO ivb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Āngo ta dilawen mo akmay dedeng a podin do mata no kakteh mo, an dyi mo a madlaw a akmay toroso podin mo? ");
INSERT INTO ivb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","On, maypāngo kaibahey mo syad kakteh mwaw a, ‘Oy, palobosan mo pa yaken, ta pakarohen ko podin mwaya,’ an myan akmay toroso a podin no mismo a mata mo? ");
INSERT INTO ivb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Maysinsīsingpet kaya! Pakarohen mo pa manma iyaw akmayay toroso a podin mata mo tan masedang kapakaboya mo, as kapakaro mos podinaw no kakteh mwaw.” ");
INSERT INTO ivb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Sinpangan na, binata ni Jesos a kāna, “Itoroh nyo abad chito masantwan, ta āngo nchan lakatan daynyo a sonyiten. As masaw a itoroh nyo abaw kwarta nyo do bago, ta tod da lasalasagan. Komwan parinen da no maskeh saw a mangadngey so chirin Āpo Dyos.” ");
INSERT INTO ivb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Chaōma nyo abaw mangdaw do Dyos, ta syirto a itoroh nanchi dyinyo akdawen nyo. Chaōma nyo abaw maychichwas so machita nyo a yapo dya, ta sidongan nanchi inyo a omsarak sya. As chaōma nyo abaw magtoktok, ta iwangan nanchiw pantaw dyinyo. ");
INSERT INTO ivb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ta aran sino a mangdaw, matorohan anchi, as no maychichwas, ki makasarak anchi. Masaw, no aran sino a magtoktok, ki maiwangan anchiw pantaw dya. ");
INSERT INTO ivb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ta ari danawri dyinyo a āmang manoroh so bato do anak na an mangdaw so tinapay? ");
INSERT INTO ivb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Mana manoroh so marem an mangdaw so among? ");
INSERT INTO ivb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Inyo paya tawo a aros gatos, an chapatak nyo manoroh so maganay do anak nyo, mangamangay panchi si Āmang nyo do hanyit a manoroh so maganay dyirad mangdawaw dya! ");
INSERT INTO ivb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Dawa, iyaw chakey nyowaw do inawan nyo, ki nawriw parinen nyo do kapayngay nyo a tawo, ta nawri lang chakey na batahen Linteg ni Moyses kan intolas daw no propīta saw do kaychowa.” ");
INSERT INTO ivb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Somdep kamo do malopit a rowangan a asdepan do hanyit. Ta iyaw maydamnayaw kan marahawaw a rowangan, ki komwan do abos pandan a kararayawan, as kan aro saw makey a mayam daw. ");
INSERT INTO ivb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ki malopit rowangan, as kan malidyat paw ayaman a lomongo do abos pandan a byay. As dawa, tomayisa lang makadongso sya.” ");
INSERT INTO ivb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Magannad kamo dyirad sinan propīta saw, ta mangay sanchi a akmay oyod sa manganohed. On, malinay kapaychirin da tan batahen nyo a masingpet sa a akmay karniro. Ki no kaoyodan na, ki akma say maranggas a lobo. ");
INSERT INTO ivb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ta akmas kailasin mo an āngo kakayo na sigon do asyaw no nawri a kayo, komwan kaimangmang nyo so dadakay da do kaparin da. Ta ari danawriw hateng a nay-asi so obas, kan ari danawriw kwantong a nay-asi so asin igos? ");
INSERT INTO ivb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ta kāda maraboy a kayo, ki omsi so maganay. Masaw nahoto a kayo, syimpri, omsi so makwan. ");
INSERT INTO ivb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","An magla kayo, omsi abas makwan. Masaw a an narokop a kayo, omsi abas maganay. ");
INSERT INTO ivb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kāda kayo a dya omsi so maganay, ki matongeh, as kapayongeb na do apoy. ");
INSERT INTO ivb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Komwan kalasinan nyo siras sinan propīta saw a maynamot do kaparin daw a marahet!” ");
INSERT INTO ivb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Tabo abanchi a makabata dyaken so, ‘Āpo, Āpo,’ ki makasdep do pagtorayan no Dyos, an dya sira lang magtongpalaw do chakey ni Āmang ko do hanyit. ");
INSERT INTO ivb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ta anchan marapit kapangokom no Dyos, ki aro sanchiw makabata dyaken so, ‘Āpo, Āpo, maynamot do ngaran mo, taywaran dyi namen a inpakatoneng Maganay a Dāmag? As taywaran dyi namen sa pinaksyat marahet saw a ispirito maynamot do nakaosar namen so ngaran mo? Asa pa, maynamot pad ngaran mo, taywaran dyi kami a nakaparin so aro a milagro?’ ");
INSERT INTO ivb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ki batahen konchi dyira a kon ko, ‘Sino kamo? Chapatak ko abaya inyo. Komaro kamo dya, inyo a marahet so dadakay.’” ");
INSERT INTO ivb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“No aran sino a makadngey so chirinen kwaya as tongpalen na, ki akmas asaw a masirib a tawo a napatnek so bahay na do pinasaw a bato. ");
INSERT INTO ivb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","As do dawri, myan mawyas a chimoy, ayo, kan mayit a salawsaw a nanghorihoris so bahayaw. Ki aran komwan, polos a dya nalasa, ta maganay nakaisedsedan batwaw. ");
INSERT INTO ivb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ki no mangadngey so chirin kwaya as dyi na tongpalen, ki maipariho do salanga a tawo a napatnek so bahay na do kahmanayan tana. ");
INSERT INTO ivb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ta do kangayaw no mawyas a chimoy, ayo, kan mayit a salawsaw a nanghorihoris so bahayaw, ki nalasa kan makamwamomo nakalasa naw.” Nawri danaw binatan Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ki do katayokaw ni Jesos a nangibahey so tabo nyaya inanawo na, nasdaawan saw tawotawo saw do akmaya syay a kapangnanawo na. ");
INSERT INTO ivb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ta no kapangnanawo naw, ki myan toray na sigon do kapaychiychirin naw, kan akmaba siras mangnanawowaw so linteg. ");
INSERT INTO ivb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Do kawsokaw ni Jesos do tokonaw, ki aro saw tawotawo a minonot dya. ");
INSERT INTO ivb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ki nangay dyaw asaw a nagliproso, as nakapaydogod na do salapen naw, as nakabata na sya a kāna, “Āpo, an chakey mo a mapyan ako, masigorādo ko a maparin mo.” ");
INSERT INTO ivb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ki tinodah ni Jesos tatchay naw a sinalid, as nakabata na sya dya a kāna, “Naon, chakey ko. Mapyan ka na!” Ki nanyeng a napyan ganyit naw a liproso. ");
INSERT INTO ivb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Sinpangan na, binatan Jesos dya a kāna, “Ibahebahey mwabaw nya naparin dyimo do aran sino, ah, basbāli a nyeng ka mangay a mapaboyad padyaw tan sakangwan maboya na a napyan ka na. As katayoka no nawri, mangidāton ka so dāton mo a para do nakapakadalos mo a akmas inbilinaw ni Moyses do kaychowa pa a pangipaneknek mo do tawotawo a napyan ka na.” ");
INSERT INTO ivb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Do nakasabataw ni Jesos do Kapernaom, binayat no asa a kapitan no soldado saw a yapod Roma kan nangdaw di Jesos so sidong. ");
INSERT INTO ivb_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Binata nad Jesos a kāna, “Āpo, myan adipen kwaw do bahay a naparalitiko danaw, kan aryaw sichangori a taywara malidyatan.” ");
INSERT INTO ivb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ki binatan Jesos dya a kāna, “Yangay kwa pyahen.” ");
INSERT INTO ivb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ki initbay no kapitanaw a kāna, “Ay, mo Āpo, maikari akwaba mapasdep dyimo do bahay ko. Tod mo na lang a ibilin, ki mapyan anchiw adipen kwaw. ");
INSERT INTO ivb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ta aran yakenaw, ki adngeyen ko bilbilin no matwatohos kan yaken. Masaw dyirad soldado ko saw a itorayan ko a tongpalen daw ibahey ko dyira. An mangmandar ako so asa a, ‘Mangay!’ ki mangay. Do matarekaw, bilinen ko a, ‘May ka pa dya!’ ki tongpalen na. An ibilin ko do adipen ko a, ‘Parinen mo nya,’ parinen na. As dawa, nawriw itaha kwaya dyimo, mo Āpo.” ");
INSERT INTO ivb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Do nakadngeyaw sya ni Jesos, ki chinasdaaw naw kapitanaw, as nakabata nas nya dyirad tawotawo saw a minonot dya a kāna, “Ibahey ko dyinyo oyod. Ari ko pad nachichwasan dyinyo a Jodyo a kapotōtan Israel iyaw kapanganohed a akma syay so kayit. ");
INSERT INTO ivb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ibahey ko dyinyo a aro sanchiw Dya-Jodyo a yapod dāya kan laod a machisalap do kanan da simna Abraham, Isaak, Jakob do pagtorayan no Dyos do hanyit. ");
INSERT INTO ivb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ki siraw sigodaw a Jodyo a inplano no Dyos a mairaman do pagtorayan na, ki mapaksyat sanchi a mangay do mamansokelaw a kasarisaryan a yanan dan tomanyitanyis saw kan mayngaletnget a tawotawo do lidyat da.” ");
INSERT INTO ivb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ki do dawri, binatan Jesos do kapitanaw a kāna, “Sigi, somabat ka na, ta naparin danaw akmas kapanganohed mwaya.” Ki nanyeng do nawri lang a oras, ki napyan adipen naw no kapitanaw. ");
INSERT INTO ivb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Sinpangan na, do kangayaw ni Jesos do bahay ni Pedro, naboya naw katoganganaw ni Pedro a mabakes a naypoktad a maganyit a magbāra. ");
INSERT INTO ivb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Do dawri, sinalid ni Jesos tanorwaw no mabakesaya, ki nyeng na binawan. Naybangon kan nakangay dana nangidasar so kanen da Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ki do dawri a ahep, inyangay da san tawotawowaw di Jesos aro saw a sindep no marahet a ispirito kan siraw maganyit saw. Ki maynamot lang do toray no chirin na, pinaksyat naw aro saw a marahet a ispirito, as nakapapya na tabo siras maganyit saw. ");
INSERT INTO ivb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Pinarin naw komwan tan matongpal inpadtwaw ni propīta Isayas a kāna, “Iyaw mismo a mangisabhay so tabo lidyat kan ganyit ta tan mapakaro sa dyaten.” ");
INSERT INTO ivb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Do nakaboyaw ni Jesos siras reprep saw a tawotawo a omdibon dya, binata na dyirad nanawhen na saw a mamtang sad minangaw. ");
INSERT INTO ivb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ki do sakbayaw no kangay da, naypasngen dyaw asaw a mangnanawo so linteg, as nakabata na sya a kāna, “Maistro, monot ako dyimo a aran dino angayan mo.” ");
INSERT INTO ivb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Inatbay ni Jesos a kāna, “Myan abab a pakaychehan bolaw, as masaw a myan binahayan dan manomanok, ki abaw pakaychehan kan paynahahan ko a Tawo a Yapod Hanyit.” ");
INSERT INTO ivb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ki binatan asaw daw a nanawhen na a kāna, “Āpo, somabatak pa manma ah, ta yangay ko pa itabon si āmang ko.” ");
INSERT INTO ivb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","“Nolay mo na,” initbay ni Jesos dya, “ta siraw naibidang danaw a nadiman, sira danaw makatoneng a mangitabon so minatay. As imo, basta onotan mo yaken.” ");
INSERT INTO ivb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ki do dawri, somnakay sa Jesos kan siraw nanawhen naw. ");
INSERT INTO ivb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ki do kayan daranaw do almidyo, nyiknyinan a naypayit salawsaw kan naypararakoh iyaw kelsang, as kan makalo dana mapno abang daw. Ki do dawri, myan a makaycheh si Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","As dawa, yay da yinokay si Jesos, as nakabata da sya dya a kon da, “Mo Āpo, somidong ka ah, ta makey danaya maarinebneb abang taya! Ih, mahmes ta na!” ");
INSERT INTO ivb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ki binatan Jesos dyira a kāna, “Napangayan nyos katored nyo? Aysa! Kadēkey pan anohed nyo!” Ki do dawri, naybangon si Jesos, kan inmandar na do salawsawaw kan kelsangaw. Ki nanyeng a nangheteng kan taywara dana matalna. ");
INSERT INTO ivb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ki chinasdaaw da, as kan binatabata da, “Āngo katatawo no nyaya a aran salawsaw kan kelsang, ki manganohed sa dya?” ");
INSERT INTO ivb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Do nakapakabtang daw da Jesos do tana daw no tawotawo a Gadareno, ki binayat dan dadwa saw a mahakay a yapod aschip a pagtatanman. Siraw nya, ki sindep san marahet saw a ispirito, kan oltimo a tangsit da. Dawa, abaw makaitored a manghabas sira do dawri a rarahan. ");
INSERT INTO ivb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ki do kasngen daranaw di Jesos, nangngey sa, kan binata da dya a kon da, “Imo a Anak no Dyos, anghen mo yamen? Yangay mori yamen a dosāen sakbay no arawaw a naikeddeng?” ");
INSERT INTO ivb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ki iyaw midyowaw so mabawas dēkey dyira, myan daw asa matokpoh a arban a bago a maysaysabok. ");
INSERT INTO ivb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Dawa, nachikakaāsi saw marahetaw a ispirito di Jesos a kon da, “An paksyaten mo yamen, toboyen mo pa yamen a somdep do bago saya.” ");
INSERT INTO ivb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Ngay! Mangay kamo na,” binata ni Jesos. Ki do dawri, minohtot sa, as nakangay da a somindep dyirad bago saw. Sinpangan na, naychapayapayayo sa tābo arban saw no bago a nandad nakatapwak dad pangpangaw a nachinmo do minangaw, kan nahmes sa tabo bago saw. ");
INSERT INTO ivb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ki siraw mangonongaw siras nawri a bago, naychapayapayayo sa a nangay a nangibahebahey do tawotawo saw do idi da maynamot do tabo naparinaya kan naparinaw dyirad dadwaw a mahakay a sindep no marahet saw a ispirito. ");
INSERT INTO ivb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","As dawa, binayat dan tabo omidi saw daw si Jesos. Ki do nakaboya daw sya, ki chindaw da dya a komaro do logar daw. ");
INSERT INTO ivb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Do dawri, somnakay dana sa Jesos do abangaw, as nakapaybidi da do kabtangaw no minanga a mandad nakarapit narana do idi na. ");
INSERT INTO ivb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ki do dawri dana, myan saw nawara di Jesos a nangisiw so asaw a paralitiko a pinaypoktad dad pinarin daw a pakaychehan na a dohod. Ki do nakaboyaw ni Jesos so kapanganohed daw dya, binata nad paralitikwaw a kāna, “Payiten mo kapangtokto mom anak ko. Napakawan ka na do gatogatos mo.” ");
INSERT INTO ivb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ki do dawri, binata dan kadwan saw a mangnanawo so linteg do aktokto da, “Aysa! Maddiw nya tawo, ta tod naya dyābat si Āpo Dyos do kapachiyengay na so toray do Dyos!” ");
INSERT INTO ivb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ki maynamot ta chinapatak ni Jesos myanaw do aktokto da, binata na dyira a kāna, “Āngo ta mangtokto kamos marahet? ");
INSERT INTO ivb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Āngo maydaydamnay a batahen ko: ‘Napakawan ka na do gatos mo,’ mana ibahey kwa, ‘Maytēnek ka, as kayam mo na’? ");
INSERT INTO ivb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ki tan chapatak nyo a yaken a Tawo a Yapod Hanyit, ki myan toray ko do tanaya a mangpakawan so naygaygatos, paytēneken ko paralitikwaya.” Sinpangan na, binata nad paralitikwaw a kāna, “Maytēnek ka, as kakatkat mos nakaychehan mwaya, as kasabat mo na.” ");
INSERT INTO ivb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Do dawri, naytēnek paralitikwaw, as nakayam na a somabat do bahay na. ");
INSERT INTO ivb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Do nakaboya daw no tawotawo saw so nawri a naparin, nananawa sa, kan indaydāyaw da si Āpo Dyos, ta intoroh naw komwan a toray do tawo. ");
INSERT INTO ivb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Komnaros Jesos do dawri a yanan. Ki do kayam naw, naboya naw asaw a tawo a mayngaran so Matchew a asa magsingsingir so bwis a maydisna do opisina naw a pagsingsingiran na. Binata ni Jesos dya a kāna, “Ka pa dya! Pachisyayan mwaba yaken.” Nanyeng a naychakatkat si Matchew, as nakawnot na sya. ");
INSERT INTO ivb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Sinpangan na, do nakapachakanaw ni Jesos kan nanawhen na saw do bahayaw ni Matchew, aro saw nachihanghang dya a magsingsingir so bwis kan tawotawo saw a naibidang a aro so gatos. ");
INSERT INTO ivb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ki do nakaboya daw sya no kadwan saw a Parisyo a machihanghang sa Jesos dyira, inyahes da dyirad nanawhen na saw a kon da, “Āngo ta machihanghang maistro nyowaya dyirad magsingsingir saya so bwis kan dyirad naibidang saya a aros gatos?” ");
INSERT INTO ivb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ki nakadngeyaw sira ni Jesos, inpangarig na dyira a kāna, “Sirabaw masalon-at makachitas mangagas, an dya siraw maganyit. ");
INSERT INTO ivb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Yangay nyo a nanawhen chakeyaya batahen myanaya do Masantwan a Tolas a kāna, ‘Iyaw kāsisyen nyo do kapayngay nyo a tawo chakey no Dyos, kan iyabaw dāton nyowaw a masosohan.’ On, nangay akwaba mangrara so tawotawo saw a malinteg, an dya siraw myan so gatos.” ");
INSERT INTO ivb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Katayokan nawri, nangay sad Jesos nanawhen saw ni Juan a Mamonyag, as nakabata da sya dya a kon da, “Āngo ta magayonar kami kan siraw Parisyowaw, ki siraw nanawhen mwaya, ki enggaya?” ");
INSERT INTO ivb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ki tinbay san Jesos do pangarig a kāna, “Namna! Maparinawri a magmamayo tawo a naawis dana do kasaran, naten dana an myan paw nobyowaw do yanan daw? Ki īto araw a maikaro dyiraw nobyowaw, kan do dawrinchiw kapagayonar da.” ");
INSERT INTO ivb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Tinongtong ni Jesos nagpangarigan dyira a maynamot do adanaw kan bayo a nanawo a dya maparin a maysagel. Binata na dyira a kāna, “Abaw mangitakop so bayo a lamit do adan a laylay, ta komsen anchiw no naitakopaw, kan marohnwan piritaw no adanaw a laylay. ");
INSERT INTO ivb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Mana maparin aba pangayen mawnged a palek do adan a sopot a lalat. Ta an komwan, mabtak anchiw sopotaw, as madonchiw palek, as kan mararayaw anchiw sopotaw. On, machita mapangay mawnged a palek do bayo a sopot a lalat tan dya mado palekaw, as kan mararayaw abaw sopotaw.” ");
INSERT INTO ivb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Myan pa madama inanawo ni Jesos nyaya pangarig do nakangayaw no asaw a āpohen dan Jodyo saw. Naydogod do salapenaw ni Jesos, as nakabata na sya a kāna, “Kapaybitos paw no byay no anak kwaw a balasītang, mo Āpo. Ki pachiyangay mo pa saliden, kan syirto a mirwanchi a mabyay.” ");
INSERT INTO ivb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Do dawri, naytēnek si Jesos, as nakawnot nad magtorayaw. Aran siraw nanawhen naw, ki nangay sa. ");
INSERT INTO ivb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ki myan daw asa mabakes a malidyatan a nāw na marodit do asa poho dana kan dadwa katawen. Naypasngen do dyichodanaw ni Jesos, as nakasalid nas sayranaw no kekeh na. ");
INSERT INTO ivb_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ta no myan do aktokto na, ki nyaya: “Aran nawri lang masalid ko laylay naya, sigorādo a mapyan ako.” ");
INSERT INTO ivb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ki do nakasalid naw sya, nanyeng a minidit si Jesos. Ki do nakaboya naw sya, binata na dya a kāna, “Payiten mo kapangtokto mom balāsang ko, ta maynamot do nakapanganohed mwaya, ki napyan ka.” Ki do dawri a oras, insigīda a napyan danaw mabakesaw. ");
INSERT INTO ivb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Sinpangan na, do nakapakarapit daw da Jesos do bahayaw no magtorayaw, ki naboya na saw magpītwaw a magtokar an myan minatay, kan naboya na paw aro a tawotawo a magringringgor. ");
INSERT INTO ivb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ki do dawri, binata na dyira a kāna, “Mohtot kamo a tabo do bahayaya, ta nadiman abaw nya balasītang, ta tod a nakaycheh.” Ki chinamyeng das Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ki do nakahbot daranaw, somindep si Jesos do kwartwaw a yanan nadimanaw. Ki do nakarapit naw sya, inigpet naw tanorwaw no balasītangaw, as nakapaybangon na sya, ki nanyeng a naybangon a sibibyay. ");
INSERT INTO ivb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Iyaw nawri a naparin, ki nagwaras a dāmag do tabo omdibon saw a idiidi. ");
INSERT INTO ivb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ki do katayokaw no nawri, komnaro sa Jesos do dawri a yanan. Do kadama daw a mayam, myan saw dadwa minonot dya a mahahakay a bolsek, kan inngengey da dya a kon da, “Kapotōtan ni Āri Dabid, chāsim pa yamen!” ");
INSERT INTO ivb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ki do nakapakasdep danaw ni Jesos do bahayaw a yanan na, ki somindep saw bolsek saw. Do dawri, inyahes ni Jesos dyira a kāna, “Anohdan nyori a maparin koynyo a pakaboyahen?” Ki, “Naon mo Āpo ah,” kon da. ");
INSERT INTO ivb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Sinpangan na, sinalid ni Jesos mata daw, as nakabata na sya dyira a kāna, “Maparin nyaya akmas ninamnama nyowaya.” ");
INSERT INTO ivb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Do dawri, nakaboya dana sa, ta napya dana sa. Ki inmandar ni Jesos dyira a abo pakono pangibaheyan das nawri a naparin. ");
INSERT INTO ivb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ki do nakakaro daranaw do dawri, nāw da inpadpadāmag do tabo omdibon saw a idiidi iyaw maynamot di Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Do nakakaro daranaw no dadwa saya a mahahakay, ki myan pa saw nangyangay di Jesos so asa omel a mahakay a sindepan marahet a ispirito. ");
INSERT INTO ivb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ki do nakapaksyat danaw no marahetaw a ispirito, ki nakapaychirin danaw tawowaw. Chinasdaaw dan tawotawowaw, kan binata da a kon da, “Ari ta payad nakaboyas komwan so panakabalin do Israel.” ");
INSERT INTO ivb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ki binata dan Parisyo saw a kon da, “Ay! Iyayaw pangolo daw no dimonyo saw manorotoroh dya so panakabalin a mangpaksyat so marahet saya ispirito.” ");
INSERT INTO ivb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Do dawri, minidibidi si Jesos do tabo idiidi kan barbaryo a nangnanawo do sinagoga da saw daw, kan nangasaba so Maganay a Dāmag a maynamot do pagtorayan no Dyos, as kan nangpapya so tabo matatarek saw a ganyit kan kaynyin dan tawotawo. ");
INSERT INTO ivb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Taywaraw nakāsi ni Jesos siras tawotawo do nakaboya naw sira a pirmi sa mariribokan kan malidyatan, ta akma saw karniro a abo mangonong dyira. ");
INSERT INTO ivb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Sinpangan na, binata na dyirad nanawhen naw a kāna, “Arwayaw ranyen, ki taytayisa lang magranyi. ");
INSERT INTO ivb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","As dawa, akdawen nyo si Āpo a iyaw akin dyiraw so ranyen saya tan manoboy so arwaro pa a magranyi.” ");
INSERT INTO ivb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Do asa karaw, tinawagan san Jesos siraw asa poho saw kan dadwa nanawhen na, as nakaitoroh na dyira so toray da a mangpaksyat so marahet saw a ispirito kan iyaw kapangpapya so tabo matatarek saw a ganyit kan kaynyin. ");
INSERT INTO ivb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Siraw nyaw ngarangaran dan asa poho saya kan dadwa nanawhen: no manma, ki si Simon a mayngaran so Pedro, kan si Andres a kakteh na; kan siraw maykaktehaw a sa Santiago kan ādi na a si Juan a anak ni Sebedeo; ");
INSERT INTO ivb_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","sa Pilipi kan Bartolome; si Tomas kan si Matchew a magsingsingir so bwis; kan si Santiago a anak ni Alpeo, kan si Tadeo; ");
INSERT INTO ivb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","si Simon a mangispal so kaidyan na, kan Jodas a yapod Iskariote, iyaw nyaw nanglipotaw di Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Tinoboy san Jesos asa poho saya kan dadwa nanawhen na, kan inbilin na dyira a kāna, “Mangay kamo abad aran dino a idiidi dan Dya-Jodyo mana somdep kamo aba do aran āngo a idiidi da no Samaritano, ");
INSERT INTO ivb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","basbāli a mangay kamo lang dyirad rarayay ta saw a kapotōtan Israel a akmay nabo a karniro. ");
INSERT INTO ivb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","On, yangay nyo a ikasaba dyiraw nya: ‘Īto danaw kapagtoray no Dyos.’ ");
INSERT INTO ivb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pyahen nyo saw maganyit, pagongaren nyo saw nadiman, pyahen nyo saw nagliproso, as kan paksyaten nyo saw marahet a ispirito. Maynamot ta abo pinanadi nyos inanohdan nyowaya, ipatadi nyo abaw itoroh nyowaya dyira. ");
INSERT INTO ivb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ki mangyonot kamo abas so aran āngo a kita kwarta do bolsa nyo. ");
INSERT INTO ivb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Masaw a mangyonot kamo abas bayon nyo, mana pagsokatan nyo, mana risirba no tokap nyo, mana sarokod nyo, ta no maytarabakwaw, ki maikari a matorohan so kanen na. ");
INSERT INTO ivb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“An makarapit kamo do aran āngo a idi mana baryo, maychichwas kamo so makey a mangpadagos dyinyo. Omyan kamo daw a mandan komaro kamod dawri a yanan. ");
INSERT INTO ivb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","An somdep kamo do asa bahay, ki bindisyonan nyo sa a kon nyo a, ‘Dyos pakono manoroh so talna na dyinyo.’ ");
INSERT INTO ivb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ki an rawaten daynyo do dawri a bahay, tokosen nyo dyiraw inbahey nyowaw a talna da. Ki an dyi daynyo a rawaten, ki ibabāwi nyo. ");
INSERT INTO ivb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","“As an makarapit kamo do bahay mana idi a dya mangrawat mana dya mangadngey dyinyo, wakwaken nyo ahbek no kokod nyo, as kakaro nyo sira. ");
INSERT INTO ivb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","“Ibahey ko dyinyo oyod a iyaw idyaw a dya mangrawat dyinyo, ki malidyalidyat anchiw dosa dan tawotawo a omyan daw kan siraw yapo do idi saw a Sodoma kan Gomorra anchan araw a kapangdosa no Dyos.” ");
INSERT INTO ivb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Binata pan Jesos dyira, “Mangadngey kamo, ta toboyen koynyo a akma siras karniro saw do payayahatangan dan mararanggas saw a lobo. Dawa, makasikap kamo a akmay marem, ki masingpet kamo a akmay boyit. ");
INSERT INTO ivb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Magannad kamo dyirad tawotawo, ta tiliwen kan idarom danchinyo. Saplitan danchinyo do sinagoga da saw, ");
INSERT INTO ivb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","kan maidarom kamonchi do salapen dan magtotoray kan ar-āri maynamot do kawnot nyo dyaken. Ki iyanchiw nawriw gondaway nyo a mangipaneknek dyira kan siraw Dya-Jodyo so Maganay a Dāmag. ");
INSERT INTO ivb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ki do katiliw daw anchi dyinyo a idarom, mabakel kamo aba an maypāngonchiw kaikalintegan nyo so inawan nyo, mana chabakel nyo aba an āngo nchiw itbay nyo dyira. Do dawrinchi, matorohan kamonchi so ichirin nyo anchan marapit nawri a oras, ");
INSERT INTO ivb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ta inyo abanchiw maylililyakaw, an dya Ispirito ni Āmang nyo do hanyit manoroh so pabatahen nyo. ");
INSERT INTO ivb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Myan sanchiw tawotawo a mangipadiman so mismo da a kakakteh, as kan komwan anchiw parinen inyapwan dyirad anak da. Siranchiw anak, ki machikontra sanchi do inyapwan da, kan ipadiman da sanchi. ");
INSERT INTO ivb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ipsok danchinyo no tabo tawotawo maynamot do kapachichasa nyowaya dyaken. Ki maisalakan anchiw makaibtor so kapanganohed na mandad pandan. ");
INSERT INTO ivb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","An idadanes daynyo do asa idi, mayyayo kamo do matarek a idi. No bata ko dyinyo, ki oyod a dyi nyo panchi a tayokaw tarabako nyo do tabo a idiidi do Israel sakbay a mangay no Tawowaw a Yapod Hanyit. ");
INSERT INTO ivb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Aryoriw machinanawo a masirsirib kan mangnanawowaw sya, mana aryoriw tobotoboyen a matortoray kan āmo naw? Syimpri aba! ");
INSERT INTO ivb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","On, mapnek danaw nachinanawowaw an mayparin dana akmas mangnanawowaw. Komwan pakono kapnek no tobotoboyenaw an mayparin dana akmas āmo naw. Ta yaken Āpo nyo, ki an batahen da a yaken si Beelsebob a āpo dan dimonyo, maypaypangay danaw kaipsok da dyinyo a manganohed dyaken?” ");
INSERT INTO ivb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“As dawa, mamo kamo aba dyira, ta abaw naitayo a dyinchi a maipaboya, mana palimed a dyinchi a mapatakan. ");
INSERT INTO ivb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ta no inbahey ko dyinyo sichangori a inyō lang, ki ibahey nyonchi do tabo tawotawo. As no iyarasāas ko dyinyo, ki ingengey nyo do katawotawowan. ");
INSERT INTO ivb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","As chamo nyo sabaw mangdimanaw so inawan, ki maparin daba dimanen pahad. Ki nawri pakono chamo nyo Dyos, ta maparin na rarayawen inawan kan pahad do impyirno. ");
INSERT INTO ivb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ta chiban nyo saw billit toleng saya a sinsinan so balor, asa lang a kaplataw balor dan dadwaw. Asyo a masday aran asa dyirad dyaya, an dya ipalōbos ni Āmang nyod hanyit, ta ay-aywanan na sa. ");
INSERT INTO ivb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ki aran siraw boboh nyo, ki chapatak danan Dyos bidang da. ");
INSERT INTO ivb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","As dawa, mamo kamo aba, ta mapatpateg kamo kan aro saw a billit toleng. ");
INSERT INTO ivb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ta aran sino a mangipodno do salapen dan tawotawo a manganohed dana dyaken, ki ipodno konchi do salapen Āmang kod hanyit. ");
INSERT INTO ivb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","“Ki no mangilibak so kapanganohed na dyaken do salapen dan tawotawo, ilibak konchi do salapen Āmang kod hanyit.” Nyaw innanawo ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Iktokto nyo aba a nangay ako a mangyangay so kapaychachapya do lobongaya. On, mangyangay akwabas kapaychachapya, an dya kapaydidiman. ");
INSERT INTO ivb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nangay ako tan inyangay ko kapachikontran anak a mahakay do āmangaw, as kan anakaw a mabakes do ānang naw. Masaw manogangaw a mabakes di katogangan na a mabakes. ");
INSERT INTO ivb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ta siraw kabosor no asaw a tawo a manganohed dyaken, ki siraw myan do mismo na a pamilya. ");
INSERT INTO ivb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ta no aran sino a rakorakoh so adaw di āmang kan ānang na kan adaw na dyaken, ki polos a maikari aba dyaken. Masaw a no rakorakoh so adaw do anak na kan adaw na dyaken, abaw sinpangan na, dyaken. ");
INSERT INTO ivb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ta aran sino a dya maysabhay so kros na, as kawnot na dyaken, polos a abos sinpangan dyaken. ");
INSERT INTO ivb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ta no mangipateg so byay nad tanaya, alit na mabo na. Ki no tawo a madiman a maynamot do kapanganohed na dyaken, myan anchiw byay na abos pandan a itoroh anchi no Dyos dya.” ");
INSERT INTO ivb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“No mangrawat dyinyo, bāli yaken danaw rinawat na. As no mangrawat dyaken, ki iya danaw rinawat naw nanoboyaw dyaken a si Āmang kod hanyit. ");
INSERT INTO ivb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","As no mangrawat so asa propīta maynamot ta iya, ki mangipakatoneng so maynamot do Dyos, magon-gonaan anchiw nawri a tawo a akmas gon-gona naw no nawri a propīta. Masaw a no mangrawat so asa malinteg a tawo maynamot do kalinteg naw, ki magon-gonaan anchi a akmas gon-gona naw no malintegaw a tawo. ");
INSERT INTO ivb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","As no aran sino a mapaynom so aran asa kabaso a mahanebneb a ranom do asa dyirad mabobodis saw so saad maynamot ta nanawhen ko sa, sigorādo a rawaten nanchiw gon-gona na,” binatan Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Do nakatayokaw ni Jesos a nangibilin dyirad dosi saw a nanawhen na so tabo nyaya, ki komnaro si Jesos do dawri a yanan kan nangay a mangnanawo kan mangasaba dyirad masngen saw daw a idiidi. ");
INSERT INTO ivb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ki do dawri a chimpo, myan si Juan a Mamonyag do bahodan. Ki do nakadamag naw so pinariparinaw ni Kristo, tinoboy na saw nanawhen naw a mangay di Jesos a manahahes dya a kon da, ");
INSERT INTO ivb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Imo danawriw hahawen namenaw a mangay anchi, mana mangnanaya kami pas matarek?” ");
INSERT INTO ivb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ki tinbay san Jesos a kāna, “Maybidi kamo di Juan, as kaibahey nyo sya dya siras nadngey nyo kan naboya nyo saya: ");
INSERT INTO ivb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Makaboya dana saw bolsek kan makayam dana saw piday, napyan saw nagliproswaw kan makadngey dana saw toleng, kan nagongar saw nadiman, as maikasaba danaw Maganay a Dāmag dyirad mapopobri. ");
INSERT INTO ivb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Magasat tawo a dya maycharwa so kapangtokto a maynamot dyaken!” ");
INSERT INTO ivb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ki do nakapakayam daw no nanawhenaw ni Juan a Mamonyag, nyaw binata ni Jesos dyirad tawotawo saw a maynamot di Juan: “Do nakangay nyowaw di Juan do let-ang, āngo hahawen nyo a maboya? Asawri a tawo a tod a madyiwadyiway so kapangtokto a akmay bochid a pablobloten salawsaw? Syimpri engga! ");
INSERT INTO ivb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Āngo saw yangay nyo a chiniban? Yay nyori a chiniban asa a tawo a naylaylay so mapintas kan mangina? Engga, ta palasyo iyaw yanan dan maylaylayaw so malamoyot a mangina. ");
INSERT INTO ivb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ngay, Ibahey nyo pa! Āngo ta nangay kamo daw? Nangay kamo āno a nanyideb so asa propīta? Naon, masyirto nawri! Ki no ibahey ko dyinyo, ki masissisīta pa a adayo kan asa a propīta. ");
INSERT INTO ivb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ta si Juan chakeyaw a batahen myanaw a naitolas do Masantwan a Tolas a kānan Āpo Dyos, ‘Panmahen konchi a toboyen asaw a pachirawatan ko tan yay na paysonongen ayaman mo.’ ");
INSERT INTO ivb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Adngeyen nyo nya, ta oyod. Tabon nayanak a tawo, ki abaw akmas kasisita ni Juan a Mamonyag. Ki aran komwan, siraw kabobodisanaw a naibidang dana do pagtorayan Āpo Dyos, ki masissisīta sa kan iya. ");
INSERT INTO ivb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ta nakayapod nakainanawowaw ni Juan so minsahi na a mandan sichangori, nawriw nakairogin tawotawo a maswasodib kan posposan daw somdep do pagtorayan no Dyos. ");
INSERT INTO ivb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ta somniknan do chimpwaw ni Moyses kan siraw propīta saw do kaychowa, ki inpadto da a tabo a maynamot do pagtorayanaya no Dyos kan iyaw kangayaw ni Juan sakbay iyaw Mesias. ");
INSERT INTO ivb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","As an chakey nyo a anohdan propīta saw, ayket na, naawātan nyo pakono a si Juan, ki iyaw Elyasaw a naipadto a mangay anchi. ");
INSERT INTO ivb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Inyo a myan so tadyinya, kadngeyen nyo, ah,” binata ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ki tinongtong ni Jesos naychirin a kāna, “Āngo paro pangiparihwan kos tawotawo sichangori? No kapariho da, ki akma saya siras adedekey saw a maychadisdisna do plasa a polos a dyi sa mapnek. Maysin-aagay a kon da dyirad maskehaw a gomtal, ");
INSERT INTO ivb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘An magtokar kami so pīto, ki tomada kamo abaya! An magkanta kamyayas para minatay, ki magdong-aw kamo abaya!’ ");
INSERT INTO ivb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Ta si Juan, ki nangay a nagayonar kan mininom aba so palek. Ki aran akma syaw, binatabata da a iya, ki linoganan no marahet a ispirito! ");
INSERT INTO ivb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","“Ki yaken a Tawo a Yapod Hanyit, ki nangay ako a nachakan kan nachinom dyinyo. Ki alit na batabatahen da a kon da, ‘Chiban nyo nya tawo, masarawaya kan maybobokaya. Sit dayan magsingsingirayas bwis kan siraw maibidang saya a aro so gatos!’ Ki aran komwan batabatahen nyo, ki kosto kan oyod sirib no Dyos, as kan maipaboyaw nyaya do kabibyay dan manganohedaw dya.” ");
INSERT INTO ivb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Do dawri, insiknan ni Jesos a pinaydabdab tawotawo saw do idiidi saw a namarinan nas aro a milagro maynamot ta nakey saba nagbabāwi do gatogatos da. ");
INSERT INTO ivb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Binata na a kāna, “Kapakāsi nyo pa, inyo a taga Korasin kan taga Betsayda! Aro makaskasdaaw a pinariparin ko do idi nyo saya, ki alit na dyi kamo a nagbabāwi! Amnan do idiidi sawen a Tiro kan do Sidon namarinan ko siras nya milagro, ayket, ari dana sa nahay a naylaylay so kostal kan naydisnad ahbek a pangipaboya da so oyod a nakapagbabāwi da. ");
INSERT INTO ivb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","As dawa, ibahey ko dyinyo a anchan araw a kapangokom, ki malidyalidyat anchiw dosa nyo kan iyaw dosa da do idiidi a Tiro kan Sidon. ");
INSERT INTO ivb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“As inyo a tawotawo a yapod Kapernaom, bata nyori an maidayaw kamonchi do hanyit? Polos, basbāli a maitapwak kamonchi do impyirno! Ta an naparin saw nya milagro do Sodoma a akmas naparin saya dyinyo, masigorādo a magbabāwi sa, as kan myan paw syodad daw sichangori. ");
INSERT INTO ivb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ki ibahey ko dyinyo a malidyalidyat anchiw dosa nyo kan siraw yapo do Sodoma anchan marapit nawri a araw a kapangdosa no Dyos.” ");
INSERT INTO ivb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Do katayokaw ni Jesos a nangibahey so nya, insiknan naw maydasal a kāna, “Āmang, imo Āpo do hanyit kan do tana! Magyaman ako dyimo, ta inpakatoneng mo dyirad abos ādal iyaw intayo mwaya dyirad mamasirib kan myan so ādal. ");
INSERT INTO ivb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","On mo Āmang, ta nawriw chakey mo kan makahwahok nawri do salapen mo.” ");
INSERT INTO ivb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Intalek dyaken Āmang tabo a panakabalin a mangitoray. Abaw makapatak so maynamot dyaken a Anak no Dyos, an dyi lang a si Āmang ko. Masaw a abo makapatak so maynamot di Āmang, an dya yaken lang a Anak na kan siraw tawo a pidyen ko a pangibaheyan so maynamot dya. ");
INSERT INTO ivb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Dawa, mangay kamo dyaken, inyo a tabo a mayrara so marahmet kan inyo a tabo a mahopag, ta paynahahen koynyo. ");
INSERT INTO ivb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Apen nyo nanawo ko kan machinanawo kamo dyaken maynamot ta maanos ako kan matangsit akwaba, as kan makadongso kamonchi so kaydamnayan no kapangtokto nyo. ");
INSERT INTO ivb_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ta no nanawo a itoroh ko, ki maydamnay, kan iyaw raraya a iparara ko dyinyo, ki marahmet aba.” ");
INSERT INTO ivb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Do dawri, do asaw a Araw a Kapaynaynahah, nayam sa Jesos do asaw a bengkag a namohan so trigo. Ki maynamot ta naptengan saw nanawhen naw, nanghokhot sas dāwa a kinan da. ");
INSERT INTO ivb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ki do nakaboya daw no Parisyo saw so nawri, binata dad Jesos a kon da, “Chiban pa! Parinen dayan nanawhen mwayaw mabaywanaya a kaparin do Araw a Kapaynaynahah? Mapsekawriw nawri?” ");
INSERT INTO ivb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ki tinbay san Jesos a kāna, “Namna! Ari nyo pawryad nabāsaw no pinarinaw ni Dabid do nakapteng daw kan siraw kinayrayay naw? ");
INSERT INTO ivb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Taywaran dya somindep si Dabid do pagdaydayāwan daw so Dyos, as nakapanghap nas kinan na tinapay a naidāton do Dyos? Sigon do linteg ta, mabaywan a kanen na kan siraw rarayay na saw, an dya sira lang papadi saw. ");
INSERT INTO ivb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mana nabāsa nyo abawriw Lintegaw ni Moyses a makagatos sabaw papadi saw an maytarabako sad irahem no Timplo do Araw a Kapaynaynahah, ta nawriw kapagsirbi da do Dyos? ");
INSERT INTO ivb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","No ibahey ko dyinyo, ki ari dyaw asa masissisīta pa kan do Timplowaya. ");
INSERT INTO ivb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","As an oyod a chapatak nyo chakey a batahen naitolasaw do Masantwan a Tolas a kāna, ‘Chakakey ko kāsi kan no dātonaw a masosohan,’ ayket na, pagatosen nyo sabaw abos gatos. ");
INSERT INTO ivb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ta yaken a Tawo a Yapod Hanyit, ki yaken myan so toray a mangeddeng so maparin do Araw a Kapaynaynahah.” ");
INSERT INTO ivb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Sinpangan na, komnaro sa Jesos, as nakangay da a somindep do sinagoga daw daw. ");
INSERT INTO ivb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ki do dawri, myan asa mahakay a singkol. Ki tan myan pamagatosan da sya, inyahes dan kadwan dya a kon da, “Nainkalinteganoriw mapapya do Arawayan Kapaynaynahah mana engga?” ");
INSERT INTO ivb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ki binatan Jesos dyira a kāna, “Kaspangarigan, an asa dyinyo masday so asa a karniro do aridos do Araw no Kapaynaynahah, yangay nyo abawri a awnen? ");
INSERT INTO ivb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Samna! Mabawa a mapatpateg tawo kan karniro! Dawa, nawriw paynamotan na a naipalobos do linteg kapamarin so maganay do Araw no Kapaynaynahah.” ");
INSERT INTO ivb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Sinpangan na, binatan Jesos do singkolaw, “Lonaten mo tatchay mwaya.” Do dawryaw a inbahey ni Jesos, linonat na kan nyeng a napyan a nachalit do asaw a tatchay na. ");
INSERT INTO ivb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ki maynamot do nyaya, minohtot saw Parisyowaw do sinagoga daw, kan nagplano sa an maypāngo iyaw no kadiman das Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ki chinapatak ni Jesos iyaw plano daw no Parisyo saw, dawa, komnaro do dawri. Ki minonot dyaw aro saw a tawotawo, as kan pinapya na san Jesos a tabo do aran āngo a ganyit da. ");
INSERT INTO ivb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ki inbahey na dyira a ibahebahey daba an sino iya. ");
INSERT INTO ivb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","On, tan matongpal binataw no Dyos do intolasaw ni propīta Isayas a maynamot dya a kāna, ");
INSERT INTO ivb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Cha dyaw tobotoboyen ko a pinidi ko a chadaw ko, as kan nahwahok ako na a maynamot dya. Itoroh konchi dyaw Ispirito ko, as ipakatoneng nanchiw malinteg a kapangokom ko dyirad tawotawo saw a Dya-Jodyo. ");
INSERT INTO ivb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","No nya tobotoboyen ko, ki nachidiman aba. Masaw a madngey aba do kalkalsāda a mangagagay. ");
INSERT INTO ivb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Siraw tawotawo saw a akmay naydonggok a byawo do kapanganohed da, ki pototen na saba. Komwan saw makakāsi saw a akmay makodrep a soho, ki ospen na saba a mandanchan paytēneken naw kinalintegaw no Dyos. ");
INSERT INTO ivb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","As iyanchiw chasaray dan tabo a tawotawo a aran sino a Dya-Jodyo.” ");
INSERT INTO ivb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Sinpangan na, inyangay dan kadwan saw a tawotawo di Jesos asaw a mahakay a bolsek kan omel maynamot ta sindep no marahet a ispirito. Ki pinapya ni Jesos nawri a mahakay, as kan nakapaychirin kan nakaboya danaw mahakayaw. ");
INSERT INTO ivb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ki chinasdaaw dan tabo a tawotawo, kan binata da a kon da, “Iya abawriw Kapotōtan ni Āri Dabid, iyaw naikaryaw a mangay a mangisalakan?” ");
INSERT INTO ivb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ki do kadngey daw no Parisyo saw so bata daw no tawotawo saw, ki binatabata da a kon da, “Ay, engga ah! Si Beelsebob lang a pangolo da no dimonyo saw manorotoroh dya so panakabalin a mangpaksyat so marahet saya a ispirito.” ");
INSERT INTO ivb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ki chapatak ni Jesos myanaw do aktokto da, kan binata na dyira a kāna, “An mayayarap tawotawo do asa kapagaryan, manayonoriw nawri a pagaryan? Masaw asa idi mana kapamilya an maglalaban sa, makapaytēnek pa saba. ");
INSERT INTO ivb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Masaw an maysinpapaksyat saw myanaw do pagaryan ni Satanas, makapaytēnekoriw pagtorayanaw ni Satanas? ");
INSERT INTO ivb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","An oyod nya batahen nyo a yapod panakabalin ni Beelsebob kapaksyat kwaya so marahet saya a ispirito, sino paro nanoroh so panakabalin dan nanawhen nyowaya a mapaksyat so akma syay? On, sira mismo mangipaneknek dyinyo so riro nyo. ");
INSERT INTO ivb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ki an maynamot dyaken, no kaoyodan na, ki paksyaten ko saw marahet a ispirito a maynamot do Ispirito no Dyos, as kan nyaw pakaboyan a nawara dana dyinyo kapagtoray no Dyos,” binatan Jesos dyira. ");
INSERT INTO ivb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ki tinongtong ni Jesos naychirin a kāna, “Maypāngo iyaw tod a makasdesdep do irahem no bahay no mayit a tawo a akmas Satanas kan manakanakaw siras dyira na saw, an dyi pa manma mabahod nya mayit a tawo? Amnan nabahod dana, libri danaw tod a manghap siras dyira na saw. ");
INSERT INTO ivb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“No dya machitonos dyaken, ki machikontra dyaken. Masaw no dya somidong a machipangpeh dyaken, mapawpit. ");
INSERT INTO ivb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nawriw paynamotan kaibahey kwaya sya dyinyo a mapakawan tawotawo do tabo a pakagatosan da mana kapaychirin da so maikontra do Dyos, ki mapakawan abaw maychirin so maikontra do Ispirito Santo. ");
INSERT INTO ivb_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","As no aran sino a maychirin so maikontra dyaken a Tawo a Yapod Hanyit, maparin pa a mapakawan. Ki no aran sino a maychirin so maikontra do Ispirito no Dyos, mapakawan abanchi a polos sichangori mana do masakbayan.” ");
INSERT INTO ivb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Tinongtong ni Jesos nagpangarig dyira a kāna, “An ibidang nyo a maglaw asa kayo, syimpri, omsi so maganay. Ki an ibidang nyo a nayhahāyo asa kayo, ibidang nyo pa a makwan asi na. Ta sigon do asyaw no kayowaw, mailasin mo an āngo kakayo na. ");
INSERT INTO ivb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Pakawanem, akma kamo kapotōtan marem! Maypāngo kapaychirin nyos maganay an maynana marahet kapangtokto nyo? Ta iyaw dangoy, ki mapahtot so kinapya na do aktokton tawo. ");
INSERT INTO ivb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","No tawowaw a maganay so dadakay, ki nawriw pahtoten naw maganay. Masaw a an marahet so dadakay; nawriw pahtoten naw marahet, ta nawriw kinapya na do aktokto na. ");
INSERT INTO ivb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ibahey ko dyinyo oyod. Anchan araw a kapangokom, ki kāda asanchi, ki atbayen nanchiw inchirin na a abos sinpaspangan a chirin. ");
INSERT INTO ivb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ta siraw mismo chirin mwaw, ki siranchiw pangikeddeng no Dyos an nakagatos ka mana engga,” binata ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Sinpangan na, naychirin saw kadwanaw a mangnanawo so linteg kan siraw rarayay da saw a Parisyo a kon da, “Maistro, paboyan pa yamen so makaskasdaawaw a kaparin a pakaboyan an oyod a yapod Dyos toray mo.” ");
INSERT INTO ivb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ki tinbay san Jesos a kāna, “Ay samna! Oltimwaya so karahet no tawotawo sichangori kan abayaw kapanganohed nyo, ta tinadyichokodan nyo Dyos. Oltimwayaw kakey nyo a makaboyas milagro, ki abanchi a polos maitoroh a milagro, malaksid do naparinaw di propīta Jonas. ");
INSERT INTO ivb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Akmas nakayanaw ni Jonas do irahemaw no bodekaw no royong a nakapahabas so tatdo a karaw kan ahep, ki komwan anchiw kahay ko a Tawo a Yapod Hanyit a maitabon. ");
INSERT INTO ivb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ta anchan araw a kapangokom, maytēnek sanchiw taga Ninebe a mapagatos dyinyo do dya kapotōtan. Ta sira, ki nagbabāwi sa do nakapangasabaw ni Jonas. Ki inyowaya, ki anohdan nyo abayaw ibahey kwaya a aran matwatohos ako kan Jonas. ");
INSERT INTO ivb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Asa pa. Do arawayan kapangokom, maytēnek anchiw Rēyna do Abagātan do kaychowa pa tan pagatosen na saw tawotawo do dya kapotōtan maynamot ta iya, ki yapod katetengan a yanan a mangay a mangadngey so kasirib ni Āri Solomon. Ki inyo, ki manganohed kamo abaya aran myan mangnanawo dyinyo sichangori a masirsirib pa kan si Āri Solomon.” ");
INSERT INTO ivb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Sinpangan na, tinongtong ni Jesos naychirin dyira so nya pangarig: “An mohtot asa marahet a ispirito do asa tawo a sindepan na, midibidi anchi a maychichwas do let-ang so matarek a paynahahan na, ki makadongso aba. ");
INSERT INTO ivb_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Sinpangan na, batahen na do inawan naw a kāna, ‘Āy, maganay āno, an paybidi ko nakayapwan kwaw a bahay?’ Do kapaybidi naw, masarakan na a madalos kan maornos, as kan apabaw omyan daw. ");
INSERT INTO ivb_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Do dawrinchi, ki mangay a manghap so rarayay na a papito pa a ispirito a maraherahet kan iya, as kan somdep sanchi a tabo do dawri a tawo. As no kayayan no nawri a tawo a sindepan da, ki mangamangay pa makakāsi kan iyaw sigodaw a kayayan na. Komwan anchiw payparinan dan tawotawo sichangori a oltimo danas karahet.” ");
INSERT INTO ivb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ki myan pa maychiychirin si Jesos dyirad tawotawo saw do kawara daw da ānang na kan no kakakteh na saw. Ki myan sa do gaganaw no bahay, as kan inpatawag das Jesos, ta chakey da kasarita. ");
INSERT INTO ivb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Dawa, binatan asaw a tawo daw a kāna, “Aryaw si ānang mo kan kakakteh mo saw a maytēnek do gagan. Chakey da, kono, imo a kasarita.” ");
INSERT INTO ivb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ki tominbay si Jesos a kāna, “Sino paro ānang ko, kan sino paro saw kakakteh ko?” ");
INSERT INTO ivb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Sinpangan na, tinongdo san Jesos nanawhen naw, as nakabata na sya a kāna, “Cha saya dyaw ānang kan kakakteh ko! ");
INSERT INTO ivb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ta aran sino a mamarin so pagayatan ni Āmang kod hanyit, ki iya danaw kakakteh kan ānang ko.” ");
INSERT INTO ivb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Do dawri a araw, komnaros Jesos do bahayaw, as nakangay na naydisna do payisaw no minanga a nangnanawo. ");
INSERT INTO ivb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ki maynamot do kārwaw no tawotawo a mindibon sya, nangay si Jesos a somnakay a naydisna do sihahatawaw a abang. Ki siraw tawotawowaw, nāw dad payisaw no minanga a nangadngey sya. ");
INSERT INTO ivb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Aro innanawo na a inpangarig dyira. Binata na dyira a kāna, “Myanaw asa maymohamoha a nangay a nangiwaris so botoh. ");
INSERT INTO ivb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Do kayan naw a magwaris, myan saw napaychahesday na do rarahan naw, kan kinan san manomanok. ");
INSERT INTO ivb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Myan paw kadwan sa a botoh, ki naychahesday sa do mabato saw a yanan. Maynamot do kadēkey no tana, nalisto sa naycharoroting. ");
INSERT INTO ivb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ki do nakaibilag daranaw do araw, nahayo sa, ta nakarahem abaw yamot da saw. ");
INSERT INTO ivb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Myan pa saw kadwan a botoh, ki naychahesday sa do katamtamkan a manolok. Ki do kapayparakoh daranaw a nachisagesagel do tametamek, ki nahonghongan sa. ");
INSERT INTO ivb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ki myan saw botoh a naychahesday do maganayaw a tana. Tomnobo sa, kan minsi sas aro. Siraw kadwanaw, ki mayid, kan myan saw kadwan a mangengen. Siraw kadwanaw, ki mawpayang so dāwa.” ");
INSERT INTO ivb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Do nakatayokaw ni Jesos so nya pangarigan na, binata na, “Inyo a myan so tadyinya, kadngeyen nyo ah.” ");
INSERT INTO ivb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Do nakatayokan Jesos so nya nanawo, nangay sad Jesos nanawhen naw, as nakaiyahes da sya dya a kon da, “Mo Āpo, āngo ta mangosar kas pangarig saya an maychirin ka dyirad tawotawo saya?” ");
INSERT INTO ivb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ki tinbay san Jesos a kāna, “Inyo nakaitorohan no kapakatoneng so palimedaya a maynamot do pagtorayan no Dyos. Ki siraw kadwan saw a tawotawo, ki engga. ");
INSERT INTO ivb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ta no makaāwat, ki arwaro maitoroh dya tan magsobra. Ki no dya makaāwat, aran iyaw dēkeyaw a myan dya, ki mapakaro panchi dya. ");
INSERT INTO ivb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Dawa, nawriw osaran kwayas pangarig an siraw paychirinan ko, ta aran manyideb sa, ki makalasin saba, kan aran mangadngey sa, ki makadngey saba mana aba polos kapakaāwat da. ");
INSERT INTO ivb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ta an maynamot dyira, natongpal danaw inpadtwaw ni propīta Isayas a kāna, ‘Pirmi kamonchi a mangadngey, ki makaāwat kamo aba. Pirmi kamonchi a manyideb, ki makalasin kamo aba. ");
INSERT INTO ivb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","As maynamot ta matwaw oho dan nyaya tawotawo, sinesengan daw tadyinya da, kan pinayreket daw mata da. Ta an dya komwan, ayket, makaboya sa kan makadngey sa, as makaāwat sa, as āngo nchan maybidi sa dyaken, as pyahen ko sa!’ Nawriw binata no Dyos. ");
INSERT INTO ivb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ki inyo, ki magasat kamo, ta makaboya kan makadngey kamo. ");
INSERT INTO ivb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ibahey ko dyinyo oyod a aro saw propīta kan siraw masingpetaw kaychowaw taywara mangahahay a manyideb so maboyaboya nyowaya, ki naboya daba, kan chakey da adngeyen iyaw madngedngey nyowaya, ki nadngey daba.” ");
INSERT INTO ivb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Sichangori, adngeyen nyo chakey na batahen pangarigaya maynamot do kapaymohamoha. ");
INSERT INTO ivb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","“No mangadngey so chirinaya a maynamot do pagtorayanaya no Dyos as dyi na maawātan, ki maipariho do payisaya no rarahan a naychahesdayan botoh. Nangay si Sairo, as kan sinodib naw maganayaw a naimoha dya. ");
INSERT INTO ivb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","As no kabatwanaya a naychahesdayan botoh, ki nawriw pachiyengayan tawowaw a nyeng a masoyot a mangrawat an madngey naw chirin no Dyos. ");
INSERT INTO ivb_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ki maynamot ta nakarahem abaw yamot na do aktokto na, manayon aba. Ta an myan kalidyatan kan kaidadanes a maynamot do chirinaya a nadngey na, chaōpay narana kan malisto a tomadyichokod do kapanganohed naw. ");
INSERT INTO ivb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","As no kanonolokanaya a naychahesdayan no botoh, ki maipariho do tawowaw a mangadngey so chirin no Dyos. Ki iyaw chirinaya nadngey na, makalo na mabo a maynamot do kabakel na makayapo do problima do byay kan no pangawis no kinabaknang. Nya sayaw manghonghong so chirinaw a nadngey na, kan may-asi aba. ");
INSERT INTO ivb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","As iyaw maganayaw a tana a naychahesdayan no botoh, ki mayarig do tawowaw a mangadngey so chirin no Dyos kan maawātan na. As siraw naimohaw dya a botoh, ki nay-asi sa. Myan saw mayid, mangengen, kan mawpayang so dāwa.” ");
INSERT INTO ivb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Myan paw matarek a pangarig a inbahey ni Jesos dyira a kāna, “Maiyarig iyaw pagtorayan ni Āpo Dyos do naparinaya do asaya a tawo a nagwaris so maganay a botoh do bengkag na. ");
INSERT INTO ivb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Do asa kahep do kapakaycheh daranan akin bengkagaw, nangay kabosor naw, as kan naymohas tamek do payapayawan daw no mohamoha naw a trigo, as nakayam narana. ");
INSERT INTO ivb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ki do nakapayparakoh daranaw no mohamohaw kan somiknan dana sa magdāwa, madlaw danaw kayan tamekaw. ");
INSERT INTO ivb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Sinpangan na, nangay saw tobotoboyen naw no akin mohamohaw, as nakabata da syad āmo daw a kon da, ‘Āpo, maganay saw botohaw a inmoha mod bengkag mwaya, ki āngo ta ari danayaw tamek na?’ ");
INSERT INTO ivb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ki binatan āmo daw a kāna, ‘Kaparin kabosor ko nawri.’ “Ki inyahes daranan tobotoboyen naw a kon da, ‘Chakey mori, ta yay namen sa bagoten tamekaya?’ ");
INSERT INTO ivb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ki binatan āmo daw, ‘Ay! Engga, ta āngo nchan makaparapas kamo so mohamoha kwaw. ");
INSERT INTO ivb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nolay nyo a mayrayay sa mayparakoh tamekaya kan mohamohaya. Ta anchan araw no kapagranyi, ki ibahey konchi dyirad pagranyen kwaw a panmahen da sa bagoten tamekaya, as kasosoh da sira. As anchan tayoka no nawri, ranyen darananchiw mohamoha kwaya, as kakapya darana sya do agāmang kwaw.’” ");
INSERT INTO ivb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Myan paw asa pangarig a inbahey ni Jesos dyira a kāna, “Maiyarig paw pagtorayan ni Āpo Dyos do dēkey a botoh no mostasa a akmay kadedēkeyan a botoh a inwaris no asa tawo do bengkag na. Ki tomobo kan mayparin a akmas kararakohanaw a mohamoha. No karakoh na, ki akmas asa kayo a maparin a payketketan manomanok sangasanga na saw.” ");
INSERT INTO ivb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Myan paw asa pangarig a inbahey ni Jesos dyira a kāna, “Maiyarig paw pagtorayan ni Āpo Dyos do yapo a pasaglen mabakes do aro a arina tan pabsogen na tabo.” ");
INSERT INTO ivb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nyaw binata ni Jesos dyirad tawotawowaw, kan inosar naw pangarig do tabo a nakapachisarsarita na dyira, ta nachisarsarita aba do dawri, an dya nangosar so pangarig. ");
INSERT INTO ivb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Pinarin naw nya tan matongpal iyaw padtwaw no propīta a kāna: “Osaren konchiw pangarig an machisarita ko dyira. Ki aran komwan, ibahey konchi dyiraw no dyi pa napapatakan a kayapo pad nakaparswa no lobong.” ");
INSERT INTO ivb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Do dawri, kinarwan sa ni Jesos tawotawo saw, as nakasdep nad bahayaw daw. Ki naypasngen sa dyaw nanawhen naw, as nakabata da sya dya a kon da, “Ipalawag mo pa dyamen, mo Āpo, chakey a batahen pangarigaw do tamekaw do bengkag.” ");
INSERT INTO ivb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Binatan Jesos dyira a kāna, “No tawowaya a maymoha so maganay a botoh, ki yaken a Tawo a Yapod Hanyit. ");
INSERT INTO ivb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","As no bengkagaya, ki siraw tawotawo saya do lobongaya. As no maganay saya botoh, ki siraw anak saya do pagtorayan ni Āpo Dyos. As siraw tamekaya, ki siraw anakaya no marahet. ");
INSERT INTO ivb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","As no kabosoraya a naymohas tamek, ki si Satanas. No kapagranyaya, ki iyaw panongpalan lobongaya, as kan no magranyi saya, ki siraw anghilis saw. ");
INSERT INTO ivb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Akmas naparinaw do tamekaw a nakpekpeh a nasosohan, komwan anchiw maparin an araw no panongpalan lobongaya dyirad nachirarayay saw di Satanas. ");
INSERT INTO ivb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ta yaken a Tawo a Yapod Hanyit, ki toboyen konchiw anghilis ko saw a mangay a mapakaro do pagtorayan ko so tabo mapaygatos saw so kapayngay da tawo kan sira tabo mamariparin saw so marahet. ");
INSERT INTO ivb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Payongben da sanchi no anghilis ko do somgesged a apoy kan dawriw yanan dan tomanyitanyis saw kan mayngaletnget a tawotawo do lidyat da. ");
INSERT INTO ivb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Komwan abaw masingpet saw a tawotawo, ta maranyag sanchi a akmay araw do pagtorayan ni Āmang da. Inyo a myan so tadyinya, kadngeyen nyo ah.” ");
INSERT INTO ivb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Maiyarig paw pagtorayan ni Āpo Dyos do balitok a nailabeng do asa a bengkag. Myan tawo a nakadongso sya, ki tod na pinonan. Sinpangan na, nayyayo a siraragsak a nangilako so tabo warawaraw na, as nakangay na a nanggatang so bengkagaw tan madyira naw pinonan naw a balitok.” ");
INSERT INTO ivb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Maiyarig paw pagtorayan ni Āpo Dyos do asa magnigosyo a pirmi a maychichichwas so mangina a alahas. ");
INSERT INTO ivb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ki do nakadongso naranaw so oltimwaw so kangina a alahas, ki inlāko naw tabo warawara naw, as nakangay na nanggatang sya.” ");
INSERT INTO ivb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Maiyarig paw pagtorayan ni Āpo Dyos do asa nakapakat a sigay a makahap so tabo a kita no among. ");
INSERT INTO ivb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ki do nakapno danaw no sigayaw, ki inākas dan magkalapaw, as inyangay dad aptanaw, as kapaydisna da a mamidi siras magaganayaw a among. Ikalapay da saw maganayaw, as ipoha da saw dyaw a maganay. ");
INSERT INTO ivb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Komwan anchiw maparin an araw no kapangokom. Mohtot sanchiw anghilis saw a mapaychapidi so marahet kan malinteg saw a tawotawo. ");
INSERT INTO ivb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Siranchiw marahetaw, ki payongben da sanchi no anghil saw do somgesgedaw a apoy, kan dawriw yanan dan tomanyitanyis saw kan mayngaletnget a tawotawo do lidyat da.” ");
INSERT INTO ivb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ki inyahes ni Jesos dyirad nanawhen na saw a kāna, “Maawātan nyoriw nya a tabo?” Ki binata da dya, “On.” ");
INSERT INTO ivb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Sinpangan na, binatan Jesos dyira a kāna, “No chakey na batahen, ki kāda asa mangnanawo so linteg a manganohed do inanawo kwaya a maynamot do pagtorayan Dyos, ki maiyarig do asaw a akin bahay a makapatak a mangosar so bayo kan adan a warawara na a kinapya na do agāmang naw.” ");
INSERT INTO ivb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Do katayokaw ni Jesos a nangnanawo so nawri sa a pangarig, ki komnaro dana do dawri a idi. ");
INSERT INTO ivb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Do dawri, naybidi do mismo naw a idi do Nasaret, as kan nangnanawo do sinagoga daw daw. Ki do nakadngey daw so inanawo naw, nasdaawan saw tawotawo saw daw, as kan naysin-iiyahes sa a kon da, “Dino paro nanghanghapan na so nyaya sirib kan panakabalin na a mamarin siras milagro saya? ");
INSERT INTO ivb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Iyabawriw barwaw ni Jose a karpintīro? As si Maria abawriw ānang naw, kan sa Santiago, Jose, Simon, kan Jodas, sira abawriw kakakteh naw? ");
INSERT INTO ivb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Asa pa, siraw tabo kakakteh naw a mababakes, ki taywaran dyi sa omyan dya a masngen dyamen? Ay samna! Dino paro nanghapan nas tabo nyaya?” ");
INSERT INTO ivb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Do dawri, inipsok das Jesos. Ki binatan Jesos dyira a kāna, “Iyaw propīta no Dyos, ki anyiben da do aran dino a logar, malaksid do bokod na idi kan pamilya.” ");
INSERT INTO ivb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ki dēkey inpaboya na milagro daw maynamot do dyi daw a panganohdan. ");
INSERT INTO ivb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ki do dawri a chimpo, nadamag ni Āri Herodes no torayen do Galilya iyaw maynamot di Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Binatan Āri Herodes dyirad tobotoboyen naw a kāna, “Iyaw nya, ki si Juan a Mamonyag a minirwa nabyay. As dawa, myan dyaw panakabalin a mamarin so komwan saw a milagro.” ");
INSERT INTO ivb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Nyayaw binatan Herodes maynamot ta iyaw nangpatiliw kan nangpakawar, as kan nangpabahod di Juan. Pinarin Herodes nya maynamot do nakapachikontraw ni Juan di Herodes do nakakabahay naw so ipag naw a si Herodyas a baket ni ādi nas Pilipi. ");
INSERT INTO ivb_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ta do nakarahan, binata ni Juan di Herodes a kāna, “Maikontraw do linteg pinarin mwaya.” ");
INSERT INTO ivb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ki do dawri, chinakey ni Herodes a dimanen, ki namo dyirad Jodyo saw, ata, inbidang dan tawotawo saw a asa propīta si Juan. ");
INSERT INTO ivb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ki do kapagkomplyaw ni Āri Herodes, tomnadaw balāsangaw a anak ni Herodyas do salapen na kan siraw bisīta na saw, ki nahwahok si Āri Herodes a maynamot dya. ");
INSERT INTO ivb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Dawa, nagkari si Herodes dya a aran āngo a akdawen na, ki itoroh nanchi dya. ");
INSERT INTO ivb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ki do dawri, minandaran ānang naw a ibahey na di Herodes a kāna, “Yangay mo sichangori iyaw ohwaw ni Juan a Mamonyag a mapadatok do tatakan.” ");
INSERT INTO ivb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Maynamot do dawri, chinaynyin aktokto no āryaw, ki maynamot do kari naw kan maynamot ta myan pa saw bisīta na, inbilin na a tongpalen daw yahesaw no balāsangaw. ");
INSERT INTO ivb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Do dawri, inpapotoh nas Juan do nakabahodan naw. ");
INSERT INTO ivb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Sinpangan na, inyangay daw ohwaw ni Juan a napadatok do tatakanaw kan inparawat dad balāsangaw, as kan iya danaw nanoroh syad ānang na. ");
INSERT INTO ivb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Katayoka no nawri, yangay da inhap no nanawhen naw ni Juan iyaw bangkay naw, as nakaitanem da sya. Do dawri, yangay da inbahey di Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Do nakadamagaw ni Jesos so nawri a naparin di Juan, nayabang sa Jesos a nangay do logaraw a kabwan tawo tan myan sa daw a sirā. Ki do nakatoneng daw no tawotawo saw so nakakarwaw ni Jesos, komnaro sad idiidi da, as nakapaglikaw da a nanakey a minonot di Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Do nakagchinaw ni Jesos do abangaw, naboya naw riniboribo saw a tawotawo. Taywaraw nakāsi na sira, as kan pinapya naw ganyit da saw. ");
INSERT INTO ivb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ki do kamakoyab naranaw, naypasngen sa di Jesos nanawhen naw, as nakabata da sya a kon da, “Īto danayaw kasdep no araw kan abayaw pagyanan dan tawotawo saya do dya ranso. Dawa, payamen mo na saw tawotawowaya tan mangay sa gomātang so kanen dad masngen saya barbaryo.” ");
INSERT INTO ivb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ki binatan Jesos dyira a kāna, “Machita paba komaro sa, ta inyo manoroh so kanen da.” ");
INSERT INTO ivb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","“Namna! Dadimaya katinapay kan dadwa among lang myanaya dyaten dya,” initbay dan nanawhen naw. ");
INSERT INTO ivb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ki binatan Jesos dyira a kāna, “Yay nyo a apen dya.” ");
INSERT INTO ivb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ki inbilin ni Jesos dyirad tawotawo saw a maychadisdisna sa do katamtamkanaw. Sinpangan na, inhap naw dadimaw a tinapay kan dadwaw a among, as nakatangay nad hanyit a nagyaman do Dyos. Sinpangan na, inakchikchid naw tinapayaw, as nakaitoroh na sya dyirad nanawhen naw. As siraw nanawhen naw, ki indasar da dyirad tawotawo saw. ");
INSERT INTO ivb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ki komninan sa tabo, kan nabsoy sa. Ki myan paw kinonokon dan nanawhen naw a panda da, as kan nakapno pad asa poho kan dadwa kakalapay. ");
INSERT INTO ivb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","As no bidang dan mahahakay lang a komninan do dawri, ki dadima a ribo. Ki siraw mababakesaw kan adedekey, ki binidang da pa saba. ");
INSERT INTO ivb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Do dawri, pinayabang ni Jesos nanawhen na saw a nanma sa a mamtang do dawri a minanga, as iya, ki nabidin pa. Sinpangan na, pinaybidi na saw tawotawowaw do bahabahay da. ");
INSERT INTO ivb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Do nakapakayam daranaw, somnonget si Jesos a maychatanyi do asaw a tokon a naydasal. Ki do kapaysarisari naranaw, maychatanyi pas Jesos do tokonaw. ");
INSERT INTO ivb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ki do dawri, maydawod danaw abangaw a nagloganan dan nanawhen naw, kan malidyatan sa maynamot ta songat daw salawsaw. ");
INSERT INTO ivb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ki do kaparbangon naranaw, romnapit si Jesos dyira, kan nayam do hapotaw no ranom. ");
INSERT INTO ivb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ki do nakaboya daw no nanawhen na saw si Jesos a myan a mayam do hapotaw no ranom, chināmo da. Inyagay da a, “Oy, samna, anyitwaya!” kon da do taywara a kāmo da. ");
INSERT INTO ivb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ki do dawri, nyeng a naychirin si Jesos dyira a kāna, “Patoreden nyo aktokto nyo! Mamo kamo aba, ta yaken si Jesos.” ");
INSERT INTO ivb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Sinpangan na, binatan Pedro dya a kāna, “On, mo Āpo, an oyod a imo, tawagan mo pa yaken a mangay dyimo do hapotayan ranom.” ");
INSERT INTO ivb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Mangay ka dya,” binata ni Jesos. Dawa, gominchin si Pedro do abangaw, as nakayam nad hapotaw no ranom a nangay do yananaw ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ki do kadlaw naw so salawsawaw, ki namo dana. Do dawri, somiknan dana omned, as kan nanyeng nangngengey a kāna, “Mo Āpo, isalākan mo pa yaken!” ");
INSERT INTO ivb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ki insigīda inigpet ni Jesos tanoro naw, as nakabata na sya dya a kāna, “Kadēkey pan anohed mo. Āngo ta magmangamanga ka?” ");
INSERT INTO ivb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ki do dawri, somnakay sad abangaw, ki nyeng a nangheteng. ");
INSERT INTO ivb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ki siraw myan saw do abangaw, ki dinaydāyaw das Jesos a kon da, “Oyodaya imo Anak no Dyos.” ");
INSERT INTO ivb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Do nakapakabtang daranaw, nakadok sa Jesos do tana a Genesaret. ");
INSERT INTO ivb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Sinpangan na, siraw tawotawo saw daw, ki nalasin das Jesos. Dawa, inpatawag da sa tabo maganyit saw daw, as nakaiyangay da sira dya. ");
INSERT INTO ivb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nachikakaāsi sa dya a aran iya lang sayranaw no laylay naw masalid da no maganyit saw tan mapyan sa. Do dawri, tabo san nakasalidaw, ki napyan dana sa. ");
INSERT INTO ivb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Sinpangan na, nawara saw kadwan saw a Parisyo as kan mangnanawo saw so linteg a yapod Jerosalem a mangay di Jesos, kan inyahes da dya a kon da, ");
INSERT INTO ivb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Āngo ta pawadinen dan nanawhen mwayaw dadakay dan kapoonan ta? Ta chiban mo, maybanaw sabaw a akma so dadakay ta an sakbay a koman sa.” ");
INSERT INTO ivb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ki binata ni Jesos dyira a kāna, “Samna, aran inyo! Āngo ta pawadinen nyo bilin no Dyos do kagaget nyowaya mangtongpal so inpatāwid daw no kapoonan nyo? ");
INSERT INTO ivb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ta inbilin no Dyos a kāna, ‘Dayāwen mo sa āmang mo kan ānang mo.’ As ‘no aran sino a mangibahey so marahet a maynamot do inyapwan na, ki machita dimanen nyo.’ ");
INSERT INTO ivb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ki no inanawo nyowaya, ki matarekaya. Batahen nyowaya a an myan iyaw no maisidong no asa a tawo do inyapwan na, ki maparin a dyi na itoroh. On, tod na ipambar a batahen dyira a iyaw isidong naw dyira, ki maitoroh do Dyos. ");
INSERT INTO ivb_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Dawa, an maynamot do inanawo nyowaya, ki pinayparin nyo a abos sinpangan no chirin no Dyos. ");
INSERT INTO ivb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Maysinsīsingpet kamo! Oyod sawen binataw ni Āpo Dyos a maynamot dyinyo do inpapadto naw di propīta Isayas a kāna, ");
INSERT INTO ivb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Siraw nya tawotawo, dayāwen da yaken do dangoy da, ki mabawaw aktokto da dyaken. ");
INSERT INTO ivb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Abaw sirbin kaidaydāyaw da dyaken, ta inanawo daw linteg a pinarin tawo, kan batahen da a iyaw oyod a bilin no Dyos.’” ");
INSERT INTO ivb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Do dawri, pinaypasngen san Jesos tawotawo saw dya, as kan binata na dyira a kāna, “Adngeyen nyo yaken, kan iktokto nyo a maganay tan maawātan nyo batahen kwaya. ");
INSERT INTO ivb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Makagatos abaw tawo do isobo na, an dya iyaw marahetaw a kapangtokto na a ihwa no dangoy na.” ");
INSERT INTO ivb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Sinpangan na, nangay sa dyaw nanawhen naw, as nakabata da sya dya a kon da, “Mo Āpo, chapatak mo abawri a maynyinan saw Parisyo saya do inchirin mwaya?” ");
INSERT INTO ivb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ki inatbay san Jesos a kāna, “Aran āngo a mohamoha a dya inmohan Āmang kod hanyit, ki mabagot anchi. ");
INSERT INTO ivb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nolay nyo sa, ta bolsek sa, as kan padasen da a ipangōlwan kapayngay da a bolsek. Ki an maysinkaday pariho sa bolsek, ki mahay abas kasday da dadwa do aridos.” ");
INSERT INTO ivb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ki binatan Pedro dya a kāna, “Na, ilawlawag mo pa dyamen nawri a pangarig!” ");
INSERT INTO ivb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Binata ni Jesos dyira a kāna, “Namna! Aran inyo, ki naawātan nyo pabawri? ");
INSERT INTO ivb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Chapatak nyo abawri a tabo kanen a isobo nyo, ki somdep abaw nawri do aktokto, an dya do bodek, as kan maipoha anchi. ");
INSERT INTO ivb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ki no pahtoten dangoy, ki siraw nawriw yapod kapangtokton tawo, kan taywaran dya pakagatosan nawri? ");
INSERT INTO ivb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","On, no pangtoktwan tawo, ki nawriw paypātobwan paygatosan a akmas marahet a kapangtokto, kapangdiman, kapachikamalala, kapaychakatekateh a machoknod, kapanakanakaw, kapangipaneknek so bayataw kan kapamaraherahet. ");
INSERT INTO ivb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Siraw nyaw mapaygatos so tawo. Ki an iyaw bata daya a dya maybanaw an sakbay a koman, ayket, nawri abaw pakagatosan asaw a tawo.” ");
INSERT INTO ivb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Do dawri, komnaro sa Jesos daw, as nakangay dad matarek a probinsya do idiidi saw a Tiro kan Sidon. ");
INSERT INTO ivb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ki nangay dyaw asaw a mabakes a Dya-Jodyo a taga Kanaan, as nachikakaāsi dya, kan inngengey na a kāna, “Mo Āpo a Kapotōtan Āri Dabid, chāsim pa yaken, ta sindepaw no marahet a ispirito balāsang kwaw, kan oltimwaw a kalidyat nas changori.” ");
INSERT INTO ivb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ki polos a dya tinbay ni Jesos. Dawa, nangay sa dyaw nanawhen naw, as kan binata da dya a kon da, “Āpo, atbayen mo na tan dya mononot dyaten a mangagagay.” ");
INSERT INTO ivb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ki binatan Jesos dyira a kāna, “Natoboy ako lang dyirad tawotawo saw a kapotōtan Israel a maiyarig do karniro saw a nabo dana.” ");
INSERT INTO ivb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ki do dawri, naypaypasngen mabakesaw a naydogod do salapenaw ni Jesos, as nakabata na syad Jesos a kāna, “Ayya, mo Āpo, sidongan mo pa yaken!” ");
INSERT INTO ivb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ki inatbay ni Jesos a kāna, “Machita pakanen a manmaw adedekey, ta maparin aba sodiben kanen daw a ipakan dyirad chito.” ");
INSERT INTO ivb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“Na, oyod nawri mo Āpo,” initbay no mabakesaw. “Ki aran siraw chito, ki dididen dabawriw maychahesday saw a yapo do lamisaan no āmo da?” ");
INSERT INTO ivb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ki do dawri, binatan Jesos dya a kāna, “Oyodaya rakkoh anohed mo! Maitoroh dyimo akdawen mwaya.” Ki do dawri, nanyeng a napyan anak naw. ");
INSERT INTO ivb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ki do dawri, komnaros Jesos daw, as nakayam nad payisaw no Minangaw a Galilya. Sinpangan na, somnonget do asaw a paytokonan, as nakapaynahah na daw a naydisna. ");
INSERT INTO ivb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Sinpangan na, nangay sa dyaw reprep saw a tawotawo, kan inyangay da saw piday, bolsek, logpi, omel, kan aro pa saw kadwan a maganyit a pinay dad salapen naw. Ki pinapya na sa tabo. ");
INSERT INTO ivb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Oyod a nasdaawan saw tawotawo saw, kan indaydāyaw daw Dyos no kapotōtan Israel do nakaboya daw a nakapaychirin dana saw omelaw, maganay dana saw logpyaw, makayam dana saw pidayaw, as kan makaboya dana saw bolsekaw. ");
INSERT INTO ivb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Do dawri, tinawagan san Jesos nanawhen naw, as nakabata na sya dyira a kāna, “Chāsi ko sayaw nyaya tawotawo, ta napatawsan dana sayas bahon, kan tatdo danaya karaw da dyaten do dya. Chakey ko saba paybidihen a mapteng, ta angwan mahohed kadwan do rarahan.” ");
INSERT INTO ivb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ki binata da dya no nanawhen naw a kon da, “Dino paro panghapan namen dya ranso so pamakan so akmaya syay a reprep a tawo?” ");
INSERT INTO ivb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ki binata ni Jesos dyira a kāna, “Papira paw tinapay nyowaya?” Ki initbay da, “Ari paw papito kan papere dana a dedekey a natapan a among.” ");
INSERT INTO ivb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Do dawri, inmandar ni Jesos dyirad tawotawowaw a maychadisdisna sa do tana. ");
INSERT INTO ivb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Sinpangan na, inhap na saw papito saw a tinapay kan siraw amongaw, as nakapagyaman na di Āpo Dyos. Ki do nakatayoka naw, inakchikchid na, as nakaitoroh na sya dyirad nanawhen naw. As siraw nanawhen naw, ki nangidasar sa dyirad tawotawo saw. ");
INSERT INTO ivb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ki komninan sa tabo, kan nabsoy sa. Ki myan paw kinonokon dan nanawhen naw a panda da, as kan nakapno pad papito a kakalapay. ");
INSERT INTO ivb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","As no bidang dan mahahakay lang a komninan do dawri, ki apat a ribo. Ki siraw mababakesaw kan adedekey, ki binidang da pa saba. ");
INSERT INTO ivb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ki do katayokaw no nawri, pinayam dana san Jesos tawotawo saw, as nakasakay nad abangaw, as nakangay da Jesos do sakop naw do idyaw a Magadan. ");
INSERT INTO ivb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Do dawri, nangay kadwan saw a Parisyo kan kadwan saw a Sadosyo di Jesos maynamot ta chakey da sooten si Jesos. Inakdaw da pa dya a mapaboyas milagro tan pangipaboya na an iya, ki yapod Āpo Dyos mana engga. ");
INSERT INTO ivb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ki initbay ni Jesos dyira a kāna, “An somdep araw, as maboya nyo a manyibayaw asdepan, batahen nyo a, ‘Mahangan anchi an delak.’ ");
INSERT INTO ivb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","As an mabekas, as maboya nyo a manyibayaw araw maynamot ta makonem, ibahey nyo a, ‘Ay! Machimoy anchi sicharaw!’ Chapatak nyo mangikeddeng so kāwan do kaboya nyo so pangilasinan do kademdeman, ki maawātan nyo abaw chakey a batahen no pangilasinan saya a pariparinen Āpo Dyos sichangori a maynamot dyaken. ");
INSERT INTO ivb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Oltimwaya so karahet tawotawo sichangori kan abayaw kapanganohed nyo, ta tinadyichokodan nyo Dyos. Oltimwayaw kakey nyo a makaboyas milagro, ki abanchi a polos maitoroh a milagro, malaksid do naparinaw a milagro di propīta Jonas.” Do katayokaw ni Jesos a nangibahey syaw, kinarwan na sa. ");
INSERT INTO ivb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ki do kapakarapit daranaw do kabtangaw no minanga, ki nanakem dan nanawhen naw a nawayakan daw naybahon so tinapay. ");
INSERT INTO ivb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ki do dawri, binatan Jesos dyira a kāna, “Magannad kamo do yapo daw no Parisyo saw kan yapo daw no Sadosyo saw.” ");
INSERT INTO ivb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ki do nakaibaheyaw ni Jesos so nya, naysin-iiyahes saw no nanawhenaw ni Jesos a kon da, “Komwan āno batan Jesos, ata, abayaw inhap ta tinapay ta?” ");
INSERT INTO ivb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ki nadlaw ni Jesos iyaw no kapagsasarita daw. As dawa, binata na dyira a kāna, “Ay samna! Taywara kamwaya! Āngo ta nawriw pagsasaritaan nyo kabon tinapay nyo? Kadēkey pan anohed nyo! ");
INSERT INTO ivb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ari kamo pawri a dya makaāwat? Napangayan nyos aktokto nyo? Manakem nyo pabawriw no nakapayparwaw no dadimaw a tinapay a kinan dan dadimaw a ribo a mahahakay, kan papira kakalapay panda nyowaw a kinonokon nyo do dawri? ");
INSERT INTO ivb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Mana iyaw papitwaw a tinapay a kinan dan nasorokaw a apat a ribo a tawotawo, kan papira kakalapay panda a kinonokon nyo daw? ");
INSERT INTO ivb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Samna! Taywaran tinapay chakey ko a batahen? Āngo ta dyi nyo a maawātan? Pirwahen ko na ibahey dyinyo a annadan nyo yapo daw no Parisyo kan Sadosyo,” binata ni Jesos dyira. ");
INSERT INTO ivb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ki do dawri, naawātan dan nanawhen naw a iya sawen abaw yapwaw a pamarin so tinapay batabatahenaw ni Jesos dyira, ta iya sawen inanawo daw no Parisyo kan Sadosyo. ");
INSERT INTO ivb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Do kapakarapit daw da Jesos do sakop no idi a Sesarea Pilipos, inyahes ni Jesos dyirad nanawhen naw a kāna, “Sigon do aktokto dan tawotawo, sino kono bata da a maynamot dyaken a Tawo a yapod hanyit?” ");
INSERT INTO ivb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Initbay da dya a kon da, “Na, binata daw no kadwan a imo kono si Juan a Mamonyag a minirwa nabyay, kan myan paw nakabata sya a imos Elyas. As siraw kadwan saw, ki batahen daw a imo si Jeremyas mana asa ka kono a propīta ni Āpo Dyos do kaychowa.” ");
INSERT INTO ivb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Ki inyo,” binata ni Jesos dyira, “sino ako do kapangtokto nyo?” ");
INSERT INTO ivb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ki initbay ni Simon Pedro a kāna, “Namna! Taywaran dya imos Kristo, iyaw Anakaya no sibibyay a Dyos?” ");
INSERT INTO ivb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ki initbay ni Jesos dya a kāna, “Magasat kam Simon a anak ni Jonas! Tawo abaw nakayapwan nawri a inbahey mo, an dya si Āmang kod hanyit nangibahey so nawri a oyod a myan dyimo. ");
INSERT INTO ivb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","No mabata ko dyimo, ki Pedro kaya, as no hapotayan bato, ki patnekan konchis iglisya ko, as kan abaken naba polos no kadiman. ");
INSERT INTO ivb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Itoroh konchi dyimo tolbek saw no pagtorayan Āpo Dyos, kan aran āngo a baywan mod tanaya, ki baywan nanchin Āpo Dyos do hanyit. Akma saw a aran āngo a ipalōbos mod tanaya, ki ipalōbos nanchin Āpo Dyos do hanyit.” ");
INSERT INTO ivb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Do nakatayoka naw a nangibahey so nawri dyira, ki inmandar na dyirad nanawhen naw a dyi da ibahebahey a iya, ki si Kristo. ");
INSERT INTO ivb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Do dawri, insiknan ni Jesos mangipakatoneng dyirad nanawhen na saw a kāna, “Machita mangay ako do Jerosalem kan aro pasaren ko daw a panglidyalidyat da dyaken siraw panglakayen saw, siraw matotohos saw a papadi, as kan siraw mangnanawo saw so linteg. Dimanen danchi yaken, ki makarahan iyaw tatdo a karaw, ki mirwa akonchi a mabyay.” ");
INSERT INTO ivb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Do dawri, pinachibawa ni Pedro so dēkey si Jesos, as nakapaydabdab na sya a kāna, “Ay samna, Āpo! Taywaran palobosan Āpo Dyos nawri? Polos anchi a dya maparin dyimo komwan ah!” ");
INSERT INTO ivb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ki inidit ni Jesos, as nakabata na syad Pedro a kāna, “Komaro ka dyam Satanas! Imo asa manengseng do rarahan ko, ta nawryayaw iktokto mo chakey no tawotawo; iyabayaw chakey no Dyos!” ");
INSERT INTO ivb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Do dawri, binatan Jesos dyirad nanawhen naw a kāna, “No aran sino a makey a monot dyaken, ki machita a penpenen naw chakey na, isabhay naw kros na, as kawnot na dyaken. ");
INSERT INTO ivb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ta no sino a mangipateg so byay nad tanaya, alit na mabo na. Ki no tawo a madiman a maynamot do kapanganohed na dyaken, myan anchiw byay na abos pandan a itoroh anchi no Dyos dya. ");
INSERT INTO ivb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ta aryoriw magon-gona no tawo a madyira na tabo iyaw no myan do lobongaya, ki mabo naw byay na abos pandan do impyirno? Polos! Mana, aryoriw maitoroh no asa tawo a panadi so byay na? Polos! ");
INSERT INTO ivb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ta mahay paba, ki maybidi akonchi a Tawo a Yapod Hanyit kontodo siraw anghilis saw, kan mangipaboya ako so dayag ni Āmang ko. As kāda asanchi, ki gon-gonaan ko sigon do pinarin na. ");
INSERT INTO ivb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Oyod nyaya ibahey ko dyinyo a siraw kadwan saya dyinyo a maytēnek dya sichangori, ki madiman sabanchi a mandad kaboya da dyaken a Tawo a Yapod Hanyit a mapaboya do pagtorayan ko,” binatan Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nakapakarahanaw no anem a karaw, inhap ni Jesos sa Pedro, Santiago, kan si Juan a kakteh ni Santiago a sirā lang, kan somnonget sa do asaw a matohos a tokon. ");
INSERT INTO ivb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Do nakapakarapit daranaw daw, nyiknyinan a nagbalbaliw inawanaw ni Jesos do salapen daw, kan mamoyat mostra na a akmay araw, as makapoyat laylay naw do oltimo a kaydak na. ");
INSERT INTO ivb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Sinpangan na, nagparang dana sa Moyses kan Elyas, kan myan sa machisarsarita di Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ki binata ni Pedro di Jesos a kāna, “Āpo, ay, angwa kagāsat no kayan taya dya! An chakey mo, maganay ngata an mamarin akos tatdo a bengbeng dya: asa dyimo, asad Moyses, kan asad Elyas.” ");
INSERT INTO ivb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ki myan pa maychiychirin si Pedro, ki nyiknyinan a inabongan sa no demdem, kan myan timek a yapod demdemaw a naychirin a kāna, “Iyaw nyaw Anak ko a oyod kos chadaw. Oltimo a mahwahok ako a maynamot dya. Adngeyen nyo ibahey na!” ");
INSERT INTO ivb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ki do nakadngey daw so chirinaya, taywaraw nakamo dan nanawhen naw, as kan naysasakeb sa do tana. ");
INSERT INTO ivb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ki naypasngen si Jesos dyira, as nakasalid na sira, as nakabata na sya a kāna, “Maybangon kamo, as kan mamo kamwaba ah!” ");
INSERT INTO ivb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ki do nakatangay daw, abaw matarek a naboya da, an dyas Jesos a maychatanyi. ");
INSERT INTO ivb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Sinpangan na, do kawsok daranaw, inbilin Jesos dyira a kāna, “Ibahey nyo abaw naboya nyowaya do aran sino a mandanchan kapagongar ko a Tawo a Yapod Hanyit.” ");
INSERT INTO ivb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ki do dawri, inyahes dan nanawhen naw di Jesos a kon da, “Na, āngo paro batan da sya no mangnanawowaya so linteg a machita manma mangay si Elyas sakbay a mangay si Kristo?” ");
INSERT INTO ivb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","“Naon,” initbay ni Jesos. “Kosto nawri a kapangnanawo da a mangay a manmas Elyas, kan pagsagānaen naw aktokto dan tawotawo. ");
INSERT INTO ivb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ki ibahey ko dyinyo a nangay danas Elyas, kan nailasin daba, basbāli a pinarin da dyaw aran āngo a chinakey da. Ki komwan anchiw parinan da dyaken a Tawo a Yapod Hanyit.” ");
INSERT INTO ivb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ki do dawri, naawātan dan nanawhen naw a si Juan a Mamonyag batabatahen naw dyira. ");
INSERT INTO ivb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Do nakapaybidyaw ni Jesos kan siraw tatdwaw a kinayrayay na do katawotawowan, nangay asaw a mahakay a naydogod do salapenaw ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Binata nad Jesos a kāna, “Mo Āpo, chāsim paw baro kwaw a abos arang, ta komsiksiwaw kan taywara danaw a kalidyat na, kan masanyibaw a masday do apoy kan ranom. ");
INSERT INTO ivb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Inyangay kwaw dyirad nanawhen mwaw, ki mapapya dabaw.” ");
INSERT INTO ivb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Do dawri, initbay ni Jesos dyira a kāna, “Ay samna! Inyo a kapotōtan a abos anohed kan madyido so pangtoktwan, anchan āngo kapanganohed nyo a aran nahay ako na minyan dyinyo? Mango pas kahay kaan-anos ko dyinyo? Iyangay nyo pa dyaw adekeyaw.” ");
INSERT INTO ivb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Do dawri, pinaydabdab ni Jesos marahetaw a ispirito, ki komnaro do adekeyaw, kan nanyeng a napyan adekeyaw. ");
INSERT INTO ivb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Sinpangan na, nahay abas dēkey, sililimed saw nanawhen naw a nangay di Jesos, as nakaiyahes da sya a kāna, “Āngo ta napaksyat namen abaw marahetaw a ispirito?” ");
INSERT INTO ivb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ki binatan Jesos dyira a kāna, “On, ata, iyaw kadēkeyayan anohed nyo. Ta ibahey ko dyinyo oyod a an myan kapanganohed nyo a akmas kadēkeyaw no botoh no mostasa, maparin nyo a ibahey do dya tokon a, ‘Komaro ka, as mangay ka daw,’ ki syirto a mayadis anchi. On, maparin nyonchi a parinen aran āngo, ki basta manganohed kamo.”  ");
INSERT INTO ivb_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","“Ki no kapaksyatan no nya kitan marahet a ispirito, ki maparin lang maynamot do kapaydasal kan kapagayonar.” ");
INSERT INTO ivb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Do kapaychipeh daranaw no nanawhen na saw do Galilya, binatan Jesos dyira a kāna, “Yaken a Tawo a Yapod Hanyit, ki mahayak paba maiparawat dyirad tawotawo a omdiman dyaken. ");
INSERT INTO ivb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ki aran komwan, mirwa akonchi a mabyay do chatatdo naw a karaw.” Ki do dawri, taywaraw nakapagmamayo dan nanawhen naw. ");
INSERT INTO ivb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Do nakangay da Jesos do Kapernaom, nangay sad Pedro magsingsingir saw so bwis dad Timplo, as nakayahes da sya dya a kon da, “Magbayadoriw maistro nyowayas bwis nad Timplo?” ");
INSERT INTO ivb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“On,” binata ni Pedro dyira, as nakasdep nad bahayaw. Ki sakbay a ibahey nad Jesos maynamot do dawri a inyahes da, binatan Jesos dya a kāna, “Āngo mabata mom Simon? Sino magbayad so bwis dyirad āri sayad lobongaya, sirawriw myan do pamilya da saw mana siraw kadwan?” ");
INSERT INTO ivb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ki initbay ni Pedro, “Na, siraw kadwan saw.” Dawa, binata ni Jesos dya a kāna, “An komwan, machita pawri a magbayad saw anak? ");
INSERT INTO ivb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ki chakey taba a myan kaynyin aktokto dan nya tawotawo, dawa, mangay ka mamasid do minangaw. As iyaw manōmaw a mapasidan mwa among, ki paytagadahen mo dangoy naw. Maboya monchi daw asaw a plata a manawob a pagbayad tas bwis ta. Ahapen mo, as kangay mwa magbayad so bwis ta yaten a dadwa.” ");
INSERT INTO ivb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ki do dawri, naypasngen saw nanawhenaw ni Jesos, as nakaiyahes da sya a kon da, “Sino kasisitaan do pagtorayan ni Āpo Dyos?” ");
INSERT INTO ivb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Sinpangan na, nanawag si Jesos so adekey, as nakapatēnek na sya do kahahatangan daw, as kan binata na dyira a kāna, ");
INSERT INTO ivb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“No ibahey ko dyinyo, ki oyod. Makasdep kamo abanchi a polos do pagtorayan no Dyos, an dyi nyo a tadyan kapangtokto nyo, as kan mayparin kamo a akmas siras adedekey saw. ");
INSERT INTO ivb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Aran sino a mapakombaba a akmas nya adekey, ki iyaw kasisitaan do pagtorayan no Dyos. ");
INSERT INTO ivb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","No aran sino a mangrawat so mabodis so saad a akmas nyaya adekey a maynamot do kapanganohed na dyaken, yaken rawaten na,” binatan Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Do dawri, tinongtong ni Jesos naychirin a kāna, “No aran sino a mangsolisog tan makagatos aran asa lang dyirad nyaya mawnged pa so kapanganohed dyaken, ki maganaganay pa adayo an mapaytanan so rakoh a bato a gilingan lagaw naw, as kaitapwak na do karahman tāw. ");
INSERT INTO ivb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Makasyāsyiw tawotawo do lobongaya maynamot do kārwayan pakasolisogan da! Sigorado a mangay saw nya pakasolisogan, ki kapakāsi pan tawowaw a pakayapwan dan nyaya! ");
INSERT INTO ivb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“As dawa, an tanoro mana kokod mwaw pakayapwan kapaygatos mo, akteben mo, as kaipoha mo sya. Maganaganay an pokol mana piday ka a somdep do hanyit kan iyaw myanaw dadwa tanoro mana dadwa kokod mo a maitapwak do yanan apoy a dya mawsepan. ");
INSERT INTO ivb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Masaw an iyaw mata mwayaw pakayapwan kapaygatos mo, hawhawen mo, as kaipoha mo sya. Maganaganay a bolsek ka a somdep do byay a abos pandan kan myanaw so dadwa mata a maitapwak do impyirno a yanan abos pandan a apoy.” ");
INSERT INTO ivb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Tinongtong ni Jesos naychirin a kāna, “Chiban nyo, ta iroromen nyo abaw aran asa dyirad nya saya adedekey, ta ibahey ko dyinyo a siraw anghil saw do hanyit a mangaywan sira, ki nāw da do salapen ni Āmang kod hanyit.  ");
INSERT INTO ivb_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ta yaken a Tawo a Yapod Hanyit, ki iyaw nyaw nangayan ko dya lobong tan isalākan ko saw nabo. ");
INSERT INTO ivb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Āngo mabata nyo an myan asa tawo a myan so asa gasot a karniro, as naiwawaw asa? Syimpri, karwan na saw sasyam saw a poho kan sasyam do pagaraban dad songesonget, as kangay na maychichwas so naiwawaw. ");
INSERT INTO ivb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","On, ibahey ko dyinyo oyod a do kaboya na sya, ki rakorakoh anchiw soyot na do naiwawaw kan siraw sasyamaw a poho kan sasyam a dya naiwawa. ");
INSERT INTO ivb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Komwan si Āmang nyod hanyit. Chakey naba myan mabo a aran asa lang akmas nya saya adedekey,” binatan Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Sinpangan na, binata ni Jesos a kāna, “An makagatos dyimo kakteh mo, mangay ka dya, as kaibahey mo dya so nakagatosan naw. Ki parinen mo an dadwa kamo lang ah. An mangadngey dyimo, as naychapya kamo, ki napabidi mo naw kapaysit nyo. ");
INSERT INTO ivb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ki an dyi naymo a adngeyen, ki manghap kas asa mana dadwa rarayay mo tan tabo ichirin mo dya, ki mapaneknekan a maynamot ta masaksyan dadwa mana tatdo. ");
INSERT INTO ivb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ki an dyi naynyo a adngeyen, ki ibahey mo na do salapen iglisya. Ki an alit na dyi na pa adngeyen iglisya, ibidang nyo naw nawri a kakteh a asa dya manganohed mana asa magsingsingir so bwis.” ");
INSERT INTO ivb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Binata pan Jesos, “Ibahey ko dyinyo oyod. Aran āngo a baywan nyod tanaya, ki baywan nanchin Āpo Dyos do hanyit. Akma saw a aran āngo a ipalōbos nyod tanaya, ki ipalōbos nanchin Āpo Dyos do hanyit. ");
INSERT INTO ivb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Pirwahen ko na ibahey dyinyo a an pagtonosan dadwa dyinyo do tanayaw kapangdakdaw nyo di Āmang kod hanyit, ki itoroh nanchi dyinyo. ");
INSERT INTO ivb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ta aran dino yanan dadwa mana tatdo dyinyo a masalasalap a maynamot do kapanganohed nyo dyaken, ki myan akonchi daw a machirayay dyinyo.” ");
INSERT INTO ivb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Sinpangan na, nangay si Pedro di Jesos, as nakaiyahes na sya dya a kāna, “Mo Āpo, maypipira makagatos dyaken kakteh ko, as kapagsardeng ko na mangpakawan sya? Maypapitori?” ");
INSERT INTO ivb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ki binatan Jesos dya a kāna, “Tod aba papito lang, an dya maypapito a poho kan papito. ");
INSERT INTO ivb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ta no pagtorayan no Dyos, ki maipariho do pagtorayanaya no asaya āri a chakey naw machikwinta dyirad opisyalis naw. ");
INSERT INTO ivb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Do kayan naranaw a mangisiknan so machikwinta, ki naiyangay dyaw asaw a opisyal a nakaōtang dya so minilmilyon a kwarta. ");
INSERT INTO ivb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ki do dawri, abaw manawob a pagbayad na. Dawa, inbilin no āryaw a ilāko da tabo warawara no opisyalaw kontodo inawan na kan kapamilyaan na tan makabayad. ");
INSERT INTO ivb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ki naydogod opisyalaw do salapenaw no āryaw, as nakabata na sya dya a kāna, ‘Anōsan mo pa yaken, mo Āpo, ata, bayādan konchi a tabo ōtang kwaw dyimo.’ ");
INSERT INTO ivb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","“Ki taywaraw nakāsi syan āpo naw, kan pinonas naranaw tabo ōtang naw, as nakapayam narana sya a abos ōtang. ");
INSERT INTO ivb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Sinpangan na, do nakapakahtot naranaw no opisyalaw, nadongso naw kapayngay naw a opisyal a nakaōtang dya so asa lang a gasot a dinaryo. Ki ginamātan na, as nakapseh na sya, as nakasingir na syad ōtang naw a kāna, ‘Bayādan mo naw ōtang mwaw sichangori!’ ");
INSERT INTO ivb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ki naydogod nakaōtangaw, as nakapagpakpakaāsi na dya a kāna, ‘Anōsan mo pa yaken ah, ata, magbayad akonchi dyimo.’ ");
INSERT INTO ivb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ki polos a dyi na chināsi, as basbāli a inpabahod na a mandan makabayad do ōtang naw. ");
INSERT INTO ivb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Ki do nakaboya daw no rarayay na saw a opisyalis so nyaya a naparin, taywara nariribokan sa. Dawa, yay da inbahey di āpo daw no naparinaya. ");
INSERT INTO ivb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Do dawri, inpatawag no āryaw opisyalaw a pinakawan na so ōtang, as nakabata na sya dya a kāna, ‘Taywara kayas karahet a tobotoboyen! Inpabāyad kwaba dyimo tabo ōtang mwaw maynamot ta nachichāsi ka. ");
INSERT INTO ivb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Na, āngo ta chināsi mwabaw rarayay mwaw a akmas nakāsi kwaw dyimo.’ ");
INSERT INTO ivb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“Do dawri, taywara nakasoliw āryaw. Inpabahod naw opisyalaw kan nalala a mandan makabayad so tabo ōtang naw. ");
INSERT INTO ivb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Komwan anchiw parinen Āmang kod hanyit do katakatayisa dyinyo, an dyi nyo a pakawanen nakagatos dyinyo a yapo do makatayrahem a kapangtokto nyo,” binata ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Do nakatayokaw ni Jesos a nangibahey syaw, komnaro dana do Galilya, as nakangay nad probinsya a Jodya do kabtangaw no Oksong a Jordan. ");
INSERT INTO ivb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ki reprep saw tawotawo a minonot dya, as kan pinapya na saw maganyit saw daw. ");
INSERT INTO ivb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ki do dawri, naypasngen di Jesos kadwan saw a Parisyo tan sooten da do kapanahes da dya a kon da, “Ipalobosori no linteg kapasyay no mahakay so kabahay na do kompormi a pamosposan?” ");
INSERT INTO ivb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ki binatan Jesos dyira a kāna, “Nabāsa nyo abawriw do Masantwan a Tolas a no pinarin Napaytawo do nakapamarswa na, ki pinarin na sa mahakay kan mabakes? ");
INSERT INTO ivb_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","As binataw no Dyos do dawri a kāna, ‘Dawa, nyaw paynamotan na a karwan mahakay āmang kan ānang na an machikabahay. Tan komwan, komplito kapayrapa da kan baket na, as kan sira dadwa, ki mayparin dana sa asa bayo a pamilya.’ ");
INSERT INTO ivb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Dawa, dadwa pa sabanchi, ta asa dana sa. As dawa, no pinayrapan Dyos a pinayparin a asa, dyi pakono a paysyayen tawo.” ");
INSERT INTO ivb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ki inatbay dan Parisyowaw a kon da, “Na, āngo ta inbilin Moyses a torohan no mahakayaw baket naw so tolas a pakaboyan a sira, ki naysyay sa?” ");
INSERT INTO ivb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ki tinbay san Jesos a kāna, “On, maynamot do katwayan oho nyo, nawriw inpalobōsan ni Moyses so nawri a kapasyay nyo so baket nyo. Ki do nanman pan araw, ki abaw komwan. ");
INSERT INTO ivb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ki no bata ko dyinyo a no aran sino a mapasyay so baket na, as mangabahay so matarek, ki makagatos so kapachikamalala, malaksid an masawek baket naw.” ");
INSERT INTO ivb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ki binata dan nanawhen naw, “An komwan dana a dyi da mapaysyay maychabahay, maganaganay dana an abo danaw mangabahay.” ");
INSERT INTO ivb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ki binatan Jesos dyira a kāna, “On, iyaw nya nanawo a dya pangabahayan, ki maparin aba rawaten tabon tawotawo, an dya siraw tawowaw a tinorohan no Dyos so komwan a kapangtokto. ");
INSERT INTO ivb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ta myan matatarek a paynamotan dya pakakabahayan mahahakay. Myan dya makakabahay a maynamot ta nakayanakan daw kayan kōrang no kamahakay da, as myan saw dya makakabahay maynamot ta nakapon sa. As siraw kadwan, ki maynamot do kakey da a magsirbi lang do Dyos. An sino makatongpal syay a nanawo, ki onotan na pakono.” ");
INSERT INTO ivb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Sinpangan na, do asa karaw, myan saw tawotawo a nangyangay di Jesos so adedekey da tan palapawan nas tanoro na kan paydasal na sa. Ki pinaydabdab da san nanawhen naw do dawri a parinen da. ");
INSERT INTO ivb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ki binata ni Jesos dyira a kāna, “Palobosan nyo saw adedekey saya a mangay dyaken, kan baywan nyo saba, ta siraw akma syay a adedekey akin dyira so pagtorayan no Dyos.” ");
INSERT INTO ivb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ki do nakatayoka naw a napalapaw so tanoro na kan nangbindisyon sira, komnaro do dawri. ");
INSERT INTO ivb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Do naypisa, nangay di Jesos asaw a mahakay, as nakabata na sya a kāna, “Mo Maistro, āngo maganay a machita a parinen ko tan madyira ko byay a abos pandan?” ");
INSERT INTO ivb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ki binata ni Jesos dya a kāna, “Āngo ta yahes mo dyaken maynamot do maganay? Myan asa lang a maganay, si Āpo Dyos. An chakey mo byay mwa abos pandan, tongpalen mo saw bilbilin na.” ");
INSERT INTO ivb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ki inyahes na, “Āngo saw nawri a bilin?” Ki initbay ni Jesos a kāna, “Mangdiman kaba, machikamalala kaba, manakanakaw kaba, mangipaneknek kabas bayataw. ");
INSERT INTO ivb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Magdayaw ka dyirad inyapwan mo, as kan chadaw nyo kapayngay mo a tawo a akmas kadaw mo so inawan nyo.” ");
INSERT INTO ivb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ki binatan mahakayaw a kāna, “Na! Tinongtongpal ko na sa tabo nyaya bilbilin, ki āngo paw pagkorāngan ko?” ");
INSERT INTO ivb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ki binatan Jesos dya a kāna, “An chakey mwa abo kōrang mo, yangay mwa ilāko kinabaknang mwaw, as kaitoroh mo sya dyirad mapopobri saw so naglakwan mwaw tan myan anchiw kinabaknang mod hanyit. Katayoka na, monot ka dyaken.” ");
INSERT INTO ivb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ki do nakadngeyaw syan mahakayaw, nagmamayo a komnaro daw a maynamot ta taywaras kabaknang. ");
INSERT INTO ivb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Sinpangan na, binatan Jesos dyirad nanawhen naw a kāna, “No ibahey ko dyinyo, ki oyod. Oltimwaya a malidyat kasdep no mabaknang do pagtorayan no Dyos. ");
INSERT INTO ivb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","On, pirwahen ko na ibahey dyinyo a maydaydamnay kapayhawos no binyay a kamilyo do wayan rayem kan kasdep no mabaknang do pagtorayan no Dyos.” ");
INSERT INTO ivb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ki taywaraw nakasdaaw dan nanawhen naw do nakadngey daw syaw, as nakaiyahes da sya dya a kon da, “Na, an komwan, sino dana paronchiw maisalakan?” ");
INSERT INTO ivb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ki pinerreng san Jesos, as nakabata na sya dyira a kāna, “Maparin aba polos no tawo nyaya do aran āngo a pamosposan. Ki no Dyos, maparin na a parinen aran āngo.” ");
INSERT INTO ivb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Sinpangan na, tominbay si Pedro a kāna, “Namna! Maypāngo kami na? Kinarwan namen dana saya tabo do nakawnot namenaya dyimo, ki āngo gon-gona namen?” ");
INSERT INTO ivb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ki binatan Jesos dyira a kāna, “Ibahey ko dyinyo oyod a anchan napabayo danaw lobongaya, as kan naydisna ako a Tawo a Yapod Hanyit do makaskasdaawaw a pagtorayan ko, ki aran inyonchi, ki maydisna kamonchi do katakatayisa a trono nyo. On, inyo a nanawhen ko a minonot dyaken, maydisna kamonchi do asa pohwaw kan dadwa trono a mangitoray siras asa pohwaw kan dadwa tribo no Israel. ");
INSERT INTO ivb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","As no aran sino a omkaro so bahay na, kakakteh na saw mana inyapwan na, anak na saw mana tana na a maynamot do kapanganohed na dyaken, ki masorsorok panchi kan ginasgasot rawaten na kan iyaw kinarwan naw, kan myan panchiw byay na abos pandan. ");
INSERT INTO ivb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ki aro saw nanmanma sichangori a maybadiw a manawdyinchi, kan myan saw nanawdyi a manmanma anchi.” ");
INSERT INTO ivb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Tinongtong ni Jesos naychirin a kāna, “Maiyarig pagtorayan ni Āpo Dyos do tawowaw a akin dyira so asaw a bengkag a kaobāsan. Asa karaw, minhep a minohbot a nangay a naychichwas so tangdanan na a maytarabako do kaobāsan naw. ");
INSERT INTO ivb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nachitolag dyirad tawotawo saw a tangdanan na so asa kwarta a dinaryo, as katoboy na sira a maytarabako do kaobāsan naw. ");
INSERT INTO ivb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Do kaalas nwebi, nangay a minidibidiw akin kaobāsanaw do plasa, ki naboya na saw tawotawo saw a maychatetēnek a abos chabalay. ");
INSERT INTO ivb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Binata na dyira a kāna, ‘Mangay kamo a maytarabako do kaobāsan kwaw, ta tangdanan konchi nyo so kostwaw a panangdan.’ ");
INSERT INTO ivb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Dawa nangay sa. Ki do kaalas dosi kan ālastres naranaw, ki minohbot akin kaobāsanaw, kan nangay dana naychichwas. ");
INSERT INTO ivb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ki do kakalo naranaw a ālassingko, nangay danad plasa, as kan do nakaboya naw so kadwan pa saw a maychatetēnek a ditā da daw, inyahes na dyira a kāna, ‘Āngo ta maychasaryan kamwaya mangronot so oras nyo a abos chabalay?’ ");
INSERT INTO ivb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ki inatbay da a kon da, ‘On, ata, abaw paytarabakwan namen, as dawa.’ “Do dawri, binata no akin kaobāsanaw dyira a kāna, ‘Ngay, mangay kamo, ta maytarabako kamod kaobāsan kwaw.’ ");
INSERT INTO ivb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ki do kapaysarisari naranaw, binatan akin dyiraw so kaobāsanaw do matalek naw a tobotoboyen na a kāna, ‘Tawagan mo na saw naytarabakwaya, ta tangdanan mo na sa. Ki panmahen mo saw nanawdyaw a mandad siraw nanmaw a somindep ah.’ ");
INSERT INTO ivb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Ki do dawri, tinorohan na sa, siraw somindepaw do ālassingko so asa kwarta a dinaryo a tangdan da. ");
INSERT INTO ivb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ki do kaitoroh naranaw so tangdan daw no nanomaw a naytarabako, hahawen da a arwaro tangdan da, ki engga, ta nachipariho a asa dinaryo tangdan da dyirad nanawdyi saw a nangay. ");
INSERT INTO ivb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Dawa, do nakarawat daw so tangdan daw, dinabadabay daw napaytarabakwaw sira. ");
INSERT INTO ivb_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Binata da dyirad akin kaobāsanaw a kon da, ‘Asaya kaoras lang nakapaytarabako dan nanawdyi saya, ki pinapariho mwayaw tangdan dad tangdan namenaya a yamen, ki nakakāsi kami a naychasaryan a nakohakohatan.’ ");
INSERT INTO ivb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ki binatan akin dyiraw so kaobāsanaw do asaw dyira a kāna, ‘Namna! Sit, komwan kaba, ata, taywaran dyi ta nagtolag kabekas a nawri lang tangdan mo? Dawa, batahen mwaba madi ako. ");
INSERT INTO ivb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Apen mo naw tangdan nyowaya, ta mayam kamo na. Sigon do chakey ko ah, an pinapariho ko tangdan dayan nanawdyi saya do tangdan nyowaw. ");
INSERT INTO ivb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ta apabawriw toray kod kwarta ko a manoroh do chakey kwa torohan? Mana omapal kamori maynamot do kadadam kwaya?’ binata no akin dyiraw so kaobāsanaw.” ");
INSERT INTO ivb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Sinpangan na, binata ni Jesos a kāna, “Manmanma sanchiw nanawdyi, as manawnawdyi sanchiw nanma.” ");
INSERT INTO ivb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Sinpangan na, do kayan daw a somonget a mangay do Jerosalem, pinachibawa san Jesos dosi saw a nanawhen na, as nakapachisarita na dyira. ");
INSERT INTO ivb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Adngeyen nyo,” kānan Jesos. “Somonget ta do Jerosalem, ki do dawri maiparawat akonchi a Tawo a Yapod Hanyit dyirad matotohos saw a papadi kan siraw mangnanawowaw so linteg. Ikeddeng danchi yaken a madiman, ");
INSERT INTO ivb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","as kan iparawat danchi yaken dyirad dyaw a Jodyo tan oyawen danchi yaken, sapsaplitan danchi yaken, as kan ipailansa danchi yaken do kros. Ki makarahan tatdo a karaw, mirwa akonchi a mabyay.” ");
INSERT INTO ivb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sinpangan na, naypasngen di Jesos si baketaw ni Sebedeo a ānang da Santiago kan Juan. Myan paw anak na saw a dadwa. Naydogod do salapenaw ni Jesos a nangdaw dya. ");
INSERT INTO ivb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ki binatan Jesos dya a kāna, “Āngo chakey mo?” Binatan ānang daw a kāna, “Ikeddeng mo pakono a machipaydisna sanchiw dadwaya a anak ko dyimo do pagtorayan mo: no asa do mangketaw do kawanan mo, as no asa do mamangketaw do kaholi mo.” ");
INSERT INTO ivb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ki binatan Jesos dyira a kāna, “Chapatak nyo abayaw akdawen nyowaya. Maibtoran nyoriw kalidyatan a akmanchis pasaren kwaw?” Ki initbay da dya a kon da, “Naon, maparin namen.” ");
INSERT INTO ivb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Do dawri, binatan Jesos dyira a kāna, “On, ibtoran nyonchiw kalidyatan a akmas kalidyatan kwaw anchi, ki yaken abaw mamidi an sinonchiw maydisnad kawanan ko kan do kaholi ko, ta si Āmang konchiw manoroh siras insagāna naw.” ");
INSERT INTO ivb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ki do nakadngey daw no asa poho saw a rarayay da so nyaya, nakasolyan da saw dadwa saya a maykakteh. ");
INSERT INTO ivb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ki tinawagan sa tabo ni Jesos nanawhen naw, as nakabata na sya dyira a kāna, “Chapatak nyo a siraw mangitoray so tawo do lobongaya, ki adipenen da saw itorayan daw. As siraw āpohen daw, ki itorayan da saw tawotawo da saw. ");
INSERT INTO ivb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ki dyi pakono a komwan parinen nyo. No magkalikagom a iyaw torayen, machita iyaw magsirbi dyinyo. ");
INSERT INTO ivb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","As no magkalikagom a iyaw katotorayan, ki machita paadipen dyinyo. ");
INSERT INTO ivb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Toladen nyo pakono yaken a Tawo a Yapod Hanyit, ta nangay akwaba dya a pagsirbyan tawotawo, an dya yaken magsirbi dyira. On, nangay ako a madiman tan isalākan ko saw tawotawo.” ");
INSERT INTO ivb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ki do kakaro daranaw do idi a Jeriko, reprep saw tawotawo a minonot di Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","As do kayam daw, myan saw dadwa a bolsek a mahahakay a maydisna do payisaw no rarahan. Do nakadngey daw sya a myan si Jesos a homabas, inyagagay da a kon da, “Kapotōtan Āri Dabid, chāsi mo pa yamen!” ");
INSERT INTO ivb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ki pinaydabdab da san tawotawowaw, kan inbahey da a magolimek sa, ki alit a naypataywaraw nakaiyagagay da sya a kon da, “Mo Āpo a Kapotōtan ni Āri Dabid, chāsim pa yamen!” ");
INSERT INTO ivb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Do dawri, nagsardeng si Jesos do kayam naw, as nakatawag na sira, as nakaiyahes na sya a kāna, “Āngo chakey nyo a parinen ko dyinyo?” ");
INSERT INTO ivb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ki binata da dya a kon da, “Mo Āpo, chakey namen a makaboya kami pakono!” ");
INSERT INTO ivb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ki chināsi san Jesos, dawa, sinalid naw mata daw, ki nyeng sa nakaboyaw bolsek saw, kan minonot dana sa di Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Do nakapaypasngen daw do Jerosalem, do kasngen daranaw do tokonaw a mayngaran so Olibo, do masngenaw do idi a Betpage, nanoboy si Jesos so dadwa dyirad nanawhen naw. ");
INSERT INTO ivb_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Binata na dyira a kāna, “Mangay kamo do masngenaya a idi do bitaw no rarahan, as kan do kapakarapit nyo daw, insigīda maboya nyonchiw naigalotaw a asno a myan so orbon. Obayan nyo sa, as kaiyangay nyo sira do dya. ");
INSERT INTO ivb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","An myan mangyahes dyinyo, ibahey nyo a ‘Machita sa ni Āpo,’ as kan nyeng na sanchi a palobosan.” ");
INSERT INTO ivb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Naparin nyaya tan natongpal inpadtwaw no propīta a kāna, ");
INSERT INTO ivb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ibahey nyo dyirad tawotawo do Jerosalem a kon nyo, ‘Īto iyaw kangay dyinyo no Āri nyowaya! Mapakombaba kan nakasakay do orbon no asno.’” ");
INSERT INTO ivb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Do dawri, nangay saw dadwaya nanawhen na, kan tinongpal daw naibaheyaya ni Jesos dyira. ");
INSERT INTO ivb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Sinpangan na, inyangay daw asnwaw kan orbon naw do yananaw ni Jesos. Pinaap-ap da saw kagay daw, as nakapagsakay ni Jesos do orbonaw. ");
INSERT INTO ivb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Do dawri, namolay saw kārwan dyirad reprep saw a tawotawo so kagay dad rarahanaw. Siraw kadwanaw, ki namisapisang sas sangasangaw no kayokayo, as nakaparasay da syad ayamanaw ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ki siraw myanaw do panmanaw kan siraw myanaw do panawdyanaw ni Jesos, ki inngengengey da a kon da, “Madaydayaw Kapotōtan Āri Dabid! Maitoroh pakono bindisyon do tinoboyaya ni Āpo Dyos a pinakainawan na! Madaydayaw si Āpo Dyos do katotohosan a hanyit!” ");
INSERT INTO ivb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ki do kasdepaw ni Jesos do Jerosalem, naringgoran kan nasdaawan saw tawotawowaw do syodadaya. Binatabata da a kon da, “Sino paro nyaya?” ");
INSERT INTO ivb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ki inatbatbay dan kadwan saw a tawotawo a kon da, “Iyaw, ki si propīta a si Jesos a taga Nasaret do Galilya!” ");
INSERT INTO ivb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Do nakapakarapit daw do Jerosalem, somindep si Jesos do atataw no Timplowaw. Sinpangan na, pinahbot na tabo saw maglaklakwaw kan siraw magatgatangaw daw. Pinasakeb na saw lamisaan saw no manatadi saw so kwarta, as kan kinwan na saw bangko da saw no maglaklāko saw so kalapāti. ");
INSERT INTO ivb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","As pinaydabdab na sa a kāna, “Naitolas do Masantwan a Tolas a kāna, ‘No bahay ko, ki matawagan anchi so yanan a paydasalan.’ Ki inyowaya, ki pinayparin nyowaya bahay dan manakanakaw!” ");
INSERT INTO ivb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Sinpangan na, nangay saw bolsekaw kan logpi saw di Jesos do Timplowaw, as kan pinapya na sa. ");
INSERT INTO ivb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ki nakasoli saw matotohos saw a papadi kan siraw mangnanawowaw so linteg do nakaboya daw so makaskasdaawaw a pariparinen na kan iyaw kapangyagagay daw no adedekey do atat no Timplowaya so dāyaw da dya a kon da, “Madaydayaw Kapotōtan Āri Dabid!” ");
INSERT INTO ivb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Dawa, siraw matotohos saw a papadi kan siraw mangnanawowaw so linteg, ki binata dad Jesos a kon da, “Madngey mo chirichirinen dayan adedekey saya?” “Naon,” binata ni Jesos. “Na, nabāsa nyo abawriw myanaw do Masantwan a Tolas a kāna, ‘Imom Āpo, ki nanawhen mo saw adedekey kan tagibi a maychirin so oyod a pagdaydayaw’?” ");
INSERT INTO ivb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ki do dawri, minohbot sa Jesos, as nakakaro nad syodadaw, as nakangay na minisan do idyaw a Betanya. ");
INSERT INTO ivb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ki do kamabekas danaw do kapaybidi daw da Jesos do syodadaw a Jerosalem, ki naptengan. ");
INSERT INTO ivb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Do dawri, nakaboya si Jesos so kayo a igos do payisaw no rarahan. Dawa, yangay na chiniban an myan asi na. Ki do nakapakarapit naw, abaw naboya na, an dyi lang a iyaw bohong naw lang. Ki maynamot ta abaw naboya ni Jesos a asi na, inbahey na a kāna, “Abo pakononchi a polos asi mo!” Do dawri, nanyeng a nahayo igosaw. ");
INSERT INTO ivb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ki nasdaawan saw nanawhen naw do nakaboya daw so nawri a naparin, kan inyahes da dya a kon da, “Ay samna! Maypāngo a nanyeng a nahayo kayowaya?” ");
INSERT INTO ivb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ki initbay ni Jesos dyira a kāna, “No ibahey ko dyinyo, ki oyod. An myan kapanganohed nyo, as abo polos kapagmangamanga nyo, maparin nyonchiw akmas pinarin kwaya do kayowaya. On, nawri aba lang, an dya aran mamandaran nyo nyaya tokon a kon nyo, ‘Makatkat ka pakono dya a maipatapwak do tāw,’ ki parinen nanchiw ibahey nyowaw. ");
INSERT INTO ivb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","As dawa, aran āngo a akdawen nyo do dasal nyo, maitoroh anchi dyinyo an myan kapanganohed nyo.” ");
INSERT INTO ivb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ki do dawri, naybidi si Jesos do Timplowaw. Ki do kadama naw a mangnanawo daw, nangay sa dyaw matotohos saw a papadi kan siraw panglakayen da saw no Jodyo, as nakaiyahes da sya a kon da, “Iyaw pinarin mwaya kakoyab do Timplowaya, ki dino nanghapan mos toray, kan sino nangmandar dyimo a omparin siras syay?” ");
INSERT INTO ivb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ki tominbay si Jesos dyira a kāna, “Sakbay a atbayen ko, ari paw iyahes ko dyinyo. Ta an matbay nyo, ayket, atbayen ko iyahes nyowaya dyaken an sino nanoroh so toray ko a mamarin siras nyaya. ");
INSERT INTO ivb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Dino nakayapwan torayaw ni Juan a Mamonyag a mangbonbonyag: yapo do Dyos mana yapod tawo?” Ki do dawri, nagsisinopyat sa, kan naysin-aatbay sa do katakatayisa dyira a kon da, “Āngo itbay ta? An ibahey ta a, ‘Yapod Āpo Dyos,’ iyahes nanchyori dyaten an āngo ta dyi ta nanganohed di Juan? ");
INSERT INTO ivb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ki an batahen tawri a, ‘Yapod tawo’? Aysa! Engga ah, ta makamwamomo saw tawotawowaw, ata, nanganohed sa tabo di Juan Mamonyag a iya, ki asa propīta no Dyos.” ");
INSERT INTO ivb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","As dawa, no initbay dad Jesos, ki “Chapatak namen aba.” Sinpangan na, binata ni Jesos dyira a kāna, “Na, an komwan, ibahey kwaba dyinyo an āngo toray ko a mamarin so akma siras nya.” ");
INSERT INTO ivb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ki inbahey ni Jesos dyiraw nya pangarig a kāna, “Āngo mabata nyo do dya? Myan saw dadwa maykakteh a mahahakay, ki nangay āmang daw do matonengaw, as nakabata na sya, ‘Barok, mangay ka pa a maytarabako sicharaw do kaobāsan taw.’ ");
INSERT INTO ivb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Ki kānan baro naw a, ‘Makey akwaba.’” Ki nahay abas dēkey, as nakapagbabāwi na, dawa, nangay. ");
INSERT INTO ivb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Sinpangan na, nangay āmangaw do adyenaw no matonengaw a anak na, as nakabata nas inbahey naw do matonengaw. Ki ‘On mo Āmang, mangay ako,’ binata na, ki nangay aba.” ");
INSERT INTO ivb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ki inyahes ni Jesos dyira a kāna, “Sino paro dyirad dadwa saya baro naw nangtongpal so inbaheyayan āmang da?” Ki binata da, “Na, syimpri iyaw matonengaya.” Dawa, binatan Jesos dyira, “No ibahey ko dyinyo, ki oyod a siraw magsingsingiraw so bwis kan siraw mababakesaw a maglaklāko so asi, ki manmanma sanchi a somdep do pagtorayan ni Āpo Dyos kan inyo. ");
INSERT INTO ivb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ta nangay si Juan dyinyo tan inanawo naw oyod a rarahan, ki inanohdan nyo aba. Ki siraw magsingsingiraw so bwis as kan siraw maglaklakwaw so asi, ki inanohdan da. Ki inyo, aran naboya nyo naw kapagbabāwi da, ki alit na pa dyi kamo a magbabāwi kan manganohed dya.” ");
INSERT INTO ivb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ki tinongtong ni Jesos naychirin a kāna, “Adngeyen nyo asa paya pangarig. Myan asa āpohen a naymoha so aro a obas do kaobāsan naw, kan dinibon na a inahadan. Nakapamarin na pa so rakoh a yanan pamīsan na kan angangaw a bato a pangapyan na so asoyaw no ipaates naw. Sinpangan na, napatnek pas bengbeng a pagbantayan na. Do katayoka naranaw, inpaābang na dyirad pinagbantay naw, as nakapagbyahi na. ");
INSERT INTO ivb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Do chimpo danaw no kapaychamomolas, tinoboy no nagpaābangaw siraw tobotoboyen naw a mangay dyirad nangipaabāngan naw tan mangay a manghap so binglay naw. ");
INSERT INTO ivb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ki siraw nangipaabānganaw, tiniliw da saw tinoboy naw, as nakamalo da so asaw dyira, as diniman daw asaw, kan inagsigsidan daw chatatdo daw. ");
INSERT INTO ivb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","“Ki minirwa nanoboy akin kaobāsanaw so arwaro kan nanoma saw a tobotoboyen, ki pinarin daranaw akmas pinarin daw dyirad nanomaw. ");
INSERT INTO ivb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Ki do dawri a naparin, tinoboy na dyiraw anak naw, kan binata na a kāna, ‘Ay! Syirto a anyiben daw anak kwaya.’ ");
INSERT INTO ivb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Ki do nakaboya daw so anakaw no akin kaobāsanaw sya, nagtotolagan da a kon da, ‘Iya danaw nyayaw mangtawidaw so kaobāsanaya. Ngay, yangay ta dimanen tan dyaten danaw kaobāsanaya!’ ");
INSERT INTO ivb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","“Sinpangan na, tiniliw da, as nakaipoha da sya do gaganaw no kaobāsan, as nakadiman da sya.” ");
INSERT INTO ivb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Do dawri, inyahes ni Jesos dyira a kāna, “Dawa, anchan mangay iyaw akin dyiraw so kaobāsanaya, āngo nchiw parinen na dyirad nangipaabāngan naw?” ");
INSERT INTO ivb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ki binata da dya a kon da, “Syimpri, dimanen na sanchi a abo polos kāsi na dyirad mararahet saw a pinaabāngan na so kaobāsan naw, as kaipaābang nanchi sya do matarek a siraw manorohaw dyas binglay na do maapit daw a asin obas.” ");
INSERT INTO ivb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Binata ni Jesos dyira a kāna, “Nabāsa nyo abawri a polos myanaw do Masantwan a Tolas a kāna, ‘Iyaw nawri a bato a inpoha dan mapatnek saw so bahay, ki nayparin a iyaw kasisitaan a bato a mangpayit so nawri a bahay. Iyaw nyaw pinarin no Dyos, kan taywara maganay kan makaskasdaaw do kapakaboya ta’? ");
INSERT INTO ivb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Dawa, ibahey ko dyinyo a mapakaronchi dyinyo pagtorayan no Dyos, as maitoroh anchi dyirad makatongpalaw so chakey no Dyos.  ");
INSERT INTO ivb_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","As no madodog do nyaya a bato, mapotopotot anchi. Ki aran sino a matopakan na, pitahen nanchi.” ");
INSERT INTO ivb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ki do nakadngey daw no matotohosaw a papadi kan siraw Parisyowaw so pangarigaw ni Jesos, ki naawātan da a chinirichirin naw nyaya a pachikontra na dyira. ");
INSERT INTO ivb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Dawa, pinadas da a ipatiliw. Ki aran komwan, namo sa dyirad tawotawowaw, ata, anohdan dan tawotawo saw a asa propīta no Dyos si Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ki minirwa dana nagpangarig si Jesos dyirad tawotawo saw. ");
INSERT INTO ivb_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Binata na a kāna, “Maiyarig paw pagtorayan ni Āpo Dyos do asaya āri a nangisagāna so kasaran maynamot ta magkasar anak naw a mahakay. ");
INSERT INTO ivb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tinoboy na saw tobotoboyen naw a manawag siras rinara na saw do pagkasaran naw, ki nakey saba nangay. ");
INSERT INTO ivb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Dawa, minirwa nanoboy so kadwan pa saw a tobotoboyen na, kan inbilin na dyira a kāna, ‘Ibahey nyo pa dyirad rinara kwaw a nakasagāna dana tabo. Naparti dana saw pinataba ko a baka ko, kan nahoto dana saw ichan. Dawa, basta mangay dana sa.’ ");
INSERT INTO ivb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ki inkaskaso daban rinara naw, basbāli a tinongtong da do sigodaw a plano da. Nangay asa do talon na, as no kadwan, ki nangay do pagnigosyowan naw. ");
INSERT INTO ivb_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ki siraw kadwan saw, ki tiniliw da saw tobotoboyen no āryaw, as nakalidyalidyat da sira, kan nakadiman da sira. ");
INSERT INTO ivb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Ki taywaraw nakapakasoli no āryaw, dawa, tinoboy na saw soldado naw a nangdiman siras nangdimanaw siras tobotoboyen naw, as nakaipasosoh nas idi daw. ");
INSERT INTO ivb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Do dawri, binatan āryaw dyirad kadwan pa saw a tobotoboyen na a kāna, ‘Naisagāna danaya tabo para do pagkasaran, ki polos a dyi dana sa maikariw rinara kwaw. ");
INSERT INTO ivb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Dawa, mangay kamod kalkalsāda, ta rarahen nyo sa tabo maboya nyo a tawo, ta mangay sa machakan do dya pagkasaran.’ ");
INSERT INTO ivb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","“Dawa, nangay saw tobotoboyen naw do kalkalsāda, as rinara da sa tabo naboya da tawo, marahet kan maganay so dadakay. Do dawri, nakapno sad pagkasaranaw. ");
INSERT INTO ivb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ki do kasdepaw no āryaw a mangay a manyideb siras nangayaw daw, ki naboya naw asaw a tawo a dya nakalaylay so pachikasar. ");
INSERT INTO ivb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ki inyahes no āryaw dya a kāna, ‘Hoy, mo Sit! Maypāngo kasdep mo dya, an dyi ka naylaylay so laylayaw a gagāngay an mangay kad pagkakasaran?’ “Ki naylilyak abaw mahakayaw. ");
INSERT INTO ivb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Sinpangan na, binatan āryaw dyirad magsirsirbi saw daw a kāna, ‘Tiliwen nyo nya mahakay, as karimpong nyo sya, as kan kapaksyat nyo syad mamansokelaw a kasarisaryan a yanan dan tomanyitanyis saw kan mayngaletnget a tawotawo do lidyat da.’” ");
INSERT INTO ivb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sinpangan na, binata pan Jesos a kāna, “Aro matawagan, ki papere lang pidyen no Dyos a makasdep do pagtorayan na.” ");
INSERT INTO ivb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Do katayoka no nawri, komnaro saw Parisyo saw, as nakapagtotolag da an maypāngo kasdok das Jesos maynamot do kapanahahes da. ");
INSERT INTO ivb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Dawa, tinoboy da saw kadwan saw a nanawhen da kan kadwan saw a nanawhen ni Āri Herodes a mangay a manahahes di Jesos. “Mo Maistro,” binata da, “chapatak namen a tabo a ichirin mo, ki oyod. Abaw matarek a inanawo mo, an dyi lang a iyaw oyodaw a chakey no Dyos a parinen tawotawo. Chapatak namen pa a mangidomdoma kaba, kan itatārek mo sabaw matohos so saad. ");
INSERT INTO ivb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Dawa, ibahey mo pa dyamen an āngo myan do aktokto mo. Maikontrawri do linteg iyaw kapagbayad namen so bwis do impirador do Roma mana engga?” ");
INSERT INTO ivb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ki nadlaw ni Jesos marahetaw a plano da dya, kan binata na dyira a kāna, “Inyo a maysinsīsingpet, āngo ta sooten nyo yaken? ");
INSERT INTO ivb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ipaboya nyo pa dyaken plata nyowaw a pagbayad nyos bwis nyo.” Do dawri, tinorohan das plata. ");
INSERT INTO ivb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ki inyahes ni Jesos dyira, “Sino akin ladawan kan akin ngaran syay?” ");
INSERT INTO ivb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ki initbay da, “Nas Impirador.” Do dawri, binata ni Jesos dyira a kāna, “Dawa, an komwan, itoroh nyod Impirador dyira naw, as itoroh nyo do Dyos dyira naw.” ");
INSERT INTO ivb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ki do nakadngey daw so nyaya, ki nasdaawan sa. Sinpangan na, kinarwan das Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ki do dawri pa a araw, myan saw nangay di Jesos a yapod gropo dan Sadosyowaw a siraw Jodyo saw a makabata a dya mirwa mabyay nadiman. Inyahes da dya a kon da, ");
INSERT INTO ivb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Maistro, innanawowaw ni Moyses a kāna, ‘An madiman iyaw asa mahakay a myan so kabahay, as abo paw pōtot na, machita ahapen a kabahayen kakteh naw bālwaw a ipag na tan potōtan na so pinakaanak no kakteh naw a nadiman.’ ");
INSERT INTO ivb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","“An komwan linteg, āngo mabata mo do dyaya pangarigan? Myan saw papito a makakakteh a mahahakay do idi namenaya. Iyaw matonengaw, ki nangabahay, as kan sakbay a myan pōtot na, nadiman. Dawa, kinabahay no adyen naw iyaw bālwaw. ");
INSERT INTO ivb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ki komwan naparin dya a nadiman a abos pōtot. Masaw, naparin do chatatdo daw a nandad nakadiman da a tabo a papito a abos pōtot. ");
INSERT INTO ivb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Do kapanawdyanaw, nadiman mabakesaw. ");
INSERT INTO ivb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","“Dawa, an komwan,” inyahes dan Sadosyowaw di Jesos, “anchan araw a kapagongar, sinonchi dyirad papito saya makakakteh iyaw akin kabahay so nya mabakes, ta kinabahay daya a tabo?” ");
INSERT INTO ivb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ki initbay ni Jesos dyira a kāna, “Samna! Matikaw kamo, ta maawātan nyo abaw naitolasaw do Masantwan a Tolas, as kan maawātan nyo abayaw panakabalin no Dyos! ");
INSERT INTO ivb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ta anchan mirwa mabyay tawotawo a nadiman, ki mangabahay pa sabanchi daw, ta akma dana sanchis anghil saw do hanyit. ");
INSERT INTO ivb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ki an maynamot do kapirwa mabyay no nadiman, nabāsa nyo abawriw binataw no Dyos dyinyo a kāna, ");
INSERT INTO ivb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Yaken, ki yaken Dyos daw da Abraham, Isaak, kan Jakob’? No chakey na batahen, ki iyabaw Dyos no nadiman, an dya iyaw Dyos no sibibyay.” ");
INSERT INTO ivb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ki do nakadngey daw no tawotawowaw so nawri, nasdaawan sa do komwanaya a kapangnanawo na. ");
INSERT INTO ivb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ki do kadngey daw no Parisyo saw a dyi da natbay no Sadosyowaw si Jesos, ki naychipeh sa a nagtotolag. ");
INSERT INTO ivb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ki do dawri, myan asa abogado a rarayay da, kan pinadas na sooten si Jesos maynamot do nakapanahes na dya. ");
INSERT INTO ivb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Maistro,” binata na di Jesos, “āngo kasisitaan a bilin do linteg taya a Jodyo?” ");
INSERT INTO ivb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ki binata ni Jesos dya a kāna, “‘Machita chadaw nyo Āpo a Dyos nyo do tābo poso nyo, tābo katawo nyo, as kan tābo aktokto nyo.’ ");
INSERT INTO ivb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Iyaw nawriw manma kan kasisitaan a bilin. ");
INSERT INTO ivb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ki no somarono a kasisitaan, ki nyaya: ‘Machita chadaw nyo kapayngay nyo a tawo a akmas kadaw nyo so inawan nyo.’ ");
INSERT INTO ivb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Siraw nya dadwaw nangornos so tabo Linteg ni Moyses kan intolas da saw no tabo a propīta.” ");
INSERT INTO ivb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ki do nakapaychipeh paw daw no Parisyo saw, inyahes ni Jesos dyira a kāna, ");
INSERT INTO ivb_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Āngo mabata nyo maynamot do Kristo? Āngo a kapotōtan iyaw pakayapwan na?” Ki binata da dya, “Yapod kapotōtan Āri Dabid.” ");
INSERT INTO ivb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ki inyahes dana ni Jesos dyira a kāna, “Na, āngo ta sigon do inpaltiingaw no Ispirito Santo di Dabid, ki tinawagan nas Kristo so Āpo na? Binata na a kāna, ");
INSERT INTO ivb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Binata ni Āpo Dyos di Āpo ko: “Maydisna ka do kawanan kwaya a mandad kaābak ko siras kabosor mo saya, kan ipapitapita ko sad kokod mwaya.”’ ");
INSERT INTO ivb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“An tawagan ni Dabid so ‘Āpo,’ maypāngo nakahtot ni Kristo do kapotōtan Dabid?” ");
INSERT INTO ivb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ki aba polos naitbay da, as kan somniknan do dawri, apabaw makaitored a manahes di Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Sinpangan na, binatan Jesos dyirad tawotawo saw kontodo nanawhen na saw a kāna, ");
INSERT INTO ivb_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Myan karbengan dan mangnanawo sayas linteg kan Parisyo saya a manginanawos Lintegayan Moyses. ");
INSERT INTO ivb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Dawa, onotan nyo tabo a ibahey da a parinen nyo. Ki aran komwan, ki tahatahan nyo abaw dadakay daw, ta iyaw inanawo dāya, ki parinen daba. ");
INSERT INTO ivb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tod da sa lidyalidyaten saw tawotawo do nakaipasabhay daw dyira so mararahmet saya a linteg da. Ki aran komwan, polos a dyi sa machipaysabhay dyira so aran akmay dedeng. ");
INSERT INTO ivb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nawri lang chagaget daw kapaysin-gaganay da a mangipaboya dyirad tawotawo so pariparinen daw tan myan pagdayawan da. Dawa, payparakohen daw akmaw kodibot a pangapyan da so intolas da a yapod Masantwan a Tolas, as kaibedbed da syad moyen daw kan kaholyaw a pongopongwan da. Asa pa, pinanaro daw baroyboy saw do kagay da saw a pangipaboyan da sya do tawotawo a akma say masisita a tawo. ");
INSERT INTO ivb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nawriw chadaw daw madadayaw saw a yanan dan matotohos saw so saad do paspasken saw kan siraw kasisitaan a disnan do sinagoga da saw. ");
INSERT INTO ivb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Imāsen da paw mapadayawan a kabkablaawan no tawotawo do plasa kan matawagan so ‘Maistro.’ ");
INSERT INTO ivb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ki inyo, ipalōbos nyo aba matawagan kamo so ‘Maistro,’ ta makakakteh kamo, as kan myan dyinyo asa lang a Maistro. ");
INSERT INTO ivb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tawagan nyo abas ‘Āmang’ aran sino do lobongaya, ta asaw Āmang nyo a iyaw Dyos a myan do hanyit. ");
INSERT INTO ivb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mana chitahen nyo abaw matawagan so ‘Āpo,’ ta asa lang Āpo nyo a si Kristo. ");
INSERT INTO ivb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","No magkalikagom a iyaw torayen machita iyaw magsirbi dyinyo. ");
INSERT INTO ivb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ta aran sino a mapatohos so inawan na, ki masnekan anchi, as iyaw mapakombaba, ki maypatohos anchi. ");
INSERT INTO ivb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Aysa! Kapakāsi nyo pa, inyo a mangnanawo so linteg kan inyo a Parisyo, ta maysinsīsingpet kamo! Ta inyo mangbalat so asdepan a mangay do pagtorayan Āpo Dyos tan dyi sa somdep tawotawo. Imbes a somdep kamo, ki engga, basbāli a ipalōbos nyo abaw tawotawo a somdep.  ");
INSERT INTO ivb_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Kapakāsi nyo pa, inyo a mangnanawo so linteg kan inyo a Parisyo, ta maysinsīsingpet kamo! Allilawen nyo pa saw babbālwaw a mababakes tan madyira nyo bahabahay da, as kapaydasal nyo so manaro a pangoliwlib nyos kaparin nyowaw. As dawa, marahrahmet anchiw dosa nyo. ");
INSERT INTO ivb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kapakāsi nyo pa, inyo a mangnanawo so linteg kan inyo a Parisyo, ta maysinsīsingpet kamo! Magbibyahi kamo kan mangangay kamo do matatarek saw a nasyon a mapawnot so aran asa lang a mayparin a nanawhen nyo. As an myan napawnot nyo, ki payparinen nyo a mangamangay pa kan inyo a madosa do impyirno. ");
INSERT INTO ivb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kapakāsi nyo pa, inyo a bolsek a mangipangolo! Inanawo nyo a kon nyo, ‘An magkariw asa tawo, ki masisita aba a tongpalen naw kari na an nawri lang pagkari naw Timplo. Ki ad-adda masisita a tongpalen na an nawriw pagkari naw balitokaw do Timplo.’ ");
INSERT INTO ivb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Samna! Inyo a bolsek a abos arang! Āngo masissisīta? Iyawriw balitokaw mana iyaw Timplowaw a mapayparin so balitokaw a masisita? ");
INSERT INTO ivb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Inanawo nyo pa a kon nyo, ‘An magkariw asa tawo do altar, ki masisita aba a tongpalen naw nawri a kari na. Ki an pagkari naw dāton naw do altaraw, ki nawriw masisita tongpalen na kari na.’ ");
INSERT INTO ivb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Bolsek kamwaya a taywaras kasalanga! Āngo masissisīta? Iyawriw dātonaw mana iyaw altaraw a mapayparin so dātonaw a masisita? ");
INSERT INTO ivb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Dawa, an pagkari no tawo altaraw, ki iyaba lang altaraw pagkari na, an dya nairaman danaw dātonaw. ");
INSERT INTO ivb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","An pagkari no tawo Timplowaw, ki iyaba lang Timplowaw pagkari na, an dya iyaw Dyos a minyan daw. ");
INSERT INTO ivb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","As an pagkari no asa tawo hanyit, nairaman danaw tronwaw no Dyos kan si Āpo Dyos a mismo a maydisna daw. ");
INSERT INTO ivb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kapakāsi nyo pa, inyo a mangnanawo so linteg kan inyo a Parisyo, ta maysinsīsingpet kamo! Chagaget nyo a itoroh apagkapollo no āpit nyo kan apagkapollo dan rikado saya a dedekey, ki parinen nyo abayaw kasisitaan saya a chakey no linteg a akmas kaparin nyos kosto dyirad kapayngay nyo a tawo, kāsi, kan kapanganohed do Dyos. Siraw nyayaw kasisigoradwan a manōma parinen nyo sakbay no kapagtongpal nyo so kadwan. ");
INSERT INTO ivb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Inyo a bolsek a mapawnot so tawo, taywarayaw kaannad nyo, ta aran akmayaw tongaw a lapos, ki sitsiten nyo a ipoha, ki āngo ta maboya nyo sabaw akmaya so karakoh no nwang a gatos? ");
INSERT INTO ivb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kapakāsi nyo pa, inyo a mangnanawos linteg kan inyo a Parisyo, ta maysinsīsingpet kamo! Ta oyasan nyo lang hapot no bāso kan pinggan nyo, ki do irahem, napekpek kamwaya so kaāgom kan kakōsit. ");
INSERT INTO ivb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Aysa! Inyo a bolsek a Parisyo, panmahen nyo a oyasan do irahem no bāso nyo a maipariho do pangtokwan nyo tan madalos panchiw hapot naw. ");
INSERT INTO ivb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kapakāsi nyo pa, inyo a mangnanawo so linteg kan inyo a Parisyo, ta maysinsīsingpet kamo! Akma kamoy tanem a aschip a napintoran so maydak. Mapintas so hapot, ki makabābaba do irahem, ta napno so tohatohang no nadiman saw kan nahta saw a bangkay. ");
INSERT INTO ivb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Masaw a mapaboya kamod tawotawo a akmay maganay so kaparin, ki napno irahem nyo so kapaysinsīsingpet kan aro pa a klasi no marahet.” ");
INSERT INTO ivb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kapakāsi nyo pa, inyo a mangnanawo so linteg kan inyo a Parisyo, ta maysinsīsingpet kamo! Patneken nyo saw mapipintas saw a tanem dan propīta saw, kan pintasen nyo tanem dan malinteg saw a tawo. ");
INSERT INTO ivb_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Batahen nyo pa a, ‘An myan kami sawen do chimpo daw no aāpong namen saw, ayket, nachipangdiman kami aba siras propīta saw.’ ");
INSERT INTO ivb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Dawa, an komwan bata nyo, ayket, pagatosen nyo inawan nyo, ta ipaboya nyo a inyo dana kapotōtan daw no nangdiman saw siras propīta saw. ");
INSERT INTO ivb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Sigi, apnohen nyo gatos saw a insiknan da no aāpong nyo saw. ");
INSERT INTO ivb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Pi! Mayarig kamo do boday, kan akma kamwayaw anak no marem a masisikap! Maypāngo a maditchanan nyo kalidyatan do impyirno? ");
INSERT INTO ivb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Dawa, toboyen ko sanchi dyinyo siraw propīta ko, siraw masisiribaw a tawo, kan siraw maganay a mangnanawo so chirin no Dyos. Dimanen nyo sanchiw kadwan dyira, kan ilansa nyo sanchid kros kadwan. As siraw kadwan saw, ki saplitan nyo sanchi do sinagoga nyo saw, kan lakatan nyo pa sanchi do idiidi a lidyalidyaten. ");
INSERT INTO ivb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Parinen konchiw nya tan rebbeng nyonchiw madosa a maynamot do nakadimanaya so tabo malinteg a tawo do lobongaya a somniknan do nakadimanaw ni Abel a abos gatos a mandad nakadimanaw ni Sakaryas a anak ni Barakyas a diniman kapoonan nyo do payawan no Masantwan a Yanan kan altar. ");
INSERT INTO ivb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","No ibahey ko dyinyo, ki oyod a rawaten nyonchi a tawotawo do dya kapotōtan kapagdosa dan kapoonan nyo saw a maynamot do tabo marahet a pinarin da.” ");
INSERT INTO ivb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ki binata na pan Jesos nyaya a kāna, “Ay-ay pīman, inyo a tawotawo do Jerosalem, ta diniman nyo saw propīta saw, as kan inagsidan nyo sas bato natoboy saw dyinyo a tobotoboyen no Dyos! Naypipira dana chakey koynyo a paychipehen a akmas kakhebaw no manok so pyek na saw, ki makey kamo abaya! ");
INSERT INTO ivb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Dawa, sichangori, nonolay narana inyo no Dyos. On, nonolay naw syodad nyo kan Timplo nyo a mararayaw. ");
INSERT INTO ivb_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","No ibahey ko dyinyo, ki polos a dyi nyo nanchi yaken a mirwa a maboya a mandan marapit chimpo a kabata nyonchi sya a, ‘Madaydayaw kan maitoroh pakono bindisyon do tinoboyaw ni Āpo Dyos a pinakainawan na.’” ");
INSERT INTO ivb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Minohbot si Jesos do Timplo. Ki do kapakabawa naranaw, naypasngen saw nanawhen naw dya, kan inpadlaw da dyaw matatarek saw a tominek do dawri a Timplo. ");
INSERT INTO ivb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ki binatan Jesos dyira a kāna, “On, maboya nyo sa tabo nyaya sichangori. Ki ibahey ko dyinyo no oyod a apabanchi a polos matokos a machidket a bato do yanan daya sichangori, ta malasanchi a tabo.” ");
INSERT INTO ivb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Sinpangan na, somnonget sa Jesos do tokonaw a mayngaran so Olibo. Do nakapaydisna naw, naypasngen sa dyaw nanawhen naw a sira lang, as nakaiyahes da sya a kon da, “Ibahey mo pa dyamen an kangonchiw kaparin dan nyaya, kan maypāngonchiw pakailasinan namen so kangay mo, as kan iyaw pandan lobongaya?” ");
INSERT INTO ivb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ki initbay ni Jesos dyira a kāna, “Magannad kamo tan abo mapaychawaw dyinyo. ");
INSERT INTO ivb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Aro sanchiw mangay a mangosar so ngaran ko, kan batahen danchi a, ‘Yaken si Kristo!’ Aronchiw allilawen da. ");
INSERT INTO ivb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","As madngey nyonchiw kabtak no gobat kan damdāmag maynamot do gobat, ki mabakel kamo abanchi, ta machita maparin saw nyaya, ki chakey naba batahen a nawri danaw pandan lobongaya. ");
INSERT INTO ivb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Maggogobat sanchiw nasyon kan nasyon, as kan komwan sanchiw pagaryan kan pagaryan. Myan pa sanchiw kapaychapteng kan gin-gined do matatarek saw a logar. ");
INSERT INTO ivb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tabo siraw nya, ki pangrogyan pa no panglidyalidyat a akmas kapagpasikalaw no maymanganak. ");
INSERT INTO ivb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ki do dawri, tiliwen kan idarom danchinyo no tawotawo a lidyalidyaten, as kan dimanen da panchinyo. Ipsok danchinyo no tabo tawotawo maynamot do kapachichasa nyowaya dyaken. ");
INSERT INTO ivb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","As do dawri, aro dana sanchiw tomadyichokod do kapanganohed da dyaken. Maysin-lilipot sanchi, kan maysin-iipsok dana sanchi. ");
INSERT INTO ivb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mohtot sanchiw aro sa sinan propīta a mapaychawaw siras aro saw a tawotawo. ");
INSERT INTO ivb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","As maynamot anchi do kapayparo danayan marahet, maypakapsot dananchiw adaw no aro a tawotawo. ");
INSERT INTO ivb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ki maisalakan anchiw makaibtor so kapanganohed na mandad pandan. ");
INSERT INTO ivb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Machita maikasaba a manma iyaw Maganayaya a Dāmag a maynamot do pagtorayanaya ni Āpo Dyos do tabo nasnasyon do lobongaya tan mapaneknekan dan tabo tawotawo. Anchan tayokaw nawri, iya dananchiw kangay no pandan lobongaya.” ");
INSERT INTO ivb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Tinongtong ni Jesos naychirin a kāna, “Maboya nyonchiw ‘Makamwamomwaw a Mangrarayaw’ a maytēnek do masantwan a yanan a akmas binataw ni Daniel a propīta no Dyos kaychowa. (Inyo a makabāsa so nyaya, awāten nyo a maganay iyaw chakey na batahen!) ");
INSERT INTO ivb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Do dawrinchi, siraw myan do Jodya, machita mayyayo sanchi a somonget do katokotokonan a tomayo. ");
INSERT INTO ivb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Iyanchiw myan do papagaw no bahay na, ki dyi dana pakono a maybabalay a manghap so warawara na do irahem no bahay na a iyonot na. ");
INSERT INTO ivb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Masaw myanaw do bengkag naw, dyi dana pakono a maybidi do bahay na a mangay a manghap so pagsokatan na. ");
INSERT INTO ivb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ki piman, ta makakāsi sanchiw mabogyaw kan mapasoswaw do dawri a araw! ");
INSERT INTO ivb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Maydasal kamo do Dyos tan dyi pakono a ammyan mana do Araw a Kapaynaynahah iyaw kapayayo nyo. ");
INSERT INTO ivb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ta do dawrinchi, myan sanchiw lidyat a polos a dyi pa naparin mana dyi pa napadasan nakayapo do nakaparswa no Dyos so lobongaya a mandas changori, as kan mapirwa pabanchi a polos nyaya do masakbayan. ");
INSERT INTO ivb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ki an dya inaksayan no Dyos bidang no nawri sa araw a kalidyatan, abanchiw aran sino a mabidin a sibibyay do lobongaya. Ki maynamot dyirad tawo saw a pinidi no Dyos, chinsayan naw araw sayanchi a kayan kalidyatanaya. ");
INSERT INTO ivb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Do dawrinchi, an myan makabata sya dyinyo a kāna, ‘Chiban nyo, ari dana dyas Kristo!’ mana ‘Chiban nyo, tori aba dwadaw?’ ki manganohed kamwaba dyira. ");
INSERT INTO ivb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ta tombod sanchiw aro a sinan Kristo kan sinan propīta a mapaboya so makaskasdaaw saw a milagro kan pangancharan tan pamaychawaw da siras aro a tawotawo. On, allilawen da sanchi, an maparin, aran sira paw pinidyaw no Dyos a tawo na. ");
INSERT INTO ivb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","As dawa, kadngeyen nyo, ta naisakbay ko na sa naibahey a tabo dyinyo nya saya. ");
INSERT INTO ivb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Dawa, an batahen danchi dyinyo a kon da, ‘Yangay nyo a chiban, ta aryaw do let-ang si Kristo,’ ki mangay kamo aba daw ah. As an batahen danchi dyinyo a kon da, ‘Aryaw si Kristo a tomayotayo do irahem dya,’ ki anohdan nyo saba. ");
INSERT INTO ivb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ta akmas karanyagaw no kimat a yapod dāya a magpalaod, ki komwan kangay konchi a Tawo a Yapod Hanyit. ");
INSERT INTO ivb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Masyirto a matongpal nyaya a akmas panyinyirinaya a mabata a, ‘Aran dino a yanan bangkay, dawrinchiw kakpehan dan agila a omsitsit sya.’” Nyaw binatan Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Tinongtong ni Jesos naychirin a kāna, “Nanyeng do katayokanchi no nawri sa a araw a kalidyatan, maysarinchiw araw, kan arabanchiw sedang no bohan. Maychahesday sanchiw bitohen a yapod hanyit, as kan tabonchi do hanyit a myan so panakabalin, ki makosokoso sanchi. ");
INSERT INTO ivb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Do dawri, mapaboyanchi do hanyit iyaw pangilasinan so kapaybidi ko a Tawo a Yapod Hanyit, kan do dawrinchi, siraw tabo nasnasyon do lobongaya, ki taywaranchiw kapagmamayo da. Ta do dawrinchi, ki maboya danchi yaken a Tawo a Yapod Hanyit a mawara a pongosan no demdem a myan so panakabalin kan tan-ok. ");
INSERT INTO ivb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Sinpangan na, toboyen ko sanchiw anghilis ko, as kan do kapaylilyak anchin trompita, mangay sanchi a mangpeh siras pinidi kwaw do aran dino a seksek do intīro a lobong a yapod dāya kan laod, ammyānan kan abagātan.” ");
INSERT INTO ivb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Sinpangan na, tinongtong ni Jesos nangnanawo a kāna, “Adālen nyo nya pangarig a maynamot do kayowaw a igos: An somiknan a omlak kan tomohos, chapatak nyo na a masngen danaw rayon. ");
INSERT INTO ivb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Komwan pa dyinyo sichangori. An maboya nyonchiw katongpal no tabo nya saya kalidyatan, chapatak nyo nanchi a īto danaw kawara ko, kan mayarig do nagtoktok danaw do aneb a mapanyiwang. ");
INSERT INTO ivb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","No ibahey kwaya dyinyo, ki oyod. Myan panchi dyinyo do dyaya kapotōtan sibibyay pa do katongpal no tabo no bata ko saya. ");
INSERT INTO ivb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Iyanchiw hanyit kan tanaya, ki mabo sanchi a tabo, ki mabo abanchi a polos chirin ko.” ");
INSERT INTO ivb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“An maynamot do dawri a araw kan oras no panongpalanaya, ki aba polos makapatak sya. On, ta aran siraw anghilis do hanyit, ki chapatak daba. As aran yaken a Anak no Dyos, ki chapatak kwaba, an dyi lang a si Āmang kod hanyit moyboh a makapatak sya. ");
INSERT INTO ivb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Akmas kaparin daw no tawotawo saw do kachimpo ni Noyi, komwan anchiw kaparin dan tawotawo do kangay konchi a Tawo a Yapod Hanyit. ");
INSERT INTO ivb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","On, ta akmas sakbayaw no layos a siraw tawotawo, ki nāw da komninan kan naybobok kan naychakabahay a nandad nakasdepaw ni Noyi do biray naw. ");
INSERT INTO ivb_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ki chinapatak dabaw napariparin a nandad kayan danaw no layosaw a nangalyod sira a tabo. Komwan anchi do kangay ko a Tawo a Yapod Hanyit. ");
INSERT INTO ivb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Do dawrinchi a araw, myan saw dadwa mahahakay do bengkag, mahap anchiw asaw, ki mabidin asaw. ");
INSERT INTO ivb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Masaw a myan sanchiw dadwa mababakes a manggiling. Mahap anchiw asaw, ki mabidin asaw. ");
INSERT INTO ivb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","As dawa, sisasagāna kamo pakono ah, ta chapatak nyo abaw araw a kangay no Āpo nyo. ");
INSERT INTO ivb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ki kaawāten nyo nya: An chapatak no akin bahay iyaw orasaw a kangay no manakanakaw do bahay na an mahep, syimpri, nāw nanchi a mayokay a magsagsagāna tan dya makasdep manakanakawaw. ");
INSERT INTO ivb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Dawa, komwan kamo pakono a pirmi a nakasagāna, ta mangay akonchi a Tawo a Yapod Hanyit do dyi nyo a hahawen a oras.” Nawriw binata ni Jesos dyira. ");
INSERT INTO ivb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ki binata ni Jesos a kāna, “Iyaw mapagtalkanaw kan masirib a adipen, ki iyanchiw talken āmo naw a manyidechideb siras rarayay na saw a adipen, kan iyanchiw maminglay dyira so kanen da. ");
INSERT INTO ivb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Magasat nawri a adipen an masabatan āmo naw a madama na pariparinen inbilin naw. ");
INSERT INTO ivb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ibahey ko dyinyo oyod. Payparinen anchi no āmo naw a iya danaw mangaywan so tabo warawara na. ");
INSERT INTO ivb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ki an kaspangarigan, marahet nawri a adipen, as kan batahen na do aktokto na a kāna, ‘Mahay pa ngataw kawara no āmo kwaw.’ ");
INSERT INTO ivb_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Do dawri, nāw narana mangkabkabil siras kapayngay naw a adipen, as kapagbokbokatot kan kapachichinom na dyirad maboboken saw. ");
INSERT INTO ivb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Sinpangan na, nyeng a mawaraw āmo naw do dyi na hahawen a araw kan oras do kadama naw a mamariparin so komwan. ");
INSERT INTO ivb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ayket na! Syimpri dosāen nanchi a dimanen. On, ipanānam nanchi dyaw no dosa daw no maysinsīsingpet saw a tawotawo a yanan dan tomanyitanyis saw kan mayngaletnget a tawotawo do lidyat da,” binata ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ki do dawri, tinongtong ni Jesos nangnanawo, as kan binata na a kāna, “No kangay no pagtorayan ni Āpo Dyos, ki maiyarig anchi dyirad asa poho saya babbalāsang a nanghap so riraken da a mangay a mangbayat so mahakayaw a mangabahay. ");
INSERT INTO ivb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ki siraw dadimaw, ki masalanga sa, as siraw dadimaw, ki masisirib sa. ");
INSERT INTO ivb_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Inhap dan masalangaw paysohwan daw, ki nanghap saba so risirba da lana. ");
INSERT INTO ivb_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ki siraw masiribaw, inapno da saw paysohwan daw, as matarek paw napangayan das risirba da. ");
INSERT INTO ivb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ki maynamot ta nahay a nawaraw nobyowaw, nadoho sa, as dawa, nakaycheh saw babbalāsangaw. ");
INSERT INTO ivb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ki do kaābak no ahep, myan nangngey a kāna, ‘Ari danaw nobyowaw! Yangay nyo na bayaten!’ ");
INSERT INTO ivb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Ki do dawri, naybangon saw babbalāsangaw, as nakaisagāna da siras paysohwan da saw. ");
INSERT INTO ivb_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","“Ki siraw masalangaw, ki nanahes sas lana daw no masisiribaw a kon da, ‘Torohan nyo pa yamen so lana nyo, ta makey danaya mawsep paysohwan namenaya.’ ");
INSERT INTO ivb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ki binata dan masiribaw dyira a kon da, ‘Namna! Engga, ata, āngo nchan dya makanawob dyaten a tabo. Maganaganay an mangay kamo na gomātang so dyira nyo.’ ");
INSERT INTO ivb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Dawa, nangay sa gomnātang dadimaw so lana da. Ki do kabo da paw, nawaraw nobyowaw. Sinpangan na, nachirayay saw myanaw so lana a somindep do pagkasaranaw, as nakaneb danan pantawaw. ");
INSERT INTO ivb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ki nahay abas dēkey, nawara saw nangayaw a gomnātang so lana da, kan inngengey da a kon da, ‘Āpo, Āpo, pasdepen mo pa yamen.’ ");
INSERT INTO ivb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ki binatan nobyowaw a kāna, ‘Ay, engga! Chapapatak ko abaya inyo.’” ");
INSERT INTO ivb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Pinanawdyi ni Jesos a kāna, “Sisasagāna kamo pakono, ta chapatak nyo abaw araw mana oras a kangay ko.” ");
INSERT INTO ivb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Tinongtong ni Jesos naychirin a kāna, “Maiyarig paw pagtorayan ni Āpo Dyos do asa tawo a magbyahi. Ki do sakbayaw a kakaro na, nangitalek so warawara na dyirad tobotoboyen naw. ");
INSERT INTO ivb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Tinorohan naw asaw so dadima ribo a kwarta. As iyaw asaw, ki tinorohan nas dadwa ribo, as asa ribo do asaw. Intoroh na dyiraw hahawen naw a kabaelan da parakohen. Ki do katayoka naranaw a nanoroh dyira, nagbyahi dana. ");
INSERT INTO ivb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Iyaw nanorohan naw so dadima ribo, ki nanyeng na innigosyo, ki naiganansyaan nas akmas kārwaw no inhap naw a dadima a ribo. ");
INSERT INTO ivb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ki aran iyaw nanorohan naw so dadwa ribo, ki innigosyo na, ki nakaganansya so akmas naitorohaw dya. ");
INSERT INTO ivb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ki iyaw nanorohanaw so asa ribo, ki yangay na inlabeng iyaw kwartaw no āmo na tan itayo na. ");
INSERT INTO ivb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ki do nakahay naranaw, somnabat danaw āmo daw kan nachikwinta dyira. ");
INSERT INTO ivb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ki nangay natorohan naw so dadima ribo, kan inyangay na intoroh do āmo naw kwartaw a naitoroh dya kontodo naganansya naw a dadima ribo, as nakabata na syad āmo naw a kāna, ‘Mo Āpo, dadima ribo intoroh mo dyaken, ki sichangori, cha danaw kwarta mwaw kan iyaw ganansya mo a dadima pa ribo.’ ");
INSERT INTO ivb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Ki binatan āmo naw dya a kāna, ‘Maganayayaw pinarin mwaya, kan managtongpal kan matalek kaya tobotoboyen! Maynamot ta mapagtalkan ka do dēkey a bānag, pagaywanen konchi mos arwaro pa. Changori, somdep ka a machiraman a machipagragsak dyaken.’ ");
INSERT INTO ivb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ki do dawri, nangay natorohan naw so dadwa ribo, as nakabata na syad āmo naw a kāna, ‘Mo Āpo, dadwa ribo intoroh mo dyaken, ki sichangori, cha danaw kwarta mwaw kan iyaw ganansya mo a dadwa pa ribo.’ ");
INSERT INTO ivb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Ki binatan āmo naw dya a kāna, ‘Maganayayaw pinarin mwaya, kan managtongpal kan matalek kaya tobotoboyen! Maynamot ta mapagtalkan ka do dēkey a bānag, pagaywanen konchi mos arwaro pa. Changori, somdep ka a machiraman a machipagragsak dyaken.’ ");
INSERT INTO ivb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ki do dawri, nangay natorohan naw so asa ribo, as nakabata na syad āmo naw a kāna, ‘Āpo, chapatak kwaw a masosolyen ka. Nawryayaw chabalay mo machichami kan magranyi kayas dyi mwa inmoha, kan hapen mo dyi mwa itahep. ");
INSERT INTO ivb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Dawa, namo akwaw. Inyangay ko a inlabeng kwartaya a intoroh mo. Sichangori, cha danaw kwarta mwaya!’ ");
INSERT INTO ivb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ki do dawri, binatan āmo naw dya a kāna, ‘Oltimo kayas karahet kan kasadot a tobotoboyen! Chapatak mo naya a nawriw chabalay ko machichami kan ranyen ko aran dyi kwa inmoha, kan hapen ko dyi kwa itahep. ");
INSERT INTO ivb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","An komwan chapatak mo, rebbeng na pakono a pinasdep mo do bangko kwarta kwaw tan sakangwan myan nahap ko do kapaybidi kwayaw sigodaw a myan dyaken kontodo anak na?’ ");
INSERT INTO ivb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ki do dawri, binata no āmwaw dyirad kadwan saw a tobotoboyen na a kāna, ‘Apen nyo kwarta kwaw dya, ta itoroh nyo do myanaw so asa poho a ribo. ");
INSERT INTO ivb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ta no tawowaw a myan so mapariparin, ki arwaro maitoroh dya tan magsobra. Ki no abos mapariparin, aran iyaw dēkeyaw a myan dya, ki mapakaro panchi dya. ");
INSERT INTO ivb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","As iyaw abos sinpangan a tobotoboyen, ki apen nyo, kan paksyaten a mangay do mamansokel a kasarisaryan a yanan dan tomanyitanyis saw kan mayngaletnget a tawotawo do lidyat da.’” ");
INSERT INTO ivb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Tinongtong ni Jesos naychirin a kāna, “Anchan mangay ako a Tawo a Yapod Hanyit kontodo kabīleg kan dayag ko, kan pachirayayan ko pa sanchiw tabo anghilis ko, ki do dawrinchi, maydisna akonchid trono kwaw a magtoray. ");
INSERT INTO ivb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Mapaychichipeh sanchiw tawotawo do tabo nasyon do salapen ko, as paychapidyen ko sanchi a akmas kapaychapidyaw no magpaspastor siras karniro kan kalding. ");
INSERT INTO ivb_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Siraw malinteg a maiyarig dyirad karniro saw, ki pangayen ko sanchi do kawanan ko. As siraw maiyarig dyirad kalding, ki pangayen ko sanchi do kaholi kwaw. ");
INSERT INTO ivb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Anchan tayokaw nawri, yaken a Āri, ki batahen konchi dyirad tawotawo saw do kawanan kwaw, ‘Ngay, inyo a binindisyonan Āmang ko! Rawaten nyo pagtorayan a naisagāna dyinyo a somniknan pad nakaparswan lobongaya. ");
INSERT INTO ivb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Maynamot ta naptengan ako, ki pinakan nyo yaken. Nawaw ako, ki pinaynom nyo yaken, kan nangay ako a akmay gan-ganaet, ki pinadagos nyo yaken. ");
INSERT INTO ivb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Do kabwaw no laylay ko, ki linaylayan nyo yaken. Naganyit ako, ki sinarongkaran nyo yaken, as kan nabahod ako, ki yangay nyo yaken a sinidongan.’ ");
INSERT INTO ivb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ki atbayen danchi no malinteg saw a tawotawo a kon da, ‘Kangom Āpo, nakaboya namen dyimo a naptengan, ki pinakan namen imo, mana kāngo nakawaw mo a pinaynom namen? ");
INSERT INTO ivb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","As kāngo paw nakaboya namen dyimo a gan-ganaet, ki pinadagos namen imo, mana kāngo nakaboya namen dyimo a abos laylay, ki linaylayan namen imo? ");
INSERT INTO ivb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","As kāngo nakaboya namen dyimo a maganyit mana nabahod, ki sinarongkaran namen imo?’ ");
INSERT INTO ivb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ki yaken a Āri, ki batahen konchi dyira a kon ko, ‘Ibahey ko dyinyo oyod a an pinarin nyo naw komwan dyirad aran asa a mabobodis a kakakteh ko, bāli pinarin nyo na dyaken.’ ");
INSERT INTO ivb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Sinpangan na, ibahey konchi dyirad myanaw do kaholi kwaw, ‘Inyo a naokom dana a madosa, komaro kamo dya. Mangay kamo do abwaw so pandan a apoy a naisagāna di Satanas kan siraw anghilis na saw. ");
INSERT INTO ivb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ta naptengan ako, ki pinakan nyo aba yaken. Nawaw ako, ki pinaynom nyo aba yaken. ");
INSERT INTO ivb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Do nakangay kwaw dyinyo a akmay gan-ganaet, ki pinadagos nyo aba yaken. Do kabwaw no laylay ko, ki linaylayan nyo aba yaken. Naganyit kan nabahod ako, ki polos a dyi nyo yaken a sinarongkaran.’ ");
INSERT INTO ivb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ki atbayen danchi a kon da, ‘Kangom Āpo, nakaboya namen dyimo a naptengan mana nawaw, gan-ganaet mana abos laylay, naganyit mana nabahod a dyi namen imo a sinidongan?’ ");
INSERT INTO ivb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ki atbayen ko sanchi a kon ko, ‘Ibahey ko dyinyo oyod a an dyi nyo sa sinidongan aran asa dyirad kabobodisanaya, bāli yaken danaw dyi nyo a sinidongan.’ ");
INSERT INTO ivb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Dawa, siranchiw nyaw mangay do abos pandan a kadosa, amnan siraw malinteg saya dya, ki siraw mangay do yanan byay a abos pandan,” binata ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Do nakaibahey danaw ni Jesos so tabo nya nanawo, binata na dyirad nanawhen naw a kāna, ");
INSERT INTO ivb_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Chapatak nyo a dadwa dana karaw mapahabas, as karapit no Pista no Pakanaknakman so Nakahabas no Anghil. Ki do dawrinchi, maiparawat ako a Tawo a Yapod Hanyit, as kan mailansa akonchi do kros.” ");
INSERT INTO ivb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ki do kaibahey paw ni Jesos so nawri, naychipeh saw matotohos saw a papadi kan siraw panglakayen da saw no Jodyo do palasyowaw ni Kaypas a katotohosan a padi. ");
INSERT INTO ivb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nagtotolag sa an maypāngo kaikorimed da mangtiliw si Jesos tan dimanen da. ");
INSERT INTO ivb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ki binata da a kon da, “Maparin aba irana ta tiliwen an madamaw pista ah, ta angwan nawriw mangkiras so riribok dyirad tawotawo saw.” ");
INSERT INTO ivb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Sinpangan na, do kayan da Jesos do Betanya a idi, nangay a nagsarongkar do bahayaw ni Simon a nagliproso do nakarahan. ");
INSERT INTO ivb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ki do kadama daw a koman, naypasngen dyaw asaw a mabakes a nakaigpet so oltimo so kangina a bangbanglo a mayngaran so nardo a nakapno do praskita a alabastro, as nakapado na sya do ohwaw ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ki nakasoli saw nanawhen naw do nakaboya daw so nya a pinarin na, as nakabata da sya a kon da, “Aysa! Mangbayo nyaya. ");
INSERT INTO ivb_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Magbalor nyaya so mangina. Dyori a maganaganay an ilāko, as itoroh kwartaw dyirad mapopobri saw?” ");
INSERT INTO ivb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ki chapatak ni Jesos kadabadabay da, dawa, binata na dyira a kāna, “Inolay nyo! Āngo ta ririboken nyo mabakesaya? Oyod a maganay nawri a pinarin na dyaken. ");
INSERT INTO ivb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ta siraw pobri, ki pirmi sa myan dyinyo. Ki an yaken, manayon akwaba dyinyo. ");
INSERT INTO ivb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Pinado na dyaken bangbanglwaya tan maisagāna ko a maitanem. ");
INSERT INTO ivb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","No ibahey ko dyinyo, ki oyod a aran dino a kaikasabaan Maganayaya a Dāmag do lobongaya, ki masarsarita panchiw pinarinayan nyaya mabakes a pakanaknakman sya.” ");
INSERT INTO ivb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Sinpangan na, asa dyirad asaw a poho kan dadwa nanawhen ni Jesos a mayngaran so Jodas Iskariote, ki nangay dyirad matotohos saw a papadi. ");
INSERT INTO ivb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ki binata na dyira a kāna, “Āngo itoroh nyo dyaken an iparawat ko dyinyo si Jesos?” Ki tinorohan das tatdo a poho a plata a pirak. ");
INSERT INTO ivb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Do dawri, insiknan ni Jodas maychichwas so gondaway na a manglipot di Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Do manōmaw a araw no Pista no Tinapay a Abos Libadora, ki nangay sad Jesos nanawhen naw, as nakabata da sya dya a kon da, “Dino chakey mo a pagsagānaan namen so pangmalem ta do Pistaya no Nakahabasaw no Anghil?” ");
INSERT INTO ivb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ki binata na dyira a kāna, “Somdep kamo do syodadaya, as kangay nyo do asaw a tawo, as kaibahey nyo sya dya a kon nyo, ‘Binataw ni Maistro a narapit danaw oras, as do bahay monchiw pachipistaan na kan nanawhen na saw.’” ");
INSERT INTO ivb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Do dawri, tinongpal dan nanawhen naw inbilinaw ni Jesos dyira. Insagāna daw kanen da sigon do dadakay daw a Jodyo do pistaya a pakanaknakman so nakahabasaw no anghil. ");
INSERT INTO ivb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ki do kapaysarisari naranaw, nahahanghang sa Jesos kan siraw dosi saw a nanawhen na. ");
INSERT INTO ivb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ki do kayan daw a koman, binata ni Jesos dyira a kāna, “No ibahey ko dyinyo, ki oyod. Asanchi dyinyo manglipot dyaken.” ");
INSERT INTO ivb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ki do dawri, taywara a nagmamayo saw nanawhen naw, kan somniknan sa nagsasarono a nangyahes sya di Jesos a kon da, “Mo Āpo, yakenori?” ");
INSERT INTO ivb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ki tinbay ni Jesos a kāna, “Iyaw kinayrayay kwaya nangisawsaw so tinapay do sabakaya, ki iyanchiw manglipotaw dyaken. ");
INSERT INTO ivb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Yaken a Tawo a Yapod Hanyit, ki syirto a madiman akonchi a akmas naitolasaw do Masantwanaya a Tolas, ki kapakāsi panchi no nawri a tawo a manglipot dyaken! Maganaganay an dya nayanak nawri a tawo.” ");
INSERT INTO ivb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ki naychirin si Jodas, iyaw manglipotaw sya a kāna, “Mo Maistro, yakenori?” Ki binatan Jesos, “Nabata mo na.” ");
INSERT INTO ivb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ki do kayan daw a koman, nanghap si Jesos so tinapay, as nakapaydasal na nagyaman di Āpo Dyos. Sinpangan na, inakchikchid na a intoroh dyirad nanawhen naw, as nakabata na sya dyira a kāna, “Hapen nyo, as kan kanen nyo, ta nyaw inawan ko.” ");
INSERT INTO ivb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Sinpangan na, nanghap so asa kabaso do inomen daw, as nakapagyaman nad Āpo Dyos, as nakaiparawat na sya dyira, as nakabata na sya a kāna, “Minom kamo a tabo so nya. ");
INSERT INTO ivb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ta iyaw nya, ki raya ko a moyog anchi do kadiman ko a pangsigorādo so bayo a tolag no Dyos tan mapakawan tabo tawotawo do gatogatos da. ");
INSERT INTO ivb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ibahey ko dyinyo a mirwak pabanchi a polos a minom so palekaya no obas a mandad araw a kapachinom ko dyinyo so bayo do pagtorayan ni Āmang ko.” ");
INSERT INTO ivb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Do katayokaw no nawri, nagkankanta sa, as nakahbot da a somnonget do Tokon a Olibo. ");
INSERT INTO ivb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Do kayan da pa do rarahan, binatan Jesos dyira a kāna, “Iyaw nya ahep, ki inyo a tabo, ki payayowan nyonchi yaken a akmas naitolasaw do Masantwan a Tolas a kāna no Dyos, ‘Dimanen konchiw mangonong so karniro, as siranchiw karniro, ki maychawpit sanchi.’ ");
INSERT INTO ivb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ki anchan mirwa akwa mabyay, manmanma akonchi a mangay do Galilya kan inyo.” ");
INSERT INTO ivb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ki initbay ni Pedro dya a kāna, “Aran komaro sanchi a tabo dyimo, ki an yaken, ki engga!” ");
INSERT INTO ivb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Binata ni Jesos dya a kāna, “Ibahey ko dyimo oyod mo Pedro a do dyaya ahep, sakbay a monyiw sabongan a manok, naypitdo mo nanchi yaken a inlibak.” ");
INSERT INTO ivb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ki binata dya ni Pedro a kāna, “Aran mairaman akonchi a madiman dyimo, polos a dyi koymo a ilibak.” Komwan paw binata da tabo no nanawhen naw. ");
INSERT INTO ivb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Sinpangan na, do kawaraw da Jesos do asaw a logar a mayngaran so Getsemani, binata ni Jesos dyirad nanawhen naw a kāna, “Maydisna kamo dya, ta mangay ako dwadaw a maydasal.” ");
INSERT INTO ivb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Katayoka na nangibahey syaw, inhap na sa Pedro kan siraw dadwaw a anak ni Sebedeo, kan nachibawa sa so dēkey. Do dawri, somniknan si Jesos a magmamayo kan mariribok. ");
INSERT INTO ivb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Sinpangan na, binata na dyira a kāna, “Taywarayaw kapagmamayo ko, kan akmayaw chadiman ko. Mabidin kamo dya, ki machipagridam kamo dyaken ah.” ");
INSERT INTO ivb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Do dawri, naypabawas dēkey, as nakapaysasakeb nad tana, as nakapaydasal na a kāna, “Mo Āmang ko, an maparin, ki paditchanen mo pa yaken do kalidyatan kwaya. Ki pagayatan kwabaw matongpal, an dya iyaw chakey mo.” ");
INSERT INTO ivb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Sinpangan na, do kapaybidyaw ni Jesos do yanan daw no tatdwaw a nanawhen na, ki nadasan na sa a makaycheh. Binata nad Pedro a kāna, “Aysa! Maparin nyo abawriw machipagridam dyaken so aran asa kaoras? ");
INSERT INTO ivb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Makaridam kamo kan maydasal kamo pakono tan dyi kamo a masday do solisog. Oyod a sisasagānaw kapangtokto nyo, ki makapsot inawan nyo.” ");
INSERT INTO ivb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Katayokan nawri, naypirwa nachibawa si Jesos do paydasalan naw, as nakapaydasal na a kāna, “Mo Āmang, an dya maditdit nya, malaksid an isabhay ko nya lidyat, maparin pakono a akmas chakey mwaw.” ");
INSERT INTO ivb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ki do kapirwa naranaw a naybidi do yanan daw no nanawhen naw, myan dana sa minirwa nakaycheh, ta oyod das kadoho. ");
INSERT INTO ivb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Dawa, kinarwan dana sa ni Jesos a mirwa, as nakapaybidi na do paydasalan naw. Iyaw pitdwaya no kapaydasal na, ki akmas nakapaydasal nad dāmwaw. ");
INSERT INTO ivb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Sinpangan na, naybidi dyirad nanawhen na, as nakabata na dyira a kāna, “Ari kam pawri a makaycheh kan maynahah? Chiban nyo an dya narapit danaw orasaw, as kaiparawat ko a Tawo a Yapod Hanyit dyirad arwaw so gatos. ");
INSERT INTO ivb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Maybangon kamo na, ta may ta na. Chiban nyo, tori danaw manglipotaw dyaken!” ");
INSERT INTO ivb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Madama pa maychiychirin si Jesos do nakawaraw ni Jodas a iyaw asaw dyirad asa poho kan dadwa saw a nanawhen na. Nachirayay sa dyaw arwaw a tawotawo a nakabahayang kan nakamamalo a tinoboy dan matotohos saw a papadi kan siraw panglakayen da saw no Jodyo. ");
INSERT INTO ivb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Tinorohan ni Jodas saw nachirayayaw dya so sinyal a iyaw nyaya: “No dadek kwaw anchi, ki iyaw kadyawen nyowaya, dawa, tiliwen nyonchi.” ");
INSERT INTO ivb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Do nakapakarapit daw daw, ki taros a nangay si Jodas di Jesos, as nakabata na sya a kāna, “Oy, mo Maistro,” as nakadadek na sya. ");
INSERT INTO ivb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ki initbay ni Jesos dya a kāna, “Mo Sit, parinen mo chakey mwa parinen dyaken.” Ki do dawri, naypasngen saw tawotawowaw, kan kinamet das Jesos a tiliwen. ");
INSERT INTO ivb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ki do dawri, inasot no asaw dyirad nanawhenaw ni Jesos bahayang naw, as nakasintaw nas adipenaw no katotohosanaw a padi, kan naringodan. ");
INSERT INTO ivb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Sinpangan na, binatan Jesos dya a kāna “Pasohoten mo bahayang mwaya, ta no mangdiman so kapayngay na tawo do bahayang, ki bahayang anchiw omdiman sya. ");
INSERT INTO ivb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Chapatak mo abawri a maparin ko mangdaw so sidong ni Āmang ko, kan nyeng na toboyen nasosorok paw kan asa poho kan dadwa a bonggoy dan anghilis saw? ");
INSERT INTO ivb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ki an parinen ko komwan, maypāngo pa matongpal naitolasaw do Masantwan a Tolas a machita maparin saw nya?” ");
INSERT INTO ivb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Sinpangan na, binatan Jesos dyirad nangtiliwaw sya a kāna, “Tolisan akori? Āngo ta myan bahayang nyo kan mamalo nyo a mangay a omtiliw dyaken? Kararaw, ki nachidisdisna ako dyinyo a nangnanawo dyinyo do Timplo, ki asyo nyo yaken a pinadas a tiliwen do dawri. ");
INSERT INTO ivb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ara, naparin saw tabo nyaya tan matongpal binata daw no propīta saw do Masantwan a Tolas.” Ki do dawri, naychapayapayayo saw nanawhen naw, as ninonolay daranas Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Sinpangan na, do nakatiliw daw si Jesos, inyangay da do bahayaw no katotohosanaw a padi a si Kaypas, ta dawriw nakakpehan dan mangnanawowaw so linteg kan siraw panglakayen daw. ");
INSERT INTO ivb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ki do dawri, myan a mononot si Pedro a makabawa so dēkey, kan tod a nanda do atataw no bahay no katotohosanaw a padi. Do nakasdep naw do atataw, nachidisna dyirad gwardya saw tan chiban na an āngo mapariparin di Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","As siraw matotohos saw a papadi kan siraw tabo konsihal saw, ki nanta sas bayataw a pangpaneknek a maikontra di Jesos tan myan iyaw pakayapwan da omdiman sya. ");
INSERT INTO ivb_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ki alit na abo nachichwasan da a aran aro mabayataw saw a nangay a maychirin so maikontra dya. Ki do kahay darana a maychichwas, myan saw naytēnek a dadwa mahakay kan nangay sa do salapen daw, as nakabata da sya a kon da, ");
INSERT INTO ivb_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Binataw no nyaya tawo a maparin na kono a rarayawen Timplowaw no Dyos, as kapirwa na kono sya patneken do irahem no tatdwa karaw!” ");
INSERT INTO ivb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ki do dawri, naytēnek katotohosanaw a padi, as nakaiyahes na syad Jesos a kāna, “Oyodoriw batabatahen daya maikontra dyimo? Abawriw maitbay mo?” ");
INSERT INTO ivb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ki naylilyak aba si Jesos. Sinpangan na, pinirwa danan katotohosanaw a padi a inyahes dya a kāna, “Pagkaryen koymo do salapen sibibyayaw a Dyos a ibahey mo an imo si Kristo a Anak no Dyos.” ");
INSERT INTO ivb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ki binatan Jesos a kāna, “Nabata mo na. Ki no ibahey ko dyinyo, ki somiknan sichangori, maboya nyonchi yaken a Tawo a Yapod Hanyit a maydisna do kawanan no Dyos do hanyit a myan so panakabalin, as kan maboya nyo panchi yaken a maypābodis a yapod hanyit a mapongosan so demdem.” ");
INSERT INTO ivb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Do dawri, taywaraw nakapakasoli no katotohosanaw a padi. As dawa, pinirit naw laylay naw, as nakaibahey na sya dyirad tawotawo saw daw a kāna, “Aysa! Maddi, ta tod naya dyābat si Āpo Dyos do kapachiyengay no toray na do Dyos! Machita ta pawriw pamaneknek ta? Nadngey nyo nayaw marahet a binata na. ");
INSERT INTO ivb_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ki āngo keddeng nyo?” Ki initbay da a tabo a rebbeng naranaw a madiman. ");
INSERT INTO ivb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Do dawri, chinichipan da kan dinandanog da. As siraw kadwan saw, ki sinipsipat da. ");
INSERT INTO ivb_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Binata da dya a kon da, “Imom Kristo, tarosen mo pa an sino saw nangsipataya dyimo?” ");
INSERT INTO ivb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Do dawri, myan a maydisna si Pedro do gagan do atataw. Sinpangan na, nangay asaw a tobotoboyen a mabakes do yanan naw, as nakabata na sya dya a kāna, “Na, aran imo, syirto a imo asaw a rarayay ni Jesos a taga Galilya.” ");
INSERT INTO ivb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ki naglibak si Pedro do salapen dan tabo, kan binata na a kāna, “Wā! Abayaw chapatak kod batabatahen mwaya!” ");
INSERT INTO ivb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ki minohbot si Pedro, as nakangay nad rowanganaw, ki naboya danan asaw a matarek a tobotoboyen a mabakes, kan binata na dyirad kadwan saw a myan daw a kāna, “Iyaw nyaya tawo, ki nachirayarayayaw di Jesos a taga Nasaret.” ");
INSERT INTO ivb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Do dawri, pinirwa danan Pedro a inlibak, as pinagkari na a kāna, “Pi! Ikari kwa polos a dyi kwa chapapatak nawri a tawo.” ");
INSERT INTO ivb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nahay abas dēkey, myan saw naytēnek daw a nangay sa di Pedro, kan binata da dya a kon da, “Syirto a imo asaw dyira, ata, madlawaya do kapaychichirin mwaya.” ");
INSERT INTO ivb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Do dawri, insiknan ni Pedro nagkari a kāna, “Si Āpo Dyos danaw makatoneng an bayataw ako, ta chapatak ko abayaw nawri a tawo!” Ki do dawri, nyeng a minonyiw sabonganaw a manok. ");
INSERT INTO ivb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","As nanakem ni Pedro binataw ni Jesos dya a kāna, “Sakbay a monyiw sabonganaw a manok, ki maypitdo mo nanchi yaken a inlibak.” Ki do nakanakem naw so nawri, minohtot si Pedro, kan napenpen nabaw katanyis na. ");
INSERT INTO ivb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Do kapaysesedang naranaw, nagtotolag sa tabo matotohos saw a papadi kan siraw panglakayen da saw no Jodyo a dimanen das Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Katayokaw no nyaya, binahod das Jesos, as nakaiyangay da sya a inparawat di Pilato a gobirnador a yapod Roma. ");
INSERT INTO ivb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ki do nakaboyaw ni Jodas, iyaw nanglilipotaw sya, so nakaikeddeng daw a dimanen si Jesos, ki nagbabāwi kan pinabidi naw tatdwaw a poho a plata a pirak dyirad matotohos saw a papadi kan panglakayen saw. ");
INSERT INTO ivb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Binata na dyira, “Nakagatos ako, ta inparawat kwaya dimanen tawowaw a abos gatos.” Ki binata dan papadyaw kan panglakayen saw dya a kon da, “Abaw bibyang namen daw. Imo danaw makatoneng.” ");
INSERT INTO ivb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ki pinagsid ni Jodas kwartaw do irahemaw no Timplo, as nakahbot na a nangay a nanglodyit a nangapseh so inawan na. ");
INSERT INTO ivb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ki kinpeh dan matotohos saw a papadiw plata saw, as nakabata da sya a kon da, “Baywan naw no linteg ta a pangayen tad pangapyanaw so kwartan Timplo, ta tadiw nya no byay no asa tawo.” ");
INSERT INTO ivb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ki do dawri, napagtotolagan da a igātang das tana daw no mamariparinaw so angang tan payparinen da pagtatanman dan gan-ganaet saw. ");
INSERT INTO ivb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Dawa, napangaranan so “Tana a Nagatang do Raya” a aran mandas changori. ");
INSERT INTO ivb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Do dawri, natongpal binataw ni propīta Jeremyas do kaychowa pa a kāna, “Inhap daw tatdo a poho a plata a pirak a iyaw baloraw no napagtotolagan dan kapotōtan Israelitaw a tadin byay na. ");
INSERT INTO ivb_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","As in-gātang da so tanaw no mamariparinaw so angang a akmas nakabilinaw no Dyos dyaken.” ");
INSERT INTO ivb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Do dawri, pinaytēnek da si Jesos do salapen gobirnadoraw tan osisaen na. Inyahes na dya a kāna, “Āngo? Imoriw Āri daw no Jodyo saw?” Ki binata ni Jesos, “Nabata mo na.” ");
INSERT INTO ivb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ki do kapagatos daw sya no matotohos saw a papadi kan siraw panglakayen saw, inatbay na saba. ");
INSERT INTO ivb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Do dawri, binatan Pilato dya a kāna, “Madngey moriw kārwayan kaipagatos da dyimo?” ");
INSERT INTO ivb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ki tominbay aba polos si Jesos do aran asaw lang a ipagatos da, dawa, taywara chinaklat no gobirnadoraw. ");
INSERT INTO ivb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Do kāda Pistan Nakahabasaw no Anghil do kāda tawen, myan dadakay no gobirnador a mapakakaro so asa nabahod a tawo a aran sino a akdawen dan tawotawo. ");
INSERT INTO ivb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","As do dawri, myan asaw a magdindinamag a nabahod a mayngaran so Jesos Barrabas. ");
INSERT INTO ivb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ki do nakapaychipeh daranaw no tawotawowaw, inyahes ni Pilato dyira a kāna, “Sino chakey nyo a pakakarohen ko: si Barrabas mana si Jesos a matawagan so Kristo?” ");
INSERT INTO ivb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Binata naw nya, ta chinapatak na a maynamot do kahoho da nawriw nangidaroman das Jesos dya. ");
INSERT INTO ivb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Asa pa, ta do kapaydisna paw ni Pilato do pangokoman naw, ki myan inpabahey dya no baket naw a kāna, “Machiraman kabad malintegaya a tawo, ta natayēnep kwaw kahep, as kan oyod ko nayas kalidyat sichangori a maynamot dya.” ");
INSERT INTO ivb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ki do dawri, pinaklaklal dan matotohosaw a papadi kan siraw panglakayenaw siraw tawotawo saw tan akdakdawen da a si Barrabas danaw pakakarohen ni Pilato, as ipadiman nas Kristo. ");
INSERT INTO ivb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ki mirwa inyahes danan gobirnadoraw dyira a kāna, “Na, ibahey nyo na ah, an sino chakey nyo a pakakarohen ko dyirad dadwa saya?” Ki initbay da, “Si Barrabas!” ");
INSERT INTO ivb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ki initbay ni Pilato a kāna, “Na, an komwan, āngo parinen kod Jesos a matawagan so Kristo?” Ki nāsa sa mangingengey sya a kon da, “Ipailansa mo do kros!” ");
INSERT INTO ivb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ki binata ni Pilato dyira a kāna, “Ta āngo pa? Āngo pinarin na a gatos ta dawa?” Ki naypangay nakaiyagagay da sya a kon da, “Ipailansa mo do kros!” ");
INSERT INTO ivb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ki maynamot ta maboya ni Pilato a apabaw sirbi na an tongtongen na, basbāli a makey sa mamarin so riribok, napahap so ranom, as nakapaybanaw na do salapen tawotawo, as nakabata na sya, “Abaw bibyang ko do kadiman nyowayas nya tawo. Inyo danaw makatoneng ah!” ");
INSERT INTO ivb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ki inatbay dan tabo tawotawo saw a kon da, “Inolay mo na, ta yamen kan siraw anak namen sayaw makatoneng do kadiman nyaya tawo!” ");
INSERT INTO ivb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Do dawri, pinakakaro na si Barrabas. Ki si Jesos, inpasaplit na dyirad soldadwaw, as nakaimandar na sya dyira a ilansa da do kros. ");
INSERT INTO ivb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Do dawri, inyangay dan soldadwaw ni gobirnador si Jesos do atataw no bahayaw no gobirnadoraw, as kan chinpeh da sa tabo rarayay da saw a soldado do salapen na. ");
INSERT INTO ivb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Sinpangan na, pinakaro daw laylay naw, kan kinekehan da si Jesos so akmay mabaya so kita kan akmas kekehaw no āri. ");
INSERT INTO ivb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Namahokon sas manolok a inbalāngat das oho naw. Pinaigpetan das byawo iyaw kawanan naw a tanoro na, as nakapaydogod da do salapen na a naysindādayaw dya a kon da, “Mabyay Āri dayan Jodyo!” ");
INSERT INTO ivb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Sinpangan na, chinichipan da, as nakapohes das byawowaw a inpaigpet da dya, as nakapasimsimlod da sya do oho naw. ");
INSERT INTO ivb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Do nakatayokaw no nakapangoy-oyaw dāya, pinakaro daw pinakekeh daw dya, as nakapabidi das sigodaw a laylay na. Sinpangan na, inyayam darana a yangay a ilansa do kros. ");
INSERT INTO ivb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ki do kahbot daranaw do syodadaw, nabayat daw asaw a mahakay a mayngaran so Simon a taga Sirene. Ki do dawri, pinilit daw nya mahakay a naysabhay so krosaw ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ki nakarapit sa do logaraw a mayngaran so Golgota. No chakey na batahen, ki “Logar no Bangabanga.” ");
INSERT INTO ivb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Sinpangan na, pinadas da a paynomen si Jesos so palek a napasaglan so apdo. Ki do nakataham naw sya, ki chinakey naba a ininom. ");
INSERT INTO ivb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sinpangan na, do nakatayoka daw a nangilansa si Jesos, nagbibinglayan daw laylay na saw maynamot do nakapagbibinonot da, ");
INSERT INTO ivb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","as nakapaydisna da ombantay sya. ");
INSERT INTO ivb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Do toknolen naw, myan pinangay da a iyaw ipagatos daw dya. No naitolas, ki “IYAW NYA SI JESOS, IYAW ĀRI DAN JODYO.” ");
INSERT INTO ivb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","As myan pa saw dadwa manakanakaw a pinarayay da a inlansa do bokod da saw a kros do maybitaw ni Jesos. Iyaw asaw, ki myan do kawanan naw. As iyaw asaw, ki myan do kaholi naw. ");
INSERT INTO ivb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Siraw tawotawowaw a omhabas sya, ki inoy-oyaw da, kan naylilinlin sa a binata da a kon da, ");
INSERT INTO ivb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Samna! Imo nakabataw sya a rarayawen monchiw Timplowaw, as kapatnek mo syad irahem no tatdo a karaw! Pi! Sichangori, isalākan mo paw mismo a inawan mo. An oyod a imo danaw Anakaw no Dyos, ayket na, gomchin ka pad dawri a kros!” ");
INSERT INTO ivb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Komwan paw matotohos saw a papadi, siraw mangnanawowaw so linteg, kan siraw panglakayen saw, ki inoy-oyaw da. ");
INSERT INTO ivb_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","On, binatabata da a kon da, “Nangisalakanaya so kadwan a tawo, ki asyo naya maisalakan inawan na. An oyod a iyaw Āri dan tawotawo saw do Israel, ayket na, gomchin pakono do kros naya tan manganohed kami dya. ");
INSERT INTO ivb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","An oyod a magtalek do Dyos, kan oyod a Anak no Dyos a akmas binata naw, chiban ta pan ara ikaso no Dyos a isalākan sichangori.” ");
INSERT INTO ivb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ki aran siraw manakanakawaw a rarayay na a nailansa, komwan kaoyaw da sya. ");
INSERT INTO ivb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Somniknan do kayegen danaw no araw, nabo sedang, kan naysari iyaw intīro a lobong a nandad kaalas tres do kamakoyab. ");
INSERT INTO ivb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Sinpangan na, do kakalo naranaw a mangalas tres, nangngengey si Jesos so malyak, kan binata na a kāna, “Eloi, Eloi, lama sabaktani?” No chakey a batahen nyaya, ki “Dyos ko, Dyos ko, āngo ta ninonolay mo yaken?” ");
INSERT INTO ivb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Siraw naychatetēnekaw daw a nakadngey sya, binata da, “Tawagan nya tawo si Elyas!” ");
INSERT INTO ivb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ki sinpangan na,, no asa dyira, ki nanyeng a nayyayo a nanghap so akmay dadyi a pinakneban na so naysoka a palek, as nakapatap na syad tobwanaw no byawo, as nakapagolo na syad dangoyaw ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ki binata dan kadwanaw daw a kon da, “Anchi kamo, ta chiban ta panchi an yangay a isalākan ni Elyas!” ");
INSERT INTO ivb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Sinpangan na, minirwa dana nangngengey si Jesos so malyak, as naybitos byay na do nakaiparawat naw so ispirito na di Āpo Dyos. ");
INSERT INTO ivb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Do dawri, napirit a naysyay kortinaw do Timplo a yapod tohos a nandad sayran. Nagin-gined pa so mayit a napayayabhak siras rarakohaw a bato. ");
INSERT INTO ivb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","As do dawri, naywangan saw tanem, as nagongar saw aro a nadiman a tawotawo no Dyos. ");
INSERT INTO ivb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ki do nakapagongar danaw ni Jesos, minohtot sa do tanem daw a aschip, as nakangay da do Jerosalem a iyaw masantwanaw a syodad a dawriw nakaboyan sira no aro a tawotawo. ");
INSERT INTO ivb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ki taywara mananawaw kapitan daw no soldado saw kan siraw rarayay naw a magbanbantay si Jesos do kadidiw daw so gin-ginedaw kan iyaw kaboya daw so mapariparin naw. Binatabata da a kon da, “Oyod sawen a Anak ni Āpo Dyos!” ");
INSERT INTO ivb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ki do mabawaw so dēkey di Jesos, myan aro saw a mababakes daw a omchidechideb sya. Siraw nyaya mababakes, ki minonot sad Jesos a somidosidong a yapo pad Galilya. ");
INSERT INTO ivb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","No kadwan dyira, ki sa Maria Magdalena, kan si Maria a ānang ni Santiago kan Jose, kan iyaw kabahayaw ni Sebedeo. ");
INSERT INTO ivb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Do kamakoyāb naranaw, ki nawaraw asaw a mahakay a mabaknang a mayngaran so Jose a taga Arimatea, as kan iya, ki asa pa nanawhen ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nangay do yananaw ni Pilato, kan yangay na chindaw bangkayaw ni Jesos. Do dawri, inbilin ni Pilato tan maitoroh dya. ");
INSERT INTO ivb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Dawa, yangay ni Jose a inhap bangkayaw, as nakapongos na sya so madalos a ayowayob. ");
INSERT INTO ivb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Sinpangan na, pinosek naw bangkayaw ni Jesos do mismo naw a tanem a aschip a bayo pa inpaparin na a nabangbangan, as nakaneb na syas rakkoh a bato, as nakayam narana. ");
INSERT INTO ivb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ki myan sa daw, sa Maria Magdalena kan asa paw a Maria a myan a maydisna do anmwaw no pantawaw no tanem. ");
INSERT INTO ivb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Do somarono danaw a araw, do katayoka danaw no Arawaw a Kapagsagāna, nangay sad Pilato matotohosaw a papadi kan siraw Parisyowaw. ");
INSERT INTO ivb_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Binata dad Pilato a kon da, “Āpo, manakem namenaya a do kabyay paw no nawri a mangal-allilawaw a tawo, ki binata naw a mirwa kono a mabyay do chatatdo naw a araw. ");
INSERT INTO ivb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Dawa, ibilin mo tan mabantayan so maganay tanemaw a mandan makahabas tatdo a karaw. On, ta āngo nchan yay da takawen nanawhen na saw bangkay naw, as kaibahey da sya dyirad tawotawo a kon da, ‘Nagongar danas Jesos.’ Ta an maparin komwan, malidlidyat dananchiw manawnawdyaw a pangallilaw kan iyaw nanmaw.” ");
INSERT INTO ivb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Do dawri, binata dyira ni Pilato a kāna, “Sigi, manghap kamo siras soldado saw, kan kapyahen nyo a ipabantay dyira a mandan pandan chapatak nyo.” ");
INSERT INTO ivb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Dawa, yangay da pinaysonong tanemaw, as pinangayan da pas pangilasinan do hapotaw no aneb naw a bato tan abo mangbadede so batwaw, as nakapanokos da siras soldado saw a magbantay sya. ");
INSERT INTO ivb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Do nakatayokaw no Araw a Kapaynaynahah, do kapaysesedang danaw do manōmaw a araw no lawas, yangay a chiniban Maria Magdalena kan asa paw a Maria iyaw nakaitanemanaw ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ki do dawri, nanyeng a naggin-gined so mayit, kan gominchin asa anghil ni Āpo a yapod hanyit. Binadede naw batwaw a aneb no tanemaw, as nakadisna na sya. ");
INSERT INTO ivb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Oltimo a makapoyat a akmay kimat anghilaw, kan taywaras kaydak laylay naw. ");
INSERT INTO ivb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ki do nakaboya daw so anghilaw, namirpir saw gwardyaw do taywara a nakamo da, kan naysasakeb sa akmay nadiman. ");
INSERT INTO ivb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ki naychirin anghilaw dyirad mababakes saw a kāna, “Mamo kamo aba. Chapatak ko a si Jesos a nailansa do kros chichwasen nyowaya. ");
INSERT INTO ivb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ki apaba dya maynamot ta nagongar dana a akmas binata naw. Ngay, chiban nyo pad pinangayan daya sya. ");
INSERT INTO ivb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Sichangori, makalisto kamo. Yangay nyo a ibahey nya dyirad nanawhen naw a kon nyo, ‘Nagongar danas Jesos, as kan nanma dana a mangay do Galilya. Dawrinchiw kaboyan nyo sya.’ Aran chiban nyo an dya oyod iyaw binata kwaya dyinyo ah!” ");
INSERT INTO ivb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Dawa, nakabel sa a komnaro do aschipaw, as kan aran mamo pa sa, ki oyod das kasoyot. Naychapayapayayo sa a nangay a nangipakatoneng so nawri a dāmag dyirad nanawhen na saw. ");
INSERT INTO ivb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ki nyiknyinan da a binayat san Jesos, kan kinablaawan na sa. Do dawri, naypasngen sa kan kinepkep daw kokod naw, as nakapagdaydayaw da dya. ");
INSERT INTO ivb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Do dawri, binatan Jesos dyira a kāna, “Mamo kamo aba. Mangay kamo dyirad kakakteh ko saw, ta ibahey nyo a mangay sad Galilya, ta maboya danchi yaken daw.” ");
INSERT INTO ivb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ki do nakayam daranaw no mababakesaw, nangay sad syodad kadwan saw a soldado a nagwardya so tanemaw, ta yangay da inpadāmag dyirad matotohosaw a papadi iyaw tabo a napariparin. ");
INSERT INTO ivb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ki naychichipeh saw matotohos saw a papadi kan siraw panglakayen saw, as nakapagtotolag da. Tinorohan da saw soldadwaw so aro a kwarta da, ");
INSERT INTO ivb_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","as nakabata da sya dyira a kon da, “Ibahey nyo dyirad tawotawo saw a, ‘Nangay sa kahep nanawhen na saw, kan tinakaw daw bangkay naw do kayan namenaw a makaycheh,’ kon nyo ah. ");
INSERT INTO ivb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","As an mapatakan anchi ni Gobirnador, ki nolay nyo, ta yamen anchiw makatoneng dya tan abo mabata na dyinyo.” ");
INSERT INTO ivb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Dawa, inhap dan gwardyaw kwartaw, as pinarin daw naibilinaw dyira. Ki mandas changori, ki nawri paw dāmag a chapatak dan Jodyo saw. ");
INSERT INTO ivb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ki siraw asaw a poho kan asa a nanawhen ni Jesos, ki nangay sa do Galilya, do tokonaw a inbahey ni Jesos a ngayan da. ");
INSERT INTO ivb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ki do nakaboya daw si Jesos, ki nagdaydayaw sa a aran nagmangamanga saw kadwan a iya, ki si Jesos. ");
INSERT INTO ivb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ki naypasngen si Jesos dyira, as nakabata na sya dyira a kāna, “Naitoroh dyaken tabo a toray do hanyit kan do tanaya. ");
INSERT INTO ivb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Dawa, mangay kamo dyirad tabo tawotawo do intīro a lobong, ta payparinen nyo sa nanawhen ko. Bonyagan nyo sa do ngaran Āmang kan Anak kan Ispirito Santo. ");
INSERT INTO ivb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","On, nanawhen nyo sa a magtongpal so tabo inbilin ko dyinyo. Naknakmen nyo nyaya a nāw ko dyinyo a mandanchan pandan.”");
INSERT INTO ivb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nyayaw nakaisiknan no Maganay a Dāmag a maynamot di Jeso-Kristo a Anak no Dyos. ");
INSERT INTO ivb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Myan binata ni Āpo Dyos do Anak naya do kaychowa pa a inpaitolas na di Isayas a asa a propīta na a kāna, “Panmahen konchi a toboyen asaw a pachirawatan ko tan yay na paysonongen ayaman mo. ");
INSERT INTO ivb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Iyanchiw mangingengengey do let-ang a mangibahebahey so nya a kāna, ‘Mamarin kamo so rarahan a para do Āpo, kan paysonongen nyo pakono ayaman na.’” ");
INSERT INTO ivb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Natongpal nya do nakapamonyagaw kan nakapangnanawowaw ni Juan siras tawotawo a romnapit dya do let-ang. Binatabata na dyira a kāna, “Magbabāwi kamo kan pabonyagan kamo. Tan komwan, pakawanen naynyo no Dyos do gatogatos nyo.” ");
INSERT INTO ivb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Do dawri a chimpo, reprep saw tawotawo a nangay di Juan a yapo do Jerosalem kan yapo do idiidi do probinsya a Jodya. Inpodno daw gatogatos da, as kan binonyagan sa tabon Juan do oksongaw a mayngaran so Jordan. ");
INSERT INTO ivb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Naparin laylay ni Juan do boboh no kamilyo, kan iyaw barikis na, ki tod a nahathat a lalat. Kabaga kan tagapolot no yokan iyaw no chinabyay na. ");
INSERT INTO ivb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Do nakapangasaba naw dyirad tawotawo saw daw, binatabata na dyira a kāna, “Myan anchiw manawnawdyi kan yaken a matortoray kan yaken, as kan maikari akwaba a magrokob a mangwasak so kahot no tokap na. ");
INSERT INTO ivb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Bonyagan koynyo do ranom. Ki iya, ki bonyagan nanchi inyo so Ispirito Santo.” ");
INSERT INTO ivb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Do dawri a chimpo, nawaras Jesos a yapo do idi a Nasaret do probinsya a Galilya, as kan nagpabonyag di Juan do oksongaw a Jordan. ");
INSERT INTO ivb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Do nakapakaraya danaw ni Jesos, ki insigīda a naboya na naywangan hanyit, kan naboya na paw Ispirito Santo a akmay boyit a naypabodis dya. ");
INSERT INTO ivb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Sinpangan na, myan timek a yapod hanyit a nakabata so nya dya a kāna, “Imo Anak ko a oyod kos chadaw. Oltimo a mahwahok ako a maynamot dyimo.” ");
INSERT INTO ivb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Do nakatayokaw no nyaya, nyeng a pinalongo no Ispirito Santo si Jesos do naychabongbongrwaw a let-ang. ");
INSERT INTO ivb_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Minyan daw so apat a poho a karaw, kan sinosoot ni Satanas. Myan pa saw bolaw a animal do dawri a yanan na, ki sinirbyan dan anghil saw si Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Do nakabahod danaw ni Juan, nangay si Jesos do Galilya a nangikasaba so Maganay a Dāmag a yapod Āpo Dyos. ");
INSERT INTO ivb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Binata na a kāna, “Narapit danaw oras a inkeddeng no Dyos, kan īto danaw kapagtoray na. Dawa, magbabāwi kamo na do gatogatos nyo, kan manganohed kamo na do Maganayaya Dāmag!” ");
INSERT INTO ivb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Do naypisaw do kayamaw ni Jesos do payisaw no Minanga a Galilya, naboya na saw dadwaw a mangalap a sa Simon kan kakteh na a si Andres. Myan sa magpakat so sigay. ");
INSERT INTO ivb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ki binatan Jesos dyira a kāna, “Onotan nyo yaken, kan payparinen koynyo a magkalap so tawo.” ");
INSERT INTO ivb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Do nakadngey daw sya, nanyeng da kinarwan sigay da saw, as nakawnot da dya. ");
INSERT INTO ivb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Do dawri, tinongtong da Jesos nayam. Ki do nakapakabawa daranaw so dēkey, naboya na saw dadwa paw a mangalap a sa Santiago kan kakteh na a si Juan a siraw anakaw ni Sebedeo. Myan sa do abang daw a madama mapaysoysonong so sigay da saw. ");
INSERT INTO ivb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Insigīda a tinawagan san Jesos, as kan do dawri, ki kinarwan das āmang da a si Sebedeo do abangaw magraman dyirad mahahakayaw a matangtangdanan, as nakawnot dad Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Sinpangan na, nangay sa Jesos do idi a Kapernaom. Do Araw a Kapaynaynahah, somindep si Jesos do sinagoga daw no Jodyo saw, as kan inrogi naw nangnanawo. ");
INSERT INTO ivb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ki do nakadngey dan tawotawo saw daw so kapangnanawowaw ni Jesos, chinasdaaw da tabo maynamot ta myan toray na sigon do kapaychiychirin naw kan akmaba siras mangnanawowaw so linteg. ");
INSERT INTO ivb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Do dawri, do kayanaw ni Jesos do sinagoga, myan daw mahakayaw a intorayan marahet a ispirito, kan nangagay mahakayaw a kāna, ");
INSERT INTO ivb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Anghen mo yamen, mo Jesos a taga Nasaret? Yangay mori yamen a rarayawen? Taywaran dyi namen imo a chapapatak? Imo abawriw Masantwanaw a tinoboy no Dyos?” ");
INSERT INTO ivb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ki pinaydabdab ni Jesos marahetaw a ispirito, as nakaibahey na sya dya a kāna, “Magolimek ka, kan komaro ka do dawri a tawo!” ");
INSERT INTO ivb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nanyeng a pinaychamirpirpir no marahetaw a ispirito iyaw tawowaw, as nakapangagay na sya, as kan do dawri, kinarwan na. ");
INSERT INTO ivb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Chinasdaaw da tabo no tawotawowaw nawri a pinarin Jesos, kan naysin-iiyahes sa a kon da, “O! Āngo paro nyaya? Bayori a kapangnanawo? Matorayaya magmandar a aran sirayaw marahetaya ispirito, as kan tongpalen dāya. Samna!” ");
INSERT INTO ivb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Do dawri, nalisto a nagdinamag do intīro a probinsya a Galilya iyaw maynamot di Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Do nakakaro daranaw da Jesos kan siraw nanawhen naw do sinagoga, nagtaros sa a kominwan do bahay da Simon kan Andres. Nachangay sa Santiago kan Juan dyira. ");
INSERT INTO ivb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Do dawri, myan do apin a madama magbāra iyaw mabakesaw a katogangan ni Simon, kan nyeng da a yangay a inbahey di Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ki naypasngen si Jesos dya, as nakaigpet nas tanoro naw a pinaybangon. Ki nyeng na binawan, kan nakangay dana nangidasar so kanen da. ");
INSERT INTO ivb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Do kasdep danaw no araw, do kapaysarisari naranaw, inyangay da sa di Jesos aro saw a tawotawo a maychagaganyit kan siraw sindep saw no marahet a ispirito. ");
INSERT INTO ivb_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tabo tawotawo a yapo do dawri a idi, ki naychipeh sa daw do salapenaw no bahayaw a yanan Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Sinpangan na, pinapya sa ni Jesos maychagaganyit saw a matatarek so ganyit, as nakapaksyat nas aro saw a marahet a ispirito, as kan pinalobosan na saba a maychirin, ta chapapatak da an sino iya. ");
INSERT INTO ivb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Sinpangan na, do kamabekasan naranaw, nakamasari si Jesos a komnaro do bahayaw, kan nangay a naydasal do kabwan naw no matawotawo a logar. ");
INSERT INTO ivb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ki do nakapaybangon daw da Simon kan rarayay na saw, yangay da kinadyaw si Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Do nakadongso daw sya, inbahey da dya, “Ari daw imo a kadikadyawen aro saw a tawotawo!” ");
INSERT INTO ivb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ki tinbay sa ni Jesos a kāna, “Mangay ta do masngen saya a idiidi tan makapangasaba ako pa dyirad tawotawo saw daw, ta nawriw nangayan ko dya.” ");
INSERT INTO ivb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Do dawri, minidibidi sa Jesos do intīro a probinsya a Galilya a nangasaba do sinagoga dan Jodyo saw kan namakpaksyat so marahet saw a ispirito. ");
INSERT INTO ivb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Do asa karaw, myan asa mahakay a nagliproso a nangay di Jesos, kan naydogod do salapen naw a nachikakaāsi dya a kāna, “Āpo, an chakey mo a mapyan ako, masigorādo ko a maparin mo.” ");
INSERT INTO ivb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ki oyod ni Jesos so nakāsi sya, kan tinodah naw tatchay naw a sinalid, as nakabata na sya dya a kāna, “Naon, chakey ko. Mapyan ka na!” ");
INSERT INTO ivb_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ki nanyeng a napyan, kan nabo ganyit naw a liproso. ");
INSERT INTO ivb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Do dawri, sakbay a pinayam ni Jesos, inmandar na pa a maganay a kāna, ");
INSERT INTO ivb_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ibahebahey mwabaw nya naparin dyimo do aran sino, ah basbāli a nyeng ka mangay a mapaboyad padyaw tan sakangwan maboya na a napyan ka na. As katayoka no nawri, mangidāton ka a para do nakapakadalos mo a akmas inbilinaw ni Moyses do kaychowa pa a pangipaneknek mo do tawotawo a napyan ka na.” ");
INSERT INTO ivb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ki do nakakaro naranaw, napenpen nabaw dangoy na, kan basbāli a inbahebahey na do tawotawo naparinaw dya. Nawriw nakayapwan na a dyi dana makasdep si Jesos do idiidi a makantad do kārwan tawo. Dawa, minyan danas Jesos do gaganaw no idiidi do logar saw a kabwan matawotawo. Ki alit na, romnapit sa dyaw aro saw a tawotawo a yapod matatarek saw a loglogar. ");
INSERT INTO ivb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Abaw aro a araw a napahabas, as nakapaybidi da Jesos do Kapernaom. Ki nadamag dan tawotawo saw a naybidi danad bahayaw a pagyanan na. ");
INSERT INTO ivb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Dawa, domnahepdep aro a tawotawo, kan napekpek bahayaw a mandan arabaw logar da a aran do yananaw no pantaw. Do kayanaw ni Jesos a mangnanawo dyira so chirin ni Āpo Dyos, ");
INSERT INTO ivb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","myan nawara apat a mahahakay a nangisiw so asa a paralitiko. ");
INSERT INTO ivb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ki maynamot do kāron tawo, maisdep dabad yananaw ni Jesos paralitikwaw. Dawa, inkayat dad atepaw no bahay, as nakakabkab das atepaw do anmwaw ni Jesos, kan tinonton daw paralitikwaw do dohod. ");
INSERT INTO ivb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Do nakaboyaw ni Jesos so kapanganohed daw dya, binata nad paralitikwaw, “Imom anak ko, napakawan ka na do gatogatos mo.” ");
INSERT INTO ivb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ki do dawri, myan sa maychadisdisna daw kadwan saw a mangnanawo so linteg no Jodyo, kan yahahes da do aktokto da, ");
INSERT INTO ivb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Āngo ta komwan kapaychirin nya tawo? Tod naya dyābat si Āpo Dyos! Sino makapakawan so tawotawo do gatogatos da, an dya si Āpo Dyos a moybōh!” ");
INSERT INTO ivb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ki naitayo daba di Jesos nawri a kapangtokto da. Dawa, binata na dyira a kāna, “Āngo ta komwan kapangtokto nyo? ");
INSERT INTO ivb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Āngo maydaydamnay a batahen ko: ‘Napakawan ka na do gatos mo,’ mana ibahey kwa, ‘Maytēnek ka, as kakatkat mos nakaychehan mwaya, as kasabat mo na’? ");
INSERT INTO ivb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ki tan chapatak nyo a yaken a Tawo a Yapod Hanyit, ki myan toray ko do tanaya a mangpakawan so naygaygatos, paytēneken ko paralitikwaya.” Sinpangan na, binata nad paralitikwaw a kāna, ");
INSERT INTO ivb_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Do bilin ko, maytēnek ka, as kakatkat mos nakaychehan mwaya, as kasabat mo na.” ");
INSERT INTO ivb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Sinpangan na, naytēnek paralitikwaw, as nanyeng na inhap nakaychehan naw, as nakayam narana do kasalasalapan daw a tabo. Do dawri, chinasdaaw da tabo, kan katakatayisaw nangidaydayaw si Āpo Dyos a kon da, “Aysa! Ari kami pad nakaboyas akma syay!” ");
INSERT INTO ivb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Sinpangan na, minirwa dana inon-onor ni Jesos masngenaw do payis no Minanga a Galilya, ki inaribongbongan dan arwaw a tawotawo, as kan ninanawo na sa. ");
INSERT INTO ivb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Do kadama naw a mayam, naboya naw asaw a magsingsingir so bwis a mayngaran so Lebi a anak ni Alpeo, kan myan a maydisna do opisina naw a pagsingsingiran na. Binata ni Jesos dya a kāna, “Ka pa dya! Pachisyayan mwaba yaken.” Nanyeng a naychakatkat si Lebi, as nakawnot na sya. ");
INSERT INTO ivb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Sinpangan na, do nakapachakanaw ni Jesos kan nanawhen na saw do bahayaw ni Lebi, aro saw nachihanghang dya a magsingsingir so bwis kan tawotawo saw a naibidang a aro so gatos, ta machononot sa di Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ki do nakaboya daw sya no mangnanawo saw so linteg a rayay dan Parisyo saw a machihanghang sa Jesos dyira, inyahes da dyirad nanawhen na saw a kon da, “Āngo ta machihanghang si Jesos dyirad magsingsingir saya so bwis kan dyirad naibidang saya a aros gatos?” ");
INSERT INTO ivb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ki do nakadngeyaw sira ni Jesos, inpangarig na dyira a kāna, “Sirabaw masalon-at makachitas mangagas, an dya siraw maganyit. On, nangay akwaba mangrara so tawotawo saw a malinteg, an dya siraw myan so gatos.” ");
INSERT INTO ivb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Do naypisa araw, do kayan daw a magayonar a maydaydasal no nanawhen saw ni Juan a Mamonyag kontodo siraw Parisyowaw, myan saw nangay di Jesos a nangyahes sya a kon da, “Āngo ta magayonar saw nanawhen naw ni Juan kan siraw no nanawhen daw no Parisyo saw, ki siraw nanawhen mwaya, ki enggaya?” ");
INSERT INTO ivb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ki tinbay san Jesos do pangarig a kāna, “Namna! Maparinawri a dyi sa koman tawo a naawis dana do kasaran, naten dana an myan paw nobyowaw do yanan daw? Syimpri, maparin aba an dyi sa koman! ");
INSERT INTO ivb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ki īto araw a maikaro dyiraw nobyowaw, kan do dawrinchi a araw, nawri dananchiw kapagayonar da.” ");
INSERT INTO ivb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tinongtong ni Jesos nagpangarigan dyira a maynamot do adanaw kan bayo a nanawo a dya maparin a maysagel. Binata na dyira a kāna, “Abaw mangitakop so bayo a lamit do adan a laylay. Ta an komwan, ki komsen anchiw no naitakopaw, kan marohnwan piritaw no adanaw a laylay. ");
INSERT INTO ivb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Masaw, maparin aba pangayen mawnged a palek do adan a sopot a lalat. Ta an komwan, pabtaken naw sopotaw, as kan mararayaw palekaw kan adanaw a sopot. No mawnged a palek para pakono lang do bayo a sopot a lalat ah!” ");
INSERT INTO ivb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Do asaw a Araw a Kapaynaynahah, nayam sa Jesos kan siraw no nanawhen naw do asaw a bengkag a namohan so trigo. Ki do kadama daw a mayam, nanghokhot saw nanawhen naw so dāwa a kinoditan da chinan. ");
INSERT INTO ivb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ki nasipotan da san Parisyo saw, as kan inyahes dad Jesos a kon da, “Chiban mo pa! Āngo ta parinen dan nanawhen mwayaw mabaywanaya do Araw a Kapaynaynahah? Mapsekawriw nawri?” ");
INSERT INTO ivb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ki inatbay san Jesos a kāna, “Namna! Ari nyo pawryad nabāsaw no pinarinaw ni Dabid do nakapteng naw kan siraw kinayrayay naw? ");
INSERT INTO ivb_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Do kachimpo ni Abyatar a katotohosan a padi, taywaran dya somindep si Dabid do pagdaydayāwan daw so Dyos, as nakakan nas tinapay a naidāton do Dyos? Sigon do linteg ta, sirabawri lang papadyaw maparin a koman so nawri a tinapay? Ki alit na kinan na, as kan nanoroh pad rarayay na saw.” ");
INSERT INTO ivb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Do dawri, pinarapa pan Jesos a inbahey, “Dawa, komwan saw nanawhen kwaya, ta pinarin aban Dyos iyaw tawo a magsirbi do Araw a Kapaynaynahah, an dya pinarin naw no Araw a Kapaynaynahah a para do kaganayan tawotawo. ");
INSERT INTO ivb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Dawa, yaken a Tawo a Yapod Hanyit, ki yaken myan so toray a mangeddeng so maparin do Araw a Kapaynaynahah.” ");
INSERT INTO ivb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sinpangan na, minirwa dana somindep si Jesos do sinagoga da daw, kan myan daw asa mahakay a singkol. ");
INSERT INTO ivb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Myan pa daw tawotawo saw a omsisiim di Jesos an pyahen naw nawri a mahakay do Araw a Kapaynaynahah tan myan pamagatosan da sya. ");
INSERT INTO ivb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Do dawri, binata ni Jesos do nagsingkolaw, “Maytēnek ka pa dya do kasalasalapanaya.” ");
INSERT INTO ivb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Sinpangan na, inyahes ni Jesos dyirad tawotawo saw daw a kāna, “Āngo chakey no linteg a parinen an marapit Araw a Kapaynaynahah: kasidong mana kapangranggas, kapangisalakan mana kapangdiman?” Ki abaw nakalilyak dyira. ");
INSERT INTO ivb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Do dawri, pinakasisirem sa ni Jesos a insoli, as kan chinaynyin no aktokto naw katwaw no oho da. Sinpangan na, binata na do mahakayaw a singkol a kāna, “Lonaten mo tatchay mwaya.” Do dawryaw a inbahey ni Jesos, linonat na kan nyeng a napyan. ");
INSERT INTO ivb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ki maynamot do nyaya, minohtot saw Parisyowaw do sinagoga, kan nyeng sa nagplano kan siraw no nanawhen naw ni Āri Herodes an maypāngo iyaw no kadiman das Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Sinpangan na, domnitchan sa Jesos kan siraw nanawhen naw, kan nangay sa do payisaw no minanga. Ki minonot saw reprep saw a tawotawo a yapo do probinsya naw a Galilya kan ");
INSERT INTO ivb_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","do Jerosalem, as kan do probinsyaw a Jodya kan Idomya kan do kabtangaw no Oksong a Jordan, as kan aran siraw no logaraw a masngen do syodad nad Tiro kan do Sidon. Tabo san nyaya tawo, ki nangay sad Jesos, ta nadamag da saw pariparinen naw. ");
INSERT INTO ivb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ki maynamot do kāron tawo, inbahey ni Jesos dyirad nanawhen naw a isagānaan das abang tan dyi da masdin no tawotawo saw, ");
INSERT INTO ivb_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ta aro pinapya na tawotawo, as kan nawriw naynamotan paysinpapadoydoyan dan maychagaganyitaw a maypasngen a omsalid sya. ");
INSERT INTO ivb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kāda maboya da si Jesos no tawotawo saw a sindepan marahet a ispirito, ki maysasakeb sad salapen naw, as kapangagay da a kon da, “Imo Anakaw no Dyos.” ");
INSERT INTO ivb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ki inmandar na dyira a dyi da ibahebahey an sino iya. ");
INSERT INTO ivb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Sinpangan na, somnonget si Jesos do asaw a tokon. Tinawagan na saw no chakey naw a tawo, kan minonot sa dya. ");
INSERT INTO ivb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Namidi dyira so asa poho kan dadwa mahahakay tan sira danaw rarayay na as kan tan toboyen na sa a mangay a mangasaba. ");
INSERT INTO ivb_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Tinorohan na pa sa so toray a mangpaksyat so marahet saw a ispirito. ");
INSERT INTO ivb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","No ngarangaran dan nya sa pinidi ni Jesos, ki sa Simon a pinangaranan ni Jesos so Pedro, ");
INSERT INTO ivb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","siraw maykaktehaw a sa Santiago kan ādi na a si Juan a anak ni Sebedeo. Siraw nya maykakteh, ki pinangaranan san Jesos so “Boanerges,” as kan no chakey na batahen ki, “akmay adey.” ");
INSERT INTO ivb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","As pinidi na pa sa Andres, Pilipi, Bartolome, Matchew, Tomas, Santiago a anak ni Alpeo, Tadeo, Simon a mangispal so kaidyan na, ");
INSERT INTO ivb_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","kan si Jodas a yapod Iskariote, iyaw nyaw nanglipotaw di Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Sinpangan na, somnabat sa Jesos. Ki do dawri, minirwa dana naychipeh daw tawotawo saw, kan maisanga na paba kan siraw nanawhen naw koman. ");
INSERT INTO ivb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ki do nakadamag daw syan pamilya naw, nangay sa tan hapen da, ta batahen dan kadwan dyira a magatit dana konos Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","As siraw mangnanawowaw so linteg a minosok a yapod Jerosalem, ki binatabata da a kon da, “Sindepaya ni Beelsebob. On, iyayaw pangolo daw no dimonyo saw manorotoroh dyas bīleg a mangpaksyat so marahet saya ispirito.” ");
INSERT INTO ivb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ki tinawagan san Jesos tawotawowaw, as nakapagpangarig na dyira a kāna, “Maypāngo kapaksyat ni Satanas so mismo na inawan?” inyahes ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","“An mayayarap saw tawotawo do asa kapagaryan, manayonoriw nawri a pagaryan? ");
INSERT INTO ivb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Masaw asa kapamilya an maglalaban sa, masigorādo a masisyay sanchi. ");
INSERT INTO ivb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Komwan pa saw myanaw do pagaryan ni Satanas an maglalaban sa, ki masisyay sanchi. Ta an maysinrararayaw saw bonggoy naw, makapaytēnek pa saba, kan narapit danaw tawsan da. ");
INSERT INTO ivb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Abaw tod a makasdesdep do irahem no bahay no mayit a tawo a akmas Satanas kan manakanakaw siras dyira na saw, an dyi pa manma mabahod nya mayit a tawo. Amnan nabahod dana, libri danaw tod a manghap siras dyira na saw. ");
INSERT INTO ivb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Oyod nya ibahey ko dyinyo maparin a mapakawan tawotawo do tabo a pakagatosan da, kan mapakawan saw maychirin so maikontra do Dyos. ");
INSERT INTO ivb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ki aran sino a maychirin so maikontra do Ispirito Santo, mapakawan aba polos tawowaw do nawri a gatos, ta gatos a abos pandan.” ");
INSERT INTO ivb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Chinirin ni Jesos nyaya maynamot do kabata daw syan mangnanawowaw so linteg a sindep kono no marahet a ispirito. ");
INSERT INTO ivb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Sinpangan na, nawara si ānang ni Jesos kan siraw kakakteh naw a mahahakay. Naytēnek sa do atataw no bahay, as nakapanoboy das nangay a omtawag sya. ");
INSERT INTO ivb_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Dawa, siraw tawotawo saw a naychadisdisna a mindibon sya, ki inbahey da dya a kon da, “Ari saw sa ānang kan ādi mo saw do gagan a maychichwas dyimo!” ");
INSERT INTO ivb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ki inatbay san Jesos a kāna, “Sino saw ānang ko kan kakakteh ko?” ");
INSERT INTO ivb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ki sinpangan na,, chiniban san Jesos myanaw do omdibon naw, as nakabata na sya, “Cha saya dyaw ānang kan kakakteh ko, ");
INSERT INTO ivb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ta aran sino a mamarin so pagayatan no Dyos, iya danaw kakteh kan ānang ko.” ");
INSERT INTO ivb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Do naypisa, naybidi dana sa Jesos do payisaw no minanga a Galilya, as kan inrogi naranaw nangnanawo daw. Ki maynamot do kārwaw no tawotawo a mindibon sya, nangay si Jesos a somnakay a naydisna do sihahatawaw a abang. Ki siraw tawotawowaw, nāw dad payisaw no minanga a nangadngey sya. ");
INSERT INTO ivb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Aro innanawo na dyira, kan pangarig inos-osar na. Binata na dyira a kāna, ");
INSERT INTO ivb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mangadngey kamo. Myanaw asa maymohamoha a nangay a nangiwaris so botoh. ");
INSERT INTO ivb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Do kayan naw a magwaris, myan saw napaychahesday na do rarahan naw, kan kinan san manomanok. ");
INSERT INTO ivb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Myan pa saw kadwan a botoh, ki naychahesday sa do mabato saw a yanan. Maynamot do kadēkey no tana, nalisto sa naycharoroting. ");
INSERT INTO ivb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ki do nakaibilag daranaw do araw, nahayo sa, ta nakarahem abaw yamot da saw. ");
INSERT INTO ivb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Myan pa kadwan saw a botoh, ki naychahesday sa do katamtamkan a manolok. Ki minsi saba maynamot ta nahonghongan sa. ");
INSERT INTO ivb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ki myan saw botoh a naychahesday do maganayaw a tana. Tomnobo sa, kan minsi sas aro. Siraw kadwanaw, ki mawpayang, kan myan saw kadwan a mangengen. Siraw kadwanaw, ki mayid so dāwa.” ");
INSERT INTO ivb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Do nakatayokaw ni Jesos so nya pangarigan na, binata na, “Changori, inyo a myan so tadyinya, kadngeyen nyo.” ");
INSERT INTO ivb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Do ka si Jesos danaw kan siraw minononotaw dya kontodo dosi saw a nanawhen na, inyahes da dya an āngo iyaw chakey a batahen no pangarig naw. ");
INSERT INTO ivb_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ki initbay ni Jesos dyira a kāna, “Inyo nakaitorohan no kapakatoneng so palimedaya a maynamot do pagaryan no Dyos. Ki siraw dya monot dyaken, maynana pangarig maosar dyira. ");
INSERT INTO ivb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Tan komwan, aran chichiban da, ki maimangmang daba. As aran adngedngeyen da, ki makaāwat saba. Ta an dyi sawen a komwan, sigoro magbabāwi sa kan pakawanen sa no Dyos.” ");
INSERT INTO ivb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Do dawri, tinongtong ni Jesos naychirin dyira a kāna, “Maawātan nyo abawriw nya pangarig? Maypangonchiw kapakaāwat nyos kadwan pa a pangarig? ");
INSERT INTO ivb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Nyaw chakey na batahen no pangarigan kwaya. No botoh saya a inwarwaras no maymoymohaw, ki chirin no Dyos. ");
INSERT INTO ivb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Iyaw rarahanaya a nakasdayan no botoh, ki mayarig do tawowaw a mangadngey so chirin no Dyos, ki nyeng si Sairo a nangay a napakaro so nadngey naw. ");
INSERT INTO ivb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“As no kabatwanaya a naychahesdayan botoh, ki nawriw pachiyengayan tawowaw a nyeng a masoyot a mangrawat an madngey naw chirin no Dyos. ");
INSERT INTO ivb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ki maynamot ta nakarahem abaw yamot na do aktokto na, manayon aba. Ta an myan kalidyatan kan kaidadanes a maynamot do chirinaya a nadngey na, chaōpay narana kan malisto a tomadyichokod do kapanganohed naw. ");
INSERT INTO ivb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","As no kanonolokanaya a naychahesdayan no botoh, ki maipariho do tawowaw a mangadngey so chirin no Dyos. ");
INSERT INTO ivb_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ki iyaw chirinaya nadngey na, makalo na mabo a maynamot do kabakel na makayapo do problima do byay a akmas pangawis no kinabaknang kan sira paw kadwanaw a kalakam na. Nya sayaw manghonghong so chirinaw a nadngey na, kan may-asi aba. ");
INSERT INTO ivb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","As iyaw maganayaw a tana a naychahesdayan no botoh, ki mayarig do tawowaw a mangadngey so chirin no Dyos kan rawaten na. As siraw naimohaw dya a botoh, ki nay-asi sa. Myan saw mawpayang, mangengen, kan mayid so dāwa.” ");
INSERT INTO ivb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Binata pan Jesos nya matarek a pangarigan a kāna, “Pasdeben nyoriw soho, as katohong nyo syan bakag, mana pasiroken nyorid ohbwaw no katri nyo? Syimpri engga, ta pangayen nyod nairantaw a pakadatokan na. ");
INSERT INTO ivb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Komwan chakey na batahen do pangarig kwaya, ta aryoriw naitayo a dyinchi a mapahtot? Masaw a abaw palimed a dyinchi a malawag a mapatakan. ");
INSERT INTO ivb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Dawa, inyo a myan so tadyinya, kadngeyen nyo ah!” ");
INSERT INTO ivb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Do dawri, tinongtong ni Jesos naychirin a kāna, “Ipasnek nyo a adngeyen iyaw ibahebahey ko dyinyo sichangori, ta an parinen nyo nawri, ki maypaypangay paw kapakaāwat nyo. Ta no rokod a osaren nyo do kapangokom nyo so kapayngay nyo a tawo, ki nawrinchiw pangrokod no Dyos dyinyo, as kan arwaro pa parapan nanchi. ");
INSERT INTO ivb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ta no makaāwat, ki arwaro maitoroh dya. Ki no dya makaāwat, aran iyaw dēkeyaw a myan dya, ki mapakaro panchi dya.” ");
INSERT INTO ivb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Tinongtong ni Jesos naychirin, kan binata na, “No pagtorayan no Dyos, ki mayarig do tawo a magwarwaris so botoh do bengkag. ");
INSERT INTO ivb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Makaycheh an mahep mahakayaw as kan maybangon an mabebekas, ki chapatak aba no naymohaw an maypāngo kapaypayparakoh no tomobo saw a inmoha na. ");
INSERT INTO ivb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ki iyaw tanaw, maparakoh kan mapay-asi so mohamohaw. On, paybohongen na manma, as kapagdāwa na sya, as kan kaynoy narana. ");
INSERT INTO ivb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","An natwa danaw dāwa naw, mangay dana magranyiw no naymohaw maynamot ta narapit danaw oras no kapagapit.” ");
INSERT INTO ivb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Sinpangan na, binata ni Jesos dyira a kāna, “Āngo paw maganay a pangarigan a osaren ta maynamot do pagtorayan no Dyos? Ngay, āngo paw akmas syaw? ");
INSERT INTO ivb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Maiyarig do dēkey a botoh no mostasa a akmay kadedēkeyan a botoh do tanaya. ");
INSERT INTO ivb_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ki an naiwaris dana, tomobo kan mayparin a akmas kararakohanaw a mohamoha. On, mayparakoh as kan maysanga so rakoh a payketketan dan manomanok a nachisirong do sangasanga na.” ");
INSERT INTO ivb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Aro saw pangarig a inosar ni Jesos do kapangnanawo na dyirad tawotawowaw sigon do pandanaw a matokod no kapakaāwat da. ");
INSERT INTO ivb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Mangnanawo abas Jesos, an dya mangosar so pangarigan dyirad tawotawowaw. Ki an nachibawa dana sa Jesos kan siraw nanawhen naw do katawotawowan, ipaāwat danan Jesos iyaw no chakey naw a batahen. ");
INSERT INTO ivb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Do kapaysarisari naranaw do dawri a araw, binata ni Jesos dyirad nanawhen naw a kāna, “Mamtang tad minangaya.” ");
INSERT INTO ivb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Dawa, maynamot ta sigod dana sad abangaw, tod darana sa kinarwan no tawotawowaw do payisaw no minanga, as nakayam da. Siraw kadwanaw a abang do dawri a yanan, ki nachisabay sa. ");
INSERT INTO ivb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ki do kayan daranaw do almidyo, naypayit salawsaw kan naypararakoh iyaw kelsang, as kan makalo dana mapno abang daw. ");
INSERT INTO ivb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Do dawri, makaycheh si Jesos a maypongan do mawdyiyaw no abangaw. Yinokay dad kabakel daranaw, kan binata da dya a kāna, “Maistro, abawriw kaynyinyinan na dyimo an omned abang taya?” ");
INSERT INTO ivb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Do nakayokayaw ni Jesos, inmandar na do salawsawaw a kāna, “Mangheteng ka!” Ki nanyeng a nangheteng kan taywara dana matalna. ");
INSERT INTO ivb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Sinpangan na, binata ni Jesos dyira a kāna, “Napangayan nyos katored nyo? Abawriw anohed nyo?” ");
INSERT INTO ivb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ki do dawri, taywaraw nakamo da, as kan binata dad katakatayisa dyira, “Sino nya tawo a aran salawsaw kan kelsang, ki manganohed sa dya?” ");
INSERT INTO ivb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Do nakapakarapit daw do kabtangaw no Minanga a Galilya, nakaraya sad tanaw daw a mayngaran so Gerasa. ");
INSERT INTO ivb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ki do nakapakagchinaw ni Jesos do abangaw, myan nangbayat sya a yapod pagtatanman daw a asa mahakay a linoganan no marahet a ispirito. ");
INSERT INTO ivb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Iyaw nyaya a mahakay, ki omyan do pagtatanmanaw do dawri, as kan apabaw makaparin a omkawar sya, ");
INSERT INTO ivb_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ta nasanyib dana naposasan kan nakawaran so tanoro kan kokod, ki binitobitos na. Oltimo kayit na kan aba polos makapagpet sya. ");
INSERT INTO ivb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Maraw kan mahep a pirmi a maypaypaktas dyirad aschipaw a pagtatanman kan do katokotokonan a mangagagay kan tagatagahen naw inawan na so bato. ");
INSERT INTO ivb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ki do nakaboya naw si Jesos a mabawa pa, nayyayo a nangay dya, as nakapaydogod na, ");
INSERT INTO ivb_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","as nakakalyak na nangibahey sya dya a kāna, “Mo Jesos a Anak no Katotohosan a Dyos, anghen mo yaken? Ikari mo do salapen no Dyos a dyi mo yaken a dosāen.” ");
INSERT INTO ivb_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Inbahey naw nyaya, ta minandaran ni Jesos a kāna, “Marahet a ispirito, mohtot ka do dyaya a tawo!” ");
INSERT INTO ivb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Sinpangan na, inyahes ni Jesos dya, “Āngo ngaran mo?” Ki tinbay nas Jesos, as nakaibahey na sya a kāna, “No ngaran ko, ki ‘Arban,’ ta aro kami.” ");
INSERT INTO ivb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Do dawri, sipapasnek a nachikakaāsi di Jesos a dyi na sa pakarohen do dawri a logar. ");
INSERT INTO ivb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ki myan daw asa matokpoh a arban bago a maysaysabok do bakrangaw no nawri a tokon. ");
INSERT INTO ivb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Dawa, nachikakaāsi saw marahetaw a ispirito di Jesos a kon da, “Toboyen mo pa yamen a somdep dyirad bago saya.” ");
INSERT INTO ivb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Dawa, pinalobosan san Jesos. Do dawri, minohtot sad mahakayaw, as nakangay da a somindep dyirad dadwaw a ribo a bago. Sinpangan na, naychapayapayayo saw bagwaw a nandad nakatapwak dad pangpangaw a nachinmo do minangaw, kan nahmes sa tabo bago saw. ");
INSERT INTO ivb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ki siraw mangonongaw siras nawri a bago, naychapayapayayo sa a nangay a nangibahebahey do tawotawo saw do idi da kan barbaryo saw maynamot do naparinaya. Sinpangan na, naychawarawara saw no tawotawowaw do yanan Jesos, ta yangay da chiban an āngo iyaw naparinaw. ");
INSERT INTO ivb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ki do nakawara daw daw, naboya daw no atittaw a mahakay a iyaw myanaw so arban a dimonyo a myan a maydisna a nakalaylay kan maganay danas pangtoktwan. Do dawri, namo sa tabo. ");
INSERT INTO ivb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Siraw nakaboyaw so nawri a naparin do mahakayaw kan bago saw, nāw da inistorya dyirad tawotawo saw naparinaw do mahakayaw kan siraw bago saw. ");
INSERT INTO ivb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Maynamot do dawri, chindaw dan tawotawowaw a komaros Jesos do logar daw. ");
INSERT INTO ivb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ki do kasakay danaw ni Jesos do abangaw, iyaw mahakayaw a sindepan dan marahet saw a ispirito, ki nachikakaāsi di Jesos a machangay dya. ");
INSERT INTO ivb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ki pinalobosan aban Jesos, as nakabata na sya dya a kāna, “Mayam ka na a maybidid bahay nyo, kan ibahey mo dyirad rarayay mo saw maynamot do makasalidaya a pinarin ni Āpo do nakāsi na dyimo.” ");
INSERT INTO ivb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Do dawri, nayam mahakayaw a kominwan do asa poho saw a idi do dawri a yanan, as kan inbahebahey na iyaw kapakaskasdaawaw no pinarin ni Jesos dya. Dawa, oyod das nakaklat no tawotawo saw. ");
INSERT INTO ivb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nakapakarayaw ni Jesos do kabtangaw no minanga do nakapaybidi naw, dinahepdep dan arwaw a tawotawo. ");
INSERT INTO ivb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ki do dawri, myan nawara asa tawo a mayngaran so Jayro a asa āpohen do sinagoga daw do dawri a yanan. Do nakaboya naw si Jesos, naydogod do salapen naw, as nakapachikakaāsi na a kāna, ");
INSERT INTO ivb_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“Kadidiman danaw no anak kwaw a balasītang, mo Āpo. Pachiyangay mo pa saliden tan mapyan dana, as kan tan mabyay.” ");
INSERT INTO ivb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nachangay si Jesos dya. Ki do kadama daw a mayam, aro saw tawotawo a minonot di Jesos, kan masyasidin sa a omdibon do ayaman naw. ");
INSERT INTO ivb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Myan do dawriw asa mabakes a nāw na marodit do asa poho kan dadwa dana katawen. ");
INSERT INTO ivb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","As iya, ki oyod naranas kalidyat, ta aro danaw nagasto nad kangangay nad matatarek saw a mangagas. On, nagasto narana tabo kwarta na, ki aba polos nakaagas sya, basbāli a naypaypangay paw ganyit naw. ");
INSERT INTO ivb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nadamdamag naranaw maynamot di Jesos, kan do dawri, nangay a nachisdin dyirad arwaw a tawo do dyichodanaw ni Jesos, as nakasalid nas kekeh naw. ");
INSERT INTO ivb_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ta no myan do aktokto na, ki nyaya: “Aran nawri lang masalid ko laylay naya, sigorādo a mapyan ako.” ");
INSERT INTO ivb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nanyeng do dawri a nagsardeng iyaw no kapayraraya naw, as kan nadidiw na pa abo danaw ganyit naw. ");
INSERT INTO ivb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ki nyeng a nadlaw ni Jesos a myan iyaw panakabalin a minohtot dya. Dawa, nayweswes as nakasalap na siras myanaw do dyichodan naw, as nakaiyahes na sya dyira a kāna, “Sino nangsalidayas laylay ko?” ");
INSERT INTO ivb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","“Namna!” tinbay dan nanawhen naw, “Maboya mwaya aro saw tawotawo a masyasidin do omdibon mwaya. Āngo paw yahsan mos nakasalid so laylay mo?” ");
INSERT INTO ivb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ki tinongtong ni Jesos nanyideb an sino nawri. ");
INSERT INTO ivb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nadlaw no mabakesaw naparinaw dya. Dawa, naypasngen do salapenaw ni Jesos a naychamirpirpir do kāmo na. Do nakapaydogod naranaw, inistorya na tabo naynamotan naw no nakasalid na sya. ");
INSERT INTO ivb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","“Balāsang ko,” kānan Jesos, “maynamot do nakapanganohed mwaya, ki napyan ka. Ngay, mayam ka na, kan myan pakono dyimo kaydamnayan no kapangtokto, as kan mariribokan ka paba a maynamot do dawri a ganyit.” ");
INSERT INTO ivb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ki do kadama paw ni Jesos a maychiychirin do mabakesaw, myan dana saw natoboy a yapod bahay ni Jayro a makabata sya a kon da, “Nadiman danaw balāsang mwaw. Āngo paw ringgoran mo si Maistro?” ");
INSERT INTO ivb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ki inkaskaso naban Jesos chirinaw no tobotoboyen saw, as basbāli a binata na di Jayro a kāna, “Mabakel kaba. Aryan mwabaw kapanganohed mwaya dyaken.” ");
INSERT INTO ivb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Do dawri, pinalobosan paba ni Jesos kawnot daw no tawotawowaw, malaksid di Pedro, as kan siraw maykaktehaw a sa Santiago kan Juan. ");
INSERT INTO ivb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Sinpangan na, do nakapakarapit daw do bahayaw ni Jayro, naboya ni Jesos rakohaw a riribok dan aro saw a tawotawo a maychatanyitanyis kan magdongdong-aw. ");
INSERT INTO ivb_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ki do nakasdep naw do bahayaw, inyahes na dyira a kāna, “Āngo pakalyak nyo a tomanyitanyis? Nadiman abaw nya balasītang, ta tod a nakaycheh.” ");
INSERT INTO ivb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ki chinamyeng das Jesos. Dawa, pinahbot na sa tabo tawotawowaw do bahayaw, as sira danaw inyapwan naw kan siraw nanawhen naw a tatdo nangay do kwartwaw no nadimanaw. ");
INSERT INTO ivb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Sinpangan na, inigpet ni Jesos tanorwaw no balasītangaw, as nakaibahey na syad chirin da, “Talita kom!” No chakey na batahen, “Balāsang ko, ibahey ko dyimo a maybangon ka!” ");
INSERT INTO ivb_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ki insigīda naybangon iyaw balasītangaw a dosi so tawen, as nakabidibidi na. Ki oltimo a chinasdaaw dan rarayayaw ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pinakaolit ni Jesos dyira a dyi da ibahebahey nya naparin do aran sino. Sinpangan na, inbahey na a pakanen daw balasītangaw. ");
INSERT INTO ivb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Sinpangan na, komnaro si Jesos do dawri a logar kan naybidi danad Nasaret a idi na, kan minonot sa dyaw nanawhen naw. ");
INSERT INTO ivb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ki do Arawaw a Kapaynaynahah, nangay si Jesos a nangnanawo do sinagoga. Ki oltimo a nasdaawan aro saw a nangadngey sya, as kan binatabata da a kon da, “Dino paro nanghanghapan na tabo siras nyaya? Maypāngo nakapatak na so komwan a sirib, kan maypāngo kaparin na siras milagro saya? ");
INSERT INTO ivb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Iyabawriw karpintirwaw a baro ni Maria, kan kakteh abawri da Santiago, Jose, Jodas, kan Simon? Asa pa, siraw kakakteh naw a mababakes, ki taywaran dyi sa omyan dya a masngen dyamen? Ay samna!” Nyaw binatabata dan nangadngeyaw di Jesos a nakoyid so aktokto a maynamot dya. ");
INSERT INTO ivb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Dawa, initbay ni Jesos dyira a kāna, “Iyaw propīta no Dyos, ki anyiben da do aran dino a logar, malaksid do bokod na idi, kakabagyan, kan pamilya.” ");
INSERT INTO ivb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Maynamot do kadēkey no kapanganohed da dya, pinarin nabaw aro a milagro do dawri, malaksid nakapalapaw naw so tanoro na dyirad papere saw a maganyit tan mapyan sa. ");
INSERT INTO ivb_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Chinasdaaw ni Jesos maynamot do dyi daw a panganohdan. Sinpangan na, nangay si Jesos a nangnanawo do kadwan saw a idiidi do omdibonaw do dawri a yanan. ");
INSERT INTO ivb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Do asaw a karaw do dawri, tinawagan sa ni Jesos asaw a poho kan dadwa nanawhen na, as nakatoboy na dyira taydodwa. Tinorohan na sas toray da a mangpaksyat so marahet saw a ispirito. ");
INSERT INTO ivb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","No inbilin ni Jesos dyira, ki mangyononot saba so aran āngo: kanen, bayon, mana kwarta do bolsa da, malaksid do sarokod da. ");
INSERT INTO ivb_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Binata na dyira a kāna, “Do kayam nyo, ki magsapatos kamo, kan mangyonot kamo abas aran āngo a pagsokatan nyo. ");
INSERT INTO ivb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","An myan iyaw ngayan nyo a idi, as myan mangrara dyinyo do bahay na, omyan kamo na daw mandad kakaro nyo do dawri a idi. ");
INSERT INTO ivb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","As an makarapit kamo do idi a dya mangrawat dyinyo kan chaskeh daynyo a adngeyen, karwan nyo sa, as kan wakwaken nyo ahbek naw no nawri a idi do kokod nyo a pamaneknek nyo dyira a sira danaw makatoneng anchan madosa sa.” Nawriw inbilin ni Jesos dyira. ");
INSERT INTO ivb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Do dawri, nangay dana saw nanawhen naw, kan inkaskasaba dad tawotawo a machita magbabāwi sad gatogatos da. ");
INSERT INTO ivb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pinaksyat daw aro a marahet a ispirito, as kan pinaptosan da saw maganyitaw so lana, ki napya sa. ");
INSERT INTO ivb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Sinpangan na, nadngeyan a tabo nyaya ni Āri Herodes, ta nagdinamag danaw pinariparinaw ni Jesos do dawri a logar. No binata dan kadwan a tawo, ki “Iyaw si Juan a Mamonyag a minirwa nabyay. As dawa, myan dyaw panakabalin a mamarin so komwan saw a milagro.” ");
INSERT INTO ivb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","As siraw kadwanaw, binata da a kon da, “Iyano si Elyas ah?” As myan paw nakabata sya a iya, ki asa propīta a akmas propīta saw do kaychowa. ");
INSERT INTO ivb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ki do nakadngeyaw syan Āri Herodes, inpapati na a kāna, “Oy! Iya si Juan a Mamonyag a inpapotoh ko! Aysa, napagongaraya!” ");
INSERT INTO ivb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Nyayaw binatan Herodes maynamot ta iyaw nangpatiliw kan nangpabahod di Juan a sikakawar. Pinarin Herodes nya maynamot do nakapachikontraw ni Juan di Herodes do nakakabahay naw so ipag naw a si Herodyas a baket ni ādi nas Pilipi. ");
INSERT INTO ivb_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ta do nakarahan, binata ni Juan di Herodes a kāna, “Malinteg abaw pinarin mwaya, ta sinodib mo baketaya ni ādi mo, kan myan pa sibibyay.” ");
INSERT INTO ivb_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Maynamot do dawri, inipsok ni Herodyas si Juan kan chakey na dimanen, ki maparin naba maynamot di Āri Herodes. ");
INSERT INTO ivb_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ta chamo ni Āri Herodes si Juan, ta chapatak na malinteg kan masantwan a tawo, dawa, inaywanan na maganay. Ki aran akma saw kapaybiybinakel ni Āri Herodes, chinakey na pa adngeyen chirinaw ni Juan. ");
INSERT INTO ivb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Sinpangan na, do nakasilibraraw ni Āri Herodes so kompli na, ki rinara na sa tabo āpohen daw no gobyirno kan siraw matotohosaw a torayen soldado kan siraw mabigbigbig saw a tawotawo do probinsya na a Galilya. Ki do dawri a silibrar, nachichwasan ni Herodyas gondaway na a mangipadiman si Juan. ");
INSERT INTO ivb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Do nakatadaw no balāsangaw a anak ni Herodyas do salapen ni Āri Herodes, oltimo a chinahwahok ni Herodes kan siraw bisīta naw nya balāsang. Dawa, binatan Āri Herodes dya a kāna, “Akdawen mo chakey mo a akdawen, kan itoroh konchi dyimo.” ");
INSERT INTO ivb_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Binata na pa a magkari, “Aran iyaw no kagodwayan pagaryan ko, an nawriw chakey mo a akdawen, ki itoroh ko.” ");
INSERT INTO ivb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ki do nakahtotaw no balāsangaw, yangay na inyahes di ānang na an āngo iyaw akdawen nad Āri Herodes. Binatan ānang na a kāna, “Iyaw ohwaw ni Juan a Mamonyag akdawen mo ah!” ");
INSERT INTO ivb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Naybabalay abaw balāsangaw a naypasngen di Āri Herodes, as nakakdaw na sya a kāna, “Changori, chakey kwa nanyeng a maiyangay dyaken iyaw ohwaw ni Juan a Mamonyag a mapadatok do tatakan.” ");
INSERT INTO ivb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Maynamot do dawri, taywara chinaynyin aktokto no āryaw, ki maynamot ta inkari na kan myan pa saw bisīta na, maparin na paba ibabāwi iyaw napabata naw do balāsangaw. ");
INSERT INTO ivb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Dawa, tinawagan Āri Herodes asaw a gwardya, as nakaimandar na sya a yangay na dyaw iyaw ohwaw ni Juan. Do dawri, komnaro iyaw gwardyaw a nangay a minpotoh si Juan a Mamonyag do yanan naw do bahodan. ");
INSERT INTO ivb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Sinpangan na, inyangay naw ohwaw ni Juan a napadatok do tatakanaw, kan inparawat nad balāsangaw. As iya, ki inyangay nad ānang na. ");
INSERT INTO ivb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Sinpangan na, do nakadngey daw syan nanawhenaw ni Juan, yangay da inhap iyaw bangkay naw, as nakaitanem da sya. Komwan nakadiman Juan a Mamonyag. ");
INSERT INTO ivb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Do dawri, naybidi saw apostolisaw ni Jesos do nakayapwan da saw a matatarek a idiidi a nangayan da, kan inbahey da di Jesos tabo pinarin kan innanawo daw. ");
INSERT INTO ivb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ki maynamot ta matatadi saw tawotawo a mawara kan komaro do yanan daw, ki aran kakan da Jesos, ki naisanga da paba. Dawa, binata ni Jesos dyirad nanawhen naw a kāna, “Ngay, mangay tad matarek a logar a abos tawo tan makapaynahah ta daw.” ");
INSERT INTO ivb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Do dawri, nayabang sa a nangay do logaraw a kabwan tawo. ");
INSERT INTO ivb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ki aro saw tawotawo nakaboya so nakakaro daw kan nakailasin dyira. As dawa, nayyayo saw tawotawowaw a yapod matatarek saw a idiidi a minbakhang sira. Sakbay a nakarapit sa Jesos kan siraw nanawhen naw do logaraw a kwanan da, myan dana sa mangnanayaw tawotawo saw. ");
INSERT INTO ivb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Do nakagchinaw ni Jesos do abangaw, naboya naw reprep saw a tawotawo kan taywaraw nakāsi na sira maynamot ta akma saw karniro a abo mangipastor sira. Dawa, insiknan naw nangnanawo so aro dyira. ");
INSERT INTO ivb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ki do kamakoyab naranaw, naypasngen sa di Jesos nanawhen naw, as nakabata da sya a kon da, “Īto danayaw kasdep no araw kan abayaw pagyanan dan tawotawo saya do dya ranso. ");
INSERT INTO ivb_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Dawa, payamen mo na saw tawotawowaya a mangay a gomātang so kanen dad masngen saya barbaryo.” ");
INSERT INTO ivb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ki tinbay san Jesos a kāna, “Inyo manoroh so kanen da ah!” Ki inyahes dan nanawhen naw a kon da “Samna! Chakey mori a mangay kami a gomātang so tinapay a balor no rinibribo tan ipakan namen dyira?” ");
INSERT INTO ivb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ki binatan Jesos dyira a kāna, “Papira paw myan a tinapay nyo? Yangay nyo pa chiban.” Ki yangay da chiniban nanawhen na saw, as nakapaybidi dad Jesos, kan binata da dya a kāna, “Ari paw dadima dana katinapay kan dadwa among.” ");
INSERT INTO ivb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ki inbilin ni Jesos dyira a paychakpekpehen da sa a maychadisdisnaw tawotawowaw do katamtamkanaw. ");
INSERT INTO ivb_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Dawa, naychadisdisna saw tawotawowaw do katamtamkanaw. Myan saw tayisa gasot a nakpekpeh, kan myan saw taydidima poho. ");
INSERT INTO ivb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Sinpangan na, inhap ni Jesos dadimaw a tinapay kan dadwaw a among, as nakatangay nad hanyit a nagyaman do Dyos. Sinpangan na, inakchikchid naw tinapayaw, as nakaitoroh na sya dyirad nanawhen naw tan idasar da dyirad tawotawo saw. Komwan pinarin na dyirad dadwaw a among tan maidatar dyira tabo. ");
INSERT INTO ivb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ki komninan sa tabo, kan nabsoy sa. ");
INSERT INTO ivb_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Myan paw kinonokon dan nanawhen naw a panda da, as kan nakapno pad asa poho kan dadwa kakalapay nabidin do tinapayaw kan amongaw. ");
INSERT INTO ivb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","As no bidang dan mahahakay lang a komninan do dawri, ki dadima a ribo. ");
INSERT INTO ivb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Do dawri, insigīda a pinayabang ni Jesos nanawhen na saw a mamtang a komwan do Betsayda, as pinaybidi na saw tawotawowaw do bahabahay da. ");
INSERT INTO ivb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Do nakapakayam daranaw, somnonget si Jesos do asaw a tokon a naydasal. ");
INSERT INTO ivb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ki do kapaysarisari naranaw, maychatanyi danas Jesos do tokonaw, ki myan pad hobokaw no minangaw abangaw a nagloganan dan nanawhen naw. ");
INSERT INTO ivb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Natalamad na sa a malidyatan a mangawod maynamot ta songat daw salawsaw. Ki do kaparbangon naranaw, romnapit si Jesos dyira, kan nayam do hapotaw no ranom. Do dawri, akma na say habasan. ");
INSERT INTO ivb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ki do nakaboya daw no nanawhen na saw si Jesos a myan a mayam do hapotaw no ranom, chināmo da kan nangagagay sa, ta no myan do aktokto da, iya, ki asa anyito. ");
INSERT INTO ivb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","On, taywaraw nakamo da do nakaboya daw sya a tabo. Ki do dawri, nyeng a naychirin si Jesos dyira a kāna, “Patoreden nyo aktokto nyo! Mamo kamo aba, ta yaken si Jesos.” ");
INSERT INTO ivb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Sinpangan na, somnakay si Jesos do abang daw, ki nyeng a nangheteng. Taywaraw nakaklat dan nanawhen naw. ");
INSERT INTO ivb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","On, komwan sa a maynamot ta aran tayoka a naboya daw no nakapayparo nas tinapayaw, ki alit na natokod dabaw kabīlegaw ni Jesos, ta matwa paw aktokto da. ");
INSERT INTO ivb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Do nakapakabtang daranaw, nakadok sa Jesos do tana a Genesaret, kan in-gwarni da daw abang daw. ");
INSERT INTO ivb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Sinpangan na do nakapakagchin daranaw, nanyeng da nailasin si Jesos no tawotawo saw. ");
INSERT INTO ivb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Dawa, naychapayapayayo saw tawotawowaw a nangay dyirad matatarek saw a idi do dawri a logar, as nakakpeh da siras maganyitaw, kan inisiw da sa inyangay do yananaw ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Do aran dino a nangayan Jesos a akmas porporok da saw, barbaryo da saw, kan siraw idiidi daw, ki naiyangay saw maganyitaw do paglaklakwan saw, as kan nachikakaāsi sa dya a aran iya lang sayranaw no laylay naw masalid da no maganyit saw tan mapyan sa. Do dawri, tabo san nakasalidaw, ki mapyan dana sa. ");
INSERT INTO ivb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Myan paw naypisa do asa karaw, naychipeh sa do yananaw ni Jesos siraw kadwan saw a Parisyo kan mangnanawo saw so linteg a yapod Jerosalem. ");
INSERT INTO ivb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Do dawri, nadlaw da siraw kadwan saw a nanawhen ni Jesos a dya monot do dadakay dan Jodyo do kapaybanaw sakbay no kakan. ");
INSERT INTO ivb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ta siraw Parisyowaw kan tabo saw Jodyowaw, ki inanohdan daw dadakay saya, ta nawriw inpatāwid dan inyaynyapwan da saw a koman saba, an dyi da manma kapyāhen maybanaw, ");
INSERT INTO ivb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","kan koman saba so aran āngo a yapod chindaan, an dyi da pa manma warsyan so ranom inawan da. Aro paw kadwan a anohdan da dadakay da no kapoonan da saw a akmas kapanoyas so bāso, banga, kan siraw longlonganaw a bronsi. ");
INSERT INTO ivb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Dawa, maynamot do dyaya dadakay da, inyahes dan Parisyowaw kan siraw mangnanawowaw so linteg di Jesos a kon da, “Āngo ta dyi sa manganohed nanawhen mwaya do dadakay dan kapoonan ta, ta kapyahen dabayaw maybanaw sakbay a koman sa?” ");
INSERT INTO ivb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ki inatbay san Jesos a kāna, “Maysinsīsingpet kamwaya! Oyod sawen binata ni Āpo Dyos a maynamot dyinyo do inpapadto na di propīta Isayas a naitolas do Masantwan a Tolas a kāna, ‘Siraw nya tawotawo, dayāwen da yaken do dangoy da, ki mabawaw aktokto da dyaken. ");
INSERT INTO ivb_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Abaw sirbin kaidaydāyaw da dyaken, ta inanawo daw linteg a pinarin tawo, kan batahen da a iyaw oyod a bilin no Dyos.’ ");
INSERT INTO ivb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Komwan kamo sichangori, ki ninonolay nyo bilinaw no Dyos, kan nawri danayaw anohdan nyo dadakayaw a inpatāwid no tawo.” ");
INSERT INTO ivb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Do dawri, tinongtong ni Jesos naychirin dyira a kāna, “Masisirib kamwaya a magpambar do nakapawadin nyos bilin no Dyos tan mawnonotan nyo inpatāwid daw no kapoonan nyo. ");
INSERT INTO ivb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ta chiban nyo intolasaw ni Moyses a kāna, ‘Dayāwen mo sa āmang mo kan ānang mo. As no aran sino a mangibahey so marahet a maynamot do inyapwan na, ki machita dimanen nyo.’ ");
INSERT INTO ivb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ki no inanawo nyowaya, ki matarekaya. Batahen nyowaya a an myan iyaw no maisidong no tawo do inyapwan na, ki maparin a dyi na itoroh. On, tod na ipambar a batahen dyira a iyaw isidong naw dyira, ki mabata a ‘Korban’.” No chakey na batahen korban, ki “naikari a naidāton do Dyos.” ");
INSERT INTO ivb_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","“Ki do dyaya a inanawo nyo, ki palobosan nyo pabaya sidongan na saw inyapwan na. ");
INSERT INTO ivb_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","On, maynamotaya do komwan saya a nanawo a natawid nyo, ninonolay nyo nayaw chirin no Dyos. Samna! Aro pa sayaw komwan a pariparinen nyo.” ");
INSERT INTO ivb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Do dawri, pinaypasngen san Jesos tawotawo saw dya, as kan binata na dyira a kāna, “Adngeyen nyo yaken, inyo a tabo, kan iktokto nyo a maganay tan maawātan nyo batahen kwaya. ");
INSERT INTO ivb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Makagatos abaw tawo do isobo na, an dya iyaw marahetaw a kapangtokto na a ihwa no dangoy na.  ");
INSERT INTO ivb_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Changori, inyo a myan so tadyinya, kadngeyen nyo ah!” ");
INSERT INTO ivb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Do nakakaro danaw ni Jesos siras tawotawowaw, somindep danad bahayaw. Ki do dawri inyahes dan nanawhen naw an āngo iyaw no chakey a batahen no pangarigan naw. ");
INSERT INTO ivb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ki binatan Jesos dyira, “Aran inyo, ki naawātan nyo pabawri? Chiban nyo kanen a isobo nyo. Taywaran pakagatosan nawri? ");
INSERT INTO ivb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Somdep abaw nawri do aktokto, an dya do bodek, as kan maipoha anchi.” No chakey a batahen ni Jesos, ki maparin a kanen aran āngo a kitan makan, kan pakagatosan aba. ");
INSERT INTO ivb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Sinpangan na, tinongtong ni Jesos nangibahey sya a kāna, “No mohtot do pangtoktwan no tawo iyaw nawriw pakagatosan. ");
INSERT INTO ivb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","On, no pangtoktwan tawo, ki nawriw paypātobwan paygatosan a akmas marahet a kapangtokto, kapaychakatekateh a machoknod, kapanakanakaw, kapangdiman, kapachikamalala, ");
INSERT INTO ivb_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kapayagom, kapamarin so marahet, kan kapangoskosit, kaderrep, kaimon, kapamaraherahet, kakospag, as kan abos arang a kaparin. ");
INSERT INTO ivb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","“Tabo san nyaya, ki yapo sad kapangtokto no tawo, as kan siraw nyayaw mapaygatos.” ");
INSERT INTO ivb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Do nakakarwaw ni Jesos do dawri a logar, ki nangay do logaraw a masngen do syodad nad Tiro, kan nachiyan do asaw a bahay daw. Do dawri, chaskeh na a myan makapatak sya, ki alit na napatakan dan tawotawo. ");
INSERT INTO ivb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Sinpangan na, myan asa a mabakes a myan so balasītang a intorayan marahet a ispirito. Do nakadamag naw a myan dana si Jesos, nyeng a nangay kan naydogod do salapen naw. ");
INSERT INTO ivb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Do dawri, nachikakaāsi di Jesos a paksyaten naw marahetaw a ispirito a nangitoray so anak naw. Ki iyaw nya mabakes, Jodyo aba, ta nayanak do Penisya do Sirya a tana, kan Griego iyaw no chirin na. ");
INSERT INTO ivb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Sinpangan na, initbay ni Jesos dyaw no nyaya pangarigan a kāna, “Machita pakanen a manmaw adedekey, ta maparin aba sodiben kanen daw a ipakan dyirad chito.” ");
INSERT INTO ivb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","“Na, oyod mo Āpo nawri,” initbay no mabakesaw. “Ki aran siraw chito do ohbwaw no lamisaan, ki dididen dabawriw mapaychahesday daw no adedekey an koman sa?” ");
INSERT INTO ivb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ki inatbay ni Jesos a kāna, “Maynamot do atbay mwaya, maparin mo naw maybidi, ta komnaro danaw marahetaw a ispirito do anak mwaw.” ");
INSERT INTO ivb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Do dawri, naybidi danaw mabakesaw. Ki do nakasabat naranaw, naboya naw anak naw a myan a maypoktad kan napya dana, ta komnaro danaw marahetaw a ispirito dya. ");
INSERT INTO ivb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Sinpangan na, komnaro sa Jesos do Tiro, kan nayam sa do Sidon a kominwan do Minangaw a Galilya a nandad nakapakarapit da do probinsya a Dekapolis. ");
INSERT INTO ivb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ki do dawri, myan saw nangyangay di Jesos so asa a mahakay a toleng kan dya makabnek. Nachikakaāsi sad Jesos a aran tod na palapawan so tanoro na tan mapyan nya mahakay. ");
INSERT INTO ivb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ki no pinarin Jesos, pinachibawa na dyirad tawotawowaw. Sinpangan na, pinaseseng na saw kamanongdo naw do tadyinya na saw no mahakayaw. Katayoka no nawri, napapot so chipa nad kamanongdo naw, as nakasalid nas ridaw no mahakayaw. ");
INSERT INTO ivb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tinangay ni Jesos hanyit, kan minawa so marahem, as nakabata na syad chirin da, “Eppata!” No chakey na batahen, ki “Manyiwang ka!” ");
INSERT INTO ivb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Do dawri, nyeng a nakadngey, as nakabnek mahakayaw, kan arabaw balibad na maychirin. ");
INSERT INTO ivb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ki maynamot do nyaya a naparin, binata ni Jesos a abaw pangibaheyan das nyaya. Ki an mango nakabilin sira ni Jesos, mangamangay paw nakaipadpadamag da sya. ");
INSERT INTO ivb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tabo san nakadngeyaw so nyaya dāmag, taywaraw nakaklat da, kan binatabata da a kon da, “Ay, oyod sawen a maganay a tabo pariparinen na! Ta aran sirayaw tolengaya, ki mapakadngey na saya, kan aran sirayaw dyaya makapaychirin, ki mapaylilyak na saya.” ");
INSERT INTO ivb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Do dawri, aro dana saw naychipeh a tawotawo do yananaw ni Jesos. Maynamot ta arabaw kanen da, tinawagan ni Jesos siraw nanawhen naw, as nakabata na sya dyira a kāna, ");
INSERT INTO ivb_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Chāsi ko sayaw nyaya tawotawo, ta napatawsan dana sayas bahon da, kan tatdo danaya karaw da dyaten do dya. ");
INSERT INTO ivb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","An paybidihen ko sa a mapteng, angwan mahohed kadwan do rarahan, ta mabawayaw sabatan dan kadwan dyira.” ");
INSERT INTO ivb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ki initbay dan nanawhen naw a kon da, “On, ki, ayya! Panghanghapan tas kanen dad nayraranswan taya? Chapakan tawri sira tabo?” ");
INSERT INTO ivb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ki inyahes ni Jesos dyira a kāna, “Papira paw tinapay nyowaya?” Ki initbay da, “Ari paw papito dana.” ");
INSERT INTO ivb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Do dawri, inbilin ni Jesos dyirad tawotawowaw a maychadisdisna sa do tana. Sinpangan na, inhap na saw papito saw a tinapay, as nakapagyaman na di Āpo Dyos. Ki do nakatayoka naw, inakchikchid na, as nakaitoroh na sya dyirad nanawhen naw tan idasar da dyirad tawotawo saw. Ki pinarin daw akmas inbilinaw ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Do dawri, myan papere a dedekey a natapan a among. Nagyaman si Jesos di Āpo Dyos a maynamot do dyaya, as nakaibahey na sya dyirad nanawhen naw a iraman da idasar dyirad tawotawowaw. ");
INSERT INTO ivb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Komninan sa tabo tawotawo saw, as kan nabsoy sa. Sinpangan na, myan paw kinonokon dan nanawhen naw a panda da, as kan nakapno pad papito a kakalapay nabidin do nakchikchidaw a tinapay kan among. ");
INSERT INTO ivb_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Do dawri, myan sa ngataw apat a ribo a tawotawo a komninan daw. Sinpangan na, pinaybidi dana san Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Do nakayam daw, nanyeng a naglogan sa Jesos kan siraw nanawhen naw do abangaw a kominwan do sakop naw do idyaw a Dalmanota. ");
INSERT INTO ivb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Do nakawara daw do dawri, yangay da sinogal no kadwan saw a Parisyo si Jesos. Inakdaw da pa dya a mapaboyas milagro tan sooten da an iya, ki yapod Āpo Dyos mana engga. ");
INSERT INTO ivb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Maynamot do dawri a inakdaw da, chinaynyin aktokton Jesos. As dawa, minnawa so marahem, as nakabata na sya dyira a kāna, “Āngo ta mangdaw nya kapotōtan so milagro? Oyod nya ibahey ko dyinyo a abanchi a polos maitoroh do dya kapotōtan!” ");
INSERT INTO ivb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Do dawri, kinarwan na sa, as kan minirwa naglogan do abangaw a namtang a nangay do kabtangaw no minangaw. ");
INSERT INTO ivb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ki do dawri, nawayakan dan nanawhen naw naybahon, malaksid do asaw lang a tinapay a myan dyira do abangaw. ");
INSERT INTO ivb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Sinpangan na, binata ni Jesos dyiraw no nya pangarigan a kāna, “Magannad kamo do yapo daw no Parisyo saw kan yapo ni Āri Herodes.” ");
INSERT INTO ivb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Do nakaibaheyaw ni Jesos so nya, nagsasarita saw nanawhen naw, kan binata da a kon da, “Komwanayaw batan Jesos, ata abayaw tinapay ta.” ");
INSERT INTO ivb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ki nadlaw ni Jesos iyaw no kapagsasarita daw, as dawa, inyahes na dyira a kāna, “Ay samna! Āngo ta nawriw pagsasaritaan nyo kabon tinapay nyo? Ari kamo pawri a dya makaboya mana ari nyo pawri a dya maawātan? Napangayan nyos aktokto nyo? ");
INSERT INTO ivb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Myanayaw mata nyo, ki makaboya kamo abawri? As myanayaw tadyinya nyo, ki bitor kamori? Manakem nyo pabawriw no nakapayparwaw no tinapay kan natapan a among? ");
INSERT INTO ivb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Do nakakchikchid kwaw so dadimaw a tinapay a kinan dan dadimaw a ribo a mahahakay, papira kakalapay panda a kinonokon nyo?” Ki initbay das Jesos a kon da, “Nakakonokon kami paw so asa poho kan dadwa kakalapay.” ");
INSERT INTO ivb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Sinpangan na, binata pan Jesos a kāna, “Naon, as kan do nakakchikchid kwaw so papitwaw a tinapay a kinan dan apataw a ribo a tawotawo, papira kakalapay panda a kinonokon nyo?” Ki initbay da, “Myan paw papito a kakalapay.” ");
INSERT INTO ivb_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Do dawri, binata ni Jesos dyira a kāna, “Na, nyawen! Ari kam pawri a dya makaāwat?” ");
INSERT INTO ivb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Do nakawara daw da Jesos do Betsayda, myan saw nangyangay so mahakay a bolsek kan nachikakaāsi sad Jesos a saliden na tan mapyan mahakayaw. ");
INSERT INTO ivb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Sinpangan na, kinaday ni Jesos iyaw no bolsekaw, as nakaihtot na syad gaganaw no idi. Do dawri, chinipan naw mataw no bolsekaw, as pinalapaw naw tanoro na dya, as kan nakaiyahes na sya dya a kāna, “Ariw maboya mo?” ");
INSERT INTO ivb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ki inwaras no mahakayaw kapanyideb na, as nakabata na sya a kāna, “On, makaboya ako nayas tawotawo, ki akma sayaw kayokayo a mayam.” ");
INSERT INTO ivb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Do dawri, minirwa sinalid ni Jesos iyaw no mataw no bolsekaw. Inmochideng no mahakayaw mata naw, ki napyan kan malawag danaw kapanyideb na. ");
INSERT INTO ivb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Sinpangan na, pinasabat ni Jesos, kan binilin na a kāna, “Taros ka na somabat ah, as kan somibah ka pabad idi.” ");
INSERT INTO ivb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Do dawri, komnaro sa Jesos kan siraw nanawhen naw do Galilya a nangay do barbaryo saw a omdibon do Sesarea Pilipos. Do kayan da paw do rarahan, inyahes ni Jesos nya dyirad nanawhen naw a kāna, “Ibahey nyo pa dyaken an sino ako do kapangtokto dan tawotawo.” ");
INSERT INTO ivb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Initbay da dya a kon da, “Na, binata daw no kadwan a imo kono si Juan a Mamonyag a minirwa nabyay, kan myan paw nakabata sya a imos Elyas. As siraw kadwan saw, ki batahen daw a asa ka kono a propīta ni Āpo Dyos do kaychowa a minirwa nabyay.” ");
INSERT INTO ivb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Ki inyo,” inyahes ni Jesos dyira, “sino ako do kapangtokto nyo?” Ki initbay ni Pedro a kāna, “Namna! Taywaran dya imos Kristo?” ");
INSERT INTO ivb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Do dawri, mainget a inbilin ni Jesos dyira a dyi da ibahebahey do aran sino a maynamotaw do kadyos na. ");
INSERT INTO ivb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Do dawri, insiknan ni Jesos a inanawo dyirad nanawhen naw a machita a rahanen no Tawo a Yapod Hanyit iyaw kalidyalidyat. Siranchiw panglakayen saw kan siraw matotohos saw a papadi kan siraw no mangnanawowaw so linteg, ki ipsok danchi, as kan iparawat danchi a madiman. Ki makarahan iyaw tatdo a karaw, ki mirwanchi a mabyay. ");
INSERT INTO ivb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ki maynamot ta malawag a inbahey ni Jesos maynamot do kadiman naya, pinachibawa ni Pedro so dēkey, as nakailyak na sya. ");
INSERT INTO ivb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ki inidit ni Jesos saw no nanawhen naw, as nakapaydabdab nad Pedro. Inbahey na dya a kāna, “Komaro ka dyam Satanas, ta nawryayaw iktokto mo chakey no tawotawo; iyabayaw chakey no Dyos!” ");
INSERT INTO ivb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Sinpangan na, tinawagan san Jesos tawotawowaw kan siraw no nanawhen naw, as nakabata na sya dyira a kāna, “No aran sino a makey a monot dyaken, ki machita a penpenen naw chakey na, isabhay naw kros na, as kawnot na dyaken. ");
INSERT INTO ivb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ta no sino a mangipateg so byay nad tanaya, alit na mabo na. Ki no tawo a madiman a maynamot do kapanganohed na dyaken kan kaiwaras nas Maganay a Dāmag, myan anchiw byay na abos pandan a itoroh anchi no Dyos dya. ");
INSERT INTO ivb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ta aryoriw magon-gona no tawo a madyira na tabo iyaw no myan do lobongaya, ki mabo naw byay na abos pandan do impyirno? Polos! ");
INSERT INTO ivb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","On, ta aryoriw maitoroh no asa tawo a panadi so byay na? Polos! ");
INSERT INTO ivb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","No mangyasnek dyaken kan iyaw chirin ko do salapen tawotawo saya sichangori a nailabay do gatos kan managdaydayaw do didyosen, ki pachisnek konchi anchan mawara ko. On, yaken a Tawo a Yapod Hanyit, ki pachisnek konchi anchan mawara ko a mangipaboya so dayag ni Āmang ko, kan pachirayayan da pan masantwan saw a anghilis.” Nawriw no binatan Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Binata na pa dyira a kāna, “Oyod nyaya ibahey ko dyinyo a siraw kadwan saya dyinyo dya sichangori, ki madiman sabanchi a mandad kaboya das pagtorayan ni Āpo Dyos kontodo panakabalin na.” ");
INSERT INTO ivb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nakapakarahanaw no anem a karaw, inhap ni Jesos sa Pedro, Santiago, kan si Juan a sira lang, kan somnonget sa do asaw a matohos a tokon. Do nakapakarapit daranaw daw, nyiknyinan a nagbalbaliw inawanaw ni Jesos do salapen da. ");
INSERT INTO ivb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Somnileng laylay naw, as kan oltimo a makapoyat kaydak na. Aba polos makapanyidak do dya tana so akmas kaydakaw no laylay naw. ");
INSERT INTO ivb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Sinpangan na, nagparang saw dadwaw a pachirawatan Āpo Dyos kaychowa a sa Elyas kan Moyses, kan myan sa machisarsarita di Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ki binata ni Pedro di Jesos, “Maistro, ay, angwa kagāsat no kayan taya dya! Maganay ngata an mamarin kamis tatdwa bengbeng: asa dyimo, asad Moyses, kan asad Elyas.” ");
INSERT INTO ivb_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Naychaychawawan Pedro a napabataw nya, ta chapatak naba polos an āngo kosto a ichirin na maynamot do taywaraw a nakamo da. ");
INSERT INTO ivb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Sinpangan na, nyiknyinan a inabongan sa no demdem, kan myan timek a yapod demdemaw a naychirin a kāna, “Iyaw nyaw Anak ko a oyod kos chadaw. Adngeyen nyo ibahey na!” ");
INSERT INTO ivb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nanyeng da inwaras kapanyideb da, ki abaw matarek a naboya da, an dyas Jesos a maychatanyi. ");
INSERT INTO ivb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Do kawsok daranaw, inbilin Jesos dyira a dyi da ibahebahey naboya daw do aran sino a mandad kapagongar naw anchi no Tawowaw a Yapod Hanyit. ");
INSERT INTO ivb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Do dawri, kinapikapya daw nawri a bilin ni Jesos dyira, ki alit na a naysin-iiyahes sa an āngo chakey na batahen kapirwa naya mabyay. ");
INSERT INTO ivb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Inyahes dad Jesos a kon da, “Na, āngo paro batan da sya no mangnanawowaya so linteg a machita manma mangay si Elyas sakbay a mangay si Kristo?” ");
INSERT INTO ivb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","“Naon,” initbay ni Jesos. “Kosto nawri a kapangnanawo da a mangay a manmas Elyas, kan pagsagānaen naw aktokto dan tawotawo. Ki nawri aba lang, ta myan paw naitolas do Masantwan a Tolas a maynamot dyaken a machita a lidyalidyaten kan oyawen da yaken a Tawo a Yapod Hanyit. ");
INSERT INTO ivb_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ki ibahey ko dyinyo a nangay danas Elyas, kan pinarin da dyaw aran āngo a chinakey da a akmas naitolasaw do Masantwan a Tolas a maynamot dya.” ");
INSERT INTO ivb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Do nakapaybidyaw ni Jesos kan siraw tatdwaw a kinayrayay na do yanan daw no nabidinaw a nanawhen na, naboya da saw arwaw a tawotawo daw. Myan pa daw tomaytayisa saw a mangnanawo so linteg a machisopsopyat dyirad nanawhenaw. ");
INSERT INTO ivb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Sinpangan na, do nakaboya daw no tawotawowaw si Jesos, akma say dya domninad tana, kan nanyeng sa naychapayapayayo a nangay a nangpadayaw sya. ");
INSERT INTO ivb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ki inyahes ni Jesos dyira a kāna, “Āngo pachisopyat nyo dyira?” ");
INSERT INTO ivb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","“Mo Maistro,” initbay no asaw dyirad tawotawo saw daw, “aryaw dyaw baro kwaw a inyangay ko dyimo. Pinagomelaw ngamin nangitorayaw sya marahet a ispirito. ");
INSERT INTO ivb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","An somrwaw marahetaw a ispirito a lomnogan dya, ki dipodiporisen naw, as kahabotab no dangoy na kan mayngaletnget paw, as kaksiw na. Chindaw ko naw dyirad nanawhen mwaya a paksyaten da, ki mapakaro dabaw a polos.” ");
INSERT INTO ivb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Do dawri, initbay ni Jesos dyira a kāna, “Inyo kapotōtan a abos anohed, anchan āngo kapanganohed nyo a aran nahay ako na minyan dyinyo? Mango pas kahay kaan-ānos ko dyinyo? Yangay nyo pa dyaken adekeyaya!” ");
INSERT INTO ivb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Sinpangan na, pinasngen da dyaw adekeyaw. Ki do nakaboyaw no marahetaw a ispirito si Jesos, pinaychamirpirpir naw adekeyaw, kan nalbad tana a nadipodiporis a homotahotab so dangoy. ");
INSERT INTO ivb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Inyahes ni Jesos do āmangaw no adekeyaw a kāna, “Kango paw nakapangrogin nyaya a mapariparin dya?” Ki tinbay no āmangaw no adekeyaw a kāna, “Nakayapo paw do kadēkey na. ");
INSERT INTO ivb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Masanyibaw a pakbongen no marahetaw a ispirito anak kwaya do apoy kan ahmesen naw do ranom tan rarayawen na. As dawa, machikakaāsi ako dyimo a chāsi kan sidongan mo pa yamen an arā mwa maparin.” ");
INSERT INTO ivb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Sinpangan na, binatan Jesos a kāna, “Āngo ta batahen mo a, ‘An maparin mo’? Aran āngo a parinen, ki maparin tawo a myan so anohed do Dyos.” ");
INSERT INTO ivb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ki nyeng a binatan āmangaw no adekey a kāna, “Manganohed ako, ki sidongan mo pa yaken do pagkorāngan ko!” ");
INSERT INTO ivb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Do nakaboyaw ni Jesos a omaribongbong saw tawotawo saw, minandaran naw marahetaw a ispirito a kāna, “Imo a ispirito a napagtoleng kan napagomel so adekeyaya, mohtot ka do dawri a adekey kan paybidyan mo paba polos.” ");
INSERT INTO ivb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Do dawri, nangagay marahetaw a ispirito, as kan naypataywaraw nakapaychamirpirpir nas adekeyaw, as kan do dawri, minohtot. Ki do nakapakahtot naranaw, akma danaw bangkay adekeyaw, as kan aro nakabata sya a nadiman dana. ");
INSERT INTO ivb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ki inigpet ni Jesos tanorwaw no adekeyaw, as nakabangon na sya, kan naytēnek adekeyaw. ");
INSERT INTO ivb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ki do nakapakasdep daranaw da Jesos kan siraw nanawhen naw do bahayaw, inyahes dan nanawhen naw so malimed a kon da, “Āngo ta napaksyat namen abaw marahetaw a ispirito?” ");
INSERT INTO ivb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ki tinbay san Jesos a kāna, “Mapaksyat abaw komwanaya marahet a ispirito, an dya manmaw kaipasnek nyo so kapaydasal nyo do Dyos.” ");
INSERT INTO ivb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Do dawri, komnaro dana sa Jesos kan siraw nanawhen naw daw, kan kinelsat dad Galilya. Chakey ni Jesos a dyi da mapatakan tawotawowaw yanan da, ");
INSERT INTO ivb_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ta madama na inanawo nyaya dyirad nanawhen naw a kāna, “Yaken a Tawo a Yapod Hanyit, ki mahayak paba maiparawat dyirad tawotawo a omdiman dyaken. Ki aran komwan, mirwa akonchi a mabyay do chatatdo naw a karaw.” ");
INSERT INTO ivb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ki do dawri, maawātan daban nanawhen naw nyaya a inbahey na dyira, as kan chamo daw manahes dya an āngo chakey naw a batahen. ");
INSERT INTO ivb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Sinpangan na, nakarapit sa do idyaw a Kapernaom. Do nakapakasdep danaw ni Jesos do bahayaw, inyahes na dyirad nanawhen naw a kāna, “Āngo kaychiw pagsosopyatan nyowaw do rarahan?” ");
INSERT INTO ivb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ki naychalilyak saba, ta do kayan daw do rarahan nawriw nagsosopyatan da an sino dyiraw kasisitaan. ");
INSERT INTO ivb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Do dawri, naydisna si Jesos, as nakatawag na siras asa pohwaw kan dadwa nanawhen na, as nakabata na sya dyira a kāna, “No magkalikagom a manma, machita a iyaw kapanawdyan kan magsirbi dyirad tabo tawotawo.” ");
INSERT INTO ivb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Sinpangan na, nanghap si Jesos so asa adekey, as nakapatēnek na sya do kahahatangan daw. Sinpangan na, kinepkep na, as nakabata na sya dyira a kāna, ");
INSERT INTO ivb_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“No aran sino a mangrawat so mabodis so saad a akmas nyaya adekey a maynamot do kapanganohed na dyaken, yaken rawaten na. As no aran sino a mangrawat dyaken, yaken aba lang rawaten na, an dyi pa iyaw nanoboyaw dyaken.” ");
INSERT INTO ivb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Binata ni Juan di Jesos a kāna, “Mo Maistro, naboya namenaw asaw a tawo a napaksyat so marahet saw a ispirito a maynamot do kaosar nas ngaran mo, ki binaywan namen, ata, rarayay tabaya.” ");
INSERT INTO ivb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ki binata ni Jesos a kāna, “Baywan nyo aba, ta an myan makaparin so milagro a maynamot do kaosar nas ngaran ko, maparin naba a pasaronwan so maikontra dyaken. ");
INSERT INTO ivb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","No dya machikontra dyaten, ki rarayay taw nawri. ");
INSERT INTO ivb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","No ibahey kwaya dyinyo, ki oyod a aran sino a mapaynom dyinyo so asa kabaso a ranom maynamot ta dyira naynyo ni Kristo, syirto a gon-gonaan anchiw nawri a tawo.” ");
INSERT INTO ivb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Do dawri, tinongtong ni Jesos naychirin a kāna, “No aran sino a mangsolisog tan makagatos aran asa lang dyirad nyaya mawnged pa so kapanganohed dyaken, ki maganaganay pa adayo an mapaytanan so rakoh a bato a gilingan lagaw naw, as kaitapwak syad tāw. ");
INSERT INTO ivb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","As dawa, an tanoro mwaw pakayapwan kapaygatos mo, akteben mo. Maganaganay an pokol ka a somdep do hanyit kan iyaw myanaw dadwa tanoro mo a maitapwak do impyirno a yanan apoy a dya mawsepan.  ");
INSERT INTO ivb_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Do dawri, madiman sabaw ohed, as kan iyaw apoyaw, ki mawsep aba. ");
INSERT INTO ivb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ki an iyaw kokod mwaw pakayapwan pakachichadan mo do kapaygatos, akteben mo! Maganaganay an piday ka a somdep do abos pandan a byay kan myanaw so dadwa a kokod a maitapwak do impyirno.  ");
INSERT INTO ivb_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Do dawri, madiman sabaw ohed, as kan iyaw apoyaw, ki mawsep aba. ");
INSERT INTO ivb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","An iyaw mata mwayaw pakayapwan kapaygatos mo, hawhawen mo. Maganaganay a bolsek ka a somdep do pagtorayan no Dyos kan myanaw so dadwa mata a maitapwak do impyirno. ");
INSERT INTO ivb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Do dawri, madiman sabaw ohed, as kan iyaw apoyaw, ki mawsep aba. ");
INSERT INTO ivb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Oyod a myan kalidyatan a pasaren tabo tawotawo a nawriw mapaganay so dadakay da a akmas apoyaw kan asin a mapaganay so taham no ichan. ");
INSERT INTO ivb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Oyod a masirbiw asin, ki an tomnabang, maybidi pawriw payit naw? Dawa, iktokto nyo chakey a batahen asinaya, as kan sikakapya kamo tan myan kapagtotonos nyo.” Nawriw binatan Jesos dyira. ");
INSERT INTO ivb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Do dawri, komnaro dana daw si Jesos, as nangay do probinsya a Jodya. Sinpangan na, namtang do Oksong a Jordan. Ki do nakapamtang naw daw, minirwa dana saw reprepaw a tawotawo a naychipeh do yanan naw. Do dawri, ninanawo na sa a akmas sigodaw a pariparinen na. ");
INSERT INTO ivb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Sinpangan na, naypasngen di Jesos kadwan saw a Parisyo tan sooten da. Inyahes da dya an maipalobos do linteg an pasyayen mahakay kabahay na? ");
INSERT INTO ivb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ki inyahes ni Jesos dyira a kāna, “Āngo inbilin Moyses dyinyo?” ");
INSERT INTO ivb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","“Na, inpalōbosaw ni Moyses. Basta maytolas mahakayaw so pakaboyan a maysyay sa, as kapayam naranas baket naw,” binata da. ");
INSERT INTO ivb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ki tinbay san Jesos, “On, maynamot do katwayan oho nyo, nawriw intolasanaw ni Moyses so nawri a bilin. ");
INSERT INTO ivb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ki no pinarin napaytawo do nakapamarswa na, pinarin na sa mahakay kan mabakes. ");
INSERT INTO ivb_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Akmas naitolasaw do Masantwan a Tolas a kāna, ‘Dawa, nyaw paynamotan na a karwan mahakay āmang kan ānang na an machikabahay. Tan komwan, komplito kapayrapa da kan baket na, ");
INSERT INTO ivb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","as kan sira dadwa, ki mayparin dana sa asa bayo a pamilya.’ ");
INSERT INTO ivb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","As dawa, no pinayrapan Dyos a pinayparin a asa, dyi pakono a paysyayen tawo.” ");
INSERT INTO ivb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Do nakapaybidi darana da Jesos do bahayaw, inyahes dan nanawhen naw maynamot do dyaya. ");
INSERT INTO ivb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ki tinbay sa ni Jesos a kāna, “No aran sino a mapasyay so baket na, as mangabahay so matarek, ki makagatos do baket naw a nanma so kapachikamalala. ");
INSERT INTO ivb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Komwan iyaw mabakes a mapasyay so lakay na, as kapachikabahay nad matarek, makagatos do nanomaw a lakay na so kapachikamalala.” ");
INSERT INTO ivb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Myan paw naypisa do asa karaw, nangyangay sa di Jesos so adedekey da tan saliden na sa a bindisyonan. Ki siraw nanawhen naw, pinaydabdab da sa. ");
INSERT INTO ivb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ki do nakaboyaw sya ni Jesos so nawri a pinarin dan nanawhen naw, ki nakasoli, kan binata na dyira a kāna, “Palobosan nyo saw adedekey saya a mangay dyaken, kan baywan nyo saba, ta siraw akma syay a adedekey akin dyira so pagtorayan no Dyos. ");
INSERT INTO ivb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","No ibahey ko dyinyo, ki oyod. No aran sino a dya machiyengay so kapangrawat so pagtorayan no Dyos a akmas kapangrawataw no nya saya adedekey, sigorādo a mairaman abanchi daw.” ");
INSERT INTO ivb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Sinpangan na, tinayitayisa na sa kinepkep adedekeyaw. Pinalapaw naw tanoro naw dyira, as nakabindisyon na sira. ");
INSERT INTO ivb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Do kapagrobwataw ni Jesos a komaro daw, myan asa mahakay a nayyayo a nangay dya. Naydogod do salapenaw ni Jesos, as nakaiyahes na sya dya a kāna, “Mo maganay a Maistro! Āngo machita a parinen ko tan madyira ko byay a abos pandan?” ");
INSERT INTO ivb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ki binata ni Jesos dya a kāna, “Āngo ta pangaranan mo yaken so maganay? Abaw maganay, an dya iya lang Dyos. ");
INSERT INTO ivb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Chapatak mo na saw bilbilinaw do linteg: ‘Mangdiman kaba, machikamalala kaba, manakanakaw kaba, mangipaneknek kabas bayataw, magkosit kaba, as kan dayāwen mo saw inyapwan mo saw.’” ");
INSERT INTO ivb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","“Na, Maistro, yapo pa do kadēkey ko, ki tinongtongpal ko na sa tabo nyaya bilbilin,” initbay no mahakayaw. ");
INSERT INTO ivb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ki naayatan si Jesos a nangperreng sya. Sinpangan na, binata na dya a kāna, “Ari paw asa pagkorāngan mo. Yangay mwa ilāko kinabaknang mwaw, as kaitoroh mo sya dyirad mapopobri saw so naglakwan mwaw tan myan anchiw kinabaknang mod hanyit. Katayoka na, monot ka dyaken.” ");
INSERT INTO ivb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ki do nakaichirinaw ni Jesos so nyaya, naopay mahakayaw, as kan nagmamayo a komnaro daw maynamot ta taywaras kabaknang. ");
INSERT INTO ivb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Do dawri, inwaras ni Jesos nanyideb, as nakabata na sya dyirad nanawhen naw a kāna, “Ay, āngo nchya kalidyat no myan sayas kinabaknang a somdep do pagtorayan no Dyos!” ");
INSERT INTO ivb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Chinasdaaw dan nanawhen naw a maynamot do dyaya chinirin na, ki tinongtong ni Jesos a binata, “Ay, inyo a anak ko, iyaw kapakasdep do pagtorayan no Dyos, ki oyod nas kalidyat! ");
INSERT INTO ivb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Maydaydamnay kapayhawos no binyay a kamilyo do wayan rayem kan kasdep no mabaknang do pagtorayan no Dyos.” ");
INSERT INTO ivb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Maynamot do dawri a chinirin Jesos, ki taywaraw kapakasdaaw da, as kan napenpen dabaw dangoy da a nangiyahes sya a kon da, “Na, an komwan, sino dana paronchiw maisalakan?” ");
INSERT INTO ivb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ki pinerreng san Jesos, as nakabata na sya dyira a kāna, “Maparin aba polos no tawo do aran āngo a pamosposan. Ki no Dyos, maparin na a parinen aran āngo.” ");
INSERT INTO ivb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Sinpangan na, binata ni Pedro dya a kāna, “Namna! Maypāngo kami na? Kinarwan namen dana saya tabo do nakawnot namenaya dyimo!” ");
INSERT INTO ivb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","“Naon!” kānan Jesos. “No ibahey ko dyinyo, ki oyod. No aran sino a omkaro so bahay na, kakakteh na saw mana inyapwan na, anak na saw mana tana na a maynamot dyaken kan Maganayaya Dāmag, ");
INSERT INTO ivb_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ki masorsorok panchi kan ginasgasot rawaten na do kayan na paw a sibibyay sichangori kan iyaw baloraya no kinarwan na saya. On, arwaronchiw bahay, kakakteh, inyapwan, anak, kan tana na. Komwan pa do karon kalidyatan, as do kapanawdyan anchi a araw, ki rawaten nanchiw byay na a abos pandan. ");
INSERT INTO ivb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ki aro saw nanmanma sichangori a maybadiw a manawdyinchi, kan myan saw nanawdyi a manmanma anchi.” ");
INSERT INTO ivb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Do dawri, somnonget dana sa Jesos kan siraw nanawhen naw a kominwan do Jerosalem. Si Jesos, ki myan do panman daw no nanawhen naw, as kan oltimo a masmasdaaw sa. Do panawdyan daw, ki siraw tawotawo saw a mamo an āngo maparin anchi daw. Sinpangan na, pinirwa pinachibawa ni Jesos asa poho saw kan dadwa a nanawhen na, kan inbahey na dyiraw mapariparinaw anchi dya. ");
INSERT INTO ivb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Adngeyen nyo,” binata na. “Somonget ta do Jerosalem, ki do dawri maiparawat akonchi a Tawo a Yapod Hanyit dyirad matotohos saw a papadi kan siraw mangnanawowaw so linteg. Ikeddeng danchi yaken a madiman, as kan iparawat danchi yaken dyirad dyaw a Jodyo. ");
INSERT INTO ivb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Do dawrinchi, oyawen danchi yaken, as kachichipa danchi dyaken, sapsaplitan, as kan dimanen danchi yaken. Ki makarahan tatdo a karaw, mirwa akonchi a mabyay.” ");
INSERT INTO ivb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ki do kadama daw a mayam, naypasngen di Jesos anak saw ni Sebedeo a sa Santiago kan Juan, as nakaiyahes da sya dya a kon da, “Mo Maistro, ari paw chakey namen a akdawen dyimo.” ");
INSERT INTO ivb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“Na, āngo chakey nyo a parinen ko dyinyo?” initbay ni Jesos dyira. ");
INSERT INTO ivb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ki nawriw inakdaw dad Jesos a kon da, “Palobosan mo pa yamen a machipaydisna anchi dyimo anchan maidayaw ka do pagtorayan mo: asa do mangketaw do kawanan mo, as asa do mamangketaw do kaholi mo.” ");
INSERT INTO ivb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ki binatan Jesos dyira a kāna, “Chapatak nyo abayaw akdawen nyowaya. Maibtoran nyoriw kalidyatan a akmanchis pasaren kwaw, kan aryoriw tored nyo a madiman a akmanchis kadiman ko?” ");
INSERT INTO ivb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ki initbay da dya a kon da, “Na, maparin namen.” Do dawri, binatan Jesos dyira a kāna, “On, ibtoran nyonchiw kalidyatan a akmas kalidyatan kwaw anchi, as kan madiman kamonchi a akmas kadiman kwaw anchi, ");
INSERT INTO ivb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ki yaken abaw mamidi an sinonchiw maydisnad kawanan ko mana do kaholi ko, ta no Dyos anchiw manoroh siras insagāna naw.” ");
INSERT INTO ivb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ki do nakadngey daw no rayay saw a asa poho a nanawhen so nyaya, nakasolyan da sa Santiago kan Juan. ");
INSERT INTO ivb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","As dawa, tinawagan sa tabo ni Jesos nanawhen naw, as nakabata na sya dyira a kāna, “Chapatak nyo a siraw mangitoray so tawo do lobongaya, ki adipenen da saw itorayan daw. As siraw āpohen daw, ki itorayan da saw tawotawo da saw. ");
INSERT INTO ivb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ki dyi pakono komwan parinen nyo. No magkalikagom a iyaw torayen, machita iyaw magsirbi dyinyo. ");
INSERT INTO ivb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","As no magkalikagom a iyaw katotorayan, ki machita paadipen dyirad tabo tawotawo. ");
INSERT INTO ivb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Toladen nyo pakono yaken a Tawo a Yapod Hanyit, ta nangay akwaba dya a pagsirbyan tawotawo, an dya yaken magsirbi dyira. On, nangay ako a madiman tan isalākan ko saw tawotawo.” ");
INSERT INTO ivb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Do dawri, nakapakarapit daw da Jesos kan siraw nanawhen naw do asaw a idi a Jeriko. Minonot sa dyiraw reprep saw a tawotawo. Sinpangan na, do kakaro daranaw do dawri a idi, myan daw a maydisnad payisaw no rarahan a magpalpalimos asaw a bolsek a si Bartimeo a anak ni Timeo. ");
INSERT INTO ivb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ki do nakadngey naw sya a myan si Jesos a taga Nasaret, inyagagay na a kāna, “Jesos a kapotōtan ni Āri Dabid, chāsi mo pa yaken!” ");
INSERT INTO ivb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ki aro naydabdab dya, kan inbahey da a magolimek, ki alit na naypataywaraw nakaiyagagay na sya a kāna, “Kapotōtan Āri Dabid, chāsim pa yaken!” ");
INSERT INTO ivb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Do dawri, nagsardeng si Jesos do kayam naw, as nakabata na sya a kāna, “Yangay nyo pa dya.” Nangay sa do bolsekaw, as kan binata da dya a kon da, “Patorden mo aktokto mo! Maytēnek ka, ta ipatawag naw imo.” ");
INSERT INTO ivb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Do nakadngeyaw syan Bartimeo, nyeng na pinawakdit kekeh naw, as nakapaytēnek na a nangapikapyas a nangay di Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Sinpangan na, inyahes ni Jesos dya a kāna, “Āngo chakey mo a parinen ko dyimo?” Ki binata no bolsekaw dya a kāna, “Mo Maistro, chakey ko makaboya.” ");
INSERT INTO ivb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Do dawri, binata ni Jesos dya a kāna, “Mayam ka na, ta maynamot do nakapanganohed mwaya, ki napyan ka na.” Ki nyeng a nakaboyaw bolsekaw, kan minonot dana di Jesos do rarahanaw. ");
INSERT INTO ivb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Do nakapaypasngen daw do Jerosalem, do kasngen daranaw do tokonaw a mayngaran so Olibo, do masngenaw do idi saw a Betpage kan Betanya, nanoboy si Jesos so dadwa dyirad nanawhen naw. ");
INSERT INTO ivb_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Binata na dyira a kāna, “Mangay kamo pa do masngenaya a idi do bitaya no rarahan, as kan do kapakarapit nyo daw, maboya nyonchiw naigalotaw a orbon no asno a dyi pa nasaksakayan. Obayan nyo, as kaiyangay nyo sya do dya. ");
INSERT INTO ivb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","An myan mangyahes dyinyo an anghen nyo asnwaw, ibahey nyo a, ‘Machita ni Āpo a pagsakayan na, as kan insigīda a pabidyen nanchi dya.’” ");
INSERT INTO ivb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Do dawri, nayam dana sa, kan nasarakan daw orbonaw no asno a myan do kalsada, kan naigalot do pantawaw no bahay. Sinpangan na, inobay da. ");
INSERT INTO ivb_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ki siraw maychatetēnek saw daw, binata da dyira a kon da, “Anghen nyo a obayan orbonayan asno?” ");
INSERT INTO ivb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ki initbay dan dadwaw a nanawhen inbilinaw ni Jesos dyira, dawa, pinalobosan da sa. ");
INSERT INTO ivb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Sinpangan na, inyangay daw orbonaw do yananaw ni Jesos. Pinaap-ap da saw kagay daw, as nakapagsakay ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Do dawri, aro a tawo namolay so kagay dad rarahanaw. Siraw kadwanaw, ki nanghap sas mabohong saw a sangasanga no kayo a tinongeh da yapod hakawan saw, as nakaparasay da syad ayamanaw ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Siraw myanaw do panmanaw kan panawdyan Jesos, ki inngengengey da a kon da, “Madaydayaw kan maitoroh pakono bindisyon do tinoboyaya ni Āpo Dyos a pinakainawan na! ");
INSERT INTO ivb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mabindisyonan pakono nyaya a mangay a maytēnek do pagaryanayan Āri Dabid a kapoonan ta. Madaydayaw si Āpo Dyos do katotohosan a hanyit!” ");
INSERT INTO ivb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Do nakapakarapit daw da Jesos do Jerosalem, nangay si Jesos do Timplo. Sinpangan na, chiniban na tabo omdibon naw, ki maynamot ta makoyab dana, naybidi sa Jesos kan siraw nanawhen naw do idi a Betanya. ");
INSERT INTO ivb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Do somaronwaw a araw, do nakayapo daranaw do Betanya, naptengan si Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Do dawri, naboya ni Jesos kayo a igos a maraboy so bohong do mabawaw so dēkey dya. Dawa, yangay na chiniban an myan asi na. Ki do nakapakarapit naranaw, abaw naboya na, an dyi lang a iyaw bohong naw, ta ari pad chimpo no kapay-asi na. ");
INSERT INTO ivb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ki maynamot ta abaw naboyan Jesos a asi na, inbahey na a kāna, “Abo pakononchi a polos koman so asi mo!” Do dawri, nadngey dan nanawhen naw binataw ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Do nakapakarapit daw do Jerosalem, somindep si Jesos do atataw no Timplowaw. Sinpangan na, pinahbot na saw maglaklakwaw kan siraw magatgatangaw daw. Pinasakeb na saw lamisaan saw no manatadi saw so kwarta, as kan kinwan na saw bangko da saw no maglaklāko saw so kalapāti. ");
INSERT INTO ivb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Aba polos pinalobosan na a myan so rara a lomasat do sakopaw no Timplo. ");
INSERT INTO ivb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Sinpangan na, ninanawo na saw tawotawowaw daw, kan binata na dyira a kāna, “Naitolas abawri do Masantwan a Tolas a kāna, ‘No bahay ko, ki matawagan anchi so yanan a paydasalan no tabo tawotawo.’ Ki inyowaya, ki pinayparin nyowaya bahay dan manakanakaw.” ");
INSERT INTO ivb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Do nakadamag daw so nyaya no matotohos saw a papadi kan siraw mangnanawowaw so linteg, inrogi da a chinichwas an maypāngo kadiman da sya, ta chināmo da, ta siraw tawotawo saw, ki taywaraw kaskasdaaw da do innanawowaw ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Do kapaysarisari naranaw, komnaro sa Jesos kan siraw nanawhen naw do Jerosalem. ");
INSERT INTO ivb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Do kamabekasan naranaw do somaronwaw a araw, do kayam daw do rarahan, naboya daw kayowaw a igos a nahayo dana tabo bohong naw kontodo yamot na saw. ");
INSERT INTO ivb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ki do dawri, nanakem ni Pedro nakaabayaw syan Jesos, kan binata na a kāna, “Mo Maistro, chiban paw kayowaya a igos a inabay mo, ki nadiman danaya!” ");
INSERT INTO ivb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Initbay ni Jesos dya a kāna, “Myan pakono kapanganohed nyo do Dyos. ");
INSERT INTO ivb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","No ibahey ko dyinyo, ki oyod. An mamandaran nyo nyaya tokon a kon nyo, ‘Makatkat ka pakono dya a maipatapwak do tāw,’ as kan anohdan nyo a abo polos kapagmangamanga nyo a maparin inbahey nyowaw, ki syirto a maitoroh anchi dyinyo katongpal na. ");
INSERT INTO ivb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","As dawa, ibahey ko dyinyo a aran āngo a akdawen nyo do dasal nyo, as anohdan nyo a narawat nyo na, maitoroh anchi dyinyo. ");
INSERT INTO ivb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ki aran komwan, machita a kāda maydasal kamo, an myan ipsok nyo dyirad aran sino, ki pakawanen nyo tan pakawanen naynyo ni Āmang nyo a Dyos do hanyit do gatogatos nyo.  ");
INSERT INTO ivb_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ki an dyi nyo a pakawanen tawotawo a nakagatos dyinyo, pakawanen nabanchi inyo ni Āmang nyo a Dyos do hanyit do gatogatos nyo.” ");
INSERT INTO ivb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Do nakapaybidi daw da Jesos do Jerosalem, minidibidi do atataw no Timplowaw. Sinpangan na, inasngenan dan matotohos saw a papadi kan siraw mangnanawowaw so linteg, as kan siraw panglakayen daw no Jodyo saw si Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Binata da dya a kon da, “Iyaw pinarin mwaya kakoyab do Timplowaya, ki dino nanghapan mos toray, mana sino nangmandar dyimo a omparin siras syay?” ");
INSERT INTO ivb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ki tominbay si Jesos dyira a kāna, “Sakbay a atbayen ko, ari paw iyahes ko dyinyo. Ta an matbay nyo, ayket, atbayen ko iyahes nyowaya dyaken an sino nanoroh so toray ko a mamarin siras nyaya. ");
INSERT INTO ivb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Dino nakayapwan torayaw ni Juan a Mamonyag a mangbonbonyag: yapo do Dyos mana yapod tawo? Atbayen nyo pa!” ");
INSERT INTO ivb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ki nagsisinopyat sa, kan naysin-aatbay sa do katakatayisa dyira a kon da, “Āngo itbay ta? An ibahey ta a, ‘Yapod Āpo Dyos,’ iyahes nanchyori dyaten an āngo ta dyi ta nanganohed di Juan? ");
INSERT INTO ivb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ki an batahen tawri a, ‘Yapod tawo’? Aysa! Engga ah,” kon da. Nyaw binata da maynamot ta mamo sad tawotawo saw daw, ata, nanganohed tabo tawotawo di Juan Mamonyag a iya, ki oyod a propīta no Dyos. ");
INSERT INTO ivb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","As dawa, no initbay dad Jesos, ki “Chapatak namen aba.” Sinpangan na, binata ni Jesos dyira a kāna, “An komwan, ibahey kwaba dyinyo an āngo toray ko a mamarin so akma siras nya.” ");
INSERT INTO ivb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sinpangan na, tinongtong ni Jesos nagpangarigan dyira a kāna, “Myan asa tawo a naymoha so aro a obas do kaobāsan naw, kan dinibon na a inahadan. Nakapamarin na pa so pangatsan na kan angangaw a bato a pangapyan naw so asoyaw a ipaates nanchi. Sinpangan na, napatnek pas bengbeng a pagbantayan na. Do katayoka naranaw, inpaābang na dyirad pinagbantay naw, as nakapagbyahi na. ");
INSERT INTO ivb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Do chimpo danaw no kapaychamomolas, tinoboy no nagpaābangaw iyaw tobotoboyen naw a mangay dyirad nangipaābangan naw tan mangay a manghap so binglay naw. ");
INSERT INTO ivb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ki siraw nangipaābanganaw, tiniliw daw tinoboy naw, as nakamalo da sya, kan pinaybidi da a aba polos intoroh da dya. ");
INSERT INTO ivb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Sinpangan na, minirwa dana nanoboy nagpaābangaw. Ki linichitan daranan nachiābangaw, as nakasnesnek da sya. ");
INSERT INTO ivb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Sinpangan na, nanoboy danas matarek, ki diniman darana. Komwan paw pinarin da dyirad tabo saw a tobotoboyen na. Myan saw minalmalo da, kan diniman daw kadwan. ");
INSERT INTO ivb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Do dawri, apabaw nabidin a maparin na toboyen, malaksid do mismo naw a anak a oyod nas chadaw. Dawa, iya danaw tinoboy na, kan binata na a kāna, ‘Ay, syirto a anyiben daw anak kwaya.’ ");
INSERT INTO ivb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ki do nakawara naw do kaobāsanaw, binata dan machiab-ābangaw do katakatayisa dyira a kon da, ‘Iya danaw nyayaw mangtawidaw so kaobāsanaya. Ngay, yangay ta dimanen tan dyaten danaw kaobāsanaya!’ ");
INSERT INTO ivb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Sinpangan na, tiniliw da, as nakadiman da sya, as nakaipoha das bangkay naw do gaganaw no kaobāsan.” ");
INSERT INTO ivb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Do dawri, inyahes ni Jesos dyirad tawotawowaw a kāna, “Āngonchiw parinen akin dyiraw so kaobāsanaw? Syimpri, yangay na sanchi a dimanen pinaabāngan naw so kaobāsan naw, as kaipaābang nanchi sya do matarek. ");
INSERT INTO ivb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nabāsa nyo abawriw nyaya chirin no Dyos a naitolas do Masantwan a Tolas a kāna, ‘Iyaw nawri a bato a inpoha dan mapatnek saw so bahay, ki nayparin a iyaw kasisitaan a bato a mangpayit so nawri a bahay. ");
INSERT INTO ivb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Iyaw nyaw pinarin no Dyos, kan taywara maganay kan makaskasdaaw do kapakaboya ta?’” ");
INSERT INTO ivb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Sinpangan na, chakey dan āpohenaw no Jodyo a ipatiliw si Jesos, ta maawātan da a chinirichirin naw nyaya a pangarigan a pachikontra na dyira. Ki maynamot ta mamo sad aro saw a tawotawo, tod darana kinarwan. ");
INSERT INTO ivb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Do dawri, nanoboy sas papere a Parisyo kan siraw kadwanaw a nanawhen Herodes tan asdosdoken das Jesos maynamot do kapanahahes da. ");
INSERT INTO ivb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nangay sa dya, kan binata da a kon da, “Mo Maistro, chapatak namen a tabo a ichirin mo, ki oyod. Chapatak namen pa a mangidomdoma kaba, kan itatārek mo sabaw matohos so saad. Abaw matarek a inanawo mo, an dyi lang a iyaw oyodaw a chakey no Dyos a parinen tawotawo. Sichangori, ibahey mo pa dyamen an maikontra do linteg iyaw kapagbayad namen so bwis do impirador do Roma? Āngo mabata mo? Magbayad kami mana engga?” ");
INSERT INTO ivb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ki maynamot ta chinapatak ni Jesos kapaysinsīsingpet da, binata na dyira a kāna, “Āngo ta sooten nyo yaken? Torohan nyo pa yaken so plata, ta chiban ko pa.” ");
INSERT INTO ivb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tinorohan da so plataw. Do dawri, inyahes na dyira a kāna, “Sino akin ladawan kan akin ngaran syay?” Ki initbay da dya, “Nas Impirador.” ");
INSERT INTO ivb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Do dawri, binata ni Jesos dyira a kāna, “Na, an komwan, itoroh nyod Impirador dyira naw, as itoroh nyo do Dyos dyira naw.” Do nakadngey daw so nyaya, ki oltimo nakasdaaw da a maynamot do kasiribaw ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Do dawri, myan saw nangay di Jesos a yapod gropo dan Sadosyowaw a siraw Jodyo saw a makabata a dya mirwa mabyay nadiman. ");
INSERT INTO ivb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Inyahes da dya a kon da, “Maistro, intolas ni Moyses nyaya linteg dyaten a Jodyo a kāna, ‘An madiman iyaw asa mahakay, as makarwan naw baket naw a abo pas pōtot, machita ahapen a kabahayen kakteh naw tan pototan na so pinakaanak no kakteh naw a nadiman.’ ");
INSERT INTO ivb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“An komwan linteg, āngo mabata mo do dyaya pangarigan? Myan sa kono papito a makakakteh a mahahakay. Iyaw matonengaw, ki nangabahay, as kan sakbay a myan pōtot na, nadiman. ");
INSERT INTO ivb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Sinpangan na, no adyenaw no nadimanaw, ki kinabahay naw ipag naw a bālo, as kan aran iya, ki nadiman a abos pōtot. Masaw, naparin do chatatdo daw. ");
INSERT INTO ivb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Siraw papitwaw a makakakteh, ki kinabahay daw nawri a mabakes, kan nadiman sa tabo a abos pōtot. Do kapanawdyanaw, nadiman mabakesaw. ");
INSERT INTO ivb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","“Dawa, an komwan,” inyahes dan Sadosyowaw di Jesos, “sinonchi dyiraw akin kabahay so nya mabakes anchan araw a kapagongar, ta kinabahay daya tabon papito saya makakakteh nyaya mabakes?” ");
INSERT INTO ivb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ki binata ni Jesos dyira a kāna, “Samna! Matikaw kamo, ta maawātan nyo abaw naitolasaw do Masantwan a Tolas, as kan maawātan nyo abayaw panakabalin no Dyos. ");
INSERT INTO ivb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ta anchan mirwa mabyay tawotawo a nadiman, ki mangabahay pa sabanchi daw, ta akma dana sanchis anghil saw do hanyit. ");
INSERT INTO ivb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ki an maynamot do kapirwa mabyay no nadiman, nabāsa nyo abawriw naitolasaw do libro a intolas ni Moyses a maynamot do somdesdebaw a kayo? Do dawri, binata no Dyos di Moyses a kāna, ‘Yaken, ki yaken no Dyos daw da Abraham, Isaak, kan Jakob.’ ");
INSERT INTO ivb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","No chakey na batahen, ki iyabaw Dyos no nadiman, an dya iyaw Dyos no sibibyay. Rakohayaw pakatikawan nyo.” ");
INSERT INTO ivb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Myan do dawriw asa mahakay a mangnanawo so linteg. Nadngey naw kapagsosopyat daw, kan napatakan naw nainsiribanaw a katbay ni Jesos dyirad Sodosyowaw. As dawa, naypasngen di Jesos, as nakaiyahes na sya a kāna, “Mo Maistro, āngo iyaw kasisitaan dyirad tabo saw a bilbilin?” ");
INSERT INTO ivb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tinbay ni Jesos a kāna, “Iyaw kasisitaan a bilin, ki nyaya: ‘Adngeyen nyo, inyo a tawotawo do Israel. No Āpo ta a Dyos, ki iyaw moyboh a Dyos. ");
INSERT INTO ivb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Machita chadaw nyo Āpo a Dyos nyo do tābo poso nyo kan tābo katawo nyo, do tābo aktokto nyo, as kan tābo kayit nyo.’ ");
INSERT INTO ivb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ki no somarono a kasisitaan, ki nyaya: ‘Machita chadaw nyo kapayngay nyo a tawo a akmas kadaw nyo so inawan nyo.’ Apabaw bilin a masissisīta kan nya saya.” ");
INSERT INTO ivb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Do dawri, binatan mangnanawowaw so linteg dya a kāna, “Kosto nawrim Maistro! Oyodayaw binata mwaya a asaw Dyos, kan abaw matarek, an dya iya lang. ");
INSERT INTO ivb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","On, machitaw kadaw ta sya do tābo poso ta kan tābo aktokto ta, do tābo kayit ta, as kan machita a chadaw taw kapayngay ta a tawo a akmas inawan ta. Masissisīta a tongpalen taw dadwa saya kan kapangidātonaw so binyay ta do Dyos.” ");
INSERT INTO ivb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ki do kadlawaw syan Jesos so nainsiribanaw a katbay na, binata na dya a kāna, “Mabawa kaba a machirapa do pagtorayan no Dyos.” Do katayokaw no nawri, mabābang dana sa manahahes di Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Sinpangan na, do kayanaw ni Jesos a mangnanawo do Timplo, inyahes naw nya a kāna, “Āngo ta batahen dan mangnanawo so linteg a si Kristo, ki tod lang a kapotōtan Āri Dabid do kaychowa? ");
INSERT INTO ivb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ta sigon do inpaltiingaw no Ispirito Santo di Dabid, nyaw intolas na a kāna, ‘Binata ni Āpo Dyos do Āpo ko a, “Maydisna ka do kawanan kwaya a mandad kaābak ko siras kabosor mo saya, kan ipapitapita ko sad kokod mwaya.”’ ");
INSERT INTO ivb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“An tawagan ni Dabid so ‘Āpo,’ maypāngo nakahtot ni Kristo do kapotōtan Dabid?” Do dawri, siraw aro saw a tawotawo a myan daw, ki taywara a masoyot sa a nangadngey di Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Do nakapangnanawo naw dyira, binata na a kāna, “Annadan nyo saw mangnanawowaya so linteg, ta chakey daw maylaylay so mayid, kan imāsen da paw mapadayawan a kabkablaawan no tawotawo do plasa. ");
INSERT INTO ivb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Pidyen da paw kasisitaan a disnan do sinagoga da saw kan madadayaw saw a yanan dan matotohos saw so saad do paspasken saw. ");
INSERT INTO ivb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Allilawen da pa saw babbālwaw a mababakes tan madyira daw bahabahay da, as kapaydasal das manaro a pangoliwlib das kaparin daw. As dawa, marahrahmet anchiw dosa da.” Nawriw binatan Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Katayokan nawri, nangay si Jesos a naydisna do masngenaw do paglimosan daw do Timplowaw. Ki do dawri, chinichiban na saw tawotawowaw a mamosek so kwarta da, ki aro saw babaknang a taywaras kāro posken da. ");
INSERT INTO ivb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Sinpangan na, naypasngen asaw a mapobri a bālo a mabakes, as nakapangasday nas dadwa plata a kabobodisan so balor. ");
INSERT INTO ivb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ki do dawri, tinawagan sa ni Jesos nanawhen naw, as kan binata na dyira a kāna, “No ibahey ko dyinyo, ki oyod. Arwaro inasdayaya no mapobryaya a bālo kan iyaw sinday daya no tabo a namosek so paglimos da. ");
INSERT INTO ivb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ta no intoroh da, ki iya lang sobraw no kinabaknang da. Ki iyaw bālwaya, aran pobri, ki intoroh naw moybohaw a myan dya. On, intoroh naw tabo a maparin a chabyay na.” ");
INSERT INTO ivb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Do nakahbot daranaw da Jesos do Timplowaw, asa dyirad nanawhen naw nakabata sya dya a kāna, “Mo Maistro, chiban pa! Ay, taywarayas kararakoh naosar saya bato a pinamatnek da, as kan mapipintas sayaw pinatnek da saya do dyaya a Timplo!” ");
INSERT INTO ivb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ki tominbay si Jesos a kāna, “Siraw maboya nyowaya rarakoh a napatnek, ki mararayaw sanchi a tabo, as kan apabanchi a polos matokos a machidket a bato do yanan daya sichangori, ta malasanchi a tabo.” ");
INSERT INTO ivb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ki do nakapaydisnaw da Jesos do talapawaw no tokonaw a mayngaran so Olibo a machisalap do Timplowaw, naypasngen si Pedro, si Santiago, si Juan, as kan si Andres di Jesos. Inlīmed da inyahes dya a kon da, ");
INSERT INTO ivb_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ibahey mo pa dyamen an kangonchiw kaparin dan nyaya, kan maypāngonchiw pakailasinan namen sya a iyaw pakatongpalan da tabon nya, ki masngen dana?” ");
INSERT INTO ivb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Do dawri, inrogi ni Jesos nangnanawo dyira a kāna, “Magannad kamo tan abo mapaychawaw dyinyo. ");
INSERT INTO ivb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Aro sanchiw mangay a mangosar so ngaran ko, kan batahen danchi a, ‘Yaken si Kristo!’ Aronchiw allilawen da. ");
INSERT INTO ivb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Anchan madngey nyo kabtak no gobat kan damdāmag maynamot do gobat, mabakel kamo abanchi. Machita maparin saw nyaya, ki chakey naba batahen a nawri danaw pandan lobongaya. ");
INSERT INTO ivb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Maggogobat sanchiw nasyon kan nasyon, as kan komwan sanchiw pagaryan kan pagaryan. Myan panchiw gin-gined do matatarek saw a logar, kan myan panchiw kapaychapteng. Siraw nya, ki pangrogyan pa no panglidyalidyat a akmas kapagpasikalaw no maymanganak. ");
INSERT INTO ivb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ki an inyo, magannad kamo, ta tiliwen kan idarom danchinyo no tawotawo. Saplitan danchinyo do sinagoga da saw, kan paytēneken danchinyo do salapen dan magtotoray kan ar-āri maynamot do kawnot nyo dyaken. Ki iyanchiw nawriw gondaway nyo a mangipaneknek dyira so Maganay a Dāmag. ");
INSERT INTO ivb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ki sakbay no pandan lobongaya, ki machita maikasaba a manma iyaw Maganay a Dāmag do tabo tawotawo do lobongaya. ");
INSERT INTO ivb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Do katiliw daw anchi dyinyo a idarom, chabakel nyo aba an āngo nchiw itbay nyo. Do dawrinchi, tod nyonchi a batahen tombodaw do pangtoktwan nyo, ta inyo abanchiw maylililyakaw, an dya Masantwan a Ispirito a manoroh so pabatahen nyo. ");
INSERT INTO ivb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Myan sanchiw tawotawo a mangipadiman so mismo da a kakakteh, as kan komwan anchiw parinen inyapwan dyirad anak da. Siranchiw anak, ki machikontra sanchi do inyapwan da, kan ipadiman da sanchi. ");
INSERT INTO ivb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ipsok danchinyo no tabo tawotawo maynamot do kapachichasa nyowaya dyaken. Ki maisalakan anchiw makaibtor so kapanganohed na mandad pandan.” ");
INSERT INTO ivb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Tinongtong ni Jesos naychirin. Binata na a kāna, “Anchan maboya nyonchiw ‘Makamwamomwaw a Mangrarayaw’ a maytēnek do dyaw a rombeng a paytēnekan na — Inyo a makabāsa so nyaya, awāten nyo a maganay iyaw chakey na batahen! — do dawrinchi, siraw myan do Jodya, machita mayyayo sanchi a somonget do katokotokonan a tomayo. ");
INSERT INTO ivb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Iyanchiw myan do papagaw no bahay na, ki dyi dana pakono maybabalay a somdep a mangay a manghap so warawara na a iyonot na. ");
INSERT INTO ivb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Masaw myanaw do bengkag naw, dyi dana pakono a maybidi do bahay na a mangay a manghap so pagsokatan na. ");
INSERT INTO ivb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ki piman, ta makakāsi sanchiw mabogyaw kan mapasoswaw do dawri a araw! ");
INSERT INTO ivb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Maydasal kamo do Dyos tan dyi pakono a ammyan kaparin no nyaya. ");
INSERT INTO ivb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ta do dawri sanchi a araw, myan sanchiw lidyat a polos a dyi pa naparin mana dyi pa napadasan nakayapo do nakaparswa no Dyos so lobongaya a mandas changori, as kan mapirwa pabanchi a polos nyaya do masakbayan. ");
INSERT INTO ivb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ki an dya inaksayan no Dyos bidang no araw saya a kalidyatan, abanchiw aran sino a mabidin a sibibyay do lobongaya. Ki maynamot dyirad pinidi saw no Dyos, chinsayan naw araw saya a kayan kalidyatanaya. ");
INSERT INTO ivb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Do dawri, an myan makabata sya dyinyo a kāna, ‘Chiban nyo, ari dana dyas Kristo!’ mana ‘Chiban nyo, tori aba dwadaw?’ ki manganohed kamwaba, ");
INSERT INTO ivb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ta tombod sanchiw aro a sinan Kristo kan sinan propīta a mapaboya so milagro kan pangancharan a pamaychawaw da siras aro a tawotawo. On, allilawen da sanchi, an maparin, sira paw pinidyaw no Dyos a tawo na. ");
INSERT INTO ivb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","As dawa, kaannadan nyo, ta naisakbay ko na sa naibahey a tabo dyinyo nya saya.” ");
INSERT INTO ivb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Do dawri sanchi a araw a katayokan kalidyatan, maysarinchiw araw, kan arabanchiw sedang no bohan. ");
INSERT INTO ivb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Maychahesday sanchiw bitohen a yapod hanyit, as kan tabonchi do hanyit a myan so panakabalin, ki makosokoso sanchi. ");
INSERT INTO ivb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Do dawrinchi, ki maboya danchi yaken a Tawo a Yapod Hanyit a mawara a pongosan no demdem a myan so rakoh a panakabalin kan tan-ok. ");
INSERT INTO ivb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Sinpangan na, toboyen ko sanchiw anghilis ko a mangay a mangpeh siras pinidi kwaw do aran dino a seksek do intīro a lobong.” ");
INSERT INTO ivb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Sinpangan na, tinongtong ni Jesos nangnanawo a kāna, “Adālen nyo nya pangarig a maynamot do kayowaw a igos: An somiknan a omlak kan tomohos, chapatak nyo na a masngen danaw rayon. ");
INSERT INTO ivb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Komwan pa dyinyo sichangori. An maboya nyonchiw katongpal no nya saya kalidyatan, chapatak nyo nanchi a īto danaw kawara ko. ");
INSERT INTO ivb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","No ibahey kwaya dyinyo, ki oyod. Myan panchi dyinyo do dyaya kapotōtan sibibyay pa do katongpal no tabo no bata ko saya. ");
INSERT INTO ivb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Iyanchiw hanyit kan tanaya, ki mabo sanchi a tabo, ki mabo abanchi a polos chirin ko.” ");
INSERT INTO ivb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“An maynamot do dawri a araw mana oras no panongpalanaya, ki aba polos makapatak sya. On, ta aran siraw anghilis do hanyit, ki chapatak daba. As aran yaken a Anak no Dyos, ki chapatak kwaba, an dyi lang a si Āmang kod hanyit moyboh a makapatak sya. ");
INSERT INTO ivb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","As dawa, magannad kamo, kan nāw kamo pakono a nakasagāna, ta chapatak nyo aba an āngo nchiw oras no kawara ko. ");
INSERT INTO ivb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Ta maiyarig ako do tawowaw a magbyahi a dya mangibahey an āngo a araw kapaybidi na. Inparawat naw bahay naw a onongan dan pachirawatan naw, kan tinorohan naw kāda asa so pagrebbengan na. Sinpangan na, binilin naw magbantayaw do pantawaw a nāw na nakasagāna do kawara na. ");
INSERT INTO ivb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“As dawa, sisasagāna kamo pakono ah, ta chapatak nyo aba an āngo nchiw kawara ko a maiyengay do akin bahayaw. Chapatak nyo aba an maysarisari, abak no ahep, maysesedang, mana an mabekas dana. ");
INSERT INTO ivb_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ta alit na maychihat anchiw kawara ko, kan maganay an dyi koynyo a madasan a makaycheh. ");
INSERT INTO ivb_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","“Nyayaw ibilin ko dyinyo dya kan dyinyo a tabo a tawotawo a sisasagāna kam pakono a pirmi.” ");
INSERT INTO ivb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Dadwa pa karaw, as karapit no Pista no Pakanaknakman so Nakahabasaw no Anghil kan Pistaw no Tinapay a Abos Libadora. Do dawri, siraw matotohos saw a papadi kan siraw mangnanawowaw so linteg, ki tinongtong daw nagtotolag an maypāngo kaikorimed da mangtiliw si Jesos tan dimanen da. ");
INSERT INTO ivb_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Binata da a kon da, “Maparin aba irana ta tiliwen an madamaw pista ah, ta angwan nawriw mangkiras so riribok.” ");
INSERT INTO ivb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Do dawri, myan sa Jesos do Betanya do bahayaw ni Simon a nagliproso do nakarahan. Ki do kadama daw a koman, myan asa mabakes a somindep do bahayaw a nakaigpet so oltimo so kangina a bangbanglo a mayngaran so nardo a nakapno do praskita a alabastro. Sinpangan na, pinotohan naw alabastrowaw, as nakapado nas bangbanglwaw do ohwaw ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ki do dawri, nakasoli saw kadwanaw a tawo a myan daw, kan binata da do katakatayisa dyira a kon da, “Aysa, mangbaywaya! Āngo ta naipohaw nyaya? ");
INSERT INTO ivb_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Sigoro magbalor nyaya so nasorsorok kan tatdo a gasot a dinaryo. Dyori a maganaganay an ilāko, as itoroh kwartaw dyirad mapopobri saw?” kon da, as kan taywaraw nakapaydabdab da sya. ");
INSERT INTO ivb_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ki binatan Jesos dyira a kāna, “Inolay nyo! Āngo ta ririboken nyo? Oyod a maganay nawri a pinarin na dyaken. ");
INSERT INTO ivb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ta siraw pobri, ki pirmi sa myan dyinyo, as kan maparin nyo sa sidongan do aran āngo a chakey nyo a oras. Ki an yaken, myan akwaba kankanayon dyinyo. ");
INSERT INTO ivb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Iyaw mabakesaya, ki pinarin na tabo maparin na. On, pinapapotan naw inawan ko a pinanma tan maisagāna do kaitanem ko. ");
INSERT INTO ivb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","No ibahey ko dyinyo, ki oyod a aran dino a kaikasabaan Maganayaya Dāmag do lobongaya, ki masarsarita panchiw pinarinayan nyaya mabakes a pakanaknakman sya.” ");
INSERT INTO ivb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Sinpangan na, si Jodas Iskariote a asa dyirad asaw a poho kan dadwa nanawhen ni Jesos, ki nangay dyirad matotohos saw a papadi tan lipotan nas Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Do nakadngey daw so rantaw ni Jodas, nasoyot saw papadyaw, kan inkari da dya a torohan das kwarta. Do dawri, insiknan ni Jodas maychichwas so gondaway na a manglipot di Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Do manōmaw a araw no Pista no Tinapay a Abos Libadora a iyaw no arawaw a kapangdiman dan Jodyo saw so orbon saw a karniro a idāton da, ki inyahes dan nanawhen na saw ni Jesos a kon da, “Dino chakey mo a pagsagānaan namen so pangmalem ta do Pistaya no Nakahabasaw no Anghil?” ");
INSERT INTO ivb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Do dawri, tinoboy san Jesos dadwaw a nanawhen na, as kan binata na dyira a kāna, “Somdep kamo do syodadaya, as kan myan anchiw ombayat dyinyo a asa mahakay a mayrara so asa kamalabi a ranom, ki monot kamonchi dya. ");
INSERT INTO ivb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Onotan nyonchi do asdepan naw a bahay, as kabata nyonchi syad akin bahayaw a, ‘Ipayahesaw ni Maistro an dino kono kwarto a kanan danchi kan siraw nanawhen naw do kapistaya?’ ");
INSERT INTO ivb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ipaboya nanchi dyinyo mamanyitwaw a kwarto a rakoh a nakasagāna dana kontodo lamisaan. Dawrinchiw pagsagānaan nyos kanen ta.” ");
INSERT INTO ivb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Sinpangan na, nangay saw dadwaw a nanawhen ni Jesos do syodadaw, ki naparin binataw ni Jesos dyira. Do dawri, nagsagāna sa so kanen da maynamot do Pistaw a Pakanaknakman so Nakahabasaw no Anghil. ");
INSERT INTO ivb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ki do kapaysarisari naranaw, nawara dana sa Jesos kan siraw dosi saw a nanawhen na. ");
INSERT INTO ivb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ki do kayan daw do lamisaan a koman, binatan Jesos dyira a kāna, “No ibahey ko dyinyo, ki oyod. Asanchi dyinyo a machihanghang dyaken sichangori, ki manglipot anchi dyaken.” ");
INSERT INTO ivb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Pinagmamayo daw nawri a nadngey da, kan nagsasarono sa nangyahes sya di Jesos a kon da, “Yakenori?” ");
INSERT INTO ivb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Binatan Jesos dyira a kāna, “On, syirto a asa dyinyo a asa poho kan dadwa a machipaydidinot dyaken do sabak. ");
INSERT INTO ivb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ta yaken a Tawo a Yapod Hanyit, ki madiman a akmas naitolasaw do Masantwanaya a Tolas, ki kapakāsi panchi no nawri a tawo a manglipot dyaken! Maganaganay an dya nayanak nawri a tawo.” ");
INSERT INTO ivb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ki do kayan daw a koman, nanghap si Jesos so tinapay, as nakapaydasal na nagyaman di Āpo Dyos. Sinpangan na, inakchikchid na a intoroh dyirad nanawhen naw, as nakabata na sya dyira a kāna, “Hapen nyo nyaya, ta nyaw inawan ko.” ");
INSERT INTO ivb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Sinpangan na, nanghap so asa kabaso do inomen daw, as nakapagyaman nad Āpo Dyos, as nakaiparawat na sya dyira, ki mininom sa tabo. ");
INSERT INTO ivb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Do dawri, binata na dyira a kāna, “Iyaw nya, ki raya ko a moyog anchi do kadiman ko a pangsigorādo so bayo a tolag no Dyos dyirad tabo tawotawo. ");
INSERT INTO ivb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Oyod nyaya ibahey ko dyinyo a mirwak pabanchi a polos a minom so palekaya no obas a mandad araw a kaynom ko so bayo do pagtorayan no Dyos.” ");
INSERT INTO ivb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Do katayokaw no nawri, nagkankanta sa, as nakahbot da a somnonget do Tokon a Olibo. ");
INSERT INTO ivb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ki do kayam daw do tokonaw, binatan Jesos dyira a kāna, “Payayowan nyonchi yaken, inyo a tabo, ta myan naitolas do Masantwan a Tolas a kāna no Dyos, ‘Dimanen konchiw mangonong so karniro, as siranchiw karniro, ki maychawpit sanchi.’ ");
INSERT INTO ivb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ki anchan mirwa akwa mabyay, manmanma akonchi a mangay do Galilya kan inyo.” ");
INSERT INTO ivb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ki initbay ni Pedro dya a kāna, “Aran komaro sanchi a tabo, ki yaken, ki engga!” ");
INSERT INTO ivb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Binata ni Jesos dya a kāna, “Ibahey ko dyimo oyod mo Pedro a do dyaya ahep, sakbay a pirwahen sabongan a manok monyi, naypitdo mo nanchi yaken a inlibak.” ");
INSERT INTO ivb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ki inpapati ni Pedro a inbahey dya a kāna, “Aran mairaman akonchi a madiman dyimo, polos a dyi koymo a ilibak.” Komwan paw binata da tabo no nanawhen naw. ");
INSERT INTO ivb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Sinpangan na, nawara sa Jesos do asaw a logar a mayngaran so Getsemani do dawri a tokon. Do dawri, binata ni Jesos dyirad nanawhen naw a kāna, “Maydisna kamo dya, ta mangay akwa maydasal.” ");
INSERT INTO ivb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Katayoka na nangibahey syaw, inhap na sa Pedro, Santiago, kan Juan, kan nachibawa sa so dēkey. Do dawri, somniknan si Jesos a taywara mabakel kan mariribok. ");
INSERT INTO ivb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Binata na dyira a kāna, “Taywarayaw kapagmamayo ko, kan akmayaw chadiman ko. Mabidin kamo dya, ki makaridam kamo.” ");
INSERT INTO ivb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Do dawri, naypabawas dēkey, as nakapaysasakeb nad tana a naydasal. Inakdaw na an maparin, ki ditchanan naw nawri a kalidyatan. ");
INSERT INTO ivb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Do nakapaydasal naw, binata na a kāna, “Mo Āmang ko, maparin mo aran āngo. An maparin, ki paditchanen mo pa yaken do kalidyatan kwaya. Ki pagayatan kwabaw matongpal, an dya iyaw chakey mo.” ");
INSERT INTO ivb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Sinpangan na, do kapaybidyaw ni Jesos do yanan daw no tatdwaw a nanawhen na, ki nadasan na sa a makaycheh. Binata nad Pedro a kāna, “Simon, nakaycheh kawri? Maparin mwabawriw magridam so aran asa kaoras? ");
INSERT INTO ivb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Makaridam kamo kan maydasal kamo tan dyi kamo a masday do solisog. Sisasagānaw kapangtokto nyo, ki makapsot inawan nyo.” ");
INSERT INTO ivb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Katayokan nawri, naybidi danas Jesos do paydasalan naw a naydaydasal a akmas dāmwaw a pinarin na. ");
INSERT INTO ivb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ki do kapirwa naranaw a naybidi do yanan daw no nanawhen naw, myan dana sa minirwa nakaycheh, ta oyod das kadoho. Chapatak dabaw itbay da dya. Sinpangan na, naybidi danas Jesos do paydasalan naw. ");
INSERT INTO ivb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ki do chatatdwaw no nakapaybidi nad yanan daw, binata na dyira a kāna, “Ari kam pawri a makaycheh kan maynahah? Naw dana ah! Narapit danaw orasaw a kaiparawat ko a Tawo a Yapod Hanyit dyirad arwaw so gatos. ");
INSERT INTO ivb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Maybangon kamo na, ta may ta na. Chiban nyo, tori danaw manglipotaw dyaken!” ");
INSERT INTO ivb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Madama pa maychiychirin si Jesos do nakawaraw ni Jodas a iyaw asaw dyirad asa poho kan dadwa saw a nanawhen na. Nachirayay sa dyaw arwaw a tawotawo a nakabahayang kan nakamamalo a tinoboy dan matotohos saw a papadi, siraw mangnanawowaw so linteg, kan siraw panglakayen da saw no Jodyo. ");
INSERT INTO ivb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tinorohan ni Jodas saw nachirayayaw dya so sinyal a iyaw nyaya: “No dadek kwaw anchi, ki iyaw kadyawen nyowaya. Tiliwen nyonchi, as kaikaro nyo sya a mabantayan a maganay.” ");
INSERT INTO ivb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Do nakapakarapit daw daw, ki taros a nangay si Jodas di Jesos, as nakabata na sya a kāna, “Mo Maistro,” as nakadadek na sya. ");
INSERT INTO ivb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Insigīda kinamet das Jesos a tiniliw. ");
INSERT INTO ivb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Do dawri, inasot no asaw dyirad nanawhen naw a myan a maytēnek daw bahayang naw, as nakasintaw nas adipenaw no katotohosanaw a padi, kan naringodan. ");
INSERT INTO ivb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Sinpangan na, binatan Jesos dyirad nangtiliwaw sya a kāna, “Tolisan akori? Āngo ta myan bahayang nyo kan mamalo nyo a mangay a omtiliw dyaken? ");
INSERT INTO ivb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kararaw, ki nachisagel ako dyinyo a nangnanawo dyinyo do Timplo, ki asyo nyo yaken a pinadas a tiliwen do dawri. Ki aran komwan, machita parinen nyo nyaya tan matongpal naitolasaw kaychowa do Masantwan A Tolas.” ");
INSERT INTO ivb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Sinpangan na, naychapayapayayo saw nanawhen naw, kan inonolay daranas Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ki do dawri, myan iyaw barwaw, kan nakalaylay lang so ayob a minonot di Jesos. Sinpangan na, inigpet daw ayob naw, ta aran iya, ki pinadas da tiliwen. ");
INSERT INTO ivb_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ki sinpangan na,, nabahas ayob naw, kan nayyayo a silalābos. ");
INSERT INTO ivb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Do dawri, inyangay da si Jesos do bahayaw no katotohosanaw a padi a nakakpehan dan tabo matotohos saw a papadi, siraw panglakayen dan Jodyo saw, as kan siraw mangnanawowaw so linteg. ");
INSERT INTO ivb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","An maynamot di Pedro, ki nakateng a minonot di Jesos, as kan do nakapakarapit naw do atataw no bahay no katotohosanaw a padi, nachidisna dyirad gwardya saw kan nachipanangdang. ");
INSERT INTO ivb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","As siraw matotohos saw a papadi kan siraw tabo a konsihal, ki nanta sas pangpaneknek a maikontra di Jesos tan myan iyaw pakayapwan da omdiman sya. Ki alit na abo nachichwasan da. ");
INSERT INTO ivb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Aro saw tawotawo a nangpaneknek so maikontra di Jesos, ki malit sa bayataw. As dawa, mayoyonot abaw batabata daw. ");
INSERT INTO ivb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Myan saw kadwan dyira a naytēnek a nangpaneknek so nya bayataw a maikontra dya a kon da: ");
INSERT INTO ivb_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nadngey namenaw nyaya tawo a batahen na a kāna, ‘Rarayawen ko nyaya Timplo a pinarin tawo, as do irahem no tatdo a karaw, ki mapatnek ako so dya pinarin tawo.’” ");
INSERT INTO ivb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ki aran komwan binata dan kadwan saw, alit na mayoyonot abaw batabata daw. ");
INSERT INTO ivb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ki do dawri, naytēnek katotohosanaw a padi do salapen dan tabo, as nakaiyahes na syad Jesos a kāna, “Oyodoriw batabatahen daya maikontra dyimo? Abawriw maitbay mo?” ");
INSERT INTO ivb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ki naylilyak aba si Jesos kan polos nad inatbay. Sinpangan na, pinirwa danan katotohosanaw a padi a inyahes a kāna, “Imoris Kristo a Anak no maidayawaw a Dyos?” ");
INSERT INTO ivb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ki tinbay ni Jesos a kāna, “On, yaken nawri, kan maboya nyonchi yaken a Tawo a Yapod Hanyit a maydisna do kawanan no Dyos do hanyit a myan so panakabalin, as kan maboya nyo panchi yaken a maypābodis a yapod hanyit a mapongosan so demdem.” ");
INSERT INTO ivb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Do dawri, taywaraw nakapakasoli no katotohosanaw a padi. As dawa, pinirit naw laylay naw, as nakaibahey na sya dyirad tawotawo saw daw a kāna, “Machita ta pawriw pamaneknek ta? ");
INSERT INTO ivb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nadngey nyo nayaw bata naya a ipariho naw inawan na do Dyos. Ki āngo keddeng nyo?” Ki initbay da a tabo a machita a madiman. ");
INSERT INTO ivb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Sinpangan na, insiknan dan kadwan saw a chinichipan si Jesos. Binarabādan das mata, as nakadandanog da sya, as nakaiyahes da sya dya, “Tarosen mo pa an sino saw mangdandanogaya dyimo?” kon da. Sinpangan na, inhap das Jesos no magbanbantayaw daw, as nakatongtong da minbaot sya. ");
INSERT INTO ivb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ki si Pedro, nabidin do panangdangan daw do atataw do dawri a bahay. Myan daw asaw a mabakes a kasidong no katotohosanaw a padi, kan naypasngen do yananaw ni Pedro. ");
INSERT INTO ivb_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Do nakaboya naw si Pedro a myan a manangdang, pinerreng na, as binata na dya a kāna, “Na, aran imo, syirto imo asaw a rarayay ni Jesos a taga Nasaret?” ");
INSERT INTO ivb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ki naglibak si Pedro, kan binata na a kāna, “Wa! Abayaw chapatak kod batabatahen mwaya, kan polos a dyi kwa maawātan!” Do dawri, nachibawa a nangay do rowanganaw. Sinpangan na, minonyiw sabonganaw a manok. ");
INSERT INTO ivb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ki naboya no mabakesaw si Pedro do nayadisanaw, kan minirwa binata na dyirad kadwan sa a myan daw a kāna, “Iyaw nyaya tawo, ki asaw a kayban da.” ");
INSERT INTO ivb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Do dawri, pinirwa danan Pedro a inlibak. Nahay abas dēkey, binata da pa di Pedro no myan saw a naytēnek daw a kon da, “Syirto a imo asaw dyira, ta yapo kad probinsya a Galilya.” ");
INSERT INTO ivb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Do dawri, insiknan ni Pedro nangabay do mismo na inawan, kan nagkari a kāna, “Si Āpo Dyos danaw makatoneng an bayataw ako, ta chapatak ko abayaw nawri a tawo a batabatahen nyo!” ");
INSERT INTO ivb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ki do dawri, nyeng a minirwa minonyiw sabonganaw a manok. As nanakem ni Pedro binataw ni Jesos dya a kāna, “Sakbay a maypirwa monyiw sabonganaw a manok, ki maypitdo mo nanchi yaken a inlibak.” Ki do nakanakem naw so nawri, naigpet nabaw inawan na, kan tomnanyis. ");
INSERT INTO ivb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Do kapaysesedang naranaw, tinolag da an āngo parinen dad Jesos no matotohos saw a papadi, panglakayen saw, siraw mangnanawowaw so linteg, kan siraw tabo konsihal da saw do dawri. Katayokaw no nyaya, binahod das Jesos, as nakaiyangay da sya a inparawat di Pilato a gobirnador a yapod Roma. ");
INSERT INTO ivb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Do nakawaraw ni Jesos daw, inyahes ni Pilato dya a kāna, “Āngo? Imoriw Āri daw no Jodyo saw?” “Nabata mo na,” initbay ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Do dawri, aro inpagatos dad Jesos no matotohos saw a papadi. ");
INSERT INTO ivb_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","As dawa, minirwa dana inyahes ni Pilato dya a kāna, “Madngey moriw kārwayan darom daya a ikontra da dyimo? Abawriw maitbay mo?” ");
INSERT INTO ivb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ki tominbay aba polos si Jesos, dawa, chinaklat ni Pilato. ");
INSERT INTO ivb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kāda Pistan Nakahabasaw no Anghil do kāda tawen, dadakay ni Pilato mapakakaro so asa dyirad nabahod a tawo a aran sino a akdawen dan tawotawo. ");
INSERT INTO ivb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ki myan daw asa dyirad nabahod saw a mayngaran so Barrabas. Nyaya tawo kan siraw rarayay naw, ki nagribildi sa, as kan do nakapaydidiman daw, diniman da saw tawotawaw. As dawa, binahod san Pilato. ");
INSERT INTO ivb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ki do dawri a kamabekas, naychipeh saw tawotawowaw do yananaw ni Pilato, as kan chindaw da a pakakarohen naw asa dyirad nabahodaw a akmas gagāngay naw do pistaya. ");
INSERT INTO ivb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ki inyahes ni Pilato dyira a kāna, “Chakey nyori a pakakarohen ko iyaw mabataya Āri dan Jodyo?” ");
INSERT INTO ivb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Binata naw nya, ta chinapatak na a maynamot do kahoho dan matotohos saw a papadi nawriw nangidaroman da sya dya. ");
INSERT INTO ivb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Do nakadngey daw syan matotohos saw a papadi so nawri a inyahes ni Pilato, pinaklaklal da saw tawotawowaw a mangdaw di Pilato a basbāli a si Barrabas pakakarohen na. ");
INSERT INTO ivb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","“Na, an komwan, āngo parinen kod Jesos a batahen nyo a Āri dan Jodyo?” inyahes ni Pilato dyira. ");
INSERT INTO ivb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ki inyagagay dan tawotawo saw, “Ipailansa mo do kros!” ");
INSERT INTO ivb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Inatbay san Pilato a kāna, “Na, āngo ta? Āngo pinarin na a gatos ta dawa?” Ki naypangay nakaiyagagay da sya a kon da, “Ipailansa mo do kros!” ");
INSERT INTO ivb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Do dawri, chakey ni Pilato a pagostwan saw tawotawo saw, dawa, pinakakaro na si Barrabas. Ki si Jesos, inpasaplit na dyirad soldadwaw, as nakaimandar na sya dyira a ilansa da do kros. ");
INSERT INTO ivb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Do dawri, inisdep dan soldadwaw si Jesos do atataw no bahayaw no gobirnadoraw, as kan tinawagan da sa tabo rarayay da saw a soldado. ");
INSERT INTO ivb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Sinpangan na, kinekehan da si Jesos so akmay obi so kita kan akmas kekehaw no āri, as kan namahokon sas inbalāngat da sya a manolok. ");
INSERT INTO ivb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Sinpangan na, sindādayaw sa a sinkakablaaw dya, as nakabata da sya a kon da, “Mabyay pakono Āri dayan Jodyo!” ");
INSERT INTO ivb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Do dawri, sinimsimlod daw oho naw, as nakachichipa da sya, as kan nakapaydogod dad salapenaw ni Jesos a sindādayaw dya. ");
INSERT INTO ivb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Do nakatayokaw no kapangoy-oyaw da dya, pinakaro daw pinakekeh daw dya a akmay obi so kita, as nakapabidi das sigodaw a laylay na. Sinpangan na, inyayam darana a yangay a ilansa do kros. ");
INSERT INTO ivb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Do kayan da paw a mayam do rarahan, nabayat das āmang da Alehandro kan Ropo a si Simon a taga Sirene a komwan do syodadaw a yapod barbaryo. Do dawri, pinilit dan soldado saw a inpaisabhay dyaw krosaw ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Tinongtong daw somnonget do tokonaw a mayngaran so Golgota. No chakey na batahen, ki “Logar no Bangabanga.” ");
INSERT INTO ivb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Sinpangan na, pinadas da a paynomen si Jesos so palek a napasaglan so mirra, ki chinaskeh na. ");
INSERT INTO ivb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Do dawri, inlansa dan soldadwaw si Jesos do kros. Ki iyaw laylay na saw, ki nagbibinglayan da maynamot do nakapagbibinonot da, ta chiban da an āngo hapen katakatayisa dyira. ");
INSERT INTO ivb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","No oras no nakailansa da sya, ki ālasnwebi do kamabekas. ");
INSERT INTO ivb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Intolas daw inpagatos daw dya a, “NO ĀRI DAN JODYO.” ");
INSERT INTO ivb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Do dawri, myan pa saw dadwa manakanakaw a inlansa da do kros do maybitaw ni Jesos. Iyaw asaw, ki myan do kawanan naw. As iyaw asaw, ki myan do kaholi naw.  ");
INSERT INTO ivb_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Maynamot do dyaya, natongpal naitolasaw do Masantwan a Tolas a kāna, “Naibidang a akmay asa kriminal.” ");
INSERT INTO ivb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ki siraw tawotawowaw a omhabas sya, ki inoy-oyaw da, kan naylilinlin sa a binata da a kon da, “Samna! Imo nakabataw sya a rarayawen monchiw Timplowaw, as kapatnek mo syad irahem no tatdo a karaw! Pi! ");
INSERT INTO ivb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Sichangori, isalākan mo paw mismo a inawan mo, kan gomchin ka pad dawri a kros!” ");
INSERT INTO ivb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Aran siraw matotohos saw a papadi kan siraw mangnanawowaw so linteg, ki inoyaw da. Binatabata da a kon da, “Nangisalakanaya so kadwan a tawo, ki asyo naya maisalakan inawan na. ");
INSERT INTO ivb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","An oyod a iyas Kristo a Āri dan tawotawo saw do Israel, ayket na, gomchin pakono do kros naya tan maboya ta kan manganohed ta dya.” Ki aran siraw rarayay naw a nailansa, komwan kaoyaw da sya. ");
INSERT INTO ivb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Do kayegen danaw no araw, nyeng a nabo sedang, kan naysari iyaw intīro a lobong a nandad kaalas tres do kamakoyab. ");
INSERT INTO ivb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Sinpangan na, do nakapangalas tres naranaw, nangngengey si Jesos so malyak, kan binata na a kāna, “Eloi, Eloi, lama sabaktani?” No chakey a batahen nyaya, ki “Dyos ko, Dyos ko, āngo ta ninonolay mo yaken?” ");
INSERT INTO ivb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Siraw naychatetēnekaw daw a nakadngey sya, binata da, “O, adngeyen nyo ah, ta tawagan nayas Elyas!” ");
INSERT INTO ivb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ki sinpangan na,, asa dyiraw nayyayo a nanghap so akmay dadyi a pinakneban na so naysoka a palek, as nakapatap na syad tobwanaw no byawo, as nakapagolo na syad dangoyaw ni Jesos. Binata na a kāna, “Anchi kamo, ta chiban ta panchi an yangay a pagchinen Elyas!” ");
INSERT INTO ivb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Sinpangan na, minirwa dana nangngengey si Jesos so malyak a nachirayayan danan nakapaybitos no byay na. ");
INSERT INTO ivb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Do dawri, napirit a naysyay kortinaw do Timplo a yapod tohos a nandad sayran. ");
INSERT INTO ivb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Do salapenaw ni Jesos, myan daw a maytēnek kapitan daw no soldado saw. Do nakaboya naw so nakadimanaw ni Jesos, binata na a kāna, “Oyod sawen a Anak ni Āpo Dyos nyaya tawo!” ");
INSERT INTO ivb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ki do mabawa so dēkey di Jesos, myan saw mababakes a omchidechideb sya. No kadwan dyira, ki sa Maria Magdalena, kan si Maria a ānang ni Jose kan si Santiago a pinangaranan das “pandek,” as kan si Salome. ");
INSERT INTO ivb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Siraw nyaya mababakes, ki minonot sad Jesos do kayan daw do Galilya, kan sinidongan da. Myan pa saw aro a mababakes a minonot dya do nakangay na do Jerosalem. ");
INSERT INTO ivb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Do kamakoyāb naranaw, do dawri a araw a iyaw arawaw a kapagsagāna da do dispiras no Araw a Kapaynaynahah, ");
INSERT INTO ivb_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","intortored ni Jose a yapod Arimatea iyaw nangay do yananaw ni Pilato, kan yangay na chindaw bangkayaw ni Jesos. Si Jose, ki asa mabigbigbig dyirad konsihalis dan Jodyo a mangnangnanaya so kangay no kapagtoray no Dyos. ");
INSERT INTO ivb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Do nakadngeyaw syan Pilato a nalisto a nadiman si Jesos, taywara chinasdaaw na. Tinawagan naw kapitanaw no soldado saw, as nakaiyahes na sya dya an oyod a nadiman danas Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Do nakadngey naw sya do kapitanaw a nadiman danas Jesos, pinalobosan Pilato a hapen ni Jose iyaw bangkayaw. ");
INSERT INTO ivb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Do dawri, inyonot ni Jose iyaw ginatang naw a maydak a ayowayob, as yangay na a pinagchin bangkayaw ni Jesos do kros, as nakapongos na sya so ayowayob. Sinpangan na, pinosek naw bangkayaw ni Jesos do pinarin daw a tanem a aschip, as nakaneb na syas rakkoh a bato. ");
INSERT INTO ivb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Myan pa daw sa Maria Magdalena kan si Maria a ānang ni Jose a nakaboya so nakaitanemanaw no bangkayaw ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Do nakatayokaw no Araw a Kapaynaynahah, sa Maria Magdalena kan Maria a ānang ni Santiago, as kan si Salome, ki gomnātang sa so bangbanglo a pangbalsamar das bangkayaw ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Masapa pa do manōmaw a araw no lawas do katatayokaw no araw a tomninyi, nangay saw mababakesaw do aschipaw a nakaitanman ni Jesos. ");
INSERT INTO ivb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Do kayam daranaw, naysin-iiyahes sa a kon da, “Sino paronchiw ombadede so anebaw a bato do asdepanaw do aschip?” ");
INSERT INTO ivb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ki do nakapakarapit daw do yananaw no aschip a tanem, naboya da a aran rakkoh iyaw batwaw, ki alit na nabadede. ");
INSERT INTO ivb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Sinpangan na, sindep daw aschipaw. Ki do nakapakasdep daranaw, sominryam sad naboya daw a asa baro a myan a maydisnad mangketaw do kawanan daw. Nakalaylay so manaro, kan oyod nas kaydak. ");
INSERT INTO ivb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Do dawri, binata na dyira a kāna, “Mamo kamwaba, ta si Jesos a taga Nasaret a chichwasen nyo a iyaw nailansaw do kros, ki apaba dya maynamot ta nagongar dana. Chiban nyo pad pinangayan daya sya, an dyi dana abo daw. ");
INSERT INTO ivb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Sichangori, yangay nyo a ibahey nya dyirad nanawhen naw a magraman di Pedro a kon nyo, ‘Nanma danas Jesos a mangay do Galilya. Dawrinchiw kaboyan nyo sya a akmas inbahey naw dyinyo do nakarahan.’” ");
INSERT INTO ivb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Do nakapakahtot daw do aschipaw, naychapayapayayo sa, ta taywaraw nakasryam kan nakapamirpir da. Abaw inbaheyan da sya a aran sino maynamot ta oyod das nakamo.  ");
INSERT INTO ivb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Minhep do nakapagongaraw ni Jesos do manōmaw a araw no lawas, napaboya a nanma di Maria Magdalena a iyaw nangpaksyatan naw so papito a marahet a ispirito. ");
INSERT INTO ivb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Do dawri, yangay a inbahey ni Maria Magdalena iyaw nyaya dyirad nachirarayayaw di Jesos a madama a tomanyitanyis do kapagmamayo da. ");
INSERT INTO ivb_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ki do nakadngey daw sya a minirwa nabyay si Jesos, kan naboya ni Maria, inanohdan daba. ");
INSERT INTO ivb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Katayokan nya, napaboya si Jesos dyirad dadwa saw a nanawhen na do kayam daw do ayamanaw a mangay do barbaryo, ki nagbaliw danaw mostra na. ");
INSERT INTO ivb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Do dawri, naybidi saw dadwaw do syodad a nangay a nangibahey dyirad rarayay da saw a nanawhen a napaboyas Jesos dyira, ki alit na dyi da inanohdan. ");
INSERT INTO ivb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Sinpangan na, do dawri, napaboya si Jesos do yanan daw no onsi saw a nanawhen na a madama a koman. Pinaydabdab na sa maynamot do kabwaw no kapanganohed da kan katwaw no oho da do dyi daw a nanganohdan dyirad nakaboyaw a nagongar dana. ");
INSERT INTO ivb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Sinpangan na, binilin na sa a kāna, “Mangay kamo do intīro a lobong, kan ikasaba nyo Maganay a Dāmag do tabo tawotawo. ");
INSERT INTO ivb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","No sino a manganohed as mabonyagan, ki maisalakan anchi. Ki no dya manganohed, madosanchi. ");
INSERT INTO ivb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Siranchiw nyayaw pangilasinan a maipaboya dan manganohedaw dyaken: Mapaksyat danchiw marahet saw a ispirito maynamot do kaosar das ngaran ko. Makapaychirin pa sanchis chirin a dyi da nachinanawowan. ");
INSERT INTO ivb_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Aran mangigpet sanchis marem mana minom so makabinino, madiman sabanchi. An palapawen daw tanoro da do oho dan maganyit saw, ki mapyan sanchi.” ");
INSERT INTO ivb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Do nakatayokaw ni Jesos a naychirin dyira, naypatohos do hanyit, kan nangay a naydisna do makanawanaw ni Āpo Dyos. ");
INSERT INTO ivb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ki siraw nanawhenaw ni Jesos, yangay da inkasabaw Maganay a Dāmag do tabo a loglogar. Sinidongan san Āpo Jesos a nangipanpaneknek so kaoyod no inkaskasaba daw maynamot do milagro saw a inpapariparin na dyira.");
INSERT INTO ivb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Dyimom madayaw a Teopilo, Aro dana saw nangpadas a naytolas so maynamot do natongpalaya do payayahatangan taya. ");
INSERT INTO ivb_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","On, no intolas daw, ki akmas nakaiparawat daw dyamen yapod kasiknan na pa no mismo saw a nakaboya kan nangasaba so maynamot di Jesos. ");
INSERT INTO ivb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Aran yaken, maynamot ta kinaganay ko kan nabisado ko a nachinanawan a tabo nya saya napariparin a yapo do kasiknan da, naktokto ko pa a maganay an itolas ko sa dyimo nyaya sigon do kosto a kasarosarono da, ");
INSERT INTO ivb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","tan sakangwan mapatakan mo a oyod iyaw no nainanawo saya dyimo. ");
INSERT INTO ivb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Do chimpwaw no kapagāri ni Herodes do Jodya, ki myan daw asa a padi a mayngaran so Sakaryas a asa mimbro no bonggoy no papadi saw a inpangpangōlwan Abias do kaychowa. Iyaw nyaya Sakaryas, ki myan baket na a mayngaran so Elisabet a yapo do kapotōtan ni Aaron. ");
INSERT INTO ivb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Siraw nya maychabahay, ki mayengay sa malinteg do salapen no Dyos, as kan kinapyā da a inononotan tabo bilbilin kan paglintegan no Dyos. ");
INSERT INTO ivb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ki abaw anak da, ta hopes si Elisabet. Asa pa, malkem kan baket dana sa. ");
INSERT INTO ivb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Asa karaw, narapit arawaw a batang no bonggoy da Sakaryas, kan iyaw magsirbi do Dyos do Timplo do dawri. ");
INSERT INTO ivb_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Sigon do dadakay daw no papadi, si Sakaryas nabonot a somindep do Timplowaw ni Āpo a maysosoh so insinso. ");
INSERT INTO ivb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Do nakarapitaw no oras a kapaysosoh na so insinso, naychipeh saw aro a tawotawo a maydaydasal do gaganaw no Timplo. ");
INSERT INTO ivb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sinpangan na, myan nagparang di Sakaryas asa a anghil ni Āpo, kan naytēnek do makanawanaw no altar a paysosohan so insinso. ");
INSERT INTO ivb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ki do nakaboyaw syan Sakaryas, sominryam, as kan oltimo nakamo na. ");
INSERT INTO ivb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ki binata dya no anghilaw a kāna, “Mamo kabam Sakaryas, ta nadngey no Dyos dasal mwaw. Dawa, maymanganak anchis Elisabet a kabahay mo so mahakay, kan pangaranan monchis Juan. ");
INSERT INTO ivb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ay, āngo nchya kasoyot mo, as kan aro sanchiw masoyot do kaiyanak naw! ");
INSERT INTO ivb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ta iya, ki maibidang anchi a masisita do salapen no Dyos. Machita dya polos a minom so palek mana aran āngo a makabok, as kan makneb anchi so panakabalin no Ispirito Santo a aran myan pad bodek ni ānang na. ");
INSERT INTO ivb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Aronchi dyirad kapotōtan Israel paybidyen na di Āpo a Dyos da. ");
INSERT INTO ivb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Manmanmanchi kan si Āpo, as kan iyaw panakabalin na, ki akmas intorohaw no Masantwan a Ispirito di propīta Elyas do kaychowa. Paychachapyahen na sanchiw may–aāmang. Pagbabawyen na sanchiw masosokir saw a tawotawo tan mangtokto sanchi a akmas siras malinteg saw. On, nyayaw parinen nanchi tan isagāna na saw tawotawowaw do kawara ni Āpo.” ");
INSERT INTO ivb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ki binata ni Sakaryas do anghilaw a kāna, “Maypangonchiw kapatak ko sya a maparin saw nya, ta malkem ako naya kan koribetbet danaw si baket ko?” ");
INSERT INTO ivb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ki tinbay no anghilaw a kāna, “Yaken si Gabriel a pachirawatan ni Āpo Dyos, kan maytēnek ako do salapen na. Tinoboy na yaken a mangay a mangibahey so nya maganay a dāmag dyimo. ");
INSERT INTO ivb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Maynamot ta inanohdan mwabaw binata ko saya, makapaylilyak ka paba a mandan arawaw a maparin saw inbahey kwaya, ta sigorādo a maparin anchi anchan marapit oras na.” ");
INSERT INTO ivb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ki siraw tawotawo saw do gagan a mangnanaya di Sakaryas, chinasdaaw da an āngo chinahay na do irahemaw no Timplo. ");
INSERT INTO ivb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sinpangan na, do nakahtot naw, oyod a omel dana, ta makapaylilyak paba. Nyaw nakatonngan da sya a myan naipaboya no Dyos dya do irahem. Yapo do dawri, sininsinyasan na saw tawotawo, ta polos a dya makapaychirin dyira. ");
INSERT INTO ivb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Do nakakabos danaw no arawaw no nakapagsirbi nad Timplo, somnabat danad bahay na. ");
INSERT INTO ivb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Oyod a nahay aba, as nakapanginaw ni Elisabet a baket na, as kan do dawri, minohbot paba do bahay na do dadima a kabohan. ");
INSERT INTO ivb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Binata na do inawan na, “Pinarin no Dyos dyaken nya sichangori a maynamot do kāsi na dyaken. Sichangori, pinakaro naw nya pakasnesnekan ko do salapen tawotawo.” ");
INSERT INTO ivb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Do chanemaw a kabohan bogyaw ni Elisabet, tinoboy no Dyos si anghil Gabriel do idi a Nasaret do probinsya a Galilya. ");
INSERT INTO ivb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nangay do asa balāsang a birhin a naitolag a machikabahay di Jose a kapotōtan ni simna Āri Dabid. No ngaran nya birhin, ki si Maria. ");
INSERT INTO ivb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Do nakapagparangaw no anghilaw di Maria do bahay na, binata na dya a kāna, “Komosta ka! Masoyot ka, ta machitatārek parabor dyimo no Dyos, kan ay–aywanan naymo.” ");
INSERT INTO ivb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maynamot do dyaya naparin, taywara chinariribok ni Maria an āngo inbaheyaw no anghilaw, kan iniktokto na an āngo chakey na batahen. ");
INSERT INTO ivb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ki binatan anghilaw dya a kāna, “Mamo kabam Maria, ta pinidi naymo ni Āpo Dyos a kaipaboyan parabor na. ");
INSERT INTO ivb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mabogi kanchi kan iyanak monchiw asa mahakay, kan pangaranan monchis Jesos. ");
INSERT INTO ivb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mabīleg anchi, kan matawagan anchi so Anak no Katotohosan. Pagārihen anchi ni Āpo Dyos a akmas kapoonan na a si Āri Dabid. ");
INSERT INTO ivb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Itorayan na sanchi a abos pandan kapotōtan sayan Jakob, kan abanchiw pandan kapagāri na.” ");
INSERT INTO ivb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ki tinbay ni Maria iyaw anghilaw a kāna, “Maypāngo a maparin nyaya dyaken a asa kwa birhin?” ");
INSERT INTO ivb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Tinbay no anghilaw a kāna, “Mangay anchi dyimo Ispirito Santo, as kan pongosan nanchimo so panakabalin no Manakabalin a Dyos. Nyaw paynamotan na a iyaw masantwanaya a adekey a iyanak monchi, ki matawagan anchi so Anak no Dyos. ");
INSERT INTO ivb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","“Chiban mo pas Elisabet a kabagyan mo a aran batabatahen da a hopes, ki maymanganak anchi. Changori, anem dana kabohan kabogi na a aran bakbaketan dana. ");
INSERT INTO ivb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ta aba polos dya maparin ni Āpo Dyos.” Nawriw binatan anghilaw. ");
INSERT INTO ivb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ki binatan Maria a kāna, “Cha ko dya a pachirawatan Āpo Dyos. Maparin pakono sa dyaken akmas binata mo saya.” Sinpangan na, komnaro danaw anghilaw. ");
INSERT INTO ivb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Do dawri, nahay aba as nakapagrobwat ni Maria, kan nakalyalisto a nangay do katokotokonanaw do asaw a idi do Jodya. ");
INSERT INTO ivb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nangay a somindep do bahay daw da Sakaryas, kan kinablaawan na si Elisabet. ");
INSERT INTO ivb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ki do nakadngeyaw ni Elisabet so kablaawaw ni Maria, minlon adekeyaw do bodek na, as kan nakneb si Elisabet do panakabalin no Ispirito Santo. ");
INSERT INTO ivb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Do dawri, nakalyak a kāna, “Ay, imo kagagasātan do tabo a mababakes, as kan magasat anchiw iyanak mo a adekey! ");
INSERT INTO ivb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Chasdaaw kwaya, ta sino ako a yangay a sarongkaran ānangayan Āpo ko? ");
INSERT INTO ivb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Chiban mo, do nakadngey kwaw so nakakablaaw mwaw dyaken, ki minlon adekeyaya do bodek ko do kasoyot na. ");
INSERT INTO ivb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","On, magasat ka, ta nanganohed ka a matongpal sanchiw inbaheyaw no Dyos dyimo!” binata ni Elisabet. ");
INSERT INTO ivb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Sinpangan na, naychirin si Maria a kāna, “Daydayāwen ko Āpo ko do tābo a aktokto ko. ");
INSERT INTO ivb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ayso kasoyot ko maynamot do Dyos a Mangisalakan ko, ");
INSERT INTO ivb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ta nanakem na yaken a mabodis a pachirawatan na! Mangrogi sichangori, batabatahen danchin tabo a tawotawo a magasat ako ");
INSERT INTO ivb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","maynamot do kataywara a kapakasdaaw a naparin dyaken a pinarin no manakabalin kan masantwan a Dyos. ");
INSERT INTO ivb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Asa pa, chāsi na saw manganyibaw sya a mangrogi dyirad kapoonan ta saw a mandanchi dyirad somarsarono pa saya a kapotōtan. ");
INSERT INTO ivb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Inpaboya naw panakablin na, kan pinaychaket na saw plano dan mapapangas saw a tawo. ");
INSERT INTO ivb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Pinakaro naw toray dan matotohosaw a aāri, as pinatohos naw saad dan mabobodis saw a tawotawo. ");
INSERT INTO ivb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Inapnek na sas maganay makachitaw, ki siraw mabaknangaw, ki pinayam na sa a kaynaynawan da. ");
INSERT INTO ivb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Sinidongan na saw tawotawo na a kapotōtan Israel a pachirawatan na, ta nāw na nanakem iyaw kari na a kāsi dyira. ");
INSERT INTO ivb_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","On, inpaboya naw kāsi na di simna Abraham kan dyaten a tabo a kapotōtan na a abos pandan a akmas inkari naw dyira kaychowa.” Nyaw binatan Maria. ");
INSERT INTO ivb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Minyan si Maria so malabit a tatdo a kabohan do yanan da Elisabet, as nakapaybidi nad bahay naw do Nasaret. ");
INSERT INTO ivb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Sinpangan na, do nakarapit danaw so orasaw a kapaymanganak ni Elisabet, inyanak naw asaw a mahakay. ");
INSERT INTO ivb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Do nakadamag daw syan karoba da saw kan siraw kakabagyan da saw so makaskasdaawaya a pinarin Āpo Dyos dya, ki nachipagragsak sa dya. ");
INSERT INTO ivb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Do chawawaho naw a araw no adekeyaw, yangay da inpakogit, ta nyaw sigod a dadakay da, kan chakey da pangaranan so Sakaryas tan mayengay sa kan āmang na. ");
INSERT INTO ivb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ki nachiengga si Elisabet a kāna, “Engga, Juan ngaran na.” ");
INSERT INTO ivb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ki binata da dya a kon da, “Naon, ki abayaw mayngaran so Juan a kabagyan nyo.” ");
INSERT INTO ivb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Do dawri, sininyasan das Sakaryas, ta yahes da an āngo chakey na ngaran adekeyaw. ");
INSERT INTO ivb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sinpangan na, nangdaw si Sakaryas so paytolasan na, as kan nyaw intolas na: “Juan iyaw ngaran na.” Chinasdaaw da a tabo no myan saw daw. ");
INSERT INTO ivb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Do dawri, nyeng a napakaro kaomelaw ni Sakaryas, kan naychirin so pangidayaw na so Dyos. ");
INSERT INTO ivb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nasdaawan sa tabo karoba da saw daw, as kan nakarakarapit nya dāmag do tabo a tawotawo do songesonget no Jodya. ");
INSERT INTO ivb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nyaw iniktokto dan tabo tawotawo saw a nakadngey sya a, “Āngo paronchiw payparinan nyaya a adekey anchan mayparakoh?” Nyaw binata da, ta madlaw da a myan panakabalin ni Āpo do dawri a adekey. ");
INSERT INTO ivb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Do dawri a nakapakalilyak dana ni Sakaryas a āmang ni Juan, nakneb dana do panakabalin no Ispirito Santo, kan inpadto na a kāna, ");
INSERT INTO ivb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Madaydayaw si Āpo a Dyos dan kapotōtan Israel, ta yangay na yaten a sarongkaran tan wayawayaan na yaten a tawotawo na. ");
INSERT INTO ivb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Tinorohan na yaten so mabīleg a Mangisalakan a yapo do kapotōtan Āri Dabid a pachirawatan na. ");
INSERT INTO ivb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","On, nyaw am–āmang dana inpaibahey na dyirad masantwan saw a propīta na do kaychowa ");
INSERT INTO ivb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","a isalākan na yaten dyirad kabosor ta kan sira tabo mangipsokaw dyaten. ");
INSERT INTO ivb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Binata na pa a chāsi na saw kapoonan ta, kan naknakmen naw masantwanaw a tolag na dyira. ");
INSERT INTO ivb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","On, inkari na di Abraham a kapoonan ta ");
INSERT INTO ivb_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","a isalākan na yaten dyirad kabosor ta tan abo kāmo ta a magsirbi dya ");
INSERT INTO ivb_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","a nāw na masantwan kan malinteg do salapen na do tabo araw do kabyay taya. ");
INSERT INTO ivb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ki imo a anak ko, matawagan kanchi a propīta no Katotohosan a Dyos. Nanmanma ka kan si Āpo tan isagāna mo ayaman na. ");
INSERT INTO ivb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","On, ipakatoneng monchi dyirad tawotawo na a maisalakan sa a maynamot ta napakawan dana sa do gatogatos da, ");
INSERT INTO ivb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ta oltimo a masisyen iyaw Dyos ta, as kan toboyen nanchiw asaw a yapod hanyit a kayarig no domadaw a araw a mangay a mangisalakan dyaten. ");
INSERT INTO ivb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ta anchan mangay, ki sedangan na sanchiw myan saya do kasarisaryan a mangay danad kadiman a abos pandan, as kan palongohen nanchi yaten do rarahan a mangay do kaydamnayan no kapangtokto.” Nawriw binatan Sakaryas. ");
INSERT INTO ivb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Do dawri, nayparakoh kan naypayit adekeyaw do inawan kan do kapakatoneng so maynamot do naispiritwan a byay. Minyan do let–ang a nandad nakapaboya naw a nangnanawo dyirad tawotawo saw a kapotōtan Israel. ");
INSERT INTO ivb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Do dawri saw a araw, myan bilin a yapod Agosto Caesar a maipalista tabo a tawotawo a omidi do dawri a pagaryan Roma. ");
INSERT INTO ivb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nya dāmo a kapagpalista, ki do kagobirnadoraw ni Kirenyo do Sirya. ");
INSERT INTO ivb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","As katakatayisa, ki nangay sa tabo a magpalista do mismo da a idi. ");
INSERT INTO ivb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Do dawri, aran si Jose, ki nagrobwat a mangay a magpalista. Ki maynamot ta yapo do kapotōtan kan pamilyaw ni Āri Dabid, nangay a yapod idi na a Nasaret do probinsya a Galilya kan nangay do Jodya do idi a Betlehem a iyaw idyaw ni Āri Dabid kaychowa. ");
INSERT INTO ivb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Do kangay naya a magpalista, rinarayay na si Maria a naitolag a kabahayen na, as kan mabogi dana si Maria do dawri. ");
INSERT INTO ivb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ki do kayan daranaw do Betlehem, narapit oras a kapaymanganak na. ");
INSERT INTO ivb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Do dawri, inyanak ni Maria iyaw matonengaya a mahakay a anak na. Sigon do dadakay da, pinongosan nas mananaro saw a lamilamit, as kan maynamot ta abaw yanan da do pagdagdagosan saw a bahay, pinapoktad na do hosagan daw no binyay. ");
INSERT INTO ivb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ki do dawri a ahep, do masngen do dawri a idi, myan saw magpaspastor a magbanbantay siras karniro da saw do pagpapaaraaban daw sira. ");
INSERT INTO ivb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ki nyiknyinan a myan napaboya dyira a anghil ni Āpo, kan nadibon san sedang no kararanyagan a glorya ni Āpo Dyos, as kan taywaraw nakamo da. ");
INSERT INTO ivb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ki binatan anghilaw dyira a kāna, “Mamo kamo aba, ta yangay ko dyinyo maganay a dāmag a manoroh so rakoh a soyot dyirad tabo a tawotawo. ");
INSERT INTO ivb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Sichangori, do idi ni Āri Dabid, ki nayanak si Kristo a Āpo kan Mangisalakan nyo. ");
INSERT INTO ivb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Iyanchiw nyaw pakatonngan nyo sya: Maboya nyonchiw adekeyaw a nakapoktad do asa hosagan a napongosan so mananaro a lamilamit.” ");
INSERT INTO ivb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ki naychihat a nagparang reprep saw a aanghil a yapod hanyit a siraw rarayay saw no napaboyaw dyira, kan nagdaydayaw sa do Dyos a kon da, ");
INSERT INTO ivb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Matan–ok si Āpo Dyos do katotohosan a hanyit, kan myan danaw kapaychachapya dyirad tawotawo a chinahwahok na do lobongaya!” ");
INSERT INTO ivb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Do nakakaro daranaw no anghil saw a naybidi do hanyit, binata dan magpaspastor saw do katakatayisa dyira a kon da, “Ngay, mangay tad Betlehem, ta yangay ta chiban inpakatonengaya ni Āpo dyaten.” ");
INSERT INTO ivb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nakalyalisto sa nangay, as kan do nakapakarapit daw daw, nachichwasan da sa Maria kan Jose, as kan naboya da pa iyaw adekeyaw a nakapoktad do hosagānaw. ");
INSERT INTO ivb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Do nakaboya daw so adekeyaw, inistorya dan magpaspastoraw iyaw inpakatonengaw dyiran anghilaw a maynamot dya ");
INSERT INTO ivb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ki nasdaaw sa tabo nakadngeyaw so inbahey daw no magpaspastor saw. ");
INSERT INTO ivb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ki si Maria, kinapya na sa tabo do aktokto naw inbahebahey daw no magpaspastor saw, as kan nāw na iktokto chakey da batahen. ");
INSERT INTO ivb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sinpangan na, naybidi dana saw magpaspastoraw a mangibahebahey so pagdaydayaw da di Āpo Dyos maynamot do tabo nadngey daw kan naboya daw, ta naparin sa tabo a akmas inbaheyaw no anghil dyira. ");
INSERT INTO ivb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Do chawawaho naranaw a karaw no adekeyaw, inpakogit da, as kan pinangaranan das Jesos. Iyaw nyaw ngaranaw a inbahey no anghilaw sakbay a naīnaw. ");
INSERT INTO ivb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Do nakarapit daranaw so arawaw a kapagtongpal da so kapakadalos da do salapen no Dyos a akmas naitolasaw do Lintegaw ni Moyses a maynamot dyirad naymanganak, inyangay da Jose kan Maria iyaw anak daw do Jerosalem tan iparawat da do Dyos. ");
INSERT INTO ivb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Pinarin daw akmas naitolasaw do linteg ni Āpo Dyos a kāna, “Kāda matoneng a anak a mahakay, ki naibidang a dyira no Dyos.” ");
INSERT INTO ivb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Indāton da pa di Āpo Dyos iyaw dāton da a mismo a akmas naitolasaw do linteg ni Āpo a kāna, “Masisita a myan dadwa boyit mana dadwa anak no kalapāti.” ");
INSERT INTO ivb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ki do dawri, myan asa malkem do Jerosalem a mayngaran so Simeon a panapanayahen naw kaisalākan no Dyos so tawotawo a kapotōtan Israel. Malinteg katawo na kan managdaydayaw di Āpo Dyos, as kan myan dyaw Ispirito Santo. ");
INSERT INTO ivb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Inpakatoneng no Ispirito Santo dya a madiman aba, an dyi na pa maboyaw Kristo a iyaw inkaryaw ni Āpo Dyos. ");
INSERT INTO ivb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Maynamot do kapawnot no Ispirito Santo dya, somindep si Simeon do Timplo. Ki do dawri, do kaiyangay daw da Jose kan Maria si Jesos do irahem tan tongpalen daw bilinaw a naitolas do linteg, ");
INSERT INTO ivb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","inhap ni Simeon adekeyaw a kinepkep, as nakaidaydayaw nas Āpo Dyos a kāna, ");
INSERT INTO ivb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Changori, natongpal kari mwaw dyaken, mo Āpo. Palobosan mo na yaken a pachirawatan mo a madiman a sikakapya. ");
INSERT INTO ivb_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","On, ta naboya ko na a mismo nyaya a tinoboy mo a mangisalakan a insagāna mo do salapen dan tabo a tawotawo do lobongaya. ");
INSERT INTO ivb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kayarig naw soho a mangsedang so pangtoktwan dan Dya–Jodyo, as kan maynamot dya, ki iyangay na anchiw dāyaw dyirad tawotawo mo a kapotōtan Israel.” ");
INSERT INTO ivb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Do dawri, chinasdaaw da Jose kan Maria iyaw chinirin saw ni Simeon a maynamot di Jesos. ");
INSERT INTO ivb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Binindisyonan san Simeon, kan binata nad Maria a ānang na, “Pinidi no Dyos nya adekey a pakararayawan kan pakaisalakanan aro a tawotawo a kapotōtan Israel. On, iyaw pangilasinan a tinoboy no Dyos a mangipaneknek so chakey naw. Ki aran komwan, kontraen danchin aro a tawotawo. ");
INSERT INTO ivb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","No pagtongpalan na, mapahtot anchiw intayo daw no tawotawo do makatayrahem a aktokto da. Ki imom Maria, oltimonchi a kapagmamayo mo, ta akma kanchiw mabagkong do poso mo,” binata ni Simeon. ");
INSERT INTO ivb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ki myan do dawriw asaw a propīta a mabakes a mayngaran so Ana. Iya, ki pōtot ni Panwel a yapod kapotōtan Aser, kan taywara danaw kabaket na. Papito lang a katawen nakapayopok da kan lakay na, ");
INSERT INTO ivb_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","as nakabālo na. Do dawri, myan danaw wawaho a poho kan apat a tawen na. Polos a dya komnarokaro do Timplowaw, an dya nāw na nagdaydayaw do Dyos a nagay–ayonar kan naydaydasal do maraw kan mahep. ");
INSERT INTO ivb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Do dawri a nakayangay das Jesos do Timplo, ki nangay si Ana do yanan daw, kan nagyaman do Dyos. Yapo do dawri, inbahebahey naw maynamot do adekeyaw dyirad tabo a mangnangnanaya so kapangisalakan no Dyos so tawotawo do Jerosalem. ");
INSERT INTO ivb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Do nakatayoka daw da Jose kan Maria a nagtongpal so tabo inbilinaw no linteg ni Āpo, naybidi dana sa do Nasaret a idi da do probinsya a Galilya. ");
INSERT INTO ivb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Do dawri, nayparakoh kan naypayit si Jesos. Napno so kinasirib, kan myan dyaw parabor no Dyos. ");
INSERT INTO ivb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kāda tawen, ki mangangay saw inyapwan naw ni Jesos do Jerosalem a machipista do Pistaw no Nakahabas no Anghil. ");
INSERT INTO ivb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Maynamot ta nyaw dān da pariparinen, nangay dana sa nachipista. Magtawen si Jesos so asa poho kan dadwa do dawri. ");
INSERT INTO ivb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ki do nakatayoka danaw no pistaya, somabat dana sa do Nasaret, ki nadladlaw daba no inyapwanaw a nabidin sawen si Jesos do Jerosalem. ");
INSERT INTO ivb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Komwan naparin, ata, no myan do aktokto da, ari a nachisagel si Jesos do aro saw a rarayay da, dawa, tinongtong daw nayam so asa karaw. Ki do nakadlaw daw sya a abo si Jesos, yangay da inyahahes dyirad kakabagyan da saw kan siraw chapapatak da saw. ");
INSERT INTO ivb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Do dyi daw a nakaboyan sya, pinaybidi da a yangay a chinichwas do Jerosalem. ");
INSERT INTO ivb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Do chatatdo naranaw a karaw, nasarakan da a myan do Timplo, kan myan a machidisdisna dyirad mamaistro saw no Jodyo. Ditā na daw a mangadngedngey kan manahahes dyira. ");
INSERT INTO ivb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nasdaaw sa tabo nakadngeyaw sya maynamot do kapakaāwat naw kan atbay na saw. ");
INSERT INTO ivb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Komwan a nasdaawan saw inyapwan naw do nakaboya daw sya. Binatan ānang na dya a kāna, “Anak ko, āngo ta pinarin mo dyamen nya? Oltimo a bakel namen kan āmang mo a maychichichwas dyimo?” ");
INSERT INTO ivb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ki nyaw initbay ni Jesos dya a kāna, “Āngo ta chinichwas nyo yaken? Chapatak nyo abawri a machita a myan ako do bahay ni Āmang ko?” ");
INSERT INTO ivb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ki naawātan dabaw inbahey naw dyira. ");
INSERT INTO ivb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Do dawri, nachangay danas Jesos dyira a naybidi do Nasaret, as kan matodyo kan managtongpal si Jesos dyira. Kinapya na sa tabon ānang naw nya napariparin do aktokto naw. ");
INSERT INTO ivb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nayparakoh si Jesos do inawan na kan do sirib, as kan makahwahok do Dyos kan do tawotawo. ");
INSERT INTO ivb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Do nakahabasaw no aro a tawen, do chaasa poho naw kan dadima a katawen no nakapagtoray ni Impirador Tiberyo, ki myan dana si Ponsyo Pilato a gobirnador do Jodya, kan nagtoray si Herodes do Galilya, as kan si Pilipi a kakteh ni Herodes, ki nagtoray do loglogar a Itorea kan do Trakonite. Myan pa si Lisanyas a nagtoray do Abilene, ");
INSERT INTO ivb_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","as kan myan pa sa Anas kan Kaypas a naggedan a katotohosan a padi do Jerosalem. As do dawri a chimpo, nawaraw no chirin ni Āpo Dyos di Juan a anak ni Sakaryas do kayan naw do let–ang. ");
INSERT INTO ivb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Binidibidi ni Juan tabo yanan tawotawo do maychamibitaw no oksongaw a Jordan, kan nangaskasaba dyira a kāna, “Magbabāwi kamo kan pabonyagan kamo. Tan komwan, pakawanen naynyo no Dyos do gatogatos nyo.” ");
INSERT INTO ivb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","No nyaya a pinariparin ni Juan, ki pakatongpalan no intolasaw ni Isayas a asa propīta kaychowa a kāna, “Iyanchiw mangingengengey do let–ang a mangibahebahey so nya a kāna, ‘Mamarin kamo so rarahan a para do Āpo, kan paysonongen nyo pakono ayaman na.’ ");
INSERT INTO ivb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ponan nyo saw naychachichidongan na, as pagdapagen nyo saw naychatokotokonan na. Lintegen nyo saw naypaypachichwan na, as linisen nyo naychadodogolanaw. ");
INSERT INTO ivb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Do dawri, maboyanchin tabo a tawotawo kapangisalakan no Dyos!” ");
INSERT INTO ivb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Iyaw nyayaw binata ni Juan dyirad aro saw a tawotawo a nangay a magpabonyag dya a kāna, “Inyo a anak no karasaen! Sino nakabata dyinyo a maditditan nyo ītwaya a soli ni Āpo Dyos an nabonyagan kamo? ");
INSERT INTO ivb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nawri pakono ipaboya nyo do kaparin nyo a nagbabāwi kamo do gatogatos nyo ah! Chasaray nyo abaw kabata nyowaya sya a, ‘Ara, ta kapoonan namen si simna Abraham,’ ta ibahey ko dyinyo a maparin ni Āpo Dyos a payparinen bato saya dya a kapotōtan ni Abraham! ");
INSERT INTO ivb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Annadan nyo okom no Dyos a akmay wasay a nakasagāna dana panongeh so kayowaw a dya omsi so maganay, as kapayongeb na syad apoy.” ");
INSERT INTO ivb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ki inyahes dan aro saw a tawotawo di Juan a kon da, “Na, an komwan, āngo paro parinen namen?” ");
INSERT INTO ivb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ki initbay ni Juan dyira a kāna, “No myan so dadwa laylay, machita paramanan naw abwanan. Masaw no myan so kanen, torohan na pakono maychapteng.” ");
INSERT INTO ivb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ki do dawri, aran siraw magsingsingir saw so bwis, ki myan sa a nangay a magpabonyag. Inyahes dad Juan a kon da, “Maistro, āngo paro parinen namen?” ");
INSERT INTO ivb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ki initbay ni Juan dyira a kāna, “Magsingir kamo aba so arwaro kan iyaw naikeddengaw a singsingiren nyo.” ");
INSERT INTO ivb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Myan pa saw kadwan a soldado, ki inyahes da dya a kon da, “Na, an yamen, āngo paro parinen namen?” Ki binatan Juan dyira, “Pilpiliten nyo aba a samsamen kwarta dan tawotawo saw, as kan maybayataw kamwaba mapagatos so aran sino a tawo. Asa pa, mapnek kamo na pakono do maitorohaya sweldo nyo.” ");
INSERT INTO ivb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Maynamot do dyaya chirin ni Juan, naypaypangay arapaap dan tawotawo a maynamot dya a iya danaw Kristwaw, ta siiinama sa a ītonchiw Kristo. ");
INSERT INTO ivb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ki binata ni Juan dyira tabo a kāna, “Bonyagan koynyo do ranom, ki mangay anchiw matortoray kan yaken, as kan maikari akwaba a mangwasak so kahot no tokap na. Bonyagan nanchinyo so Ispirito Santo kan apoy. ");
INSERT INTO ivb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ari dyaw akmay igaw a paytahpan na tan mapaytawa naw hopes kan nakabyas saw. Iyaw matahpanaw, kapyahen nad agāmang naw. As iyaw naytahpanaw, sosohan nas apoy a abos pandan.” ");
INSERT INTO ivb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Aro paw matatarek a pamagbaga ni Juan do kapangikasaba naw so Maganay a Dāmag dyirad tawotawo saw. ");
INSERT INTO ivb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Pinaydabdab na paw si Gobirnador Herodes do nakaagaw naw si Herodyas a baket ni kakteh na kan maynamot pa do tabo saw a marahet a pinariparin na. ");
INSERT INTO ivb_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Malaksid dyirad dyaya kāron marahet a pinarin Herodes, otro rinohnwan na pa a inpabahod si Juan. ");
INSERT INTO ivb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Do dyi paw a nakabahodan Juan, aro saw tawotawo a nagpabonyag dya. Do dawri, aran si Jesos, ki nagpabonyag dya. As do kadamaw ni Jesos a maydasal, naywangan hanyit, ");
INSERT INTO ivb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","kan naypabodis dyaw Ispirito Santo a akmas inawanaw no boyit. Sinpangan na, myan timek a yapod hanyit a nakabata so nya a kāna, “Imo Anak ko a oyod kos chadaw. Oltimo a mahwahok ako a maynamot dyimo.” ");
INSERT INTO ivb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Do kaisiknanaw ni Jesos so tarabako na, mangay dana tatdwa poho tawen na. An maynamot dya, ki ibidang dan tawotawo a anak ni Jose. As si Jose, ki pōtot ni Eli. ");
INSERT INTO ivb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","As si Eli, ki pōtot ni Matat. As si Matat, ki pōtot ni Lebi. As si Lebi, ki pōtot ni Melki. As si Melki, ki pōtot ni Jane. As si Jane, ki pōtot ni Jose. As si Jose, ki pōtot ni Matatias. ");
INSERT INTO ivb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Si Matatias, ki pōtot ni Amos. As si Amos, ki pōtot ni Nahom. As si Nahom, ki pōtot ni Esli. As si Esli, ki pōtot ni Nage. ");
INSERT INTO ivb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Si Nage, ki pōtot ni Maat. As si Maat, ki pōtot ni Matatias. As si Matatias, ki pōtot ni Semei. As si Semei, ki pōtot ni Jose. As si Jose, ki pōtot ni Joda. ");
INSERT INTO ivb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Si Joda, ki pōtot ni Joana. As si Joana, ki pōtot ni Resa. As si Resa, ki pōtot ni Serobbabel. As si Serobbabel, ki pōtot ni Sealtiel. As si Sealtiel, ki pōtot ni Neri. As si Neri, ki pōtot ni Melki. ");
INSERT INTO ivb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Si Melki, ki pōtot ni Adi. As si Adi, ki pōtot ni Kosam. As si Kosam, ki pōtot ni Elmodam. As si Elmodam, ki pōtot ni Er. ");
INSERT INTO ivb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Si Er, ki pōtot ni Joswe. As si Joswe, ki pōtot ni Elieser. As si Elieser, ki pōtot ni Jorim. As si Jorim, ki pōtot ni Matat. As si Matat, ki pōtot ni Lebi. ");
INSERT INTO ivb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Si Lebi, ki pōtot ni Simeon. As si Simeon, ki pōtot ni Jodas. As si Jodas, ki pōtot ni Jose. As si Jose, ki pōtot ni Jonan. As si Jonan, ki pōtot ni Eliakim. ");
INSERT INTO ivb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Si Eliakim, ki pōtot ni Melea. As si Melea, ki pōtot ni Mena. As si Mena, ki pōtot ni Matata. As si Matata, ki pōtot ni Natan. As si Natan, ki pōtot ni Dabid. ");
INSERT INTO ivb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Si Dabid, ki pōtot ni Jesse. As si Jesse, ki pōtot ni Obed. As si Obed, ki pōtot ni Boas. As si Boas, ki pōtot ni Salmon. As si Salmon, ki pōtot ni Naason. ");
INSERT INTO ivb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Si Naason, ki pōtot ni Aminadab. As si Aminadab, ki pōtot ni Aram. As si Aram, ki pōtot ni Arni. As si Arni, ki pōtot ni Esron. As si Esron, ki pōtot ni Pares. As si Pares, ki pōtot ni Joda. ");
INSERT INTO ivb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Si Joda, ki pōtot ni Jakob. As si Jakob, ki pōtot ni Isaak. As si Isaak, ki pōtot ni Abraham. As si Abraham, ki pōtot ni Tare. As si Tare, ki pōtot ni Nakor. ");
INSERT INTO ivb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Si Nakor, pōtot ni Serog. As si Serog, ki pōtot ni Ragaw. As si Ragaw, ki pōtot ni Peleg. As si Peleg, ki pōtot ni Heber. As si Heber, ki pōtot ni Selah. ");
INSERT INTO ivb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Si Selah, ki pōtot ni Kainan. As si Kainan, ki pōtot ni Arpasad. As si Arpasad, ki pōtot ni Sem. As si Sem, ki pōtot ni Noyi. As si Noyi, ki pōtot ni Lamek. ");
INSERT INTO ivb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Si Lamek, ki pōtot ni Matosalem. As si Matosalem, ki pōtot ni Enok. As si Enok, ki pōtot ni Jared. As si Jared, ki pōtot ni Mahalaleel. As si Mahalaleel, ki pōtot ni Kainan. ");
INSERT INTO ivb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Si Kainan, ki pōtot ni Enos. As si Enos, ki pōtot ni Set. As si Set, ki pōtot ni Adan, as kan si Adan, ki anak no Dyos. ");
INSERT INTO ivb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Do nakakaro danaw ni Jesos do Oksong a Jordan, ki nakneb do panakabalin no Ispirito Santo, as kan pinalongo no Ispirito do naychabongbongrwaw a let–ang. ");
INSERT INTO ivb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Minyan daw si Jesos so apat a poho a karaw, kan sinosoot ni Satanas. Ki iyaw kayanaw ni Jesos daw, polos a dya komninan, as kan do panapanawdyanaw, naptengan. ");
INSERT INTO ivb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Binata dya ni Satanas a kāna, “An oyod a imo Anak no Dyos, mandaran mo paw nyaya bato a mayparin a tinapay.” ");
INSERT INTO ivb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ki initbay ni Jesos dya a kāna, “Naitolas do Masantwan a Tolas a, ‘Tinapay aba lang manoroh so byay no tawotawo.’” ");
INSERT INTO ivb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sinpangan na, pinalongo ni Satanas si Jesos do matohosaw a yanan, as nakaiparang na dya so tabo saw a pagpagaryan do lobongaya do pagripat lang. ");
INSERT INTO ivb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Binata na pa di Jesos a kāna, “Itoroh ko sanchi a tabo dyimo nyaya panakabalin a mangitoray kan tābo kinabaknang da, ta naitoroh sa tabo dyaken, kan maparin ko a itoroh do aran sino a chakey ko a panorohan. ");
INSERT INTO ivb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Dawa, an magdayaw ka dyaken, ayket, dyira mo na sa tabo.” ");
INSERT INTO ivb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ki inatbay ni Jesos a kāna, “Naitolas do Masantwan a Tolas a, ‘Pagdayawan mo si Āpo a Dyos mo, kan iya lang pagsirbyan mo.’” ");
INSERT INTO ivb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Katayokan nawri, pinalongo ni Satanas kan pinaytēnek na si Jesos do katotohosanaw a yanan do Timplo do Jerosalem, as kabata na sya di Jesos a kāna, “An oyod a imo Anak no Dyos, gomtos ka pa dya, ");
INSERT INTO ivb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ta nawryaw batan Masantwan a Tolas: ‘Mandaran sanchi no Dyos anghilis na saw a omaywan dyimo.’ ");
INSERT INTO ivb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Asa pa, ‘Siranchiw mangigpet dyimo tan dyi sa madonggyaran bato kokod mwaya.’” ");
INSERT INTO ivb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","“Naon” tinbay ni Jesos a kāna, “ki binata na pa do Masantwan a Tolas a, ‘Sooten mwabaw Āpo a Dyos mo.’” ");
INSERT INTO ivb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Do nakapatawos danaw a tabo no maparinaw ni Satanas a isoōt di Jesos, kinarwan na pa a mandanchan myan maganay a gondaway na. ");
INSERT INTO ivb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Do dawri, naybidi si Jesos do probinsya a Galilya, kan myan dyaw panakabalin no Ispirito Santo, kan nagwaras danaw dāmag a maynamot dya do intīro a yanan do Galilya. ");
INSERT INTO ivb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nangnanawo do sinagoga da saw no Jodyo, kan indaydāyaw da no tabo tawotawo saw. ");
INSERT INTO ivb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Do dawri, nawara si Jesos do Nasaret do idyaw a nayrakorakohan na. Sigon do dadakay na do Arawaw a Kapaynaynahah, ki somindep si Jesos do sinagoga daw daw, as kan naytēnek a nangbāsa so Masantwan a Tolas. ");
INSERT INTO ivb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Inparawat da dyaw nahonaw a libro a intolas ni propīta Isayas. Binolay na, as kan nakachichwas na so naitolasaw a kāna, ");
INSERT INTO ivb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Myan dyaken Ispirito no Dyos, ta pinidi na yaken a mangikasaba so Maganay a Dāmag dyirad mapopobri. Tinoboy na yaken a mangibahey so kapakakaro dan nabahod, kan kapakaboya dan bolsek, kan kapanoroh so kalibryan dyirad malidyatan, ");
INSERT INTO ivb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","as kan kapangibahey ko so chimpo a kapangisalakan Āpo Dyos so tawotawo na.” ");
INSERT INTO ivb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Do dawri, hinon Jesos pagbasāan naw, as nakapaybidi na syad mangay–aywanaw sya daw, as nakapaydisna na. Ki pinasyay dabaw mata dad Jesos no tabo myan saw do sinagogaw. ");
INSERT INTO ivb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Binata na dyira a kāna, “Sichangori a araw, natongpal danaw nyaya a nadngey nyo do Masantwan a Tolas.” ");
INSERT INTO ivb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Do nakatayoka naw a naychirin, dinaydāyaw dan tabo tawotawo, kan nasnasdaaw sa do makadadaw saw a chinirichirin na. Ki alit na binatabata da a kon da, “Samna! Iyabawriw nyaw barwaw ni Jose?” ");
INSERT INTO ivb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Do dawri, binata ni Jesos dyira a kāna, “Sigorado ko a ibahey nyo dyaken nyaya panyinyirin a kon nyo, ‘Doktor, sigi, pyahen mo paw inawan mo!’ As chakey nyo pa batahen, ki ‘On, parinen mo pad bokod mwaya idi iyaw akmas nadngey namenaw a pinarin mo do Kapernaom.’ ");
INSERT INTO ivb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ki ibahey ko dyinyo oyod a abaw propīta no Dyos a mapadayawan do bokod na idi. ");
INSERT INTO ivb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Adngeyen nyo nyaya, ta oyod. Do chimpwaw ni Elyas do Israel, myan rakkoh a kapaychapteng do intīrwaw a tanatana do dyi naw a nakachimoyan do tatdo kan godwa a katawen, kan aro saw bālo do dawri. ");
INSERT INTO ivb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ki aran komwan, tinoboy aban Āpo Dyos si Elyas do aro saw daw, basbāli a nawriw nanoboyan na syaw asaw lang a bālo do idi a Serepta do tana a Sidon. ");
INSERT INTO ivb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","As aro saw nagliproso do Israel do chimpwaw ni propīta Eliseo, ki abaw napyan dyira, malaksid di Naaman a taga Sirya.” ");
INSERT INTO ivb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ki do dawri, oltimo a kasoli dan tabo tawotawo do sinagoga do nakadngey daw so nawri a binatan Jesos. ");
INSERT INTO ivb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nyeng sa naytēnek, as nakagoygoyod das Jesos a inihtot do dawri a idi, kan inyangay dad talapawaw no tokon a nakapatnekan syodad daw, ta chakey da asdayen daw. ");
INSERT INTO ivb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ki tod a nyiknyinan a nayhawohawos si Jesos do payapayawan daw, as nakayam na. ");
INSERT INTO ivb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Sinpangan na, minosok si Jesos do Kapernaom a asa idi do Galilya. As do Arawaw a Kapaynaynahah, nangay do sinagoga daw a nangnanawo siras tawotawo saw daw. ");
INSERT INTO ivb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Chinasdaaw da tabo do kapangnanawo naw maynamot ta malawag a myan toray na sigon do kapaychiychirin naw. ");
INSERT INTO ivb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ki do irahemaw no nawri a sinagoga, myan asa mahakay a linoganan marahet a ispirito, kan nangagay so malyak a kāna, ");
INSERT INTO ivb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ayya! Anghen mo yamen, mo Jesos a taga Nasaret? Yangay mori yamen a rarayawen? Taywaran dyi namen imo a chapapatak? Imo abawriw Masantwanaw a tinoboy no Dyos?” ");
INSERT INTO ivb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ki pinaydabdab ni Jesos marahetaw a ispirito, as nakaibahey na sya dya a kāna, “Magolimek ka, kan komaro ka do dawri a tawo!” Sinpangan na, pinaydipodiporis no marahetaw a ispirito mahakayaw do salapen daw, as nakakaro na sya, kan pinaynyinan naba. ");
INSERT INTO ivb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Chinasdaaw da tabo no tawotawowaw nawri a pinarin Jesos, kan binatabata da do katakatayisa dyira a kon da, “O! Āngo paro nyaya chirin? Myanayas toray kan panakabalin a magmandar siras marahet saya a ispirito, as kan komaro sa!” ");
INSERT INTO ivb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nagwaras do dawri a idi kan tabo do omdibonaw iyaw dāmagaya a maynamot di Jesos. ");
INSERT INTO ivb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Sinpangan na, komnaros Jesos do dawri a sinagoga, as nakangay nad bahay ni Simon Pedro. Ki myan do dawri iyaw mabakesaw a katogangan ni Simon a palalo so kapagbāra. Dawa, chindaw dad Jesos a sidongan na. ");
INSERT INTO ivb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Do dawri, naytēnek si Jesos do katalinaw no mabakesaw, as nakaimandar na sya komaro kapagbāra naw, ki nyeng na binawan. Insigīda naybangon, kan nakangay dana nangidasar so kanen da. ");
INSERT INTO ivb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Do kasdep danaw no araw, inyangay da san tawotawowaw maychagaganyit saw a matatarek so ganyit di Jesos, kan pinalapaw naw tanoro naw do katakatayisa dyira, ki napyan sa a tabo. ");
INSERT INTO ivb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Do dawri, pinaksyat na paw marahet saw a ispirito a somindep dyirad aro saw a tawotawo, kan ingengengey dan marahet saw a ispirito do kakaro daw nya a kon da, “Imo, Anakaw no Dyos!” Ki pinaydabdab san Jesos, kan palobosan na saba a maychirin, ta sigod darana chapatak a iya, ki si Kristo. ");
INSERT INTO ivb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Do kapaysesedang naranaw, komnaro si Jesos, kan nangay do kabwan naw no matawotawo a logar. Ki siraw tawotawo saw, ki nangay da a chinichwas, as kan do nakaboya daw sya, pinadas da a pagpegpeten tan nāw narana dyira. ");
INSERT INTO ivb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ki binata na dyira a kāna, “Machita ko a ikasabaw Maganayaya a Dāmag a maynamot do pagtorayanayan Āpo Dyos do kadwan pa saya a idiidi, ta nawriw nanoboyan dyaken no Dyos.” ");
INSERT INTO ivb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Dawa, nangay si Jesos a nangasaba do sinagoga da saw do intīro a probinsya a Jodya. ");
INSERT INTO ivb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Do naypisaw a kayan ni Jesos a naytēnek do payisaw no Minanga a Genesaret a mangnanawo, naysinpapadoydoy saw tawotawowaw a maypasngen dya, ta chakey daw mangadngey so chirin no Dyos. ");
INSERT INTO ivb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Do dawri, naboya ni Jesos dadwaw a abang a naigwarni dana, as nakagchin dana saw magkalkalapaw a nangay a naylablab so sigay da. ");
INSERT INTO ivb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Sinakayan ni Jesos asaw a abang a dyira ni Simon, kan inyahes na dya a paydawden nas dēkey. Sinpangan na, naydisnas Jesos do abangaw, as nakainanawo na siras tawotawo saw daw. ");
INSERT INTO ivb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Do nakatayoka naw a nangnanawo, binata nad Simon a kāna, “Paydawden mo paw abangaya, kan ipakat nyo sigay nyo saya tan makakalap kamo.” ");
INSERT INTO ivb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ki initbay ni Simon dya a kāna, “Āpo, naychararakan naw a nakapakat sigay namenaya, ki polos! Ki maynamot ta ibahey mo, ayket, ipakat namen a mirwaw sigay saya.” ");
INSERT INTO ivb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Do nakaipakat daranaw so sigay da saw, nakalikmot sa so pangen dan among, kan kāpipirit danan sigay daw saw do kāron nahap da. ");
INSERT INTO ivb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Dawa, sininyasan da saw rarayay da saw do matarekaw a abang a mangay a machisidong. Ki nangay sa, kan inapno daw dadwa saw a abang da, kan makalo dana sa dadwa a omned. ");
INSERT INTO ivb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Do nakaboyaw ni Simon Pedro so naparinaw, naydogod do salapenaw ni Jesos, as nakabata na sya a kāna, “Āpo, pachibawan mo yaken, ta asa kwa aros gatos!” ");
INSERT INTO ivb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Nabatan Pedro nawri maynamot ta oltimo a nasnasdaawan sa kan siraw tabo rarayay naw do kārwaw no nahap da among. ");
INSERT INTO ivb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Aran siraw rarayayaw ni Simon a sa Santiago kan Juan a pōtot ni Sebedeo, ki nasdaaw pa sa. Sinpangan na, binatan Jesos di Simon, “Mamo kabam Simon, ta mangrogi sichangori, tawo danaw kalāpen mo.” ");
INSERT INTO ivb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ki do nakapakaraya daranaw so abang da saw, kinarwan da tabo, as nakawnot dad Jesos. ");
INSERT INTO ivb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Do naypisa do kayanaw ni Jesos do asaw a idi, myan omnasngen dya a asa mahakay a nahapot dana so liproso. Ki do nakaboya naw si Jesos, naydogod a naysasakeb a nachikakaāsi dya a kāna, “Āpo, an chakey mo a mapyan ako, masigorādo ko a maparin mo.” ");
INSERT INTO ivb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ki tinodah ni Jesos tatchay naw a sinalid, as nakabata na sya dya a kāna, “Naon, chakey ko. Mapyan ka na!” Ki nanyeng a nabo ganyit naw a liproso. ");
INSERT INTO ivb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Sinpangan na, inmandar ni Jesos dya a kāna, “Ibahebahey mwabaw nya naparin dyimo do aran sino ah, basbāli a nyeng ka mangay a mapaboyad padyaw tan sakangwan maboya na a napyan ka na. As katayoka no nawri, mangidāton ka a para do nakapakadalos mo a akmas inbilinaw ni Moyses do kaychowa pa a pangipaneknek mo do tawotawo a napyan ka na.” ");
INSERT INTO ivb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ki naypaypangay a nagwaras iyaw dāmag a maynamot di Jesos. Dawa, nayparo saw nangay a nangadngey kan tan mapyan sa do ganyit da saw. ");
INSERT INTO ivb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ki maynamot di Jesos, ki nasanyib a nachibawa a nangay do kabwan naw no matawotawo a logar a maydasal. ");
INSERT INTO ivb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Do asaw a karaw do kayan ni Jesos a nangnanawo, myan saw Parisyo kan siraw mangnanawo so linteg a maydisna do dawri. Yapo sa do kāda idi do probinsya saw a Galilya kan Jodya as kan yapo pa do Jerosalem. Myan di Jesos panakabalin a mangpapya siras maganyitaw. ");
INSERT INTO ivb_vpl VA