﻿USE sofia;
DROP TABLE IF EXISTS sofia.ita1927_vpl;
CREATE TABLE ita1927_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ita1927_vpl WRITE;
INSERT INTO ita1927_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Nel principio Iddio creò i cieli e la terra. ");
INSERT INTO ita1927_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","E la terra era informe e vuota, e le tenebre coprivano la faccia dell’abisso, e lo spirito di Dio aleggiava sulla superficie delle acque. E Dio disse: ");
INSERT INTO ita1927_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","“Sia la luce!” E la luce fu. ");
INSERT INTO ita1927_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","E Dio vide che la luce era buona; e Dio separò la luce dalle tenebre. ");
INSERT INTO ita1927_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","E Dio chiamò la luce “giorno”, e le tenebre “notte”. Così fu sera, poi fu mattina: e fu il primo giorno. ");
INSERT INTO ita1927_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Poi Dio disse: “Ci sia una distesa tra le acque, che separi le acque dalle acque”. ");
INSERT INTO ita1927_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","E Dio fece la distesa e separò le acque ch’erano sotto la distesa, dalle acque ch’erano sopra la distesa. E così fu. ");
INSERT INTO ita1927_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","E Dio chiamò la distesa “cielo”. Così fu sera, poi fu mattina: e fu il secondo giorno. ");
INSERT INTO ita1927_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Poi Dio disse: “Le acque che son sotto il cielo siano raccolte in un unico luogo, e apparisca l’asciutto”. E così fu. ");
INSERT INTO ita1927_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","E Dio chiamò l’asciutto “terra”, e chiamò la raccolta delle acque “mari”. E Dio vide che questo era buono. ");
INSERT INTO ita1927_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Poi Dio disse: “Produca la terra della verdura, dell’erbe che faccian seme e degli alberi fruttiferi che, secondo la loro specie, portino del frutto avente in sé la propria semenza, sulla terra”. E così fu. ");
INSERT INTO ita1927_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","E la terra produsse della verdura, dell’erbe che facevan seme secondo la loro specie, e degli alberi che portavano del frutto avente in sé la propria semenza, secondo la loro specie. E Dio vide che questo era buono. ");
INSERT INTO ita1927_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Così fu sera, poi fu mattina: e fu il terzo giorno. ");
INSERT INTO ita1927_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Poi Dio disse: “Sianvi de’ luminari nella distesa dei cieli per separare il giorno dalla notte; e siano dei segni e per le stagioni e per i giorni e per gli anni; ");
INSERT INTO ita1927_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","e servano da luminari nella distesa dei cieli per dar luce alla terra”. E così fu. ");
INSERT INTO ita1927_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","E Dio fece i due grandi luminari: il luminare maggiore, per presiedere al giorno, e il luminare minore per presiedere alla notte; e fece pure le stelle. ");
INSERT INTO ita1927_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","E Dio li mise nella distesa dei cieli per dar luce alla terra, ");
INSERT INTO ita1927_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","per presiedere al giorno e alla notte e separare la luce dalle tenebre. E Dio vide che questo era buono. ");
INSERT INTO ita1927_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Così fu sera, poi fu mattina: e fu il quarto giorno. ");
INSERT INTO ita1927_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Poi Dio disse: “Producano le acque in abbondanza animali viventi, e volino degli uccelli sopra la terra per l’ampia distesa del cielo”. ");
INSERT INTO ita1927_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","E Dio creò i grandi animali acquatici e tutti gli esseri viventi che si muovono, i quali le acque produssero in abbondanza secondo la loro specie, ed ogni volatilo secondo la sua specie. E Dio vide che questo era buono. ");
INSERT INTO ita1927_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","E Dio li benedisse, dicendo: “Crescete, moltiplicate, ed empite le acque dei mari, e moltiplichino gli uccelli sulla terra”. ");
INSERT INTO ita1927_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Così fu sera, poi fu mattina: e fu il quinto giorno. ");
INSERT INTO ita1927_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Poi Dio disse: “Produca la terra animali viventi secondo la loro specie: bestiame, rettili e animali selvatici della terra, secondo la loro specie”. E così fu. ");
INSERT INTO ita1927_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","E Dio fece gli animali selvatici della terra, secondo le loro specie, il bestiame secondo le sue specie, e tutti i rettili della terra, secondo le loro specie. E Dio vide che questo era buono. ");
INSERT INTO ita1927_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Poi Dio disse: “Facciamo l’uomo a nostra immagine e a nostra somiglianza, ed abbia dominio sui pesci del mare e sugli uccelli del cielo e sul bestiame e su tutta la terra e su tutti i rettili che strisciano sulla terra”. ");
INSERT INTO ita1927_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","E Dio creò l’uomo a sua immagine; lo creò a immagine di Dio; li creò maschio e femmina. ");
INSERT INTO ita1927_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","E Dio li benedisse; e Dio disse loro: “Crescete e moltiplicate e riempite la terra, e rendetevela soggetta, e dominate sui pesci del mare e sugli uccelli del cielo e sopra ogni animale che si muove sulla terra”. ");
INSERT INTO ita1927_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","E Dio disse: “Ecco, io vi do ogni erba che fa seme sulla superficie di tutta la terra, ed ogni albero fruttifero che fa seme; questo vi servirà di nutrimento. ");
INSERT INTO ita1927_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","E ad ogni animale della terra e ad ogni uccello dei cieli e a tutto ciò che si muove sulla terra ed ha in sé un soffio di vita, io do ogni erba verde per nutrimento”. E così fu. ");
INSERT INTO ita1927_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","E Dio vide tutto quello che aveva fatto, ed ecco, era molto buono. Così fu sera, poi fu mattina: e fu il sesto giorno. ");
INSERT INTO ita1927_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Così furono compiti i cieli e la terra e tutto l’esercito loro. ");
INSERT INTO ita1927_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Il settimo giorno, Iddio compì l’opera che aveva fatta, e si riposò il settimo giorno da tutta l’opera che aveva fatta. ");
INSERT INTO ita1927_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","E Dio benedisse il settimo giorno e lo santificò, perché in esso si riposò da tutta l’opera che aveva creata e fatta. ");
INSERT INTO ita1927_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Queste sono le origini dei cieli e della terra quando furono creati, nel giorno che l’Eterno Iddio fece la terra e i cieli. ");
INSERT INTO ita1927_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Non c’era ancora sulla terra alcun arbusto della campagna, e nessuna erba della campagna era ancora spuntata, perché l’Eterno Iddio non avea fatto piovere sulla terra, e non c’era alcun uomo per coltivare il suolo; ");
INSERT INTO ita1927_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ma un vapore saliva dalla terra e adacquava tutta la superficie del suolo. ");
INSERT INTO ita1927_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","E l’Eterno Iddio formò l’uomo dalla polvere della terra, gli soffiò nelle narici un alito vitale, e l’uomo divenne un’anima vivente. ");
INSERT INTO ita1927_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","E l’Eterno Iddio piantò un giardino in Eden, in oriente, e quivi pose l’uomo che aveva formato. ");
INSERT INTO ita1927_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","E l’Eterno Iddio fece spuntare dal suolo ogni sorta d’alberi piacevoli a vedersi e il cui frutto era buono da mangiare, e l’albero della vita in mezzo al giardino, e l’albero della conoscenza del bene e del male. ");
INSERT INTO ita1927_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","E un fiume usciva d’Eden per adacquare il giardino, e di la si spartiva in quattro bracci. ");
INSERT INTO ita1927_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Il nome del primo è Pishon, ed è quello che circonda tutto il paese di Havila, dov’è l’oro; ");
INSERT INTO ita1927_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","e l’oro di quel paese è buono; quivi si trovan pure il bdellio e l’onice. ");
INSERT INTO ita1927_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Il nome del secondo fiume è Ghihon, ed è quello che circonda tutto il paese di Cush. ");
INSERT INTO ita1927_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Il nome del terzo fiume è Hiddekel, ed è quello che scorre a oriente dell’Assiria. E il quarto fiume è l’Eufrate. ");
INSERT INTO ita1927_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","L’Eterno Iddio prese dunque l’uomo e lo pose nel giardino d’Eden perché lo lavorasse e lo custodisse. ");
INSERT INTO ita1927_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","E l’Eterno Iddio diede all’uomo questo comandamento: “Mangia pure liberamente del frutto d’ogni albero del giardino; ");
INSERT INTO ita1927_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ma del frutto dell’albero della conoscenza del bene e del male non ne mangiare; perché, nel giorno che tu ne mangerai, per certo morrai”. ");
INSERT INTO ita1927_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Poi l’Eterno Iddio disse: “Non è bene che l’uomo sia solo; io gli farò un aiuto che gli sia convenevole”. ");
INSERT INTO ita1927_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","E l’Eterno Iddio avendo formato dalla terra tutti gli animali dei campi e tutti gli uccelli dei cieli, li menò all’uomo per vedere come li chiamerebbe, e perché ogni essere vivente portasse il nome che l’uomo gli darebbe. ");
INSERT INTO ita1927_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","E l’uomo dette de’ nomi a tutto il bestiame, agli uccelli dei cieli e ad ogni animale dei campi; ma per l’uomo non si trovò aiuto che gli fosse convenevole. ");
INSERT INTO ita1927_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Allora l’Eterno Iddio fece cadere un profondo sonno sull’uomo, che s’addormentò; e prese una delle costole di lui, e richiuse la carne al posto d’essa. ");
INSERT INTO ita1927_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","E l’Eterno Iddio, con la costola che avea tolta all’uomo, formò una donna e la menò all’uomo. ");
INSERT INTO ita1927_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","E l’uomo disse: “Questa, finalmente, è ossa delle mie ossa e carne della mia carne. Ella sarà chiamata donna perché è stata tratta dall’uomo”. ");
INSERT INTO ita1927_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Perciò l’uomo lascerà suo padre e sua madre e si unirà alla sua moglie, e saranno una stessa carne. ");
INSERT INTO ita1927_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","E l’uomo e la sua moglie erano ambedue ignudi e non ne aveano vergogna. ");
INSERT INTO ita1927_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Or il serpente era il più astuto di tutti gli animali dei campi che l’Eterno Iddio aveva fatti; ed esso disse alla donna: “Come! Iddio v’ha detto: Non mangiate del frutto di tutti gli alberi del giardino?” ");
INSERT INTO ita1927_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","E la donna rispose al serpente: “Del frutto degli alberi del giardino ne possiamo mangiare; ");
INSERT INTO ita1927_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ma del frutto dell’albero ch’è in mezzo al giardino Iddio ha detto: Non ne mangiate e non lo toccate, che non abbiate a morire”. ");
INSERT INTO ita1927_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","E il serpente disse alla donna: “No, non morrete affatto; ");
INSERT INTO ita1927_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","ma Iddio sa che nel giorno che ne mangerete, gli occhi vostri s’apriranno, e sarete come Dio, avendo la conoscenza del bene e del male”. ");
INSERT INTO ita1927_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","E la donna vide che il frutto dell’albero era buono a mangiarsi, ch’era bello a vedere, e che l’albero era desiderabile per diventare intelligente; prese del frutto, ne mangiò, e ne dette anche al suo marito ch’era con lei, ed egli ne mangiò. ");
INSERT INTO ita1927_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Allora si apersero gli occhi ad ambedue, e s’accorsero ch’erano ignudi; e cucirono delle foglie di fico, e se ne fecero delle cinture. ");
INSERT INTO ita1927_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","E udirono la voce dell’Eterno Iddio il quale camminava nel giardino sul far della sera; e l’uomo e sua moglie si nascosero dalla presenza dell’Eterno Iddio, fra gli alberi del giardino. ");
INSERT INTO ita1927_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","E l’Eterno Iddio chiamò l’uomo e gli disse: “Dove sei?” E quegli rispose: ");
INSERT INTO ita1927_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","“Ho udito la tua voce nel giardino, e ho avuto paura, perch’ero ignudo, e mi sono nascosto”. ");
INSERT INTO ita1927_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","E Dio disse: “Chi t’ha mostrato ch’eri ignudo? Hai tu mangiato del frutto dell’albero del quale io t’avevo comandato di non mangiare?” ");
INSERT INTO ita1927_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","L’uomo rispose: “La donna che tu m’hai messa accanto, è lei che m’ha dato del frutto dell’albero, e io n’ho mangiato”. ");
INSERT INTO ita1927_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","E l’Eterno Iddio disse alla donna: “Perché hai fatto questo?” E la donna rispose: “Il serpente mi ha sedotta, ed io ne ho mangiato”. ");
INSERT INTO ita1927_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Allora l’Eterno Iddio disse al serpente: “Perché hai fatto questo, sii maledetto fra tutto il bestiame e fra tutti gli animali dei campi! Tu camminerai sul tuo ventre, e mangerai polvere tutti i giorni della tua vita. ");
INSERT INTO ita1927_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","E io porrò inimicizia fra te e la donna, e fra la tua progenie e la progenie di lei; questa progenie ti schiaccerà il capo, e tu le ferirai il calcagno”. ");
INSERT INTO ita1927_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Alla donna disse: “Io moltiplicherò grandemente le tue pene e i dolori della tua gravidanza; con dolore partorirai figliuoli; i tuoi desideri si volgeranno verso il tuo marito, ed egli dominerà su te”. ");
INSERT INTO ita1927_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","E ad Adamo disse: “Perché hai dato ascolto alla voce della tua moglie e hai mangiato del frutto dell’albero circa il quale io t’avevo dato quest’ordine: Non ne mangiare, il suolo sarà maledetto per causa tua; ne mangerai il frutto con affanno, tutti i giorni della tua vita. ");
INSERT INTO ita1927_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Esso ti produrrà spine e triboli, e tu mangerai l’erba dei campi. ");
INSERT INTO ita1927_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","mangerai il pane col sudore del tuo volto, finché tu ritorni nella terra donde fosti tratto; perché sei polvere, e in polvere ritornerai”. ");
INSERT INTO ita1927_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","E l’uomo pose nome Eva alla sua moglie, perch’è stata la madre di tutti i viventi. ");
INSERT INTO ita1927_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","E l’Eterno Iddio fece ad Adamo e alla sua moglie delle tuniche di pelle, e li vestì. ");
INSERT INTO ita1927_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Poi l’Eterno Iddio disse: “Ecco, l’uomo è diventato come uno di noi quanto a conoscenza del bene e dei male. Guardiamo ch’egli non stenda la mano e prenda anche del frutto dell’albero della vita, e ne mangi, e viva in perpetuo”. ");
INSERT INTO ita1927_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Perciò l’Eterno Iddio mandò via l’uomo dal giardino d’Eden, perché lavorasse la terra donde era stato tratto. ");
INSERT INTO ita1927_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Così egli scacciò l’uomo; e pose ad oriente del giardino d’Eden i cherubini, che vibravano da ogni parte una spada fiammeggiante, per custodire la via dell’albero della vita. ");
INSERT INTO ita1927_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Or Adamo conobbe Eva sua moglie, la quale concepì e partorì Caino, e disse: “Ho acquistato un uomo, con l’aiuto dell’Eterno”. ");
INSERT INTO ita1927_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Poi partorì ancora Abele, fratello di lui. E Abele fu pastore di pecore; e Caino, lavoratore della terra. ");
INSERT INTO ita1927_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","E avvenne, di li a qualche tempo, che Caino fece un offerta di frutti della terra all’Eterno; ");
INSERT INTO ita1927_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","e Abele offerse anch’egli dei primogeniti del suo gregge e del loro grasso. E l’Eterno guardò con favore Abele e la sua offerta, ");
INSERT INTO ita1927_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ma non guardò con favore Caino e l’offerta sua. E Caino ne fu molto irritato, e il suo viso ne fu abbattuto. ");
INSERT INTO ita1927_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","E l’Eterno disse a Caino: “Perché sei tu irritato? e perché hai il volto abbattuto? ");
INSERT INTO ita1927_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Se fai bene non rialzerai tu il volto? ma, se fai male, il peccato sta spiandoti alla porta, e i suoi desideri son vòlti a te; ma tu lo devi dominare!” ");
INSERT INTO ita1927_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","E Caino disse ad Abele suo fratello: “Usciamo fuori ai campi!” E avvenne che, quando furono nei campi, Caino si levò contro Abele suo fratello, e l’uccise. ");
INSERT INTO ita1927_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","E l’Eterno disse a Caino: “Dov’è Abele tuo fratello?” Ed egli rispose: “Non lo so; sono io forse il guardiano di mio fratello?” ");
INSERT INTO ita1927_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","E l’Eterno disse: “Che hai tu fatto? la voce del sangue di tuo fratello grida a me dalla terra. ");
INSERT INTO ita1927_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","E ora tu sarai maledetto, condannato ad errar lungi dalla terra che ha aperto la sua bocca per ricevere il sangue del tuo fratello dalla tua mano. ");
INSERT INTO ita1927_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Quando coltiverai il suolo, esso non ti darà più i suoi prodotti, e tu sarai vagabondo e fuggiasco sulla terra”. ");
INSERT INTO ita1927_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","E Caino disse all’Eterno: “Il mio castigo è troppo grande perch’io lo possa sopportare. ");
INSERT INTO ita1927_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ecco, tu mi scacci oggi dalla faccia di questo suolo, ed io sarò nascosto dal tuo cospetto, e sarò vagabondo e fuggiasco per la terra; e avverrà che chiunque mi troverà mi ucciderà”. ");
INSERT INTO ita1927_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","E l’Eterno gli disse: “Perciò, chiunque ucciderà Caino, sarà punito sette volte più di lui”. E l’Eterno mise un segno su Caino, affinché nessuno, trovandolo, l’uccidesse. ");
INSERT INTO ita1927_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","E Caino si partì dal cospetto dell’Eterno e dimorò nel paese di Nod, ad oriente di Eden. ");
INSERT INTO ita1927_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","E Caino conobbe la sua moglie, la quale concepì e partorì Enoc. Poi si mise a edificare una città, a cui diede il nome di Enoc, dal nome del suo figliuolo. ");
INSERT INTO ita1927_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","E ad Enoc nacque Irad; Irad generò Mehujael; Mehujael generò Methushael, e Methushael generò Lamec. ");
INSERT INTO ita1927_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","E Lamec prese due mogli: il nome dell’una era Ada, e il nome dell’altra, Zilla. ");
INSERT INTO ita1927_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","E Ada partorì Jabal, che fu il padre di quelli che abitano sotto le tende presso i greggi. ");
INSERT INTO ita1927_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","E il nome del suo fratello era Jubal, che fu il padre di tutti quelli che suonano la cetra ed il flauto. ");
INSERT INTO ita1927_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","E Zilla partorì anch’essa Tubal-cain, l’artefice d’ogni sorta di strumenti di rame e di ferro, e la sorella di Tubal-cain fu Naama. ");
INSERT INTO ita1927_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","E Lamec disse alle sue mogli: “Ada e Zilla, ascoltate la mia voce; mogli di Lamec, porgete orecchio ai mio dire! Sì, io ho ucciso un uomo perché m’ha ferito, e un giovine perché m’ha contuso. ");
INSERT INTO ita1927_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Se Caino sarà vendicato sette volte, Lamec lo sarà settantasette volte”. ");
INSERT INTO ita1927_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","E Adamo conobbe ancora la sua moglie, ed essa partorì un figliuolo, a cui pose nome Seth, “perché” ella disse, “Iddio m’ha dato un altro figliuolo al posto d’Abele, che Caino ha ucciso”. ");
INSERT INTO ita1927_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","E anche a Seth nacque un figliuolo, a cui pose nome Enosh. Allora si cominciò a invocare il nome dell’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Questo è il libro della posterità d’Adamo. Nel giorno che Dio creò l’uomo, lo fece a somiglianza di Dio; ");
INSERT INTO ita1927_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","li creò maschio e femmina, li benedisse e dette loro il nome di “uomo”, nel giorno che furon creati. ");
INSERT INTO ita1927_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adamo visse centotrent’anni, generò un figliuolo, a sua somiglianza, conforme alla sua immagine, e gli pose nome Seth; ");
INSERT INTO ita1927_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","e il tempo che Adamo visse, dopo ch’ebbe generato Seth, fu ottocento anni, e generò figliuoli e figliuole; ");
INSERT INTO ita1927_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","e tutto il tempo che Adamo visse fu novecentotrenta anni; poi morì. ");
INSERT INTO ita1927_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","E Seth visse centocinque anni, e generò Enosh. ");
INSERT INTO ita1927_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","E Seth, dopo ch’ebbe generato Enosh, visse ottocentosette anni, e generò figliuoli e figliuole; ");
INSERT INTO ita1927_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","e tutto il tempo che Seth visse fu novecentododici anni; poi morì. ");
INSERT INTO ita1927_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ed Enosh visse novant’anni, e generò Kenan. ");
INSERT INTO ita1927_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ed Enosh, dopo ch’ebbe generato Kenan, visse ottocentoquindici anni, e generò figliuoli e figliuole; ");
INSERT INTO ita1927_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","e tutto il tempo che Enosh visse fu novecentocinque anni; poi morì. ");
INSERT INTO ita1927_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","E Kenan visse settant’anni, e generò Mahalaleel. ");
INSERT INTO ita1927_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","E Kenan, dopo ch’ebbe generato Mahalaleel, visse ottocentoquaranta anni, e generò figliuoli e figliuole; ");
INSERT INTO ita1927_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","e tutto il tempo che Kenan visse fu novecentodieci anni; poi morì. ");
INSERT INTO ita1927_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","E Mahalaleel visse sessantacinque anni, e generò Jared. ");
INSERT INTO ita1927_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","E Mahalaleel, dopo ch’ebbe generato Jared, visse ottocentotrenta anni, e generò figliuoli e figliuole; ");
INSERT INTO ita1927_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","e tutto il tempo che Mahalaleel visse fu ottocento novantacinque anni; poi morì. ");
INSERT INTO ita1927_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","E Jared visse cento sessantadue anni, e generò Enoc. ");
INSERT INTO ita1927_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","E Jared, dopo ch’ebbe generato Enoc, visse ottocento anni, e generò figliuoli e figliuole; ");
INSERT INTO ita1927_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","e tutto il tempo che Jared visse fu novecento sessantadue anni; poi morì. ");
INSERT INTO ita1927_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ed Enoc visse sessantacinque anni, e generò Methushelah. ");
INSERT INTO ita1927_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Ed Enoc, dopo ch’ebbe generato Methushelah, camminò con Dio trecento anni, e generò figliuoli e figliuole; ");
INSERT INTO ita1927_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","e tutto il tempo che Enoc visse fu trecento sessantacinque anni. ");
INSERT INTO ita1927_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Ed Enoc camminò con Dio; poi disparve, perché Iddio lo prese. ");
INSERT INTO ita1927_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","E Methushelah visse cento ottantasette anni e generò Lamec. ");
INSERT INTO ita1927_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","E Methushelah, dopo ch’ebbe generato Lamec, visse settecento ottantadue anni, e generò figliuoli e figliuole; ");
INSERT INTO ita1927_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","e tutto il tempo che Methushelah visse fu novecento sessantanove anni; poi morì. ");
INSERT INTO ita1927_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","E Lamec visse cento ottantadue anni, e generò un figliuolo; ");
INSERT INTO ita1927_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","e gli pose nome Noè, dicendo: “Questo ci consolerà della nostra opera e della fatica delle nostre mani cagionata dal suolo che l’Eterno ha maledetto”. ");
INSERT INTO ita1927_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","E Lamec, dopo ch’ebbe generato Noè, visse cinquecento novantacinque anni, e generò figliuoli e figliuole; ");
INSERT INTO ita1927_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","e tutto il tempo che Lamec visse fu settecento settantasette anni; poi morì. ");
INSERT INTO ita1927_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","E Noè, all’età di cinquecento anni, generò Sem, Cam e Jafet. ");
INSERT INTO ita1927_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Or quando gli uomini cominciarono a moltiplicare sulla faccia della terra e furon loro nate delle figliuole, ");
INSERT INTO ita1927_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","avvenne che i figliuoli di Dio videro che le figliuole degli uomini erano belle, e presero per mogli quelle che si scelsero fra tutte. ");
INSERT INTO ita1927_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","E l’Eterno disse: “Lo spirito mio non contenderà per sempre con l’uomo; poiché, nel suo traviamento, egli non è che carne; i suoni giorni saranno quindi centoventi anni”. ");
INSERT INTO ita1927_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","In quel tempo c’erano sulla terra i giganti, e ci furono anche di poi, quando i figliuoli di Dio si accostarono alle figliuole degli uomini, e queste fecero loro de’ figliuoli. Essi sono gli uomini potenti che, fin dai tempi antichi, sono stati famosi. ");
INSERT INTO ita1927_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","E l’Eterno vide che la malvagità degli uomini era grande sulla terra, e che tutti i disegni dei pensieri del loro cuore non erano altro che male in ogni tempo. ");
INSERT INTO ita1927_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","E l’Eterno si pentì d’aver fatto l’uomo sulla terra, e se ne addolorò in cuor suo. ");
INSERT INTO ita1927_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","E l’Eterno disse: “Io sterminerò di sulla faccia della terra l’uomo che ho creato: dall’uomo al bestiame, ai rettili, agli uccelli dei cieli; perché mi pento d’averli fatti”. ");
INSERT INTO ita1927_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ma Noè trovò grazia agli occhi dell’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Questa è la posterità di Noè. Noè fu uomo giusto, integro, ai suoi tempi; Noè camminò con Dio. ");
INSERT INTO ita1927_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","E Noè generò tre figliuoli: Sem, Cam e Jafet. ");
INSERT INTO ita1927_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Or la terra era corrotta davanti a Dio; la terra era ripiena di violenza. ");
INSERT INTO ita1927_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","E Dio guardò la terra; ed ecco, era corrotta, poiché ogni carne avea corrotto la sua via sulla terra. ");
INSERT INTO ita1927_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","E Dio disse a Noè: “Nei miei decreti, la fine d’ogni carne è giunta; poiché la terra, per opera degli uomini, è piena di violenza; ecco, io li distruggerò, insieme con la terra. ");
INSERT INTO ita1927_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Fatti un’arca di legno di gofer; falla a stanze, e spalmala di pece, di dentro e di fuori. ");
INSERT INTO ita1927_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ed ecco come la dovrai fare: la lunghezza dell’arca sarà di trecento cubiti; la larghezza, di cinquanta cubiti, e l’altezza, di trenta cubiti. ");
INSERT INTO ita1927_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Farai all’arca una finestra, in alto, e le darai la dimensione d’un cubito; metterai la porta da un lato, e farai l’arca a tre piani: uno da basso, un secondo e un terzo piano. ");
INSERT INTO ita1927_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ed ecco, io sto per far venire il diluvio delle acque sulla terra, per distruggere di sotto i cieli ogni carne in cui è alito di vita; tutto quello ch’è sopra la terra, morrà. ");
INSERT INTO ita1927_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ma io stabilirò il mio patto con te; e tu entrerai nell’arca: tu e i tuoi figliuoli, la tua moglie e le mogli de’ tuoi figliuoli con te. ");
INSERT INTO ita1927_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","E di tutto ciò che vive, d’ogni carne, fanne entrare nell’arca due d’ogni specie, per conservarli in vita con te; e siano maschio e femmina. ");
INSERT INTO ita1927_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Degli uccelli secondo le loro specie del bestiame secondo le sue specie, e di tutti i rettili della terra secondo le loro specie, due d’ogni specie verranno a te, perché tu li conservi in vita. ");
INSERT INTO ita1927_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","E tu prenditi d’ogni cibo che si mangia, e fattene provvista, perché serva di nutrimento a te e a loro”. ");
INSERT INTO ita1927_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","E Noè fece così; fece tutto quello che Dio gli avea comandato. ");
INSERT INTO ita1927_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","E l’Eterno disse a Noè: “Entra nell’arca tu con tutta la tua famiglia, poiché t’ho veduto giusto nel mio cospetto, in questa generazione. ");
INSERT INTO ita1927_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","D’ogni specie di animali puri prendine sette paia, maschio e femmina; e degli animali impuri un paio, maschio e femmina; ");
INSERT INTO ita1927_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","e parimente degli uccelli dei cieli prendine sette paia, maschio e femmina, per conservarne in vita la razza sulla faccia di tutta la terra; ");
INSERT INTO ita1927_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","poiché di qui a sette giorni farò piovere sulla terra per quaranta giorni e quaranta notti, e sterminerò di sulla faccia della terra tutti gli esseri viventi che ho fatto”. ");
INSERT INTO ita1927_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","E Noè fece tutto quello che l’Eterno gli avea comandato. ");
INSERT INTO ita1927_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noè era in età di seicento anni, quando il diluvio delle acque inondò la terra. ");
INSERT INTO ita1927_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","E Noè, coi suoi figliuoli, con la sua moglie e con le mogli de’ suoi figliuoli, entrò nell’arca per scampare dalle acque del diluvio. ");
INSERT INTO ita1927_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Degli animali puri e degli animali impuri, degli uccelli e di tutto quello che striscia sulla terra, ");
INSERT INTO ita1927_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","vennero delle coppie, maschio e femmina, a Noè nell’arca, come Dio avea comandato a Noè. ");
INSERT INTO ita1927_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","E, al termine dei sette giorni, avvenne che le acque del diluvio furono sulla terra. ");
INSERT INTO ita1927_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","L’anno seicentesimo della vita di Noè, il secondo mese, il diciassettesimo giorno del mese, in quel giorno, tutte le fonti del grande abisso scoppiarono e le cateratte del cielo s’aprirono. ");
INSERT INTO ita1927_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","E piovve sulla terra per quaranta giorni e quaranta notti. ");
INSERT INTO ita1927_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","In quello stesso giorno, Noè, Sem, Cam e Jafet, figliuoli di Noè, la moglie di Noè e le tre mogli dei suoi figliuoli con loro, entrarono nell’arca: ");
INSERT INTO ita1927_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","essi, e tutti gli animali secondo le loro specie, e tutto il bestiame secondo le sue specie, e tutti i rettili che strisciano sulla terra, secondo le loro specie, e tutti gli uccelli secondo le loro specie, tutti gli uccelletti, tutto quel che porta ali. ");
INSERT INTO ita1927_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","D’ogni carne in cui è alito di vita venne una coppia a Noè nell’arca: ");
INSERT INTO ita1927_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","venivano maschio e femmina d’ogni carne, come Dio avea comandato a Noè; poi l’Eterno lo chiuse dentro l’arca. ");
INSERT INTO ita1927_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","E il diluvio venne sopra la terra per quaranta giorni; e le acque crebbero e sollevarono l’arca, che fu levata in alto d’in su la terra. ");
INSERT INTO ita1927_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","E le acque ingrossarono e crebbero grandemente sopra la terra, e l’arca galleggiava sulla superficie delle acque. ");
INSERT INTO ita1927_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","E le acque ingrossarono oltremodo sopra la terra; e tutte le alte montagne che erano sotto tutti i cieli, furon coperte. ");
INSERT INTO ita1927_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Le acque salirono quindici cubiti al disopra delle vette dei monti; e le montagne furon coperte. ");
INSERT INTO ita1927_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","E perì ogni carne che si moveva sulla terra: uccelli, bestiame, animali salvatici, rettili d’ogni sorta striscianti sulla terra, e tutti gli uomini. ");
INSERT INTO ita1927_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Tutto quello ch’era sulla terra asciutta ed aveva alito di vita nelle sue narici, morì. ");
INSERT INTO ita1927_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","E tutti gli esseri che erano sulla faccia della terra furono sterminati: dall’uomo fino al bestiame, ai rettili e agli uccelli del cielo; furono sterminati di sulla terra; non scampò che Noè con quelli ch’eran con lui nell’arca. ");
INSERT INTO ita1927_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","E le acque rimasero alte sopra la terra per centocinquanta giorni. ");
INSERT INTO ita1927_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Or Iddio si ricordò di Noè, di tutti gli animali e di tutto il bestiame ch’era con lui nell’arca; e Dio fece passare un vento sulla terra, e le acque si calmarono; ");
INSERT INTO ita1927_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","le fonti dell’abisso e le cateratte del cielo furono chiuse, e cessò la pioggia dal cielo; ");
INSERT INTO ita1927_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","le acque andarono del continuo ritirandosi di sulla terra, e alla fine di centocinquanta giorni cominciarono a scemare. ");
INSERT INTO ita1927_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","E nel settimo mese, il decimosettimo giorno del mese, l’arca si fermò sulle montagne di Ararat. ");
INSERT INTO ita1927_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","E le acque andarono scemando fino al decimo mese. Nel decimo mese, il primo giorno del mese, apparvero le vette dei monti. ");
INSERT INTO ita1927_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","E in capo a quaranta giorni, Noè apri la finestra che avea fatta nell’arca, ");
INSERT INTO ita1927_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","e mandò fuori il corvo, il quale uscì, andando e tornando, finché le acque furono asciugate sulla terra. ");
INSERT INTO ita1927_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Poi mandò fuori la colomba, per vedere se le acque fossero diminuite sulla superficie della terra. ");
INSERT INTO ita1927_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ma la colomba non trovò dove posar la pianta del suo piede, e tornò a lui nell’arca, perché c’eran delle acque sulla superficie di tutta la terra; ed egli stese la mano, la prese, e la portò con sé dentro l’arca. ");
INSERT INTO ita1927_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","E aspettò altri sette giorni, poi mandò di nuovo la colomba fuori dell’arca. ");
INSERT INTO ita1927_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","E la colomba tornò a lui, verso sera; ed ecco, essa aveva nel becco una foglia fresca d’ulivo; onde Noè capì che le acque erano scemate sopra la terra. ");
INSERT INTO ita1927_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","E aspettò altri sette giorni, poi mandò fuori la colomba; ma essa non tornò più a lui. ");
INSERT INTO ita1927_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","L’anno secentesimoprimo di Noè, il primo mese, il primo giorno del mese, le acque erano asciugate sulla terra; e Noè scoperchiò l’arca, guardò, ed ecco che la superficie del suolo era asciutta. ");
INSERT INTO ita1927_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","E il secondo mese, il ventisettesimo giorno del mese, la terra era asciutta. ");
INSERT INTO ita1927_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","E Dio parlò a Noè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Esci dall’arca tu e la tua moglie, i tuoi figliuoli e le mogli dei tuoi figliuoli con te. ");
INSERT INTO ita1927_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Fa’ uscire con te tutti gli animali che sono teco, d’ogni carne: uccelli, bestiame, e tutti i rettili che strisciano sulla terra, perché abbondino sulla terra, e figlino e moltiplichino sulla terra”. ");
INSERT INTO ita1927_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","E Noè uscì con i suoi figliuoli, con la sua moglie, e con le mogli dei suoi figliuoli. ");
INSERT INTO ita1927_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Tutti gli animali, tutti i rettili, tutti gli uccelli, tutto quel che si muove sulla terra, secondo le loro famiglie, uscirono dall’arca. ");
INSERT INTO ita1927_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","E Noè edificò un altare all’Eterno; prese d’ogni specie d’animali puri e d’ogni specie d’uccelli puri, e offrì olocausti sull’altare. ");
INSERT INTO ita1927_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","E l’Eterno sentì un odor soave; e l’Eterno disse in cuor suo: “Io non maledirò più la terra a cagione dell’uomo, poiché i disegni del cuor dell’uomo sono malvagi fin dalla sua fanciullezza; e non colpirò più ogni cosa vivente, come ho fatto. ");
INSERT INTO ita1927_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Finché la terra durerà, sementa e raccolta, freddo e caldo, estate e inverno, giorno e notte, non cesseranno mai”. ");
INSERT INTO ita1927_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","E Dio benedisse Noè e i suoi figliuoli, e disse loro: “Crescete, moltiplicate, e riempite la terra. ");
INSERT INTO ita1927_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","E avranno timore e spavento di voi tutti gli animali della terra e tutti gli uccelli del cielo. Essi son dati in poter vostro con tutto ciò che striscia sulla terra e con tutti i pesci del mare. ");
INSERT INTO ita1927_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Tutto ciò che si muove ed ha vita vi servirà di cibo; io vi do tutto questo, come l’erba verde; ");
INSERT INTO ita1927_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","ma non mangerete carne con la vita sua, cioè col suo sangue. ");
INSERT INTO ita1927_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","E, certo, io chiederò conto del vostro sangue, del sangue delle vostre vite; ne chiederò conto ad ogni animale; e chiederò conto della vita dell’uomo alla mano dell’uomo, alla mano d’ogni suo fratello. ");
INSERT INTO ita1927_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Il sangue di chiunque spargerà il sangue dell’uomo sarà sparso dall’uomo, perché Dio ha fatto l’uomo a immagine sua. ");
INSERT INTO ita1927_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Voi dunque crescete e moltiplicate; spandetevi sulla terra, e moltiplicate in essa”. ");
INSERT INTO ita1927_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Poi Dio parlò a Noè e ai suoi figliuoli con lui, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Quanto a me, ecco, stabilisco il mio patto con voi e con la vostra progenie dopo voi, ");
INSERT INTO ita1927_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","e con tutti gli esseri viventi che sono con voi: uccelli, bestiame, e tutti gli animali della terra con voi; da tutti quelli che sono usciti dall’arca, a tutti quanti gli animali della terra. ");
INSERT INTO ita1927_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Io stabilisco il mio patto con voi, e nessuna carne sarà più sterminata dalle acque del diluvio, e non ci sarà più diluvio per distruggere la terra”. ");
INSERT INTO ita1927_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","E Dio disse: “Ecco il segno del patto che io fo tra me e voi e tutti gli esseri viventi che sono con voi, per tutte le generazioni a venire. ");
INSERT INTO ita1927_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Io pongo il mio arco nella nuvola, e servirà di segno del patto fra me e la terra. ");
INSERT INTO ita1927_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","E avverrà che quando avrò raccolto delle nuvole al disopra della terra, l’arco apparirà nelle nuvole, ");
INSERT INTO ita1927_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","e io mi ricorderò del mio patto fra me e voi e ogni essere vivente d’ogni carne, e le acque non diventeranno più un diluvio per distruggere ogni carne. ");
INSERT INTO ita1927_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","L’arco dunque sarà nelle nuvole, e io lo guarderò per ricordarmi del patto perpetuo fra Dio e ogni essere vivente, di qualunque carne che è sulla terra”. ");
INSERT INTO ita1927_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","E Dio disse a Noè: “Questo è il segno del patto che io ho stabilito fra me e ogni carne che è sulla terra”. ");
INSERT INTO ita1927_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","E i figliuoli di Noè che uscirono dall’arca furono Sem, Cam e Jafet; e Cam è il padre di Canaan. ");
INSERT INTO ita1927_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Questi sono i tre figliuoli di Noè; e da loro fu popolata tutta la terra. ");
INSERT INTO ita1927_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Or Noè, ch’era agricoltore, cominciò a piantar la vigna; ");
INSERT INTO ita1927_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","e bevve del vino e s’inebriò e si scoperse in mezzo alla sua tenda. ");
INSERT INTO ita1927_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","E Cam, padre di Canaan, vide la nudità del padre suo, e andò a dirlo fuori, ai suoi fratelli. ");
INSERT INTO ita1927_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ma Sem e Jafet presero il suo mantello, se lo misero assieme sulle spalle, e camminando all’indietro, coprirono la nudità del loro padre; e siccome aveano la faccia vòlta alla parte opposta, non videro la nudità del loro padre. ");
INSERT INTO ita1927_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","E quando Noè si svegliò dalla sua ebbrezza, seppe quello che gli avea fatto il suo figliuolo minore; e disse: ");
INSERT INTO ita1927_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","“Maledetto sia Canaan! Sia servo dei servi de’ suoi fratelli!” ");
INSERT INTO ita1927_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","E disse ancora: “Benedetto sia l’Eterno, l’Iddio di Sem, e sia Canaan suo servo! ");
INSERT INTO ita1927_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Iddio estenda Jafet, ed abiti egli nelle tende di Sem, e sia Canaan suo servo!” ");
INSERT INTO ita1927_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","E Noè visse, dopo il diluvio, trecentocinquanta anni. ");
INSERT INTO ita1927_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","E tutto il tempo che Noè visse fu novecento cinquanta anni; poi morì. ");
INSERT INTO ita1927_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Questa è la posterità dei figliuoli di Noè: Sem, Cam e Jafet; e a loro nacquero de’ figliuoli, dopo il diluvio. ");
INSERT INTO ita1927_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","I figliuoli di Jafet furono Gomer, Magog, Madai, Javan, Tubal, Mescec e Tiras. ");
INSERT INTO ita1927_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","I figliuoli di Gomer: Ashkenaz, Rifat e Togarma. ");
INSERT INTO ita1927_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","I figliuoli di Javan: Elisha, Tarsis, Kittim e Dodanim. ");
INSERT INTO ita1927_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Da essi vennero i popoli sparsi nelle isole delle nazioni, nei loro diversi paesi, ciascuno secondo la propria lingua, secondo le loro famiglie, nelle loro nazioni. ");
INSERT INTO ita1927_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","I figliuoli di Cam furono Cush, Mitsraim, Put e Canaan. ");
INSERT INTO ita1927_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","I figliuoli di Cush: Seba, Havila, Sabta, Raama e Sabteca; e i figliuoli di Raama: Sceba e Dedan. ");
INSERT INTO ita1927_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","E Cush generò Nimrod, che cominciò a esser potente sulla terra. ");
INSERT INTO ita1927_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Egli fu un potente cacciatore nei cospetto dell’Eterno; perciò si dice: “Come Nimrod, potente cacciatore nel cospetto dell’Eterno”. ");
INSERT INTO ita1927_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","E il principio del suo regno fu Babel, Erec, Accad e Calne nel paese di Scinear. ");
INSERT INTO ita1927_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Da quel paese andò in Assiria ed edificò Ninive, Rehoboth-Ir e Calah; ");
INSERT INTO ita1927_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","e, fra Ninive e Calah, Resen, la gran città. ");
INSERT INTO ita1927_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mitsraim generò i Ludim, gli Anamim, i Lehabim, i Naftuhim, ");
INSERT INTO ita1927_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","i Pathrusim, i Casluhim (donde uscirono i Filistei) e i Caftorim. ");
INSERT INTO ita1927_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Canaan generò Sidon, suo primogenito, e Heth, ");
INSERT INTO ita1927_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","e i Gebusei, gli Amorei, i Ghirgasei, ");
INSERT INTO ita1927_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","gli Hivvei, gli Archei, i Sinei, ");
INSERT INTO ita1927_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","gli Arvadei, i Tsemarei e gli Hamattei. Poi le famiglie dei Cananei si sparsero. ");
INSERT INTO ita1927_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","E i confini dei Cananei andarono da Sidon, in direzione di Gherar, fino a Gaza; e in direzione di Sodoma, Gomorra, Adma e Tseboim, fino a Lesha. ");
INSERT INTO ita1927_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Questi sono i figliuoli di Cam, secondo le loro famiglie, secondo le loro lingue, nei loro paesi, nelle loro nazioni. ");
INSERT INTO ita1927_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Anche a Sem, padre di tutti i figliuoli di Eber e fratello maggiore di Jafet, nacquero de’ figliuoli. ");
INSERT INTO ita1927_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","I figliuoli di Sem furono Elam, Assur, Arpacshad, Lud e Aram. ");
INSERT INTO ita1927_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","I figliuoli di Aram: Uz, Hul, Gheter e Mash. ");
INSERT INTO ita1927_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","E Arpacshad generò Scelah, e Scelah generò Eber. ");
INSERT INTO ita1927_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","E ad Eber nacquero due figliuoli; il nome dell’uno fu Peleg, perché ai suoi giorni la terra fu spartita; e il nome del suo fratello fu Jokthan. ");
INSERT INTO ita1927_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","E Jokthan generò Almodad, Scelef, Hatsarmaveth, ");
INSERT INTO ita1927_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Jerah, Hadoram, Uzal, ");
INSERT INTO ita1927_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Diklah, Obal, Abimael, Sceba, ");
INSERT INTO ita1927_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila e Jobab. Tutti questi furono figliuoli di Jokthan. ");
INSERT INTO ita1927_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","E la loro dimora fu la montagna orientale, da Mesha, fin verso Sefar. ");
INSERT INTO ita1927_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Questi sono i figliuoli di Sem, secondo le loro famiglie, secondo le loro lingue, nei loro paesi, secondo le loro nazioni. ");
INSERT INTO ita1927_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Queste sono le famiglie dei figliuoli di Noè secondo le loro generazioni, nelle loro nazioni; e da essi uscirono le nazioni che si sparsero per la terra dopo il diluvio. ");
INSERT INTO ita1927_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Or tutta la terra parlava la stessa lingua e usava le stesse parole. ");
INSERT INTO ita1927_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","E avvenne che, essendo partiti verso l’Oriente, gli uomini trovarono una pianura nel paese di Scinear, e quivi si stanziarono. ");
INSERT INTO ita1927_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","E dissero l’uno all’altro: “Orsù, facciamo dei mattoni e cociamoli col fuoco!” E si valsero di mattoni invece di pietre, e di bitume invece di calcina. ");
INSERT INTO ita1927_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","E dissero: “Orsù, edifichiamoci una città ed una torre di cui la cima giunga fino al cielo, e acquistiamoci fama, onde non siamo dispersi sulla faccia di tutta la terra”. ");
INSERT INTO ita1927_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","E l’Eterno discese per vedere la città e la torre che i figliuoli degli uomini edificavano. ");
INSERT INTO ita1927_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","E l’Eterno disse: “Ecco, essi sono un solo popolo e hanno tutti il medesimo linguaggio; e questo è il principio del loro lavoro; ora nulla li impedirà di condurre a termine ciò che disegnano di fare. ");
INSERT INTO ita1927_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Orsù, scendiamo e confondiamo quivi il loro linguaggio, sicché l’uno non capisca il parlare dell’altro!” ");
INSERT INTO ita1927_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Così l’Eterno li disperse di la sulla faccia di tutta la terra, ed essi cessarono di edificare la città. ");
INSERT INTO ita1927_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Perciò a questa fu dato il nome di Babel perché l’Eterno confuse quivi il linguaggio di tutta la terra, e di la l’Eterno li disperse sulla faccia di tutta la terra. ");
INSERT INTO ita1927_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Questa è la posterità di Sem. Sem, all’età di cent’anni, generò Arpacshad, due anni dopo il diluvio. ");
INSERT INTO ita1927_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","E Sem, dopo ch’ebbe generato Arpacshad, visse cinquecento anni e generò figliuoli e figliuole. ");
INSERT INTO ita1927_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpacshad visse trentacinque anni e generò Scelah; e Arpacshad, dopo aver generato Scelah, ");
INSERT INTO ita1927_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","visse quattrocento anni e generò figliuoli e figliuole. ");
INSERT INTO ita1927_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Scelah visse trent’anni e generò Eber; ");
INSERT INTO ita1927_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","e Scelah, dopo aver generato Eber, visse quattrocentotre anni e generò figliuoli e figliuole. ");
INSERT INTO ita1927_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber visse trentaquattro anni e generò Peleg; ");
INSERT INTO ita1927_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","ed Eber, dopo aver generato Peleg, visse quattrocento trenta anni e generò figliuoli e figliuole. ");
INSERT INTO ita1927_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg visse trent’anni e generò Reu; ");
INSERT INTO ita1927_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","e Peleg, dopo aver generato Reu, visse duecentonove anni e generò figliuoli e figliuole. ");
INSERT INTO ita1927_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu visse trentadue anni e generò Serug; ");
INSERT INTO ita1927_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","e Reu, dopo aver generato Serug, visse duecentosette anni e generò figliuoli e figliuole. ");
INSERT INTO ita1927_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug visse trent’anni e generò Nahor; ");
INSERT INTO ita1927_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","e Serug, dopo aver generato Nahor, visse duecento anni e generò figliuoli e figliuole. ");
INSERT INTO ita1927_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor visse ventinove anni e generò Terah; ");
INSERT INTO ita1927_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","e Nahor, dopo aver generato Terah, visse centodiciannove anni e generò figliuoli e figliuole. ");
INSERT INTO ita1927_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Terah visse settant’anni e generò Abramo, Nahor e Haran. ");
INSERT INTO ita1927_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","E questa è la posterità di Terah. Terah generò Abramo, Nahor e Haran; e Haran generò Lot. ");
INSERT INTO ita1927_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran morì in presenza di Terah suo padre, nel suo paese nativo, in Ur de’ Caldei. ");
INSERT INTO ita1927_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","E Abramo e Nahor si presero delle mogli; il nome della moglie d’Abramo era Sarai; e il nome della moglie di Nahor, Milca, ch’era figliuola di Haran, padre di Milca e padre di Isca. ");
INSERT INTO ita1927_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","E Sarai era sterile; non aveva figliuoli. ");
INSERT INTO ita1927_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","E Terah prese Abramo, suo figliuolo, e Lot, figliuolo di Haran, cioè figliuolo del suo figliuolo, e Sarai sua nuora, moglie d’Abramo suo figliuolo, e uscirono insieme da Ur de’ Caldei per andare nel paese di Canaan; e, giunti a Charan, dimorarono quivi. ");
INSERT INTO ita1927_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","E il tempo che Terah visse fu duecentocinque anni; poi Terah morì in Charan. ");
INSERT INTO ita1927_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Or l’Eterno disse ad Abramo: “Vattene dal tuo paese e dal tuo parentado e dalla casa di tuo padre, nel paese che io ti mostrerò; ");
INSERT INTO ita1927_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","e io farò di te una grande nazione e ti benedirò e renderò grande il tuo nome e tu sarai fonte di benedizione; ");
INSERT INTO ita1927_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","e benedirò quelli che ti benediranno e maledirò chi ti maledirà e in te saranno benedette tutte le famiglie della terra”. ");
INSERT INTO ita1927_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","E Abramo se ne andò, come l’Eterno gli avea detto, e Lot andò con lui. Abramo aveva settantacinque anni quando partì da Charan. ");
INSERT INTO ita1927_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","E Abramo prese Sarai sua moglie e Lot, figliuolo del suo fratello, e tutti i beni che possedevano e le persone che aveano acquistate in Charan, e partirono per andarsene nel paese di Canaan; e giunsero nel paese di Canaan. ");
INSERT INTO ita1927_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","E Abramo traversò il paese fino al luogo di Sichem, fino alla quercia di Moreh. Or in quel tempo i Cananei erano nel paese. ");
INSERT INTO ita1927_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","E l’Eterno apparve ad Abramo e disse: “Io darò questo paese alla tua progenie”. Ed egli edificò quivi un altare all’Eterno che gli era apparso. ");
INSERT INTO ita1927_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","E di là si trasportò verso la montagna a oriente di Bethel, e piantò le sue tende, avendo Bethel a occidente e Ai ad oriente; e quivi edificò un altare all’Eterno e invocò il nome dell’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Poi Abramo si partì, proseguendo da un accampamento all’altro, verso mezzogiorno. ");
INSERT INTO ita1927_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Or venne nel paese una carestia; e Abramo scese in Egitto per soggiornarvi, perché la fame era grave nel paese. ");
INSERT INTO ita1927_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","E come stava per entrare in Egitto, disse a Sarai sua moglie: “Ecco, io so che tu sei una donna di bell’aspetto; ");
INSERT INTO ita1927_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","e avverrà che quando gli Egiziani t’avranno veduta, diranno: Ella è sua moglie; e uccideranno me, ma a te lasceranno la vita. ");
INSERT INTO ita1927_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Deh, di’ che sei mia sorella, perché io sia trattato bene a motivo di te, e la vita mi sia conservata per amor tuo”. ");
INSERT INTO ita1927_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","E avvenne che quando Abramo fu giunto in Egitto, gli Egiziani osservarono che la donna era molto bella. ");
INSERT INTO ita1927_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","E i principi di Faraone la videro e la lodarono dinanzi a Faraone; e la donna fu menata in casa di Faraone. ");
INSERT INTO ita1927_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ed egli fece del bene ad Abramo per amor di lei; ed Abramo ebbe pecore e buoi e asini e servi e serve e asine e cammelli. ");
INSERT INTO ita1927_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ma l’Eterno colpì Faraone e la sua casa con grandi piaghe, a motivo di Sarai, moglie d’Abramo. ");
INSERT INTO ita1927_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Allora Faraone chiamò Abramo e disse: “Che m’hai tu fatto? perché non m’hai detto ch’era tua moglie? perché hai detto: ");
INSERT INTO ita1927_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","E’ mia sorella? ond’io me la son presa per moglie. Or dunque eccoti la tua moglie; prenditela e vattene!” ");
INSERT INTO ita1927_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","E Faraone diede alla sua gente ordini relativi ad Abramo, ed essi fecero partire lui, sua moglie, e tutto quello ch’ei possedeva. ");
INSERT INTO ita1927_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abramo dunque risalì dall’Egitto con sua moglie, con tutto quel che possedeva e con Lot, andando verso il mezzogiorno di Canaan. ");
INSERT INTO ita1927_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abramo era molto ricco di bestiame, d’argento e d’oro. ");
INSERT INTO ita1927_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","E continuò il suo viaggio dal mezzogiorno fino a Bethel, al luogo ove da principio era stata la sua tenda, fra Bethel ed Ai, ");
INSERT INTO ita1927_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","al luogo dov’era l’altare ch’egli avea fatto da prima; e quivi Abramo invocò il nome dell’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Or Lot, che viaggiava con Abramo, aveva anch’egli pecore, buoi e tende. ");
INSERT INTO ita1927_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","E il paese non era sufficiente perch’essi potessero abitarvi assieme; poiché le loro facoltà erano grandi ed essi non potevano stare assieme. ");
INSERT INTO ita1927_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","E nacque una contesa fra i pastori del bestiame d’Abramo e i pastori del bestiame di Lot. I Cananei e i Ferezei abitavano a quel tempo nel paese. ");
INSERT INTO ita1927_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","E Abramo disse a Lot: “Deh, non ci sia contesa fra me e te, né fra i miei pastori e i tuoi pastori, poiché siam fratelli! ");
INSERT INTO ita1927_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Tutto il paese non sta esso davanti a te? Deh, separati da me! Se tu vai a sinistra, io andrò a destra; e se tu vai a destra, io andrò a sinistra”. ");
INSERT INTO ita1927_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","E Lot alzò gli occhi e vide l’intera pianura del Giordano. Prima che l’Eterno avesse distrutto Sodoma e Gomorra, essa era tutta quanta irrigata fino a Tsoar, come il giardino dell’Eterno, come il paese d’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","E Lot si scelse tutta la pianura del Giordano, e partì andando verso oriente. Così si separarono l’uno dall’altro. ");
INSERT INTO ita1927_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abramo dimorò nel paese di Canaan, e Lot abitò nelle città della pianura e andò piantando le sue tende fino a Sodoma. ");
INSERT INTO ita1927_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ora la gente di Sodoma era scellerata e oltremodo peccatrice contro l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","E l’Eterno disse ad Abramo, dopo che Lot si fu separato da lui: “Alza ora gli occhi tuoi e mira, dal luogo dove sei, a settentrione, a mezzogiorno, a oriente, a occidente. ");
INSERT INTO ita1927_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Tutto il paese che vedi, lo darò a te e alla tua progenie, in perpetuo. ");
INSERT INTO ita1927_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","E farò si che la tua progenie sarà come la polvere della terra; in guisa che, se alcuno può contare la polvere della terra, anche la tua progenie si potrà contare. ");
INSERT INTO ita1927_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Lèvati, percorri il paese quant’è lungo e quant’è largo, poiché io te lo darò”. ");
INSERT INTO ita1927_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Allora Abramo levò le sue tende, e venne ad abitare alle querce di Mamre, che sono a Hebron; e quivi edificò un altare all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Or avvenne, al tempo di Amrafel re di Scinear, d’Arioc re di Ellasar, di Kedorlaomer re di Elam, e di Tideal re dei Goim, ");
INSERT INTO ita1927_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ch’essi mossero guerra a Bera re di Sodoma, a Birsha re di Gomorra, a Scinear re di Adma, a Scemeber re di Tseboim e al re di Bela, che è Tsoar. ");
INSERT INTO ita1927_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Tutti questi ultimi si radunarono nella valle di Siddim, ch’è il Mar salato. ");
INSERT INTO ita1927_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Per dodici anni erano stati soggetti a Kedorlaomer, e al tredicesimo anno si erano ribellati. ");
INSERT INTO ita1927_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","E nell’anno quattordicesimo, Kedorlaomer e i re ch’erano con lui vennero e sbaragliarono i Refei ad Ashteroth-Karnaim, gli Zuzei a Ham, gli Emei nella pianura di Kiriathaim ");
INSERT INTO ita1927_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","e gli Horei nella loro montagna di Seir fino a El-Paran, che è presso al deserto. ");
INSERT INTO ita1927_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Poi tornarono indietro e vennero a En-Mishpat, che è Kades, e sbaragliarono gli Amalekiti su tutto il loro territorio, e così pure gli Amorei che abitavano ad Hatsatson-Tamar. ");
INSERT INTO ita1927_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Allora il re di Sodoma, il re di Gomorra, il re di Adma, il re di Tseboim e il re di Bela, che è Tsoar, uscirono e si schierarono in battaglia contro quelli, nella valle di Siddim: ");
INSERT INTO ita1927_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","contro Kedorlaomer re di Elam, Tideal re dei Goim, Amrafel re di Scinear e Arioc re di Ellasar: quattro re contro cinque. ");
INSERT INTO ita1927_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Or la valle di Siddim era piena di pozzi di bitume; e i re di Sodoma e di Gomorra si dettero alla fuga e vi caddero dentro; quelli che scamparono fuggirono al monte. ");
INSERT INTO ita1927_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","E i vincitori presero tutte le ricchezze di Sodoma e di Gomorra, e tutti i loro viveri, e se ne andarono. ");
INSERT INTO ita1927_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Presero anche Lot, figliuolo del fratello di Abramo, con la sua roba; e se ne andarono. Lot abitava in Sodoma. ");
INSERT INTO ita1927_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","E uno degli scampati venne a dirlo ad Abramo, l’Ebreo, che abitava alle querce di Mamre l’Amoreo, fratello di Eshcol e fratello di Aner, i quali aveano fatto alleanza con Abramo. ");
INSERT INTO ita1927_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","E Abramo, com’ebbe udito che il suo fratello era stato fatto prigioniero, armò trecentodiciotto de’ suoi più fidati servitori, nati in casa sua, ed inseguì i re fino a Dan. ");
INSERT INTO ita1927_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","E, divisa la sua schiera per assalirli di notte, egli coi suoi servi li sconfisse e l’inseguì fino a Hobah, che è a sinistra di Damasco. ");
INSERT INTO ita1927_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","E ricuperò tutta la roba, e rimenò pure Lot suo fratello, la sua roba, e anche le donne e il popolo. ");
INSERT INTO ita1927_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","E com’egli se ne tornava dalla sconfitta di Kedorlaomer e dei re ch’eran con lui, il re di Sodoma gli andò incontro nella valle di Shaveh, che è la Valle del re. ");
INSERT INTO ita1927_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","E Melchisedec, re di Salem, fece portar del pane e del vino. Egli era sacerdote dell’Iddio altissimo. ");
INSERT INTO ita1927_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ed egli benedisse Abramo, dicendo: “Benedetto sia Abramo dall’Iddio altissimo, padrone de’ cieli e della terra! ");
INSERT INTO ita1927_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","E benedetto sia l’Iddio altissimo, che t’ha dato in mano i tuoi nemici!” E Abramo gli diede la decima d’ogni cosa. ");
INSERT INTO ita1927_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","E il re di Sodoma disse ad Abramo: “Dammi le persone, e prendi per te la roba”. ");
INSERT INTO ita1927_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ma Abramo rispose al re di Sodoma: “Ho alzato la mia mano all’Eterno, l’Iddio altissimo, padrone dei cieli e della terra, ");
INSERT INTO ita1927_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","giurando che non prenderei neppure un filo, né un laccio di sandalo, di tutto ciò che t’appartiene; perché tu non abbia a dire: Io ho arricchito Abramo. ");
INSERT INTO ita1927_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Nulla per me! tranne quello che hanno mangiato i giovani, e la parte che spetta agli uomini che son venuti meco: Aner, Eshcol e Mamre; essi prendano la loro parte”. ");
INSERT INTO ita1927_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Dopo queste cose, la parola dell’Eterno fu rivolta in visione ad Abramo, dicendo: “Non temere, o Abramo, io sono il tuo scudo, e la tua ricompensa sarà grandissima”. ");
INSERT INTO ita1927_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","E Abramo disse: “Signore, Eterno, che mi darai tu? poiché io me ne vo senza figliuoli, e chi possederà la mia casa è Eliezer di Damasco”. ");
INSERT INTO ita1927_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","E Abramo soggiunse: “Tu non m’hai dato progenie; ed ecco, uno schiavo nato in casa mia sarà mio erede”. ");
INSERT INTO ita1927_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Allora la parola dell’Eterno gli fu rivolta, dicendo: “Questi non sarà tuo erede; ma colui che uscirà dalle tue viscere sarà erede tuo”. ");
INSERT INTO ita1927_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","E lo menò fuori, e gli disse: “Mira il cielo, e conta le stelle, se le puoi contare”. E gli disse: “Così sarà la tua progenie”. ");
INSERT INTO ita1927_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ed egli credette all’Eterno, che gli contò questo come giustizia. ");
INSERT INTO ita1927_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","E l’Eterno gli disse: “Io sono l’Eterno che t’ho fatto uscire da Ur de’ Caldei per darti questo paese, perché tu lo possegga”. ");
INSERT INTO ita1927_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","E Abramo chiese: “Signore, Eterno, da che posso io conoscere che lo possederò?” ");
INSERT INTO ita1927_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","E l’Eterno gli rispose: “Pigliami una giovenca di tre anni, una capra di tre anni, un montone di tre anni, una tortora e un piccione”. ");
INSERT INTO ita1927_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ed egli prese tutti questi animali, li divise per mezzo, e pose ciascuna metà dirimpetto all’altra; ma non divise gli uccelli. ");
INSERT INTO ita1927_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Or degli uccelli rapaci calarono sulle bestie morte, ma Abramo li scacciò. ");
INSERT INTO ita1927_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","E, sul tramontare del sole, un profondo sonno cadde sopra Abramo; ed ecco, uno spavento, una oscurità profonda, cadde su lui. ");
INSERT INTO ita1927_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","E l’Eterno disse ad Abramo: “Sappi per certo che i tuoi discendenti dimoreranno come stranieri in un paese che non sarà loro, e vi saranno schiavi, e saranno oppressi per quattrocento anni; ");
INSERT INTO ita1927_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","ma io giudicherò la gente di cui saranno stati servi; e, dopo questo, se ne partiranno con grandi ricchezze. ");
INSERT INTO ita1927_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","E tu te n’andrai in pace ai tuoi padri, e sarai sepolto dopo una prospera vecchiezza. ");
INSERT INTO ita1927_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","E alla quarta generazione essi torneranno qua; perché l’iniquità degli Amorei non e giunta finora al colmo”. ");
INSERT INTO ita1927_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Or come il sole si fu coricato e venne la notte scura, ecco una fornace fumante ed una fiamma di fuoco passare in mezzo agli animali divisi. ");
INSERT INTO ita1927_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","In quel giorno l’Eterno fece patto con Abramo, dicendo: “Io do alla tua progenie questo paese, dal fiume d’Egitto al gran fiume, il fiume Eufrate; ");
INSERT INTO ita1927_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","i Kenei, i Kenizei, i Kadmonei, ");
INSERT INTO ita1927_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","gli Hittei, i Ferezei, i Refei, ");
INSERT INTO ita1927_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","gli Amorei, i Cananei, i Ghirgasei e i Gebusei”. ");
INSERT INTO ita1927_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Or Sarai, moglie d’Abramo, non gli avea dato figliuoli. Essa aveva una serva egiziana per nome Agar. ");
INSERT INTO ita1927_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","E Sarai disse ad Abramo: “Ecco, l’Eterno m’ha fatta sterile; deh, va’ dalla mia serva; forse avrò progenie da lei”. E Abramo dette ascolto alla voce di Sarai. ");
INSERT INTO ita1927_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Sarai dunque, moglie d’Abramo, dopo che Abramo ebbe dimorato dieci anni nel paese di Canaan, prese la sua serva Agar, l’Egiziana, e la diede per moglie ad Abramo suo marito. ");
INSERT INTO ita1927_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ed egli andò da Agar, che rimase incinta; e quando s’accorse ch’era incinta, guardò la sua padrona con disprezzo. ");
INSERT INTO ita1927_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","E Sarai disse ad Abramo: “L’ingiuria fatta a me, ricade su te. Io t’ho dato la mia serva in seno; e da che ella s’è accorta ch’era incinta, mi guarda con disprezzo. L’Eterno sia giudice fra me e te”. ");
INSERT INTO ita1927_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","E Abramo rispose a Sarai: “Ecco, la tua serva è in tuo potere; fa’ con lei come ti piacerà”. Sarai la trattò duramente, ed ella se ne fuggì da lei. ");
INSERT INTO ita1927_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","E l’angelo dell’Eterno la trovò presso una sorgente d’acqua, nel deserto, presso la sorgente ch’è sulla via di Shur, ");
INSERT INTO ita1927_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","e le disse: “Agar, serva di Sarai, donde vieni? e dove vai?” Ed ella rispose: “Me ne fuggo dal cospetto di Sarai mia padrona”. ");
INSERT INTO ita1927_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","E l’angelo dell’Eterno le disse: “Torna alla tua padrona, e umiliati sotto la sua mano”. ");
INSERT INTO ita1927_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","L’angelo dell’Eterno soggiunse: “Io moltiplicherò grandemente la tua progenie, e non la si potrà contare, tanto sarà numerosa”. ");
INSERT INTO ita1927_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","E l’angelo dell’Eterno le disse ancora: “Ecco, tu sei incinta, e partorirai un figliuolo, al quale porrai nome Ismaele, perché l’Eterno t’ha ascoltata nella tua afflizione; ");
INSERT INTO ita1927_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","esso sarà tra gli uomini come un asino selvatico; la sua mano sarà contro tutti, e la mano di tutti contro di lui; e abiterà in faccia a tutti i suoi fratelli”. ");
INSERT INTO ita1927_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Allora Agar chiamò il nome dell’Eterno che le avea parlato, Atta-El-Roi, perché disse: “Ho io, proprio qui, veduto andarsene colui che m’ha vista?” ");
INSERT INTO ita1927_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Perciò quel pozzo fu chiamato “il pozzo di Lachai-Roi”. Ecco, esso è fra Kades e Bered. ");
INSERT INTO ita1927_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","E Agar partorì un figliuolo ad Abramo; e Abramo, al figliuolo che Agar gli avea partorito, pose nome Ismaele. ");
INSERT INTO ita1927_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abramo aveva ottantasei anni quando Agar gli partorì Ismaele. ");
INSERT INTO ita1927_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Quando Abramo fu d’età di novantanove anni, l’Eterno gli apparve e gli disse: “Io sono l’Iddio onnipotente; cammina alla mia presenza, e sii integro; ");
INSERT INTO ita1927_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","e io fermerò il mio patto fra me e te, e ti moltiplicherò grandissimamente”. ");
INSERT INTO ita1927_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Allora Abramo si prostrò con la faccia in terra, e Dio gli parlò, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Quanto a me, ecco il patto che fo con te; tu diverrai padre di una moltitudine di nazioni; ");
INSERT INTO ita1927_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","e non sarai più chiamato Abramo, ma il tuo nome sarà Abrahamo, poiché io ti costituisco padre di una moltitudine di nazioni. ");
INSERT INTO ita1927_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","E ti farò moltiplicare grandissimamente, e ti farò divenir nazioni, e da te usciranno dei re. ");
INSERT INTO ita1927_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","E fermerò il mio patto fra me e te e i tuoi discendenti dopo di te, di generazione in generazione; sarà un patto perpetuo, per il quale io sarò l’Iddio tuo e della tua progenie dopo di te. ");
INSERT INTO ita1927_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","E a te e alla tua progenie dopo di te darò il paese dove abiti come straniero: tutto il paese di Canaan, in possesso perpetuo; e sarò loro Dio”. ");
INSERT INTO ita1927_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Poi Dio disse ad Abrahamo: “Quanto a te, tu osserverai il mio patto: tu e la tua progenie dopo di te, di generazione in generazione. ");
INSERT INTO ita1927_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Questo è il mio patto che voi osserverete, patto fra me e voi e la tua progenie dopo di te: ogni maschio fra voi sia circonciso. ");
INSERT INTO ita1927_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","E sarete circoncisi; e questo sarà un segno del patto fra me e voi. ");
INSERT INTO ita1927_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","All’età d’otto giorni, ogni maschio sarà circonciso fra voi, di generazione in generazione: tanto quello nato in casa, quanto quello comprato con danaro da qualsivoglia straniero e che non sia della tua progenie. ");
INSERT INTO ita1927_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Quello nato in casa tua e quello comprato con danaro dovrà esser circonciso; e il mio patto nella vostra carne sarà un patto perpetuo. ");
INSERT INTO ita1927_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","E il maschio incirconciso, che non sarà stato circonciso nella sua carne, sarà reciso di fra il su popolo: egli avrà violato il mio patto”. ");
INSERT INTO ita1927_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","E Dio disse ad Abrahamo: “Quanto a Sarai tua moglie, non la chiamar più Sarai; il suo nome sarà, invece Sara. ");
INSERT INTO ita1927_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","E io la benedirò, ed anche ti darò di lei un figliuolo; io la benedirò, ed essa diverrà nazioni; re di popoli usciranno da lei”. ");
INSERT INTO ita1927_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Allora Abrahamo si prostrò con la faccia in terra e rise; e disse in cuor suo: “Nascerà egli un figliuolo a un uomo di cent’anni? e Sara, che ha novant’anni, partorirà ella?” ");
INSERT INTO ita1927_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","E Abrahamo disse a Dio: “Di grazia, viva Ismaele nel tuo cospetto!” ");
INSERT INTO ita1927_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","E Dio rispose: “No, ma Sara tua moglie ti partorirà un figliuolo, e tu gli porrai nome Isacco; e io fermerò il mio patto con lui, un patto perpetuo per la sua progenie dopo di lui. ");
INSERT INTO ita1927_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Quanto a Ismaele, io t’ho esaudito. Ecco, io l’ho benedetto, e farò che moltiplichi e s’accresca grandissimamente. Egli genererà dodici principi, e io farò di lui una grande nazione. ");
INSERT INTO ita1927_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ma fermerò il mio patto con Isacco che Sara ti partorirà in questo tempo, l’anno venturo”. ");
INSERT INTO ita1927_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","E quand’ebbe finito di parlare con lui, Iddio lasciò Abrahamo, levandosi in alto. ");
INSERT INTO ita1927_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","E Abrahamo prese Ismaele suo figliuolo e tutti quelli che gli erano nati in casa e tutti quelli che avea comprato col suo danaro, tutti i maschi fra la gente della casa d’Abrahamo, e li circoncise, in quello stesso giorno come Dio gli avea detto di fare. ");
INSERT INTO ita1927_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Or Abrahamo aveva novantanove anni quando fu circonciso. ");
INSERT INTO ita1927_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","E Ismaele suo figliuolo aveva tredici anni quando fu circonciso. ");
INSERT INTO ita1927_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","In quel medesimo giorno fu circonciso Abrahamo, e Ismaele suo figliuolo. ");
INSERT INTO ita1927_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","E tutti gli uomini della sua casa, tanto quelli nati in casa quanto quelli comprati con danaro dagli stranieri, furono circoncisi con lui. ");
INSERT INTO ita1927_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","L’Eterno apparve ad Abrahamo alle querce di Mamre, mentre questi sedeva all’ingresso della sua tenda durante il caldo del giorno. ");
INSERT INTO ita1927_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abrahamo alzò gli occhi, ed ecco che scòrse tre uomini, i quali stavano dinanzi a lui; e come li ebbe veduti, corse loro incontro dall’ingresso della tenda, si prostrò fino a terra e disse: ");
INSERT INTO ita1927_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","“Deh, Signor mio, se ho trovato grazia davanti a te, non passare senza fermarti dal tuo servo! ");
INSERT INTO ita1927_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Deh, lasciate che si porti un po’ d’acqua; e lavatevi i piedi; e riposatevi sotto quest’albero. ");
INSERT INTO ita1927_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","lo andrò a prendere un pezzo di pane, e vi fortificherete il cuore; poi, continuerete il vostro cammino; poiché per questo siete passati presso al vostro servo”. E quelli dissero: “Fa’ come hai detto”. ");
INSERT INTO ita1927_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Allora Abrahamo andò in fretta nella tenda da Sara, e le disse: “Prendi subito tre misure di fior di farina, impastala, e fa’ delle schiacciate”. ");
INSERT INTO ita1927_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Poi Abrahamo corse all’armento, ne tolse un vitello tenero e buono, e lo diede a un servo, il quale s’affrettò a prepararlo. ");
INSERT INTO ita1927_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","E prese del burro, del latte e il vitello ch’era stato preparato, e li pose davanti a loro; ed egli se ne stette in piè presso di loro sotto l’albero. E quelli mangiarono. ");
INSERT INTO ita1927_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Poi essi gli dissero: “Dov’è Sara tua moglie?” Ed egli rispose: “E’ là nella tenda”. ");
INSERT INTO ita1927_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","E l’altro: “Tornerò certamente da te fra un anno; ed ecco, Sara tua moglie avrà un figliuolo”. E Sara ascoltava all’ingresso della tenda, ch’era dietro a lui. ");
INSERT INTO ita1927_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Or Abrahamo e Sara eran vecchi, bene avanti negli anni, e Sara non aveva più i corsi ordinari delle donne. ");
INSERT INTO ita1927_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","E Sara rise dentro di sé, dicendo: “Vecchia come sono, avrei io tali piaceri? e anche il mio signore è vecchio!” ");
INSERT INTO ita1927_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","E l’Eterno disse ad Abrahamo: “Perché mai ha riso Sara, dicendo: Partorirei io per davvero, vecchia come sono? ");
INSERT INTO ita1927_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","V’ha egli cosa che sia troppo difficile per l’Eterno? Al tempo fissato, fra un anno, tornerò, e Sara avrà un figliuolo”. ");
INSERT INTO ita1927_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Allora Sara negò, dicendo: “Non ho riso”; perch’ebbe paura. Ma egli disse: “Invece, hai riso!” ");
INSERT INTO ita1927_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Poi quegli uomini s’alzarono e volsero gli sguardi verso Sodoma; e Abrahamo andava con loro per accomiatarli. ");
INSERT INTO ita1927_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","E l’Eterno disse: “Celerò io ad Abrahamo quello che sto per fare, ");
INSERT INTO ita1927_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","giacché Abrahamo deve diventare una nazione grande e potente e in lui saran benedette tutte le nazioni della terra? ");
INSERT INTO ita1927_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Poiché io l’ho prescelto affinché ordini ai suoi figliuoli, e dopo di sé alla sua casa, che s’attengano alla via dell’Eterno per praticare la giustizia e l’equità, onde l’Eterno ponga ad effetto a pro d’Abrahamo quello che gli ha promesso”. ");
INSERT INTO ita1927_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","E l’Eterno disse: “Siccome il grido che sale da Sodoma e Gomorra è grande e siccome il loro peccato è molto grave, ");
INSERT INTO ita1927_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","io scenderò e vedrò se hanno interamente agito secondo il grido che n’è pervenuto a me; e, se così non è, lo saprò”. ");
INSERT INTO ita1927_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","E quegli uomini, partitisi di là, s’avviarono verso Sodoma; ma Abrahamo rimase ancora davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","E Abrahamo s’accostò e disse: “Farai tu perire il giusto insieme con l’empio? ");
INSERT INTO ita1927_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Forse ci son cinquanta giusti nella città; farai tu perire anche quelli? o non perdonerai tu a quel luogo per amore de’ cinquanta giusti che vi sono? ");
INSERT INTO ita1927_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Lungi da te il fare tal cosa! il far morire il giusto con l’empio, in guisa che il giusto sia trattato come l’empio! lungi da te! Il giudice di tutta la terra non farà egli giustizia?” ");
INSERT INTO ita1927_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","E l’Eterno disse: “Se trovo nella città di Sodoma cinquanta giusti, perdonerò a tutto il luogo per amor d’essi”. ");
INSERT INTO ita1927_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","E Abrahamo riprese e disse: “Ecco, prendo l’ardire di parlare al Signore, benché io non sia che polvere e cenere; ");
INSERT INTO ita1927_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","forse, a que’ cinquanta giusti ne mancheranno cinque; distruggerai tu tutta la città per cinque di meno?” E l’Eterno: “Se ve ne trovo quarantacinque, non la distruggerò”. ");
INSERT INTO ita1927_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abrahamo continuò a parlargli e disse: “Forse, vi se ne troveranno quaranta”. E l’Eterno: “Non io farò, per amor dei quaranta”. ");
INSERT INTO ita1927_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","E Abrahamo disse: “Deh, non si adiri il Signore, ed io parlerò. Forse, vi se ne troveranno trenta”. E l’Eterno: “Non lo farò, se ve ne trovo trenta”. ");
INSERT INTO ita1927_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","E Abrahamo disse: “Ecco, prendo l’ardire di parlare al Signore; forse, vi se ne troveranno venti”. E l’Eterno: “Non la distruggerò per amore dei venti”. ");
INSERT INTO ita1927_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","E Abrahamo disse: “Deh, non si adiri il Signore, e io parlerò ancora questa volta soltanto. Forse, vi se ne troveranno dieci”. E l’Eterno: “Non la distruggerò per amore de’ dieci”. ");
INSERT INTO ita1927_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","E come l’Eterno ebbe finito di parlare ad Abrahamo, se ne andò. E Abrahamo tornò alla sua dimora. ");
INSERT INTO ita1927_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Or i due angeli giunsero a Sodoma verso sera; e Lot stava sedendo alla porta di Sodoma; e, come li vide, s’alzò per andar loro incontro e si prostrò con la faccia a terra, e disse: ");
INSERT INTO ita1927_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“Signori miei, vi prego, venite in casa del vostro servo, albergatevi questa notte, e lavatevi i piedi; poi domattina vi leverete per tempo e continuerete il vostro cammino”. Ed essi risposero: “No; passeremo la notte sulla piazza”. ");
INSERT INTO ita1927_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ma egli fe’ loro tanta premura, che vennero da lui ed entrarono in casa sua. Ed egli fece loro un convito, cosse dei pani senza lievito, ed essi mangiarono. ");
INSERT INTO ita1927_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ma prima che si fossero coricati, gli uomini della città, i Sodomiti, circondarono la casa: giovani e vecchi, la popolazione intera venuta da ogni lato; e chiamarono Lot, e gli dissero: ");
INSERT INTO ita1927_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","“Dove sono quegli uomini che son venuti da te stanotte? Menaceli fuori, affinché noi li conosciamo!” ");
INSERT INTO ita1927_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot uscì verso di loro sull’ingresso di casa, si chiuse dietro la porta, e disse: ");
INSERT INTO ita1927_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“Deh, fratelli miei, non fate questo male! ");
INSERT INTO ita1927_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ecco, ho due figliuole che non hanno conosciuto uomo; deh, lasciate ch’io ve le meni fuori, e voi fate di loro quel che vi piacerà; soltanto non fate nulla a questi uomini, poiché son venuti all’ombra del mio tetto”. ");
INSERT INTO ita1927_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ma essi gli dissero: “Fatti in là!” E ancora: “Quest’individuo è venuto qua come straniero, e la vuol far da giudice! Ora faremo a te peggio che a quelli!” E, premendo Lot con violenza, s’avvicinarono per sfondare la porta. ");
INSERT INTO ita1927_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ma quegli uomini stesero la mano, trassero Lot in casa con loro, e chiusero la porta. ");
INSERT INTO ita1927_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","E colpirono di cecità la gente ch’era alla porta della casa, dal più piccolo al più grande, talché si stancarono a cercar la porta. ");
INSERT INTO ita1927_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","E quegli uomini dissero a Lot: “Chi hai tu ancora qui? fa’ uscire da questo luogo generi, figliuoli, figliuole e chiunque de’ tuoi è in questa città; ");
INSERT INTO ita1927_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","poiché noi distruggeremo questo luogo, perché il grido contro i suoi abitanti è grande nel cospetto dell’Eterno, e l’Eterno ci ha mandati a distruggerlo”. ");
INSERT INTO ita1927_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Allora Lot usci, parlò ai suoi generi che avevano preso le sue figliuole, e disse: “Levatevi, uscite da questo luogo, perché l’Eterno sta per distruggere la città”. Ma ai i generi parve che volesse scherzare. ");
INSERT INTO ita1927_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","E come l’alba cominciò ad apparire, gli angeli sollecitarono Lot, dicendo: “Lèvati, prendi tua moglie e le tue due figliuole che si trovan qui, affinché tu non perisca nel castigo di questa città”. ");
INSERT INTO ita1927_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ma egli s’indugiava; e quegli uomini presero per la mano lui, sua moglie e le sue due figliuole, perché l’Eterno lo volea risparmiare; e lo menaron via, e lo misero fuori della città. ");
INSERT INTO ita1927_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","E avvenne che quando li ebbero fatti uscire, uno di quegli uomini disse: “Sàlvati la vita! non guardare indietro, e non ti fermare in alcun luogo della pianura; sàlvati al monte, che tu non abbia a perire!” ");
INSERT INTO ita1927_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","E Lot rispose loro: “No, mio signore! ");
INSERT INTO ita1927_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","ecco, il tuo servo ha trovato grazia agli occhi tuoi, e tu hai mostrato la grandezza della tua bontà verso di me conservandomi in vita; ma io non posso salvarmi al monte prima che il disastro mi sopraggiunga, ed io perisca. ");
INSERT INTO ita1927_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ecco, questa città è vicina da potermici rifugiare, ed è piccola. Deh, lascia ch’io scampi quivi non è essa piccola? e vivrà l’anima mia!” ");
INSERT INTO ita1927_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","E quegli a lui: “Ecco, anche questa grazia io ti concedo: di non distruggere la città, della quale hai parlato. ");
INSERT INTO ita1927_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Affrettati, scampa colà, poiché io non posso far nulla finché tu vi sia giunto”. Perciò quella città fu chiamata Tsoar. ");
INSERT INTO ita1927_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Il sole si levava sulla terra quando Lot arrivò a Tsoar. ");
INSERT INTO ita1927_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Allora l’Eterno fece piovere dai cieli su Sodoma e Gomorra zolfo e fuoco, da parte dell’Eterno; ");
INSERT INTO ita1927_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","ed egli distrusse quelle città e tutta la pianura e tutti gli abitanti delle città e quanto cresceva sul suolo. ");
INSERT INTO ita1927_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ma la moglie di Lot si volse a guardare indietro, e diventò una statua di sale. ");
INSERT INTO ita1927_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","E Abrahamo si levò la mattina a buon’ora, e andò al luogo dove s’era prima fermato davanti all’Eterno; ");
INSERT INTO ita1927_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","guardò verso Sodoma e Gomorra e verso tutta la regione della pianura, ed ecco vide un fumo che si levava dalla terra, come il fumo d’una fornace. ");
INSERT INTO ita1927_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Così avvenne che, quando Iddio distrusse le città della pianura, egli si ricordò d’Abrahamo, e fece partir Lot di mezzo al disastro, allorché sovvertì le città dove Lot avea dimorato. ");
INSERT INTO ita1927_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot salì da Tsoar e dimorò sul monte insieme con le sue due figliuole, perché temeva di stare in Tsoar; e dimorò in una spelonca, egli con le sue due figliuole. ");
INSERT INTO ita1927_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","E la maggiore disse alla minore: “Nostro padre è vecchio, e non c’è più nessuno sulla terra per venire da noi, come si costuma in tutta la terra. ");
INSERT INTO ita1927_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Vieni, diamo a bere del vino a nostro padre, e giaciamoci con lui, affinché possiamo conservare la razza di nostro padre”. ");
INSERT INTO ita1927_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","E quella stessa notte dettero a bere del vino al loro padre; e la maggiore entrò e si giacque con suo padre; ed egli non s’accorse né quando essa si coricò né quando si levò. ");
INSERT INTO ita1927_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","E avvenne che il dì seguente, la maggiore disse alla minore: “Ecco, la notte passata io mi giacqui con mio padre; diamogli a bere del vino anche questa notte; e tu entra, e giaciti con lui, affinché possiamo conservare la razza di nostro padre”. ");
INSERT INTO ita1927_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","E anche quella notte dettero a bere del vino al padre loro, e la minore andò a giacersi con lui; ed egli non s’accorse né quando essa si coricò né quando si levò. ");
INSERT INTO ita1927_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Così le due figliuole di Lot rimasero incinte del loro padre. ");
INSERT INTO ita1927_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","E la maggiore partorì un figliuolo, al quale pose nome Moab. Questi è il padre dei Moabiti, che sussistono fino al di d’oggi. ");
INSERT INTO ita1927_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","E la minore partorì anch’essa un figliuolo, al quale pose nome Ben-Ammi. Questi è il padre degli Ammoniti, che sussistono fino al dì d’oggi. ");
INSERT INTO ita1927_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abrahamo si partì di là andando verso il paese del mezzodì, dimorò fra Kades e Shur, e abitò come forestiero in Gherar. ");
INSERT INTO ita1927_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","E Abrahamo diceva di Sara sua moglie: “Ell’è mia sorella”. E Abimelec, re di Gherar, mandò a pigliar Sara. ");
INSERT INTO ita1927_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ma Dio venne, di notte, in un sogno, ad Abimelec, e gli disse: “Ecco, tu sei morto, a motivo della donna che ti sei presa; perch’ella ha marito”. ");
INSERT INTO ita1927_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Or Abimelec non s’era accostato a lei; e rispose: “Signore, faresti tu perire una nazione anche se giusta? ");
INSERT INTO ita1927_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Non m’ha egli detto: E’ mia sorella? e anche lei stessa ha detto: Egli è mio fratello. Io ho fatto questo nella integrità del mio cuore e con mani innocenti”. ");
INSERT INTO ita1927_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","E Dio gli disse nel sogno: “Anch’io so che tu hai fatto questo nella integrità del tuo cuore; e t’ho quindi preservato dal peccare contro di me; perciò non ti ho permesso di toccarla. ");
INSERT INTO ita1927_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Or dunque, restituisci la moglie a quest’uomo, perché è profeta; ed egli pregherà per te, e tu vivrai. Ma, se non la restituisci, sappi che, per certo, morrai: tu e tutti i tuoi”. ");
INSERT INTO ita1927_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","E Abimelec si levò la mattina per tempo, chiamò tutti i suoi servi, e raccontò in loro presenza tutte queste cose. E quegli uomini furon presi da gran paura. ");
INSERT INTO ita1927_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Poi Abimelec chiamò Abrahamo e gli disse: “Che ci hai tu fatto? E in che t’ho io offeso, che tu abbia fatto venir su me e sul mio regno un sì gran peccato? Tu m’hai fatto cose che non si debbono fare”. ");
INSERT INTO ita1927_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","E di nuovo Abimelec disse ad Abrahamo: “A che miravi, facendo questo?” ");
INSERT INTO ita1927_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","E Abrahamo rispose: “L’ho fatto, perché dicevo fra me: Certo, in questo luogo non c’è timor di Dio; e m’uccideranno a causa di mia moglie. ");
INSERT INTO ita1927_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Inoltre, ella è proprio mia sorella, figliuola di mio padre, ma non figliuola di mia madre; ed è diventata mia moglie. ");
INSERT INTO ita1927_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Or quando Iddio mi fece errare lungi dalla casa di mio padre, io le dissi: Questo è il favore che tu mi farai; dovunque, giungeremo dirai di me: E’ mio fratello”. ");
INSERT INTO ita1927_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","E Abimelec prese delle pecore, de’ buoi, de’ servi e delle serve, e li diede ad Abrahamo, e gli restituì Sara sua moglie. E Abimelec disse: ");
INSERT INTO ita1927_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","“Ecco, il mio paese ti sta dinanzi; dimora dovunque ti piacerà”. E a Sara disse: ");
INSERT INTO ita1927_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","“Ecco, io ho dato tuo fratello mille pezzi d’argento; questo ti sarà un velo sugli occhi di fronte a tutti quelli che sono teco, e sarai giustificata dinanzi a tutti”. ");
INSERT INTO ita1927_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","E Abrahamo pregò Dio, e Dio guarì Abimelec, la moglie e le serve di lui, ed esse poteron partorire. ");
INSERT INTO ita1927_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Poiché l’Eterno avea del tutto resa sterile l’intera casa di Abimelec, a motivo di Sara moglie di Abrahamo. ");
INSERT INTO ita1927_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","L’Eterno visitò Sara come avea detto; e l’Eterno fece a Sara come aveva annunziato. ");
INSERT INTO ita1927_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","E Sara concepì e partorì un figliuolo ad Abrahamo, quand’egli era vecchio, al tempo che Dio gli avea fissato. ");
INSERT INTO ita1927_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","E Abrahamo pose nome Isacco al figliuolo che gli era nato, che Sara gli avea partorito. ");
INSERT INTO ita1927_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","E Abrahamo circoncise il suo figliuolo Isacco all’età di otto giorni, come Dio gli avea comandato. ");
INSERT INTO ita1927_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Or Abrahamo aveva cento anni, quando gli nacque il suo figliuolo Isacco. ");
INSERT INTO ita1927_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","E Sara disse: “Iddio m’ha dato di che ridere; chiunque l’udrà riderà con me”. ");
INSERT INTO ita1927_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","E aggiunse: “Chi avrebbe mai detto ad Abrahamo che Sara allatterebbe figliuoli? poiché io gli ho partorito un figliuolo nella sua vecchiaia”. ");
INSERT INTO ita1927_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Il bambino dunque crebbe e fu divezzato; e nei giorno che Isacco fu divezzato, Abrahamo fece un gran convito. ");
INSERT INTO ita1927_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","E Sara vide che il figliuolo partorito ad Abrahamo da Agar, l’egiziana, rideva; ");
INSERT INTO ita1927_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","allora ella disse ad Abrahamo: “Caccia via questa serva e il suo figliuolo; perché il figliuolo di questa serva non ha da essere erede col mio figliuolo, con Isacco”. ");
INSERT INTO ita1927_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","E la cosa dispiacque fortemente ad Abrahamo, a motivo del suo figliuolo. ");
INSERT INTO ita1927_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ma Dio disse ad Abrahamo: “Questo non ti dispiaccia, a motivo del fanciullo della tua serva; acconsenti a tutto quello che Sara ti dirà; poiché da Isacco uscirà la progenie che porterà il tuo nome. ");
INSERT INTO ita1927_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ma anche del figliuolo di questa serva io farò una nazione, perché e tua progenie”. ");
INSERT INTO ita1927_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Abrahamo dunque si levò la mattina di buon’ora, prese del pane e un otre d’acqua, e lo diede ad Agar, mettendoglielo sulle spalle; le diede anche il fanciullo, e la mandò via. Ed essa partì e andò errando per il deserto di Beer-Sceba. ");
INSERT INTO ita1927_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","E quando l’acqua dell’otre venne meno, essa lasciò cadere il fanciullo sotto un arboscello. ");
INSERT INTO ita1927_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","E se ne andò, e si pose a sedere dirimpetto, a distanza d’un tiro d’arco; perché diceva: “Ch’io non vegga morire il fanciullo!” E sedendo così dirimpetto, alzò la voce e pianse. ");
INSERT INTO ita1927_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","E Dio udì la voce del ragazzo; e l’angelo dì Dio chiamò Agar dal cielo, e le disse: “Che hai, Agar? non temere, poiché Iddio ha udito la voce del fanciullo là dov’è. ");
INSERT INTO ita1927_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Lèvati, prendi il ragazzo e tienlo per la mano; perché io farò di lui una grande nazione”. ");
INSERT INTO ita1927_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","E Dio le aperse gli occhi, ed ella vide un pozzo d’acqua: e andò, empì d’acqua l’otre, e diè da bere al ragazzo. ");
INSERT INTO ita1927_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","E Dio fu con lui; ed egli crebbe, abitò nel deserto, e fu tirator d’arco; ");
INSERT INTO ita1927_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","dimorò nel deserto di Paran, e sua madre gli prese per moglie una donna del paese d’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Or avvenne in quel tempo che Abimelec, accompagnato da Picol, capo del suo esercito, parlò ad Abrahamo, dicendo: “Iddio è teco in tutto quello che fai; ");
INSERT INTO ita1927_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","or dunque giurami qui, nel nome di Dio, che tu non ingannerai né me, né i miei figliuoli, né i miei nipoti; ma che userai verso di me e verso il paese dove hai dimorato come forestiero, la stessa benevolenza che io ho usata verso di te”. ");
INSERT INTO ita1927_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","E Abrahamo rispose: “Lo giuro”. ");
INSERT INTO ita1927_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","E Abrahamo fece delle rimostranze ad Abimelec per cagione di un pozzo d’acqua, di cui i servi di Abimelec s’erano impadroniti per forza. ");
INSERT INTO ita1927_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","E Abimelec disse: “Io non so chi abbia fatto questo; tu stesso non me l’hai fatto sapere, e io non ne ho sentito parlare che oggi”. ");
INSERT INTO ita1927_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","E Abrahamo prese pecore e buoi e li diede ad Abimelec; e i due fecero alleanza. ");
INSERT INTO ita1927_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Poi Abrahamo mise da parte sette agnelle del gregge. ");
INSERT INTO ita1927_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","E Abimelec disse ad Abrahamo: “Che voglion dire queste sette agnelle che tu hai messe da parte?” ");
INSERT INTO ita1927_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abrahamo rispose: “Tu accetterai dalla mia mano queste sette agnelle, affinché questo mi serva di testimonianza che io ho scavato questo pozzo”. ");
INSERT INTO ita1927_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Perciò egli chiamò quel luogo Beer-Sceba, perché ambedue vi avean fatto giuramento. ");
INSERT INTO ita1927_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Così fecero alleanza a Beer-Sceba. Poi Abimelec, con Picol, capo del suo esercito, si levò, e se ne tornarono nel paese dei Filistei. ");
INSERT INTO ita1927_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","E Abrahamo piantò un tamarindo a Beer-Sceba, e invocò quivi il nome dell’Eterno, l’Iddio della eternità. ");
INSERT INTO ita1927_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","E Abrahamo dimorò come forestiero molto tempo nel paese de’ Filistei. ");
INSERT INTO ita1927_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Dopo queste cose, avvenne che Iddio provò Abrahamo, e gli disse: “Abrahamo!” Ed egli rispose: “Eccomi”. ");
INSERT INTO ita1927_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","E Dio disse: “Prendi ora il tuo figliuolo, il tuo unico, colui che ami, Isacco, e vattene nel paese di Moriah, e offrilo quivi in olocausto sopra uno dei monti che ti dirò”. ");
INSERT INTO ita1927_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","E Abrahamo levatosi la mattina di buon’ora, mise il basto al suo asino, prese con sé due de’ suoi servitori e Isacco suo figliuolo, spaccò delle legna per l’olocausto, poi partì per andare al luogo che Dio gli avea detto. ");
INSERT INTO ita1927_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Il terzo giorno, Abrahamo alzò gli occhi e vide da lontano il luogo. ");
INSERT INTO ita1927_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","E Abrahamo disse ai suoi servitori: “Rimanete qui con l’asino; io ed il ragazzo andremo fin colà e adoreremo; poi torneremo a voi”. ");
INSERT INTO ita1927_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","E Abrahamo prese le legna per l’olocausto e le pose addosso a Isacco suo figliuolo; poi prese in mano sua il fuoco e il coltello, e tutti e due s’incamminarono assieme. ");
INSERT INTO ita1927_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","E Isacco parlò ad Abrahamo suo padre e disse: “Padre mio!” Abrahamo rispose: “Eccomi qui, figlio mio”. E Isacco: “Ecco il fuoco e le legna; ma dov’è l’agnello per l’olocausto?” ");
INSERT INTO ita1927_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abrahamo rispose: “Figliuol mio, Iddio se lo provvederà l’agnello per l’olocausto”. E camminarono ambedue assieme. ");
INSERT INTO ita1927_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","E giunsero al luogo che Dio gli avea detto, e Abrahamo edificò quivi l’altare, e vi accomodò la legna; legò Isacco suo figliuolo, e lo mise sull’altare, sopra la legna. ");
INSERT INTO ita1927_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","E Abrahamo stese la mano e prese il coltello per scannare il suo figliuolo. ");
INSERT INTO ita1927_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ma l’angelo dell’Eterno gli gridò dal cielo e disse: “Abrahamo, Abrahamo”. ");
INSERT INTO ita1927_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","E quegli rispose: “Eccomi”. E l’angelo: “Non metter la mano addosso al ragazzo, e non gli fare alcun male; poiché ora so che tu temi Iddio, giacché non m’hai rifiutato il tuo figliuolo, l’unico tuo”. ");
INSERT INTO ita1927_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","E Abrahamo alzò gli occhi, guardò, ed ecco dietro a sé un montone, preso per le corna in un cespuglio. E Abrahamo andò, prese il montone, e l’offerse in olocausto invece del suo figliuolo. ");
INSERT INTO ita1927_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","E Abrahamo pose nome a quel luogo Iehovah-jireh. Per questo si dice oggi: “Al monte dell’Eterno sarà provveduto”. ");
INSERT INTO ita1927_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","L’angelo dell’Eterno chiamò dal cielo Abrahamo una seconda volta, e disse: ");
INSERT INTO ita1927_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Io giuro per me stesso, dice l’Eterno, che, siccome tu hai fatto questo e non m’hai rifiutato il tuo figliuolo, l’unico tuo, ");
INSERT INTO ita1927_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","io certo ti benedirò e moltiplicherò la tua progenie come le stelle del cielo e come la rena ch’è sul lido del mare; e la tua progenie possederà la porta de’ suoi nemici. ");
INSERT INTO ita1927_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","E tutte le nazioni della terra saranno benedette nella tua progenie, perché tu hai ubbidito alla mia voce”. ");
INSERT INTO ita1927_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Poi Abrahamo se ne tornò ai suoi servitori; e si levarono, e se n’andarono insieme a Beer-Sceba. E Abrahamo dimorò a Beer-Sceba. ");
INSERT INTO ita1927_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Dopo queste cose avvenne che fu riferito ad Abrahamo questo: “Ecco Milca ha partorito anch’ella de’ figliuoli a Nahor, tuo fratello: ");
INSERT INTO ita1927_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uz, suo primogenito, Buz suo fratello, Kemuel padre d’Aram, ");
INSERT INTO ita1927_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Hazo, Pildash, Jidlaf e Bethuel”. ");
INSERT INTO ita1927_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","E Bethuel generò Rebecca. Questi otto Milca partorì a Nahor, fratello d’Abrahamo. ");
INSERT INTO ita1927_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","E la concubina di lui, che si chiamava Reumah, partorì anch’essa Thebah, Gaam, Tahash e Maaca. ");
INSERT INTO ita1927_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Or la vita di Sara fu di centoventisette anni. Tanti furon gli anni della vita di Sara. ");
INSERT INTO ita1927_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","E Sara morì a Kiriat-Arba, che è Hebron, nel paese di Canaan; e Abrahamo venne a far duolo di Sara e a piangerla. ");
INSERT INTO ita1927_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Poi Abrahamo si levò di presso al suo morto, e parlò ai figliuoli di Heth, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Io sono straniero e avventizio fra voi; datemi la proprietà di un sepolcro fra voi, affinché io seppellisca il mio morto e me lo tolga d’innanzi”. ");
INSERT INTO ita1927_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","E i figliuoli di Heth risposero ad Abrahamo dicendogli: ");
INSERT INTO ita1927_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Ascoltaci, signore; tu sei fra noi un principe di Dio; seppellisci il tuo morto nel migliore dei nostri sepolcri; nessun di noi ti rifiuterà il suo sepolcro perché tu vi seppellisca il tuo morto”. ");
INSERT INTO ita1927_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","E Abrahamo si levò, s’inchinò dinanzi al popolo del paese, dinanzi ai figliuoli di Heth, e parlò loro dicendo: ");
INSERT INTO ita1927_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","“Se piace a voi ch’io tolga il mio morto d’innanzi a me e lo seppellisca, ascoltatemi, e intercedete per me presso Efron figliuolo di Zohar ");
INSERT INTO ita1927_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","perché mi ceda la sua spelonca di Macpela che è all’estremità del suo campo, e me la dia per l’intero suo prezzo, come sepolcro che m’appartenga fra voi”. ");
INSERT INTO ita1927_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Or Efron sedeva in mezzo ai figliuoli di Heth; ed Efron, lo Hitteo, rispose ad Abrahamo in presenza dei figliuoli di Heth, di tutti quelli che entravano per la porta della sua città, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“No, mio signore, ascoltami! Io ti dono il campo, e ti dono la spelonca che v’è; te ne fo dono, in presenza de’ figliuoli del mio popolo; seppellisci il tuo morto”. ");
INSERT INTO ita1927_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","E Abrahamo s’inchinò dinanzi al popolo del paese, ");
INSERT INTO ita1927_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","e parlò ad Efron in presenza del popolo del paese, dicendo: “Deh, ascoltami! Io ti darò il prezzo del campo; accettalo da me, e io seppellirò quivi il mio morto”. ");
INSERT INTO ita1927_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ed Efron rispose ad Abrahamo, dicendogli: ");
INSERT INTO ita1927_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Signor mio, ascoltami! Un pezzo di terreno di quattrocento sicli d’argento, che cos’è fra me e te? Seppellisci dunque il tuo morto”. ");
INSERT INTO ita1927_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","E Abrahamo fece a modo di Efron; e Abrahamo pesò a Efron il prezzo ch’egli avea detto in presenza de’ figliuoli di Heth, quattrocento sicli d’argento, di buona moneta mercantile. ");
INSERT INTO ita1927_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Così il campo di Efron ch’era a Macpela dirimpetto a Mamre, il campo con la caverna che v’era, e tutti gli alberi ch’erano nel campo e in tutti i confini all’intorno, ");
INSERT INTO ita1927_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","furono assicurati come proprietà d’Abrahamo, in presenza de’ figliuoli di Heth e di tutti quelli ch’entravano per la porta della città di Efron. ");
INSERT INTO ita1927_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Dopo questo, Abrahamo seppellì Sara sua moglie nella spelonca del campo di Macpela dirimpetto a Mamre, che è Hebron, nel paese di Canaan. ");
INSERT INTO ita1927_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","E il campo e la spelonca che v’è, furono assicurati ad Abrahamo, dai figliuoli di Heth, come sepolcro di sua proprietà. ");
INSERT INTO ita1927_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Or Abrahamo era vecchio e d’età avanzata; e l’Eterno avea benedetto Abrahamo in ogni cosa. ");
INSERT INTO ita1927_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","E Abrahamo disse al più antico servo di casa sua, che aveva il governo di tutti i suoi beni: “Deh, metti la tua mano sotto la mia coscia; ");
INSERT INTO ita1927_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","e io ti farò giurare per l’Eterno, l’Iddio dei cieli e l’Iddio della terra, che tu non prenderai per moglie al mio figliuolo alcuna delle figliuole de’ Cananei, fra i quali dimoro; ");
INSERT INTO ita1927_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ma andrai al mio paese e al mio parentado, e vi prenderai una moglie per il mio figliuolo, per Isacco”. ");
INSERT INTO ita1927_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Il servo gli rispose: “Forse quella donna non vorrà seguirmi in questo paese; dovrò io allora ricondurre il tuo figliuolo nei paese donde tu sei uscito?” ");
INSERT INTO ita1927_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","E Abrahamo gli disse: “Guardati dal ricondurre colà il mio figliuolo! ");
INSERT INTO ita1927_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","L’Eterno, l’Iddio dei cieli, che mi trasse dalla casa di mio padre e dal mio paese natale e mi parlò e mi giurò dicendo: Io darò alla tua progenie questo paese, egli stesso manderà il suo angelo davanti a te, e tu prenderai di là una moglie per il mio figliuolo. ");
INSERT INTO ita1927_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","E se la donna non vorrà seguirti, allora sarai sciolto da questo giuramento che ti faccio fare; soltanto, non ricondurre colà il mio figliuolo”. ");
INSERT INTO ita1927_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","E il servo pose la mano sotto la coscia d’Abrahamo suo signore, e gli giurò di fare com’egli chiedeva. ");
INSERT INTO ita1927_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Poi il servo prese dieci cammelli fra i cammelli del suo signore, e si partì, avendo a sua disposizione tutti i beni del suo signore; e, messosi in viaggio, andò in Mesopotamia, alla città di Nahor. ");
INSERT INTO ita1927_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","E, fatti riposare sulle ginocchia i cammelli fuori della città presso a un pozzo d’acqua, verso sera, all’ora in cui le donne escono ad attinger acqua, disse: ");
INSERT INTO ita1927_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","“O Eterno, Dio del mio signore Abrahamo, deh, fammi fare quest’oggi un felice incontro, e usa benignità verso Abrahamo mio signore! ");
INSERT INTO ita1927_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ecco, io sto qui presso a questa sorgente; e le figlie degli abitanti della città usciranno ad attinger acqua. ");
INSERT INTO ita1927_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Fa’ che la fanciulla alla quale dirò: Deh, abbassa la tua brocca perch’io beva e che mi risponderà Bevi, e darò da bere anche ai tuoi cammelli, sia quella che tu hai destinata al tuo servo Isacco. E da questo comprenderò che tu hai usato benignità verso il mio signore”. ");
INSERT INTO ita1927_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Non aveva ancora finito di parlare, quand’ecco uscire con la sua brocca sulla spalla, Rebecca, figliuola di Bethuel figlio di Milca, moglie di Nahor fratello d’Abrahamo. ");
INSERT INTO ita1927_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","La fanciulla era molto bella d’aspetto, vergine, e uomo alcuno non l’avea conosciuta. Ella scese alla sorgente, empì la brocca, e risalì. ");
INSERT INTO ita1927_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","E il servo le corse incontro, e le disse: “Deh, dammi a bere un po’ d’acqua della tua brocca”. ");
INSERT INTO ita1927_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ed ella rispose: “Bevi, signor mio”; e s’affrettò a calarsi la brocca sulla mano, e gli diè da bere. ");
INSERT INTO ita1927_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","E quand’ebbe finito di dargli da bere, disse: “Io ne attingerò anche per i tuoi cammelli finché abbian bevuto a sufficienza”. ");
INSERT INTO ita1927_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","E presto vuotò la sua brocca nell’abbeveratoio, corse di nuovo al pozzo ad attingere acqua, e ne attinse per tutti i cammelli di lui. ");
INSERT INTO ita1927_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","E quell’uomo la contemplava in silenzio, per sapere se l’Eterno avesse o no fatto prosperare il suo viaggio. ");
INSERT INTO ita1927_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","E quando i cammelli ebbero finito di bere, l’uomo prese un anello d’oro del peso di mezzo siclo, e due braccialetti del peso di dieci sicli d’oro, per i polsi di lei, e disse: ");
INSERT INTO ita1927_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","“Di chi sei figliuola? deh, dimmelo. V’è posto in casa di tuo padre per albergarci?” ");
INSERT INTO ita1927_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ed ella rispose: “Son figliuola di Bethuel figliuolo di Milca, ch’ella partorì a Nahor”. ");
INSERT INTO ita1927_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","E aggiunse: “C’è da noi strame e foraggio assai, e anche posto da albergare”. ");
INSERT INTO ita1927_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","E l’uomo s’inchinò, adorò l’Eterno, e disse: ");
INSERT INTO ita1927_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“Benedetto l’Eterno, l’Iddio d’Abrahamo mio signore, che non ha cessato d’esser benigno e fedele verso il mio signore! Quanto a me, l’Eterno mi ha messo sulla via della casa dei fratelli del mio signore”. ");
INSERT INTO ita1927_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","E la fanciulla corse a raccontare queste cose a casa di sua madre. ");
INSERT INTO ita1927_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Or Rebecca aveva un fratello chiamato Labano. E Labano corse fuori da quell’uomo alla sorgente. ");
INSERT INTO ita1927_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Com’ebbe veduto l’anello e i braccialetti ai polsi di sua sorella ed ebbe udite le parole di Rebecca sua sorella che diceva: “Quell’uomo m’ha parlato così”, venne a quell’uomo, ed ecco ch’egli se ne stava presso ai cammelli, vicino alla sorgente. ");
INSERT INTO ita1927_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","E disse: “Entra, benedetto dall’Eterno! perché stai fuori? Io ho preparato la casa e un luogo per i cammelli”. ");
INSERT INTO ita1927_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","L’uomo entrò in casa, e Labano scaricò i cammelli, diede strame e foraggio ai cammelli, e portò acqua per lavare i piedi a lui e a quelli ch’eran con lui. ");
INSERT INTO ita1927_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Poi gli fu posto davanti da mangiare; ma egli disse: “Non mangerò finché non abbia fatto la mia ambasciata”. E l’altro disse: “Parla”. ");
INSERT INTO ita1927_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","E quegli: “Io sono servo d’Abrahamo. ");
INSERT INTO ita1927_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","L’Eterno ha benedetto abbondantemente il mio signore, ch’è divenuto grande; gli ha dato pecore e buoi, argento e oro, servi e serve, cammelli e asini. ");
INSERT INTO ita1927_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Or Sara, moglie del mio signore, ha partorito nella sua vecchiaia un figliuolo al mio padrone, che gli ha dato tutto quel che possiede. ");
INSERT INTO ita1927_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","E il mio signore m’ha fatto giurare, dicendo: Non prenderai come moglie per il mio figliuolo alcuna delle figlie de’ Cananei, nel paese de’ quali dimoro; ");
INSERT INTO ita1927_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ma andrai alla casa di mio padre e al mio parentado e vi prenderai una moglie per il mio figliuolo. ");
INSERT INTO ita1927_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","E io dissi al mio padrone: Forse quella donna non mi vorrà seguire. ");
INSERT INTO ita1927_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ed egli rispose: L’Eterno, nel cospetto del quale ho camminato, manderà il suo angelo teco e farà prosperare il tuo viaggio, e tu prenderai al mio figliuolo una moglie del mio parentado e della casa di mio padre. ");
INSERT INTO ita1927_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Sarai sciolto dal giuramento che ti fo fare, quando sarai andato dal mio parentado; e, se non vorranno dartela, allora sarai sciolto dal giuramento che mi fai. ");
INSERT INTO ita1927_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Oggi sono arrivato alla sorgente, e ho detto: O Eterno, Dio del mio signore Abrahamo, se pur ti piace far prosperare il viaggio che ho intrapreso, ");
INSERT INTO ita1927_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ecco, io mi fermo presso questa sorgente; fa’ che la fanciulla che uscirà ad attinger acqua, alla quale dirò: Deh, dammi da bere un po’ d’acqua della tua brocca, ");
INSERT INTO ita1927_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","e che mi dirà: Bevi pure e ne attingerò anche per i tuoi cammelli, sia la moglie che l’Eterno ha destinata al figliuolo del mio signore. ");
INSERT INTO ita1927_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","E avanti che avessi finito di parlare in cuor mio, ecco uscir fuori Rebecca con la sua brocca sulla spalla, scendere alla sorgente e attinger l’acqua. Allora io le ho detto: ");
INSERT INTO ita1927_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Deh, dammi da bere! Ed ella s’è affrettata a calare la brocca dalla spalla, e m’ha risposto: Bevi! e darò da bere anche ai tuoi cammelli. Così ho bevuto io ed ella ha abbeverato anche i cammelli. ");
INSERT INTO ita1927_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Poi l’ho interrogata, e le ho detto: Di chi sei figliuola? Ed ella ha risposto: Son figliuola di Bethuel figlio di Nahor, che Milca gli partorì. Allora io le ho messo l’anello al naso e i braccialetti ai polsi. ");
INSERT INTO ita1927_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","E mi sono inchinato, ho adorato l’Eterno e ho benedetto l’Eterno, l’Iddio d’Abrahamo mio signore, che m’ha condotto per la retta via a prendere per il figliuolo di lui la figliuola del fratello del mio signore. ");
INSERT INTO ita1927_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","E ora, se volete usare benignità e fedeltà verso il mio signore, ditemelo; e se no, ditemelo lo stesso, e io mi volgerò a destra o a sinistra”. ");
INSERT INTO ita1927_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Allora Labano e Bethuel risposero e dissero: “La cosa procede dall’Eterno; noi non possiam dirti né mal né bene. ");
INSERT INTO ita1927_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ecco, Rebecca ti sta dinanzi, prendila, va’, e sia ella moglie del figliuolo del tuo signore, come l’Eterno ha detto”. ");
INSERT INTO ita1927_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","E quando il servo d’Abrahamo ebbe udito le loro parole si prostrò a terra dinanzi all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Il servo trasse poi fuori oggetti d’argento e oggetti d’oro, e vesti, e li dette a Rebecca; e donò anche delle cose preziose al fratello e alla madre di lei. ");
INSERT INTO ita1927_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Poi mangiarono e bevvero, egli e gli nomini ch’eran con lui, e passaron quivi la notte. La mattina, quando si furono levati, il servo disse: “Lasciatemi tornare al mio signore”. ");
INSERT INTO ita1927_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","E il fratello e la madre di Rebecca dissero: “Rimanga la fanciulla ancora alcuni giorni con noi, almeno una diecina; poi se ne andrà”. Ma egli rispose loro: ");
INSERT INTO ita1927_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","“Non mi trattenete, giacché l’Eterno ha fatto prosperare il mio viaggio; lasciatemi partire, affinché io me ne torni al mio signore”. ");
INSERT INTO ita1927_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Allora dissero: “Chiamiamo la fanciulla e sentiamo lei stessa”. ");
INSERT INTO ita1927_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Chiamarono Rebecca, e le dissero: “Vuoi tu andare con quest’uomo?” Ed ella rispose: ");
INSERT INTO ita1927_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","“Sì, andrò”. Così lasciarono andare Rebecca loro sorella e la sua balia col servo d’Abrahamo e la sua gente. ");
INSERT INTO ita1927_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","E benedissero Rebecca e le dissero: “Sorella nostra, possa tu esser madre di migliaia di miriadi, e possa la tua progenie possedere la porta de’ suoi nemici!” ");
INSERT INTO ita1927_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","E Rebecca si levò con le sue serve e montarono sui cammelli e seguirono quell’uomo. E il servo prese Rebecca e se ne andò. ");
INSERT INTO ita1927_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Or Isacco era tornato dal pozzo di Lachai-Roi, ed abitava nel paese del mezzodì. ");
INSERT INTO ita1927_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Isacco era uscito, sul far della sera, per meditare nella campagna; e, alzati gli occhi, guardò, ed ecco venir de’ cammelli. ");
INSERT INTO ita1927_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","E Rebecca, alzati anch’ella gli occhi, vide Isacco, saltò giù dal cammello, e disse al servo: ");
INSERT INTO ita1927_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","“Chi è quell’uomo che viene pel campo incontro a noi?” Il servo rispose: “E’ il mio signore”. Ed ella, preso il suo velo, se ne coprì. ");
INSERT INTO ita1927_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","E il servo raccontò a Isacco tutto quello che avea fatto. ");
INSERT INTO ita1927_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","E Isacco menò Rebecca nella tenda di Sara sua madre, se la prese, ed ella divenne sua moglie, ed egli l’amò. Così Isacco fu consolato dopo la morte di sua madre. ");
INSERT INTO ita1927_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Poi Abrahamo prese un’altra moglie, per nome Ketura. ");
INSERT INTO ita1927_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","E questa gli partorì Zimran, Jokshan, Medan, Madian, Jishbak e Shuach. ");
INSERT INTO ita1927_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokshan generò Sceba e Dedan. I figliuoli di Dedan furono gli Asshurim, Letushim ed i Leummim. ");
INSERT INTO ita1927_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","E i figliuoli di Madian furono Efa, Efer, Hanoch, Abida ed Eldaa. Tutti questi furono i figliuoli di Ketura. ");
INSERT INTO ita1927_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","E Abrahamo dette tutto quello che possedeva a Isacco; ");
INSERT INTO ita1927_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","ma ai figliuoli delle sue concubine fece dei doni, e, mentre era ancora in vita, li mandò lungi dal suo figliuolo Isacco, verso levante, nel paese d’oriente. ");
INSERT INTO ita1927_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Or tutto il tempo della vita d’Abrahamo fu di centosettanta cinque anni. ");
INSERT INTO ita1927_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Poi Abrahamo spirò in prospera vecchiezza, attempato e sazio di giorni, e fu riunito al suo popolo. ");
INSERT INTO ita1927_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","E Isacco e Ismaele, suoi figliuoli, io seppellirono nella spelonca di Macpela nel campo di Efron figliuolo di Tsoar lo Hitteo, ch’è dirimpetto a Mamre: ");
INSERT INTO ita1927_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","campo, che Abrahamo avea comprato dai figliuoli di Heth. Quivi furon sepolti Abrahamo e Sara sua moglie. ");
INSERT INTO ita1927_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","E dopo la morte d’Abrahamo, Iddio benedisse Isacco figliuolo di lui; e Isacco dimorò presso il pozzo di Lachai-Roi. ");
INSERT INTO ita1927_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Or questi sono i discendenti d’Ismaele, figliuolo d’Abrahamo, che Agar, l’Egiziana, serva di Sara, avea partorito ad Abrahamo. ");
INSERT INTO ita1927_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Questi sono i nomi de’ figliuoli d’Ismaele, secondo le loro generazioni: Nebaioth, il primogenito d’Ismaele; poi Kedar, Adbeel, Mibsam, ");
INSERT INTO ita1927_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Duma, Massa, Hadar, Tema, Jethur, ");
INSERT INTO ita1927_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Nafish e Kedma. ");
INSERT INTO ita1927_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Questi sono i figliuoli d’Ismaele, e questi i loro nomi, secondo i loro villaggi e i loro accampamenti. Furono i dodici capi dei loro popoli. ");
INSERT INTO ita1927_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","E gli anni della vita d’Ismaele furono centotrenta sette; poi spirò, morì, e fu riunito al suo popolo. ");
INSERT INTO ita1927_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","E i suoi figliuoli abitarono da Havila fino a Shur, ch’è dirimpetto all’Egitto, andando verso l’Assiria. Egli si stabilì di faccia a tutti i suoi fratelli. ");
INSERT INTO ita1927_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","E questi sono i discendenti d’Isacco, figliuolo d’Abrahamo. ");
INSERT INTO ita1927_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Abrahamo generò Isacco; e Isacco era in età di quarant’anni quando prese per moglie Rebecca, figliuola di Bethuel, l’Arameo di Paddan-Aram, e sorella di Labano, l’Arameo. ");
INSERT INTO ita1927_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isacco pregò istantemente l’Eterno per sua moglie, perch’ella era sterile. L’Eterno l’esaudì, e Rebecca, sua moglie, concepì. ");
INSERT INTO ita1927_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","E i bambini si urtavano nel suo seno; ed ella disse: “Se così è, perché vivo?” E andò a consultare l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","E l’Eterno le disse: “Due nazioni sono nel tuo seno, e due popoli separati usciranno dalle tue viscere. Uno dei due popoli sarà più forte dell’altro, e il maggiore servirà il minore”. ");
INSERT INTO ita1927_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","E quando venne per lei il tempo di partorire, ecco ch’ella aveva due gemelli nel seno. ");
INSERT INTO ita1927_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","E il primo che uscì fuori era rosso, e tutto quanto come un mantello di pelo; e gli fu posto nome Esaù. ");
INSERT INTO ita1927_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Dopo uscì il suo fratello, che con la mano teneva il calcagno di Esaù; e gli fu posto nome Giacobbe. Or Isacco era in età di sessant’anni quando Rebecca li partorì. ");
INSERT INTO ita1927_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","I due fanciulli crebbero, ed Esaù divenne un esperto cacciatore, un uomo di campagna, e Giacobbe un uomo tranquillo, che se ne stava nelle tende. ");
INSERT INTO ita1927_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Or Isacco amava Esaù, perché la cacciagione era di suo gusto; e Rebecca amava Giacobbe. ");
INSERT INTO ita1927_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Or come Giacobbe s’era fatto cuocere una minestra, Esaù giunse dai campi, tutto stanco. ");
INSERT INTO ita1927_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ed Esaù disse a Giacobbe: “Deh, dammi da mangiare un po’ di cotesta minestra rossa; perché sono stanco”. Per questo fu chiamato Edom. ");
INSERT INTO ita1927_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","E Giacobbe gli rispose: “Vendimi prima di tutto la tua primogenitura”. ");
INSERT INTO ita1927_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ed Esaù disse: “Ecco io sto per morire; che mi giova la primogenitura?” ");
INSERT INTO ita1927_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","E Giacobbe disse: “Prima, giuramelo”. Ed Esaù glielo giurò, e vendé la sua primogenitura a Giacobbe. ");
INSERT INTO ita1927_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","E Giacobbe diede a Esaù del pane e della minestra di lenticchie. Ed egli mangiò e bevve; poi si levò, e se ne andò. Così Esaù sprezzò la primogenitura. ");
INSERT INTO ita1927_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Or ci fu la carestia nel paese, oltre la prima carestia che c’era stata al tempo d’Abrahamo. E Isacco andò da Abimelec, re dei Filistei, a Gherar. ");
INSERT INTO ita1927_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","E l’Eterno gli apparve e gli disse: “Non scendere in Egitto; dimora nel paese che io ti dirò. ");
INSERT INTO ita1927_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Soggiorna in questo paese, e io sarò teco e ti benedirò, poiché io darò a te e alla tua progenie tutti questi paesi, e manterrò il giuramento che feci ad Abrahamo tuo padre, ");
INSERT INTO ita1927_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","e moltiplicherò la tua progenie come le stelle del cielo, darò alla tua progenie tutti questi paesi, e tutte le nazioni della terra saranno benedette nella tua progenie, ");
INSERT INTO ita1927_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","perché Abrahamo ubbidì alla mia voce e osservò quello che gli avevo ordinato, i miei comandamenti, i miei statuti e le mie leggi”. ");
INSERT INTO ita1927_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","E Isacco dimorò in Gherar. ");
INSERT INTO ita1927_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","E quando la gente del luogo gli faceva delle domande intorno alla sua moglie, egli rispondeva: “E’ mia sorella”; perché avea paura di dire: “E’ mia moglie”. “Non vorrei”, egli pensava, “che la gente del luogo avesse ad uccidermi, a motivo di Rebecca”. Poiché ella era di bell’aspetto. ");
INSERT INTO ita1927_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ora, prolungandosi quivi il suo soggiorno, avvenne che Abimelec re de’ Filistei, mentre guardava dalla finestra, vide Isacco che scherzava con Rebecca sua moglie. ");
INSERT INTO ita1927_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","E Abimelec chiamò Isacco, e gli disse: “Certo, costei è tua moglie; come mai dunque, hai detto: E mia sorella?” E Isacco rispose: “Perché dicevo: Non vorrei esser messo a morte a motivo di lei”. ");
INSERT INTO ita1927_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","E Abimelec: “Che cos’è questo che ci hai fatto? Poco è mancato che qualcuno del popolo si giacesse con tua moglie, e tu ci avresti tirato addosso una gran colpa”. ");
INSERT INTO ita1927_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","E Abimelec diede quest’ordine a tutto il popolo: “Chiunque toccherà quest’uomo o sua moglie sia messo a morte”. ");
INSERT INTO ita1927_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isacco seminò in quel paese, e in quell’anno raccolse il centuplo; e l’Eterno lo benedisse. ");
INSERT INTO ita1927_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Quest’uomo divenne grande, andò crescendo sempre più, finché diventò grande oltremisura. ");
INSERT INTO ita1927_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Fu padrone di greggi di pecore, di mandre di buoi e di numerosa servitù. I Filistei lo invidiavano; ");
INSERT INTO ita1927_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","e perciò turarono ed empiron di terra tutti i pozzi che i servi di suo padre aveano scavati al tempo d’Abrahamo suo padre. ");
INSERT INTO ita1927_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","E Abimelec disse ad Isacco: “Vattene da noi, poiché tu sei molto più potente di noi”. ");
INSERT INTO ita1927_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isacco allora si partì di là, s’accampò nella valle di Gherar, e quivi dimorò. ");
INSERT INTO ita1927_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","E Isacco scavò di nuovo i pozzi d’acqua ch’erano stati scavati al tempo d’Abrahamo suo padre, e che i Filistei avean turati dopo la morte d’Abrahamo; e pose loro gli stessi nomi che avea loro posto suo padre. ");
INSERT INTO ita1927_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","E i servi d’Isacco scavarono nella valle, e vi trovarono un pozzo d’acqua viva. ");
INSERT INTO ita1927_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ma i pastori di Gherar altercarono coi pastori d’Isacco, dicendo: “L’acqua è nostra”. Ed egli chiamò il pozzo Esek, perché quelli aveano conteso con lui. ");
INSERT INTO ita1927_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Poi i servi scavarono un altro pozzo, e per questo ancora quelli altercarono. E Isacco lo chiamò Sitna. ");
INSERT INTO ita1927_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Allora egli si partì di là, e scavò un altro pozzo per il quale quelli non altercarono. Ed egli lo chiamò Rehoboth “perché”, disse, “ora l’Eterno ci ha messi al largo, e noi prospereremo nel paese”. ");
INSERT INTO ita1927_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Poi di là Isacco salì a Beer-Sceba. ");
INSERT INTO ita1927_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","E l’Eterno gli apparve quella stessa notte, e gli disse: “Io sono l’Iddio d’Abrahamo tuo padre; non temere, poiché io sono teco e ti benedirò e moltiplicherò la tua progenie per amor d’Abrahamo mio servo”. ");
INSERT INTO ita1927_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ed egli edificò quivi un altare, invocò il nome dell’Eterno, e vi piantò la sua tenda. E i servi d’Isacco scavaron quivi un pozzo. ");
INSERT INTO ita1927_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimelec andò a lui da Gherar con Ahuzath, suo amico, e con Picol, capo del suo esercito. ");
INSERT INTO ita1927_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","E Isacco disse loro: “Perché venite da me, giacché mi odiate e m’avete mandato via dal vostro paese?” ");
INSERT INTO ita1927_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","E quelli risposero: “Noi abbiam chiaramente veduto che l’Eterno è teco; e abbiam detto: Si faccia ora un giuramento fra noi, fra noi e te, e facciam lega teco. ");
INSERT INTO ita1927_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Giura che non ci farai alcun male, così come noi non t’abbiamo toccato, e non t’abbiamo fatto altro che del bene, e t’abbiamo lasciato andare in pace. Tu sei ora benedetto dall’Eterno”. ");
INSERT INTO ita1927_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","E Isacco fece loro un convito, ed essi mangiarono e bevvero. ");
INSERT INTO ita1927_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","La mattina dipoi si levarono di buon’ora e si fecero scambievole giuramento. Poi Isacco li accomiatò, e quelli si partirono da lui in pace. ");
INSERT INTO ita1927_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Or avvenne che, in quello stesso giorno, i servi d’Isacco gli vennero a dar notizia del pozzo che aveano scavato, dicendogli: “Abbiam trovato dell’acqua”. ");
INSERT INTO ita1927_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ed egli lo chiamò Sciba. Per questo la città porta il nome di Beer-Sceba, fino al di d’oggi. ");
INSERT INTO ita1927_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Or Esaù, in età di quarant’anni, prese per moglie Judith, figliuola di Beeri, lo Hitteo, e Basmath, figliuola di Elon, lo Hitteo. ");
INSERT INTO ita1927_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","(H26-34) Esse furon cagione d’amarezza d’animo a Isacco ed a Rebecca. ");
INSERT INTO ita1927_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Or avvenne, quando Isacco era divenuto vecchio e i suoi occhi indeboliti non ci vedevano più, ch’egli chiamò Esaù, suo figliuolo maggiore, e gli disse: “Figliuol mio!” ");
INSERT INTO ita1927_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","E quello rispose: “Eccomi!” E Isacco: “Ecco, io sono vecchio, e non so il giorno della mia morte. ");
INSERT INTO ita1927_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Deh, prendi ora le tue armi, il tuo turcasso e il tuo arco, vattene fuori ai campi, prendimi un po’ di caccia, ");
INSERT INTO ita1927_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","e preparami una pietanza saporita di quelle che mi piacciono; portamela perch’io la mangi e l’anima mia ti benedica prima ch’io muoia”. ");
INSERT INTO ita1927_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ora Rebecca stava ad ascoltare, mentre Isacco parlava ad Esaù suo figliuolo. Ed Esaù se n’andò ai campi per fare qualche caccia e portarla a suo padre. ");
INSERT INTO ita1927_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","E Rebecca parlò a Giacobbe suo figliuolo, e gli disse: “Ecco, io ho udito tuo padre che parlava ad Esaù tuo fratello, e gli diceva: ");
INSERT INTO ita1927_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Portami un po’ di caccia e fammi una pietanza saporita perch’io la mangi e ti benedica nel cospetto dell’Eterno, prima ch’io muoia. ");
INSERT INTO ita1927_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Or dunque, figliuol mio, ubbidisci alla mia voce e fa’ quello ch’io ti comando. ");
INSERT INTO ita1927_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Va’ ora al gregge e prendimi due buoni capretti; e io ne farò una pietanza saporita per tuo padre, di quelle che gli piacciono. ");
INSERT INTO ita1927_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","E tu la porterai a tuo padre, perché la mangi, e così ti benedica prima di morire”. ");
INSERT INTO ita1927_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","E Giacobbe disse a Rebecca sua madre: “Ecco, Esaù mio fratello è peloso, e io no. ");
INSERT INTO ita1927_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Può darsi che mio padre mi tasti; sarò allora da lui reputato un ingannatore, e mi trarrò addosso una maledizione, invece di una benedizione”. ");
INSERT INTO ita1927_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","E sua madre gli rispose: “Questa maledizione ricada su me, figliuol mio! Ubbidisci pure alla mia voce, e va’ a prendermi i capretti”. ");
INSERT INTO ita1927_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Egli dunque andò a prenderli, e li menò a sua madre; e sua madre ne preparò una pietanza saporita, di quelle che piacevano al padre di lui. ");
INSERT INTO ita1927_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Poi Rebecca prese i più bei vestiti di Esaù suo figliuolo maggiore, i quali aveva in casa presso di sé, e li fece indossare a Giacobbe suo figliuolo minore; ");
INSERT INTO ita1927_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","e con le pelli de’ capretti gli coprì le mani e il collo, ");
INSERT INTO ita1927_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ch’era senza peli. Poi mise in mano a Giacobbe suo figliuolo la pietanza saporita e il pane che avea preparato. ");
INSERT INTO ita1927_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ed egli venne a suo padre e gli disse: “Padre mio!” E Isacco rispose: “Eccomi; chi sei tu, figliuol mio?” ");
INSERT INTO ita1927_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","E Giacobbe disse a suo padre: “Sono Esaù, il tuo primogenito. Ho fatto come tu m’hai detto. Deh, lèvati, mettiti a sedere e mangia della mia caccia, affinché l’anima tua mi benedica”. ");
INSERT INTO ita1927_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","E Isacco disse ai suo figliuolo: “Come hai fatto a trovarne così presto, figliuol mio?” E quello rispose: “Perché l’Eterno, il tuo Dio, l’ha fatta venire sulla mia via”. ");
INSERT INTO ita1927_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","E Isacco disse a Giacobbe: “Fatti vicino, figliuol mio, ch’io ti tasti, per sapere se sei proprio il mio figliuolo Esaù, o no”. ");
INSERT INTO ita1927_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Giacobbe dunque s’avvicinò a Isacco suo padre e, come questi l’ebbe tastato, disse: “La voce è la voce di Giacobbe; ma le mani son le mani d’Esaù”. ");
INSERT INTO ita1927_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","E non lo riconobbe, perché le mani di lui eran pelose come le mani di Esaù suo fratello: e lo benedisse. E disse: ");
INSERT INTO ita1927_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","“Sei tu proprio il mio figliuolo Esaù?” Egli rispose: “Sì”. ");
INSERT INTO ita1927_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","E Isacco gli disse: “Servimi ch’io mangi della caccia del mio figliuolo e l’anima mia ti benedica”. E Giacobbe lo servì, e Isacco mangiò. Giacobbe gli portò anche del vino, ed egli bevve. ");
INSERT INTO ita1927_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Poi Isacco suo padre gli disse: “Deh, fatti vicino e baciami, figliuol mio”. ");
INSERT INTO ita1927_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ed egli s’avvicinò e lo baciò. E Isacco senti l’odore de’ vestiti di lui, e lo benedisse dicendo: “Ecco, l’odor del mio figliuolo è come l’odor d’un campo, che l’Eterno ha benedetto. ");
INSERT INTO ita1927_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Iddio ti dia della rugiada de’ cieli e della grassezza della terra e abbondanza di frumento e di vino. ");
INSERT INTO ita1927_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ti servano i popoli e le nazioni s’inchinino davanti a te. Sii padrone de’ tuoi fratelli e i figli di tua madre s’inchinino davanti a te. Maledetto sia chiunque ti maledice, benedetto sia chiunque ti benedice!” ");
INSERT INTO ita1927_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","E avvenne che, come Isacco ebbe finito di benedire Giacobbe e Giacobbe se n’era appena andato dalla presenza d’Isacco suo padre, Esaù suo fratello giunse dalla sua caccia. ");
INSERT INTO ita1927_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Anch’egli preparò una pietanza saporita la portò a suo padre, e gli disse: “Lèvisi mio padre, e mangi della caccia del suo figliuolo, affinché l’anima tua mi benedica”. ");
INSERT INTO ita1927_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","E Isacco suo padre gli disse: “Chi sei tu?” Ed egli rispose: “Sono Esaù, il tuo figliuolo primogenito”. ");
INSERT INTO ita1927_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isacco fu preso da un tremito fortissimo, e disse: “E allora, chi è che ha preso della caccia e me l’ha portata? Io ho mangiato di tutto prima che tu venissi, e l’ho benedetto; e benedetto ei sarà”. ");
INSERT INTO ita1927_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Quando Esaù ebbe udite le parole di suo padre, dette in un grido forte ed amarissimo. Poi disse a suo padre: “Benedici anche me, padre mio!” ");
INSERT INTO ita1927_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","E Isacco rispose: “Il tuo fratello è venuto con inganno e ha preso la tua benedizione”. ");
INSERT INTO ita1927_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ed Esaù: “Non è forse a ragione ch’egli è stato chiamato Giacobbe? M’ha già soppiantato due volte: mi tolse la mia primogenitura, ed ecco che ora m’ha tolta la mia benedizione”. Poi aggiunse: “Non hai tu riserbato qualche benedizione per me?” ");
INSERT INTO ita1927_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","E Isacco rispose e disse a Esaù: “Ecco io l’ho costituito tuo padrone, e gli ho dato tutti i suoi fratelli per servi, e l’ho provvisto di frumento e di vino; che potrei dunque fare per te, figliuol mio?” ");
INSERT INTO ita1927_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ed Esaù disse a suo padre: “Non hai tu che questa benedizione, padre mio? Benedici anche me, o padre mio!” Ed Esaù alzò la voce e pianse. ");
INSERT INTO ita1927_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","E Isacco suo padre rispose e gli disse: “Ecco, la tua dimora sarà priva della grassezza della terra e della rugiada che scende dai cieli. ");
INSERT INTO ita1927_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Tu vivrai della tua spada, e sarai servo del tuo fratello; ma avverrà che, menando una vita errante, tu spezzerai il suo giogo di sul tuo collo”. ");
INSERT INTO ita1927_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ed Esaù prese a odiare Giacobbe a motivo della benedizione datagli da suo padre; e disse in cuor suo: “I giorni del lutto di mio padre si avvicinano; allora ucciderò il mio fratello Giacobbe”. ");
INSERT INTO ita1927_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Furon riferite a Rebecca le parole di Esaù, suo figliuolo maggiore; ed ella mandò a chiamare Giacobbe, suo figliuolo minore, e gli disse: “Ecco, Esaù, tuo fratello, si consola riguardo a te, proponendosi d’ucciderti. ");
INSERT INTO ita1927_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Or dunque, figliuol mio, ubbidisci alla mia voce; lèvati, e fuggi a Charan da Labano mio fratello; ");
INSERT INTO ita1927_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","e trattienti quivi qualche tempo, finché il furore del tuo fratello sia passato, ");
INSERT INTO ita1927_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","finché l’ira del tuo fratello si sia stornata da te ed egli abbia dimenticato quello che tu gli hai fatto; e allora io manderò a farti ricondurre di la. Perché sarei io privata di voi due in uno stesso giorno?” ");
INSERT INTO ita1927_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","E Rebecca disse ad Isacco: “Io sono disgustata della vita a motivo di queste figliuole di Heth. Se Giacobbe prende in moglie, tra le figliuole di Heth, tra le figliuole del paese, una donna come quelle, che mi giova la vita?” ");
INSERT INTO ita1927_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Allora Isacco chiamò Giacobbe, lo benedisse e gli diede quest’ordine: “Non prender moglie tra le figliuole di Canaan. ");
INSERT INTO ita1927_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Lèvati, vattene in Paddan-Aram, alla casa di Bethuel, padre di tua madre, e prenditi moglie di là, tra le figliuole di Labano, fratello di tua madre. ");
INSERT INTO ita1927_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","E l’Iddio onnipotente ti benedica, ti renda fecondo e ti moltiplichi, in guisa che tu diventi un’assemblea di popoli, ");
INSERT INTO ita1927_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","e ti dia la benedizione d’Abrahamo: a te, e alla tua progenie con te; affinché tu possegga il paese dove sei andato peregrinando, e che Dio donò ad Abrahamo”. ");
INSERT INTO ita1927_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","E Isacco fece partire Giacobbe, il quale se n’andò in Paddan-Aram da Labano, figliuolo di Bethuel, l’Arameo, fratello di Rebecca, madre di Giacobbe e di Esaù. ");
INSERT INTO ita1927_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Or Esaù vide che Isacco avea benedetto Giacobbe e l’avea mandato in Paddan-Aram perché vi prendesse moglie; e che, benedicendolo, gli avea dato quest’ordine: “Non prender moglie tra le figliuole di Canaan”, ");
INSERT INTO ita1927_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","e che Giacobbe aveva ubbidito a suo padre e a sua madre, e se n’era andato in Paddan-Aram. ");
INSERT INTO ita1927_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ed Esaù s’accorse che le figliuole di Canaan dispiacevano ad Isacco suo padre; ");
INSERT INTO ita1927_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","e andò da Ismaele, e prese per moglie, oltre quelle che aveva già, Mahalath, figliuola d’Ismaele, figliuolo d’Abrahamo, sorella di Nebaioth. ");
INSERT INTO ita1927_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Or Giacobbe partì da Beer-Sceba e se n’andò verso Charan. ");
INSERT INTO ita1927_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Capitò in un certo luogo, e vi passò la notte, perché il sole era già tramontato. Prese una delle pietre del luogo, la pose come suo capezzale e si coricò quivi. ");
INSERT INTO ita1927_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","E sognò; ed ecco una scala appoggiata sulla terra, la cui cima toccava il cielo; ed ecco gli angeli di Dio, che salivano e scendevano per la scala. ");
INSERT INTO ita1927_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","E l’Eterno stava al disopra d’essa, e gli disse: “Io sono l’Eterno, l’Iddio d’Abrahamo tuo padre e l’Iddio d’Isacco; la terra sulla quale tu stai coricato, io la darò a te e alla tua progenie; ");
INSERT INTO ita1927_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","e la tua progenie sarà come la polvere della terra, e tu ti estenderai ad occidente e ad oriente, a settentrione e a mezzodì; e tutte le famiglie della terra saranno benedette in te e nella tua progenie. ");
INSERT INTO ita1927_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ed ecco, io son teco, e ti guarderò dovunque tu andrai, e ti ricondurrò in questo paese; poiché io non ti abbandonerò prima d’aver fatto quello che t’ho detto”. ");
INSERT INTO ita1927_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","E come Giacobbe si fu svegliato dal suo sonno, disse: “Certo, l’Eterno è in questo luogo ed io non lo sapevo!” ");
INSERT INTO ita1927_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ed ebbe paura, e disse: “Com’è tremendo questo luogo! Questa non è altro che la casa di Dio, e questa è la porta del cielo!” ");
INSERT INTO ita1927_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","E Giacobbe si levò la mattina di buon’ora, prese la pietra che avea posta come suo capezzale, la eresse in monumento, e versò dell’olio sulla sommità d’essa. ");
INSERT INTO ita1927_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","E pose nome a quel luogo Bethel; ma, prima, il nome della città era Luz. ");
INSERT INTO ita1927_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","E Giacobbe fece un voto, dicendo: “Se Dio è meco, se mi guarda durante questo viaggio che fo, se mi dà pane da mangiare e vesti da coprirmi, ");
INSERT INTO ita1927_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","e se ritorno sano e salvo alla casa del padre mio, l’Eterno sarà il mio Dio; ");
INSERT INTO ita1927_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","e questa pietra che ho eretta in monumento, sarà la casa di Dio; e di tutto quello che tu darai a me, io, certamente, darò a te la decima”. ");
INSERT INTO ita1927_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Poi Giacobbe si mise in cammino e andò nel paese degli Orientali. ");
INSERT INTO ita1927_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","E guardò, e vide un pozzo in un campo; ed ecco tre greggi di pecore, giacenti lì presso; poiché a quel pozzo si abbeveravano i greggi; e la pietra sulla bocca del pozzo era grande. ");
INSERT INTO ita1927_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Quivi s’adunavano tutti i greggi; i pastori rotolavan la pietra di sulla bocca del pozzo, abbeveravano le pecore, poi rimettevano al posto la pietra sulla bocca del pozzo. ");
INSERT INTO ita1927_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","E Giacobbe disse ai pastori: “Fratelli miei, di dove siete?” E quelli risposero: “Siamo di Charan”. ");
INSERT INTO ita1927_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ed egli disse loro: “Conoscete voi Labano, figliuolo di Nahor?” Ed essi: “Lo conosciamo”. ");
INSERT INTO ita1927_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ed egli disse loro: “Sta egli bene?” E quelli: “Sta bene; ed ecco Rachele, sua figliuola, che viene con le pecore”. ");
INSERT INTO ita1927_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ed egli disse: “Ecco, è ancora pieno giorno, e non è tempo di radunare il bestiame; abbeverate le pecore e menatele al pascolo”. ");
INSERT INTO ita1927_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","E quelli risposero: “Non possiamo, finché tutti i greggi siano radunati; allora si rotola la pietra di sulla bocca del pozzo, e abbeveriamo le pecore”. ");
INSERT INTO ita1927_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Mentr’egli parlava ancora con loro, giunse Rachele con le pecore di suo padre; poich’ella era pastora. ");
INSERT INTO ita1927_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","E quando Giacobbe vide Rachele figliuola di Labano, fratello di sua madre, e le pecore di Labano fratello di sua madre, s’avvicinò, rotolò la pietra di sulla bocca del pozzo, e abbeverò il gregge di Labano fratello di sua madre. ");
INSERT INTO ita1927_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","E Giacobbe baciò Rachele, alzò la voce, e pianse. ");
INSERT INTO ita1927_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","E Giacobbe fe’ sapere a Rachele ch’egli era parente del padre di lei, e ch’era figliuolo di Rebecca. Ed ella corse a dirlo a suo padre. ");
INSERT INTO ita1927_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","E appena Labano ebbe udito le notizie di Giacobbe figliuolo della sua sorella, gli corse incontro, l’abbracciò, lo baciò, e lo menò a casa sua. Giacobbe raccontò a Labano tutte queste cose; ");
INSERT INTO ita1927_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","e Labano gli disse: “Tu sei proprio mie ossa e mia carne!” Ed egli dimorò con lui durante un mese. ");
INSERT INTO ita1927_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Poi Labano disse a Giacobbe: “Perché sei mio parente dovrai tu servirmi per nulla? Dimmi quale dev’essere il tuo salario”. ");
INSERT INTO ita1927_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Or Labano aveva due figliuole: la maggiore si chiamava Lea, e la minore Rachele. ");
INSERT INTO ita1927_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea aveva gli occhi delicati, ma Rachele era avvenente e di bell’aspetto. ");
INSERT INTO ita1927_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","E Giacobbe amava Rachele, e disse a Labano: “Io ti servirò sette anni, per Rachele tua figliuola minore”. ");
INSERT INTO ita1927_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","E Labano rispose: “E’ meglio ch’io la dia a te che ad un altr’uomo; sta’ con me”. ");
INSERT INTO ita1927_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","E Giacobbe servì sette anni per Rachele; e gli parvero pochi giorni, per l’amore che le portava. ");
INSERT INTO ita1927_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","E Giacobbe disse a Labano: “Dammi la mia moglie, poiché il mio tempo è compiuto, ed io andrò da lei”. ");
INSERT INTO ita1927_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Allora Labano radunò tutta la gente del luogo, e fece un convito. ");
INSERT INTO ita1927_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ma, la sera, prese Lea, sua figliuola, e la menò da Giacobbe, il quale entrò da lei. ");
INSERT INTO ita1927_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","E Labano dette la sua serva Zilpa per serva a Lea, sua figliuola. ");
INSERT INTO ita1927_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","L’indomani mattina, ecco che era Lea. E Giacobbe disse a Labano: “Che m’hai fatto? Non è egli per Rachele ch’io t’ho servito? Perché dunque m’hai ingannato?” ");
INSERT INTO ita1927_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","E Labano rispose: “Non è usanza da noi di dare la minore prima della maggiore. Finisci la settimana di questa; ");
INSERT INTO ita1927_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","e ti daremo anche l’altra, per il servizio che presterai da me altri sette anni”. ");
INSERT INTO ita1927_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Giacobbe fece così, e finì la settimana di quello sposalizio; poi Labano gli dette in moglie Rachele sua figliuola. ");
INSERT INTO ita1927_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","E Labano dette la sua serva Bilha per serva a Rachele, sua figliuola. ");
INSERT INTO ita1927_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","E Giacobbe entrò pure da Rachele, ed anche amò Rachele più di Lea, e servì da Labano altri sette anni. ");
INSERT INTO ita1927_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","L’Eterno, vedendo che Lea era odiata, la rese feconda; ma Rachele era sterile. ");
INSERT INTO ita1927_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","E Lea concepì e partorì un figliuolo, al quale pose nome Ruben; perché disse: “L’Eterno ha veduto la mia afflizione; e ora il mio marito mi amerà”. ");
INSERT INTO ita1927_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Poi concepì di nuovo e partorì un figliuolo, e disse: “L’Eterno ha udito ch’io ero odiata, e però m’ha dato anche questo figliuolo”. E lo chiamò Simeone. ");
INSERT INTO ita1927_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","E concepì di nuovo e partorì un figliuolo, e disse: “Questa volta, il mio marito sarà ben unito a me, poiché gli ho partorito tre figliuoli”. Per questo fu chiamato Levi. ");
INSERT INTO ita1927_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","E concepì di nuovo e partorì un figliuolo, e disse: “Questa volta celebrerò l’Eterno”. Perciò gli pose nome Giuda. E cessò d’aver figliuoli. ");
INSERT INTO ita1927_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rachele, vedendo che non dava figliuoli a Giacobbe, portò invidia alla sua sorella, e disse a Giacobbe: “Dammi de’ figliuoli; altrimenti, muoio”. ");
INSERT INTO ita1927_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","E Giacobbe s’accese d’ira contro Rachele, e disse: “Tengo io il luogo di Dio che t’ha negato d’esser feconda?” ");
INSERT INTO ita1927_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ed ella rispose: “Ecco la mia serva Bilha; entra da lei; essa partorirà sulle mie ginocchia, e, per mezzo di lei, avrò anch’io de’ figliuoli”. ");
INSERT INTO ita1927_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ed ella gli diede la sua serva Bilha per moglie, e Giacobbe entrò da lei. ");
INSERT INTO ita1927_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","E Bilha concepì e partorì un figliuolo a Giacobbe. ");
INSERT INTO ita1927_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","E Rachele disse: “Iddio m’ha reso giustizia, ha anche ascoltato la mia voce, e m’ha dato un figliuolo”. Perciò gli pose nome Dan. ");
INSERT INTO ita1927_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","E Bilha, serva di Rachele, concepì ancora e partorì a Giacobbe un secondo figliuolo. ");
INSERT INTO ita1927_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","E Rachele disse: “Io ho sostenuto con mia sorella lotte di Dio, e ho vinto”. Perciò gli pose nome Neftali. ");
INSERT INTO ita1927_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea, vedendo che avea cessato d’aver figliuoli, prese la sua serva Zilpa e la diede a Giacobbe per moglie. ");
INSERT INTO ita1927_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","E Zilpa, serva di Lea, partorì un figliuolo a Giacobbe. ");
INSERT INTO ita1927_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","E Lea disse: “Che fortuna!” E gli pose nome Gad. ");
INSERT INTO ita1927_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Poi Zilpa, serva di Lea, partorì a Giacobbe un secondo figliuolo. ");
INSERT INTO ita1927_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","E Lea disse: “Me felice! ché le fanciulle mi chiameranno beata. Perciò gli pose nome Ascer. ");
INSERT INTO ita1927_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Or Ruben uscì, al tempo della mietitura del grano, e trovò delle mandragole per i campi, e le portò a Lea sua madre. Allora Rachele disse a Lea: “Deh, dammi delle mandragole del tuo figliuolo!” ");
INSERT INTO ita1927_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ed ella le rispose: “Ti par egli poco l’avermi tolto il marito, che mi vuoi togliere anche le mandragole del mio figliuolo?” E Rachele disse: “Ebbene, si giaccia egli teco questa notte, in compenso delle mandragole del tuo figliuolo”. ");
INSERT INTO ita1927_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","E come Giacobbe, in sulla sera, se ne tornava dai campi, Lea uscì a incontrarlo, e gli disse: “Devi entrare da me; poiché io t’ho accaparrato con le mandragole del mio figliuolo”. Ed egli si giacque con lei quella notte. ");
INSERT INTO ita1927_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","E Dio esaudì Lea, la quale concepì e partorì a Giacobbe un quinto figliuolo. ");
INSERT INTO ita1927_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ed ella disse: “Iddio m’ha dato la mia mercede, perché diedi la mia serva a mio marito”. E gli pose nome Issacar. ");
INSERT INTO ita1927_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","E Lea concepì ancora, e partorì a Giacobbe un sesto figliuolo. ");
INSERT INTO ita1927_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","E Lea disse: “Iddio m’ha dotata di buona dote; questa volta il mio marito abiterò con me, poiché gli ho partorito sei figliuoli”. E gli pose nome Zabulon. ");
INSERT INTO ita1927_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Poi partorì una figliuola, e le pose nome Dina. ");
INSERT INTO ita1927_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Iddio si ricordò anche di Rachele; Iddio l’esaudì, e la rese feconda; ");
INSERT INTO ita1927_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","ed ella concepì e partorì un figliuolo, e disse: “Iddio ha tolto il mio obbrobrio”. ");
INSERT INTO ita1927_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","E gli pose nome Giuseppe, dicendo: “L’Eterno m’aggiunga un altro figliuolo”. ");
INSERT INTO ita1927_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Or dopo che Rachele ebbe partorito Giuseppe, Giacobbe disse a Labano: “Dammi licenza, ch’io me ne vada a casa mia, nel mio paese. ");
INSERT INTO ita1927_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Dammi le mie mogli, per le quali t’ho servito, e i miei figliuoli; e lasciami andare; poiché tu ben conosci il servizio che t’ho prestato”. ");
INSERT INTO ita1927_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","E Labano gli disse: “Se ho trovato grazia dinanzi a te, rimanti; giacché credo indovinare che l’Eterno mi ha benedetto per amor tuo”. ");
INSERT INTO ita1927_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Poi disse: “Fissami il tuo salario, e te lo darò”. ");
INSERT INTO ita1927_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Giacobbe gli rispose: “Tu sai in qual modo io t’ho servito, e quel che sia diventato il tuo bestiame nelle mie mani. ");
INSERT INTO ita1927_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Poiché quel che avevi prima ch’io venissi, era poco; ma ora s’è accresciuto oltremodo, e l’Eterno t’ha benedetto dovunque io ho messo il piede. Ora, quando lavorerò io anche per la casa mia?” ");
INSERT INTO ita1927_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labano gli disse: “Che ti darò io?” E Giacobbe rispose: “Non mi dar nulla; se acconsenti a quel che sto per dirti, io pascerò di nuovo i tuoi greggi e n’avrò cura. ");
INSERT INTO ita1927_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Passerò quest’oggi fra mezzo a tutti i tuoi greggi, mettendo da parte, di fra le pecore, ogni agnello macchiato e vaiolato, e ogni agnello nero; e di fra le capre, le vaiolate e le macchiate. E quello sarà il mio salario. ");
INSERT INTO ita1927_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Così, da ora innanzi, il mio diritto risponderà per me nel tuo cospetto, quando verrai ad accertare il mio salario: tutto ciò che non sarà macchiato o vaiolato fra le capre, e nero fra gli agnelli, sarà rubato, se si troverà presso di me”. ");
INSERT INTO ita1927_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","E Labano disse: “Ebbene, sia come tu dici!” ");
INSERT INTO ita1927_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","E quello stesso giorno mise da parte i becchi striati e vaiolati e tutte le capre macchiate e vaiolate, tutto quello che avea del bianco e tutto quel ch’era nero fra gli agnelli, e li affidò ai suoi figliuoli. ");
INSERT INTO ita1927_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","E Labano frappose la distanza di tre giornate di cammino fra se e Giacobbe; e Giacobbe pascolava il rimanente de’ greggi di Labano. ");
INSERT INTO ita1927_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","E Giacobbe prese delle verghe verdi di pioppo, di mandorlo e di platano; vi fece delle scortecciature bianche, mettendo allo scoperto il bianco delle verghe. ");
INSERT INTO ita1927_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Poi collocò le verghe che avea scortecciate, in vista delle pecore, ne’ rigagnoli, negli abbeveratoi dove le pecore venivano a bere; ed entravano in caldo quando venivano a bere. ");
INSERT INTO ita1927_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Le pecore dunque entravano in caldo avendo davanti quelle verghe, e figliavano agnelli striati, macchiati e vaiolati. ");
INSERT INTO ita1927_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Poi Giacobbe metteva da parte questi agnelli, e faceva volger gli occhi delle pecore verso tutto quello ch’era striato e tutto quel ch’era nero nel gregge di Labano. Egli si formò così dei greggi a parte, che non unì ai greggi di Labano. ");
INSERT INTO ita1927_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Or avveniva che, tutte le volte che le pecore vigorose del gregge entravano in caldo, Giacobbe metteva le verghe ne’ rigagnoli, in vista delle pecore, perché le pecore entrassero in caldo vicino alle verghe; ");
INSERT INTO ita1927_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ma quando le pecore erano deboli, non ve le metteva; così gli agnelli deboli erano di Labano, e i vigorosi di Giacobbe. ");
INSERT INTO ita1927_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","E quest’uomo diventò ricco oltremodo, ed ebbe greggi numerosi, serve, servi, cammelli e asini. ");
INSERT INTO ita1927_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Or Giacobbe udì le parole de’ figliuoli di Labano, che dicevano: “Giacobbe ha tolto tutto quello che era di nostro padre; e con quello ch’era di nostro padre, s’è fatto tutta questa ricchezza”. ");
INSERT INTO ita1927_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Giacobbe osservò pure il volto di Labano; ed ecco, non era più, verso di lui, quello di prima. ");
INSERT INTO ita1927_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","E l’Eterno disse a Giacobbe: “Torna al paese de’ tuoi padri e al tuo parentado; e io sarò teco”. ");
INSERT INTO ita1927_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","E Giacobbe mandò a chiamare Rachele e Lea perché venissero ai campi, presso il suo gregge, e disse loro: ");
INSERT INTO ita1927_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","“Io vedo che il volto di vostro padre non è più, verso di me, quello di prima; ma l’Iddio di mio padre è stato meco. ");
INSERT INTO ita1927_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","E voi sapete che io ho servito il padre vostro con tutto il mio potere, ");
INSERT INTO ita1927_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","mentre vostro padre m’ha ingannato e ha mutato il mio salario dieci volte; ma Dio non gli ha permesso di farmi del male. ");
INSERT INTO ita1927_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Quand’egli diceva: I macchiati saranno il tuo salario, tutto il gregge i figliava agnelli macchiati; e quando diceva: Gli striati saranno il tuo salario, tutto il gregge figliava agnelli striati. ");
INSERT INTO ita1927_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Così Iddio ha tolto il bestiame a vostro padre, e me l’ha dato. ");
INSERT INTO ita1927_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","E una volta avvenne, al tempo che le pecore entravano in caldo, ch’io alzai gli occhi, e vidi, in sogno, che i maschi che montavano le femmine, erano striati macchiati o chiazzati. ");
INSERT INTO ita1927_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","E l’angelo di Dio mi disse nel sogno: Giacobbe! E io risposi: Eccomi! ");
INSERT INTO ita1927_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ed egli: Alza ora gli occhi e guarda; tutti i maschi che montano le femmine, sono striati, macchiati o chiazzati; perché ho veduto tutto quel che Labano ti fa. ");
INSERT INTO ita1927_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Io son l’Iddio di Bethel, dove tu ungesti un monumento e mi facesti un voto, Ora lèvati, partiti da questo paese, e torna al tuo paese natìo”. ");
INSERT INTO ita1927_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rachele e Lea risposero e gli dissero: “Abbiam noi forse ancora qualche parte o eredità in casa di nostro padre? ");
INSERT INTO ita1927_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Non ci ha egli trattate da straniere, quando ci ha vendute e ha per di più mangiato il nostro danaro? ");
INSERT INTO ita1927_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Tutte le ricchezze che Dio ha tolte a nostro padre, sono nostre e dei nostri figliuoli; or dunque, fa’ tutto quello che Dio t’ha detto”. ");
INSERT INTO ita1927_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Allora Giacobbe si levò, mise i suoi figliuoli e le sue mogli sui cammelli, ");
INSERT INTO ita1927_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","e menò via tutto il suo bestiame, tutte le sostanze che aveva acquistate, il bestiame che gli apparteneva e che aveva acquistato in Paddan-Aram, per andarsene da Isacco suo padre, nel paese di Canaan. ");
INSERT INTO ita1927_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Or mentre Labano se n’era andato a tosare le sue pecore, Rachele rubò gl’idoli di suo padre. ");
INSERT INTO ita1927_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","E Giacobbe si partì furtivamente da Labano, l’Arameo, senza dirgli che voleva fuggire. ");
INSERT INTO ita1927_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Così se ne fuggì, con tutto quello che aveva; e si levò, passò il fiume, e si diresse verso il monte di Galaad. ");
INSERT INTO ita1927_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Il terzo giorno, fu annunziato a Labano che Giacobbe se n’era fuggito. ");
INSERT INTO ita1927_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Allora egli prese seco i suoi fratelli, lo inseguì per sette giornate di cammino, e lo raggiunse al monte di Galaad. ");
INSERT INTO ita1927_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ma Dio venne a Labano l’Arameo, in un sogno della notte, e gli disse: “Guardati dal parlare a Giacobbe, né in bene né in male”. ");
INSERT INTO ita1927_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Labano dunque raggiunse Giacobbe. Or Giacobbe avea piantato la sua tenda sul monte; e anche Labano e i suoi fratelli avean piantato le loro, sul monte di Galaad. ");
INSERT INTO ita1927_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Allora Labano disse a Giacobbe: “Che hai fatto, partendoti da me furtivamente, e menando via le mie figliuole come prigioniere di guerra? ");
INSERT INTO ita1927_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Perché te ne sei fuggito di nascosto, e sei partito da me furtivamente, e non m’hai avvertito? Io t’avrei accomiatato con gioia e con canti, a suon di timpano di cetra. ");
INSERT INTO ita1927_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","E non m’hai neppur permesso di baciare i miei figliuoli e le mie figliuole! Tu hai agito stoltamente. ");
INSERT INTO ita1927_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ora è in poter mio di farvi del male; ma l’Iddio del padre vostro mi parlò la notte scorsa, dicendo: Guardati dal parlare a Giacobbe, né in bene né in male. ");
INSERT INTO ita1927_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ora dunque te ne sei certo andato, perché anelavi alla casa di tuo padre; ma perché hai rubato i miei dèi?” ");
INSERT INTO ita1927_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","E Giacobbe rispose a Labano: “Egli è che avevo paura, perché dicevo fra me che tu m’avresti potuto togliere per forza le tue figliuole. ");
INSERT INTO ita1927_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ma chiunque sia colui presso il quale avrai trovato i tuoi dèi, egli deve morire! In presenza dei nostri fratelli, riscontra ciò ch’è tuo fra le cose mie, e prenditelo!” Or Giacobbe ignorava che Rachele avesse rubato gl’idoli. ");
INSERT INTO ita1927_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Labano dunque entrò nella tenda di Giacobbe, nella tenda di Lea e nella tenda delle due serve, ma non trovò nulla. E uscito dalla tenda di Lea, entrò nella tenda di Rachele. ");
INSERT INTO ita1927_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Or Rachele avea preso gl’idoli, li avea messi nel basto del cammello, e vi s’era posta sopra a sedere. Labano frugò tutta la tenda, e non trovò nulla. ");
INSERT INTO ita1927_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ed ella disse a suo padre: “Non s’abbia il mio signore a male s’io non posso alzarmi davanti a te, perché ho le solite ricorrenze delle donne”. Ed egli cercò ma non trovò gl’idoli. ");
INSERT INTO ita1927_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Allora Giacobbe si adirò e contese con Labano e riprese a dirgli: “Qual è il mio delitto, qual è il mio peccato, perché tu m’abbia inseguito con tanto ardore? ");
INSERT INTO ita1927_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Tu hai frugato tutta la mia roba; che hai trovato di tutta la roba di casa tua? Mettilo qui davanti ai miei e tuoi fratelli, e giudichino loro fra noi due! ");
INSERT INTO ita1927_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ecco vent’anni che sono stato con te; le tue pecore e le tue capre non hanno abortito, e io non ho mangiato i montoni del tuo gregge. ");
INSERT INTO ita1927_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Io non t’ho mai portato quel che le fiere aveano squarciato; n’ho subìto il danno io; tu mi ridomandavi conto di quello ch’era stato rubato di giorno o rubato di notte. ");
INSERT INTO ita1927_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Di giorno, mi consumava il caldo; di notte, il gelo; e il sonno fuggiva dagli occhi miei. ");
INSERT INTO ita1927_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ecco vent’anni che sono in casa tua; t’ho servito quattordici anni per le tue due figliuole, e sei anni per le tue pecore, e tu hai mutato il mio salario dieci volte. ");
INSERT INTO ita1927_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Se l’Iddio di mio padre, l’Iddio d’Abrahamo e il Terrore d’Isacco non fosse stato meco, certo, tu m’avresti ora a rimandato vuoto. Iddio ha veduto la mia afflizione e la fatica delle mie mani, e la notte scorsa ha pronunziato la sua sentenza”. ");
INSERT INTO ita1927_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","E Labano rispose a Giacobbe, dicendo: “Queste figliuole son mie figliuole, questi figliuoli son miei figliuoli, queste pecore son pecore mie, e tutto quel che vedi è mio. E che posso io fare oggi a queste mie figliuole o ai loro figliuoli ch’esse hanno partorito? ");
INSERT INTO ita1927_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Or dunque vieni, facciamo un patto fra me e te, e serva esso di testimonianza fra me e te”. ");
INSERT INTO ita1927_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Giacobbe prese una pietra, e la eresse in monumento. ");
INSERT INTO ita1927_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","E Giacobbe disse ai suoi fratelli: “Raccogliete delle pietre”. Ed essi presero delle pietre, ne fecero un mucchio, e presso il mucchio mangiarono. ");
INSERT INTO ita1927_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","E Labano chiamò quel mucchio Jegar-Sahadutha, e Giacobbe lo chiamò Galed. ");
INSERT INTO ita1927_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","E Labano disse: “Questo mucchio è oggi testimonio fra me e te”. Perciò fu chiamato Galed, ");
INSERT INTO ita1927_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","e anche Mitspa, perché Labano disse: “L’Eterno tenga l’occhio su me e su te quando non ci potremo vedere l’un l’altro. ");
INSERT INTO ita1927_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Se tu affliggi le mie figliuole e se prendi altre mogli oltre le mie figliuole, non un uomo sarà con noi; ma, bada, Iddio sarà testimonio fra me e te”. ");
INSERT INTO ita1927_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Labano disse ancora a Giacobbe: “Ecco questo mucchio di pietre, ed ecco il monumento che io ho eretto fra me e te. ");
INSERT INTO ita1927_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Sia questo mucchio un testimonio e sia questo monumento un testimonio che io non passerò oltre questo mucchio per andare a te, e che tu non passerai oltre questo mucchio e questo monumento, per far del male. ");
INSERT INTO ita1927_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","L’Iddio d’Abrahamo e l’Iddio di Nahor, l’Iddio del padre loro, sia giudice fra noi!” E Giacobbe giurò per il Terrore d’Isacco suo padre. ");
INSERT INTO ita1927_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Poi Giacobbe offrì un sacrifizio sul monte, e invitò i suoi fratelli a mangiar del pane. Essi dunque mangiarono del pane, e passarono la notte sul monte. ");
INSERT INTO ita1927_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","La mattina, Labano si levò di buon’ora, baciò i suoi figliuoli e le sue figliuole, e li benedisse. Poi Labano se ne andò, e tornò a casa sua. ");
INSERT INTO ita1927_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Giacobbe continuò il suo cammino, e gli si fecero incontro degli angeli di Dio. ");
INSERT INTO ita1927_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","E come Giacobbe li vide, disse: “Questo è il campo di Dio”; e pose nome a quel luogo Mahanaim. ");
INSERT INTO ita1927_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Giacobbe mandò davanti a sé dei messi a Esaù suo fratello, nel paese di Seir, nella campagna di Edom. ");
INSERT INTO ita1927_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","E dette loro quest’ordine: “Direte così ad Esaù, mio signore: Così dice il tuo servo Giacobbe: Io ho soggiornato presso Labano, e vi sono rimasto fino ad ora; ");
INSERT INTO ita1927_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","ho buoi, asini, pecore, servi e serve; e lo mando a dire al mio signore, per trovar grazia agli occhi tuoi”. ");
INSERT INTO ita1927_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","E i messi tornarono a Giacobbe, dicendo: “Siamo andati dal tuo fratello Esaù, ed eccolo che ti viene incontro con quattrocento uomini”. ");
INSERT INTO ita1927_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Allora Giacobbe fu preso da gran paura ed angosciato; divise in due schiere la gente ch’era con lui, i greggi, gli armenti, i cammelli, e disse: ");
INSERT INTO ita1927_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","“Se Esaù viene contro una delle schiere e la batte, la schiera che rimane potrà salvarsi”. ");
INSERT INTO ita1927_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Poi Giacobbe disse: “O Dio d’Abrahamo mio padre, Dio di mio padre Isacco! O Eterno, che mi dicesti: Torna al tuo paese e al tuo parentado e ti farò del bene, ");
INSERT INTO ita1927_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","io son troppo piccolo per esser degno di tutte le benignità che hai usate e di tutta la fedeltà che hai dimostrata al tuo servo; poiché io passai questo Giordano col mio bastone, e ora son divenuto due schiere. ");
INSERT INTO ita1927_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Liberami, ti prego, dalle mani di mio fratello, dalle mani di Esaù; perché io ho paura di lui e temo che venga e mi dia addosso, non risparmiando né madre né bambini. ");
INSERT INTO ita1927_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","E tu dicesti: Certo, io ti farò del bene, e farò diventare la tua progenie come la rena del mare, la quale non si può contare da tanta che ce n’è”. ");
INSERT INTO ita1927_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ed egli passò quivi quella notte; e di quello che avea sotto mano prese di che fare un dono al suo fratello Esaù: ");
INSERT INTO ita1927_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","duecento capre e venti capri, duecento pecore e venti montoni, ");
INSERT INTO ita1927_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","trenta cammelle allattanti coi loro parti, quaranta vacche e dieci tori, venti asine e dieci puledri. ");
INSERT INTO ita1927_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","E li consegnò ai suoi servi, gregge per gregge separatamente, e disse ai suoi servi: “Passate dinanzi a me, e fate che vi sia qualche intervallo fra gregge e gregge”. ");
INSERT INTO ita1927_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","E dette quest’ordine al primo: “Quando il mio fratello Esaù t’incontrerà e ti chiederà: Di chi sei? dove vai? a chi appartiene questo gregge che va dinanzi a te? ");
INSERT INTO ita1927_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","tu risponderai: Al tuo servo Giacobbe, è un dono inviato al mio signore Esaù; ed ecco, egli stesso vien dietro a noi”. ");
INSERT INTO ita1927_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","E dette lo stesso ordine al secondo, al terzo, e a tutti quelli che seguivano i greggi, dicendo: “In questo modo parlerete a Esaù, quando lo troverete, ");
INSERT INTO ita1927_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","e direte: “Ecco il tuo servo Giacobbe, che viene egli stesso dietro a noi”. Perché diceva: “Io lo placherò col dono che mi precede, e, dopo, vedrò la sua faccia; forse, mi farà buona accoglienza”. ");
INSERT INTO ita1927_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Così il dono andò innanzi a lui, ed egli passò la notte nell’accampamento. ");
INSERT INTO ita1927_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","E si levò, quella notte, prese le sue due mogli, le sue due serve, i suoi undici figliuoli, e passò il guado di Iabbok. ");
INSERT INTO ita1927_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Li prese, fece loro passare il torrente, e lo fece passare a tutto quello che possedeva. ");
INSERT INTO ita1927_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Giacobbe rimase solo, e un uomo lottò con lui fino all’apparir dell’alba. ");
INSERT INTO ita1927_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","E quando quest’uomo vide che non lo poteva vincere, gli toccò la commessura dell’anca; e la commessura dell’anca di Giacobbe fu slogata, mentre quello lottava con lui. ");
INSERT INTO ita1927_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","E l’uomo disse: “Lasciami andare, ché spunta l’alba”. E Giacobbe: “Non ti lascerò andare prima che tu m’abbia benedetto!” ");
INSERT INTO ita1927_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","E l’altro gli disse: Qual è il tuo nome?” Ed egli rispose: “Giacobbe”. ");
INSERT INTO ita1927_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","E quello disse: “Il tuo nome non sarà più Giacobbe, ma Israele, poiché tu hai lottato con Dio e con gli uomini, ed hai vinto”. ");
INSERT INTO ita1927_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","E Giacobbe gli chiese: “Deh, palesami il tuo nome”. E quello rispose: “Perché mi chiedi il mio nome?” ");
INSERT INTO ita1927_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","E lo benedisse quivi. E Giacobbe chiamò quel luogo Peniel, “perché”, disse, “ho veduto Iddio a faccia a faccia, e la mia vita è stata risparmiata”. ");
INSERT INTO ita1927_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Il sole si levava com’egli ebbe passato Peniel; e Giacobbe zoppicava dell’anca. ");
INSERT INTO ita1927_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Per questo, fino al dì d’oggi, gl’Israeliti non mangiano il nervo della coscia che passa per la commessura dell’anca, perché quell’uomo avea toccato la commessura dell’anca di Giacobbe, al punto del nervo della coscia. ");
INSERT INTO ita1927_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Giacobbe alzò gli occhi, guardò, ed ecco Esaù che veniva, avendo seco quattrocento uomini. Allora divise i figliuoli fra Lea, Rachele e le due serve. ");
INSERT INTO ita1927_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","E mise davanti le serve e i loro figliuoli, poi Lea e i suoi figliuoli, e da ultimo Rachele e Giuseppe. ");
INSERT INTO ita1927_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ed egli stesso passò dinanzi a loro, s’inchinò fino a terra sette volte, finché si fu avvicinato al suo fratello. ");
INSERT INTO ita1927_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ed Esaù gli corse incontro, l’abbracciò, gli si gettò al collo, e lo baciò: e piansero. ");
INSERT INTO ita1927_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Poi Esaù, alzando gli occhi, vide le donne e i fanciulli, e disse: “Chi son questi qui che hai teco?” Giacobbe rispose: “Sono i figliuoli che Dio s’è compiaciuto di dare al tuo servo”. ");
INSERT INTO ita1927_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Allora le serve s’accostarono, esse e i loro figliuoli, e s’inchinarono. ");
INSERT INTO ita1927_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","S’accostarono anche Lea e i suoi figliuoli, e s’inchinarono. Poi s’accostarono Giuseppe e Rachele, e s’inchinarono. ");
INSERT INTO ita1927_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ed Esaù disse: “Che ne vuoi fare di tutta quella schiera che ho incontrata?” Giacobbe rispose: “E’ per trovar grazia agli occhi del mio signore”. ");
INSERT INTO ita1927_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ed Esaù: “Io ne ho assai della roba, fratel mio; tienti per te ciò ch’è tuo”. ");
INSERT INTO ita1927_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ma Giacobbe disse: “No, ti prego; se ho trovato grazia agli occhi tuoi, accetta il dono dalla mia mano, giacché io ho veduto la tua faccia, come uno vede la faccia di Dio, e tu m’hai fatto gradevole accoglienza. ");
INSERT INTO ita1927_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Deh, accetta il mio dono che t’è stato recato; poiché Iddio m’ha usato grande bontà, e io ho di tutto”. E insisté tanto, che Esaù l’accettò. ");
INSERT INTO ita1927_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Poi Esaù disse: “Partiamo, incamminiamoci, e io andrò innanzi a te”. ");
INSERT INTO ita1927_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","E Giacobbe rispose: “Il mio signore sa che i fanciulli son di tenera età, e che ho con me delle pecore e delle vacche che allattano; se si forzassero per un giorno solo a camminare, le bestie morrebbero tutte. ");
INSERT INTO ita1927_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Deh, passi il mio signore innanzi al suo servo; e io me ne verrò pian piano, al passo del bestiame che mi precederà, e al passo de’ fanciulli, finché arrivi presso al mio signore, a Seir”. ");
INSERT INTO ita1927_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ed Esaù disse: “Permetti almeno ch’io lasci con te un po’ della gente che ho meco”. Ma Giacobbe rispose: “E perché questo? Basta ch’io trovi grazia agli occhi del mio signore”. ");
INSERT INTO ita1927_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Così Esaù, in quel giorno stesso, rifece il cammino verso Seir. ");
INSERT INTO ita1927_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Giacobbe partì alla volta di Succoth e edificò una casa per sé, e fece delle capanne per il suo bestiame; e per questo quel luogo fu chiamato Succoth. ");
INSERT INTO ita1927_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Poi Giacobbe, tornando da Paddan-Aram, arrivò sano e salvo alla città di Sichem, nel paese di Canaan, e piantò le tende dirimpetto alla città. ");
INSERT INTO ita1927_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","E comprò dai figliuoli di Hemor, padre di Sichem, per cento pezzi di danaro, la parte del campo dove avea piantato le sue tende. ");
INSERT INTO ita1927_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ed eresse quivi un altare, e lo chiamò El-Elohè-Israel. ");
INSERT INTO ita1927_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Or Dina, la figliuola che Lea aveva partorito a Giacobbe, uscì per vedere le figliuole del paese. ");
INSERT INTO ita1927_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","E Sichem, figliuolo di Hemor lo Hivveo, principe del paese, vedutala, la rapì, si giacque con lei, e la violentò. ");
INSERT INTO ita1927_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","E l’anima sua s’appassionò per Dina, figliuola di Giacobbe; egli amò la fanciulla, e parlò al cuore di lei. ");
INSERT INTO ita1927_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Poi disse a Hemor suo padre: “Dammi questa fanciulla per moglie”. ");
INSERT INTO ita1927_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Or Giacobbe udì ch’egli avea disonorato la sua figliuola Dina; e come i suoi figliuoli erano ai campi col suo bestiame, Giacobbe si tacque finché non furon tornati. ");
INSERT INTO ita1927_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","E Hemor, padre di Sichem, si recò da Giacobbe per parlargli. ");
INSERT INTO ita1927_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","E i figliuoli di Giacobbe, com’ebbero udito il fatto, tornarono dai campi; e questi uomini furono addolorati e fortemente adirati perché costui aveva commessa un’infamia in Israele, giacendosi con la figliuola di Giacobbe: cosa che non era da farsi. ");
INSERT INTO ita1927_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ed Hemor parlò loro dicendo: “L’anima del mio figliuolo Sichem s’è unita strettamente alla vostra figliuola; deh, dategliela per moglie; ");
INSERT INTO ita1927_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","e imparentatevi con noi; dateci le vostre figliuole, e prendetevi le figliuole nostre. ");
INSERT INTO ita1927_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Voi abiterete con noi, e il paese sarà a vostra disposizione; dimoratevi, trafficatevi, e acquistatevi delle proprietà”. ");
INSERT INTO ita1927_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Allora Sichem disse al padre e ai fratelli di Dina: “Fate ch’io trovi grazia agli occhi vostri, e vi darò quel che mi direte. ");
INSERT INTO ita1927_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Imponetemi pure una gran dote e di gran doni; e io ve li darò come mi direte; ma datemi la fanciulla per moglie”. ");
INSERT INTO ita1927_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","I figliuoli di Giacobbe risposero a Sichem e ad Hemor suo padre, e parlarono loro con astuzia, perché Sichem avea disonorato Dina loro sorella; ");
INSERT INTO ita1927_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","e dissero loro: “Questa cosa non la possiamo fare; non possiam dare la nostra sorella a uno che non è circonciso; giacché questo, per noi, sarebbe un obbrobrio. ");
INSERT INTO ita1927_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Soltanto a questa condizione acconsentiremo alla vostra richiesta: se vorrete essere come siam noi, circoncidendo ogni maschio tra voi. ");
INSERT INTO ita1927_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Allora vi daremo le nostre figliuole, e noi ci prenderemo le figliuole vostre; abiteremo con voi, e diventeremo un popolo solo. ");
INSERT INTO ita1927_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ma se non ci volete ascoltare e non vi volete far circoncidere, noi prenderemo la nostra fanciulla e ce ne andremo”. ");
INSERT INTO ita1927_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Le loro parole piacquero ad Hemor e a Sichem figliuolo di Hemor. ");
INSERT INTO ita1927_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","E il giovine non indugiò a fare la cosa, perché portava affezione alla figliuola di Giacobbe, ed era l’uomo più onorato in tutta la casa di suo padre. ");
INSERT INTO ita1927_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hemor e Sichem, suo figliuolo, vennero alla porta della loro città, e parlarono alla gente della loro città, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Questa è gente pacifica, qui tra noi; rimanga dunque pure nel paese, e vi traffichi; poiché, ecco, il paese è abbastanza ampio per loro. Noi prenderemo le loro figliuole per mogli, e daremo loro le nostre. ");
INSERT INTO ita1927_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ma soltanto a questa condizione questa gente acconsentirà ad abitare con noi per formare un popolo solo: che ogni maschio fra noi sia circonciso, come son circoncisi loro. ");
INSERT INTO ita1927_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Il loro bestiame, le loro sostanze, tutti i loro animali non saran nostri? Acconsentiamo alla loro domanda ed essi abiteranno con noi”. ");
INSERT INTO ita1927_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","E tutti quelli che uscivano dalla porta della città diedero ascolto ad Hemor e a Sichem suo figliuolo; e ogni maschio fu circonciso: ognuno di quelli che uscivano dalla porta della città. ");
INSERT INTO ita1927_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Or avvenne che il terzo giorno, mentre quelli eran sofferenti, due de’ figliuoli di Giacobbe, Simeone e Levi, fratelli di Dina, presero ciascuno la propria spada, assalirono la città che si tenea sicura, e uccisero tutti i maschi. ");
INSERT INTO ita1927_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Passarono anche a fil di spada Hemor e Sichem suo figliuolo, presero Dina dalla casa di Sichem, e uscirono. ");
INSERT INTO ita1927_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","I figliuoli di Giacobbe si gettarono sugli uccisi e saccheggiarono la città, perché la loro sorella era stata disonorata; ");
INSERT INTO ita1927_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","presero i loro greggi, i loro armenti, i loro asini, quello che era in città, e quello che era per i campi, ");
INSERT INTO ita1927_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","e portaron via come bottino tutte le loro ricchezze, tutti i loro piccoli bambini, le loro mogli, e tutto quello che si trovava nelle case. ");
INSERT INTO ita1927_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Allora Giacobbe disse a Simeone ed a Levi: “Voi mi date grande affanno, mettendomi in cattivo odore presso gli abitanti del paese, presso i Cananei ed i Ferezei. Ed io non ho che poca gente; essi si raduneranno contro di me e mi daranno addosso, e sarò distrutto: io con la mia casa”. ");
INSERT INTO ita1927_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ed essi risposero: “Dovrà la nostra sorella esser trattata come una meretrice?” ");
INSERT INTO ita1927_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Iddio disse a Giacobbe: “Lèvati, vattene a Bethel, dimora quivi, e fa’ un altare all’Iddio che ti apparve, quando fuggivi dinanzi al tuo fratello Esaù”. ");
INSERT INTO ita1927_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Allora Giacobbe disse alla sua famiglia e a tutti quelli ch’erano con lui: “Togliete gli dèi stranieri che sono fra voi, purificatevi, e cambiatevi i vestiti; ");
INSERT INTO ita1927_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","e leviamoci, andiamo a Bethel, ed io farò quivi un altare all’Iddio che mi esaudì nel giorno della mia angoscia, e ch’è stato con me nel viaggio che ho fatto”. ");
INSERT INTO ita1927_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ed essi dettero a Giacobbe tutti gli dei stranieri ch’erano nelle loro mani e gli anelli che avevano agli orecchi; e Giacobbe li nascose sotto la quercia ch’è presso a Sichem. ");
INSERT INTO ita1927_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Poi si partirono; e un terrore mandato da Dio invase le città ch’erano intorno a loro; talché non inseguirono i figliuoli di Giacobbe. ");
INSERT INTO ita1927_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Così Giacobbe giunse a Luz, cioè Bethel, ch’è nel paese di Canaan: egli con tutta la gente che avea seco; ");
INSERT INTO ita1927_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","ed edificò quivi un altare, e chiamò quel luogo El-Bethel, perché quivi Iddio gli era apparso, quando egli fuggiva dinanzi al suo fratello. ");
INSERT INTO ita1927_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Allora morì Debora, balia di Rebecca, e fu sepolta al di sotto di Bethel, sotto la quercia, che fu chiamata Allon-Bacuth. ");
INSERT INTO ita1927_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Iddio apparve ancora a Giacobbe, quando questi veniva da Paddan-Aram; e lo benedisse. ");
INSERT INTO ita1927_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","E Dio gli disse: “Il tuo nome è Giacobbe; tu non sarai più chiamato Giacobbe, ma il tuo nome sarà Israele”. E gli mise nome Israele. ");
INSERT INTO ita1927_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","E Dio gli disse: “Io sono l’Iddio onnipotente; sii fecondo e moltiplica; una nazione, anzi una moltitudine di nazioni discenderà da te, e dei re usciranno dai tuoi lombi; ");
INSERT INTO ita1927_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","e darò a te e alla tua progenie dopo di te il paese che detti ad Abrahamo e ad Isacco”. ");
INSERT INTO ita1927_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","E Dio risalì di presso a lui, dal luogo dove gli avea parlato. ");
INSERT INTO ita1927_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","E Giacobbe eresse un monumento di pietra nel luogo dove Iddio gli avea parlato; vi fece sopra una libazione e vi sparse su dell’olio. ");
INSERT INTO ita1927_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","E Giacobbe chiamò Bethel il luogo dove Dio gli avea parlato. ");
INSERT INTO ita1927_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Poi partirono da Bethel; e c’era ancora qualche distanza per arrivare ad Efrata, quando Rachele partorì. Essa ebbe un duro parto; ");
INSERT INTO ita1927_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","e mentre penava a partorire, la levatrice le disse: “Non temere, perché eccoti un altro figliuolo”. ");
INSERT INTO ita1927_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","E com’ella stava per rendere l’anima (perché morì), pose nome al bimbo Ben-Oni; ma il padre lo chiamò Beniamino. ");
INSERT INTO ita1927_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","E Rachele morì, e fu sepolta sulla via di Efrata; cioè di Bethlehem. ");
INSERT INTO ita1927_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","E Giacobbe eresse un monumento sulla tomba di lei. Questo è il monumento della tomba di Rachele, il quale esiste tuttora. ");
INSERT INTO ita1927_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Poi Israele si partì, e piantò la sua tenda al di là di Migdal-Eder. ");
INSERT INTO ita1927_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","E avvenne che, mentre Israele abitava in quel paese, Ruben andò e si giacque con Bilha, concubina di suo padre. E Israele lo seppe. ");
INSERT INTO ita1927_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Or i figliuoli di Giacobbe erano dodici. I figliuoli di Lea: Ruben, primogenito di Giacobbe, Simeone, Levi, Giuda, Issacar, Zabulon. ");
INSERT INTO ita1927_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","I figliuoli di Rachele: Giuseppe e Beniamino. ");
INSERT INTO ita1927_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","I figliuoli di Bilha, serva di Rachele: Dan e Neftali. ");
INSERT INTO ita1927_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","I figliuoli di Zilpa, serva di Lea: Gad e Ascer. Questi sono i figliuoli di Giacobbe che gli nacquero in Paddan-Aram. ");
INSERT INTO ita1927_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","E Giacobbe venne da Isacco suo padre a Mamre, a Kiriath-Arba, cioè Hebron, dove Abrahamo e Isacco aveano soggiornato. ");
INSERT INTO ita1927_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","E i giorni d’Isacco furono centottant’anni. ");
INSERT INTO ita1927_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","E Isacco spirò, morì, e fu raccolto presso il suo popolo, vecchio e sazio di giorni; ed Esaù e Giacobbe, suoi figliuoli, lo seppellirono. ");
INSERT INTO ita1927_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Questa è la posterità di Esaù, cioè Edom. ");
INSERT INTO ita1927_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esaù prese le sue mogli tra le figliuole de’ Cananei: Ada, figliuola di Elon, lo Hitteo; Oholibama, figliuola di Ana, ");
INSERT INTO ita1927_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","figliuola di Tsibeon, lo Hivveo; e Basmath, figliuola d’Ismaele, sorella di Nebaioth. ");
INSERT INTO ita1927_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada partorì ad Esaù Elifaz; ");
INSERT INTO ita1927_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Basmath partorì Reuel; e Oholibama partorì Ieush, Ialam e Korah. Questi sono i figliuoli di Esaù, che gli nacquero nel paese di Canaan. ");
INSERT INTO ita1927_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esaù prese le sue mogli, i suoi figliuoli, le sue figliuole, tutte le persone della sua casa, i suoi greggi, tutto il suo bestiame e tutti i beni che aveva messi assieme nel paese di Canaan, e se ne andò in un altro paese, lontano da Giacobbe suo fratello; ");
INSERT INTO ita1927_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","giacché i loro beni erano troppo grandi perch’essi potessero dimorare assieme; e il paese nel quale soggiornavano, non era loro sufficiente a motivo del loro bestiame. ");
INSERT INTO ita1927_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ed Esaù abitò sulla montagna di Seir, Esaù è Edom. ");
INSERT INTO ita1927_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Questa è la posterità di Esaù, padre degli Edomiti, sulla montagna di Seir. ");
INSERT INTO ita1927_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Questi sono i nomi dei figliuoli di Esaù: Elifaz, figliuolo di Ada, moglie di Esaù; Reuel, figliuolo di Basmath, moglie di Esaù. ");
INSERT INTO ita1927_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","I figliuoli di Elifaz furono: Teman, Omar, Tsefo, Gatam e Kenaz. ");
INSERT INTO ita1927_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna era la concubina di Elifaz, figliuolo di Esaù; essa partorì ad Elifaz Amalek. Questi furono i figliuoli di Ada, moglie di Esaù. ");
INSERT INTO ita1927_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","E questi furono i figliuoli di Reuel: Nahath e Zerach, Shammah e Mizza. Questi furono i figliuoli di Basmath, moglie di Esaù. ");
INSERT INTO ita1927_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","E questi furono i figliuoli di Oholibama, figliuola di Ana, figliuola di Tsibeon, moglie di Esaù; essa partorì a Esaù: Ieush, Ialam e Korah. ");
INSERT INTO ita1927_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Questi sono i capi de’ figliuoli di Esaù: Figliuoli di Elifaz, primogenito di Esaù: il capo Teman, il capo Omar, il capo Tsefo, il capo Kenaz, ");
INSERT INTO ita1927_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","il capo Korah, il capo Gatam, il capo Amalek; questi sono i capi discesi da Elifaz, nel paese di Edom. E sono i figliuoli di Ada. ");
INSERT INTO ita1927_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","E questi sono i figliuoli di Reuel, figliuolo di Esaù: il capo Nahath, il capo Zerach, il capo Shammah, il capo Mizza; questi sono i capi discesi da Reuel, nel paese di Edom. E sono i figliuoli di Basmath, moglie di Esaù. ");
INSERT INTO ita1927_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","E questi sono i figliuoli di Oholibama, moglie di Esaù: il capo Ieush, il capo Ialam, il capo Korah; questi sono i capi discesi da Oholibama, figliuola di Ana, moglie di Esaù. ");
INSERT INTO ita1927_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Questi sono i figliuoli di Esaù, che è Edom, e questi sono i loro capi. ");
INSERT INTO ita1927_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Questi sono i figliuoli di Seir, lo Horeo, che abitavano il paese: Lothan, Shobal, Tsibeon, ");
INSERT INTO ita1927_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Ana, Dishon, Etser e Dishan. Questi sono i capi degli Horei, figliuoli di Seir, nel paese di Edom. ");
INSERT INTO ita1927_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","I figliuoli di Lothan furono: Hori e Hemam; e la sorella di Lothan fu Timna. ");
INSERT INTO ita1927_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","E questi sono i figliuoli di Shobal: Alvan, Manahath, Ebal, Scefo e Onam. ");
INSERT INTO ita1927_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","E questi sono i figliuoli di Tsibeon: Aiah e Ana. Questo e quell’Ana che trovò le acque calde nel deserto, mentre pasceva gli asini di Tsibeon suo padre. ");
INSERT INTO ita1927_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","E questi sono i figliuoli di Ana: Dishon e Oholibama, figliuola di Ana. ");
INSERT INTO ita1927_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","E questi sono i figliuoli di Dishon: Hemdan, Eshban, Ithran e Keran. ");
INSERT INTO ita1927_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Questi sono i figliuoli di Etser: Bilhan, Zaavan e Akan. ");
INSERT INTO ita1927_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Questi sono i figliuoli di Dishan: Uts e Aran. ");
INSERT INTO ita1927_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Questi sono i capi degli Horei: il capo Lothan, il capo Shobal, il capo Tsibeon, il capo Ana, ");
INSERT INTO ita1927_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","il capo Dishon, il capo Etser, il capo Dishan. Questi sono i capi degli Horei, i capi ch’essi ebbero nel paese di Seir. ");
INSERT INTO ita1927_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Questi sono i re che regnarono nel paese di Edom, prima che alcun re regnasse sui figliuoli d’Israele: ");
INSERT INTO ita1927_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, figliuolo di Beor, regnò in Edom, e il nome della sua città fu Dinhaba. ");
INSERT INTO ita1927_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela morì, e Iobab, figliuolo di Zerach, di Botsra, regnò in luogo suo. ");
INSERT INTO ita1927_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Iobab morì e Husham, del paese de’ Temaniti, regnò in luogo suo. ");
INSERT INTO ita1927_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husham morì, e Hadad, figliuolo di Bedad, che sconfisse i Madianiti ne’ campi di Moab, regnò in luogo suo; e il nome della sua città fu Avith. ");
INSERT INTO ita1927_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad morì, e Samla, di Masreka, regnò in luogo suo. ");
INSERT INTO ita1927_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla morì, e Saul di Rehoboth sul Fiume, regnò in luogo suo. ");
INSERT INTO ita1927_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saul morì, e Baal-Hanan, figliuolo di Acbor, regnò in luogo suo. ");
INSERT INTO ita1927_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baal-Hanan, figliuolo di Acbor, morì, e Hadar regnò in luogo suo. Il nome della sua città fu Pau, e il nome della sua moglie, Mehetabeel, figliuola di Matred, figliuola di Mezahab. ");
INSERT INTO ita1927_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","E questi sono i nomi dei capi di Esaù, secondo le loro famiglie, secondo i loro territori, coi loro nomi: Il capo Timna, il capo Alva, il capo Ieteth, ");
INSERT INTO ita1927_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","il capo Oholibama, il capo Ela, ");
INSERT INTO ita1927_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","il capo Pinon, il capo Kenaz, il capo Teman, il capo Mibtsar, il capo Magdiel, il capo Iram. ");
INSERT INTO ita1927_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Questi sono i capi di Edom secondo le loro dimore, nel paese che possedevano. Questo è Esaù, il padre degli Edomiti. ");
INSERT INTO ita1927_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Or Giacobbe dimorò nel paese dove suo padre avea soggiornato, nel paese di Canaan. ");
INSERT INTO ita1927_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","E questa è la posterità di Giacobbe. Giuseppe, all’età di diciassette anni, pasceva il gregge coi suoi fratelli; e, giovinetto com’era, stava coi figliuoli di Bilha e coi figliuoli di Zilpa, mogli di suo padre. E Giuseppe riferì al loro padre la mala fama che circolava sul loro conto. ");
INSERT INTO ita1927_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Or Israele amava Giuseppe più di tutti gli altri suoi figliuoli, perché era il figlio della sua vecchiaia; e gli fece una veste lunga con le maniche. ");
INSERT INTO ita1927_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","E i suoi fratelli, vedendo che il loro padre l’amava più di tutti gli altri fratelli, l’odiavano, e non gli potevan parlare amichevolmente. ");
INSERT INTO ita1927_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Or Giuseppe ebbe un sogno, e lo raccontò ai suoi fratelli; e questi l’odiaron più che mai. ");
INSERT INTO ita1927_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Egli disse loro: “Udite, vi prego, il sogno che ho fatto. ");
INSERT INTO ita1927_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Noi stavamo legando de’ covoni in mezzo ai campi, quand’ecco che il mio covone si levò su e si tenne ritto; ed ecco i covoni vostri farsi d’intorno al mio covone, e inchinarglisi dinanzi”. ");
INSERT INTO ita1927_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Allora i suoi fratelli gli dissero: “Dovrai tu dunque regnare su noi? o dominarci?” E l’odiarono più che mai a motivo de’ suoi sogni e delle sue parole. ");
INSERT INTO ita1927_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Egli ebbe ancora un altro sogno, e lo raccontò ai suoi fratelli, dicendo: “Ho avuto un altro sogno! Ed ecco che il sole, la luna e undici stelle mi s’inchinavano dinanzi”. ");
INSERT INTO ita1927_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ei lo raccontò a suo padre e ai suoi fratelli; e suo padre lo sgridò, e gli disse: “Che significa questo sogno che hai avuto? Dovremo dunque io e tua madre e i tuoi fratelli venir proprio a inchinarci davanti a te fino a terra?” ");
INSERT INTO ita1927_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","E i suoi fratelli gli portavano invidia, ma suo padre serbava dentro di sé queste parole. ");
INSERT INTO ita1927_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Or i fratelli di Giuseppe erano andati a pascere il gregge del padre a Sichem. ");
INSERT INTO ita1927_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","E Israele disse a Giuseppe: “I tuoi fratelli non sono forse alla pastura a Sichem? Vieni, che ti manderò da loro”. Ed egli rispose: “Eccomi”. ");
INSERT INTO ita1927_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Israele gli disse: “Va’ a vedere se i tuoi fratelli stanno bene, e se tutto va bene col gregge; e torna a dirmelo”. Così lo mandò dalla valle di Hebron, e Giuseppe arrivò a Sichem. ");
INSERT INTO ita1927_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","E un uomo lo trovò che andava errando per i campi e quest’uomo lo interrogò dicendo: “Che cerchi?” ");
INSERT INTO ita1927_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Egli rispose: “Cerco i miei fratelli; deh, dimmi dove siano a pascere il gregge”. ");
INSERT INTO ita1927_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","E quell’uomo gli disse: “Son partiti di qui, perché li ho uditi che dicevano: Andiamocene a Dotan”. Giuseppe andò quindi in traccia de’ suoi fratelli, e li trovò a Dotan. ");
INSERT INTO ita1927_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Essi lo scorsero da lontano; e prima ch’egli fosse loro vicino, macchinarono d’ucciderlo. ");
INSERT INTO ita1927_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","E dissero l’uno all’altro: “Ecco cotesto sognatore che viene! ");
INSERT INTO ita1927_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ora dunque venite, uccidiamolo, e gettiamolo in una di queste cisterne; diremo poi che una mala bestia l’ha divorato, e vedremo che ne sarà de’ suoi sogni”. ");
INSERT INTO ita1927_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ruben udì questo, e lo liberò dalle loro mani. Disse: “Non gli togliamo la vita”. ");
INSERT INTO ita1927_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Poi Ruben aggiunse: “Non spargete sangue; gettatelo in quella cisterna ch’è nel deserto, ma non lo colpisca la vostra mano”. Diceva così, per liberarlo dalle loro mani e restituirlo a suo padre. ");
INSERT INTO ita1927_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Quando Giuseppe fu giunto presso i suoi fratelli, lo spogliarono della sua veste, della veste lunga con le maniche che aveva addosso; ");
INSERT INTO ita1927_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","lo presero e lo gettarono nella cisterna. Or la cisterna era vuota; non c’era punt’acqua. ");
INSERT INTO ita1927_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Poi si misero a sedere per prender cibo; e avendo alzati gli occhi, ecco che videro una carovana d’Ismaeliti, che veniva da Galaad, coi suoi cammelli carichi di aromi, di balsamo e di mirra, che portava in Egitto. ");
INSERT INTO ita1927_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","E Giuda disse ai suoi fratelli: “Che guadagneremo a uccidere il nostro fratello e a nascondere il suo sangue? ");
INSERT INTO ita1927_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Venite, vendiamolo agl’Ismaeliti, e non lo colpisca la nostra mano, poiché è nostro fratello, nostra carne”. E i suoi fratelli gli diedero ascolto. ");
INSERT INTO ita1927_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","E come que’ mercanti Madianiti passavano, essi trassero e fecero salire Giuseppe su dalla cisterna, e lo vendettero per venti sicli d’argento a quegl’Ismaeliti. E questi menarono Giuseppe in Egitto. ");
INSERT INTO ita1927_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Or Ruben tornò alla cisterna; ed ecco, Giuseppe non era più nella cisterna. Allora egli si stracciò le vesti, ");
INSERT INTO ita1927_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","tornò dai suoi fratelli, e disse: “Il fanciullo non c’è più; e io, dove andrò io?” ");
INSERT INTO ita1927_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Essi presero la veste di Giuseppe, scannarono un becco, e intrisero del sangue la veste. ");
INSERT INTO ita1927_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Poi mandarono uno a portare al padre loro la veste lunga con le maniche, e gli fecero dire: “Abbiam trovato questa veste; vedi tu se sia quella del tuo figliuolo, o no”. ");
INSERT INTO ita1927_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ed egli la riconobbe e disse: “E’ la veste del mio figliuolo; una mala bestia l’ha divorato; per certo, Giuseppe è stato sbranato”. ");
INSERT INTO ita1927_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","E Giacobbe si stracciò le vesti, si mise un cilicio sui fianchi, e fece cordoglio del suo figliuolo per molti giorni. ");
INSERT INTO ita1927_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","E tutti i suoi figliuoli e tutte le sue figliuole vennero a consolarlo; ma egli rifiutò d’esser consolato, e disse: “Io scenderò, facendo cordoglio, dal mio figliuolo, nel soggiorno de’ morti”. E suo padre lo pianse. ");
INSERT INTO ita1927_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","E que’ Madianiti lo vendettero in Egitto a Potifar, ufficiale di Faraone, capitano delle guardie. ");
INSERT INTO ita1927_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Or avvenne che, in quel tempo, Giuda discese di presso ai suoi fratelli, e andò a stare da un uomo di Adullam, che avea nome Hira. ");
INSERT INTO ita1927_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","E Giuda vide quivi la figliuola di un Cananeo, chiamato Shua; e se la prese, e convisse con lei. ");
INSERT INTO ita1927_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ed ella concepì e partorì un figliuolo, al quale egli pose nome Er. ");
INSERT INTO ita1927_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Poi ella concepì di nuovo, e partorì un figliuolo, al quale pose nome Onan. ");
INSERT INTO ita1927_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","E partorì ancora un figliuolo, al quale pose nome Scela. Or Giuda era a Kezib, quand’ella lo partorì. ");
INSERT INTO ita1927_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","E Giuda prese per Er, suo primogenito, una moglie che avea nome Tamar. ");
INSERT INTO ita1927_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ma Er, primogenito di Giuda, era perverso agli occhi dell’Eterno, e l’Eterno lo fece morire. ");
INSERT INTO ita1927_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Allora Giuda disse a Onan: “Va’ dalla moglie del tuo fratello, prenditela come cognato, e suscita una progenie al tuo fratello”. ");
INSERT INTO ita1927_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","E Onan, sapendo che quella progenie non sarebbe sua, quando s’accostava alla moglie del suo fratello, faceva in modo d’impedire il concepimento, per non dar progenie al fratello. ");
INSERT INTO ita1927_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ciò ch’egli faceva dispiacque all’Eterno, il quale fece morire anche lui. ");
INSERT INTO ita1927_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Allora Giuda disse a Tamar sua nuora: “Rimani vedova in casa di tuo padre, finché Scela, mio figliuolo, sia cresciuto”. Perché diceva: “Badiamo che anch’egli non muoia come i suoi fratelli”. E Tamar se ne andò, e dimorò in casa di suo padre. ");
INSERT INTO ita1927_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Passaron molti giorni, e morì la figliuola di Shua, moglie di Giuda; e dopo che Giuda si fu consolato, salì da quelli che tosavan le sue pecore a Timna; egli col suo amico Hira, l’Adullamita. ");
INSERT INTO ita1927_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Di questo fu informata Tamar, e le fu detto: “Ecco, il tuo suocero sale a Timna a tosare le sue pecore”. ");
INSERT INTO ita1927_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Allora ella si tolse le vesti da vedova, si coprì d’un velo, se ne avvolse tutta, e si pose a sedere alla porta di Enaim, ch’è sulla via di Timna; poiché vedeva che Scela era cresciuto, e nondimeno, lei non gli era stata data per moglie. ");
INSERT INTO ita1927_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Come Giuda la vide, la prese per una meretrice, perch’essa aveva il viso coperto. ");
INSERT INTO ita1927_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","E accostatosi a lei sulla via, le disse: “Lasciami venire da te!” Poiché non sapeva ch’ella fosse sua nuora. Ed ella rispose: “Che mi darai per venire da me?” ");
INSERT INTO ita1927_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ed egli le disse: “Ti manderò un capretto del mio gregge”. Ed ella: “Mi darai tu un pegno finché tu me l’abbia mandato?” ");
INSERT INTO ita1927_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ed egli: “Che pegno ti darò?” E l’altra rispose: “Il tuo sigillo, il tuo cordone e il bastone che hai in mano”. Egli glieli dette, andò da lei, ed ella rimase incinta di lui. ");
INSERT INTO ita1927_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Poi ella si levò, e se ne andò; si tolse il velo, e si rimise le vesti da vedova. ");
INSERT INTO ita1927_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","E Giuda mandò il capretto per mezzo del suo amico, l’Adullamita, affin di ritirare il pegno di man di quella donna; ma egli non la trovò. ");
INSERT INTO ita1927_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Interrogò la gente del luogo, dicendo: “Dov’è quella meretrice che stava a Enaim, sulla via?” E quelli risposero: “Qui non c’è stata alcuna meretrice”. ");
INSERT INTO ita1927_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ed egli se ne tornò a Giuda, e gli disse: “Non l’ho trovata; e, per di più, la gente del luogo m’ha detto: Qui non c’è stata alcuna meretrice”. ");
INSERT INTO ita1927_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","E Giuda disse: “Si tenga pure il pegno, che non abbiamo a incorrere nel disprezzo. Ecco, io ho mandato questo capretto, e tu non l’hai trovata”. ");
INSERT INTO ita1927_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Or circa tre mesi dopo, vennero a dire a Giuda: “Tamar, tua nuora, si è prostituita; e, per di più, eccola incinta in seguito alla sua prostituzione”. E Giuda disse: “Menatela fuori, e sia arsa!” ");
INSERT INTO ita1927_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Come la menavano fuori, ella mandò a dire al suocero: “Sono incinta dell’uomo al quale appartengono queste cose”. E disse: “Riconosci, ti prego, di chi siano questo sigillo, questi cordoni e questo bastone”. ");
INSERT INTO ita1927_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Giuda li riconobbe, e disse: “Ella è più giusta di me, giacché io non l’ho data a Scela, mio figliuolo”. Ed egli non ebbe più relazioni con lei. ");
INSERT INTO ita1927_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Or quando venne il tempo in cui doveva partorire, ecco ch’essa aveva in seno due gemelli. ");
INSERT INTO ita1927_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","E mentre partoriva, l’un d’essi mise fuori una mano; e la levatrice la prese, e vi legò un filo di scarlatto, dicendo: “Questo qui esce il primo”. ");
INSERT INTO ita1927_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ma egli ritirò la mano, ed ecco uscir fuori il suo fratello. Allora la levatrice disse: “Perché ti sei fatta questa breccia?” Per questo motivo gli fu messo nome Perets. ");
INSERT INTO ita1927_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Poi uscì il suo fratello, che aveva alla mano il filo di scarlatto; e fu chiamato Zerach. ");
INSERT INTO ita1927_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Giuseppe fu menato in Egitto; e Potifar, ufficiale di Faraone, capitano delle guardie, un Egiziano, lo comprò da quegl’Ismaeliti, che l’aveano menato quivi. ");
INSERT INTO ita1927_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","E l’Eterno fu con Giuseppe, il quale prosperava e stava in casa del suo signore, l’Egiziano. ");
INSERT INTO ita1927_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","E il suo signore vide che l’Eterno era con lui, e che l’Eterno gli faceva prosperare nelle mani tutto quello che intraprendeva. ");
INSERT INTO ita1927_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Giuseppe entrò nelle grazie di lui, e attendeva al servizio personale di Potifar, il quale lo fece maggiordomo della sua casa, e gli mise nelle mani tutto quello che possedeva. ");
INSERT INTO ita1927_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","E da che l’ebbe fatto maggiordomo della sua casa e gli ebbe affidato tutto quello che possedeva, l’Eterno benedisse la casa dell’Egiziano, per amor di Giuseppe; e la benedizione dell’Eterno riposò su tutto quello ch’egli possedeva, in casa e in campagna. ");
INSERT INTO ita1927_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potifar lasciò tutto quello che aveva, nelle mani di Giuseppe; e non s’occupava più di cosa alcuna, tranne del suo proprio cibo. Or Giuseppe era di presenza avvenente e di bell’aspetto. ");
INSERT INTO ita1927_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Dopo queste cose avvenne che la moglie del signore di Giuseppe gli mise gli occhi addosso, e gli disse: “Giaciti meco”. ");
INSERT INTO ita1927_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ma egli rifiutò e disse alla moglie del suo signore: “Ecco, il mio signore non s’informa da me di nulla ch’è nella casa, e ha messo nelle mie mani tutto quello che ha; ");
INSERT INTO ita1927_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","egli stesso non è più grande di me in questa casa; e nulla mi ha divietato, tranne che te, perché sei sua moglie. Come dunque potrei io fare questo gran male e peccare contro Dio?” ");
INSERT INTO ita1927_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","E bench’ella gliene parlasse ogni giorno, Giuseppe non acconsentì, né a giacersi né a stare con lei. ");
INSERT INTO ita1927_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Or avvenne che un giorno egli entrò in casa per fare il suo lavoro; e non c’era quivi alcuno della gente di casa; ");
INSERT INTO ita1927_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ed essa lo afferrò per la veste, e gli disse: “Giaciti meco”. Ma egli le lasciò in mano la veste e fuggì fuori. ");
INSERT INTO ita1927_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","E quand’ella vide ch’egli le aveva lasciata la veste in mano e ch’era fuggito fuori, ");
INSERT INTO ita1927_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","chiamò la gente della sua casa, e le parlò così: “Vedete, ei ci ha menato in casa un Ebreo per pigliarsi giuoco di noi; esso è venuto da me per giacersi meco, ma io ho gridato a gran voce. ");
INSERT INTO ita1927_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","E com’egli ha udito ch’io alzavo la voce e gridavo, m’ha lasciato qui la sua veste, ed è fuggito fuori”. ");
INSERT INTO ita1927_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","E si tenne accanto la veste di lui, finché il suo signore non fu tornato a casa. ");
INSERT INTO ita1927_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Allora ella gli parlò in questa maniera: “Quel servo ebreo che tu ci hai menato, venne da me per pigliarsi giuoco di me. ");
INSERT INTO ita1927_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ma com’io ho alzato la voce e ho gridato, egli m’ha lasciato qui la sua veste e se n’è fuggito fuori”. ");
INSERT INTO ita1927_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Quando il signore di Giuseppe ebbe intese le parole di sua moglie che gli diceva: “Il tuo servo m’ha fatto questo!” l’ira sua s’infiammò. ");
INSERT INTO ita1927_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","E il signore di Giuseppe lo prese e lo mise nella prigione, nel luogo ove si tenevano chiusi i carcerati del re. Egli fu dunque là in quella prigione. ");
INSERT INTO ita1927_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ma l’Eterno fu con Giuseppe, e spiegò a pro di lui la sua benignità, cattivandogli le grazie del governatore della prigione. ");
INSERT INTO ita1927_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","E il governatore della prigione affidò alla sorveglianza di Giuseppe tutti i detenuti ch’erano nella carcere; e nulla si faceva quivi senza di lui. ");
INSERT INTO ita1927_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Il governatore della prigione non rivedeva niente di quello ch’era affidato a lui, perché l’Eterno era con lui, e l’Eterno faceva prosperare tutto quello ch’egli intraprendeva. ");
INSERT INTO ita1927_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Or, dopo queste cose, avvenne che il coppiere e il panettiere del re d’Egitto offesero il loro signore, il re d’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","E Faraone s’indignò contro i suoi due ufficiali, contro il capo de’ coppieri e il capo de’ panettieri, ");
INSERT INTO ita1927_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","e li fece mettere in carcere, nella casa del capo delle guardie; nella prigione stessa dove Giuseppe stava rinchiuso. ");
INSERT INTO ita1927_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","E il capitano delle guardie li affidò alla sorveglianza di Giuseppe, il quale li serviva. Ed essi rimasero in prigione per un certo tempo. ");
INSERT INTO ita1927_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","E durante una medesima notte, il coppiere e il panettiere del re d’Egitto, ch’erano rinchiusi nella prigione, ebbero ambedue un sogno, un sogno per uno, e ciascun sogno aveva il suo significato particolare. ");
INSERT INTO ita1927_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Giuseppe, venuto la mattina da loro, li guardò, ed ecco, erano conturbati. ");
INSERT INTO ita1927_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","E interrogò gli ufficiali di Faraone ch’eran con lui in prigione nella casa del suo signore, e disse: “Perché avete oggi il viso così mesto?” ");
INSERT INTO ita1927_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","E quelli gli risposero: “Abbiam fatto un sogno e non v’è alcuno che ce lo interpreti”. E Giuseppe disse loro: “Le interpretazioni non appartengono a Dio? Raccontatemi i sogni, vi prego”. ");
INSERT INTO ita1927_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","E il capo de’ coppieri raccontò il suo sogno a Giuseppe, e gli disse: “Nei mio sogno, ecco, mi stava davanti una vite; ");
INSERT INTO ita1927_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","e in quella vite c’eran tre tralci; e mi pareva ch’essa germogliasse, poi fiorisse, e desse in fine dei grappoli d’uva matura. ");
INSERT INTO ita1927_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","E io avevo in mano la coppa di Faraone; presi l’uva, la spremei nella coppa di Faraone, e diedi la coppa in mano a Faraone”. ");
INSERT INTO ita1927_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Giuseppe gli disse: “Questa è l’interpretazione del sogno: i tre tralci sono tre giorni; ");
INSERT INTO ita1927_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","ancora tre giorni, e Faraone ti farà rialzare il capo, ti ristabilirà nel tuo ufficio, e tu darai in mano a Faraone la sua coppa, nel modo che facevi prima, quand’eri suo coppiere. ");
INSERT INTO ita1927_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ma ricordati di me, quando sarai felice, e siimi benigno, ti prego; parla di me a Faraone, e fammi uscire da questa casa; ");
INSERT INTO ita1927_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","perché io fui portato via furtivamente dal paese degli Ebrei, e anche qui non ho fatto nulla da esser messo in questa fossa”. ");
INSERT INTO ita1927_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Il capo de’ panettieri, vedendo che la interpretazione di Giuseppe era favorevole, gli disse: “Anch’io, nel mio sogno, ecco, avevo tre canestri di pan bianco, sul capo; ");
INSERT INTO ita1927_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","e nel canestro più alto c’era per Faraone ogni sorta di vivande cotte al forno; e gli uccelli le mangiavano dentro al canestro sul mio capo”. ");
INSERT INTO ita1927_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Giuseppe rispose e disse: “Questa è l’interpretazione del sogno: i tre canestri sono tre giorni; ");
INSERT INTO ita1927_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","ancora tre giorni, e Faraone ti porterà via la testa di sulle spalle, ti farà impiccare a un albero, e gli uccelli ti mangeranno le carni addosso”. ");
INSERT INTO ita1927_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","E avvenne, il terzo giorno, ch’era il natalizio di Faraone, che questi dette un convito a tutti i suoi servitori, e fece alzare il capo al gran coppiere, e alzare il capo al gran panettiere in mezzo ai suoi servitori: ");
INSERT INTO ita1927_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","ristabilì il gran coppiere nel suo ufficio di coppiere, perché mettesse la coppa in man di Faraone, ");
INSERT INTO ita1927_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ma fece appiccare il gran panettiere, secondo la interpretazione che Giuseppe avea loro data. ");
INSERT INTO ita1927_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Il gran coppiere però non si ricordò di Giuseppe, ma lo dimenticò. ");
INSERT INTO ita1927_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Or avvenne, in capo a due anni interi, che Faraone ebbe un sogno. Ed ecco che stava presso il fiume; ");
INSERT INTO ita1927_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","e su dal fiume ecco salire sette vacche, di bell’apparenza e grasse, e mettersi a pascere nella giuncaia. ");
INSERT INTO ita1927_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","E, dopo quelle, ecco salire dal fiume altre sette vacche di brutt’apparenza e scarne, e fermarsi presso alle prime, sulla riva del fiume. ");
INSERT INTO ita1927_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","E le vacche di brutt’apparenza e scarne, divorarono le sette vacche di bell’apparenza e grasse. E Faraone si svegliò. ");
INSERT INTO ita1927_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Poi si riaddormentò, e sognò di nuovo; ed ecco sette spighe, grasse e belle, venir su da un unico stelo. ");
INSERT INTO ita1927_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Poi ecco sette spighe, sottili e arse dal vento orientale, germogliare dopo quelle altre. ");
INSERT INTO ita1927_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","E le spighe sottili inghiottirono le sette spighe grasse e piene. E Faraone si svegliò: ed ecco, era un sogno. ");
INSERT INTO ita1927_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","La mattina, lo spirito di Faraone fu conturbato; ed egli mandò a chiamare tutti i magi e tutti i savi d’Egitto, e raccontò loro i suoi sogni; ma non ci fu alcuno che li potesse interpretare a Faraone. ");
INSERT INTO ita1927_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Allora il capo de’ coppieri parlò a Faraone, dicendo: “Ricordo oggi i miei falli. ");
INSERT INTO ita1927_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Faraone s’era sdegnato contro i suoi servitori, e m’avea fatto mettere in prigione in casa del capo delle guardie: me, e il capo de’ panettieri. ");
INSERT INTO ita1927_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","L’uno e l’altro facemmo un sogno, nella medesima notte: facemmo ciascuno un sogno, avente il suo proprio significato. ");
INSERT INTO ita1927_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Or c’era quivi con noi un giovane ebreo, servo del capo delle guardie; a lui raccontammo i nostri sogni, ed egli ce li interpretò, dando a ciascuno l’interpretazione del suo sogno. ");
INSERT INTO ita1927_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","E le cose avvennero secondo l’interpretazione ch’egli ci aveva data: Faraone ristabilì me nel mio ufficio, e l’altro lo fece appiccare”. ");
INSERT INTO ita1927_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Allora Faraone mandò a chiamare Giuseppe, il quale fu tosto tratto fuor dalla prigione sotterranea. Egli si rase, si cambiò il vestito, e venne da Faraone. ");
INSERT INTO ita1927_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","E Faraone disse a Giuseppe: “Ho fatto un sogno, e non c’è chi lo possa interpretare; e ho udito dir di te che, quando t’hanno raccontato un sogno, tu lo puoi interpretare”. ");
INSERT INTO ita1927_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Giuseppe rispose a Faraone, dicendo: “Non son io; ma sarà Dio che darà a Faraone una risposta favorevole”. ");
INSERT INTO ita1927_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","E Faraone disse a Giuseppe: “Nel mio sogno, io stavo sulla riva del fiume; ");
INSERT INTO ita1927_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","quand’ecco salir dal fiume sette vacche grasse e di bell’apparenza, e mettersi a pascere nella giuncaia. ");
INSERT INTO ita1927_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","E, dopo quelle, ecco salire altre sette vacche magre, di bruttissima apparenza e scarne: tali, che non ne vidi mai di così brutte in tutto il paese d’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","E le vacche magre e brutte divorarono le prime sette vacche grasse; ");
INSERT INTO ita1927_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","e quelle entrarono loro in corpo, e non si riconobbe che vi fossero entrate; erano di brutt’apparenza come prima. E mi svegliai. ");
INSERT INTO ita1927_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Poi vidi ancora nel mio sogno sette spighe venir su da un unico stelo, piene e belle; ");
INSERT INTO ita1927_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","ed ecco altre sette spighe vuote, sottili e arse dal vento orientale, germogliare dopo quelle altre. ");
INSERT INTO ita1927_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","E le spighe sottili inghiottirono le sette spighe belle. Io ho raccontato questo al magi; ma non c’è stato alcuno che abbia saputo spiegarmelo”. ");
INSERT INTO ita1927_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Allora Giuseppe disse a Faraone: “Ciò che Faraone ha sognato è una stessa cosa. Iddio ha significato a Faraone quello che sta per fare. ");
INSERT INTO ita1927_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Le sette vacche belle sono sette anni, e le sette spighe belle sono sette anni; è uno stesso sogno. ");
INSERT INTO ita1927_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","E le sette vacche magre e brutte che salivano dopo quelle altre, sono sette anni; come pure le sette spighe vuote e arse dal vento orientale saranno sette anni di carestia. ");
INSERT INTO ita1927_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Questo è quel che ho detto a Faraone: Iddio ha mostrato a Faraone quello che sta per fare. ");
INSERT INTO ita1927_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ecco, stanno per venire sette anni di grande abbondanza in tutto il paese d’Egitto; ");
INSERT INTO ita1927_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","e dopo, verranno sette anni di carestia; e tutta quell’abbondanza sarà dimenticata nel paese d’Egitto, e la carestia consumerà il paese. ");
INSERT INTO ita1927_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","E uno non si accorgerà più di quell’abbondanza nel paese, a motivo della carestia che seguirà; perché questa sarà molto aspra. ");
INSERT INTO ita1927_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","E l’essersi il sogno replicato due volte a Faraone vuol dire che la cosa è decretata da Dio, e che Dio l’eseguirà tosto. ");
INSERT INTO ita1927_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Or dunque si provveda Faraone d’un uomo intelligente e savio e lo stabilisca sul paese d’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Faraone faccia così: Costituisca de’ commissari sul paese per prelevare il quinto delle raccolte del paese d’Egitto, durante i sette anni dell’abbondanza. ");
INSERT INTO ita1927_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","E radunino essi tutti i viveri di queste sette buone annate che stan per venire, e ammassino il grano a disposizione di Faraone per l’approvvigionamento delle città, e lo conservino. ");
INSERT INTO ita1927_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Questi viveri saranno una riserva per il paese, in vista dei sette anni di carestia che verranno nel paese d’Egitto; e così il paese non perirà per la carestia”. ");
INSERT INTO ita1927_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Piacque la cosa a Faraone e a tutti i suoi servitori. ");
INSERT INTO ita1927_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","E Faraone disse ai suoi servitori: “Potremmo noi trovare un uomo pari a questo, in cui sia lo spirito di Dio?” ");
INSERT INTO ita1927_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","E Faraone disse a Giuseppe: “Giacché Iddio t’ha fatto conoscere tutto questo, non v’è alcuno che sia intelligente e savio al pari di te. ");
INSERT INTO ita1927_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Tu sarai sopra la mia casa, e tutto il mio popolo obbedirà ai tuoi ordini; per il trono soltanto, io sarò più grande di te”. ");
INSERT INTO ita1927_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","E Faraone disse a Giuseppe: “Vedi, io ti stabilisco su tutto il paese d’Egitto”. ");
INSERT INTO ita1927_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","E Faraone si tolse l’anello di mano e lo mise alla mano di Giuseppe; lo fece vestire di abiti di lino fino, e gli mise al collo una collana d’oro. ");
INSERT INTO ita1927_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Lo fece montare sul suo secondo carro, e davanti a lui si gridava: “In ginocchio!” Così Faraone lo costituì su tutto il paese d’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","E Faraone disse a Giuseppe: “Io son Faraone! e senza te, nessuno alzerà la mano o il piede in tutto il paese d’Egitto”. ");
INSERT INTO ita1927_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","E Faraone chiamò Giuseppe Tsafnath-Paneach e gli dette per moglie Asenath figliuola di Potifera, sacerdote di On. E Giuseppe partì per visitare il paese d’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Or Giuseppe avea trent’anni quando si presentò dinanzi a Faraone re d’Egitto. E Giuseppe uscì dal cospetto di Faraone, e percorse tutto il paese d’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Durante i sette anni d’abbondanza, la terra produsse a piene mani; ");
INSERT INTO ita1927_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","e Giuseppe adunò tutti i viveri di quei sette anni che vennero nel paese d’Egitto, e ripose i viveri nelle città; ripose in ogni città i viveri del territorio circonvicino. ");
INSERT INTO ita1927_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Così Giuseppe ammassò grano come la rena del mare; in così gran quantità, che si smise di contarlo, perch’era innumerevole. ");
INSERT INTO ita1927_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Or avanti che venisse il primo anno della carestia, nacquero a Giuseppe due figliuoli, che Asenath figliuola di Potifera sacerdote di On gli partorì. ");
INSERT INTO ita1927_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","E Giuseppe chiamò il primogenito Manasse, perché, disse, “Iddio m’ha fatto dimenticare ogni mio affanno e tutta la casa di mio padre”. ");
INSERT INTO ita1927_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","E al secondo pose nome Efraim, perché, disse, “Iddio m’ha reso fecondo nel paese della mia afflizione”. ");
INSERT INTO ita1927_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","I sette anni d’abbondanza ch’erano stati nel paese d’Egitto, finirono; ");
INSERT INTO ita1927_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","e cominciarono a venire i sette anni della carestia, come Giuseppe avea detto. E ci fu carestia in tutti i paesi; ma in tutto il paese d’Egitto c’era del pane. ");
INSERT INTO ita1927_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Poi la carestia si estese a tutto il paese d’Egitto, e il popolo gridò a Faraone per aver del pane. E Faraone disse a tutti gli Egiziani: “Andate da Giuseppe, e fate quello che vi dirà”. ");
INSERT INTO ita1927_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","La carestia era sparsa su tutta la superficie del paese, e Giuseppe aperse tutti i depositi e vendé grano agli Egiziani. E la carestia s’aggravò nel paese d’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","E da tutti i paesi si veniva in Egitto da Giuseppe per comprar del grano, perché la carestia era grave per tutta la terra. ");
INSERT INTO ita1927_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Or Giacobbe, vedendo che c’era del grano in Egitto, disse ai suoi figliuoli: “Perché vi state a guardare l’un l’altro?” ");
INSERT INTO ita1927_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Poi disse: “Ecco, ho sentito dire che c’è del grano in Egitto; scendete colà per comprarcene, onde possiam vivere e non abbiamo a morire”. ");
INSERT INTO ita1927_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","E dieci de’ fratelli di Giuseppe scesero in Egitto per comprarvi del grano. ");
INSERT INTO ita1927_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ma Giacobbe non mandò Beniamino, fratello di Giuseppe, coi suoi fratelli, perché diceva: “Che non gli abbia a succedere qualche disgrazia!” ");
INSERT INTO ita1927_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","E i figliuoli d’Israele giunsero per comprare del grano in mezzo agli altri, che pur venivano; poiché nel paese di Canaan c’era la carestia. ");
INSERT INTO ita1927_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Or Giuseppe era colui che comandava nel paese; era lui che vendeva il grano a tutta la gente del paese; e i fratelli di Giuseppe vennero, e si prostrarono dinanzi a lui con la faccia a terra. ");
INSERT INTO ita1927_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","E Giuseppe vide i suoi fratelli e li riconobbe, ma fece lo straniero davanti a loro, e parlò loro aspramente e disse loro: “Donde venite?” Ed essi risposero: “Dal paese di Canaan per comprar de’ viveri”. ");
INSERT INTO ita1927_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","E Giuseppe riconobbe i suoi fratelli, ma essi non riconobbero lui. ");
INSERT INTO ita1927_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","E Giuseppe si ricordò de’ sogni che aveva avuti intorno a loro, e disse: “Voi siete delle spie! Siete venuti per vedere i luoghi sforniti del paese!” ");
INSERT INTO ita1927_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ed essi a lui: “No, signor mio; i tuoi servitori son venuti a comprar de’ viveri. ");
INSERT INTO ita1927_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Siamo tutti figliuoli d’uno stesso uomo; siamo gente sincera; i tuoi servitori non son delle spie”. ");
INSERT INTO ita1927_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ed egli disse loro: “No, siete venuti per vedere i luoghi sforniti del paese!” ");
INSERT INTO ita1927_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","E quelli risposero: “Noi, tuoi servitori, siamo dodici fratelli, figliuoli d’uno stesso uomo, nel paese di Canaan. Ed ecco, il più giovane è oggi con nostro padre, e uno non è più”. ");
INSERT INTO ita1927_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","E Giuseppe disse loro: “La cosa è come v’ho detto; siete delle spie! ");
INSERT INTO ita1927_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ecco come sarete messi alla prova: Per la vita di Faraone, non uscirete di qui prima che il vostro fratello più giovine sia venuto qua. ");
INSERT INTO ita1927_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Mandate uno di voi a prendere il vostro fratello; e voi resterete qui in carcere, perché le vostre parole siano messe alla prova, e si vegga se c’è del vero in voi; se no, per la vita di Faraone, siete delle spie!” ");
INSERT INTO ita1927_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","E li mise assieme in prigione per tre giorni. ");
INSERT INTO ita1927_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Il terzo giorno, Giuseppe disse loro: “Fate questo, e vivrete; io temo Iddio! ");
INSERT INTO ita1927_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Se siete gente sincera, uno di voi fratelli resti qui incatenato nella vostra prigione; e voi, andate, portate del grano per la necessità delle vostre famiglie; ");
INSERT INTO ita1927_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","e menatemi il vostro fratello più giovine; così le vostre parole saranno verificate, e voi non morrete”. Ed essi fecero così. ");
INSERT INTO ita1927_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","E si dicevano l’uno all’altro: “Sì, noi fummo colpevoli verso il nostro fratello, giacché vedemmo l’angoscia dell’anima sua quando egli ci supplicava, e noi non gli demmo ascolto! Ecco perché ci viene addosso quest’angoscia”. ");
INSERT INTO ita1927_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","E Ruben rispose loro, dicendo: “Non ve lo dicevo io: Non commettete questo peccato contro il fanciullo? Ma voi non mi voleste dare ascolto. Perciò ecco, che il suo sangue ci è ridomandato”. ");
INSERT INTO ita1927_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Or quelli non sapevano che Giuseppe li capiva, perché fra lui e loro c’era un interprete. ");
INSERT INTO ita1927_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ed egli s’allontanò da essi, e pianse. Poi tornò, parlò loro, e prese di fra loro Simeone, che fece incatenare sotto i loro occhi. ");
INSERT INTO ita1927_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Poi Giuseppe ordinò che s’empissero di grano i loro sacchi, che si rimettesse il danaro di ciascuno nel suo sacco, e che si dessero loro delle provvisioni per il viaggio. E così fu fatto. ");
INSERT INTO ita1927_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ed essi caricarono il loro grano sui loro asini, e se ne andarono. ");
INSERT INTO ita1927_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Or l’un d’essi aprì il suo sacco per dare del foraggio al suo asino, nel luogo ove pernottavano, e vide il suo danaro ch’era alla bocca del sacco; ");
INSERT INTO ita1927_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","e disse ai suoi fratelli: “Il mio danaro m’è stato restituito, ed eccolo qui nel mio sacco”. Allora il cuore venne lor meno, e, tremando, dicevano l’uno all’altro: “Che è mai questo che Dio ci ha fatto?” ");
INSERT INTO ita1927_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","E vennero a Giacobbe, loro padre, nel paese di Canaan, e gli raccontarono tutto quello ch’era loro accaduto, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“L’uomo ch’è il signor del paese, ci ha parlato aspramente e ci ha trattato da spie del paese. ");
INSERT INTO ita1927_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","E noi gli abbiamo detto: Siamo gente sincera; non siamo delle spie; ");
INSERT INTO ita1927_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","siamo dodici fratelli, figliuoli di nostro padre; uno non è più, e il più giovine è oggi con nostro padre nel paese di Canaan. ");
INSERT INTO ita1927_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","E quell’uomo, signore del paese, ci ha detto: Da questo conoscerò se siete gente sincera; lasciate presso di me uno dei vostri fratelli, prendete quel che vi necessita per le vostre famiglie, partite, e menatemi il vostro fratello più giovine. ");
INSERT INTO ita1927_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Allora conoscerò che non siete delle spie ma gente sincera; io vi renderò il vostro fratello, e voi potrete trafficare nel paese”. ");
INSERT INTO ita1927_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Or com’essi vuotavano i loro sacchi, ecco che l’involto del danaro di ciascuno era nel suo sacco; essi e il padre loro videro gl’involti del loro danaro, e furon presi da paura. ");
INSERT INTO ita1927_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","E Giacobbe, loro padre, disse: “Voi m’avete privato dei miei figliuoli! Giuseppe non è più, Simeone non è più, e mi volete togliere anche Beniamino! Tutto questo cade addosso a me!” ");
INSERT INTO ita1927_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","E Ruben disse a suo padre: “Se non te lo rimeno, fa’ morire i miei due figliuoli! Affidalo a me, io te lo ricondurrò”. ");
INSERT INTO ita1927_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ma Giacobbe rispose: “Il mio figliuolo non scenderà con voi; poiché il suo fratello è morto, e questo solo è rimasto: se gli succedesse qualche disgrazia durante il vostro viaggio, fareste scendere con cordoglio la mia canizie nel soggiorno de’ morti”. ");
INSERT INTO ita1927_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Or la carestia era grave nel paese; ");
INSERT INTO ita1927_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","e quand’ebbero finito di mangiare il grano che aveano portato dall’Egitto, il padre disse loro: “Tornate a comprarci un po’ di viveri”. ");
INSERT INTO ita1927_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","E Giuda gli rispose, dicendo: “Quell’uomo ce lo dichiarò positivamente: Non vedrete la mia faccia, se il vostro fratello non sarà con voi. ");
INSERT INTO ita1927_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Se tu mandi il nostro fratello con noi, noi scenderemo e ti compreremo dei viveri; ");
INSERT INTO ita1927_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ma, se non lo mandi, non scenderemo; perché quell’uomo ci ha detto: Non vedrete la mia faccia, se il vostro fratello non sarà con voi”. ");
INSERT INTO ita1927_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","E Israele disse: “Perché m’avete fatto questo torto di dire a quell’uomo che avevate ancora un fratello?” ");
INSERT INTO ita1927_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Quelli risposero: “Quell’uomo c’interrogò partitamente intorno a noi e al nostro parentado, dicendo: Vostro padre vive egli ancora? Avete qualche altro fratello? E noi gli rispondemmo a tenore delle sue domande. Potevam noi mai sapere che ci avrebbe detto: Fate venire il vostro fratello?” ");
INSERT INTO ita1927_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","E Giuda disse a Israele suo padre: “Lascia venire il fanciullo con me, e ci leveremo e andremo; e noi vivremo e non morremo: né noi, né tu, né i nostri piccini. ");
INSERT INTO ita1927_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Io mi rendo garante di lui; ridomandane conto alla mia mano; se non te lo riconduco e non te io rimetto davanti, io sarò per sempre colpevole verso di te. ");
INSERT INTO ita1927_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Se non ci fossimo indugiati, a quest’ora saremmo già tornati due volte”. ");
INSERT INTO ita1927_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Allora Israele, loro padre, disse loro: “Se così è fate questo: Prendete ne’ vostri sacchi delle cose più squisite di questo paese, e portate a quell’uomo un dono: un po’ di balsamo, un po’ di miele, degli aromi e della mirra, de’ pistacchi e delle mandorle; ");
INSERT INTO ita1927_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","e pigliate con voi il doppio del danaro, e riportate il danaro che fu rimesso alla bocca de’ vostri sacchi; forse fu un errore; ");
INSERT INTO ita1927_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","prendete anche il vostro fratello, e levatevi, tornate da quell’uomo; ");
INSERT INTO ita1927_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","e l’Iddio onnipotente vi faccia trovar grazia dinanzi a quell’uomo, sì ch’egli vi rilasci l’altro vostro fratello e Beniamino. E se debbo esser privato de’ miei figliuoli, ch’io lo sia!” ");
INSERT INTO ita1927_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Quelli presero dunque il dono, presero seco il doppio del danaro, e Beniamino; e, levatisi, scesero in Egitto, e si presentarono dinanzi a Giuseppe. ");
INSERT INTO ita1927_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","E come Giuseppe vide Beniamino con loro, disse al suo maestro di casa: “Conduci questi uomini in casa; macella, e prepara tutto; perché questi uomini mangeranno con me a mezzogiorno”. ");
INSERT INTO ita1927_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","E l’uomo fece come Giuseppe aveva ordinato, e li menò in casa di Giuseppe. ");
INSERT INTO ita1927_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","E quelli ebbero paura, perché eran menati in casa di Giuseppe, e dissero: “Siamo menati qui a motivo di quel danaro che ci fu rimesso nei sacchi la prima volta; ei vuol darci addosso, precipitarsi su noi e prenderci come schiavi, coi nostri asini”. ");
INSERT INTO ita1927_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","E accostatisi al maestro di casa di Giuseppe, gli parlarono sulla porta della casa, e dissero: ");
INSERT INTO ita1927_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Scusa, signor mio! noi scendemmo già una prima volta a comprar dei viveri; ");
INSERT INTO ita1927_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","e avvenne che, quando fummo giunti al luogo dove pernottammo, aprimmo i sacchi, ed ecco il danaro di ciascun di noi era alla bocca del suo sacco: il nostro danaro del peso esatto; e noi l’abbiam riportato con noi. ");
INSERT INTO ita1927_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","E abbiam portato con noi dell’altro danaro per comprar de’ viveri; noi non sappiamo chi avesse messo il nostro danaro nei nostri sacchi”. ");
INSERT INTO ita1927_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ed egli disse: “Datevi pace, non temete; l’Iddio vostro e l’Iddio del vostro padre ha messo un tesoro nei vostri sacchi. Io ebbi il vostro danaro”. E, fatto uscire Simeone, lo condusse loro. ");
INSERT INTO ita1927_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Quell’uomo li fece entrare in casa di Giuseppe; dette loro dell’acqua, ed essi si lavarono i piedi; ed egli dette del foraggio ai loro asini. ");
INSERT INTO ita1927_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ed essi prepararono il regalo, aspettando che Giuseppe venisse a mezzogiorno; perché aveano inteso che rimarrebbero quivi a mangiare. ");
INSERT INTO ita1927_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","E quando Giuseppe venne a casa, quelli gli porsero il dono che aveano portato seco nella casa, e s’inchinarono fino a terra davanti a lui. ");
INSERT INTO ita1927_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Egli domandò loro come stessero, e disse: “Vostro padre, il vecchio di cui mi parlaste, sta egli bene? Vive egli ancora?” ");
INSERT INTO ita1927_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","E quelli risposero: “Il padre nostro, tuo servo, sta bene; vive ancora”. E s’inchinarono, e gli fecero riverenza. ");
INSERT INTO ita1927_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Poi Giuseppe alzò gli occhi, vide Beniamino suo fratello, figliuolo della madre sua, e disse: “E’ questo il vostro fratello più giovine di cui mi parlaste?” Poi disse a lui: “Iddio ti sia propizio, figliuol mio!” ");
INSERT INTO ita1927_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","E Giuseppe s’affrettò ad uscire, perché le sue viscere s’eran commosse per il suo fratello; e cercava un luogo dove piangere; entrò nella sua camera, e quivi pianse. ");
INSERT INTO ita1927_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Poi si lavò la faccia, ed uscì; si fece forza, e disse: “Portate il pranzo”. ");
INSERT INTO ita1927_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Fu dunque portato il cibo per lui a parte, e per loro a parte, e per gli Egiziani che mangiavan con loro, a parte; perché gli Egiziani non possono mangiare con gli Ebrei; per gli Egiziani è cosa abominevole. ");
INSERT INTO ita1927_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ed essi si misero a sedere dinanzi a lui: il primogenito, secondo il suo diritto di primogenitura, e il più giovine secondo la sua età; e si guardavano l’un l’altro con maraviglia. ");
INSERT INTO ita1927_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","E Giuseppe fe’ loro portare delle vivande che aveva dinanzi; ma la porzione di Beniamino era cinque volte maggiore di quella d’ogni altro di loro. E bevvero, e stettero allegri con lui. ");
INSERT INTO ita1927_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Giuseppe dette quest’ordine al suo maestro di casa: “Riempi i sacchi di questi uomini di tanti viveri quanti ne posson portare, e metti il danaro di ciascun d’essi alla bocca del suo sacco. ");
INSERT INTO ita1927_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","E metti la mia coppa, la coppa d’argento, alla bocca del sacco del più giovine, assieme al danaro del suo grano”. Ed egli fece come Giuseppe avea detto. ");
INSERT INTO ita1927_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","La mattina, non appena fu giorno, quegli uomini furon fatti partire coi loro asini. ");
INSERT INTO ita1927_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","E quando furono usciti dalla città e non erano ancora lontani, Giuseppe disse al suo maestro di casa: “Lèvati, va’ dietro a quegli uomini; e quando li avrai raggiunti, di’ loro: Perché avete reso mal per bene? ");
INSERT INTO ita1927_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Non è quella la coppa nella quale il mio signore beve, e della quale si serve per indovinare? Avete fatto male a far questo!” ");
INSERT INTO ita1927_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Egli li raggiunse, e disse loro quelle parole. ");
INSERT INTO ita1927_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ed essi gli risposero: “Perché il mio signore ci rivolge parole come queste? Iddio preservi i tuoi servitori dal fare una tal cosa! ");
INSERT INTO ita1927_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ecco, noi t’abbiam riportato dal paese di Canaan il danaro che avevam trovato alla bocca de’ nostri sacchi; come dunque avremmo rubato dell’argento o dell’oro dalla casa del tuo signore? ");
INSERT INTO ita1927_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Quello de’ tuoi servitori presso il quale si troverà la coppa, sia messo a morte; e noi pure saremo schiavi del tuo signore!” ");
INSERT INTO ita1927_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ed egli disse: “Ebbene, sia fatto come dite: colui presso il quale essa sarà trovata, sarà mio schiavo; e voi sarete innocenti”. ");
INSERT INTO ita1927_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","In tutta fretta, ognun d’essi mise giù il suo sacco a terra, e ciascuno aprì il suo. ");
INSERT INTO ita1927_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Il maestro di casa li frugò, cominciando da quello del maggiore, per finire con quello del più giovane; e la coppa fu trovata nel sacco di Beniamino. ");
INSERT INTO ita1927_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Allora quelli si stracciarono le vesti, ognuno ricaricò il suo asino, e tornarono alla città. ");
INSERT INTO ita1927_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Giuda e i suoi fratelli arrivarono alla casa di Giuseppe, il quale era ancora quivi; e si gettarono in terra dinanzi a lui. ");
INSERT INTO ita1927_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","E Giuseppe disse loro: “Che azione è questa che avete fatta? Non lo sapete che un uomo come me ha potere d’indovinare?” ");
INSERT INTO ita1927_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Giuda rispose: “Che diremo al mio signore? quali parole useremo? o come ci giustificheremo? Dio ha ritrovato l’iniquità de’ tuoi servitori. Ecco, siamo schiavi del mio signore: tanto noi, quanto colui in mano del quale è stata trovata la coppa”. ");
INSERT INTO ita1927_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ma Giuseppe disse: “Mi guardi Iddio dal far questo! L’uomo in man del quale è stata trovata la coppa, sarà mio schiavo; quanto a voi, risalite in pace dal padre vostro”. ");
INSERT INTO ita1927_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Allora Giuda s’accostò a Giuseppe, e disse: “Di grazia, signor mio, permetti al tuo servitore di far udire una parola al mio signore, e non s’accenda l’ira tua contro il tuo servitore! poiché tu sei come Faraone. ");
INSERT INTO ita1927_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Il mio signore interrogò i suoi servitori, dicendo: Avete voi padre o fratello? ");
INSERT INTO ita1927_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","E noi rispondemmo al mio signore: Abbiamo un padre ch’è vecchio, con un giovane figliuolo, natogli nella vecchiaia; il fratello di questo è morto, talché egli è rimasto solo de’ figli di sua madre; e suo padre l’ama. ");
INSERT INTO ita1927_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Allora tu dicesti ai tuoi servitori: Menatemelo, perch’io lo vegga co’ miei occhi. ");
INSERT INTO ita1927_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","E noi dicemmo al mio signore: Il fanciullo non può lasciare suo padre; perché, se lo lasciasse, suo padre morrebbe. ");
INSERT INTO ita1927_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","E tu dicesti ai tuoi servitori: Se il vostro fratello più giovine non scende con voi, voi non vedrete più la mia faccia. ");
INSERT INTO ita1927_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","E come fummo risaliti a mio padre, tuo servitore, gli riferimmo le parole del mio signore. ");
INSERT INTO ita1927_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Poi nostro padre disse: Tornate a comprarci un po’ di viveri. ");
INSERT INTO ita1927_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","E noi rispondemmo: Non possiamo scender laggiù; se il nostro fratello più giovine verrà con noi, scenderemo; perché non possiamo veder la faccia di quell’uomo, se il nostro fratello più giovine non è con noi. ");
INSERT INTO ita1927_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","E mio padre, tuo servitore, ci rispose: Voi sapete che mia moglie mi partorì due figliuoli; ");
INSERT INTO ita1927_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","l’un d’essi si partì da me, e io dissi: Certo egli è stato sbranato; e non l’ho più visto da allora; ");
INSERT INTO ita1927_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","e se mi togliete anche questo, e se gli avviene qualche disgrazia, voi farete scendere con dolore la mia canizie nel soggiorno de’ morti. ");
INSERT INTO ita1927_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Or dunque, quando giungerò da mio padre, tuo servitore, se il fanciullo, all’anima del quale la sua è legata, non è con noi, ");
INSERT INTO ita1927_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","avverrà che, come avrà veduto che il fanciullo non c’è, egli morrà; e i tuoi servitori avranno fatto scendere con cordoglio la canizie del tuo servitore nostro padre nel soggiorno de’ morti. ");
INSERT INTO ita1927_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ora, siccome il tuo servitore s’è reso garante del fanciullo presso mio padre, e gli ha detto: Se non te lo riconduco sarò per sempre colpevole verso mio padre, ");
INSERT INTO ita1927_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","deh, permetti ora che il tuo servitore rimanga schiavo del mio signore, invece del fanciullo, e che il fanciullo se ne torni coi suoi fratelli. ");
INSERT INTO ita1927_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Perché, come farei a risalire da mio padre senz’aver meco il fanciullo? Ah, ch’io non vegga il dolore che ne verrebbe a mio padre!” ");
INSERT INTO ita1927_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Allora Giuseppe non poté più contenersi dinanzi a tutti gli astanti, e gridò: “Fate uscir tutti dalla mia presenza!” E nessuno rimase con Giuseppe quand’egli si diè a conoscere ai suoi fratelli. ");
INSERT INTO ita1927_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","E alzò la voce piangendo; gli Egiziani l’udirono, e l’udì la casa di Faraone. ");
INSERT INTO ita1927_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","E Giuseppe disse ai suoi fratelli: “Io son Giuseppe; mio padre vive egli tuttora?” Ma i suoi fratelli non gli potevano rispondere, perché erano sbigottiti alla sua presenza. ");
INSERT INTO ita1927_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","E Giuseppe disse ai suoi fratelli: “Deh, avvicinatevi a me!” Quelli s’avvicinarono ed egli disse: “Io son Giuseppe, vostro fratello, che voi vendeste perché fosse menato in Egitto. ");
INSERT INTO ita1927_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ma ora non vi contristate, né vi dolga d’avermi venduto perch’io fossi menato qua; poiché Iddio m’ha mandato innanzi a voi per conservarvi in vita. ");
INSERT INTO ita1927_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Infatti, sono due anni che la carestia è nel paese; e ce ne saranno altri cinque, durante i quali non ci sarà né aratura né mèsse. ");
INSERT INTO ita1927_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ma Dio mi ha mandato dinanzi a voi, perché sia conservato di voi un resto sulla terra, e per salvarvi la vita con una grande liberazione. ");
INSERT INTO ita1927_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Non siete dunque voi che m’avete mandato qua, ma è Dio; egli m’ha stabilito come padre di Faraone, signore di tutta la sua casa, e governatore di tutto il paese d’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Affrettatevi a risalire da mio padre, e ditegli: Così dice il tuo figliuolo Giuseppe: Iddio mi ha stabilito signore di tutto l’Egitto; scendi da me; non tardare; ");
INSERT INTO ita1927_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","tu dimorerai nel paese di Goscen, e sarai vicino a me; tu e i tuoi figliuoli, i figliuoli de’ tuoi figliuoli, i tuoi greggi, i tuoi armenti, e tutto quello che possiedi. ");
INSERT INTO ita1927_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","E quivi io ti sostenterò (perché ci saranno ancora cinque anni di carestia), onde tu non sia ridotto alla miseria: tu, la tua famiglia, e tutto quello che possiedi. ");
INSERT INTO ita1927_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ed ecco, voi vedete coi vostri occhi, e il mio fratello Beniamino vede con gli occhi suoi, ch’è proprio la bocca mia quella che vi parla. ");
INSERT INTO ita1927_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Raccontate dunque a mio padre tutta la mia gloria in Egitto, e tutto quello che avete veduto; e fate che mio padre scenda presto qua”. ");
INSERT INTO ita1927_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","E gettatosi al collo di Beniamino, suo fratello, pianse; e Beniamino pianse sul collo di lui. ");
INSERT INTO ita1927_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Baciò pure tutti i suoi fratelli, piangendo. E, dopo questo, i suoi fratelli si misero a parlare con lui. ");
INSERT INTO ita1927_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Il rumore della cosa si sparse nella casa di Faraone, e si disse: “Sono arrivati i fratelli di Giuseppe”. Il che piacque a Faraone ed ai suoi servitori. ");
INSERT INTO ita1927_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","E Faraone disse a Giuseppe: “Di’ ai tuoi fratelli: Fate questo: caricate le vostre bestie, e andate, tornate al paese di Canaan; ");
INSERT INTO ita1927_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","prendete vostro padre e le vostre famiglie, e venite da me; io vi darò del meglio del paese d’Egitto, e voi mangerete il grasso del paese. ");
INSERT INTO ita1927_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Tu hai l’ordine di dir loro: Fate questo: Prendete nel paese di Egitto de’ carri per i vostri piccini e per le vostre mogli; conducete vostro padre, e venite. ");
INSERT INTO ita1927_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","E non vi rincresca di lasciar le vostre masserizie; perché il meglio di tutto il paese d’Egitto sarà vostro”. ");
INSERT INTO ita1927_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","I figliuoli d’Israele fecero così, e Giuseppe diede loro dei carri, secondo l’ordine di Faraone, e diede loro delle provvisioni per il viaggio. ");
INSERT INTO ita1927_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","A tutti dette un abito di ricambio per ciascuno; ma a Beniamino dette trecento sicli d’argento e cinque mute di vestiti; ");
INSERT INTO ita1927_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","e a suo padre mandò questo: dieci asini carichi delle migliori cose d’Egitto, dieci asine cariche di grano, di pane e di viveri, per suo padre, durante il viaggio. ");
INSERT INTO ita1927_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Così licenziò i suoi fratelli, e questi partirono; ed egli disse loro: “Non ci siano, per via, delle dispute fra voi”. ");
INSERT INTO ita1927_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ed essi risalirono dall’Egitto, e vennero nel paese di Canaan da Giacobbe loro padre. ");
INSERT INTO ita1927_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","E gli riferirono ogni cosa, dicendo: “Giuseppe vive tuttora, ed è il governatore di tutto il paese d’Egitto”. Ma il suo cuore rimase freddo, perch’egli non credeva loro. ");
INSERT INTO ita1927_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Essi gli ripeterono tutte le parole che Giuseppe avea dette loro; ed egli vide i carri che Giuseppe avea mandato per condurlo via; allora lo spirito di Giacobbe loro padre si ravvivò, e Israele disse: ");
INSERT INTO ita1927_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","“Basta; il mio figliuolo Giuseppe vive tuttora; io andrò, e lo vedrò prima di morire”. ");
INSERT INTO ita1927_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israele dunque si partì con tutto quello che aveva; e, giunto a Beer-Sceba, offrì sacrifizi all’Iddio d’Isacco suo padre. ");
INSERT INTO ita1927_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","E Dio parlò a Israele in visioni notturne, e disse: “Giacobbe, Giacobbe!” Ed egli rispose: “Eccomi”. ");
INSERT INTO ita1927_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","E Dio disse: “Io sono Iddio, l’Iddio di tuo padre; non temere di scendere in Egitto, perché là ti farò diventare una grande nazione. ");
INSERT INTO ita1927_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Io scenderò con te in Egitto, e te ne farò anche sicuramente risalire; e Giuseppe ti chiuderà gli occhi”. ");
INSERT INTO ita1927_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Allora Giacobbe partì da Beer-Sceba; e i figliuoli d’Israele fecero salire Giacobbe loro padre, i loro piccini e le loro mogli sui carri che Faraone avea mandato per trasportarli. ");
INSERT INTO ita1927_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ed essi presero il loro bestiame e i beni che aveano acquistato nel paese di Canaan, e vennero in Egitto: Giacobbe, e tutta la sua famiglia con lui. ");
INSERT INTO ita1927_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Egli condusse seco in Egitto i suoi figliuoli, le sue figliuole, le figliuole de’ suoi figliuoli, e tutta la sua famiglia. ");
INSERT INTO ita1927_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Questi sono i nomi de’ figliuoli d’Israele che vennero in Egitto: Giacobbe e i suoi figliuoli. Il primogenito di Giacobbe: Ruben. ");
INSERT INTO ita1927_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","I figliuoli di Ruben: Henoc, Pallu, Hetsron e Carmi. ");
INSERT INTO ita1927_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","I figliuoli di Simeone: Iemuel, Iamin, Ohad, Iakin, Tsohar e Saul, figliuolo di una Cananea. ");
INSERT INTO ita1927_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","I figliuoli di Levi: Gherson, Kehath e Merari. ");
INSERT INTO ita1927_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","I figliuoli di Giuda: Er, Onan, Scela, Perets e Zerach; ma Er e Onan morirono nel paese di Canaan; e i figliuoli di Perets furono: Hetsron e Hamul. ");
INSERT INTO ita1927_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","I figliuoli d’Issacar: Tola, Puva, Iob e Scimron. ");
INSERT INTO ita1927_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","I figliuoli di Zabulon: Sered, Elon e Iahleel. ");
INSERT INTO ita1927_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Cotesti sono i figliuoli che Lea partorì a Giacobbe a Paddan-Aram, oltre Dina figliuola di lui. I suoi figliuoli e le sue figliuole erano in tutto trentatre persone. ");
INSERT INTO ita1927_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","I figliuoli di Gad: Tsifion, Haggi, Shuni, Etsbon, Eri, Arodi e Areli. ");
INSERT INTO ita1927_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","I figliuoli di Ascer: Imna, Tishva, Tishvi, Beria e Serah loro sorella. E i figliuoli di Beria: Heber e Malkiel. ");
INSERT INTO ita1927_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Cotesti furono i figliuoli di Zilpa che Labano avea dato a Lea sua figliuola; ed essa li partorì a Giacobbe: in tutto sedici persone. ");
INSERT INTO ita1927_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","I figliuoli di Rachele, moglie di Giacobbe: Giuseppe e Beniamino. ");
INSERT INTO ita1927_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","E a Giuseppe, nel paese d’Egitto, nacquero Manasse ed Efraim, i quali Asenath, figliuola di Potifera, sacerdote di On, gli partorì. ");
INSERT INTO ita1927_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","I figliuoli di Beniamino: Bela, Beker, Ashbel, Ghera, Naaman, Ehi, Rosh, Muppim, Huppim e Ard. ");
INSERT INTO ita1927_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Cotesti sono i figliuoli di Rachele che nacquero a Giacobbe: in tutto, quattordici persone. ");
INSERT INTO ita1927_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","I figliuoli di Dan: Huscim. ");
INSERT INTO ita1927_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","I figliuoli di Neftali: Iahtseel, Guni, Ietser e Scillem. ");
INSERT INTO ita1927_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Cotesti sono i figliuoli di Bilha che Labano avea dato a Rachele sua figliuola, ed essa li partorì a Giacobbe: in tutto, sette persone. ");
INSERT INTO ita1927_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Le persone che vennero con Giacobbe in Egitto, discendenti da lui, senza contare le mogli de’ figliuoli di Giacobbe, erano in tutto sessantasei. ");
INSERT INTO ita1927_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","E i figliuoli di Giuseppe, natigli in Egitto, erano due. Il totale delle persone della famiglia di Giacobbe che vennero in Egitto, era di settanta. ");
INSERT INTO ita1927_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Or Giacobbe mandò avanti a sé Giuda a Giuseppe, perché questi lo introducesse nel paese di Goscen. E giunsero nel paese di Goscen. ");
INSERT INTO ita1927_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Giuseppe fece attaccare il suo carro, e salì in Goscen a incontrare Israele, suo padre; e gli si presentò, gli si gettò al collo, e pianse lungamente sul collo di lui. ");
INSERT INTO ita1927_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","E Israele disse a Giuseppe: “Ora, ch’io muoia pure, giacché ho veduto la tua faccia, e tu vivi ancora!” ");
INSERT INTO ita1927_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","E Giuseppe disse ai suoi fratelli e alla famiglia di suo padre: “Io salirò a informare Faraone, e gli dirò: I miei fratelli e la famiglia di mio padre che erano nel paese di Canaan, sono venuti da me. ");
INSERT INTO ita1927_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Questi uomini sono pastori, poiché son sempre stati allevatori di bestiame; e hanno menato seco i loro greggi, i loro armenti, e tutto quello che posseggono. ");
INSERT INTO ita1927_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","E quando Faraone vi farà chiamare e vi dirà: Qual è la vostra occupazione? risponderete: ");
INSERT INTO ita1927_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","I tuoi servitori sono stati allevatori di bestiame dalla loro infanzia fino a quest’ora: così noi come i nostri padri. Direte così, perché possiate abitare nel paese di Goscen. Poiché gli Egiziani hanno in abominio tutti i pastori”. ");
INSERT INTO ita1927_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Giuseppe andò quindi a informare Faraone, e gli disse: “Mio padre e i miei fratelli coi loro greggi, coi loro armenti e con tutto quello che hanno, son venuti dal paese di Canaan; ed ecco, sono nel paese di Goscen”. ");
INSERT INTO ita1927_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","E prese cinque uomini di tra i suoi fratelli e li presentò a Faraone. ");
INSERT INTO ita1927_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","E Faraone disse ai fratelli di Giuseppe: “Qual è la vostra occupazione?” Ed essi risposero a Faraone: “I tuoi servitori sono pastori, come furono i nostri padri”. ");
INSERT INTO ita1927_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Poi dissero a Faraone: “Siam venuti per dimorare in questo paese, perché nel paese di Canaan non c’è pastura per i greggi dei tuoi servitori; poiché la carestia v’è grave; deh, permetti ora che i tuoi servi dimorino nel paese di Goscen”. ");
INSERT INTO ita1927_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","E Faraone parlò a Giuseppe dicendo: “Tuo padre e i tuoi fratelli son venuti da te; ");
INSERT INTO ita1927_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","il paese d’Egitto ti sta dinanzi; fa’ abitare tuo padre e i tuoi fratelli nella parte migliore del paese; dimorino pure nel paese di Goscen; e se conosci fra loro degli uomini capaci, falli sovrintendenti del mio bestiame”. ");
INSERT INTO ita1927_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Poi Giuseppe menò Giacobbe suo padre da Faraone, e glielo presentò. E Giacobbe benedisse Faraone. ");
INSERT INTO ita1927_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","E Faraone disse a Giacobbe: “Quanti sono i giorni del tempo della tua vita?” ");
INSERT INTO ita1927_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Giacobbe rispose a Faraone: “I giorni del tempo de’ miei pellegrinaggi sono centotrent’anni; i giorni del tempo della mia vita sono stati pochi e cattivi, e non hanno raggiunto il numero dei giorni della vita de’ miei padri, ai dì dei loro pellegrinaggi”. ");
INSERT INTO ita1927_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Giacobbe benedisse ancora Faraone, e si ritirò dalla presenza di lui. ");
INSERT INTO ita1927_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","E Giuseppe stabilì suo padre e i suoi fratelli, e dette loro un possesso nel paese d’Egitto, nella parte migliore del paese, nella contrada di Ramses, come Faraone aveva ordinato. ");
INSERT INTO ita1927_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","E Giuseppe sostentò suo padre, i suoi fratelli e tutta la famiglia di suo padre, provvedendoli di pane, secondo il numero de’ figliuoli. ");
INSERT INTO ita1927_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Or in tutto il paese non c’era pane, perché la carestia era gravissima; il paese d’Egitto e il paese di Canaan languivano a motivo della carestia. ");
INSERT INTO ita1927_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Giuseppe ammassò tutto il danaro che si trovava nel paese d’Egitto e nel paese di Canaan, come prezzo del grano che si comprava; e Giuseppe portò questo danaro nella casa di Faraone. ");
INSERT INTO ita1927_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","E quando il danaro fu esaurito nel paese d’Egitto e nel paese di Canaan, tutti gli Egiziani vennero a Giuseppe e dissero: “Dacci del pane! Perché dovremmo morire in tua presenza? giacché il danaro è finito”. ");
INSERT INTO ita1927_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","E Giuseppe disse: “Date il vostro bestiame; e io vi darò del pane in cambio del vostro bestiame, se non avete più danaro”. ");
INSERT INTO ita1927_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","E quelli menarono a Giuseppe il loro bestiame; e Giuseppe diede loro del pane in cambio dei loro cavalli, dei loro greggi di pecore, delle loro mandre di buoi e dei loro asini. Così fornì loro del pane per quell’anno, in cambio di tutto il loro bestiame. ");
INSERT INTO ita1927_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Passato quell’anno, tornarono a lui l’anno seguente, e gli dissero: “Noi non celeremo al mio signore che, il danaro essendo esaurito e le mandre del nostro bestiame essendo passate al mio signore, nulla più resta che il mio signore possa prendere, tranne i nostri corpi e le nostre terre. ");
INSERT INTO ita1927_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","E perché dovremmo perire sotto gli occhi tuoi: noi e le nostre terre? Compra noi e le terre nostre in cambio di pane; e noi con le nostre terre saremo schiavi di Faraone; e dacci da seminare affinché possiam vivere e non moriamo, e il suolo non diventi un deserto”. ");
INSERT INTO ita1927_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Così Giuseppe comprò per Faraone tutte le terre d’Egitto; giacché gli Egiziani venderono ognuno il suo campo, perché la carestia li colpiva gravemente. Così il paese diventò proprietà di Faraone. ");
INSERT INTO ita1927_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Quanto al popolo, lo fece passare nelle città, da un capo all’altro dell’Egitto; ");
INSERT INTO ita1927_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","solo le terre dei sacerdoti non acquistò; perché i sacerdoti ricevevano una provvisione assegnata loro da Faraone, e vivevano della provvisione che Faraone dava loro; per questo essi non venderono le loro terre. ");
INSERT INTO ita1927_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","E Giuseppe disse al popolo: “Ecco, oggi ho acquistato voi e le vostre terre per Faraone; eccovi del seme; seminate la terra; ");
INSERT INTO ita1927_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","e al tempo della raccolta, ne darete il quinto a Faraone, e quattro parti saran vostre, per la sementa dei campi e per il nutrimento vostro, di quelli che sono in casa vostra, e per il nutrimento de’ vostri bambini”. ");
INSERT INTO ita1927_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","E quelli dissero: “Tu ci hai salvato la vita! ci sia dato di trovar grazia agli occhi del mio signore, e saremo schiavi di Faraone!” ");
INSERT INTO ita1927_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Giuseppe ne fece una legge, che dura fino al dì d’oggi, secondo la quale un quinto del reddito delle terre d’Egitto era per Faraone; non ci furono che le terre dei sacerdoti che non furon di Faraone. ");
INSERT INTO ita1927_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Così gl’Israeliti abitarono nel paese d’Egitto, nel paese di Goscen; vi ebbero de’ possessi, vi s’accrebbero, e moltiplicarono oltremodo. ");
INSERT INTO ita1927_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","E Giacobbe visse nel paese d’Egitto diciassette anni; e i giorni di Giacobbe, gli anni della sua vita, furono centoquarantasette. ");
INSERT INTO ita1927_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","E quando Israele s’avvicinò al giorno della sua morte, chiamò il suo figliuolo Giuseppe, e gli disse: “Deh, se ho trovato grazia agli occhi tuoi, mettimi la mano sotto la coscia, e usami benignità e fedeltà; deh, non mi seppellire in Egitto! ");
INSERT INTO ita1927_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ma, quando giacerò coi miei padri, portami fuori d’Egitto, e seppelliscimi nel loro sepolcro!” ");
INSERT INTO ita1927_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ed egli rispose: “Farò come tu dici”. E Giacobbe disse: “Giuramelo”. E Giuseppe glielo giurò. E Israele, vòlto al capo del letto, adorò. ");
INSERT INTO ita1927_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Dopo queste cose, avvenne che fu detto a Giuseppe: “Ecco, tuo padre è ammalato”. Ed egli prese seco i suoi due figliuoli, Manasse ed Efraim. ");
INSERT INTO ita1927_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Giacobbe ne fu informato, e gli fu detto: “Ecco, il tuo figliuolo Giuseppe viene da te”. E Israele raccolse le sue forze, e si mise a sedere sul letto. ");
INSERT INTO ita1927_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","E Giacobbe disse a Giuseppe: “L’Iddio onnipotente mi apparve a Luz nel paese di Canaan, mi benedisse, ");
INSERT INTO ita1927_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","e mi disse: Ecco, io ti farò fruttare, ti moltiplicherò, ti farò diventare una moltitudine di popoli, e darò questo paese alla tua progenie dopo di te, come un possesso perpetuo. ");
INSERT INTO ita1927_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","E ora, i tuoi due figliuoli che ti son nati nel paese d’Egitto prima ch’io venissi da te in Egitto, sono miei. Efraim e Manasse saranno miei, come Ruben e Simeone. ");
INSERT INTO ita1927_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ma i figliuoli che hai generati dopo di loro, saranno tuoi; essi saranno chiamati col nome dei loro fratelli, quanto alla loro eredità. ");
INSERT INTO ita1927_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Quanto a me, allorché tornavo da Paddan, Rachele morì presso di me, nel paese di Canaan, durante il viaggio, a qualche distanza da Efrata; e la seppellii quivi, sulla via di Efrata, che è Bethlehem”. ");
INSERT INTO ita1927_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Israele guardò i figliuoli di Giuseppe, e disse: “Questi, chi sono?” ");
INSERT INTO ita1927_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","E Giuseppe rispose a suo padre: “Sono miei figliuoli, che Dio mi ha dati qui”. Ed egli disse: “Deh, fa’ che si appressino a me, e io li benedirò”. ");
INSERT INTO ita1927_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Or gli occhi d’Israele erano annebbiati a motivo dell’età, sì che non ci vedeva più. E Giuseppe li fece avvicinare a lui, ed egli li baciò e li abbracciò. ");
INSERT INTO ita1927_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","E Israele disse a Giuseppe: “Io non pensavo di riveder più la tua faccia; ed ecco che Iddio m’ha dato di vedere anche la tua progenie”. ");
INSERT INTO ita1927_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Giuseppe li ritirò di tra le ginocchia di suo padre, e si prostrò con la faccia a terra. ");
INSERT INTO ita1927_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Poi Giuseppe li prese ambedue: Efraim alla sua destra, alla sinistra d’Israele; e Manasse alla sua sinistra, alla destra d’Israele; e li fece avvicinare a lui. ");
INSERT INTO ita1927_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","E Israele stese la sua man destra, e la posò sul capo di Efraim ch’era il più giovane; e posò la sua mano sinistra sul capo di Manasse, incrociando le mani; poiché Manasse era il primogenito. ");
INSERT INTO ita1927_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","E benedisse Giuseppe, e disse: “L’Iddio, nel cui cospetto camminarono i miei padri Abrahamo e Isacco, l’Iddio ch’è stato il mio pastore dacché esisto fino a questo giorno, ");
INSERT INTO ita1927_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","l’angelo che mi ha liberato da ogni male, benedica questi fanciulli! Siano chiamati col mio nome e col nome de’ miei padri Abrahamo ed Isacco, e moltiplichino copiosamente sulla terra!” ");
INSERT INTO ita1927_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Or quando Giuseppe vide che suo padre posava la man destra sul capo di Efraim, n’ebbe dispiacere, e prese la mano di suo padre per levarla di sul capo di Efraim e metterla sul capo di Manasse. ");
INSERT INTO ita1927_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","E Giuseppe disse a suo padre: “Non così, padre mio; perché questo è il primogenito; metti la tua man destra sul suo capo”. ");
INSERT INTO ita1927_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ma suo padre ricusò e disse: “Lo so, figliuol mio, lo so; anch’egli diventerà un popolo, e anch’egli sarà grande; nondimeno, il suo fratello più giovane sarà più grande di lui, e la sua progenie diventerà una moltitudine di nazioni”. ");
INSERT INTO ita1927_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","E in quel giorno li benedisse, dicendo: “Per te Israele benedirà, dicendo: Iddio ti faccia simile ad Efraim ed a Manasse!” E mise Efraim prima di Manasse. ");
INSERT INTO ita1927_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Poi Israele disse a Giuseppe: “Ecco, io mi muoio; ma Dio sarà con voi, e vi ricondurrà nel paese dei vostri padri. ");
INSERT INTO ita1927_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","E io ti do una parte di più che ai tuoi fratelli: quella che conquistai dalle mani degli Amorei, con la mia spada e col mio arco”. ");
INSERT INTO ita1927_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Poi Giacobbe chiamò i suoi figliuoli, e disse: “Adunatevi, e vi annunzierò ciò che vi avverrà ne’ giorni a venire. ");
INSERT INTO ita1927_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Adunatevi e ascoltate, o figliuoli di Giacobbe! Date ascolto a Israele, vostro padre! ");
INSERT INTO ita1927_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, tu sei il mio primogenito, la mia forza, la primizia del mio vigore, eminente in dignità ed eminente in forza. ");
INSERT INTO ita1927_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Impetuoso come l’acqua, tu non avrai la preeminenza, perché sei salito sul letto di tuo padre. Allora tu l’hai profanato. Egli è salito sul mio letto. ");
INSERT INTO ita1927_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeone e Levi sono fratelli: le loro spade sono strumenti di violenza. ");
INSERT INTO ita1927_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Non entri l’anima mia nel loro consiglio segreto, non si unisca la mia gloria alla loro raunanza! Poiché nella loro ira hanno ucciso degli uomini, e nel loro mal animo han tagliato i garetti ai tori. ");
INSERT INTO ita1927_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Maledetta l’ira loro, perch’è stata violenta, e il loro furore perch’è stato crudele! Io li dividerò in Giacobbe, e li disperderò in Israele. ");
INSERT INTO ita1927_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Giuda, te loderanno i tuoi fratelli; la tua mano sarà sulla cervice de’ tuoi nemici; i figliuoli di tuo padre si prostreranno dinanzi a te. ");
INSERT INTO ita1927_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Giuda è un giovine leone; tu risali dalla preda, figliuol mio; egli si china, s’accovaccia come un leone, come una leonessa: chi lo farà levare? ");
INSERT INTO ita1927_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Lo scettro non sarà rimosso da Giuda, né il bastone del comando di fra i suoi piedi, finché venga Colui che darà il riposo, e al quale ubbidiranno i popoli. ");
INSERT INTO ita1927_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Egli lega il suo asinello alla vite, e il puledro della sua asina, alla vite migliore; lava la sua veste col vino, e il suo manto col sangue dell’uva. ");
INSERT INTO ita1927_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Egli ha gli occhi rossi dal vino, e i denti bianchi dal latte. ");
INSERT INTO ita1927_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zabulon abiterà sulla costa dei mari; sarà sulla costa ove convengon le navi, e il suo fianco s’appoggerà a Sidon. ");
INSERT INTO ita1927_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issacar è un asino robusto, sdraiato fra i tramezzi del chiuso. ");
INSERT INTO ita1927_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Egli ha visto che il riposo è buono, e che il paese è ameno; ha curvato la spalla per portare il peso, ed è divenuto un servo forzato al lavoro. ");
INSERT INTO ita1927_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan giudicherà il suo popolo, come una delle tribù d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan sarà una serpe sulla strada, una cerasta sul sentiero, che morde i talloni del cavallo, sì che il cavaliere cade all’indietro. ");
INSERT INTO ita1927_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Io ho aspettato la tua salvezza, o Eterno! ");
INSERT INTO ita1927_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad, l’assaliranno delle bande armate, ma egli a sua volta le assalirà, e le inseguirà. ");
INSERT INTO ita1927_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Da Ascer verrà il pane saporito, ed ei fornirà delizie reali. ");
INSERT INTO ita1927_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Neftali è una cerva messa in libertà; egli dice delle belle parole. ");
INSERT INTO ita1927_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Giuseppe e un ramo d’albero fruttifero; un ramo d’albero fruttifero vicino a una sorgente; i suoi rami si stendono sopra il muro. ");
INSERT INTO ita1927_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Gli arcieri l’hanno provocato, gli han lanciato dei dardi, l’hanno perseguitato; ");
INSERT INTO ita1927_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","ma l’arco suo è rimasto saldo; le sue braccia e le sue mani sono state rinforzate dalle mani del Potente di Giacobbe, da colui ch’è il pastore e la roccia d’Israele, ");
INSERT INTO ita1927_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","dall’Iddio di tuo padre che t’aiuterà, e dall’Altissimo che ti benedirà con benedizioni del cielo di sopra, con benedizioni dell’abisso che giace di sotto, con benedizioni delle mammelle e del seno materno. ");
INSERT INTO ita1927_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Le benedizioni di tuo padre sorpassano le benedizioni dei miei progenitori, fino a raggiunger la cima delle colline eterne. Esse saranno sul capo di Giuseppe, sulla fronte del principe de’ suoi fratelli. ");
INSERT INTO ita1927_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Beniamino è un lupo rapace; la mattina divora la preda, e la sera spartisce le spoglie”. ");
INSERT INTO ita1927_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Tutti costoro sono gli antenati delle dodici tribù d’Israele; e questo è quello che il loro padre disse loro, quando li benedisse. Li benedisse, dando a ciascuno la sua benedizione particolare. ");
INSERT INTO ita1927_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Poi dette loro i suoi ordini, e disse: “Io sto per essere riunito al mio popolo; seppellitemi coi miei padri nella spelonca ch’è nel campo di Efron lo Hitteo, ");
INSERT INTO ita1927_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","nella spelonca ch’è nel campo di Macpela, dirimpetto a Mamre, nel paese di Canaan, la quale Abrahamo comprò, col campo, da Efron lo Hitteo, come sepolcro di sua proprietà. ");
INSERT INTO ita1927_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Quivi furon sepolti Abrahamo e Sara sua moglie; quivi furon sepolti Isacco e Rebecca sua moglie, e quivi io seppellii Lea. ");
INSERT INTO ita1927_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Il campo e la spelonca che vi si trova, furon comprati dai figliuoli di Heth”. ");
INSERT INTO ita1927_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Quando Giacobbe ebbe finito di dare questi ordini ai suoi figliuoli, ritirò i piedi entrò il letto, e spirò, e fu riunito al suo popolo. ");
INSERT INTO ita1927_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Allora Giuseppe si gettò sulla faccia di suo padre, pianse su lui, e lo baciò. ");
INSERT INTO ita1927_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Poi Giuseppe ordinò ai medici ch’erano al suo servizio, d’imbalsamare suo padre; e i medici imbalsamarono Israele. ");
INSERT INTO ita1927_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ci vollero quaranta giorni; perché tanto è il tempo che s’impiega ad imbalsamare; e gli Egiziani lo piansero settanta giorni. ");
INSERT INTO ita1927_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","E quando i giorni del lutto fatto per lui furon passati, Giuseppe parlò alla casa di Faraone, dicendo: “Se ora ho trovato grazia agli occhi vostri, fate giungere agli orecchi di Faraone queste parole: ");
INSERT INTO ita1927_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Mio padre m’ha fatto giurare e m’ha detto: Ecco, io mi muoio; seppelliscimi nel mio sepolcro, che mi sono scavato nel paese di Canaan. Ora dunque, permetti ch’io salga e seppellisca mio padre; poi tornerò”. ");
INSERT INTO ita1927_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","E Faraone rispose: “Sali, e seppellisci tuo padre come t’ha fatto giurare”. ");
INSERT INTO ita1927_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Allora Giuseppe salì a seppellire suo padre; e con lui salirono tutti i servitori di Faraone, gli Anziani della sua casa e tutti gli Anziani del paese d’Egitto, ");
INSERT INTO ita1927_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","e tutta la casa di Giuseppe e i suoi fratelli e la casa di suo padre. Non lasciarono nel paese di Goscen che i loro bambini, i loro greggi e i loro armenti. ");
INSERT INTO ita1927_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Con lui salirono pure carri e cavalieri; talché il corteggio era numerosissimo. ");
INSERT INTO ita1927_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","E come furon giunti all’aia di Atad, ch’è oltre il Giordano, vi fecero grandi e profondi lamenti; e Giuseppe fece a suo padre un lutto di sette giorni. ");
INSERT INTO ita1927_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Or quando gli abitanti del paese, i Cananei, videro il lutto dell’aia di Atad, dissero: “Questo e un grave lutto per gli Egiziani!” Perciò fu messo nome Abel-Mitsraim a quell’aia, ch’è oltre il Giordano. ");
INSERT INTO ita1927_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","I figliuoli di Giacobbe fecero per lui quello ch’egli aveva ordinato loro: ");
INSERT INTO ita1927_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","lo trasportarono nel paese di Canaan, e lo seppellirono nella spelonca del campo di Macpela, che Abrahamo avea comprato, col campo, da Efron lo Hitteo, come sepolcro di sua proprietà, dirimpetto a Mamre. ");
INSERT INTO ita1927_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Giuseppe, dopo ch’ebbe sepolto suo padre, se ne tornò in Egitto coi suoi fratelli e con tutti quelli ch’erano saliti con lui a seppellire suo padre. ");
INSERT INTO ita1927_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","I fratelli di Giuseppe, quando videro che il loro padre era morto, dissero: “Chi sa che Giuseppe non ci porti odio, e non ci renda tutto il male che gli abbiam fatto!” ");
INSERT INTO ita1927_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","E mandarono a dire a Giuseppe: “Tuo padre, prima di morire, dette quest’ordine: ");
INSERT INTO ita1927_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Dite così a Giuseppe: Deh, perdona ora ai tuoi fratelli il loro misfatto e il loro peccato; perché t’hanno fatto del male. Deh, perdona dunque ora il misfatto de’ servi dell’Iddio di tuo padre!” E Giuseppe, quando gli fu parlato così, pianse. ");
INSERT INTO ita1927_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","E i suoi fratelli vennero anch’essi, si prostrarono ai suoi piedi, e dissero: “Ecco, siamo tuoi servi”. ");
INSERT INTO ita1927_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","E Giuseppe disse loro: “Non temete; poiché son io forse al posto di Dio? ");
INSERT INTO ita1927_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Voi avevate pensato del male contro a me; ma Dio ha pensato di convertirlo in bene, per compiere quello che oggi avviene: per conservare in vita un popolo numeroso. ");
INSERT INTO ita1927_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ora dunque non temete; io sostenterò voi e i vostri figliuoli”. E li confortò, e parlò al loro cuore. ");
INSERT INTO ita1927_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Giuseppe dimorò in Egitto: egli, con la casa di suo padre; e visse centodieci anni. ");
INSERT INTO ita1927_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Giuseppe vide i figliuoli di Efraim, fino alla terza generazione; anche i figliuoli di Makir, figliuolo di Manasse, nacquero sulle sue ginocchia. ");
INSERT INTO ita1927_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","E Giuseppe disse ai suoi fratelli: “Io sto per morire; ma Dio per certo vi visiterà, e vi farà salire, da questo paese, nel paese che promise con giuramento ad Abrahamo, a Isacco e a Giacobbe”. ");
INSERT INTO ita1927_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","E Giuseppe fece giurare i figliuoli d’Israele, dicendo: “Iddio per certo vi visiterà; allora, trasportate di qui le mie ossa”. ");
INSERT INTO ita1927_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Poi Giuseppe morì, in età di centodieci anni; e fu imbalsamato, e posto in una bara in Egitto. ");
INSERT INTO ita1927_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Or questi sono i nomi dei figliuoli d’Israele che vennero in Egitto. Essi ci vennero con Giacobbe, ciascuno con la sua famiglia: ");
INSERT INTO ita1927_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeone, Levi e Giuda; ");
INSERT INTO ita1927_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issacar, Zabulon e Beniamino; ");
INSERT INTO ita1927_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan e Neftali, Gad e Ascer. ");
INSERT INTO ita1927_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Tutte le persone discendenti da Giacobbe ammontavano a settanta. Giuseppe era già in Egitto. ");
INSERT INTO ita1927_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","E Giuseppe morì, come moriron pure tutti i suoi fratelli e tutta quella generazione. ");
INSERT INTO ita1927_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","E i figliuoli d’Israele furon fecondi, moltiplicarono copiosamente, diventarono numerosi e si fecero oltremodo potenti, e il paese ne fu ripieno. ");
INSERT INTO ita1927_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Or sorse sopra l’Egitto un nuovo re, che non avea conosciuto Giuseppe. ");
INSERT INTO ita1927_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Egli disse al suo popolo: “Ecco, il popolo de’ figliuoli d’Israele è più numeroso e più potente di noi. ");
INSERT INTO ita1927_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Orsù, usiamo prudenza con essi; che non abbiano a moltiplicare e, in caso di guerra, non abbiano a unirsi ai nostri nemici e combattere contro di noi e poi andarsene dal paese”. ");
INSERT INTO ita1927_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Stabilirono dunque sopra Israele de’ soprastanti ai lavori, che l’opprimessero con le loro angherie. Ed esso edificò a Faraone le città di approvvigionamento, Pithom e Raamses. ");
INSERT INTO ita1927_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ma più l’opprimevano, e più il popolo moltiplicava e s’estendeva; e gli Egiziani presero in avversione i figliuoli d’Israele, ");
INSERT INTO ita1927_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","e fecero servire i figliuoli d’Israele con asprezza, ");
INSERT INTO ita1927_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","e amareggiaron loro la vita con una dura servitù, adoprandoli nei lavori d’argilla e di mattoni, e in ogni sorta di lavori nei campi. E imponevano loro tutti questi lavori, con asprezza. ");
INSERT INTO ita1927_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Il re d’Egitto parlò anche alle levatrici degli Ebrei, delle quali l’una si chiamava Scifra e l’altra Pua. E disse: ");
INSERT INTO ita1927_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Quando assisterete le donne ebree al tempo del parto, e le vedrete sulla seggiola, se è un maschio, uccidetelo; ma se è una femmina, lasciatela vivere”. ");
INSERT INTO ita1927_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ma le levatrici temettero Iddio, e non fecero quello che il re d’Egitto aveva ordinato loro; lasciarono vivere i maschi. ");
INSERT INTO ita1927_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Allora il re d’Egitto chiamò le levatrici, e disse loro: “Perché avete fatto questo, e avete lasciato vivere i maschi?” ");
INSERT INTO ita1927_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","E le levatrici risposero a Faraone: “Egli è che le donne ebree non sono come le egiziane; sono vigorose, e, prima che la levatrice arrivi da loro, hanno partorito”. ");
INSERT INTO ita1927_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","E Dio fece del bene a quelle levatrici; e il popolo moltiplicò e divenne oltremodo potente. ");
INSERT INTO ita1927_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","E perché quelle levatrici temettero Iddio, egli fece prosperare le loro case. ");
INSERT INTO ita1927_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Allora Faraone diede quest’ordine al suo popolo: “Ogni maschio che nasce, gettatelo nel fiume; ma lasciate vivere tutte le femmine”. ");
INSERT INTO ita1927_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Or un uomo della casa di Levi andò e prese per moglie una figliuola di Levi. ");
INSERT INTO ita1927_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Questa donna concepì, e partorì un figliuolo; e vedendo com’egli era bello, lo tenne nascosto tre mesi. ");
INSERT INTO ita1927_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","E quando non poté più tenerlo nascosto, prese un canestro fatto di giunchi, lo spalmò di bitume e di pece, vi pose dentro il bambino, e lo mise nel canneto sulla riva del fiume. ");
INSERT INTO ita1927_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","E la sorella del bambino se ne stava a una certa distanza, per sapere quel che gli succederebbe. ");
INSERT INTO ita1927_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Or la figliuola di Faraone scese a fare le sue abluzioni sulla riva del fiume; e le sue donzelle passeggiavano lungo il fiume. Ella vide il canestro nel canneto, e mandò la sua cameriera a prenderlo. ");
INSERT INTO ita1927_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","L’aprì, e vide il bimbo; ed ecco, il piccino piangeva; ed ella n’ebbe compassione, e disse: “Questo è uno de’ figliuoli degli Ebrei”. ");
INSERT INTO ita1927_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Allora la sorella del bambino disse alla figliuola di Faraone: “Devo andare a chiamarti una balia tra le donne ebree che t’allatti questo bimbo?” ");
INSERT INTO ita1927_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","La figliuola di Faraone le rispose: “Va’”. E la fanciulla andò a chiamare la madre del bambino. ");
INSERT INTO ita1927_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","E la figliuola di Faraone le disse: “Porta via questo bambino, allattamelo, e io ti darò il tuo salario”. E quella donna prese il bambino e l’allattò. ");
INSERT INTO ita1927_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","E quando il bambino fu cresciuto, ella lo menò dalla figliuola di Faraone: esso fu per lei come un figliuolo, ed ella gli pose nome Mosè; “Perché, disse, io l’ho tratto dall’acqua”. ");
INSERT INTO ita1927_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Or in que’ giorni, quando Mosè era già diventato grande, avvenne ch’egli uscì a trovare i suoi fratelli, e notò i lavori di cui erano gravati; e vide un Egiziano, che percoteva uno degli Ebrei suoi fratelli. ");
INSERT INTO ita1927_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Egli volse lo sguardo di qua e di là; e, visto che non c’era nessuno, uccise l’Egiziano, e lo nascose nella sabbia. ");
INSERT INTO ita1927_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Il giorno seguente uscì, ed ecco due Ebrei che si litigavano; ed egli disse a quello che avea torto: “Perché percuoti il tuo compagno?” ");
INSERT INTO ita1927_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","E quegli rispose: “Chi t’ha costituito principe e giudice sopra di noi? Vuoi tu uccider me come uccidesti l’Egiziano?” Allora Mosè ebbe paura, e disse: “Certo, la cosa è nota”. ");
INSERT INTO ita1927_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","E quando Faraone udì il fatto, cercò di uccidere Mosè; ma Mosè fuggì dal cospetto di Faraone, e si fermò nel paese di Madian; e si mise a sedere presso ad un pozzo. ");
INSERT INTO ita1927_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Or il sacerdote di Madian aveva sette figliuole; ed esse vennero ad attinger acqua, e a riempire gli abbeveratoi per abbeverare il gregge del padre loro. ");
INSERT INTO ita1927_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ma sopraggiunsero i pastori, che le scacciarono. Allora Mosè si levò, prese la loro difesa, e abbeverò il loro gregge. ");
INSERT INTO ita1927_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","E com’esse giunsero da Reuel loro padre, questi disse: “Come mai siete tornate così presto oggi?” ");
INSERT INTO ita1927_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ed esse risposero: “Un Egiziano ci ha liberate dalle mani de’ pastori, e di più ci ha attinto l’acqua, ed ha abbeverato il gregge”. ");
INSERT INTO ita1927_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ed egli disse alle sue figliuole: “E dov’è? Perché avete lasciato là quell’uomo? Chiamatelo, che prenda qualche cibo”. ");
INSERT INTO ita1927_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","E Mosè acconsentì a stare da quell’uomo; ed egli diede a Mosè Sefora, sua figliuola. ");
INSERT INTO ita1927_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Ed ella partorì un figliuolo ch’egli chiamò Ghershom; “perché, disse, io soggiorno in terra straniera”. ");
INSERT INTO ita1927_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Or nel corso di quel tempo, che fu lungo, avvenne che il re d’Egitto morì; e i figliuoli d’Israele sospiravano a motivo della schiavitù, e alzavan delle grida; e le grida che il servaggio strappava loro salirono a Dio. ");
INSERT INTO ita1927_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","E Dio udì i loro gemiti; e Dio si ricordò dei suo patto con Abrahamo, con Isacco e con Giacobbe. ");
INSERT INTO ita1927_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","E Dio vide i figliuoli d’Israele, e Dio ebbe riguardo alla loro condizione. ");
INSERT INTO ita1927_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Or Mosè pasceva il gregge di Jethro suo suocero, sacerdote di Madian; e guidando il gregge dietro al deserto, giunse alla montagna di Dio, a Horeb. ");
INSERT INTO ita1927_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","E l’angelo dell’Eterno gli apparve in una fiamma di fuoco, di mezzo a un pruno. Mosè guardò, ed ecco il pruno era tutto in fiamme, ma non si consumava. ");
INSERT INTO ita1927_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","E Mosè disse: “Ora voglio andar da quella parte a vedere questa grande visione e come mai il pruno non si consuma!” ");
INSERT INTO ita1927_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","E l’Eterno vide ch’egli s’era scostato per andare a vedere. E Dio lo chiamò di mezzo al pruno, e disse: “Mosè! Mosè!” Ed egli rispose: “Eccomi”. ");
INSERT INTO ita1927_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","E Dio disse: “Non t’avvicinar qua; togliti i calzari dai piedi, perché il luogo sul quale stai, e suolo sacro”. ");
INSERT INTO ita1927_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Poi aggiunse: “Io sono l’Iddio di tuo padre, l’Iddio d’Abrahamo, l’Iddio d’Isacco e l’Iddio di Giacobbe”. E Mosè si nascose la faccia, perché avea paura di guardare Iddio. ");
INSERT INTO ita1927_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","E l’Eterno disse: “Ho veduto, ho veduto l’afflizione del mio popolo che è in Egitto, e ho udito il grido che gli strappano i suoi angariatori; perché conosco i suoi affanni; ");
INSERT INTO ita1927_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","e sono sceso per liberarlo dalla mano degli Egiziani, e per farlo salire da quel paese in un paese buono e spazioso, in un paese ove scorre il latte e il miele, nel luogo dove sono i Cananei, gli Hittei, gli Amorei, i Ferezei, gli Hivvei e i Gebusei. ");
INSERT INTO ita1927_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ed ora, ecco, le grida de’ figliuoli d’Israele son giunte a me, ed ho anche veduto l’oppressione che gli Egiziani fanno loro soffrire. ");
INSERT INTO ita1927_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Or dunque vieni, e io ti manderò a Faraone perché tu faccia uscire il mio popolo, i figliuoli d’Israele, dall’Egitto”. ");
INSERT INTO ita1927_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","E Mosè disse a Dio: “Chi son io per andare da Faraone e per trarre i figliuoli d’Israele dall’Egitto?” ");
INSERT INTO ita1927_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","E Dio disse: “Va’, perché io sarò teco; e questo sarà per te il segno che son io che t’ho mandato: quando avrai tratto il popolo dall’Egitto, voi servirete Iddio su questo monte”. ");
INSERT INTO ita1927_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","E Mosè disse a Dio: “Ecco, quando sarò andato dai figliuoli d’Israele e avrò detto loro: L’Iddio de’ vostri padri m’ha mandato da voi, se essi mi dicono: Qual è il suo nome? che risponderò loro?” ");
INSERT INTO ita1927_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Iddio disse a Mosè: “Io sono quegli che sono”. Poi disse: “Dirai così ai figliuoli d’Israele: L’Io sono m’ha mandato da voi”. ");
INSERT INTO ita1927_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Iddio disse ancora a Mosè: “Dirai così ai figliuoli d’Israele: L’Eterno, l’Iddio de’ vostri padri, l’Iddio d’Abrahamo, l’Iddio d’Isacco e l’Iddio di Giacobbe mi ha mandato da voi. Tale è il mio nome in perpetuo, tale la mia designazione per tutte le generazioni. ");
INSERT INTO ita1927_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Va’ e raduna gli anziani d’Israele, e di’ loro: L’Eterno, l’Iddio de’ vostri padri, l’Iddio d’Abrahamo, d’Isacco e di Giacobbe m’è apparso, dicendo: Certo, io vi ho visitati, e ho veduto quello che vi si fa in Egitto; ");
INSERT INTO ita1927_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","e ho detto: Io vi trarrò dall’afflizione d’Egitto, e vi farò salire nel paese dei Cananei, degli Hittei, degli Amorei, de’ Ferezei, degli Hivvei e de’ Gebusei, in un paese ove scorre il latte e il miele. ");
INSERT INTO ita1927_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Ed essi ubbidiranno alla tua voce; e tu, con gli anziani d’Israele, andrai dal re d’Egitto, e gli direte: L’Eterno, l’Iddio degli Ebrei, ci è venuto incontro; or dunque, lasciaci andare tre giornate di cammino nel deserto, per offrir sacrifizi all’Eterno, all’Iddio nostro. ");
INSERT INTO ita1927_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Or io so che il re d’Egitto non vi concederà d’andare, se non forzato da una potente mano. ");
INSERT INTO ita1927_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","E io stenderò la mia mano e percoterò l’Egitto con tutti i miracoli che io farò in mezzo ad esso; e, dopo questo, vi lascerà andare. ");
INSERT INTO ita1927_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","E farò sì che questo popolo trovi favore presso gli Egiziani; e avverrà che, quando ve ne andrete, non ve ne andrete a mani vuote; ");
INSERT INTO ita1927_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","ma ogni donna domanderà alla sua vicina e alla sua casigliana degli oggetti d’argento, degli oggetti d’oro e dei vestiti; voi li metterete addosso ai vostri figliuoli e alle vostre figliuole, e così spoglierete gli Egiziani”. ");
INSERT INTO ita1927_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mosè rispose e disse: “Ma ecco, essi non mi crederanno e non ubbidiranno alla mia voce, perché diranno: L’Eterno non t’è apparso”. ");
INSERT INTO ita1927_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","E l’Eterno gli disse: “Che è quello che hai in mano?” Egli rispose: “Un bastone”. ");
INSERT INTO ita1927_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","E l’Eterno disse: “Gettalo in terra”. Egli lo gettò in terra, ed esso diventò un serpente; e Mosè fuggì d’innanzi a quello. ");
INSERT INTO ita1927_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Allora l’Eterno disse a Mosè: “Stendi la tua mano, e prendilo per la coda”. Egli stese la mano, e lo prese, ed esso ritornò un bastone nella sua mano. ");
INSERT INTO ita1927_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“Questo farai, disse l’Eterno, affinché credano che l’Eterno, l’Iddio dei loro padri, l’Iddio d’Abrahamo, l’Iddio d’Isacco e l’Iddio di Giacobbe t’è apparso”. ");
INSERT INTO ita1927_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","L’Eterno gli disse ancora: “Mettiti la mano in seno”. Ed egli si mise la mano in seno; poi, cavatala fuori, ecco che la mano era lebbrosa, bianca come neve. ");
INSERT INTO ita1927_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","E l’Eterno gli disse: “Rimettiti la mano in seno”. Egli si rimise la mano in seno; poi, cavatasela di seno, ecco ch’era ritornata come l’altra sua carne. ");
INSERT INTO ita1927_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","“Or avverrà, disse l’Eterno, che, se non ti crederanno e non daranno ascolto alla voce del primo segno, crederanno alla voce del secondo segno; ");
INSERT INTO ita1927_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","e se avverrà che non credano neppure a questi due segni e non ubbidiscano alla tua voce, tu prenderai dell’acqua del fiume, e la verserai sull’asciutto; e l’acqua che avrai presa dal fiume, diventerà sangue sull’asciutto”. ");
INSERT INTO ita1927_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","E Mosè disse all’Eterno: “Ahimè, Signore, io non sono un parlatore; non lo ero in passato, e non lo sono da quando tu hai parlato al tuo servo; giacché io sono tardo di parola e di lingua”. ");
INSERT INTO ita1927_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","E l’Eterno gli disse: “Chi ha fatto la bocca dell’uomo? o chi rende muto o sordo o veggente o cieco? non son io, l’Eterno? ");
INSERT INTO ita1927_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Or dunque va’, e io sarò con la tua bocca, e t’insegnerò quello che dovrai dire”. ");
INSERT INTO ita1927_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","E Mosè disse: “Deh! Signore, manda il tuo messaggio per mezzo di chi vorrai!” ");
INSERT INTO ita1927_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Allora l’ira dell’Eterno s’accese contro Mosè, ed egli disse: “Non c’è Aaronne tuo fratello, il Levita? Io so che parla bene. E per l’appunto, ecco ch’egli esce ad incontrarti; e, come ti vedrà, si rallegrerà in cuor suo. ");
INSERT INTO ita1927_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Tu gli parlerai, e gli metterai le parole in bocca; io sarò con la tua bocca e con la bocca sua, e v’insegnerò quello che dovrete fare. ");
INSERT INTO ita1927_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Egli parlerà per te al popolo; e così ti servirà di bocca, e tu sarai per lui come Dio. ");
INSERT INTO ita1927_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Or prendi in mano questo bastone col quale farai i prodigi”. ");
INSERT INTO ita1927_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Allora Mosè se ne andò, tornò da Jethro suo suocero, e gli disse: “Deh, lascia ch’io me ne vada e torni dai miei fratelli che sono in Egitto, e vegga se sono ancor vivi”. E Jethro disse a Mosè: “Va’ in pace”. ");
INSERT INTO ita1927_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Or l’Eterno disse a Mosè in Madian: “Va’, tornatene in Egitto, perché tutti quelli che cercavano di toglierti la vita sono morti”. ");
INSERT INTO ita1927_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Mosè dunque prese la sua moglie e i suoi figliuoli, li pose su degli asini, e tornò nei paese d’Egitto; e Mosè prese nella sua mano il bastone di Dio. ");
INSERT INTO ita1927_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","E l’Eterno disse a Mosè: “Quando sarai tornato in Egitto, avrai cura di fare dinanzi a Faraone tutti i prodigi che t’ho dato potere di compiere; ma io gl’indurerò il cuore, ed egli non lascerà partire il popolo. ");
INSERT INTO ita1927_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","E tu dirai a Faraone: Così dice l’Eterno: Israele è il mio figliuolo, il mio primogenito; ");
INSERT INTO ita1927_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","e io ti dico: Lascia andare il mio figliuolo, affinché mi serva; e se tu ricusi di lasciarlo andare, ecco, io ucciderò il tuo figliuolo, il tuo primogenito”. ");
INSERT INTO ita1927_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Or avvenne che, essendo Mosè in viaggio, nel luogo dov’egli albergava, l’Eterno gli si fece incontro, e cercò di farlo morire. ");
INSERT INTO ita1927_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Allora Sefora prese una selce tagliente, recise il prepuzio del suo figliuolo, e lo gettò ai piedi di Mosè, dicendo: “Sposo di sangue tu mi sei!” ");
INSERT INTO ita1927_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","E l’Eterno lo lasciò. Allora ella disse: “Sposo di sangue, per via della circoncisione”. ");
INSERT INTO ita1927_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","L’Eterno disse ad Aaronne: “Va’ nel deserto incontro a Mosè”. Ed egli andò, lo incontrò al monte di Dio, e lo baciò. ");
INSERT INTO ita1927_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","E Mosè riferì ad Aaronne tutte le parole che l’Eterno l’aveva incaricato di dire, e tutti i segni portentosi che gli aveva ordinato di fare. ");
INSERT INTO ita1927_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Mosè ed Aaronne dunque andarono, e radunarono tutti gli anziani de’ figliuoli d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","E Aaronne riferì tutte le parole che l’Eterno avea dette a Mosè, e fece i prodigi in presenza del popolo. ");
INSERT INTO ita1927_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","E il popolo prestò loro fede. Essi intesero che l’Eterno avea visitato i figliuoli d’Israele e avea veduto la loro afflizione, e s’inchinarono e adorarono. ");
INSERT INTO ita1927_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Dopo questo, Mosè ed Aaronne vennero a Faraone, e gli dissero: “Così dice l’Eterno, l’Iddio d’Israele: Lascia andare il mio popolo, perché mi celebri una festa nel deserto”. ");
INSERT INTO ita1927_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Ma Faraone rispose: “Chi è l’Eterno ch’io debba ubbidire alla sua voce e lasciar andare Israele? Io non conosco l’Eterno, e non lascerò affatto andare Israele”. ");
INSERT INTO ita1927_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ed essi dissero: “L’Iddio degli Ebrei si è presentato a noi; lasciaci andare tre giornate di cammino nel deserto per offrir sacrifizi all’Eterno, ch’è il nostro Dio, onde ei non abbia a colpirci con la peste o con la spada”. ");
INSERT INTO ita1927_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","E il re d’Egitto disse loro: “O Mosè e Aaronne, perché distraete il popolo dai suoi lavori? Andate a fare quello che vi è imposto!” ");
INSERT INTO ita1927_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","E Faraone disse: “Ecco, il popolo è ora numeroso nel paese, e voi gli fate interrompere i lavori che gli sono imposti”. ");
INSERT INTO ita1927_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","E quello stesso giorno Faraone dette quest’ordine agli ispettori del popolo e ai suoi sorveglianti: ");
INSERT INTO ita1927_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Voi non darete più, come prima, la paglia al popolo per fare i mattoni; vadano essi a raccogliersi della paglia! ");
INSERT INTO ita1927_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","E imponete loro la stessa quantità di mattoni di prima, senza diminuzione alcuna; perché son de’ pigri; e però gridano dicendo: Andiamo a offrir sacrifizi al nostro Dio! ");
INSERT INTO ita1927_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Sia questa gente caricata di lavoro; e si occupi di quello senza badare a parole di menzogna”. ");
INSERT INTO ita1927_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Allora gl’ispettori del popolo e i sorveglianti uscirono e dissero al popolo: “Così dice Faraone: Io non vi darò più paglia. ");
INSERT INTO ita1927_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Andate voi a procurarvi della paglia dove ne potrete trovare, perché il vostro lavoro non sarà diminuito per nulla”. ");
INSERT INTO ita1927_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Così il popolo si sparse per tutto il paese d’Egitto, per raccogliere della stoppia invece di paglia. ");
INSERT INTO ita1927_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","E gli ispettori li sollecitavano dicendo: “Compite i vostri lavori giorno per giorno, come quando c’era la paglia!” ");
INSERT INTO ita1927_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","E i sorveglianti de’ figliuoli d’Israele stabiliti sopra loro dagli ispettori di Faraone, furon battuti; e fu loro detto: “Perché non avete fornito, ieri e oggi come prima, la quantità di mattoni che v’è imposta?” ");
INSERT INTO ita1927_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Allora i sorveglianti dei figliuoli d’Israele vennero a lagnarsi da Faraone, dicendo: “Perché tratti così i tuoi servitori? ");
INSERT INTO ita1927_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Non si dà più paglia ai tuoi servitori, e ci si dice: Fate de’ mattoni! ed ecco che i tuoi servitori sono battuti, e il tuo popolo è considerato come colpevole!” ");
INSERT INTO ita1927_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ed egli rispose: “Siete dei pigri! siete dei pigri! Per questo dite: Andiamo a offrir sacrifizi all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Or dunque andate a lavorare! non vi si darà più paglia, e fornirete la quantità di mattoni prescritta”. ");
INSERT INTO ita1927_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","I sorveglianti de’ figliuoli d’Israele si videro ridotti a mal partito, perché si diceva loro: “Non diminuite per nulla il numero de’ mattoni impostovi giorno per giorno”. ");
INSERT INTO ita1927_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","E, uscendo da Faraone, incontrarono Mosè e Aaronne, che stavano ad aspettarli, ");
INSERT INTO ita1927_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","e dissero loro: “L’Eterno volga il suo sguardo su voi, e giudichi! poiché ci avete messi in cattivo odore dinanzi a Faraone e dinanzi ai suoi servitori, e avete loro messa la spada in mano perché ci uccida”. ");
INSERT INTO ita1927_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Allora Mosè tornò dall’Eterno, e disse: “Signore, perché hai fatto del male a questo popolo? Perché dunque mi hai mandato? ");
INSERT INTO ita1927_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Poiché, da quando sono andato da Faraone per parlargli in tuo nome, egli ha maltrattato questo popolo, e tu non hai affatto liberato il tuo popolo”. ");
INSERT INTO ita1927_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","L’Eterno disse a Mosè: “Ora vedrai quello che farò a Faraone; perché, forzato da una mano potente, li lascerà andare; anzi, forzato da una mano potente, li caccerà dal suo paese”. ");
INSERT INTO ita1927_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","E Dio parlò a Mosè, e gli disse: ");
INSERT INTO ita1927_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","“Io sono l’Eterno, e apparii ad Abrahamo, ad Isacco e a Giacobbe, come l’Iddio onnipotente; ma non fui conosciuto da loro sotto il mio nome di Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Stabilii pure con loro il mio patto, promettendo di dar loro il paese di Canaan, il paese dei loro pellegrinaggi, nel quale soggiornavano. ");
INSERT INTO ita1927_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ed ho anche udito i gemiti de’ figliuoli d’Israele che gli Egiziani tengono in schiavitù, e mi son ricordato del mio patto. ");
INSERT INTO ita1927_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Perciò di’ ai figliuoli d’Israele: Io sono l’Eterno, vi sottrarrò ai duri lavori di cui vi gravano gli Egiziani, vi emanciperò dalla loro schiavitù, e vi redimerò con braccio steso e con grandi giudizi. ");
INSERT INTO ita1927_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","E vi prenderò per mio popolo, e sarò vostro Dio; e voi conoscerete che io sono l’Eterno, il vostro Dio, che vi sottrae ai duri lavori impostivi dagli Egiziani. ");
INSERT INTO ita1927_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","E v’introdurrò nel paese, che giurai di dare ad Abrahamo, a Isacco e a Giacobbe; e ve lo darò come possesso ereditario: io sono l’Eterno”. ");
INSERT INTO ita1927_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","E Mosè parlò a quel modo ai figliuoli d’Israele; ma essi non dettero ascolto a Mosè, a motivo dell’angoscia dello spirito loro e della loro dura schiavitù. ");
INSERT INTO ita1927_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","E l’Eterno parlò a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Va’, parla a Faraone re d’Egitto, ond’egli lasci uscire i figliuoli d’Israele dal suo paese”. ");
INSERT INTO ita1927_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ma Mosè parlò nel cospetto dell’Eterno, e disse: “Ecco, i figliuoli d’Israele non mi hanno dato ascolto; come dunque darebbe Faraone ascolto a me che sono incirconciso di labbra?” ");
INSERT INTO ita1927_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","E l’Eterno parlò a Mosè e ad Aaronne, e comandò loro d’andare dai figliuoli d’Israele e da Faraone re d’Egitto, per trarre i figliuoli d’Israele dal paese d’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Questi sono i capi delle loro famiglie. Figliuoli di Ruben, primogenito d’Israele: Henoc e Pallu, Hetsron e Carmi. Questi sono i rami dei Rubeniti. ");
INSERT INTO ita1927_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Figliuoli di Simeone: Jemuel, Jamin, Ohad, Jakin, Tsochar e Saul, figliuolo della Cananea. Questi sono i rami dei Simeoniti. ");
INSERT INTO ita1927_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Questi sono i nomi dei figliuoli di Levi, secondo le loro generazioni: Gherson, Kehath e Merari. E gli anni della vita di Levi furono centotrenta sette. ");
INSERT INTO ita1927_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Figliuoli di Gherson: Libni e Scimei, con le loro diverse famiglie. ");
INSERT INTO ita1927_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Figliuoli di Kehath: Amram, Jitshar, Hebron e Uziel. E gli anni della vita di Kehath furono centotrentatre. ");
INSERT INTO ita1927_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Figliuoli di Merari: Mahli e Musci. Questi sono i rami dei Leviti, secondo le loro generazioni. ");
INSERT INTO ita1927_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Or Amram prese per moglie Iokebed, sua zia; ed ella gli partorì Aaronne e Mosè. E gli anni della vita di Amram furono centotrenta sette. ");
INSERT INTO ita1927_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Figliuoli di Jitshar: Kore, Nefeg e Zicri. ");
INSERT INTO ita1927_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Figliuoli di Uziel: Mishael, Eltsafan e Sitri. ");
INSERT INTO ita1927_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaronne prese per moglie Elisceba, figliuola di Amminadab, sorella di Nahashon; ed ella gli partorì Nadab, Abihu, Eleazar e Ithamar. ");
INSERT INTO ita1927_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Figliuoli di Kore: Assir, Elkana e Abiasaf. Questi sono i rami dei Koriti. ");
INSERT INTO ita1927_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleazar, figliuolo d’Aaronne, prese per moglie una delle figliuole di Putiel; ed ella gli partorì Fineas. Questi sono i capi delle famiglie dei Leviti nei loro diversi rami. ");
INSERT INTO ita1927_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","E questo è quell’Aaronne e quel Mosè ai quali l’Eterno disse: “Fate uscire i figliuoli d’Israele dal paese d’Egitto, spartiti nelle loro schiere”. ");
INSERT INTO ita1927_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Essi son quelli che parlarono a Faraone re d’Egitto, per trarre i figliuoli d’Israele dall’Egitto: sono quel Mosè e quell’Aaronne. ");
INSERT INTO ita1927_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Or avvenne, allorché l’Eterno parlò a Mosè nel paese d’Egitto, ");
INSERT INTO ita1927_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","che l’Eterno disse a Mosè: “Io sono l’Eterno: di’ a Faraone, re d’Egitto, tutto quello che dico a te”. ");
INSERT INTO ita1927_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","E Mosè rispose, nel cospetto dell’Eterno: “Ecco, io sono incirconciso di labbra; come dunque Faraone mi porgerà egli ascolto?” ");
INSERT INTO ita1927_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","L’Eterno disse a Mosè: “Vedi, io ti ho stabilito come Dio per Faraone, e Aaronne tuo fratello sarà il tuo profeta. ");
INSERT INTO ita1927_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Tu dirai tutto quello che t’ordinerò, e Aaronne tuo fratello parlerà a Faraone, perché lasci partire i figliuoli d’Israele dal suo paese. ");
INSERT INTO ita1927_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","E io indurerò il cuore di Faraone, e moltiplicherò i miei segni e i miei prodigi nel paese d’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","E Faraone non vi darà ascolto; e io metterò la mia mano sull’Egitto, e farò uscire dal paese d’Egitto le mie schiere, il mio popolo, i figliuoli d’Israele, mediante grandi giudizi. ");
INSERT INTO ita1927_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","E gli Egiziani conosceranno che io sono l’Eterno, quando avrò steso la mia mano sull’Egitto e avrò tratto di mezzo a loro i figliuoli d’Israele”. ");
INSERT INTO ita1927_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","E Mosè e Aaronne fecero così; fecero come l’Eterno avea loro ordinato. ");
INSERT INTO ita1927_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Or Mosè aveva ottant’anni e Aaronne ottantatre, quando parlarono a Faraone. ");
INSERT INTO ita1927_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","L’Eterno parlò a Mosè e ad Aaronne, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Quando Faraone vi parlerà e vi dirà: Fate un prodigio! tu dirai ad Aaronne: Prendi il tuo bastone, gettalo davanti a Faraone, e diventerà un serpente”. ");
INSERT INTO ita1927_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Mosè ed Aaronne andaron dunque da Faraone, e fecero come l’Eterno aveva ordinato. Aaronne gettò il suo bastone davanti a Faraone e davanti ai suoi servitori, e quello diventò un serpente. ");
INSERT INTO ita1927_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Faraone a sua volta chiamò i savi e gl’incantatori; e i magi d’Egitto fecero anch’essi lo stesso, con le loro arti occulte. ");
INSERT INTO ita1927_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ognun d’essi gettò il suo bastone, e i bastoni diventaron serpenti; ma il bastone d’Aaronne inghiottì i bastoni di quelli. ");
INSERT INTO ita1927_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","E il cuore di Faraone s’indurò, ed egli non diè ascolto a Mosè e ad Aaronne, come l’Eterno avea detto. ");
INSERT INTO ita1927_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","L’Eterno disse a Mosè: “Il cuor di Faraone è ostinato; ");
INSERT INTO ita1927_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","egli rifiuta di lasciar andare il popolo. Va’ da Faraone domani mattina; ecco, egli uscirà per andare verso l’acqua; tu sta’ ad aspettarlo sulla riva del fiume, e prendi in mano il bastone ch’è stato mutato in serpente. ");
INSERT INTO ita1927_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","E digli: L’Eterno, l’Iddio degli Ebrei, m’ha mandato da te per dirti: Lascia andare il mio popolo, perché mi serva nel deserto; ed ecco, fino ad ora, tu non hai ubbidito. ");
INSERT INTO ita1927_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Così dice l’Eterno: Da questo conoscerai che io sono l’Eterno; ecco, io percoterò col bastone che ho in mia mano le acque che son nel fiume, ed esse saran mutate in sangue. ");
INSERT INTO ita1927_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","E il pesce ch’è nel fiume morrà, e il fiume cara ammorbato, e gli Egiziani avranno ripugnanza a bere l’acqua del fiume”. ");
INSERT INTO ita1927_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","E l’Eterno disse a Mosè: “Di’ ad Aaronne: Prendi il tuo bastone, e stendi la tua mano sulle acque dell’Egitto, sui loro fiumi, sui loro rivi, sui loro stagni e sopra ogni raccolta d’acqua; essi diventeranno sangue, e vi sarà sangue per tutto il paese d’Egitto, perfino ne’ recipienti di legno e ne’ recipienti di pietra”. ");
INSERT INTO ita1927_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mosè ed Aaronne fecero come l’Eterno aveva ordinato. Aaronne alzò il bastone, e in presenza di Faraone e in presenza dei suoi servitori percosse le acque ch’erano nel fiume; e tutte le acque ch’erano nel fiume furon cangiate in sangue. ");
INSERT INTO ita1927_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","E il pesce ch’era nel fiume morì; e il fiume fu ammorbato, sì che gli Egiziani non potevan bere l’acqua del fiume; e vi fu sangue per tutto il paese d’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","E i magi d’Egitto fecero lo stesso con le loro arti occulte; e il cuore di Faraone s’indurò ed egli non diè ascolto a Mosè e ad Aaronne, come l’Eterno avea detto. ");
INSERT INTO ita1927_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","E Faraone, volte ad essi le spalle, se ne andò a casa sua, e neanche di questo fece alcun caso. ");
INSERT INTO ita1927_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","E tutti gli Egiziani fecero degli scavi ne’ pressi del fiume per trovare dell’acqua da bere, perché non potevan bere l’acqua del fiume. ");
INSERT INTO ita1927_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","E passaron sette interi giorni, dopo che l’Eterno ebbe percosso il fiume. ");
INSERT INTO ita1927_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Poi l’Eterno disse a Mosè: “Va’ da Faraone, e digli: Così dice l’Eterno: Lascia andare il mio popolo perché mi serva. ");
INSERT INTO ita1927_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","E se rifiuti di lasciarlo andare, ecco, io colpirò tutta l’estensione del tuo paese col flagello delle rane; ");
INSERT INTO ita1927_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","e il fiume brulicherà di rane, che saliranno ed entreranno nella tua casa, nella camera ove dormi, sul tuo letto, nelle case de’ tuoi servitori e fra il tuo popolo, ne’ tuoi forni e nelle tue madie. ");
INSERT INTO ita1927_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","E le rane assaliranno te, il tuo popolo e tutti i tuoi servitori”. ");
INSERT INTO ita1927_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","E l’Eterno disse a Mosè: “Di’ ad Aaronne: Stendi la tua mano col tuo bastone sui fiumi, sui rivi e sugli stagni e fa salir le rane sul paese d’Egitto”. ");
INSERT INTO ita1927_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","E Aaronne stese la sua mano sulle acque d’Egitto, e le rane salirono e coprirono il paese d’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","E i magi fecero lo stesso con le loro arti occulte, e fecero salire le rane sul paese d’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Allora Faraone chiamò Mosè ed Aaronne e disse loro: “Pregate l’Eterno che allontani le rane da me e dal mio popolo, e io lascerò andare il popolo, perché offra sacrifizi all’Eterno”. ");
INSERT INTO ita1927_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","E Mosè disse a Faraone: “Fammi l’onore di dirmi per quando io devo chiedere, nelle mie supplicazioni per te, per i tuoi servitori e per il tuo popolo, che l’Eterno distrugga le rane intorno a te e nelle tue case, e non ne rimanga se non nel fiume”. ");
INSERT INTO ita1927_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Egli rispose: “Per domani”. E Mosè disse: “Sarà fatto come tu dici, affinché tu sappia che non v’è alcuno pari all’Eterno, ch’è il nostro Dio. ");
INSERT INTO ita1927_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","E le rane s’allontaneranno da te, dalle tue case, dai tuoi servitori e dal tuo popolo; non ne rimarrà che nel fiume”. ");
INSERT INTO ita1927_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Mosè ed Aaronne uscirono da Faraone; e Mosè implorò l’Eterno relativamente alle rane che aveva inflitte a Faraone. ");
INSERT INTO ita1927_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","E l’Eterno fece quello che Mosè avea domandato, e le rane morirono nelle case, nei cortili e nei campi. ");
INSERT INTO ita1927_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Le radunarono a mucchi e il paese ne fu ammorbato. ");
INSERT INTO ita1927_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Ma quando Faraone vide che v’era un po’ di respiro, si ostinò in cuor suo, e non diè ascolto a Mosè e ad Aaronne, come l’Eterno avea detto. ");
INSERT INTO ita1927_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","E l’Eterno disse a Mosè: “Di’ ad Aaronne: Stendi il tuo bastone e percuoti la polvere della terra, ed essa diventerà zanzare per tutto il paese di Egitto”. ");
INSERT INTO ita1927_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ed essi fecero così. Aaronne stese la sua mano col suo bastone, percosse la polvere della terra, e ne vennero delle zanzare sugli uomini e sugli animali; tutta la polvere della terra diventò zanzare per tutto il paese d’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","E i magi cercarono di far lo stesso coi loro incantesimi per produrre le zanzare, ma non poterono. Le zanzare furon dunque sugli uomini e sugli animali. ");
INSERT INTO ita1927_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Allora i magi dissero a Faraone: “Questo è il dito di Dio”. Ma il cuore di Faraone s’indurò ed egli non diè ascolto a Mosè e ad Aaronne, come l’Eterno avea detto. ");
INSERT INTO ita1927_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Poi l’Eterno disse a Mosè: “Alzati di buon mattino, e presentati a Faraone. Ecco, egli uscirà per andar verso l’acqua; e digli: Così dice l’Eterno: Lascia andare il mio popolo, perché mi serva. ");
INSERT INTO ita1927_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Se no, se non lasci andare il mio popolo, ecco io manderò su te, sui tuoi servitori, sul tuo popolo e nelle tue case, le mosche velenose; le case degli Egiziani saran piene di mosche velenose e il suolo su cui stanno ne sarà coperto. ");
INSERT INTO ita1927_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Ma in quel giorno io farò eccezione del paese di Goscen, dove abita il mio popolo; e quivi non ci saranno mosche, affinché tu sappia che io, l’Eterno, sono in mezzo al paese. ");
INSERT INTO ita1927_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","E io farò una distinzione fra il mio popolo e il tuo popolo. Domani avverrà questo miracolo”. ");
INSERT INTO ita1927_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","E l’Eterno fece così; e vennero grandi sciami di mosche velenose in casa di Faraone e nelle case dei suoi servitori; e in tutto il paese d’Egitto la terra fu guasta dalle mosche velenose. ");
INSERT INTO ita1927_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Faraone chiamò Mosè ed Aaronne e disse: “Andate, offrite sacrifizi al vostro Dio nel paese”. ");
INSERT INTO ita1927_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ma Mosè rispose: “Non si può far così; poiché offriremmo all’Eterno, ch’è l’Iddio nostro, dei sacrifizi che sono un abominio per gli Egiziani. Ecco, se offrissimo sotto i loro occhi dei sacrifizi che sono un abominio per gli Egiziani, non ci lapiderebbero essi? ");
INSERT INTO ita1927_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Andremo tre giornate di cammino nel deserto, e offriremo sacrifizi all’Eterno, ch’è il nostro Dio, com’egli ci ordinerà”. ");
INSERT INTO ita1927_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","E Faraone disse: “Io vi lascerò andare, perché offriate sacrifizi all’Eterno, ch’è il vostro Dio, nel deserto; soltanto, non andate troppo lontano; pregate per me”. ");
INSERT INTO ita1927_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","E Mosè disse: “Ecco, io esco da te e pregherò l’Eterno, e domani le mosche s’allontaneranno da Faraone, dai suoi servitori e dal suo popolo; soltanto, Faraone non si faccia più beffe, impedendo al popolo d’andare a offrir sacrifizi all’Eterno”. ");
INSERT INTO ita1927_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","E Mosè uscì dalla presenza di Faraone, e pregò l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","E l’Eterno fece quel che Mosè domandava, e allontanò le mosche velenose da Faraone, dai suoi servitori e dal suo popolo; non ne restò neppur una. ");
INSERT INTO ita1927_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ma anche questa volta Faraone si ostinò in cuor suo, e non lasciò andare il popolo. ");
INSERT INTO ita1927_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Allora l’Eterno disse a Mosè: “Va’ da Faraone, e digli: Così dice l’Eterno, l’Iddio degli Ebrei: Lascia andare il mio popolo, perché mi serva; ");
INSERT INTO ita1927_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","che se tu rifiuti di lasciarlo andare e lo rattieni ancora, ");
INSERT INTO ita1927_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ecco, la mano dell’Eterno sarà sul tuo bestiame ch’è nei campi, sui cavalli, sugli asini, sui cammelli, sui buoi e sulle pecore; ci sarà una tremenda mortalità. ");
INSERT INTO ita1927_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","E l’Eterno farà distinzione fra il bestiame d’Israele ed il bestiame d’Egitto; e nulla morrà di tutto quello che appartiene ai figliuoli d’Israele”. ");
INSERT INTO ita1927_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","E l’Eterno fissò un termine, dicendo: “Domani, l’Eterno farà questo nel paese”. ");
INSERT INTO ita1927_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","E l’indomani l’Eterno lo fece, e tutto il bestiame d’Egitto morì; ma del bestiame dei figliuoli d’Israele neppure un capo morì. ");
INSERT INTO ita1927_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Faraone mandò a vedere, ed ecco che neppure un capo del bestiame degl’Israeliti era morto. Ma il cuore di Faraone fu ostinato, ed ei non lasciò andare il popolo. ");
INSERT INTO ita1927_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","E l’Eterno disse a Mosè e ad Aaronne: “Prendete delle manate di cenere di fornace, e la sparga Mosè verso il cielo, sotto gli occhi di Faraone. ");
INSERT INTO ita1927_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Essa diventerà una polvere che coprirà tutto il paese d’Egitto, e produrrà delle ulceri germoglianti pustole sulle persone e sugli animali, per tutto il paese d’Egitto”. ");
INSERT INTO ita1927_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ed essi presero della cenere di fornace, e si presentarono a Faraone; Mosè la sparse verso il cielo, ed essa produsse delle ulceri germoglianti pustole sulle persone e sugli animali. ");
INSERT INTO ita1927_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","E i magi non poteron stare dinanzi a Mosè, a motivo delle ulceri, perché le ulceri erano addosso ai magi come addosso a tutti gli Egiziani. ");
INSERT INTO ita1927_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","E l’Eterno indurò il cuor di Faraone, ed egli non diè ascolto a Mosè e ad Aaronne come l’Eterno avea detto a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Poi l’Eterno disse a Mosè: “Lèvati di buon mattino, presentati a Faraone, e digli: Così dice l’Eterno, l’Iddio degli Ebrei: Lascia andare il mio popolo, perché mi serva; ");
INSERT INTO ita1927_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","poiché questa volta manderò tutte le mie piaghe sul tuo cuore, sui tuoi servitori e sul tuo popolo, affinché tu conosca che non c’è nessuno simile a me su tutta la terra. ");
INSERT INTO ita1927_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Che se ora io avessi steso la mia mano e avessi percosso di peste te e il tuo popolo, tu saresti stato sterminato di sulla terra. ");
INSERT INTO ita1927_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ma no; io t’ho lasciato sussistere per questo: per mostrarti la mia potenza, e perché il mio nome sia divulgato per tutta la terra. ");
INSERT INTO ita1927_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","E ti opponi ancora al mio popolo per non lasciarlo andare? ");
INSERT INTO ita1927_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ecco, domani, verso quest’ora, io farò cadere una grandine così forte, che non ce ne fu mai di simile in Egitto, da che fu fondato, fino al dì d’oggi. ");
INSERT INTO ita1927_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Or dunque manda a far mettere al sicuro il tuo bestiame e tutto quello che hai per i campi. La grandine cadrà su tutta la gente e su tutti gli animali che si troveranno per i campi e non saranno stati raccolti in casa, e morranno”. ");
INSERT INTO ita1927_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Fra i servitori di Faraone, quelli che temettero la parola dell’Eterno fecero rifugiare nelle case i loro servitori e il loro bestiame; ");
INSERT INTO ita1927_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","ma quelli che non fecero conto della parola dell’Eterno, lasciarono i loro servitori e il loro bestiame per i campi. ");
INSERT INTO ita1927_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","E l’Eterno disse a Mosè: “Stendi la tua mano verso il cielo, e cada grandine in tutto il paese d’Egitto, sulla gente, sugli animali e sopra ogni erba dei campi, nel paese d’Egitto”. ");
INSERT INTO ita1927_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","E Mosè stese il suo bastone verso il cielo; e l’Eterno mandò tuoni e grandine, e del fuoco s’avventò sulla terra; e l’Eterno fece piovere grandine sul paese d’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Così ci fu grandine e fuoco guizzante del continuo tra la grandine; e la grandine fu così forte, come non ce n’era stata di simile in tutto il paese d’Egitto, da che era diventato nazione. ");
INSERT INTO ita1927_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","E la grandine percosse, in tutto il paese d’Egitto, tutto quello ch’era per i campi: uomini e bestie; e la grandine percosse ogni erba de’ campi e fracassò ogni albero della campagna. ");
INSERT INTO ita1927_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Solamente nel paese di Goscen, dov’erano i figliuoli d’Israele, non cadde grandine. ");
INSERT INTO ita1927_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Allora Faraone mandò a chiamare Mosè ed Aaronne, e disse loro: “Questa volta io ho peccato; l’Eterno è giusto, mentre io e il mio popolo siamo colpevoli. ");
INSERT INTO ita1927_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Pregate l’Eterno perché cessino questi grandi tuoni e la grandine; e io vi lascerò andare, e non sarete più trattenuti”. ");
INSERT INTO ita1927_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","E Mosè gli disse: “Come sarò uscito dalla città, protenderò le mani all’Eterno; i tuoni cesseranno e non ci sarà più grandine, affinché tu sappia che la terra è dell’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ma quanto a te e ai tuoi servitori, io so che non avrete ancora timore dell’Eterno Iddio”. ");
INSERT INTO ita1927_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Ora il lino e l’orzo erano stati percossi, perché l’orzo era in spiga e il lino in fiore; ");
INSERT INTO ita1927_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","ma il grano e la spelda non furon percossi, perché sono serotini. ");
INSERT INTO ita1927_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Mosè dunque, lasciato Faraone, uscì di città, protese le mani all’Eterno, e i tuoni e la grandine cessarono, e non cadde più pioggia sulla terra. ");
INSERT INTO ita1927_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","E quando Faraone vide che la pioggia, la grandine e i tuoni eran cessati, continuò a peccare, e si ostinò in cuor suo: lui e i suoi servitori. ");
INSERT INTO ita1927_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","E il cuor di Faraone s’indurò, ed egli non lasciò andare i figliuoli d’Israele, come l’Eterno avea detto per bocca di Mosè. ");
INSERT INTO ita1927_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","E l’Eterno disse a Mosè: “Va’ da Faraone; poiché io ho reso ostinato il suo cuore e il cuore dei suoi servitori, per fare in mezzo a loro i segni che vedrai, ");
INSERT INTO ita1927_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","e perché tu narri ai tuoi figliuoli e ai figliuoli dei tuoi figliuoli quello che ho operato in Egitto e i segni che ho fatto in mezzo a loro, onde sappiate che io sono l’Eterno”. ");
INSERT INTO ita1927_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Mosè ed Aaronne andaron dunque da Faraone, e gli dissero: “Così dice l’Eterno, l’Iddio degli Ebrei: Fino a quando rifiuterai d’umiliarti dinanzi a me? Lascia andare il mio popolo, perché mi serva. ");
INSERT INTO ita1927_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Se tu rifiuti di lasciar andare il mio popolo, ecco, domani farò venire delle locuste in tutta l’estensione del tuo paese. ");
INSERT INTO ita1927_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Esse copriranno la faccia della terra, sì che non si potrà vedere il suolo; ed esse divoreranno il resto ch’è scampato, ciò che v’è rimasto dalla grandine, e divoreranno ogni albero che vi cresce ne’ campi. ");
INSERT INTO ita1927_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ed empiranno le tue case, le case di tutti i tuoi servitori e le case di tutti gli Egiziani, come né i tuoi padri né i padri de’ tuoi padri videro mai, dal giorno che furono sulla terra, al dì d’oggi”. Detto questo, voltò le spalle, e uscì dalla presenza di Faraone. ");
INSERT INTO ita1927_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","E i servitori di Faraone gli dissero: “Fino a quando quest’uomo ci sarà come un laccio? Lascia andare questa gente, e che serva l’Eterno, l’Iddio suo! Non sai tu che l’Egitto e rovinato?” ");
INSERT INTO ita1927_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Allora Mosè ed Aaronne furon fatti tornare da Faraone; ed egli disse loro: “Andate, servite l’Eterno, l’Iddio vostro; ma chi son quelli che andranno?” E Mosè disse: ");
INSERT INTO ita1927_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","“Noi andremo col nostri fanciulli e coi nostri vecchi, coi nostri figliuoli e con le nostre figliuole; andremo coi nostri greggi e coi nostri armenti, perché dobbiam celebrare una festa all’Eterno”. ");
INSERT INTO ita1927_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","E Faraone disse loro: “Così sia l’Eterno con voi, com’io lascerò andare voi e i vostri bambini! Badate bene, perché avete delle cattive intenzioni! ");
INSERT INTO ita1927_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","No, no; andate voi uomini, e servite l’Eterno; poiché questo è quel che cercate”. E Faraone li cacciò dalla sua presenza. ");
INSERT INTO ita1927_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Allora l’Eterno disse a Mosè: “Stendi la tua mano sul paese d’Egitto per farvi venire le locuste; e salgano esse sul paese d’Egitto e divorino tutta l’erba del paese, tutto quello che la grandine ha lasciato”. ");
INSERT INTO ita1927_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","E Mosè stese il suo bastone sul paese d’Egitto; e l’Eterno fece levare un vento orientale sul paese, tutto quel giorno e tutta la notte; e, come venne la mattina, il vento orientale avea portato le locuste. ");
INSERT INTO ita1927_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","E le locuste salirono su tutto il paese d’Egitto, e si posarono su tutta l’estensione dell’Egitto; erano in sì grande quantità, che prima non ce n’eran mai state tante, né mai più tante ce ne saranno. ");
INSERT INTO ita1927_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Esse coprirono la faccia di tutto il paese, in guisa che il paese ne rimase oscurato; e divorarono tutta l’erba del paese e tutti i frutti degli alberi, che la grandine avea lasciato; e nulla restò di verde negli alberi, e nell’erba della campagna, per tutto il paese d’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Allora Faraone chiamò in fretta Mosè ed Aaronne, e disse: “Io ho peccato contro l’Eterno, l’Iddio vostro, e contro voi. ");
INSERT INTO ita1927_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ma ora perdona, ti prego, il mio peccato, questa volta soltanto; e supplicate l’Eterno, l’Iddio vostro, perché almeno allontani da me questo flagello mortale”. ");
INSERT INTO ita1927_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","E Mosè uscì da Faraone, e pregò l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","E l’Eterno fe’ levare un vento contrario, un gagliardissimo vento di ponente, che portò via le locuste e le precipitò nel mar Rosso. Non ci rimase neppure una locusta in tutta l’estensione dell’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ma l’Eterno indurò il cuor di Faraone, ed egli non lasciò andare figliuoli d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","E l’Eterno disse a Mosè: “Stendi la tua mano verso il cielo, e sianvi tenebre nel paese d’Egitto: tali, che si possan palpare”. ");
INSERT INTO ita1927_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","E Mosè stese la sua mano verso il cielo, e ci fu una fitta tenebrìa in tutto il paese d’Egitto per tre giorni. ");
INSERT INTO ita1927_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Uno non vedeva l’altro, e nessuno si mosse di dove stava, per tre giorni; ma tutti i figliuoli d’Israele aveano della luce nelle loro dimore. ");
INSERT INTO ita1927_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Allora Faraone chiamò Mosè e disse: “Andate, servite l’Eterno; rimangano soltanto i vostri greggi e i vostri armenti; anche i vostri bambini potranno andare con voi”. ");
INSERT INTO ita1927_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","E Mosè disse: “Tu ci devi anche concedere di prendere di che fare de’ sacrifizi e degli olocausti, perché possiamo offrire sacrifizi all’Eterno, ch’è l’Iddio nostro. ");
INSERT INTO ita1927_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Anche il nostro bestiame verrà con noi, senza che ne rimanga addietro neppure un’unghia; poiché di esso dobbiam prendere per servire l’Eterno Iddio nostro; e noi non sapremo con che dovremo servire l’Eterno, finché sarem giunti colà”. ");
INSERT INTO ita1927_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ma l’Eterno indurò il cuore di Faraone, ed egli non volle lasciarli andare. ");
INSERT INTO ita1927_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","E Faraone disse a Mosè: “Vattene via da me! Guardati bene dal comparire più alla mia presenza! poiché il giorno che comparirai alla mia presenza, tu morrai!” ");
INSERT INTO ita1927_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","E Mosè rispose: “Hai detto bene; io non comparirò più alla tua presenza”. ");
INSERT INTO ita1927_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","E l’Eterno disse a Mosè: “Io farò venire ancora una piaga su Faraone e sull’Egitto; poi egli vi lascerà partire di qui. Quando vi lascerà partire, egli addirittura vi caccerà di qui. ");
INSERT INTO ita1927_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Or parla al popolo e digli che ciascuno domandi al suo vicino e ogni donna alla sua vicina degli oggetti d’argento e degli oggetti d’oro”. ");
INSERT INTO ita1927_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","E l’Eterno fece entrare il popolo nelle buone grazie degli Egiziani; anche Mosè era personalmente in gran considerazione nel paese d’Egitto, agli occhi dei servitori di Faraone e agli occhi del popolo. ");
INSERT INTO ita1927_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","E Mosè disse: “Così dice l’Eterno: Verso mezzanotte, io passerò in mezzo all’Egitto; ");
INSERT INTO ita1927_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","e ogni primogenito nel paese d’Egitto morrà: dal primogenito di Faraone che siede sul suo trono, al primogenito della serva che sta dietro la macina, e ad ogni primogenito del bestiame. ");
INSERT INTO ita1927_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","E vi sarà per tutto il paese d’Egitto un gran grido, quale non ci fu mai prima, né ci sarà di poi. ");
INSERT INTO ita1927_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Ma fra tutti i figliuoli d’Israele, tanto fra gli uomini quanto fra gli animali, neppure un cane moverà la lingua, affinché conosciate la distinzione che l’Eterno fa tra gli Egiziani e Israele. ");
INSERT INTO ita1927_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","E tutti questi tuoi servitori scenderanno da me, e s’inchineranno davanti a me, dicendo: Parti, tu e tutto il popolo ch’è al tuo séguito! E, dopo questo, io partirò”. E Mosè uscì dalla presenza di Faraone, acceso d’ira. ");
INSERT INTO ita1927_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","E l’Eterno disse a Mosè: “Faraone non vi darà ascolto, affinché i miei prodigi si moltiplichino nel paese d’Egitto”. ");
INSERT INTO ita1927_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","E Mosè ed Aaronne fecero tutti questi prodigi dinanzi a Faraone; ma l’Eterno indurò il cuore di Faraone, ed egli non lasciò uscire i figliuoli d’Israele dal suo paese. ");
INSERT INTO ita1927_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","L’Eterno parlò a Mosè e ad Aaronne nel paese d’Egitto, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Questo mese sarà per voi il primo dei mesi: sarà per voi il primo dei mesi dell’anno. ");
INSERT INTO ita1927_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Parlate a tutta la raunanza d’Israele, e dite: Il decimo giorno di questo mese, prenda ognuno un agnello per famiglia, un agnello per casa; ");
INSERT INTO ita1927_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","e se la casa è troppo poco numerosa per un agnello, se ne prenda uno in comune col vicino di casa più prossimo, tenendo conto del numero delle persone; voi conterete ogni persona secondo quel che può mangiare dell’agnello. ");
INSERT INTO ita1927_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Il vostro agnello sia senza difetto, maschio, dell’anno; potrete prendere un agnello o un capretto. ");
INSERT INTO ita1927_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Lo serberete fino al quattordicesimo giorno di questo mese, e tutta la raunanza d’Israele, congregata, lo immolerà sull’imbrunire. ");
INSERT INTO ita1927_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","E si prenda del sangue d’esso, e si metta sui due stipiti e sull’architrave della porta delle case dove lo si mangerà. ");
INSERT INTO ita1927_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","E se ne mangi la carne in quella notte; si mangi arrostita al fuoco, con pane senza lievito e con dell’erbe amare. ");
INSERT INTO ita1927_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Non ne mangiate niente di poco cotto o di lessato nell’acqua, ma sia arrostito al fuoco, con la testa, le gambe e le interiora. ");
INSERT INTO ita1927_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","E non ne lasciate nulla di resto fino alla mattina; e quel che ne sarà rimasto fino alla mattina, bruciatelo col fuoco. ");
INSERT INTO ita1927_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","E mangiatelo in questa maniera: coi vostri fianchi cinti, coi vostri calzari ai piedi e col vostro bastone in mano; e mangiatelo in fretta: è la Pasqua dell’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Quella notte io passerò per il paese d’Egitto, e percoterò ogni primogenito nel paese d’Egitto, tanto degli uomini quanto degli animali, e farò giustizia di tutti gli dèi d’Egitto. Io sono l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","E quel sangue vi servirà di segno sulle case dove sarete; e quand’io vedrò il sangue passerò oltre, e non vi sarà piaga su voi per distruggervi, quando percoterò il paese d’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Quel giorno sarà per voi un giorno di ricordanza, e lo celebrerete come una festa in onore dell’Eterno; lo celebrerete d’età in età come una festa d’istituzione perpetua. ");
INSERT INTO ita1927_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Per sette giorni mangerete pani azzimi. Fin dal primo giorno toglierete ogni lievito dalle vostre case; poiché, chiunque mangerà pane lievitato, dal primo giorno fino al settimo, sarà reciso da Israele. ");
INSERT INTO ita1927_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","E il primo giorno avrete una santa convocazione, e una santa convocazione il settimo giorno. Non si faccia alcun lavoro in que’ giorni; si prepari soltanto quel ch’è necessario a ciascuno per mangiare, e non altro. ");
INSERT INTO ita1927_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Osservate dunque la festa degli azzimi; poiché in quel medesimo giorno io avrò tratto le vostre schiere dal paese d’Egitto; osservate dunque quel giorno d’età in età, come una istituzione perpetua. ");
INSERT INTO ita1927_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Mangiate pani azzimi dalla sera del quattordicesimo giorno del mese, fino alla sera del ventunesimo giorno. ");
INSERT INTO ita1927_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Per sette giorni non si trovi lievito nelle vostre case; perché chiunque mangerà qualcosa di lievitato, quel tale sarà reciso dalla raunanza d’Israele: sia egli forestiero o nativo del paese. ");
INSERT INTO ita1927_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Non mangiate nulla di lievitato; in tutte le vostre dimore mangiate pani azzimi”. ");
INSERT INTO ita1927_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Mosè dunque chiamò tutti gli anziani d’Israele, e disse loro: “Sceglietevi e prendetevi degli agnelli per le vostre famiglie, e immolate la Pasqua. ");
INSERT INTO ita1927_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","E prendete un mazzetto d’issopo, intingetelo nel sangue che sarà nel bacino, e spruzzate di quel sangue che sarà nel bacino, l’architrave e i due stipiti delle porte; e nessuno di voi varchi la porta di casa sua, fino al mattino. ");
INSERT INTO ita1927_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Poiché l’Eterno passerà per colpire gli Egiziani; e quando vedrà il sangue sull’architrave e sugli stipiti, l’Eterno passera oltre la porta, e non permetterà al distruttore d’entrare nelle vostre case per colpirvi. ");
INSERT INTO ita1927_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Osservate dunque questo come una istituzione perpetua per voi e per i vostri figliuoli. ");
INSERT INTO ita1927_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","E quando sarete entrati nel paese che l’Eterno vi darà, conforme ha promesso, osservate questo rito; ");
INSERT INTO ita1927_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","e quando i vostri figliuoli vi diranno: Che significa per voi questo rito? ");
INSERT INTO ita1927_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","risponderete: Questo è il sacrifizio della Pasqua in onore dell’Eterno il quale passò oltre le case dei figliuoli d’Israele in Egitto, quando colpì gli Egiziani e salvò le nostre case”. ");
INSERT INTO ita1927_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","E il popolo s’inchinò e adorò. E i figliuoli d’Israele andarono, e fecero così; fecero come l’Eterno aveva ordinato a Mosè e ad Aaronne. ");
INSERT INTO ita1927_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","E avvenne che, alla mezzanotte, l’Eterno colpì tutti i primogeniti nel paese di Egitto, dal primogenito di Faraone che sedeva sul suo trono al primogenito del carcerato ch’era in prigione, e tutti i primogeniti del bestiame. ");
INSERT INTO ita1927_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","E Faraone si alzò di notte: egli e tutti i suoi servitori e tutti gli Egiziani; e vi fu un gran grido in Egitto, perché non c’era casa dove non fosse un morto. ");
INSERT INTO ita1927_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ed egli chiamò Mosè ed Aaronne, di notte, e disse: “Levatevi, partite di mezzo al mio popolo, voi e i figliuoli d’Israele; e andate, servite l’Eterno, come avete detto. ");
INSERT INTO ita1927_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Prendete i vostri greggi e i vostri armenti, come avete detto; andatevene, e benedite anche me!” ");
INSERT INTO ita1927_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","E gli Egiziani facevano forza al popolo per affrettarne la partenza dal paese, perché dicevano: “Noi siamo tutti morti”. ");
INSERT INTO ita1927_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Il popolo portò via la sua pasta prima che fosse lievitata; avvolse le sue madie ne’ suoi vestiti e se le mise sulle spalle. ");
INSERT INTO ita1927_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Or i figliuoli d’Israele fecero come Mosè avea detto: domandarono agli Egiziani degli oggetti d’argento, degli oggetti d’oro e de’ vestiti; ");
INSERT INTO ita1927_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","e l’Eterno fece entrare il popolo nelle buone grazie degli Egiziani, che gli dettero quel che domandava. Così spogliarono gli Egiziani. ");
INSERT INTO ita1927_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","I figliuoli d’Israele partirono da Ramses per Succoth, in numero di circa seicentomila uomini a piedi, senza contare i fanciulli. ");
INSERT INTO ita1927_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","E una folla di gente d’ogni specie salì anch’essa con loro; e avevano pure greggi, armenti, bestiame in grandissima quantità. ");
INSERT INTO ita1927_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","E cossero la pasta che avean portata dall’Egitto, e ne fecero delle focacce azzime; poiché la pasta non era lievitata, essendo essi stati cacciati dall’Egitto senza poter indugiare e senza potersi prendere provvisioni di sorta. ");
INSERT INTO ita1927_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Or la dimora che i figliuoli d’Israele fecero in Egitto fu di quattrocento trenta anni. ");
INSERT INTO ita1927_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","E al termine di quattrocento trenta anni, proprio il giorno che finivano, avvenne che tutte le schiere dell’Eterno uscirono dal paese d’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Questa è una notte da celebrarsi in onore dell’Eterno, perché ei li trasse dal paese d’Egitto; questa è una notte consacrata all’Eterno, per essere osservata da tutti i figliuoli d’Israele, d’età in età. ");
INSERT INTO ita1927_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","E l’Eterno disse a Mosè e ad Aaronne: “Questa è la norma della Pasqua: Nessuno straniero ne mangi; ");
INSERT INTO ita1927_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","ma qualunque servo, comprato a prezzo di danaro, dopo che l’avrai circonciso, potrà mangiarne. ");
INSERT INTO ita1927_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","L’avventizio e il mercenario non ne mangino. ");
INSERT INTO ita1927_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Si mangi ogni agnello in una medesima casa; non portate fuori nulla della carne d’esso, e non ne spezzate alcun osso. ");
INSERT INTO ita1927_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Tutta la raunanza d’Israele celebri la Pasqua. ");
INSERT INTO ita1927_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","E quando uno straniero soggiornerà teco e vorrà far la Pasqua in onore dell’Eterno, siano circoncisi prima tutti i maschi della sua famiglia; e poi s’accosti pure per farla, e sia come un nativo del paese; ma nessuno incirconciso ne mangi. ");
INSERT INTO ita1927_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Siavi un’unica legge per il nativo del paese e per lo straniero che soggiorna tra voi”. ");
INSERT INTO ita1927_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Tutti i figliuoli d’Israele fecero così; fecero come l’Eterno aveva ordinato a Mosè e ad Aaronne. ");
INSERT INTO ita1927_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","E avvenne che in quel medesimo giorno l’Eterno trasse i figliuoli d’Israele dal paese d’Egitto, secondo le loro schiere. ");
INSERT INTO ita1927_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","L’Eterno parlò a Mosè, dicendo: “Consacrami ogni primogenito, ");
INSERT INTO ita1927_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","tutto ciò che nasce primo tra i figliuoli d’Israele, tanto degli uomini quanto degli animali: esso mi appartiene”. ");
INSERT INTO ita1927_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","E Mosè disse al popolo: “Ricordatevi di questo giorno, nel quale siete usciti dall’Egitto, dalla casa di servitù; poiché l’Eterno vi ha tratti fuori di questo luogo, con mano potente; non si mangi pane lievitato. ");
INSERT INTO ita1927_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Voi uscite oggi, nel mese di Abib. ");
INSERT INTO ita1927_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Quando dunque l’Eterno ti avrà introdotto nel paese dei Cananei, degli Hittei, degli Amorei, degli Hivvei e dei Gebusei che giurò ai tuoi padri di darti, paese ove scorre il latte e il miele, osserva questo rito, in questo mese. ");
INSERT INTO ita1927_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Per sette giorni mangia pane senza lievito; e il settimo giorno si faccia una festa all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Si mangi pane senza lievito per sette giorni; e non si vegga pan lievitato presso di te, né si vegga lievito presso di te, entro tutti i tuoi confini. ");
INSERT INTO ita1927_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","E in quel giorno tu spiegherai la cosa al tuo figliuolo, dicendo: Si fa così, a motivo di quello che l’Eterno fece per me quand’uscii dall’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","E ciò ti sarà come un segno sulla tua mano, come un ricordo fra i tuoi occhi, affinché la legge dell’Eterno sia nella tua bocca; poiché l’Eterno ti ha tratto fuori dall’Egitto con mano potente. ");
INSERT INTO ita1927_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Osserva dunque questa istituzione, al tempo fissato, d’anno in anno”. ");
INSERT INTO ita1927_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Quando l’Eterno t’avrà introdotto nel paese dei Cananei, come giurò a te e ai tuoi padri, e te lo avrà dato, ");
INSERT INTO ita1927_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","consacra all’Eterno ogni fanciullo primogenito e ogni primo parto del bestiame che t’appartiene: i maschi saranno dell’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Ma riscatta ogni primo parto dell’asino con un agnello; e se non lo vuoi riscattare, fiaccagli il collo; riscatta anche ogni primogenito dell’uomo fra i tuoi figliuoli. ");
INSERT INTO ita1927_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","E quando, in avvenire, il tuo figliuolo t’interrogherà, dicendo: Che significa questo? gli risponderai: L’Eterno ci trasse fuori dall’Egitto, dalla casa di servitù, con mano potente; ");
INSERT INTO ita1927_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","e avvenne che, quando Faraone s’ostinò a non lasciarci andare, l’Eterno uccise tutti i primogeniti nel paese d’Egitto, tanto i primogeniti degli uomini quanto i primogeniti degli animali; perciò io sacrifico all’Eterno tutti i primi parti maschi, ma riscatto ogni primogenito dei miei figliuoli. ");
INSERT INTO ita1927_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ciò sarà come un segno sulla tua mano e come un frontale fra i tuoi occhi, poiché l’Eterno ci ha tratti dall’Egitto con mano potente”. ");
INSERT INTO ita1927_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Or quando Faraone ebbe lasciato andare il popolo, Iddio non lo condusse per la via del paese de’ Filistei, perché troppo vicina; poiché Iddio disse: “Bisogna evitare che il popolo, di fronte a una guerra, si penta e torni in Egitto”; ");
INSERT INTO ita1927_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","ma Iddio fece fare al popolo un giro per la via del deserto, verso il mar Rosso. E i figliuoli d’Israele salirono armati dal paese d’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","E Mosè prese seco le ossa di Giuseppe; perché questi aveva espressamente fatto giurare i figliuoli d’Israele, dicendo: “Iddio, certo, vi visiterà; allora, trasportate di qui le mie ossa con voi”. ");
INSERT INTO ita1927_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","E gl’Israeliti, partiti da Succoth, si accamparono a Etham, all’estremità del deserto. ");
INSERT INTO ita1927_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","E l’Eterno andava davanti a loro: di giorno, in una colonna di nuvola per guidarli per il loro cammino; e di notte, in una colonna di fuoco per illuminarli, onde potessero camminare giorno e notte. ");
INSERT INTO ita1927_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","La colonna di nuvola non si ritirava mai di davanti al popolo di giorno, né la colonna di fuoco di notte. ");
INSERT INTO ita1927_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","E l’Eterno parlò a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Di’ ai figliuoli d’Israele che tornino indietro e s’accampino di rimpetto a Pi-Hahiroth, fra Migdol e il mare, di fronte a Baal-Tsefon; accampatevi di faccia a quel luogo presso il mare. ");
INSERT INTO ita1927_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","E Faraone dirà de’ figliuoli d’Israele: Si sono smarriti nel paese; il deserto li tiene rinchiusi. ");
INSERT INTO ita1927_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","E io indurerò il cuor di Faraone, ed egli li inseguirà; ma io trarrò gloria da Faraone e da tutto il suo esercito, e gli Egiziani sapranno che io sono l’Eterno”. Ed essi fecero così. ");
INSERT INTO ita1927_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Or fu riferito al re d’Egitto che il popolo era fuggito; e il cuore di Faraone e de’ suoi servitori mutò sentimento verso il popolo, e quelli dissero: “Che abbiam fatto a lasciar andare Israele, sì che non ci serviranno più?” ");
INSERT INTO ita1927_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","E Faraone fece attaccare il suo carro, e prese il suo popolo seco. ");
INSERT INTO ita1927_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Prese seicento carri scelti e tutti i carri d’Egitto; e su tutti c’eran de’ guerrieri. ");
INSERT INTO ita1927_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","E l’Eterno indurò il cuor di Faraone, re d’Egitto, ed egli inseguì i figliuoli d’Israele, che uscivano pieni di baldanza. ");
INSERT INTO ita1927_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Gli Egiziani dunque li inseguirono; e tutti i cavalli, i carri di Faraone, i suoi cavalieri e il suo esercito li raggiunsero mentr’essi erano accampati presso il mare, vicino a Pi-Hahiroth, di fronte a Baal-Tsefon. ");
INSERT INTO ita1927_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","E quando Faraone si fu avvicinato, i figliuoli d’Israele alzarono gli occhi: ed ecco, gli Egiziani marciavano alle loro spalle; ond’ebbero una gran paura, e gridarono all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","E dissero a Mosè: “Mancavan forse sepolture in Egitto, che ci hai menati a morire nel deserto? Perché ci hai fatto quest’azione, di farci uscire dall’Egitto? ");
INSERT INTO ita1927_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Non è egli questo che ti dicevamo in Egitto: Lasciaci stare, che serviamo gli Egiziani? Poiché meglio era per noi servire gli Egiziani che morire nel deserto”. ");
INSERT INTO ita1927_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","E Mosè disse al popolo: “Non temete, state fermi, e mirate la liberazione che l’Eterno compirà oggi per voi; poiché gli Egiziani che avete veduti quest’oggi, non li vedrete mai più in perpetuo. ");
INSERT INTO ita1927_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","L’Eterno combatterà per voi, e voi ve ne starete queti”. ");
INSERT INTO ita1927_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","E l’Eterno disse a Mosè: “Perché gridi a me? Di’ ai figliuoli d’Israele che si mettano in marcia. ");
INSERT INTO ita1927_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","E tu alza il tuo bastone, stendi la tua mano sul mare, e dividilo; e i figliuoli d’Israele entreranno in mezzo al mare a piedi asciutti. ");
INSERT INTO ita1927_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","E quanto a me, ecco, io indurerò il cuore degli Egiziani, ed essi v’entreranno, dietro a loro; ed io trarrò gloria da Faraone, da tutto il suo esercito, dai suoi carri e dai suoi cavalieri. ");
INSERT INTO ita1927_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","E gli Egiziani sapranno che io sono l’Eterno, quando avrò tratto gloria da Faraone, dai suoi carri e dai suoi cavalieri”. ");
INSERT INTO ita1927_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Allora l’angelo di Dio, che precedeva il campo d’Israele, si mosse e andò a porsi alle loro spalle; parimente la colonna di nuvola si mosse dal loro fronte e si fermò alle loro spalle; ");
INSERT INTO ita1927_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","e venne a mettersi fra il campo dell’Egitto e il campo d’Israele; e la nube era tenebrosa per gli uni, mentre rischiarava gli altri nella notte. E l’un campo non si accostò all’altro per tutta la notte. ");
INSERT INTO ita1927_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Or Mosè stese la sua mano sul mare; e l’Eterno fece ritirare il mare mediante un gagliardo vento orientale durato tutta la notte, e ridusse il mare in terra asciutta; e le acque si divisero. ");
INSERT INTO ita1927_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","E i figliuoli d’Israele entrarono in mezzo al mare sull’asciutto; e le acque formavano come un muro alla loro destra e alla loro sinistra. ");
INSERT INTO ita1927_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","E gli Egiziani li inseguirono; e tutti i cavalli di Faraone, i suoi carri e i suoi cavalieri entrarono dietro a loro in mezzo al mare. ");
INSERT INTO ita1927_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","E avvenne verso la vigilia del mattino, che l’Eterno, dalla colonna di fuoco e dalla nuvola, guardò verso il campo degli Egiziani, e lo mise in rotta. ");
INSERT INTO ita1927_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","E tolse le ruote dei loro carri, e ne rese l’avanzata pesante; in guisa che gli Egiziani dissero: “Fuggiamo d’innanzi ad Israele, perché l’Eterno combatte per loro contro gli Egiziani”. ");
INSERT INTO ita1927_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","E l’Eterno disse a Mosè: “Stendi la tua mano sul mare, e le acque ritorneranno sugli Egiziani, sui loro carri e sui loro cavalieri”. ");
INSERT INTO ita1927_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","E Mosè stese la sua mano sul mare; e, sul far della mattina, il mare riprese la sua forza; e gli Egiziani, fuggendo, gli andavano incontro; e l’Eterno precipitò gli Egiziani in mezzo al mare. ");
INSERT INTO ita1927_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Le acque tornarono e coprirono i carri, i cavalieri, tutto l’esercito di Faraone ch’erano entrati nel mare dietro agl’Israeliti; e non ne scampò neppur uno. ");
INSERT INTO ita1927_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Ma i figliuoli d’Israele camminarono sull’asciutto in mezzo al mare, e le acque formavano come un muro alla loro destra e alla loro sinistra. ");
INSERT INTO ita1927_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Così, in quel giorno l’Eterno salvò Israele dalle mani degli Egiziani, e Israele vide sul lido del mare gli Egiziani morti. ");
INSERT INTO ita1927_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","E Israele vide la gran potenza che l’Eterno avea spiegata contro gli Egiziani; onde il popolo temé l’Eterno, e credette nell’Eterno e in Mosè suo servo. ");
INSERT INTO ita1927_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Allora Mosè e i figliuoli d’Israele cantarono questo cantico all’Eterno, e dissero così: “Io cantero all’Eterno perché si è sommamente esaltato; ha precipitato in mare cavallo e cavaliere. ");
INSERT INTO ita1927_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","L’Eterno è la mia forza e l’oggetto del mio cantico; egli è stato la mia salvezza. Questo è il mio Dio, io lo glorificherò; è l’Iddio di mio padre, io lo esalterò. ");
INSERT INTO ita1927_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","L’Eterno è un guerriero, il suo nome è l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Egli ha gettato in mare i carri di Faraone e il suo esercito, e i migliori suoi condottieri sono stati sommersi nel mar Rosso. ");
INSERT INTO ita1927_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Gli abissi li coprono; sono andati a fondo come una pietra. ");
INSERT INTO ita1927_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","La tua destra, o Eterno, è mirabile per la sua forza, la tua destra, o Eterno, schiaccia i nemici. ");
INSERT INTO ita1927_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Con la grandezza della tua maestà, tu rovesci i tuoi avversari; tu scateni la tua ira, essa li consuma come stoppia. ");
INSERT INTO ita1927_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Al soffio delle tue nari le acque si sono ammontate, le onde si son drizzate come un muro, i flutti si sono assodati nel cuore del mare. ");
INSERT INTO ita1927_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Il nemico diceva: “Inseguirò, raggiungerò, dividerò le spoglie, la mia brama si sazierà su loro; sguainerò la mia spada, la mia mano li sterminerà”; ");
INSERT INTO ita1927_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","ma tu hai mandato fuori il tuo soffio e il mare li ha ricoperti; sono affondati come piombo nelle acque potenti. ");
INSERT INTO ita1927_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Chi è pari a te fra gli dèi, o Eterno? Chi è pari a te, mirabile nella tua santità, tremendo anche a chi ti loda, operator di prodigi? ");
INSERT INTO ita1927_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Tu hai steso la destra, la terra li ha ingoiati. ");
INSERT INTO ita1927_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Tu hai condotto con la tua benignità il popolo che hai riscattato; l’hai guidato con la tua forza verso la tua santa dimora. ");
INSERT INTO ita1927_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","I popoli l’hanno udito, e tremano. L’angoscia ha còlto gli abitanti della Filistia. ");
INSERT INTO ita1927_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Già sono smarriti i capi di Edom, il tremito prende i potenti di Moab, tutti gli abitanti di Canaan vengono meno. ");
INSERT INTO ita1927_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Spavento e terrore piomberà su loro. Per la forza del tuo braccio diventeran muti come una pietra, finché il tuo popolo, o Eterno, sia passato, finché sia passato il popolo che ti sei acquistato. ");
INSERT INTO ita1927_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Tu li introdurrai e li pianterai sul monte del tuo retaggio, nel luogo che hai preparato, o Eterno, per tua dimora, nel santuario che le tue mani, o Signore, hanno stabilito. ");
INSERT INTO ita1927_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","L’Eterno regnerà per sempre, in perpetuo”. ");
INSERT INTO ita1927_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Questo cantarono gl’Israeliti perché i cavalli di Faraone coi suoi carri e i suoi cavalieri erano entrati nel mare, e l’Eterno avea fatto ritornar su loro le acque del mare, ma i figliuoli d’Israele aveano camminato in mezzo al mare, sull’asciutto. ");
INSERT INTO ita1927_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","E Maria, la profetessa, sorella d’Aaronne, prese in mano il timpano, e tutte le donne usciron dietro a lei con de’ timpani, e danzando. ");
INSERT INTO ita1927_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","E Maria rispondeva ai figliuoli d’Israele: “Cantate all’Eterno, perché si è sommamente esaltato; ha precipitato in mare cavallo e cavaliere”. ");
INSERT INTO ita1927_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Poi Mosè fece partire gl’Israeliti dal Mar Rosso, ed essi si diressero verso il deserto di Shur; camminarono tre giorni nel deserto, e non trovarono acqua. ");
INSERT INTO ita1927_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","E quando giunsero a Mara, non poteron bevere le acque di Mara, perché erano amare; perciò quel luogo fu chiamato Mara. ");
INSERT INTO ita1927_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","E il popolo mormorò contro Mosè, dicendo: “Che berremo?” ");
INSERT INTO ita1927_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Ed egli gridò all’Eterno; e l’Eterno gli mostrò un legno ch’egli gettò nelle acque, e le acque divennero dolci. Quivi l’Eterno dette al popolo una legge e una prescrizione, e lo mise alla prova, e disse: ");
INSERT INTO ita1927_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","“Se ascolti attentamente la voce dell’Eterno, ch’è il tuo Dio, e fai ciò ch’è giusto agli occhi suoi e porgi orecchio ai suoi comandamenti e osservi tutte le sue leggi, io non ti manderò addosso alcuna delle malattie che ho mandate addosso agli Egiziani, perché io sono l’Eterno che ti guarisco”. ");
INSERT INTO ita1927_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Poi giunsero ad Elim, dov’erano dodici sorgenti d’acqua e settanta palme; e si accamparono quivi presso le acque. ");
INSERT INTO ita1927_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","E tutta la raunanza de’ figliuoli d’Israele partì da Elim e giunse al deserto di Sin, ch’è fra Elim e Sinai, il quindicesimo giorno del secondo mese dopo la loro partenza dal paese d’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","E tutta la raunanza de’ figliuoli d’Israele mormorò contro Mosè e contro Aaronne nel deserto. ");
INSERT INTO ita1927_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","I figliuoli d’Israele dissero loro: “Oh, fossimo pur morti per mano dell’Eterno nel paese d’Egitto, quando sedevamo presso le pignatte della carne e mangiavamo del pane a sazietà! Poiché voi ci avete menati in questo deserto per far morir di fame tutta questa raunanza”. ");
INSERT INTO ita1927_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","E l’Eterno disse a Mosè: “Ecco, io vi farò piovere del pane dal cielo; e il popolo uscirà e ne raccoglierà giorno per giorno quanto gliene abbisognerà per la giornata, ond’io lo metta alla prova per vedere se camminerà o no secondo la mia legge. ");
INSERT INTO ita1927_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ma il sesto giorno, quando prepareranno quello che avran portato a casa, essa sarà il doppio di quello che avranno raccolto ogni altro giorno”. ");
INSERT INTO ita1927_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","E Mosè ed Aaronne dissero a tutti i figliuoli d’Israele: “Questa sera voi conoscerete che l’Eterno è quegli che vi ha tratto fuori dal paese d’Egitto; ");
INSERT INTO ita1927_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","e domattina vedrete la gloria dell’Eterno; poich’egli ha udito le vostre mormorazioni contro l’Eterno; quanto a noi, che cosa siamo perché mormoriate contro di noi?” ");
INSERT INTO ita1927_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","E Mosè disse: “Vedrete la gloria dell’Eterno quando stasera egli vi darà della carne da mangiare e domattina del pane a sazietà; giacché l’Eterno ha udito le vostre mormorazioni che proferite contro di lui; quanto a noi, che cosa siamo? le vostre mormorazioni non sono contro di noi ma contro l’Eterno”. ");
INSERT INTO ita1927_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Poi Mosè disse ad Aaronne: “Di’ a tutta la raunanza de’ figliuoli d’Israele: Avvicinatevi alla presenza dell’Eterno, perch’egli ha udito le vostre mormorazioni”. ");
INSERT INTO ita1927_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","E come Aaronne parlava a tutta la raunanza de’ figliuoli d’Israele, questi volsero gli occhi verso il deserto; ed ecco che la gloria dell’Eterno apparve nella nuvola. ");
INSERT INTO ita1927_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","E l’Eterno parlò a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Io ho udito le mormorazioni dei figliuoli d’Israele; parla loro, dicendo: Sull’imbrunire mangerete della carne, e domattina sarete saziati di pane; e conoscerete che io sono l’Eterno, l’Iddio vostro”. ");
INSERT INTO ita1927_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","E avvenne, verso sera, che saliron delle quaglie, che ricopersero il campo; e, la mattina, c’era uno strato di rugiada intorno al campo. ");
INSERT INTO ita1927_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","E quando lo strato di rugiada fu sparito, ecco sulla faccia del deserto una cosa minuta, tonda, minuta come brina sulla terra. ");
INSERT INTO ita1927_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","E i figliuoli d’Israele, veduta che l’ebbero, dissero l’uno all’altro: “Che cos’è?” perché non sapevan che cosa fosse. E Mosè disse loro: “Questo è il pane che l’Eterno vi dà a mangiare. ");
INSERT INTO ita1927_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ecco quel che l’Eterno ha comandato: Ne raccolga ognuno quanto gli basta per il suo nutrimento: un omer a testa, secondo il numero delle vostre persone; ognuno ne pigli per quelli che sono nella sua tenda”. ");
INSERT INTO ita1927_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","I figliuoli d’Israele fecero così, e ne raccolsero gli uni più e gli altri meno. ");
INSERT INTO ita1927_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Lo misurarono con l’omer, e chi ne aveva raccolto molto non n’ebbe di soverchio; e chi ne aveva raccolto poco non n’ebbe penuria. Ognuno ne raccolse quanto gliene abbisognava per il suo nutrimento. ");
INSERT INTO ita1927_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","E Mosè disse loro: “Nessuno ne serbi fino a domattina”. ");
INSERT INTO ita1927_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ma alcuni non ubbidirono a Mosè, e ne serbarono fino all’indomani; e quello inverminì e mandò fetore; e Mosè s’adirò contro costoro. ");
INSERT INTO ita1927_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Così lo raccoglievano tutte le mattine: ciascuno nella misura che bastava al suo nutrimento; e quando il sole si faceva caldo, quello si struggeva. ");
INSERT INTO ita1927_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","E il sesto giorno raccolsero di quel pane il doppio: due omer per ciascuno. E tutti i capi della raunanza lo vennero a dire a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ed egli disse loro: “Questo è quello che ha detto l’Eterno: Domani è un giorno solenne di riposo: un sabato sacro all’Eterno; fate cuocere oggi quel che avete da cuocere e fate bollire quel che avete da bollire; e tutto quel che vi avanza, riponetelo e serbatelo fino a domani”. ");
INSERT INTO ita1927_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Essi dunque lo riposero fino all’indomani, come Mosè aveva ordinato: e quello non diè fetore e non inverminì. ");
INSERT INTO ita1927_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","E Mosè disse: “Mangiatelo oggi, perché oggi è il sabato sacro all’Eterno; oggi non ne troverete per i campi. ");
INSERT INTO ita1927_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Raccoglietene durante sei giorni; ma il settimo giorno è il sabato; in quel giorno non ve ne sarà”. ");
INSERT INTO ita1927_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Or nel settimo giorno avvenne che alcuni del popolo uscirono per raccoglierne, e non ne trovarono. ");
INSERT INTO ita1927_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","E l’Eterno disse a Mosè: “Fino a quando rifiuterete d’osservare i miei comandamenti e le mie leggi? ");
INSERT INTO ita1927_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Riflettete che l’Eterno vi ha dato il sabato; per questo, nel sesto giorno egli vi dà del pane per due giorni; ognuno stia dov’è; nessuno esca dalla sua tenda il settimo giorno”. ");
INSERT INTO ita1927_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Così il popolo si riposò il settimo giorno. ");
INSERT INTO ita1927_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","E la casa d’Israele chiamò quel pane Manna; esso era simile al seme di coriandolo; era bianco, e aveva il gusto di schiacciata fatta col miele. ");
INSERT INTO ita1927_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","E Mosè disse: “Questo è quello che l’Eterno ha ordinato: Empi un omer di manna, perché sia conservato per i vostri discendenti, onde veggano il pane col quale vi ho nutriti nel deserto, quando vi ho tratti fuori dal paese d’Egitto”. ");
INSERT INTO ita1927_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","E Mosè disse ad Aaronne: “Prendi un vaso, mettivi dentro un intero omer di manna, e deponilo davanti all’Eterno, perché sia conservato per i vostri discendenti”. ");
INSERT INTO ita1927_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Secondo l’ordine che l’Eterno avea dato a Mosè, Aaronne lo depose dinanzi alla Testimonianza, perché fosse conservato. ");
INSERT INTO ita1927_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","E i figliuoli d’Israele mangiarono la manna per quarant’anni, finché arrivarono in paese abitato; mangiarono la manna finché giunsero ai confini del paese di Canaan. ");
INSERT INTO ita1927_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Or l’omer è la decima parte dell’efa. ");
INSERT INTO ita1927_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Poi tutta la raunanza de’ figliuoli d’Israele partì dal deserto di Sin, marciando a tappe secondo gli ordini dell’Eterno, e si accampò a Refidim; e non c’era acqua da bere per il popolo. ");
INSERT INTO ita1927_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Allora il popolo contese con Mosè, e disse: “Dateci dell’acqua da bere”. E Mosè rispose loro: “Perché contendete con me? perché tentate l’Eterno?” ");
INSERT INTO ita1927_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Il popolo dunque patì quivi la sete, e mormorò contro Mosè, dicendo: “Perché ci hai fatti salire dall’Egitto per farci morire di sete noi, i nostri figliuoli e il nostro bestiame?” ");
INSERT INTO ita1927_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","E Mosè gridò all’Eterno, dicendo: “Che farò io per questo popolo? Non andrà molto che mi lapiderà”. ");
INSERT INTO ita1927_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","E l’Eterno disse a Mosè: “Passa oltre in fronte al popolo, e prendi teco degli anziani d’Israele; piglia anche in mano il bastone col quale percotesti il fiume, e va’. ");
INSERT INTO ita1927_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ecco, io starò la dinanzi a te, sulla roccia ch’è in Horeb; tu percoterai la roccia, e ne scaturirà dell’acqua, ed il popolo berrà”. Mosè fece così in presenza degli anziani d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","E pose nome a quel luogo Massah e Meribah a motivo della contesa de’ figliuoli d’Israele, e perché aveano tentato l’Eterno, dicendo: “L’Eterno è egli in mezzo a noi, si o no?” ");
INSERT INTO ita1927_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Allora venne Amalek a dar battaglia a Israele a Refidim. ");
INSERT INTO ita1927_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","E Mosè disse a Giosuè: “Facci una scelta d’uomini ed esci a combattere contro Amalek; domani io starò sulla vetta del colle col bastone di Dio in mano”. ");
INSERT INTO ita1927_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Giosuè fece come Mosè gli aveva detto, e combatté contro Amalek; e Mosè, Aaronne e Hur salirono sulla vetta del colle. ");
INSERT INTO ita1927_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","E avvenne che, quando Mosè teneva la mano alzata, Israele vinceva; e quando la lasciava cadere, vinceva Amalek. ");
INSERT INTO ita1927_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Or siccome le mani di Mosè s’eran fatte stanche, essi presero una pietra, gliela posero sotto, ed egli vi si mise a sedere; e Aaronne e Hur gli sostenevano le mani: l’uno da una parte, l’altro dall’altra; così le sue mani rimasero immobili fino al tramonto del sole. ");
INSERT INTO ita1927_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","E Giosuè sconfisse Amalek e la sua gente, mettendoli a fil di spada. ");
INSERT INTO ita1927_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","E l’Eterno disse a Mosè: “Scrivi questo fatto in un libro, perché se ne conservi il ricordo, e fa’ sapere a Giosuè che io cancellerò interamente di sotto al cielo la memoria di Amalek”. ");
INSERT INTO ita1927_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","E Mosè edificò un altare, al quale pose nome: “L’Eterno è la mia bandiera”; e disse: ");
INSERT INTO ita1927_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","“La mano è stata alzata contro il trono dell’Eterno, e l’Eterno farà guerra ad Amalek d’età in età”. ");
INSERT INTO ita1927_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Or Jethro, sacerdote di Madian, suocero di Mosè, udì tutto quello che Dio avea fatto a favor di Mosè e d’Israele suo popolo: come l’Eterno avea tratto Israele fuor dall’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","E Jethro, suocero di Mosè, prese Sefora, moglie di Mosè, ");
INSERT INTO ita1927_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","che questi avea rimandata, e i due figliuoli di lei che si chiamavano: l’uno, Ghershom, perché Mosè avea detto: “Ho soggiornato in terra straniera”; ");
INSERT INTO ita1927_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","e l’altro Eliezer, perché avea detto: “L’Iddio del padre mio è stato il mio aiuto, e mi ha liberato dalla spada di Faraone”. ");
INSERT INTO ita1927_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Jethro dunque, suocero di Mosè, venne a Mosè, coi figliuoli e la moglie di lui, nel deserto dov’egli era accampato, al monte di Dio; ");
INSERT INTO ita1927_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","e mandò a dire a Mosè: “Io, Jethro, tuo suocero, vengo da te con la tua moglie e i due suoi figliuoli con lei”. ");
INSERT INTO ita1927_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","E Mosè uscì a incontrare il suo suocero, gli s’inchinò, e lo baciò; s’informarono scambievolmente della loro salute, poi entrarono nella tenda. ");
INSERT INTO ita1927_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Allora Mosè raccontò al suo suocero tutto quello che l’Eterno avea fatto a Faraone e agli Egiziani per amor d’Israele, tutte le sofferenze patite durante il viaggio, e come l’Eterno li avea liberati. ");
INSERT INTO ita1927_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","E Jethro si rallegrò di tutto il bene che l’Eterno avea fatto a Israele, liberandolo dalla mano degli Egiziani. ");
INSERT INTO ita1927_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","E Jethro disse: “Benedetto sia l’Eterno, che vi ha liberati dalla mani degli Egiziani e dalla mano di Faraone, e ha liberato il popolo dal giogo degli Egiziani! ");
INSERT INTO ita1927_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ora riconosco che l’Eterno è più grande di tutti gli dèi; tale s’è mostrato, quando gli Egiziani hanno agito orgogliosamente contro Israele”. ");
INSERT INTO ita1927_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","E Jethro, suocero di Mosè, prese un olocausto e dei sacrifizi per offrirli a Dio; e Aaronne e tutti gli anziani d’Israele vennero a mangiare col suocero di Mosè in presenza di Dio. ");
INSERT INTO ita1927_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Il giorno seguente, Mosè si assise per render ragione al popolo; e il popolo stette intorno a Mosè dal mattino fino alla sera. ");
INSERT INTO ita1927_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","E quando il suocero di Mosè vide tutto quello ch’egli faceva per il popolo, disse: “Che è questo che tu fai col popolo? Perché siedi solo, e tutto il popolo ti sta attorno dal mattino fino alla sera?” ");
INSERT INTO ita1927_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","E Mosè rispose al suo suocero: “Perché il popolo viene da me per consultare Dio. ");
INSERT INTO ita1927_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Quand’essi hanno qualche affare, vengono da me, e io giudico fra l’uno e l’altro, e fo loro conoscere gli ordini di Dio e le sue leggi”. ");
INSERT INTO ita1927_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Ma il suocero di Mosè gli disse: “Questo che tu fai non va bene. ");
INSERT INTO ita1927_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Tu ti esaurirai certamente: tu e questo popolo ch’è teco; poiché quest’affare è troppo grave per te; tu non puoi bastarvi da te solo. ");
INSERT INTO ita1927_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Or ascolta la mia voce; io ti darò un consiglio, e Dio sia teco: Sii tu il rappresentante del popolo dinanzi a Dio, e porta a Dio le loro cause. ");
INSERT INTO ita1927_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Insegna loro gli ordini e le leggi, e mostra loro la via per la quale han da camminare e quello che devon fare; ");
INSERT INTO ita1927_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","ma scegli fra tutto il popolo degli uomini capaci che temano Dio: degli uomini fidati, che detestino il lucro iniquo; e stabiliscili sul popolo come capi di migliaia, capi di centinaia, capi di cinquantine e capi di diecine; ");
INSERT INTO ita1927_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","e rendano essi ragione al popolo in ogni tempo; e riferiscano a te ogni affare di grande importanza, ma ogni piccolo affare lo decidano loro. Allevia così il peso che grava su te, e lo portino essi teco. ");
INSERT INTO ita1927_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Se tu fai questo, e se Dio te l’ordina, potrai durare; e anche tutto questo popolo arriverà felicemente al luogo che gli è destinato”. ");
INSERT INTO ita1927_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mosè acconsentì al dire del suo suocero, e fece tutto quello ch’egli avea detto. ");
INSERT INTO ita1927_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","E Mosè scelse fra tutto Israele degli uomini capaci, e li stabilì capi del popolo: capi di migliaia, capi di centinaia, capi di cinquantine e capi di diecine. ");
INSERT INTO ita1927_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","E quelli rendevano ragione al popolo in ogni tempo; le cause difficili le portavano a Mosè, ma ogni piccolo affare lo decidevano loro. ");
INSERT INTO ita1927_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Poi Mosè accomiatò il suo suocero, il quale se ne tornò al suo paese. ");
INSERT INTO ita1927_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Nel primo giorno del terzo mese da che furono usciti dal paese d’Egitto, i figliuoli d’Israele giunsero al deserto di Sinai. ");
INSERT INTO ita1927_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Essendo partiti da Refidim, giunsero al deserto di Sinai e si accamparono nel deserto; quivi si accampò Israele, dirimpetto al monte. ");
INSERT INTO ita1927_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","E Mosè salì verso Dio; e l’Eterno lo chiamò dal monte, dicendo: “Di’ così alla casa di Giacobbe, e annunzia questo ai figliuoli d’Israele: ");
INSERT INTO ita1927_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Voi avete veduto quello che ho fatto agli Egiziani, e come io v’ho portato sopra ali d’aquila e v’ho menato a me. ");
INSERT INTO ita1927_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Or dunque, se ubbidite davvero alla mia voce e osservate il mio patto, sarete fra tutti i popoli il mio tesoro particolare; ");
INSERT INTO ita1927_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","poiché tutta la terra è mia; e mi sarete un regno di sacerdoti e una nazione santa. Queste sono le parole che dirai ai figliuoli d’Israele”. ");
INSERT INTO ita1927_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","E Mosè venne, chiamò gli anziani del popolo, ed espose loro tutte queste parole che l’Eterno gli aveva ordinato di dire. ");
INSERT INTO ita1927_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","E tutto il popolo rispose concordemente e disse: “Noi faremo tutto quello che l’Eterno ha detto”. E Mosè riferì all’Eterno le parole del popolo. ");
INSERT INTO ita1927_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","E l’Eterno disse a Mosè: “Ecco, io verro a te in una folta nuvola, affinché il popolo oda quand’io parlerò con te, e ti presti fede per sempre”. E Mosè riferì all’Eterno le parole del popolo. ");
INSERT INTO ita1927_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Allora l’Eterno disse a Mosè: “Va’ dal popolo, santificalo oggi e domani, e fa’ che si lavi le vesti. ");
INSERT INTO ita1927_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","E siano pronti per il terzo giorno; perché il terzo giorno l’Eterno scenderà in presenza di tutto il popolo sul monte Sinai. ");
INSERT INTO ita1927_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","E tu fisserai attorno attorno de’ limiti al popolo, e dirai: Guardatevi dal salire sul monte o dal toccarne il lembo. Chiunque toccherà il monte sarà messo a morte. ");
INSERT INTO ita1927_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Nessuna mano tocchi quel tale; ma sia lapidato o trafitto di frecce; animale o uomo che sia, non sia lasciato vivere! Quando il corno sonerà a distesa, allora salgano pure sul monte”. ");
INSERT INTO ita1927_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","E Mosè scese dal monte verso il popolo; santificò il popolo, e quelli si lavarono le vesti. ");
INSERT INTO ita1927_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ed egli disse al popolo: “Siate pronti fra tre giorni; non v’accostate a donna”. ");
INSERT INTO ita1927_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Il terzo giorno, come fu mattino, cominciaron de’ tuoni, de’ lampi, apparve una folta nuvola sul monte, e s’udì un fortissimo suon di tromba; e tutto il popolo ch’era nel campo, tremò. ");
INSERT INTO ita1927_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","E Mosè fece uscire il popolo dal campo per menarlo incontro a Dio; e si fermarono appiè del monte. ");
INSERT INTO ita1927_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Or il monte Sinai era tutto fumante, perché l’Eterno v’era disceso in mezzo al fuoco; e il fumo ne saliva come il fumo d’una fornace, e tutto il monte tremava forte. ");
INSERT INTO ita1927_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Il suon della tromba s’andava facendo sempre più forte; Mosè parlava, e Dio gli rispondeva con una voce. ");
INSERT INTO ita1927_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","L’Eterno dunque scese sul monte Sinai, in vetta al monte; e l’Eterno chiamò Mosè in vetta al monte, e Mosè vi salì. ");
INSERT INTO ita1927_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","E l’Eterno disse a Mosè: “Scendi, avverti solennemente il popolo onde non faccia irruzione verso l’Eterno per guardare, e non n’abbiano a perire molti. ");
INSERT INTO ita1927_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","E anche i sacerdoti che si appressano all’Eterno, si santifichino, affinché l’Eterno non si avventi contro a loro”. ");
INSERT INTO ita1927_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mosè disse all’Eterno: “Il popolo non può salire sul monte Sinai, poiché tu ce l’hai divietato dicendo: Poni de’ limiti attorno al monte, e santificalo”. ");
INSERT INTO ita1927_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ma l’Eterno gli disse: “Va’, scendi abbasso; poi salirai tu, e Aaronne teco; ma i sacerdoti e il popolo non facciano irruzione per salire verso l’Eterno, onde non s’avventi contro a loro”. ");
INSERT INTO ita1927_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Mosè discese al popolo e glielo disse. ");
INSERT INTO ita1927_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Allora Iddio pronunziò tutte queste parole, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Io sono l’Eterno, l’Iddio tuo, che ti ho tratto dal paese d’Egitto, dalla casa di servitù. ");
INSERT INTO ita1927_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Non avere altri dii nel mio cospetto. ");
INSERT INTO ita1927_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Non ti fare scultura alcuna né immagine alcuna delle cose che sono lassù ne’ cieli o quaggiù sulla terra o nelle acque sotto la terra; ");
INSERT INTO ita1927_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","non ti prostrare dinanzi a tali cose e non servir loro, perché io, l’Eterno, l’Iddio tuo, sono un Dio geloso che punisco l’iniquità dei padri sui figliuoli fino alla terza e alla quarta generazione di quelli che mi odiano, ");
INSERT INTO ita1927_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","e uso benignità, fino alla millesima generazione, verso quelli che m’amano e osservano i miei comandamenti. ");
INSERT INTO ita1927_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Non usare il nome dell’Eterno, ch’è l’Iddio tuo, in vano; perché l’Eterno non terra per innocente chi avrà usato il suo nome in vano. ");
INSERT INTO ita1927_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Ricordati del giorno del riposo per santificarlo. ");
INSERT INTO ita1927_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Lavora sei giorni e fa’ in essi ogni opera tua; ");
INSERT INTO ita1927_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ma il settimo è giorno di riposo, sacro all’Eterno, ch’è l’Iddio tuo; non fare in esso lavoro alcuno, né tu, né il tuo figliuolo, né la tua figliuola, né il tuo servo, né la tua serva, né il tuo bestiame, né il forestiero ch’è dentro alle tue porte; ");
INSERT INTO ita1927_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","poiché in sei giorni l’Eterno fece i cieli, la terra, il mare e tutto ciò ch’è in essi, e si riposò il settimo giorno; perciò l’Eterno ha benedetto il giorno del riposo e l’ha santificato. ");
INSERT INTO ita1927_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Onora tuo padre e tua madre, affinché i tuoi giorni siano prolungati sulla terra che l’Eterno, l’Iddio tuo, ti dà. ");
INSERT INTO ita1927_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Non uccidere. ");
INSERT INTO ita1927_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Non commettere adulterio. ");
INSERT INTO ita1927_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Non rubare. ");
INSERT INTO ita1927_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Non attestare il falso contro il tuo prossimo. ");
INSERT INTO ita1927_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Non concupire la casa del tuo prossimo; non concupire la moglie del tuo prossimo, né il suo servo, né la sua serva, né il suo bue, né il suo asino, né cosa alcuna che sia dei tuo prossimo”. ");
INSERT INTO ita1927_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Or tutto il popolo udiva i tuoni, il suon della tromba e vedeva i lampi e il monte fumante. A tal vista, tremava e se ne stava da lungi. ");
INSERT INTO ita1927_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","E disse a Mosè: “Parla tu con noi, e noi t’ascolteremo; ma non ci parli Iddio, che non abbiamo a morire”. ");
INSERT INTO ita1927_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","E Mosè disse al popolo: “Non temete, poiché Dio è venuto per mettervi alla prova, e affinché il suo timore vi stia dinanzi, e così non pecchiate”. ");
INSERT INTO ita1927_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Il popolo dunque se ne stava da lungi; ma Mosè s’avvicinò alla caligine dov’era Dio. ");
INSERT INTO ita1927_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","E l’Eterno disse a Mosè: “Di’ così ai figliuoli d’Israele: Voi stessi avete visto ch’io v’ho parlato dai cieli. ");
INSERT INTO ita1927_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Non fate altri dii accanto a me; non vi fate dii d’argento, né dii d’oro. ");
INSERT INTO ita1927_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Fammi un altare di terra; e su questo offri i tuoi olocausti, i tuoi sacrifizi di azioni di grazie, le tue pecore e i tuoi buoi; in qualunque luogo dove farò che il mio nome sia ricordato, io verrò a te e ti benedirò. ");
INSERT INTO ita1927_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","E se mi fai un altare di pietra, non lo costruire di pietre tagliate; perché, se tu alzassi su di esse lo scalpello, tu le contamineresti. ");
INSERT INTO ita1927_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","E non salire al mio altare per gradini, affinché la tua nudità non si scopra sovr’esso. ");
INSERT INTO ita1927_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Or queste sono le leggi che tu porrai dinanzi a loro: ");
INSERT INTO ita1927_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Se compri un servo ebreo, egli ti servirà per sei anni; ma il settimo se ne andrà libero, senza pagar nulla. ");
INSERT INTO ita1927_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Se è venuto solo, se ne andrà solo; se aveva moglie, la moglie se ne andrà con lui. ");
INSERT INTO ita1927_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Se il suo padrone gli dà moglie e questa gli partorisce figliuoli e figliuole, la moglie e i figliuoli di lei saranno del padrone, ed egli se ne andrà solo. ");
INSERT INTO ita1927_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ma se il servo fa questa dichiarazione: “Io amo il mio padrone, mia moglie e i miei figliuoli; io non voglio andarmene libero” ");
INSERT INTO ita1927_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","allora il suo padrone lo farà comparire davanti a Dio, e lo farà accostare alla porta o allo stipite, e il suo padrone gli forerà l’orecchio con una lesina; ed egli lo servirà per sempre. ");
INSERT INTO ita1927_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Se uno vende la propria figliuola per esser serva, ella non se ne andrà come se ne vanno i servi. ");
INSERT INTO ita1927_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","S’ella dispiace al suo padrone, che se l’era presa per moglie, egli la farà riscattare; ma non avrà il diritto di venderla a gente straniera, dopo esserle stato infedele. ");
INSERT INTO ita1927_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","E se la dà in isposa al suo figliuolo, la tratterà secondo il diritto delle fanciulle. ");
INSERT INTO ita1927_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Se prende un altra moglie, non toglierà alla prima né il vitto, né il vestire, né la coabitazione. ");
INSERT INTO ita1927_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Se non le fa queste tre cose, ella se ne andrà senza pagamento di prezzo. ");
INSERT INTO ita1927_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Chi percuote un uomo sì ch’egli muoia, dev’esser messo a morte. ");
INSERT INTO ita1927_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Se non gli ha teso agguato, ma Dio gliel’ha fatto cader sotto mano, io ti stabilirò un luogo dov’ei si possa rifugiare. ");
INSERT INTO ita1927_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Se alcuno con premeditazione uccide il suo prossimo mediante insidia, tu lo strapperai anche dal mio altare, per farlo morire. ");
INSERT INTO ita1927_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Chi percuote suo padre o sua madre dev’esser messo a morte. ");
INSERT INTO ita1927_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Chi ruba un uomo sia che l’abbia venduto o che gli sia trovato nelle mani dev’esser messo a morte. ");
INSERT INTO ita1927_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Chi maledice suo padre o sua madre dev’esser messo a morte. ");
INSERT INTO ita1927_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Se degli uomini vengono a rissa, e uno percuote l’altro con una pietra o col pugno, e quello non muoia, ma debba mettersi a letto, ");
INSERT INTO ita1927_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","se si rileva e può camminar fuori appoggiato al suo bastone, colui che lo percosse sarà assolto; soltanto, lo indennizzerà del tempo che ha perduto e lo farà curare fino a guarigione compiuta. ");
INSERT INTO ita1927_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Se uno percuote il suo servo o la sua serva col bastone sì che gli muoiano fra le mani, il padrone dev’esser punito; ");
INSERT INTO ita1927_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","ma se sopravvivono un giorno o due, non sarà punito, perché son danaro suo. ");
INSERT INTO ita1927_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Se alcuni vengono a rissa e percuotono una donna incinta sì ch’ella si sgravi, ma senza che ne segua altro danno, il percotitore sarà condannato all’ammenda che il marito della donna gl’imporrà; e la pagherà come determineranno i giudici; ");
INSERT INTO ita1927_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","ma se ne segue danno, ");
INSERT INTO ita1927_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","darai vita per vita, occhio per occhio, dente per dente, mano per mano, ");
INSERT INTO ita1927_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","piede per piede, scottatura per scottatura, ferita per ferita, contusione per contusione. ");
INSERT INTO ita1927_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Se uno colpisce l’occhio del suo servo o l’occhio della sua serva e glielo fa perdere, li lascerà andar liberi in compenso dell’occhio perduto. ");
INSERT INTO ita1927_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","E se fa cadere un dente al suo servo o un dente alla sua serva, li lascerà andar liberi in compenso del dente perduto. ");
INSERT INTO ita1927_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Se un bue cozza un uomo o una donna sì che muoia, il bue dovrà esser lapidato e non se ne mangerà la carne; ma il padrone del bue sarà assolto. ");
INSERT INTO ita1927_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Però, se il bue era già da tempo uso cozzare, e il padrone n’è stato avvertito, ma non l’ha tenuto rinchiuso, e il bue ha ucciso un uomo o una donna, il bue sarà lapidato, e il suo padrone pure sarà messo a morte. ");
INSERT INTO ita1927_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Ove sia imposto al padrone un prezzo di riscatto, egli pagherà per il riscatto della propria vita tutto quello che gli sarà imposto. ");
INSERT INTO ita1927_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Se il bue cozza un figliuolo o una figliuola, gli si applicherà questa medesima legge. ");
INSERT INTO ita1927_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Se il bue cozza un servo o una serva, il padrone del bue pagherà al padrone del servo trenta sicli d’argento, e il bue sarà lapidato. ");
INSERT INTO ita1927_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Se uno apre una fossa, o se uno scava una fossa e non la copre, e un bue o un asino vi cade dentro, ");
INSERT INTO ita1927_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","il padron della fossa rifarà il danno: pagherà in danaro il valore della bestia al padrone, e la bestia morta sarà sua. ");
INSERT INTO ita1927_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Se il bue d’un uomo perisce il bue d’un altro sì ch’esso muoia, si venderà il bue vivo e se ne dividerà il prezzo; e anche il bue morto sarà diviso fra loro. ");
INSERT INTO ita1927_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Se poi è noto che quel bue era già da tempo uso cozzare, e il suo padrone non l’ha tenuto rinchiuso, questi dovrà pagare bue per bue, e la bestia morta sarà sua. ");
INSERT INTO ita1927_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Se uno ruba un bue o una pecora e li ammazza o li vende, restituirà cinque buoi per il bue e quattro pecore per la pecora. ");
INSERT INTO ita1927_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Se il ladro, còlto nell’atto di fare uno scasso, è percosso e muore, non v’è delitto d’omicidio. ");
INSERT INTO ita1927_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Se il sole era levato quand’avvenne il fatto, vi sarà delitto d’omicidio. Il ladro dovrà risarcire il danno; se non ha di che risarcirlo, sarà venduto per ciò che ha rubato. ");
INSERT INTO ita1927_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Se il furto, bue o asino o pecora che sia gli è trovato vivo nelle mani, restituirà il doppio. ");
INSERT INTO ita1927_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Se uno arrecherà de’ danni a un campo altrui o ad una vigna, lasciando andare le sue bestie a pascere nel campo altrui risarcirà il danno col meglio del suo campo e col meglio della sua vigna. ");
INSERT INTO ita1927_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Se divampa un fuoco e s’attacca alle spine sì che ne sia distrutto il grano in covoni o il grano in piedi o il campo, chi avrà acceso il fuoco dovrà risarcire il danno. ");
INSERT INTO ita1927_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Se uno affida al suo vicino del danaro o degli oggetti da custodire, e questi siano rubati dalla casa di quest’ultimo, se il ladro si trova, restituirà il doppio. ");
INSERT INTO ita1927_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Se il ladro non si trova, il padrone della casa comparirà davanti a Dio per giurare che non ha messo la mano sulla roba del suo vicino. ");
INSERT INTO ita1927_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","In ogni caso di delitto, sia che si tratti d’un bue o d’un asino o d’una pecora o d’un vestito o di qualunque oggetto perduto del quale uno dica: “E’ questo qui!” la causa d’ambedue le parti verrà davanti a Dio; colui che Dio condannerà, restituirà il doppio al suo prossimo. ");
INSERT INTO ita1927_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Se uno dà in custodia al suo vicino un asino o un bue o una pecora o qualunque altra bestia, ed essa muore o resta stroppiata o è portata via senza che ci sian testimoni, ");
INSERT INTO ita1927_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","interverrà fra le due parti il giuramento dell’Eterno per sapere se colui che avea la bestia in custodia non ha messo la mano sulla roba del suo vicino. Il padrone della bestia si contenterà del giuramento, e l’altro non sarà tenuto a rifacimento di danni. ");
INSERT INTO ita1927_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ma se la bestia gli è stata rubata, egli dovrà risarcire del danno il padrone d’essa. ");
INSERT INTO ita1927_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Se la bestia è stata sbranata, la produrrà come prova, e non sarà tenuto a risarcimento per la bestia sbranata. ");
INSERT INTO ita1927_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Se uno prende in prestito dal suo vicino una bestia, e questa resti stroppiata o muoia essendo assente il padrone d’essa, egli dovrà rifare il danno. ");
INSERT INTO ita1927_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Se il padrone è presente, non v’è luogo a rifacimento di danni; se la bestia è stata presa a nolo, essa è compresa nel prezzo del nolo. ");
INSERT INTO ita1927_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Se uno seduce una fanciulla non ancora fidanzata e si giace con lei, dovrà pagare la sua dote e prenderla per moglie. ");
INSERT INTO ita1927_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Se il padre di lei rifiuta del tutto di dargliela, paghi la somma che si suol dare per le fanciulle. ");
INSERT INTO ita1927_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Non lascerai vivere la strega. ");
INSERT INTO ita1927_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Chi s’accoppia con una bestia dovrà esser messo a morte. ");
INSERT INTO ita1927_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Chi offre sacrifizi ad altri dèi, fuori che all’Eterno solo, sarà sterminato come anatema. ");
INSERT INTO ita1927_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Non maltratterai lo straniero e non l’opprimerai; perché anche voi foste stranieri nel paese d’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Non affliggerete alcuna vedova, ne alcun orfano. ");
INSERT INTO ita1927_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Se in qualche modo li affliggi, ed essi gridano a me, io udrò senza dubbio il loro grido; ");
INSERT INTO ita1927_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","la mia ira s’accenderà, e io vi ucciderò con la spada; e le vostre mogli saranno vedove, e i vostri figliuoli orfani. ");
INSERT INTO ita1927_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Se tu presti del danaro a qualcuno del mio popolo, al povero ch’è teco, non lo tratterai da usuraio; non gl’imporrai interesse. ");
INSERT INTO ita1927_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Se prendi in pegno il vestito del tuo prossimo, glielo renderai prima che tramonti il sole; ");
INSERT INTO ita1927_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","perché esso è l’unica sua coperta, è la veste con cui si avvolge il corpo. Su che dormirebb’egli? E se avverrà ch’egli gridi a me, io l’udrò; perché sono misericordioso. ");
INSERT INTO ita1927_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Non bestemmierai contro Dio, e non maledirai il principe del tuo popolo. ");
INSERT INTO ita1927_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Non indugerai a offrirmi il tributo dell’abbondanza delle tue raccolte e di ciò che cola dai tuoi strettoi. Mi darai il primogenito de’ tuoi figliuoli. ");
INSERT INTO ita1927_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Lo stesso farai del tuo grosso e del tuo minuto bestiame: il loro primo parto rimarrà sette giorni presso la madre; l’ottavo giorno, me lo darai. ");
INSERT INTO ita1927_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Voi mi sarete degli uomini santi; non mangerete carne di bestia trovata sbranata nei campi; gettatela ai cani. ");
INSERT INTO ita1927_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Non spargere alcuna voce calunniosa e non tener di mano all’empio nell’attestare il falso. ");
INSERT INTO ita1927_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Non andar dietro alla folla per fare il male; e non deporre in giudizio schierandoti dalla parte dei più per pervertire la giustizia. ");
INSERT INTO ita1927_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Parimente non favorire il povero nel suo processo. ");
INSERT INTO ita1927_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Se incontri il bue del tuo nemico o il suo asino smarrito, non mancare di ricondurglielo. ");
INSERT INTO ita1927_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Se vedi l’asino di colui che t’odia steso a terra sotto il carico, guardati bene dall’abbandonarlo, ma aiuta il suo padrone a scaricarlo. ");
INSERT INTO ita1927_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Non violare il diritto del povero del tuo popolo nel suo processo. ");
INSERT INTO ita1927_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Rifuggi da ogni parola bugiarda; e non far morire l’innocente e il giusto; perché io non assolverò il malvagio ");
INSERT INTO ita1927_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Non accettar presenti; perché il presente acceca quelli che ci veggon chiaro, e perverte le parole dei giusti. ");
INSERT INTO ita1927_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Non opprimere lo straniero; voi lo conoscete l’animo dello straniero, giacché siete stati stranieri nel paese d’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Per sei anni seminerai la tua terra e ne raccoglierai i frutti; ");
INSERT INTO ita1927_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ma il settimo anno la lascerai riposare e rimanere incolta; i poveri del tuo popolo ne godranno, e le bestie della campagna mangeranno quel che rimarrà. Lo stesso farai della tua vigna e de’ tuoi ulivi. ");
INSERT INTO ita1927_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Per sei giorni farai il tuo lavoro; ma il settimo giorno ti riposerai, affinché il tuo bue e il tuo asino possano riposarsi, e il figliuolo della tua serva e il forestiero possano riprender fiato. ");
INSERT INTO ita1927_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Porrete ben mente a tutte le cose che io vi ho dette, e non pronunzierete il nome di dèi stranieri: non lo si oda uscire dalla vostra bocca. ");
INSERT INTO ita1927_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Tre volte all’anno mi celebrerai una festa. ");
INSERT INTO ita1927_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Osserverai la festa degli azzimi. Per sette giorni mangerai pane senza lievito, come te l’ho ordinato, al tempo stabilito del mese di Abib, perché in quel mese tu uscisti dal paese d’Egitto; e nessuno comparirà dinanzi a me a mani vuote. ");
INSERT INTO ita1927_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Osserverai la festa della mietitura, delle primizie del tuo lavoro, di quello che avrai seminato nei campi; e la festa della raccolta, alla fine dell’anno, quando avrai raccolto dai campi i frutti del tuo lavoro. ");
INSERT INTO ita1927_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Tre volte all’anno tutti i maschi compariranno davanti al Signore, l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Non offrirai il sangue della mia vittima insieme con pane lievitato; e il grasso dei sacrifizi della mia festa non sarà serbato durante la notte fino al mattino. ");
INSERT INTO ita1927_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Porterai alla casa dell’Eterno, ch’è il tuo Dio, le primizie de’ primi frutti della terra. Non farai cuocere il capretto nel latte di sua madre. ");
INSERT INTO ita1927_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Ecco, io mando un angelo davanti a te per proteggerti per via, e per introdurti nel luogo che ho preparato. ");
INSERT INTO ita1927_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Sii guardingo in sua presenza, e ubbidisci alla sua voce; non ti ribellare a lui, perch’egli non perdonerà le vostre trasgressioni; poiché il mio nome è in lui. ");
INSERT INTO ita1927_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ma se ubbidisci fedelmente alla sua voce e fai tutto quello che ti dirò, io sarò il nemico de’ tuoi nemici, l’avversario de’ tuoi avversari; ");
INSERT INTO ita1927_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","poiché il mio angelo andrà innanzi a te e t’introdurrà nel paese degli Amorei, degli Hittei, dei Ferezei, dei Cananei, degli Hivvei e dei Gebusei, e li sterminerò. ");
INSERT INTO ita1927_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Tu non ti prostrerai davanti ai loro dèi, e non servirai loro. Non farai quello ch’essi fanno; ma distruggerai interamente quegli dèi e spezzerai le loro colonne. ");
INSERT INTO ita1927_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Servirete all’Eterno, ch’è il vostro Dio, ed egli benedirà il tuo pane e la tua acqua; ed io allontanerò la malattia di mezzo a te. ");
INSERT INTO ita1927_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Nel tuo paese non ci sarà donna che abortisca, né donna sterile. Io farò completo il numero de’ tuoi giorni. ");
INSERT INTO ita1927_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Io manderò davanti a te il mio terrore, e metterò in rotta ogni popolo presso il quale arriverai, e farò voltar le spalle dinanzi a te a tutti i tuoi nemici. ");
INSERT INTO ita1927_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","E manderò davanti a te i calabroni, che scacceranno gli Hivvei, i Cananei e gli Hittei dal tuo cospetto. ");
INSERT INTO ita1927_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Non li scaccerò dal tuo cospetto in un anno, affinché il paese non diventi un deserto, e le bestie de’ campi non si moltiplichino contro di te. ");
INSERT INTO ita1927_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Li scaccerò dal tuo cospetto a poco a poco, finché tu cresca di numero e possa prender possesso del paese. ");
INSERT INTO ita1927_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","E fisserò i tuoi confini dal mar Rosso al mar de’ Filistei, e dal deserto sino al fiume; poiché io vi darò nelle mani gli abitanti del paese; e tu li scaccerai d’innanzi a te. ");
INSERT INTO ita1927_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Non farai alleanza di sorta con loro, né coi loro dèi. ");
INSERT INTO ita1927_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Non dovranno abitare nel tuo paese, perché non t’inducano a peccare contro di me: tu serviresti ai loro dèi, e questo ti sarebbe un laccio. ");
INSERT INTO ita1927_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Poi Dio disse a Mosè: “Sali all’Eterno tu ed Aaronne, Nadab e Abihu e settanta degli anziani d’Israele, e adorate da lungi; ");
INSERT INTO ita1927_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","poi Mosè solo s’accosterà all’Eterno; ma gli altri non s’accosteranno, né salirà il popolo con lui”. ");
INSERT INTO ita1927_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","E Mosè venne e riferì al popolo tutte le parole dell’Eterno e tutte le leggi. E tutto il popolo rispose ad una voce e disse: “Noi faremo tutte le cose che l’Eterno ha dette”. ");
INSERT INTO ita1927_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Poi Mosè scrisse tutte le parole dell’Eterno; e, levatosi di buon’ora la mattina, eresse appiè del monte un altare e dodici pietre per le dodici tribù d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","E mandò dei giovani tra i figliuoli d’Israele a offrire olocausti e a immolare giovenchi come sacrifizi di azioni di grazie all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","E Mosè prese la metà del sangue e lo mise in bacini; e l’altra metà la sparse sull’altare. ");
INSERT INTO ita1927_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Poi prese il libro del patto e lo lesse in presenza del popolo, il quale disse: “Noi faremo tutto quello che l’Eterno ha detto, e ubbidiremo”. ");
INSERT INTO ita1927_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Allora Mosè prese il sangue, ne asperse il popolo e disse: “Ecco il sangue del patto che l’Eterno ha fatto con voi sul fondamento di tutte queste parole”. ");
INSERT INTO ita1927_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Poi Mosè ed Aaronne, Nadab e Abihu e settanta degli anziani d’Israele salirono, ");
INSERT INTO ita1927_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","e videro l’Iddio d’Israele. Sotto i suoi piedi c’era come un pavimento lavorato in trasparente zaffiro, e simile, per limpidezza, al cielo stesso. ");
INSERT INTO ita1927_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ed egli non mise la mano addosso a quegli eletti tra i figliuoli d’Israele; ma essi videro Iddio, e mangiarono e bevvero. ");
INSERT INTO ita1927_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","E l’Eterno disse a Mosè: “Sali da me sul monte, e fermati quivi; e io ti darò delle tavole di pietra, la legge e i comandamenti che ho scritti, perché siano insegnati ai figliuoli d’Israele”. ");
INSERT INTO ita1927_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Mosè dunque si levò con Giosuè suo ministro; e Mosè salì sul monte di Dio. ");
INSERT INTO ita1927_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","E disse agli anziani: “Aspettateci qui, finché torniamo a voi. Ecco, Aaronne e Hur sono con voi; chiunque abbia qualche affare si rivolga a loro”. ");
INSERT INTO ita1927_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Mosè dunque salì sul monte, e la nuvola ricoperse il monte. ");
INSERT INTO ita1927_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","E la gloria dell’Eterno rimase sui monte Sinai e la nuvola lo coperse per sei giorni; e il settimo giorno l’Eterno chiamò Mosè di mezzo alla nuvola. ");
INSERT INTO ita1927_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","E l’aspetto della gloria dell’Eterno era agli occhi de’ figliuoli d’Israele come un fuoco divorante sulla cima del monte. ");
INSERT INTO ita1927_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","E Mosè entrò in mezzo alla nuvola e salì sul monte; e Mosè rimase sul monto quaranta giorni e quaranta notti. ");
INSERT INTO ita1927_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","L’Eterno parlò a Mosè dicendo: “Di’ ai figliuoli d’Israele che mi facciano un’offerta; ");
INSERT INTO ita1927_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","accetterete l’offerta da ogni uomo che sarà disposto a farmela di cuore. ");
INSERT INTO ita1927_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","E questa è l’offerta che accetterete da loro: oro, argento e rame; ");
INSERT INTO ita1927_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","stoffe di color violaceo, porporino, scarlatto; ");
INSERT INTO ita1927_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","lino fino e pel di capra; pelli di montone tinte in rosso, pelli di delfino e legno d’acacia; ");
INSERT INTO ita1927_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","olio per il candelabro, aromi per l’olio della unzione e per il profumo odoroso; ");
INSERT INTO ita1927_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","pietre di onice e pietre da incastonare per l’efod e il pettorale. ");
INSERT INTO ita1927_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","E mi facciano un santuario perch’io abiti in mezzo a loro. ");
INSERT INTO ita1927_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Me lo farete in tutto e per tutto secondo il modello del tabernacolo e secondo il modello di tutti i suoi arredi, che io sto per mostrarti. ");
INSERT INTO ita1927_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Faranno dunque un’arca di legno d’acacia; la sua lunghezza sarà di due cubiti e mezzo, la sua larghezza di un cubito e mezzo, e la sua altezza di un cubito e mezzo. ");
INSERT INTO ita1927_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","La rivestirai d’oro puro; la rivestirai così di dentro e di fuori; e le farai al di sopra una ghirlanda d’oro, che giri intorno. ");
INSERT INTO ita1927_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Fonderai per essa quattro anelli d’oro, che metterai ai suoi quattro piedi: due anelli da un lato e due anelli dall’altro lato, ");
INSERT INTO ita1927_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Farai anche delle stanghe di legno d’acacia, e le rivestirai d’oro. ");
INSERT INTO ita1927_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","E farai passare le stanghe per gli anelli ai lati dell’arca, perché servano a portarla. ");
INSERT INTO ita1927_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Le stanghe rimarranno negli anelli dell’arca; non ne saranno tratte fuori. ");
INSERT INTO ita1927_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","E metterai nell’arca la testimonianza che ti darò. ");
INSERT INTO ita1927_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Farai anche un propiziatorio d’oro puro; la sua lunghezza sarà di due cubiti e mezzo, e la sua larghezza di un cubito e mezzo. ");
INSERT INTO ita1927_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","E farai due cherubini d’oro; li farai lavorati al martello, alle due estremità del propiziatorio; ");
INSERT INTO ita1927_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","fa’ un cherubino a una delle estremità, e un cherubino all’altra; farete che questi cherubini escano dal propiziatorio alle due estremità. ");
INSERT INTO ita1927_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","E i cherubini avranno le ali spiegate in alto, in modo da coprire il propiziatorio con le loro ali; avranno la faccia vòlta l’uno verso l’altro; le facce dei cherubini saranno volte verso il propiziatorio. ");
INSERT INTO ita1927_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","E metterai il propiziatorio in alto, sopra l’arca; e nell’arca metterai la testimonianza che ti darò. ");
INSERT INTO ita1927_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Quivi io m’incontrerò teco; e di sul propiziatorio, di fra i due cherubini che sono sull’arca della testimonianza, ti comunicherò tutti gli ordini che avrò da darti per i figliuoli d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Farai anche una tavola di legno d’acacia; la sua lunghezza sarà di due cubiti; la sua larghezza di un cubito, e la sua altezza di un cubito e mezzo. ");
INSERT INTO ita1927_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","La rivestirai d’oro puro, e le farai una ghirlanda d’oro che le giri attorno. ");
INSERT INTO ita1927_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Le farai all’intorno una cornice alta quattro dita; e a questa cornice farai tutt’intorno una ghirlanda d’oro. ");
INSERT INTO ita1927_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Le farai pure quattro anelli d’oro, e metterai gli anelli ai quattro canti, ai quattro piedi della tavola. ");
INSERT INTO ita1927_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Gli anelli saranno vicinissimi alla cornice per farvi passare le stanghe destinate a portar la tavola. ");
INSERT INTO ita1927_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","E le stanghe le farai di legno d’acacia, le rivestirai d’oro, e serviranno a portare la tavola. ");
INSERT INTO ita1927_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Farai pure i suoi piatti, le sue coppe, i suoi calici e le sue tazze da servire per le libazioni; li farai d’oro puro. ");
INSERT INTO ita1927_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","E metterai sulla tavola il pane della presentazione, che starà del continuo nel mio cospetto. ");
INSERT INTO ita1927_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Farai anche un candelabro d’oro puro; il candelabro, il suo piede e il suo tronco saranno lavorati al martello; i suoi calici, i suoi pomi e i suoi fiori saranno tutti d’un pezzo col candelabro. ");
INSERT INTO ita1927_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Gli usciranno sei bracci dai lati: tre bracci del candelabro da un lato e tre bracci del candelabro dall’altro; ");
INSERT INTO ita1927_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","su l’uno de’ bracci saranno tre calici in forma di mandorla, con un pomo e un fiore; e sull’altro braccio, tre calici in forma di mandorla, con un pomo e un fiore. Lo stesso per i sei bracci uscenti dal candelabro. ");
INSERT INTO ita1927_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Nel tronco del candelabro ci saranno poi quattro calici in forma di mandorla, coi loro pomi e i loro fiori. ");
INSERT INTO ita1927_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Ci sarà un pomo sotto i due primi bracci che partono dal candelabro; un pomo sotto i due seguenti bracci, e un pomo sotto i due ultimi bracci che partono dal candelabro: così per i sei bracci uscenti dal candelabro. ");
INSERT INTO ita1927_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Questi pomi e questi bracci saranno tutti d’un pezzo col candelabro; il tutto sarà d’oro fino lavorato al martello. ");
INSERT INTO ita1927_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Farai pure le sue lampade, in numero di sette; e le sue lampade si accenderanno in modo che la luce rischiari il davanti del candelabro. ");
INSERT INTO ita1927_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","E i suoi smoccolatoi e i suoi porta smoccolature saranno d’oro puro. ");
INSERT INTO ita1927_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Per fare il candelabro con tutti questi suoi utensili s’impiegherà un talento d’oro puro. ");
INSERT INTO ita1927_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","E vedi di fare ogni cosa secondo il modello che t’è stato mostrato sul monte. ");
INSERT INTO ita1927_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Farai poi il tabernacolo di dieci teli di lino fino ritorto, di filo color violaceo, porporino e scarlatto, con dei cherubini artisticamente lavorati. ");
INSERT INTO ita1927_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","La lunghezza d’ogni telo sarà di ventotto cubiti, e la larghezza d’ogni telo di quattro cubiti; tutti i teli saranno d’una stessa misura. ");
INSERT INTO ita1927_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Cinque teli saranno uniti assieme, e gli altri cinque teli saran pure uniti assieme. ");
INSERT INTO ita1927_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Farai de’ nastri di color violaceo all’orlo del telo ch’è all’estremità della prima serie; e lo stesso farai all’orlo del telo ch’è all’estremità della seconda serie. ");
INSERT INTO ita1927_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Metterai cinquanta nastri al primo telo, e metterai cinquanta nastri all’orlo del telo ch’è all’estremità della seconda serie di teli: i nastri si corrisponderanno l’uno all’altro. ");
INSERT INTO ita1927_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","E farai cinquanta fermagli d’oro, e unirai i teli l’uno all’altro mediante i fermagli, perché il tabernacolo formi un tutto. ");
INSERT INTO ita1927_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Farai pure dei teli di pel di capra, per servir da tenda per coprire il tabernacolo: di questi teli ne farai undici. ");
INSERT INTO ita1927_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","La lunghezza d’ogni telo sarà di trenta cubiti, e la larghezza d’ogni telo, di quattro cubiti; gli undici teli avranno la stessa misura. ");
INSERT INTO ita1927_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Unirai assieme, da sé, cinque di questi teli, e unirai da sé gli altri sei, e addoppierai il sesto sulla parte anteriore della tenda. ");
INSERT INTO ita1927_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","E metterai cinquanta nastri all’orlo del telo ch’è all’estremità della prima serie, e cinquanta nastri all’orlo del telo ch’è all’estremità della seconda serie di teli. ");
INSERT INTO ita1927_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","E farai cinquanta fermagli di rame, e farai entrare i fermagli nei nastri e unirai così la tenda, in modo che formi un tutto. ");
INSERT INTO ita1927_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Quanto alla parte che rimane di soprappiù dei teli della tenda, la metà del telo di soprappiù ricadrà sulla parte posteriore del tabernacolo; ");
INSERT INTO ita1927_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","e il cubito da una parte e il cubito dall’altra parte che saranno di soprappiù nella lunghezza dei teli della tenda, ricadranno sui due iati del tabernacolo, di qua e di là, per coprirlo. ");
INSERT INTO ita1927_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Farai pure per la tenda una coperta di pelli di montone tinte di rosso, e sopra questa un’altra coperta di pelli di delfino. ");
INSERT INTO ita1927_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Farai per il tabernacolo delle assi di legno d’acacia, messe per ritto. ");
INSERT INTO ita1927_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","La lunghezza d’un’asse sarà di dieci cubiti, e la larghezza d’un’asse, di un cubito e mezzo. ");
INSERT INTO ita1927_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Ogni asse avrà due incastri paralleli; farai così per tutte le assi del tabernacolo. ");
INSERT INTO ita1927_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Farai dunque le assi per il tabernacolo: venti assi dal lato meridionale, verso il sud. ");
INSERT INTO ita1927_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Metterai quaranta basi d’argento sotto le venti assi: due basi sotto ciascun’asse per i suoi due incastri. ");
INSERT INTO ita1927_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","E farai venti assi per il secondo lato dei tabernacolo, il lato di nord, ");
INSERT INTO ita1927_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","e le oro quaranta basi d’argento: due basi sotto ciascun’asse. ");
INSERT INTO ita1927_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","E per la parte posteriore del tabernacolo, verso occidente, farai sei assi. ");
INSERT INTO ita1927_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Farai pure due assi per gli angoli del tabernacolo, dalla parte posteriore. ");
INSERT INTO ita1927_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Queste saranno doppie dal basso in su, e al tempo stesso formeranno un tutto fino in cima, fino al primo anello. Così sarà per ambedue le assi, che saranno ai due angoli. ");
INSERT INTO ita1927_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Vi saranno dunque otto assi, con le loro basi d’argento: sedici basi: due basi sotto ciascun’asse. ");
INSERT INTO ita1927_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Farai anche delle traverse di legno d’acacia: cinque, per le assi di un lato del tabernacolo; ");
INSERT INTO ita1927_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","cinque traverse per le assi dell’altro lato del tabernacolo, e cinque traverse per le assi della parte posteriore del tabernacolo, a occidente. ");
INSERT INTO ita1927_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","La traversa di mezzo, in mezzo alle assi, passera da una parte all’altra. ");
INSERT INTO ita1927_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","E rivestirai d’oro le assi, e farai d’oro i loro anelli per i quali passeranno le traverse, e rivestirai d’oro le traverse. ");
INSERT INTO ita1927_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Erigerai il tabernacolo secondo la forma esatta che te n’è stata mostrata sul monte. ");
INSERT INTO ita1927_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Farai un velo di filo violaceo, porporino, scarlatto, e di lino fino ritorto con de’ cherubini artisticamente lavorati, ");
INSERT INTO ita1927_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","e lo sospenderai a quattro colonne di acacia, rivestite d’oro, che avranno i chiodi d’oro e poseranno su basi d’argento. ");
INSERT INTO ita1927_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Metterai il velo sotto i fermagli; e quivi, al di là del velo, introdurrai l’arca della testimonianza; quel velo sarà per voi la separazione del luogo santo dal santissimo. ");
INSERT INTO ita1927_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","E metterai il propiziatorio sull’arca della testimonianza nel luogo santissimo. ");
INSERT INTO ita1927_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","E metterai la tavola fuori del velo, e il candelabro dirimpetto alla tavola dal lato meridionale del tabernacolo; e metterai la tavola dal lato di settentrione. ");
INSERT INTO ita1927_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Farai pure per l’ingresso della tenda una portiera di filo violaceo, porporino, scarlatto, e di lino fino ritorto, in lavoro di ricamo. ");
INSERT INTO ita1927_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","E farai cinque colonne di acacia per sospendervi la portiera; le rivestirai d’oro, e avranno i chiodi d’oro e tu fonderai per esse cinque basi di rame. ");
INSERT INTO ita1927_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Farai anche un altare di legno d’acacia, lungo cinque cubiti e largo cinque cubiti; l’altare sarà quadrato, e avrà tre cubiti d’altezza. ");
INSERT INTO ita1927_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Farai ai quattro angoli dei corni che spuntino dall’altare, il quale rivestirai di rame. ");
INSERT INTO ita1927_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Farai pure i suoi vasi per raccoglier le ceneri, le sue palette, i suoi bacini, i suoi forchettoni e i suoi bracieri; tutti i suoi utensili li farai di rame. ");
INSERT INTO ita1927_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","E farai una gratella di rame in forma di rete; e sopra la rete, ai suoi quattro canti, farai quattro anelli di rame; ");
INSERT INTO ita1927_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","e la porrai sotto la cornice dell’altare, nella parte inferiore, in modo che la rete raggiunga la metà dell’altezza dell’altare. ");
INSERT INTO ita1927_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Farai anche delle stanghe per l’altare: delle stanghe di legno d’acacia, e le rivestirai di rame. ");
INSERT INTO ita1927_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","E si faran passare le stanghe per gli anelli; e le stanghe saranno ai due lati dell’altare, quando lo si dovrà portare. ");
INSERT INTO ita1927_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Lo farai di tavole, vuoto; dovrà esser fatto, conforme ti è stato mostrato sul monte. ");
INSERT INTO ita1927_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Farai anche il cortile del tabernacolo; dal lato meridionale, ci saranno, per formare il cortile, delle cortine di lino fino ritorto, per una lunghezza di cento cubiti, per un lato. ");
INSERT INTO ita1927_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Questo lato avrà venti colonne con le loro venti basi di rame; i chiodi e le aste delle colonne saranno d’argento. ");
INSERT INTO ita1927_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Così pure per il lato di settentrione, per lungo, ci saranno delle cortine lunghe cento cubiti, con venti colonne e le loro venti basi di rame; i chiodi e le aste delle colonne saranno d’argento. ");
INSERT INTO ita1927_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","E per largo, dal lato d’occidente, il cortile avrà cinquanta cubiti di cortine, con dieci colonne e le loro dieci basi. ");
INSERT INTO ita1927_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","E per largo, sul davanti, dal lato orientale il cortile avrà cinquanta cubiti. ");
INSERT INTO ita1927_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Da uno dei lati dell’ingresso ci saranno quindici cubiti di cortine, con tre colonne e le loro tre basi; ");
INSERT INTO ita1927_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","e dall’altro lato pure ci saranno quindici cubiti di cortine, con tre colonne e le loro tre basi. ");
INSERT INTO ita1927_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Per l’ingresso del cortile ci sarà una portiera di venti cubiti, di filo violaceo, porporino, scarlatto, e di lino fino ritorto, in lavoro di ricamo, con quattro colonne e le loro quattro basi. ");
INSERT INTO ita1927_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Tutte le colonne attorno al cortile saran congiunte con delle aste d’argento; i loro chiodi saranno d’argento, e le loro basi di rame. ");
INSERT INTO ita1927_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","La lunghezza del cortile sarà di cento cubiti; la larghezza, di cinquanta da ciascun lato; e l’altezza, di cinque cubiti; le cortine saranno di lino fino ritorto, e le basi delle colonne, di rame. ");
INSERT INTO ita1927_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Tutti gli utensili destinati al servizio del tabernacolo, tutti i suoi piuoli e tutti i piuoli del cortile saranno di rame. ");
INSERT INTO ita1927_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Ordinerai ai figliuoli d’Israele che ti portino dell’olio d’uliva puro, vergine, per il candelabro, per tener le lampade continuamente accese. ");
INSERT INTO ita1927_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Nella tenda di convegno, fuori del velo che sta davanti alla testimonianza, Aaronne e i suoi figliuoli lo prepareranno perché le lampade ardano dalla sera al mattino davanti all’Eterno. Questa sarà una regola perpetua per i loro discendenti, da essere osservata dai figliuoli d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","E tu fa’ accostare a te, di tra i figliuoli d’Israele, Aaronne tuo fratello e i suoi figliuoli con lui perché mi esercitino l’ufficio di sacerdoti: Aaronne, Nadab, Abihu, Eleazar e Ithamar, figliuoli d’Aaronne. ");
INSERT INTO ita1927_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","E farai ad Aaronne, tuo fratello, dei paramenti sacri, come insegne della loro dignità e come ornamento. ");
INSERT INTO ita1927_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Parlerai a tutti gli uomini intelligenti, i quali io ho ripieni di spirito di sapienza, ed essi faranno i paramenti d’Aaronne per consacrarlo, onde mi eserciti l’ufficio di sacerdote. ");
INSERT INTO ita1927_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","E questi sono i paramenti che faranno: un pettorale, un efod, un manto, una tunica lavorata a maglia, una mitra e una cintura. Faranno dunque de’ paramenti sacri per Aaronne tuo fratello e per i suoi figliuoli, affinché mi esercitino l’ufficio di sacerdoti; ");
INSERT INTO ita1927_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","e si serviranno d’oro, di filo violaceo, porporino, scarlatto, e di lino fino. ");
INSERT INTO ita1927_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Faranno l’efod d’oro, di filo violaceo, porporino, scarlatto, e di lino fino ritorto, lavorato artisticamente. ");
INSERT INTO ita1927_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Esso avrà alle due estremità due spallette, che si uniranno, in guisa ch’esso si terra bene insieme. ");
INSERT INTO ita1927_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","E la cintura artistica che è sull’efod per fissarlo, sarà del medesimo lavoro dell’efod, e tutto d’un pezzo con esso; sarà d’oro, di filo color violaceo, porporino, scarlatto, e di lino fino ritorto. ");
INSERT INTO ita1927_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","E prenderai due pietre d’onice e v’inciderai su i nomi dei figliuoli d’Israele: ");
INSERT INTO ita1927_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","sei de’ loro nomi sopra una pietra, e gli altri sei nomi sopra la seconda pietra, secondo il loro ordine di nascita. ");
INSERT INTO ita1927_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Inciderai su queste due pietre i nomi de’ figliuoli d’Israele come fa il lapidario, come s’incide un sigillo; le farai incastrare in castoni d’oro. ");
INSERT INTO ita1927_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Metterai le due pietre sulle spallette dell’efod, come pietre di ricordanza per i figliuoli d’Israele; e Aaronne porterà i loro nomi davanti all’Eterno sulle sue due spalle, per ricordanza. ");
INSERT INTO ita1927_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","E farai de’ castoni d’oro, ");
INSERT INTO ita1927_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","e due catenelle d’oro puro che intreccerai a mo’ di cordone, e metterai ne’ castoni le catenelle così intrecciate. ");
INSERT INTO ita1927_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Farai pure il pettorale del giudizio, artisticamente lavorato; lo farai come il lavoro dell’efod: d’oro, di filo violaceo, porporino, scarlatto, e di lino fino ritorto. ");
INSERT INTO ita1927_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Sarà quadrato e doppio; avrà la lunghezza d’una spanna, e una spanna di larghezza. ");
INSERT INTO ita1927_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","E v’incastonerai un fornimento di pietre: quattro ordini di pietre; nel primo ordine sarà un sardonio, un topazio e uno smeraldo; ");
INSERT INTO ita1927_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","nel secondo ordine, un rubino, uno zaffiro, un calcedonio; ");
INSERT INTO ita1927_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","nel terzo ordine, un’opale, un’agata, un’ametista; ");
INSERT INTO ita1927_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","nel quarto ordine, un grisolito, un onice e un diaspro. Queste pietre saranno incastrate nei loro castoni d’oro. ");
INSERT INTO ita1927_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","E le pietre corrisponderanno ai nomi dei figliuoli d’Israele, e saranno dodici, secondo i loro nomi; saranno incise come de’ sigilli, ciascuna col nome d’una delle tribù d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Farai pure sul pettorale delle catenelle d’oro puro, intrecciate a mo’ di cordoni. ");
INSERT INTO ita1927_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Poi farai sul pettorale due anelli d’oro, e metterai i due anelli alle due estremità del pettorale. ");
INSERT INTO ita1927_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Fisserai i due cordoni d’oro ai due anelli alle estremità del pettorale; ");
INSERT INTO ita1927_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","e attaccherai gli altri due capi dei due cordoni ai due castoni, e li metterai sulle due spallette dell’efod, sul davanti. ");
INSERT INTO ita1927_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","E farai due anelli d’oro, e li metterai alle altre due estremità del pettorale, sull’orlo interiore vòlto verso l’efod. ");
INSERT INTO ita1927_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Farai due altri anelli d’oro, e li metterai alle due spallette dell’efod, in basso, sul davanti, vicino al punto dove avviene la giuntura, al disopra della cintura artistica dell’efod. ");
INSERT INTO ita1927_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","E si fisserà il pettorale mediante i suoi anelli agli anelli dell’efod con un cordone violaceo, affinché il pettorale sia al di sopra della cintura artistica dell’efod, e non si possa staccare dall’efod. ");
INSERT INTO ita1927_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Così Aaronne porterà i nomi de’ figliuoli d’Israele incisi nel pettorale del giudizio, sul suo cuore, quando entrerà nel santuario, per conservarne del continuo la ricordanza dinanzi all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Metterai sul pettorale del giudizio l’Urim e il Thummim; e staranno sul cuore d’Aaronne quand’egli si presenterà davanti all’Eterno. Così Aaronne porterà il giudizio de’ figliuoli d’Israele sul suo cuore, davanti all’Eterno, del continuo. ");
INSERT INTO ita1927_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Farai anche il manto dell’efod, tutto di color violaceo. ");
INSERT INTO ita1927_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Esso avrà, in mezzo, un’apertura per passarvi il capo; e l’apertura avrà all’intorno un’orlatura tessuta, come l’apertura d’una corazza, perché non si strappi. ");
INSERT INTO ita1927_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","All’orlo inferiore del manto, tutt’all’intorno, farai delle melagrane di color violaceo, porporino e scarlatto; e in mezzo ad esse, d’ogn’intorno, porrai de’ sonagli d’oro: ");
INSERT INTO ita1927_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","un sonaglio d’oro e una melagrana, un sonaglio d’oro e una melagrana, sull’orlatura del manto, tutt’all’intorno. ");
INSERT INTO ita1927_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aaronne se lo metterà per fare il servizio; quand’egli entrerà nel luogo santo dinanzi all’Eterno e quando ne uscirà, s’udrà il suono, ed egli non morrà. ");
INSERT INTO ita1927_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Farai anche una lamina d’oro puro, e sovr’essa inciderai, come s’incide sopra un sigillo: SANTO ALL’ETERNO. ");
INSERT INTO ita1927_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","La fisserai ad un nastro violaceo sulla mitra, e starà sul davanti della mitra. ");
INSERT INTO ita1927_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Starà sulla fronte d’Aaronne, e Aaronne porterà le iniquità commesse dai figliuoli d’Israele nelle cose sante che consacreranno, in ogni genere di sante offerte; ed essa starà continuamente sulla fronte di lui, per renderli graditi nel cospetto dell’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Farai pure la tunica di lino fino, lavorata a maglia; farai una mitra di lino fino, e farai una cintura in lavoro di ricamo. ");
INSERT INTO ita1927_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","E per i figliuoli d’Aaronne farai delle tuniche, farai delle cinture, e farai delle tiare, come insegne della loro dignità e come ornamento. ");
INSERT INTO ita1927_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","E ne vestirai Aaronne, tuo fratello, e i suoi figliuoli con lui; e li ungerai, li consacrerai e li santificherai perché mi esercitino l’ufficio di sacerdoti. ");
INSERT INTO ita1927_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Farai anche loro delle brache di lino per coprire la loro nudità; esse andranno dai fianchi fino alle cosce. ");
INSERT INTO ita1927_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aaronne e i suoi figliuoli le porteranno quando entreranno nella tenda di convegno, o quando s’accosteranno all’altare per fare il servizio nel luogo santo, affinché non si rendano colpevoli e non muoiano. Questa è una regola perpetua per lui e per la sua progenie dopo di lui. ");
INSERT INTO ita1927_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Questo è quello che farai per consacrarli perché mi esercitino l’ufficio di sacerdoti. ");
INSERT INTO ita1927_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Prendi un giovenco e due montoni senza difetto, de’ pani senza lievito, delle focacce senza lievito impastate con olio, e delle gallette senza lievito unte d’olio; tutte queste cose farai di fior di farina di grano. ");
INSERT INTO ita1927_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Le metterai in un paniere, e le offrirai nel paniere al tempo stesso del giovenco e de’ due montoni. ");
INSERT INTO ita1927_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Farai avvicinare Aaronne e i suoi figliuoli all’ingresso della tenda di convegno, e li laverai con acqua. ");
INSERT INTO ita1927_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Poi prenderai i paramenti, e vestirai Aaronne della tunica, del manto dell’efod, dell’efod e del pettorale, e lo cingerai della cintura artistica dell’efod. ");
INSERT INTO ita1927_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Gli porrai in capo la mitra, e metterai sulla mitra il santo diadema. ");
INSERT INTO ita1927_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Poi prenderai l’olio dell’unzione, glielo spanderai sul capo, e l’ungerai. ");
INSERT INTO ita1927_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Farai quindi accostare i suoi figliuoli, e li vestirai delle tuniche. ");
INSERT INTO ita1927_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Cingerai Aaronne e i suoi figliuoli con delle cinture, e assicurerai sul loro capo delle tiare; e il sacerdozio apparterrà loro per legge perpetua. Così consacrerai Aaronne e i suoi figliuoli. ");
INSERT INTO ita1927_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Poi farai accostare il giovenco davanti alla tenda di convegno; e Aaronne e i suoi figliuoli poseranno le mani sul capo del giovenco. ");
INSERT INTO ita1927_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","E scannerai il giovenco davanti all’Eterno, all’ingresso della tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","E prenderai del sangue del giovenco, e ne metterai col dito sui corni dell’altare, e spanderai tutto il sangue appiè dell’altare. ");
INSERT INTO ita1927_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Prenderai pure tutto il grasso che copre le interiora, la rete ch’è sopra il fegato, i due arnioni e il grasso che v’è sopra, e farai fumar tutto sull’altare. ");
INSERT INTO ita1927_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Ma la carne del giovenco, la sua pelle e i suoi escrementi li brucerai col fuoco fuori del campo: è un sacrifizio per il peccato. ");
INSERT INTO ita1927_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Poi prenderai uno de’ montoni; e Aaronne e i suoi figliuoli poseranno le loro mani sul capo del montone. ");
INSERT INTO ita1927_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","E scannerai il montone, ne prenderai il sangue, e lo spanderai sull’altare, tutto all’intorno. ");
INSERT INTO ita1927_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Poi farai a pezzi il montone, laverai le sue interiora e le sue gambe, e le metterai sui pezzi e sulla sua testa. ");
INSERT INTO ita1927_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","E farai fumare tutto il montone sull’altare: è un olocausto all’Eterno; è un sacrifizio di soave odore fatto mediante il fuoco all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Poi prenderai l’altro montone, e Aaronne e i suoi figliuoli poseranno le loro mani sul capo dei montone. ");
INSERT INTO ita1927_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Scannerai il montone, prenderai del suo sangue e lo metterai sull’estremità dell’orecchio destro d’Aaronne e sull’estremità dell’orecchio destro de’ suoi figliuoli, e sul pollice della loro man destra e sul dito grosso del loro piè destro, e spanderai il sangue sull’altare, tutto all’intorno. ");
INSERT INTO ita1927_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","E prenderai del sangue che è sull’altare, e dell’olio dell’unzione, e ne aspergerai Aaronne e i suoi paramenti, e i suoi figliuoli e i paramenti de’ suoi figliuoli con lui. Così saranno consacrati lui, i suoi paramenti, i suoi figliuoli e i loro paramenti con lui. ");
INSERT INTO ita1927_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Prenderai pure il grasso dei montone, la coda, il grasso che copre le interiora, la rete del fegato, i due arnioni e il grasso che v’è sopra e la coscia destra, perché è un montone di consacrazione; ");
INSERT INTO ita1927_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","prenderai anche un pane, una focaccia oliata e una galletta dal paniere degli azzimi che è davanti all’Eterno; ");
INSERT INTO ita1927_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","e porrai tutte queste cose sulle palme delle mani Aaronne e sulle palme delle mani de’ suoi figliuoli, e le agiterai come offerta agitata davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Poi le prenderai dalle loro mani e le farai fumare sull’altare sopra l’olocausto, come un profumo soave davanti all’Eterno; è un sacrifizio fatto mediante il fuoco all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","E prenderai il petto del montone che avrà servito alla consacrazione d’Aaronne, e lo agiterai come offerta agitata davanti all’Eterno; e questa sarà la tua parte. ");
INSERT INTO ita1927_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","E consacrerai, di ciò che spetta ad Aaronne e ai suoi figliuoli, il petto dell’offerta agitata e la coscia dell’offerta elevata: vale a dire, ciò che del montone della consacrazione sarà stato agitato ed elevato; ");
INSERT INTO ita1927_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","esso apparterrà ad Aaronne e ai suoi figliuoli, per legge perpetua da osservarsi dai figliuoli d’Israele; poiché è un’offerta fatta per elevazione. Sarà un’offerta fatta per elevazione dai figliuoli d’Israele nei loro sacrifizi di azioni di grazie: la loro offerta per elevazione sarà per l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","E i paramenti sacri di Aaronne saranno, dopo di lui, per i suoi figliuoli, che se li metteranno all’atto della loro unzione e della loro consacrazione. ");
INSERT INTO ita1927_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Quello de’ suoi figliuoli che gli succederà nel sacerdozio, li indosserà per sette giorni quando entrerà nella tenda di convegno per fare il servizio nel luogo santo. ");
INSERT INTO ita1927_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Poi prenderai il montone della consacrazione, e ne farai cuocere la carne in un luogo santo; ");
INSERT INTO ita1927_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","e Aaronne e i suoi figliuoli mangeranno, all’ingresso della tenda di convegno, la carne del montone e il pane che sarà nel paniere. ");
INSERT INTO ita1927_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Mangeranno le cose che avranno servito a fare l’espiazione per consacrarli e santificarli; ma nessun estraneo ne mangerà, perché son cose sante. ");
INSERT INTO ita1927_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","E se rimarrà della carne della consacrazione o del pane fino alla mattina dopo, brucerai quel resto col fuoco; non lo si mangerà, perché è cosa santa. ");
INSERT INTO ita1927_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Eseguirai dunque, riguardo ad Aaronne e ai suoi figliuoli, tutto quello che ti ho ordinato: li consacrerai durante sette giorni. ");
INSERT INTO ita1927_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","E ogni giorno offrirai un giovenco, come sacrifizio per il peccato, per fare l’espiazione; purificherai l’altare mediante questa tua espiazione, e l’ungerai per consacrarlo. ");
INSERT INTO ita1927_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Per sette giorni farai l’espiazione dell’altare, e lo santificherai; l’altare sarà santissimo: tutto ciò che toccherà l’altare sarà santo. ");
INSERT INTO ita1927_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Or questo è ciò che offrirai sull’altare: due agnelli d’un anno, ogni giorno, del continuo. ");
INSERT INTO ita1927_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Uno degli agnelli l’offrirai la mattina; e l’altro l’offrirai sull’imbrunire. ");
INSERT INTO ita1927_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Col primo agnello offrirai la decima parte di un efa di fior di farina impastata con la quarta parte di un hin d’olio vergine, e una libazione di un quarto di hin di vino. ");
INSERT INTO ita1927_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Il secondo agnello l’offrirai sull’imbrunire; l’accompagnerai con la stessa oblazione e con la stessa libazione della mattina; è un sacrifizio di profumo soave offerto mediante il fuoco all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Sarà un olocausto perpetuo offerto dai vostri discendenti, all’ingresso della tenda di convegno, davanti all’Eterno, dove io v’incontrerò per parlar quivi con te. ");
INSERT INTO ita1927_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","E là io mi troverò coi figliuoli d’Israele; e la tenda sarà santificata dalla mia gloria. ");
INSERT INTO ita1927_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","E santificherò la tenda di convegno e l’altare; anche Aaronne e i suoi figliuoli santificherò, perché mi esercitino l’ufficio di sacerdoti. ");
INSERT INTO ita1927_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","E dimorerò in mezzo ai figliuoli d’Israele e sarò il loro Dio. ");
INSERT INTO ita1927_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Ed essi conosceranno che io sono l’Eterno, l’Iddio loro, che li ho tratti dal paese d’Egitto per dimorare tra loro. Io sono l’Eterno, l’Iddio loro. ");
INSERT INTO ita1927_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Farai pure un altare per bruciarvi su il profumo: lo farai di legno d’acacia. ");
INSERT INTO ita1927_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","La sua lunghezza sarà di un cubito; e la sua larghezza, di un cubito; sarà quadro, e avrà un’altezza di due cubiti; i suoi corni saranno tutti d’un pezzo con esso. ");
INSERT INTO ita1927_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Lo rivestirai d’oro puro: il disopra, i suoi lati tutt’intorno, i suoi corni; e gli farai una ghirlanda d’oro che gli giri attorno. ");
INSERT INTO ita1927_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","E gli farai due anelli d’oro, sotto la ghirlanda, ai suoi due lati; li metterai ai suoi due lati, per passarvi le stanghe che serviranno a portarlo. ");
INSERT INTO ita1927_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Farai le stanghe di legno d’acacia, e le rivestirai d’oro. ");
INSERT INTO ita1927_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","E collocherai l’altare davanti al velo ch’è dinanzi all’arca della testimonianza, di faccia al propiziatorio che sta sopra la testimonianza, dove io mi ritroverò con te. ");
INSERT INTO ita1927_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","E Aaronne vi brucerà su del profumo fragrante; lo brucerà ogni mattina, quando acconcerà le lampade; ");
INSERT INTO ita1927_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","e quando Aaronne accenderà le lampade sull’imbrunire, lo farà bruciare come un profumo perpetuo davanti all’Eterno, di generazione in generazione. ");
INSERT INTO ita1927_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Non offrirete sovr’esso né profumo straniero, né olocausto, né oblazione; e non vi farete libazioni. ");
INSERT INTO ita1927_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","E Aaronne farà una volta all’anno l’espiazione sui corni d’esso; col sangue del sacrifizio d’espiazione per il peccato vi farà l’espiazione una volta l’anno, di generazione in generazione. Sarà cosa santissima, sacra all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Quando farai il conto de’ figliuoli d’Israele, facendo il censimento, ognun d’essi darà all’Eterno il riscatto della propria persona, quando saranno contati; onde non siano colpiti da qualche piaga, allorché farai il loro censimento. ");
INSERT INTO ita1927_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Daranno questo: chiunque sarà compreso nel censimento darà un mezzo siclo, secondo il siclo del santuario, che è di venti ghere: un mezzo siclo sarà l’offerta da fare all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Ognuno che sarà compreso nel censimento, dai venti anni in su, darà quest’offerta all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Il ricco non darà di più, né il povero darà meno del mezzo siclo, quando si farà quest’offerta all’Eterno per il riscatto delle vostre persone. ");
INSERT INTO ita1927_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Prenderai dunque dai figliuoli d’Israele questo danaro del riscatto e lo adoprerai per il servizio della tenda di convegno: sarà per i figliuoli d’Israele una ricordanza dinanzi all’Eterno per fare il riscatto delle vostre persone”. ");
INSERT INTO ita1927_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Farai pure una conca di rame, con la sua base di rame, per le abluzioni; la porrai fra la tenda di convegno e l’altare, e ci metterai dell’acqua. ");
INSERT INTO ita1927_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","E Aaronne e i suoi figliuoli vi si laveranno le mani e i piedi. ");
INSERT INTO ita1927_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Quando entreranno nella tenda di convegno, si laveranno con acqua, onde non abbiano a morire; così pure quando si accosteranno all’altare per fare il servizio, per far fumare un’offerta fatta all’Eterno mediante il fuoco. ");
INSERT INTO ita1927_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Si laveranno le mani e i piedi, onde non abbiano a morire. Questa sarà una norma perpetua per loro, per Aaronne e per la sua progenie, di generazione in generazione”. ");
INSERT INTO ita1927_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Prenditi anche de’ migliori aromi: di mirra vergine, cinquecento sicli; di cinnamomo aromatico, la metà, cioè duecentocinquanta; di canna aromatica, pure duecentocinquanta; ");
INSERT INTO ita1927_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","di cassia, cinquecento, secondo il siclo del santuario; e un hin d’olio d’oliva. ");
INSERT INTO ita1927_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","E ne farai un olio per l’unzione sacra, un profumo composto con arte di profumiere: sarà l’olio per l’unzione sacra. ");
INSERT INTO ita1927_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","E con esso ungerai la tenda di convegno e l’arca della testimonianza, ");
INSERT INTO ita1927_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","la tavola e tutti i suoi utensili, il candelabro e i suoi utensili, l’altare dei profumi, ");
INSERT INTO ita1927_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","l’altare degli olocausti e tutti i suoi utensili, la conca e la sua base. ");
INSERT INTO ita1927_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Consacrerai così queste cose, e saranno santissime; tutto quello che le toccherà, sarà santo. ");
INSERT INTO ita1927_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","E ungerai Aaronne e i suoi figliuoli, e li consacrerai perché mi esercitino l’ufficio di sacerdoti. ");
INSERT INTO ita1927_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","E parlerai ai figliuoli d’Israele, dicendo: Quest’olio mi sarà un olio di sacra unzione, di generazione in generazione. ");
INSERT INTO ita1927_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Non lo si spanderà su carne d’uomo, e non ne farete altro di simile, della stessa composizione; esso è cosa santa, e sarà per voi cosa santa. ");
INSERT INTO ita1927_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Chiunque ne comporrà di simile, o chiunque ne metterà sopra un estraneo, sarà sterminato di fra il suo popolo”. ");
INSERT INTO ita1927_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","L’Eterno disse ancora a Mosè: “Prenditi degli aromi, della resina, della conchiglia odorosa, del galbano, degli aromi con incenso puro, in dosi uguali; ");
INSERT INTO ita1927_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","e ne farai un profumo composto secondo l’arte del profumiere, salato, puro, santo; ");
INSERT INTO ita1927_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","ne ridurrai una parte in minutissima polvere, e ne porrai davanti alla testimonianza nella tenda di convegno, dove io m’incontrerò con te: esso vi sarà cosa santissima. ");
INSERT INTO ita1927_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","E del profumo che farai, non ne farete della stessa composizione per uso vostro; ti sarà cosa santa, consacrata all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Chiunque ne farà di simile per odorarlo, sarà sterminato di fra il suo popolo”. ");
INSERT INTO ita1927_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","L’Eterno parlò ancora a Mosè, dicendo: “Vedi, io ho chiamato per nome Betsaleel, ");
INSERT INTO ita1927_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","figliuolo di Uri, figliuolo di Hur, della tribù di Giuda; ");
INSERT INTO ita1927_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","e l’ho ripieno dello spirito di Dio, di abilità, d’intelligenza e di sapere per ogni sorta di lavori, ");
INSERT INTO ita1927_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","per concepire opere d’arte, per lavorar l’oro, l’argento e il rame, ");
INSERT INTO ita1927_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","per incidere pietre da incastonare, per scolpire il legno, per eseguire ogni sorta di lavori. ");
INSERT INTO ita1927_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ed ecco, gli ho dato per compagno Oholiab, figliuolo di Ahisamac, della tribù di Dan; e ho messo sapienza nella mente di tutti gli uomini abili, perché possan fare tutto quello che t’ho ordinato: ");
INSERT INTO ita1927_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","la tenda di convegno, l’arca per la testimonianza, il propiziatorio che vi dovrà esser sopra, e tutti gli arredi della tenda; la tavola e i suoi utensili, ");
INSERT INTO ita1927_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","il candelabro d’oro puro e tutti i suoi utensili, ");
INSERT INTO ita1927_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","l’altare dei profumi, l’altare degli olocausti e tutti i suoi utensili, la conca e la sua base, ");
INSERT INTO ita1927_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","i paramenti per le cerimonie, i paramenti sacri per il sacerdote Aaronne e i paramenti dei suoi figliuoli per esercitare il sacerdozio, ");
INSERT INTO ita1927_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","l’olio dell’unzione e il profumo fragrante per il luogo santo. Faranno tutto conformemente a quello che ho ordinato”. ");
INSERT INTO ita1927_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Quanto a te, parla ai figliuoli d’Israele e di’ loro: Badate bene d’osservare i miei sabati, perché il sabato è un segno fra me e voi per tutte le vostre generazioni, affinché conosciate che io sono l’Eterno che vi santifica. ");
INSERT INTO ita1927_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Osserverete dunque il sabato, perché è per voi un giorno santo; chi lo profanerà dovrà esser messo a morte; chiunque farà in esso qualche lavoro sarà sterminato di fra il suo popolo. ");
INSERT INTO ita1927_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Si lavorerà sei giorni; ma il settimo giorno è un sabato di solenne riposo, sacro all’Eterno; chiunque farà qualche lavoro nel giorno del sabato dovrà esser messo a morte. ");
INSERT INTO ita1927_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","I figliuoli d’Israele quindi osserveranno il sabato, celebrandolo di generazione in generazione come un patto perpetuo. ");
INSERT INTO ita1927_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Esso è un segno perpetuo fra me e i figliuoli d’Israele; poiché in sei giorni l’Eterno fece i cieli e la terra, e il settimo giorno cessò di lavorare, e si riposò”. ");
INSERT INTO ita1927_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Quando l’Eterno ebbe finito di parlare con Mosè sul monte Sinai, gli dette le due tavole della testimonianza, tavole di pietra, scritte col dito di Dio. ");
INSERT INTO ita1927_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Or il popolo, vedendo che Mosè tardava a scender dal monte, si radunò intorno ad Aaronne e gli disse: “Orsù, facci un dio, che ci vada dinanzi; poiché, quanto a Mosè, a quest’uomo che ci ha tratto dal paese d’Egitto, non sappiamo che ne sia stato”. ");
INSERT INTO ita1927_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","E Aaronne rispose loro: “Staccate gli anelli d’oro che sono agli orecchi delle vostre mogli, dei vostri figliuoli e delle vostre figliuole, e portatemeli”. ");
INSERT INTO ita1927_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","E tutto il popolo si staccò dagli orecchi gli anelli d’oro e li portò ad Aaronne, ");
INSERT INTO ita1927_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","il quale li prese dalle loro mani, e, dopo averne cesellato il modello, ne fece un vitello di getto. E quelli dissero: “O Israele, questo è il tuo dio che ti ha tratto dal paese d’Egitto!” ");
INSERT INTO ita1927_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Quando Aaronne vide questo, eresse un altare davanti ad esso, e fece un bando che diceva: “Domani sarà festa in onore dell’Eterno!” ");
INSERT INTO ita1927_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","E l’indomani, quelli si levarono di buon’ora, offrirono olocausti e recarono de’ sacrifizi di azioni di grazie; e il popolo si adagiò per mangiare e bere, e poi si alzò per divertirsi. ");
INSERT INTO ita1927_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","E l’Eterno disse a Mosè: “Va’, scendi; perché il tuo popolo che hai tratto dal paese d’Egitto, s’è corrotto; ");
INSERT INTO ita1927_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","si son presto sviati dalla strada ch’io avevo loro ordinato di seguire; si son fatti un vitello di getto, l’hanno adorato, gli hanno offerto sacrifizi, e hanno detto: O Israele, questo è il tuo dio che ti ha tratto dal paese d’Egitto”. ");
INSERT INTO ita1927_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","L’Eterno disse ancora a Mosè: “Ho considerato bene questo popolo; ecco, è un popolo di collo duro. ");
INSERT INTO ita1927_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Or dunque, lascia che la mia ira s’infiammi contro a loro, e ch’io li consumi! ma di te io farò una grande nazione”. ");
INSERT INTO ita1927_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Allora Mosè supplicò l’Eterno, il suo Dio, e disse: “Perché, o Eterno, l’ira tua s’infiammerebbe contro il tuo popolo che hai tratto dal paese d’Egitto con gran potenza e con mano forte? ");
INSERT INTO ita1927_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Perché direbbero gli Egiziani: Egli li ha tratti fuori per far loro del male, per ucciderli su per le montagne e per sterminarli di sulla faccia della terra? Calma l’ardore della tua ira e pèntiti del male di cui minacci il tuo popolo. ");
INSERT INTO ita1927_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Ricordati d’Abrahamo, d’Isacco e d’Israele, tuoi servi, ai quali giurasti per te stesso, dicendo loro: Io moltiplicherò la vostra progenie come le stelle de’ cieli; darò alla vostra progenie tutto questo paese di cui vi ho parlato, ed essa lo possederà in perpetuo”. ");
INSERT INTO ita1927_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","E l’Eterno si pentì del male che avea detto di fare al suo popolo. ");
INSERT INTO ita1927_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Allora Mosè si voltò e scese dal monte con le due tavole della testimonianza nelle mani: tavole scritte d’ambo i lati, di qua e di là. ");
INSERT INTO ita1927_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Le tavole erano opera di Dio, e la scrittura era scrittura di Dio, incisa sulle tavole. ");
INSERT INTO ita1927_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Or Giosuè, udendo il clamore del popolo che gridava, disse a Mosè: “S’ode un fragore di battaglia nel campo”. ");
INSERT INTO ita1927_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","E Mosè rispose: “Questo non è né grido di vittoria, né grido di vinti; il clamore ch’io odo e di gente che canta”. ");
INSERT INTO ita1927_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","E come fu vicino al campo vide il vitello e le danze; e l’ira di Mosè s’infiammò, ed egli gettò dalle mani le tavole e le spezzò appiè del monte. ");
INSERT INTO ita1927_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Poi prese il vitello che quelli avea fatto, lo bruciò col fuoco, lo ridusse in polvere, sparse la polvere sull’acqua, la fece bere ai figliuoli d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","E Mosè disse ad Aaronne: “Che t’ha fatto questo popolo, che gli hai tirato addosso un sì gran peccato?” ");
INSERT INTO ita1927_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaronne rispose: “L’ira del mio signore non s’infiammi; tu conosci questo popolo, e sai ch’è inclinato al male. ");
INSERT INTO ita1927_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Essi m’hanno detto: Facci un di che ci vada dinanzi; poiché, quanto Mosè, a quest’uomo che ci ha tratti dal paese d’Egitto, non sappiamo che ne sia stato. ");
INSERT INTO ita1927_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","E io ho detto loro: Chi ha dell’oro se lo levi di dosso! Essi me l’hanno dato; io l’ho buttato nel fuoco, e n’è venuto fuori questo vitello”. ");
INSERT INTO ita1927_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Quando Mosè vide che il popolo era senza freno e che Aaronne lo avea lasciato sfrenarsi esponendolo all’obbrobrio de’ suoi nemici, ");
INSERT INTO ita1927_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","si fermò all’ingresso del campo, e disse: “Chiunque è per l’Eterno, venga a me!” E tutti i figliuoli di Levi si radunarono presso a lui. ");
INSERT INTO ita1927_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ed egli disse loro: “Così dice l’Eterno, l’Iddio d’Israele: Ognun di voi si metta la spada al fianco; passate e ripassate nel campo, da una porta all’altra d’esso, e ciascuno uccida il fratello, ciascuno l’amico, ciascuno il vicino!” ");
INSERT INTO ita1927_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","I figliuoli di Levi eseguirono l’ordine di Mosè e in quel giorno caddero circa tremila uomini. ");
INSERT INTO ita1927_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Or Mosè avea detto: “Consacratevi oggi all’Eterno, anzi ciascuno si consacri a prezzo del proprio figliuolo e del proprio fratello, onde l’Eterno v’impartisca una benedizione”. ");
INSERT INTO ita1927_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","L’indomani Mosè disse al popolo: “Voi avete commesso un gran peccato; ma ora io salirò all’Eterno; forse otterrò che il vostro peccato vi sia perdonato”. ");
INSERT INTO ita1927_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Mosè dunque tornò all’Eterno e disse: “Ahimè, questo popolo ha commesso un gran peccato, e s’è fatto un dio d’oro; ");
INSERT INTO ita1927_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","nondimeno, perdona ora il loro peccato! Se no, deh, cancellami dal tuo libro che hai scritto!” ");
INSERT INTO ita1927_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","E l’Eterno rispose a Mosè: “Colui che ha peccato contro di me, quello cancellerò dal mio libro! ");
INSERT INTO ita1927_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Or va’, conduci il popolo dove t’ho detto. Ecco, il mio angelo andrà dinanzi a te; ma nel giorno che verrò a punire, io li punirò del loro peccato”. ");
INSERT INTO ita1927_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","E l’Eterno percosse il popolo, perch’esso era l’autore del vitello che Aaronne avea fatto. ");
INSERT INTO ita1927_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","L’Eterno disse a Mosè: “Va’ sali di qui, tu col popolo che hai tratto dal paese d’Egitto, verso il paese che promisi con giuramento ad Abrahamo ad Isacco e a Giacobbe, dicendo: Io lo darò alla tua progenie. ");
INSERT INTO ita1927_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Io manderò un angelo dinanzi a te, e caccerò i Cananei, gli Amorei, gli Hittei, i Ferezei, gli Hivvei e i Gebusei. ");
INSERT INTO ita1927_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Esso vi condurrà in un paese ove scorre il latte e il miele; poiché io non salirò in mezzo a te, perché sei un popolo di collo duro, ond’io non abbia a sterminarti per via”. ");
INSERT INTO ita1927_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Quando il popolo udì queste sinistre parole, fece cordoglio, e nessuno si mise i propri ornamenti. ");
INSERT INTO ita1927_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Infatti l’Eterno avea detto a Mosè: “Di’ ai figliuoli d’Israele: Voi siete un popolo di collo duro; s’io salissi per un momento solo in mezzo a te, ti consumerei! Or dunque, togliti i tuoi ornamenti, e vedrò com’io ti debba trattare”. ");
INSERT INTO ita1927_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","E i figliuoli d’Israele si spogliarono de’ loro ornamenti, dalla partenza dal monte Horeb in poi. ");
INSERT INTO ita1927_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","E Mosè prese la tenda, e la piantò per sé fuori del campo, a una certa distanza dal campo, e la chiamò la tenda di convegno; e chiunque cercava l’Eterno, usciva verso la tenda di convegno, ch’era fuori del campo. ");
INSERT INTO ita1927_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Quando Mosè usciva per recarsi alla tenda, tutto il popolo si alzava, e ognuno se ne stava ritto all’ingresso della propria tenda, e seguiva con lo sguardo Mosè, finché egli fosse entrato nella tenda. ");
INSERT INTO ita1927_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","E come Mosè era entrato nella tenda, la colonna di nuvola scendeva, si fermava all’ingresso della tenda, e l’Eterno parlava con Mosè. ");
INSERT INTO ita1927_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Tutto il popolo vedeva la colonna di nuvola ferma all’ingresso della tenda; e tutto il popolo si alzava, e ciascuno si prostrava all’ingresso della propria tenda. ");
INSERT INTO ita1927_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Or l’Eterno parlava con Mosè faccia a faccia, come un uomo parla col proprio amico; poi Mosè tornava al campo; ma Giosuè, figliuolo di Nun, suo giovane ministro, non si dipartiva dalla tenda. ");
INSERT INTO ita1927_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","E Mosè disse all’Eterno: “Vedi, tu mi dici: Fa’ salire questo popolo! e non mi fai conoscere chi manderai meco. Eppure hai detto: Io ti conosco personalmente ed anche hai trovato grazia agli occhi miei. ");
INSERT INTO ita1927_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Or dunque, se ho trovato grazia agli occhi tuoi, deh, fammi conoscere le tue vie, ond’io ti conosca e possa trovar grazia agli occhi tuoi. E considera che questa nazione è popolo tuo”. ");
INSERT INTO ita1927_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","E l’Eterno rispose: “La mia presenza andrà teco, e io ti darò riposo”. ");
INSERT INTO ita1927_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","E Mosè gli disse: “Se la tua presenza non vien meco, non ci far partire di qui. ");
INSERT INTO ita1927_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Poiché, come si farà ora a conoscere che io e il tuo popolo abbiam trovato grazia agli occhi tuoi? Non sarà egli dal fatto che tu vieni con noi? Questo distinguerà me e il tuo popolo da tutti i popoli che sono sulla faccia della terra”. ");
INSERT INTO ita1927_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","E l’Eterno disse a Mosè: “Farò anche questo che tu chiedi, poiché tu hai trovato grazia agli occhi miei, e ti conosco personalmente”. ");
INSERT INTO ita1927_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Mosè disse: “Deh, fammi vedere la tua gloria!” ");
INSERT INTO ita1927_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","E l’Eterno gli rispose: “Io farò passare davanti a te tutta la mia bontà, e proclamerò il nome dell’Eterno davanti a te; e farò grazia a chi vorrò far grazia, e avrò pietà di chi vorrò aver pietà”. ");
INSERT INTO ita1927_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Disse ancora: “Tu non puoi veder la mia faccia, perché l’uomo non mi può vedere e vivere”. ");
INSERT INTO ita1927_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","E l’Eterno disse: “Ecco qui un luogo presso a me; tu starai su quel masso; ");
INSERT INTO ita1927_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","e mentre passerà la mia gloria, io ti metterò in una buca del masso, e ti coprirò con la mia mano, finché io sia passato; ");
INSERT INTO ita1927_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","poi ritirerò la mano, e mi vedrai per di dietro; ma la mia faccia non si può vedere”. ");
INSERT INTO ita1927_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","L’Eterno disse a Mosè: “Tagliati due tavole di pietra come le prime; e io scriverò sulle tavole le parole che erano sulle prime che spezzasti. ");
INSERT INTO ita1927_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","E sii pronto domattina, e sali al mattino sul monte Sinai, e presentati quivi a me in vetta al monte. ");
INSERT INTO ita1927_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Nessuno salga con te, e non si vegga alcuno per tutto il monte; e greggi ed armenti non pascolino nei pressi di questo monte”. ");
INSERT INTO ita1927_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Mosè dunque tagliò due tavole di pietra, come le prime; si alzò la mattina di buon’ora, e salì sul monte Sinai come l’Eterno gli avea comandato, e prese in mano le due tavole di pietra. ");
INSERT INTO ita1927_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","E l’Eterno discese nella nuvola, si fermò quivi con lui e proclamò il nome dell’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","E l’Eterno passò davanti a lui, e gridò: “L’Eterno! l’Eterno! l’Iddio misericordioso e pietoso, lento all’ira, ricco in benignità e fedeltà, ");
INSERT INTO ita1927_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","che conserva la sua benignità fino alla millesima generazione, che perdona l’iniquità, la trasgressione e il peccato ma non terrà il colpevole per innocente, e che punisce l’iniquità dei padri sopra i figliuoli e sopra i figliuoli de’ figliuoli, fino alla terza e alla quarta generazione!” ");
INSERT INTO ita1927_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","E Mosè subito s’inchinò fino a terra, e adorò. ");
INSERT INTO ita1927_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Poi disse: “Deh, Signore, se ho trovato grazia agli occhi tuoi, venga il Signore in mezzo a noi, perché questo è un popolo di collo duro; perdona la nostra iniquità e il nostro peccato, e prendici come tuo possesso”. ");
INSERT INTO ita1927_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","E l’Eterno risposo: “Ecco, io faccio un patto: farò dinanzi a tutto il tuo popolo maraviglie, quali non si son mai fatte su tutta la terra né in alcuna nazione; e tutto il popolo in mezzo al quale ti trovi vedrà l’opera dell’Eterno, perché tremendo è quello ch’io sono per fare per mezzo di te. ");
INSERT INTO ita1927_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Osserva quello che oggi ti comando: Ecco, io caccerò dinanzi a te gli Amorei, i Cananei, gli Hittei, i Ferezei, gli Hivvei e i Gebusei. ");
INSERT INTO ita1927_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Guardati dal far lega con gli abitanti del paese nel quale stai per andare, onde non abbiano a diventare, in mezzo a te, un laccio; ");
INSERT INTO ita1927_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","ma demolite i loro altari, frantumate le loro colonne, abbattete i loro idoli; ");
INSERT INTO ita1927_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","poiché tu non adorerai altro dio, perché l’Eterno, che si chiama “il Geloso”, è un Dio geloso. ");
INSERT INTO ita1927_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Guardati dal far lega con gli abitanti del paese, affinché, quando quelli si prostituiranno ai loro dèi e offriranno sacrifizi ai loro dèi, non avvenga ch’essi t’invitino, e tu mangi dei loro sacrifizi, ");
INSERT INTO ita1927_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","e prenda delle loro figliuole per i tuoi figliuoli, e le loro figliuole si prostituiscano ai loro dèi, e inducano i tuoi figliuoli a prostituirsi ai loro dèi. ");
INSERT INTO ita1927_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Non ti farai dèi di getto. ");
INSERT INTO ita1927_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Osserverai la festa degli azzimi. Sette giorni, al tempo fissato del mese di Abib, mangerai pane senza lievito, come t’ho ordinato; poiché nel mese di Abib tu sei uscito dall’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Ogni primogenito è mio; e mio è ogni primo parto maschio di tutto il tuo bestiame: del bestiame grosso e minuto. ");
INSERT INTO ita1927_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Ma riscatterai con un agnello il primo nato dell’asino; e, se non lo vorrai riscattare, gli fiaccherai il collo. Riscatterai ogni primogenito de’ tuoi figliuoli. E nessuno comparirà davanti a me a mani vuote. ");
INSERT INTO ita1927_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Lavorerai sei giorni; ma il settimo giorno ti riposerai: ti riposerai anche al tempo dell’aratura e della mietitura. ");
INSERT INTO ita1927_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Celebrerai la festa delle settimane: cioè delle primizie della mietitura del frumento, e la festa della raccolta alla fine dell’anno. ");
INSERT INTO ita1927_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Tre volte all’anno comparirà ogni vostro maschio nel cospetto del Signore, dell’Eterno, ch’è l’Iddio d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Poiché io caccerò dinanzi a te delle nazioni, e allargherò i tuoi confini; né alcuno agognerà il tuo paese, quando salirai, tre volte all’anno, per comparire nel cospetto dell’Eterno, ch’è l’Iddio tuo. ");
INSERT INTO ita1927_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Non offrirai con pane lievitato il sangue della vittima immolata a me; e il sacrifizio della festa di Pasqua non sarà serbato fino al mattino. ");
INSERT INTO ita1927_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Porterai alla casa dell’Eterno Iddio tuo le primizie de’ primi frutti della tua terra. Non cuocerai il capretto nel latte di sua madre”. ");
INSERT INTO ita1927_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Poi l’Eterno disse a Mosè: “Scrivi queste parole; perché sul fondamento di queste parole io ho contratto alleanza con te e con Israele”. ");
INSERT INTO ita1927_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","E Mosè rimase quivi con l’Eterno quaranta giorni e quaranta notti; non mangiò pane e non bevve acqua. E l’Eterno scrisse sulle tavole le parole del patto, le dieci parole. ");
INSERT INTO ita1927_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Or Mosè, quando scese dal monte Sinai scendendo dal monte Mosè aveva in mano le due tavole della testimonianza non sapeva che la pelle del suo viso era diventata tutta raggiante mentr’egli parlava con l’Eterno; ");
INSERT INTO ita1927_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","e quando Aaronne e tutti i figliuoli d’Israele videro Mosè, ecco che la pelle del suo viso era tutta raggiante, ed essi temettero d’accostarsi a lui. ");
INSERT INTO ita1927_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ma Mosè li chiamò, ed Aaronne e tutti i capi della raunanza tornarono a lui, e Mosè parlò loro. ");
INSERT INTO ita1927_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Dopo questo, tutti i figliuoli d’Israele si accostarono, ed egli ordinò loro tutto quello che l’Eterno gli avea detto sul monte Sinai. ");
INSERT INTO ita1927_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","E quando Mosè ebbe finito di parlar con loro, si mise un velo sulla faccia. ");
INSERT INTO ita1927_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ma quando Mosè entrava al cospetto dell’Eterno per parlare con lui, si toglieva il velo, finché non tornasse fuori; tornava fuori, e diceva ai figliuoli d’Israele quello che gli era stato comandato. ");
INSERT INTO ita1927_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","I figliuoli d’Israele, guardando la faccia di Mosè, ne vedeano la pelle tutta raggiante; e Mosè si rimetteva il velo sulla faccia, finché non entrasse a parlare con l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mosè convocò tutta la raunanza de’ figliuoli d’Israele, e disse loro: “Queste son le cose che l’Eterno ha ordinato di fare. ");
INSERT INTO ita1927_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Sei giorni si dovrà lavorare, ma il settimo giorno sarà per voi un giorno santo, un sabato di solenne riposo, consacrato all’Eterno. Chiunque farà qualche lavoro in esso sarà messo a morte. ");
INSERT INTO ita1927_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Non accenderete fuoco in alcuna delle vostre abitazioni il giorno del sabato”. ");
INSERT INTO ita1927_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Poi Mosè parlò a tutta la raunanza de’ figliuoli d’Israele, e disse: “Questo è quello che l’Eterno ha ordinato: ");
INSERT INTO ita1927_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Prelevate da quello che avete, un’offerta all’Eterno; chiunque è di cuor volenteroso recherà un’offerta all’Eterno: oro, argento, rame; ");
INSERT INTO ita1927_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","stoffe di color violaceo, porporino, scarlatto, lino fino, pel di capra, ");
INSERT INTO ita1927_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","pelli di montone tinte in rosso, pelli di delfino, legno d’acacia, ");
INSERT INTO ita1927_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","olio per il candelabro, aromi per l’olio dell’unzione e per il profumo fragrante, ");
INSERT INTO ita1927_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","pietre d’onice, pietre da incastonare per l’efod e per il pettorale. ");
INSERT INTO ita1927_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Chiunque tra voi ha dell’abilità venga ed eseguisca tutto quello che l’Eterno ha ordinato: ");
INSERT INTO ita1927_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","il tabernacolo, la sua tenda e la sua coperta, i suoi fermagli, le sue assi, le sue traverse, le sue colonne e le sue basi, ");
INSERT INTO ita1927_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","l’arca, le sue stanghe, il propiziatorio e il velo da stender davanti all’arca, la tavola e le sue stanghe, ");
INSERT INTO ita1927_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","tutti i suoi utensili, e il pane della presentazione; ");
INSERT INTO ita1927_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","il candelabro per la luce e i suoi utensili, le sue lampade e l’olio per il candelabro; ");
INSERT INTO ita1927_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","l’altare dei profumi e le sue stanghe, l’olio dell’unzione e il profumo fragrante, la portiera dell’ingresso per l’entrata del tabernacolo, ");
INSERT INTO ita1927_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","l’altare degli olocausti con la sua gratella di rame, le sue stanghe e tutti i suoi utensili, la conca e la sua base, ");
INSERT INTO ita1927_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","le cortine del cortile, le sue colonne e le loro basi e la portiera all’ingresso del cortile; ");
INSERT INTO ita1927_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","i piuoli del tabernacolo e i piuoli del cortile e le loro funi; ");
INSERT INTO ita1927_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","i paramenti per le cerimonie per fare il servizio nel luogo santo, i paramenti sacri per il sacerdote Aaronne, e i paramenti de’ suoi figliuoli per esercitare il sacerdozio”. ");
INSERT INTO ita1927_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Allora tutta la raunanza de’ figliuoli d’Israele si partì dalla presenza di Mosè. ");
INSERT INTO ita1927_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","E tutti quelli che il loro cuore spingeva e tutti quelli che il loro spirito rendea volenterosi, vennero a portare l’offerta all’Eterno per l’opera della tenda di convegno, per tutto il suo servizio e per i paramenti sacri. ");
INSERT INTO ita1927_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Vennero uomini e donne; quanti erano di cuor volenteroso portarono fermagli, orecchini, anelli da sigillare e braccialetti, ogni sorta di gioielli d’oro; ognuno portò qualche offerta d’oro all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","E chiunque aveva delle stoffe tinte in violaceo, porporino, scarlatto, o lino fino, o pel di capra, o pelli di montone tinte in rosso, o pelli di delfino, portava ogni cosa. ");
INSERT INTO ita1927_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Chiunque prelevò un’offerta d’argento e di rame, portò l’offerta consacrata all’Eterno; e chiunque aveva del legno d’acacia per qualunque lavoro destinato al servizio, lo portò. ");
INSERT INTO ita1927_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","E tutte le donne abili filarono con le proprie mani e portarono i loro filati in color violaceo, porporino, scarlatto, e del lino fino. ");
INSERT INTO ita1927_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","E tutte le donne che il cuore spinse ad usare la loro abilità, filarono del pel di capra. ");
INSERT INTO ita1927_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","E i capi dei popolo portarono pietre d’onice e pietre da incastonare per l’efod e per il pettorale, ");
INSERT INTO ita1927_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","aromi e olio per il candelabro, per l’olio dell’unzione e per il profumo fragrante. ");
INSERT INTO ita1927_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Tutti i figliuoli d’Israele, uomini e donne, che il cuore mosse a portare volenterosamente il necessario per tutta l’opera che l’Eterno aveva ordinata per mezzo di Mosè, recarono all’Eterno delle offerte volontarie. ");
INSERT INTO ita1927_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Mosè disse ai figliuoli d’Israele: “Vedete, l’Eterno ha chiamato per nome Betsaleel, figliuolo di Uri, figliuolo di Hur, della tribù di Giuda; ");
INSERT INTO ita1927_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","e lo ha ripieno dello spirito di Dio, di abilità, d’intelligenza e di sapere per ogni sorta di lavori, ");
INSERT INTO ita1927_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","per concepire opere d’arte, per lavorar l’oro, l’argento e il rame, ");
INSERT INTO ita1927_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","per incidere pietre da incastonare, per scolpire il legno, per eseguire ogni sorta di lavori d’arte. ");
INSERT INTO ita1927_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","E gli ha comunicato il dono d’insegnare: a lui ed a Oholiab, figliuolo di Ahisamac, della tribù di Dan. ");
INSERT INTO ita1927_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Li ha ripieni d’intelligenza per eseguire ogni sorta di lavori d’artigiano e di disegnatore, di ricamatore e di tessitore in colori svariati: violaceo, porporino, scarlatto, e di lino fino, per eseguire qualunque lavoro e per concepire lavori d’arte. ");
INSERT INTO ita1927_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","E Betsaleel e Oholiab e tutti gli uomini abili, nei quali l’Eterno ha messo sapienza e intelligenza per saper eseguire tutti i lavori per il servizio del santuario, faranno ogni cosa secondo che l’Eterno ha ordinato”. ");
INSERT INTO ita1927_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Mosè chiamò dunque Betsaleel e Oholiab e tutti gli uomini abili ne’ quali l’Eterno avea messo intelligenza, tutti quelli che il cuore moveva ad applicarsi al lavoro per eseguirlo; ");
INSERT INTO ita1927_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","ed essi presero in presenza di Mosè tutte le offerte recate dai figliuoli d’Israele per i lavori destinati al servizio del santuario, affin di eseguirli. Ma ogni mattina i figliuoli d’Israele continuavano a portare a Mosè delle offerte volontarie. ");
INSERT INTO ita1927_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Allora tutti gli uomini abili ch’erano occupati a tutti i lavori del santuario, lasciato ognuno il lavoro che faceva, vennero a dire a Mosè: ");
INSERT INTO ita1927_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","“Il popolo porta molto più di quel che bisogna per eseguire i lavori che l’Eterno ha comandato di fare”. ");
INSERT INTO ita1927_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Allora Mosè dette quest’ordine, che fu bandito per il campo: “Né uomo né donna faccia più alcun lavoro come offerta per il santuario”. Così s’impedì che il popolo portasse altro. ");
INSERT INTO ita1927_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Poiché la roba già pronta bastava a fare tutto il lavoro, e ve n’era d’avanzo. ");
INSERT INTO ita1927_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Tutti gli uomini abili, fra quelli che eseguivano il lavoro, fecero dunque il tabernacolo di dieci teli, di lino fino ritorto, e di filo color violaceo, porporino e scarlatto, con dei cherubini artisticamente lavorati. ");
INSERT INTO ita1927_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","La lunghezza d’un telo era di ventotto cubiti; e la larghezza, di quattro cubiti; tutti i teli erano d’una stessa misura. ");
INSERT INTO ita1927_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Cinque teli furono uniti assieme, e gli altri cinque furon pure uniti assieme. ");
INSERT INTO ita1927_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Si fecero de’ nastri di color violaceo all’orlo del telo ch’era all’estremità della prima serie di teli; e lo stesso si fece all’orlo del telo ch’era all’estremità della seconda serie. ");
INSERT INTO ita1927_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Si misero cinquanta nastri al primo telo, e parimente cinquanta nastri all’orlo del telo ch’era all’estremità della seconda serie: i nastri si corrispondevano l’uno all’altro. ");
INSERT INTO ita1927_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Si fecero pure cinquanta fermagli d’oro, e si unirono i teli l’uno all’altro mediante i fermagli; e così il tabernacolo formò un tutto. ");
INSERT INTO ita1927_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Si fecero inoltre dei teli di pel di capra, per servir da tenda per coprire il tabernacolo: di questi teli se ne fecero undici. ");
INSERT INTO ita1927_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","La lunghezza d’ogni telo era di trenta cubiti; e la larghezza, di quattro cubiti; gli undici teli aveano la stessa misura. ");
INSERT INTO ita1927_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","E si unirono insieme, da una parte, cinque teli, e si uniron insieme, dall’altra parte, gli altri sei. ");
INSERT INTO ita1927_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","E si misero cinquanta nastri all’orlo del telo ch’era all’estremità della prima serie di teli, e cinquanta nastri all’orlo del telo ch’era all’estremità della seconda serie. ");
INSERT INTO ita1927_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","E si fecero cinquanta fermagli di rame per unire assieme la tenda, in modo che formasse un tutto. ");
INSERT INTO ita1927_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Si fece pure per la tenda una coperta di pelli di montone tinte di rosso, e, sopra questa, un’altra di pelli di delfino. ");
INSERT INTO ita1927_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Poi si fecero per il tabernacolo le assi di legno d’acacia, messe per ritto. ");
INSERT INTO ita1927_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","La lunghezza d’un’asse era di dieci cubiti, e la larghezza d’un’asse, di un cubito e mezzo. ");
INSERT INTO ita1927_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Ogni asse aveva due incastri paralleli; così fu fatto per tutte le assi del tabernacolo. ");
INSERT INTO ita1927_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Si fecero dunque le assi per il tabernacolo: venti assi dal lato meridionale, verso il sud; ");
INSERT INTO ita1927_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","e si fecero quaranta basi d’argento sotto le venti assi: due basi sotto ciascun’asse per i suoi due incastri. ");
INSERT INTO ita1927_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","E per il secondo lato del tabernacolo, il lato di nord, ");
INSERT INTO ita1927_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","si fecero venti assi, con le loro quaranta basi d’argento: due basi sotto ciascun’asse. ");
INSERT INTO ita1927_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","E per la parte posteriore del tabernacolo, verso occidente, si fecero sei assi. ");
INSERT INTO ita1927_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Si fecero pure due assi per gli angoli del tabernacolo, dalla parte posteriore. ");
INSERT INTO ita1927_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","E queste erano doppie dal basso in su, e al tempo stesso formavano un tutto fino in cima, fino al primo anello. Così fu fatto per ambe due le assi, ch’erano ai due angoli. ");
INSERT INTO ita1927_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","V’erano dunque otto assi, con le loro basi d’argento: sedici basi: due basi sotto ciascun’asse. ");
INSERT INTO ita1927_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","E si fecero delle traverse di legno d’acacia: cinque, per le assi di un lato del tabernacolo; ");
INSERT INTO ita1927_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","cinque traverse per le assi dell’altro lato del tabernacolo, e cinque traverse per le assi della parte posteriore del tabernacolo, a occidente. ");
INSERT INTO ita1927_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","E si fece la traversa di mezzo, in mezzo alle assi, per farla passare da una parte all’altra. ");
INSERT INTO ita1927_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","E le assi furon rivestite d’oro, e furon fatti d’oro i loro anelli per i quali dovean passare le traverse, e le traverse furon rivestite d’oro. ");
INSERT INTO ita1927_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Fu fatto pure il velo, di filo violaceo, porporino, scarlatto, e di lino fino ritorto con de’ cherubini artisticamente lavorati; ");
INSERT INTO ita1927_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","e si fecero per esso quattro colonne di acacia e si rivestirono d’oro; i loro chiodi erano d’oro; e per le colonne, si fusero quattro basi d’argento. ");
INSERT INTO ita1927_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Si fece anche per l’ingresso della tenda una portiera, di filo violaceo porporino, scarlatto, e di lino fino ritorto, in lavoro di ricamo. ");
INSERT INTO ita1927_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","E si fecero le sue cinque colonne coi loro chiodi; si rivestiron d’oro i loro capitelli e le loro aste; e le loro cinque basi eran di rame. ");
INSERT INTO ita1927_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Poi Betsaleel fece l’arca di legno d’acacia; la sua lunghezza era di due cubiti e mezzo, la sua larghezza di un cubito e mezzo, e la sua altezza di un cubito e mezzo. ");
INSERT INTO ita1927_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","E la rivestì d’oro puro di dentro e di fuori, e le fece una ghirlanda d’oro che le girava attorno. ");
INSERT INTO ita1927_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","E fuse per essa quattro anelli d’oro, che mise ai suoi quattro piedi: due anelli da un lato e due anelli dall’altro lato. ");
INSERT INTO ita1927_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Fece anche delle stanghe di legno d’acacia, e le rivesti d’oro. ");
INSERT INTO ita1927_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","E fece passare le stanghe per gli anelli ai lati dell’arca per portar l’arca. ");
INSERT INTO ita1927_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Fece anche un propiziatorio d’oro puro; la sua lunghezza era di due cubiti e mezzo, e la sua larghezza di un cubito e mezzo. ");
INSERT INTO ita1927_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","E fece due cherubini d’oro; li fece lavorati al martello, alle due estremità del propiziatorio: ");
INSERT INTO ita1927_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","un cherubino a una delle estremità, e un cherubino all’altra; fece che questi cherubini uscissero dal propiziatorio alle due estremità. ");
INSERT INTO ita1927_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","E i cherubini aveano le ali spiegate in alto, in modo da coprire il propiziatorio con le ali; aveano la faccia vòlta l’uno verso l’altro; le facce dei cherubini erano volte verso il propiziatorio. ");
INSERT INTO ita1927_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Fece anche la tavola di legno d’acacia; la sua lunghezza era di due cubiti, la sua larghezza di un cubito, e la sua altezza di un cubito e mezzo. ");
INSERT INTO ita1927_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","La rivestì d’oro puro e le fece una ghirlanda d’oro che le girava attorno. ");
INSERT INTO ita1927_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","E le fece attorno una cornice alta quattro dita; e a questa cornice fece tutt’intorno una ghirlanda d’oro. ");
INSERT INTO ita1927_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","E fuse per essa quattro anelli d’oro; e mise gli anelli ai quattro canti, ai quattro piedi della tavola. ");
INSERT INTO ita1927_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Gli anelli erano vicinissimi alla cornice per farvi passare le stanghe destinate a portar la tavola. ");
INSERT INTO ita1927_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","E fece le stanghe di legno d’acacia, e le rivesti d’oro; esse dovean servire a portar la tavola. ");
INSERT INTO ita1927_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Fece anche, d’oro puro, gli utensili da mettere sulla tavola: i suoi piatti, le sue coppe, le sue tazze e i suoi calici da servire per le libazioni. ");
INSERT INTO ita1927_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Fece anche il candelabro d’oro puro; fece il candelabro lavorato al martello, col suo piede e il suo tronco; i suoi calici, i suoi pomi e i suoi fiori erano tutti d’un pezzo col candelabro. ");
INSERT INTO ita1927_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Gli uscivano sei bracci dai lati: tre bracci del candelabro da un lato e tre bracci del candelabro dall’altro; ");
INSERT INTO ita1927_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","su l’uno de’ bracci erano tre calici in forma di mandorla, con un pomo e un fiore; e sull’altro braccio, tre calici in forma di mandorla, con un pomo e un fiore. Lo stesso per i sei bracci uscenti dal candelabro. ");
INSERT INTO ita1927_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","E nel tronco del candelabro v’erano quattro calici in forma di mandorla, coi loro pomi e i loro fiori. ");
INSERT INTO ita1927_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","E c’era un pomo sotto i due primi bracci che partivano dal candelabro; un pomo sotto i due seguenti bracci che partivano dal candelabro, e un pomo sotto i due ultimi bracci che partivano dal candelabro; così per i sei rami uscenti dal candelabro. ");
INSERT INTO ita1927_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Questi pomi e questi bracci erano tutti d’un pezzo col candelabro; il tutto era d’oro puro lavorato al martello. ");
INSERT INTO ita1927_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Fece pure le sue lampade, in numero di sette, i suoi smoccolatoi e i suoi porta smoccolature, d’oro puro. ");
INSERT INTO ita1927_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Per fare il candelabro con tutti i suoi utensili impiego un talento d’oro puro. ");
INSERT INTO ita1927_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Poi fece l’altare dei profumi, di legno d’acacia; la sua lunghezza era di un cubito; e la sua larghezza di un cubito; era quadro, e aveva un’altezza di due cubiti; i suoi corni erano tutti d’un pezzo con esso. ");
INSERT INTO ita1927_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","E lo rivestì d’oro puro: il disopra, i suoi lati tutt’intorno, i suoi corni; e gli fece una ghirlanda d’oro che gli girava attorno. ");
INSERT INTO ita1927_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Gli fece pure due anelli d’oro, sotto la ghirlanda, ai suoi due lati; li mise ai suoi due lati per passarvi le stanghe che servivano a portarlo. ");
INSERT INTO ita1927_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","E fece le stanghe di legno d’acacia, e le rivestì d’oro. ");
INSERT INTO ita1927_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Poi fece l’olio santo per l’unzione e il profumo fragrante, puro, secondo l’arte del profumiere. ");
INSERT INTO ita1927_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Poi fece l’altare degli olocausti, di legno d’acacia; la sua lunghezza era di cinque cubiti; e la sua larghezza di cinque cubiti; era quadro, e avea un’altezza di tre cubiti. ");
INSERT INTO ita1927_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","E ai quattro angoli gli fece dei corni, che spuntavano da esso, e lo rivesti di rame. ");
INSERT INTO ita1927_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Fece pure tutti gli utensili dell’altare: i vasi per le ceneri, le palette, i bacini, i forchettoni, i bracieri; tutti i suoi utensili fece di rame. ");
INSERT INTO ita1927_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","E fece per l’altare una gratella di rame in forma di rete, sotto la cornice, nella parte inferiore; in modo che la rete raggiungeva la metà dell’altezza dell’altare. ");
INSERT INTO ita1927_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","E fuse quattro anelli per i quattro angoli della gratella di rame, per farvi passare le stanghe. ");
INSERT INTO ita1927_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Poi fece le stanghe di legno d’acacia, e le rivestì di rame. ");
INSERT INTO ita1927_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","E fece passare le stanghe per gli anelli, ai lati dell’altare le quali dovean servire a portarlo; e lo fece di tavole, vuoto. ");
INSERT INTO ita1927_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Poi fece la conca di rame e la sua base di rame, servendosi degli specchi delle donne che venivano a gruppi a fare il servizio all’ingresso della tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Poi fece il cortile; dal lato meridionale, c’erano, per formare il cortile, cento cubiti di cortine di lino fino ritorto, ");
INSERT INTO ita1927_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","con le loro venti colonne e le loro venti basi di rame; i chiodi e le aste delle colonne erano d’argento. ");
INSERT INTO ita1927_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Dal lato di settentrione, c’erano cento cubiti di cortine con le loro venti colonne e le loro venti basi di rame; i chiodi e le aste delle colonne erano d’argento. ");
INSERT INTO ita1927_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Dal lato d’occidente, c’erano cinquanta cubiti di cortine con le loro dieci colonne e le loro dieci basi; i chiodi e le aste delle colonne erano d’argento. ");
INSERT INTO ita1927_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","E sul davanti, dal lato orientale, c’erano cinquanta cubiti: ");
INSERT INTO ita1927_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","da uno dei lati dell’ingresso c’erano quindici cubiti di cortine, con tre colonne e le loro tre basi; ");
INSERT INTO ita1927_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","e dall’altro lato (tanto di qua quanto di là dall’ingresso del cortile) c’erano quindici cubiti di cortine, con le loro tre colonne e le loro tre basi. ");
INSERT INTO ita1927_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Tutte le cortine formanti il recinto del cortile erano di lino fino ritorto; ");
INSERT INTO ita1927_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","e le basi per le colonne eran di rame; i chiodi e le aste delle colonne erano d’argento, e i capitelli delle colonne eran rivestiti d’argento, e tutte le colonne del cortile eran congiunte con delle aste d’argento. ");
INSERT INTO ita1927_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","La portiera per l’ingresso del cortile era in lavoro di ricamo, di filo violaceo, porporino, scarlatto, e di lino fino ritorto; aveva una lunghezza di venti cubiti, un’altezza di cinque cubiti, corrispondente alla larghezza delle cortine del cortile. ");
INSERT INTO ita1927_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Le colonne erano quattro, e quattro le loro basi, di rame; i loro chiodi eran d’argento, e i loro capitelli e le loro aste eran rivestiti d’argento. ");
INSERT INTO ita1927_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Tutti i piuoli del tabernacolo e dei recinto del cortile erano di rame. ");
INSERT INTO ita1927_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Questi sono i conti del tabernacolo, del tabernacolo della testimonianza, che furon fatti per ordine di Mosè, per cura dei Leviti, sotto la direzione d’Ithamar, figliuolo del sacerdote Aaronne. ");
INSERT INTO ita1927_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Betsaleel, figliuolo d’Uri, figliuolo di Hur, della tribù di Giuda, fece tutto quello che l’Eterno aveva ordinato a Mosè, ");
INSERT INTO ita1927_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","avendo con sé Oholiab, figliuolo di Ahisamac, della tribù di Dan, scultore, disegnatore, e ricamatore di stoffe violacee, porporine, scarlatte e di lino fino. ");
INSERT INTO ita1927_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Tutto l’oro che fu impiegato nell’opera per tutti i lavori del santuario, oro delle offerte, fu ventinove talenti e settecentotrenta sicli, secondo il siclo del santuario. ");
INSERT INTO ita1927_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","E l’argento di quelli della raunanza de’ quali si fece il censimento, fu cento talenti e mille settecento settantacinque sicli, secondo il siclo del santuario: ");
INSERT INTO ita1927_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","un beka a testa, vale a dire un mezzo siclo, secondo il siclo del santuario, per ogni uomo compreso nel censimento, dall’età di venti anni in su: cioè, per seicento tremila cinquecento cinquanta uomini. ");
INSERT INTO ita1927_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","I cento talenti d’argento servirono a fondere le basi del santuario e le basi del velo: cento basi per i cento talenti, un talento per base. ");
INSERT INTO ita1927_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","E coi mille settecento settantacinque sicli si fecero dei chiodi per le colonne, si rivestirono i capitelli, e si fecero le aste delle colonne. ");
INSERT INTO ita1927_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Il rame delle offerte ammontava a settanta talenti e a duemila quattrocento sicli. ");
INSERT INTO ita1927_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","E con questi si fecero le basi dell’ingresso della tenda di convegno, l’altare di rame con la sua gratella di rame, e tutti gli utensili dell’altare, ");
INSERT INTO ita1927_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","le basi del cortile tutt’all’intorno, le basi dell’ingresso del cortile, tutti i piuoli del tabernacolo e tutti i piuoli del recinto del cortile. ");
INSERT INTO ita1927_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Poi, con le stoffe tinte in violaceo, porporino e scarlatto, fecero de’ paramenti cerimoniali ben lavorati per le funzioni nel santuario, e fecero i paramenti sacri per Aaronne, come l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Si fece l’efod, d’oro, di filo violaceo, porporino, scarlatto, e di lino fino ritorto. ");
INSERT INTO ita1927_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","E batteron l’oro in lamine e lo tagliarono in fili, per intesserlo nella stoffa violacea, porporina, scarlatta, e nel lino fino, e farne un lavoro artistico. ");
INSERT INTO ita1927_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Gli fecero delle spallette, unite assieme; in guisa che l’efod era tenuto assieme mediante le sue due estremità. ");
INSERT INTO ita1927_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","E la cintura artistica che era sull’efod per fissarlo, era tutta d’un pezzo con l’efod, e del medesimo lavoro d’esso: cioè, d’oro, di filo violaceo, porporino, scarlatto, e di lino fino ritorto, come l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Poi lavorarono le pietre d’onice, incastrate in castoni d’oro, sulle quali incisero i nomi de’ figliuoli d’Israele, come s’incidono i sigilli. ");
INSERT INTO ita1927_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","E le misero sulle spallette dell’efod, come pietre di ricordanza per i figliuoli d’Israele, nel modo che l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Poi si fece il pettorale, artisticamente lavorato, come il lavoro dell’efod: d’oro, di filo violaceo, porporino, scarlatto, e di lino fino ritorto. ");
INSERT INTO ita1927_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Il pettorale era quadrato; e lo fecero doppio; avea la lunghezza d’una spanna e una spanna di larghezza; era doppio. ");
INSERT INTO ita1927_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","E v’incastonarono quattro ordini di pietre; nel primo ordine v’era un sardonio, un topazio e uno smeraldo; ");
INSERT INTO ita1927_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","nel secondo ordine, un rubino, uno zaffiro, un calcedonio; ");
INSERT INTO ita1927_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","nel terzo ordine, un’opale, un’agata, un’ametista; ");
INSERT INTO ita1927_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","nel quarto ordine, un grisolito, un onice e un diaspro. Queste pietre erano incastrate nei loro castoni d’oro. ");
INSERT INTO ita1927_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","E le pietre corrispondevano ai nomi dei figliuoli d’Israele, ed erano dodici, secondo i loro nomi; erano incise come de’ sigilli, ciascuna col nome d’una delle dodici tribù. ");
INSERT INTO ita1927_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Fecero pure sul pettorale delle catenelle d’oro puro, intrecciate a mo’ di cordoni. ");
INSERT INTO ita1927_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","E fecero due castoni d’oro e due anelli d’oro, e misero i due anelli alle due estremità del pettorale. ");
INSERT INTO ita1927_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","E fissarono i due cordoni d’oro ai due anelli alle estremità del pettorale; ");
INSERT INTO ita1927_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","e attaccarono gli altri due capi dei due cordoni d’oro ai due castoni, e li misero sulle due spallette dell’efod, sul davanti. ");
INSERT INTO ita1927_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Fecero anche due anelli d’oro e li misero alle altre due estremità del pettorale, sull’orlo interiore vòlto verso l’efod. ");
INSERT INTO ita1927_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","E fecero due altri anelli d’oro, e li misero alle due spallette dell’efod, in basso, sul davanti, vicino al punto dove avveniva la giuntura, al disopra della cintura artistica dell’efod. ");
INSERT INTO ita1927_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","E attaccarono il pettorale mediante i suoi anelli agli anelli dell’efod con un cordone violaceo, affinché il pettorale fosse al disopra della banda artisticamente lavorata dell’efod, e non si potesse staccare dall’efod; come l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Si fece pure il manto dell’efod, di lavoro tessuto tutto di color violaceo, ");
INSERT INTO ita1927_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","e l’apertura, in mezzo al manto, per passarvi il capo: apertura, come quella d’una corazza, con all’intorno un’orlatura tessuta, perché non si strappasse. ");
INSERT INTO ita1927_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","E all’orlo inferiore del manto fecero delle melagrane di color violaceo, porporino e scarlatto, di filo ritorto. ");
INSERT INTO ita1927_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","E fecero de’ sonagli d’oro puro; e posero i sonagli in mezzo alle melagrane all’orlo inferiore del manto, tutt’all’intorno, fra le melagrane: ");
INSERT INTO ita1927_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","un sonaglio e una melagrana, un sonaglio e una melagrana, sull’orlatura del manto, tutt’all’intorno, per fare il servizio, come l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Si fecero pure le tuniche di lino fino, di lavoro tessuto, per Aaronne e per i suoi figliuoli, ");
INSERT INTO ita1927_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","e la mitra di lino fino e le tiare di lino fino da servir come ornamento e le brache di lino fino ritorto, ");
INSERT INTO ita1927_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","e la cintura di lino fino ritorto, di color violaceo, porporino, scarlatto, in lavoro di ricamo, come l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","E fecero d’oro puro la lamina del sacro diadema, e v’incisero, come s’incide sopra un sigillo: SANTO ALL’ETERNO. ");
INSERT INTO ita1927_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","E v’attaccarono un nastro violaceo per fermarla sulla mitra, in alto, come l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Così fu finito tutto il lavoro del tabernacolo e della tenda di convegno. I Figliuoli d’Israele fecero interamente come l’Eterno aveva ordinato a Mosè; fecero a quel modo. ");
INSERT INTO ita1927_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Poi portarono a Mosè il tabernacolo, la tenda e tutti i suoi utensili, i suoi fermagli, le sue tavole le sue traverse, le sue colonne, le sue basi; ");
INSERT INTO ita1927_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","la coperta di pelli di montone tinte in rosso, la coperta di pelli di delfino e il velo di separazione; ");
INSERT INTO ita1927_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","l’arca della testimonianza con le sue stanghe, e il propiziatorio; ");
INSERT INTO ita1927_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","la tavola con tutti i suoi utensili e il pane della presentazione; ");
INSERT INTO ita1927_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","il candelabro d’oro puro con le sue lampade, le lampade disposte in ordine, tutti i suoi utensili, e l’olio per il candelabro; ");
INSERT INTO ita1927_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","l’altare d’oro, l’olio dell’unzione, il profumo fragrante, e la portiera per l’ingresso della tenda; ");
INSERT INTO ita1927_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","l’altare di rame, la sua gratella di rame, le sue stanghe e tutti i suoi utensili, la conca con la sua base; ");
INSERT INTO ita1927_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","le cortine del cortile, le sue colonne con le sue basi, la portiera per l’ingresso del cortile, i cordami del cortile, i suoi piuoli e tutti gli utensili per il servizio del tabernacolo, per la tenda di convegno; ");
INSERT INTO ita1927_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","i paramenti cerimoniali per le funzioni nel santuario, i paramenti sacri per il sacerdote Aaronne e i paramenti de’ suoi figliuoli per esercitare il sacerdozio. ");
INSERT INTO ita1927_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","I figliuoli d’Israele eseguirono tutto il lavoro, secondo che l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","E Mosè vide tutto il lavoro; ed ecco, essi l’aveano eseguito come l’Eterno aveva ordinato; l’aveano eseguito a quel modo. E Mosè li benedisse. ");
INSERT INTO ita1927_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","L’Eterno parlò a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Il primo giorno del primo mese erigerai il tabernacolo, la tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Vi porrai l’arca della testimonianza, e stenderai il velo dinanzi all’arca. ");
INSERT INTO ita1927_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Vi porterai dentro la tavola, e disporrai in ordine le cose che vi son sopra; vi porterai pure il candelabro e accenderai le sue lampade. ");
INSERT INTO ita1927_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Porrai l’altare d’oro per i profumi davanti all’arca della testimonianza e metterai la portiera all’ingresso del tabernacolo. ");
INSERT INTO ita1927_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Porrai l’altare degli olocausti davanti all’ingresso del tabernacolo, della tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Metterai la conca fra la tenda di convegno e l’altare, e vi metterai dentro dell’acqua. ");
INSERT INTO ita1927_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Stabilirai il cortile tutt’intorno, e attaccherai la portiera all’ingresso del cortile. ");
INSERT INTO ita1927_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Poi prenderai l’olio dell’unzione e ungerai il tabernacolo e tutto ciò che v’è dentro, lo consacrerai con tutti i suoi utensili, e sarà santo. ");
INSERT INTO ita1927_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ungerai pure l’altare degli olocausti e tutti i suoi utensili, consacrerai l’altare, e l’altare sarà santissimo. ");
INSERT INTO ita1927_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ungerai anche la conca con la sua base, e la consacrerai. ");
INSERT INTO ita1927_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Poi farai accostare Aaronne e i suoi figliuoli all’ingresso della tenda di convegno, e li laverai con acqua. ");
INSERT INTO ita1927_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Rivestirai Aaronne de’ paramenti sacri, e lo ungerai e lo consacrerai, perché mi eserciti l’ufficio di sacerdote. ");
INSERT INTO ita1927_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Farai pure accostare i suoi figliuoli, li rivestirai di tuniche, ");
INSERT INTO ita1927_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","e li ungerai come avrai unto il loro padre, perché mi esercitino l’ufficio di sacerdoti; e la loro unzione conferirà loro un sacerdozio perpetuo, di generazione in generazione”. ");
INSERT INTO ita1927_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","E Mosè fece così; fece interamente come l’Eterno gli aveva ordinato. ");
INSERT INTO ita1927_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","E il primo giorno del primo mese del secondo anno, il tabernacolo fu eretto. ");
INSERT INTO ita1927_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mosè eresse il tabernacolo, ne pose le basi, ne collocò le assi, ne mise le traverse e ne rizzò le colonne. ");
INSERT INTO ita1927_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Stese la tenda sul tabernacolo, e sopra la tenda pose la coperta d’essa, come l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Poi prese la testimonianza e la pose dentro l’arca, mise le stanghe all’arca, e collocò il propiziatorio sull’arca; ");
INSERT INTO ita1927_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","portò l’arca nel tabernacolo, sospese il velo di separazione e coprì con esso l’arca della testimonianza, come l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Pose pure la tavola nella tenda di convegno, dal lato settentrionale del tabernacolo, fuori del velo. ");
INSERT INTO ita1927_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Vi dispose sopra in ordine il pane, davanti all’Eterno, come l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Poi mise il candelabro nella tenda di convegno, dirimpetto alla tavola, dal lato meridionale del tabernacolo; ");
INSERT INTO ita1927_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","e accese le lampade davanti all’Eterno, come l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Poi mise l’altare d’oro nella tenda di convegno, davanti al velo, ");
INSERT INTO ita1927_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","e vi bruciò su il profumo fragrante, come l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Mise pure la portiera all’ingresso del tabernacolo. ");
INSERT INTO ita1927_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Poi collocò l’altare degli olocausti all’ingresso del tabernacolo della tenda di convegno, e v’offrì sopra l’olocausto e l’oblazione, come l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","E pose la conca fra la tenda di convegno e l’altare, e vi pose dentro dell’acqua per le abluzioni. ");
INSERT INTO ita1927_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","E Mosè ed Aaronne e i suoi figliuoli vi si lavarono le mani e i piedi; ");
INSERT INTO ita1927_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","quando entravano nella tenda di convegno e quando s’accostavano all’altare, si lavavano, come l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Eresse pure il cortile attorno al tabernacolo e all’altare, e sospese la portiera all’ingresso dei cortile. Così Mosè compié l’opera. ");
INSERT INTO ita1927_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Allora la nuvola coprì la tenda di convegno, e la gloria dell’Eterno riempì il tabernacolo. ");
INSERT INTO ita1927_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","E Mosè non poté entrare nella tenda di convegno perché la nuvola vi s’era posata sopra, e la gloria dell’Eterno riempiva il tabernacolo. ");
INSERT INTO ita1927_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Or durante tutti i loro viaggi quando la nuvola s’alzava di sul tabernacolo, i figliuoli d’Israele partivano; ");
INSERT INTO ita1927_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","ma se la nuvola non s’alzava, non partivano fino al giorno che s’alzasse. ");
INSERT INTO ita1927_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Poiché la nuvola dell’Eterno stava sul tabernacolo durante il giorno; e di notte vi stava un fuoco, a vista di tutta la casa d’Israele durante tutti i loro viaggi. ");
INSERT INTO ita1927_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","L’Eterno chiamò Mosè e gli parlò dalla tenda di convegno, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Parla ai figliuoli d’Israele e di’ loro: Quando qualcuno tra voi recherà un’offerta all’Eterno, l’offerta che recherete sarà di bestiame: di capi d’armento o di capi di gregge. ");
INSERT INTO ita1927_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Se la sua offerta è un olocausto di capi d’armento, offrirà un maschio senza difetto; l’offrirà all’ingresso della tenda di convegno, per ottenere il favore dell’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","E poserà la mano sulla testa dell’olocausto, il quale sarà accetto all’Eterno, per fare espiazione per lui. ");
INSERT INTO ita1927_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Poi scannerà il vitello davanti all’Eterno; e i sacerdoti, figliuoli d’Aaronne, offriranno il sangue, e lo spargeranno tutt’intorno sull’altare, che è all’ingresso della tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Si trarrà quindi la pelle all’olocausto, e lo si taglierà a pezzi. ");
INSERT INTO ita1927_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","E i figliuoli del sacerdote Aaronne metteranno del fuoco sull’altare, e accomoderanno delle legna sul fuoco. ");
INSERT INTO ita1927_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Poi i sacerdoti, figliuoli d’Aaronne, disporranno que’ pezzi, la testa e il grasso, sulle legna messe sul fuoco sopra l’altare; ");
INSERT INTO ita1927_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","ma le interiora e le gambe si laveranno con acqua, e il sacerdote farà fumare ogni cosa sull’altare, come un olocausto, un sacrifizio di soave odore, fatto mediante il fuoco all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Se la sua offerta è un olocausto di capi di gregge, di pecore o di capre, offrirà un maschio senza difetto. ");
INSERT INTO ita1927_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Lo scannerà dal lato settentrionale dell’altare, davanti all’Eterno; e i sacerdoti, figliuoli d’Aaronne, ne spargeranno il sangue sull’altare, tutt’intorno. ");
INSERT INTO ita1927_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Poi lo si taglierà a pezzi, che, insieme colla testa e col grasso, il sacerdote disporrà sulle legna messe sul fuoco sopra l’altare; ");
INSERT INTO ita1927_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","ma le interiora e le gambe si laveranno con acqua, e il sacerdote offrirà ogni cosa e la farà fumare sull’altare. Questo è un olocausto, un sacrifizio di soave odore, fatto mediante il fuoco all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Se la sua offerta all’Eterno è un olocausto d’uccelli, offrirà delle tortore o de’ giovani piccioni. ");
INSERT INTO ita1927_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Il sacerdote offrirà in sacrifizio l’uccello sull’altare, gli spiccherà la testa, la farà fumare sull’altare, e il sangue d’esso sarà fatto scorrere sopra uno de’ lati dell’altare. ");
INSERT INTO ita1927_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Poi gli toglierà il gozzo con quel che contiene, e getterà tutto allato all’altare, verso oriente, nel luogo delle ceneri. ");
INSERT INTO ita1927_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Spaccherà quindi l’uccello per le ali, senza però dividerlo in due, e il sacerdote lo farà fumare sull’altare, sulle legna messe sopra il fuoco. Questo è un olocausto, un sacrifizio di soave odore, fatto mediante il fuoco all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Quando qualcuno presenterà all’Eterno come offerta una oblazione, la sua offerta sarà di fior di farina; vi verserà sopra dell’olio e v’aggiungerà dell’incenso. ");
INSERT INTO ita1927_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","E la porterà ai sacerdoti figliuoli d’Aaronne; e il sacerdote prenderà una manata piena del fior di farina spruzzata d’olio, con tutto l’incenso, e farà fumare ogni cosa sull’altare, come ricordanza. Questo è un sacrifizio di soave odore, fatto mediante il fuoco all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ciò che rimarrà dell’oblazione sarà per Aaronne e per i suoi figliuoli; è cosa santissima tra i sacrifizi fatti mediante il fuoco all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","E quando offrirai un’oblazione di cosa cotta in forno, ti servirai di focacce non lievitate di fior di farina impastata con olio, e di gallette senza lievito unte d’olio. ");
INSERT INTO ita1927_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","E se la tua offerta è un’oblazione cotta sulla gratella, sarà di fior di farina, impastata con olio, senza lievito. ");
INSERT INTO ita1927_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","La farai a pezzi, e vi verserai su dell’olio; è un’oblazione. ");
INSERT INTO ita1927_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","E se la tua offerta è un’oblazione cotta in padella, sarà fatta di fior di farina con olio. ");
INSERT INTO ita1927_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Porterai all’Eterno l’oblazione fatta di queste cose; sarà presentata al sacerdote, che la porterà sull’altare. ");
INSERT INTO ita1927_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Il sacerdote preleverà dall’oblazione la parte che dev’essere offerta come ricordanza, e la farà fumare sull’altare. E’ un sacrifizio di soave odore, fatto mediante il fuoco all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ciò che rimarrà dell’oblazione sarà per Aaronne e per i suoi figliuoli; è cosa santissima tra i sacrifizi fatti mediante il fuoco all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Qualunque oblazione offrirete all’Eterno sarà senza lievito; poiché non farete fumar nulla che contenga lievito o miele, come sacrifizio fatto mediante il fuoco all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Potrete offrirne all’Eterno come oblazione di primizie; ma queste offerte non saranno poste sull’altare come offerte di soave odore. ");
INSERT INTO ita1927_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","E ogni oblazione che offrirai, la condirai con sale e non lascerai la tua oblazione mancar di sale, segno del patto del tuo Dio. Su tutte le tue offerte offrirai del sale. ");
INSERT INTO ita1927_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","E se offri all’Eterno un’oblazione di primizie, offrirai, come oblazione delle tue primizie, delle spighe tostate al fuoco, chicchi di grano nuovo, tritati. ");
INSERT INTO ita1927_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","E vi porrai su dell’olio e v’aggiungerai dell’incenso: è un’oblazione. ");
INSERT INTO ita1927_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","E il sacerdote farà fumare come ricordanza una parte del grano tritato e dell’olio, con tutto l’incenso. E’ un sacrifizio fatto mediante il fuoco all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Quand’uno offrirà un sacrifizio di azioni di grazie, se offre capi d’armenti, un maschio o una femmina, l’offrirà senza difetto davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Poserà la mano sulla testa della sua offerta, e la sgozzerà all’ingresso della tenda di convegno; e i sacerdoti, figliuoli d’Aaronne, spargeranno il sangue sull’altare tutt’intorno. ");
INSERT INTO ita1927_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","E di questo sacrifizio di azioni di grazie offrirà, come sacrifizio mediante il fuoco all’Eterno, il grasso che copre le interiora e tutto il grasso che aderisce alle interiora, ");
INSERT INTO ita1927_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","i due arnioni e il grasso che v’è sopra e che copre i fianchi, e la rete del fegato, che staccherà vicino agli arnioni. ");
INSERT INTO ita1927_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","E i figliuoli d’Aaronne faranno fumare tutto questo sull’altare sopra l’olocausto, che è sulle legna messe sul fuoco. Questo è un sacrifizio di soave odore, fatto mediante il fuoco all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Se l’offerta ch’egli fa come sacrifizio di azioni di grazie all’Eterno è di capi di gregge, un maschio o una femmina, l’offrirà senza difetto. ");
INSERT INTO ita1927_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Se presenta come offerta un agnello, l’offrirà davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Poserà la mano sulla testa della sua offerta, e la sgozzerà all’ingresso della tenda di convegno; e i figliuoli d’Aaronne ne spargeranno il sangue sull’altare tutt’intorno. ");
INSERT INTO ita1927_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","E di questo sacrifizio di azioni di grazie offrirà, come sacrifizio mediante il fuoco all’Eterno, il grasso, tutta la coda ch’egli staccherà presso l’estremità della spina, il grasso che copre le interiora e tutto il grasso che aderisce alle interiora, ");
INSERT INTO ita1927_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","i due arnioni e il grasso che v’è sopra e che copre i fianchi, e la rete del fegato, che staccherà vicino agli arnioni. ");
INSERT INTO ita1927_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","E il sacerdote farà fumare tutto questo sull’altare. E’ un cibo offerto mediante il fuoco all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Se la sua offerta è una capra, l’offrirà davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Poserà la mano sulla testa della vittima, e la sgozzerà all’ingresso della tenda di convegno; e i figliuoli d’Aaronne ne spargeranno il sangue sull’altare tutt’intorno. ");
INSERT INTO ita1927_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","E della vittima offrirà, come sacrifizio mediante il fuoco all’Eterno, il grasso che copre le interiora e tutto il grasso che aderisce alle interiora, ");
INSERT INTO ita1927_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","i due arnioni e il grasso che v’è sopra e che copre i fianchi, e la rete del fegato, che staccherà vicino agli arnioni. ");
INSERT INTO ita1927_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","E il sacerdote farà fumare tutto questo sull’altare. E’ un cibo di soave odore, offerto mediante il fuoco. Tutto il grasso appartiene all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Questa è una legge perpetua, per tutte le vostre generazioni, in tutti i luoghi dove abiterete: non mangerete né grasso né sangue”. ");
INSERT INTO ita1927_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Parla ai figliuoli d’Israele e di’ loro: Quando qualcuno avrà peccato per errore e avrà fatto alcuna delle cose che l’Eterno ha vietato di fare, ");
INSERT INTO ita1927_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","se il sacerdote che ha ricevuto l’unzione è quegli che ha peccato, rendendo per tal modo colpevole il popolo, offrirà all’Eterno, per il peccato commesso, un giovenco senza difetto, come sacrifizio per il peccato. ");
INSERT INTO ita1927_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Menerà il giovenco all’ingresso della tenda di convegno, davanti all’Eterno; poserà la mano sulla testa del giovenco, e sgozzerà il giovenco davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Poi il sacerdote che ha ricevuto l’unzione prenderà del sangue del giovenco e lo porterà entro la tenda di convegno; ");
INSERT INTO ita1927_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","e il sacerdote intingerà il suo dito nel sangue, e farà aspersione di quel sangue sette volte davanti all’Eterno, di fronte al velo del santuario. ");
INSERT INTO ita1927_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Il sacerdote quindi metterà di quel sangue sui corni dell’altare del profumo fragrante, altare che è davanti all’Eterno, nella tenda di convegno; e spanderà tutto il sangue del giovenco appiè dell’altare degli olocausti, che è all’ingresso della tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","E torrà dal giovenco del sacrifizio per il peccato tutto il grasso: il grasso che copre le interiora e tutto il grasso che aderisce alle interiora, ");
INSERT INTO ita1927_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","i due arnioni e il grasso che v’è sopra e che copre i fianchi, ");
INSERT INTO ita1927_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","e la rete del fegato, che staccherà vicino agli arnioni, nello stesso modo che queste parti si tolgono dal bue del sacrifizio di azioni di grazie; e il sacerdote le farà fumare sull’altare degli olocausti. ");
INSERT INTO ita1927_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Ma la pelle del giovenco e tutta la sua carne, con la sua testa, le sue gambe, le sue interiora e i suoi escrementi, ");
INSERT INTO ita1927_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","il giovenco intero, lo porterà fuori del campo, in un luogo puro, dove si gettan le ceneri; e lo brucerà col fuoco, su delle legna; sarà bruciato sul mucchio delle ceneri. ");
INSERT INTO ita1927_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Se tutta la raunanza d’Israele ha peccato per errore, senz’accorgersene, e ha fatto alcuna delle cose che l’Eterno ha vietato di fare, e si è così resa colpevole, ");
INSERT INTO ita1927_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","quando il peccato che ha commesso venga ad esser conosciuto, la raunanza offrirà, come sacrifizio per il peccato, un giovenco, e lo menerà davanti alla tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Gli anziani della raunanza poseranno le mani sulla testa del giovenco davanti all’Eterno; e il giovenco sarà sgozzato davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Poi il sacerdote che ha ricevuto l’unzione porterà del sangue del giovenco entro la tenda di convegno; ");
INSERT INTO ita1927_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","e il sacerdote intingerà il dito nel sangue e ne farà aspersione sette volte davanti all’Eterno, di fronte al velo. ");
INSERT INTO ita1927_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","E metterà di quel sangue sui corni dell’altare che è davanti all’Eterno, nella tenda di convegno; e spanderà tutto il sangue appiè dell’altare dell’olocausto, che è all’ingresso della tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","E torrà dal giovenco tutto il grasso, e lo farà fumare sull’altare. ");
INSERT INTO ita1927_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Farà di questo giovenco, come ha fatto del giovenco offerto per il peccato. Così il sacerdote farà l’espiazione per la raunanza, e le sarà perdonato. ");
INSERT INTO ita1927_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Poi porterà il giovenco fuori del campo, e lo brucerà come ha bruciato il primo giovenco. Questo è il sacrifizio per il peccato della raunanza. ");
INSERT INTO ita1927_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Se uno dei capi ha peccato, e ha fatto per errore alcuna di tutte le cose che l’Eterno Iddio suo ha vietato di fare, e si è così reso colpevole, ");
INSERT INTO ita1927_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","quando il peccato che ha commesso gli sarà fatto conoscere, menerà, come sua offerta, un becco, un maschio fra le capre, senza difetto. ");
INSERT INTO ita1927_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Poserà la mano sulla testa del becco, e lo scannerà nel luogo dove si scannano gli olocausti, davanti all’Eterno. E’ un sacrifizio per il peccato. ");
INSERT INTO ita1927_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Poi il sacerdote prenderà col suo dito del sangue del sacrifizio per il peccato, e lo metterà sui corni dell’altare degli olocausti, e spanderà il sangue del becco appiè dell’altare dell’olocausto; ");
INSERT INTO ita1927_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","e farà fumare tutto il grasso del becco sull’altare, come ha fatto del grasso del sacrifizio di azioni di grazie. Così il sacerdote farà l’espiazione del peccato di lui, e gli sarà perdonato. ");
INSERT INTO ita1927_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Se qualcuno del popolo del paese peccherà per errore e farà alcuna delle cose che l’Eterno ha vietato di fare, rendendosi così colpevole, ");
INSERT INTO ita1927_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","quando il peccato che ha commesso gli sarà fatto conoscere, dovrà menare, come sua offerta, una capra, una femmina senza difetto, per il peccato che ha commesso. ");
INSERT INTO ita1927_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Poserà la mano sulla testa del sacrifizio per il peccato, e sgozzerà il sacrifizio per il peccato nel luogo ove si sgozzano gli olocausti. ");
INSERT INTO ita1927_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Poi il sacerdote prenderà col suo dito del sangue della capra e lo metterà sui corni dell’altare dell’olocausto, e spanderà tutto il sangue della capra appiè dell’altare. ");
INSERT INTO ita1927_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","E torrà tutto il grasso dalla capra, come ha tolto il grasso dal sacrifizio di azioni di grazie; e il sacerdote lo farà fumare sull’altare come un soave odore all’Eterno. Così il sacerdote farà l’espiazione per quel tale, e gli sarà perdonato. ");
INSERT INTO ita1927_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","E se colui menerà un agnello come suo sacrifizio per il peccato, dovrà menare una femmina senza difetto. ");
INSERT INTO ita1927_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Poserà la mano sulla testa del sacrifizio per il peccato, e lo sgozzerà come sacrifizio per il peccato nel luogo ove si sgozzano gli olocausti. ");
INSERT INTO ita1927_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Poi il sacerdote prenderà col suo dito del sangue del sacrifizio per il peccato, e lo metterà sui corni dell’altare dell’olocausto, e spanderà tutto il sangue della vittima appiè dell’altare; ");
INSERT INTO ita1927_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","e torrà dalla vittima tutto il grasso, come si toglie il grasso dall’agnello del sacrifizio di azioni di grazie; e il sacerdote lo farà fumare sull’altare, sui sacrifizi fatti mediante il fuoco all’Eterno. Così il sacerdote farà per quel tale l’espiazione del peccato che ha commesso, e gli sarà perdonato. ");
INSERT INTO ita1927_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Quando una persona, dopo aver udito dal giudice la formula del giuramento, nella sua qualità di testimonio pecca non dichiarando ciò che ha veduto o altrimenti conosciuto, porterà la pena della sua iniquità. ");
INSERT INTO ita1927_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","O quand’uno, senza saperlo, avrà toccato qualcosa d’impuro, come il cadavere d’una bestia selvatica impura, o il cadavere d’un animale domestico impuro, o quello d’un rettile impuro, rimarrà egli stesso impuro e colpevole. ");
INSERT INTO ita1927_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","O quando, senza saperlo, toccherà una impurità umana una qualunque delle cose per le quali l’uomo diviene impuro allorché viene a saperlo, è colpevole. ");
INSERT INTO ita1927_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","O quand’uno, senza badarvi, parlando leggermente con le labbra, avrà giurato, con uno di quei giuramenti che gli uomini sogliono proferire alla leggera, di fare qualcosa di male o di bene, allorché viene ad accorgersene, è colpevole. ");
INSERT INTO ita1927_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Quand’uno dunque si sarà reso colpevole d’una di queste cose, confesserà il peccato che ha commesso; ");
INSERT INTO ita1927_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","recherà all’Eterno, come sacrifizio della sua colpa, per il peccato che ha commesso, una femmina del gregge, una pecora o una capra, come sacrifizio per il peccato; e il sacerdote farà per lui l’espiazione del suo peccato. ");
INSERT INTO ita1927_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Se non ha mezzi da procurarsi una pecora o una capra, porterà all’Eterno, come sacrifizio della sua colpa, per il suo peccato, due tortore o due giovani piccioni: uno come sacrifizio per il peccato, l’altro come olocausto. ");
INSERT INTO ita1927_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","E li porterà al sacerdote, il quale offrirà prima quello per il peccato; gli spiccherà la testa vicino alla nuca, ma senza staccarla del tutto; ");
INSERT INTO ita1927_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","poi spargerà del sangue del sacrifizio per il peccato sopra uno dei lati dell’altare, e il resto del sangue sarà spremuto appiè dell’altare. Questo è un sacrifizio per il peccato. ");
INSERT INTO ita1927_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Dell’altro uccello farà un olocausto, secondo le norme stabilite. Così il sacerdote farà per quel tale l’espiazione del peccato che ha commesso, e gli sarà perdonato. ");
INSERT INTO ita1927_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Ma se non ha mezzi da procurarsi due tortore o due giovani piccioni, porterà, come sua offerta per il peccato che a commesso, la decima parte di un efa di fior di farina, come sacrifizio per il peccato; non vi metterà su né olio né incenso, perché è un sacrifizio per il peccato. ");
INSERT INTO ita1927_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Porterà la farina al sacerdote, e il sacerdote ne prenderà una manata piena come ricordanza, e la farà fumare sull’altare sopra i sacrifizi fatti mediante il fuoco all’Eterno. E’ un sacrifizio per il peccato. ");
INSERT INTO ita1927_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Così il sacerdote farà per quel tale l’espiazione del peccato che ha commesso in uno di quei casi e gli sarà perdonato. Il resto della farina sarà per il sacerdote come si fa nell’oblazione”. ");
INSERT INTO ita1927_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Quand’uno commetterà una infedeltà e peccherà per errore relativamente a ciò che dev’esser consacrato all’Eterno, porterà all’Eterno, come sacrifizio di riparazione, un montone senza difetto, preso dal gregge, secondo la tua stima in sicli d’argento a siclo di santuario, come sacrifizio di riparazione. ");
INSERT INTO ita1927_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","E risarcirà il danno fatto al santuario, aggiungendovi un quinto in più e lo darà al sacerdote; e il sacerdote farà per lui l’espiazione col montone offerto come sacrifizio di riparazione, e gli sarà perdonato. ");
INSERT INTO ita1927_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","E quand’uno peccherà facendo, senza saperlo, qualcuna delle cose che l’Eterno ha vietato di fare, sarà colpevole e porterà la pena della sua iniquità. ");
INSERT INTO ita1927_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Presenterà al sacerdote, come sacrifizio di riparazione, un montone senza difetto, preso dal gregge, secondo la tua stima; e il sacerdote farà per lui l’espiazione dell’errore commesso per ignoranza, e gli sarà perdonato. ");
INSERT INTO ita1927_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Questo è un sacrifizio di riparazione; quel tale si è realmente reso colpevole verso l’Eterno”. ");
INSERT INTO ita1927_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","E l’Eterno parlò a Mosè dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Quand’uno peccherà e commetterà una infedeltà verso l’Eterno, negando al suo prossimo un deposito da lui ricevuto, o un pegno messo nelle sue mani, o una cosa che ha rubata o estorta con frode al prossimo, ");
INSERT INTO ita1927_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","o una cosa perduta che ha trovata, e mentendo a questo proposito e giurando il falso circa una delle cose nelle quali l’uomo può peccare, ");
INSERT INTO ita1927_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","quando avrà così peccato e si sarà reso colpevole, restituirà la cosa rubata o estorta con frode, o il deposito che gli era stato confidato, o l’oggetto perduto che ha trovato, ");
INSERT INTO ita1927_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","o qualunque cosa circa la quale abbia giurato il falso. Ne farà la restituzione per intero e v’aggiungerà un quinto in più, consegnandola al proprietario il giorno stesso che offrirà il suo sacrifizio di riparazione. ");
INSERT INTO ita1927_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","E porterà al sacerdote il suo sacrifizio di riparazione all’Eterno: un montone senza difetto, preso dal gregge, secondo la tua stima, come sacrifizio di riparazione. ");
INSERT INTO ita1927_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","E il sacerdote farà l’espiazione per lui davanti all’Eterno, e gli sarà perdonato qualunque sia la cosa di cui si è reso colpevole”. ");
INSERT INTO ita1927_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Da’ quest’ordine ad Aaronne e ai suoi figliuoli, e di’ loro: Questa è la legge dell’olocausto. L’olocausto rimarrà sulle legna accese sopra l’altare tutta la notte, fino al mattino; e il fuoco dell’altare sarà tenuto acceso. ");
INSERT INTO ita1927_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Il sacerdote si vestirà della sua tunica di lino e si metterà sulla carne le brache; leverà la cenere fatta dal fuoco che avrà consumato l’olocausto sull’altare e la porrà allato all’altare. ");
INSERT INTO ita1927_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Poi si spoglierà delle vesti e ne indosserà delle altre, e porterà la cenere fuori del campo, in un luogo puro. ");
INSERT INTO ita1927_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Il fuoco sarà mantenuto acceso sull’altare e non si lascerà spegnere; e il sacerdote vi brucerà su delle legna ogni mattina, vi disporrà sopra l’olocausto, e vi farà fumar sopra il grasso dei sacrifizi di azioni di grazie. ");
INSERT INTO ita1927_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Il fuoco dev’esser del continuo mantenuto acceso sull’altare, e non si lascerà spengere. ");
INSERT INTO ita1927_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Questa è la legge dell’oblazione. I figliuoli d’Aaronne l’offriranno davanti all’Eterno, dinanzi all’altare. ");
INSERT INTO ita1927_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Si leverà una manata di fior di farina con il suo olio e tutto l’incenso che è sull’oblazione, e si farà fumare ogni cosa sull’altare in sacrifizio di soave odore, come una ricordanza per l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Aaronne e i suoi figliuoli mangeranno quel che rimarrà dell’oblazione; la si mangerà senza lievito, in luogo santo; la mangeranno nel cortile della tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Non la si cocerà con lievito; è la parte che ho data loro de’ miei sacrifizi fatti mediante il fuoco. E’ cosa santissima, come il sacrifizio per il peccato e come il sacrifizio di riparazione. ");
INSERT INTO ita1927_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Ogni maschio tra i figliuoli d’Aaronne ne potrà mangiare. E’ una parte perpetua, assegnatavi di generazione in generazione, sui sacrifizi fatti mediante il fuoco all’Eterno. Chiunque toccherà quelle cose dovrà esser santo”. ");
INSERT INTO ita1927_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Questa è l’offerta che Aaronne e i suoi figliuoli faranno all’Eterno il giorno che riceveranno l’unzione: un decimo d’efa di fior di farina, come oblazione perpetua, metà la mattina e metà la sera. ");
INSERT INTO ita1927_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Essa sarà preparata con olio, sulla gratella; la porterai quando sarà fritta; l’offrirai in pezzi, come offerta divisa di soave odore all’Eterno; ");
INSERT INTO ita1927_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","e il sacerdote che, tra i figliuoli d’Aaronne, sarà unto per succedergli, farà anch’egli quest’offerta; è la parte assegnata in perpetuo all’Eterno; sarà fatta fumare per intero. ");
INSERT INTO ita1927_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Ogni oblazione del sacerdote sarà fatta fumare per intero; non sarà mangiata”. ");
INSERT INTO ita1927_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Parla ad Aaronne e ai suoi figliuoli, e di’ loro: Questa è la legge del sacrifizio per il peccato. Nel luogo dove si sgozza l’olocausto, sarà sgozzata, davanti all’Eterno, la vittima per il peccato. E’ cosa santissima. ");
INSERT INTO ita1927_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Il sacerdote che l’offrirà per il peccato, la mangerà; dovrà esser mangiata in luogo santo, nel cortile della tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Chiunque ne toccherà la carne dovrà esser santo; e se ne schizza del sangue sopra una veste, il posto ove sarà schizzato il sangue lo laverai in luogo santo. ");
INSERT INTO ita1927_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Ma il vaso di terra che avrà servito a cuocerla, sarà spezzato; e se è stata cotta in un vaso di rame, questo si strofini bene e si sciacqui con acqua. ");
INSERT INTO ita1927_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Ogni maschio, fra i sacerdoti, ne potrà mangiare; è cosa santissima. ");
INSERT INTO ita1927_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Ma non si mangerà alcuna vittima per il peccato, quando si deve portare del sangue d’essa nella tenda di convegno per fare l’espiazione nel santuario. Essa sarà bruciata col fuoco. ");
INSERT INTO ita1927_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Questa è la legge del sacrifizio di riparazione; è cosa santissima. ");
INSERT INTO ita1927_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Nel luogo ove si scanna l’olocausto, si scannerà la vittima di riparazione; e se ne spanderà il sangue sull’altare tutt’intorno; ");
INSERT INTO ita1927_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","e se ne offrirà tutto il grasso, la coda, il grasso che copre le interiora, ");
INSERT INTO ita1927_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","i due arnioni, il grasso che v’è sopra e che copre i fianchi, e la rete del fegato, che si staccherà vicino agli arnioni. ");
INSERT INTO ita1927_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Il sacerdote farà fumare tutto questo sull’altare, come un sacrifizio fatto mediante il fuoco all’Eterno. Questo è un sacrifizio di riparazione. ");
INSERT INTO ita1927_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Ogni maschio tra i sacerdoti ne potrà mangiare; lo si mangerà in luogo santo; è cosa santissima. ");
INSERT INTO ita1927_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Il sacrifizio di riparazione è come il sacrifizio per il peccato; la stessa legge vale per ambedue; la vittima sarà del sacerdote che farà l’espiazione. ");
INSERT INTO ita1927_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","E il sacerdote che offrirà l’olocausto per qualcuno avrà per sé la pelle dell’olocausto che avrà offerto. ");
INSERT INTO ita1927_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Così pure ogni oblazione cotta in forno, o preparata in padella, o sulla gratella, sarà del sacerdote che l’ha offerta. ");
INSERT INTO ita1927_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","E ogni oblazione impastata con olio, o asciutta, sarà per tutti i figliuoli d’Aaronne: per l’uno come per l’altro. ");
INSERT INTO ita1927_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Questa è la legge del sacrifizio di azioni di grazie, che si offrirà all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Se uno l’offre per riconoscenza, offrirà, col sacrifizio di azioni di grazie, delle focacce senza lievito intrise con olio, delle gallette senza lievito unte con olio, e del fior di farina cotto, in forma di focacce intrise con olio. ");
INSERT INTO ita1927_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Presenterà anche, per sua offerta, oltre quelle focacce, delle focacce di pan lievitato, insieme col suo sacrifizio di riconoscenza e di azioni di grazie. ");
INSERT INTO ita1927_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","D’ognuna di queste offerte si presenterà una parte come oblazione elevata all’Eterno; essa sarà del sacerdote che avrà fatto l’aspersione del sangue del sacrifizio di azioni di grazie. ");
INSERT INTO ita1927_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","E la carne del sacrifizio di riconoscenza e di azioni di grazie sarà mangiata il giorno stesso ch’esso è offerto; non se ne lascerà nulla fino alla mattina. ");
INSERT INTO ita1927_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Ma se il sacrifizio che uno offre è votivo o volontario, la vittima sarà mangiata il giorno ch’ei l’offrirà, e quel che ne rimane dovrà esser mangiato l’indomani; ");
INSERT INTO ita1927_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","ma quel che sarà rimasto della carne del sacrifizio fino al terzo giorno, dovrà bruciarsi col fuoco. ");
INSERT INTO ita1927_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Che se uno mangia della carne del suo sacrifizio di azioni di grazie il terzo giorno, colui che l’ha offerto non sarà gradito; e dell’offerta non gli sarà tenuto conto; sarà cosa aborrita; e colui che ne avrà mangiato porterà la pena della sua iniquità. ");
INSERT INTO ita1927_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","La carne che sarà stata in contatto di qualcosa d’impuro, non sarà mangiata; sarà bruciata col fuoco. ");
INSERT INTO ita1927_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Quanto alla carne che si mangia, chiunque è puro ne potrà mangiare; ma la persona che, essendo impura, mangerà della carne del sacrifizio di azioni di grazie che appartiene all’Eterno, sarà sterminata di fra il suo popolo. ");
INSERT INTO ita1927_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","E se uno toccherà qualcosa d’impuro, una impurità umana, un animale impuro o qualsivoglia cosa abominevole, immonda, e mangerà della carne del sacrifizio di azioni di grazie che appartiene all’Eterno, quel tale sarà sterminato di fra il suo popolo”. ");
INSERT INTO ita1927_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Parla ai figliuoli d’Israele, e di’ loro: Non mangerete alcun grasso, né di bue, né di pecora, né di capra. ");
INSERT INTO ita1927_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Il grasso di una bestia morta da sé, o il grasso d’una bestia sbranata potrà servire per qualunque altro uso; ma non ne mangerete affatto; ");
INSERT INTO ita1927_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","perché chiunque mangerà del grasso degli animali che si offrono in sacrifizio mediante il fuoco all’Eterno, quel tale sarà sterminato di fra il suo popolo. ");
INSERT INTO ita1927_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","E non mangerete affatto alcun sangue, né di uccelli né di quadrupedi, in tutti i luoghi dove abiterete. ");
INSERT INTO ita1927_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Chiunque mangerà sangue di qualunque specie, sarà sterminato di fra il suo popolo”. ");
INSERT INTO ita1927_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Parla ai figliuoli d’Israele, e di’ loro: Colui che offrirà all’Eterno il suo sacrifizio di azioni di grazie porterà la sua offerta all’Eterno, prelevandola dal suo sacrifizio di azioni di grazie. ");
INSERT INTO ita1927_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Porterà con le proprie mani ciò che dev’essere offerto all’Eterno mediante il fuoco; porterà il grasso insieme col petto, il petto per agitarlo come offerta agitata davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Il sacerdote farà fumare il grasso sull’altare; e il petto sarà d’Aaronne e de’ suoi figliuoli. ");
INSERT INTO ita1927_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Darete pure al sacerdote, come offerta elevata, la coscia destra dei vostri sacrifizi d’azioni di grazie. ");
INSERT INTO ita1927_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Colui de’ figliuoli d’Aaronne che offrirà il sangue e il grasso dei sacrifizi di azioni di grazie avrà, come sua parte, la coscia destra. ");
INSERT INTO ita1927_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Poiché, dai sacrifizi di azioni di grazie offerti dai figliuoli d’Israele, io prendo il petto dell’offerta agitata e la coscia dell’offerta elevata, e li do al sacerdote Aaronne e ai suoi figliuoli per legge perpetua, da osservarsi dai figliuoli d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Questa è la parte consacrata ad Aaronne e consacrata ai suoi figliuoli, dei sacrifizi fatti mediante il fuoco all’Eterno, dal giorno in cui saranno presentati per esercitare il sacerdozio dell’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Questo l’Eterno ha ordinato ai figliuoli d’Israele di dar loro dal giorno della loro unzione. E’ una parte ch’è loro dovuta in perpetuo, di generazione in generazione”. ");
INSERT INTO ita1927_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Questa è la legge dell’olocausto, dell’oblazione, del sacrifizio per il peccato, del sacrifizio di riparazione, della consacrazione e del sacrifizio di azioni di grazie: ");
INSERT INTO ita1927_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","legge che l’Eterno dette a Mosè sul monte Sinai il giorno che ordinò ai figliuoli d’Israele di presentare le loro offerte all’Eterno nel deserto di Sinai. ");
INSERT INTO ita1927_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Prendi Aaronne e i suoi figliuoli con lui, i paramenti, l’olio dell’unzione, il giovenco del sacrifizio per il peccato, i due montoni e il paniere dei pani azzimi; ");
INSERT INTO ita1927_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","e convoca tutta la raunanza all’ingresso della tenda di convegno”. ");
INSERT INTO ita1927_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","E Mosè fece come l’Eterno gli aveva ordinato, e la raunanza fu convocata all’ingresso della tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","E Mosè disse alla raunanza: “Questo è quello che l’Eterno ha ordinato di fare”. ");
INSERT INTO ita1927_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","E Mosè fece accostare Aaronne e i suoi figliuoli, e li lavò con acqua. ");
INSERT INTO ita1927_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Poi rivestì Aaronne della tunica, lo cinse della cintura, gli pose addosso il manto, gli mise l’efod, e lo cinse della cintura artistica dell’efod, con la quale gli fissò l’efod addosso. ");
INSERT INTO ita1927_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Gli mise pure il pettorale, e sul pettorale pose l’Urim e il Thummim. ");
INSERT INTO ita1927_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Poi gli mise in capo la mitra, e sul davanti della mitra pose la lamina d’oro, il santo diadema, come l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Poi Mosè prese l’olio dell’unzione, unse il tabernacolo e tutte le cose che vi si trovavano, e le consacrò. ");
INSERT INTO ita1927_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Ne fece sette volte l’aspersione sull’altare, unse l’altare e tutti i suoi utensili, e la conca e la sua base, per consacrarli. ");
INSERT INTO ita1927_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","E versò dell’olio dell’unzione sul capo d’Aaronne, e unse Aaronne, per consacrarlo. ");
INSERT INTO ita1927_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Poi Mosè fece accostare i figliuoli d’Aaronne, li vestì di tuniche, li cinse di cinture, e assicurò sul loro capo delle tiare, come l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Fece quindi accostare il giovenco del sacrifizio per il peccato, e Aaronne e i suoi figliuoli posarono le loro mani sulla testa del giovenco del sacrifizio per il peccato. ");
INSERT INTO ita1927_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Mosè lo scannò, ne prese del sangue, lo mise col dito sui corni dell’altare tutto all’intorno, e purificò l’altare; poi sparse il resto del sangue appiè dell’altare, e lo consacrò per farvi su l’espiazione. ");
INSERT INTO ita1927_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Poi prese tutto il grasso ch’era sulle interiora, la rete del fegato, i due arnioni col loro grasso, e Mosè fece fumar tutto sull’altare. ");
INSERT INTO ita1927_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Ma il giovenco, la sua pelle, la sua carne e i suoi escrementi, li bruciò col fuoco fuori del campo, come l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Fece quindi accostare il montone dell’olocausto, e Aaronne e i suoi figliuoli posarono le mani sulla testa del montone. ");
INSERT INTO ita1927_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","E Mosè lo scannò, e ne sparse il sangue sull’altare tutto all’intorno. ");
INSERT INTO ita1927_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Poi fece a pezzi il montone, e Mosè fece fumare la testa, i pezzi e il grasso. ");
INSERT INTO ita1927_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","E quando n’ebbe lavato le interiora e le gambe con acqua, Mosè fece fumare tutto il montone sull’altare. Fu un olocausto di soave odore, un sacrifizio fatto mediante il fuoco all’Eterno, come l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Poi fece accostare il secondo montone, il montone della consacrazione; e Aaronne e i suoi figliuoli posarono le mani sulla testa del montone. ");
INSERT INTO ita1927_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","E Mosè lo scannò, e ne prese del sangue e lo mise sull’estremità dell’orecchio destro d’Aaronne e sul pollice della sua man destra e sul dito grosso del suo piede destro. ");
INSERT INTO ita1927_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Poi Mosè fece accostare i figliuoli d’Aaronne, e pose di quel sangue sull’estremità del loro orecchio destro, sul pollice della loro man destra e sul dito grosso del loro piè destro; e sparse il resto del sangue sull’altare tutto all’intorno. ");
INSERT INTO ita1927_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Poi prese il grasso, la coda, tutto il grasso che copriva le interiora, la rete del fegato, i due arnioni, il loro grasso, e la coscia destra; ");
INSERT INTO ita1927_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","e dal paniere dei pani azzimi, ch’era davanti all’Eterno, prese una focaccia senza lievito, una focaccia di pasta oliata e una galletta, e le pose sui grassi e sulla coscia destra. ");
INSERT INTO ita1927_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Poi mise tutte queste cose sulle palme delle mani d’Aaronne e sulle palme delle mani de’ suoi figliuoli, e le agitò come offerta agitata davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Mosè quindi le prese dalle loro mani, e le fece fumare sull’altare sopra l’olocausto. Fu un sacrifizio di consacrazione, di soave odore: un sacrifizio fatto mediante il fuoco all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Poi Mosè prese il petto del montone e lo agitò come offerta agitata davanti all’Eterno; questa fu la parte del montone della consacrazione che toccò a Mosè, come l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Mosè prese quindi dell’olio dell’unzione e del sangue ch’era sopra l’altare, e ne asperse Aaronne e i suoi paramenti, i figliuoli di lui e i loro paramenti; e consacrò Aaronne e i suoi paramenti, i figliuoli di lui e i loro paramenti con lui. ");
INSERT INTO ita1927_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Poi Mosè disse ad Aaronne e ai suoi figliuoli: “Fate cuocere la carne all’ingresso della tenda di convegno; e quivi la mangerete col pane che è nel paniere della consacrazione, come ho ordinato, dicendo: Aaronne e i suoi figliuoli la mangeranno. ");
INSERT INTO ita1927_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","E quel che rimane della carne e del pane lo brucerete col fuoco. ");
INSERT INTO ita1927_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","E per sette giorni non vi dipartirete dall’ingresso della tenda di convegno, finché non siano compiuti i giorni delle vostre consacrazioni; poiché la vostra consacrazione durerà sette giorni. ");
INSERT INTO ita1927_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Come s’è fatto oggi, così l’Eterno ha ordinato che si faccia, per fare espiazione per voi. ");
INSERT INTO ita1927_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Rimarrete dunque sette giorni all’ingresso della tenda di convegno, giorno e notte, e osserverete il comandamento dell’Eterno, affinché non muoiate; poiché così m’è stato ordinato”. ");
INSERT INTO ita1927_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","E Aaronne e i suoi figliuoli fecero tutte le cose che l’Eterno aveva ordinate per mezzo di Mosè. ");
INSERT INTO ita1927_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","L’ottavo giorno, Mosè chiamò Aaronne, i suoi figliuoli e gli anziani d’Israele, ");
INSERT INTO ita1927_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","e disse ad Aaronne: “Prendi un giovine vitello per un sacrifizio per il peccato, e un montone per un olocausto: ambedue senza difetto, e offrili all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","E dirai così ai figliuoli d’Israele: Prendete un capro per un sacrifizio per il peccato, e un vitello e un agnello, ambedue d’un anno, senza difetto, per un olocausto; ");
INSERT INTO ita1927_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","e un bue e un montone per un sacrifizio di azioni di grazie, per sacrificarli davanti all’Eterno; e un’oblazione intrisa con olio; perché oggi l’Eterno vi apparirà”. ");
INSERT INTO ita1927_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Essi dunque menarono davanti alla tenda di convegno le cose che Mosè aveva ordinate; e tutta la raunanza si accostò, e si tenne in piè davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","E Mosè disse: “Questo è quello che l’Eterno vi ha ordinato; fatelo, e la gloria dell’Eterno vi apparirà”. ");
INSERT INTO ita1927_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","E Mosè disse ad Aaronne: “Accostati all’altare; offri il tuo sacrifizio per il peccato e il tuo olocausto, e fa’ l’espiazione per te e per il popolo; presenta anche l’offerta del popolo e fa’ l’espiazione per esso, come l’Eterno ha ordinato”. ");
INSERT INTO ita1927_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Aaronne dunque s’accostò all’altare e scannò il vitello del sacrifizio per il peccato, ch’era per sé. ");
INSERT INTO ita1927_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","E i suoi figliuoli gli porsero il sangue, ed egli intinse il dito nel sangue, ne mise sui corni dell’altare, e sparse il resto del sangue appiè dell’altare; ");
INSERT INTO ita1927_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","ma il grasso, gli arnioni e la rete del fegato della vittima per il peccato, li fece fumare sull’altare, come l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","E la carne e la pelle, le bruciò col fuoco fuori del campo. ");
INSERT INTO ita1927_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Poi scannò l’olocausto; e i figliuoli d’Aaronne gli porsero il sangue, ed egli lo sparse sull’altare tutto all’intorno. ");
INSERT INTO ita1927_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Gli porsero pure l’olocausto fatto a pezzi, e la testa; ed egli li fece fumare sull’altare. ");
INSERT INTO ita1927_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","E lavò le interiora e le gambe, e le fece fumare sull’olocausto, sopra l’altare. ");
INSERT INTO ita1927_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Poi presentò l’offerta del popolo. Prese il capro destinato al sacrifizio per il peccato del popolo, lo scannò e l’offrì per il peccato, come la prima volta. ");
INSERT INTO ita1927_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Poi offrì l’olocausto, e lo fece secondo la regola stabilita. ");
INSERT INTO ita1927_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Presentò quindi l’oblazione; ne prese una manata piena, e la fece fumare sull’altare, oltre l’olocausto della mattina. ");
INSERT INTO ita1927_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","E scannò il bue e il montone, come sacrifizio di azioni di grazie per il popolo. I figliuoli d’Aaronne gli porsero il sangue, ed egli lo sparse sull’altare, tutto all’intorno. ");
INSERT INTO ita1927_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Gli porsero i grassi del bue, del montone, la coda, il grasso che copre le interiora, gli arnioni e la rete del fegato; ");
INSERT INTO ita1927_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","misero i grassi sui petti, ed egli fece fumare i grassi sull’altare; ");
INSERT INTO ita1927_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","e i petti e la coscia destra, Aaronne li agitò davanti all’Eterno come offerta agitata, nel modo che Mosè aveva ordinato. ");
INSERT INTO ita1927_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Poi Aaronne alzò le mani verso il popolo, e lo benedisse; e, dopo aver fatto il sacrifizio per il peccato, l’olocausto e i sacrifizi di azioni di grazie, scese giù dall’altare. ");
INSERT INTO ita1927_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","E Mosè ed Aaronne entrarono nella tenda di convegno; poi uscirono e benedissero il popolo; e la gloria dell’Eterno apparve a tutto il popolo. ");
INSERT INTO ita1927_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Un fuoco uscì dalla presenza dell’Eterno e consumò sull’altare l’olocausto e i grassi; e tutto il popolo lo vide, diè in grida d’esultanza, e si prostrò colla faccia a terra. ");
INSERT INTO ita1927_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Or Nadab ed Abihu, figliuoli d’Aaronne, presero ciascuno il suo turibolo, vi misero dentro del fuoco, vi posero su del profumo, e offrirono davanti all’Eterno del fuoco estraneo: il che egli non aveva loro ordinato. ");
INSERT INTO ita1927_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","E un fuoco uscì dalla presenza dell’Eterno, e li divorò; e morirono davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Allora Mosè disse ad Aaronne: “Questo è quello di cui l’Eterno ha parlato, quando ha detto: Io sarò santificato per mezzo di quelli che mi stanno vicino, e sarò glorificato in presenza di tutto il popolo”. E Aaronne si tacque. ");
INSERT INTO ita1927_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","E Mosè chiamò Mishael ed Eltsafan, figliuoli di Uziel, zio d’Aaronne, e disse loro: “Accostatevi, portate via i vostri fratelli di davanti al santuario, fuori del campo”. ");
INSERT INTO ita1927_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ed essi si accostarono, e li portaron via nelle loro tuniche, fuori del campo, come Mosè avea detto. ");
INSERT INTO ita1927_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","E Mosè disse ad Aaronne, ad Eleazar e ad Ithamar, suoi figliuoli: “Non andate a capo scoperto, e non vi stracciate le vesti, affinché non muoiate, e l’Eterno non s’adiri contro tutta la raunanza; ma i vostri fratelli, tutta quanta la casa d’Israele, menino duolo, a motivo dell’arsione che l’Eterno ha fatto. ");
INSERT INTO ita1927_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","E non vi dipartite dall’ingresso della tenda di convegno, onde non abbiate a perire; poiché l’olio dell’unzione dell’Eterno è su voi”. Ed essi fecero come Mosè avea detto. ");
INSERT INTO ita1927_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","L’Eterno parlò ad Aaronne, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Non bevete vino né bevande alcooliche tu e i tuoi figliuoli quando entrerete nella tenda di convegno, affinché non muoiate; sarà una legge perpetua, di generazione in generazione; ");
INSERT INTO ita1927_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","e questo, perché possiate discernere ciò ch’è santo da ciò che è profano e ciò che è impuro da ciò ch’è puro, ");
INSERT INTO ita1927_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","e possiate insegnare ai figliuoli d’Israele tutte le leggi che l’Eterno ha dato loro per mezzo di Mosè”. ");
INSERT INTO ita1927_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Poi Mosè disse ad Aaronne, ad Eleazar e ad Ithamar, i due figliuoli che restavano ad Aaronne: “Prendete quel che rimane dell’oblazione dei sacrifizi fatti mediante il fuoco all’Eterno, e mangiatelo senza lievito, presso l’altare; perché è cosa santissima. ");
INSERT INTO ita1927_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Lo mangerete in luogo santo, perché è la parte che spetta a te e ai tuoi figliuoli, de’ sacrifizi fatti mediante il fuoco all’Eterno; poiché così mi è stato ordinato. ");
INSERT INTO ita1927_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","E il petto dell’offerta agitata e la coscia dell’offerta elevata li mangerete tu, i tuoi figliuoli e le tue figliuole con te, in luogo puro; perché vi sono stati dati come parte spettante a te ed ai tuoi figliuoli, dei sacrifizi di azioni di grazie de’ figliuoli d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Oltre ai grassi da ardere si porteranno la coscia dell’offerta elevata e il petto dell’offerta agitata, per esser agitati davanti all’Eterno come offerta agitata; anche questo apparterrà a te e ai tuoi figliuoli con te, per diritto perpetuo, come l’Eterno ha ordinato”. ");
INSERT INTO ita1927_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Or Mosè cercò e ricercò il capro del sacrifizio per il peccato; ed ecco, era stato bruciato; ond’egli s’adirò gravemente contro Eleazar e contro Ithamar, i figliuoli ch’eran rimasti ad Aaronne, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Perché non avete mangiato il sacrifizio per il peccato nel luogo santo? giacché è cosa santissima, e l’Eterno ve l’ha dato perché portiate l’iniquità della raunanza, perché ne facciate l’espiazione davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Ecco, il sangue della vittima non e stato portato dentro il santuario; voi avreste dovuto mangiarla nel santuario, come io avevo ordinato”. ");
INSERT INTO ita1927_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Ed Aaronne disse a Mosè: “Ecco oggi essi hanno offerto il loro sacrifizio per il peccato e il loro olocausto da vanti all’Eterno; e, dopo le cose che mi son successe, se oggi avessi mangiato la vittima del sacrifizio per il peccato, sarebbe ciò piaciuto all’Eterno?” ");
INSERT INTO ita1927_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Quando Mosè udì questo, rimase soddisfatto. ");
INSERT INTO ita1927_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Poi l’Eterno parlò a Mosè e ad Aaronne, dicendo loro: ");
INSERT INTO ita1927_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Parlate così ai figliuoli d’Israele: Questi sono gli animali che potrete mangiare fra tutte le bestie che sono sulla terra. ");
INSERT INTO ita1927_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Mangerete d’ogni animale che ha l’unghia spartita e ha il piè forcuto, e che rumina. ");
INSERT INTO ita1927_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Ma di fra quelli che ruminano e di fra quelli che hanno l’unghia spartita, non mangerete questi: il cammello, perché rumina, ma non ha l’unghia spartita; lo considererete come impuro; ");
INSERT INTO ita1927_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","il coniglio, perché rumina, ma non ha l’unghia spartita; lo considererete come impuro; ");
INSERT INTO ita1927_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","la lepre, perché rumina, ma non ha l’unghia spartita; la considererete come impura; ");
INSERT INTO ita1927_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","il porco, perché ha l’unghia spartita e il piè forcuto, ma non rumina; lo considererete come impuro. ");
INSERT INTO ita1927_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Non mangerete della loro carne e non toccherete i loro corpo morti; li considererete come impuri. ");
INSERT INTO ita1927_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Questi sono gli animali che potrete mangiare fra tutti quelli che sono nell’acqua. Mangerete tutto ciò che ha pinne e scaglie nelle acque, tanto ne’ i mari quanto ne’ fiumi. ");
INSERT INTO ita1927_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Ma tutto ciò che non ha né pinne né scaglie, tanto ne’ mari quanto ne’ fiumi, fra tutto ciò che si muove nelle acque e tutto ciò che vive nelle acque, l’avrete in abominio. ");
INSERT INTO ita1927_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Essi vi saranno in abominio; non mangerete della loro carne, e avrete in abominio i loro corpi morti. ");
INSERT INTO ita1927_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Tutto ciò che non ha né pinne né scaglie nelle acque vi sarà in abominio. ");
INSERT INTO ita1927_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","E fra gli uccelli avrete in abominio questi: non se ne mangi; sono un abominio: l’aquila, l’ossifraga e l’aquila di mare; ");
INSERT INTO ita1927_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","il nibbio e ogni specie di falco; ");
INSERT INTO ita1927_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ogni specie di corvo; ");
INSERT INTO ita1927_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","lo struzzo, il barbagianni, il gabbiano e ogni specie di sparviere; ");
INSERT INTO ita1927_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","il gufo, lo smergo, l’ibi; ");
INSERT INTO ita1927_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","il cigno, il pellicano, l’avvoltoio; ");
INSERT INTO ita1927_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","la cicogna, ogni specie di airone, l’upupa e il pipistrello. ");
INSERT INTO ita1927_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Vi sarà pure in abominio ogni insetto alato che cammina su quattro piedi. ");
INSERT INTO ita1927_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Però, fra tutti gl’insetti alati che camminano su quattro piedi, mangerete quelli che hanno gambe al disopra de’ piedi per saltare sulla terra. ");
INSERT INTO ita1927_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Di questi potrete mangiare: ogni specie di cavalletta, ogni specie di solam, ogni specie di hargol e ogni specie di hagab. ");
INSERT INTO ita1927_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Ogni altro insetto alato che ha quattro piedi vi sarà in abominio. ");
INSERT INTO ita1927_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Questi animali vi renderanno impuri; chiunque toccherà il loro corpo morto sarà impuro fino alla sera. ");
INSERT INTO ita1927_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","E chiunque porterà i loro corpi morti si laverà le vesti, e sarà impuro fino alla sera. ");
INSERT INTO ita1927_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Considererete come impuro ogni animale che ha l’unghia spartita, ma non ha il piè forcuto, e che non rumina; chiunque lo toccherà sarà impuro. ");
INSERT INTO ita1927_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Considererete come impuri tutti i quadrupedi che camminano sulla pianta de’ piedi; chiunque toccherà il loro corpo morto sarà impuro fino alla sera. ");
INSERT INTO ita1927_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","E chiunque porterà i loro corpi morti si laverà le vesti, e sarà immondo fino alla sera. Questi animali considererete come impuri. ");
INSERT INTO ita1927_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","E fra i piccoli animali che strisciano sulla terra, considererete come impuri questi: la talpa, il topo e ogni specie di lucertola, il toporagno, ");
INSERT INTO ita1927_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","la rana, la tartaruga, la lumaca, il camaleonte. ");
INSERT INTO ita1927_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Questi animali, fra tutto ciò che striscia, saranno impuri per voi; chiunque li toccherà morti, sarà impuro fino alla sera. ");
INSERT INTO ita1927_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Ogni oggetto sul quale cadrà qualcun d’essi quando sarà morto, sarà immondo: siano utensili di legno, o veste, o pelle, o sacco, o qualunque altro oggetto di cui si faccia uso; sarà messo nell’acqua, e sarà impuro fino alla sera; poi sarà puro. ");
INSERT INTO ita1927_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","E se ne cade qualcuno in un vaso di terra, tutto quello che vi si troverà dentro sarà impuro, e spezzerete il vaso. ");
INSERT INTO ita1927_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Ogni cibo che serve al nutrimento, sul quale sarà caduta di quell’acqua, sarà impuro; e ogni bevanda di cui si fa uso, qualunque sia il vaso che la contiene, sarà impura. ");
INSERT INTO ita1927_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Ogni oggetto sul quale cadrà qualcosa del loro corpo morto, sarà impuro; il forno o il fornello sarà spezzato; sono impuri, e li considererete come impuri. ");
INSERT INTO ita1927_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Però, una fonte o una cisterna, dov’è una raccolta d’acqua, sarà pura; ma chi toccherà i loro corpi morti sarà impuro. ");
INSERT INTO ita1927_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","E se qualcosa de’ loro corpi morti cade su qualche seme che dev’esser seminato, questo sarà puro; ");
INSERT INTO ita1927_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","ma se è stata messa dell’acqua sul seme, e vi cade su qualcosa de’ loro corpi morti, lo considererai come impuro. ");
INSERT INTO ita1927_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Se muore un animale di quelli che vi servono per nutrimento, colui che ne toccherà il corpo morto sarà impuro fino alla sera. ");
INSERT INTO ita1927_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Colui che mangerà di quel corpo morto si laverà le vesti, e sarà impuro fino alla sera; parimente colui che porterà quel corpo morto si laverà le vesti, e sarà impuro fino alla sera. ");
INSERT INTO ita1927_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Ogni cosa che brulica sulla terra è un abominio; non se ne mangerà. ");
INSERT INTO ita1927_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Di tutti gli animali che brulicano sulla terra non ne mangerete alcuno che strisci sul ventre o cammini con quattro piedi o con molti piedi, poiché sono un abominio. ");
INSERT INTO ita1927_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Non rendete le vostre persone abominevoli mediante alcuno di questi animali che strisciano; e non vi rendete impuri per loro mezzo, in guisa da rimaner così contaminati. ");
INSERT INTO ita1927_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Poiché io sono l’Eterno, l’Iddio vostro; santificatevi dunque e siate santi, perché io son santo; e non contaminate le vostre persone mediante alcuno di questi animali che strisciano sulla terra. ");
INSERT INTO ita1927_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Poiché io sono l’Eterno che vi ho fatti salire dal paese d’Egitto, per essere il vostro Dio; siate dunque santi, perché io son santo. ");
INSERT INTO ita1927_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Questa è la legge concernente i quadrupedi, gli uccelli, ogni essere vivente che si muove nelle acque e ogni essere che striscia sulla terra, ");
INSERT INTO ita1927_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","affinché sappiate discernere ciò ch’è impuro da ciò ch’è puro, l’animale che si può mangiare da quello che non si deve mangiare”. ");
INSERT INTO ita1927_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","L’Eterno parlò ancora a Mosè, dicendo: “Parla così ai figliuoli d’Israele: ");
INSERT INTO ita1927_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Quando una donna sarà rimasta incinta e partorirà un maschio, sarà impura sette giorni; sarà impura come nel tempo de’ suoi corsi mensuali. ");
INSERT INTO ita1927_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","L’ottavo giorno si circonciderà la carne del prepuzio del bambino. ");
INSERT INTO ita1927_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Poi, ella resterà ancora trentatre giorni a purificarsi del suo sangue; non toccherà alcuna cosa santa, e non entrerà nel santuario finché non siano compiuti i giorni della sua purificazione. ");
INSERT INTO ita1927_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Ma, se partorisce una bambina, sarà impura due settimane come al tempo de’ suoi corsi mensuali; e resterà sessantasei giorni a purificarsi del suo sangue. ");
INSERT INTO ita1927_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","E quando i giorni della sua purificazione, per un figliuolo o per una figliuola, saranno compiuti, porterà al sacerdote, all’ingresso della tenda di convegno, un agnello d’un anno come olocausto, e un giovane piccione o una tortora come sacrifizio per il peccato; ");
INSERT INTO ita1927_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","e il sacerdote li offrirà davanti all’Eterno e farà l’espiazione per lei; ed ella sarà purificata del flusso del suo sangue. Questa è la legge relativa alla donna che partorisce un maschio o una femmina. ");
INSERT INTO ita1927_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","E se non ha mezzi da offrire un agnello, prenderà due tortore o due giovani piccioni: uno per l’olocausto, e l’altro per il sacrifizio per il peccato. Il sacerdote farà l’espiazione per lei, ed ella sarà pura”. ");
INSERT INTO ita1927_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","L’Eterno parlò ancora a Mosè e ad Aaronne, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Quand’uno avrà sulla pelle del suo corpo un tumore o una pustola o una macchia lucida che sia sintomo di piaga di lebbra sulla pelle del suo corpo, quel tale sarà menato al sacerdote Aaronne o ad uno de’ suoi figliuoli sacerdoti. ");
INSERT INTO ita1927_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Il sacerdote esaminerà la piaga sulla pelle del corpo; e se il pelo della piaga è diventato bianco, e la piaga appare più profonda della pelle del corpo, è piaga di lebbra; e il sacerdote che l’avrà esaminato, dichiarerà quell’uomo impuro. ");
INSERT INTO ita1927_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Ma se la macchia lucida sulla pelle del corpo e bianca, e non appare esser più profonda della pelle, e il suo pelo non è diventato bianco, il sacerdote rinchiuderà per sette giorni colui che ha la piaga. ");
INSERT INTO ita1927_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Il sacerdote, il settimo giorno, l’esaminerà; e se gli parrà che la piaga si sia fermata e non si sia allargata sulla pelle, il sacerdote lo rinchiuderà altri sette giorni. ");
INSERT INTO ita1927_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Il sacerdote, il settimo giorno, lo esaminerà di nuovo; e se vedrà che la piaga non è più lucida e non s’è allargata sulla pelle, il sacerdote dichiarerà quell’uomo puro: è una pustola. Quel tale laverà le sue vesti, e sarà puro. ");
INSERT INTO ita1927_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Ma se la pustola s’è allargata sulla pelle dopo ch’egli s’è mostrato al sacerdote per esser dichiarato puro, si farà esaminare per la seconda volta dal sacerdote; ");
INSERT INTO ita1927_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","il sacerdote l’esaminerà; e se vedrà che la pustola si è allargata sulla pelle, il sacerdote lo dichiarerà impuro; è lebbra. ");
INSERT INTO ita1927_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Quand’uno avrà addosso una piaga di lebbra, sarà menato al sacerdote. ");
INSERT INTO ita1927_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Il sacerdote lo esaminerà; e se vedrà che sulla pelle c’è un tumor bianco, che questo tumore ha fatto imbiancare il pelo e che v’è nel tumore della carne viva, ");
INSERT INTO ita1927_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","è lebbra inveterata nella pelle del corpo di colui, e il sacerdote lo dichiarerà impuro; non lo rinchiuderà, perché è impuro. ");
INSERT INTO ita1927_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","E se la lebbra produce delle efflorescenze sulla pelle in modo da coprire tutta la pelle di colui che ha la piaga, dal capo ai piedi, dovunque il sacerdote guardi, ");
INSERT INTO ita1927_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","il sacerdote lo esaminerà; e quando avrà veduto che la lebbra copre tutto il corpo, dichiarerà puro colui che ha la piaga. Egli è divenuto tutto quanto bianco, quindi è puro. ");
INSERT INTO ita1927_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ma dal momento che apparirà in lui della carne viva, sarà dichiarato impuro. ");
INSERT INTO ita1927_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Quando il sacerdote avrà visto la carne viva, dichiarerà quell’uomo impuro; la carne viva è impura; è lebbra. ");
INSERT INTO ita1927_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Ma se la carne viva ridiventa bianca, vada colui al sacerdote, e il sacerdote lo esaminerà; ");
INSERT INTO ita1927_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","e se vedrà che la piaga è ridiventata bianca, il sacerdote dichiarerà puro colui che ha la piaga: è puro. ");
INSERT INTO ita1927_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Quand’uno avrà avuto sulla pelle della carne un’ulcera che sia guarita, ");
INSERT INTO ita1927_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","e poi, sul luogo dell’ulcera apparirà un tumor bianco o una macchia lucida, bianca, tendente al rosso, quel tale si mostrerà al sacerdote. ");
INSERT INTO ita1927_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Il sacerdote l’esaminerà; e se vedrà che la macchia apparisce più profonda della pelle e che il pelo n’è diventato bianco, il sacerdote lo dichiarerà impuro; è piaga di lebbra che è scoppiata nell’ulcera. ");
INSERT INTO ita1927_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Ma se il sacerdote, esaminandola, vede che nella macchia non ci sono peli bianchi e che non è più profonda della pelle e non è più lucida, il sacerdote lo rinchiuderà sette giorni. ");
INSERT INTO ita1927_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","E se la macchia s’allarga sulla pelle, il sacerdote lo dichiarerà impuro; è piaga di lebbra. ");
INSERT INTO ita1927_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Ma se la macchia è rimasta allo stesso punto e non si e allargata, è la cicatrice dell’ulcera, e il sacerdote lo dichiarerà puro. ");
INSERT INTO ita1927_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Quand’uno avrà sulla pelle del suo corpo una bruciatura cagionata dal fuoco, e su questa bruciatura apparirà una macchia lucida, bianca, tendente al rosso o soltanto bianca, ");
INSERT INTO ita1927_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","il sacerdote l’esaminerà; e se vedrà che il pelo della macchia è diventato bianco e la macchia appare più profonda della pelle, è lebbra scoppiata nella bruciatura. Il sacerdote dichiarerà quel tale impuro; è piaga di lebbra. ");
INSERT INTO ita1927_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Ma se il sacerdote, esaminandola, vede che non c’è pelo bianco nella macchia, e ch’essa non è più profonda della pelle e non è più lucida, il sacerdote lo rinchiuderà sette giorni. ");
INSERT INTO ita1927_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Il sacerdote, il settimo giorno, l’esaminerà; e se la macchia s’è allargata sulla pelle, il sacerdote dichiarerà quel tale impuro; è piaga di lebbra. ");
INSERT INTO ita1927_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","E se la macchia è rimasta ferma nello stesso luogo, e non si è allargata sulla pelle, e non è più lucida, è il tumore della bruciatura; il sacerdote dichiarerà quel tale puro, perch’è la cicatrice della bruciatura. ");
INSERT INTO ita1927_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Quand’un uomo o una donna avrà una piaga sul capo o nella barba, ");
INSERT INTO ita1927_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","il sacerdote esaminerà la piaga; e se vedrà ch’essa appare più profonda della pelle e che v’è del pelo gialliccio e sottile, il sacerdote li dichiarerà impuri; è tigna, è lebbra del capo o della barba. ");
INSERT INTO ita1927_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","E se il sacerdote, esaminando la piaga della tigna, vedrà che non appare più profonda della pelle e che non v’è pelo nero, il sacerdote rinchiuderà sette giorni colui che ha la piaga della tigna. ");
INSERT INTO ita1927_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","E se il sacerdote, esaminando il settimo giorno la piaga, vedrà che la tigna non s’è allargata, e che non v’è pelo giallo, e che la tigna non appare più profonda della pelle, ");
INSERT INTO ita1927_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","quel tale si raderà, ma non raderà il luogo dov’è la tigna; e il sacerdote rinchiuderà altri sette giorni colui che ha la tigna. ");
INSERT INTO ita1927_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Il sacerdote, il settimo giorno, esaminerà la tigna; e se vedrà che la tigna non s’è allargata sulla pelle e non appare più profonda della pelle, il sacerdote dichiarerà quel tale puro; colui si laverà le vesti, e sarà puro. ");
INSERT INTO ita1927_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Ma se, dopo ch’egli e stato dichiarato puro, la tigna s’è allargata sulla pelle, ");
INSERT INTO ita1927_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","il sacerdote l’esaminerà; e se vedrà che la tigna s’è allargata sulla pelle, il sacerdote non cercherà se v’è del pelo giallo; quel tale è impuro. ");
INSERT INTO ita1927_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ma se vedrà che la tigna s’è fermata e che v’è cresciuto del pelo nero, la tigna è guarita; quel tale è puro, e il sacerdote lo dichiarerà puro. ");
INSERT INTO ita1927_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Quand’un uomo o una donna avrà sulla pelle del suo corpo delle macchie lucide, delle macchie bianche, ");
INSERT INTO ita1927_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","il sacerdote l’esaminerà; e se vedrà che le macchie sulla pelle del loro corpo sono di un bianco pallido, è una eruzione cutanea; quel tale è puro. ");
INSERT INTO ita1927_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Colui al quale son cascati i capelli del capo è calvo, ma è puro. ");
INSERT INTO ita1927_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Se i capelli gli son cascati dalla parte della faccia, è calvo di fronte, ma è puro. ");
INSERT INTO ita1927_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Ma se sulla parte calva del di dietro o del davanti del capo appare una piaga bianca tendente al rosso, è lebbra, scoppiata nella parte calva del di dietro o del davanti del capo. ");
INSERT INTO ita1927_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Il sacerdote lo esaminerà; e se vedrà che il tumore della piaga nella parte calva del di dietro o del davanti del capo è bianca tendente al rosso, simile alla lebbra della pelle del corpo, ");
INSERT INTO ita1927_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","quel tale è un lebbroso; è impuro, e il sacerdote lo dovrà dichiarare impuro; egli ha la sua piaga sul campo. ");
INSERT INTO ita1927_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Il lebbroso, affetto da questa piaga, porterà le vesti strappate e il capo scoperto; si coprirà la barba, e andrà gridando: Impuro! impuro! ");
INSERT INTO ita1927_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Sarà impuro tutto il tempo che avrà la piaga; è impuro; se ne starà solo; abiterà fuori del campo. ");
INSERT INTO ita1927_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Quando apparirà una piaga di lebbra sopra una veste, sia veste di lana o veste di lino, ");
INSERT INTO ita1927_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","un tessuto o un lavoro a maglia, di lino o di lana, un oggetto di pelle o qualunque altra cosa fatta di pelle, ");
INSERT INTO ita1927_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","se la piaga sarà verdastra o rossastra sulla veste o sulla pelle, sul tessuto, o sulla maglia, o su qualunque cosa fatta di pelle, è piaga di lebbra, e sarà mostrata al sacerdote. ");
INSERT INTO ita1927_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Il sacerdote esaminerà la piaga, e rinchiuderà sette giorni colui che ha la piaga. ");
INSERT INTO ita1927_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Il settimo giorno esaminerà la piaga; e se la piaga si sarà allargata sulla veste o sul tessuto o sulla maglia o sulla pelle o sull’oggetto fatto di pelle per un uso qualunque, è una piaga di lebbra maligna; è cosa impura. ");
INSERT INTO ita1927_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Egli brucerà quella veste o il tessuto o la maglia di lana o di lino o qualunque oggetto fatto di pelle, sul quale è la piaga; perché è lebbra maligna; saran bruciati col fuoco. ");
INSERT INTO ita1927_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","E se il sacerdote, esaminandola, vedrà che la piaga non s’è allargata sulla veste o sul tessuto o sulla maglia o sull’oggetto qualunque di pelle, ");
INSERT INTO ita1927_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","il sacerdote ordinerà che si lavi l’oggetto su cui è la piaga, e lo rinchiuderà altri sette giorni. ");
INSERT INTO ita1927_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Il sacerdote esaminerà la piaga, dopo che sarà stata lavata; e se vedrà che la piaga non ha mutato colore, benché non si sia allargata, è un oggetto immondo; lo brucerai col fuoco; v’è corrosione, sia che la parte corrosa si trovi sul diritto o sul rovescio dell’oggetto. ");
INSERT INTO ita1927_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","E se il sacerdote, esaminandola, vede che la piaga, dopo essere stata lavata, è diventata pallida, la strapperà dalla veste o dalla pelle o dal tessuto o dalla maglia. ");
INSERT INTO ita1927_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","E se apparisce ancora sulla veste o sul tessuto o sulla maglia o sull’oggetto qualunque fatto di pelle, è una eruzione lebbrosa; brucerai col fuoco l’oggetto su cui e la piaga. ");
INSERT INTO ita1927_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","La veste o il tessuto o la maglia o qualunque oggetto fatto di pelle che avrai lavato e dal quale la piaga sarà scomparsa, si laverà una seconda volta, e sarà puro. ");
INSERT INTO ita1927_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Questa è la legge relativa alla piaga di lebbra sopra una veste di lana o di lino, sul tessuto o sulla maglia o su qualunque oggetto fatto di pelle, per dichiararli puri o impuri”. ");
INSERT INTO ita1927_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Questa è la legge relativa al lebbroso per il giorno della sua purificazione. Egli sarà menato al sacerdote. ");
INSERT INTO ita1927_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Il sacerdote uscirà dal campo, e l’esaminerà; e se vedrà che la piaga della lebbra è guarita nel lebbroso, ");
INSERT INTO ita1927_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","il sacerdote ordinerà che si prendano, per colui che dev’esser purificato, due uccelli vivi, puri, del legno di cedro, dello scarlatto e dell’issopo. ");
INSERT INTO ita1927_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Il sacerdote ordinerà che si sgozzi uno degli uccelli in un vaso di terra su dell’acqua viva. ");
INSERT INTO ita1927_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Poi prenderà l’uccello vivo, il legno di cedro, lo scarlatto e l’issopo, e l’immergerà, con l’uccello vivo, nel sangue dell’uccello sgozzato sopra l’acqua viva. ");
INSERT INTO ita1927_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Ne aspergerà sette volte colui che dev’esser purificato dalla lebbra; lo dichiarerà puro, e lascerà andar libero per i campi l’uccello vivo. ");
INSERT INTO ita1927_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Colui che si purifica si laverà le vesti, si raderà tutti i peli, si laverà nell’acqua, e sarà puro. Dopo questo potrà entrar nel campo, ma resterà sette giorni fuori della sua tenda. ");
INSERT INTO ita1927_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Il settimo giorno si raderà tutti i peli, il capo, la barba, le ciglia: si raderà insomma tutti i peli, si laverà le vesti e si laverà il corpo nell’acqua, e sarà puro. ");
INSERT INTO ita1927_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","L’ottavo giorno prenderà due agnelli senza difetto, un’agnella d’un anno senza difetto, tre decimi d’un efa di fior di farina, una oblazione, intrisa con olio, e un log d’olio; ");
INSERT INTO ita1927_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","e il sacerdote che fa la purificazione, presenterà colui che si purifica e quelle cose davanti all’Eterno, all’ingresso della tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Poi il sacerdote prenderà uno degli agnelli e l’offrirà come sacrifizio di riparazione, con il log d’olio, e li agiterà come offerta agitata davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Poi scannerà l’agnello nel luogo dove si scannano i sacrifizi per il peccato e gli olocausti: vale a dire, nel luogo sacro; poiché il sacrifizio di riparazione appartiene al sacerdote, come quello per il peccato; è cosa santissima. ");
INSERT INTO ita1927_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","E il sacerdote prenderà del sangue del sacrifizio di riparazione e lo metterà sull’estremità dell’orecchio destro di colui che si purifica, sul pollice della sua man destra e sul dito grosso del suo piedi destro. ");
INSERT INTO ita1927_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Poi il sacerdote prenderà dell’olio del log, e lo verserà nella palma della sua mano sinistra; ");
INSERT INTO ita1927_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","quindi il sacerdote intingerà il dito della sua destra nell’olio che avrà nella sinistra, e col dito farà sette volte aspersione di quell’olio davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","E del rimanente dell’olio che avrà in mano, il sacerdote ne metterà sull’estremità dell’orecchio destro di colui che si purifica, sul pollice della sua man destra e sul dito grosso del suo piede destro, oltre al sangue del sacrifizio di riparazione. ");
INSERT INTO ita1927_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Il resto dell’olio che avrà in mano, il sacerdote lo metterà sul capo di colui che si purifica; e il sacerdote farà per lui l’espiazione davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Poi il sacerdote offrirà il sacrifizio per il peccato, e farà l’espiazione per colui che si purifica della sua impurità; quindi, scannerà l’olocausto. ");
INSERT INTO ita1927_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Il sacerdote offrirà l’olocausto e l’oblazione sull’altare; farà per quel tale l’espiazione, ed egli sarà puro. ");
INSERT INTO ita1927_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Se colui è povero e non può procurarsi quel tanto, prenderà un solo agnello da offrire in sacrifizio di riparazione come offerta agitata, per fare l’espiazione per lui, e un solo decimo d’un efa di fior di farina intrisa con olio, come oblazione, e un log d’olio. ");
INSERT INTO ita1927_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Prenderà pure due tortore o due giovani piccioni, secondo i suoi mezzi; uno sarà per il sacrifizio per il peccato, e l’altro per l’olocausto. ");
INSERT INTO ita1927_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","L’ottavo giorno porterà, per la sua purificazione, queste cose al sacerdote, all’ingresso della tenda di convegno, davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","E il sacerdote prenderà l’agnello del sacrifizio di riparazione e il log d’olio, e li agiterà come offerta agitata davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Poi scannerà l’agnello del sacrifizio di riparazione. Il sacerdote prenderà del sangue del sacrifizio di riparazione, e lo metterà sull’estremità dell’orecchio destro di colui che si purifica, e sul pollice della sua man destra e sul dito grosso del suo piede destro. ");
INSERT INTO ita1927_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Il sacerdote verserà di quell’olio sulla palma della sua mano sinistra. ");
INSERT INTO ita1927_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","E col dito della sua man destra il sacerdote farà aspersione dell’olio che avrà nella mano sinistra, sette volte davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Poi il sacerdote metterà dell’olio che avrà in mano, sull’estremità dell’orecchio destro di colui che si purifica, sul pollice della sua man destra e sul dito grosso del suo piede destro, nel luogo dove ha messo del sangue del sacrifizio di riparazione. ");
INSERT INTO ita1927_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Il resto dell’olio che avrà in mano, il sacerdote lo metterà sul capo di colui che si purifica, per fare espiazione per lui davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Poi sacrificherà una delle tortore o uno dei due giovani piccioni, secondo che ha potuto procurarsi; ");
INSERT INTO ita1927_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","delle vittime che ha potuto procurarsi, una offrirà come sacrifizio per il peccato, e l’altra come olocausto, insieme con l’oblazione; e il sacerdote farà l’espiazione davanti all’Eterno per colui che si purifica. ");
INSERT INTO ita1927_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Questa è la legge relativa a colui ch’è affetto da piaga di lebbra, e non ha mezzi da procurarsi ciò ch’è richiesto per la sua purificazione”. ");
INSERT INTO ita1927_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","L’Eterno parlò ancora a Mosè e ad Aaronne, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Quando sarete entrati nel paese di Canaan che io vi do come vostro possesso, se mando la piaga della lebbra in una casa del paese che sarà vostro possesso, ");
INSERT INTO ita1927_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","il padrone della casa andrà a dichiararlo al sacerdote, dicendo: Mi pare che in casa mia ci sia qualcosa di simile alla lebbra. ");
INSERT INTO ita1927_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Allora il sacerdote ordinerà che si sgomberi la casa prima ch’egli v’entri per esaminare la piaga, affinché tutto quello che è nella casa non diventi impuro. Dopo questo, il sacerdote entrerà per esaminar la casa. ");
INSERT INTO ita1927_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Ed esaminerà la piaga; e se vedrà che la piaga che è sui muri della casa consiste in fossette verdastre o rossastre che appaiano più profonde della superficie della parete, ");
INSERT INTO ita1927_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","il sacerdote uscirà dalla casa; e, giunto alla porta, farà chiudere la casa per sette giorni. ");
INSERT INTO ita1927_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Il settimo giorno, il sacerdote vi tornerà; e se, esaminandola, vedrà che la piaga s’è allargata sulle pareti della casa, ");
INSERT INTO ita1927_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","il sacerdote ordinerà che se ne smurino le pietre sulle quali è la piaga, e che si gettino in luogo immondo, fuor di città. ");
INSERT INTO ita1927_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Farà raschiare tutto l’interno della casa, e butteranno i calcinacci raschiati fuor di città, in luogo impuro. ");
INSERT INTO ita1927_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Poi si prenderanno delle altre pietre e si metteranno al posto delle prime, e si prenderà dell’altra calcina per intonacare la casa. ");
INSERT INTO ita1927_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","E se la piaga torna ed erompe nella casa dopo averne smurate le pietre e dopo che la casa è stata raschiata e rintonacata, ");
INSERT INTO ita1927_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","il sacerdote entrerà ad esaminare la casa; e se vedrà che la piaga vi s’è allargata, nella casa c’è della lebbra maligna; la casa è impura. ");
INSERT INTO ita1927_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Perciò si demolirà la casa; e se ne porteranno le pietre, il legname e i calcinacci fuori della città, in luogo impuro. ");
INSERT INTO ita1927_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Inoltre, chiunque sarà entrato in quella casa durante tutto il tempo che è stata chiusa, sarà impuro fino alla sera. ");
INSERT INTO ita1927_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Chi avrà dormito in quella casa, si laverà le vesti; e chi avrà mangiato in quella casa, si laverà le vesti. ");
INSERT INTO ita1927_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","E se il sacerdote che è entrato nella casa e l’ha esaminata vede che la piaga non s’è allargata nella casa dopo che la casa è stata rintonacata, il sacerdote dichiarerà la casa pura, perché la piaga è guarita. ");
INSERT INTO ita1927_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Poi, per purificare la casa, prenderà due uccelli, del legno di cedro, dello scarlatto e dell’issopo; ");
INSERT INTO ita1927_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","sgozzerà uno degli uccelli in un vaso di terra su dell’acqua viva; ");
INSERT INTO ita1927_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","e prenderà il legno di cedro, l’issopo, lo scarlatto e l’uccello vivo, e l’immergerà nel sangue dell’uccello sgozzato e nell’acqua viva, e ne aspergerà sette volte la casa. ");
INSERT INTO ita1927_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","E purificherà la casa col sangue dell’uccello, dell’acqua viva, dell’uccello vivo, col legno di cedro, con l’issopo e con lo scarlatto; ");
INSERT INTO ita1927_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ma lascerà andar libero l’uccello vivo, fuor di città, per i campi; e così farà l’espiazione per la casa ed essa sarà pura. ");
INSERT INTO ita1927_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Questa è la legge relativa a ogni sorta di piaga di lebbra e alla tigna, ");
INSERT INTO ita1927_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","alla lebbra delle vesti e della casa, ");
INSERT INTO ita1927_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ai tumori, alle pustole e alle macchie lucide, ");
INSERT INTO ita1927_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","per insegnare quando una cosa è impura e quando è pura. Questa è la legge relativa alla lebbra”. ");
INSERT INTO ita1927_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","L’Eterno parlò ancora a Mosè e ad Aaronne, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Parlate ai figliuoli d’Israele e dite loro: Chiunque ha una gonorrea, a motivo della sua gonorrea è impuro. ");
INSERT INTO ita1927_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","La sua impurità sta nella sua gonorrea; sia la sua gonorrea continua o intermittente, la impurità esiste. ");
INSERT INTO ita1927_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Ogni letto sul quale si coricherà colui che ha la gonorrea, sarà impuro; e ogni oggetto sul quale si sederà sarà impuro. ");
INSERT INTO ita1927_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Chi toccherà il letto di colui si laverà le vesti, laverà se stesso nell’acqua, e sarà impuro fino alla sera. ");
INSERT INTO ita1927_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Chi si sederà sopra un oggetto qualunque sul quale si sia seduto colui che ha la gonorrea, si laverà le vesti, laverà se stesso nell’acqua, e sarà impuro fino alla sera. ");
INSERT INTO ita1927_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Chi toccherà il corpo di colui che ha la gonorrea, si laverà le vesti, laverà se stesso nell’acqua, e sarà impuro fino alla sera. ");
INSERT INTO ita1927_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Se colui che ha la gonorrea sputerà sopra uno che è puro, questi si laverà le vesti, laverà se stesso nell’acqua, e sarà impuro fino alla sera. ");
INSERT INTO ita1927_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Ogni sella su cui sarà salito chi ha la gonorrea, sarà impura. ");
INSERT INTO ita1927_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Chiunque toccherà qualsivoglia cosa che sia stata sotto quel tale, sarà impuro fino alla sera. E chi porterà cotali oggetti si laverà le vesti, laverà se stesso nell’acqua, e sarà impuro sino alla sera. ");
INSERT INTO ita1927_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Chiunque sarà toccato da colui che ha la gonorrea, se questi non s’era lavato le mani, dovrà lavarsi le vesti, lavare se stesso nell’acqua, e sarà immondo fino alla sera. ");
INSERT INTO ita1927_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Il vaso di terra toccato da colui che ha la gonorrea, sarà spezzato; e ogni vaso di legno sarà lavato nell’acqua. ");
INSERT INTO ita1927_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Quando colui che ha la gonorrea sarà purificato della sua gonorrea, conterà sette giorni per la sua purificazione; poi si laverà le vesti, laverà il suo corpo nell’acqua viva, e sarà puro. ");
INSERT INTO ita1927_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","L’ottavo giorno prenderà due tortore o due giovani piccioni, verrà davanti all’Eterno all’ingresso della tenda di convegno, e li darà al sacerdote. ");
INSERT INTO ita1927_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","E il sacerdote li offrirà: uno come sacrifizio per il peccato, l’altro come olocausto; e il sacerdote farà l’espiazione per lui davanti all’Eterno, a motivo della sua gonorrea. ");
INSERT INTO ita1927_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","L’uomo da cui sarà uscito seme genitale si laverà tutto il corpo nell’acqua, e sarà impuro fino alla sera. ");
INSERT INTO ita1927_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Ogni veste e ogni pelle su cui sarà seme genitale, si laveranno nell’acqua e saranno impuri fino alla sera. ");
INSERT INTO ita1927_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","La donna e l’uomo che giaceranno insieme carnalmente, si laveranno ambedue nell’acqua e saranno impuri fino alla sera. ");
INSERT INTO ita1927_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Quando una donna avrà i suoi corsi e il sangue le fluirà dalla carne, la sua impurità durerà sette giorni; e chiunque la toccherà sarà impuro fino alla sera. ");
INSERT INTO ita1927_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Ogni letto sul quale si sarà messa a dormire durante la sua impurità, sarà impuro; e ogni mobile sul quale si sarà messa a sedere, sarà impuro. ");
INSERT INTO ita1927_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Chiunque toccherà il letto di colei si laverà le vesti, laverà se stesso nell’acqua, e sarà impuro fino alla sera. ");
INSERT INTO ita1927_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","E chiunque toccherà qualsivoglia mobile sul quale ella si sarà seduta, si laverà le vesti, laverà se stesso nell’acqua, e sarà impuro fino alla sera. ");
INSERT INTO ita1927_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","E se l’uomo si trovava sul letto o sul mobile dov’ella sedeva quand’è avvenuto il contatto, egli sarà impuro fino alla sera. ");
INSERT INTO ita1927_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","E se un uomo giace con essa, e avvien che lo tocchi la impurità di lei, egli sarà impuro sette giorni; e ogni letto sul quale si coricherà, sarà impuro. ");
INSERT INTO ita1927_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","La donna che avrà un flusso di sangue per parecchi giorni, fuori del tempo de’ suoi corsi, o che avrà questo flusso oltre il tempo de’ suoi corsi, sarà impura per tutto il tempo del flusso, com’è al tempo de’ suoi corsi. ");
INSERT INTO ita1927_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Ogni letto sul quale si coricherà durante tutto il tempo del suo flusso, sarà per lei come il letto sul quale si corica quando ha i suoi corsi; e ogni mobile sul quale si sederà sarà impuro, com’è impuro quand’ella ha i suoi corsi. ");
INSERT INTO ita1927_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","E chiunque toccherà quelle cose sarà immondo; si laverà le vesti, laverà se stesso nell’acqua, e sarà impuro fino alla sera. ");
INSERT INTO ita1927_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","E quand’ella sarà purificata del suo flusso, conterà sette giorni, e poi sarà pura. ");
INSERT INTO ita1927_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","L’ottavo giorno prenderà due tortore o due giovani piccioni, e li porterà al sacerdote all’ingresso della tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","E il sacerdote ne offrirà uno come sacrifizio per il peccato e l’altro come olocausto; il sacerdote farà per lei l’espiazione, davanti all’Eterno, del flusso che la rendeva impura. ");
INSERT INTO ita1927_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Così terrete lontani i figliuoli d’Israele da ciò che potrebbe contaminarli, affinché non muoiano a motivo della loro impurità, contaminando il mio tabernacolo ch’è in mezzo a loro. ");
INSERT INTO ita1927_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Questa è la legge relativa a colui che ha una gonorrea e a colui dal quale è uscito seme genitale che lo rende immondo, ");
INSERT INTO ita1927_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","e la legge relativa a colei che è indisposta a motivo de’ suoi corsi, all’uomo o alla donna che ha un flusso, e all’uomo che si corica con donna impura”. ");
INSERT INTO ita1927_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","L’Eterno parlò a Mosè dopo la morte dei due figliuoli d’Aaronne, i quali morirono quando si presentarono davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","L’Eterno disse a Mosè: “Parla ad Aaronne, tuo fratello, e digli di non entrare in ogni tempo nel santuario, di là dal velo, davanti al propiziatorio che è sull’arca, onde non abbia a morire; poiché io apparirò nella nuvola sul propiziatorio. ");
INSERT INTO ita1927_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Aaronne entrerà nel santuario in questo modo: prenderà un giovenco per un sacrifizio per il peccato, e un montone per un olocausto. ");
INSERT INTO ita1927_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Si metterà la tunica sacra di lino, e porterà sulla carne le brache di lino; si cingerà della cintura di lino, e si porrà in capo la mitra di lino. Questi sono i paramenti sacri; egli l’indosserà dopo essersi lavato il corpo nell’acqua. ");
INSERT INTO ita1927_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Dalla raunanza de’ figliuoli d’Israele prenderà due capri per un sacrifizio per il peccato, e un montone per un olocausto. ");
INSERT INTO ita1927_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Aaronne offrirà il giovenco del sacrifizio per il peccato, che è per sé, e farà l’espiazione per sé e per la sua casa. ");
INSERT INTO ita1927_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Poi prenderà i due capri, e li presenterà davanti all’Eterno all’ingresso della tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","E Aaronne trarrà le sorti per vedere qual de’ due debba essere dell’Eterno e quale di Azazel. ");
INSERT INTO ita1927_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","E Aaronne farà accostare il capro ch’è toccato in sorte all’Eterno, e l’offrirà come sacrifizio per il peccato; ");
INSERT INTO ita1927_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","ma il capro ch’è toccato in sorte ad Azazel sarà posto vivo davanti all’Eterno, perché serva a fare l’espiazione e per mandarlo poi ad Azazel nel deserto. ");
INSERT INTO ita1927_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Aaronne offrirà dunque il giovenco del sacrifizio per il peccato per sé, e farà l’espiazione per sé e per la sua casa; e scannerà il giovenco del sacrifizio per il peccato per sé. ");
INSERT INTO ita1927_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Poi prenderà un turibolo pieno di carboni accesi tolti di sopra all’altare davanti all’Eterno, e due manate piene di profumo fragrante polverizzato; e porterà ogni cosa di là dal velo. ");
INSERT INTO ita1927_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Metterà il profumo sul fuoco davanti all’Eterno, affinché il nuvolo del profumo copra il propiziatorio che è sulla testimonianza, e non morrà. ");
INSERT INTO ita1927_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Poi prenderà del sangue del giovenco, e ne aspergerà col dito il propiziatorio dal lato d’oriente, e farà sette volte l’aspersione del sangue col dito, davanti al propiziatorio. ");
INSERT INTO ita1927_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Poi scannerà il capro del sacrifizio per il peccato, che è per il popolo, e ne porterà il sangue di là dal velo; e farà di questo sangue quello che ha fatto del sangue del giovenco: ne farà l’aspersione sul propiziatorio e davanti al propiziatorio. ");
INSERT INTO ita1927_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Così farà l’espiazione per il santuario, a motivo delle impurità dei figliuoli d’Israele, delle loro trasgressioni e di tutti i loro peccati. Lo stesso farà per la tenda di convegno ch’è stabilita fra loro, in mezzo alle loro impurità. ");
INSERT INTO ita1927_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","E nella tenda di convegno, quand’egli entrerà nel santuario per farvi l’espiazione, non ci sarà alcuno, finch’egli non sia uscito e non abbia fatto l’espiazione per sé, per la sua casa e per tutta la raunanza d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Egli uscirà verso l’altare ch’è davanti all’Eterno, e farà l’espiazione per esso; prenderà del sangue del giovenco e del sangue del capro, e lo metterà sui corni dell’altare tutto all’intorno. ");
INSERT INTO ita1927_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","E farà sette volte l’aspersione del sangue col dito, sopra l’altare, e così lo purificherà e lo santificherà a motivo delle impurità dei figliuoli d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","E quando avrà finito di fare l’espiazione per il santuario, per la tenda di convegno e per l’altare, farà accostare il capro vivo. ");
INSERT INTO ita1927_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aaronne poserà ambedue le mani sui capo del capro vivo, confesserà sopra esso tutte le iniquità dei figliuoli d’Israele, tutte le loro trasgressioni, tutti i loro peccati, e li metterà sulla testa del capro; poi, per mano di un uomo incaricato di questo, lo manderà via nel deserto. ");
INSERT INTO ita1927_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","E quel capro porterà su di sé tutte le loro iniquità in terra solitaria, e sarà lasciato andare nel deserto. ");
INSERT INTO ita1927_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Poi Aaronne entrerà nella tenda di convegno, si spoglierà delle vesti di lino che aveva indossate per entrar nel santuario, e le deporrà quivi. ");
INSERT INTO ita1927_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Si laverà il corpo nell’acqua in un luogo santo, si metterà i suoi paramenti, e uscirà ad offrire il suo olocausto e l’olocausto del popolo, e farà l’espiazione per sé e per il popolo. ");
INSERT INTO ita1927_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","E farà fumare sull’altare il grasso del sacrifizio per il peccato. ");
INSERT INTO ita1927_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Colui che avrà lasciato andare il capro destinato ad Azazel si laverà le vesti, laverà il suo corpo nell’acqua, e dopo questo rientrerà nel campo. ");
INSERT INTO ita1927_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","E si porterà fuori del campo il giovenco del sacrifizio per il peccato e il capro del sacrifizio per il peccato, il cui sangue sarà stato portato nel santuario per farvi l’espiazione; e se ne bruceranno nel fuoco le pelli, la carne e gli escrementi. ");
INSERT INTO ita1927_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Poi colui che li avrà bruciati si laverà le vesti e laverà il suo corpo nell’acqua; dopo questo, rientrerà nel campo. ");
INSERT INTO ita1927_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Questa sarà per voi una legge perpetua: nel settimo mese, il decimo giorno del mese, umilierete le anime vostre, non farete lavoro di sorta, né colui ch’è nativo del paese, né il forestiero che soggiorna fra voi. ");
INSERT INTO ita1927_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Poiché in quel giorno si farà l’espiazione per voi, affin di purificarvi; voi sarete purificati da tutti i vostri peccati, davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","E’ per voi un sabato di riposo solenne, e voi umilierete le anime vostre; è una legge perpetua. ");
INSERT INTO ita1927_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","E il sacerdote che ha ricevuto l’unzione ed è stato consacrato per esercitare il sacerdozio al posto di suo padre, farà l’espiazione; si vestirà delle vesti di lino, de’ paramenti sacri. ");
INSERT INTO ita1927_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","E farà l’espiazione per il santuario sacro; farà l’espiazione per la tenda di convegno e per l’altare; farà l’espiazione per i sacerdoti e per tutto il popolo della raunanza. ");
INSERT INTO ita1927_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Questa sarà per voi una legge perpetua, per fare una volta all’anno, per i figliuoli d’Israele, l’espiazione di tutti i loro peccati”. E si fece come l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","L’Eterno parlò ancora a Mosè dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Parla ad Aaronne, ai suoi figliuoli e a tutti i figliuoli d’Israele e di’ loro: Questo è quello che l’Eterno ha ordinato, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Se un uomo qualunque della casa d’Israele scanna un bue o un agnello o una capra entro il campo, o fuori del campo, ");
INSERT INTO ita1927_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","e non lo mena all’ingresso della tenda di convegno per presentarlo come offerta all’Eterno davanti al tabernacolo dell’Eterno, sarà considerato come colpevole di delitto di sangue; ha sparso del sangue, e cotest’uomo sarà sterminato di fra il suo popolo, ");
INSERT INTO ita1927_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","affinché i figliuoli d’Israele, invece d’immolare, come fanno, i loro sacrifizi nei campi, li rechino all’Eterno presentandoli al sacerdote, all’ingresso della tenda di convegno, e li offrano all’Eterno come sacrifizi di azioni di grazie. ");
INSERT INTO ita1927_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Il sacerdote ne spanderà il sangue sull’altare dell’Eterno, all’ingresso della tenda di convegno, e farà fumare il grasso come un profumo soave all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Ed essi non offriranno più i loro sacrifizi ai demoni, ai quali sogliono prostituirsi. Questa sarà per loro una legge perpetua, di generazione in generazione. ");
INSERT INTO ita1927_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Di’ loro ancora: Se un uomo qualunque della casa d’Israele o degli stranieri che soggiornano fra loro offrirà un olocausto o un sacrifizio, ");
INSERT INTO ita1927_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","e non lo porterà all’ingresso della tenda di convegno per immolarlo all’Eterno, cotest’uomo sarà sterminato di fra il suo popolo. ");
INSERT INTO ita1927_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Se un uomo qualunque della casa d’Israele o degli stranieri che soggiornano fra loro mangia di qualsivoglia specie di sangue, io volgerò la mia faccia contro la persona che avrà mangiato del sangue, e la sterminerò di fra il suo popolo. ");
INSERT INTO ita1927_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Poiché la vita della carne è nel sangue. Per questo vi ho ordinato di porlo sull’altare per far l’espiazione per le vostre persone; perché il sangue è quello che fa l’espiazione, mediante la vita. ");
INSERT INTO ita1927_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Perciò ho detto ai figliuoli d’Israele: Nessuno tra voi mangerà del sangue; neppure lo straniero che soggiorna fra voi mangerà del sangue. ");
INSERT INTO ita1927_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","E se uno qualunque de’ figliuoli d’Israele o degli stranieri che soggiornano fra loro prende alla caccia un quadrupede o un uccello che si può mangiare, ne spargerà il sangue e lo coprirà di polvere; ");
INSERT INTO ita1927_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","perché la vita d’ogni carne è il sangue; nel sangue suo sta la vita; perciò ho detto ai figliuoli d’Israele: Non mangerete sangue d’alcuna specie di carne, poiché il sangue è la vita d’ogni carne; chiunque ne mangerà sarà sterminato. ");
INSERT INTO ita1927_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","E qualunque persona, sia essa nativa del paese o straniera, che mangerà carne di bestia morta da sé o sbranata, si laverà le vesti, laverà sé stesso nell’acqua, e sarà impuro fino alla sera; poi sarà puro. ");
INSERT INTO ita1927_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ma se non si lava le vesti e se non lava il suo corpo, porterà la pena della sua iniquità”. ");
INSERT INTO ita1927_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","L’Eterno parlò ancora a Mosè dicendo: “Parla ai figliuoli d’Israele, e di’ loro: ");
INSERT INTO ita1927_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Io sono l’Eterno, l’Iddio vostro. ");
INSERT INTO ita1927_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Non farete quel che si fa nel paese d’Egitto dove avete abitato, e non farete quel che si fa nel paese di Canaan dove io vi conduco, e non seguirete i loro costumi. ");
INSERT INTO ita1927_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Metterete in pratica le mie prescrizioni e osserverete le mie leggi, per conformarvi ad esse. Io sono l’Eterno, l’Iddio vostro. ");
INSERT INTO ita1927_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Osserverete le mie leggi e le mie prescrizioni, mediante le quali chiunque le metterà in pratica, vivrà. Io sono l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Nessuno si accosterà ad alcuna sua parente carnale per scoprire la sua nudità. Io sono l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Non scoprirai la nudità di tuo padre, né la nudità di tua madre: è tua madre; non scoprirai la sua nudità. ");
INSERT INTO ita1927_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Non scoprirai la nudità della moglie di tuo padre: è la nudità di tuo padre. ");
INSERT INTO ita1927_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Non scoprirai la nudità della tua sorella, figliuola di tuo padre o figliuola di tua madre, sia essa nata in casa o nata fuori. ");
INSERT INTO ita1927_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Non scoprirai la nudità della figliuola del tuo figliuolo o della figliuola della tua figliuola, poiché è la tua propria nudità. ");
INSERT INTO ita1927_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Non scoprirai la nudità della figliuola della moglie di tuo padre, generata da tuo padre: è tua sorella. ");
INSERT INTO ita1927_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Non scoprirai la nudità della sorella di tuo padre; è parente stretta di tuo padre. ");
INSERT INTO ita1927_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Non scoprirai la nudità della sorella di tua madre, perch’è parente stretta di tua madre. ");
INSERT INTO ita1927_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Non scoprirai la nudità del fratello di tuo padre, e non t’accosterai alla sua moglie: è tua zia. ");
INSERT INTO ita1927_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Non scoprirai la nudità della tua nuora: è la moglie del tuo figliuolo; non scoprire la sua nudità. ");
INSERT INTO ita1927_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Non scoprirai la nudità della moglie di tuo fratello: è la nudità di tuo fratello. ");
INSERT INTO ita1927_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Non scoprirai la nudità di una donna e della sua figliuola; non prenderai la figliuola del figliuolo di lei, né la figliuola della figliuola di lei per scoprirne la nudità: sono parenti stretti: è un delitto. ");
INSERT INTO ita1927_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Non prenderai la sorella di tua moglie per farne una rivale, scoprendo la sua nudità insieme con quella di tua moglie, mentre questa è in vita. ");
INSERT INTO ita1927_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Non t’accosterai a donna per scoprir la sua nudità mentre è impura a motivo dei suoi corsi. ");
INSERT INTO ita1927_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Non avrai relazioni carnali con la moglie del tuo prossimo per contaminarti con lei. ");
INSERT INTO ita1927_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Non darai de’ tuoi figliuoli ad essere immolati a Moloc; e non profanerai il nome del tuo Dio. Io sono l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Non avrai con un uomo relazioni carnali come si hanno con una donna: è cosa abominevole. ");
INSERT INTO ita1927_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Non t’accoppierai con alcuna bestia per contaminarti con essa; e la donna non si prostituirà ad una bestia: è una mostruosità. ");
INSERT INTO ita1927_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Non vi contaminate con alcuna di queste cose; poiché con tutte queste cose si son contaminate le nazioni ch’io sto per cacciare dinanzi a voi. ");
INSERT INTO ita1927_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Il paese n’è stato contaminato; ond’io punirò la sua iniquità; il paese vomiterà i suoi abitanti. ");
INSERT INTO ita1927_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Voi dunque osserverete le mie leggi e le mie prescrizioni, e non commetterete alcuna di queste cose abominevoli: né colui ch’è nativo dei paese, né il forestiere che soggiorna fra voi. ");
INSERT INTO ita1927_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Poiché tutte queste cose abominevoli le ha commesse la gente che v’era prima di voi, e il paese n’è stato contaminato. ");
INSERT INTO ita1927_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Badate che, se lo contaminate, il paese non vi vomiti come vomiterà la gente che vi stava prima di voi. ");
INSERT INTO ita1927_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Poiché tutti quelli che commetteranno alcuna di queste cose abominevoli saranno sterminati di fra il loro popolo. ");
INSERT INTO ita1927_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Osserverete dunque i miei ordini, e non seguirete alcuno di quei costumi abominevoli che sono stati seguiti prima di voi, e non vi contaminerete con essi. Io sono l’Eterno, l’Iddio vostro”. ");
INSERT INTO ita1927_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Parla a tutta la raunanza de’ figliuoli d’Israele, e di’ loro: Siate santi, perché io, l’Eterno, l’Iddio vostro, son santo. ");
INSERT INTO ita1927_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Rispetti ciascuno sua madre e suo padre, e osservate i miei sabati. Io sono l’Eterno, l’Iddio vostro. ");
INSERT INTO ita1927_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Non vi rivolgete agl’idoli, e non vi fate degli dèi di getto. Io sono l’Eterno, l’Iddio vostro. ");
INSERT INTO ita1927_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","E quando offrirete un sacrifizio di azioni di grazie all’Eterno, l’offrirete in modo da esser graditi. ");
INSERT INTO ita1927_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Lo si mangerà il giorno stesso che l’avrete immolato, e il giorno seguente; e se ne rimarrà qualcosa fino al terzo giorno, lo brucerete col fuoco. ");
INSERT INTO ita1927_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Se se ne mangerà il terzo giorno, sarà cosa abominevole; il sacrifizio non sarà gradito. ");
INSERT INTO ita1927_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","E chiunque ne mangerà porterà la pena della sua iniquità, perché avrà profanato ciò ch’è sacro all’Eterno; e quel tale sarà sterminato di fra il suo popolo. ");
INSERT INTO ita1927_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Quando mieterete la raccolta della vostra terra, non mieterai fino all’ultimo canto il tuo campo, e non raccoglierai ciò che resta da spigolare della tua raccolta; ");
INSERT INTO ita1927_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","e nella tua vigna non coglierai i raspoli, né raccoglierai i granelli caduti; li lascerai per il povero e per il forestiere. Io sono l’Eterno, l’Iddio vostro. ");
INSERT INTO ita1927_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Non ruberete, e non userete inganno né menzogna gli uni a danno degli altri. ");
INSERT INTO ita1927_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Non giurerete il falso, usando il mio nome; ché profaneresti il nome del tuo Dio. Io sono l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Non opprimerai il tuo prossimo, e non gli rapirai ciò ch’è suo; il salario dell’operaio al tuo servizio non ti resti in mano la notte fino al mattino. ");
INSERT INTO ita1927_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Non maledirai il sordo, e non porrai inciampo davanti al cieco, ma temerai il tuo Dio. Io sono l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Non commetterete iniquità, nel giudicare; non avrai riguardo alla persona del povero, né tributerai speciale onore alla persona del potente; ma giudicherai il tuo prossimo con giustizia. ");
INSERT INTO ita1927_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Non andrai qua e là facendo il diffamatore fra il tuo popolo, né ti presenterai ad attestare il falso a danno della vita del tuo prossimo. Io sono l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Non odierai il tuo fratello in cuor tuo; riprendi pure il tuo prossimo, ma non ti caricare d’un peccato a cagion di lui. ");
INSERT INTO ita1927_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Non ti vendicherai, e non serberai rancore contro i figliuoli del tuo popolo, ma amerai il prossimo tuo come te stesso. Io sono l’Eterno. Osserverete le mie leggi. ");
INSERT INTO ita1927_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Non accoppierai bestie di specie differenti; non seminerai il tuo campo con due sorta di seme, né porterai veste tessuta di due diverse materie. ");
INSERT INTO ita1927_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Se uno si giace carnalmente con donna che sia schiava promessa a un uomo, ma non riscattata o affrancata, saranno ambedue puniti; ma non saranno messi a morte, perché colei non era libera. ");
INSERT INTO ita1927_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","L’uomo menerà all’Eterno, all’ingresso della tenda di convegno, come sacrifizio di riparazione, un montone; ");
INSERT INTO ita1927_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","e il sacerdote farà per lui l’espiazione davanti all’Eterno, col montone del sacrifizio di riparazione, per il peccato che colui ha commesso, e il peccato che ha commesso gli sarà perdonato. ");
INSERT INTO ita1927_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Quando sarete entrati nel paese e vi avrete piantato ogni sorta d’alberi fruttiferi, ne considererete i frutti come incirconcisi; per tre anni saranno per voi come incirconcisi; non si dovranno mangiare. ");
INSERT INTO ita1927_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Ma il quarto anno tutti i loro frutti saranno consacrati all’Eterno, per dargli lode. ");
INSERT INTO ita1927_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","E il quinto anno mangerete il frutto di quegli alberi, affinché essi vi aumentino il loro prodotto. Io sono l’Eterno, l’Iddio vostro. ");
INSERT INTO ita1927_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Non mangerete nulla che contenga sangue. Non praticherete alcuna sorta di divinazione o di magia. ");
INSERT INTO ita1927_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Non vi taglierete in tondo i capelli ai lati dei capo, né toglierai i canti alla tua barba. ");
INSERT INTO ita1927_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Non vi farete incisioni nella carne per un morto, né vi stamperete segni addosso. Io sono l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Non profanare la tua figliuola, prostituendola, affinché il paese non si dia alla prostituzione e non si riempia di scelleratezze. ");
INSERT INTO ita1927_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Osserverete i miei sabati, e porterete rispetto ai mio santuario. Io sono l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Non vi rivolgete agli spiriti, né agl’indovini; non li consultate, per non contaminarvi per mezzo loro. Io sono l’Eterno, l’Iddio vostro. ");
INSERT INTO ita1927_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Alzati dinanzi al capo canuto, onora la persona del vecchio, e temi il tuo Dio. Io sono l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Quando qualche forestiero soggiornerà con voi nel vostro paese, non gli farete torto. ");
INSERT INTO ita1927_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Il forestiero che soggiorna fra voi, lo tratterete come colui ch’è nato fra voi; tu l’amerai come te stesso; poiché anche voi foste forestieri nel paese d’Egitto. Io sono l’Eterno, l’Iddio vostro. ");
INSERT INTO ita1927_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Non commetterete ingiustizie nei giudizi, né con le misure di lunghezza, né coi pesi, né con le misure di capacità. ");
INSERT INTO ita1927_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Avrete stadere giuste, pesi giusti, efa giusto, hin giusto. Io sono l’Eterno, l’Iddio vostro, che v’ho tratto dal paese d’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Osserverete dunque tutte le mie leggi e tutte le mie prescrizioni, e le metterete in pratica. Io sono l’Eterno”. ");
INSERT INTO ita1927_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","L’Eterno parlò ancora a Mosè, dicendo: “Dirai ai figliuoli d’Israele: ");
INSERT INTO ita1927_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Chiunque de’ figliuoli d’Israele o de’ forestieri che soggiornano in Israele darà de’ suoi figliuoli a Moloc, dovrà esser messo a morte; il popolo del paese lo lapiderà. ");
INSERT INTO ita1927_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","E anch’io volgerò la mia faccia contro quell’uomo, e lo sterminerò di fra il suo popolo, perché avrà dato de’ suoi figliuoli a Moloc per contaminare il mio santuario e profanare il mio santo nome. ");
INSERT INTO ita1927_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","E se il popolo del paese chiude gli occhi quando quell’uomo da dei suoi figliuoli a Moloc, e non lo mette a morte, ");
INSERT INTO ita1927_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","io volgerò la mia faccia contro quell’uomo e contro la sua famiglia, e sterminerò di fra il suo popolo lui con tutti quelli che si prostituiscono come lui, prostituendosi a Moloc. ");
INSERT INTO ita1927_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","E se qualche persona si volge agli spiriti e agl’indovini per prostituirsi dietro a loro, io volgerò la mia faccia contro quella persona, e la sterminerò di fra il suo popolo. ");
INSERT INTO ita1927_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Santificatevi dunque e siate santi, perché io sono l’Eterno, l’Iddio vostro. ");
INSERT INTO ita1927_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","E osservate le mie leggi, e mettetele in pratica. Io sono l’Eterno che vi santifica. ");
INSERT INTO ita1927_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Chiunque maledice suo padre o sua madre dovrà esser messo a morte; ha maledetto suo padre o sua madre; il suo sangue ricadrà su lui. ");
INSERT INTO ita1927_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Se uno commette adulterio con la moglie d’un altro, se commette adulterio con la moglie del suo prossimo, l’adultero e l’adultera dovranno esser messi a morte. ");
INSERT INTO ita1927_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Se uno si giace con la moglie di suo padre, egli scopre la nudità di suo padre; ambedue dovranno esser messi a morte; il loro sangue ricadrà su loro. ");
INSERT INTO ita1927_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Se uno si giace con la sua nuora, ambedue dovranno esser messi a morte; hanno commesso una cosa abominevole; il loro sangue ricadrà su loro. ");
INSERT INTO ita1927_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Se uno ha con un uomo relazioni carnali come si hanno con una donna, ambedue hanno commesso cosa abominevole; dovranno esser messi a morte; il loro sangue ricadrà su loro. ");
INSERT INTO ita1927_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Se uno prende per moglie la figlia e la madre è un delitto; si bruceranno col fuoco lui e loro, affinché non si trovi fra voi alcun delitto. ");
INSERT INTO ita1927_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","L’uomo che s’accoppia con una bestia, dovrà esser messo a morte; e ucciderete la bestia. ");
INSERT INTO ita1927_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","E se una donna s’accosta a una bestia per prostituirsi ad essa, ucciderai la donna e la bestia; ambedue dovranno esser messe a morte; il loro sangue ricadrà su loro. ");
INSERT INTO ita1927_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Se uno prende la propria sorella, figliuola di suo padre o figliuola di sua madre, e vede la nudità di lei ed ella vede la nudità di lui, è una infamia; ambedue saranno sterminati in presenza de’ figliuoli del loro popolo; quel tale ha scoperto la nudità della propria sorella; porterà la pena della sua iniquità. ");
INSERT INTO ita1927_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Se uno si giace con una donna che ha i suoi corsi, e scopre la nudità di lei, quel tale ha scoperto il flusso di quella donna, ed ella ha scoperto il flusso del proprio sangue; perciò ambedue saranno sterminati di fra il loro popolo. ");
INSERT INTO ita1927_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Non scoprirai la nudità della sorella di tua madre o della sorella li tuo padre; chi lo fa scopre la sua stretta parente; ambedue porteranno la pena della loro iniquità. ");
INSERT INTO ita1927_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Se uno si giace con la moglie di suo zio, scopre la nudità di suo zio; ambedue porteranno la pena del loro peccato; morranno senza figliuoli. ");
INSERT INTO ita1927_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Se uno prende la moglie di suo fratello, è una impurità, egli ha scoperto la nudità di suo fratello; non avranno figliuoli. ");
INSERT INTO ita1927_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Osserverete dunque tutte le mie leggi e le mie prescrizioni, e le metterete in pratica, affinché il paese dove io vi conduco per abitarvi non vi vomiti fuori. ");
INSERT INTO ita1927_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","E non adotterete i costumi delle nazioni che io sto per cacciare d’innanzi a voi; esse hanno fatto tutte quelle cose, e perciò le ho avute in abominio; ");
INSERT INTO ita1927_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","e vi ho detto: Sarete voi quelli che possederete il loro paese; ve lo darò come vostra proprietà; è un paese ove scorre il latte e il miele. Io sono l’Eterno, l’Iddio vostro, che vi ho separato dagli altri popoli. ");
INSERT INTO ita1927_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Farete dunque distinzione fra gli animali puri e quelli impuri, fra gli uccelli impuri e quelli puri, e non renderete le vostre persone abominevoli, mangiando animali, uccelli, o cosa alcuna strisciante sulla terra, e che io v’ho fatto distinguere come impuri. ");
INSERT INTO ita1927_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","E mi sarete santi, poiché io, l’Eterno, son santo, e v’ho separati dagli altri popoli perché foste miei. ");
INSERT INTO ita1927_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Se un uomo o una donna ha uno spirito o indovina, dovranno esser messi a morte; saranno lapidati; il loro sangue ricadrà su loro”. ");
INSERT INTO ita1927_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","L’Eterno disse ancora a Mosè: “Parla ai sacerdoti, figliuoli d’Aaronne, e di’ loro: Un sacerdote non si esporrà a divenire impuro in mezzo al suo popolo per il contatto con un morto, ");
INSERT INTO ita1927_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","a meno che si tratti d’uno de’ suoi parenti più stretti: di sua madre, di suo padre, del suo figliuolo, della sua figliuola, ");
INSERT INTO ita1927_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","del suo fratello e della sua sorella ancora vergine che vive con lui, non essendo ancora maritata; per questa può esporsi alla impurità. ");
INSERT INTO ita1927_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Capo com’è in mezzo al suo popolo, non si contaminerà, profanando se stesso. ");
INSERT INTO ita1927_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","I sacerdoti non si faranno tonsure sul capo, non si raderanno i canti della barba, e non si faranno incisioni nella carne. ");
INSERT INTO ita1927_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Saranno santi al loro Dio e non profaneranno il nome del loro Dio, poiché offrono all’Eterno i sacrifizi fatti mediante il fuoco, il pane del loro Dio; perciò saran santi. ");
INSERT INTO ita1927_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Non prenderanno una prostituta, né una donna disonorata; non prenderanno una donna ripudiata dal suo marito, perché sono santi al loro Dio. ");
INSERT INTO ita1927_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Tu considererai dunque il sacerdote come santo, perch’egli offre il pane del tuo Dio: ei ti sarà santo, perché io, l’Eterno che vi santifico, son santo. ");
INSERT INTO ita1927_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Se la figliuola di un sacerdote si disonora prostituendosi, ella disonora suo padre; sarà arsa col fuoco. ");
INSERT INTO ita1927_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Il sommo sacerdote che sta al disopra de’ suoi fratelli, sul capo del quale è stato sparso l’olio dell’unzione e che è stato consacrato per rivestire i paramenti sacri, non si scoprirà il capo e non si straccerà le vesti. ");
INSERT INTO ita1927_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Non si avvicinerà ad alcun cadavere; non si renderà impuro neppure per suo padre e per sua madre. ");
INSERT INTO ita1927_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Non uscirà dal santuario, e non profanerà il santuario del suo Dio, perché l’olio dell’unzione del suo Dio e su lui come un diadema. Io sono l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Sposerà una vergine. ");
INSERT INTO ita1927_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Non sposerà né una vedova, né una divorziata, né una disonorata, né una meretrice; ma prenderà per moglie una vergine del suo popolo. ");
INSERT INTO ita1927_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Non disonorerà la sua progenie in mezzo al suo popolo; poiché io sono l’Eterno che lo santifico”. ");
INSERT INTO ita1927_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Parla ad Aaronne e digli: Nelle generazioni a venire nessun uomo della tua stirpe che abbia qualche deformità s’accosterà per offrire il pane del suo Dio; ");
INSERT INTO ita1927_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","perché nessun uomo che abbia qualche deformità potrà accostarsi: né il cieco, né lo zoppo, né colui che ha una deformità per difetto o per eccesso, ");
INSERT INTO ita1927_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","o una frattura al piede o alla mano, ");
INSERT INTO ita1927_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","né il gobbo, né il nano, né colui che ha una macchia nell’occhio, o ha la rogna o un erpete o i testicoli infranti. ");
INSERT INTO ita1927_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Nessun uomo della stirpe del sacerdote Aaronne, che abbia qualche deformità, si accosterà per offrire i sacrifizi fatti mediante il fuoco all’Eterno. Ha un difetto: non s’accosti quindi per offrire il pane del suo Dio. ");
INSERT INTO ita1927_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Egli potrà mangiare del pane del suo Dio, delle cose santissime e delle cose sante; ");
INSERT INTO ita1927_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","ma non si avvicinerà al velo, e non s’accosterà all’altare, perché ha una deformità. Non profanerà i miei luoghi santi, perché io sono l’Eterno che li santifico”. ");
INSERT INTO ita1927_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Così parlò Mosè ad Aaronne, ai figliuoli di lui e a tutti i figliuoli d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Di’ ad Aaronne e ai suoi figliuoli che si astengano dalle cose sante che mi son consacrate dai figliuoli d’Israele, e non profanino il mio santo nome. Io sono l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Di’ loro: Qualunque uomo della vostra stirpe che nelle vostre future generazioni, trovandosi in stato d’impurità, s’accosterà alle cose sante che i figliuoli d’Israele consacrano all’Eterno, sarà sterminato dal mio cospetto. Io sono l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Qualunque uomo della stirpe d’Aaronne che sia lebbroso o abbia la gonorrea, non mangerà delle cose sante, finché non sia puro. E così sarà di chi avrà toccato una persona impura per contatto con un morto, o avrà avuto una perdita di seme genitale, ");
INSERT INTO ita1927_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","o di chi avrà toccato un rettile che l’abbia reso impuro, o un uomo che gli abbia comunicato una impurità di qualsivoglia specie. ");
INSERT INTO ita1927_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","La persona che avrà avuto di tali contatti sarà impura fino alla sera, e non mangerà delle cose sante prima d’essersi lavato il corpo nell’acqua; ");
INSERT INTO ita1927_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","dopo il tramonto del sole sarà pura, e potrà poi mangiare delle cose sante, perché sono il suo pane. ");
INSERT INTO ita1927_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Il sacerdote non mangerà carne di bestia morta da sé o sbranata, per non rendersi impuro. Io sono l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Osserveranno dunque ciò che ho comandato, onde non portino la pena del loro peccato, e muoiano per aver profanato le cose sante. Io sono l’Eterno che li santifico. ");
INSERT INTO ita1927_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Nessun estraneo al sacerdozio mangerà delle cose sante: chi sta da un sacerdote o lavora da lui per un salario non mangerà delle cose sante. ");
INSERT INTO ita1927_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Ma una persona che il sacerdote avrà comprata coi suoi danari, ne potrà mangiare; così pure colui che gli è nato in casa: questi potranno mangiare del pane di lui. ");
INSERT INTO ita1927_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","La figliuola di un sacerdote maritata a un estraneo non mangerà delle cose sante offerte per elevazione. ");
INSERT INTO ita1927_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Ma se la figliuola del sacerdote è vedova, o ripudiata, senza figliuoli, e torna a stare da suo padre come quand’era giovine, potrà mangiare del pane del padre; ma nessun estraneo al sacerdozio ne mangerà. ");
INSERT INTO ita1927_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","E se uno mangia per sbaglio di una cosa santa, darà al sacerdote il valore della cosa santa aggiungendovi un quinto. ");
INSERT INTO ita1927_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","I sacerdoti non profaneranno dunque le cose sante dei figliuoli d’Israele, ch’essi offrono per elevazione all’Eterno, ");
INSERT INTO ita1927_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","e non faranno loro portare la pena del peccato di cui si renderebbero colpevoli, mangiando delle loro cose sante; poiché io sono l’Eterno che li santifico”. ");
INSERT INTO ita1927_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Parla ad Aaronne, ai suoi figliuoli, a tutti i figliuoli d’Israele, e di’ loro: Chiunque sia della casa d’Israele o de’ forestieri in Israele che presenti in olocausto all’Eterno un’offerta per qualche voto o per qualche dono volontario, per essere gradito, ");
INSERT INTO ita1927_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","dovrà offrire un maschio, senza difetto, di fra i buoi, di fra le pecore o di fra le capre. ");
INSERT INTO ita1927_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Non offrirete nulla che abbia qualche difetto, perché non sarebbe gradito. ");
INSERT INTO ita1927_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Quand’uno offrirà all’Eterno un sacrifizio di azioni di grazie, di buoi o di pecore, sia per sciogliere un voto, sia come offerta volontaria, la vittima, perché sia gradita, dovrà esser perfetta: non dovrà aver difetti. ");
INSERT INTO ita1927_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Non offrirete all’Eterno una vittima che sia cieca, o storpia, o mutilata, o che ubbia delle ulceri, o la rogna, o la scabbia; e non ne farete sull’altare un sacrifizio mediante il fuoco all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Potrai presentare come offerta volontaria un bue o una pecora che abbia un membro troppo lungo o troppo corto; ma, come offerta per qualche voto, non sarebbe gradito. ");
INSERT INTO ita1927_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Non offrirete all’Eterno un animale che abbia i testicoli ammaccati o schiacciati o strappati o tagliati; e di queste operazioni non ne farete nel vostro paese. ");
INSERT INTO ita1927_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Non accetterete dallo straniero alcuna di queste vittime per offrirla come pane del vostro Dio; siccome sono mutilate, difettose, non sarebbero gradite per il vostro bene”. ");
INSERT INTO ita1927_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Quando sarà nato un vitello, o un agnello, o un capretto, starà sette giorni sotto la madre; dall’ottavo giorno in poi, sarà gradito come sacrifizio fatto mediante il fuoco all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Sia vacca, sia pecora, non la scannerete lo stesso giorno col suo parto. ");
INSERT INTO ita1927_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Quando offrirete all’Eterno un sacrifizio di azioni di grazie, l’offrirete in modo da esser graditi. ");
INSERT INTO ita1927_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","La vittima sarà mangiata il giorno stesso; non ne lascerete nulla fino ai mattino. Io sono l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Osserverete dunque i miei comandamenti, e li metterete in pratica. Io sono l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Non profanerete il mio santo nome, ond’io sia santificato in mezzo ai figliuoli d’Israele. Io sono l’Eterno che vi santifico, ");
INSERT INTO ita1927_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","che vi ho tratto dal paese d’Egitto per esser vostro Dio. Io sono l’Eterno”. ");
INSERT INTO ita1927_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Parla ai figliuoli d’Israele e di’ loro: Ecco le solennità dell’Eterno, che voi bandirete come sante convocazioni. Le mie solennità son queste. ");
INSERT INTO ita1927_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Durante sei giorni si attenderà al lavoro; ma il settimo giorno è sabato, giorno di completo riposo e di santa convocazione. Non farete in esso lavoro alcuno; è un riposo consacrato all’Eterno in tutti i luoghi dove abiterete. ");
INSERT INTO ita1927_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Queste sono le solennità dell’Eterno, le sante convocazioni che bandirete ai tempi stabiliti. ");
INSERT INTO ita1927_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Il primo mese, il quattordicesimo giorno del mese, sull’imbrunire, sarà la Pasqua dell’Eterno; ");
INSERT INTO ita1927_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","e il quindicesimo giorno dello stesso mese sarà la festa dei pani azzimi in onore dell’Eterno; per sette giorni mangerete pane senza lievito. ");
INSERT INTO ita1927_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Il primo giorno avrete una santa convocazione; non farete in esso alcuna opera servile; ");
INSERT INTO ita1927_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","e per sette giorni offrirete all’Eterno de’ sacrifizi mediante il fuoco. Il settimo giorno si avrà una santa convocazione, non farete alcuna opera servile”. ");
INSERT INTO ita1927_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Parla ai figliuoli d’Israele, di’ loro: Quando sarete entrati nel paese che io vi do e ne mieterete la raccolta, porterete al sacerdote una mannella, come primizia della vostra raccolta; ");
INSERT INTO ita1927_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","e il sacerdote agiterà la mannella davanti all’Eterno, perché sia gradita per il vostro bene; il sacerdote l’agiterà il giorno dopo il sabato. ");
INSERT INTO ita1927_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","E il giorno che agiterete la mannella, offrirete un agnello di un anno, che sia senza difetto, come olocausto all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","L’oblazione che l’accompagna sarà di due decimi di un efa di fior di farina intrisa con olio, come sacrifizio mediante il fuoco, di soave odore all’Eterno; la libazione sarà d’un quarto di un hin di vino. ");
INSERT INTO ita1927_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Non mangerete pane, né grano arrostito, né spighe fresche, fino a quel giorno, fino a che abbiate portata l’offerta al vostro Dio. E’ una legge perpetua, di generazione in generazione, in tutti i luoghi dove abiterete. ");
INSERT INTO ita1927_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Dall’indomani del sabato, dal giorno che avrete portato la mannella dell’offerta agitata, conterete sette settimane intere. ");
INSERT INTO ita1927_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Conterete cinquanta giorni fino all’indomani del settimo sabato, e offrirete all’Eterno una nuova oblazione. ");
INSERT INTO ita1927_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Porterete dai luoghi dove abiterete due pani per un’offerta agitata, i quali saranno di due decimi di un efa di fior di farina e cotti con del lievito; sono le primizie offerte all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","E con que’ pani offrirete sette agnelli dell’anno, senza difetto, un giovenco e due montoni, che saranno un olocausto all’Eterno assieme alla loro oblazione e alle loro libazioni; sarà un sacrifizio di soave odore fatto mediante il fuoco all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","E offrirete un capro come sacrifizio per il peccato, e due agnelli dell’anno come sacrifizio di azioni di grazie. ");
INSERT INTO ita1927_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Il sacerdote agiterà gli agnelli col pane delle primizie, come offerta agitata davanti all’Eterno; e tanto i pani quanto i due agnelli consacrati all’Eterno apparterranno al sacerdote. ");
INSERT INTO ita1927_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","In quel medesimo giorno bandirete la festa, e avrete una santa convocazione. Non farete alcun’opera servile. E’ una legge perpetua, di generazione in generazione, in tutti i luoghi dove abiterete. ");
INSERT INTO ita1927_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Quando mieterete la raccolta della vostra terra, non mieterai fino all’ultimo canto il tuo campo, e non raccoglierai ciò che resta da spigolare della tua raccolta; lo lascerai per il povero e per il forestiero. Io sono l’Eterno, l’Iddio vostro”. ");
INSERT INTO ita1927_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Parla ai figliuoli d’Israele, di’ loro: Il settimo mese, il primo giorno del mese avrete un riposo solenne, una commemorazione fatta a suon di tromba, una santa convocazione. ");
INSERT INTO ita1927_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Non farete alcun’opera servile, e offrirete all’Eterno dei sacrifizi mediante il fuoco”. ");
INSERT INTO ita1927_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Il decimo giorno di questo settimo mese sarà il giorno delle espiazioni; avrete una santa convocazione, umilierete le anime vostre e offrirete all’Eterno de’ sacrifizi mediante il fuoco. ");
INSERT INTO ita1927_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","In quel giorno non farete alcun lavoro; poiché è un giorno d’espiazione, destinato a fare espiazione per voi davanti all’Eterno, ché l’Iddio vostro. ");
INSERT INTO ita1927_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Poiché, ogni persona che non si umilierà in quel giorno, sarà sterminata di fra il suo popolo. ");
INSERT INTO ita1927_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","E ogni persona che farà in quel giorno qualsivoglia lavoro, io la distruggerò di fra il suo popolo. ");
INSERT INTO ita1927_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Non farete alcun lavoro. E’ una legge perpetua, di generazione in generazione, in tutti i luoghi dove abiterete. ");
INSERT INTO ita1927_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Sarà per voi un sabato di completo riposo, e umilierete le anime vostre; il nono giorno del mese, dalla sera alla sera seguente, celebrerete il vostro sabato”. ");
INSERT INTO ita1927_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Parla ai figliuoli d’Israele, e di’ loro: Il quindicesimo giorno di questo settimo mese sarà la festa delle Capanne, durante sette giorni, in onore dell’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Il primo giorno vi sarà una santa convocazione; non farete alcuna opera servile. ");
INSERT INTO ita1927_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Per sette giorni offrirete all’Eterno dei sacrifizi mediante il fuoco. L’ottavo giorno avrete una santa convocazione, e offrirete all’Eterno dei sacrifizi mediante il fuoco. E’ giorno di solenne raunanza; non farete alcuna opera servile. ");
INSERT INTO ita1927_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Queste sono le solennità dell’Eterno che voi bandirete come sante convocazioni, perché si offrano all’Eterno sacrifizi mediante il fuoco, olocausti e oblazioni, vittime e libazioni, ogni cosa al giorno stabilito, ");
INSERT INTO ita1927_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","oltre i sabati dell’Eterno, oltre i vostri doni, oltre tutti i vostri voti e tutte le offerte volontarie che presenterete all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Or il quindicesimo giorno del settimo mese, quando avrete raccolto i frutti della terra, celebrerete una festa all’Eterno, durante sette giorni; il primo giorno sarà di completo riposo; e l’ottavo, di completo riposo. ");
INSERT INTO ita1927_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Il primo giorno prenderete del frutto di alberi d’ornamento: rami di palma, rami dalla verzura folta e salci de’ torrenti, e vi rallegrerete dinanzi all’Eterno, ch’è l’Iddio vostro, durante sette giorni. ");
INSERT INTO ita1927_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Celebrerete questa festa in onore dell’Eterno per sette giorni, ogni anno. E’ una legge perpetua, di generazione in generazione. La celebrerete il settimo mese. ");
INSERT INTO ita1927_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Dimorerete in capanne durante sette giorni; tutti quelli che saranno nativi d’Israele dimoreranno in capanne, ");
INSERT INTO ita1927_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","affinché i vostri discendenti sappiano che io feci dimorare in capanne i figliuoli d’Israele, quando li trassi fuori dal paese d’Egitto. Io sono l’Eterno, l’Iddio vostro”. ");
INSERT INTO ita1927_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Così Mosè dette ai figliuoli d’Israele le istruzioni relative alle solennità dell’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","L’Eterno parlò ancora a Mosè dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Ordina ai figliuoli d’Israele che ti portino dell’olio di uliva puro, vergine, per il candelabro, per tener le lampade continuamente accese. ");
INSERT INTO ita1927_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Aaronne lo preparerà nella tenda di convegno, fuori del velo che sta davanti alla testimonianza, perché le lampade ardano del continuo, dalla sera al mattino, davanti all’Eterno. E’ una legge perpetua, di generazione in generazione. ");
INSERT INTO ita1927_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Egli le disporrà sul candelabro d’oro puro, perché ardano del continuo davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Prenderai pure del fior di farina, e ne farai cuocere dodici focacce; ogni focaccia sarà di due decimi d’efa. ");
INSERT INTO ita1927_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Le metterai in due file, sei per fila, sulla tavola d’oro puro davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","E porrai dell’incenso puro sopra ogni fila, e sarà sul pane come una ricordanza, come un sacrifizio fatto mediante il fuoco all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Ogni giorno di sabato si disporranno i pani davanti all’Eterno, del continuo; saranno forniti dai figliuoli d’Israele; è un patto perpetuo. ");
INSERT INTO ita1927_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","I pani apparterranno ad Aaronne e ai suoi figliuoli, ed essi li mangeranno in luogo santo; poiché saranno per loro cosa santissima tra i sacrifizi fatti mediante il fuoco all’Eterno. E’ una legge perpetua”. ");
INSERT INTO ita1927_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Or il figliuolo di una donna israelita e di un Egiziano uscì tra i figliuoli d’Israele; e fra questo figliuolo della donna israelita e un Israelita nacque una lite. ");
INSERT INTO ita1927_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Il figliuolo della Israelita bestemmiò il nome dell’Eterno, e lo maledisse; onde fu condotto a Mosè. La madre di quel tale si chiamava Shelomith figliuola di Dibri, della tribù di Dan. ");
INSERT INTO ita1927_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Lo misero in prigione, finché fosse deciso che cosa fare per ordine dell’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","E l’Eterno parlò a Mosè dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Mena quel bestemmiatore fuori del campo; e tutti quelli che l’hanno udito posino le mani sul suo capo, e tutta la raunanza lo lapidi. ");
INSERT INTO ita1927_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","E parla ai figliuoli d’Israele, e di’ loro: Chiunque maledirà il suo Dio porterà la pena del suo peccato. ");
INSERT INTO ita1927_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","E chi bestemmia il nome dell’Eterno dovrà esser messo a morte; tutta la raunanza lo dovrà lapidare. Sia straniero o nativo del paese, quando bestemmi il nome dell’Eterno, sarà messo a morte. ");
INSERT INTO ita1927_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Chi percuote mortalmente un uomo qualsivoglia, dovrà esser messo a morte. ");
INSERT INTO ita1927_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Chi percuote a morte un capo di bestiame, lo pagherà: vita per vita. ");
INSERT INTO ita1927_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Quand’uno avrà fatto una lesione al suo prossimo, gli sarà fatto com’egli ha fatto: ");
INSERT INTO ita1927_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","frattura per frattura, occhio per occhio, dente per dente; gli si farà la stessa lesione ch’egli ha fatta all’altro. ");
INSERT INTO ita1927_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Chi uccide un capo di bestiame, lo pagherà; ma chi uccide un uomo sarà messo a morte. ");
INSERT INTO ita1927_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Avrete una stessa legge tanto per il forestiero quanto per il nativo del paese; poiché io sono l’Eterno, l’Iddio vostro”. ");
INSERT INTO ita1927_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","E Mosè parlò ai figliuoli d’Israele, i quali trassero quel bestemmiatore fuori del campo, e lo lapidarono. Così i figliuoli d’Israele fecero quello che l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","L’Eterno parlò ancora a Mosè sul monte Sinai, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Parla ai figliuoli d’Israele e di’ loro: Quando sarete entrati nel paese che io vi do, la terra dovrà avere il suo tempo di riposo consacrato all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Per sei anni seminerai il tuo campo, per sei anni poterai la tua vigna e ne raccoglierai i frutti; ");
INSERT INTO ita1927_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","ma il settimo anno sarà un sabato, un riposo completo per la terra, un sabato in onore dell’Eterno; non seminerai il tuo campo, né poterai la tua vigna. ");
INSERT INTO ita1927_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Non mieterai quello che nascerà da sé dal seme caduto nella tua raccolta precedente, e non vendemmierai l’uva della vigna che non avrai potata; sarà un anno di completo riposo per la terra. ");
INSERT INTO ita1927_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Ciò che la terra produrrà durante il suo riposo, servirà di nutrimento a te, al tuo servo, alla tua serva, al tuo operaio e al tuo forestiero che stanno da te, ");
INSERT INTO ita1927_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","al tuo bestiame e agli animali che sono nel tuo paese; tutto il suo prodotto servirà loro di nutrimento. ");
INSERT INTO ita1927_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Conterai pure sette settimane d’anni: sette volte sette anni; e queste sette settimane d’anni ti faranno un periodo di quarantanove anni. ");
INSERT INTO ita1927_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Poi il decimo giorno del settimo mese farai squillar la tromba; il giorno delle espiazioni farete squillar la tromba per tutto il paese. ");
INSERT INTO ita1927_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","E santificherete il cinquantesimo anno, e proclamerete l’affrancamento nel paese per tutti i suoi abitanti. Sarà per voi un giubileo; ognun di voi tornerà nella sua proprietà, e ognun di voi tornerà nella sua famiglia. ");
INSERT INTO ita1927_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Il cinquantesimo anno sarà per voi un giubileo; non seminerete e non raccoglierete quello che i campi produrranno da sé, e non vendemmierete le vigne non potate. ");
INSERT INTO ita1927_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Poiché è il giubileo; esso vi sarà sacro; mangerete il prodotto che vi verrà dai campi. ");
INSERT INTO ita1927_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","In quest’anno del giubileo ciascuno tornerà in possesso del suo. ");
INSERT INTO ita1927_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Se vendete qualcosa al vostro prossimo o se comprate qualcosa dal vostro prossimo, nessuno faccia torto al suo fratello. ");
INSERT INTO ita1927_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Regolerai la compra che farai dal tuo prossimo, sul numero degli anni passati dall’ultimo giubileo, e quegli venderà a te in ragione degli anni di rendita. ");
INSERT INTO ita1927_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Quanti più anni resteranno, tanto più aumenterai il prezzo; e quanto minore sarà il tempo, tanto calerai il prezzo; poiché quegli ti vende il numero delle raccolte. ");
INSERT INTO ita1927_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Nessun di voi danneggi il suo fratello, ma temerai il tuo Dio; poiché io sono l’Eterno, l’Iddio vostro. ");
INSERT INTO ita1927_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Voi metterete in pratica le mie leggi, e osserverete le mie prescrizioni e le adempirete, e abiterete il paese in sicurtà. ");
INSERT INTO ita1927_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","La terra produrrà i suoi frutti, voi ne mangerete a sazietà e abiterete in essa in sicurtà. ");
INSERT INTO ita1927_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","E se dite: Che mangeremo il settimo anno, giacché non semineremo e non faremo la nostra raccolta? ");
INSERT INTO ita1927_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Io disporrò che la mia benedizione venga su voi il sesto anno, ed esso vi darà una raccolta per tre anni. ");
INSERT INTO ita1927_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","E l’ottavo anno seminerete e mangerete della vecchia raccolta fino al nono anno; mangerete della raccolta vecchia finché sia venuta la nuova. ");
INSERT INTO ita1927_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Le terre non si venderanno per sempre; perché la terra è mia, e voi state da me come forestieri e avventizi. ");
INSERT INTO ita1927_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Perciò, in tutto il paese che sarà vostro possesso, concederete il diritto di riscatto del suolo. ");
INSERT INTO ita1927_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Se il tuo fratello diventa povero e vende una parte della sua proprietà, colui che ha il diritto di riscatto, il suo parente più prossimo verrà, e riscatterà ciò che il suo fratello ha venduto. ");
INSERT INTO ita1927_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","E se uno non ha chi possa fare il riscatto, ma giunge a procurarsi da sé la somma necessaria al riscatto, ");
INSERT INTO ita1927_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","conterà le annate scorse dalla vendita, renderà il soprappiù al compratore, e rientrerà così nel suo. ");
INSERT INTO ita1927_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ma se non trova da sé la somma sufficiente a rimborsarlo, ciò che ha venduto rimarrà in mano del compratore fino all’anno del giubileo; al giubileo sarà cosa franca, ed egli rientrerà nel suo possesso. ");
INSERT INTO ita1927_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Se uno vende una casa da abitare in una città murata, avrà il diritto di riscattarla fino al compimento di un anno dalla vendita; il suo diritto di riscatto durerà un anno intero. ");
INSERT INTO ita1927_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Ma se quella casa posta in una città murata non è riscattata prima del compimento d’un anno intero, rimarrà in perpetuo intero, rimarrà in perpetuo proprietà del compratore e dei suoi discendenti; non sarà franca al giubileo. ");
INSERT INTO ita1927_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Però, le case de’ villaggi non attorniati da mura saranno considerate come parte dei fondi di terreno; potranno essere riscattate, e al giubileo saranno franche. ");
INSERT INTO ita1927_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Quanto alle città de’ Leviti e alle case ch’essi vi possederanno, i Leviti avranno il diritto perpetuo di riscatto. ");
INSERT INTO ita1927_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","E se anche uno de’ Leviti ha fatto il riscatto, la casa venduta, con la città dove si trova, sarà franca al giubileo, perché le case delle città dei Leviti sono loro proprietà, in mezzo ai figliuoli d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","I campi situati ne’ dintorni delle città dei Leviti non si potranno vendere, perché sono loro proprietà perpetua. ");
INSERT INTO ita1927_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Se il tuo fratello ch’è presso di te è impoverito e i suoi mezzi vengon meno, tu lo sosterrai, anche se forestiero e avventizio, onde possa vivere presso di te. ");
INSERT INTO ita1927_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Non trarre da lui interesse, né utile; ma temi il tuo Dio, e viva il tuo fratello presso di te. ");
INSERT INTO ita1927_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Non gli darai il tuo danaro a interesse, né gli darai i tuoi viveri per ricavarne un utile. ");
INSERT INTO ita1927_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Io sono l’Eterno, il vostro Dio, che vi ha tratto dal paese d’Egitto per darvi il paese di Canaan, per essere il vostro Dio. ");
INSERT INTO ita1927_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Se il tuo fratello ch’è presso di te è impoverito e si vende a te, non lo farai servire come uno schiavo; ");
INSERT INTO ita1927_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","starà da te come un lavorante, come un avventizio. Ti servirà fino all’anno del giubileo; ");
INSERT INTO ita1927_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","allora se ne andrà da te insieme coi suoi figliuoli, tornerà nella sua famiglia, e rientrerà nella proprietà de’ suoi padri. ");
INSERT INTO ita1927_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Poiché essi sono miei servi, ch’io trassi dal paese d’Egitto; non debbono esser venduti come si vendono gli schiavi. ");
INSERT INTO ita1927_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Non lo dominerai con asprezza, ma temerai il tuo Dio. ");
INSERT INTO ita1927_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Quanto allo schiavo e alla schiava che potrete avere in proprio, li prenderete dalle nazioni che vi circondano; da queste comprerete lo schiavo e la schiava. ");
INSERT INTO ita1927_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Potrete anche comprarne tra i figliuoli degli stranieri stabiliti fra voi e fra le loro famiglie che si troveranno fra voi, tra i figliuoli ch’essi avranno generato nel vostro paese; e saranno vostra proprietà. ");
INSERT INTO ita1927_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","E li potrete lasciare in eredità ai vostri figliuoli dopo di voi, come loro proprietà; vi servirete di loro come di schiavi in perpetuo; ma quanto ai vostri fratelli, i figliuoli d’Israele, nessun di voi dominerà l’altro con asprezza. ");
INSERT INTO ita1927_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Se un forestiero stabilito presso di te arricchisce, e il tuo fratello divien povero presso di lui e si vende al forestiero stabilito presso di te o a qualcuno della famiglia del forestiero, ");
INSERT INTO ita1927_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","dopo che si sarà venduto, potrà essere riscattato; lo potrà riscattare uno de’ suoi fratelli; ");
INSERT INTO ita1927_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","lo potrà riscattare suo zio, o il figliuolo del suo zio; lo potrà riscattare uno de’ parenti dello stesso suo sangue, o, se ha i mezzi di farlo, potrà riscattarsi da sé. ");
INSERT INTO ita1927_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Farà il conto, col suo compratore, dall’anno che gli si è venduto all’anno del giubileo; e il prezzo da pagare si regolerà secondo il numero degli anni, valutando le sue giornate come quelle di un lavorante. ");
INSERT INTO ita1927_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Se vi sono ancora molti anni per arrivare al giubileo, pagherà il suo riscatto in ragione di questi anni, e in proporzione del prezzo per il quale fu comprato: ");
INSERT INTO ita1927_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","se rimangon pochi anni per arrivare al giubileo, farà il conto col suo compratore, e pagherà il prezzo del suo riscatto in ragione di quegli anni. ");
INSERT INTO ita1927_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Starà da lui come un lavorante fissato annualmente; il padrone non lo dominerà con asprezza sotto i tuoi occhi. ");
INSERT INTO ita1927_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","E se non è riscattato in alcuno di quei modi, se ne uscirà libero l’anno del giubileo: egli, coi suoi figliuoli. ");
INSERT INTO ita1927_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Poiché i figliuoli d’Israele son servi miei; sono miei servi, che ho tratto dal paese d’Egitto. Io sono l’Eterno, l’Iddio vostro. ");
INSERT INTO ita1927_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Non vi farete idoli, non vi eleverete immagini scolpite né statue, e non collocherete nel vostro paese alcuna pietra ornata di figure, per prostrarvi davanti ad essa; poiché io sono l’Eterno, l’Iddio vostro. ");
INSERT INTO ita1927_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Osserverete i miei sabati, e porterete rispetto al mio santuario. Io sono l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Se vi conducete secondo le mie leggi, se osservate i miei comandamenti e li mettete in pratica, ");
INSERT INTO ita1927_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","io vi darò le piogge nella loro stagione, la terra darà i suoi prodotti, e gli alberi della campagna daranno i loro frutti. ");
INSERT INTO ita1927_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","La trebbiatura vi durerà fino alla vendemmia, e la vendemmia vi durerà fino alla sementa; mangerete a sazietà il vostro pane, e abiterete in sicurtà il vostro paese. ");
INSERT INTO ita1927_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Io farò che la pace regni nel paese; voi vi coricherete, e non ci sarà chi vi spaventi; farò sparire dal paese le bestie nocive, e la spada non passerà per il vostro paese. ");
INSERT INTO ita1927_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Voi inseguirete i vostri nemici, ed essi cadranno dinanzi a voi per la spada. ");
INSERT INTO ita1927_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Cinque di voi ne inseguiranno cento, cento di voi ne inseguiranno diecimila, e i vostri nemici cadranno dinanzi a voi per la spada. ");
INSERT INTO ita1927_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","E io mi volgerò verso voi, vi renderò fecondi e vi moltiplicherò, e raffermerò il mio patto con voi. ");
INSERT INTO ita1927_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","E voi mangerete delle raccolte vecchie, serbate a lungo, e trarrete fuori la raccolta vecchia per far posto alla nuova. ");
INSERT INTO ita1927_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Io stabilirò la mia dimora in mezzo a voi, e l’anima mia non vi aborrirà. ");
INSERT INTO ita1927_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Camminerò tra voi, sarò vostro Dio, e voi sarete mio popolo. ");
INSERT INTO ita1927_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Io sono l’Eterno, l’Iddio vostro, che vi ho tratto dal paese d’Egitto affinché non vi foste più schiavi; ho spezzato il vostro giogo, e v’ho fatto camminare a test’alta. ");
INSERT INTO ita1927_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Ma se non mi date ascolto e se non mettete in pratica tutti questi comandamenti, ");
INSERT INTO ita1927_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","se disprezzate le mie leggi e l’anima vostra disdegna le mie prescrizioni in guisa che non mettiate in pratica tutti i miei comandamenti e rompiate il mio patto, ");
INSERT INTO ita1927_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ecco quel che vi farò a mia volta: manderò contro voi il terrore, la consunzione e la febbre, che vi faranno venir meno gli occhi e languir l’anima, e seminerete invano la vostra sementa: la mangeranno i vostri nemici. ");
INSERT INTO ita1927_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Volgerò la mia faccia contro di voi, e voi sarete sconfitti dai vostri nemici; quelli che vi odiano vi domineranno, e vi darete alla fuga senza che alcuno v’insegua. ");
INSERT INTO ita1927_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","E se nemmeno dopo questo vorrete darmi ascolto, io vi castigherò sette volte di più per i vostri peccati. ");
INSERT INTO ita1927_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Spezzerò la superbia della vostra forza, farò che il vostro cielo sia come di ferro, e la vostra terra come di rame. ");
INSERT INTO ita1927_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","La vostra forza si consumerà invano, poiché la vostra terra non darà i suoi prodotti, e gli alberi della campagna non daranno i loro frutti. ");
INSERT INTO ita1927_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","E se mi resistete con la vostra condotta e non volete darmi ascolto, io vi colpirò sette volte di più, secondo i vostri peccati. ");
INSERT INTO ita1927_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Manderò contro di voi le fiere della campagna, che vi rapiranno i figliuoli, stermineranno il vostro bestiame, vi ridurranno a un piccol numero, e le vostre strade diverranno deserte. ");
INSERT INTO ita1927_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","E se, nonostante questi castighi, non volete correggervi per tornare a me, ma con la vostra condotta mi resistete, anch’io vi resisterò, ");
INSERT INTO ita1927_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","e vi colpirò sette volte di più per i vostri peccati. ");
INSERT INTO ita1927_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","E farò venir contro di voi la spada, vindice del mio patto; voi vi raccoglierete nelle vostre città, ma io manderò in mezzo a voi la peste, e sarete dati in man del nemico. ");
INSERT INTO ita1927_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Quando vi toglierò il pane che sostiene, dieci donne coceranno il vostro pane in uno stesso forno, vi distribuiranno il vostro pane a peso, e mangerete, ma non vi sazierete. ");
INSERT INTO ita1927_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","E se, nonostante tutto questo, non volete darmi ascolto ma con la vostra condotta mi resistete, ");
INSERT INTO ita1927_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","anch’io vi resisterò con furore, e vi castigherò sette volte di più per i vostri peccati. ");
INSERT INTO ita1927_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Mangerete la carne dei vostri figliuoli, e mangerete la carne delle vostre figliuole. ");
INSERT INTO ita1927_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Io devasterò i vostri alti luoghi, distruggerò le vostre statue consacrate al sole, metterò i vostri cadaveri sui cadaveri dei vostri idoli, e l’anima mia vi aborrirà. ");
INSERT INTO ita1927_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","E ridurrò le vostre città in deserti, desolerò i vostri santuari, e non aspirerò più il soave odore dei vostri profumi. ");
INSERT INTO ita1927_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Desolerò il paese; e i vostri nemici che vi abiteranno, ne saranno stupefatti. ");
INSERT INTO ita1927_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","E, quanto a voi, io vi disperderò fra le nazioni, e vi darò dietro a spada tratta; il vostro paese sarà desolato, e le vostre città saranno deserte. ");
INSERT INTO ita1927_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Allora la terra si godrà i suoi sabati per tutto il tempo che rimarrà desolata e che voi sarete nel paese dei vostri nemici; allora la terra si riposerà e si godrà i suoi sabati. ");
INSERT INTO ita1927_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Per tutto il tempo che rimarrà desolata avrà il riposo che non ebbe nei vostri sabati, quando voi l’abitavate. ");
INSERT INTO ita1927_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Quanto ai superstiti fra voi, io renderò pusillanime il loro cuore nel paese dei loro nemici: il rumore d’una foglia agitata li metterà in fuga; fuggiranno come si fugge dinanzi alla spada, e cadranno senza che alcuno l’insegua. ");
INSERT INTO ita1927_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Precipiteranno l’uno sopra l’altro come davanti alla spada, senza che alcuno l’insegua, e voi non potrete resistere dinanzi ai vostri nemici. ");
INSERT INTO ita1927_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","E perirete fra le nazioni, e il paese de’ vostri nemici vi divorerà. ");
INSERT INTO ita1927_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","I superstiti fra voi si struggeranno nei paesi de’ loro nemici, a motivo delle proprie iniquità; e si struggeranno pure a motivo delle iniquità dei loro padri. ");
INSERT INTO ita1927_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","E confesseranno la loro iniquità e l’iniquità dei loro padri: l’iniquità delle trasgressioni commesse contro di me e della resistenza oppostami, ");
INSERT INTO ita1927_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","peccati per i quali anch’io avrò dovuto resister loro, e menarli nel paese de’ loro nemici. Ma se allora il cuor loro incirconciso si umilierà, e se accetteranno la punizione della loro iniquità, ");
INSERT INTO ita1927_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","io mi ricorderò del mio patto con Giacobbe, mi ricorderò del mio patto con Isacco e del mio patto con Abrahamo, e mi ricorderò del paese; ");
INSERT INTO ita1927_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","poiché il paese sarà abbandonato da loro, e si godrà i suoi sabati mentre rimarrà desolato, senza di loro, ed essi accetteranno la punizione della loro iniquità per aver disprezzato le mie prescrizioni e aver avuto in avversione le mie leggi. ");
INSERT INTO ita1927_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","E, nonostante tutto questo, quando saranno nel paese dei loro nemici, io non li disprezzerò e non li prenderò in avversione fino al punto d’annientarli del tutto e di rompere il mio patto con loro; poiché io sono l’Eterno, il loro Dio; ");
INSERT INTO ita1927_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","ma per amor d’essi mi ricorderò del patto stretto coi loro antenati, i quali trassi dal paese d’Egitto, nel cospetto delle nazioni, per essere il loro Dio. Io sono l’Eterno”. ");
INSERT INTO ita1927_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Tali sono gli statuti, le prescrizioni e le leggi che l’Eterno stabilì fra sé e i figliuoli d’Israele, sul monte Sinai, per mezzo di Mosè. ");
INSERT INTO ita1927_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Parla ai figliuoli d’Israele e di’ loro: Quand’uno farà un voto concernente delle persone, queste persone apparterranno all’Eterno secondo la valutazione che ne farai. ");
INSERT INTO ita1927_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","E la tua stima sarà, per un maschio dai venti ai sessant’anni, cinquanta sicli d’argento, secondo il siclo del santuario; ");
INSERT INTO ita1927_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","se si tratta di una donna, la tua stima sarà di trenta sicli. ");
INSERT INTO ita1927_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Dai cinque ai vent’anni, la tua stima sarà di venti sicli per un maschio, e di dieci sicli per una femmina. ");
INSERT INTO ita1927_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Da un mese a cinque anni, la tua stima sarà di cinque sicli d’argento per un maschio, e di tre sicli d’argento per una femmina. ");
INSERT INTO ita1927_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Dai sessant’anni in su, la tua stima sarà di quindici sicli per un maschio e di dieci sicli per una femmina. ");
INSERT INTO ita1927_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","E se colui che ha fatto il voto e troppo povero per pagare la somma fissata da te, lo si farà presentare al sacerdote, il quale lo tasserà. Il sacerdote farà una stima, in proporzione de’ mezzi di colui che ha fatto il voto. ");
INSERT INTO ita1927_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Se si tratta di animali che possono essere presentati come offerta all’Eterno, ogni animale che si darà all’Eterno sarà cosa santa. ");
INSERT INTO ita1927_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Non lo si dovrà cambiare; non se ne metterà uno buono al posto di uno cattivo, o uno cattivo al posto di uno buono; e se pure uno sostituisce un animale all’altro, ambedue gli animali saranno cosa sacra. ");
INSERT INTO ita1927_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","E se si tratta di animali impuri di cui non si può fare offerta all’Eterno, l’animale sarà presentato davanti al sacerdote; ");
INSERT INTO ita1927_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","e il sacerdote ne farà la stima, secondo che l’animale sarà buono o cattivo; e uno se ne starà alla stima fattane dal sacerdote. ");
INSERT INTO ita1927_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Ma se uno lo vuol riscattare, aggiungerà un quinto alla tua stima. ");
INSERT INTO ita1927_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Se uno consacra la sua casa per esser cosa santa all’Eterno, il sacerdote ne farà la stima secondo ch’essa sarà buona o cattiva; e uno se ne starà alla stima fattane dal sacerdote. ");
INSERT INTO ita1927_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","E se colui che ha consacrato la sua casa la vuol riscattare, aggiungerà un quinto al prezzo della stima, e sarà sua. ");
INSERT INTO ita1927_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Se uno consacra all’Eterno un pezzo di terra della sua proprietà, ne farai la stima in ragione della sementa: cinquanta sicli d’argento per un omer di seme d’orzo. ");
INSERT INTO ita1927_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Se consacra la sua terra dall’anno del giubileo, il prezzo ne resterà fissato secondo la tua stima; ");
INSERT INTO ita1927_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","ma se la consacra dopo il giubileo, il sacerdote ne valuterà il prezzo in ragione del numero degli anni che rimangono fino al giubileo, e si farà una detrazione dalla tua stima. ");
INSERT INTO ita1927_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","E se colui che ha consacrato il pezzo di terra lo vuol riscattare, aggiungerà un quinto al prezzo della tua stima, e resterà suo. ");
INSERT INTO ita1927_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Ma se non riscatta il pezzo di terra e lo vende ad un altro, non lo si potrà più riscattare; ");
INSERT INTO ita1927_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","ma quel pezzo di terra, quando rimarrà franco al giubileo, sarà consacrato all’Eterno come una terra interdetta, e diventerà proprietà del sacerdote. ");
INSERT INTO ita1927_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Se uno consacra all’Eterno un pezzo di terra ch’egli ha comprato e che non fa parte della sua proprietà, ");
INSERT INTO ita1927_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","il sacerdote ne valuterà il prezzo secondo la stima fino all’anno del giubileo; e quel tale pagherà il giorno stesso il prezzo fissato, giacché è cosa consacrata all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","L’anno del giubileo la terra tornerà a colui da cui fu comprata, e del cui patrimonio faceva parte. ");
INSERT INTO ita1927_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Tutte le tuo stime si faranno in sicli del santuario; il siclo è di venti ghere. ");
INSERT INTO ita1927_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Però, nessuno potrà consacrare i primogeniti del bestiame, i quali appartengono già all’Eterno, perché primogeniti: sia un bue, sia un agnello, appartiene all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","E se si tratta di un animale impuro, lo si riscatterà al prezzo della tua stima, aggiungendovi un quinto; se non è riscattato, sarà venduto al prezzo della tua stima. ");
INSERT INTO ita1927_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Nondimeno, tutto ciò che uno avrà consacrato all’Eterno per voto d’interdetto, di fra le cose che gli appartengono, sia che si tratti di una persona, di un animale o di un pezzo di terra del suo patrimonio, non potrà esser né venduto, né riscattato; ogni interdetto è cosa interamente consacrata all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Nessuna persona consacrata per voto d’interdetto potrà essere riscattata; dovrà essere messa a morte. ");
INSERT INTO ita1927_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Ogni decima della terra, sia delle raccolte del suolo sia dei frutti degli alberi, appartiene all’Eterno; è cosa consacrata all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Se uno vuol riscattare una parte della sua decima vi aggiungerà il quinto. ");
INSERT INTO ita1927_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","E ogni decima dell’armento o del gregge, il decimo capo di tutto ciò che passa sotto la verga del pastore, sarà consacrata all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Non si farà distinzione fra animale buono e cattivo, e non si faranno sostituzioni; e se si sostituisce un animale all’altro, ambedue saranno cosa sacra; non si potranno riscattare”. ");
INSERT INTO ita1927_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Questi sono i comandamenti che l’Eterno diede a Mosè per i figliuoli d’Israele, sul monte Sinai. ");
INSERT INTO ita1927_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","L’Eterno parlò ancora a Mosè, nel deserto di Sinai, nella tenda di convegno, il primo giorno del secondo mese, il secondo anno dell’uscita de’ figliuoli d’Israele dal paese d’Egitto, e disse: ");
INSERT INTO ita1927_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Fate la somma di tutta la raunanza de’ figliuoli d’Israele secondo le loro famiglie, secondo le case dei loro padri, contando i nomi di tutti i maschi, uno per uno, ");
INSERT INTO ita1927_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","dall’età di venti anni in su, tutti quelli che in Israele possono andare alla guerra; tu ed Aaronne ne farete il censimento, secondo le loro schiere. ");
INSERT INTO ita1927_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","E con voi ci sarà un uomo per tribù, il capo della casa de’ suoi padri. ");
INSERT INTO ita1927_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Questi sono i nomi degli nomini che staranno con voi. Di Ruben: Elitsur, figliuolo di Scedeur; ");
INSERT INTO ita1927_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","di Simeone: Scelumiel, figliuolo di Tsurishaddai; ");
INSERT INTO ita1927_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","di Giuda: Nahshon, figliuolo di Aminadab; ");
INSERT INTO ita1927_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","di Issacar: Nethaneel, figliuolo di Tsuar; ");
INSERT INTO ita1927_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","di Zabulon: Eliab, figliuolo di Helon; ");
INSERT INTO ita1927_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","de’ figliuoli di Giuseppe: di Efraim: Elishama, figliuolo di Ammihud; di Manasse: Gamaliel, figliuolo di Pedahtsur; ");
INSERT INTO ita1927_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","di Beniamino: Abidan, figliuolo di Ghideoni; ");
INSERT INTO ita1927_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","di Dan: Ahiezer, figliuolo di Ammishaddai; ");
INSERT INTO ita1927_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","di Ascer: Paghiel, figliuolo di Ocran; ");
INSERT INTO ita1927_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","di Gad: Eliasaf, figliuolo di Deuel; ");
INSERT INTO ita1927_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","di Neftali: Ahira, figliuolo di Enan”. ");
INSERT INTO ita1927_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Questi furono i chiamati dal seno della raunanza, i principi delle tribù de’ loro padri, i capi delle migliaia d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Mosè ed Aaronne presero dunque questi uomini ch’erano stati designati per nome, ");
INSERT INTO ita1927_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","e convocarono tutta la raunanza, il primo giorno del secondo mese; e il popolo fu inscritto secondo le famiglie, secondo le case de’ padri, contando il numero delle persone dai venti anni in su, uno per uno. ");
INSERT INTO ita1927_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Come l’Eterno gli aveva ordinato, Mosè ne fece il censimento nel deserto di Sinai. ");
INSERT INTO ita1927_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Figliuoli di Ruben, primogenito d’Israele, loro discendenti secondo le loro famiglie, secondo le case dei loro padri, contando i nomi di tutti i maschi, uno per uno, dall’età di vent’anni in su, tutti quelli che potevano andare alla guerra: ");
INSERT INTO ita1927_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","il censimento della tribù di Ruben dette la cifra di quarantaseimila cinquecento. ");
INSERT INTO ita1927_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Figliuoli di Simeone, loro discendenti secondo le loro famiglie, secondo le case dei loro padri, inscritti contando i nomi di tutti i maschi, uno per uno, dall’età di vent’anni in su, tutti quelli che potevano andare alla guerra: ");
INSERT INTO ita1927_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","il censimento della tribù di Simeone dette la cifra di cinquantanovemila trecento. ");
INSERT INTO ita1927_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Figliuoli di Gad, loro discendenti secondo le loro famiglie, secondo le case dei loro padri, contando i nomi dall’età di vent’anni in su, tutti quelli che potevano andare alla guerra: ");
INSERT INTO ita1927_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","il censimento della tribù di Gad dette la cifra di quarantacinquemila seicentocinquanta. ");
INSERT INTO ita1927_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Figliuoli di Giuda, loro discendenti secondo le loro famiglie, secondo le case dei loro padri, contando i nomi dall’età di venti anni in su, tutti quelli che potevano andare alla guerra: ");
INSERT INTO ita1927_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","il censimento della tribù di Giuda dette la cifra di settantaquattromila seicento. ");
INSERT INTO ita1927_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Figliuoli di Issacar, loro discendenti secondo le loro famiglie, secondo le case dei loro padri, contando i nomi dall’età di venti anni in su, tutti quelli che potevano andare alla guerra: ");
INSERT INTO ita1927_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","il censimento della tribù di Issacar dette la cifra di cinquantaquattromila quattrocento. ");
INSERT INTO ita1927_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Figliuoli di Zabulon, loro discendenti secondo le loro famiglie, secondo le case dei loro padri, contando i nomi dall’età di venti anni in su, tutti quelli che potevano andare alla guerra: ");
INSERT INTO ita1927_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","il censimento della tribù di Zabulon dette la cifra di cinquantasettemila quattrocento. ");
INSERT INTO ita1927_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Figliuoli di Giuseppe: Figliuoli d’Efraim, loro discendenti secondo le loro famiglie, secondo le case dei loro padri, contando i nomi dall’età di venti anni in su, tutti quelli che potevano andare alla guerra: ");
INSERT INTO ita1927_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","il censimento della tribù di Efraim dette la cifra di quarantamila cinquecento. ");
INSERT INTO ita1927_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Figliuoli di Manasse, loro discendenti secondo le loro famiglie, secondo le case dei loro padri, contando i nomi dall’età di venti anni in su, tutti quelli che potevano andare alla guerra: ");
INSERT INTO ita1927_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","il censimento della tribù dì Manasse dette la cifra di trentaduemila duecento. ");
INSERT INTO ita1927_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Figliuoli di Beniamino, loro discendenti secondo le loro famiglie, secondo le case dei loro padri, contando i nomi dall’età di venti anni in su, tutti quelli che potevano andare alla guerra: ");
INSERT INTO ita1927_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","il censimento della tribù di Beniamino dette la cifra di trentacinquemila quattrocento. ");
INSERT INTO ita1927_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Figliuoli di Dan, loro discendenti secondo le loro famiglie, secondo le case dei loro padri, contando i nomi dall’età di venti anni in su, tutti quelli che potevano andare alla guerra: ");
INSERT INTO ita1927_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","il censimento della tribù di Dan dette la cifra di sessantaduemila settecento. ");
INSERT INTO ita1927_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Figliuoli di Ascer, loro discendenti secondo le loro famiglie, secondo le case dei loro padri, contando i nomi dall’età di venti anni in su, tutti quelli che potevano andare alla guerra: ");
INSERT INTO ita1927_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","il censimento della tribù di Ascer dette la cifra di quarantunmila cinquecento. ");
INSERT INTO ita1927_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Figliuoli di Neftali, loro discendenti secondo le loro famiglie, secondo le case dei loro padri, contando i nomi dall’età di venti anni in su, tutti quelli che potevano andare alla guerra: ");
INSERT INTO ita1927_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","il censimento della tribù di Neftali dette la cifra di cinquantatremila quattrocento. ");
INSERT INTO ita1927_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Questi son quelli di cui Mosè ed Aaronne fecero il censimento, coi dodici uomini, principi d’Israele: ce n’era uno per ognuna delle case de’ loro padri. ");
INSERT INTO ita1927_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Così tutti i figliuoli d’Israele dei quali fu fatto il censimento secondo le case del loro padri, dall’età di vent’anni in su, cioè tutti gli uomini che in Israele potevano andare alla guerra, ");
INSERT INTO ita1927_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","tutti quelli dei quali fu fatto il censimento, furono seicentotremila cinquecentocinquanta. ");
INSERT INTO ita1927_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Ma i Leviti, come tribù dei loro padri, non furon compresi nel censimento con gli altri; ");
INSERT INTO ita1927_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","poiché l’Eterno avea parlato a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Soltanto della tribù di Levi non farai il censimento, e non ne unirai l’ammontare a quello de’ figliuoli d’Israele; ");
INSERT INTO ita1927_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","ma affida ai Leviti la cura del tabernacolo della testimonianza, di tutti i suoi utensili e di tutto ciò che gli appartiene. Essi porteranno il tabernacolo e tutti i suoi utensili, ne faranno il servizio, e staranno accampati attorno al tabernacolo. ");
INSERT INTO ita1927_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Quando il tabernacolo dovrà partire, i Leviti lo smonteranno; quando il tabernacolo dovrà accamparsi in qualche luogo, i Leviti lo rizzeranno; e l’estraneo che gli si avvicinerà sarà messo a morte. ");
INSERT INTO ita1927_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","I figliuoli d’Israele pianteranno le loro tende ognuno nel suo campo, ognuno vicino alla sua bandiera, secondo le loro schiere. ");
INSERT INTO ita1927_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Ma i Leviti pianteranno le loro attorno al tabernacolo della testimonianza, affinché non si accenda l’ira mia contro la raunanza de’ figliuoli d’Israele; e i Leviti avranno la cura del tabernacolo della testimonianza”. ");
INSERT INTO ita1927_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","I figliuoli d’Israele si conformarono in tutto agli ordini che l’Eterno avea dato a Mosè; fecero così. ");
INSERT INTO ita1927_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","L’Eterno parlò ancora a Mosè e ad Aaronne, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“I figliuoli d’Israele s’accamperanno ciascuno vicino alla sua bandiera sotto le insegne delle case dei loro padri; si accamperanno di faccia e tutt’intorno alla tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Sul davanti, verso oriente, s’accamperà la bandiera del campo di Giuda con le sue schiere; ");
INSERT INTO ita1927_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","il principe de’ figliuoli di Giuda è Nahshon, figliuolo di Aminadab, e il suo corpo, secondo il censimento, è di settantaquattromila seicento uomini. ");
INSERT INTO ita1927_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Accanto a lui s’accamperà la tribù di Issacar; il principe dei figliuoli di Issacar e Nethaneel, figliuoli di Tsuar, ");
INSERT INTO ita1927_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","e il suo corpo, secondo il censimento, è di cinquantaquattromila quattrocento uomini. ");
INSERT INTO ita1927_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Poi la tribù di Zabulon; il principe dei figliuoli di Zabulon e Eliab, figliuolo di Helon, e il suo corpo, ");
INSERT INTO ita1927_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","secondo il censimento, è di cinquantasettemila quattrocento uomini. ");
INSERT INTO ita1927_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Il totale del censimento del campo di Giuda è dunque centottantaseimila quattrocento uomini, secondo le loro schiere. Si metteranno in marcia i primi. ");
INSERT INTO ita1927_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","A mezzogiorno starà la bandiera del campo di Ruben con le sue schiere; il principe de’ figliuoli di Ruben è Elitsur, figliuolo di Scedeur, ");
INSERT INTO ita1927_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","e il suo corpo, secondo il censimento, è di quarantaseimila cinquecento uomini. ");
INSERT INTO ita1927_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Accanto a lui s’accamperà la tribù di Simeone; il principe de’ figliuoli di Simeone è Scelumiel, figliuolo di Tsurishaddai, ");
INSERT INTO ita1927_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","e il suo corpo, secondo il censimento, è di cinquantanovemila trecento uomini. ");
INSERT INTO ita1927_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Poi la tribù di Gad; il principe de’ figliuoli di Gad è Eliasaf, figliuolo di Reuel, ");
INSERT INTO ita1927_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","e il suo corpo, secondo il censimento, è di quarantacinquemila seicentocinquanta uomini. ");
INSERT INTO ita1927_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Il totale del censimento dei campo di Ruben è dunque centocinquantunmila e quattrocentocinquanta uomini, secondo le loro schiere. Si metteranno in marcia in seconda linea. ");
INSERT INTO ita1927_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Poi si metterà in marcia la tenda di convegno col campo dei Leviti in mezzo agli altri campi. Seguiranno nella marcia l’ordine nel quale erano accampati, ciascuno al suo posto, con la sua bandiera. ");
INSERT INTO ita1927_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Ad occidente starà la bandiera del campo di Efraim con le sue schiere; il principe de’ figliuoli di Efraim è Elishama, ");
INSERT INTO ita1927_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","figliuolo di Ammihud, e il suo corpo, secondo il censimento, è di quarantamila cinquecento uomini. ");
INSERT INTO ita1927_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Accanto a lui s’accamperà la tribù di Manasse; il principe de’ figliuoli di Manasse e Gamaliel, figliuolo di Pedahtsur, ");
INSERT INTO ita1927_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","e il suo corpo, secondo il censimento, è di trentaduemila duecento uomini. ");
INSERT INTO ita1927_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Poi la tribù di Beniamino; il principe dei figliuoli di Beniamino è Abidan, figliuolo di Ghideoni, ");
INSERT INTO ita1927_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","e il suo corpo, secondo il censimento, è di trentacinquemila quattrocento uomini. ");
INSERT INTO ita1927_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Il totale del censimento del campo d’Efraim è dunque centottomila cento uomini, secondo le loro schiere. Si metteranno in marcia in terza linea. ");
INSERT INTO ita1927_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","A settentrione starà il campo di Dan con le sue schiere; il principe de’ figliuoli di Dan è Ahiezer, figliuolo di Ammishaddai, ");
INSERT INTO ita1927_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","e il suo campo, secondo il censimento, è di sessantaduemila settecento uomini. ");
INSERT INTO ita1927_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Accanto a lui s’accamperà la tribù di Ascer; il principe de’ figliuoli di Ascer è Paghiel, figliuolo d’Ocran, ");
INSERT INTO ita1927_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","e il suo campo, secondo il censimento, è di quarantunmila cinquecento uomini. ");
INSERT INTO ita1927_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Poi la tribù di Neftali; il principe de’ figliuoli di Neftali è Ahira, figliuolo di Enan, ");
INSERT INTO ita1927_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","e il suo campo, secondo il censimento, è di cinquantatremila quattrocento uomini. ");
INSERT INTO ita1927_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Il totale del censimento del campo di Dan è dunque centocinquantasettemila seicento. Si metteranno in marcia gli ultimi, secondo le loro bandiere”. ");
INSERT INTO ita1927_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Questi furono i figliuoli d’Israele de’ quali si fece il censimento secondo le case dei loro padri. Tutti gli uomini de’ quali si fece il censimento, e che formarono i campi, secondo i loro corpi, furono seicentotremila cinquecentocinquanta. ");
INSERT INTO ita1927_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ma i Leviti, secondo l’ordirle che l’Eterno avea dato a Mosè, non furon compresi nel censimento coi figliuoli d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","E i figliuoli d’Israele si conformarono in tutto agli ordini che l’Eterno avea dati a Mosè: così s’accampavano secondo le loro bandiere, e così si mettevano in marcia, ciascuno secondo la sua famiglia, secondo la casa de’ suoi padri. ");
INSERT INTO ita1927_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Or questi sono i discendenti di Aaronne e di Mosè nel tempo in cui l’Eterno parlò a Mosè sul monte Sinai. ");
INSERT INTO ita1927_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Questi sono i nomi dei figliuoli di Aaronne: Nadab, il primogenito, Abihu, Eleazar e Ithamar. ");
INSERT INTO ita1927_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Tali i nomi dei figliuoli d’Aaronne, che ricevettero l’unzione come sacerdoti e furon consacrati per esercitare il sacerdozio. ");
INSERT INTO ita1927_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nadab e Abihu morirono davanti all’Eterno quand’offrirono fuoco straniero davanti all’Eterno, nel deserto di Sinai. Essi non aveano figliuoli, ed Eleazar e Ithamar esercitarono il sacerdozio in presenza d’Aaronne, loro padre. ");
INSERT INTO ita1927_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","E l’Eterno parlò a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Fa’ avvicinare la tribù de’ Leviti e ponila davanti al sacerdote Aaronne, affinché sia al suo servizio. ");
INSERT INTO ita1927_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Essi avranno la cura di tutto ciò che è affidato a lui e a tutta la raunanza davanti alla tenda di convegno e faranno così il servizio del tabernacolo. ");
INSERT INTO ita1927_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Avranno cura di tutti gli utensili della tenda di convegno e di quanto è affidato ai figliuoli d’Israele, e faranno così il servizio del tabernacolo. ");
INSERT INTO ita1927_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Tu darai i Leviti ad Aaronne e ai suoi figliuoli; essi gli sono interamente dati di tra i figliuoli d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Tu stabilirai Aaronne e i suoi figliuoli, perché esercitino le funzioni del loro sacerdozio; lo straniero che s’accosterà all’altare sarà messo a morte”. ");
INSERT INTO ita1927_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","E l’Eterno parlò a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Ecco, io ho preso i Leviti di tra i figliuoli d’Israele in luogo d’ogni primogenito che apre il seno materno tra i figliuoli d’Israele; e i Leviti saranno miei; ");
INSERT INTO ita1927_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","poiché ogni primogenito è mio; il giorno ch’io colpii tutti i primogeniti nel paese d’Egitto, io mi consacrerai tutti i primi parti in Israele, tanto degli uomini quanto degli animali; saranno miei: io sono l’Eterno”. ");
INSERT INTO ita1927_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","E l’Eterno parlò a Mosè nel deserto di Sinai, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Fa’ il censimento de’ figliuoli di Levi secondo le case de’ loro padri, secondo le loro famiglie; farai il censimento di tutti i maschi dall’età d’un mese in su”. ");
INSERT INTO ita1927_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","E Mosè ne fece il censimento secondo l’ordine dell’Eterno, come gli era stato comandato di fare. ");
INSERT INTO ita1927_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Questi sono i figliuoli di Levi, secondo i loro nomi: Gherson, Kehath e Merari. ");
INSERT INTO ita1927_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Questi i nomi dei figliuoli di Gherson, secondo le loro famiglie: Libni e Scimei. ");
INSERT INTO ita1927_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","E i figliuoli di Kehath, secondo le loro famiglie: Amram, Jitsehar, Hebron e Uzziel. ");
INSERT INTO ita1927_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","E i figliuoli di Merari secondo le loro famiglie: Mahli e Musci. Queste sono le famiglie dei Leviti, secondo le case de’ loro padri. ");
INSERT INTO ita1927_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Da Gherson discendono la famiglia dei Libniti e la famiglia dei Scimeiti, che formano le famiglie dei Ghersoniti. ");
INSERT INTO ita1927_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Quelli de’ quali fu fatto il censimento, contando tutti i maschi dall’età di un mese in su, furono settemila cinquecento. ");
INSERT INTO ita1927_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Le famiglie dei Ghersoniti avevano il campo dietro il tabernacolo, a occidente. ");
INSERT INTO ita1927_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Il principe della casa de’ padri dei Ghersoniti era Eliasaf, figliuolo di Lael. ");
INSERT INTO ita1927_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Per quel che concerne la tenda di convegno, i figliuoli di Gherson doveano aver cura del tabernacolo e della tenda, della sua coperta, della portiera all’ingresso della tenda di convegno, ");
INSERT INTO ita1927_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","delle tele del cortile e della portiera dell’ingresso del cortile, tutt’intorno al tabernacolo e all’altare, e dei suoi cordami per tutto il servizio del tabernacolo. ");
INSERT INTO ita1927_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Da Kehath discendono la famiglia degli Amramiti, la famiglia degli Jitsehariti, la famiglia degli Hebroniti e la famiglia degli Uzzieliti, che formano le famiglie dei Kehathiti. ");
INSERT INTO ita1927_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Contando tutti i maschi dall’età di un mese in su, furono ottomila seicento, incaricati della cura del santuario. ");
INSERT INTO ita1927_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Le famiglie dei figliuoli di Kehath avevano il campo al lato meridionale del tabernacolo. ");
INSERT INTO ita1927_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Il principe della casa de’ padri dei Kehathiti era Elitsafan, figliuolo di Uzziel. ");
INSERT INTO ita1927_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Alle loro cure erano affidati l’arca, la tavola, il candelabro, gli altari e gli utensili dei santuario coi quali si fa il servizio, il velo e tutto ciò che si riferisce al servizio del santuario. ");
INSERT INTO ita1927_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Il principe dei principi dei Leviti era Eleazar, figliuolo del sacerdote Aaronne; egli aveva la sorveglianza di quelli ch’erano incaricati della cura del santuario. ");
INSERT INTO ita1927_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Da Merari discendono la famiglia dei Mahliti e la famiglia dei Musciti, che formano le famiglie di Merari. ");
INSERT INTO ita1927_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Quelli di cui si fece il censimento, contando tutti i maschi dall’età di un mese in su, furono seimila duecento. ");
INSERT INTO ita1927_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Il principe della casa de’ padri delle famiglie di Merari era Tsuriel, figliuolo di Abihail. Essi aveano il campo dal lato settentrionale del tabernacolo. ");
INSERT INTO ita1927_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Alle cure dei figliuoli di Merari furono affidati le tavole del tabernacolo, le sue traverse, le sue colonne e le loro basi, tutti i suoi utensili e tutto ciò che si riferisce al servizio del tabernacolo, ");
INSERT INTO ita1927_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","le colonne del cortile tutt’intorno, le loro basi, i loro piuoli e il loro cordame. ");
INSERT INTO ita1927_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Sul davanti del tabernacolo, a oriente, di faccia alla tenda di convegno, verso il sol levante, avevano il campo Mosè, Aaronne e i suoi figliuoli; essi aveano la cura del santuario in luogo de’ figliuoli d’Israele; lo straniero che vi si fosse accostato sarebbe stato messo a morte. ");
INSERT INTO ita1927_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Tutti i Leviti di cui Mosè ed Aaronne fecero il censimento secondo le loro famiglie per ordine dell’Eterno, tutti i maschi dall’età di un mese in su, furono ventiduemila. ");
INSERT INTO ita1927_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","E l’Eterno disse a Mosè: “Fa’ il censimento di tutti i primogeniti maschi tra i figliuoli d’Israele dall’età di un mese in su e fa’ il conto dei loro nomi. ");
INSERT INTO ita1927_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Prenderai i Leviti per me io sono l’Eterno invece di tutti i primogeniti de’ figliuoli d’Israele e il bestiame dei Leviti in luogo dei primi parti del bestiame de’ figliuoli d’Israele”. ");
INSERT INTO ita1927_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","E Mosè fece il censimento di tutti i primogeniti tra i figliuoli d’Israele, secondo l’ordine che l’Eterno gli avea dato. ");
INSERT INTO ita1927_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Tutti i primogeniti maschi di cui si fece il censimento, contando i nomi dall’età di un mese in su, furono ventiduemila duecentosettantatre. ");
INSERT INTO ita1927_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","E l’Eterno parlò a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Prendi i Leviti in luogo di tutti i primogeniti dei figliuoli d’Israele, e il bestiame de’ Leviti in luogo del loro bestiame; e i Leviti saranno miei. Io sono l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Per il riscatto dei duecentosettantatre primogeniti dei figliuoli d’Israele che oltrepassano il numero dei Leviti, ");
INSERT INTO ita1927_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","prenderai cinque sicli a testa; li prenderai secondo il siclo dei santuario, che è di venti ghere. ");
INSERT INTO ita1927_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Darai il danaro ad Aaronne e ai suoi figliuoli per il riscatto di quelli che oltrepassano il numero dei Leviti”. ");
INSERT INTO ita1927_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","E Mosè prese il danaro per il riscatto di quelli che oltrepassavano il numero dei primogeniti riscattati dai Leviti; ");
INSERT INTO ita1927_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","prese il danaro dai primogeniti dei figliuoli d’Israele: milletrecento sessantacinque sicli, secondo il siclo del santuario. ");
INSERT INTO ita1927_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","E Mosè dette il danaro del riscatto ad Aaronne e ai suoi figliuoli, secondo l’ordine dell’Eterno, come l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","L’Eterno parlò ancora a Mosè e ad Aaronne, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Fate il conto dei figliuoli di Kehath, tra i figliuoli di Levi, secondo le loro famiglie, secondo le case dei loro padri, ");
INSERT INTO ita1927_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","dall’età di trent’anni in su fino all’età di cinquant’anni, di tutti quelli che possono assumere un ufficio per far l’opera nella tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Questo è il servizio che i figliuoli di Kehath avranno a fare nella tenda di convegno, e che concerne le cose santissime. ");
INSERT INTO ita1927_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Quando il campo si moverà, Aaronne e i suoi figliuoli verranno a smontare il velo di separazione, e copriranno con esso l’arca della testimonianza; ");
INSERT INTO ita1927_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","poi porranno sull’arca una coperta di pelli di delfino, vi stenderanno sopra un panno tutto di stoffa violacea e vi metteranno al posto le stanghe. ");
INSERT INTO ita1927_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Poi stenderanno un panno violaceo sulla tavola dei pani della presentazione, e vi metteranno su i piatti, le coppe, i bacini, i calici per le libazioni; e vi sarà su anche il pane perpetuo; ");
INSERT INTO ita1927_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","e su queste cose stenderanno un panno scarlatto, e sopra questo una coperta di pelli di delfino, e metteranno le stanghe alla tavola. ");
INSERT INTO ita1927_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Poi prenderanno un panno violaceo, col quale copriranno il candelabro, le sue lampade, le sue forbici, i suoi smoccolatoi e tutti i suoi vasi dell’olio destinati al servizio del candelabro; ");
INSERT INTO ita1927_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","metteranno il candelabro con tutti i suoi utensili in una coperta di pelli di delfino, e lo porranno sopra un paio di stanghe. ");
INSERT INTO ita1927_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Poi stenderanno sull’altare d’oro un panno violaceo, e sopra questo una coperta di pelli di delfino; e metteranno le stanghe all’altare. ");
INSERT INTO ita1927_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","E prenderanno tutti gli utensili di cui si fa uso per il servizio nel santuario, li metteranno in un panno violaceo, li avvolgeranno in una coperta di pelli di delfino e li porranno sopra un paio di stanghe. ");
INSERT INTO ita1927_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Poi toglieranno le ceneri dall’altare, e stenderanno sull’altare un panno scarlatto; ");
INSERT INTO ita1927_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","vi metteranno su tutti gli utensili destinati al suo servizio, i bracieri, i forchettoni, le palette, i bacini, tutti gli utensili dell’altare e vi stenderanno su una coperta li pelli di delfino; poi porranno le stanghe all’altare. ");
INSERT INTO ita1927_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","E dopo che Aaronne e i suoi figliuoli avranno finito di coprire il santuario e tutti gli arredi del santuario, quando il campo si moverà, i figliuoli di Kehath verranno per portar quelle cose; ma non toccheranno le cose sante, che non abbiano a morire. Queste sono le incombenze de’ figliuoli di Kehath nella tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Ed Eleazar, figliuolo del sacerdote Aaronne, avrà l’incarico dell’olio per il candelabro, del profumo fragrante, dell’offerta perpetua e dell’olio dell’unzione, e l’incarico di tutto il tabernacolo e di tutto ciò che contiene, del santuario e de’ suoi arredi”. ");
INSERT INTO ita1927_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Poi l’Eterno parlò a Mosè e ad Aaronne dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Badate che la tribù delle famiglie dei Kehathiti non abbia ad essere sterminata di fra i Leviti; ");
INSERT INTO ita1927_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","ma fate questo per loro, affinché vivano e non muoiano quando si accosteranno al luogo santissimo: Aaronne e i suoi figliuoli vengano e assegnino a ciascun d’essi il proprio servizio e il proprio incarico. ");
INSERT INTO ita1927_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","E non entrino quelli a guardare anche per un istante le cose sante, onde non muoiano”. ");
INSERT INTO ita1927_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Fa’ il conto anche dei figliuoli di Gherson, secondo le case dei loro padri, secondo le loro famiglie. ");
INSERT INTO ita1927_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Farai il censimento, dall’età di trent’anni in su fino all’età di cinquant’anni, di tutti quelli che possono assumere un ufficio per far l’opera nella tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Questo è il servizio delle famiglie dei Ghersoniti: quel che debbono fare e quello che debbono portare: ");
INSERT INTO ita1927_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","porteranno i teli del tabernacolo e la tenda di convegno, la sua coperta, la coperta di pelli di delfino che v’è sopra, e la portiera all’ingresso della tenda di convegno; ");
INSERT INTO ita1927_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","le cortine del cortile con la portiera dell’ingresso del cortile, cortine che stanno tutt’intorno al tabernacolo e all’altare, i loro cordami e tutti gli utensili destinati al loro servizio; faranno tutto il servizio che si riferisce queste cose. ");
INSERT INTO ita1927_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Tutto il servizio dei figliuoli dei Ghersoniti sarà sotto gli ordini di Aaronne e dei suoi figliuoli per tutto quello che dovranno portare e per tutto quello che dovranno fare; voi affiderete alla loro cura tutto quello che debbon portare. ");
INSERT INTO ita1927_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Tale è il servizio delle famiglie dei figliuoli del Ghersoniti nella tenda di convegno; e l’incarico loro sarà eseguito agli ordini di Ithamar figliuolo del sacerdote Aaronne. ");
INSERT INTO ita1927_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Farai il censimento dei figliuoli di Merari secondo le loro famiglie, secondo le case dei loro padri; ");
INSERT INTO ita1927_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","farai il censimento, dall’età di trent’anni in su fino all’età di cinquant’anni, di tutti quelli che possono assumere un ufficio per far l’opera nella tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Questo è quanto è affidato alle loro cure e quello che debbono portare, in conformità di tutto il loro servizio nella tenda di convegno: le assi del tabernacolo, le sue traverse, le sue colonne, le sue basi; ");
INSERT INTO ita1927_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","le colonne che sono intorno al cortile, le loro basi, i loro piuoli, i loro cordami, tutti i loro utensili e tutto il servizio che vi si riferisce. Farete l’inventario nominativo degli oggetti affidati alle loro cure e ch’essi dovranno portare. ");
INSERT INTO ita1927_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Tale è il servizio delle famiglie dei figliuoli di Merari, tutto il loro servizio nella tenda di convegno, sotto ali ordini di Ithamar, figliuolo del sacerdote Aaronne”. ");
INSERT INTO ita1927_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Mosè, Aaronne e i principi della raunanza fecero dunque il censimento dei figliuoli dei Kehathiti secondo le loro famiglie e secondo le case dei loro padri, ");
INSERT INTO ita1927_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","di tutti quelli che dall’età di trent’anni in su fino all’età di cinquant’anni potevano assumere un ufficio per far l’opera nella tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","E quelli di cui si fece il censimento secondo le loro famiglie, furono duemila settecentocinquanta. ");
INSERT INTO ita1927_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Questi son quelli delle famiglie dei Kehathiti dei quali si fece il censimento: tutti quelli che esercitavano un qualche ufficio nella tenda di convegno; Mosè ed Aaronne ne fecero il censimento secondo l’ordine che l’Eterno avea dato per mezzo di Mosè. ");
INSERT INTO ita1927_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","I figliuoli di Gherson, di cui si fece il censimento secondo le loro famiglie e secondo le case dei loro padri, ");
INSERT INTO ita1927_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","dall’età di trent’anni in su fino all’età di cinquant’anni, tutti quelli che potevano assumere un ufficio per far l’opera nella tenda di convegno, ");
INSERT INTO ita1927_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","quelli di cui si fece il censimento secondo le loro famiglie, secondo le case dei loro padri, furono duemila seicentotrenta. ");
INSERT INTO ita1927_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Questi son quelli delle famiglie dei figliuoli di Gherson, di cui si fece il censimento: tutti quelli che esercitavano un qualche ufficio nella tenda di convegno; Mosè ed Aaronne ne fecero il censimento secondo l’ordine dell’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Quelli delle famiglie dei figliuoli di Merari dei quali si fece il censimento secondo le loro famiglie, secondo le famiglie dei loro padri, ");
INSERT INTO ita1927_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","dall’età di trent’anni in su fino all’età di cinquant’anni, tutti quelli che potevano assumere un ufficio per far l’opera nella tenda di convegno, ");
INSERT INTO ita1927_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","quelli di cui si fece il censimento secondo le loro famiglie, furono tremila duecento. ");
INSERT INTO ita1927_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Questi son quelli delle famiglie dei figliuoli di Merari, di cui si fece il censimento; Mosè ed Aaronne ne fecero il censimento secondo l’ordine che l’Eterno avea dato per mezzo di Mosè. ");
INSERT INTO ita1927_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Tutti i Leviti dei quali Mosè, Aaronne e i principi d’Israele fecero il censimento secondo le loro famiglie e secondo le case dei loro padri, ");
INSERT INTO ita1927_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","dall’età di trent’anni in su fino all’età di cinquant’anni, tutti quelli che potevano assumere l’ufficio di servitori e l’ufficio di portatori nella tenda di convegno, ");
INSERT INTO ita1927_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","tutti quelli di cui si fece il censimento, furono ottomila cinquecento ottanta. ");
INSERT INTO ita1927_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Ne fu fatto il censimento secondo l’ordine che l’Eterno avea dato per mezzo di Mosè, assegnando a ciascuno il servizio che dovea fare e quello che dovea portare. Così ne fu fatto il censimento come l’Eterno avea ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Poi l’Eterno parlò a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Ordina ai figliuoli d’Israele che mandino fuori del campo ogni lebbroso, chiunque ha la gonorrea o è impuro per il contatto con un morto. ");
INSERT INTO ita1927_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Maschi o femmine che siano, li manderete fuori; li manderete fuori del campo perché non contaminino il loro campo in mezzo al quale io abito”. ");
INSERT INTO ita1927_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","I figliuoli d’Israele fecero così, e li mandarono fuori del campo. Come l’Eterno avea detto a Mosè, così fecero i figliuoli d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Di’ ai figliuoli d’Israele: Quando un uomo o una donna avrà fatto un torto a qualcuno commettendo una infedeltà rispetto all’Eterno, e questa persona si sarà così resa colpevole, ");
INSERT INTO ita1927_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","ella confesserà il peccato commesso, restituirà per intero il corpo del delitto, aggiungendovi in più un quinto, e lo darà a colui verso il quale si è resa colpevole. ");
INSERT INTO ita1927_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ma se questi non ha prossimo parente a cui si possa restituire il corpo del delitto, questo corpo del delitto restituito spetterà all’Eterno, cioè al sacerdote, oltre al montone espiatorio, mediante il quale si farà l’espiazione per il colpevole. ");
INSERT INTO ita1927_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Ogni offerta elevata di tutte le cose consacrate che i figliuoli d’Israele presenteranno al sacerdote, sarà del sacerdote; ");
INSERT INTO ita1927_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","le cose che uno consacrerà saranno del sacerdote; ciò che uno darà al sacerdote, apparterrà a lui”. ");
INSERT INTO ita1927_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Parla ai figliuoli d’Israele, e di’ loro: Se una donna si svia dal marito e commette una infedeltà contro di lui; ");
INSERT INTO ita1927_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","se uno ha relazioni carnali con lei e la cosa è nascosta agli occhi del marito; s’ella si è contaminata in segreto senza che vi sian testimoni contro di lei o ch’ella sia stata còlta sul fatto, ");
INSERT INTO ita1927_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","ove lo spirito di gelosia s’impossessi del marito e questi diventi geloso della moglie che si è contaminata, ovvero lo spirito di gelosia s’impossessi di lui e questi diventi geloso della moglie che non si è contaminata, ");
INSERT INTO ita1927_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","quell’uomo menerà la moglie al sacerdote, e porterà un’offerta per lei: un decimo d’efa di farina d’orzo; non vi spanderà sopra olio né vi metterà sopra incenso, perché è un’oblazione di gelosia, un’oblazione commemorativa, destinata a ricordare una iniquità. ");
INSERT INTO ita1927_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Il sacerdote farà avvicinare la donna, e la farà stare in piè davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Poi il sacerdote prenderà dell’acqua santa in un vaso di terra; prenderà pure della polvere ch’è sul suolo del tabernacolo, e la metterà nell’acqua. ");
INSERT INTO ita1927_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Il sacerdote farà quindi stare la donna in piè davanti all’Eterno, le scoprirà il capo e porrà in mano di lei l’oblazione commemorativa, ch’è l’oblazione di gelosia; e il sacerdote avrà in mano l’acqua amara che arreca maledizione ");
INSERT INTO ita1927_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Il sacerdote farà giurare quella donna, e le dirà: Se nessun uomo ha dormito teco, e se non ti sei sviata per contaminarti ricevendo un altro invece del tuo marito, quest’acqua amara che arreca maledizione, non ti faccia danno! ");
INSERT INTO ita1927_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Ma se tu ti sei sviata ricevendo un altro invece del tuo marito e ti sei contaminata, e altri che il tuo marito ha dormito teco… ");
INSERT INTO ita1927_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","allora il sacerdote farà giurare la donna con un giuramento d’imprecazione e le dirà: l’Eterno faccia di te un oggetto di maledizione e di esecrazione fra il tuo popolo, facendoti smagrire i fianchi e gonfiare il ventre; ");
INSERT INTO ita1927_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","e quest’acqua che arreca maledizione, t’entri nelle viscere per farti gonfiare il ventre e smagrire i fianchi! E la donna dirà: Amen! amen! ");
INSERT INTO ita1927_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Poi il sacerdote scriverà queste imprecazioni in un rotolo, e le cancellerà con l’acqua amara. ");
INSERT INTO ita1927_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Farà bere alla donna quell’acqua amara che arreca maledizione, e l’acqua che arreca maledizione entrerà in lei per produrle amarezza; ");
INSERT INTO ita1927_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","e il sacerdote prenderà dalle mani della donna l’oblazione di gelosia, agiterà l’oblazione davanti all’Eterno, e l’offrirà sull’altare; ");
INSERT INTO ita1927_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","e il sacerdote prenderà una manata di quell’oblazione come ricordanza, e la farà fumare sull’altare; poi farà bere l’acqua alla donna. ");
INSERT INTO ita1927_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","E quando le avrà fatto bere l’acqua, avverrà che, s’ella si è contaminata ed ha commesso una infedeltà contro il marito, l’acqua che arreca maledizione entrerà in lei per produrre amarezza; il ventre le si gonfierà, i suoi fianchi smagriranno, e quella donna diventerà un oggetto di maledizione in mezzo al suo popolo. ");
INSERT INTO ita1927_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Ma se la donna non si è contaminata ed è pura, sarà riconosciuta innocente, ed avrà de’ figliuoli. ");
INSERT INTO ita1927_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Questa è la legge relativa alla gelosia, per il caso in cui la moglie di uno si svii ricevendo un altro invece del suo marito, e si contamini, ");
INSERT INTO ita1927_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","e per il caso in cui lo spirito di gelosia s’impossessi del marito, e questi diventi geloso della moglie; egli farà comparire sua moglie davanti all’Eterno, e il sacerdote le applicherà questa legge integralmente. ");
INSERT INTO ita1927_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Il marito sarà immune da colpa, ma la donna porterà la pena della sua iniquità”. ");
INSERT INTO ita1927_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Parla ai figliuoli d’Israele e di’ loro: Quando un uomo o una donna avrà fatto un voto speciale, il voto di nazireato, ");
INSERT INTO ita1927_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","per consacrarsi all’Eterno, si asterrà dal vino e dalle bevande alcooliche; non berrà aceto fatto di vino, né aceto fatto di bevanda alcoolica; non berrà liquori tratti dall’uva, e non mangerà uva, né fresca né secca. ");
INSERT INTO ita1927_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Tutto il tempo del suo nazireato non mangeria alcun prodotto della vigna, dagli acini alla buccia. ");
INSERT INTO ita1927_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Tutto il tempo del suo voto di nazireato il rasoio non passerà sul suo capo; fino a che sian compiuti i giorni per i quali ei s’è consacrato all’Eterno, sarà santo; si lascerà crescer liberamente i capelli sul capo. ");
INSERT INTO ita1927_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Tutto il tempo ch’ei s’è consacrato all’Eterno, non si accosterà a corpo morto; ");
INSERT INTO ita1927_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","si trattasse anche di suo padre, di sua madre, del suo fratello e della sua sorella, non si contaminerà per loro alla loro morte, perché porta sul capo il segno della sua consacrazione a Dio. ");
INSERT INTO ita1927_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Tutto il tempo del suo nazireato egli è consacrato all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","E se uno gli muore accanto improvvisamente, e il suo capo consacrato rimane così contaminato, si raderà il capo il giorno della sua purificazione; se lo raderà il settimo giorno; ");
INSERT INTO ita1927_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","l’ottavo giorno porterà due tortore o due giovani piccioni al sacerdote, all’ingresso della tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","E il sacerdote ne offrirà uno come sacrifizio per il peccato e l’altro come olocausto, e farà per lui l’espiazione del peccato che ha commesso a cagion di quel morto; e, in quel giorno stesso, il nazireo consacrerà così il suo capo. ");
INSERT INTO ita1927_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Consacrerà di nuovo all’Eterno i giorni del suo nazireato, e offrirà un agnello dell’anno come sacrifizio di riparazione; i giorni precedenti non saranno contati, perché il suo nazireato è stato contaminato. ");
INSERT INTO ita1927_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Questa è la legge del nazireato: quando i giorni del suo nazireato saranno compiuti, lo si farà venire all’ingresso della tenda di convegno; ");
INSERT INTO ita1927_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","ed egli presenterà la sua offerta all’Eterno: un agnello dell’anno, senza difetto, per l’olocausto; una pecora dell’anno, senza difetto, per il sacrifizio per il peccato, e un montone senza difetto, per il sacrifizio di azioni di grazie; ");
INSERT INTO ita1927_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","un paniere di pani azzimi fatti con fior di farina, di focacce intrise con olio, di gallette senza lievito unte d’olio, insieme con l’oblazione e le libazioni relative. ");
INSERT INTO ita1927_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Il sacerdote presenterà quelle cose davanti all’Eterno, e offrirà il suo sacrifizio per il peccato e il suo olocausto; ");
INSERT INTO ita1927_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","offrirà il montone come sacrifizio di azioni di grazie all’Eterno col paniere dei pani azzimi; il sacerdote offrirà pure l’oblazione e la libazione. ");
INSERT INTO ita1927_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Il nazireo raderà, all’ingresso della tenda di convegno, il suo capo consacrato; prenderà i capelli del suo capo consacrato e li metterà sul fuoco che è sotto il sacrifizio di azioni di grazie. ");
INSERT INTO ita1927_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Il sacerdote prenderà la spalla del montone, quando sarà cotta, una focaccia non lievitata del paniere, una galletta senza lievito, e le porrà nelle mani del nazireo, dopo che questi avrà raso il suo capo consacrato. ");
INSERT INTO ita1927_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Il sacerdote le agiterà, come offerta agitata, davanti all’Eterno; è cosa santa che appartiene al sacerdote, assieme al petto dell’offerta agitata e alla spalla dell’offerta elevata. Dopo questo, il nazireo potrà bere del vino. ");
INSERT INTO ita1927_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Tale è la legge relativa a colui che ha fatto voto di nazireato, tale è la sua offerta all’Eterno per il suo nazireato, oltre quello che i suoi mezzi gli permetteranno di fare. Egli agirà secondo il voto che avrà fatto, conformemente alla legge del suo nazireato”. ");
INSERT INTO ita1927_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Parla ad Aaronne e al suoi figliuoli, e di’ loro: Voi benedirete così i figliuoli d’Israele; direte loro: ");
INSERT INTO ita1927_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","L’Eterno ti benedica e ti guardi! ");
INSERT INTO ita1927_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","L’Eterno faccia risplendere il suo volto su te e ti sia propizio! ");
INSERT INTO ita1927_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","L’Eterno volga verso te il suo volto, e ti dia la pace! ");
INSERT INTO ita1927_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Così metteranno il mio nome sui figliuoli d’Israele, e io li benedirò”. ");
INSERT INTO ita1927_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Il giorno che Mosè ebbe finito di rizzare il tabernacolo e l’ebbe unto e consacrato con tutti i suoi utensili, quando ebbe rizzato l’altare con tutti i suoi utensili, e li ebbe unti e consacrati, ");
INSERT INTO ita1927_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","i principi d’Israele, capi delle case de’ loro padri, che erano i principi delle tribù ed aveano presieduto al censimento, presentarono un’offerta ");
INSERT INTO ita1927_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","e la portarono davanti all’Eterno: sei carri-lettiga e dodici buoi; vale a dire un carro per due principi e un bove per ogni principe; e li offrirono davanti al tabernacolo. ");
INSERT INTO ita1927_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","E l’Eterno parlò a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Prendili da loro per impiegarli al servizio della tenda di convegno, e dalli ai Leviti; a ciascuno secondo le sue funzioni”. ");
INSERT INTO ita1927_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Mosè prese dunque i carri e i buoi, e li dette ai Leviti. ");
INSERT INTO ita1927_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Dette due carri e quattro buoi ai figliuoli di Gherson, secondo le loro funzioni; ");
INSERT INTO ita1927_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","dette quattro carri e otto buoi ai figliuoli di Merari, secondo le loro funzioni, sotto la sorveglianza d’Ithamar, figliuolo del sacerdote Aaronne; ");
INSERT INTO ita1927_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","ma ai figliuoli di Kehath non ne diede punti, perché avevano il servizio degli oggetti sacri e doveano portarli sulle spalle. ");
INSERT INTO ita1927_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","E i principi presentarono la loro offerta per la dedicazione dell’altare, il giorno ch’esso fu unto; i principi presentarono la loro offerta davanti all’altare. ");
INSERT INTO ita1927_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","E l’Eterno disse a Mosè: “I principi presenteranno la loro offerta uno per giorno, per la dedicazione dell’altare”. ");
INSERT INTO ita1927_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Colui che presentò la sua offerta il primo giorno fu Nahshon, figliuolo d’Amminadab della tribù di Giuda; ");
INSERT INTO ita1927_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","e la sua offerta fu un piatto d’argento del peso di centotrenta sicli, un bacino d’argento di settanta sicli, secondo il siclo del santuario, ambedue pieni di fior di farina intrisa con olio, per l’oblazione; ");
INSERT INTO ita1927_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","una coppa d’oro di dieci sicli piena di profumo, ");
INSERT INTO ita1927_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","un giovenco, un montone, ");
INSERT INTO ita1927_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","un agnello dell’anno per l’olocausto, un capro per il sacrifizio per il peccato, ");
INSERT INTO ita1927_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","e, per il sacrifizio di azioni di grazie, due buoi, cinque montoni, cinque capri, cinque agnelli dell’anno. Tale fu l’offerta di Nahshon, figliuolo d’Amminadab. ");
INSERT INTO ita1927_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Il secondo giorno, Nethaneel, figliuolo di Tsuar, principe d’Issacar, presentò la sua offerta. ");
INSERT INTO ita1927_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Offrì un piatto d’argento del peso di centotrenta sicli, un bacino d’argento di settanta sicli, secondo il siclo del santuario, ambedue pieni di fior di farina intrisa con olio, per l’oblazione; ");
INSERT INTO ita1927_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","una coppa d’oro di dieci sicli piena di profumo, ");
INSERT INTO ita1927_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","un giovenco, un montone, un agnello dell’anno per l’olocausto, ");
INSERT INTO ita1927_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","un capro per il sacrifizio per il peccato, ");
INSERT INTO ita1927_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","e, per il sacrifizio di azioni di grazie, due buoi, cinque montoni, cinque capri, cinque agnelli dell’anno. Tale fu l’offerta di Nethaneel, figliuolo di Tsuar. ");
INSERT INTO ita1927_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Il terzo giorno fu Eliab, figliuolo di Helon, principe dei figliuoli di Zabulon. ");
INSERT INTO ita1927_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","La sua offerta fu un piatto d’argento del peso di centotrenta sicli, un bacino d’argento di settanta sicli, secondo il siclo del santuario, ambedue pieni di fior di farina intrisa con olio, per l’oblazione; ");
INSERT INTO ita1927_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","una coppa d’oro di dieci sicli piena di profumo, ");
INSERT INTO ita1927_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","un giovenco, un montone, un agnello dell’anno per l’olocausto, ");
INSERT INTO ita1927_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","un capro per il sacrifizio per il peccato, ");
INSERT INTO ita1927_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","e, per sacrifizio da render grazie, due buoi, cinque montoni, cinque capri, cinque agnelli dell’anno. Tale fu l’offerta di Eliab, figliuolo di Helon. ");
INSERT INTO ita1927_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Il quarto giorno fu Elitsur, figliuolo di Scedeur, principe dei figliuoli di Ruben. ");
INSERT INTO ita1927_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","La sua offerta fu un piatto d’argento del peso di centotrenta sicli, un bacino d’argento di settanta sicli, secondo il siclo del santuario, ambedue pieni di fior di farina intrisa con olio, per l’oblazione; ");
INSERT INTO ita1927_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","una coppa d’oro di dieci sicli piena di profumo, ");
INSERT INTO ita1927_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","un giovenco, un montone, un agnello dell’anno per l’olocausto, ");
INSERT INTO ita1927_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","un capro per il sacrifizio per il peccato, ");
INSERT INTO ita1927_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","e, per sacrifizio di azioni di grazie, due buoi, cinque montoni, cinque capri, cinque agnelli dell’anno. Tale fu l’offerta di Elitsur, figliuolo di Scedeur. ");
INSERT INTO ita1927_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Il quinto giorno fu Scelumiel, figliuolo di Tsurishaddai, principe dei figliuoli di Simeone. ");
INSERT INTO ita1927_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","La sua offerta fu un piatto d’argento del peso di centotrenta sicli, un bacino d’argento di settanta sicli, secondo il siclo del santuario, ambedue pieni di fior di farina intrisa con olio, per l’oblazione; ");
INSERT INTO ita1927_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","una coppa d’oro di dieci sicli piena di profumo, ");
INSERT INTO ita1927_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","un giovenco, un montone, un agnello dell’anno per l’olocausto, ");
INSERT INTO ita1927_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","un capro per il sacrifizio per il peccato, ");
INSERT INTO ita1927_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","e, per sacrifizio di azioni di grazie, due buoi, cinque montoni, cinque capri, cinque agnelli dell’anno. Tale fu l’offerta di Scelumiel, figliuolo di Tsurishaddai. ");
INSERT INTO ita1927_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Il sesto giorno fu Eliasaf, figliuolo di Deuel, principe dei figliuoli di Gad. ");
INSERT INTO ita1927_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","La sua offerta fu un piatto d’argento del peso di centotrenta sicli, un bacino d’argento di settanta sicli, secondo il siclo del santuario, ambedue pieni di fior di farina intrisa con olio, per l’oblazione; ");
INSERT INTO ita1927_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","una coppa d’oro di dieci sicli piena di profumo, ");
INSERT INTO ita1927_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","un giovenco, un montone, un agnello dell’anno per l’olocausto, ");
INSERT INTO ita1927_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","un capro per il sacrifizio per il peccato, ");
INSERT INTO ita1927_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","e, per sacrifizio di azioni di grazie, due buoi, cinque montoni, cinque capri, cinque agnelli dell’anno. Tale fu l’offerta di Eliasaf, figliuolo di Deuel. ");
INSERT INTO ita1927_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Il settimo giorno fu Elishama, figliuolo di Ammihud, principe dei figliuoli d’Efraim. ");
INSERT INTO ita1927_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","La sua offerta fu un piatto d’argento del peso di centotrenta sicli, un bacino d’argento di settanta sicli, secondo il siclo del santuario, ambedue pieni di fior di farina intrisa con olio, per l’oblazione; ");
INSERT INTO ita1927_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","una coppa d’oro di dieci sicli piena di profumo, ");
INSERT INTO ita1927_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","un giovenco, un montone, un agnello dell’anno per l’olocausto, ");
INSERT INTO ita1927_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","un capro per il sacrifizio per il peccato, ");
INSERT INTO ita1927_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","e, per il sacrifizio di azioni di grazie, due buoi, cinque montoni, cinque capri, cinque agnelli dell’anno. Tale fu l’offerta di Elishama, figliuolo di Am. ");
INSERT INTO ita1927_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","L’ottavo giorno fu Gamaliel, figliuolo di Pedahtsur, principe dei figliuoli di Manasse. ");
INSERT INTO ita1927_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","La sua offerta fu un piatto d’argento del peso di centotrenta sicli, un bacino d’argento di settanta sicli, secondo il siclo del santuario, ambedue pieni di fior di farina intrisa con olio, per l’oblazione; ");
INSERT INTO ita1927_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","una coppa d’oro di dieci sicli piena di profumo, ");
INSERT INTO ita1927_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","un giovenco, un montone, un agnello dell’anno per l’olocausto, ");
INSERT INTO ita1927_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","un capro per il sacrifizio per il peccato, ");
INSERT INTO ita1927_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","e, per il sacrifizio di azioni di grazie, due buoi, cinque montoni, cinque capri, cinque agnelli dell’anno. Tale fu l’offerta di Gamaliel, figliuolo di Pedahtsur. ");
INSERT INTO ita1927_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Il nono giorno fu Abidan, figliuolo di Ghideoni, principe dei figliuoli di Beniamino. ");
INSERT INTO ita1927_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","La sua offerta fu un piatto d’argento del peso di centotrenta sicli, un bacino d’argento di settanta sicli, secondo il siclo del santuario, ambedue pieni di fior di farina intrisa con olio, per l’oblazione; ");
INSERT INTO ita1927_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","una coppa d’oro di dieci sicli piena di profumo, ");
INSERT INTO ita1927_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","un giovenco, un montone, un agnello dell’anno per l’olocausto, ");
INSERT INTO ita1927_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","un capro per il sacrifizio per il peccato, ");
INSERT INTO ita1927_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","e, per il sacrifizio di azioni di grazie, due buoi, cinque montoni, cinque capri, cinque agnelli dell’anno. Tale fu l’offerta di Abidan, figliuolo di Ghideoni. ");
INSERT INTO ita1927_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Il decimo giorno fu Ahiezer, figliuolo di Ammishaddai, principe dei figliuoli di Dan. ");
INSERT INTO ita1927_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","La sua offerta fu un piatto d’argento del peso di centotrenta sicli, un bacino d’argento di settanta sicli, secondo il siclo del santuario, ambedue pieni di fior di farina intrisa con olio, per l’oblazione; ");
INSERT INTO ita1927_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","una coppa d’oro di dieci sicli piena di profumo, ");
INSERT INTO ita1927_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","un giovenco, un montone, un agnello dell’anno per l’olocausto, ");
INSERT INTO ita1927_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","un capro per il sacrifizio per il peccato, ");
INSERT INTO ita1927_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","e, per il sacrifizio di azioni di grazie, due buoi, cinque montoni, cinque capri, cinque agnelli dell’anno. Tale fu l’offerta di Ahiezer, figliuolo di Ammishaddai. ");
INSERT INTO ita1927_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","L’undecimo giorno fu Paghiel, figliuolo di Ocran, principe dei figliuoli di Ascer. ");
INSERT INTO ita1927_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","La sua offerta fu un piatto d’argento del peso di centotrenta sicli, un bacino d’argento di settanta sicli, secondo il siclo del santuario, ambedue pieni di fior di farina intrisa con olio, per l’oblazione; ");
INSERT INTO ita1927_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","una coppa d’oro di dieci sicli piena di profumo, ");
INSERT INTO ita1927_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","un giovenco, un montone, un agnello dell’anno per l’olocausto, ");
INSERT INTO ita1927_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","un capro per il sacrifizio per il peccato, ");
INSERT INTO ita1927_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","e, per il sacrifizio di azioni di grazie, due buoi, cinque montoni, cinque capri, cinque agnelli dell’anno. Tale fu l’offerta di Paghiel, figliuolo di Ocran. ");
INSERT INTO ita1927_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Il dodicesimo giorno fu Ahira, figliuolo d’Enan, principe dei figliuoli di Neftali. ");
INSERT INTO ita1927_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","La sua offerta fu un piatto d’argento del peso di centotrenta sicli, un bacino d’argento di settanta sicli, secondo il siclo del santuario, ambedue pieni di fior di farina intrisa con olio, per l’oblazione; ");
INSERT INTO ita1927_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","una coppa d’oro di dieci sicli piena di profumo, ");
INSERT INTO ita1927_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","un giovenco, un montone, un agnello dell’anno per l’olocausto, ");
INSERT INTO ita1927_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","un capro per il sacrifizio per li peccato, ");
INSERT INTO ita1927_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","e, per il sacrifizio di azioni di grazie, due buoi, cinque montoni, cinque capri, cinque agnelli dell’anno. Tale fu l’offerta di Ahira, figliuolo di Enan. ");
INSERT INTO ita1927_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Questi furono i doni per la dedicazione dell’altare, da parte dei principi d’Israele, il giorno in cui esso fu unto: dodici piatti d’argento, dodici bacini d’argento, dodici coppe d’oro; ");
INSERT INTO ita1927_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ogni piatto d’argento pesava centotrenta sicli e ogni bacino d’argento, settanta; il totale dell’argento dei vasi fu duemila quattrocento sicli, secondo il siclo del santuario; ");
INSERT INTO ita1927_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","dodici coppe d’oro piene di profumo, le quali, a dieci sicli per coppa, secondo il siclo del santuario, dettero, per l’oro delle coppe, un totale di centoventi sicli. ");
INSERT INTO ita1927_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Totale del bestiame per l’olocausto: dodici giovenchi, dodici montoni, dodici agnelli dell’anno con le oblazioni ordinarie, e dodici capri per il sacrifizio per il peccato. ");
INSERT INTO ita1927_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Totale del bestiame per il sacrifizio di azioni di grazie: ventiquattro giovenchi, sessanta montoni, sessanta capri, sessanta agnelli dell’anno. Tali furono i doni per la dedicazione dell’altare, dopo ch’esso fu unto. ");
INSERT INTO ita1927_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","E quando Mosè entrava nella tenda di convegno per parlare con l’Eterno, udiva la voce che gli parlava dall’alto del propiziatorio che è sull’arca della testimonianza fra i due cherubini; e l’Eterno gli parlava. ");
INSERT INTO ita1927_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Parla ad Aaronne, e digli: Quando collocherai le lampade, le sette lampade dovranno proiettare la luce sul davanti del candelabro”. ");
INSERT INTO ita1927_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","E Aaronne fece così; collocò le lampade in modo che facessero luce sul davanti del candelabro, come l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Or il candelabro era fatto così: era d’oro battuto; tanto la sua base quanto i suoi fiori erano lavorati a martello. Mosè avea fatto il candelabro secondo il modello che l’Eterno gli avea mostrato. ");
INSERT INTO ita1927_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","E l’Eterno parlò a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Prendi i Leviti di tra i figliuoli d’Israele, e purificali. ");
INSERT INTO ita1927_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","E, per purificarli, farai così: li aspergerai con l’acqua dell’espiazione, essi faranno passare il rasoio su tutto il loro corpo, laveranno le loro vesti e si purificheranno. ");
INSERT INTO ita1927_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Poi prenderanno un giovenco con l’oblazione ordinaria di fior di farina intrisa con olio, e tu prenderai un altro giovenco per il sacrifizio per il peccato. ");
INSERT INTO ita1927_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Farai avvicinare i Leviti dinanzi alla tenda di convegno, e convocherai tutta la raunanza de’ figliuoli d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Farai avvicinare i Leviti dinanzi all’Eterno, e i figliuoli d’Israele poseranno le loro mani sui Leviti; ");
INSERT INTO ita1927_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","e Aaronne presenterà i Leviti come offerta agitata davanti all’Eterno da parte dei figliuoli d’Israele, ed essi faranno il servizio dell’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Poi i Leviti poseranno le loro mani sulla testa dei giovenchi, e tu ne offrirai uno come sacrifizio per il peccato e l’altro come olocausto all’Eterno, per fare l’espiazione per i Leviti. ");
INSERT INTO ita1927_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","E farai stare i Leviti in piè davanti ad Aaronne e davanti ai suoi figliuoli, e li presenterai come un’offerta agitata all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Così separerai i Leviti di tra i figliuoli d’Israele, e i Leviti saranno miei. ");
INSERT INTO ita1927_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Dopo questo, i Leviti verranno a fare il servizio nella tenda di convegno; e tu li purificherai, e li presenterai come un’offerta agitata; ");
INSERT INTO ita1927_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","poiché mi sono interamente dati di tra i figliuoli d’Israele; io li ho presi per me, invece di tutti quelli che aprono il seno materno, dei primogeniti di tutti i figliuoli d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Poiché tutti i primogeniti dei figliuoli d’Israele, tanto degli uomini quanto del bestiame, sono miei; io me li consacrai il giorno che percossi tutti i primogeniti nel paese d’Egitto. ");
INSERT INTO ita1927_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","E ho preso i Leviti invece di tutti i primogeniti dei figliuoli d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","E ho dato in dono ad Aaronne ed ai suoi figliuoli i Leviti di tra i figliuoli d’Israele, perché facciano il servizio de’ figliuoli d’Israele nella tenda di convegno, e perché facciano l’espiazione per i figliuoli d’Israele, onde nessuna piaga scoppi tra i figliuoli d’Israele per il loro accostarsi ai santuario”. ");
INSERT INTO ita1927_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Così fecero Mosè, Aaronne e tutta la raunanza dei figliuoli d’Israele rispetto ai Leviti; i figliuoli d’Israele fecero a loro riguardo tutto quello che l’Eterno avea ordinato a Mosè relativamente a loro. ");
INSERT INTO ita1927_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","E i Leviti si purificarono e lavarono le loro vesti; e Aaronne li presentò come un’offerta agitata davanti all’Eterno, e fece l’espiazione per essi, per purificarli. ");
INSERT INTO ita1927_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Dopo questo, i Leviti vennero a fare il loro servizio nella tenda di convegno in presenza di Aaronne e dei suoi figliuoli. Si fece rispetto ai Leviti secondo l’ordine che l’Eterno avea dato a Mosè circa loro. ");
INSERT INTO ita1927_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","E l’Eterno parlò a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Questo è quel che concerne i Leviti: da venticinque anni in su il Levita entrerà in servizio per esercitare un ufficio nella tenda di convegno; ");
INSERT INTO ita1927_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","e dall’età di cinquant’anni si ritirerà dall’esercizio dell’ufficio, e non servirà più. ");
INSERT INTO ita1927_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Potrà assistere i suoi fratelli nella tenda di convegno, sorvegliando ciò che è affidato alle loro cure; ma non farà più servizio. Così farai, rispetto ai Leviti, per quel che concerne i loro uffici”. ");
INSERT INTO ita1927_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","L’Eterno parlò ancora a Mosè, nel deserto di Sinai, il primo mese del secondo anno da che furono usciti dal paese d’Egitto, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“I figliuoli d’Israele celebreranno la pasqua nel tempo stabilito. ");
INSERT INTO ita1927_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","La celebrerete nel tempo stabilito, il quattordicesimo giorno di questo mese, sull’imbrunire; la celebrerete secondo tutte le leggi e secondo tutte le prescrizioni che vi si riferiscono”. ");
INSERT INTO ita1927_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","E Mosè parlò ai figliuoli d’Israele perché celebrassero la pasqua. ");
INSERT INTO ita1927_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Ed essi celebrarono la pasqua il quattordicesimo giorno del primo mese, sull’imbrunire, nel deserto di Sinai; i figliuoli d’Israele si conformarono a tutti gli ordini che l’Eterno avea dati a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Or v’erano degli uomini che, essendo impuri per aver toccato un morto, non potevan celebrare la pasqua in quel giorno. Si presentarono in quello stesso giorno davanti a Mosè e davanti ad Aaronne; ");
INSERT INTO ita1927_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","e quegli uomini dissero a Mosè: “Noi siamo impuri per aver toccato un morto; perché ci sarebb’egli tolto di poter presentare l’offerta dell’Eterno, al tempo stabilito, in mezzo ai figliuoli d’Israele?” ");
INSERT INTO ita1927_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","E Mosè rispose loro: “Aspettate, e sentirò quel che l’Eterno ordinerà a vostro riguardo”. ");
INSERT INTO ita1927_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","E l’Eterno parlò a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Parla ai figliuoli d’Israele, e di’ loro: Se uno di voi o de’ vostri discendenti sarà impuro per il contatto con un morto o sarà lontano in viaggio, celebrerà lo stesso la pasqua in onore dell’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","La celebreranno il quattordicesimo giorno del secondo mese, sull’imbrunire; la mangeranno con del pane senza lievito e con delle erbe amare; ");
INSERT INTO ita1927_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","non ne lasceranno nulla di resto fino al mattino, e non ne spezzeranno alcun osso. La celebreranno secondo tutte le leggi della pasqua. ");
INSERT INTO ita1927_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Ma colui ch’è puro e che non è in viaggio, se s’astiene dal celebrare la pasqua, quel tale sarà sterminato di fra il suo popolo; siccome non ha presentato l’offerta all’Eterno nel tempo stabilito, quel tale porterà la pena del suo peccato. ");
INSERT INTO ita1927_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","E se uno straniero che soggiorna tra voi celebra la pasqua dell’Eterno, si conformerà alle leggi e alle prescrizioni della pasqua. Avrete un’unica legge, per lo straniero e per il nativo del paese”. ");
INSERT INTO ita1927_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Or il giorno in cui il tabernacolo fu eretto, la nuvola coprì il tabernacolo, la tenda della testimonianza; e, dalla sera fino alla mattina, aveva sul tabernacolo l’apparenza d’un fuoco. ");
INSERT INTO ita1927_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Così avveniva sempre: la nuvola copriva il tabernacolo, e di notte avea l’apparenza d’un fuoco. ");
INSERT INTO ita1927_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","E tutte le volte che la nuvola s’alzava di sulla tenda, i figliuoli d’Israele si mettevano in cammino; e dove la nuvola si fermava, quivi i figliuoli d’Israele si accampavano. ");
INSERT INTO ita1927_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","I figliuoli d’Israele si mettevano in cammino all’ordine dell’Eterno, e all’ordine dell’Eterno si accampavano; rimanevano accampati tutto il tempo che la nuvola restava sul tabernacolo. ");
INSERT INTO ita1927_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","E quando la nuvola rimaneva per molti giorni sul tabernacolo, i figliuoli d’Israele osservavano la prescrizione dell’Eterno e non si movevano. ");
INSERT INTO ita1927_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","E se avveniva che la nuvola rimanesse pochi giorni sul tabernacolo, all’ordine dell’Eterno rimanevano accampati, e all’ordine dell’Eterno si mettevano in cammino. ");
INSERT INTO ita1927_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","E se la nuvola si fermava dalla sera alla mattina, e s’alzava la mattina, si mettevano in cammino; o se dopo un giorno e una notte la nuvola si alzava, si mettevano in cammino. ");
INSERT INTO ita1927_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Se la nuvola rimaneva ferma sul tabernacolo due giorni o un mese o un anno, i figliuoli d’Israele rimanevano accampati e non si moveano; ma, quando s’alzava, si mettevano in cammino. ");
INSERT INTO ita1927_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","All’ordine dell’Eterno si accampavano, e all’ordine dell’Eterno si mettevano in cammino; osservavano le prescrizioni dell’Eterno, secondo l’ordine trasmesso dall’Eterno per mezzo di Mosè. ");
INSERT INTO ita1927_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Fatti due trombe d’argento; le farai d’argento battuto; ti serviranno per convocare la raunanza e per far muovere i campi. ");
INSERT INTO ita1927_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Al suon d’esse tutta la raunanza si raccoglierà presso di te, all’ingresso della tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Al suono d’una tromba sola, i principi, i capi delle migliaia d’Israele, si aduneranno presso di te. ");
INSERT INTO ita1927_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Quando sonerete a lunghi e forti squilli, i campi che sono a levante si metteranno in cammino. ");
INSERT INTO ita1927_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Quando sonerete una seconda volta a lunghi e forti squilli, i campi che si trovano a mezzogiorno si metteranno in cammino; si sonerà a lunghi e forti squilli quando dovranno mettersi in cammino. ");
INSERT INTO ita1927_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Quando dev’esser convocata la raunanza, sonerete, ma non a lunghi e forti squilli. ");
INSERT INTO ita1927_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","E i sacerdoti figliuoli d’Aaronne soneranno le trombe; sarà una legge perpetua per voi e per i vostri discendenti. ");
INSERT INTO ita1927_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Quando nel vostro paese andrete alla guerra contro il nemico che vi attaccherà, sonerete a lunghi e forti squilli con le trombe, e sarete ricordati dinanzi all’Eterno, al vostro Dio, e sarete liberati dai vostri nemici. ");
INSERT INTO ita1927_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Così pure nei vostri giorni di gioia, nelle vostre solennità e al principio de’ vostri mesi, sonerete con le trombe quand’offrirete i vostri olocausti e i vostri sacrifizi di azioni di grazie; ed esse vi faranno ricordare nel cospetto del vostro Dio. Io sono l’Eterno, il vostro Dio”. ");
INSERT INTO ita1927_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Or avvenne che, il secondo anno il secondo mese, il ventesimo giorno del mese, la nuvola s’alzò di sopra il tabernacolo della testimonianza. ");
INSERT INTO ita1927_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","E i figliuoli d’Israele partirono dal deserto di Sinai, secondo l’ordine fissato per le loro marce; e la nuvola si fermò nel deserto di Paran. ");
INSERT INTO ita1927_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Così si misero in cammino la prima volta, secondo l’ordine dell’Eterno trasmesso per mezzo di Mosè. ");
INSERT INTO ita1927_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","La bandiera del campo de’ figliuoli di Giuda, diviso secondo le loro schiere, si mosse la prima. Nahshon, figliuolo di Amminadab comandava l’esercito di Giuda. ");
INSERT INTO ita1927_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Nethaneel, figliuolo di Tsuar, comandava l’esercito della tribù de’ figliuoli d’Issacar, ");
INSERT INTO ita1927_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ed Eliab, figliuolo di Helon, comandava l’esercito della tribù dei figliuoli di Zabulon. ");
INSERT INTO ita1927_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Il tabernacolo fu smontato, e i figliuoli di Gherson e i figliuoli di Merari si misero in cammino, portando il tabernacolo. ");
INSERT INTO ita1927_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Poi si mosse la bandiera del campo di Ruben, diviso secondo le sue schiere. Elitsur, figliuolo di Scedeur, comandava l’esercito di Ruben. ");
INSERT INTO ita1927_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Scelumiel, figliuolo di Tsurishaddai, comandava l’esercito della tribù de’ figliuoli di Simeone, ");
INSERT INTO ita1927_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ed Eliasaf, figliuolo di Deuel, comandava l’esercito della tribù de’ figliuoli di Gad. ");
INSERT INTO ita1927_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Poi si mossero i Kehathiti, portando gli oggetti sacri; e gli altri rizzavano il tabernacolo, prima che quelli arrivassero. ");
INSERT INTO ita1927_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Poi si mosse la bandiera del campo de’ figliuoli di Efraim, diviso secondo le sue schiere. Elishama, figliuolo di Ammihud, comandava l’esercito di Efraim. ");
INSERT INTO ita1927_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamaliel, figliuolo di Pedahtsur, comandava l’esercito della tribù dei figliuoli di Manasse, ");
INSERT INTO ita1927_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","e Abidan, figliuolo di Ghideoni, comandava l’esercito della tribù de’ figliuoli di Beniamino. ");
INSERT INTO ita1927_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Poi si mosse la bandiera del campo de’ figliuoli di Dan, diviso secondo le sue schiere, formando la retroguardia di tutti i campi. Ahiezer, figliuolo di Ammishaddai, comandava l’esercito di Dan. ");
INSERT INTO ita1927_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Paghiel, figliuolo di Ocran, comandava l’esercito della tribù de’ figliuoli di Ascer, ");
INSERT INTO ita1927_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","e Ahira, figliuolo di Enan, comandava l’esercito della tribù de’ figliuoli di Neftali. ");
INSERT INTO ita1927_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Tale era l’ordine in cui i figliuoli d’Israele si misero in cammino, secondo le loro schiere. E così partirono. ");
INSERT INTO ita1927_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Or Mosè disse a Hobab, figliuolo di Reuel, Madianita, suocero di Mosè: “Noi c’incamminiamo verso il luogo del quale l’Eterno ha detto: Io ve lo darò. Vieni con noi e ti faremo, del bene, perché l’Eterno ha promesso di far del bene a Israele”. ");
INSERT INTO ita1927_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hobab gli rispose: “Io non verrò, ma andrò al mio paese e dal miei parenti”. ");
INSERT INTO ita1927_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","E Mosè disse: “Deh, non ci lasciare; poiché tu conosci i luoghi dove dovremo accamparci nel deserto, e sarai la nostra guida. ");
INSERT INTO ita1927_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","E, se vieni con noi, qualunque bene l’Eterno farà a noi, noi lo faremo a te”. ");
INSERT INTO ita1927_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Così partirono dal monte dell’Eterno, e fecero tre giornate di cammino; e l’arca del patto dell’Eterno andava davanti a loro durante le tre giornate di cammino, per cercar loro un luogo di riposo. ");
INSERT INTO ita1927_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","E la nuvola dell’Eterno era su loro, durante il giorno, quando partivano dal campo. ");
INSERT INTO ita1927_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Quando l’arca partiva, Mosè diceva: “Lèvati, o Eterno, e siano dispersi i tuoi nemici, e fuggano dinanzi alla tua presenza quelli che t’odiano!” ");
INSERT INTO ita1927_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","E quando si posava, diceva: “Torna, o Eterno, alle miriadi delle schiere d’Israele!” ");
INSERT INTO ita1927_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Or il popolo fece giungere empi mormorii agli orecchi dell’Eterno; e come l’Eterno li udì, la sua ira si accese, il fuoco dell’Eterno divampò fra loro e divorò l’estremità del campo. ");
INSERT INTO ita1927_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","E il popolo gridò a Mosè; Mosè pregò l’Eterno, e il fuoco si spense. ");
INSERT INTO ita1927_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","E a quel luogo fu posto nome Taberah, perché il fuoco dell’Eterno avea divampato fra loro. ");
INSERT INTO ita1927_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","E l’accozzaglia di gente raccogliticcia ch’era tra il popolo, fu presa da concupiscenza; e anche i figliuoli d’Israele ricominciarono a piagnucolare e a dire: “Chi ci darà da mangiare della carne? ");
INSERT INTO ita1927_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Ci ricordiamo de’ pesci che mangiavamo in Egitto per nulla, de’ cocomeri, de’ poponi, de’ porri, delle cipolle e degli agli. ");
INSERT INTO ita1927_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","E ora l’anima nostra e inaridita; non c’è più nulla! gli occhi nostri non vedono altro che questa manna”. ");
INSERT INTO ita1927_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Or la manna era simile al seme di coriandolo e avea l’aspetto del bdellio. ");
INSERT INTO ita1927_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Il popolo andava attorno a raccoglierla; poi la riduceva in farina con le macine o la pestava nel mortaio, la faceva cuocere in pentole o ne faceva delle focacce, e aveva il sapore d’una focaccia con l’olio. ");
INSERT INTO ita1927_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Quando la rugiada cadeva sul campo, la notte, vi cadeva anche la manna. ");
INSERT INTO ita1927_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","E Mosè udì il popolo che piagnucolava, in tutte le famiglie, ognuno all’ingresso della propria tenda; l’ira dell’Eterno si accese gravemente, e la cosa dispiacque anche a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","E Mosè disse all’Eterno: “Perché hai trattato così male il tuo servo? perché non ho io trovato grazia agli occhi tuoi, che tu m’abbia messo addosso il carico di tutto questo popolo? ");
INSERT INTO ita1927_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","L’ho forse concepito io tutto questo popolo? o l’ho forse dato alla luce io, che tu mi dica: Portalo sul tuo seno, come il balio porta il bimbo lattante, fino al paese che tu hai promesso con giuramento ai suoi padri? ");
INSERT INTO ita1927_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Donde avrei io della carne da dare a tutto questo popolo? Poiché piagnucola dietro a me, dicendo: Dacci da mangiar della carne! ");
INSERT INTO ita1927_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Io non posso, da me solo, portare tutto questo popolo; è un peso troppo grave per me. ");
INSERT INTO ita1927_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","E se mi vuoi trattare così, uccidimi, ti prego; uccidimi, se ho trovato grazia agli occhi tuoi; e ch’io non vegga la mia sventura!” ");
INSERT INTO ita1927_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","E l’Eterno disse a Mosè: “Radunami settanta uomini degli anziani d’Israele, conosciuti da te come anziani del popolo e come aventi autorità sovr’esso; conducili alla tenda di convegno, e vi si presentino con te. ");
INSERT INTO ita1927_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Io scenderò e parlerò quivi teco; prenderò dello spirito che è su te e lo metterò su loro, perché portino con te il carico del popolo, e tu non lo porti più da solo. ");
INSERT INTO ita1927_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","E dirai al popolo: Santificatevi per domani, e mangerete della carne, poiché avete pianto agli orecchi dell’Eterno, dicendo: Chi ci farà mangiar della carne? Stavamo pur bene in Egitto! Ebbene, l’Eterno vi darà della carne, e voi ne mangerete. ");
INSERT INTO ita1927_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","E ne mangerete, non per un giorno, non per due giorni, non per cinque giorni, non per dieci giorni, non per venti giorni, ma per un mese intero, ");
INSERT INTO ita1927_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","finché vi esca per le narici e vi faccia nausea poiché avete rigettato l’Eterno che è in mezzo a voi, e avete pianto davanti a lui, dicendo: Perché mai siamo usciti dall’Egitto?” ");
INSERT INTO ita1927_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","E Mosè disse: “Questo popolo, in mezzo al quale mi trovo, novera seicentomila adulti, e tu hai detto: Io darò loro della carne, e ne mangeranno per un mese intero! ");
INSERT INTO ita1927_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Si scanneranno per loro greggi ed armenti in modo che n’abbiano abbastanza? o si radunerà per loro tutto il pesce del mare in modo che n’abbiano abbastanza?” ");
INSERT INTO ita1927_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","E l’Eterno rispose a Mosè: “La mano dell’Eterno è forse raccorciata? Ora vedrai se la parola che t’ho detta s’adempia o no”. ");
INSERT INTO ita1927_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Mosè dunque uscì e riferì al popolo le parole dell’Eterno; e radunò settanta uomini degli anziani del popolo, e li pose intorno alla tenda. ");
INSERT INTO ita1927_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","E l’Eterno scese nella nuvola e gli parlò; prese dello spirito ch’era su lui, e lo mise sui settanta anziani; e avvenne che quando lo spirito si fu posato su loro, quelli profetizzarono, ma non continuarono. ");
INSERT INTO ita1927_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Intanto, due uomini, l’uno chiamato Eldad e l’altro Medad, erano rimasti nel campo, e lo spirito si posò su loro; erano fra gl’iscritti, ma non erano usciti per andare alla tenda; e profetizzarono nel campo. ");
INSERT INTO ita1927_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Un giovine corse a riferire la cosa a Mosè, e disse: “Eldad e Medad profetizzano nel campo”. ");
INSERT INTO ita1927_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Allora Giosuè, figliuolo di Nun, servo di Mosè dalla sua giovinezza, prese a dire: “Mosè, signor mio, non glielo permettere!” ");
INSERT INTO ita1927_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Ma Mosè gli rispose: “Sei tu geloso per me? Oh! fossero pur tutti profeti nel popolo dell’Eterno, e volesse l’Eterno metter su loro lo spirito suo!” ");
INSERT INTO ita1927_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","E Mosè si ritirò nel campo, insieme con gli anziani d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","E un vento si levò, per ordine dell’Eterno, e portò delle quaglie dalla parte del mare, e le fe’ cadere presso il campo, sulla distesa di circa una giornata di cammino da un lato e una giornata di cammino dall’altro intorno al campo, e a un’altezza di circa due cubiti sulla superficie del suolo. ");
INSERT INTO ita1927_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","E il popolo si levò, e tutto quel giorno e tutta la notte e tutto il giorno seguente raccolse le quaglie. Chi ne raccolse meno n’ebbe dieci omer; e se le distesero tutt’intorno al campo. ");
INSERT INTO ita1927_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ne avevano ancora la carne fra i denti e non l’aveano peranco masticata, quando l’ira dell’Eterno s’accese contro il popolo, e l’Eterno percosse il popolo con una gravissima piaga. ");
INSERT INTO ita1927_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","E a quel luogo fu dato il nome di Kibroth-Hattaava, perché vi si seppellì la gente ch’era stata presa dalla concupiscenza. ");
INSERT INTO ita1927_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Da Kibroth-Hattaava il popolo partì per Hatseroth, e a Hatseroth si fermò. ");
INSERT INTO ita1927_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Maria ed Aaronne parlarono contro Mosè a cagione della moglie Cuscita che avea preso; poiché avea preso una moglie Cuscita. ");
INSERT INTO ita1927_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","E dissero: “L’Eterno ha egli parlato soltanto per mezzo di Mosè? non ha egli parlato anche per mezzo nostro?” E l’Eterno l’udì. ");
INSERT INTO ita1927_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Or Mosè era un uomo molto mansueto, più d’ogni altro uomo sulla faccia della terra. ");
INSERT INTO ita1927_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","E l’Eterno disse a un tratto a Mosè, ad Aaronne e a Maria: “Uscite voi tre, e andate alla tenda di convegno”. E uscirono tutti e tre. ");
INSERT INTO ita1927_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","E l’Eterno scese in una colonna di nuvola, si fermò all’ingresso della tenda, e chiamò Aaronne e Maria; ambedue si fecero avanti. ");
INSERT INTO ita1927_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","E l’Eterno disse: “Ascoltate ora le mie parole; se v’è tra voi alcun profeta, io, l’Eterno, mi faccio conoscere a lui in visione, parlo con lui in sogno. ");
INSERT INTO ita1927_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Non così coi mio servitore Mosè, che è fedele in tutta la mia casa. ");
INSERT INTO ita1927_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Con lui io parlo a tu per tu, facendomi vedere, e non per via d’enimmi; ed egli contempla la sembianza dell’Eterno. Perché dunque non avete temuto di parlar contro il mio servo, contro Mosè?” ");
INSERT INTO ita1927_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","E l’ira dell’Eterno s’accese contro loro, ed egli se ne andò, ");
INSERT INTO ita1927_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","e la nuvola si ritirò di sopra alla tenda; ed ecco che Maria era lebbrosa, bianca come neve; Aaronne guardò Maria, ed ecco era lebbrosa. ");
INSERT INTO ita1927_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","E Aaronne disse a Mosè: “Deh, signor mio, non ci far portare la pena di un peccato che abbiamo stoltamente commesso, e di cui siamo colpevoli. ");
INSERT INTO ita1927_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Deh, ch’ella non sia come il bimbo nato morto, la cui carne è già mezzo consumata quand’esce dal seno materno!” ");
INSERT INTO ita1927_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","E Mosè gridò all’Eterno dicendo: “Guariscila, o Dio, te ne prego!” ");
INSERT INTO ita1927_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","E l’Eterno rispose a Mosè: “Se suo padre le avesse sputato in viso, non ne porterebbe ella la vergogna per sette giorni? Stia dunque rinchiusa fuori del campo sette giorni; poi, vi sarà di nuovo ammessa”. ");
INSERT INTO ita1927_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Maria dunque fu rinchiusa fuori del campo sette giorni; e il popolo non si mise in cammino finché Maria non fu riammessa al campo. ");
INSERT INTO ita1927_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Poi il popolo partì da Hatseroth, e si accampò nel deserto di Paran. ");
INSERT INTO ita1927_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","L’Eterno parlò a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Manda degli uomini ad esplorare il paese di Canaan che io do ai figliuoli d’Israele. Mandate un uomo per ogni tribù de’ loro padri; siano tutti dei loro principi”. ");
INSERT INTO ita1927_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","E Mosè li mandò dal deserto di Paran, secondo l’ordine dell’Eterno; quegli uomini erano tutti capi de’ figliuoli d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","E questi erano i loro nomi: Per la tribù di Ruben: Shammua, figliuolo di Zaccur; per la tribù di Simeone: ");
INSERT INTO ita1927_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Shafat, figliuolo di Hori; ");
INSERT INTO ita1927_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","per la tribù di Giuda: Caleb, figliuolo di Gefunne; ");
INSERT INTO ita1927_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","per la tribù d’Issacar: Igal, figliuolo di Giuseppe; ");
INSERT INTO ita1927_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","per la tribù di Efraim: Hoscea, figliuolo di Nun; ");
INSERT INTO ita1927_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","per la tribù di Beniamino: Palti, figliuolo di Rafu; ");
INSERT INTO ita1927_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","per la tribù di Zabulon: Gaddiel, figliuolo di Sodi; ");
INSERT INTO ita1927_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","per la tribù di Giuseppe, cioè, per la tribù di Manasse: Gaddi figliuolo di Susi; ");
INSERT INTO ita1927_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","per la tribù di Dan: Ammiel, figliuolo di Ghemalli; ");
INSERT INTO ita1927_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","per la tribù di Ascer: Sethur, figliuolo di Micael; ");
INSERT INTO ita1927_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","per la tribù di Neftali: Nahbi, figliuolo di Vofsi; ");
INSERT INTO ita1927_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","per la tribù di Gad: Gheual, figliuolo di Machi. ");
INSERT INTO ita1927_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Tali i nomi degli uomini che Mosè mandò a esplorare il paese. E Mosè dette ad Hoscea, figliuolo di Nun, il nome di Giosuè. ");
INSERT INTO ita1927_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Mosè dunque li mandò ad esplorare il paese di Canaan, e disse loro: “Andate su di qua per il Mezzogiorno; poi salirete sui monti, ");
INSERT INTO ita1927_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","e vedrete che paese sia, che popolo l’abiti, se forte o debole, se poco o molto numeroso; ");
INSERT INTO ita1927_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","come sia il paese che abita, se buono o cattivo, e come siano le città dove abita, se siano degli accampamenti o dei luoghi fortificati; ");
INSERT INTO ita1927_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","e come sia il terreno, se grasso o magro, se vi siano alberi o no. Abbiate coraggio, e portate de’ frutti del paese”. Era il tempo che cominciava a maturar l’uva. ");
INSERT INTO ita1927_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Quelli dunque salirono ed esplorarono il paese dal deserto di Tsin fino a Rehob, sulla via di Hamath. ");
INSERT INTO ita1927_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Salirono per il mezzogiorno e andarono fino a Hebron, dov’erano Ahiman, Sceshai e Talmai, figliuoli di Anak. Or Hebron era stata edificata sette anni prima di Tsoan in Egitto. ");
INSERT INTO ita1927_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","E giunsero fino alla valle d’Eshcol, dove tagliarono un tralcio con un grappolo d’uva, che portarono in due con una stanga, e presero anche delle melagrane e dei fichi. ");
INSERT INTO ita1927_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Quel luogo fu chiamato valle d’Eshcol a motivo del grappolo d’uva che i figliuoli d’Israele vi tagliarono. ");
INSERT INTO ita1927_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","E alla fine di quaranta giorni tornarono dall’esplorazione del paese, ");
INSERT INTO ita1927_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","e andarono a trovar Mosè ed Aaronne e tutta la raunanza de’ figliuoli d’Israele nel deserto di Paran, a Kades; riferirono ogni cosa a loro e a tutta la raunanza, e mostraron loro i frutti del paese. ");
INSERT INTO ita1927_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","E fecero il loro racconto, dicendo: “Noi arrivammo nel paese dove tu ci mandasti, ed è davvero un paese dove scorre il latte e il miele, ed ecco de’ suoi frutti. ");
INSERT INTO ita1927_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Soltanto, il popolo che abita il paese è potente, le città sono fortificate e grandissime, e v’abbiamo anche veduto de’ figliuoli di Anak. ");
INSERT INTO ita1927_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Gli Amalekiti abitano la parte meridionale del paese; gli Hittei, i Gebusei e gli Amorei, la regione montuosa; e i Cananei abitano presso il mare e lungo il Giordano”. ");
INSERT INTO ita1927_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","E Caleb calmò il popolo che mormorava contro Mosè, e disse: “Saliamo pure e conquistiamo il paese; poiché possiamo benissimo soggiogarlo. ");
INSERT INTO ita1927_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ma gli uomini che v’erano andati con lui, dissero: “Noi non siam capaci di salire contro questo popolo; perché è più forte di noi”. ");
INSERT INTO ita1927_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","E screditarono presso i figliuoli d’Israele il paese che aveano esplorato, dicendo: “Il paese che abbiamo attraversato per esplorarlo, è un paese che divora i suoi abitanti; e tutta la gente che vi abbiam veduta, è gente d’alta statura; ");
INSERT INTO ita1927_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","e v’abbiam visto i giganti, figliuoli di Anak, della razza de’ giganti, appetto ai quali ci pareva d’esser locuste; e tali parevamo a loro”. ");
INSERT INTO ita1927_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Allora tutta la raunanza alzò la voce e diede in alte grida; e il popolo pianse tutta quella notte. ");
INSERT INTO ita1927_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","E tutti i figliuoli d’Israele mormorarono contro Mosè e contro Aaronne, e tutta la raunanza disse loro: “Fossimo pur morti nel paese d’Egitto! o fossimo pur morti in questo deserto! ");
INSERT INTO ita1927_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","E perché ci mena l’Eterno in quel paese ove cadremo per la spada? Le nostre mogli e i nostri piccini vi saranno preda del nemico. Non sarebb’egli meglio per noi di tornare in Egitto?” ");
INSERT INTO ita1927_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","E si dissero l’uno all’altro: “Nominiamoci un capo torniamo in Egitto!” ");
INSERT INTO ita1927_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Allora Mosè ed Aaronne si prostrarono a terra dinanzi a tutta l’assemblea riunita de’ figliuoli d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","E Giosuè, figliuolo di Nun, e Caleb, figliuolo di Gefunne, ch’erano di quelli che aveano esplorato il paese, si stracciarono le vesti, ");
INSERT INTO ita1927_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","e parlarono così a tutta la raunanza de’ figliuoli d’Israele: “Il paese che abbiamo attraversato per esplorarlo, è un paese buono, buonissimo. ");
INSERT INTO ita1927_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Se l’Eterno ci è favorevole, c’introdurrà in quel paese, e ce lo darà: è un paese dove scorre il latte e il miele. ");
INSERT INTO ita1927_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Soltanto, non vi ribellate all’Eterno, e non abbiate paura del popolo di quel paese; poiché ne faremo nostro pascolo; l’ombra che li copriva s’è ritirata, e l’Eterno è con noi; non ne abbiate paura”. ");
INSERT INTO ita1927_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Allora tutta la raunanza parlò di lapidarli; ma la gloria dell’Eterno apparve sulla tenda di convegno a tutti i figliuoli d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","E l’Eterno disse a Mosè: “Fino a quando mi disprezzerà questo popolo? e fino a quando non avranno fede in me dopo tutti i miracoli che ho fatto in mezzo a loro? ");
INSERT INTO ita1927_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Io lo colpirò con la peste, e lo distruggerò, ma farò di te una nazione più grande e più potente di lui”. ");
INSERT INTO ita1927_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","E Mosè disse all’Eterno: “Ma l’udranno gli Egiziani, di mezzo ai quali tu hai fatto salire questo popolo per la tua potenza, ");
INSERT INTO ita1927_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","e la cosa sarà risaputa dagli abitanti di questo paese. Essi hanno udito che tu, o Eterno, sei nel mezzo di questo popolo, che apparisci loro faccia a faccia, che la tua nuvola si ferma sopra loro, e che cammini davanti a loro il giorno in una colonna di nuvola, e la notte in una colonna di fuoco; ");
INSERT INTO ita1927_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","ora, se fai perire questo popolo come un sol uomo, le nazioni che hanno udito la tua fama, diranno: ");
INSERT INTO ita1927_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Siccome l’Eterno non è stato capace di far entrare questo popolo nel paese che avea giurato di dargli, li ha scannati nel deserto. ");
INSERT INTO ita1927_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","E ora si mostri, ti prego, la potenza del Signore nella sua grandezza, come tu hai promesso dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","L’Eterno è lento all’ira e grande in benignità; egli perdona l’iniquità e il peccato, ma non lascia impunito il colpevole, e punisce l’iniquità dei padri sui figliuoli, fino alla terza e alla quarta generazione. ");
INSERT INTO ita1927_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Deh, perdona l’iniquità di questo popolo, secondo la grandezza della tua benignità, nel modo che hai perdonato a questo popolo dall’Egitto fin qui”. ");
INSERT INTO ita1927_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","E l’Eterno disse: “Io perdono, come tu hai chiesto; ");
INSERT INTO ita1927_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","ma, com’è vero ch’io vivo, tutta la terra sarà ripiena della gloria dell’Eterno, ");
INSERT INTO ita1927_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","e tutti quegli uomini che hanno veduto la mia gloria e i miracoli che ho fatto in Egitto e nel deserto, e nonostante m’hanno tentato già dieci volte e non hanno ubbidito alla mia voce, ");
INSERT INTO ita1927_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","certo non vedranno il paese che promisi con giuramento ai loro padri. Nessuno di quelli che m’hanno disprezzato lo vedrà; ma il mio servo Caleb, ");
INSERT INTO ita1927_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","siccome è stato animato da un altro spirito e m’ha seguito appieno, io lo introdurrò nel paese nel quale è andato; e la sua progenie lo possederà. ");
INSERT INTO ita1927_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Or gli Amalekiti e i Cananei abitano nella valle; domani tornate addietro, incamminatevi verso il deserto, in direzione del mar Rosso”. ");
INSERT INTO ita1927_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","L’Eterno parlò ancora a Mosè e ad Aaronne, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Fino a quando sopporterò io questa malvagia raunanza che mormora contro di me? Io ho udito i mormorii che i figliuoli d’Israele fanno contro di me. ");
INSERT INTO ita1927_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Di’ loro: Com’è vero ch’io vivo, dice l’Eterno, io vi farò quello che ho sentito dire da voi. ");
INSERT INTO ita1927_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","I vostri cadaveri cadranno in questo deserto; e voi tutti, quanti siete, di cui s’è fatto il censimento, dall’età di venti anni in su, e che avete mormorato contro di me, ");
INSERT INTO ita1927_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","non entrerete di certo nel paese nei quale giurai di farvi abitare; salvo Caleb, figliuolo di Gefunne, e Giosuè, figliuolo di Nun. ");
INSERT INTO ita1927_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","I vostri piccini, che avete detto sarebbero preda de’ nemici, quelli vi farò entrare; ed essi conosceranno il paese che voi avete disdegnato. ");
INSERT INTO ita1927_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Ma quanto a voi, i vostri cadaveri cadranno in questo deserto. ");
INSERT INTO ita1927_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","E i vostri figliuoli andran pascendo i greggi nel deserto per quarant’anni e porteranno la pena delle vostre infedeltà, finché i vostri cadaveri non siano consunti nel deserto. ");
INSERT INTO ita1927_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Come avete messo quaranta giorni a esplorare il paese, porterete la pena delle vostre iniquità quarant’anni; un anno per ogni giorno; e saprete che cosa sia incorrere nella mia disgrazia. ");
INSERT INTO ita1927_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Io, l’Eterno, ho parlato; certo, così farò a tutta questa malvagia raunanza, la quale s’è messa assieme contro di me; in questo deserto saranno consunti; quivi morranno”. ");
INSERT INTO ita1927_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","E gli uomini che Mosè avea mandato ad esplorare il paese e che, tornati, avean fatto mormorare tutta la raunanza contro di lui screditando il paese, ");
INSERT INTO ita1927_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","quegli uomini, dico, che aveano screditato il paese, morirono colpiti da una piaga, dinanzi all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Ma Giosuè, figliuolo di Nun, e Caleb, figliuolo di Gefunne, rimasero vivi fra quelli ch’erano andati ad esplorare il paese. ");
INSERT INTO ita1927_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Or Mosè riferì quelle parole a tutti i figliuoli d’Israele; e il popolo ne fece gran cordoglio. ");
INSERT INTO ita1927_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","E la mattina si levarono di buon’ora e salirono sulla cima del monte, dicendo: “Eccoci qua; noi saliremo ai luogo di cui ha parlato l’Eterno, poiché abbiamo peccato”. ");
INSERT INTO ita1927_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Ma Mosè disse: “Perché trasgredite l’ordine dell’Eterno? La cosa non v’andrà bene. ");
INSERT INTO ita1927_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Non salite, perché l’Eterno non è in mezzo a voi; che non abbiate ad essere sconfitti dai vostri nemici! ");
INSERT INTO ita1927_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Poiché là, di fronte a voi, stanno gli Amalekiti e i Cananei, e voi cadrete per la spada; giacché vi siete sviati dall’Eterno, l’Eterno non sarà con voi”. ");
INSERT INTO ita1927_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Nondimeno, s’ostinarono a salire sulla cima del monte; ma l’arca del patto dell’Eterno e Mosè non si mossero di mezzo al campo. ");
INSERT INTO ita1927_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Allora gli Amalekiti e i Cananei che abitavano su quel monte scesero giù, li batterono, e li fecero a pezzi fino a Hormah. ");
INSERT INTO ita1927_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Poi l’Eterno parlò a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Parla ai figliuoli d’Israele e di’ loro: Quando sarete entrati nel paese che dovrete abitare e che io vi do, ");
INSERT INTO ita1927_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","e offrirete all’Eterno un sacrifizio fatto mediante il fuoco, olocausto o sacrifizio, per adempimento d’un voto o come offerta volontaria, o nelle vostre feste solenni, per fare un profumo soave all’Eterno col vostro grosso o minuto bestiame, ");
INSERT INTO ita1927_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","colui che presenterà la sua offerta all’Eterno, offrirà come oblazione un decimo d’efa di fior di farina stemperata col quarto di un hin d’olio, ");
INSERT INTO ita1927_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","e farai una libazione d’un quarto di hin di vino con l’olocausto o il sacrifizio, per ogni agnello. ");
INSERT INTO ita1927_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Se è per un montone, offrirai come oblazione due decimi d’efa di fior di farina stemperata col terzo di un hin d’olio, ");
INSERT INTO ita1927_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","e farai una libazione d’un terzo di hin di vino come offerta di odor soave all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","E se offri un giovenco come olocausto o come sacrifizio, per adempimento d’un voto o come sacrifizio d’azioni di grazie all’Eterno, ");
INSERT INTO ita1927_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","si offrirà, col giovenco, come oblazione, tre decimi d’efa di fior di farina stemperata con la metà di un hin d’olio, ");
INSERT INTO ita1927_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","e farai una libazione di un mezzo hin di vino: è un sacrifizio fatto mediante il fuoco, di soave odore all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Così si farà per ogni bue, per ogni montone, per ogni agnello o capretto. ");
INSERT INTO ita1927_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Qualunque sia il numero degli animali che immolerete, farete così per ciascuna vittima. ");
INSERT INTO ita1927_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Tutti quelli che sono nativi del paese faranno le cose così, quando offriranno un sacrifizio fatto mediante il fuoco, di soave odore all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","E se uno straniero che soggiorna da voi, o chiunque dimori fra voi nel futuro, offre un sacrifizio fatto mediante il fuoco, di soave odore all’Eterno, farà come fate voi. ");
INSERT INTO ita1927_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Vi sarà una sola legge per tutta l’assemblea, per voi e per lo straniero che soggiorna fra voi; sarà una legge perpetua, di generazione in generazione; come siete voi, così sarà lo straniero davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Ci sarà una stessa legge e uno stesso diritto per voi e per lo straniero che soggiorna da voi”. ");
INSERT INTO ita1927_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Parla ai figliuoli d’Israele e di’ loro: Quando sarete arrivati nel paese dove io vi conduco, ");
INSERT INTO ita1927_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","e mangerete del pane di quel paese, ne preleverete un’offerta da presentare all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Delle primizie della vostra pasta metterete da parte una focaccia come offerta; la metterete da parte, come si mette da parte l’offerta dell’aia. ");
INSERT INTO ita1927_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Delle primizie della vostra pasta darete all’Eterno una parte come offerta, di generazione in generazione. ");
INSERT INTO ita1927_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Quando avrete errato e non avrete osservato tutti questi comandamenti che l’Eterno ha dati a Mosè, ");
INSERT INTO ita1927_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","tutto quello che l’Eterno vi ha comandato per mezzo di Mosè, dal giorno che l’Eterno vi ha dato dei comandamenti e in appresso, nelle vostre successive generazioni, ");
INSERT INTO ita1927_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","se il peccato è stato commesso per errore, senza che la raunanza se ne sia accorta, tutta la raunanza offrirà un giovenco come olocausto di soave odore all’Eterno, con la sua oblazione e la sua libazione secondo le norme stabilite, e un capro come sacrifizio per il peccato. ");
INSERT INTO ita1927_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","E il sacerdote farà l’espiazione per tutta la raunanza dei figliuoli d’Israele, e sarà loro perdonato, perché è stato un peccato commesso per errore, ed essi hanno portato la loro offerta, un sacrifizio fatto all’Eterno mediante il fuoco, e il loro sacrifizio per il peccato dinanzi all’Eterno, a causa del loro errore. ");
INSERT INTO ita1927_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Sarà perdonato a tutta la raunanza de’ figliuoli d’Israele e allo straniero che soggiorna in mezzo a loro, perché tutto il popolo ha peccato per errore. ");
INSERT INTO ita1927_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Se è una persona sola che pecca per errore, offra una capra d’un anno come sacrifizio per il peccato. ");
INSERT INTO ita1927_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","E il sacerdote farà l’espiazione dinanzi all’Eterno per la persona che avrà mancato commettendo un peccato per errore; e quando avrà fatta l’espiazione per essa, le sarà perdonato. ");
INSERT INTO ita1927_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Sia che si tratti d’un nativo del paese tra i figliuoli d’Israele o d’uno straniero che soggiorna fra voi, avrete un’unica legge per colui che pecca per errore. ");
INSERT INTO ita1927_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Ma la persona che agisce con proposito deliberato, sia nativo del paese o straniero, oltraggia l’Eterno; quella persona sarà sterminata di fra il suo popolo. ");
INSERT INTO ita1927_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Siccome ha sprezzato la parola dell’Eterno e ha violato il suo comandamento, quella persona dovrà essere sterminata; porterà il peso della sua iniquità”. ");
INSERT INTO ita1927_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Or mentre i figliuoli d’Israele erano nel deserto, trovarono un uomo che raccoglieva delle legna in giorno di sabato. ");
INSERT INTO ita1927_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Quelli che l’aveano trovato a raccogliere le legna lo menarono a Mosè, ad Aaronne e a tutta la raunanza. ");
INSERT INTO ita1927_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","E lo misero in prigione, perché non era ancora stato stabilito che cosa gli si dovesse fare. ");
INSERT INTO ita1927_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","E l’Eterno disse a Mosè: “Quell’uomo dev’esser messo a morte; tutta la raunanza lo lapiderà fuori del campo”. ");
INSERT INTO ita1927_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Tutta la raunanza lo menò fuori del campo e lo lapidò; e quello morì, secondo l’ordine che l’Eterno avea dato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Parla ai figliuoli d’Israele e di’ loro che si facciano, di generazione in generazione, delle nappe agli angoli delle loro vesti, e che mettano alla nappa d’ogni angolo un cordone violetto. ");
INSERT INTO ita1927_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Sarà questa una nappa d’ornamento, e quando la guarderete, vi ricorderete di tutti i comandamenti dell’Eterno per metterli in pratica; e non andrete vagando dietro ai desideri del vostro cuore e dei vostri occhi che vi trascinano alla infedeltà. ");
INSERT INTO ita1927_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Così vi ricorderete di tutti i miei comandamenti, li metterete in pratica, e sarete santi al vostro Dio. ");
INSERT INTO ita1927_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Io sono l’Eterno, il vostro Dio, che vi ho tratti dal paese d’Egitto per essere vostro Dio. Io sono l’Eterno, l’Iddio vostro”. ");
INSERT INTO ita1927_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Or Kore, figliuolo di Itshar, figliuolo di Kehath, figliuolo di Levi, insieme con Dathan e Abiram figliuoli di Eliab, e On, figliuolo di Peleth, tutti e tre figliuoli di Ruben, ");
INSERT INTO ita1927_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","presero altra gente e si levaron su in presenza di Mosè, con duecentocinquanta uomini dei figliuoli d’Israele, principi della raunanza, membri dei consiglio, uomini di grido; ");
INSERT INTO ita1927_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","e, radunatisi contro Mosè e contro Aaronne, dissero loro: “Basta! tutta la raunanza, tutti fino ad uno son santi, e l’Eterno è in mezzo a loro; perché dunque v’innalzate voi sopra la raunanza dell’Eterno?” ");
INSERT INTO ita1927_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Quando Mosè ebbe udito questo, si prostrò colla faccia a terra; ");
INSERT INTO ita1927_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","poi parlò a Kore e a tutta la gente ch’era con lui, dicendo: “Domattina l’Eterno farà conoscere chi è suo e chi è santo, e se lo farà avvicinare: farà avvicinare a se colui ch’egli avrà scelto. ");
INSERT INTO ita1927_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Fate questo: prendete de’ turiboli, tu, Kore, e tutta la gente che è con te; ");
INSERT INTO ita1927_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","e domani mettetevi del fuoco, e ponetevi su del profumo dinanzi all’Eterno; e colui che l’Eterno avrà scelto sarà santo. Basta, figliuoli di Levi!” ");
INSERT INTO ita1927_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Mosè disse inoltre a Kore: “Ora ascoltate, o figliuoli di Levi! ");
INSERT INTO ita1927_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","E’ egli poco per voi che l’Iddio d’Israele v’abbia appartati dalla raunanza d’Israele e v’abbia fatto accostare a sé per fare il servizio del tabernacolo dell’Eterno e per tenervi davanti alla raunanza affin d’esercitare a pro suo il vostro ministerio? ");
INSERT INTO ita1927_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Egli vi fa accostare a sé, te e tutti i tuoi fratelli figliuoli di Levi con te, e cercate anche il sacerdozio? ");
INSERT INTO ita1927_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","E per questo tu e tutta la gente che è teco vi siete radunati contro l’Eterno! poiché chi è Aaronne che vi mettiate a mormorare contro di lui?” ");
INSERT INTO ita1927_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","E Mosè mandò a chiamare Dathan e Abiram, figliuoli di Eliab; ma essi dissero: “Noi non saliremo. ");
INSERT INTO ita1927_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","E’ egli poco per te l’averci tratti fuori da un paese ove scorre il latte e il miele, per farci morire nel deserto, che tu voglia anche farla da principe, si, da principe su noi? ");
INSERT INTO ita1927_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","E poi, non ci hai davvero condotti in un paese dove scorra il latte e il miele, e non ci hai dato possessi di campi e di vigne! Credi tu di potere render cieca questa gente? Noi non saliremo”. ");
INSERT INTO ita1927_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Allora Mosè si adirò forte e disse all’Eterno: “Non gradire la loro oblazione; io non ho preso da costoro neppure un asino, e non ho fatto torto ad alcuno di loro”. ");
INSERT INTO ita1927_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Poi Mosè disse a Kore: “Tu e tutta la tua gente trovatevi domani davanti all’Eterno: tu e loro, con Aaronne; ");
INSERT INTO ita1927_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","e ciascun di voi prenda il suo turibolo, vi metta del profumo, e porti ciascuno il suo turibolo davanti all’Eterno: saranno duecentocinquanta turiboli. Anche tu ed Aaronne prenderete ciascuno il vostro turibolo”. ");
INSERT INTO ita1927_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Essi dunque presero ciascuno il suo turibolo, vi misero del fuoco, vi posero su del profumo, e si fermarono all’ingresso della tenda di convegno; lo stesso fecero Mosè ed Aaronne. ");
INSERT INTO ita1927_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","E Kore convocò tutta la raunanza contro Mosè ed Aaronne all’ingresso della tenda di convegno; e la gloria dell’Eterno apparve a tutta la raunanza. ");
INSERT INTO ita1927_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","E l’Eterno parlò a Mosè e ad Aaronne, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Separatevi da questa raunanza, e io li consumerò in un attimo”. ");
INSERT INTO ita1927_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Ma essi, prostratisi con la faccia a terra, dissero: “O Dio, Dio degli spiriti d’ogni carne! Un uomo solo ha peccato, e ti adireresti tu contro tutta la raunanza?” ");
INSERT INTO ita1927_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","E l’Eterno parlò a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Parla alla raunanza e dille: Ritiratevi d’intorno alla dimora di Kore, di Dathan e di Abiram”. ");
INSERT INTO ita1927_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Mosè si levò e andò da Dathan e da Abiram; e gli anziani d’Israele lo seguirono. ");
INSERT INTO ita1927_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Ed egli parlò alla raunanza, dicendo: “Allontanatevi dalle tende di questi uomini malvagi, e non toccate nulla di ciò ch’è loro, affinché non abbiate a perire a cagione di tutti i loro peccati”. ");
INSERT INTO ita1927_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Così quelli si ritirarono d’intorno alla dimora di Kore, di Dathan e di Abiram. Dathan ed Abiram uscirono, e si fermarono all’ingresso delle loro tende con le loro mogli, i loro figliuoli e i loro piccini. E Mosè disse: ");
INSERT INTO ita1927_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","“Da questo conoscerete che l’Eterno mi ha mandato per fare tutte queste cose, e che io non le ho fatte di mia testa. ");
INSERT INTO ita1927_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Se questa gente muore come muoion tutti gli uomini, se la loro sorte è la sorte comune a tutti gli uomini, l’Eterno non mi ha mandato; ");
INSERT INTO ita1927_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","ma se l’Eterno fa una cosa nuova, se la terra apre la sua bocca e li ingoia con tutto quello che appartiene loro e s’essi scendono vivi nel soggiorno de’ morti, allora riconoscerete che questi uomini hanno disprezzato l’Eterno”. ");
INSERT INTO ita1927_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","E avvenne, com’egli ebbe finito di proferire tutte queste parole, che il suolo si spaccò sotto i piedi di coloro, ");
INSERT INTO ita1927_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","la terra spalancò la sua bocca e li ingoiò: essi e le loro famiglie, con tutta la gente che apparteneva a Kore, e tutta la loro roba. ");
INSERT INTO ita1927_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","E scesero vivi nel soggiorno de’ morti; la terra si richiuse su loro, ed essi scomparvero di mezzo all’assemblea. ");
INSERT INTO ita1927_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Tutto Israele ch’era attorno ad essi fuggì alle loro grida; perché dicevano: “Che la terra non inghiottisca noi pure!” ");
INSERT INTO ita1927_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","E un fuoco uscì dalla presenza dell’Eterno e divorò i duecentocinquanta uomini che offrivano il profumo. ");
INSERT INTO ita1927_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Poi l’Eterno parlò a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Di’ a Eleazar, figliuolo del sacerdote Aaronne, di trarre i turiboli di mezzo all’incendio e di disperdere qua e là il fuoco, perché quelli son sacri; ");
INSERT INTO ita1927_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","e dei turiboli di quegli uomini che hanno peccato al prezzo della loro vita si facciano tante lamine battute per rivestirne l’altare, poiché sono stati presentati davanti all’Eterno e quindi son sacri; e serviranno di segno ai figliuoli d’Israele”. ");
INSERT INTO ita1927_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","E il sacerdote Eleazar prese i turiboli di rame presentati dagli uomini ch’erano stati arsi; e furon tirati in lamine per rivestirne l’altare, ");
INSERT INTO ita1927_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","affinché servissero di ricordanza ai figliuoli d’Israele, e niun estraneo che non sia della progenie d’Aaronne s’accosti ad arder profumo davanti all’Eterno ed abbia la sorte di Kore e di quelli ch’eran con lui. Eleazar fece come l’Eterno gli avea detto per mezzo di Mosè. ");
INSERT INTO ita1927_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Il giorno seguente, tutta la raunanza de’ figliuoli d’Israele mormorò contro Mosè ed Aaronne dicendo: “Voi avete fatto morire il popolo dell’Eterno”. ");
INSERT INTO ita1927_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","E avvenne che, come la raunanza si faceva numerosa contro Mosè e contro Aaronne, i figliuoli d’Israele si volsero verso la tenda di convegno; ed ecco che la nuvola la ricoprì, e apparve la gloria dell’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Mosè ed Aaronne vennero davanti alla tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","E l’Eterno parlò a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Toglietevi di mezzo a questa raunanza, e io li consumerò in un attimo”. Ed essi si prostrarono con la faccia a terra. ");
INSERT INTO ita1927_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","E Mosè disse ad Aaronne: “Prendi il turibolo, mettivi del fuoco di sull’altare, ponvi su del profumo, e portalo presto in mezzo alla raunanza e fa’ l’espiazione per essi; poiché l’ira dell’Eterno è scoppiata, la piaga è già cominciata”. ");
INSERT INTO ita1927_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","E Aaronne prese il turibolo, come Mosè avea detto; corse in mezzo all’assemblea, ed ecco che la piaga era già cominciata fra il popolo; mise il profumo nel turibolo e fece l’espiazione per il popolo. ");
INSERT INTO ita1927_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","E si fermò tra i morti e i vivi, e la piaga fu arrestata. ");
INSERT INTO ita1927_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Or quelli che morirono di quella piaga furono quattordicimila settecento, oltre quelli che morirono per il fatto di Kore. ");
INSERT INTO ita1927_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Aaronne tornò a Mosè all’ingresso della tenda di convegno e la piaga fu arrestata. ");
INSERT INTO ita1927_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Poi l’Eterno parlò a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Parla ai figliuoli d’Israele, e fatti dare da loro delle verghe: una per ogni casa dei loro padri: cioè, dodici verghe da parte di tutti i loro principi secondo le case dei loro padri; scriverai il nome d’ognuno sulla sua verga; ");
INSERT INTO ita1927_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","e scriverai il nome d’Aaronne sulla verga di Levi; poiché ci sarà una verga per ogni capo delle case dei loro padri. ");
INSERT INTO ita1927_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","E riporrai quelle verghe nella tenda di convegno, davanti alla testimonianza, dove io mi ritrovo con voi. ");
INSERT INTO ita1927_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","E avverrà che l’uomo che io avrò scelto sarà quello la cui verga fiorirà; e farò cessare davanti a me i mormorii che i figliuoli d’Israele fanno contro di voi”. ");
INSERT INTO ita1927_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","E Mosè parlò ai figliuoli d’Israele, e tutti i loro principi gli dettero una verga per uno, secondo le case dei loro padri: cioè, dodici verghe; e la verga d’Aaronne era in mezzo alle verghe loro. ");
INSERT INTO ita1927_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","E Mosè ripose quelle verghe davanti all’Eterno nella tenda della testimonianza. ");
INSERT INTO ita1927_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","E avvenne, l’indomani, che Mosè entrò nella tenda della testimonianza; ed ecco che la verga d’Aaronne per la casa di Levi aveva fiorito, gettato dei bottoni, sbocciato dei fiori e maturato delle mandorle. ");
INSERT INTO ita1927_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Allora Mosè tolse tutte le verghe di davanti all’Eterno e le portò a tutti i figliuoli d’Israele; ed essi le videro e presero ciascuno la sua verga. ");
INSERT INTO ita1927_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","E l’Eterno disse a Mosè: “Riporta la verga d’Aaronne davanti alla testimonianza, perché sia conservata come un segno ai ribelli; onde sia messo fine ai loro mormorii contro di me, ed essi non muoiano”. ");
INSERT INTO ita1927_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Mosè fece così; fece come l’Eterno gli avea comandato. ");
INSERT INTO ita1927_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","E i figliuoli d’Israele dissero a Mosè: “Ecco, periamo! siam perduti! siam tutti perduti! ");
INSERT INTO ita1927_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Chiunque s’accosta, chiunque s’accosta al tabernacolo dell’Eterno, muore; dovrem perire tutti quanti?” ");
INSERT INTO ita1927_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","E l’Eterno disse ad Aaronne: “Tu, i tuoi figliuoli e la casa di tuo padre con te porterete il peso delle iniquità commesse nel santuario; e tu e i tuoi figliuoli porterete il peso delle iniquità commesse nell’esercizio del vostro sacerdozio. ");
INSERT INTO ita1927_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","E anche i tuoi fratelli, la tribù di Levi, la tribù di tuo padre, farai accostare a te, affinché ti siano aggiunti e ti servano quando tu e i tuoi figliuoli con te sarete davanti alla tenda della testimonianza. ");
INSERT INTO ita1927_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Essi faranno il servizio sotto i tuoi ordini in tutto quel che concerne la tenda; soltanto non si accosteranno agli utensili del santuario né all’altare affinché non moriate e gli uni e gli altri. ");
INSERT INTO ita1927_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Essi ti saranno dunque aggiunti, e faranno il servizio della tenda di convegno in tutto ciò che la concerne, e nessun estraneo s’accosterà a voi. ");
INSERT INTO ita1927_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","E voi farete il servizio del santuario e dell’altare affinché non vi sia più ira contro i figliuoli d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Quanto a me, ecco, io ho preso i vostri fratelli, i Leviti, di mezzo ai figliuoli d’Israele; dati all’Eterno, essi son rimessi in dono a voi per fare il servizio della tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","E tu e i tuoi figliuoli con te eserciterete il vostro sacerdozio in tutto ciò che concerne l’altare e in ciò ch’è di la dal velo; e farete il vostro servizio. Io vi do l’esercizio del sacerdozio come un dono; l’estraneo che si accosterà sarà messo a morte”. ");
INSERT INTO ita1927_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","L’Eterno disse ancora ad Aaronne: “Ecco, di tutte le cose consacrate dai figliuoli d’Israele io ti do quelle che mi sono offerte per elevazione: io te le do, a te e ai tuoi figliuoli, come diritto d’unzione, per legge perpetua. ");
INSERT INTO ita1927_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Questo ti apparterrà fra le cose santissime non consumate dal fuoco: tutte le loro offerte, vale a dire ogni oblazione, ogni sacrifizio per il peccato e ogni sacrifizio di riparazione che mi presenteranno; son tutte cose santissime che apparterranno a te ed ai tuoi figliuoli. ");
INSERT INTO ita1927_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Le mangerai in luogo santissimo; ne mangerà ogni maschio; ti saranno cose sante. ");
INSERT INTO ita1927_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Questo ancora ti apparterrà: i doni che i figliuoli d’Israele presenteranno per elevazione, e tutte le loro offerte agitate; io le do a te, ai tuoi figliuoli e alle tue figliuole con te, per legge perpetua. Chiunque sarà puro in casa tua ne potrà mangiare. ");
INSERT INTO ita1927_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Ti do pure tutte le primizie ch’essi offriranno all’Eterno: il meglio dell’olio e il meglio del mosto e del grano. ");
INSERT INTO ita1927_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Le primizie di tutto ciò che produrrà la loro terra e ch’essi presenteranno all’Eterno saranno tue. Chiunque sarà puro in casa tua ne potrà mangiare. ");
INSERT INTO ita1927_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Tutto ciò che sarà consacrato per voto d’interdetto in Israele sarà tuo. ");
INSERT INTO ita1927_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Ogni primogenito d’ogni carne ch’essi offriranno all’Eterno, così degli uomini come degli animali, sarà tuo; però, farai riscattare il primogenito dell’uomo, e farai parimente riscattare il primogenito d’un animale impuro. ");
INSERT INTO ita1927_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","E quanto al riscatto, li farai riscattare dall’età di un mese, secondo la tua stima, per cinque sicli d’argento, a siclo di santuario, che è di venti ghere. ");
INSERT INTO ita1927_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Ma non farai riscattare il primogenito della vacca né il primogenito della pecora né il primogenito della capra; sono cosa sacra; spanderai il loro sangue sull’altare, e farai fumare il loro grasso come sacrifizio fatto mediante il fuoco, di soave odore all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","La loro carne sarà tua; sarà tua come il petto dell’offerta agitata e come la coscia destra. ");
INSERT INTO ita1927_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Io ti do, a te, ai tuoi figliuoli e alle tue figliuole con te, per legge perpetua, tutte le offerte di cose sante che i figliuoli d’Israele presenteranno all’Eterno per elevazione. E un patto inalterabile, perpetuo, dinanzi all’Eterno, per te e per la tua progenie con te”. ");
INSERT INTO ita1927_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","L’Eterno disse ancora ad Aaronne: “Tu non avrai alcun possesso nel loro paese, e non ci sarà parte per te in mezzo a loro; io sono la tua parte e il tuo possesso in mezzo ai figliuoli d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","E ai figliuoli di Levi io do come possesso tutte le decime in Israele in contraccambio del servizio che fanno, il servizio della tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","E i figliuoli d’Israele non s’accosteranno più alla tenda di convegno, per non caricarsi d’un peccato che li trarrebbe a morte. ");
INSERT INTO ita1927_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Ma il servizio della tenda di convegno lo faranno soltanto i Leviti; ed essi porteranno il peso delle proprie iniquità; sarà una legge perpetua, di generazione in generazione; e non possederanno nulla tra i figliuoli d’Israele; ");
INSERT INTO ita1927_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","poiché io do come possesso ai Leviti le decime che i figliuoli d’Israele presenteranno all’Eterno come offerta elevata; per questo dico di loro: Non possederanno nulla tra i figliuoli d’Israele”. ");
INSERT INTO ita1927_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","E l’Eterno parlò a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Parlerai inoltre ai Leviti e dirai loro: Quando riceverete dai figliuoli d’Israele le decime che io vi do per conto loro come vostro possesso, ne metterete da parte un’offerta da fare all’Eterno: una decima della decima; ");
INSERT INTO ita1927_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","e l’offerta che avrete prelevata vi sarà contata come il grano che vien dall’aia e come il mosto che esce dallo strettoio. ");
INSERT INTO ita1927_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Così anche voi metterete da parte un’offerta per l’Eterno da tutte le decime che riceverete dai figliuoli d’Israele, e darete al sacerdote Aaronne l’offerta che avrete messa da parte per l’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Da tutte le cose che vi saranno donate metterete da parte tutte le offerte per l’Eterno; di tutto ciò che vi sarà di meglio metterete da parte quel tanto ch’è da consacrare. ");
INSERT INTO ita1927_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","E dirai loro: Quando ne avrete messo da parte il meglio, quel che rimane sarà contato ai Leviti come il provento dell’aia e come il provento dello strettoio. ");
INSERT INTO ita1927_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","E lo potrete mangiare in qualunque luogo, voi e le vostre famiglie, perché è la vostra mercede, in contraccambio del vostro servizio nella tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","E così non vi caricherete d’alcun peccato, giacché ne avrete messo da parte il meglio; e non profanerete le cose sante de’ figliuoli d’Israele, e non morrete”. ");
INSERT INTO ita1927_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","L’Eterno parlò ancora a Mosè e ad Aaronne, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Questo è l’ordine della legge che l’Eterno ha prescritta dicendo: Di’ ai figliuoli d’Israele che ti menino una giovenca rossa, senza macchia, senza difetti, e che non abbia mai portato il giogo. ");
INSERT INTO ita1927_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","E la darete al sacerdote Eleazar, che la condurrà fuori del campo e la farà scannare in sua presenza. ");
INSERT INTO ita1927_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Il sacerdote Eleazar prenderà col dito del sangue della giovenca, e ne farà sette volte l’aspersione dal lato dell’ingresso della tenda di convegno; ");
INSERT INTO ita1927_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","poi si brucerà la giovenca sotto gli occhi di lui; se ne brucerà la pelle, la carne e il sangue con i suoi escrementi. ");
INSERT INTO ita1927_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Il sacerdote prenderà quindi del legno di cedro, dell’issopo, della stoffa scarlatta, e getterà tutto in mezzo al fuoco che consuma la giovenca. ");
INSERT INTO ita1927_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Poi il sacerdote si laverà le vesti ed il corpo nell’acqua; dopo di che rientrerà nel campo, e il sacerdote sarà impuro fino alla sera. ");
INSERT INTO ita1927_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","E colui che avrà bruciato la giovenca si laverà le vesti nell’acqua, farà un’abluzione del corpo nell’acqua, e sarà impuro fino alla sera. ");
INSERT INTO ita1927_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Un uomo puro raccoglierà le ceneri della giovenca e le depositerà fuori del campo in luogo puro, dove saranno conservate per la raunanza de’ figliuoli d’Israele come acqua di purificazione: è un sacrifizio per il peccato. ");
INSERT INTO ita1927_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","E colui che avrà raccolto le ceneri della giovenca si laverà le vesti e sarà impuro fino alla sera. E questa sarà una legge perpetua per i figliuoli d’Israele e per lo straniero che soggiornerà da loro: ");
INSERT INTO ita1927_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","chi avrà toccato il cadavere di una persona umana sarà impuro sette giorni. ");
INSERT INTO ita1927_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Quand’uno si sarà purificato con quell’acqua il terzo e il settimo giorno, sarà puro; ma se non si purifica il terzo ed il settimo giorno, non sarà puro. ");
INSERT INTO ita1927_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Chiunque avrà toccato un morto, il corpo d’una persona umana che sia morta e non si sarà purificato, avrà contaminato la dimora dell’Eterno; e quel tale sarà sterminato di mezzo a Israele. Siccome l’acqua di purificazione non è stata spruzzata su lui, egli è impuro; ha ancora addosso la sua impurità. ");
INSERT INTO ita1927_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Questa è la legge: Quando un uomo sarà morto in una tenda, chiunque entrerà nella tenda e chiunque sarà nella tenda sarà impuro sette giorni. ");
INSERT INTO ita1927_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","E ogni vaso scoperto sul quale non sia coperchio attaccato, sarà impuro. ");
INSERT INTO ita1927_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","E chiunque, per i campi, avrà toccato un uomo ucciso per la spada o morto da sé, o un osso d’uomo, o un sepolcro, sarà impuro sette giorni. ");
INSERT INTO ita1927_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","E per colui che sarà divenuto impuro si prenderà della cenere della vittima arsa per il peccato, e vi si verserà su dell’acqua viva, in un vaso: ");
INSERT INTO ita1927_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","poi un uomo puro prenderà dell’issopo, lo intingerà nell’acqua, e ne spruzzerà la tenda, tutti gli utensili e tutte le persone che son quivi, e colui che ha toccato l’osso o l’ucciso o il morto da sé o il sepolcro. ");
INSERT INTO ita1927_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","L’uomo puro spruzzerà l’impuro il terzo giorno e il settimo giorno, e lo purificherà il settimo giorno; poi colui ch’è stato immondo si laverà le vesti, laverà sé stesso nell’acqua, e sarà puro la sera. ");
INSERT INTO ita1927_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Ma colui che divenuto impuro non si purificherà, sarà sterminato di mezzo alla raunanza, perché ha contaminato il santuario dell’Eterno; l’acqua della purificazione non è stata spruzzata su lui; è impuro. ");
INSERT INTO ita1927_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Sarà per loro una legge perpetua: Colui che avrà spruzzato l’acqua di purificazione si laverà le vesti; e chi avrà toccato l’acqua di purificazione sarà impuro fino alla sera. ");
INSERT INTO ita1927_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","E tutto quello che l’impuro avrà toccato sarà impuro; e la persona che avrà toccato lui sarà impura fino alla sera”. ");
INSERT INTO ita1927_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Or tutta la raunanza dei figliuoli d’Israele arrivò al deserto di Tsin il primo mese, e il popolo si fermò a Kades. Quivi morì e fu sepolta Maria. ");
INSERT INTO ita1927_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","E mancava l’acqua per la raunanza; onde ci fu un assembramento contro Mosè e contro Aaronne. ");
INSERT INTO ita1927_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","E il popolo contese con Mosè, dicendo: “Fossimo pur morti quando morirono i nostri fratelli davanti all’Eterno! ");
INSERT INTO ita1927_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","E perché avete menato la raunanza dell’Eterno in questo deserto per morirvi noi e il nostro bestiame? ");
INSERT INTO ita1927_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","E perché ci avete fatti salire dall’Egitto per menarci in questo tristo luogo? Non è un luogo dove sì possa seminare; non ci son fichi, non vigne, non melagrane, e non c’è acqua da bere”. ");
INSERT INTO ita1927_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Allora Mosè ed Aaronne s’allontanarono dalla raunanza per recarsi all’ingresso della tenda di convegno; si prostrarono con la faccia in terra, e la gloria dell’Eterno apparve loro. ");
INSERT INTO ita1927_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","E l’Eterno parlò a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Prendi il bastone; e tu e tuo fratello Aaronne convocate la raunanza e parlate a quel sasso, in loro presenza, ed esso darà la sua acqua; e tu farai sgorgare per loro dell’acqua dal sasso, e darai da bere alla raunanza e al suo bestiame”. ");
INSERT INTO ita1927_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Mosè dunque prese il bastone ch’era davanti all’Eterno, come l’Eterno gli aveva ordinato. ");
INSERT INTO ita1927_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","E Mosè ed Aaronne convocarono la raunanza dirimpetto al sasso, e Mosè disse loro: “Ora ascoltate, o ribelli; vi farem noi uscir dell’acqua da questo sasso?” ");
INSERT INTO ita1927_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","E Mosè alzò la mano, percosse il sasso col suo bastone due volte, e ne uscì dell’acqua in abbondanza; e la raunanza e il suo bestiame bevvero. ");
INSERT INTO ita1927_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Poi L’Eterno disse a Mosè e ad Aaronne: “Siccome non avete avuto fiducia in me per dar gloria al mio santo nome agli occhi dei figliuoli d’Israele, voi non introdurrete questa raunanza nel paese che io le do”. ");
INSERT INTO ita1927_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Queste sono le acque di Meriba dove i figliuoli d’Israele contesero con l’Eterno che si fece riconoscere come il Santo in mezzo a loro. ");
INSERT INTO ita1927_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Poi Mosè mandò da Kades degli ambasciatori al re di Edom per dirgli: “Così dice Israele tuo fratello: Tu sai tutte le tribolazioni che ci sono avvenute: ");
INSERT INTO ita1927_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","come i nostri padri scesero in Egitto e noi in Egitto dimorammo per lungo tempo e gli Egiziani maltrattaron noi e i nostri padri. ");
INSERT INTO ita1927_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","E noi gridammo all’Eterno ed egli udì la nostra voce e mandò un angelo e ci fece uscire dall’Egitto; ed eccoci ora in Kades, che è città agli estremi tuoi confini. ");
INSERT INTO ita1927_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Deh, lasciaci passare per il tuo paese, noi non passeremo né per campi né per vigne e non berremo l’acqua dei pozzi; seguiremo la strada pubblica senza deviare né a destra né a sinistra finché abbiamo oltrepassato i tuoi confini”. ");
INSERT INTO ita1927_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Ma Edom gli rispose: “Tu non passerai sul mio territorio; altrimenti, ti verrò contro con la spada”. ");
INSERT INTO ita1927_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","I figliuoli d’Israele gli dissero: “Noi saliremo per la strada maestra; e se noi e il nostro bestiame berremo dell’acqua tua, te la pagheremo; lasciami semplicemente transitare a piedi”. ");
INSERT INTO ita1927_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Ma quello rispose: “Non passerai!” E Edom mosse contro Israele con molta gente e con potente mano. ");
INSERT INTO ita1927_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Così Edom ricusò a Israele il transito per i suoi confini; onde Israele s’allontanò da lui. ");
INSERT INTO ita1927_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Tutta la raunanza de’ figliuoli d’Israele si partì da Kades e arrivò al monte Hor. ");
INSERT INTO ita1927_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","E l’Eterno parlò a Mosè e ad Aaronne al monte Hor sui confini del paese di Edom, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aaronne sta per esser raccolto presso il suo popolo, e non entrerà nel paese che ho dato ai figliuoli d’Israele, perché siete stati ribelli al mio comandamento alle acque di Meriba. ");
INSERT INTO ita1927_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Prendi Aaronne ed Eleazar suo figliuolo e falli salire sul monte Hor. ");
INSERT INTO ita1927_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Spoglia Aaronne de’ suoi paramenti, e rivestine Eleazar suo figliuolo; quivi Aaronne sarà raccolto presso il suo popolo, e morrà”. ");
INSERT INTO ita1927_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","E Mosè fece come l’Eterno aveva ordinato; ed essi salirono sul monte Hor, a vista di tutta la raunanza. ");
INSERT INTO ita1927_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Mosè spogliò Aaronne de’ suoi paramenti, e ne rivestì Eleazar, figliuolo di lui; e Aaronne morì quivi sulla cima del monte. Poi Mosè ed Eleazar scesero dal monte. ");
INSERT INTO ita1927_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","E quando tutta la raunanza vide che Aaronne era morto, tutta la casa d’Israele lo pianse per trenta giorni. ");
INSERT INTO ita1927_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Or il re cananeo di Arad, che abitava il mezzogiorno, avendo udito che Israele veniva per la via di Atharim, combatté contro Israele, e fece alcuni prigionieri. ");
INSERT INTO ita1927_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Allora Israele fece un voto all’Eterno, e disse: “Se tu dài nelle mie mani questo popolo, le loro città saranno da me votate allo sterminio”. ");
INSERT INTO ita1927_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","L’Eterno porse ascolto alla voce d’Israele e gli diede nelle mani i Cananei; e Israele votò allo sterminio i Cananei e le loro città, e a quel luogo fu posto nome Horma. ");
INSERT INTO ita1927_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Poi gl’Israeliti si partirono dal monte Hor, movendo verso il mar Rosso per fare il giro del paese di Edom; e il popolo si fe’ impaziente nel viaggio. ");
INSERT INTO ita1927_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","E il popolo parlò contro Dio e contro Mosè, dicendo: “Perché ci avete fatti salire fuori d’Egitto per farci morire in questo deserto? Poiché qui non c’è né pane né acqua, e l’anima nostra è nauseata di questo cibo tanto leggero”. ");
INSERT INTO ita1927_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Allora l’Eterno mandò fra il popolo de’ serpenti ardenti i quali mordevano la gente, e gran numero d’Israeliti morirono. ");
INSERT INTO ita1927_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Allora il popolo venne a Mosè e disse: “Abbiamo peccato, perché abbiam parlato contro l’Eterno e contro te; prega l’Eterno che allontani da noi questi serpenti”. E Mosè pregò per il popolo. ");
INSERT INTO ita1927_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","E l’Eterno disse a Mosè: “Fatti un serpente ardente, e mettilo sopra un’antenna; e avverrà che chiunque sarà morso e lo guarderà, scamperà”. ");
INSERT INTO ita1927_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Mosè allora fece un serpente di rame e lo mise sopra un’antenna; e avveniva che, quando un serpente avea morso qualcuno, se questi guardava il serpente di rame, scampava. ");
INSERT INTO ita1927_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Poi i figliuoli d’Israele partirono e si accamparono a Oboth; ");
INSERT INTO ita1927_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","e partitisi da Oboth, si accamparono a Ije-Abarim nel deserto ch’è dirimpetto a Moab dal lato dove sorge il sole. ");
INSERT INTO ita1927_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Di là si partirono e si accamparono nella valle di Zered. ");
INSERT INTO ita1927_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Poi si partirono di là e si accamparono dall’altro lato dell’Arnon, che scorre nel deserto e nasce sui confini degli Amorei: poiché l’Arnon e il confine di Moab, fra Moab e gli Amorei. ");
INSERT INTO ita1927_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Per questo è detto nel Libro delle Guerre dell’Eterno: “…Vaheb in Sufa, e le valli dell’Arnon ");
INSERT INTO ita1927_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","e i declivi delle valli che si estendono verso le dimore di Ar, e s’appoggiano alla frontiera di Moab”. ");
INSERT INTO ita1927_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","E di là andarono a Beer, che è il pozzo a proposito del quale l’Eterno disse a Mosè: “Raduna il popolo e io gli darò dell’acqua”. ");
INSERT INTO ita1927_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Fu in quell’occasione che Israele cantò questo cantico: “Scaturisci, o pozzo! Salutatelo con canti! ");
INSERT INTO ita1927_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Pozzo che i principi hanno scavato, che i nobili del popolo hanno aperto con lo scettro, coi loro bastoni!” ");
INSERT INTO ita1927_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Poi dal deserto andarono a Matthana; da Matthana a Nahaliel; da Nahaliel a Bamoth, ");
INSERT INTO ita1927_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","e da Bamoth nella valle che è nella campagna di Moab, verso l’altura del Pisga che domina il deserto. ");
INSERT INTO ita1927_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Or Israele mandò ambasciatori a Sihon, re degli Amorei, per dirgli: ");
INSERT INTO ita1927_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Lasciami passare per il tuo paese; noi non ci svieremo per i campi né per le vigne, non berremo l’acqua dei pozzi; seguiremo la strada pubblica finché abbiamo oltrepassato i tuoi confini”. ");
INSERT INTO ita1927_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Ma Sihon non permise a Israele di passare per i suoi confini; anzi radunò tutta la sua gente e uscì fuori contro Israele nel deserto; giunse a Jahats, e diè battaglia a Israele. ");
INSERT INTO ita1927_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Israele lo sconfisse passandolo a fil di spada, e conquistò il suo paese dall’Arnon fino al Jabbok, sino ai confini de’ figliuoli di Ammon, poiché la frontiera dei figliuoli di Ammon era forte. ");
INSERT INTO ita1927_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","E Israele prese tutte quelle città, e abitò in tutte le città degli Amorei: in Heshbon e in tutte le città del suo territorio; ");
INSERT INTO ita1927_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","poiché Heshbon era la città di Sihon, re degli Amorei, il quale avea mosso guerra al precedente re di Moab, e gli avea tolto tutto il suo paese fino all’Arnon. ");
INSERT INTO ita1927_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Per questo dicono i poeti: “Venite a Heshbon! La città di Sihon sia ricostruita e fortificata! ");
INSERT INTO ita1927_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Poiché un fuoco è uscito da Heshbon una fiamma dalla città di Sihon; essa ha divorato Ar di Moab, ");
INSERT INTO ita1927_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","i padroni delle alture dell’Arnon. Guai e te, o Moab! Sei perduto, o popolo di Kemosh! Kemosh ha fatto de’ suoi figliuoli tanti fuggiaschi, e ha dato le sue figliuole come schiave a Sihon, re degli Amorei. ");
INSERT INTO ita1927_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Noi abbiamo scagliato su loro le nostre frecce; Heshbon è distrutta fino a Dibon. Abbiam tutto devastato fino a Nofah, il fuoco e giunto fino a Medeba”. ");
INSERT INTO ita1927_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Così Israele si stabilì nel paese degli Amorei. ");
INSERT INTO ita1927_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Poi Mosè mandò a esplorare Jaezer, e gl’Israeliti presero le città del suo territorio e ne cacciarono gli Amorei che vi si trovavano. ");
INSERT INTO ita1927_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","E, mutata direzione, risalirono il paese in direzione di Bashan; e Og, re di Bashan, uscì contro loro con tutta la sua gente per dar loro battaglia a Edrei. ");
INSERT INTO ita1927_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Ma l’Eterno disse a Mosè: “Non lo temere; poiché io lo do nelle tue mani: lui, tutta la sua gente e il suo paese; trattalo com’hai trattato Sihon, re degli Amorei che abitava a Heshbon”. ");
INSERT INTO ita1927_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","E gli Israeliti batteron lui, coi suoi figliuoli e con tutto il suo popolo, in guisa che non gli rimase più anima viva; e s’impadronirono del suo paese. ");
INSERT INTO ita1927_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Poi i figliuoli d’Israele partirono e si accamparono nelle pianure di Moab, oltre il Giordano di Gerico. ");
INSERT INTO ita1927_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Or Balak, figliuolo di Tsippor, vide tutto quello che Israele avea fatto agli Amorei; ");
INSERT INTO ita1927_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","e Moab ebbe grande paura di questo popolo, ch’era così numeroso; Moab fu preso d’angoscia a cagione de’ figliuoli d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Onde Moab disse agli anziani di Madian: “Ora questa moltitudine divorerà tutto ciò ch’è dintorno a noi, come il bue divora l’erba dei campi”. Or Balak, figliuolo di Tsippor era, in quel tempo, re di Moab. ");
INSERT INTO ita1927_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Egli mandò ambasciatori a Balaam, figliuolo di Beor, a Pethor che sta sul fiume, nel paese de’ figliuoli del suo popolo per chiamarlo e dirgli: “Ecco un popolo è uscito d’Egitto; esso ricopre la faccia della terra, e si è stabilito dirimpetto a me; ");
INSERT INTO ita1927_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","or dunque vieni, te ne prego, e maledicimi questo popolo; poiché è troppo potente per me; forse così riusciremo a sconfiggerlo, e potrò cacciarlo dal paese; poiché so che chi tu benedici è benedetto, e chi tu maledici è maledetto”. ");
INSERT INTO ita1927_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Gli anziani di Moab e gli anziani di Madian partirono portando in mano la mercede dell’indovino; e, arrivati da Balaam, gli riferirono le parole di Balak. ");
INSERT INTO ita1927_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","E Balaam disse loro: “Alloggiate qui stanotte; e vi darò la risposta secondo che mi dirà l’Eterno”. E i principi di Moab stettero da Balaam. ");
INSERT INTO ita1927_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Or Dio venne a Balaam e gli disse: “Chi sono questi uomini che stanno da te?” ");
INSERT INTO ita1927_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","E Balaam rispose a Dio: “Balak, figliuolo di Tsippor, re di Moab, mi ha mandato a dire: ");
INSERT INTO ita1927_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Ecco, il popolo ch’è uscito d’Egitto ricopre la faccia della terra; or vieni a maledirmelo; forse riuscirò così a batterlo e potrò cacciarlo”. ");
INSERT INTO ita1927_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","E Dio disse a Balaam: “Tu non andrai con loro, non maledirai quel popolo, perché egli è benedetto”. ");
INSERT INTO ita1927_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Balaam si levò, la mattina, e disse ai principi di Balak: “Andatevene al vostro paese, perché l’Eterno m’ha rifiutato il permesso di andare con voi”. ");
INSERT INTO ita1927_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","E i principi di Moab si levarono, tornarono da Balak e dissero: “Balaam ha rifiutato di venir con noi”. ");
INSERT INTO ita1927_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Allora Balak mandò di nuovo de’ principi, in maggior numero e più ragguardevoli che que’ di prima. ");
INSERT INTO ita1927_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","I quali vennero da Balaam e gli dissero: “Così dice Balak, figliuolo di Tsippor: Deh, nulla ti trattenga dal venire da me; ");
INSERT INTO ita1927_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","poiché io ti ricolmerò di onori farò tutto ciò che mi dirai; vieni dunque, te ne prego, e maledicimi questo popolo”. ");
INSERT INTO ita1927_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Ma Balaam rispose e disse ai servi di Balak: “Quand’anche Balak mi desse la sua casa piena d’argento e d’oro, non potrei trasgredire l’ordine dell’Eterno, del mio Dio, per fare cosa piccola o grande che fosse. ");
INSERT INTO ita1927_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Nondimeno, trattenetevi qui, anche voi, stanotte, ond’io sappia ciò che l’Eterno mi dirà ancora”. ");
INSERT INTO ita1927_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","E Dio venne la notte a Balaam e gli disse: “Se quegli uomini son venuti a chiamarti, lèvati e va’ con loro; soltanto, farai ciò che io ti dirò”. ");
INSERT INTO ita1927_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balaam quindi si levò la mattina, sellò la sua asina, e se ne andò coi principi di Moab. ");
INSERT INTO ita1927_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Ma l’ira di Dio s’accese perché egli se n’era andato; e l’angelo dell’Eterno si pose sulla strada per fargli ostacolo. Or egli cavalcava la sua asina e avea seco due servitori. ");
INSERT INTO ita1927_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","L’asina, vedendo l’angelo dell’Eterno che stava sulla strada con la sua spada sguainata in mano, uscì di via e cominciava ad andare per i campi. Balaam percosse l’asina per rimetterla sulla strada. ");
INSERT INTO ita1927_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Allora l’angelo dell’Eterno si fermò in un sentiero incavato che passava tra le vigne e aveva un muro di qua e un muro di là. ");
INSERT INTO ita1927_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","L’asina vide l’angelo dell’Eterno; si serrò al muro e strinse il piede di Balaam al muro; e Balaam la percosse di nuovo. ");
INSERT INTO ita1927_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","L’angelo dell’Eterno passò di nuovo oltre, e si fermò in un luogo stretto dove non c’era modo di volgersi né a destra né a sinistra. ");
INSERT INTO ita1927_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","L’asina vide l’angelo dell’Eterno e si sdraiò sotto Balaam; l’ira di Balaam s’accese, ed egli percosse l’asina con un bastone. ");
INSERT INTO ita1927_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Allora l’Eterno aprì la bocca all’asina, che disse a Balaam: “Che t’ho io fatto che tu mi percuoti già per la terza volta?” ");
INSERT INTO ita1927_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","E Balaam rispose all’asina: “Perché ti sei fatta beffe di me. Ah se avessi una spada in mano! t’ammazzerei sull’attimo”. ");
INSERT INTO ita1927_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","L’asina disse a Balaam: “Non son io la tua asina che hai sempre cavalcata fino a quest’oggi? Sono io solita farti così?” Ed egli rispose: “No”. ");
INSERT INTO ita1927_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Allora l’Eterno aprì gli occhi a Balaam, ed egli vide l’angelo dell’Eterno che stava sulla strada, con la sua spada sguainata. Balaam s’inchinò e si prostrò con la faccia in terra. ");
INSERT INTO ita1927_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","L’angelo dell’Eterno gli disse: “Perché hai percosso la tua asina già tre volte? Ecco, io sono uscito per farti ostacolo, perché la via che batti è contraria al voler mio; ");
INSERT INTO ita1927_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","e l’asina m’ha visto ed è uscita di strada davanti a me queste tre volte; se non fosse uscita di strada davanti a me, certo io avrei già ucciso te e lasciato in vita lei”. ");
INSERT INTO ita1927_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Allora Balaam disse all’angelo dell’Eterno: “Io ho peccato, perché non sapevo che tu ti fossi posto contro di me sulla strada; e ora, se questo ti dispiace, io me ne ritornerò”. ");
INSERT INTO ita1927_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","E l’angelo dell’Eterno disse a Balaam: “Va’ pure con quegli uomini; ma dirai soltanto quello che io ti dirò”. E Balaam se ne andò coi principi di Balak. ");
INSERT INTO ita1927_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Quando Balak udì che Balaam arrivava, gli andò incontro a Jr-Moab che è sul confine segnato dall’Arnon, alla frontiera estrema. ");
INSERT INTO ita1927_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","E Balak disse a Balaam: “Non t’ho io mandato con insistenza a chiamare? perché non sei venuto da me? non son io proprio i grado di farti onore?” ");
INSERT INTO ita1927_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","E Balaam rispose a Balak: “Ecco, son venuto da te; ma posso io adesso dire qualsiasi cosa? la parola che Dio mi metterà in bocca, quella dirò”. ");
INSERT INTO ita1927_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Balaam andò con Balak, e giunsero a Kiriath-Hutsoth. ");
INSERT INTO ita1927_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","E Balak sacrificò buoi e pecore e mandò parte delle carni a Balaam e ai principi ch’eran con lui. ");
INSERT INTO ita1927_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","La mattina Balak prese Balaam e lo fece salire a Bamoth Baal, donde Balaam vide l’estremità del campo d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaam disse a Balak: “Edificami qui sette altari e preparami qui sette giovenchi e sette montoni”. ");
INSERT INTO ita1927_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak fece come Balaam avea detto e Balak e Balaam offrirono un giovenco e un montone su ciascun altare. ");
INSERT INTO ita1927_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","E Balaam disse a Balak: “Stattene presso al tuo olocausto, e io andrò: forse l’Eterno mi verrà incontro; e quei che mi avrà fatto vedere, te lo riferirò”. E se ne andò sopra una nuda altura. ");
INSERT INTO ita1927_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","E Dio si fece incontro a Balaam, e Balaam gli disse: “Io ho preparato i sette altari, ed ho offerto un giovenco e un montone su ciascun altare”. ");
INSERT INTO ita1927_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Allora l’Eterno mise delle parole in bocca a Balaam e gli disse: “Torna da Balak, e parla così”. ");
INSERT INTO ita1927_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Balaam tornò da Balak, ed ecco che questi stava presso al suo olocausto: egli con tutti i principi di Moab. ");
INSERT INTO ita1927_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Allora Balaam pronunziò il suo oracolo e disse: Balak m’ha fatto venire da Aram, re di Moab, dalle montagne d’Oriente. “Vieni”, disse, “maledicimi Giacobbe! Vieni, esecra Israele!” ");
INSERT INTO ita1927_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Come farò a maledire? Iddio non l’ha maledetto. Come farò ad esecrare? L’Eterno non l’ha esecrato. ");
INSERT INTO ita1927_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Io lo guardo dal sommo delle rupi e lo contemplo dall’alto dei colli; ecco, è un popolo che dimora solo, e non è contato nel novero delle nazioni. ");
INSERT INTO ita1927_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Chi può contar la polvere di Giacobbe o calcolare il quarto d’Israele? Possa io morire della morte dei giusti, e possa la mia fine esser simile alla loro! ");
INSERT INTO ita1927_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Allora Balak disse a Balaam: “Che m’hai tu fatto? T’ho preso per maledire i miei nemici, ed ecco, non hai fatto che benedirli”. ");
INSERT INTO ita1927_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","L’altro gli rispose e disse: “Non debbo io stare attento a dire soltanto ciò che l’Eterno mi mette in bocca?” ");
INSERT INTO ita1927_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","E Balak gli disse: “Deh, vieni meco in un altro luogo, donde tu lo potrai vedere; tu, di qui, non ne puoi vedere che una estremità; non lo puoi vedere tutto quanto; e di la me lo maledirai”. ");
INSERT INTO ita1927_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","E lo condusse al campo di Tsofim, sulla cima del Pisga; edificò sette altari, e offrì un giovenco e un montone su ciascun altare. ");
INSERT INTO ita1927_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","E Balaam disse a Balak: “Stattene qui presso ai tuo olocausto, e io andrò a incontrare l’Eterno”. ");
INSERT INTO ita1927_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","E l’Eterno si fece incontro a Balaam, gli mise delle parole in bocca e gli disse: “Torna da Balak, e parla così”. ");
INSERT INTO ita1927_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Balaam tornò da Balak, ed ecco che questi stava presso al suo olocausto, coi principi di Moab. E Balak gli disse: “Che ha detto l’Eterno?” ");
INSERT INTO ita1927_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Allora Balaam pronunziò il suo oracolo e disse: “Lèvati, Balak, e ascolta! Porgimi orecchio, figliuolo di Tsippor! ");
INSERT INTO ita1927_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Iddio non è un uomo, perch’ei mentisca, né un figliuol d’uomo, perch’ei si penta. Quand’ha detto una cosa non la farà? o quando ha parlato non manterrà la parola? ");
INSERT INTO ita1927_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Ecco, ho ricevuto l’ordine di benedire; egli ha benedetto; io non revocherò la benedizione. ");
INSERT INTO ita1927_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Egli non scorge iniquità in Giacobbe, non vede perversità in Israele. L’Eterno, il suo Dio, è con lui, e Israele lo acclama come suo re. ");
INSERT INTO ita1927_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Iddio lo ha tratto dall’Egitto e gli da il vigore del bufalo. ");
INSERT INTO ita1927_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","In Giacobbe non v’è magia, in Israele, non v’è divinazione; a suo tempo vien detto a Giacobbe e ad Israele qual è l’opera che Iddio compie. ");
INSERT INTO ita1927_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Ecco un popolo che si leva su come una leonessa, si rizza come un leone; ei non si sdraia prima d’aver divorato la preda e bevuto il sangue di quelli che ha ucciso”. ");
INSERT INTO ita1927_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Allora Balak disse a Balaam: “Non lo maledire, ma anche non lo benedire”. ");
INSERT INTO ita1927_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Ma Balaam rispose e disse a Balak: “Non t’ho io detto espressamente: Io farò tutto quello che l’Eterno dirà?” ");
INSERT INTO ita1927_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","E Balak disse a Balaam: “Deh, vieni, io ti condurrò in un altro luogo; forse piacerà a Dio che tu me lo maledica di là”. ");
INSERT INTO ita1927_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balak dunque condusse Balaam in cima al Peor che domina il deserto. ");
INSERT INTO ita1927_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","E Balaam disse a Balak: “Edificami qui sette altari, e preparami qui sette giovenchi e sette montoni”. ");
INSERT INTO ita1927_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak fece come Balaam avea detto, e offrì un giovenco e un montone su ciascun altare. ");
INSERT INTO ita1927_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","E Balaam, vedendo che piaceva all’Eterno di benedire Israele, non ricorse come le altre volte alla magia, ma voltò la faccia verso il deserto. ");
INSERT INTO ita1927_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","E, alzati gli occhi, Balaam vide Israele accampato tribù per tribù; e lo spirito di Dio fu sopra lui. ");
INSERT INTO ita1927_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","E Balaam pronunziò il suo oracolo e disse: “Così dice Balaam, figliuolo di Beor, così dice l’uomo che ha l’occhio aperto, ");
INSERT INTO ita1927_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","così dice colui che ode le parole di Dio, colui che contempla la visione dell’Onnipotente, colui che si prostra e a cui s’aprono gli occhi: ");
INSERT INTO ita1927_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Come son belle le tue tende, o Giacobbe, le tue dimore, o Israele! ");
INSERT INTO ita1927_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Esse si estendono come valli, come giardini in riva ad un fiume, come aloe piantati dall’Eterno, come cedri vicini alle acque. ");
INSERT INTO ita1927_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","L’acqua trabocca dalle sue secchie, la sua semenza è bene adacquata, il suo re sarà più in alto di Agag, e il suo regno sarà esaltato. ");
INSERT INTO ita1927_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Iddio che l’ha tratto d’Egitto, gli dà il vigore del bufalo. Egli divorerà i popoli che gli sono avversari, frantumerà loro le ossa, li trafiggerà con le sue frecce. ");
INSERT INTO ita1927_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Egli si china, s’accovaccia come un leone, come una leonessa: chi lo farà rizzare? Benedetto chiunque ti benedice maledetto chiunque ti maledice!” ");
INSERT INTO ita1927_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Allora l’ira di Balak s’accese contro Balaam; e Balak, battendo le mani, disse a Balaam: “Io t’ho chiamato per maledire i miei nemici, ed ecco che li hai benedetti già per la terza volta. ");
INSERT INTO ita1927_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Or dunque fuggitene a casa tua! Io avevo detto che ti colmerei di onori; ma, ecco, l’Eterno ti rifiuta gli onori”. ");
INSERT INTO ita1927_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","E Balaam rispose a Balak: “E non dissi io, fin da principio, agli ambasciatori che mi mandasti: ");
INSERT INTO ita1927_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Quand’anche Balak mi desse la sua casa piena d’argento e d’oro, non potrei trasgredire l’ordine dell’Eterno per far di mia iniziativa alcun che di bene o di male; ciò che l’Eterno dirà, quello dirò? ");
INSERT INTO ita1927_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Ed ora, ecco, io me ne vado al mio popolo; vieni, io t’annunzierò ciò che questo popolo farà al popolo tuo nei giorni avvenire”. ");
INSERT INTO ita1927_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Allora Balaam pronunziò il suo oracolo e disse: “Così dice Balaam, figliuolo di Beor; così dice l’uomo che ha l’occhio aperto, ");
INSERT INTO ita1927_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","così dice colui che ode le parole di Dio, che conosce la scienza dell’Altissimo, che contempla la visione dell’Onnipotente, colui che si prostra e a cui s’aprono gli occhi: ");
INSERT INTO ita1927_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Lo vedo, ma non ora; lo contemplo, ma non vicino: un astro sorge da Giacobbe, e uno scettro s’eleva da Israele, che colpirà Moab da un capo all’altro e abbatterà tutta quella razza turbolenta. ");
INSERT INTO ita1927_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","S’impadronirà di Edom, s’impadronirà di Seir, suo nemico; Israele farà prodezze. ");
INSERT INTO ita1927_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Da Giacobbe verrà un dominatore che sterminerà i superstiti delle città. ");
INSERT INTO ita1927_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Balaam vide anche Amalek, e pronunziò il suo oracolo, dicendo: “Amalek è la prima delle nazioni ma il suo avvenire fa capo alla rovina”. ");
INSERT INTO ita1927_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Vide anche i Kenei, e pronunziò il suo oracolo, dicendo: “La tua dimora è solida e il tuo nido è posto nella roccia; ");
INSERT INTO ita1927_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","nondimeno, il Keneo dovrà essere devastato, finché l’Assiro ti meni in cattività”. ");
INSERT INTO ita1927_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Poi pronunziò di nuovo il suo oracolo e disse: “Ahimè! Chi sussisterà quando Iddio avrà stabilito colui? ");
INSERT INTO ita1927_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Ma delle navi verranno dalle parti di Kittim e umilieranno Assur, umilieranno Eber, ed egli pure finirà per esser distrutto”. ");
INSERT INTO ita1927_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Poi Balaam si levò, partì e se ne tornò a casa sua; e Balak pure se ne andò per la sua strada. ");
INSERT INTO ita1927_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Or Israele era stanziato a Sittim, e il popolo cominciò a darsi alla impurità con le figliuole di Moab. ");
INSERT INTO ita1927_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Esse invitarono il popolo ai sacrifizi offerti ai loro dèi, e il popolo mangiò e si prostrò dinanzi agli dèi di quelle. ");
INSERT INTO ita1927_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Israele si unì a Baal-Peor, e l’ira dell’Eterno si accese contro Israele. ");
INSERT INTO ita1927_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","E l’Eterno disse a Mosè: “Prendi tutti i capi del popolo e falli appiccare davanti all’Eterno, in faccia al sole, affinché l’ardente ira dell’Eterno sia rimossa da Israele”. ");
INSERT INTO ita1927_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","E Mosè disse ai giudici d’Israele: “Ciascuno di voi uccida quelli de’ suoi uomini che si sono uniti a Baal-Peor”. ");
INSERT INTO ita1927_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Ed ecco che uno dei figliuoli d’Israele venne e condusse ai suoi fratelli una donna Madianita, sotto gli occhi di Mosè e di tutta la raunanza dei figliuoli d’Israele, mentr’essi stavano piangendo all’ingresso della tenda di convegno. ");
INSERT INTO ita1927_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","La qual cosa avendo veduta Fineas, figliuolo di Eleazar, figliuolo del sacerdote Aaronne, si alzò di mezzo alla raunanza e die’ di piglio ad una lancia; ");
INSERT INTO ita1927_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","andò dietro a quell’uomo d’Israele nella sua tenda, e li trafisse ambedue, l’uomo d’Israele e la donna, nel basso ventre. E il flagello cessò tra i figliuoli d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Di quel flagello morirono ventiquattromila persone. ");
INSERT INTO ita1927_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","L’Eterno parlò a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Fineas, figliuolo di Eleazar, figliuolo del sacerdote Aaronne, ha rimossa l’ira mia dai figliuoli d’Israele, perch’egli è stato animato del mio zelo in mezzo ad essi; ed io, nella mia indignazione, non ho sterminato i figliuoli d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Perciò digli ch’io fermo con lui un patto di pace, ");
INSERT INTO ita1927_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","che sarà per lui e per la sua progenie dopo di lui l’alleanza d’un sacerdozio perpetuo, perch’egli ha avuto zelo per il suo Dio, e ha fatta l’espiazione per i figliuoli d’Israele”. ");
INSERT INTO ita1927_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Or l’uomo d’Israele che fu ucciso con la donna Madianita, si chiamava Zimri, figliuolo di Salu, capo di una casa patriarcale dei Simeoniti. ");
INSERT INTO ita1927_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","E la donna che fu uccisa, la Madianita, si chiamava Cozbi, figliuola di Tsur, capo della gente di una casa patriarcale in Madian. ");
INSERT INTO ita1927_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Poi l’Eterno parlò a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Trattate i Madianiti come nemici e uccideteli, ");
INSERT INTO ita1927_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","poiché essi vi hanno trattati da nemici con gl’inganni mediante i quali v’hanno sedotti nell’affare di Peor e nell’affare di Cozbi, figliuola d’un principe di Madian, loro sorella, che fu uccisa il giorno della piaga causata dall’affare di Peor. ");
INSERT INTO ita1927_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Or avvenne che, dopo quella piaga, l’Eterno disse a Mosè e ad Eleazar, figliuolo del sacerdote Aaronne: ");
INSERT INTO ita1927_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Fate il conto di tutta la raunanza de’ figliuoli d’Israele, dall’età di vent’anni in su, secondo le case de’ loro padri, di tutti quelli che in Israele possono andare alla guerra”. ");
INSERT INTO ita1927_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","E Mosè e il sacerdote Eleazar parlarono loro nelle pianure di Moab presso al Giordano di faccia a Gerico, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Si faccia il censimento dall’età di venti anni in su, come l’Eterno ha ordinato a Mosè e ai figliuoli d’Israele, quando furono usciti dal paese d’Egitto”. ");
INSERT INTO ita1927_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruben, primogenito d’Israele. Figliuoli di Ruben: Hanoch, da cui discende la famiglia degli Hanochiti; Pallu, da cui discende la famiglia de’ Palluiti; ");
INSERT INTO ita1927_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hetsron, da cui discende la famiglia degli Hetsroniti; Carmi da cui discende la famiglia de’ Carmiti. ");
INSERT INTO ita1927_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Tali sono le famiglie dei Rubeniti: e quelli dei quali si fece il censimento furono quarantatremila settecentotrenta. ");
INSERT INTO ita1927_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Figliuoli di Pallu: Eliab. ");
INSERT INTO ita1927_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Figliuoli di Eliab: Nemuel, Dathan ed Abiram. Questi sono quel Dathan e quell’Abiram, membri del consiglio, che si sollevarono contro Mosè e contro Aaronne con la gente di Kore, quando si sollevarono contro l’Eterno; ");
INSERT INTO ita1927_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","e la terra aprì la sua bocca e li inghiottì assieme con Kore, allorché quella gente perì, e il fuoco divorò duecentocinquanta uomini, che servirono d’esempio. ");
INSERT INTO ita1927_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Ma i figliuoli di Kore non perirono. ");
INSERT INTO ita1927_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Figliuoli di Simeone secondo le loro famiglie. Da Nemuel discende la famiglia dei Nemueliti; da Jamin, la famiglia degli Jaminiti; da Jakin, la famiglia degli Jakiniti; da Zerach, la famiglia de’ Zerachiti; ");
INSERT INTO ita1927_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","da Saul, la famiglia dei Sauliti. ");
INSERT INTO ita1927_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Tali sono le famiglie dei Simeoniti: ventiduemila duecento. ");
INSERT INTO ita1927_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Figliuoli di Gad secondo le loro famiglie. Da Tsefon discende la famiglia dei Tsefoniti; da Hagghi, la famiglia degli Hagghiti; da Shuni, la famiglia degli Shuniti; ");
INSERT INTO ita1927_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","da Ozni, la famiglia degli Ozniti; da Eri, la famiglia degli Eriti; ");
INSERT INTO ita1927_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","da Arod, la famiglia degli Aroditi; da Areli, la famiglia degli Areliti. ");
INSERT INTO ita1927_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Tali sono le famiglie dei figliuoli di Gad secondo il loro censimento: quarantamila cinquecento. ");
INSERT INTO ita1927_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Figliuoli di Giuda: Er e Onan; ma Er e Onan morirono nel paese di Canaan ");
INSERT INTO ita1927_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Ecco i figliuoli di Giuda secondo le loro famiglie: da Scelah discende la famiglia degli Shelaniti; da Perets, la famiglia dei Peretsiti; da Zerach, la famiglia dei Zerachiti. ");
INSERT INTO ita1927_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","I figliuoli di Perets furono: Hetsron da cui discende la famiglia degli Hetsroniti; Hamul da cui discende la famiglia degli Hamuliti. ");
INSERT INTO ita1927_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Tali sono le famiglie di Giuda secondo il loro censimento: settantaseimila cinquecento. ");
INSERT INTO ita1927_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Figliuoli d’Issacar secondo le loro famiglie: da Thola discende la famiglia dei Tholaiti: da Puva, la famiglia dei Puviti; ");
INSERT INTO ita1927_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","da Jashub, la famiglia degli Jashubiti; da Scimron, la famiglia dei Scimroniti. ");
INSERT INTO ita1927_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Tali sono le famiglie d’Issacar secondo il loro censimento: sessanta quattromila trecento. ");
INSERT INTO ita1927_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Figliuoli di Zabulon secondo le loro famiglie: da Sered discende la famiglia dei Sarditi; da Elon, la famiglia degli Eloniti; da Jahleel, la famiglia degli Jahleeliti. ");
INSERT INTO ita1927_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Tali sono le famiglie degli Zabuloniti secondo il loro censimento: sessantamila cinquecento. ");
INSERT INTO ita1927_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Figliuoli di Giuseppe secondo le loro famiglie: Manasse ed Efraim. ");
INSERT INTO ita1927_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Figliuoli di Manasse: da Makir discende la famiglia dei Makiriti. Makir generò Galaad. Da Galaad discende la famiglia dei Galaaditi. ");
INSERT INTO ita1927_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Questi sono i figliuoli di Galaad: Jezer, da cui discende la famiglia degli Jezeriti; Helek, da cui discende la famiglia degli Helekiti; ");
INSERT INTO ita1927_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asriel, da cui discende la famiglia degli Asrieliti; Sichem, da cui discende la famiglia dei Sichemiti; ");
INSERT INTO ita1927_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Scemida, da cui discende la famiglia dei Scemidaiti; Hefer, da cui discende la famiglia degli Heferiti. ");
INSERT INTO ita1927_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Or Tselofehad, figliuolo di Hefer, non ebbe maschi ma soltanto delle figliuole; e i nomi delle figliuole di Tselofehad furono: Mahlah, Noah, Hoglah, Milcah e Thirtsah. ");
INSERT INTO ita1927_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Tali sono le famiglie di Manasse; le persone censite furono cinquantaduemila settecento. ");
INSERT INTO ita1927_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Ecco i figliuoli di Efraim secondo le loro famiglie: da Shuthelah discende la famiglia dei Shuthelahiti; da Beker, la famiglia dei Bakriti; da Tahan, la famiglia dei Tahaniti. ");
INSERT INTO ita1927_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Ed ecco i figliuoli di Shuthelah: da Eran è discesa la famiglia degli Eraniti. ");
INSERT INTO ita1927_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Tali sono le famiglie de’ figliuoli d’Efraim secondo il loro censimento: trentaduemila cinquecento. Questi sono i figliuoli di Giuseppe secondo le loro famiglie. ");
INSERT INTO ita1927_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Figliuoli di Beniamino secondo le loro famiglie: da Bela discende la famiglia dei Belaiti; da Ashbel, la famiglia degli Ashbeliti; da Ahiram, la famiglia degli Ahiramiti; ");
INSERT INTO ita1927_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","da Scefulam, la famiglia degli Shufamiti; ");
INSERT INTO ita1927_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","da Hufam, la famiglia degli Hufamiti. I figliuoli di Bela furono: Ard e Naaman; da Ard discende la famiglia degli Arditi; da Naaman, la famiglia dei Naamiti. ");
INSERT INTO ita1927_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Tali sono i figliuoli di Beniamino secondo le loro famiglie. Le persone censite furono quarantacinquemila seicento. ");
INSERT INTO ita1927_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Ecco i figliuoli di Dan secondo le loro famiglie: da Shuham discende la famiglia degli Shuhamiti. Sono queste le famiglie di Dan secondo le loro famiglie. ");
INSERT INTO ita1927_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Totale per le famiglie degli Shuhamiti secondo il loro censimento: sessanta quattromila quattrocento. ");
INSERT INTO ita1927_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Figliuoli di Ascer secondo le loro famiglie: da Imna discende la famiglia degli Imniti; da Ishvi, la famiglia degli Ishviti; da Beriah, la famiglia de’ Beriiti. ");
INSERT INTO ita1927_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Dai figliuoli di Beriah discendono: da Heber, la famiglia degli Hebriti; da Malkiel, la famiglia de’ Malkieliti. ");
INSERT INTO ita1927_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Il nome della figliuola di Ascer era Serah. ");
INSERT INTO ita1927_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Tali sono le famiglie de’ figliuoli di Ascer secondo il loro censimento: cinquantatremila quattrocento. ");
INSERT INTO ita1927_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Figliuoli di Neftali secondo le loro famiglie: da Jahtseel discende la famiglia degli Jahtseeliti; da Guni, la famiglia dei Guniti; ");
INSERT INTO ita1927_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","da Jetser, la famiglia degli Jetseriti; da Scillem la famiglia degli Scillemiti. ");
INSERT INTO ita1927_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Tali sono le famiglie di Neftali secondo le loro famiglie. Le persone censite furono quarantacinquemila quattrocento. ");
INSERT INTO ita1927_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Tali sono i figliuoli d’Israele di cui si fece il censimento: seicentunmila settecentotrenta. ");
INSERT INTO ita1927_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","L’Eterno parlò a Mosè dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Il paese sarà diviso tra essi, per esser loro proprietà, secondo il numero de’ nomi. ");
INSERT INTO ita1927_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","A quelli che sono in maggior numero darai in possesso una porzione maggiore; a quelli che sono in minor numero darai una porzione minore; si darà a ciascuno la sua porzione secondo il censimento. ");
INSERT INTO ita1927_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Ma la spartizione del paese sarà fatta a sorte; essi riceveranno la rispettiva proprietà secondo i nomi delle loro tribù paterne. ");
INSERT INTO ita1927_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","La spartizione delle proprietà sarà fatta a sorte fra quelli che sono in maggior numero e quelli che sono in numero minore”. ");
INSERT INTO ita1927_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Ecco i Leviti dei quali si fece il censimento secondo le loro famiglie; da Gherson discende la famiglia dei Ghersoniti; da Kehath, la famiglia de’ Kehathiti; da Merari, la famiglia de’ Merariti. ");
INSERT INTO ita1927_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Ecco le famiglie di Levi: la famiglia de’ Libniti, la famiglia degli Hebroniti, la famiglia dei Mahliti, la famiglia de’ Mushiti, la famiglia de’ Korahiti. E Kehath generò Amram. ");
INSERT INTO ita1927_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Il nome della moglie di Amram era Jokebed, figliuola di Levi che nacque a Levi in Egitto; ed essa partorì ad Amram Aaronne, Mosè e Maria loro sorella. ");
INSERT INTO ita1927_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","E ad Aaronne nacquero Nadab e Abihu, Eleazar e Ithamar. ");
INSERT INTO ita1927_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Or Nadab e Abihu morirono quando presentarono all’Eterno fuoco estraneo. ");
INSERT INTO ita1927_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Quelli de’ quali si fece il censimento furono ventitremila: tutti maschi, dell’età da un mese in su. Non furon compresi nel censimento dei figliuoli d’Israele perché non fu loro data alcuna proprietà tra i figliuoli d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Tali son quelli de’ figliuoli d’Israele dei quali Mosè e il sacerdote Eleazar fecero il censimento nelle pianure di Moab presso al Giordano di Gerico. ");
INSERT INTO ita1927_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Fra questi non v’era alcuno di quei figliuoli d’Israele de’ quali Mosè e il sacerdote Aaronne aveano fatto il censimento nel deserto di Sinai. ");
INSERT INTO ita1927_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Poiché l’Eterno avea detto di loro: “Certo morranno nel deserto!” E non ne rimase neppur uno, salvo Caleb, figliuolo di Gefunne, e Giosuè, figliuolo di Nun. ");
INSERT INTO ita1927_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Or le figliuole di Tselofehad, figliuolo di Hefer, figliuolo di Galaad, figliuolo di Makir, figliuolo di Manasse, delle famiglie di Manasse, figliuolo di Giuseppe, che si chiamavano Mahlah, Noah, Hoglah, Milcah e Thirtsah, ");
INSERT INTO ita1927_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","si accostarono e si presentarono davanti a Mosè, davanti al sacerdote Eleazar, davanti ai principi e a tutta la raunanza all’ingresso della tenda di convegno, e dissero: ");
INSERT INTO ita1927_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Il padre nostro morì nel deserto, e non fu nella compagnia di quelli che si adunarono contro l’Eterno, non fu della gente di Kore, ma morì a motivo del suo peccato, e non ebbe figliuoli. ");
INSERT INTO ita1927_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Perché dovrebbe il nome del padre nostro scomparire di mezzo alla sua famiglia s’egli non ebbe figliuoli? Dacci un possesso in mezzo ai fratelli di nostro padre”. ");
INSERT INTO ita1927_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","E Mosè portò la loro causa davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","E l’Eterno disse a Mosè: ");
INSERT INTO ita1927_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Le figliuole di Tselofehad dicono bene. Sì, tu darai loro in eredità un possesso tra i fratelli del padre loro, e farai passare ad esse l’eredità del padre loro. ");
INSERT INTO ita1927_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Parlerai pure ai figliuoli d’Israele, e dirai: Quand’uno sarà morto senza lasciar figliuolo maschio, farete passare l’eredità sua alla sua figliuola. ");
INSERT INTO ita1927_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","E, se non ha figliuola, darete la sua eredità ai suoi fratelli. ");
INSERT INTO ita1927_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","E, se non ha fratelli, darete la sua eredità ai fratelli di suo padre. ");
INSERT INTO ita1927_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","E, se non ci sono fratelli del padre, darete la sua eredità al parente più stretto nella sua famiglia; quello la possederà. Questo sarà per i figliuoli d’Israele una norma di diritto, come l’Eterno ha ordinato a Mosè”. ");
INSERT INTO ita1927_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Poi l’Eterno disse a Mosè: “Sali su questo monte di Abarim e contempla il paese che io do ai figliuoli d’Israele. ");
INSERT INTO ita1927_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","E quando l’avrai veduto, anche tu sarai raccolto presso il tuo popolo, come fu raccolto Aaronne tuo fratello, ");
INSERT INTO ita1927_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","perché vi ribellaste all’ordine che vi detti nel deserto di Tsin quando la raunanza si mise a contendere, e voi non mi santificaste agli occhi loro, a proposito di quelle acque”. Sono le acque della contesa di Kades, nel deserto di Tsin. ");
INSERT INTO ita1927_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","E Mosè parlò all’Eterno, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“L’Eterno, l’Iddio degli spiriti d’ogni carne, costituisca su questa raunanza un uomo ");
INSERT INTO ita1927_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","che esca davanti a loro ed entri davanti a loro, e li faccia uscire e li faccia entrare, affinché la raunanza dell’Eterno non sia come un gregge senza pastore”. ");
INSERT INTO ita1927_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","E l’Eterno disse a Mosè: “Prenditi Giosuè, figliuolo di Nun, uomo in cui è lo spirito; poserai la tua mano su lui, ");
INSERT INTO ita1927_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","lo farai comparire davanti al sacerdote Eleazar e davanti a tutta la raunanza, gli darai i tuoi ordini in loro presenza, ");
INSERT INTO ita1927_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","e lo farai partecipe della tua autorità, affinché tutta la raunanza de’ figliuoli d’Israele gli obbedisca. ");
INSERT INTO ita1927_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Egli si presenterà davanti al sacerdote Eleazar, che consulterà per lui il giudizio dell’Urim davanti all’Eterno; egli e tutti i figliuoli d’Israele con lui e tutta la raunanza usciranno all’ordine di Eleazar ed entreranno all’ordine suo”. ");
INSERT INTO ita1927_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","E Mosè fece come l’Eterno gli aveva ordinato; prese Giosuè e lo fece comparire davanti al sacerdote Eleazar e davanti a tutta la raunanza; ");
INSERT INTO ita1927_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","posò su lui le sue mani e gli diede i suoi ordini, come l’Eterno aveva comandato per mezzo di Mosè. ");
INSERT INTO ita1927_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","E l’Eterno parlò a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Da’ quest’ordine ai figliuoli d’Israele, e di’ loro: Avrete cura d’offrirmi al tempo stabilito la mia offerta, il cibo de’ miei sacrifizi fatti mediante il fuoco, e che mi sono di soave odore. ");
INSERT INTO ita1927_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","E dirai loro: Questo è il sacrifizio mediante il fuoco, che offrirete all’Eterno: degli agnelli dell’anno, senza difetti, due al giorno, come olocausto perpetuo. ");
INSERT INTO ita1927_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Uno degli agnelli offrirai la mattina, e l’altro agnello offrirai sull’imbrunire: ");
INSERT INTO ita1927_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","e, come oblazione, un decimo d’efa di fior di farina, intrisa con un quarto di hin d’olio vergine. ");
INSERT INTO ita1927_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Tale è l’olocausto perpetuo, offerto sul monte Sinai: sacrifizio fatto mediante il fuoco, di soave odore all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","La libazione sarà di un quarto di hin per ciascun agnello; la libazione di vino puro all’Eterno la farai nel luogo santo. ");
INSERT INTO ita1927_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","E l’altro agnello l’offrirai sull’imbrunire, con un’oblazione e una libazione simili a quelle della mattina: è un sacrifizio fatto mediante il fuoco, di soave odore all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Nel giorno di sabato offrirete due agnelli dell’anno, senza difetti; e, come oblazione, due decimi di fior di farina intrisa con olio, con la sua libazione. ");
INSERT INTO ita1927_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","E’ l’olocausto del sabato, per ogni sabato, oltre l’olocausto perpetuo e la sua libazione. ");
INSERT INTO ita1927_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Al principio de’ vostri mesi offrirete come olocausto all’Eterno due giovenchi, un montone, sette agnelli dell’anno, senza difetti, ");
INSERT INTO ita1927_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","e tre decimi di fior di farina intrisa con olio, come oblazione per ciascun giovenco; due decimi di fior di farina intrisa con olio, come oblazione per il montone, ");
INSERT INTO ita1927_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","e un decimo di fior di farina intrisa con olio, come oblazione per ogni agnello. E’ un olocausto di soave odore, un sacrifizio fatto mediante il fuoco all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Le libazioni saranno di un mezzo hin di vino per giovenco, d’un terzo di hin per il montone e di un quarto di hin per agnello. Tale è l’olocausto del mese, per tutti i mesi dell’anno. ");
INSERT INTO ita1927_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","E s’offrirà all’Eterno un capro come sacrifizio per il peccato, oltre l’olocausto perpetuo e la sua libazione. ");
INSERT INTO ita1927_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Il primo mese, il quattordicesimo giorno del mese sarà la Pasqua in onore dell’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","E il quindicesimo giorno di quel mese sarà giorno di festa. Per sette giorni si mangerà pane senza lievito. ");
INSERT INTO ita1927_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Il primo giorno vi sarà una santa convocazione; non farete alcuna opera servile, ");
INSERT INTO ita1927_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","ma offrirete, come sacrifizio mediante il fuoco, un olocausto all’Eterno: due giovenchi, un montone e sette agnelli dell’anno che siano senza difetti; ");
INSERT INTO ita1927_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","e, come oblazione, del fior di farina intrisa con olio; e ne offrirete tre decimi per giovenco e due per il montone; ");
INSERT INTO ita1927_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ne offrirai un decimo per ciascuno de’ sette agnelli, ");
INSERT INTO ita1927_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","e offrirai un capro come sacrifizio per il peccato, per fare l’espiazione per voi. ");
INSERT INTO ita1927_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Offrirete questi sacrifizi oltre l’olocausto della mattina, che è un olocausto perpetuo. ");
INSERT INTO ita1927_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","L’offrirete ogni giorno, per sette giorni; è un cibo di sacrifizio fatto mediante il fuoco, di soave odore all’Eterno. Lo si offrirà oltre l’olocausto perpetuo con la sua libazione. ");
INSERT INTO ita1927_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","E il settimo giorno avrete una santa convocazione; non farete alcuna opera servile. ");
INSERT INTO ita1927_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Il giorno delle primizie, quando presenterete all’Eterno una oblazione nuova, alla vostra festa delle settimane, avrete una santa convocazione; non farete alcuna opera servile. ");
INSERT INTO ita1927_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","E offrirete, come olocausto di soave odore all’Eterno, due giovenchi, un montone e sette agnelli dell’anno; ");
INSERT INTO ita1927_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","e, come oblazione, del fior di farina intrisa con olio; tre decimi per ciascun giovenco, due decimi per il montone, ");
INSERT INTO ita1927_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","e un decimo per ciascuno dei sette agnelli; ");
INSERT INTO ita1927_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","e offrirete un capro per fare l’espiazione per voi. ");
INSERT INTO ita1927_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Offrirete questi sacrifizi, oltre l’olocausto perpetuo e la sua oblazione. Sceglierete degli animali senza difetti e v’aggiungerete le relative libazioni. ");
INSERT INTO ita1927_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Il settimo mese, il primo giorno del mese avrete una santa convocazione; non farete alcuna opera servile; sarà per voi il giorno dei suon delle trombe. ");
INSERT INTO ita1927_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Offrirete come olocausto di soave odore all’Eterno un giovenco, un montone, sette agnelli dell’anno senza difetti, ");
INSERT INTO ita1927_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","e, come oblazione, del fior di farina intrisa con olio: tre decimi per il giovenco, due decimi per il montone, ");
INSERT INTO ita1927_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","un decimo per ciascuno dei sette agnelli; ");
INSERT INTO ita1927_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","e un capro, come sacrifizio per il peccato, per fare l’espiazione per voi, ");
INSERT INTO ita1927_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","oltre l’olocausto del mese con la sua oblazione, e l’olocausto perpetuo con la sua oblazione, e le loro libazioni, secondo le regole stabilite. Sarà un sacrifizio, fatto mediante il fuoco, di soave odore all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Il decimo giorno di questo settimo mese avrete una santa convocazione e umilierete le anime vostre; non farete lavoro di sorta, ");
INSERT INTO ita1927_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","e offrirete, come olocausto di soave odore all’Eterno, un giovenco, un montone, sette agnelli dell’anno che siano senza difetti, ");
INSERT INTO ita1927_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","e, come oblazione, del fior di farina intrisa con olio: tre decimi per il giovenco, due decimi per il montone, ");
INSERT INTO ita1927_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","un decimo per ciascuno dei sette agnelli; ");
INSERT INTO ita1927_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","e un capro come sacrifizio per il peccato, oltre il sacrifizio d’espiazione, l’olocausto perpetuo con la sua oblazione e le loro libazioni. ");
INSERT INTO ita1927_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Il quindicesimo giorno del settimo mese avrete una santa convocazione; non farete alcuna opera servile, e celebrerete una festa in onor dell’Eterno per sette giorni. ");
INSERT INTO ita1927_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","E offrirete come olocausto, come sacrifizio fatto mediante il fuoco, di soave odore all’Eterno, tredici giovenchi, due montoni, quattordici agnelli dell’anno, che siano senza difetti, ");
INSERT INTO ita1927_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","e, come oblazione, del fior di farina intrisa con olio: tre decimi per ciascuno dei tredici giovenchi, due decimi per ciascuno dei due montoni, ");
INSERT INTO ita1927_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","un decimo per ciascuno dei quattordici agnelli, ");
INSERT INTO ita1927_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","e un capro come sacrifizio per il peccato, oltre l’olocausto perpetuo, con la sua oblazione e la sua libazione. ");
INSERT INTO ita1927_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Il secondo giorno offrirete dodici giovenchi, due montoni, quattordici agnelli dell’anno, senza difetti, ");
INSERT INTO ita1927_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","con le loro oblazioni e le libazioni per i giovenchi, i montoni e gli agnelli secondo il loro numero, seguendo le regole stabilite; ");
INSERT INTO ita1927_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","e un capro come sacrifizio per il peccato, oltre l’olocausto perpetuo, la sua oblazione e le loro libazioni. ");
INSERT INTO ita1927_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Il terzo giorno offrirete undici giovenchi, due montoni, quattordici agnelli dell’anno, senza difetti, ");
INSERT INTO ita1927_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","con le loro oblazioni e le loro libazioni per i giovenchi, i montoni e gli agnelli, secondo il loro numero, seguendo le regole stabilite; ");
INSERT INTO ita1927_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","e un capro come sacrifizio per il peccato, oltre l’olocausto perpetuo, la sua oblazione e la sua libazione. ");
INSERT INTO ita1927_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Il quarto giorno offrirete dieci giovenchi, due montoni e quattordici agnelli dell’anno, senza difetti, ");
INSERT INTO ita1927_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","con le loro offerte e le loro libazioni per i giovenchi, i montoni e gli agnelli, secondo il loro numero e seguendo le regole stabilite; ");
INSERT INTO ita1927_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","e un capro, come sacrifizio per il peccato, oltre l’olocausto perpetuo, la sua oblazione e la sua libazione. ");
INSERT INTO ita1927_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Il quinto giorno offrirete nove giovenchi, due montoni, quattordici agnelli dell’anno, senza difetti, ");
INSERT INTO ita1927_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","con le loro oblazioni e le loro libazioni per i giovenchi, i montoni e gli agnelli, secondo il loro numero e seguendo le regole stabilite; ");
INSERT INTO ita1927_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","e un capro, come sacrificio per il peccato, oltre l’olocausto perpetuo, la sua oblazione e la sua libazione. ");
INSERT INTO ita1927_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Il sesto giorno offrirete otto giovenchi, due montoni, quattordici agnelli dell’anno, senza difetti, ");
INSERT INTO ita1927_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","con le loro oblazioni e le loro libazioni per i giovenchi, i montoni e gli agnelli, secondo il loro numero e seguendo le regole stabilite; ");
INSERT INTO ita1927_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","e un capro, come sacrifizio per il peccato, oltre l’olocausto perpetuo, la sua oblazione e la sua libazione. ");
INSERT INTO ita1927_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Il settimo giorno offrirete sette giovenchi, due montoni, quattordici agnelli dell’anno, senza difetti, ");
INSERT INTO ita1927_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","con le loro oblazioni e le loro libazioni per i giovenchi, i montoni e gli agnelli, secondo il loro numero e seguendo le regole stabilite; ");
INSERT INTO ita1927_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","e un capro, come sacrifizio per il peccato, oltre l’olocausto perpetuo, la sua oblazione e la sua libazione. ");
INSERT INTO ita1927_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","L’ottavo giorno avrete una solenne raunanza; non farete alcuna opera servile, ");
INSERT INTO ita1927_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","e offrirete come olocausto, come sacrifizio fatto mediante il fuoco, di soave odore all’Eterno, un giovenco, un montone, sette agnelli dell’anno, senza difetti, ");
INSERT INTO ita1927_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","con le loro oblazioni e le loro libazioni per il giovenco, il montone e gli agnelli, secondo il loro numero, seguendo le regole stabilite; ");
INSERT INTO ita1927_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","e un capro, come sacrifizio per il peccato, oltre l’olocausto perpetuo, la sua oblazione e la sua libazione. ");
INSERT INTO ita1927_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Tali sono i sacrifizi che offrirete all’Eterno nelle vostre solennità, oltre i vostri voti e le vostre offerte volontarie, sia che si tratti de’ vostri olocausti o delle vostre oblazioni o delle vostre libazioni o de’ vostri sacrifizi di azioni di grazie”. ");
INSERT INTO ita1927_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","E Mosè riferì ai figliuoli d’Israele tutto quello che l’Eterno gli aveva ordinato. ");
INSERT INTO ita1927_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Mosè parlò ai capi delle tribù de’ figliuoli d’Israele, dicendo: “Questo è quel che l’Eterno ha ordinato: ");
INSERT INTO ita1927_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Quand’uno avrà fatto un voto all’Eterno od avrà con giuramento contratta una solenne obbligazione, non violerà la sua parola, ma metterà in esecuzione tutto quello che gli è uscito di bocca. ");
INSERT INTO ita1927_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Così pure quando una donna avrà fatto un voto all’Eterno e si sarà legata con un impegno essendo in casa dei padre, durante la sua giovinezza, ");
INSERT INTO ita1927_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","se il padre, avendo conoscenza del voto di lei e dell’impegno per il quale ella si è legata, non dice nulla a questo proposito, tutti i voti di lei saranno validi, e saranno validi tutti gli impegni per i quali ella si sarà legata. ");
INSERT INTO ita1927_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Ma se il padre, il giorno che ne viene a conoscenza, le fa opposizione, tutti i voti di lei e tutti gl’impegni per i quali si sarà legata, non saranno validi; e l’Eterno le perdonerà, perché il padre le ha fatto opposizione. ");
INSERT INTO ita1927_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","E se viene a maritarsi essendo legata da voti o da una promessa fatta alla leggera con le labbra, per la quale si sia impegnata, ");
INSERT INTO ita1927_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","se il marito ne ha conoscenza e il giorno che ne viene a conoscenza non dice nulla a questo proposito, i voti di lei saranno validi, e saranno validi gl’impegni per i quali ella si è legata. ");
INSERT INTO ita1927_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Ma se il marito, il giorno che ne viene a conoscenza, le fa opposizione, egli annullerà il voto ch’ella ha fatto e la promessa che ha proferito alla leggera per la quale s’è impegnata; e l’Eterno le perdonerà. ");
INSERT INTO ita1927_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Ma il voto di una vedova o di una donna ripudiata, qualunque sia l’impegno per il quale si sarà legata, rimarrà valido. ");
INSERT INTO ita1927_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Quando una donna, nella casa di suo marito, farà dei voti o si legherà con un giuramento, ");
INSERT INTO ita1927_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","e il marito ne avrà conoscenza, se il marito non dice nulla a questo proposito e non le fa opposizione, tutti i voti di lei saranno validi, e saran validi tutti gl’impegni per i quali ella si sarà legata. ");
INSERT INTO ita1927_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Ma se il marito, il giorno che ne viene a conoscenza li annulla, tutto ciò che le sarà uscito dalle labbra, siano voti o impegni per cui s’è legata, non sarà valido; il marito lo ha annullato; e l’Eterno le perdonerà. ");
INSERT INTO ita1927_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Il marito può ratificare e il marito può annullare qualunque voto e qualunque giuramento, per il quale ella si sia impegnata a mortificare la sua persona. ");
INSERT INTO ita1927_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Ma se il marito, giorno dopo giorno, non dice nulla in proposito, egli ratifica così tutti i voti di lei e tutti gl’impegni per i quali ella si è legata; li ratifica, perché non ha detto nulla a questo proposito il giorno che ne ha avuto conoscenza. ");
INSERT INTO ita1927_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Ma se li annulla qualche tempo dopo averne avuto conoscenza, sarà responsabile del peccato della moglie”. ");
INSERT INTO ita1927_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Tali sono le leggi che l’Eterno prescrisse a Mosè, riguardo al marito e alla moglie, al padre e alla figliuola, quando questa è ancora fanciulla, in casa di suo padre. ");
INSERT INTO ita1927_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Poi l’Eterno parlò a Mosè, dicendo: “Vendica i figliuoli d’Israele dei Madianiti; ");
INSERT INTO ita1927_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","poi sarai raccolto col tuo popolo”. ");
INSERT INTO ita1927_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","E Mosè parlò al popolo, dicendo: “Mobilitate tra voi uomini per la guerra, e marcino contro Madian per eseguire la vendetta dell’Eterno su Madian. ");
INSERT INTO ita1927_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Manderete alla guerra mille uomini per tribù, di tutte le tribù d’Israele”. ");
INSERT INTO ita1927_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Così furon forniti, fra le migliaia d’Israele, mille uomini per tribù: cioè dodicimila uomini, armati per la guerra. ");
INSERT INTO ita1927_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","E Mosè mandò alla guerra que’ mille uomini per tribù, e con loro Fineas figliuolo del sacerdote Eleazar, il quale portava gli strumenti sacri ed aveva in mano le trombe d’allarme. ");
INSERT INTO ita1927_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Essi marciarono dunque contro Madian, come l’Eterno aveva ordinato a Mosè, e uccisero tutti i maschi. ");
INSERT INTO ita1927_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Uccisero pure, con tutti gli altri, i re di Madian Evi, Rekem, Tsur, Hur e Reba: cinque re di Madian; uccisero pure con la spada Balaam, figliuolo di Beor. ");
INSERT INTO ita1927_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","E i figliuoli d’Israele presero prigioniere le donne di Madian e i loro fanciulli, e predarono tutto il loro bestiame, tutti i loro greggi e ogni loro bene; ");
INSERT INTO ita1927_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","e appiccarono il fuoco a tutte le città che quelli abitavano, e a tutti i loro accampamenti, ");
INSERT INTO ita1927_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","e presero tutte le spoglie e tutta la preda: gente e bestiame; ");
INSERT INTO ita1927_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","e menarono i prigionieri, la preda e le spoglie a Mosè, al sacerdote Eleazar e alla raunanza dei figliuoli d’Israele, accampati nelle pianure di Moab, presso il Giordano, di faccia a Gerico. ");
INSERT INTO ita1927_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Mosè, il sacerdote Eleazar e tutti i principi della raunanza uscirono loro incontro fuori dei campo. ");
INSERT INTO ita1927_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","E Mosè si adirò contro i comandanti dell’esercito, capi di migliaia e capi di centinaia, che tornavano da quella spedizione di guerra. ");
INSERT INTO ita1927_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Mosè disse loro: “Avete lasciato la vita a tutte le donne? ");
INSERT INTO ita1927_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Ecco, sono esse che, a suggestione di Balaam, trascinarono i figliuoli d’Israele alla infedeltà verso l’Eterno, nel fatto di Peor, onde la piaga scoppiò nella raunanza dell’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Or dunque uccidete ogni maschio tra i fanciulli, e uccidete ogni donna che ha avuto relazioni carnali con un uomo; ");
INSERT INTO ita1927_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","ma tutte le fanciulle che non hanno avuto relazioni carnali con uomini, serbatele in vita per voi. ");
INSERT INTO ita1927_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","E voi accampatevi per sette giorni fuori del campo; chiunque ha ucciso qualcuno e chiunque ha toccato una persona uccisa, si purifichi il terzo e il settimo giorno: e questo, tanto per voi quanto per i vostri prigionieri. ");
INSERT INTO ita1927_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Purificherete anche ogni veste, ogni oggetto di pelle, ogni lavoro di pel di capra e ogni utensile di legno”. ");
INSERT INTO ita1927_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","E il sacerdote Eleazar disse ai soldati ch’erano andati alla guerra: “Questo è l’ordine della legge che l’Eterno ha prescritta a Mosè: ");
INSERT INTO ita1927_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","L’oro, l’argento, il rame, il ferro, lo stagno e il piombo, ");
INSERT INTO ita1927_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","tutto ciò, insomma, che può reggere al fuoco, lo farete passare per il fuoco e sarà reso puro; nondimeno, sarà purificato anche con l’acqua di purificazione; e tutto ciò che non può reggere al fuoco, lo farete passare per l’acqua. ");
INSERT INTO ita1927_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","E vi laverete lei vesti il settimo giorno, e sarete puri; poi potrete entrare nel campo”. ");
INSERT INTO ita1927_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","L’Eterno parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Tu, col sacerdote Eleazar e con i capi delle case della raunanza, fa’ il conto di tutta la preda ch’è stata fatta: della gente e del bestiame; ");
INSERT INTO ita1927_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","e dividi la preda fra i combattenti che sono andati alla guerra e tutta la raunanza. ");
INSERT INTO ita1927_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Dalla parte spettante ai soldati che sono andati alla guerra preleverai un tributo per l’Eterno: cioè uno su cinquecento, tanto delle persone quanto de’ buoi, degli asini e delle pecore. ");
INSERT INTO ita1927_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Lo prenderete sulla loro metà e lo darai al sacerdote Eleazar come un’offerta all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","E dalla metà che spetta ai figliuoli d’Israele prenderai uno su cinquanta, tanto delle persone quanto dei buoi, degli asini, delle pecore, di tutto il bestiame; e lo darai ai Leviti, che hanno l’incarico del tabernacolo dell’Eterno”. ");
INSERT INTO ita1927_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","E Mosè e il sacerdote Eleazar fecero come l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Or la preda, cioè quel che rimaneva del bottino fatto da quelli ch’erano stati alla guerra, consisteva in seicentosettanta cinquemila pecore, ");
INSERT INTO ita1927_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","settantaduemila buoi, ");
INSERT INTO ita1927_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","sessantamila asini, e trentaduemila persone, ossia donne, ");
INSERT INTO ita1927_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","che non avevano avuto relazioni carnali con uomini. ");
INSERT INTO ita1927_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","La metà, cioè la parte di quelli ch’erano andati alla guerra, fu di trecentotrenta settemila cinquecento pecore, ");
INSERT INTO ita1927_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","delle quali seicentosettanta cinque per il tributo all’Eterno; ");
INSERT INTO ita1927_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","trentaseimila bovi, dei quali settantadue per il tributo all’Eterno; ");
INSERT INTO ita1927_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","trentamila cinquecento asini, dei quali sessantuno per il tributo all’Eterno; ");
INSERT INTO ita1927_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","e sedicimila persone, delle quali trentadue per il tributo all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","E Mosè dette a sacerdote Eleazar il tributo prelevato per l’offerta all’Eterno, come l’Eterno gli aveva ordinato. ");
INSERT INTO ita1927_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","La metà che spettava ai figliuoli d’Israele, dopo che Mosè ebbe fatta la spartizione con gli uomini andati alla guerra, la metà spettante alla raunanza, ");
INSERT INTO ita1927_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","fu di trecentotrenta settemila cinquecento pecore, ");
INSERT INTO ita1927_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","trentaseimila buoi, ");
INSERT INTO ita1927_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","trentamila cinquecento asini e sedicimila persone. ");
INSERT INTO ita1927_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","Da questa metà, ");
INSERT INTO ita1927_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","che spettava ai figliuoli d’Israele, Mosè prese uno su cinquanta, tanto degli uomini quanto degli animali, e li dette ai Leviti che hanno l’incarico del tabernacolo dell’Eterno, come l’Eterno aveva ordinato a Mosè. ");
INSERT INTO ita1927_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","I comandanti delle migliaia dell’esercito, capi di migliaia e capi di centinaia, s’avvicinarono a Mosè e gli dissero: ");
INSERT INTO ita1927_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","“I tuoi servi hanno fatto il conto dei soldati che erano sotto i nostri ordini, e non ne manca neppur uno. ");
INSERT INTO ita1927_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","E noi portiamo, come offerta all’Eterno, ciascuno quel che ha trovato di oggetti d’oro: catenelle, braccialetti, anelli, pendenti, collane, per fare l’espiazione per le nostre persone davanti all’Eterno”. ");
INSERT INTO ita1927_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","E Mosè e il sacerdote Eleazar presero dalle loro mani tutto quell’oro in gioielli lavorati. ");
INSERT INTO ita1927_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Tutto l’oro dell’offerta ch’essi presentarono all’Eterno da parte de’ capi di migliaia e de’ capi di centinaia pesava sedicimila settecentocinquanta sicli. ");
INSERT INTO ita1927_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Or gli uomini dell’esercito si tennero il bottino che ognuno avea fatto per conto suo. ");
INSERT INTO ita1927_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","E Mosè e il sacerdote Eleazar presero l’oro dei capi di migliaia e di centinaia e lo portarono nella tenda di convegno come ricordanza per i figliuoli d’Israele davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Or i figliuoli di Ruben e i figliuoli di Gad aveano del bestiame in grandissimo numero; e quando videro che il paese di Iazer e il paese di Galaad erano luoghi da bestiame, ");
INSERT INTO ita1927_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","i figliuoli di Gad e i figliuoli di Ruben vennero a parlare a Mosè, al sacerdote Eleazar e ai principi della raunanza, e dissero: ");
INSERT INTO ita1927_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Ataroth, Dibon, Iazer, Nimrah, Heshbon, Elealeh, Sebam, Nebo e Beon, ");
INSERT INTO ita1927_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","terre che l’Eterno ha colpite dinanzi alla raunanza d’Israele, sono terre da bestiame, e i tuoi servi hanno del bestiame”. ");
INSERT INTO ita1927_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","E dissero ancora: “Se abbiam trovato grazia agli occhi tuoi, sia concesso ai tuoi servi il possesso di questo paese, e non ci far passare il Giordano”. ");
INSERT INTO ita1927_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Ma Mosè rispose ai figliuoli di Gad e ai figliuoli di Ruben: “Andrebbero eglino i vostri fratelli alla guerra e voi ve ne stareste qui? ");
INSERT INTO ita1927_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","E perché volete scoraggiare i figliuoli d’Israele dal passare nei paese che l’Eterno ha loro dato? ");
INSERT INTO ita1927_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Così fecero i vostri padri, quando li mandai da Kades-Barnea per esplorare il paese. ");
INSERT INTO ita1927_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Salirono fino alla valle d’Eshcol; e dopo aver esplorato il paese, scoraggiarono i figliuoli d’Israele dall’entrare nel paese che l’Eterno avea loro dato. ");
INSERT INTO ita1927_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","E l’ira dell’Eterno s’accese in quel giorno, ed egli giurò dicendo: ");
INSERT INTO ita1927_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","Gli uomini che son saliti dall’Egitto, dall’età di vent’anni in su non vedranno mai il paese che promisi con giuramento ad Abrahamo, a Isacco ed a Giacobbe, perché non m’hanno seguitato fedelmente, ");
INSERT INTO ita1927_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","salvo Caleb, figliuolo di Gefunne, il Kenizeo, e Giosuè, figliuolo di Nun, che hanno seguitato l’Eterno fedelmente. ");
INSERT INTO ita1927_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","E l’ira dell’Eterno si accese contro Israele; ed ei lo fece andar vagando per il deserto durante quarant’anni, finché tutta la generazione che avea fatto quel male agli occhi dell’Eterno, fosse consumata. ");
INSERT INTO ita1927_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Ed ecco che voi sorgete al posto de’ vostri padri, razza d’uomini peccatori, per rendere l’ira dell’Eterno anche più ardente contro Israele. ");
INSERT INTO ita1927_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Perché, se voi vi sviate da lui, egli continuerà a lasciare Israele nel deserto, e voi farete perire tutto questo popolo”. ");
INSERT INTO ita1927_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Ma quelli s’accostarono a Mosè e gli dissero: “Noi edificheremo qui dei recinti per il nostro bestiame, e delle città per i nostri figliuoli; ");
INSERT INTO ita1927_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","ma, quanto a noi, ci terremo pronti, in armi, per marciare alla testa de’ figliuoli d’Israele, finché li abbiam condotti ai luogo destinato loro; intanto, i nostri figliuoli dimoreranno nelle città forti a cagione degli abitanti del paese. ");
INSERT INTO ita1927_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Non torneremo alle nostre case finché ciascuno de’ figliuoli d’Israele non abbia preso possesso della sua eredità; ");
INSERT INTO ita1927_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","e non possederemo nulla con loro al di là del Giordano e più oltre, giacché la nostra eredità ci è toccata da questa parte dei Giordano, a oriente”. ");
INSERT INTO ita1927_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","E Mosè disse loro: “Se fate questo, se vi armate per andare a combattere davanti all’Eterno, ");
INSERT INTO ita1927_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","se tutti quelli di voi che s’armeranno passeranno il Giordano davanti all’Eterno finch’egli abbia cacciato i suoi nemici dal suo cospetto, ");
INSERT INTO ita1927_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","e se non tornate che quando il paese vi sarà sottomesso davanti all’Eterno, voi non sarete colpevoli di fronte all’Eterno e di fronte a Israele, e questo paese sarà vostra proprietà davanti all’Eterno. ");
INSERT INTO ita1927_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Ma, se non fate così, voi avrete peccato contro l’Eterno; e sappiate che il vostro peccato vi ritroverà. ");
INSERT INTO ita1927_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Edificatevi delle città per i vostri figliuoli e dei recinti per i vostri greggi, e fate quello che la vostra bocca ha proferito”. ");
INSERT INTO ita1927_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","E i figliuoli di Gad e i figliuoli di Ruben parlarono a Mosè, dicendo: “I tuoi servi faranno quello che il mio signore comanda. ");
INSERT INTO ita1927_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","I nostri fanciulli, le nostre mogli, i nostri greggi e tutto il nostro bestiame rimarranno qui nelle città di Galaad; ");
INSERT INTO ita1927_v