﻿USE sofia;
DROP TABLE IF EXISTS sofia.ita1885_vpl;
CREATE TABLE ita1885_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ita1885_vpl WRITE;
INSERT INTO ita1885_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","NEL principio Iddio creò il cielo e la terra. ");
INSERT INTO ita1885_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","E la terra era una cosa deserta e vacua; e tenebre erano sopra la faccia dell'abisso. E lo Spirito di Dio si moveva sopra la faccia delle acque. ");
INSERT INTO ita1885_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","E Iddio disse: Sia la luce. E la luce fu. ");
INSERT INTO ita1885_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","E Iddio vide che la luce era buona. E Iddio separò la luce dalle tenebre. ");
INSERT INTO ita1885_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","E Iddio nominò la luce Giorno, e le tenebre Notte. Così fu sera, e poi fu mattina, che fu il primo giorno. ");
INSERT INTO ita1885_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Poi Iddio disse: Siavi una distesa tra le acque, la quale separi le acque dalle acque. ");
INSERT INTO ita1885_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","E Iddio fece quella distesa: e separò le acque che son disotto alla distesa, da quelle che son disopra d'essa. E così fu. ");
INSERT INTO ita1885_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","E Iddio nominò la distesa Cielo. Così fu sera, e poi fu mattina, che fu il secondo giorno. ");
INSERT INTO ita1885_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Poi Iddio disse: Sieno tutte le acque, che son sotto al cielo, raccolte in un luogo, ed apparisca l'asciutto. E così fu. ");
INSERT INTO ita1885_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","E Iddio nominò l'asciutto Terra, e la raccolta delle acque Mari. E Iddio vide che ciò era buono. ");
INSERT INTO ita1885_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Poi Iddio disse: Produca la terra erba minuta, erbe che facciano seme, ed alberi fruttiferi che portino frutto, secondo le loro specie; il cui seme sia in esso, sopra la terra. E così fu. ");
INSERT INTO ita1885_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","La terra adunque produsse erba minuta, erbe che fanno seme, secondo le loro specie, ed alberi che portano frutto, il cui seme è in esso, secondo le loro specie. E Iddio vide che ciò era buono. ");
INSERT INTO ita1885_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Così fu sera, e poi fu mattina, che fu il terzo giorno. ");
INSERT INTO ita1885_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Poi Iddio disse: Sienvi de' luminari nella distesa del cielo, per far distinzione tra il giorno e la notte: e quelli sieno per segni, e per distinguer le stagioni e i giorni e gli anni. ");
INSERT INTO ita1885_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","E sieno per luminari nella distesa del cielo, per recar la luce in su la terra. E così fu. ");
INSERT INTO ita1885_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Iddio adunque fece i due gran luminari (il maggiore per avere il reggimento del giorno, e il minore per avere il reggimento della notte), e le stelle. ");
INSERT INTO ita1885_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","E Iddio li mise nella distesa del cielo, per recar la luce sopra la terra, ");
INSERT INTO ita1885_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","e per avere il reggimento del giorno e della notte, e per separar la luce dalle tenebre. E Iddio vide che ciò era buono. ");
INSERT INTO ita1885_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Così fu sera, e poi fu mattina, che fu il quarto giorno. ");
INSERT INTO ita1885_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Poi Iddio disse: Producano le acque copiosamente rettili, che sieno animali viventi; e volino gli uccelli sopra la terra, e per la distesa del cielo. ");
INSERT INTO ita1885_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Iddio adunque creò le grandi balene, ed ogni animal vivente che va serpendo; i quali animali le acque produssero copiosamente, secondo le loro specie; ed ogni sorta di uccelli che hanno ale, secondo le loro specie. E Iddio vide che ciò era buono. ");
INSERT INTO ita1885_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","E Iddio li benedisse, dicendo: Figliate, moltiplicate, ed empiete le acque ne' mari; moltiplichino parimente gli uccelli sulla terra. ");
INSERT INTO ita1885_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Così fu sera, e poi fu mattina, che fu il quinto giorno. ");
INSERT INTO ita1885_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Poi Iddio disse: Produca la terra animali viventi, secondo le loro specie; bestie domestiche, rettili e fiere della terra, secondo le loro specie. E così fu. ");
INSERT INTO ita1885_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Iddio adunque fece le fiere della terra, secondo le loro specie; e gli animali domestici, secondo le loro specie; ed ogni sorta di rettili della terra, secondo le loro specie. E Iddio vide che ciò era buono. ");
INSERT INTO ita1885_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Poi Iddio disse: Facciamo l'uomo alla nostra immagine, secondo la nostra somiglianza; ed abbia la signoria sopra i pesci del mare, e sopra gli uccelli del cielo, e sopra le bestie, e sopra tutta la terra, e sopra ogni rettile che serpe sopra la terra. ");
INSERT INTO ita1885_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Iddio adunque creò l'uomo alla sua immagine; egli lo creò all'immagine di Dio; egli li creò maschio e femmina. ");
INSERT INTO ita1885_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","E Iddio li benedisse, e disse loro: Fruttate e moltiplicate, ed empiete la terra, e rendetevela soggetta, e signoreggiate sopra i pesci del mare, e sopra gli uccelli del cielo, e sopra ogni bestia che cammina sopra la terra. ");
INSERT INTO ita1885_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Oltre a ciò, Iddio disse: Ecco, io vi do tutte l'erbe che producono seme, che son sopra tutta la terra; e tutti gli alberi fruttiferi che fanno seme. Queste cose vi saranno per cibo. ");
INSERT INTO ita1885_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ma a tutte le bestie della terra, ed a tutti gli uccelli del cielo, ed a tutti gli animali che serpono sopra la terra, ne' quali è anima vivente, io do ogni erba verde per mangiarla. E così fu. ");
INSERT INTO ita1885_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","E Iddio vide tutto quello ch'egli avea fatto; ed ecco, era molto buono. Così fu sera, e poi fu mattina, che fu il sesto giorno. ");
INSERT INTO ita1885_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Così furono compiuti i cieli e la terra, e tutto l'esercito di quelli. ");
INSERT INTO ita1885_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ora, avendo Iddio compiuta nel settimo giorno l'opera sua, la quale egli avea fatta, si riposò nel settimo giorno da ogni sua opera, che egli avea fatta. ");
INSERT INTO ita1885_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","E Iddio benedisse il settimo giorno, e lo santificò; perciocchè in esso egli s'era riposato da ogni sua opera ch'egli avea creata, per farla. ");
INSERT INTO ita1885_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","TALI furono le origini del cielo e della terra, quando quelle cose furono create, nel giorno che il Signore Iddio fece la terra e il cielo; ");
INSERT INTO ita1885_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","e ogni albero ed arboscello della campagna, avanti che ne fosse alcuno in su la terra; ed ogni erba della campagna, avanti che ne fosse germogliata alcuna; perciocchè il Signore Iddio non avea ancora fatto piovere in su la terra, e non v'era alcun uomo per lavorar la terra. ");
INSERT INTO ita1885_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Or un vapore saliva dalla terra, che adacquava tutta la faccia della terra. ");
INSERT INTO ita1885_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","E il Signore Iddio formò l'uomo del la polvere della terra, e gli alitò nelle nari un fiato vitale; e l'uomo fu fatto anima vivente. ");
INSERT INTO ita1885_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Or il Signore Iddio piantò un giardino in Eden, dall'Oriente, e pose quivi l'uomo ch'egli avea formato. ");
INSERT INTO ita1885_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","E il Signore Iddio fece germogliar dalla terra ogni sorta d'alberi piacevoli a riguardare, e buoni a mangiare; e l'albero della vita, in mezzo del giardino; e l'albero della conoscenza del bene e del male. ");
INSERT INTO ita1885_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ed un fiume usciva di Eden, per adacquare il giardino; e di là si spartiva in quattro capi. ");
INSERT INTO ita1885_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Il nome del primo è Pison; questo è quello che circonda tutto il paese di Havila, ove è dell'oro. ");
INSERT INTO ita1885_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","E l'oro di quel paese è buono; quivi ancora si trovano le perle e la pietra onichina. ");
INSERT INTO ita1885_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","E il nome del secondo fiume è Ghihon; questo è quello che circonda tutto il paese di Cus. ");
INSERT INTO ita1885_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","E il nome del terzo fiume è Hiddechel; questo è quello che corre di rincontro all'Assiria. E il quarto fiume è l'Eufrate. ");
INSERT INTO ita1885_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Il Signore Iddio adunque prese l'uomo e lo pose nel giardino di Eden, per lavorarlo, e per guardarlo. ");
INSERT INTO ita1885_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","E il Signore Iddio comandò all'uomo, dicendo: Mangia pur d'ogni albero del giardino. ");
INSERT INTO ita1885_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Ma non mangiar dell'albero della conoscenza del bene e del male; perciocchè, nel giorno che tu ne mangerai per certo tu morrai. ");
INSERT INTO ita1885_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Il Signore Iddio disse ancora: E' non è bene che l'uomo sia solo; io gli farò un aiuto convenevole a lui. ");
INSERT INTO ita1885_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Or il Signore Iddio, avendo formate della terra tutte le bestie della campagna, e tutti gli uccelli del cielo, li menò ad Adamo, acciocchè vedesse qual nome porrebbe a ciascuno di essi; e che qualunque nome Adamo ponesse a ciascuno animale, esso fosse il suo nome. ");
INSERT INTO ita1885_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","E Adamo pose nome ad ogni animal domestico, ed agli uccelli del cielo, e ad ogni fiera della campagna; ma non si trovava per Adamo aiuto convenevole a lui. ");
INSERT INTO ita1885_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","E il Signore Iddio fece cadere un profondo sonno sopra Adamo, onde egli si addormentò; e Iddio prese una delle coste di esso, e saldò la carne nel luogo di quella. ");
INSERT INTO ita1885_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","E il Signore Iddio fabbricò una donna della costa che egli avea tolta ad Adamo, e la menò ad Adamo. ");
INSERT INTO ita1885_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","E Adamo disse: A questa volta pure ecco osso delle mie ossa, e carne della mia carne; costei sarà chiamata femmina d'uomo, conciossiachè costei sia stata tolta dall'uomo. ");
INSERT INTO ita1885_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Perciò l'uomo lascerà suo padre e sua madre, e si atterrà alla sua moglie, ed essi diverranno una stessa carne. ");
INSERT INTO ita1885_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Or amendue, Adamo e la sua moglie, erano ignudi, e non se ne vergognavano. ");
INSERT INTO ita1885_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","OR il serpente era astuto più che qualunque altra bestia della campagna, che il Signore Iddio avesse fatta. Ed esso disse alla donna: Ha pure Iddio detto: Non mangiate del frutto di tutti gli alberi del giardino? ");
INSERT INTO ita1885_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","E la donna disse al serpente: Noi possiamo mangiare del frutto degli alberi del giardino. ");
INSERT INTO ita1885_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Ma del frutto dell'albero, ch'è in mezzo del giardino, Iddio ha detto: Non ne mangiate, e nol toccate, chè non muoiate. ");
INSERT INTO ita1885_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","E il serpente disse alla donna: Voi non morreste punto. ");
INSERT INTO ita1885_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ma Iddio sa che, nel giorno che voi ne mangereste, i vostri occhi si aprirebbero; onde sareste come dii, avendo conoscenza del bene e del male. ");
INSERT INTO ita1885_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","La donna adunque, veggendo che il frutto dell'albero era buono a mangiare, e ch'era dilettevole a vedere e che l'albero era desiderabile per avere intelletto, prese del frutto, e ne mangiò, e ne diede ancora al suo marito, acciocchè ne mangiasse seco. Ed egli ne mangiò. ");
INSERT INTO ita1885_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Allora gli occhi di amendue loro si apersero, e conobbero ch'erano ignudi; onde cucirono insieme delle foglie di fico, e se ne fecero delle coperte da cignersi attorno. ");
INSERT INTO ita1885_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Poi, all'aura del dì, udirono la voce del Signore Iddio che camminava per lo giardino. E Adamo, con la sua moglie, si nascose dal cospetto del Signore Iddio, per mezzo gli alberi del giardino. ");
INSERT INTO ita1885_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","E il Signore Iddio chiamò Adamo, e gli disse: Ove sei? ");
INSERT INTO ita1885_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ed egli disse: Io intesi la tua voce per lo giardino, e temetti, perciocchè io era ignudo; e mi nascosi. ");
INSERT INTO ita1885_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","E Iddio disse: Chi ti ha mostrato che tu fossi ignudo? Hai tu mangiato del frutto dell'albero, del quale io ti avea vietato di mangiare? ");
INSERT INTO ita1885_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","E Adamo disse: La donna, che tu hai posta meco, è quella che mi ha dato del frutto dell'albero, ed io ne ho mangiato. ");
INSERT INTO ita1885_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","E il Signore Iddio disse alla donna: Che cosa è questo che tu hai fatto? E la donna rispose: Il serpente mi ha sedotta, ed io ho mangiato di quel frutto. ");
INSERT INTO ita1885_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Allora il Signore Iddio disse al serpente: Perciocchè tu hai fatto questo, sii maledetto sopra ogni altro animale, e sopra ogni altra bestia della campagna; tu camminerai in sul tuo ventre, e mangerai la polvere tutti i giorni della tua vita. ");
INSERT INTO ita1885_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ed io metterò inimicizia fra te e la donna, e fra la tua progenie e la progenie di essa; essa progenie ti triterà il capo e tu le ferirai il calcagno. ");
INSERT INTO ita1885_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Poi disse alla donna: Io accrescerò grandemente i dolori del tuo parto e della tua gravidanza; tu partorirai figliuoli con dolori, e i tuoi desiderii dipenderanno dal tuo marito, ed egli signoreggerà sopra te. ");
INSERT INTO ita1885_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","E ad Adamo disse: Perciocchè tu hai atteso alla voce della tua moglie, ed hai mangiato del frutto dell'albero, del quale io ti avea data questo comandamento: Non mangiarne: la terra sarà maledetta per cagion tua; tu mangerai del frutto di essa con affanno, tutti i giorni della tua vita. ");
INSERT INTO ita1885_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ed ella ti produrrà spine e triboli; e tu mangerai l'erba de' campi. ");
INSERT INTO ita1885_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Tu mangerai il pane col sudor del tuo volto, fin che tu ritorni in terra; conciossiachè tu ne sii stato tolto; perciocchè tu sei polvere, tu ritornerai altresì in polvere. ");
INSERT INTO ita1885_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","E Adamo pose nome Eva alla sua moglie; perciocchè ella è stata madre di tutti i viventi. ");
INSERT INTO ita1885_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","E il Signore Iddio fece delle toniche di pelle ad Adamo ed alla sua moglie; e li vestì. ");
INSERT INTO ita1885_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Poi il Signore Iddio disse: Ecco, l'uomo è divenuto come uno di noi, avendo conoscenza del bene e del male; ora adunque e' si convien provvedere che talora egli non istenda la mano, e non prenda ancora del frutto dell'albero della vita, e ne mangi, e viva in perpetuo. ");
INSERT INTO ita1885_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Perciò il Signore Iddio mandò l'uomo fuor del giardino di Eden, per lavorar la terra, dalla quale era stato tolto. ");
INSERT INTO ita1885_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Così egli cacciò l'uomo, e pose dei Cherubini davanti al giardino di Eden, con una spada fiammeggiante che si vibrava in giro, per guardar la via dell'albero della vita. ");
INSERT INTO ita1885_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","OR Adamo conobbe la sua moglie, ed ella concepette, e partorì Caino, e disse: Io ho acquistato un uomo col Signore. ");
INSERT INTO ita1885_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Poi partorì ancora Abele, fratello di esso. Ed Abele fu pastore di pecore, e Caino fu lavorator della terra. ");
INSERT INTO ita1885_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Or avvenne, in capo di alquanto tempo, che Caino offerse al Signore offerta de' frutti della terra. ");
INSERT INTO ita1885_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ed Abele offerse anch'esso de' primogeniti delle sue pecore, e del grasso di esse. E il Signore riguardò ad Abele ed alla sua offerta. ");
INSERT INTO ita1885_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ma non riguardò a Caino, nè alla sua offerta; onde Caino si sdegnò grandemente, e il suo volto fu abbattuto. ");
INSERT INTO ita1885_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","E il Signore disse a Caino: Perchè sei tu sdegnato? e perchè è il tuo volto abbattuto? ");
INSERT INTO ita1885_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Se tu fai bene, non vi sarà egli esaltazione? ma altresì, se tu fai male, il peccato giace alla porta. Ora i desiderii di esso dipendono da te, e tu hai la signoria sopra lui. ");
INSERT INTO ita1885_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","E Caino disse ad Abele suo fratello: Andiamo ai campi. Ed avvenne che essendo essi ai campi, Caino si levò contro ad Abele suo fratello, e l'uccise. ");
INSERT INTO ita1885_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","E il Signore disse a Caino: Ov'è Abele tuo fratello? Ed egli disse: Io non so; sono io guardiano del mio fratello? ");
INSERT INTO ita1885_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","E il Signore gli disse: Che hai fatto? ecco la voce del sangue del tuo fratello grida a me dalla terra. ");
INSERT INTO ita1885_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ora dunque tu sei maledetto, e sarai cacciato dalla terra, che ha aperta la sua bocca per ricevere il sangue del tuo fratello dalla tua mano. ");
INSERT INTO ita1885_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Quando tu lavorerai la terra, ella non continuerà più di renderti la sua virtù; e tu sarai vagabondo ed errante sulla terra. ");
INSERT INTO ita1885_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","E Caino disse al Signore: La mia iniquità è più grande che io non posso portare. ");
INSERT INTO ita1885_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ecco, tu mi hai oggi cacciato d'in su la faccia della terra, ed io sarò nascosto dal tuo cospetto, e sarò vagabondo ed errante sulla terra; ed avverrà che chiunque mi troverà mi ucciderà. ");
INSERT INTO ita1885_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","E il Signore gli disse: Perciò, chiunque ucciderà Caino sarà punito a sette doppi più che Caino. E il Signore pose un segnale in Caino, acciocchè alcuno, trovandolo, non lo uccidesse. ");
INSERT INTO ita1885_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","E Caino si partì dal cospetto del Signore, e dimorò nel paese di Nod, dalla parte orientale di Eden. ");
INSERT INTO ita1885_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","E Caino conobbe la sua moglie, ed ella concepette, e partorì Enoch. Poi egli si mise ad edificare una città, e la nominò del nome del suo figliuolo Enoch. ");
INSERT INTO ita1885_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","E ad Enoch nacque Irad; ed Irad generò Mehujael; e Mehujael generò Metusael; e Metusael generò Lamec. ");
INSERT INTO ita1885_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","E Lamec si prese due mogli; il nome dell'una delle quai era Ada, e il nome dell'altra Silla. ");
INSERT INTO ita1885_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","E Ada partorì Iabal. Esso fu padre di coloro che dimorano in tende, e son mandriani. ");
INSERT INTO ita1885_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","E il nome del suo fratello fu Iubal. Esso fu padre di tutti coloro che maneggiano la cetera e l'organo. ");
INSERT INTO ita1885_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","E Silla partorì anch'ella Tubal-cain, il quale ha ammaestrato ogni fabbro di rame e di ferro; e la sorella di Tubal-cain fu Naama. ");
INSERT INTO ita1885_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","E Lamec disse ad Ada e Silla sue mogli: Ascoltate la mia voce, mogli di Lamec; Porgete l'orecchio al mio parlare. Certo io ho ucciso un uomo, dandogli una ferita; Ed un giovane, dandogli una percossa. ");
INSERT INTO ita1885_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Se Caino è vendicato a sette doppi, Lamec lo sarà a settanta volte sette doppi. ");
INSERT INTO ita1885_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","E Adamo conobbe ancora la sua moglie; ed ella partorì un figliuolo, e gli pose nome Set; perciocchè, disse ella, Iddio mi ha riposta un'altra progenie in luogo di Abele, che Caino ha ucciso. ");
INSERT INTO ita1885_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Ed a Set ancora nacque un figliuolo; ed egli gli pose nome Enos. Allora si cominciò a nominare una parte degli uomini del Nome del Signore. ");
INSERT INTO ita1885_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","QUESTA è la descrizione delle generazioni di Adamo. Nel giorno che Iddio creò l'uomo, egli lo fece alla sua somiglianza. ");
INSERT INTO ita1885_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Egli li creò maschio e femmina, e li benedisse, e pose loro nome UOMO, nel giorno che furono creati. ");
INSERT INTO ita1885_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ora Adamo, essendo vivuto centotrent'anni, generò un figliuolo alla sua somiglianza, secondo la sua immagine; e gli pose nome Set. ");
INSERT INTO ita1885_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","E il tempo che visse Adamo, dopo ch'ebbe generato Set, fu ottocent'anni; e generò figliuoli e figliuole. ");
INSERT INTO ita1885_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Così tutto il tempo che visse Adamo fu novecentrent'anni; poi morì. ");
INSERT INTO ita1885_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","E Set, essendo vivuto centocinque anni, generò Enos. ");
INSERT INTO ita1885_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","E Set, dopo che ebbe generato Enos, visse ottocensette anni, e generò figliuoli e figliuole. ");
INSERT INTO ita1885_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Così tutto il tempo che visse Set fu novecendodici anni; poi morì. ");
INSERT INTO ita1885_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ed Enos, essendo vivuto novant'anni, generò Chenan. ");
INSERT INTO ita1885_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ed Enos, dopo ch'ebbe generato Chenan, visse ottocenquindici anni, e generò figliuoli e figliuole. ");
INSERT INTO ita1885_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Così tutto il tempo che visse Enos fu novecencinque anni; poi morì. ");
INSERT INTO ita1885_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","E Chenan, essendo vivuto settant'anni, generò Mahalaleel. ");
INSERT INTO ita1885_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","E Chenan, dopo ch'ebbe generato Mahalaleel, visse ottocenquarant'anni, e generò figliuoli e figliuole. ");
INSERT INTO ita1885_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Così tutto il tempo che Chenan visse fu novecendieci anni; poi morì. ");
INSERT INTO ita1885_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","E Mahalaleel, essendo vivuto sessantacinque anni, generò Iared. ");
INSERT INTO ita1885_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","E Mahalaleel, dopo ch'ebbe generato Iared, visse ottocentrent'anni, e generò figliuoli e figliuole. ");
INSERT INTO ita1885_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Così tutto il tempo che Mahalaleel visse fu ottocennovantacinque anni; poi morì. ");
INSERT INTO ita1885_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","E Iared, essendo vivuto censessantadue anni, generò Enoc. ");
INSERT INTO ita1885_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","E Iared, dopo ch'ebbe generato Enoc, visse ottocent'anni, e generò figliuoli e figliuole. ");
INSERT INTO ita1885_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Così tutto il tempo che Iared visse fu novecensessantadue anni; poi morì. ");
INSERT INTO ita1885_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ed Enoc essendo vivuto sessantacinque anni, generò Metusela. ");
INSERT INTO ita1885_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Ed Enoc, dopo ch'ebbe generato Metusela, camminò con Dio per lo spazio di trecent'anni e generò figliuoli e figliuole. ");
INSERT INTO ita1885_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Così, tutto il tempo che Enoc visse fu trecensessantacinque anni. ");
INSERT INTO ita1885_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","E dopo che Enoc fu camminato con Dio, non si vide più; perciocchè Iddio lo prese. ");
INSERT INTO ita1885_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","E Metusela, essendo vivuto centottantasette anni, generò Lamec. ");
INSERT INTO ita1885_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","E Metusela, dopo ch'ebbe generato Lamec, visse settecentottantadue anni, e generò figliuoli e figliuole. ");
INSERT INTO ita1885_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Così, tutto il tempo che Metusela visse fu novecensessantanove anni; poi morì. ");
INSERT INTO ita1885_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","E Lamec, essendo vivuto centottantadue anni, generò un figliuolo. ");
INSERT INTO ita1885_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","E gli pose nome Noè, dicendo: Costui ci consolerà della nostra opera, e della fatica delle nostre mani, la quale portiamo per cagion della terra che il Signore ha maladetta. ");
INSERT INTO ita1885_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","E Lamec, dopo ch'ebbe generato Noè, visse cinquecennovantacinque anni, e generò figliuoli e figliuole. ");
INSERT INTO ita1885_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Così tutto il tempo che Lamec visse fu settecensettantasette anni; poi morì. ");
INSERT INTO ita1885_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","E Noè, essendo di età di cinquecent'anni, generò Sem, Cam e Iafet. ");
INSERT INTO ita1885_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","OR avvenne che, quando gli uomini cominciarono a moltiplicar sopra la terra, e che furono loro nate delle figliuole, ");
INSERT INTO ita1885_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","i figliuoli di Dio, veggendo che le figliuole degli uomini erano belle, si presero per mogli quelle che si scelsero d'infra tutte. ");
INSERT INTO ita1885_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","E il Signore disse: Lo Spirito mio non contenderà in perpetuo con gli uomini; perciocchè anche non sono altro che carne; e il termine loro sarà centovent'anni. ");
INSERT INTO ita1885_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","In quel tempo i giganti erano in su la terra, e furono anche dappoi, quando i figliuoli di Dio entrarono dalle figliuole degli uomini, ed esse partorirono loro de' figliuoli. Costoro son quegli uomini possenti, i quali già anticamente erano uomini famosi. ");
INSERT INTO ita1885_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","E il Signore, veggendo che la malvagità degli uomini era grande in terra; e che tutte le immaginazioni de' pensieri del cuor loro non erano altro che male in ogni tempo, ");
INSERT INTO ita1885_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ei si pentì d'aver fatto l'uomo in su la terra, e se ne addolorò nel cuor suo. ");
INSERT INTO ita1885_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","E il Signore disse: Io sterminerò d'in su la terra gli uomini che io ho creati; io sterminerò ogni cosa, dagli uomini fino agli animali, ai rettili ed agli uccelli del cielo; perciocchè io mi pento di averli fatti. ");
INSERT INTO ita1885_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ma Noè trovò grazia appo il Signore. ");
INSERT INTO ita1885_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Queste son le generazioni di Noè. Noè fu uomo giusto, intiero nelle sue età, e camminò con Dio. ");
INSERT INTO ita1885_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","E generò tre figliuoli: Sem, Cam e Iafet. ");
INSERT INTO ita1885_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ora, la terra si era corrotta nel cospetto di Dio, ed era piena di violenza. ");
INSERT INTO ita1885_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","E Iddio riguardò la terra, ed ecco era corrotta; poichè ogni carne aveva corrotta la sua via in su la terra. ");
INSERT INTO ita1885_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","E Iddio disse a Noè: Appo me la fine di ogni carne è giunta; perciocchè la terra è ripiena di violenza per cagion di costoro; ed ecco io li farò perire, insieme con la terra. ");
INSERT INTO ita1885_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Fatti un'Arca di legno di Gofer; falla a stanze, ed impeciala, di fuori e di dentro, con pece. ");
INSERT INTO ita1885_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","E questa è la forma della qual tu la farai: la lunghezza di essa sia di trecento cubiti, e la larghezza di cinquanta cubiti, e l'altezza di trenta cubiti. ");
INSERT INTO ita1885_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","E da' lume all'Arca; e fa' il comignolo di essa disopra di un cubito; e metti la porta dell'Arca al lato di essa; falla a tre palchi, basso, secondo e terzo. ");
INSERT INTO ita1885_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ed ecco io farò venir sopra la terra il diluvio delle acque, per far perir di sotto al cielo ogni carne in cui è alito di vita; tutto ciò ch'è in terra morrà. ");
INSERT INTO ita1885_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ma io fermerò il mio patto teco; e tu entrerai nell'Arca, tu, ed i tuoi figliuoli, e la tua moglie, e le mogli de' tuoi figliuoli teco. ");
INSERT INTO ita1885_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","E di ogni creatura vivente, di ogni carne, fanne entrar dentro l'Arca due per ciascuna, che saranno maschio e femmina, per conservarli in vita teco. ");
INSERT INTO ita1885_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Degli uccelli, secondo le loro specie; delle bestie, secondo le loro specie; e di tutti i rettili, secondo le loro specie; due per ciascuna verranno a te, per esser conservati in vita. ");
INSERT INTO ita1885_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","E tu, prenditi di ogni cibo che si mangia, ed accoglilo appresso a te; acciocchè sia a te ed a quegli animali per cibo. ");
INSERT INTO ita1885_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","E Noè fece così; egli fece secondo tutto ciò che Iddio gli avea comandato. ");
INSERT INTO ita1885_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Poi il Signore disse a Noè: Entra tu, e tutta la tua famiglia dentro l'Arca; perciocchè in questa età io ti ho veduto giusto davanti a me. ");
INSERT INTO ita1885_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Di ciascuna specie di animali mondi, prendine sette paia, maschio e femmina; e degli animali immondi, un paio, un maschio e la sua femmina. ");
INSERT INTO ita1885_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Degli uccelli del cielo, prendine parimente di ciascuna specie sette paia, maschio e femmina; per conservarne in vita la generazione sopra la terra. ");
INSERT INTO ita1885_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Perciocchè fra qui e sette dì, io farò piovere in su la terra per lo spazio di quaranta giorni e di quaranta notti, e sterminerò d'in su la terra ogni cosa sussistente che io ho fatta. ");
INSERT INTO ita1885_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","E Noè fece secondo tutto ciò che il Signore gli avea comandato. ");
INSERT INTO ita1885_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Or Noè era di età di seicent'anni, quando il diluvio fu, e le acque vennero sopra la terra. ");
INSERT INTO ita1885_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","E Noè, insieme co' suoi figliuoli, e con la sua moglie, e con le mogli de' suoi figliuoli, entrò nell'Arca d'innanzi alle acque del diluvio. ");
INSERT INTO ita1885_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Degli animali mondi, e degli animali immondi, e degli uccelli, e di tutto ciò che serpe in su la terra, ");
INSERT INTO ita1885_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ne vennero delle paia, maschio e femmina, a Noè, dentro l'Arca; come Iddio avea comandato a Noè. ");
INSERT INTO ita1885_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ed avvenne, al termine de' sette giorni, che le acque del diluvio vennero sopra la terra. ");
INSERT INTO ita1885_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","L'anno seicentesimo della vita di Noè, nel secondo mese, nel decimosettimo giorno del mese, in quel giorno tutte le fonti del grande abisso scoppiarono, e le cateratte del cielo furono aperte. ");
INSERT INTO ita1885_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","E la pioggia fu in su la terra, per lo spazio di quaranta giorni e di quaranta notti. ");
INSERT INTO ita1885_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","In quel giorno stesso Noè entrò nell'Arca, insieme con Sem, Cam e Iafet, suoi figliuoli, e con la sua moglie, e con le tre mogli de' suoi figliuoli. ");
INSERT INTO ita1885_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Essi vi entrarono, ed anche fiere de ogni specie, ed animali domestici di ogni specie, e rettili che serpono sopra la terra di ogni specie, ed uccelli di ogni specie, ed uccelletti di ogni sorta di qualunque ala. ");
INSERT INTO ita1885_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","In somma, di ogni carne, in cui è alito di vita, ne venne un paio a Noè dentro l'Arca. ");
INSERT INTO ita1885_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","E gli animali che vennero erano maschio e femmina, come Iddio avea comandato a Noè. Poi il Signore serrò l'Arca sopra esso. ");
INSERT INTO ita1885_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","E il diluvio venne sopra la terra, per lo spazio di quaranta giorni; e le acque crebbero, e sollevarono l'Arca, ed ella fu alzata d'in su la terra. ");
INSERT INTO ita1885_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","E le acque si rinforzarono, e crebbero grandemente sopra la terra; e l'Arca notava sopra le acque. ");
INSERT INTO ita1885_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","E le acque si rinforzarono grandissimamente sopra la terra; e tutti gli alti monti, che son sotto tutti i cieli, furono coperti. ");
INSERT INTO ita1885_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Le acque avanzarono essi monti, dell'altezza di quindici cubiti. Così i monti furono coperti. ");
INSERT INTO ita1885_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ed ogni carne che si muove sopra la terra, degli uccelli, degli animali domestici, delle fiere e di tutti i rettili che serpono sopra la terra, morì, insieme con tutti gli uomini. ");
INSERT INTO ita1885_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Tutto ciò che ha fiato d'alito di vita nelle sue nari, d'infra tutto ciò ch'era nell'asciutto, morì. ");
INSERT INTO ita1885_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","E fu sterminata ogni cosa sussistente, che era sopra la faccia della terra, dagli uommi fino alle bestie, e i rettili, e gli uccelli del cielo; furono, dico, sterminati d'in su la terra; e Noè solo scampò, con quelli ch'erano con lui nell'Arca. ");
INSERT INTO ita1885_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","E le acque furono alte sopra la terra, per lo spazio di cencinquanta giorni. ");
INSERT INTO ita1885_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","OR Iddio si ricordò di Noè, e di tutte le fiere, e di tutti gli animali domestici ch'erano con lui nell'Arca; e fece passare un vento in su la terra; e le acque si posarono. ");
INSERT INTO ita1885_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ed essendo state le fonti dell'abisso e le cateratte del cielo serrate, e rattenuta la pioggia del cielo, ");
INSERT INTO ita1885_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","le acque andarono del continuo ritirandosi d'in su la terra. Al termine adunque di cencinquanta giorni cominciarono a scemare. ");
INSERT INTO ita1885_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","E, nel decimosettimo giorno del settimo mese, l'Arca si fermò sopra le montagne di Ararat. ");
INSERT INTO ita1885_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","E le acque andarono scemando fino al decimo mese. Nel primo giorno del decimo mese, le sommità de' monti apparvero. ");
INSERT INTO ita1885_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","E, in capo di quaranta giorni, Noè aperse la finestra dell'Arca, ch'egli avea fatta. ");
INSERT INTO ita1885_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","E mandò fuori il corvo, il quale usciva del continuo fuori, e tornava, fin che le acque furono asciutte d'in su la terra. ");
INSERT INTO ita1885_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Poi mandò d'appresso a sè la colomba, per veder se le acque erano scemate d'in su la faccia della terra. ");
INSERT INTO ita1885_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ma la colomba, non trovando ove posar la pianta del piè, se ne ritornò a lui dentro l'Arca; perciocchè v'erano ancora delle acque sopra la faccia di tutta la terra. Ed egli, stesa la mano, la prese, e l'accolse a sè, dentro l'Arca. ");
INSERT INTO ita1885_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ed egli aspettò sette altri giorni, e di nuovo mandò la colomba fuor dell'Arca. ");
INSERT INTO ita1885_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ed in sul tempo del vespro, la colomba ritornò a lui; ed ecco, avea nel becco una fronde spiccata di un ulivo; onde Noè conobbe che le acque erano scemate d'in su la terra. ");
INSERT INTO ita1885_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ed egli aspettò sette altri giorni, e mandò fuori la colomba, ed essa non ritornò più a lui. ");
INSERT INTO ita1885_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","E, nell'anno seicentunesimo di Noè, nel primo giorno del primo mese, le acque furono asciutte d'in su la terra. E Noè, levato il coperto dell'Arca, vide che la faccia della terra era asciutta. ");
INSERT INTO ita1885_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","E, nel ventisettesimo giorno del secondo mese, la terra era tutta asciutta. ");
INSERT INTO ita1885_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","E Iddio parlò a Noè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Esci fuor dell'Arca, tu, e la tua moglie, ed i tuoi figliuoli, e le mogli de' tuoi figliuoli teco. ");
INSERT INTO ita1885_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Fa uscir fuori teco tutti gli animali che son teco, di qualunque carne, degli uccelli, delle bestie, e di tutti i rettili che serpono sopra la terra; e lascia che scorrano per la terra, e figlino, e moltiplichino in su la terra. ");
INSERT INTO ita1885_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","E Noè uscì fuori, co' suoi figliuoli, e con la sua moglie, e con le mogli de' suoi figliuoli. ");
INSERT INTO ita1885_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Tutte le bestie ancora, e tutti i rettili, e tutti gli uccelli, e tutti gli animali che si muovono sopra la terra, secondo le lor generazioni, uscirono fuor dell'Arca. ");
INSERT INTO ita1885_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","E Noè edificò un altare al Signore; e prese d'ogni specie di animali mondi, e d'ogni specie di uccelli mondi, ed offerse olocausti sopra l'altare. ");
INSERT INTO ita1885_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","E il Signore odorò un odor soave; e disse nel cuor suo: Io non maledirò più la terra per l'uomo; conciossiachè l'immaginazione del cuor dell'uomo sia malvagia fin dalla sua fanciullezza; e non percoterò più ogni cosa vivente, come ho fatto. ");
INSERT INTO ita1885_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Da ora innanzi, quanto durerà la terra, sementa e ricolta, freddo e caldo, state e verno, giorno e notte giammai non cesseranno. ");
INSERT INTO ita1885_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","E IDDIO benedisse Noè, e i suoi figliuoli; e disse loro; Fruttate, e moltiplicate, e riempiete la terra. ");
INSERT INTO ita1885_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","E la paura e lo spavento di voi sia sopra tutte le bestie della terra, e sopra tutti gli uccelli del cielo; essi vi son dati nelle mani, insieme con tutto ciò che serpe sopra la terra, e tutti i pesci del mare. ");
INSERT INTO ita1885_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ogni cosa che si muove, ed ha vita, vi sarà per cibo; io ve le do tutte, come l'erbe verdi. ");
INSERT INTO ita1885_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ma pur non mangiate la carne con l'anima sua, ch'è il suo sangue. ");
INSERT INTO ita1885_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","E certamente io ridomanderò conto del vostro sangue, per le vostre persone; io ne ridomanderò conto ad ogni bestia, ed agli uomini; io ridomanderò conto della vita dell'uomo a qualunque suo fratello. ");
INSERT INTO ita1885_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Il sangue di colui che spanderà il sangue dell'uomo sarà sparso dall'uomo; perciocchè Iddio ha fatto l'uomo alla sua immagine. ");
INSERT INTO ita1885_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Voi dunque fruttate e moltiplicate; generate copiosamente sulla terra, e crescete in essa. ");
INSERT INTO ita1885_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Poi Iddio parlò a Noè, ed a' suoi figliuoli con lui, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","E quant'è a me, ecco, io fermo il mio patto con voi, e con la vostra progenie dopo voi; ");
INSERT INTO ita1885_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","e con ogni animal vivente ch'è con voi, così degli uccelli, come degli animali domestici, e di tutte le fiere della terra, con voi; così con quelle che sono uscite fuor dell'Arca, come con ogni altra bestia della terra. ");
INSERT INTO ita1885_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Io fermo il mio patto con voi, che ogni carne non sarà più distrutta per le acque del diluvio, e che non vi sarà più diluvio, per guastar la terra. ");
INSERT INTO ita1885_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Oltre a ciò, Iddio disse: Questo sarà il segno del patto che io fo fra me e voi e tutti gli animali viventi, che son con voi, in perpetuo per ogni generazione. ");
INSERT INTO ita1885_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Io ho messo il mio Arco nella nuvola; ed esso sarà per segno del patto fra me e la terra. ");
INSERT INTO ita1885_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ed avverrà che, quando io avrò coperta la terra di nuvole, l'Arco apparirà nella nuvola. ");
INSERT INTO ita1885_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Ed io mi ricorderò del mio patto, ch'è fra me e voi, ed ogni animal vivente, di qualunque carne; e le acque non faranno più diluvio, per distruggere ogni carne. ");
INSERT INTO ita1885_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","L'Arco adunque sarà nella nuvola, ed io lo riguarderò, per ricordarmi del patto perpetuo, fra Dio ed ogni animal vivente, di qualunque carne ch'è sopra la terra. ");
INSERT INTO ita1885_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Così Iddio disse a Noè: Questo è il segno del patto, che io ho fermato fra me ed ogni carne ch'è sopra la terra. ");
INSERT INTO ita1885_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","OR i figliuoli di Noè, che uscirono fuor dell'Arca, furono Sem, Cam e Iafet. ");
INSERT INTO ita1885_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","E Cam fu padre di Canaan. Questi tre furono figliuoli di Noè; e da essi, sparsi per tutta la terra, ella è stata popolata. ");
INSERT INTO ita1885_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","E Noè cominciò ad esser lavorator della terra e piantò la vigna. ");
INSERT INTO ita1885_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","E bevve del vino, e s'inebbriò, e si scoperse in mezzo del suo tabernacolo. ");
INSERT INTO ita1885_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","E Cam, padre di Canaan, vide le vergogne di suo padre, e lo rapportò fuori a' suoi due fratelli. ");
INSERT INTO ita1885_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ma Sem e Iafet presero un mantello, e se lo misero amendue in su le spalle; e, camminando a ritroso, copersero le vergogne del padre loro; e le faccie loro erano volte indietro, tal che non videro le vergogne del padre loro. ");
INSERT INTO ita1885_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","E, quando Noè si fu svegliato dal suo vino, seppe ciò che gli avea fatto il suo figliuol minore. ");
INSERT INTO ita1885_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","E disse: Maledetto sia Canaan; sia servo de' servi de' suoi fratelli. ");
INSERT INTO ita1885_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ma disse: Benedetto sia il Signore Iddio di Sem, e sia Canaan lor servo. ");
INSERT INTO ita1885_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Iddio allarghi Iafet, ed abiti egli ne' tabernacoli di Sem; e sia Canaan lor servo. ");
INSERT INTO ita1885_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","E Noè visse dopo il diluvio trecencinquant'anni. ");
INSERT INTO ita1885_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","E tutto il tempo che Noè visse fu novecencinquent'anni; poi morì. ");
INSERT INTO ita1885_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","OR queste sono le generazioni dei figliuoli di Noè: Sem, Cam e Iafet; e ad essi nacquero figliuoli dopo il diluvio. ");
INSERT INTO ita1885_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","I figliuoli di Iafet furono Gomer, e Magog, e Madai, e Iavan, e Tubal, e Mesec, e Tiras. ");
INSERT INTO ita1885_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","E i figliuoli di Gomer furono Aschenaz, e Rifat, e Togarma. ");
INSERT INTO ita1885_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","E i figliuoli di Iavan furono Elisa e Tarsis, Chittim e Dodanim. ");
INSERT INTO ita1885_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Da costoro, per le lor famiglie, nelle lor nazioni, è venuto lo spartimento dell'Isole delle genti, nei loro paesi, secondo la lingua di ciascun di essi. ");
INSERT INTO ita1885_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","E i figliuoli di Cam furono Cus, Misraim, e Put, e Canaan. ");
INSERT INTO ita1885_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","E i figliuoli di Cus furono Seba, ed Havila, e Sabta, e Rama, e Sabteca; ed i figliuoli di Rama furono Seba e Dedan. ");
INSERT INTO ita1885_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","E Cus generò Nimrod. Esso cominciò ad esser possente sulla terra. ");
INSERT INTO ita1885_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Egli fu un potente cacciatore nel cospetto del Signore; perciò si dice: Come Nimrod, potente cacciatore nel cospetto del Signore. ");
INSERT INTO ita1885_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","E il principio del suo regno fu Babilonia, ed Erec, ed Accad, e Calne, nel paese di Sinear. ");
INSERT INTO ita1885_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Di quel paese uscì Assur, ed edificò Ninive, e la città di Rehobot, a Cala; ");
INSERT INTO ita1885_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","e, fra Ninive e Cala, Resen, la gran città. ");
INSERT INTO ita1885_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","E Misraim generò Ludim, ed Anamim, e Lehabim, e Naftuhim, ");
INSERT INTO ita1885_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","e Patrusim, e Casluhim (onde sono usciti i Filistei), e Caftorim. ");
INSERT INTO ita1885_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","E Canaan generò Sidon suo primogenito, ed Het; ");
INSERT INTO ita1885_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","e il Gebuseo, e l'Amorreo, e il Ghirgaseo; ");
INSERT INTO ita1885_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","e l'Hivveo, e l'Archeo, e il Sineo; ");
INSERT INTO ita1885_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","e l'Arvadeo, e il Semareo, e l'Hamateo. E poi le famiglie de' Cananei si sparsero. ");
INSERT INTO ita1885_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ed i confini de' Cananei furono da Sidon, traendo verso Gherar, fino a Gaza; e traendo verso Sodoma, e Gomorra, ed Adma, e Seboim, fino a Lesa. ");
INSERT INTO ita1885_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Questi sono i figliuoli di Cam, secondo le lor famiglie e lingue, ne' lor paesi e nazioni. ");
INSERT INTO ita1885_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","A Sem ancora, padre di tutti i figliuoli di Eber, e fratel maggiore di Iafet, nacquero figliuoli. ");
INSERT INTO ita1885_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","I figliuoli di Sem furono Elam, ed Assur, ed Arfacsad, e Lud, ed Aram. ");
INSERT INTO ita1885_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","E i figliuoli di Aram furono Us, Hul, Gheter, e Mas. ");
INSERT INTO ita1885_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Ed Arfacsad generò Sela, e Sela generò Eber. ");
INSERT INTO ita1885_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","E ad Eber nacquero due figliuoli, il nome dell'uno fu Peleg, perciocchè al suo tempo la terra fu divisa; e il nome dell'altro suo fratello fu Ioctan. ");
INSERT INTO ita1885_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","E Ioctan generò Almodad, e Selef, ed Asarmavet, e Iera; ");
INSERT INTO ita1885_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","e Hadoram, ed Huzal, e Dicla; ");
INSERT INTO ita1885_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ed Obal, ed Abimael, e Seba; ");
INSERT INTO ita1885_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ed Ofir, ed Havila, e Iobab. Tutti costoro furono figliuoli di Ioctan. ");
INSERT INTO ita1885_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","E le loro abitazioni furono da Mesa, traendo verso Sefar, fino al monte Orientale. ");
INSERT INTO ita1885_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Costoro furono i figliuoli di Sem, secondo le lor famiglie e lingue, ne' lor paesi, per le lor nazioni. ");
INSERT INTO ita1885_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Queste son le famiglie de' figliuoli di Noè secondo le loro generazioni, nelle lor nazioni; e da costoro sono discese le genti divise per la terra, dopo il diluvio. ");
INSERT INTO ita1885_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","OR tutta la terra era d'una favella e di un linguaggio. ");
INSERT INTO ita1885_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ed avvenne che, partendosi gli uomini di Oriente, trovarono una pianura nel paese di Sinear, e quivi si posarono. ");
INSERT INTO ita1885_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","E dissero l'uno all'altro: Or su, facciamo de' mattoni, e cociamoli col fuoco. I mattoni adunque furono loro in vece di pietre, e il bitume in vece di malta. ");
INSERT INTO ita1885_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Poi dissero: Or su, edifichiamoci una città, ed una torre, la cui sommità giunga fino al cielo, ed acquistiamoci fama; che talora noi non siamo dispersi sopra la faccia di tutta la terra. ");
INSERT INTO ita1885_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","E il Signore discese, per veder la città e la torre che i figliuoli degli uomini edificavano. ");
INSERT INTO ita1885_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","E il Signore disse: Ecco un medesimo popolo, ed essi tutti hanno un medesimo linguaggio, e questo è il cominciamento del lor lavoro, ed ora tutto ciò che hanno disegnato di fare, non sarà loro divietato. ");
INSERT INTO ita1885_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Or su, scendiamo e confondiamo ivi la lor favella; acciocchè l'uno non intenda la favella dell'altro. ");
INSERT INTO ita1885_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","E il Signore li disperse di là sopra la faccia di tutta la terra; ed essi cessarono di edificar la città. ");
INSERT INTO ita1885_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Perciò essa fu nominata Babilonia; perciocchè il Signore confuse quivi la favella di tutta la terra, e disperse coloro di là sopra la faccia di tutta la terra. ");
INSERT INTO ita1885_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","QUESTE sono le generazioni di Sem: Sem, essendo d'età di cent'anni, generò Arfacsad, due anni dopo il diluvio. ");
INSERT INTO ita1885_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","E Sem, dopo ch'ebbe generato Arfacsad, visse cinquecent'anni, e generò figliuoli e figliuole. ");
INSERT INTO ita1885_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ed Arfacsad, essendo vivuto trentacinque anni, generò Sela. ");
INSERT INTO ita1885_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Ed Arfacsad, dopo ch'egli ebbe generato Sela, visse quattrocentotre anni, e generò figliuoli e figliuole. ");
INSERT INTO ita1885_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","E Sela, essendo vivuto trent'anni, generò Eber. ");
INSERT INTO ita1885_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","E Sela, dopo ch'ebbe generato Eber, visse quattrocentotre anni, e generò figliuoli e figliuole. ");
INSERT INTO ita1885_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ed Eber, essendo vivuto trentaquattr'anni, generò Peleg. ");
INSERT INTO ita1885_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ed Eber, dopo ch'ebbe generato Peleg, visse quattrocentrent'anni, e generò figliuoli e figliuole. ");
INSERT INTO ita1885_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","E Peleg, essendo vivuto trent'anni, generò Reu. ");
INSERT INTO ita1885_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","E Peleg, dopo ch'ebbe generato Reu, visse dugennove anni, e generò figliuoli e figliuole. ");
INSERT INTO ita1885_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","E Reu, essendo vivuto trentadue anni, generò Serug. ");
INSERT INTO ita1885_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","E Reu, dopo che ebbe generato Serug, visse dugensette anni, e generò figliuoli e figliuole. ");
INSERT INTO ita1885_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","E Serug, essendo vivuto trent'anni, generò Nahor. ");
INSERT INTO ita1885_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","E Serug, dopo che ebbe generato Nahor, visse dugent'anni, e generò figliuoli e figliuole. ");
INSERT INTO ita1885_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","E Nahor, essendo vivuto ventinove anni, generò Tare. ");
INSERT INTO ita1885_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","E Nahor, dopo ch'ebbe generato Tare, visse cendiciannove anni, e generò figliuoli e figliuole. ");
INSERT INTO ita1885_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","E Tare, essendo vivuto settant'anni, generò Abramo, Nahor, e Haran. ");
INSERT INTO ita1885_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","E queste sono le generazioni di Tare: Tare generò Abramo, Nahor e Haran; e Haran generò Lot. ");
INSERT INTO ita1885_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Or Haran morì in presenza di Tare suo padre, nel suo natio paese, in Ur de' Caldei. ");
INSERT INTO ita1885_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ed Abramo e Nahor si presero delle mogli; il nome della moglie di Abramo era Sarai; e il nome della moglie di Nahor, Milca, la quale era figliuola di Haran, padre di Milca e d'Isca. ");
INSERT INTO ita1885_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Or Sarai era sterile, e non avea figliuoli. ");
INSERT INTO ita1885_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","E Tare prese Abramo suo figliuolo, e Lot figliuol del suo figliuolo, cioè di Haran, e Sarai sua nuora, moglie di Abramo suo figliuolo; ed essi uscirono con loro fuori d'Ur de' Caldei, per andar nel paese di Canaan; e, giunti fino in Charan, dimorarono quivi. ");
INSERT INTO ita1885_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","E il tempo della vita di Tare fu dugentocinque anni; poi morì in Charan. ");
INSERT INTO ita1885_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","OR il Signore avea detto ad Abramo: Vattene fuor del tuo paese, e del tuo parentado, e della casa di tuo padre, nel paese che io ti mostrerò. ");
INSERT INTO ita1885_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ed io ti farò divenire una gran gente, e ti benedirò, e magnificherò il tuo nome; e tu sarai benedizione. ");
INSERT INTO ita1885_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ed io benedirò coloro che ti benediranno, e maledirò coloro che ti malediranno; e tutte le nazioni della terra saranno benedette in te. ");
INSERT INTO ita1885_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ed Abramo se ne andò, come il Signore gli avea detto; e Lot andò con lui. Or Abramo era d'età di settantacinque anni quando partì di Charan. ");
INSERT INTO ita1885_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abramo adunque prese Sarai sua moglie, e Lot figliuol del suo fratello, e tutte le lor facoltà che aveano acquistate, e parimente le persone che aveano acquistate in Charan; e si partirono, per andar nel paese di Canaan. E pervennero al paese di Canaan. ");
INSERT INTO ita1885_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ed Abramo passò per lo paese, fino al luogo di Sichem, fino alla pianura di More. Ed in quel tempo i Cananei erano nel paese. ");
INSERT INTO ita1885_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","E il Signore apparve ad Abramo, e gli disse: Io darò questo paese alla tua progenie. Ed Abramo edificò quivi un altare al Signore che gli era apparito. ");
INSERT INTO ita1885_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Poi egli si tramutò di là verso il monte, dalla parte orientale di Betel; e tese i suoi padiglioni, avendo dal lato occidentale Betel, e dall'orientale Ai; ed edificò quivi un altare al Signore, ed invocò il Nome del Signore. ");
INSERT INTO ita1885_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Poi Abramo si partì, camminando e traendo verso il Mezzodì. ");
INSERT INTO ita1885_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","OR sopravvenne una fame nel paese; ed Abramo scese in Egitto, per dimorarvi, perciocchè la fame era grave nel paese. ");
INSERT INTO ita1885_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","E, come egli fu presso ad entrare in Egitto, disse a Sarai sua moglie: Ecco, ora io so che tu sei donna di bell'aspetto. ");
INSERT INTO ita1885_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Laonde avverrà che, quando gli Egizj ti vedranno, diranno: Costei è moglie di costui; e mi uccideranno, e a te scamperanno la vita. ");
INSERT INTO ita1885_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Deh! di' che tu sei mia sorella; acciocchè per cagion di te mi sia fatto del bene, e per amor tuo la vita mi sia conservata. ");
INSERT INTO ita1885_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Avvenne adunque che, come Abramo fu venuto in Egitto, gli Egizj riguardarono quella donna, perchè ella era molto bella. ");
INSERT INTO ita1885_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ed i principi di Faraone, vedutala, la commendarono a Faraone; onde quella donna fu presa e menata in casa di Faraone. ");
INSERT INTO ita1885_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ed egli fece del bene ad Abramo, per amor di lei; ed egli n'ebbe pecore, e buoi, ed asini, e servi, e serve, ed asine, e cammelli. ");
INSERT INTO ita1885_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ma il Signore percosse Faraone e la sua casa di gran piaghe, per cagion di Sarai, moglie di Abramo. ");
INSERT INTO ita1885_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","E Faraone chiamò Abramo, e gli disse: Che cosa è questo che tu mi hai fatto? perchè non mi hai tu dichiarato ch'ella era tua moglie? ");
INSERT INTO ita1885_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Perchè dicesti: Ell'è mia sorella? onde io me l'avea presa per moglie; ora dunque, eccoti la tua moglie, prendila, e vattene. ");
INSERT INTO ita1885_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","E Faraone diede commissione di lui a certi uomini; ed essi accommiatarono lui e la sua moglie e tutto quello ch'era suo. ");
INSERT INTO ita1885_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abramo adunque salì di Egitto, con la sua moglie, e con tutto ciò ch'era suo, e con Lot, traendo verso il Mezzodì. ");
INSERT INTO ita1885_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","(Or Abramo era grandemente possente in bestiame, in argento ed in oro). ");
INSERT INTO ita1885_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ed egli, seguendo il suo viaggio, andò dal Mezzodì fino a Betel, fino al luogo dove prima erano stati i suoi padiglioni, fra Betel ed Ai, ");
INSERT INTO ita1885_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","nel luogo ove era l'altare che egli aveva prima fatto quivi; ed Abramo invocò quivi il nome del Signore. ");
INSERT INTO ita1885_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","OR Lot ancora, che andava con Abramo, avea pecore, e buoi, e padiglioni. ");
INSERT INTO ita1885_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","E il paese non li poteva portare, abitando amendue insieme; perciocchè le lor facoltà erano grandi, e non potevano dimorare insieme. ");
INSERT INTO ita1885_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","E nacque contesa fra i pastori del bestiame di Abramo, ed i pastori del bestiame di Lot. (Or i Cananei ed i Ferezei abitavano allora nel paese.) ");
INSERT INTO ita1885_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ed Abramo disse a Lot: Deh! non siavi contesa fra me e te, nè fra i miei pastori ed i tuoi; conciossiachè noi siamo fratelli. ");
INSERT INTO ita1885_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Tutto il paese non è egli davanti a te? deh! separati d'appresso a me; se tu vai a sinistra, io andrò a destra; e se tu vai a destra, io andrò a sinistra. ");
INSERT INTO ita1885_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","E Lot, alzati gli occhi, riguardò tutta la pianura del Giordano, ch'era tutta adacquata; avanti che il Signore avesse distrutto Sodoma e Gomorra, quella era come il giardino del Signore, come il paese di Egitto, fino a Soar. ");
INSERT INTO ita1885_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","E Lot elesse per sè tutta la pianura del Giordano; ed egli si partì, traendo verso l'Oriente; e così si separarono l'uno dall'altro. ");
INSERT INTO ita1885_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abramo dimorò nel paese di Canaan, e Lot dimorò nelle terre della pianura, e andò tendendo i suoi padiglioni fin che venne a Sodoma. ");
INSERT INTO ita1885_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ora gli uomini di Sodoma erano grandemente scellerati e peccatori contro al Signore. ");
INSERT INTO ita1885_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","E il Signore disse ad Abramo, dopo che Lot si fu separato d'appresso a lui: Alza ora gli occhi tuoi, e riguarda, dal luogo ove tu sei, verso il Settentrione, verso il Mezzodì, verso l'Oriente, e verso l'Occidente. ");
INSERT INTO ita1885_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Perciocchè io darò a te ed alla tua progenie, in perpetuo, il paese che tu vedi. ");
INSERT INTO ita1885_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","E farò che la tua progenie sarà come la polvere della terra; che se alcuno può annoverar la polvere della terra, anche potrassi annoverar la tua progenie. ");
INSERT INTO ita1885_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Levati, va' attorno per lo paese, per largo e per lungo; perciocchè io tel darò. ");
INSERT INTO ita1885_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abramo adunque andò tendendo i suoi padiglioni; e, giunto alle pianure di Mamre, che sono in Hebron, dimorò quivi, e vi edificò un altare al Signore. ");
INSERT INTO ita1885_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","OR avvenne al tempo di Amrafel re di Sinear, d'Arioc re di Ellasar, di Chedor-laomer re di Elam, e di Tideal re de' Goi, ");
INSERT INTO ita1885_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ch'essi fecero guerra contro a Bera re di Sodoma, e contro a Birsa re di Gomorra, e contro a Sineab re di Adma, e contro a Semeeber re di Seboim, e contro al re di Bela, ch'è Soar. ");
INSERT INTO ita1885_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Tutti costoro, fatta lega insieme, si adunarono nella Valle di Siddim, ch'è il mar salato. ");
INSERT INTO ita1885_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Essi erano stati soggetti a Chedor-laomer, lo spazio di dodici anni, ed al decimoterzo si erano ribellati. ");
INSERT INTO ita1885_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","E nell'anno decimoquarto, Chedor-laomer e i re ch'erano con lui erano venuti, ed aveano percossi i Rafei in Asterot-carnaim, e gli Zuzei in Ham, e gli Emei nella pianura di Chiriataim, ");
INSERT INTO ita1885_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","e gli Horei nelle lor montagne di Seir, fino alla pianura di Paran, ch'è presso al deserto. ");
INSERT INTO ita1885_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Poi, rivoltisi, erano venuti in Enmispat, ch'è Cades; ed aveano percosso tutto il territorio degli Amalechiti, ed anche gli Amorrei che dimoravano in Hasason-tamar. ");
INSERT INTO ita1885_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","E il re di Sodoma, e il re di Gomorra, e il re di Adma, e il re di Seboim, e il re di Bela, ch'è Soar, uscirono, ed ordinarono la battaglia nella Valle di Siddim, contro a questi: ");
INSERT INTO ita1885_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","contro a Chedor-laomer re di Elam, e Tideal re de' Goi, ed Amrafel re di Sinear, ed Arioc re di Ellasar; quattro re contro a cinque. ");
INSERT INTO ita1885_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Or la valle di Siddim era piena di pozzi di bitume; e i re di Sodoma e di Gomorra si misero in fuga, e cascarono dentro que' pozzi; e coloro che scamparono fuggirono verso il monte. ");
INSERT INTO ita1885_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","E quei re presero tutte le ricchezze di Sodoma e di Gomorra, e tutta la lor vittuaglia; poi se ne andarono. ");
INSERT INTO ita1885_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Presero ancora Lot figliuol del fratello di Abramo, il quale abitava in Sodoma, e la roba di esso; poi se ne andarono. ");
INSERT INTO ita1885_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ed alcuno ch'era scampato venne e rapportò la cosa ad Abramo Ebreo, il qual dimorava nelle pianure di Mamre Amorreo, fratello di Escol, e fratello di Aner, i quali erano collegati con Abramo. ");
INSERT INTO ita1885_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ed Abramo, com'ebbe inteso che il suo fratello era menato prigione, armò trecendiciotto de' suoi allievi nati in casa sua, e perseguì coloro fino in Dan. ");
INSERT INTO ita1885_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ed egli, co' suoi servitori, li assalì di notte da diverse bande, e li sconfisse, e li perseguì fino in Hoba, ch'è dal lato sinistro di Damasco. ");
INSERT INTO ita1885_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","E ricoverò tutta la roba; riscosse ancora Lot suo fratello, e la sua roba, ed anche le donne, e il popolo. ");
INSERT INTO ita1885_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","E di poi, come egli se ne ritornava dalla sconfitta di Chedor-laomer e de' re ch'erano con lui, il re di Sodoma gli uscì incontro nella Valle della pianura, ch'è la Valle del re. ");
INSERT INTO ita1885_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","E Melchisedec, re di Salem, arrecò pane e vino; or egli era sacerdote dell'Iddio altissimo. ");
INSERT INTO ita1885_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","E lo benedisse, dicendo: Benedetto sia Abramo, appo l'Iddio altissimo, possessor del cielo e della terra. ");
INSERT INTO ita1885_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","E benedetto sia l'altissimo Iddio, che ti ha dati i tuoi nemici nelle mani. Ed Abramo gli diede la decima di ogni cosa. ");
INSERT INTO ita1885_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","E il re di Sodoma disse ad Abramo: Dammi le persone, e prendi per te la roba. ");
INSERT INTO ita1885_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ma Abramo rispose al re di Sodoma: Io ho alzata la mano al Signore Iddio altissimo, possessor del cielo e della terra; ");
INSERT INTO ita1885_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","se, di tutto ciò ch'è tuo, io prendo pure un filo, od una correggia di scarpa; che talora tu non dica: Io ho arricchito Abramo; ");
INSERT INTO ita1885_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","salvo sol quello che questi fanti hanno mangiato, e la parte degli uomini che sono andati meco, cioè: Aner, Escol e Mamre; essi prenderanno la lor parte. ");
INSERT INTO ita1885_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","DOPO queste cose, la parola del Signore fu indirizzata ad Abramo in visione, dicendo: Non temere, o Abramo, io ti sono scudo; il tuo premio è molto grande. ");
INSERT INTO ita1885_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ed Abramo disse: O Signore Iddio, che mi daresti? conciossiachè io viva senza figliuoli, e colui che ha il governo della mia casa è questo Eliezer Damasceno. ");
INSERT INTO ita1885_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abramo disse ancora: Ecco, tu non mi hai data progenie; ed ecco, un servo nato in casa mia sarà mio erede. ");
INSERT INTO ita1885_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ed in quello stante, la parola del Signore gli fu indirizzata, dicendo: Costui non sarà tuo erede; anzi colui che uscirà delle tue viscere sarà tuo erede. ");
INSERT INTO ita1885_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Poi lo menò fuori, e gli disse: Riguarda ora verso il cielo, ed annovera le stelle, se pur tu le puoi annoverare. Poi gli disse: Così sarà la tua progenie. ");
INSERT INTO ita1885_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ed esso credette al Signore; e il Signore gl'imputò ciò a giustizia. ");
INSERT INTO ita1885_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","E gli disse: Io sono il Signore che ti ho fatto uscire di Ur de' Caldei, per darti questo paese, acciocchè tu lo possegga. ");
INSERT INTO ita1885_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ed Abramo rispose: Signore Iddio, a che conoscerò io che io lo possederò? ");
INSERT INTO ita1885_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","E il Signore gli disse: Pigliami una giovenca di tre anni, ed una capra di tre anni, ed un montone di tre anni, ed una tortora ed un pippione. ");
INSERT INTO ita1885_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ed egli prese tutte quelle cose, e le partì per lo mezzo, e pose ciascuna metà dirimpetto all'altra; ma non partì gli uccelli. ");
INSERT INTO ita1885_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Or certi uccelli discesero sopra quei corpi morti, ed Abramo, sbuffando, li cacciò. ");
INSERT INTO ita1885_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ed in sul tramontar del sole, un profondo sonno cadde sopra Abramo; ed ecco, uno spavento ed una grande oscurità cadde sopra lui. ");
INSERT INTO ita1885_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","E il Signore disse ad Abramo: Sappi pure che la tua progenie dimorerà come straniera in un paese che non sarà suo, e servirà alla gente di quel paese, la quale l'affliggerà; e ciò sarà per lo spazio di quattrocent'anni. ");
INSERT INTO ita1885_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ma altresì io farò giudicio della gente alla quale avrà servito; poi essi se ne usciranno con gran ricchezze. ");
INSERT INTO ita1885_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","E tu te ne andrai a' tuoi padri in pace, e sarai seppellito in buona vecchiezza. ");
INSERT INTO ita1885_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","E nella quarta generazione, essi ritorneranno qua; perciocchè fino ad ora l'iniquità degli Amorrei non è compiuta. ");
INSERT INTO ita1885_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ora, come il sole si fu coricato, venne una caligine; ed ecco, un forno fumante, ed un torchio acceso, il qual passò per mezzo quelle parti di quegli animali. ");
INSERT INTO ita1885_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","In quel giorno il Signore fece patto con Abramo, dicendo: Io ho dato alla tua progenie questo paese, dal fiume di Egitto fino al fiume grande, ch' è il fiume Eufrate; ");
INSERT INTO ita1885_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","il paese de' Chenei, e de' Chenizzei, e de' Cadmonei; ");
INSERT INTO ita1885_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","e degl'Hittei, e de' Ferezei, e de' Rafei; ");
INSERT INTO ita1885_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","e degli Amorrei, e de' Cananei, e de' Ghirgasei, e de' Gebusei. ");
INSERT INTO ita1885_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","OR Sarai, moglie di Abramo, non gli partoriva figliuoli; ");
INSERT INTO ita1885_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","ed avendo una serva egizia, nominata Agar, disse ad Abramo: Ecco, ora il Signore mi ha fatta sterile, tal che non posso far figliuoli; deh! entra dalla mia serva; forse avrò progenie da lei. Ed Abramo acconsentì alla voce di Sarai. ");
INSERT INTO ita1885_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Sarai adunque, moglie di Abramo, prese Agar egizia, sua serva, dopo che Abramo fu abitato nel paese di Canaan lo spazio di dieci anni, e la diede ad Abramo suo marito, da essergli per moglie. ");
INSERT INTO ita1885_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ed egli entrò da lei, ed ella concepette; e, veggendo che avea conceputo, sprezzò la sua padrona. ");
INSERT INTO ita1885_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","E Sarai disse ad Abramo: L'ingiuria ch'è fatta a me è sopra te; io ti ho data la mia serva in seno; ed ella, veggendo che ha conceputo, mi sprezza; il Signore giudichi fra me e te. ");
INSERT INTO ita1885_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ed Abramo rispose a Sarai: Ecco, la tua serva è in mano tua; falle come ti piacerà. Sarai adunque l'afflisse; laonde ella se ne fuggì dal suo cospetto. ");
INSERT INTO ita1885_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","E l'Angelo del Signore la trovò presso di una fonte d'acqua, nel deserto, presso della fonte ch'è in su la via di Sur. ");
INSERT INTO ita1885_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","E le disse: Agar, serva di Sarai, onde vieni? ed ove vai? Ed ella rispose: Io me ne fuggo dal cospetto di Sarai, mia padrona. ");
INSERT INTO ita1885_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","E l'Angelo del Signore le disse: Ritornatene alla tua padrona, ed umiliati sotto la sua mano. ");
INSERT INTO ita1885_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","L'Angelo del Signore le disse ancora: Io moltiplicherò grandemente la tua progenie; e non si potrà annoverare, per la moltitudine. ");
INSERT INTO ita1885_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","L'Angelo del Signore le disse oltre a ciò: Ecco, tu sei gravida, e partorirai un figliuolo, al quale poni nome Ismaele; perciocchè il Signore ha udita la tua afflizione. ");
INSERT INTO ita1885_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ed esso sarà un uomo simigliante ad un asino salvatico; la man sua sarà contro a tutti, e la man di tutti contro a lui; ed egli abiterà dirimpetto a tutti i suoi fratelli. ");
INSERT INTO ita1885_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Allora Agar chiamò il nome del Signore che parlava con lei: Tu sei l'Iddio della veduta; perciocchè disse: Ho io pur qui ancora veduto, dopo la mia visione? ");
INSERT INTO ita1885_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Perciò quel pozzo è stato nominato: Il pozzo del Vivente che mi vede; ecco, egli è fra Cades e Bered. ");
INSERT INTO ita1885_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ed Agar partorì un figliuolo ad Abramo; ed Abramo nominò il suo figliuolo, che Agar avea partorito, Ismaele. ");
INSERT INTO ita1885_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ed Abramo era di età d'ottantasei anni, quando Agar gli partorì Ismaele. ");
INSERT INTO ita1885_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","POI, quando Abramo fu d'età di novantanove anni, il Signore gli apparve, e gli disse: Io son l'Iddio Onnipotente; cammina davanti a me, e sii intiero. ");
INSERT INTO ita1885_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ed io stabilirò il mio patto fra me e te; e ti accrescerò grandissimamente. ");
INSERT INTO ita1885_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Allora Abramo cadde sopra la sua faccia, e Iddio parlò con lui, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Quant'è a me, ecco, io fo il mio patto teco: Tu diventerai padre d'una moltitudine di nazioni. ");
INSERT INTO ita1885_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","E tu non sarai più nominato Abramo; anzi il tuo nome sarà Abrahamo; perciocchè io ti ho costituito padre d'una moltitudine di nazioni. ");
INSERT INTO ita1885_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","E ti farò moltiplicare grandissimamente, e ti farò divenir nazioni; e re usciranno di te ");
INSERT INTO ita1885_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ed io fermerò il mio patto fra me e te, ed i tuoi discendenti dopo te, per le lor generazioni, per patto perpetuo; per esser l'Iddio tuo, e della tua progenie dopo te. ");
INSERT INTO ita1885_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","E darò a te, ed a' tuoi discendenti dopo te, il paese dove tu abiti come forestiere, tutto il paese di Canaan, in possessione perpetua; e sarò loro Dio. ");
INSERT INTO ita1885_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Iddio disse ancora ad Abrahamo: Tu altresì, ed i tuoi discendenti dopo te, per le lor generazioni, osservate il mio patto. ");
INSERT INTO ita1885_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Questo è il mio patto, che io fo fra me e voi, e la tua progenie dopo te, il quale voi avete ad osservare: Ogni maschio d'infra voi sia circonciso. ");
INSERT INTO ita1885_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","E voi circonciderete la carne del vostro prepuzio, e ciò sarà per segno del patto fra me a voi. ");
INSERT INTO ita1885_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ed ogni maschio d'infra voi sarà circonciso nell'età di otto giorni per le vostre generazioni; così il servo che sarà nato in casa, come colui che sarà stato comperato con danari d'infra qualunque popolo straniero, che non sarà della tua progenie. ");
INSERT INTO ita1885_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Circoncidasi del tutto, così colui che sarà nato in casa tua, come colui che tu avrai comperato co' tuoi danari; e sia il mio patto nella vostra carne, per patto perpetuo. ");
INSERT INTO ita1885_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","E quant'è al maschio incirconciso, la carne del cui prepuzio non sarà stata circoncisa, sia una tal persona ricisa dai suoi popoli; ella ha violato il mio patto. ");
INSERT INTO ita1885_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Oltre a ciò Iddio disse ad Abraham: Quant'è a Sarai, non chiamar più la tua moglie Sarai; perciocchè il suo nome ha ad esser Sara. ");
INSERT INTO ita1885_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ed io la benedirò, ed anche ti darò d'essa un figliuolo; io la benedirò, ed ella diventerà nazioni; e d'essa usciranno re di popoli. ");
INSERT INTO ita1885_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ed Abrahamo cadde sopra la sua faccia, e rise, e disse nel cuor suo: Nascerà egli pure un figliuolo ad un uomo di cent'anni? e Sara, ch'è d'età di novent'anni partorirà ella pure? ");
INSERT INTO ita1885_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ed Abrahamo disse a Dio: Viva pure Ismaele nel tuo cospetto. ");
INSERT INTO ita1885_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","E Iddio disse: Anzi Sara tua moglie ti partorirà un figliuolo, e tu gli porrai nome Isacco; ed io fermerò il mio patto con lui, per patto perpetuo per la sua progenie dopo lui. ");
INSERT INTO ita1885_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","E quant'è ad Ismaele ancora, io ti ho esaudito; ecco, io l'ho benedetto, e lo farò moltiplicare e crescer grandissimamente; egli genererà dodici principi, ed io lo farò divenire una gran nazione. ");
INSERT INTO ita1885_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ma io fermerò il mio patto con Isacco, il qual Sara ti partorirà l'anno vegnente, in quest'istessa stagione. ");
INSERT INTO ita1885_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","E, quando Iddio ebbe finito di parlare con Abrahamo, egli se ne salì d'appresso a lui. ");
INSERT INTO ita1885_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ed Abrahamo prese Ismaele suo figliuolo, e tutti coloro che gli erano nati in casa, e tutti coloro ch'egli avea comperati co' suoi danari, tutti i maschi dei suoi famigliari; e circoncise il prepuzio della lor carne, in quell'istesso giorno, come Iddio gliene avea parlato. ");
INSERT INTO ita1885_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Or Abrahamo era d'età di novantanove anni, quando egli circoncise la carne del suo prepuzio. ");
INSERT INTO ita1885_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ed Ismaele suo figliuolo era d'età di tredici anni, quando gli fu circoncisa la carne del suo prepuzio. ");
INSERT INTO ita1885_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","In quell'istesso giorno fu circonciso Abraham, ed Ismaele suo figliuolo. ");
INSERT INTO ita1885_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Furono parimente circoncisi con lui tutti gli uomini della sua casa, così quelli ch'erano nati in casa, come quelli ch'erano stati comperati con danari d'infra gli stranieri. ");
INSERT INTO ita1885_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","POI il Signore gli apparve nelle pianure di Mamre, essendo egli a sedere all'entrata del padiglione, in sul caldo del giorno. ");
INSERT INTO ita1885_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ed egli, alzati gli occhi, riguardò, ed ecco, tre uomini si presentarono a lui; e come egli li ebbe veduti, corse loro incontro dall'entrata del padiglione, e s'inchinò verso terra. E disse: ");
INSERT INTO ita1885_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Deh! Signore mio, se io ho trovato grazia appo te, non passare, ti prego, oltre la stanza del tuo servitore. ");
INSERT INTO ita1885_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Deh! prendasi un poco d'acqua, e lavatevi i piedi, e vi posate sotto quest'albero. ");
INSERT INTO ita1885_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ed io arrecherò una fetta di pane, e voi vi conforterete il cuore; poi procederete al vostro cammino; conciossiachè per questo siate passati dal vostro servitore. Ed essi dissero: Fa' così come tu hai detto. ");
INSERT INTO ita1885_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abrahamo adunque se ne andò in fretta nel padiglione a Sara, e le disse: Prendi prestamente tre misure di fior di farina, ed intridila, e fanne delle schiacciate. ");
INSERT INTO ita1885_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Abrahamo corse ancora all'armento, e ne prese un vitello tenero e buono, e lo diede al servitore, il qual si affrettò d'apparecchiarlo. ");
INSERT INTO ita1885_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Poi prese del burro e del latte, e quel vitello che il servitore avea apparecchiato, e pose queste cose davanti a loro: ed egli si stette presso di loro sotto quell'albero; ed essi mangiarono. ");
INSERT INTO ita1885_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","E gli dissero: Ov'è Sara tua moglie? Ed egli rispose: Eccola nel padiglione. ");
INSERT INTO ita1885_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ed egli gli disse: Io del tutto ritornerò a te, l'anno vegnente, in quest'istessa stagione; ed ecco, Sara tua moglie avrà un figliuolo. Or Sara ascoltava all'uscio del padiglione, dietro al quale essa era. ");
INSERT INTO ita1885_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Or Abrahamo e Sara erano vecchi ed attempati; ed era cessato a Sara ciò che sogliono aver le donne. ");
INSERT INTO ita1885_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","E Sara rise tra sè stessa, dicendo: Avrei io diletto, dopo essere invecchiata? ed oltre a ciò, il mio signoreè vecchio. ");
INSERT INTO ita1885_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","E il Signore disse ad Abrahamo: Perchè ha riso Sara, dicendo: Partorirei io pur certamente, essendo già vecchia? ");
INSERT INTO ita1885_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Evvi cosa alcuna difficile al Signore? io ritornerò a te al termine posto, l'anno vegnente, in quest'istessa stagione, e Sara avrà un figliuolo. ");
INSERT INTO ita1885_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","E Sara negò d'aver riso, dicendo: Io non ho riso; perciocchè ebbe paura. Ma egli le disse: Non dir così, perciocchè tu hai riso. ");
INSERT INTO ita1885_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","POI quegli uomini si levarono di là, e si dirizzarono verso Sodoma; ed Abrahamo andava con loro, per accommiatarli. ");
INSERT INTO ita1885_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","E il Signore disse: Celerò io ad Abrahamo ciò ch'io son per fare? ");
INSERT INTO ita1885_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Conciossiachè Abrahamo abbia pure a diventare una grande e possente nazione; ed in lui saranno benedette tutte le nazioni della terra. ");
INSERT INTO ita1885_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Perciocchè io l'ho conosciuto, io glielo paleserò, acciocchè ordini a' suoi figliuoli ed alla sua casa, dopo sè, che osservino la via del Signore, per far giustizia e giudicio; acciocchè il Signore faccia avvenire ad Abrahamo quello che gli ha promesso. ");
INSERT INTO ita1885_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Il Signore adunque disse: Certo il grido di Sodoma e di Gomorra è grande, e il lor peccato è molto grave. ");
INSERT INTO ita1885_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ora io scenderò, e vedrò se son venuti allo stremo, come il grido n'è pervenuto a me; e se no, io lo saprò. ");
INSERT INTO ita1885_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Quegli uomini adunque, partitisi di là, s'inviarono verso Sodoma; ed Abrahamo stette ancora davanti al Signore. ");
INSERT INTO ita1885_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ed Abrahamo si accostò, e disse: Faresti tu pur perire il giusto con l'empio? ");
INSERT INTO ita1885_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Forse vi son cinquanta uomini giusti dentro a quella città; li faresti tu eziandìo perire? anzi non perdoneresti tu a quel luogo per amor di cinquanta uomini giusti, che vi fosser dentro? ");
INSERT INTO ita1885_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Sia lungi da te il fare una cotal cosa, di far morire il giusto con l'empio, e che il giusto sia al par con l'empio. Sia ciò lungi da te; il Giudice di tutta la terra non farebbe egli diritta giustizia? ");
INSERT INTO ita1885_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","E il Signore disse: Se io trovo dentro alla città di Sodoma cinquanta uomini giusti, io perdonerò a tutto il luogo per amor di essi. ");
INSERT INTO ita1885_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ed Abrahamo rispose, e disse: Ecco, ora io ho pure impreso di parlare al Signore, benchè io sia polvere e cenere. ");
INSERT INTO ita1885_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Forse ne mancheranno cinque di quei cinquanta uomini giusti; distruggeresti tu tutta la città per cinque persone? E il Signore disse: Se io ve ne trovo quarantacinque, io non la distruggerò. ");
INSERT INTO ita1885_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ed Abrahamo continuò a parlargli, dicendo: Forse vi se ne troveranno quaranta. E il Signore disse: Per amor di que' quaranta, io nol farò. ");
INSERT INTO ita1885_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ed Abrahamo disse: Deh! non adirisi il Signore, ed io parlerò: Forse vi se ne troveranno trenta. E il Signore disse: Io nol farò, se ve ne trove trenta. ");
INSERT INTO ita1885_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ed Abrahamo disse: Ecco, ora io ho impreso di parlare al Signore: Forse vi se ne troveranno venti. E il Signore disse: Per amor di que' venti, io non la distruggerò. ");
INSERT INTO ita1885_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ed Abrahamo disse: Deh! non adirisi il Signore, ed io parlerò sol questa volta: Forse vi se ne troveranno dieci. E il Signore disse: Per amor di que' dieci, io non la distruggerò. ");
INSERT INTO ita1885_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","E quando il Signore ebbe finito di parlare ad Abrahamo, egli se ne andò; ed Abrahamo se ne ritornò al suo luogo. ");
INSERT INTO ita1885_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","OR que' due Angeli giunsero in Sodoma, in su la sera; e Lot sedeva alla porta di Sodoma; e come egli li vide, si levò per andar loro incontro, e s'inchinò verso terra. ");
INSERT INTO ita1885_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","E disse: Or su, signori miei, io vi prego, riducetevi in casa del vostro servitore, e statevi questa notte ad albergo, e vi lavate i piedi: poi domattina voi vi leverete, e ve ne andrete al vostro cammino. Ed essi dissero: No; anzi noi staremo questa notte in su la piazza. ");
INSERT INTO ita1885_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ma egli fece loro gran forza, tanto che essi si ridussero appo lui, ed entrarono in casa sua. Ed egli fece loro un convito, e cosse de' pani azzimi, ed essi mangiarono. ");
INSERT INTO ita1885_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Avanti che si fossero posti a giacere, gli uomini della città di Sodoma intorniarono la casa, giovani e vecchi, tutto il popolo, fin dalle estremità della città. ");
INSERT INTO ita1885_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","E chiamarono Lot, e gli dissero: Ove son quegli uomini che son venuti a te questa notte? menaceli fuori, acciocchè noi li conosciamo. ");
INSERT INTO ita1885_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","E Lot uscì fuori a loro, in su la porta, e si serrò l'uscio dietro. ");
INSERT INTO ita1885_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","E disse: Deh! fratelli miei, non fate male. ");
INSERT INTO ita1885_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ecco, ora io ho due figliuole che non hanno conosciuto uomo; deh! lasciate che io ve le meni fuori, e fate loro come vi piacerà; solo non fate nulla a questi uomini; perciocchè per questo son venuti all'ombra del mio coperto. ");
INSERT INTO ita1885_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ma essi gli dissero: Fatti in là. Poi dissero: Quest'uno è venuto qua per dimorarvi come straniere, e pur fa il giudice! Ora noi faremo peggio a te che a loro. Fecero adunque gran forza a quell'uomo Lot, e si accostarono per romper l'uscio. ");
INSERT INTO ita1885_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","E quegli uomini stesero le mani, e ritrassero Lot a loro, dentro alla casa; poi serrarono l'uscio. ");
INSERT INTO ita1885_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","E percossero d'abbarbaglio gli uomini ch'erano alla porta della casa, dal minore al maggiore; onde essi si stancarono, per trovar la porta. ");
INSERT INTO ita1885_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","E quegli uomini dissero a Lot: Chi de' tuoi è ancora qui? fa' uscir di questo luogo generi, figliuoli e figliuole, e chiunque è de' tuoi in questa città. ");
INSERT INTO ita1885_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Perciocchè noi di presente distruggeremo questo luogo; perchè il grido loro è grande nel cospetto del Signore; e il Signore ci ha mandati per distruggerlo. ");
INSERT INTO ita1885_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lot adunque uscì fuori, e parlò a' suoi generi, che doveano prender le sue figliole, e disse loro: Levatevi, uscite di questo luogo; perciocchè il Signore di presente distruggerà questa città. Ma parve loro ch'egli si facesse beffe. ");
INSERT INTO ita1885_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","E, come l'alba cominciò ad apparire, gli Angeli sollecitarono Lot, dicendo: Levati, prendi la tua moglie, e le tue due figliuole che qui si ritrovano; che talora tu non perisca nell'iniquità della città. ");
INSERT INTO ita1885_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ed egli s'indugiava; ma quegli uomini presero lui, la sua moglie e le sue due figliuole, per la mano (perciocchè il Signore voleva risparmiarlo), e lo fecero uscire, e lo misero fuor della città. ");
INSERT INTO ita1885_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","E quando li ebber fatti uscir fuori, il Signore disse: Scampa sopra l'anima tua; non riguardare indietro, e non fermarti in tutta la pianura; scampa verso il monte, che talora tu non perisca. ");
INSERT INTO ita1885_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","E Lot disse loro: Deh! no, Signore. ");
INSERT INTO ita1885_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ecco, ora il tuo servitore ha trovato grazia appo te, e tu hai usata gran benignità in ciò che hai fatto verso me, conservando in vita la mia persona; ma io non potrò scampar verso il monte, che il male non mi giunga, onde io morrò. ");
INSERT INTO ita1885_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Deh! ecco, questa città è vicina, per rifuggirmici, ed è poca cosa; deh! lascia che io mi salvi là (non è ella poca cosa?), e la mia persona resterà in vita. ");
INSERT INTO ita1885_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ed egli gli disse: Ecco, io ti ho esaudito eziandio in questa cosa, per non sovvertir quella città, della quale tu hai parlato. ");
INSERT INTO ita1885_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Affrettati, scampa là; perciocchè io non potrò far nulla fin che tu non vi sii arrivato. Perciò quella città è stata nominata Soar. ");
INSERT INTO ita1885_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Il sole si levava in su la terra, quando Lot arrivò a Soar. ");
INSERT INTO ita1885_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","E il Signore fece piover dal cielo sopra Sodoma e sopra Gomorra, solfo e fuoco, dal Signore. ");
INSERT INTO ita1885_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","E sovvertì quelle città e tutta la pianura, e tutti gli abitanti di esse città, e le piante della terra. ");
INSERT INTO ita1885_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Or la moglie di Lot riguardò di dietro a lui, e divenne una statua di sale. ");
INSERT INTO ita1885_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ed Abrahamo levatosi la mattina a buon'ora, andò al luogo ove si era fermato davanti al Signore. ");
INSERT INTO ita1885_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","E, riguardando verso Sodoma e Gomorra e verso tutto il paese della pianura, vide che dalla terra saliva un fumo simile ad un fumo di fornace. ");
INSERT INTO ita1885_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Così avvenne che, quando Iddio distrusse le città della pianura, egli si ricordò di Abrahamo, e mandò Lot fuori di mezzo la sovversione, mentre egli sovvertiva le città nelle quali Lot era dimorato. ");
INSERT INTO ita1885_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","POI Lot salì di Soar, e dimorò sul monte, insieme con le sue due figliuole (perciocchè egli temeva di dimorare in Soar), e dimorò in una spelonca, egli e le sue due figliuole. ");
INSERT INTO ita1885_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","E la maggiore disse alla minore: Nostro padre è vecchio, e non vi è più uomo alcuno sulla terra ch'entri da noi, secondo l'usanza di tutta la terra. ");
INSERT INTO ita1885_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Vieni, diam da bere del vino a nostro padre, e giaciamoci con lui; e così di nostro padre conserveremo in vita alcuna progenie. ");
INSERT INTO ita1885_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Quell'istessa notte adunque diedero a ber del vino al loro padre; e la maggiore venne, e si giacque con suo padre, il quale non si avvide nè quando ella si pose a giacere, nè quando si levò. ");
INSERT INTO ita1885_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","E il giorno seguente, la maggiore disse alla minore: Ecco, la notte passata io son giaciuta con mio padre; diamogli a ber del vino ancora questa notte; poi va', e giaciti con lui; così di nostro padre conserveremo in vita alcuna progenie. ");
INSERT INTO ita1885_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Quella notte adunque diedero ancora a ber del vino al padre loro, e la minore si levò, e si giacque con lui; ed egli non si avvide nè quando ella si pose a giacere, nè quando si levò. ");
INSERT INTO ita1885_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","E le due figliuole di Lot concepettero di lor padre. ");
INSERT INTO ita1885_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","E la maggiore partorì un figliuolo, al quale pose nome Moab. Esso è il padre de' Moabiti, che son fino ad oggi. ");
INSERT INTO ita1885_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","E la minore partorì anch'essa un figliuolo, al quale pose nome Ben-ammi. Esso è il padre degli Ammoniti, che son fino ad oggi. ");
INSERT INTO ita1885_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","ED Abrahamo se ne andò di là verso il paese del Mezzodì, e dimorò fra Cades e Sur; ed abitò come forestiere in Gherar. ");
INSERT INTO ita1885_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ed Abrahamo disse della sua moglie Sara: Ell'è mia sorella. Ed Abimelecco, re di Gherar, mandò a torla. ");
INSERT INTO ita1885_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ma Iddio venne ad Abimelecco in sogno di notte, e gli disse: Ecco, tu sei morto, per cagion della donna che tu hai tolta, essendo ella maritata ad un marito. ");
INSERT INTO ita1885_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","(Or Abimelecco non se l'era accostato.) Ed egli disse: Signore, uccideresti tu tutta una nazione, ed anche giusta? ");
INSERT INTO ita1885_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Non mi ha egli detto: Ell'è mia sorella? ed essa ancora ha detto: Egli è mio fratello; io ho fatto questo con integrità del mio cuore, e con innocenza delle mie mani. ");
INSERT INTO ita1885_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","E Iddio gli disse in sogno: Anch'io so che tu hai fatto questo con integrità del tuo cuore; onde io ancora ti ho impedito di peccar contro a me; perciò non ti ho permesso di toccarla. ");
INSERT INTO ita1885_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ora dunque restituisci la moglie a quest'uomo; perciocchè egli è profeta; ed egli pregherà per te, e tu viverai; ma, se tu non la restituisci, sappi che per certo morrai, tu e tutti i tuoi. ");
INSERT INTO ita1885_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ed Abimelecco, levatosi la mattina, chiamò tutti i suoi servitori, e raccontò in lor presenza tutte queste cose; e quegli uomini temettero grandemente. ");
INSERT INTO ita1885_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Ed Abimelecco chiamò Abrahamo, e gli disse: Che cosa ci hai tu fatto? e di che ti ho io offeso, che tu abbi fatto venir sopra me, e sopra il mio regno, un gran peccato? Tu hai fatto inverso me cose che non si convengono fare. ");
INSERT INTO ita1885_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimelecco disse ancora ad Abrahamo: A che hai tu riguardato, facendo questo? ");
INSERT INTO ita1885_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ed Abrahamo disse: Io l'ho fatto, perciocchè io diceva: E' non vi è pure alcun timor di Dio in questo luogo; e mi uccideranno per cagion della mia moglie. ");
INSERT INTO ita1885_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","E pure anche certo ella è mia sorella, figliuola di mio padre, ma non già figliuola di mia madre; ed è divenuta mia moglie. ");
INSERT INTO ita1885_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Or facendomi Iddio andar qua e là, fuor della casa di mio padre, io le ho detto: Questo è il favor che tu mi farai: dovunque noi giungeremo, di' di me: Egli è mio fratello. ");
INSERT INTO ita1885_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ed Abimelecco prese pecore, buoi, servi e serve, e le diede ad Abrahamo, e gli restituì Sara sua moglie. ");
INSERT INTO ita1885_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ed Abimelecco disse: Ecco, il mio paese è davanti a te, dimora dovunque ti piacerà. ");
INSERT INTO ita1885_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ed a Sara disse: Ecco, io ho donati mille sicli d'argento al tuo fratello; ecco, egli ti è coperta d'occhi appo tutti coloro che son teco. E con tutto ciò, ella fu ripresa. ");
INSERT INTO ita1885_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Ed Abrahamo fece orazione a Dio; e Iddio guarì Abimelecco, e la sua moglie, e le sue serve; e poterono partorire. ");
INSERT INTO ita1885_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Perciocchè il Signore avea del tutto serrata ogni matrice alla casa di Abimelecco, per cagion di Sara moglie di Abrahamo. ");
INSERT INTO ita1885_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","E IL Signore visitò Sara, come avea detto. E il Signore fece a Sara come ne avea parlato. ");
INSERT INTO ita1885_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Ella adunque concepette, e partorì un figliuolo ad Abrahamo, nella vecchiezza di esso, al termine che Iddio gli aveva detto. ");
INSERT INTO ita1885_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ed Abrahamo pose nome Isacco al suo figliuolo che gli era nato, il qual Sara gli avea partorito. ");
INSERT INTO ita1885_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ed Abrahamo circoncise Isacco suo figliuolo, nell'età di otto giorni, come Iddio gli avea comandato. ");
INSERT INTO ita1885_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Or Abrahamo era d'età di cent'anni, quando Isacco suo figliuolo gli nacque. ");
INSERT INTO ita1885_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","E Sara disse: Iddio mi ha fatto di che ridere; chiunque l'intenderà riderà meco. ");
INSERT INTO ita1885_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Disse ancora: Chi avrebbe detto ad Abrahamo che Sara allatterebbe figliuoli? conciossiachè io gli abbia partorito un figliuolo nella sua vecchiezza. ");
INSERT INTO ita1885_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Poi, essendo il fanciullo cresciuto, fu spoppato; e nel giorno che Isacco fu spoppato, Abrahamo fece un gran convito. ");
INSERT INTO ita1885_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","E Sara vide che il figliuolo di Agar Egizia, il quale ella avea partorito ad Abrahamo, si faceva beffe. ");
INSERT INTO ita1885_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Onde ella disse ad Abrahamo: Caccia via questa serva e il suo figliuolo; perciocchè il figliuol di questa serva non ha da essere erede col mio figliuolo Isacco. ");
INSERT INTO ita1885_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","E ciò dispiacque grandemente ad Abrahamo, per amor del suo figliuolo. ");
INSERT INTO ita1885_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ma Iddio gli disse: Non aver dispiacere per lo fanciullo, nè per la tua serva; acconsenti a Sara in tutto quello ch'ella ti dirà; perciocchè in Isacco ti sarà nominata progenie. ");
INSERT INTO ita1885_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ma pure io farò che anche il figliuolo di questa serva diventerà una nazione; perciocchè egli è tua progenie. ");
INSERT INTO ita1885_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Abrahamo adunque, levatosi la mattina a buon'ora, prese del pane, ed un bariletto d'acqua, e diede ciò ad Agar, metendoglielo in ispalla; le diede ancora il fanciullo, e la mandò via. Ed ella si partì, e andò errando per lo deserto di Beerseba. ");
INSERT INTO ita1885_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ed essendo l'acqua del bariletto venuta meno, ella gittò il fanciullo sotto un arboscello. ");
INSERT INTO ita1885_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ed ella se ne andò, e si pose a sedere dirimpetto, di lungi intorno ad una tratta d'arco; perciocchè ella diceva: Ch'io non vegga morire il fanciullo; e sedendo così dirimpetto, alzò la voce e pianse. ");
INSERT INTO ita1885_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","E Iddio udì la voce del fanciullo, e l'Angelo di Dio chiamò Agar dal cielo, e le disse: Che hai, Agar? non temere; perciocchè Iddio ha udita la voce del fanciullo, là dove egli è. ");
INSERT INTO ita1885_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Levati, togli il fanciullo, e fortificati ad averne cura; perciocchè io lo farò divenire una gran nazione. ");
INSERT INTO ita1885_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","E Iddio le aperse gli occhi, ed ella vide un pozzo d'acqua, ed andò, ed empiè il bariletto d'acqua, e diè bere al fanciullo. ");
INSERT INTO ita1885_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","E Iddio fu con quel fanciullo, ed egli divenne grande, e dimorò nel deserto, e fu tirator d'arco. ");
INSERT INTO ita1885_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ed egli dimorò nel deserto di Paran; e sua madre gli prese una moglie del paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","OR avvenne in quel tempo che Abimelecco con Picol, capo del suo esercito, parlò ad Abrahamo, dicendo: Iddio è teco in tutto ciò che tu fai. ");
INSERT INTO ita1885_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ora dunque giurami qui per lo Nome di Dio, se tu menti a me, od al mio figliuolo, od al mio nipote; che tu userai la medesima benignità inverso me, ed inverso il paese dove tu sei dimorato come forestiere, la quale io ho usata inverso te. ");
INSERT INTO ita1885_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ed Abrahamo disse: Sì, io il giurerò. ");
INSERT INTO ita1885_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ma Abrahamo si querelò ad Abimelecco, per cagion di un pozzo d'acqua, che i servitori di Abimelecco aveano occupato per forza. ");
INSERT INTO ita1885_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ed Abimelecco disse: Io non so chi abbia fatto questo; nè anche tu me l'hai fatto assapere, ed io non ne ho inteso nulla, se non oggi. ");
INSERT INTO ita1885_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ed Abrahamo prese pecore e buoi, e li diede ad Abimelecco, e fecero amendue lega insieme. ");
INSERT INTO ita1885_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Poi Abrahamo mise da parte sette agnelle della greggia. ");
INSERT INTO ita1885_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ed Abimelecco disse ad Abrahamo: Che voglion dire qui queste sette agnelle che tu hai poste da parte? ");
INSERT INTO ita1885_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ed egli disse: Che tu prenderai queste sette agnelle dalla mia mano; acciocchè questo sia per testimonianza che io ho cavato questo pozzo. ");
INSERT INTO ita1885_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Perciò egli chiamò quel luogo Beerseba; perchè amendue vi giurarono. ");
INSERT INTO ita1885_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Fecero adunque lega insieme in Beerseba. Poi Abimelecco con Picol, capo del suo esercito, si levò, ed essi se ne ritornarono nel paese de' Filistei. ");
INSERT INTO ita1885_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ed Abrahamo piantò un bosco in Beerseba, e quivi invocò il Nome del Signore Iddio eterno. ");
INSERT INTO ita1885_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ed Abrahamo dimorò come forestiere nel paese de' Filistei molti giorni. ");
INSERT INTO ita1885_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","DOPO queste cose, avvenne che Iddio provò Abrahamo, e gli disse: Abrahamo. Ed egli disse: Eccomi. ");
INSERT INTO ita1885_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","E Iddio gli disse: Prendi ora il tuo figliuolo, il tuo unico, il qual tu ami, cioè, Isacco; e vattene nella contrada di Moria, ed offeriscilo quivi in olocausto, sopra l'uno di que' monti, il quale io ti dirò. ");
INSERT INTO ita1885_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Abrahamo adunque, levatosi la mattina a buon'ora, mise il basto al suo asino, e prese due suoi servitori seco, ed Isacco, suo figliuolo; e schiappate delle legne per l'olocausto, si levò, e se ne andò al luogo il quale Iddio gli avea detto. ");
INSERT INTO ita1885_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Al terzo giorno, Abrahamo alzò gli occhi, e vide quel luogo di lontano. ");
INSERT INTO ita1885_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","E disse a' suoi servitori: Restate qui con l'asino; ed io e il fanciullo andremo fin colà, ed adoreremo; poi ritorneremo a voi. ");
INSERT INTO ita1885_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ed Abrahamo prese le legne per l'olocausto, e le mise addosso ad Isacco, suo figliuolo; e prese in mano il fuoco e il coltello; e se ne andarono amendue insieme. ");
INSERT INTO ita1885_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ed Isacco disse ad Abrahamo suo padre: Padre mio. Ed egli rispose: Eccomi, figliuol mio. Ed Isacco disse: Ecco il fuoco e le legne; ma dove è l'agnello per l'olocausto? ");
INSERT INTO ita1885_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ed Abrahamo disse: Figliuol mio, Iddio si provvederà d'agnello per l'olocausto. Ed essi se ne andarono amendue insieme. ");
INSERT INTO ita1885_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","E giunsero al luogo il quale Iddio avea detto ad Abrahamo; ed egli edificò quivi un altare, ed ordinò le legne; e legò Isacco suo figliuolo, e lo mise su l'altare disopra alle legne. ");
INSERT INTO ita1885_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ed Abrahamo stese la mano, e prese il coltello per iscannare il suo figliuolo. ");
INSERT INTO ita1885_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ma l'Angelo del Signore gli gridò dal cielo, e disse: Abrahamo, Abrahamo. Ed egli disse: Eccomi. ");
INSERT INTO ita1885_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","E l'Angelo gli disse: Non metter la mano addosso al fanciullo, e non fargli nulla; perciocchè ora conosco che tu temi Iddio, poichè tu non mi hai dinegato il tuo figliuolo, il tuo unico. ");
INSERT INTO ita1885_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ed Abrahamo alzò gli occhi, e riguardò; ed ecco un montone dietro a lui, rattenuto per le corna ad un cespuglio. Ed Abrahamo andò, e prese quel montone, e l'offerse in olocausto, in luogo del suo figliuolo. ");
INSERT INTO ita1885_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ed Abrahamo nominò quel luogo: Il Signor provvederà. Che è quel che oggi si dice: Nel monte del Signore sarà provveduto. ");
INSERT INTO ita1885_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","E l'Angelo del Signore gridò ad Abrahamo dal cielo, la secondo volta. ");
INSERT INTO ita1885_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","E disse: Io giuro per me stesso, dice il Signore, che, poichè tu hai fatto questo e non mi hai dinegato il tuo figliuolo, il tuo unico; ");
INSERT INTO ita1885_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","io del tutto ti benedirò, e farò moltiplicar grandemente la tua progenie, tal che sarà come le stelle del cielo, e come la rena che è in sul lido del mare; e la tua progenie possederà la porta de' suoi nemici. ");
INSERT INTO ita1885_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","E tutte le nazioni della terra saranno benedette nella tua progenie; perciocchè tu hai ubbidito alla mia voce. ");
INSERT INTO ita1885_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Poi Abrahamo se ne ritornò a' suoi servitori. E si levarono, e se ne andarono insieme in Beerseba, ove Abrahamo dimorava. ");
INSERT INTO ita1885_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","E DOPO queste cose, fu rapportato ad Abrahamo: Ecco, Milca ha anch'essa partoriti figliuoli a Nahor, tuo fratello. ");
INSERT INTO ita1885_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Questi furono: Us primogenito di esso, e Buz suo fratello, e Chemuel padre di Aram, ");
INSERT INTO ita1885_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","e Chesed, ed Hazo, e Pildas, ed Idlaf, e Betuel. (Or Betuel generò Rebecca.) ");
INSERT INTO ita1885_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Milca partorì questi otto a Nahor fratello di Abrahamo. ");
INSERT INTO ita1885_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","E la concubina di esso, il cui nome era Reuma, partorì anch'essa Tebach, e Gaham, e Tahas, e Maaca. ");
INSERT INTO ita1885_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","OR la vita di Sara fu di cenventisett'anni. Questi furono gli anni della vita di Sara. ");
INSERT INTO ita1885_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","E Sara morì in Chiriat-Arba, ch'è Hebron, nel paese di Canaan, ed Abrahamo entrò, per far duolo di Sara, e per piangerla. ");
INSERT INTO ita1885_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Poi Abrahamo si levò d'appresso al suo morto, e parlò a' figliuoli di Het, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Io sono straniere ed avveniticcio appresso di voi; datemi la possessione di una sepoltura appo voi; acciocchè io seppellisca il mio morto, e mel levi d'innanzi. ");
INSERT INTO ita1885_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","E i figliuoli di Het risposero ad Abrahamo, dicendogli: ");
INSERT INTO ita1885_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Signor mio, ascoltaci: Tu sei per mezzo noi un principe divino; seppellisci il tuo morto nella più scelta delle nostre sepolture; niuno di noi ti rifiuterà la sua sepoltura, che tu non vi seppellisca il tuo morto. ");
INSERT INTO ita1885_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ed Abrahamo si levò, e s'inchinò al popolo del paese, a' figliuoli di Het; e parlò con loro, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Se voi avete nell'animo che io seppellisca il mio morto, e mel levi d'innanzi, ascoltatemi: Intercedete per me appo Efron, figliuolo di Sohar; ");
INSERT INTO ita1885_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","che mi dia la spelonca di Macpela, che è sua, la quale è nell'estremità del suo campo; che me la dia per lo suo prezzo intiero, per possession di sepoltura fra voi. ");
INSERT INTO ita1885_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Or Efron sedeva per mezzo i figliuoli di Het. Ed Efron Hitteo rispose ad Abrahamo, in presenza de' figliuoli di Het, di tutti coloro ch'entravano nella porta della sua città, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","No, signor mio; ascoltami: Io ti dono il campo; ti dono ancora la spelonca ch'è in esso; io te ne fo un dono, in presenza de' figliuoli del mio popolo; seppelliscivi il tuo morto. ");
INSERT INTO ita1885_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ed Abrahamo s'inchinò al popolo del paese; ");
INSERT INTO ita1885_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","e parlò ad Efron, in presenza del popolo del paese, dicendo: Anzi se così ti piace, ascoltami, ti prego: Io darò i danari del campo; prendili da me, ed io vi seppellirò il mio morto. ");
INSERT INTO ita1885_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ed Efron rispose ad Abrahamo, dicendogli: ");
INSERT INTO ita1885_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Signor mio, ascoltami: Fra me e te che cosa è una terra di quattrocento sicli d'argento? seppelliscivi pure il tuo morto. ");
INSERT INTO ita1885_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ed Abrahamo acconsentì ad Efron, e gli pagò i danari ch'egli gli avea detto, in presenza de' figliuoli di Het; cioè quattrocento sicli d'argento, correnti fra' mercatanti. ");
INSERT INTO ita1885_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Così l'acquisto del campo di Efron, il quale è in Macpela, ch'è dirimpetto a Mamre, insieme con la spelonca che è in esso, e con tutti gli alberi ch'erano in esso campo, in tutti i suoi confini attorno attorno, ");
INSERT INTO ita1885_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","fu fermato ad Abrahamo, in presenza de' figliuoli di Het, fra tutti coloro ch'entravano nella porta della città di esso. ");
INSERT INTO ita1885_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","E dopo ciò, Abrahamo seppellì Sara, sua moglie, nella spelonca del campo di Macpela, ch'è dirimpetto a Mamre, ch'è Hebron, nel paese di Canaan. ");
INSERT INTO ita1885_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Così l'acquisto di quel campo, e della spelonca ch'è in esso, fu fermato ad Abrahamo, per possession di sepoltura, dai figliuoli di Het. ");
INSERT INTO ita1885_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","OR Abrahamo, essendo vecchio ed attempato, ed avendolo il Signore benedetto in ogni cosa, ");
INSERT INTO ita1885_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","disse ad un suo servitore, ch'era il più vecchio di casa sua, il quale avea il governo di tutte le cose sue: Deh! metti la tua mano sotto la mia coscia; ");
INSERT INTO ita1885_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ed io ti farò giurar per lo Signore Iddio del cielo, ed Iddio della terra, che tu non prenderai al mio figliuolo moglie delle figliuole de' Cananei, fra' quali io dimoro. ");
INSERT INTO ita1885_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ma che tu andrai al mio paese, ed al mio parentado, e di esso prenderai moglie al mio figliuolo Isacco. ");
INSERT INTO ita1885_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","E quel servitore gli disse: Forse non aggradirà a quella donna di venir dietro a me in questo paese; mi converrà egli del tutto rimenare il tuo figliuolo nel paese onde tu sei uscito? ");
INSERT INTO ita1885_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ed Abrahamo gli disse: Guardati che tu non rimeni là il mio figliuolo. ");
INSERT INTO ita1885_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Il Signore Iddio del cielo, il qual mi ha preso di casa di mio padre, e del mio natio paese, e mi ha parlato, e mi ha giurato, dicendo: Io darò alla tua progenie questo paese; esso manderà l'Angelo suo davanti a te, e tu prenderai di là moglie al mio figliuolo. ");
INSERT INTO ita1885_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","E se non aggrada alla donna di venir dietro a te, tu sarai sciolto di questo giuramento che io ti fo fare; sol non rimenar là il mio figliuolo. ");
INSERT INTO ita1885_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","E il servitore pose la sua mano sotto la coscia di Abrahamo, suo signore, e gli giurò intorno a quest'affare. ");
INSERT INTO ita1885_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","E il servitore prese dieci cammelli, di quei del suo signore, e si partì, portando seco di ogni sorta di beni del suo signore; e, messosi in viaggio, andò in Mesopotamia, alla città di Nahor. ");
INSERT INTO ita1885_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","E, fatti posare in su le ginocchia i cammelli fuor della città, presso ad un pozzo d'acqua, in su la sera, al tempo ch'escono fuori quelle che vanno ad attigner l'acqua, disse: ");
INSERT INTO ita1885_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","O Signore Iddio di Abrahamo mio signore, dammi, ti prego, ch'io scontri oggi buono incontro; ed usa benignità inverso Abrahamo mio signore. ");
INSERT INTO ita1885_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ecco, io mi fermerò presso alla fonte d'acqua, e le figliuole della gente della città usciranno per attigner dell'acqua. ");
INSERT INTO ita1885_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Avvenga adunque, che la fanciulla, la quale, dicendole io: Deh! abbassa la tua secchia, acciocchè io bea; mi dirà: Bevi, ed anche darò a bere a' tuoi cammelli; essa sia quella che tu hai preparata ad Isacco, tuo servitore; ed in ciò conoscerò che tu avrai usata benignità verso il mio signore. ");
INSERT INTO ita1885_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ed avvenne che, avanti ch'egli avesse finito di parlare, ecco Rebecca, figliuola di Betuel, figliuol di Milca, moglie di Nahor, fratello di Abrahamo, usciva fuori, avendo la sua secchia in su la spalla. ");
INSERT INTO ita1885_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","E la fanciulla era di molto bello aspetto, vergine, ed uomo alcuno non l'avea conosciuta. Ed ella scese alla fonte, ed empiè la sua secchia, e se ne ritornava. ");
INSERT INTO ita1885_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","E quel servitore le corse incontro, e le disse: Deh! dammi a bere un poco d'acqua della tua secchia. ");
INSERT INTO ita1885_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ed ella disse: Bevi, signor mio. E prestamente, calatasi la secchia in mano, gli diè da bere. ");
INSERT INTO ita1885_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","E, dopo avergli dato da bere a sufficienza, disse: Io ne attignerò eziandio per li tuoi cammelli, finchè abbiano bevuto a sufficienza. ");
INSERT INTO ita1885_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","E prestamente votò la sua secchia nell'abbeveratoio, e corse di nuovo al pozzo per attignere; e attinse per tutti i cammelli di esso. ");
INSERT INTO ita1885_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","E quell'uomo stupiva di lei, stando tacito a considerare se il Signore avea fatto prosperare il suo viaggio, o no. ");
INSERT INTO ita1885_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","E quando i cammelli ebber finito di bere, quell'uomo prese un monile d'oro, di peso d'un mezzo siclo, e gliel mise disopra al naso; e un par di maniglie d'oro di peso di dieci sicli, e gliele mise in su le mani. ");
INSERT INTO ita1885_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","E le disse: Di chi sei tu figliuola? deh! dichiaramelo. Evvi in casa di tuo padre luogo per albergarci? ");
INSERT INTO ita1885_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ed ella rispose: Io son figliuola di Betuel, figliuolo di Milca; il quale ella partorì a Nahor. ");
INSERT INTO ita1885_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Gli disse ancora: E' vi è strame e pastura assai appo noi, ed anche luogo da albergarvi. ");
INSERT INTO ita1885_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","E quell'uomo s'inchinò, e adorò il Signore. ");
INSERT INTO ita1885_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","E disse: Benedetto sia il Signore Iddio di Abrahamo mio signore, il qual non ha dismessa la sua benignità e lealtà inverso il mio signore; e quant'è a me, il Signore mi ha condotto per la diritta via in casa de' fratelli del mio signore. ");
INSERT INTO ita1885_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","E la fanciulla corse, e rapportò quelle cose in casa di sua madre. ");
INSERT INTO ita1885_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Or Rebecca avea un fratello, il cui nome era Labano; costui corse fuori a quell'uomo, alla fonte. ");
INSERT INTO ita1885_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Come adunque egli ebbe veduto quel monile, e quelle maniglie nelle mani della sua sorella; e come ebbe intese le parole di Rebecca sua sorella, che dicea: Quell'uomo mi ha così parlato; egli se ne venne a quell'uomo; ed ecco, egli se ne stava presso de' cammelli, appresso alla fonte. ");
INSERT INTO ita1885_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ed egli gli disse: Entra, benedetto dal Signore; perchè te ne stai fuori? io ho pure apparecchiata la casa, e il luogo per i cammelli. ");
INSERT INTO ita1885_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","E quell'uomo entrò dentro la casa, e Labano scaricò i cammelli, e diede loro dello strame e della pastura; parimente recò dell'acqua per lavare i piedi a quell'uomo, ed a quelli che erano con lui. ");
INSERT INTO ita1885_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Poi gli fu posto avanti da mangiare; ma egli disse: Io non mangerò, finchè io non abbia detto ciò che ho da dire. Ed esso gli disse: Parla. ");
INSERT INTO ita1885_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ed egli disse: Io son servitore di Abrahamo. ");
INSERT INTO ita1885_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Ora, il Signore ha grandemente benedetto il mio signore, ed egli è divenuto grande; e il Signore gli ha dato pecore, e buoi, ed oro, ed argento, e servi, e serve, e cammelli, ed asini. ");
INSERT INTO ita1885_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","E Sara, moglie del mio signore, dopo esser divenuta vecchia gli ha partorito un figliuolo, al quale egli ha dato tutto ciò ch'egli ha. ");
INSERT INTO ita1885_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","E il mio signore mi ha fatto giurare, dicendo: Non prender moglie al mio figliuolo delle figliuole de' Cananei, nel cui paese io dimoro. ");
INSERT INTO ita1885_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Anzi, va' alla casa di mio padre, ed alla mia nazione, e prendi moglie al mio figliuolo. ");
INSERT INTO ita1885_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ed io ho detto al mio signore: Forse quella donna non vorrà venirmi dietro. ");
INSERT INTO ita1885_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ed egli mi ha detto: Il Signore, nel cui cospetto io son camminato, manderà il suo Angelo teco, e prospererà il tuo viaggio, e tu prenderai moglie al mio figliuolo, della mia nazione, e della casa di mio padre. ");
INSERT INTO ita1885_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Allora sarai sciolto del giuramento che io ti fo fare; quando sarai andato alla mia nazione, se essi non te l'avranno voluta dare, allora sarai sciolto del giuramento che io ti fo fare. ");
INSERT INTO ita1885_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Essendo adunque oggi giunto alla fonte, io dissi: Signore Iddio di Abrahamo mio signore, se pur ti piace prosperare il viaggio che io ho impreso; ");
INSERT INTO ita1885_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ecco, io mi fermerò presso a questa fontana di acqua; avvenga adunque, che la vergine che uscirà per attignere, la quale, dicendole io: Deh! dammi da bere un poco d'acqua della tua secchia; ");
INSERT INTO ita1885_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","mi dirà: Bevi pure; ed anche attignerò per i tuoi cammelli; essa sia la moglie che il Signore ha preparata al figliuolo del mio signore. ");
INSERT INTO ita1885_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Avanti che io avessi finito di parlare fra me stesso, ecco, Rebecca uscì fuori, avendo la sua secchia in su la spalla; e scese alla fontana, ed attinse. Ed io le dissi: Deh! dammi da bere. ");
INSERT INTO ita1885_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ed ella, calatasi prestamente la sua secchia d'addosso, mi disse: Bevi; ed anche darò da bere a' tuoi cammelli. Ed io bevvi, ed ella diede ancora da bere a' cammelli. ");
INSERT INTO ita1885_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ed io la domandai, e le dissi: Di chi sei tu figliuola? Ed ella mi disse: Io son figliuola di Betuel, figliuolo di Nahor, il quale Milca gli partorì. Allora io le posi quel monile disopra al naso, e quelle maniglie in su le mani. ");
INSERT INTO ita1885_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","E m'inchinai, e adorai il Signore, e benedissi il Signore Iddio d'Abrahamo mio signore, il quale mi avea, per la vera via, condotto a prendere al figliuolo del mio signore la figliuola del fratello di esso. ");
INSERT INTO ita1885_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ora dunque, se voi volete usar benignità e lealtà verso il mio signore, significatemelo; se no, fatemelo assapere, ed io mi rivolgerò a destra o a sinistra. ");
INSERT INTO ita1885_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","E Labano e Betuel risposero, e dissero: Questa cosa è proceduta dal Signore; noi non possiamo dirti nè mal nè bene. ");
INSERT INTO ita1885_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ecco Rebecca al tuo comando; prendila, e vattene; e sia moglie del figliuol del tuo signore, siccome il Signore ne ha parlato. ");
INSERT INTO ita1885_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","E quando il servitore di Abrahamo ebbe udite le lor parole, s'inchinò a terra, e adorò il Signore. ");
INSERT INTO ita1885_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Poi quel servitore trasse fuori vasellamenti d'argento e d'oro, e vestimenti; e li diede a Rebecca; ed al fratello, ed alla madre di essa donò cose preziose. ");
INSERT INTO ita1885_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","E poi mangiarono e bevvero, egli, e gli uomini ch'erano con lui, ed albergarono quivi quella notte; e la mattina seguente, essendosi levati, egli disse: Rimandatemi al mio signore. ");
INSERT INTO ita1885_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","E il fratello e la madre di Rebecca dissero: Rimanga la fanciulla con noi alcuni giorni, almeno dieci; poi tu te ne andrai. ");
INSERT INTO ita1885_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ed egli disse loro: Non mi ritardate, poichè il Signore ha fatto prosperare il mio viaggio: datemi commiato, acciocchè io me ne vada al mio signore. ");
INSERT INTO ita1885_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ed essi dissero: Chiamiamo la fanciulla, e domandiamone lei stessa. ");
INSERT INTO ita1885_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Chiamarono adunque Rebecca, e le dissero: Vuoi tu andar con quest'uomo? Ed ella rispose: Sì, io vi andrò. ");
INSERT INTO ita1885_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Così mandarono Rebecca, lor sorella, e la sua balia, col servitore di Abrahamo, e con la sua gente. ");
INSERT INTO ita1885_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","E benedissero Rebecca, e le dissero: Tu sei nostra sorella: moltiplica in mille migliaia; e possegga la tua progenie la porta de' suoi nemici. ");
INSERT INTO ita1885_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","E Rebecca si levò, insieme con le sue serventi, e montarono sopra i cammelli, e andarono dietro a quell'uomo. E quel servitore prese Rebecca, e se ne andò. ");
INSERT INTO ita1885_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Or Isacco se ne ritornava di verso il Pozzo del Vivente che mi vede; perciocchè egli abitava nella contrada del mezzodì. ");
INSERT INTO ita1885_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ed era uscito fuori per fare orazione alla campagna, in sul far della sera. E, alzati gli occhi, riguardò, ed ecco de' cammelli che venivano. ");
INSERT INTO ita1885_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebecca alzò anch'essa gli occhi, e vide Isacco, e si gittò giù d'in sul cammello. ");
INSERT INTO ita1885_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","(Perciocchè avendo detto a quel servitore: Chi è quell'uomo che ci cammina incontro nel campo? egli le avea detto: Egli è il mio signore). E prese un velo, e se ne coprì. ");
INSERT INTO ita1885_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","E il servitore raccontò ad Isacco tutte le cose ch'egli avea fatte. ");
INSERT INTO ita1885_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","E Isacco menò Rebecca nel padiglione di Sara, sua madre; e la prese, ed ella divenne sua moglie, ed egli l'amò. E Isacco si consolò dopo la morte di sua madre. ");
INSERT INTO ita1885_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","ED Abrahamo prese un'altra moglie, il cui nome era Chetura. ");
INSERT INTO ita1885_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ed ella gli partorì Zimran, e Iocsan, e Medan, e Madian, e Isbac, e Sua. ");
INSERT INTO ita1885_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","E Iocsan generò Seba e Dedan. Ed i figliuoli di Dedan furono Assurim, e Letusim, e Leummim. ");
INSERT INTO ita1885_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ed i figliuoli di Madian furono Efa, ed Efer ed Hanoc, ed Abida, ed Eldaa. Tutti questi furono figliuoli di Chetura. ");
INSERT INTO ita1885_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ed Abrahamo donò tutto il suo avere ad Isacco. ");
INSERT INTO ita1885_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ed a' figliuoli delle sue concubine diede doni; e mentre era in vita, li mandò via d'appresso al suo figliuolo Isacco, verso il Levante, nel paese Orientale. ");
INSERT INTO ita1885_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Or il tempo della vita di Abrahamo fu di centosettantacinque anni. ");
INSERT INTO ita1885_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Poi trapassò, e morì in buona vecchiezza, attempato, e sazio di vita: e fu raccolto a' suoi popoli. ");
INSERT INTO ita1885_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","E Isacco ed Ismaele, suoi figliuoli, lo seppellirono nella spelonca di Macpela nel campo di Efron, figliuoli di Sohar Hitteo, ch'è dirimpetto a Mamre; ");
INSERT INTO ita1885_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ch'è il campo che Abrahamo avea comperato da' figliuoli di Het; quivi fu seppellito Abrahamo, e Sara, sua moglie. ");
INSERT INTO ita1885_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ora, dopo che Abrahamo fu morto, Iddio benedisse Isacco, suo figliuolo; e Isacco abitò presso del Pozzo del Vivente che mi vede. ");
INSERT INTO ita1885_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","OR queste sono le generazioni d'Ismaele, figliuolo di Abrahamo, il quale Agar Egizia, serva di Sara, avea partorito ad Abrahamo. ");
INSERT INTO ita1885_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","E questi sono i nomi de' figliuoli d'Ismaele secondo i lor nomi nelle lor generazioni: Il primogenito d'Ismaele fu Nebaiot; poi v'era Chedar, ed Adbeel, e Mibsam; ");
INSERT INTO ita1885_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","e Misma, e Duma, e Massa; ");
INSERT INTO ita1885_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ed Hadar, e Tema, e Ietur, e Nafis, e Chedma. ");
INSERT INTO ita1885_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Questi furono i figliuoli d'Ismaele, e questi sono i lor nomi, nelle lor villate, e nelle lor castella; e furono dodici principi fra' lor popoli. ");
INSERT INTO ita1885_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","E gli anni della vita d'Ismaele furono centrentasette; poi trapassò, e morì, e fu raccolto a' suoi popoli. ");
INSERT INTO ita1885_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ed i suoi figliuoli abitarono da Havila fin a Sur, ch'è dirimpetto all'Egitto, traendo verso l'Assiria. Il paese di esso gli scadde dirimpetto a tutti i suoi fratelli. ");
INSERT INTO ita1885_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","E QUESTE sono le generazioni d'Isacco, figliuolo di Abrahamo: ");
INSERT INTO ita1885_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Abrahamo generò Isacco. Ed Isacco era d'età di quarant'anni, quando prese per moglie Rebecca, figliuola di Betuel, Sirio, da Paddanaram, e sorella di Labano, Sirio. ");
INSERT INTO ita1885_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","E Isacco fece orazione al Signore per la sua moglie; perciocchè ella era sterile: e il Signore l'esaudì; e Rebecca sua moglie concepette. ");
INSERT INTO ita1885_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ed i figliuoli si urtavano l'un l'altro nel suo seno. Ed ella disse: Se così è, perchè sono io in vita? E andò a domandarne il Signore. ");
INSERT INTO ita1885_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","E il Signore le disse: Due nazioni sono nel tuo seno; e due popoli diversi usciranno delle tue interiora; e l'un popolo sarà più possente dell'altro, e il maggiore servirà al minore. ");
INSERT INTO ita1885_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","E quando fu compiuto il termine di essa da partorire, ecco, due gemelli erano nel suo seno. ");
INSERT INTO ita1885_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","E il primo uscì fuori, ed era rosso, tutto peloso come un mantel velluto; e gli fu posto nome Esaù. ");
INSERT INTO ita1885_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Appresso uscì il suo fratello, il quale con la mano teneva il calcagno di Esaù; e gli fu posto nome Giacobbe. Or Isacco era d'età di settant'anni, quando ella li partorì. ");
INSERT INTO ita1885_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","ED i fanciulli crebbero; ed Esaù fu uomo intendente della caccia, uomo di campagna; ma Giacobbe fu uomo semplice, che se ne stava ne' padiglioni. ");
INSERT INTO ita1885_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","E Isacco amava Esaù; perciocchè le selvaggine erano di suo gusto; e Rebecca amava Giacobbe. ");
INSERT INTO ita1885_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ora, concendo Giacobbe una minestra, Esaù giunse da' campi, ed era stanco. ");
INSERT INTO ita1885_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ed Esaù disse a Giacobbe: Deh! dammi a mangiare un po' di cotesta minestra rossa; perciocchè io sono stanco; perciò egli fu nominato Edom. ");
INSERT INTO ita1885_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","E Giacobbe gli disse: Vendimi oggi la tua primogenitura. ");
INSERT INTO ita1885_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ed Esaù disse: Ecco, io me ne vo alla morte, che mi gioverà la primogenitura? ");
INSERT INTO ita1885_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","E Giacobbe disse: Giurami oggi che tu me la vendi. Ed Esaù gliel giurò; e vendette la sua primogenitura a Giacobbe. ");
INSERT INTO ita1885_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","E Giacobbe diede ad Esaù del pane, ed una minestra di lenticchie. Ed egli mangiò e bevve; poi si levò e se ne andò. Così Esaù sprezzò la primogenitura. ");
INSERT INTO ita1885_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","OR vi fu fame nel paese, oltre alla prima fame ch'era stata al tempo di Abrahamo. E Isacco se ne andò ad Abimelecco, re de' Filistei, in Gherar. ");
INSERT INTO ita1885_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","E il Signore gli apparve, e gli disse: Non iscendere in Egitto; dimora nel paese che io ti dirò. ");
INSERT INTO ita1885_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Dimora in questo paese, ed io sarò teco, e ti benedirò; perciocchè io darò a te, ed alla tua progenie, tutti questi paesi; ed atterrò ciò che io ho giurato ad Abrahamo tuo padre. ");
INSERT INTO ita1885_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","E moltiplicherò la tua progenie, talchè sarà come le stelle del cielo; e darò alla tua progenie tutti questi paesi; e tutte le nazioni della terra saranno benedette nella tua progenie. ");
INSERT INTO ita1885_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Perciocchè Abrahamo ubbidì alla mia voce ed osservò ciò che io gli avea imposto di osservare, i miei comandamenti, i miei statuti, e le mie leggi. ");
INSERT INTO ita1885_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","E Isacco adunque dimorò in Gherar. ");
INSERT INTO ita1885_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","E le genti del luogo lo domandarono della sua moglie. Ed egli disse: Ella è mia sorella; perciocchè egli temeva di dire: Ella è mia moglie; che talora le genti del luogo non l'uccidessero per cagion di Rebecca; perciocchè ella era di bell'aspetto. ");
INSERT INTO ita1885_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Or avvenne che, dopo ch'egli fu dimorato quivi alquanti giorni, Abimelecco, re de' Filistei, riguardando per la finestra, vide Isacco, che scherzava con Rebecca, sua moglie. ");
INSERT INTO ita1885_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","E Abimelecco chiamò Isacco, e gli disse: Ecco, costei è pur tua moglie; come adunque hai tu detto: Ell'è mia sorella? E Isacco gli disse: Perciocchè io diceva: E' mi convien guardare che io non muoia per cagion d'essa. ");
INSERT INTO ita1885_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","E Abimelecco gli disse: Che cosa è questo che tu ci hai fatto? per poco alcuno del popolo si sarebbe giaciuto con la tua moglie, e così tu ci avresti fatto venire addosso una gran colpa. ");
INSERT INTO ita1885_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","E Abimelecco fece un comandamento a tutto il popolo, dicendo: Chiunque toccherà quest'uomo, o la sua moglie, del tutto sarà fatto morire. ");
INSERT INTO ita1885_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","E Isacco seminò in quel paese; e quell'anno trovò cento per uno. E il Signore lo benedisse. ");
INSERT INTO ita1885_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","E quell'uomo divenne grande, e andò del continuo crescendo, finchè fu sommamente accresciuto. ");
INSERT INTO ita1885_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ed avea gregge di minuto bestiame, ed armenti di grosso, e molta famiglia; e perciò i Filistei lo invidiavano. ");
INSERT INTO ita1885_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Laonde turarono, ed empierono di terra tutti i pozzi che i servitori di suo padre aveano cavati al tempo di Abrahamo. ");
INSERT INTO ita1885_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","E Abimelecco disse ad Isacco: Partiti da noi; perciocchè tu sei divenuto molto più possente di noi. ");
INSERT INTO ita1885_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isacco adunque si partì di là, e tese i padiglioni nella Valle di Gherar, e dimorò quivi. ");
INSERT INTO ita1885_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","E Isacco cavò di nuovo i pozzi d'acqua, che erano stati cavati al tempo di Abrahamo, suo padre, i quali i Filistei aveano turati dopo la morte di Abrahamo; e pose loro gli stessi nomi che suo padre avea lor posti. ");
INSERT INTO ita1885_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","E i servitori d'Isacco cavarono in quella valle, e trovarono quivi un pozzo d'acqua viva. ");
INSERT INTO ita1885_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ma i pastori di Gherar contesero co' pastori d'Isacco, dicendo: Quest'acqua è nostra. Ed esso nominò quel pozzo Esec; perciocchè essi ne aveano mossa briga con lui. ");
INSERT INTO ita1885_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Poi cavarono un altro pozzo, e per quello ancora contesero; laonde Isacco nominò quel pozzo Sitna. ");
INSERT INTO ita1885_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Allora egli si tramutò di là, e cavò un altro pozzo, per lo quale non contesero; ed egli nominò quel pozzo Rehobot; e disse: Ora ci ha pure il Signore allargati, essendo noi moltiplicati in questo paese. ");
INSERT INTO ita1885_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Poi di là salì in Beerseba. ");
INSERT INTO ita1885_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","E il Signore gli apparve in quella stessa notte, e gli disse: Io son l'Iddio di Abrahamo, tuo padre; non temere; perciocchè io son teco, e ti benedirò, e moltiplicherò la tua progenie, per amor di Abrahamo mio servitore. ");
INSERT INTO ita1885_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ed egli edificò quivi un altare, ed invocò il Nome del Signore, e tese quivi i suoi padiglioni; e i suoi servitori cavarono quivi un pozzo. ");
INSERT INTO ita1885_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","E Abimelecco andò a lui da Gherar, insieme con Ahuzat suo famigliare, e con Picol capo del suo esercito. ");
INSERT INTO ita1885_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","E Isacco disse loro: Perchè siete voi venuti a me, poichè mi odiate, e mi avete mandato via d'appresso a voi? ");
INSERT INTO ita1885_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ed essi dissero: Noi abbiamo chiaramente veduto che il Signore è teco; laonde abbiamo detto: Siavi ora giuramento fra noi; fra noi e te, e facciamo lega teco: ");
INSERT INTO ita1885_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Se giammai tu ci fai alcun male; come ancora noi non ti abbiamo toccato; e non ti abbiam fatto se non bene, e ti abbiamo rimandato in pace; tu che ora sei benedetto dal Signore. ");
INSERT INTO ita1885_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ed egli fece loro un convito; ed essi mangiarono e bevvero. ");
INSERT INTO ita1885_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","E, levatisi la mattina seguente a buon'ora, giurarono l'uno all'altro. Poi Isacco li accommiatò; ed essi si partirono da lui amichevolmente. ");
INSERT INTO ita1885_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","In quell'istesso giorno, i servitori d'Isacco vennero, e gli fecero rapporto di un pozzo che aveano cavato; e gli dissero: Noi abbiam trovato dell'acqua. ");
INSERT INTO ita1885_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ed egli pose nome a quel pozzo Siba; perciò quella città è stata nominata Beerseba fino ad oggi. ");
INSERT INTO ita1885_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Or Esaù, essendo d'età di quarant'anni, prese per moglie Iudit, figliuola di Beeri Hitteo; e Basmat, figliuola di Elon Hitteo. ");
INSERT INTO ita1885_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ed esse furono cagione di amaritudine d'animo a Isacco ed a Rebecca. ");
INSERT INTO ita1885_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","OR avvenne che, essendo già invecchiato Isacco, ed essendo gli occhi suoi scurati, sì che non vedeva, chiamò Esaù suo figliuol maggiore, e gli disse: Figliuol mio. Ed egli gli disse: Eccomi. ");
INSERT INTO ita1885_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","E Isacco disse: Ecco, ora io sono invecchiato, e non so il giorno della mia morte. ");
INSERT INTO ita1885_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Deh! prendi ora i tuoi arnesi, il tuo turcasso e il tuo arco; e vattene fuori a' campi, e prendimi qualche cacciagione. ");
INSERT INTO ita1885_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ed apparecchiami alcune vivande saporite, quali io le amo, e portamele, che io ne mangi; acciocchè l'anima mia ti benedica avanti che io muoia. ");
INSERT INTO ita1885_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Or Rebecca stava ad ascoltare, mentre Isacco parlava ad Esaù, suo figliuolo. Esaù adunque andò a' campi per prender qualche cacciagione, e portarla a suo padre. ");
INSERT INTO ita1885_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","E Rebecca parlò a Giacobbe suo figliuolo, e gli disse: Ecco, io ho udito che tuo padre parlava ad Esaù, tuo fratello, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Portami della cacciagione, ed apparecchiami alcun mangiare saporito, acciocchè io ne mangi; ed io ti benedirò nel cospetto del Signore, avanti che io muoia. ");
INSERT INTO ita1885_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ora dunque, figliuol mio, attendi alla mia voce, in ciò che io ti comando. ");
INSERT INTO ita1885_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Vattene ora alla greggia, ed arrecami di là due buoni capretti, ed io ne apparecchierò delle vivande saporite a tuo padre, quali egli le ama. ");
INSERT INTO ita1885_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","E tu le porterai a tuo padre, acciocchè ne mangi, e ti benedica, avanti ch'egli muoia. ");
INSERT INTO ita1885_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","E Giacobbe disse a Rebecca sua madre: Ecco, Esaù mio fratello è uomo peloso, ed io son uomo senza peli. ");
INSERT INTO ita1885_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Per avventura mio padre mi tasterà, e sarò da lui reputato un ingannatore; e così mi farò venire addosso maledizione, e non benedizione. ");
INSERT INTO ita1885_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ma sua madre gli disse: Figliuol mio, la tua maledizione sia sopra me; attendi pure alla mia voce, e va' ed arrecami que' capretti. ");
INSERT INTO ita1885_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Egli adunque andò, e prese que' capretti, e li arrecò a sua madre; e sua madre ne apparecchiò delle vivande saporite, quali il padre di esso le amava. ");
INSERT INTO ita1885_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Poi Rebecca prese i più bei vestimenti di Esaù suo figliuol maggiore, ch'ella avea appresso di sè in casa, e ne vestì Giacobbe suo figliuol minore. ");
INSERT INTO ita1885_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","E con le pelli de' capretti coperse le mani di esso, e il collo ch'era senza peli. ");
INSERT INTO ita1885_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","E diede in mano a Giacobbe suo figliuolo, quelle vivande saporite, e quel pane che avea apparecchiato. ");
INSERT INTO ita1885_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ed egli venne a suo padre, e gli disse: Padre mio. Ed egli disse: Eccomi: chi sei, figliuol mio? ");
INSERT INTO ita1885_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","E Giacobbe disse a suo padre: Io sono Esaù, tuo primogenito; io ho fatto come tu mi dicesti. Deh! levati, assettati, e mangia della mia cacciagione, acciocchè l'anima tua mi benedica. ");
INSERT INTO ita1885_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","E Isacco disse al suo figliuolo: Come ne hai tu così presto trovato, figliuol mio? Ed egli rispose: Perciocchè il Signore Iddio tuo me ne ha fatto scontrare. ");
INSERT INTO ita1885_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","E Isacco disse a Giacobbe: Deh! appressati, figliuol mio, che io ti tasti, per saper se tu sei pure il mio figliuolo Esaù, o no. ");
INSERT INTO ita1885_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Giacobbe adunque si appressò ad Isacco suo padre; e come egli l'ebbe tastato, disse: Cotesta voce è la voce di Giacobbe, ma queste mani son le mani di Esaù. ");
INSERT INTO ita1885_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","E nol riconobbe; perciocchè le sue mani erano pelose, come le mani di Esaù, suo fratello; e lo benedisse. ");
INSERT INTO ita1885_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","E disse: Sei tu pur desso, figliuol mio Esaù? Ed egli disse: Sì, io son desso. ");
INSERT INTO ita1885_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ed egli disse: Recami della cacciagione del mio figliuolo, acciocchè io ne mangi, e che l'anima mia ti benedica. E Giacobbe gliela recò, e Isacco mangiò. Giacobbe ancora gli recò del vino, ed egli bevve. ");
INSERT INTO ita1885_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Poi Isacco suo padre gli disse: Deh! appressati e baciami, figliuol mio. ");
INSERT INTO ita1885_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ed egli si appressò, e lo baciò. E Isacco odorò l'odor dei vestimenti di esso, e lo benedisse; e disse: Ecco l'odor del mio figliuolo, simile all'odor di un campo che il Signore ha benedetto. ");
INSERT INTO ita1885_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Iddio adunque ti dia della rugiada del cielo, E delle grassezze della terra, Ed abbondanza di frumento e di mosto. ");
INSERT INTO ita1885_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Servanti i popoli, Ed inchininsi a te le nazioni; Sii pardrone de' tuoi fratelli, Ed inchininsi a te i figliuoli di tua madre; Sieno maledetti coloro che ti malediranno, E benedetti coloro che ti benediranno. ");
INSERT INTO ita1885_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","E come Isacco ebbe finito di benedir Giacobbe, ed essendo appena Giacobbe uscito d'appresso ad Isacco suo padre, Esaù suo fratello giunse dalla sua caccia. ");
INSERT INTO ita1885_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","E apparecchiò anch'egli delle vivande saporite, e le recò a suo padre, e gli disse: Levisi mio padre, e mangi della cacciagion del suo figliuolo; acciocchè l'anima tua mi benedica. ");
INSERT INTO ita1885_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","E Isacco suo padre gli disse: Chi sei tu? Ed egli disse: Io sono Esaù tuo figliuolo primogenito. ");
INSERT INTO ita1885_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","E Isacco sbigottì di un grandissimo sbigottimento, e disse: Or chi è colui che prese della cacciagione e me la recò; talchè, avanti che tu fossi venuto, io mangiai di tutto ciò ch'egli mi presentò, e lo benedissi? ed anche sarà benedetto. ");
INSERT INTO ita1885_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Quando Esaù ebbe intese le parole di suo padre, fece un grande ed amarissimo gridare: poi disse a suo padre: Benedici me ancora, padre mio. ");
INSERT INTO ita1885_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ed egli gli disse: Il tuo fratello è venuto con inganno, ed ha tolta la tua benedizione. ");
INSERT INTO ita1885_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ed Esaù disse: Non fu egli pur nominato Giacobbe? egli mi ha frodato già due volte; egli mi tolse già la mia primogenitura; ed ecco, ora mi ha tolta la mia benedizione. Poi disse a suo padre: Non mi hai tu riserbata alcuna benedizione? ");
INSERT INTO ita1885_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","E Isacco rispose, e disse ad Esaù: Ecco, io l'ho costituito tuo padrone, e gli ho dati tutti i suoi fratelli per servi; e l'ho fornito di frumento e di mosto; ora dunque, che ti farei io, figliuol mio? ");
INSERT INTO ita1885_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ed Esaù disse a suo padre: Hai tu una sola benedizione, padre mio? benedici ancora me, padre mio. E alzò la voce, e pianse. ");
INSERT INTO ita1885_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","E Isacco suo padre rispose, a gli disse: Ecco, la tua stanza sarà in luoghi grassi di terreno, E per la rugiada del cielo disopra. ");
INSERT INTO ita1885_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","E tu viverai con la tua spada, E servirai al tuo fratello; Ma egli avverrà che, dopo che tu avrai gemuto, Tu spezzerai il suo giogo d'in sul tuo collo. ");
INSERT INTO ita1885_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ed Esaù prese ad odiar Giacobbe, per cagion della benedizione, con la quale suo padre l'avea benedetto; e disse nel suo cuore: I giorni del duolo di mio padre si avvicinano; allora io ucciderò Giacobbe mio fratello. ");
INSERT INTO ita1885_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","E le parole di Esaù, suo figliuol maggiore, furono rapportate a Rebecca; ed ella mandò a chiamar Giacobbe, suo figliuol minore, e gli disse: Ecco, Esaù tuo fratello si consola intorno a te, ch'egli ti ucciderà. ");
INSERT INTO ita1885_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ora dunque, figliuol mio, attendi alla mia voce; levati, fuggitene in Charan, a Labano, mio fratello. ");
INSERT INTO ita1885_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","E dimora con lui alquanto tempo, finchè l'ira del tuo fratello sia racquetata; ");
INSERT INTO ita1885_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","finchè il cruccio del tuo fratello sia racquetato inverso te, e ch'egli abbia dimenticato ciò che tu gli hai fatto; e allora io manderò a farti tornar di là; perchè sarei io orbata di amendue voi in uno stesso giorno? ");
INSERT INTO ita1885_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","E Rebecca disse ad Isacco: La vita mi è noiosa per cagion di queste Hittee; se Giacobbe prende moglie delle figliuole degli Hittei, quali son queste che son delle donne di questo paese, che mi giova il vivere? ");
INSERT INTO ita1885_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ISACCO adunque chiamò Giacobbe, e lo benedisse, e gli comandò, e gli disse: Non prender moglie delle figliuole di Canaan. ");
INSERT INTO ita1885_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Levati, vattene in Paddan-aram, alla casa di Betuel, padre di tua madre, e prenditi di là moglie, delle figliuole di Labano, fratello di tua madre. ");
INSERT INTO ita1885_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","E l'Iddio Onnipotente ti benedica, e ti faccia fruttare, e crescere; talchè tu diventi una raunanza di popoli. ");
INSERT INTO ita1885_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","E ti dia la benedizione di Abrahamo; a te, ed alla tua progenie teco; acciocchè tu possegga il paese dove sei andato peregrinando, il quale Iddio donò ad Abrahamo. ");
INSERT INTO ita1885_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Isacco adunque ne mandò Giacobbe; ed egli si ne andò in Paddan-aram, a Labano, figliuolo di Betuel, Sirio, fratello di Rebecca, madre di Giacobbe e di Esaù. ");
INSERT INTO ita1885_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ed Esaù vide che Isacco avea benedetto Giacobbe, e l'avea mandato in Paddan-aram, acciocchè di là si prendesse moglie; e che, benedicendolo, gli avea vietato e detto: Non prender moglie delle figliuole di Canaan; ");
INSERT INTO ita1885_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","e che Giacobbe avea ubbidito a suo padre ed a sua madre, e se n'era andato in Paddan-aram. ");
INSERT INTO ita1885_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esaù vedeva, oltre a ciò, che le figliuole di Canaan dispiacevano ad Isacco suo padre. ");
INSERT INTO ita1885_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ed egli andò ad Ismaele, e prese per moglie Mahalat, figliuola d'Ismaele, figliuolo di Abrahamo, sorella di Nebaiot; oltre alle sue altre mogli. ");
INSERT INTO ita1885_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","OR Giacobbe partì di Beerseba, ed andando in Charan, ");
INSERT INTO ita1885_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","capitò in un certo luogo, e vi stette la notte; perciocchè il sole era già tramontato, e prese delle pietre del luogo, e le pose per suo capezzale; e giacque in quel luogo. ");
INSERT INTO ita1885_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","E sognò; ed ecco una scala rizzata in terra, la cui cima giungeva al cielo; ed ecco gli angeli di Dio salivano e scendevano per essa. ");
INSERT INTO ita1885_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ed ecco, il Signore stava al disopra di essa. Ed egli disse: Io sono il Signore Iddio di Abrahamo tuo padre, e l'Iddio d'Isacco; io darò a te, ed alla tua progenie, il paese sopra il quale tu giaci. ");
INSERT INTO ita1885_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","E la tua progenie sarà come la polvere della terra; e tu ti spanderai verso occidente, e verso oriente, e verso settentrione, e verso mezzodì; e tutte le nazioni della terra saranno benedette in te, e nella tua progenie. ");
INSERT INTO ita1885_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ed ecco, io son teco, e ti guarderò dovunque tu andrai, e ti ricondurrò in questo paese; perciocchè io non ti abbandonerò, finchè io abbia fatto ciò che ti ho detto. ");
INSERT INTO ita1885_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","E quando Giacobbe si fu risvegliato dal suo sonno, disse: Per certo il Signore è in questo luogo, ed io nol sapeva. ");
INSERT INTO ita1885_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","E temette, e disse: Quanto è spaventevole questo luogo! questo luogo non è altro che la casa di Dio, e questa è la porta del cielo. ");
INSERT INTO ita1885_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","E Giacobbe si levò la mattina a buon'ora, e prese la pietra, la quale avea posta per suo capezzale, e ne fece un piliere, e versò dell'olio sopra la sommità di essa. ");
INSERT INTO ita1885_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","E pose nome a quel luogo Betel; conciossiachè prima il nome di quella città fosse Luz. ");
INSERT INTO ita1885_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","E Giacobbe fece un voto, dicendo: Se Iddio è meco, e mi guarda in questo viaggio che io fo, e mi dà del pane da mangiare, e de' vestimenti da vestirmi; ");
INSERT INTO ita1885_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","e se io ritorno sano e salvo a casa di mio padre, il Signore sarà il mio Dio. ");
INSERT INTO ita1885_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","E questa pietra, della quale ho fatto un piliere, sarà una casa di Dio, e del tutto io ti darò la decima di tutto quel che tu mi avrai donato. ");
INSERT INTO ita1885_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","POI Giacobbe si mise in cammino, e andò nel paese degli Orientali. ");
INSERT INTO ita1885_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","E riguardò, ed ecco un pozzo in un campo, e quivi erano tre gregge di pecore, che giacevano appresso di quello; perciocchè di quel pozzo si abbeveravano le gregge; ed una gran pietra era sopra la bocca del pozzo. ");
INSERT INTO ita1885_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","E quivi si raunavano tutte le gregge, e i pastori rotolavano quella pietra d'in su la bocca del pozzo, e abbeveravano le pecore; e poi tornavano la pietra al suo luogo, in su la bocca del pozzo. ");
INSERT INTO ita1885_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","E Giacobbe disse loro: Fratelli miei, onde siete voi? Ed essi risposero: Noi siamo di Charan. ");
INSERT INTO ita1885_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ed egli disse loro: Conoscete voi Labano, figliuolo di Nahor? Ed essi dissero: Sì, noi lo conosciamo. ");
INSERT INTO ita1885_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ed egli disse loro: Sta egli bene? Ed essi dissero: Sì, egli sta bene; ed ecco Rachele, sua figliuola, che viene con le pecore. ");
INSERT INTO ita1885_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ed egli disse loro: Ecco, il giorno è ancora alto; non è tempo di raccogliere il bestiame; abbeverate queste pecore, ed andate, e pasturatele. ");
INSERT INTO ita1885_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ma essi dissero: Noi non possiamo, finchè tutte le gregge non sieno adunate, e che si rotoli la pietra d'in su la bocca del pozzo; allora abbevereremo le pecore. ");
INSERT INTO ita1885_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Mentre egli parlava ancora con loro, Rachele sopraggiunse, con le pecore di suo padre; perciocchè ella era guardiana di pecore. ");
INSERT INTO ita1885_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","E, quando Giacobbe ebbe veduta Rachele, figliuola di Labano, fratello di sua madre, con le pecore di Labano, fratello di sua madre, egli si fece innanzi, e rotolò quella pietra d'in su la bocca del pozzo, e abbeverò le pecore di Labano, fratello di sua madre. ");
INSERT INTO ita1885_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","E Giacobbe baciò Rachele, e alzò la sua voce, e pianse. ");
INSERT INTO ita1885_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","E Giacobbe dichiarò a Rachele come egli era fratello di suo padre; e come egli era figliuolo di Rebecca. Ed ella corse, e lo rapportò a suo padre. ");
INSERT INTO ita1885_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","E, come Labano ebbe udite le novelle di Giacobbe, figliuolo della sua sorella, gli corse incontro, e l'abbracciò, e lo baciò, e lo menò in casa sua. E Giacobbe raccontò a Labano tutte queste cose. ");
INSERT INTO ita1885_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","E Labano gli disse: Veramente tu sei mie ossa e mia carne. Ed egli dimorò con lui un mese intiero. ");
INSERT INTO ita1885_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","E Labano gli disse: Perchè tu sei mio fratello, mi serviresti tu gratuitamente? dichiarami qual deve essere il tuo premio. ");
INSERT INTO ita1885_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Or Labano avea due figliuole: la maggiore si chiamava Lea, e la minore Rachele. ");
INSERT INTO ita1885_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","E Lea avea gli occhi teneri; ma Rachele era formosa, e di bello aspetto. ");
INSERT INTO ita1885_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","E Giacobbe amava Rachele; e disse a Labano: Io ti servirò sett'anni per Rachele, tua figliuola minore. ");
INSERT INTO ita1885_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","E Labano disse: Meglio è che io la dia a te, che ad un altro uomo; stattene pur meco. ");
INSERT INTO ita1885_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","E Giacobbe servì per Rachele lo spazio di sette anni; e quelli gli parvero pochi giorni, per l'amore ch'egli le portava. ");
INSERT INTO ita1885_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","E Giacobbe disse a Labano: Dammi la mia moglie; perciocchè il mio termine è compiuto; e lascia che io entri da lei. ");
INSERT INTO ita1885_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","E Labano adunò tutte le genti del luogo, e fece un convito. ");
INSERT INTO ita1885_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ma la sera prese Lea, sua figliuola, e la menò a Giacobbe; il quale entrò da lei. ");
INSERT INTO ita1885_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","E Labano diede Zilpa, sua serva, a Lea, sua figliuola, per serva. ");
INSERT INTO ita1885_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Poi, venuta la mattina, ecco, colei era Lea. E Giacobbe disse a Labano: Che cosa è ciò che tu mi hai fatto? non ho io servito appo te per Rachele? perchè dunque mi hai ingannato? ");
INSERT INTO ita1885_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","E Labano gli disse: E' non si suol far così appo noi, di dar la minore avanti la maggiore. ");
INSERT INTO ita1885_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Fornisci pure la settimana di questa; e poi ti daremo ancora quest'altra, per lo servigio che tu farai in casa mia altri sett'anni. ");
INSERT INTO ita1885_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Giacobbe adunque fece così; e fornì la settimana di quella; poi Labano gli diede ancora per moglie Rachele, sua figliluola. ");
INSERT INTO ita1885_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","E Labano diede Bilha, sua serva, a Rachele, sua figliola, per serva. ");
INSERT INTO ita1885_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","E Giacobbe entrò eziandio da Rachele, ed anche amò Rachele più che Lea, e servì ancora sett'altri anni appo Labano. ");
INSERT INTO ita1885_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","E il Signore, veggendo che Lea era odiata, aperse la sua matrice; ma Rachele era sterile. ");
INSERT INTO ita1885_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","E Lea concepette, e partorì un figliuolo, al quale ella pose nome Ruben; perciocchè disse: Il Signore ha pur riguardato alla mia afflizione; ora mi amerà pure il mio marito. ");
INSERT INTO ita1885_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Poi concepette di nuovo, e partorì un figliuolo, e disse: Il Signore ha pure inteso che io era odiata, e però mi ha dato ancora questo figliuolo; perciò gli pose nome Simeone. ");
INSERT INTO ita1885_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ed ella concepette ancora, e partorì un figliuolo, e disse: Questa volta pure il mio marito starà congiunto meco; perciocchè io gli ho partoriti tre figliuoli; perciò fu posto nome a quel figliuolo Levi. ");
INSERT INTO ita1885_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ed ella concepette ancora, e partorì un figliuolo, e disse: Questa volta io celebrerò il Signore; perciò pose nome a quel figliuolo Giuda; poi restò di partorire. ");
INSERT INTO ita1885_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","E Rachele, veggendo che non faceva figliuoli a Giacobbe, portò invidia alla sua sorella; e disse a Giacobbe: Dammi de' figliuoli; altrimenti io son morta. ");
INSERT INTO ita1885_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","E Giacobbe s'accesse in ira contro a Rachele, e disse: Sono io in luogo di Dio, il qual t'ha dinegato il frutto del ventre? ");
INSERT INTO ita1885_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ed ella disse: Ecco Bilha, mia serva; entra da lei ed ella partorirà sopra le mie ginocchia, ed io ancora avrò progenie da lei. ");
INSERT INTO ita1885_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ed ella diede a Giacobbe Bilha, sua serva, per moglie, ed egli entrò da lei. ");
INSERT INTO ita1885_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","E Bilha concepette, e partorì un figliuolo a Giacobbe. ");
INSERT INTO ita1885_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","E Rachele disse: Iddio mi ha fatto ragione, ed ha eziandio ascoltata la mia voce, e mi ha dato un figliuolo; perciò ella gli pose nome Dan. ");
INSERT INTO ita1885_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","E Bilha, serva di Rachele, concepette ancora, e partorì un secondo figliuolo a Giacobbe. ");
INSERT INTO ita1885_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","E Rachele disse: Io ho lottate le lotte di Dio con la mia sorella; ed anche ho vinto; perciò pose nome a quel figliuolo Neftali. ");
INSERT INTO ita1885_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","E Lea, veggendo ch'era restata di partorire, prese Zilpa, sua serva, e la diede a Giacobbe per moglie. ");
INSERT INTO ita1885_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","E Zilpa, serva di Lea, partorì un figliuolo a Giacobbe. ");
INSERT INTO ita1885_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","E Lea disse: Buona ventura è giunta; e pose nome a quel figliuolo Gad. ");
INSERT INTO ita1885_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Poi Zilpa, serva di Lea, partori un secondo figliuolo a Giacobbe. ");
INSERT INTO ita1885_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","E Lea disse: Quest'è per farmi beata; conciossiachè le donne mi chiameranno beata; perciò ella pose nome a quel figliuolo Aser. ");
INSERT INTO ita1885_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Or Ruben andò fuori al tempo della ricolta de' grani, e trovò delle mandragole per i campi, e le portò a Lea, sua madre. E Rachele disse a Lea: Deh! dammi delle mandragole del tuo figliuolo. ");
INSERT INTO ita1885_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ed ella le disse: È egli poco che tu mi abbi tolto il mio marito, che tu mi vuoi ancora togliere le mandragole del mio figliuolo? E Rachele disse: Or su, giacciasi egli questa notte teco per le mandragole del tuo figliuolo. ");
INSERT INTO ita1885_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","E come Giacobbe se ne veniva in su la sera da' campi, Lea gli uscì incontro, e gli disse: Entra da me; perciocchè io ti ho tolto a prezzo per le mandragole del mio figliuolo. Egli adunque si giacque con lei quella notte. ");
INSERT INTO ita1885_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","E Iddio esaudì Lea, talchè ella concepette, e partorì il quinto figliuolo a Giacobbe. ");
INSERT INTO ita1885_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ed ella disse: Iddio mi ha dato il mio premio, di ciò che io diedi la mia serva al mio marito; e pose nome a quel figliuolo Issacar. ");
INSERT INTO ita1885_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","E Lea concepette ancora, e partorì il sesto figliuolo a Giacobbe. ");
INSERT INTO ita1885_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","E Lea disse: Iddio mi ha dotata d'una buona dote; questa volta il mio marito abiterà meco, poichè io gli ho partoriti sei figliuoli; e pose nome a quel figliuolo Zabulon. ");
INSERT INTO ita1885_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Poi partorì una figliuola, e le pose nome Dina. ");
INSERT INTO ita1885_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","E Iddio si ricordò di Rachele, e l'esaudì, e le aperse la matrice. ");
INSERT INTO ita1885_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ed ella concepette, e partorì un figliuolo; e disse: Iddio ha tolto via il mio obbrobrio. ");
INSERT INTO ita1885_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","E pose nome a quel figliuolo Giuseppe, dicendo: Il Signore mi aggiunga un altro figliuolo. ");
INSERT INTO ita1885_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","E, dopo che Rachele ebbe partorito Giuseppe, Giacobbe disse a Labano: Dammi licenza, acciocchè io me ne vada al mio luogo, ed al mio paese. ");
INSERT INTO ita1885_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Dammi le mie mogli, per le quali io ti ho servito, ed i miei figliuoli; acciocchè io me ne vada; perciocchè tu sai il servigio che io t'ho renduto. ");
INSERT INTO ita1885_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","E Labano gli disse: Deh! se pure ho trovato grazia appo te: Io ho veduto che il Signore mi ha benedetto per cagion tua. ");
INSERT INTO ita1885_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Poi disse: Significami appunto qual salario mi ti converrà dare, ed io te lo darò. ");
INSERT INTO ita1885_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ed egli gli disse: Tu sai come io ti ho servito, e quale è divenuto il tuo bestiame meco. ");
INSERT INTO ita1885_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Perciocchè poco era quello che tu avevi, avanti che io venissi; ma ora egli è cresciuto sommamente; e il Signore ti ha benedetto per lo mio governo; ed ora quando mi adopererò io ancora per la mia famiglia? ");
INSERT INTO ita1885_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Ed egli disse: Che ti darò io? E Giacobbe disse: Non darmi nulla; se tu mi fai questo, io tornerò a pasturare, ed a guardar le tue pecore. ");
INSERT INTO ita1885_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Io passerò oggi per mezzo tutte le tue gregge, levandone, d'infra le pecore, ogni agnello macchiato e vaiolato; e ogni agnello di color fosco; e, d'infra le capre, le vaiolate e le macchiate; e tal sarà da ora innanzi il mio salario. ");
INSERT INTO ita1885_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Così da questo dì innanzi, quando tu mi contenderai il mio salario, la mia giustizia risponderà per me nel tuo cospetto; tutto ciò che non sarà macchiato o vaiolato fra le capre, e di color fosco fra le pecore, e sarà trovato appo me, sarà furto. ");
INSERT INTO ita1885_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","E Labano disse: Ecco, sia come tu hai detto. ");
INSERT INTO ita1885_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ed in quel dì mise da parte i becchi, e i montoni macchiati e vaiolati; e tutte le capre macchiate e vaiolate; e tutte quelle in cui era alcuna macchia bianca; e, d'infra le pecore, tutte quelle ch'erano di color fosco; e le mise tra le mani de' suoi figliuoli. ");
INSERT INTO ita1885_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","E frappose il cammino di tre giornate fra sè e Giacobbe. E Giacobbe pasturava il rimanente delle gregge di Labano. ");
INSERT INTO ita1885_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","E Giacobbe prese delle verghe verdi di pioppo, di nocciuolo, e di castagno; e vi fece delle scorzature bianche, scoprendo il bianco ch' era nelle verghe. ");
INSERT INTO ita1885_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Poi piantò le verghe ch'egli avea scorzate, dinanzi alle gregge, ne' canali dell'acqua, e negli abbeveratoi, ove le pecore venivano a bere; e le pecore entravano in calore quando venivano a bere. ");
INSERT INTO ita1885_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Le pecore adunque e le capre entravano in calore, vedendo quelle verghe; onde figliavano parti vergati, macchiati, e viaolati. ");
INSERT INTO ita1885_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Poi, come Giacobbe avea spartiti gli agnelli, faceva volger gli occhi alle pecore delle gregge di Labano, verso le vaiolate, e verso tutte quelle ch'erano di color fosco; e metteva le sue gregge da parte, e non le metteva di rincontro alle pecore di Labano. ");
INSERT INTO ita1885_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","E ogni volta che le pecore primaiuole entravano in calore, Giacobbe metteva quelle verghe ne' canali, alla vista delle pecore e delle capre; acciocchè entrassero in calore, alla vista di quelle verghe. ");
INSERT INTO ita1885_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ma, quando le pecore erano serotine, egli non ve le poneva; e così le pecore serotine erano di Labano, e le primaiuole di Giacobbe. ");
INSERT INTO ita1885_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","E quell'uomo crebbe sommamente in facoltà, ed ebbe molte gregge, e servi, e serve, e cammelli, ed asini. ");
INSERT INTO ita1885_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","OR egli udì le parole de' figliuoli di Labano, che dicevano: Giacobbe ha tolto a nostro padre tutto il suo avere; e di quello ch' era di nostra padre, egli ha acquistata tutta questa dovizia. ");
INSERT INTO ita1885_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Giacobbe ancora vide che la faccia di Labano non era verso lui qual soleva esser per addietro. ");
INSERT INTO ita1885_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","E il Signore disse a Giacobbe: Ritornatene al paese de' tuoi, ed al tuo luogo natio, ed io sarò teco. ");
INSERT INTO ita1885_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","E Giacobbe mandò a chiamar Rachele e Lea, a' campi, presso della sua greggia. ");
INSERT INTO ita1885_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","E disse loro: Io veggo che la faccia di vostro padre non è inverso me qual soleva esser per addietro; e pur l'Iddio di mio padre è stato meco. ");
INSERT INTO ita1885_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","E voi sapete che ho servito a vostro padre di tutto il mio potere. ");
INSERT INTO ita1885_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ma egli mi ha ingannato, e m'ha cambiato il mio salario dieci volte; ma Iddio non gli ha permesso di farmi alcun danno. ");
INSERT INTO ita1885_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Se egli diceva così: Le macchiate saranno il tuo salario, tutta la greggia figliava parti macchiati; e se diceva così: Le vergate saranno il tuo salario, tutta la greggia figliava parti vergati. ");
INSERT INTO ita1885_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","E Iddio ha tolto il bestiame a vostro padre, e me lo ha dato. ");
INSERT INTO ita1885_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Ed avvenne una volta, al tempo che le pecore entrano in calore, che io alzai gli occhi, e vidi in sogno che i becchi ed i montoni che ammontavano le pecore e le capre, erano vergati, macchiati e grandinati. ");
INSERT INTO ita1885_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","E l'angelo di Dio mi disse in sogno: Giacobbe. Ed io dissi: Eccomi. ");
INSERT INTO ita1885_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ed egli disse: Alza ora gli occhi, e vedi tutti i becchi e i montoni, che ammontano le capre e le pecore, come son tutti vergati, macchiati, e grandinati; perciocchè io ho veduto tutto quello che Labano ti fa. ");
INSERT INTO ita1885_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Io son l'Iddio di Betel, dove tu ugnesti quel piliere, e dove tu mi facesti quel voto; ora levati, e partiti di questo paese, e ritornatene nel tuo natio paese. ");
INSERT INTO ita1885_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","E Rachele e Lea risposero, e dissero: Abbiamo noi più alcuna parte od eredità in casa di nostro padre? ");
INSERT INTO ita1885_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Non fummo noi da lui reputate straniere, quando egli ci vendette? ed oltre a ciò egli ha tutti mangiati i nostri danari. ");
INSERT INTO ita1885_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Conciossiachè tutte queste facoltà che Iddio ha tolte a nostro padre, già fosser nostre e de' nostri figliuoli; ora dunque fa' pur tutto quello che Iddio ti ha detto. ");
INSERT INTO ita1885_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","E Giacobbe si levò, e mise i suoi figliuoli e le sue mogli in su de' cammelli. ");
INSERT INTO ita1885_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","E ne menò tutto il suo bestiame, e tutte le sue facoltà ch'egli avea acquistate; il bestiame ch'egli avea acquistato in Paddan-aram per venirsene nel paese di Canaan, ad Isacco suo padre. ");
INSERT INTO ita1885_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Or Labano se n'era andato a tondere le sue pecore; e Rachele rubò gl'idoli di suo padre. ");
INSERT INTO ita1885_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","E Giacobbe si partì furtivamente da Labano, Sirio; perciocchè egli non gliel dichiarò; conciossiachè egli se ne fuggisse. ");
INSERT INTO ita1885_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Egli adunque se ne fuggì, con tutto quello ch'egli avea; e si levò, e passò il Fiume, e si dirizzò verso il monte di Galaad. ");
INSERT INTO ita1885_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","E il terzo giorno appresso fu rapportato a Labano, che Giacobbe se n'era fuggito. ");
INSERT INTO ita1885_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Allora egli prese seco i suoi fratelli, e lo perseguì per sette giornate di cammino; e lo raggiunse al monte di Galaad. ");
INSERT INTO ita1885_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ma Iddio venne a Labano, Sirio, in sogno di notte, e gli disse: Guardati che tu non venga a parole con Giacobbe, nè in bene, nè in male. ");
INSERT INTO ita1885_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Labano adunque raggiunse Giacobbe. E Giacobbe avea tesi i suoi padiglioni in sul monte; e Labano, co' suoi fratelli, tese parimente i suoi nel monte di Galaad. ");
INSERT INTO ita1885_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","E Labano disse a Giacobbe: Che hai tu fatto, partendoti da me furtivamente, e menandone le mie figliuole come prigioni di guerra? ");
INSERT INTO ita1885_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Perchè ti sei fuggito celatamente, e ti sei furtivamente partito da me, e non me l'hai fatto assapere? ed io ti avrei accommiatato con allegrezza e con canti, con tamburi e con cetere. ");
INSERT INTO ita1885_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","E non mi hai pur permesso di baciare i miei figliuoli e le mie figliuole; ora tu hai stoltamente fatto. ");
INSERT INTO ita1885_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","E' sarebbe in mio potere di farvi del male; ma l'Iddio del padre vostro mi parlò la notte passata, dicendo: Guardati che tu non venga a parole con Giacobbe, nè in bene, nè in male. ");
INSERT INTO ita1885_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ora dunque, siitene pure andato, poichè del tutto bramavi la casa di tuo padre; ma, perchè hai tu rubati i miei dii? ");
INSERT INTO ita1885_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","E Giacobbe rispose, e disse a Labano: Io me ne son così andato, perchè io avea paura; perciocchè io diceva che mi conveniva guardar che talora tu non rapissi le tue figliuole d'appresso a me. ");
INSERT INTO ita1885_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Colui, appo il quale tu avrai trovati i tuoi dii, non sia lasciato vivere; riconosci, in presenza de' nostri fratelli, se vi è nulla del tuo appo me, e prenditelo. Or Giacobbe non sapeva che Rachele avesse rubati quegl'iddii. ");
INSERT INTO ita1885_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Labano adunque entrò nel padiglione di Giacobbe, e nel padiglione di Lea, e nel padiglione delle due serve, e non li trovò; ed uscito del padiglione di Lea, entrò nel padiglione di Rachele. ");
INSERT INTO ita1885_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ma Rachele avea presi quegl'idoli, e li avea messi dentro l'arnese d'un cammello, e s'era posta a sedere sopra essi; e Labano frugò tutto il padiglione, e non li trovò. ");
INSERT INTO ita1885_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ed ella disse a suo padre: Non prenda il mio signore sdegno, ch'io non posso levarmi su davanti a te; perciocchè io ho quello che sogliono aver le donne. Egli adunque investigò, ma non trovò quegl'idoli. ");
INSERT INTO ita1885_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","E Giacobbe si adirò, e contese con Labano, e gli parlò, e gli disse: Qual misfatto, o qual peccato ho io commesso, che tu mi abbi così ardentemente perseguito? ");
INSERT INTO ita1885_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Poichè tu hai frugate tutte le mie masserizie, che hai tu trovato di tutte le masserizie di casa tua? mettilo qui davanti a' tuoi e miei fratelli, acciocchè giudichino chi di noi due ha ragione. ");
INSERT INTO ita1885_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Già son vent'anni ch'io sono stato teco; le tue pecore e le tue capre non hanno disperduto, ed io non ho mangiati i montoni della tua greggia. ");
INSERT INTO ita1885_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Io non ti ho portato ciò ch'era lacerato; io l'ho pagato; tu me lo hai ridomandato: come ancora se alcuna cosa era stata rubata di giorno o di notte. ");
INSERT INTO ita1885_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Io mi son portato in maniera che il caldo mi consumava di giorno, e di notte il gelo, e il sonno mi fuggiva dagli occhi. ");
INSERT INTO ita1885_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Già son vent'anni ch' io sono in casa tua, io ti ho servito quattordici anni per le tue due figliuole, e sei anni per le tue pecore; e tu mi hai mutato il mio salario dicei volte. ");
INSERT INTO ita1885_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Se l'Iddio di mio padre, l'Iddio di Abrahamo, e il terrore d'Isacco, non fosse stato meco, certo tu mi avresti ora rimandato voto. Iddio ha veduta la mia afflizione, e la fatica delle mie mani: e però la notte passata ne ha data la sentenza. ");
INSERT INTO ita1885_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labano rispose a Giacobbe, e gli disse: Queste figliuole son mie figliuole, e questi figliuoli son miei figliuoli, e queste pecore son mie pecore, e tutto quello che tu vedi è mio; e che farei io oggi a queste mie figliuole, ovvero a' lor figliuoli che esse hanno partoriti? ");
INSERT INTO ita1885_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ora dunque, vieni, facciam patto insieme, tu ed io; e sia ciò per testimonianza fra me e te. ");
INSERT INTO ita1885_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","E Giacobbe prese una pietra, e la rizzò per un piliere. ");
INSERT INTO ita1885_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","E Giacobbe disse a' suoi fratelli: Raccogliete delle pietre. Ed essi presero delle pietre, e ne fecero un mucchio, e mangiarono quivi. ");
INSERT INTO ita1885_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","E Labano chiamò quel mucchio Iegar-sahaduta; e Giacobbe gli pose nome Galed. ");
INSERT INTO ita1885_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","E Labano disse: Questo mucchio è oggi testimonio fra me e te; perciò fu nominato Galed: ");
INSERT INTO ita1885_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ed anche Mispa; perciocchè Labano disse: Il Signore riguardi fra te e me, quando non ci potremo vedere l'un l'altro. ");
INSERT INTO ita1885_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Se tu affliggi le mie figliuole, ovvero, se tu prendi altre mogli oltre alle mie figliuole, non un uomo è testimonio fra noi; vedi: Iddio è testimonio fra me e te. ");
INSERT INTO ita1885_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Labano, oltre a ciò, disse a Giacobbe: Ecco questo mucchio che io ho ammonticchiato, ed ecco questo piliere fra me e te. ");
INSERT INTO ita1885_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Questo mucchio sarà testimonio, e questo piliere ancora sarà testimonio, che nè io non passerò questo mucchio per andare a te, nè tu non passerai questo mucchio e questo piliere, per venire a me, per male. ");
INSERT INTO ita1885_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","L'Iddio di Abrahamo, e l'Iddio di Nahor, l'Iddio del padre loro, sieno giudici fra noi. Ma Giacobbe giurò per lo terrore d'Isacco, suo padre. ");
INSERT INTO ita1885_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","E Giacobbe sacrificò un sacrificio in su quel monte, e chiamò i suoi fratelli a mangiar del pane. Essi adunque mangiarono del pane, e dimorarono quella notte in su quel monte. ");
INSERT INTO ita1885_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","E la mattina, Labano si levò a buon'ora, e baciò le sue figliuole, e i suoi figliuoli, e li benedisse. Poi se ne andò, e ritornò al suo luogo. ");
INSERT INTO ita1885_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","E GIACOBBE andò al suo cammino; ed egli scontrò degli Angeli di Dio. ");
INSERT INTO ita1885_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","E come Giacobbe li vide, disse: Quest'è un campo di Dio: perciò pose nome a quel luogo Mahanaim. ");
INSERT INTO ita1885_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","E Giacobbe mandò davanti a sè dei messi ad Esaù, suo fratello, nel paese di Seir, territorio di Edom. ");
INSERT INTO ita1885_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","E diede loro quest'ordine: Dite così ad Esaù, mio signore: Così ha detto il tuo servitore Giacobbe: Io sono stato forestiere appo Labano, e vi son dimorato infino ad ora. ");
INSERT INTO ita1885_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ed ho buoi, ed asini, e pecore, e servi, e serve; e mando significandolo al mio signore, per ritrovar grazia appo te. ");
INSERT INTO ita1885_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","E i messi se ne ritornarono a Giacobbe, e gli dissero: Noi siamo andati ad Esaù, tuo fratello; ed egli altresì ti viene incontro, menando seco quattrocent'uomini. ");
INSERT INTO ita1885_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","E Giacobbe temette grandemente, e fu angosciato; e spartì la gente ch'era seco, e le gregge, e gli armenti, e i cammelli in due schiere. ");
INSERT INTO ita1885_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","E disse: Se Esaù viene ad una delle schiere, e la percuote, l'altra scamperà. ");
INSERT INTO ita1885_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Poi Giacobbe disse: O Dio di Abrahamo, mio padre, e Dio parimente d'Isacco, mio padre; o Signore, che mi dicesti: Ritorna al tuo paese, ed al tuo luogo natio, ed io ti farò del bene, ");
INSERT INTO ita1885_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","io son piccolo appo tutte le benignità, e tutta la lealtà che tu hai usata inverso il tuo servitore; perciocchè io passai questo Giordano col mio bastone solo, ed ora son divenuto due schiere. ");
INSERT INTO ita1885_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Liberami, ti prego, dalle mani del mio fratello, dalle mani di Esaù; perciocchè io temo di lui, che talora egli non venga, e mi percuota, madre e figliuoli insieme. ");
INSERT INTO ita1885_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","E pur tu hai detto: Per certo io ti farò del bene, e farò che la tua progenie sarà come la rena del mare, la qual non si può annoverare per la sua moltitudine. ");
INSERT INTO ita1885_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ed egli dimorò quivi quella notte; e prese di ciò che gli venne in mano per farne un presente ad Esaù, suo fratello; ");
INSERT INTO ita1885_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","cioè dugento capre, e venti becchi; dugento pecore, e venti montoni; ");
INSERT INTO ita1885_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","trenta cammelle allattanti, insieme co' lor figli; quaranta vacche, e dieci giovenchi; venti asine, e dieci puledri d'asini. ");
INSERT INTO ita1885_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","E diede ciascuna greggia da parte in mano ai suoi servitori; e disse loro: Passate davanti a me, e fate che vi sia alquanto spazio fra una greggia e l'altra. ");
INSERT INTO ita1885_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","E diede quest'ordine al primo: Quando Esaù, mio fratello, ti scontrerà, e ti domanderà: Di cui sei tu? e dove vai? e di cui son questi animali che vanno davanti a te? ");
INSERT INTO ita1885_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","di': Io son del tuo servitore Giacobbe; quest'è un presente mandato al mio signore Esaù; ed ecco, egli stesso viene dietro a noi. ");
INSERT INTO ita1885_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","E diede lo stesso ordine al secondo, ed al terzo, ed a tutti que' servitori che andavano dietro a quelle gregge; dicendo: Parlate ad Esaù in questa maniera, quando voi lo troverete. ");
INSERT INTO ita1885_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","E ditegli ancora: Ecco il tuo servitore Giacobbe dietro a noi. Perciocchè egli diceva: Io lo placherò col presente che va davanti a me; e poi potrò veder la sua faccia; forse mi farà egli buona accoglienza. ");
INSERT INTO ita1885_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Quel presente adunque passò davanti a lui; ed egli dimorò quella notte nel campo. ");
INSERT INTO ita1885_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ed egli si levò di notte, e prese le sue due mogli, e le sue due serve, e i suoi undici figliuoli; e passò il guado di Iabboc. ");
INSERT INTO ita1885_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","E, dopo che li ebbe presi, ed ebbe loro fatto passare il torrente, fece passare tutto il rimanente delle cose sue. ");
INSERT INTO ita1885_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","E Giacobbe restò solo; ed un uomo lottò con lui fino all'apparir dell'alba. ");
INSERT INTO ita1885_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ed esso, veggendo che non lo potea vincere, gli toccò la giuntura della coscia; e la giuntura della coscia di Giacobbe fu smossa, mentre quell'uomo lottava con lui. ");
INSERT INTO ita1885_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","E quell'uomo gli disse: Lasciami andare; perciocchè già spunta l'alba. E Giacobbe gli disse: Io non ti lascerò andare, che tu non mi abbi benedetto. ");
INSERT INTO ita1885_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","E quell'uomo gli disse: Quale è il tuo nome? ");
INSERT INTO ita1885_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ed egli disse: Giacobbe. E quell'uomo gli disse: Tu non sarai più chiamato Giacobbe, anzi Israele; conciossiachè tu sii stato prode e valente con Dio e con gli uomini, ed abbi vinto. ");
INSERT INTO ita1885_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","E Giacobbe lo domandò, e gli disse: Deh! dichiarami il tuo nome. Ed egli disse: Perchè domandi del mio nome? ");
INSERT INTO ita1885_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","E quivi lo benedisse. E Giacobbe pose nome a quel luogo Peniel; perciocchè disse: Io ho veduto Iddio a faccia a faccia; e pur la vita mi è stata salvata. ");
INSERT INTO ita1885_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","E il sole gli si levò come fu passato Peniel; ed egli zoppicava della coscia. ");
INSERT INTO ita1885_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Perciò i figliuoli d'Israele non mangiano fino ad oggi del muscolo della commessura dell'anca ch'è sopra la giuntura della coscia; perciocchè quell'uomo toccò la giuntura della coscia di Giacobbe, al muscolo della commessura dell'anca. ");
INSERT INTO ita1885_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","POI Giacobbe alzò gli occi, e riguardò; ed ecco Esaù veniva, menando seco quattrocent'uomini. Ed egli spartì i fanciulli in tre schiere, sotto Lea, sotto Rachele, e sotto le due serve. ");
INSERT INTO ita1885_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","E mise le serve e i lor figliuoli davanti; e Lea e i suoi figliuoli appresso; e Rachele e Giuseppe gli ultimi. ");
INSERT INTO ita1885_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ed egli passò davanti a loro, e s'inchinò sette volte a terra, finchè fu presso al suo fratello. ");
INSERT INTO ita1885_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ed Esaù gli corse incontro, e l'abbracciò, e gli si gittò al collo, e lo baciò; ed amendue piansero. ");
INSERT INTO ita1885_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ed Esaù alzò gli occhi, e vide quelle donne e que' fanciulli, e disse: Che ti son costoro? E Giacobbe disse: Sono i fanciulli che Iddio ha donati al tuo servitore. ");
INSERT INTO ita1885_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","E le serve si accostarono, coi loro figliuoli, e s'inchinarono. ");
INSERT INTO ita1885_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Poi Lea si accostò, co' suoi figliuoli, e s'inchinarono. Poi si accostò Giuseppe e Rachele, e si inchinarono. ");
INSERT INTO ita1885_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ed Esaù disse a Giacobbe: Che vuoi far di tutta quell'oste che io ho scontrata? Ed egli disse: Io l'ho mandata per trovar grazia appo il mio signore. ");
INSERT INTO ita1885_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ed Esaù disse: Io ne ho assai, fratel mio; tienti per te ciò ch' è tuo. ");
INSERT INTO ita1885_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ma Giacobbe disse: Deh! no; se ora io ho trovato grazia appo te, prendi dalla mia mano il mio presente; conciossiachè per ciò io abbia veduta la tua faccia, il che mi è stato come se avessi veduta la faccia di Dio; e tu mi hai gradito. ");
INSERT INTO ita1885_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Deh! prendi il mio presente che ti è stato condotto; perciocchè Iddio mi è stato liberal donatore, ed io ho di tutto. E gli fece forza, sì ch'egli lo prese. ");
INSERT INTO ita1885_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Poi Esaù disse: Partiamoci, ed andiamocene; ed io ti accompagnerò. ");
INSERT INTO ita1885_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ma Giacobbe gli disse: Ben riconosce il mio signore che questi fanciulli son teneri; ed io ho le mie pecore e le mie vacche pregne; e se sono spinte innanzi pure un giorno, tutta la greggia morrà. ");
INSERT INTO ita1885_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Deh! passi il mio signore davanti al suo servitore, ed io mi condurrò pian piano, al passo di questo bestiame ch'è davanti a me, e di questi fanciulli, finchè io arrivi al mio signore in Seir. ");
INSERT INTO ita1885_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ed Esaù disse: Deh! lascia che io faccia restar teco della gente ch'è meco. Ma Giacobbe disse: Perchè questo? lascia che io ottenga questa grazia dal mio signore. ");
INSERT INTO ita1885_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Esaù adunque in quel dì se ne ritornò verso Seir, per lo suo cammino. ");
INSERT INTO ita1885_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","E Giacobbe partì, e venne in Succot, e si edificò una casa, e fece delle capanne per lo suo bestiame; perciò pose nome a quel luogo Succot. ");
INSERT INTO ita1885_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Poi Giacobbe arrivò sano e salvo nella città di Sichem, nel paese di Canaan, tornando di Paddan-aram; e tese i suoi padiglioni davanti alla città. ");
INSERT INTO ita1885_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","E comperò da' figliuoli d'Hemor, padre di Sichem, per cento pezze di moneta, la parte del campo, ove avea tesi i suoi padiglioni. ");
INSERT INTO ita1885_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","E rizzò un altare, e lo nominò Iddio, l'Iddio d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","OR Dina, figliuola di Lea, la quale ella avea partorita a Giacobbe, uscì fuori, per veder le donne del paese. ");
INSERT INTO ita1885_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","E Sichem, figliuolo d'Hemor, Hivveo, principe del paese, vedutala, la rapì, e si giacque con lei, e la sforzò. ");
INSERT INTO ita1885_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","E l'animo suo si apprese a Dina, figliuola di Giacobbe; ed amò quella giovane, e la racconsolò. ");
INSERT INTO ita1885_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Poi disse ad Hemor, suo padre: Prendimi questa giovane per moglie. ");
INSERT INTO ita1885_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","E Giacobbe intese che Sichem avea contaminata Dina, sua figliuola; ed essendo i suoi figliuoli a' campi col suo bestiame, Giacobbe si tacque finchè fosser venuti. ");
INSERT INTO ita1885_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Ed Hemor, padre di Sichem, venne a Giacobbe, per parlarne con lui. ");
INSERT INTO ita1885_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","E quando i figliuoli di Giacobbe ebbero inteso il fatto, se ne vennero da' campi; e quegli uomini furono addolorati, e gravemente adirati, che colui avesse commessa villania in Israele, giacendosi con la figliuola di Giacobbe; il che non si conveniva fare. ");
INSERT INTO ita1885_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ed Hemor parlò con loro, dicendo: Sichem, mio figliuolo, ha posto il suo amore alla figliuola di casa vostra; deh! dategliela per moglie. ");
INSERT INTO ita1885_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ed imparentatevi con noi; dateci le vostre figliuole, e prendetevi le nostre. ");
INSERT INTO ita1885_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ed abitate con noi; e il paese sarà a vostro comando; dimoratevi, e trafficatevi, ed acquistate delle possessioni in esso. ");
INSERT INTO ita1885_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sichem ancora disse al padre ed a' fratelli di essa: Lasciate che io trovi grazia appo voi; ed io darò ciò che mi direte. ");
INSERT INTO ita1885_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Imponetemi pur gran dote e presenti, ed io li darò, secondo che mi direte; e datemi la fanciulla per moglie. ");
INSERT INTO ita1885_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","E i figliuoli di Giacobbe risposero a Sichem, e ad Hemor suo padre, con inganno, e lo trattennero con parole; perciocchè egli avea contaminata Dina, lor sorella. ");
INSERT INTO ita1885_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","E disser loro: Noi non possiam far questa cosa, di dar la nostra sorella ad un uomo incirconciso; perciocchè il prepuzio ci è cosa vituperosa. ");
INSERT INTO ita1885_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ma pur vi compiaceremo con questo, che voi siate come noi, circoncidendosi ogni maschio d'infra voi. ");
INSERT INTO ita1885_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Allora noi vi daremo le nostre figliuole, e ci prenderemo le vostre, ed abiteremo con voi, e diventeremo uno stesso popolo. ");
INSERT INTO ita1885_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ma se voi non ci acconsentite di circoncidervi, noi prenderemo la nostra fanciulla, e ce ne andremo. ");
INSERT INTO ita1885_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","E le lor parole piacquero ad Hemor, ed a Sichem figliuolo d'Hemor. ");
INSERT INTO ita1885_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","E quel giovane non indugiò il far questa cosa; perciocchè egli portava affezione alla figliuola di Giacobbe; ed egli era il più onorato di tutta la casa di suo padre. ");
INSERT INTO ita1885_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ed Hemor, e Sichem suo figliuolo, vennero alla porta della città, e parlarono agli uomini della lor città, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Questi uomini vivono pacificamente con noi, e dimoreranno nel paese, e vi trafficheranno; ed ecco il paese è ampio assai per loro; e noi ci prenderemo le lor figliuole per mogli, e daremo loro le nostre. ");
INSERT INTO ita1885_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ma pure a questi patti ci compiaceranno di abitar con noi, per diventare uno stesso popolo, che ogni maschio d'infra noi sia circonciso, siccome essi son circoncisi. ");
INSERT INTO ita1885_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Il lor bestiame, e le lor facoltà, e tutte le lor bestie non saranno elle nostre? compiacciamo pur loro, ed essi abiteranno con noi. ");
INSERT INTO ita1885_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","E tutti quelli che uscivano per la porta della lor città, acconsentirono loro; e ogni maschio d'infra tutti quelli che uscivano per la porta della lor città, fu circonciso. ");
INSERT INTO ita1885_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","E al terzo giorno, mentre essi erano in dolore, due figliuoli di Giacobbe, Simeone e Levi fratelli di Dina, presa ciascuno la sua spada, assalirono a man salva la città, ed uccisero tutti i maschi. ");
INSERT INTO ita1885_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Uccisero ancora Hemor e Sichem suo figliuolo, mettendoli a fil di spada; e presero Dina della casa di Sichem, e se ne uscirono. ");
INSERT INTO ita1885_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Dopo che coloro furono uccisi, sopraggiunsero i figliuoli di Giacobbe, e predarono la città; perciocchè la lor sorella era stata contaminata. ");
INSERT INTO ita1885_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","E presero le lor gregge, e i loro armenti, e i loro asini, e ciò ch'era nella città e per li campi. ");
INSERT INTO ita1885_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Così predarono tutte le facoltà de' Sichemiti, e tutto ciò ch' era nelle case, e menarono prigioni i lor piccoli figliuoli e le lor mogli. ");
INSERT INTO ita1885_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","E Giacobbe disse a Simeone ed a Levi: Voi mi avete messo in gran turbamento, rendendomi abbominevole agli abitanti di questo paese, a' Cananei, ed a' Ferezei; laonde, avendo io poca gente, essi si rauneranno contro a me, e mi percoteranno; e sarò distrutto io e la mia famiglia. ");
INSERT INTO ita1885_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ed essi dissero: Avrebbe egli fatto della nostra sorella come d'una meretrice? ");
INSERT INTO ita1885_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","E IDDIO disse a Giacobbe: Levati, vattene in Betel, e dimora quivi, e fa' un altare all'Iddio che ti apparve quando tu fuggivi per tema di Esaù, tuo fratello. ");
INSERT INTO ita1885_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","E Giacobbe disse alla sua famiglia, ed a tutti coloro ch'erano con lui: Togliete via gl'iddii stranieri che son fra voi, e purificatevi, e cambiatevi i vestimenti. ");
INSERT INTO ita1885_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","E noi ci leveremo, ed andremo in Betel; ed io farò quivi un altare all'Iddio che mi ha risposto al giorno della mia angoscia, ed è stato meco per lo viaggio che io ho fatto. ");
INSERT INTO ita1885_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ed essi diedero a Giacobbe tutti gl'iddii degli stranieri, ch' erano nelle lor mani, e i monili che aveano agli orecchi; e Giacobbe il nascose sotto la quercia, ch'è vicina a Sichem. ");
INSERT INTO ita1885_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Poi si partirono. E il terror di Dio fu sopra le città ch' erano d'intorno a loro; laonde non perseguirono i figliuoli di Giacobbe. ");
INSERT INTO ita1885_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","E Giacobbe, con tutta la gente ch'era con lui, giunse a Luz, ch'è nel paese di Canaan, la quale è Betel. ");
INSERT INTO ita1885_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ed edificò quivi un altare, e nominò quel luogo: L'Iddio di Betel; perciocchè quivi gli apparve Iddio, quando egli si fuggiva per tema del suo fratello. ");
INSERT INTO ita1885_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","E Debora, balia di Rebecca, morì, e fu seppellita al disotto di Betel, sotto una quercia, la quale Giacobbe nominò: Quercia di pianto. ");
INSERT INTO ita1885_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","E Iddio apparve ancora a Giacobbe, quando egli veniva di Paddan-aram, e lo benedisse. ");
INSERT INTO ita1885_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","E Iddio gli disse: Il tuo nome è Giacobbe: tu non sarai più nominato Giacobbe, anzi il tuo nome sarà Israele; e gli pose nome Israele. ");
INSERT INTO ita1885_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Oltre a ciò Iddio gli disse: Io son l'Iddio Onnipotente; cresci e moltiplica; una nazione, anzi una raunanza di nazioni, verrà da te, e re usciranno da' tuoi lombi. ");
INSERT INTO ita1885_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ed io donerò a te, ed alla tua progenie dopo te, il paese che io diedi ad Abrahamo e ad Isacco. ");
INSERT INTO ita1885_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Poi Iddio risalì d'appresso a lui, nel luogo stesso dove egli avea parlato con lui. ");
INSERT INTO ita1885_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","E Giacobbe rizzò un piliere di pietra nel luogo ove Iddio avea parlato con lui; e versò sopra esso una offerta da spandere, e vi sparse su dell'olio. ");
INSERT INTO ita1885_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Giacobbe adunque pose nome Betel a quel luogo, dove Iddio avea parlato con lui. ");
INSERT INTO ita1885_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Poi Giacobbe, co' suoi, partì di Betel; e, restandovi ancora alquanto spazio di paese per arrivare in Efrata, Rachele partorì, ed ebbe un duro parto. ");
INSERT INTO ita1885_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","E, mentre penava a partorire, la levatrice le disse: Non temere; perciocchè eccoti ancora un figliuolo. ");
INSERT INTO ita1885_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","E, come l'anima sua si partiva (perciocchè ella morì), ella pose nome a quel figliuolo: Ben-oni; ma suo padre lo nominò Beniamino. ");
INSERT INTO ita1885_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","E Rachele morì, e fu seppellita nella via d'Efrata, ch'è Bet-lehem. ");
INSERT INTO ita1885_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","E Giacobbe rizzò una pila sopra la sepoltura di essa. Quest' è la pila della sepoltura di Rachele, che dura infino al dì d'oggi. ");
INSERT INTO ita1885_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","E Israele si partì, e tese i suoi padiglioni di là da Migdal-eder. ");
INSERT INTO ita1885_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ed avvenne, mentre Israele abitava in quel paese, che Ruben andò, e si giacque con Bilha, concubina di suo padre; e Israele lo intese. ");
INSERT INTO ita1885_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Or i figliuoli di Giacobbe furono dodici. ");
INSERT INTO ita1885_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","I figliuoli di Lea furono Ruben, primogenito di Giacobbe, e Simeone e Levi, e Giuda, ed Issacar, e Zabulon. ");
INSERT INTO ita1885_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","E i figliuoli di Rachele furono Giuseppe e Beniamino. ");
INSERT INTO ita1885_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","E i figliuoli di Bilha, serva di Rachele, furono Dan e Neftali. ");
INSERT INTO ita1885_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","E i figliuoli di Zilpa, serva di Lea, furono Gad ed Aser. Questi sono i figliuoli di Giacobbe, i quali gli nacquero in Paddan-aram. ");
INSERT INTO ita1885_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","E Giacobbe arrivò ad Isacco, suo padre, in Mamre, nella città di Arba, ch'è Hebron, ove Abrahamo ed Isacco erano dimorati. ");
INSERT INTO ita1885_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Or il tempo della vita d'Isacco fu di centottant'anni. ");
INSERT INTO ita1885_vpl VALUES ("GN35_30","002_35_30","GEN","35","30","30","Poi Isacco trapassò, e morì, e fu raccolto a' suoi popoli, vecchio e sazio di giorni. Ed Esaù e Giacobbe, suoi figliuoli, lo seppellirono. ");
INSERT INTO ita1885_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","OR queste sono le generazioni di Esaù, che è Edom. ");
INSERT INTO ita1885_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esaù prese le sue mogli d'infra le figliuole de' Cananei; Ada, figliuola di Elon Hitteo; ed Oholibama, figliuola di Ana, e figliuola di Sibon Hivveo; ");
INSERT INTO ita1885_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","e Basemat, figliuola d'Ismaele, sorella di Nebaiot. ");
INSERT INTO ita1885_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","E Ada partorì ad Esaù Elifaz; e Basemat partorì Reuel. ");
INSERT INTO ita1885_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Ed Oholibama partorì Ieus, e Ialam, e Cora. Questi sono i figliuoli di Esaù, che gli nacquero nel paese di Canaan. ");
INSERT INTO ita1885_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ed Esaù prese le sue mogli, ed i suoi figliuoli, e le sue figliuole, e tutte le persone di casa sua, e le sue gregge, e tutte le sue bestie, e tutte le sue facoltà, che egli avea acquistate nel paese di Canaan; ed andò nel paese, lungi da Giacobbe, suo fratello. ");
INSERT INTO ita1885_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Perciocchè le lor facoltà erano troppo grandi, per poter dimorare insieme; e il paese, nel quale abitavano come forestieri, non li poteva comportare per cagion de' lor bestiami. ");
INSERT INTO ita1885_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ed Esaù abitò nella montagna di Seir. Esaù è Edom. ");
INSERT INTO ita1885_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","E queste sono le generazioni di Esaù, padre degl'Idumei, nella montagna di Seir. ");
INSERT INTO ita1885_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Questi sono i nomi de' figliuoli di Esaù: Elifaz, figliuolo di Ada, moglie di Esaù; e Reuel, figliuolo di Basemat, moglie di Esaù. ");
INSERT INTO ita1885_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","E i figliuoli di Elifaz furono Teman, Omar, Sefo, Gatam, e Chenaz. ");
INSERT INTO ita1885_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","E Timna fu concubina d'Elifaz, figliuolo di Esaù, e gli partorì Amalec. Questi furono i figliuoli di Ada moglie di Esaù. ");
INSERT INTO ita1885_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","E questi furono i figliuoli di Reuel: Nahat, e Zera, e Samma, e Mizza. Questi furono i figliuoli di Basemat, moglie di Esaù. ");
INSERT INTO ita1885_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","E questi furono i figliuoli d'Oholibama figliuola di Ana, figliuola di Sibon, moglie di Esaù. Ella partorì ad Esaù Ieus, Ialam e Cora. ");
INSERT INTO ita1885_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Questi sono i duchi de' figliuoli di Esaù: de' figliuoli di Elifaz, primogenito di Esaù, il duca Teman, il duca Omar, il duca Sefo, il duca Chenaz; ");
INSERT INTO ita1885_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","il duca Cora, il duca Gatam, il duca Amalec. Questi furono i duchi della linea di Elifaz, nel paese degl'Idumei. Essi furono dei figliuoli di Ada. ");
INSERT INTO ita1885_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","E questi furono i duchi de' figliuoli di Reuel, figliuolo di Esaù: il duca Nahat, il duca Zera, il duca Samma, il duca Mizza. Questi furono i duchi della linea di Reuel, nel paese degl'Idumei. Questi furono de' figliuoli di Basemat, moglie di Esaù. ");
INSERT INTO ita1885_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","E questi furono de' figliuoli di Oholibama, moglie di Esaù: il duca Ieus, il duca Ialam, il duca Cora. Questi furono i duchi de' figliuoli di Oholibama, figliuola di Ana, moglie di Esaù. ");
INSERT INTO ita1885_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Questi furono i figliuoli di Esaù, che è Edom; e questi furono i duchi d'infra loro. ");
INSERT INTO ita1885_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Questi furono i figliuoli di Seir Horeo, i quali abitavano in quel paese cioè: Lotan, e Sobal, e Sibon, ed Ana; e Dison, ed Eser, e Disan. ");
INSERT INTO ita1885_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Questi furono i duchi degli Horei, figliuoli di Seir, nel paese degl'Idumei. ");
INSERT INTO ita1885_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","E i figliuoli di Lotan furono Hori, ed Hemam; e la sorella di Lotan fu Timna. ");
INSERT INTO ita1885_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","E questi furono i figliuoli di Sobal, cioè: Alvan, e Manahat, ed Ebal, e Sefo, ed Onam. ");
INSERT INTO ita1885_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","E questi furono i figliuoli di Sibon: Aia, ed Ana. Questo Ana fu colui che trovò le acque calde nel deserto, mentre pasturava gli asini di Sibon, suo padre. ");
INSERT INTO ita1885_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","E questi furono i figliuoli di Ana: Dison, ed Oholibama, figliuola di Ana. ");
INSERT INTO ita1885_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","E questi furono i figliuoli di Dison: Hemdan, ed Esban, ed Itran, e Cheran. ");
INSERT INTO ita1885_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Questi furono i figliuoli di Eser, cioè: Bilhan, e Zaavan, ed Aran. ");
INSERT INTO ita1885_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Questi furono i figliuoli di Dison, cioè: Us, ed Aran. ");
INSERT INTO ita1885_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Questi furono i duchi degli Horei: il duca Lotan, il duca Sobal, il duca Sibon, il duca Ana; ");
INSERT INTO ita1885_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","il duca Dison, il duca Eser, il duca Disan. Questi furono i duchi degli Horei, secondo il numero de' lor duchi nel paese di Seir. ");
INSERT INTO ita1885_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","E questi furono i re, che regnarono nel paese d'Idumea, avanti che re alcuno regnasse sopra i figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, figliuolo di Beor, regnò in Idumea; e il nome della sua città era Dinhaba. ");
INSERT INTO ita1885_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","E, morto Bela, Iobab, figliuolo di Zera, da Bosra, regnò in luogo suo. ");
INSERT INTO ita1885_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","E, morto Iobab, Husam, del paese de' Temaniti, regnò in luogo suo. ");
INSERT INTO ita1885_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","E, morto Husam, Hadad, figliuolo di Bedad, il qual percosse i Madianiti nel territorio di Moab, regnò in luogo suo; e il nome della sua città era Avit. ");
INSERT INTO ita1885_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","E, morto Hadad, Samla, da Masreca, regnò in luogo suo. ");
INSERT INTO ita1885_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","E, morto Samla, Saul, da Rehobot del Fiume, regnò in luogo suo. ");
INSERT INTO ita1885_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","E, morto Saul, Baal-hanan, figliuolo di Acbor, regnò in luogo suo. ");
INSERT INTO ita1885_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","E, morto Baal-hanan, figliuolo di Acbor, Hadar regnò in luogo suo; il nome della cui città era Pau e il nome della sua moglie era Mehetabeel, figliuola di Matred, figliuola di Mezahab. ");
INSERT INTO ita1885_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","E questi sono i nomi de' duchi di Esaù, per le lor famiglie, secondo i lor luoghi, nominati de' loro nomi: il duca Timna, il duca Alva, il duca Ietet; ");
INSERT INTO ita1885_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","il duca Oholibama, il duca Ela, il duca Pinon; ");
INSERT INTO ita1885_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","il duca Chenaz, il duca Teman, il duca Mibsar; ");
INSERT INTO ita1885_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","il duca Magdiel, e il duca Iram. Questi furono i duchi degl'Idumei, spartiti secondo le loro abitazioni, nel paese della lor possessione. Così Esaù fu padre degl'Idumei. ");
INSERT INTO ita1885_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","OR Giacobbe abitò nel paese dove suo padre era andato peregrinando, nel paese di Canaan. ");
INSERT INTO ita1885_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","E le generazioni di Giacobbe furono quelle. Giuseppe, essendo giovane, d'età di diciassette anni, pasturava le gregge, coi suoi fratelli, co' figliuoli di Bilha, e coi figliluoli di Zilpa, mogli di suo padre. Ed egli rapportava al padre loro la mala fama che andava attorno di loro. ");
INSERT INTO ita1885_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Or Israele amava Giuseppe più che tutti gli altri suoi figliuoli; perciocchè gli era nato nella sua vecchiezza, e gli fece una giubba vergata. ");
INSERT INTO ita1885_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","E i suoi fratelli, veggendo che il padre loro l'amava più che tutti i suoi fratelli, l'odiavano, e non potevano parlar con lui in pace. ");
INSERT INTO ita1885_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","E Giuseppe sognò un sogno, ed egli lo raccontò a' suoi fratelli; ed essi l'odiarono vie maggiormente. ");
INSERT INTO ita1885_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Egli adunque disse loro: Deh! udite questo sogno che io ho sognato. ");
INSERT INTO ita1885_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ecco, noi legavamo i covoni in mezzo di un campo; ed ecco, il mio covone si levò su, ed anche si tenne ritto; ed ecco, i vostri covoni furon d'intorno al mio covone, e gli s'inchinarono. ");
INSERT INTO ita1885_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","E i suoi fratelli gli dissero: Regneresti tu pur sopra noi? signoreggeresti tu pur sopra noi? Essi adunque l'odiarono vie maggiormente per i suoi sogni, e per le sue parole. ");
INSERT INTO ita1885_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ed egli sognò ancora un altro sogno, e lo raccontò a' suoi fratelli, dicendo: Ecco, io ho sognato ancora un sogno: ed ecco, il sole, e la luna, ed undici stelle, mi s'inchinavano. ");
INSERT INTO ita1885_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ed egli lo raccontò a suo padre, e a' suoi fratelli. E suo padre lo sgridò, e gli disse: Quale è questo sogno che tu hai sognato? avremo noi, io, e tua madre, e i tuoi fratelli, pure a venire ad inchinarci a te a terra? ");
INSERT INTO ita1885_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","E i suoi fratelli gli portavano invidia; ma suo padre riserbava appo sè queste parole. ");
INSERT INTO ita1885_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Or i suoi fratelli andarono a pasturar le gregge del padre loro in Sichem. ");
INSERT INTO ita1885_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ed Israele disse a Giuseppe: I tuoi fratelli non pasturano essi in Sichem? Vieni, ed io ti manderò a loro. Ed egli disse: Eccomi. ");
INSERT INTO ita1885_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ed esso gli disse: Or va', e vedi se i tuoi fratelli, e le gregge, stanno bene, e rapportamelo. Così lo mandò dalla valle di Hebron; ed egli venne in Sichem. ");
INSERT INTO ita1885_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Ed un uomo lo trovò ch'egli andava errando per li campi; e quell'uomo lo domandò, e gli disse: Che cerchi? ");
INSERT INTO ita1885_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ed egli disse: Io cerco i miei fratelli; deh! insegnami dove essi pasturano. ");
INSERT INTO ita1885_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","E quell'uomo gli disse: Essi son partiti di qui; perciocchè io li udii che dicevano: Andamocene in Dotain. Giuseppe adunque andò dietro a' suoi fratelli, e li trovò in Dotain. ");
INSERT INTO ita1885_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ed essi lo videro da lungi; ed avanti che si appressasse a loro, macchinarono contro a lui, per ucciderlo. ");
INSERT INTO ita1885_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","E dissero l'uno all'altro: Ecco cotesto sognatore viene. ");
INSERT INTO ita1885_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ora dunque venite, ed uccidiamolo; e poi gittiamolo in una di queste fosse; e noi diremo che una mala bestia l'ha divorato; e vedremo che diverranno i suoi sogni. ");
INSERT INTO ita1885_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ma Ruben, udendo questo, lo riscosse dalle lor mani, e disse: Non percotiamolo a morte. ");
INSERT INTO ita1885_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ruben ancora disse loro: Non ispandete il sangue; gittatelo in quella fossa ch'è nel deserto, ma non gli mettete la mano addosso; per riscuoterlo dalle lor mani e per rimenarlo a suo padre. ");
INSERT INTO ita1885_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","E, quando Giuseppe fu venuto a' suoi fratelli, essi lo spogliarono della sua giubba, di quella giubba vergata ch'egli avea indosso. ");
INSERT INTO ita1885_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Poi lo presero, e lo gittarono in quella fossa: or la fossa era vota, e non vi era acqua alcuna dentro. ");
INSERT INTO ita1885_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Poi si assettarono per prender cibo, ed alzarono gli occhi, e videro una carovana d'Ismaeliti che veniva di Galaad, i cui cammelli erano carichi di cose preziose, di balsamo e di mirra; ed essi andavano per portar quelle cose in Egitto. ");
INSERT INTO ita1885_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","E Giuda disse a' suoi fratelli: Che guadagno faremo, quando avremo ucciso il nostro fratello, ed avremo occultato il suo sangue? ");
INSERT INTO ita1885_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Venite, vendiamolo a costesti Ismaeliti, e non mettiamogli la mano addosso; perciocchè egli è nostro fratello, nostra carne. E i suoi fratelli gli acconsentirono. ");
INSERT INTO ita1885_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","E come que' mercatanti Madianiti passavano, essi trassero e fecero salir Giuseppe fuor di quella fossa, e per venti sicli d'argento lo vendettero a quegl'Ismaeliti; ed essi lo menarono in Egitto. ");
INSERT INTO ita1885_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Or Ruben tornò alla fossa, ed ecco, Giuseppe non v'era più; ed egli stracciò i suoi vestimenti. ");
INSERT INTO ita1885_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","E tornò a' suoi fratelli, e disse: Il fanciullo non si trova; ed io, dove andrò io? ");
INSERT INTO ita1885_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ed essi presero la giubba di Giuseppe; e scannarono un becco, e tinsero quella col sangue. ");
INSERT INTO ita1885_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","E mandarono a portar quella giubba vergata al padre loro, ed a dirgli: Noi abbiam trovata questa giubba: riconosci ora se è la giubba del tuo figliuolo, o no. ");
INSERT INTO ita1885_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ed egli la riconobbe, e disse: Questa è la giubba del mio figliuolo; una mala bestia l'ha divorato; Giuseppe per certo è stato lacerato. ");
INSERT INTO ita1885_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","E Giacobbe stracciò i suoi vestimenti, e si mise un sacco sopra i lombi, e fece cordoglio del suo figliuolo per molti giorni. ");
INSERT INTO ita1885_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","E tutti i suoi figliuoli, e tutte le sue figliuole, si levarono per consolarlo; ma egli rifiutò di esser consolato, e disse: Certo io scenderò con cordoglio al mio figliuolo nel sepolcro. E suo padre lo pianse. ");
INSERT INTO ita1885_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","E que' Madianiti, menato Giuseppe in Egitto, lo vendettero a Potifarre, Eunuco di Faraone, Capitan delle guardie. ");
INSERT INTO ita1885_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","OR avvenne in quel tempo, che Giuda discese d'appresso a' suoi fratelli, e si ridusse ad albergare in casa di un uomo Adullamita, il cui nome era Hira. ");
INSERT INTO ita1885_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","E Giuda vide quivi una figliuola di un uomo Cananeo, il nome del quale era Sua; ed egli la prese per moglie, ed entrò da lei. ");
INSERT INTO ita1885_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ed ella concepette e partorì un figliuolo, al quale Giuda pose nome Er. ");
INSERT INTO ita1885_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Poi ella concepette ancora, e partorì un figliuolo, e gli pose nome Onan. ");
INSERT INTO ita1885_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ed ella partorì ancora un figliuolo, e gli pose nome Sela; or Giuda era in Chezib, quando ella lo partorì. ");
INSERT INTO ita1885_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","E Giuda prese una moglie ad Er, suo primogenito, il cui nome era Tamar. ");
INSERT INTO ita1885_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ma Er, primogenito di Giuda, dispiacque al Signore, e il Signore lo fece morire. ");
INSERT INTO ita1885_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","E Giuda disse ad Onon: Entra dalla moglie del tuo fratello, e sposala per ragion di consanguinità, e suscita progenie al tuo fratello. ");
INSERT INTO ita1885_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ma Onan, sapendo che quella progenie non sarebbe sua, quando entrava dalla moglie del suo fratelo, si corrompeva in terra, per non dar progenie al suo fratello. ");
INSERT INTO ita1885_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","E ciò ch'egli faceva dispiacque al Signore; ed egli fece morire ancora lui. ");
INSERT INTO ita1885_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","E Giuda disse a Tamar, sua nuora: Stattene vedova in casa di tuo padre, finchè Sela, mio figliuolo, sia divenuto grande; perciocchè egli diceva: E' si convien provvedere che costui ancora non muoia, come i suoi fratelli. Tamar adunque se ne andò, e dimorò in casa di suo padre. ");
INSERT INTO ita1885_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","E, dopo molti giorni, morì la figliuola di Sua, moglie di Giuda; e, dopo che Giuda si fu consolato, salì in Timna, con Hira Adullamita, suo famigliare amico, a' tonditori delle sue pecore. ");
INSERT INTO ita1885_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ed e' fu rapportato a Tamar, e detto: Ecco, il tuo suocero sale in Timna, per tonder le sue pecore. ");
INSERT INTO ita1885_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Allora ella si levò d'addosso gli abiti suoi vedovili, e si coperse di un velo, e se ne turò il viso, e si pose a sedere alla porta di Enaim, ch'è in sulla strada, traendo verso Timna; perciocchè vedeva che Sela era divenuto grande, e pure ella non gli era data per moglie. ");
INSERT INTO ita1885_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","E Giuda la vide, e stimò lei essere una meretrice; conciossiachè ella avesse coperto il viso. ");
INSERT INTO ita1885_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","E, stornatosi verso lei in su la via, le disse: Deh! permetti che io entri da te (perciocchè egli non sapeva ch'ella fosse sua nuora). Ed ella gli disse: Che mi darai, perchè tu entri da me? ");
INSERT INTO ita1885_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ed egli le disse: Io ti manderò un capretto della greggia. Ed ella disse: Mi darai tu un pegno, finchè tu me l'abbi mandato? ");
INSERT INTO ita1885_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ed egli disse: Qual pegno ti darò io? Ed ella disse: Il tuo suggello, e la tua benda, e il tuo bastone che tu hai in mano. Ed egli le diede quelle cose, ed entrò da lei, ed ella concepette di lui. ");
INSERT INTO ita1885_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Poi si levò, e se ne andò, e si levò d'addosso il suo velo, e si rivestì i suoi abiti vedovili. ");
INSERT INTO ita1885_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","E Giuda mandò il capretto per le mani di quell'Adullamita, suo famigliare amico, per ritrarre il pegno da quella donna; ma egli non la trovò. ");
INSERT INTO ita1885_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","E ne domandò gli uomini del luogo dove era stata, dicendo: Dove è quella meretrice ch'era alla porta di Enaim in sulla strada? Ed essi risposero: Qui non è stata alcuna meretrice. ");
INSERT INTO ita1885_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ed egli se ne ritornò a Giuda, e gli disse: Io non ho trovata colei; ed anche gli uomini di quel luogo mi hanno detto: Qui non è stata alcuna meretrice. ");
INSERT INTO ita1885_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","E Giuda disse: Tengasi pure il pegno, che talora noi non siamo in isprezzo: ecco, io le ho mandato questo capretto; ma tu non l'hai trovata. ");
INSERT INTO ita1885_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Or intorno a tre mesi appresso, fu rapportato, e detto a Guida: Tamar, tua nuora, ha fornicato, ed anche ecco, è gravida di fornicazione. E Giuda disse: Menatela fuori, e sia arsa. ");
INSERT INTO ita1885_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Come era menata fuori, mandò a dire al suo suocero: Io son gravida di coliu al quale appartengono queste cose. Gli mandò ancora a dire: Riconosci ora di cui è questo suggello, e queste bende, e questo bastone. ");
INSERT INTO ita1885_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","E Giuda riconobbe quelle cose, e disse: Ell'è più giusta di me; conciossiachè ella abbia fatto questo, perciocchè io non l'ho data per moglie a Sela, mio figliuolo. Ed egli non la conobbe più da indi innanzi. ");
INSERT INTO ita1885_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Or avvenne che al tempo ch'ella dovea partorire, ecco, avea due gemelli in corpo. ");
INSERT INTO ita1885_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","E, mentre partoriva, l'uno porse la mano; e la levatrice la prese, e vi legò dello scarlatto sopra, dicendo: Costui è uscito il primo. ");
INSERT INTO ita1885_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ma avvenne ch'egli ritrasse la mano; ed ecco, il suo fratello uscì fuori; e la levatrice disse: Qual rottura hai tu fatta? la rottura sia sopra te; e gli fu posto nome Fares. ");
INSERT INTO ita1885_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Poi uscì il suo fratello che avea lo scarlatto sopra la mano; e gli fu posto nome Zara. ");
INSERT INTO ita1885_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","ORA, essendo stato Giuseppe menato in Egitto, Potifarre, Eunuco di Faraone, Capitan delle guardie, uomo Egizio, lo comperò da quegl'Ismaeliti, che l'aveano menato. ");
INSERT INTO ita1885_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","E il Signore fu con Giuseppe; e fu uomo che andava prosperando; e stette in casa del suo signore Egizio. ");
INSERT INTO ita1885_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","E il suo signore vide che il Signore era con lui, e che il Signore gli prosperava nelle mani tutto ciò ch'egli faceva. ");
INSERT INTO ita1885_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Laonde Giuseppe venne in grazia di esso, e gli serviva; ed egli lo costituì sopra tutta la sua casa, e gli diede in mano tuto ciò ch'egli avea. ");
INSERT INTO ita1885_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","E da che quell'Egizio l'ebbe costituito sopra la sua casa, e sopra tutto ciò ch'egli avea, il Signore benedisse la casa di esso, per amor di Giuseppe; e la benedizione del Signore fu sopra tutto ciò ch'egli avea in casa, e ne' campi. ");
INSERT INTO ita1885_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ed egli rimise nelle mani di Giuseppe tutto ciò ch'egli avea, e non tenea ragion con lui di cosa alcuna, salvo del suo mangiare. Or Giuseppe era formoso, e di bell'aspetto. ");
INSERT INTO ita1885_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ed avvenne, dopo queste cose, che la moglie del signore di Giuseppe gli pose l'occhio addosso, e gli disse: Giaciti meco. ");
INSERT INTO ita1885_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ma egli il ricusò, e disse alla moglie del suo signore: Ecco, il mio signore non tiene ragione meco di cosa alcuna che sia in casa, e mi ha dato in mano tutto ciò ch'egli ha. ");
INSERT INTO ita1885_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Egli stesso non è più grande di me in questa casa, e non mi ha divietato null'altro che te; perciocchè tu sei sua moglie; come dunque farei questo gran male, e peccherei contro a Dio? ");
INSERT INTO ita1885_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","E, benchè ella gliene parlasse ogni giorno, non però le acconsentì di giacerlesi allato, per esser con lei. ");
INSERT INTO ita1885_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Or avvenne un giorno, che, essendo egli entrato in casa per far sue faccende, e non essendovi alcuno della gente di casa ivi in casa; ");
INSERT INTO ita1885_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ella, presolo per lo vestimento, gli disse: Giaciti meco. Ma egli, lasciatole il suo vestimento in mano, se ne fuggì, e se ne uscì fuori. ");
INSERT INTO ita1885_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","E, quando ella vide ch'egli le avea lasciato il suo vestimento in mano, e che se ne era fuggito fuori; ");
INSERT INTO ita1885_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","chiamò la gente di casa sua, e disse loro: Vedete, egli ci ha menato in casa un uomo Ebreo per ischernirci; esso venne a me per giacersi meco; ma io gridai ad alta voce. ");
INSERT INTO ita1885_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","E come egli udì che io avea alzata la voce, e gridava, lasciò il suo vestimento appresso a me, e se ne fuggì, e se ne uscì fuori. ");
INSERT INTO ita1885_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ed ella ripose il vestimento di Giuseppe appo sè, finchè il signore di esso fosse tornato in casa sua. ");
INSERT INTO ita1885_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Poi gli parlò in questa maniera: Quel servo Ebreo che tu ci menasti venne a me per ischernirmi. ");
INSERT INTO ita1885_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ma, come io ebbi alzata la voce, ed ebbi gridato, egli lasciò il suo vestimento appresso a me, e se ne fuggì fuori. ");
INSERT INTO ita1885_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","E quando il signore di Giuseppe ebbe intese le parole che sua moglie gli diceva, cioè: Il tuo servo mi ha fatte cotali cose, si accese nell'ira. ");
INSERT INTO ita1885_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","E il signore di Giuseppe lo prese, e lo mise nel Torrione, ch'era il luogo dove i prigioni del re erano incarcerati; ed egli fu ivi nel Torrione. ");
INSERT INTO ita1885_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","E il Signore fu con Giuseppe, e spiegò la sua benignità inverso lui, e lo rendette grazioso al carceriere. ");
INSERT INTO ita1885_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","E il carceriere diede in mano a Giuseppe tutti i prigioni ch' erano nel Torrione; ed egli faceva tutto ciò che vi si avea a fare. ");
INSERT INTO ita1885_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Il carceriere non riguardava a cosa alcuna ch'egli avesse nelle mani; perciocchè il Signore era con lui; e il Signore prosperava tutto quello ch'egli faceva. ");
INSERT INTO ita1885_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","OR, dopo queste cose, avvenne che il coppiere del re di Egitto, e il panatiere, peccarono contro al re di Egitto, lor signore. ");
INSERT INTO ita1885_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","E Faraone si crucciò gravemente contro a que' suoi due Eunuchi, cioè: contro al coppier maggiore, e contro al panattier maggiore. ");
INSERT INTO ita1885_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","E li fece mettere in prigione in casa del Capitan delle guardie, nel Torrione, nello stesso luogo ove Giuseppe era incarcerato. ");
INSERT INTO ita1885_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","E il Capitan delle guardie commise a Giuseppe d'esser con loro; ed egli li serviva. Ed essi furono un anno in prigione. ");
INSERT INTO ita1885_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ed amendue, il coppiere ed il panattiere del re di Egitto, ch' erano incarcerati nel Torrione, sognarono ciascuno un sogno in una stessa notte, conveniente alla interpretazione che ne fu data a ciascun d'essi. ");
INSERT INTO ita1885_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","E Giuseppe, venuto la mattina a loro, li riguardò; ed ecco, erano conturbati. ");
INSERT INTO ita1885_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ed egli domandò quegli Eunuchi di Faraone, ch'erano seco in prigione, in casa del suo signore, dicendo: Perchè sono oggi le vostre facce meste? ");
INSERT INTO ita1885_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ed essi gli dissero: Noi abbiam sognato ciascuno un sogno, e non vi è alcuno che ce lo interpreti. E Giuseppe disse loro: Le interpretazioni non appartengono esse a Dio? deh! raccontatemeli. ");
INSERT INTO ita1885_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","E il coppier maggiore raccontò a Giuseppe il suo sogno, e gli disse: E' mi pareva nel mio sogno di veder davanti a me una vite. ");
INSERT INTO ita1885_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","E in quella vite erano tre tralci; e parve ch'ella germogliasse, poi che fiorisse, ed in fine che i suoi grappoli maturassero le uve. ");
INSERT INTO ita1885_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ed io avea la coppa di Faraone in mano; e prendeva quelle uve, e le spremeva nella coppa di Faraone, e dava la coppa in mano a Faraone. ");
INSERT INTO ita1885_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","E Giuseppe gli disse: Quest'è l'interpretazione di cotesto sogno: I tre tralci son tre giorni. ");
INSERT INTO ita1885_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Fra qui e tre giorni, Faraone, rivedendo la sua famiglia, ti rassegnerà, e ti rimetterà nel tuo stato; e tu porgerai in mano a Faraone la sua coppa, secondo il tuo primiero ufficio, quando eri suo coppiere. ");
INSERT INTO ita1885_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ma abbi appo te memoria di me, quando avrai del bene; ed usa, ti prego, benignità inverso me, e fa' menzion di me a Faraone, e fa' che io esca fuor di questa casa. ");
INSERT INTO ita1885_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Perciocchè in verità io sono stato rubato dal paese degli Ebrei; ed anche qui non ho fatto nulla, perchè io dovessi esser messo in questa fossa. ");
INSERT INTO ita1885_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","E il panattier maggiore, veggendo che Giuseppe avea interpretato il sogno di colui in bene, disse a Giuseppe: A me ancora pareva nel mio sogno di aver tre panieri bianchi in su la testa. ");
INSERT INTO ita1885_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","E nel più alto paniere vi erano di tutte le vivande di Faraone, di lavoro di fornaio; e gli uccelli le mangiavano di dentro quel paniere d'in sul mio capo. ");
INSERT INTO ita1885_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","E Giuseppe rispose, e disse: Questa è l'interpretazione di cotesto sogno: I tre panieri son tre giorni. ");
INSERT INTO ita1885_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Fra qui e tre giorni, Faraone, rivedendo la sua famiglia, ti casserà e ti torrà il tuo ufficio, e ti farà appiccare ad un legno, e gli uccelli ti mangeranno la carne d'addosso. ");
INSERT INTO ita1885_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ed egli avvenne il terzo giorno appresso, ch'era il giorno della natività di Faraone, ch'egli fece un convito a tutti i suoi servitori; e trovò fra' suoi servitori rassegnati, il coppier maggiore, e il panattier maggiore. ");
INSERT INTO ita1885_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ed egli rimise il coppier maggiore nel suo ufficio di coppiere; ed egli porse la coppa in mano a Faraone. ");
INSERT INTO ita1885_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ma fece appiccare il panattier maggiore, secondo l'interpretazione che Giuseppe avea lor data. ");
INSERT INTO ita1885_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","E il coppier maggiore non si ricordò di Giuseppe; anzi lo dimenticò. ");
INSERT INTO ita1885_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","ED avvenne, in capo di due anni intieri, che Faraone sognò, e gli pareva di essere presso al fiume. ");
INSERT INTO ita1885_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Ed ecco, dal fiume salivano sette vacche di bella apparenza, e grasse, e carnose, e pasturavano nella giuncaia. ");
INSERT INTO ita1885_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Poi ecco, dal fiume salivano sette altre vacche di brutta apparenza, e magre, e scarne; e si fermarono presso a quelle altre in su la riva del fiume. ");
INSERT INTO ita1885_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","E le vacche di brutta apparenza, e magre, e scarne, mangiarono le sette vacche di bella apparenza, e grasse. E Faraone si risvegliò. ");
INSERT INTO ita1885_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Poi, raddormentatosi, sognò di nuovo: ed ecco, sette spighe prospere, e belle, salivano da un gambo. ");
INSERT INTO ita1885_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Poi ecco, sette altre spighe minute, ed arse dal vento orientale, germogliavano dopo quelle. ");
INSERT INTO ita1885_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","E le spighe minute tranghiottirono le sette spighe prospere e piene. E Faraone si risvegliò; ed ecco un sogno. ");
INSERT INTO ita1885_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","E venuta la mattina, lo spirito suo fu conturbato; e mandò a chiamar tutti i Magi ed i Savi d'Egitto, e racontò loro i suoi sogni; ma non vi fu alcuno che li potesse interpretare a Faraone. ");
INSERT INTO ita1885_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Allora il coppier maggiore parlò a Faraone, dicendo: Io mi rammemoro oggi i miei falli. ");
INSERT INTO ita1885_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Faraone si crucciò già gravemente contro a' suoi servitori, e mise me e il panattier maggiore in prigione, in casa del Capitan delle guardie. ");
INSERT INTO ita1885_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","E sognammo egli ed io, in una stessa notte ciascuno un sogno; noi sognammo ciascuno il suo sogno, conveniente all'interpretazione che ne fu data. ");
INSERT INTO ita1885_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Or quivi con noi era un giovane Ebreo, servitor del Capitan delle guardie, al quale noi raccontammo i nostri sogni, ed egli ce l'interpretò, dando la interpretazione a ciascuno secondo il suo sogno. ");
INSERT INTO ita1885_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ed avvenne che, secondo l'interpretazione ch'egli ci avea data, Faraone mi rimise nel mio stato, e fece appiccar quell'altro. ");
INSERT INTO ita1885_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Allora Faraone mandò a chiamar Giuseppe, il quale prestamente fu tratto fuor della fossa; ed egli si tondè, e si cambiò i vestimenti, e venne a Faraone. ");
INSERT INTO ita1885_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","E Faraone disse a Giuseppe: Io ho sognato un sogno, e non vi è niuno che l'interpreti; or io ho udito dir di te, che tu intendi i sogni, per interpretarli. ");
INSERT INTO ita1885_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","E Giuseppe rispose a Faraone, dicendo: V'è altri che me; Iddio risponderà ciò che sarà per la prosperità di Faraone. ");
INSERT INTO ita1885_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","E Faraone disse a Giuseppe: E' mi pareva nel mio sogno che io stava presso alla riva del fiume. ");
INSERT INTO ita1885_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ed ecco, dal fiume salivano sette vacche, grasse, e carnose, e di bella apparenza, e pasturavano nella giuncaia. ");
INSERT INTO ita1885_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Poi ecco, sette altre vacche salivano dietro a quelle, magre, e di bruttissima apparenza, e scarne; io non ne vidi mai di così misere in tutto il paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","E le vacche magre, e misere, mangiarono le sette prime vacche grasse. ");
INSERT INTO ita1885_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","E quelle entrarono loro in corpo; ma pur non se ne riconobbe nulla; conciossiachè fossero di così brutto aspetto, come prima. Ed io mi risvegliai. ");
INSERT INTO ita1885_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","E' mi parve ancora, sognando, veder sette spighe piene e belle, che salivano da un gambo. ");
INSERT INTO ita1885_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Poi ecco, sette altre spighe aride, minute, arse dal vento orientale, germogliarono dopo quelle. ");
INSERT INTO ita1885_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","E le spighe minute tranghiottirono le sette spighe belle. Or io ho detti questi sogni a' Magi; ma non vi è stato alcuno che me li abbia saputi dichiarare. ");
INSERT INTO ita1885_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Allora Giuseppe disse a Faraone: Ciò che ha sognato Faraone è una stessa cosa. Iddio ha significato a Faraone ciò ch'egli è per fare. ");
INSERT INTO ita1885_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Le sette vacche belle son sette anni; e le sette spighe belle sono altresì sette anni; l'uno e l'altro sogno sono una stessa cosa. ");
INSERT INTO ita1885_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Parimente, le sette vacche magre e brutte, che salivano dopo quelle, son sette anni; e le sette spighe vote, arse dal vento orientale, saranno sette anni di fame. ");
INSERT INTO ita1885_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Questo è quello che io ho detto a Faraone: Che Iddio ha mostrato a Faraone ciò ch'egli è per fare. ");
INSERT INTO ita1885_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ecco, vengono sette anni di grande abbondanza in tutto il paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Poi, dopo quelli, verranno sette anni di fame; e tutta quella abbondanza sarà dimenticata nel paese di Egitto; e la fame consumerà il paese. ");
INSERT INTO ita1885_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","E quell'abbondanza non si conoscerà nel paese, per cagion di quella fame che verrà appresso; perciocchè ella sarà molto aspra. ");
INSERT INTO ita1885_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","E quant'è a ciò che il sogno è stato reiterato per due volte a Faraone, ciò è avvenuto, perchè la cosa è determinata da Dio; e Iddio l'eseguirà tosto. ");
INSERT INTO ita1885_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Ora dunque provveggasi Faraone di un uomo intendente e savio, il quale egli costituisca sopra il paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Faraone faccia questo: Ordini de' commissari nel paese; e facciasi dare il quinto della rendita del paese di Egitto, ne' sette anni dell'abbondanza. ");
INSERT INTO ita1885_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","E adunino essi tutta la vittuaglia di questi sette buoni anni che vengono, e ammassino il grano sotto la mano di Faraone, per vittuaglia nella città; e lo conservino. ");
INSERT INTO ita1885_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","E quella vittuaglia sarà per provvisione del paese, ne' sette anni della fame che saranno nel paese di Egitto; e il paese non sarà distrutto per la fame. ");
INSERT INTO ita1885_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","E la cosa piacque a Faraone e a tutti i suoi servitori. ");
INSERT INTO ita1885_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","E Faraone disse a' suoi servitori: Potremmo noi trovare alcuno pari a costui, ch'è uomo in cui è lo Spirito di Dio? ");
INSERT INTO ita1885_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","E Faraone disse a Giuseppe: Poichè Iddio ti ha manifestato tutto questo, e' non vi è alcuno intendente, nè savio, come sei tu. ");
INSERT INTO ita1885_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Tu sarai sopra la mia casa, e tutto il mio popolo ti bacerà in bocca; io non sarò più grande di te, salvo che nel trono. ");
INSERT INTO ita1885_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Oltre a ciò, Faraone disse a Giuseppe: Vedi, io ti costituisco sopra tutto il paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","E Faraone si trasse il suo anello di mano, e lo mise in mano a Giuseppe, e lo fece vestir di vestimenti di bisso, e gli mise una collana d'oro al collo. ");
INSERT INTO ita1885_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","E lo fece salir sopra il carro della seconda persona del suo regno; e si gridava davanti a lui: Ognuno s'inginocchi; e ch'egli lo costituiva sopra tutto il paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Faraone disse ancora a Giuseppe: Io son Faraone; niuno leverà il piè, nè la mano, in tutto il paese di Egitto, senza te. ");
INSERT INTO ita1885_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","E Faraone pose nome a Giuseppe Safenatpaanea; e gli diede per moglie Asenat, figliuola di Potifera, Governatore di On. E Giuseppe andò attorno per lo paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","(Or Giuseppe era d'età di trent'anni, quando egli si presentò davanti a Faraone, re di Egitto.) Giuseppe adunque si partì dal cospetto di Faraone, e passò per tutto il paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","E la terra produsse a menate, ne' sette anni dell'abbondanza. ");
INSERT INTO ita1885_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","E Giuseppe adunò tutta la vittuaglia di quei sette anni, che furono nel paese di Egitto, e la ripose nelle città; egli ripose in ciascuna tutta la vittuaglia del contado circonvicino. ");
INSERT INTO ita1885_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Giuseppe adunque ammassò grano in grandissima quantità, come la rena del mare; tanto che si rimase di annoverarlo; perciocchè era innumerabile. ");
INSERT INTO ita1885_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ora, avanti che venisse il primo anno della fame, nacquero a Giuseppe due figliuoli; i quali Asenat, figliuola di Potifera, Governatore di On, gli partorì. ");
INSERT INTO ita1885_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","E Giuseppe pose nome al primogenito Manasse; perciocchè, disse egli, Iddio mi ha fatto dimenticare ogni affanno, e tutta la casa di mio padre. ");
INSERT INTO ita1885_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","E pose nome al secondo, Efraim; perciocchè, disse egli, Iddio mi ha fatto fruttare nel paese della mia afflizione. ");
INSERT INTO ita1885_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Poi, finiti i sette anni dell'abbondanza che fu nel paese di Egitto; ");
INSERT INTO ita1885_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","cominciarono a venire i sette anni della fame, siccome Giuseppe avea detto; e vi fu fame per tutti i paesi; ma per tutto Egitto vi era del pane. ");
INSERT INTO ita1885_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Alla fine tutto il paese di Egitto fu anch'esso affamato, e il popolo gridò a Faraone per del pane. E Faraone disse a tutti gli Egizj: Andate a Giuseppe, e fate ciò ch'egli vi dirà. ");
INSERT INTO ita1885_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ed essendo la fame per tutto il paese, Giuseppe aperse tutti i granai, e ne vendè agli Egizj. E la fame si aggravò nel paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Da ogni paese eziandio si veniva in Egitto a Giuseppe, per comperar del grano; perciocchè la fame si era aggravata per tutta la terra. ");
INSERT INTO ita1885_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","E GIACOBBE, veggendo che vi era del grano da vendere in Egitto, disse a' suoi figliuoli: Perchè state a riguardarvi l'un l'altro? ");
INSERT INTO ita1885_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Poi disse: Ecco, io ho udito che in Egitto v'è del grano da vendere; scendete là, e compratacene di là; e noi viveremo, e non morremo. ");
INSERT INTO ita1885_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","E dieci de' fratelli di Giuseppe scesero in Egitto, per comperar del grano di là. ");
INSERT INTO ita1885_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ma Giacobbe non mandò Beniamino, fratello di Giuseppe, co' suoi fratelli; perciocchè diceva: E' si convien guardare che talora alcuna mortale sciagura non gl'intervenga. ");
INSERT INTO ita1885_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","I figliuoli d'Israele adunque giunsero in Egitto, per comperar del grano, per mezzo altri che vi andavano; perciocchè la fame era nel paese di Canaan. ");
INSERT INTO ita1885_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Or Giuseppe, ch'era rettor del paese, vendeva il grano a ciascun popolo della terra. I fratelli di Giuseppe adunque, essendo giunti, s'inchinarono a lui, con la faccia verso terra. ");
INSERT INTO ita1885_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","E, come Giuseppe ebbe veduti i suoi fratelli, li riconobbe; ma pur s'infinse strano inverso loro, e parlò loro aspramente, e disse loro: Onde venite voi? Ed essi dissero: Dal paese di Canaan, per comperar della vittuaglia. ");
INSERT INTO ita1885_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Giuseppe adunque riconobbe i suoi fratelli, ma essi non riconobber lui. ");
INSERT INTO ita1885_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","E Giuseppe si ricordò de' sogni che egli avea sognati di loro, e disse loro: Voi siete spie; voi siete venuti per vedere i luoghi sforniti del paese. ");
INSERT INTO ita1885_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ma essi dissero: No, signor mio, anzi i tuoi servitori son venuti per comperar della vittuaglia. ");
INSERT INTO ita1885_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Noi siamo tutti figliuoli di uno stesso uomo; noi siamo uomini leali; i tuoi servitori non furono giammai spie. ");
INSERT INTO ita1885_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ed egli disse loro: No; anzi voi siete venuti per veder i luoghi sforniti del paese. ");
INSERT INTO ita1885_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ed essi dissero: Noi, tuoi servitori, eravamo dodici fratelli, figliuoli di uno stesso uomo, nel paese di Canaan; ed ecco, il minore è oggi con nostro padre, e uno non è più. ");
INSERT INTO ita1885_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","E Giuseppe disse loro: Quest'è pur quello che io vi ho detto, che voi siete spie. ");
INSERT INTO ita1885_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","E' si farà prova di voi in questo: Come vive Faraone, voi non partirete di qui, prima che il vostro fratel minore sia venuto qua. ");
INSERT INTO ita1885_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Mandate un di voi a prendere il vostro fratello; e voi restate qui incarcerati, e si farà prova delle vostre parole, se vi è in voi verità; se no, come vive Faraone, voi siete spie. ");
INSERT INTO ita1885_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","E li serrò in prigione, per tre dì. ");
INSERT INTO ita1885_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","E al terzo giorno, Giuseppe disse loro: Fate questo, e voi viverete; io temo Iddio. ");
INSERT INTO ita1885_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Se voi siete uomini leali uno di voi fratelli rimanga incarcerato nella prigione dove siete stati posti, e voi altri andate, portatene del grano, secondo la necessità delle vostre case. ");
INSERT INTO ita1885_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","E menatemi il vostro fratel minore, e così le vostre parole saranno verificate, e voi non morrete. Ed essi fecero così. ");
INSERT INTO ita1885_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","E dicevano l'uno all'altro: Certamente noi siamo colpevoli intorno al nostro fratello; perciocchè noi vedemmo l'angoscia dell'anima sua, quando egli ci supplicava, e non l'esaudimmo; perciò è avvenuta questa angoscia a noi. ");
INSERT INTO ita1885_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","E Ruben rispose loro, dicendo: Non vi diceva io: Non peccate contro al fanciullo? ma voi non mi voleste ascoltare; perciò altresì, ecco, è domandata ragion del suo sangue. ");
INSERT INTO ita1885_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Or essi non sapevano che Giuseppe li intendesse; perciocchè fra loro vi era un interprete. ");
INSERT INTO ita1885_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","E Giuseppe si rivoltò indietro da loro, e pianse. Poi ritornò a loro, e parlò loro, e prese d'infra loro Simeone, il quale egli fece incarcerare in lor presenza. ");
INSERT INTO ita1885_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Poi Giuseppe comandò che si empiessero di grano le lor sacca, e che si rimettessero i danari di ciascun d'essi nel suo sacco, e che si desse loro provvisione per lo viaggio. E così fu lor fatto. ");
INSERT INTO ita1885_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ed essi, caricato sopra i loro asini il grano che aveano comperato, si partirono di là. ");
INSERT INTO ita1885_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","E l'uno di essi, aperto il suo sacco, per dar della pastura al suo asino nell'albergo, vide i suoi danari ch'erano alla bocca del suo sacco. ");
INSERT INTO ita1885_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","E disse a' suoi fratelli: I miei danari mi sono stati restituiti; e anche eccoli nel mio sacco. E il cuore isvenne loro, e si spaventarono, dicendo l'uno all'altro: Che cosa è questo che Iddio ci ha fatto? ");
INSERT INTO ita1885_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Poi, venuti a Giacobbe, lor padre, nel paese di Canaan, gli raccontarono tutte le cose ch'erano loro intervenute, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Quell'uomo, che è rettor del paese, ci ha parlato aspramente, e ci ha trattati da spie del paese. ");
INSERT INTO ita1885_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","E noi gli abbiam detto: Noi siamo uomini leali; noi non fummo giammai spie. ");
INSERT INTO ita1885_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Noi eravamo dodici fratelli, figliuoli di nostro padre, e l'uno non è più; e il minore è oggi con nostro padre, nel paese di Canaan. ");
INSERT INTO ita1885_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","E quell'uomo, rettor del paese, ci ha detto: Per questo conoscerò che voi siete uomini leali: lasciate un di voi fratelli appo me, e prendete quanto vi fa bisogno per la necessità delle vostre casa, e andate. ");
INSERT INTO ita1885_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","E menatemi il vostro fratel minore; ed io conoscerò che voi non siete spie, anzi uomini leali; ed io vi renderò il vostro fratello, e voi potrete andare attorno trafficando per lo paese. ");
INSERT INTO ita1885_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ora, come essi votavano le lor sacca, ecco, il sacchetto de' denari di ciascuno era nel suo sacco; ed essi, e il padre loro, videro i sacchetti de' lor danari, e temettero. ");
INSERT INTO ita1885_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","E Giacobbe, lor padre, disse loro: Voi mi avete orbato di figliuoli; Giuseppe non è più, Simeone non è più, e ancora volete tormi Beniamino; tutte queste cose son contro a me. ");
INSERT INTO ita1885_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","E Ruben disse a suo padre: Fa' morire i miei due figliuoli, se io non te lo riconduco; rimettilo nelle mie mani, ed io te lo ricondurrò. ");
INSERT INTO ita1885_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ma Giacobbe disse: Il mio figliuolo non iscenderà con voi; perciocche il suo fratello è morto, ed egli è rimasto solo; e, se gli avvenisse alcuna mortale sciagura per lo viaggio che farete, voi fareste scender la mia canutezza con cordoglio nel sepolcro. ");
INSERT INTO ita1885_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","OR la fame era grave nel paese. ");
INSERT INTO ita1885_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","E, dopo ch'essi ebber finito di mangiare il grano che aveano portato di Egitto, il padre loro disse loro: Tornate a comperarci un poco di vittuaglia. ");
INSERT INTO ita1885_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","E Giuda gli disse: Quell'uomo ci ha espressamente protestato, e detto: Voi non vedrete la mia faccia, che il vostro fratello non sia con voi. ");
INSERT INTO ita1885_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Se tu mandi il nostro fratello con noi, noi scenderemo, e ti compreremo della vittuaglia. ");
INSERT INTO ita1885_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ma, se pur tu non vel mandi, noi non iscenderemo; perciocchè quell'uomo ci ha detto: Voi non vedrete la mia faccia, che il vostro fratello non sia con voi. ");
INSERT INTO ita1885_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","E Israele disse: Perchè mi avete voi fatto questa offesa, di dichiarare a quell'uomo che avevate ancora un fratello? ");
INSERT INTO ita1885_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ed essi dissero: Quell'uomo ci domandò partitamente di noi, e del nostro parentado, dicendo: Il padre vostro vive egli ancora? avete voi alcun altro fratello? E noi gliene demmo contezza, secondo quelle parole; potevamo noi in alcun modo sapere ch'egli direbbe: Fate venire il vostro fratello? ");
INSERT INTO ita1885_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","E Giuda disse a Israele, suo padre: Lascia venire il giovane meco, e noi ci leveremo, e andremo, e viveremo, e non morremo, e noi, e tu, e le nostre famiglie. ");
INSERT INTO ita1885_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Io te lo sicuro; ridomandalo dalla mia mano; se io non tel riconduco, e non tel rappresento, io sarò colpevole inverso te in perpetuo. ");
INSERT INTO ita1885_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Che se non ci fossimo indugiati, certo ora saremmo già ritornati due volte. ");
INSERT INTO ita1885_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","E Israele, lor padre, disse loro: Se pur qui così bisogna fare, fate questo: Prendete delle più isquisite cose di questo paese nelle vostre sacca, e portatene un presente a quell'uomo; un poco di balsamo, e un poco di mele, e degli aromati, e della mirra, e de' pinocchi, e delle mandorle. ");
INSERT INTO ita1885_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","E pigliate in mano danari al doppio; riportate eziandio i danari che vi furono rimessi alla bocca de' vostri sacchi; forse fu errore. ");
INSERT INTO ita1885_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","E prendete il vostro fratello, e levatevi e ritornate a quell'uomo. ");
INSERT INTO ita1885_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","E facciavi l'Iddio Onnipotente trovar pietà appo quell'uomo, sì ch'egli vi rilasci il vostro altro fratello, e Beniamino; e se pure io sarò orbato di figliuoli, sialo. ");
INSERT INTO ita1885_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Quegli uomini adunque presero quel presente; presero eziandio danari al doppio, e Beniamino; e, levatisi, scesero in Egitto, e si presentarono davanti a Giuseppe. ");
INSERT INTO ita1885_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","E Giuseppe, veggendo Beniamino con loro, disse al suo mastro di casa: Mena questi uomini dentro alla casa, e ammazza delle carni e apparecchiale; perciocchè questi uomini mangeranno meco a meriggio. ");
INSERT INTO ita1885_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","E colui fece come Giuseppe avea detto, e menò quegli uomini dentro alla casa di Giuseppe. ");
INSERT INTO ita1885_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","E quegli uomini temettero, perciocchè erano menati dentro alla casa di Giuseppe, e dissero: Noi siamo menati qua entro per que' danari che ci furono tornati ne' nostri sacchi la prima volta; acciocchè egli si rivolti addosso a noi, e si avventi contro a noi, e ci prenda per servi, insieme co' nostri asini. ");
INSERT INTO ita1885_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","E accostatisi al mastro di casa di Giuseppe, gli parlarono in su l'entrata della casa. ");
INSERT INTO ita1885_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","E dissero: Ahi, signor mio! certo da principio noi scendemmo per comperar della vittuaglia. ");
INSERT INTO ita1885_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Or avvenne, come fummo giunti all'albergo, che, aprendo i nostri sacchi, ecco, i danari di ciascun di noi erano alla bocca del suo sacco; i nostri danari vi erano appunto secondo il lor peso; e noi li abbiamo riportati con noi. ");
INSERT INTO ita1885_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Abbiamo, oltre a ciò, portati nelle nostre mani altri danari per comperar della vittuaglia; noi non sappiamo chi mettesse i nostri danari ne' nostri sacchi. ");
INSERT INTO ita1885_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ed egli disse loro: Datevi pace; non temiate; l'Iddio vostro, e l'Iddio del padre vostro, ha messo un tesoro ne' vostri sacchi; i vostri danari mi vennero in mano. ");
INSERT INTO ita1885_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Poi trasse lor fuori Simeone. E, menatili dentro alla casa di Giuseppe, fece portar dell'acqua, ed essi si lavarono i piedi; ed egli diede della pastura ai loro asini. ");
INSERT INTO ita1885_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","E aspettando che Giuseppe venisse a meriggio, essi apparecchiarono quel presente; perciocchè aveano inteso che resterebbero quivi a mangiare. ");
INSERT INTO ita1885_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","E quando Giuseppe fu venuto in casa, essi gli porsero quel presente che aveano in mano, dentro alla casa; e gli s'inchinarono fino in terra. ");
INSERT INTO ita1885_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","E egli li domandò del lor bene stare, e disse: Il padre vostro, quel vecchio di cui mi parlaste, sta egli bene? vive egli ancora? ");
INSERT INTO ita1885_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ed essi dissero: Nostro padre, tuo servitore, sta bene; egli vive ancora. E s'inchinarono, e gli fecero riverenza. ");
INSERT INTO ita1885_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","E Giuseppe alzò gli occhi, e vide Beniamino, suo fratello, figliuol di sua madre, e disse: È costui il vostro fratel minore, del qual mi parlaste? Poi disse: Iddio ti sia favorevole, figliuol mio. ");
INSERT INTO ita1885_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","E Giuseppe si ritrasse prestamente; perciocchè le sue viscere si riscaldavano inverso il suo fratello; e cercando luogo per piangere, se n'entrò nella cameretta, e quivi pianse. ");
INSERT INTO ita1885_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Poi, lavatosi il viso, uscì fuori, e si fece forza, e disse: Recate le vivande. ");
INSERT INTO ita1885_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Furono adunque recate le vivande a lui da parte, a loro da parte, e agli Egizj che mangiavano con lui da parte; conciossiachè gli Egizj non possano mangiare con gli Ebrei; perciocchè ciò è cosa abbominevole agli Egizj. ");
INSERT INTO ita1885_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Essi adunque si posero a sedere nel suo cospetto, il primogenito, secondo l'ordine suo di primogenito; e il minore, secondo l'ordine della sua età minore; e quegli uomini, maravigliandosi, si riguardavano l'un l'altro. ");
INSERT INTO ita1885_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ed egli prese de' messi delle vivande d'appresso a sè, e le mandò loro; e la parte di Beniamino fu cinque volte maggiore di quella di qualunque altro di loro. Ed essi bevvero, e goderono con lui. ");
INSERT INTO ita1885_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","E GIUSEPPE comandò, e disse al suo mastro di casa: Empi le sacca di questi uomini di vittuaglia, quanto essi ne potranno portare; e rimetti i danari di ciascuno di essi alla bocca del suo sacco. ");
INSERT INTO ita1885_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Metti eziandio la mia coppa, quella coppa di argento, alla bocca del sacco del minore, insieme co' danari del suo grano. Ed egli fece come Giuseppe gli avea detto. ");
INSERT INTO ita1885_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","In su lo schiarir della mattina, quegli uomini furono accommiatati co' loro asini. ");
INSERT INTO ita1885_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Essendo usciti fuor della città, e non essendo ancora lungi, Giuseppe disse al suo mastro di casa: Levati, persegui quegli uomini; e, quando tu li avrai aggiunti, di' loro: Perchè avete voi renduto mal per bene? ");
INSERT INTO ita1885_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Non è quella la coppa, nella quale il mio signore suol bere, per la quale egli suole indovinare? voi avete malvagiamente operato in ciò che avete fatto. ");
INSERT INTO ita1885_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Egli adunque li raggiunse, e disse loro quelle parole. ");
INSERT INTO ita1885_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ed essi gli dissero: Perchè dice il mio signore cotali parole? tolga Iddio che i tuoi servitori facciano una cotal cosa. ");
INSERT INTO ita1885_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ecco, noi ti riportammo dal paese di Canaan i danari che avevamo trovati alle bocche delle nostre sacca; come dunque avremmo noi rubato della casa del tuo signore oro od argento? ");
INSERT INTO ita1885_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Muoia colui de' tuoi servitori, appo il quale quella coppa sarà trovata; e oltre a ciò noi saremo servi al mio signore. ");
INSERT INTO ita1885_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ed egli disse: Quantunque ora fosse ragionevole di far secondo le vostre parole, pur nondimeno colui solo appo il quale ella sarà trovata, mi sarà servo, e voi altri sarete sciolti. ");
INSERT INTO ita1885_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","E ciascun d'essi mise giù il suo sacco in terra, e l'aperse. ");
INSERT INTO ita1885_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","E il maestro di casa li frugò tutti, cominciando dal sacco del maggiore, e finendo a quel del minore; e la coppa fu ritrovata nel sacco di Beniamino. ");
INSERT INTO ita1885_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Allora essi stracciarono i lor vestimenti; e, caricato ciascuno il suo asino, tornarono nella città. ");
INSERT INTO ita1885_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","E Giuda, co' suoi fratelli, entrò nella casa di Giuseppe, il quale era ancora quivi; ed essi si gittarono in terra davanti a lui. ");
INSERT INTO ita1885_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","E Giuseppe disse loro: Quale è questo atto che voi avete fatto? non sapete voi che un par mio per certo indovina? ");
INSERT INTO ita1885_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","E Giuda disse: Che diremo al mio signore? quali parole useremo? e come ci giustificheremo noi? Iddio ha ritrovata l'iniquità de' tuoi servitori; ecco, noi siamo servi al mio signore, così noi altri, come colui appo il quale è stata ritrovata la coppa. ");
INSERT INTO ita1885_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ma Giuseppe disse: Tolga Iddio che io faccia questo; colui, appo il quale è stata trovata la coppa, mi sia servo, e voi altri ritornatevene in pace a vostro padre. ");
INSERT INTO ita1885_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","E Giuda gli si accostò, e disse: Ahi! signor mio: deh! lascia che il tuo servitore dica una parola al mio signore, e non accendasi la tua ira contro al tuo servitore; conciossiachè tu sii appunto come Faraone. ");
INSERT INTO ita1885_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Il mio signore domandò i suoi servitori, dicendo: Avete voi padre o fratello? ");
INSERT INTO ita1885_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Enoi: dicemmo al mio signore: Noi abbiamo un padre vecchio, e un giovane piccol fratello, nato a nostro padre nella sua vecchiezza, e il suo fratello è morto; talchè egli è rimasto solo di sua madre, e suo padre l'ama. ");
INSERT INTO ita1885_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Allora tu dicesti a' tuoi servitori: Menatemelo, ed io porrò l'occhio mio sopra lui. ");
INSERT INTO ita1885_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","E noi dicemmo al mio signore: Il fanciullo non può lasciar suo padre; perciocchè s'egli lo lasciasse, suo padre morrebbe. ");
INSERT INTO ita1885_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","E tu dicesti a' tuoi servitori: Se il vostro fratel minore non iscende con voi, voi non vedrete più la mia faccia. ");
INSERT INTO ita1885_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Come dunque fummo ritornati a mio padre, tuo servitore, gli rapportammo le parole del mio signore. ");
INSERT INTO ita1885_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Dipoi nostro padre disse: Tornate a comperarci un poco di vittuaglia. ");
INSERT INTO ita1885_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","E noi dicemmo: Noi non possiamo scender là; ma, se il nostro fratello minore è con noi, noi vi scenderemo; perciocchè noi non possiam veder la faccia di quell'uomo, se il nostro fratel minore non è con noi. ");
INSERT INTO ita1885_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","E mio padre, tuo servitore, ci disse: Voi sapete che mia moglie mi partorì due figliuoli. ");
INSERT INTO ita1885_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","L'uno de' quali, essendosi dipartito d'appresso a me, io ho detto: Certo egli del tutto è stato lacerato; ed io non l'ho veduto fino ad ora. ");
INSERT INTO ita1885_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","E se voi togliete ancora questo d'appresso a me, e gli avviene alcuna mortal sciagura, voi farete scender la mia canutezza con afflizione nel sepolcro. ");
INSERT INTO ita1885_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Ora dunque se, quando io giungerò a mio padre, tuo servitore, il fanciullo, alla cui anima la sua è legata, non è con noi; ");
INSERT INTO ita1885_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","egli avverrà che, come vedrà che il fanciullo non vi sarà, egli si morrà; e così i tuoi servitori avranno fatto scender la canutezza di nostro padre, tuo servitore, con cordoglio, nel sepolcro. ");
INSERT INTO ita1885_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ora, perciocchè il tuo servitore ha assicurato di questo fanciullo a mio padre, menandonelo d'appresso a lui, dicendo: Se io non te lo riconduco, io sarò colpevole inverso mio padre in perpetuo; ");
INSERT INTO ita1885_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","deh! lascia ora che il tuo servitore rimanga servo al mio signore, in luogo del fanciullo, e che il fanciullo se ne ritorni co' suoi fratelli. ");
INSERT INTO ita1885_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Perciocchè, come ritornerei io a mio padre, non essendo il fanciullo meco? Io non potrei farlo, che talora io non vedessi l'afflizione che ne avverrebbe a mio padre. ");
INSERT INTO ita1885_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","ALLORA Giuseppe, non potendo più farsi forza in presenza di tutti i circostanti, gridò: Facciasi uscire ognuno fuori d'appresso a me. E niuno restò con lui, quando egli si diede a conoscere a' suoi fratelli. ");
INSERT INTO ita1885_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ed egli diede un grido con pianto, e gli Egizj lo intesero; que' della casa di Faraone lo intesero anch'essi. ");
INSERT INTO ita1885_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","E Giuseppe disse a' suoi fratelli: Io son Giuseppe; mio padre vive egli ancora? Ma i suoi fratelli non gli potevano rispondere; perciocchè erano tutti sbigottiti della sua presenza. ");
INSERT INTO ita1885_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","E Giuseppe disse a' suoi fratelli: Deh! appressatevi a me. Ed essi si appressarono a lui. Ed egli disse: Io son Giuseppe, vostro fratello, il qual voi vendeste per esser menato in Egitto. ");
INSERT INTO ita1885_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ma ora non vi contristate, e non vi rincresca di avermi venduto per esser menato qua; conciossiachè Iddio mi abbia mandato davanti a voi per vostra conservazione. ");
INSERT INTO ita1885_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Perciocchè quest'è l'anno secondo della fame dentro del paese; e ve ne saranno ancora cinque, ne' quali non vi sarà nè aratura, nè mietitura. ");
INSERT INTO ita1885_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ma Iddio mi ha mandato davanti a voi, per far che abbiate alcun rimanente nella terra, e per conservarvelo in vita, per un grande scampo. ");
INSERT INTO ita1885_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ora dunque, non voi mi avete mandato qua, anzi Iddio; ed egli mi ha costituito per padre a Faraone, e per padrone sopra tutta la sua casa, e rettore in tutto il paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ritornatevene prestamente a mio padre, e ditegli: Così dice il tuo figliuolo Giuseppe: Iddio mi ha costituito rettor di tutto l'Egitto; scendi a me, non restare. ");
INSERT INTO ita1885_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","E tu dimorerai nella contrada di Gosen, e sarai presso di me, tu, e i tuoi figliuolo, e i figliuoli de'tuoi figliuoli e le tue gregge, e i tuoi armenti, e tutto ciò ch'è tuo. ");
INSERT INTO ita1885_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","E io ti sostenterò quivi, perciocchè vi saranno ancora cinque anni di fame; accioccè talora tu non sofferi necessità, tu, e la tua famiglia, e tutto ciò ch'è tuo. ");
INSERT INTO ita1885_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ed ecco, gli occhi vostri veggono, gli occhi del mio fratello Beniamino anch'essi veggono, che la mia bocca è quella che vi parla. ");
INSERT INTO ita1885_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Rapportate adunque a mio pardre tutta la gloria, nella quale io sono in Egitto, e tutto ciò che voi avete veduto; e fate prestamente venir qua mio padre. ");
INSERT INTO ita1885_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Poi, gittatosi al collo di Beniamino, suo fratello, pianse; Beniamino altresì pianse sopra il collo di esso. ");
INSERT INTO ita1885_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Baciò ancora tutti i suoi fratelli, e pianse sopra loro. E, dopo questo, i suoi fratelli parlarono con lui. ");
INSERT INTO ita1885_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","E il grido ne fu udito nella casa di Faraone, e fu detto: I fratelli di Giuseppe son venuti. E la cosa piacque a Faraone ed a' suoi servitori. ");
INSERT INTO ita1885_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","E Faraone disse a Giuseppe: Di' a' tuoi fratelli: Fate questo: caricate le vostre bestie, e andatevene; e, quando sarete giunti nel paese di Canaan, ");
INSERT INTO ita1885_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","prendete vostro padre, e le vostre famiglie, e venite a me; ed io vi darò il meglio del paese di Egitto, e voi mangerete il grasso del paese. ");
INSERT INTO ita1885_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","E a te, Giuseppe, è ordinato questo: fate ciò: prendete de' carri del paese di Egitto, per le vostre famiglie, e per le vostre mogli; e levate vostro padre, e venitevene. ");
INSERT INTO ita1885_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","E non vi rincresca di lasciar le vostre masserizie; perciocchè il meglio di tutto il paese di Egitto sarà vostro. ");
INSERT INTO ita1885_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","E i figliuoli d'Israele fecero così; e Giuseppe diede loro de' carri secondo il comandamento di Faraone; diede loro ancora provvisione per lo viaggio. ");
INSERT INTO ita1885_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Diede eziandio a ciascun d'essi tutti delle mute di vestimenti; e a Beniamino diede trecento sicli di argento, e cinque mute di vestimenti. ");
INSERT INTO ita1885_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","E a suo padre mandò questo: dieci asini carichi delle migliori cose di Egitto; e dieci asine cariche di grano, e di pane, e di vittuaglia, per suo padre, per lo viaggio. ");
INSERT INTO ita1885_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","E diede commiato a' suoi fratelli, ed essi se ne andarono. Ed egli disse loro: Non vi crucciate per cammino. ");
INSERT INTO ita1885_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ed essi se ne ritornarono di Egitto; e vennero nel paese di Canaan, a Giacobbe, lor padre. ");
INSERT INTO ita1885_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","E gli rapportarono la cosa, dicendo: Giuseppe vive ancora; e anche è rettore in tutto il paese di Egitto. E il cuore gli venne meno; perciocchè non credeva loro. ");
INSERT INTO ita1885_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ma essi gli dissero tutte le parole che Giuseppe avea lor dette; ed egli vide i carri, che Giuseppe avea mandati per levarlo; allora lo spirito si ravvivò a Giacobbe, lor padre. ");
INSERT INTO ita1885_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","E Israele disse: Basta, il mio figliuolo Giuseppe vive ancora; io andrò, e lo vedrò, avanti che io muoia. ");
INSERT INTO ita1885_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","ISRAELE adunque si partì, con tutto ciò ch'egli avea. E, giunto in Beerseba, sacrificò sacrificii all'Iddio d'Isacco suo padre. ");
INSERT INTO ita1885_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","E Iddio parlò a Israele in visioni di notte, e disse: Giacobbe, Giacobbe. Ed egli disse: Eccomi. ");
INSERT INTO ita1885_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","E Iddio disse: Io sono Iddio, l'Iddio di tuo padre; non temer di andare in Egitto; perciocchè io ti farò divenir quivi una gran nazione. ");
INSERT INTO ita1885_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Io scenderò teco in Egitto; e altresì te ne ricondurrò fuori; e Giuseppe metterà la sua mano sopra gli occhi tuoi. ");
INSERT INTO ita1885_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","E Giacobbe partì di Beerseba; e i figliuoli d'Israele fecero salire Giacobbe, loro padre, e i lor piccoli figliuoli, e le lor mogli, sopra i carri, che Faraone avea mandati per levar Giacobbe. ");
INSERT INTO ita1885_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Presero ancora i lor bestiami, e le facoltà che aveano acquistate nel paese di Canaan; e vennero in Egitto, Giacobbe e tutta la sua progenie. ");
INSERT INTO ita1885_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Egli menò seco in Egitto i suoi figliuoli, e i figliuoli de' suoi figliuoli; le sue figliuole, e le figliuole de' suoi figliuoli, e tutta la sua progenie. ");
INSERT INTO ita1885_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","E questi sono i nomi de' figliuoli d'Israele, che vennero in Egitto: Giacobbe, vi venne, co' suoi figliuoli; il primogenito di Giacobbe fu Ruben. ");
INSERT INTO ita1885_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","E i figliuoli di Ruben furono Henoc, e Pallu, e Hesron, e Carmi. ");
INSERT INTO ita1885_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","E i figliuoli di Simeonefurono Iemuel, e Iamin, e Ohad, e Iachin, e Sohar, e Saul, figliuolo di una Cananea. ");
INSERT INTO ita1885_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","E i figliuoli di Levifurono Gherson, e Chehat, e Merari. ");
INSERT INTO ita1885_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","E i figliuoli di Giudafurono Er, e Onan, e Sela, e Fares, e Zara; or Er, e Onan morirono nel paese di Canaan. E i figliuoli di Fares furono Hesron, e Hamul. ");
INSERT INTO ita1885_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","E i figliuoli d'Issacarfurono Tola, e Puva, e Iob, e Simron. ");
INSERT INTO ita1885_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","E i figliuoli di Zabulon furono Sered, ed Elon, e Ialeel. ");
INSERT INTO ita1885_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Questi sono i figliuoli di Lea, i quali ella partorì a Giacobbe in Paddan-aram, oltre a Dina, figliuola di esso: tutte le persone de' suoi figliuoli, con le sue figliuole, erano trentatre. ");
INSERT INTO ita1885_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","E i figliuoli di Gadfurono Siflon, e Hagghi, e Suni, ed Esbon, ed Eri, e Arodi, e Areeli. ");
INSERT INTO ita1885_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","E i figliuoli di Aserfurono Imna, e Isua, e Isui, e Beria, e Sera, lor sorella. E i figliuoli di Beria furono Heber, e Malchiel. ");
INSERT INTO ita1885_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Questi sono i figliuoli di Zilpa, la quale Labano diede a Lea, sua figliuola; ed ella partorì costoro a Giacobbe, che furono sedici persone. ");
INSERT INTO ita1885_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","I figliuoli di Rachele, moglie di Giacobbe, furono Giuseppe, e Beniamino. ");
INSERT INTO ita1885_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","E a Giuseppe, nel paese di Egitto, nacquero Manasse ed Efraim, i quali Asenat, figliuola di Potifera, Governatore di On, gli partorì. ");
INSERT INTO ita1885_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","E i figliuoli di Beniamino furono Bela, e Becher, e Asbel, e Ghera, e Naaman, ed Ehi, e Ros, e Muppim, e Huppim, e Ard. ");
INSERT INTO ita1885_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Questi sono i figliuoli di Rachele, i quali nacquero a Giacobbe: in tutto quattordici persone. ");
INSERT INTO ita1885_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","E il figliuolo di Danfu Husim. ");
INSERT INTO ita1885_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","E i figliuoli di Neftali furono Iaseel, e Guni, e Ieser, e Sillem. ");
INSERT INTO ita1885_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Questi sono i figliuoli di Bilha, la quale Labano diede a Rachele, sua figliuola: ed ella partorì costoro a Giacobbe; in tutto sette persone. ");
INSERT INTO ita1885_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Tutte le persone che vennero in Egitto, appartenenti a Giacobbe, procedute dalla sua anca, oltre alle mogli de' figliuoli di Giacobbe, furono in tutto sessantasei. ");
INSERT INTO ita1885_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","E i figliuoli di Giuseppe, che gli nacquero in Egitto, furono due persone; talchè tutte le persone della famiglia di Giacobbe, che vennero in Egitto, furono settanta. ");
INSERT INTO ita1885_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Or Giacobbe mandò davanti a sè Giuda a Giuseppe, per avvisarlo che gli venisse incontro in Gosen. Ed essi giunsero alla contrada di Gosen. ");
INSERT INTO ita1885_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","E Giuseppe fece mettere i cavalli al suo carro, e andò incontro a Israele, suo padre, in Gosen, e gli si fece vedere, e gli si gittò al collo, e pianse sopra il suo collo, per lungo spazio. ");
INSERT INTO ita1885_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","E Israele disse a Giuseppe: Muoia io pure questa volta, poichè ho veduta la tua faccia; conciossiachè tu vivi ancora. ");
INSERT INTO ita1885_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Poi Giuseppe disse a' suoi fratelli, e alla famiglia di suo padre: Io andrò, e farò assapere la vostra venuta a Faraone, e gli dirò: I miei fratelli, e la famiglia di mio padre, i quali erano nel paese di Canaan, son venuti a me. ");
INSERT INTO ita1885_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","E questi uomini son pastori di gregge; conciossiachè sieno sempre stati gente di bestiame; e hanno menate le lor gregge, e i loro armenti, e tutto ciò che hanno. ");
INSERT INTO ita1885_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ora, s'egli avviene che Faraone vi chiami, e vi dica: Qual'è il vostro mestiere? dite: ");
INSERT INTO ita1885_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","I tuoi servitori, dalla nostra giovanezza infino ad ora, sono sempre stati gente di bestiame, così noi, come i nostri padri; acciocchè dimoriate nella contrada di Gosen: (perciocchè ogni pastor di greggia è in abbominio agli Egizj). ");
INSERT INTO ita1885_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","GIUSEPPE adunque venne, e rapportò e disse a Faraone: Mio padre, e i miei fratelli, con le lor gregge, e co' loro armenti, e con tutto ciò che hanno, son venuti dal paese di Canaan; ed ecco, sono nella contrada di Gosen. ");
INSERT INTO ita1885_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Prese eziandio una parte de' suoi fratelli, cioè cinque, e li presentò davanti a Faraone. ");
INSERT INTO ita1885_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","E Faraone disse a' fratelli di Giuseppe: Qual'è il vostro mestiere? Ed essi dissero a Faraone: I tuoi servitori son pastori di gregge, come anche furono i nostri padri. ");
INSERT INTO ita1885_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Poi dissero a Faraone: Noi siam venuti per dimorare in questo paese; perciocchè non vi è pastura per le gregge de' tuoi servitori nel paese di Canaan, conciossiachè la fame vi sia grave; deh! permetti ora che i tuoi servitori dimorino nella contrada di Gosen. ");
INSERT INTO ita1885_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","E Faraone disse a Giuseppe: Poichè tuo padre, e i tuoi fratelli, son venuti a te; ");
INSERT INTO ita1885_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","il paese di Egitto è al tuo comando; fa' abitar tuo padre, e i tuoi fratelli, nel meglio del paese; dimorino pur nella contrada di Gosen, e se tu conosci che fra loro vi sieno degli uomini di valore, costituiscili governatori del mio bestiame. ");
INSERT INTO ita1885_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Poi Giuseppe menò Giacobbe, suo padre, a Faraone, e gliel presentò. E Giacobbe benedisse Faraone. ");
INSERT INTO ita1885_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","E Faraone disse a Giacobbe: Quanti anni hai? ");
INSERT INTO ita1885_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","E Giacobbe rispose a Faraone: Il tempo degli anni de' miei pellegrinaggiè centrent'anni; il tempo degli anni della mia vita è stato corto, e malvagio, e non è giunto al tempo degli anni della vita de' miei padri, ne' quali andarono peregrinando. ");
INSERT INTO ita1885_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Poi Giacobbe, salutato Faraone, se ne uscì fuori dal suo cospetto. ");
INSERT INTO ita1885_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","E Giuseppe diede a suo padre, e ai suoi fratelli, stanza e possessione nel paese di Egitto, nel meglio del paese, nella contrada di Rameses, come Faraone avea comandato. ");
INSERT INTO ita1885_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","E Giuseppe sostentò suo padre, e i suoi fratelli, e tutta la casa di suo padre, provvedendo loro di pane, secondo le bocche delle lor famiglie. ");
INSERT INTO ita1885_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","OR in tutta la terra non vi era pane; perciocchè la fame era gravissima; e il paese di Egitto, e di Canaan, si veniva meno per la fame. ");
INSERT INTO ita1885_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","E Giuseppe raccolse tutti i danari che si ritrovarono nel paese di Egitto, e nel paese di Canaan, per lo grano che la gente di que' paesi comperava; e Giuseppe portò que' danari in casa di Faraone. ");
INSERT INTO ita1885_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","E, quando i danari furono mancati nel paese di Egitto, e nel paese di Canaan, tutti gli Egizj vennero a Giuseppe, dicendo: Dacci del pane, perchè morremmo noi davanti agli occhi tuoi per mancamento di danari? ");
INSERT INTO ita1885_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","E Giuseppe disse: Datemi il vostro bestiame, ed io vi darò del pane per lo vostro bestiame, se pure i danari son mancati. ");
INSERT INTO ita1885_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ed essi menarono il lor bestiame a Giuseppe; e Giuseppe diede loro del pane per cavalli, e per gregge di pecore, e per armenti di buoi, e per asini. Così li sostentò di pane quell'anno per tutto il lor bestiame. ");
INSERT INTO ita1885_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","E, passato quell'anno, ritornarono l'anno seguente a lui, e gli dissero: Noi non possiamo celare il nostro bisogno al mio signore; ma i danari son mancati, e i nostri bestiami son pervenuti al mio signore; e' non ci resta nulla che il mio signore possa pigliare, salvo i nostri corpi, e le nostre terre. ");
INSERT INTO ita1885_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Perchè periremmo, e noi, e le nostre terre, davanti agli occhi tuoi? compera noi, e le nostre terre, per del pane; e noi, e le nostre terre, saremo servi a Faraone; e dacci della semenza, acciocchè viviamo, e non muoiamo, e che la terra non sia desolata. ");
INSERT INTO ita1885_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Giuseppe adunque acquistò a Faraone tutte le terre di Egitto; perciocchè gli Egizj venderono ciascun la sua possessione; conciossiachè la fame si fosse aggravata sopra loro; e così le terre furono acquistate a Faraone. ");
INSERT INTO ita1885_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","E Giuseppe trasportò il popolo nelle città, da un capo de' confini di Egitto infino all'altro. ");
INSERT INTO ita1885_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Sol non acquistò le terre de' sacerdoti; perciocchè vi era una provvisione assegnata da Faraone a' sacerdoti; onde essi mangiarono la provvisione che Faraone dava loro, e perciò non venderono le lor terre. ");
INSERT INTO ita1885_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","E Giuseppe disse al popolo: Ecco io ho oggi acquistati a Faraone e voi e le vostre terre; eccovi della semenza: seminate la terra. ");
INSERT INTO ita1885_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","E al tempo della ricolta, voi darete il quinto di essa a Faraone, e le altre quattro parti saranno vostre, per la sementa de' campi, e per lo mangiar di voi, e di coloro che son nelle vostre case, e per lo mangiar delle vostre famiglie. ");
INSERT INTO ita1885_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ed essi dissero: Tu ci hai scampata la vita; troviamo pur grazia appo il mio signore, e siamo servi a Faraone. ");
INSERT INTO ita1885_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","E Giuseppe, per istatuto che dura infino ad oggi, fece una imposta sopra le terre di Egitto, del quinto della rendita, per Faraone; sol le terre de' sacerdoti non furono di Faraone. ");
INSERT INTO ita1885_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Così gl'Israeliti abitarono nel paese di Egitto, nella contrada di Gosen, e ne furono fatti possessori, e moltiplicarono, e crebbero grandemente. ");
INSERT INTO ita1885_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","E Giacobbe visse nel paese di Egitto diciassette anni; e gli anni della vita di Giacobbe furono cenquarantasette. ");
INSERT INTO ita1885_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Or avvicinandosi il tempo della morte di Israele, egli chiamò il suo figliuolo Giuseppe, e gli disse: Deh! se io ho trovato grazia appo te, metti ora la tua mano sotto la mia coscia, promettendomi che tu userai inverso me benignità e lealtà; deh! non seppellirmi in Egitto. ");
INSERT INTO ita1885_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Anzi, quando io giacerò co' miei padri, portami fuor di Egitto, e seppelliscimi nella lor sepoltura. E Giuseppe disse: Io farò secondo la tua parola. ");
INSERT INTO ita1885_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","E Israele disse: Giuramelo. Ed egli gliel giurò. E Israele, inchinatosi verso il capo del letto, adorò. ");
INSERT INTO ita1885_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","ORA, dopo queste cose, fu detto a Giuseppe: Ecco, tuo padre è infermo. Allora egli prese seco i suoi due figliuoli, Manasse ed Efraim. ");
INSERT INTO ita1885_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ed egli fu rapportato, e detto a Giacobbe: Ecco, Giuseppe, tuo figliuolo, viene a te. E Israele, isforzatosi, si mise a sedere in sul letto. ");
INSERT INTO ita1885_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","E Giacobbe disse a Giuseppe: L'Iddio Onnipotente mi apparve in Luz, nel paese di Canaan, e mi benedisse. ");
INSERT INTO ita1885_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","E mi disse: Ecco, io ti farò moltiplicare, e ti accrescerò, e ti farò divenir raunanza di popoli; e darò questo paese alla tua progenie dopo te, per possession perpetua. ");
INSERT INTO ita1885_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ora dunque, i tuoi due figliuoli, che ti son nati nel paese di Egitto, prima che io venissi a te in Egitto, son miei; Efraim e Manasse saranno miei, come Ruben e Simeone. ");
INSERT INTO ita1885_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ma i figliuoli che tu genererai dopo loro, saranno tuoi; nella loro eredità saranno nominati del nome de' lor fratelli. ");
INSERT INTO ita1885_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Or, quant'è a me, quando io veniva di Paddan, Rachele morì appresso di me nel paese di Canaan, per cammino, alquanto spazio lungi di Efrata; e io la seppellii quivi nel cammino di Efrata, ch' è Betlehem. ");
INSERT INTO ita1885_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","E Israele, veduti i figluoli di Giuseppe, disse: Chi son costoro? ");
INSERT INTO ita1885_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","E Giuseppe disse a suo padre: Sono i miei figliuoli, i quali Iddio mi ha dati qui. E Giacobbe disse: Deh! falli appressare a me, ed io li benedirò. ");
INSERT INTO ita1885_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","(Or gli occhi d'Israele erano gravi per la vecchiezza, talchè egli non potea vedere.) E Giuseppe glieli fece appressare. ");
INSERT INTO ita1885_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ed egli li baciò, e li abbracciò. E Israele disse a Giuseppe: Io non pensava di veder mai più la tua faccia; ed ecco, Iddio mi ha fatto vedere eziandio della tua progenie. ");
INSERT INTO ita1885_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Poi Giuseppe, fattili levar d'appresso alle ginocchia di esso, s'inchinò con la faccia in terra. ");
INSERT INTO ita1885_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","E li prese amendue, e pose Efraim alla sua destra, dalla sinistra d'Israele; e Manasse alla sua sinistra, dalla destra d'Israele; e così glieli fece appressare. ");
INSERT INTO ita1885_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","E Israele porse la sua man destra, e la pose sopra il capo di Efraim, ch'era il minore, e pose la sinistra sopra il capo di Manasse; e, benchè Manasse fosse il primogenito, nondimeno avvedutamente pose così le mani. ");
INSERT INTO ita1885_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","E benedisse Giuseppe, e disse: Iddio, nel cui cospetto i miei padri, Abrahamo ed Isacco, son camminati; Iddio, che mi ha pasciuto da che io sono al mondo infino a questo giorno; ");
INSERT INTO ita1885_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","l'Angelo, che mi ha riscosso d'ogni male, benedica questi fanciulli, e sieno nominati del mio nome, e del nome de' miei padri, Abrahamo ed Isacco; e moltiplichino copiosamente sulla terra. ");
INSERT INTO ita1885_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ora, veggendo Giuseppe che suo padre avea posta la sua man destra sopra il capo di Efraim, ciò gli dispiacque, e prese la mano di suo padre, per rimoverla d'in sul capo di Efraim, e per metterla in sul capo di Manasse. ");
INSERT INTO ita1885_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","E Giuseppe disse a suo padre: Non così, padre mio; conciossiachè questo sia il primogenito, metti la tua man destra sopra il suo capo. ");
INSERT INTO ita1885_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ma suo padre ricusò di farlo, e disse: Io il so, figliuol mio, io il so; ancora esso diventerà un popolo, e ancora esso sarà grande; ma pure il suo fratel minore sarà più grande di lui, e la progenie di esso sarà una piena di genti. ");
INSERT INTO ita1885_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Così in quel giorno li benedisse, dicendo: Israele benedirà altrui, prendendone l'esempio in te; dicendo: Iddio ti faccia esser simile ad Efraim ed a Manasse. E Israele antepose Efraim a Manasse. ");
INSERT INTO ita1885_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Poi Israele disse a Giuseppe: Ecco, io muoio, e Iddio sarà con voi, e vi ricondurrà al paese de' vostri padri. ");
INSERT INTO ita1885_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ed io ti dono una parte sopra i tuoi fratelli, la quale io ho conquistata dalle mani degli Amorrei con la mia spada e col mio arco. ");
INSERT INTO ita1885_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","POI Giacobbe chiamò i suoi figliuoli, e disse: Adunatevi, ed io vi dichiarerò chò che vi avverrà nel tempo a venire. ");
INSERT INTO ita1885_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Adunatevi e ascoltate, figliuoli di Giacobbe! Prestate udienza a Israele, vostro padre. ");
INSERT INTO ita1885_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","RUBEN, tu sei il mio primogenito, La mia possa, e il principio delle mie forze, Eccellente in dignità, ed eccellente in forza. ");
INSERT INTO ita1885_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Tutto ciò è scolato come acqua; non aver la maggioranza! Perciocchè tu salisti in sul letto di tuo padre; Allora che tu contaminasti il mio letto, tutto ciò sparì. ");
INSERT INTO ita1885_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","SIMEONE e LEVI son fratelli; Le loro spade sono arme di violenza. ");
INSERT INTO ita1885_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Non entri l'anima mia nel lor consiglio segreto; Non uniscasi la gloria mia alla lor raunanza; Perciocchè nella loro ira hanno uccisi uomini, E hanno a lor voglia spianato il muro. ");
INSERT INTO ita1885_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Maledetta sia l'ira loro, perciocchè è stata violenta; E il furor loro, perciocchè è stato aspro; Io li dividerò per Giacobbe, E li spargerò per Israele. ");
INSERT INTO ita1885_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","GIUDA, te celebreranno i tuoi fratelli; La tua mano sarà sopra il collo de' tuoi nemici; I figliuoli di tuo padre s'inchineranno a te; ");
INSERT INTO ita1885_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Giuda è un leoncello; Figliuol mio, tu sei ritornato dalla preda; Quando egli si sarà chinato, e si sarà posto a giacere come un leone, Anzi come un gran leone, chi lo desterà? ");
INSERT INTO ita1885_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Lo Scettro non sarà rimosso da Giuda, Nè il Legislatore d'infra i piedi di esso, Finchè non sia venuto colui al quale quello appartiene; E inverso lui sarà l'ubbidienza de' popoli. ");
INSERT INTO ita1885_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Egli lega il suo asinello alla vite, E al tralcio della vite nobile il figlio della sua asina; Egli lava il suo vestimento nel vino, E i suoi panni nel liquor delle uve. ");
INSERT INTO ita1885_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Egli ha gli occhi rosseggianti per lo vino, E i denti bianchi per lo latte. ");
INSERT INTO ita1885_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","ZABULON abiterà nel porto de' mari Egli sarà al porto delle navi; E il suo confine sarà fino a Sidon. ");
INSERT INTO ita1885_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","ISSACAR è un asino ossuto, Che giace fra due sbarre. ");
INSERT INTO ita1885_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","E avendo egli veduto che il riposo è cosa buona, E che il paese è ameno, Chinerà la spalla per portar la soma, E diverrà tributario. ");
INSERT INTO ita1885_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","DAN giudicherà il suo popolo, Come una delle tribù d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan sarà una serpe in su la strada, Un colubro in sul sentiero, Il qual morde i pasturali del cavallo, Onde colui che lo cavalca cade indietro. ");
INSERT INTO ita1885_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","O Signore, io ho aspettata la tua salute. ");
INSERT INTO ita1885_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Quant'è a GAD, schiere lo scorreranno; Ma egli in iscambio scorrerà altri. ");
INSERT INTO ita1885_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Dal paese di ASER procederà la grascia della sua vittuaglia, Ed esso produrrà delizie reali. ");
INSERT INTO ita1885_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","NEFTALI è una cerva sciolta; Egli proferisce belle parole. ");
INSERT INTO ita1885_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","GIUSEPPE è un ramo di una vite fruttifera, Un ramo di una vite fruttifera appresso ad una fonte, I cui rampolli si distendono lungo il muro. ");
INSERT INTO ita1885_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","E benchè egli sia stato amaramente afflitto, E che degli arcieri l'abbiano saettato e nimicato; ");
INSERT INTO ita1885_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Pur è dimorato l'arco suo nella sua forza; E le sue braccia e le sue mani si son rinforzate, Per l'aiuto del Possente di Giacobbe: Quindi egli è stato il pastore, la pietra d'Israele, ");
INSERT INTO ita1885_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Ciò è proceduto dall'Iddio di tuo padre, il quale ancora ti aiuterà; E dall'Onnipotente, il quale ancora ti benedirà Delle benedizioni del cielo di sopra, Delle benedizioni dell'abisso che giace disotto, Delle benedizioni delle mammelle e della matrice. ");
INSERT INTO ita1885_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Le benedizioni di tuo padre Hanno avanzate le benedizioni de' miei genitori, E son giunte fino al sommo de' colli eterni. Esse saranno sopra il capo di Giuseppe, E sopra la sommità del capo di lui, Ch'è stato messo da parte d'infra i suoi fratelli. ");
INSERT INTO ita1885_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","BENIAMINO è un lupo rapace; La mattina egli divorerà la preda, E in su la sera partirà le spoglie. ");
INSERT INTO ita1885_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Tutti costoro sono i capi delle dodici tribù d'Israele; e questo è quello che il padre loro disse loro, quando il benedisse, benedicendo ciascuno di essi secondo la sua propria benedizione. ");
INSERT INTO ita1885_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Poi comandò, e disse loro: Tosto sarò raccolto al mio popolo; seppellitemi coi miei padri, nella spelonca ch'è nel campo di Efron Hitteo; ");
INSERT INTO ita1885_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","nella spelonca, ch'è nel campo di Macpela, il quale è dirincontro a Mamre, nel paese di Cannan; la quale spelonca Abrahamo comperò da Efron Hitteo, insieme col campo, per possession di sepoltura. ");
INSERT INTO ita1885_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Quivi fu seppellito Abrahamo e Sara, sua moglie; quivi fu seppellito Isacco e Rebecca, sua moglie; quivi ancora ho seppellita Lea. ");
INSERT INTO ita1885_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","L'acquisto di quel campo, e della spelonca ch'è in esso, fu fatto da' figliuoli di Het. ");
INSERT INTO ita1885_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","E, dopo che Giacobbe ebbe finito di dar questi comandamenti a' suoi figliuoli, ritrasse i piedi dentro al letto, e trapassò, e fu raccolto a' suoi popoli. ");
INSERT INTO ita1885_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","E GIUSEPPE, gittatosi sopra la faccia di suo padre, pianse sopra lui, e lo baciò. ");
INSERT INTO ita1885_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Poi comandò a' suoi servitori medici, che imbalsamassero suo padre. E i medici imbalsamarono Israele. ");
INSERT INTO ita1885_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","E quaranta giorni intieri furono posti ad imbalsamarlo; perciocchè tanto tempo appunto si metteva ad imbalsamar coloro che s'imbalsamavano; e gli Egizj lo piansero per settanta giorni. ");
INSERT INTO ita1885_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","E, dopo che furono passati i giorni del pianto che si fece per lui, Giuseppe parlò alla famiglia di Faraone, dicendo: Deh! se io ho trovata grazia appo voi, parlate, vi prego, a Faraone, e ditegli: ");
INSERT INTO ita1885_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Che mio padre mi ha fatto giurare, dicendo: Ecco, io mi muoio; seppelliscimi nella mia sepoltura, la quale io mi ho cavata nel paese di Canaan. Deh! lascia ora dunque che io vada a seppellire mio padre; poi ritornerò. ");
INSERT INTO ita1885_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","E Faraone disse: Va', seppellisci tuo padre, come egli ti ha fatto giurare. ");
INSERT INTO ita1885_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Giuseppe adunque salì, per seppellir suo padre; e con lui andarono tutti gli anziani della casa di Faraone, servitori di esso, e tutti gli anziani del paese di Egitto; ");
INSERT INTO ita1885_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","e tutta la famiglia di Giuseppe, e i suoi fratelli, e la famiglia di suo padre; sol lasciarono nella contrada di Gosen le lor famiglie, e le lor gregge, e i loro armenti. ");
INSERT INTO ita1885_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Con lui andarono eziandio carri e cavalieri; talchè lo stuolo fu grandissimo. ");
INSERT INTO ita1885_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","E, come furono giunti all'aia di Atad, che era di là dal Giordano, fecero quivi un grande e molto grave lamento. E Giuseppe fece cordoglio di suo padre per sette giorni. ");
INSERT INTO ita1885_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Or i Cananei, abitanti di quel paese, veggendo il cordoglio che si faceva nell'aia di Atad, dissero: Quest'è un duolo grave agli Egizj: perciò fu posto nome a quell'aia, Abel-Misraim, ch'è di là dal Giordano. ");
INSERT INTO ita1885_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","E i figliuoli di Giacobbe gli fecero come egli avea lor comandato. ");
INSERT INTO ita1885_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","E lo portarono nel paese di Canaan, e lo seppellirono nella spelonca del campo di Macpela, dirimpetto a Mamre, la quale Abrahamo avea comperata, insieme col campo, da Efron Hitteo, per possession di sepoltura. ");
INSERT INTO ita1885_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","E Giuseppe, dopo ch'ebbe seppellito suo padre, se ne ritornò in Egitto, co' suoi fratelli, e con tutti coloro che erano andati con lui, per seppellir suo padre. ");
INSERT INTO ita1885_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Or i fratelli di Giuseppe, veggendo che il padre loro era morto, dissero: Forse Giuseppe ci porterà odio, e nimistà, e non mancherà di renderci tutto il male che gli abbiam fatto. ");
INSERT INTO ita1885_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Laonde commisero ad alcuni di andare a Giuseppe, per dirgli; Tuo padre, avanti che morisse, ordinò, e disse: ");
INSERT INTO ita1885_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Dite così a Giuseppe: Perdona, ti prego, ora a' tuoi fratelli il lor misfatto, e il lor peccato; conciossiachè essi ti abbiano fatto del male. Deh! perdona dunque ora a' servitori dell'Iddio di tuo padre il lor misfatto. E Giuseppe pianse, quando coloro gli parlarono. ");
INSERT INTO ita1885_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","I suoi fratelli andarono eziandio a lui; e, gittatisi in terra davanti a lui, gli dissero: Eccociti per servi. ");
INSERT INTO ita1885_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ma Giuseppe disse loro: Non temiate; perciocchè, sono io in luogo di Dio? ");
INSERT INTO ita1885_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Voi certo avevate pensato del male contro a me; ma Iddio ha pensato di convertir quel male in bene, per far ciò che oggi appare, per conservare in vita una gran gente. ");
INSERT INTO ita1885_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ora dunque, non temiate; io sostenterò voi, e le vostre famiglie. Così li consolò, e li riconfortò. ");
INSERT INTO ita1885_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","E Giuseppe dimorò in Egitto, con la famiglia di suo padre, e visse centodieci anni. ");
INSERT INTO ita1885_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","E vide ad Efraim figliuoli della terza generazione; i figliuoli di Machir, figliuolo di Manasse, nacquero anch'essi, e furono allevati sopra le ginocchia di Giuseppe. ");
INSERT INTO ita1885_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","E Giuseppe disse a' suoi fratelli: Tosto morrò, e Iddio per certo vi visiterà, e vi farà salire fuor di questo paese, nel paese il quale egli giurò ad Abrahamo, a Isacco, e a Giacobbe. ");
INSERT INTO ita1885_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","E Giuseppe fece giurare i figliuoli d'Israele, dicendo: Iddio per certo vi visiterà; allora trasportate di qui le mie ossa. ");
INSERT INTO ita1885_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Poi Giuseppe morì, essendo di età di centodieci anni; e fu imbalsamato, e posto in un cataletto in Egitto.");
INSERT INTO ita1885_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","OR questi sono i nomi de' figliuoli d'Israele, che vennero in Egitto: essi vi vennero con Giacobbe, ciascuno con la sua famiglia. ");
INSERT INTO ita1885_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeone, Levi, e Giuda; ");
INSERT INTO ita1885_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issacar, Zabulon, e Beniamino; ");
INSERT INTO ita1885_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Neftali, Gad, e Aser. ");
INSERT INTO ita1885_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","E tutte le persone, uscite dell'anca di Giacobbe, erano settanta. Or Giuseppe era già in Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","E Giuseppe morì, e tutti i suoi fratelli, e tutta quella generazione. ");
INSERT INTO ita1885_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","E i figliuoli d'Israele fruttarono e moltiplicarono copiosamente, e crebbero, e divennero grandemente possenti, talchè il paese fu ripieno di essi. ");
INSERT INTO ita1885_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Or sorse un nuovo re sopra l'Egitto, il qual non avea conosciuto Giuseppe. ");
INSERT INTO ita1885_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Costui disse al suo popolo: Ecco, il popolo de' figliuoli d'Israele è più grande e più possente di noi. ");
INSERT INTO ita1885_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Ora procediamo saggiamente intorno ad esso; che talora non moltiplichi; onde, se alcuna guerra avvenisse, egli non si congiunga anche esso co' nostri nemici, e non guerreggi contro a noi, o se ne vada via dal paese. ");
INSERT INTO ita1885_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Furono adunque costituiti sopra il popolo d'Israele commissari d'angherie, per affliggerlo con le lor gravezze. E il popolo edificò a Faraone delle città da magazzini, cioè, Pitom e Raamses. ");
INSERT INTO ita1885_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ma quanto più l'affliggevano, tanto più cresceva, e tanto più moltiplicava fuor di modo; onde gli Egizj portavano gran noia de' figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","E gli Egizj facevano servire i figliuoli d'Israele con asprezza. ");
INSERT INTO ita1885_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","E li facevano vivere in amaritudine, con dura servitù, adoperandoli intorno all'argilla, e a' mattoni, e ad ogni servigio de' campi; tutta la servitù, nella quale li adoperavano, era con asprezza. ");
INSERT INTO ita1885_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Il re di Egitto disse ancora alle levatrici delle donne Ebree, il nome dell'una delle quali era Sifra, e quel dell'altra Pua: ");
INSERT INTO ita1885_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Quando voi ricoglierete i parti delle donne Ebree, e le vedrete in su la seggiola, se il parto è un figliuol maschio, uccidetelo; ma se è una figliuola femmina, lasciatela vivere. ");
INSERT INTO ita1885_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ma quelle levatrici temettero Iddio, e non fecero secondo che il re di Egitto avea loro detto; anzi lasciarono vivere i fanciulli. ");
INSERT INTO ita1885_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","E il re di Egitto chiamò le levatrici, e disse loro: Perchè avete voi fatto questo, di lasciar vivere i fanciulli? ");
INSERT INTO ita1885_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","E le levatrici dissero a Faraone: Le donne Ebree non sono come l'Egizie, perciocchè sono vigorose; avanti che la levatrice sia venuta a loro, hanno partorito. ");
INSERT INTO ita1885_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","E Iddio fece del bene a quelle levatrici; e il popolo crebbe, e divenne grandemente possente. ");
INSERT INTO ita1885_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","E perchè quelle levatrici temettero Iddio, egli edificò loro delle case. ");
INSERT INTO ita1885_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Allora Faraone comandò a tutto il suo popolo, dicendo: Gittate nel fiume ogni figliuol maschio che nascerà, e lasciate vivere tutte le figliuole femmine. ");
INSERT INTO ita1885_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","OR un uomo della famiglia di Levi andò, e prese per moglie una figliuola di Levi. ");
INSERT INTO ita1885_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","E quella donna concepette, e partorì un figliuolo; e, veggendolo bello, lo tenne nascosto lo spazio di tre mesi. ");
INSERT INTO ita1885_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ma non potendo più tenerlo nascosto, ella prese una cestella fatta di giunchi, e la impiastrò di bitume e di pece; e, postovi dentro il fanciullo, la mise nella giuncaia, in su la riva del fiume. ");
INSERT INTO ita1885_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","E la sorella del fanciullo se ne stava da lungi, per saper ciò che gli avverrebbe. ");
INSERT INTO ita1885_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Or la figliuola di Faraone discese per bagnarsi nel fiume; e le sue donzelle passeggiavano su la riva del fiume; ed ella vide quella cestella per mezzo la giuncaia, e mandò una sua servente, e la fece torre. ");
INSERT INTO ita1885_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","E apertala vide quel bambino; ed ecco, il fanciullo piangeva; ed ella ne ebbe compassione, e disse: Questo fanciullo è de' figliuoli degli Ebrei. ");
INSERT INTO ita1885_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","E la sorella di esso disse alla figliuola di Faraone: Andrò io a chiamarti una balia d'infra le donne Ebree, che ti allatti questo fanciullo? ");
INSERT INTO ita1885_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","E la figliuola di Faraone le disse: Va'. E la fanciulla andò, e chiamò la madre del fanciullo. ");
INSERT INTO ita1885_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","E la figliuola di Faraone disse: Portane questo fanciullo, e allattamelo, ed io ti darò il tuo salario. E quella donna prese il fanciullo, e lo allattò. ");
INSERT INTO ita1885_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","E quando il fanciullo fu grande, ella lo menò alla figliuola di Faraone, ed esso le fu in luogo di figliuolo, ed ella gli pose nome Mosè; perciocchè, disse ella, io lo ho tratto fuor delle acque. ");
INSERT INTO ita1885_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Or in quel tempo, essendo Mosè già divenuto grande, avvenne ch'egli uscì fuori a' suoi fratelli, e vide le lor gravezze; e vide un Egizio che percuoteva un uomo Ebreo de' suoi fratelli. ");
INSERT INTO ita1885_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","E avendo riguardato qua e là, e veduto, che non v'era nissuno, percosse quell'Egizio, e lo nascose nel sabbione. ");
INSERT INTO ita1885_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","E il giorno seguente egli uscì ancora fuori; ed ecco, due uomini Ebrei contendevano insieme. Ed egli disse a colui che avea il torto: Perchè percuoti il tuo prossimo? ");
INSERT INTO ita1885_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","E colui gli rispose: Chi ti ha costituito principe e giudice sopra noi? pensi tu di uccider me, come uccidesti quell'Egizio? E Mosè temette, e disse: Per certo la cosa si è saputa. ");
INSERT INTO ita1885_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","E Faraone udì questa cosa, e cercò Mosè per ucciderlo; ma Mosè se ne fuggì dal cospetto di Faraone, e si fermò nel paese di Madian, ove si pose a sedere presso ad un pozzo. ");
INSERT INTO ita1885_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Or il sacerdote di Madian avea sette figliuole; le quali vennero, e attinsero dell'acqua, ed empierono gli abbeveratoi, per abbeverar le gregge del lor padre. ");
INSERT INTO ita1885_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","E i pastori sopraggiunsero, e scacciarono le gregge; ma Mosè si levò, e soccorse quelle fanciulle, e abbeverò le lor gregge. ");
INSERT INTO ita1885_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ed elleno se ne vennero a Reuel, lor padre; ed egli disse loro: Perchè siete voi oggi così presto ritornate? ");
INSERT INTO ita1885_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ed elleno risposero: Un uomo Egizio ci ha riscosse dalle mani de' pastori, e anche ci ha attinto dell'acqua abbondantemente, ed ha abbeverate le gregge. ");
INSERT INTO ita1885_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ed egli disse alla sue figliuole: E dov'è egli? perchè avete lasciato là quell'uomo? chiamatelo, che prenda cibo. ");
INSERT INTO ita1885_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","E Mosè acconsentì di dimorar con quell'uomo: ed egli diede a Mosè Sippora, sua figliuola. ");
INSERT INTO ita1885_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Ed ella partorì un figliuolo, ed egli gli pose nome Ghersom; perciocchè disse: Io sono stato forestiere in paese strano. ");
INSERT INTO ita1885_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Or avvenne che in quel mezzo tempo, che fu lungo, il re di Egitto morì; e i figliuoli d'Israele sospirarono per la servitù, e gridarono; e le lor grida, che gittarono per la servitù, salirono a Dio. ");
INSERT INTO ita1885_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","E Iddio intese i loro stridi, e si ricordò del suo patto con Abrahamo, con Isacco, e con Giacobbe. ");
INSERT INTO ita1885_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","E Iddio riguardò a' figliuoli d'Israele, e ne prese conoscenza. ");
INSERT INTO ita1885_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","OR Mosè pasturava la greggia di Ietro, sacerdote di Madian, suo suocero; e guidando la greggia dietro al deserto, pervenne alla montagna di Dio, ad Horeb. ");
INSERT INTO ita1885_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","E l'Angelo del Signore gli apparve in una fiamma di fuoco, di mezzo un pruno. Ed egli riguardò, ed ecco, il pruno ardea in fuoco, e pure il pruno non si consumava. ");
INSERT INTO ita1885_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","E Mosè disse: Or andrò là, e vedrò questa gran visione, per qual cagione il pruno non si bruci. ");
INSERT INTO ita1885_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","E il Signore vide ch'egli era andato là fuor di via, per veder quella visione. E Iddio lo chiamò di mezzo il pruno, e disse: Mosè, Mosè. Ed egli rispose: Eccomi. ");
INSERT INTO ita1885_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","E Iddio gli disse: Non appressarti in qua; tratti le scarpe da' piedi, perciocchè il luogo, sopra il quale tu stai, è terra santa. ");
INSERT INTO ita1885_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Poi disse: Io son l'Iddio di tuo padre, l'Iddio di Abrahamo, l'Iddio d'Isacco, e l'Iddio di Giacobbe. E Mosè si nascose la faccia; perciocchè egli temeva di riguardar verso Iddio. ");
INSERT INTO ita1885_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","E il Signore disse: Ben ho veduta l'afflizion del mio popolo, ch' è in Egitto, ed ho udite le lor grida, per cagion dei loro esattori; perciocchè io ho presa conoscenza delle sue doglie. ");
INSERT INTO ita1885_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","E sono sceso per riscuoterlo dalle mani degli Egizj, e per farlo salir da quel paese in un paese buono e largo; in un paese stillante latte e miele; nel luogo de' Cananei, deg'Hittei, degli Amorrei, dei Ferezei, degl'Hivvei, e de' Gebusei. ");
INSERT INTO ita1885_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ora dunque, ecco, le grida de' figliuoli d'Israele son pervenute a me, ed anche ho veduta l'oppressione, con la quale gli Egizj li oppressano. ");
INSERT INTO ita1885_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Perciò, vieni ora, ed io ti manderò a Faraone, e tu trarrai fuor di Egitto il mio popolo, i figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","E Mosè disse a Dio: Chi sono io, che io vada a Faraone, e tragga fuor di Egitto i figliuoli d'Israele? ");
INSERT INTO ita1885_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","E Iddio gli disse! Va' pure; perciocchè io sarò teco; e questo ti sarà per segno che io ti ho mandato. Quando tu avrai tratto fuor di Egitto il popolo, voi servirete a Dio sopra questo monte. ");
INSERT INTO ita1885_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","E Mosè disse a Dio: Ecco, quando io sarò venuto a' figliuoli d'Israele, e avrò lor detto: L'Iddio de' vostri padri mi ha mandato a voi, se essi mi dicono: Qual'è il suo nome? che dirò io loro? ");
INSERT INTO ita1885_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","E Iddio disse a Mosè: IO SON COLUI CHE SONO; poi disse: Così dirai ai figliuoli d'Israele: Colui che si chiama IO SONO, m'ha mandato a voi. ");
INSERT INTO ita1885_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Iddio disse ancora a Mosè: Così dirai a' figliuoli d'Israele: Il Signore Iddio de' padri vostri, l'Iddio di Abrahamo, e l'Iddio d'Isacco, e l'Iddio di Giacobbe, mi ha mandato a voi; questo è il mio Nome in eterno e questa è la mia ricordanza per ogni età. ");
INSERT INTO ita1885_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Va', e raduna gli Anziani d'Israele, e di' loro: Il Signore Iddio de' vostri padri, l'Iddio di Abrahamo, d'Isacco, e di Giacobbe, mi è apparito, dicendo: Certamente io vi ho visitati, e ho veduto ciò che vi si fa in Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","E ho detto: Io vi trarrò fuor dell'afflizione di Egitto, e vi condurrò nel paese de' Cananei, degl'Hittei, degli Amorrei, de' Ferezei, degl'Hivvei, e de' Gebusei; in un paese stillante latte e miele. ");
INSERT INTO ita1885_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Ed essì ubbidiranno alla tua voce; e tu, con gli Anziani d'Israele, entrerai dal re di Egitto, e voi gli direte: Il Signore Iddio degli Ebrei ci ha incontrati; deh! lascia dunque ora che andiamo tre giornate di cammino nel deserto, e che sacrifichiamo al Signore Iddio nostro. ");
INSERT INTO ita1885_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Or io so che il re di Egitto non vi concederà l'andare, se non isforzato con potente mano. ");
INSERT INTO ita1885_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Ed io stenderò la mia mano, e percuoterò l'Egitto con tutte le mie maravigliose opere, che io farò in mezzo di esso. Dopo ciò egli vi lascerà andare. ");
INSERT INTO ita1885_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","E allora metterò in grazia questo popolo inverso gli Egizj; e avverrà che, quando voi ve ne andrete, non ve ne andrete vuoti. ");
INSERT INTO ita1885_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Anzi, ciascuna donna chiederà alla sua vicina, e alla sua albergatrice, vasellamenti di argento, e vasellamenti di oro, e vestimenti; e voi metterete quelli addosso a' vostri figliuoli, e alle vostre figliuole; e così spoglierete gli Egizj. ");
INSERT INTO ita1885_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","E Mosè rispose, e disse: Ma ecco, essi non mi crederanno, e non ubbidiranno alla mia voce; perciocchè diranno: Il Signore non ti è apparito. ");
INSERT INTO ita1885_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","E il Signore gli disse: Che cosa è questa che tu hai in mano? Ed egli rispose: Una bacchetta. ");
INSERT INTO ita1885_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","E il Signore gli disse: Gittala in terra. Ed egli la gittò in terra; ed ella divenne un serpente; e Mosè fuggì d'innanzi a quello. ");
INSERT INTO ita1885_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Ma il Signore disse a Mosè: Stendi la tua mano, e prendilo per la coda. Ed egli stese la mano, e lo prese; ed esso divenne bacchetta nella sua mano. ");
INSERT INTO ita1885_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Così farai, disse Iddio, acciocchè credano che il Signore Iddio de' lor padri, l'Iddio di Abrahamo, l'Iddio d'Isacco e l'Iddio di Giacobbe, ti è apparito. ");
INSERT INTO ita1885_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Il Signore gli disse ancora: Mettiti ora la mano in seno. Ed egli si mise la mano in seno; poi, trattala fuori, ecco, la sua mano era lebbrosa, bianca come neve. ");
INSERT INTO ita1885_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Poi gli disse: Rimettiti la mano in seno. Ed egli si rimise la mano in seno; poi, trattasela fuor del seno, ecco, era tornata come l'altra sua carne. ");
INSERT INTO ita1885_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Se dunque, disse il Signore, non ti credono, e non ubbidiscono alla tua voce al primo segno, ubbidiranno alla tua voce, al secondo segno. ");
INSERT INTO ita1885_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","E se egli avviene che non pure a questi due segni credano, e non ubbidiscano alla tua voce; allora prendi dell'acqua del fiume, e spandila in su l'asciutto; e l'acqua che tu avrai presa dal fiume diventerà sangue in su l'asciutto. ");
INSERT INTO ita1885_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","E Mosè disse al Signore: Ahi! Signore, io non son mai per addietro stato uomo ben parlante, non pur da che tu parlasti al tuo servitore; conciossiachè io sia tardo di bocca e di lingua. ");
INSERT INTO ita1885_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","E il Signore gli disse: Chi ha posta la bocca all'uomo? ovvero, chi fa il mutolo, o il sordo, o colui che ha gli occhi, e gli orecchi aperti, o il cieco? non son desso io, il Signore? ");
INSERT INTO ita1885_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ora dunque va', ed io sarò con la tua bocca, e t'insegnerò ciò che avrai a dire. ");
INSERT INTO ita1885_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","E Mosè disse: Ahi! Signore; deh! manda a far questo per colui il qual tu hai a mandare. ");
INSERT INTO ita1885_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Allora l'ira del Signore si accese contro a Mosè; ed egli gli disse: Non so io che Aaronne, tuo fratello, Levita, è uomo ben parlante? e anche, ecco, egli se n'esce fuori a incontrarti; e, veggendoti, si rallegrerà nel suo cuore. ");
INSERT INTO ita1885_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Parlagli adunque, e mettigli in bocca queste parole, ed io sarò con la tua bocca, e con la sua, e v'insegnerò ciò che avrete a fare. ");
INSERT INTO ita1885_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ed egli parlerà per te al popolo; e così egli ti sarà in luogo di bocca, e tu gli sarai in luogo di Dio. ");
INSERT INTO ita1885_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Or prendi questa bacchetta in mano, acciocchè con essa tu faccia que' segni. ");
INSERT INTO ita1885_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","MOSÈ adunque andò; e, ritornato a Ietro, suo suocero, gli disse: Deh! lascia che io me ne vada, e ritorni a' miei fratelli che sono in Egitto e vegga se sono ancora vivi. E Ietro gli disse: Vattene in pace. ");
INSERT INTO ita1885_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Il Signore disse ancora a Mosè nel paese di Madian: Va', ritornatene in Egitto; perciocchè tutti coloro che cercavano l'anima tua son morti. ");
INSERT INTO ita1885_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Mosè adunque prese la sua moglie e i suoi figliuoli; e, postili sopra degli asini, se ne ritornava in Egitto. Mosè prese ancora la bacchetta di Dio nella sua mano. ");
INSERT INTO ita1885_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","E il Signore disse a Mosè: Poichè tu te ne vai per ritornare in Egitto, vedi, fa' davanti a Faraone tutti i miracoli che io ti ho posti in mano; ma io gl'indurerò il cuore, talchè egli non lascerà andare il popolo. ");
INSERT INTO ita1885_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","E tu dirai a Faraone: Così dice il Signore: Israele è mio figliuolo, il mio primogenito. ");
INSERT INTO ita1885_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Or io ti ho detto: Lascia andare il mio figliuolo, acciocchè mi serva; e tu hai ricusato di lasciarlo andare; ecco, io uccido il tuo figliuolo, il tuo primogenito. ");
INSERT INTO ita1885_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ora, essendo Mosè per cammino, in un albergo, il Signore l'incontrò, e cercava di farlo morire. ");
INSERT INTO ita1885_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","E Sippora prese una selce tagliente, e tagliò il prepuzio del suo figliuolo, e lo gittò a' piedi di Mosè, e disse: Certo tu mi sei uno sposo di sangue. ");
INSERT INTO ita1885_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","E il Signore lo lasciò. Allora ella disse: Sposo di sangue, per le circoncisioni. ");
INSERT INTO ita1885_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","E il Signore disse ad Aaronne: Va' incontro a Mosè verso il deserto. Ed egli andò, e lo scontrò, al Monte di Dio, e lo baciò. ");
INSERT INTO ita1885_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","E Mosè dichiarò ad Aaronne tutte le parole del Signore, per le quali lo mandava, e tutti i segni che gli avea comandato di fare. ");
INSERT INTO ita1885_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Mosè adunque, ed Aaronne, andarono, e adunarono tutti gli Anziani de' figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","E Aaronne annunziò loro tutte le parole che il Signore avea dette a Mosè, e fece que' segni nel cospetto del popolo. ");
INSERT INTO ita1885_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","E il popolo credette, e intese che il Signore visitava i figliuoli d'Israele; e ch'egli avea veduta la loro afflizione. Ed essi s'inchinarono, e adorarono. ");
INSERT INTO ita1885_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","POI Mosè ed Aaronne vennero a Faraone, e gli dissero: Così ha detto il Signore Iddio d'Israele: Lascia andare il mio popolo, acciocchè mi celebri una festa nel deserto. ");
INSERT INTO ita1885_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Ma Faraone disse: Chi è il Signore, che io ubbidisca alla sua voce, per lasciare andare Israele? Io non conosco il Signore, e anche non lascerò andare Israele. ");
INSERT INTO ita1885_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ed essi dissero: L'Iddio degli Ebrei ci ha scontrati; deh! lascia che noi andiamo tre giornate di cammino nel deserto, e che sacrifichiamo al Signore Iddio nostro; che talora egli non si avventi sopra noi con pestilenza, o con la spada. ");
INSERT INTO ita1885_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","E il re di Egitto disse loro: O Mosè ed Aaronne, perchè distraete il popolo dalle sue opere? andate a' vostri incarichi. ");
INSERT INTO ita1885_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Faraone disse ancora: Ecco, ora il popolo del paese è in gran numero; e voi lo fate restare da' suoi incarichi. ");
INSERT INTO ita1885_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","E quell'istesso giorno Faraone comandò a' commissari costituiti sopra il popolo, e a' rettori d'esso, e disse: ");
INSERT INTO ita1885_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Non continuate più a dar della paglia a questo popolo, per fare i mattoni, come avete fatto per addietro; vadano essi medesimi, e raccolgansi della paglia. ");
INSERT INTO ita1885_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","E pure imponete loro la medesima somma di mattoni che facevano per addietro; non diminuitene nulla; perciocchè essi sono oziosi, e però gridano, dicendo: Andiamo, sacrifichiamo all'Iddio nostro. ");
INSERT INTO ita1885_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Sia il lavoro aggravato sopra questi uomini; e lavorino intorno ad esso, e non attendano a parole di menzogna. ");
INSERT INTO ita1885_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","I commissari adunque del popolo, e i rettori di esso, uscirono fuori, e dissero al popolo: Così ha detto Faraone: Io non vi darò più paglia. ");
INSERT INTO ita1885_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Andate voi medesimi, e prendetevi della paglia dovunque ne troverete; perciocchè nulla sarà diminuito del vostro lavoro. ");
INSERT INTO ita1885_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","E il popolo si sparse per tutto il paese di Egitto, per raccoglier della stoppia in luogo di paglia. ");
INSERT INTO ita1885_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","E i commissari sollecitavano, dicendo: Fornite le vostre opere, giorno per giorno, come quando avevate della paglia. ");
INSERT INTO ita1885_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","E i rettori dei figliuoli d'Israele, i quali i commissari di Faraone aveano costituiti sopra loro, furono battuti; e fu lor detto: Perchè non avete voi fornito ieri ed oggi la somma de' mattoni che vi è imposta, come per addietro? ");
INSERT INTO ita1885_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","E i rettori de' figliuoli d'Israele vennero, e gridarano a Faraone, dicendo: Perchè fai così a' tuoi servitori? ");
INSERT INTO ita1885_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","E' non si dà paglia a' tuoi servitori, e pur ci dicono: Fate de' mattoni; ed ora i tuoi servitori son battuti; e il tuo popolo commette fallo. ");
INSERT INTO ita1885_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ed egli disse: Voi siete oziosi, voi siete oziosi; perciò dite: Andiamo, sacrifichiamo al Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ora dunque andate, lavorate; e' non vi si darà paglia, e pur renderete la somma de' mattoni. ");
INSERT INTO ita1885_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","E i rettori de' figliuoli d'Israele, veggendoli a mal partito, essendo lor detto: Non diminuite nulla de' mattoni impostivi giorno per giorno, ");
INSERT INTO ita1885_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","quando uscirono d'appresso a Faraone, scontrarono Mosè ed Aaronne, che si presentarono davanti a loro. ");
INSERT INTO ita1885_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ed essi dissero loro: Il Signore riguardi a voi, e facciane giudicio; conciossiachè voi abbiate renduto puzzolente l'odor nostro appo Faraone, e appo i suoi servitori, dando loro in mano la spada per ucciderci. ");
INSERT INTO ita1885_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","E MOSÈ ritornò al Signore, e disse: Signore, perchè hai fatto questo male a questo popolo? perchè mi hai mandato? ");
INSERT INTO ita1885_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Conciossiachè dacchè io son venuto a Faraone, per parlargli in nome tuo, egli abbia trattato male questo popolo; e tu non hai punto liberato il tuo popolo. ");
INSERT INTO ita1885_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Ed il Signore disse a Mosè: Ora vedrai quel ch'io farò a Faraone; perciocchè, sforzato con potente mano, li lascerà andare; anzi, sforzato con potente mano, li caccerà dal suo paese. ");
INSERT INTO ita1885_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Oltre a ciò, Iddio parlò a Mosè, e gli disse: ");
INSERT INTO ita1885_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Io sono il Signore. E apparvi ad Abrahamo, ad Isacco, ed a Giacobbe, sotto il nome di: Dio Onnipotente; ma non fui conosciuto da loro sotto il mio nome di: Colui che è. ");
INSERT INTO ita1885_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","E, come io fermai il mio patto con loro, di dar loro il paese di Canaan, il paese de' lor pellegrinaggi, nel quale dimorarono come forestieri; ");
INSERT INTO ita1885_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","così ancora ho uditi gli stridi de' figliuoli d'Israele, i quali gli Egizj tengono in servitù; e mi son ricordato del mio patto. ");
INSERT INTO ita1885_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Perciò, di' ai figliuoli d'Israele: Io sono il Signore; e vi trarrò di sotto alle gravezze degli Egizj, e vi libererò dalla servitù loro, e vi riscuoterò con braccio steso, e con grandi giudicii. ");
INSERT INTO ita1885_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","E vi prenderò per mio popolo, e sarò vostro Dio; e voi conoscerete ch'io sono il Signore Iddio vostro, che vi traggo di sotto alle gravezze degli Egizj. ");
INSERT INTO ita1885_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","E vi condurrò nel paese, del quale io ho alzata la mano che io lo darei ad Abrahamo, ad Isacco, ed a Giacobbe; e vel darò per possessione ereditaria. Io sono il Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","E Mosè parlò in quella stessa maniera a' figliuoli d'Israele; ma essi non porsero orecchio a Mosè, per l'angoscia dello spirito loro, e per la dura servitù. ");
INSERT INTO ita1885_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","E il Signore parlò a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Va', parla a Faraone, re di Egitto, che lasci andare i figliuoli d'Israele dal suo paese. ");
INSERT INTO ita1885_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","E Mosè parlò nel cospetto del Signore, dicendo: Ecco, i figliuoli di Israele non mi hanno porto orecchio; e come mi porgerebbe orecchio Faraone, essendo io incirconciso di labbra? ");
INSERT INTO ita1885_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ma il Signore parlò a Mosè e ad Aaronne, e comandò loro di andare ai figliuoli d'Israele, e a Faraone, re di Egitto, per trar fuor del paese di Egitto i figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","QUESTI sono i capi delle famiglie paterne di essi: I figliuoli di Ruben, primogenito di Israele, furono Henoc, e Pallu, e Hesron, e Carmi. Queste son le famiglie de' Rubeniti. ");
INSERT INTO ita1885_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","E i figliuoli di Simeone furono Iemuel, e Iamin, e Ohad, e Iachin, e Sohar, e Saul, figliuolo d'una Cananea. Queste son le famiglie de' Simeoniti. ");
INSERT INTO ita1885_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","E questi sono i nomi de' figliuoli di Levi, secondo le lor generazioni: Gherson, e Chehat, e Merari. E gli anni della vita di Levi furono centrentasette. ");
INSERT INTO ita1885_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","I figliuoli di Gherson furono: Libni, e Simi, divisi per le lor generazioni. ");
INSERT INTO ita1885_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","E i figliuoli di Chehat furono: Amram, e Ishar, e Hebron, e Uzziel. E gli anni della vita di Chehat furono centrentatre. ");
INSERT INTO ita1885_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","E i figliuoli di Merari furono Mahali, e Musi. Queste son le famiglie dei Leviti, divise per le lor linee. ");
INSERT INTO ita1885_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Or Amram prese Iochebed, sua zia, per moglie; ed essa gli partorì Aaronne e Mosè. E gli anni della vita di Amram furono centrentasette. ");
INSERT INTO ita1885_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","E i figliuoli di Ishar furono: Core, e Nefeg, e Zicri. ");
INSERT INTO ita1885_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","E i figliuoli di Uzziel furono: Misael, ed Elsafan, e Zicri. ");
INSERT INTO ita1885_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","E Aaronne si prese per moglie Eliseba, figliuola di Amminadab, sorella di Nahasson; ed essa gli partorì Nadab, e Abihu, ed Eleazar, e Itamar. ");
INSERT INTO ita1885_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","E i figliuoli di Core furono: Assir, ed Elcana, e Abiasaf. Queste son le famiglie de' Coriti. ");
INSERT INTO ita1885_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Ed Eleazar, figliuolo di Aaronne si prese per moglie una delle figliuole di Putiel; ed essa gli partorì Finees. Questi sono i capi delle famiglie paterne de' Leviti per le loro schiatte. ");
INSERT INTO ita1885_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Quest'è quell'Aaronne, e quel Mosè, a' quali il Signore disse: Traete fuor del paese di Egitto i figliuoli d'Israele, per le loro schiere. ");
INSERT INTO ita1885_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Essi, cioè Mosè ed Aaronne, furon quelli che parlarono a Faraone, re di Egitto, per trar fuor di Egitto i figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","OR nel giorno che il Signore parlò a Mosè, nel paese di Egitto, ");
INSERT INTO ita1885_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","il Signore gli disse: Io sono il Signore; di' a Faraone, re di Egitto, tutto ciò che io ti dico. ");
INSERT INTO ita1885_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","E Mosè disse nel cospetto del Signore: Ecco, io sono incirconciso di labbra; come dunque Faraone mi porgerebbe egli orecchio? ");
INSERT INTO ita1885_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","E il Signore disse a Mosè: Vedi, io ti ho costituito per essere in luogo di Dio a Faraone; ed Aaronne, tuo fratello, sarà tuo profeta. ");
INSERT INTO ita1885_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Tu dirai tutte le cose che io ti avrò comandate; e parli Aaronne, tuo fratello, a Faraone, acciocchè lasci andar dal suo paese i figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ma io indurerò il cuor di Faraone; e moltiplicherò i miei segni ed i miei prodigi nel paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","E pur ancora Faraone non vi porgerà orecchio; ma io metterò la mia mano in sul paese di Egitto e trarrò fuor del paese di Egitto le mie schiere, il mio popolo, i figliuoli d'Israele, con grandi giudicii. ");
INSERT INTO ita1885_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","E gli Egizj conosceranno che io sono il Signore, quando avrò stesa la mia mano in su l'Egitto, e avrò tratti fuori d'infra loro i figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","E Mosè ed Aaronne fecero così; essi fecero intieramente come il Signore avea lor comandato. ");
INSERT INTO ita1885_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Ora, Mosè era d'età di ottant'anni, e Aaronne di ottantatrè anni, quando parlarono a Faraone. ");
INSERT INTO ita1885_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","E il Signore parlò a Mose e ad Aaronne, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Quando Faraone parlerà a voi, e vi dirà: Fate un prodigio; tu Mosè, di' ad Aaronne: Prendi la tua bacchetta, e gittala davanti a Faraone; ed ella diverrà un serpente. ");
INSERT INTO ita1885_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Mosè adunque ed Aaronne vennero a Faraone, e fecero come il Signore avea comandato. Ed Aaronne gittò la sua bacchetta davanti a Faraone, e davanti ai suoi servitori; ed ella divenne un serpente. ");
INSERT INTO ita1885_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Allora Faraone chiamò eziandio i savi e gl'incantatori. E i Magi di Egitto fecero anch'essi il simigliante co' loro incantesimi. ");
INSERT INTO ita1885_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","E ciascun d'essi gittò la sua bacchetta, ed esse divennero serpenti; ma la bacchetta di Aaronne tranghiottì le lor bacchette. ");
INSERT INTO ita1885_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","E il cuore di Faraone s'indurò, e non porse orecchio a Mosè e ad Aaronne; secondo che il Signore ne avea parlato. ");
INSERT INTO ita1885_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","E IL Signore disse a Mosè: Il cuor di Faraone è aggravato; egli ricusa di lasciare andare il popolo. ");
INSERT INTO ita1885_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Va' questa mattina a Faraone; ecco egli uscirà fuori verso l'acqua, e presentati innanzi a lui in su la riva del fiume, e prendi in mano la bacchetta ch'è stata cangiata in serpente. ");
INSERT INTO ita1885_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","E digli: Il Signore Iddio degli Ebrei mi avea mandato a te, dicendo: Lascia andare il mio popolo, acciocchè mi serva nel deserto; ed ecco, fino a qui tu non hai ubbidito. ");
INSERT INTO ita1885_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Così ha detto il Signore: Da questo conoscerai che io sono il Signore: ecco, io darò una percossa con la bacchetta che io ho in mano, in su le acque che son nel fiume, ed esse saranno cangiate in sangue. ");
INSERT INTO ita1885_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","E il pesce che è nel fiume morrà, e il fiume putirà; e gli Egizj si stancheranno per bere dell'acqua del fiume. ");
INSERT INTO ita1885_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","E il Signore disse a Mosè: Di' ad Aaronne: Prendi la tua bacchetta, e stendi la tua mano sopra le acque degli Egizj, sopra i lor fiumi, sopra i lor rivi, sopra i loro stagni, e sopra ogni raccolta delle loro acque; ed esse diverranno sangue; e vi sarà sangue per tutto il paese di Egitto, eziandio ne' vasi di legno e di pietra. ");
INSERT INTO ita1885_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","E Mosè ed Aaronne fecero come il Signore avea comandato; e Aaronne alzò la bacchetta, e ne percosse le acque ch'erano nel fiume, nel cospetto di Faraone, e nel cospetto dei suoi servitori; e tutte le acque, ch'erano nel fiume, furono cangiate in sangue. ");
INSERT INTO ita1885_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","E il pesce, ch'era nel fiume, morì, e il fiume putì, talchè gli Egizj non potevano ber delle acque del fiume: e vi fu sangue per tutto il paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","E i magi di Egitto fecero il simigliante co' loro incantesimi; e il cuor di Faraone s'indurò, e non porse orecchio a Mosè e ad Aaronne, come il Signore ne avea parlato. ");
INSERT INTO ita1885_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","E Faraone, rivoltosi indietro, se ne venne in casa sua; e non pure a questo pose mente. ");
INSERT INTO ita1885_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","E tutti gli Egizj, cavando intorno al fiume, cercavano acqua da bere; conciossiachè non potessero ber delle acque del fiume. ");
INSERT INTO ita1885_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","E sette giorni intieri passarono, dopo che il Signore ebbe percosso il fiume. ");
INSERT INTO ita1885_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","POI il Signore disse a Mosè: Vattene a Faraone, e digli: Così ha detto il Signore: Lascia andare il mio popolo, acciocchè egli mi serva. ");
INSERT INTO ita1885_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","E se tu ricusi di lasciarlo andare, ecco, io percuoterò con rane tutto il tuo paese. ");
INSERT INTO ita1885_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","E il fiume produrrà copiosamente rane; le quali saliranno fuori, ed entreranno in casa tua, e nella camera dove tu giaci, e in sul tuo letto, e nelle case dei tuoi servitori, e fra il tuo popolo, e nei tuoi forni, e nelle tue madie. ");
INSERT INTO ita1885_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","E le rane saliranno contro a te, e contro al tuo popolo, e contro a tutti i tuoi servitori. ");
INSERT INTO ita1885_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Poi il Signore disse a Mosè: Di' ad Aaronne: Stendi la tua mano con la tua bacchetta sopra i fiumi, sopra i rivi, e sopra gli stagni, e fanne salir le rane in sul paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","E Aaronne stese la sua mano sopra le acque di Egitto, e le rane salirono, e copersero il paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","E i Magi di Egitto fecero il simigliante co' loro incantesimi; e fecero salir rane in sul paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","E Faraone chiamò Mosè ed Aaronne, e disse loro: Pregate il Signore che rimuova da me, e dal mio popolo, queste rane; ed io lascerò andare il popolo, acciocchè sacrifichi al Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","E Mosè disse a Faraone: Gloriati pur sopra me; per quando pregherò io il Signore per te, e per i tuoi servitori, e per il tuo popolo, ch'egli stermini le rane d'appresso a te, e dalle tue case, e che rimangano solo nel fiume? ");
INSERT INTO ita1885_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Ed egli disse: Per domani. E Mosè disse: Sarà fatto secondo la tua parola; acciocchè tu sappi che non vi è alcuno pari all'Iddio nostro. ");
INSERT INTO ita1885_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","E le rane si partiranno da te, e dalle tue case, e da' tuoi servitori, e dal tuo popolo; e rimarranno solo nel fiume. ");
INSERT INTO ita1885_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","E Mosè ed Aaronne uscirono d'appresso a Faraone. E Mosè gridò al Signore intorno al fatto delle rane, ch'egli avea mandate contro a Faraone. ");
INSERT INTO ita1885_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","E il Signore fece secondo la parola di Mosè; e le rane morirono; e le case, e i cortili, e i campi ne furono liberati. ");
INSERT INTO ita1885_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","E gli Egizj le raccolsero per mucchi, e la terra ne putì. ");
INSERT INTO ita1885_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Ma Faraone, veggendo che vi era dell'alleggerimento, aggravò il suo cuore, e non porse orecchio a Mosè e ad Aaronne, come il Signore ne avea parlato. ");
INSERT INTO ita1885_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","E IL Signore disse a Mosè: Di' ad Aaronne: Stendi la tua bacchetta, e percuoti la polvere della terra, ed ella diverrà mosconi in tutto il paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ed essi fecero così; e Aaronne stese la sua mano con la sua bacchetta, e percosse la polvere della terra; e una moltitudine di mosconi venne in su gli uomini, e in su gli animali; tutta la polvere della terra divenne mosconi in tutto il paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","E i Magi si adoperarono anch'essi simigliantemente co' loro incantesimi, per produrre mosconi; ma non poterono. E quella moltitudine di mosconi fu sopra gli uomini, e sopra gli animali. ");
INSERT INTO ita1885_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","E i Magi dissero a Faraone: Questo è il dito di Dio. Ma il cuor di Faraone s'indurò, e non porse loro orecchio; come il Signore ne avea parlato. ");
INSERT INTO ita1885_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","POI il Signore disse a Mosè: Levati da mattina, e presentati davanti a Faraone; ecco, egli uscirà fuori verso l'acqua; e digli: Così ha detto il Signore: ");
INSERT INTO ita1885_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Lascia andare il mio popolo, acciocchè mi serva. Perciocchè, se tu non lasci andare il mio popolo, ecco, io manderò sopra te, sopra i tuoi servitori, sopra il tuo popolo, e sopra le tue case, una mischia d'insetti; e le case degli Egizj, e la terra sopra la quale abitano, saranno ripiene di quella mischia. ");
INSERT INTO ita1885_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Ma in quel giorno io lascerò da parte la contrada di Gosen, nella quale sta il mio popolo; talchè non vi sarà alcuna mischia; acciocchè tu conosca che io sono il Signore in mezzo della terra. ");
INSERT INTO ita1885_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ed io metterò una salvaguardia tra il mio popolo e il tuo popolo; domani avverrà questo segno. ");
INSERT INTO ita1885_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","E il Signore fece così; e venne una gran mischia d'insetti nella casa di Faraone, e nelle case de' suoi servitori; e la terra fu guasta da questa mischia d'insetti per tutto il paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","E Faraone chiamò Mosè ed Aaronne, e disse: Andate, sacrificate al vostro Dio nel paese. ");
INSERT INTO ita1885_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ma Mosè disse: E' non è convenevole di far così; conciossiachè noi abbiamo a sacrificare al Signore Iddio nostro cose, che gli Egizj abbominano di sacrificare; ecco, se noi sacrificassimo davanti agli occhi degli Egizj ciò ch'essi abbominano di sacrificare, non ci lapiderebbero essi? ");
INSERT INTO ita1885_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Lascia che andiamo tre giornate di cammino nel deserto, e noi sacrificheremo al Signore Iddio nostro, secondo ch'egli ci dirà. ");
INSERT INTO ita1885_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","E Faraone disse: Io vi lascerò andare, acciocchè sacrifichiate al Signore Iddio vostro nel deserto; sol che non andiate più lungi; pregate per me. ");
INSERT INTO ita1885_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","E Mosè disse: Ecco, io esco di presente d'appresso a te, e pregherò il Signore, e la mischia degl'insetti si partirà domani da Faraone, da' suoi servitori, e dal suo popolo; ma non continui Faraone a farsi beffe, per non lasciare andare il popolo, per sacrificare al Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","E Mosè uscì fuori d'appresso a Faraone, e pregò il Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","E il Signore fece secondo la parola di Mosè; e rimosse quella mischia d'insetti da Faraone, da' suoi servitori, e dal suo popolo; non ve ne restò pur uno. ");
INSERT INTO ita1885_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ma Faraone ancora questa volta aggravò il suo cuore, e non lasciò andare il popolo. ");
INSERT INTO ita1885_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","E IL Signore disse a Mosè: Entra da Faraone, e digli: Così ha detto il Signore Iddio degli Ebrei: Lascia andare il mio popolo, acciocchè mi serva. ");
INSERT INTO ita1885_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Perciocchè se tu ricusi di lasciarlo andare, e se tu lo ritieni ancora; ");
INSERT INTO ita1885_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ecco, la mano del Signore sarà sopra il tuo bestiame ch'è per li campi, sopra i cavalli, sopra gli asini, sopra i cammelli, sopra i buoi, e sopra le pecore, con una grandissima mortalità. ");
INSERT INTO ita1885_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","E il Signore metterà separazione fra il bestiame degl'Israeliti, e il bestiame degli Egizj; e nulla, di tutto quel che appartiene a' figliuoli d'Israele, morrà. ");
INSERT INTO ita1885_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","E il Signore pose un termine, dicendo: Domani il Signore farà questa cosa nel paese. ");
INSERT INTO ita1885_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","E il giorno seguente il Signore fece quello; e ogni bestiame degli Egizj morì, ma del bestiame de' figliuoli d'Israele non ne morì alcuna bestia. ");
INSERT INTO ita1885_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","E Faraone mandò a vedere; ed ecco, del bestiame degl'Israeliti non era morta pure una bestia. Ma pure il cuor di Faraone si aggravò e non lasciò andare il popolo. ");
INSERT INTO ita1885_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","E IL Signore disse a Mosè e ad Aaronne: Prendetevi delle menate di faville di fornace, e spargale Mosè verso il cielo, davanti agli occhi di Faraone. ");
INSERT INTO ita1885_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","E quelle diverranno polvere, che si spargerà sopra tutto il paese di Egitto; onde, sopra gli uomini, e sopra gli animali nasceranno ulcere, dalle quali germoglieranno bolle in tutto il paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Essi adunque presero delle faville di fornace; e, presentatisi davanti a Faraone, Mosè sparse quelle verso il cielo; e da esse nacquero, negli uomini e negli animali, ulcere dalle quali germogliavano bolle. ");
INSERT INTO ita1885_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","E i Magi non poterono stare in piè davanti a Mosè, per cagion di quell'ulcere; perciocchè quell'ulcere erano sopra i Magi, come sopra tutti gli Egizj. ");
INSERT INTO ita1885_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","E il Signore indurò il cuor di Faraone; ed egli non porse orecchio a Mosè e ad Aaronne, come il Signore ne avea parlato a Mosè. ");
INSERT INTO ita1885_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","POI il Signore disse a Mosè: Levati da mattina, e presentati a Faraone, e digli: Così ha detto il Signore Iddio degli Ebrei: Lascia andare il mio popolo, acciocchè mi serva. ");
INSERT INTO ita1885_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Perciocchè questa volta io manderò tutte le mie piaghe nel tuo cuore, e sopra i tuoi servitori, e sopra il tuo popolo; acciocchè tu conosca che non vi è alcuno pari a me in tutta la terra. ");
INSERT INTO ita1885_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Conciossiachè, se io avessi stesa la mano, potrei aver percosso te e il tuo popolo, con la mortalità; e tu saresti stato sterminato d'in su la terra. ");
INSERT INTO ita1885_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ma pur perciò ti ho costituito, acciocchè in te si vegga la mia potenza, e che il mio Nome sia predicato per tutta la terra. ");
INSERT INTO ita1885_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ancora t'innalzi contro al mio popolo, per non lasciarlo andare? ");
INSERT INTO ita1885_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ecco, domani, intorno a quest'ora, io farò piovere una gravissima gragnuola, la cui simile non fu giammai in Egitto, dal giorno che fu fondato, fino ad ora. ");
INSERT INTO ita1885_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ora dunque, manda a fare accogliere tutto il tuo bestiame, e tutto ciò ch'è del tuo per li campi; la gragnuola caderà sopra tutti gli uomini, e sopra gli animali che si traveranno per li campi e non saranno accolti in casa; e morranno. ");
INSERT INTO ita1885_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","D'infra i servitori di Faraone, chi temette la parola del Signore fece rifuggire i suoi servitori, e il suo bestiame, nelle case. ");
INSERT INTO ita1885_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ma chi non pose mente alla parola del Signore lasciò i suoi servitori, e il suo bestiame, per li campi. ");
INSERT INTO ita1885_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","E il Signore disse a Mosè: Stendi la tua mano verso il cielo, a caderà gragnuola in tutto il paese di Egitto, sopra gli uomini, e sopra gli animali, e sopra tutta l'erba de' campi, nel paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","E Mosè stese la sua bacchetta verso il cielo; e il Signore fece tonare, e cader gragnuola; e il fuoco si avventava verso la terra; e il Signore fece piover gragnuola sopra il paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","E vi fu gragnuola e fuoco avviluppato per mezzo essa gragnuola, la quale era molto fiera, la cui pari non fu giammai in tutto il paese degli Egizj, da che essi son divenuti nazione. ");
INSERT INTO ita1885_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","E la gragnuola percosse, in tutto il paese di Egitto, tutto quello ch'era per li campi, così uomini come animali; percosse ancora tutta l'erba de' campi, e spezzò tutti gli alberi de' campi. ");
INSERT INTO ita1885_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Sol nella contrada di Gosen, dove erano i figliuoli d'Isaele, non vi fu gragnuola. ");
INSERT INTO ita1885_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","E Faraone mandò a chiamar Mosè ed Aaronne, e disse loro: Questa volta io ho peccato; il Signore è il giusto; ma io e il mio popolo siamo i colpevoli. ");
INSERT INTO ita1885_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Pregate il Signore, acciocchè basti, e che non vi sieno più tuoni di Dio, nè gragnuola; ed io vi lascerò andare, e non resterete più. ");
INSERT INTO ita1885_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","E Mosè gli disse: Come io sarò uscito fuor della città, io spanderò le palme delle mani verso il Signore; e i tuoni cesseranno, e la gragnuola non sarà più; acciocchè tu conosca che la terra e del Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ma io so che nè tu, nè i tuoi servitori, non avrete ancora timore del Signore Iddio. ");
INSERT INTO ita1885_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Or il lino e l'orzo furono percossi; perciocchè l'orzo era già in ispiga, mezzo maturo, e il lino in gambo. ");
INSERT INTO ita1885_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ma il grano e la spelta non furono percossi; perciocchè erano più serotini. ");
INSERT INTO ita1885_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Mosè adunque uscì fuor della città, d'appresso a Faraone, e sparse le palme delle sue mani verso il Signore; e cessarono i tuoni e la gragnuola; e la pioggia non fu più versata sopra la terra. ");
INSERT INTO ita1885_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","E Faraone, veggendo ch'era cessata la pioggia, la gragnuola, ed i tuoni, continuò a peccare, e aggravò il cuor suo, egli, e i suoi servitori. ");
INSERT INTO ita1885_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","E il cuor di Faraone s'indurò, ed egli non lasciò andare i figliuoli d'Israele; come il Signore ne avea parlato per Mosè. ");
INSERT INTO ita1885_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","E IL Signore disse a Mosè: Entra da Faraone; perciocchè io ho aggravato il suo cuore, e il cuore dei suoi servitori, acciocchè io ponga questi miei segni in mezzo del suo paese; ");
INSERT INTO ita1885_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","e acciocchè tu racconti al tuo figliuolo, e al figliuolo del tuo figliuolo, ciò che io avrò operato in Egitto, e i segni che avrò fatti fra loro; e che voi conosciate che io sono il Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Mosè adunque ed Aaronne entrarono da Faraone, e gli dissero: Così ha detto il Signore Iddio degli Ebrei: Fino a quando ricuserai d'umiliarti davanti alla mia faccia? lascia andare il mio popolo, acciocchè mi serva. ");
INSERT INTO ita1885_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Perciocchè, se tu ricusi di lasciarlo andare, ecco, io fo venir domane delle locuste nelle tue contrade. ");
INSERT INTO ita1885_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Ed esse copriranno la faccia della terra, talchè la terra non si potrà vedere; e mangeranno il rimanente ch'è scampato, quel che vi è restato dalla gragnuola; mangeranno ancora ogni albero che vi germoglia fuori ne' campi. ");
INSERT INTO ita1885_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ed empieranno le tue case, e le case di tutti i tuoi servitori, e le case di tutti gli Egizj; il che nè i tuoi padri nè i padri de' tuoi padri, giammai non videro, dal giorno che furono in su la terra, infino ad oggi. Detto questo, egli si rivoltò indietro, e uscì d'appresso a Faraone. ");
INSERT INTO ita1885_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","E i servitori di Faraone gli dissero: Fino a quando ci sarà costui per laccio? lascia andar questi uomini acciocchè servano al Signore Iddio loro; non sai tu ancora che l'Egitto è perito? ");
INSERT INTO ita1885_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Allora Mosè ed Aaronne furono fatti tornare a Faraone; ed egli disse loro: Andate, servite al Signore Iddio vostro; ma chi e chi son coloro che andranno? ");
INSERT INTO ita1885_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","E Mosè disse: Noi andremo co' nostri fanciulli, e co' nostri vecchi; noi andremo co' nostri figliuoli, e con le nostre figliuole; con le nostre gregge, e co' nostri armenti; perciocchè abbiamo a celebrare una festa al Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Ed egli disse loro: Così sia il Signore con voi, come io vi lascerò andare con le vostre famiglie; guardate, perciocchè il male vi soprastà davanti agli occhi. ");
INSERT INTO ita1885_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","E' non sarà così; andate ora voi uomini, e servite al Signore; poichè questo è quel che voi cercate. E Faraone li cacciò dal suo cospetto. ");
INSERT INTO ita1885_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","E il Signore disse a Mosè: Stendi la tua mano sopra il paese di Egitto, per far venir le locuste; ed esse saliranno sopra il paese di Egitto, e mangeranno tutta l'erba della terra; tutto quel che la gragnuola ha lasciato di resto. ");
INSERT INTO ita1885_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","E Mosè stese la sua bacchetta sopra il paese di Egitto; e il Signore fece venire un vento orientale in sul paese tutto quel giorno, e tutta quella notte; e, come fu mattina, il vento orientale avea portate le locuste. ");
INSERT INTO ita1885_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","E le locuste salirono sopra tutto il paese di Egitto, e si posarono per tutte le contrade di Egitto, in grandissima moltitudine; avanti quelle non ne furono, e dopo quelle non ne saranno giammai di tali. ");
INSERT INTO ita1885_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ed esse copersero la faccia di tutto il paese, talchè il paese ne fu scurato, e mangiarono tutta l'erba del paese, e tutti i frutti degli alberi, i quali la gragnuola avea lasciati di resto; e non rimase alcun verdume negli alberi, nè nell'erbe dei campi per tutto il paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Allora Faraone fece prestamente chiamar Mosè ed Aaronne, e disse loro: Io ho peccato contro al Signore Iddio vostro, e contro a voi. ");
INSERT INTO ita1885_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ma ora perdonami, ti prego, il mio peccato, sol questa volta; e pregate il Signore Iddio vostro, che rimuova d'addosso a me sol questa morte. ");
INSERT INTO ita1885_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","E Mosè uscì d'appresso a Faraone, e pregò il Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","E il Signore voltò il vento in un fortissimo vento occidentale, il qual portò via le locuste, e le affondò nel mar rosso; e' non vi restò una sola locusta in tutti i confini di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ma il Signore indurò il cuor di Faraone; ed egli non lasciò andare i figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","E IL Signore disse a Mosè: Stendi la tua mano verso il cielo, e verranno tenebre sopra il paese di Egitto, tali che si potranno tastar con le mani. ");
INSERT INTO ita1885_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","E Mosè stese la sua mano verso il cielo, e vennero tenebre caliginose in tutto il paese di Egitto, per lo spazio di tre giorni. ");
INSERT INTO ita1885_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","L'uno non vedeva l'altro; e niuno si levò dal suo luogo, per lo spazio di tre giorni; ma tutti i figliuoli d'Israele ebbero luce nelle loro stanze. ");
INSERT INTO ita1885_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","E Faraone chiamò Mosè, e disse: Andate, servite al Signore; sol le vostre gregge e i vostri armenti saranno fatti restare; le vostre famiglie eziandio andranno con voi. ");
INSERT INTO ita1885_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","E Mosè disse: Tu ci concederai pure ancora di prender sacrificii ed olocausti, per offerire al Signore Iddio nostro. ");
INSERT INTO ita1885_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Anche il nostro bestiame verrà con noi, senza che ne rimanga pure un'unghia; perciocchè di esso noi abbiamo a prendere da servire al Signore Iddio nostro; e noi non sappiamo con che abbiamo a servire al Signore, finchè siamo arrivati là. ");
INSERT INTO ita1885_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ma il Signore indurò il cuor di Faraone, ed egli non volle lasciarli andare. ");
INSERT INTO ita1885_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","E Faraone disse a Mosè: Vattene d'appresso a me; guardati che tu non vegga mai più la mia faccia; perciocchè nel giorno che tu vedrai la mai faccia, tu morrai. ");
INSERT INTO ita1885_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","E Mosè disse: Tu hai parlato bene: io non vedrò più la tua faccia. ");
INSERT INTO ita1885_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","E IL Signore disse a Mosè: Io farò venire ancora una piaga sopra Faraone, e sopra l'Egitto; e poi egli vi lascerà andar di qui; quando egli vi lascerà andare, egli del tutto vi scaccerà tutti quanti di qui. ");
INSERT INTO ita1885_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Parla ora al popolo, e digli che ciascuno uomo chiegga al suo amico, e ciascuna donna alla sua amica, vasellamenti di argento, e vasellamenti d'oro. ");
INSERT INTO ita1885_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","E il Signore rendette grazioso il popolo agli Egizj; e anche quell'uomo Mosè era molto grande nel paese di Egitto, appo i servitori di Faraone, ed appo il popolo. ");
INSERT INTO ita1885_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","E Mosè disse: Così ha detto il Signore: In su la mezza notte io uscirò fuori, e passerò per mezzo l'Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","E ogni primogenito morrà nel paese di Egitto, dal primogenito di Faraone che siede sopra il suo trono, fino al primogenito della serva che è dietro alle macine; e anche ogni primogenito degli animali. ");
INSERT INTO ita1885_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","E vi sarà un gran grido per tutto il paese di Egitto, il cui pari non fu, nè sarà giammai più. ");
INSERT INTO ita1885_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Ma appresso tutti i figliuoli d'Israele, così fra gli uomini, come fra gli animali, non pure un cane moverà la lingua; acciocchè voi sappiate che il Signore avrà messa separazione fra gli Egizj e gl'Israeliti. ");
INSERT INTO ita1885_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Allora tutti questi tuoi servitori scenderanno a me, e s'inchineranno davanti a me, dicendo: Partiti, tu, e il popolo che è al tuo seguito; e, dopo quello, io me ne partirò. E Mosè se ne uscì d'appresso a Faraone, acceso d'ira. ");
INSERT INTO ita1885_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Or il Signore aveva detto a Mosè: Faraone non vi porgerà orecchio; acciocchè io moltiplichi i miei prodigi nel paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","E Mosè ed Aaronne fecero tutti questi prodigi nel cospetto di Faraone, ma il Signore indurò il cuor di Faraone, ed egli non lasciò andare i figliuoli d'Israele fuori del suo paese. ");
INSERT INTO ita1885_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","OR il Signore parlò a Mosè e ad Aaronne nel paese di Egitto, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Questo mese vi sarà il principio de' mesi; egli vi sarà il primo dei mesi dell'anno. ");
INSERT INTO ita1885_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Parlate a tutta la raunanza d'Israele, dicendo; Nel decimo giorno di questo mese, ciascuna casa di padre di famiglia prenda un agnello o un capretto; uno per casa. ");
INSERT INTO ita1885_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ma se la famiglia è minore che non conviene per mangiar quell'agnello o capretto, prendalo il padre della famiglia in compagnia del suo vicino, il più prossimo di casa sua, con un certo numero di persone, il quale voi conterete, facendo ragione su l'agnello o il capretto, secondo che ciascuno può mangiare. ");
INSERT INTO ita1885_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Prendete quell'agnello o quel capretto, senza difetto, maschio, di un anno, d'infra le pecore, o d'infra le capre. ");
INSERT INTO ita1885_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","E tenetelo in guardia fino al quartodecimo giorno di questo mese; e allora tutta la raunanza della comunanza d'Israele lo scanni fra i due vespri. ");
INSERT INTO ita1885_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","E prendasene del sangue, e mettasene sopra i due stipiti, e sopra il limitar di sopra della porta, nelle case nelle quali si mangerà. ");
INSERT INTO ita1885_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","E mangisene quella stessa notte la carne arrostita al fuoco, con pani azzimi, e lattughe salvatiche. ");
INSERT INTO ita1885_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Non mangiate nulla di esso crudo, o pur lesso nell'acqua; ma arrostito al fuoco, capo, gambe e interiora. ");
INSERT INTO ita1885_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","E non ne lasciate nulla di resto fino alla mattina; e ciò che sarà restato fino alla mattina, bruciatelo col fuoco. ");
INSERT INTO ita1885_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Or mangiatelo in questa maniera: abbiate i lombi cinti, e i vostri calzamenti ne' piedi, e il vostro bastone in mano, e mangiatelo in fretta. Esso è il Passaggio del Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","E quella notte io passerò per lo paese di Egitto, e percuoterò ogni primogenito nel paese di Egitto, così d'uomini come di animali; e farò ancora giudicii sopra tutti gl'iddii di Egitto. Io sono il Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","E quel sangue vi sarà per un segnale, nelle case nelle quali sarete; e quando io vedrò quel sangue, passerò oltre senza toccarvi; e non vi sarà fra voi alcuna piaga a distruzione, mentre io percuoterò il paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","E quel giorno vi sarà per una ricordanza, e voi lo celebrerete per festa solenne, al Signore; voi lo celebrerete per festa solenne, per istatuto perpetuo, per le vostre età. ");
INSERT INTO ita1885_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Voi mangerete per sette giorni pani azzimi; anzi fin dal primo giorno farete che non vi sia alcun lievito nelle vostre case; perciocchè, se alcuno mangia cosa alcuna lievitata dal primo giorno fino al settimo, quella persona sarà ricisa d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","E nel primo giorno voi avrete santa raunanza; siavi parimente santa raunanza nel settimo giorno; non facciasi alcun'opera in que' giorni; solo vi si apparecchi quel che ciascuna persona deve mangiare e non altro. ");
INSERT INTO ita1885_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Osservate adunque l'osservanza de' pani azzimi; perciocchè in quel giorno stesso io avrò tratte le vostre schiere fuor del paese di Egitto; perciò osservate quel giorno per le vostre età, per istatuto perpetuo. ");
INSERT INTO ita1885_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Mangiate pani azzimi, dal quartodecimo giorno del primo mese al vespro, fino al ventunesimo giorno di esso mese al vespro. ");
INSERT INTO ita1885_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Non trovisi alcun lievito nelle vostre case per sette giorni; perciocchè, se alcuno mangia cosa alcuna lievitata, quella persona sarà ricisa dalla raunanza d'Israele; forestiere, o natio del paese, ch'egli si sia. ");
INSERT INTO ita1885_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Non mangiate nulla di lievitato; mangiate pani azzimi in tutte le vostre stanze. ");
INSERT INTO ita1885_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Mosè adunque chiamò tutti gli Anziani d'Israele, e disse loro: Traete fuori, e prendetevi un agnello, o un capretto, per ciascuna delle vostre famiglie, e scannate la Pasqua. ");
INSERT INTO ita1885_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Pigliate eziandio un mazzuol d'isopo, e intignetelo nel sangue che sarà nel bacino; e spruzzate di quel sangue che sarà nel bacino il limitar disopra, e i due stipiti delle porte; e non esca alcun di voi fuor dell'uscio della sua casa fino alla mattina. ");
INSERT INTO ita1885_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","E quando il Signore passerà per percuoter gli Egizj, egli vedrà il sangue sopra il limitare, e sopra i due stipiti; e trapasserà oltre alla porta, e non permetterà al distruttore di entrar nelle vostre case per percuotere. ");
INSERT INTO ita1885_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Voi dunque osservate questa cosa, come uno statuto imposto a te e a' tuoi figliuoli, in perpetuo. ");
INSERT INTO ita1885_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","E quando voi sarete entrati nel paese che il Signore vi darà, come egli ne ha parlato, osservate questo servigio. ");
INSERT INTO ita1885_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","E quando i vostri figliuoli vi diranno: Che vuol dire questo servigio che voi fate? dite: ");
INSERT INTO ita1885_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Quest'è il sacrificio della Pasqua del Signore, il quale trapassò oltre alle case de' figliuoli d'Israele in Egitto, quando egli percosse gli Egizj, e salvò le nostre case. ");
INSERT INTO ita1885_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","E il popolo s'inchinò e adorò. E i figliuoli d'Israele andarono, e fecero interamente come il Signore avea comandato a Mosè e ad Aaronne. ");
INSERT INTO ita1885_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","E ALLA mezza notte il Signore percosse tutti i primogeniti nel paese di Egitto, dal primogenito di Faraone, che sedeva sopra il suo trono, fino al primogenito del prigione che era nella carcere; ed anche tutti i primogeniti degli animali. ");
INSERT INTO ita1885_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","E Faraone si levò di notte, egli, e tutti i suoi servitori, e tutti gli Egizj; e vi fu un gran grido in Egitto; perciocchè non vi era alcuna casa ove non fosse un morto. ");
INSERT INTO ita1885_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","E Faraone chiamò Mosè ed Aaronne, di notte, e disse: Levatevi, partitevi di mezzo il mio popolo, voi, e i figliuoli d'Israele; e andate, servite al Signore, secondo che avete detto. ");
INSERT INTO ita1885_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Pigliate le vostre gregge e i vostri armenti, come avete detto; e andatevene, ed anche beneditemi. ");
INSERT INTO ita1885_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","E gli Egizj sollecitavano instantemente il popolo, affrettandosi di mandarlo via dal paese; perciocchè dicevano: Noi siam tutti morti. ");
INSERT INTO ita1885_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","E il popolo tolse la sua pasta, avanti che fosse lievitata, avendo le sue madie involte ne' suoi vestimenti, in su le spalle. ");
INSERT INTO ita1885_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Or i figliuoli d'Israele aveano fatto secondo la parola di Mosè: e aveano chiesto agli Egizj vasellamenti di argento, e vasellamenti d'oro, e vestimenti. ");
INSERT INTO ita1885_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","E il Signore avea reso grazioso il popolo agli Egizj, onde essi gli aveano prestate quelle cose. Così, spogliarono gli Egizj. ");
INSERT INTO ita1885_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","E i figliuoli d'Israele si partirono di Rameses, e pervennero a Succot, essendo intorno a seicentomila uomini a piè, oltre alle famiglie. ");
INSERT INTO ita1885_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Una gran turba ancora di gente mescolata salì con loro; e grandissimo numero di bestiame, minuto e grosso. ");
INSERT INTO ita1885_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ed essi cossero la pasta che aveano portata fuor di Egitto, in focacce azzime; conciossiachè non fosse lievitata; perciocchè, essendo scacciati dagli Egizj, non si erano potuti indugiare, ed anche non si aveano apparecchiata alcuna vivanda. ");
INSERT INTO ita1885_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Or la dimora che i figliuoli d'Israele fecero in Egitto fu di quattrocentrent'anni. ");
INSERT INTO ita1885_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","E al termine di quattrocentrent'anni, lo stesso giorno che quelli finivano, avvenne che tutte le schiere del Signore uscirono fuor del paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Quest'è la notte dell'osservanze, consecrata al Signore, quando egli trasse fuor del paese di Egitto i figliuoli d'Israele; quest'è la notte consecrata al Signore, che si deve celebrare con ogni osservanza da tutti i figliuoli d'Israele, per le loro età. ");
INSERT INTO ita1885_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","E IL Signore disse a Mosè e ad Aaronne: Quest'è lo statuto della Pasqua. Niun forestiere ne mangi. ");
INSERT INTO ita1885_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Ma qualunque servo di chi che sia comperato con danari, dopo che tu l'avrai circonciso, ne mangerà. ");
INSERT INTO ita1885_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","L'avveniticcio e il mercenario non ne mangino. ");
INSERT INTO ita1885_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Mangisi in una stessa casa; non portar fuor di casa della carne di essa, e non ne rompete alcun osso. ");
INSERT INTO ita1885_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Facciala tutta la raunanza d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","E quando un forestiere dimorerà teco, e vorrà far la Pasqua del Signore, circoncidasi prima ogni maschio di casa sua; e allora accostisi per farla, e sia come colui ch'è natio del paese; ma niuno incirconciso ne mangi. ");
INSERT INTO ita1885_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Siavi una stessa legge per colui ch'è natio del paese, e per lo forestiere che dimora per mezzo di voi. ");
INSERT INTO ita1885_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","E tutti i figliuoli d'Israele fecero interamente come il Signore avea comandato a Mosè e ad Aaronne. ");
INSERT INTO ita1885_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","E in quello stesso giorno avvenne che il Signore trasse fuor del paese di Egitto i figliuoli d'Israele, per le loro schiere. ");
INSERT INTO ita1885_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","E IL Signore parlò a Mosè, dicendo: Consacrami ogni primogenito, ");
INSERT INTO ita1885_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","tutto quello che apre la matrice fra i figliuoli d'Israele, così degli uomini come degli animali; esso è mio. ");
INSERT INTO ita1885_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","E Mosè disse al popolo: Ricordatevi di questo giorno, nel quale siete usciti di Egitto, della casa di servitù; conciossiachè il Signore ve ne abbia tratti fuori con potente mano; perciò non mangisi alcuna cosa lievitata. ");
INSERT INTO ita1885_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Oggi voi uscite fuori nel mese di Abib. ");
INSERT INTO ita1885_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Quando adunque il Signore ti avrà introdotto, nel paese de' Cananei, degl'Hittei, degli Amorrei, degl'Hivvei, e de' Gebusei, ch'egli giurò a' tuoi padri di darti, ch'è un paese stillante latte e miele, osserva questo servigio in questo mese. ");
INSERT INTO ita1885_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Mangia per sette giorni pani azzimi; e nel settimo giorno siavi festa solenne al Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Manginsi pani azzimi per sette giorni, e non veggasi appo te cosa lievitata, nè lievito, in tutti i tuoi confini. ");
INSERT INTO ita1885_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","E in quel giorno dichiara questa cosa a' tuoi figliuoli, dicendo: Questo si fa per cagion di quello che mi fece il Signore, quando io uscii di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","E ciò ti sia per segnale sopra la tua mano, e per ricordanza fra' tuoi occhi; acciocchè la Legge del Signore sia nella tua bocca; conciossiachè egli ti abbia tratto fuori di Egitto con potente mano. ");
INSERT INTO ita1885_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","E osserva questo statuto d'anno in anno, nella sua stagione. ");
INSERT INTO ita1885_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","E quando il Signore ti avrà introdotto nel paese de' Cananei, come egli ha giurato a te e a' tuoi padri, e te l'avrà dato; ");
INSERT INTO ita1885_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","rassegna al Signore tutto ciò che apre la matrice: parimente, d'ogni primo portato del tuo bestiame, i maschi apparterranno al Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Ma riscatta ogni primo portato dell'asino, con un agnello, o con un capretto; e se tu non lo riscatti, fiaccagli il collo: riscatta eziandio ogni primogenito dell'uomo d'infra i tuoi figliuoli. ");
INSERT INTO ita1885_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","E quando per innanzi il tuo figliuolo ti domanderà: Che vuol dir questo? digli: Il Signore ci trasse fuori di Egitto, della casa di servitù, con potenza di mano. ");
INSERT INTO ita1885_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","E avvenne che, mostrandosi Faraone duro a lasciarci andare, il Signore uccise tutti i primogeniti nel paese di Egitto, da' primogeniti degli uomini, fino a' primogeniti delle bestie; perciò io sacrifico al Signore i maschi d'ogni primo portato, e riscatto ogni primogenito de' miei figliuoli. ");
INSERT INTO ita1885_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ciò adunque ti sarà per segnale sopra la tua mano, e per frontali fra' tuoi occhi, che il Signore ci ha tratti fuori di Egitto con potenza di mano. ");
INSERT INTO ita1885_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","OR, quando Faraone ebbe lasciato andare il popolo, Iddio, non condusse quello per la via del paese de' Filistei; benchè quella fosse la più corta; perciocchè Iddio disse: Che talora il popolo non si penta, quando vedrà la guerra, e non se ne ritorni in Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ma Iddio fece fare un giro al popolo, traendo al deserto, verso il mar rosso. E i figliuoli d'Israele salirono del paese di Egitto in oardinanza. ");
INSERT INTO ita1885_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","E Mosè prese seco l'ossa di Giuseppe; perciocchè egli avea espressamente fatto giurare i figliuoli d'Israele, dicendo: Iddio per certo vi visiterà; allora trasportate di qui le mie ossa con voi. ");
INSERT INTO ita1885_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","E gl'Israeliti, partitisi di Succot, si accamparono in Etam all'estremità del deserto. ");
INSERT INTO ita1885_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","E il Signore camminava davanti a loro; di giorno, in una colonna di nuvola, per guidarli per lo cammino; e di notte, in una colonna di fuoco, per illuminarli; acciocchè camminassero giorno e notte. ");
INSERT INTO ita1885_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Egli non rimosse dal cospetto del popolo la colonna della nuvola di giorno, nè la colonna del fuoco di notte. ");
INSERT INTO ita1885_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","E il Signore parlò a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Di' a' figliuoli d'Israele, che si rivolgano, e si accampino dinanzi alla foce d'Hirot, fra Migdol e il mare, dirincontro a Baal-sefon; ponete campo presso al mare, dirimpetto a quel luogo. ");
INSERT INTO ita1885_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","E Faraone dirà de' figliuoli d'Israele: Sono intrigati nel paese; il deserto ha lor serrato il passo. ");
INSERT INTO ita1885_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ed io indurerò il cuor di Faraone, talchè egli li perseguiterà, ed io sarò glorificato in Faraone e in tutto il suo esercito; e gli Egizj conosceranno ch'io sono il Signore. Ed essi fecero così. ");
INSERT INTO ita1885_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Or fu rapportato al re di Egitto, che il popolo se ne fuggiva; e il cuore di Faraone e de' suoi servitori si mutò inverso il popolo, e dissero: Che cosa è questo che noi abbiam fatto, di aver lasciato andar gl'Israeliti, per non servirci più? ");
INSERT INTO ita1885_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","E Faraone fece mettere i cavalli al suo carro, e prese la sua gente seco. ");
INSERT INTO ita1885_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","E prese seicento carri scelti, e tutti i carri dell'Egitto, sopra tutti i quali vi erano de' capitani. ");
INSERT INTO ita1885_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","E il Signore indurò il cuor di Faraone, re di Egitto; ed egli perseguì i figliuoli di Israele, i quali se ne uscivano a mano alzata. ");
INSERT INTO ita1885_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Gli Egizj adunque li perseguirono; e tutti i cavalli, e i carri di Faraone, e i suoi cavalieri, e il suo esercito, li raggiunsero, mentre erano accampati presso al mare, in su la foce d'Hirot, dirimpetto a Baal-sefon. ");
INSERT INTO ita1885_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","E quando Faraone fu vicino, i figliuoli d'Israele alzarono gli occhi; ed ecco, gli Egizj venivano dietro a loro; onde temettero grandemente, e gridarono al Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","E dissero a Mosè: Ci hai tu menati a morire nel deserto, perchè mancassero sepolture in Egitto? che cosa è questo che tu ci hai fatto, di averci fatti uscir di Egitto? ");
INSERT INTO ita1885_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Non è egli ciò che noi ti dicevamo in Egitto, dicendo: Lasciaci stare, che serviamo agli Egizj? perciocchè meglio era per noi di servire agli Egizj, che di morir nel deserto. ");
INSERT INTO ita1885_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","E Mosè disse al popolo: Non temete; fermatevi, e state a vedere la liberazione del Signore, la quale oggi egli vi farà; perciocchè voi non vedrete mai più in eterno quegli Egizj che avete oggi veduti. ");
INSERT INTO ita1885_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Il Signore combatterà per voi, e voi ve ne starete queti. ");
INSERT INTO ita1885_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","E il Signore disse a Mosè: Perchè gridi a me? di' a' figliuoli d'Israele che camminino. ");
INSERT INTO ita1885_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","E tu, alza la tua bacchetta, e stendi la tua mano sopra il mare, e fendilo; ed entrino i figliuoli di Israele dentro al mare per l'asciutto. ");
INSERT INTO ita1885_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","E quant'è a me, ecco, io induro il cuor degli Egizj, ed essi entreranno dietro a loro; ed io sarò glorificato in Faraone, e in tutto il suo esercito, e ne' suoi carri, e nella sua cavalleria. ");
INSERT INTO ita1885_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","E gli Egizj sapranno che io sono il Signore, quando io mi sarò glorificato in Faraone, e ne' suoi carri, e nella sua cavalleria. ");
INSERT INTO ita1885_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Allora l'Angelo di Dio che andava davanti al campo degl'Israeliti, si partì, e andò dietro a loro; parimente la colonna della nuvola si partì d'innanzi a loro, e si fermò dietro a loro. ");
INSERT INTO ita1885_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","E venne fra il campo degli Egizj e il campo degl'Israeliti; e agli uni era nuvola e oscurità; e agli altri illuminava la notte; e l'un campo non si appressò all'altro in tutta quella notte. ");
INSERT INTO ita1885_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","E Mosè stese la sua mano sopra il mare; e il Signore fece con un potente vento orientale ritrarre il mare tutta quella notte; e ridusse il mare in asciutto, e l'acque furono spartite. ");
INSERT INTO ita1885_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","E i figliuoli d'Israele entrarono in mezzo al mare per l'asciutto; e l'acque erano loro a guisa di muro, a destra e a sinistra. ");
INSERT INTO ita1885_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","E gli Egizj li perseguirono; e tutti i cavalli di Faraone, e i suoi carri, e i suoi cavalieri, entrarono dietro a loro in mezzo al mare. ");
INSERT INTO ita1885_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","E avvenne, alla vigilia della mattina, che il Signore, dalla colonna del fuoco e della nuvola, riguardò verso il campo degli Egizj, e lo mise in rotta. ");
INSERT INTO ita1885_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","E, levate le ruote de' lor carri, li conduceva pesantemente. E gli Egizj dissero: Fuggiamo d'innanzi agl'Israeliti; perciocchè il Signore combatte per loro contr'agli Egizj. ");
INSERT INTO ita1885_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Allora il Signore disse a Mosè: Stendi la tua mano in sul mare, e l'acque ritorneranno sopra gli Egizj, e sopra i lor carri, e sopra i lor cavalieri. ");
INSERT INTO ita1885_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Mosè adunque stese la sua mano in sul mare; e, in sul far della mattina, il mare ritornò al suo corso violento; e gli Egizj gli fuggivano incontro; ma il Signore li traboccò in mezzo al mare. ");
INSERT INTO ita1885_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","E l'acque ritornarono, e coprirono i carri e i cavalieri di tutto l'esercito di Faraone, i quali erano entrati dentro al mare dietro agl'Israeliti; e' non iscampò di loro neppur uno. ");
INSERT INTO ita1885_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Ma i figliuoli d'Israele camminarono per l'asciutto in mezzo al mare, e l'acque erano loro a guisa di muro a destra e a sinistra. ");
INSERT INTO ita1885_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Così in quel giorno il Signore salvò gl'Israeliti dalle mani degli Egizj; e gli Israeliti videro gli Egizj morti in sul lito del mare. ");
INSERT INTO ita1885_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","E Israele vide la gran mano che il Signore avea adoperata contro agli Egizj, e temette il Signore, e credette al Signore e a Mosè suo servitore. ");
INSERT INTO ita1885_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","ALLORA Mosè, co' figliuoli d'Israele, cantò questo cantico al Signore, e dissero così: Io canterò al Signore, perciocchè egli si è sommamente magnificato; Egli ha traboccato in mare il cavallo, e colui che lo cavalcava. ");
INSERT INTO ita1885_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Il Signore è la mia forza e il mio cantico, E mi è stato in salvezza; Quest'è il mio Dio, io lo glorificherò; L'Iddio del padre mio, io l'esalterò. ");
INSERT INTO ita1885_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Il Signore è un gran guerriero; Il suo Nome è, il Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Egli ha traboccati in mare i carri di Faraone, e il suo esercito; E la scelta de' suoi capitani è stata sommersa nel mar rosso. ");
INSERT INTO ita1885_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Gli abissi li hanno coperti; Essi sono andati a fondo, come una pietra. ");
INSERT INTO ita1885_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","La tua destra, o Signore, è stata magnificata in forza; La tua destra, o Signore, ha rotto il nemico. ");
INSERT INTO ita1885_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","E con la tua magnifica grandezza, Tu hai distrutti coloro che s'innalzavano contro a te; Tu hai mandata l'ira tua, Che li ha consumati come stoppia. ");
INSERT INTO ita1885_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","E, col soffiar delle tue nari, l'acque sono state accumulate; Le correnti si son fermate come un mucchio; Gli abissi si sono assodati nel cuor del mare. ");
INSERT INTO ita1885_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Il nemico dicea: Io li perseguirò, io li raggiungerò, Io partirò le spoglie, l'anima mia si sazierà di essi; Io sguainerò la mia spada, la mia mano li sterminerà. ");
INSERT INTO ita1885_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ma tu hai soffiato col tuo vento, e il mare li ha coperti; Essi sono stati affondati come piombo in acque grosse. ");
INSERT INTO ita1885_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Chi è pari a te fra gl'iddii, o Signore? Chi è pari a te, magnifico in santità, Reverendo in laudi, facitor di miracoli? ");
INSERT INTO ita1885_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Tu hai distesa la tua destra, E la terra li ha tranghiottiti. ");
INSERT INTO ita1885_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Tu hai condotto, per la tua benignità, Il popolo che tu hai riscattato; Tu l'hai guidato per la tua forza Verso l'abitacolo della tua santità. ");
INSERT INTO ita1885_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","I popoli l'hanno inteso, ed hanno tremato; Dolore ha colti gli abitanti della Palestina. ");
INSERT INTO ita1885_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Allora sono stati smarriti i principi di Edom; Tremore ha occupati i possenti di Moab; Tutti gli abitanti di Canaan si sono strutti. ");
INSERT INTO ita1885_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Spavento e terrore caggia loro addosso; Sieno stupefatti per la grandezza del tuo braccio, come una pietra; Finchè sia passato il tuo popolo, o Signore; Finchè sia passato il popolo che tu hai acquistato. ");
INSERT INTO ita1885_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Tu l'introdurrai, e lo pianterai nel Monte della tua eredità; Nel luogo che tu hai preparato per tua stanza, o Signore; Nel Santuario, o Signore, che le tue mani hanno stabilito. ");
INSERT INTO ita1885_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Il Signore regnerà in sempiterno. ");
INSERT INTO ita1885_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Questo disse Mosè; perciocchè i cavalli di Faraone, co' suoi carri, e co' suoi cavalieri, erano entrati nel mare, e il Signore avea fatte ritornar sopra loro le acque del mare; ma i figliuoli d'Israele erano camminati per mezzo il mare per l'asciutto. ");
INSERT INTO ita1885_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","E Maria profetessa, sorella di Aaronne, prese in mano un tamburo; e tutte le donne uscirono dietro a lei, con tamburi, e con danze. ");
INSERT INTO ita1885_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","E Maria rispondeva a Mosè e agli altri uomini, dicendo: Cantate al Signore; perciocchè egli si è sommamente magnificato; Egli ha traboccato in mare il cavallo e colui che lo cavalcava. ");
INSERT INTO ita1885_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","POI Mosè fece partir gl'Israeliti dal mar rosso; ed essi procedettero innanzi verso il deserto di Sur; e camminarono tre giornate nel deserto senza trovar acqua. ");
INSERT INTO ita1885_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Poi arrivarono a Mara; e non potevano ber dell'acque di Mara; perciocchè erano amare; perciò a quel luogo fu posto nome Mara. ");
INSERT INTO ita1885_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","E il popolo mormorò contro a Mosè, dicendo; Che berremo? ");
INSERT INTO ita1885_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Ed egli gridò al Signore; e il Signore gli mostrò un legno, il quale egli gittò nell'acque, e l'acque divennero dolci. Quivi ordinò il Signore al popolo statuti e leggi; e quivi ancora lo provò. ");
INSERT INTO ita1885_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","E disse: Se del tutto tu ubbidisci alla voce del Signore Iddio tuo, e fai ciò che gli piace, e porgi gli orecchi a' suoi comandamenti, e osservi tutti i suoi statuti; io non ti metterò addosso niuna delle infermità, le quali io ho messe sopra l'Egitto; perciocchè io sono il Signore che ti guarisco d'ogni male. ");
INSERT INTO ita1885_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Poi vennero in Elim, e quivi erano dodici fontane d'acqua, e settanta palme; e si accamparono quivi presso all'acque. ");
INSERT INTO ita1885_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","POI tutta la raunanza de' figliuoli d'Israele si partì di Elim, e venne nel deserto di Sin, ch'è fra Elim e Sinai, nel quintodecimo giorno del mese secondo, da che furono usciti di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","E tutta la raunanza de' figliuoli d'Israele mormorò contro a Mosè, e contro ad Aaronne, nel deserto. ");
INSERT INTO ita1885_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","E i figliuoli d'Israele dissero loro: Oh! fossimo pur morti per la mano del Signore, nel paese di Egitto, quando sedevamo presso alle pignatte delle carni, quando mangiavamo del pane a sazietà; conciossiachè voi ci abbiate tratti in questo deserto, per far morir di fame tutta questa raunanza. ");
INSERT INTO ita1885_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","E il Signore disse a Mosè: Ecco, io vi farò piovere del pane dal cielo; e il popolo uscirà, e ne raccoglierà di dì in dì quanto gliene bisognerà per giorno; acciocchè io lo provi, s'egli camminerà nella mia Legge, o no. ");
INSERT INTO ita1885_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ma ogni sesto giorno apparecchino essi ciò che avranno a portare in tavola; e ciò sia il doppio di quello che coglieranno per ciascun giorno. ");
INSERT INTO ita1885_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","E Mosè ed Aaronne dissero a tutti i figliuoli d'Israele: Questa sera voi conoscerete che il Signore vi ha tratti fuori del paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","E domattina voi vedrete la gloria del Signore; conciossiachè egli abbia uditi i vostri mormorii contro al Signore; ma, quant'è a noi, che siamo noi, che voi mormoriate contro a noi? ");
INSERT INTO ita1885_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mosè, oltre a ciò, disse: Ciò avverrà, dandovi il Signore questa sera della carne a mangiare, e domattina del pane a sazietà; perchè il Signore ha intesi i vostri mormorii, co' quali avete mormorato contro a lui; ma, quant'è a noi, che siamo noi? i vostri mormorii non s'indirizzano contro a noi, anzi contro al Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Poi Mosè disse ad Aaronne: Di' a tutta la raunanza de' figliuoli d'Israele: Appressatevi davanti al Signore; perciocchè egli ha intesi i vostri mormorii. ");
INSERT INTO ita1885_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","E, come Aaronne parlava a tutta la raunanza de' figliuoli d'Israele, essi voltarono la faccia verso il deserto; ed ecco, la gloria del Signore apparve nella nuvola. ");
INSERT INTO ita1885_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","E il Signore parlò a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Io ho intesi i mormorii dei figliuoli d'Israele; parla loro, dicendo: Fra i due vespri voi mangerete della carne, e domattina sarete saziati di pane; e conoscerete ch'io sono il Signore Iddio vostro. ");
INSERT INTO ita1885_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","E avvenne su la sera che delle quaglie salirono, e coprirono il campo; e la mattina vi fu un suolo di rugiada intorno al campo. ");
INSERT INTO ita1885_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","E quando quel suolo di rugiada fu sparito, ecco, sopra la faccia del deserto vi era una cosa minuta, tonda, sottile come brina, in su la terra. ");
INSERT INTO ita1885_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","E quando i figliuoli d'Israele la videro, dissero l'uno all'altro: Questo è del Man; perciocchè non sapevano che cosa fosse. E Mosè disse loro: Quest'è il pane che il Signore vi dà per mangiare. ");
INSERT INTO ita1885_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Quest'è quello che il Signore ha comandato: Raccoglietene ciascuno a ragion del suo mangiare, un omer per testa, secondo il numero delle vostre persone; prendane ciascuno per quelli che son nel suo padiglione. ");
INSERT INTO ita1885_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","E i figliuoli d'Israele fecero così; e ne raccolsero, chi assai, e chi poco. ");
INSERT INTO ita1885_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","E lo misurarono con l'omer; e chi ne avea raccolto assai non n'ebbe di soverchio; e chi ne avea raccolto poco non n'ebbe di manco; ciascuno ne raccoglieva quanto gliene bisognava per lo suo mangiare. ");
INSERT INTO ita1885_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","E Mosè disse loro: Niuno ne lasci di resto fino alla mattina. ");
INSERT INTO ita1885_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ma alcuni non ubbidirono a Mosè, e ne lasciarono di resto fino alla mattina, e quello inverminò, e putì; laonde Mosè si adirò contro a loro. ");
INSERT INTO ita1885_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Così lo raccoglievano ogni mattina, ciascuno a ragion del suo mangiare; e quando il sole si riscaldava, quello si struggeva. ");
INSERT INTO ita1885_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","E nel sesto giorno raccolsero di quel pane il doppio, cioè: due omer per uno. E tutti i principali della raunanza vennero, e rapportarono la cosa a Mosè. ");
INSERT INTO ita1885_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ed egli disse loro: Quest'è quel che il Signore ha detto: Domani è il Sabato, il riposo sacro al Signore; cuocete oggi quel che avete a cuocere al forno od al fuoco; e riponetevi tutto quello che soprabbonderà, per serbarlo fino a domani. ");
INSERT INTO ita1885_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Essi adunque riposero quello fino alla mattina, come Mosè avea comandato; e non putì, e non vi fu alcun vermine. ");
INSERT INTO ita1885_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","E Mosè disse: Mangiatelo oggi; perciocchè oggi è Sabato al Signore; oggi voi non ne troverete per li campi. ");
INSERT INTO ita1885_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Raccoglietene per sei giorni; ma nel settimo giorno è Sabato; in quel dì non ne sarà. ");
INSERT INTO ita1885_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ora, nel settimo giorno avvenne che alcuni del popolo uscirono per raccoglierne, ma non ne trovarono. ");
INSERT INTO ita1885_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","E il Signore disse a Mosè: Fino a quando ricuserete di osservare i miei comandamenti, e le mie leggi? ");
INSERT INTO ita1885_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Vedete che il Signore vi ha ordinato il Sabato; perciò egli vi dà nel sesto giorno del pane per due giorni; stiasene ciascun di voi in casa, non esca alcuno del suo luogo al settimo giorno. ");
INSERT INTO ita1885_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Il popolo adunque si riposò nel settimo giorno. ");
INSERT INTO ita1885_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","E la casa d'Israele chiamò quel pane manna; ed esso era simile a seme di coriandolo, ed era bianco, e il suo sapore era come di frittelle fatte col miele. ");
INSERT INTO ita1885_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mosè, oltre a ciò, disse: Quest'è quello che il Signore ha comandato: Empi un omer di manna, acciocchè sia serbata per le vostre età, e che esse veggano il pane, del quale io vi ho cibati nel deserto, dopo avervi tratti fuor del paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Mosè adunque disse ad Aaronne: Piglia un vaso, e mettivi dentro un pieno omer di manna, e riponilo davanti al Signore, acciocchè quella sia serbata per le vostre età. ");
INSERT INTO ita1885_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Come il Signore avea comandato a Mosè, Aaronne ripose quella manna davanti alla Testimonianza, per esser serbata. ");
INSERT INTO ita1885_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","E i figliuoli d'Israele mangiarono la manna lo spazio di quarant'anni, finchè furono arrivati in paese abitato; mangiarono la manna, finchè furono arrivati a' confini del paese di Canaan. ");
INSERT INTO ita1885_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Or un omer è la decima parte di un efa. ");
INSERT INTO ita1885_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","POI tutta la raunanza de' figliuoli d'Israele si partì dal deserto di Sin, movendosi da un luogo all'altro, secondo il comandamento del Signore: e si accampò in Refidim. Or non vi era acqua per lo bere del popolo. ");
INSERT INTO ita1885_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","E il popolo contese con Mosè, e disse: Dateci dell'acqua da bere. E Mosè disse loro: Perchè contendete voi meco? e perchè tentate il Signore? ");
INSERT INTO ita1885_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Avendo adunque il popolo quivi sete di acqua, mormorò contro a Mosè, e disse: Perchè ci hai fatti salire fuor di Egitto, per far morir di sete, noi, i nostri figliuoli, e i nostri bestiami? ");
INSERT INTO ita1885_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","E Mosè gridò al Signore, dicendo: Che farò io a questo popolo? tantosto mi lapideranno. ");
INSERT INTO ita1885_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","E il Signore disse a Mosè: Passa davanti al popolo, e prendi teco degli Anziani d'Israele; piglia eziandio in mano la bacchetta con la quale tu percuotesti il fiume, e va'. ");
INSERT INTO ita1885_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ecco, io starò ivi davanti a te sopra la roccia in Horeb; e tu percuoterai la roccia, e d'essa uscirà acqua, e il popolo berrà. E Mosè fece così alla vista degli Anziani d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","E pose nome a quel luogo Massa, e Meriba, per la contesa de' figliuoli d'Israele; e perchè essi aveano tentato il Signore, dicendo: Il Signore è egli nel mezzo di noi, o no? ");
INSERT INTO ita1885_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","ALLORA gli Amalechiti vennero per combattere contro agl'Israeliti, in Refidim. ");
INSERT INTO ita1885_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","E Mosè, disse a Giosuè: Sceglici degli uomini, ed esci fuori, e combatti contro agli Amalechiti; domani io mi fermerò in su la sommità del colle, avendo la bacchetta di Dio in mano. ");
INSERT INTO ita1885_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","E Giosuè fece come Mosè gli avea comandato, combattendo contro agli Amalechiti. E Mosè, Aaronne, e Hur, salirono in su la sommità del colle. ");
INSERT INTO ita1885_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Or avvenne, che quando Mosè alzava la sua mano, gl'Israeliti vincevano; ma, quando egli la posava, gli Amalechiti vincevano. ");
INSERT INTO ita1885_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Or essendo le mani di Mosè pesanti, Aaronne, ed Hur, presero una pietra, e la misero sotto lui, ed egli vi si pose sopra a sedere; ed Aaronne, e Hur, gli sostenevano le mani, l'un di qua, e l'altro di là; e così le sue mani furono ferme fino al tramontar del sole. ");
INSERT INTO ita1885_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","E Giosuè ruppe gli Amalechiti, e la lor gente, e li mise a fil di spada. ");
INSERT INTO ita1885_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","E il Signore disse a Mosè: Scrivi questa cosa per ricordanza, nel libro; e metti nell'orecchie di Giosuè che io del tutto spegnerò la memoria di Amalec di sotto al cielo. ");
INSERT INTO ita1885_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","E Mosè edificò un altare, al quale pose nome: Il Signore è la mia bandiera. ");
INSERT INTO ita1885_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","E disse: Certo, e' v'è una mano in sul trono del Signore, che il Signore avrà per ogni età guerra con Amalec. ");
INSERT INTO ita1885_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","OR Ietro, sacerdote di Madian, suocero di Mosè, intese tutto quel che Iddio avea fatto a Mosè, e ad Israele, suo popolo; come il Signore avea tratto Israele fuor di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","E Ietro prese Sippora, moglie di Mosè, dopo ch'egli l'ebbe rimandata; ");
INSERT INTO ita1885_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","e i due figliuoli di essa; il nome dell'uno de' quali era Ghersom; perciocchè Mosè, avea detto: Io sono stato forestiere in paese strano. ");
INSERT INTO ita1885_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","E il nome dell'altro era Eliezer; perciocchè egli avea detto: L'Iddio di mio padre mi è stato in aiuto, e mi ha scampato dalla spada di Faraone. ");
INSERT INTO ita1885_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Ietro adunque, suocero di Mosè, venne a Mosè, co' figliuoli di esso, e con la sua moglie, nel deserto, ove egli era accampato al Monte di Dio. ");
INSERT INTO ita1885_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","E mandò a dire a Mosè: Io Ietro, tuo suocero, vengo a te, con la tua moglie, e co' suoi due figliuoli. ");
INSERT INTO ita1885_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","E Mosè uscì incontro al suo suocero; e gli s'inchinò, e lo baciò; e si domandarono l'un l'altro del lor bene stare; poi entrarono nel padiglione. ");
INSERT INTO ita1885_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","E Mosè raccontò al suo suocero tutto ciò che il Signore avea fatto a Faraone, ed agli Egizj, per amor d'Israele; e tutti i travagli ch'erano loro sopraggiunti per cammino, de' quali il Signore li avea liberati. ");
INSERT INTO ita1885_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","E Ietro si rallegrò di tutto il bene che il Signore avea fatto a Israele, avendolo riscosso dalla man degli Egizj. ");
INSERT INTO ita1885_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","E Ietro disse: Benedetto sia il Signore, il qual vi ha liberati dalla mano degli Egizj, e dalla mano di Faraone; il quale ha riscosso questo popolo di sotto alla man degli Egizj. ");
INSERT INTO ita1885_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ora conosco che il Signore è più grande di tutti gl'iddii; conciossiachè questo sia loro avvenuto, perciocchè erano superbamente proceduti contro a loro. ");
INSERT INTO ita1885_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Poi Ietro, suocero di Mosè, prese un olocausto, e de' sacrificii da offerire a Dio; e Aaronne, e tutti gli Anziani d'Israele, vennero a mangiar col suocero di Mosè, davanti al Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","E il giorno seguente, avvenne che, sedendo Mosè, per render ragion al popolo, e stando il popolo in piè davanti a Mosè, dalla mattina fino alla sera; ");
INSERT INTO ita1885_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","il suocero di Mosè vide tutto quel che egli faceva al popolo, e disse: Che cosa è questo che tu fai inverso questo popolo? perchè siedi tu solo, e tutto il popolo ti sta in piè davanti, dalla mattina fino alla sera? ");
INSERT INTO ita1885_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","E Mosè rispose al suo suocero: Io il fo, perchè questo popolo viene a me per domandare Iddio. ");
INSERT INTO ita1885_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Quando essi hanno qualche affare, vengono a me, ed io giudico fra l'uno e l'altro, e dichiaro loro gli statuti di Dio, e le sue leggi. ");
INSERT INTO ita1885_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Ma il suocero di Mosè, gli disse: Ciò che tu fai non istà bene. ");
INSERT INTO ita1885_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Per certo tu verrai meno, e tu, e questo popolo ch'è teco; perciocchè cotesto affare è troppo grave per te; tu non puoi far ciò tutto solo. ");
INSERT INTO ita1885_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Attendi ora alla mia voce, io ti consiglierò, e Iddio sarà teco: Sii tu per lo popolo davanti a Dio, e rapporta a Dio gli affari. ");
INSERT INTO ita1885_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","E ammaestra il popolo intorno agli statuti, e alle leggi; e dichiaragli la via per la quale ha da camminare, e l'opere che ha da fare. ");
INSERT INTO ita1885_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","E tu scegli d'infra tutto il popolo degli uomini di valore, che temano Iddio; uomini leali che abbiano in odio l'avarizia; e costituiscili sopra il popolo capi di migliaia, capi di centinaia, capi di cinquantine, e capi di diecine. ");
INSERT INTO ita1885_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","E rendano essi ragione al popolo in ogni tempo; e rapportino a te ogni grande affare; ma giudichino ogni piccolo affare. Così ti sgraverai del carico che hai addosso, ed essi lo porteranno teco. Se tu fai questa cosa, ");
INSERT INTO ita1885_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","e se Iddio te la comanda, tu potrai durare; e anche tutto questo popolo perverrà in pace al suo luogo. ");
INSERT INTO ita1885_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","E Mosè acconsentì al dire del suo suocero, e fece tutto ciò ch'egli avea detto. ");
INSERT INTO ita1885_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","E Mosè scelse di tutto Israele degli uomini di valore, e li costituì capi sopra il popolo; capi di migliaia, capi di centinaia, capi di cinquantine, e capi di diecine. ");
INSERT INTO ita1885_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","E quelli doveano render ragione al popolo in ogni tempo; essi rapportavano a Mosè gli affari difficili, e giudicavano ogni piccolo affare. ");
INSERT INTO ita1885_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Poi Mosè accommiatò il suo suocero, ed egli se ne andò nel suo paese. ");
INSERT INTO ita1885_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","NEL primo giorno del terzo mese, da che i figliuoli d'Israele furono usciti del paese di Egitto, in quell'istesso giorno arrivarono nel deserto di Sinai. ");
INSERT INTO ita1885_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Essendo adunque partiti di Refidim, arrivarono nel deserto di Sinai, e si accamparono nel deserto. Ed essendo Israele accampato quivi dirimpetto al monte, ");
INSERT INTO ita1885_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mosè salì a Dio; e il Signore gli gridò dal monte, dicendo: Di' così alla casa di Giacobbe, e dichiara questo a' figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Voi avete veduto ciò che ho fatto agli Egizj, e come vi ho portati come sopra ale di aquile, e vi ho menati a me. ");
INSERT INTO ita1885_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ora dunque, se voi del tutto ubbidite alla mia voce, e osservate il mio patto, voi mi sarete un tesoro riposto d'infra tutti i popoli; conciossiachè tutta la terra sia mia. ");
INSERT INTO ita1885_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","E mi sarete un Reame sacerdotale, e una gente santa. Queste son le parole che tu dirai a' figliuoli di Israele. ");
INSERT INTO ita1885_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Mosè adunque venne, e chiamò gli Anziani del popolo, e propose loro tutte queste parole, che il Signore gli avea comandate. ");
INSERT INTO ita1885_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","E tutto il popolo rispose ad una, e disse: Noi faremo tutto quello che il Signore ha detto. E Mosè rapportò al Signore le parole del popolo. ");
INSERT INTO ita1885_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","E il Signore disse a Mosè: Ecco, io verrò a te in una folta nuvola, acciocchè il popolo oda quando io parlerò teco, ed anche ti creda in perpetuo. Ora, dopo che Mosè ebbe rapportate le parole del popolo al Signore, il Signore gli disse: ");
INSERT INTO ita1885_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Vattene al popolo, e santificalo oggi e domani, e fa' che lavino i lor vestimenti. ");
INSERT INTO ita1885_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","E che sieno presti per lo terzo giorno; perciocchè al terzo giorno il Signore scenderà in sul monte di Sinai, nel cospetto di tutto il popolo. ");
INSERT INTO ita1885_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","E tu poni de' termini al popolo attorno attorno, dicendo: Guardatevi di salire al monte, o di toccar pur l'estremità di esso: chiunque toccherà il monte del tutto sarà fatto morire. ");
INSERT INTO ita1885_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Niuna mano tocchi un tale; anzi del tutto sia lapidato o saettato; o bestia, od uomo che egli si sia, non viva; quando il corno sonerà alla distesa, allora salgano essi verso il monte. ");
INSERT INTO ita1885_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","E Mosè scese dal monte al popolo, e santificò il popolo, ed essi lavarono i lor vestimenti. ");
INSERT INTO ita1885_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ed egli disse al popolo: Siate presti per lo terzo giorno; non vi accostate a donna. ");
INSERT INTO ita1885_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","E al terzo giorno, come fu mattina, si fecero tuoni e folgori; e vi era una folta nuvola in sul monte, insieme con un suon di tromba molto forte; e tutto il popolo ch'era nel campo tremava. ");
INSERT INTO ita1885_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","E Mosè fece uscire il popolo fuor del campo, incontro a Dio; e si fermarono appiè del monte. ");
INSERT INTO ita1885_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Or il monte di Sinai fumava tutto; perciocchè il Signore era sceso sopra esso in fuoco; e il fumo ne saliva a guisa di fumo di fornace; e tutto il monte tremava forte. ");
INSERT INTO ita1885_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","E il suon della tromba si andava vie più rinforzando grandemente; e Mosè parlava, e Iddio gli rispondeva per un tuono. ");
INSERT INTO ita1885_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Il Signore adunque scese in sul monte di Sinai, sulla sommità del monte, e chiamò Mosè alla sommità del monte. E Mosè vi salì. ");
INSERT INTO ita1885_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","E il Signore disse a Mosè: Scendi, protesta al popolo, che talora egli non rompa i termini, e non si appressi al Signore per riguardare; onde molti di essi caggiano morti. ");
INSERT INTO ita1885_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","I sacerdoti eziandio, che si appressano al Signore, si santifichino; che talora il Signore non si avventi sopra loro. ");
INSERT INTO ita1885_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","E Mosè disse al Signore: Il popolo non può salire al monte Sinai; conciossiachè tu ci abbi protestato, dicendo: Poni de' termini a questo monte, e santificalo. ");
INSERT INTO ita1885_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","E il Signore disse a Mosè: Va', scendi; poi monta tu, ed Aaronne teco; ma i sacerdoti, e il popolo non rompano i termini, per salire al Signore, che talora egli non si avventi sopra loro. ");
INSERT INTO ita1885_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","E Mosè discese al popolo, e gliel disse. ");
INSERT INTO ita1885_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","ALLORA Iddio pronunziò tutte queste parole, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Io sono il Signore Iddio tuo, che ti ho tratto fuor del paese di Egitto, della casa di servitù. ");
INSERT INTO ita1885_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Non avere altri dii nel mio cospetto. ");
INSERT INTO ita1885_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Non farti scultura alcuna, nè immagine alcunadi cosa che sia in cielo di sopra, nè di cosa che sia in terra di sotto, nè di cosa che sia nell'acque di sotto alla terra. ");
INSERT INTO ita1885_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Non adorar quelle cose, e non servir loro; perciocchè io, il Signore Iddio tuo, son Dio geloso, che visito l'iniquità de' padri sopra i figliuoli fino alla terza e alla quarta generazione di coloro che m'odiano. ");
INSERT INTO ita1885_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Ed uso benignità in mille generazioni verso coloro che mi amano, e osservano i miei comandamenti. ");
INSERT INTO ita1885_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Non usare il Nome del Signore Iddio tuo in vano; perciocchè il Signore non terrà innocente chi avrà usato il suo Nome in vano. ");
INSERT INTO ita1885_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Ricordati del giorno del riposo, per santificarlo. ");
INSERT INTO ita1885_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Lavora sei giorni, e fa' in essi ogni opera tua. ");
INSERT INTO ita1885_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Ma il settimo giorno è il riposo al Signore Iddio tuo; non fare in esso lavoro alcuno, nè tu, nè il tuo figliuolo, nè la tua figliuola, nè il tuo servo, nè la tua serva, nè il tuo bestiame, nè il tuo forestiere ch'è dentro alle tue porte. ");
INSERT INTO ita1885_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Perciocchè in sei giorni il Signore fece il cielo e la terra, e il mare, e tutto ciò ch'è in essi, e si riposò al settimo giorno; perciò, il Signore ha benedetto il giorno del riposo e l'ha santificato. ");
INSERT INTO ita1885_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Onora tuo padre e tua madre; acciocchè i tuoi giorni sieno prolungati sopra la terra, la quale il Signore Iddio tuo ti dà. ");
INSERT INTO ita1885_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Non uccidere. ");
INSERT INTO ita1885_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Non commettere adulterio. ");
INSERT INTO ita1885_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Non furare. ");
INSERT INTO ita1885_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Non dir falsa testimonianza contro al tuo prossimo. ");
INSERT INTO ita1885_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Non concupire la casa del tuo prossimo; non concupir la moglie del tuo prossimo; nè il suo servo, nè la sua serva, nè il suo bue, nè il suo asino, nè cosa alcuna che sia del tuo prossimo. ");
INSERT INTO ita1885_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Or tutto il popolo vedeva i tuoni, e i lampi, e il suon della tromba, e il monte fumante; e veggendo queste cose, tremava, e se ne stava lungi; ");
INSERT INTO ita1885_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","e disse a Mosè: Parla tu con noi, e noi ascolteremo; e non parli Iddio con noi, chè talora noi non muoiamo. ");
INSERT INTO ita1885_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","E Mosè disse al popolo: Non temiate; perciocchè Iddio è venuto per provarvi, e affinchè il suo timore sia davanti agli occhi vostri, acciocchè non pecchiate. ");
INSERT INTO ita1885_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Il popolo adunque si fermò da lungi; e Mosè si accostò alla caligine; nella quale Iddio era. ");
INSERT INTO ita1885_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","E il Signore disse a Mosè: Di' così a' figliuoli d'Israele: Voi avete veduto che io ho parlato a voi dal cielo. ");
INSERT INTO ita1885_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Non fate alcun dio meco; non vi fate dii di argento, nè dii d'oro. ");
INSERT INTO ita1885_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Fammi un altar di terra, e sacrifica sopra esso i tuoi olocausti, e i tuoi sacrificii da render grazie, le tue pecore, e i tuoi buoi; in qualunque luogo io farò ricordare il mio Nome, io verrò a te, e ti benedirò. ");
INSERT INTO ita1885_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","E se pur tu mi fai un altar di pietre, non fabbricarlo di pietre conce a scarpello; quando tu vi avrai fatto passar lo scarpello sopra, tu l'avrai contaminate. ");
INSERT INTO ita1885_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","E non salir per gradi al mio altare; acciocchè non si scuopra la tua nudità sopra esso. ");
INSERT INTO ita1885_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","OR queste sono le leggi giudiciali, le quali tu proporrai loro: ");
INSERT INTO ita1885_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Quando tu avrai comperato un servo Ebreo, servati egli sei anni; ma al settimo anno vadasene franco, senza pagar nulla. ");
INSERT INTO ita1885_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Se egli è venuto sol col suo corpo, vadasene col suo corpo; se egli avea moglie, vadasene la sua moglie con lui. ");
INSERT INTO ita1885_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Se il suo signore gli ha data moglie, la quale gli abbia partoriti figliuoli o figliuole; quella moglie, e i figliuoli di essa, sieno del signore; e vadasene egli col suo corpo. ");
INSERT INTO ita1885_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ma se pure il servo dice: Io amo il mio signore, la mia moglie, e i miei figliuoli; io non me ne voglio andar franco; ");
INSERT INTO ita1885_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","faccialo il suo signore comparire davanti a' giudici; poi faccialo appressare all'uscio, o allo stipite della porta, e forigli l'orecchio con una lesina; e servagli colui in perpetuo. ");
INSERT INTO ita1885_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","E quando alcuno avrà venduta la sua figliuola per serva, non esca ella di casa, come i servi ne escono. ");
INSERT INTO ita1885_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Se ella dispiace al suo signore, a cui il padre l'avrà sposata, facciala quello franca; non abbia podestà di venderla a un popolo straniero, dopo averle rotta la fede. ");
INSERT INTO ita1885_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","E se egli la fa sposare al suo figliuolo, facciale secondo la ragion delle fanciulle. ");
INSERT INTO ita1885_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Se egli gliene prende un'altra, non tolgale il nutrimento, nè il vestire, nè la coabitazione. ");
INSERT INTO ita1885_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","E se egli non le fa queste tre cose, vadasene ella gratuitamente, senza pagar danari alcuni. ");
INSERT INTO ita1885_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Chi avrà percosso un uomo, sì che egli ne muoia, del tutto sia fatto morire. ");
INSERT INTO ita1885_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ma, quant'è a colui che non l'avrà appostato, anzi Iddio glielo avrà fatto scontrar nelle mani, io ti costituirò un luogo, al quale colui rifugga. ");
INSERT INTO ita1885_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ma, quando alcuno per temerità avrà macchinato contro al suo prossimo, per ucciderlo con inganno, trallo fuori, eziandio d'appresso al mio altare, perchè muoia. ");
INSERT INTO ita1885_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Chi avrà battuto suo padre, o sua madre, del tutto sia fatto morire. ");
INSERT INTO ita1885_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Parimente, chi avrà rubata una persona, o sia che l'abbia venduta, o che gli sia trovata in mano, del tutto sia fatto morire. ");
INSERT INTO ita1885_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Ed anche, chi avrà maledetto suo padre, o sua madre, del tutto sia fatto morire. ");
INSERT INTO ita1885_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","E quando alcuni contenderanno insieme, e l'uno avrà percosso l'altro con pietra, o col pugno, onde egli non muoia, ma giaccia in letto; ");
INSERT INTO ita1885_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","se egli si rileva, e cammina fuori in sul suo bastone, colui che l'avrà percosso sia assolto; sol gli paghi ciò ch'egli è stato a bada, e lo faccia medicare fino a compiuta guarigione. ");
INSERT INTO ita1885_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","E quando alcuno avrà percosso il suo servo, o la sua serva, con un bastone, sì che gli muoia sotto la mano, facciasene del tutto punizione. ");
INSERT INTO ita1885_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Ma se pur campa un giorno, o due, non facciasene punizione; perciocchè è suo danaro. ");
INSERT INTO ita1885_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","E quando alcuni, contendendo insieme, avranno percossa una donna gravida, sì che il parto n'esca fuori, ma pur non vi sarà caso di morte; sia colui che l'avrà percossa condannato ad ammenda, secondo che il marito della donna gl'imporrà; e paghila per autorità de' giudici. ");
INSERT INTO ita1885_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Ma, se vi è caso di morte, metti vita per vita; ");
INSERT INTO ita1885_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","occhio per occhio, dente per dente, mano per mano, piè per piè; ");
INSERT INTO ita1885_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","arsura per arsura, ferita per ferita, lividore per lividore. ");
INSERT INTO ita1885_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","E quando alcuno avrà percosso l'occhio del suo servo, o l'occhio della sua serva, e l'avrà guasto; lascilo andar franco per lo suo occhio. ");
INSERT INTO ita1885_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Parimente, se ha fatto cadere un dente al suo servo o alla sua serva, lascilo andar franco per lo suo dente. ");
INSERT INTO ita1885_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","E quando un bue avrà cozzato un uomo o una donna, sì che ne muoia, del tutto sia quel bue lapidato, e non mangisene la carne; e il padrone del bue sia assolto. ");
INSERT INTO ita1885_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ma se il bue per addietro è stato uso di cozzare, e ciò è stato protestato al padron di esso, ed egli non l'ha guardato, e il bue ha ucciso un uomo o una donna, sia il bue lapidato, e anche facciasi morire il padron di esso. ");
INSERT INTO ita1885_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Se gli è imposto alcun prezzo di riscatto, paghi il riscatto della sua vita, interamente come gli sarà imposto. ");
INSERT INTO ita1885_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Se il bue cozza un figliuolo o una figliuola, facciaglisi secondo questa legge. ");
INSERT INTO ita1885_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Se il bue cozza un servo o una serva, paghi il padron del bue trenta sicli di argento al padrone di esso, e sia lapidato il bue. ");
INSERT INTO ita1885_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","E, se alcuno scuopre una fossa; ovvero, avendo cavata una fossa, non la ricuopre, e vi cade dentro bue od asino; ");
INSERT INTO ita1885_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ristorine il danno il padron della fossa, pagandone i danari al padron del bue o dell'asino; e il morto sia suo. ");
INSERT INTO ita1885_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","E se il bue d'alcuno urta il bue del prossimo di esso, dì che muoia, vendano essi il bue vivo, e partiscanne i danari per metà; partiscano eziandio il morto. ");
INSERT INTO ita1885_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ma, se è notorio che quel bue per addietro fosse uso di cozzare, e il padrone di esso non l'ha guardato, restituisca egli del tutto bue per bue; ma il morto sia suo. ");
INSERT INTO ita1885_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","QUANDO alcuno avrà rubato un bue, o una pecora, o una capra, e l'avrà ammazzata o venduta; paghi cinque buoi per quel bue, e quattro pecore, o capre, per quella pecora, o capra. ");
INSERT INTO ita1885_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Se il ladro, colto di notte nello sconficcare è percosso, e muore, non vi è omicidio. ");
INSERT INTO ita1885_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Se il sole è levato quando sarà colto, vi è omicidio. Il ladro soddisfaccia del tutto; e se non ha da soddisfare, sia venduto per lo suo furto. ");
INSERT INTO ita1885_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Se pure il furto gli è trovato in mano, vivo; o bue, o asino, o pecora che sia, restituiscalo al doppio. ");
INSERT INTO ita1885_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Se alcuno fa pascolare un campo, o una vigna; e se manda nel campo altrui il suo bestiame, il quale vi pasturi dentro, soddisfaccia il danno col meglio del suo campo, e col meglio della sua vigna. ");
INSERT INTO ita1885_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Quando un fuoco uscirà fuori, e incontrerà delle spine, onde sia consumato grano in bica, o biade, o campo, del tutto soddisfaccia il danno colui che avrà acceso il fuoco. ");
INSERT INTO ita1885_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Quando alcuno avrà dato al suo prossimo danari, o vasellamenti, a guardare, e quelli saranno rubati dalla casa di colui, se il ladro è trovato, restituiscali al doppio. ");
INSERT INTO ita1885_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Se il ladro non si trova, facciasi comparire il padron della casa davanti a' rettori, per giurare s'egli non ha punto messa la mano sopra la roba del suo prossimo. ");
INSERT INTO ita1885_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","In ogni causa di misfatto intorno a bue, asino, pecora, capra, vestimento, o a qualunque altra cosa perduta, della quale uno dica: Questa è dessa; venga la causa d'amendue le parti davanti a' rettori; e colui che i rettori avranno condannato, paghi il doppio al suo prossimo. ");
INSERT INTO ita1885_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Quando alcuno avrà dato al suo prossimo, asino, o bue, o pecora, o qualunque altra bestia, a guardare, ed ella muore, o le si fiacca alcun membro, o è rapita, senza che alcuno l'abbia veduto, ");
INSERT INTO ita1885_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","il giuramento del Signore intervenga fra le due parti, per saper se colui non ha punto messa la mano sopra il bene del suo prossimo; e accetti il padron della bestia quel giuramento, e non sia l'altro obbligato a pagamento. ");
INSERT INTO ita1885_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ma se pur quella bestia gli è stata rubata d'appresso, facciane soddisfazione al padron di essa. ");
INSERT INTO ita1885_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Se pur quella bestia è stata lacerata dalle fiere, portila per testimonianza, e non sia obbligato a pagar la bestia. ");
INSERT INTO ita1885_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","E quando alcuno avrà presa in prestanza una bestia dal suo prossimo, e le si fiaccherà alcun membro, o morrà, e il padrone di essa non sarà presente, del tutto colui paghila. ");
INSERT INTO ita1885_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Ma se il padrone è stato presente, non sia colui obbligato a pagarla; se la bestia è stata tolta a vettura, ell'è venuta per lo prezzo della sua vettura. ");
INSERT INTO ita1885_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","E quando alcuno avrà sedotta una vergine, la qual non sia sposata, e sarà giaciuto con lei, del tutto dotila, e prendalasi per moglie. ");
INSERT INTO ita1885_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Se pure il padre di essa del tutto ricusa di dargliela, paghi danari, secondo la dote delle vergini. ");
INSERT INTO ita1885_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Non lasciar vivere la donna maliosa. ");
INSERT INTO ita1885_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Chiunque si congiungerà con una bestia, del tutto sia fatto morire. ");
INSERT INTO ita1885_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Chi sacrificherà ad altri dii, fuor che al Signore solo, sia sterminato come anatema. ");
INSERT INTO ita1885_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Non far violenza al forestiere, e non opprimerlo; conciossiachè voi siate stati forestieri nel paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Non affliggete alcuna vedova nè orfano. ");
INSERT INTO ita1885_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Guardati d'affliggerlo in alcuna maniera, perciocchè, se egli grida a me, io del tutto esaudirò il suo grido. ");
INSERT INTO ita1885_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","E l'ira mia si accenderà, ed io vi ucciderò con la spada: e le vostre mogli saranno vedove, e i vostri figliuoli orfani. ");
INSERT INTO ita1885_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Quando tu presterai danari al mio popolo, al povero ch'è appresso a te, non procedere inverso lui a guisa di usuraio: non imponetegli usura. ");
INSERT INTO ita1885_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Se pur tu togli in pegno il vestimento del tuo prossimo, rendiglielo infra il tramontar del sole. ");
INSERT INTO ita1885_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Perciocchè quello solo è la sua copritura, ed è il suo vestire per coprir la sua pelle; in che giacerebbe egli? se dunque egli avviene che egli gridi a me, io l'esaudirò; perciocchè io son pietoso. ");
INSERT INTO ita1885_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Non dir male de' rettori; e non maledir colui ch'è principe nel tuo popolo. ");
INSERT INTO ita1885_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Non indugiare il pagar le primizie della tua vendemmia, nè del gocciolar de' tuoi olii; dammi il primogenito dei tuoi figliuoli. ");
INSERT INTO ita1885_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Fa' il simigliante del tuo bue, e della tua pecora, e capra; stia il primo portato di esse sette giorni appresso la madre sua, e all'ottavo giorno dammelo. ");
INSERT INTO ita1885_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","E siatemi uomini santi; e non mangiate carne lacerata dalle fiere per li campi; gittatela a' cani. ");
INSERT INTO ita1885_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","NON levare un falso grido; non metter mano con l'empio per esser testimonio falso. ");
INSERT INTO ita1885_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Non andar dietro a' grandi per far male; e non dar sentenza in una lite, inchinando a favorire i grandi, per far torto. ");
INSERT INTO ita1885_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Non avere altresì rispetto al povero nella sua lite. ");
INSERT INTO ita1885_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Se tu incontri il bue del tuo nemico, o l'asino suo smarrito, del tutto riconduciglielo. ");
INSERT INTO ita1885_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Se tu vedi l'asino di colui che ti odia giacer sotto il suo carico, mentre tu ti rimani di aiutarlo a farglielo andare oltre, del tutto fa' con lui sì che possa andare oltre. ");
INSERT INTO ita1885_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Non far torto al tuo bisognoso nella sua lite. ");
INSERT INTO ita1885_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Allontanati dal parlar falso; e non far morir l'innocente nè il giusto; perciocchè io non assolverò l'empio. ");
INSERT INTO ita1885_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","E non prender presenti; perciocchè il presente accieca coloro che hanno chiara vista, e sovverte le parole de' giusti. ");
INSERT INTO ita1885_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","E non oppressare il forestiere; perciocchè voi sapete in quale stato è l'anima del forestiere, essendo stati forestieri nel paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Semina la tua terra sei anni, e ricogli il frutto di essa. ");
INSERT INTO ita1885_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Ma ogni settimo anno lasciala vacare, e in abbandono, e mangino i bisognosi del tuo popolo il frutto di essa; e ciò che rimarrà loro, manginlo le bestie della campagna; fa' il simigliante alla tua vigna ed a' tuoi ulivi. ");
INSERT INTO ita1885_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Sei giorni fa' le tue faccende; ma al settimo giorno riposati; acciocchè il tuo bue, e il tuo asino, abbiano requie; e il figliuolo della tua serva, e il forestiere possano respirare. ");
INSERT INTO ita1885_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","E prendete guardia a tutto quello che io vi ho detto; e non ricordate il nome degl'iddii stranieri; non odasi quello nella tua bocca. ");
INSERT INTO ita1885_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Celebrami tre feste solenni per anno. ");
INSERT INTO ita1885_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Osserva la festa degli azzimi; mangia pani azzimi per sette giorni, come io ti ho comandato, nel tempo ordinato del mese di Abib; conciossiachè in quel mese tu sii uscito fuori di Egitto; e non comparisca alcuno davanti alla mia faccia vuoto. ");
INSERT INTO ita1885_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Parimente osserva la festa della mietitura, delle primizie de' tuoi frutti, di ciò che tu avrai seminato nel tuo campo; e la festa della ricolta, all'uscita dell'anno, quando tu avrai ricolti i tuoi frutti d'in sui campi. ");
INSERT INTO ita1885_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Tre volte l'anno comparisca ogni maschio tuo davanti alla faccia del Signore, ch'è l'Eterno. ");
INSERT INTO ita1885_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Non sacrificare il sangue del mio sacrificio con pan lievitato; e non sia guardato il grasso dell'agnello della mia solennità la notte fino alla mattina. ");
INSERT INTO ita1885_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Porta nella Casa del Signore Iddio tuo le primizie de' primi frutti della tua terra. Non cuocere il capretto nel latte di sua madre. ");
INSERT INTO ita1885_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","ECCO, io mando un Angelo davanti a te, per guardarti per lo cammino, e per condurti al luogo che io ho preparato. ");
INSERT INTO ita1885_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Guardati, per la sua presenza, e ubbidisci alla sua voce, e non irritarlo; perciocchè egli non vi perdonerà i vostri misfatti; conciossiachè il mio Nome sia in lui. ");
INSERT INTO ita1885_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ma se pure tu ubbidisci alla sua voce, e fai tutto quello che io ti dirò, io sarò nemico de' tuoi nemici, e avversario dei tuoi avversari. ");
INSERT INTO ita1885_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Perciocchè l'Angelo mio andrà davanti a te, e t'introdurrà nel paese degli Amorrei, degl'Hittei, dei Ferezei, de' Cananei, degl'Hivvei, a dei Gebusei; ed io distruggerò que' popoli. ");
INSERT INTO ita1885_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Non adorar gl'iddii loro, e non servir loro; e non far secondo l'opere di quei popoli; anzi distruggi quelli affatto, e del tutto spezza le loro statue. ");
INSERT INTO ita1885_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","E servite al Signore Iddio vostro, ed egli benedirà il tuo pane, e la tua acqua; ed io torrò via ogni infermità dal mezzo di te. ");
INSERT INTO ita1885_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","E' non vi sarà nel tuo paese femmina che sperda, nè sterile; io compierò il numero de' tuoi giorni. ");
INSERT INTO ita1885_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Io manderò davanti a te il mio spavento, e metterò in rotta ogni popolo, nel cui paese tu entrerai, e farò che tutti i tuoi nemici volteran le spalle dinanzi a te. ");
INSERT INTO ita1885_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Manderò eziandio davanti a te de' calabroni, i quali scacceranno gl'Hivvei, i Cananei, e gl'Hittei dal tuo cospetto. ");
INSERT INTO ita1885_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Io non li scaccerò dal tuo cospetto in un anno; che talora il paese non divenga deserto, e che le fiere della campagna non moltiplichino contro a te. ");
INSERT INTO ita1885_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Io li scaccerò dal tuo cospetto a poco a poco, finchè tu sii cresciuto, e abbi presa la possessione del paese. ");
INSERT INTO ita1885_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","E io porrò i tuoi confini dal mar rosso fino al mar de' Filistei; e dal deserto fino al Fiume; perciocchè io darò nelle vostre mani gli abitanti del paese, e tu li scaccerai dinanzi a te. ");
INSERT INTO ita1885_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Non far lega alcuna con loro, nè co' loro iddii. ");
INSERT INTO ita1885_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Non abitino essi nel tuo paese, chè talora non ti facciano peccare contro a me; conciossiachè tu serviresti agl'iddii loro; perciocchè quello ti sarebbe in laccio. ");
INSERT INTO ita1885_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","POI disse a Mosè: Sali al Signore, tu, ed Aaronne, e Nadab, e Abihu, e settanta degli Anziani d'Israele, e adorate da lungi. ");
INSERT INTO ita1885_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Poi accostisi Mosè solo al Signore, e quegli altri non vi si accostino; e non salga il popolo con lui. ");
INSERT INTO ita1885_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","E Mosè venne, e raccontò al popolo tutte le parole del Signore, e tutte quelle leggi. E tutto il popolo rispose ad una voce, e disse: Noi faremo tutte le cose che il Signore ha dette. ");
INSERT INTO ita1885_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Poi Mosè scrisse tutte le parole del Signore; e, levatosi la mattina, edificò sotto a quel monte un altare, e rizzò dodici pilieri, per le dodici tribù d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","E mandò i ministri de' figliuoli d'Israele a offerire olocausti, e sacrificare al Signore giovenchi, per sacrificii da render grazie. ");
INSERT INTO ita1885_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","E Mosè prese la metà del sangue, e lo mise in bacini; e ne sparse l'altra metà sopra l'altare. ");
INSERT INTO ita1885_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Poi prese il Libro del Patto, e lo lesse in presenza del popolo. E esso disse: Noi faremo tutto quello che il Signore ha detto, e ubbidiremo. ");
INSERT INTO ita1885_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Allora Mosè prese quel sangue, e lo sparse sopra il popolo, e disse: Ecco il sangue del patto che il Signore ha fatto con voi, sopra tutte quelle parole. ");
INSERT INTO ita1885_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Poi Mosè, ed Aaronne, e Nadab, e Abihu, e settanta degli Anziani d'Israele, salirono. ");
INSERT INTO ita1885_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","E videro l'Iddio d'Israele; e sotto i piedi di esso vi era come un lavorio di lastre di zaffiro, risomigliante il cielo stesso in chiarezza. ");
INSERT INTO ita1885_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ed egli non avventò la sua mano sopra gli Eletti d'infra i figliuoli d'Israele; anzi videro Iddio, e mangiarono e bevvero. ");
INSERT INTO ita1885_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","E il Signore disse a Mosè: Sali a me in sul monte, e fermati quivi; ed io ti darò delle tavole di pietra, cioè: la Legge, e i comandamenti che io ho scritti, per insegnarli a' figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Mosè adunque, con Giosuè, suo ministro, si levò; e Mosè salì al monte di Dio. ");
INSERT INTO ita1885_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","E disse agli Anziani d'Israele: Rimanete qui, aspettandoci, finchè noi ritorniamo a voi; ecco, Aaronne ed Hur sono con voi; chiunque avrà qualche affare, vada a loro. ");
INSERT INTO ita1885_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Mosè adunque salì al monte, e la nuvola coperse il monte. ");
INSERT INTO ita1885_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","E la gloria del Signore si posò in sul monte di Sinai, e la nuvola lo coperse per lo spazio di sei giorni; e al settimo giorno il Signore chiamò Mosè del mezzo della nuvola. ");
INSERT INTO ita1885_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","E l'aspetto della gloria del Signore era simile a un fuoco consumante, in su la sommità del monte, alla vista de' figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","E Mosè entrò nel mezzo della nuvola, e salì al monte, e dimorò in sul monte quaranta giorni e quaranta notti. ");
INSERT INTO ita1885_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","E IL Signore parlò a Mosè, dicendo: Di' a' figliuoli d'Israele, che prendano da farmi un'offerta; ");
INSERT INTO ita1885_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","prendete quella mia offerta da ogni uomo il cui cuore lo moverà volontariamente. ");
INSERT INTO ita1885_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","E quest'è l'offerta che voi prenderete da loro: oro, e argento, e rame; ");
INSERT INTO ita1885_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","e violato, e porpora, e scarlatto, e fin lino, e pel di capra; ");
INSERT INTO ita1885_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","e pelli di montoni tinte in rosso, e pelli di tassi, e legno di Sittim; ");
INSERT INTO ita1885_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","olio per la lumiera, aromati per l'olio dell'Unzione, e per lo profumo degli aromati; ");
INSERT INTO ita1885_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","pietre onichine, e pietre da incastonare, per l'Efod, e per lo Pettorale. ");
INSERT INTO ita1885_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","E faccianmi essi un Santuario, ed io abiterò nel mezzo di loro. ");
INSERT INTO ita1885_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Fatelo interamente secondo il modello del Tabernacolo, e il modello di tutti i suoi arredi, che io ti mostro. ");
INSERT INTO ita1885_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Facciano adunque un'Arca di legno di Sittim, la cui lunghezza sia di due cubiti e mezzo, e la larghezza di un cubito e mezzo, e l'altezza di un cubito e mezzo. ");
INSERT INTO ita1885_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","E coprila d'oro puro di dentro e di fuori; e fa' sopra essa una corona d'oro attorno. ");
INSERT INTO ita1885_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","E fondile quattro anelli d'oro, e metti quegli anelli a' quattro cantoni di essa, due da uno de' lati dell'Arca, e due dall'altro. ");
INSERT INTO ita1885_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Fai ancora delle stanghe di legno di Sittim, e coprile d'oro. ");
INSERT INTO ita1885_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","E metti quelle stanghe dentro agli anelli da' lati dell'Arca, per portarla con esse. ");
INSERT INTO ita1885_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Dimorino le stanghe negli anelli dell'Arca e non ne sieno rimosse. ");
INSERT INTO ita1885_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Poi metti nell'Arca la Testimonianza che io ti darò. ");
INSERT INTO ita1885_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Fa' eziandio all'Arca un Coperchio d'oro puro, la cui lunghezza sia di due cubiti e mezzo, e la larghezza di un cubito e mezzo. ");
INSERT INTO ita1885_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","E fa' due Cherubini d'oro; falli di lavoro tirato al martello, a' due capi del Coperchio. ");
INSERT INTO ita1885_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Fai adunque un Cherubino da un de' capi di qua, e un altro dall'altro di là; fate questi Cherubini tirati dal Coperchio stesso, sopra i due capi d'esso. ");
INSERT INTO ita1885_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","E spandano i Cherubini l'ale in su, facendo con le loro ale una coverta al disopra del Coperchio, e abbiano le lor facce volte l'un verso l'altro; sieno le facce de' Cherubini volte verso il Coperchio. ");
INSERT INTO ita1885_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","E metti il Coperchio in su l'Arca disopra, e nell'Arca metti la Testimonianza che io ti darò. ");
INSERT INTO ita1885_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ed io mi troverò quivi presente teco, e parlerò teco d'in sul Coperchio, di mezzo i due Cherubini che saranno sopra l'Arca della Testimonianza; e ti dirò tutte le cose che ti comanderò di proporre a' figliuoli di Israele. ");
INSERT INTO ita1885_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Fa' ancora una Tavola di legno di Sittim, la cui lunghezza sia di due cubiti, e la larghezza di un cubito e l'altezza di un cubito e mezzo. ");
INSERT INTO ita1885_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","E coprila d'oro puro, e falle una corona d'oro attorno. ");
INSERT INTO ita1885_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Falle eziandio attorno una chiusura di un palmo, d'oro puro, e a quella sua chiusura fa' una corona d'oro attorno attorno. ");
INSERT INTO ita1885_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Falle, oltre a ciò, quattro anelli d'oro, e metti quegli anelli a' quattro canti, che saranno ai quattro piedi di essa. ");
INSERT INTO ita1885_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Sieno gli anelli dirincontro alla chiusura, per farvi passar dentro le stanghe, per portar la Tavola. ");
INSERT INTO ita1885_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","E fa' le stanghe di legno di Sittim, e coprile d'oro, e con esse portisi la Tavola. ");
INSERT INTO ita1885_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Fa' eziandio i suoi piattelli, le sue scodelle, i suoi nappi, e i suoi bacini, co' quali si faranno gli spargimenti; fa'quelle cose d'oro puro. ");
INSERT INTO ita1885_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","E metti sopra la Tavola il pane del cospetto, il quale sia del continuo nel mio cospetto. ");
INSERT INTO ita1885_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Fa' ancora un Candelliere d'oro puro; facciasi di lavoro tirato al martello, così il suo gambo, come i suoi rami; sieno i vasi d'esso, i suoi pomi, e le sue bocce, di un pezzo col Candelliere. ");
INSERT INTO ita1885_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","E sienvi sei rami procedenti da' lati di esso; tre de' rami del Candelliere dall'uno de' lati di esso, e tre dall'altro. ");
INSERT INTO ita1885_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","In uno di essi rami sieno tre vasi in forma di mandorla; e un pomo, e una boccia a ciascun vaso; e parimente nell'altro ramo, tre vasi in forma di mandorla; e un pomo e una boccia a ciascun vaso; e così conseguentemente ne' sei rami del Candelliere. ");
INSERT INTO ita1885_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","E nel gambo del Candelliere sieno quattro vasi in forma di mandorla, co' suoi pomi, e con le sue bocce. ");
INSERT INTO ita1885_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","E ne' sei rami procedenti dal Candelliere, siavi un pomo sotto i due primi rami di un pezzo col Candelliere; e un pomo sotto i due altri rami, d'un pezzo altresì col Candelliere; e un pomo sotto i due ultimi rami, di un pezzo altresì col Candelliere. ");
INSERT INTO ita1885_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Sieno i pomi, e i rami loro di un pezzo col Candelliere; sia tutto il Candelliere di un pezzo, d'oro puro, tirato al martello. ");
INSERT INTO ita1885_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Fa' ancora le sette lampane di esso, e accendansi, e porgano lume verso la parte anteriore del Candelliere. ");
INSERT INTO ita1885_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","E sieno gli smoccolatoi, e i catinelli di esso d'oro puro. ");
INSERT INTO ita1885_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Impiega intorno ad esso, e intorno a tutti questi strumenti, un talento d'oro. ");
INSERT INTO ita1885_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","E vedi di far tutte queste cose, secondo il modello che ti è mostrato in sul monte. ");
INSERT INTO ita1885_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","FA' ancora il Padiglione, di dieci teli di fin lino ritorto, di violato, di porpora, e di scarlatto; e fa' que' teli lavorati a cherubini di lavoro di disegno. ");
INSERT INTO ita1885_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Sia la lunghezza d'un telo di ventotto cubiti, e la larghezza di quattro cubiti; sieno tutti que' teli di una stessa misura. ");
INSERT INTO ita1885_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Sieno cinque teli accoppiati l'uno con l'altro, e cinque altri teli parimente accoppiati l'uno con l'altro. ");
INSERT INTO ita1885_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","E fa' de' lacciuoli di violato all'orlo dell'uno de' teli, che sarà all'estremità dell'uno degli accoppiamenti; fa' il simigliante ancora nell'orlo del telo estremo nel secondo accoppiamento. ");
INSERT INTO ita1885_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Fa' cinquanta lacciuoli nell'uno di que' teli, e parimente cinquanta lacciuoli all'estremità del telo che sarà al secondo accoppiamento; sieno i lacciuoli dirincontro l'uno all'altro. ");
INSERT INTO ita1885_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Fa' ancora cinquanta graffi d'oro, e accoppia que' teli, l'uno con l'altro con que' graffi; e così sia il Padiglione giunto in uno. ");
INSERT INTO ita1885_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Fa', oltre a ciò, sopra il Padiglione una Tenda a teli di pel di capra; fai undici di que' teli. ");
INSERT INTO ita1885_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Sia la lunghezza di un telo di trenta cubiti, e la larghezza di quattro cubiti; sieno gli undici teli di una stessa misura. ");
INSERT INTO ita1885_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","E accoppia cinque di que' teli da parte, e sei da parte; e raddoppia il sesto telo in su la parte anteriore del Tabernacolo. ");
INSERT INTO ita1885_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","E fa' cinquanta lacciuoli all'orlo dell'un de' teli, che sarà l'estremo del primo accoppiamento; e parimente cinquanta lacciuoli all'orlo del telo estremo del secondo accoppiamento. ");
INSERT INTO ita1885_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Fa' ancora cinquanta graffi di rame, e metti i graffi dentro i lacciuoli; e assembra insieme la Tenda, acciocchè sia giunta in uno. ");
INSERT INTO ita1885_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","E quel soverchio che avanzerà ne' teli della Tenda, cioè: quel mezzo telo che sarà di soverchio, soprabbondi nella parte di dietro del Tabernacolo. ");
INSERT INTO ita1885_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","E il cubito di qua, e il cubito di là, che sarà di soverchio nella lunghezza de' teli della Tenda, soprabbondi ne' lati del Tabernacolo, di qua e di là, per coprirlo. ");
INSERT INTO ita1885_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Fa' ancora alla Tenda una coverta di pelli di montone, tinte in rosso; e un'altra coverta di pelli di tasso, disopra. ");
INSERT INTO ita1885_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Fa', oltre a ciò, delle assi per lo Tabernacolo; falle di legno di Sittim, per metterle ritte. ");
INSERT INTO ita1885_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Sia la lunghezza di ciascuna asse di dieci cubiti, e la larghezza di un cubito e mezzo. ");
INSERT INTO ita1885_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Abbia ciascuna asse due cardini da incastrare un pezzo nell'altro; fa' così a tutte le assi del Tabernacolo. ");
INSERT INTO ita1885_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Fa' adunque le assi per lo Tabernacolo; venti assi dal lato Australe, verso il Mezzodì. ");
INSERT INTO ita1885_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","E fa' quaranta piedistalli di argento per metter sotto quelle venti assi; due piedistalli sotto ciascuna asse, per li suoi due cardini. ");
INSERT INTO ita1885_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","E venti assi per l'altro lato del Tabernacolo, verso Aquilone; ");
INSERT INTO ita1885_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","co' lor quaranta piedistalli di argento, due piedistalli sotto ciascuna asse. ");
INSERT INTO ita1885_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","E per lo fondo del Tabernacolo, verso Occidente, fa' sei assi. ");
INSERT INTO ita1885_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Fa' ancora due assi per li cantoni del Tabernacolo, nel fondo. ");
INSERT INTO ita1885_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","E sieno quelle a due facce fin da basso; e tutte sieno ben commesse insieme al capo di queste assi con un anello; sieno quelle due assi, che saranno per li due cantoni, fatte di una medesima maniera. ");
INSERT INTO ita1885_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Sienvi adunque otto assi, co' lor piedistalli di argento, in numero di sedici piedistalli; due piedistalli sotto ciascuna asse. ");
INSERT INTO ita1885_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Fai ancora cinque sbarre di legno di Sittim, per le assi dell'uno de' lati del Tabernacolo. ");
INSERT INTO ita1885_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Parimente cinque sbarre per le assi dell'altro lato del Tabernacolo; e cinque sbarre per le assi del lato del fondo del Tabernacolo, verso Occidente. ");
INSERT INTO ita1885_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","E la sbarra di mezzo sia nel mezzo delle assi, e traversi da un capo all'altro. ");
INSERT INTO ita1885_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","E copri d'oro le assi, e fa' d'oro i loro anelli, da mettervi dentro le sbarre; copri ancora d'oro le sbarre. ");
INSERT INTO ita1885_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Poi rizza il Tabernacolo secondo il modello di esso, che ti è stato mostrato nel monte. ");
INSERT INTO ita1885_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Fa' ancora una Cortina di violato, e di porpora, e di scarlatto, e di fin lino ritorto; facciasi di lavoro di disegno a Cherubini. ");
INSERT INTO ita1885_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","E appendila a quattro colonne di legno di Sittim, coperte d'oro, co' lor capitelli d'oro; e quelle sieno poste sopra quattro piedistalli di argento. ");
INSERT INTO ita1885_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","E metti la Cortina sotto i graffi; e porta là, dentro della Cortina, l'Arca della Testimonianza; e facciavi quella Cortina separazione fra il luogo Santo e il Santissimo. ");
INSERT INTO ita1885_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","E metti il Coperchio sopra l'Arca della Testimonianza, nel luogo Santissimo. ");
INSERT INTO ita1885_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","E metti la Tavola di fuori della Cortina, dal lato Settentrionale; e il Candelliere, dirimpetto alla Tavola, dal lato Australe del Tabernacolo. ");
INSERT INTO ita1885_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Fa' eziandio, per l'entrata del Tabernacolo, un tappeto di violato, e di porpora, e di scarlatto, e di fin lino ritorto, di lavoro di ricamatore. ");
INSERT INTO ita1885_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","E fai cinque colonne di legno di Sittim, per appendervi quel tappeto, e copri le colonne d'oro, e sieno i lor capitelli d'oro; e fondi loro cinque piedistalli di rame. ");
INSERT INTO ita1885_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","FA', oltre a ciò, un Altare di legno di Sittim, la cui lunghezza sia di cinque cubiti, e la larghezza di cinque cubiti; talchè sia quadrato; e l'altezza di tre cubiti. ");
INSERT INTO ita1885_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","E fagli delle corna a' quattro canti, le quali sieno dell'Altare stesso; e coprilo di rame. ");
INSERT INTO ita1885_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Fagli eziandio de' calderoni per raccoglier le sue ceneri, e delle palette, e de' bacini, e delle forcelle, e delle cazze; fa' tutti gli stumenti d'esso di rame. ");
INSERT INTO ita1885_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Fagli ancora una grata di rame, di lavor reticolato; e fa' disopra di quella grata quattro anelli di rame, sopra le quattro estremità di essa. ");
INSERT INTO ita1885_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","E mettila disotto al procinto dell'Altare a basso; e sia quella rete fino a mezzo l'Altare. ");
INSERT INTO ita1885_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Fa' ancora delle stanghe per l'Altare, di legno di Sittim, e coprile di rame. ");
INSERT INTO ita1885_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","E mettansi quelle stanghe di esso agli anelli; e sieno le stanghe a' due lati dell'Altare, quando si avrà da portare. ");
INSERT INTO ita1885_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Fallo di tavole, vuoto; facciasi come ti è stato mostrato in sul monte. ");
INSERT INTO ita1885_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Fa' ancora il Cortile del Tabernacolo; dal lato Australe verso il Mezzodì abbia il Cortile cento cubiti di lunghezza di cortine di fin lino ritorto; abbiane tanto da un lato; ");
INSERT INTO ita1885_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","con le sue venti colonne, e i lor venti piedistalli di rame; e sieno i capitelli, e i fili delle colonne di argento. ");
INSERT INTO ita1885_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Così ancora dal lato Settentrionale per lungo, abbia la lunghezza di cento cubiti di cortine; con lor venti colonne, e i lor venti piedistalli di rame; e sieno i capitelli, e i fili delle colonne di argento. ");
INSERT INTO ita1885_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","E per largo, dal lato Occidentale, abbia il Cortile cinquanta cubiti di cortine colle lor dieci colonne, e dieci piedistalli. ");
INSERT INTO ita1885_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","E per largo dal lato Orientale, verso il Levante, abbia il Cortile parimente cinquanta cubiti di cortine; ");
INSERT INTO ita1885_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","cioè all'un de' canti quindici cubiti di cortine, colle lor tre colonne, e tre piedistalli; ");
INSERT INTO ita1885_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","e dall'altro canto, parimente quindici cubiti di cortine, colle lor tre colonne, e tre piedistalli. ");
INSERT INTO ita1885_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","E all'entrata del Cortile siavi un tappeto di venti cubiti, di violato, e di porpora, e di scarlatto, e di fin lino ritorto, di lavoro di ricamatore, colle lor quattro colonne, e quattro piedistalli. ");
INSERT INTO ita1885_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Abbiano tutte le colonne del Cortile d'intorno de' fili di argento; e sieno i lor capitelli di argento, e i lor piedistalli di rame. ");
INSERT INTO ita1885_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Sia la lunghezza del Cortile di cento cubiti, e la larghezza, da un lato e dall'altro, di cinquanta cubiti, e l'altezza di cinque cubiti; sieno le cortine di fin lino ritorto, e i piedistalli delle colonne di rame. ");
INSERT INTO ita1885_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Sieno di rame tutti gli arredi del Tabernacolo, per qualunque suo servigio, come ancora tutti i suoi piuoli, e tutti i piuoli del Cortile. ");
INSERT INTO ita1885_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Comanda ancora a' figliuoli d'Israele che ti portino dell'olio di uliva puro, vergine, per la lumiera, per accendere del continuo le lampane. ");
INSERT INTO ita1885_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Mettanle in ordine Aaronne ed i suoi figliuoli, per ardere dalla sera fino alla mattina, davanti al Signore, nel Tabernacolo della convenenza, di fuori della cortina che ha da essere davanti alla Testimonianza. Sia questo uno statuto perpetuo, da osservarsi da' figliuoli d'Israele per le loro età. ");
INSERT INTO ita1885_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","E TU, fa' accostare a te, d'infra i figliuoli d'Israele, Aaronne tuo fratello, e i suoi figliuoli con lui, per esercitarmi il sacerdozio; Aaronne, dico, e Nadab, e Abihu, ed Eleazaro, e Itamar, figliuoli di Aaronne. ");
INSERT INTO ita1885_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","E fa' ad Aaronne, tuo fratello, de' vestimenti sacri, a gloria ed ornamento. ");
INSERT INTO ita1885_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","E parla a tutti gli uomini industriosi, i quali io ho ripieni di spirito d'industria, che facciano i vestimenti di Aaronne, per consacrarlo, acciocchè mi eserciti il sacerdozio. ");
INSERT INTO ita1885_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","E questi sono i vestimenti che hanno da fare; il Pettorale, e l'Efod, e il Manto, e la Tonica trapunta; la Benda, e la Cintura. Facciano adunque i vestimenti sacri ad Aaronne, tuo fratello, e a' suoi figliuoli, per esercitarmi il sacerdozio. ");
INSERT INTO ita1885_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","E prendano di quell'oro, di quel violato, porpora, scarlatto, e fin lino; ");
INSERT INTO ita1885_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","e facciano l'Efod, d'oro, di violato, di porpora, di scarlatto, e di fin lino ritorto, di lavoro di disegno. ");
INSERT INTO ita1885_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Sienvi due omerali che si accoppino insieme da' due capi di esso; e così sia l'Efod accoppiato. ");
INSERT INTO ita1885_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","E sia il disegno del fregio che sarà sopra l'Efod, col quale egli si cingerà, del medesimo lavoro, tirato dall'Efod istesso, d'oro, di violato, di porpora, di scarlatto, e di fin lino ritorto. ");
INSERT INTO ita1885_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Piglia ancora due pietre onichine, e scolpisci sopra esse i nomi de' figliuoli d'Israele; ");
INSERT INTO ita1885_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","sei de' nomi loro sopra una pietra, e gli altri sei nomi sopra l'altra pietra, secondo le lor nascite. ");
INSERT INTO ita1885_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Scolpisci sopra quelle due pietre i nomi de' figliuoli d'Israele, a lavoro di scultor di pietre, come s'intagliano i suggelli; falle intorniate di castoni d'oro. ");
INSERT INTO ita1885_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","E metti quelle due pietre sopra gli omerali dell'Efod, acciochè sieno pietre di ricordanza per i figliuoli d'Israele; porti Aaronne i nomi loro davanti al Signore, sopra le sue due spalle, per memoria. ");
INSERT INTO ita1885_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","E fai de' castoni d'oro. ");
INSERT INTO ita1885_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","E due catenelle di oro puro; falle a capi, di lavoro intorcicchiato; e attacca quelle catenelle intorcicchiate a' castoni. ");
INSERT INTO ita1885_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Fa', oltre a ciò, il Pettorale del giudicio, di lavoro di disegno; fallo del lavoro dell'Efod, d'oro, e di violato, e di porpora, e di scarlatto, e di fin lino ritorto. ");
INSERT INTO ita1885_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Sia quadrato, e doppio; e abbia in lunghezza una spanna, e una spanna in larghezza. ");
INSERT INTO ita1885_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","E incastra in esso delle pietre preziose in castoni, in quattro ordini; nel primo siavi un sardonio, un topazio, e uno smeraldo. ");
INSERT INTO ita1885_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","E nel secondo, un carbonchio, uno zaffiro, e un diamante. ");
INSERT INTO ita1885_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","E nel terzo, un ligurio, un'agata, e un'amatista. ");
INSERT INTO ita1885_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","E nel quarto un grisolito, una pietra onichina, e un diaspro. Sieno quelle pietre incastrate nei lor castoni d'oro. ");
INSERT INTO ita1885_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","E sieno quelle pietre in numero di dodici, secondo i nomi de' figliuoli d'Israele; abbia ciascuna il suo nome intagliato a lavoro d'intagli di suggello; e sieno per le dodici tribù. ");
INSERT INTO ita1885_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Fa' eziandio al Pettorale delle catenelle a capi, di lavoro intorcicchiato, d'oro puro. ");
INSERT INTO ita1885_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Fa' ancora al Pettorale due anelli d'oro, e metti que' due anelli a due de' capi del Pettorale. ");
INSERT INTO ita1885_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","E metti quelle due catenelle d'oro intorcicchiate a que' due anelli, a' capi del Pettorale. ");
INSERT INTO ita1885_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","E attacca i due capi di quelle due catenelle intorcicchiate a que' due castoni, e metti il Pettorale, e le sue catenelle, sopra i due omerali dell'Efod, in su la parte anteriore di esso. ");
INSERT INTO ita1885_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Fa' ancora due anelli d'oro, e mettili agli altri due capi del Pettorale, all'orlo di esso che sarà allato all'Efod, in dentro. ");
INSERT INTO ita1885_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Fa' parimente due anelli d'oro, e mettili a' due omerali dell'Efod, al disotto, nella parte anteriore di esso, allato alla giuntura di esso, disopra al fregio lavorato dell'Efod. ");
INSERT INTO ita1885_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","E giungasi il Pettorale serrato da' suoi anelli agli anelli dell'Efod, con una bendella di violato, acciocchè stia disopra al fregio lavorato dell'Efod, e non sia il Pettorale rimosso d'in su l'Efod. ");
INSERT INTO ita1885_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","E porti Aaronne i nomi de' figliuoli d'Israele nel Pettorale del giudicio, in sul suo cuore, quando egli entrerà nel Santuario, per ricordanza, nel cospetto del Signore, del continuo. ");
INSERT INTO ita1885_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","E metti Urim e Tummim nel Pettorale del giudicio; sieno in sul cuore di Aaronne, quando egli entrerà nel cospetto del Signore; e porti Aaronne il Giudicio de' figliuoli d'Israele sopra il suo cuore, del continuo. ");
INSERT INTO ita1885_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Fa' ancora il Manto dell'Efod, tutto di violato. ");
INSERT INTO ita1885_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","E siavi nel mezzo di esso una scollatura da passarvi dentro il capo; abbia quella sua scollatura un orlo d'intorno, di lavoro tessuto; a guisa di scollatura di corazza, acciocchè non si schianti. ");
INSERT INTO ita1885_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","E fa' alle fimbrie di esso Manto, attorno attorno, delle melagrane di violato, di porpora, e di scarlatto; e de' sonagli d'oro per mezzo quelle d'ogni intorno. ");
INSERT INTO ita1885_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Un sonaglio di oro, poi una melagrana; un sonaglio di oro, poi una melagrana, alle fimbrie del Manto d'ogn'intorno. ");
INSERT INTO ita1885_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Ed abbia Aaronne quel Manto addosso quando farà il servigio divino; e odasi il suono di esso quando egli entrerà nel luogo Santo, nel cospetto del Signore, e quando ne uscirà, acciocchè non muoia. ");
INSERT INTO ita1885_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Fa' ancora una lama d'oro puro, e scolpisci sopra essa, a lavoro d'intagli di suggello: LA SANTITÀ DEL SIGNORE. ");
INSERT INTO ita1885_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","E metti quella piastra in sur una bendella di violato, sicchè sia sopra la Benda, in su la parte anteriore di essa. ");
INSERT INTO ita1885_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","E sia in su la fronte di Aaronne: acciocchè Aaronne porti l'iniquità delle sante offerte, le quali i figliuoli d'Israele avranno consacrate in tutte le offerte ch'essi consacrano; e sia in su la fronte di esso del continuo, per renderli grati nel cospetto del Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Fa' ancora la Tonica di fin lino, trapunta; fa' parimente la Benda di fin lino; e fa' la Cintura di lavoro di ricamatore. ");
INSERT INTO ita1885_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Fa' ancora a' figliuoli di Aaronne, delle toniche, e delle cinture, e delle mitrie, a gloria ed ornamento. ");
INSERT INTO ita1885_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","E vesti di questi vestimenti Aaronne, tuo fratello, e i suoi figliuoli; e ungili, e consacrali, e santificali, acciocchè mi esercitino il sacerdozio. ");
INSERT INTO ita1885_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Fa' loro ancora delle mutande line, per coprir la carne delle vergogne; giungano quelle mutande dai lombi fino al disotto delle cosce. ");
INSERT INTO ita1885_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","E abbianle Aaronne ed i suoi figliuoli addosso, quando entreranno nel Tabernacolo della convenenza; ovvero, quando si accosteranno all'Altare, per fare il servigio nel luogo Santo; acciocchè non portino pena d'iniquità, e non muoiano. Questo è uno statuto perpetuo per lui, e per la sua progenie dopo lui. ");
INSERT INTO ita1885_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","E QUESTO è quello che tu farai loro per consacrarli, acciocchè mi esercitino il sacerdozio. Prendi un giovenco, e due montoni, senza difetto; ");
INSERT INTO ita1885_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","e de' pani azzimi, e delle focacce azzime, intrise con olio; e delle schiacciate azzime, unte con olio; fai quelle cose di fior di farina di frumento. ");
INSERT INTO ita1885_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","E mettile in un paniere, e presentale in esso paniere, col giovenco, e co' due montoni. ");
INSERT INTO ita1885_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","E fa' accostare Aaronne e i suoi figliuoli, all'entrata del Tabernacolo della convenenza; e lavali con acqua. ");
INSERT INTO ita1885_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Poi prendi que' vestimenti, e fa' vestire ad Aaronne la Tonica, e il Manto dell'Efod, e l'Efod, e il Pettorale; e cingilo al fregio lavorato dell'Efod. ");
INSERT INTO ita1885_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Poi mettigli in sul capo la Benda, e sopra la Benda metti il sacro Diadema. ");
INSERT INTO ita1885_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","E piglia dell'olio dell'Unzione, e spandiglielo in sul capo, e ungilo. ");
INSERT INTO ita1885_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Poi fa' accostare i suoi figliuoli, e fa' lor vestire le toniche. ");
INSERT INTO ita1885_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","E cingi Aaronne e i suoi figliuoli con le cinture; e allaccia loro le mitrie; e sia loro il sacerdozio per istatuto perpetuo. Così consacra Aaronne e i suoi figliuoli. ");
INSERT INTO ita1885_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Poi fa' accostar quel giovenco davanti al Tabernacolo della convenenza, e posino Aaronne e i suoi figliuoli le mani sopra il capo del giovenco. ");
INSERT INTO ita1885_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Poi scanna il giovenco davanti al Signore, all'entrata del Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","E piglia del sangue del giovenco, e col dito mettine sopra le corna dell'Altare, poi spandi tutto il sangue appiè dell'Altare. ");
INSERT INTO ita1885_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Prendi ancora tutto i grasso che copre l'interiora, e la rete ch'è sopra il fegato, e i due arnioni, col grasso ch'è sopra essi; e, bruciando quelle cose, fanne profumo sopra l'Altare. ");
INSERT INTO ita1885_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Ma brucia col fuoco, fuor del campo, la carne, la pelle, e lo sterco del giovenco; egli è sacrificio per lo peccato. ");
INSERT INTO ita1885_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Poi piglia uno de' montoni; e posino Aaronne e i suoi figliuoli le mani sopra il capo del montone. ");
INSERT INTO ita1885_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Poi scanna il montone, e prendine il sangue, e spargilo sopra l'Altare, attorno attorno. ");
INSERT INTO ita1885_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Poi taglia il montone a pezzi, e lava le sue interiora, e i suoi piedi, e mettili sopra i pezzi, e sopra il capo di esso. ");
INSERT INTO ita1885_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","E, bruciando il montone tutto intiero, fanne profumo sopra l'Altare; egli è un olocausto al Signore, egli è un odor soave, un'offerta fatta col fuoco al Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Poi prendi l'altro montone; e posino Aaronne e i suoi figliuoli le mani sopra il capo del montone. ");
INSERT INTO ita1885_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Poi scanna il montone, e piglia del suo sangue, e mettilo in sul tenerume dell'orecchia destra di Aaronne e de' suoi figliuoli, e in sul dito grosso della lor man destra, e in sul dito grosso del loro piè destro; poi spargi il sangue sopra l'Altare, attorno attorno. ");
INSERT INTO ita1885_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Prendi, oltre a ciò, del sangue che sarà sopra l'Altare, e dell'olio dell'Unzione, e spruzzane Aaronne e i suoi vestimenti; e parimente i suoi figliuoli e i lor vestmenti. Così sarà consacrato egli e i suoi vestimenti; e parimente i suoi figliuoli e i lor vestimenti, con lui. ");
INSERT INTO ita1885_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Poi piglia del montone il grasso, e la coda, e il grasso che copre l'interiora, e la rete del fegato, e i due arnioni, e il grasso ch' è sopra essi, e la spalla destra; perciocchè egli è il montone delle consacrazioni. ");
INSERT INTO ita1885_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Prendi ancora dal paniere degli azzimi, che sarà davanti al Signore, una fetta di pane, e una focaccia intrisa nell' olio, e una schiacciata. ");
INSERT INTO ita1885_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","E metti tutte coteste cose sopra le palme delle mani di Aaronne, e sopra le palme delle mani de' suoi figliuoli, e falle dimenare come offerta dimenata davanti al Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Poi prendi quelle cose dalle lor mani; e, bruciandole sopra l'Altare, fanne profumo sopra l'olocausto, per odor soave davanti al Signore. Quest'è un'offerta fatta col fuoco al Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Prendi ancora il petto del montone delle consacrazioni, che è per Aaronne, e fallo dimenare davanti al Signore per offerta dimenata. E quello sia per tua parte. ");
INSERT INTO ita1885_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Così santifica il petto di offerta dimenata, e la spalla di offerta elevata, che sarà stata dimenata ed elevata, del montone delle consacrazioni e di ciò che è stato offerto per Aaronne, e per li suoi figliuoli. ");
INSERT INTO ita1885_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","E quello, per istatuto perpetuo, appartenga ad Aaronne e a' suoi figliuoli, e prendasi da' figliuoli d'Israele; conciossiachè sia un'offerta elevata; or le offerte elevate si prenderanno dai figliuoli d'Israele de' lor sacrificii da render grazie; le loro offerte elevate apparterranno al Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","E i vestimenti sacri, che sono per Aaronne, saranno per li suoi figliuoli dopo lui, per essere unti, e consacrati, in essi. ");
INSERT INTO ita1885_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Vestali per sette giorni il Sacerdote che sarà in luogo di esso, d'infra i suoi figliuoli; il quale entrerà nel Tabernacolo della convenenza, per fare il servigio nel luogo Santo. ");
INSERT INTO ita1885_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Poi prendi il montone delle consacrazioni, e cuoci la sua carne in luogo santo. ");
INSERT INTO ita1885_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","E mangino Aaronne e i suoi figliuoli, all'entrata del Tabernacolo della convenenza, la carne del montone, e il pane che sarà in quel paniere. ");
INSERT INTO ita1885_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Mangino, dico, quelle cose, con le quali sarà stato fatto il purgamento del peccato, per consacrarli e per santificarli; e non mangine alcuno straniere; conciossiachè sieno cosa santa. ");
INSERT INTO ita1885_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","E se pur vi rimarrà della carne delle consacrazioni, e di quel pane, fino alla mattina, brucia col fuoco quello che ne sarà rimasto, e non si mangi; perciocchè è cosa santa. ");
INSERT INTO ita1885_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Fa' adunque ad Aaronne e a' suoi figliuoli, interamente com'io ti ho comandato; consacrali per lo spazio di sette giorni. ");
INSERT INTO ita1885_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","E sacrifica un giovenco per lo peccato, per giorno, per li purgamenti del peccato; e fa' sacrificio per lo peccato per l'Altare, quando tu farai il purgamento per esso; e ungilo, per consacrarlo. ");
INSERT INTO ita1885_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Fa' il purgamento per l'altare, per sette giorni; e così consacralo, e sia l'Altare una cosa santissima; tutto quello che toccherà l'Altare sia sacro. ");
INSERT INTO ita1885_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","OR questo è quello che tu sacrificherai sopra l'Altare, cioè: due agnelli di un anno, per giorno, del continuo. ");
INSERT INTO ita1885_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Sacrificane uno la mattina, e l'altro fra i due vespri. ");
INSERT INTO ita1885_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Con la decima parte di un'efa di fior di farina, stemperata con la quarta parte di un hin d'olio vergine, e un'offerta da spandere, di una quarta parte di un hin di vino, per l'uno degli agnelli. ");
INSERT INTO ita1885_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","E sacrifica l'altro agnello fra i due vespri, facendo con esso la medesima offerta e spargimento, come con quel della mattina; per soave odore, per offerta fatta per fuoco al Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Sia questo un olocausto continuo, per le vostre generazioni, e facciasi all'entrata del Tabernacolo della convenenza, davanti al Signore, dove io mi ritroverò con voi, per parlar quivi a te. ");
INSERT INTO ita1885_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Io adunque mi ritroverò quivi co' figliuoli d'Israele, e Israele sarà santificato per la mia gloria. ");
INSERT INTO ita1885_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Io santificherò ancora il Tabernacolo della convenenza, e l'Altare; santificherò parimente Aaronne e i suoi figliuoli, acciocchè mi esercitino il sacerdozio. ");
INSERT INTO ita1885_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","E abiterò nel mezzo de' figliuoli d'Israele, e sarò loro Dio. ");
INSERT INTO ita1885_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","E dessi conosceranno ch'io sono il Signore Iddio loro, che li ho tratti fuor del paese di Egitto, per abitar nel mezzo di loro. Io sono il Signore Iddio loro. ");
INSERT INTO ita1885_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","FA' ancora un Altare da fare i profumi; fallo di legno di Sittim. ");
INSERT INTO ita1885_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Sia quadro, di lunghezza d'un cubito, e di larghezza d'un cubito; e sia la sua altezza di due cubiti; sieno le sue corna tirate di esso. ");
INSERT INTO ita1885_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","E coprilo d'oro puro, il suo coperchio, i suoi lati d'intorno, e le sue corna; e fagli una corona d'oro attorno attorno. ");
INSERT INTO ita1885_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Fagli ancora due anelli d'oro disotto a quella sua corona, a' due suoi cantoni; falli da due dei suoi lati; e sieno per mettervi dentro le stanghe, per portar l'Altare con esse. ");
INSERT INTO ita1885_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","E fa' le stanghe di legno di Sittim, e coprile d'oro. ");
INSERT INTO ita1885_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","E metti quell'Altare davanti alla Cortina, che sarà dirimpetto all'Arca della Testimonianza, davanti al Coperchio che sarà sopra la Testimonianza, dove io mi ritroverò teco. ");
INSERT INTO ita1885_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","E faccia Aaronne profumo di aromati sopra esso; faccia quel profumo ogni mattina, quando egli avrà acconce le lampane. ");
INSERT INTO ita1885_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","E faccia Aaronne quel medesimo profumo, quando avrà accese le lampane fra i due vespri. Sia questo un profumo continuo davanti al Signore, per le vostre età. ");
INSERT INTO ita1885_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Non offerite sopra esso alcun profumo strano, nè olocausto, nè offerta; e non ispandete alcuno spargimento sopra esso. ");
INSERT INTO ita1885_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","E faccia Aaronne, una volta l'anno, purgamento de' peccati sopra le corna di esso; faccia quel purgamento una volta l'anno, per le vostre età, sopra esso, col sangue del sacrificio de' purgamenti, fatto per lo peccato. Questo Altare sia una cosa santissima al Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","IL Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Quando tu farai la rassegna de' figliuoli d'Israele, di coloro d'infra essi che devono essere annoverati, dia ciascuno al Signore il riscatto dell'anima sua, quando saranno annoverati; acciocchè non venga sopra essi alcuna piaga, mentre saranno annoverati. ");
INSERT INTO ita1885_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Essi daranno questo: chiunque passa fra gli annoverati, darà un mezzo siclo, a siclo di Santuario, il quale è di venti oboli, per offerta al Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Chiunque passa fra gli annoverati, di età da vent'anni in su, darà quell' offerta al Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Il ricco non darà più, nè il povero meno di un mezzo siclo, in questa offerta al Signore, per lo riscatto delle anime vostre. ");
INSERT INTO ita1885_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","E piglia que' danari de' riscatti dai figliuoli d'Israele, e impiegali nell'opera del Tabernacolo della convenenza, e sieno per ricordanza per li figliuoli d'Israele, nel cospetto del Signore, per fare il riscatto delle anime vostre. ");
INSERT INTO ita1885_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","IL Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Fa', oltre a ciò, una Conca di rame, col suo piè di rame, per lavare; e ponila fra il Tabernacolo della convenenza e l'Altare; e mettivi dentro dell'acqua. ");
INSERT INTO ita1885_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","E lavinsene Aaronne e i suoi figliuoli le mani ed i piedi. ");
INSERT INTO ita1885_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Quando entreranno nel Tabernacolo della convenenza, ovvero quando si accosteranno all'Altare, per fare il servigio divino per far bruciare alcuna offerta fatta col fuoco al Signore, lavinsi con acqua, acciocchè non muoiano. ");
INSERT INTO ita1885_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","E lavinsi le mani ed i piedi, acciocchè non muoiano. Sia loro questo uno statuto perpetuo; ad Aaronne, dico, e a' suoi figliuoli, per le loro età. ");
INSERT INTO ita1885_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Il Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Prenditi degli aromati eccellenti, della mirra schietta il peso di cinquecento sicli, del cinamomo odoroso la metà, cioè dugencinquanta, e della canna odorosa parimente dugencinquanta; ");
INSERT INTO ita1885_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","e della cassia cinquecento sicli, a siclo di Santurario; e un hin d'olio di uliva. ");
INSERT INTO ita1885_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","E fanne l'olio per la sacra Unzione, un unguento composto per arte d'unguentaro. Questo sia l'olio della sacra Unzione. ");
INSERT INTO ita1885_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Ungi con esso il Tabernacolo della convenenza, e l'Arca della Testimonianza; ");
INSERT INTO ita1885_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","e la Tavola, e tutti i suoi strumenti; ed il Candelliere, e tutti i suoi strumenti; e l'Altar de' profumi; ");
INSERT INTO ita1885_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","e l'Altar degli olocausti, e tutti i suoi strumenti; e la Conca, e il suo piè. ");
INSERT INTO ita1885_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Così consacrerai quelle cose, e saranno cose santissime; tutto quello che le toccherà sia sacro. ");
INSERT INTO ita1885_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Ungi parimente Aaronne e i suoi figliuoli, e consacrali acciocchè mi esercitino il sacerdozio. ");
INSERT INTO ita1885_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","E parla a' figliuoli d'Israele, dicendo: Quest'olio mi sarà un olio di sacra unzione, per le vostre età. ");
INSERT INTO ita1885_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Non ungasene la carne di alcun uomo, e non ne fate alcun simigliante, secondo la sua composizione; egli è cosa santa; siavi cosa santa. ");
INSERT INTO ita1885_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Chi ne comporrà del simigliante, ovvero chi ne metterà sopra alcuna persona strana, sia riciso da' suoi popoli. ");
INSERT INTO ita1885_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Il Signore disse oltre a ciò a Mosè: Prenditi degli aromati, storace liquida, unghia odorosa, e galbano, e incenso puro; ciascuno aromato a parte a peso uguale. ");
INSERT INTO ita1885_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","E fanne un profumo una composizione aromatica fatta per arte di profumiere, confettata, pura e santa. ");
INSERT INTO ita1885_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","E di essa stritolane alquanto minuto minuto, e mettilo davanti alla Testimonianza, nel Tabernacolo della convenenza, dove io mi troverò teco. Siavi questo profumo una cosa santissima. ");
INSERT INTO ita1885_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","E non fatevi alcun profumo di composizione simigliante a quello che tu avrai fatto. Siati esso una cosa sacra al Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Chi ne farà del simigliante, per odorarlo, sia riciso da' suoi popoli. ");
INSERT INTO ita1885_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","IL Signore parlò ancora a Mosè, dicendo: Vedi, io ho chiamato per nome Besaleel, ");
INSERT INTO ita1885_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","figliuol di Uri, figliuol di Hur, della tribù di Giuda. ");
INSERT INTO ita1885_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","E l'ho ripieno dello spirito di Dio, in industria, e in ingegno, e in sapere, e in ogni artificio; ");
INSERT INTO ita1885_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","per far disegni da lavorare in oro, e in argento, e in rame; ");
INSERT INTO ita1885_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","e in arte di pietre da legare, e in arte di lavorar di legno, in qualunque lavorio. ");
INSERT INTO ita1885_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ed ecco, io gli ho aggiunto Oholiab, figliuol di Ahisamac, della tribù di Dan. Io ho oltre a ciò messa industria nell'animo d'ogni uomo industrioso, acciocchè facciano tutte le cose che io ti ho comandate. ");
INSERT INTO ita1885_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Il Tabernacolo della convenenza, e l'Arca per la Testimonianza, e il Coperchio che ha da esser sopra essa, e tutti gli arredi del Tabernacolo. ");
INSERT INTO ita1885_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","E la Tavola, e i suoi strumenti; e il Candelliere puro, e tutti i suoi strumenti; e l'Altar de' profumi. ");
INSERT INTO ita1885_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","E l'Altar degli olocausti, e tutti i suoi strumenti; e la Conca, e il suo piede. ");
INSERT INTO ita1885_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","E i vestimenti del servigio divino, e i vestimenti sacri del Sacerdote Aaronne, e i vestimenti dei suoi figliuoli, per esercitare il sacerdozio. ");
INSERT INTO ita1885_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","E l'olio dell'Unzione, e il profumo degli aromati per lo Santuario. Facciano interamente com'io ti ho comandato. ");
INSERT INTO ita1885_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","IL Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","E tu, parla a' figliuoli di Israele, dicendo: Tuttavia osservate i miei Sabati; perciocchè il Sabato è un segnale fra me e voi, per le vostre età; acciocchè voi conosciate ch'io sono il Signore che vi santifico. ");
INSERT INTO ita1885_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Osservate adunque il Sabato; perciocchè egli vi è un giorno santo; chiunque lo profanerà del tutto sia fatto morire; perciocchè qualunque persona farà in esso alcun lavoro, sarà ricisa d'infra i suoi popoli. ");
INSERT INTO ita1885_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Lavorisi sei giorni, ma al settimo giorno è il Sabato del riposo, giorno sacro al Signore; chiunque farà lavoro alcuno nel giorno del Sabato, del tutto sia fatto morire. ");
INSERT INTO ita1885_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Osservino adunque i figliuoli d'Israele il Sabato, per celebrarlo per le loro età, per patto perpetuo. ");
INSERT INTO ita1885_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Esso è un segnale perpetuo fra me e i figliuoli d'Israele; conciossiachè il Signore abbia in sei giorni fatto il cielo e la terra; e nel settimo giorno cessò, e si riposò. ");
INSERT INTO ita1885_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","E dopo che il Signore ebbe finito di parlar con Mosè in sul monte di Sinai, egli gli diede le due Tavole della Testimonianza, tavole di pietra, scritte col dito di Dio. ");
INSERT INTO ita1885_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","OR il popolo, veggendo che Mosè tardava a scender dal monte, si adunò appresso ad Aaronne, e gli disse: Levati, facci degl'iddii che vadano davanti a noi; perciocchè, quant'è a quell'uomo Mosè, che ci ha condotti fuor del paese di Egitto, noi non sappiamo che ne sia stato. ");
INSERT INTO ita1885_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ed Aaronne disse loro: Spiccate i pendenti d'oro che sono alle orecchie delle vostre mogli, de' vostri figliuoli, e delle vostre figliuole; e portatemeli. ");
INSERT INTO ita1885_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","E tutto il popolo si spiccò i pendenti d'oro che avea agli orecchi; e li portò ad Aaronne. ");
INSERT INTO ita1885_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ed egli li prese dalle lor mani; e, dopo aver fatto il modello con lo scarpello, ne fece un vitello di getto. E gl'Israeliti dissero: O Israele, questi sono i tuoi dii, che ti hanno tratto fuor del paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ed Aaronne, veggendo questo, edificò un altare davanti ad esso; e fece fare una grida, dicendo: Domani sarà festa solenne al Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","E la mattina seguente, i figliuoli di Israele si levarono a buon'ora, e sacrificarono olocausti, e offersero sacrificii da render grazie; e il popolo si assettò per mangiare e per bere; poi si levò per sollazzare. ");
INSERT INTO ita1885_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","E il Signore disse a Mosè: Va', scendi giù; perciocchè il tuo popolo, che tu hai tratto fuor del paese di Egitto, si è corrotto. ");
INSERT INTO ita1885_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Essi si son tosto stornati dalla via che io avea lor comandata; essi si hanno fatto un vitello di getto, e l'hanno adorato, e gli hanno sacrificato, e hanno detto: Questi, o Israele, sono i tuoi dii, che ti hanno tratto fuor del paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Il Signore disse ancora a Mosè: Io ho riguardato questo popolo, ed ecco, egli è un popolo di collo duro. ");
INSERT INTO ita1885_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ora dunque, lasciami fare, e l'ira mia si accenderà contro a loro, e io li consumerò; e io ti farò diventare una gran nazione. ");
INSERT INTO ita1885_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Ma Mosè supplicò al Signore Iddio suo, e disse: Perchè si accenderebbe, o Signore, l'ira tua contro al tuo popolo, che tu hai tratto fuor del paese di Egitto, con gran forza e con possente mano? ");
INSERT INTO ita1885_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Perchè direbbero gli Egizj: Egli li ha tratti fuori per male, per farli morir su per que' monti, e per consumarli d'in su la terra? Racqueta il tuo cruccio acceso, e pentiti di questo male inverso il tuo popolo. ");
INSERT INTO ita1885_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Ricordati di Abrahamo, d'Isacco e d'Israele, tuoi servitori, ai quali tu giurasti per te stesso; ed a' quali dicesti: Io moltiplicherò la vostra progenie, come le stelle del cielo; e darò alla vostra progenie tutto questo paese, del quale io ho parlato, acciocchè lo possegga in perpetuo. ");
INSERT INTO ita1885_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","E il Signore si pentì del male che avea detto di fare al suo popolo. ");
INSERT INTO ita1885_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","E Mosè, rivoltosi, scese dal monte, avendo in mano le due Tavole della Testimonianza, tavole scritte da' due lati, di qua e di là. ");
INSERT INTO ita1885_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","E le Tavole erano lavoro di Dio, e la scrittura era scrittura di Dio, intagliata sopra le Tavole. ");
INSERT INTO ita1885_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Or Giosuè udì il romor del popolo, mentre gridava, e disse a Mosè: E' vi è un grido di battaglia nel campo. ");
INSERT INTO ita1885_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","E Mosè disse: Questo non è punto grido di vittoriosi; nè grido di vinti; io odo un suono di canto. ");
INSERT INTO ita1885_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","E, come egli fu vicino al campo, vide quel vitello e le danze. E l'ira sua si accese, ed egli gittò le Tavole dalle sue mani, e le spezzò appiè del monte. ");
INSERT INTO ita1885_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Poi prese il vitello, che i figliuoli d'Israele aveano fatto, e lo bruciò col fuoco, e lo tritò, finchè fu ridotto in polvere; e sparse quella polvere sopra dell'acqua, e fece bere quell'acqua a' figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","E Mosè disse ad Aaronne: Che ti ha fatto questo popolo, che tu gli hai tratto addosso un gran peccato? ");
INSERT INTO ita1885_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Ed Aaronne disse: Non accendasi l'ira del mio signore; tu conosci questo popolo, come egli è dato al male. ");
INSERT INTO ita1885_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Essi mi dissero: Facci degl'iddii che vadano davanti a noi; perciocchè, quant'è e quell'uomo Mosè, che ci ha tratti fuor del paese di Egitto, noi non sappiamo che ne sia stato. ");
INSERT INTO ita1885_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","E io dissi loro: Chi ha dell'oro? spiccatevelo d'addosso. Ed essi mi diedero quell'oro, e io lo misi nel fuoco, e n'è uscito questo vitello. ");
INSERT INTO ita1885_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","E Mosè, veggendo che il popolo era spogliato (conciossiachè Aaronne lo avesse spogliato, per essere in vituperio appo i suoi assalitori), ");
INSERT INTO ita1885_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","si fermò alla porta del campo, e disse: Chi è qui per lo Signore? venga a me. E tutti i figliuoli di Levi si adunarono appresso a lui. ");
INSERT INTO ita1885_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ed egli disse loro: Così ha detto il Signore Iddio d'Israele: Ciascun di voi metta la sua spada al fianco; e passate, e ripassate per lo campo, da una porta all'altra, e uccidete ciascuno il suo fratello, il suo amico, e il suo prossimo parente. ");
INSERT INTO ita1885_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","E i figliuoli di Levi fecero secondo la parola di Mosè; e in quel giorno caddero morti del popolo intorno a tremila uomini. ");
INSERT INTO ita1885_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Or Mosè avea lor detto: Consacratevi oggi al Signore; anzi ciascuno si consacri nel suo proprio figliuolo, e nel suo fratello; e ciò affin di attrarre oggi benedizione sopra voi. E IL giorno seguente, Mosè disse al popolo: Voi avete commesso un gran peccato; ");
INSERT INTO ita1885_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","ma ora io salirò al Signore: forse farò io che vi sia perdonato il vostro peccato. ");
INSERT INTO ita1885_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Mosè dunque ritornò al Signore, e disse: Deh! Signore; questo popolo ha commesso un gran peccato, facendosi degl'iddii d'oro. ");
INSERT INTO ita1885_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ma ora, rimetti loro il lor peccato; se no, cancellami ora dal tuo Libro che tu hai scritto. ");
INSERT INTO ita1885_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","E il Signore disse a Mosè: Io cancellerò dal mio Libro colui che avrà peccato contro a me. ");
INSERT INTO ita1885_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Or va' al presente, conduci il popolo al luogo del quale ti ho parlato; ecco, un mio Angelo andrà davanti a te; e al giorno della mia visitazione, io li punirò del lor peccato. ");
INSERT INTO ita1885_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","E il Signore percosse il popolo, perciocchè avea fatto il vitello, che Aaronne avea fabbricato. ");
INSERT INTO ita1885_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Il Signore adunque disse a Mosè: Va', sali di qui, col popolo che tu hai tratto fuor del paese di Egitto, verso il paese del quale io ho giurato ad Abrahamo, a Isacco, e a Giacobbe, dicendo: Io lo darò alla tua progenie. ");
INSERT INTO ita1885_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ed io manderò davanti a te un Angelo, e caccerò i Cananei, gli Amorrei, gl'Hittei, i Ferezei, gl'Hivvei, e i Gebusei. ");
INSERT INTO ita1885_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Ed esso ti condurrà in un paese stillante latte e miele; perciocchè io non salirò nel mezzo di te; conciossiachè tu sii un popolo di collo duro; che talora io non ti consumi per lo cammino. ");
INSERT INTO ita1885_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","E il popolo, avendo udita questa dolorosa parola, ne fece cordoglio; e niuno si mise addosso i suoi ornamenti. ");
INSERT INTO ita1885_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Perciocchè il Signore avea detto a Mosè: Di' a' figliuoli d'Israele: Voi siete un popolo di collo duro; in un momento, se salgo nel mezzo di te, io ti avrò consumato; ora dunque, levati d'addosso i tuoi ornamenti, e io saprò quello che avrò da farti. ");
INSERT INTO ita1885_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","E i figliuoli d'Israele si trassero i loro ornamenti, dalla montagna di Horeb. ");
INSERT INTO ita1885_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","E Mosè prese il Padiglione, e se lo tese fuor del campo, lungi da esso; e lo nominò: Il Tabernacolo della convenenza; e, chiunque cercava il Signore, usciva fuori al Tabernacolo della convenenza, ch'era fuor del campo. ");
INSERT INTO ita1885_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Ora, quando Mosè uscì verso il Padiglione, tutto il popolo si levò, e ciascuno si fermò all'entrata del suo padiglione, e riguardò dietro a Mosè, finchè fosse entrato nel Padiglione. ");
INSERT INTO ita1885_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","E avvenne, come Mosè entrava nel Tabernacolo, la colonna della nuvola si abbassò, e si fermò all'entrata del Tabernacolo, e il Signore parlò con Mosè. ");
INSERT INTO ita1885_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","E tutto il popolo, veggendo la colonna della nuvola fermarsi all'entrata del Tabernacolo, si levò, e adorò, ciascuno all'entrata del suo padiglione. ");
INSERT INTO ita1885_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Ora, il Signore parlava a Mosè a faccia a faccia, come un uomo parla al suo compagno. Poi Mosè tornò nel campo; ma Giosuè, figliuol di Nun, ministro di Mosè, uomo giovane, non si partì di dentro al Tabernacolo. ");
INSERT INTO ita1885_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","E Mosè disse al Signore: Vedi, tu mi dici: Mena fuori questo popolo; e tu non mi hai fatto conoscere chi tu manderai meco; e pur tu mi hai detto: Io ti ho conosciuto per nome, e anche tu hai trovata grazia davanti agli occhi miei. ");
INSERT INTO ita1885_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ora dunque, se pure ho trovata grazia davanti agli occhi tuoi, fammi, ti prego, conoscere la tua via, e fa' ch'io ti conosca; acciocchè io trovi grazia davanti agli occhi tuoi; e riguarda che questa nazione è tuo popolo. ");
INSERT INTO ita1885_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","E il Signore disse: La mia faccia andrà, e io ti darò riposo. ");
INSERT INTO ita1885_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Mosè adunque avendo detto al Signore: Se la tua faccia non va con noi, non farci partir di qui; ");
INSERT INTO ita1885_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","e a che si conoscerà egli ora che io e il tuo popolo abbiamo trovata grazia davanti agli occhi tuoi? non sarà egli quando tu andrai con noi? onde io e il tuo popolo saremo renduti ammirabili sopra qualunque popolo che sia sopra la terra. ");
INSERT INTO ita1885_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Il Signore gli disse: Io farò ancora questo che tu dici; conciossiachè tu abbi trovata grazia davanti agli occhi miei, e che io t'abbia conosciuto per nome. ");
INSERT INTO ita1885_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","E Mosè disse al Signore: Deh! fammi veder la tua gloria. ");
INSERT INTO ita1885_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","E il Signore gli disse: Io farò passare davanti a te tutta la mia bellezza, e griderò il Nome del Signore davanti a te; e farò grazia a chi vorrò far grazia, e avrò pietà di chi vorrò aver pietà. ");
INSERT INTO ita1885_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ma gli disse: Tu non puoi veder la mia faccia; perciocchè l'uomo non mi può vedere, e vivere. ");
INSERT INTO ita1885_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Poi gli disse: Ecco un luogo appresso di me; fermati adunque sopra quel sasso. ");
INSERT INTO ita1885_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","E quando la mia gloria passerà, io ti metterò nella buca del sasso, e ti coprirò con la mia mano, finchè io sia passato. ");
INSERT INTO ita1885_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Poi rimoverò la mia mano, e tu mi vedrai di dietro; ma la mia faccia non si può vedere. ");
INSERT INTO ita1885_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","E IL Signore disse a Mosè: Tagliati due tavole di pietra, simili alle primiere; e io scriverò in su quelle tavole la parole ch'erano in su le primiere che tu spezzasti. ");
INSERT INTO ita1885_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","E sii presto domattina, e sali la mattina in sul monte di Sinai, e presentati quivi davanti a me, in su la sommità del monte. ");
INSERT INTO ita1885_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","E non salga teco alcuno, nè anche si vegga alcuno in tutto il monte, nè anche pasturi alcun bestiame, minuto o grosso, dirincontro a questo monte. ");
INSERT INTO ita1885_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Mosè adunque tagliò due tavole di pietra, simili alle primiere; e si levò la mattina seguente a buon'ora, e salì in sul monte di Sinai; come il Signore gli avea comandato; e prese in mano quelle due tavole di pietra. ");
INSERT INTO ita1885_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","E il Signore scese nella nuvola, e si fermò quivi con lui, e gridò: Il Nome del Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Il Signore adunque passò davanti a lui, e gridò: Il Signore, il Signore, l'Iddio pietoso e misericordioso, lento all'ira, e grande in benignità e verità; ");
INSERT INTO ita1885_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","che osserva la benignità in mille generazioni; che perdona l'iniquità, il misfatto, e il peccato: il quale altresì non assolve punto il colpevole; anzi fa punizione della iniquità de' padri sopra i figliuoli, e sopra i figliuoli de' figliuoli, fino alla terza e alla quarta generazione. ");
INSERT INTO ita1885_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","E Mosè subito s'inchinò a terra, e adorò. ");
INSERT INTO ita1885_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","E disse: Deh! Signore; se io ho trovata grazia davanti agli occhi tuoi, venga ora il Signore nel mezzo di noi; questo popolo è veramente un popolo di collo duro; ma tu, perdonaci le nostre iniquità e il nostro peccato, e possedici. ");
INSERT INTO ita1885_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","E il Signore disse: Ecco, io fo patto nel cospetto di tutto il tuo popolo; io farò maraviglie, quali non furono mai create in tutta la terra, nè fra alcuna nazione; e tutto il popolo, nel mezzo del quale tu sei, vedrà l'opera del Signore; conciossiachè quello che io farò teco sia cosa tremenda. ");
INSERT INTO ita1885_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Osserva quello che oggi ti comando. Ecco, io scaccerò d'innanzi a te gli Amorrei, e i Cananei, e gl'Hittei e i Ferezei, e gli Hivvei, e i Gebusei. ");
INSERT INTO ita1885_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Guardati che tu non faccia lega con gli abitanti del paese, nel qual tu entrerai; che talora essi non ti sieno in laccio nel mezzo di te. ");
INSERT INTO ita1885_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Anzi disfate i loro altari, e spezzate le loro statue, e tagliate i lor boschi. ");
INSERT INTO ita1885_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Perciocchè tu non hai da adorare altro dio; conciossiachè il nome del Signore sia: Il Geloso; egli è un Dio geloso. ");
INSERT INTO ita1885_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Guardati dunque che tu non faccia lega con gli abitanti di quel paese; che talora, quando essi fornicheranno dietro a' lor dii, e sacrificheranno loro, non ti chiamino, e tu non mangi de' lor sacrificii. ");
INSERT INTO ita1885_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","E non prenda delle lor figliuole per li tuoi figliuoli; e ch'esse, fornicando dietro a' lor dii, non facciano parimente fornicare i tuoi figliuoli dietro agl'iddii loro. ");
INSERT INTO ita1885_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Non farti alcun dio di getto. ");
INSERT INTO ita1885_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Osserva la festa solenne degli Azzimi; mangia azzimi sette giorni, come io ti ho comandato, nel tempo ordinato del mese di Abib; conciossiachè nel mese di Abib tu sii uscito di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Tutto quello che apre la matrice è mio; e di tutto il tuo bestiame sarà fatta offerta per ricordanza, cioè: dei primi parti del tuo minuto e del tuo grosso bestiame. ");
INSERT INTO ita1885_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Ma riscatta con un agnello, o con un capretto, il primogenito dell'asino; e se pur tu non lo riscatti, fiaccagli il collo; riscatta ogni primogenito d'infra i tuoi figliuoli; e non comparisca alcuno davanti a me vuoto. ");
INSERT INTO ita1885_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Lavora sei giorni, e riposati al settimo giorno; riposati eziandio nel tempo dell'arare e del mietere. ");
INSERT INTO ita1885_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Celebra ancora la festa solenne delle Settimane, ch'è la festa delle primizie della mietitura del grano; e parimente la festa solenne della ricolta de' frutti, all'uscita dell'anno. ");
INSERT INTO ita1885_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Tre volte l'anno comparisca ogni maschio tuo davanti alla faccia del Signore, dell'Eterno Signore Iddio d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Perciocchè io scaccerò le genti d'innanzi a te, e allargherò i tuoi confini; e quando tu salirai per comparir davanti alla faccia del Signore Iddio tuo, tre volte l'anno, niuno sarà mosso da cupidità per assalire il tuo paese. ");
INSERT INTO ita1885_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Scannando il mio sacrificio, non ispandere il sangue di esso con pan lievitato; e non sia il sacrificio della festa della Pasqua guardato la notte infino alla mattina. ");
INSERT INTO ita1885_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Porta nella Casa del Signore Iddio tuo le primizie de' primi frutti della tua terra. Non cuocere il capretto nel latte di sua madre. ");
INSERT INTO ita1885_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Poi il Signore disse a Mosè: Scrivi queste parole, perciocchè su queste parole io ho fatto patto teco e con Israele. ");
INSERT INTO ita1885_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","E Mosè stette quivi col Signore quaranta giorni e quaranta notti; senza mangiar pane, nè bere acqua; e il Signore scrisse sopra quelle tavole le parole del patto, le dieci parole. ");
INSERT INTO ita1885_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Ora, quando Mosè scese dal monte di Sinai, avendo le due Tavole della Testimonianza in mano, mentre scendeva dal monte, egli non sapeva che la pelle del suo viso era divenuta risplendente, mentre egli parlava col Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Ed Aaronne e tutti i figliuoli d'Israele riguardarono Mosè; ed ecco, la pelle del suo viso risplendeva; onde temettero di accostarsi a lui. ");
INSERT INTO ita1885_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ma Mosè il chiamò; ed Aaronne e tutti i principali ritornarono a lui alla raunanza; e Mosè parlò loro. ");
INSERT INTO ita1885_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","E, dopo questo, tutti i figliuoli d'Israele si accostarono, ed egli comandò loro tutte le cose che il Signore gli avea dette nel monte di Sinai. ");
INSERT INTO ita1885_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","E quando ebbe finito di parlar con loro, egli si mise un velo in sul viso. ");
INSERT INTO ita1885_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","E quando Mosè veniva davanti alla faccia del Signore, per parlar con lui, si toglieva il velo, finchè uscisse fuori; poi, come era uscito, diceva a' figliuoli d'Israele ciò che gli era comandato. ");
INSERT INTO ita1885_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","E i figliuoli d'Israele, riguardando la faccia di Mosè, vedevano che la pelle del suo viso risplendeva. Poi egli si rimetteva il velo in sul viso, finchè entrasse a parlar col Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","MOSÈ adunque adunò tutta la raunanza de' figliuoli d'Israele, e disse loro: Queste son le cose che il Signore ha comandate che si facciano: ");
INSERT INTO ita1885_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Lavorisi sei giorni, e al settimo giorno siavi giorno santo, il Riposo del Sabato consacrato al Signore; chiunque farà in esso opera alcuna sia fatto morire. ");
INSERT INTO ita1885_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Non accendete fuoco in alcuna delle vostre stanze nel giorno del Sabato. ");
INSERT INTO ita1885_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Poi Mosè disse a tutta la raunanza de' figliuoli d'Israele: Questo è quello che il Signore ha comandato. ");
INSERT INTO ita1885_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Pigliate di quello che avete appo voi da fare un'offerta al Signore; chiunque sarà d'animo volenteroso, porti quell' offerta al Signore; oro, e argento, e rame, ");
INSERT INTO ita1885_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","e violato, e porpora, e scarlatto, e fin lino, e pel di capra, ");
INSERT INTO ita1885_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","e pelli di montone tinte in rosso, e pelli di tasso, e legno di Sittim, ");
INSERT INTO ita1885_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","e olio per la lumiera, e aromati per l'olio dell'Unzione, e per lo profumo degli aromati, ");
INSERT INTO ita1885_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","e pietre onichine, e pietre da legare, per l'Efod, e per lo Pettorale. ");
INSERT INTO ita1885_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","E tutti gli uomini industriosi che son fra voi vengano, e facciano tutto quello che il Signore ha comandato: ");
INSERT INTO ita1885_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","il Tabernacolo, la sua tenda, la sua coverta, i suoi graffi, le sue assi, le sue sbarre, le sue colonne, e i suoi piedistalli; ");
INSERT INTO ita1885_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","l'Arca, e le sue stanghe; il Coperchio, e la Cortina da tender davanti; ");
INSERT INTO ita1885_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","la Tavola, e le sue stanghe, e tutti i suoi strumenti; e il Pane del cospetto; ");
INSERT INTO ita1885_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","e il Candelliere della lumiera, e i suoi strumenti, e le sue lampane, e l'olio per la lumiera; ");
INSERT INTO ita1885_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","e l'Altar de' profumi, e le sue stanghe; l'olio dell'Unzione, e il profumo degli aromati, e il Tappeto dell'entrata, per l'entrata del Tabernacolo; ");
INSERT INTO ita1885_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","l'Altar degli olocausti, e la sua grata di rame, e le sue sbarre, e tutti i suoi strumenti; la Conca, e il suo piede; ");
INSERT INTO ita1885_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","le cortine del Cortile, le sue colonne e i suoi piedistalli; e il Tappeto dell'entrata del Cortile; ");
INSERT INTO ita1885_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","i piuoli del Tabernacolo, e i piuoli del Cortile, e le lor corde; ");
INSERT INTO ita1885_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","i vestimenti del servigio, da fare il servigio nel Luogo santo; i vestimenti sacri del Sacerdote Aaronne, e i vestimenti de' suoi figliuoli, per esercitare il sacerdozio. ");
INSERT INTO ita1885_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Allora tutta la raunanza de' figliuoli d'Israele si partì dal cospetto di Mosè. ");
INSERT INTO ita1885_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","E tutti coloro, il cui cuore li sospinse, e il cui spirito li mosse volenterosamente, vennero, e portarono l'offerta del Signore, per l'opera del Tabernacolo della convenenza, e per ogni servigio di esso, e per li vestimenti sacri. ");
INSERT INTO ita1885_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","E tutte le persone di cuor volenteroso vennero, uomini e donne; e portarono fibbie, e monili, e anella, e fermagli; ogni sorte di arredi d'oro; oltre a tutti coloro che offersero al Signore offerta d'oro. ");
INSERT INTO ita1885_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","E ogni uomo, appo cui si trovò violato, o porpora, o scarlatto, o fin lino, o pel di capra, o pelli di montone tinte in rosso, e pelli di tasso, ne portò. ");
INSERT INTO ita1885_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Chiunque potè offerire offerta d'argento, e di rame, ne portò per l'offerta del Signore; parimente ciascuno, appo cui si trovò legno di Sittim, per qualunque opera del lavorio, ne portò. ");
INSERT INTO ita1885_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","E tutte le donne industriose filarono con le lor mani, e portarono il filato del violato, e della porpora, e dello scarlatto, e del fin lino. ");
INSERT INTO ita1885_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Tutte le donne ancora, il cui cuore le sospinse ad adoperarsi con industria, filarono il pel di capra. ");
INSERT INTO ita1885_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","E i principali del popolo portarono pietre onichine, e pietre da legare, per l'Efod, e per lo Pettorale; ");
INSERT INTO ita1885_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","e aromati, e olio, per la lumiera, e per l'olio dell'Unzione, e per lo profumo degli aromati. ");
INSERT INTO ita1885_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Così tutti coloro d'infra i figliuoli d'Israele, così uomini come donne, il cui cuore li mosse volenterosamente a portar ciò che faceva bisogno per tutto il lavorio, che il Signore avea comandato per Mosè che si facesse, portarono offerte volontarie al Signore. ");
INSERT INTO ita1885_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","E MOSÈ disse a' figliuoli d'Israele: Vedete, il Signore ha chiamato per nome Besaleel, figliuol di Uri, figliuol di Hur, della tribù di Giuda. ");
INSERT INTO ita1885_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","E l'ha empiuto dello Spirito di Dio, in industria, in ingegno, in sapere, e in ogni artificio; ");
INSERT INTO ita1885_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","eziandio per far disegni da lavorare in oro, e in argento, e in rame, ");
INSERT INTO ita1885_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","e in arte di pietre da legare, e in arte di lavorar di legno, per far qualunque lavorio ingegnoso. ");
INSERT INTO ita1885_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","E anche ha messo nell'animo suo il sapere ammaestrare altrui; e con lui Oholiab, figliuol di Ahisamac, della tribù di Dan. ");
INSERT INTO ita1885_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Egli li ha empiuti d'industria, da far qualunque lavorio di fabbro, e di disegnatore, e di ricamatore in violato, in porpora, in iscarlatto, e in fin lino; e di tessitore; e di artefice in qualunque lavorio e disegno. ");
INSERT INTO ita1885_vpl VALUES ("EX35_36","003_35_36","EXO","35","36","36","Besaleel adunque, e Oholiab, e ogni uomo industrioso, in cui il Signore ha posto industria ed ingegno, da saper lavorare, facciano tutto il lavorio dell'opera del Santuario, secondo tutto quello che il Signore ha comandato. ");
INSERT INTO ita1885_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","E Mosè chiamò Besaleel, e Oholiab, e ogni uomo industrioso, nel cui animo il Signore avea posta industria; ogni uomo il cui cuore lo sospinse a profferirsi a quell'opera, per farla. ");
INSERT INTO ita1885_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Ed essi tolsero d'innanzi a Mosè tutta quella offerta, che i figliuoli d'Israele aveano portata, acciocchè se ne facesse l'opera del lavoro del Santuario. Ma i figliuoli d'Israele portando loro ancora ogni mattina alcuna offerta volontaria; ");
INSERT INTO ita1885_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","tutti que' maestri artefici, che facevano tutto il lavorio del Santuario, lasciato ciascuno il suo lavorio che facevano, vennero, e dissero a Mosè: ");
INSERT INTO ita1885_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Il popolo porta troppo, vie più che non bisogna per lo lavoro dell'opera, che il Signore ha comandato che si faccia. ");
INSERT INTO ita1885_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Laonde Mosè comandò che si facesse andare una grida per lo campo, dicendo: Non faccia più nè uomo nè donna offerta di alcuna roba per lo Santuario. Così si divietò che il popolo non portasse altro. ");
INSERT INTO ita1885_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Perciocchè coloro aveano, in quelle robe che si erano già portate, quanto bastava loro per far tutto quel lavorio, e anche ne avanzava. ");
INSERT INTO ita1885_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","COSÌ tutti i maestri artefici, d'infra coloro che facevano il lavorio, fecero il Padiglione di dieci teli di fin lino ritorto, e di violato, e di porpora, e di scarlatto; essi fecero que' teli lavorati a Cherubini, di lavoro di disegno. ");
INSERT INTO ita1885_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","La lunghezza di un telo era di ventotto cubiti, e la larghezza di quattro cubiti: tutti que' teli erano di una stessa misura. ");
INSERT INTO ita1885_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","E accoppiarono cinque teli l'uno con l'altro; parimente accoppiarono cinque altri teli l'uno con l'altro. ");
INSERT INTO ita1885_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","E fecero de' lacciuoli di violato all'orlo dell'un de' teli, all'estremità dell'uno degli accoppiamenti; fecero ancora il simigliante nell'orlo dell'estremo telo nel secondo accoppiamento. ");
INSERT INTO ita1885_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Fecero cinquanta lacciuoli all'uno di que' teli; e fecero parimente cinquanta lacciuoli all'estremità del telo che era al secondo accoppiamento; que' lacciuoli erano l'uno dirincontro all'altro. ");
INSERT INTO ita1885_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Fecero ancora cinquanta graffi d'oro, e accoppiarono i teli l'uno con l'altro con quei graffi; e così il Padiglione fu giunto in uno. ");
INSERT INTO ita1885_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Fecero, oltre a ciò, de'teli di pel di capra, per Tenda sopra il Padiglione. ");
INSERT INTO ita1885_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Fecero undici di que' teli. La lunghezza d'uno di essi era di trenta cubiti, e la larghezza di quattro cubiti; quegli undici teli erano di una stessa misura. ");
INSERT INTO ita1885_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","E accoppiarono cinque teli da parte, e sei teli da parte. ");
INSERT INTO ita1885_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","E fecero cinquanta lacciuoli all'orlo del telo estremo dell'uno degli accoppiamenti; e altri cinquanta lacciuoli all'orlo del medesimo telo del secondo accoppiamento. ");
INSERT INTO ita1885_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Fecero, oltre a ciò, cinquanta graffi di rame, per giugnere insieme la Tenda, acciocchè fosse giunta in uno. ");
INSERT INTO ita1885_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Fecero ancora alla Tenda una coverta di pelli di montone, tinte in rosso; e un'altra coverta di pelli di tasso, di sopra. ");
INSERT INTO ita1885_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Poi fecero per lo Tabernacolo le assi di legno di Sittim, da esser ritte. ");
INSERT INTO ita1885_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","La lunghezza di ciascun'asse era di dieci cubiti, e la larghezza di un cubito e mezzo. ");
INSERT INTO ita1885_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","E in ciascun'asse v'erano due cardini da incastrar l'un pezzo con l'altro; così fecero a tutte le assi del Tabernacolo. ");
INSERT INTO ita1885_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Fecero adunque le assi per lo Tabernacolo; venti assi pel lato Australe, verso il Mezzodì; ");
INSERT INTO ita1885_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","e quaranta piedistalli di argento, per metter sotto quelle venti assi; due piedistalli sotto ciascun'asse, per li suoi due cardini. ");
INSERT INTO ita1885_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","E per l'altro lato del Tabernacolo, verso l'Aquilone, venti assi; ");
INSERT INTO ita1885_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","co' lor quaranta piedistalli di argento, due piedistalli sotto ciascun'asse. ");
INSERT INTO ita1885_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","E per lo fondo del Tabernacolo, verso l'Occidente, fecero sei assi. ");
INSERT INTO ita1885_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Fecero ancora due assi per li cantoni del Tabernacolo, nel fondo di esso. ");
INSERT INTO ita1885_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","E quelle erano a due facce fin da basso; e tutte erano ben commesse insieme al capo di ciascuna di queste assi, con un anello; fecero queste due assi ch'erano per li due cantoni, di una medesima maniera. ");
INSERT INTO ita1885_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","V'erano adunque otto assi, insieme co' lor sedici piedistalli di argento; due piedistalli sotto ciascun'asse. ");
INSERT INTO ita1885_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Fecero, oltre a ciò, cinque sbarre di legno di Sittim, per le assi dell'uno de' lati del Tabernacolo. ");
INSERT INTO ita1885_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Parimente cinque sbarre per le assi dell'altro lato del Tabernacolo; e cinque sbarre per le assi del fondo del Tabernacolo, verso l'Occidente. ");
INSERT INTO ita1885_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","E fecero la sbarra di mezzo, per traversar per lo mezzo delle assi, da un capo all'altro. ");
INSERT INTO ita1885_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","E copersero d'oro le assi, e fecero d'oro i loro anelli, per mettervi dentro le sbarre; copersero anche d'oro le sbarre. ");
INSERT INTO ita1885_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Fecero ancora la Cortina di violato, e di porpora, e di scarlatto, e di fin lino ritorto, di lavoro di disegno: la fecero di lavoro di disegno a Cherubini. ");
INSERT INTO ita1885_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","E fecero per essa quattro colonne di legno di Sittim e le copersero d'oro; e i lor capitelli erano d'oro; e fonderono per quelle colonne quattro piedistalli di argento. ");
INSERT INTO ita1885_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Fecero eziandio per l'entrata del Tabernacolo un Tappeto di violato, e di porpora, e di scarlatto, e di fin lino ritorto, di lavoro di ricamatore; con le lor cinque colonne, ");
INSERT INTO ita1885_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","e i lor capitelli; e copersero d'oro i capitelli, e i fili di esse; e fecero loro cinque piedistalli di rame. ");
INSERT INTO ita1885_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","BESALEEL fece ancora l'Arca, di legno di Sittim; la sua lunghezza era di due cubiti e mezzo, e la larghezza di un cubito e mezzo, e l'altezza di un cubito e mezzo. ");
INSERT INTO ita1885_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","E la coperse d'oro puro, di dentro e di fuori, e le fece una corona d'oro attorno. ");
INSERT INTO ita1885_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","E le fondè quattro anelli d'oro, e mise quegli anelli a' quattro piedi di essa, due dall'uno de' lati di essa, e due dall'altro. ");
INSERT INTO ita1885_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Fece ancora delle stanghe di legno di Sittim, e le coperse d'oro. ");
INSERT INTO ita1885_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","E mise quelle stanghe dentro agli anelli, da' lati dell'Arca, per portarla. ");
INSERT INTO ita1885_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Fece ancora il Coperchio d'oro puro; e la sua lunghezza era di due cubiti e mezzo, e la larghezza di un cubito e mezzo. ");
INSERT INTO ita1885_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Fece, oltre a ciò, due Cherubini d'oro; li fece di lavoro tirato al martello, da' due capi del Coperchio; ");
INSERT INTO ita1885_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","un Cherubino nell'uno de' capi di qua, e un altro nell'altro di là; fece que' Cherubini tirati dal Coperchio stesso, da' due capi di esso. ");
INSERT INTO ita1885_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","E i Cherubini spandevano l'ale in su, facendo coverta sopra il Coperchio con le loro ale; e aveano le lor facce volte l'uno verso l'altro; le facce de' Cherubini erano verso il Coperchio. ");
INSERT INTO ita1885_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Fece ancora la Tavola, di legno di Sittim; la sua lunghezza era di due cubiti, e la larghezza di un cubito, e l'altezza di un cubito e mezzo. ");
INSERT INTO ita1885_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","E la coperse d'oro puro, e le fece una corona d'oro attorno. ");
INSERT INTO ita1885_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Le fece eziandio attorno una chiusura di larghezza di un palmo, e a quella sua chiusura fece una corona d'oro attorno. ");
INSERT INTO ita1885_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","E fondè a quella Tavola quattro anelli d'oro, e mise quegli anelli a' quattro canti, ch'erano a' quattro piedi di essa Tavola. ");
INSERT INTO ita1885_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Quegli anelli erano dirincontro a quella chiusura, per mettervi dentro le stanghe, da portar la Tavola. ");
INSERT INTO ita1885_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Fece, oltre a ciò, le stanghe di legno di Sittim, e le coperse d'oro. ");
INSERT INTO ita1885_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Fece ancora d'oro puro i vasellamenti che s'aveano a mettere sopra la Tavola, le sue scodelle, e le sue coppe, e i suoi bacini, e i suoi nappi, co' quali si doveano far gli spargimenti. ");
INSERT INTO ita1885_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Fece eziandio il Candelliere, d'oro puro; egli lo fece di lavoro tirato al martello; così il suo gambo, come i suoi rami, i suoi vasi, i suoi pomi, e le sue bocce, erano di un pezzo. ");
INSERT INTO ita1885_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","E v'erano sei rami procedenti da' lati di esso; tre rami dall'uno de' lati di esso, e tre dall'altro. ");
INSERT INTO ita1885_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Nell'uno di essi rami v'erano tre vasi in forma di mandorla, un pomo, e una boccia, a ciascun vaso; parimente tre vasi in forma di mandorla, un pomo, e una boccia a ciascun vaso, nell'altro ramo; e così in tutti i sei rami procedenti dal Candelliere. ");
INSERT INTO ita1885_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","E nel gambo del Candelliere v'erano quattro vasi in forma di mandorla, co' suoi pomi, e con le sue bocce. ");
INSERT INTO ita1885_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","E ne' sei rami procedenti dal Candelliere, v'era un pomo sotto i due primi rami, d'un pezzo col Candelliere; e un pomo sotto i due altri rami, d'un pezzo col Candelliere; e un pomo sotto i due altri rami, d'un pezzo col Candelliere. ");
INSERT INTO ita1885_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","I pomi de' rami e i rami loro erano d'un pezzo col Candelliere; tutto il Candelliere era d'un pezzo d'oro puro tirato al martello. ");
INSERT INTO ita1885_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Fece ancora le sette lampane d'esso, i suoi smoccolatoi, e i suoi catinelli, d'oro puro. ");
INSERT INTO ita1885_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Egli impiegò intorno al Candelliere, e a tutti i suoi strumenti, un talento d'oro. ");
INSERT INTO ita1885_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Poi fece l'Altar de' profumi, di legno di Sittim; la sua lunghezza era di un cubito, e la larghezza di un cubito, sì ch'era quadrato; e la sua altezza era di due cubiti; e le sue corna erano tirate d'esso. ");
INSERT INTO ita1885_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","E lo coperse d'oro puro, il suo coperchio, i suoi lati d'intorno, e le sue corna: gli fece eziandio una corona d'oro attorno. ");
INSERT INTO ita1885_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Gli fece ancora due anelli d'oro, disotto a quella sua corona, a' due suoi cantoni, da due de' suoi lati, i quali erano per mettervi dentro le stanghe, per portar quell'Altare con esse. ");
INSERT INTO ita1885_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","E fece quelle stanghe di legno di Sittim, e le coperse d'oro. ");
INSERT INTO ita1885_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Poi fece l'olio sacro dell'Unzione, e il profumo degli aromati, puro, di lavoro di profumiere. ");
INSERT INTO ita1885_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","POI fece l'Altar degli olocausti, di legno di Sittim; la sua lunghezza era di cinque cubiti, e la larghezza di cinque cubiti, tal ch'era quadrato, e l'altezza di tre cubiti. ");
INSERT INTO ita1885_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","E gli fece delle corna a' suoi quattro canti, le quali erano tirate dall'Altare; e lo coperse di rame. ");
INSERT INTO ita1885_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Fece eziandio tutti gli strumenti dell'Altare, i calderoni, e le palette, e i bacini, e le forcelle, e le cazze; egli fece tutti gli strumenti dell'Altare di rame. ");
INSERT INTO ita1885_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Fece ancora all'Altare una grata di rame, di lavor reticolato, disotto al procinto dell'Altare, a basso, ed era fino a mezzo l'Altare. ");
INSERT INTO ita1885_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","E fondè quattro anelli, i quali egli mise a' quattro canti della grata di rame, per mettervi dentro le stanghe. ");
INSERT INTO ita1885_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Fece, oltre a ciò, le stanghe di legno di Sittim, e le coperse di rame. ");
INSERT INTO ita1885_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","E mise quelle stanghe dentro agli anelli, a' lati dell'Altare, per portarlo con esse; egli fece l'Altare di tavole, vuoto. ");
INSERT INTO ita1885_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Fece ancora di rame la Conca, e il suo piè di rame, degli specchi delle donne, che a certi tempi ordinati venivano a servire nell'entrata del Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Fece, oltre a ciò, il Cortile; dal lato Australe verso il Mezzodì v'erano cento cubiti di cortine di fin lino ritorto, per lo Cortile, ");
INSERT INTO ita1885_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","con le lor venti colonne, e i lor venti piedistalli, di rame; ma i capitelli delle colonne, e i lor fili, erano di argento. ");
INSERT INTO ita1885_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Così ancora dal lato Settentrionale v'erano cento cubiti di cortine, con le lor venti colonne, e i lor venti piedistalli, di rame; ma i capitelli delle colonne, e i lor fili, erano d'argento. ");
INSERT INTO ita1885_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","E dal lato Occidentale, v'erano cinquanta cubiti di cortine, con le lor dieci colonne, e i lor dieci piedistalli; e i capitelli delle colonne, e i lor fili, erano di argento. ");
INSERT INTO ita1885_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","E dal lato Orientale, verso il Levante, v'erano cinquanta cubiti di cortine. ");
INSERT INTO ita1885_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Cioè, all'un de' canti vi erano quindici cubiti di cortine, con le lor tre colonne, e i lor tre piedistalli; ");
INSERT INTO ita1885_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","e all'altro canto, cioè così di qua, come di là dell'entrata del Cortile, quindici cubiti di cortine, con le lor tre colonne, e i lor tre piedistalli. ");
INSERT INTO ita1885_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Tutte le cortine del Cortile d'intorno erano di fin lino ritorto. ");
INSERT INTO ita1885_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","E i piedistalli e le colonne erano di rame; ma i capitelli delle colonne, e i lor fili erano di argento; tutte le colonne del Cortile aveano i capitelli coperti di argento; ma i lor fili erano di argento. ");
INSERT INTO ita1885_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Fece ancora all'entrata del Cortile un tappeto di lavoro di ricamatore, di violato, e di porpora, e di scarlatto, e di fin lino ritorto, di venti cubiti di lunghezza, e di cinque cubiti d'altezza, nella larghezza corrispondente alle cortine del Cortile; ");
INSERT INTO ita1885_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","con le lor quattro colonne, e i lor quattro piedistalli, di rame; ma i lor capitelli erano di argento; esse aveano i lor capitelli coperti di argento, ma i lor fili erano di argento. ");
INSERT INTO ita1885_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","E fece tutti i piuoli del Tabernacolo, e del Cortile d'intorno, di rame. ");
INSERT INTO ita1885_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","QUESTE son le somme dell'oro, dell'argento, e del rame, impiegato intorno al Tabernacolo della Testimonianza, le quali furono fatte d'ordine di Mosè, per opera de' Leviti, sotto la condotta d'Itamar, figliuol del Sacerdote Aaronne. ");
INSERT INTO ita1885_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Delle quali Besaleel, figliuol di Uri, figliuol di Hur, della tribù di Giuda, fece tutte quelle cose che il Signore avea comandate a Mosè; ");
INSERT INTO ita1885_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","insieme con Oholiab, figliuol di Ahisamac, della tribù di Dan, e altri fabbri, e disegnatori, e ricamatori in violato, e in porpora, e in iscarlatto, e in fin lino. ");
INSERT INTO ita1885_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Tutto l'oro che fu impiegato nell'opera, in tutto il lavorio del Santuario: l'oro di quell'offerta fu ventinove talenti, e settecentrenta sicli, a siclo di Santuario. ");
INSERT INTO ita1885_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","E l'argento degli annoverati d'infra la raunanza fu cento talenti, e mille settecensettantacinque sicli, a siclo di Santuario; ");
INSERT INTO ita1885_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","prendendo un didramma per testa, ch'è la metà d'un siclo, a siclo di Santuario, da chiunque passava fra gli annoverati, dall'età di vent'anni in su, i quali furono seicentotremila cinquecentocinquanta. ");
INSERT INTO ita1885_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Di questo argento cento talenti furono per fondere i piedistalli del Santuario, e i piedistalli della Cortina; cento talenti per cento piedistalli, un talento per piedistallo. ");
INSERT INTO ita1885_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","E con que' mille settecensettantacinque sicli, egli fece i capitelli alle colonne, e coperse i lor capitelli; e fece lor de' fili. ");
INSERT INTO ita1885_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","E il rame dell'offerta fu settanta talenti, e duemila quattrocento sicli. ");
INSERT INTO ita1885_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","E d'esso fece i piedistalli dell'entrata del Tabernacolo della convenenza, e l'Altar di rame, e la sua grata di rame; e tutti gli strumenti dell'Altare; ");
INSERT INTO ita1885_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","e i piedistalli del Cortile, d'intorno, e i piedistalli dell'entrata del Cortile, e tutti i piuoli del Tabernacolo, e tutti i piuoli del Cortile d'intorno. ");
INSERT INTO ita1885_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","POI del violato, e della porpora e dello scarlatto, coloro fecero i vestimenti del servigio, per fare il ministerio nel Santuario; e anche fecero i vestimenti sacri per Aaronne; come il Signore avea comandato a Mosè. ");
INSERT INTO ita1885_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Fecero adunque l'Efod d'oro, di violato, e di porpora, e di scarlatto, e di fin lino ritorto. ");
INSERT INTO ita1885_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","E assottigliarono delle piastre d'oro e le tagliarono per fila, per metterle in opera per mezzo il violato, e per mezzo la porpora, e per mezzo lo scarlatto, e per mezzo il fin lino, in lavoro di disegno. ");
INSERT INTO ita1885_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","E fecero a quello degli omerali che si accoppiavano insieme; e così l'Efod era accoppiato dai suoi due capi. ");
INSERT INTO ita1885_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","E il disegno del fregio ch'era sopra l'Efod, era tirato dell'Efod istesso, e del medisimo lavoro, d'oro, e di violato, e di porpora, e di scarlatto, e di fin lino ritorto; come il Signore avea comandato a Mosè. ");
INSERT INTO ita1885_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Lavorarono ancora le pietre onichine, intorniate di castoni d'oro, nelle quali erano scolpiti i nomi de' figliuoli d'Israele, a lavoro d'intagli di suggello. ");
INSERT INTO ita1885_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","E le misero sopra gli omerali dell'Efod, per esser pietre di ricordanza per li figliuoli d'Israele; come il Signore avea comandato a Mosè. ");
INSERT INTO ita1885_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Fecero, oltre a ciò, il Pettorale, di lavoro di disegno, e dell'istesso lavoro dell'Efod, d'oro, di violato, e di porpora, e di scarlatto, e di fin lino ritorto. ");
INSERT INTO ita1885_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Il Pettorale era quadrato ed essi lo fecero doppio; la sua lunghezza era d'una spanna, e la sua larghezza d'una spanna; ed era doppio. ");
INSERT INTO ita1885_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","E incastrarono in esso quattro ordini di pietre; nel primo v'era un sardonio, un topazio, e uno smeraldo. ");
INSERT INTO ita1885_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","E nel second'ordine v'era un carbonchio, uno zaffiro, e un diamante. ");
INSERT INTO ita1885_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","E nel terz'ordine v'era un ligurio, un'agata, ed un'amatista. ");
INSERT INTO ita1885_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","E nel quart'ordine v'era un grisolito, una pietra onichina, e un diaspro. Queste pietre erano legate in oro, ciascuna nel suo castone. ");
INSERT INTO ita1885_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","E quelle pietre erano in numero di dodici, secondo i nomi dei figliuoli d'Israele; in ciascuna d'esse era scolpito, a lavoro d'intagli di suggello, il suo nome, per le dodici tribù. ");
INSERT INTO ita1885_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Fecero ancora al Pettorale le catenelle, d'oro puro, a capi, di lavoro intorcicchiato. ");
INSERT INTO ita1885_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Fecero, oltre a ciò, due castoni d'oro, e due fibbie d'oro; misero eziandio due anelli a due capi del Pettorale. ");
INSERT INTO ita1885_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Poi attaccarono quelle due catenelle d'oro intorcicchiate a que' due anelli, a' capi del Pettorale. ");
INSERT INTO ita1885_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","E i due capi dell'altre due catenelle intorcicchiate li attaccarono a que' due castoni, i quali essi misero sopra gli omerali dell'Efod, in su la parte anteriore di esso. ");
INSERT INTO ita1885_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Fecero ancora due anelli d'oro, i quali misero agli altri due capi del Pettorale, all'orlo di esso, ch'era allato all'Efod, in dentro. ");
INSERT INTO ita1885_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Fecero, oltre a ciò, due anelli d'oro, e li misero ai due omerali dell'Efod, disotto, nella parte anteriore di esso, allato alla giuntura d'esso, disopra al fregio lavorato dell'Efod. ");
INSERT INTO ita1885_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","E serrarono il Pettorale da' suoi anelli agli anelli dell'Efod, con una bendella di violato; in modo ch'egli era disopra del fregio lavorato dell'Efod, e non poteva esser tolto d'in su l'Efod; come il Signore avea comandato a Mosè. ");
INSERT INTO ita1885_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Fecero ancora il Manto dell'Efod, di lavoro tessuto, tutto di violato. ");
INSERT INTO ita1885_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","E nel mezzo di quel Manto v'era una scollatura, simile a una scollatura di corazza, avendo un orlo attorno, acciocchè non si schiantasse. ");
INSERT INTO ita1885_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","E alle fimbrie di esso Manto d'intorno, fecero delle melagrane di violato, e di porpora, e di scarlatto, a fila ritorte. ");
INSERT INTO ita1885_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Fecero ancora de' sonagli d'oro puro, e misero que' sonagli per mezzo quelle melagrane, alle fimbrie del Manto d'intorno, mescolandoli con le melagrane. ");
INSERT INTO ita1885_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","E mettendo un sonaglio, poi una melagrana; un sonaglio, poi una melagrana, alle fimbrie del Manto d'ogni intorno, per fare il ministerio; come il Signore avea comandato a Mosè. ");
INSERT INTO ita1885_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Fecero ancora le toniche di fin lino, di lavoro tessuto, per Aaronne, e per li suoi figliuoli. ");
INSERT INTO ita1885_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Fecero parimente la Benda di fin lino, e gli ornamenti delle mitrie, altresì di fin lino; e le mutande line, di fin lino ritorto. ");
INSERT INTO ita1885_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Fecero ancora la Cintura, di fin lino ritorto, e di violato, e di porpora, e di scarlatto, di lavoro di ricamatore; come il Signore avea comandato a Mosè. ");
INSERT INTO ita1885_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Fecero ancora la lama della sacra corona, d'oro puro; e scrissero sopra essa, in iscrittura d'intagli di suggello: LA SANTITÀ DEL SIGNORE. ");
INSERT INTO ita1885_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","E misero a quella una bendella di violato, per metterla in su la Benda, disopra; come il Signore avea comandato a Mosè. ");
INSERT INTO ita1885_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Così fu finito tutto il lavorio del Padiglione, e del Tabernacolo della convenenza; e i figliuoli d'Israele fecero interamente secondo che il Signore avea comandato a Mosè. ");
INSERT INTO ita1885_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","POI portarono a Mosè la Tenda, il Tabernacolo, e tutti i suoi arredi, i suoi graffi, le sue assi, le sue sbarre, le sue colonne, e i suoi piedistalli; ");
INSERT INTO ita1885_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","e la coverta delle pelli di montone tinte in rosso, e la coverta delle pelli di tasso, e la Cortina da tendere davanti al Luogo santissimo; ");
INSERT INTO ita1885_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","l'Arca della Testimonianza, e le sue stanghe; e il Coperchio; ");
INSERT INTO ita1885_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","la Tavola, e tutti i suoi strumenti; e il pane del cospetto; ");
INSERT INTO ita1885_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","il Candelliere puro, e le sue lampane da tenere in ordine del continuo; e tutti i suoi strumenti, e l'olio per la lumiera; ");
INSERT INTO ita1885_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","e l'Altare d'oro, e l'olio dell'Unzione, e il profumo degli aromati, e il Tappeto dell'entrata del Tabernacolo; ");
INSERT INTO ita1885_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","l'Altar di rame, e la sua grata di rame, le sue sbarre, e tutti i suoi strumenti; la Conca, e il suo piede; ");
INSERT INTO ita1885_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","le cortine del Cortile, le sue colonne, e i suoi piedistalli; e il Tappeto per l'entrata del Cortile; le funi di esso Cortile, e i suoi piuoli, e tutti gli arredi dell'opera della Tenda del Tabernacolo della convenenza; ");
INSERT INTO ita1885_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","i vestimenti del servigio, per fare il ministerio nel Santuario; i vestimenti sacri per il Sacerdote Aaronne, e i vestimenti de' suoi figliuoli, per esercitare il sacerdozio. ");
INSERT INTO ita1885_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","I figliuoli d'Israele fecero tutto il lavorio, interamente secondo che il Signore avea comandato a Mosè. ");
INSERT INTO ita1885_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","E Mosè vide tutta l'opera; ed ecco, essi l'aveano fatta come il Signore avea comandato. E Mosè li benedisse. ");
INSERT INTO ita1885_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","E IL Signore parlò a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Nel primo giorno del primo mese rizza la Tenda del Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","E mettivi dentro l'Arca della Testimonianza, e tendi la Cortina davanti all'Arca. ");
INSERT INTO ita1885_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Poi portavi dentro la Tavola, e ordina ciò che deve essere ordinato in quella; portavi parimente il Candelliere, e accendi le sue lampane. ");
INSERT INTO ita1885_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","E metti l'Altare d'oro per li profumi davanti all'Arca della Testimonianza; metti eziandio il Tappeto all'entrata del Tabernacolo. ");
INSERT INTO ita1885_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","E metti l'Altare degli olocausti davanti all'entrata della Tenda del Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","E metti la Conca fra il Tabernacolo della convenenza, e l'Altare; e mettivi dentro dell'acqua. ");
INSERT INTO ita1885_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Disponi ancora il Cortile d'intorno, e metti il Tappeto all'entrata del Cortile. ");
INSERT INTO ita1885_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Poi piglia l'olio dell'Unzione, e ungine il Tabernacolo, e tutto quello chi vi sarà dentro; e consacralo, con tutti i suoi arredi; e sarà cosa santa. ");
INSERT INTO ita1885_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ungi parimente l'Altar degli olocausti, e tutti i suoi strumenti, e consacra l'Altare; e sarà cosa santissima. ");
INSERT INTO ita1885_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ungi ancora la Conca, e il suo piè, e consacrala. ");
INSERT INTO ita1885_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Poi fa' accostare Aaronne e i suoi figliuoli, all'entrata del Tabernacolo della convenenza; e lavali con acqua. ");
INSERT INTO ita1885_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","E fai vestire ad Aaronne i vestimenti sacri, e ungilo, e consacralo; e così amministrimi egli il sacerdozio. ");
INSERT INTO ita1885_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Fa' eziandio accostare i suoi figliuoli, e fa' lor vestir le toniche. ");
INSERT INTO ita1885_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","E ungili, come tu avrai unto il padre loro; e così amministrinmi il sacerdozio; e la loro Unzione sarà loro per sacerdozio perpetuo, per le lor generazioni. ");
INSERT INTO ita1885_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","E Mosè fece interamente come il Signore gli avea comandato. ");
INSERT INTO ita1885_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","E nell'anno secondo, nel primo giorno del primo mese, fu rizzato il Tabernacolo. ");
INSERT INTO ita1885_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mosè adunque rizzò il Tabernacolo; e, posati i suoi piedistalli, dispose le sue assi, e vi mise le sbarre, e rizzò le sue colonne. ");
INSERT INTO ita1885_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","E stese la Tenda sopra il Tabernacolo, e pose la coverta della Tenda sopra essa al disopra; come il Signore gli avea comandato. ");
INSERT INTO ita1885_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Poi prese la Testimonianza, e la pose dentro all'Arca; e mise le stanghe all'Arca; e posò il Coperchio in su l'Arca, disopra. ");
INSERT INTO ita1885_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","E portò l'Arca dentro al Tabernacolo, e mise la Cortina che s'avea da tender davanti, e la tese davanti all'Arca della Testimonianza; come il Signore gli avea comandato. ");
INSERT INTO ita1885_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Poi mise la Tavola nel Tabernacolo della convenenza, dal lato settentrionale del Tabernacolo, difuori della Cortina; ");
INSERT INTO ita1885_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","e mise per ordine sopra essa i pani che si aveano da tenere in ordine davanti al Signore; come il Signore gli avea comandato. ");
INSERT INTO ita1885_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Poi mise il Candelliere nel Tabernacolo della convenenza, dirimpetto alla Tavola, dal lato australe del Tabernacolo; ");
INSERT INTO ita1885_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","e accese le lampane davanti al Signore; come il Signore gli avea comandato. ");
INSERT INTO ita1885_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Poi mise l'Altar d'oro nel Tabernacolo della convenenza, davanti alla Cortina; ");
INSERT INTO ita1885_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","e bruciò sopra esso il profumo degli aromati; come il Signore gli avea comandato. ");
INSERT INTO ita1885_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Poi mise il Tappeto all'entrata del Tabernacolo. ");
INSERT INTO ita1885_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","E pose l'Altar degli olocausti all'entrata della Tenda del Tabernacolo della convenenza; e offerse sopra esso l'olocausto, e l'offerta; come il Signore gli avea comandato. ");
INSERT INTO ita1885_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","E pose la Conca fra il Tabernacolo della convenenza, e l'Altare; e vi mise dentro dell'acqua, da lavare. ");
INSERT INTO ita1885_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","E Mosè, ed Aaronne, e i suoi figliuoli, se ne lavarono le mani ed i piedi. ");
INSERT INTO ita1885_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Quando entravano nel Tabernacolo della convenenza, e quando si accostavano all'Altare, si lavavano; come il Signore avea comandato a Mosè. ");
INSERT INTO ita1885_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Poi rizzò il Cortile d'intorno al Tabernacolo, e all'Altare; e mise il Tappeto all'entrata del Cortile. Così Mosì fornì l'opera. ");
INSERT INTO ita1885_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","E la nuvola coperse il Tabernacolo della convenenza, e la gloria del Signore empiè il Tabernacolo. ");
INSERT INTO ita1885_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","E Mosè non potè entrare nel Tabernacolo della convenenza; conciossiachè la nuvola si fosse posata sopra esso, e la gloria del Signore empiesse il Tabernacolo. ");
INSERT INTO ita1885_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Or, quando la nuvola s'alzava d'in sul Tabernacolo, i figliuoli d'Israele si partivano; ciò avvenne in tutte le lor mosse. ");
INSERT INTO ita1885_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","E, quando la nuvola non si alzava, non si partivano, fino al giorno ch'ella s'alzava. ");
INSERT INTO ita1885_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Perciocchè la nuvola del Signore era di giorno sopra il Tabernacolo, e un fuoco v'era di notte, alla vista di tutta la casa d'Israele, in tutti i lor viaggi.");
INSERT INTO ita1885_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","OR il Signore chiamò Mosè, e parlò a lui dal Tabernacolo della convenenza, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Parla a' figliuoli d'Israele, e di' loro: Quando alcun di voi offerirà un'offerta al Signore, se quella è di animali, offerite le vostre offerte di buoi, o di pecore, o di capre. ");
INSERT INTO ita1885_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Se la sua offerta è olocausto di buoi, offerisca quell'animale maschio, senza difetto; offeriscalo all'entrata del Tabernacolo della convenenza; acciocchè quello sia gradito per lui davanti al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","E posi la mano in su la testa dell'olocausto; ed esso sarà gradito, per far purgamento del peccato per lui. ");
INSERT INTO ita1885_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Poi quel bue sarà scannato davanti al Signore; e i figliuoli di Aaronne, sacerdoti, ne offeriranno il sangue, e lo spanderanno in su l'Altare ch'è all' entrata del Tabernacolo della convenenza, attorno attorno. ");
INSERT INTO ita1885_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Poi l'olocausto sarà scorticato, e tagliato a pezzi. ");
INSERT INTO ita1885_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","E i figliuoli del Sacerdote Aaronne metteranno il fuoco sopra l'Altare, e ordineranno le legne in sul fuoco. ");
INSERT INTO ita1885_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","E poi i figliuoli di Aaronne, sacerdoti, ordineranno que' pezzi, il capo, e la corata, sopra le legne, che saranno in sul fuoco, il qual sarà sopra l'Altare. ");
INSERT INTO ita1885_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Ma si laveranno l'interiora, e le gambe di quel bue. E il sacerdote farà ardere tutte queste cose sopra l'Altare, in olocausto, in offerta soave fatta per fuoco, di soave odore al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","E se l'offerta di esso per l'olocausto è del minuto bestiame, di pecore, o di capre, offerisca quell'animale maschio, senza difetto. ");
INSERT INTO ita1885_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","E scannisi dal lato settentrionale dell'Altare, davanti al Signore; e spandanne e figliuoli d'Aaronne, sacerdoti, il sangue sopra l'Altare, attorno attorno. ");
INSERT INTO ita1885_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Poi taglisi a pezzi, i quali, insieme con la testa, e la corata, il sacerdote metterà per ordine sopra le legne che saranno in sul fuoco, il qual sarà sopra l'Altare. ");
INSERT INTO ita1885_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Ma lavinsi le interiora, e le gambe, con acqua; e il sacerdote offerirà tutte queste cose, e le farà ardere sopra l'Altare. Quest' è un olocausto un'offerta fatta per fuoco, di soave odore al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","E se la sua offerta al Signore è olocausto di uccelli, offerisca la sua offerta di tortole, ovvero di pippioni. ");
INSERT INTO ita1885_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","E offerisca il sacerdote quell'olocausto sopra l'Altare; e, torcendogli il collo, gli spicchi il capo, e faccialo ardere sopra l'Altare; e spremasene il sangue all'un dei lati dell'Altare. ");
INSERT INTO ita1885_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Poi tolgasene il gozzo, e la piuma, e gittinsi quelle cose allato all'Altare, verso Oriente nel luogo delle ceneri. ");
INSERT INTO ita1885_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Poi fenda il sacerdote l'uccello per le sue ale, senza partirlo in due; e faccialo ardere sopra l'Altare, sopra le legne che saranno in sul fuoco. Quest'è un olocausto, un'offerta fatta per fuoco, di soave odore al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","E QUANDO alcuna persona offerirà offerta di panatica, sia la sua offerta fior di farina; e spanda sopra essa dell'olio, e mettavi sopra dell'incenso. ");
INSERT INTO ita1885_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","E portila a' figliuoli di Aaronne, sacerdoti; e prenda il sacerdote una piena menata del fior di farina, e dell'olio di essa, insieme con tutto il suo incenso; e faccia bruciar quelle cose, che son la ricordanza di quell'offerta, in su l'Altare. Questa è un'offerta fatta per fuoco, di soave odore al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","E sia il rimanente di quell'offerta, di Aaronne e de' suoi figliuoli; è cosa santissima, d'infra le offerte che si ardono al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","E quando tu offerirai, per offerta di panatica, alcuna cosa cotta al forno, offerisci focacce azzime di fior di farina, intrise con olio; o schiacciate azzime, unte con olio. ");
INSERT INTO ita1885_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","E se la tua offerta è di cose di panatica, cotte in su la teglia, sia di fior di farina, intrisa con olio, senza lievito. ");
INSERT INTO ita1885_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Spartiscila in pezzi, e spandi sopra essa dell'olio. Ella è offerta di panatica. ");
INSERT INTO ita1885_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","E se la tua offerta è di cose di panatica cotte nella padella, facciasi di fior di farina, con olio. ");
INSERT INTO ita1885_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","E porta al Signore quell'offerta che sarà fatta di quelle cose; e presentala al sacerdote, ed egli rechila in su l'Altare. ");
INSERT INTO ita1885_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","E levine il sacerdote la ricordanza di essa, e facciala bruciare in su l'Altare, in offerta fatta per fuoco, di soave odore al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","E sia il rimanente dell'offerta di Aaronne e de' suoi figliuoli; è cosa santissima, d'infra le offerte che si ardono al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Niuna offerta di panatica, che voi offerirete al Signore, non facciasi con lievito; perciocchè voi non dovete fare ardere alcun lievito, nè alcun miele, in offerta fatta per fuoco al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Ben potrete offerir quelle cose per offerta di primizie al Signore; ma non sieno poste in su l'Altare, per odor soave. ");
INSERT INTO ita1885_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","E sala ogni tua offerta di panatica con sale; e non lasciar venir meno il sale del patto del Signore d'in su le tue offerte; offerisci del sale sopra ogni tua offerta. ");
INSERT INTO ita1885_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","E se tu offerisci al Signore offerta di primizie di panatica, offerisci spighe fresche arrostite al fuoco; granelli sfregolati di fior di frumento, per offerta delle tue primizie. ");
INSERT INTO ita1885_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","E spandi sopra essa dell'olio e dell'incenso; ella è offerta di panatica. ");
INSERT INTO ita1885_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","E faccia il sacerdote bruciar la ricordanza di essa, insieme con tutto il suo incenso, in offerta fatta per fuoco al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","E SE l'offerta di alcuno è sacrificio da render grazie, s'egli l'offerisce del grosso bestiame, maschio o femmina che quella bestia sia, offeriscala senza difetto, nel cospetto del Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","E posi la mano in sul capo della sua offerta; e scannisi quella all'entrata del Tabernacolo della convenenza; e spandanne i figliuoli di Aaronne, sacerdoti, il sangue in su l'Altare, attorno attorno. ");
INSERT INTO ita1885_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Poi offerisca il sacerdote, del sacrificio da render grazie, ciò che si ha da ardere al Signore, cioè: il grasso che copre l'interiora, e tutto il grasso che è sopra l'interiora; ");
INSERT INTO ita1885_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","e i due arnioni, e il grasso che è sopra essi, e quello che è sopra i fianchi; e levi la rete che è sopra il fegato, insieme con gli arnioni. ");
INSERT INTO ita1885_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","E i figliuoli di Aaronne faccianla bruciare in su l'Altare, sopra l'olocausto che sarà sopra le legne, le quali saranno in sul fuoco; in offerta fatta per fuoco, di soave odore al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","E se l'offerta di alcuno, per sacrificio da render grazie al Signore, è del minuto bestiame, maschio o femmina, offeriscala senza difetto. ");
INSERT INTO ita1885_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","S'egli offerisce per sua offerta una pecora, offeriscala nel cospetto del Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","E posi la mano in sul capo della sua offerta; e scannisi quella all'entrata del Tabernacolo della convenenza; e spandanne i figliuoli di Aaronne il sangue in su l'Altare, attorno attorno. ");
INSERT INTO ita1885_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","E offerisca il sacerdote di quel sacrificio da render grazie, ciò che si ha da ardere al Signore, cioè: il grasso, e la coda intiera, la quale spicchisi appresso della schiena; e il grasso che copre l'interiora, e tutto il grasso che è sopra l'interiora; ");
INSERT INTO ita1885_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","e i due arnioni, e il grasso che è sopra essi, che è sopra i fianchi; e levi la rete che è sopra il fegato, insieme con gli arnioni. ");
INSERT INTO ita1885_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","E faccia il sacerdote bruciar quel grasso in su l'Altare, in cibo di offerta fatta per fuoco al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","E se l'offerta di alcuno è capra, offeriscala nel cospetto del Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","E posi la mano sopra il capo di essa, e scannisi davanti al Tabernacolo della convenenza; e spandanne i figliuoli di Aaronne il sangue in su l'Altare, attorno attorno. ");
INSERT INTO ita1885_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Poi offeriscane il sacerdote l'offerta che deve esser fatta per fuoco al Signore, cioè: il grasso che copre l'interiora, e tutto il grasso che è sopra l'interiora; ");
INSERT INTO ita1885_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","e i due arnioni, insieme col grasso che è sopra essi, che è sopra i fianchi; e levi la rete che è sopra il fegato, insieme con gli arnioni. ");
INSERT INTO ita1885_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","E faccia il sacerdote bruciar queste cose in su l'Altare, in cibo di offerta fatta per fuoco, di soave odore. Ogni grasso appartiene al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Questo sia uno statuto perpetuo, per le vostre generazioni, in tutte le vostre abitazioni. Non mangiate alcun sangue, nè alcun grasso. ");
INSERT INTO ita1885_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","IL Signore parlò ancora a Mosè, dicendo: Parla a' figliuoli d'Israele, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Quando alcuna persona avrà peccato per errore, e avrà fatta alcuna di tutte quelle cose che il Signore ha vietate di fare; ");
INSERT INTO ita1885_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","se il Sacerdote unto è quel che avrà peccato, onde il popolo sia renduto colpevole, offerisca al Signore per lo peccato suo, il quale egli avrà commesso, un giovenco senza difetto per sacrificio per lo peccato. ");
INSERT INTO ita1885_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","E adduca quel giovenco all'entrata del Tabernacolo della convenenza, davanti al Signore; e posi la mano in sul capo di esso, e scannisi nel cospetto del Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Poi prenda il Sacerdote unto, del sangue del giovenco, e portilo dentro al Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","E intinga il Sacerdote il dito in quel sangue sette volte nel cospetto del Signore, davanti alla Cortina del Santuario. ");
INSERT INTO ita1885_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","E metta il Sacerdote di quel sangue in su le corna dell'Altar de' profumi degli aromati, che è nel Tabernacolo della convenenza, nel cospetto del Signore; e spanda tutto il rimanente del sangue del giovenco appiè dell'Altar degli olocausti, che è all'entrata del Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","E levi dal giovenco del sacrificio per lo peccato tutto il grasso di esso; il grasso che copre l'interiora, e tutto il grasso che è sopra l'interiora; ");
INSERT INTO ita1885_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","e i due arnioni, e il grasso che è sopra essi, che è sopra i fianchi; levi parimente con gli arnioni la rete che è sopra il fegato; ");
INSERT INTO ita1885_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","come queste cose si levano dal bue del sacrificio da render grazie; e facciale il Sacerdote bruciare sopra l'Altar degli olocausti. ");
INSERT INTO ita1885_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Ma, quant'è alla pelle del giovenco, e tutta la sua carne, insieme col capo, e con le gambe, e le sue interiora, e il suo sterco, ");
INSERT INTO ita1885_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","e tutto il giovenco, portilo fuor del campo, in luogo mondo, dove si versano le ceneri; e brucilo col fuoco sopra delle legne; brucisi là dove si versano le ceneri. ");
INSERT INTO ita1885_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","E se tutta la raunanza d'Israele ha peccato per errore, senza ch'ella se ne sia avveduta; e ha fatta alcuna di tutte quelle cose che il Signore ha vietate di fare; onde sia caduta in colpa; ");
INSERT INTO ita1885_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","quando il peccato, ch'ella avrà commesso, sarà venuto a notizia, offerisca la raunanza un giovenco, per sacrificio per lo peccato, ed adducalo davanti al Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","E posino gli Anziani della raunanza le lor mani in sul capo di quel giovenco, nel cospetto del Signore; e scannisi quel giovenco davanti al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","E porti il Sacerdote unto, del sangue del giovenco, dentro al Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","E intinga il Sacerdote il dito in quel sangue, e spargane sette volte nel cospetto del Signore, davanti alla Cortina. ");
INSERT INTO ita1885_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","E metta di esso sangue sopra le corna dell'Altare, che è nel Tabernacolo della convenenza, davanti al Signore; e spanda tutto il rimanente del sangue, appiè dell'Altar degli olocausti, che è all'entrata del Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","E levi da quel giovenco tutto il grasso, e faccialo bruciar sopra l'Altare. ");
INSERT INTO ita1885_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","E faccia di questo giovenco come ha fatto dell'altro giovenco offerto per lo suo peccato. E così farà il purgamento del peccato della raunanza, e le sarà perdonato. ");
INSERT INTO ita1885_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Poi porti il giovenco fuor del campo, e brucilo, come ha bruciato il primo giovenco. Esso è sacrificio per lo peccato della raunanza. ");
INSERT INTO ita1885_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Se alcuno de' principali ha peccato, e ha, per errore, fatta alcuna di tutte quelle cose, che il Signore Iddio suo ha vietate di fare, onde sia caduto in colpa; ");
INSERT INTO ita1885_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","quando il suo peccato, ch'egli avrà commesso, gli sarà fatto conoscere, adduca, per la sua offerta, un becco, un maschio d'infra le capre, senza difetto. ");
INSERT INTO ita1885_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","E posi la mano sopra il capo di quel becco; e scannisi quello nel luogo dove si scannano gli olocausti, davanti al Signore. Esso è sacrificio per lo peccato. ");
INSERT INTO ita1885_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","E prenda il sacerdote del sangue di questo sacrificio per lo peccato, col dito, e mettalo sopra le corna dell'Altare degli olocausti; e spanda il rimanente del sangue di esso appiè dell'Altare degli olocausti. ");
INSERT INTO ita1885_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","E faccia bruciar tutto il grasso di quel becco sopra l'Altare, come il grasso del sacrificio da render grazie. E così il sacerdote farà il purgamento del peccato di esso, e gli sarà perdonato. ");
INSERT INTO ita1885_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","E se alcuno del comun popolo ha peccato per errore, e ha fatta alcuna delle cose che il Signore ha vietate di fare, onde sia caduto in colpa; ");
INSERT INTO ita1885_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","quando il suo peccato, ch'egli avrà commesso, gli sarà fatto conoscere, adduca, per la sua offerta, una femmina d'infra le capre, senza difetto, per sacrificio per lo suo peccato, che egli ha commesso. ");
INSERT INTO ita1885_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","E posi la mano in sul capo di quel sacrificio per lo peccato; e scannisi quello nel luogo degli olocausti. ");
INSERT INTO ita1885_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Poi prenda il sacerdote del sangue di esso col dito, e mettalo in su le corna dell'Altare degli olocausti, e spanda tutto il rimanente del sangue di esso appiè dell'Altare. ");
INSERT INTO ita1885_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","E levine tutto il grasso, come si leva il grasso del sacrificio da render grazie; e faccia il sacerdote bruciar quel grasso sopra l'Altare, in odor soave al Signore. E così il sacerdote farà il purgamento del peccato di esso, e gli sarà perdonato. ");
INSERT INTO ita1885_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","E se pur colui adduce una pecora per sua offerta, per sacrificio per lo peccato, adducala femmina, senza difetto. ");
INSERT INTO ita1885_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","E posi la mano in sul capo del sacrificio per lo peccato; e scannisi quel sacrificio per lo peccato, nel luogo dove si scannano gli olocausti dell'Altare. ");
INSERT INTO ita1885_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","E levine tutto il grasso, ");
INSERT INTO ita1885_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Poi prenda il sacerdote del sangue di quel sacrificio per lo peccato, col dito, e mettalo sopra le corna dell'Altare degli olocausti, e spanda tutto il rimanente del sangue di esso appiè come si leva il grasso della pecora del sacrificio da render grazie; e faccia il sacerdote bruciar quei grassi in su l'Altare, sopra le offerte che si fanno per fuoco al Signore. E così il sacerdote farà il purgamento del peccato di esso, il quale egli avrà commesso, e gli sarà perdonato. ");
INSERT INTO ita1885_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","E QUANDO alcuno avrà peccato, perciocchè avrà udita la voce di una dinunziazione con giuramento di alcuna cosa, onde egli sia testimonio (o che l'abbia veduta, o che l'abbia altramente saputa), e non l'avrà dichiarata; egli porterà la sua iniquità. ");
INSERT INTO ita1885_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Parimente, quando alcuno avrà toccata alcuna cosa immonda, carogna di fiera immonda, o carogna di animal domestico immondo, o carogna di rettile immondo; avvenga ch'egli l'abbia fatto per ignoranza, pure è immondo, e colpevole. ");
INSERT INTO ita1885_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Così, quando egli avrà toccata alcuna immondizia dell'uomo, secondo ogni sua immondizia, per la quale egli è contaminato, benchè egli non l'abbia fatto saputamente, se viene a saperlo, egli è colpevole. ");
INSERT INTO ita1885_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Similmente, quando alcuno avrà giurato, profferendo leggermente con le sue labbra di voler male o ben fare, secondo tutte le cose che gli uomini sogliono profferir leggermente con giuramento; ed egli non ne ha più conoscenza; se viene a saperlo, egli è colpevole in una di queste maniere. ");
INSERT INTO ita1885_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Quando adunque alcuno sarà colpevole in una di queste maniere, faccia la confession del peccato ch'egli avrà commesso. ");
INSERT INTO ita1885_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","E adduca al Signore il sacrificio per la sua colpa, per lo peccato ch'egli avrà commesso, cioè: una femmina del minuto bestiame, o pecora, o capra, per lo peccato. E faccia il sacerdote il purgamento del peccato di esso. ");
INSERT INTO ita1885_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","E se pur la possibilità di colui non potrà fornire una pecora, o una capra, adduca al Signore, per sacrificio per la sua colpa, in ciò che avrà peccato, due tortole, o due pippioni; l'uno per sacrificio per lo peccato, e l'altro per olocausto. ");
INSERT INTO ita1885_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","E portili al sacerdote; ed esso offerisca imprima quello che sarà per lo peccato, e torcendogli il collo, gli spicchi il capo appresso al collo, senza però spartirlo in due. ");
INSERT INTO ita1885_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Poi sparga del sangue del sacrificio per lo peccato sopra una delle pareti dell'Altare, e spremasi il rimanente del sangue appiè dell'Altare. Esso è sacrificio per lo peccato. ");
INSERT INTO ita1885_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","E dell'altro facciane olocausto, secondo ch'è ordinato. E così il sacerdote farà il purgamento del peccato che colui avrà commesso, e gli sarà perdonato. ");
INSERT INTO ita1885_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","E se colui non può fornire pur due tortole, o due pippioni, porti per sua offerta, per ciò ch'egli avrà peccato, la decima parte d'un efa di fior di farina, per offerta per lo peccato; non mettavi sopra nè olio, nè incenso; perciocchè è un'offerta per lo peccato. ");
INSERT INTO ita1885_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Porti adunque quella farina al sacerdote, e prendane il sacerdote una menata piena per la ricordanza di quella; e facciala bruciar sopra l'Altare, in su l'offerte fatte per fuoco al Signore. Ella è un'offerta per lo peccato. ");
INSERT INTO ita1885_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","E così il sacerdote farà il purgamento per esso del peccato che egli avrà commesso in una di quelle maniere, e gli sarà perdonato. E sia il rimanente di quella farina del sacerdote, come l'offerta di panatica. ");
INSERT INTO ita1885_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Il Signore parlò, oltre a ciò, a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Quando alcuno avrà misfatto, e peccato per errore, prendendo delle cose consacrate al Signore, adduca al Signore, per sacrificio per la sua colpa, un montone senza difetto, del prezzo di tanti sicli d'argento, a siclo di Santuario, che tu l'avrai tassato per la colpa. ");
INSERT INTO ita1885_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","E restituisca ciò in che egli avrà peccato, prendendo delle cose consacrate, e sopraggiungavi il quinto, e dialo al sacerdote; e faccia il sacerdote, con quel montone del sacrificio per la colpa, il purgamento del peccato di esso; e gli sarà perdonato. ");
INSERT INTO ita1885_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","In somma, quando una persona avrà peccato, e avrà fatta alcuna di tutte quelle cose che il Signore ha vietate di fare, benchè egli non l'abbia fatto saputamente, pure è colpevole; e deve portar la sua iniquità. ");
INSERT INTO ita1885_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Adduca adunque al sacerdote un montone del prezzo che tu l'avrai tassato per la colpa; e faccia il sacerdote il purgamento dell'errore ch'egli avrà commesso per ignoranza; e gli sarà perdonato. ");
INSERT INTO ita1885_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ciò è colpa; egli del tutto si è renduto colpevole inverso il Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Il Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Quando alcuno avrà peccato, e commesso misfatto contro al Signore, avendo mentito al suo prossimo intorno a deposito, o a roba rimessagli nelle mani, o a cosa rapita; ovvero, avendo fatta fraude al suo prossimo; ");
INSERT INTO ita1885_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ovvero anche, avendo trovata alcuna cosa perduta, e avendo mentito intorno ad essa, e giurato falsamente; e in qualunque altra cosa, di tutte quelle, le quali l'uomo suol fare, peccando in esse; ");
INSERT INTO ita1885_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","quando adunque alcuno avrà peccato, e sarà caduto in colpa, restituisca la cosa ch'egli avrà rapita o fraudata; o il deposito che gli sarà stato dato in guardia, o la cosa perduta che egli avrà trovata. ");
INSERT INTO ita1885_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Ovvero qualunque altra cosa, della quale egli abbia giurato falsamente; restituiscane il capitale, e sopraggiungavi il quinto; e dialo a colui al quale appartiene, nel giorno stesso del sacrificio per la sua colpa. ");
INSERT INTO ita1885_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","E adduca al Signore, per sacrificio per la sua colpa, un montone senza difetto, del prezzo che tu l'avrai tassato per la colpa; e menilo al sacerdote. ");
INSERT INTO ita1885_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","E faccia il sacerdote il purgamento per esso, nel cospetto del Signore, e gli sarà perdonato; qualunque cosa egli abbia fatta di tutte quelle, le quali si soglion fare, onde l'uomo cade in colpa. ");
INSERT INTO ita1885_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","IL Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Comanda ad Aaronne e ai suoi figliuoli, dicendo: Quest'è la legge dell'olocausto: Stia esso olocausto sopra il fuoco acceso che sarà sopra l'Altare, tutta la notte, fino alla mattina; e arda il fuoco dell'Altare sopra esso del continuo. ");
INSERT INTO ita1885_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","E vestasi il sacerdote il suo vestimento di lino, e vesta la sua carne delle mutande line; e levi le ceneri, nelle quali il fuoco avrà ridotto l'olocausto, consumandolo sopra l'Altare; e mettale allato all'Altare. ");
INSERT INTO ita1885_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Poi spogli i suoi vestimenti, e vestane degli altri, e porti la cenere fuor del campo in luogo mondo. ");
INSERT INTO ita1885_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","E sia il fuoco che sarà sopra l'Altare, tenuto del continuo acceso in esso; non lascisi giammai spegnere; e accenda il sacerdote ogni mattina delle legne sopra esso, e dispongavi gli olocausti sopra, e bruci sopra esso i grassi de' sacrificii da render grazie. ");
INSERT INTO ita1885_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Arda il fuoco del continuo sopra l'Altare; non lascisi giammai spegnere. ");
INSERT INTO ita1885_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Ora, quest'è la legge dell'offerta di panatica. Offeriscala uno de' figliuoli di Aaronne, nel cospetto del Signore, davanti all'Altare. ");
INSERT INTO ita1885_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","E levine una menata del fior di farina, e dell'olio di essa offerta, insieme con tutto, l'incenso che sarà sopra l'offerta, e faccia bruciar sopra l'Altare la ricordanza di essa, in odor soave, al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","E mangino Aaronne e i suoi figliuoli il rimanente di essa; mangisi in azzimi, in luogo sacro, nel Cortile del Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Non cuocasi con lievito; io l'ho data loro per lor parte dell'offerte che mi son fatte per fuoco. E cosa santissima, come il sacrificio per lo peccato, e per la colpa. ");
INSERT INTO ita1885_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Ogni maschio, d'infra i figliuoli di Aaronne, può mangiare quello, per istatuto perpetuo, per le vostre età, dell'offerte che si fanno per fuoco al Signore. Chiunque toccherà quelle cose sia santo. ");
INSERT INTO ita1885_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Il Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Quest'è l'offerta, che Aaronne e i suoi figliuoli hanno sempre da offerire al Signore, nel giorno che alcun di loro sarà unto, cioè: un'offerta di panatica d'un decimo d'un efa di fior di farina, per offerta perpetua; la metà la mattina, e l'altra metà la sera. ");
INSERT INTO ita1885_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Apparecchisi con olio in su la teglia; portala così cotta in su la teglia; e offerisci, per soave odore al Signore, quella offerta cotta in pezzi. ");
INSERT INTO ita1885_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","E faccia il Sacerdote, che sarà unto in luogo di Aaronne, d'infra i suoi figliuoli, quella offerta per istatuto perpetuo; brucisi tutta intera al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","E, generalmente, ogni offerta di panatica del Sacerdote brucisi interamente; non mangisene nulla. ");
INSERT INTO ita1885_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Il Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Parla ad Aaronne e a' suoi figliuoli, dicendo: Quest'è la legge del sacrificio per lo peccato: Scannisi il sacrificio per lo peccato davanti al Signore, nell'istesso luogo dove si scannano gli olocausti; è cosa santissima. ");
INSERT INTO ita1885_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Mangilo il sacerdote che farà quel sacrificio per lo peccato; mangisi in luogo santo, nel Cortile del Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Chiunque toccherà la carne di esso sia santo; e se sprizza del sangue di esso sopra alcun vestimento, lavisi quello sopra che sarà sprizzato, in luogo santo. ");
INSERT INTO ita1885_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","E spezzisi il vaso di terra, nel quel sarà stato cotto; che se pure è stato cotto in un vaso di rame, strebbisi quello, e sciacquisi con acqua. ");
INSERT INTO ita1885_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Ogni maschio d'infra i sacerdoti ne potrà mangiare; è cosa santissima. ");
INSERT INTO ita1885_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Ma non mangisi di alcun sacrificio per lo peccato, del cui sangue si deve portar nel Tabernacolo della convenenza, per far purgamento di peccato, nel Santuario; brucisi col fuoco. ");
INSERT INTO ita1885_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Or quest'è la legge del sacrificio per la colpa; è cosa santissima: ");
INSERT INTO ita1885_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Scannisi il sacrificio per la colpa nello stesso luogo dove si scannano gli olocausti; e spargasene il sangue sopra l'Altare, attorno attorno. ");
INSERT INTO ita1885_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","E offeriscasene tutto il grasso, la coda, e il grasso che copre l'interiora; ");
INSERT INTO ita1885_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","e i due arnioni, e il grasso che è sopra essi, che è sopra i fianchi; e levisi la rete che è in sul fegato, insieme co' due arnioni. ");
INSERT INTO ita1885_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","E faccia il sacerdote bruciar quelle cose sopra l'Altare, per offerta fatta per fuoco al Signore; è sacrificio per la colpa. ");
INSERT INTO ita1885_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Ogni maschio d'intra i sacerdoti ne potrà mangiare; mangisi in luogo santo: è cosa santissima. ");
INSERT INTO ita1885_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Facciasi al sacrificio per la colpa, come al sacrificio per lo peccato; siavi una stessa legge per l'uno e per l'altro; sia quel sacrificio del sacerdote, il qual con esso avrà fatto il purgamento del peccato. ");
INSERT INTO ita1885_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Parimente abbia per sè il sacerdote, che avrà offerto l'olocausto di alcuno, la pelle dell'olocausto ch'egli avrà offerto. ");
INSERT INTO ita1885_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Così ancora ogni offerta di panatica che si cuocerà al forno, o si apparecchierà nella padella, o in su la teglia sia del sacerdote che l'offerirà. ");
INSERT INTO ita1885_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Ma ogni offerta di panatica, intrisa con olio, o asciutta, sia di tutti i figliuoli di Aaronne indifferentemente. ");
INSERT INTO ita1885_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","E quest'è la legge del sacrificio da render grazie, che si offerirà al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Se alcuno l'offerisce per sacrificio di laude, offerisca, oltre ad esso sacrificio di laude, delle focacce azzime, intrise con olio, e delle schiacciate azzime, unte con olio; e del fior di farina, cotta in su la teglia, in focacce intrise con olio. ");
INSERT INTO ita1885_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Offerisca ancora per sua offerta, oltre a quelle focacce, del pan lievitato, insieme col suo sacrificio di laude, da render grazie. ");
INSERT INTO ita1885_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","E di quel pane lievitato, presentine uno di tutta l'offerta, in offerta elevata al Signore; ed esso sia del sacerdote che avrà sparso il sangue del sacrificio da render grazie. ");
INSERT INTO ita1885_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","E mangisi la carne del suo sacrificio di laude da render grazie, nel giorno stesso ch'egli avrà fatta la sua offerta; non lascisene nulla di avanzo fino alla mattina. ");
INSERT INTO ita1885_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","E se il sacrificio ch'egli offerirà è votato, o volontario, mangisi nel giorno stesso ch'egli l'avrà offerto; e se ne rimane alcuna cosa, mangisi il giorno seguente. ");
INSERT INTO ita1885_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","E brucisi col fuoco quello che sarà rimasto della carne di esso sacrificio fino al terzo giorno. ");
INSERT INTO ita1885_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","E se pure al terzo giorno si mangia della carne del sacrificio di colui da render grazie, colui che l'avrà offerto non sarà gradito; quello non gli sarà imputato; sarà fracidume; e la persona che ne avrà mangiato porterà la sua iniquità. ");
INSERT INTO ita1885_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","E di questa carne ciò che avrà toccata qualunque cosa immonda, non mangisi; brucisi col fuoco; quant'è a questa carne, mangine chiunque è mondo. ");
INSERT INTO ita1885_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Ma la persona che avrà mangiata della carne del sacrificio da render grazie, offerto al Signore, avendo la sua immondizia addosso, sia ricisa da' suoi popoli. ");
INSERT INTO ita1885_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Parimente la persona, la quale, avendo toccata qualunque cosa immonda, come immondizia d'uomo, o alcun animale immondo, o alcun rettile immondo, mangerà della carne del sacrificio da render grazie, offerta al Signore, sia ricisa da' suoi popoli. ");
INSERT INTO ita1885_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Il Signore parlò ancora a Mosè, dicendo: Parla a' figliuoli d'Israele, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Non mangiate alcun grasso, nè di bue, nè di pecora, nè di capra. ");
INSERT INTO ita1885_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Ben potrassi adoperare in qualunque altro uso il grasso di una bestia morta da sè, o il grasso di una bestia lacerata dalle fiere; ma non mangiatelo per niuna maniera. ");
INSERT INTO ita1885_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Perciocchè, se alcuno mangia del grasso di alcun animale, del quale si offerisce sacrificio fatto per fuoco al Signore, la persona che ne mangerà sarà ricisa da' suoi popoli. ");
INSERT INTO ita1885_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Parimente, non mangiate, in niuna delle vostre abitazioni, alcun sangue, nè di uccelli, nè di bestie. ");
INSERT INTO ita1885_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Qualunque persona avrà mangiato alcun sangue, sia ricisa da' suoi popoli. ");
INSERT INTO ita1885_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Il Signore parlò, oltre a ciò, a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Parla a' figliuoli d'Israele, dicendo: Se alcuno offerisce al Signore un suo sacrificio da render grazie, porti egli stesso al Signore la sua offerta del sacrificio da render grazie. ");
INSERT INTO ita1885_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Portino le sue mani stesse quelle cose che si hanno da ardere al Signore; porti il grasso, insieme col petto; il petto, per esser dimenato per offerta dimenata, nel cospetto del Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","E faccia il sacerdote bruciare il grasso sopra l'Altare; e il petto sia di Aaronne e de' suoi figliuoli. ");
INSERT INTO ita1885_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Date ancora al sacerdote, per offerta elevata, la spalla destra de' vostri sacrificii da render grazie. ");
INSERT INTO ita1885_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Sia quella spalla destra di colui de' figliuoli di Aaronne che avrà offerto il sangue, e il grasso de' sacrificii da render grazie, per sua parte. ");
INSERT INTO ita1885_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Perciocchè io ho preso dai figliuoli d'Israele il petto dell'offerta dimenata, e la spalla dell'offerta elevata, de' lor sacrificii da render grazie; e ho date al Sacerdote Aaronne, e a' suoi figliuoli, per istatuto perpetuo, quelle cose che si devono prendere da' figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Quest'è il diritto dell' Unzione di Aaronne, e dell'Unzione dei figliuoli suoi, che si deve torre dell'offerte fatte per fuoco al Signore, il quale è stato loro assegnato nel giorno che il Signore li ha fatti accostare, per esercitargli il sacerdozio. ");
INSERT INTO ita1885_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Il quale il Signore ha comandato che sia loro dato da' figliuoli d'Israele, nel giorno che li ha unti, per istatuto perpetuo, per le lor generazioni. ");
INSERT INTO ita1885_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Quest'è la legge dell'olocausto, dell'offerta di panatica, e del sacrificio per lo peccato, e del sacrificio per la colpa, e del sacrificio delle consacrazioni, e del sacrificio da render grazie; ");
INSERT INTO ita1885_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","la quale il Signore diede a Mosè, in sul monte di Sinai, nel giorno ch'egli comandò nel deserto di Sinai, a' figliuoli d'Israele, d'offerir le loro offerte al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","IL Signore parlò, oltre a ciò, a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Prendi Aaronne, e i suoi figliuoli con lui; e i vestimenti, e l'olio dell'Unzione, e il giovenco per lo sacrificio per lo peccato, e i due montoni, e il paniere degli azzimi. ");
INSERT INTO ita1885_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","E aduna tutta la raunanza, all'entrata del Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","E Mosè fece come il Signore gli avea comandato; e la raunanza fu adunata all'entrata del Tabernacolo della convenza. ");
INSERT INTO ita1885_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","E Mosè disse alla raunanza: Quest'è quello che il Signore ha comandato che si faccia. ");
INSERT INTO ita1885_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","E Mosè fece accostare Aaronne e i suoi figliuoli, e li lavò con acqua. ");
INSERT INTO ita1885_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Poi mise indosso ad Aaronne la Tonica, e lo cinse con la Cintura; poi lo vestì del Manto, e gli mise l'Efod addosso, e lo cinse col fregio lavorato dell'Efod; e così con quello gli serrò le vesti addosso. ");
INSERT INTO ita1885_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Poi mise sopra lui il Pettorale, nel quale pose Urim e Tummim. ");
INSERT INTO ita1885_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Poi gli mise in capo la Benda; sopra la quale, in su la parte anteriore di essa, mise la lama d'oro, il Diadema di santità; come il Signore avea comandato a Mosè. ");
INSERT INTO ita1885_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Poi Mosè prese l'olio dell'Unzione, e unse il Tabernacolo, e tutte le cose che erano in esso; e le consacrò. ");
INSERT INTO ita1885_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","E ne spruzzò l'Altare per sette volte, e unse l'Altare, e tutti i suoi strumenti; e la Conca, e il suo piede; per consacrar quelle cose. ");
INSERT INTO ita1885_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Poi versò dell'olio dell'Unzione in sul capo di Aaronne; e l'unse, per consacrarlo. ");
INSERT INTO ita1885_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Poi Mosè fece accostare i figliuoli di Aaronne e li vestì delle toniche, e li cinse con le cinture, e allacciò loro le mitrie; come il Signore gli avea comandato. ");
INSERT INTO ita1885_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Appresso fece accostare il giovenco del sacrificio per lo peccato; e Aaronne e i suoi figliuoli posarono le mani in sul capo del giovenco del sacrificio per lo peccato. ");
INSERT INTO ita1885_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Poi Mosè lo scannò, e ne prese del sangue, e lo mise col dito in su le corna dell'Altare, attorno attorno, e purgò l'Altare; e versò il rimanente del sangue appiè dell'Altare; e così consacrò l'Altare, per far purgamento del peccato sopra esso. ");
INSERT INTO ita1885_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Appresso prese tutto il grasso ch'era sopra l'interiora, e la rete del fegato, e i due arnioni, col grasso loro; e Mosè fece bruciar quelle cose sopra l'Altare. ");
INSERT INTO ita1885_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Ma bruciò col fuoco fuor del campo il giovenco, e la sua pelle, e la sua carne, e il suo sterco; come il Signore gli avea comandato. ");
INSERT INTO ita1885_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Poi fece appressare il montone dell'olocausto; e Aaronne e i suoi figliuoli posarono le mani in sul capo del montone. ");
INSERT INTO ita1885_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","E Mosè lo scannò, e ne sparse il sangue sopra l'Altare, attorno attorno. ");
INSERT INTO ita1885_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Poi tagliò il montone a pezzi; e fece bruciare il capo, e i pezzi, e la corata. ");
INSERT INTO ita1885_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","E lavò con acqua l'interiora, e le gambe; e così fece bruciar tutto quel montone sopra l'Altare; come olocausto di soave odore, e offerta fatta per fuoco al Signore; come il Signore gli avea comandato. ");
INSERT INTO ita1885_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Poi fece appressare il secondo montone, il montone delle consacrazioni; e Aaronne e i suoi figliuoli posarono le mani in sul capo di esso. ");
INSERT INTO ita1885_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","E Mosè lo scannò, e ne prese del sangue, e lo mise in sul tenerume dell'orecchia destra di Aaronne, e sopra il dito grosso della man destra di esso, e sopra il dito grosso del suo piè destro. ");
INSERT INTO ita1885_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Poi fece appressare i figliuoli di Aaronne, e pose di quel sangue in sul tenerume della loro orecchia destra, e sopra il dito grosso della lor mano destra, e sopra il dito grosso del lor piè destro; e sparse il rimanente di quel sangue in su l'Altare, attorno attorno. ");
INSERT INTO ita1885_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Poi prese il grasso, e la coda, e tutto il grasso ch'era sopra l'interiora, e la rete del fegato, e i due arnioni, col grasso loro, e la spalla destra. ");
INSERT INTO ita1885_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","E del paniere degli azzimi, ch'era davanti al Signore, prese una focaccia azzima, e una focaccia di pane fatta con olio, e una schiacciata; e pose quelle sopra que' grassi, e sopra la spalla destra. ");
INSERT INTO ita1885_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Poi mise tutte quelle cose in su le palme delle mani di Aaronne, e in su le palme delle mani de' suoi figliuoli; e le fece dimenare per offerta dimenata, nel cospetto del Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Poi Mosè prese quelle cose d'in su le lor mani, e le fece bruciare sopra l'Altare, sopra l'olocausto; come offerte di consacrazioni, di odor soave, offerta fatta per fuoco al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Poi Mosè prese il petto di quel montone, e lo dimenò per offerta dimenata, nel cospetto del Signore; e Mosè ebbe quello per la sua parte del montone delle consacrazioni; come il Signore gli avea comandato. ");
INSERT INTO ita1885_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Oltre a ciò, Mosè prese dell'olio dell'Unzione, e del sangue ch'era sopra l'Altare, e ne spruzzò Aaronne e i suoi vestimenti; e i figliuoli di esso, e i lor vestimenti; e così consacrò Aaronne e i suoi vestimenti; e i suoi figliuoli, e i vestimenti de' suoi figliuoli. ");
INSERT INTO ita1885_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","E Mosè disse ad Aaronne e a' suoi figliuoli: Fate cuocere cotesta carne all'entrata del Tabernacolo della convenenza, e quivi mangiatela; insieme col pane ch'è nel paniere dell'offerta delle consacrazioni; come mi è stato comandato, dicendo: Mangino Aaronne e i suoi figliuoli quelle cose. ");
INSERT INTO ita1885_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","E bruciate col fuoco ciò che rimarrà della carne e del pane. ");
INSERT INTO ita1885_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","E non vi dipartite dall'entrata del Tabernacolo della convenenza, per sette giorni; finchè non sieno compiuti i giorni delle vostre consacrazioni; conciossiachè abbiate ad esser consacrati nel vostro ufficio per lo spazio di sette giorni. ");
INSERT INTO ita1885_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Come si è oggi fatto, così avea il Signore comandato che si facesse, per far purgamento de' vostri peccati. ");
INSERT INTO ita1885_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Dimorate adunque all'entrata del Tabernacolo della convenenza per sette giorni, dì e notte; e osservate ciò che il Signore ha comandato che si osservi; acciocchè non muoiate: perciocchè così mi è stato comandato. ");
INSERT INTO ita1885_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","E Aaronne e i suoi figliuoli fecero tutte le cose che il Signore avea comandate per Mosè. ");
INSERT INTO ita1885_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","E L'OTTAVO giorno appresso, Mosè chiamò Aaronne e i suoi figliuoli, e gli Anziani d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","E disse ad Aaronne: Prenditi un vitello per sacrificio per lo peccato, e un montone per olocausto; amendue senza difetto; e presentali davanti al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","E parla a' figliuoli d'Israele, dicendo; Prendete un becco per sacrificio per lo peccato, e un vitello, e un agnello, amendue di un anno, senza difetto, per olocausto; ");
INSERT INTO ita1885_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","e un bue, e un montone, per sacrificio da render grazie, per sacrificarli davanti al Signore; e una offerta di panatica intrisa con olio; perchè oggi il Signore vi apparirà. ");
INSERT INTO ita1885_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Essi adunque presero le cose che Mosè avea comandate, e le addussero davanti al Tabernacolo della convenenza; e tutta la raunanza si accostò, e stette in piè davanti al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","E Mosè disse: Fate questo che il Signore ha comandato; e la gloria del Signore v'apparirà. ");
INSERT INTO ita1885_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","E Mosè disse ad Aaronne: Accostati all'Altare, e fa' il tuo sacrificio per lo peccato, e il tuo olocausto; e fa' il purgamento de' tuoi peccati, e di que' del popolo; offerisci eziandio l'offerta del popolo, e fa' il purgamento de lor peccati; come il Signore ha comandato. ");
INSERT INTO ita1885_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Aaronne adunque si accostò all'Altare, e scannò il vitello del sacrificio per lo peccato ch'era per lui. ");
INSERT INTO ita1885_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","E i suoi figliuoli gli porsero il sangue; ed egli intinse il dito nel sangue, e lo mise in su le corna dell'Altare; e sparse il rimanente del sangue appiè dell'Altare. ");
INSERT INTO ita1885_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","E fece bruciare il grasso, e gli arnioni, e la rete del fegato, del sacrificio per lo peccato, sopra l'Altare; come il Signore avea comandato a Mosè. ");
INSERT INTO ita1885_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Ma bruciò col fuoco la carne, e la pelle, fuor del campo. ");
INSERT INTO ita1885_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Poi scannò l'olocausto, e i suoi figliuoli gliene porsero il sangue, ed egli lo sparse in su l'Altare, attorno attorno. ");
INSERT INTO ita1885_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Gli porsero eziandio l'olocausto tagliato a pezzi, insieme col capo; ed egli lo fece bruciar sopra l'Altare. ");
INSERT INTO ita1885_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","E lavò l'interiora, e le gambe; e le bruciò sopra l'olocausto, sopra l'Altare. ");
INSERT INTO ita1885_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Poi offerse l'offerta del popolo; e prese il becco del sacrificio del popolo per lo peccato, e l'offerse per sacrificio per lo peccato, come il vitello precedente. ");
INSERT INTO ita1885_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Poi offerse l'olocausto; e ne fece come era ordinato. ");
INSERT INTO ita1885_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Poi offerse l'offerta di panatica; e n'empiè la palma della sua mano, e la fece bruciar sopra l'Altare; oltre all'olocausto della mattina. ");
INSERT INTO ita1885_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Appresso scannò il bue, e il montone del sacrificio del popolo da render grazie; e i suoi figliuoli gliene porsero il sangue, ed egli lo sparse in su l'Altare, attorno attorno. ");
INSERT INTO ita1885_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Gli porsero eziandio i grassi del bue; e del montone la coda, e il grasso che copre l'interiora, e gli arnioni, e la rete del fegato. ");
INSERT INTO ita1885_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","E posero i grassi in su i petti; ed Aaronne fece bruciar que' grassi sopra l'Altare. ");
INSERT INTO ita1885_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","E dimenò, per offerta dimenata, que' petti, e quella spalla destra davanti al Signore, come Mosè avea comandato. ");
INSERT INTO ita1885_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Poi Aaronne alzò le mani verso il popolo, e lo benedisse; e, dopo che ebbe fatto il sacrificio per lo peccato, l'olocausto, e i sacrificii da render grazie, scese giù. ");
INSERT INTO ita1885_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Or Mosè ed Aaronne erano entrati nel Tabernacolo della convenenza; poi, essendone usciti, aveano benedetto il popolo; e la gloria del Signore era apparita a tutto il popolo. ");
INSERT INTO ita1885_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","E un fuoco era uscito dal cospetto del Signore, e avea consumato l'olocausto, ed i grassi, sopra l'Altare. E tutto il popolo lo vide, e diede grida di allegrezza, e si gittò in terra sopra la sua faccia. ");
INSERT INTO ita1885_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","OR Nadab ed Abihu, figliuoli di Aaronne, presero ciascuno il suo turibolo, e vi posero dentro del fuoco, e vi misero su dell'incenso; e presentarono davanti al Signore del fuoco strano; il che egli non avea lor comandato. ");
INSERT INTO ita1885_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","E un fuoco uscì dal cospetto del Signore, il quale li divampò; ed essi morirono davanti al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","E Mosè disse ad Aaronne: Quest'è pur quello che il Signore ha pronunziato, dicendo: Io sarò santificato ne' miei più prossimi; e sarò glorificato in presenza di tutto il popolo. E Aaronne tacque. ");
INSERT INTO ita1885_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","E Mosè chiamò Misael ed Elsafan, figliuoli di Uzziel, zio di Aaronne, e disse loro: Accostatevi; portatene i vostri fratelli d'innanzi al Santuario fuor del campo. ");
INSERT INTO ita1885_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ed essi si accostarono, e li portarono via con le lor toniche, fuor del campo; come Mosè avea detto. ");
INSERT INTO ita1885_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","E Mosè disse ad Aaronne, e a Eleazar, e a Itamar, suoi figliuoli: Non andate a capo scoperto, e non vi sdrucite i vestimenti; acciocchè non muoiate, e ch'egli non si adiri contro a tutta la raunanza; ma piangano i vostri fratelli, tutta la casa d'Israele, l'arsione che il Signore ha fatta. ");
INSERT INTO ita1885_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","E non vi dipartite dall'entrata del Tabernacolo della convenenza, che talora non muoiate; perciocchè l'olio dell'Unzione del Signore è sopra voi. Ed essi fecero secondo la parola di Mosè. ");
INSERT INTO ita1885_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","E IL Signore parlò ad Aaronne, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Non ber vino, nè cervogia, nè tu, nè i tuoi figliuoli, quando avrete ad entrar nel Tabernacolo della convenenza; acciocchè non muoiate. Sia questo uno statuto perpetuo per le vostre generazioni. ");
INSERT INTO ita1885_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","E ciò per poter discernere tra la cosa santa e la profana; e tra la cosa immonda e la monda; ");
INSERT INTO ita1885_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","e per insegnare a' figliuoli d'Israele tutti gli statuti che il Signore ha loro dati per Mosè. ");
INSERT INTO ita1885_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Poi Mosè parlò ad Aaronne, e a Eleazar, e a Itamar, suoi figliuoli, ch'erano rimasti, dicendo: Pigliate l'offerta di panatica ch'è rimasta dell'offerte fatte per fuoco al Signore, e mangiatela in pani azzimi appresso all'Altare; conciossiachè sia cosa santissima. ");
INSERT INTO ita1885_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Mangiatela adunque in luogo santo; perciocchè è la parte ordinata per te, e per i tuoi figliuoli, delle offerte che si fanno per fuoco al Signore; perciocchè così mi è stato comandato. ");
INSERT INTO ita1885_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Mangiate ancora il petto dell'offerta dimenata, e la spalla dell'offerta elevata, in luogo mondo, tu, e i tuoi figliuoli, e le tue figliuole, teco; perciocchè quelle sono state date a te, ed ai tuoi figliuoli, per parte vostra de' sacrificii da render grazie de' figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Portino essi la spalla dell'offerta elevata, e il petto dell'offerta dimenata, insieme co' grassi che si hanno da ardere, acciocchè quelle cose sieno dimenate davanti al Signore, per offerta dimenata; e sieno di te, e de' tuoi figliuoli teco, per istatuto perpetuo; come il Signore ha comandato. ");
INSERT INTO ita1885_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Or Mosè cercò, e ricercò il becco del sacrificio per lo peccato; ed ecco, egli era stato bruciato; laonde si adirò gravemente contro ad Eleazar, e contro ad Itamar, figliuoli di Aaronne, ch'erano rimasti, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Perchè non avete voi mangiato il sacrificio per lo peccato nel luogo santo? conciossiachè sia cosa santissima, e che il Signore ve l'abbia dato per portar l'iniquità della raunanza, per far purgamento de' peccati di essa, nel cospetto del Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Ecco, il sangue di esso non è stato portato dentro al Santuario; per l'innanzi adunque del tutto mangiatelo nel luogo santo, come io ho comandato. ");
INSERT INTO ita1885_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","E Aaronne disse a Mosè: Ecco, essi hanno oggi offerto il loro sacrificio per lo peccato, e il loro olocausto, davanti al Signore; e cotali cose mi sono avvenute; se dunque io avessi oggi mangiato del sacrificio per lo peccato, sarebbe ciò piaciuto al Signore? ");
INSERT INTO ita1885_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","E, quando Mosè ebbe udito questo, fu contento. ");
INSERT INTO ita1885_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","POI il Signore parlò a Mosè e ad Aaronne, dicendo loro: ");
INSERT INTO ita1885_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Parlate a' figliuoli d'Israele, dicendo: Questi son gli animali, de' quali voi potrete mangiare, d'infra tutte le bestie che son sopra la terra. ");
INSERT INTO ita1885_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","D'infra le bestie a quattro piedi, voi potrete mangiar di tutte quelle bestie che hanno il piè forcuto, e l'unghia spartita in due, e che ruminano. ");
INSERT INTO ita1885_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Ma, fra quelle che hanno il piè forcuto, o che ruminano, non mangiate di queste: del cammello; conciossiachè egli rumini, ma non abbia il piè forcuto; siavi immondo; ");
INSERT INTO ita1885_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","nè del coniglio; conciossiachè egli rumini, ma non abbia il piè forcuto; siavi immondo; ");
INSERT INTO ita1885_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","nè della lepre; conciossiachè ella rumini, ma non abbia il piè forcuto; siavi immonda; ");
INSERT INTO ita1885_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","nè del porco; conciossiachè egli abbia il piè forcuto, e spartito in due, ma non rumini; siavi immondo. ");
INSERT INTO ita1885_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Non mangiate della carne loro, e non toccate le lor carogne; sienvi immonde. ");
INSERT INTO ita1885_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Voi potrete mangiar di queste specie d'infra tutti gli animali acquatici, cioè: di tutti quelli che hanno pennette, e scaglie, nell'acque, così ne' mari, come nei fiumi. ");
INSERT INTO ita1885_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Ma siavi in abbominazione tutto ciò che non ha pennette, nè scaglie, così ne' mari, come ne' fiumi, fra tutti i rettili acquatici, e fra tutti gli animali che vivono nelle acque. ");
INSERT INTO ita1885_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Sienvi adunque in abbominazione; non mangiate della carne loro, e abbiate in abbominio le lor carogne. ");
INSERT INTO ita1885_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","In somma, siavi cosa abbominevole ogni animale che nell'acque non ha pennette, nè scaglie. ");
INSERT INTO ita1885_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","E fra gli uccelli abbiate questi in abbominio; non manginsi; son cosa abbominevole: l'aquila, il girifalco, l'aquila marina; ");
INSERT INTO ita1885_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ogni specie di nibbio e di avvoltoio; ");
INSERT INTO ita1885_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ogni specie di corvo; ");
INSERT INTO ita1885_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","l'ulula, la civetta, la folica, e ogni specie di sparviere; ");
INSERT INTO ita1885_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","il gufo, lo smergo, e l'alocco; il cigno, il pellicano, la pica; ");
INSERT INTO ita1885_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","la cicogna, e ogni specie di aghirone; ");
INSERT INTO ita1885_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","l'upupa, e il vipistrello. ");
INSERT INTO ita1885_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Siavi parimente in abbominio ogni rettile che vola, e cammina a quattro piedi. ");
INSERT INTO ita1885_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Ma pur d'infra tutti i rettili che volano, e camminano a quattro piedi, voi potrete mangiar di quelli che hanno garetti disopra a' piedi, per saltar con essi in su la terra. ");
INSERT INTO ita1885_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Di tali potrete mangiar di questi; d'ogni specie di arbe, di ogni specie di soleam, d'ogni specie di argol, e d'ogni specie di agab. ");
INSERT INTO ita1885_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Ma siavi in abbominio ogni altro rettile che vola, ed ha quattro piedi. ");
INSERT INTO ita1885_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","E per queste bestie voi vi renderete immondi; chiunque toccherà il corpo morto loro, sarà immondo infino alla sera. ");
INSERT INTO ita1885_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","E chiunque avrà portato del lor corpo morto lavi i suoi vestimenti, e sia immondo infino alla sera. ");
INSERT INTO ita1885_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Di tutte le bestie domestiche sienvi immonde tutte quelle che hanno l'unghia fessa, ma non spartita in due, e che non ruminano; chiunque avrà toccati tali animali, sia immondo. ");
INSERT INTO ita1885_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","E di tutte le bestie che camminano a quattro piedi sienvi immonde tutte quelle che camminano sopra le lor branche; chiunque avrà toccato il corpo morto di tali bestie, sia immondo infino alla sera. ");
INSERT INTO ita1885_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","E chi avrà portato il lor corpo morto lavi i suoi vestimenti, e sia immondo infino alla sera; quelle bestie vi sono immonde. ");
INSERT INTO ita1885_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","E de' rettili che van serpendo sopra la terra, sienvi immondi questi, cioè: ogni specie di donnola, e di topo, e di testuggine; ");
INSERT INTO ita1885_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","e il toporagno, e il cameleone, e la lucertola, e la tarantola, e la talpa. ");
INSERT INTO ita1885_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Fra tutti i rettili, sienvi questi immondi; chiunque li avrà toccati, essendo morti, sia immondo infino alla sera. ");
INSERT INTO ita1885_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","E qualunque cosa, sopra la quale sarà caduto alcuno di que' rettili, essendo morto, sia immonda; qualunque vasello di legno, o vestimento, o pelle, o sacco, o qualunque altro strumento, col quale si fa alcun servigio; e però sia posto nell'acqua, e sia immondo infino alla sera; poi sia mondo. ");
INSERT INTO ita1885_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","E se alcun di quei rettili sarà caduto dentro alcun testo, tutto quello che vi sarà dentro sia immondo, e spezzate il testo. ");
INSERT INTO ita1885_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Qualunque vivanda si mangia, sopra la quale si mette dell'acqua, sia immonda; e qualunque bevanda si beve, in qualche vaso ella si sia, sia immonda. ");
INSERT INTO ita1885_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","E ogni cosa, sopra la quale caderà del corpo morto loro, sia immonda; il forno, o il testo da cuocere, sia disfatto; essi sono immondi; però teneteli per immondi. ");
INSERT INTO ita1885_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Ma pur la fonte, o il pozzo d'acqua raccolta, sia monda; ma chi avrà tocco il corpo morto loro, sia immondo. ");
INSERT INTO ita1885_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Ma, se cade del corpo morto loro sopra qualunque semenza che si semina, sia quella semenza monda. ");
INSERT INTO ita1885_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Ma, se è stata messa dell'acqua sopra la semenza, e vi cade sopra del corpo morto loro, siavi quella semenza immonda. ");
INSERT INTO ita1885_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","E, quando alcuna di quelle bestie che vi son per cibo sarà morta da sè, chi avrà tocco il corpo morto di essa, sia immondo infino alla sera. ");
INSERT INTO ita1885_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","E chi avrà mangiata della carne morta di essa lavi i suoi vestimenti, e sia immondo infino alla sera; parimente, chi avrà portato il corpo morto di essa lavi i suoi vestimenti, e sia immondo infino alla sera. ");
INSERT INTO ita1885_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Ogni rettile che serpe sopra la terra sia immondo; non mangisi. ");
INSERT INTO ita1885_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","D'infra tutti i rettili che serpono sopra la terra non mangiate niuno di quelli che camminano in sul petto, o sia che camminino a quattro piedi, o che abbiano più piedi; perciocchè son cosa abbominevole. ");
INSERT INTO ita1885_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Non rendete abbominevoli le vostre persone per niun rettile che serpe; e non vi contaminate con essi, onde siate immondi per essi. ");
INSERT INTO ita1885_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Perciocchè io sono il Signore Iddio vostro; santificatevi adunque, e siate santi; conciossiachè io sia santo; e non contaminate le vostre persone con alcun rettile che serpe sopra la terra. ");
INSERT INTO ita1885_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Perciocchè io sono il Signore, che vi ho tratti fuor del paese di Egitto, acciocchè io vi sia Dio; siate adunque santi; imperocchè io son santo. ");
INSERT INTO ita1885_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Quest'è la legge intorno alle bestie, e agli uccelli, e ad ogni animal vivente che guizza nelle acque, e ad ogni animale che serpe sopra la terra; ");
INSERT INTO ita1885_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","per discernere fra l'immondo e il mondo; e fra gli animali che si posson mangiare, e quelli che non si devono mangiare. ");
INSERT INTO ita1885_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","IL Signore parlò ancora a Mosè, dicendo: Parla a' figliuoli d'Israele, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Quando una donna avrà fatto un figliuolo, e avrà partorito un maschio, sia immonda sette giorni; sia immonda come al tempo che è separata per la sua immondizia. ");
INSERT INTO ita1885_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","E, nell'ottavo giorno, circoncidasi la carne del prepuzio del fanciullo. ");
INSERT INTO ita1885_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Poi stia quella donna trentatrè giorni a purificarsi del sangue; non tocchi alcuna cosa sacra, e non venga al Santuario, finchè non sieno compiuti i giorni della sua purificazione. ");
INSERT INTO ita1885_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Ma, se partorisce una femmina, sia immonda lo spazio di due settimane, come al tempo ch'ella è separata per la sua immondizia, poi stia sessantasei giorni a purificarsi del sangue. ");
INSERT INTO ita1885_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","E, quando saranno compiuti i giorni della sua purificazione, per figliuolo, o per figliuola, porti al sacerdote, all'entrata del Tabernacolo della convenenza, un agnello d'un anno, per olocausto; e un pippione, o una tortola, per sacrificio per lo peccato. ");
INSERT INTO ita1885_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","E offerisca il sacerdote quelle cose davanti al Signore, e faccia il purgamento del peccato di essa; ed ella sarà purificata del suo flusso di sangue. Questa è la legge della donna che partorisce maschio o femmina. ");
INSERT INTO ita1885_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","E se pur non avrà il modo di fornire un agnello, pigli due tortole, o due pippioni, l'uno per olocausto, l'altro per sacrificio per lo peccato; e faccia il sacerdote il purgamento del peccato di essa; ed ella sarà purificata. ");
INSERT INTO ita1885_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","IL Signore parlò ancora a Mosè e ad Aaronne, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Quando nella pelle della carne di alcuno vi sarà tumore, o rogna, o bolla, o tacca tralucente; e ciò diventerà nella pelle della sua carne come piaga di lebbra; sia colui condotto al Sacerdote Aaronne, ovvero ad uno de' suoi figliuoli sacerdoti. ");
INSERT INTO ita1885_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","E riguardi il sacerdote la piaga nella pelle della carne di esso; e se il pelo della piaga ha mutato colore, ed è divenuto bianco, e la piaga apparisce più profonda della pelle della carne di esso, è piaga di lebbra; perciò, dopo che il sacerdote l'avrà riguardato, dichiarilo immondo. ");
INSERT INTO ita1885_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Ma, se è una tacca tralucente, e bianca, nella pelle della carne di esso, senza apparir più profonda della pelle, e senza che il suo pelo abbia mutato colore, nè sia divenuto bianco; rinchiuda il sacerdote colui che avrà quella piaga, per sette giorni. ");
INSERT INTO ita1885_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","E se, al settimo giorno, al sacerdote, riguardandolo, parrà che la piaga si sia arrestata, e non si sia allargata nella pelle, rinchiudalo di nuovo per sette giorni. ");
INSERT INTO ita1885_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Che se, al settimo giorno, il sacerdote, riguardandolo di nuovo, vede che la piaga si sia ristretta, e non si sia allargata nella pelle, dichiarilo netto; è rogna; e lavi colui i suoi vestimenti; e sarà netto. ");
INSERT INTO ita1885_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Ma, se pur quella rogna si è allargata nella pelle, dopo che colui si sarà fatto riguardare al sacerdote, per esser dichiarato netto; e sarà stato riguardato la seconda volta dal sacerdote; ");
INSERT INTO ita1885_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","e, riguardandolo il sacerdote, ecco, la rogna si è allargata nella pelle; dichiari il sacerdote colui immondo; è lebbra. ");
INSERT INTO ita1885_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Quando vi sarà in alcuno piaga di lebbra, sia condotto al sacerdote. ");
INSERT INTO ita1885_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","E se, riguardandolo il sacerdote, ecco vi è alcun tumore bianco nella pelle, e il pelo di essa ha mutato colore, ed è divenuto bianco, e vi è qualche rimanente di carne viva nel tumore; ");
INSERT INTO ita1885_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","è lebbra invecchiata nella pelle della carne di colui; perciò, dichiarilo il sacerdote immondo; non rinchiudalo; conciossiachè egli sia immondo. ");
INSERT INTO ita1885_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Ma, se la lebbra germoglia largamente nella pelle, e copre tutta la pelle di colui che avrà la piaga, dal capo ai piedi, dovunque il sacerdote potrà vedere con gli occhi; ");
INSERT INTO ita1885_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","allora, se, riguardandolo il sacerdote, ecco, la lebbra ha coperta tutta la pelle di esso, dichiarilo netto; la piaga è tutta divenuta bianca; egli è netto. ");
INSERT INTO ita1885_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ma, al giorno che apparirà in lui alcuna carne viva, sia immondo. ");
INSERT INTO ita1885_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","E il sacerdote, avendo veduta la carne viva, dichiarilo immondo; la carne viva è immonda; è lebbra. ");
INSERT INTO ita1885_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Che se la carne viva si muta di nuovo, e diviene bianca, venga colui al sacerdote. ");
INSERT INTO ita1885_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","E se, riguardandolo il sacerdote, ecco, la piaga ha mutato colore, ed è divenuta bianca, dichiari netto colui che avrà la piaga; egli è netto. ");
INSERT INTO ita1885_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Quando vi sarà stato nella pelle della carne di alcuno ulcera, la qual sia guarita; ");
INSERT INTO ita1885_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","e poi, nel luogo dell'ulcera nascerà tumor bianco, o tacca tralucente, bianca, rosseggiante; sia mostrato al sacerdote. ");
INSERT INTO ita1885_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","E se, riguardandolo il sacerdote, ecco, quella apparisce più bassa che la pelle, e il pelo di essa ha mutato colore, ed è divenuto bianco; dichiari colui immondo; è piaga di lebbra, la quale è germogliata nell'ulcera. ");
INSERT INTO ita1885_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Ma se, riguardandolo il sacerdote, ecco, non vi è alcun pelo bianco, ed ella non è più bassa che la pelle, ed ella s'è ristretta; rinchiudalo il sacerdote per sette giorni. ");
INSERT INTO ita1885_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Ma, se pur quella si è allargata nella pelle, dichiarilo il sacerdote immondo; è piaga di lebbra. ");
INSERT INTO ita1885_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Ma, se la tacca tralucente si è arrestata nel suo luogo, e non si è allargata; è la crosta dell'ulcera; perciò, dichiarilo il sacerdote netto. ");
INSERT INTO ita1885_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Parimente, quando nella pelle della carne di alcuno vi sarà arsura di fuoco, e in quella parte guarita dell'arsura vi sarà tacca tralucente, bianca, rosseggiante, o sol bianca; ");
INSERT INTO ita1885_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","e, riguardandola il sacerdote, ecco, il pelo nella tacca ha mutato colore, ed è divenuto bianco, ed essa apparisce più profonda che la pelle; è lebbra ch'è germogliata nell'arsura; perciò, dichiari il sacerdote colui immondo; è piaga di lebbra. ");
INSERT INTO ita1885_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Ma se, riguardandola il sacerdote, ecco, non vi è alcun pelo bianco nella tacca, ed ella non è punto più bassa che la pelle, e si è ristretta; rinchiuda il sacerdote colui per sette giorni. ");
INSERT INTO ita1885_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Ma se pure, riguardando il sacerdote quella tacca al settimo giorno, ella si è allargata nella pelle; dichiari il sacerdote colui immondo; è piaga di lebbra. ");
INSERT INTO ita1885_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Ma, se la tacca si è arrestata nel suo luogo, e non si è allargata nella pelle, anzi si è ristretta; è una sobbollitura di arsura; perciò, dichiarilo il sacerdote netto; conciossiachè sia crosta di arsura. ");
INSERT INTO ita1885_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","E se un uomo, o una donna, ha alcuna piaga, nel capo, o nella barba; ");
INSERT INTO ita1885_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","e, riguardando il sacerdote la piaga, ecco, ella apparisce più profonda che la pelle; e vi è in essa alcun pelo giallo sottile; dichiari il sacerdote colui immondo; è tigna, è lebbra di capo, o di barba. ");
INSERT INTO ita1885_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Ma se, riguardando il sacerdote quella piaga della tigna, ecco, ella non apparisce più profonda che la pelle, ma non vi è alcun pelo bruno; rinchiuda il sacerdote colui che avrà la piaga della tigna, per sette giorni. ");
INSERT INTO ita1885_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","E se, riguardando il sacerdote quella piaga al settimo giorno, ecco la tigna non si è allargata, e non vi è nato alcun pelo giallo, e la tigna non apparisce più profonda che la pelle; ");
INSERT INTO ita1885_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","radasi colui, ma non rada la tigna; poi rinchiudalo il sacerdote di nuovo per sette giorni. ");
INSERT INTO ita1885_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","E se, riguardando il sacerdote la tigna al settimo giorno, ecco, la tigna non si è allargata nella pelle, e non apparisce punto più profonda della pelle; dichiari il sacerdote colui netto; e lavi egli i suoi vestimenti, e sarà netto. ");
INSERT INTO ita1885_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Ma se pure, dopo che sarà stato dichiarato netto, la tigna si allarga nella sua pelle; ");
INSERT INTO ita1885_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","e, riguardandolo il sacerdote, ecco, la tigna si è allargata nella pelle: non cerchi il sacerdote del pelo giallo; colui è immondo. ");
INSERT INTO ita1885_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ma, se gli pare che la tigna si sia arrestata, e il pelo bruno vi è nato, la tigna è guarita; colui è netto; dichiarilo adunque il sacerdote netto. ");
INSERT INTO ita1885_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","E se un uomo, o una donna, ha alcune tacche tralucenti, bianche, nella pelle della sua carne; ");
INSERT INTO ita1885_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","e, riguardandolo il sacerdote, ecco, nella pelle della lor carne vi sono delle tacche bianche, tralucenti, raggrinzate; son broffole, che son germogliate nella pelle; quella persona è netta. ");
INSERT INTO ita1885_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","E se il capo di alcuno è tutto senza peli, egli è calvo; è netto. ");
INSERT INTO ita1885_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","E s'egli ha la testa pelata dalla parte della faccia, egli è calvo dalla fronte; è netto. ");
INSERT INTO ita1885_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Ma, se nel capo tutto senza peli, o calvo dalla fronte, v'è piaga bianca rosseggiante, è lebbra, che germoglia nel capo tutto senza peli, o calvo dalla fronte. ");
INSERT INTO ita1885_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Se adunque, riguardandolo il sacerdote, ecco un tumore di piaga bianca rosseggiante nel capo, tutto senza peli, o calvo dalla fronte, simile in vista alla lebbra della pelle della carne; ");
INSERT INTO ita1885_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","colui è lebbroso; egli è immondo; del tutto dichiarilo il sacerdote immondo; egli ha la sua piaga nel capo. ");
INSERT INTO ita1885_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Or abbia il lebbroso, in cui sarà piaga di lebbra, i vestimenti sdruciti, e il capo scoperto, e velisi il labbro disopra; e vada gridando: L'immondo! l'immondo! ");
INSERT INTO ita1885_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Sia immondo tutto il tempo che quella piaga sarà in lui; egli è immondo; dimori in disparte, sia la sua stanza fuor del campo. ");
INSERT INTO ita1885_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","E se vi è piaga di lebbra in alcun vestimento di lana o di lino; ");
INSERT INTO ita1885_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ovvero in istame, o in trama di lino, o di lana, o in pelle; ovvero in qualunque lavorio di pelle; ");
INSERT INTO ita1885_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ed essa piaga è verdeggiante, o rosseggiante, nel vestimento, o nella pelle, o nello stame, o nella trama, o in qualunque cosa fatta di pelle; è piaga di lebbra; sia adunque mostrata al sacerdote. ");
INSERT INTO ita1885_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","E il sacerdote, dopo averla riguardata, rinchiuda quello in che sarà la piaga, per sette giorni. ");
INSERT INTO ita1885_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","E se, al settimo giorno, egli vede che la piaga si sia allargata nel vestimento, o nello stame, o nella trama, o nella pelle, in qualunque lavorio s'adoperi pelle; quella piaga è lebbra rodente; quella cosa è immonda. ");
INSERT INTO ita1885_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Perciò, faccia bruciar quel vestimento, o quello stame, o quella trama, di lana, o di lino, ovvero qualunque cosa fatta di pelle nella quale sia quella piaga; conciossiachè sia lebbra rodente; brucisi col fuoco. ");
INSERT INTO ita1885_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Ma se, riguardandola il sacerdote, ecco, la piaga non si è allargata nel vestimento, nello stame, nella trama, ovvero in qualunque cosa fatta di pelle; ");
INSERT INTO ita1885_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","comandi che si lavi ciò in che sarà la piaga; e rinchiudalo il sacerdote per sette altri giorni. ");
INSERT INTO ita1885_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Ma se, dopo che ciò in che sarà la piaga sarà stato lavato; e, riguardandolo il sacerdote, ecco, la piaga non ha mutato colore, benchè non si sia allargata; quella cosa è immonda; brucisi col fuoco; è una rosura che fa cava, o nel diritto, o nel rovescio di quella cosa. ");
INSERT INTO ita1885_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Ma se, riguardandola il sacerdote, ecco, la piaga si è arrestata, dopo essere stata lavata, stracci quella parte, dove sarà la piaga, dal vestimento, o dalla pelle, o dallo stame, o dalla trama. ");
INSERT INTO ita1885_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","E se apparisce ancora nel vestimento, o nello stame, o nella trama, ovvero in qualunque cosa fatta di pelle; è lebbra germogliante; bruciate col fuoco ciò in che sarà la piaga. ");
INSERT INTO ita1885_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Ma il vestimento, o lo stame, o la trama, o qualunque cosa fatta di pelle, dalla quale, dopo che tu l'avrai lavata, la piaga sarà dipartita, lavisi di nuovo; e sarà netta. ");
INSERT INTO ita1885_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Quest'è la legge della piaga della lebbra nel vestimento di lana, o di lino, o nello stame, o nella trama, o in qualunque cosa fatta di pelle; per dichiararla o netta, o immonda. ");
INSERT INTO ita1885_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","IL Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Quest'è la legge intorno al lebbroso, nel giorno della sua purificazione: Sia menato al sacerdote. ");
INSERT INTO ita1885_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Ed esca il sacerdote fuor del campo; e se, avendo riguardato colui, ecco, la piaga della lebbra è guarita nel lebbroso; ");
INSERT INTO ita1885_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","comandi che si prendano, per colui che si purificherà, due uccelletti vivi, mondi, e del legno di cedro, e dello scarlatto, e dell'isopo. ");
INSERT INTO ita1885_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Poi comandi il sacerdote, che si scanni l'uno degli uccelletti, versandone il sangue dentro un testo, sopra dell'acqua viva. ");
INSERT INTO ita1885_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Ed egli stesso prenda l'uccelletto vivo, e il legno di cedro, e lo scarlatto, e l'isopo; e intinga quelle cose, insieme con l'uccelletto vivo, nel sangue dell'uccelletto scannato sopra l'acqua viva. ");
INSERT INTO ita1885_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","E spruzzine sette volte colui che si purifica della lebbra; e, dopo averlo così purificato, lascine andar libero l'uccelletto vivo, su per li campi. ");
INSERT INTO ita1885_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","E colui che si purifica lavi i suoi vestimenti, e radasi tutti i peli, e lavisi con acqua; e sarà netto; poi potrà entrar nel campo; ma dimori sette giorni fuor del suo padiglione. ");
INSERT INTO ita1885_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","E al settimo giorno radasi tutti i peli, il capo, e la barba, e le ciglia degli occhi; in somma, radasi tutti i peli, e lavi i suoi vestimenti; lavisi parimente con acqua le carni; e sarà netto. ");
INSERT INTO ita1885_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","E l'ottavo giorno appresso, prenda due agnelli senza difetto, e un'agnella d'un anno, senza difetto, e tre decimi di fior di farina stemperata con olio, per offerta di panatica, e un log d'olio. ");
INSERT INTO ita1885_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","E presenti il sacerdote, che farà la purificazione, colui che si purificherà, insieme con quelle cose, davanti al Signore, all'entrata del Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Poi prenda il sacerdote l'uno degli agnelli, e offeriscalo per la colpa; insieme col log dell'olio; e dimeni quelle cose per offerta davanti al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Poi scanni l'agnello nel luogo dove si scannano i sacrificii per lo peccato, e gli olocausti, in luogo santo; perciocchè, come il sacrificio per lo peccato appartiene al sacerdote, così ancora gli appartiene il sacrificio per la colpa; è cosa santissima. ");
INSERT INTO ita1885_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","E prenda il sacerdote del sangue del sacrificio per la colpa, e mettalo in sul tenerume dell'orecchia destra di colui che si purificherà, e in sul dito grosso della sua man destra, e in sul dito grosso del suo piè destro. ");
INSERT INTO ita1885_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Poi prenda il sacerdote dell'olio di quel log, e versine sopra la palma della sua man sinistra. ");
INSERT INTO ita1885_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","E intinga il dito della sua man destra, in quell'olio che sarà sopra la palma della sua man sinistra; e col dito spruzzi di quell'olio sette volte nel cospetto del Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","E del rimanente dell'olio, ch'egli avrà in su la palma della mano, mettane in sul tenerume dell'orechhia destra di colui che si purificherà; e in sul dito grosso della sua man destra e in sul dito grosso del suo piè destro, sopra il sangue del sacrificio per la colpa. ");
INSERT INTO ita1885_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","E metta il sacerdote il rimasto dell'olio, ch'egli avrà in mano, in sul capo di colui che si purificherà. E così faccia il sacerdote il purgamento per lui, davanti al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Poi offerisca il sacerdote il sacrificio per lo peccato; e faccia il purgamento per colui che si purificherà della sua immondizia; e poi appresso scanni l'olocausto. ");
INSERT INTO ita1885_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","E offerisca l'olocausto, insieme con l'offerta di panatica, sopra l'Altare. Così faccia il sacerdote purgamento per colui, ed egli sarà netto. ");
INSERT INTO ita1885_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Ma, se colui è povero, e non può fornire quelle cose, prenda un agnello per sacrificio per la colpa, per essere offerto in offerta dimenata, per far purgamento per lui; e un decimo di fior di farina intrisa con olio, per offerta di panatica, e un log d'olio; ");
INSERT INTO ita1885_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","e due tortole, o due pippioni, secondo ch'egli potrà fornire; de' quali l'uno sarà per sacrificio per lo peccato, e l'altro per olocausto. ");
INSERT INTO ita1885_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","E porti quelle cose al sacerdote, all'entrata del Tabernacolo della convenenza, davanti al Signore, l'ottavo giorno appresso la sua purificazione. ");
INSERT INTO ita1885_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","E prenda il sacerdote l'agnello per sacrificio per la colpa, e il log d'olio; e dimenti quelle cose davanti al Signore, in offerta dimenata. ");
INSERT INTO ita1885_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Poi scanni l'agnello del sacrificio per la colpa, e prenda del sangue di esso, e mettalo in sul tenerume dell'orecchia destra di colui che si purificherà, e in sul dito grosso della sua man destra, e in sul dito grosso del suo piè destro. ");
INSERT INTO ita1885_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Poi versi di quell'olio in su la palma della sua man sinistra. ");
INSERT INTO ita1885_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","E col dito della sua man destra spruzzi il sacerdote di quell'olio, che egli avrà nella sua man sinistra, sette volte davanti al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Poi metta di quell'olio, ch'egli avrà sopra la palma della sua mano, in sul tenerume dell'orecchia destra di colui che si purificherà, e in sul dito grosso della sua man destra, e in sul dito grosso del suo piè destro, sopra il luogo dove sarà stato posto il sangue del sacrificio per la colpa. ");
INSERT INTO ita1885_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Poi metta il sacerdote il rimanente di quell'olio, ch'egli avrà sopra la palma della sua mano, in sul capo di colui che si purificherà, per far purgamento per lui nel cospetto del Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Poi sacrifichi l'una di quelle tortole, o l'uno di que' pippioni, secondo che colui avrà potuto fornire. ");
INSERT INTO ita1885_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Di quello ch'egli avrà potuto fornire, o tortole o pippioni, siane uno per sacrificio per lo peccato, e l'altro per olocausto, insieme con l'offerta di panatica. E così il sacerdote faccia il purgamento davanti al Signore per colui che si purificherà. ");
INSERT INTO ita1885_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Quest'è la legge intorno a colui, in cui sarà stata piaga di lebbra, il quale non potrà fornire le cose suddette per la sua purificazione. ");
INSERT INTO ita1885_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","IL Signore parlò, oltre a ciò, a Mosè e ad Aaronne, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Quando voi sarete entrati nel paese di Canaan, il quale io vi do per possessione, se io mando piaga di lebbra in alcuna casa del paese della vostra possessione; ");
INSERT INTO ita1885_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","venga colui di cui sarà la casa, e significhilo al sacerdote, dicendo: Egli appare come una piaga di lebbra nella mia casa. ");
INSERT INTO ita1885_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Allora comandi il sacerdote che si sgomberi la casa, avanti ch'egli vi entri per riguardar la piaga, acciocchè non sia immondo tutto ciò che sarà in quella casa; dopo questo, entrivi il sacerdote, per riguardar la casa. ");
INSERT INTO ita1885_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","E se, avendo riguardata la piaga, vedrà che vi sia piaga nelle pareti della casa, fossatelle verdeggianti, o rosseggianti, che appariscano più basse della parete; ");
INSERT INTO ita1885_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","escasene il sacerdote fuor della casa, all'uscio di essa, e serri la casa per sette giorni. ");
INSERT INTO ita1885_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","E il settimo giorno appresso, tornivi il sacerdote; e se, riguardandola, ecco, la piaga si è allargata per le pareti della casa; ");
INSERT INTO ita1885_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","comandi che si cavino le pietre, nelle quali sarà la piaga, e che si gittino fuor della città in luogo immondo. ");
INSERT INTO ita1885_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","E faccia rader lo smalto della casa di dentro d'ogni intorno, e versisi la polvere dello smalto che si sarà raso, fuor della città, in luogo immondo. ");
INSERT INTO ita1885_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Poi prendansi dell'altre pietre, e ficchinsi in luogo di quelle; prendasi ancora dell'altro smalto, e smaltisene la casa. ");
INSERT INTO ita1885_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Ma, se la piaga torna a germogliar nella casa, dopo che ne saranno state cavate le pietre, e dopo che la casa sarà stata rasa, e di nuovo smaltata; ");
INSERT INTO ita1885_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","e il sacerdote, entrandovi, e riguardando, ecco, la piaga si è allargata nella casa; è lebbra rodente nella casa; la casa è immonda. ");
INSERT INTO ita1885_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Perciò disfacciasi quella casa, le sue pietre, e il suo legname, e tutto lo smalto di essa; e portinsi quelle cose fuor della città, in luogo immondo. ");
INSERT INTO ita1885_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","E chi sarà entrato in quella casa, in tutti i giorni ch'ella sarà serrata, sia immondo infino alla sera. ");
INSERT INTO ita1885_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","E chi sarà giaciuto in quelle casa, lavi i suoi vestimenti; parimente, chi avrà mangiato in essa, lavi i suoi vestimenti. ");
INSERT INTO ita1885_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Ma se pure, essendovi entrato il sacerdote, e avendo riguardato, ecco, la piaga non si è allargata nella casa, dopo che è stata smaltata; dichiari quella casa netta; conciossiachè la piaga sia guarita. ");
INSERT INTO ita1885_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Poi prenda, per purificar la casa, due uccelletti, e del legno di cedro, e dello scarlatto, e dell'isopo. ");
INSERT INTO ita1885_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","E scanni l'uno degli uccelletti; versandone il sangue dentro un testo, sopra dell'acqua viva. ");
INSERT INTO ita1885_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Poi prenda il legno di cedro e l'isopo, e lo scarlatto, e l'uccelletto vivo, e intinga quelle cose nel sangue dell'uccelletto scannato, e nell'acqua viva; e spruzzi la casa sette volte. ");
INSERT INTO ita1885_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","E così purifichi la casa col sangue dell'uccelletto, e con l'acqua viva, e con l'uccelletto vivo, e col legno di cedro, e con l'isopo, e con lo scarlatto; ");
INSERT INTO ita1885_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","poi lascine andar libero l'uccelletto vivo, fuor della città, su per li campi; e così faccia il purgamento per la casa; ed ella sarà netta. ");
INSERT INTO ita1885_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Quest'è la legge intorno a qualunque piaga di lebbra, o tigna; ");
INSERT INTO ita1885_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","e intorno alla lebbra di vestimento o di casa; ");
INSERT INTO ita1885_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","e intorno a tumore, o bolla, o tacca tralucente; ");
INSERT INTO ita1885_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","per insegnare in qual giorno alcuna cosa è immonda, e in quale è netta. Quest'è la legge intorno alla lebbra. ");
INSERT INTO ita1885_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","IL Signore parlò ancora a Mosè e ad Aaronne, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Parlate ai figliuoli d'Israele, e dite loro: Quando ad alcuno colerà la carne, egli è immondo per la sua colagione. ");
INSERT INTO ita1885_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","E questa sarà la sua immondizia, per la sua colagione; o sia che la sua carne coli a guisa di bava, o che la sua carne rattenga la sua colagione; ciò è la sua immondizia. ");
INSERT INTO ita1885_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Sia immondo ogni letto, sopra il quale sarà giaciuto colui che avrà la colagione; sieno parimente immonde tutte le masserizie, sopra le quali egli sarà seduto. ");
INSERT INTO ita1885_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","E colui che avrà tocco il letto di esso, lavi i suoi vestimenti, e sè stesso, con acqua; e sia immondo infino alla sera. ");
INSERT INTO ita1885_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Parimente, chi sarà seduto sopra alcuna delle masserizie, sopra la quale sia seduto colui che avrà la colagione, lavi i suoi vestimenti, e sè stesso, con acqua; e sia immondo infino alla sera. ");
INSERT INTO ita1885_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Simigliantemente, chi avrà tocca la carne di colui che avrà la colagione, lavi i suoi vestimenti, e sè stesso, con acqua; e sia immondo infino alla sera. ");
INSERT INTO ita1885_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","E se colui che avrà la colagione sputa sopra alcuna persona netta, lavi quella persona i suoi vestimenti, e sè stessa, con acqua; e sia immonda infino alla sera. ");
INSERT INTO ita1885_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Sia parimente immonda ogni sella, sopra la quale colui che avrà la colagione sarà cavalcato. ");
INSERT INTO ita1885_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","E chiunque avrà tocca cosa alcuna che sia stata sotto di lui, sia immondo infino alla sera; e chi porterà cotali cose, lavi i suoi vestimenti, e sè stesso, con acqua; e sia immondo infino alla sera. ");
INSERT INTO ita1885_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","E chiunque sarà stato tocco da colui che avrà la colagione, senza ch'egli abbia prima tuffate le mani nell'acqua; lavi i suoi vestimenti, e sè stesso, con acqua; e sia immondo infino alla sera. ");
INSERT INTO ita1885_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","E sia spezzato il testo, il quale colui che avrà la colagione avrà tocco; e ogni vasello di legno sia tuffato nell'acqua. ");
INSERT INTO ita1885_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","E quando colui che avrà la colagione si purificherà della sua colagione contisi sette giorni per la sua purificazione, e lavi i suoi vestimenti; lavisi parimente le carni con acqua viva; e sarà netto. ");
INSERT INTO ita1885_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","E l'ottavo giorno, prendasi due tortole, o due pippioni, e venga davanti al Signore, all'entrata del Tabernacolo della convenenza; e rechi quelli al sacerdote. ");
INSERT INTO ita1885_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","E offeriscali il sacerdote, l'uno in sacrificio per lo peccato, e l'altro in olocausto; e così faccia il sacerdote, davanti al Signore, il purgamento per lui della sua colagione. ");
INSERT INTO ita1885_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","E quando di alcuno sarà uscito seme genitale, lavisi egli con acqua tutte le carni; e sia immondo infino alla sera. ");
INSERT INTO ita1885_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Sia eziandio lavata con acqua ogni vesta, e ogni pelle, sopra la quale sarà seme genitale; e sia immonda infino alla sera. ");
INSERT INTO ita1885_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","E se un uomo, che abbia la colagione, giace carnalmente con una donna; lavinsi amendue con acqua, e sieno immondi infino alla sera. ");
INSERT INTO ita1885_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","E quando la donna avrà il suo flusso, quando le colerà sangue dalla sua carne, dimori separata sette giorni; e chiunque la toccherà sia immondo infino alla sera. ");
INSERT INTO ita1885_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","E ogni cosa, sopra la quale ella si sarà giaciuta, mentre sarà separata, sia immonda; sia parimente immonda ogni cosa, sopra la quale si sarà seduta. ");
INSERT INTO ita1885_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","E chiunque avrà toccato il letto di essa, lavi i suoi vestimenti, e sè stesso, con acqua; e sia immondo infino alla sera. ");
INSERT INTO ita1885_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Parimente, chiunque avrà tocca alcuna delle masserizie, sopra la quale ella si sarà seduta, lavi i suoi vestimenti, e sè stesso, con acqua; e sia immondo infino alla sera. ");
INSERT INTO ita1885_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Anzi, se alcuna cosa è sopra il letto o sopra alcun arnese, sopra il quale ella sia seduta, quando alcuno toccherà quella cosa, sia immondo infino alla sera. ");
INSERT INTO ita1885_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","E se pure alcuno giace con lei talchè abbia addosso della di lei immondizia, sia immondo sette giorni; e sia immondo ogni letto, sopra il quale egli sarà giaciuto. ");
INSERT INTO ita1885_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Parimente, quando la donna avrà il flusso del sangue più dì, fuor del tempo de' suoi corsi; ovvero, quando avrà esso flusso oltre al tempo di essi; sia immonda tutto il tempo del flusso della sua immondizia, come al tempo de' suoi corsi. ");
INSERT INTO ita1885_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Siale ogni letto, sopra il quale sarà giaciuta in tutto il tempo del suo flusso, come il letto, sopra il quale giacerà avendo i suoi corsi; sieno parimente tutte le masserizie, sopra le quali ella si sederà, immonde, per l'immondizia de' suoi corsi. ");
INSERT INTO ita1885_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","E chiunque avrà tocche quelle cose sia immondo; e lavi i suoi vestimenti, e sè stesso, con acqua; e sia immondo infino alla sera. ");
INSERT INTO ita1885_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","E, quando sarà netta del suo flusso, contisi sette giorni; e poi sarà netta. ");
INSERT INTO ita1885_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","E l'ottavo giorno prendasi due tortole, o due pippioni; e portili al sacerdote, all'entrata del Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","E offeriscane il sacerdote uno in sacrificio per lo peccato, e l'altro in olocausto; e così faccia il sacerdote il purgamento per lei del flusso della sua immondizia, nel cospetto del Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Così fate che i figliuoli d'Israele si guardino della loro immondizia; acciocchè non muoiano per la loro immondizia, contaminando il mio Tabernacolo, ch'è nel mezzo di loro. ");
INSERT INTO ita1885_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Quest'è la legge intorno a colui del quale esce seme genitale, onde è renduto immondo; ");
INSERT INTO ita1885_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","e intorno alla donna che ha l'infermità della sua immondizia; e intorno a chiunque ha flusso, maschio, o femmina; e intorno all'uomo che sarà giaciuto con donna immonda. ");
INSERT INTO ita1885_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","E IL Signore parlò a Mosè, dopo che i due figliuoli di Aaronne furon morti, quando, essendosi appressati davanti al Signore, morirono. ");
INSERT INTO ita1885_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Il Signore adunque disse a Mosè: Parla ad Aaronne, tuo fratello, che non entri in ogni tempo nel Santuario, dentro della Cortina, davanti al Coperchio, ch'è in su l'Arca, acciocchè non muoia; conciossiachè io apparisca nella nuvola, in sul Coperchio. ");
INSERT INTO ita1885_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Entri Aaronne nel Santuario con questo, cioè: con un giovenco per sacrificio per lo peccato, e un montone per olocausto; ");
INSERT INTO ita1885_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","vestasi la sacra Tonica di lino; e abbia in su la sua carne le mutande line; e sia cinto con la Cintura di lino; e ravvolgasi intorno al capo la Benda di lino; quelli sono i sacri vestimenti; vestali dunque, dopo essersi lavate le carni con acqua. ");
INSERT INTO ita1885_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","E prenda dalla raunanza de' figliuoli d'Israele, due becchi per sacrificio per lo peccato, e un montone per olocausto. ");
INSERT INTO ita1885_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","E offerisca Aaronne il giovenco del sacrificio per lo peccato, ch'è per lui; e faccia purgamento per sè, e per la sua casa. ");
INSERT INTO ita1885_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Appresso, prenda due becchi, e presentili nel cospetto del Signore, all'entrata del Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","E tragga Aaronne le sorti sopra que' due becchi; una sorte per lo Signore, e un'altra per Azazel. ");
INSERT INTO ita1885_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","E offerisca Aaronne il becco, sopra il quale sarà caduta la sorte per lo Signore; e sacrifichilo per lo peccato. ");
INSERT INTO ita1885_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Ma il becco, sopra il quale sarà caduta la sorte per Azazel, sia presentato vivo davanti al Signore, per far purgamento con esso, per mandarlo nel deserto, come per Azazel. ");
INSERT INTO ita1885_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Offerisca adunque Aaronne il giovenco del sacrificio per lo peccato ch'è per lui, e faccia purgamento per sè, e per la sua casa. E dopo ch'egli avrà scannato il giovenco del suo sacrificio per lo peccato, ch'è per lui; ");
INSERT INTO ita1885_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","prenda pieno il turibolo di brace accese d'in su l'Altare, d'innanzi al Signore; e due menate piene del profumo degli aromati polverizzato; e rechilo dentro della Cortina. ");
INSERT INTO ita1885_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","E metta il profumo sopra il fuoco, davanti al Signore; e copra il vapore del profumo il Coperchio, ch'è sopra la Testimonianza; che talora egli non muoia. ");
INSERT INTO ita1885_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Poi prenda del sangue del giovenco, e spruzzine col dito la parte anteriore del Coperchio, verso oriente; spruzzi parimente col dito di quel sangue, sette volte davanti al Coperchio. ");
INSERT INTO ita1885_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Scanni ancora il becco del sacrificio per lo peccato, ch' è per lo popolo, e portine il sangue dentro della Cortina; e faccia del sangue di esso come avrà fatto del sangue del giovenco; e spruzzine sopra il Coperchio, e davanti al Coperchio. ");
INSERT INTO ita1885_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","E così purifichi il Santuario, purificandolo dell'immondizie dei figliuoli d'Israele, e de' loro misfatti, secondo tutti i lor peccati; faccia ancora il simigliante al Tabernacolo della convenenza, il quale è stanziato appresso loro, per le loro immondizie. ");
INSERT INTO ita1885_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","E non siavi alcun uomo nel Tabernacolo della convenenza, quando esso entrerà nel Santuario, per farvi purgamento, finchè non sia uscito. E, dopo ch'egli avrà fatto il purgamento per sè, per la sua casa, e per tutta la raunanza d'Israele; ");
INSERT INTO ita1885_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","esca verso l'Altare, ch'è davanti al Signore, e faccia purgamento per esso; e prenda del sangue del giovenco, e del sangue del becco, e mettalo in su le corna dell'Altare, attorno attorno. ");
INSERT INTO ita1885_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","E col dito spruzzi di quel sangue sette volte sopra l'Altare; e così purifichilo, e santifichilo, dell'immondizie de' figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","E, dopo ch'egli avrà compiuto di fare il purgamento del Santuario, e del Tabernacolo della convenenza, e dell'Altare, offerisca il becco vivo. ");
INSERT INTO ita1885_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","E posi Aaronne le sue due mani sopra il capo del becco vivo, e faccia sopra esso confessione di tutte le iniquità de' figliuoli d'Israele, e di tutti i misfatti loro, secondo tutti i lor peccati; e metta quelli sopra il capo di quel becco, e mandinelo nel deserto per mano di un uomo apposta. ");
INSERT INTO ita1885_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","E quel becco porterà sopra sè tutte le loro iniquità, in terra solitaria; e lascilo colui andar per lo deserto. ");
INSERT INTO ita1885_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Appresso entri Aaronne nel Tabernacolo della convenenza, e spoglisi i vestimenti lini, i quali egli si avea vestiti entrando nel Santuario; e ripongali quivi. ");
INSERT INTO ita1885_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Poi lavisi le carni con acqua, in luogo santo, e rivesta i suoi vestimenti; poi esca e sacrifichi il suo olocausto, e l'olocausto del popolo; e faccia purgamento per sè, e per lo popolo. ");
INSERT INTO ita1885_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","E bruci il grasso del sacrificio per lo peccato sopra l'Altare. ");
INSERT INTO ita1885_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","E lavi colui che avrà menato via il becco per Azazel i suoi vestimenti, e le sue carni, con acqua; poi ritorni nel campo. ");
INSERT INTO ita1885_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Ma portisi fuor del campo il giovenco del sacrificio per lo peccato, e il becco del sacrificio per lo peccato, il cui sangue sarà stato portato dentro al Santuario, per farvi purgamento; e brucisi la lor pelle, e la lor carne, e il loro sterco, col fuoco. ");
INSERT INTO ita1885_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","E lavi colui che li avrà bruciati i suoi vestimenti, e le sue carni, con acqua; e poi vengasene nel campo. ");
INSERT INTO ita1885_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","E siavi questo per istatuto perpetuo. Nel settimo mese, nel decimo giorno del mese, affliggete l'anime vostre; e non fate lavoro alcuno, nè colui ch'è natio del paese, nè il forestiere che dimora fra voi. ");
INSERT INTO ita1885_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Perciocchè in quel dì si farà purgamento per voi, per purificarvi; voi sarete purificati di tutti i vostri peccati nel cospetto del Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Siavi quel giorno riposo di Sabato; e affliggete in esso l'anime vostre, per istatuto perpetuo. ");
INSERT INTO ita1885_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","E il Sacerdote, che sarà stato unto, e consacrato, per esercitare il sacerdozio, in luogo di suo padre, faccia il purgamento, essendo vestito de' vestimenti lini, de' vestimenti sacri. ");
INSERT INTO ita1885_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","E faccia il purgamento per lo santo Santuario, e per lo Tabernacolo della convenenza, e per l'Altare; faccia parimente il purgamento per li sacerdoti, e per tutto il popolo della raunanza. ");
INSERT INTO ita1885_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","E siavi questo per istatuto perpetuo, per far purgamento per i figliuoli d'Israele, di tutti i lor peccati, una volta l'anno. E si fece come il Signore avea comandato a Mosè. ");
INSERT INTO ita1885_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","IL Signore parlò, oltre a ciò, a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Parla ad Aaronne e a' suoi figliuoli, e a tutti i figliuoli d'Israele, e di' loro: Quest'è quello che il Signore ha comandato, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Se alcuno della casa d'Israele scanna bue, o agnello, o capra, dentro del campo; o anche se lo scanna fuor del campo, ");
INSERT INTO ita1885_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","e non l'adduce all'entrata del Tabernacolo della convenenza, per offerirne l'offerta al Signore, davanti al Tabernacolo del Signore; ciò sia imputato a colui in ispargimento di sangue; egli ha sparso sangue, e però sia riciso d'infra il suo popolo. ");
INSERT INTO ita1885_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Acciocchè i figliuoli d'Israele adducano i lor sacrificii, i quali essi sacrificano per li campi, e li presentino al Signore all'entrata del Tabernacolo della convenenza, dandoli al sacerdote; e li sacrifichino al Signore, per sacrificii da render grazie; ");
INSERT INTO ita1885_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","e acciocchè il sacerdote spanda il sangue di essi sacrificii sopra l'Altare del Signore, all'entrata del Tabernacolo della convenenza; e faccia bruciare il grasso in soave odore al Signore; ");
INSERT INTO ita1885_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","e non sacrifichino più i lor sacrificii a' demoni, dietro ai quali sogliono andar fornicando. Questo sia loro uno statuto perpetuo per le lor generazioni. ");
INSERT INTO ita1885_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Di' loro ancora: Se alcuno della casa d'Israele, o de' forestieri che dimoreranno fra voi, offerisce olocausto, o sacrificio; ");
INSERT INTO ita1885_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","e non l'adduce all'entrata del Tabernacolo della convenenza, per sacrificarlo al Signore; sia quell'uomo riciso da' suoi popoli. ");
INSERT INTO ita1885_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","E SE alcuno della casa d'Israele, o de' forestieri che dimoreranno fra loro, mangia alcun sangue, io metterò la mia faccia contro a quella persona che avrà mangiato il sangue; e la sterminerò d'infra il suo popolo. ");
INSERT INTO ita1885_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Perciocchè la vita della carne è nel sangue; e però vi ho ordinato che sia posto sopra l'Altare, per far purgamento per l'anime vostre; conciossiachè il sangue sia quello con che si fa il purgamento per la persona. ");
INSERT INTO ita1885_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Perciò ho detto a' figliuoli di Israele: Niuno di voi mangi sangue; il forestiere stesso, che dimora fra voi, non mangi sangue. ");
INSERT INTO ita1885_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","E anche, se alcuno dei figliuoli d'Israele, o de' forestieri che dimoreranno fra loro, prende a caccia alcuna fiera, o uccello, che si può mangiare, spandane il sangue, e copralo di polvere. ");
INSERT INTO ita1885_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Perciocchè esso è la vita di ogni carne; il sangue le è in luogo di anima; e però ho detto a' figliuoli d'Israele: Non mangiate sangue di alcuna carne; perciocchè il sangue è la vita di ogni carne; chiunque ne mangerà sia sterminato. ");
INSERT INTO ita1885_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","E qualunque persona avrà mangiata carne di bestia morta da sè, o lacerata dalle fiere, natio, o forestiere, ch'egli sia, lavi i suoi vestimenti, e sè stesso, con acqua; e sia immondo infino alla sera: poi sia netto. ");
INSERT INTO ita1885_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","E, se non lava i suoi vestimenti, e le sue carni, egli porterà la sua iniquità. ");
INSERT INTO ita1885_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","IL Signore parlò ancora a Mosè, dicendo: Parla a' figliuoli d'Israele, e di' loro: ");
INSERT INTO ita1885_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Io sono il Signore Iddio vostro. ");
INSERT INTO ita1885_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Non fate secondo l'opere del paese di Egitto, nel quale siete dimorati; non fate altresì secondo l'opere del paese di Canaan, dove io vi conduco; e non procedete secondo i lor costumi. ");
INSERT INTO ita1885_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Mettete in opera le mie leggi, e osservate i miei statuti, per camminare in essi. ");
INSERT INTO ita1885_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Io sono il Signore Iddio vostro. Osservate, dico, i miei statuti, e le mie leggi; le quali chiunque metterà in opera viverà per esse. Io sono il Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Niuno si accosti ad alcuna sua carnal parente, per iscoprire le sue vergogne. Io sono il Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Non iscoprir le vergogne di tuo padre, nè le vergogne di tua madre: ell'è tua madre; non iscoprir le sue vergogne. ");
INSERT INTO ita1885_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Non iscoprir le vergogne della moglie di tuo padre; esse son le vergogne di tuo padre. ");
INSERT INTO ita1885_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Non iscoprir le vergogne di tua sorella, figliuola di tuo padre, o figliuola di tua madre, generata in casa, o generata fuori. ");
INSERT INTO ita1885_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Non iscoprir le vergogne della figliuola del tuo figliuolo, o della figliuola della tua figliuola; conciossiachè esse sieno le tue vergogne proprie. ");
INSERT INTO ita1885_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Non iscoprir le vergogne della figliuola della moglie di tuo padre, generata da tuo padre. Ell'è tua sorella. ");
INSERT INTO ita1885_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Non iscoprir le vergogne della sorella di tuo padre. Ell'è la carne di tuo padre. ");
INSERT INTO ita1885_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Non iscoprir le vergogne della sorella di tua madre; perciocchè ell'è la carne di tua madre. ");
INSERT INTO ita1885_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Non iscoprir le vergogne del fratello di tuo padre; non accostarti alla sua moglie; ell'è tua zia. ");
INSERT INTO ita1885_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Non iscoprir le vergogne della tua nuora; ell'è moglie del tuo figliuolo; non iscoprir le sue vergogne. ");
INSERT INTO ita1885_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Non iscoprir le vergogne della moglie del tuo fratello; esse son le vergogne del tuo fratello. ");
INSERT INTO ita1885_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Non iscoprir le vergogne di una donna, e della sua figliuola insieme; non prender la figliuola del suo figliuolo, nè la figliuola della sua figliuola, per iscoprir le lor vergogne; esse sono una medesima carne; ciò è una scelleratezza. ");
INSERT INTO ita1885_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Non prendere eziandio una donna, insieme con la sua sorella; per esser la sua rivale, scoprendo le vergogne della sua sorella, insieme con lei, in vita sua. ");
INSERT INTO ita1885_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","E non accostarti a donna, mentre è appartata per la sua immondizia, per iscoprir le sue vergogne. ");
INSERT INTO ita1885_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","E non giacer carnalmente con la moglie del tuo prossimo, contaminandoti con essa. ");
INSERT INTO ita1885_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","E non dar della tua progenie, per farla passar per lo fuoco a Molec; e non profanare il nome dell'Iddio tuo. Io sono il Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Non giacer carnalmente con maschio; ciò è cosa abbominevole. ");
INSERT INTO ita1885_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Parimente, non congiungerti carnalmente con alcuna bestia, per contaminarti con essa; e non presentisi la donna ad alcuna bestia, per farsi coprire; ciò è confusione. ");
INSERT INTO ita1885_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Non vi contaminate in alcuna di queste cose; conciossiachè le genti, che io scaccio dal vostro cospetto, si sieno contaminate in tutte queste cose. ");
INSERT INTO ita1885_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","E il paese è stato contaminato; onde io visito sopra esso la sua iniquità, e il paese vomita fuori i suoi abitatori. ");
INSERT INTO ita1885_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Ma voi, osservate i miei statuti, e le mie leggi; e non fate alcuna di queste cose abbominevoli, nè il natio del paese, nè il forestiere che dimora fra voi; ");
INSERT INTO ita1885_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(conciossiachè gli uomini di quel paese, che sono stati innanzi a voi, abbiano fatte tutte queste cose abbominevoli; laonde il paese è stato contaminato;) ");
INSERT INTO ita1885_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","acciocchè il paese non vi vomiti fuori, se voi lo contaminerete; come avrà vomitata fuori la gente ch'era innanzi a voi. ");
INSERT INTO ita1885_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Perciocchè, se alcuno fa alcuna di queste cose abbominevoli, le persone che avranno ciò fatto saranno sterminate d'infra il lor popolo. ");
INSERT INTO ita1885_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Osservate adunque ciò che io comando che si osservi, per non operare secondo alcuno di que' costumi abbominevoli, che sono stati usati innanzi a voi; e non vi contaminate in essi. Io sono il Signore Iddio vostro. ");
INSERT INTO ita1885_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","IL Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Parla a tutta la raunanza de' figliuoli d'Israele, e di' loro: Siate santi; perciocchè io, il Signore Iddio vostro, son santo. ");
INSERT INTO ita1885_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Porti ciascuno riverenza a sua madre, e a suo padre; e osservate i miei Sabati. Io sono il Signore Iddio vostro. ");
INSERT INTO ita1885_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Non vi rivolgete agl'idoli, e non vi fate dii di getto. Io sono il Signore Iddio vostro. ");
INSERT INTO ita1885_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","E quando voi sacrificherete al Signore sacrificio da render grazie, sacrificatelo in maniera ch'egli sia gradito per voi. ");
INSERT INTO ita1885_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Mangisi il giorno stesso che voi l'avrete sacrificato, e il giorno seguente; ma ciò che ne sarà avanzato fino al terzo giorno sia bruciato col fuoco. ");
INSERT INTO ita1885_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","E se pur se ne mangerà il terzo giorno, sarà fracidume; non sarà gradito. ");
INSERT INTO ita1885_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","E chiunque ne avrà mangiato porterà la sua iniquità; perciocchè egli avrà profanata una cosa sacra al Signore; e però sia quella persona ricisa da' suoi popoli. ");
INSERT INTO ita1885_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","E quando voi mieterete la ricolta della vostra terra, non mietere affatto il canto del campo; e non ispigolar le spighe tralasciate dalla tua ricolta. ");
INSERT INTO ita1885_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","E non racimolar la tua vigna, nè raccoglierne i granelli; lasciali a' poveri, e ai forestieri. Io sono il Signore Iddio vostro. ");
INSERT INTO ita1885_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Niuno di voi rubi, nè menta, nè frodi il suo prossimo. ");
INSERT INTO ita1885_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","E non giurate falsamente per lo mio Nome, sì che tu profani il Nome dell'Iddio tuo. Io sono il Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Non oppressare il tuo prossimo, e non rapirgli il suo; il pagamento dell'opera del tuo mercenario non dimori appresso di te la notte, infino alla mattina. ");
INSERT INTO ita1885_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Non maledire il sordo, e non porre intoppo davanti al cieco; ma temi l'Iddio tuo. Io sono il Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Non fate iniquità in giudicio; non aver riguardo alla qualità del povero; e non portare onore alla qualità del grande; rendi giusto giudicio al tuo prossimo. ");
INSERT INTO ita1885_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Non andare sparlando d'altrui fra i tuoi popoli; e non levarti contro al sangue del tuo prossimo. Io sono il Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Non odiare il tuo fratello nel tuo cuore; riprendi pure il tuo prossimo, e non caricarti di peccato per lui. ");
INSERT INTO ita1885_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Non far vendetta, e non serbare odio a quei del tuo popolo; anzi ama il tuo prossimo come te stesso. Io sono il Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Osservate i miei statuti: Non far coprire la tua bestia da altra di diversa specie; non seminare il tuo campo di diverse specie di semenze; e non portare addosso veste contesta di diverse materie. ");
INSERT INTO ita1885_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Se alcuno giace carnalmente con donna, la quale essendo serva, sia stata sposata ad un uomo, senza essere stata riscattata, nè essere stata messa in libertà, sieno amendue castigati di scopatura; non sieno fatti morire; perciocchè colei non è stata messa in libertà. ");
INSERT INTO ita1885_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","E adduca colui al Signore, all'entrata del Tabernacolo della convenenza, un montone per sacrificio per la sua colpa. ");
INSERT INTO ita1885_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","E faccia il sacerdote, col montone del sacrificio per la colpa, purgamento davanti al Signore, per lui, del peccato ch'egli ha commesso; e il peccato ch'egli ha commesso gli sia perdonato. ");
INSERT INTO ita1885_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Ora, quando voi sarete entrati nel paese, e avrete piantato qualche albero fruttifero, toglietegli il prepuzio, cioè il suo frutto; tenete quell'albero per incirconciso per tre anni; non mangisene del frutto. ");
INSERT INTO ita1885_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","E l'anno quarto sia tutto il frutto suo cosa sacra al Signore, da rendergli lode. ");
INSERT INTO ita1885_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Ma l'anno quinto mangiate del suo frutto, cogliendo la sua rendita per voi. Io sono il Signore Iddio vostro. ");
INSERT INTO ita1885_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Non mangiate nulla col sangue; non usate augurii, nè pronostichi. ");
INSERT INTO ita1885_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Non vi tagliate a tondo i capelli da' lati del capo; e non vi guastate i canti della barba. ");
INSERT INTO ita1885_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Parimente non vi fate alcuna tagliatura nelle carni per un morto, e non vi fate bollatura alcuna addosso. Io sono il Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Non contaminar la tua figliuola, recandola a fornicare; e il paese non fornichi, e non si empia di scelleratezze. ");
INSERT INTO ita1885_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Osservate i miei Sabati; e riverite il mio Santuario. Io sono il Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Non vi rivolgete agli spiriti di Pitone, e agl'indovini; e non li domandate, per contaminarvi con essi. Io sono il Signore Iddio vostro. ");
INSERT INTO ita1885_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Levati su davanti al canuto, e onora l'aspetto del vecchio; e temi dell'Iddio tuo. Io sono il Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","E quando alcun forestiere dimorerà con voi nel vostro paese, non gli fate alcun torto. ");
INSERT INTO ita1885_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Siavi il forestiere, che dimorerà con voi, come uno di voi che sia natio del paese; amalo come te stesso; conciossiachè voi siate stati forestieri nel paese di Egitto. Io sono il Signore Iddio vostro. ");
INSERT INTO ita1885_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Non fate alcuna iniquità in giudicio, nè in misura di spazio, nè in peso, nè in misura di contenenza. ");
INSERT INTO ita1885_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Abbiate bilance giuste, pesi giusti, efa giusto, e hin giusto. Io sono il Signore Iddio vostro, che vi ho tratti fuor del paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Osservate adunque tutti i miei statuti e tutte le mie leggi, e mettetele in opera. Io sono il Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","IL Signore parlò, oltre a ciò, a Mosè dicendo: Di' ancora a' figliuoli d'Israele: ");
INSERT INTO ita1885_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Chiunque de' figliuoli d'Israele, o de' forestieri che dimorano in Israele, avrà dato della sua progenie a Molec, del tutto sia fatto morire; lapidilo il popolo del paese. ");
INSERT INTO ita1885_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","E io ancora metterò la mia faccia contro a quell'uomo, e lo sterminerò d'infra il suo popolo; perciocchè egli avrà dato della sua progenie a Molec, per contaminare il mio Santuario, e per profanare il mio Nome santo. ");
INSERT INTO ita1885_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Che se pure il popolo del paese del tutto chiude gli occhi, per non vedere quell'uomo, quando avrà dato della sua progenie a Molec, per non farlo morire; ");
INSERT INTO ita1885_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","io metterò la mia faccia contro a quell'uomo, e contro alla sua famiglia; e sterminerò d'infra il lor popolo lui, e tutti coloro che lo seguiranno, in fornicare dietro a Molec. ");
INSERT INTO ita1885_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","E se alcuna persona si rivolge agli spiriti di Pitone, o agl'indovini, per fornicar dietro a loro, io metterò la mia faccia contro a quella persona, e la sterminerò d'infra il suo popolo. ");
INSERT INTO ita1885_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Voi dunque santificatevi, e siate santi; perciocchè io sono il Signore Iddio vostro. ");
INSERT INTO ita1885_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","E osservate i miei statuti, e metteteli in opera. Io sono il Signore che vi santifico. ");
INSERT INTO ita1885_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Se alcuno maledice suo padre, o sua madre, del tutto sia fatto morire; egli ha maledetto suo padre, o sua madre; sia il suo sangue sopra lui. ");
INSERT INTO ita1885_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","E se alcuno commette adulterio con la moglie di un altro, con la moglie del suo prossimo; facciansi morire l'adultero e l'adultera. ");
INSERT INTO ita1885_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","E se alcuno giace con la moglie di suo padre, egli ha scoperte le vergogne di suo padre; del tutto facciansi morire amendue; sia il lor sangue sopra loro. ");
INSERT INTO ita1885_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","E se alcuno giace con la sua nuora, del tutto facciansi morire amendue; essi hanno fatta confusione; sia il lor sangue sopra loro. ");
INSERT INTO ita1885_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","E se alcuno giace carnalmente con maschio, amendue hanno fatta una cosa abbominevole; del tutto facciansi morire; sia il lor sangue sopra loro. ");
INSERT INTO ita1885_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","E se alcuno prende una donna, e la madre di essa insieme, ciò è scelleratezza; brucinsi col fuoco, e lui e loro; acciocchè non vi sia alcuna scelleratezza nel mezzo di voi. ");
INSERT INTO ita1885_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","E se alcuno si congiunge carnalmente con una bestia, del tutto sia fatto morire; uccidete ancora la bestia. ");
INSERT INTO ita1885_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Parimente, se alcuna donna si accosta ad alcuna bestia, per farsi coprire, uccidi la donna, e la bestia; del tutto facciansi morire; sia il lor sangue sopra loro. ");
INSERT INTO ita1885_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","E se alcuno prende la sua sorella, figliuola di suo padre, o figliuola di sua madre, e vede le sue vergogne, ed essa vede le vergogne di lui, ciò è cosa vituperosa; sieno adunque amendue sterminati alla vista de' figliuoli del lor popolo; colui ha scoperte le vergogne della sua sorella; porti la sua iniquità. ");
INSERT INTO ita1885_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","E se alcuno giace con donna che è nella sua immondizia, e scopre le sue vergogne, egli ha scoperto il flusso di quella donna, ed essa ha scoperto il flusso del suo sangue; perciò sieno amendue sterminati del mezzo del lor popolo. ");
INSERT INTO ita1885_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","E non iscoprir le vergogne della sorella di tua madre, o della sorella di tuo padre; perciocchè se alcuno scopre la carne loro, amendue porteranno la loro iniquità. ");
INSERT INTO ita1885_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","E se alcuno giace con la sua zia, egli ha scoperte le vergogne del suo zio; amendue porteranno il lor peccato; sieno fatti morire, e non abbiano figliuoli. ");
INSERT INTO ita1885_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Parimente, se alcuno prende la moglie del suo fratello, ciò è cosa brutta; colui ha scoperte le vergogne del suo fratello; sieno senza figliuoli. ");
INSERT INTO ita1885_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Osservate tutti i miei statuti, e tutte le mie leggi, e metteteli in opera; acciocchè il paese, dove io vi conduco per abitarvi, non vi vomiti fuori. ");
INSERT INTO ita1885_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","E non procedete secondo i costumi della nazione che io scaccio dal vostro cospetto; perciocchè essi hanno fatte tutte queste cose; onde io li ho avuti in abbominio. ");
INSERT INTO ita1885_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","E io vi ho detto: Voi possederete la terra loro, e io ve la darò per possederla; terra stillante latte e miele. Io sono il Signore Iddio vostro, che vi ho separati dagli altri popoli. ");
INSERT INTO ita1885_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","E però mettete differenza fra la bestia monda e l'immonda, e fra l'uccello mondo e l'immondo; e non rendete le vostre persone abbominevoli per quelle bestie, o per quegli uccelli, o per alcun rettile che serpe sopra la terra, i quali io vi ho separati per averli per immondi. ");
INSERT INTO ita1885_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","E siatemi santi; perciocchè io, il Signore, son santo; e vi ho separati dagli altri popoli, acciocchè siate miei. ");
INSERT INTO ita1885_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Se alcuno, uomo o donna, ha lo spirito di Pitone, o è indovino, del tutto sia fatto morire; sia lapidato; sia il sangue di tali persone sopra loro. ");
INSERT INTO ita1885_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","IL Signore disse, oltre a ciò, a Mosè: Parla a' sacerdoti, figliuoli di Aaronne, e di' loro: Non contaminisi alcun sacerdote fra' suoi popoli, per un morto, ");
INSERT INTO ita1885_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","se non è per alcun suo prossimo carnal parente; per sua madre, per suo padre, per suo figliuolo, per sua figliuola, e per suo fratello; ");
INSERT INTO ita1885_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","o per una sua sorella germana, che sia vergine, e che non abbia avuto marito; per una tale potrà contaminarsi. ");
INSERT INTO ita1885_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Non contaminisi fra' suoi popoli, come marito, in maniera che si renda immondo. ");
INSERT INTO ita1885_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Non dipelinsi il capo, e non radansi i canti della barba, e non facciansi tagliature nelle carni. ");
INSERT INTO ita1885_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Sieno santi all'Iddio loro, e non profanino il Nome dell'Iddio loro; conciossiachè essi offeriscano i sacrificii che si fanno per fuoco al Signore, le vivande dell'Iddio loro; perciò sieno santi. ");
INSERT INTO ita1885_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Non prendano donna meretrice, nè viziata, nè donna ripudiata dal suo marito; perciocchè son santi all'Iddio loro. ");
INSERT INTO ita1885_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Santificali adunque; conciossiachè essi offeriscano le vivande dell'Iddio tuo; sienti santi; perciocchè io, il Signore che vi santifico, son santo. ");
INSERT INTO ita1885_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","E se la figliuola di un sacerdote si contamina, fornicando, ella contamina suo padre; sia arsa col fuoco. ");
INSERT INTO ita1885_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Ma il Sacerdote, il sommo fra' suoi fratelli, sopra il cui capo sarà stato sparso l'olio dell'Unzione, e il quale sarà stato consacrato per vestire i vestimenti sacri, non iscoprasi il capo, e non isdruciscasi i vestimenti. ");
INSERT INTO ita1885_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","E non entri in luogo dove sia alcun corpo morto; non contaminisi, non pur per suo padre, nè per sua madre. ");
INSERT INTO ita1885_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","E non esca fuori del Santuario, e non contamini il Santuario dell'Iddio suo; perciocchè il Diadema dell'olio dell'Unzione dell'Iddio suo è sopra lui. Io sono il Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","E prendasi moglie che sia ancora vergine. ");
INSERT INTO ita1885_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Non prenda queste: nè vedova, nè ripudiata, nè viziata, nè meretrice; anzi, prenda per moglie una vergine dei suoi popoli. ");
INSERT INTO ita1885_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","E non contamini la sua progenie ne' suoi popoli; perciocchè io sono il Signore, che lo santifico. ");
INSERT INTO ita1885_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Il Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Parla ad Aaronne, e digli: Se alcuno della tua progenie, per le loro età, ha in sè alcun difetto, non s'appressi per offerir le vivande dell'Iddio suo. ");
INSERT INTO ita1885_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Perciocchè niun uomo, in cui sia difetto, vi si deve appressare; nè il cieco, nè lo zoppo, nè colui che ha il naso schiacciato, o smisurato. ");
INSERT INTO ita1885_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","Nè colui che ha rottura nel piè, o rottura nella mano. ");
INSERT INTO ita1885_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","Nè il gobbo, nè colui che ha panno o albugine nell'occhio, nè colui che ha scabbia, o volatica; nè l'ernioso. ");
INSERT INTO ita1885_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Niun uomo adunque, della progenie del Sacerdote Aaronne, in cui sia alcun difetto, s'appressi per offerire i sacrificii fatti per fuoco al Signore; vi è difetto in lui; perciò, non si appressi per offerir le vivande dell'Iddio suo. ");
INSERT INTO ita1885_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Ben potrà egli mangiar delle vivande dell'Iddio suo, così delle santissime, come delle sante. ");
INSERT INTO ita1885_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Ma non venga alla Cortina, e non si appressi all'Altare; perciocchè vi è in lui difetto; e non contamini i miei luoghi santi; perciocchè io sono il Signore che li santificio. ");
INSERT INTO ita1885_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","E Mosè disse queste cose ad Aaronne e a' suoi figliuoli, e a tutti i figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","IL Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Di' ad Aaronne e a' suoi figliuoli, che si astengano dalle cose sacre de' figliuoli d'Israele, e non profanino il mio Nome nelle cose che mi consacrano. Io sono il Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Di' loro: Se alcuno, di tutta la vostra progenie, nelle vostre generazioni, si appressa alla cose sacre, che i figliuoli di Israele avranno consacrate al Signore, avendo addosso la sua immondizia; quella persona sia ricisa dal mio cospetto. Io sono il Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Niuno, della progenie di Aaronne, che sia lebbroso, o che abbia la colagione, non mangi delle cose sacre, finchè non sia netto. Parimente, se alcuno ha toccata qualunque persona immonda per un morto, o se d'alcuno è uscito seme genitale; ");
INSERT INTO ita1885_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","o se alcuno ha tocco qual si voglia rettile, per lo quale sia renduto immondo; o alcun uomo, per lo quale sia renduto immondo, secondo qualunque sua immondizia; ");
INSERT INTO ita1885_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","la persona che l'avrà tocco sia immonda infino alla sera, e non mangi delle cose sacre, che prima ella non abbia lavate le sue carni con acqua. ");
INSERT INTO ita1885_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","E, ciò fatto, dopo che il sole sarà tramontato, sarà netta; e poi potrà mangiar delle cose sacre; perciocchè sono suo cibo. ");
INSERT INTO ita1885_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Non mangi il sacerdote alcuna carne di bestia morta da sè, o lacerata dalle fiere, per rendersi immondo. Io sono il Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Osservino adunque ciò che io ho comandato che si osservi, e non si carichino di peccato, e non muoiano per esso, se profanano questa mia ordinazione. Io sono il Signore che li santifico. ");
INSERT INTO ita1885_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","E niuno strano non mangi delle cose sacre; il forestiere del sacerdote, nè il suo mercenario, non mangino delle cose sacre. ");
INSERT INTO ita1885_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Ma, quando il sacerdote avrà comperata una persona co' suoi danari, essa ne potrà mangiare; parimente il servo natogli in casa; costoro potranno mangiare del cibo di esso. ");
INSERT INTO ita1885_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","E la figliuola del sacerdote, se è maritata a uno strano, non mangi dell'offerta delle cose sacre. ");
INSERT INTO ita1885_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Ma, se la figliuola del sacerdote è vedova, o ripudiata, senza aver figliuoli, e torna a stare in casa di suo padre, come nella sua fanciullezza; ella potrà mangiar delle vivande di suo padre; ma niuno straniere ne mangi. ");
INSERT INTO ita1885_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","E se pure alcuno mangia alcuna cosa sacra per errore, sopraggiungavi il quinto, e dialo al sacerdote, insieme con la cosa sacra. ");
INSERT INTO ita1885_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Non profanino adunque le cose sacre de' figliuoli d'Israele, le quali essi avranno offerte al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","E non si carichino d'iniquità di colpa, mangiando le cose da essi consacrate; perciocchè io sono il Signore che li santifico. ");
INSERT INTO ita1885_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","IL Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Parla ad Aaronne e a' suoi figliuoli, e a tutti i figliuoli d'Israele; e di' loro: Quando alcuno della casa d'Israele, ovvero de' forestieri che sono in Israele, offerirà la sua offerta, secondo tutti i lor voti, e le loro offerte volontarie, che offeriranno al Signore per olocausto; ");
INSERT INTO ita1885_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","acciocchè sia gradita per voi, sia un maschio senza difetto, d'infra i buoi, o d'infra le pecore, o d'infra le capre. ");
INSERT INTO ita1885_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Non offerite nulla che abbia difetto; perciocchè non sarebbe gradito per voi. ");
INSERT INTO ita1885_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Parimente, quando alcuno offerirà al Signore sacrificio da render grazie, o per singolar voto, o per offerta volontaria, sia quello di buoi, o di pecore, o di capre, senza difetto; acciocchè sia gradito; non siavi alcun difetto. ");
INSERT INTO ita1885_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Non offerite al Signore bestia alcuna cieca, nè che abbia alcun membro fiaccato, nè monca, nè porrosa, nè rognosa, nè scabbiosa; e non presentatene alcuna tale in su l'Altare al Signore, per offerta che si fa per fuoco. ");
INSERT INTO ita1885_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Ben potrai, per offerta volontaria, offerir bue, o pecora, o capra, che abbia alcun membro di manco, o di soverchio; ma per voto non sarebbe gradita. ");
INSERT INTO ita1885_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Non offerite al Signore alcun animale che abbia i granelli schiacciati, o infranti, o strappati, o ricisi; e non ne fate di tali nel vostro paese. ");
INSERT INTO ita1885_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Nè prendetene alcuni di man degli stranieri, per offerirne cibo al Signore; perciocchè il lor vizio è in essi; v' è in essi difetto; non sarebbero graditi per voi. ");
INSERT INTO ita1885_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Il Signore parlò ancora a Mosè dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Quando sarà nato un vitello, o un agnello, o un capretto, stia sette giorni sotto la madre; poi dall'ottavo giorno innanzi, sarà gradito per offerta da ardere al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","E non iscannate in uno stesso giorno la vacca, o la pecora, o la capra, col suo figlio. ");
INSERT INTO ita1885_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","E quando voi sacrificherete al Signore sacrificio di laude, sacrificatelo in maniera ch'egli sia gradito per voi. ");
INSERT INTO ita1885_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Mangisi nell'istesso giorno; non ne lasciate nulla di avanzo fino alla mattina seguente. Io sono il Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","E osservate i miei comandamenti, e metteteli in opera. Io sono il Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","E non profanate il mio santo Nome; onde io mi santifichi me stesso nel mezzo de' figliuoli d'Israele. Io sono il Signore che vi santifico; ");
INSERT INTO ita1885_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","che vi ho tratti fuor del paese di Egitto, per essere vostro Dio. Io sono il Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","IL Signore parlò, oltre a ciò, a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Parla a' figliuoli di Israele, e di' loro: Quant'è alle feste solenni del Signore, le quali voi bandirete per sante raunanze, queste son le mie feste solenni. ");
INSERT INTO ita1885_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Lavorisi sei giorni; ma, al settimo giorno, siavi riposo di Sabato, santa raunanza; non fate in esso lavoro alcuno; quel giorno è il Sabato del Signore, in tutte le vostre abitazioni. ");
INSERT INTO ita1885_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Queste sono le feste solenni del Signore, sante raunanze, le quali voi bandirete nelle loro stagioni: ");
INSERT INTO ita1885_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Nel primo mese, nel quartodecimo giorno del mese, fra i due vespri, è la Pasqua del Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","E nel quintodecimo giorno dell'istesso mese, è la festa degli azzimi, consacrata al Signore; mangiate per sette giorni pani azzimi. ");
INSERT INTO ita1885_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Siavi santa raunanza nel primo giorno, e non fate in esso alcuna opera servile. ");
INSERT INTO ita1885_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","E offerite offerte da ardere al Signore per sette giorni; e nel settimo giorno siavi santa raunanza; non fate in esso opera alcuna servile. ");
INSERT INTO ita1885_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Il Signore parlò, oltre a ciò, a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Parla a' figliuoli d'Israele, e di' loro: Quando voi sarete entrati nel paese, il quale io vi do, e ne mieterete la ricolta; portate al sacerdote una menata delle primizie della vostra ricolta. ");
INSERT INTO ita1885_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","E dimeni il sacerdote quella menata, davanti al Signore, in favor vostro; offeriscala il sacerdote il giorno appresso quel Sabato. ");
INSERT INTO ita1885_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","E nel giorno che voi offerirete quella menata, sacrificate un agnello di un anno, senza difetto, in olocausto al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","E sia la sua offerta di panatica di due decimi di fior di farina, stemperata con olio, per offerta da ardere al Signore, in odor soave; e la sua offerta da spandere sia della quarta parte di un hin di vino. ");
INSERT INTO ita1885_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","E non mangiate pane, nè grano arrostito, nè spighe fresche, fino a questo stesso giorno; finchè non abbiate portata l'offerta del vostro Iddio. Quest'è uno statuto perpetuo per le vostre generazioni, in tutte le vostre abitazioni. ");
INSERT INTO ita1885_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","E, dal giorno appresso quel Sabato, dal giorno che voi avrete portata la menata dell'offerta dimenata, contatevi sette settimane compiute. ");
INSERT INTO ita1885_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Contatevi cinquanta giorni, fino al giorno appresso la settima settimana; e allora offerite una nuova offerta di panatica al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Portate dalle vostre stanze, per primizie, al Signore, due pani per offerta dimenata, i quali sieno di due decimi di fior di farina, cotti con lievito. ");
INSERT INTO ita1885_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","E con que' pani offerite sette agnelli di un anno, senza difetto; e un giovenco, e due montoni; e sieno per olocausto al Signore, insieme con le loro offerte di panatica, e da spandere; per sacrificii da ardere, di soave odore al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Oltre a ciò, offerite un becco per sacrificio per lo peccato; e due agnelli di un anno per sacrificio da render grazie. ");
INSERT INTO ita1885_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","E offeriscali il sacerdote in offerta dimenata, davanti al Signore, insieme co' pani delle primizie, e co' due agnelli; sieno quelle cose sacre al Signore, per lo sacerdote. ");
INSERT INTO ita1885_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","E in quell'istesso giorno bandite la festa; esso vi sia giorno di santa raunanza; non fate in esso alcuna opera servile. Quest'è uno statuto perpetuo in tutte le vostre abitazioni, per le vostre generazioni. ");
INSERT INTO ita1885_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","E, quando voi mieterete la ricolta della vostra terra, non mietere affatto i canti del tuo campo, e non ispigolar le spighe della tua ricolta; lasciale al povero e al forestiere. Io sono il Signore Iddio vostro. ");
INSERT INTO ita1885_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Il Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Parla a' figliuoli d'Israele, dicendo: Nel settimo mese, nel primo giorno del mese, celebrate un Sabato una ricordanza con suon di tromba, una santa raunanza. ");
INSERT INTO ita1885_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Non fate in quel dì alcuna opera servile; e offerite al Signore offerte da ardere. ");
INSERT INTO ita1885_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Il Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Ma nel decimo giorno di questo settimo mese, ch'è il giorno de' purgamenti, celebrate una santa raunanza; e affliggete le vostre anime, e offerite offerte da ardere al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","E non fate in quel giorno lavoro alcuno; conciossiachè sia il giorno de' purgamenti, per far purgamento per voi, davanti al Signore Iddio vostro. ");
INSERT INTO ita1885_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Perciocchè, ogni persona che non sarà stata afflitta in quel giorno, sarà ricisa da' suoi popoli. ");
INSERT INTO ita1885_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","E se alcuna persona fa in quel giorno alcun lavoro, io la farò perire d'infra il suo popolo. ");
INSERT INTO ita1885_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Non fate in quel giorno lavoro alcuno. Quest'è uno statuto perpetuo, per le vostre generazioni, in tutte le vostre abitazioni. ");
INSERT INTO ita1885_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Siavi quel giorno riposo di Sabato; e affliggete le vostre persone; cominciando al nono dì del mese, in sul vespro; celebrate il vostro Sabato da un vespro all'altro. ");
INSERT INTO ita1885_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Il Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Parla a' figliuoli d'Israele, dicendo: In questo stesso settimo mese, nel quintodecimo giorno del mese, celebrisi al Signore la festa solenne de' Tabernacoli, per sette giorni. ");
INSERT INTO ita1885_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Nel primo giorno siavi santa raunanza; non fate in esso alcuna opera servile. ");
INSERT INTO ita1885_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Offerite per sette giorni offerte da ardere al Signore; e nell'ottavo giorno siavi santa raunanza, e offerite offerte da ardere al Signore; quel giorno è giorno di solenne raunanza; non fate in esso opera alcuna servile. ");
INSERT INTO ita1885_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Queste sono le feste solenni del Signore, le quali voi bandirete, acciocchè sieno sante raunanze, per offerire al Signore offerte da ardere, olocausti, offerte di panatica, sacrificii, ed offerte da spandere; in ciascun giorno ciò che conviene; ");
INSERT INTO ita1885_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","oltre a' Sabati del Signore, e oltre a' vostri doni, e oltre a tutti i vostri voti, e oltre a tutte le vostre offerte volontarie, che voi presenterete al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Or nel quintodecimo giorno del settimo mese, quando avrete ricolta la rendita della terra, celebrate la festa solenne del Signore per sette giorni; nel primo giorno siavi Sabato, e nell'ottavo giorno parimente siavi Sabato. ");
INSERT INTO ita1885_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","E nel primo giorno prendetevi del frutto di cedro, de' rami di palme, delle frasche di mortella, e de' salci di riviera; e rallegratevi nel cospetto del Signore Iddio vostro per sette giorni. ");
INSERT INTO ita1885_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","E celebrate quella festa al Signore per sette giorni, ogni anno. Quest'è uno statuto perpetuo per le vostre generazioni; celebratela al settimo mese. ");
INSERT INTO ita1885_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Dimorate in tabernacoli per sette giorni; dimori ognuno, che è natio d'Israele, in tabernacoli. ");
INSERT INTO ita1885_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Acciocchè le vostre generazioni sappiano che io ho fatto dimorare i figliuoli d'Israele in tabernacoli, quando io li ho tratti fuor del paese di Egitto. Io sono il Signore Iddio vostro. ");
INSERT INTO ita1885_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Così Mosè ordinò a' figliuoli d'Israele le feste solenni del Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","IL Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Comanda a' figliuoli d'Israele che ti rechino dell'olio di uliva, puro, vergine, per la lumiera, per tener del continuo le lampane accese. ");
INSERT INTO ita1885_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Mettale in ordine Aaronne nel Tabernacolo della convenenza, di fuori della Cortina della Testimonianza, dalla sera infino alla mattina, del continuo, davanti al Signore. Quest'è uno statuto perpetuo per le vostre generazioni. ");
INSERT INTO ita1885_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Metta del continuo in ordine le lampane in sul Candelliere puro, davanti al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Piglia, oltre a ciò, del fior di farina, e fanne dodici focacce, e cuocile; sia ciascuna focaccia di due decimi d'efa. ");
INSERT INTO ita1885_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","E mettile in due ordini, sei per ordine, sopra la Tavola pura, davanti al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","E metti dell'incenso puro sopra ciascun ordine; e sia quell'incenso per ricordanza di que' pani, per offerta che si fa per fuoco al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Mettansi per ordine, ogni giorno di Sabato, del continuo, nel cospetto del Signore, quelle focacce tolte da' figliuoli d'Israele, per patto perpetuo. ");
INSERT INTO ita1885_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","E sieno quelle per Aaronne e per i suoi figliuoli; ed essi le mangino in luogo santo; conciossiachè sieno cosa santissima, a lui appartenente dell'offerte che si hanno da ardere al Signore, per istatuto perpetuo. ");
INSERT INTO ita1885_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","OR un uomo, figliuolo di una donna Israelita, ma di padre Egizio, che stava per mezzo i figliuoli d'Israele, uscì fuori; ed egli e un Israelita contesero insieme nel campo. ");
INSERT INTO ita1885_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","E il figliuolo della donna Israelita bestemmiò il Nome, e lo maledisse; laonde fu condotto a Mosè; (or il nome di sua madre era Selomit, figliuola di Dibri, della tribù di Dan;) ");
INSERT INTO ita1885_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","e fu messo in prigione, finchè Mosè avesse dichiarato ciò che se ne avesse a fare, per comandamento del Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","E il Signore parlò a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Mena quel bestemmiatore fuor del campo; e posino tutti coloro che l'hanno udito le lor mani sopra il capo di esso, e lapidilo tutta la raunanza. ");
INSERT INTO ita1885_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","E parla a' figliuoli d'Israele, dicendo: Chiunque avrà maledetto il suo Dio, porti il suo peccato. ");
INSERT INTO ita1885_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","E chi avrà bestemmiato il Nome del Signore, del tutto sia fatto morire; in ogni modo lapidilo tutta la raunanza; sia fatto morire così lo straniere, come colui ch'è natio del paese, quando avrà bestemmiato il Nome. ");
INSERT INTO ita1885_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Parimente, chi avrà percossa a morte alcuna persona, del tutto sia fatto morire. ");
INSERT INTO ita1885_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","E chi avrà percossa alcuna bestia a morte, paghila; animale per animale. ");
INSERT INTO ita1885_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","E quando alcuno avrà fatta alcuna lesione corporale al suo prossimo, facciaglisi il simigliante di ciò ch'egli avrà fatto. ");
INSERT INTO ita1885_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Rottura per rottura, occhio per occhio, dente per dente; facciaglisi tal lesione corporale, quale egli avrà fatta ad altrui. ");
INSERT INTO ita1885_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Chi avrà percossa a morte una bestia, paghila; ma chi avrà percosso un uomo a morte, sia fatto morire. ");
INSERT INTO ita1885_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Abbiate una stessa ragione; sia il forestiere, come colui ch'è natio del paese; perciocchè io sono il Signore Iddio vostro. ");
INSERT INTO ita1885_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","E Mosè parlò a' figliuoli d'Israele; ed essi trassero quel bestemmiatore fuor del campo, e lo lapidarono con pietre. E i figliuoli d'Israele fecero come il Signore avea comandato a Mosè. ");
INSERT INTO ita1885_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","IL Signore parlò ancora a Mosè nel monte di Sinai, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Parla a' figliuoli d'Israele, e di' loro: Quando voi sarete entrati nel paese che io vi do, abbia la terra i suoi riposi, per maniera di Sabato al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Semina il tuo campo sei anni continui, e pota la tua vigna altresì sei anni continui, e ricogli la sua rendita. ");
INSERT INTO ita1885_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Ma l'anno settimo siavi riposo di Sabato per la terra; siavi Sabato al Signore; non seminare in esso il tuo campo, e non potar la tua vigna. ");
INSERT INTO ita1885_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Non mietere ciò che sarà nato da sè stesso da' granelli caduti nella tua ricolta; e non vendemmiar le uve della vigna che tu non avrai potata; sia quell'anno anno di riposo per la terra. ");
INSERT INTO ita1885_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","E ciò che sarà prodotto nell'anno del Sabato della terra sarà per mangiarlo, a te, e al tuo servo, e alla tua serva, e al tuo mercenario, e al tuo avveniticcio, i quali dimoreranno appresso di te, e alle tue bestie domestiche, ");
INSERT INTO ita1885_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","e alle fiere che saranno nel tuo paese; sia tutta la rendita di quell'anno per mangiare. ");
INSERT INTO ita1885_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Contati eziandio sette settimane di anni, sette volte sette anni; in maniera che il tempo delle sette settimane di anni ti sia lo spazio di quarantanove anni. ");
INSERT INTO ita1885_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","E nel settimo mese, nel decimo giorno del mese, fa' passare un suon di tromba; fate passar la tromba per tutto il vostro paese, nel giorno de' purgamenti. ");
INSERT INTO ita1885_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","E santificate l'anno cinquantesimo, e bandite franchigia nel paese, a tutti suoi abitanti; siavi quello il Giubileo; e allora ritorni ciascun di voi nella sua possessione, e alla sua famiglia. ");
INSERT INTO ita1885_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Quest'è il Giubileo; celebratelo ogni cinquantesimo anno; non seminate in esso, e non ricogliete ciò che in quell'anno sarà nato da sè stesso, e non vendemmiate le vigne che non saranno state potate. ");
INSERT INTO ita1885_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Perciocchè quello è il Giubileo; siavi sacro; mangiate ciò che il campo produrrà tolto dal campo stesso. ");
INSERT INTO ita1885_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","In quest'anno del Giubileo, ritorni ciascun di voi nella sua possessione. ");
INSERT INTO ita1885_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","E quando tu farai qualche vendita al tuo prossimo, ovvero qualche compera, niun di voi rapisca il bene del suo fratello. ");
INSERT INTO ita1885_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Compera dal tuo prossimo a ragione degli anni scorsi dopo il Giubileo; ed egli facciati la vendita a ragione degli anni della rendita. ");
INSERT INTO ita1885_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Secondo che vi saranno più o meno anni, accresci o scema il prezzo di ciò che tu compererai da lui; conciossiachè egli ti venda un certo numero di rendite. ");
INSERT INTO ita1885_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","E niun di voi rapisca il ben del suo prossimo; anzi abbi timore dell'Iddio tuo; perciocchè io sono il Signore Iddio vostro. ");
INSERT INTO ita1885_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Ed eseguite i miei statuti, e osservate le mie leggi, e mettetele in opera; e voi abiterete nel paese in sicurtà. ");
INSERT INTO ita1885_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","E la terra produrrà i suoi frutti, e voi ne mangerete a sazietà, e abiterete in essa in sicurtà. ");
INSERT INTO ita1885_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Che se pur dite: Che mangeremo l'anno settimo, se non seminiamo, e non ricogliamo le nostre rendite? ");
INSERT INTO ita1885_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Io comanderò alla mia benedizione che venga sopra voi l'anno sesto, e quell'anno produrrà frutto per tre anni. ");
INSERT INTO ita1885_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","E nell'anno ottavo voi seminerete, e mangerete del vecchio di quella ricolta, fino all'anno nono; voi mangerete del vecchio, finchè venga la ricolta di quell'anno. ");
INSERT INTO ita1885_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","OR non vendansi le terre assolutamente; conciossiachè la terra sia mia; perciocchè voi siete forestieri, e fittaiuoli appresso di me. ");
INSERT INTO ita1885_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Perciò, date luogo di riscatto delle terre in tutto il paese della vostra possessione. ");
INSERT INTO ita1885_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Quando il tuo fratello sarà impoverito, e avrà venduto della sua possessione; se il suo prossimo parente, il qual per consanguinità avrà la ragion del riscatto, si presenta, egli potrà riscattar ciò che il suo fratello avrà venduto. ");
INSERT INTO ita1885_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Ma, se alcuno, non avendo parente che per consanguinità abbia la ragion del riscatto, ricovera da sè stesso il modo, e trova quanto gli fa bisogno per lo suo riscatto; ");
INSERT INTO ita1885_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","allora conti le annate dopo la sua vendita, e restituisca il soprappiù a colui a chi avrà fatta la vendita, e rientri nella sua possessione. ");
INSERT INTO ita1885_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ma, s'egli non trova quanto gli fa bisogno per fargli il suo pagamento, resti quello ch'egli avrà venduto in man di colui che l'avrà comperato, fino all'anno del Giubileo; e nel Giubileo escane il comperatore, e rientri colui nella sua possessione. ");
INSERT INTO ita1885_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","E quando alcuno avrà venduta una casa da abitare, in città murata, siavi podestà di riscatto fino all'anno compiuto dopo la sua vendita; sia il termine del suo riscatto un anno intiero. ");
INSERT INTO ita1885_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Ma se non è ricomperata infra il compiersi di un anno intiero, quella casa che è in città murata resterà assolutamente in proprio a colui che l'avrà comperata, e a' suoi d'età in età; egli non sarà obbligato di uscirne nel Giubileo. ");
INSERT INTO ita1885_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Ma le case delle ville, non intorniate di mura, sieno reputate come possessioni di terra; siavi ragion di riscatto per esse, ed escane il comperatore nel Giubileo. ");
INSERT INTO ita1885_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Ma, quant'è alle città de' Leviti, abbiano i Leviti in perpetuo ragion di ricompera in su le case delle città della lor possessione. ");
INSERT INTO ita1885_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","E colui de' Leviti, che ricompererà alcuna casa, esca fuori della casa venduta, e della città della possession del venditore, nel Giubileo; perciocchè le case delle città de' Leviti sono la lor possessione nel mezzo de' figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Ma non vendansi i campi de' contorni delle lor città; perciocchè sono loro una possessione perpetua. ");
INSERT INTO ita1885_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","E quando il tuo fratello sarà impoverito, e le sue facoltà saranno scadute appresso di te, porgigli la mano, forestiere o avveniticcio che egli si sia; acciocchè possa vivere appresso di te. ");
INSERT INTO ita1885_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Non prender da lui usura nè profitto; e abbi timore dell'Iddio tuo, e fa' che il tuo fratello possa vivere appresso di te. ");
INSERT INTO ita1885_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Non dargli i tuoi danari ad usura, nè la tua vittuaglia a profitto. ");
INSERT INTO ita1885_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Io sono il Signore Iddio vostro, che vi ho tratti fuor del paese di Egitto, per darvi il paese di Canaan, per essere vostro Iddio. ");
INSERT INTO ita1885_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","E quando il tuo fratello sarà impoverito appresso di te, e si sarà venduto a te, non adoperarlo in servitù da schiavo. ");
INSERT INTO ita1885_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Stia appresso di te a guisa di mercenario o di avveniticcio; serva appresso di te fino all'anno del Giubileo. ");
INSERT INTO ita1885_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","E allora egli si partirà d'appresso a te, insieme co' suoi figliuoli, e se ne ritornerà alla sua famiglia; e rientrerà nella possessione de' suoi padri. ");
INSERT INTO ita1885_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Perciocchè essi sono miei servitori, avendoli io tratti fuor del paese di Egitto; e però non sieno venduti nella maniera degli schiavi. ");
INSERT INTO ita1885_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Non signoreggiarlo con asprezza; anzi abbi timore dell'Iddio tuo. ");
INSERT INTO ita1885_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Ma, quant'è al tuo servo, e alla tua serva, che hanno ad esser tuoi in proprio, compera servi e serve d'infra le genti che saranno intorno a te. ");
INSERT INTO ita1885_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Anche ne potrete comperar de' figliuoli degli avveniticci che dimoreranno con voi; e delle lor famiglie che saranno appresso di voi, le quali essi avranno generate nel vostro paese; e quelli saranno vostri in proprio. ");
INSERT INTO ita1885_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","E tali potrete possedere, e lasciare a' vostri figliuoli dopo voi in proprietà ereditaria; e anche servirvi di loro in perpetuo; ma, quant'è a' vostri fratelli, figliuoli d'Israele, niuno di voi signoreggi il suo fratello con asprezza. ");
INSERT INTO ita1885_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","E se il forestiere, o l'avveniticcio che sarà appresso di te, acquista delle facoltà, e il tuo fratello impoverisce appresso a lui, e si vende al forestiere, o all'avveniticcio che sarà appresso di te, o a qualcuno di stirpe di nazione straniera; ");
INSERT INTO ita1885_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","abbia egli podestà di riscatto, dopo essersi venduto; riscattilo alcuno de' suoi fratelli. ");
INSERT INTO ita1885_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Riscattilo il suo zio, o il figliuol del suo zio, o alcun altro suo carnal parente, della sua famiglia; ovvero, riscattisi egli stesso, se ne trova il modo. ");
INSERT INTO ita1885_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","E faccia ragione col suo comperatore, dall'anno che gli si sarà venduto fino all'anno del Giubileo, e vadano i danari della sua vendita per lo numero degli anni ch'egli avrà servito; stia con lui come a giornate di mercenario. ");
INSERT INTO ita1885_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Se vi sono ancora molti anni fino al Giubileo, restituisca a ragione di essi, de' danari della sua compera, per suo riscatto. ");
INSERT INTO ita1885_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","E se vi restano pochi anni fino all'anno del Giubileo, faccia ragione con lui; e restituisca il prezzo del suo riscatto, secondo il numero degli anni che gli restano da servire. ");
INSERT INTO ita1885_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Stia con lui a guisa di mercenario annuale; non signoreggilo con asprezza nel tuo cospetto. ");
INSERT INTO ita1885_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","E se pur non è riscattato in alcuna di queste maniere, egli se ne uscirà l'anno del Giubileo, insieme coi suoi figliuoli. ");
INSERT INTO ita1885_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Conciossiachè i figliuoli d'Israele mi sieno servi; sono miei servi, avendoli io tratti fuor del paese di Egitto. Io sono il Signore Iddio vostro. ");
INSERT INTO ita1885_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","NON vi fate idoli, e non vi rizzate scultura, nè statua, e non mettete alcuna pietra effigiata nel vostro paese, per adorarla; perciocchè io sono il Signore Iddio vostro. ");
INSERT INTO ita1885_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Osservate i miei Sabati; e riverite il mio Santuario. Io sono il Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Se voi camminate ne' miei statuti, e osservate i miei comandamenti, e li mettete in opera; ");
INSERT INTO ita1885_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","io vi darò le vostre pioggie nelle loro stagioni, e la terra produrrà la sua rendita, e gli alberi della campagna produrranno i lor frutti. ");
INSERT INTO ita1885_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","E la trebbiatura vi giungerà infino alla vendemmia, e la vendemmia giungerà infino alla sementa; e voi mangerete il vostro pane a sazietà, e abiterete nel vostro paese in sicurtà. ");
INSERT INTO ita1885_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","E io farò che vi sarà pace nel paese, e voi vi coricherete, e non vi sarà chi vi spaventi; e farò venir meno le bestie nocive nel paese, e la spada non passerà per lo vostro paese. ");
INSERT INTO ita1885_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","E voi perseguirete i vostri nemici, ed essi caderanno per la spada davanti a voi. ");
INSERT INTO ita1885_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","E cinque di voi ne perseguiranno cento, e cento ne perseguiranno diecimila; e i vostri nemici caderanno per la spada davanti a voi. ");
INSERT INTO ita1885_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","E io mi volgerò verso voi, e vi farò crescere e moltiplicare; e stabilirò il mio patto con voi. ");
INSERT INTO ita1885_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","E voi mangerete del vecchio, serbato per molto tempo; e trarrete fuori il vecchio, per dar luogo al nuovo. ");
INSERT INTO ita1885_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","E io farò che il mio Tabernacolo starà nel mezzo di voi; e l'anima mia non vi sdegnerà. ");
INSERT INTO ita1885_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","E camminerò nel mezzo di voi, e vi sarò Dio, e voi mi sarete popolo. ");
INSERT INTO ita1885_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Io sono il Signore Iddio vostro, che vi ho tratti fuor del paese degli Egizj, acciocchè non foste loro servi; e ho spezzate le sbarre del vostro giogo, e vi ho fatti camminare a capo erto. ");
INSERT INTO ita1885_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Ma, se voi non mi ubbidite, e non mettete in opera tutti questi comandamenti; ");
INSERT INTO ita1885_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","e se sprezzate i miei statuti, e se l'anima vostra sdegna le mie leggi, per non eseguire tutti i miei comandamenti, per annullare il mio patto; ");
INSERT INTO ita1885_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","io altresì vi farò queste cose: io manderò contr'a voi lo spavento, la tisichezza, e l'arsura, che vi consumeranno gli occhi, e vi tormenteranno l'anima; e voi seminerete indarno la vostra semenza; perciocchè i vostri nemici la mangeranno. ");
INSERT INTO ita1885_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","E io metterò la mia faccia contro a voi, e sarete sconfitti da' vostri nemici, e quelli che vi odieranno, vi signoreggeranno; e voi fuggirete, senza che alcuno vi persegua. ");
INSERT INTO ita1885_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","E se pur anche, dopo queste cose, voi non mi ubbidite, io continuerò a castigarvi per i vostri peccati sette volte più. ");
INSERT INTO ita1885_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","E romperò l'alterezza della vostra forza; e farò che il vostro cielo sarà come di ferro, e la vostra terra come di rame. ");
INSERT INTO ita1885_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","E la vostra forza si consumerà indarno; e la vostra terra non darà la sua rendita, nè gli alberi della campagna i lor frutti. ");
INSERT INTO ita1885_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","E se voi procedete meco con contrasto, e non volete ubbidirmi, io vi aggiugnerò sette cotanti di piaghe, secondo i vostri peccati. ");
INSERT INTO ita1885_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","E manderò contro a voi le fiere della campagna, le quali vi orberanno di figliuoli, e diserteranno il vostro bestiame, e vi dipopoleranno, e le vostre strade saranno deserte. ");
INSERT INTO ita1885_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","E se pur anche per queste cose voi non vi ammendate inverso me, anzi procedete meco con contrasto; ");
INSERT INTO ita1885_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","io altresì procederò con voi con contrasto e vi percoterò anch'io sette volte più, per i vostri peccati. ");
INSERT INTO ita1885_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","E farò venir contro a voi la spada, che farà la vendetta del patto; e voi vi ricovererete nelle vostre città; ma io manderò nel mezzo di voi la pestilenza, e sarete dati nelle mani dei nemici. ");
INSERT INTO ita1885_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Quando io vi avrò rotto il sostentamento del pane, dieci donne coceranno il vostro pane in uno stesso forno, e vi renderanno il vostro pane a peso; e voi mangerete, e non vi sazierete. ");
INSERT INTO ita1885_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","E se per questo ancora non mi ubbidite, anzi procedete meco con contrasto; ");
INSERT INTO ita1885_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","io ancora procederò con voi con ira e con contrasto; e io ancora vi castigherò sette volte più, per i vostri peccati. ");
INSERT INTO ita1885_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","E mangerete la carne de' vostri figliuoli, e la carne delle vostre figliuole. ");
INSERT INTO ita1885_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","E io disfarò i vostri alti luoghi, e distruggerò i vostri idoli, e metterò i vostri corpi morti sopra le carogne dei vostri idoli; e l'anima mia vi avrà in abbominio. ");
INSERT INTO ita1885_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","E ridurrò le vostre città in desolazione, e diserterò i vostri santuari, e non odorerò i vostri odori soavi. ");
INSERT INTO ita1885_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","E io stesso desolerò il paese; e i vostri nemici, che abiteranno in esso, ne saranno stupefatti. ");
INSERT INTO ita1885_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","E, quant'è a voi, io vi disperderò fra le genti, e vi sarò dietro a spada tratta; e il vostro paese sarà deserto, e le vostre città desolate. ");
INSERT INTO ita1885_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Allora la terra si compiacerà ne' suoi Sabati, tutto il tempo ch'ella resterà deserta, e che voi sarete nel paese dei vostri nemici; allora la terra si riposerà, e si compiacerà ne' suoi Sabati. ");
INSERT INTO ita1885_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Ella si riposerà tutto il tempo ch'ella starà deserta di ciò che non si sarà riposata ne' vostri Sabati, mentre voi sarete dimorati in essa. ");
INSERT INTO ita1885_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","E, quant'è a quelli che di voi saranno rimasti, io manderò loro un avvilimento di cuore ne' paesi de' lor nemici; talchè eziandio il rumor d'una fronde agitata li perseguiterà, e fuggiranno, come d'innanzi alla spada; e caderanno, senza che alcuno li persegua. ");
INSERT INTO ita1885_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","E traboccheranno l'uno sopra l'altro, come se fuggissero davanti alla spada, senza però che alcuno li perseguiti; e voi non potrete durar davanti a' vostri nemici. ");
INSERT INTO ita1885_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","E perirete fra le genti, e il paese de' vostri nemici vi consumerà. ");
INSERT INTO ita1885_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Ma, se pur que' di voi che saranno rimasti si struggono nel paese de' lor nemici, per le loro iniquità, e insieme per quelle de' lor padri; ");
INSERT INTO ita1885_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","e confessano la loro iniquità, e l'iniquità de' lor padri, ne' lor misfatti che avranno commessi contro a me; ed anche in ciò che saranno proceduti meco con contrasto; ");
INSERT INTO ita1885_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","onde io ancora sarò proceduto con loro con contrasto; e li avrò condotti nel paese de' lor nemici; se allora il lor cuore incirconciso si umilia, e se di buon grado riconoscono la loro iniquità; ");
INSERT INTO ita1885_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","io ancora mi ricorderò del mio pattocon Giacobbe, e anche del mio patto con Isacco, e anche del mio patto con Abrahamo; mi ricorderò eziandio del paese. ");
INSERT INTO ita1885_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Appresso adunque che la terra sarà stata disabitata di essi, e si sarà compiaciuta ne' suoi Sabati, mentre sarà stata desolata, essendone essi fuori; ed essi di buon grado avranno riconosciuta la loro iniquità, perciocchè avranno sprezzate le mie leggi, e l'anima loro avrà sdegnati i miei statuti; ");
INSERT INTO ita1885_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","e che nondimeno, mentre saranno stati nel paese de'lor nemici, io non li avrò riprovati, e non li avrò avuti in abbominio, per ridurli al niente, annullando il mio patto con loro; perciocchè io sono il Signore Iddio loro; ");
INSERT INTO ita1885_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","io mi ricorderò in favor loro del patto degli antichi loro, i quali io trassi fuor del paese di Egitto, nel cospetto delle genti, per essere loro Dio. Io sono il Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Questi sono gli statuti, e le ordinazioni, e le leggi, le quali il Signore stabilì fra sè, e i figliuoli d'Israele, nel monte di Sinai, per mano di Mosè. ");
INSERT INTO ita1885_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","IL Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Parla a' figliuoli d'Israele, e di' loro: Quando alcuno avrà fatto qualche singolar voto; quando egli avrà fatto voto di persone al Signore, sotto la tua estimazione; ");
INSERT INTO ita1885_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","l'estimazione che tu farai, d'un maschio di età di venti anni fino a sessant'anni, sia a cinquanta sicli d'argento, a siclo di Santuario. ");
INSERT INTO ita1885_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","E d'una femmina, sia la tua estimazione a trenta sicli. ");
INSERT INTO ita1885_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","E se è una persona di età da cinque anni a venti, sia la tua estimazione a venti sicli per lo maschio, e a dieci sicli per la femmina. ");
INSERT INTO ita1885_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","E se è una persona di età da un mese a cinque anni, sia la tua estimazione a cinque sicli d'argento per lo maschio, e a tre sicli d'argento per la femmina. ");
INSERT INTO ita1885_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","E se è una persona di età da sessant'anni in su, sia la tua estimazione a quindici sicli per lo maschio, e a dieci sicli per la femmina. ");
INSERT INTO ita1885_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","E se colui che avrà fatto il voto sarà così povero, che non possa pagar la tua estimazione, presenti la persona votata davanti al Sacerdote, il qual ne faccia l'estimazione; facciala secondo la possibilità di colui che avrà fatto il voto. ");
INSERT INTO ita1885_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","E se il voto è di bestia della quale si offerisce offerta al Signore, tutto ciò che egli avrà di quella specie donato al Signore sia sacro. ");
INSERT INTO ita1885_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Non cambila, e non permutila, buona per cattiva, nè cattiva per buono; e se pur permuta quella bestia con un'altra, così la bestia votata, come la bestia messa in iscambio suo, saranno sacre. ");
INSERT INTO ita1885_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","E se il voto è di qualunque bestia immonda, della quale non si offerisce offerta al Signore, presenti quella bestia davanti al Sacerdote. ");
INSERT INTO ita1885_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","E facciane il Sacerdote l'estimazione secondo che sarà buona o cattiva; facciasene secondo l'estimazione, che tu, o Sacerdote, ne avrai fatta. ");
INSERT INTO ita1885_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","E se pure egli vuol riscattarla, sopraggiunga il quinto del prezzo di essa, oltre alla tua estimazione. ");
INSERT INTO ita1885_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","E quando alcuno avrà consacrata la casa sua, per esser cosa sacra al Signore, apprezzila il Sacerdote, secondo che sarà buona o cattiva; resti fermo il suo prezzo, quale il Sacerdote le avrà posto. ");
INSERT INTO ita1885_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","E se pur colui che avrà consacrata la sua casa la vuol riscattare, sopraggiunga alla tua estimazione il quinto del prezzo di essa, e sia sua. ");
INSERT INTO ita1885_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","E se alcuno consacra al Signore dei campi della sua eredità, sia la tua estimazione a ragione della sementa di esso; la sementa d'un omer d'orzo sia estimata a cinquanta sicli di argento. ");
INSERT INTO ita1885_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Se egli consacra il suo campo fin dall'anno del Giubileo, stia fermo il prezzo di esso, come tu l'avrai tassato. ");
INSERT INTO ita1885_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Ma, se egli lo consacra dopo il Giubileo, faccia il Sacerdote ragion de' danari col comperatore secondo gli anni che resteranno fino all'anno del Giubileo, e secondo il numero di essi diffalchisi della tua estimazione. ");
INSERT INTO ita1885_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","E se colui che ha consacrato il campo, pur vuol riscattarlo, sopraggiunga alla tua estimazione il quinto dei danari di essa, e resti il campo suo. ");
INSERT INTO ita1885_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Ma, se egli non riscatta il campo, e il campo è venduto ad un altro, non possa più riscattarlo. ");
INSERT INTO ita1885_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","E quando il comperatore ne uscirà al Giubileo, sia cosa sacra al Signore, come campo d'interdetto; appartenga esso in proprio al Sacerdote. ");
INSERT INTO ita1885_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","E se alcuno ha consacrato al Signore un campo da sè comperato, il qual non sia de' campi della sua eredità; ");
INSERT INTO ita1885_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","faccia il Sacerdote ragione col comperatore della somma della tua estimazione, secondo il tempo che vi sarà fino all'anno del Giubileo; e dia colui in quello stesso giorno il prezzo da te posto; è cosa sacra al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Nell'anno del Giubileo ritorni il campo a colui da chi esso l'avrà comperato, a colui di cui sarà la proprietà del terreno. ");
INSERT INTO ita1885_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Or sia ogni tua estimazione a siclo di Santuario; sia il siclo di venti oboli. ");
INSERT INTO ita1885_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Ma niuno consacri alcun primogenito di bestie, delle quali s'offeriscono i primogeniti al Signore; o vitello, o agnello, o capretto ch'egli sia, già appartiene al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Ma, se è degli animali immondi, riscattilo secondo la tua estimazione, e sopraggiungavi il quinto di essa; e se pur non è riscattato, vendasi secondo il prezzo da te posto. ");
INSERT INTO ita1885_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Ma niuna cosa consacrata per interdetto, che l'uomo abbia consacrata al Signore per interdetto, di tutto ciò ch'è suo, così degli uomini, come del bestiame, e de' campi della sua eredità, non si potrà vendere nè riscattare; ogni interdetto è cosa santissima, appartenente al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Niuno interdetto, consacrato d'infra gli uomini, si possa riscattare; del tutto sia fatto morire. ");
INSERT INTO ita1885_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Tutte le decime eziandio della terra così delle semenze della terra, come dei frutti degli alberi, appartengono al Signore; son cosa sacra al Signore. ");
INSERT INTO ita1885_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","E se pure alcuno vuol riscattar delle sue decime, sopraggiunga il quinto al prezzo di esse. ");
INSERT INTO ita1885_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Parimente sia cosa sacra al Signore ogni decima di buoi, e di pecore, e di capre; ogni decimo animale di tutti quelli che passano sotto la verga. ");
INSERT INTO ita1885_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Non discernasi tra buono e cattivo; e non permutisi l'un con l'altro; e se pure alcuno permuta l'un con l'altro, quel decimo, e quell'altro messo in suo scambio, saranno cosa sacra; non si potranno riscattare. ");
INSERT INTO ita1885_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Questi sono i comandamenti che il Signore diede a Mosè, nel monte di Sinai, per proporli a' figliuoli d'Israele.");
INSERT INTO ita1885_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","IL Signore parlò ancora a Mosè, nel deserto di Sinai, nel Tabernacolo della convenenza, nel primo giorno del secondo mese, nell'anno secondo da che i figliuoli d'Israele furono usciti fuor del paese di Egitto, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Levate la somma di tutta la raunanza de' figliuoli d'Israele, secondo le lor nazioni, e le famiglie de' padri loro, contando per nome, a testa a testa, ogni maschio, ");
INSERT INTO ita1885_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","di età da vent'anni in su, tutti coloro che possono andare alla guerra in Israele; annoverateli, tu, ed Aaronne, per le loro schiere. ");
INSERT INTO ita1885_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","E siavi con voi un uomo di ciascuna tribù, che sia capo della sua casa paterna. ");
INSERT INTO ita1885_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","E questi sono i nomi di coloro che saranno presenti con voi: Di Ruben, Elisur, figliuolo di Sedeur; ");
INSERT INTO ita1885_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Di Simeone, Selumiel, figliuolo di Surisaddai; ");
INSERT INTO ita1885_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Di Giuda, Naasson, figliuolo di Amminadab; ");
INSERT INTO ita1885_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","D'Issacar, Natanael, figliuolo di Suar; ");
INSERT INTO ita1885_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Di Zabulon, Eliab, figliuolo di Helon; ");
INSERT INTO ita1885_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","De' figliuoli di Giuseppe: di Efraim, Elisama, figliuoli di Ammiud; di Manasse, Gamliel, figliuolo di Pedasur; ");
INSERT INTO ita1885_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Di Beniamino, Abidan, figliuolo di Ghidoni; ");
INSERT INTO ita1885_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Di Dan, Ahiezer, figliuolo di Ammisaddai; ");
INSERT INTO ita1885_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Di Aser, Paghiel, figliuolo di Ocran; ");
INSERT INTO ita1885_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Di Gad, Eliasaf, figliuolo di Deuel; ");
INSERT INTO ita1885_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Di Neftali, Ahira, figliuolo di Enan. ");
INSERT INTO ita1885_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Costoro erano quelli che si chiamavano alla raunanza, principali delle tribù loro paterne, e capi delle migliaia d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Mosè adunque ed Aaronne presero seco questi uomini, ch'erano stati nominati per li nomi loro. ");
INSERT INTO ita1885_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","E, a' calendi del secondo mese, adunarono tutta la raunanza; e le generazioni de' figliuoli d'Israele furono descritte per le lor nazioni, e per le famiglie loro paterne, contandoli per nome dall'età di vent'anni in su, a testa a testa. ");
INSERT INTO ita1885_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Come il Signore avea comandato a Mosè, egli li annoverò nel deserto di Sinai. ");
INSERT INTO ita1885_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","E delle generazioni de' figliuoli di Ruben, primogenito d'Israele, per le lor nazioni, e famiglie paterne, contati per nome, a testa a testa, d'infra tutti i maschi, dall'età di vent'anni in su, tutti quelli che potevano andare alla guerra; ");
INSERT INTO ita1885_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","gli annoverati della tribù di Ruben furono quarantaseimila cinquecento. ");
INSERT INTO ita1885_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Delle generazioni de' figliuoli di Simeone, per le lor nazioni, e famiglie paterne, contati per nome, a testa a testa, d'infra tutti i maschi, dall'età di vent'anni in su, tutti quelli che potevano andare alla guerra; ");
INSERT INTO ita1885_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","gli annoverati della tribù di Simeone furono cinquantanovemila trecento. ");
INSERT INTO ita1885_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Delle generazioni de' figliuoli di Gad, per le lor nazioni, e famiglie paterne, contati per nome tutti quelli che potevano andare alla guerra, dall'età di vent'anni in su; ");
INSERT INTO ita1885_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","gli annoverati della tribù di Gad furono quarantacinquemila seicencinquanta. ");
INSERT INTO ita1885_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Delle generazioni de' figliuoli di Giuda, per le lor nazioni, e famiglie paterne, contati per nome tutti quelli che potevano andare alla guerra, dall'età di vent'anni in su; ");
INSERT INTO ita1885_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","gli annoverati della tribù di Giuda furono settantaquattromila seicento. ");
INSERT INTO ita1885_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Delle generazioni de' figliuoli d'Issacar, per le lor nazioni, e famiglie paterne, contati per nome tutti quelli che potevano andare alla guerra, dall'età di vent'anni in su; ");
INSERT INTO ita1885_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","gli annoverati della tribù d'Issacar furono cinquantaquattromila quattrocento. ");
INSERT INTO ita1885_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Delle generazioni de' figliuoli di Zabulon, per le lor nazioni, e famiglie paterne, contati per nome tutti quelli che potevano andare alla guerra, dall'età di vent'anni in su; ");
INSERT INTO ita1885_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","gli annoverati della tribù di Zabulon furono cinquantasettemila quattrocento. ");
INSERT INTO ita1885_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","De' figliuoli di Giuseppe; delle generazioni de' figliuoli di Efraim, per le lor nazioni, e famiglie paterne, contati per nome tutti quelli che potevano andare alla guerra, dall'età di vent'anni in su; ");
INSERT INTO ita1885_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","gli annoverati della tribù di Efraim furono quarantamila cinquecento. ");
INSERT INTO ita1885_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Delle generazioni de' figliuoli di Manasse, per le lor nazioni, e famiglie paterne, contati per nome tutti quelli che potevano andare alla guerra, dall'età di vent'anni in su; ");
INSERT INTO ita1885_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","gli annoverati della tribù di Manasse furono trentaduemila dugento. ");
INSERT INTO ita1885_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Delle generazioni de' figliuoli di Beniaminio, per le lor nazioni, e famiglie paterne, contati per nome tutti quelli che potevano andare alla guerra, dall'età di vent'anni in su; ");
INSERT INTO ita1885_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","gli annoverati della tribù di Beniamino furono trentacinquemila quattrocento. ");
INSERT INTO ita1885_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Delle generazioni de' figliuoli di Dan, per le lor nazioni, e famiglie paterne, contati per nome tutti quelli che potevano andare alla guerra, dall'età di vent'anni in su; ");
INSERT INTO ita1885_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","gli annoverati della tribù di Dan furono sessantaduemila settecento. ");
INSERT INTO ita1885_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Delle generazioni de' figliuoli di Aser, per le lor nazioni, e famiglie paterne; contati per nome tutti quelli che potevano andare alla guerra, dall'età di vent'anni in su; ");
INSERT INTO ita1885_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","gli annoverati della tribù di Aser furono quarantunmila cinquecento. ");
INSERT INTO ita1885_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Delle generazioni de' figliuoli di Neftali, per le lor nazioni, e famiglie paterne, contati per nome tutti quelli che potevano andare alla guerra, dall'età di vent'anni in su; ");
INSERT INTO ita1885_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","gli annoverati della tribù di Neftali furono cinquantatremila quattrocento. ");
INSERT INTO ita1885_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Questi furono gli annoverati, i quali Mosè ed Aaronne annoverarono, insieme co' principali d'Israele, ch' erano dodici uomini, uno per familglia paterna. ");
INSERT INTO ita1885_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Così, tutti gli annoverati d'infra i figliuoli d'Israele, per le lor famiglie paterne, dall'età di vent'anni in su, che potevano andare alla guerra, ");
INSERT INTO ita1885_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","furono seicentotremila cinquecencinquanta. ");
INSERT INTO ita1885_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Ma i Leviti non furono annoverati fra loro secondo la lor tribù paterna; ");
INSERT INTO ita1885_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","perciocchè il Signore avea detto a Mosè: ");
INSERT INTO ita1885_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Sol non annoverar la tribù di Levi, e non levarne la somma per mezzo i figliuoli d'Iraele. ");
INSERT INTO ita1885_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Ma ordina i Leviti sopra il Tabernacolo della Testimonianza, e sopra tutti i suoi arredi; e sopra tutte le cose ad esso appartenenti; e portino essi il Tabernacolo e tutti i suoi arredi; e facciano i servigi di esso, e accampinvisi attorno. ");
INSERT INTO ita1885_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","E quando il Tabernacolo si dipartirà, mettanlo giù i Leviti; quando altresì si accamperà, rizzinlo i Leviti; e se alcuno straniere vi si appressa, sia fatto morire. ");
INSERT INTO ita1885_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Or accampinsi i figliuoli d'Israele, ciascuno nel suo quartiere, e ciascuno presso alla sua bandiera, per le loro schiere. ");
INSERT INTO ita1885_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Ma accampinsi i Leviti intorno al Tabernacolo della Testimonianza; acciocchè non vi sia ira contro alla raunanza de' figliuoli d'Israele; e facciano i Leviti la funzione del Tabernacolo della Testimonianza. ");
INSERT INTO ita1885_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","E i figliuoli d'Israele fecero interamente come il Signore avea comandato. ");
INSERT INTO ita1885_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","POI il Signore parlò a Mosè e ad Aaronne, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Accampinsi i figliuoli d'Israele, ciascuno presso alla sua bandiera, distinti per le insegne delle lor famiglie paterne; accampinsi dirincontro al Tabernacolo della convenenza d'ogn'intorno. ");
INSERT INTO ita1885_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","E quelli che si accamperanno dalla parte anteriore, verso il Levante, sieno que' della bandiera del campo di Giuda distinti per le loro schiere; e sia il lor capo Naasson, figliuolo di Amminadab. ");
INSERT INTO ita1885_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","La cui schiera, e gli annoverati, son settantaquattromila seicento. ");
INSERT INTO ita1885_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","E quelli che si accamperanno presso a lui, sieno la tribù d'Issacar e sia capo de' figliuoli d'Issacar Natanael, figliuolo di Suar. ");
INSERT INTO ita1885_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","La cui schiera, e gli annoverati, son cinquantaquattromila quattrocento. ");
INSERT INTO ita1885_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","E la tribù di Zabulon; e sia capo de' figliuoli di Zabulon Eliab, figliuolo di Helon. ");
INSERT INTO ita1885_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","La cui schiera, e gli annoverati, son cinquantasettemila quattrocento. ");
INSERT INTO ita1885_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Tutti gli annoverati del campo in Giuda son centottantaseimila quattrocento, distinti per le loro schiere. Questi si moveranno i primi. ");
INSERT INTO ita1885_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Sia la bandiera del campo di Ruben, distinta per le sue schiere, verso il Mezzodì; e sia capo de' figliuoli di Ruben Elisur, figliuolo di Sedeur. ");
INSERT INTO ita1885_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","La cui schiera, e gli annoverati, son quarantaseimila cinquecento. ");
INSERT INTO ita1885_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","E quelli che si accamperanno presso a lui sieno la tribù di Simeone; e sia capo de' figliuoli di Simeone Selumiel, figliuolo di Surisaddai. ");
INSERT INTO ita1885_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","La cui schiera, e gli annoverati, son cinquantanovemila trecento. ");
INSERT INTO ita1885_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","E la tribù di Gad; e sia capo de' figliuoli di Gad Eliasaf, figliuolo di Reuel. ");
INSERT INTO ita1885_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","La cui schiera, e gli annoverati, son quarantacinquemila seicencinquanta. ");
INSERT INTO ita1885_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Tutti gli annoverati del campo di Ruben son cencinquantunmila quattrocencinquanta, distinti per le loro schiere. Questi movansi i secondi. ");
INSERT INTO ita1885_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Poi movasi il Tabernacolo della convenenza, essendo l'oste de' Leviti nel mezzo degli altri campi; come sono accampati, così movansi, ciascuno nel suo ordine, secondo le lor bandiere. ");
INSERT INTO ita1885_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Sia la bandiera del campo di Efraim, distinta per le sue schiere, verso il Ponente; e sia capo de' figliuoli di Efraim Elisama, figliuolo di Ammiud. ");
INSERT INTO ita1885_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","La cui schiera, e gli annoverati, son quarantamila cinquecento. ");
INSERT INTO ita1885_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","E presso a lui si accampi la tribù di Manasse; e sia capo de' figliuoli di Manasse Gamliel, figliuolo di Pedasur. ");
INSERT INTO ita1885_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","La cui schiera, e gli annoverati, son trentaduemila dugento. ");
INSERT INTO ita1885_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","E la tribù di Beniamino; e sia capo de' figliuoli di Beniamino Abidan, figliuolo di Ghidoni. ");
INSERT INTO ita1885_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","La cui schiera, e gli annoverati, son trentacinquemila quattrocento. ");
INSERT INTO ita1885_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Tutti gli annoverati del campo di Efraim son centottomila cento, distinti per le loro schiere. Questi movansi i terzi. ");
INSERT INTO ita1885_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Sia la bandiera del campo di Dan, distinta per le sue schiere, verso il Settentrione; e sia capo de' figliuoli di Dan Ahiezer, figliuolo di Ammisaddai. ");
INSERT INTO ita1885_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","La cui schiera, e gli annoverati, son sessantaduemila settecento. ");
INSERT INTO ita1885_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","E quelli che si accamperanno presso a lui sieno la tribù di Aser, e sia capo de' figliuoli di Aser Paghiel, figliuolo di Ocran. ");
INSERT INTO ita1885_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","La cui schiera, e gli annoverati, son quarantunmila cinquecento. ");
INSERT INTO ita1885_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","E la tribù di Neftali; e sia capo de' figliuoli di Neftali Ahira, figliuolo di Enan. ");
INSERT INTO ita1885_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","La cui schiera, e gli annoverati, son cinquantatremila quattrocento. ");
INSERT INTO ita1885_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Tutti gli annoverati del campo di Dan, son cencinquantasettemila seicento. Questi si movano gli ultimi, distinti per le lor bandiere. ");
INSERT INTO ita1885_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Questi sono gli annoverati d'infra i figliuoli d'Israele, per le lor famiglie paterne. Tutti gli annoverati de' campi, per le loro schiere, furono seicentotremila cinquecencinquanta. ");
INSERT INTO ita1885_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ma i Leviti non furono annoverati per mezzo i figliuoli d'Israele; secondo che il Signore avea comandato a Mosè. ");
INSERT INTO ita1885_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","E i figliuoli d'Israele fecero interamente come il Signore avea comandato a Mosè; così si accampavano distinti per le lor bandiere, e così si movevano, ciascuno secondo la sua nazione, e secondo la sua famiglia paterna. ");
INSERT INTO ita1885_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","OR queste sono le generazioni di Aaronne e di Mosè, al tempo che il Signore parlò con Mosè, nel monte di Sinai. ");
INSERT INTO ita1885_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","E questi sono i nomi de' figliuoli d'Aaronne: Nadab il primogenito, e Abihu, Eleazaro e Itamar. ");
INSERT INTO ita1885_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Questi sono i nomi de' figliuoli d'Aaronne, sacerdoti, i quali furono unti e consacrati, per esercitare il sacerdozio. ");
INSERT INTO ita1885_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Or Nadab ed Abihu morirono davanti al Signore, quando offersero fuoco strano nel cospetto del Signore, nel deserto di Sinai; e non ebbero figliuoli; ed Eleazaro e Itamar esercitarono il sacerdozio nella presenza d'Aaronne, lor padre. ");
INSERT INTO ita1885_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","E il Signore parlò a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Fa' appressar la tribù di Levi, e falla comparir davanti al Sacerdote Aaronne, acciocchè gli ministrino. ");
INSERT INTO ita1885_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","E facciano la fazione di esso, e la fazione di tutta la raunanza, davanti al Tabernacolo della convenenza, facendo i servigi del Tabernacolo. ");
INSERT INTO ita1885_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","E abbiano in guardia tutti gli arredi del Tabernacolo della convenenza; e in somma facciano la fazione de' figliuoli d'Israele, facendo i servigi del Tabernacolo. ");
INSERT INTO ita1885_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Così da' i Leviti ad Aaronne, e a' suoi figliuoli; essi gli sono dati in dono d'infra i figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","E costituisci Aaronne e i suoi figliuoli, a far la fazione del lor sacerdozio; e se alcuno straniere vi si appressa, sia fatto morire. ");
INSERT INTO ita1885_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Oltre a ciò, il Signore parlò a Mosè dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Ecco, io ho presi i Leviti d'infra i figliuoli d'Israele in luogo di tutti i primogeniti che aprono la matrice fra i figliuoli d'Israele; perciò i Leviti saranno miei. ");
INSERT INTO ita1885_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Conciossiachè ogni primogenito sia mio; nel giorno che io percossi tutti i primogeniti nel paese di Egitto, io mi consacrai tutti i primogeniti d'Israele, così degli uomini, come degli animali; essi hanno ad esser miei. Io sono il Signore. ");
INSERT INTO ita1885_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Il Signore parlò ancora a Mosè, nel deserto di Sinai, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Annovera i figliuoli di Levi, per le lor famiglie paterne, e per le lor nazioni, annovera ogni maschio d'infra loro, dall'età d'un mese in su. ");
INSERT INTO ita1885_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","E Mosè li annoverò secondo il comandamento del Signore, come gli era stato imposto. ");
INSERT INTO ita1885_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Or questi furono i figliuoli di Levi, secondo i lor nomi; Gherson, e Chehat, e Merari. ");
INSERT INTO ita1885_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","E questi sono i nomi de' figliuoli di Gherson, distini per le lor nazioni; Libni e Simei. ");
INSERT INTO ita1885_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","E i figliuoli di Chehat, distinti per le lor nazioni, furono Amram, e Ishar, e Hebron, e Uzziel. ");
INSERT INTO ita1885_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","E i figliuoli di Merari, distinti per le lor nazioni, furono Mahali e Musi. Queste sono le nazioni de' Leviti, distinte per le lor famiglie paterne. ");
INSERT INTO ita1885_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Di Gherson fu la nazione de' Libniti, e la nazione de' Simeiti. Queste furono le nazioni de' Ghersoniti. ");
INSERT INTO ita1885_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","De' quali gli annoverati, contati tutti i maschi dall'età d'un mese in su, furono settemila cinquecento. ");
INSERT INTO ita1885_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Le nazioni de' Ghersoniti furono dietro al Tabernacolo, verso il Ponente. ");
INSERT INTO ita1885_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","E il capo della famiglia paterna de' Ghersoniti fu Eliasaf, figliuolo di Lael. ");
INSERT INTO ita1885_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","E la fazione de' figliuoli di Gherson, nel Tabernacolo della convenenza, era il Tabernacolo e la Tenda, la Coverta di essa, e il Tappeto dell'entrata del Tabernacolo della convenenza; ");
INSERT INTO ita1885_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","e le cortine del Cortile, insieme col Tappeto dell'entrata del Cortile, d'intorno al Padiglione e all'Altare, e le sue corde, per tutti i suoi servigi. ");
INSERT INTO ita1885_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","E di Chehat fu la nazione degli Amramiti, e la nazione degl'Ishariti, e la nazione degli Hebroniti, e la nazione degli Uzzieliti. Queste sono le nazioni de' Chehatiti. ");
INSERT INTO ita1885_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","I quali, contati tutti i maschi, dall'età d'un mese in su, furono ottomila seicento, che facevano la fazione del Santuario. ");
INSERT INTO ita1885_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Le nazioni de' figliuoli di Chehat doveano accamparsi allato al Tabernacolo verso il Mezzodì. ");
INSERT INTO ita1885_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","E il capo delle famiglie paterne delle nazioni de' Chehatiti fu Elisafan, figliuolo d'Uzziel. ");
INSERT INTO ita1885_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","E la lor fazione era l'Arca e la Tavola, e il Candelliere, e gli Altari, e i vasellamenti del Santuario, co' quali si faceva il ministerio, e la Cortina, e tutti i suoi servigi. ");
INSERT INTO ita1885_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Ed Eleazaro, figliuolo del Sacerdote Aaronne, era Capo de' capi de' Leviti; essendo Sopraintendente di coloro che facevano la fazione del Santuario. ");
INSERT INTO ita1885_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Di Merari fu la nazione de' Mahaliti, e la nazione de' Musiti. Queste sono le nazioni de' Merariti. ");
INSERT INTO ita1885_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","De' quali gli annoverati, contati tutti i maschi dall'età d'un mese in su, furono seimila dugento. ");
INSERT INTO ita1885_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","E il capo delle famiglie paterne delle nazioni de' Merariti fu Suriel, figliuolo di Abihail. Essi doveano accamparsi allato al Tabernacolo, verso il Settentrione. ");
INSERT INTO ita1885_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","E il carico della fazione de' figliuoli di Merari era le assi, e le sbarre, e le colonne, e i piedistalli del Tabernacolo, e tutti i suoi tali arredi, e tutti tali suoi servigi; ");
INSERT INTO ita1885_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","e le colonne del Cortile d'intorno, e i lor piedistalli, e i lor piuoli, e le lor corde. ");
INSERT INTO ita1885_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","E quelli che doveano accamparsi davanti alla Tenda, verso il Levante, dalla parte anteriore del Tabernacolo della convenenza, verso l'Oriente, erano Mosè e Aaronne, e i suoi figliuoli; i quali facevano la fazione del Santuario, in vece ed a nome de' figliuoli d'Israele; in maniera, che se alcuno straniere vi si appressava, dovea esser fatto morire. ");
INSERT INTO ita1885_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Tutti gli annoverati d'infra i Leviti, i quali Mosè ed Aaronne, per comandamento del Signore, annoverarono per le lor nazioni, cioè: tutti i maschi, dall'età d'un mese in su, furono ventiduemila. ");
INSERT INTO ita1885_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","POI il Signore disse a Mosè: Annovera tutti i primogeniti maschi d'infra i figliuoli d'Israele, dall'età d'un mese in su; e leva la somma de' loro nomi. ");
INSERT INTO ita1885_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","E prendi per me, io sono il Signore, i Leviti, in luogo di tutti i primogeniti d'infra i figliuoli d'Israele; prendi parimente il bestiame de' Leviti, in luogo di tutti i primogeniti del bestiame dei figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","E Mosè annoverò tutti i primogeniti d'infra i figliuoli d'Israele, come il Signore gli avea comandato. ");
INSERT INTO ita1885_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","E tutti i primogeniti maschi, secondo che furono annoverati, contati per nome, dall'età di un mese in su, furono ventiduemila dugensettantatrè. ");
INSERT INTO ita1885_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Il Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Prendi i Leviti in luogo di tutti i primogeniti d'infra i figliuoli d'Israele; e il bestiame de' Leviti in luogo del bestiame di essi; e sieno i Leviti miei. Io sono il Signore. ");
INSERT INTO ita1885_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","E per lo riscatto di que' dugensettantatrè, de' primogeniti dei figliuoli d'Israele, che son di avanzo sopra il numero de' Leviti; ");
INSERT INTO ita1885_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","prendi cinque sicli per testa, a siclo di Santuario, che è di venti oboli. ");
INSERT INTO ita1885_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","E da' ad Aaronne, e a' suoi figliuoli, i danari del riscatto di coloro che son di avanzo fra' primogeniti. ");
INSERT INTO ita1885_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Mosè adunque prese i danari del riscatto, da coloro ch'erano stati d'avanzo de' riscattati per i Leviti. ");
INSERT INTO ita1885_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Egli prese que' danari da' primogeniti de' figliuoli d'Israele, che furono milletrecensessantacinque sicli, a siclo di Santuario. ");
INSERT INTO ita1885_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","E Mosè diede i danari del riscatto ad Aaronne, e a' suoi figliuoli, secondo il comandamento del Signore, come il Signore gli avea imposto. ");
INSERT INTO ita1885_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","IL Signore parlò ancora a Mosè e ad Aaronne, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Levate la somma de' figliuoli di Chehat, d'infra i figliuoli di Levi, per le lor nazioni e famiglie paterne; ");
INSERT INTO ita1885_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","dall'età di trent'anni in su, fino a cinquanta; cioè: tutti quelli che possono entrare in ufficio, per fare l'opera nel Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Questo è il servizio de' figliuoli di Chehat, nel Tabernacolo della convenenza, nelle cose santissime. ");
INSERT INTO ita1885_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Quando il campo si moverà, vengano Aaronne ed i suoi figliuoli, e pongan giù la Cortina che si tende davanti all'Arca, e copre l'Arca della Testimonianza. ");
INSERT INTO ita1885_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Poi mettanvi sopra una coverta di pelli di tasso, e stendano disopra un drappo tutto di violato; e mettano le stanghe all'Arca. ");
INSERT INTO ita1885_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Poi stendano sopra la Tavola di presenza un drappo di violato; e mettano sopra essa i piattelli, e le scodelle, e le coppe, e i nappi da fare gli spargimenti; sia parimente sopra essa il pane continuo. ");
INSERT INTO ita1885_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","E stendano sopra quelle cose un drappo di scarlatto, e coprano quello con una coverta di pelli di tasso; poi mettano le stanghe alla Tavola. ");
INSERT INTO ita1885_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Poi prendano un drappo di violato, e copranne il Candelliere della lumiera, e le sue lampane, e i suoi smoccalatoi, e i suoi catinelli, e tutti i vaselli dell'olio di esso, co' quali si fanno i suoi servigi. ");
INSERT INTO ita1885_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Poi mettano il Candelliere, con tutti i suoi strumenti, in una coverta di pelli di tasso; e mettanlo sopra un par di stanghe. ");
INSERT INTO ita1885_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Poi stendano un drappo di violato sopra l'Altare d'oro; e copranlo con una coverta di pelli di tasso; poi mettano le stanghe all'Altare. ");
INSERT INTO ita1885_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Poi prendano tutti gli arredi del servigio, co' quali si fa il servigio nel Santuario, e mettanli dentro un drappo di violato, e copranli con una coverta di pelli di tasso; e mettanli sopra un par di stanghe. ");
INSERT INTO ita1885_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Poi tolgano le ceneri dall'Altare, e stendano sopra esso un drappo di scarlatto. ");
INSERT INTO ita1885_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","E mettano sopra esso tutti i suoi strumenti, co' quali si fa il servigio sopra esso, le cazze, le forcelle, le palette, i bacini, e tutti gli altri strumenti dell'Altare; e stendanvi sopra una coverta di pelli di tasso; poi mettano le stanghe all'Altare. ");
INSERT INTO ita1885_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","E, dopo che Aaronne e i suoi figliuoli avranno finito di coprire il Santuario, e tutti gli arredi di esso, quando il campo si moverà; vengano i figliuoli di Chehat, per portar quelle cose; e non tocchino il Santuario, che non muoiano. Queste son le cose che i figliuoli di Chehat devono portare, del Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","E abbia Eleazaro, figliuolo del Sacerdote Aaronne, il carico dell'olio della lumiera, e del profumo aromatico, e dell'offerta continua, e dell'olio dell'Unzione; oltre alla sopraintendenza sopra tutto il Tabernacolo, e tutto ciò ch'è in esso, per lo Santuario, e per li suoi arredi. ");
INSERT INTO ita1885_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Poi il Signore parlò a Mosè e ad Aaronne, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Non fate sì che la tribù delle famiglie de' Chehatiti sia sterminata d'infra i Leviti. ");
INSERT INTO ita1885_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Anzi fate loro questo, acciocchè vivano, e non muoiano, quando si accosteranno alle cose santissime: Vengano Aaronne e i suoi figliuoli, e disponganli ciascuno al suo servigio, e a ciò ch'egli ha da portare. ");
INSERT INTO ita1885_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Ma non vengano per riguardare, quando si copriranno le cose sante, che non muoiano. ");
INSERT INTO ita1885_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Il Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Leva parimente la somma dei figliuoli di Gherson, per le lor famiglie paterne e nazioni. ");
INSERT INTO ita1885_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Annoverali, dall'età di trent'anni in su, fino a cinquanta, cioè: tutti quelli che possono entrare in esercizio di ufficio, per servire nel Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Questo è il servigio delle famiglie dei Ghersoniti, in ministrare e in portare: ");
INSERT INTO ita1885_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Portino i teli della Tenda, e il Tabernacolo della convenenza; la sua Coverta, e la Coverta di pelli di tasso che è disopra, e il Tappeto dell'entrata del Tabernacolo della convenenza; ");
INSERT INTO ita1885_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","e le cortine del Cortile, e il Tappeto dell'entrata della porta del Cortile, il quale è intorno al Tabernacolo e all'Altare; e le corde di quelle, e tutti gli arredi per lor servigio. E servano essi in tutto ciò che si deve fare intorno a quelle cose. ");
INSERT INTO ita1885_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Tutto il servigio de' figliuoli di Gherson, in tutto ciò che devono portare, e in tutti i servigi che devono fare, sia secondo l'ordine di Aaronne e de' suoi figliuoli; e voi darete loro il carico di tutto ciò che dovranno portare. ");
INSERT INTO ita1885_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Questo è il servigio delle famiglie de' figliuoli di Gherson, nel Tabernacolo della convenenza; e la fazion loro sarà sotto la sopraintendenza d'Itamar, figliuolo del Sacerdote Aaronne. ");
INSERT INTO ita1885_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Annovera eziandio i figliuoli di Merari, per le lor nazioni e famiglie paterne. ");
INSERT INTO ita1885_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Annoverali, dall'età di trenta anni in su, fino a cinquanta, cioè: tutti quelli che possono entrare nel servigio del Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","E questo sia ciò che devono portare per lor fazione, insieme con tutto il servigio che dovranno fare nel Tabernacolo della convenenza, cioè: le assi del Tabernacolo, e le sue sbarre e le sue colonne, e i suoi piedistalli. ");
INSERT INTO ita1885_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","E le colonne del Cortile d'intorno, e i lor piedistalli, e i lor piuoli, e le lor corde, insieme con tutti i loro arredi, per tutti i lor servigi; e consegnate loro per nome gli arredi che dovranno portare per lor fazione. ");
INSERT INTO ita1885_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Questo è il servigio delle famiglie de' figliuoli di Merari; oltre a tutto il servigio che hanno da fare nel Tabernacolo della convenenza, sotto la sopraintendenza di Itamar, figliuolo del Sacerdote Aaronne. ");
INSERT INTO ita1885_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Mosè adunque, ed Aaronne, e i principali della raunanza, annoverarono i figliuoli di Chehat, per le lor nazioni e famiglie paterne; ");
INSERT INTO ita1885_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","dall'età di trent'anni in su, fino a cinquanta, cioè: tutti quelli che potevano entrare in ufficio, per servire nel Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","E gli annoverati d'infra loro, distinti per le lor nazioni, furono duemila settecencinquanta. ");
INSERT INTO ita1885_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Questi sono gli annoverati delle nazioni de' Chehatiti; che erano tutti quelli che servivano nel Tabernacolo della convenenza, i quali Mosè ed Aaronne annoverarono, per comandamento del Signore, dato per man di Mosè. ");
INSERT INTO ita1885_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","E gli annoverati d'infra i figliuoli di Gherson, distinti per le lor nazioni e famiglie paterne; ");
INSERT INTO ita1885_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","dall'età di trent'anni in su, fino a cinquanta; ch'erano tutti quelli che potevano entrare in ufficio, per servire nel Tabernacolo della convenenza; ");
INSERT INTO ita1885_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","gli annoverati, dico, d'infra loro, distinti per le lor nazioni e famiglie paterne, furono duemila seicentrenta. ");
INSERT INTO ita1885_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Questi sono gli annoverati delle nazioni de' figliuoli di Gherson; ch'erano tutti quelli che servivano nel Tabernacolo della convenenza; i quali Mosè ed Aaronne annoverarono, per comandamento del Signore. ");
INSERT INTO ita1885_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","E gli annoverati delle nazioni de' figliuoli di Merari, distinti per le lor nazioni e famiglie paterne; ");
INSERT INTO ita1885_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","dall'età di trent'anni in su, fino a cinquanta, cioè: tutti quelli che potevano entrare in ufficio, per servire nel Tabernacolo della convenenza; ");
INSERT INTO ita1885_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","gli annoverati, dico, d'infra loro, distinti per le lor nazioni, furono tremila dugento. ");
INSERT INTO ita1885_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Questi sono gli annoverati delle nazioni de' figliuoli di Merari; i quali Mosè ed Aaronne annoverarono, per comandamento del Signore, dato per man di Mosè. ");
INSERT INTO ita1885_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Tutti gli annoverati i quali Mosè, ed Aaronne, e i principali d'Israele, annoverarono, d'infra i Leviti, distinti per le lor nazioni e famiglie paterne; ");
INSERT INTO ita1885_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","dall'età di trent'anni in su, fino a cinquanta, cioè: tutti quelli che potevano entrare in servigio, così per servire, come per portare, nel Tabernacolo della convenenza; ");
INSERT INTO ita1885_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","gli annoverati, dico, d'infra loro, furono ottomila cinquecentottanta. ");
INSERT INTO ita1885_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Essi gli annoverarono per comandamento del Signore, dato per man di Mosè, ciascuno secondo che dovea servire o portare; e gli annoverati da loro furono quelli che il Signore avea comandati a Mosè. ");
INSERT INTO ita1885_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","POI il Signore parlò a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Comanda a' figliuoli d'Israele che mandino fuor del campo ogni lebbroso, e ogni uomo che ha la colagione, e ogni uomo immondo per un morto. ");
INSERT INTO ita1885_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Mandateli fuori, così maschi, come femmine; mandateli fuor del campo; acciocchè non contaminino il campo loro, nel mezzo del quale io abito. ");
INSERT INTO ita1885_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","E i figliuoli d'Israele fecero così, e mandarono coloro fuor del campo. Come il Signore avea detto a Mosè, così fecero i figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","IL Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Parla a' figliuoli d'Israele, e di' loro: Quando un uomo o una donna avrà fatto alcuno de' peccati degli uomini, commettendo misfatto contro al Signore; quella cotal persona è colpevole. ");
INSERT INTO ita1885_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Se confessa il suo peccato che avrà commesso, restituisca il capitale di ciò intorno a che avrà misfatto; e vi sopraggiunga il quinto, e dialo a colui contro a cui avrà misfatto. ");
INSERT INTO ita1885_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","E se colui non ha alcun prossimo parente, che abbia ragione di ricoverar ciò che fu suo, per restituirgli ciò in che il misfatto sarà stato commesso; venendosi ciò a restituire, appartenga al Signore, cioè al sacerdote, oltre al montone de' purgamenti, col quale il sacerdote farà purgamento per lui. ");
INSERT INTO ita1885_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Parimente sia del sacerdote ogni offerta elevata di tutte le cose consacrate da' figliuoli d'Israele, le quali essi gli presenteranno. ");
INSERT INTO ita1885_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","E le cose consacrate da chi che sia sieno del sacerdote; sia suo ciò che qualunque persona gli avrà dato. ");
INSERT INTO ita1885_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","OLTRE a ciò, il Signore parlò a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Parla a' figliuoli d'Israele, e di' loro: Quando la moglie di alcun si sarà sviata, e avrà commesso misfatto contro a lui; ");
INSERT INTO ita1885_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","e alcuno sarà giaciuto carnalmente con lei, di nascosto dal marito; ed ella si sarà celatamente contaminata, senza che vi sia alcun testimonio contro a lei nè che sia stata colta in sul fatto; ");
INSERT INTO ita1885_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","se lo spirito della gelosia entra nel marito, sì ch'egli sia geloso della sua moglie, essendosi ella contaminata; ovvero anche, se lo spirito della gelosia entra in lui, sì che sia geloso della sua moglie, non essendosi ella contaminata; ");
INSERT INTO ita1885_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","meni quell'uomo la sua moglie al sacerdote, e presenti per lei l'offerta di essa, che sarà la decima parte di un efa di farina d'orzo; non ispandavi sopra olio, e non mettavi sopra incenso; perciocchè è offerta di gelosie, oblazione di rammemorazione, che riduce a memoria iniquità. ");
INSERT INTO ita1885_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","E faccia il sacerdote appressar quella donna, e facciala stare in piè nel cospetto del Signore. ");
INSERT INTO ita1885_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Poi prenda il sacerdote dell'acqua santa in un vasello di terra; prenda eziandio della polvere che sarà sopra il suolo del Tabernacolo, e mettala in quell'acqua. ");
INSERT INTO ita1885_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","E facendo star quella donna in piè davanti al Signore, scoprale il sacerdote la testa, e mettale in su le palme delle mani l'offerta della rammemorazione, che è l'offerta delle gelosie; e abbia il Sacerdote in mano quell'acqua amara che reca maledizione. ");
INSERT INTO ita1885_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","E faccia il sacerdote giurar quella donna, e dicale: Se niun uomo è giaciuto teco, e se tu non ti sei sviata per contaminazione, ricevendo un altro in luogo del tuo marito; quest'acqua amara, che reca maledizione, non facciati alcun danno. ");
INSERT INTO ita1885_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Ma se tu ti sei sviata, ricevendo un altro in luogo del tuo marito, e ti sei contaminata, e altri che il tuo marito è giaciuto teco carnalmente; ");
INSERT INTO ita1885_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","(allora faccia il sacerdote giurar la donna, con giuramento di esecrazione, e dicale): Il Signore ti metta in maledizione ed esecrazione, nel mezzo del tuo popolo, facendoti cader la coscia, e gonfiare il ventre. ");
INSERT INTO ita1885_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Ed entriti nell'interiora quest'acqua che reca maledizione, per farti gonfiare il ventre, e cader la coscia. E la donna dica: Amen, Amen. ");
INSERT INTO ita1885_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Poi scriva il sacerdote queste maledizioni in un cartello, e le cancelli con quell'acqua amara. ");
INSERT INTO ita1885_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","E dia a bere alla donna quell'acqua amara, che reca maledizione, sì che quell'acqua che reca maledizione entri in lei, per acqua amara. ");
INSERT INTO ita1885_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Or prenda il sacerdote di man di quella donna l'offerta delle gelosie; e dimenila davanti al Signore; e poi offeriscala sopra l'Altare. ");
INSERT INTO ita1885_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Prenda eziandio una menata di quell'offerta, per la sua ricordanza, e brucila sopra l'Altare; e poi dia a bere quell'acqua alla donna. ");
INSERT INTO ita1885_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","E quando egli gliela avrà data a bere, avverrà che, se ella si è contaminata, e ha commesso misfatto contro al suo marito, quando l'acqua che reca maledizione sarà entrata in lei, per acqua amara, il ventre le gonfierà, e la coscia le caderà; e quella donna sarà in esecrazione in mezzo del suo popolo. ");
INSERT INTO ita1885_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Ma, se quella donna non si è contaminata, anzi è pura, ella non avrà male alcuno, e potrà portar figliuoli. ");
INSERT INTO ita1885_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Questa è la legge delle gelosie, quando la moglie di alcuno si sarà sviata, ricevendo un altro in luogo del suo marito, e si sarà contaminata. ");
INSERT INTO ita1885_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Ovvero, quando lo spirito della gelosia sarà entrato nel marito, ed egli sarà geloso della sua moglie; facciala comparire davanti al Signore, e facciale il Sacerdote tutto quello ch'è ordinato per questa legge. ");
INSERT INTO ita1885_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","E sia il marito esente di colpa, ma porti la donna la sua iniquità. ");
INSERT INTO ita1885_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","IL Signore parlò, altre a ciò, a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Parla a' figliuoli d'Israele, e di' loro: Quando alcuno, uomo o donna, avrà fatto singolar voto di Nazireo, per farsi Nazireo al Signore; astengasi da vino e da cervogia; ");
INSERT INTO ita1885_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","non beva alcun aceto, nè di vino, nè di cervogia; nè alcun liquor d'uva; e non mangi alcuna uva, nè fresca nè secca. ");
INSERT INTO ita1885_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Tutto il tempo del suo Nazireato non mangi cosa niuna prodotta da vite che fa vino; non pure acini nè fiocini. ");
INSERT INTO ita1885_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Tutto il tempo del voto del suo Nazireato non passi il rasoio sopra il suo capo; sia santo, finchè sia compiuto il tempo per lo quale egli si è votato Nazireo al Signore; lasciando crescer la chioma de' capelli del suo capo. ");
INSERT INTO ita1885_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Non vada, in tutto il tempo per lo quale, egli si sarà votato Nazireo al Signore, in alcun luogo ove sia un morto. ");
INSERT INTO ita1885_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Non contaminisi per suo padre, nè per sua madre, nè per suo fratello, nè per sua sorella, quando alcuno di loro sarà morto; perciocchè il Nazireato dell'Iddio suo è sopra il suo capo. ");
INSERT INTO ita1885_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Sia santo al Signore, tutto il tempo del suo Nazireato. ");
INSERT INTO ita1885_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","E se alcuno muore appresso di lui di subito improvviso, egli ha contaminato il capo del suo Nazireato; perciò radasi il capo al giorno della sua purificazione; radaselo al settimo giorno. ");
INSERT INTO ita1885_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","E nell'ottavo giorno porti al sacerdote alla entrata del Tabernacolo della convenenza, due tortole o due pippioni. ");
INSERT INTO ita1885_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","E sacrifichine il sacerdote uno per lo peccato, e uno per olocausto; e faccia purgamento per lui, di ciò ch'egli avrà peccato intorno al morto; e in quel giorno stesso santifichi il suo capo; ");
INSERT INTO ita1885_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","e consacri al Signore i giorni del suo Nazireato; e adduca un agnello di un anno per la colpa; e sieno i giorni precedenti tenuti per nulla; conciossiachè il suo Nazireato sia stato contaminato. ");
INSERT INTO ita1885_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Or questa è la legge intorno al Nazireo: Nel giorno che il tempo del suo Nazireato sarà compiuto, portilo all'entrata del Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","E offerisca la sua offerta al Signore; cioè: un agnello di un anno, senza difetto, per olocausto; e un'agnella di un anno, senza difetto, per lo peccato; e un montone senza difetto, per sacrificio da render grazie; ");
INSERT INTO ita1885_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","e un paniere di focacce di fior di farina, azzime, intrise con olio, e di schiacciate azzime, unte con olio; insieme con l'offerte di panatica, e da spandere di que' sacrificii. ");
INSERT INTO ita1885_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","E offerisca il sacerdote quelle cose nel cospetto del Signore; e sacrifichi il sacrificio per lo peccato, e l'olocausto di esso. ");
INSERT INTO ita1885_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Poi offerisca quel montone al Signore, per sacrificio da render grazie, insieme con quel paniere di azzimi; offerisca ancora il sacerdote l'offerta di panatica, e l'offerta da spandere di esso. ");
INSERT INTO ita1885_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","E facciasi il Nazireo radere il capo del suo Nazireato all'entrata del Tabernacolo della convenenza; e prenda i capelli del suo Nazireato, e mettali in sul fuoco, che sarà sotto il sacrificio da render grazie. ");
INSERT INTO ita1885_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Poi prenda il sacerdote una spalla di quel montone cotta; e una focaccia azzima di quel paniere, e una schiacciata azzima; e mettale in su le palme delle mani del Nazireo, dopo ch'egli avrà fatto radere il suo Nazireato. ");
INSERT INTO ita1885_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","E dimeni il sacerdote quelle cose per offerta dimenata davanti al Signore; sono cosa sacra, appartenente al sacerdote, siccome ancora il petto dell'offerta dimenata, e la spalla dell'offerta elevata. Dopo questo, il Nazireo potrà ber vino. ");
INSERT INTO ita1885_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Questa è la legge del Nazireo che avrà votata la sua offerta al Signore per lo suo Nazireato; oltre a quello ch'egli potrà fornir di più secondo la sua facoltà; faccia secondo il voto ch'egli avrà fatto, oltre alla legge del suo Nazireato. ");
INSERT INTO ita1885_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Il Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Parla ad Aaronne e a' suoi figliuoli, dicendo: Benedite i figliuoli di Israele in questa maniera, dicendo loro: ");
INSERT INTO ita1885_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Il Signore ti benedica e ti guardi. ");
INSERT INTO ita1885_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Il Signore faccia risplendere le sua faccia verso te, e ti sia propizio. ");
INSERT INTO ita1885_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Alzi il Signore la sua faccia verso te, e ti stabilisca la pace. ");
INSERT INTO ita1885_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","E mettano il mio Nome sopra i figliuoli d'Israele; e io il benedirò. ");
INSERT INTO ita1885_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","OR nel giorno che Mosè ebbe finito di rizzare il Tabernacolo, e l'ebbe unto e consacrato, con tutti i suoi arredi: e l'Altare, con tutti i suoi strumenti; ");
INSERT INTO ita1885_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","i principali d'Israele, capi delle case loro paterne, i quali erano i principali delle tribù, ed erano stati sopra le rassegne del popolo, fecero un'offerta. ");
INSERT INTO ita1885_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","E l'addussero davanti al Signore, cioè: sei carri coperti e dodici buoi; un carro per due di que' principali, e un bue per uno; e offersero quelli davanti al Tabernacolo. ");
INSERT INTO ita1885_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","E il Signore parlò a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Prendili da loro, e sieno impiegati nei servigi del Tabernacolo della convenenza, e dalli a' Leviti; acciocchè se ne servano, ciascuno secondo il suo servigio. ");
INSERT INTO ita1885_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Mosè adunque prese que' carri e quei buoi, e li diede a' Leviti. ");
INSERT INTO ita1885_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","A' figliuoli di Gherson diede due di que' carri, e quattro di que' buoi, per servirsene secondo il lor servigio. ");
INSERT INTO ita1885_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","E a' figliuoli di Merari diede i quattro altri carri, e gli altri otto buoi, per servirsene secondo il lor servigio; sotto la sopraintendenza d'Itamar, figliuolo del Sacerdote Aaronne. ");
INSERT INTO ita1885_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Ma a' figliuoli di Chehat non ne diede; perciocchè il servigio del Santuario era loro imposto; essi aveano da portare in su le spalle. ");
INSERT INTO ita1885_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Oltre a ciò, que' principali fecero una offerta per la dedicazione dell'Altare, nel giorno ch'egli fu unto; e l'offersero davanti all'Altare. ");
INSERT INTO ita1885_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","E il Signore disse a Mosè: Di questi capi uno per giorno offerisca la sua offerta, per la Dedicazione dell'Altare. ");
INSERT INTO ita1885_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","E colui che offerse la sua offerta il primo giorno, fu Naasson, figliuolo di Amminadab, della tribù di Giuda. ");
INSERT INTO ita1885_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","E la sua offerta fu un piattel d'argento, di peso di centrenta sicli; un nappo di argento, di settanta sicli, a siclo di Santuario; amendue pieni di fior di farina, stemperata con olio, per offerta di panatica; ");
INSERT INTO ita1885_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","un turibolo d'oro, di dieci sicli, pien di profumo; ");
INSERT INTO ita1885_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","un giovenco, un montone, un agnello di un anno, per olocausto; ");
INSERT INTO ita1885_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","un becco, per sacrificio per lo peccato: ");
INSERT INTO ita1885_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","e, per sacrificio da render grazie, un par di buoi, cinque montoni, cinque becchi, e cinque agnelli di un anno. Questa fu l'offerta di Naasson, figliuolo di Amminadab. ");
INSERT INTO ita1885_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Il secondo giorno, Natanael, figliuolo di Suar, capo d'Issacar, offerse la sua offerta; ");
INSERT INTO ita1885_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","che fu: un piattel d'argento, di peso di centrenta sicli; un nappo di argento, di settanta sicli, a siclo di Santuario; amendue pieni di fior di farina, stemperata con olio, per offerta di panatica; ");
INSERT INTO ita1885_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","un turibolo d'oro, di dieci sicli, pien di profumo; ");
INSERT INTO ita1885_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","un giovenco, un montone, un agnello di un anno, per olocausto; ");
INSERT INTO ita1885_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","un becco, per sacrificio per lo peccato: ");
INSERT INTO ita1885_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","e, per sacrificio da render grazie, un par di buoi, cinque montoni, cinque becchi, e cinque agnelli di un anno. Questa fu l'offerta di Natanael, figliuolo di Suar. ");
INSERT INTO ita1885_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Il terzo giorno, Eliab, figliuolo di Helon, capo de' figliuoli di Zabulon, offerse la sua offerta; ");
INSERT INTO ita1885_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","che fu: un piattel di argento, di peso di centrenta sicli; un nappo di argento, di settanta sicli, a siclo di Santuario; amendue pieni di fior di farina, stemperata con olio, per offerta di panatica; ");
INSERT INTO ita1885_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","un turibolo d'oro, di dieci sicli, pien di profumo; ");
INSERT INTO ita1885_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","un giovenco, un montone, un agnello di un anno, per olocausto; ");
INSERT INTO ita1885_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","un becco, per sacrificio per lo peccato: ");
INSERT INTO ita1885_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","e, per sacrificio da render grazie, un par di buoi, cinque montoni, cinque becchi, e cinque agnelli di un anno. Questa fu l'offerta di Eliab, figliuolo di Helon. ");
INSERT INTO ita1885_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Il quarto giorno, Elisur, figliuolo di Sedeur, capo de' figliuoli di Ruben, offerse la sua offerta; ");
INSERT INTO ita1885_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","che fu: un piattel di argento, di peso di centrenta sicli; un nappo di argento, di settanta sicli, a siclo di Santuario; amendue pieni di fior di farina, stemperata con olio, per offerta di panatica; ");
INSERT INTO ita1885_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","un turibolo d'oro, di dieci sicli, pien di profumo; ");
INSERT INTO ita1885_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","un giovenco, un montone, un agnello di un anno, per olocausto; ");
INSERT INTO ita1885_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","un becco, per sacrificio per lo peccato: ");
INSERT INTO ita1885_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","e, per sacrificio da render grazie, un par di buoi, cinque montoni, cinque becchi, e cinque agnelli di un anno. Questa fu l'offerta di Elisur, figliuolo di Sedeur. ");
INSERT INTO ita1885_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Il quinto giorno, Selumiel, figliuolo di Surisaddai, capo de' figliuoli di Simeone, offerse la sua offerta; ");
INSERT INTO ita1885_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","che fu: un piattel di argento, di peso di centrenta sicli; un nappo di argento, di settanta sicli, a siclo di Santuario; amendue pieni di fior di farina, stemperata con olio, per offerta di panatica; ");
INSERT INTO ita1885_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","un turibolo d'oro, di dieci sicli, pien di profumo; ");
INSERT INTO ita1885_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","un giovenco, un montone, un agnello di un anno, per olocausto; ");
INSERT INTO ita1885_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","un becco, per sacrificio per lo peccato: ");
INSERT INTO ita1885_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","e, per sacrificio da render grazie, un par di buoi, cinque montoni, cinque becchi, e cinque agnelli di un anno. Questa fu l'offerta di Selumiel, figliuolo di Surisaddai. ");
INSERT INTO ita1885_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Il sesto giorno, Eliasaf, figliuolo di Deuel, capo de' figliuoli di Gad, offerse la sua offerta; ");
INSERT INTO ita1885_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","che fu: un piattel di argento, di peso di centrenta sicli; un nappo di argento, di settanta sicli, a siclo di Santuario; amendue pieni di fior di farina, stemperata con olio, per offerta di panatica; ");
INSERT INTO ita1885_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","un turibolo d'oro di dieci sicli, pien di profumo; ");
INSERT INTO ita1885_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","un giovenco, un montone, un agnello di un anno, per olocausto; ");
INSERT INTO ita1885_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","un becco, per sacrificio per lo peccato: ");
INSERT INTO ita1885_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","e, per sacrificio da render grazie, un par di buoi, cinque montoni, cinque becchi, e cinque agnelli di un anno. Questa fu l'offerta di Eliasaf, figliuolo di Deuel. ");
INSERT INTO ita1885_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Il settimo giorno, Elisama, figliuolo di Ammiud, capo de' figliuoli di Efraim, offerse la sua offerta; ");
INSERT INTO ita1885_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","che fu: un piattel di argento, di peso di centrenta sicli; un nappo di argento, di settanta sicli, a siclo di Santuario; amendue pieni di fior di farina, stemperata con olio, per offerta di panatica; ");
INSERT INTO ita1885_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","un turibolo d'oro, di dieci sicli, pien di profumo; ");
INSERT INTO ita1885_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","un giovenco, un montone, un agnello di un anno, per olocausto; ");
INSERT INTO ita1885_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","un becco, per sacrificio per lo peccato: ");
INSERT INTO ita1885_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","e, per sacrificio da render grazie, un par di buoi, cinque montoni, cinque becchi, e cinque agnelli di un anno. Questa fu l'offerta di Elisama, figliuolo di Ammiud. ");
INSERT INTO ita1885_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","L'ottovo giorno, Gamliel, figliuolo di Pedasur, capo de'figliuoli di Manasse, offerse la sua offerta; ");
INSERT INTO ita1885_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","che fu: un piattel di argento, di peso di centrenta sicli; un nappo di argento, di settanta sicli, a siclo di Santuario; amendue pieni di fior di farina, stemperata con olio, per offerta di panatica; ");
INSERT INTO ita1885_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","un turibolo d'oro, di dieci sicli, pien di profumo; ");
INSERT INTO ita1885_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","un giovenco, un montone, un agnello di un anno, per olocausto; ");
INSERT INTO ita1885_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","un becco, per sacrificio per lo peccato: ");
INSERT INTO ita1885_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","e, per sacrificio da render grazie, un par di buoi, cinque montoni, cinque becchi, e cinque agnelli di un anno. Questa fu l'offerta di Gamliel, figliuolo di Pedasur. ");
INSERT INTO ita1885_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Il nono giorno, Abidan, figliuolo di Ghidoni, capo de' figliuoli di Beniamino, offerse la sua offerta; ");
INSERT INTO ita1885_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","che fu: un piattel di argento, di peso di centrenta sicli; un nappo di argento, di settanta sicli, a siclo di Santuario; amendue pieni di fior di farina, stemperata con olio, per offerta di panatica; ");
INSERT INTO ita1885_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","un turibolo d'oro, di dieci sicli, pien di profumo; ");
INSERT INTO ita1885_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","un giovenco, un montone, un agnello di un anno, per olocausto; ");
INSERT INTO ita1885_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","un becco, per sacrificio per lo peccato: ");
INSERT INTO ita1885_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","e, per sacrificio da render grazie, un par di buoi, cinque montoni, cinque becchi, e cinque agnelli di un anno. Questa fu l'offerta di Abidan, figliuolo di Ghidoni. ");
INSERT INTO ita1885_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Il decimo giorno, Ahiezer, figliuolo di Ammisaddai, capo de' figliuoli di Dan, offerse la sua offerta; ");
INSERT INTO ita1885_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","che fu: un piattel di argento, di peso di centrenta sicli; un nappo di argento, di settanta sicli, a siclo di Santuario; amendue pieni di fior di farina, stemperata con olio, per offerta di panatica; ");
INSERT INTO ita1885_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","un turibolo d'oro, di dieci sicli, pien di profumo; ");
INSERT INTO ita1885_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","un giovenco, un montone, un agnello di un anno, per olocausto; ");
INSERT INTO ita1885_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","un becco, per sacrificio per lo peccato: ");
INSERT INTO ita1885_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","e, per sacrificio da render grazie, un par di buoi, cinque montoni, cinque becchi, e cinque agnelli di un anno. Questa fu l'offerta di Ahiezer, figliuolo di Ammisaddai. ");
INSERT INTO ita1885_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","L'undecimo giorno, Paghiel, figliuolo di Ocran, capo de' figliuoli di Aser, offerse la sua offerta; ");
INSERT INTO ita1885_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","che fu: un piattel di argento, di peso di centrenta sicli; un nappo di argento, di settanta sicli, a siclo di Santuario; amendue pieni di fior di farina, stemperata con olio, per offerta di panatica; ");
INSERT INTO ita1885_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","un turibolo d'oro, di dieci sicli, pien di profumo; ");
INSERT INTO ita1885_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","un giovenco, un montone, un agnello di un anno, per olocausto; ");
INSERT INTO ita1885_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","un becco, per sacrificio per lo peccato: ");
INSERT INTO ita1885_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","e, per sacrificio da render grazie, un par di buoi, cinque montoni, cinque becchi, e cinque agnelli di un anno. Questa fu l'offerta di Paghiel, figliuolo di Ocran. ");
INSERT INTO ita1885_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Il duodecimo giorno, Ahira, figliuolo di Enan, capo de' figliuoli di Neftali, offerse la sua offerta; ");
INSERT INTO ita1885_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","che fu: un piattel di argento, di peso di centrenta sicli; un nappo di argento, di settanta sicli, a siclo di Santuario; amendue pieni di fior di farina, stemperata con olio, per offerta di panatica; ");
INSERT INTO ita1885_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","un turibolo d'oro, di dieci sicli, pien di profumo; ");
INSERT INTO ita1885_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","un giovenco, un montone, un agnello di un anno, per olocausto; ");
INSERT INTO ita1885_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","un becco, per sacrificio per lo peccato; ");
INSERT INTO ita1885_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","e, per sacrificio da render grazie, un par di buoi, cinque montoni, cinque becchi, e cinque agnelli di un anno. Questa fu l'offerta di Ahira, figliuolo di Enan. ");
INSERT INTO ita1885_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Questa fu l'offerta della Dedicazione dell'Altare, nel giorno ch'esso fu unto, fatta da' Capi d'Israele, cioè: dodici piattelli di argento, dodici nappi di argento, dodici turiboli d'oro. ");
INSERT INTO ita1885_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Ciascun piattello di argento era di peso di centrenta sicli, e ciascun nappo di settanta; tutto l'argento di que' vasellamenti era di duemila quattrocento sicli, a siclo di Santuario. ");
INSERT INTO ita1885_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Ciascuno di que' dodici turiboli d'oro, pieni di profumo, era di dieci sicli, a siclo di Santuario; tutto l'oro di que' turiboli era cenventi sicli. ");
INSERT INTO ita1885_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Tutti i buoi per olocausto erano dodici giovenchi; con dodici montoni, e dodici agnelli di un anno, e le loro offerte di panatica; vi erano anche dodici becchi, per sacrificio per lo peccato. ");
INSERT INTO ita1885_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","E tutti i buoi del sacrificio da render grazie erano ventiquattro giovenchi; con sessanta montoni, sessanta becchi, e sessanta agnelli di un anno. Questa fu l'offerta della Dedicazione dell'Altare, dopo che fu unto. ");
INSERT INTO ita1885_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Or da indi innanzi, quando Mosè entrava nel Tabernacolo della convenenza, per parlar col Signore, egli udiva la voce che parlava a lui, d'in sul Coperchio ch'era sopra l'Arca della Testimonianza, di mezzo de' due Cherubini; ed egli parlava a lui. ");
INSERT INTO ita1885_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","IL Signore parlò ancora a Mosè dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Parla ad Aaronne, e digli: Quando tu accenderai le lampane, porgano le sette lampane il lume verso la parte anteriore del Candelliere. ");
INSERT INTO ita1885_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","E Aaronne fece così; e accese le lampane per maniera che porgevano il lume verso la parte anteriore del Candelliere, come il Signore avea comandato a Mosè. ");
INSERT INTO ita1885_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Or tale era il lavoro del Candelliere: egli era tutto d'oro tirato al martello, così il suo gambo, come le sue bocce. Mosè l'avea fatto secondo la forma che il Signore gli avea mostrata. ");
INSERT INTO ita1885_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","IL Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Prendi i Leviti d'infra i figliuoli d'Israele, e purificali. ");
INSERT INTO ita1885_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","E fa' loro così per purificarli: spruzzali d'acqua di purgamento; e facciano passare il rasoio sopra tutta la lor carne, e lavino i lor vestimenti, e purifichinsi. ");
INSERT INTO ita1885_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Poi prendano un giovenco con la sua offerta di panatica, che sia fior di farina, stemperata con olio; e tu piglia un altro giovenco per sacrificio per lo peccato. ");
INSERT INTO ita1885_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","E fa' appressare i Leviti davanti al Tabernacolo della convenenza, e aduna tutta la raunanza de' figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","E quando tu avrai fatti appessare i Leviti davanti al Signore, posino i figliuoli d'Israele le lor mani sopra i Leviti. ");
INSERT INTO ita1885_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","E presenti Aaronne i Leviti davanti al Signore, per offerta dimenata da parte de' figliuoli d'Israele; e sieno per esercitare il ministerio del Signore. ");
INSERT INTO ita1885_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Poi posino i Leviti le lor mani sopra la testa di que' giovenchi; e tu sacrificane l'uno per sacrificio per lo peccato, e l'altro per olocausto, al Signore, per far purgamento per i Leviti. ");
INSERT INTO ita1885_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","E fa' stare in piè i Leviti davanti ad Aaronne, e davanti a' suoi figliuoli, e offeriscili per offerta al Signore. ");
INSERT INTO ita1885_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","E separa i Leviti d'infra i figliuoli d'Israele, e sieno i Leviti miei. ");
INSERT INTO ita1885_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","E, dopo questo, vengano i Leviti, per esercitare il ministerio nel Tabernacolo della convenenza. Così li purificherai, e li offerirai per offerta. ");
INSERT INTO ita1885_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Conciossiachè del tutto mi sieno appropriati d'infra i figliuoli d'Israele; io me li ho presi in luogo di tutti quelli che aprono la matrice, d'ogni primogenito di ciascuno de' figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Perciocchè ogni primogenito de' figliuoli d'Israele, così degli uomini, come delle bestie, è mio; io me li consacrai nel giorno che io percossi tutti i primogeniti nel paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","E ho presi i Leviti in luogo di tutti i primogeniti de' figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","E ho dati in dono ad Aaronne e ai suoi figliuoli i Leviti, d'infra i figliuoli d'Israele, per fare il ministerio de'figliuoli d'Israele, nel Tabernacolo della convenenza, e per fare il purgamento de' figliuoli d'Israele; acciocchè non vi sia piaga fra' figliuoli d'Israele, se talora si accostassero al Santuario. ");
INSERT INTO ita1885_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","E Mosè, ed Aaronne, e tutta la raunanza de' figliuoli d'Israele, fecero a' Leviti interamente come il Signore avea comandato a Mosè, intorno a loro. ");
INSERT INTO ita1885_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","E i Leviti si purificarono, e lavarono i lor vestimenti. E Aaronne li presentò per offerta davanti al Signore, e fece purgamento per loro, per purificarli. ");
INSERT INTO ita1885_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","E, dopo questo, i Leviti vennero per esercitare il lor ministerio nel Tabernacolo della convenenza, davanti ad Aaronne, e a' suoi figliuoli. E si fece inverso i Leviti, come il Signore avea comandato a Mosè, intorno a loro. ");
INSERT INTO ita1885_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Il Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Questo è quello che appartiene al carico de' Leviti: I Leviti, dall'età di venticinque anni in su, entrino in ufficio nel ministerio del Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Ma, da cinquant'anni in su, ritraggansi dall'esercizio dell'ufficio, e non servano più. Ben potrà un tale servire a' suoi fratelli nel Tabernacolo della convenenza, a far la lor fazione, ma non faccia più il servigio. Fa' così a' Leviti nelle loro fazioni. ");
INSERT INTO ita1885_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","IL Signore parlò ancora a Mosè, nel deserto di Sinai, nel primo mese dell'anno secondo dacchè i figliuoli d'Israele furono usciti del paese di Egitto, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Facciano i figliuoli d'Israele la Pasqua, nella sua stagione. ");
INSERT INTO ita1885_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Fatela nella sua stagione, nel quartodecimo giorno di questo mese, fra' due vespri; fatela secondo tutti i suoi statuti, e secondo tutti i suoi ordini. ");
INSERT INTO ita1885_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","E Mosè parlò a' figliuoli d'Israele, acciocchè facessero la Pasqua. ");
INSERT INTO ita1885_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Ed essi fecero la Pasqua nel quartodecimo giorno del primo mese, fra' due vespri, nel deserto di Sinai. I figliuoli d'Israele fecero interamente come il Signore avea comandato a Mosè. ");
INSERT INTO ita1885_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Or vi furono alcuni uomini, i quali, essendo immondi per una persona morta, non poterono far la Pasqua in quel giorno; laonde si presentarono davanti a Mosè e davanti ad Aaronne, in quel giorno stesso. ");
INSERT INTO ita1885_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","E dissero loro: Noi siamo immondi per una persona morta; perchè saremmo noi divietati di offerir l'offerta al Signore nella sua stagione, fra' figliuoli d'Israele? ");
INSERT INTO ita1885_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","E Mosè disse loro: Statevene; e io udirò cio che il Signore comanderà intorno a voi. ");
INSERT INTO ita1885_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","E il Signore parlò a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Parla a' figliuoli d'Israele, dicendo: Quando alcun di voi, o delle vostre generazioni, sarà immondo per una persona morta, ovvero sarà in viaggio lontano, non lasci però di far la Pasqua al Signore. ");
INSERT INTO ita1885_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Faccianla nel quartodecimo giorno del secondo mese, fra' due vespri; manginla con azzimi e con lattughe salvatiche. ");
INSERT INTO ita1885_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Non lascinne nulla di resto fino alla mattina; e non ne rompano osso alcuno; faccianla secondo tutti gli statuti della Pasqua. ");
INSERT INTO ita1885_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Ma, se alcuno è netto, e non è in viaggio, e pur si rimane di far la Pasqua; sia una tal persona ricisa da' suoi popoli; porti quell'uomo il suo peccato; perciocchè non ha offerta nella sua stagione l'offerta del Signore. ");
INSERT INTO ita1885_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","E quando alcuno straniere, dimorando con voi, farà la Pasqua del Signore, facciala secondo gli statuti e gli ordini di essa; siavi un medesimo statuto fra voi; così per lo forestiere, come per colui che è natio del paese. ");
INSERT INTO ita1885_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","OR nel giorno che il Tabernacolo fu rizzato, la nuvola coperse il Tabernacolo, di sopra il Padiglione della Testimonianza; e in su la sera era sopra il Tabernacolo in apparenza di fuoco, fino alla mattina. ");
INSERT INTO ita1885_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Così era del continuo; la nuvola lo copriva di giorno; e di notte vi era un'apparenza di fuoco. ");
INSERT INTO ita1885_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","E, secondo che la nuvola si alzava d'in sul Tabernacolo, i figliuoli d'Israele camminavano appresso; e dove la nuvola stanziava, quivi si accampavano i figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Al comandamento del Signore i figliuoli d'Israele si movevano, e altresì al comandamento del Signore si accampavano; e stavano accampati tutto il tempo che la nuvola stanziava sopra il Tabernacolo. ");
INSERT INTO ita1885_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","E quando la nuvola continuava a star per molti giorni in sul Tabernacolo, allora i figliuoli d'Israele attendevano alle fazioni del servigio del Signore, e non si partivano. ");
INSERT INTO ita1885_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","O fosse che la nuvola stesse pochi dì in sul Tabernacolo, al comandamento del Signore si accampavano, e altresì al comandamento del Signore si movevano. ");
INSERT INTO ita1885_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","O fosse che la nuvola vi stesse dalla sera fino alla mattina, e poi si alzasse in su la mattina, essi si movevano; o fosse che, statavi un giorno ed una notte, poi si alzasse, essi parimente si movevano. ");
INSERT INTO ita1885_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Per quanto tempo la nuvola continuava a stanziare in sul Tabernacolo, o fossero due dì, o un mese, o un anno, tanto se ne stavano i figliuoli d'Israele accampati, e non si movevano; poi, quando la nuvola si alzava, si movevano. ");
INSERT INTO ita1885_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Al comandamento del Signore si accampavano, e al comandamento del Signore si movevano; e al comandamento del Signore, dato per Mosè, attendevano alle fazioni del servigio del Signore. ");
INSERT INTO ita1885_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","IL Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Fatti due trombe d'argento, di lavoro tirato al martello, e servitene per adunar la raunanza, e per far movere i campi. ");
INSERT INTO ita1885_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","E quando si sonerà con amendue, adunisi tutta la raunanza appresso di te, all'entrata del Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","E quando si sonerà con una solamente, aduninsi appresso di te i principali, i capi delle migliaia d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","E quando voi sonerete con suono squillante, movansi i campi posti verso il levante. ");
INSERT INTO ita1885_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","E quando voi sonerete con suono squillante la seconda volta, movansi i campi posti verso il mezzodì. Suonisi con suono squillante ogni volta che i campi dovranno moversi. ");
INSERT INTO ita1885_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Ma quando voi adunerete la raunanza, sonate, ma non con suono squillante. ");
INSERT INTO ita1885_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","E suonino i figliuoli di Aaronne, sacerdoti, con quelle trombe; e usatele per istatuto perpetuo, per le vostre generazioni. ");
INSERT INTO ita1885_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","E quando nel vostro paese voi entrerete in battaglia contro al nemico che vi assalirà, allora sonate con le trombe, con suono squillante, ed e' sovverrà di voi al Signore Iddio vostro; e sarete salvati da' vostri nemici. ");
INSERT INTO ita1885_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Parimente a' giorni delle vostre allegrezze, e nelle vostre feste solenni, e nelle vostre calendi, sonate con le trombe, offerendo i vostri olocausti, e i vostri sacrificii da render grazie; ed esse vi saranno per ricordanza nel cospetto dell'Iddio vostro. Io sono il Signore Iddio vostro. ");
INSERT INTO ita1885_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","OR nell'anno secondo, nel secondo mese, nel ventesimo giorno del mese, avvenne che la nuvola si alzò d'in sul Tabernacolo della Testimonianza. ");
INSERT INTO ita1885_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","E i figliuoli d'Israele si mossero, secondo l'ordine delle lor mosse, dal deserto di Sinai; e la nuvola stanziò nel deserto di Paran. ");
INSERT INTO ita1885_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Così si mossero la prima volta, secondo che il Signore avea comandato per Mosè. ");
INSERT INTO ita1885_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","E la bandiera del campo de' figliuoli di Giuda si mosse la primiera, distinta per le sue schiere; essendo Naasson figliuolo di Amminadab, capo dell'esercito de' figliuoli di Giuda; ");
INSERT INTO ita1885_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","e Natanael, figliuolo di Suar, capo dell'esercito della tribù de' figliuoli d'Issacar; ");
INSERT INTO ita1885_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ed Eliab, figliuolo di Helon, capo dell'esercito della tribù de' figliuoli di Zabulon. ");
INSERT INTO ita1885_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","E, dopo che il Tabernacolo fu posto giù, i figliuoli di Gherson, e i figliuoli di Merari, si mossero, portando il Tabernacolo. ");
INSERT INTO ita1885_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Appresso si mosse la bandiera del campo di Ruben, distinta per le sue schiere; essendo Elisur, figliuolo di Sedeur, capo dell'esercito di Ruben; ");
INSERT INTO ita1885_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","e Selumiel, figliuolo di Surisaddai, capo dell'esercito della tribù de' figliuoli di Simeone; ");
INSERT INTO ita1885_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ed Eliasaf, figliuolo di Deuel, capo dell'esercito della tribù de' figliuoli di Gad. ");
INSERT INTO ita1885_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Poi si mossero i Chehatiti, che portavano il Santuario; e mentre essi arrivavano, gli altri rizzavano il Tabernacolo. ");
INSERT INTO ita1885_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Appresso si mosse la bandiera del campo de' figliuoli di Efraim, distinta per le sue schiere; essendo Elisama, figliuolo di Ammiud, capo dell'esercito de' figliuoli di Efraim; ");
INSERT INTO ita1885_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","e Gamliel, figliuolo di Pedasur, capo dell'esercito della tribù de' figliuoli di Manasse; ");
INSERT INTO ita1885_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","e Abidan, figliuolo di Ghidoni, capo dell'esercito della tribù de' figliuoli di Beniamino. ");
INSERT INTO ita1885_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Appresso si mosse la bandiera del campo de' figliuoli di Dan, distinta per le sue schiere; facendo retroguardia a tutti i campi; essendo Ahiezer, figliuolo di Ammisaddai, capo dell'esercito di Dan; ");
INSERT INTO ita1885_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","e Paghiel, figliuolo di Ocran, capo dell'esercito della tribù de' figliuoli di Aser; ");
INSERT INTO ita1885_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","e Ahira, figliuolo di Enan, capo dell'esercito della tribù de' figliuoli di Neftali. ");
INSERT INTO ita1885_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Queste erano le mosse de' figliuoli di Israele, distinti per le loro schiere, quando si movevano. ");
INSERT INTO ita1885_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Or Mosè disse a Hobab, figliuolo di Reuel, Madianita, suo suocero: Noi ci partiamo per andare al luogo del quale il Signore ha detto: Io vel darò; vieni con noi, e noi ti faremo del bene; conciossiachè il Signore abbia promesso del bene a Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Ed egli gli disse: Io non vi andrò; anzi me ne andrò al mio paese, e al mio parentado. ");
INSERT INTO ita1885_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Ma Mosè gli disse: Deh! non lasciarci; perciocchè, conoscendo tu i luoghi dove noi abbiamo da accamparci nel deserto, tu ci servirai di occhi. ");
INSERT INTO ita1885_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","E se tu vieni con noi, quando sarà avvenuto quel bene che il Signore ci vuol fare, noi ti faremo del bene. ");
INSERT INTO ita1885_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Così si partirono dal Monte del Signore; e fecero il cammino di tre giornate, andando l'Arca del Patto del Signore davanti a loro tre giornate, per investigar loro un luogo di riposo. ");
INSERT INTO ita1885_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","E quando si movevano dal luogo ove erano stati accampati, la nuvola del Signore era sopra loro, di giorno. ");
INSERT INTO ita1885_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","E, quando l'Arca si moveva, Mosè diceva: Levati su, o Signore, e sieno dispersi i tuoi nemici; e quelli che ti odiano fuggiranno per la tua presenza. ");
INSERT INTO ita1885_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","E, quando ella si posava, diceva: O Signore, riconduci le diecine delle migliaia delle schiere d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","OR il popolo mostrò di lamentarsi agli orecchi del Signore, come per disagio sofferto. E il Signore l'udì, e l'ira sua si accese, e il fuoco del Signore si apprese fra esso, e consumò una della estremità del campo. ");
INSERT INTO ita1885_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","E il popolo sclamò a Mosè. E Mosè pregò il Signore, e il fuoco fu ammorzato. ");
INSERT INTO ita1885_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","E fu posto nome a quel luogo Tabera; perciocchè il fuoco del Signore si apprese quivi in essi. ");
INSERT INTO ita1885_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","OR la turba della gente accogliticcia ch'era fra il popolo, si mosse a concupiscenza; e i figliuoli d'Israele anch'essi tornarono a piagnere, e dissero: Chi ci darà a mangiar della carne? ");
INSERT INTO ita1885_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","E' ci ricorda nel pesce che noi mangiavamo in Egitto per nulla, de' cocomeri, de' poponi, de' porri, delle cipolle, e degli agli. ");
INSERT INTO ita1885_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Laddove ora l'anima nostra è arida; e non abbiam nulla; noi non possiamo volger gli occhi sopra altro che sopra la Manna. ");
INSERT INTO ita1885_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","(Or la Manna era simile al seme di coriandolo; e il suo colore simile al color delle perle. ");
INSERT INTO ita1885_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","E il popolo si spandeva, e la raccoglieva; poi la macinava con le macine, o la pestava nel mortaio; e la coceva in pentole, o ne facea delle focaccie; e il sapore di essa era come il sapor di pastello oliato. ");
INSERT INTO ita1885_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","E, quando cadeva la rugiada in sul campo di notte, sopra essa cadea ancora la Manna). ");
INSERT INTO ita1885_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","E Mosè intese che il popolo piagneva per le sue famiglie, ciascuno all'entrata del suo padiglione. E l'ira del Signore si accese gravemente. Ciò dispiacque eziandio a Mosè. ");
INSERT INTO ita1885_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Ed egli disse al Signore: Perchè hai tu fatto questo male al tuo servitore? e perchè non ho io trovata grazia appo te, che tu mi abbi posto addosso il carico di tutto questo popolo? ");
INSERT INTO ita1885_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Ho io conceputo tutto questo popolo? l'ho io generato, perchè tu mi dica che io lo porti in seno, come il balio porta il fanciullo che poppa, nel paese che tu hai giurato a' padri loro? ");
INSERT INTO ita1885_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Onde avrei io della carne, per darne a tutto questo popolo? conciossiachè egli mi pianga appresso, dicendo: Dacci a mangiar della carne. ");
INSERT INTO ita1885_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Io solo non posso regger tutto questo popolo; perciocchè è troppo grave peso per me. ");
INSERT INTO ita1885_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","E se pur tu mi vuoi fare in cotesta maniera, uccidimi ti prego, se ho trovata grazia appo te; e non fare che io vegga il mio male. ");
INSERT INTO ita1885_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","E il Signore disse a Mosè: Adunami settant'uomini degli Anziani d'Israele, i quali tu conosci, essendo essi Anziani del popolo, e suoi rettori; e menali al Tabernacolo della convenenza; e compariscano quivi teco. ");
INSERT INTO ita1885_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","E io scenderò, e parlerò quivi teco, e metterò da parte dello Spirito che è sopra te, e lo metterò sopra loro; ed essi porteranno teco il carico del popolo, e tu non lo porterai solo. ");
INSERT INTO ita1885_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Or di' al popolo: Santificatevi per domani, e voi mangerete della carne; conciossiachè voi abbiate pianto agli orecchi del Signore, dicendo: Chi ci darà a mangiar della carne? certo noi stavamo bene in Egitto. Il Signore adunque vi darà della carne, e voi ne mangerete. ");
INSERT INTO ita1885_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Voi non ne mangerete sol un giorno, nè due, nè cinque, nè dieci, nè venti; ");
INSERT INTO ita1885_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ma fino a un mese intiero, finchè vi esca per le nari, e che l'abbiate in abbominio; poichè voi avete sprezzato il Signore che è nel mezzo di voi, e avete pianto davanti a lui, dicendo: Perchè siamo usciti di Egitto? ");
INSERT INTO ita1885_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","E Mosè disse: Questo popolo, fra il quale io sono, è di seicentomila uomini a piè; e tu hai detto: Io darò loro della carne, ed essi ne mangeranno un mese intiero. ");
INSERT INTO ita1885_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Scanneransi loro pecore e buoi, tantochè ne abbiano a sufficienza? rauneransi loro tutti i pesci del mare, tantochè ne abbiano quanto basti loro? ");
INSERT INTO ita1885_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","E il Signore disse a Mosè: È forse la mano del Signore raccorciata? ora vedrai se la mia parola ti avverrà o no. ");
INSERT INTO ita1885_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","E Mosè se ne uscì fuori, e rapportò al popolo le parole del Signore; e adunò settant'uomini degli Anziani del popolo, i quali fece stare in piè intorno al Tabernacolo. ");
INSERT INTO ita1885_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","E il Signore scese nella nuvola, e parlò a lui, e mise da parte dello Spirito, ch'era sopra lui, e lo mise sopra que' settant'uomini Anziani; e avvenne che, quando lo Spirito si fu posato sopra loro, profetizzarono, e da indi innanzi non restarono. ");
INSERT INTO ita1885_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Or due di quegli uomini erano rimasti nel campo; e il nome dell'uno era Eldad, e il nome dell'altro Medad; e lo Spirito si posò sopra loro. Or essi erano d'infra quelli ch' erano stati rassegnati; ma non erano usciti, per andare al Tabernacolo. E profetizzarono dentro al campo. ");
INSERT INTO ita1885_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","E un giovane corse, e rapportò la cosa a Mosè, dicendo: Eldad, e Medad, profetizzano dentro al campo. ");
INSERT INTO ita1885_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Allora Giosuè, figliuolo di Nun, che avea servito a Mosè fin dalla sua giovanezza, fece motto a Mosè, e gli disse: Signore mio Mosè, divietali. ");
INSERT INTO ita1885_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Ma Mosè gli disse: Sei tu geloso per me? anzi, fosse pur tutto il popolo del Signore profeta: e avesse pure il Signore messo il suo Spirito sopra loro. Poi Mosè si ricolse nel campo insieme con gli Anziani d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Mosè si ricolse nel campo insieme con gli Anziani d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","E un vento si levò, mosso dal Signore, e trasportò delle quaglie di verso il mare, e le gittò in sul campo, d'intorno a una giornata di cammino di qua, e una giornata di cammino di là, intorno al campo; e n'era l'altezza presso che di due cubiti in su la faccia della terra. ");
INSERT INTO ita1885_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","E il popolo si levò, e tutto quel giorno, e tutta quella notte, e tutto il dì seguente, raccolse delle quaglie; chi ne raccolse il meno, ne raccolse dieci omer; poi se le distesero al largo intorno al campo. ");
INSERT INTO ita1885_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Essi aveano ancora la carne fra' denti, e non era ancora mancata, quando l'ira del Signore si accese contro al popolo; e il Signore percosse il popolo d'una piaga grandissima. ");
INSERT INTO ita1885_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","E fu posto nome a quel luogo: Chibrot-taava; perciocchè quivi furono seppelliti que' del popolo che si erano mossi a concupiscenza. ");
INSERT INTO ita1885_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Da Chibrot-taava il popolo partì, traendo in Haserot, e si fermò in Haserot. ");
INSERT INTO ita1885_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","OR Maria ed Aaronne parlarono contro a Mosè, per cagion della moglie Cusita ch'egli avea presa; perciocchè egli avea presa una moglie Cusita. ");
INSERT INTO ita1885_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","E dissero: Ha veramente il Signore parlato sol per Mosè? non ha egli eziandio parlato per noi? E il Signore udì queste parole. ");
INSERT INTO ita1885_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Or quell'uomo Mosè era molto mansueto, più che altro uomo che fosse in su la terra.) ");
INSERT INTO ita1885_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","E il Signore disse in quello stante a Mosè, e ad Aaronne, e a Maria: Uscite tutti e tre, e venite al Tabernacolo della convenenza. Ed essi uscirono tutti e tre. ");
INSERT INTO ita1885_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","E il Signore scese nella colonna della nuvola, e si fermò all'entrata del Tabernacolo; e chiamò Aaronne e Maria. E amendue andarono là. ");
INSERT INTO ita1885_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","E il Signore disse: Ascoltate ora le mie parole: Se v'è fra voi alcun profeta, io, il Signore, mi do a conoscere a lui in visione, o parlo a lui in sogno. ");
INSERT INTO ita1885_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Ma non fo così inverso il mio servitore Mosè, il quale è fedele in tutta la mia casa. ");
INSERT INTO ita1885_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Io parlo a bocca a bocca con lui, e a veduta, e non con maniere oscure; ed egli vede la sembianza del Signore; perchè dunque non avete voi temuto di parlar contro al mio servitore, contro a Mosè? ");
INSERT INTO ita1885_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","E l'ira del Signore si accese contro a loro, ed egli se ne andò. ");
INSERT INTO ita1885_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","E la nuvola si partì d'in sul Tabernacolo; ed ecco, Maria era lebbrosa, bianca come neve; e Aaronne riguardò Maria; ed ecco, era lebbrosa. ");
INSERT INTO ita1885_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","E Aaronne disse a Mosè: Ahi! Signore mio; deh! non metterci peccato addosso; conciossiachè noi abbiamo follemente fatto, e abbiamo peccato. ");
INSERT INTO ita1885_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Deh! non sia ella come un parto morto, la cui carne, quando egli esce del seno di sua madre, è già mezza consumata. ");
INSERT INTO ita1885_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","E Mosè gridò al Signore, dicendo: Deh! sanala ora, o Dio. ");
INSERT INTO ita1885_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","E il Signore disse a Mosè: Se suo padre le avesse sputato nel viso, non sarebb'ella tutta vergognosa per sette giorni? Sia rinchiusa fuor del campo sette giorni; poi sia raccolta. ");
INSERT INTO ita1885_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Maria adunque fu rinchiusa fuor del campo sette giorni; e il popolo non si mosse, finchè Maria non fu raccolta. ");
INSERT INTO ita1885_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","POI il popolo si partì di Haserot, e si accampò nel deserto di Paran. ");
INSERT INTO ita1885_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","E il Signore parlò a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Manda degli uomini, che spiino il paese di Canaan, il quale io dono a' figliuoli d'Israele; mandate un uomo per tribù de' lor padri; tutti capi de' figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Mosè adunque mandò quegli uomini dal deserto di Paran, secondo il comandamento del Signore; e tutti erano capi de' figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","E questi sono i nomi loro: Sammua, figliuolo di Zaccui, della tribù di Ruben; ");
INSERT INTO ita1885_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Safat, figliuolo di Hori, della tribù di Simeone; ");
INSERT INTO ita1885_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Caleb, figliuolo di Gefunne, della tribù di Giuda; ");
INSERT INTO ita1885_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Igheal, figliuolo di Giuseppe, della tribù d'Issacar; ");
INSERT INTO ita1885_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Hosea, figliuolo di Nun, della tribù di Efraim; ");
INSERT INTO ita1885_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Palti, figliuolo di Rafu, della tribù di Beniamino; ");
INSERT INTO ita1885_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Gaddiel, figliuolo di Sodi, della tribù di Zabulon; ");
INSERT INTO ita1885_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Gaddi, figliuolo di Susi, dell'altra tribù di Giuseppe, cioè, della tribù di Manasse; ");
INSERT INTO ita1885_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Ammiel, figliuolo di Ghemalli, della tribù di Dan; ");
INSERT INTO ita1885_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Setur, figliuolo di Micael, della tribù di Aser; ");
INSERT INTO ita1885_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Nabi, figliuolo di Vofsi, della tribù di Neftali; ");
INSERT INTO ita1885_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Gheuel, figliuolo di Machi, della tribù di Gad. ");
INSERT INTO ita1885_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Questi sono i nomi degli uomini, che Mosè mandò per ispiare il paese (or Mosè avea posto nome Giosuè, a Hosea, figliuolo di Nun). ");
INSERT INTO ita1885_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Mosè adunque li mandò a spiare il paese di Canaan, e disse loro: Andate di qua, dal Mezzodi, poi salite al monte. ");
INSERT INTO ita1885_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","E vedete qual sia quel paese, e qual sia il popolo che abita in esso, se egli è forte o debole; se egli è in piccolo, o in gran numero. ");
INSERT INTO ita1885_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","E qual sia la terra nella quale egli abita, se ella è buona o cattiva; e quali sieno le città nelle quali egli abita, se abita in luoghi steccati, o in murati. ");
INSERT INTO ita1885_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","E qual sia il terreno, se è grasso o magro; e se vi son alberi, o no; e portatevi valentemente, e recate de' frutti del paese. Or allora era il tempo dell'uve primaticce. ");
INSERT INTO ita1885_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Essi adunque andarono, e spiarono il paese, dal deserto di Sin fino a Rehob, all'entrata d'Hamat. ");
INSERT INTO ita1885_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Poi salirono verso il mezzodì, e vennero fino in Hebron, dove erano Ahiman, Sesai e Talmai, nati da Anac. Or Hebron era stata edificata sette anni innanzi a Soan di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","E, giunti fino al torrente di Escol, tagliarono di là un tralcio con un grappolo d'uva, e lo portarono con una stanga a due; insieme con delle melagrane e dei fichi. ");
INSERT INTO ita1885_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","E, per cagione di quel grappolo d'uva che i figliuoli d'Israele ne tagliarono, fu posto nome a quel luogo, Nahal-escol. ");
INSERT INTO ita1885_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","E, in capo di quaranta giorni, tornarono da spiare il paese. ");
INSERT INTO ita1885_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","E andarono a Mosè e ad Aaronne, e a tutta la raunanza de' figliuoli d'Israele, nel deserto di Paran, di Cades; ove essendo giunti, rapportarono l'affare a loro, e a tutta la raunanza, e mostrarono loro que' frutti del paese. ");
INSERT INTO ita1885_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","E raccontarono il lor viaggio a Mosè, e dissero: Noi arrivammo nel paese nel quale tu ci mandasti; e certo è un paese che stilla latte e miele; ed ecco de' suoi frutti. ");
INSERT INTO ita1885_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Sol vi è questo, che il popolo che abita in esso, è potente, e le città son molto forti e grandi; e anche vi abbiamo veduti i figliuoli di Anac. ");
INSERT INTO ita1885_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Gli Amalechiti abitano nella contrada Meridionale; gl'Hittei, i Gebusei, e gli Amorrei abitano nel monte; e i Cananei abitano presso al mare, e lungo il Giordano. ");
INSERT INTO ita1885_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","E Caleb racquetò il popolo inverso Mosè, e disse: Andiamo pure in quel paese, e conquistiamolo; perciocchè di certo noi lo soggiogheremo. ");
INSERT INTO ita1885_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ma quegli uomini ch'erano andati con lui dissero: Egli non è in poter nostro di salir contro a quel popolo; conciossiachè egli sia troppo potente per noi. ");
INSERT INTO ita1885_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","E infamarono il paese che aveano spiato appresso i figliuoli d'Israele, dicendo: Il paese per lo quale siam passati, per ispiarlo, è un paese che divora i suoi abitanti; e tutto il popolo che noi abbiamo veduto in esso, sono uomini alti e grandi. ");
INSERT INTO ita1885_vpl VALUES ("NU13_34","005_13_34","NUM","13","34","34","Noi vi abbiamo eziandio veduti de' giganti, i figliuoli di Anac, della schiatta de' giganti; appetto a' quali ci pareva di esser locuste; e tali eziandio parevamo loro. ");
INSERT INTO ita1885_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","ALLORA tutta la raunanza alzò la voce, e diede di gran grida, e il popolo pianse quella notte. ");
INSERT INTO ita1885_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","E tutti i figliuoli d'Israele mormorarono contro a Mosè, e contro ad Aaronne; e tutta la raunanza disse loro: Fossimo pur morti nel paese di Egitto, o fossimo pur morti in questo deserto. ");
INSERT INTO ita1885_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","E perchè ci mena il Signore in quel paese, acciocchè siamo morti per la spada, e sieno le nostre mogli, e le nostre famiglie, in preda? non sarebb' egli meglio per noi di ritornarcene in Egitto? ");
INSERT INTO ita1885_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","E dissero l'uno all'altro: Costituiamoci un capo, e ritorniamocene in Egitto. ");
INSERT INTO ita1885_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Allora Mosè ed Aaronne si gittarono a terra sopra le lor facce, davanti a tutta la raunanza della comunanza de' figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","E Giosuè, figliuolo di Nun, e Caleb, figliuolo di Gefunne, ch'erano stati di quelli che aveano spiato il paese, si stracciarono i vestimenti; ");
INSERT INTO ita1885_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","e dissero a tutta la raunanza de' figliuoli d'Israele: Il paese, per lo quale siamo passati, per ispiarlo, è un buonissimo paese. ");
INSERT INTO ita1885_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Se il Signore ci è favorevole, egli c'introdurrà in quel paese, e cel darà; che è un paese stillante latte e miele. ");
INSERT INTO ita1885_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Sol non ribellatevi contro al Signore, e non abbiate paura del popolo di quel paese; conciossiachè essi sieno nostro pane; la loro ombra s'è dipartita d'in su loro; e il Signore è con noi; non abbiatene paura. ");
INSERT INTO ita1885_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Allora tutta la raunanza disse di lapidarli; ma la gloria del Signore apparve a tutti i figliuoli d'Israele, nel Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","E il Signore disse a Mosè: Infino a quando mi dispetterà questo popolo? e infino a quando non crederanno essi in me, per tutti i miracoli che io ho fatti nel mezzo di lui? ");
INSERT INTO ita1885_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Io lo percoterò di mortalità, e lo disperderò; e io ti farò divenire una nazione più grande, e più potente di lui. ");
INSERT INTO ita1885_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","E Mosè disse al Signore: Ma gli Egizj l'udiranno; conciossiachè tu abbi tratto fuori questo popolo del mezzo di loro, con la tua forza. ");
INSERT INTO ita1885_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","E diranno agli abitanti di questo paese, i quali hanno inteso che tu, Signore, sei nel mezzo di questo popolo, e che tu apparisci loro a vista d'occhio, e che la tua nuvola si ferma sopra loro, e che tu cammini davanti a loro in colonna di nuvola di giorno, e in colonna di fuoco di notte; ");
INSERT INTO ita1885_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","se, dico, tu fai morir questo popolo, come un solo uomo le genti che avranno intesa la tua fama, diranno: ");
INSERT INTO ita1885_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Perciocchè il Signore non ha potuto fare entrar cotesto popolo nel paese ch'egli avea lor giurato, egli li ha ammazzati nel deserto. ");
INSERT INTO ita1885_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Ora dunque, sia, ti prego, la potenza del Signore magnificata, e fa' secondo che tu hai parlato, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Il Signore è lento all'ira, e grande in benignità; egli perdona l'iniquità e il misfatto; ma altresì non assolve punto il colpevole; anzi fa punizione dell'iniquità de' padri sopra i figliuoli, infino alla terza e alla quarta generazione. ");
INSERT INTO ita1885_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Deh! perdona a questo popolo la sua iniquità, secondo la grandezza della tua benignità, e come tu gli hai perdonato dall'Egitto infin a qui. ");
INSERT INTO ita1885_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","E il Signore disse: io gli ho perdonato, secondo la tua parola. ");
INSERT INTO ita1885_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Ma pure, come io vivo, e come tutta la terra è ripiena della mia gloria; ");
INSERT INTO ita1885_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","niuno di quegli uomini che hanno veduta la mia gloria, e i miei miracoli che io ho fatti in Egitto, e nel deserto, e pur m'hanno tentato già dieci volte, e non hanno ubbidito alla mia voce; ");
INSERT INTO ita1885_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","non vedrà il paese, il quale ho giurato a' lor padri; niuno di quelli che m'hanno dispettato non lo vedrà. ");
INSERT INTO ita1885_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ma, quant'è a Caleb, mio servitore, perchè in lui è stato un altro spirito, e m'ha seguitato appieno, io l'introdurrò nel paese nel quale egli è andato, e la sua progenie lo possederà. ");
INSERT INTO ita1885_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Or gli Amalechiti e i Cananei abitano nella Valle, e però domani voltate faccia, e camminate verso il deserto, traendo verso il mar rosso. ");
INSERT INTO ita1885_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Il Signore parlò ancora a Mosè e ad Aaronne, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Infino a quando sofferirò io questa malvagia raunanza, che mormora contro a me? io ho uditi i mormorii de' figliuoli d'Israele, co' quali mormorano contro a me. ");
INSERT INTO ita1885_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Di' loro: Come io vivo, dice il Signore, io vi farò come voi avete parlato a' miei orecchi. ");
INSERT INTO ita1885_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","I vostri corpi caderanno morti in questo deserto; e quant'è a tutti gli annoverati d'infra voi, seconda tutto il vostro numero, dall'età di vent'anni in su, che avete mormorato contro a me; ");
INSERT INTO ita1885_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","se voi entrate nel paese del quale io alzai la mano che io vi ci stanzierei; salvo Caleb, figliuolo di Gefunne; e Giosuè, figliuolo di Nun. ");
INSERT INTO ita1885_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ma io ci farò entrare i vostri piccoli fanciulli, de' quali voi avete detto che sarebbero in preda; ed essi conosceranno che cosa è il paese, il quale voi avete sdegnato. ");
INSERT INTO ita1885_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Ma di voi i corpi caderanno morti in questo deserto. ");
INSERT INTO ita1885_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","E i vostri figliuoli andranno pasturando nel deserto, per quarant'anni, e porteranno la pena delle vostre fornicazioni, finchè i vostri corpi morti sieno consumati nel deserto. ");
INSERT INTO ita1885_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Voi porterete la pena delle vostre iniquità per quarant'anni, secondo il numero de' quaranta giorni che siete stati in ispiare il paese, un anno per un giorno; e voi conoscerete come io rompo le mie promesse. ");
INSERT INTO ita1885_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Io il Signore ho parlato. Se io non fo questo a tutta questa malvagia raunanza, che si è convenuta contro a me; essi verranno meno in questo deserto, e vi morranno. ");
INSERT INTO ita1885_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","E quegli uomini che Mosè avea mandati per ispiare il paese, i quali, essendo tornati, aveano fatta mormorar tutta la raunanza contro a lui, infamando quel paese; ");
INSERT INTO ita1885_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","quegli uomini, dico, che aveano sparso un cattivo grido di quel paese, morirono di piaga, davanti al Signore. ");
INSERT INTO ita1885_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Ma Giosuè, figliuolo di Nun, e Caleb, figliuolo di Gefunne, restarono in vita, d'infra quelli ch'erano andati per ispiare il paese. ");
INSERT INTO ita1885_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Or Mosè riferì quelle parole a tutti i figliuoli d'Israele; e il popolo ne fece un gran cordoglio. ");
INSERT INTO ita1885_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","E la mattina seguente si levarono, e salirono alla sommità del monte, dicendo: Eccoci; noi saliremo al luogo che il Signore ha detto; perciocchè noi abbiamo peccato. ");
INSERT INTO ita1885_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Ma Mosè disse: Perchè trapassate il comandamento del Signore? ciò non prospererà. ");
INSERT INTO ita1885_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Non salite; conciossiachè il Signore non sia nel mezzo di voi; che talora, se vi affrontate co' vostri nemici, non siate sconfitti. ");
INSERT INTO ita1885_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Perchè colà davanti a voi son gli Amalechiti, e i Cananei, e voi sarete morti per la spada; perciocchè voi vi siete rivolti di dietro al Signore; ed egli non sarà con voi. ");
INSERT INTO ita1885_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Nondimeno essi si attentarono temerariamente di salire alla sommità del monte; ma l'Arca del Patto del Signore, e Mosè non si mossero di mezzo al campo. ");
INSERT INTO ita1885_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","E gli Amalechiti, e i Cananei, che abitavano in quel monte, scesero giù, e li percossero, e li ruppero, perseguendoli fino in Horma. ");
INSERT INTO ita1885_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","POI il Signore parlò a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Parla a' figliuoli d'Israele, e di' loro: Quando voi sarete entrati nel paese, dove avete ad abitare, il quale io vi do; ");
INSERT INTO ita1885_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","e farete alcun sacrificio da ardere al Signore, come olocausto, o altro sacrificio, per singolar voto, o per ispontanea volontà, o nelle vostre feste solenni, per offerir soave odore, del grosso o del minuto bestiame, al Signore; ");
INSERT INTO ita1885_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","offerisca colui che farà la sua offerta al Signore, un'offerta di panatica della decima parte d'un efa di fior di farina, stemperata con la quarta parte d'un hin d'olio; ");
INSERT INTO ita1885_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","e la quarta parte di un hin di vino, per offerta da spandere. Questo offerirai per ciascuno olocausto, o altro sacrificio che sia d'un agnello. ");
INSERT INTO ita1885_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","E se fai offerta di panatica per un montone, offeriscila di due decimi di fior di farina, stemperata col terzo d'un hin d'olio. ");
INSERT INTO ita1885_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","E per offerta da spandere, offerisci il terzo d'un hin di vino, in odor soave al Signore. ");
INSERT INTO ita1885_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","E se tu offerisci al Signore un giovenco per olocausto, o per altro sacrificio, per singolar voto, o per sacrificio da render grazie; ");
INSERT INTO ita1885_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","offerisci, insieme col giovenco, un'offerta di panatica, di tre decimi di fior di farina, stemperata con la metà d'un hin d'olio. ");
INSERT INTO ita1885_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","E, per offerta da spandere, offerisci la metà d'un hin di vino; il tutto in offerta da ardere, di soave odore al Signore. ");
INSERT INTO ita1885_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Facciasi così per ciascun bue, per ciascun montone, e per ciascuna minuta bestia, pecora o capra. ");
INSERT INTO ita1885_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Fate così per ciascuna di quelle bestie, secondo il numero che ne sacrificherete. ");
INSERT INTO ita1885_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Chiunque è natio del paese offerisca queste cose in questa maniera, per presentare offerta da ardere, di soave odore, al Signore. ");
INSERT INTO ita1885_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","E quando alcuno straniere che dimorerà appresso di voi, o qualunque altro sarà fra voi, per le vostre generazioni, farà offerta da ardere, di soave odore al Signore, faccia così come farete voi. ");
INSERT INTO ita1885_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Siavi un medesimo statuto per voi, e per lo forestiere che dimora con voi che siete della raunanza. Sia questo uno statuto perpetuo per le vostre generazioni. Davanti al Signore il forestiere sarà come voi. ");
INSERT INTO ita1885_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Una medisima legge, e una medesima ragione sarà per voi, e per lo straniere che dimora con voi. ");
INSERT INTO ita1885_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Il Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Parla a' figliuoli d'Israele, e di' loro: Quando voi sarete entrati nel paese, dove io vi conduco; ");
INSERT INTO ita1885_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","quando voi mangerete del pane del paese, offeritene un'offerta al Signore. ");
INSERT INTO ita1885_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Offerite una focaccia per offerta, delle primizie delle vostre paste; offeritela nella medesima maniera, come l'offerta dell'aia. ");
INSERT INTO ita1885_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Date al Signore, per le vostre generazioni, un'offerta delle primizie delle vostre paste. ");
INSERT INTO ita1885_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Ora, quando voi avrete fallito per errore, e non avrete eseguiti tutti questi comandamenti che il Signore ha dati a Mosè; ");
INSERT INTO ita1885_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","tutto quello che il Signore vi ha comandato per Mosè, fin dal dì che egli vi ha dati comandamenti per le vostre generazioni; ");
INSERT INTO ita1885_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","se l'errore è stato commesso per inavvertenza della raunanza, offerisca tutta la raunanza per olocausto, in soave odore al Signore, un giovenco, con la sua offerta di panatica e da spandere, secondo l'ordinazione; e un becco per sacrificio per lo peccato. ");
INSERT INTO ita1885_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","E faccia il sacerdote il purgamento per tutta la raunanza de' figliuoli d'Israele, e sarà loro perdonato; perciocchè è errore, ed essi hanno addotta davanti al Signore la loro offerta da ardere al Signore, e il sacrificio per lo peccato, per l'error loro. ");
INSERT INTO ita1885_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Così sarà perdonato a tutta la raunanza de' figliuoli d'Israele, e parimente a' forestieri che dimoreranno fra loro; perciocchè tutto il popolo ha parte in quell'errore. ");
INSERT INTO ita1885_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Ma, se una sola persona ha peccato per errore, offerisca una capra di un anno, per lo peccato. ");
INSERT INTO ita1885_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","E faccia il sacerdote il purgamento per quella persona che avrà peccato per errore, peccando per errore nel cospetto del Signore; e quando il sacerdote avrà fatto purgamento per essa, le sarà perdonato. ");
INSERT INTO ita1885_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Siavi una medesima legge per chiunque avrà fatta alcuna cosa per errore, così se sarà de' figliuoli d'Israele, natio del paese, come se sarà forestiere, che dimori fra loro. ");
INSERT INTO ita1885_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Ma la persona, così il natio del paese, come il forestiere, che farà alcun atto a mano alzata, oltraggia il Signore; e però sia una cotal persona ricisa d'infra il suo popolo. ");
INSERT INTO ita1885_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Conciossiachè abbia sprezzata la parola del Signore, e abbia rotto il suo comandamento, del tutto sia quella persona ricisa; sia la sua iniquità sopra essa. ");
INSERT INTO ita1885_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","ORA, essendo i figliuoli d'Israele nel deserto, trovarono un uomo che ricoglieva delle legne in giorno di Sabato. ");
INSERT INTO ita1885_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","E, coloro che lo trovarono cogliendo delle legne, lo menarono a Mosè, e ad Aaronne, e a tutta la raunanza. ");
INSERT INTO ita1885_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","E lo misero in prigione; perciocchè non era stato dichiarato ciò che se gli avesse a fare. ");
INSERT INTO ita1885_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","E il Signore disse a Mosè: Del tutto sia quell'uomo fatto morire; lapidilo tutta la raunanza fuor del campo. ");
INSERT INTO ita1885_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","E tutta la raunanza lo menò fuor del campo, e lo lapidò, sicchè egli morì; come il Signore avea comandato a Mosè. ");
INSERT INTO ita1885_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","IL Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Parla a' figliuoli d'Israele, e di' loro, che si facciano delle fimbrie ai lembi delle lor veste, per le lor generazioni; e mettano sopra quelle fimbrie de' lor lembi un cordone di violato. ");
INSERT INTO ita1885_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","E abbiate quel cordone in su le fimbrie, acciocchè, quando lo riguarderete, voi vi ricordiate di tutti i comandamenti del Signore, e li mettiate in opera, e non andiate guatando dietro al vostro cuore, e agli occhi vostri, dietro a' quali solete andar fornicando. ");
INSERT INTO ita1885_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Acciocchè vi ricordiate di mettere in opera tutti i miei comandamenti, e siate santi all'Iddio vostro. ");
INSERT INTO ita1885_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Io sono il Signore Iddio vostro, che vi ho tratti fuor del paese di Egitto, per esservi Dio. Io sono il Signore Iddio vostro. ");
INSERT INTO ita1885_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","OR Core, figliuolo d'Ishar, figliuolo di Chehat, figliuolo di Levi; e Datan e Abiram, figliuoli di Eliab; e On, figliuolo di Pelet, avendo presi degli altri seco; ");
INSERT INTO ita1885_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","si levarono in presenza di Mosè, con dugencinquant'uomini de' figliuoli d'Israele, ch'erano de' principali della raunanza, che si solevano chiamare alla raunata del popolo, uomini di nome. ");
INSERT INTO ita1885_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","E, adunatisi contro a Mosè, e contro ad Aaronne, disser loro: Bastivi; perciocchè tutta la raunanza è santa, e il Signore è nel mezzo di loro; perchè dunque v'innalzate sopra la raunanza del Signore? ");
INSERT INTO ita1885_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Quando Mosè ebbe ciò inteso, egli si gittò a terra sopra la sua faccia. ");
INSERT INTO ita1885_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","E parlò a Core, e a tutto il suo seguito, dicendo: Domattina farà il Signore conoscere chi è suo, e chi è santo, e lo farà accostare a sè; egli farà accostare a sè chi egli avrà eletto. ");
INSERT INTO ita1885_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Fate questo: Tu, Core, e tutti voi che siete del suo seguito, prendete de' turiboli. ");
INSERT INTO ita1885_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","E domani mettete in essi del fuoco, e ponetevi su del profumo nel cospetto del Signore; e colui che il Signore avrà eletto sarà il Santo. Bastivi, figliuoli di Levi. ");
INSERT INTO ita1885_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Mosè, oltre a ciò, disse a Core: Deh! ascoltate, figliuoli di Levi. ");
INSERT INTO ita1885_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","È egli troppo poco per voi, che l'Iddio d'Israele v'abbia appartati della raunanza d'Israele, per farvi accostare a sè, per fare il servigio del Tabernacolo del Signore, e per presentarvi davanti alla raunanza, per fare il suo ministerio? ");
INSERT INTO ita1885_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","E ch'egli abbia in effetto fatto accostar te, e tutti i tuoi fratelli, figliuoli di Levi, teco; che voi procacciate ancora il sacerdozio? ");
INSERT INTO ita1885_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Perciò, tu, e tutto il tuo seguito, siete quelli che si son convenuti contro al Signore; e che cosa è Aaronne, che voi mormorate contro a lui? ");
INSERT INTO ita1885_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Mosè mandò ancora a chiamar Datan e Abiram, figliuoli di Eliab; ma essi dissero: Noi non ci andremo. ");
INSERT INTO ita1885_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","È egli poca cosa che tu ci abbi tratti fuor di un paese stillante latte e miele, per farci morir nel deserto, che tu vogli eziandio assolutamente fare il principe sopra noi? ");
INSERT INTO ita1885_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ma, lasciamo che tu non ci abbi condotti in un paese stillante latte e miele, avessici data almeno qualche possessione di campi o di vigne! Pensi tu di abbacinar gli occhi di questi uomini? Noi non ci andremo. ");
INSERT INTO ita1885_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Allora Mosè si adirò forte, e disse al Signore: Non riguardare alla loro offerta; io non ho preso nulla di quel d'alcun di loro, non pure un asino; e non ho offeso alcun di loro. ");
INSERT INTO ita1885_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Poi Mosè disse a Core: Comparite domani, tu, e tutti quelli del tuo seguito, davanti al Signore; Aaronne vi comparirà anch'esso. ");
INSERT INTO ita1885_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","E prenda ciascun di voi il suo turibolo, e mettavi del profumo, e rechi ciascuno il suo turibolo, davanti al Signore, che saranno dugencinquanta turiboli. Tu ancora, ed Aaronne, abbiate ciascuno il suo turibolo. ");
INSERT INTO ita1885_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Essi adunque presero ciascuno il suo turibolo, e postovi del fuoco, vi misero del profumo; e si fermarono all'entrata del Tabernacolo della convenenza. Il simigliante fecero ancora Mosè ed Aaronne. ");
INSERT INTO ita1885_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","E Core adunò tutta la raunanza contro a loro, all'entrata del Tabernacolo della convenenza; e la gloria del Signore apparve a tutta la raunanza. ");
INSERT INTO ita1885_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","E il Signore parlò a Mosè e ad Aaronne, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Separatevi di mezzo di questa raunanza, e in un momento io li consumerò. ");
INSERT INTO ita1885_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Ma essi, gittatisi in terra sopra la faccia, dissero: O Dio, Dio degli spiriti d'ogni carne, quest'uomo solo avendo peccato, ti adireresti tu contro a tutta la raunanza? ");
INSERT INTO ita1885_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","E il Signore parlò a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Parla alla raunanza, dicendo: Ritraetevi d'intorno a' padiglioni di Core, di Datan, e di Abiram. ");
INSERT INTO ita1885_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","E Mosè si levò, e andò a Datan, e ad Abiram; e gli Anziani d'Israele andarono dietro a lui. ");
INSERT INTO ita1885_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Ed egli parlò alla raunanza, dicendo: Deh! dipartitevi d'appresso a' padiglioni di cotesti malvagi uomini, e non toccate cosa alcuna loro; che talora non periate per tutti i lor peccati. ");
INSERT INTO ita1885_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Ed essi si dipartirono d'appresso a' padiglioni di Core, di Datan, e di Abiram, d'ogni intorno. Or Datan e Abiram uscirono fuori, e si fermarono all'entrata de' lor padiglioni, con le lor mogli, i lor figliuoli, e le lor famiglie. ");
INSERT INTO ita1885_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","E Mosè disse: Da questo conoscerete che il Signore mi ha mandato, per far tutte queste opere; conciossiachè io non l'abbia fatte di mio senno. ");
INSERT INTO ita1885_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Se costoro muoiono nella maniera di tutti gli uomini, e son puniti come tutti gli altri uomini, il Signore non mi ha mandato. ");
INSERT INTO ita1885_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Ma, se il Signore crea una cosa nuova, tal che la terra apra la sua bocca, e li tranghiottisca, insieme con tutto quello che appartiene loro, sì che scendano vivi nell'inferno, voi conoscerete che questi uomini hanno dispettato il Signore. ");
INSERT INTO ita1885_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Ed egli avvenne che, come egli ebbe finito di proferire tutte queste parole, la terra ch'era sotto coloro si fendè, ");
INSERT INTO ita1885_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","e aperse la sua bocca, e li tranghiottì, insieme con le lor case; e parimente tutte le persone appartenenti a Core, e tutta la roba. ");
INSERT INTO ita1885_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","E scesero vivi nell'inferno, insieme con tutto quello che apparteneva loro; e la terra li coperse, ed essi perirono d'infra la raunanza. ");
INSERT INTO ita1885_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","E tutti gl'Israeliti ch'erano intorno a loro fuggirono al grido loro; perciocchè dicevano: Che la terra non ci tranghiottisca. ");
INSERT INTO ita1885_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Oltre a ciò, un fuoco uscì d'appresso al Signore, il qual consumò que' dugencinquant'uomini, che offerivano il profumo. ");
INSERT INTO ita1885_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Appresso, il Signore parlò a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Di' a Eleazaro, figliuolo del Sacerdote Aaronne, che raccolga i turiboli di mezzo dell'arsione, spargendone via il fuoco; perciocchè sono sacri. ");
INSERT INTO ita1885_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","E dei turiboli di costoro che han peccato contro alle lor proprie anime, facciansene delle piastre distese, da coprir l'Altare; perciocchè essi li hanno presentati davanti al Signore, e sono sacri; e sieno per segnale a' figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","E il sacerdote Eleazaro prese que' turiboli di rame, i quali coloro ch'erano stati arsi aveano presentati; e furono distesi in piastre, per coprir l'Altare, ");
INSERT INTO ita1885_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","per ricordanza a' figliuoli d'Israele; acciocchè alcun uomo straniere, che non è della progenie d'Aaronne, non si accosti per far profumo davanti al Signore; e non sia come Core, e come que' del suo seguito; siccome il Signore avea comandato a Eleazaro, per Mosè. ");
INSERT INTO ita1885_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","E il giorno seguente tutta la raunanza de' figliuoli d'Israele mormorò contro a Mosè, e contro ad Aaronne, dicendo: Voi avete fatto morire il popolo del Signore. ");
INSERT INTO ita1885_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","E avvenne che, come la raunanza si adunava contro a Mosè, e contro ad Aaronne, i figliuoli d'Israele riguardarono verso il Tabernacolo della convenenza; ed ecco, la nuvola lo coperse, e la gloria del Signore apparve. ");
INSERT INTO ita1885_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","E Mosè ed Aaronne vennero davanti al Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","E il Signore parlò a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Levatevi di mezzo di questa raunanza, e io la consumerò in un momento. Ma essi si gittarono a terra sopra le lor facce. ");
INSERT INTO ita1885_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","E Mosè disse ad Aaronne: Prendi il turibolo, e mettivi del fuoco d'in su l'Altare, e ponvi del profumo, e va' prestamente alla raunanza, e fa' purgamento per loro; perciocchè una grave ira è proceduta d'innanzi al Signore; la piaga è già cominciata. ");
INSERT INTO ita1885_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","E Aaronne prese il turibolo, come Mosè avea detto, e corse in mezzo della raunanza; ed ecco, la piaga era già cominciata fra il popolo; ed egli mise il profumo in sul turibolo, e fece purgamento per lo popolo. ");
INSERT INTO ita1885_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","E si fermò fra i vivi e i morti; e la piaga fu arrestata. ");
INSERT INTO ita1885_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","E i morti per quella piaga furono quattordicimila settecento persone; oltre a quelli ch'erano morti per lo fatto di Core. ");
INSERT INTO ita1885_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","E la piaga essendo arrestata, Aaronne se ne ritornò a Mosè, all'entrata del Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","POI il Signore parlò a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Parla a' figliuoli d'Israele, e prendi da loro una verga per ciascuna nazione paterna; dodici verghe, da tutti i capi delle lor nazioni paterne; e scrivi il nome di ciascum d'essi sopra la sua verga. ");
INSERT INTO ita1885_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","E scrivi il nome di Aaronne sopra la verga di Levi; perciocchè v'ha da essere una verga per ciascun capo di nazione paterna. ");
INSERT INTO ita1885_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Poi riponi quelle verghe nel Tabernacolo della convenenza, davanti alla Testimonianza, dove io mi ritrovo con voi. ");
INSERT INTO ita1885_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","E avverrà che la verga di colui che io avrò eletto germoglierà; e così acqueterò d'attorno a me i mormorii de' figliuoli d'Israele, co' quali mormorano contro a voi. ");
INSERT INTO ita1885_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Mosè adunque parlò a' figliuoli d'Israele; e tutti i lor capi gli diedero una verga per ciascun capo delle lor nazioni paterne, che furono dodici verghe; e la verga d'Aaronne era per mezzo le lor verghe. ");
INSERT INTO ita1885_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","E Mosè ripose quelle verghe davanti al Signore, nel Tabernacolo della Testimonianza. ");
INSERT INTO ita1885_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","E il giorno seguente, essendo Mosè entrato nel Tabernacolo della Testimonianza, ecco, la verga d'Aaronne, ch'era per la nazione di Levi, era germogliata; e avea messe gemme, e prodotti fiori, e maturate delle mandorle. ");
INSERT INTO ita1885_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","E Mosè trasse fuori tutte quelle verghe d'innanzi al Signore, e le recò a tutti i figliuoli d'Israele; i quali le videro, e ciascuno prese la sua verga. ");
INSERT INTO ita1885_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","E il Signore disse a Mosè: Riporta la verga d'Aaronne davanti alla Testimonianza; acciocchè sia guardata per segnale a' ribelli; e così fa' restar d'attorno a me i lor mormorii; che talora non muoiano. ");
INSERT INTO ita1885_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","E Mosè fece così; come il Signore gli avea comandato, così fece. ");
INSERT INTO ita1885_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","E i figliuoli d'Israele dissero a Mosè: Ecco, noi siam morti, noi siam perduti, noi tutti siam perduti. ");
INSERT INTO ita1885_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Chiunque si accosta al Tabernacolo del Signore muore; morremo noi tutti quanti? ");
INSERT INTO ita1885_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","E IL Signore disse ad Aaronne: Tu, e i tuoi figliuoli, e la casa di tuo padre teco, porterete l'iniquità che si commetterà intorno al Santuario; e, parimente, tu, e i tuoi figliuoli, porterete l'iniquità che si commetterà nel vostro sacerdozio. ");
INSERT INTO ita1885_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Or fa' eziandio accostar teco i tuoi fratelli, la tribù di Levi, che è la tribù tua paterna, e sienti aggiunti, e ti ministrino; ma tu, e i tuoi figliuoli teco, state davanti al Tabernacolo della Testimonianza. ");
INSERT INTO ita1885_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","E facciano essi la fazione che tu ordinerai loro, e la fazione di tutto il Tabernacolo; ma non appressinsi agli arredi del Santuario, nè all'Altare; che talora non muoiano essi, e voi ancora. ");
INSERT INTO ita1885_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Sienti adunque aggiunti, e facciano la fazione del Tabernacolo della convenenza, in ogni suo servigio; niuno straniere non si accosti a voi. ");
INSERT INTO ita1885_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","E voi fate la fazione del Santuario e dell'Altare, acciocchè non vi sia più ira contro a' figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","E, quant'è a me, ecco, io ho presi i vostri fratelli, i Leviti, d'infra i figliuoli d'Israele; essi vi son dati in dono da parte del Signore, per fare i servigi del Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Ma tu, e i tuoi figliuoli teco, fate l'ufficio del vostro sacerdozio, in tutte le cose che si devono far nell'Altare, e dentro della Cortina, e fate il servigio; io vi dono il vostro sacerdozio per ministerio dato in dono in proprio; e però facciasi morir lo straniere che vi si accosterà. ");
INSERT INTO ita1885_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Il Signore parlò ancora ad Aaronne, dicendo: Ecco, io t'ho donate le mie offerte elevate, per una ordinazione da osservarsi; di tutte le cose consacrate da' figliuoli d'Israele, io dono quelle a te, e a' tuoi figliuoli, per istatuto perpetuo, in virtù dell'Unzione. ");
INSERT INTO ita1885_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Questo sarà tuo delle cose santissime, rimaste del fuoco; tutte le loro offerte delle loro oblazioni di panatica, e di tutti i lor sacrificii per lo peccato, e di tutti lor sacrificii per la colpa, che mi presenteranno per soddisfazione, che son cose santissime, saranno tue, e de' tuoi figliuoli. ");
INSERT INTO ita1885_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Mangiale in luogo santissimo; mangine ogni maschio; sienti cosa santa. ");
INSERT INTO ita1885_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Questo ancora sia tuo, cioè: l'offerte elevate di tutte le cose che i figliuoli d'Israele avranno presentate in dono, e di tutte le loro offerte dimenate; io dono quelle a te, e a' tuoi figliuoli, e alle tue figliuole, teco, per istatuto perpetuo; mangine chiunque sarà netto in casa tua. ");
INSERT INTO ita1885_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Io ti dono parimente tutto il fior dell'olio, tutto il fior del mosto, e del frumento, delle lor primizie, che presenteranno al Signore. ");
INSERT INTO ita1885_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Sieno tuoi i primi frutti di tutto ciò che nascerà nella lor terra, i quali essi presenteranno al Signore; mangine chiunque sarà netto in casa tua. ");
INSERT INTO ita1885_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Sia tua ogni cosa interdetta in Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Sia tuo tutto ciò che apre la matrice, d'ogni carne che si offerisce al Signore, così degli uomini come delle bestie; ma del tutto fa' che si riscatti il primogenito dell'uomo; fa' parimente che si riscatti il primogenito della bestia immonda. ");
INSERT INTO ita1885_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","E fa' riscattare i primogeniti degli uomini che conviene riscattare, dall'età d'un mese, secondo la tua estimazione, che sarà di cinque sicli d'argento, a siclo di Santuario, che è di vent'oboli; ");
INSERT INTO ita1885_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","ma non lasciar riscattare il primogenito della vacca, nè il primogenito della pecora, nè il primogenito della capra; sono cosa sacra; spandi il sangue loro sopra l'Altare; e brucia il lor grasso, per offerta da ardere, in soave odore al Signore. ");
INSERT INTO ita1885_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","E sia la lor carne tua, come il petto dell'offerta dimenata, e come la spalla destra. ");
INSERT INTO ita1885_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Io dono a te e a' tuoi figliuoli, e alle tue figliuole, teco, per istatuto perpetuo, tutte le offerte elevate delle cose consacrate, che i figliuoli d'Israele offeriranno al Signore. Questa è una convenzione di sale; perpetua davanti al Signore, per te, e per la tua progenie teco. ");
INSERT INTO ita1885_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Il Signore disse ancora ad Aaronne: Tu non avrai alcuna eredità nella terra loro, e non avrai parte fra loro. Io son la tua parte, e la tua eredità fra' figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","E a' figliuoli di Levi: Ecco, io dono tutte le decime in Israele, per eredità, per ricompensa del lor servigio che fanno intorno al Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","E non accostinsi più i figliuoli d'Israele al Tabernacolo della convenenza; acciocchè non portino peccato, e non muoiano. ");
INSERT INTO ita1885_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Ma facciano i Leviti il servigio del Tabernacolo della convenenza; ed essi porteranno la loro iniquità (questo è uno statuto perpetuo per le vostre generazioni); ed essi non possederanno alcuna possessione fra' figliuoli d'Israele; ");
INSERT INTO ita1885_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","conciossiachè io abbia data a' Leviti in eredità le decime, delle quali i figliuoli d'Israele offeriranno offerta al Signore. Perciò ho detto di loro, che non posseggano alcuna eredità fra' figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","E il Signore parlò, oltre a ciò, a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Parla ancora a' Leviti, e di' loro: Quando voi avrete ricevute da' figliuoli d'Israele le decime che io vi dono a prender da loro, per vostra eredità, offeritene ancora voi un' offerta al Signore, le decime delle decime. ");
INSERT INTO ita1885_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","E la vostra offerta vi sarà imputata, come grano tolto dall'aia, e mosto del tino. ");
INSERT INTO ita1885_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Così ancora voi offerirete offerta al Signore di tutte le vostre decime che riceverete da' figliuoli d'Israele; e ne darete l'offerta del Signore al Sacerdote Aaronne. ");
INSERT INTO ita1885_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Offerite, di tutte le cose che vi saranno donate, l'offerta del Signore tutta intera; offerite di tutto il meglio di quelle cose la parte che n'ha da essere consacrata. ");
INSERT INTO ita1885_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Di' loro ancora: Quando avrete offerto il meglio di quelle cose, egli sarà imputato a' Leviti, come rendita d'aia, e rendita di tino. ");
INSERT INTO ita1885_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Poi potrete mangiar quelle cose in qualunque luogo, e voi, e le vostre famiglie; perciocchè son vostra mercede, in ricompensa del vostro servigio intorno al Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","E quando avrete offerto il meglio di quelle cose, voi non porterete peccato per quelle, e non profanerete le cose consacrate dai figliuoli d'Israele, e non morrete. ");
INSERT INTO ita1885_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","IL Signore parlò ancora a Mosè e ad Aaronne, dicendo: Questo è uno statuto e legge che il Signore ha data, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Di' a' figliuoli d'Israele che ti adducano una giovenca rossa intiera, senza difetto, la quale non abbia ancora portato giogo. ");
INSERT INTO ita1885_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","E datela al Sacerdote Eleazaro, ed esso la meni fuor del campo, e la faccia scannare in sua presenza. ");
INSERT INTO ita1885_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","E prenda il Sacerdote Eleazaro del sangue di essa col suo dito, e spruzzine verso la parte anteriore del Tabernacolo della convenenza sette volte. ");
INSERT INTO ita1885_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Poi brucisi quella giovenca davanti agli occhi di esso; brucisi la sua pelle, la sua carne, il suo sangue, insieme col suo sterco. ");
INSERT INTO ita1885_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Poi prenda il Sacerdote del legno di cedro, dell'isopo, e dello scarlatto; le gitti quelle cose in mezzo del fuoco, nel quale si brucerà la giovenca. ");
INSERT INTO ita1885_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Appresso lavisi il Sacerdote i vestimenti, e le carni, con acqua; e poi rientri nel campo, e sia immondo infino alla sera. ");
INSERT INTO ita1885_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Parimente colui che avrà bruciata la giovenca lavisi i vestimenti, e le carni, con acqua; e sia immondo infino alla sera. ");
INSERT INTO ita1885_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","E raccolga un uomo netto la cenere della giovenca, e ripongala fuor del campo, in un luogo netto; e sia quella cenere guardata per la raunanza de' figliuoli d'Israele, per farne l'acqua di purificazione; quell'è un sacrificio per lo peccato. ");
INSERT INTO ita1885_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","E lavisi colui che avrà raccolta la cenere della giovenca i vestimenti, e sia immondo infino alla sera. E sia questo uno statuto perpetuo a' figliuoli d'Israele, e al forestiere che dimorerà fra loro. ");
INSERT INTO ita1885_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Chi avrà tocco il corpo morto di qualunque persona, sia immondo per sette giorni. ");
INSERT INTO ita1885_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Purifichisi al terzo giorno con quell'acqua, e al settimo giorno sarà netto; ma s'egli non sarà purificato al terzo giorno, nè anche sarà netto al settimo. ");
INSERT INTO ita1885_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Chiunque avrà tocco il corpo morto d'una persona che sia morta, e non si sarà purificato; egli ha contaminato il Tabernacolo del Signore; perciò sia quella persona ricisa d'Israele; conciossiachè l'acqua di purificazione non sia stata sparsa sopra lui, egli sarà immondo; la sua immondizia rimarrà da indi innanzi in lui. ");
INSERT INTO ita1885_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Questa è la legge, quando un uomo sarà morto in un padiglione: chiunque entrerà nel padiglione, o vi sarà dentro, sia immondo per sette giorni. ");
INSERT INTO ita1885_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Parimente sia immondo ogni vasello aperto, sopra il quale non vi sarà coperchio ben commesso. ");
INSERT INTO ita1885_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","E chiunque per li campi avrà tocco alcuno ucciso con la spada, o un uomo morto da sè, o alcun osso d'uomo, o alcuna sepoltura, sia immondo per sette giorni. ");
INSERT INTO ita1885_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","E per l'immondo prendasi della cenere del fuoco di quel sacrificio per lo peccato, e mettavisi su dell'acqua viva in un vaso. ");
INSERT INTO ita1885_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Poi pigli un uomo che sia netto, dell'isopo, e intingalo in quell'acqua, e spruzzine quel padiglione, e tutti que' vaselli, e tutte le persone che vi saranno dentro; spruzzine parimente colui che avrà tocco l'osso, o l'uomo ucciso, o l'uomo morto da sè, o la sepoltura. ");
INSERT INTO ita1885_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Quell'uomo netto adunque spruzzi l'immondo, al terzo e al settimo giorno; e, avendolo purificato al settimo giorno, lavi colui i suoi vestimenti, e sè stesso, con acqua; e sarà netto la sera. ");
INSERT INTO ita1885_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Ma, se alcuno, essendo immondo, non si purifica, sia quella persona ricisa di mezzo la raunanza; conciossiachè abbia contaminato il Santuario del Signore; l'acqua di purificazione non è stata sparsa sopra lui; egli è immondo. ");
INSERT INTO ita1885_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","E questo sia loro uno statuto perpetuo; e colui che avrà spruzzata l'acqua di purificazione lavisi i vestimenti; e chi avrà toccata l'acqua di purificazione sia immondo infino alla sera. ");
INSERT INTO ita1885_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Sia ancora immondo tutto quello che l'immondo avrà tocco; e la persona che avrà tocco lui sia immonda infino alla sera. ");
INSERT INTO ita1885_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","ORA, essendo tutta la raunanza dei figliuoli d'Israele giunta al deserto di Sin, nel primo mese, il popolo si fermò in Cades; e quivi morì, e fu seppellita Maria. ");
INSERT INTO ita1885_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Ora, non v'era acqua per la raunanza; laonde si adunarono contro a Mosè e contro ad Aaronne. ");
INSERT INTO ita1885_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","E il popolo contese con Mosè e disse: Ah! fossimo pur morti, quando morirono i nostri fratelli davanti al Signore! ");
INSERT INTO ita1885_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","E perchè avete voi menata la raunanza del Signore in questo deserto, acciocchè noi e il nostro bestiame vi muoiamo? ");
INSERT INTO ita1885_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","E perchè ci avete tratti fuor di Egitto, per menarci in questo cattivo luogo, che non è luogo di sementa, nè di fichi, nè di vigne, nè di melagrane, e non vi è pure acqua da bere? ");
INSERT INTO ita1885_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Allora Mosè ed Aaronne se ne vennero d'appresso alla raunanza, all'entrata del Tabernacolo della convenenza, e si gittarono in terra sopra le lor facce; e la gloria del Signore apparve loro. ");
INSERT INTO ita1885_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","E il Signore parlò a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Piglia la verga; e tu ed Aaronne, tuo fratello, adunate la raunanza, e parlate a quel sasso, in presenza loro; ed esso darà la sua acqua, e tu farai loro uscir dell'acqua del sasso, e darai da bere alla raunanza e al lor bestiame. ");
INSERT INTO ita1885_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Mosè adunque prese la verga d'innanzi al Signore, come egli gli avea comandato. ");
INSERT INTO ita1885_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","E Mosè ed Aaronne adunarono la raunanza davanti a quel sasso, e dissero loro: Ascoltate ora, o ribelli; vi faremo noi uscir dell'acqua di questo sasso? ");
INSERT INTO ita1885_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","E Mosè, alzata la mano, percosse il sasso con la sua verga due volte, e ne uscì molt'acqua; e la raunanza e il suo bestiame ne bevve. ");
INSERT INTO ita1885_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Poi il Signore disse a Mosè e ad Aaronne: Perciocchè voi non mi avete creduto, per santificarmi in presenza dei figliuoli d'Israele; perciò voi non introdurrete questa raunanza nel paese che io ho lor donato. ");
INSERT INTO ita1885_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Quest'è l'acqua della contesa, della quale i figliuoli d'Israele contesero col Signore; ed egli fu santificato fra loro. ");
INSERT INTO ita1885_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","POI Mosè mandò di Cades ambasciadori al re di Edom, a dirgli: Così dice Israele, tuo fratello: Tu sai tutti i travagli che ci sono avvenuti. ");
INSERT INTO ita1885_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Come i nostri padri scesero in Egitto, e come noi siamo dimorati in Egitto lungo tempo, e come gli Egizj hanno trattato male noi e i nostri padri. ");
INSERT INTO ita1885_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Onde avendo noi gridato al Signore, egli ha uditi i nostri gridi, e ha mandato l'Angelo, e ci ha tratti fuor del paese di Egitto. Or eccoci in Cades, città che è allo stremo de' tuoi confini. ");
INSERT INTO ita1885_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Deh! lascia che passiamo per lo tuo paese; noi non passeremo per campi, nè per vigne, e non berremo alcun'acqua di pozzo; cammineremo per la strada reale, e non ci rivolgeremo nè a destra nè a sinistra, finchè abbiamo passati i tuoi confini. ");
INSERT INTO ita1885_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Ma l'Idumeo mandò loro a dire: Non passate per lo mio paese, ch'io non esca incontro a voi a mano armata. ");
INSERT INTO ita1885_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","E i figliuoli d'Israele gli risposero: Noi cammineremo per la strada pubblica; e, se noi e il nostro bestiame beviamo della tua acqua, noi te ne pagheremo il prezzo; sol una cosa ti chieggiamo, che possiamo passare col nostro seguito. ");
INSERT INTO ita1885_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Ma egli disse: Voi non passerete. E l'Idumeo uscì incontro a loro, con molta gente, e con potente mano. ");
INSERT INTO ita1885_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","L'Idumeo adunque ricusò di dare a Israele il passo per li suoi confini; laonde Israele si rivolse dal suo paese. ");
INSERT INTO ita1885_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","E TUTTA la raunanza de' figliuoli d'Israele, partitasi di Cades, pervenne al monte di Hor. ");
INSERT INTO ita1885_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","E il Signore parlò a Mosè e ad Aaronne, al monte di Hor, presso a' confini del paese di Edom, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Aaronne sarà raccolto a' suoi popoli; perciocchè egli non entrerà nel paese che io ho donato a' figliuoli d'Israele; conciossiachè voi siate stati ribelli al mio comandamento all'acqua della contesa. ");
INSERT INTO ita1885_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Prendi Aaronne ed Eleazaro suo figliuolo; e falli salire in sul monte di Hor. ");
INSERT INTO ita1885_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","E spoglia Aaronne dei suoi vestimenti, e vestine Eleazaro, suo figliuolo; ed Aaronne sarà quivi raccolto, e morrà. ");
INSERT INTO ita1885_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","E Mosè fece come il Signore gli avea comandato; ed essi salirono in sul monte di Hor, alla vista di tutta la raunanza. ");
INSERT INTO ita1885_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","E Mosè spogliò Aaronne dei suoi vestimenti, e li fece vestire a Eleazaro, figliuolo di esso; ed Aaronne morì quivi in su la sommità del monte. Poi Mosè ed Eleazaro scesero giù dal monte. ");
INSERT INTO ita1885_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","E avendo tutta la raunanza veduto che Aaronne era trapassato, tutte le famiglie d'Israele lo piansero per trenta giorni. ");
INSERT INTO ita1885_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","OR avendo il Cananeo, re di Arad, che abitava verso il Mezzodì, inteso che Israele se ne veniva per lo cammino delle spie, combattè contro a Israele, e ne menò alcuni prigioni. ");
INSERT INTO ita1885_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Allora Israele votò un voto al Signore, e disse: Se pur tu mi dài questo popolo nelle mani, io distruggerò le lor città nella maniera dell'interdetto. ");
INSERT INTO ita1885_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","E il Signore esaudì la voce d'Israele, e gli diede nelle mani que' Cananei; ed egli distrusse loro, e le lor città, nella maniera dell'interdetto; perciò pose nome a quel luogo Horma. ");
INSERT INTO ita1885_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Poi gl'Israeliti si partirono dal monte di Hor, traendo verso il mar rosso, per circuire il paese di Edom; e l'animo venne meno al popolo per lo cammino. ");
INSERT INTO ita1885_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","E il popolo parlò contro a Dio, e contro a Mosè, dicendo: Perchè ci avete voi tratti fuor di Egitto, acciocchè muoiamo in questo deserto? conciossiachè non vi sia nè pane alcuno, nè acqua; e l'anima nostra è tutta svogliata di questo pane tanto leggiero. ");
INSERT INTO ita1885_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Allora il Signore mandò contro al popolo de' serpenti ardenti, i quali mordevano il popolo; onde molta gente d'Israele morì. ");
INSERT INTO ita1885_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","E il popolo venne a Mosè, e disse: Noi abbiamo peccato; conciossiachè abbiamo parlato contro al Signore, e contro a te; prega il Signore che rimova d'addosso a noi i serpenti. E Mosè pregò per lo popolo. ");
INSERT INTO ita1885_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","E il Signore disse a Mosè: Fatti un serpente ardente, e mettilo sopra un'antenna; e avverrà che chiunque sarà morso, riguardando quello, scamperà. ");
INSERT INTO ita1885_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","E Mosè fece un serpente di rame, e lo mise sopra una antenna; e avveniva che, se un serpente avea morso alcuno, ed egli riguardava al serpente di rame, egli scampava. ");
INSERT INTO ita1885_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","POI i figliuoli d'Israele si mossero, e si accamparono in Obot. ");
INSERT INTO ita1885_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","E, partitisi di Obot, si accamparono a' Poggi di Abarim, nel deserto ch'è dirimpetto al paese di Moab, dal sol levante. ");
INSERT INTO ita1885_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Poi si mossero di là, e si accamparono nella valle di Zered. ");
INSERT INTO ita1885_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Poi si partirono di là, e si accamparono lungo il fiume di Arnon, che è nel deserto; il quale si sporge innanzi dai confini degli Amorrei; perciocchè Arnon è il confine di Moab, fra Moab e gli Amorrei. ");
INSERT INTO ita1885_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","(Perciò è detto nel Libro delle battaglie del Signore, Vaheb in Suf, e i fiumi di Arnon, ");
INSERT INTO ita1885_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","e il letto del fiume, che si volge là dove siede Ar, e tocca i confini di Moab.) ");
INSERT INTO ita1885_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","E di là giunsero in Beer (Quest'è il pozzo del quale il Signore disse a Mosè: Aduna il popolo, e io darò loro dell'acqua. ");
INSERT INTO ita1885_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Allora Israele cantò questo cantico: Sali, o pozzo; cantategli: ");
INSERT INTO ita1885_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Pozzo, che i principali hanno cavato; Che i nobili d'infra il popolo hanno tagliato nel sasso, Col Legislatore, avendo in mano i lor bastoni.) Poi, dal deserto giunsero in Mattana. ");
INSERT INTO ita1885_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","E da Mattana in Nahaliel, e da Nahaliel in Bamot. ");
INSERT INTO ita1885_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","E da Bamot nella valle che è nel territorio di Moab, in capo di Pisga, e riguarda verso il deserto. ");
INSERT INTO ita1885_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Allora Israele mandò ambasciadori a Sihon, re degli Amorrei, a dirgli: ");
INSERT INTO ita1885_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Lascia ch'io passi per lo tuo paese; noi non ci rivolgeremo nè in campi, nè in vigne, e non berremo alcun'acqua di pozzo; noi cammineremo per la strada reale, finchè siamo passati i tuoi confini. ");
INSERT INTO ita1885_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Ma Sihon non concedette a Israele di passar per li suoi confini; anzi adunò tutta la sua gente, e uscì fuori incontro a Israle, nel deserto; e venne in Iaas, e combattè con Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","E Israele lo sconfisse, e lo mise a fil di spada, e conquistò il suo paese, ch'era da Arnon fino a Iabboc, fino al paese de' figliuoli di Ammon; perciocchè la frontiera de' figliuoli di Ammon era forte. ");
INSERT INTO ita1885_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","E Israele prese tutte le città ch'erano in quel paese, e abitò in tutte le città degli Amorrei, cioè in Hesbon, e in tutte le terre del suo territorio. ");
INSERT INTO ita1885_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Perciocchè Hesbon era la città di Sihon, re degli Amorrei, il quale era stato il primo che avea guerreggiato contro al re di Moab, e gli avea tolto tutto il suo paese, fino all'Arnon. ");
INSERT INTO ita1885_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Perciò dicono i poeti: Venite in Hesbon; Sia riedificata e ristorata la città di Sihon. ");
INSERT INTO ita1885_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Perciocchè un fuoco uscì già di Hesbon, E una fiamma della città di Sihon, E consumò Ar di Moab, Gli abitanti di Bamot-Arnon. ");
INSERT INTO ita1885_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Guai a te, Moab! O popolo di Chemos, tu sei perito; Esso ha dati i suoi figliuoli ch'erano scampati, E le sue figliuole, in cattività A Sihon, re degli Amorrei. ");
INSERT INTO ita1885_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Ma noi li abbiamo sconfitti. Hesbon è perito fino a Dibon; E noi li abbiamo distrutti fino a Nofa, Che arriva fino a Medeba. ");
INSERT INTO ita1885_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","E Israele abitò nel paese degli Amorrei. ");
INSERT INTO ita1885_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Poi Mosè mandò a spiare Iazer: e gli Israeliti presero le terre del suo territorio; e ne cacciarono gli Amorrei che vi erano. ");
INSERT INTO ita1885_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Poi, voltatisi, salirono per lo cammino di Basan; e Og, re di Basan, uscì incontro a loro, con tutta la sua gente, in battaglia, in Edrei. ");
INSERT INTO ita1885_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","E il Signore disse a Mosè: Non temerlo; perciocchè io ti ho dato nelle mani lui, e tutta la sua gente, e il suo paese; e fagli come tu hai fatto a Sihon, re degli Amorrei, che abitava in Hesbon. ");
INSERT INTO ita1885_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Gl'Israeliti adunque percossero lui, e i suoi figliuoli, e tutto il suo popolo; talchè non ne lasciarono alcuno in vita; e conquistarono il suo paese. ");
INSERT INTO ita1885_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","POI i figliuoli d'Israele si mossero, e si accamparono nelle campagne di Moab, di là dal Giordano di Gerico. ");
INSERT INTO ita1885_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Or avendo Balac, figliuolo di Sippor, veduto tutto ciò che Israele avea fatto agli Amorrei; ");
INSERT INTO ita1885_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","i Moabiti ebbero grande spavento del popolo; perciocchè era in gran numero; talchè i Moabiti erano in angoscia per tema dei figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Perciò i Moabiti dissero agli Anziani di Madian: Questa gente roderà ora tutto ciò ch'è d'intorno a noi, come il bue rode l'erba verde della campagna. Or Balac, figliuolo di Sippor, era re di Moab, in quel tempo. ");
INSERT INTO ita1885_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Ed egli mandò ambasciadori a Balaam, figliuolo di Beor, in Petor, città posta in sul Fiume, ch'era la patria d'esso, per chiamarlo, dicendo: Ecco, un popolo è uscito di Egitto; ecco, egli copre la faccia della terra, ed è stanziato dirimpetto a me; ");
INSERT INTO ita1885_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","ora dunque vieni, ti prego, e maledicimi questo popolo; perciocchè egli è troppo potente per me; forse potrò fare in maniera che noi lo sconfiggeremo, e che io lo scaccerò dal paese; perciocchè io so che chi tu benedici è benedetto, e maledetto chi tu maledici. ");
INSERT INTO ita1885_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","E gli Anziani di Moab, e gli Anziani di Madian, andarono, avendo in mano gl'indovinamenti. E, giunti a Balaam, gli rapportarono le parole di Balac. ");
INSERT INTO ita1885_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Ed egli disse loro: State qui questa notte; e poi io vi renderò risposta, secondo che il Signore avrà parlato. E i principali di Moab dimorarono con Balaam. ");
INSERT INTO ita1885_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","E Iddio venne a Balaam, e gli disse: Chi son cotesti uomini che sono appresso di te? ");
INSERT INTO ita1885_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","E Balaam disse a Dio: Balac, figliuolo di Sippor, re di Moab, ha mandato a dirmi: ");
INSERT INTO ita1885_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Ecco un popolo, ch'è uscito di Egitto, e ha coperta la faccia della terra; or vieni, e maledicimelo; forse potrò combattere con lui, e lo scaccerò. ");
INSERT INTO ita1885_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","E Iddio disse a Balaam: Non andar con loro; non maledire quel popolo; conciossiachè egli sia benedetto. ");
INSERT INTO ita1885_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","E la mattina seguente, Balaam si levò, e disse a que' principi di Balac: Andatevene al vostro paese; perciocchè il Signore ha rifiutato di concedermi ch'io vada con voi. ");
INSERT INTO ita1885_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","E i principi di Moab si levarono, e vennero a Balac, e gli dissero: Balaam ha ricusato di venir con noi. ");
INSERT INTO ita1885_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","E Balac vi mandò di nuovo altri principi, in maggior numero, e più onorati che que' primi. ");
INSERT INTO ita1885_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Ed essi vennero a Balaam, e gli dissero: Così dice Balac, figliuolo di Sippor: Deh! non ritenerti di venire a me; ");
INSERT INTO ita1885_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","perciocchè io del tutto ti farò grande onore, e farò tutto quello che tu mi dirai; deh! vieni pure, e maledicimi questo popolo. ");
INSERT INTO ita1885_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","E Balaam rispose, e disse a' servitori di Balac: Avvegnachè Balac mi desse la sua casa piena d'argento e d'oro, io non potrei trapassare il comandamento del Signore Iddio mio, per far cosa alcuna piccola o grande. ");
INSERT INTO ita1885_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Tuttavia statevene, vi prego, qui ancora voi questa notte, e io saprò ciò che il Signore seguiterà a dirmi. ");
INSERT INTO ita1885_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","E Iddio venne di notte a Balaam, e gli disse: Cotesti uomini sono eglino venuti per chiamarti? levati, vai con loro; tuttavolta, fa' quello che io ti dirò. ");
INSERT INTO ita1885_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balaam adunque si levò la mattina, e sellò la sua asina, e andò co' principi di Moab. ");
INSERT INTO ita1885_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","E l'ira di Dio si accese, perciocchè egli andava; e l'Angelo del Signore si presentò in su la strada, per contrariarlo. Or egli cavalcava la sua asina, e avea seco due suoi fanti. ");
INSERT INTO ita1885_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","E l'asina vide l'Angelo del Signore che stava in su la strada, con la sua spada nuda in mano; e l'asina si rivolse dalla strada, e andava per li campi. E Balaam percosse l'asina, per farla ritornar nella strada. ");
INSERT INTO ita1885_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","E l'Angelo del Signore si fermò in un sentier di vigne, dove era una chiusura di muro secco di qua e di là. ");
INSERT INTO ita1885_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","E l'asina, vedendo l'Angelo del Signore, si strinse contro al muro, e stringeva il piè di Balaam al muro; laonde egli da capo la percosse. ");
INSERT INTO ita1885_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","E l'Angelo del Signore passò di nuovo oltre, e si fermò in un luogo stretto, ove non v'era spazio da volgersi nè a destra nè a sinistra. ");
INSERT INTO ita1885_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","E l'asina, avendo veduto l'Angelo del Signore, si coricò sotto Balaam; laonde l'ira di Balaam si accese, e percosse l'asina col bastone. ");
INSERT INTO ita1885_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Allora il Signore aperse la bocca all'asina; ed ella disse a Balaam: Che t'ho io fatto, che tu mi hai percossa già tre volte? ");
INSERT INTO ita1885_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","E Balaam disse all'asina: Io t'ho percossa, perchè tu m'hai beffato; avessi pure in mano una spada, che ora ti ucciderei. ");
INSERT INTO ita1885_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","E l'asina disse a Balaam: Non sono io la tua asina, che sempre hai cavalcata per addietro, fino a questo giorno? sono io mai stata usata di farti così? Ed egli disse: No. ");
INSERT INTO ita1885_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Allora il Signore aperse gli occhi a Balaam; ed egli vide l'Angelo del Signore, che stava in su la strada, avendo in mano la sua spada nuda. E Balaam si chinò, e si prostese in terra sopra la sua faccia. ");
INSERT INTO ita1885_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","E l'Angelo del Signore gli disse: Perchè hai percossa la tua asina già tre volte? Ecco, io sono uscito fuori per contrastarti; perciocchè questo viaggio non è dirittamente ordinato nel mio cospetto. ");
INSERT INTO ita1885_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Ma l'asina mi ha veduto; e, veggendomi, si è rivolta già tre volte; forse si è ella rivolta per tema di me; perciocchè già avrei ucciso te, e lei avrei lasciata vivere. ");
INSERT INTO ita1885_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","E Balaam disse all'Angelo del Signore: Io ho peccato; perciocchè io non sapeva che tu mi stessi contra in questo viaggio; ma ora, se esso ti dispiace, io me ne ritornerò. ");
INSERT INTO ita1885_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","E l'Angelo del Signore disse a Balaam: Va' pure con cotesti uomini; ma di' sol ciò ch'io ti dirò. E Balaam andò co' principi di Balac. ");
INSERT INTO ita1885_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","E Balac, udito che Balaam veniva, andò ad incontrarlo in una città di Moab, che è in sul confine di Arnon, il quale è all'estremità della frontiera del paese. ");
INSERT INTO ita1885_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","E Balac disse a Balaam: Non ti avea io mandato instantemente a chiamare? perchè non venivi tu a me? non potrei io pur farti onore? ");
INSERT INTO ita1885_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","E Balaam rispose a Balac: Ecco, io son venuto a te; ora potrei io in alcuna maniera dir cosa alcuna? Ciò che il Signore mi avrà messo in bocca, quello dirò. ");
INSERT INTO ita1885_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","E Balaam andò con Balac, e vennero in Chiriat-husot. ");
INSERT INTO ita1885_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","E Balac sacrificò buoi, e pecore, e ne mandò a Balaam, e a' principi ch'erano con lui. ");
INSERT INTO ita1885_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","E la mattina seguente, Balac prese Balaam, e lo menò sopra gli alti luoghi di Baal; e di là gli mostrò una estremità del popolo. ");
INSERT INTO ita1885_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","E Balaam disse a Balac: Edificami qui sette altari, e apparecchiami qui sette giovenchi, e sette montoni. ");
INSERT INTO ita1885_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","E Balac fece come Balaam avea detto; e Balac e Balaam offersero un giovenco e un montone, sopra ciascuno altare. ");
INSERT INTO ita1885_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","E Balaam disse a Balac: Fermati presso al tuo olocausto, e io andrò; forse mi si farà il Signore incontro, e ciò ch'egli mi avrà fatto vedere, io tel rapporterò. Ed egli se ne andò sopra un'alta cima di un monte. ");
INSERT INTO ita1885_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","E Iddio si fece incontro a Balaam; e Balaam gli disse: Io ho ordinati sette altari, e ho offerto un giovenco e un montone, sopra ciascuno altare. ");
INSERT INTO ita1885_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Allora il Signore mise la parola in bocca a Balaam, e gli disse: Ritorna a Balac, e parla così. ");
INSERT INTO ita1885_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Egli adunque ritornò a Balac; ed ecco, egli si stava presso al suo olocausto, insieme con tutti i principi di Moab. ");
INSERT INTO ita1885_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Allora egli prese a proferire la sua sentenza, e disse: Balac, re di Moab, mi ha fatto condurre di Siria, Dalle montagne d'Oriente, Dicendo: Vieni, maledicimi Giacobbe; Vieni pure, scongiura Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Come lo maledirò io? Iddio non l'ha maledetto; Come lo scongiurerò io? il Signore non l'ha scongiurato. ");
INSERT INTO ita1885_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Quando io lo riguardo dalla sommità delle rupi, E lo miro d'in su i colli, Ecco un popolo che abiterà da parte, E non si acconterà fra l'altre nazioni. ");
INSERT INTO ita1885_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Chi annovererà Giacobbe, che è come la polvere? E chi farà il conto pur della quarta parte d'Israele? Muoia la mia persona della morte degli uomini diritti, E sia il mio fine simile al suo. ");
INSERT INTO ita1885_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Allora Balac disse a Balaam: Che mi hai tu fatto? io ti avea fatto venir per maledire i miei nemici; ed ecco, tu li hai pur benedetti. ");
INSERT INTO ita1885_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Ed egli rispose, e disse: Non prenderei io guardia di dir ciò che il Signore mi ha messo in bocca? ");
INSERT INTO ita1885_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","E Balac gli disse: Deh! vieni meco in un altro luogo, onde tu lo vedrai; tu ne puoi di qui veder solamente una estremità, tu non lo puoi veder tutto; e maledicimelo di là. ");
INSERT INTO ita1885_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","E lo condusse al campo di Sofim, nella cima di Pisga; ed edificò sette altari, e offerse un giovenco e un montone, sopra ciascuno altare. ");
INSERT INTO ita1885_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","E Balaam disse a Balac: Fermati qui presso al tuo olocausto, e io me ne andrò colà allo scontro. ");
INSERT INTO ita1885_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","E il Signore si fece incontro a Balaam, e gli mise la parola in bocca; e gli disse: Ritorna a Balac, e parla così. ");
INSERT INTO ita1885_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Ed egli se ne venne a Balac; ed egli se ne stava presso al suo olocausto, e con lui erano i principi di Moab. E Balac gli disse: Che ha detto il Signore? ");
INSERT INTO ita1885_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Ed egli prese a proferir la sua sentenza, e disse: Levati, Balac, e ascolta! Porgimi gli orecchi, figliuolo di Sippor. ");
INSERT INTO ita1885_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Iddio non è un uomo, ch'egli menta; Nè un figliuol d'uomo, ch'egli si penta. Avrà egli detta una cosa, e non la farà? Avrà egli parlato, e non atterrà la sua parola? ");
INSERT INTO ita1885_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Ecco, io ho ricevuta commissione di benedire; E poi ch'egli ha benedetto, io non posso impedir la sua benedizione. ");
INSERT INTO ita1885_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Egli non iscorge iniquità in Giacobbe, E non vede perversità in Israele. Il Signore Iddio suo è con lui, E fra esso v'è un grido di trionfo reale. ");
INSERT INTO ita1885_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Iddio, che li ha tratti fuori di Egitto, È loro a guisa di forze di liocorno. ");
INSERT INTO ita1885_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Perciocchè non v'è incantamento in Giacobbe, Nè indovinamento in Israele; Infra un anno, intorno a questo tempo, e' si dirà di Giacobbe e d'Israele: Quali cose ha fatte Iddio! ");
INSERT INTO ita1885_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Ecco un popolo che si leverà come un gran leone, E si ergerà come un leone; Egli non si coricherà, finchè non abbia divorata la preda, E bevuto il sangue degli uccisi. ");
INSERT INTO ita1885_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Allora Balac disse a Balaam: Non maledirlo, ma pure anche non benedirlo. ");
INSERT INTO ita1885_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","E Balaam rispose, e disse a Balac: Non ti diss'io, ch'io farei tutto ciò che il Signore direbbe? ");
INSERT INTO ita1885_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","E Balac disse a Balaam: Deh! vieni, io ti menerò in un altro luogo; forse piacerà a Dio che di là tu mel maledica. ");
INSERT INTO ita1885_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balac adunque menò Balaam in cima di Peor, che riguarda verso il deserto. ");
INSERT INTO ita1885_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","E Balaam disse a Balac: Edificami qui sette altari, e apparecchiami qui sette giovenchi, e sette montoni. ");
INSERT INTO ita1885_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","E Balac fece come Balaam avea detto; e offerse un giovenco e un montone, sopra ciascuno altare. ");
INSERT INTO ita1885_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Or Balaam, veggendo che piaceva al Signore di benedire Israele, non andò più, come l'altre volte, a incontrare augurii; e dirizzò la faccia verso il deserto. ");
INSERT INTO ita1885_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","E, alzati gli occhi, vide Israele, stanziato a tribù a tribù. Allora lo Spirito di Dio fu sopra lui. ");
INSERT INTO ita1885_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Ed egli prese a proferir la sua sentenza, e disse: Così dice Balaam, figliuolo di Beor, Così dice l'uomo che ha l'occhio aperto: ");
INSERT INTO ita1885_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Così dice colui che ode le parole di Dio, Che vede la visione dell'Onnipotente, che cade a terra, E a cui gli occhi sono aperti. ");
INSERT INTO ita1885_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Quanto son belli i tuoi padiglioni, o Giacobbe! E i tuoi tabernacoli, o Israele! ");
INSERT INTO ita1885_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Essi son distesi a guisa di valli; Sono come orti presso a un fiume, Come santali che il Signore ha piantati, Come cedri presso all'acque. ");
INSERT INTO ita1885_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Egli verserà dell'acqua delle sue secchie, E il suo seme sarà fra acque copiose, E il suo re sarà innalzato sopra Agag, E il suo regno sarà esaltato. ");
INSERT INTO ita1885_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Iddio, che l'ha tratto fuor di Egitto, Gli sarà a guisa di forze di liocorno; Egli consumerà le genti che gli saranno nemiche, E triterà loro le ossa, e le trafiggerà con le sue saette. ");
INSERT INTO ita1885_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Quando egli si sarà chinato, e si sarà posto a giacere come un leone, E come un gran leone, chi lo desterà? Coloro che ti benedicono saranno benedetti, E coloro che ti maledicono saranno maledetti. ");
INSERT INTO ita1885_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Allora l'ira di Balac si accese contro a Balaam; e, battendosi a palme, gli disse: Io t'ho chiamato per maledire i miei nemici; ed ecco, tu li hai pur benedetti già tre volte. ");
INSERT INTO ita1885_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Ora dunque, fuggitene al tuo luogo; io avea detto che ti farei grande onore; ma ecco, il Signore ti ha divietato d'essere onorato. ");
INSERT INTO ita1885_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","E Balaam rispose a Balac: E io non aveva io detto a' tuoi ambasciadori che tu mi mandasti: ");
INSERT INTO ita1885_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Avvegnachè Balac mi desse piena la sua casa d'argento, e d'oro, io non potrei trapassare il comandamento del Signore, per far cosa alcuna, buona o malvagia, di mio senno; ciò che il Signore mi avrà detto, quello dirò? ");
INSERT INTO ita1885_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Ora dunque, io me ne vo al mio popolo; vieni, io ti consiglierò; e ti dirò ciò che questo popolo farà al tuo popolo negli ultimi tempi. ");
INSERT INTO ita1885_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Allora egli prese a proferir la sua sentenza, e disse: Così dice Balaam, figliuolo di Beor; Così dice l'uomo che ha l'occhio aperto: ");
INSERT INTO ita1885_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Così dice colui che ode le parole di Dio; E che intende la scienza dell'Altissimo; Che vede la visione dell'Onnipotente, Che cade a terra, e a cui gli occhi sono aperti: ");
INSERT INTO ita1885_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Io lo veggo, ma non al presente; Io lo scorgo, ma non di presso. Una stella procederà da Giacobbe, E uno scettro surgerà d'Israele, Il quale trafiggerà i principi di Moab, E distruggerà tutti i figliuoli del fondamento. ");
INSERT INTO ita1885_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Ed Edom sarà il conquisto, Seir sarà il conquisto de' suoi nemici; E Israele farà prodezze. ");
INSERT INTO ita1885_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","E uno disceso di Giacobbe, signoreggerà E distruggerà chi sarà scampato della città. ");
INSERT INTO ita1885_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Poi Balaam riguardò Amalec, e prese a proferir la sua sentenza, e disse: Amalec è una primizia di Gentili, E il suo rimanente sarà ridotto a perdizione. ");
INSERT INTO ita1885_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Poi riguardò il Cheneo, e prese a proferir la sua sentenza, e disse: La tua stanza è forte, E tu hai posto il tuo nido nella rupe. ");
INSERT INTO ita1885_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Ma pur Cain sarà disertato, Infino a tanto che Assur ti meni in cattività. ");
INSERT INTO ita1885_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Poi prese di nuovo a proferir la sua sentenza, e disse: Guai a chi viverà dopo che Iddio avrà innalzato colui! ");
INSERT INTO ita1885_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Poi appresso verranno navi dalla costa di Chittim, E affliggeranno Assur, e oppresseranno Eber; Ed essi ancora saranno ridotti a perdizione. ");
INSERT INTO ita1885_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Poi Balaam si levò, e se ne andò, e ritornò al suo luogo; e Balac altresì andò a suo cammino. ");
INSERT INTO ita1885_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","OR Israele, stanziato in Sittim, cominciò a fornicar con le figliuole di Moab. ");
INSERT INTO ita1885_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Ed esse invitarono il popolo a' sacrificii de' loro iddii, e il popolo ne mangiò, e adorò gl'iddii d'esse. ");
INSERT INTO ita1885_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","E Israele si congiunse con Baal-peor; laonde l'ira del Signore si accese contro a Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","E il Signore disse a Mosè: Prendi tutti i Capi del popolo, e appiccali al Signore, davanti al sole; e l'ira accesa del Signore si rivolgerà d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Mosè disse ancora a' Giudici d'Israele: Uccida ciascun di voi quelli de' suoi, che si son congiunti con Baal-peor. ");
INSERT INTO ita1885_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Or in quel mezzo tempo un uomo d'Israele venne, e menò a' suoi fratelli una donna Madianita, davanti agli occhi di Mosè, e davanti agli occhi di tutta la raunanza de' figliuoli d'Israele, i quali piangevano all'entrata del Tabernacolo della convenenza. ");
INSERT INTO ita1885_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","E Finees, figliuolo d'Eleazaro, figliuolo del Sacerdote Aaronne, avendo ciò veduto, si levò d'infra la raunanza, e prese in mano una lancia. ");
INSERT INTO ita1885_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Ed entrò dietro a quell'uomo Israelita, dentro al lupanare, e li trafisse amendue, l'uomo Israelita, e la donna, per lo ventre d'essa. E la piaga fu arrestata d'in su i figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","E i morti di quella piaga furono ventiquattromila. ");
INSERT INTO ita1885_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","E il Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Finees, figliuolo d'Eleazaro, figliuolo del Sacerdote Aaronne, ha acquetata l'ira mia d'in su i figliuoli d'Israele; perchè è stato mosso del mio zelo nel mezzo di loro; laonde io non ho consumati i figliuoli d'Israele nella mia gelosia. ");
INSERT INTO ita1885_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Perciò digli ch'io gli do il mio patto di pace. ");
INSERT INTO ita1885_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","E il patto del Sacerdozio perpetuo sarà suo, e della sua progenie dopo lui; perciocchè egli è stato mosso di zelo per l'Iddio suo, e ha fatto purgamento per li figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Or il nome dell'uomo Israelita ucciso, il quale era stato ucciso con la donna Madianita, era Zimri, figliuolo di Salu, Capo d'una famiglia paterna de' Simeoniti. ");
INSERT INTO ita1885_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","E il nome della donna Madianita uccisa era Cozbi, figliuola di Sur, Capo di nazioni, e di famiglia paterna in Madian. ");
INSERT INTO ita1885_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Poi il Signore parlò a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Fate guerra a' Madianiti, e percoteteli; ");
INSERT INTO ita1885_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","conciossiachè essi abbiano fatta guerra a voi, co' loro inganni, che v'hanno fatti nel fatto di Peor, e nel fatto di Cozbi, figliuola d'un de' Capi di Madian, lor sorella, ch'è stata uccisa al giorno della piaga avvenuta per cagione di Peor. ");
INSERT INTO ita1885_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","ORA, dopo quella piaga, il Signore disse a Mosè e ad Eleazaro, figliuolo d'Aaronne, Sacerdote: ");
INSERT INTO ita1885_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Levate la somma di tutta la raunanza de' figliuoli d'Israele, annoverando dall'età di vent'anni in su, per le nazioni loro paterne, tutti quelli che possono andare alla guerra in Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Mosè adunque, e il Sacerdote Eleazaro, parlarono loro nelle campagne di Moab, presso al Giordano di Gerico, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Annoverate il popolo, dall'età di vent'anni in su; come il Signore avea comandato a Mosè, e ai figliuoli d'Israele, ch'erano usciti del paese di Egitto. ");
INSERT INTO ita1885_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Il primogenito d'Israele fu Ruben. I figliuoli di Ruben furono, di Hanoc, la nazione degli Hanochiti; di Pallu, la nazione de' Palluiti; ");
INSERT INTO ita1885_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","di Hesron, la nazione degli Hesroniti; di Carmi, la nazione dei Carmiti. ");
INSERT INTO ita1885_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Queste sono le nazioni de' Rubeniti, e gli annoverati fra loro furono quarantatremila settecentrenta. ");
INSERT INTO ita1885_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Di Pallu fu figliuolo Eliab. ");
INSERT INTO ita1885_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","E i figliuoli di Eliab furono Nemuel, Datan e Abiram. Questo è quel Datan e quell'Abiram, d'infra quelli che si chiamavano alla raunata del popolo, i quali si sollevarono contro a Mosè e contro ad Aaronne, quando Core fece la sua massa, ed essi si sollevarono contro al Signore. ");
INSERT INTO ita1885_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","E la terra aperse la sua bocca, e li tranghiottì; insieme con Core, che morì quando morì quella raunata, quando il fuoco consumò i dugencinquant'uomini, i quali furono per segno. ");
INSERT INTO ita1885_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Or i figliuoli di Core non morirono. ");
INSERT INTO ita1885_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","I figliuoli di Simeone, distinti per le lor nazioni, furono, di Nemuel, la nazione de' Nemueliti; di Giamin, la nazione de' Giaminiti; di Giachin, la nazione de' Giachiniti; ");
INSERT INTO ita1885_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","di Zera, la nazione de' Zeraiti; e di Saul, la nazione de' Sauliti. ");
INSERT INTO ita1885_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Queste sono le nazioni de' Simeoniti, de' quali gli annoverati furono ventiduemila dugento. ");
INSERT INTO ita1885_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","I figliuoli di Gad, distinti per le lor nazioni, furono, di Sefon, la nazione dei Sefoniti; d'Hagghi, la nazione degli Hagghiti; di Suni, la nazione de' Suniti; ");
INSERT INTO ita1885_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","d'Ozni, la nazione degli Ozniti; di Eri, la nazione degli Eriti; di Arod, la nazione degli Aroditi; ");
INSERT INTO ita1885_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","e di Areel, la nazione degli Areeliti. ");
INSERT INTO ita1885_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Queste sono le nazioni de' figliuoli di Gad, secondo i loro annoverati, che furono quarantamila cinquecento. ");
INSERT INTO ita1885_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","I figliuoli di Giuda furono Er e Onan. Ora Er e Onan morirono nel paese di Canaan. ");
INSERT INTO ita1885_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","E i figliuoli di Giuda, distinti per le lor nazioni, furono, di Sela, la nazione de' Selaniti; di Fares, la nazione de' Farsiti; di Zara, la nazione degli Zariti. ");
INSERT INTO ita1885_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","E i figliuoli di Fares furono, di Hesron, la nazione degli Hesroniti; e di Hamul, la nazione degli Hamuliti. ");
INSERT INTO ita1885_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Queste sono le nazioni di Giuda, secondo i loro annoverati, che furono settantaseimila cinquecento. ");
INSERT INTO ita1885_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","I figliuoli d'Issacar, distinti per le lor nazioni, furono, di Tola, la nazione dei Tolaiti; di Puva, la nazione de' Puviti; ");
INSERT INTO ita1885_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","di Giasub, la nazione de' Giasubiti; e di Simron, la nazione de' Simroniti. ");
INSERT INTO ita1885_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Queste sono le nazioni d'Issacar, sedondo i loro annoverati, che furono sessantaquattromila trecento. ");
INSERT INTO ita1885_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","I figliuoli di Zabulon, distinti per le lor nazioni, furono, di Sered, la nazione de' Sarditi; di Elon, la nazione degli Eloniti; e di Gialeel, la nazione de' Gialeeliti. ");
INSERT INTO ita1885_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Queste sono le nazioni degli Zabuloniti, secondo i loro annoverati, che furono sessantamila cinquecento. ");
INSERT INTO ita1885_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","I figliuoli di Giuseppe, distinti per le lor nazioni, furono Manasse ed Efraim. ");
INSERT INTO ita1885_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","I figliuoli di Manasse furono, di Machir, la nazione de' Machariti. E Machir generò Galaad, e di Galaad discese la nazione de' Galaaditi. ");
INSERT INTO ita1885_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Questi sono i figliuoli di Galaad: di Iezer, la nazione degl'Iezeriti; di Helec, la nazione degli Helchiti; ");
INSERT INTO ita1885_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","di Asriel, la nazione degli Asrieliti; di Sechem, la nazione de' Sechemiti; ");
INSERT INTO ita1885_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","di Semida, la nazione de' Semidaiti; e di Hefer, la nazione degli Heferiti. ");
INSERT INTO ita1885_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Or Selofad, figliuolo di Hefer, non ebbe figliuoli maschi, ma sol figliuole, i cui nomi erano Mala, Noa, Hogla, Milca, e Tirsa. ");
INSERT INTO ita1885_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Queste sono le nazioni di Manasse, delle quali gli annoverati furono cinquantaduemila settecento. ");
INSERT INTO ita1885_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Questi sono i figliuoli di Efraim, distinti per le lor nazioni: di Sutela, la nazione de' Sutelaiti; di Becher, la nazione de' Bacriti; di Tahan, la nazione de' Tahaniti. ");
INSERT INTO ita1885_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","E questi sono i figliuoli di Sutela: di Eran, la nazione degli Eraniti. ");
INSERT INTO ita1885_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Queste sono le nazioni de' figliuoli d'Efraim, secondo i loro annoverati, che furono trentaduemila cinquecento. Questi sono i figliuoli di Giuseppe, distinti per le lor nazioni. ");
INSERT INTO ita1885_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","I figliuoli di Beniamino, distinti per le lor nazioni, furono, di Bela, la nazione de' Belaiti; di Asbel, la nazione degli Asbeliti; di Ahiram, la nazione degli Ahiramiti; ");
INSERT INTO ita1885_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","di Sefusam, la nazione dei Sefusamiti; e di Huppam, la nazione degli Huppamiti. ");
INSERT INTO ita1885_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","E i figliuoli di Bela furono Ard e Naaman; di Ard discese la nazione degli Arditi; di Naaman, la nazione de' Naamiti. ");
INSERT INTO ita1885_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Questi sono i figliuoli di Beniamino, distinti per le lor nazioni, de' quali gli annoverati furono quarantacinquemila seicento. ");
INSERT INTO ita1885_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Questi sono i figliuoli di Dan, distinti per le lor famiglie: di Suham, discese la nazione de' Suhamiti. Questa è la nazione de' Daniti, distinta per le lor famiglie. ");
INSERT INTO ita1885_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Tutte le famiglie de' Suhamiti, secondo i loro annoverati, furono sessantaquattromila quattrocento. ");
INSERT INTO ita1885_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","I figliuoli di Aser, distinti per le lor nazioni, furono, d'Imna, la nazione degli Imnaiti; d'Isui, la nazione degl'Isuiti; e di Beria, la nazione de' Beriiti. ");
INSERT INTO ita1885_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","E de' figliuoli di Beria, di Heber, la nazione degli Hebriti; di Malchiel, la nazione de' Malchieliti. ");
INSERT INTO ita1885_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","E il nome della figliuola di Aser fu Sera. ");
INSERT INTO ita1885_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Queste sono le nazioni de' figliuoli di Aser, secondo i loro annoverati, che furono cinquantatremila quattrocento. ");
INSERT INTO ita1885_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","I figliuoli di Neftali, distinti per le lor nazioni, furono, di Giaseel, la nazione de' Giaseeliti; di Guni, la nazione de' Guniti; ");
INSERT INTO ita1885_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","di Geser, la nazione de' Geseriti; e di Sillem, la nazione de' Sillemiti. ");
INSERT INTO ita1885_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Queste sono le nazioni di Neftali, distinte per le lor famiglie; e gli annoverati d'infra loro furono quarantacinquemila quattrocento. ");
INSERT INTO ita1885_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Questi sono gli annoverati de' figliuoli d'Israele, in numero di seicentunmila settecentrenta. ");
INSERT INTO ita1885_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","E il Signore parlò a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Sia il paese spartito tra costoro per eredità, secondo il numero delle persone. ");
INSERT INTO ita1885_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Da' maggiore eredità a chi è in maggior numero, e minore a chi è in minor numero; diasi a ciascuno eredità a ragione de' suoi annoverati. ");
INSERT INTO ita1885_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Ma pure spartiscasi il paese a sorte; e abbiano eredità secondo i nomi delle loro tribù paterne. ");
INSERT INTO ita1885_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Spartiscasi l'eredità di ciascuna tribù, grande o piccola, a sorte. ");
INSERT INTO ita1885_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","E questi sono gli annoverati d'infra i Leviti, distinti per le lor nazioni: di Gherson discese la nazione de' Ghersoniti; di Chehat, la nazione de' Chehatiti; di Merari, la nazione de' Merariti. ");
INSERT INTO ita1885_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Queste sono le nazioni de' Leviti: la nazione de' Libniti, la nazione degli Hebroniti, la nazione de' Mahaliti, la nazione dei Musiti, e la nazione de' Coriti. Or Chehat generò Amram. ");
INSERT INTO ita1885_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","E il nome della moglie di Amram fu Iochebed, che fu figliuola di Levi, la qual gli nacque in Egitto; ed essa partorì ad Amram Aaronne, Mosè, e Maria, lor sorella. ");
INSERT INTO ita1885_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","E ad Aaronne nacquero Nadab, e Abihu, ed Eleazaro, e Itamar. ");
INSERT INTO ita1885_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Or Nadab e Abihu morirono quando presentarono fuoco strano davanti al Signore. ");
INSERT INTO ita1885_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","E gli annoverati d'infra i Leviti furono ventitremila, tutti maschi, dall'età d'un mese in su; conciossiachè non fossero annoverati fra' figliuoli d'Israele; perciocchè non era lor data eredità fra' figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Questi sono quelli che furono annoverati da Mosè, e dal Sacerdote Eleazaro, i quali annoverarono i figliuoli d'Israele nelle campagne di Moab, presso al Giordano di Gerico. ");
INSERT INTO ita1885_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","E fra costoro non vi fu alcuno di quelli ch'erano stati annoverati da Mosè, e dal Sacerdote Aaronne, i quali annoverarono i figliuoli d'Israele nel deserto di Sinai. ");
INSERT INTO ita1885_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Conciossiachè il Signore avesse detto di quelli: Del tutto morranno nel deserto. Onde non ne rimase alcuno, salvo Caleb, figliuolo di Gefunne; e Giosuè, figliuolo di Nun. ");
INSERT INTO ita1885_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","OR le figliuole di Selofad, figliuolo di Hefer, figliuolo di Galaad, figliuolo di Machir, figliuolo di Manasse, si accostarono alle nazioni di Manasse, figliuolo di Giuseppe; e i nomi loro erano Mala, Noa, Hogla, Milca, e Tirsa. ");
INSERT INTO ita1885_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","E si presentarono davanti a Mosè, e davanti al Sacerdote Eleazaro, e davanti a' Capi, e davanti a tutta la raunanza, all'entrata del Tabernacolo della convenenza, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Nostro padre è morto nel deserto; egli però non fu fra la raunata di coloro che s'adunarono contro al Signore alla raunata di Core; anzi è morto per suo peccato, e non ha lasciati figliuoli maschi. ");
INSERT INTO ita1885_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Perchè verrebbe meno il nome di nostro padre di mezzo della sua nazione, per non avere egli alcun figliuolo maschio? Dacci possessione tra i fratelli di nostro padre. ");
INSERT INTO ita1885_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","E Mosè rapportò la causa loro davanti al Signore. ");
INSERT INTO ita1885_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","E il Signore rispose a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Le figliuole di Selofad parlano dirittamente; del tutto da' loro possession d'eredità tra i fratelli del padre loro; e trasporta in loro la possessione del padre loro. ");
INSERT INTO ita1885_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","E parla a' figliuoli d'Israele, dicendo: Quando alcuno sarà morto senza figliuol maschio, trasportate l'eredità di esso nella sua figliuola. ");
INSERT INTO ita1885_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","E s'egli non ha figliuola, date la sua eredità a' suoi fratelli. ");
INSERT INTO ita1885_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","E se non ha fratelli, date la sua eredità a' fratelli di suo padre. ");
INSERT INTO ita1885_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","E se non vi sono fratelli di suo padre, date la sua eredità al suo prossimo carnal parente, che sia della sua famiglia; ed egli la possegga. E ciò sia uno statuto di ragione a' figliuoli d'Israele; come il Signore ha comandato a Mosè. ");
INSERT INTO ita1885_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","POI il Signore disse a Mosè: Sali in su questo monte di Abarim, e riguarda il paese ch'io ho donato a' figliuoli d'Israele. ");
INSERT INTO ita1885_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","E dopo che tu l'avrai veduto, anche tu sarai raccolto a' tuoi popoli, come è stato raccolto Aaronne, tuo fratello. ");
INSERT INTO ita1885_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Perciocchè voi contravveniste al comandamento ch'io vi diedi nel deserto di Sin, alla contesa della raunanza, che voi non mi santificaste in quell'acqua, nel cospetto del popolo. Quella è l'acqua della contesa di Cades, nel deserto di Sin. ");
INSERT INTO ita1885_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","E Mosè parlò al Signore, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Costituisca il Signore Iddio degli spiriti d'ogni carne, sopra questa raunanza, un uomo, ");
INSERT INTO ita1885_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","che vada e che venga davanti a loro, il quale li conduca e riconduca; acciocchè la raunanza del Signore non sia a guisa di pecore senza pastore. ");
INSERT INTO ita1885_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","E il Signore disse a Mosè: Prenditi Giosuè, figliuolo di Nun, che è uomo in cui è lo Spirito, e posa la tua mano sopra lui. ");
INSERT INTO ita1885_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","E fallo comparir davanti al Sacerdote Eleazaro, e davanti a tutta la raunanza; e dagli i tuoi ordini in presenza loro. ");
INSERT INTO ita1885_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","E metti della tua maestà sopra lui; acciocchè tutta la raunanza de' figliuoli d'Israele gli ubbidisca. ");
INSERT INTO ita1885_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","E presentisi egli davanti al Sacerdote Eleazaro, e l'addimandi per lo giudicio di Urim, nel cospetto del Signore; vadano e vengano, egli, e tutti i figliuoli d'Israele con lui, e tutta la raunanza, secondo ch'esso dirà. ");
INSERT INTO ita1885_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","E Mosè fece come il Signore gli avea comandato; e prese Giosuè, e lo fece comparir davanti al Sacerdote Eleazaro, e davanti a tutta la raunanza. ");
INSERT INTO ita1885_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","E posò le sue mani sopra lui, e gli diede i suoi ordini, come il Signore avea comandato per Mosè. ");
INSERT INTO ita1885_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","IL Signore parlò ancora a Mosè, dicendo: ");
INSERT INTO ita1885_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Comanda a' figliuoli d'Israele, e di' loro: Prendete guardia alle mie offerte, che son mio cibo; a' miei sacrificii da ardere, in odor soave a me, per offerirmeli a' lor tempi. ");
INSERT INTO ita1885_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","E di' loro: Quest'è il sacrificio da ardere, che voi avete a offerire al Signore per ciascun giorno, in olocausto continuo, cioè: due agnelli di un anno, senza difetto. ");
INSERT INTO ita1885_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Sacrifica l'uno di quegli agnelli la mattina, e l'altro fra' due vespri. ");
INSERT INTO ita1885_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","E la decima parte di un efa di fior di farina, stemperata con la quarta parte di un hin d'olio vergine, per offerta di panatica. ");
INSERT INTO ita1885_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Quest'è l'olocausto continuo, che è stato offerto nel monte di Sinai, in odor soave, per sacrificio da ardere al Signore. ");
INSERT INTO ita1885_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","E sia l'offerta da spandere d'esso, la quarta parte di un hin, per ciascun agnello; spandi al Signore l'offerta da spandere, d'ottimo vino, nel luogo santo. ");
INSERT INTO ita1885_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Poi fra' due vespri sacrifica l'altro agnello; fagli la medesima offerta di panatica, e da spandere, quale è quella della mattina; per sacrificio da ardere, d'odor soave al Signore. ");
INSERT INTO ita1885_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","E NEL giorno del Sabato offerite due agnelli di un anno, senza difetto; e due decimi di fior di farina, stemperata con olio, per offerta di panatica, insieme con le loro offerte da spandere. ");
INSERT INTO ita1885_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Quest'è l'olocausto del Sabato, per ciascun Sabato, oltre all'olocausto continuo, e la sua offerta da spandere. ");
INSERT INTO ita1885_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","E ne' principii de' vostri mesi, offerite per olocausto al Signore, due giovenchi, e un montone, e sette agnelli di un anno, senza difetto; ");
INSERT INTO ita1885_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","e tre decimi di fior di farina, stemperata con olio, per offerta di panatica, per ciascun giovenco; e due decimi di fior di farina, stemperata con olio, per offerta di panatica, per lo montone; ");
INSERT INTO ita1885_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","e un decimo di fior di farina stemperata con olio, per offerta di panatica, per ciascun agnello; per olocausto, in odor soave, per sacrificio da ardere al Signore. ");
INSERT INTO ita1885_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","E le loro offerte da spandere sieno la metà di un hin di vino, per ciascun giovenco; il terzo di un hin, per lo montone; e il quarto di un hin, per ciascun agnello. Quest'è l'olocausto delle calendi, per ogni mese dell'anno. ");
INSERT INTO ita1885_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Sacrifichisi ancora al Signore un becco, per sacrificio per lo peccato, oltre all'olocausto continuo, e la sua offerta da spandere. ");
INSERT INTO ita1885_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","OLTRE a ciò, nel primo mese, nel quartodecimo giorno del mese, è la Pasqua del Signore. ");
INSERT INTO ita1885_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","E nel quintodecimo giorno del medesimo mese, è festa solenne; manginsi pani azzimi per sette giorni. ");
INSERT INTO ita1885_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Nel primo giorno siavi santa raunanza; non fate in esso alcuna opera servile. ");
INSERT INTO ita1885_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","E offerite per sacrificio da ardere, in olocausto, al Signore, due giovenchi, e un montone, e sette agnelli di un anno, che sieno senza difetto; ");
INSERT INTO ita1885_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","insieme con la loro offerta di panatica di fior di farina, stemperata con olio; offeritene tre decimi per giovenco, e due decimi per lo montone. ");
INSERT INTO ita1885_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Offeriscine ancora un decimo per ciascun di que' sette agnelli. ");
INSERT INTO ita1885_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Offerite, oltre a ciò, un becco, per sacrificio per lo peccato, per far purgamento per voi. ");
INSERT INTO ita1885_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Offerite queste cose, oltre all'olocausto della mattina, che è per olocausto continuo. ");
INSERT INTO ita1885_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Offerite cotali cose ciascun di que' sette giorni, per cibo, per sacrificio da ardere, di soave odore al Signore; offeriscasi quello, oltre all'olocausto continuo, e la sua offerta da spandere. ");
INSERT INTO ita1885_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","E al settimo giorno siavi santa raunanza; non fate in esso alcuna opera servile. ");
INSERT INTO ita1885_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Oltre a ciò, al giorno de' primi frutti, quando voi offerirete nuova offerta di panatica al Signore, al termine delle vostre settimane, siavi santa raunanza; e non fate in quel giorno alcuna opera servile. ");
INSERT INTO ita1885_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","E offerite per olocausto, in soave odore al Signore, due giovenchi, un montone, e sette agnelli di un anno; ");
INSERT INTO ita1885_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","insieme con la loro offerta di panatica di fior di farina, stemperata con olio, di tre decimi per giovenco, e di due decimi per lo montone, ");
INSERT INTO ita1885_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","e di un decimo per ciascuno di que' sette agnelli. ");
INSERT INTO ita1885_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Offerite eziandio un becco, per far purgamento per voi. ");
INSERT INTO ita1885_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Offerite, oltre all'olocausto continuo, e la sua offerta di panatica, quegli animali, con le loro offerte da spandere; e sieno quelli senza difetto. ");
INSERT INTO ita1885_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","E nel settimo mese, alle calendi, siavi santa raunanza; non fate in quel giorno opera alcuna servile; siavi giorno di suon di tromba. ");
INSERT INTO ita1885_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","E offerite in esso per olocausto, in soave odore al Signore, un giovenco, un montone, e sette agnelli di un anno, senza difetto; ");
INSERT INTO ita1885_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","insieme con la loro offerta di panatica, di fior di farina, stemperata con olio, di tre decimi per lo giovenco, e di due decimi per lo montone, ");
INSERT INTO ita1885_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","e di un decimo per ciascuno di que' sette agnelli; ");
INSERT INTO ita1885_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","e un becco, per sacrificio per lo peccato, per far purgamento per voi; ");
INSERT INTO ita1885_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","oltre all'olocausto delle calendi, e la sua offerta di panatica; e oltre all'olocausto continuo, e la sua offerta di panatica, e le loro offerte da spandere, secondo i loro ordini, in soave odore, in sacrificio da ardere al Signore. ");
INSERT INTO ita1885_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Parimente, al decimo giorno di questo settimo mese, siavi santa raunanza; e affliggete l'anime vostre, e non fate alcun lavoro. ");
INSERT INTO ita1885_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","E offerite al Signore per olocausto, in soave odore, un giovenco, un montone, e sette agnelli di un anno, che sieno senza difetto; ");
INSERT INTO ita1885_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","insieme con la loro offerta di panatica, di fior di farina, stemperata con olio, di tre decimi per lo giovenco, di due decimi per lo montone, ");
INSERT INTO ita1885_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","e di un decimo per ciascuno di que' sette agnelli; ");
INSERT INTO ita1885_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","e un becco, per sacrificio per lo peccato, oltre al sacrificio de' purgamenti per lo peccato; e oltre all'olocausto continuo, e la sua offerta di panatica, e le loro offerte da spandere. ");
INSERT INTO ita1885_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Parimente, al quintodecimo giorno del settimo mese siavi santa raunanza; non fate in esso opera alcuna servile; e celebrate la festa solenne al Signore, per sette giorni. ");
INSERT INTO ita1885_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","E offerite per olocausto, per sacrificio da ardere in soave odore al Signore, tredici giovenchi, due montoni, e quattordici agnelli di un anno, che sieno senza difetto; ");
INSERT INTO ita1885_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","insieme con la loro offerta di panatica, di fior di farina, stemperata con olio di tre decimi per ciascuno di que' tredici giovenchi, di due decimi per ciascuno di que' due montoni, ");
INSERT INTO ita1885_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","e di un decimo per ciascuno di que' quattordici agnelli; ");
INSERT INTO ita1885_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","e un becco, per sacrificio per lo peccato, oltre all'olocausto continuo, e la sua offerta di panatica, e da spandere. ");
INSERT INTO ita1885_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","E, nel secondo giorno, offerite dodici giovenchi, due montoni, e quattordici agnelli di un anno, senza difetto; ");
INSERT INTO ita1885_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","insieme con le loro offerte di panatica, e da spandere, per li giovenchi, per li montoni, e per gli agnelli, secondo il lor numero, siccome è ordinato; ");
INSERT INTO ita1885_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","e un becco, per sacrificio per lo peccato, oltre all'olocausto continuo, e la sua offerta di panatica, e le loro offerte da spandere. ");
INSERT INTO ita1885_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","E nel terzo giorno, offerite undici giovenchi, due montoni, e quattordici agnelli di un anno, senza difetto; ");
INSERT INTO ita1885_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","insieme con le loro offerte di panatica, e da spandere, per li giovenchi, per li montoni, e per gli agnelli, secondo il lor numero, siccome è ordinato; ");
INSERT INTO ita1885_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","e un becco, per sacrificio per lo peccato, oltre all'olocausto continuo, e la sua offerta di panatica, e da spandere. ");
INSERT INTO ita1885_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","E nel quarto giorno, offerite dieci giovenchi, due montoni, e quattordici agnelli di un anno, senza difetto; ");
INSERT I