﻿USE sofia;
DROP TABLE IF EXISTS sofia.isn_vpl;
CREATE TABLE isn_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES isn_vpl WRITE;
INSERT INTO isn_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kitabu ka ukoo wang'wa Yesu Kilisto ng'wana wang'wa Daudi, ng'wana wang'wa Ibrahimu. ");
INSERT INTO isn_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibrahimu ae tata wang'wa Isaka, nu Isaka tata wang'wa Yakobo, nu Yakobo tata wang'wa Yuda nialuna akwe. ");
INSERT INTO isn_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","U Yuda ae tata wang'wa Peresi nu Sera kung'wa Tamari, Peresi tata wang'wa Hezeroni, nu Hezeroni tata wang'wa Ramu. ");
INSERT INTO isn_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","U Ramu ae tata wang'wa Aminadabu, Aminadabu tata wang'wa Nashoni, nu Nashoni tata wang'wa Salimoni. ");
INSERT INTO isn_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimoni ae tata wang'wa Boazi kung'wa Rahabu, u Boazi tata wang'wa Obedi kung'wa Ruthi, u Obedi tata wang'wa Yese, ");
INSERT INTO isn_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","u Yese ae tata wang'wa mtemi Daudi, u Daudi ae tata wang'wa Sulemani kumu sungu wang'wa Uria. ");
INSERT INTO isn_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sulemani ae tata wang'wa Rehoboamu, Rehoboamu tata wang'wa Abiya, Abiya tata wang'wa Asa. ");
INSERT INTO isn_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ae tata wang'wa Yehoshafati, Yehoshafati tata wang'wa Yoramu, nu Yoramu tata wang'wa Uzia. ");
INSERT INTO isn_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia ae tata wang'wa Yothamu, u Yothamu ae tata wang'wa Ahazi, u Ahazi tata wang'wa Hezekia. ");
INSERT INTO isn_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekia ae tata wang'wa Manase, u Manase tata wang'wa Amoni nu Amoni tata wang'wa Yosia. ");
INSERT INTO isn_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","U Yosia ae tata wang'wa Yekonia nialuna akwe naiahoilwe kulongola ku Babeli. ");
INSERT INTO isn_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nai aholwa kulongola ku Babeli, Yekonia ae tata wang'wa Shetieli, u Shetieli ai sekulu wakwe nu Zerubabeli. ");
INSERT INTO isn_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabeli ai tata wang'wa Abiudi, Abiudi tata wang'wa Eliakimu, nu Eliakimu tata wang'wa Azori. ");
INSERT INTO isn_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azori ai tata wang'wa Zadoki, nu Zadoki tata wang'wa Akimu, nu Akimu tata wang'wa Eliudi. ");
INSERT INTO isn_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudi ae tata wang'wa Elieza, Elieza tata wang'wa Matani nu Matani tata wang'wa Yakobo. ");
INSERT INTO isn_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","U Yakobo ai tata wang'wa Yusufu mugoha wang'wa Mariamu, kukeela ng'wenso u Yesu akatugwa, naewitangilwe Kilisto. ");
INSERT INTO isn_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Wileli wehi puma u Ibrahimu nu Daudi ae wileli wikumi na inne, kupuma u Daudi nukunolwa kulongola ku Babeli ae wileli wi kumi na inne, nu kumakuholwa kulongola ku Babeli kupika kung'wa Yesu ae wileli ikumi na inne. ");
INSERT INTO isn_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kutugwa kung'wa Yesu Kilisto aeitwile ite, Mariamu, auligigwe nu Yusufu, akaze akile kutankanya, akigeeleka ukete nda ang'wau ng'welu. ");
INSERT INTO isn_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Umugoha wakwe u Yusufu, ae muntu wa tai, singa akalowa kumuhumya uminyala u Mariamu. Akahia amuleke kenkunku. ");
INSERT INTO isn_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Naukusiga ulukani nulanso, umalaika wang'wa Itunda akamizeela kukeela ndoti. Akalunga, “Yusufu ng'wana wang'wa Daudi, leka kugopa kumuhola u Mariamu anga msungu wako, nsoko inda nutite upatile kungulu ya ng'waung'welu. ");
INSERT INTO isn_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ukitunguila ng'wana mgoha ni lina lakwe ukumitanga Yesu, kunsoko ukuaguna antu ni milandu ao. ");
INSERT INTO isn_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Aya ihi aigelekile kukondanilya iko naikiligitigwe ni Tunda kukeela anyakidagu, akalunga. ");
INSERT INTO isn_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Gozi umunanso ukuhola nda nukitunguela ng'wana mugoha, ilina lakwe ukitangwa Immanueli, nsoko akwe “Itunda palung'wi nu sese.” ");
INSERT INTO isn_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yusufu akauka kupuma mutulo akituma anga naulagiigwe nu malaika akamuhola akatula msungu wakwe. ");
INSERT INTO isn_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Palung'wi nayo nanso singa aeihugee, singa akatugwa ung'wana akamitanga lina lakwe Yesu. ");
INSERT INTO isn_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Nae watugwa u Yesu mkisale ka Bethelehemu a Uyahudi mumahiku ang'wa mutemi Herode, eantu nia manyi kupuma kilya na kuli ikapika ku Yerusalemu ikalunga. ");
INSERT INTO isn_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ukolipi uyu nutugilwe umutemi wa Ayahudi? Aza kuina nzota akwe kukilya nusese kapika kumukulya. ");
INSERT INTO isn_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Matungo nu Herode aewija inkani izi akaambwa masigo makulu, i Yerusalemu ihi palung'wi nung'wenso. ");
INSERT INTO isn_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herode akailingiila iakulu ihi nawa neetunza inkani ya antu, akaakolya, “u Kilisto ukutugwa pee?” ");
INSERT INTO isn_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Akamuila, “ukutugwa ku Bethelehemu a Uyahudi, kunsoko uu aeyandikilwe nianyakidagu, ");
INSERT INTO isn_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Nue Bethelehemu, ihi ang'wa Yuda, singa wimunino muatongeeli ang'wa Yuda, kunsoko kupuma kitalako uzile mkulu nuziadima iantu ane Israeli.” ");
INSERT INTO isn_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herode akaitanga iamanyi ankani kenkunku akaakolya ite matungo kelukulu inzota ai ezigela. ");
INSERT INTO isn_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Akaatuma alongole ku Bethelehemu, akalunga, longoli kiisa uende mumuetume ung'wana nutugilwe. Matungo angamamuona, ulete inkani nunene nihuma kuza kumukulya.” ");
INSERT INTO isn_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nai amija umtemi, ikalongoleka numuhinzo wao, ni nzota iyo naeamiine kukilya ikaatongeela ikimika migulya apo nung'wana utugiwe. ");
INSERT INTO isn_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nai amiona inzota ikalowa ikulu. ");
INSERT INTO isn_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ikingila mnyumba ikamuona ung'wana nutugilwe nu Mariamu unyinya wakwe. Ikamiloelya nukumukulya. Ikatungula imaintu nimaza naiatite ikamupa. ");
INSERT INTO isn_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Itunda akaahugulya kukeela ndoti kusuka kung'wa Herode, kululo, ikahega kusuka kihe ao kukeela nzila ngiza. ");
INSERT INTO isn_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nai akondya kuhega, malaika akamuzeela Yusufu kukeela ndoti akalunga, “Uka, muhole ung'wana nu nyinya wakwe mumankeele ku Misri. Musige kuko mpaka ninzemuila kunsoko u Herode wenda ukumupenza amubulage. ");
INSERT INTO isn_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Utiku wuwo u Yusufu akauka akamuhola ung'wana nu nyinya wakwe ikamankiila ku Misri. ");
INSERT INTO isn_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Akikie kuko mpaka u Herode ikasha. Iko naikilingiligwe numunyakidagu, “Kupuma ku Misri numitangile ung'waane.” ");
INSERT INTO isn_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kululo u Herode, akalunga kina iantu awa niahugu antendela ubi, akalaka. Akalagiilya kubulagwa ehi iang'enya niagoha ku Bethelehemu niatite miaka ibiile ni pihe apang'wanso kunsoko aiwakondya kulinga kukeela antu ao niamanyi ankani. ");
INSERT INTO isn_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ingi nailakondigwa ulukani naeluligitigwe kukeela mnyakidagu Yeremia, ");
INSERT INTO isn_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Luli lukigela ku Ramah, kilelo nikinyauwai kikulu, u Raheli akazealila iana akwe, hangi akahita kupumbuligwa, kunsoko ikutile singaaziziona hangi.” ");
INSERT INTO isn_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","U Herode naiwasha, umalaika akamuhanga u Yusufu kukeela ndoti kuko ku Misri akalunga, ");
INSERT INTO isn_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Uka muhole ung'wana nunyinya wakwe, mlongole mihe a Israeli kunsoko awa naienda upenza upanga wa ng'wana akuza.” ");
INSERT INTO isn_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","U Yusufu akauka akamuhola ung'wana nu nyinya wakwe, ikolongola mihe a Israeli. ");
INSERT INTO isn_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ingi gwa nae wija kina Arikelau ae mutemi Yuda pang'wa tata wakwe u Herode. Akogopa kulongola kung'wanso. Matungo ni Tunda nae wamuhugula kukeela mundoti, akahega akalongola mukisali ka Galilaya. ");
INSERT INTO isn_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Hangi akalongola kikie mukisali nikitangwa Nazareti. Ike aekekondaniye iko naikiligitigwe kukeela nzila aanyakedagu, kina ukitangwa Mnazareti. ");
INSERT INTO isn_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","I mahiku ayo u Yohana Mbatizaji auzile akazetanantya ulukani mumbuga ang'wa Yuda akazelunga, ");
INSERT INTO isn_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Leki imilandu kunsoko utemi wa kigulu ukole pakupe.” ");
INSERT INTO isn_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kunsoko yuyu nauligitigwe numunyakidagu u Isaya ikalunga, “Luli la muntu nukitanga mumbuga, leki uza inzila ya Mkulu, gooli kisa imapanda akwe.” ");
INSERT INTO isn_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","U Yohana autugae mauli angamia hangi akitunga numusipi wa ndili mkileno kakwe indya yakwe ai ngaga nu uki wa mihaka. ");
INSERT INTO isn_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Hangi Yerusalemu, Yuda ihi, nikisali kihi nikepilimiye umongo wa Yorodani ikalongola kitalakwe. ");
INSERT INTO isn_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Aizabadisigwa mumongo wa Yorodani nukila itunu imilandu ao. ");
INSERT INTO isn_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Sunga akatyatwa unuduu wa mafarisayo ni masadukayo kuza kubadisigwa, akaeela, unye wileli wa nzoka nikete sumu nyenyu numuhuguye kuutiga uubi nupembilye? ");
INSERT INTO isn_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tugi imaintu nahegekile mumilandu, namuloeye Itunda. ");
INSERT INTO isn_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Leki kusige nukikolya kung'wanyu kutite u Ibrahimu anga tata witu, inge kumuila Itunda uhumile kumuukilya u Ibrahimu iana kupumila mumagwe aya. ");
INSERT INTO isn_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ihengo aikwa mumuli wa muti, kulule umuti nishawipeza indya ninza witeng'wa nukugung'wa mumoto. ");
INSERT INTO isn_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Kumubadiza kunzila amazi, nukumuhugilya muhueli. Kululo uyu nupembilye ukete ingulu kukila unene, hangi kuleng'wa lukulu kukenka ilatu yakwe. Nuanso ukuabadisa kukeela ng'waung'welu nu moto. ");
INSERT INTO isn_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ipetelo nilakupelela ingano likole mumikono akwe, kilingila iyo ninza misalanka. Kululo gwa iyo nikite ipuko ikusonswa umoto uo nishawilima. ");
INSERT INTO isn_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Sunga u Yesu akaza kupembelya kugalilaya akapika mumongo wa Yorodani akabadisigwa nu Yohana. ");
INSERT INTO isn_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yohana akahia amugilye akalunga, unene ntakile mbadisigwe nuewe, nikawaza kitalane? ");
INSERT INTO isn_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","U Yesu akasusha akalunga, “Gomba itule uu itungile. Kunsoko yatula kukondanilye itai ehi.” Sunga u Yohana akamugombya. ");
INSERT INTO isn_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Naiwamala kubadisigwa, u Yesu akapuma mumazi, Ilunde likaluguka kitalakwe. Akamuona ng'waung'welu wang'wi Tunda akazesima anga inkunda nukukilaja migulya akwe. ");
INSERT INTO isn_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Goza, luli ailupumie kilunde lukalunga, “Uyu ng'waane mlowa. ni ndoeigwe nangulu nung'wenso.” ");
INSERT INTO isn_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Sunga u Yesu akatongeelwa nung'waung'welu akapika mumbuga ahume kugeng'wa nu mulugu. ");
INSERT INTO isn_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Pang'wanso ae wiimile kulya indya mahiku makumi anne utiku nu ng'ung'wi sunga akahungwa nzala. ");
INSERT INTO isn_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Mugemi akaza akamuila, “Angwe tai weng'wana wang'wi Tunda maile imagwe aya atule ndya.” ");
INSERT INTO isn_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","U Yesu akasukeelya akamuila, “Yandikilwe, u muntu singa uhumile kikie ni ndya du, uhumilye kikie nalukani nulupumie mumolomo wang'wi Tunda.” ");
INSERT INTO isn_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Sunga umulugu akamutwala mukisali nikiza nukumuika pigulya a nyumba ang'wa Itunda. ");
INSERT INTO isn_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Akamuila, “ang'wi wing'wana wang'wi Tunda, puta pihi nsoko yaandikilye, ukuaila iamalaika akwe akuuke uleke kugwa, hangi akuuhumbula na mikono ao. Sunga shukukumpa umagulu wako pigwe.” ");
INSERT INTO isn_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","U Yesu akaaila, “Hangi yandikilwe, leka kumgema Itunda wako. ");
INSERT INTO isn_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sunga umulugu akamuhola akamutwala migulya akamulagiila utemi wihi nugole akwe nuaunkumbigulu. ");
INSERT INTO isn_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Akamuila, Kupa aya ihi agunihuele nukunkulya.” ");
INSERT INTO isn_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Sunga u Yesu akamuila hega apaite uwe mulugu, kunsoko yandikilwe, mkulye Itunda wako, hange umitumile imilimo ung'wenso du. ");
INSERT INTO isn_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Sunga umulugu akamuleka, iamalaika akaza akituma imilimo akwe. ");
INSERT INTO isn_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Matungo u Yesu naiwija kina u Yohana waambwa, akahega akalongola ku Galilaya. ");
INSERT INTO isn_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Akahega ku Nazareti akenda akatula kikie Kaperanaumu, nikole mpelompelo aluzila Galilaya, mumimbe ni hii ang'wa Zabuloni nu Naftali. ");
INSERT INTO isn_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Iye aigeelekile kukondanilya iko naikiligiligwe nu munyakidagu u Isaya. ");
INSERT INTO isn_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Kululo ihi ang'wa Zabuloni nihi ang'wa Naftali kulonga kuluzi, itumbi la Yorodani, Galilaya aanyakilungu! ");
INSERT INTO isn_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Antu nikie mukiti auona uwelu nukulu, nao naikie mumululewa ushi, migulya ao alikilwa nung'waung'welu.” ");
INSERT INTO isn_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Pumeela matungo yayo u Yesu akandya kutanantya ulukani akazelunga leki imilandu kunsoko utemi wa kigulu wahugeela.” ");
INSERT INTO isn_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Naugenda mumpelompelo a luzi la Galilaya, akaaona anyandugu abiili, Simoni naiwitangwa Petro, nu Andrea muluna wakwe, ikazetega muluzi kunsoko aiavui a samaki. ");
INSERT INTO isn_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","U Yesu akaaila, nzii ntyati, kumupa uhumi mukivua iantu. ");
INSERT INTO isn_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Sunga ikaleka inyavu ikamutyata. ");
INSERT INTO isn_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","U Yesu naikile ulongolekile numuhinzo akaaona anyandugu abiili hangi, Yakobo ng'wana wang'wa Zebedayo, nu Yohana muluna wakwe. Aaze akoli mibina palung'wi nu Zebedayo utata wao akaze tumainyavu yao akaitanga, ");
INSERT INTO isn_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Shanga ekisinsela ikalileka ibine nu tata ao ikamutyata. ");
INSERT INTO isn_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","U Yesu akagendeela i Galilaya ihi, akaze amanyisa mumapolyo ao, akazetanantya ulukani la utemi wa kigulu, hangi niantu akaza komya indwala. ");
INSERT INTO isn_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Inkani yakwe ikenela Isiria ihi, niantu ikaaleta ihi iantu awa niilwala indwala ni makendi, niatile iamintunga, niagwa nkolo nawa niatite igandi. U Yesu akaakomya. ");
INSERT INTO isn_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Iumbi ikulu la antu likamtyata kupumiila ku Galilaya nuku Dekapoli, Yerusalemu nuku Uyahudi nukupuma kitumbi la Yorodani. ");
INSERT INTO isn_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","U Yesu naewaliona iumbi, akahega akalongola Mulugulu, naewikie pihi, iamanyisigwa akwe akaza kitalakwe. ");
INSERT INTO isn_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Akaligitya nukuamanyisa, akalunga, ");
INSERT INTO isn_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Bahu awa nia kia amunkolo kunsoko utemi wa kigulu wao. ");
INSERT INTO isn_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Bahu niakite ikinyauwai, azizapumbuligwa. ");
INSERT INTO isn_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Bahu awa niapolo, kunsoko azizamisala ihi. ");
INSERT INTO isn_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Bahu awa niakite inzala ni nyota atai kunsoko azizalisigwa ikute. ");
INSERT INTO isn_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Bahu awania hegelya imilanda nienso aziza hegeligwa. ");
INSERT INTO isn_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Bahu awa niankolo nza azemuona Itunda. ");
INSERT INTO isn_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Bahu awa niakaminkanya, nsoko nianso azezitangwa ana ang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Bahu awa neitumigwa usese kunsoko atai, nsoko utemi wa kigulu wao. ");
INSERT INTO isn_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Bahu unye niantu akumutukila nukumitumya ubi, nukumligitya ubi nuteele kunsoko ane. ");
INSERT INTO isn_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Lowi nukulumbiilya kunsoko ikipegwa kanyu kikulu kigulu. Kunsoko inge uu aiaitumilya ubi ianyakidagu nia kali. ");
INSERT INTO isn_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Unye mi munyu wa unkumbigulu umunyu iga ulimilye umulyo wake, ukutula ne munyu hange? Singa ukutula uza kukintu nikingiza inge ukugung'wa kunzi nukupambatwa nimigulu aantu. ");
INSERT INTO isn_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Unye miwelu wa unkumbigulu. Ihi nizengilwe mulugulu nishalipihile. ");
INSERT INTO isn_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Iantu singa akakilya ulumule nukuluika pihi a nkapu, akumiika migulya, ikualika ihi niakoli munyumba. ");
INSERT INTO isn_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Leka uwelu wanyu welye kuntongeela aantu kunsoko aione intendo yanyu ninza hangi amukulye utata wanyu nuakigulu. ");
INSERT INTO isn_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Leki kusigiili kina ainzile gazanja uzipiili nia anyakidagu. Singa zegazanja zilekondanilya. ");
INSERT INTO isn_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kutai kumuila unkumbigulu nihi ihi ukile hangi kutile uzipiilya hata nung'wi, mpaka nuzetula wakondigwa. ");
INSERT INTO isn_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kululo wihi nuibananga ilagiilyo ninino nilamalagiilyo aya nukuamanyisa kituma niangiza uu ukitangwa munino muutemi wa kigulu. Inge gwa wihi nuiambile nukuimanyisa ukitangwa muutemi wa kigulu. ");
INSERT INTO isn_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kunsoko numuie itai anyu igehite kumikelinkela itai a mafarisayo, shanga mukingile mtemi wa kigulu. ");
INSERT INTO isn_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Amigulu ikali ailambuwe kina leka, “kubulaga” numubulagi wihi ukole mubii wa ulamulya. ");
INSERT INTO isn_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Hangi kumuila wihi ni shumuloilwe muluna akwe ukutula ukole mubii wa ulamulwa. Hangi muntu wihi nukumuila umunyandugu wakwe kina shufaile! ukutula mubii wianza. Nuyu wihi nuilunga uwe wimupungu, ukutula mubii wa moto wamu jehanamu. ");
INSERT INTO isn_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ang'wi ukupumya isongeelyo kuntongeela ikumbikilo, kunu aza mileile numunyandugu shamiungamie, ");
INSERT INTO isn_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Lileke isongeelyo pa ntongeela pi kumbikilo, uambi nzila ende miungamile hanza numunyandugu wako, usuke uzupumye gwa isongeelyo. ");
INSERT INTO isn_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Kayi igombi numilei wako munzila nimukili mulongoe kianza, hakamuhite kigombya umilei wako uhumile akuleke mumikono angwa mlamuli hangi ugung'we kukitungo. ");
INSERT INTO isn_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tai numuie shangaukulekelwa mpaka mulipe impia nimudaigwe. ");
INSERT INTO isn_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Migule iligitigwe kina leka, “Kugoolya.” ");
INSERT INTO isn_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Numuie kina wihi nukumugoza umusungu nukumulowa wagoolya munkolo akwe. ");
INSERT INTO isn_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ang'wi iliho lako nila mukono wako nua kigoha lenda kutwala muibe, liheje uligume kule nuewe, ikatula bahu muili unino ugung'we unukulu uguneke kugung'wa ku jehanamu. ");
INSERT INTO isn_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ang'we umukono wa kigoha inda nsoko akukumpa uteme ugume kuli, sunga umuili nungiza uleke kugung'wa ku jehanamu. ");
INSERT INTO isn_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Itambuwe kina wihi nukumuzunsa umusungu wakwe ampe ikilingisilyo kutai na ulamulwa. ");
INSERT INTO isn_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Une numuie wihi nukumleka umusungu wakwe nsoko a ugoolya, ukutula wituma usambo. Hangi wihi nukumuhugela anga wapegwa ulamulwa wa tai ukutula wituma usambo. ");
INSERT INTO isn_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Hangi migule aitambuue kuantu ao niakali, leki kutambuli uteele, kululo twali itai anyu kumukulu. ");
INSERT INTO isn_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Une numuie, leki kutambula hata niniino, ang'wi kigulu, nsoko kung'wanso kung'witunda. ");
INSERT INTO isn_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ang'wi mihi, nsoko wieka ituntu lakupambatilya impambatilyo yakwe ang'wi Yerusalemu, nsoko ingi kisali ni kamutemi numukulu. ");
INSERT INTO isn_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Leka kulapa nitwe lako, kunsoko shukulipeula isingi ling'we litule lyelu ang'wi ilwaalu. ");
INSERT INTO isn_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ingi gwa inkani yanyu, tai, tai, singau, singa u, kunsoko ayo nakangeelya ipuma kumulugu. ");
INSERT INTO isn_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Migule iligitigwe kina, liho na liho ni lino na lino. ");
INSERT INTO isn_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Une numuie leki inkungumi nu muntu nu mubii, anga wakukua ikunda nilamkono wa kigoha mupiuele nilulya. ");
INSERT INTO isn_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ang'wi wihi nuloilwe kulongola nuewe kianza anga wakuhegelya inkanzu ako, muleke ni joho lao. ");
INSERT INTO isn_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nuyu wihi nukuonyeelya kulongola muhinzo ung'we, longola nung'wenso mihinzo ibiili. ");
INSERT INTO isn_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Wihi nukulompa mpe, hangi uleke kumuhita uyu nutakile umukopise. ");
INSERT INTO isn_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Migule iligitigwe mlowe umunyakisali wako, na umuhukilwe umubi wako. ");
INSERT INTO isn_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kululo numuie, alowi iabi anyu, alompeeli awa nimutasha. ");
INSERT INTO isn_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ingi gwa mutule miano wang'wa tata wanyu nuakigulu, kunsoko wialikila ilyoa iabi niaza. Hangi wikuisa imbula kuabi niaza. ");
INSERT INTO isn_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Anga mualowe ao nizamualoilwe nye, mipata kintu kii? Aiahoela mpia shaituma ne itii? ");
INSERT INTO isn_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Anga mulamushe ianyandugu anyu du mipata ntuni kua uya? Ianyakilungu shaituma ne uu? ");
INSERT INTO isn_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kululo ihumikile mutule mia tai, anga utata wanyu nuakigulu nukoli mutai. ");
INSERT INTO isn_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Tula miho uleke kituma intendo niyatai kuntongeela aantu nukielya kitalao, nsoko shukupata ukembetwa kupuma kung'wa tata nukole kigulu. ");
INSERT INTO isn_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kululo nukupumya leka kukua impembe nukikulya anga ao niielya niakoli mumatekeelo numuisali, nsoko iantu aakulye, tai numuie asingiilya uziza wao. ");
INSERT INTO isn_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Uwe nukupuma, umukono wako nuakikema uleke kulinga iko nikekitung'wa numukono nua kigoha. ");
INSERT INTO isn_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ingi gwa ikintu kako kipumigwe kwa kinkunku. Pang'wanso utata ako nuiona unkunku ako ukuupa imaintu ako. ");
INSERT INTO isn_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Hangi nukulompa, uleke kutula anga ao niielya, kunsoko ilowa kimika nukulompa mumatekeelo numumpelo ya isali, nsoko agozwe niantu. Tai numuie akondilye kupegwa ipegwa yao. ");
INSERT INTO isn_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kululo gwa, angawahia kulompa ingile munyumba lugaila umulango ulompe kung'wa Tata ako nukole kunkunku. Pang'wanso utata ako nuiona unkunku ukuupa ikipegwa kako. ");
INSERT INTO isn_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nukulompa leka kusukila sukiila inkani ningila insoko anga anyakilungu niituma, isiga kina akigigwa kunsoko amakani du niakumaligitya. ");
INSERT INTO isn_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kululo, uleke kutula anga nianso, kunsoko utata ao aiwalinga kina atakile ntuni nianso akazi akili kanu kulompa. ");
INSERT INTO isn_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ingi lompa iti: Tata witu nukoli kilunde lina lako likuligwe. ");
INSERT INTO isn_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Utemi wako uze, ulowa wako witume mihi anga nuituma kilunde. ");
INSERT INTO isn_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ukupe indya yitu nia leliye. ");
INSERT INTO isn_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ukulekele imilandu anga usese nikialekela awa naiakukosee. ");
INSERT INTO isn_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Uleke kuutwala muma geng'wa, ukupugamule numulugu. ");
INSERT INTO isn_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Anga itule mukualekela iantu imilandu ao, nunyenye utata anyu nuakigulu nung'wenso ukumulekela. ");
INSERT INTO isn_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ang'wi shamukualekela imilandu ao ka nu tata anyu shukumulekela imilandu anyu. ");
INSERT INTO isn_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Matungo ihi nakiima leka kigeeleke anga ao niilya, akunye imakelu ao anwe kina iimile kuntongeela aantu. Tai kuila asingiilya ipegwa yao. ");
INSERT INTO isn_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kululo uewe niwiimile, paka imakuta itwe lako, hangi woje usu ako. ");
INSERT INTO isn_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ingi shaikigeeleka kuntongeela aantu kina wiimile, ikutula kung'wa Tata ako nuakinkunku. Nu tata ako nuiona unkunku ukuupa ikipegwa kako. ");
INSERT INTO isn_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Leka kiekilya ikiuto kako munu mihi akoli agazanji, nii ii niibunanga nukia. ");
INSERT INTO isn_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Iekelya ikiuto kako kigulu, kung'wanso kulile anga agazanji, hangi tile anga ii niakubunanga nukia. ");
INSERT INTO isn_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kunsoko kuna kiuto kako kikoli, kuko ni nkolo ako izize ikoli. ");
INSERT INTO isn_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","I liho lumuli la muili. Kululo ang'wi iliho lako ipanga, muili wihi ukizuligwa welu. ");
INSERT INTO isn_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Anga itule iliho lako ibe, umuili wako wihi ukizula kiti nikibe. Anga itule uwelu nuukole mitalako wa ki ti nangulu, ikiti kikutula kikulu nangulu. ");
INSERT INTO isn_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Kutile ata nung'wi nuhumila kuitumila akulu abili, kunsoko ukumuhukilwa ung'wi nukumlowa numungiza, hangi ukipumya kumukulya ung'wi, nukuhita kumukulya umuya. Sha mukumtumi kila Itunda ni nsao. ");
INSERT INTO isn_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Kululo kuila, heja uoa wako, kina ukulya ntuni, ang'wi ukung'wa ntuni, ang'wi umuili ako, ukutugala ntuni. Aya hii singa akilingie indya, nu muili ukilinkie utugali? ");
INSERT INTO isn_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Goza inyunyi nikoli migulya. Shaitemela, shaikungula hangi shayilingila nukuika misalanga, utata anyu nua kigulu wilesa, unye sha miazane kukila nianso? ");
INSERT INTO isn_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nyenyu nuhumile kiongeela ala uluhiku nulung'wi munu mihi upanga wakwe? ");
INSERT INTO isn_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Niki nimukula nuwoa nuakutugala? Si sigiila maua nitula mumagunda nitulakula, shituma anga milimo, hangi shanga akitugalya. ");
INSERT INTO isn_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nkili kumuila kina ata Sulemani mugole wakwe wihi shautugawi ana nanso. ");
INSERT INTO isn_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ng'wi Itunda wiimatugalya imatutu na mumigunda nikie luhiku lung'wi numudau agung'we mumoto, aunye mkulaigaligwa uu, nimutite uhuili unino? ");
INSERT INTO isn_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kululo leki kutula nuwoa, kina kuulya ntuni? Angwe kutendwa ule? angwe kutugala ntuni? ");
INSERT INTO isn_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kunsoko ianya kilungu akuduma yayo, nu Tata nyu nuakigulu uineu kina mtakile yayo. ");
INSERT INTO isn_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ingi gwa hanza upenzi utemi wakwe ni tai akwe nayi hii mukupegwa kitalakwe. ");
INSERT INTO isn_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kululo leka kutula ninkiki nsoko amudau, aya namudau akizipiilya imenso. Kila uluhiku lutete ninkani yakwe. ");
INSERT INTO isn_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Leka kuakenkya ulamulwa, nuewe uzuleke kukenkigwa ulamulwa. ");
INSERT INTO isn_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ulamulwa nuapeza, nue uziza lamuilwa. Ningele nuiapimila nuewe uziza pimilwa yiyo yiyo. ");
INSERT INTO isn_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kuniki nukugoza ikipande kamuti nikikoli muliho la mnyandugu ako, kunu shuine ikipande kigogo nikikoli muliho lako? ");
INSERT INTO isn_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Uhumile ule kulunga kumunyandugu ako, kilaja nukuhegelye igogo nikikoli muliho lako, kunu uewe igogo likoli muliho lako? ");
INSERT INTO isn_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wimieli uewe; hangi heja igogo nilikoli muliho lako, hangi pang'wanso ukuhuma kuona iza nukuheja igogo la miti nilikoli muliho la munyandugu ako. ");
INSERT INTO isn_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Leka kuipa mbwa iko nikigila imilandu, hangi leka kuigumila ingulima insailo kuutongeela ao. Uhumile kuigazanja nukuipambata namigulu, hangi akupilukila nukutamulanga inino inino. ");
INSERT INTO isn_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Lompa, nuewe ukupegwa, duma nuewe ukulija, pindula nuewe ukuluguilwa. ");
INSERT INTO isn_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Wihi nuilompa wisingiilya, nuyu wihi nuiduma wilija, nu muntu wihi nuipindula wiluguilwa. ");
INSERT INTO isn_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ang'wi ukoli muntu kitalanyu, ung'wana agalompe indya ukumpa igwe? ");
INSERT INTO isn_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Angwe ukumulompa nsamaki, nungwenso amupe nzoka? ");
INSERT INTO isn_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ang'wi unye nimiabe mumanyile kuapa iana anyu ipegwa niza, au Tata nukuli kigulu singaukuapa nangulu imaintu nimaza ao nimulompa? ");
INSERT INTO isn_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kululo gwa, ayo nuilowa kitumilwa niako, nuewe uitumile iako uu. Kunsoko nuanso uzipilya numunyakidagu. ");
INSERT INTO isn_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ingili kukiila ikihepeelo nikipinyi. Kunsoko ikihepeelo nikigali ni nzila ningali ihongile kuubi hangi antu idu ikiila inzila nanso. ");
INSERT INTO isn_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ikihepeelo nikipinyi, ikihepeelo nikipinyi ingi nzila nilongoe kuupanga hangi akehu niahumile kumiona. ");
INSERT INTO isn_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ihambe nianyakidagu niautelee, azile aze atugae ndili ya nkolo, nianso mbugi ni ntaki. ");
INSERT INTO isn_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kuntendo yao mukualinga. Iantu ahumile na kukungula indya mumija, ang'wi itini mumibaruti. ");
INSERT INTO isn_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kululo umuti nuuza wituga indya ninziza, nu muti nuubi wituga ndya nimbi. ");
INSERT INTO isn_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Umuti nuuza shanga uhumile kutuga indya nimbi. Nu muti nuubi shaukutuga indya ninza. ");
INSERT INTO isn_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Muti wihi nishaukutuga indya ninza ukuteng'wa nukugung'wa mumoto. ");
INSERT INTO isn_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kululo ukualinga kukiila ntendo yao. ");
INSERT INTO isn_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Singa ihi nimbila, mukulu mukulu, akingila mutemi wa kilunde, aoiti du niituma ulowa wang'wa Tata nana nuakigulu. ");
INSERT INTO isn_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Antu idu azimbila uluhiku nulanso, mukumukulu kua lina lako, shaikuhegelye iamintunga kua lina lako, hangi kukiila lina lako shaikitumile ne nimakulu? ");
INSERT INTO isn_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pang'wanso ziza aila kimazali, shanumulingile unyenye! Hegi kitalane, unye nimituma nimabi! ");
INSERT INTO isn_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Kululo wihi niwija inkani yane nukuityata ukimpyana numuntu numuhugu nauzengile inyumba akwe migulya nigwe. ");
INSERT INTO isn_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mbula ikakua, imazi akizula, nung'wega ukiza ukamikua inyumba pihi, kunsoko aizengilwe migulya migwe. ");
INSERT INTO isn_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Uyu niwija ulukani lane, ahite kulukela, ikimpyanigwa numuntu numupungu nuzengele inyumba mihanga hanga. ");
INSERT INTO isn_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mbula ikaza, mazi akaza, nung'wega ukaza ukamikua ikagwa, nungwi wake ukatula ukulu. ");
INSERT INTO isn_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ikapika matungo u Yesu naiwakondya kuligitya inkani nianso, umilundo ukakuilwa numanyisi wakwe. ");
INSERT INTO isn_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Kululo aiwiamanyisa anga muntu nukite uhumi, hangi singa anga aandiki ao. ");
INSERT INTO isn_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Matungo u Yesu naukusima pihi kupuma mulugulu, milundo ukulu ukamutyata. ");
INSERT INTO isn_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Goza, umunyambili akaza kuntongeela akwe, akalunga “Mukulu, ang'wi wihambile, uhumile kunzipya ntule nimuza. ");
INSERT INTO isn_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","U Yesu akagoola umkono akwe nukumuamba, akalunga, “Nihambile utule wing'welu.” Matungo yayo akazipigwa imbili ikahila. ");
INSERT INTO isn_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","U Yesu akamuila, “Goza uleke kumuila muntu wihi. Ambi nzila ako, hangi ulongole uewe ende umulagile umdimi, upumye nisongeelyo numusa au iagiiye, kunsoko awikengi wako.” ");
INSERT INTO isn_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Matungo u Yesu akapika Kapernaumu, munyangulu ung'wi akaza kitalakwe akamuuliza, ");
INSERT INTO isn_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","akalunga, “Mukulu, umitumi ane ulae munyumba ukete ulwae wigandi hangi umuili utete uwai wakogopa.” ");
INSERT INTO isn_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","U Yesu akamuila, nzile nukumukamya.” ");
INSERT INTO isn_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Umunyangulu akasukiilya hangi akamuila, “Mukulu unene niantuni ni mpaka nize ningile munyumba ako. Tambula ulukani du numitumi ane ukukomigwa. ");
INSERT INTO isn_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kunsoko une nimuntu ninkite uhumi ntete anino ane anyangulu, akanunge kung'wa uyu “Longola” wilongola nukumuya, nzuu nung'wenso wiiza, nukumitumi wane. Itume iti, nung'wenso ukituma uu. ");
INSERT INTO isn_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Matungo u Yesu naiwija aya, akakuilwa, akaila ao naiamutyatile, tai namuita nkili kuona umuntu nukite uhuili anga uyu mihi iyi na Israeli. ");
INSERT INTO isn_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Idu azile akupuma kilya ning'weli, akikie palung'wi nu Abrahamu, Isaka nu Yakobo muutemi wa kigulu. ");
INSERT INTO isn_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ingigwa iana autemi akugung'wa mukiti nikakunzi, pang'wanso izitula kililo kakasia namino.” ");
INSERT INTO isn_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","U Yesu akamuila umunyangulu, “Longola! Anga nauhuie, na itule anga uu kitalako, nu mitumi akagunika itungo lilo. ");
INSERT INTO isn_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Matungo nu Yesu aupikile munyumba ang'wa Petro, akamuona umukwingwa ang'wa Petro nuakisungu ulae akazimulwae ndwala. ");
INSERT INTO isn_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","U Yesu akamuamba umukono wake, nindyala ikahega, sunga akauka akatula muailya. ");
INSERT INTO isn_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Naipikile impindi antu idu ikamuletela u Yesu antu idu naikaiwe niamintunga. Akaazunsa iamintunawa naialwae akaakomya. ");
INSERT INTO isn_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kunsoko iyiye aakondigwe kuligitigwa nunabii Isaya, “Ung'wanso aukenkile ulwae witu hangi aukenkile upungukilwa witu.” ");
INSERT INTO isn_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Sunga u Yesu naiwaliana iumbi nailimupilimile, akaalagila ende nkigi ngiza na luzi la Galilaya. ");
INSERT INTO isn_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Sunga muika nkani ung'wi akaza kitalakwe akamuila, “Mumanyisi, kunuhongee.” ");
INSERT INTO isn_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","U Yesu akamuila, “Amulula atite imakombo, ni nyunyi niamigulya itite iuye, ung'wana wang'wa Adamu mugila uhongo wakulalisha itwe.” ");
INSERT INTO isn_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mumanyisigwa ung'wi akamuila, “Mkulu, ngombye hanza nongole nende muika ibaba ane ukule.” ");
INSERT INTO isn_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Sunga u Yesu akamuila, “Ntyate, hange uwaleke iashi aike iashi ao.” ");
INSERT INTO isn_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","U Yesu naiwingie mibini, iamanyisigwa akwe ikamutyata mibini. ");
INSERT INTO isn_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Goza uluzi ukatula nimaingo makulu, ibini lika kunikilwa ni mazi, imatungo nanso u Yesu au iae. ");
INSERT INTO isn_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Amanyisigwa akaza kitalakwe akamupitya akalunga, “Tata kugune usese kakasha!” ");
INSERT INTO isn_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","U Yesu akaaila kuniki nimukogopa, unye nimutite uhuili unino? Itungo inino akauka akaupalya ung'wega nu luzi. Sunga ung'wega ukakilaga. ");
INSERT INTO isn_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Itunja ikakuilwa ikalunga, uyu muntu kii, uluzi niamintunga akumukulya?” ");
INSERT INTO isn_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Matungo nu Yesu nauzile kunkika kihi na Magadala, itunja abiili naizaingiwe niamintunga ikatankanya nung'wenso akaze apumie muibiila akazenyomana ikulu, kutile muntu amihizazo nauhumila inzila nanso. ");
INSERT INTO isn_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Akitunta ikalunga, kukete ntuni kitalako, uwe ng'wang'wi Tunda? Waza kuunyoma umatungo itu akili kupika? ");
INSERT INTO isn_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ilundo ikulu nila ngulima ailikudima, singa aikuli napo naiakoli, ");
INSERT INTO isn_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","amitunga azetukana kung'wa Yesu, akazilunga, ang'we ukuzunsa kupume, kutwale milundo la ngulima.” ");
INSERT INTO isn_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","U Yesu akaila, “Longoli!” Iamintunga ikamanka ikalongola mungulima. Ilundo lihi likasima kupuma mulugulu, kuhonga muluzi, yihi ikashila mumazi. ");
INSERT INTO isn_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Eitunja nakuidima ingulima ikamanka. Naialongola mukisali ikaligitya ihi ayo napumie kuitunja ao naingigwe niamintunga. ");
INSERT INTO isn_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kisali kihi kikaza kulankanya nu Yesu. Naiamuona, ikamupepelya alege mukisali kao. ");
INSERT INTO isn_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","U Yesu akingila mibini, akaputa akapika kukisali naiaikile. ");
INSERT INTO isn_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Goza ikamuletela muntu naimulwae gandi akazilae migodoro. Naiwauona uhuili wao, u Yesu akamuila umuntu naimulwae wigandi, ng'waane tula nuulowa, imalandu ako walekelwa.” ");
INSERT INTO isn_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Iamanyisi ankani ikandya kitambulya enso na enso, umuntu uyu ukumela. ");
INSERT INTO isn_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","U Yesu akalinga imasigo ao akalunga, Niki nimukusiga imabi munkolo yanyu? ");
INSERT INTO isn_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nikiuli nikipepela kulunga, milandu ako alekelwa, ang'wi kulunga, imike igende? ");
INSERT INTO isn_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kululo gwa mlinge kina ung'wana wang'wa Adamu ukite uhumi nukulekela iamilandu...” amaligitilye kung'wa uyu naimulwae wigandi, imike uhole igodoro lako, hangi ulongole kitalako.” ");
INSERT INTO isn_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Sunga umuntu nuanso akimika akalongola kitalakwe. ");
INSERT INTO isn_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Umilundo naiwaona aya, ikaambwa ikuilwa nukumulumbilya itunda nua pee uhumi nuanso. ");
INSERT INTO isn_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","U Yesu naukeile pang'wanso akamuona muntu naiwitangwa Mathayo, naiwikie palung'wi niahoela mpia. Nung'wenso akamuela “Tyate” nung'wenso akamutyata. ");
INSERT INTO isn_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","U Yesu awikie munyumba ahume kulya indya, akaza ahoela mpia idu, niantu nianyamilandu ikalya palung'wi niamanyisigwa ang'wa Yesu. ");
INSERT INTO isn_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ingi iamanya nkani naiaona nanso, ikaaila iamanyisigwa, “Kuniki umumanyisi wanyu, niki nukulya indya niahoela mpia palung'wi niamilandu? ");
INSERT INTO isn_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","U Yesu naiwija nanso, akalunga, “Iantu niapanga shamlakile umuganga awa nialwae wawo amuloilwe umuganga. ");
INSERT INTO isn_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ingi gwa longoli mendo mimanyise itai akwe ntuni, ndoilwe ngulu kupuma kumukola singa masongeelyo” kunsoko ainzile, singa ainzile kuanyatai kila itunu, kunsoko aanyumilandu. ");
INSERT INTO isn_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Sunga iamanyisigwa ang'wa Yohana akaza kitalakwe akalunga, kuniki usese niamanya nkani nikiima, aiamanyisigwa niki nishaima? ");
INSERT INTO isn_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","U Yesu akaila, iatindikilya awinga ahumile nekutula nikinyauwai matungo numunyawinga ukutala palung'wi nienso? Ingi mahiku apembilya umunyawinga nuziholya kupuma kitalao, pang'wanso azizima. ");
INSERT INTO isn_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kutile umuntu nuikuila ikilaka ka ng'wenda nuupa mung'wenda nuakali, ikilaka kikutotoka kupuma mung'wenda nuutamukwa ukutula ukulu. ");
INSERT INTO isn_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kutile iantu niika umunyo nuupya mkiseme nikamuvinyo nikale, ang'wi akituma, ngozi itachanika, numuvinyo ukuhega, nindili ikugazika. Badala akwe wiikwe umuvinyo nuupya nindili nimpya hangi akutula maza. ");
INSERT INTO isn_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Matungo nu Yesu akuila inkani izi, goza akaza muntu kuntongeela akwe akatugama, akalunga, “Munanso wane matungo makupi ukule, ingi nzuu gwa uikile migulya imikono ako nung'wenso ukukomya. ");
INSERT INTO isn_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ingi gwa u Yesu akimika, hangi akamutyata palung'wi niamanyisigwa akwe. ");
INSERT INTO isn_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Goza umusungu naiwipuma isakami matungo amiaka ikimi ling'wi nibiili, akaza pakupe nu Yesu akamuamba mipindo lakwe nilijoho. ");
INSERT INTO isn_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kunsoko aulungile, “Anga niliambe ijoho lakwe, une kukomya.” ");
INSERT INTO isn_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","U Yesu akapiluka akamugoza, “Munanso, ipe umoyo, uhuili wako wakuguna, Ni matungo yayo yayo umusungu akagunika akapela kupuma isakami. ");
INSERT INTO isn_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","U Yesu akapika munyumba amuntu ung'wi mkulu, akaona iakua mpembe numilundo wantu ukazogolya. ");
INSERT INTO isn_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","U Yesu akalunga, hega apo, kunsoko umunanso shukule ingi ulaeu. Nianso ikatula heka. ");
INSERT INTO isn_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Iantu nianso naiapumigwa kunzi, akingila munyumba akamuamba umunanso kumukono akauka. ");
INSERT INTO isn_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Inkani izi ikasambaila ikisali kihi. ");
INSERT INTO isn_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","U Yesu naukoli mumuhinzo itunja abiili aboku ikamutyata. Ikalongoleka kitunta, akazilunga, kulumba, ukugune imilandu, ng'wa Daudi. ");
INSERT INTO isn_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Matungo u Yesu naiwapika munyumba iapoku nianso ikaza kitalakwe. U Yesu akaila, muhuie ne kina nkite uhumi nua kituma? Nienso ikamuila, Ee kuhuie Mkulu.” ");
INSERT INTO isn_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","U Yesu akaamba imiho ao akalunga, itule uu kitalanyu, anga uhuili wanyu nuile. ");
INSERT INTO isn_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ni miho ikaona, u Yesu akalagiilya akalunga, gozi muntu wihi aleke kumanya aya namupumie unyenye. ");
INSERT INTO isn_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ingi gwa iantu awa niabili ikalongola kutanantya inkani izi nia ukuilwa ikisali kihi. ");
INSERT INTO isn_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Itunja abiili aakugenda azeahongile yao, muntu ung'wi kimume aukete amintunga akatwalwa kung'wa Yesu. ");
INSERT INTO isn_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Niamintunga naiamuteela, ukimume nuanso akandya kuligitya. Umilundo ukaambwa ikuilwa ukalunga. Ulukani ulu izalukili kigele mihi iyi na Israeli. ");
INSERT INTO isn_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ingi gwa iamanya nkani akazilunga kuakulu amintunga, ukuazunsa iamintunga.” ");
INSERT INTO isn_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","U Yesu akalongola muisali yihi. Akatula manyisa mumatekeelo, akazitanantya lukani la utemi wa kigulu, nuhumi nuakuguna indwala yihi. ");
INSERT INTO isn_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Naiwaona umilundo, akauhumila kinyauwai, kunsoko aiagili nukubunika inkolo, aiatuile anga inkolo ningila umudimi. ");
INSERT INTO isn_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","U Yesu akaila iamanyisigwa akwe, indya ipie idu, itumi akenu. ");
INSERT INTO isn_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kululo gwa kayi kulompi kumukulu nua indya izi niipie, ahume kutuma uhumi nia indya yakwe. ");
INSERT INTO isn_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","U Yesu akaitanga iamanyisigwa akwe ikumi na abili akaapa uhumi wa kuzunsa amintunga niabi, kuakenela nukuheja indwala yihi. ");
INSERT INTO isn_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Mina aitumi ikumi naabili sayala ng'wandyo, Simeoni (naiwitangwa Petro), nu Andrea muluna akwe, Yakobo ng'wa Zebedayo, nu Yohana muluna akwe. ");
INSERT INTO isn_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipo, nu Bartimayo, Thomaso nu Matayo muhoela mpia, Yakobo ng'wa Alfayo, nu Tadeo. ");
INSERT INTO isn_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simeoni mkananayo, nu Yuda Iskariote, naumuhitile u Yesu. ");
INSERT INTO isn_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Awa ikumi na abili u Yesu akaatuma, akaatuma akaalagiila akalunga “Muleke kulongola uko nikie ianyakilungu, hangi muleke kingila mu isali ya Samaria. ");
INSERT INTO isn_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ingi gwa mulongole munkolo nailimie mito lang'wa Israeli. ");
INSERT INTO isn_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nuko nimulongoe, muzitanantya nukulunga, utemi akigulu wahugela.” ");
INSERT INTO isn_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Aguni ialwoe, aushi uashi, anoni ianyambili azunsi iamintunga. Musingiyeu nunyenye pamiu. ");
INSERT INTO isn_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Muleke kukenka isao, mumbugulu yanyu. ");
INSERT INTO isn_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Leka kuhola imbugulu mumuhenzo anyu, ang'we wakukaila, ilatu ang'wi mulanga, kunsoko umitumi uloiwe ndya yakwe. ");
INSERT INTO isn_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Kisali kihi nimukingile, mdume umuntu nimuhumile kikie, sunga nimuzizahega. ");
INSERT INTO isn_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nimukingila pang'wanso lamushi, ang'we inonee pang'wanso, upolo wanyu usige hapo, ");
INSERT INTO isn_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ang'wi inyumba shinonee, muhege nuupolo wanyu. ");
INSERT INTO isn_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nao nishaakumusingilya mukulegeelya inkani yanyu, matungo nimukuhega munyumba ang'wi mukisali nikanso, kununti ulunkundi nula migula nyu kuko. ");
INSERT INTO isn_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tai numuie, izitula iza iisali ya sodoma ni Gomola imahiku naulamatwa kukila ikisali nikanso. ");
INSERT INTO isn_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Tuli miho, kumutuma anga nkolo midale la mbugi, kululo mulule miahugu anga inzoka hangi miapolo anga inzia. ");
INSERT INTO isn_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mutule miho niantu, akumutwala mumaanza, hangi akumukua mumatekeelo. ");
INSERT INTO isn_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Hangi mukuletwa kuntongeela akulu nukuatemi kunsoko ane, anga wihenge wao nukuanya kilungu. ");
INSERT INTO isn_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Anga makatungigwa, leki kutuli nuwoa kuuligitya ntuni, kunsoko iko nikakuligityakuupegwa imatungo yayo. ");
INSERT INTO isn_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kululo singa nyenye mukuligitya, ng'waung'we wang'wa Tata anyu ukuligitya. ");
INSERT INTO isn_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Uzimuluta umuluna akwe nukumubulaga, nu Tata kung'wa akwe. Ni ana kulemanya nia leli, mukuatwala munsha. ");
INSERT INTO isn_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Antu ihi akumuhukilwa kunsoko a lina lane, hangi wihi nukugimya sunga impelo ukugunika. ");
INSERT INTO isn_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Matungo nimukagigwa mukisali iki, mankiili mukisali nikityatie, kutai kumuila, singa mukutula menda muisali yihi nia Israeli azizakili kusuka ung'wana wang'wa Adamu. ");
INSERT INTO isn_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Umumanyisigwa singa mukulu kukila umumanyisi wakwe, ang'we umutugwa azukoli migulya amukulu akwe. ");
INSERT INTO isn_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Umumanyisigwa ukutule anga mumanyisi wake, numutugwa kutula anga mukulu wakwe. Ang'wi akumitanga umukola nyumba Beelzebuli, aigwa singa akilinkie ao niakoli munyumba akwe! ");
INSERT INTO isn_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Kululo leki kuogopi, kunsoko kutile ulukani nishaliziza kunukulwa, hangi kutile nulipihile nishalumanyikile. ");
INSERT INTO isn_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Iki nikumuila mukiti, mukiligitye muwelu, niki numukigulu kuauza muakutwe anyu, mukitanantye muzemkole migulya na nyumba. ");
INSERT INTO isn_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Leki kuogopi ao nibulaga umuili inkolo amileke mpanga, ingigwa ogopi uyu nukubulaga umuili ninkolo amutwale kuulungu. ");
INSERT INTO isn_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ia kasuku abiili shaiguligwa nee na mpia ninino? Kululo gwa kutile nuhumile kugwa pihi utata wanyu ahite kulinga. ");
INSERT INTO isn_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ingi gwa nimasingi a matwe anyu aaligwa. ");
INSERT INTO isn_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Leki kutuli nuwoa kunsoko musanigwe kukila iakasuku nidu. ");
INSERT INTO isn_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Kululo gwa uyu nukungomba ntongeele aantu nunene nzinzamugomba pantongeela ang'wa tata ane nukuli kuilunde. ");
INSERT INTO isn_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Uyu nukunihita paantu nunene nzemuhita pang'wa Tata witu nuakingulu. ");
INSERT INTO isn_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Leki kulungi aindetile ulowa mihi, unene aindetile mbita. ");
INSERT INTO isn_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ainzile kumuika muntu ikue nu Tata wakwe, umunanso nu nyinya, umukwinu nyinyi akwe. ");
INSERT INTO isn_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ianyaulugu amuntu akutula wawania nia mitalakwe. ");
INSERT INTO isn_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Uyu numuloilwe utata ang'wi uia akwe kukila ne nuanso shutakiwe nuyu numuloilwe umuhumba ang'wi munanso kukila une nuanso shutakiwe. ");
INSERT INTO isn_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Uyu nisinga ukukenka ikota la upanga nukuntyata shukuona utemi wa kigulu. ");
INSERT INTO isn_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Uyu nuiduma upanga wa mihi ukulimilye, kululo uyu nuilimilya uupanga kunsoko ane wipantika. ");
INSERT INTO isn_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Uyu nukumusingilya wansingiilya nene, nuyu nukunsingiilya unene wamusingiilya uyu nauntumile unene. ");
INSERT INTO isn_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nuyu nukumusingiilya uyu nua tai kunsoko muntu wa tai ukupegwa uuza wa muntu nua tai. ");
INSERT INTO isn_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Wihi nukumupa ung'wi wa anino awa, ikikombe kakung'wela imazi nimaliuku, kunsoko nuanso mumanyisigwa, tai kumuila, nuanso shukuulya kunzila yihi uuza wakwe.” ");
INSERT INTO isn_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","U Yesu naiwakondya kualagiila iamanyisigwa akwe ikumi naabili akahega akalongola kumanyisa nukutanantya muisali yao. ");
INSERT INTO isn_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nu Yohana akazukoli kukitungo naiwija intendo yang'wa Kilisto, aulaagilyo ulukani kukiila amanyisigwa akwe, ");
INSERT INTO isn_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","hangi ikamukolya, “Uwe yuyu ne nupembilye, ang'wi mungiza nikumulindie?” ");
INSERT INTO isn_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","U Yesu akalunga, longoli mumuile u Yohana ayo nimumaine nayo nimuwigule. ");
INSERT INTO isn_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Iantu niapoku akuona, akitele akugenda, anyambili akogigwa, agulu akija, niakule akuukigwa kutula apanga hangi, niantu niakite insula akutanantiligwa ulukani nuluza. ");
INSERT INTO isn_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Hangi akembetwe uyu nunihuie unene. ");
INSERT INTO isn_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Itungo naiahega iantu awa, u Yesu akandya kuligitya numilundo kunsoko ang'wa Yohana, aimendile ona ntuni mumbuga- muntu nutugae mienda nimiza? Ang'wi ifa nilikuhingisigwa nung'wega? ");
INSERT INTO isn_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ite ntuni naimendile ona-muntu nautugae imyanda nimiza? Ingi tai ao niitugala imyenda nimiza ikue munyumba ya temi. ");
INSERT INTO isn_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ite amulongoe kugoza ntuni-Munyakidagu? Ee, humuila. Hangi ukilinkie umunyakidagu. ");
INSERT INTO isn_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Uyu yuyo nailindiwe, Goza, kumulagiilya umumboi wane kuntongeela auso wako, uyu nukunonelya inzila pantongeela ako. ");
INSERT INTO isn_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Une kumuila itai, awa nialugilwe niasungu kutile numukulu kukila u Yohana Mbatizaji, kululo uyu nimunino ukutula mukulu muutemi wa kigulu kukila nuanso. ");
INSERT INTO isn_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Puma imahiku ang'wa Yohana Mbatizaji sunga nitungile, utemi wa kigulu wa ngulu, niantu nia ngulu ihola kua ngulu. ");
INSERT INTO isn_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kunsoko ianyakidagu niaziipilya ankani niazitambula kupika kung'wa Yohana. ");
INSERT INTO isn_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ang'wi wihambile gomba uyu Eliya, naulindiwe. ");
INSERT INTO isn_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nukite iakutwe akija ukija. ");
INSERT INTO isn_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Nuipyane nintuni uwileli uwu? Ingi pyani ang'enya niakiginsa kiguilyo la maintu, niike nukiitanga, ");
INSERT INTO isn_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","nu kuligitya akumukuila ikali shamakiginsa, aikuhongeelya shamukalila. ");
INSERT INTO isn_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kunsoko u Yohana nauzile singa akalya umukate, singa akang'wa umuvinyo, ukamuila ukete amintunga. ");
INSERT INTO isn_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ung'wana wang'wa Adamu auzile kulya nukung'wa ikalunga, goza ingi mulii hangi mugala ntuli, muhumba muya wa ahoela mpia na niakite imilandu, ingi uhugu nintendo yigeeleka niakue.” ");
INSERT INTO isn_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","U Yesu akandya kuikenela isali izo ni ntendo yaukuilwa naiyitumilwe, kunsoko akili kuleka imilandu (kila itunu). ");
INSERT INTO isn_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ukia ako, Kolazini, ukia ako Bethsaida! Angi intendo ninkulu aizeyatendekile Tiro ni Sidoni, aya naitumilwe apa, azize alekile imilandu kali kutugala imagunila nukipaka imau. ");
INSERT INTO isn_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Izetula ugimya i Tiro ni Sidoni imahiku naulamulwa kukila kilalao. ");
INSERT INTO isn_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Uewe Kapernaumu, usigile uzeukigwa mpaka kigulu? Ata uzesimigwa mpaka kuulungu. Anga ize intendo ninkulu aizeyilumilwe ku Sodoma, anga naiyitendekile kitalako, aizeikole sunga ni lelo. ");
INSERT INTO isn_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ingi izetula bahu ihi a Sodoma kimika uluhiko la ulamulwa kukila uewe. ");
INSERT INTO isn_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Imatungo nanso u Yesu akalunga nakulumbilya uwe Tata, Mukulu wa kilunde ni ihi, kunsoko aupihile inkani awa nia hugu nawa niamahala, uka kunukula kuantu nishaaine anga kintu anga ang'enya nianino. ");
INSERT INTO isn_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tata kunsoko aikuloeye uu mumiho ako. ");
INSERT INTO isn_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Maintu ihi mambigwe nene kupuma kung'wa Tata. Hangi kutile numulingile ung'wana ingi. U tata du. Hangi kutile numulingile utata ingi ung'wana, nuyu wihi nung'wana ukite insula akukunukuilwa. ");
INSERT INTO isn_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nzi kitalane mihi nimulemeigwe nimiligo nimilito, une nze musupya. ");
INSERT INTO isn_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tugali uhuili ane, mimanyise kitalane, kunsoko unene ingi nimuntu wa ukenge nuupolo wa nkolo hangi mkupantika uusupilyo wa nkolo yanyu. ");
INSERT INTO isn_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kunsoko nakitalane maza ni miligo ane mipepele. ");
INSERT INTO isn_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Matungo nanso ailuhiku la Sabato u Yesu akakiila mumigunda. Ia manyisigwa akwe aiatite nzala akandya kubunanga uilo nukulya. ");
INSERT INTO isn_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Iafarisayo naiaona nanso ikamuila u Yesu goza iamanyisigwa ako akituma imilimo iyi nisinga itung'wa uluhiku nula Sabato.” ");
INSERT INTO isn_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","U Yesu akaaila magemile ni kuona, u Daudi naiwitumile, matungo naukete inzala, palung'wi niantu naine. ");
INSERT INTO isn_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Naiwingie munyumba ang'wi Tunda nukulya, imikate iyo nisinga augombigwe palung'wi niantu naine. Kulya nanso aiagombigwe kulya iakuhani du? ");
INSERT INTO isn_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Iza mukili ne kuona muuziipilya wa nkani uluhiku la Sabato, iadimi mitekeelo ituma ubi, musabato, kululo shaiiailigwa kina itumile ubi? ");
INSERT INTO isn_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kululo kulunga kitalanyu kina uyu nu mukulu kukila itekeelo ukoli hapa. ");
INSERT INTO isn_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Angamuze uulingile iko nikukiligitya kintuni, ndoilwe ulekelwa singa isongeelyo. Singa aimuzeakenkya iantu ulamulwa, ");
INSERT INTO isn_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kunsoko ung'wana wang'wa Adamu yuyo Mukulu wa Sabato.” ");
INSERT INTO isn_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Sunga u Yesu akahega pang'wanso akalongola mitekeelo lao. ");
INSERT INTO isn_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Goza aukoli muntu amulwae wigandi la mukono, ia Farisayo ikamukolya u Yesu ikalunga. Iza tai ne kuaguna iantu uluhiku la Sabato? Kunsoko ahume kumsemela nukituma imilandu. ");
INSERT INTO isn_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","U Yesu akaila nyenyu kitalanyu nuhumile kuhita kumipumya mikombo inko nigwie uluhiku la Sabato. ");
INSERT INTO isn_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nikiule nikiza nikikilinkie, kukila inkolo! kululo igombigwe kituma nimaza uluhiku la Sabato. ");
INSERT INTO isn_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Sunga u Yesu akamuila umuntu nuanso, goola umukono nuanso, akaugoola ukakomya anga uuya. ");
INSERT INTO isn_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kululo ia Farisayo ikapuma kunzi ahume kunonya nzila ya kumulimansilya, akenda kunzi akatula duma nzila akumubulaga ule. ");
INSERT INTO isn_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","U Yesu naiwalinga ili akahega pang'wanso. Antu idu ikamutyata, hangi akaaguna idu. ");
INSERT INTO isn_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Akaaligiilya kina singa ntakile manyike kuantu nia ngiza. ");
INSERT INTO isn_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kina ikondaniligwe itai iyo nailigitigwe nu munyakidagu u Isaya akalunga, ");
INSERT INTO isn_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Goza umitumi wane nainumuholanilye, mlowa wane kukiila ng'wenso. Inkolo ane iloeigwe kuika inkolo ane kitalakwe, hangi ukutanantya ulamulwa kuantu ihi mihi. ");
INSERT INTO isn_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Shukusiga hangi singa ukupumya ululi lakwe, hangi tile umuntu nukija ululi lakwe munzila. ");
INSERT INTO isn_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Shukubunanga ulumuli, shukulimisa ulutambi nuipumya ilyuki sunga nuzeleta ulamulwa uhume. ");
INSERT INTO isn_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nao nishaizaahuie azetula agimya kukiila lina lakwe. ");
INSERT INTO isn_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Aukole muntu ai mupoku kuna aze kimume, aiwingiwe nu mintunga akatwala pantongeela ang'wa Yesu. Akamuguna, sunga umuntu nuanso akaligitya nukuona. ");
INSERT INTO isn_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Umilundo wihi ukakuilwa, nukulunga, “Ihumikile umuntu yu ng'wana wang'wa Daudi?” ");
INSERT INTO isn_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ingi gwa ia Farisayo naiija uukuilwa uwu, akalunga uyu shukenda azunsa iamintunga na ngulu yakwe, weenda azunsa kukiila mkulu wa amintunga. ");
INSERT INTO isn_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","U Yesu akalinga imasigo ao akaaila utemi nuutemanukile, wigazika, ni kisali ang'wi nyumba nitemanukile singa imika. ");
INSERT INTO isn_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ang'wi umubi ukumuheja umubi, ingi ukigilya ung'wenso munkolo akwe. ");
INSERT INTO isn_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ukimika ule utemi wakwe? Ang'wi nizunsa iamintunga kungulu ya mkulu wa amintunga, aiantu anyu iazunsa kungulu yang'wa nyenyu? Kunsoko aili azetula alamuli anyu. ");
INSERT INTO isn_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ang'wi kuzunsa iamintunga kungulu yang'wa ng'waung'welu wang'wi Tunda, ingi gwa utemi wang'wi Tunda wazaa kitalanyu. ");
INSERT INTO isn_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","U muntu uhumile ule kingila mito la munyangulu nukia, ahite kumtunga hanza umunyangulu? Pang'wanso ukuhuma kia gwa imiantu nakule mung'wanso. ");
INSERT INTO isn_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Uyu nisingaiza kigombiliye singaizukoli palung'wi nunene, nuyu nishawilingiila palung'wi nunene wisambailya. ");
INSERT INTO isn_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kululo kulunga iti kitalanyu, milandu nuimeli iantu azizalekilwa imilandu, ingi gwa kumumela ung'waung'welu shuzizalekelwa imilandu. ");
INSERT INTO isn_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Muntu wihi nuipiula ukani la ng'wana wang'wa Adamu, wilekilwa imilandu ingi gwa uyu nuipiula inkani ya ng'waung'welu nuanso shawilekelwa imilandu, muunkumbigulu uwu nuo nuuzile. ");
INSERT INTO isn_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ang'wi unonye umuti kutula uza nindya yakwe nza, ang'wi uugazanje umuti nuludya lakwe, kunsoko umuti wimanyika kulu dya lakwe. ");
INSERT INTO isn_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Unye wileli wa nzoka miabi, muhumile uli kuligitya inkani ninza? Kunsoko ikimilo kimaligitya ayo nakoli munkolo. ");
INSERT INTO isn_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Umuntu numuza nikiuto nikiza nikankolo akwe kipumya nimaza, numuntu numubi mukiuto nikibi nikankolo akwe, kipumya nikibi. ");
INSERT INTO isn_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Kumuila kina uluhiku la ulamulwa iantu azepumya intendo yao izo naiituma nisingaaiza nziza. ");
INSERT INTO isn_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kua nkani yako uzeailigwa tai, hangi kuankani yako uzepegwa ulamulwa wako.” ");
INSERT INTO isn_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Iaika nkani ni Mafarisayo, akamuila u Yesu akalunga “Mumanyisi azakuloilwe kuona kilingasilyo kitalako” ");
INSERT INTO isn_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ingi gwa u Yesu akasusha akaila, “Wileli nuabi nuausambo kikuduma kilingasiilyo. Kutile ikilingasiilyo nikikupumigwa kitalao, ingi kiki naikipumiigwe nu munyakidagu u Yona. ");
INSERT INTO isn_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Anga umunyakidagu u Yona naukole munda ansamaki mahiku atatu utiku nu mung'wi. Kuiti uu ung'wana wang'wa Adamu uzize ukole mukati ihi mahiku atatu mung'wi nuutiku. ");
INSERT INTO isn_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Antu a Ninawi akimika pantongeela aulamulwa palung'wi nu wileli wa antu awa apegwe ulamulwa wao. Kunsoko aialekile imilandu pautananti wang'wa Yona. Goza ukole muntu mukulu kukila u Yona apa. ");
INSERT INTO isn_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Musungu wa mutemi nuakutakama ukuuka muulamulwa palung'wi niantu awileli uwu, nukukipa ulamulwa. Auzile kupuma mumpele ihi kuza kija uhugu wang'wa Selemani, hangi goza ukole muntu mukulu kukila Selemani ukoli apa. ");
INSERT INTO isn_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Matungo numintunga numubi nuimlekela umuntu, wikiila pana kutile imazi, wizeduma kusupya shawipaona. ");
INSERT INTO isn_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Sunga wilunga kusuka munyumba ane nazampumie, nusukile wihanga inyumba akondaniligwa kupyagulwa. ");
INSERT INTO isn_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Sunga wilongola kuityata nkolo ngiza mpungate nimbi kukila nuanso, yize yikie yihi apo. Hangi witula mubi kukukila nuang'wandyo. Ite uu uzetula muwileli uwu nubi. ");
INSERT INTO isn_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Matungo u Yesu naukuligitya numilundo, goza, unyinya nianyandugu akwe akimika kunzi, akazeduma kuligitya nung'wenso. ");
INSERT INTO isn_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Muntu ung'wi akamuila, uyiaaka nialuna ake imikile kunzi, akaduma kuligitya nuewe.” ");
INSERT INTO isn_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","U Yesu akamuila umuntu nuanso uiane nyenyu? Nialuna ane anyenyu? ");
INSERT INTO isn_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Akagoda umukono wakwe kuamanyisigwa akwe akalunga, goza awa ingi lane nianya ndugu ane! ");
INSERT INTO isn_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kunsoko wihi nuituma ulowa wang'wa Tata ane nuakigulu, nuanso yuyo munyandugu ane ng'waitu nu iane.” ");
INSERT INTO isn_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Uluhiku nulanso u Yesu akahega kitalakwe akikie pampelo a luzi. ");
INSERT INTO isn_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Milundo ukulu ukilingiila kuligitya nung'wenso, akingila mibini akikie, milundo wihi ukimika pa mpelo a luzi. ");
INSERT INTO isn_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Sunga u Yesu akaligitya kwa mpyani, Goza, mutemeli aiwendile temela. ");
INSERT INTO isn_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Naukutemela imbeu ing'wi ikagwa mumpelo mpelo anzila inyunyi ikahoela. ");
INSERT INTO isn_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ning'wi ikagwa migwe, singaikapata imahalu. Ikakaya kuheluka kunsoko mahalu aimakehu. ");
INSERT INTO isn_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ingigwa ilyoa nailatoroka ikasonswa nsoko aingila nga mili hangi ikuma. ");
INSERT INTO isn_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Imbeu ing'wi ikagwa mumija. Imiti nikite imiija ikalipa migula ikatunyiilya. ");
INSERT INTO isn_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mbeu ing'wi ikagwa mumahalu ni maza, ikatuga mbeu, ning'wi ikakila igana ling'wi, ning'wi makumi mutandatu, ning'wi makumi atatu. ");
INSERT INTO isn_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nukete iakutwi ije. ");
INSERT INTO isn_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Iamanyisigwa akwe akaza akamukolya niki nukendaligitya kukiila mpyani? ");
INSERT INTO isn_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","U Yesu akasukiilya akaila, lumbi nimpewe kulinga inkunku wa kigulu ianyu singa apewe. ");
INSERT INTO isn_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kululo uyu nutite ukangeeligwa hangi uyu numugila ukuhegeligwa kaniki nazutite. ");
INSERT INTO isn_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ingi kuligitya nienso kua mpyani ingi nsoko akuona, aleke kuona itai, ataizeazija aleke kija nukulinga. ");
INSERT INTO isn_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Uunyakidagu wang'wa Isaya wakondanila kitalao, nuuliye kija mukija singamkulinga kugoza mukugoza shamukuona. ");
INSERT INTO isn_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Inkolo ya antu awa ikoli mukiti, ikakukija, imiho ao akunikiwe, aleke kuona na miho ao, nukija kua kutwe ao, nukulinga kwa nkolo yao, kululo anga aiampilukile hangi anzeaguna.” ");
INSERT INTO isn_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Kululo gwa imiho anyu akembetilwe, nsoko akuona, niakutwe anyu akija. ");
INSERT INTO isn_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tai kumuila, anyakidagu idu niaantu niatai akete insula akuona inkani izi nimukuiona, shaikahuma kuona, ailoilwe kija aya nimendija shaikija. ");
INSERT INTO isn_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ingi tegeeli impyani amutemeli. ");
INSERT INTO isn_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Uyu nuija ulukani nulautemi wa kigulu ahite kulinga, hapo umubi wiza hola iko nikitemiwe munkolo akwe. Iye yiyi mbeu nitemewe munzila. ");
INSERT INTO isn_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Uyu nutemewe migwe yuyu nuikaya kija nukusingiilya kua ulowa. ");
INSERT INTO isn_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Iza akili mugila anga mili, wigimya matungo makehu. Anga hangwe ni nkani ni nkaku wikaya kugwa. ");
INSERT INTO isn_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Uyu nautemewe mumiti na mija yuyu nuwija ulukani, kunu akazutyatile makani umunkumbigulu akalutunyiilya ulukani lang'wi Tunda lakahita kuluga indya ninza. ");
INSERT INTO isn_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nautemewe mumahalu nimaza, yuyu nuija ulukani nukulija, nukululinga. Uyu yuyu nuituga indya, nukulongoleka kutuga kukila igana ling'wi ning'wi makumi atatu.” ");
INSERT INTO isn_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","U Yesu akaapa mpyani ngiza. Akalunga, utemi wa kigulu wimpyanigwe numuntu nautemee imbeu mumugunda wakwe. ");
INSERT INTO isn_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Iantu naiatindila umulugu akaza akatemela iapungu pakati a ngano sunga akalongola yakwe. ");
INSERT INTO isn_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ingano nakonda kupuma nukupumya indya yakwe, nia pungu akigela hangi. ");
INSERT INTO isn_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Itumi amumugunda akaza akamukolya shautemee ne imbeu ni nza mumugunda wako? Latula ule gwa likite apungu? ");
INSERT INTO isn_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Akaila mulugu witumile iti. Eitumi ikamuila iti gwa utakila kende kumipe? ");
INSERT INTO isn_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Umukola mugunda angalunge, aa imatungo nimukipa iapungu mukipa palung'wi ni ngano. ");
INSERT INTO isn_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Maleki akule palung'wi sunga imatungo akuogola kuligitya kuagoli ipi iapungu mutunge mapanzi mapunzi mumasonse ingano milingiile misalanka lane.” ");
INSERT INTO isn_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Hangi u Yesu akaapumilya mpyani ngiza akalunga, utemi wa kigulu wimpyani ni mbeu a haladali iyi nu muntu auhoile akatemela mumugunda wakwe. ");
INSERT INTO isn_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Imbeu iyi tai niino kukila mbeu yihi ninino. Kululo ilungile ikulu kukila indya yihi niambustani, ukutula mti, kina ni nyuni iziza tula zenga niitie mumatambi akwe.” ");
INSERT INTO isn_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Akaaila mpyani ngiza hangi, “Utemi wa kigulu anga igai naihoilwe numusungu nukuhalinkanya ininoinino itatu nia utu mpaka witikiilye. ");
INSERT INTO isn_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Aya hii u Yesu akauila umilundo kukiila mpyani, inkani yihi aiwiiligitya kukiila mpyani. ");
INSERT INTO isn_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Iki aitule kina iko naikakondigwe kuligitigwa kukiila anyakidagu kihuma kipika apo naulungile kulugula ikimilo kane kwa mpyani, kuligitya ihi ayo napikilwe kupuma ung'wando wa unkumbigulu.” ");
INSERT INTO isn_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Sunga u Yesu akauleka umilundo akalongola kitalakwe. Iamanyisigwa akue akamutyata akalunga, kutemanuilye impyani iyi naapungu mumugunda.” ");
INSERT INTO isn_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","U Yesu akasisha akalunga, Nuitemela imbeu ninza ingi ng'wana wang'wa Adamu. ");
INSERT INTO isn_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Umugunda unkumbigulu, ni mbeu ninza awa ana autemi. Iapungu ana ang'wa uyo numubi, nimbeu izi nuitemee mulugu. ");
INSERT INTO isn_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nuogoli mpelu aunkumbigulu niaogoli ia malaika. ");
INSERT INTO isn_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Anga iapungu niilingiilwa nukusonswa umoto. Iti uu izitula mpelu aunkumbigulu. ");
INSERT INTO isn_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ung'wana wang'wa Adamu ukualagiilya iamalaika akwe, hangi ukilingiila kupuma muutemi wakwe ni nkani yihi nailetekeye imilandu nawa ihi niituma uubi. ");
INSERT INTO isn_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Akuaguma ihi milungu la moto, kung'wanso kizeze kikoli kililo nikakusia na mino. ");
INSERT INTO isn_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pang'wanso iantu niatai azizemili ginta anga ilyoa muutemi wang'wa tata wao. Uyu nukete iakutwe nije. ");
INSERT INTO isn_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Uutemi wa kigulu wa hanga anga ikiuto nikipihilwe mumugunda. Umuntu akaona akakipiha mulumbili wakwe akalongola kugulya ihi nautite akaugule umugunda. ");
INSERT INTO isn_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Hangi uutemi wa kigulu wihanga anga umuntu numusuluja nuipenza insao. ");
INSERT INTO isn_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Matungo naiwamiona insao, akalongola akagulya ihi nautite, akamigula. ");
INSERT INTO isn_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Uutemi wa kigulu wili anga inyavu nikoli muluzi, ni liingiila kila ikintu. ");
INSERT INTO isn_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Naizula inyavu ikamuluta kumpelo. Sunga akikie pihi akiliingila imaintu nimaza muiseme, nishanganzinza ikagungwa kuli. ");
INSERT INTO isn_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Izizatula iti kumpolo ihi, aziza kumutemanula muantu niabi, kupuma muantu nia tai. ");
INSERT INTO isn_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nukuaguma milungu la moto, kung'wanso izize ukoli uhungeelya wa kusiana mino. ");
INSERT INTO isn_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Malinga ne aya ihi? Iamanyisigwa ikalunga “Kalinga.” ");
INSERT INTO isn_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Sunga u Yesu akaila, muika nkani wihi nuatula mumanyisigwa wa utemi wimpyani numukolo nyumba nuipumya ikiuto kwakwe nikamaintu ni nimapya naya nakali. ");
INSERT INTO isn_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ikatula u Yesu naiwakondya kupumya impyani yihi, akahega kung'wanso. ");
INSERT INTO isn_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Sunga u Yesu akapika mukisali kakwe, akutula amanyisa iantu mumatekeelo, ingi gwa ikakuilwa ikalunga, umuntu yu auhoe pi u hugu wuu nukuilwa uwu? ");
INSERT INTO isn_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Umuntu singa ng'wana wang'wa mutamula mbao? U Mariamu singa nyinya? Nianyandugu singa Yakobo, Yusufu, Simoni nu Yuda? ");
INSERT INTO isn_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nialuna akwe kuwatite apa pitaitu? Umuntu uyu umahoeepi aya hii? ");
INSERT INTO isn_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Akaatasha sunga u Yesu akaila, umunyakidagu shanga wiulya ikulyo kuleka kitalao nukihi nao. ");
INSERT INTO isn_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Singa akahuma kituma ukuuilwa nuidu kunsoko aiagila anga uhuili nung'wenso. ");
INSERT INTO isn_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kumatungo nanso Herode akija ulukumo lang'wa Yesu. ");
INSERT INTO isn_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Akaila eitumi akwe, “Uyu yuyu Yohana uhimbukile kupuma kuashi. Kululo ingulu izi ikole kitalakwe.” ");
INSERT INTO isn_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kunsoko u Herode amuambile Yohana akamtunga akamuguma kukitungo nsoko ang'wa Herodia, musungu wang'wa Filipo nuluna wakwe. ");
INSERT INTO isn_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kunsoko Yohana, amuie sunga tai nuanso kumuhola atule musungu wake. ");
INSERT INTO isn_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herode auze mubulaga akogopa antu kunsoko aumuine Yohana kina munyakidagu. ");
INSERT INTO isn_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ingi gwa uluhiku lakutugwa Herode nailapika umunanso wa Herodia aiwiginsile muantu akamuloilya i Herode. ");
INSERT INTO isn_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Akapumya ilago akamuila ukumupa kihi nukulilompa kung'wakwe. ");
INSERT INTO isn_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Naiwasigigwa nunyinya, akalunga kulompa itwe lang'wa Yohana mbatizaji.” ");
INSERT INTO isn_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Umtemi akatula nimasiko makulu na malompi ang'wa munanso, nsoko ilago lakwe la aantu naiakoli palung'wi pandya, akaila leki itulike uu. ");
INSERT INTO isn_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Akaaligity u Yohana aletwe kupuma kukitungo ");
INSERT INTO isn_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","itwe lakwe likaletwa mukiseme umunanso akatwala kung'wa nyinya. ");
INSERT INTO isn_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Sunga amanyisigwa akwe akaza akauhola umuimba akautulila naamala akenda akamuila u Yesu. ");
INSERT INTO isn_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","U Yesu naiwija nanso akalongola kuna antu kutili. Ni lundo la antu nailija likamutyata na migulu kukisali naukoli. ");
INSERT INTO isn_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Sunga u Yesu akaza akauona ulundo ukulu. Akahumila kinyauwai akakomya indwala naiyiaja. ");
INSERT INTO isn_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Naapika impindi iamanyisigwa akaza akalunga, iyi mbuga, uluhiku iahila. Asambailye aantu ende musali yao ende agule indya kunsoko ao. ");
INSERT INTO isn_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","U Yesu akaaila, “agila anga nsula akuhega api indya alye” ");
INSERT INTO isn_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Akamuila ingi kukite mikate itaano ni nsamaki ibiili du. ");
INSERT INTO isn_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","U Yesu akalunga, “Mileti kitalane.” ");
INSERT INTO isn_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Sunga u Yesu akaupa ilago umilundo pihi mumala. Akahola mikate itaano ni nsamaki ibiili akagoza kigulu, akakembeta, akaige imikate akaapa iamanyisigwa. Iamanyisigwa akaugalanya umilundo. ");
INSERT INTO isn_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Akalya ihi akikuta sunga ikahoela indya yihi ikizulya imbugulu ikumi na ibiili. ");
INSERT INTO isn_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ao naialia asigiiwe kuhugela magana nzogu ataano iasungu nia ng'enya ikutile mialo nilanso. ");
INSERT INTO isn_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Itungo akaapi ilago iamanyisigwa ingile mibini, matungo nanso akilaga nimilundo. ");
INSERT INTO isn_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Naiilaga numilundo, akalongola mulugulu kulompa akaziwing'wene. Ai matungo ampindi akaziukoli wing'wene. ");
INSERT INTO isn_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ingi gwa ibini alikoli pakati aluzi likazikenkwa ni maingo kunsoko ung'wega aiukulu. ");
INSERT INTO isn_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Matungo nautiku wa kupitilya kane u Yesu akaahugeela, akaze igenda mumazi. ");
INSERT INTO isn_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Iamanyisigwa akwe naamuona ugenda mumazi. Ikogopa ikalunga, uyu mintunga ikazogolya kunsoko awoa. ");
INSERT INTO isn_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","U Yesu akaaila tuli nu moyo leki kogopi ingi nene.” ");
INSERT INTO isn_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petro akasusha akalunga, Mukulu ang'wi wewe mpi lago ngendi mumazi nze kitalako. ");
INSERT INTO isn_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","U Yesu akalunga, “Nzuu” Kululo u Petro akahega mibini akagenda mumazi akalongola kuna Yesu aukoli. ");
INSERT INTO isn_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","U Petro naiwaona imaingo, akogopa, akatula nyeheela mumazi, akitanga akalunga, Mukulu ngune!” ");
INSERT INTO isn_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Itungo u Yesu akagoola umukono akamuhumbula u Petro akamuula, iwe nukite uhuili unino, niki nazawogopile? ");
INSERT INTO isn_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kululo u Yesu nu Petro naingila mibini ung'wega ukahila. ");
INSERT INTO isn_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Iamanyisigwa naiakoli mibini ikamukulya u Yesu akilanga, “Tai uewe wi ng'wana wang'wi Tunda.” ");
INSERT INTO isn_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Naikondya kuputa uluzi. Akapika mihi na Genesareti. ");
INSERT INTO isn_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Iantu naiakondya kumumanya u Yesu akatwala inkani muisali, ikaaleta ihi nailwae. ");
INSERT INTO isn_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Akaminena ahume kuomba inguo akue, ihi naiambile inguo ikagunwa. ");
INSERT INTO isn_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ingi Mafarisayo niaka nkani akiza kung'wa Yesu kupuma ku Yerusalemu ikalunga, ");
INSERT INTO isn_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Ku niki iamanyisigwa niakugazanja imalago anyampala? Kunsoko shaikalala imikona nikulya indya. ");
INSERT INTO isn_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","U Yesu akasusha akaaila, “Au nye kuniki nimukugazanja uzipiilya nuamkulu kunsoko amalagiilyo anyu? ");
INSERT INTO isn_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kunsoko Itunda auliye, mkulye itata ako nuia ako; uyu nuiligitya ubii kung'wa tata akwe nuia kwe, tai ikusha. ");
INSERT INTO isn_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ingi gwa unye mihunga wihi nuimuila utata akwe nuia akwe wihi uailigwa nauzepata kupuma kung'wane ingi likutula isongeelyo kupuma kung'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Umuntu nuanso mugila anga nsoko nakumukulya utata akwe. Kuiti malupugamukila ulukani lang'wi Tunda kunsoko amalagiilyo anyu. ");
INSERT INTO isn_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Unye ni mielya, ikutula iza anga u Isaya nauine kitalanyu akalunga. ");
INSERT INTO isn_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Antu awaiti indankula unene na milomo ao, ingi inkolo yao ikoli kuli nu nene. ");
INSERT INTO isn_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Akunkulya nakanda, kunsoko akinda manyisigwa malagiilyo aantu.” ");
INSERT INTO isn_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Akaitanga umilundo nuantu akauila.” tegeeli hangi mulinge, ");
INSERT INTO isn_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","iki nukingila mumulomo wa muntu singa iza kibi, iko nikipuma mumulomo kiko kintwala nikatula nimubi.” ");
INSERT INTO isn_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ingi iamanyisigwa ikamuhanga u Yesu ikamuila, uinene Mafarisayo naiiguli ulukani ulo abipiwe? ");
INSERT INTO isn_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","U Yesu akaila, muti wihi nu tata wane nuakigulu nishauutemee ukipwa. ");
INSERT INTO isn_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Aleki ing'wene, nianso atongeeli apoku, ang'wi umuntu numupoku ukumutongeela umuya, ihi abiili akugwila mikombo. ");
INSERT INTO isn_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","U Petro akasusha, akamuila u Yesu kuile impyani iyi ilungila ntuni kung'witu. ");
INSERT INTO isn_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","U Yesu akasusha, akaaila, nunyenye mukili ne kulinga? ");
INSERT INTO isn_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Unye shamuinene kina iki nikilongola mumulomo kukiila munda kenda niwa? ");
INSERT INTO isn_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ingi gwa maintu ihi nipuma mumulomo ipembelya munkolo, yaya umushapula umuntu. ");
INSERT INTO isn_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kululo gwa munkolo mumo ipuma masigo ni mabi, ubulagi, ugoolya, usambo, wii, ntambu au teele niituki. ");
INSERT INTO isn_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Aya yaya umupeza umuntu uubi. Ingi gwa kulya nisinga ukalae imikono singa ukutwalwa muubi.” ");
INSERT INTO isn_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Sunga u Yesu akikoma akahega akalongola muisali ya Tiro ni Sidoni. ");
INSERT INTO isn_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Akaza musungu Mkanani kupuma kuko, akitunta akalunga, “Nihumile kinyauwai. Mkulu ng'wana wang'wa Daudi, umunanso ane ukagigwa niamintunga.” ");
INSERT INTO isn_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","U Yesu singa akasusha anga lukani. Iamanyisigwa akwe akaza akamupepelya akazilunga. Muheje mutwale uko nsoko ukuzogoelya.” ");
INSERT INTO isn_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","U Yesu akaila akalunga, singa aintumi kunkolo izi nikole aintumilwe kunkolo nilimiie munyumba ang'wa Israeli.” ");
INSERT INTO isn_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ingi akaza kuntongeela akatuna, akalunga mukulu nzailye. ");
INSERT INTO isn_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Akasusha, akalunga singa iziza kuhola indya yang'wenya nukuigumila mbwa.” ");
INSERT INTO isn_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Akalunga ee mukulu, ingi ala mbwa ninino iliza indya nigwie mituntu ia mukulu ao. ");
INSERT INTO isn_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Sunga u Yesu akasusha akazilunga, musungu uhuili wako ukulu, utulike uu anganuloilwe, numunanso akwe aiwagunika imatungo yayo. ");
INSERT INTO isn_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","U Yesu akahega pang'wanso akalongola pakupe nuluzi nula Galilaya. Sunga akalongola mulugulu akikie kuko. ");
INSERT INTO isn_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Milundo ukulu ukaza kitalakwe, ukamletela akitele, apoku, akimumi, alema nia uya idu, naialwae, ikaika mumigulu ang'wa Yesu akaaguna. ");
INSERT INTO isn_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Umilundo ukakaulwa, ukimumi kuligitya akilema kutula apanga, akitela kugenda niapoku akazeona. Ikamulumbiilya Itunda wa Israeli. ");
INSERT INTO isn_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","U Yesu akaitanga iamanyisigwa akwe akalunga, nauhumila kinyauwai umilundo, kunsoko enda kine nene mahiku ataatu akili kulya kintu kihi. Singa kualanga ende kitalao singa aze alie. Aleki kugwa nanzala munzila.” ");
INSERT INTO isn_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Iamanyisigwa akwe akamuila, pi nikuhumile kupantika indya niakulya mumbuga kikute umilundo uwu nukulu iti? ");
INSERT INTO isn_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","U Yesu akaila mkite mikate inga? Akalonga mupungate, ni nsamaki ibiili ninino nkehu. ");
INSERT INTO isn_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","U Yesu akapumya ilago umilundo wikie pihi. ");
INSERT INTO isn_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Akahola mikate mupungate ni nsamaki akakembeta, akamiega akaapa iamanyisigwa. Iamanyisigwa ikaupa umilundo. ");
INSERT INTO isn_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Antu ihi ikalya akikuta akilingiila imaminyanguilwa andya akizulya mbugulu mupungati. ");
INSERT INTO isn_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ihi naialia ai itunja magana anzogu anne iasungu nia ng'enya aikutile. ");
INSERT INTO isn_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Sunga u Yesu akaulaga umilundo ukalongola yao, nuanso akingila mibini akalongola ku Magadani. ");
INSERT INTO isn_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mafarisayo ni Masadukayo ikamuhanga ukamugema u Yesu alagiile ikilingasiilyo nikakupuma kilunde. ");
INSERT INTO isn_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kululo u Yesu akasusha akaaila, ang'wi impindi mukulunga singa iziza, kunsoko likoli ilunde ikauku. ");
INSERT INTO isn_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ni kidaudau mukulunga ung'wega ileliye shanga uziza, migulya imalunde makauku du, kugoza ilingasilyo niamatungo shamumanyile. ");
INSERT INTO isn_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Wileli nuubi hangi nika ugoolya kikuduma kilingasiilyo, kutili kilingasilyo kihi nikikupegwa, iko iti du ni kang'wa Yona. Sunga u Yesu akaaleka akalongola. ");
INSERT INTO isn_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","I a manyingwa akiza inkigi akaabiia, akatula iwa shangaahoile imikate. ");
INSERT INTO isn_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","U Yesu akaaila, tuli miho nuteele wa Mafarisayo nia Masadukayo.” ");
INSERT INTO isn_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Iamanyisigwa akatulikolyo ienso nukulunga. Kunsoko shaaza kuhoile imikate. ");
INSERT INTO isn_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","U Yesu alilinga nilanso akaaila, unye nimukite uhuili nunino, niki nimasigo nukikolya unyenye, nukuhunga kina kunsoko shaaza muhoile imikate? ");
INSERT INTO isn_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Shamulingile ne hangi shamukimbukile imikate iyo mintaano kuantumagana anzogu muntaano, ni mbugulu inga naimuhoee? ");
INSERT INTO isn_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ang'wi mikate mupungate kuantu magana anzogu anne, ni mbugulu inga naimuhoile? ");
INSERT INTO isn_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Yatulika uli kina shamulingile kina singa aikuligitya nunye kunsoko amikate? Igozi nuteele wa Mafarisayo ni Masadukayo. ");
INSERT INTO isn_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Sunga ikalinga kina singa aukuaila ikie miho nimikate iyi nauteele, kina ihambe nuuteele wa Mafarisayo ni Masadukayo. ");
INSERT INTO isn_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Matungo u Yesu naiwapika ku Kaisaria iyi na Filipi, akakolya lamanyisigwa akwe akazelunga antu akulunga ung'wana muntu iza nyenyu? ");
INSERT INTO isn_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ikalunga, niang'wi ilunga uyu Yohana Mbatizaji, niang'wi Eliya, niangiza Yeremia, niang'wi ang'wi anyakidagu. ");
INSERT INTO isn_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Akaila unye milunga une ninyenyu? ");
INSERT INTO isn_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoni Petro akasusha, akalunga, “Ue ingi wi Kilisto ng'wana wang'wi Tunda numupanga.” ");
INSERT INTO isn_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","U Yesu akasusha akamuila, Bahu uewe Simoni Bar Yona. Kunsoko isakami numuili shangaikakulagiilaili. Ingi utata ne du nuakigulu. ");
INSERT INTO isn_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nene kuila uewe Petro numigulya nigwe iliite ukulizenga itekeelo lane. Ni moma nakuulungu shakulilemya. ");
INSERT INTO isn_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kuupa iifungulo ya utemi wa kigulu, kihi nukukilugaila munkumbigulu, kikutula kalugailwa kigulu, hangi kihi iko nukukiluguila munkubigulu kikuluguilwa nukigulu.” ");
INSERT INTO isn_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Sunga u Yesu akaapa ilago iamanyisigwa aleke kumuila muntu wihi kina ng'wenso ai Kilisto. ");
INSERT INTO isn_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Sunga imatungo yayo u Yesu akandya kuaila iamanyisigwa kina itulikile alongole ku Yerusalemu, winzagigwa ni nkani yidu, mumikono aanyampala nia kulu amakuhani niaika nkani, kubulagwa nukuuka uluhiku lakatatu. ");
INSERT INTO isn_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Sunga Petro akamuhola kumpelo akamkenela, akalunga, ulukani ulu lutule kule nuewe, “Mukulu ili lileke kupumila kitalako. ");
INSERT INTO isn_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ingi gwa u Yesu akapiluka akamuila Petro, “Suka kitalane mulugu uewe weenda ngilya kitalane, kunsoko shangaukee ulukani lang'wi Tunda, endu kee zizi niantu du.” ");
INSERT INTO isn_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Sunga u Yesu akaila iamanyisigwa akwe ang'wi muntu wihi nuloilwe kuntyata iime ihi namunkumbigulu, ahole uhuili wakwe, sunga antyate. ");
INSERT INTO isn_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Uyu nuloilwe kuuguna upanga wa mihi ukulimilya, nuyu wihi kumalimilya kunsoko ane ukamaguna. ");
INSERT INTO isn_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ukupata nsao ki umuntu aga amipate ihi hi kunu alimilye upanga wake? Kintu kii nukuila nuupanga wakwe? ");
INSERT INTO isn_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kululo ung'wana wang'wa Adamu uzile nuukulu wang'wa Tata akwe nia malaika akwe, ng'wenso uze apa ikinyamulimo iantu kukiila witumi wao. ");
INSERT INTO isn_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tai kumuila akoli apa ianyu niimikile singaaziza mionza insha sunga azizamuona ung'wa wang'wa Adamu nuzile muutemi wakwe. ");
INSERT INTO isn_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mahiku mutandatu u Yesu akahola palung'wi nung'wenso Prtro nu Yakobo, nu Yohana muluna wakwe, hangi akahola akaatwala migulya mlugulu nululepu. ");
INSERT INTO isn_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Au kaiwe pa ntongeela ao, uso wakwe ukamiliginta anga ilyoa, nu nguo yakwe ikigela ikazemiliginta anga uwelu. ");
INSERT INTO isn_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Pang'wanso ikapumila Musa nu Eliya akazeligitya nung'wenso. ");
INSERT INTO isn_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","U Petro akasusha akamuila u Yesu, Mukulu, ukutula iza ne usese kutula ang'we uloilwe kuizenga itali itatumking'wi kang'wa kako, king'wi kunsoko ang'wa Musa ni king'wi kunsoko ang'wa Eliya.” ");
INSERT INTO isn_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Itungo naakuligitya ilunde lyelu likaguma mululi, likapumula luli milunde lukazelunga, “Uyu ingi ng'wana mulowa nindoigwe, mtegeeli.” ");
INSERT INTO isn_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Iamanyisigwa akwe naiija nanso, akagwa undala pihi akogopa. ");
INSERT INTO isn_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Sunga u Yesu akaza akaamba, akalunga, uki hangi leki kogopi. ");
INSERT INTO isn_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nienso ikahumbula imiho ao migulya singa ikamuona anga muntu, ikamuona u Yesu du. ");
INSERT INTO isn_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Naikusima mulugulu u Yesu akaapa ilagilo, akalunga, “Muleki kupumya ukunukuilwa sunga nu ng'wana wang'wa Adamu nuzeuka kupuma kuashi.” ");
INSERT INTO isn_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Iamanyisigwa akwe akamukolya kuniki iakilisi akulunga u Eliya akutongela kiza atule wang'wandyo? ");
INSERT INTO isn_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","U Yesu akasusha akalunga, u Eliya uzile itai hangi ukususha inkani yihi. ");
INSERT INTO isn_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kululo numuie unye, u Eliya wahumile kiza, shaikamumanya, ikamulendeela inkani nialoilwe enso. Ni ite ung'wana wang'wa Adamu uzizagigwa mumikono ao. ");
INSERT INTO isn_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Sunga iamanyisigwa akwe ikalinga kina aukuligitya nkani ya Yohana Mbatizaji. ");
INSERT INTO isn_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Naapika mumilundo wa antu, muntu ung'wi akamuhanga, akatugama pantongeela akwe akamuila, ");
INSERT INTO isn_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Mukulu muhumile kinyauwai ung'waane, kunsoko izutite lyagu la kugwa nkolo, wiza aze gwa mumyongo nu mumazi. ");
INSERT INTO isn_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ai numuletile kuamanyisigwa ako singa ikamuguna. ");
INSERT INTO isn_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","U Yesu akasukiilya, akalunga, “Unye wileli nishauhuie hangi nikigazikile kikie nunye sunga nali?” Muleti apa ninkoli. ");
INSERT INTO isn_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","U Yesu akamupatya, nu mintunga akahega. Umuhumba akagunika imatungo yao. ");
INSERT INTO isn_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Sunga iamanyisigwa ikamuhanga u Yesu kinkunku ikamukolya, kuniki kahita kuhuma kumuzunsa umintunga? ");
INSERT INTO isn_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu akaaila kunsoko auhuili wanyu unino, tai numuie ang'wi mukutula nuhuili unino anga uluseke nula mbeu a haraali, muhumile kuila ulugulu hega apa ulongole uko, nuenso ukuhama kutili kintu kihi nikikulemeka kung'wanyu. ");
INSERT INTO isn_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ingi gwa impyani iyi naa mintunga shehuma kuhega, ihega kukiila malompi nukiima. (shayigee muilingasilyo ninza nia kali). ");
INSERT INTO isn_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Matungo naiakili akoli ku Galilaya u Yesu akaaila iamanyisigwa akwe, ung'wana wang'wa Adamu ukutula mumikono aantu. ");
INSERT INTO isn_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Hangi akumubulaga nu luhiku lakatatu ukuuka, iamanyisigwa ikahungwa kinyauwai. ");
INSERT INTO isn_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Naiapika ku Kapernaumu antu ahoela mpia nusu shekeli akamuhanga u Petro nukulunga, umumanyisi anyu wilipa ne inusu shekeli? ");
INSERT INTO isn_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Akalunga ee, u Petro nai wingila munyumba akwe, u Yesu akaligitya nu Petro akalunga, ukusiga ntuni Simoni? Iatemi amihi ihoela impia, angwi kung'wa nyeni? Ang'wi kuantu nizaa temile kupuma kuageni? ");
INSERT INTO isn_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Nu Petro nauliye, kupuma kuageni u Yesu akamuila kululo awa niakoli muutemi ahegigwe mulipi. ");
INSERT INTO isn_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kululo kuleke kuitumya iahoela mpia, itume milandu, longola muluzi goma indoano, na umihole insamaki iyo na ng'wandyo, naiwalugula umulomo wakwe, ukuhanga mumo impia ing'wi. Imihole uape iahoela mpia kunsoko ane nuewe. ");
INSERT INTO isn_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Matungo yayoyayo iamanyisigwa akaza kung'wa Yesu akamuila, Nyenyu numukulu muutemi akigulu? ");
INSERT INTO isn_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu akamitanga umung'enya numunino, akamuika pakati ao. ");
INSERT INTO isn_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Akahinga, tai numuie, iga muhite kila itunu nukutula anga ang'enya nianino singamuzizahuma kingila ku utemi wa kigulu. ");
INSERT INTO isn_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kululo uyu nuituna anga ng'wana numunino, Umuntu nuanso mukulu kutemi nuakigulu. ");
INSERT INTO isn_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nuyu wihi nuimu singiilya unge'wana numunino unsingiilyenene. ");
INSERT INTO isn_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Kululo wihi nukuhuma kukinyila kuantuawa nianino nizaahui kumuleka Itunda. Ikutula iza umuntu nuanso atungiligwe igwe la kusela munkingo agumilwe mulunzi nululundu. ");
INSERT INTO isn_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Isatiko lanyu anyaunkumbingula kunsoko a nkani ya unkunyili, kunsoko aya aiwi azizaimatungo. Ingi gwa isaliko lakwe umuntu uyu nuziziza kumatungo ayo, naziziza kunsoko ane. ");
INSERT INTO isn_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ang'wi umukono wako numugulu weenda kukinyila, Uteme uugume kuli nu ewe, hangi ikutula iza kitalako kingila kuupanga uzewimugila umukono ang'wi wimlema, kukila kungungwa kumoto uzazitite umikono nimigulu ihi. ");
INSERT INTO isn_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ang'wi iliho liko likutosha lipe uligume kuli nuewewe, ukutula iza uewe kingila ni liho lingwi kukola kwingila ni miho abiilikunu endu soswe moto. ");
INSERT INTO isn_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Gozi mleke kumudalaha ung'wi wa anino awa. kunsoko kumuila kina kilunde akale amalaika ao mahiku ihi azeaulindie uunso wang'wa Tata ane nua kigulu. ");
INSERT INTO isn_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Mukusiga ntuni? iga itule umuntu utite nkolo igana ling'wi ilimile ing'wi singi ukualeka ne ao ni makumi kenda mulugulu nukulongola kumupenza uyo nung'wi? ");
INSERT INTO isn_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Anga amuhole, tai kumuila, ukulumbilya kukila ao ni makumi kenda na kenda ni singa aialimie. ");
INSERT INTO isn_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ingi iti singa ulowa wang'wa Tata anyu nuakigulu kina ung'wi waanino awa kulimansila. ");
INSERT INTO isn_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ang'wi ng'waanyu wakulea, longola ende umuhugulye uewe nu ng'wenso anga akije waina munyandugu ako. ");
INSERT INTO isn_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Anga wahita kuulegeelya, muhole muntu ng'wi ang'wi abiili palung'wi nue, kunsoko imilomo naantu abiili ang'wi atatu ihumile kukondanilya ulukani luzipe. ");
INSERT INTO isn_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Anga wihita kumutegeelya liile itekeelo ulukani ulu, angawahila hangi kulilegeelya itekeelo, nuanso waina munya kilungu rumuhoela mpia. ");
INSERT INTO isn_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Tai numuile kilu nimukukilungaila mihi nu kilunde kikulugailwa hangi kilu nimukukilugula mihi nukigulu kikuhugulwa. ");
INSERT INTO isn_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Hangi numuie kina antu abiili miumbi lanyu anga igombye lukani lihi mihi nialulompila nulanso utata ane nuakigulu ukituma. ");
INSERT INTO isn_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kunsoko abiili ang'wi atatu nikie palung'wi kukiila lina lane, nunene nkoli palung'wi nienso. ");
INSERT INTO isn_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Hangi u Petro akaza akamuila u Yesu, ''mukulu, umunyanduguani antashe kanga nune numulekee, ata mupangati? ");
INSERT INTO isn_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","U Yesu akamuila, singakuila ang'wi mupugati, Ingi ata iti imakumi mupungati na mupungati. ");
INSERT INTO isn_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kunsoko nanso utemi wa kigulu wilika nuulemi uo nautakile kunonelya ialo la mutugwa wakwe. ");
INSERT INTO isn_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Naiwandya kunonelya ialo, umutugwe akwe ung'wi anudaiye makumi anzagu ikumi. ");
INSERT INTO isn_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kunsoko aimugila anga nzila akulipa, unugole akwe akalagiilya aguligwe umusungu akwe, palung'wi niana akwe ni kintu kihi nautile uulipe wifung'we. ");
INSERT INTO isn_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Umutugwa akagwa, akatugama pa ntongeela akwe, akalunga mukulu utule nuugimya palung'wi nune hangi kuulipa kila ikintu. ");
INSERT INTO isn_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Umugole wang'wa mutugwa nuanso akahungwa kinyauwai akalekanuka nayo ihi naumudaiye. ");
INSERT INTO isn_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ingigwa umutugwa naiwalekelwa numugole, akalongola akamuamba muntungwi akamgoga kunsoka amudailye dinari igana ling'wi, akamuila ndipe iko ninukudaiye. ");
INSERT INTO isn_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Umutugwa uyu naudaigwe akamuila nindiile kuupa udu aya nundailye. ");
INSERT INTO isn_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Umuntu gwa uyu nuang'wandyo akahita, sunga akalongola akamutunga kukitungo, anga wazawamailya iko numudaiye amutunguile. ");
INSERT INTO isn_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Latugwa niangiza naiaona nikanso makipumie, Ikahung'wa kinyauwai kikulu, akaza ikamuila umugole ao kihi iko naikine kung'wanso. ");
INSERT INTO isn_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ingi gwa umgole uyo nua mutugwa akamitango akamuila ue mutugwa numbi, nakalekela uewe ideni lake lili kunsoko aumpepeye. ");
INSERT INTO isn_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Uewe gwa? singa au humile na kutula ni kinyauwai kumutugwa miako? Anga une nainukumie ikinyauwai. ");
INSERT INTO isn_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Umugole akwe ataka akamutwala kuantu niaja iantu, akatula gigwa sunga ruzemaila ilipo naudaigwe. ");
INSERT INTO isn_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Iti ingi uu uTata ane nuakigulu uzimu tendeela, ang'wi ung'wianyu shuzemulekela imilandu umulana akwe kupuma munkolo yanyu. ");
INSERT INTO isn_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","U Yesu naiwakondya kuligitya inkani izi, akahega ku Galilaya, hangi akalongola mumpolempole a Yudea kuntongeela amongo wa Jordani. ");
INSERT INTO isn_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mihundo ukulu wa antu ukamutyata, ukapantika uguniki kuko. ");
INSERT INTO isn_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mafarisayo akamuhanga u Yesu, akamugema, akamuila, Ikutula taine umuntu kumuleka umusungu akwe kunsoko ihi? ");
INSERT INTO isn_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","U Yesu asusha akalunga, ''shamusomile ne kina uyu nauauimbile ung'wandyo, auaumbile mitinja nu musungu? ");
INSERT INTO isn_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Hangi akalunga, kunsoko iye umitunja ukumuleka utata akwe nu iakwe nukutula palung'wi numusungu akwe nianso abiili akatula muili ung'wi. ");
INSERT INTO isn_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kuluko singa abiili hangi, aina muili ung'wi ingi gwa iko naukikamantilye Itunda, kutile muntu wihi nukukikamantula. ");
INSERT INTO isn_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ikamuiila niki gwa umusa aupamilye ilago li tutu nulakumuleka? ");
INSERT INTO isn_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Akaaila kunsoko aukaku wa nkolo yanyu, umusa akaagombya kualike iasungu ao ingigwa kupuma ng'wandyo singa aiza uu. ");
INSERT INTO isn_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Numuie kina wihi nukumuleka umusungu akwe angwe singa nsoko augoolya nukutina musungu mungiza, ukutula wagoolya, numitunja nukumutina umu sungu naulekilwe la ukutula wagoolya. ");
INSERT INTO isn_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Amwanyisigwa akamuila u Yesu ang'wi uu yili umugoha nu musungu singa iziza kutina. ");
INSERT INTO isn_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","U Yesu akaila ingi singa kila munti uhumile kusingiilya umanyisi uwu ingi aoiti dunia gombigwe kusingiilya. ");
INSERT INTO isn_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kululo gwa akoli iantu naiaimilwe uhumi wa kituma ikimuili, kupuma niang'wi aiaimilwe uhumi nuanso niantu, niang'wi aimpya nilye age kunsoko itume lukani la kigulu, nuhumile kusingiilya umanyisigwa ausingiilye. ");
INSERT INTO isn_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Sunga akatwaila ang'enya anino alume kuaikilya imikono ao nu kulompa iamanyisigwa akwe ikamupatya. ");
INSERT INTO isn_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","U Yesu akaila, ''agombi'' iangenya nianino, laki kuagili kuza kitalame, kunsoko uetemi wa kigulu ingi wa antu anga wawa. ");
INSERT INTO isn_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nung'wenso akaika imikono akwe migulya ao, sunga akahega pang'wanso. ");
INSERT INTO isn_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Muntu ung'wi akaza kung'wa Yesu akalunga, ''mumanyisi, kintuni nikiza nini humile kituma sunga mpanlike utemi nuakali nakali. ");
INSERT INTO isn_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","U Yesu akamuila, kuniki nukunkolya ikintu kinikiza? Ukoli ung'wi du numuza, ang'wi uloilwe kupantika uupanga ambiila uunonelya wa ng'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Umuntu nuanso akamukolya, unonelya kii? u Yesu akalunga, leka kubalaga, leka kugoolya, leka kia, leka kuligitya uleele. ");
INSERT INTO isn_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Akulye utata ako nuiako, hangi mulowe umanyakisali anga uewe nizawiloilwe. ");
INSERT INTO isn_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Umuntu nuanso akamuila, aya ihi nimakondaniye. Nikiule ni mpee. ");
INSERT INTO isn_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","U Yesu akamuila ang'wi uloilwe kukondanila, longola ende ugulye ihi uape iahimbe ukutula ni kiuto kihunde, sunga nzuu untyate. ");
INSERT INTO isn_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Umuhumba yu naiwija ayo nu Yesu naukumuila akahenga akazesiga masigo idu, kunsoko aiwilingie nsao yidu. ");
INSERT INTO isn_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","U Yesu akaila iamanyisigwa akwe; '' Tai numuiie ikaku umugole kingila muutemi wa kigulu. ");
INSERT INTO isn_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Hangi numuie ingi ipepeele ingami kukiila mibolomyo la sindano, kukila umugole kingila mutemi wa kigulu. ");
INSERT INTO isn_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Iamanyisigwa naiija nanso, ikakuilwa nangulu nukulunga, ''Nyenyu gwa nuzegunika? ");
INSERT INTO isn_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","U Yesu akaagoza akalunga, kuantu shalihumikile, kung'wi Tunda ihi nanso ahumile. ");
INSERT INTO isn_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Sunga u Petro akamusukiilya akamuila, Goza, kaleka ihi kakatyata uewe, kintu ki nikupantika kitalako? ");
INSERT INTO isn_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu akaila, ''Tai numuie, uyu nuantyatile unene muileli nupya mumatungo na ng'wana wang'wa Adamu, nuzizikie pakatikati pi tundu la ukulu wa mukola, nunye muzizikie migulya amatundu ikumi na abiili na ukulu kumapa ulamulwa makabila ikumi na abiili na Israel. ");
INSERT INTO isn_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Sunga ung'wi anyu naulekile ito lakwe, aluna niagoha, nawa niasungu, Tata, ia, ana ang'wi mugunda kunsoko a lina lane, ukusingiilya kukila igana, nu kusala uutemi nuakali nakali. ");
INSERT INTO isn_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Idu awa niang'wandyo itungili, azetula anyuma, nawa nianyuma azizatula angwandyo. ");
INSERT INTO isn_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kumdogoilyo utemi nuakilunde ukimpyananu muntu nukete umugunda, nai wiandiie ukedaudau nsoko akuaika anyamilimo mumugunda wakwe nuamizabibu. ");
INSERT INTO isn_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nae igombya neanyamilemo dinalu ing'wi kumung'wi, wikaayuma ende kumugunda nua mezabibu. ");
INSERT INTO isn_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nai akeile masaa ataatu wikenda hange uu wikaaona itumi angiza aeimekule akeeze agila anga mulemo pake awiza kisoko. ");
INSERT INTO isn_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Wikaaila, ''Nunyenye gwa, longoli mumugunda nuamuzabibu, hange kehi nemutakile kumupa Uuu ekalongola kitumia umulemo. ");
INSERT INTO isn_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Wikalongola hange naakela masaa mutandatu muma saa nemutandatu, wikituma uulukulu. ");
INSERT INTO isn_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nkua yedu hange naepikile saa ikumi neleng'wi akenda nukuahanga eantu neangiza imekile akeze angila anga mulemo. Wikaaila, ''kuneke mumehile apa nuagile anga mulemo wehi kuluhiku lehi? ");
INSERT INTO isn_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ika muila kunsoko kutile umuntu wehi nukupee umulemo. Wika aila nunyenye gaa lungoli mumugunda nua mezabibu. ");
INSERT INTO isn_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Imatungo ampinde napikile, umuhola mugunda nua mezabibu wikamuila umemeeli wakwe, ''Itange eitumi wape ekinyamulimo, kandiilya nua musho sunga nua nguandyo. ");
INSERT INTO isn_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nae ekiza awa nae aikilwe saa kumi ne ng'wi, kelaung'wi ausengiiye dinali. ");
INSERT INTO isn_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nae ekiza eitumi ang'wandyo, aeasigike kena akupegwa kukele, kuite ekasingiilyegua kela ung'wi dinali ing'wi kela umuntu. ");
INSERT INTO isn_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nae ikasingiilya dunyamulimo kao, ikamisusumelya umukola mugunda. ");
INSERT INTO isn_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ikalunga, ''Ee eitumi neampelo aeitumiile isaa Ing'wi udu muitumi mulemo kuite waempyania nusese use kukenkile imeligo kuluhuku lelinukupya mpasui. ");
INSERT INTO isn_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kuite umuhola nuugunda wihesusha nukulunga kung'wi wao, muhumbe miane, singa nutumile anga ubii. ");
INSERT INTO isn_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Itee? singa aelugombilyene nunene kudinali eng'wi? ");
INSERT INTO isn_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Itee singa taine leung'wane kutuma anga nendilwe ninsao yane? Ang'wi iliho lako ibe nsoho une nemuza? ");
INSERT INTO isn_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Unu nua mwisho ukutula wang'wendyo nuyu nua ng'wandyo ukutula wa mwisho. ");
INSERT INTO isn_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","U Yesu nauhunankila kena kuyelusalemu awahoile iamanyisigwa akwe ikumi nuubiili kumpelo, numunzila wikaaila. ");
INSERT INTO isn_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Gozi kuunaikela kuyelusalemu, nu Ng'wana wang'wa Adamu uhukwa mumikono aakulu aakuhani neaandeki. Akumulamuila ensha. ");
INSERT INTO isn_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Hange akamupunya kuantu ne amahi nsoko kumumela, kumukua nukumutumbeka. Kuite uluhiku laka taatu ukuiuka. ");
INSERT INTO isn_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Hange uia nua ng'wana wang'wa Zebedayo ae uzile kung'wa Yesu niana akwe. Wikatungama ntongeela akwe nukulompa kentu kupuma kung'waakwe. ");
INSERT INTO isn_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","U Yesu wika nuila, ''utakile ntuni? Wikamuiila, ''Lunga kena iana ane neabiiliikie, ung'wi kumohono wako nua hegoha hange ung'wi kumokono wako nua kekema nuuitemi wako'' ");
INSERT INTO isn_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Kuite u Yesu wihasusha nululunga, ''singauine eke nukulompa. Itee? Uhumilene kung'wela ekekole nekung'wela? ekamuila''Kuuhuma'' ");
INSERT INTO isn_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Aaaila, ekehole kane mukuhingwela. Kuite kikie umukono wane nua kulela numokono wane nuakekema singa anga nene kumupa, kuite kuawa neanoneeigwe nutata wane''. ");
INSERT INTO isn_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Eamanyisigwa neangeza ikuminaeigule uu, iha ambwa ukea nea luna ao neabiili. ");
INSERT INTO isn_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kuite u Yesu wikaitanga ung'wenso nukuaile, ''Muleugile kena eahumu nea mihe amuduile, nea hulu ao ituma uuhumi kitalao. ");
INSERT INTO isn_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kuite ileke kutula uu kitulanyu kuleka ite, wehi nakulowa kutula mukulu nulalanyu kusinjawatule mutumi wanyu. ");
INSERT INTO isn_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nunyu nukulula wang'wendyo kusinja watu mitumi wanyu. ");
INSERT INTO isn_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Anga uu ung'wana nuang'wa Adamu singa ae uzitumilwa inge kituma, nukupunya uupanga wakwe kutule ukomoli waantu duu.'' ");
INSERT INTO isn_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Imatungo naeapumile kuyeliko, iimbe ikulu lekamityata. ");
INSERT INTO isn_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Hange ika aona apoku abiili ikie mumpelompelo anzila. Naeigule kena Uyesu ukukela, ekitanta mduli ekalunga, ''Mukulu, Ng'wana wang'wa Daudi ukugeze.'' ");
INSERT INTO isn_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kuite iumbe likaakenda nukuaila kulagi. Ata uu, neanso ekahulya unduli kukile nukulunga '' Mukulu Ng'wana wang'wa Daudi kugoze.'' ");
INSERT INTO isn_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Hange u Yesu wikenuka wikailanga nukuaholya mutakile numulendele ulee? ");
INSERT INTO isn_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ikamuila, ''Mukulku kena emiho itu apelye. ");
INSERT INTO isn_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Inge u Yesu wikalutwe nuukea, wika maambaemiho ao, inge uu ekasingiilya uhumi wakuona hange ikanityata. ");
INSERT INTO isn_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","U Yesu neamanyisigwa akwa ekapika pakupi ne Yelusalemu hange ekalongola sunga kuBethfage, kulugulu nuka mezeituni, hange u Yesu wihaatuma iamanyisigwa abiili. ");
INSERT INTO isn_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Wikaaila, longoli kukesale nekakunlongeela, sunga mukumiona ndogwe etungilwe palungwanso, nung'wa ndogwa palung'wi nuyo. Itungueli nukuileta kung'waane. ");
INSERT INTO isn_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Anga muntu wihi wamuila kehi kua nelanso, mukulunga, 'Mukulu uitakile,' numuntu nuanso ukukaya kumugimbwa mize palung'wi nizo. ");
INSERT INTO isn_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ikani nelanso inge ilo naelekeiye kuanyahedagu kusinja ligeelekele. Wikaaila. ");
INSERT INTO isn_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Aeli iana akisungu akasayuni, egoza, umutimi wako upembilye kung'waanyu, mupolo hange unaulie mundogwe, nung'wa ndogwe mugoha, ng'wa ndogwe mudabu. ");
INSERT INTO isn_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Hange iamanyisigwa ekalongola ekituma anga u Yesu naualagiiye. ");
INSERT INTO isn_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ikamualeta undogwe nu ng'waa ndogwe, nukueka iang'wenda migulyaao, nu Yesu wikikie nung'wanso. ");
INSERT INTO isn_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Iidu mumilundo ekaila iangwenda ao munzila niauye ehatema imatambi kupuma mumahota nukaile munzila. ");
INSERT INTO isn_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Iumbi naelemutongee u Yesu nawa naiamulyatile iha hulya mduli, nukulunga, ''Hosana kung'wana wang'wa Daudi! Ukembelilwe uzile kulima lamukulu; Hosana migulwa kukila. ");
INSERT INTO isn_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","U Yesu paekapika kuYelusalemu, kesale kehi kekitumba nukulunga, ''Uyu nyenyu? ");
INSERT INTO isn_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Iumbe lekalunga, ''Uyu Yesu munyakidagu, kupuma kunazaleti akuGalilaya. ");
INSERT INTO isn_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Hange u Yesu wekingela mitekeelo ( ang'wi Tunda. Akaazunsa ehi hunzi naiakugulya nukugula mitekeelo. Wekapeula ga numeza neyaantu nae akukaila impia ne maintu naagulya nkume. ");
INSERT INTO isn_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Wikaaila, ''Iandekile, ''Ito lane lekutula ito nelakulompela, kuite unyenye mametenda ikulungu laii. ");
INSERT INTO isn_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Hange iapulu nea kilele ika miziila mitekeelo, nung'wenso wikaakomya. ");
INSERT INTO isn_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kuite kumatungo eakulu amakuhani neaandeki naiaine imakula naumiyumi, hange naeigule iang'enya ahuzugalya mitekeelo nukulunga, ''Hosana ng'wana wang'wa Daudi, ''ihaambwa makuo. ");
INSERT INTO isn_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ikamuila, ''Wigulene nehe kulambulwa neantu awa? U Yesu wikaaila, ''Ee! kuite muikele kusoma, kupuma mumelomo ang'enya neadabu neakankamukete likimo lupikile. ");
INSERT INTO isn_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Hange u Yesu wikaaleka nuikulongola kunzi nakisale mu Bethania nukulala kuko. ");
INSERT INTO isn_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ikedaudau nausukile mukesali, aeukete nzala. ");
INSERT INTO isn_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Wikaleona ikota mumpelompelo anzila. Wikalehanga, kuite shanga wikalya angakentu, mung'wanso inge ematutu du. Akauele, Itule tile inkali kung'waako lukulu hange. ''Hange itungu lelo imtini wekuma ");
INSERT INTO isn_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Amanyisigwa akwe naiaine, ikakulwa nukulunga, yatuleka ule umtini wuma nkua eng'wi? ");
INSERT INTO isn_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","U Yesu wikasusha nukulunga, ''Tai kumuila, ang'wi mihutula nuuhueli muleke kuailya, shanga mukituma eke nekitumilwe kumtini udu, kuite mukuuila ate ulugulu, uholwe ugung'we mubahali, yukutula. ");
INSERT INTO isn_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kehi nemukulompa kusola, kunu eze muhuie mukusengiilya. ");
INSERT INTO isn_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","U Yesu naupikile mutekeelo, akulu amakuhane anyampala antu ekamuhanga imalungo naukumanyisa nukukolya, kuuhumi ke ukituma imakani aya? Hange nyenyu nukupee uhumi uwu? ");
INSERT INTO isn_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","U Yesu wihasusha nukuaila, nunene hange kumukolya ikolyo nen'wi. Ang'wi mukumbila, nunene uu kumuila kuuhumi ke nekituma imakani aya. ");
INSERT INTO isn_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ubadisigwa nuang'wa Yohana aeupumile pee, kulumdane ang'wi kuantu? Ikiholya ienso, akalunga, anga kulunge, aeupumile kilunde ukuuila, nehe mukahita kuhuila? ");
INSERT INTO isn_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kuite anga kulunge, aeupumile kuantu, ''kogopile imaumbie, kunsoko ehi aine uYohana kena munyakedagu.'' ");
INSERT INTO isn_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Hange ekasusha kung'wa Yesu nukulunga, ''Shakuine'' Nung'wenso wikaaila gwa, ''Nunene singa kumuila kuushumi he kituma emakani aya. ");
INSERT INTO isn_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kuite mukusinga ntuni? Umuntu nukete iama abiili Wikenda kung'wi nukumuila, Ng'waane, longola witume umulemo mumugunda nuamezabebu. ");
INSERT INTO isn_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Lelo, ''Ung'wana wikasusha nukulunga, shaninzuu, kuite panyambele wikakaila imasigo akwe nukulongola. ");
INSERT INTO isn_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nu muntu nuanso wikalongola kung'wana nuanso akasusha nukulunga ninzuu, Mukulu, huite shanga wekenda. ");
INSERT INTO isn_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nuule kuawa neabiili nuilumile anga nuTata wakwe nauloilwe? Ikalunga, ''Ng'wana nuangwandyo'' U Yesu wikaaila, ''Itai kumuila, iamanangwa neakosi ahingela muutemi wang'wi Tunda kuleka hanza unyenye hingela. ");
INSERT INTO isn_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kundogoilyo u Yohana auzile kitalanyu kunzila nenguloku, kuite singa meka muhuela, mutungo ia manangwa nea kosi akamuhuela. Nu nyenye naimuine nelanso lekole, shanga mekaungana nsoko mieka mumuluile. ");
INSERT INTO isn_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Tegeeli ikilingasiilo nekiuya, aukule muntu, umuntu aukele ieneo ikulu nelihi. Auteme imizabibu, unkakitiila, wikazipya nihiseme nekakukamula imagai, akazenga numuhala nualindi nukuliliha kuagaza zabibu. Hange wekenda kehengiza. ");
INSERT INTO isn_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Imatungu amaogola amizabibu naeuhugee, wikaatuma atuungwa ang'wi, Umuya ekamubulega, nu muya ung'wi ikamukua namagwe. ");
INSERT INTO isn_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kuite awe neelima izabibu ikazihola eihimi akwe, ihamuhua ung'wi, Umuiye eka mubalaga, nu muya ung'wi ikamukua namagwe. ");
INSERT INTO isn_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kumkua nengiza, umugole wikaatuma atungwi angiza, eeelu kukila awa neangwandyo, huite awa neelima akaaleda hange wudu. ");
INSERT INTO isn_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nai akahila nanso umuhulu nuanso akamutuma latalao uug'waalawe nukulunga, ahumukulyaumngwane. ");
INSERT INTO isn_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kuite awa neelma emezabibu naeamwine umuhumba nuanso, Akiela, Uyu musali, Nzii, kumbulage nukuhola uusali. ");
INSERT INTO isn_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Uu ekamuhola, ekamugume kunzi na mugunda nua mizabibu nukumubulaga. ");
INSERT INTO isn_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Itee umukola mugunda nua mizabibu nuzile, utenda uli ialemi amezabibu? ");
INSERT INTO isn_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ikamuila, ''Ukuabipya iantu nuanso abi kunzila aulaki kukila, ne hange ukusalisha umugunda nua mizabibu kulumiangeza, iantu neahuli pa kunzila amezabibu neakahonda''. ");
INSERT INTO isn_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","U Yesu wikaaila '' Shamusomilene numaandeko,' Igwe nealatulile iaashi naina igwa ikulu nelaukundeki, Ile lepumile kumukulu, hange ukuleta ikuilwa kumiho iluu? ");
INSERT INTO isn_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Uu kumuila, Utemi wang'wi Tunda ukuholwa kupuma kitalanyu nukupegwa ihe nekee inkali yalawe. ");
INSERT INTO isn_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Wehi nuekagwa nugwe nelanso ukubungwa ninoo. Kuite kuehi nelelumugwila, lekumusia. ");
INSERT INTO isn_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ikulu amakuhani nea mafalisayo naeakija ilingasilyo yakwe, ikaona kena akulambulwa enso. ");
INSERT INTO isn_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kuite kela naealoilwe kugoola mikono migulya lakwe, akagopa umilundo, kunsoko iantu aeamugozile anga munyakidagu. ");
INSERT INTO isn_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","U Yesu autambue neenso mulengasiilyo nukulunga. ");
INSERT INTO isn_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","'''Utemi wa kilunde wumpyani numutemi naoneneeye wiloelinua winga wang'waakwe. ");
INSERT INTO isn_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Wikaatuma eitumi akwe husila awa neaalehikweize muwiloeli nua winga, huite sengaikapika. ");
INSERT INTO isn_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Umutemi wikaatuma hange eitumi angizawikalunga. ''Aeli ehe neanilwe, Gozi, nanonelyaindya. Nakwa neamudama neaginu asinzwaa, ne makani ehi ahondilile, Nzii hiloelye muwinga''. ");
INSERT INTO isn_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kuite iantu awa singaai akee lukulu uamwi wakwe. Neang'wi ikalongola kumigunda ao, nawa niangiza ikalongola mumaanza ao nabiashala. ");
INSERT INTO isn_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Niangiza ikaaja eitumi amukulu nukuabulaga. ");
INSERT INTO isn_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kuite umutemi wikataka. Wikatuma ikua mbiteakwe akabulangwa eabulagi nukulimansiilya ikisalekao kumoto. ");
INSERT INTO isn_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Hange wikaaila eitumi akwe, ''Uwinga ukondile, kuite ianwi shangaaza. ");
INSERT INTO isn_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kuitelongoli muninsambwa nzile nemehulu, muane iantu needu anga uu neukuhuma aze muwiloeli nua winga.'' ");
INSERT INTO isn_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Eitumi akena munzila ninkulu nukuakalibisha iantu ehi nae aine, aza kuabi, Uu itando nila winga ieizula iageni. ");
INSERT INTO isn_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Kuite umutemi nae wingie nukuagoza iaiziila, wikamuona muntu ung'wi akeze mugila ung'wenda nua winga. ");
INSERT INTO isn_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Umutemi akamukolya, Muhumba miane, azaupikile ule apakunu umugila ung'we nua winga? Numuntu nuanso shanga wikasushaketi. ");
INSERT INTO isn_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Uu gwa umutemi akaaila eitumi akwe, Mutungi umuintu uyu imekono nemegulu mugumi kunzi kuhiti, kung'wanso nuuhole uleli nukusia muno. ");
INSERT INTO isn_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kunsoko antu edu itangilwe, kuite awa niasaguwe ashenyu. ");
INSERT INTO isn_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Uu iatalisayu ikahega nukuzipeilya amurambe uyehu munkani yakwe ung'wenso. ");
INSERT INTO isn_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Uuikaatuma iamanyisigwa ao palung'wi Helode Hange ikamuila uYesu, ''Mumanyisi, kulengile kenauewe wimuntu watai, hange kena ukumanyisa ita ang'wi Tunda etai shanga ukee mkani ningiza hange umugila anga ukweli nua antu. ");
INSERT INTO isn_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kuite kuile, usegile ntuni? Itee? taine kilago kapunya ehodi nshenyu ang'wi alii? ");
INSERT INTO isn_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","U Yesu aulengile uubi wao wikalunga, Kuneki nemungema unye nemiamasue? ");
INSERT INTO isn_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ndangiili empia netumeka mukodi.''Uu ikamutetela edinali. ");
INSERT INTO isn_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","U Yesu akakolya ''Ikelu ne lina ele lang'wi nyanyu? ");
INSERT INTO isn_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ikasusha,''Yang'wa kaisari.'' Uu Yesu akabila,''Mupiukaisari nakwe nang'wi Tunda mupi Itunda.'' ");
INSERT INTO isn_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Naeigule ile ikakuilwa. Hange ikamuleka nukulongola yao. ");
INSERT INTO isn_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Iluhiku nulanso ang'wi ao amasadukayo akiza kung'wa Yesu, awa neelunga kutile anga uiukiwaashi. Ekamukulya, ");
INSERT INTO isn_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","akalunga,''Mumanyisi, Umusa aulugile, Angeze umuntu ukule singa utugile ung'wana, umuluna ukumusala umusungu nuanso nukumuligelya ung'wana nsoko amuluna wakwe. ");
INSERT INTO isn_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Aeahote atuna mupungate. Nua ng'wandyo autenile wikasha shuutungile ung'wana. Aka mutekela umulune umusungu. ");
INSERT INTO isn_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Hange umulune wakwe wikalenda uu, hange nuyu nuaka taatu, yekatenda uu sunga yuyu nua mupungate. ");
INSERT INTO isn_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Nae ituma ite ehi, numusungu nuanso wikasha. ");
INSERT INTO isn_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Inge muuiuki umusungu nuanso ukutula wang'wanyenyu mualuna neanso nemupungate? kunsoko ehi ae amutenile.'' ");
INSERT INTO isn_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Kuite u Yesu ausuhilye nukulunga, Mukakoseela, Kunsoko shamumanyile Imaandeko sunga ningulu niang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kunsoko muuniuhi, iantu shaitena ang'wi hulenwa, kuleka ite iantu etula anga iamakika hilunde. ");
INSERT INTO isn_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kuite uiuki waashi mukele musomene niTunda auketambue kitalanyu, nukulunga. ");
INSERT INTO isn_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Unene ni Tunda nuang'wa Iblahimu, Itunda wang'wa Isaki, ni Tunda nuang'waYakobo? Itunda singa Itundawaashi, inge Itunda nua panga.'' ");
INSERT INTO isn_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Imatungo umulundo nuahija ile, ikakuilwa umanyisi wakwe. ");
INSERT INTO isn_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kuite emafalisayo niakija kena Uyesu wakilaja ea masadukayo, ekiiligeila ienso palug'wi. ");
INSERT INTO isn_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ung'wiao, akeze munyilago, wika mukolya ikolyokumugema. ");
INSERT INTO isn_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Mumanyisi, ilago neleuke ni kulu kukele imalago ehi. ");
INSERT INTO isn_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","U Yesu akasusha,''kusinja umulowe umukulu kunholo ako ehi, nemahala ako ehi. ");
INSERT INTO isn_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ili lilo ilagilyo ikulu hangi nilang'wandyo. ");
INSERT INTO isn_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Hange na akabiili impyani ni yiyo. Kusinja kumulowa u munya kisali anga nuiloilwe u ewe. ");
INSERT INTO isn_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Imalago ehi neanya kidagu imeiwe nemalago yaya nabiili. ");
INSERT INTO isn_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ne mafalisayo naekili ilingile paluug'wi, U Yesu akaakulya ikolyo. ");
INSERT INTO isn_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Akalunga,''Itee? Musegile ntuni kung'wa Kristo? Nuanso ng'wa nyenyu? Neenso ekasusha,'' Ng'wana wang'wa Daudi. ");
INSERT INTO isn_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","U Yesu wikaasukeelya.''Kuuhuni kea udaudi ike ni nkolo ukumitanga mukulu, nukulunga. ");
INSERT INTO isn_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Mukulu auumuie Umukulu wane,'' Ikieumohono wanenuakegohe, sunga nekuatenda ialugu aho aikwepihe amegulu aho?'' ");
INSERT INTO isn_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ang'wi Udaudi ukumitanga ukristo,''Mukulu''Ukutulang'waakwe ule? ");
INSERT INTO isn_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kutile nae usuhilye ulukani hanga, hange hutile naugemile kumukolya imakolyo nendu kupuma uluhiku lulo nukulongoleka. ");
INSERT INTO isn_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kuleka ite auligilye ne antu neamanyisigwa ahwe, ");
INSERT INTO isn_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","''Iaandeki neamafalisayo ikaie ituntu lang'wa Musa. ");
INSERT INTO isn_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kehi neakumuila kituma, itumi kunu mezeagoza. Kuita muteke kituma intendo yao, kunsoko neanso elunga imakani neshaituma. ");
INSERT INTO isn_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Itai etunga meligo melito neanso hange mekaku humehenha, hange eahensha iantu mumeenga ao. Kuite neanso shaehugeela ata ninino kukenha. ");
INSERT INTO isn_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Inlendo yao yehi, ituma nsoko agozwe neantu. Kunsoko neanso igalipya imasandeko ao nukongeelya ukuulu nua upendi wang'wenda ao. ");
INSERT INTO isn_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Neanso ilowa kikie muianza yakikulya muumalagone mumatuntu akakulya mukate amumasinagogi, ");
INSERT INTO isn_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","nuhulamushigwa kukulyo nkani yakusoko, nukulang'wa, ''Amanyisi'' ne antu. ");
INSERT INTO isn_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kuite unye singainonee kitangwa''Miamanyisi'' Kunsoko muukete umumanyisi ung'wi, hange unye meehi mekiluna. ");
INSERT INTO isn_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Muleke kuuitanga muntu wehi apa mihe kena Tata wanyu, kunsoko mukete Tata wang'wi alua, nung'wenso ukole hilunde. ");
INSERT INTO isn_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Hange muleke kitangwa ''amanyisi'' kunsoko mukete umumanyisi ung'wi duu, inge Kristo. ");
INSERT INTO isn_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Inge numukulu mulalanyu ukutala mutumi wanyu. ");
INSERT INTO isn_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Wehi nukihumbula ukusimigwa, hange wehi nukisimya ukuhumbulwa. ");
INSERT INTO isn_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Kuite ukea wanyu aandeki nea mafalisayo, ateele! mukua lugaile iantu utemi nuakilunde. Nunyenyeshamuhumile kingela, shamuagombilye neakingela hutende ite. ");
INSERT INTO isn_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ukae wanyu aandeki neafalisayo, ateele! Mukuputa itumbe labahali nukumutenda umuntu ung'wi wahuele kuaya nemukumanyisa. hangi nuekatenda anga unyenye, mukumulenda kabiili muntu nue kumoto jehanamu anga uu uuyenye nemile. ");
INSERT INTO isn_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ukae wanyu atongeeli nea poku, unye nemilunga, wehi nuelapa kitekeelo, singa kentu. Kuite nuelapa kilapo la zahabu ni lekeelo, ukulungwa nekelapokakwe. ");
INSERT INTO isn_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Unye apoku meapungu, nekeule nekekulu kukelakeuya, zahabune angwi itekeelo neliikilwe wakufu nezahabu kung'wi Tunda? ");
INSERT INTO isn_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Hange, wehi nukulapa kuzahabu, singa kentu. Inge nukulapa kisongelyo nelekole mung'waakwe, utungilwa nuulapi wakwe. ");
INSERT INTO isn_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Unye antu nemeapoku, nekeule nekekulu kukele ikiunya isongeelyona ang'wi adhabu neekwa wakufu imasongeilyo nepumigwa kung'wi Tunda? ");
INSERT INTO isn_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kuite, nuanso nuelopa kuzahabu wilapa kunelanso nukumaintu ehe nahole kung'wa akwe. ");
INSERT INTO isn_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nung'wenso nuelapa mitekeelo, wilapa kunelanso kung'wenso nuekili akwe. ");
INSERT INTO isn_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nung'wenso nuelapa kiluunde, wilapa pituntu la utemi ne lang'wi Tunda nukung'wenso nuikie mung'wanso. ");
INSERT INTO isn_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ukae wanyu, aandeki neafalisayo, ateele! kunsoko mukupunya ezaka kubizali, mnaanaa nechicha, kuita mukuleka imakani nemalito milego -tai ukende, nuuhueli. Kuite aya yemunonee kutula mutumile, hange singa kumaleka nemangiza muhile kumitumela. ");
INSERT INTO isn_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Unye atongeeli nemeapoku, nemukusuza umududu numuniino kuite mukuimela ingamia! ");
INSERT INTO isn_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ukae wanyu, andeki neafalisayo, miateele! Kunsoko mukoja ikole kunzi ne sahani kuhunzi, kuite kunzi izue uubi hange kulile anga upolo. ");
INSERT INTO isn_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Unye aaafalisa nemiapoku, oji hanza ikole mukati ne mukati a sahani, nsoko inkika na kunzi etule nza nenyenso gaa. ");
INSERT INTO isn_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ukae wanyi, aandeke neafalisayo, meateele! kunsoko mukimpyana niibeela napakilwe ukenke, kunzi igela maza, kuite mukati izue imakupa naashi hange kela kentu neke bii. ");
INSERT INTO isn_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Uulukuli, nunye kunzi migee kena miaza ntongeele aantu, kuite kunzi mizue uteele nuubi. ");
INSERT INTO isn_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ukae wanyu, aandeki neafalisayo, meateele! kunsoko mukuzenga iibiila na anyakidagu nukupambe iibiila yao awa nea tai. ");
INSERT INTO isn_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Unye milunga, anga aekikie mumahiku a tata itu, shanga aezekipalung'wi nao kuhunula usakami nuanya kidagu. ");
INSERT INTO isn_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kuite mukihenga unyenye kena unye miana ao awa nae abulagile ianyakidagu. ");
INSERT INTO isn_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Hange unyenye mukupikeelya kizulya pang'wanso niinonee umulandu nua Tata anyu. ");
INSERT INTO isn_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Unye nzoka, akete vipilibao, muuekile ule uulamuli nuakujehanamu? ");
INSERT INTO isn_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kuite, goza, kuatuma kitalanyu ianyakidagu, antuneakuligwa, neaandeki, Ang'wi ao mukuabulaga nukuaja. Ang'wiao mukuakua mumasinagogi anyu nukuazunsa nukupuma makesale king'wi sunga numuya. ");
INSERT INTO isn_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Upumeli kena kung'wa anyu ukupumela usakami wehi nua tai nauhunuwe mihe, kaziilya isakamiang'wa Habili nua tai sunga isakani niya Zakalia ung'waa Balaki, nae mumubulabile patakatifu nepa kezindaalo. ");
INSERT INTO isn_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tai, kumuila, imakani aya ehi akuupata uwileli uwu. ");
INSERT INTO isn_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yerusalemu, Yerusalemu, uewe nukeze abulaga ianyakidagu nukuakua namagwe awa neatumilwe kung'wa ako! Nkua inga kumilingeela iang'enya ako palung'wi anga enkuku nilingeela iana akwe mumanana akwe, kuite singa wikagomba! ");
INSERT INTO isn_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Goza ito lako lasaga nuula. ");
INSERT INTO isn_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nunee kuila, kandeelya, itungo lele nukulongoleka singa umona, sunga nuekalunga, “Ukembetilwe nuanso nuzile kulina nela Mukulu.” ");
INSERT INTO isn_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","U Yesu akapuma mitekeelo akalongola kwea. Iamanyisigwa akwe ikamuhanga nukumulagiila imajengo amatekeelo. ");
INSERT INTO isn_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Kuite akasusha nukuaila, “Itee, shamuine ne imakani aya ehi? Itai kumuila, kutile igwe nelekusaga migulya alulya nesha nukuhambulwa.” ");
INSERT INTO isn_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Hange pawikikie mulugulu nula Mizeituni, iamanyisigwa akwe ekamuhanga akeze ipihie nukulunga, “Kuite imakani aya akupumela nale? Kentu ke nekikutula kelingasiilyo kakuza kung'waako ne mpelo aunkumbigulu? ");
INSERT INTO isn_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","U Yesu akasusha nukuaila, “Tuli nuugozi kena aleke umuntu kuakongela. ");
INSERT INTO isn_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kunsoko edu azile kulina lane. Akulunga, “Unene inge nene ne Kilisto, hange akuakonga edu. ");
INSERT INTO isn_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Muukija mbita ni mpola nia mbita. Gozi muleke kutula nuwoa, kunsoko imakani akupumela, kuite empelo ika ikeli. ");
INSERT INTO isn_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kunsoko ihe ikauka kihe nzuya, nuutemi kuutemi uuya. Yukutula nenzala nematetemeko amahimuianza niakuli kuli. ");
INSERT INTO isn_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kuite imakani aya ehi ng'wandyo udu wauai nuakutuga. ");
INSERT INTO isn_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Uu akumupumya kunsoko magigwe nukubulagwa. Mukubipilwa ne mahi ehi nsoko alina lane. ");
INSERT INTO isn_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Uu edu akukumpa nukilekeelya nukibepilwe unyenye kua nyenye. ");
INSERT INTO isn_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Anyakidagu edu akupumela nukuakongela edu. ");
INSERT INTO isn_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kunsoko uubi ukongeeleka, ulowa nuantu du ukupola. ");
INSERT INTO isn_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kuite uyu nukigigimiilya sunga empelo, ukuguneka. ");
INSERT INTO isn_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Izi inkani nenziza nia utemi yukutanatigwa unkumbigulu wehi kutula wihengi kumahi ehi. Uu empelo ekapika. ");
INSERT INTO isn_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Kuite nemekaona uwibulugi nuubi, naeletambuwa numunya kedagu u Danieli lemekile pakianza neketakatifu (nukusoma nualinge), ");
INSERT INTO isn_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","uu awa neakole ku Yuda amankiile mumalugulu. ");
INSERT INTO isn_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nuyu nuakole migulya mumalo waleke kusima pihe kuhola kentu keke kupuma munyumba akwe, ");
INSERT INTO isn_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","nuyu nuakole kumugunda aleke kusuka kuhola ung'wenda wakwe. ");
INSERT INTO isn_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kuite ukia wao neakete ung'wana nawe neakonsha mumahiku nanso! ");
INSERT INTO isn_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Lompi kena kumanka kung'waanyu ileke kutula matungo ampepo, ang'wi luhiku nula kusupya. ");
INSERT INTO isn_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kunso ikalukole lwago lukulu, neze lukile lupumile kupuma kuumbwa uukumbigulu sunga nitungo gaa, singalezezigela hange. ");
INSERT INTO isn_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Anga imahiku nanso anga ae akugempigwe, kutile naeweze guneka. Kuite nsoko aasagulwa, imahiku nanso akukugempigwa. ");
INSERT INTO isn_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Hange angeze muntu wehi ukumuila, “Goza, Kilisto ukole papa! Ang'wi, Ukilisto ukole uko muleke kuhuila inkani nianso. ");
INSERT INTO isn_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kunsoko i Makilisto nauteele neanya kidagu auteele azile nukigeelya makula makulu naukuelwi, kunsoko akukongela, ang'wi yukuwezekana ata iasagulwa. ");
INSERT INTO isn_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Gozi, namuhugula nakele kupumela. ");
INSERT INTO isn_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kuite, anga amuila, “Ukilisto ukole kumbuga, muleke kenda kung'wanso kumbuga. Ang'wi, “Gozi, ukole munyumba muleke kuhuela inkani nianso. ");
INSERT INTO isn_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Anga uu nulumelika kupuma kilya nukumelika kung'weli, uu yeekatula keza kung'wana nuang'wa Adamu. ");
INSERT INTO isn_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Pehi nuukole umuimba, kung'wanso kuko indeeyilingeela. ");
INSERT INTO isn_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Kuite matungo makupe kukela yekatula nulwago lukulu imahiku nanso, Ilya lukuikilwa kiti, ung'weli shaukupumya uwelu wakwe, inzota yukugwa kupuma kilunde, ningulu yakilunde yukuhingieka. ");
INSERT INTO isn_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Uu ekelingasiilyo ka ng'wana wang'wa Adamu ekigela migulya, ni ntambu yehi ni amihe yako hongelya. Akumuona ung'wana nuang'wa Adamu upembilye mumalunde amigulya kungulu nuukulu nukulu. ");
INSERT INTO isn_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ukuatuma iamalaika akwe kululi nulukulu alalumbeta, neensa akuulingiila palung'wi iasagulwa akwe kupuma nande ine nia mihe, kupuma mpelo ung'wini lunde sunga neye nengiza. ");
INSERT INTO isn_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Imanyisi isomo kupuma mumtini. Anga itambee liketegela nukupumya imatutu, malenga kena iketiku kahugeela. ");
INSERT INTO isn_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Uu gwa, anga maona imakani aya ehi, mulenge kena wahugeela, pakupi pamulango. ");
INSERT INTO isn_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Itai kumuila, uwitugi uwu shaukukila, sunga imakani aya igele. ");
INSERT INTO isn_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ilunde nihi yukukela, kuite inkani yane shayukukila kwee. ");
INSERT INTO isn_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Kuile kuluhiku nulanso nesasa kutile umuntu nuine, ata umalaika nua kilunde, ang'wi ung'wana, inge u Tata ung'wana wang'wenso udu. ");
INSERT INTO isn_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Anga uu naeyeli mumatungo ang'wa Nuhu, uu yukutula keza kung'wana wang'wa Adamu. ");
INSERT INTO isn_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kunsoko mumahiku nanso imazi naeakeli kigela iantu ae akulya nukung'wa, akutina nukutinwa kupika uluhiku lulo nu Nuhu aewingile musafina, ");
INSERT INTO isn_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","hange shanga aealingile kentu kehi sunga emazi nai ahangile nukuchola ehi uu yukutula heza kung'wana wang'wa Adamu. ");
INSERT INTO isn_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Uu antu abiile ika akole kumugunda, ung'wi ukuholwa, ung'wi ukulekwa kunyuma. ");
INSERT INTO isn_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Asungu abiili ikaa eze sia palung'wi, ung'wi ukuholwa, ung'wi ukusaga. ");
INSERT INTO isn_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kuite, tuli meahugu nsoko shamuine luhiku ke nuzile u Mukulu wanyu. ");
INSERT INTO isn_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kuite mulenge kena, angeze umukulu nuito angize azuine itungo ke nuzile umuhembi, azuzekesha shanga azuzee leka ito lakwe kubunangwa. ");
INSERT INTO isn_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kuite, inonee gwa mutule mukondile, kunsoko ung'wana wang'wa Adamu uzile itungo nesungamuine. ");
INSERT INTO isn_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ite nyenyu numulindie, mutugwa nukele imakala, umukulu wakwe umupee uuhumi kuawa neakole nuto lakwe, nsoko waape indya kumatungo nanonee? ");
INSERT INTO isn_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ukembetilwe umitumi nuanso, u Mukulu wakwe ukumuhanga ukitume uu imatungo nuzile. ");
INSERT INTO isn_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Itai kumuila kena umukulu ukumuika mukela kentu nekakwe. ");
INSERT INTO isn_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kuite umutugwa ang'wi mubii ukulunga munkolo akwe, “Mukulu wane watinia,” ");
INSERT INTO isn_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","wandye kuakua eitumi akwe, hange wang'we nukulya palung'wi nuhugala. ");
INSERT INTO isn_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","U Mukulu nua mutugwa nuanso uzile uluhiku numugila ata isigo, numitungu nushuine. ");
INSERT INTO isn_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","U Mukulu wakwe ukumutema ipande ibiili nukumuika mulyoma ling'wi anga asambo, kung'wanso ikole kulila nukusia emino. ");
INSERT INTO isn_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Uu utemi wakilunde ukipyanigwa neawali nikuminaahole intala yao ekalongola kumupokela ubwana nuawinga. ");
INSERT INTO isn_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Antaano ao ae apungu nawa neangiza ataano aeaelewa. ");
INSERT INTO isn_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Eanawali neapungu ekahola intala yao, shanga ekahola emakuta. ");
INSERT INTO isn_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Hange aenawali awa neaelewa ekahola iseme yao nemakuta palungwi ni ntala yao. ");
INSERT INTO isn_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Imatungo yayo Ubwana nuawinga naushelewe kupika, ehi akahung'wa tolo ekalala. ");
INSERT INTO isn_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Lakini utiku wakatekate akakakuta ngwano,''Goza, ubwana nuawinga! Pumi kunzi mumusingeelye. ");
INSERT INTO isn_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Uu neenso enawali ehi akauka ekakakelya intala yao. ");
INSERT INTO isn_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Awa neapunga ekaaela awa neelewa, 'Mukongelye esehemu amakuta anyu kunsoko intala yitu yukulima.' ");
INSERT INTO isn_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Lakini awa neaelewa ekaasukilya ekaaela, 'Kunsoko shanga akutosilye unyenye nusese, kuite longoli kwa awaneegulya miguelye ekeasi kanyu nekemutosilye. ");
INSERT INTO isn_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Imatungo naalongoe neanso kugula, Ubwana wawinga wekapika, ne matungo naakole tayali aeendile nang'wenso kushelehe awinga, numulango wikalugailwa. ");
INSERT INTO isn_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Baadae enawali neangiza naapikile ekalunga, ''Bwana, bwana, kulungwile.'' ");
INSERT INTO isn_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Lakini akaasukelya nukulunga,'Etai kumuela, shanga numumanyile. ");
INSERT INTO isn_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kuite gozi, kunsoko shangamuihe ematungo luhiku ang'wi saa. ");
INSERT INTO isn_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Kuite sawa numuntu nautakile kusafili kulongola ihe ngeza aeutangile eatugwa akwe nukuapa ugole wakwe. ");
INSERT INTO isn_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ung'wiao wekamupa talanta itaano, uyu numungiza wekamupa ibeele, nuyuite wekamupa eng'wi. Kela ung'wiao aupokee kiasi kulengana nuuwezo wakwe, numuntu nuanso weka safili kulongola yakwe. ");
INSERT INTO isn_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mapema uyu naupokee entalanta niitano wikalogola wekaelya, nukutugisa talanta itaano hange. ");
INSERT INTO isn_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Uu uu nuyu naeupokee italanta nibeele, aeutugizilye ni nzuya ibeele. ");
INSERT INTO isn_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Lakini umutugwa naeupokee talanta eng'wi, wikalongola yakwe wikahemba ishimu pihe, ite wikamepiha empia ang'wa bwana akwe. ");
INSERT INTO isn_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Na baada matungo malepu, Ubwana watungwa neanso wekasuka nukuzepelya emaesabu neenso. ");
INSERT INTO isn_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Umutugwa nuanso nausengeeye italanta niitano auzile wikaleta ningeeza itaano. wikalunga, Bwana, azumpee talanta iitano. Goza napata efaeda atalanta ngiza itaano. ");
INSERT INTO isn_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ubwana akwe wikamuila,'' Hongera, mutugwa numuza nuuhueli! Umuhueli kuintu niino. Kuupa emadalaka migulya kuintu niidu. Ingele muiloelyi wang'wa Bwana ako. ");
INSERT INTO isn_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Umutugwa nausengeye italanta niibeele wekeza nukulunga, Bwana, aumpee talanta ibeele. Goza napata faeda atalanta geza ibeele. ");
INSERT INTO isn_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ubwana akwe wekamuela,''Hongeeli mutugwa numuza nuuhueli kumaintu nemakehu. Kuupa emadalaka migulya kumaintu needu. Ingile wiloelye mung'wa Bwana ako.'' ");
INSERT INTO isn_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Baadae umutugwa naupokee etalanta neng'we aewezie wekalunga,''Bwana, nengile kina uewe umuntu mutaki wevuna pang'wanso neshanga uhusekile. ");
INSERT INTO isn_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Unene nekogopa, nekenda yane nekapiha etalanta akopihe. Goza, ukete hapa nekako.'' ");
INSERT INTO isn_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Lakini ubwana wikamusukilya wekalunga. 'Uewe umutugwa mubee, aulengile kina nekala pang'wanso neshanga ntemee nukuvuna pang'wanso neshanganihusekile. ");
INSERT INTO isn_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kuite aeizepie kuapa empia ane entu abenki, nematungo naensukile kung'wane aezemesengelya nane palung'wi nefaeda. ");
INSERT INTO isn_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Apa muhegelyi etalanta nanso mumupe utugwa nukete talanta nikumi. ");
INSERT INTO isn_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kila umuntu nukete nekakwe, okongeligwa ikulu ata ukuzidisheligwa. Lakini kwa uyu nemugila ekentu, ga nekenukete ukuhegeligwa. ");
INSERT INTO isn_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mugumi kunzi kukiti umutugwa nuanso neshanga ufaile hange ikutula kelelo nukukelya emino! ");
INSERT INTO isn_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ematungo ung'wa Adamu nuekeza nuutukufu wakwe, naealaeka ehi palung'wi nung'wenso, Uu ukikie migulya ituntu lakwe nuutukufu. ");
INSERT INTO isn_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Indugu yehi ikilingeela ntongeela akwe, nung'wenso ukuabagala eantu. Anga umudemi nuebagula inkolo nimbuli. ");
INSERT INTO isn_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ukuieka inkolo mukono wakwe nuwakigoha, ite ukiekaimbuli mokono wankege. ");
INSERT INTO isn_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ite umufalme ukuaela awa nea mukono wakegoha, Nzii, nemukembetilwe nu Tata anyi, usali ufalme nauandalewe kunsoko anyu kupuma ukuekwa emesingi au nkumbigulu. ");
INSERT INTO isn_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Hange aenkete nzala mekampa indya; Ae nemugeni mukankalibisha. ");
INSERT INTO isn_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ae nkole kepwe, mekantugala eang'wenda; Ae numulwae mekantunza; Ae nkole muketungo mukangoza! ");
INSERT INTO isn_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Uu awa neatai akumusukelya nukumuela, Bwana, Nale aekukuine ukete nzala kekakulesa? Ang'wi ukete nyota kekakupe maze? Hange nale nae kukuine umugeni kekaku kalibisha? Ag'wi ukete nyota kekakupa emaze? ");
INSERT INTO isn_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ang'wi nale naekukuine umugeni nakekakukalibesha? Hange umugila anga lang, wenda kekakutugala eang'wenda? ");
INSERT INTO isn_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ang'wi nale naeumulwae, ang'wi ukole muketungo kekeza kuugoza? ");
INSERT INTO isn_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Na umufalme ukuasukelya, etai kumuela, naemutendile apaite kung'wi anyandugu ane neanino, aemuntendee nene! ");
INSERT INTO isn_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Kuite ukuaela awa neakole umukono wakwe nuankege; Hegi kitalane unye nemukete emasatiko, Longoli kumoto nua kulenakale naeuandalewe kunsoko ang'wa shetani neamalaeka akwe; ");
INSERT INTO isn_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kunsoko aenkete nzala shanga mekakumpa indya; Ae nkete nyota shanga kekakupa emaze; ");
INSERT INTO isn_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ae nemugeni shanga mekankalibisha; Ae nkolekepwe shanga mekampa eang'wenda; Ae nemulwae ae ntungilwe kuite shanga mekangoza. ");
INSERT INTO isn_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Au nawa neanso aku musukelwa nukulunga, Bwana nale naekukuine ukete nzala ang'wi nyota, ang'wi umugeni, ang'wi ukepwe ang'wi umulwae, ang'wiutungilwe, shanga kekakuhudumela? ");
INSERT INTO isn_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ite ukuasukelya nukulunga,''Etai kumuela, eke neshanga aemuatendee awa neanino, shangaae muntendee anga nene. ");
INSERT INTO isn_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Awaite inzu kuazabu akale nakale kuite awa neatai upanga wakale na kale.'' ");
INSERT INTO isn_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Imatungo u Yesu naumaile kutambula inkani yehi niyanso, akaaela eamanyisigwa akwe, ");
INSERT INTO isn_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mulengile kina baada amahiku abeele kuutula nesikukuu, nung'wana wang'wa Adamu ukupumigwa kuite wasulubiwe.” ");
INSERT INTO isn_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Baadaye eakulu amakuhani neanyampala neantu aeatankanile palung'wi pakate pamakao ang'wa kuhani numukulu, naewitangwa Kayafa. ");
INSERT INTO isn_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Kwa palung'wi ekupanga enjama akumuamba u Yesu kwa unkunku nukumubulaga. ");
INSERT INTO isn_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kunsoko aalungile, “Ileke kutula matungo asikukuu, kuite ilekekuleta eghasia pakatekate aantu.” ");
INSERT INTO isn_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Imatungo u Yesu naukole ku Bethania munyumba ang'wa Simoni umukoma, ");
INSERT INTO isn_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","naukole ukionyesha pameza, musungu ung'wi aewezile kitalakwe aukenkile mukebe nuwa alabasta naekete imakukuta naake ethama nkulu, na aeumahunuie migulya mitwe lakwe. ");
INSERT INTO isn_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Lakini eamanyisigwa akwe naaine ikani eleite, aabepewa nukulunga, “Kunsokoke easala eyeite? ");
INSERT INTO isn_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ayaite ahumekile aguligwe kukeasi kekolo nukupegwa eaula.” ");
INSERT INTO isn_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Lakini u Yesu kunsoko aaulengile eleite, wekaaela. “Kuneke mukumusumbula umusungu uyuite? Witumile kentu kezakung'wane. ");
INSERT INTO isn_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Eaula mukete mahiku ehi, lakini shangamukutula mukole nunene mahiku ehi. ");
INSERT INTO isn_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kunsoko nauhunue imakuta mitwe lane aya migulya wa mwele wane, aewitumile ite kunsoko ukuekwa kung'wane. ");
INSERT INTO isn_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Kutai kumuela, pehi ulukani ulu nulekatambulwa pakate aunkumbigulu wehi, eketendo nukitumile umusungu uyuite, hange kekutambulwa kunsoko akumbukumbu.” ");
INSERT INTO isn_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kuite ung'wiao nua awa nekumi nambele, naewitangwa Yuda Iskariote, akenda kwa akulu amakuhani, ");
INSERT INTO isn_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","nukulunga “Mukumpa ntuni anganumusaliti?” Akamupimela u Yuda ipande thelathini niyampia. ");
INSERT INTO isn_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Hange imatungo yayo wekaduma enafasi akumusaliti. ");
INSERT INTO isn_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Hata uluhiku lang'wando nuamekate neshanga eekewe igae, eamanyisigwa akwe aeendile kung'wa Yesu nukulunga, Pe nutakile kukuandaelye ulye indya ya Pasaka?” ");
INSERT INTO isn_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Wekaaela, Longoli kumujini kumuntu fulani namueli, Ung'walimu ukulunga, “Ematungo ane ahumbeela kumetimelya epasaka palung'wi neamanyisigwa ane, pakate panyumbako.” ");
INSERT INTO isn_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Emanyisigwa akituma anga u Yesu naualageye, na andae indya ya Pasaka. ");
INSERT INTO isn_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Naeipikile mpende, aewikie kulya indya palung'wi neamanyigwa kumi nambeele. ");
INSERT INTO isn_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Naakulya indya, wikalunga, “Etai kumuela ung'wi anyu ukunisaliti.” ");
INSERT INTO isn_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ekapyenenkela kule, kila ung'wiao akandya kumukolya, “Ite shanganene Mukulu?” ");
INSERT INTO isn_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Akaasukilya, “Uyu nukutala umukono wakwe palung'wi nunene mukate mibakuli yuyo ukunisaliti. ");
INSERT INTO isn_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ung'wana wang'wa Adamu ukuhega, anga naeyandekilwe. Lakini isateko lakwe umuntu nuekamusaliti ung'wana wang'wa Adamu! Azetula tazu kumuntu nuanso angae waleke kutugwa.” ");
INSERT INTO isn_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","U Yuda, nae uzemusaliti wikalunga, ite nene Labi? U Yesu wekamuila, “Ukutambula ulukani nulanso uewe.” ");
INSERT INTO isn_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Naatuile ukulya indya, u Yesu wikauhola umukate, akaukembeta, nukuega. Wikaapa eamanyisigwa akwe nukulunga, “Holi, mulye. Uwu wuwu mweele waane.” ");
INSERT INTO isn_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Wekahola ekekombe nukukembeta, akaapa nukulunga, “Wing'wi mehi kuekeite. ");
INSERT INTO isn_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kunsoko uyu sakami wane nuilago lane, nekuhunulwa kwa ehi kumusamaha waanyamendu. ");
INSERT INTO isn_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Lakini kumuela, shangakung'wa hange inkali yamezabibu uwaie, hadi uluhiku ulo nenzeng'wa nepya palung'wi nunyenye pakate autemi wang'wa Tata ane.” ");
INSERT INTO isn_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nakondilye kemba uwembo, ekapuma ekalongola kumulema wa Mizeituni. ");
INSERT INTO isn_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Hange u Yesu wikaaela, “Utiku wuwu mehi mukukumpa kunso ane, kunsoko yandekilwe, kumukua umudemi wikundi lankolo ninyenso ikusambaela. ");
INSERT INTO isn_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Lakini baada akuiuka kung'wane, kumutongela kulongola ku Galilaya.” ");
INSERT INTO isn_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Lakini u Petelo wikamuila, “Hata anga ehi akuhite kunsoko amakani nakuhanga, nakuupata, unene shanga kuhita. ");
INSERT INTO isn_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","U Yesu wikamusukelya, “Etai kuela, utiku wuwu kabla ujogoo wakunkule, ukunihita nkua itaatu.” ");
INSERT INTO isn_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","U Petelo wikamuela, “hata kina impasile kusha nuewe, singa kuuhita.” Neamanyisigwa neangeza ehi ekalunga uu, uu. ");
INSERT INTO isn_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Baadaye u Yesu wikalongola neenso pang'wenso niitangwa Gethsemane nawikaaela eamanyisigwa akwe, “Ikie hapa ematungo neninzu uko kulompa.” ");
INSERT INTO isn_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Akamuhola u Petelo neana abeele neang'wa Zebedayo na wikandya kupyenenkela nukusononeka. ");
INSERT INTO isn_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Hange wikaaela, “Enkolone ekete kenyauwai kekulu kule ata ekeasi kakusha. Sagi hapa mukeshe palung'wi nunene.” ");
INSERT INTO isn_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Wekalongola kuntongela inino, wikagwa kifudifudi, nukulompa. Wikalunga, “Tata ane, peza iwezekanile, ekekombe ekeite kenkwepe. Iteke kutula anga nentakile unene, hange kina nutakile uewe.” ");
INSERT INTO isn_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Akaahanga eamanyisigwa wekaahanga alala tulo, kunso emiho aemalito. ");
INSERT INTO isn_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Keshi nukulompa kunso mulekekingila mumagemo. Inkolo akole radhi, lakini umweele udhaifu. ");
INSERT INTO isn_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Akalongola yakwe nkua akabeele nukulompa, akalunga, “Tata ane kina ulukani ulu shangaiwezekanile kulekwepa lazima nukeng'we ekekombe ekeite, emapenzi ako atimele.” ");
INSERT INTO isn_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Wekasuka hange wikahanga alala tulo, kunsoko emiho ao ae malito. ");
INSERT INTO isn_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kuite wikaaleka hange wekalongola yakwe. Akalompa enkua akatuatu inkani zizo zizo. ");
INSERT INTO isn_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Baadaye u Yesu wekaahanga eamanyisigwa akwe nukuaela, “Kele mukie ne nukusupya? Gozi ematungo ahumbeela, nung'wana wang'wa Adamu ukusalitiwa mumekono aanyamelandu. ");
INSERT INTO isn_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Uki kuhege. Gozi uyuite nung'wenso nukunsaliti wahugela.” ");
INSERT INTO isn_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ematungo naukele ukuligitya, u Yuda ung'wi wa awa nenkumi na mbeele, akapika. Lulili lukulu lukapika palung'wi nung'wenso anga lepumele kwa akulu amakuhani neanyampala neantu. Ae azile nimpanga niidunkuli. ");
INSERT INTO isn_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Hange umuntu naeudee kumusaliti u Yesu auapee eshala, akalunga, “Uyu nenekamulungela, ng'wenso muambi.” ");
INSERT INTO isn_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Imatungo yayo wekiza kung'wa Yesu nukulunga, “Na wikamulungela. ");
INSERT INTO isn_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","U Yesu wikamuila, “Muhumba meane itume ele nelekutile uu akeza, nukumugoolela emekono u Yesu, nukumuamba. ");
INSERT INTO isn_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Goza, muntu ung'wi naukole palung'wi nu Yesu, wikagoola umukono wakwe, wikahopola upanga wakwe, na wikamukua umitumi wang'wa kuhani numukulu, nukumuamba ukutwe wakwe. ");
INSERT INTO isn_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Uu Yesu wikamuila, susha upanga wako pana aza uhoe, kunsoko ehi neetumila upanga akuangamizigwa kwa upanga. ");
INSERT INTO isn_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ite mulungile shanganihumilene kumitanga u Tata ane, nung'wenso ukuntumela emajeshi zaidi akumi na mbeele na amalaeka? ");
INSERT INTO isn_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Lakini ite emaandiko awazekanile kutimeligwa, kuite uu ipasilwe kupumila? ");
INSERT INTO isn_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Imatungo yayo u Yesu wikauela umilundo, “Ite mezile nemapanga neidunkuli kumamba kina uyu nuehegelanya? Kila imahiku aenikie mihekalu nukumumanyisa nashangaemumambile! ");
INSERT INTO isn_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Lakini ayaite ehe itumilwe ite emaandiko anyakedagu atimile. “Uu emanyisigwa akwe ekamuleka nukumanka. ");
INSERT INTO isn_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Awa naamuambile u Yesu akamutala kung'wa Kayafa, u Kuhani nu mukulu pang'wanso eaandeki neanyampala aeilingie palung'wi. ");
INSERT INTO isn_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Kuite u Petelo aiumutyatile kunyuma kukuli kupikila mu itando nilang'wa Kuhani u Mukulu. Ai wingie mukate nukikie palung'wi nienso wihenga mukikapumila. ");
INSERT INTO isn_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kuite eakulu amakuhani nebalaza lehi aeakuduma ushahidi wauteele dhidi ang'wa Yesu kunsoko ahume kumubulaga. ");
INSERT INTO isn_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kuite apumie amashaidi eedu, lakini shanga ekalija anga lukani lehi. Lakini baadaye eamashahidi abeele ekapumila pantongela. ");
INSERT INTO isn_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","nu kulunga, “Umuntu uyu aulungile, “Mbezile kuunanga ihekalu lang'wi Tunda nukulezenga kwa mahiku atatu.” ");
INSERT INTO isn_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ukuhani numukulu akimeka wikamukolya, “Shanga uhumilene kusukilya? ");
INSERT INTO isn_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Lakini u Yesu aewikie ukilagilye ihetwe. Ukuhani numukulu wikamuela, “Anga Itunda nuikie kuamulu ukuele, kang'wi uwe wi Kilisto ng'wana wa Itunda. ");
INSERT INTO isn_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","U Yesu wikamusukilya, “Uwe utambue ulukani nulanso. Lakini kuela kupuma itungele nukendelea ukumuona ung'wana wang'wa Adamu wikie umukono wakulela nuukete ingulu na wikeza na malunde kigulu.” ");
INSERT INTO isn_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Uu gwa u Kuhani nu Mukulu wekatamulanga eng'wenda akwe nukulunga, “Wakufulu! Ite, kutakile hange ushahidi wantuni? Goza, uu wimeka ukukufulu. ");
INSERT INTO isn_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ite mukusega ntuni? Ekamusukilya nukulunga, “Ugombigwe washe.” ");
INSERT INTO isn_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Hange ekamutye emate muusu nukumukua enkunde, nukumukua emakopi kumekono ao, ");
INSERT INTO isn_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","nukulunga, “Wewe uewe Kilisto. Nyenyu nukukuile? ");
INSERT INTO isn_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ematungo nanso u Petelo aewikie kunzi pakate aukumbi numitumi nuakesungu wikamuhenga nukulunga, Newe ga aeukole palung'wi nu Yesu wa Galilaya.” ");
INSERT INTO isn_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Lakini wekahita ntongeele ao ehi, wikalunga, singa nengile ekeite nemukutambula.” ");
INSERT INTO isn_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nae ulongoe kunzi amulango, umitumi mungiza nuakesungu wakamuona nukumuela naakole pang'wanso, “Umuntu uyu aliakoli nu Yesu wa Nazareti.” ");
INSERT INTO isn_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Wikahita hange kwakulapa, “Unene shanga numumanyile umuntu uyuite.” ");
INSERT INTO isn_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ematungo makupe baadaye, awa naeimekile pakupe, ekameendela u Petelo nukulunga, “Kutai nuewe ga wiang'weao, kunsoko ata lafudhi ako ekuonyesha.” ");
INSERT INTO isn_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Uu wikanza kuapa emasateko, “Unene shanga numumanyile umuntu uyuite” kuite ujogoo wekakunkula. ");
INSERT INTO isn_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","U Petelo wekakumbuka inkani nauewe nu Yesu, “Kabla ujogoo wekakunkula wakunihita nkua itatu.” ");
INSERT INTO isn_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ematungo ekedaudau naapikile, eakulu ehi neamakuhani neanyampala aantu aalie njama dhidi ang'wa Yesu ahume kumubulaga. ");
INSERT INTO isn_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Aamutungile, aeamutongee, ekamupisha kung'wa Liwali Pilato. ");
INSERT INTO isn_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Hange ematungo ang'wa Yuda, naeumusalitile, auinekina u Yesu wahukumilwa wikaambwa masego wekasusha epande thelathini niya mpia kwa akulu neamakuhani neanyampala. ");
INSERT INTO isn_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Wikalunga, “Nituma melandu kumesaliti usakami nengila anga mulandu.” Lakini ekamusukelya, “Akuhusile ntuni? Magoze nanso uewe.” ");
INSERT INTO isn_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Hange wikaguma pihe ipande nianso nesalani niya mpia mihekalu, wekahega yakwe wekigoga ung'wenso. ");
INSERT INTO isn_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Umukulu wa Makuhani wekaihola ipande niyanso neampia nukulunga, “Singa inonene kuieka impia iziite muhazina, kunsoko agalama asakami.” ");
INSERT INTO isn_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ekikolya kwa palung'wi empia ekutumeka kuguila umugunda nelamufinyanzi nelakiieka eageni. ");
INSERT INTO isn_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kunsoko eyeite umugunda nuanso ukitangwa, “Mugunda wa sakami” ata elelo yeye. ");
INSERT INTO isn_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Hange ulukani naelutambuwe numunyakedagu u Yeremia lekatimila, kulunga, “Aeatumie ipande salasini niya mpia, egalama naepangilwe neantu a Israeli kunsoko akwe, ");
INSERT INTO isn_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","na ae ametumie kumugunda wamufinyanzi, kina Mukulu naeundagie.” ");
INSERT INTO isn_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Imatungo yayo u Yesu wekimika ntongeela ang'wa liwali nuliwali wakamukolya, “Ite uewe umutawala wa Ayahudine? U Yesu wikamusukelya, “Wewe ulungile ite.” ");
INSERT INTO isn_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Lakini ematungo nae usemewe neakulu amakahani neanyampala, shanga aeusukeye lehi. ");
INSERT INTO isn_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Hange u Pilato wekamuila, “Shangawigule anga mashitaka ehi kung'wako?” ");
INSERT INTO isn_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Lakini singa aeumusukeye ata ulukani nulung'wi, kuite uliwali wakizula uwoa. ");
INSERT INTO isn_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kumatungo na sikukuu ae desituli aa liwali kumutungula umutungwa ung'wi nusaguwe numilundo. ");
INSERT INTO isn_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ematungo nanso aeakete mutungwa ung'wi sugu elina lakwe Balaba. ");
INSERT INTO isn_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kuite imatungo naeatuile kilundela palung'wi, u Pilato wekaakolya, “Nyenyu nemutakile kumutungule kunso anyu?” Balaba ang'wi Yesu nukitangwa Kilisto?” ");
INSERT INTO isn_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kunsoko aeuine kina amuamba kunsoko amubepewe. ");
INSERT INTO isn_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Imatungo naeakoli ikie mituntu la ulamuli, umusungu wakamutumela lukani nukulunga, “Lekakituma lukani lehi kumuntu uyuite numugila anga ubee, kuite nsumbukile ikulu eleleye mundoti kunsoko akwe.” ");
INSERT INTO isn_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Uu eakulu amakuhani neanyampala aashawishilye emakutano amulompe u Balaba, nu Yesu abulagwe. ");
INSERT INTO isn_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","U Liwali aiuwakoiye, “Nu uli kati a abiili muloilwe unene numulekele kitalanyu?” Ailigitilye “Balaba.” ");
INSERT INTO isn_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","U Pilato wikaaela, “Numutendele ntuni u Yesu nukitangwa Kilisto?” Ehi ekasukelya “Msulibishe.” ");
INSERT INTO isn_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nung'wenso wikalunga, “Kuneke ikosake nuitumile? Lakini aeazidilye kukulya induli yao migulya ikulu, “Musulubishe.” ");
INSERT INTO isn_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kuite imatungo u Pilato auine shangauwezilye kituma lukani lehi, lakini badalakwe efujo ekanza, wikahola emaze wekakaala emekono akwe ntongeela amilundo, nukulunga, “Unene numugila anga ubee kusakami wa muntu uyuite numugila ubee. Magozi ayaite unyenye.” ");
INSERT INTO isn_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Antu ehi ekalunga, “Usakami akwe watule migulya itu neana itu.” ");
INSERT INTO isn_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Hange wikamutungwila u Balaba kung'wao, lakini aeumukuile emesheleti u Yesu wekamukabidhi kung'wao alongole amusulubishe. ");
INSERT INTO isn_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Hange easkale ang'wa liwali akamuhola u Yesu mpaka Praitorio numilundo nuamaskali ehi ekilundeela. ");
INSERT INTO isn_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Akamutugula eang'wenda akwe nukumutugala ung'wenda nualangi nkuuku. ");
INSERT INTO isn_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Hange akazepya etaji amija nukumueka migulya itwe lakwe, na amuekeye mwanzi kumukono wakwe nuakegoha. Aeakuieli imalu ao pihe ntongela akwe nukumuhonda ekalunga, “Salamu, Mutemi wa a Yahudi?” ");
INSERT INTO isn_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Na amutyie emate, na aeahoile umuanzi ekamukua kitwe. ");
INSERT INTO isn_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ematungo naeakumugema, ukumutugula ung'wenda nuanso ekamutugala eang'wenda akwe, ekamulongolya kenda kumusulubisha. ");
INSERT INTO isn_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Naapumile kunzi, ekamuona muntu aeupumie ku Krene elina lakwe Simeoni, hange amulazimishilye kenda nenso kuite aukenke umusalaba wakwe. ");
INSERT INTO isn_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Naeapikile pang'wanso niitangwa Goligota, endogoelyo akwe ieneo li fuvu litwe.” ");
INSERT INTO isn_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Amupee esiki nehangigwe nenyongo wang'we. Lakini naeumionzile, shanga wikaweza kumeng'wa. ");
INSERT INTO isn_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Imatungo naamusulubishilye, ae agalanile e ang'wenda akwe kwa kuikuela kula. ");
INSERT INTO isn_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Na aeikie kwa kumugoza. ");
INSERT INTO isn_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Migulya mitwe lakwe aaekile mashitaka akwe ekasomeka, “Uyuite Yesu, mutemi a Wayahudi.” ");
INSERT INTO isn_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ee nyang'anyi abeele ekasulubiwa palung'we nung'wenso, ung'wi mukono wakulela ung'wi mukono wankege. ");
INSERT INTO isn_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Awa naakeile ekamutanela, ekaze hingisa ematwe ao, ");
INSERT INTO isn_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","nukulunga, “Uewe wewe nautakile kulizepya ihekalu nukulezenga kwa nsiku itatu, iokoe uewe! Angiza wang'wa Itunda, sima pihe uhege pa msalaba!” ");
INSERT INTO isn_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kumatungo ehali yeyo yeyo ekulu a makuhani aeakumukashifu, palung'wi neaandeki neanyampala, nukulunga, ");
INSERT INTO isn_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Aeuaokoe neangiza, lakini shangauwezilye kiokoa ung'wenso. Nuanso Mutemi wa Ayahudi. Nuasime pihe kupuma mumusalaba, kunso aulungile, unene neng'wa Itunda kuite kumuhuela. ");
INSERT INTO isn_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Aeumuhue Itunda. Leki Tunda wamuokoe angeza utakile kunsoko aeulungile, “Unene neng'wana wang'wa Itunda.” ");
INSERT INTO isn_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nawoite enyanyanyi namusulubishilye palung'wi nung'wenso ga atambue makani akumudhihaki. ");
INSERT INTO isn_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Imatungo yayo nasaa sita ikatula kiti mihe ehi mpaka esaa tisa. ");
INSERT INTO isn_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Naepikile esaa tisa, u Yesu wikalela kusauti nenkulu, “Eloi, Eloi, Lama thabakithani?” wikamaanisha “Itunda ane, Itunda ane, mbona wandeka?” ");
INSERT INTO isn_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ematungo nanso ang'we ao aeimekile pang'wanso aigulye, ekalunga, Ukumitanga Eliya.” ");
INSERT INTO isn_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Akamanka ung'wi kuhola sifongo nukizulya ekinywaji nekelulu, ekameeka migulya mumute ekamupa wang'we. ");
INSERT INTO isn_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nao nasagile ekalunga, “Muleki wing'wene, leki kuone kina u Eliya weze muguna.” ");
INSERT INTO isn_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","U Yesu wikalela hange kwa luli nulukulu wekameheja enkolo akwe. ");
INSERT INTO isn_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Goza, Ipazia li itekeelo ailitamukile nkika ibeele kupumila migulya kupikiila pihi. Ni ihi ikakagaka ni matalagwe ikatamuka ipande. ");
INSERT INTO isn_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Emakabuli akaluguka nemeele atakatifu edu nualae utulo akioka. ");
INSERT INTO isn_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ekapuma mumakabuli baada aa uiuki wakwe, ekingila mumuji nuutakatifu ekigeeleka edu. ");
INSERT INTO isn_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Uakida nuanso nawa naamugozee u Yesu ekaona itetemeko nemakani naakupumela, ekisula uwoa kule nukulunga, “Etai uyu aeng'wana wang'wi Tunda.” Ekagoza kupuma kule. ");
INSERT INTO isn_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Aasungu edu amutyatile u Yesu kupuma ku Galilaya ahume kumuhudumela akoeakole pang'wanso ekagozeela kupuma kule. ");
INSERT INTO isn_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mukatekate ao aeukole u Mariamu Magdalena, Mariamu mama akwe Yakobo nu Joseph, nu mama waana ang'wa Zebedayo. ");
INSERT INTO isn_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Naepikile mpende awezile muntu mugole kupuma Arimathaya, nae witangwa Yusufu, kuite nuyu nuanso aemumanyisigwa wang'wa Yesu. ");
INSERT INTO isn_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Aewendile kung'wa Pilato wekalompa umeele wang'wa Yesu. Kuite u Pilato wekalagelya apegwe. ");
INSERT INTO isn_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","U Yusufu wekauhola umweele akautunga ung'wenda numuza, ");
INSERT INTO isn_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","wekaulalesha mikabuli nipya naeulezepilye wekalechonga mumwamba. ");
INSERT INTO isn_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","U Mariamu Magdalena nu Mariamu numungiza akole hapo aeikie kugozela ikabuli. ");
INSERT INTO isn_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Uluhiku nautyatie kina uluhiku nula maandalio, e akulu amakuhani ne Mafarisayo aeilingee palung'wi kung'wa Pilato. ");
INSERT INTO isn_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ekamuela, “Mukulu kukembukile kina imatungo nuanso numudanganyifu naeukele ukole mupanga, aulungile, Baada amahiku atatu ukiioka hange. ");
INSERT INTO isn_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kululo lagilya kina ikabuli lelindwe salama mpaka uluhiku lakatatu. Kuite, eamanyisigwa akwe awezilye kezakumia nukulunga kuantu, “Wioka kupuma mwaashi. Nuudanganyifu wamwisho ukutula ubee kukela naakwanza. ");
INSERT INTO isn_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","U Pilato wekaaela, “Holi ealinzi. Longoli mitume muhali ausalama pamuwezeye.” ");
INSERT INTO isn_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kuite akalongola nukituma pikabuli kutula usalama ukole, igwe lekagongwa umuhuli nukueka ealinzi. ");
INSERT INTO isn_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Baadaye empende uluhiku la Sabato, elyoa naelakapuma kuhumbela luhiku lang'wandyo nulijuma, Mariamu Magdalena, nu Mariamu numungeza azele kulegoza ikabuli. ");
INSERT INTO isn_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Goza aelekole itetemeko ikulu, kunsoko umalaeka wang'wa Mukulu ausimile wekalepingilitya igwe, hange wekikaela. ");
INSERT INTO isn_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Esula akwe ae ehanganga umeme, neang'wenda akwe ae elu anga etheluji. ");
INSERT INTO isn_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ealinzi neanso ekizula uwoa ekatu anga eashi. ");
INSERT INTO isn_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Umalaeka nuanso wekaalengasa easungu neanso wekalunga,'' lekikogopi kondogoelye mine kina mukumuduma Yesu, nausubiwe. ");
INSERT INTO isn_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ukutile apaite, Lakini wioka anga naeumuie. Pembyi muone Ubwana pana aulae. ");
INSERT INTO isn_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Longoli halaka muaele emanyisigwa akwe, wiuka kupuma mwashi, goza wamutongeela ku Galilaya. Kung'wanso kukomukumuona. Gozi unene namuela.'' ");
INSERT INTO isn_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Easungu neanso ekahega pang'wanso pikabuli halaka ekaze akete uwoa ao niloeligwi ikulu, hange ekamanka kuaela eamanyisigwa akwe. ");
INSERT INTO isn_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Goza U Yesu wikatankana neenso nukulunga,''Salamu,'' Easunguneanso aeazile ekaamba emegulu akwe, hage ekamukulya. ");
INSERT INTO isn_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ite U Yesu wekaaela,'' lekikogopi, Longoli muaele eanya ndugu akwe atongele Kugalilaya. Kung'wanso akumona.'' ");
INSERT INTO isn_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ematungo nanso easungu naalongoe, goza baadhi aalinzekenda kumujini nukuaela aekulu amkuhani emakani ehinaapumie. ");
INSERT INTO isn_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Emakuhani naatankanile neanyampala kikoelya emakani nanso palug'wi neenso, Aeapumilye keasi kekulu nekampia kwa alinzi neanso. ");
INSERT INTO isn_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ekaaela,'' Aeli neangiza ite, Eamanyisigwa ang'wa Yesu aeazile utiku ekia umweele wang'wa Yesu imatungo usese azakulae. ");
INSERT INTO isn_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Hange etaalifa eye angemupikile uliwali, usese kuumushawishi nukumuhegelya unyenye emashaka ehi.'' ");
INSERT INTO isn_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kuite easkali neanso ekaihola impia ninyanso nukituma anga naalagewe. Impola izi ikenela kule kwa ayahundi nayatuile uu mpaka elelo. ");
INSERT INTO isn_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Lakini ametume neanso kumi na moja ekalongola ku Galilaya, kumulema nuanso naualagie. ");
INSERT INTO isn_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Neenso namuine, ekamukulya, lakini baadhi ao ekakisha. ");
INSERT INTO isn_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","U Yesu wekeza kung'waao wekaaela wekalunga,'' Mpewe uhumi wehi muunkumbigulu nukilunde. ");
INSERT INTO isn_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kuite longoli muaifanye indugu yehi itule amanyisigwa ane. Abadisi kulina lang'wa Tata. nele nela ng'wana nu ng'wa ung'welu. ");
INSERT INTO isn_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Amanyisi kumaamba emakani ehi naenumuie, Goza unenkole palung'wi nunyenye mahiku ehi. mpaka empelo aunkumbigulu. ");
INSERT INTO isn_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Uwu ingi ng'wandyo nua nkani ninza niang'wa Yesu Kristo, Ng'wana wang'wa Itunda. ");
INSERT INTO isn_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Anga ni ikilisigwe nu munyakidagu uIsaya, “Gozeela, kumulagiilya u mutung'wa nuane ntongeela ako, ung'wi nuikazipiilya i nzila niako. ");
INSERT INTO isn_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Luli nula muntu nuitangaa mihaka, “Mikondeelyi i nzila a Mukulu; Igooli i nzila niakwe.” ");
INSERT INTO isn_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","uYohana ai uzile, wazoja mihaka nu kutanantya wogigwa nua kila itunu ku ulekelwa nua milandu. ");
INSERT INTO isn_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ihi ihi a ku Yudea ni antu ihi nia ku Yerusalemu ai alongoe kitalakwe. Ai atulaa akogigwa nu ng'wenso mu mongo nua Yordani, aze ila itunu ku milandu ao. ");
INSERT INTO isn_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","uYohana ai watulaa utugae ng'wenda nua mauli a ngamia nu mukoha nua ndili mu kilino nikakwe, hangi ai watulaa ukulya ngaga nu uki nua mihaka. ");
INSERT INTO isn_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ai utanantilye nu kuligitya, “Ukoli ung'wi upembilye ze yakilaa unene munya ngulu ikolo kukila unene, hangi nimugila u unoneli ga nu kutuna pihi nu kutungula i mikoha a ilatu niakwe. ");
INSERT INTO isn_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Unene ai numogilye ku mazi, kuiti nuanso ukumoja unyenye ku Ng'wau Ng'welu.” ");
INSERT INTO isn_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ai ipumie mu mahiku nanso kina uYesu ai uzile kupuma ku Nazareti a ku Galilaya, hangi ai wogigwe nu Yohana mu mongo nua Yordani. ");
INSERT INTO isn_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Itungo uYesu nai uhumbukile kupuma mu mazi, ai wihengile ilunde ligalanukile ng'walyi nu Ng'wau Ng'welu ukusima pihi migulya akwe anga i nkunda. ");
INSERT INTO isn_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nu luli ai lupumiie milunde, “ Uewe ingi Ng'wana nuane mulowa, Ndoeigwe nangaluu nu ewe.” ");
INSERT INTO isn_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Uugwa nkua ing'wi u Ng'wau Ng'welu akamusinja kulongola mihaka. ");
INSERT INTO isn_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ai ukoli mihaka mahiku makumi anne, wazegeng'wa nu Mulugu, Ai watulaa palung'wi ni ikali nia mihaka, nia malaika ai amuaiiye. ");
INSERT INTO isn_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Itungili ze yakilaa uYohana kuambwa, uYesu ai uzile ku Galilaya wazetanantya inkani ninza niang'wa Itunda, ");
INSERT INTO isn_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","wazeligitya, “Itungo lakondaniila, nu utemi nuang'wa Itunda wahumbeela. Ili itunu nu kuhuiila mu nkani ninza.” ");
INSERT INTO isn_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Hangi wazekila mu mpelo a luzi nula Galilaya, ai umihengile uSimioni nu Andrea muluna wang'wa Simioni azegumila i nyavu niao mu luzi, kunsoko ai atulaa avua nsamaki. ");
INSERT INTO isn_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","uYesu ai uatambuie, “Pembyi, ntyati, hangi kumuzipya avua antu.” ");
INSERT INTO isn_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ni nkua ing'wi ai alekile i nyavu hangi akamutyata. ");
INSERT INTO isn_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Itungo uYesu naiwagenda kahelu iniino, ai umihengile uYakobo ng'wana wang'wa Zebedayo nu Yohana muluna nuakwe; ai atulaa mi ilinga akuzipya nyavu. ");
INSERT INTO isn_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Katungo akaitanga ni enso ai amulekile u tata nuao uZebedayo mukati ilinga ni anyamulimo nia kugulwa, akamutyata. ");
INSERT INTO isn_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nai akapika ku Kapernaumu, luhiku nula kusupya, uYesu ai wingie mi itekeelo nu kumanyisa. ");
INSERT INTO isn_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Aka ukuilwa u umanyisa nuakwe. ku iti ai watulaa ukuamanyisa anga muntu naiza ukete uhumi hangi shanga anga amanyi. ");
INSERT INTO isn_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Itungo lilo liilo ai ukoli nu muntu mi itekeelo nilao nai ukete nu hing'wi, hangi ai uzogooye, ");
INSERT INTO isn_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","wazeligitya, “Kukete ntuni nika kituma nu ewe, Yesu nua ku Nazereti? Uzile ku ulimilya? Nukulingile wi nyenyu. U ewe ingi Ng'welu wing'wene nuang'wa Itunda!” ");
INSERT INTO isn_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","uYesu ai umukenee u hing'wi nu kuligitya, “Kilaga hangi upume mukati akwe!” ");
INSERT INTO isn_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nu hing'wi ai umugwisilye pihi hangi akapuma kitalakwe itungo wazelila ku luli nula migulya. ");
INSERT INTO isn_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ni antu ihi ai akuiwe, iti gwa akikolya kila ung'wi, “iki ingi ntuni? Umanyisa ugeni ukete uhumi? Ga nukulagiilya ia hing'wi nienso aku mukulya!” ");
INSERT INTO isn_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nu lukani kutula ng'wenso nkua ing'wi lukasapatila kila kianza mukati a mukoa wihi nua Galilaya ");
INSERT INTO isn_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Hangi nkua ing'wi ze yakilaa kupuma kunzi itekeelo, ai ingi mi ito nilang'wa Simioni nu Andrea aze akoli nu Yakobo nu Yohana. ");
INSERT INTO isn_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Itungili mukwingwa nuang'wa Simioni ai watula ulae mulwae, ni nkua ing'wi ai amutambuie uYesu inkani niakwe. ");
INSERT INTO isn_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iti gwa ai uzile, ai umuambile ku mukono, nu kumunyansula migulya; ulwae ukahega kitalakwe, hangi wakandya ku a aiilya. ");
INSERT INTO isn_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mpindi nanso itungo ilyoa lakondya kulimila, ai amuletee kitalakwe ihi nai atulaa alwae, ang'wi nai akete i ahing'wi. ");
INSERT INTO isn_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kisali kihi ai kilingiie palung'wi pa mulango. ");
INSERT INTO isn_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ai uagunile idu nai atulaa alwae a kila ulwae nu kupumya ahing'wi idu, ila shanga ai ulekee hing'wi kuligitya ku nsoko ai amulingile. ");
INSERT INTO isn_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ai u ukile dau maniabwa, itungo nai ikili kiti; ai uhegile nu kulongola nkika a kinkunku nu kulompa kuko. ");
INSERT INTO isn_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","uSimioni ni ihi nai atulaa palung'wi nu ng'wenso ai amudumile. ");
INSERT INTO isn_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ai amuligilye hangi akamutambuila, “Kila ung'wi uku uduma” ");
INSERT INTO isn_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ai uatambuie, “Kwini kianza kingiiza, kunzi mu isali ni ipilimikiiye, iti nihume kutanantya nuko ga. Yiyo nsoko aza nzile apa.” ");
INSERT INTO isn_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ai ulongoe waze ukiie i Galilaya ihi, waze tanantya mu matekeelo ao nu kuapatya ia hing'wi. ");
INSERT INTO isn_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Munya mbili ung'wi ai uzile kitalakwe. Ai watulaa ukumusinja; ai utugamile nu kumutambuila, “Anga ize uloilwe, uhumile kunzipya ntule ni muza.” ");
INSERT INTO isn_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Waze usuntilwe ni kinya uwai, uYesu ai ugooe u mukono nuakwe nu kumuamba, akamuila, “Ndoilwe, Utule u muza.” ");
INSERT INTO isn_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Itungo ling'wi i mbili ikamupuma, hangi ai uzipigwe kutula muza. ");
INSERT INTO isn_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","uYesu akamukania itaki nu kumuila walongole itungo ling'wi. ");
INSERT INTO isn_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ai umutambuie, “Kendegeela shanga uligitilye lukani ku wihi, kuiti longola, wiambye kung'wa kuhani, hangi upumye isongelyo ku nsoko a weligwa naiza uMusa ai ulagiiye, anga ukuiili kitalao.” ");
INSERT INTO isn_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kuiti ai ulongoe nu kandya kumutambula kila ung'wi nu kenelya u lukani ikilo ga nu Yesu shanga ai uhumile hangi kingila mu kisali ku ulyuuku. Iti gwa ai wikiie kianza nika kinkunku ni antu ai azile kitalakwe kupuma kila nkika. ");
INSERT INTO isn_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nai usukile ku Kapernaumu ze yakilaa mahiku masheenyu, ai ikumukile kina ai ukoli mi ito. ");
INSERT INTO isn_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Antu idu nangaluu ai atulaa ilundiie pang'wanso hangi shanga ai limoli i lyoma hangi, ga nilo nila pa mulango, nu Yesu ai uligitilye lukan kitalao. ");
INSERT INTO isn_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Uugwa ang'wi a antu ai azile kitalakwe nai amuletile muntu nai watulaa ukule igandi; antu anne ai atulaa amukenkile. ");
INSERT INTO isn_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Itungo nai alemilwe kumuhumbeela kunsoko a iubi nila antu, ai agumue migulya a kianza pang'wanso nai ukoli. Hangi nai atula akondyaa kutobola ibolomyo, ai asimilye u ulili naiza u muntu nai ukule igandi ai watulaa ulae. ");
INSERT INTO isn_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nai wihengile u uhuiili nuao, uYesu ai umutambuie u muntu nai ukule igandi, “ng'waane, i milandu ako alekelwa.” ");
INSERT INTO isn_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Kuiti ang'wi ao a amanyi awo nai akoli ikie pang'wanso ai ikoiye mu nkolo niao. ");
INSERT INTO isn_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Uhumile uli u muntu uyu kuligiya iti? Uku kuna! Nyenyu nuihuma kulekela i milandu kwaala Itunda wing'wene duu?” ");
INSERT INTO isn_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Itngo uYesu nai ulingile mu nkolo akwe nai atulaa akusiga mukati ao akola. Ai ua tambuie, “Ku niki mukusiga iti mu nkolo nianyu? ");
INSERT INTO isn_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ni liuli ni ipepeele ikilo kuligitya ku muntu nu kule igandi, 'Milandu ako alekelwaa' ang'wi kuligitya 'imike, hola u ulili nuako, hangi uende?' ");
INSERT INTO isn_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kuiti iti alije kulinga kutula u Ng'wana nuang'wa Adamu ukete u humi nua kulekela i milandu mi ihi, ai umutambuie uyo nai ukule igandi. ");
INSERT INTO isn_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nukutambuie u ewe, nyansuka, hola u mukeka nuako, hangi ulongole kito nilako.” ");
INSERT INTO isn_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ai wimikile hangi nkua ing'wi akahola u mukeka nuakwe, hangi ai ulongoe kunzi a numba ntongeela a kila muntu, iti ihi ai akuiwe hangi akaminkiilya Itunda ikulyo, hangi akaligitya “Nangaluu, kukili kaya kihenga ikani anga ili.” ");
INSERT INTO isn_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ai ulongoe hangi mpelo a luzi, ni iumbi lihi nila antu ai azile kitalakwe, hangi waka amanyisa. ");
INSERT INTO isn_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nai watula ukukila ai umihengile uLawi ng'wana wang'wa Alfayo wikie mu nkika a kuhanguilya i kodi hangi akamuila, “Ntyate.” Ai wimikile nu kumutyata. ");
INSERT INTO isn_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Hangi itungo uYesu nai watulaa ukulya indya mu nyumba ang'wa Lawi, ahangulya kodi idu ni antu niakete i milandu ai atulaa akulya nu Yesu ni amanyisigwa akwe, ku nsoko ai atulaa idu ni enso ai amutyatile. ");
INSERT INTO isn_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Itungo i amanyi, naza atulaa Afarisayo, nai akihenga kina uYesu ukulya ni antu anya milandu ni ahangulya kodi, ai a atambuie i amanyisigwa akwe, “Ku niki ukulya ni ahangulya kodi ni anya milandu?” ");
INSERT INTO isn_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Itungo uYesu nai wakija iti ai uatambuie, “Antu niakete u upanga mu muili shanga amutakile u mukiliki; Ingi antu nia lwae ing'wene wawo amutakile. Shanga ai nzile kuitanga i antu niakete itai ane, kuiti antu ni akete i milandu.” ");
INSERT INTO isn_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Amanyisigwa ang'wa Yohana ni Afarisayo ai atulaa akudilya kulya. Hangi ang'wi a antu ai azile kitalakwe nu kumuila, “Ku niki i aanyisigwa ang'wa Yohana ni Afarisayo idila kulya, kuiti i amanyisigwa ako shanga akudila kulya? ");
INSERT INTO isn_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","uYesu ai uatambuie, “Itii niamoli mu winga ahumile kudila kulya itungo u mukulu nua winga waze utuile ukoli palung'wi ni enso? ku lihi u mukulu nua winga anga watule ukoli palung'wi ni enso shanga ahumile kudila kulya.” ");
INSERT INTO isn_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kuiti mahiku apembilye itungo u mukulu nua winga nuika hegigwa kitalao, nu mu mahiku nanso ni enso akudilya kulya. ");
INSERT INTO isn_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Kutili u muntu nuihilita i kilaka ni kigeni nika ng'wenda mu ng'wenda nui taho, anga itule i kilaka kikutaluka kupuma mu nilanso, ni kigeni kitaluka kupuma mi itaho, hangi ikutula nu utamukwaa ubibi. ");
INSERT INTO isn_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kutili muntu wihi nuikitila i magai ni maza mu ntunda ni nkakilu, anga itule iti imagai akubadula i ntunda hangi yahi ibiili magai ni itunda ikulimila. Badala akwe, ika imagai ni maziza mu ntunda ni nziza. ");
INSERT INTO isn_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mu luhiku nula kusupya uYesu ai ukiile mu migunda ing'wi, ni amanyisigwa akwe akandya kuhola imatita ang'wi a ngano. ");
INSERT INTO isn_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ni Afarisayo akamuila, “Goza, ku niki akituma i kintu naiza ingi nsuta ni ilagiilyo mu luhiku nula kusupya?” ");
INSERT INTO isn_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ai uatambuie, “Shanga ai musomile iko nai witumile uDaudi nai watula mu u ula nua nzala—Ng'wenso palung'wi ni antu nai akoli palung'wi nu ng'wenso? ");
INSERT INTO isn_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Iti nai ulongoe mu ito nilang'wa Itunda itungo nilang'wa Abiathari nai watulaa kuhani nu mukulu nu kulya u mukate nai uikilwe ntongeela—naza ituile nsuta a malagiilyo ku muntu wihi kulya kwaala akuhani— hangi ai uinkiiye ga ni ang'wi a awo nai atulaa palung'wi nu ng'wenso ");
INSERT INTO isn_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","uYesu ai uligitilye, U luhiku nula kusupya ai litumilwe ku nsoko a ana adamu, shanga ng'wana adamu ku nsoko a luhiku nula kusupya. ");
INSERT INTO isn_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ku lulo, u Ng'wana nuang'wa Adamu ingi mukulu, ga kuluhiku nula kusupya. ");
INSERT INTO isn_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ni hangi ai wingie mukati itekeelo nu mung'wanso ai umoli muntu ukete mukono ukule igandi. ");
INSERT INTO isn_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ang'wi a antu ai atulaa akumutyatiila ku ukupi kihenga kina anga ize ukuguna luhiku nula kusupya iti kina amusemele. ");
INSERT INTO isn_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","uYesu ai umutambuie u muntu nu kete u mukono ukule igandi. “Humbuka wimike pakati i umbi ili.” ");
INSERT INTO isn_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Uugwa aka atambuila i antu. “Itii ingi taine kituma mulimo nu uza luhiku nula kusupya ang'wi kituma ni shanga tai ane; Kunguna likalo ang'wi kubulaga?” Kuiti akasaga ihi twi. ");
INSERT INTO isn_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Aka agozeela ku ikuo, waze uhukilye ku nsoko a ukaku nua nkolo niao, hangi akamutambuila u muntu uyo, “Goola u mukono nuako.” akaugoola nu Yesu akamuguna u mkono nuakwe. ");
INSERT INTO isn_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Afarisayo akalongola kunzi hangi itungo akazipya isui palung'wi ni Aherode ku ng'waakwe iti kumubulaga. ");
INSERT INTO isn_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Uugwa uYesu, palung'wi ni amanyisigwa akwe, ai alongoe mu luzi, ni i umbi ikulu nila antu ai limutyatile ize lipembeeye ku Galilaya nu ku Uyahudi ");
INSERT INTO isn_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","nu kupuma ku Yerusalemu nu kupuma ku Idumaya ntongeela a Yorodani ni kisali nika Tiro ni Sidoni, i umbi ikulu, nai likija kila i kintu nai watulaa ukituma, akapembya kitalakwe. ");
INSERT INTO isn_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Hangi ai uatambuie i amanyisigwa akwe kuzipiilya u mulinga nu uniino ku nsoko akwe ku nsoko a iumbi, iti kina aleke kumutunyiilya. ");
INSERT INTO isn_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ku nsoko ai ugunile idu, iti kila u muntu nai watulaa nu lwago ai watulaa ni nsula a kumupikiila iti wamuambe. ");
INSERT INTO isn_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Pihi i ahing'wi nai amuine, ai agwie pihi ntongeela akwe nu kulila, nu kuligitya, “U ewe ingi wi Ng'wana wang'wa Itunda.” ");
INSERT INTO isn_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ai ualagiiye ku kukomangiila aleke kituma wakumuke. ");
INSERT INTO isn_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ai ulongoe migulya a lugulu, nu kuitanga nai ualoilwe, hangi akalongola kitalakwe. ");
INSERT INTO isn_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Aka aholania ikumi na abiili (nai uitangile itumi), iti kina atule palung'wi nu ng'wenso hangi wahume kualagiilya kutanantya, ");
INSERT INTO isn_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","nu kutula nu uhumi nua kupumya i ahing'wi. ");
INSERT INTO isn_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Hangi aka aholania ikumi na abiili; Simioni nai uminkiiye ilina nila Petro, ");
INSERT INTO isn_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobo ng'wana wang'wa Zebedayo, nu Yohana muluna nuakwe u Yakobo, nai winkiigwe i lina nila Bonagesi, awo ingi, ana nia mulilo, ");
INSERT INTO isn_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","nu Andrea, Filipo, Bartholomayo, Mathayo, Tomaso, Yakobo ng'wana wang'wa Alfayo, Thadayo, Simioni Mukananayo, ");
INSERT INTO isn_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","nu Yuda Iskariote, naiza uku mugumaniilya. ");
INSERT INTO isn_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Uugwa ai ulongoe ki ito, ni umbi nila antu akapembya palung'wi hangi, aleng'we ga nu kulya ga nu mukate. ");
INSERT INTO isn_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Familia akwe nai akija u lukani nulanso, akalongola kumuamba, kuiti akaligitya, “Waputwa ni mahala.” ");
INSERT INTO isn_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Amanyi nai azile kupuma ku Yerusalemu ai aligitilye, “Uhalinkaniwe nu Beelzebuli,” nu “Ku mukulu nua a hing'wi ukupumya i a hing'wi.” ");
INSERT INTO isn_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","uYesu ai uitangile kitalakwe nu kuligitya ni enso ku mpyani, “Kinya uli uMulugu wahume kumupumya uMulugu? ");
INSERT INTO isn_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Anga ize utemi ukugalanuka ukola, utemi nuanso shanga uhumile kimika. ");
INSERT INTO isn_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Anga ize ito likugalanuka ikola, ito nilanso shanga lihumile kimika. ");
INSERT INTO isn_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Anga ize uMulugu ukunyansuka nsuta akwe mukola nu kugalanuka, hangi ukutula wapika mpelo akwe. ");
INSERT INTO isn_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kuiti kutili ga nung'wi nuhumile kingila mukati ito nila muntu ni munya ngulu nu kia i intu niakwe bila kumutunga u munyangulu hanza, hangi uugwa kilingiila ni kimoli mi ito. ");
INSERT INTO isn_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Tai kumutambuila, milandu ihi nia ana a antu ikulekelwa, palung'wi nu ukuni naza akutambula, ");
INSERT INTO isn_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","kuiti wihi nuika mukuna u Ng'wau Ng'welu shanga ukulekelwa lukulu, ila ukete ugazi nua mulandu nua kali na kali.” ");
INSERT INTO isn_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","uYesu ai ulitambue ili ku nsoko ai atulaa akuligitya, “Ukete hing'wi.” ");
INSERT INTO isn_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Uugwa u nyinya nuakwe ni aluna akwe ai apembilye nu kimika kunzi. Akamulagiilya muntu, kumitanga. ");
INSERT INTO isn_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ni iumbi nila antu nai latulaa likie pakupi nu ng'wenso akamutambuila, “u ia ako ni aluna ako akoli kunzi, hangi akuuduma u ewe.” ");
INSERT INTO isn_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ai uasukiiye, “Ingi nyenyu u ia ane ni aluna ane?” ");
INSERT INTO isn_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ai uagozee nai atulaa ikie amupilimikiiye, nu kuligitya, “Goza, awa ingi a ia ane ni aluna ane! ");
INSERT INTO isn_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Wihi nuitumaa u ulowa nuang'wa Itunda, muntu nuanso ingi muluna ane, hangi ng'waitu, hangi ia ane.” ");
INSERT INTO isn_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Hangi ai wandilye kumanyisa mu mpelompelo a luzi. Ni iumbi ikulu likilundiila likamupilimikiilya, akingila mukati i ilinga mu luzi, nu kikie. Iumbi lihi nai likoli mu mpelo a luzi mu nshemba. ");
INSERT INTO isn_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Hangi aka amanyisa makani idu ku mpyani, hangi akaligitya kitalao ku umanyisa nuakwe. ");
INSERT INTO isn_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Tegeelyi, mutemeli ai ulongoe kutemela. ");
INSERT INTO isn_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nai wakatula ukutemela, ing'wi nia mbeu ai igwie mu nzila, ni nyunyi ikapembya ikailya. ");
INSERT INTO isn_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mbeu i nzuya ai igwie mu matalagwe, naiza kutili ni mahalu idu. Itungo ikanyala, ku nsoko ai ngila anga mahalu nakondaniie. ");
INSERT INTO isn_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kuiti i lyoa nai litolokile, ai inyaile, ku nsoko ai ngila anga mili, ikuma. ");
INSERT INTO isn_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mbeu inzuya ai igwie pakati a mija. iMija ikakula nu kuitunyiilya, hangi shanga ikapa inkali yihi. ");
INSERT INTO isn_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mbeu i nzuya ai igwie mu mahalu ni maza hangi ai ipee i nkali itungo nai yukukula nu kungeeleka, inzuya ai ipee nkua makumi ataatu ikilo, ni nzuya makumi mutandaatu, ni nzuya igana.” ");
INSERT INTO isn_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Hangi wakaligitya, “Wihi nukete i akutwi ni akija, nu ije!” ");
INSERT INTO isn_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","uYesu nai wakatula wing'wene, awo nai akoli pakupi nu ng'wenso nawo ni ikumi na abiili ai amukoiye kutula i mpyani. ");
INSERT INTO isn_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Akaligitya kitalao, “Kitalanyu minkiigwe kinkunku nika utemi nuang'wa Itunda. Kuiti ku niakoli kunzi kila i kintu ingi mpyani, ");
INSERT INTO isn_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","iti anga agoze, uu igoza, kuiti shanga ihenga, hangi ku lulo niakija uu ijaa, kuiti shanga ilinga, anga ize shanga uu aza azee mupiluka Itunda ai uzee alekela.” ");
INSERT INTO isn_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Hangi akaligiya kitalao, “Itii shanga mulingile i mpyani iyi? Mukuhuma uli kulinga i mpyani ni ingiiza? ");
INSERT INTO isn_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mutemeli ai utemee lukani. ");
INSERT INTO isn_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ing'wi ingi awo nai agwie mu mpelo a anzila, kianza u lukani naza lutemewe. Hangi nai igulye, itungo u Mulugu akapembya nu kuluhola u lukani naiza lutemewe mukati ao. ");
INSERT INTO isn_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Hani ang'wi ao ingi awo nai atemewe migulya amatalagwe, naza, nai igulye u lukani, ku ukau akulusingiilya ku ulowa. ");
INSERT INTO isn_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Hnagi agila imili ihi mukati ao, kuiti igimya ku itungo ikupi. Halafu lwago nu wagigwa ni ipembilye ku nsoko a lukani, itungo ikumpyaa. ");
INSERT INTO isn_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Hangi ang'wi ingi awo nai atemewe mu mija. Akulija u lukani. ");
INSERT INTO isn_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Kuiti unyong'wa nu ihi. ukongelwa nua nsao, ni nsula a makani mangiiza, wi ingiila nu kulutunyiilya u lukani, nu kuleng'wa kupaa inkali. ");
INSERT INTO isn_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Uugwa akoli awo naza atemewe mu mahalu ni maza. Akulija u lukani nu kulusingiilya nu kupa i nkali; ang'wi makumi ataatu, hangi ang'wi makumi mutandatu, hangi ang'wi igana ling'wi.” ");
INSERT INTO isn_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","uYesu aka atambuila, “Itii iiza wileta u lumuli mukati ito nu kuluika pihi a nkapu, ang'wi pihi a ulili? Wiluletaa mukati nu kuluika migulya a ishupaka. ");
INSERT INTO isn_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ku nsoko kutili kihi nikipihile naiza shanga kiku kumuka, hangi kutili i kinkunku naiza shanga kikuikwa kihenga. ");
INSERT INTO isn_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Anga ize ukoli nukete i akutwi a kija, nu ije!” ");
INSERT INTO isn_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Aka atambuila, “Tuli miakendegeeli ku iko ni mukukija, ku nsoko u ugemeelya ni mukugemeelya, kiko ni mukagemeeligwa, hangi kikongeligwa kitalanyu. ");
INSERT INTO isn_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ku nsoko nuanso nukete, ukinkiiligwa ikilo, hangi uyo nimugila, kupuma kitalakwe ikuholwa ga nizo nuikete.” ");
INSERT INTO isn_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Hangi akaligitya, “Utemi nuang'wa Itunda wimpyanigwe nu muntu nai utemee i mbeu mu mahalu. ");
INSERT INTO isn_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nai wakalala u utiku nu kuuka i kidaudau, ni mbeu ikaheluka nu kukula, Ga ni uu shanga ulingile nai ipumie. ");
INSERT INTO isn_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ihi ipumyaa i mbeu nkola; hanza matutu, alafu ulua, alafu mbeu niakagupaa. ");
INSERT INTO isn_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Hangi itungo imbeu ni ikatula ailyaa itungo witwalaa uzolo, ku nsoko i maogola apikiila.” ");
INSERT INTO isn_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Hangi akaligitya, “kuimpyanie u utemi nuang'wa itunda ni kintu kii, ang'wi kutumile mpyani kii ku uganula? ");
INSERT INTO isn_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ingi anga i mbeu a haradali, naiza ai itemewe ingi niino nangaluu kukila i mbeu yihi mihi. ");
INSERT INTO isn_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ga, ni itungo naza itemewe, ikukula nu kutula nkulu ikilo nila mimea ihi mu shuli, hangi izipyaa ntaambi nkulu, ga ni nyunyi nia kilunde ihumaa kuzipya iuyi niao mu mululi nuakwe.” ");
INSERT INTO isn_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ku mpyani idu ai umanyisilye hangi ai uligitilye u lukani kitalao, ku upikiilo nai uhumile kulinga, ");
INSERT INTO isn_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","hangi shanga ai uligitilye ni enso bila mpyani. Kuiti itungo nai wakatula wing'wene duu, aka aganuila kila i kintu i amanyisigwa akwe. ");
INSERT INTO isn_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mu luhiku nulanso, itungo nila mpindi nai lipikiie, akaligitya kitalao, “Kweni i nkika a kabiili.” ");
INSERT INTO isn_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Iti gwa akalileka i umbi, akamuhola uYesu, itungo nilanso yakondaa ai watula mukati ilinga. Malinga mauya ai atulaa palung'wi nu ng'wenso. ");
INSERT INTO isn_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nu ng'wega utaki nua kimpupu ni maingu ai atulaa akingila mukati a mulinga nu mulinga ai wakondyaa kutula wizula. ");
INSERT INTO isn_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Kuiti uYesu mukola ai ukoli mu shetri, ulae mu muto. Akamutambuila, azeligitya, “Ng'walimu, shanga ulingile kina usese kuusha?” ");
INSERT INTO isn_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Hangi akauka, akaukenela u ng'wega nu kuluila u luzi, “Itule ihi twii, ulyuuku.” Ung'wega ukapela, hangi ai ituile nu ulyuuku ukulu. ");
INSERT INTO isn_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Hangi akaligitya kitalao, “Ku niki mukitumba? Itii mukili miagila u uhuiili?” ");
INSERT INTO isn_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Akizuilwa nu woa ukulu mukati ao hangi akitambulya enso ku enso, “Uyu ingi nyenyu hangi, ku nsoko ga nu ng'wega nu luzi ikumugombya.” ");
INSERT INTO isn_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nai akapembya kupikiila nkika ingiiza a luzi, mu mukoa nua Gerasi. ");
INSERT INTO isn_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Hangi kupumpugila itungo uYesu naiwatulaa ukupuma kunzi ilinga, muntu nukete u hing'wi ai uzile kitalakwe kupuma mu ibiila. ");
INSERT INTO isn_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Muntu uyu ai wikiie mu ibiila. Kutili nai uhumile kumugilya ikilo, kutili ga nu ku minyororo. ");
INSERT INTO isn_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ai watulaa utungilwe matungo iduu ku mpingu ni minyororo. Kutili ga nu ng'wi nai ukete i ngulu nia kumukilya. ");
INSERT INTO isn_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Utiku nu mung'wi waze ukoli mu ibiila nu mu malugulu, ai wilila nu kitemanga u ng'wenso mukola ku magwe ni migi. ");
INSERT INTO isn_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nai wakamihenga uYesu ku kaheelu, akamankiila kung'wakwe nu kutuna ntongeela akwe. ");
INSERT INTO isn_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ai uleile ku luli lukulu, “Uloilwe nukutendele ntuni, Yesu ng'wana wang'wa Itunda nukoli migulya nangaluu? Ku usinja kung'wa Itunda mukola, leka kunaja. ");
INSERT INTO isn_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ku nsoko ai watulaa wamuila, “Mupume u muntu uyu, u ewe hing'wi.” ");
INSERT INTO isn_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nu ng'wenso ai umukoiye, “Lina nilako ingi nyenyu?” Nuanso akamusuliilya, “Lina nilane ingi Legion, ku nsoko kukoli kidu.” ");
INSERT INTO isn_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ai umusingilye hangi ni hangi waleke kuatwala kunzi a mukoa. ");
INSERT INTO isn_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Itungili idale ikulu nila ngulima ai likoli likuding'wa migulya a lugulu, ");
INSERT INTO isn_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ni enso ai amusingilye, azeligitya, “Kulagiilye ku ngulima; kingile mu kati yao.” ");
INSERT INTO isn_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Iti gwa ai uagombilye; ia hing'wi ai amupumile nu kingila mukati a ngulima, ni nyenso ai imankile pihi a lugulu kupikiila mu luzi, hangi kupikiila ngulima magana a nzogu a biili ikalimilila mu luzi. ");
INSERT INTO isn_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Hangi awo nai atulaa akudima i ngulima ai amankile nu kupumya u lukani nula iko nai kipumie mu kisali nu mi ihi. Uugwa antu idu ai apumile kulongola kihenga nai kipumie. ");
INSERT INTO isn_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Uugwa ai apembilye kung'wa Yesu hangi ai amihengile u muntu nai wahalinkaniwe nu hing'wi nai ukete idale —wikie pihi, utugawe, hangi aze ukoli mu mahala akwe akondaniie, ni enso ai itumbile. ");
INSERT INTO isn_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Awo nai atulaa ihengile nai kipumie ku muntu nai watulaa uhalinkaniwe nu hing'wi ai a atambuie nai kipumie kitalakwe ga ni kutula i ngulima. ");
INSERT INTO isn_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ni enso akandya kumusinja wahege mu mukoa nuao. ");
INSERT INTO isn_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Hangi nai wakatula ukingila mukati i linga, muntu nai watulaa uhalinkaniwe nia hing'wi ai umusingilye kina alongole palung'wi nu ng'wenso. ");
INSERT INTO isn_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kuiti shanga ai umugombilye, kuiti ai umutambuie, “Longola ki ito nilako nu ku antu niako, hangi uatambuile aza ukutendee Mukulu, nu ukende naza ukinkiiye.” ");
INSERT INTO isn_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Uugwa ai ulongoe nu kandya kutanantya i makani makulu naiza uYesu witumile kitalakwe mu Dekapoli, ni kila ung'wi ai ukuiwe. ");
INSERT INTO isn_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Hangi itungo nai wakaputa hangi nkika i ngiiza, mukati ilinga, iumbi ikulu likilingiila kumupilimikiilya, nai ukoli mpelo a luzi. ");
INSERT INTO isn_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Hangi ung'wi nu a lukolongo ni i tekeelo, nai witangwaa Yairo, ai uzile, hangi nai umuhengile, ai ugwie mu migulu akwe. ");
INSERT INTO isn_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Akamusija ikilo ni ikilo, wazeligitya, “Munaanso nu ane nu muniino wahumbeela kusha. Ku usinja, pembya nu kuika i mikono ako migulya akwe iti kina wahume kulija upanga nu kikie.” ");
INSERT INTO isn_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Iti gwa ai ulongoe palung'wi nu ng'wenso. ni i umbi ikulu ai limutyatile ni enso ai akumunyempa pakupi aze amupilimikiiye. ");
INSERT INTO isn_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ai ukoli nu musungu naiza i sakami akwe ai atulaa ipumaa ku myaka ikumi na ibiili. ");
INSERT INTO isn_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ai wagilee nia kukonda pihi a akiliki idu hangi ai watumie kila i kintu nai watuile ni kenso. Ga ni iti shanga akagunika ku kintu kihi. kuiti badala akwe akakilinkiila kutula ni hali mbibi. ");
INSERT INTO isn_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ai wigulye i nkani kutula uYesu. Iti gwa ai upembilye ku nyuma akwe itungo nai watulaa ukugenda mukati i umbi, nu ng'wenso ai utenilye u ng'wenda nuakwe. ");
INSERT INTO isn_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ku nsoko ai uligitilye, “Anga niatenie i ang'wenda ni akwe udu, nikatula ni mupanga.” ");
INSERT INTO isn_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nai utenilye, kupung'wa i sakami ikapela, hangi ai wigulye mu muili nuakwe kina ai wagunwaa kupuma mu lwago nulakwe ");
INSERT INTO isn_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Hangi kupumpugiilya uYesu akalinga mukati akwe mukola kina ngulu imupumile. Hangi ai upilukile kunu nu kunu mi iumbi nila antu nu kukolya, “Ingi nyenyu nutenilye u ng'wenda nuane?” ");
INSERT INTO isn_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Amanyisigwa akwe ai amutambuie, “Ukihenga i umbii ili likutunyiiye likupilimikiiye, nu ewe ukuligitya, 'Ingi nyenyu nu ntenilye?'” ");
INSERT INTO isn_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kuiti uYesu ai ugozile kunu nu kunu kihenga naiza watulaa witumile ili. ");
INSERT INTO isn_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Musungu, waze ulingile nai kipumie kitalakwe, ai witumbile nu kukagata. Ai upembilye hangi ai ugwie pihi ntongeela akwe nu kumuila i tai ihi. ");
INSERT INTO isn_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ai uligitilye kitalakwe, “Munanso, uhuiili nuako wakuzipya utule u mupanga. Longola ku ulyuuku hangi ugunwe kupuma mu ulwae nuako.” ");
INSERT INTO isn_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nai watulaa ukuligitya, ang'wi a antu ai apembilye kupuma kung'a lukolongo nua itekeelo, azeligitya, “U munanso nuako wakuza. Ku niki kulongoleka kumunyoma u ng'walimu?” ");
INSERT INTO isn_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kuiti uYesu nai wakija naza akukiligiya, ai umutambuie u lukolongo nu itekeelo, Leka kitumba. Huiila udu.” ");
INSERT INTO isn_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Shanga ai umugombilye wihi kitongelya nu ng'wenso kwaala uPetro, Yakobo, nu Yohana muluna nuakwe uYakobo. ");
INSERT INTO isn_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ai apembilye mi ito nilang'wa lukolongo nui itekeelo nu ng'wenso ai wihengile unyong'wa, kulila kidu nu kuhongeelya. ");
INSERT INTO isn_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nai wakingila mi ito, ai uatambuie, “ Ku niki mukusiga ikulu hangi ku niki mukulila? uMung'yinya akili kusha ila ulae.” ");
INSERT INTO isn_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ai amuhekile, kuiti nuanso, ai uapumilye ihi kunzi, ai umuhoile utata nua ng'wana nu nyinya ni awo nai atulaa palung'wi nu ng'wenso, hangi ai wingie mukati nai umoli u ng'wana. ");
INSERT INTO isn_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ai u uhoile u mukono nua ng'wana hangi ai umutambuie, “Talitha koum,” naiza ingi kuligitya, “Munanso muniino, ku utambuila, uka.” ");
INSERT INTO isn_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kupumpugiilya u ng'wana ai u ukile nu kugenda. (ku nsoko ai watulaa ni ilika nila myaka ikumi na ibiili). Hangi kupumpugiilya ai a ambilwe nu ukuilwa ukulu. ");
INSERT INTO isn_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ai ulagiiye ku ngulu kina kutili wihi utakiwe kulinga kutula ili. Hangi ai uatambuie aminkiilye u munanso nuanso indya. ");
INSERT INTO isn_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Hangi akahega pang'wanso nu kulongola mu kisali kao, ni amanyisiga akwe akamutyata. ");
INSERT INTO isn_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Luhiku nula kusupya nai likapika. ai wandilye kumanyisa mu Itekeelo. Antu idu ai amigulye hangi akakuilwa. Akaligitya, Uligilye pii u umanyisa uwu?” Ingi upolo kii uwu nuinkiigwe?” Ukituma uli u ukuilwa uwu ku mikono akwe?” ");
INSERT INTO isn_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","“Itii uyu shanga yuyo u mulanda mabada, ng'wana wang'wa Mariamu hangi muluna nuao ia Yakobo, Yose, Yuda nu Simioni? Itii i aluna akwe nia kisugu shanga ikie papa paapa palung'wi nu sese?” Hangi shanga ikaloeligwa nu Yesu. ");
INSERT INTO isn_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","uYesu aka atambuila, “U munyakidagu shanga wiulyaa ikulyo, kwaala mu kisali nikakwe ni mukati a aluna akwe nia mi ito nilakwe.” ");
INSERT INTO isn_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Shanga ai uhumile kituma u ukuilwa pang'wanso, iti ai uaikiiye mikono alwae asheenyu aka aguna. ");
INSERT INTO isn_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ai ukuiwe nangaluu ku nsoko a kuhita kuhuiila kitalao. Uugwa ai uigendee i ijiji nia kisali waze manyisa. ");
INSERT INTO isn_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ai uitangile awo i amanyisigwa ikumi na abiili akandya kualagiilya abiili a biili. Ai uinkiiye uhumi migulya a ahing'wi ");
INSERT INTO isn_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","nu kualagiilya aleke kuhola kihi nialongoe kwaala mulanga udu. Aleke kuhola u mukate ang'wi mbogoshi, ang'wi mpia mu kilino; ");
INSERT INTO isn_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kuiti atugale i latu, hangi shanga a mujulungu a biili. ");
INSERT INTO isn_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Hangi aka atamuila, “ Ito lihi ni mukingila, ikii papo kupikiila ni mikahega. ");
INSERT INTO isn_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ni kisali kihi nishanga kikumusingiilya ang'wi kumutegeelya, hegi kitalao, kununti u lunkundi nula migulu anyu, itule ukuiili kitalao.” ");
INSERT INTO isn_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ni enso akalongola azetanantya antu ile itunu nu kuleka i milandu ao. ");
INSERT INTO isn_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ai a anuzunsilye i ahing'wi idu, hangi ai apuguhie i makuta i alwae hangi akagunwa. ");
INSERT INTO isn_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","uMutemi Herode nai wakija nanso, ku nsoko i lina nilang'wa Yesu ai latulaa lakumuka nangaluu. Ang'wi ai aligitilye, uYohana ni moganyi wiuka hangi ku nsoko nanso, iyi ngulu a ukuilwa ikituma u mulimo mukati akwe.” ");
INSERT INTO isn_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ang'wi ao akaligitya, “Uyu ingi Eliya,” Ikili i auya akaligitya, “Uyu ingi munyakidagu, anga ung'wi nua awo anyakidagu nia kali.” ");
INSERT INTO isn_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kuiti uHerode nai wakija aya akaligitya, “uYohana, nai numudumue itwe wiukigwa.” ");
INSERT INTO isn_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ndogoelyo uHerode mukola ai ulagiiye uYohana waambwe nu kutungwa mu kadulumu ku nsoko ang'wa Herodia (musungu nua muluna nuakwe uFilipo) ku nsoko nuanso ai watulaa wamutenaa. ");
INSERT INTO isn_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ku ndogoelyo uYohana ai umutambuie uHerode, “Shanga tai ako kumutina u musungu nuang'wa heu nuako.” ");
INSERT INTO isn_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kuiti uHerode ai wandilye kumubipilwa hangi ai watulaa uloilwe kumubulaga, kuiti shanga wikahuma, ");
INSERT INTO isn_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ndogoelyo u Herode aizaa umitumbile uYohana; ai ulingile kina ingi munya tai ane muntu ni ng'welu, hangi ai umulekile iziza. Hangi nai ulongolekile kumutegeelya akahusha nangaluu, kuiti ai wiloile kumutegeelya. ");
INSERT INTO isn_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nai lipikile ga ni itungo niligombekile anga itule lahumbeela u luhiku nula kutugwa uHerode aka azipiililya i aopisa akwe isiku kuu, nia mboi, nia lukolongo nia ku Galilaya. ");
INSERT INTO isn_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Uugwa u munaano nuang'wa Herodia akingila kiginsa ntongeela ao, akamuloeelya uHerode ni aziila nai ikie itungo nila ndya nia mpindi. Uugwa u mutemi akamuila umu nanso, “Nompe kihi nukiloilwe nu nene nikaki nkiilya.' ");
INSERT INTO isn_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Akamulapila nu kuligitya, kihi nui kanompa, nika kinkiilya, ga ni ikinda nila utemi nuane.” ");
INSERT INTO isn_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Akapuma kunzi akamukolya u nyinya nuakwe, “Nompe ntuni?” Akaligitya, “Itwe lang'wa Yohana nuojaa.” ");
INSERT INTO isn_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ni itungo ling'wi akingila ku mutemi akandya kuligitya, “Ndoilwe uninkiilye mukati a sahani, itwe nilang'wa Yohana Nuojaa.” ");
INSERT INTO isn_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","uMutemi akahusha nangaluu, kuiti ku nsoko a ilapo nilakwe hangi ku nsoko a aziila, shanga ai uhumile kumuhitilya ilompi nilakwe. ");
INSERT INTO isn_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Iti gwa, umutemi akalagiilya i a asikali pakati a asunja akwe nu kualagiilya kulongola kuleta itwe lang'wa Yohana. uMusunja ai ulongoe kumutema itwe waze ukoli mu kitungo. ");
INSERT INTO isn_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Akaleta itwe nilakwe mu sahani nu kuminkiilya u munanso, nu munanso akaminkiilya u nyinya nuakwe. ");
INSERT INTO isn_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Hangi i amanyisigwa akwe nai akija nanso, ai alongoe ku uhola u muili nuakwe akalongola ku uika mu kibiila. ");
INSERT INTO isn_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ni itumi, ai ilundiie palung'wi ntongeela ang'wa Yesu, akamuganuila ihi nai itumile hangi nai amanyisilye. ");
INSERT INTO isn_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nu ng'wenso aka atambuila, Pembyi akola i kianza nika kinkunku hangi kusupye ku itungo.” Antu idu ai atulaa akupembya nu kuhega, shanga ai aligilye ga nilyoma nila kulya. ");
INSERT INTO isn_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Iti gwa akanankila i mashua akalongola kianza nika kinkunku i ng'wene duu. ");
INSERT INTO isn_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kuiti ai uihengile ni akuhega hangi idu aka alinga, ku palung'wi ai amankile ku migulu kupuma mu isali yihi, ni enso akapika ze ikili ni anso. ");
INSERT INTO isn_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nai apilkile ku nkilimbwaa, ai wihengile i umbi ikulu hangi aka a aisiilya, ku nsoko ai atulaa anga i nkolo ni ngila anga mudimi. Hangi akandya kuamanyisa makani idu. ");
INSERT INTO isn_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Itungo ai lilongolekile nangaluu, amanyisigwa akamuziila akamutambuila, “Apa ingi kianza nika kinkunku ni itungo lalongolekaa. ");
INSERT INTO isn_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ualage alongole mu isali nia kisali ni ijiji iti ende iguilye indya.” ");
INSERT INTO isn_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kuiti aka asukiilya akaligitya, “Api nyenye indya.” Aka atambuila, “Kuhumile kulongola nu kugula i mikate nikete i nsailo a dinari magana abiili nu kuinkiilya alye?” ");
INSERT INTO isn_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Aka atambuila, “Mukete mikate inga? Longoli mugoze.” nai aligilye akamutambuila, “Mikate itaano ni nsamaki ibiili.' ");
INSERT INTO isn_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Aka alagiilya i antu ikie mu madale migulya a mafwa ni matotu. Aka ikalinsha mu madale; madale a magana ni ku makumi ataano. ");
INSERT INTO isn_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Uugwa akahola i mikate itaano ni nsamaki ibiili, nu kugoza kilunde, akamikendepa uugwa aka inkiilya i amanyisigwa aike ntongeela a iumbi. Hangi uugwa ai ugalanilye i nsamaki ibiili ku antu ihi. ");
INSERT INTO isn_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ai alie ihi kupikiila akakondaniila. ");
INSERT INTO isn_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ai ilingiie i mapuli a mikate nai isigile. Yikizula nkapu ikumi na ibiili, ga ni mapuli a nsamaki. ");
INSERT INTO isn_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Hangi ai atulaa agoha magana a nzogu ataano nai alie i mikate. ");
INSERT INTO isn_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Itungo aka atambuila anankile mu mashua alongole nkuka i ngiiza, kupikiila ku Bethsaida, itungo Nuanso waze alaga anyianza. ");
INSERT INTO isn_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nai akatula akondyaa kuhega, akalongola mu lugulu kulompa. ");
INSERT INTO isn_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nai ikatula mpindi, ni mashua ao itungo ni lanso ize ikoli pakati a luzi, nu ng'wenso ai ukoli wing'wene duu mihi ni nyumu. ");
INSERT INTO isn_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Hangi ai uihengile akagisha kukua i makasia ku nsoko a ng'wega ukuagilya. nai ihumbee i kidaudau aka alondoola, wazegenda migulya a mazi, hangi ai uloilwe kuakila. ");
INSERT INTO isn_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kuiti nai akamihenga ukugenda migulya a mazi, akingiilwa nu mitumbo aze asigile ingi mintunga akakua ga ni ogo. ");
INSERT INTO isn_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ku nsoko ai amihengile akizuilwa nu woa, Itungo akaligita ni enso aka atambuila, “Mutule akamatiku ingi nene! Leki kutuli nu woa. ");
INSERT INTO isn_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Akingila mukati a mashua, nu g'wega ukaleka ku kunka, ni enso akakuilwa lukulu. ");
INSERT INTO isn_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Iti gwa shanga ikatula alingaa i ndogoelyo a iyo i mikate. Ndogoelyo i mahala ao ai akete ulingi uniino. ");
INSERT INTO isn_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ni enso kaputa kitumbi, akapika mihi a Genesareti imashua ikaika i nanga. ");
INSERT INTO isn_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nai akapuma kunzi a mashua, itungo akamulinga. ");
INSERT INTO isn_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Akamanka kutanantya mu mukoa wihi hangi akandya kualeta i alwae ku ulili, kila nai igulye upembilye. ");
INSERT INTO isn_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Pihi nai wingie mu ijiji, ang'wi mu isali, ang'wi mi ihi, ai a aikile i alwae kianza ni kisoko, hangi akamusinja waagombye kutenia ukunzilo nua ng'wenda nuakwe. Hangi ihi nai amutenilye ai agunilwe ");
INSERT INTO isn_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Afarisayo ni ang'wi a amanyi naza atulaa apembeeye ku Yerusalemu ai ilingiie kumupilima ung'wenso. ");
INSERT INTO isn_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Hangi ai ihengile kina amanyisigwa ang'wi ao akulya u mukate ku mikono mishapu; naiza shanga ikalaigwe, ");
INSERT INTO isn_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(ku Afarisayo ni Ayahudi ihi shanga iliza kupikiila akalaye i mikono ao iziza; a ambiiye ulogo nula anyampala. Matungo ");
INSERT INTO isn_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","i Afarisayo niagomokile kupuma kianza ki isoko, shanga ilizaa kupikiila oge hanza. Hangi akoli malagiilyo maulya naza akumatyata lukulu, anga itule ingi palung'wi nu koja i ikombe, masupulia, iseme nia shaba, ga ni matuntu ni itumila itungo nila ndya,) ");
INSERT INTO isn_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Afarisayo ni amanyi ai amukoiye uYesu, “Ku niki amanyisigwa ako shanga ikii kuniganiila nu logo nula anyampala, ku iti akulya umukate shanga ize akalae i mikono?” ");
INSERT INTO isn_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Kuiti nuanso aka atambuila, “uIsaya ai ulotile iza kutula u nyenye adosi, ai ukilisilye, 'Antu awa akunkulya ku milomo ao, kuiti i nkolo niao ikoli kuli nu nene. ");
INSERT INTO isn_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Akunintumila ikumbiko ni gila anga ndogoelyo, azemanyisa malagiilyo a ana adamu anga ulekeelya nuao,' ");
INSERT INTO isn_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Malilekaa ilagiilyo nilang'wa Itunda maluambaa ku upepeele u logo nula ana adamu.” ");
INSERT INTO isn_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Hangi akaligitya kitalao, “Malihitaa ilagiilyo nilang'wa Itunda ku utontu iti kina mu luike u logo nulanyu! ");
INSERT INTO isn_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ku nsoko uMusa ai uligitilye, 'mukulye u tata nuako nu ia nuako,' 'nu ng'wenso nuiligitya u ubi migulya ang'wa tata nuakwe nu nyinya nuakwe kulu kuulu ukusha,' ");
INSERT INTO isn_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kuiti mukuligitya, 'Anga ize u muntu waligitye kung'wa tata nuakwe ang'wi nyinya, 'Uaiilya wihi naza mukusingiilya kupuma kitalane ingi itulyo nila Itekeelo,” (nanso ingi kulunga kina, ipumiigwe kung'wa Itunda') ");
INSERT INTO isn_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","iti gwa shanga imugombilye kituma lihi ku nsoko ia tata ang'wi a nyinya akwe. ");
INSERT INTO isn_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mukulizipya ilagiilyo nilang'wa Itunda ku nakanda ku kuleta u logo nulanyu. Ni makani idu a kinya iti ni mukituma.” ");
INSERT INTO isn_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ai uitangile i anyianza hangi nu kuatambuila, “Muntegeelye u nene, unyenye mihi, hangi muninge. ");
INSERT INTO isn_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kutili kihi kupuma kunzi a muntu naiza kahumaa kumushapula u muntu ni kingiila kung'waakwe. Ila ingi iko ni kimupumaa u muntu kiko ni kimushapulaa. ");
INSERT INTO isn_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(Komaniilya; u lukiili ulu. “anga ize u muntu wihi ukete i akutwi akija, u ije” umutili mu mbugulu nia kali.) ");
INSERT INTO isn_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","uYesu nai wakaaleka i anyianza nu kingila mi ito, amanyisigwa niakwe akamukolya kutula i mpyani nanso. ");
INSERT INTO isn_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","uYesu akaligitya, “Nu nyenye ga mukili ku ninga? Shanga mihengile kina kihi ni kimingiila u muntu shanga kihumile kumushapula, ");
INSERT INTO isn_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ku nsoko shanga kihumile kulongola mu nkolo akwe, kuiti kikingila mu nda akwe hangi kikukila kulongola ku shoo.” ku lugano ulu uYesu ai uizipilye i ndya yihi kutula nzelu. ");
INSERT INTO isn_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ai uligitilye, “Ingi iko naiza kikumupuma u muntu kiko ni kimushapulaa. ");
INSERT INTO isn_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ku nsoko kipuma mukati a muntu, kunzi a nkolo, ipuma masigo ni mabibi, ugoolya, wii, ubulagi, ");
INSERT INTO isn_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","usambo, nsula ni mbibi, ubibi, ukongelani, kigoolya, wilu, ukunki, wiketi, upungu. ");
INSERT INTO isn_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","U ubi uwu wihi wipuma mukati, kiko iko ni kimushapula u muntu.” ");
INSERT INTO isn_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ai u ukile kupuma pang'wanso nu kuhega kulongola mu mukoa nua Tiro ni Sidoni. Ai wingie mukati hangi shanga ai uloilwe muntu wihi walinge kina ukoli papo, kuiti shanga ai ihumikile ku mupiha. ");
INSERT INTO isn_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kuiti kupumpugiilya musungu, naiza u ng'wana nuakwe muniino ai ukete hing'wi, ai wigulye i nkani niakwe, akiza, hangi akagwa mu migulu akwe. ");
INSERT INTO isn_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","uMusungu nuanso ai watulaa Muyunani, nua ndugu a Kifoeniki. Ai umusingilye nuanso amuzunse u hing'wi kupuma ku munaanso nuakwe. ");
INSERT INTO isn_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","uYesu akamuila u musungu, “Aleke i ang'yinya alisigwe hanza, kunsoko shanga izipie ku uhola u mukate nua ana nu kuigumila i mbwa” ");
INSERT INTO isn_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kuiti u musunu akamusukiilya nu kuligitya, “Iti gwa Mukulu, ga ni mbwa pihi a meza iliza i ipoli nia ndya nia ana.” ");
INSERT INTO isn_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Akamuila, “Ku nsoko waligitya iti, ukoli ilyuuku kulongola. uHing'wi wamupumaa u munanso nuako.” ");
INSERT INTO isn_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","uMusungu ai ugomokile ki ito nilakwe hangi akahanga u munanso nuakwe ulae mu ulili, nu hing'wi ai watulaa wamupumaa. ");
INSERT INTO isn_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","uYesu ai upumile hangi kunzi a mukoa nua Tiro nu kukila ku Sidoni kutunga u Luzi nula Galilaya kupikiila nkika a Dikapolisi. ");
INSERT INTO isn_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Akamuleta hangi muntu nai watuile gulu hangi ai watulaa shanga uhumile kuligitya iziza, ai amusingilye uYesu waike i mikono migulya akwe. ");
INSERT INTO isn_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ai umupumilye kunzi a milundo ku kinkunku, hangi akaika i ng'yanza niakwe mu akutwi akwe, hangi ze yakila kutya i mati, ai utenilye u lulimi nulakwe. ");
INSERT INTO isn_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ai ugozile migulya mi lunde, akahupa nu kumuila, Efata,” nanso ingi kuligitya, “luguka!” ");
INSERT INTO isn_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ni itungo lilo liilo akutwi akaluguka, hangi nai katulaa kimugiiye u lulimi kikabipigwa hangi akahuma kuligitya iziza. ");
INSERT INTO isn_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Hangi ai ulagiiye aleke kumuila muntu wihi. Kuiti kupikiila nai ualagiiye, uu nai atanantilye i nkani nianso ku widu. ");
INSERT INTO isn_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kulu kuulu ai akuiwe, nu kuligitya, “Witumile kila i kintu iziza. Waazipya ga nia gulu kija nia kimumi kuligitya.” ");
INSERT INTO isn_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mu mahiku nanso, ai likoli hangi iumbi ikulu, hangi ai agila ni ndya, uYesu akaitanga i amanyisigwa akwe aka atambuila, ");
INSERT INTO isn_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Niliaisiiye i umbi ili, alongolekile kutula nu nene ku mahiku ataatu hangi agila indya. ");
INSERT INTO isn_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Anga niasapatilye agomoke ku mato ao bila kulya ahumile kusha kisha mukanka munzila ku nzala. Hangi amg'wi ao apumile kuli nangaluu.” ");
INSERT INTO isn_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Amanyisigwa akwe akamusukiilya, “Ku ulija pii i mikate a kenela kui kutya i antu awa mu nkika iyi nililekilwe?” ");
INSERT INTO isn_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Aka akolya, “mukete mapuli anga na mikate?” Akaligitya, “Mupungati.” ");
INSERT INTO isn_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ai ulagiiye i umbi likie pihi. Akahola i mikate mupungati, akamulumba Itunda, nu kumibadulania. Akainkiilya i amanyisigwa akwe amiikie ntongeela ao, ni enso akamiika ntongeela i umbi. ");
INSERT INTO isn_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Hangi ai akete ni nsamaki ni niino nsheenyu, ni ze yakilaa kulumba, ai ualagiiye i amanyisigwa akwe a agalanie iti hangi. ");
INSERT INTO isn_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ai alie nu ku kondaniila. Hangi ai ilingiie i mapuli nai asigile, nkapu ni nkulu mupungati. ");
INSERT INTO isn_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ai ahumbee antu magana a nzogu anne. Hangi ai ualekile alongole. ");
INSERT INTO isn_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Itungo ai wingie mu mashua ni amanyisigwa akwe, hangi akalongola mu nkika nia ku Dalmanuta. ");
INSERT INTO isn_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Uugwa Afarisayo ai apumile kunzi nu kandya kikunguma nu ng'wenso. Ai aloilwe wainkiilye kilingasiilyo kupuma kilunde, ku kumugema. ");
INSERT INTO isn_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Akasiganiilya ku mukati mu nkolo akwe akaligitya, “Ku niki ulelwa uwu ukuduma kilingasiilyo” Kumutambuila unyenye itai, kutili kilingasiilyo ni kikapumigwa ku ulelwa uwu.” ");
INSERT INTO isn_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Uugwa aka aleka, akingila mukati a mashua hangi, akahega kutunga nkika ingiiza. ");
INSERT INTO isn_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Itungo nilanso amanyisigwa ai i ilwe kuhola i mikate. Shanga ai akete ni mikate kukila a ipuli ling'wi nai limoli mu mashua. ");
INSERT INTO isn_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ai uahugue nu kuligitya, “Mutule miho nu kisunja ku usasu nua Afarisayo nu usasu nuang'wa Herode. ");
INSERT INTO isn_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Amanyisigwa akitambulya enso ku enso, “Ingi ku nsoko kiagila i ikate.” ");
INSERT INTO isn_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","uYesu ai ulilingile ili, nu kuatambuila, “Ku niki mukitambuila kutula kuhita kutula ni mikate? Mukili kulinga? Shanga mulingile? I nkolo yanyu yatulaa mpepeele? ");
INSERT INTO isn_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mukete i miho, shanga mukihenga? Mukete akutwi, shanga mukija? Shanga mukimbukiile? ");
INSERT INTO isn_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Naza nimigalanilye i mikate itaano ku antu magana a nzogu ataano, ai muhoile nkapu inga nai yizue nia mapuli a mikate?” Akasukiilya, “i kumi na ibiili.” ");
INSERT INTO isn_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Hangi naza nimigalanilye i mikate mupungati ku antu magana anzogu anne, ai muhoile ikapu inga?” ");
INSERT INTO isn_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Akaligitya, “Mupungati.” Aka atambuila, “Mukili kulinga?” ");
INSERT INTO isn_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Akapembya ku Bethsaida. Antu awo ai amuletile mupoku hangi akamusinja ");
INSERT INTO isn_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","uYesu amutenie. uYesu akamuamba ku mikono u mupoku uyo, nu kumutonga kunzi a kijiji. Nai wakatya i mati migulya a miho akwe nu kugoola i mikono akwe migulya akwe, ai umukoiye, “Ukihenga kihi?” ");
INSERT INTO isn_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Akagoza migulya nu kuligita, “Kihenga antu akigela anga makota akugenda.” ");
INSERT INTO isn_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Papo akagoola hangi i mikono akwe migulya a miho akwe, muntu uyo akapitya i miho akwe ai wihengile hangi, nu kihenga kila ikintu iziza. ");
INSERT INTO isn_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","uYesu ai umulekile alongole ki ito hangi akamutambuila, “Uleke kingila mu kisali.” ");
INSERT INTO isn_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","uYesu ai uhegile ni amanyisigwa akwe kulongola ijiji nia ku Kaiseria a ku Filipi. Waze ukoli mu nzila ai uakoiye i amanyisigwa, Antu akuligitya unene ingi nyenyu?” ");
INSERT INTO isn_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Akamusukiilya akaligitya, “Yohana nu ojaa. Auya akuligitya, 'Eliya' ni auya, 'Ung'wi nua anyakidagu.” ");
INSERT INTO isn_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Aka akolya, “Kuiti unyenye mukuligitya unene ni nyenyu?” uPetro akamuila, “U ewe ingi Kristo.” ");
INSERT INTO isn_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","uYesu aka ahugula aleke kumutambuila muntu wihi ku mutula u ng'wenso. ");
INSERT INTO isn_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Hangi akandya kuamanyisa nia kina u Ng'wana wang'wa Adamu kusinja wagishe ku makani idu, hangi ukuhitwa nia lukolongo nia kuhani ni akulu, ni amanyi, ni elu a nkolo, hangi ze yakilaa a mahiku ataatu ukiuka. ");
INSERT INTO isn_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ai uligitilye aya ku kihenga. Uugwa uPetro akamuhola ku mpelo hangi akandya kumupatya ");
INSERT INTO isn_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kuiti uYesu ai upilukile nu kuagoza i amanyisigwa akwe nu kumukenela uPetro nu kuligitya, “Kila ku kituli ni kane Mulugu! Shanga ukee i makani ang'wa Itunda, kwaala makani a antu” ");
INSERT INTO isn_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Uugwa akalitanga i umbi ni amanyisigwa akwe palung'wi, nu kuatambuila, “Anga ize ukoli muntu uloilwe kuntyata, nui kungume u mukola, wahole ikota nila mpaga nilakwe wantyate. ");
INSERT INTO isn_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ku nsoko wihi nuloilwe kuluguna u likalo nulakwe ukululimilya, hangi wihi nuika lulimilya u likalo nulakwe ku nsoko ane hangi ku nsoko a nkani ni nziza, ukuluguna. ");
INSERT INTO isn_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ikumuaiilya ntuni u muntu, ku ulija u unkumbigulu wihi, hangi uugwa kulija uula nua likalo nulakwe? ");
INSERT INTO isn_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Muntu uhumile kupumya ntuni badala a likalo nulakwe? ");
INSERT INTO isn_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Wihi nui nihumilwa i minyala ni makani ane mu ulelwa uwu nua ugoolya hangi mu ulelwa nua anya milandu, u Ng'wana wang'wa Adamu ukumuhumilwa i minyala nuikapembya mu utemi nuang'wa Tata nuakwe palung'wi ni a malaika ni elu. ");
INSERT INTO isn_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Hangi ai uligitilye kitalao, “Kulu kuulu kuligitya kitalanyu, ang'wi anyu akoli antu neimikile papa shanga ikalulya i nsha ze akili kuihenga u utemi nuang'wa Itunda uze upembilye ku ngulu.” ");
INSERT INTO isn_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Hangi ze yakilaa mahiku mutandaatu, uYesu ai uahoile uPetro, Yakobo nu Yohana palung'wi nu ng'wenso mu lugulu, ing'wene duu. Uugwa akandya kukailika ntongeela ao. ");
INSERT INTO isn_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ang'wenda akwe akandya kelya nangaluu, melu ikilo, melu kukila melyi wihi mihi. ");
INSERT INTO isn_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Uugwa uEliya palung'wi nu Musa ai upumie ntongeela ao, hangi ai atulaa akuligitya nu Yesu. ");
INSERT INTO isn_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","uPetro ai usukiiye akamutambuila uYesu, “Ng'walimu, Ingi iziza usese kutula papa, ni kuzenge itala itaatu, king'wi ku nsoko ako, king'wi ku nsoko ang'wa Musa ni kiuya ku nsoko ang'wa Eliya.” ");
INSERT INTO isn_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Ku nsoko shanga ai ulingile ntuni nika kuligitya, ai itumbile nangaluu.) ");
INSERT INTO isn_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ilunde ai lipumie nu kuakunikila, Uugwa luli lukapuma mu malunde lukuligitya, “Uyu ingi ng'wana nuane mulowa. Mutegeelyi ng'wenso.” ");
INSERT INTO isn_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kupumpugiilya, nai atula akugoza, shanga ai amihengile wihi palung'wi ni enso, kwaala uYesu duu. ");
INSERT INTO isn_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nai atula akusima kupuma mulugulu, ai ua lagiiye kuleka kumutambuila muntu wihi ayo ihi nai ihengile, Kupikiila uNg'wana wang'wa Adamu nui kiukigwa kupuma mu ashi. ");
INSERT INTO isn_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Uugwa ai amaikile i makani ao akola. Kuiti a itambuuye enso ku enso ingi ntuni i ndogoelyo akwe “kiukigwa kupuma ku ashi.” ");
INSERT INTO isn_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ai amukoiye uYesu, “Ku niki i amanyi iligitya kusinja uEliya waze hanza?” ");
INSERT INTO isn_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Aka atambuila, “kulu kuulu uEliya ukupembya hanza kuguna i intu yihi. Ku niki ikilisigwe uNg'wana wang'wa Adamu kusinja walije ulwago lidu hangi amubipilwe? ");
INSERT INTO isn_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kuiti kuligitya kitalanyu uEliya ai wakondya kuza, hangi ai amutendile anga nai aloilwe, anga iti u ukilisigwa nuiligitya kutula nuanso.” ");
INSERT INTO isn_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Hangi nai agomokile ku amanyisigwa, ai ihengile idale ikulu liapilimikiiye ni Asadukayo ai atulaa akikunguma ni enso. ");
INSERT INTO isn_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Hangi itungo nai ihengile, idale lihi ai likuiwe nu kumumankiila kumulausha. ");
INSERT INTO isn_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ai uakoiye i amanyisigwa akwe, “Mukikunguma ni enso migulya antuni?” ");
INSERT INTO isn_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ung'wi nu ao mi idale ai umuusukiiye, “Ng'walimu, aza numuletile ng'wana nuane kitalako; ukete hing'wi naiza wimutendaa waleke kuhuma kuligitya, ");
INSERT INTO isn_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","hangi wimusasha kukagata nu kumugwisa pihi, nu kupuma ipomboluu mu mulomo nu kukilisa i mino nu kugagambalaa. Aza nialompile i amanyisigwa ako kumupumya u hing'wi, kuiti shanga ahuma. ");
INSERT INTO isn_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ai uasukiiye, “Ulelwa nishanga kihuiie, kikie nu nyenye ku itungo kii? Kihoeela nu nyenye kupikiila nali? Muleti kitalane.” ");
INSERT INTO isn_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ai amuletile u ng'wana nuakwe. U hing'wi nai umihengil uYesu, kupumpugiilya ai umuikile mu ukagati. uMuhumba ai ugwie pihi nu kupumya ipomboolu mu mulomo. ");
INSERT INTO isn_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","uYesu ai umukoiye u tata nuakwe, “Watulaa ni hali iyi ku itungo kii?” uTata akaligitya, “Puma ung'yinya. ");
INSERT INTO isn_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Itungo lulya wigwizaa mu moto ang'wi mu azi, nu kugema kumulimilya. Anga ize uhumile kituma kihi kuaisiilye nu ku uailya.” ");
INSERT INTO isn_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","uYesu ai umutambuie, “Angaa ize ukoli ukondaniie? Kila i kintu kihumikile ku wihi nu uhuiie.” ");
INSERT INTO isn_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kupumpugiilya u tata nua ng'wana akalila nu kuligitya, “Nihuiie nzaiilye kuhita kuhuiila ku ng'waane” ");
INSERT INTO isn_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Matungo uYesu nai wihenga idale likumankiila kitalao, ai umukenee u hing'wi nu kuligitya, “U ewe hing'wi kimumi hangi gulu, ku ulagiilya muleke, leka kingila kitalakwe hangi. ");
INSERT INTO isn_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Akalila ku ngulu nu kumaja u ng'wana nu hing'wi ai umupumile. Ung'wana ai wigee anga ukule, Uugwa idu ai aligitilye, “Wakuza.” ");
INSERT INTO isn_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kuiti uYesu ai umuhoile ku mukono akamunyansula, hangi u ng'wana ai wimikile. ");
INSERT INTO isn_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Matungo uYesu nai wakingila mukati, amanyisigwa akwe akamukolya ku kimpinyimpinyi, “Ku niki shanga aza kuhumile ku mupumya?” ");
INSERT INTO isn_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ai uatambuie, “ku kinya iti shanga ukupuma kwaala ku malompi.” ");
INSERT INTO isn_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Akahega pang'wanso nu kukiila ku Galilaya. Shanga ai uloilwe muntu wihi walinge ku amoli, ");
INSERT INTO isn_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ku nsoko ai watulaa ukuamanyisa amanyisigwa akwe. Ai uatambuie, uNg'wana wang'wa Adamu ukupikigwa mu mikono a antu, hangi akumubulaga. Nuikatulaa wakuza, ze yakilaa mahiku a taatu ukiuka hangi.” ");
INSERT INTO isn_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kuiti shanga ikalinga uganuli uwu, hangi ai itumbile kumukolya. ");
INSERT INTO isn_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Uugwa ai apikile ku Karperinaumu. Matungo nai ukoli mukati i ito ai uakoiye, “Aza mukisija ntuni mu nzila?” ");
INSERT INTO isn_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kuiti akatula ihitwi. Kuiti ai atulaa akikunguma mu nzila kina nyenyu nai watulaa mukulu kukila. ");
INSERT INTO isn_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ai wikie pihi akaitanga ikumi na abiili palung'wi, hangi ai uligitilye ni enso, “Anga ize wihi uloilwe kutula wang'wandyo, ingi kusinja watule wang'wisho hangi munyamulimo nua ihi.” ");
INSERT INTO isn_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Akamuhola mung'yinya muniino akamuika pakati ao. Akamuhola mu mikono akwe, akaligitya. ");
INSERT INTO isn_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Wihi nuimusingiilya u mung'yinya anga uyu ku lina nilane, unsingiiye ga nu nene, hangi anga itule muntu shanga unsingiiye unene du, kuiti ga nuyu nai undagiiye.” ");
INSERT INTO isn_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","uYohana ai umutambuie, “Ng'walimu aza kumihengile muntu ukupumya hing'wi ku lina nilako hangi kamugilya, ku nsoko shanga ukutyatile. ");
INSERT INTO isn_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Kuiti uYesu akaligitya, “Leki kumugilyi, ku nsoko kutili nuikituma u mulimo nu ukulu ku lina nilane hangi uugwa panyambele waligitye lukani nu lubi lihi migulya ane ");
INSERT INTO isn_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Wihi nui kutilye nsuta nu sese ukoli nkika itu. ");
INSERT INTO isn_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Wihi nuika kinkiilya i kikombe nika mazi a kung'wa ku nsoko ukoli nu Kristo, tai kumuila, shanga ukulimilya i kinyamulimo kikakwe. ");
INSERT INTO isn_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Wihi nuika asasha awa ni aniino nianihuiie unene, aza izeetula iziza kitalakwe kutungiiligwa ulwala mu nkingo nu kugumilwa mu luzi. ");
INSERT INTO isn_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Anga u mukono nuako ukusashe uteme. Ingi ibahu kingila mu upanga bila mukono kukila kingila mu ulamulwa uze ukete mikono ihi. Mu moto ni “shanga wimimaa. ");
INSERT INTO isn_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","'(Komaniilya; U lukiili ulu, Nkika naiza i ngunyi shanga ikuza nu moto shanga wilimaa.” umutili mu mbugulu nia kali). ");
INSERT INTO isn_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Anga u mugulu ukusashe, udumule. Ingi iziza kigila mu upanga wize wimulema, kukila kugung'wa mu ulamulwa ni migulu ibiili. ");
INSERT INTO isn_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Komaniilya; Ulukiili ulu, “Kianza naiza i ngunyi shanga ikuzaa nu moto nishanga wilimaa” Umutili mu mbugulu nia kali). ");
INSERT INTO isn_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Anga ize i liho likusashe lipe. Ingi iziza kitalako kingila mu Utemi nuang'wa Itunda uze ukete liho ling'wi, kukila kutula ni miho abiili hangi ugung'we ku ulungu. ");
INSERT INTO isn_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kianza niimoli i ngunyi ni shanga ikuza, nu moto ni shanga wilimaa. ");
INSERT INTO isn_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ku nsoko kila ung'wi uku aswa nu moto. ");
INSERT INTO isn_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","uMunyu ingi uziza, anga u munyu ulimilye i kinagunagu kakwe, uku utenda uli utule niki nagunagu kakwe hangi? Mutule nu munyu mukati anyu akola, hangi mutule nu ulyuuku ku kila ung'wi.” ");
INSERT INTO isn_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","uYesu ai uhegile i kianza nikanso nu kulongola mu mukoa nua Ayahudi ni kianza nika ntongeela a mongo nua Yordani, hangi anyianza akamutyata hangi. Ai uamanyisilye hangi, anga nai yatulaa ntendo akwe kituma. ");
INSERT INTO isn_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Hangi i Afarisayo akapembya kumugema hangi akamukolya, “Ingi taine ku mugoha kutemanuka nu musungu nuakwe?” ");
INSERT INTO isn_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","uYesu aka asukiilya “uMusa ai umulagiiye ntuni?” ");
INSERT INTO isn_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Akaligitya, “uMusa ai ulekee kukilisa ibada nila kutemanuka hangi kumuzunsa u musungu.” ");
INSERT INTO isn_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","“Ingi ku nsoko a ukaku nua nkolo nianyu yiyo ndogoelyo ai umukilisiiye ilagiilo ili.” uYesu ai uatambuie. ");
INSERT INTO isn_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","“Kuiti kupuma u ng'wandyo nua u umbwa, 'Itunda ai ua umbile mugoha nu musungu.' ");
INSERT INTO isn_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ku nsoko iyi u mitunja ukumuleka u tata nuakwe nu nyinya nuakwe ukuambinkana nu mukima nuakwe, ");
INSERT INTO isn_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","hangi awo nia biili akutula muili ung'wi; ku nsoko shanga a biili hangi, ila muili ung'wi. ");
INSERT INTO isn_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ku lulo nuika kiambinkania Itunda, u ng'wana adamu waleke kukitemanula.” ");
INSERT INTO isn_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nai akatula mukati ito, amanyisigwa akwe akamukolya hangi kutula ili. ");
INSERT INTO isn_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Aka atambuila, “Wihi nuimulekaa umusungu nuakwe nu kutina musungu mungiiza, wituaa ugoolya ku ng'wakwe. ");
INSERT INTO isn_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Umusungu nu ng'wenso aga wamuleke u mugoha nuakwe nu kutinwa nu mugoha mungiiza, ukituma ugoolya.” ");
INSERT INTO isn_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ni enso ai amuletee ang'yinya niao nia niino iti waatenie, kuiti amanyisigwa aka apatya. ");
INSERT INTO isn_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kuiti uYesu nai ulilingile nilanso, Shanga akaloeligwa ni lyenso lukulu aka aila, “Alekeli i ang'yinya nia niino aze kitalane, hangi leki kuagilyi, ku nsoko niili anga awa u utemi nuang'wa Itunda ingi wao. ");
INSERT INTO isn_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","I tai kumutambuila, wihi nishanga uku usingiilya u utemi nuang'wa Itunda anga mung'yinya nu muniino kulu kuulu shanga uhumile kingila mu utemi nuang'wa Itunda. ");
INSERT INTO isn_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Uugwa aka ahola i ang'yinya mu mikono akwe nu kuakendepa waze aikiilya mikono akwe migulya ao. ");
INSERT INTO isn_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Hangi nai wakandya muhinzo nuakwe muntu ung'wi ai umu mankiie hangi akatugama ntongeela akwe, aka mukolya, “Ng'walimu Mukende, nitume ntuni iti nihume kusala u upanga nua kali na kali?” ");
INSERT INTO isn_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Nu Yesu akaligitya, “Ku niki ukunintanga mukende? Kutili niiza mukende, kwaala Itunda wing'wene duu. ");
INSERT INTO isn_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","U malingile i malagiilyo; Leka kubulaga, Leka kugoolya, Leka kia, Leka ku kuiila u uteele, Leka kukongela, Mukulye u tata nu ia nuako.” ");
INSERT INTO isn_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","U muntu nuanso akaligitya, “Ng'walimu, aya ihi namakuiye puma nai nkoli ni muhumba.” ");
INSERT INTO isn_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","uYesu ai umugozee nu kumulowa. Akamutambuila, “Ukepewe kintu king'wi. Utakiwe kugulya yihi nuatuile ni nyenso nu kuinkiilya i aula, hangi ukutula ni itulyo kilunde. Uugwa upembye untyate.” ");
INSERT INTO isn_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kuiti aka hung'wa ukata kunsoko a uganulwa uwu; ai uhegile aze uhukilye, ku nsoko ai ukete nsao idu. ");
INSERT INTO isn_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","uYesu akihenga nkika yihi nu kua tambuila i amanyisigwa akwe, “Ingi kinya uli niyili ikaku ku mugoli kingila mu utemi nuang'wa Itunda! ");
INSERT INTO isn_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Amanyisigwa ai akuiwe ku makani aya. Kuiti uYesu aka atambuila hangi, “Ang'yinya, ingi kinya uli ni yili ikaku kingia mu utemi nuang'wa Itunda! ");
INSERT INTO isn_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ingi itontu ku ngamia kingila mu nzuunki a lusinge, kukila muntu nu mugoli kingila mu utemi nuang'wa Itunda.” ");
INSERT INTO isn_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ai akuiwe nangaluu hangi akitambullya, “Iti gwa nyenyu ukugunika” ");
INSERT INTO isn_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","uYesu aka agoza nu kuligitya, “Kung'wa bina adamu shanga ihumikile, kuiti shanga kung'wa Itunda. Ku nsoko mung'wa Itunda ihi ahumikile.” ");
INSERT INTO isn_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","uPetro akandya kuligitya nu ng'wenso, “Goza kulekile yihi hangi kakutyata.” ");
INSERT INTO isn_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","uYesu akaligitya, “I tai kumuila unyenye, kutili nualekilee ito ang'wi heu, ang'wi muluna musungu, ang'wi nyinya, ang'wi tata, ang'wi ana, ang'wi mugunda, ku nsoko ane, ni kunsoko a nkani ni nziza, ");
INSERT INTO isn_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","naize shanga ukusingiilya nkua igana ikilo a itungili papa mi ihi; Ito, heu, muluna musungu, nyinya, ana, nu mugunda, ku lwago, nu unkumbigulu nu upembilye, upanga mua kali na kali. ");
INSERT INTO isn_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kuiti idu niaile ang'wandyo akutula a ng'wisho hang ni aile a ng'wisho akutula a ng'wandyo.” ");
INSERT INTO isn_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nai atula munzila, kulongola ku Yerusalemu, uYesu ai watulaa utongee ntogeela ao. Amanyisigwa ai akuiwe, hangi awo nai atulaa atyatile ku nyuma ai itumbile. Uugwa uYesu akaapumya ku mpelo hangi awo ni ikumi na abiili nu kandya kuatambuila naiza kikumupumila iti pakupi; ");
INSERT INTO isn_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Goza, kulongoe kupikiila ku Yerusalemu, nu Ng'wana nuang'wa Adamu ukupikigwa ku akuhani ni akulu ni amanyi. Akumulamula washe hangi akumupumya ku anyaigu. ");
INSERT INTO isn_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Akumukuna, akumutyila i mate, akumukua milanga, hangi akumubulaga. Kuiti ze yakilaa mahiku ataatu ukiuka.” ");
INSERT INTO isn_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","uYakobo nu Yohana, ana ang'wa Zebedayo, ai azile kitalakwe nu kumutambuila, “Ng'walimu, kuloilwe ukutendeele kihi ni ku ukulompa.” ");
INSERT INTO isn_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ai uatambuie, “Muloilwe numutendeele ntuni?” ");
INSERT INTO isn_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Akaligitya, “Ukugombye kikie nu ewe mi ikulyo nilako, ung'wi mu mukono nuako nua kigoha nu muya mukono nuako nua ki kima.” ");
INSERT INTO isn_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kuiti uYesu ai uasukiiye, “Shanga mulingile ni muku kilompa. Muhumilene kuking'wela i kikombe naiza kuking'wela ang'wi kugimya u wogigwa naza nikogigwa?” ");
INSERT INTO isn_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Akamutambuila, “Kuhumile” uYesu aka atambuila, “ i kikombe ni nika king'wela, mu kuking'wela. Nu wogigwa naza kitalao nogigwe, muku ugimya. ");
INSERT INTO isn_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kuiti nuikikie mukono nuane nua kigoha ang'wi nua kikima shanga nene nina kupumya, kuiti ingi ku awo naza kitalao yakondile kuzipiiligwa.” ");
INSERT INTO isn_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Awo i amanyisigwa auya ikumi nai akija aya, akandya ku atakiila uYakobo nu Yohana. ");
INSERT INTO isn_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","uYesu akaitanga kitalakwe ku kuligitya, “Mulingile kina awo niasigile kina ahumi nia anyaingu i ahumaa, ni antu ao ni ahugu ia lagiila u uhumi migulya ao ");
INSERT INTO isn_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kuiti shanga itakiwe kutula iti mukati anyu. Wihi nuloilwe kutula mukulu kati anyu kusinja nua muaiilye, ");
INSERT INTO isn_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","hangi wihi nuloilwe kutula wang'wandyo mu kati anyu ingi kusinja watule mutuung'wa nua ihi. ");
INSERT INTO isn_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ku nsoko uNg'wana nuang'wa Adamu shanga aza uzile kuailigwa ila kuailya, nu kulupumya u likalo nulakwe kutula usukiilya ku idu.” ");
INSERT INTO isn_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Akapembya ku Yeriko. Nai wakatula ukuhega ku Yeriko ni amanyisigwa akwe hangi idale ikulu, ng'wana nuang'wa Timayo, Batimayo, mupoku nuilompaa, ai wikie mpelo ipamda. ");
INSERT INTO isn_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nai wakija kina ingi Yesu Munazareti, ai wandilye kuzogolya nu kuligitya, “Yesu, Ng'wana nuang'wa Daudi, mbaisiilye!” ");
INSERT INTO isn_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Idu ai amupatilye u mupoku uyo, aze mutambuila wakilage. Kuiti ai uliile ku luli ikilo, “Ng'wana nuang'wa Daudi, mbaisiilye!” ");
INSERT INTO isn_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","uYesu ai wimikile nu kulagiilya witangwe. Ai amitangle u mupoku uyo, azeligitya, Kina mukomoli! nyansuka! Yesu ukuitanga.” ");
INSERT INTO isn_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Akauguma ku mpelo u mujulungu nuakwe. akamanka ikilo, nu kupembya kung'wa Yesu. ");
INSERT INTO isn_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","uYesu akamusukiilya nu kuligitya, “Uloilwe nukutendele ntuni?” U mugoha uyo nu mupoku akasukiilya, “Ng'walimu, ndoilwe kihenga.” ");
INSERT INTO isn_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","uYesu akamuila, “Longola, u uhuiili nuako wakuguna.” Papo paapo i miho akwe akihenga; hangi akamutyata uYesu mi ipanda. ");
INSERT INTO isn_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Itungo nilanso nai akapembya ku Yerusalemu, Nai akahumbeela ku Besthfage ni Bethania, mu Lugulu nula Mizeituni, uYesu ai ualagiiye abiili mukati a amanyisigwa niakwe ");
INSERT INTO isn_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","hangi ai uatambuie, “Longoli mu kijiji kigozenkanile nu sese. Itungo ni mikingila mung'wanso, mikamuhanga ng'wa andogwe naiza wakili nankilwa. Mutunguili hangi mu mulete kitalane. ");
INSERT INTO isn_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Hangi anga wihi wamutambuila, “Ku niki mukituma iti?” mutakiwe kuligitya, ' Mukulu umutakile hangi itungo ukumususha papa.” ");
INSERT INTO isn_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Akalongola nu kumuhanga u ng'waa ndogwe utungilwe kunzi a mumpita mu kisali niking'walyi, ni enso ai amutunguie. ");
INSERT INTO isn_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Hangi ang'wi a antu nai akoli imikile pa ng'wanso hangi aka atambuila, “Mukituma ntuni, kumutungula u ng'waa ndogwe nuanso?” ");
INSERT INTO isn_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ai a atambuie anga uYesu nai ua tambuie, hangi i antu aka aleka alongole. ");
INSERT INTO isn_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Amanyisigwa a biili ai amuletile u ng'waa ndogwe kung'wa Yesu hangi ai aie ang'wenda ao migulya akwe iti uYesu wahume kumunankila. ");
INSERT INTO isn_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Antu idu akaila i ang'wenda ao mu balabala, ni auya ai aie ntaambi nai aitemile kupuma mu migunda. ");
INSERT INTO isn_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Awo nai alongoe ntongeela akwe hangi nawo nai amutyatiie ai azogooye, “Hosiana, Ukendepilwe nupembilye ku ilna nila Mukulu. ");
INSERT INTO isn_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ukendepwe u utemi nu upembilye nuang'wa tata itu u Daudi! Hosiana kung'wa nu koli migulya” ");
INSERT INTO isn_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Uugwa uYesu akingila ku Yerusalemu hangi ai ulongoe mi itekeelo hangi akagoza kila i kintu. Itungili, itungo ai latulaa lalongola, ai ulongoe ku Bethania palung'wi nawo ni ikumi na abiili. ");
INSERT INTO isn_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Luhiku nai lutyatile, itungo nai atula agomokile kupuma ku Bethania, ai watulaa ni nzala. ");
INSERT INTO isn_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Hangi akihenga u mutini nai ukete matutu ku kahelu, ai ulongoe kugoza anga ize ai uhumile kulija kihi migulya akwe. Hangi itungo nai watula ulongoe ku nuanso, shanga akalija kihi kwaala matutu, ku nsoko shanga ai matungo a mutini. ");
INSERT INTO isn_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ai u utambuie, “Kutili wihi nuikalya i nkali kupuma kitaalako hangi.” Hangi i amanyisigwa akwe akija. ");
INSERT INTO isn_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ai azile ku Yerusalemu, nu ng'wenso ai wingie mi itekeelo hangi akandya kuapumya kunzi i agulya ni aguli mukati i itekeelo. Ai uipiue i meza nia akaila mpia ni matuntu a awo nai atulaa akugulya i nkunda. ");
INSERT INTO isn_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Shanga ai umulekee wihi kukenka kihi mi itekeelo nai kihumile kuguligwa. ");
INSERT INTO isn_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ai uamanyisilye hangi akaligitya, “Iti shanga ai ikilisigwe ne, 'ito nilane likitangwa ito nila ikumbiko ku anyaingu ihi?' kuiti malitenda ikulungu nila asapuilang'yi.” ");
INSERT INTO isn_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Akuhani niakulu ni amanyi ai igulye nai watulaa wiligitya, ni enso ai adumile nzila a ku mubulaga. Ga ni iti ai amogopile ku nsoko i umbi ai likuiwe nu umanyisigwa nuakwe. ");
INSERT INTO isn_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Hangi kila itungo i mpindi nai ipikile, ai ahegile mu kisali. ");
INSERT INTO isn_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nai atula akugenda kidau dau, ai ui hengile u mutini wumile kupikiila mu mili akwe. ");
INSERT INTO isn_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","uPetro ai ukimbukile nu kuligitya, “Rabi! Goza, ikota nila mutini nai u uzumile wumaa.” ");
INSERT INTO isn_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","uYesu ai uasukiiye, “Mutule nu uhuiili mung'wa Itunda. ");
INSERT INTO isn_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Huiili kumuila kina kila nu iluilaa u lugulu ulu, ' Hega, hangi wigumile u mukola mu luzi, 'hangi anga ize mugila i nkankani mu nkolo akwe kuiti uhuiie kina nukiligitilye kikupumila, iti uu Itunda nuikituma. ");
INSERT INTO isn_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ku lulo kumuila; kila i kintu ni mulompile nu kukolya ku nsoko akwe, huiili kina mukusingiilya, ni yenso yukutula yanyu. ");
INSERT INTO isn_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Matungo ni mukimika nu kulompa, mutakiwe kulekela kihi ni mukikete ku wihi, iti kina uTata nuanyu nukoli kilunde amulekele ga nu nyenye u utumuli nuanyu. ");
INSERT INTO isn_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(Komaniilya; Ulukiili ulu, “Kuiti angamuhite kulekela, ang'wi uTata nuanyu nukoli kilunde shanga ukulekela i milandu anyu” umutili mu mbugulu nia kali). ");
INSERT INTO isn_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nai atulaa ku Yerusalemu hangi. Nu Yesu nai watulaa ukugenda mi itekeelo, akuhani ni akulu, amanyi ni anyampala ai azile kitalakwe. ");
INSERT INTO isn_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ai amutambuie, “Ku uhumi kii ukituma i makani aya?” Hangi ingi nyenyu numinkiiye u uhumi nua kituma aya?” ");
INSERT INTO isn_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","uYesu ai uatambuie, “Nikamukolya ikolyo ling'wi. Ntambuili nu nene nikamutambuila ku uhumi kii kituma i makani aya. ");
INSERT INTO isn_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Itii, u wogigwa nuang'wa Yohana ai upumile kilundene ang'wi ai upumile ku ana adamu? Nsukiilyi.” ");
INSERT INTO isn_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ai itambuuye mukati ao nu kikilya nu kuligitya, “Anga kuligitye, 'Kupuma kilunde,' ukuligitya, 'Ku niki gwa shanga ai ku muhuiie? ");
INSERT INTO isn_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kuiti anga kuligitye, ' Kupuma ku ana adamu,'...” Ai aogopile i antu, ku nsoko ihi ai a ambiie kina uYohana ai watulaa munyakidagu. ");
INSERT INTO isn_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Uugwa ai amusukiiye uYesu nu kuligitya, “Shanga kulingile. Uugwa uYesu aka atambuila, “Uugwa nu nene shanga kumutambuila ingi ku uhumi kii kituma i makani aya. ");
INSERT INTO isn_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Uugwa uYesu ai wandilye kuamanyisa ku mpyani. Akaligitya, “Muntu ai utemee mugunda nua mizabibu, akaukitiila ikito, hangi akahimba ikombo nila kugundikila u muvinyo. Akazenga i kilingasiilyo hangi uugwa aka wiliha u mugunda nua mizabibu ku alimi nia mizabibu. Uugwa ai utungile muhinzo nua kuli. ");
INSERT INTO isn_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Itungo nai lipikile, ai umulagiiye munyamulimo ku alimi nia mizabibu kusingiilya kihi kupuma kitalao ing'wi nia nkali nia mugunda nua mizabibu. ");
INSERT INTO isn_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kuiti ai amuambile, akamukua, hangi akamuzunsa bila kintu. ");
INSERT INTO isn_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Akalagiilya kitalao munya mulimo mungiiza, akamuaalya kitwe nu kumutendeela makani a minyala. ");
INSERT INTO isn_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ikili ai umulagiiye mungiiza, nuyu nu ng'wi akamubulaga. Ai a atendee ni auya idu makani anga yayo yaayo, aze akua ni auya kuabulaga. ");
INSERT INTO isn_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ai wakili ukete muntu ung'wi ikilo nua kumulagiilya, ng'wana mulowa. Nu ng'wenso ai watulaa wang'wisho nai ulagiigwe kitalao. Akaligitya, “Akumukulya u ng'wana nuane.” ");
INSERT INTO isn_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kuiti i ilihwa akitambulya enso ku enso, “Uyu ng'wenso musali. Pembyi, si ni kumubulage, nu usali ukutula witu ");
INSERT INTO isn_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ai amugilinkiiye, akamubulaga nu kumuguma kunzi a mugunda nua mizabibu. ");
INSERT INTO isn_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ku lulo, Itii! Ukituma ntuni u mukola hiu nua mugunda nua mizabibu? Ukupembya nu kualimilya i alimi nia mizabibu nu kuwinkiilya u mugunda nua mizabibu ku angiiza. ");
INSERT INTO isn_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mukili kulija kusoma u ukilisigwa uwu? “ Igwe naiza ia zengi ai alihitile, latulaa igwe nila kumpelo. ");
INSERT INTO isn_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ili ai lipumile ku Mukulu, hangi ingi nila ukuilwa mu miho itu” ");
INSERT INTO isn_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ai adumile kumuamba uYesu, Kuiti ai aogopile i anyianza, Kuiti ai alingile kina ai watulaa utambue i mpyani nanso ki italao. Iti gwa ai amulekile akalongola yao. ");
INSERT INTO isn_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Uugwa aka alagiilya ang'wi a afarisayo ni a herode kitalakwe iti ku mugema ku nkani. ");
INSERT INTO isn_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nai akapika, akamuila, “Ng'walimu, kulingile kina shanga ukee i masigo a wihi hangi shanga ulagiie ukuiili kati a antu. Ukumanyisa i nzila ang'wa Itunda mu tai. Itii! ingi tai ane kupumya i kodi kung'wa Kaisari ang'wi ishi? Itii! Kuhumile kupumya ang'wi ishi? ");
INSERT INTO isn_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kuiti uYesu ai ulingile u udosi nuao nu kuatambuila, “Kuniki mukungema? Ninkiilyi i dinari nihume kumigoza.” ");
INSERT INTO isn_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Akaleta ing'wi kung'wa Yesu, Aka atambuila, Itii! ingi ikelu lang'wa nyenyu nu ukilisigwa nu ukoli apa ingi wang'wa nyenyu? Akaligitya, “Wang'wa Kaisari.” ");
INSERT INTO isn_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","uYesu aka atambuila, Minkiilyi u Kaisari i intu niang'wa Kaisari nu Itunda i intu niang'wa Itunda.” Akamukuilwa. ");
INSERT INTO isn_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Uugwa iAsadukayo, ni iligitya kutili u wiuki, ai akamutyata. Akamukolya, azeligitya. ");
INSERT INTO isn_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ng'walimu, uMusa ai ukukilisiiye kina, 'Anga itule u muluna washe nu kumuleka u mukima ku nyuma akwe, Kuiti shanga ulekile ung'wana, muntu ukumuhola u mukima nua muluna nuakwe, nu kiligilya u ng'wana ku nsoko a muluna nuakwe.' ");
INSERT INTO isn_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ai akoli ni aluna mupungati, nu ang'wandyo ai uhoile u mukima ni hangi akasha, shanga ai ulekile u ng'wana. ");
INSERT INTO isn_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Uugwa nua kabiili ai umuhoile nung'wenso akasha, shanga ai ulekile u ng'wana. hangi nua kataatu ga ni iti. ");
INSERT INTO isn_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Hangi nua mupungati shanga akaleka u ng'wana. Mpelo akwe ga nu musungu akasha. ");
INSERT INTO isn_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Itungo nila wiukigwa, ni ikiukigwa hangi, Itii! Ukutula mukima wang'wa nyenyu? Kuiti awo i aluna ihi mupungati ai atulaa agoha akwe.” ");
INSERT INTO isn_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","uYesu ai uatambuie, “Itii! Ili shanga nsoko kutula malimiligwaa, ku nsoko shanga mulingile u ukilisigwa ang'wi ngulu niang'wa Itunda?” ");
INSERT INTO isn_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Itungo nila kiukigwa puma ku ashi, shanga akutina ang'wi kingila mu utinwa, ila akutula anga i amalaika nia kilunde ");
INSERT INTO isn_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kuiti, kutula ashi naiza akiukigwa, Itii! Shanga ai musomile kupuma mu mbugulu ang'wa Musa, mu nkani ni yi tunku, iti Itunda nai uligitilye nu kumuila, 'Unene ingi Itunda nuang'wa Abrahamu, hangi Itunda wang'wa Isaka, hangi Itunda wang'wa Yakobo?' ");
INSERT INTO isn_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nuanso shanga Itunda nua ashi, ila nua ni akoli apanga. Ingi i kihenga malimilaa.” ");
INSERT INTO isn_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ung'wi nua amanyi akapembya nu kija i ntambu ao; ai wihengile kina uYesu ai uasukiiye iziza. Ai umukoiye, Itii! ingi ilagiilyo ni liuli nilikete u usanigwa ikilo mu ihi?” ");
INSERT INTO isn_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","uYesu ai umusukiiye, “Nila kusanigwa ingi sili, “Ije, Israeli, Mukulu Itunda nuitu, Mukulu ingi ung'wi. ");
INSERT INTO isn_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kusinja u mulowe uMukulu Itunda nuako, ku nkolo ako ihi, ku Ngwau ng'welu nuako wihi, ku mahala ako ihi, nu ku ngulu niako yihi.' ");
INSERT INTO isn_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ilagiilyo nila ka biili ingi sili, 'Kusinja umulowe u munyakisali nuako anga nuiloilwe u mukola.' Kutili ilagiilyo ingiiza ni ikulu kukila aya.” ");
INSERT INTO isn_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","uMumanyi akaligitya, “Iziza Ng'walimu! Uligitilye tai kina Itunda ini ung'wi, ni kina kutili nu mungiiza kukila nuanso. ");
INSERT INTO isn_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kumulowa nuanso ku nkolo ihi, nu ku ulingi wihi nu ku ngulu yihi, nu kumulowa u munyakisali anga u mukola, ingi kusanigwa nangaluu kukila i masongelyo ang'wi ipolya nila kulimiligwa.” ");
INSERT INTO isn_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Itungo uYesu nai wakihenga kina wapumya isosho nila upolo, akamutambuila, “Uewe shanga ukoli kuli nu utemi nuang'wa Itunda.” Ze yakilaa pang'wanso kutili ga nung'wi nai ugemile kumukolya uYesu makolyo ihi. ");
INSERT INTO isn_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Hangi uYesu ai usukiiye, itungo nai watula ukumanyisa mu itekeelo, akaligitya, “Itii! amanyi iligitya kina uKristo ingi ng'wana wang'wa Daudi? ");
INSERT INTO isn_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","uDaudi mukola mu Ng'wau Ng'welu, ai uligitilye, 'uMukulu ai uligitilye ku Mukulu nuane, ikie mu mukono nuane nua kugoha, kupikiila niazipye i alugu niako kutula pihi a migulu ako.' ");
INSERT INTO isn_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","uDaudi mukola wimitangaa uKristo, 'Mukulu' Itii! ingi ng'wana wang'wa Daudi kinya uli?” Hangi milundo ukulu ai umutegeeye ku ulowa. ");
INSERT INTO isn_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mu umanyisigwa nuakwe uYesu ai uligitilye, “Ikendegeeli nia manyi, niakete i nsula akugenda nia mujulungu nialipu nu kulamukigwa mu masoko ");
INSERT INTO isn_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","nu kikie mu matuntu a akulu mu matekeelo nu mu siku kuu ku nkika nia akulu. ");
INSERT INTO isn_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Akulya ga ni mato a ahimbi hangi akulompa malompi malipu iti kina i antu aihenge. Antu awa akusingiilya u ulamula nu ukulu.” ");
INSERT INTO isn_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Uugwa uYesu ai wikie pihi pakupi ni isandiko nila masongelyo mukati a nkika itekeelo; Ai watula ukugoza antu nai atulaa akuikila i mpia niao mukati i sandiko. Antu idu i agoli ai aikie ngele nkulu a ampia. ");
INSERT INTO isn_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Uugwa musungu muhimbi muula ai uzile nu kuikila ipande ibiili, nsailo a senti. ");
INSERT INTO isn_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Uugwa akaitanga i amanyisigwa akwe nu kuatambuila, Huiili kumutambuila, u musungu uyu nu muhimbi uikie ngele nkulu ikilo a ihi naza akondya pumya mu isandiko nila masongelyo. ");
INSERT INTO isn_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kuiti ihi apumilye kupumiila nu widu nua upuli nuao. Kuiti u musungu uyu nu muhimbi, kupuma mu uula nuakwe, uikie i mpia yihi naza ai utakiwe kuitumila ku likalo nu lakwe. ");
INSERT INTO isn_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","uYesu nai wakatula ukugenda kupuma mi itekeelo, ung'wi nua amanysigwa akwe akamukolya, “Ng'walimu, goza i magwe aya ni aku kuilwa ni mazumba!” ");
INSERT INTO isn_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Akamutambuila, Ukihenga i mazumba aya ni makulu? Kutili ga nigwe ni ling'wi nilika sagiila migulya a lingiiza ni shanga aza likugwa pihi.” ");
INSERT INTO isn_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nu ng'wenso nai wakatula wikie migulya a lugulu nula mizeituni kituli ki itekeelo, uPetro, Yakobo, Yohana nu Andrea akamukolya ku kinkunku. ");
INSERT INTO isn_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Kuile, i makani aya akutula nali? Ingi ntuni i kilingasiilyo nika makani aya kupumila?” ");
INSERT INTO isn_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","uYsu ai wandilye kuatambuila, “Tuli miakendegeeli kina mntu wihi waleke kumulimilya. ");
INSERT INTO isn_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Idu ikapembya ku lina nilane azeligitya 'Unene ng'wenso,' hangi akualimilya idu. ");
INSERT INTO isn_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ni mikija ulugu nu pwepwe nua uligu, leki kitumbi; makani aya atakiwe kupumila, kuiti i mpelo ikili. ");
INSERT INTO isn_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ihi likunyansuka kikua ni ihi lingiiza, nu utemi nsuta nu utemi. Yikatula ni matetemeko nkika nia kuli ni kuli, hangi nzala. Uwu ingi ng'wandyo nua uwai. ");
INSERT INTO isn_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Tuli miho. Akumutwala kupikiila mu maanza, hagi mukukuwa mu matekeelo. Mukimikigwa ntongeela a ahumi ni atemi ku nsoko ane, anga ukuiili kitalao. ");
INSERT INTO isn_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kuiti i nkani ninza kusinja hanza itanantigwe ku anyaingu ihi. ");
INSERT INTO isn_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ni ikatula amuamba nu kuinkiilya, leki kitumbi kutula iko nimukaligitya. Mukati itungo nilanso, mukinkiiligwa ntuni nika kuligitya; shanga mikatula nyenye ni mikaligitya, ila Ng'wau Ng'welu. ");
INSERT INTO isn_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Munyandugu ukumusemela u muluna kubulagwa, u tata nu ng'wana nuakwe. iAna akimika nsuta a atata ao hangi kuasasha kubulagwa. ");
INSERT INTO isn_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mukutakiilwa ni kila u muntu ku nsoko a lina nilane. Kuiti nuikagimya kupikiila i mpelo, muntu nuanso ukugunika. ");
INSERT INTO isn_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ni mikihenga utaki nua ubipigwa wimikile pang'wanso ni shanga utakiwe kimika (nukusoma nua linge), papo niamoli mu Yuda amankiile mu malugulu, ");
INSERT INTO isn_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","nu ng'wenso nukoli migulya i ito nualeke kusima pihi ito, ang'wi kuhola kihi nikikoli kunzi, ");
INSERT INTO isn_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","hangi nukoli mu mugunda waleke kusuka kuhola u ng'wenda nuakwe. ");
INSERT INTO isn_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kuiti ukia awo i asungu niakete inda nawa niakonsha mu mahiku nanso! ");
INSERT INTO isn_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Lompi kina ileke kupumila itungo nila ulyuuku. ");
INSERT INTO isn_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kuiti yikatula nu lwago lukulu, naiza lukilikaya kupumila, puma Itunda nai u umbile u unkumbigulu, kupikiila itungili, ishi, ang'wi shanga ikapumila hangi. ");
INSERT INTO isn_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kupikiila u Mukulu nuikakepya i mahiku. Kutili u muili nuikagunika, kuiti ku nsoko a asagulwa, nuika asagula, wikakepya i namba nia mahiku. ");
INSERT INTO isn_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Matungo nanso anga ize muntu wihi wika mutambuila, 'Goza, uKristo ukoli apa!' ang'wi 'Goza, ukoli apo!' leki kuhuiili. ");
INSERT INTO isn_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kuiti iAkristo nia uteele ni anyakidagu nia uteele akupumila hangi akupumya ilingasiilyo nu ukuilwa, iti kina, amukongele, nsigile ga ni asagulwa. ");
INSERT INTO isn_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Tuli miho! Nakondyaa mutambuila aya ze akili i matungo. ");
INSERT INTO isn_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Kuiyi ze yakilaa u lwago nula mahiku nanso, i lyoa likuikilwa kiti, u ng'weli shanga ukupumya u welu nuakwe, ");
INSERT INTO isn_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","i nzota yukugwa kupuma kilunde, ni ingulu ni ikoli kilunde yukuhingiika. ");
INSERT INTO isn_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Papo ni ikamihenga u Ng'wana wang'wa Adamu upembilye mu malunde ku ngulu nkulu ni ikulyo. ");
INSERT INTO isn_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Papo ukulagiilya i amalaika akwe hagi ukuilingiila palung'wi i asagulwa akwe kupuma nkika inne ni yihi, kupuma i mpelo nui ihi kupikiila i mpelo ilunde. ");
INSERT INTO isn_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ku mutini imanyisi. Anga itambi nili humile kupumya nu kuika u ukende mu matutu akwe, papo mukulinga kina i kipasu kikoli pakupi. ");
INSERT INTO isn_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Uu gwa yili, nimikihenga i makani aya anga apumile, lingi kina ukoli pakupi, ni mimpita. ");
INSERT INTO isn_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tai, kumuili, uwu u ulelwa shanga ukukila kuli ze akili imakani aya kupumila. ");
INSERT INTO isn_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ilunde ni ihi yukukila, kuiti imakani ane shanga akukila lukulu. Kuiti kutula luhiku nulanso ang'wi saa, ");
INSERT INTO isn_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","kutili nulingile, ga nia malaika nia kilunde, ang'wi Ng'wana, ila Tata. ");
INSERT INTO isn_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Tuli miho, Gozi, ku nsoko shanga mulingile ingi itungo kii akupumila. (Komaniilya; U lukiili ulu, “Mutule miakendegeeli, Gozeeli hangi lompi ku nsoko .....” umutili mu mbugulu nia kali). ");
INSERT INTO isn_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ingi anga umuntu nulongoe muhinzo; wakaleka ito nilakwe, nu kumuika u mutuung'wa nuakwe kutula muhumi nu ito, kila ung'wi nu mulimo nuakwe. Nu kumulagiilya u musunja kikie miho. ");
INSERT INTO isn_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ku lulo tuli miho! Kuiti shanga mulingile ingi nali u mukulu nu ito nuikagomoka ki ito, ihumikile ingi mpindi, utiku nuigingu, itungo nila nsambaligugu ni ikakunkula, ang'wi kidau dau. ");
INSERT INTO isn_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Anga waze kupumpugiilya, waleke kuhanga ulae. ");
INSERT INTO isn_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Iko ni kukiligitya ku kila u muntu; Huguki!” ");
INSERT INTO isn_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ai yatulaa mahiku abiili duu ze yakilaa i siku kuu a pasaka nulu nula mikate Ni shanga I ikiwe i igai. Akuhani niakulu ni amanyi ai atulaa akuduma nzila akumuamba uYesu ku uhugu nu kumubulaga. ");
INSERT INTO isn_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ku nsoko ai aligitya, “Shanga itungo lili nila siku kuu, antu aleke kuza kituma u minyomo.” ");
INSERT INTO isn_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Matungo uYesu nai ukoli ku Bethania mi ito kung'wa Simioni munyambili, hangi nai wakatula utungile mu meza, musungu ung'wi ai uzile kitalakwe waze ukete i nsupa a manyunkiilo a nardo nziza ikete nsailo nkulu nangaluu, ai umibunangile i nsupa nu kumadubunsha migulya itwe nilakwe. ");
INSERT INTO isn_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kuiti ai akoli ang'wi ao nai atakile. Ai itambuie enso ku enso azeligitya, “Ingi ntuni insoko a ulimilyi uwu? ");
INSERT INTO isn_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Manyunkiilo aya aza azeeguligwa ku dinari magana ataatu ni ikilo, hangi apegwe i aula.” Ni enso ai amupatilye. ");
INSERT INTO isn_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kuiti uYesu ai uligitilye, “Muleki wing'wene duu. Ku niki mukumunyoma? Witumile ikani iza kitalane. ");
INSERT INTO isn_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mahiku ihi i aula muakete, hangi itungo lihi ni mukuhung'wa i nsula muhumile kituma ni maza kitalao, kuiti shanga mukutula nu nene itungo lihi. ");
INSERT INTO isn_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Witumile iko nukihumile, u upuguhie u muili nuane i makuta ku nsoko a uikwi. ");
INSERT INTO isn_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tai kuimuili, kila i kianza i nkani ninza niuku tanantigwa mu unkumbigulu wihi, iko nukitumile u musugu uyu kikutambulwa ku ukimbukiilyi nuakwe. ");
INSERT INTO isn_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Uugwa uYuda Iskariote, ung'wi nua awo ikumi na abiili, ai ulongoe ku akulu a akuhani iti kina walije kuminkiilya kitalao. ");
INSERT INTO isn_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Matungo i akulu a Akuhani nai igulye ili, ai iloile hangi akalaga kuminkiilya mpia. Ai wandilye kuduma ilyoma nila kuminkiilya kitalao. ");
INSERT INTO isn_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mu luhiku nula ng'wandyo nula mkate nishanga uikiwe i igai, itungo nai apumilye u ng'waa nkolo nua pasaka, amanyisigwa niakwe ai amutambuie, “Uloilwe kulongole pii kuzipiilye iti ulije kulya u ludya nula pasaka?” ");
INSERT INTO isn_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ai ua lagiiye amanyisigwa akwe abiili nu kuatambuila, “Longoli mu kisali, nu mitunja naiza ukenkile i ntunda ukiona nu nyenye. Mutyati. ");
INSERT INTO isn_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ito nuikingila, mutyati hangi mutambuili u mukola ito nilanso, ' Ung'walimu uligitilye, Kikoli pii i shumba nika aziila kianza ni nikalila i pasaka ni amanyisigwa ane?” ");
INSERT INTO isn_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ukumulagiila i shumba nika migulya kikulu ni kikete i iseme niize kikoli kikondile. Itumi u uzipiilya ku nsoko itu pang'wanso.” ");
INSERT INTO isn_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Amanyisigwa ai ahegile akalongola mu kisali; ai ahangile kila ikintu anga nai watulaa uatambuie, hangi akazipiilya u ludya nula pasaka. ");
INSERT INTO isn_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Matungo nai yatula mpindi, ai upembilye ni awo ikumi na abili. ");
INSERT INTO isn_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Hangi nai akatula akumihumbeela i meza nu kulya, uYesu ai uligitilye, Tai kumutambuila, umg'wi kati anyu nukulya palung'wi nu nene ukungumaniilya.” ");
INSERT INTO isn_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ihi akasiga ikulu, hangi ung'wi ze yakilaa u muya ai amutambuie, “Kulu kuulu shanga u nene?” ");
INSERT INTO isn_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","uYesu ai usukiiye nu kuatambuila, “Ingi ung'wi nua ikumi na abiili kati anyu, ung'wi naiza itungili ukuliilya ipuli mi bakuli palung'wi nu nene. ");
INSERT INTO isn_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ku soko uNg'ana wang'wa Adamu ukulongola anga uu u ukilisigwa nu uligitilye migulya akwe. Kuiti ukia nuakwe u muntu uyo naiza kukiila nuanso u Ng'wana wang'wa Adamu ukugumaniilgwa! Aza izeetula iziza kunkilinkiila ku ng'wakwe anga ize u muntu nuanso ai uzeeleka kutugwa ");
INSERT INTO isn_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Hangi nai atula akulya, uYesu ai uhoile u mukate, akaukendepa, nu ku uega. Akainkiilya wazeligitya, “Holi. Uwu ingi muili nuane.” ");
INSERT INTO isn_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ai uhoile i kikombe, akalumbiilya, hangi akainkiilya, hangi ihi akaking'wela. ");
INSERT INTO isn_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ai uatambuie, “Iyi ingi sakami ane na wigombya, sakami ni hunuka ku nsoko a idu. ");
INSERT INTO isn_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tai kumutambuila, shanga kung'wa hangi mu nkali iyi na muzabibu kupikiila u luhiku ulo ni nikang'wa nu upya mu utemi nuang'wa Itunda.” ");
INSERT INTO isn_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nai akondya kimba u wimbo, ai alongoe kunzi mulugulu nula mizeituni. ");
INSERT INTO isn_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","uYesu ai uatambuie, “Unyenye mihi mukibagula kuli ku nsoko ane, ku nsoko ikilisigwe, 'Nikamukua u mudimi ni nkolo yukusapatila.' ");
INSERT INTO isn_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“Kuiti ze yakila ku iuka kitalane, nikamutongeela ntongeela anyu ku Galilaya.” ");
INSERT INTO isn_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","uPetro ai umutambuie, “Anga itye ihi ga akuuleka, unene shanga kuuleka.” ");
INSERT INTO isn_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","uYesu ai umutambuie, “Tai nakutambuila, u utiku uwu, ze ikili i nsambaligugu ku kunkula nkua ibiili, wikatula wanihita nkua itaatu.” ");
INSERT INTO isn_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kuiti uPetro ai uligitilye, “Anga insinje ga nu kusha palung'wi nu ewe, shanga ku uhita.”Ihi ai apumilye ilago lilo liilo. ");
INSERT INTO isn_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ai apembilye mu nkika nai itangwaa Gethsemane, nu Yesu ai uatambuie i amanyisigwa akwe, “Ikii papa itungo ni kikumbika.” ");
INSERT INTO isn_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ai uahoile u Petro, Yakobo nu Yohana palung'wi nu ng'wenso, akandya kuhung'wa kinya uwai nu kaga nangaluu. ");
INSERT INTO isn_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ai uatambuie ung'yenyi nuane ukete kinya uwai nangaluu, ga insha. Sagi papa nu kelya.” ");
INSERT INTO isn_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","uYesu ai ulongoe ntongeela iniino, akagwa pihi, akalompa, anga ize ihumikile, kina isaa iyi aza ize muhuga. ");
INSERT INTO isn_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ai uligitilye, “Aba, Tata, Makani ihi kitalako ahumikile. Nihegelye i kikombe iki. Kuiti shanga ku ulowa nuane, ila ulowa nuako.” ");
INSERT INTO isn_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ai ugomokile nu kua hanga alala, hangi aka mutambuila uPetro, “Simioni, itii walalane? Shanga wahuma kelya ga i saa ing'wi? ");
INSERT INTO isn_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Huguki hangi mulompe muleke kingila mu mageng'wa. Kulu kuulu i nkolo ikoli iziza, kuiti u muili ingi unementaalu.” ");
INSERT INTO isn_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ai ulongoe hangi nu kulompa, hangi ai utumie makani yayo yaayo. ");
INSERT INTO isn_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ai upembilye hangi waka ahanga alala, kunsoko miho ao ai atulaa malito hangi shanga ai alingile ntuni nika kumutambuila. ");
INSERT INTO isn_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ai uzile nkua aka taatu nu kuatambuila, Mukili mulae nu kusupyaa? Yakonda! isaa apikaa. Goza! uNg'wana wang'wa Adamu ukugumaniiligwa mu mikono a anya milandu. ");
INSERT INTO isn_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Uki, kwini. Goza, uyo nuendaa ngumaniilya ukoli pakupi.” ");
INSERT INTO isn_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Itungo udu nai watula wakili ukuligitya, uYuda, ung'wi nua awo ni ikumi na abiili, ai upikile, ni idale ikulu kupuma kuakulu a akuhani, amanyi ni anyampala akete i mpanga ni idunkuli. ");
INSERT INTO isn_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Itungo nilanso u mugumaniilyi nuakwe ai watulaa uinkiiye kilingasiilyo, wazeligitya. Uyo ni nikamulungila, ng'wenso. Muambi nu kumutwala pihi a usunji.” ");
INSERT INTO isn_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Itungo u Yuda nai upikile, kang'wi duu ai ulongoe kung'wa Yesu nu kuligitya, “Ng'walimu!” Hangi akamulungila. ");
INSERT INTO isn_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Uugwa akamuika pihi a usunji nu kumuamba. ");
INSERT INTO isn_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kuiti ung'wi kati ao nai wimikile pakupi nu ng'wenso ai uhopoe i mpanga akwe akamukua u munyamilimo wang'wa kuhani nu mukulu nu kumutema u kutwi. ");
INSERT INTO isn_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","uYesu ai uatambuie, “Mupembilye kumamba ku mapanga ni idunkuli anga muhegelanyi? ");
INSERT INTO isn_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Matungo kila luhiku ai nkoli nu nyenye hangi nizemanyisa mi itekeelo, shanga ai mumambile. Kuiti ili litumikile iti ukilisigwa ukondaniile. ");
INSERT INTO isn_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Hangi awo ihi nai akoli nu Yesu ai amulekile nu kumanka. ");
INSERT INTO isn_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Muhumba ung'wi ai umutyatile, hangi ai watulaa utugae u mugolole udu ai watulaa wikumbile kitaligiilya; ai amuambile kuiti ");
INSERT INTO isn_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ai uatigie akauleka u mugolole papo akamanka kipwi. ");
INSERT INTO isn_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nai akamutongeela uYesu kung'wa kuhani nu mukulu. Pang'wanso ai ilundiie palung'wi nu ng'wenso i akuhani ni akulu ihi, anyampala, ni amanyi. ");
INSERT INTO isn_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","uPeto nu ng'wenso ai umutyatile uYesu ku kuli, kutunga mi itando nilang'wa kuhani nu mukulu. Ai wikie palung'wi ni asunja, nai atulaa pakupi nu moto akaze ota iti kulija upyu. ");
INSERT INTO isn_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Matungo nanso akuhani niakulu ihi ni ianza lihi ai atulaa akuduma ukuiili kung'wa Yesu iti alije kumubulaga. Kuiti shanga ikaulija. ");
INSERT INTO isn_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ku nsoko antu idu ai aletile ukuiili nua uteele ku ngwaakwe, kuiti ga nu ukuiili nuao shanga ukimpyana ");
INSERT INTO isn_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ang'wi ao ai imikile nu kuleta ukuiili nua uteele ku ng'waakwe; azeligitya, ");
INSERT INTO isn_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Aza kigulye ukuligitya, 'Nikalibipya itekeelo ili nai lizipigwe ku mikono, nu mukati a mahiku a taatu nikikalizenga ingiiza ni shanga lizipigwe ku mikono.” ");
INSERT INTO isn_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kuiti ga nu ukuiili nuao shanga ukimpyana. ");
INSERT INTO isn_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kuhani nu mukulu ai wimikile pakati ao nu kumukolya uYesu, “Itii umugila isosho? Antu awa akukuiila ntuni kitalako?” ");
INSERT INTO isn_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kuiti ai wikie ihi twii hangi shanga ai usukiiye kihi. Itungo u kuhani nu mukulu ai umukoiye hangi, “Itii u ewe ingi wi Kristo, ng'wana wang'wa Mukendepwa?” ");
INSERT INTO isn_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","uYesu ai uligitilye, “Unene ng'wenso. Hangi wikumihenga uNg'wana wang'wa Adamu wikie mukono nua kigoha nua ngulu upembilye ni malunde a kilunde.” ");
INSERT INTO isn_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","uKuhani nu mukulu ai utamue i ang'wenda akwe nu kuligitya, “Itii, kukili kuloilwe akuiili? ");
INSERT INTO isn_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Migulye i kimeli. Ulamuli nuanyu nu uli?” Hangi ihi ai amulamue anga ung'wi nai utakiwe insha. ");
INSERT INTO isn_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ang'wi akandya kumutyila i mati nu kumukunikila u usu nu kumukua nu kumutambuila, “Lota!” A ofisa ai amuhoile nu kumukua. ");
INSERT INTO isn_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Hangi uPetro nai wakatula wakili ukoli pihi mitando, munyamulimo ung'wi nua kisungu nuang'wa kuhani nu mukulu akapembya kitalakwe. ");
INSERT INTO isn_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ai umihengile uPetro nai wimikile ukota u moto, hangi ai umugozile ku kumuhumbeela. Uugwa ai uligitilye, “Nu ewe ga aza ukoli nu Munazareti, uYesu.” ");
INSERT INTO isn_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kuiti ai uhitile, wazeligitya, “Shanga ningile hangi shanga manyile kutula iko nukuligitya!” Uugwa ai upumile akalongola kunzi itando. (Komaniilya; U lukiili ulu, “Hangi i nsambaligugu ikakunkula” umutili mu mbugulu nia akali). ");
INSERT INTO isn_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kuiti munyamulimo nua kisungu pang'wanso, ai umihengile nu kandya kuatambuila hangi awo naza akoli imikile pang'wanso, “uMuntu uyu ingi ung'wi ao!” ");
INSERT INTO isn_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kuiti ai uhitile hangi. Panyambele iniino awo nai atulaa imikile pang'wanso ai atulaa akumumbuila uPetro, “Kulu kuulu u ewe ingi wi ung'wi ao, ku ndogoelyo ga nu ewe ingi wi Mugalilaya.” ");
INSERT INTO isn_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Kuiti ai wandilye ki ika u mukola pihi a kizumo nu kulapa, “Shanga numulingile u muntu uyu ni muku mutambula.” ");
INSERT INTO isn_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Uugwa i nsambaligugu ikakunkula kabiili. Uugwa uPetro ai ukimbukiiye i makani naiza uYesu ai watulaa umutambuie; “Ze ikili i nsambaligugu ku kunkula nkua ibiili, ukunihita nkua itaatu.” Hangi ai ugwie pihi nu kulila. ");
INSERT INTO isn_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kidau dau maniambwa akulu a akuhani ai atankanila palung'wi ni anyampala ni amanyi ni ianza lihi nila anyampala. Uugwa akamutunga uYesu akamutwala kung'wa Pilato. uPilato akamukolya, “U ewe ingi wi mutemi nua Ayahudi?” ");
INSERT INTO isn_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Akasukiilya, “U ewe ukuligitya nianso.” ");
INSERT INTO isn_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Akulu a akuhani akaganula u usemelwa widu migulya ang'wa Yesu. ");
INSERT INTO isn_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","uPilato akamukolya hangi, “Shanga ukusukiilya kihi? Shanga wihengile iti niaku usemela ku makani idu? ");
INSERT INTO isn_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kuiti uYesu shanga ai umusukiiye uPilato, hangi nianso ai imukuie. ");
INSERT INTO isn_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ku u udu itungo nila siku kuu wimutunguila mutugwa ung'wi, mutungwa niize amulompile. ");
INSERT INTO isn_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ai amoli atumuli mu kadulumu, mukati ao i abulagi mu kati a nai apilukile ni akutumikila u utumuli nuao. Ai ukoli muntu ung'wi nuitangwa Baraba. ");
INSERT INTO isn_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Iumbi ai lipembilye kung'wa Pilato, nu kumulompa witume anga nai witumile uko kunyuma. ");
INSERT INTO isn_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","uPilatto aka asukiilya nu kuligitya, “Muloilwe numutunguilye u mutemi nua Ayahudi?” ");
INSERT INTO isn_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ku nsoko ai ulingile ingi ku nsoko a wilu akulu a akuhani ai amuambile uYesu nu kumuleta kitalakwe. ");
INSERT INTO isn_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kuiti akulu a akuhani ai akinyiie i umbi ku kua i yogo ku luli kina watunguilwe u Baraba badala akwe ");
INSERT INTO isn_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","uPilato aka asukiilya hangi nu kuligitya, “Numutende ntuni u mutemi nua Ayahudi? ");
INSERT INTO isn_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Akakua iyogo hangi, “Maje!” ");
INSERT INTO isn_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","uPilato akaligitya, “Witumile ikani kii ni bibi?” Kuiti akakilinkiilya kukua iyogo ikilo ni ikilo “Maje.' ");
INSERT INTO isn_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","uPilato waze uloilwe kuliloeelyai umbi, aka atunguilya uBaraba. Akamukua uYesu i mikoha uugwa akamupumya iti wagigwe. ");
INSERT INTO isn_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ia Asikali ai amutongile uYesu kupikiila mukati itando (ilo nilikoli mukati a nkambi) hangi ai ilingiile palung'wi idale nila asikali. ");
INSERT INTO isn_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Akamutugala uYesu mujulungu nua ung'ole nua zambalau, hangi akapotya i ngala amija akamutugala. ");
INSERT INTO isn_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Akandya kumukunka nu kuligitya, 'Milamu, Mutemi nua Ayahudi!” ");
INSERT INTO isn_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Akamukua mi itwe ku mulanga nu kumutyila i mati. Akatugama ntongeela akwe ku kumukulya. ");
INSERT INTO isn_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nai akondya ga nu kumukunka, akamutugula u mujulungu nua ung'ole nua zambarau nu kumutugala i ang'wenda akwe, hangi akamupumya kunzi kulongola ku maja. ");
INSERT INTO isn_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Akamusinja mukila nzila kumuaiilya, nai watulaa ukingila mu kisali kupuma ku mugunda. Nuitangwaa Simioni Mukirene ( tata nuakwe u Iskanda nu Rufo); Akamusinja kukenka ikota nila mpaga nilang'wa Yesu ");
INSERT INTO isn_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ia Askali akamutwala uYesu kianza ni kitangwaa Golgotha (ndogoelyo a mpyani iyi ingi Ing'ang'a litwe). ");
INSERT INTO isn_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Akaminkiilya magai na ahalinkanigwe ni manemane, kuiti shanga ai ung'wee. ");
INSERT INTO isn_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Akamaja hangi akagalana i ang'wenda akwe, akamakuila i kula kulamula i kipande nuikalija kila u asikali. ");
INSERT INTO isn_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ipikiie saa tatu kidau dau nai amagilye. ");
INSERT INTO isn_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Akaika migulya akwe ibada nilikilisigwe u usemelwa. “Mutemi ua Ayahudi.” ");
INSERT INTO isn_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Akamaja palung'wi ni a himbi abiili, ung'wi ipande nilakwe nila kigoha nu muya ki kima ku ng'waakwe. ");
INSERT INTO isn_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Komaniilya; Ulukiili ulu. “Nu ukilisigwa ukakondaniila nai uligitigwe “ umutili mu mbugulu nia kali). ");
INSERT INTO isn_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nawo nai atulaa akukila ai amutukie, aze hingisa i matwe ao nukuligitya, “Aha! u ewe nuikalibunanga i itekeelo nu kulizenga ku mahiku ataatu, ");
INSERT INTO isn_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Igune mukola hangi usime pihi puma mikota nila mpaga!” ");
INSERT INTO isn_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ku ndogoelyo yiyo yiiyo akulu a akuhani ai amusensile azitambulya, palung'wi ni amanyi nu kuligitya, “Ai uagunile i auya, kuiti shanga uhumile kiguna u mukola. ");
INSERT INTO isn_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kristo Mutemi nua Israeli, sima pihi puma mikota nila mpaga, iti kuhume kihenga nu kuhuiila.” Hangi awo nai agigwe palung'wi nu ng'wenso ga ai amusensile. ");
INSERT INTO isn_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nai ipikile i saa mutandatu, kiti kikapembya migulya ihi ihi kupikiila i saa kenda. ");
INSERT INTO isn_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Itungo nila saa kenda, uYesu akazogolya ku luli lukulu, “Eloi, Eloi, lama sabaktani?” ize ituile ni ndogoelyo, “Itunda nuane, ku niki nuandeka?” ");
INSERT INTO isn_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ang'wi a awo nai imikile nai akija akaligitya, “Goza, ukumitanga Eliya.” ");
INSERT INTO isn_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Muntu ung'wi akamanka, akizulya i siki misali nu kumiikila migulya amulanga, akaminkiilya iti wang'we. Muntu ung'wi akaligitya, “Lindiila kihenge anga ize u Eliya ukupembya kumusimya pihi.” ");
INSERT INTO isn_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Uugwa uYesu akalila ku luli lukulu nu kusha. ");
INSERT INTO isn_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ipazia ni li tekeelo likagalanuka ipande ibiili puma migulya kupikiila pihi. ");
INSERT INTO isn_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","uOfisa ung'wi nai watulaa wimikile waze umutungile uYesu, nai wakihenga wakuza ku kinya iti, akaligitya, “Tai u muntu uyu ai watulaa Ng'wana wang'wa Itunda.” ");
INSERT INTO isn_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ai akoli ga niasungu nai atulaa akugoza ku kuli. Mukati ao ai ukoli uMariamu Magdalena, Mariamu (nyinya nuakwe u Yakobo muniino wang'wa Yose), nu Salome. ");
INSERT INTO isn_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Matungo nai akoli ku Galilaya ai amutyatile nu kumuaiilya. Ga ni asungu angiiza idu ai ityatinkanilye kupikiila ku Yerusalemu. ");
INSERT INTO isn_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nai yatula mpindi, hangi kunsoko ai ituile luhiku nula wihambi, luhiku ze ikili u luhiku nula kusupya. ");
INSERT INTO isn_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","uYusufu nua ku Arimathaya ai uzile pang'wanso. Ai watulaa munyianza nai ukuigwe muntu nu ulindiie u utemi nuang'wa Itunda. Ku ukamatiku akalongola kung'wa Pilato, nu kumulompa u muili nuang'wa Yesu. ");
INSERT INTO isn_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","uPilato akakuilwa kina uYesu yakondaa wakuza; akamitanga u afisa uyo akamukolya anga ize uYesu wakuza. ");
INSERT INTO isn_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nai wakalija i kulu kuulu kung'wa Afia kina wakuza, ai umugombilye uYusufu ku uhola u muili. ");
INSERT INTO isn_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","uYusufu ai watulaa wagula i sanda. Akamusimya puma mikota nila mpaga, akamutunga ku sanda, nu kumuika mukati a kibiila nai kihimbilwe mi italagwe. Uugwa akalipingiltya igwe mu mulango nua kibiila. ");
INSERT INTO isn_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","uMariamu Magdalena nu Mariamu nyinya wang'wa Yose ai ihengile i kipango nai uikilwe uYesu ");
INSERT INTO isn_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Matungo u luhiku nula kusupya nai laula, uMariamu Magdalena nu Mariamu nyinya nuakwe u Yakobo, nu Salome, ai aguile manyunkiilo maziza, iti ahume kupembya nu ku upuguhila i makuta u muili wang'wa Yesu ku nsoko a uikwi. ");
INSERT INTO isn_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kidau dau mania mbwa luhiku nula ng'wandyo nula wiki, ai alongoe mu kibiila itungo i lyoa nai litolokile. ");
INSERT INTO isn_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Azitambulya enso ku enso, “Nyenyu ukulipingilitya igwe ku nsoko itu iti kingile mu kibiila?” ");
INSERT INTO isn_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Itungo nai agozile, ai amihengile muntu wakondya kulipingilitya igwe, naiza lituile ikulu nangalu. ");
INSERT INTO isn_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Akingila mu kibiila nu kumihenga muhumba utugae mujulungu ng'welu, wikie ipande nila kigoha, hangi akakuilwa. ");
INSERT INTO isn_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Aka atambuila, “Leki kitumbi. Mukumuduma Yesu, nua ku Nazareti, naza wagigwe. Wiuka! Wimutili apa. Goza i nkika apo naza atulaa amuikile. ");
INSERT INTO isn_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Longoli, muatambuile i amanyisigwa akwe nu Petro nia kina wamutongeela kutunga ku Galilaya. Kung'wanso mukumihenga, anga nai watulaa umutambuie.” ");
INSERT INTO isn_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Akahega nu kumanka kupuma mu kibiila; ai akagatile nuku kuilwa. Shanga ai aligitilye kihi ku muntu wihi nsoko ai itumbile nangaluu. ");
INSERT INTO isn_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","(Komaniilya; Mbugulu nia kali ngila u Marko 16: 9-20) Dau ni nkulu mu luhiku nula ng'wandyo nula wiki, ze yakilaa kiuka, ai umupumie hanza uMariamu Magdalena, naiza kupuma kitalakwe ai umupumiiye a hing'wi mupungati. ");
INSERT INTO isn_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ai uhegile nu kuatambuila awo naza atulaa palung'wi nu ng'wenso, itungo nai atulaa akusiga ikulu nu kupumya u liholi. ");
INSERT INTO isn_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ai igulye kina ingi mupanga hangi wigeelekile nu ng'wenso, kuiti shanga ai amuhuiie. ");
INSERT INTO isn_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","(Komaniilya; Mbugulu nia kali ngila i Marko 16: 9-20) Ze yakilaa nanso, akipumilya ku mpyani isa ku antu angiiza abiili, itungo nai atulaa akugenda kupuma mi ihi. ");
INSERT INTO isn_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ai alongoe nu kuatambuila i amanyisigwa ni angiiza nai asagile, kuiti shanga ai a ahuiie. ");
INSERT INTO isn_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","(Komaniilya; Mbugulu nia kali ngila u Marko 16: 9-20) uYesu panyambele akipumilya ku awo ni ikumi na ung'wi nai atulaa ipantamiiye mu meza, hangi aka akenela ku kuhita kuhiiila kitalao nu ukaku nua nkolo, ku nsoko shanga ai ahuiie awo nai amihengile ze yakilaa kiuka kupuma mu ashi. ");
INSERT INTO isn_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Aka atambuila, “Longoli mu unkumbigulu wihi, nu kutanantya inkani ninza ku intu yihi. ");
INSERT INTO isn_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Wihi nu uhuiie nu kogigwa ukugunwa, nu uyo ni shanga u huiie ukulamulwa. ");
INSERT INTO isn_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","(Komaniilya; Mbugulu nia kali ngila Marko 16: 9-20) “Ilingasiilyo izi ikityata ni ihi niahuiie. Ku lina nilane akupumya i ahing'wi. Akuligita ku ntambu ngeni. ");
INSERT INTO isn_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Akuamba i nzoka ku mikono ao, hangi ga nu kung'wa kintu kihi nika kubulaga shanga kikualemaalya. Akuika i mikono ku alwae, nienso akutula apanga.” ");
INSERT INTO isn_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ze yakilaa u Mukulu kuligita nienso, akaholwa migulya milunde hangi wikie mukono nua kigoha nuang'wa Itunda. ");
INSERT INTO isn_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Amanyisigwa akahega nu kutanantya kila kianza, itungo uMukulu ukituma u mulimo nienso nu ku lukaminkiilya u lukani ku miukuilwa ni ilingasiilyo ize yityatinkanilye ni enso ");
INSERT INTO isn_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Idu naakagupile kuika uza imahumo ayo naakondigwe kung'witu, ");
INSERT INTO isn_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","anga naakupee usese kupuma ung'wandyo naaihengile kumiho nitumi alukani. ");
INSERT INTO isn_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kululo unene nanakomanilya ung'wandyo wa nkani izi yihi kupuma ung'wandyo naona uza kitalane hangi kuandikila unoneligwa wakwe mkuligwa wakwe Theofilo. ");
INSERT INTO isn_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Kina uhume kumanya itai ankani naumanyisigwe. ");
INSERT INTO isn_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mumahiku ang'wa Herode, mtemi wa Yuda, aukole umdimi naiwitangwa Zakaria, nuaukoo wang'wa Abia musungu akwe akapuma kuwa nanso ang'wa Haruni, nilina lakwe aiwitangwa Elizabethi. ");
INSERT INTO isn_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ihi akete itai pantongeela ang'wi Tunda, aakugenda aziagili anga ubi mumalagilyo ihi na mukulu. ");
INSERT INTO isn_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Aagila anga ng'wana kunsoko u Elizabeti aimugumba, aya ihi abili aina anyampala. ");
INSERT INTO isn_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ikatula na ukituma imilimo akidimi akaziunonelya kuntongeela ang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kutyata uigobi naizaigombilye kumupata umudimi nua kenda kunyuunkilya uvumba kunyumba ang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ilundo lili nilaantu ailikoli kunzi likazilompa imatungo nuvumba nukutunkiilya. ");
INSERT INTO isn_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Malaika wa mukulu aupumie akimika mukono wa kigoha wa kikumbikilo la kunyunkilya. ");
INSERT INTO isn_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","U Zakaria wikatinuka nuika muona; uoa wika mugwila. ");
INSERT INTO isn_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ingigwa umalaika akamuila, “Leka kogopa Zakaria, kunsoko imalompi ako igigwa u musungu u Elizabethi ukuutugila ung'wana ilina lakwe ukumitanga Yohana. ");
INSERT INTO isn_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ukula nuulowa na idu niakuulowa kutu gwa kung'wakwe. ");
INSERT INTO isn_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kunsoko ukutula mukulu mumiho amukulu. Sanga ukung'wa idivai anwi ikigalyo nikilulu, ukutula uiizuligwa ng'wa ung'welu kupuma munda ang'wa nyinya. ");
INSERT INTO isn_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Niantu idu nia Israeli akupiulwa kung'witunda wao. ");
INSERT INTO isn_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Winzu pantongeela amukulu kunkolo ang'wa aung'welu ningulu yang'wa Eliya. Ukituma iti kunsoko akususha ikolo yaana ingigwa awa nishaigomba ilongola kuwa hugu niatai. Ukituma iti kuaika antu ihambe kumukulu kinoneelya kunsoko akwe. ");
INSERT INTO isn_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","U Zakaria akamuila umalaika, kuhuma uli kuhuma ili? Kunsoko unene nimunyampala numusungu wane imyaka akwila. ");
INSERT INTO isn_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Umalaika akasusha akamwila unene ni Gabrieli, numika pantongeela ang'wi Tunda. Ntumilwe kuila, ulukani nuluza. ");
INSERT INTO isn_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Hangi goza, shukuligitya, ukukilaja, shukuhuma kuligitya sunga uluhiku ulo inkani izi ni ziza kupumila iyi kunsoko aulemilwe kuhuili nkani yane niziza yakondaniligwa kumatungo ane. ");
INSERT INTO isn_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Iantu aamulindie u Zakaria. Ikakuilwa nautinilye mitekeelo. ");
INSERT INTO isn_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Naiwapuma kunzi singa akahuma kuligitya nung'wenso. Ikalinga kina awa apa akakunukuilwa naukole mitekeelo. Akalongoleka kulagiila iilinga silyo hangi aka kilaja twi. ");
INSERT INTO isn_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Imahiku amilimo naahila akasuka kitalakwe. ");
INSERT INTO isn_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Matungo u Zakaria naiwakondya kituma imilimo akwe mitekeelo, umusungu akaamba ulito nuanso singa akapuma mitalakwe nimatungo amyeli itaano, akalunga. ");
INSERT INTO isn_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ulu lulu naiwitumile umukulu kitalane kwa uuza kuheja iminyala kuntongeela aantu.” ");
INSERT INTO isn_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabethi naiwapisha inda amyeli mutandatu, Itunda akamuila umalaika Gabrieli longola kukisali nikitangwa Galilaya ni Nazareti, ");
INSERT INTO isn_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","munanso nauligigwe numuhumba ilina lakwe naiwitangwa Yusufu nuanso amuluna wang'wa Daudi, umunanso nuanso aiwitangwa Mariamu. ");
INSERT INTO isn_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Akaza kitalakwe akalunga 'Nusigilye uhumi Nukulu Nitunda uloeeigwe.” ");
INSERT INTO isn_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Kululo inkani u malaika auhalinkanilye akahita kulinga kuniki umalaika atambule imakuilwa akwe. ");
INSERT INTO isn_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Umalaika akamwila, “Leka kogopa, Mariamu, kunsoko uupatile uhumi kupuma kung'witunda. ");
INSERT INTO isn_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Goza gwa, ukukenka inda ukutuga ungwana. Ukumitanga Yesu.' ");
INSERT INTO isn_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ukutula ngwana nua Mkulu migulya Itunda ukumupa ituntu lanywa Daudi utata akwe. ");
INSERT INTO isn_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ukutula mutemi numukulu mukoo wang'wa Yakobo mpaka impelo utemi wakwe ugilangampelo. ");
INSERT INTO isn_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariamu akamwila ikutuika uli, iza nkili kihugeela numitunja wihi? ");
INSERT INTO isn_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malaika akamwila akalunga, “Ng'wang'welu ukuuhanga migulya ningulu yako uyu nukutugwa ukitangwa ng'wang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Goza, umuluna wang'wa Elizabethi ukete nda ang'wana nunyampala wakwe ukete mieli mtandatu, naiwilwa mugumba. ");
INSERT INTO isn_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kunsoko kutili nilihumile kung'wiTunda.” ");
INSERT INTO isn_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mariamu akalunga, “Goza, une nimukulu numusungu wang'wi Tunda. Leka itule uu kitalane iza nulukani lako.” Umalaika akamleka. ");
INSERT INTO isn_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kululo imahiku yayo u Mariamu akahega akenda mihe na malugulu, mihe na mukisali nitangwa Yudea. ");
INSERT INTO isn_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Akalongola munyumba ang'wa Zakaria akamulamusha u Elizabethi. ");
INSERT INTO isn_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Itungili aipumie kuiti u Elizabethi naiwigule imilamu ang'wa Mariamu ung'wana munda akwe akaputa nu Elizabethi akizula ingulu yang'wawelu. ");
INSERT INTO isn_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Akitunta kululi nulukulu akalunga akaligitilya akitunta kululi nulukulu akalunga ue kukiila muasungu nu ng'wana nukoli muda ako ukembetilwe. ");
INSERT INTO isn_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ingi gwa atuile uli kitalane uiya wang'wa tata ane aze kitalane? ");
INSERT INTO isn_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kunsoko goza naiwigule muakutue ako ululi imilamu ako ung'wana munda ane auputile kilumbi. ");
INSERT INTO isn_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nu ng'wenso ukia nai uhuiie; kundogoelyo akukondeeligwa nai utambuiwe nu Mukulu. ");
INSERT INTO isn_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","U Mariamu akaligitya, nkolo ane ikumulumbiilya u Mukulu, ");
INSERT INTO isn_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","nu ng'wau nuane imiloeeye Itunda, Muguni nuane. ");
INSERT INTO isn_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kunsoko uugozile u unyeku nua mutugwa nuakwe. Kundogoelyo, goza, pumiila itungili ulelwa wihi akunintanga mukendepwa. ");
INSERT INTO isn_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kunsoko munyangulu wantendeela makulu, ni lina nilakwe inge inyelu. ");
INSERT INTO isn_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nu ukende nuakwe wikiee ulelwa ga nu ulelwa ku awo ni umukulyaa. ");
INSERT INTO isn_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Uzipilye ngulu ku mukono nuakwe; uasapatiiye niakete ulugoha mu masigo a nkolo ni ao. ");
INSERT INTO isn_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Uagwisilye i akulu mu matuntu ao na ukulu ni anyeku uanankiiye. ");
INSERT INTO isn_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Anya nzala uikutilye ukende, ni anya nsao uahegilye mikono mitili. ");
INSERT INTO isn_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Umiiaiiye u Israeli munyamulimo nuakwe, iti wikimbukiilye u ukende nuakwe ");
INSERT INTO isn_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","(anga nai uatambuie i atata itu) u Abrahamu nu ulelwa nuakwa ga ikali na kali.” ");
INSERT INTO isn_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariamu akikie nu Elizabeti mieli itaatu uu gwa ikatulika akasuka kito. ");
INSERT INTO isn_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Matungo nai apika u Elizabeti akitunguila ng'wana mgoha. ");
INSERT INTO isn_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ianya kisali akwe nialuna akwe naigule umukulu uza. ");
INSERT INTO isn_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Naiapikile mahiku munana aiazila kumtala kukidamu umung'enya akamitanga lina lakwe Zakaria kushatilya ilina lang'wi he. ");
INSERT INTO isn_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ingigwa unyinya akwe akasusha akalunga aa ukitangwa Yohana. ");
INSERT INTO isn_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kamuila kutile hata nung'wi kua luna ako nuitangwa ilina nilanso. ");
INSERT INTO isn_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Akatula kilinga silyo ihe itangwe nyinyu. ");
INSERT INTO isn_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ihe akalowa ahole ikibao andike “Ilina lakwe Yohana.” Ihi ika ambwa ikuilywa kua ili. ");
INSERT INTO isn_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Itungo umulomo wakwe ukaluguka nulimi lakwe likaligitya nukumukulya Itunda. ");
INSERT INTO isn_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Uoa ukaizila wihi naiakolipakupi nung'wenso. Makani ikasambaila mihi ihi mulugulu mung'wa Yudea ayo. ");
INSERT INTO isn_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ihi ayo naigule ikamaika munkolo yao akalunga ung'wana uyu wiuli? Kunsoko umukano wang'wa tata ukoli palung'wi nung'wenso. ");
INSERT INTO isn_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ihe akwe u Zakaria ung'wang'welu munya kidagu akalunga, ");
INSERT INTO isn_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Akuligwe Itunda mukulu wa Israeli, kunsoko auiye kuleta uguniki kuantu akwe. ");
INSERT INTO isn_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Wakimikiye lupembe nu uhuili wa nyumba nai mitumi akwe u Daudi, ");
INSERT INTO isn_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Anga na ulungile mulomo wakinya kidagu naiakoli matungo ao na kale. ");
INSERT INTO isn_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ukakuguna muabi itu kupuma mumikono akwe nia kubipiwe. ");
INSERT INTO isn_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ukende uu kulagilya uza wang'wa tata itu, kilingasilyo lakwe ni za, ");
INSERT INTO isn_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ilago nautambue kung'wa Abrahamu tata witu. ");
INSERT INTO isn_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Uine kigeleka uhumile kutuma bila woa, kekahuma kugunwa kupuma muabi itu. ");
INSERT INTO isn_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kuite uza nitai kuntongela itu imahiku ihi. ");
INSERT INTO isn_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Uu nu ewe munya kidagu nukole migulya kunsoko ukulongoleka kunsoko amukulu kumunonelya inzila kuwanonelya iantu kunsoko aupembelyo wakwe. ");
INSERT INTO isn_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kualingasa iantu akwe kugunwa imilandu ao. ");
INSERT INTO isn_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ulu lutuile kinyauwai wang'wi Itunda witu kunsoko ilyoa lukupuma hange. ");
INSERT INTO isn_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kelya kuantu nikie mkiti nao niikie mumulule wa nsha ukituma iti kumitongeela imigulu itu munzila aupolo. ");
INSERT INTO isn_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ung'wana uyo akatula ningulu mkolo nukikie mumbuga sunga mihaea akingila kitalakwe kung'wa Israeli ");
INSERT INTO isn_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Matungo na mahiku nanso ukaisari Agusto au pumilye Ilago akaila holi ua ligwa waantu Ihi ni Ikie mihiyi. ");
INSERT INTO isn_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ili aialyo lagwandiyo alitumilye matungo krenio amukulu wang'wa siria. ");
INSERT INTO isn_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kila muntu akalongola kukisali kao. Kenda kuhola ialo. ");
INSERT INTO isn_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nung'wenso uyusufu akahega mukisali ka Nazareti ku Galilay nu kulongola ku Yudea mukisali ka Bethlehemu. nu manyikile anga kisali kang'wa Daudi. kunsoko au pumie muileli wang'wa Daudi. ");
INSERT INTO isn_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Au ulongae kung'wanso kenda kuhola ialo palung'wi nu Mariamu amuligilye nukumulindilya ung'wana. ");
INSERT INTO isn_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Naiakole kung'wanso imatungo nanso aialindie ung'wana alelywe. ");
INSERT INTO isn_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Akaleta ng'wana mugoha. Uleli wakwe wang'wandyo akamuimba inguo muili wihi kugilya impepo ung'wana. Akamuika muntua nakuliselya imitugo kunsoko aikutile ilyoma munyumba ya kila nzila. ");
INSERT INTO isn_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ihi ni anso aiakole iadimi naikie mumbuga akazelindila ikolo yao utiku. ");
INSERT INTO isn_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Itungo malaika wa mukulu akapumila utemi wa mukulu ukelya nukupilimilya akatula nu oa. ");
INSERT INTO isn_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kululo umalaika akaaila, ''leki kogopi numuletee lukani luza, nulukuleta ilumbi ku antu ihi. ");
INSERT INTO isn_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Iie liyi, muguni uleilwe kunsoko anyu, mukisale kang'wa Daudi nuanso yuyo kristo mkulu! ");
INSERT INTO isn_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ike inge kilingasilyo mkupegwa, mukumu hanga ung'wana utungilye nguo uloe muntua akulisilya imetungo. ");
INSERT INTO isn_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Itungo itumi akilunde ikaza idu ikatula palung'wi ikamusongelya Itunda, Ikalunga. ");
INSERT INTO isn_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Ukulu wang'wi itunda mua migulya nu upolowa mihi nualoilye. ");
INSERT INTO isn_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kuite inge ia malaika ai atuile kulongola kenda kilunde, iadimi akitambuile enso kua enso, Inge kweni ku Bethelehemu, kende kuone iku nikigee nu mukulu ukulagie. ");
INSERT INTO isn_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Akakaya kung'wanso, akamuhanga mariamu nu Yusufu, ikamuona ug'wana ulae muntua nikilyesilya imetugo. ");
INSERT INTO isn_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Na iane uu akaaila iantu naiaiwe aya na ng'wana. ");
INSERT INTO isn_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ihi naigule alukani ulu ikakuilwa iko na ikitambuwe nu mudimi. ");
INSERT INTO isn_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Inge u mariamu akalongoleka, kusega kunsoko ihi nae wigule, akamaika munkola akwe. ");
INSERT INTO isn_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","I a dime ikasuka ikamukulya nukumulumbelya Itunda kitu naeigule nukuona, anga nae itambuwe, kung'wanso. ");
INSERT INTO isn_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Naelipikile ulu hiku la munana ikatula matungo, akumutala kukedamu ung'wana, ikamitanga elina lakwe Yesu, elina naupewe nu malaika Inda naikilengila munda. ");
INSERT INTO isn_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Naelipikile imahiku akuzepilingwa kitalao anga nai uzepeigwe malagelyo ang'wa musa, Yusuma na Mariamu akamutala mitekelo ku yerusalemu kumuika kuntongela ing'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Anga naeiandekilye mumalago ang'wi Tunda, kila mugoha nulugue Inda ukitangwa naupumigwe wakfu wang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ne anso aiazile kupumwa isongelyo anga naelitambuwe milago la ng'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Goza aukoli muntu ku yerusalemu zilina lakwe aukitangwa Simeoni. Umuntu nuanso aewatai nukumukulya Itunda. nuanso aizulindie muaili wa Israeli, nu ng'wang'welu aiukole migulya lakwe. ");
INSERT INTO isn_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Aituile kuhila kukiela kung'wa ng'welu kuiti nuanso sanga auzesha iza kuli kumuona U - kristo wang'wi itunda. ");
INSERT INTO isn_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Luhuki lung'wi auzile mukate mitekeelo akazutongewe nung'wang'welu, Ateli ai amuletile ung'wana, yesu, kumtendela anga ilago. ");
INSERT INTO isn_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeoni akamsingilya mumikono akwe, kumukulya Itunda akalunga. ");
INSERT INTO isn_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Mulekele umitumi wako alongote kuhuili wa mukulu, kutula nulukani lako. ");
INSERT INTO isn_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kunsoko imiho ane auona uza wako. ");
INSERT INTO isn_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nuingee kumiho aantu ihi. ");
INSERT INTO isn_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nuanso ng'welu kunsoko akukunukulya ukumbigulu nu ukulu wa antu Israeli. ");
INSERT INTO isn_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ihe nu nyinga nia ng'wana ai akuiwe Inkani nai itambuwe kunsoko akwe. ");
INSERT INTO isn_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Smeoni akasongelya akalunga Mariamu, akwe ntegeelye kisa ung'wana uyu ite ukutula kunsoko kulimila kuguna iantu Idu ku Israeli inge kulingasilyo ku antu idu nia kuhita. ");
INSERT INTO isn_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ingi upanga ukusonsa ikolo ako ue, maswgo amukolo igelekee! ");
INSERT INTO isn_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Munyakidagu musungu nai witangwa Ana hangi au koli mitekelo, nuanso ai munanso wang'wa Fanueli kupuma ulelwa wa ng'wa asheli, Aukite mahiku idu, nung'wenso ai ikie nu mugoha myaka mapungate nai ihoile. ");
INSERT INTO isn_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Akatula muhimbe kumanyaka munana na unne Nuanso shanga aiwihega mitekelo akendelea kumukulya Itunda palung'wi nukupunga nukulopa, utiko nu mung'wi. ");
INSERT INTO isn_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Matungo nanso akaza pang'wanso na iakoli akamusongelya Itunda akaligitya kunsoko ang'wa na kumuntu na mulindie ku Yerusalemu. ");
INSERT INTO isn_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Naiamalile kila ekintu naealoilye kituma ilango la mukulu ikasuka ku Galilaya, kukesali, kao, Nazareti. ");
INSERT INTO isn_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ung'wana akakula akatula ukete inguru akaongeleka mulikalo, Uza wang'witunda ukatula mingulya. ");
INSERT INTO isn_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ialeli akwe kila ung'waka enda ku Yerusalemu kunsoko amilundo wa Pasaka. ");
INSERT INTO isn_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nautuele myaka ikumi na ibili akalongoka hange naeipipile miko kunsoko amilundo. ");
INSERT INTO isn_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Naisigile matungo ehi kunsoko amilundo ikanza kusuka kito. Inge Umuhumba u-Yesu auasiga kunyuma mumo mu-Yerusalemu ialeli akwe shanga ikalinga ili. ");
INSERT INTO isn_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Aialiye ukoi palung'wi neinso naiakugenda aiagendile luhiku. Kululo akanza kumuduma Mwanya ndugu ao. ");
INSERT INTO isn_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Naialemilye kumulija akasuka ku-Yerusalemu ikatula kumuduma kuko. ");
INSERT INTO isn_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ikatula mahiku atatu ikamuhanga mutekelo akazimikie pakate pamanyisigwa akizu ategeye nuku akolya inkani. ");
INSERT INTO isn_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ihi naiamigule akakuilwa umanyi wakwe nu usukeli. ");
INSERT INTO isn_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nai amuine Ikakuilwa unyinya akamuila ng'waane, neke nukutenda nanso? Utata ako nu nene aikekuduma kuoa nuukulu. ");
INSERT INTO isn_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kunene, ''naimukunduma? sanga aimulingile kina kutula koli munyumba ang'wa tata ane? ");
INSERT INTO isn_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Singa alinga azu kuligitya nkanike izi. ");
INSERT INTO isn_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Sunga akalongala palung'wi ku nazareti kitalao hangi au gombile kitalao, Unyinya auikile inkani yihi munkolo akwe. ");
INSERT INTO isn_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Sunga u Yesu akalongeleka kukula kimahala ni kimwili, niantu ang'wi Tunda ikamulowa. ");
INSERT INTO isn_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Itungli myaka Ikumi na utano utemi wanywa kaikani Tiberia, Matungo Pontio Pilato mudimi wang'wa Uyahudi, Herode ayi mukulu wa kisali Galilaya, Filipo muluna akwe amukulu wakisali kang'wa Iturea nutrakoniti, nu Lisania amukulu wakisali kang'wa Abilene, ");
INSERT INTO isn_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Matungo umudimi mukulu wa Anasi nukayafa, Lukani Langwi Itunda alumuzie Yohana wana ang'wa Zakaria mumbuga. ");
INSERT INTO isn_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Aulongoe muhinzo mkisali kihii nikipilimiye umongo wa mazi nu ang'wa Yordani, akizitanatia itai naubadisigwa nanukuheja imilandu. ");
INSERT INTO isn_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Anga naiandikilwe mukitabu kankani yang'wa Isaya naauotile, ululi la muntu nakulila, nyika noneeli mukondien Inzura amukulu na munonelye Inzula akwe igoloke. ");
INSERT INTO isn_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Makombo ihi akizulig'wa malugulu niana malugulu ihi akunoneligwa ninzula niyikunyile ikikogoolwa ninzila Yihi nimbi yikuzipigwa. ");
INSERT INTO isn_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Antu ihi akuona uguni wang'wi Itunda. ");
INSERT INTO isn_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kululo u Yohana akauila umilundo nukulunu antu au muhangile abatisigwe nugwenso uye wileli wanzoka nua uhungu nubii nyinyu na muhuguye kuumanka ubii nauzile. ");
INSERT INTO isn_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Leli Indiya niyipyani nitai namuleke kulunga mkati anyu kukete u Ibarahimu ingi tata witu kunsoko nimuila kuiti Itunda ukete uhumi kumuhumbula Ibalihimu ng'wana kupuma mumagwe aya. ");
INSERT INTO isn_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ingigwa ihengo aikwa mumili a miti kululo u muti nishawitugaa Indya ninza wite ng'wa mu moto. ");
INSERT INTO isn_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Sunga iantu niilundie akamukolya akalunga, i magwe aya utakile kutende ulii? ");
INSERT INTO isn_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Akasusha akalunga ang'wi muntu ukite nkanzu Ibili utakiwe aheje nkanzu ing'wi amupe umuya numugila nuyu nukete indya witume uu. ");
INSERT INTO isn_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Sunga iahoela mpia ikaza kubadisigwa akamuila, mumanyi kutendeuli. ");
INSERT INTO isn_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Aka aila, '' leki kuhoeli impia ni Idu kukela ni mutakile kuhoela. ");
INSERT INTO isn_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Anya nguru akamuila akalunga ause? kitumentuni? ");
INSERT INTO isn_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Matungo, Iantu aiakite Insula akumulindila U-kristo kila muntu akasiga munkolo akwe kunsoko ng'wenso Kristo. ");
INSERT INTO isn_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","U yohana akaaila ihii, ''unene kumubatiza unye kumanzi ukoli nuzile nukete uhumi kukila une, nishantakiwe kutungula uludingi la ilatu yakwe. ukumubatiza unye kung'wang'welu nu kumoto. ");
INSERT INTO isn_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ipetelo lakwe likoli kumukono akwe kupyagula ni Iza ikiuga nikakupetela Ingano nukilingila Ingano misalanka lakwe ingi gwa ukuma sansa imakamilya kumoto ni shawilimaa. ");
INSERT INTO isn_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ukeneli widu autanantilye nkani ninza kuantu. ");
INSERT INTO isn_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","U Yohana aumpatile U - Herode mukulu wa kisali akamutina U - Herode musungu wa ng'wa muluna akwe nuku mabi nidu ni mangiza u Herode nutendile. ");
INSERT INTO isn_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Matungo naitwile Herde aiwitumile uubi ukulu na ngulu, akamu tunga Yohana kukitungo. ");
INSERT INTO isn_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ingi aipumie matungo iantu ihii naiakubadilisi gwa nu Yesu nu ng'wenso aubadisigwe, Imatungo naukulompa, Ilunde likalunguka. ");
INSERT INTO isn_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ung'wa ngwelu akasima migulya akwe. anga Inyunyi, Matungo yayo yayo luli likaza kupuma milunde likalilya. Ue Ingi nu anso ng'wana wane ninumukuilye. ");
INSERT INTO isn_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","U-Yesu ung'wenso, naiwapisha Imyaka makumi ataatu. Akandilya kumanyisa akazimpaya nigwa anga ng'wana ang'wa Yusufu, anga Eli. ");
INSERT INTO isn_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ni ang'wi akalunga ng'wana wa ng'wa Mathati, ng'wana wang'wa Lawi, ng'wana wang'wa Melki, ng'wana wa ng'wa Yona, ng'wana wang'wa Yusufu. ");
INSERT INTO isn_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ng'ana wa Matathia, ng'wana wa ng'wa Amosi ng'wana wa ng'wa Nahumu, ng'wana wa ng'wa Esli, ng'wana wa ng'wa Nagai. ");
INSERT INTO isn_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ng'wana wang'wa Maati, ng'wana wang'wa Matathia, ng'wana wang'wa Semein, ng'wana wang'wa Yusufu, ng'wana wang'wa Yuda. ");
INSERT INTO isn_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ng'wana wang'wa Yoanani, ng'wana wang'wa Resa, ng'wana wang'wa Zerubabeli, ng'wana wang'wa Shealtieli, ng'wana wang'wa Neri, ");
INSERT INTO isn_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ng'wana wang'wa Melki, ng'wana wang'wa Adi, ng'wana wang'wa Kosamu, ng'wana wang'wa Elmadamu, ng'wana wang'wa Eri, ");
INSERT INTO isn_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ng'wana wang'wa Yoshua, ng'wana wang'wa Eliezeri, ng'wana wang'wa Yorimu, ng'wana wang'wa Matath, ng'wana wang'wa Lawi. ");
INSERT INTO isn_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ng'wana wang'wa Simeoni, ng'wana wang'wa Yuda, ng'wana wang'wa Yusufu, ng'wana wang'wa Yonamu, ng'wana wang'wa Eliyakimu. ");
INSERT INTO isn_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ng'wana wang'wa Melea, ng'wana wang'wa Mena, ng'wana wang'wa Matatha, ng'wana wang'wa Nathani, ng'wana wang'wa Daudi. ");
INSERT INTO isn_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ng'wana wang'wa Yese, ng'wana wang'wa Obedi, ng'wana wang'wa Boazi, ng'wana wang'wa Salmoni, ng'wana wang'wa Nashoni. ");
INSERT INTO isn_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ng'wana wang'wa Abinadabu, ng'wana wang'wa Aramu, ng'wana wang'wa Hesroni, ng'wana wang'wa Peresi, ng'wana wang'wa Yuda, ");
INSERT INTO isn_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ng'wana wang'wa Yakobo, ng'wana wang'wa Isaka, ng'wana wang'wa Ibrahimu, ng'wana wang'wa Tera, ng'wana wang'wa Nahori, ");
INSERT INTO isn_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ng'wana wang'wa Seruig, ng'wana wang'wa Ragau, ng'wana wang'wa Pelegi, ng'wana wang'wa Eberi, ng'wana wang'wa Sala, ");
INSERT INTO isn_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ng'wana wang'wa Kenani, ng'wana wang'wa Arfaksadi, ng'wana wang'wa Shemu, ng'wana wang'wa Nuhu, ng'wana wang'wa Lameki, ");
INSERT INTO isn_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ng'wana wang'wa Methusela, ng'wana wang'wa Henoko, ng'wana wang'wa Yaredi, ng'wana wang'wa Mahalalei, ng'wana wang'wa Kenani, ");
INSERT INTO isn_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ng'wana wang'wa Enashi, ng'wana wang'wa Sethi, ng'wana wang'wa Adamu, ng'wana wang'wa Tunda. ");
INSERT INTO isn_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Sunga u - Yesu akaza wizue ung'wang'welu, akasuka kupuma kumongo wang'wa Jordani, hangi akatongelwa nu ng'wang'welu mumbuga. ");
INSERT INTO isn_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kwa mahiku makumi ane nukung'wanso akapata, mageng, wa nu mulungu, imatungo nanso shanga akalya anga kintu kilii, nempelo amatungo nanso. ");
INSERT INTO isn_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Umulugu akalunga ang'we tai wing'wana wang'wi Itunda liilie igwe litule ludya. ");
INSERT INTO isn_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","U - Yesu akasukilya iandikile umuntu shanga ukikie kundya duu. ");
INSERT INTO isn_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Hangi umulugu akamutongela mingulya kunsonge a lugulu, akamulagila utemi wi hii nwa munku migulu kumatungo ni makupii. ");
INSERT INTO isn_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Umulugu akamuila kuupa ukulu wa utemi wihii nuu kote kituma uu kunsoko iikilwe kitalane nikete wihi nutakile kumpa. ");
INSERT INTO isn_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ang'wi ukutungama, nukunkulya imaintu aya akutula ako ihi. ");
INSERT INTO isn_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ingi u Yesu akasusha nukumuila, iandekilye, umukulye Itunda wako, nukumutumikila ung'wenso duu. ");
INSERT INTO isn_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Itungo umulugu akamutongela u-Yesu mpaka kuYerusalemu, nukumuika migulya mitekelo, akamuila ang'wi wing'wana wa ng'wi tunda wigume pihi kupuma pang'wanso. ");
INSERT INTO isn_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kunsoko iandikilwe, ukualangilya i a malaika akwe nukuusunga. ");
INSERT INTO isn_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Hakuhumbula miglya mumikono ao kunsoko uleke kiaalya imigulu migwe. ");
INSERT INTO isn_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","U-Yesu akasusha akamuila, itambuwe leka kumugema Itunda ako. ");
INSERT INTO isn_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Umulugu naukondilye kumugema U-Yesu, akalongola yakwe akamuleka imatungo ni mangiza. ");
INSERT INTO isn_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ingi U-Yesu akasuka ku-galilaya kunguluu ya ng'wa ng'welu, ninkani yakwe yakendelea kusambaila muisale yihi nia pakupi. ");
INSERT INTO isn_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Aumanyisilye mumatekelo ao, ihi ikamukulya. ");
INSERT INTO isn_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Luhiku akalongola ku Nazaleti, mukisali nautungilwe nukukuila. Anga naiwilowa kingila mumatekelo luhiku la sabato, na aiwimikile nukusoma naiiandikile. ");
INSERT INTO isn_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Akapegwa ikitabu kang'wanyakindagu U-Isaya, kululo, akalungula akaduma apo niandekile. ");
INSERT INTO isn_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ung'wang'welu ukole mitalane, kunsoko aumpakoie imakuta kutanahia ulukani luza. Untumile kutanantwa ulekelwa kuwatungwa, nishaiona kuteleona hangi kuapa ulekelwa awa neonyeigwe. ");
INSERT INTO isn_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Kutanantwa ung'waka nua mukulu ukulangila uza wakwe. ");
INSERT INTO isn_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Hangi akalungaila ikitabu, akamusukilya umukulu witekelo, nukikie pihe. Miho aantu ihi ikamuguzela naiakoli pang'wanso ikamugozela ung'wenso. ");
INSERT INTO isn_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Akandya kulingitya neenso akalunga, ileliye ilangilyo lapika muakutwi ayu. ");
INSERT INTO isn_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ihii naihenile pang'wanso naikilingitigwe nu Yesu, na indu naiakoli pang'wanso ikakuilwa inkani Yauhugu nai yakupumakumulomo wakwe aikulunga, ''uhuyu ingi muhumba du wang'wa Yusufu, singa uu. ");
INSERT INTO isn_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","U-Yesu akamuila itai mukulingitwa ulu lukole kitalane, ilagute uewe kihii nikigule anga wituma Kapernaumu, Itume hangi numukisali kako. ");
INSERT INTO isn_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Hangi akalunga,''tai kumuilaa unye kutile munya kidagu nugombigwe mihi akwe. ");
INSERT INTO isn_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ingi kumuila unye tai aiakole lashilwa iduku Israel kumatungo ang'wa Eliya, matungo ni lunde nailitungilwa itule kutili anga mbula myaka itaatu ni kinda, matungo naeikoli inzala ni nkulu ihi ihi. ");
INSERT INTO isn_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ingi u - Eliya shaautumilye kumuntu wihi hangi kumushilwa ung'widu naiwikie ku sarepta pakupi ni kisali ua sidoni. ");
INSERT INTO isn_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Aiakoli anyambili ku Israel imatungo ang'wa Elisha umunyakidagu, ingi kutile ung'wi ao nauponigwa ingi u Naamani muntu wa ku siria. ");
INSERT INTO isn_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Antu ihi munyumba mitekelo aiizue nuulowa naigule nanso ihi. ");
INSERT INTO isn_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ikimika kumuhugelya kunzi mukisali, nukumugila pakupi nu lugulu la mukisali hangi kisali kao nauzengilye migulwa akwe kumuguma pihii. ");
INSERT INTO isn_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ingi aukiile uza pakati ao akalongola yakwe. ");
INSERT INTO isn_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Hangi akasimila kapernaumu mukisali kaku Galilaya sabato ung'wi aukuamanyisa iantu munyumba mitekeelo. ");
INSERT INTO isn_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Akakuilwa umanyisigwa wakwe aumanyisilye kwa uhumu wakwe. ");
INSERT INTO isn_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Uluhiku nulanso mukati musinagogi aukoli muntu naukite nkolo amitunga niaabii. ");
INSERT INTO isn_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Ukite ntuni nue u - Yesu nazareti? waaza kumala? minne ue winyanyu! uewe wing'wang'welu ang'wi Itunda. ");
INSERT INTO isn_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","U-Yesu amapatilye umintunga akalunga kilaga ihitwu nuanso umintunga nuanso akamuguma muntu nuanso pihi mukatikati ao akapuma kuuntu nuanso singa akaona anga uwai. ");
INSERT INTO isn_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Iantu ihi ikapata Ikuilwa, ikatula ligitya Inkani kila umuntu numuya Ikazilunga Izinnkanikee akahega ikolo nimbii kuhumi akag'wa. ");
INSERT INTO isn_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kululo intambu ang'wa Yesu ikapika kuli ninkani yikapiimilya mukisali nikanso. ");
INSERT INTO isn_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ingi u-Yesu akahega mukisali nikanso naaki ngila munyumba ang'wa simoni itungili ite mukwing'wa angwa Simoni ae mulwae ndwala ntaki naikamulompa kukiila kungwa kwe. ");
INSERT INTO isn_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ingi u-Yesu akamuhugela, akamupatya Indwala ikahega hapuu na akimika akatula mitamila Itunda ");
INSERT INTO isn_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Liyoa nailukuhaila, lantu aiamuletee U-Yesu kila umuntu naikite umu lua akwe hangi kila indwala akaika imikono akwe migulya amulue na akagunika. ");
INSERT INTO isn_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Iamintunga nienso ikapume iduu akazilila kulali ikazilunga ue ingi wing'wana wang'wi Itunda: U-Yesu akapatiya lamimitunga shakago mpya kuligitiu kunsoka auine nuanso Kristo. ");
INSERT INTO isn_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Matungo naiweile, aiwendile kieneo naingila iantu. Umilundo wa antu akumuduma naikaza kieneo naukoti. Ikatula mugiliya alekekenda kuli nienso. ");
INSERT INTO isn_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ingi akaila, kutula tanalwya uuza mukulu ng'wa ngwa Itunda, Kuisali ningiza kunsoko aidangiigwe Pa ng'wanso. ");
INSERT INTO isn_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Hangi akendelea kutanatia mukati musinagogi ku- Yahudi wihi. ");
INSERT INTO isn_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Aitulikile matungo iantu akizura nakumupilimilya U-Yesu nukumutegelya ulukani Langwi Itunda, nai wimikile panipelo aluzi la Genesareti. ");
INSERT INTO isn_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Auine mabine abili Imikingwe kupelo aluzi Iaibua Samaki aiapumaa aiakoja inyabu yao. ");
INSERT INTO isn_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","U-Yesu akingila mibini, nai lang'wa Simoni na akalompa atwale ibini muluzi kuli inino nihi ninyumu. hangi akikie kumumanyisa kupuma mibini. ");
INSERT INTO isn_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Akaligitia, akamuila U-Simoni litwale ibini lako muluzi uisimie inyabu yako utule bua Insamaki. ");
INSERT INTO isn_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoni akasusha nukulunga, tata kituma, aimilimo uliku wihi, Shakupatile anga kintu kihi hangi kulukani lako kuisimya inyabu. ");
INSERT INTO isn_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Naitumile uu ikahoela Insamaki iduu na lyabu yao yika tula tinike. ");
INSERT INTO isn_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ikaitanga Iabuani ao kibini Ingiza hangi aze kua ailya. Ikaza akizulia imabini ihi ikatula kilieka mukati muluzi. ");
INSERT INTO isn_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Hangi Simoni Petro nauine uu, akatugama na malu pang'wa Yesu akalunga;''Hega kitalane, kunsoko une ni muntu wamilandu tata. ");
INSERT INTO isn_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kunsoko akapata ikuilwa ihi naine kunsamaki naiatendile. ");
INSERT INTO isn_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ulu iti aliakuile uYakobo na Yohana ng'wana wang'wa Zebedayo aipulug'wi nu Simoni. Nu Yesu akamuila uSimoni kandya itungili apana kogopa kumbele ukutula bua iantu. ");
INSERT INTO isn_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Naiamaletile imabini ao mihi ni nyumu, kaleka kintu kihi ikamutyata nuanso. ");
INSERT INTO isn_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Niipumie naukali mukisali muntu naukete ibili kuko, matungo namuine U-Yesu augwie akakumana pihi nukulompa, akalunga,''tata ang'wi uloiwe umponie.'' ");
INSERT INTO isn_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Sunga U-Yesu akahumbula umukona nukumuamba, akalunga ndoilwa ukomie itungo lilo imbili iakahega. ");
INSERT INTO isn_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Akamuile alekekumuila anga muntu wihi, akamula longala wionyeshe nu utemi upumie isongiliyo. ");
INSERT INTO isn_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kulula ikani yakwe ikasambaila kui, numilundo wa antu ukaza palung'wi nukumutigelya numanyisa nukuguna imalwae ao. ");
INSERT INTO isn_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ingi hapu hapuu akikie wingene akazilompa. ");
INSERT INTO isn_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Aituile luhiku lungwi nema hiku ayo naukumanyisa, aiokoli Mafarisayo niamanyisa anonya nkai akikie hapo aizile kupuma muisali ningiza numukisali kang, wa Galilaya nanu Yudea, hangi nukupuma mukisali kang'wa Yerusalemu. Ingulu yang'wa tata akali palung'wi nung'wenso kuguna. ");
INSERT INTO isn_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","antu akehu aiazile, ainkenkile mundili umuntu nuigandi naikai ikaduma inzila akumingilya mukati amulalishe pihi kuntongela ang'wa Yesu. ");
INSERT INTO isn_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Shaikapata inzila akumingilya mukati kunsoko umilundo, ukanankila migulya milialo lanyumba ikamusunta muntu nuanso pihi kukiila mibolomya migulya mundili akwe mukati wa antu kuntongela lukulu pang'wa Yesu. ");
INSERT INTO isn_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Akazigoza uhuili wakwe, Yesu akalunga muhumba miane, imilandu ako wasamehelwa. ");
INSERT INTO isn_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Anumwa nkani ni mafalisayo ikandya kukolya nulanso, akalunga uyu nyenyu nukuligitya kuubii? Nyenyu nuhumile kusamehela imilandu ingi Itunda du nuing'wine? ");
INSERT INTO isn_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ingi u Yesu ainualinga ntuni naiakukisiga, akasukilya, nukuaila, kuniki nimukikolya mukolo yanyu? ");
INSERT INTO isn_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nikiuli nikipepele kulugilya, Imilandu ako alekwa ang'wi kulunga uka ugende? ");
INSERT INTO isn_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ingi mulinge gwa ung'wana wang'wa Adamu ukite uhumu muukumbigulu kusamehela imilandu, kuila uewe uka uhole indili ako ulongole kitalako. ");
INSERT INTO isn_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Imatungo yayo yayo akauko meleao nukuhola indili akwe naulaie. Hangi akasuka kitalakwe nukumukulya Itunda. ");
INSERT INTO isn_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ingi kila ung'wi ao akakuilwa nukumukulya Itunda. Ikizuilwa nuao, ikalunga, kuine ikani shanga nzaile liyi. ");
INSERT INTO isn_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ingi inkani nianso kupumila, u Yesu akahega kung'wanso akamuona umuhoela mpia naiwitang'wa Lawi wikie mukisali kakuhoela mpia. Akamuiila, ntwate. ");
INSERT INTO isn_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ingi u Lawi akahumbuka nukumuntwata, akaleka kila kintu kunyuma. ");
INSERT INTO isn_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ingi u Lawi akanunelya munyumbakwe isikukuu ninkulu kunsoko ang'wa Yesu. Aiakoli iahoela mpia indu kung'wanso ni antu indu naiikie pameza akizilya palung'wi nienso. ");
INSERT INTO isn_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Hangi mafalisayo aiakuanung'u nikila iamanyisigwa akizilunga, kuniki nimukulya nukung'wa niahoela mpia palung'wi ni antu niangiza niakite milandu? ");
INSERT INTO isn_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","U Yesu akasusha, iantu niakite upanga nuuza shaatakile itabibu, ingi ao nialwaeli niaamutakile ung'wi. ");
INSERT INTO isn_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Shainzile kuitanga iantu makite itai ahume kugunwa, ingi ainziitanga nia milandu ahume kugunwa. ");
INSERT INTO isn_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ikamuila, iamanyisigwa ang'wa Yohana a hapouifunga nukulompa, ni amanyisigwa ang'wa mafalisayonienso itenda uu, Ai amanyisigwa ako iliza nukung'wa. ");
INSERT INTO isn_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","U Yesu akaaila, ihumile muntu wihi kituma naiendile muwinga kumunyawinga, matungo numunyawinga, kilukoli palung'wi nienso? ");
INSERT INTO isn_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ingi imahiku aziziza imatungo umunyamwinga nuzi hegigwa kitalao, lulo luhiku lakufunga. ");
INSERT INTO isn_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ingi u Yesu akaligitya kitalao kwakilingasilyo. Hutile nukutamula inino ung'wenda kupuma mivazi nipya nukutumila kunonelya ivazi nilakali. Anga watende uu, ukutamula ung'wenda. ");
INSERT INTO isn_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Hangi kutile anga muntu nuika idivai nimpya muuriba nunkulukulu, inga angitume uu, idivai nimpya aizitamula. Ikiseme ni divai aizihunuka iriba aiyizigazika. ");
INSERT INTO isn_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ingi idivai nimpya iikwe muiliba nimpya. ");
INSERT INTO isn_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kutile umuntu hangi nukung'wa idivai na kali, shukulowa nimpya kunsoko ukulunga na kali nza. ");
INSERT INTO isn_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ingigwa aiipumie musabato u Yesu aukiile mukati mumugunda wandya nia manyisigwa akwe aiakukala masukwi ikapugula mumikono ao ikalya indya. ");
INSERT INTO isn_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ingi niang'wi mafalisayo ikalunga, “Kuniki nimukituma ikintu nishanga katai ilango singatai kituma uluhiku la sabato.” ");
INSERT INTO isn_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","U Yesu akasukilya, akalunga, shanga aimusomile ne iki nu Daudi aiwitumile naiukite inzala niitunja auya naine palung'wi. ");
INSERT INTO isn_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Aiwendile munyumba ang'wi Tunda, akahola imikate nimiza nukumilya mikehu, akamipumya imiuya kuantu naiakoli nung'wenso kumilya, ingi aiituile tai iadimu kulya.” ");
INSERT INTO isn_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ingi akalunga, Ung'wana wang'wa Adamu mukulu wa Sabato.” ");
INSERT INTO isn_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Aiipumie musabato ngiza akalongola mukati musinagogi nukuamanyisa iantu kung'wanso. Aiukole muntu umukono wakwe nuakingoha aukule igandi. ");
INSERT INTO isn_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Iaandike iamafalisayo aiamugozee kisa nukuona ang'wi ukumuguna umuntu uluhiku la Sabato, ingi ahume kuligwa igazo la kumusemela. ");
INSERT INTO isn_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Aaine tuni naiakusiga akalunga umuntu naiwigandi umukono, auke imike apa mukatikati antu ihi kululo umuntu akauka akimika apo. ");
INSERT INTO isn_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","U Yesu akalunga kitalao, kumukolya unye tai ne uluhiku la Sabato kituma nimaza ang'wi kugazanja kuguna imatungo ang'wi kugazanja? Hangi akaagoza ihi nukuaila umuntu uyu. ");
INSERT INTO isn_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Goola umukono ako.” Akatenda uu numukono akwe uuagunwa. ");
INSERT INTO isn_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ingi ikizula ikuo, ikiligitwa enso kuenso itume ntuni kung'wa Yesu. ");
INSERT INTO isn_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Apumie mahiku ayo kusoko aiwendile mulugu kulompa, akalongoleka utiku wihi kumulompa Itunda. ");
INSERT INTO isn_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Naiituile dau, akaitanga iamanyi akwe, akahula ikumi na ibili ung'wi ao, hangi akaitanga ia mitume.” ");
INSERT INTO isn_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Mina amitume nianso aitangwa Simoni (hangi akamitanga Petro) nu Andrea umuluna akwe, Yakobo, Yohana, Filipo, Bartolomayo, ");
INSERT INTO isn_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matayo, Tomaso nu Yakobo ng'wana wang'wa Alfayo, Simoni, awitangilwe Zelote. ");
INSERT INTO isn_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda, ng'wana wang'wa Yakobo nu Yuda Isikariote naumuguiye. ");
INSERT INTO isn_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ingi u Yesu akasima mulugulu palung'wi nienso nukimika muegusi, malundo makulu idu na manyisigwa aiakoli kuko, palung'wi nilundo ikulu la antu kupuma ku Uyahudi nuku Yerusalemu, nukupuma kupwani ang'wa Tiro nu Sidoni. ");
INSERT INTO isn_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ingi ikaza kumutegelya nukumuguna imaulwaee akwe. Iantu aiagigwa nia mintunga niabii ikagunwa ingi. ");
INSERT INTO isn_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ihi naiakole pang'wanso pamilundo ihi aiagemile kumuamba ingulu yaugunwa aiipumile mukati akwe, akagunwa ihi. ");
INSERT INTO isn_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ingi akaagoza iamanyi akwe, nu kulunga, makendepwane unye nimiahimbi kunsoko utemi wang'wi Tunda wanyu. ");
INSERT INTO isn_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Makendepwa ni unye ni mianyanzala itungili, kunsoko mukikutigwa. Makendepwa unye nimukulila itungili, kunsoko mukuheka. ");
INSERT INTO isn_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Makendepwa unye kunsoko iantu akumubipilwa nukuabagula unye nukuilwa miabii kunsoko ang'wana wang'wa Adamu. ");
INSERT INTO isn_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ingi mulowe n'wa uluhiku nulanso nukuputangila kuulowa, kunsoko itai mukutula nikulu kilunde, kunsoko iatata ao aiatendee uu ianya kidagu. ");
INSERT INTO isn_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ingi gozi gwa unyi agoli nimapatile upumpuilya wanyu. ");
INSERT INTO isn_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ingi gozi gwa nimikutile itungili, kunsoko mukumiona inzala pambele. Unyenimukuheka itungili kunsoko muzeziaya nukulila pambele. ");
INSERT INTO isn_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Unye nimukulumbiligwa niantu ihi ingi iatata ao aiatendee ianyakidagu autele uu uu. ");
INSERT INTO isn_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ingi gwa kulunga kitalanyu unye nimutegeye, alowi iaibii anyu nukituma nimaza awani mubipiwe. ");
INSERT INTO isn_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Akendepi ao niakumuzuma unye nu kualompela awa niakumuonela. ");
INSERT INTO isn_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kitalakwe uyu nukukua ukunda ling'wi mupiuilye nili nilakabili anga umuntu wakuhegelya inkanzu ako leka kumugilya. ");
INSERT INTO isn_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mupe kihi nukulompa, anga umuntu wakuhegelya ikintu kihi nikako lekakumlompa akusukilye. ");
INSERT INTO isn_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Anga nimualoilwe iantu amutendeke, nunye atendeli uu uu. ");
INSERT INTO isn_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Anga mualowe iantu nia amuloilwe unye du, nilanso isongelyo kii kitalanyu? Ingi ataianyamilandu aloilwe ao nizaaaloilwe. ");
INSERT INTO isn_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Anga muatendele nimaza ao niimutendela unye nimaza nilanso isongelyo kukitalanyu? Ata ianyamilandu ituma uu. ");
INSERT INTO isn_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Anga muapa imaintu niantu ao nimulindie akusukilya, nilanso isongelyo ki kitalanyu? Ata ianyamilandu iapeza ianyamilandu, nukulindila kusigilya kikokiko hangi. ");
INSERT INTO isn_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ingi alowi iabii anyu nukuatendela ni maza. Akopisi muleki kutula nuwoa kusukiligwa. Isongelyo lanyu lukutula ikulu. Mukutula miana ang'wa uyo nukole migulya, kunsoko nuanso ng'wenso muza kuantu niagila isongela niabii. ");
INSERT INTO isn_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tuli nikinyauwai anga utata anyu nukete ikinyauwai. ");
INSERT INTO isn_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Leki kuahukumile, ianyu shanga mukuhukumilwa. Leki kuzumi, nunye shanga mukulaanilwa. Lekeli niangiza, nunye mukulekelwa. ");
INSERT INTO isn_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Api niangiza, nunye mupegwa. Ngele aukende nu ukinyangiwe, nu kokelwa nu kuhunuka mu malu pang'wanyu. Kunsoko kungeli ihi ni mukutumila kugemelya, ingele iyo ikutumika kumugemelelya unyenye.” ");
INSERT INTO isn_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ingi akaaila hangi, “Ite umuntu numopoku uhumile kumutongela umuntu numungiza numupoku? Ang'wi aiwitumile uu ihi aizigwila mikombo, ite singa aazigwila? ");
INSERT INTO isn_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Umumanyisigwa singukutula mukulu kukila umumanisi akwe, kululo umuntu anga manyisigwe kisa ukutula anga umumanyisi wakwe. ");
INSERT INTO isn_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Kuniki nukuligoza ihongo nilikoli muliho la munya ndugu ako, ili nilikoli muliho lako shuligozili? ");
INSERT INTO isn_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Uhumile uli kumuila umunyandugu ako, munyandugu kulopa nikiheje ikibanzi nikikoli mukati muliho lako. nue shangaugozili nilikoli muliho lako uewe? Umutele uewe! Heja hanza nilikoli muliho lako uewe, pang'wanso ukuona iza kuheja ikibanzi muliho la munyandugu ako. ");
INSERT INTO isn_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Kunsoko kutile umuti nuuza uukutuga imatunda ni mabii, hangi kutili umuntu uubii nuukutuga imatunda ni maza. ");
INSERT INTO isn_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kunsoko kila umuti umanyikile ni matunda ake. Kunsoko umuntu shangakukala itini kupuma mumija, hangi shangu kukala izabibu kupuma mumichongoma. ");
INSERT INTO isn_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Umuntu numuzaa nukite imasigo nimaza munkolo akwe wipumya nakoli nimaza. Umuntu numubii imasigo ni mabii namunkolakwe ipumya ni mabii kunsoko umulomo wake wiligitwa nizuilya inkolo akwe. ");
INSERT INTO isn_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Kunike nimukunintanga, Tata, Tata, namukili kituma aya ninungile? ");
INSERT INTO isn_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Umuntu wihi nuzile kitalane nukija ikani yane nukituma, imilimo, kumulagila nuili. ");
INSERT INTO isn_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ingigwa impyani numuntu nuzengile inyumba akwe hangi nuhimbile pihi lukulu nukuzenga umusingi wa nyumba migulwa migwe nikaku imazi naiazile, numongo ikamikua inyumba sanga ikagwa shanga ikahuma ata ukumihingisa kunsoko aizengile iza. ");
INSERT INTO isn_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ingi wihi nukija ulukani lane, shanga ulukee, impyani akwe numuntu nuzengile inyumba migulwa amizi nikutile numusingi, umongo nausimile kunguru, inyumba iyo ikahingisigwa ikulu. ");
INSERT INTO isn_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","U Yesu naiwakondya kuligitya imaintu izi iantu naiamutegeye, akingila ku Kapernaumu. ");
INSERT INTO isn_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mtungwa ung'wa ung'wi wang'wa akida, aimuza nangulu kitalakwe ai mulwae tai hangi aukuhiaukusha. ");
INSERT INTO isn_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ingi aiwijaa itendo yang'wa Yesu, uyo u Akida akamutuma umomboi wa kiyahudi, kumulompa aze kumuguna umutugwa akwe aleke kusha. ");
INSERT INTO isn_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Naiapikile kakupi nu Yesu, ikamlompa akalunga, utakiwe witume uu kunsoko akwe. ");
INSERT INTO isn_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kunsoko umiloilwe izi itu, ng'wenso akazenga itekeelo kunsoko itu.” ");
INSERT INTO isn_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","U Yesu akendelea ni muhinzo wakwe palung'wi ni enso naiwakuli kulongola kuli ni nyumba, mukulu wang'wi auatumile lahumba uya aligitye nu ng'wenso tata iekakukatala uewe kunsoko unene singa faile iewe kingila mudari ane. ");
INSERT INTO isn_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kunsoko iyi shaaza singie unene ung'wenso kutula faile kuza kitalako, ingi tambula ulukani du umitumi wane akomye. ");
INSERT INTO isn_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kuniki unene hangi ni muntu nuikilwe muukulu hangi nyenyu nitalishi pihi ane. Wilunga kung'wa uyo, “Longola” na ulongole, nukumungiza, “Nzuu” nung'wenso wizaa nukumitumi wane itume iki nung'wenso wituma. ");
INSERT INTO isn_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","U Yesu naiwigule aya akakuilwa, nukuapilukila umilondo naumtyatile nukulunga kumuila ata ku Israeli iza nkili kuona umuntu nukite uhuili nukulu anga uyu. ");
INSERT INTO isn_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ingi awaite naiatumilwe aiasukile kito ikamuhanga umukulu mupangau. ");
INSERT INTO isn_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Naitumile nanso, aeipumie u Yesu aulongoe mukisali nikitangwa Naini, iamanyisigwa akwe ikalongola palung'wi nung'wenso ikakuile niauntu idu. ");
INSERT INTO isn_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Naupikile pakupi nitanilyo lakisali goza, muntu nukule akizukekilwe, hangi ng'wana wing'wene kung'wa nyinya akwe, naukali muhimbi numilundo ikatuula palung'wi nung'wenso. ");
INSERT INTO isn_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Naumuine, utata akamuhugela kwa uwai nukulu itai migulya akwe nukumuila, liekakulila.” ");
INSERT INTO isn_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ingi akahugela akalianka isandiko nailikenkee umuimba, nawanaiakenkile ikimika ikalunga umuhumba nungile uka. ");
INSERT INTO isn_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Umushi akauka nukikie pihii nukaza kuligitya hangi u Yesu akamupa unyinya wakwe. ");
INSERT INTO isn_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Hangi ikizuilwa nuoa ihi. Ikalongoleka kumukulya Itunda akizilunga “Munyakidagu mukulu uukigwe kukiila kumataitu” nu Itunda ukugozile iantu akwe. ");
INSERT INTO isn_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Izinkani ni nzaa ni yang'wa Yesu aisambaie ku Yudea ihi niisali yihi niapakupii. ");
INSERT INTO isn_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Iamanyisigwa ang'wa Yohana aiamuie inkani izi yihi. ");
INSERT INTO isn_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ingi Yohana akaitanga abili iamanyisigwa akwe nukuatuma kung'wa tata, kulunga uewe ng'wenso uyu nuzile, ang'wi ukole muntu mungiza kumulindile? ");
INSERT INTO isn_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Naiapikile pakupi nu Yesu nianso ikalunga, Yohana mubadisigwa ukutumile kitalako kulunge. Uewe u ng'wenso nuzile ang'wi ukole muntu mungiza kumugezele? ");
INSERT INTO isn_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Imatungo yayo auagunile iantu idu, kupuma mdwala numulwago, kupuma mukolo nibii, niantu niakete upoku ikaona. ");
INSERT INTO isn_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","U Yesu akasukilya nukulunga kitalao, ingi naimulongoe naiapumie mukumulagilwa u Yohana ikinimukiine nukukija, awaniapoku akuona niakitele akugenda, niakite imbili akunona, iagulu ainija, iashi ahimbuka nukutula apanga hangi iahimbi akuilwa ulukani nuluza. ");
INSERT INTO isn_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Umuntu nushukuleka kunihuila unene kunsoko auitumi wane ukukendepwa.” ");
INSERT INTO isn_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ao naiatumilwe nu Yohana kusuka naiapumie, Uu Yesu akandya kuligitya numilundo kunsoko ang'wa Yohana, aimendile kunzi kugoza ntuni, uwelu auukuhingisigwa nu ng'wega? ");
INSERT INTO isn_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Azamendile kunzi kugoza ntuni, muntu nutugae izaane? Goza iantu niatugae inguo yakitemi nukikie ulikalo nuluza akole niang'wi akete ilyoma anga iatemi. ");
INSERT INTO isn_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ite minzu kunzi kugoza ntuni, muntu mnyakidagu? Ingi kulunga kitalanyu niidu itai kukila umnyakidagu. ");
INSERT INTO isn_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Uyu yuyu nauandikiwe, “Goza, kumtuma mitumi wane ntongela a miho anyu, nukunonelya inzila kunsoko ane. ");
INSERT INTO isn_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nungile kitalanyu, kukiila ao naiatugilwe numusungu, kutile numukulu anga Yohana, ingi umuntu ishanga wati nuhumile kikie nu Itunda kung'wanso nukoli nuanso, ukutula mukulu kukila u Yohana.” ");
INSERT INTO isn_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ni antu ihi naiigulwe aya palung'wi niahoela mpia aiatanantilye Itunda ukete Itai. Aiakoli niang'wi naiabadisigwe nu ubadizo wang'wa Yohana. ");
INSERT INTO isn_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ingi imafarisayo nia zaa akani ya kiyahudi awa nishaaiabadisigwe nung'wenso aiahitile itai ang'wi Tunda kunsoko ao ienso. ");
INSERT INTO isn_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Hangi nihumile kumipyana ni ntuni antu nia uleli uwu? Akoli uli hangi? ");
INSERT INTO isn_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Impyani niangenya, niakigisa mumpelo isoko, niikie nukuitanga ung'wi ung'wi nukulunga, kupembile ipilimbi kunsoko anyu, shanga miginsile kiaiye shanga muliile. ");
INSERT INTO isn_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","U Yohana mubadisi auzile shanga aulie hangi shanga aung'wee imagai, mikalunga ukite amitunga. ");
INSERT INTO isn_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ung'wa muntu uzile walya nukung'wa mikalunga, “Gozi mulaku mugala ntuli, muhumamuya wa ahoela mpia nia anyamilandu! ");
INSERT INTO isn_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ingi uhuili wigeleka kina ukite itai ku anaako ihi.” ");
INSERT INTO isn_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ung'wi wa mafarisayo aumulompile u Yesu alongole kulya palung'wi nung'wenso. U Yesu naiwingila munyumba ang'wa farisayo, akahegamila mumeza alye. ");
INSERT INTO isn_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Goza aukoli musungu ung'wi mukisali nikanso naukete imilandu, Akalinga kumbi wikie kung'wa farisayo, akaleta insupa na makuta nimaza. ");
INSERT INTO isn_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Aiwimikile kunyuma akwe kakupi ni migulu akwe kunu akizilila. Hangi akizitontwa imigulu akwe kulihali, nukupyagula kumasingi amitwe lakwe, akamibusu imigulu akwe nukumipaka imakuta nimaza. ");
INSERT INTO isn_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nung'wenso u farisayo aumanile u Yesu nauine uu, akasiga ung'wenso akalunga, umuntu uyu angaaizi munyakidagu, auziliga uyu nyenyu nu wanamuna ki umusungu nukumupapatwa, ukutula mnyamilandu. ");
INSERT INTO isn_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","U Yesu akasukilya nukumuila, Simoni nkite kitu kakuuila. “Akalunga” “Kitambule udu ngwalimu!” ");
INSERT INTO isn_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","U Yesu akalunga, “Aiakole adaigwa abili kumukopisi ung'wi. Ung'wi audaigwe magana miatano nua akabili dinari hamusini. ");
INSERT INTO isn_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Naiatuile agila impia nia kumulipa ikalekelwa ihi. Nuuli nukumulowa mbelee? ");
INSERT INTO isn_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","U Simoni akasukilya nukulunga, nsigile uyu nutekewe u Yesu akamuila, ulamue itai.” ");
INSERT INTO isn_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","U Yesu akamupilukila umusungu nukumuila u Simoni umuine ne umusungu uyu. Ningie munyumba ako. Shangaupee imazi kunsoko amigulu ane. Ingi umusungu uyu, kuliholi lakwe akatontwa imigulu ane nukumipyagula kuisingi lakwe. ");
INSERT INTO isn_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Shanga azunungie, nuanso nazawingia muno sigulekile kunungila imigulu ane. ");
INSERT INTO isn_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Shaazumipakile imigulu ane imakuta, ingi umipakile imigulu ane kumakuta nimaza. ");
INSERT INTO isn_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ku lukani uli, nukuuila ingi aukite imilandu nidu ingi wasamihilwa itai, hangi akalowa itai. Ingi uyu nusamihiwe inino, nuilowa inino du. ");
INSERT INTO isn_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Itungo akamuila umusungu, “Imikindo ako asamihilwa.” ");
INSERT INTO isn_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nawa naiikie pameza palung'wi nung'wenso ikandya kiligitya enso ku enso, “Uyu nyenyu nukusamihila imilandu? ");
INSERT INTO isn_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nu Yesu akamuila umusungu, uhuili wako wakuguna. Longola ku uhuili” ");
INSERT INTO isn_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Aiituile tungo ikupi u Yesu akandya kulongola muisali numukisali nia kulikuli, akazitanantwa inkani ninzaa nia utemi wang'wi Tunda na nikumi na ibili aialongoe palung'wi nung'wenso, ");
INSERT INTO isn_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","kuu iasungu niang'wi aiagunilwe kupuma kumakoro nimabii nindwala nigiza, ai Mariamu naiwitagilwe Magdalena naupumiigwe iamitunga mupungati. ");
INSERT INTO isn_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yoana musungu wang'wa Kuza numukulu wang'wa Herode, Susana, nia sungu niagiza idu, aiapumilye imaintu ao ienso. ");
INSERT INTO isn_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Matungo inino umilondo wa antu kilingila palung'wi, akiziakole ni antu naiazile kitalakwe muisali kulikuli, akaligitwa nienso kutumila ipyani. ");
INSERT INTO isn_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Umutemeli aiwendile kutemela imbeu, nautuile kutemela imbeu ing'wi nianso yikagwila pampelo a nzila yikapanangilwa nimigulu ni nyunyi niamigulya ikailya. ");
INSERT INTO isn_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Imbeo inzuya aiigwee milolo migulya, numitalagwe naiipumile nukukula imili ikaola kunsoko aikutile utotu totu. ");
INSERT INTO isn_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Imbeu niingiza aiigwei mumiti namija, ni miti nanso ikakula palung'wi nimbeu nianso yikatunyiligwa. ");
INSERT INTO isn_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ingi imbeu ningiza naigwie milolo niza yikatuga uilo hangi magana idu, U Yesu akalunga inkani izi akahumbula ululi, “Ulihi nukete iakulyu ije.” ");
INSERT INTO isn_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Hangi iamanyisigwa akwe ikamukolya insoko apyaniao. ");
INSERT INTO isn_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","U Yesu akaaila mupewe ilyoma nukumanya ukulu wa mutemi wa utemi wang'wi Tunda, hangi iantu idu akumanyisigwa du kumpyani, ingi angaona, alekekuona niakija aleke kulinga.” ");
INSERT INTO isn_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","I yi yiyi ng'wao apyani i yi. Imbeu lukani lang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Imbeu niing'wi niingwie mupelopelo anzila ingi wawo antu niija ulukani, umubii umulugu wikalohula kuli kupuma mukolo, ingi aleke kuhuila nukugwigwa. ");
INSERT INTO isn_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ingi izo niigwie mitalagwe ingi antu nianso niija uluka nukulupokela kuulowa ingi agila imile ihi, ihuila udu kumatungo nimakupi ni matungo amageng'wa ingwiza. ");
INSERT INTO isn_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Imbeu izo niigwie mumija ingi antu niija ulukani, ingi aloilwe kukula ilingilwa nu ugoli, nuuza walikalo aya ingi shaituga imatunda. ");
INSERT INTO isn_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ingi imbeu izo naigwie milolo niza wawa antu niapolo nikolo ninza, angaije ulukani iluambila likatula lupanga nukutuga indya kulindila. ");
INSERT INTO isn_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ingi itungili kutile ata nung'wi nukusonsa intala nukumikunikila ni bakuli ang'wi kumiika pihi akitanda kuika migulwa ya ntala hangi ungwiao nukingila ahume kumiona. ");
INSERT INTO isn_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Hangi gwa kutile nikukipiha nishakikumanywa ang'wi nikaunkunku iki nishakikumanywa nikikoli muwelu. ");
INSERT INTO isn_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ingi tula ukoli uza unutegeye kunsoko nukite kitalakwe ukungeligwa itai. Uyu numugila ata nikinino ukite kikuholwa.” ");
INSERT INTO isn_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Matungo unyinya wang'wa Yesu nianyandugu akwe akiza kitalakwe shanga aihahugee kunsoko amilundo nu antu. ");
INSERT INTO isn_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ingi akailwa, “Unyinya ako nialuna ako akoli apo kunzi atakile kuona uewe. ");
INSERT INTO isn_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ingi u Yesu akasukilya akalunga uiane nialuna ane awaniilija ulukani lang'wi Tunda nukulugomba.” ");
INSERT INTO isn_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Aiipumie luhiku lung'wi imahiku nanso u Yesu nia manyisigwa akwe aianakie mibini, akaaila kupute kitumbi la kabili kuluzi, ikanonelya ibini lao. ");
INSERT INTO isn_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Naiandilye kuhega, u Yesu akalala utulo, nung'wega ukatula leta imaingo, ni mabini ao ikatulizula imazi. ");
INSERT INTO isn_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ingi iamanyisigwa akwe akiza kitalakwe uumuusha, nukulunga, tata mukulu. Tata mukulu kukoli kakupi kusha. Akauka nukuukenela ung'wega imaingo amazi akakilaja. Ikatulia. ");
INSERT INTO isn_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Hangi akaaila, uhuiili wanyu ukoli pii? Akogopa, ikakuilwa, ikatuitambulya ung'wi numuya. Uyu nyinyu nukulagilwa ung'wega ni mazi akumukulya? ");
INSERT INTO isn_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Aiapikile kukisali kaku Gerasini nikoli ipande kunyuma ang'wa Galilaya. ");
INSERT INTO isn_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","U Yesu nausimile nukupambata pihi, muntu kupuma mukisali akatankana nung'wenso umuntu nuanso aukite ngulu ya kiti. ");
INSERT INTO isn_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Naumuine u Yesu akalila kululi, nukugwa pihikuntongela akwe. Ululi nulukulu akalunga, tendile uli kitalako, u Yesu ng'wana wang'wi Tunda nukoli migulya? Kulompa uleke kumpa ulwago unene. ");
INSERT INTO isn_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","U Yesu akamiila ikolo nibii ihege kumuntu nuanso, kunsoko aizimukite ata atungwe indigi nukutunyingwa, nukuikwa pihi ulindilwa, akabadula ifungo nukutalwa nia mintunga mumbuga. ");
INSERT INTO isn_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","U Yesu akamukolya ilina lako winyinyu? Akasusha akalunga, “Legiono” Kunsoko iamintunga idu niingie kitalakwe. ");
INSERT INTO isn_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ikalongoleka kumupepelya leka kuuzunsa kweni mikombo. ");
INSERT INTO isn_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ilundo la ngulima ailikudima migulya mulugulu, akamlompa alekele ingile kung'wanso mungulima. Akaagompya kituma uu. ");
INSERT INTO isn_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ingi iamitunga ikahega kumuntu ikalongola mungulima ilondo langulima likamanka migunguda mlugulu numulizi ikalimansila mumo. ");
INSERT INTO isn_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Iantu naiakudima ingulima nai aine itulekile ikamaka ikaaila ianyakisali nikunzi isali naiapilimile. ");
INSERT INTO isn_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Iantu naiigule nanso ikalongola kugoza nikigee, ikaza kung'wa Yesu ikamuona umuntu naukite iamintunga ikamuteela. Aiwitungile ung'wenda iza akizukete ni mahala izi, akikie mumigulu ang'wa Yesu, ikakuilwa. ");
INSERT INTO isn_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kululo ung'wi ao nauine akaaila niangiza umuntu uyu nautawe nimintunga naugunilwe. ");
INSERT INTO isn_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Iantu ihi nia mukisali kang'wa wa Gerasi nimatumbi naiapilimiye ikamolompa u Yesu ahege kitalao kunsoko aukete uoa ukulu. Akingila mibini akasuka. ");
INSERT INTO isn_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Umuntu nuanso naupumilwe numintunga akamupepelya u Yesu alongole nung'wenso, ingi u yesu akamuila alongole nukulunga. ");
INSERT INTO isn_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Suka munyumba ako na ualye ayo ihi ni Tunda ukutendee” Uyu umuntu akahega, akatanantya uko muisali yihi aya ihi nu Yesu naiwitumile kunsoko akwe. ");
INSERT INTO isn_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nu Yesu akasuka, umilundo ukamusingiilya kunsoko ihi aiamulinde. ");
INSERT INTO isn_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Goza akoza muntu ung'wi aiwitangwa Yairo ung'wi wao wa kulu wa mikumbikilo, Yairo akagwa mu magulu ang'wa Yesu nukumupepelya alongole munyumba akwe, ");
INSERT INTO isn_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kunsoko aukete ung'wana numunanso ung'wi du naukete imyaka ikumi na ubili, aukole inino nukusha. Naulongoe, umilondo aiwitunyiye kitalakwe. ");
INSERT INTO isn_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Umusungu aiwipuma isakami imyaka ikumi na ubili aukoli hapa autumie impia yihi muaganga ingi kutile naumugunile ata nung'wi. ");
INSERT INTO isn_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Auzile kunyuma ang'wa Yesu nukuamba ung'wenda mumpelo akwe, hapou isakami ikahila. ");
INSERT INTO isn_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","U Yesu akalunga, “Nyinyu numambile? Naiahitile ihi u Petro akalunga, mkulu, umilondo wa antu winda kusunta nukuutambula. ");
INSERT INTO isn_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ingi u Yesu akalunga, muntu ung'wi aumambile kunsoko aimine ingulu ipumile kitalane.” ");
INSERT INTO isn_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Umusungu nauine shanga ukupiha naiwitumile, akatula kagata, akagwa pihi pang'wa Yesu akatanantwa muantu ihi kunsoko naiituile amuambe nukumuguna hapou. ");
INSERT INTO isn_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ingi akalunga kitalakwe, “Munanso uhuili wako ukulu wa wakutenda utule wimupanga. Longola kuuza.” ");
INSERT INTO isn_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Naulongolekile kulunga, umuntu ung'wi akaza kupuma munyumba amukulu wa mitekeelo akalunga, “Munanso ako ukule likakumunyoma ung'walimu. ");
INSERT INTO isn_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","U Yesu naiwigwe iti, akasukilya, “Uleke kogopa du Huila ukugunika.” ");
INSERT INTO isn_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Hangi naiwingie munyumba nanso, shanga ulekee muntu wihi kingila palung'wi nung'wenso, ingi Petro, Yohana, nu Yakobo, ihe akwe nua munanso, nu nyinya akwe. ");
INSERT INTO isn_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Iantu ihi aiakulila nukupumya uluili kunsoko akwe, hangi akalunga, tekikukulya iogo, sangu kule, ingi ulae tulo du. ");
INSERT INTO isn_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ingi ikamuheka kuzalau akizi aini ingi ukule. ");
INSERT INTO isn_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ingi nuanso, akamuamba umunanso umukono, akitanga kululi akalunga, mung'enya uka.” ");
INSERT INTO isn_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ikolo akwe ikamusukila, nukuuka matungo yayo. Akalagelya apege kintu kihi alye. ");
INSERT INTO isn_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ialeli akwe ikakuilwa, ingi akaalagelya alekekumuila muntu iki nakipumie. ");
INSERT INTO isn_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Akaitanga ao ni kumi na abili palung'wi, akaapa uhumi nuukulu mugulya amintunga ihi nukuaguna indwala. ");
INSERT INTO isn_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Akatuma alongole kutanantya utemi wang'wi Tunda nukuguna ialwae. ");
INSERT INTO isn_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Akaila, muleke kuhola kihi kunsoko amuhinzo wanyuata umulanga, ata imbugulu, ata indya, ata ipia, muleke kuhola inkanzu niibili. ");
INSERT INTO isn_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nyumba ihi nimukingila mikie mumo kunamukuhegela kung'wanso. ");
INSERT INTO isn_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ingi ngwa ao nisha akumusingilya, nimukahega mukisali nikanso, mipununte ulunkundi mumigulu anyu kunsoko akilingasilyo kao. ");
INSERT INTO isn_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ikahega ikalongola nukukiila muisali, nukutanantya upanga nukuguna lantu ni. ");
INSERT INTO isn_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Itungili Herode, mkulu, aiwigule, ihi naiapumie aiwagile itai, kunsoko aiittambuwe ikatula Yohana mubatisaji uhimbukile kupuma muashi. ");
INSERT INTO isn_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Niakehu ikalunga ue Elia wapumie, niangita ikalunga ung'wi wanyakidagu nia kali wahimbuka muashi hangi. ");
INSERT INTO isn_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","U Herode, akalunga, ainimusinzile u Yohana, Ingi uyu nyinyu nung'wenso nikija inkani yakwee? u Herode akaduma inzila akumuona U Yesu. ");
INSERT INTO isn_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Imatungo naiasukile nai atumilwe, ikamuila imantu ihi naitumile. Akahahola palung'winung'wenso akalongola wing'wene muhisali nikitangiwle Bethsadia. ");
INSERT INTO isn_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ingi umilundo wikija, ikamutwata, nukuasingilya akaligitwa nienso, utemi wang'wiTunda, au agunile awa naialoitwe kuguma. ");
INSERT INTO isn_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Uluhuki nailandilye, kuhila nao nikumi naibili ikalongola kitalakwe akalunga, ''Usimbailye umilundo ulongole mukisali nia pakupi numuisali adume, usupilyo nindya, kunsoko kukoli mumbuga. ");
INSERT INTO isn_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ingi akaaila unye api imaintu akulya. ''Ikalunga kutile nimangiza ikoli indya kunsoko amilundo ni antu''. ");
INSERT INTO isn_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Aikali itunja magana anzugu ataano pang'wanso. Akaaila iamanyisigwa akwe, Ikalinsi pihi maanza aantu iziakoli hamsini kila lanza ");
INSERT INTO isn_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kuluko ikatenda uu ni antu akikie pihi. ");
INSERT INTO isn_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Akahola indya itaano ni samaki ibili akagoza milunde, akaikendepa, nukuega ipande, akaapa iamanyisigwa akwe aike kuntongela amilundo. ");
INSERT INTO isn_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ini ikalya ikikuta, imaminyanguilwa naisigile ikahoela ikizulya itoto ikumi na ibili. ");
INSERT INTO isn_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nung'weso naukulopa wing'wene, lamanyisigwa akwe aiakoli palung'wi nung'wenso, akaakolya akalunga, lantu ilunga une ni nyinyu? ");
INSERT INTO isn_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ikasusha, ikalunga, Yohana mubadisaji, niangiza ilunga Eliya, niangiza ilunga ung'wi wanyakidagu wa matungo na kali wahimbuka hangi. ");
INSERT INTO isn_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Akaaila unyenye milunga unene ni nyinyu? Akasusha u petero akalunga, ''kristo kupuma kung'wi Tunda''. ");
INSERT INTO isn_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ingi ngwa u Yesu akaahugolya, alekekumuila wihi kua ili iti. ");
INSERT INTO isn_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Akalunga ng'wana wang'wa Adamu itai ukaga kunkani ni idu nukuhitwa nianyampala ni atemi ni aandiki nukubulagwa, nuluhiku lakatatu ukuhembuna. ");
INSERT INTO isn_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Akaaila ihi, ang'wi muntu wihi nuloilwe kutyata, Ikanwe ung'wenso, ahole itoka lakwe imahiku ihi na antyate. ");
INSERT INTO isn_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Wihi niwiza kugemakukuna upanga akwe ukuguni. ");
INSERT INTO isn_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kululo ukupata nsao ke umuntu, hangi au one ukumbigulu wihi, ukuliniilya nukuulya Ilioma lakwe. ");
INSERT INTO isn_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Wihi nukuona iminyala kungwana ninganiyane, ng'wenso ng'wana wa ng'wa Adamu ukumuone minyala muuza na nuuzawang'wi ihe. ");
INSERT INTO isn_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ingi kumuili itai, akehu, niimikile apa, sha akumilulya insha ku utemi wang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mahiku munana naiakile u yesu alunga nkani Izi ingi ahela palung'wi nung'weso petro, Yona nu Yakobo, Akanankila mulugulu nukulompa. ");
INSERT INTO isn_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ingi gwa nakulompa, u usu wakwe ukakailika ni mavazi akwe ikela pee. ");
INSERT INTO isn_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ingi goza, aiakali Itunja abili akaziligitya nung'wenso ai Musa nu Eliya. ");
INSERT INTO isn_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Aigee kunso au kendepwa, ai aligitilya kunsoko kuhega kitala kwe, nkani naihuge kumala ku Yerusalem. ");
INSERT INTO isn_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Itungili u petro naiyine palung'wi nung'wenso ainkoti mutulo numulito hangi naiaukile, Ikaona uza wakwe ni itunja abili naimikile palung'wi nung'winso. ");
INSERT INTO isn_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ikatula naiakuhega kung'wa Yesu, akamuila, ''mukulu, ingi iza kikie kunu kitaitu itakiwe kunoniye imakazi a antu atatu. ");
INSERT INTO isn_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nau ukulunga, nanso, likeuta ilunde lika akunikila, na ikogopa nilkaona apilimili gwa ni lunde. ");
INSERT INTO isn_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ululi lika puma milunde ikalunga, uyu ng'wa ana mutemi, mutegeli ng'wenso. ");
INSERT INTO isn_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ululi nailukilagilye, u Yesu aiwing'ene du, aiwikie twee imahiku nanso. ");
INSERT INTO isn_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Luhiku nulukatwata, nika puma mulugulu, mumilunda ukulu nu a antu ikantankana nu ng'winso. ");
INSERT INTO isn_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Goza, mitunja mitunja aupumie mumilundo akalila kululi, akalunga, mumanyisi kulopa umugoza ung'wa ane, wingene. ");
INSERT INTO isn_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Waona ikolo nimbi hapun witule kulia iogo, witula uhaile nukupumai pombalu, N lipuma kushada, nu uwai nu utaki. ");
INSERT INTO isn_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Aini alompile iamanyisigwa ako kukemela Ikaleng'wa. ");
INSERT INTO isn_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","U Yesu akasusha akalunga, unye uileli nu uhuie nuwu nualekile, kizi kikie nalinunye? muleti ungwa apa. ");
INSERT INTO isn_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Muhumba inkolo aiza nimbi aimutagaa pihi nuku muhingisa kungulu. ");
INSERT INTO isn_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ihi ikapata ikuilwa ukulu wang'wi Itunda hangi ikatula singa ihi inkani naiwatumile, alunga kua manyasigwa akwe. ");
INSERT INTO isn_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Inkani yingile mua kutwa anyu kunsako ungwana angwa Adamu ukuhegigwa mumikono a anadamu. ");
INSERT INTO isn_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ingi shanga aialingile inkani nianso aipihilwe mumiho ao kusoko aleke kulinga akogopa kukolia ulukani nulanso. ");
INSERT INTO isn_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ingi akatula kinyoma kukiila kitalao Ingi gwa nyenyu natule mukulu. ");
INSERT INTO isn_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ingi u Yesu akalinga naiakikalia mukalo yao, akamuhola umungenye numunino nukumuika pang'wa kwe. ");
INSERT INTO isn_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Akulunga umuntu wihi nukumusingilia umung'enya numunino angu uyu kulina lane, ansingilie nune hangi, wihi nukunsingili une amusingili nuyu nautumile, kunsoko munino kung'wanyu wihi yuyo mukulu. ");
INSERT INTO isn_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohana akasusha akulunga, ''mukulu, aikumuine umuntu akazi muzunsa ukintunga kulina lako kikamugili kunsoko shukoli palungwi nuse. ");
INSERT INTO isn_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ingi u Yesu akaila lekikumugili, uyu nisingukali palung'wi nunye Ingi wanyu. ");
INSERT INTO isn_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ikatula imahiku nai ahumbee kullongala kilunge, akahonja u usu wakwe ku Yaruselemu. ");
INSERT INTO isn_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Akatuma lanya mpala akwe, kuntonge la akwe, nienso ikalongola kukisali ka Wasomaria amunonelie pang'wanso. ");
INSERT INTO isn_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","I antu sanga ikamusingilia, kunsoko au hongilye u usu wakwe ku Yarusalemu. ");
INSERT INTO isn_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Iamanyisigwa akwe Yakobo nu Yohana naiaine iti, Ikalunga, mukulu itakile uzume umoto usime pihi kuma milunde ualimili? ");
INSERT INTO isn_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ingi akapilukila akaakenela. ");
INSERT INTO isn_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ingi gwa Ikalongola kisali lingiza. ");
INSERT INTO isn_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Naiahongile munzila yao, muntu ung'wi akamuila, mahali Ihi nuinzo. ");
INSERT INTO isn_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu akamuila,'' umulula akete imakombo, Inyonyi yamigulia akete iunyi, kunsoko umuntu mugila pakulala itue lakwe'' ");
INSERT INTO isn_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kululo akamuila muntu mungiza, Itiate.''naunso akalungai'' mukulu, ndekele nendemuika utata wane. ");
INSERT INTO isn_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Nuanso akamuila aleke Iashi aike Iashi ao, kululo uewe longola utanantie utemi wang'wi Itunda kuisali. ");
INSERT INTO isn_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Hangi muntu mungiza akalunga, kutiata, Mukulu, ndulusile hanza nialage niakoli munyumba ane. ");
INSERT INTO isn_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu akamuila kutile umuntu, nuika umukono akwe kulima nukugoza kunyuma nukutula Mtemi wang'wi Itunda. ");
INSERT INTO isn_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Naiwakondyo kuligitya nanso, Uyesu akaaholanya hangi makumi mapungate nuakualagialya abili amutongeele muisali nutakile kenda. ");
INSERT INTO isn_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Akaila indya niakuogolwa yidu, eituwia milimo akehu, kululo mulompi umukulu nuauogoli akaye kuatwala eitumi muogoli nuandya yakwe. ");
INSERT INTO isn_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Longoli muisali mutule miho numutumile anga inkolomukati amadale a mbugu ya yamihaka. ");
INSERT INTO isn_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Muleki kukenka imbugulu nia kila ngila, ang'wi ilatu, hangi muleke kumulamsha muntu wihi mungila. ");
INSERT INTO isn_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Munyamba ihi nimukingila, lungui hanza, mpolo utule ni nyumba uji ");
INSERT INTO isn_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6",". Ang'wi muntu wa upolo ukoli pang'wanso, upoto ukutula kitalakwe ang'wi kutile pang'wanso mpolo ukusuka kusuka kutalanyu. ");
INSERT INTO isn_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Sagi munyumba yiyo, lii nukung'wa iko niakuki pumya, kunsoko umitumi wipegwa ikinya mulimo nazawitumilo. ");
INSERT INTO isn_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Mukisali kihi nemukingila, anga amu singilya, muliye indyanikuwekwa panlongeela anfu. ");
INSERT INTO isn_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Hangi aguni ialwae niakole mung'wanso, lungikitalao Ulemi wang'wi Tunda waza pakupi nunyenye. ");
INSERT INTO isn_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Anga menda muisali ing'wi ahila kuwuisingiilya longoli kunzi numunzila mulunge. ");
INSERT INTO isn_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Ulukundi la kisali kanyu nuludamantie mumigulu itu kuulukununta kutalanyu, ingi mulingi ili kina ulewi wang'wi Tunda wahugeela. ");
INSERT INTO isn_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Numuie kina uluhuki nulaulamulwa luzetula lukamaliku ku sodoma kukali ikisali nikanso. ");
INSERT INTO isn_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Isatiko lako korazini, Isatiko lako Bethsaida ang'wi Imilimo nimikulu aitumiwe kitalako anga aizeitumiwe ku Tiro nuku sidoni, aziili tunu ung'wandyo aileke imilandu, aiatugale Imyenda amagunila ni mau kipaka. ");
INSERT INTO isn_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ingi gwa izizatula ikamatiku nangulu utuhiku nulaulamulwa rula tiro ni sidoni kukila unye. ");
INSERT INTO isn_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ue kapernaumu, usigile uzihumbulwa upike kilundo? Uzesimigwa pihi kujehanamu. ");
INSERT INTO isn_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Uyu numtegeeye unye, untegeeye unihitile nene, nuyu wihi nunihitile une, umuhitile uyu nuntumile. ");
INSERT INTO isn_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ao ni mupungati ikasuka nilumbi, akalunga ''Mukulu ka nia mintunga aina kukulya kudiila lina lako. ");
INSERT INTO isn_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Uyusu akaila ''azarumuine umulugu azukugwa kupuma kilunde anga ulupito. ");
INSERT INTO isn_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Goza numupee uhumi wakupambala inzoka ni nkuma, ningulu yihi nialugu, hangi kutile kintu kihi nikikumu alya. ");
INSERT INTO isn_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kuluko muleki kulowa kunsoko aili, kuna menda kuligwa, singa uu, ingi lumbi imina anyu nandikilwe kilunde. ");
INSERT INTO isn_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kumatungu yayoyayo akaloa nangulu kuvikolo ang'wa ng'welu akalunga nakulumbulya huewe, Tata mukulu naukulunde numihi kunsoko umapihile imakani aya kuakuantu nisiamanyisigwe, anga ia ngenya nianino, ingi uu Tata kunsoko auloeigwe mumcho ako. antu ni ahugu nawa niamahala nuku makunukula ");
INSERT INTO isn_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Maintu ihi mambigwe nu Tata wane, hangi kutile nulingile ungwana nyenye ingi utala, hangi kutile numumanyile utata ingi ung'wana, nuyu wihi nuilowa ung'wana kikunukula kung'wakwe. ");
INSERT INTO isn_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Akapilukila iamanyisigwa, akalunga kinkunku, akembetwa awa nimaona aya ninye nimaona. ");
INSERT INTO isn_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kumuila unyenye kina anyakidagu idu niatemi aialoilwe kuiona inkani nimiiona, shakaona nu kija ayo nimija singaakija. ");
INSERT INTO isn_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Goza akimika mumanyisi ung'wi nua unonelya nua kiyahudi, akawiugema uyesu akamuila nitume ntumi nihume kusala utemi nua kiguhe. ");
INSERT INTO isn_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Uyesu akamuila iliiye ule muunonelya nuiusoma? ");
INSERT INTO isn_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Akasusha akalunga, ''mulowe Itundo wako kuakonto ako ihi, nukungulu yako yihi, nimahala ako ihi, numunya kisali ako anga uewe nizawiloilwe. ");
INSERT INTO isn_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Uyesu akalunga, wasukiilya tai, itume uu ukikie. ");
INSERT INTO isn_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ingi umumanyisi akalowa iaelyeitaiung'wenso, akamuila uyesu, ite gwa umunyakiali ane nyanyu? ");
INSERT INTO isn_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu akasucha akalunga aukoli muntu au kusima kupuma kuyelusalemu kulongolaku yeriko akagwilamuantu niabi, ikamuhegela insao yakwe yihi hangi ikamukuwa pakupe insha. ");
INSERT INTO isn_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kua uniniau mudimi ing'wi auzile akazesima munjila nansa, naumuine akakiila kunziga. ");
INSERT INTO isn_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Uu hangi umulawi, naupikile pang'wanso akamuona akakila kungiza. ");
INSERT INTO isn_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kululo msamana ung'wi naukite umuhinzo, akakiila apo naukole umuntu nuanso, naumuine, akahung'wa kinyauwai. ");
INSERT INTO isn_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Aumuhugee akamutungilya inkomele yakwe akahunuila imakuta ni divai migulya akwe. akamunankilya migulya amutugo wakwe, akamutwala munyumba akila njila akamuailya. ");
INSERT INTO isn_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Iluhiku nailutyatie akahota mpia ibiihi hangi akamupa umukola nuyumba nia kupikila iakila nzila nukumuila muailye kihi mitite angavu suka nzekusukiilya. ");
INSERT INTO isn_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nuuli kuawa niatatu, usigile kina ai Munyakisali akwe, naugwie muabi? ");
INSERT INTO isn_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Umumanyisi akalunga, ingi uyunamuonee inyauwaikutalakwe, Uyesuakamuila iongola ende witume uu. ");
INSERT INTO isn_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Naiakole mumu ihinzo akiingela mukisali king'wi, musungu ung'wi lina lakwe Mrtha akamu singiilya kito lakwe ");
INSERT INTO isn_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39",". Autite umufuna naiwitanga Mariamu naiwikie pa migulu amu kulu nukutegeelya ulukanilakwe. ");
INSERT INTO isn_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ingi gwa umartha akipa milimo idu kunonelya indya akalongola kung'wa Yesu, nu kuhuga, mukulu, singaukee kina ung'waitu wandeka nitume ningwene ingi gwa muile anzailye. ");
INSERT INTO isn_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ingi umukulu akamusukulya akamuila, Martha, Martha, ukaga ni nkani idu. ");
INSERT INTO isn_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kululo gwa ingi kintu king'wi du nikatai Mariamu waholanya iko nikiza, nishakizehegigwa kupuma kitalakwe. ");
INSERT INTO isn_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ukatala Matungo Uyesu nakolompa, ung'wi wa amanyisigwa wakwe akamuila, mukulu, kumanyise nusesie kulumpa, anga uyohana nau amisilye iamanyisingwa akwe kulompa. ");
INSERT INTO isn_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Uyesu akaila nimukulompa, lungi, Tata, lina lako likuligwe, utemi wako uze. ");
INSERT INTO isn_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ukupe indya yitu nia mahiku ihi. ");
INSERT INTO isn_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ukulekele imalandu itu aka use nikia lakala nakugaziiye, uleke kuitwala muimageng'wa. ");
INSERT INTO isn_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Uyesu akaila, nyenyu kitalanyu nukite umuhumba muya nukumuhanga uutiku, nukumuila, muhumba miane mpe imikate itatu. ");
INSERT INTO isn_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kunsoko muhumba shuya wane wampikiila inoino kupuma muhinzo, nu ne nimugila indya nikumupa. ");
INSERT INTO isn_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nuyo nukale mrupumba akamuila, leka kunaja, umulango walugailwa palung'wi niana ane, nune nalala singa kuhuma kuuka nukuupa uewe indya. ");
INSERT INTO isn_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nunuie, kina atizeshukuuka indya umuhumba muya akwe, kunsoko akazulongolekile kumupitya tile niminyala, ukuuka akupe indya yidu kutula nuhilwa wako. ");
INSERT INTO isn_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nu ne kumuila, lompi, nunye mukupewa, penzi nunye mukulija, pinduli nunye mukuluguilwa. ");
INSERT INTO isn_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","kunsoko nuilompa wisingiilya, nuyu nuiduma wipata, pinduli nunye mukuluguilwa. ");
INSERT INTO isn_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Tata kii kung'wanyu, ung'waakwe agalompe insamaki ukumupa nzoka? ");
INSERT INTO isn_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ang'wi agalompe ije ukumpa nkumi? ");
INSERT INTO isn_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Klulo ang'wi unyenye nimiabi mumanyile kuapa iana nyu imasongeelyo nimaza, Ai g'wautata nyu nua nuakigulu ukuapa ung'waungwelu ao nimulo mpa? ");
INSERT INTO isn_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sunga Uyesu akatula mupatya umintunga, Uyu naukete umintunga ai kimume umintunga akahega kumuntu nuanso, umuntu nuanso akahuma kuligitya umitunda ukakuilwa nanguli. ");
INSERT INTO isn_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Niang'wi ikalunga, uyu ukuheja imintunga kua Beelzabul mukulu wa amintunga. ");
INSERT INTO isn_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Niang'we akamgema ikalowa alagiile ikilingasilyo nikakupuma kilunde. ");
INSERT INTO isn_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ingi uyesu akalinga imasigo akaaila, utemi wili nukutemanuka utula nuukia, ninyumba nikutemanuka ikugwa. ");
INSERT INTO isn_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ang'wi umubi ukutula utemanukile, utemi wakwe ukimaka ule? Kunsoko uenda lunga neenda heja imintunga kua Belzebuli. ");
INSERT INTO isn_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ang'wi unene neenda heja iamintunga kua Belzebuli, ai iane menda heja imitunga kukiila ntuni? Kunsoko iyi, nianso azizamtwala mulamulwa. ");
INSERT INTO isn_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kululo, angwi kuheja amintunga kukiila shala kang'wi Tunda, ingi gwa utemi ukumuhanga. ");
INSERT INTO isn_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Umunyangulu nukite ishigi angaamilile inyumba kwe, imaintu akwe akikie uza. ");
INSERT INTO isn_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kululo angingiilwe nu muntu numukiiye ingulu umunyangulu nuanso ukumuhegelya ishige yake, nukuhola insao yakwe yihi. ");
INSERT INTO isn_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Uyu nisha kipalung'wi nu nene, shamiane, nuyu nishawilingiila palung'wi nunene wisambailya. ");
INSERT INTO isn_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Umintunga numubi nukuhega kumuntu, wenda nikutili imaze kunsoko asupye. Agatule walimila, ukulunga, kusuka nazampumie. ");
INSERT INTO isn_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Anga asuke ahange inyumba apyagulwa hangi ikie iza. ");
INSERT INTO isn_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kululo wilongola kuaduma amintunga mupungati ao bi kukila nuanso, nukualeta ikie pang'wanso, u muntu nuanso witula mubi kukila nazawili ung'wandyo. ");
INSERT INTO isn_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Naukuligitya inkani izi, musungu ung'wi akahumbula ululi kukila ihi naiakoli pang'wanso akalunga, “Akembetwa inda naikutugile nimaele naumonkile.” ");
INSERT INTO isn_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Sunga akalunga, akembetwa ao neija ulukani lang'wi Tunda nukuluamba. ");
INSERT INTO isn_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Umilundo wa antu ukatula kongeeleka, u Yesu akandya kulunga, “Uwileli uwu ingi wileli wa ubi, ukuduma kilinga siilyo, kutile ikilingasiilyo nikikupegwa kukila ikiilingasiilyo ni kang'wa Yona. ");
INSERT INTO isn_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Anga u Yona naikilingasiilyo kuantu a Ninawi. Uu nungwana wang'wa Adamu ukutula kilingasiilyo kuwileli uwu. ");
INSERT INTO isn_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Umusungu wa Mutemi nuakutakama ukimika uluhiku nula ulamulwa niantu awileli uwu azizapegwa ulamulwa wao, ingi nuanso aupumie kumpelu nihi aze ategeelye uhugu wang'wa Solomoni, na paite ukoli numukulu kukila u Solomoni. ");
INSERT INTO isn_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Iantu a Ninawi akimika mulamulwa palung'wi niantu niawileli uwu uluhiku la ulamulwa azizaapa uulamulwa, kunsoko nianso aialekile imilandu nu Yona naukutanantya ulukani lang'wi Yunda, hangi goza pang'wanso ukoli numukulu kukila Yona. ");
INSERT INTO isn_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Kutile umuntu wihi, nuakilya ulumuli aluike mulungu ang'wi pihi akikapu, ingi wakilya nukuika migulya kunsoko akelyo, angawingila muntu wihi ahume kuona uwelu. ");
INSERT INTO isn_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Iliho lako lumuli la muili iliho lako angalilule iza umuili wako wihi ukutula nuwelu, iliho lako angalihule ibi umuili wako wihi ukutula kiti. ");
INSERT INTO isn_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kululo mihambe uwelu nuukole mitalanyu uleke kukilwa ikiti. ");
INSERT INTO isn_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kululo ang'wi umuili wako ukoli muwelu, hangi kutile ata nuunino nuukoli mukiti. Ingi gwa umuili wako ukutula anga ulumuli nulukupumya uwelu kitalanyu.” ");
INSERT INTO isn_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Naiwamala kuligitya, Farisayo akamana enda alye ndya kitalakwe, u Yesu akingila munyumba akatula palung'wi nienso. ");
INSERT INTO isn_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Imafarisayo ikakuilwa kunsoko shaukalae indya naikili kuletwa. ");
INSERT INTO isn_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","U Yesu akaila, “Unye Mafarisayo mendoja iseme kunzi, mukati anyu mizue insuula nimbi nuubi. ");
INSERT INTO isn_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Unye antu nimiagila uhugu uyu naumbile kunzi shanga au umbile ne numukati?” ");
INSERT INTO isn_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ape iahimbe aya namkati, ni nkani yihi ikutula nza kitalanyu. ");
INSERT INTO isn_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Kululo isatiko lanyu Mafarisayo, nsoko mipumya imasongeelyo aminanaa numuchicha ni nyenyi yihi niamugunda, kunu mulekile inkani ya tai nukumulowa Itunda, kuna shango mukuleka nimangiza. ");
INSERT INTO isn_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Isatiko lanyu Mafarisayo kunsoko milowa kikiie kumatuntu akuntongeela amatekeelo nukulamukigwa kua milamu iyi nikilya. ");
INSERT INTO isn_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Isatiko lanyu kunsoko mimpyani niibula ningila ilingasiilyo iantu niza azegenda migulya aibiila nianso singaazeaine.” ");
INSERT INTO isn_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mumanyisi ung'wi wa unonelya wa Kiyahudi akasusha akamuila, mumanyisi iki nukukiligitya kakutasha use. ");
INSERT INTO isn_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu akaila isatiko lanyu, unye aminyisi ankani, ingi mendaapa iantu imiligo nisinga ahumile kuminkenka, kunu unye shamaenda miamba ata nayala yanyu. ");
INSERT INTO isn_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Isatiko lanyu kunsoko mendazenga nukuika ilingasiilyo muibiila ya anyakidagu ao naiabulagilwe niesekulu anyu. ");
INSERT INTO isn_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kululo gwa unyenye mihangile nukigombya imilimo naiitumile isekulu anyu, kunsoko ikulukulu aiabulagile ianyakidagu, imo nimezenga ilingasiilyo muibiila yao. ");
INSERT INTO isn_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kunsoko iyo uhugu wang'wi Tunda uuliye, kuatuma ianyakidagu neituma milimo ane neenso muakaja nukuabulaga niang'wi. ");
INSERT INTO isn_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Uwileli uwu uziza liilwa ni sakami anyakidagu naiabulagile kupuma ung'wandyo nua unkumbigulu. ");
INSERT INTO isn_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kupuma usakami wang'wa Abeli nu Zakaria, naubulagilwe pakati wikumbikilo la ng'waung'welu. Uu, numuie uwileli uwu uzizaliilwa. ");
INSERT INTO isn_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Isatiko lanyu amanyisi ankani nia Kiyahudi kunsoko mahola ifungulo nia uhugu; unyenye shamendingila, kunu mukuagilya kingila ao niatakile kingila.” ");
INSERT INTO isn_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","U Yesu naiwahega pang'wanso, akilisa nkani ni Mafarisayo ikatula kumugilya nukikunguma nung'wenso kua nkani idu. ");
INSERT INTO isn_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Akaze mugema kumutungila ahume kupantika lukani kitalakwe. ");
INSERT INTO isn_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kumatungo yayo, maelfu edu naantu aeilingiie palung'wi, ikanza kitilangila, akanza kutambula niamanyisigwa akwe niakwanza, “Huguki nigae ya Mafarisayo kunsoko eze unafiki.” ");
INSERT INTO isn_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","3","Naikutula kutile anga unkunku nuipihile kunsoko shangaikunukulwa, wala lukani nulipihile kunsoko shangalukigeela. Na lehi nemulitambue mukiti, lukigwa muwelu. Na mehi namihinaatambuwe mukate mukutwe ntongeela anyu niyamukati naoilugaiwe akatanantigwa migulya muukuta wa nyumba. ");
INSERT INTO isn_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Kumuila ahumba eane, lekikogopi awa niuulaga umwiili na agila anga kintu nikingiza nikakituma. ");
INSERT INTO isn_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kuite kumulingasa nuakumwogopa. Mogopi uyo kunsoko kukila kina wabulaga, ukite uhumi wakuguma kujehanamu. Ee kumuila unye, mwogopi nuanso. ");
INSERT INTO isn_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ite shomoro aatano shangaakualigwa kusarafu ibiile? Hata uuga kutile hata nung'we ao shangaukusahaulika ntoongela ang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kuite mulinge kina, imasingi amatwe anyu aaigwe. Lekikopi. Unye meathamani nkulu kukila shomoro edu. ");
INSERT INTO isn_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Kumuila, wihi nukungomba unene ntongeela aantu, Ung'wana wang'wa Adamu ukumugomba ntongeela amalaeka ang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Lakini wihe nuekanihita ntongela aantu nung'wenso kumuhita ntongeela amalaeka ang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Wehi nuekatambula ulukani nulube migulya ang'wana wang'wa Adamu, ukusamilwa, lakini wehi wikamumela ung'waung'welu, singaukusamilwa. ");
INSERT INTO isn_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nuekamutala ntongeela aakulu amatekeelo, akulu, niakite uhumi, lekikuogopi migulya kunsoko akuligitya nukitetea ntuni nilakutambula, ");
INSERT INTO isn_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","kunsoko ung'waung'welu ukumumanyisa kutambula kumatungo nanso.” ");
INSERT INTO isn_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Muntu ung'we mumo mumilundo akamuila, “Mwalimu muile umunyandogu ane wangawile isehemu aurithi wane.” ");
INSERT INTO isn_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","U Yesu akamuila, nyenyu naumbikile une kutula nimulamuli nukumuhumbilya ntongeela anyu? ");
INSERT INTO isn_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kuite akaaila, huguki nekila nsula, kunsoko uupanga wantu shangaukole munsao nimaintu akwe nukite.” ");
INSERT INTO isn_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","U Yesu akaaila kumpyani, wikalunga, umugunda wamuntu ung'wi naemugole ailitugile ikulu, ");
INSERT INTO isn_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","wekikolya munkolo akwe, wikalunga, kutenda ule nsokotile anga sehemu akueka imazao ane? ");
INSERT INTO isn_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Akatambula, kutenda ite. Kuunanga imasalanka ane nimanino nukuzepya ile nikulo, nukumaika imazao ane ehi nimaintu nimangiza. ");
INSERT INTO isn_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kumeila inkolo ane, “Nkolo, wiikilye akiba intu idu kumyaka edu. Supya, ulye, ung'we nukusupya.” ");
INSERT INTO isn_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Lakini Itunda akamuila, ue muntu numugila mahala, utiku wa lelo ametakile inkolo kupuma kitalako, nimaintu ehi numazipye ukumulekela nyenyu? ");
INSERT INTO isn_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Uu ikutula kukila muntu nuiikiye insao kizepeelya kunsoko ang'wa Mukulu. ");
INSERT INTO isn_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","U Yesu akaaila iamanyisigwa akwe, kuite kumuela mulekekuhofu migulya amaisha anyu_mukulya ntuni numigulya ameele anyu_mukutugala ntuni. ");
INSERT INTO isn_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kunsoko imaisha kukela andya, numwiile kukila ang'wenda. ");
INSERT INTO isn_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Gozi inyunyi ya migulya, shangailema hange shangaivuna. Agila anga nyumba wala isalanka nilakukiila, lakini Itunda wialesa. Unye shanga miaza kukila inyonyi! ");
INSERT INTO isn_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nuule kitalanyu nuhumile kisumbula nukongelya dhiraa ing'we muwikale wakwe. ");
INSERT INTO isn_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Angaitule shangamuwezilye kituma nikanso ikentu nikinino nekidabu kuneke usumbukile nimangiza? ");
INSERT INTO isn_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Gozi imaua-nizepela. Shangituma anga milemo wala shangipalinga. Lakini kumuila, ata u Sulemani muutukufu wakwe wehi shangaaukunikiwe anga yaite. ");
INSERT INTO isn_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kuite Itunda wimakunikila iza imatutu imugunda, kunsoko lelo akole, nu mudau wimaguma mumoto. Ite singa tai ne ukumukunikila unyenye? ");
INSERT INTO isn_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Lekikusumbukili namigulya mukulya ntuni ang'wi mukung'wa ntuni, muleke kutula nuwoa. ");
INSERT INTO isn_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kunsoko imahe ihe na muunkumbigulu agiila emakani ao. Nutata anyu uine mutakile yayo. ");
INSERT INTO isn_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kuite dumi uutemi wakwe hanza, aya nimangiza mukongeeligwa, ");
INSERT INTO isn_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","lekikogopi, unye niakehu, kunsoko utata anyu uloilwe kumupa unye uutemi. ");
INSERT INTO isn_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ngulyi insao yanyu muape iatuka, mutule nimefuko nishangiuilwa_itulyo lakilunde nishangalihila, kianza nikanso eii shangaehumbila wala nondo shanga akuweza kubepya. ");
INSERT INTO isn_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kuite nilikole itulyo lako, hapo ninkolo ako ikutulaikole. ");
INSERT INTO isn_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Iang'wenda anyu nialepu atule atungilwe kumunkanda, ni ntala yanyu ihakikishigwe kina yendelee kakila, ");
INSERT INTO isn_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mutule anga aantu, niamugozee u Mukulu kupuma mushere winga. Kuite anga waze wakoe ihodi, ahumile kumuluguela mulango kwa haraka. ");
INSERT INTO isn_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Akembetilwe iitumi, neanso u Mukulu nukuaahanga akole miho. Etai ukuatunga ang'wenda alepu neminkanda kuite ukuikalesha pihe pandya, neite ukuahudumila. ");
INSERT INTO isn_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kuite u Mukulu angawaze kunkua akabiile nadolia ang'wi utiku ung'wi nkua akatatu na dolia, nukuahanga, akole uza, ikutula tazu kung'wao eitumi. ");
INSERT INTO isn_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kukila ayo, mulinge ile, kina u mukulu ung'wenso nuanyumba angize uine imatungo nuzie umii, singauzegomba enyumba akwe kuunangwa. ");
INSERT INTO isn_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mutule mukole iza kunsoko shangamuine imatungo kee ung'wa Adamu nukusuka. ");
INSERT INTO isn_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","U Petelo akalunga, “Mukulu, ukoela usese kumpyani ang'wi ukuila kila umuntu? ");
INSERT INTO isn_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mukulu wekaaila nyenyu umitumi numuhueli ang'wi nukete eheshima kuite u mukulu wakwe ukumuika migulya aitumi neangiza, kuite agawile indya yao kumatungo nazipie? ");
INSERT INTO isn_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Uloeigwe umitumi nuanso, kunsoko u mukulu wakwe ukumuhanga ukituma aya naulageigwe. ");
INSERT INTO isn_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ite kumuila unye kunsoko ukumuika migulya ansao yakwe yehi. ");
INSERT INTO isn_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kunsoko umitumi nuanso ukulunga mumoyo wakwe, “mukulu wane ukushelewa kusuka, kuite akakaakua zitumi akigoha nawa niasungu, kuite akanza kulya, kung'wa nukugala. ");
INSERT INTO isn_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","U mukulu wakwe nuanso umitumi uzile kuluhiku nisingautegemee nematungo nishangaumaine, nung'wanso ukumutema ipande ipande nukuaika isehemu palung'wi nishangaahuie. ");
INSERT INTO isn_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Umitumi, nuzile ulowa wang'wa Mukulu wakwe, nung'wenso shanga aiwihambile endogoilyo shangaukituma sawa sawa nuulowa wakwe, ukukuwa iboko iidu. ");
INSERT INTO isn_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Lakini umitumi nushangaune uloowa wang'wa Mukulu wakwe, lakini ukituma naloeye adhabu, ukokuwa iboko ikehu. Kunsoko aupewe yeedu, yeedu kupuma kung'wakwe, ung'wenso nishangaauhuiwe kuintu niyedu, kitalakwe ikudaigwa yedu kukila. ");
INSERT INTO isn_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nezile kakilya umoto muunkumbigulu, na nkete insula utule wakeigwe. ");
INSERT INTO isn_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Lakini nkete ubatizo nuanso nuakubadisigwa, nankite uukia mpaka nuukukamilika! ");
INSERT INTO isn_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ite musegile aenizile kuleta uhueline muunkumbigulu? Kutile, kumuila, badala akwe ndetile mugawanyiko. ");
INSERT INTO isn_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kupuma itungile nukendelea ikutula aantu aatano munymba ing'wi agawanyikile, awa niatatu akatula kinyume nawa niabiile, nawaniabiile akutula kinyume nawaniatatu. ");
INSERT INTO isn_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Akutawanyika, utata ukutula kinyume niana, niana akutula kenyume nutata ao, umama ukutulakinyume numunanso akwe, numunanso ukutula kenyume numama akwe, umama mukwe ukutula kenyume numukwingwakwe, numukwingwakw ukutula kenyume numamamukwe wakwe. ");
INSERT INTO isn_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","U Yesu wikatula aela imakutano hange, “Ite angamuone imalunde akupumila kukilya, melunga imatungo ambula aapika; uu yetula. ");
INSERT INTO isn_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nung'wega wakuhuma anga ukunke, mekalunga, ikutula ijoto itaki, uu ikatula. ");
INSERT INTO isn_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Unye ateele, mukuweza kutafsiri wigeleki wihe ni gulu lakini itula ule shangamugemile kutafsiri imatungo nakole? ");
INSERT INTO isn_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Kuneke kila ung'we anyu kupambanula ileni lekole iza kung'wakwe kituma kumatungo nukete inafasi akituma nanso. ");
INSERT INTO isn_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kundogoilyo angawende numube wako ntongeela amulamuli, mugeme kupatana numube wako muze mukole munzila aleke kuutwala kumulamuli, numulamuli wakutwal3 kumukulu, numukulu wakutwale mukitungo. ");
INSERT INTO isn_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kuila shanga ukupuma kung'wanso mpaka ukulipa esenti aamwisho. ");
INSERT INTO isn_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kumatungo yayoyayo, aakole baadhi aantu naamuie migulya Aagalilaya kuite upilato auabulagile nukuahalinkanya usakami ao nimasongilyo oa. ");
INSERT INTO isn_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","U Yesu akaasukilya akaaila, “Ite mulungile Eagalilaya awa akete milandu kukila Agalilaya neangiza ehi ee indogoelyo apatilwe naya nemabe? ");
INSERT INTO isn_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kutile, kumuila, lakini angamuhite kutubu, nunyenye mukulimiila uu, uu, ");
INSERT INTO isn_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ite awa aantu nikumi namunana ku Siloamu nsoko umunana nauugwie nukuabulaga, musegile neanso aeanyamilandu kukila aantu niangiza ku Yerusalemu? ");
INSERT INTO isn_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kutile unene, kutambula lakini angamuhite kutubu, unye mehinunyenye mukulimeela. ");
INSERT INTO isn_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","U Yesu wakaaila kumpyani eye, “Muntu ung'wi aukite mutini utemewe mukate amugunda wakwe aewendile kuduma inkali migulya lakini akaulya. ");
INSERT INTO isn_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Akamuila umutunzi wakianza, “Goza, kumyaka itatu nezile kugema kuduma inkali yakwe mumutini uwu lakini nikaulya. Uuteme. Kunsoko ukuleta uube mihe? ");
INSERT INTO isn_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Umutunzi wakianza wikaasukilya nukuaila; uleki ung'waka uwuite nuuginge nukuekila embolea migulya akwe. ");
INSERT INTO isn_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Anga watuga inkali yakwe ung'waka nuuzile, iza, lakini angawahita kutuga uuteme!” ");
INSERT INTO isn_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Itungile u Yesu akatula amanyisa mujawapo wamatekeelo matungo a Sabato. ");
INSERT INTO isn_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Goza, aukole musungu ung'we nsoko myaka kumi na munana aukete nkolo mbee auneketu. Nung'wenso aewipendile aimigila anga uhumi lukulu nuwakimika. ");
INSERT INTO isn_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","U Yesu naumuine, wakamitanga, akamuila, “Musungu ukole huru kupuma muudhaifu wako.” ");
INSERT INTO isn_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Akaika imekono akwe migulya akwe, kuite umwiite wake ukagoloka akamukulya Itunda. ");
INSERT INTO isn_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Uugwa u mukulu nua itekeelo ai utakile kunsoko u Yesu umugunile muntu luhiku nula kusupya, akasukiilya, aka atambuila i anyianza, “Mahiku mutandatu nazipie kituma u mulimo, uugwa pembyi, muagune mu mahiku nanso, hangi shanga mu luhiku nula Kusupya.” ");
INSERT INTO isn_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Umukulu wikamusukilya nukumuila, “Uteele! Kuite kina ung'we anyu witung'wila endogwe akwe ang'wi ng'ombe kupuma mitando nukuatongela kuatwala kung'wa uluhiku lakukulya? ");
INSERT INTO isn_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kuite umunanso wang'wa Abrahamu, nsoko u Shetani umutungile kumyaka kumi na munana. Ite shangaaizepiene ikitungo kakwe kileke kutunguelwa luhiku lakukulya?” ");
INSERT INTO isn_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nautuile kutambula imakani nanso, awa ehi naeakumugilya akahung'wa minyala, imakutano ehi neangiza ekalumbilya kunsoko amakani namakula naiwitumile. ");
INSERT INTO isn_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","U Yesu wikatambula, “Utemi wang'wi Tunda wipyani nentuni, nakuwipyana nentuni? ");
INSERT INTO isn_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Anga embeu amuharadali naumihoile umuntu ung'wi nukumitemela mumugonda wakwe, ikazepa ekatula mute ukulu, ninyunyi yakilunde yekazenga itie yao mumatambe akwe. ");
INSERT INTO isn_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ite akatambula, “Nuipyanye nintuni utemi wang'wi Tunda? ");
INSERT INTO isn_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Inge ihanganga iigae umusungu nuehola wekahalinkanya muipimo itatu niyautu yekaumuka.” ");
INSERT INTO isn_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","U Yesu augendee kila ikesale neisale munzila naulongoe ku Yerusalemu nukuamanyisa. ");
INSERT INTO isn_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Muntu ung'wi wikakolya, “Mukulu, antu akehu dune niakuokolewa?” Ite wakaaila. ");
INSERT INTO isn_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ingimelye kingila kukiila mulango nuupinye kunsoko eedu akugema kingiila shangaakuweza. ");
INSERT INTO isn_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kuite anga umukulu wa nyumba anga wingile nukufunga umulango, ite mukimeka kunzi nukukua ehodi pamulango nukiitanga, mukulu, mukulu, kuluguile nung'wenso ukusukilya nukuaila, shanganumumanyile unye kunamupumile.” ");
INSERT INTO isn_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ite mukulunga, Aekulie nukungwa ntongeela ako nuewe aukumanyisilye muisale yitu.” ");
INSERT INTO isn_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Lakini nuanso ukuasukilya, nukuaila, shanganumumanyile kumupumiie, hegi pitalane, unye nimituma imelandu! ");
INSERT INTO isn_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ikutula kelelo nukukelya emino matungo nimekaaona u Abrahamu, Isaka, Yakobo neitumii ehi muutemi wang'wi Tunda lakini inye unyenye mugumilwe kunzi. ");
INSERT INTO isn_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Akapika kupuma kukilya, kung'weli, kutakama, nukukuma, nukusupya. Pameza aandya yampende muutemi wang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nengile nuamwisho ukutula wang'wandyo nuyu nuang'wandyo ukutula wa mwisho” ");
INSERT INTO isn_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Matungo makupe baadaye, ang'wi a mafarisayo aazile nukuaila, “Longola nahega apaite kunsoko u Herode utakile kuulaga. ");
INSERT INTO isn_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","U Yesu akatambula, “Longoli mumuile umbweha, goza kuazunsa aapepo nukituma kukamya ilelo numudau, nuluhiku lakatatu kutimilya ilengo lane. ");
INSERT INTO isn_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kuhali ehi nanso, inge muhimu kunsoko ane kendelea eleleye, numudau, nuluhiku nulutyatie, kunsoko shangaigombigwe kumubulaga umitumi kule ni Yerusalemu. ");
INSERT INTO isn_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yerusalemu, Yerusalemu, nyenyu nukuabulaga eitumi nukuakua imagwe awa naatumilwe kitalanyu. Kanga naetakile kumilingila eana anyu anga inkuku nilingila eana akwe pihe ambaa yakwe, lakini shangamikalegomba ile. ");
INSERT INTO isn_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Goza, inyumba ako alekwa. Nunene kumuila, shangamuhumile kuona nemekatambula ubarikiwe uyu nuzile kulina lang'wa Mukulu. ");
INSERT INTO isn_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Aeipumie luhiku lakumukulya, naulongoe munyumba ang'wi ao nuatongeli a Mafarisayo kulya mukate, neenso akumugoza kwa pakupe. ");
INSERT INTO isn_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Goza, pantongelakwe aukole muntu nuanso aukagigwa nuuimbwa. ");
INSERT INTO isn_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","U Yesu wakaakolya eamanyi kupuma milago la Ayahudi ne Mafarisayo, “Ite izane kumukomya umuntu uluhiku lakukulya, anga singauu?” ");
INSERT INTO isn_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Lakini nianso akilagilye ihetwe, kuite u Yesu wakamuamba, wekamukomya wikamulekela alongole yakwe. ");
INSERT INTO isn_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nung'wenso wikamuila, “Nyenyi apaite nukite ung'wana ang'wi ng'ombe wagwila muluze luhiku la kukulya shanga ukumuluta kunzi wapume?” ");
INSERT INTO isn_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nianso aeagila anga uhumi wakupumya ulukani kunkani niyanso. ");
INSERT INTO isn_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Imatungo u Yesu nauagundue naile naalekilwe kina asagae intu niyaheshima, akaaila, kupyani akaaila. ");
INSERT INTO isn_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Imatungo nimalekilwe numuntu kuwinga, ukekikie munafasi naheshima, kunsoko iwezekanile walikilwe muntu mungiza nukite heshima kukila uewe. ");
INSERT INTO isn_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Imatungo umuntu nualekilwe unye nimeabiile angawapike, ukuela uewe, “muhegele uyu enafasi ako” kuite kwa minyala ukonza kuhega nukikie kunyuma. ");
INSERT INTO isn_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Lakini uewe angawalekwe, longola wikie kumwisho ite imatungo angawaza nukualekile, uhumile kuuila uewe, muhumba miane, longola kuntongela kukila.” Kuite ukutula uheshimiwe ntongela aehi neikie palung'wi nuewe pameza. ");
INSERT INTO isn_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kundogoilyo uyu nuikulya wisimigwa, nuyu nuisimya wikuligwa. ");
INSERT INTO isn_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","U Yesu akamuila umuntu naumalekile, “Nukupumya indya ya mung'wi ang'wi yampende, lakukualeka eahumba eako ang'wi anya ndugo ako ang'wi antu ang'wi anyakisale ako neatajili, ite kunsoko neaenso akekualika uewe upate ilipo. ");
INSERT INTO isn_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kuleka ite, nukuanya isherehe, aaleke eamasikini, ealema, akewete, niapoku, ");
INSERT INTO isn_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","nuewe ukukembetwa, kunsoko shangaakulipa. Kundogoelyo ukulipwa muwioki watai.” ");
INSERT INTO isn_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Imatungo ung'wi ao aewikie mumeza palung'wi nu Yesu naewigule aya, nung'wenso wikaaela, “Ukembetilwe nuanso nuekulya umukute muutemi wang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Lakini u Yesu wikaaila, “Muntu ung'we auzepilye sherehe nkulu, akaitanga antu eedu.” ");
INSERT INTO isn_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Matungo isherehe naekole tayari, aumutumike umitumi akwe aaele awa naalekilwe, “Pembyi mihi kunsoko iintu yehi ikole tayali. ");
INSERT INTO isn_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ehi, ekatulalompa radhi. Nuang'wandyo akamuila umitumi, ngoile mugunda, lazima nende nulegoze. Itunu unsamile. ");
INSERT INTO isn_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Numuya wikalunga, Nguile majoki ataano na ng'ombe, nunene niinzu kuagema, itunu unkoelwe. ");
INSERT INTO isn_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nu muntu mungiza wekalunga, “Ntenile musungu, kuite shanga nzile.” ");
INSERT INTO isn_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Umitumi akasuka akamuila umukulu wakwe emakani nanso. Umukola nyumba wikataka akamuila umitumi wakwe, “Longokaya muisale numukona akisale ualete hapa iamasikini, niakelema, niapoku nawa nialemilwe.” ");
INSERT INTO isn_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Umitumi wikalunga, mkulu aya nazundagiye ehi namituma, ganitungile ga enafasi kele ekole.” ");
INSERT INTO isn_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Mukulu wikamuila umitumi, longola munzila nenkulu uahimize eantu ingiile, ite enyumba ne izule. ");
INSERT INTO isn_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kundogoelyo kumuila, kuite awa nialekilwe nung'wandyo shangaukuonza esherehe ane. ");
INSERT INTO isn_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ite umati ukulu aealongoe palung'wi nung'wenso, nung'wenso wikapiluka, wikaaila, ");
INSERT INTO isn_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Angize muntu wizile kitalane nung'wenso shangaumubipiwe utata akwe, musungu wakwe, anaaakwe, anyandugu akwe, agoha nawa niasungu ee, ga nuwikale wakwe ga shanga ukutula mumanyisigwa wane. ");
INSERT INTO isn_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Umuntu nushanga ukuhola umusalaba wakwe waze kunyuma ane shanga uhumile kutula mumanyisigwa wane. ");
INSERT INTO isn_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Kundogoelyo nyenyu ung'wi anyu, nuhumilwe insula akuzenga umunola shanga ukikie hanza wakadilie engalama kumahesabu kina ukite eke nutakile wahu kukamisha nelanso? ");
INSERT INTO isn_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kuite, baada akuika umusingi nukuleng'wa kumala, ehi naineakanza kumugema. ");
INSERT INTO isn_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Akutambula umuntu uyu aewandilye kuzenga, wekatula mugila anga ngulu akumailya.” ");
INSERT INTO isn_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ite mutemike, nutakile kenda kikua nuutemi nuungiza kumbita, shanga uhumile kikie hanza pihe nukuhola imasigo angize uhumile, palung'wi ni antu elfu ikumi kikua nuutemi nuungiza nuukiza migulya akwe neantu elfu ishilini? ");
INSERT INTO isn_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kang'wi shangauu, matungo ijeshi nilaangiza kile lekole kule, wetuma momboi kutaka emashariti aamani. ");
INSERT INTO isn_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kuite gwa, wehi ung'wi ao neshanga ukuleka ehi nanso nukete, shanga uhumile kutula mumanyisigwa ane. ");
INSERT INTO isn_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Umunyu uza, lakini anga umunyu angaulimilye lauha akwe, ikutula ule utule munyu hange? ");
INSERT INTO isn_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ngila anga matumizi muudogo hata mumbolea uyu nakite iakutwe ahija nuije.” ");
INSERT INTO isn_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Awa neehangulya uushulu wehi nawa niangiza nianyamilandu aazile kung'wa Yesu kumutegeelya ");
INSERT INTO isn_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","awa neandeka ikamulongela ikalunga “Umuntu uyu weakalibisha enyamilandu hangi welya neenso.” ");
INSERT INTO isn_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","U Yesu wikatambula mpyani eye kung'wao, nukulunga ");
INSERT INTO isn_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Nyenyu kitanyu, angeze ukete nkolo mia moja angawalimigwe neng'wi ao, shanga ukualeka awa netisini na tisa, alongole kumeduma eye nelimie wameone? ");
INSERT INTO isn_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nung'wenso anga wamelije wemekenka mumaega akwe nukiloelya. ");
INSERT INTO isn_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Anga wapike munyumba, wiitanga eahumba auyanianyakisale akwe nukuaila iloelyi palung'wi nune kunsoko namepata enkolo ane nazelimie. ");
INSERT INTO isn_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kumuila uu, uu, ikutula wiloelyo ukulu kilunde kunso umunyamilandu ung'wi nutubile. ");
INSERT INTO isn_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ang'wi ukole musunguke nukete sarafu ikumi niyahela, anga walimiligwe nesarafu eng'we, shanga ukakilane ntala nukupyagula munyumba nukumiduma kwangulu mpaka wamelije? ");
INSERT INTO isn_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Angawamione weitanga eahumba ekwe neanyakisale akwe nukuaila iloelyi palung'wi nunene kunsoko namilija hangi esarafu ane eye naelimiie. ");
INSERT INTO isn_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kuite kumuila, ukole wiloelyi ntongeela amalaika ang'wi Tunda, kunsoko amunyamilandu ung'wi nukutubu.” ");
INSERT INTO isn_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Nu Yesu akaaila, muntu ung'wi aukete ana abiile. ");
INSERT INTO isn_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Uyu numunino wikamuila tatakwe, Tata mpe une isalo lane nilengwie kusala. Ite wikaagawila insao yakwe, kati ao. ");
INSERT INTO isn_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nsiku singa yedu uyu numunino wekilingila ehi naukete akalongola kesale kakule, nukung'wenso wekasapatilya impia yakwe nukuguli maintu nesingutakile, nukusapatilya impia yakwe kwa usambo. ");
INSERT INTO isn_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nung'wenso naukondilye kitumila ehi enzala nkulu ekingila mihe nanso, nung'wenso akatula lompa. ");
INSERT INTO isn_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Akalongola ung'wenso nukisalisa nukutula ung'wiao mihe nanso, nung'wenso wekamutala kumugunda wakwe kulesa ingulue. ");
INSERT INTO isn_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Wikatula ukete nsula akilesa emaganda naeikulya ingulue, kunsoko aetile anga muntu naumupee kintu nekakulya. ");
INSERT INTO isn_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Sunga uyu ung'wana naukimbule munkolo akwe, wikalunga atung'wa anga neang'wa tatane akete indya yedu ikondile unene nkole apa, kusha nanzala? ");
INSERT INTO isn_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kulutya nongole kung'wa tatane, nekina, “Tata natumula migulya kilunde nukuntongeela amiho ako. ");
INSERT INTO isn_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Shainonee kitangwa neng'wako hange, ntende anga ning'wi wao watugwa ako.” ");
INSERT INTO isn_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Uu wekahega wikalongola kung'wa tata akwe. Aekele ukole kule utata akwe wikamuonela ukia wikamumankila nukumukumbasela nukumulungila. ");
INSERT INTO isn_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ung'wana nuanso wekamuila, “tata natumula migulya kilunde nukuntongela amiho ako singainonee nitangwe ning'wako.” ");
INSERT INTO isn_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Utata akwe wikaaela atugwa akwe “kayi leti ung'wenda uyo numuza, mukumbi mumutugale ipete kushala niilatu kumegulu. ");
INSERT INTO isn_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Hange muleti ung'wang'ombe uyu numugenu mumusinze kulye kiloelye. ");
INSERT INTO isn_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kunsoko ung'wane waioka ukole mupanga. Aulimie nung'wenso wigela ikandya kilumbilya. ");
INSERT INTO isn_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ingi ung'wana numukulu aukole kumugunda naupembilye wikahumbela pito wikija nduli ya nyemboneakiginsa. ");
INSERT INTO isn_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Wikitanga mutugwa ung'wi wikamukolya imakani aya endogoelyo ntuni? ");
INSERT INTO isn_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Umutugwa wikamuela umunino ako waza nutata ako wamusinzila ung'wang'ombe numuginu kunsoko wasuka mupanga.” ");
INSERT INTO isn_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ung'wana numukulu wikabepelwa wikahita kingila munyumba nutataakwe wikapuma kunzi kumupepelya. ");
INSERT INTO isn_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Sunga wikasusha kung'wa tatakwe nukulunga, “Goza unene nukitumie myaka edu, hange nkele ntumuile ilago lako, kuite ukele kumpa ung'wambuli nihume kiloelya neahumba eane. ");
INSERT INTO isn_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kuite nazuzile ung'wako uyu naewiginseye insao yako yehi palung'wi neasambo wamusenzila ung'ombe uyu numugenu. ");
INSERT INTO isn_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Utata wikamuila, “Ng'waane uewe ukole palung'wi nunene mahiku ehi hange ehi nenkete une ako. ");
INSERT INTO isn_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Inge aaukole iza kitaitu kitume sherehe nukiloelya, umulunako aewakule, nitungo ile, ukole mupanga, aewalimie wigela. ");
INSERT INTO isn_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","U Yesu akaaila hange eamanyisigwa akwe, “Aukole muntu ung'wi mgole aukekete, eandiki, na auewe kina umuandiki nuanso ukusapatilya insao yakwe. ");
INSERT INTO isn_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kuite umugole akamiitanga, akamuila, ntuni ekeite nekija kitalako? Pumya ualya wauandiki wako, kunsoko shangaukutu umuandiki hange. ");
INSERT INTO isn_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Nuanso umuandiki wikatambula munkolo akwe, ntende ule indogoilyo umukulu wane wakanihegelya uwitumi wane nuaundeki? Numugila anga nguluyakulema nukulima kuona minyala. ");
INSERT INTO isn_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mine nekituma kuite anganahegigwa muitumi wane nuauandeki eantu ansingilye munyumba yao. ");
INSERT INTO isn_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Mukuili wikaitanga awa niadaigwe numukulu wakwe, kela ung'wi aa akamuila nuakwanza, udaigwe keasike numukulu wane? ");
INSERT INTO isn_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Wekalunga ipimo mia moja niyamakuta wikamuila hola ehati ako ikie halaka andike amusini! ");
INSERT INTO isn_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Wikamuila numuya nuewe udaigwe kiasike? Wikalunga ipimo mia moja niyautu wa ngano! Wikamuila hola ihati ako andike themanini. ");
INSERT INTO isn_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Umukulu nuanso wikamulumbilya umuandiki dhalimu kunsoko naumutende kuelewa. Kuite ina aukumbigulu uwu akete uelewe wedu ituma kuhugu neantu nkeka ao kulila neele eana neawelu. ");
INSERT INTO isn_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nunene kumuila mitendele kehumba shuya kunsao ya ubee nsoko anga ahita kigela amusingilye mulikalo lukale. ");
INSERT INTO isn_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Uyu numuhuili kueke nekinino kukila eze muhuili nukueke nekekolo ga nuyu numube kueke nekenino ezemubee nukueke nekekuluga. ");
INSERT INTO isn_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ang'wi unyenye shangaaemiahueli kunsao naube nyenyu nukumuhuila munsao natai? ");
INSERT INTO isn_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Hangi ang'wi shaemiahueli kitumila ensao amuntu numugiza nyenyu nuekamupa unyenye nanyu? ");
INSERT INTO isn_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kutile umitumi nuhumile kuitumila eakulu abeele kundogoelyo ukumubepelwa ung'wi nukumulowa numungiza, ang'wi ukuambikana nuyu kumumela numungiza. Shamuhumile kumitumela Itunda ninsao.” ");
INSERT INTO isn_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Inge i Mafarisayo naeaeze aloilwe impia aiigulye nanso ehi ekamumela. ");
INSERT INTO isn_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Hange wikaaela, “Unye nyenye nemikulya kutai ntongeela aantu, kuite Itunda uilengile inkolo yanyu. Kunso nelekuigwe kuantu iziibe ndongela ang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ilago nianyakedagu aelekole kupuma kung'wa Yohana nauzile. Kupuma imatungo yayo, impola ninziza niyautemi wang'wi Tunda yetanantigwa, hange kila umuntu wegema kiingelya kungulu. ");
INSERT INTO isn_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kuite itotu ilunde nihe kuhegigwa kukila atauandeki nuung'wi nuilago kuula. ");
INSERT INTO isn_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Uyu nukumuleka umusungu wakwe nukutina musungu mungiza ugooye, nuyu nukumutina uyu nulekilwe numugoha nung'wenso ugooye. ");
INSERT INTO isn_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Aukole muntu ung'wi mugole aewitugala ang'wenda alagi azambalao nekitani nikeza hange aeezoloilo kila uluhiku kuugole wakwe nuukulu. ");
INSERT INTO isn_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Hange numuhimbe ung'wi lina lakwe Lazaro aewiikwa pawingiilo wakwe, hange aukete nkomele. ");
INSERT INTO isn_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nung'we aukete nsula akikuta maminyangulwa nagwie mumeza amugole nuanso ata imbwa yakiza nukulampa inkomele yakwe. ");
INSERT INTO isn_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Yekatula umuhimbe nuanso nuekasha wikaholwa numalaeka sunga mukikua kang'wa Ibrahimu. Numugole nuanso wekasha wikaekwa. ");
INSERT INTO isn_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nukung'wanso kuulungu naukole mulwago wikahumbu imiho akwe wekamuona u Ibrahimu kukule nu Lazaro mukikua kakwe. ");
INSERT INTO isn_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Wikalela nukulunga, Tata Ibrahimu, mbuisele umutume u Lazaro wine insonge nashala kakwe mumaze, alubuludishe ululeme lane. Kunsoko kagigwa mumoto uwu. ");
INSERT INTO isn_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Kuite u Ibrahimu wikalunga, “Ng'wanane kembuka kina mulikalo lako ausengeye imakani ako nemaza, nu Lazaro uu aupatile nemabe. Inge itungo ile ukole papa ukiloelya nuewe ukuaaligwa. ");
INSERT INTO isn_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Hange kukila nanso leekilwe ikombo ikulu hange ilundu kitaitu, nsoko awa nialoilwe kuputa kunu nukenda kitalanyu aleng'we hange eantu nianyu aleke kuputa keza kitaitu.” ");
INSERT INTO isn_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Umugole nuanso wikalunga, “Kuulompa tata Ibrahimu, kina umutume mito lang'wa tata ane! ");
INSERT INTO isn_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Kunsoko nkete aluna ane aatano wahugule, kuwoa kina neensoga nienso azile papa palwago lulu. ");
INSERT INTO isn_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Kuite u Ibrahimu akalunga, “Akete i Musa neanyakidagu. Aleke aategelye wawo. ");
INSERT INTO isn_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Umugole nuanso wikalunga, aa tata Ibrahimu, kuite angawaile umuntu nupile kuashi akuungama. ");
INSERT INTO isn_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Kuite u Ibrahimu wikamuila, “Angaaleke kuategelya u Musa nianyakidagu shanga akumija ataumuntu nuiukile kuashi. ");
INSERT INTO isn_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","U Yesu wikaaila iamanyisigwa akwe, “Imakani neletekelya eantu kituma imilandu azepumila. Lakini isateko lakwe umuntu nueletekelya! ");
INSERT INTO isn_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ikutula bahu kina umuntu nuanso atungeligwe igwe nilito nelakusela munkingo nukugong'wa mubahali, kukila kumituma ung'wi waawa nianino itume emelandu. ");
INSERT INTO isn_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ilindi. Ang'wi umunyandugu ako wakukosela muonye, nung'wenso anga waungame musamehe. ");
INSERT INTO isn_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ang'wi wakukosela nkua saba kwa luhiku lung'wi waza kitalako walunga, naungama musamehe. ");
INSERT INTO isn_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Eitumi akwe akamuila umukulu, “Kongeelye uhueli witu.” ");
INSERT INTO isn_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Umukulu wikamuila, “Ang'wi angamutule mukite uhueli anga epunje ahaladalii, muhumile kuuela umute uwunuamukuyu, ipike wendelie mubahali, newenso ukumutii. ");
INSERT INTO isn_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Lakini nyenyu mung'wanyu, nukete umitumi nuelema umugunda ang'wi nuesagula inkolo, ukumuila nusukile, Nzuu halaka wikie ulye indya? ");
INSERT INTO isn_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ite shangaukumuila, 'Nzepeeli indya ndye, hange itunge umunkanda untumikile hange mpaka male kulya nukung'wa. Baada apang'wanso ukulya nukung'wa? ");
INSERT INTO isn_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kuite shanga ukomusogeelya umitumi nuanso kunsoko watimelya aya nazulageigwe? ");
INSERT INTO isn_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Uu uu nunyenye anga mitume nemulageigwe tambuli “Usese du keitumi nesingakunonee. Kitumile aya naekugombigwe kituma. ");
INSERT INTO isn_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Aeipumie kina naawile kusafiri kulongola ku Yerualemu, aukeile mumumpaka wa Samaria ne Galilaya. ");
INSERT INTO isn_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nautuile kingela mukesale king'wi, kung'wanso emtankanile neantu ikumi naakete uukoma. Akimeka kule. ");
INSERT INTO isn_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Akakulyi nukulunga, Yesu Bwana kuhulumele.” ");
INSERT INTO isn_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nauaine wikaaila, “Longoli miambye kwa tongeeli.” Neenso naalongoe ikatakasigwa. ");
INSERT INTO isn_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ung'wi ao nauine kina wakomya, wikasuka kululi nulukulu nukumukulya Itunda. ");
INSERT INTO isn_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Wikagwa mumigulu ang'wa Yesu wikamusongelya. Nuanso ae Musamaria. ");
INSERT INTO isn_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","U Yesu wikasukilya wikalunga, “Ite shangaatakasigwene ehi ikumi? Akolepe awa netisa? ");
INSERT INTO isn_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kutile hata nung'wi naewigee kusuka nukumukulya Itunda, ikutula umugeni yuyudu? ");
INSERT INTO isn_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Wikamuila, “Uka na ulongole yako uhueli wako wakukomya.” ");
INSERT INTO isn_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Naukoigwe neafarisayo utemi wang'wi Tunda uzile nale, U Yesu wikaasukilya wikalunga, “Utemi wang'wi Tunda singanga kentu nekewezile kigela. ");
INSERT INTO isn_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Wala eantu shanga akutambula, “Gozapa! ang'wi gozako! Kondogoelyo utemi wang'wi Tunda ukole mukate anyu. ");
INSERT INTO isn_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","U Yesu wikaaila eamanyisigwa akwe, “Imatungo neekapika nemekapa insula kuona moja aluhiku lang'wana wang'wa Adamu, lakini shangamukuona. ");
INSERT INTO isn_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Akamuila, Goza, uko! Goza, pa!” Lakini muleke kenda kugoza wala ukuatyata, ");
INSERT INTO isn_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","anga umeme wa radi nuemeleka igulu kondya enkeka ing'wi hadi enka ngiza, kuite hata ung'wana wa ng'wa Adamu ukutula uu kuluhiku lakwe. ");
INSERT INTO isn_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Lakini hanza igombigwe kuteseka hanza kumakani eedu nukuhitwa nuutugwa uwuite. ");
INSERT INTO isn_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Anga naituile mahiku ang'wa Nuhu uu ikutuleka kumahiku ang'wana wang'wa Adamu. ");
INSERT INTO isn_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Aalee, aang'wee, akatena nukutenwa mpaka uluhiku u Nuhu naawingie mukate musafina negarika ekeza nukuaangameza ehi. ");
INSERT INTO isn_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Uu aitulekile mumahiku ang'wa Lutu, aalee, ang'wee, nakugula nukugulya, akulema nukuzenga. ");
INSERT INTO isn_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lakini uluhiku nulanso u Lutu nauhegile ku Sodoma ikakuimbula, amoto nekebiliti kupuma kilunde ekaangamiza ehi. ");
INSERT INTO isn_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Uu uu ikutula uluhiku nulanso ung'wana wang'wa Adamu nuekakunukulwa. ");
INSERT INTO isn_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Uluhiku nunso, iekakumugombya nukole kudali anyumba asime kuhola ibidhaa yakwe mukate munyumba. Naulekekumugombya nukole kumugunda kusuka kito. ");
INSERT INTO isn_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mukembuke umusungu wang'wa Lutu. ");
INSERT INTO isn_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Uyu wehi nukugema kuaokoa uwikale wakwe ukuulimelya, lakini wehi nuekamalimelya uwikale wakwe ukuokoa. ");
INSERT INTO isn_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kumuelya utiku nuanso ikutula antu abeele alae kitanda keng'we. Ung'we ukuholwa ung'wi ukulekwa. ");
INSERT INTO isn_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ikutula asungu abeele akusia palung'wi ung'wi ukuholwa ung'wi ukulekwa. (Antu abiili akutula mu mugunda, ung'wi ukuholwa, ung'wi ukulekwa) ");
INSERT INTO isn_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Akasukiilya, akamukolya, Ku pii, Mukulu? Akaatambuila, Nu ukoli umuimba, papo ni ikihanguila i a jumuuda. ");
INSERT INTO isn_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Hange wekaaila mpyani netakewe kulompa daima, alekekuta etamaa. ");
INSERT INTO isn_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Akamitambula, “Aokole mulamuli pakesale fulani, hange shanga aumwogopile Itunda nukuaheshimu eantu. ");
INSERT INTO isn_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Aukole mujane pakesale nekanso, nung'wenso aewimuhanga nkua yeedu, nukutambula, “Nzaelye mpate ehakiane numupenzani wane. ");
INSERT INTO isn_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kumatungo edu shangaaukole tayali kumusaidila, lakini baada amatungo akatambula munkolo akwe, ataitule unene shanganumwogopile Itunda ang'wi kumuheshimu umuntu, ");
INSERT INTO isn_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","lakini kunsoko umujane uyu ukunsumbula nukumusaidela wapate ehaki akwe, waleke kunkatalya kwa kunezela mala kwa mala.” ");
INSERT INTO isn_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kuite umukulu wekalunga, “Tegeelyi nautambue nuanso umulamuli nuanso nedhalimu. ");
INSERT INTO isn_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ite Itunda shanga ukuleta ehaki kwateule akwe neakumukela mung'we nuutiku? Ite nuanso shaukiumelyane kung'wao? ");
INSERT INTO isn_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kumuila kina ukuleta ehaki kung'wa kwakukaya. Lakini ematungo nuzie ung'wana wang'wa Adamu, ite ukuuhangane uhueli muunkumbigulu?” ");
INSERT INTO isn_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Uu wikaaela mpyani eye kuantu baadhi hange niiona eenso kina akete ehaki nukuazalau eantu niangiza. ");
INSERT INTO isn_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Antu abeele anankie kulongola mihekalu kusali: ung'wi Farisayo ung'wi mutoza ushuru. ");
INSERT INTO isn_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ufarisayo wekimeka nukulompa aya migulya lakwe ung'wenso, Itunda kusongeelya kunsoko unene singa kipyani neantu niangiza kuita eahegelya, antu nishanga aaminifu, agoolyi, ang'wi anga yuyu umutoza ushulu. ");
INSERT INTO isn_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nefunga mahiku abeele kuwiki. Neepumya ezaka mumapato ane ehi nenepata. ");
INSERT INTO isn_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Lakini nuanso umutoza ushulu, aewimekile kule, shanga auwezilye ata ukuhumbula emiho akwe kilunde, akakuanga kekua kakwe wekalunga, Itunda ngoze unene nimunya milandu.” ");
INSERT INTO isn_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kumuila, umuntu nuanso ausukile kito akize uaeeigwe etai kukela umuya, kunsoko uyu nuikulya wisimigwa, lakini uyu nuisimya wehumbulwa. ");
INSERT INTO isn_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Eantu amuletee eana ao neadabu, kuite ahume kuaamba, lakini eamanyisigwa akwe naaine nanso, akaagilya. ");
INSERT INTO isn_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Lakini u Yesu wakaitanga kung'wakwe wekalunga, “Aleki ana nianino aze kitalane, wala lekikuagilya. Kundogoelyo utemi wang'wi Tunda waantu anga nianso. ");
INSERT INTO isn_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Amini kumuila umuntu wehi nishanga ukusengelya utemi wang'wi Tunda anga ana neanino shangaukingela.” ");
INSERT INTO isn_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mutawa ung'wi aumukoilye, wikalunga, 'Mwalimu namuza ntende ule nuusale upanga wakale nakale? ");
INSERT INTO isn_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","U Yesu wikamuila, “Kuneke ukunintanga numuza? Kutile umuntu numuza, ila Itunda wing'wene du. ");
INSERT INTO isn_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Umamanyilene emalago-lekakugoolya, lekakubulaga, lekakia, lekakutambula uteele, aheshimu ebaba ako numama ako. ");
INSERT INTO isn_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Umutawala nuanso wekalunga, “Imakani ayaite numaambile kupuma uhumba wane. ");
INSERT INTO isn_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","U Yesu naewigule nanso wikaaila, “Upungukewe nekentu king'wi. Lazima ugulye ehi nukete aagawele awa niagila, nuewe ukutuwa nehazina kilunde kuite nzuu, uuntyate. ");
INSERT INTO isn_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Lakini umugole naewigulye nanso wekapata kenyauai lukulu, kunsoko ae mugole lukulu. ");
INSERT INTO isn_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Hange u Yesu wikamugoza nauambilwe ikenyauai ikulu wikalunga, 'Kuule neekatula ikaku eagole kingela ku utemi wang'wi Tunda! ");
INSERT INTO isn_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kundogoelyo itotu ikulu kungamea kukela mitundu la sindano, kukela eugole kingela utemi wang'wi Tunda.” ");
INSERT INTO isn_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Awa naeigulye nanso, ekalunga, “Nyenyu gwa, nuekaweza kuokolewa? ");
INSERT INTO isn_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","U Yesu wikasukilya, “Imakani neshangaawezekanile kwa anadamu kung'wi Tunda awezekanile.” ");
INSERT INTO isn_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","U Petelo wikalunga, “Uu usese kaleka kila ekentu nakakutyata uewe.” ");
INSERT INTO isn_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Hange u Yesu wikaaila, hueli kumuela kina kutile muntu nulekile enyumba ang'wi musungu, ang'wi munyandugu ang'wi aleli, ang'wi ana, kunsoko autemi wang'wi Tunda, ");
INSERT INTO isn_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kuite shanga ukupokela nedu kukela muunkumbigulu uwu, numuunkumbigulu uwu nuuzile upanga wakale na kale. ");
INSERT INTO isn_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Baada akuilingela awa nekumi na mbele, wikaaila, goza, kuunankela kulongoe ku Yerusalemu, ne makani ehi naandekilwe neanyakedagu kuhusu ung'wana wang'wa Adamu akukamileka. ");
INSERT INTO isn_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kundogoelyo ukuambwa mumekono amataifa akumudhiki nukumutenda ejeuri, nukumutyela emate. ");
INSERT INTO isn_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Baada akumukua iiboko akumubulaga nuluhiku lakatatu ukiiuka.” ");
INSERT INTO isn_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Shanga ealengile imakani nanso, nulukani ulu ite aelupihilwe kung'wao, hange shangaaealengile emakani naatambuwe. ");
INSERT INTO isn_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ikatula u Yesu naauhugie ku Yeriko, muntu ung'wi mupoku aewikie mumpelompelo abalabala aeukulompa ugunwa, ");
INSERT INTO isn_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","naewigule umilundo wa antu ukeile akakolya ntuni niipumie. ");
INSERT INTO isn_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Eekamuila kina u Yesu nua Nazareti ukeile. ");
INSERT INTO isn_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kuite umupoku wekalela kululi, wikalunga, Yesu, ng'wana wang'wa Daudi nehulumele.” Awa naakugenda ekamukenela umupoku nuanso, ekamuela kilaga. ");
INSERT INTO isn_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Uugwa awo naza atongee, akamukenda ite wakilage, kuiti u ng'wenso ai ukiile ikilo nangahu kitunta u luli Ee, ng'wana wang'wa Daudi unkendepe. ");
INSERT INTO isn_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","U Yesu wikimeka akaamulu umuntu nuanso waletwe pang'wa akwe. Hange umupoku nuanso nauhumbie, U Yesu wikamukolya, ");
INSERT INTO isn_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Utakile nukutendele ntuni? Akalunga, “Bwana ntakile kuona.” ");
INSERT INTO isn_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","U Yesu wikamuila, “Upegwe kuona. Uhueli wako wakukomya.” ");
INSERT INTO isn_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Uu wekapegwa kuona, akamutyata u Yesu nukumukulya Itunda. Naaine ileile eantu ehi akamukulya Itunda. ");
INSERT INTO isn_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","U Yesu aewingie nukukela mukate a Yeriko. ");
INSERT INTO isn_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nepang'wanso aukole muntu elina lakwe Zakayo. Hange ae mukulu waatoza ushulu hange muntu numugole. ");
INSERT INTO isn_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Aukugema kumuona u Yesu muntu wa namunake, lakini shanga aukondilye kuona kunsoko amilundo wa antu, kunsoko aemukupe wakimo. ");
INSERT INTO isn_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kuite wikatongela intambo ntongeela aantu, wikanankela migulya amunkuyu kuite wahume kuona, kunsoko u Yesu aewahumbela ukukeela inzila yeyo. ");
INSERT INTO isn_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Imatungo u Yesu naupikile pang'wanso, augozile migulya akamuila, “Zakayo sima kaya, kundogoelyo lelo lazima nshinde munyumbako. ");
INSERT INTO isn_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Wikituma halaka, wekasima nukumukalibisha kwakiloelya. ");
INSERT INTO isn_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Eantu ehi naaine nanso, akalalameka, nukulunga, “Wendamugendela umuntu nukete imilandu.” ");
INSERT INTO isn_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","U Zakayo wikimeka wikamuila Bwana, goza Bwana enusu ansailo yane kuapa eaula, anga itule numuhegeye muntuwehi ekentu, kumusukelya nkua inne.” ");
INSERT INTO isn_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","U Yesu wikamuila, Elelo uugunwa upikile munyumba yeye, kunsoko nuanso nung'wenso ng'wana wang'wa Ibrahimu. ");
INSERT INTO isn_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kundogoelyo ung'wana wamuntu uzile kuduma nukuaokola eantu nialimie.” ");
INSERT INTO isn_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Naaigulye nanso, wikaendelea kuligitya nukuapumilya impyani, kunsoko aukole pakupe ne Yerusalemu, neenso alengile kina utemi wang'wi Tunda aeukole pakupe kigela nkuaing'wi. ");
INSERT INTO isn_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kuite wekamuila, “ofisa ung'wi aewendile ihe akole ili apokeele utemi hange wasuke. ");
INSERT INTO isn_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Aeutangile iitumi akwe ikumi, wikaapa mafungu ikumi, wikaaila, itumi ebiashala kuite mpaka nekusuka. ");
INSERT INTO isn_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Lakini enihe akwe shanga aeamuloilwe kuite wekaatuma eajumbe ende amudume nukulunga, shangakutakile umuntu uyu ite wakutawale. ");
INSERT INTO isn_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Kuite nausukile kito baada akupegwa uutemi, akalagelya eitumi naualekee impia itangwe kung'wakwe ahume kumanya faedake naamepatile naeitumile ebiashala. ");
INSERT INTO isn_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nuang'wandyo wekeza, nukulunga, “Bwana ifungu lako litumile mafungu ikumi zaidi.” ");
INSERT INTO isn_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Uofisa nuanso akamuila, iza, mitume numuza, kunsoko aeumuhueli kueke nekenino, ukutula nuuhueli migulya aisale ikumi. ");
INSERT INTO isn_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Nuakabeele wekiza, akalunga, “Bwana ifungu lako lituma mafungu ataano. ");
INSERT INTO isn_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Uofisa nuanso wekamuila, Hola utawala migulya aisale itaano.” ");
INSERT INTO isn_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nuyu numungiza wekiza, akalunga, “Bwana seye apa empia ako, kuite aembekile iza mukitambala, ");
INSERT INTO isn_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","kundogoilyo aenogopile kunsoko, kunsoko uewe umutaki, nihola neshanukeekile nukuvuna neshauketeme.” ");
INSERT INTO isn_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Uofisa nuanso akamuila, “Kunkani yako uewe, nukuhukumu, ue umitumi numube. Aulengile kina unene nemuntu numutaki, nehola neshanganukeekile, nukuvuna nishanga nuketemee. ");
INSERT INTO isn_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ite shangawekaekane empia ane mubenki, kuite nensukile numehole palung'wi nefaida? ");
INSERT INTO isn_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Uofisa wekaaela eantu naeakole imekile apaite, Muhegelyi ifungu nelanso nukumupa uyu nuamafungu ikumi.” ");
INSERT INTO isn_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Wekamuela, Bwana, nuanso ukete mafungu ikumi. ");
INSERT INTO isn_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Kumuela, kila umuntu nukete ukupegwa ikulu, lakini uyu numugila, ata keke nukete kekuholwa. ");
INSERT INTO isn_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Lakini awaite ebee ane, kuite shangae atakile ntule numutemi wao, aleti apaite muabulage ntongeela ane.” ");
INSERT INTO isn_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Baada akulunga nanso, wikendelea kuntongela nukunankela kulongola ku Yerusalemu. ");
INSERT INTO isn_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kuite nauhugie ku Bethfage nuku Bethania, pakupe numulema wa Mizeituni, autumile eamanyisigwa akwe abeele, ");
INSERT INTO isn_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","akalunga: “Longoli kijiji nekakesale. Mingile mukumuhanga ng'wandogwe nukele kunankelwa. Mutungoli, mumulete kung'waane. ");
INSERT INTO isn_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Anga muntu wamukolya, “Mbona mukumutungwela? “Lungu, “Bwana umutakile.” ");
INSERT INTO isn_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Awa naatumilwe akalongola ekamuona ung'we - ndogwe anga u Yesu nauaee. ");
INSERT INTO isn_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Naakumutungula ung'wa-ndogwe eatawala akaela, kuneke mukumutungula ung'wa ndogwe uyuite? ");
INSERT INTO isn_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ekalunga, Bwana umutakile. ");
INSERT INTO isn_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kuite, akamutaila u Yesu, ekaela ian'wenda ao migulya mung'wa - ndogwe ekamunankelya u Yesu migulya akwe. ");
INSERT INTO isn_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nautuile ukolongola eantu akaela iang'wenda ao mubalabala. ");
INSERT INTO isn_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nautuile ukusima mumulima wa Mizeituni umilondo wehi nuamanyisigwa akwe akanza kumulombeelya nukumukulya Itunda kululi nulukulu, kunsoko amakani nemakulu naamaine, ");
INSERT INTO isn_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ekalunga, “Inge ukembetilwe umutemi nuzile kulina lang'wa Bwana! Ulowa, Milunde, nuutukufu migulya! ");
INSERT INTO isn_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Baadhi amafarisayo mukate amilundo ekamuila, Mwalimu akilagye imagwe akukulya ululi. ");
INSERT INTO isn_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","U Yesu wekaasukilya, nukulunga, wekaaila, anga wawa akilage, imagwe akukulya ululi.” ");
INSERT INTO isn_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","U Yesu nauhugie ikesale wekakelela, ");
INSERT INTO isn_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","wikalunga, tazu angezeune ata uewe, muluhiku ulu emakani aya nekuletela ulowa! Lakini itungele apihilwe mumiho ako. ");
INSERT INTO isn_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kunsoko ipembilye insiku eabee ako akuzenga itando pakupe nuewe. ");
INSERT INTO isn_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Akugwisa pihe uewe neana ako. Shangaakulekela ata igwe neleng'we migulya anilengiza, kunsoko shanga aulengile imatungo Itunda naugemile kuokoa. ");
INSERT INTO isn_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Uye wakingila mihekalu, akandya kuazunsa awa naeakugulya, ");
INSERT INTO isn_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","wekaaela, “Yandekilwe, Enyumbane ekutula nyumba amalompi, lakini unyenye yatula anga ikulungu lahegelyi” ");
INSERT INTO isn_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kuite, u Yesu aewimanyisa kila uluhiku mihekalu. Eatongeli neakulu nealimu a shelia neatongeli antu naatakile kumubulaga. ");
INSERT INTO isn_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Lakini shangaekaweza kulija enzila nakituma nanso, kunsoko eantu ehi amutegeye kwamakini. ");
INSERT INTO isn_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ikatula luhiku lung'wi, u Yesu naukuamanyisa eantu mihekalu nukuaela ulukani, Eatongeli neakulu nealimu ailagilo ekalongola palung'wi neanyampala. ");
INSERT INTO isn_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Aaligitilye, Ekumuela, kuele kwa utawalake ukitumae makani aya?” ");
INSERT INTO isn_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nung'wenso wikaasukilya akaaela, Nunene ga kumukolya iswali mbeli, ");
INSERT INTO isn_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ubatizo wang'wa Yohana ite aupumie kilundene kang'wi muantu? ");
INSERT INTO isn_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Lakini akakikolya eenso kwa enso, ekalunga, anyakulunge, lepumie kilunde, ukukolya, ite mbona shungamumukue? ");
INSERT INTO isn_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Anga kulunge aupumie kwanadamu eantu ehe akukua imagwe, kundogoelyo ehi amuhue kina u Yohana ae munyakidagu.” ");
INSERT INTO isn_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ite ekamuela kina shangaaine kuna upumie. ");
INSERT INTO isn_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","U Yesu wikaaela, “Wala unene singa kumuila unyenyu kwa utawalake kituma emakani aya. ");
INSERT INTO isn_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Auoe eantu mpyani eye, “Muntu ung'wi autemee mugunda wamezabibu, wikalekodisha kwa alemi amezabibu nawikalongola kesale kengeza kwa matungo ulepu. ");
INSERT INTO isn_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kumatungo naapangilwe, aeumutumile umitumi kumitumi wamezabibu, kina amupe esehemu ankali yamugunda wa mizabibu, lakini ealemi neamugunda wazabibu ekamuhita, ekamususha mekono metile. ");
INSERT INTO isn_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kuite akamutuma hange umitumi mungiza nung'wenso ekamuhita, akamutenda ibee nukumususha mekono metile. ");
INSERT INTO isn_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Wikamutuma hange nuakatatu nenso ekamubepya nukumuguma kunzi. ");
INSERT INTO isn_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Kuite umukola mugunda wikalunga, kutenda ule? Kumutuma ung'wane nenumuloilwe kuite akumuheshimu. ");
INSERT INTO isn_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Lakini ealemi amizabibu naamuine, aeikoile eenso kwa enso ekalunga uyu yuyu musali, kumubulage kuite usali wakwe utule witu. ");
INSERT INTO isn_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ekamupumya kunzi amugunda wazabibu nukumubulaga ite umukola mugunda ukutenda ule? ");
INSERT INTO isn_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Uzile uzeangameza ealemi amugunda wazabibu, naukuapa antu angiza umugunda nuanso. ");
INSERT INTO isn_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Lakini u Yesu wikaagoza, wekalunga, ite ulukani uluite lukete ndogoelyo ke? Igwe naalehile eazengi latula lamumpelompelo? ");
INSERT INTO isn_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kela umuntu nukugwa migulya igwe nelanso ukuunangwa ipande, ipande, lakini uyu nuekagwelwa lekumutula.” ");
INSERT INTO isn_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kuite eandeki neakulu amakuhani aeadumile nzela akumuamba matungo yayo yayo, alengile kina alungile empyani eye kunsoko ao. Lakini aeaogopile antu. ");
INSERT INTO isn_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ae amugozee nunda, ekatuma eakoelyi naeitendya kina antu neatai, ite alenge kulija ikosa kuhetubaakwe. ");
INSERT INTO isn_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Neenso ekamukolya ekalunga, mwalimu, kuine kina ukutambula, nukumanyisa imakani atai nashanga akuilwa numtu wehi, lakini uewe wemanyisa etai kukeela Itunda. ");
INSERT INTO isn_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","He taine usese kulepa ekodi kung'wa Kaisali ang'wi aa? ");
INSERT INTO isn_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Lakini uyesu wikalenga umuntego wao, wekaaila, ");
INSERT INTO isn_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Ndagele edinali. Sula ang'wa nyenyu ekole migulya akwa? Ekalunga, ''Ang'wa Kaisali.'' ");
INSERT INTO isn_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nung'wenso wekaaela, kuite, mupi ukaisali, ni Tunda nakwe mupii. ");
INSERT INTO isn_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Eandeki neakulu neakuhani aeagila anga uhumi wa kukosela eke nuketambue ntongeela aantu. Ekakuelwa emasukilyo akwe, nashaatambue lehi. ");
INSERT INTO isn_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ang'wi amasadukayo ekamendela, awa kina etambula kina kutile anga uiuki. ");
INSERT INTO isn_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ekamukolya, ekalunga, ''Mwalimu umusa aukuandekie kina umuntu angawashilwe numunyandugu nukete umusungu nemugila anga ng'wana ite uhumile kumuhola umusungu wamunyandugu wakwe nukutuga nung'wenso kunso ang'wa kaka akwe. ");
INSERT INTO isn_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Aakole anya ndugu saba nung'wandyo wekatena, akasha bila kuleka anga ng'wana, ");
INSERT INTO isn_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nunyu nukabele ga. ");
INSERT INTO isn_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nukatatu akamuhola uu, uuuu nuasaba shanga aulikile anga ana wikasha. ");
INSERT INTO isn_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Baadae umusungu nuanso, nung'wenso wikasha. ");
INSERT INTO isn_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kuite kuiiuki ukutula musungu wang'wa nyenyu? kundogoelyoehi saba amutenile ");
INSERT INTO isn_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Uyesu wikaaela, ''Eana aunkumbigulu etena nukutenwa. ");
INSERT INTO isn_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Awa neagombigwe kupokela uiiuki nuashi nukingila muupanga wakalenakale shangaitena nukutenwa. ");
INSERT INTO isn_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kuite shanga ahumile kusha hange, kunso etula kina esawasawa neamalaeka na ana ang'wi Tunda, Ana auiki. ");
INSERT INTO isn_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Lakini kuite eashi eiiuka, kuite Umusa aulagie pangwanso ku habali akehaka, pangwanso aumitangile Bwana kina Itunda wang'wa Ibrahimu ni Tunda wang'wa Isaka ni Tunda wang'wa yakobo. ");
INSERT INTO isn_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Apa nuanso singa Itunda waashi, inge wa awa neapanga, kunso ehi iikie kung'wakwe. ");
INSERT INTO isn_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Baadhi aantu ang'wamwalimu ilago akamusukilya, mwalimu, wasukilya Iza. ");
INSERT INTO isn_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Shanga aeagemile kumukolya emaswale nemangiza, lukulu. ");
INSERT INTO isn_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Uyesu aakaela, ''kuneke eantu elunga kina ukristo ng'wa Daudi? ");
INSERT INTO isn_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kundogoelyo Udaudi ung'wenso welunga muzabuli: Bwana aumuee ubwana ane: Ikie kumukono wane nuwakulela. ");
INSERT INTO isn_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Kuite nuaeke hanza eabe ane pihe amigulu anko. ");
INSERT INTO isn_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Udaudi wikamitanga kristo, 'Bwana', Ite ikutuleka ule ng'wana wang'wa Daudi? ");
INSERT INTO isn_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Eantu ehe naamutegeeye wekaaela emanyisigwa akwe, ");
INSERT INTO isn_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Ihugushi neaandiki, Nelowa kugenda nukutugala eng'wenda nealepu, naelowa kilamusha maaluku misoko nematuntu aheshima mumatekeelo, nemaeneo aeshima mukalamu. ");
INSERT INTO isn_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nenso ga eleza inyumba ya jane, niafanya elompa matungo malepu. Awa akusengilya ehukumu nkulu kukila. ");
INSERT INTO isn_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","U Yesu akagoza akaaona itunja niagole akazeika masongeelyo ao mukiuto. ");
INSERT INTO isn_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Akamuona musungu ung'wi mushilwa akazeki mkumba akaziika mpia ibiili. ");
INSERT INTO isn_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kululo akalunga, “Tai numuie, umushilwa uyu nikinkumba uikile idu kukila ihi nazaaikile. ");
INSERT INTO isn_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Awa ihi apumilye imasongeelye kunsoko aiatite maintu idu, ingi umushilwa uyu aupumilye impia yihi kunsoko zizo autite.” ");
INSERT INTO isn_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Niang'wi akazilunga itekeelo, nailinoneigwe na magwe nimaza nimasongeelyo aantu akalunga, ");
INSERT INTO isn_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Kua nkani izi, aya nimukamaona, mahiku azile, nikutile igwe ata nilig'wi nilizizalekwa migulya nigwe ningiza nishalizizakumulwa. “ ");
INSERT INTO isn_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Kululo ikamukolya, ikalunga, “Mumanyisi inkani izi izi eapumila nali? Hangi kilingasiilyo ki ni ka nkani nikikoli pakupe kupumila?” ");
INSERT INTO isn_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","U Yesu akasusha, “Mutule miho muleke kukongwa, kunsoko idu akupembya kukiila lina lane aze lunga ingi nene ni matungo ahugeela” Muleke kuatyata. ");
INSERT INTO isn_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Anga mija uulugu nuwilei muleke kugopa, kunsoko inkani izi mpaka ipumile hanza, ingi impelo izizeikili kupumila.” ");
INSERT INTO isn_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Sunga akaaila, “Ihi ikuuka kikua nihi nzuya, nutemi kua utemi. ");
INSERT INTO isn_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Izitula ni matetemeko makulu, ni nzala ni ndwala niampuku muisali, izitula ninkani yakogopa, niilingasiilyo niakogopa kupuma kilunde. ");
INSERT INTO isn_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ingi gwa ntongeela ankani izi yihi, akuikila imikono ao migulya anyu nukumaja, kumutwala mumatekeelo nu muitungo, kumuleta kuntongeela a temi nawa niatite uhumi kunsoko a lina lane. ");
INSERT INTO isn_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ili likuluguilwa lyoma nila wihengi wanyu. ");
INSERT INTO isn_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kululo lamuli munkolo yanyu muleka kutula nimasigo. ");
INSERT INTO isn_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kunsoko kumupa inkani muhugu, nialugu anyu ihi nishaakuhuma kumigilya nukumihita. ");
INSERT INTO isn_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ingi gwa muzizahitwa nia leki anyu, anyandugu anyu, antu akitaitu, ahumba eitu, hangi niang'wi azi bulagwa. ");
INSERT INTO isn_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Mukuhukilwa nu kila umuntu kunsoko alina lane. ");
INSERT INTO isn_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Kululo gwa ingi kutili ata isingi niliing'wi nuitwe lanyu nukuzizalimila. ");
INSERT INTO isn_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kua ugimya wanyu mukuiguna inkolo yanyu. ");
INSERT INTO isn_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Anga maona i Yerusalemu apiling'wa nia homi, ingi gwa lingi kina ugazanji wake wahugeela. ");
INSERT INTO isn_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Pang'wanso ao niakoli ku Yudea amankiile mumalugulu, nao niakoli pakati akisali ahege, hangi aleke kualeka ao niakoli muisali kingila. ");
INSERT INTO isn_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nsoko aya mahiku akulipisha, kina inkani yihi naiyandikilwe ihuma kukondaniila. ");
INSERT INTO isn_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Isatiko lao ao niakite inda nao niakonsha mumahiku nanso! Kunsoko izetula nu lwago luhiku mihi, nikililo kuantu awa. ");
INSERT INTO isn_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Hangi akugwa kua nsonge nia panga, hangi akuholwa usese ku ihi ihi, ni Yerusalemu ikupambatwa niantu nishaahuie, sunga imatungo na aantu nishaahuie nizikondanila. ");
INSERT INTO isn_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Izezeikoli ilingasiilyo mu lyoa, ng'weli ni nzota. Numihi izeze lukoli lwago mahi, azihita kulongola kunsoko amulilo nualuzi ni maingo. ");
INSERT INTO isn_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Antu azitula gwa kiteta kunsoko akagopa makani ayo nazilepumila mihi, nsoko ingulu yilunde ize hingisigwa. ");
INSERT INTO isn_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Sunga azemuona ung'wana wang'wa Adamu azuzile mumalunde ni ngulu nuukulu nuakigulu. ");
INSERT INTO isn_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ingi imakani aya anga andya kupumila, imiki, humbuli imatwe anyu, kunsoko uguniki wanyu wahugeela pakupe.” ");
INSERT INTO isn_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","U Yesu akaaila kua mpyani, “Ugozi umuti, ni mite ihi. ");
INSERT INTO isn_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Iga andye kutegeta, miona unyenye nukulinga kina kipasu kikoli pakupe. ");
INSERT INTO isn_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ingi uu anga maona inkani izi yakapumila nunye lingi kina utemi wa kigulu wahugula. ");
INSERT INTO isn_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Tai, numuie, uwileli uwu shaukukila, sunga inkani izi yihi nizizapumila. ");
INSERT INTO isn_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Unkumbigulu ni ukukila, ingi inkani yane shaikukila lukulu. ");
INSERT INTO isn_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Kululo igozi unyenye, inkolo yanyu izeileke kulemeligwa nuubi ugala magai, nulwago nula mihi kunsoko uluhiku nulanso luzizilumbane kuza. ");
INSERT INTO isn_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Uzetula anga umuntego, kua kita umuntu nuikie mihi ihi. ");
INSERT INTO isn_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ingi mihambe kumatungo ihi, mulompe kutula mikomu kukonda kumatyaga aya ihi nazepumila, nukimika kuntongeela a ng'wana wang'wa Adamu.” ");
INSERT INTO isn_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kululo matungo ang'ung'wi akapuma kunzi, akenda kulompa mlugulu nulitangwa Mizeituni. ");
INSERT INTO isn_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Antu ihi ikamuhanga ikidaudau ikamutegeelya akazukoli mitekeelo. ");
INSERT INTO isn_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ingi uluhiku nulaulumbili wa mikate nishiikiwe igai ailapika, nulitangwa Pasaka. ");
INSERT INTO isn_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Iamakuhani niakulu niakilisi akatulikolya kumubulaga u Yesu, kunsoko aiaogopile iantu. ");
INSERT INTO isn_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Umubi akingila kung'wa Yuda Iskariote, ung'wi wa ao nai amanyisigwa ikumi na abiili. ");
INSERT INTO isn_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","U Yuda akalongola kikolya nia kulu amakuhani kina ukumutwala uli u Yesu kitalao. ");
INSERT INTO isn_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ikalowa, ikigombyo kumpa impia. ");
INSERT INTO isn_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","U Yuda akagomba hangi akaduma ilyoma niilakumtwala u Yesu kitalao, kuli nu milundo nuantu. ");
INSERT INTO isn_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Luhiku nulamikate nisingaikiwe igai lukapika, kululo inkolo na Pasaka mpaka ipumigwe. ");
INSERT INTO isn_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","U Yesu akaaligiilya, u Petro nu Yohana, akalunga, iongoli mende mukunonelelye indya nia Pasaka kuze kuilye. ");
INSERT INTO isn_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ikamukolya utakile kunonelya pi? ");
INSERT INTO isn_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Akaasukiilya, “Tegeeli, nimukingila mukisali mitunja nukenkile inyungu a mazi mukutankanya nunyenye. Mulyati munyumba nukingila. ");
INSERT INTO isn_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Sunga muili umukola nyumba, “Umumanyisi ukuuila, kikoli pi ishumba nikakila nzila, uko nikulya i Pasaka nia manyisigwa ane. ");
INSERT INTO isn_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ukumulagiila ishumba nikamiggulya nikikondile. Noneeli mumo. ");
INSERT INTO isn_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Kululo ikalongola ikahanga maintu ihi akoli anganauaie. Sunga ikanonelya indya nia Pasaka. ");
INSERT INTO isn_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Matungo naapika akikie niitumi akwe. ");
INSERT INTO isn_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Sunga akaaila, nkete nsula nkulu akulya ilumbili nila Pasaka nunye une ninkili kagigwa. ");
INSERT INTO isn_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kunsoko numuie, singa kulya hangi niizekondaniila utemi wa kigulu. ");
INSERT INTO isn_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Sunga u Yesu akahola ikikombe naiwakondya kulompa, akalunga, holi iki hangi mugalane nyenye kua nyene. ");
INSERT INTO isn_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kunsoko numuie singa kung'wa hangi uleli nua mzabibu, sunga utemi wang'wi Tunda nuziziza ");
INSERT INTO isn_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Sunga akauhola umukate, naiwakondya kulomba, akauega, akaapa, akalunga, “Uwu muili wane naupumigwe kunsoko anyu. Itumi uu kua kunkimbuka unene. ");
INSERT INTO isn_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Akahola ikikombe naiwakondya indya niautiku akalunga, ikikombe iki ilago ipya nilasakami ane, naihunukile kunsoko anyu. ");
INSERT INTO isn_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ingi gwa gozi uyu nukungulya kukoli palung'wi nung'wenso kuulya mumeza. ");
INSERT INTO isn_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kunsoko ung'wana wang'wa Adamu tai akalongola yakwe anga naupewe ilago. Isatiko lakwe umuntu nuzemulekeelya ung'wana wang'wa Adamu kagigwa niantu. ");
INSERT INTO isn_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Akandya kikolya ienso naenso, nyenu apa nikukoli nuhumile kituma ulukani ulu. ");
INSERT INTO isn_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Sunga ukapumila wikungumi pakati ao kina nyenyu nusigiiwe kutula mukulu kukila ihi. ");
INSERT INTO isn_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Atemi amahi iatema nao niakote uhumi migulya ao eitanga akuligwa. ");
INSERT INTO isn_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ingi nishaitakiwe kutula iti kitalanyu, kuite leki uyu numukulu kitalanyu atule anga muniino. Nuyu nutakiwi itai nangulu atule anga wituma. ");
INSERT INTO isn_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nuuli umukulu, uyu nuikie mumeza ang'wi uyu nuiluma? Ang'wi uyu nuikie mumeza? Numene nkili pakati anyu anga nitumika. ");
INSERT INTO isn_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ingi unye inda mulongolekile kutula nunene mumakuilwa ane. ");
INSERT INTO isn_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kumupa unyenye utemi, anga unene utata naumpee utemi. ");
INSERT INTO isn_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Kina muhume kulya nukung'wa mumeza ane mutemi wane, hangi mukikie mumatuntu aukulu muzeapa ulamulwa ikabila ikumi naibiili nia Israeli. ");
INSERT INTO isn_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simoni, Simoni, linga kina umubi walompa amuhole ahume kumupeta anga ingano. ");
INSERT INTO isn_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kululo nakulompeela, kina uhuili wako ulekekulengwa. Anga wasuka hangi uakomise ianyandugu ako.” ");
INSERT INTO isn_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","U Petro akamuila mukulu nihambile kulongola nuewe kukitungo nu munsha kulongolania. Palung'wi. ");
INSERT INTO isn_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","U Yesu akasusha, akamuila, Petro, inkunkuli shikukunkula ileli yi, nukila kunihita kataatu kina uningile. ");
INSERT INTO isn_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Sunga u Yesu akaila, “Nainumutwae unye mikaze miagila umufuko, kikapu kandya ang'wi ilatu, muhiiwe ni maintu? akalunga kutili. ");
INSERT INTO isn_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Sunga akaila, wihi nukete imbugulu, au hole palung'wi ni ndya, uyu numugila upanga ilakiwe agulye ijoho ende agule ing'wi. ");
INSERT INTO isn_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kunsoko kumuila, ihi aya nandikilwe kunsoko ane mpaka akondanile, hangi auhoilwe anga muntu naubunangile unoneelya, kunsoko iko naikiligitigwe kunsoko ana kikukondaniligwa. ");
INSERT INTO isn_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Sunga akalunga mukulu, goza sizi hapa ipnga ibiili, hangi akaaila yakonda. ");
INSERT INTO isn_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Umatungo andya nautiku u Yesu akahega akatula anga naiwituma imahiku ihi akalongola mulugulu nula Mizeituni niamanyisigwa akwe ikamutyata. ");
INSERT INTO isn_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Naiapika akaaila lompi gwa muleke kingila mumageng'wa. ");
INSERT INTO isn_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Akalongola kuli mpyani akuguma igwe, akatugama akalompa. ");
INSERT INTO isn_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Akalunga, Tata, anng'wi uloilwe, nihegelye ikikombe iki. Ingi gwa singa anga nindoilwe unene, kululo ulowa wako witume. ");
INSERT INTO isn_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Sunga umalaika kupuma kigulu akapumila akamupa ingulu. ");
INSERT INTO isn_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Akazukoli muulwali, akalompa kutai, ulitutu lakwe lukatula anga imadonyo makulu na sakami akazigwa pihi. ");
INSERT INTO isn_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Matungo naiwauka kupuma mumalompi yakwe, akiza kuamanyisigwa akwe, akaahanga alal kunsoko akinya uwai kao. ");
INSERT INTO isn_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Hangi akaakolya, kuniko mlikulala? Uki mulompe muleke kingila mumageng'wa.” ");
INSERT INTO isn_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Matungo naakili ukuligitya, goga milunde ukulu nuantu ukapumila, nu Yuda ung'wia wao nuitumi wa kumi na abiili akazuatongee. Akaza pakupe nu Yesu ahume kumulungila. ");
INSERT INTO isn_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Kululo u Yesu akamuila, u Yuda uloilwe kumugulya ung'wana wang'wa Adamu kuilungili? ");
INSERT INTO isn_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ao naiakoli pakupi nu Yesu naiaona aya akupumila, akalunga, mukulu, kuakue na panga? ");
INSERT INTO isn_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Sunga ung'wia akamukua umitumi nuang'wa kuhani numukulu, akamudumula ukutwi wakwe nuamkono wakigoha. ");
INSERT INTO isn_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","U Yesu akalunga, iyi ikondilye, hangi akamuamba ukutwe akwe, akamuguna. ");
INSERT INTO isn_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","U Yesu akalunga kung'wa kuhani numukulu, nukuakulu niamatekeelo, nianyampala naiazile mupiluka, iti muzile anga muzikua nia sambo, niidunkuli nia panga? ");
INSERT INTO isn_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mahiku ihi naikina palung'wi nunye mitekeelo, shaimuikie imikono anyu kitalane. Ingi gwa aya matungo ako, ni ngulu ya kiti. ");
INSERT INTO isn_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Akamuamba ikamutongeela ikamuleta kung'wa kuhani, ingi gwa u Petro akamutyatila kua kuli. ");
INSERT INTO isn_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nai akilya umoto mung'wanso mukati, naiamala kikie pihi palung'wi, u Petro akikie pakati ao. ");
INSERT INTO isn_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mitumi ung'wi nuakisungu, akamuona naiwikie muwelu nuamoto, akamugoza akamuila umuntu uyu azaine palung'wi nung'wenso. ");
INSERT INTO isn_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ingi u Petro akahita, akalunga uwe musungu we une shanumumanyile. ");
INSERT INTO isn_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Matungo makehu, numuya muntu akamuona akamuila nu ewe mipalung'wi nung'wenso, u Petro akasusha, “Mitunja, singa nene.” ");
INSERT INTO isn_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Naakila matungo anga isaa ling'wi itu, mitunja ung'wi akalunga, tai lukulu umuntu uyu azaipalung'wi nung'wenso kunsoko ingi Mgalilaya.” ");
INSERT INTO isn_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ingi u Petro akalunga, mitunja shamine nuligitilye, akatula naukuligitya inkunkuli ikakunkula. ");
INSERT INTO isn_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Akapiluka, umukulu akamugoza u Petro nu Petro akalukimbuka ulukani nula mukulu, apo namuie, inkunkuli izizikili kukunkula ileliye, ukunihita katatu. ");
INSERT INTO isn_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Akalongola kunzi, u Petro, akalila kua kinyauwai kidu. ");
INSERT INTO isn_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Sunga eitunja ao naenda musunga ikatula mumela nukumukua. ");
INSERT INTO isn_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nai amukunikila imiho, akamukolya, akamuila, simumanye nyenyu nukukuile? ");
INSERT INTO isn_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ikaligitya nkani yidu nishayimpyani nizo niang'wa Yesu, hangi akazemumela. ");
INSERT INTO isn_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Naapika imatungo akidaudau, anyampala aantu akiilingila palung'wi, akulu amakuhani, niaika nkani. Ikamutwala kianza. ");
INSERT INTO isn_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Akazelunga ang'wi uewe wi Kilisto, kuile nuanso akaaila, aga numuile shamukuhuila. ");
INSERT INTO isn_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Hangi aganumukolye shangamukusukiilya. ");
INSERT INTO isn_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ingi kandiilya inoino nukulongoleka, ung'wana wang'wa Adamu ukutula wikie mkono nua kigoha nua ngulu yang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ihi ikalunga, kululo kulunge uewe wing'wana wang'wi Tunda? Nu yesu akaaila, unye muliiye kina unene. ");
INSERT INTO isn_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Akalunga kuniki enda kukili kuduma nsoko? Kunu enda kigule usese kupuma mumulomo wakwe. ");
INSERT INTO isn_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Umilundo wihi ukimika, ukamutwale uYesu pantongeela ang'wa Pilato. ");
INSERT INTO isn_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ikandya kumuumbilya inkani, akazelunga, kumuhangile umuntu yu ukumunkonga ihi itu, wenda agilya iantu aleke kupumya impia kung'wa kaisari, hangi wenda hinga kina nuanso Kristo, Mtemi. ");
INSERT INTO isn_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato akamkolya, akahunga, Uewe wintemi Wayahudi? uYesu akasusha akalunga, ingi wewe ukulanga iti. ");
INSERT INTO isn_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Upilato akamuila ukuhani numukulu a mitunda, shakuona igazo nila muntu uyu. ");
INSERT INTO isn_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ingi nianso ikalunga, wenda asongeela iantu, wenda amanyisa kuuyahundi ihi, kandilya kugalilaya ni tungili ukoti hapa. ");
INSERT INTO isn_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Upilato nai wija, akakaelya kina Umuntu uyu ang'wa waku Galilaya. ");
INSERT INTO isn_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Naiwalinga kina aukoli mutemi wang, wa Herode, akamutwala kung'wa Herode, imatungo nanso nung'wenso aukoli kuyerusalemu imahiko nanso. ");
INSERT INTO isn_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Uherode naiwamuona Yesu, akalowa, kunsoko autakile kumuona siku idu. Aiwija ulukumo lakwe, akalowa aone ata ikuilwa ling'wi nilikitung'wa nung'wenso. ");
INSERT INTO isn_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Uherode akamukolya uYesu nkani yidu, Uyesu singa akasusha kintu kihi. ");
INSERT INTO isn_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Iakuhani niakulu palung'wi niandiki akimika kuautaki ukazimusemela. ");
INSERT INTO isn_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Uherode palung'wi nia hami akwe, ikmutukila nukumumda, nukumutagala inguo ninza uYesu sunga ikamususha kung'wa Pilato. ");
INSERT INTO isn_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herode nu Pilato ikatula ikihumbashuya kandilya uluhiku lulo, ntongeela apa ng'wanso aialemanilye. ");
INSERT INTO isn_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Upilato akaitanga iakuhani niakulu nilongeeli niamilundo na antu. ");
INSERT INTO isn_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Akaaila mandetela umuntu uyu, anga muntu nuiatongeela awa niyituma imabi, hangi gozi namukolekelya pa ntongeela anyu, singa naona igazo ku muntu uyu ku nkani yihi inazamenda musemela nuinso. ");
INSERT INTO isn_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Kutile, ang'wi Herode, kunsoko wamususha kitaitu, inangi kutile kintu kihi nikibi naiwitumile nakihumile kutule apegwe ulamulwa wa nsha. ");
INSERT INTO isn_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kululo kumupa ulamulwa nukumutunguila. ");
INSERT INTO isn_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Itungili, Upilato ukumulekela mutungwa ung'wi kua yahudi matungo na mahiku aulumbiili. ");
INSERT INTO isn_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ingi ihi akazogolya palung'wi, akazelunga,''Muheje uyu, hangi kuluguilye ubaraba.'' ");
INSERT INTO isn_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ubaraba ai muntu nauikilwe kukitungo kunsoko au sambo mukisali palung'wi nuubulagi. ");
INSERT INTO isn_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Upilato akaila hangi, ndalwe kumuleka uYesu. ");
INSERT INTO isn_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kululo nianso akakulya iyogo agigwe agigwe. ");
INSERT INTO isn_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Akaakolya katatu, akaila umuntu uyu witumile mabiki? Naulya igazo nilihumile kumutwala muulamutwa wa nshaakwe, kululo ingankondye kupumya uulamulwa kumulekela. ");
INSERT INTO isn_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Akitwita kua ngulu, akalowa agig'wa, induli yao ikampembeselya upilato. ");
INSERT INTO isn_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Upilato akaaila mitumi anganimuonee. ");
INSERT INTO isn_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Akamutunguila uyu nautungilwe kukitingo kunsoko akusingizeeligwa kituma ubi nu kubalaga. Uyu naumuloilwe, akamupunya uYesu amitumile nialoilwe. ");
INSERT INTO isn_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Naiakumuheja ikamuamba muntu ung'wi, Simoni Mkirene, naupimie kumugunda, ikamutika ikota la mpanga amutyale uYesu. ");
INSERT INTO isn_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Milundo mkulu nuantu, niasungu idu naiahumilwe ikinya uwayi nukuhongeelya kunsoko akwe, ai amutyatile. ");
INSERT INTO isn_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Akaa pilukila akaaila, Ananso niamu Yerusalemu, leki kundiili unene, iliili unyenye niana anyu. ");
INSERT INTO isn_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Goza imahiku apembilye,''niazelunga, akembetwa iagumba ni nda nishayiluga nimaele aya nisinga aiankilye. ");
INSERT INTO isn_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Pang'wanso azetula maila imalugulu, kugwili, ana malugulu kukunikili. ");
INSERT INTO isn_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ang'wi akituma nkanizizi mu mti nutotu ukatula uli mu mti nuwumo? ");
INSERT INTO isn_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Intunja abiili hangi niansambo aiatwawe palung'wi nung'wenso ende abulagwe. ");
INSERT INTO isn_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Naipaka apo niitangwa ing'ang'a Iitwe, ikatula maja palung'wi niasambo, ung'wi mukono nuakigiha numuya mukono nua kikima. ");
INSERT INTO isn_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Uyesu akahinga, Tata alekole kunsoko shangaalikile niakituma. Nienso ikaku ialo ahume kugalana imyenda akwe. ");
INSERT INTO isn_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Iantu ainukile akazeagozeeye kunu iatemi akazemumela, akazelunga, aiwiaguna niangizeo, itungili nigune nung'wenso, ang'wi nuanso Kristo wang'wi, Itunda, naushaguwe. ");
INSERT INTO isn_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Iahomi neonso ikamudalaha, Ikamuhugeela ikamupa inkungu. ");
INSERT INTO isn_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ikalunga, ang'wi uewe wimu temi wayahudi igune uewe. ");
INSERT INTO isn_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Aikikoli hangi kilingasiilyo migulya akwe naikiandikilwe, ''UYU NGWENSO MUTEMI WAYAHUDI”. ");
INSERT INTO isn_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ung'wi wa Sambo naukagigwa akamutuhila akalunga, uewe wi Kristo? Iguno uewe nu sese. ");
INSERT INTO isn_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ingi gwa umuya akasusha, akamukenela akalunga, uewe shumogopile ne Itunda? nuewe ukoli mulamulwa wuwo wuwo? ");
INSERT INTO isn_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Use kukoli kutai, Kunsoko usese kusingiilya iko nikimpyani ni ntendo yitie ingi umuntie uyu shawitumile anga kintu kihi nikibi. ");
INSERT INTO isn_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Hangi akongeelya, Yesu unkimbuke nukingila mutemi wako. ");
INSERT INTO isn_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Uyesu akamuila, huila kuila ilelo iyi ukutula palung'wi nunene kuparadiso. ");
INSERT INTO isn_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ainugee kutula matungo mutandatu, ihe ihi ikakunikilwa ni kiti sunga imatungo kenda ikapika. ");
INSERT INTO isn_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Uwelu wa lyoa ukalima, sunga ung'wenda nuitekeelo ukatamuka pakati kandiilya migulya. ");
INSERT INTO isn_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Akalila kua luli lukulu, Uyesu akalunga, Tata mumikono nako, namiika inkolo ane, naiwaligitya aya akasha. ");
INSERT INTO isn_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Matungo uakida naiwaona ayo naitumilwe akamukolya Itunda akalunga, itai uyu ai muntu wa tai. ");
INSERT INTO isn_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Matungo umilundo wa antu naiazile palung'wi kihenga naiaona ayo naitumilwe, ikasuka akaze kuaga ikue yao. ");
INSERT INTO isn_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ingi gwa iahumba uya akwe, niasunga ikamutatya kupuma kugalilaya, akimika kuli akazegoza ayo naitumilwe. ");
INSERT INTO isn_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Goza aukoli muntu nai witangwa Yusufu nai muntu wianza, Muntu muza nuatai. ");
INSERT INTO isn_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Akili kigombya ni ntendo yao, kupuma Armathaya kisali ka kiyahudi uo naizaulindie utemi wang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Umuntu uyu, akamuhugeela upilato, akalompa apeng'we umuili wang'wa Yesu. ");
INSERT INTO isn_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Akausimya hangi akaukumba isanda akauka mukibiila naikimbihiimbilwe mungwe, omo naizakili muntu wihi kuikwa. ");
INSERT INTO isn_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","luhiku la kunonelya ni Sabato ahugeela. ");
INSERT INTO isn_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Iasungu, naiazile kupuma Kugalilaya, aiamulyatile ikibiila nu muili wakwe naiulalikigwe. ");
INSERT INTO isn_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Akasuka ikatula nonelya imakuta nakunyunkilya. Sunga luhiku la sabato akasupya anga naiza malagiilyo ao. ");
INSERT INTO isn_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Aikili dau luhiku la ng'wandyo nuli juma, akaza pa kibiil, akaleta imakuta nkunyunkiila naamanoneeye. ");
INSERT INTO isn_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Akahanga igwe lapilingitigw lend kulini kibiila. ");
INSERT INTO isn_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Akingila mumo, shangaikaukauhanga umuili wang'wa Yesu. ");
INSERT INTO isn_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Matungo nanso ikatula nimasugo makulu na lukani ulu, akaona antu abiili kazemikile pakati ao akazeatugae myenda nakumiligita. ");
INSERT INTO isn_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ia sangu akazeiwe uwoa, akatunya usu pihi, akaaila asungu. Kuniki mukumuduma uyu numupanga muashi? ");
INSERT INTO isn_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Wikutile apa ingi wauka kembuki nauligitilye nunye naukoli ku Galilaya. ");
INSERT INTO isn_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Akalunga kina ung'wana wang'wa Adamu ukupumigwa mumikano antu niakite imilandu hangi agigwe nuhihiku la mtandatu ukuuka hangi. ");
INSERT INTO isn_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ia sangu nianso ikakimbuka inkani nianso. ");
INSERT INTO isn_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ikasuka kupuma kukibiila ikaaila aya ihi ao ni kumi nung'wi ningiza ihi. ");
INSERT INTO isn_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ingi Maria Magdalena, Joana, Maria nyinya wang'wa Yakobo, niasungu niangiza palung'wi nienso ikapumya inkani inzi kuitumi. ");
INSERT INTO isn_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ingi gwa ulukani uhu lukatula anga lanakanda udu kuitumi, hangi shanga ikahuila ia sungu nianso. ");
INSERT INTO isn_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Upatoo akauka, akamanga akahonga kukibiila akahungiila akagoza mukati, akaona isanda akwe du, sunga Petro akahega akenda kitalakwe, akazutite ikilwa kwa iko nikipumie. ");
INSERT INTO isn_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Antu abiili akalongola uluhiku lulolulo kukisali nikitangwa Emmau lugendo la matungo abiili. ");
INSERT INTO isn_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Akatuli kolya ienso kua enso ayo ihi naupumie kung'wanso. ");
INSERT INTO isn_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Imatungo nanso naiakili akikolya, Uyesu aka hugeela pakupi akatula palung'wi nienso. ");
INSERT INTO isn_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Imiho ao ikakuwa upoku aleke kumumunya. ");
INSERT INTO isn_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Uyesu akaila unye nimiabiili mendi ila ule nimukugenda? akasiga imikile kunu akaziatile kinyauwai. ");
INSERT INTO isn_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Muntu ung'wi lina lakwe Cleopa, akasusha, uewe du ne apa pa Yerusalemu nishuine aya naapumie kung'wanso imahiku aya? ");
INSERT INTO isn_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Uyesu akaaila, makani ke? akamuila aya nang'wa Yesu mnazareti uyu nai munyakidagu, muhumi nua witumi ni nkani ntongeela ang'wi Tunda niantu ihi. ");
INSERT INTO isn_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Anga iakulu niakuhani nia tongeeli itu naamupunilye mulamulwa wa nsha nukumaja. ");
INSERT INTO isn_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ingi gwa aikuluile kina uyu yuyu nuzeapa ulekelwa Israel. kulinaya ihi itungili luhiku la katatu inkani izi niyigee. ");
INSERT INTO isn_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kululo gwa lasungu kupuma kitaile akupee ikaiilwa, naikoli pakibiila ikidaudau. ");
INSERT INTO isn_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Naiaulya umuiili akwe, akaza akazelunga kina aiaine wa malaika naialiye kina ukoli mupanga. ");
INSERT INTO isn_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Iitunja ao naiakoli palung'wi nusese ikenda pakibiila, ikahanga anga iasungu naialigitilye, ingi singaaia muine nuanso. ");
INSERT INTO isn_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Uyesu akaaila, unye antu nimiapungu nimukite inkolo ni ndito nishaya kuhuila ihi ayo nianyakidagu aliiye. ");
INSERT INTO isn_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ingi aitulikili uyesu kagigwa ku nkaai izi, nukingila kuukulu wakwe. ");
INSERT INTO isn_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Sunga kandiilya kung'wa Musa nianyakidagu ihi, akaakunukuila aya ihi naakoli muandike wihi nuakwe. ");
INSERT INTO isn_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Naahugela mukisali iko, akazialongoe, Uyesu akatula anga kili ulongoe kuntongeela. ");
INSERT INTO isn_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kuite aiamusingilya azeligitya, ikie palung'wi nusese kundogoelyo ilongolekile mpindi nuluhiku anga laula. Itegwa u Yesu akingila kulongola kikie nienso. ");
INSERT INTO isn_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Matungo naiikie nienso akazilya, akahola umkate, akaukembeta nukuega akaapa. ");
INSERT INTO isn_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Sunga imiho ao ikakuwukulwa ikamulinga, matungo makupi akalimila mumiho ao. ");
INSERT INTO isn_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Akatula kitambulya enso iti inkolo yitu shaaza yakie na mukati itui, matungo naukuligitya nusese munzila, naukukunukuilye ayo naandikilwe. ");
INSERT INTO isn_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ikauka itungo lilolilo, ikasuka ku Yerusalemu. Ikaahanga ao ni kumi nung'wi akazeilingie palung'wi nao naine pang'wanso. ");
INSERT INTO isn_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Akazilunga, wauka itaitai, hangi aza wigeelekili kung'wa Simoni. ");
INSERT INTO isn_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kululo ikaila ayo naiamaine munzila, ayo nu Yesu naiwigeelekile kitalao kuuega umukate. ");
INSERT INTO isn_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Naakili akuligitya inkani nianso, u Yesu akimika pakati ao, hangi akaila, upolo utule nunye. ");
INSERT INTO isn_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Aiogapile akazuilwe nuwoa, ikasiga kina azaamuine ng'waungwelu. ");
INSERT INTO isn_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","U Yesu akaaila kuniki nimukusiga? Kuniki makolyo akuuka munkolo yanyu. ");
INSERT INTO isn_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Gozi imikono ane ni migulu ane, muone kina ingi nene. Mambi muone. Kunsoko inkolo ngila anga nyama ni makupa, anga nimuona unene kutula ninyenso. ");
INSERT INTO isn_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Naiwakondya kulunga iti, akaalagiila imikono akwe nimigulu akwe. ");
INSERT INTO isn_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Akaziakili akite ulumbi nauhali inkanile nukuhite kuhuila nu ukuilwa u Yesu akaila, mukate kintu ne ni kakulya? ");
INSERT INTO isn_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Akamupa nsamaki iegile ikaziasile. ");
INSERT INTO isn_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","U esu akahola akalya pantongeela ao. ");
INSERT INTO isn_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Akaaila, “Nainkoli nunye, ainumuie kina ihi naandikilwe munonelya wang'wa Musa nianyakidagu ni zaburi ingi mpaka akondaniile.” ");
INSERT INTO isn_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Sunga akalugula imahala ao, ahume kulinga ayo nandikilwe. ");
INSERT INTO isn_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Akaaila yandikilwe kina, “Ukilisto mpaka agigwe, nukuuka hangi kupuma muashi uluhiku lakatatu. ");
INSERT INTO isn_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Uungami nuulekelwa wamilandu utanantigwe kulina lakwe kumahi ihi kandiilya ku Yerusalemu. ");
INSERT INTO isn_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Unye miikengi ankani izi. ");
INSERT INTO isn_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Goza, kumutwailya ulagwa wang'wa Tata ane kitalanyu, kululo lindili hapo pakisali, sunga nimuzetugalwa ingulu kupuma kigulya. ");
INSERT INTO isn_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Sunga u Yesu akatongeela kunzi mpaka naiahugeela ku Bethania. Akahumbula imikono akwe migulya, akaakembeta. ");
INSERT INTO isn_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Matungo naukuakembeta, akikie wing'wene akaholwa migulya kilunde. ");
INSERT INTO isn_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ikamukulya hangi ikasuka ku Yerusalemu ni lumbi ikulu. ");
INSERT INTO isn_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Akasiga akoli mitekeelo akazemukulya Itunda. ");
INSERT INTO isn_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ung'wandyo ai lukoli lukani, nu lukani ai latulaa palung'wi ni Itunda, nu lukani ai latulaa Itunda. ");
INSERT INTO isn_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Uyu, u lukani, Ung'wandyo ai watulaa palung'wi ni Itunda. ");
INSERT INTO isn_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","I intu yihi ai itumilwe ku ng'wenso, ni anga ihite kutula ng'wenso kutili ga ni kintu king'wi nai katulaa kitumilwe. ");
INSERT INTO isn_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mukati akwe ai ukoli u upanga, nu uwo upanga ai watulaa welu nu a ana adamu ihi. ");
INSERT INTO isn_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Welu welyaa mu kiti, ang'wi i kiti shanga ukaulimisa. ");
INSERT INTO isn_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ai ukoli u muntu nai ulagiigwe kupuma kung'wa Itunda, niiza ilina ni lakwe ai watulaa Yohana. ");
INSERT INTO isn_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ai wazile anga mukuiili kukiila kutula uwo u welu, iti kina ihi ahume kuhuiila kukiila ng'wenso. ");
INSERT INTO isn_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","U Yohona shanga ai uwo u welu, ila ai uzile iti wakuiile kutula uwo u welu. ");
INSERT INTO isn_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Iyo ai ayulaa welu nua tai naza utuile uzile mu ihi ni nyenso wimuikila welu kila u ng'wi. ");
INSERT INTO isn_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ai watulaa mihi, ni ihi ai iumbilwe kukiila ng'wenso, ni ihi shanga ai limumanyile. ");
INSERT INTO isn_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ai uzile ku intu ni akwe, ni antu ni akwe shanga ikamusingiilya. ");
INSERT INTO isn_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ila ku awo ni idu nai amusingiiye, naza alihuiie i lina ni lakwe, ku awo ai uikiiye tai ane ni akutula ana ang'wi Itunda. ");
INSERT INTO isn_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Naza aleilwe shanga ku sakami, ang'wi ku ulowa nua muili, ang'wi ku ulowa nua muntu, ila kung'wi Itunda mukola. ");
INSERT INTO isn_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nu ng'wenso u lukani ai wizipiilye muili hangi akikie mukati itu, ka wihengilee ikulyo ni lakwe, ikulyo anga ni la muntu nu ing'wene nua kinyena nai uzile kupuma kung'wa Tata, wizue ukende nua tai. ");
INSERT INTO isn_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","U Yohana ai ukuiie kutula ung'wenso, nu kitunta ku luli azeligitya, “Uyu yuyoo niza niligitya i nkani niakwe nizeligitya, “Uyo nuzile ze yakilaa unene inge Mukulu kukila unene, kunsoko iiza ukoli ze ikili unene”. ");
INSERT INTO isn_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kunsoko kupuma mu ukondaniili nu akwe, usese kihi kusingiiye nankanda u uhumi ze yakilaa nia uhumi. ");
INSERT INTO isn_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kunsoko ilagiilyo ai liletilwe kukiila Musa, u ukende ni tai ai izile kukiila Yesu Kristo. ");
INSERT INTO isn_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kutili u ng'wana adamu nai umihengile Itunda matungo ihi, muntu wing'wene niiza inge Itunda, nuili mu kikua kang'wa Tata, umizipilye ung'wenso wamanyike. ");
INSERT INTO isn_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nu uwu wuwu ukuiili nuang'wa Yohana matungo i Akuhani ni Alawi nai alagiigwe kitalakwe ni Ayahudi kumukolya “uewe inge nyenyu?”. ");
INSERT INTO isn_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Bila kisinsila hangi shanga ai uhitile, ila ai usukiiye, “Unene shanga Kristo”. ");
INSERT INTO isn_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Uu gwa akamokolya, “ku lulo uewe inge nyenyu itungili?” Uewe inge Eliya? Akaligitya, “Unene shanga” Akaligitya, uewe inge munyakidagu? Akasukiila “A aa”. ");
INSERT INTO isn_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Uu gwa akamuila, “uewe inge nyenyu iti kina kuinkiilye isusho naza akulaagiye? Ukikuiila uli uewe mukola?” ");
INSERT INTO isn_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Akaligitya, “ Unene inge luli nu lakwe nui lilaa muwii, “Migooli i nzila a mukulu! anga munyakidagu Isaya nai uligitilye.” ");
INSERT INTO isn_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Uu gwa ai akoli ni antu alagiigwe kupuma pang'wanso kupuma ku Afalisayo. Akamukolya nu kuligitya, ");
INSERT INTO isn_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25",": ku niki ukoja gwa angize uewe shanga wi Kilisto ang'wi Eliya ang'wi munyakidagu? ");
INSERT INTO isn_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","uYohana ai uasukiiye azeligitya: Nukoja ku mazi, Ga ni iti, mukati anyu wimikile muntu ni shanga mumulingile. ");
INSERT INTO isn_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Uyu yuyo nupembilye ze yakilaa unene, Unene ni mugila uhumi nuakutolya i mikoha a ilatu niakwe, ");
INSERT INTO isn_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Makani aya ai atulikile uko ku Bethania, itumbi nila Yordani, kianza naiza uYohani ukoli ukoja. ");
INSERT INTO isn_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Luhiku nai lutyatile uYohana akamihenga uYesu upembilye kung'waakwe akaligitya, Goza ung'waa nkolo wang'wa Itunda nuiuhola umulandu nua unkumbigulu! ");
INSERT INTO isn_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","uyu yuyo naindigitilye inkani niakwe nizeligitya, Nuanso nupembilye kituli kane inge mukulu kukila unene, kunsoko ai watuile zeikili unene, ");
INSERT INTO isn_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Shanga ai numulingile ung'wenso, kuiti aiitulikile nanso kina akunukulwe mukati a Israeli, kina ainzile nikazeoja ku mazi, ");
INSERT INTO isn_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","uYohana ai ukuiie, “Ai nihengile uNg'wau Ng'welu ukusima kupuma kilunde mpyani a nkuni nu kusiga migulya akwe. ");
INSERT INTO isn_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Unene shanga ai numulingile, kuiti nuanso nai undagiiye iti noje ku mazi ai untambuie, “uyo nize ukihenga Ug'wau Ng'welu ukusima nu kikie migilya akwe, Nuanso yuyo nuojaa ku Ng'wau Ng'walu, ");
INSERT INTO isn_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nihengaa nu kukuiila kina uyu ige ng'wana wang'wa Itunda,” ");
INSERT INTO isn_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Hangi luhiku nai lutyatile uYohana aiukoli wimikile nia manyisigwa akwe abiili, ");
INSERT INTO isn_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ai amihengile uYesu ukugenda nu Yohana akaligitya, “Goza, uNng'waa nkolo nuang'wa Itunda” ");
INSERT INTO isn_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Amanyisigwa abiili ai amigulye uYohana ukuligitya aya akamutyata uYesu. ");
INSERT INTO isn_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Hangi uYesu ai upilukile nu kuihenga iamanyisigwa awo amutyatile, nu kuaila, “Muloilwe ntuni?” Akamusukiilya, Rabbi, ( ndogoelyo akwe ng'walimu;) wikiee pii?” ");
INSERT INTO isn_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Aka atambuila, “pembyi nu kihenga. “Uugwa ai alongoe nu kihenga i kianza nai wikiee; akikie palung'wi nu ng'wenso u luhiku nulanso, kunsoko aiyatulaa yapikiila saa ikumi iti. ");
INSERT INTO isn_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ung'wi nua awo ni abiili nai amigulye uYohana ukutambula ni uugwa kumutyata uYesu ai utuile inge Andrea, muluna akwe uSimoni Petro. ");
INSERT INTO isn_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Akamihenga muluna akwe uSimioni nu kumutambuila,”Kamulijaa uMasihi” (niiza impyanigwe Kristo). ");
INSERT INTO isn_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Akamuleta kung'wa Yesu. uYesu akamugoza nu kuligitya, Uewe wi Simioni ng'wana wang'wa Yohana” wikitangwa Kefa” ( ndogoelyo akwe 'Ptro') ");
INSERT INTO isn_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Luhiku nai lutyatile itungo uYesu nai wahia kuhega kulongola kuGalilaya, ai umuligilye uFilipo nu kumuila, “Ntyate unene.” ");
INSERT INTO isn_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","uFilipo aiwatulaa mukola ihi nua kuBethasaida, kisali kang'wa Adrea nu Petro. ");
INSERT INTO isn_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","uFilipo ai umuligilye uNathanaeli nu kumuila, Kamulijaa uyo naiza uMusa ukilisilye inkani niakwe mu malagiilyo nu Unyakidagu, Yesu ng'wana awng'wa Yusufu, kupuma kuNazareti. ");
INSERT INTO isn_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","uNathanaeli akamuila, ''Itii kintu ni kiziza kihumile kupembelya kuNazareti?” uFilipo akamuila, “Nzuu nu kihenga.” ");
INSERT INTO isn_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","uYesu akaamihenga uNathanaeli upembilye kung'waakwe nu kuligitya, “Goza uMuisraeli tai taai ni mugila u ukongelwa mukati akwe|” ");
INSERT INTO isn_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","uNathanaeli akamuila, “Uningile kinyauli unene?” uYesu akamusukiilya nu kumuila, Aza ikili uFilipo kuitanga naza ukoli pihi pi ikota, aza nakihengaa.” ");
INSERT INTO isn_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","uNahanaeli akasukiilya, “Rabi uewe wi Ng'wana wang'wa Itunda| Uewe wi Mutemi nua Israeli”| ");
INSERT INTO isn_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","uYesu akasukiilya akamuila, Kunsoko nukuiie aza 'nukihengile pihi i kota' itii wahuiila? ukihenga ntendo nkulu kukila izi.” ");
INSERT INTO isn_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","uYesu akaligitya, “Huiili huiili kumuili mikihenga ilunde likuluguka, nu kuihenga iamalaika akunankila nu kusima migulya a Ng'wana wang'wa Adamu.” ");
INSERT INTO isn_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ze yakilaa mahiku a taatu, ai ukoli winga uko ku Kana a Galilaya nu Nyinya wang'wa Yesu ai ukoli kuko. ");
INSERT INTO isn_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","uYesu ni amanyisigwa akwe ai atulaa anilwe mu winga. ");
INSERT INTO isn_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Itungo nai auilwa i magai, u nyinya wakwe uYesu akamuila, “Agila i magai.” ");
INSERT INTO isn_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","uYesu akasukiilya, Musungu ni kanso kintuile ntuni unene? Itungo ni lane likili kupikiila,” ");
INSERT INTO isn_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","uNyinya nuakwe akaaila, “Kihi nuikamuila itumi.” ");
INSERT INTO isn_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","U ugwa ai ikoli ni ntunda mutandatu ni a magwe pang'wanso nai iekilwe kunsoko a ku kalala mu mahiku a Ayahudi, kila ing'wi ai ikete wizulyo nua nzio ibiili, itaatu. ");
INSERT INTO isn_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","uYesu aka aila, Izulyi imazi intunda nia magwe, “akizulya ga nu migulya. ");
INSERT INTO isn_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Uugwa aka aila awo ianya mulimo, “Holi ngele itungili nu kutwala ku mua aiilya nu mukulu nua meza. “'Akituma anga naza ualagiiye. ");
INSERT INTO isn_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Muaiilya nu mukulu ai umaluilye imazi ayo nai atulaa akailikaa nu kutula magai, ila shanga aiulingile kapumile (kuiti ianyamulimo naza atepile imazi ai alingile kai apumile). Uugwa akamitanga umukulu nua winga nu ");
INSERT INTO isn_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","kumuila, kila ung'wi wandya kuagiza i antu imagai ni maziza ni anga agale wiagiza imagai ni shanga maziza. Kuiti uewe umaikile imagai ni maziza kupikiila itungili” ");
INSERT INTO isn_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","U ukuilwa uwo nua ku Kana a kuGalilaya, ai watulaa wuwo ng'wandyo nua mpyani nia ukuilwa nuang'wa Yesu, azekunukula ikulyo nilakwe, itigwa ia manyisigwa akwe akamuhuiila. ");
INSERT INTO isn_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ze yakilaa izi, uYesu, Nyinya nua kwe, aluna akwe ni amanyisigwa akwe ai alongoe mu kisali nika Kapernaumu nu kikie kuko ku mahiku masheenyu. ");
INSERT INTO isn_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Uugwa ipasaka a Ayahudi ai ahumbeela, itigwa uYesu akalongola ku Yerusalemu. ");
INSERT INTO isn_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Aka ahanga ia gulya a ng'ombe, nkolo, ni nkunda mukati Itekeelo. Ga nia kaila mpia ai akoli ikie mukati Itekeelo. ");
INSERT INTO isn_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Uyesu akanonia umikoha ukete makundo, aka apumya ihi nai amoli mukati Itekeelo, ize ihanguie ng'ombe ni nkolo. Akahunula impia ni ya akaila mpia nu kuipiula i meza niao. ");
INSERT INTO isn_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ku agulya kunda aka aila, “Pumyi i intu izi kuli ni kianza iki, leki kulitendi ito ni lang'wa Tata nu ane kutula kianza ki soko” ");
INSERT INTO isn_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Amanyisigwa akwe akakimbukiilya kina ai yatulaa ikilisigwe, “Wilu nu ito ni lako likundya.” ");
INSERT INTO isn_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Akulu ni a Ayahudi akasukiilya, akamuila, Inge kilingasiilyo kii nu kulagiila kunsoko ukituma imakani aya?” ");
INSERT INTO isn_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","uYesu aka asukiilya, Ligumuli Itekeelo ili nu nene kulizenga ze yakilaa mahiku ataatu.” ");
INSERT INTO isn_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Uugwa Akulu a Ayahudi akaligitya, “Ai ikuhoile miaka makumi anne na mutaandatu kulizenga Itekeelo ili nu ewe ukuligitya ukulizenga ku mahiku ataatu?” ");
INSERT INTO isn_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ga ni iti, nuanso ai utambue itekeelo aze usigiie muili nuakwe. ");
INSERT INTO isn_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Iti gwa panyambele ze yakilaa kiuka kung'waakwe kupuma kuashi, ia manyisigwa ni akwe akakimbukiilya kina ai uligitilye nianso, akahuiila uukilisigwa ni ntambu naiza uYesu wakondilyee kumiligitya. ");
INSERT INTO isn_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Uugwa nai watulaa ku Yerusalemu matungo a pasaka, itungo nila sikukuu antu idu ai ahuiie i lina ni lakwe. nai ihengile i ilingasiilyo ni a ukuilwa nai witumile. ");
INSERT INTO isn_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kuiti uYesu ai mugila u uhuiili ni enso ku nsoko ai ualingile i ana adamu i hi. ");
INSERT INTO isn_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Shanga ai utakile muntu wihi kumuila kutula ni ili i ana adamu kunsoko ai ulingile nai kimoli mukati ao. ");
INSERT INTO isn_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Uugwa ai ukoli nu Afarisayo nai iza ilina nilakwe Nikodemo, ung'wi nua anyampala ni i anza nila Ayahudi. ");
INSERT INTO isn_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Muntu uyu ai umuhangile uYesu utiku nu kumuila, “Rabi, kulingile kina wi ng'walimu kupuma kung'wa Itunda, ku ndogoelyo kutili u muntu nu humile kituma izi yihi Itunda aze wikutili palung'wi nu ng'wenso.” ");
INSERT INTO isn_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","uYesu akamusukiilya, “Huiila huiila, shsnga uhumile u muntu kingila mu utemi nuang'wa Itunda anga wahite kutugwa nkua a kabiili.” ");
INSERT INTO isn_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","uNikodemo akaligitya, “Umuntu uhumile uli kutugwa aze mnyampala? Shanga uhumile kingila munda ang'wa nyinya nuakwe nkua a kabiili nu kutugwa, itii uhuile uli?” ");
INSERT INTO isn_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","uYesu akasukiilya, “Huiila huiila muntu anga wahite kutugwa ku mazi nu ku Ng'wau Ng'welu, shanga uhumile kingila mu utemi nuang'wa Itunda. ");
INSERT INTO isn_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ni kitugilwe ku muili inge muili, hangi nikitugilwe ku nkolo inge nkolo. ");
INSERT INTO isn_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Leka ku kuilwa kunsoko aza nakuilaa, inge kusinja kutugwa nkua aka biili. ");
INSERT INTO isn_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ung'wega wikunkaa pihi ku uloilwe nu luli nu lakwe mulijaa, kuiti shanga mulingile kuupumiie nuko ku ulongoe. Uugwa ni yili i hali a kila nutugilwe nu Ng'wau Ng'welu. ");
INSERT INTO isn_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","uNikodemo akasukiilya, ku kuligitya, “Makani aya ahumikile uli?” ");
INSERT INTO isn_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","uYesu akasukiilya, “u ewe wi ng'walimu nua Israeli shanga ulingile ga ni makani aya? ");
INSERT INTO isn_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Huiila, huiila, nu kuuila, iko ni kukilingile kuuki kuiila ku iko ni kuki hengile. kuiti shanga mukusingiilya u ukuili nu itu. ");
INSERT INTO isn_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Anga ize namuilaa imakani aya apa mihi shanga mu huiie, muhumile uli kuhuiila anga numuile imakani na kilunde? ");
INSERT INTO isn_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ndogoelyo kutili nai unankie migulya kupuma kilunde kwaala ng'wenso nai usimile, uNg'wana wang'wa Adamu. ");
INSERT INTO isn_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Anga uu uMusa nai umiyansue inzoka mi bambazi, u uu uNg'wa nu ang'wa Adamu kusinja wanyansulwe, ");
INSERT INTO isn_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","iti kina ihi ni ika muhuiila alije u upanga nua kali na kali. ");
INSERT INTO isn_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ku ndogoelyo iyi Itunda ai u uloelwe u unkumbigulu, kina akamupumya u ng'wana nu akwe nu ing'wene, iti kina muntu wihi nu muhuiie waleke kulimila ila watule nu upanga nua kali na kali. ");
INSERT INTO isn_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ku nsoko Itunda shanga ai umulagiiye ung'wana nu akwe mihi iti aulamule u unkumbigulu, ila kina u unkumbigulu ugunike mung'wa akwe. ");
INSERT INTO isn_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nu muhuiie nuanso shanga ukulamulwa. Nuanso ni shanga umuhuiie yakondaa walamulwaa ku nsoko shanga ulihuiie i lina nila Ng'wana wing'wene nuang'wa Itunda. ");
INSERT INTO isn_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Iyi yiyo nsoko a ulamulwa, nia kina u welu ai uzile mu unkumbigulu, kuiti iana adamu akalowa kiti ikilo a welu ku nsoko ntendo ni ao ai yatulaa ya ubii. ");
INSERT INTO isn_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kila muntu nuitumaa u ubii wibipilwaa u welu ni iti shanga uzile mu welu iti kina intendo niakwe ileke kuikwa ng'walyi. ");
INSERT INTO isn_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kuiti, nuanso nuitumaa i tai wizaa mu welu iti intendo niakwe igeeleke kina yitumilwe ku ikulyo ni lang'wa Itunda. ");
INSERT INTO isn_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ze akilaa aya, uYesu palung'wi ni amanyisigwa akalongola mihi a Yudea. Kung'wanso ai utumie itungo palung'wi ni enso hangi ai watulaa ukoja. ");
INSERT INTO isn_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Itungili ga nu uYohana ai watulaa ukoja uko ku Ainea pakupi ni Salam ndogoelyo ai akoli ni mazi idu pang'wanso. Antu ai atulaa akupembya kitalakwe nu kogigwa, ");
INSERT INTO isn_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ku nsoko uYohana ai watulaa wakili kugung'wa mu kadulumu. ");
INSERT INTO isn_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Uugwa ai ipumie wikungumi mu amanyisigwa ang'wa Yohana ni Ayahudi kutula siku kuu nia weligwa. ");
INSERT INTO isn_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Akalongola kung'wa Yohana akamuila, “Rabi, nuanso naza mine nu ng'wenso kitumbi nila mongo nua Yordani, Ng'wenso nai ukuiie i nkani ni akwe, goza, ukoja ni ihi akulongola akumutyata.” ");
INSERT INTO isn_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","uYohana akasukiilya umuntu shanga uhumile kusingiilya kintu kihi kwaala anga ize winkiiigwe kupuma kilunde. ");
INSERT INTO isn_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","uNyenye akola mikuiila kina aindigitilye kina, 'unene shanga ni kilisto; badala akwe ai ndigitilye, 'ndagiigwe ntongeela akwe.' ");
INSERT INTO isn_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nuanso nuine nu mutiziila ingi mukulu nua winga. Itungili umuhumbamuya nuang'wa mukulu nua winga, nuimikaa nu kutegeelya wiloeelya lukulu kunsoko a luli nula mukulu nua winga. Uwu itungili ingi ulowa nu ane ni ukondaniie. ");
INSERT INTO isn_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Utakiwe kukilinkiila nu nene ntakiwe kukepa. ");
INSERT INTO isn_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nuanso nu pembeeye migulya, ukoli migulya a ihi. Nuanso nua unkumbigulu upumiie mu unkumbigulu hangi wiligitya makani a kinya unkumbigulu. Nuanso nupembeeye kilunde ukoli migulya a yihi. ");
INSERT INTO isn_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nuanso wikuiila ayo nuihengile nu kigiilya, kuiti kutili nuisingiilya u ukuiili nu akwe. ");
INSERT INTO isn_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nuanso nai usingiiye u ukuiili nuakwe ukomaniigwe kina Itunda ingi watai. ");
INSERT INTO isn_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ku nsoko nuanso nai ulagiingwe ni Itunda wiligitya makani ang'wa Itunda. Ku nsoko shanga wiminkiilya uNg'wau ng'welu nua ngele. ");
INSERT INTO isn_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","uTata wimulowaa ung'wana hangi uminkiiye i intu yihi mu mikono akwe. ");
INSERT INTO isn_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nuanso numuhuiie uNg'wana ukete u upanga nua kali na kali, Kuiti ku ng'waakwe ni shanga ukumukulya uNg'wana shanga ukuihenga u upanga nua kali na kali, ila ikuo ni lang'wa Itunda liambinkanaa migulya akwe. ");
INSERT INTO isn_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Uugwa uYesu nai walinga kina iAfarisayo ijaa kina uYesu ai watulaa ukumanyisa nu kuoja ikilo ni lang'wa Yohana ");
INSERT INTO isn_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Anga itule uYesu mukola ai watulaa shanga ukoja ila amanyisigwa akwe). ");
INSERT INTO isn_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ai upumile ku Judea nu kulongola kuGalilaya. ");
INSERT INTO isn_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Iti ai ituile ingulu kukiila ku Samaria ");
INSERT INTO isn_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5",". Nu kupikiila mu kisali nika Samaria, nikitangwaa Sikari, pakupi ni kitongo niiza uYakobo ai uminkiiye u ng'wana nuakwe uYusufu. ");
INSERT INTO isn_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ni kilungu ni kang'wa Yakobo ai kikoli pang'wanso. uYesu ai watulaa wakatala kunsoko a muhinzo akikie pakupi ni kilungu. Ai yatulaa matungo a mung'wi. ");
INSERT INTO isn_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Musungu ni Musamalia ai uzile kutepa i mazi, nu Yesu akamuila, “Ninkiilye imazi ng'wee.” ");
INSERT INTO isn_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Kunsoko i a manyisingwa akwe ai atulaa endaa yao mu kisali kugula indya. ");
INSERT INTO isn_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","uMusungu nuanso akamuila, “Itulikile uli uewe Muyahudi, kunompa unene musungu ni Musamalia, kintu ni ka kung'wa?” kunsoko iAyahudi shanga i halinkana ni Asamalia. ");
INSERT INTO isn_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Uyesu akamusukiilya, “ Anga ize ulingile u uhumi nuang'wa Itunda, nuyo nukuuila ''ninkiilye i mazi,' aza uzee mulompa, hangi aza uzee kinkiilya mazi a upanga.” ");
INSERT INTO isn_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","uMusungu akamusukiilya, “Mukulu wimugila i ndoo a kutepela, ni kilungu ingi kilipu. Ukuligilya pii imazi na upanga? ");
INSERT INTO isn_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Itii uewe wi mukulu, kukila utata witu uYakobo, naiiza ukinkiiye i kilungu iki, nu ng'wenso mukola ni ana akwe palung'wi ni mitugo akwe akang'wa imazi a kilungu iki?” ");
INSERT INTO isn_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","uYesu akasukiilya, “Wihi nui ng'wezaa imazi aya ukuhung'wa inyota hangi, ");
INSERT INTO isn_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","kuiti nuanso nuikang'wa imazi ni nikaminkiilya shanga ukuhung'wa inyota hangi. Badala akwe imazi ni nikaminkiilya akutula ndiilyo nikuhuma ikali na kali.” ");
INSERT INTO isn_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","uMusungu uyo akamuila, “Mukulu, kumalompa imazi nanso iti ndeke kuhung'wa inyota, hangi ndeke kaga kuza apa kupepa imazi.” ");
INSERT INTO isn_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","uYesu akamuila, “Longola umitange u mugohako, uugwa usuke.” ");
INSERT INTO isn_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","uMusungu akamuila, “Ni mugila mugoha.” uYesu akasukiilya, “Uligitilye iziza, 'Nimugila mugoha;' ");
INSERT INTO isn_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ku ndogoelyo watuilee ni agoha ataano, nuyu nug'wi niiza ukete itungili shanga mugoha wako. Mu ili uligitilye itai!” ");
INSERT INTO isn_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","uMusungu akamuila, “Mukulu nihengaa yakina uewe ingi wimunyakidagu. ");
INSERT INTO isn_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","aTata itu ai ipoelyaa mu lugulu ulu. Kuiti unyenye miligityaa kina iYerusalemu kiko kipango niizaa iantu atakiwe kipoelya.” ");
INSERT INTO isn_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","uYesu akamusukiilya, “Musungu, nihuiile, itungo lipembilye niize shanga muku mukulya u Tata mu lugulu ulu ang'wi ku Yerusalemu. ");
INSERT INTO isn_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Unyenye antu mikikulyaa nikukilingile, ku nsoko u ugunwa wipumaa ku Ayahudi.” ");
INSERT INTO isn_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ga ni iti, itungo lipembilye, nitungili likoli hapa, itungo ni ikulyaa itai akumukulya uTata mu nkolo ni tai, ku nsoko uTata wiadumaa iantu ni a mpyani nanso ku antu akwe ni imukulyaa. ");
INSERT INTO isn_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Itunda ingi Nkolo, hangi awo ni imukulyaa atakiwe kumukulya ku nkolo ni tai ");
INSERT INTO isn_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","uMusungu akamuila, “Ningile kina u Masihi upembilye, (nuitamgwaa Kristo). Nuanso nuikiza ukuutambuila yihi.” ");
INSERT INTO isn_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","uYesu akamuila,” Unene nukuligitya nu nene yuyo.” ");
INSERT INTO isn_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Itungo lilo liilo i amanyisigwa akwe akasuka. Ni enso ai akuiwe ku niki ai watulaa ukuligitya nu musungu, kuiti kutili nai ugemile kumukolya, “Uloilwe ntuni?” ang'wi “Ku niki ukitambulya nu ng'wenso?” ");
INSERT INTO isn_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Iti u musungu akaleka intunda akwe nu kulongola mu kisali nu kuatambuila i antu, ");
INSERT INTO isn_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Pembyi mihenge muntu naza umbiie imakani ane ihii nai nitumile, itii ihumikile watule ng'wenso Kristo?” ");
INSERT INTO isn_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Akapuma mu kisali akapembya kitalakwe. ");
INSERT INTO isn_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Matungo a mung'wi amanyisigwa akwe akamusinja azeligitya, “Rabi lya indya.” ");
INSERT INTO isn_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","kuiti nuanso waka aila, “Unene nkete u ludya ni shanga mulumanyile unyenye.” ");
INSERT INTO isn_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Amanyisigwa akiila, kutili naza wamuletelaa kintu kihi kulya,” Itii aza aletaa?” ");
INSERT INTO isn_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","uYesu aka aila, “Uludya nu lane ingi kituma ulowa nu akwe ng'wenso nai undagiiye nu kukaminkiilya umulimo nuakwe. ");
INSERT INTO isn_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Itii, shanga miligityaa, 'Ikili myeli itaano ni maogola akutula akondaa?' Kumutambuila gozi i migunda ni ikoli ikondile ku maogola| ");
INSERT INTO isn_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Nuanso nui ogolaa wisingiilya i kinyamulimo nu kilingiila inkali kunsoko a upanga nua kali na kali, iti kina nuanso nuitemelaa nu ng'wenso nui ogolaa alowe palung'wi. ");
INSERT INTO isn_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ku nsoko i ntambu iyi a tai, 'Ung'wi witemelaa nu muya wiogolaa.' ");
INSERT INTO isn_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Aza numulagiiye kuogola naiiza shanga muki nyomekee, Auya itumaa milimo nu nyenye mingie mu ulowa nua milimo ao.” ");
INSERT INTO isn_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Asamalia idu mu kisali ni kanso ai amuhuiie ku nsoko a mpola a musungu uyo nai watulaa uku kuilaa, “Naza untambuie imakani ihi nai nitumile.” ");
INSERT INTO isn_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Iti Asamalia nai azile ai amusingilye wikie palung'wi ni enso nu kikie kitalao ku mahiku abiili. ");
INSERT INTO isn_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Hangi idu ikilo akamuhuiila ku nsoko a lukani lakwe. ");
INSERT INTO isn_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Akamuila u musungu uyo, “Kuhuiie shanga udu ku makani ako, ku nsoko usese akola kigulye, ni itungili kamanyaa kina kulu kuulu ng'wenso ingi muguni nua unkumbigulu.” ");
INSERT INTO isn_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ze yakilaa imahiku nanso na abiili, akahega nu kutunga ku Galilaya. ");
INSERT INTO isn_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ku nsoko ng'wenso mukola ai watulaa watanantya kina u munyakidagu mugila ukulu mihi akwe mukola. ");
INSERT INTO isn_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nai wapembya kupuma ku Galilaya, iAgalilaya ai amusingiiye. Ai atulaa ihengile i makani ihi nai witumile ku Yerusalemu mu siku kuu, ku nsoko ni enso ga ai atulaa amoli mu siku kuu. ");
INSERT INTO isn_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ai uzile hangi ku Kana a Galilaya uko kai umakaie imazi kutua magai. Ai ukoli ofisa naiza ng'wana nuakwe mulowae uko ku Kapernaumu. ");
INSERT INTO isn_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nai wakija kina uYesu ai wapumaa ku Judea nu kulongola ku Galilaya, ai ulongoe kung'wa Yesu nu kumusinja wasime wamugune u ng'wana wakwe, naiza watulaa pakupi kusha. ");
INSERT INTO isn_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Uugwa uYesu akamuila, “Unyenye ana muhite kihenga i ilingasiilyo nu ukuilwa shanga muhumile kuhuiila. ");
INSERT INTO isn_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mutongeeli akaligitya, “Mukulu sima pihi ze ikili ung'wana wane kusha. ");
INSERT INTO isn_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","“uYesu akamuila, “Longola ung'waako mupanga.” umuntu uyo akahuiila lukani naiululigitilye uYesu ");
INSERT INTO isn_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nai watula ukusima, anya mulimo akwe akamusingiilya nu kuuila ng'wana nu akwe ai watulaa mupanga. ");
INSERT INTO isn_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Iti aka akolya ingi itungo kii aza uligilye ibahu. Akasukiilya, “Igulo itungo nila saa mutandatu ulwae naza umulekile.” ");
INSERT INTO isn_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Uugwa utata nu akwe wakalinga kina ingi itungo lilo liilo uYesu naza uligitilye, “Ng'wana nuako ingi mupanga.” Uugwa nuanso naa ni anya mito lakwe akahuiila. ");
INSERT INTO isn_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Iki ingi kilingasiilyo ka kabiili nai witumile uYesu nai upumiie ku Yudea kulongola ku Galilaya. ");
INSERT INTO isn_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ze yakilaa pang'wanso ai ikoli i siku kuu a Ayahudi, nu Yesu ai unankie kulongola ku Yerusalemu. ");
INSERT INTO isn_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nu kung'wanso ku Yerusalemu ai ikoli ikunu mu mumpita nua nkolo, nai kitangwaa ku ntambu a Kiebrania Bethzatha, ni kenso kikete nkigo itaano. ");
INSERT INTO isn_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ilundo ikulu nila alwae ai limoli, apoku, a kitele, ang'wi nia kule igandi ai atulaa alae mu nkigo nianso. (Komaniilya; Makani a lukiili nula 3 shanga igeelekile mu mbugulu ni nziza niya kali,) “Aze alindiie imazi kuhigintulwa.” ku kulu kuulu itungo la ki tuunga malaika ai wisimaa mukati ang'wa Mukulu nu kumahigintula i mazi. ");
INSERT INTO isn_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ku iti, uyo naiza ukutula wang'wandyo kingila mukati ze yakilaa i mazi kuhigintulwa ai watendwaa mupanga kupumiila ni kihi nai katulaa kamuambaa ku itungo nilanso. ");
INSERT INTO isn_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nu muntu ung'wi nai watulaa walwae ku itungo la myaka makumi ataatu ni mu nana ai ukoli mukati a nkigo. ");
INSERT INTO isn_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","uYesu nai wakamihenga ulae mukati a nkigo ni zeyakilaa kulinga kina ulae pang'wanso ku itungo ilipu uYesu ai umuiie, “Itii uloilwe kutula wimupanga?” ");
INSERT INTO isn_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Umulwae uyo aka musukiilya, “Mukulu nimugila muntu, nua kumbika mi ikunu itungo imazi nakuhigintulwa, Itungo ni kugema kingila muntu mungiiza wintongeela.” ");
INSERT INTO isn_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","uYesu akamuila, “Nyansuka hangi uhole ikipalatu kako nu kulongola.” ");
INSERT INTO isn_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nkua umuntu nuanso akakomigwa, wakahola u ulili nuakwe nu kulongola. Nu luhiku nulanso ai latulaa luhiku la kusupya. ");
INSERT INTO isn_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Iti gwa i Ayahudi akamuila u muntu uyo nai ugunilwe, '“Lelo luhiku nu la kusupya, shanga ugobigwe kukenka i kipalatu kako,” ");
INSERT INTO isn_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Akasukiilya, ng'wenso nu nungunile yuyo umbiie, kenka i kipalatu kaoko u kulongola. ");
INSERT INTO isn_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Akamukolya, “Inge nyenyu naza ukuiie “Hola igodolo ni lako hangi ulongole?” ");
INSERT INTO isn_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ga ni uu, Uyo nai upangataigwe shanga ai umulingile, kunsoko ai akoli ni antu idu mu kipango ni kanso. ");
INSERT INTO isn_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ze yakilaa papo u yesu ai umuhangile u muntu nuanso mi tekeelo nu kumuila, “Goza wapangataala! uleke kituma i milandu hangi uleke kuligigwa ni ikani ni ibi ikilo”. ");
INSERT INTO isn_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Muntu nuanso akalongola nu kuapindula i Ayahudi kina u Yesu yuyo naza umupangataaye. ");
INSERT INTO isn_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Iti gwa, kunsoko a makani nanso Ayahudi ai amunyomile u Yesu kunsoko ai witumile makani aya luhiku nu la kusupya. ");
INSERT INTO isn_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","U Yesu akaaila, “Tata nu ane ukituma u mulimo ga ni itungili nu nene kituma milimo” ");
INSERT INTO isn_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kunsoko nanso Ayahudi ai akilinkiila kumuduma iti amulage shanga udu kunsoko akubunanga luhiku la kusupya, ila ku kumitanga Itunda, Tata nu akwe, Azi tendisa kina ilikaa ni Itunda. ");
INSERT INTO isn_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","U Yesu akasukiila, “Huiili, Huiili, ung'wana shanga uhumile kituma kintu kihi kwa ala iko niiza umihengile Tata nu akwe uku kituma, kunsoko kihi u Tata nu kituma kiko nu ng'wana wi kitumaa. ");
INSERT INTO isn_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kunsoko u Tata umuloilwe u ng'wana, hangi ukumulagiila kila i kintu nu kituma hangi ukumulagiila makani makulu kukila aya iti kina mukilinkiie ku kuilwa”. ");
INSERT INTO isn_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kunsoko u Tata umuloilwe u ng'wana, hangi ukumulagiila kila i kintu nu ku kituma hangi ukumulagiila makani makulu kukila aya iti kina mukilinkiie ku kuilwa”. ");
INSERT INTO isn_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Kunsoko u Tata shaga wimulamulaa wihi, ila uminkiiye u ng'wana ulamuli wihi. ");
INSERT INTO isn_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Iti kina ihi amukulye u ng'wana anga uu u ng'wana nu mukuiye u Tata, Nuanso ni shanga umukuiye u ng'wana shanga umukuiye u Tata naza umulagiiye. ");
INSERT INTO isn_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Huiili, huiili nuanso nuijaa lukani lane nu kumuhuiila nuanso nai undagiiye ukete u upanga nua kali na kali hangi shanga ukulamulwa, Badala akwe, wakilaa kupuma mu ushi nu kingila mu upanga. ");
INSERT INTO isn_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Huiili, Huiili, kumuila itungo lipembilye ni itungili limoli naza i ashi akija u luli nula ng'wana nuang'wi Itunda, hangi ihi ni ikija a kikie. ");
INSERT INTO isn_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kunsoko anga uu u Tata nu ili nu upanga mukati akwe mukola. ");
INSERT INTO isn_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Anga uu uminkiiye u ng'wana kutula nu upanga mukati akwe, hangi u Tata uminkiiye u ng'wana u uhumi iti kina aulamule kunsoko inge ng'wana wang'wa Adamu. ");
INSERT INTO isn_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Muleke ikuilwa ku ili, kunsoko itungo lipembilye naza i ashi ihi ni amoli mi ibiila akija u luli nu lakwe. ");
INSERT INTO isn_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ni enso akupuma kunzi, ku nai itumile i maza ku u ukigwa nua upanga, hangi nai itumile u ubi ku uukigwa nua ulamulwa. ");
INSERT INTO isn_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Shanga nihumile kituma kintu kihi kupuma kitalane mukola, anga ni kija, uugwa ni keenda lamula nu ulamuli nuane inge nua tai ane kunsoko shanga kuduma u ulowa wane, ila ulowa wakwe nai undagiiye. ");
INSERT INTO isn_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Anga ni kuiile mukola, ukuiili nuane shanga ukutula wa tai. ");
INSERT INTO isn_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ukoli mungiiza nuikuiila kutula unene hangi ningile ku tai ane ukuiili nu ku kuiila inge nua tai. ");
INSERT INTO isn_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Malagiilya kung'wa Yohana nu ng'wenso wamikuila itai. ");
INSERT INTO isn_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ga ni iti, u ukuiili nineenda usingiilya shanga upumile ku ana Adamu, kumaligitya aya iti muhume kugunwa. ");
INSERT INTO isn_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","U Yohana ai watulaa inge ntala natuilee ikakila nu kelya, hangi ai matulaa mukondile kumuloeelwa ku itungo ikupi u welu nuakwe. ");
INSERT INTO isn_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Uukuiili ni nuukete ingi ukulu kukila nu ang'wa Yohana, ku milimo u Tata naza uninkiiye kumikondeelya, milimo nanso ni niitumaa inkuiila kina u Tata undagiiye. U ");
INSERT INTO isn_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tata nai undagiiye ng'wenso mukola ukuiie kutula unene. Izaa mukili kigiilya u luli nulakwe ang'wi kihenge u luli nu lakwe itungo lihi. ");
INSERT INTO isn_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kutili lukani nu lakwe anga likie mukati anyu kunsoko shanga mumuhuiie ng'wenso nai ulagiigwa. ");
INSERT INTO isn_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mukuulingula u ukilisigwa ize musigile mukati akwe umoli upanga nua kali na kali, ni ayo u ukilisigwa akukuiila inkani ni ane hangi. ");
INSERT INTO isn_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Shanga muloilwe kupembya kitalane iti mulije u upanga nua kali na kali. ");
INSERT INTO isn_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Shanga kusingiilya ikulyo kupuma ku antu. ");
INSERT INTO isn_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ku iti ningile kina kutili u ulowa nuang'wa Itunda. ");
INSERT INTO isn_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nazile ku lina ni lang'wa Tata nuane, shanga mukahuma kusingiilya. Anga mungiiza waze ku lina ni lakwe aza muzee musingiilya. ");
INSERT INTO isn_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Iti muhumile uli kuhuiila unyenye naza mukusingiilya ikulyo kupuma ku kila ung'wi anyu kuiti shanga mukuduma ikulyo nilipumiila kung'wa Itunda nuing'wene? ");
INSERT INTO isn_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Leki kusigi unene nikamusongeela ntongeela ang'wa Tata. Nuikamusongeela u nyenye inge Musa, niiza unyenye mu ikila u uhuiili nu anyu kitalakwe. ");
INSERT INTO isn_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Anga ai mutule mumuhuiie u Musa, aza muze nihuiila nu nene kunsoko ai ukilisilye nkani kutula yane. ");
INSERT INTO isn_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Anga ize shanga muhuiie u ukilisigwa nuakwe mikahuma uli kuhuiila i makani ane? ");
INSERT INTO isn_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ze yakilaa i makani aya, uYesu ai ulongoe nkika nia luzi nula Galilaya, hangi litangwaa Luzi nula Tiberia. ");
INSERT INTO isn_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","I ANZA IKULU AI LATULAA LIMUTYATILE KU NSOKO AI IHENGAA ILINGASIILYO NAI WITUMAA KU AWO NAI ATULAA ALWAE. ");
INSERT INTO isn_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","uYesu ai unankie migulya kupikiila nkika nia migulya a lugulu nu kikie kuko ni amanyisigwa akwe. ");
INSERT INTO isn_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(Ni Pasaka, Siku kuu a Ayahudi ai atulaa ahumbeela). ");
INSERT INTO isn_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","uYesu nai unyansue imiho akwe migulya nu kihenga iumbi ikulu lipembilye kitalakwe, akamuila uFilipo, “Kikalongola pii kugula i mikate iti awa ahume kulya?” ");
INSERT INTO isn_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Kuiti uYesu ai umaligitilye aya kung'wa Filipo kumugema ku nsoko ung'wenso mukola ai ulingile nuikituma). ");
INSERT INTO isn_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","uFilipo akamusukilya, “Ga i mikate a nsailo a dinali magana a biili shanga i kukondaniila ga ni kila ung'wi kulija ipuli ga ni niino.” ");
INSERT INTO isn_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","uAndrea, ung'wi nua amanyisigwa akwe muluna nu ang'wa Simioni Petro akamuila ");
INSERT INTO isn_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","u Yesu, “Ukoli muhumba apa ukete mikate itaano ni nsamaki i biili, kuiti i kuaiilya ntuni ku antu ni idu kinya iti?” ");
INSERT INTO isn_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","uYesu aka aila, “Ikalinshi i antu pihi” (ai ikoli mafa idu pang'wanso). Iti gwa agoha apikiie magana a nzogu a taano akikie pihi. ");
INSERT INTO isn_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Uugwa uYesu akahola imikate iyo ni itaano akasongelya akaomolania awo nai atulaa ikie. Ku uu akaomolania i nsamaki kupikiila uu nialoilwe. ");
INSERT INTO isn_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Antu naza ikutile, ai uaiie i amanyisigwa akwe, “Ilingiili imapuli a ipoli, nasagiie iti kina kileke kulimila kihi.” ");
INSERT INTO isn_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","U ugwa akilingiila nu kizulya nkapu ikumi na ibiili, mapuli a mikate itaano a shyiri-mapuli nai asagigwe nao nai alie. ");
INSERT INTO isn_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Uugwa i antu nai ihengile ikilingasiilyo iki naza witumile akaligitya, “Tai uyu yuyo munyakidagu nupembilye mu unkumbigulu.” ");
INSERT INTO isn_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","uYesu nai wakalinga kina ai atulaa alowa kumuamba iti amuike kutula mutemi nu ao, ai wibague, hangi nu kulongola mulugulu ng'wenso wing'wene du. ");
INSERT INTO isn_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nai ipikile impindi, amanyisigwa akwe akasima kulongola muluzi. ");
INSERT INTO isn_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Akanankila milinga hangi ai atulaa akuputa kutunga ku Kapernaumu. (Kiti ai latulaa lingilaa nu Yesu ai watulaa wakili kuza kitalao). ");
INSERT INTO isn_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Itungo ni lanso ng'wega utaki ai watulaa uku kunka, nu luzi ai latulaa lulongolekile kugazika. ");
INSERT INTO isn_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Hangi i amanyisiga akwe nai atuaa akukua i mabini anga makumi abiil na ataano ang'wi makumi ataatu, akamihenga uYesu ukugenda migulya a luzi ku humbeela ilinga, hani akitumba. ");
INSERT INTO isn_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Kuiti aka atambuila, “Ingi nene| leki kitumbi.” ");
INSERT INTO isn_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Hangi ai atulaa akondaa kumukenka mu mulinga, ni nkua ilinga ai lipikiie mihi kianza nai atulaa alongoe. ");
INSERT INTO isn_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Luhiku nai lutyatile, ianza nai watulaa wimikile nkika a luzi ai ihengile kina kutili ilinga ningiiza kwaala ilo naza uYesu ni amanyisigwa akwe ai atulaa shanga ali nankie kuiti i amanyisigwa akwe ai atulaa alongolaa yao akola. ");
INSERT INTO isn_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","(Ga ni iti, ai ikoli ing'wii a milinganai ipumiie ku Tiberia pakupi ni kianza nai alie i mikate ze yakilaa u Mukulu kupumya isongelyo). ");
INSERT INTO isn_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Matungo i anyianza nai alinga kina shanga Yesu ang'wi amanyisigwa akwe nai akoli kung'wanso, i enso akola ai anankie mukati a milinga akalongola ku Kapernaumu azemuduma uYesu. ");
INSERT INTO isn_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ze yakilaa kumulija nkika ngiiza na luzi akamukolya, “Rabbi aza uzile nali kunu?” ");
INSERT INTO isn_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","uYesu aka asukiilya, aka atambuila, Huiili, huiili, mukunduma unene, shanga kunsoko aza mihengile ilingasiilyo, ila kunsoko aza mulie mikate nu kikuta. Leki ");
INSERT INTO isn_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","kitumili u mulimo u ludya nulibipaa, ila itumili u ludya ni likiee ikali na kali ulo niiza ung'wana nu ang'wa adamu wika minkiilya, ku nsoko Itunda uikile ugomola migulya akwe.” ");
INSERT INTO isn_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Uugwa akamuila, “Ki ntuni ni kutakiwe kituma iti kituma imilimo ang'wa Itunda?” ");
INSERT INTO isn_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","uYesu akasukiilya, “Uwu wuwo mulimo nuang'wa Itunda; kina mumuhuiile nuanso nai umulagiiye.” ");
INSERT INTO isn_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Uugwa akamutambuila, “Ingi kilingasiilyo kii nuikituma, kina kuhume kihenga nu ku uhuiila? Ukituma ntuni? ");
INSERT INTO isn_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","aTata itu ai alie manna mibambazi, aga niiza ikilisigwe, “Ai uinkiiye kupuma kilunde iti alye.” ");
INSERT INTO isn_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Uugwa uYsu aka asukiilya, Huiili, huiili, shanga Musa nai uinkiiye umukate kupuma kilunde, ila Tata nu ane yuyo nui uinkiilya u mukate nua tai kupuma kilunde. ");
INSERT INTO isn_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ku nsoko u mukate nu ang'wa Itunda igi uwo nuisimaa kupuma kilunde nu kuinkiilya upanga u unkumbigulu' ");
INSERT INTO isn_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Uugwa akamutambuila, “Mukulu kinkiilye u mukate nuanso matungo ihi.” ");
INSERT INTO isn_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","uYesu aka atambuila, “ Unene wuwo mukate nu a upanga, nuanso nuzile kitalane shanga ukulija inzala nu ng'wenso nunihuiie shanga ukuhung'wa inyota lukulu.” ");
INSERT INTO isn_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ga ni iti aza numutambuie kina, manihengaa, hangi mukili shanga muhuiie. ");
INSERT INTO isn_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ihi naza uTata ukuninkiilya azile kitalane, hangi wihi nuzile kitalane shanga kumuguma kunzi lukulu. ");
INSERT INTO isn_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ku nsoko nsimile kupuma kilunde, shanga ku nsoko akituma ulowa nuane, ila ulowa nukwe naza undagiiye. ");
INSERT INTO isn_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nu uwu wuwo ulowa nuakwe nai undagiiye, kina ndeke kumulimilya ga nung'wi nua awo naza uninkiiye, ila nika ausha uluhiku nula mpelo. ");
INSERT INTO isn_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ku nsoko uwu wuwo ulowa nuang'wa Tata nu ane, kina wihi numugozee ung'wana nu kumuhuiilaa walije u upanga nua kali na kali; nu nene nikamuusha u luhiku nula mpelo. ");
INSERT INTO isn_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Uugwa iAyahudi akisusumya kutula ng'wenso ku nsoko ai uligitilye, “Unene ni mukate nu usimile kupuma kilunde. ");
INSERT INTO isn_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“Akaligitya, “Uyu shanga Yesu ng'wana nuang'wa Yusufu niiza utata nuakwe nu nyinya nuakwe kualingile? Itulikile uli itungili ukuligitya, ''Nsimile kupuma kilunde'?” ");
INSERT INTO isn_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Uyesu akasukiilya, akaaila, “Leki kisusumyi nyenye ku nyenye mukati anyu akola. ");
INSERT INTO isn_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kutili muntu nuzile kitalane ni shanga ukulutwa nu Tata nuane nai undagiiye, nu nene nikamuusha u luhiku nula mpelo. ");
INSERT INTO isn_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kunsoko ikilisigwe mu unyakidagu, 'Akumanyisigwa ni Itunda, ' kila nai wigulye hangi wimanyisilye kupuma kung'wa Tata, wizaa kitalane. ");
INSERT INTO isn_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Shanga kina ukoli muntu nai umihengile uTata, kwaala ng'wenso nupembeeye kung'wa Itunda- umihengile uTata. ");
INSERT INTO isn_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Huiili, huiili nuanso nuhuiie ukete u upanga nua kali na kali. ");
INSERT INTO isn_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Unene ni mukate nua upanga. ");
INSERT INTO isn_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","atata anyu ai alie i manna mi ibambazi, nu kusha. ");
INSERT INTO isn_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Uwu wuwu mukate nu usimile kupuma kilunde, iti kina muntu nukulya ipuli ni lakwe iti waleke kusha. ");
INSERT INTO isn_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Unene ingi mukate nuikiee naza usimile kupuma kilunde. Anga muntu wihi walye ipuli nila mukate uwu, ukikie ikali na kali. Mukate ninikau pumya ingi muili nuane ku nsoko a upanga nua unkumbigulu.” ");
INSERT INTO isn_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","iAyahudi akataka akola ku akola nu kandya kikunguma azeligitya, “Muntu uyu ukuhuma uli kuinkiilya u muili nuakwe kuulye?” ");
INSERT INTO isn_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Uugwa uYesu aka atambuila, Huiili, huiili, anga muhite kulya u muili nua ng'wana nuang'wa Adamu nu kuming'wa isakami akwe, shanga mukutula nu panga mukati nyu. ");
INSERT INTO isn_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Wihi nuilizaa u muili nuane nu kung'wa isakami ane ukete u upanga nua kali na kali, nu nene nikamuusha u luhiku nula mpelo. ");
INSERT INTO isn_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ku nsoko u muili nuane ingi ludya nula tai, ni sakami ane ingi king'wegwa nika tai. ");
INSERT INTO isn_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nuanso nuilizaa u muili nuane nu kung'wa isakami ane wikiee mikati ane, nu nene mukati akwe. ");
INSERT INTO isn_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Anga uTata munya upanga nundagiiye, ni anga ni nikiee kunsoko ang'wa Tata, nu ng'eanso ga ukikie kunsoko ane. ");
INSERT INTO isn_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Uwu wuwo mukate nuisimaa kupuma kilunde, shanga anga iti ia tata nai alie akasha. Nuanso nui ulizaa u mukate uwu ukikie ikali na kali. ");
INSERT INTO isn_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","uYesu ai umaligitilye aya mukati itekeelo nai watulaa ukumanyisa uko ku Kapernaumu. ");
INSERT INTO isn_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Uugwa idu a amanyisigwa akwe nai igulye aya, akaligitya, “Ili imanyisigwa ikaku ingi nyenyu nuhumile kulisingiilya?” ");
INSERT INTO isn_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","uYesu kunsoko ai ulingile nia kina amanyisigwa akwe ai atulaa akisusumilya ikani ili, akaaila itii ikani ili likumukila? ");
INSERT INTO isn_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Uugwa i kutulika uli ni mikamihenga u ng'wana nuang'wa Adamu ukusima kupuma kai ukoli ze ikili? ");
INSERT INTO isn_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ingi Ng'wau ng'welu yuyo nuipumyaa u upanga, u Muili shanga wigunaa kintu kihi. I makani nai nimaligitilye kitalanyu ingi Ng'wau ng'welu hangi ingi upanga. ");
INSERT INTO isn_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ikili akoli antu mu kati anyu ni shanga ahuiie.” ku nsoko uYesu ai ulingile puma u ng'wandyo uyo niiza shanga uhumile kuhuiila nu ng'wenso niiza ukumugumaniilya. ");
INSERT INTO isn_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Aka atambuila, ingi ku nsoko iyi ai numutambuie kina kutili u muntu nuhumile kupembya kitalane kwaala winkii igwe nu Tata.” ");
INSERT INTO isn_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ze yakilaa aya i amanyisigwa akwe idu akasuka kinyuma hangi shanga akityata nu ng'wenso. ");
INSERT INTO isn_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","uYesu aka atambuila awo ni ikumi na abiili, “Itii nu nyenye malowaa kuhega?” ");
INSERT INTO isn_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","uSimioni Petro akamusukiilya, “Mukulu kulongole kung'wa nyenyu ku iti uewe ukete makani a upanga nua kali na kali. ");
INSERT INTO isn_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","hangi kahuuie nu kulinga kina uewe wi ng'welu nuang'wa Itunda.” ");
INSERT INTO isn_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","uYesu akaaila, “Itii u nene shanga ai numuholanilye u nyenye, ni ung'wi anyu mulugu? ");
INSERT INTO isn_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Itungili ai watulaa ukutambula kutula uYuda, ng'wana wang'wa Simioni Iskariote, ku nsoko ai watulaa ingi ng'wenso utuile ung'wi nua awo ikumi na abiili, niiza yuyo ukumugumaniilya uYesu. ");
INSERT INTO isn_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Hangi ze yakilaa a makani aya uYesu ai utungile muhinzo iti mu Galilaya, ku nsoko shanga ai uloilwe kulongola ku Uyahudi ku nsoko i Ayahudi i atulaa akuzipya masigo a kumubulaga. ");
INSERT INTO isn_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Itungili i siku kuu a Ayahudi na itala, ai atulaa pakupi. ");
INSERT INTO isn_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Uugwa i aluna akwe nai amutambuie, “Hega i kianza iki ulongole ku Uyahudi, iti kina amanyisigwa ni ako uu uuu ihenge intendo nukituma. ");
INSERT INTO isn_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kutili nuitumaa lihi ku kinkunku anga itule ung'wenso mukola uloilwe ku kumuka ng'walyi. Anga itule ukituma imakani aya, igeeleke mukola ku anya unkumbigulu.” ");
INSERT INTO isn_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ga ni aluna akwe shanga ai amuhuiie. ");
INSERT INTO isn_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Uugwa uYesu ai uatambuiie, “Itungo ni lane likili kupikiila, kuiti itungo nilanyu nkua yihi likoli likondile. ");
INSERT INTO isn_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Unkumbigulu shanga uhumile kumubipilwa u nyenye, ila umbipiwe unene ku nsoko ku ukuiila kina intendo ni akwe ingi ubii. ");
INSERT INTO isn_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nankili kulongola ku siku kuu; u nene shanga ninzu ku siku kuu iyi ku nsoko itungo ni lane likili likondaniile.” ");
INSERT INTO isn_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ze yakilaa kulingitya imakani nanso kitalao, ai usigile ku Galilaya. ");
INSERT INTO isn_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ga ni iti, aluna akwe nai atulaa alongolaa ku siku kuu, uugwa nu ng'wenso akalongola, shanga ku kihenga ila ku kinkunku. ");
INSERT INTO isn_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ayahudi ai atulaa aku muduma mu siku kuu nu kuligitya, “Ukoli pii?” ");
INSERT INTO isn_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ai ukoli nu witambulyi widu mu kati a anyianza migulya akwe. I auya ai aligitilye, “Ingi muntu mukende,” I auya ai aligitilye, 'Ishi, wialimilya i anyianza,” ");
INSERT INTO isn_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ga ni iti kutili nai utambue kihenga migulya akwe aze uogopile i Ayahudi. ");
INSERT INTO isn_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Itungo i siku kuu nai apikiila pakati, Uyesu ai unankie kulongola mi Itekeelo nu kandya kumanyisa. ");
INSERT INTO isn_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","iAyahudi ai atulaa akukuilwa nu kuligitya, “ku kinya uli u muntu uyu ulingile i makani idu? Shanga wimanyisilye nangaluu,” ");
INSERT INTO isn_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","uYesu aka asukiilya nu kuatambuila, '“Umanyisa nuane shanga wane, ila ingi wakwe ng'wenso nai undagiiye. ");
INSERT INTO isn_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Anga itule wihi ukulowa kituma u ulowa nuakwe u ng'wenso, ukulinga kutula umanyisigwa uwu, anga ize apumiie kung'wa Itunda, ang'wi anga itule kutambula kupuma kitalane mukola. ");
INSERT INTO isn_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kila nuitambulaa napumiie kitalakwe mukola widumaa ikulyo ni lakwe, ila kila nuidumaa ikulyo ni lakwe nuanso nai umulagiiye, muntu nuanso ingi munya tai, nu mukati akwe kutili kuhita kituma itai ane. ");
INSERT INTO isn_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","uMusa shanga ai uminkiiye unyenye ilagiilyo? Kuiti kutili ga nung'wi mi italanyu nuitumaa ilagiilyo. Ku niki muloilwe kumbulagaa? ");
INSERT INTO isn_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","i Anyianza akasukiilya, “Ukete hing'wi. Nyenyu uloilwe ku ubulagaa?” ");
INSERT INTO isn_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","uYesu akasukiilya nu kuaila, “Nitumile mulimo ung'wi, nu nyenye mihi makuilwa ku nsoko akwe. ");
INSERT INTO isn_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","uMusa ai uminkiiye iganda (shanga kina lipumiie kung'wa Musa, ila nilanso lipumiie kua tata), nu mu luhiku nula kusupya mi mutwalaa kiganda muntu. ");
INSERT INTO isn_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Anga itule uku singiilya iganda mu Luhiku nula kusupya iti kina ilagiilyo ni lang'wa Musa lileke kubunangwa, ku niki mukuntakiila unene ku nsoko numitumile u muntu kutula mupanga lukulu mu Luhiku nula kusupya? ");
INSERT INTO isn_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Leki kulamuli kuniganiila nu wigeeleki, ila lamuli ku tai ane. ");
INSERT INTO isn_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ang'wi ao kupuma ku Yerusalemu akaligitya, “Shanga yuyu niakuduma kumubulaga? ");
INSERT INTO isn_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Hangi goza, ukutambula i kihenga, hangi shanga akuligitya kihi migulya akwe. Shanga ihumile itule kina i atongeeli alingile itai kina u muntu uyu ingi Kristo, ihumilene itule? ");
INSERT INTO isn_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kulingile uyu muntu upembeeye pii. uKristo nuikiza, ga ni iti, kutili nuikalinga pii nuikapuma.” ");
INSERT INTO isn_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","uYesu ai watulaa ukitunta ululi nulakwe mi Itekeelo, aze manyisa nu kuligitya, “Unyenye mihi muningile unene hangi mulingile ku mpembeeye. Shanga ai nzile ku umi nuane, ila ng'wenso nai undagiiye ingi wa tai, hangi shanga mu mulingile u ng'wenso. ");
INSERT INTO isn_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nu mulingile u ng'wenso ku nsoko mpembeeye kitalakwe hangi ai undagiiye.” ");
INSERT INTO isn_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ai atulaa akugema kumuamba, kuiti kutili ga nung'wi nai unyansue u mukono nu akwe migulya akwe ku nsoko i saa akwe ai ikili kupika. ");
INSERT INTO isn_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ga ni iti, idu mu anyianza ai amuhuiie. Akaligitya, “uKristo nuikiza, ukituma ilingasiilyo idu kukila nuitumile u muntu uyu?” ");
INSERT INTO isn_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","iAfarisayo ai aigulye i anyianza akipwepweela i makani aya kutula u Yesu, ni akulu a Akuhani ni Afarisayo akalagiilya ia afisa iti kumuamba. ");
INSERT INTO isn_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Uugwa uYesu nai uligitilye, Ikili likoli itungo ikupi nkoli palung'wi nu nyenye, Ni panyambele nikalongola kung'waakwe ng'wenso nai undagiiye. ");
INSERT INTO isn_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mukunduma ni iti shanga mukunihenga, uko ninongoe, shanga muhumile kuza.” ");
INSERT INTO isn_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ku lulo iAyahudi akitambulya enso ku enso, “uMuntu uyu ukulongola pii kina kuleke kuhuma kumihenga? Ukulongola ku nia sapatiee mu Ayunani nu kuamanyisa i Ayunani? ");
INSERT INTO isn_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ingi ikani kii ili nuli ligitilye. 'Mukunduma shanga mukunihenga; uko ninongoe shanga muhumile kupembya'?” ");
INSERT INTO isn_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Itungili mu luhiku nula mpelo, luhiku nu lukulu nula siku kuu, uYesu ai wimikile nu kitunta ku luli, azeligitya, “Aga itule wihi ukete nyota, nu aze kitalane wang'we. ");
INSERT INTO isn_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nuanso nu ni huiie unene anga u ukilisigwa nu uligitilye, kupuma mukati akwe ikuhuma imyongo a mazi a upanga.” ");
INSERT INTO isn_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Kuiti ai umaligitilye aya kutula Ng'wau Ng'welu, naiiza i enso ni amu huiie akumusingiilya; Ng'wau Ng'welu ai watulaa wakili kupumigwa ku nsoko uYesu ai watulaa wakili ku kuligwa. ");
INSERT INTO isn_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ang'wi a anyianza, nai akija imakani aya, ai aligitilye, “Tai uyu ingi munyakidagu.” ");
INSERT INTO isn_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","i Auya ai aligitilye, “Uyu ingi Kristo,” Kuiti i auya ai aliditilye, “ntuni, uKristo uhumile kupuma ku Galilaya? ");
INSERT INTO isn_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","U ukilisigwa shanga uligitilye kina uKristo ukupumiila mu ndugu ang'wa Daudi nu kupuma ku Bethlehemu, kijiji naiza uDaudi ai ukoli? ");
INSERT INTO isn_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Iti gwa, pang'wanso ukamyansuka utemanuki mu kati a anyianza ku nsoko akwe. ");
INSERT INTO isn_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","i Auya mukati ao ai azee muamba, kuiti kutili nai ugooe u mukono migulya akwe. ");
INSERT INTO isn_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Iti gwa awo i a ofisa akasuka ku akulu nia Akuhani ni Afarisayo, ni enso aka atambuila, “ku niki shanga mamuleta?” ");
INSERT INTO isn_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","iAofisa akasukiilya, “Kutili u muntu nai wakaiye kuligitya anga uyu ze ikili.” ");
INSERT INTO isn_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Papo i Afarisayo nai aka asukiilya, “Nu nyenye ga malimiligwa? ");
INSERT INTO isn_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ukoli wihi mu kati a atemi numuhuiie, ang'wi wihi mu Afarisayo? ");
INSERT INTO isn_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ila awa i anyianza ni shanga alingile ilagiilyo - azumilwe.” ");
INSERT INTO isn_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","uNikodemu aka atambuila (nuanso ai umuhangile uYesu i kali, aze ung'wi nua Afarisayo). ");
INSERT INTO isn_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Itii ilagiilyo litu likumulamula umuntu kwaala utegeeigwe hanza nu kulinga nukituma?” ");
INSERT INTO isn_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ai asukiiye nu kumutambuila, “Nu ewe ga upembeeye ku Galilaya? Duma hangi wihenge kutili u munyakidagu nupembeeye ku Galilaya.” ");
INSERT INTO isn_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Hangi kila u muntu ai ulongoe kitalakwe. ");
INSERT INTO isn_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","uYesu ai wendile mu lugulu nula mizeituni. ");
INSERT INTO isn_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Dau kidaudau akiza hangi mi Tekeelo, ni antu ihi akamuhanga; akikie nu kuamanyisa. ");
INSERT INTO isn_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","iAmanyi ni Afaisayo akamuletela musungu nai uambilwe mu ntendo a ugoolya. Akamuika pa kati. ");
INSERT INTO isn_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Papo akamutambuila uYesu, “Ng'walimu, musung uyu uambilwe mu ugoolya, mu ntendo lukulu. ");
INSERT INTO isn_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Itungili, mi ilagiilyo, uMusa ukulagiiye kuatulanga magwe i antu anga awa, ukuligitya uli migulya akwe? ");
INSERT INTO isn_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ai aligitilye aya iti kumutega iti kina alije ikani nila kumusemela, kuiti uYesu akatuna pihi akakilisa mu mahalu ku lung'anza lakwe. ");
INSERT INTO isn_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nai alongolekile kumukolya, ai wimikile nu kuatambuila, “Nuanso ni mugila umulandu mukati anyu, watule wang'wandyo kumutulanga i magwe.” ");
INSERT INTO isn_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Akatuna hangi pihi, akakilisa ku lung'anza lakwe. ");
INSERT INTO isn_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nai akija nanso, ai ahegile ug'wi ung'wi, kandiilya nai munyampala. Mpelo akwe uYesu ai ulekilwe wing'wene du, palung'wi nu musungu nai ukoli pakati ao. ");
INSERT INTO isn_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","uYesu ai wimikile nu kumutambuila “Musungu, naza akusemee akoli pii? “Kutili ga nung'wi nu kulamuee?” ");
INSERT INTO isn_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Akaligitya, “Kutili ga nung'wi Mukulu,” uYesu akaligitya, “Ga nu nene shanga kuulamula. Longola inzila ako; kandiilya ino nu kulongoleka uleke kituma u mulandu hangi.” ");
INSERT INTO isn_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Hangi uYesu akatambula ni antu akaligitya, “ Unene ingi welu nua unkumbigulu; nuanso nuintyataa shanga ukugenda mu kiti; ila ukutula nu welu nua upanga.” ");
INSERT INTO isn_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Afarisyo akamutambuila, “Ukikuiila mukola; ukuilii nu ako shanga wa tai.” ");
INSERT INTO isn_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","uYesu ai usukiiye akaatambuila, “Anga ize kikuiila mukola, ukuilii nuane ingi tai. Ningile i kianza ni mpumiie nu uko ni nongoe, kuiti unyenye shanga mulingile kumpumile nuko kunongoe. ");
INSERT INTO isn_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Unyenye mukulamula ki muili; unene shanga kumulamula wihi. ");
INSERT INTO isn_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Unene anganamule, ulamuli nuane ingi tai ku nsoko shanga nkoli ning'wene du, ila nkoli palung'wi nu Tata nai undagiiye. ");
INSERT INTO isn_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Uugwa, nu miilagiilyo ni lanyu ikilisigwe kina ukuiili nua antu a biili ingi tai. ");
INSERT INTO isn_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Unene ng'wenso niki kuiila, nu Tata nai undagiiye uku nkuiila.” ");
INSERT INTO isn_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Akamutambuila, “uTata nuako ukoli pii?” uYesu akasukiilya, “unene shanga muningile ga nu Tata nuane shanga mumulingile; anga aza itule muningile unene, aza muzee mulinga nu Tata nuane ga.” ");
INSERT INTO isn_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ai utambue imakani aya aze ukoli pakupi ni tulyo nai watula ukumanyisa mi Itekeelo, hangi kutili ga nung'wi nai umuambile ku nsoko itungo ni lakwe ai latulaa likili kupika. ");
INSERT INTO isn_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Uugwa aka atambuila hangi, “Nongoe yane; mukunduma nu kusha mu milandu anyu. uko ku nongoe, shanga muhumile kupembya.” ");
INSERT INTO isn_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ayahudi akaligitya, “Ukulinga mukola, ng'wenso naiza uligitilye, 'uko ku nongoe shanga muhumile kupembya?” ");
INSERT INTO isn_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","uYesu aka atambuila, “Mupumiie pihi; unene mpumiie kigulya, Unyenye mia unkumbigulu uwu; unene shanga nia unkumbigulu uwu. ");
INSERT INTO isn_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ku lulo, ai namutambuilaa kina mukushaa mu milandu anyu. Kwaala muhuiile kina UNENE YUYO, mu kusha mu milandu anyu,” ");
INSERT INTO isn_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ku lulo akamuila, “Uewe wi nyenyu?” uYesu aka atambuila, Ayo nai numutambuie puma u ng'wandyo. ");
INSERT INTO isn_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nkete makani idu na akuligitya nu kulamula migulya anyu. Ga ni iti, nuanso nai undagiiye ingi wa tai; ni makani nai nigulye kupuma kitalakwe, makani naso kumatambula ku unkumbigulu,” ");
INSERT INTO isn_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Shanga akamulinga kina ai watula ukutambula ni enso kutula uTata. ");
INSERT INTO isn_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","uYesu akaligitya, Ni mika munyansula migulya uNg'wana nua muntu, papo mukulinga kina UNENE YUYO, ni kina shanga kituma kihi ku umi nuane. Anga uTata nai umanyisilye, kutambula i makani aya. ");
INSERT INTO isn_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nuanso nai undagiiye ukoli palung'wi nu nene wakili kundeka nig'wene duu, ku iti nkua yihi kituma ayo namu loeeye.” ");
INSERT INTO isn_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Itungo uYesu ukuligitya imakani aya, idu ai amuhuiie. ");
INSERT INTO isn_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","uYesu akaligitya ku awo iAyahudi nai amuhuiie, “Anga itule mukikie mu lukani lane, uugwa mukutula mia manyisigwa ane i tai, ");
INSERT INTO isn_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","nu nyenye mukumilinga itai, ni tai ikumuika ilyuuku,” ");
INSERT INTO isn_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Akamusukiilya, “Usese ingi ulelwa wang'wa Ibrahimu ni kulu kuulu kukili kutula pihi a utugwa nuihi; ukuligitya uli, “Kuuikwa ilyuuku?” ");
INSERT INTO isn_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","uYesu ai uasukiiye, Huiili, huiili, kumuila, wihi nuitumaa u mulandu ingi mutung'waa nua mulandu. ");
INSERT INTO isn_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","uMutung'waa shanga wikiee mito matungo ihi; ung'wana wikiee mahiku ihi. ");
INSERT INTO isn_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ku lulo, anga itule Ung'wana wamuike ilyuuku, mukutula alyuuku itai lukulu,” ");
INSERT INTO isn_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ningile kina unyenye mi ulelwa wang'wa Ibrahimu; mukuduma kumbulaga ku nsoko lukani lane lugila ilyoma mukati anyu. ");
INSERT INTO isn_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Kuligitya imakani naiza nimihengile palung'wi nu Tata nu ane, nu nyenye u uu mukituma i makani naiza migulye kupuma ku a tata anyu.” ");
INSERT INTO isn_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ai asukiiye nu kumutambuila, “Tata itu ingi Abrahamu,” uYesu aka atambuila, anga aza mutule ana ang'wa Ibrahamu, aza muziituma imilimo angwa Ibrahimu. ");
INSERT INTO isn_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ga ni itungili mukuduma kumbulaga, muntu nai umutambuie i tai kina ai nigulye kupuma kung'wa Itunda. Abrahamu shanga ai witumile iti. ");
INSERT INTO isn_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mukituma milimo a atata anyu.” akamuila, “shanga ai kuleilwe mu ugoolya, kukete utata ung'wi, Itunda.” ");
INSERT INTO isn_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","uYesu aka aila, “Anga itule Itunda ingi Tata wanyu, aza muzee ndowa unene, ku ndogoelyo mpumiie kumg'wa Itunda; ni uu shanganzile ku umi wane, ila ng'wenso undagiiye. ");
INSERT INTO isn_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ku niki shanga mumaligile imakani ane? Ku nsoko shanga muhumile kugimya ku mija imakani ane. ");
INSERT INTO isn_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Unyenye mi ang'wa tata nuanyu, u mulugu, hangi mukuduma kituma insula nang'wa tata nuanyu. Ai watuilee mubulagi puma ung'wandyo hangi shanga uhumile kimika mu tai ku nsoko itai imutili mukati akwe. Nukuligitya u uteele, ukuligitya kupumiila mu upumoo nu akwe ku nsoko ingi muteele hangi tata nua uteele. ");
INSERT INTO isn_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ga nitungili, ku nsoko kuligitya nituile itai, shanga munihuiie. ");
INSERT INTO isn_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ingi nyenyu mukati anyu nuku nkuiila kina nkete mulandu? anga itule kuligitya nili itai, ku niki shanga munuhuiie? ");
INSERT INTO isn_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nuanso nuang'wa Itunda wimijaa imakani ang'wa Itunda; unyenye shanga mukija ku nsoko unyenye shanga mi ang'wa Itunda.” ");
INSERT INTO isn_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ayahudi akamusukiilya nu kumuila, “shanga kuligitilye tai kina uewe wi Musamaria hangi ukete hing'wi?” ");
INSERT INTO isn_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","uYesu akasukiilya, nimugila u hing'wi; kuiti nu mukuiye u Tata nu ane, nu nyenye shanga munkuiye. ");
INSERT INTO isn_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Shanga kuduma ikulyo ni lane; ukoli ung'wi nuidumaa nu kulamula. ");
INSERT INTO isn_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Huiili, huiili, kumuili, anga itule wihi ukuluamba u lukani lane, shanga ukihenga insha lukulu.” ");
INSERT INTO isn_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ayahudi akamutambuila, “Itungili kalingaa kina ukete hing'wi. Abrahamu ni anyakidagu ai akule; kuiti ukiligitya, 'Anga itule u muntu ukuluamba u lukani nu lane, shanga ukululya insha'. ");
INSERT INTO isn_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Uewe shanga wimukulu kukila utata itu Abrahamu nai ukule, shanga? Ga ni anyakidagu ai akule, Uewe ukitendisa kina nyenyu?” ");
INSERT INTO isn_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","uYesu akasukiilya, “Anga itule kikulya mukola, ikulyo lane ingi nankanda; ingi Tata nuane nuenda nkulya - uyo ni mukumutambula kina ingi Itunda wanyu. ");
INSERT INTO isn_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Unyenye mukili kumulinga nuanso, kuiti unene numulingile nuanso. Anga itule nikaligitya, 'shanga numulingile,' nikatula anga unyenye, muteele. Ga ni iti, numulingile ni makani akwe nimaambile. ");
INSERT INTO isn_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","uTata nu anyu uAbrahamu ai ulumbiiyee nuikihenga u luhiku nu lane; ai ulihengile hangi ai ulumbiiye.” ");
INSERT INTO isn_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ayahudi akamutambuila, “Ukili kupisha i lika nila myaka makumi a taano, nu ewe wamihengaa u Ibrahimu?” ");
INSERT INTO isn_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","uYesu aka atambuila, “Huiili, huiili, kumutambuila, ze ikili u Abrahamu kutugwa, UNENE NKOLI,” ");
INSERT INTO isn_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Uugwa akahooela i magwe alije kumukua, kuiti uYesu ai wipihiiye nu kupuma kunzi itekeelo. ");
INSERT INTO isn_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Itungo, anga uYesu nai watula ukukila, ai umihengile muntu mupoku puma kutungwa kung'wa akwe. ");
INSERT INTO isn_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Amanyisigwa akwe akamukolya, “ Rabi, nyenyu nai witumile u mulandu, muntu uyu ang'wi aleli akwe, watungwa mupoku?” ");
INSERT INTO isn_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","uYesu akasukiilya, “Shanga muntu uyu ang'wi aleli akwe nai itumile u mulandu, ila milimo ang'wa Itunda ilije ku kunukulwa ku kiila kung'wakwe. ");
INSERT INTO isn_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kutakiwe kituma i milimo akwe nuanso nai undagiiye itungo ni ikli mung'wi, Utiku upembilye itungo niize kutili nukuhuma kituma u mulimo. ");
INSERT INTO isn_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Matungo nimoli mu unkumbigulu, unene ingi welu nua unkumbigulu.” ");
INSERT INTO isn_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ze yakilaa uYesu kuligitya imakani aya, ai utyie imati mu mahalu, akazipya ilolo ku mati nu kumupaka umuntu nuanso mu miho ni malolo. ");
INSERT INTO isn_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Akamuila, longola woge mu kilungu nika Siloam (ikulingasigwa anga 'nai ulagiigwe').” Ku lulo umuntu uyu ai ulongoe, aka kalala, nu kusuka, ukihenga. ");
INSERT INTO isn_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Anya kisali a muntu nuanso na awo nai amihengile u ng'wandyo anga mineneelyi ai aligitilye, Itii| uyu shanga yuyo muntu naiwatuilee wikie nu kulompa?” auya ai aaligitilye, “Ingi ng'wenso,” ");
INSERT INTO isn_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ni auya ai aligitilye, Aa, ila wimpyani nu ng'wenso,” Kuiti aiwatulaa ukuligitya, “ Ingi nene.” ");
INSERT INTO isn_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Akamutambuila, “Itungili imiho ako apitigwe uli?” ");
INSERT INTO isn_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Akasukiilya, muntu nui atangwaa Yesu aza uzipilye ilolo nu kumpaka i miho ane nu kumbila, ' Longola ku Siloam ukalale.' Ku lulo aza nongoe, nu kukalala, nu kulija kihenga hangi.” Akamutambuila, “Ukoli pii?” ");
INSERT INTO isn_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Akasukiilya, “Shanga ningile.” ");
INSERT INTO isn_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Akamutwala umuntu uyo nai watuilee mupoku ku Afarisayo. ");
INSERT INTO isn_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Kunu ai yatulaa luhiku nula kusupya itungo uYesu naza uzipilye ilolo nu kumapitya imiho akwe. ");
INSERT INTO isn_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Papo hangi iAfarisayo akamukolya aza uligilye uli kihengaa. Ai uatambuile,”Aza uikie ilolo mu miho ane, ni itungili nahumaa kihenga.” ");
INSERT INTO isn_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ang'wi a Afarisayo akaligitya, “umuntu uyu shanga upumiie kung'wa Itunda ku nsoko shanga uluambile u luhiku nula kusupya.” Auya ai aligitilye, “Ihumikile uli muntu mnya milandu kituma i ilingasiilyo anga izo?” Ku lulo ikatula nu utemanuki mukati ao. ");
INSERT INTO isn_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Papo nai amukoiye u mupoku uyo hangi, “Ukuligitya ntuni migulya akwe ku nsoko umapitilye imiho ako?” u mupoku akaligitya, “Ingi munyakidagu.” ");
INSERT INTO isn_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ga ni tungo ili Ayahudi shanga ai ahuiie kina ai watuilee mupoku nu ng'wenso walijaa kihenga kupikiila nai aitangile i aleli akwe nuanso nai uligilye kihenga. ");
INSERT INTO isn_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ai a akoiye i aleli, Itii, uyu ingi ng'wana wanyu ni mukuligitya ai utugilwe mupoku? uhumile uli itungili kihenga? ");
INSERT INTO isn_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","“Iti gwa aleli akwe akamusukiilya, “Kulingile kina uyu ingi ng'wana witu ni kina ai uleilwe mupoku. ");
INSERT INTO isn_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kinya uli itungili ukihenga, shanga kulingile, nu ng'wenso numupitilye i miho akwe, shanga kumulingile. Mukolyi ng'wenso. Ingi muntu mukulu. Uhumile kitambuilya u mukola. ");
INSERT INTO isn_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Aleli akwe ai aligitilye i makani aya, ku nsoko ai aogopile i Ayahudi. Ku iti i Ayahudi ai atulaa akondyaa kigombya kina, anga itule wihi ukulapa kina uYesu ingi Kristo, Ukubagulwa ni Itekeelo. ");
INSERT INTO isn_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ku nsoko iyi, aleli akwe ai aligitilye, “Ingi muntu mukulu, mukolyi ng'wenso.” ");
INSERT INTO isn_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ku lulo ku nkua a kabiili, ai amitangile u muntu nai wakaiyee kutula mupoku nu kumutambuila, “Minkiilye Itunda ikulyo. Kulingile kina u muntu uyu munya milandu.” ");
INSERT INTO isn_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Papo muntu uyu ai usukiiye, “Atule ingi munya milandu, unene shanga ningile. Kintu kimg'wi ni nikilingile: ai izaa nimupoku, ni itungili kihenga.” ");
INSERT INTO isn_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Papo nai amutambuie, “ Ukutendee ntuni? Aza umapitilye uli i miho ako?” ");
INSERT INTO isn_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ai usukiiye, “Nakondyaa kumutambuila, nu nyenye shanga mutegeeye| Ku niki mutakila kija hangi? Nu nyenye shanga muloilwe kutula amanyisigwa akwe ga, shanga uu? ");
INSERT INTO isn_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ai amutukie nu kuligitya, “Uewe ingi wi mu manyisigwa wakwe, kuiti usese ingi kiamanyisigwa ang'wa Musa. ");
INSERT INTO isn_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kulingile kina Itunda ai witambuuye nu Musa, kuiti ku muntu uyu, shanga kulingile uko ku upembeeye. ");
INSERT INTO isn_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","uMuntu uyo akasukiilya nu kuatambuila, Ku niki, ili ingi ikani nila kukuilwa, kina shanga mulingile ku upembeeye, hangi ikili umapitilye imiho ane. ");
INSERT INTO isn_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kulingile kina Itunda shanga wiategeelya i anya milandu. kuiti anga itule u muntu wihi ukumukulya Itunda nu kituma u ulowa nuakwe, Itunda wimutegeelya. ");
INSERT INTO isn_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Puma kandya ku unkumbigulu ikili kukaya nangaluu kigigwa kina wihi umapitilye miho a muntu nai utugilwe mupoku. ");
INSERT INTO isn_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Anga itule u muntu uyu shanga upumiie kung'wa Itunda, shanga aze uzii ituma kihi.” ");
INSERT INTO isn_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ai asukiiye nu kumutambuila, “Ai utugiwe mu milandu nangaluu, nu ewe uku umanyisa u sese?” Papo nai akamuzunsa kupuma mi itekeelo. ");
INSERT INTO isn_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","uYesu akija kina amuhejaa mi Itekeelo. Ai umuligilye nu kumutambuila, “Umuhuiie u ng'wana nua muntu?” ");
INSERT INTO isn_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Akasukiiya nu kuligitya, “Ingi nyenyu, Mukulu, iti nu nene ndije kumu huiila?” ");
INSERT INTO isn_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","uYesu akamutambuila, “Wakondyaa kumihenga, nung'wenso nukitambulya nu ng'wenso yuyo.” ");
INSERT INTO isn_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Umuntu uyo akaligitya, “Mukulu, Na huiila,” Uugwa akamukulya. ");
INSERT INTO isn_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","uYesu akaligitya, Ku ulamuli nzile mu unkumbigulu uwu iti kia awo ni shanga ihengaa alije kihenga ni awo ni ihenga atule apoku.” ");
INSERT INTO isn_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ang'wi aAfarisayo nai atulaa palungwi nu ng'wenso akija imakani nanso nu kumukolya, “Nu sese ga kiapoku?” ");
INSERT INTO isn_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","uYesu aka atambuila, “Anga aza ize matulaa miapoku, shanga aza muzee tula ni milandu. Ga ni iti, itungili mu kuligitya, 'Kihengaa,' u mulandu nuanyu wiki kiie.” ");
INSERT INTO isn_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Huiili, huiili kumutambuila, uyo ni shanga ukingila kukiila mumpita nua itando nila nkolo, kuiti winankila ku nzila ingiiza, muntu nuanso ingi mii hangi muhimbi. ");
INSERT INTO isn_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nuanso nuingilaa ku ku mulango ingi mudimi nua nkolo. ");
INSERT INTO isn_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ku ng'waakwe u musunja nua mumpita wi muluguilaa. Inkolo yijaa u luli nu lakwe hangi wi yitangaa inkolo ku mina ao nu kuipumya kunzi. ");
INSERT INTO isn_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nuika ipumya kunzi izo ni akwe, wi itongeela, ni inkolo yi mutyataa, ku nsoko ilingile u luli lakwe. ");
INSERT INTO isn_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Shanga ikumutyata u muziila kuiti badala akwe yukumuhuga, ku nsoko shanga yilingile induli nia aziil.” ");
INSERT INTO isn_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","uYesu ai uligitilye impyani iyi kitalao, kuiti shanga ikamalinga imakani aya naiza utuile ukuligitya kitalao. ");
INSERT INTO isn_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","uYesu ai uligitilye ni enso hangi, Huiili, huiili, kumutambuila, Unene ni mumpita nua nkolo. ");
INSERT INTO isn_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ihi nai antongee ingi ii hangi ahimbi, kuiti i nkolo shanga ai iategeeye. ");
INSERT INTO isn_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Unene ingi mumpita. Wihi ni ingiila kukiila kitalane, ukugunwa; ukingila mukati nu kupuma, nu ng'wenso uki ligilya u ludimo. ");
INSERT INTO isn_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Umii shanga uzile kwaala kia, kubulaga, nu kulimilya. Nzile iti kina alije u upanga nua kali na kali hangi atule nuenso widu. ");
INSERT INTO isn_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Unene ni mudimi nu mukende, uMudimi nu mukende wipumyaa u upanga nu akwe ku nsoko a nkolo. ");
INSERT INTO isn_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","uMunya mulimo nu anilwe, ni shanga mudimi, naiza inkolo shanga nsao yakwe, wihengaa i mbugi ipembilye nu kuimanka inkolo. ");
INSERT INTO isn_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ni imbugi yi iambaa nu kuisapatilya. Wimankaa ku nsoko ingi munya milimo nua kanwa hangi shanga uikee inkolo. ");
INSERT INTO isn_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Unene ni mudimi nu mukende, hangi nialingile ni ane, ni enso ni ane aningile unene. ");
INSERT INTO isn_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","uTata uningile, nu nene numulingile uTata, nu nene niupumyaa u upanga nuane ku nsoko a nkolo. ");
INSERT INTO isn_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nkete i nkolo inzuya naza shanga yi itando ili. Nianso ga, ntakiwe kuileta, ni nyenso yukija u luli nulane iti kina itule ikoli idale ling'wi nu mudimi ung'wi. ");
INSERT INTO isn_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Iyi yiyo nsoko uTata undoilwe: Nu upumye u upanga nu ane halafu nu uhole hangi. ");
INSERT INTO isn_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kutili nui uholaa kupuma kitalane, kuiti unene mukola niu pumyaa. Nkete u uhumi nua ku upumya, hangi nkete u uhumi ga nuku uhola. Nilisingiiye ilagiilyo ili kupuma kung'wa Tata.” ");
INSERT INTO isn_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Utemanuki ukapumila hangi mu Ayahudi ku nsoko a makani aya. ");
INSERT INTO isn_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Idu ao akaligitya, “Ukete hing'wi hangi ingi muhali. Ku niki mukumutengeelya?” ");
INSERT INTO isn_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Auya akaligitya, “Aya shanga makani a muntu nu halinkaniwe ni ahing'wi. uHing'wi uhumile kumupitya i miho u mupoku?” ");
INSERT INTO isn_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Uugwa ikaza i siku kuu a kuika u wakfu iYerusalemu. ");
INSERT INTO isn_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ai yatulaa itungo nila ulyuuku, nu Yesu ai watulaa ukugenda mi Itekeelo mu kianda ni kang'wa Selemani. ");
INSERT INTO isn_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Uugwa iAyahudi nai akamupilimikiilya nu kumutambuila, “Kupikiila nali ukuuika mu witumbi? anga ize uewe ingi Kristo, kuile kihenga. ");
INSERT INTO isn_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","uYesu akasukiilya, “Nakondyaa kumutambuila kuiti shanga muhuiie. Milimo nikituma ku lina ni lang'wa Tata nuane, nianso iku kuila migulya ane ");
INSERT INTO isn_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ga ni iti shanga mu huiie ku nsoko unyenye shanga mi nkolo yane. ");
INSERT INTO isn_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Inkolo ni ane yukija u luli nulane; Ni ilingile, ni nyenso yukuntyata unene. ");
INSERT INTO isn_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ni yinkiiye u upanga nua kali na kali; shanga yukulimila nangaluu, hangi kutili ga nung'wi nuika isapula kupuma mu mikono ane. ");
INSERT INTO isn_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","uTata nu ane, nai uninkiiye nianso, ingi mukulu kukila ni angiiza ihi. hangi kutili ga nung'wi nukete u uhumi nua kuasapula kupuma mu mikono ang'wa Tata. ");
INSERT INTO isn_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Unene nu Tata ki palung'wi.” ");
INSERT INTO isn_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Akakenka i magwe iti amutulangwe hangi. ");
INSERT INTO isn_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","uYesu aka asukiilya, “Nakondya kumulagiila milimo idu ni miza kupuma kung'wa Tata. Ku milimo ni uli mu nanso muloilwe kuntulanga imagwe?” ");
INSERT INTO isn_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","iAyahudi akamusukiilya, “Shanga ku ukutulanga image ku mulimo wihi nu uziza, kuiti ku kukunka, ku nsoko uewe, nuili wi muntu, ukitendiisa kina Itunda.” ");
INSERT INTO isn_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","uYesu aka asukiilya, “Shanga ai ikilisigwe mu malagiilyo anyu, 'Aindigitilye, “Unyenye mi itunda?” ");
INSERT INTO isn_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Anga itule ai uitangile mi Itunda, ku awo naza Lukani nu lang'wa Itunda ai liaziie (nu Ukilisigwa shanga uhumile kubunangwa), ");
INSERT INTO isn_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","mukuligitya migulya a uyo naiza u Tata umupumilye nu kumulagiilya mu unkumbigulu, 'Ukukunka,' ku nsoko ai ndigitilye, ''unene ni ng'wana wang'wa Itunda'? ");
INSERT INTO isn_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“Anga itule shanga kituma i milimo ang'wa Tata nuane, muleke kuni huiila. ");
INSERT INTO isn_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ga ni iti anga itule kituma i milimo, anga itule shanga munihuiie, huiili i milimo iti kina muhume kulinga uTata ukoli mu kati ane nu nene nkoli mukati ang'wa Tata.” ");
INSERT INTO isn_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Akagema hangi kumuamba uYesu, kuiti akalongola yakwe kupuma mu mikono ao. ");
INSERT INTO isn_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","uYesu akalongola yakwe hangi ki itumbi nila Yordani nkika naiza uYohana ai watulaa ukoja u ng'wandyo, nu kikie kuko. ");
INSERT INTO isn_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Antu idu akapembya kung'wa Yesu. Ai alongolekile kuligitya, “uYahana tai shanga ai witule i ilingasiilyo yihi, kuiti imakani ihi nai umaligitilye uYohana migulya a muntu uyu ingi a tai.” ");
INSERT INTO isn_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Antu idu akamuhuiila uYesu pang'wanso. ");
INSERT INTO isn_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Uugwa muntu ug'wi ilina nilakwe Lazaro ai watulaa mulwae. Ai upembeeye ku Bethania, Kijiji kang'wa Mariamu nu muluna nuakwe uMartha. ");
INSERT INTO isn_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ai watulaa Mariamu yuyo yuuyo nai umupuguhie uMukulu nu kumupyagula i migulu akwe ku nsingi ni akwe. naiza mulunaa akwe Lazaro ai watulaa mulwae. ");
INSERT INTO isn_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Papo i luna awa ai alagiiye u lukani kung'wa Yesu nu kuligitya, “Mukulu, goza uyo nu muloilwe ukulwala.” ");
INSERT INTO isn_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","uYesu nai wakija akaligitya, “Ulwae uwu shanga wansha, kuiti, badala akwe ingi ku nsoko i ikulyo ni lang'wa Itunda iti kina ng'wana nuang'wa Itunda walije kukuligwa mu ulwae uwu.” ");
INSERT INTO isn_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","uYesu ai umuloilwe u Martha nu muluna nu akwe nu Lazaro. ");
INSERT INTO isn_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Nai wakija kina uLazaro ingi mulwae, uYesu ai wikie mahiku a biili ikilo ku kianza nai ukoli. ");
INSERT INTO isn_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Uugwa ze yakilaa a ili ai uaiie i amanyisigwa akwe, “Kweni ku Uyahudi hangi.” ");
INSERT INTO isn_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Amanyisigwa akamutambuila, “Rabi, Ayahudi ai atula akugema ku utulanga magwe, nu ewe uloilwe kusuka kung'wanso hangi?'” ");
INSERT INTO isn_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","uYesu aka atambuila, I matngo a mung'wi shanga ikumi na abiili? Muntu nukugenda u mung'wi shanga uhumile ku kumpa, ku nsoko ukihenga ku welu nua mung'wi. ");
INSERT INTO isn_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ga ni iti, anga itule wika genda utiku, uku kumpa ku nsoko u welu ukutili mukati akwe.” ");
INSERT INTO isn_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","uYesu akaligitya imakani aya, ni ze yakilaa imakani aya, aka atambuila, “Muhumba miitu uLazaro walala, kuiti nongoe iti kina ndije kumuusha kupuma mu tulo.” ");
INSERT INTO isn_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Uugwa i amanyisigwa akamutambuila, 'Mukulu, anga itule ulae, ukuuka. ");
INSERT INTO isn_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Itungo ili uYesu ai watulaa ukuligitya nkani nia nsha ang'wa Lazaro, kuiti nianso ai asigiie ukutambula migulya a kulala tulo. ");
INSERT INTO isn_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Uugwa uYesu akatambula nienso kihenga, “uLazaro wakuzaa, ");
INSERT INTO isn_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nkete u lowa kunsoko anyu, kina aza nikutili ku ng'wanso iti kina mulije kuhuiila. Kwini kung'waakwe.” ");
INSERT INTO isn_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Uugwa uTomaso, nai witangwaa ituti, ai uatambuie i amanyisigwa auya, “Nu sese ga kweni kushe palung'wi nu Yesu.” ");
INSERT INTO isn_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Itungo uYesu nai wakapembya, ai uhangile kina uLazaro wakondya kutula mukibiila mahiku anne. ");
INSERT INTO isn_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ni nyenso iBethania ai ikoli pakupi ni Yerusalemu anga kilomita makumi anne na ataano iti. ");
INSERT INTO isn_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Idu mukati a Ayahudi akaembya kung'wa Martha nu Mariamu kuahongeelya kunsoko a muluna ao. ");
INSERT INTO isn_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Papo uMartha nai wakija kina uYesu wapembyaa, ai ulongoe kutankana nu ng'wenso, kuiti uMariamu akalongoleka kikie mi ito. ");
INSERT INTO isn_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Papo uMartha akamutambuila uYesu, “Mukulu, anga aza utule papa, uheu nuane shanga azaa uzeesha. ");
INSERT INTO isn_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ga ni itungili, ningile ya kina lihi nuikalompa kupuma kung'wa Itunda, ukuinkiilya.” ");
INSERT INTO isn_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","uYesu akamutambuila, uheu nuako ukiuka hangi.” ");
INSERT INTO isn_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","uMartha akamuila, ningile kina ukiuka mu wiuki nua luhiku nula mpelo.” ");
INSERT INTO isn_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","uYesu akamuila, “Unene ingi wiuki nu upanga; nuanso nu nihuiie, anga itule ukusha, ga ni iti ukutula ukikie; ");
INSERT INTO isn_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","nu ng'wenso nuikie nu kunihuiila unene shanga ukusha, uhuiie ulu?” ");
INSERT INTO isn_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Akamutambuila, “Ee, Mukulu nihuiie kina uewe ingi wi Kristo, Ng'wana nuang'wa Itunda, ng'wenso nu pembilye mu unkumbigulu.” ");
INSERT INTO isn_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nai wakondya kuligitya ili, akalongolaa yakwe kumitanga u muluna akwe uMariamu ku ki mpinyimpinyi. Akaligitya, uNg'walimu ukoli apa ukuitanga.” ");
INSERT INTO isn_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","uMariamu nai wakija aya, ai unyansukile ku upepele nu kulongola kung'wa Yesu. ");
INSERT INTO isn_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Nu ng'wenso uYesu aiwatulaa wakili kuza mukati a kijiji, ila ai watulaa ukoli ikianza nai utankanie nu Martha. ");
INSERT INTO isn_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Uugwa Ayahudi nai akoli nu Mariamu mi ito ni awo nai atulaa akumuhongeelya, nai akamihenga ukunyansuka ku upepeele nu kupuma kunzi, ai amutyatile; aze asigiie kina ulongoe ku kibiila iti kina wende walile kuko. ");
INSERT INTO isn_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Uugwa uMariamu, nai wakapika pang'wanso uYesu nai ukoli nai wakamihenga nu kugwa pihi a migulu akwe nu kumuila,” Mukulu, anga aza utule ukoli papa, muluna ane shanga aza uzeesha.” ");
INSERT INTO isn_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","uYesu nai wakamihenga ukulila, ni Ayahudi nai azile palung'wi nu ng'wenso ai atulaa akulila ga, ai uhongeeye mu nkolo nu kuhusha; ");
INSERT INTO isn_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","akaligitya, “Mumulalikilye pii? akamutambuila, Mukulu, Pembya ugoze.” ");
INSERT INTO isn_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","uYesu akalila. ");
INSERT INTO isn_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Papo iAyahudi akaligitya, “Goza nai umuloilwe uLazaro|” ");
INSERT INTO isn_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Kuiti i auya mu kati ao akaligitya, “Shanga yuyu, muntu nai umapitilye i miho ang'wa uyo nai watuile mupoku, shanga aza uhumile kumuzipya u muntu uyu waleke kusha?” ");
INSERT INTO isn_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Uugwa uYesu, aze ukuhongeelya mu umi nuakwe hangi, akalogola mu kibiila. Itungili ai latulaa ikulungi, ni igwe li ikilwe migulya akwe. ");
INSERT INTO isn_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","uYesu akaligitya, Liheji igwe. “uMartha, muluna nuakwe uLazaro, nuanso nai ukule, akamuila uYesu, “Mukulu, ku itungo ili, muimba ukutula waolaa, ku nsoko wakondya kutula muimba ku mahiku anne.” ");
INSERT INTO isn_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","uYesu akamuila, “Unene shanga aza nukuiie kina, anga uhuiile, ukihenga ikulyo ni lang'wa Itunda?” ");
INSERT INTO isn_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ku lulo akaliheja igwe. uYesu akanyansula imiho akwe migulya nu kuligitya, “Tata, nukulumbile ku nsoko untegeeye. ");
INSERT INTO isn_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Aza ningile kina wintegeelya nkua yihi, kuiti ingi ku nsoko a milundo nuimikile ku mpilimikiilya kina ndigitilye aya, iti kina alije kuhuiila kina uewe undagiiye.” ");
INSERT INTO isn_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ze yakilaa kuligitya aya, ai uli ile ku luli lukulu, “Lazaro, puma kunzi|'” ");
INSERT INTO isn_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mushi ai upumule kunzi utungilwe i mikono ni migulu ku sanda ni kiikila, nu usu nu akwe ai utungilwe mukako” uYesu aka atambuila, “Mutunguili mu muleke walongole.” ");
INSERT INTO isn_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Uugwa iAyahudi idu nai azile kung'wa Mariamu nu kihenga uYesu naza witumile, ai amuhuiie; ");
INSERT INTO isn_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","kuiti ang'wi ao ai alongoe ku Afarisayo nu kuaila imakani naza witumile uYesu. ");
INSERT INTO isn_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Uugwa akulu a Akuhani ni Afarisayo akilundiila palung'wi mu kianda nu kuligitya, Ku utenda ntuni? uMuntu uyu ukituma ilingasiilyo idu. ");
INSERT INTO isn_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Anga itule ku umuleka iti wing'wene duu, ihi aku muhuiila; iArumi akupembya nu kuhola yihi i kianza kitu ni ihi itu.” ");
INSERT INTO isn_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ga ni iti, muntu ung'wi mu kati ao, Kayafa, nai watuile Kuhani Mukulu ng'waka nuanso, aka atambuila, ");
INSERT INTO isn_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","“Shanga mulingile kihi lukulu. Shanga musigile kina izipie ku nsoko anyu kina muntu ung'wi utakiwe kusha kunsoko a antu kukila ingu wihi kulimila.” ");
INSERT INTO isn_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Aya shsnga ai umaligitilye kunsoko akwe mukola, badala akwe, kunsoko ai watulaa kuhani mukulu ung'waka nuanso. ai ulotile kina uYesu ukusha kunsoko a ingu, ");
INSERT INTO isn_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","hangi shanga kunsoko a ingu ling'wene duu, ila uYesu walije u uu kuilingiila i ana ang'wa Itunda naza asapatie nkika nia kuli kuli. ");
INSERT INTO isn_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ku lulo kandiilya u luhiku nu lanso nu kulongoleka akanonia nzila a kumubulaga. ");
INSERT INTO isn_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","uYesu shanga ai ugendile hangi kihenga mu Ayahudi, ila ai uhegile pang'wanso nu kulongola ihi nikoli pakupi ni ibambazi mu kisali ni kitangwaa Efraimu. Pang'wanso akikie ni amanyisigwa. ");
INSERT INTO isn_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ila i Pasaka a Ayahudi ai atulaa pakupi, ni idu aka nankila kulongola ku Yerusalemu kunzi a kisali ze ikili i pasaka iti alije ki elya akola. ");
INSERT INTO isn_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ai atulaa akumuduma uYesu, nu kutambula kila ung'wi nai atulaa imikile mi Itekeelo, “Mukusiga ntuni? kina shanga uzile mu siku kuu?” ");
INSERT INTO isn_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Itungo ili i akulu a akuhani ni Afarisayo ai atulaa apumyaa ilagiilyo kina anga itule ung'wi ukulinga kina uYesu ukoli, utakiwe kupumya impola iti kina alije kumuamba. ");
INSERT INTO isn_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Mahiku mutandatu ze ikili ipasaka, uYesu ai wendile ku Bethania, kai ukoli uLazaro, nuanso nai umiukilye ku puma mu ashi. ");
INSERT INTO isn_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ila akamuzipilililya indya nia mpindi kuko, nu Martha akamuaiilya, itungo nilanso uLazaro ai watulaa ung'wi ao nua awo nai ikie mu ndya palung'wi nu Yesu, ");
INSERT INTO isn_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Hangi uMariamu akahola i ratili a manyukiilo nai azipigwe ku nadro nziza, ikete nsailo nkulu, akamupuguhila uYesu mu migulu, nu kumupyagula i migulu ku nsingi ni akwe; ito lihi likizula u unyunki nua manyunkiilo. ");
INSERT INTO isn_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","uYuda Iskariote, ung'wi nua awo ia manyisigwa akwe, naiza yuyo nuika mugumaniilya uYesu, akaligitya. ");
INSERT INTO isn_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Ku niki i manyunkiilo aya shanga aza aguigwe ku dinari magana ataatu nu kinkiiligwa i aula?” ");
INSERT INTO isn_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Nu ng'wenso ai uligitilye nanso shanga kuaisiilya aula, ila ku nsoko ai waatuilee mii; ung'wenso yuyo ai watuile uambiie i mbugulu a mpia hangi ai watuilee wiholaa ing'wi nai aiekilwe mung'wanso kunsoko akwe mukola. ");
INSERT INTO isn_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","uYesu ai uligiyilye, muleke waike nukete ku nsoko a luhiku nula uikwi nu ane. ");
INSERT INTO isn_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","i aula mukutula nienso mahiku ihi, kuiti shanga mukutula nu nene mahiku ihi.” ");
INSERT INTO isn_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Iti gwa i umbi ikulu ni la Ayahudi nai alijaa kulinga nia kina uYesu ukoli kuko, ni eso akapembya shanga kunsoko ang'wa Yesu duu. Ila amihenge nu Petro nai umiulilye kupuma mu ashi. ");
INSERT INTO isn_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ni enso i akulu a kuhani akazipya lukani iti amubulage u Lazaro; ");
INSERT INTO isn_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ndogoelyo kunsoko ayo imakani akwe idu mu Ayahudi ai alongoe yao nu kumuhiila uYesu ");
INSERT INTO isn_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nu luhiku nula kabiili lakwe i umbi ikulu ai lizile mu siku kuu. Nai akija kina uYesu upembilye ku Yerusalemu, ");
INSERT INTO isn_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ai ahoile i ntambi nia makota a mitende nu kupuma kunzi kulongola kumusingiilya hangi akakua iyogo, “Hosiana| Ukendepilwe nuanso nu pembilye ku lina nila Mukulu, Mutemi nua Israeli.” ");
INSERT INTO isn_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","uYesu ai umuligilye u ng'waa ndogwe akanankila; anga uu nai ukiliseigwe. ");
INSERT INTO isn_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Leka kitumba munanso nua Sayuni; goza, uMutemi nuako upembilye, unankie ng'waa ndogwe.” ");
INSERT INTO isn_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Amanyisigwa akwe shanga ai amalingile imakani aya apo u ng'wandyo; kuiti uYesu nai wakakuligwa, papo nai akimbukiiye nia kina imakani aya ai ukiliseigwe nuanso nia kina itumile imakani aya kitalakwe. ");
INSERT INTO isn_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Uugwa idale ilo nila antu nai akoli palung'wi nu Yesu itungo nai umitangile uLazaro kupuma mu kibiila, aka kuiila ku auya. ");
INSERT INTO isn_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Hangi ai ituile ga ni kunsoko iyi kina idale nila antu ai alongoe kumusingiilya ku nsoko ai igulye kina witumile ikilingasiilyo nikanso. ");
INSERT INTO isn_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","iAfarisayo akitambulya i enso ku enso, Goza, itungili shanga muhumile kituma kihi; goza, u unkumbigulu walongolaa kitalakwe.” ");
INSERT INTO isn_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Itungili ang'wi a Ayahudi ai atulaa mu kati ao mu awo nai atulaa alongoe kipolya mu siku kuu. ");
INSERT INTO isn_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Awa ai amuhangile uFilipo, naiza upumiie ku Bethsaida a ku Galilaya, akamulompa aze ligitya, “Mukulu, usese kukete nsula kumihenga uYesu.” ");
INSERT INTO isn_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","uFilipo akalongola akamutambuila uAndrea; uAndrea nu Filipo akalongola nu kumutambuila uYesu. ");
INSERT INTO isn_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","uYesu aka asukiilya, Isaa apika ku nsoko a ng'wana nuang'wa Adamu ku kuligwa. ");
INSERT INTO isn_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Huiili, huiili, kumutambuila, imbeu a ngano anga ileke kugwa mi ihi nu kusha, ikiee uu ing'wene duu, ila anga ishe, ikupa nkali idu. ");
INSERT INTO isn_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nuanso nululoilwe u likalo nu lakwe ukululimilya; ila nuanso nu lubipiwe u likalo nu lakwe mu unkumbigulu uwu uku uhuja ga u upanga nua kali na kali. ");
INSERT INTO isn_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Muntu wihi anga wanzailye unene, nu antyate, nu nene kunkoli, papo nu munyamilimo nuane nuikatula ukoli. Muntu wihi nuikanzaiilya, uTata ukumukulya. ");
INSERT INTO isn_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Itungili i nkolo ane ahusha: nu nene ndigitye uli? 'Tata, ungune mu saa iyi” kuiti ingi ku isigo ili nimipikiie i saa iyi. ");
INSERT INTO isn_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tata, ulikulye i lina ni lako.” Uugwa luli lukaza nu kuligitya “Nalikulyaa nu nene kulikulya hangi.” ");
INSERT INTO isn_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ila ianza nai limikile pakupi ni enso akija, akaligitya nia kina yatula nu mulilo, Auya ai aligitilye, “Malaika witambuuye nu ng'wenso.” ");
INSERT INTO isn_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","uYesu akasukiilya nu kuligitya, Luli ulu shanga luzile ku nsoko ane, ila kunsoko anyu. ");
INSERT INTO isn_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Itungili ulamulwa nua unkumbigulu uwu ukoli; Itungili u mukulu nua unkumbigulu uwu ukugung'wa kunzi. ");
INSERT INTO isn_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nu nene anga nyansulwe migulya ihi, kualuta ihi kitalane.” ");
INSERT INTO isn_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ai wituntile nanso azelagiila ingi nshile kii nuikasha. ");
INSERT INTO isn_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ianza likasukiilya, “Usese kigulye mi lagiilyo nia kina uKristo ukikie i kali na kali. Nu ewe kuligitya uli, 'Ng'wana nuang'wa Adamu kusinja wanyansulwe migulya'? uyu u ng'wana nua muntu ingi nyenyu?” ");
INSERT INTO isn_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ila uYesu aka atambuila, “Welu ukoli palung'wi nu nyenye itungo iniino. Longoli nsoko mukete u welu, iti kina i kiti kileke kumuhumiilya. Nuanso nui longolaa mukiti shanga ulingile kulongoe. ");
INSERT INTO isn_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mukili mukete u welu.” uYesu ai umaligitilye ni hangi akalongola yakwe akipiha aleke kumihenga. ");
INSERT INTO isn_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ga ni iti uYesu aiwitumile ilingasiilyo idu kinya nianso ntongeela ao, akili shanga akahuiila. ");
INSERT INTO isn_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","iti lipikiile ikani ni lang'wa Isaya, nai uligitilye; “Mukulu, ingi nyenyu nai uhuiie inkani yitu? Nu mukono nua Mukulu ukunukuiwe nyenyu?” ");
INSERT INTO isn_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Yiyo nsoko ni anso shanga ai ahuiie, ndogoelyo uIsaya ai uligitilye hangi, ");
INSERT INTO isn_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Uapokuuye imiho, nu kuitenda nkaku i nkolo ni ao; aleke kihenga ku miho ao nu kulinga ku nkolo ni ao, nu kugunika nu nene nikaanguna.” ");
INSERT INTO isn_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","uIsaya ai uligitilye imakani nanso kunsoko ai wihengile ikulyo nilang'wa Yesu nu kuligitya inkani niakwe. ");
INSERT INTO isn_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ga ni iti, ga i akulu idu ai amuhuiie uYesu; kuiti ku nsoko iAfarisayo, shanga ai alapile iti aleke kubagulwa ni Itekeelo. ");
INSERT INTO isn_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ai iloile ikulyo ni ana adamu kukila ikulyo nilipembeeye kung'wa Itungo. ");
INSERT INTO isn_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","uYesu akanyansula ululi nu kuligitya, “Nuanso nunihuiie unene, shanga unihuiie unene duu ila nu ng'wenso nai undagiiye unene, ");
INSERT INTO isn_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","nuanso nunihengile unene umihengile nuanso nai undagiiye. ");
INSERT INTO isn_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Unene nzile anga welu mu unkumbigulu iti kila muntu nu nihuiie unene waleke kikie mu kiti. ");
INSERT INTO isn_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Anga itule umuntu wihi ukija imakani ane kuiti waleke kumaamba, unene shanga kumulamula; ndogoelyo shanga ainzile iti nu ulamule u unkumbigulu, ila nuugune u unkumbigulu. ");
INSERT INTO isn_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nuanso nui nihitaa unene hangi shanga wimagombaa imakani ane, ukete nui mulamulaa; lukani nulanso ni nululigitilye lulo nulikamulamula uluhiku nula mpelo. ");
INSERT INTO isn_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ndogoelyo unene shanga ai ndigitilye ku umi nuane du. Ila ingi Tata nai untwae, ng'wenso mukola ai undagiiye ni nikamatambula nu kumaligitya. ");
INSERT INTO isn_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nu nene ningile nia kina ilagiilyo nilakwe ingi upanga nua kali na kali; ila nanso nikuligitya unene - anga uTata nai umbiie, uu gwa kulingitya kitalao.” ");
INSERT INTO isn_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Itungili ze ikil i siku kuu a pasaka, ku nsoko uYesu ai ulingile kina isaa akwe apikiila naiza ukupuma mihi iyi nu kulongola kung'wa Tata, aze wakili ua loilwe i antu akwe naza akoli mihi, ai ualoilwe impelo. ");
INSERT INTO isn_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nu mulugu ai watulaa wakondyaa kuikwa mu nkolo ang'wa Yuda Iskariote, ng'wana nuang'wa Simioni, kumugumaniilya uYesu. ");
INSERT INTO isn_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","uYesu ai ulingile kina uTata waikaa i intu yihi mu mikono akwe ni kina upumiie kung'wa Itunda ni ai watulaa ulongoe hangi kung'wa Itunda. ");
INSERT INTO isn_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Akauka mu ndya nu kaila pihi u ng'wenda nuakwe nua kunzi. Uugwa ai uhoile i taulo nu kitunga mkola. ");
INSERT INTO isn_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Uugwa akaikila imazi mi ibakuli nu kandya kuakalalya i migulu i amanyisigwa akwe nu kuapyagula ni taulo naiza ai witungile ng'wenso mukola. ");
INSERT INTO isn_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Wakiza kung'wa Simioni Petro, nu Petro akamuila, “Mukulu, Uloilwe kunkalalya i migulu ane?” ");
INSERT INTO isn_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","uYesu akasukiilya nu kumutambuila, “Nikulituma shanga ulilingile itungili, kuiti ukulinga panyambele,” ");
INSERT INTO isn_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","uPetro akamutambuila, “Shanga ukunkalalya imigulu ane nanguluu.” uYesu akamusukiilya “Anga itule shanga kuukalalya, shanga ukutula ni kipango palung'wi nu nene,” ");
INSERT INTO isn_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","uSimioni Petro akamutambuila, “Mukulu, leke kunkalalya i migulu ane duu, ila ga ni mikono ni itwe ni lane.” ");
INSERT INTO isn_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","uYesu akamutambuila, Wihi niiza wakondya koga shanga uloilwe koga kwaala i migulu akwe, hangi watulaa ng'welu u muili nuakwe wihi, unyenye matuilee mielu, kuiti shanga mihi.” ");
INSERT INTO isn_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Kunsoko uYesu ai ulingile uyo nuika mugumaniilya; iyi yiyo nsoko ai uligitilye, shanga mihi matuilee mielu.” ");
INSERT INTO isn_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Matungo uYesu nai watulaa waakalalya i migulu ao nu kutula waholaa ung'wenda nuakwe nu kikie hangi, ai uatambuie, “Itii mukilingile iko naza nu mutendee? ");
INSERT INTO isn_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mukunintanga unene “Ng'walimu” nu Mukulu iti mukuligitya tai, ndogoelyo uu yili. ");
INSERT INTO isn_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Anga itule unene Mukulu nu ng'walimu, nu mukalaaye i migulu anyu, nu nyenye ga mutakiwe kuakalalya i ianyu imigulu. ");
INSERT INTO isn_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kunsoko naminkiilya impyani iyi kina unyenye ga mutende anga unene ni nitumile kitalanyu. ");
INSERT INTO isn_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Huiili, huiili, Kumuila, umutugwa shanga mukulu kukila umukulu nuakwe; ang'wi uyo niiza ulagiigwe ingi mukulu kukila uyo numulagiiye. ");
INSERT INTO isn_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Anga itule ulingile imakani aya, ukendepilwe anga witume. ");
INSERT INTO isn_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Shanga kuligitya kutula unyenye mihi, kunsoko nialingile awo naza niaholanilye - ila kuligitya aya iti kina u ukilisigwa uhume kukaminkiiligwa; Nuanso nuilizaa u mukate nuane unyansuiye i kintiginyo kakwe. ");
INSERT INTO isn_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kumutambuila ili itungili ze ikili kupumila iti kina ni likapumila, muhume kuhuiila kina unene NG'WENSO. ");
INSERT INTO isn_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Huiili, huiil, kumuila, nuinsingiilya unene wimusingiilya naiza kumulagiilya, nu uyo nuinsingiilya unene wimusingiilya uyo nai undagiiye unene.” ");
INSERT INTO isn_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Matungo uYesu nai ukumaligitya aya, ai unyomekile mu nkolo, ai ukuiie nu kuligitya, Huiili, huiili, kumutambuila kina ung'wi mu kati anyu ukungumaniilya.” ");
INSERT INTO isn_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","iAmanyisigwa akwe akigozenkania, aze akuiwe ingi kunsoko ang'wa nyenyu aza uligitilye. ");
INSERT INTO isn_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ai ikoli mu meza, ung'wi nua amanyisigwa akwe wipantamiiye mu kikua kang'wa Yesu uyo naiza uYesu umuloilwe. ");
INSERT INTO isn_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","uSimioni Petro ai umukoiye u mumanyisigwa uyu nu kuligitya, “Kuile ingi nu uli naiza kung'wakwe ukutambula.” ");
INSERT INTO isn_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mumanyisigwa uyo nai wipantamiiye mu kikua kang'wa Yesu nu kumutambuila, “Mukulu, ingi nyenyu?” ");
INSERT INTO isn_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Uugwa uYesu ai usukiiye, “Ingi kung'waakwe uyo ninika liilya intonge a mukati nu kuminkiilya,” Iti gwa nai watula waliilya umukate, ai uminkiiye uYuda ng'wana wang'wa Simioni Iskariote. ");
INSERT INTO isn_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ni ze yakilaau mukate, uMulugu ai umingiie. Uugwa uYesu akautambuila, Iko naza uloilwe kituma kaya ukitume. ");
INSERT INTO isn_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Itungili kutili umuntu mu meza ai ulingile nsoko ang'wa Yesu kuligitya ikani ili kung'waakwe. ");
INSERT INTO isn_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ang'wi ao ai asigile kina, ku nsoko uYuda ai uambile imbugulu a mpia, uYesu ai umutambuie, “Gula i intu ni kuitakile kunsoko a siku kuu,” ang'wi kina utakiwe kupumya kintu ku aula. ");
INSERT INTO isn_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ze yakilaa uYuda kusingiilya u mukate, ai ukaiye kupuma kunzi hangi ai yatulaa utiku. ");
INSERT INTO isn_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Matungo uYuda nai watula wahegaa, uYesu ai uligitilye, “Itungili u ng'wana nuang'wa Adamu wakuligwa, hangi Itunda wakuligwa mu ng'waakwe. ");
INSERT INTO isn_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Itunda uku mukulilya mu ng'waakwe mukola, hangi ukukaya kumukulya. ");
INSERT INTO isn_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ang'yinya aniino, nkoli palung'wi nu nyenye itungo iniino, Mukunduma, ni anga nai niatambuie i Ayahudi, 'Kunongoe, shanga muhumile kupembya,' itungili kumutambuila nu nyenye ga. ");
INSERT INTO isn_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Kuminkiilya ilagiilyo igeni, kina milowe; anga unene naza numuloilwe unyenye, uu nu nyenye ga mutakiwe kilowa unyenye ku nyenye. ");
INSERT INTO isn_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kunsoko a ili iantu akulinga kina unyenye mi amanyisigwa ane, anga itule mukete u ulowa ku kila ung'wi nu muya.” ");
INSERT INTO isn_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","uSimioni Petro ai umutambuie, “Mukulu, ulongoe pii?” uYesu akasukiilya, “Nkika ku nongoe ku itungili shanga ukuhuma kuntyata, kuiti ukuntyata panyambele.” ");
INSERT INTO isn_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","uPetro akamutambuila, “Mukulu, ku niki ndeke ku utyata ga ni itungili? Unene kulupumya u likalo nula ne ku nsoko ako.” ");
INSERT INTO isn_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","uYesu akasukiilya, “Itii uku lupumya u likalo nulako kunsoko ane? Huiila huiila kuutambuila, i nsambaligugu shanga ikukunkula ze ikili kunihita nkua itaatu.” ");
INSERT INTO isn_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Leka kulekela inkolo ako kutula mu lwago. Umuhuiie Itunda ni huiile ga nunene. ");
INSERT INTO isn_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mi ito nilang'wa Tata nuane lukoli u likalo lidu nula kikie; anga aza ihite kutula iti, aza izee natula nakutambuila, ku nulanso nongoe kuzipiililya kianza kunsoko ako. ");
INSERT INTO isn_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Anga nongole nu kumu zipiililya i kianza, nikapemya hangi kumusingiilya kitalane, iti ikianza ni nkoli nu nyenye ga mutule mukoli. ");
INSERT INTO isn_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mulingile i nzila ku nongoe, ");
INSERT INTO isn_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","uTomaso ai umutambuie uYesu, “Mukulu, shanga kulingile i kianza kulongoe; Itii! ku uhuma uli kulinga inzila? ");
INSERT INTO isn_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","uYesu ai umutambuie, “Unene yiyo nzila, tai nu upanga; kutili nu uhumile kupemya kung'wa Tata kwaala kukiila kitalane. ");
INSERT INTO isn_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Anga aize muningile unene, aize matulaa mamulingaa nu Tata ga; kandiilya itungili nu kulongoleka mamulingaa hangi mamihengaa u ng'wenso.” ");
INSERT INTO isn_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","uPhilpo ai umutambuie uYesu, “Mukulu, kulagiile uTata ni iti ikutula yakondya.” ");
INSERT INTO isn_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","uYesu akamutambuila, “Shanga natulaa palung'wi nu nyenye ku itungo ilipu, hang ukili shanga uningile unene, Philipo? Wihi nuanihengilee unene wamihengaa uTata; Kinya uli ukuligitya, 'kulagiile uTata? ");
INSERT INTO isn_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Shanga muhuiie kina unene nkoli mukati ang'wa Tata, nu Tata ukoli mukati ane, Makani ni kumaligitya kitalanyu shanga kumaligitya ku isigo nilane mukola, badala akwe, ingi Tata nuikiie mukati ane nukituma u mulimo nuakwe. ");
INSERT INTO isn_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nihuiili unene, kina nkoli mukati ang'wa Tata, nu Tata ukoli mukati ane; Ga ni iti nihuiili unene ku nsko a milimo ane kulu kuulu. ");
INSERT INTO isn_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Huiili, huiili, kumuila, nuanso nunihuiie unene, milimo iyo ni nitumaa, ukituma ga ni milimo iyi; nangi ukituma ga ni milimo mikulu ku nsoko nalongolaa kung'wa Tata. ");
INSERT INTO isn_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Kihi anga mulompe ku lina nilane, nikituma iti kina uTata wahume kukuligwa mu ng'wana. ");
INSERT INTO isn_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Anga mulompe kintu kihi ku lina nilane, nilanso kituma. ");
INSERT INTO isn_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Anga mundowe, mukuamba i malagiilyo ane. ");
INSERT INTO isn_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Hangi nika mulompa uTata, Nu ng'wenso ukuminkiilya u muaiilya mungiiza iti kina ahume kutula palung'wi nu nyenye i kali na kali. ");
INSERT INTO isn_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ng'wau Ng'welu nua tai. u Unkumbigulu shanga uhumule kumusingiilya nuanso ku nsoko shanga umihengile, ang'wi kumumanya nuanso. Ga ni iti unyenye mumulingile nuanso. Kuiti wikiie palung'wi nu nyenye nu kutula mukati anyu. ");
INSERT INTO isn_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Shanga kumuleka ming'wene; Nikasuka kitalanyu. ");
INSERT INTO isn_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ku itungo ihelu, u unkumbigulu shanga ukunihenga hangi, kuiti unyenye mukunihenga. Ku nsoko ni kiie, ga nu nyenye mukikie. ");
INSERT INTO isn_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mu luhiku nulanso mukulinga kina unene nkoli mukati ang'wa Tata, ni kina unyenye mukoli mukati ane, ni kina unene nkoli mukati anyu. ");
INSERT INTO isn_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Wihii nui ambaa i malagiilyo ane nu kituma, yuyo ung'wi niiza undoilwe unene; hangi niiza undoilwe unene wikalowa nu Tata nuane, Hangi nikamulowa hangi nikigeeleka unene mukola kitalakwe.” ");
INSERT INTO isn_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","uYuda (shanga Iskariote) akamuila uYesu, “Mukulu, Itii ingi ki ntuni kikupumila kina ukigeeleka mukola kitaitu ni shanga ku unkumbigulu? ");
INSERT INTO isn_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","uYesu ai usukiiye akamutambuila, “Anga ize wihi ukundowa, ukuluamba u lukani nu lane, nu Tata nuane ukumulowa, hangi kikapembya nu kuzipya likalo litu palung'wi nu ng'wenso. ");
INSERT INTO isn_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Wihi niiza shanga undoilwe unene, shanga wiambaa u lukani nulane. Lukani naza mukija shanga lane ila lang'wa Tata naza undagiiye. ");
INSERT INTO isn_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nimaligitilye imakani aya kitalanyu, itungo ni nkili kikie mukati anyu. ");
INSERT INTO isn_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ga ni iti, uMupoeelyi, Ng'wau Ng'welu, naiza uTata ukumulagiilya ku lina lane, ukumumanyisa i makani ihi hangi wikamutenda mukimbukiilye ihi naiza nimaligitilye kitalanyu. ");
INSERT INTO isn_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","U ulyuuku, kuminkiilya ulyuuku nuane unyenye, shanga kuminkiilya uwu anga unkumbigulu nuipumyaa. Leki kuzipyi inkolo nianyu kutula nu lwago, nu woa. ");
INSERT INTO isn_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ai migule iti nai numutambuie, 'Nongoe yane, hangi nikasuka kitalanyu, 'Anga aza ize mundoilwe unene, aza muze mukete ulowa kunsoko nongoe kung'wa Tata, kunsoko uTata ingi mukulu kukila unene. ");
INSERT INTO isn_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Itungili nakondyaa kumutambuila ze ikili kupumila iti kina, itungo anga lipumile, muhume kuhuiila. ");
INSERT INTO isn_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Shanga kutambula nu nyenye makani idu, kunsoko mukulu nua ihi iyi upembilye, Nuanso mugila ingulu migulya lane, ");
INSERT INTO isn_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","kuiti kina u unkumbigulu ulije kulinga kina numuloilwe uTata, nitumaa iko uTata nukundagiilya unene, anga iti nai uninkiiye ilagiilyo. Nyansuki, hangi kupume i kianza iki. ");
INSERT INTO isn_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Unene ni muzabibu nua tai, nu tata nuane ingi mulimi nua mizabibu. ");
INSERT INTO isn_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kila itambi mukati ane niiza shanga lipaa i nkali wi lihenguila, ni kila itambi ni llipaa inkali wilelyaa iti kina lihume kupa ikilo. ");
INSERT INTO isn_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Unyenye yakondaa kutula mielu kunsoko a lukani naza nakondyaa kumutambuila. ");
INSERT INTO isn_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mikie mukati ane, nu nene mukati anyu. Anga itambi ni shanga lihumile kupaa ling'wene, anga lihite kutula mu muzabibu, ga ni iti unyenye, anga muhite kikie mukati ane. ");
INSERT INTO isn_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Unene ingi ni muzabibu; unyenye mi ntambi. Nuikiie mukati ane nu nene mu kati akwe, muntu uyu wipezaa nkali idu, kunsoko anga ize shanga nene shanga muhuile kituma ikani lihi. ");
INSERT INTO isn_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Anga itule muntu wihi shanga ukusaga mukati ane, ukugung'wa anga itambi nukuma; antu ilingiila i ntambi nu kugumila mu moto, nu kulimila. ");
INSERT INTO isn_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Anga itule mukikie mukati ane, hangi anga imakani ane ikie mukati anyu, lompi lihi ni muloilwe, nu nyenye mukutendelwa. ");
INSERT INTO isn_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mu ili uTata nuane ukuigwe, kina mipezaa nkali idu ni kina ingi mi amanyisigwa ane. ");
INSERT INTO isn_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Anga uTata nuane nai undoilwe unene, Ga nu nene namulowaa unyenye; ikii mu ulowa nuane. ");
INSERT INTO isn_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Anga itule mikaamba i malagiilyo ane, mukikie mu ulowa nuane anga ni mambiie i malagiilyo ang'wa Tata nu ane nu kikie mu ulowa nuakwe. ");
INSERT INTO isn_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ni maligitilye i makani aya kitalanyu iti kina iloeelya nilane litule mukati anyu ni iti kina iloeelya ni lanyu litulike kutula likondaniie. ");
INSERT INTO isn_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ili lilo ilagiilyo nilane, kina milowe unyenye ku nyenye anga nai numuloilwe unyenye. ");
INSERT INTO isn_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kutili u muntu nukete u ulowa ukulu kukila uwu, kina walupumye u likalo nu lakwe ku nsoko a ahumba uya. ");
INSERT INTO isn_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Unyenye mi ahumba iane anga itule mukituma ayo ni neenda mulagiilya. ");
INSERT INTO isn_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Shanga kumitanga atugwa, ku nsoko u mutugwa shanga ulingile iko nuitumaa u mukulu nuakwe. Numitangile unyenye ahumba iane. ku nsoko namukumuila i makani ihi naiza nigulye kupuma kung'wa Tata. ");
INSERT INTO isn_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Shanga ai muniholanilye unene, ila unene ai numuholanilye unyenye nu kumuika mulongole mupe inkali, ni nkali yanyu ilije kikie. Ili likoli iti kina kihi ni mukulompa kung'wa Tata ku lina ni lane, ukuminkiilya. ");
INSERT INTO isn_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Makani aya kumulagiilya, kina milowe kila muntu nu muya. ");
INSERT INTO isn_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Anga ize u unkumbigulu ukumubipilwa, mulinge kina ai umbipiwe unene ze ikili kumubipilwa unyenye. ");
INSERT INTO isn_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Anga aza mutule mia unkumbigulu, u unkumbigulu aza uzee mulowa anga mia kitalao; Kuiti ku nsoko shanga mia unkumbigulu hangi kunsoko ai numuholanilye kupuma mu unkumbigulu, ingi kunsoko ili u unkumbigulu wimubipilwa. ");
INSERT INTO isn_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kimbukiilyi ikani naiza numutambuie, 'uMutugwa shanga mukulu kukila umukulu nuakwe, 'Anga itule ai anagilye unene, akumaja nu nyenye ga; Anga izee ai a ambile u lukani nulane, ai azee amba nulu nulanyu ga. ");
INSERT INTO isn_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Akumutendeela makani aya ihi kunsoko a lina ni lane kunsoko shanga amulingile uyo numulagiiye. ");
INSERT INTO isn_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Anga aza itule shanga aza nzile nu kuatambuila, shanga ai azeetula itumile u mulandu; kuiti itungili agila u winegi ku milandu ao. ");
INSERT INTO isn_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nuimbipilwaa unene wimubipilwaa nu Tata ga. ");
INSERT INTO isn_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Anga itule shanga nitumile u mulimo mukati ao naiza kutili nung'wi nai witumile, ai azeetula agila u mulandu; kuiti itungili itumile ihi abiili ihengile hangi ambipiwe unene nu Tata nuane. ");
INSERT INTO isn_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ili likupumila iti kunsoko lukani lukondaniile naiza lukilisigwe mi ilagiilyo ni lao; 'Ambipiwe unene bila nsoko.' ");
INSERT INTO isn_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","27","Itungo u mupooelya nuazaa, naiza numulagiiye kitalanyu kupuma kung'wa Tata, uyu yuyo, Ng'wau ng'welu nua tai, naiza ukupembelya kung'wa Tata, ukunkuiila. Ga nu nyenye muku nkuiila kunsoko matulaa palung'wi nu nene puma ung'wandyo. ");
INSERT INTO isn_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Numutambuie imakani aya iti muleke kutakigwa. ");
INSERT INTO isn_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Akumupumya kunzi a Matekeelo; Kulu kuulu isaa ipembilye niiza kila nuikamubulaga ukusiganiilya kina ukituma mulimo uziza ku nsoko ang'wa Itunda. ");
INSERT INTO isn_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Akumutendeela aya ku nsoko shanga amumanyile u Tata ang'wi shanga amanyile unene. ");
INSERT INTO isn_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Numutambuie imakani aya iti kina itungo anga lipike nila aya kupumila, muhumile kukimbukilya ni kinya nai numutambuie muhume kitalao. Shanga numutambuie kutula i makani aya ung'wandyo ku nsoko ai natulaa palung'wi nu nyenye. ");
INSERT INTO isn_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Anga itule, itungili nongoe kung'wa uyo nai undagiiye; kuiti kutili mukati anyu nukunkolya, “Ulomgoe pii?” ");
INSERT INTO isn_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ku nsoko nimaligitilye imakani aya kitalanyu, kinya uwai kizue mu nkolo yanyu. ");
INSERT INTO isn_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ga ni iti, kumutambuila itai; ku ndogoelyo anga nihite kuhega, u mupoelya shanga uzile kitalanyu; kuiti anga nongole nikamulagiilya kitalanyu. ");
INSERT INTO isn_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Anga waze, u mupoelya nuanso uku ukaminkiilya u unkumbigulu kutulika nu ulamulwa. ");
INSERT INTO isn_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kutulika ni milandu, ku nsoko shanga ai anihuiie unene, ");
INSERT INTO isn_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","kutulika ni tai ane, kunsoko nongoe kung'wa Tata, shanga mukunihenga hangi; ");
INSERT INTO isn_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ni kutulika nu ulamulwa kunsoko u mukulu nua unkumbgulu uwu walamuwe. ");
INSERT INTO isn_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Nimakete idu nakumutambuila, kuiti shanga mukumalinga itungili. ");
INSERT INTO isn_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kuiti, nuanso, Ng'wau ng'welu nua tai, anga waze, ukumutongeela mu tai a ihi; ku nsoko shanga ukuligitya ku nsoko akwe mukola; kuiti ihi nuikija, ukumaligitya imakani nanso; hangi ukumakaminkiilya kitalanyu imakani ni ikapembya. ");
INSERT INTO isn_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nuanso wikankulya unene, kunsoko ukumahola imakani ane hangi ukumatanantya kitalanyu. ");
INSERT INTO isn_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Intu yihi nuikete uTata ingi yane; ku lulo, naligityaa kina uNg'wau ng'welu ukuhola imakani ane nu kumakaminkiilya kitalanyu. ");
INSERT INTO isn_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ikili itungo ikupi, shanga mukunihenga hangi; ni ize yakilaa itungo ikupi hangi, mukunihenga.” ");
INSERT INTO isn_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ang'wi a amanyisigwa akwe akitambulya, “Ingi ntuni nu kuutambuila, “itungo ikupi, hangi shanga mukunihenga hangi,' ni, uugwa, itungo ikupi mukunihenga,' ni, 'ku nsoko nongoe kung'wa Tata?” ");
INSERT INTO isn_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ku lulo akaligitya, “Ingi kintu kii nukuligitya, 'Ikili itungo ikupi'? Shanga kulingile nukuligitya.” ");
INSERT INTO isn_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","uYesu ai uine kina ai ahung'waa nsula kumukolya, nu ng'wenso aka atambuila, Mukikolya akola kutula ili, ni ndigitilye, 'Ikili itungo ikupi, shanga mukanihenga hangi; ni ze yakilaa itungo ikupi mukunihenga'? ");
INSERT INTO isn_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Huiili, huiili, kumutambuila, mukulila nu kuhongeelya, kuiti u unkumbigulu ukulumbiilya, mukutula ni kinya uwai kuiti kinya uwai kanyu kikupiluka kutula iloeelya. ");
INSERT INTO isn_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","uMusungu witulaa ni kinya uwai itungo nuitulaa nu uwai kunsoko itungo nila kitunguila lapikaa; kuiti nuikitunguila ung'wana, shanga wikimbukiilya hangi u uwai kunsoko a iloeelya ni lakwe kina ng'wana watug'waa mi ihi. ");
INSERT INTO isn_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nu nyenye ga mukete kinya uwai itungili, kuiti nikamihenga hangi; ni nkolo nianyu yukiloa hangi kutili nuikahuma kuliheja iloelya ni lanyu. ");
INSERT INTO isn_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Luhiku nu lanso shanga mikankolya i makolyo. Huiili, huiili, kumutambuila, Anga mulope lihi kung'wa Tata, ukuminkiilya ku lina nilane. ");
INSERT INTO isn_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kupikiila itungili mukili kulompa lihi ku lina nilane; lompi, nu nyenye mukusingiilya iti kina iloeelya nilaanyu likondaniile. ");
INSERT INTO isn_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Nitambuuye nu nyenye ku ntambu ni shanga ilingikile, kuiti isaa ipembilye niiza shanga kitambulya ku ntambu ni shanga ilingikile kuiti badala akwe nikamutambuila kihenga kutula uTata. ");
INSERT INTO isn_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Luhiku nulanso mukulompa ku lina nilane, hangi shanga kumuila kina nikalompa kung'wa Tata ku nsoko anyu; ");
INSERT INTO isn_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Kunsoko uTata mukola umuloilwe ku nsoko manihuiie kina mpumiie kung'wa Tata. ");
INSERT INTO isn_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ai mpumiie kung'wa Tata nu kupembya mu unkumbigulu; hangi, kuhega mu unkumbigulu nu kulongola kung'wa Tata.” ");
INSERT INTO isn_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Amanyisigwa akwe akamutambuila, “Ukihenga, itungili ukuligitya i kihenga hangi shanga ukutumila ihalityo. ");
INSERT INTO isn_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Itungili, kalingaa kina ulingile imakani ihi, ni shanga uloilwe muntu wihi wakukolye imakolyo. Kunsoko ili kahuiila kina upembeeye kung'wa Tata. ");
INSERT INTO isn_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","uYesu aka asukiilya, “Itungili mahuiila?” ");
INSERT INTO isn_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Goza, isaa ipembilye, ee ni kulu kuulu apikaa, niiza mikasapatila kila ung'wi nu ku kitalao mukundeka umukola. Kuiti shanga nkoli ni ng'wene duu kunsoko uTata ukoli nu nene. ");
INSERT INTO isn_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Kumutambuila imakani aya iti kina mukati anyu mutule nu ulyuuku. Mihi mukete lwago, kuiti ipii i nkolo, nauhumaa u unkumbigulu. ");
INSERT INTO isn_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","uYesu ai umaligitilye i makani aya, uugwa akanyansula i miho akwe kutunga kilunde nu kuligitya, “Tata, isaa apikiila; mukulye u ng'wana nuako iti nu ng'wenso akukulye u ewe. ");
INSERT INTO isn_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","anga iti nai uminkiiye i ngulu migulya a yihi ni ikete u muili iti ainkiilye u upanga nua kali na kali awo ihi nai uminkiiye ");
INSERT INTO isn_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Uwu wuwo upanga nua kali na kali; kina akulinge u ewe, Itunda nua tai hangi wing'wene, nu ng'wenso nai umulagiiye, uYesu Kristo. ");
INSERT INTO isn_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ai nukukuiye apa mihi, nu kukondaniilya u mulimo nai uninkiye nuitume. ");
INSERT INTO isn_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Itungili, Tata, unkulye unene palung'wi nu ewe mukola ku ikulyo ilo nai nkoli ni lyenso palung'wi nu ewe ze ikili u unkumbigulu kuumbwa. ");
INSERT INTO isn_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ai nilikunukue i lina nilako ku antu nai uninkiiye apa mi ihi. Ai atulaa antu ako; kuiti ai waninkiilya unene. ni enso aluambilaa u lukani nulako. ");
INSERT INTO isn_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Itungili alingile kina kila kintu nu ninkiiye u nene kipumiie kitolako, ");
INSERT INTO isn_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ku makani ayo nai uninkiiye u nene - Nakondya ku inkiilya enso i makani nanso. Ai amasingiiye ni tai akalinga kina unene mpumiie kitalako, nu kuhuiila kina uewe yuyo ai undagiiye. ");
INSERT INTO isn_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Kualompeela enso. Shanga ku ulompeela u nkumbigulu ila awo nai ununkiiye ku nsoko i enso ingi ako. ");
INSERT INTO isn_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Intu yihi naiza ingi yane ingi yalo, ni izo nuikete uewe ingi yane; nu nene nikukulyaa mu nianso. ");
INSERT INTO isn_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","uNene nimutili hangi mu unkumbigulu, ila nianso amoli mu unkumbigulu, unene itungili napembyaa kitalako. Tata nu ng'welu, akulye ku lina nilako ilo nai ukinkiiye usese iti kina ni enso atule nu ung'wi, anga unene nu ewe ni kukete u ung'wi. ");
INSERT INTO isn_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nai natulaa ni enso, ai niasungilye ku lina nai uninkiiye; Ai naasunjaa, hangi kutili ga nung'wi ao nai ulimie kwaala ng'wana nuaa mulimili, iti kina ukilisigwa ukondaniile. ");
INSERT INTO isn_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Itungili napembyaa kitolako; kuiti kumaligitya aya mu unkumbigulu iti kina iloeelya ni lane likondaniile mukati ao akola. ");
INSERT INTO isn_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nainkiilya ikani nilako; u unkumbigulu waabipilwaa ku nsoko i enso shanga a unkumbigulu, anga iti unene ni shanga ntuile nia unkumbigulu. ");
INSERT INTO isn_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Shanga kualompelya kina uaheje mu unkumbigulu ila uasunje nu uyo u mubii. ");
INSERT INTO isn_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nianso shanga ihi anga iti unene ni shanga ntuile nia mu unkumbigulu. ");
INSERT INTO isn_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Uaike mu ikulyo kitalako mu kola mu tai; lukani nulako lulo tai. ");
INSERT INTO isn_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ai undagiiye mu unkumbigulu, nu nene na alagiilya mu unkumbigulu. ");
INSERT INTO isn_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kunsoko ao unene mukola kipumyaa kitalao iti kina ni enso ipumye ki tolako ku iyo itai. ");
INSERT INTO isn_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Shanga wawa duu ni kualompelya, ila ni awo ni ikahuiila kukiila lukani nulao ");
INSERT INTO isn_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","iti kina ni enso atule nu ung'wi, anga iti uewe Tata, nuili mukati ane nu nene mukati ako. Kualompelya iti kina ni enso ga ahume kutula mu kati itu iti u unkumbigulu uhume kuhuiila kina uewe yuyo ai undagiiye. ");
INSERT INTO isn_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ikulyo ilo nai uninkiiye unene - nainkiilya enso, iti kina ahume kutula nu ung'wi, anga iti usese ni kili ung'wi - ");
INSERT INTO isn_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Unene mukati ao, nu ewe mukati ane, iti ahume kukondeeligwa mu ung'wi; iti u unkumbigulu ulinge kina kulu kuulu uewe yuyo nai undagiiye, nu kualowa, anga iti uewe nuizaa undoilwe, unene. ");
INSERT INTO isn_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tata, iko nai uninkiiye unene - Nkete nsula kina ni enso ga ahume kutula palung'wi nu nene kianza ni nkoli iti ahume kihenga ikulyo nilane, ilo nai uninkiiye: ku nsoko uewe ai undoilwe unene ze ikili kuumbwa u musingi nua unkumbigulu. ");
INSERT INTO isn_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tata munya tai ane, u unkumbigulu shanga ai ukulingile uewe; kuiti unene nukulingile uewe; hangi alingile kina ai undagiiye. ");
INSERT INTO isn_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nilizipilye ilina nilako likumuke kitalao, hangi kulizipya likumuke iti kina u ulowa uwo naiza ku nuanso ai undoilwe unene uhume kutula mukati ao, nu nene nihume kutula mukati ao.” ");
INSERT INTO isn_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ze yakilaa uYesu kuligitya imakani aya, ai uhegile ni amanyisigwa akwe kulongola ku ng'wapo nua kidron, naize ikoli inzega, naize ung'wenso ni amanyisigwa akwe akingila mukati akwe. ");
INSERT INTO isn_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Itungili uyo uYuda, nai walowaa kumuhulyaa, nu ng'wenso ai ulingile nkika nanso, kuiti uYesu ai watulaa wilongolaa inkika iyi nkua kitungaa aze ukoli ni amanyisigwa akwe. ");
INSERT INTO isn_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nu ng'wenso uYuda, ze yakilaa kutula walijaa idale ni la asikali ni a ofisa puma ku akulu a akuhani, akapembya aze akete ni muli, tochi ni yigi. ");
INSERT INTO isn_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Nu ng'wenso uYesu, iti aze uilgile kila ikintu nai katula kikitung'wa kung'wa akwe, akapumila ntongeela nu kuakolya, “Ingi nyenyu ni mukumuduma?” ");
INSERT INTO isn_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nienso aka musukiilya, “Yesu Munazareti.” Nu ng'wenso uYuda nai umugumaniiye, ai watulaa wimikile palung'wi ni awo i asikali. ");
INSERT INTO isn_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ku lulo nai waatambuila, “Unene ng'wenso” ai asukile kinyuma nu kugwa pihi. ");
INSERT INTO isn_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Hangi aka akolya, “Ingi nyenyu ni mukumuduma? Ni enso akamusukiilya hangi “Yessu munazareti.” ");
INSERT INTO isn_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","uYesu aka asukiilya, “Nakondyaa kumuila kina Unene ng'wenso; ku lulo anga ize mukunduma nene, aleki awa i auya alongole.” ");
INSERT INTO isn_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Aya ai atulaa iti lukani ulo lukaminkiile; apo nai uligitilye; “Mu awo nai ununkiiye, shanga numulimiiye ga nung'wi.” ");
INSERT INTO isn_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Uugwa uSimioni Petro, naiwatulaa ni mpanga, akamipyagula nu kumutema kutyi nua kigoha umunya milimo nuang'wa Kuhani nu mukulu. Ni lina nilakwe u munya milimo nuanso ai latulaa Malko. ");
INSERT INTO isn_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","uYesu akamutambuila uPetro, “Susha i mpanga ako mu hala akwe. Ku niki ndeke kuking'wela i kikombe iko nuninkiiye uTata?” ");
INSERT INTO isn_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Uugwa idale ilo nila asikali ni ajemedari, ni anyamilimo a Ayahudi, ai amuambile uYesu nu kumutunga. ");
INSERT INTO isn_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nienso akamutonga hanza kupikiila kung'wa Anasi, ku iti ung'wenso ai watulaa mukwingwa nuang'wa Kayafa, naiza yuyo ai watulaa Kuhani nu mukulu ku ng'waka nuanso. ");
INSERT INTO isn_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Itungili uKayafa yuyo ai watulaa uinkiiye isigo i Ayahudi nila kina utakiwe muntu ung'wi washe ku noko a antu. ");
INSERT INTO isn_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","uSimioni Petro ai umutyatile uYesu, ni u umu manyisigwa nu muya. Nu munyisigwa uyu ai watulaa umanyikile kung'wa Kuhani nu mukulu, nu ng'wenso akingila palung'wi nuYesu mi itando nilang'wa Kuhani nu mukulu; ");
INSERT INTO isn_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","kuiti uPetro ai watulaa wimikile kunzi a mumpita. Uugwa uyo umu manyisigwa nai watulaa umanyikile kung'wa Kuhani nu mukulu, ai upumile kunzi akalongola kitambuila nu musungu uyu munyamilimo nai watulaa ukusunja u mumpita nu kumingilya uPetro mukati. ");
INSERT INTO isn_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Uugwa mutugwa uyo nai watulaa ukusunja u mumpta, akamutambuila uPetro, “Itii uewe shanga wi ung'wi nua atyatiili a muntu uyu?'” Nung'wenso akasukiilya, “Unene shanga.” ");
INSERT INTO isn_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ni awo i anyamilimo ni akulu ai atulaa imikile ikianza nikapa ng'wanso; akota moto ku ndogoelyo, ai ukoli ulyuuku, ni iti ai atulaa akota moto iti alije ilugute, Nu ng'wenso uPetro ai watulaa ni enso, ukota moto aze wimikile. ");
INSERT INTO isn_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kuhani nu mukulu akamukolya uYesu migulya a amanyisigwa akwe nu umanyisigwa nuakwe. ");
INSERT INTO isn_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","uYesu akamusukiilya, “Nuutambuie kihenga u unkumbigulu; Unene ai manyisilye nkua ku nkua mu matekeelo ni itekeelo ni ikulu kianza naiza i Ayahudi ilingiila. Nunene shanga ai ndigitilye kihi mu kinkunku. ");
INSERT INTO isn_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ku niki ai munkoiye? Akolyi nai antegeeye migulya a iko nai ndigitilye. iAntu awa alingile imkani ayo nai nimaligitilye. ");
INSERT INTO isn_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","uYesu nai wakondya kuligitya nanso, ung'wi nua akulu nai watulaa wimikile akamukua uYesu ku mukono nuakwe ni uugwa akaligitya, ");
INSERT INTO isn_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","“Itii, uu nutakiwe kumusukiilya umukulu?” Nu ng'wenso uYesu akamusukiilya, “Anga ize ndigitilye ikani lihi ibibi uugwa utule wimukuiili ku nsoko a ubii, ni anga ize numusukiiye iziza ku niki ukunkua? ");
INSERT INTO isn_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Uugwa uAnasi nai wakamutwala uYesu kung'wa Kayafa kuhani nu mukulu aze utungilwe. ");
INSERT INTO isn_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Itungili uSimioni Petro ai watulaa wimikile ukipupya iluguti u mukola. Ga ni iti antu awo akamutambuila, “Itii, ga nu ewe shanga ung'wi nua amanyisigwa akwe?” Akahita azeligitya, “Unene shanga.” ");
INSERT INTO isn_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ung'wi nua anyamilimo ang'wa Kuhani nu mukulu, Naiza ai watulaa muluna wang'wa uyo u mugoha naiza uPetro umutemile u kutyu, ai uligitilye, “Itii, shanga u ewe naza nukihengile uko ku nzega?' ");
INSERT INTO isn_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","uPetro akahita hangi, ni nkua i nsamba ligugu ika kunkula. ");
INSERT INTO isn_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Uugwa akamuhola uYesu puma kung'wa Kayafa kupikiila mu Praitorio. Ai yatulaa dau mania mbwa. Enso akola shanga ai ingiie ilo iPraitorio iti aleke kishapula nu kumilya i pasaka. ");
INSERT INTO isn_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ku lulo uPilato aka ahanga nu kuligitya, “Ingi usemelwa kii nu umutuile umuntu uyu?” ");
INSERT INTO isn_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Akamusukiilya nu kumutambuila, “Anga aza ize umuntu uyu watule shanga mituma ubibi, shanga azaa kuzeemuleta kitalako.” ");
INSERT INTO isn_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","uPilato aka atambuila, Muholi unyenye akola, mende mumulamule kuniganiila ni lagiilyo nilanyu.” Ni enso i Ayahudi akamutambuila, 'Ilagiilyo shanga likulekee usese kumubulaga muntu wihi.” ");
INSERT INTO isn_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ai aligitilye aya iti lukani nu lang'wa Yesu lukondaniile, lukani naiza watulaa wakondyaa ligitya migulya a mpyani a nsha akwe. ");
INSERT INTO isn_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Uugwa uPilato akingila mu praitorio akamitanga uYesu; akamutambuila, “Itii, uewe wi mutemi nu Ayahudi?' ");
INSERT INTO isn_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","uYesu akamusukiilya, '“Itii, uewe ukunkolya ikolyo ili ku nsoko uloilwe kulingaa ang'wi ku nsoko angiiza akulagiiye iti unkolye unene?” ");
INSERT INTO isn_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Nu ng'wenso uPilato akamusukiilya, “Unene shanga ni Muyahudi, ang'wi shanga?” Ingu nuako ni a kuhani akulu wawo niakuletile kitalane; uewe witumile ki ntuni? ");
INSERT INTO isn_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","uYesu aka sukiilya; “Uutemi nuane shanga nua unkumbigulu uwu, anga ize u utemi nuane azautule ni patyo mu unkumbigulu uwu atung'waa ane aza aze ninkuilya iti ndeke kupumigwa ku Ayahudi. Ku tai u utemi nuane shanga upumile apa” Ila ");
INSERT INTO isn_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","uPilato akamutambuila, “Itii, uewe gwa wi mutemi?” uYesu akasukiilya, “u ewe yuyo ukuligitya kina unene ni mutemi, ku nsoko iyi unene ai ntugilwe ni ku nsoko iy unene nazilee mu unkumbigulu iti ntule numukuiili nua tai. Wihi nuailee wa tai iyo witegeelya u luli nuane. ");
INSERT INTO isn_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","uPilato akamutambuila, “Itai ki ntuni?” Nu ng'wenso nai wakondya kuligitya aya akalongola ku Ayahudi nu kuatambuila, “shanga kihenga mu muntu uyu kihi. ");
INSERT INTO isn_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Unyenye mukete logo nulanyu nu ukuntenda nu mutunguile ung'wi itungo nila pasaka. Itii muloilwe numutunguile mutemi nua Ayahudi.” ");
INSERT INTO isn_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Uugwa akakua iyogo azeligitya, shanga yuyu, kutunguilye uBaraba.” nu ng'wenso uBaraba ai watulaa muhegelanyi. ");
INSERT INTO isn_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Uugwa uPilato ai umuhoile uYesu nu kumutandika. ");
INSERT INTO isn_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Awo i a asikali akahoeela i mija nu kunonia i ngala. akamiika migulya itwe nilang'wa Yesu nu kumutugalya u ng'wenda nua ung'ole wa zambarau. ");
INSERT INTO isn_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Akamuziila nu kuligitya, “Uewe mutemi nua Ayahudi ni uugwa kumukua ku ikono ao. ");
INSERT INTO isn_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Uugwa uPilato ai upumile kunzi nu kuatambuila i antu, “Goza namuletelaa u muntu uyu kitalanyu iti mulinge kina unene shanga aza mine igazo lihi mukati akwe.” ");
INSERT INTO isn_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Kululo uYesu akapuma kunzi; ai watulaa utugae ngala a mija nu ng'wenda nua zambarau. Uugwa uPilato aka atambuila, “Gozeeli u muntu uyu apa!” ");
INSERT INTO isn_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kululo itungo uKuhani mukulu ni akulu nai akamihenga uYesu, akakua iyogo azeligitya, “Majee, majee.” uPilato aka atambila, “Muholi unyenye akola mende mumaje, ku noko unene shanga nihenga igazo mukati akwe. ");
INSERT INTO isn_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ayahudi akamusukiilya uPilato, “Usese kukete ilagiilyo, nu ki ilagiilyo nilanso, utakiwe kusha kunsoko nuanso ukitendisa kina ng'wana wan'gwa Itunda.” ");
INSERT INTO isn_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","uPilato nai wakija imakani aya aka kilinkiila kitumba, ");
INSERT INTO isn_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","akingila mu Praitorio hangi nu kumutambuila uYesu, “Uewe upumiie pii? Ga ni iti, uYesu shanga akamusukiilya. ");
INSERT INTO isn_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Uugwa uPilato akamutambuila, “Itii, uewe shanga ukuligitya nu nene? Itii, uewe shanga ulingile kina unene nkete u uhumi nua kuutunguila nu uhumi nua kuaja?” ");
INSERT INTO isn_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","uYesu akamusukiilya, “Shanga aza uzeetula ni ngulu kung'waane anga aza uhite kinkiiligwa kupuma kigulya. Kululo, muntu numpumilye kitolako ukete mulandu ukulu.” ");
INSERT INTO isn_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kupumeiila mi sosho ili, uPilato akalowa kumuleka ilyuuku, kuiti iAyahudi akazogolya azeligitya, “Anga ize ukumuleka ilyuuku uugwa uewe shanga wi muhumba muya wang'wa Kaisari; Kila nuitendisaa kina mutemi wiligityaa nsuta ang'wa Kaisari.” ");
INSERT INTO isn_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","uPilato nai wakija imakani aya, akamuleta uYesu kunzi uugwa akikie mituntu nila ulamuli kianza iko nikikumukile anga sakafu, kuiti ku Kiebrania, Gabatha. ");
INSERT INTO isn_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Luhiku nula kuzipiilya i pasaka nai lapika, anga itungo nila saa mutandatu. uPilato aka atambuila iAyahudi, Gozeeli u mutemi nuanyu suyu papa!” ");
INSERT INTO isn_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Akazogolya, “Muheje, muheje, maje!” uPiato aka atambuila, “Itii, numaje u mutemi nua nyu?” Nu ng'wenso uKuhani nu mukulu akasukiilya, “Usese kiagila u mutemi kwaala Kaisari.” ");
INSERT INTO isn_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Uugwa uPilato nai wakamupumya uYesu kitalao wagigwe. ");
INSERT INTO isn_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Nienso akamuhola uYesu, nu ng'wenso akapuma, aze u ukenkile ikota nila mpaga nilakwe mukola kupikiila mu kianza ni litangwaa ing'ang'a litwe, ku ki Ebrania litangwaa Golgota. ");
INSERT INTO isn_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Papo nai amagilye uYesu palung'wi nu ng'wenso agoha abiili, ung'wi nkika iyi nu muya nkika iyi, nu Yesu pakati ao. ");
INSERT INTO isn_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Uugwa uPilato akakilisa logo nu kuluika migulya a ikota nila mpaga. Pang'wanso ai ikilisigwe; YESU MUNAZARETI, MUTEMI NUA AYAHUDI; ");
INSERT INTO isn_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Idu a Ayahudi ai asomile ulogo nulanso kuiti kianza ni kanso nai wagigwe uYesu ai yatulaa pakupi ni kisali, Logo nulanso ai lukilisigwe ku Kiebrania, ku Kirumi nu ku Kiyunani ");
INSERT INTO isn_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Uugwa akulu a akuhani a Ayahudi akamutambuila uPilato, 'Leka kukilisa, 'Mutemi nua Ayahudi; ila nuanso ai uligitilye unene ni mutemi nua Ayahudi.” ");
INSERT INTO isn_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nung'wenso uPilato aka asukiilya, “Ni namakilisa namakilisa.” ");
INSERT INTO isn_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ze yakilaa ia asikali kumaja uYesu, ai ahoile i ang'wenda akwe nu kuagalania mu malundo anne, kila asikali ilundo ling'wi, ku uu nu mujulungu, Itungili u mujulungu uyo shanga ai uhilitilwe ila ai usukilwe wihi puma migulya. ");
INSERT INTO isn_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Uugwa akitambulya enso ku enso, “Kuleke kutamulanya, ila kukuile kula iti kihenge ukutula wang'wa nyenyu. “Ili ai lipumie iti u ukilisigwa uwu ukaminkiliigwe, uwo nai ukilisilye ai agalanile i ang'wenda ane. nu mujulungu nuane akaukuila kula.” ");
INSERT INTO isn_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","iAsikali ai itumile imakani aya. uNyinya nuang'wa Yesu, muluna nuang'wa nyinya, Mariamu musungu nuang'wa Kleopa nu Mariamu Magdalena - iasungu awa ai akoli imikile pakupi nikota nila mpaga nilang'wa Yesu. ");
INSERT INTO isn_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","uYesu nai wakamihenga unyinya nuakwe palung'wi nu mumanyisigwa uyo nai umuloilwe aze imikile pakupi, akamutambuila u nyinya, “Musungu, goza, ihenge u ng'wana nu ako suyu papa!” ");
INSERT INTO isn_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Uugwa akamutambuila u mumanyisigwa uyo, “Goza, suyu papa u ia ako.” “Pumiila i saa yiyo u mumanyisigwa uyo akamuhola kulongola kitalakwe. ");
INSERT INTO isn_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ze yakilaa ni lanso, Uu uYesu aze ulingile kina ihi akondya kuhilinkiila iti kukaminkiilya u ukilisigwa, akaligitya, “Nahung'waa nyota.” ");
INSERT INTO isn_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kiseme ai katulaa kizue siki ai kikoli ki ikilwe pang'wanso, ku lulo akaikila isifongo ni izuee i siki migulya a lukito nua hisopo, akamuikiilya mu mulomo nuakwe. ");
INSERT INTO isn_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Nung'wenso uYesu nai wakalulya nanso, akaligitya, “Yaulaa” Uugwa akatunia itwe ni lakwe, akaminkiilya inkolo akwe. ");
INSERT INTO isn_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ku nianso ai yatulaa matungo a unoneelya, ni kunsoko i miili shanga ai itakiwe kusiga migulya a makota a mpaga matungo a luhiku nula kusupya (ku nsoko u luhiku nula kusupya ai latulaa la kusanigwa), ayahudi ai amulompile uPilato kina migulu ao awo nai atulaa agigwe ibunangwe, ni kina i miili ao isimigwe. ");
INSERT INTO isn_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Papo i a asikali nai akapembya nu kubunanga i migulu a muntu nua ng'wandyo nuyu nua kabiili nai watulaa wagigwe palung'wi nu Yesu. ");
INSERT INTO isn_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nai amupikiile uYesu, ai amuhangile yakondaa kutula wakondyaa kusha, Ku lulo shanga ai abunangile i migulu akwe. ");
INSERT INTO isn_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ga ni iti, ung'wi nua asikali ai umuhomile uYesu mu lubalu ku ndilima, ni nkua akapuma mazi ni sakami. ");
INSERT INTO isn_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nu ng'wenso nai wihengile ili upumilye ukuiili, nu ukuiili nuakwe ingi i tai. Ng'wenso ulingile kina nukiligitilye ingi ka tai iti nu nyenye ga muhuiile. ");
INSERT INTO isn_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Makani aya ai atuile iti ikani ilo nai liligitigwe lihume kupikiila, “Kutili ga nu ung'wi nuakwe nu ukubunangwa.” ");
INSERT INTO isn_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Hangi ukilisigwa u uya wiligitya, “Akumugozeela nuanso nai amuhomile.” ");
INSERT INTO isn_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ze yakilaa imakani aya uYusufu nua ku Arimathaya, ku nsoko ai watulaa mumanyisigwa wang'wa Yesu, kuiti ku kinkunku ku kuitumba iAyahudi, ai umulompile uPilato kina wauhole u muili nuang'wa Yesu. Nu ng'wenso uPilato akamulekela. Ku lulo uYusufu akapembya nu kuuheja u muili nuang'wa Yesu. ");
INSERT INTO isn_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nu ng'wenso uNikodemu naiza apo ung'wandyo ai umutyatile uYesu u utiku nu ng'wenso akapembya, uNg'wenso ai uletile u uhalinkanigwa nua udi, upikiie ulito nua latili igana ling'wi. ");
INSERT INTO isn_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ku lulo akauhola u muili nuang'wa Yesu akautunga mu sanda ni nzelu palung'wi ni manyunkiilo ayo, anga nai izaa ntendo a Ayahudi itungo nila kuika. ");
INSERT INTO isn_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kianza naiza uYesu ai wagigwe ai ikoli nzega; mukati a nzega nanso ai kikoli kibiila kigeni naiza kutili anga muntu nuakaiye kuikwe mung'wanso. ");
INSERT INTO isn_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Uugwa, kunsoko ai yatulaa luhiku nula uzipiilya ku Ayahudi, nu ku uu i kibiila ai kikoli pakupi, uu akamuika uYesu mukati akwe. ");
INSERT INTO isn_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Dau ni nkulu luhiku nula ng'wandyo nula wiki, ze ikili kiti, uMariamu Magdalena akapembya mu kibiila; akihenga igwe nilanso lahegigwaa mu kibiila. ");
INSERT INTO isn_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ku lulo akamanka intambo kulongola kung'wa Simioni Petro nu ku nuanso u mumanyisigwa mu ngiiza naiza uYesu ai umuloilwe, uugwa akamutambuila, “amuholaa uMukulu mu kibiila, nusese shanga kulingile ku amulalikilye.” ");
INSERT INTO isn_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Uugwa uPetro nu uyo u mumanyisigwa mungiiza akapuma, kulongola mu kibiila. ");
INSERT INTO isn_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ihi ai amankile ntambo ku palung'wi; uyo u mumanyisigwa u muya akamanka ntambo kulia uPetro nu kupika mu ki biila wang'wandyo. ");
INSERT INTO isn_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Akimika ni uugwa kugozeela mu kibiila; akihenga isanda iyo ni nzelu ilae, kuiti shanga akingila mukati. ");
INSERT INTO isn_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Uugwa uSimioni Petro nu ng'wenso akapika akingila mukati a kibiila. Akihenga i sanda iyo ni nzelu ilae pang'wanso ");
INSERT INTO isn_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","nu mukako uwo nai ukoli kitwe wing'wene shanga ai ulae palung'wi ni sanda iyo ni nzelu ila ai watulaa ulae mpelo wing'wene duu ");
INSERT INTO isn_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Papo u mumanyisigwa uyo u muya akingila mukati a kibiila; akihenga nu kuhuiila. ");
INSERT INTO isn_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ku lulo kupikiila itungo ni lanso ai yatulaa akili kulinga u ukilisigwa kina ai isingigwe uYesu wiuke hangi mu ashi. ");
INSERT INTO isn_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Uugwa i a manyisigwa akalongola hangi kumatalao ");
INSERT INTO isn_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ga ni iti, uMariamu ai watulaa wimikile mu kibiila ukulila, nai wakatula ulongolekile kulila ai wimikile hangi akagoza mu kibiila. ");
INSERT INTO isn_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Akihenga amalaika abiili akete ikelu lyelu ikie ung'wi ku mitwe nu muya ku migulu kianza naiza uYesu ai watula ulae. ");
INSERT INTO isn_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ni enso akamutambuila, “Musungu, ku niki ukulila?” Nung'wenso aka atambuila, “Ingi ku nsoko amuholaa uMukulu nuane, nunene shanga ningile kuamuikile.” ");
INSERT INTO isn_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nai wakondya kuligitya nanso, ai upilukile nu kumihenga uYesu aze wimikile. Kuiti shanga ai umanyile anga ize nuanso ai Yesu. ");
INSERT INTO isn_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Nu ng'wenso uYesu akamutambuila, “ Ia, kuniki ukulila? ukumuduma nyenyu?” Nu ng'wenso kunu aze usigile kina ingi musunja nzega akamutambuila, “Mukulu, anga ize ingi wewe numuhoile, ntambuile kumuikile, nu nene kumuhola.” ");
INSERT INTO isn_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","uYesu akamutambuila, “Mariamu.” Nu ng'wenso akapiluka mukola nu kumutabuila ku kiaramu, “Raboni,” iti gwa ili ingi kuligitya, “Ng'walimu.” ");
INSERT INTO isn_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","uYesu akamuila, “Leka ki kilisiilya, kunsoko nkili kuluma kulongola kung'wa Tata; ila ulongole ku aluna ane uatambuile kina nikaluma ku longola kung'wa Tata nuane naiza ingi Tata nuanyu ga, Itunda nu ane hangi Itunda nu anyu. ");
INSERT INTO isn_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","uMariamu Magdalena akapembya nu kuatambuila i amanyisigwa, “Namihengaa uMukulu.” ni kina umutambuie imakani aya. ");
INSERT INTO isn_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Hangi nai ikatula mpindi, luhiku nulanso, luhiku nulang'wandyo nula wiki, ni milango ize ituile ilugaiwe kianza i amanyisigwa nai akoli aze ai tumbile i Ayahudi, uYesu ai upembilye nu kimika pa kate ao nu kuatambuila, “Ulyuuku utule kitalanyu.” ");
INSERT INTO isn_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Nai wakondya kuligitya aya aka alagiila i mikono akwe nu lubalu nu lakwe. Ni enso i amanyisigwa nai akamihenga uMukulu ai iloile. ");
INSERT INTO isn_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Uugwa uYesu aka atambuila hangi, “Ulyuuku utule nu nyenye, anga iti uTata nai undagiiye unene, ku u uu nu nene kumulagiilya unyenye.” ");
INSERT INTO isn_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","uYesu nai akakondya kuligitya nanso, Aka aikiilya ingulu aka atambuila nianso, Singiilyi u Ng'wau Ng'welu. ");
INSERT INTO isn_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ihi ni mukualekela i milandu, alekelwa; ni awo ni mukuatungilya akutungiligwa. ");
INSERT INTO isn_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","uThomaso, ung'wi nua awo ikumi na abiili, nai witangilwe Didimas, shanga ai ukoli ni amanyisigwa auya uYesu nai uzile. ");
INSERT INTO isn_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Awo i amanyisigwa i auya akamutambuila panyambele. “Kamihengaa uMukulu.” Nu ng'wenso aka atambuila, “Anga nihite kihenga i mabasa a misumali mu mikono akwe, nu kuikila ing'anza niane mu mabasa nanso, ni hangi kuikila u mukono nuane mu lubalu nulakwe shanga kuhuiila.” ");
INSERT INTO isn_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ze yakilaa i mahiku mu nana amanyisigwa ai akoli ku shumba hangi, nu ng'wenso uThomaso ai ukoli palung'wi nienso, Matungo i milango ai atulaa ilugaiwe uYesu akimika pakati ao, nu kuligitya, “Ulyuuku nu utule nu nyenye.” ");
INSERT INTO isn_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Uugwa aka mutambuila uThomaso, leta u mukono nuako hangi uuikile mu lubalu nu lane; ang'wi uleke kutula ni shanga uhuiie ila nu uhuiie.” ");
INSERT INTO isn_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Nu ng'wenso uThomaso akasukiilya nu kumutambuila, “Mukulu nu ane hangi Itunda nu ane.” ");
INSERT INTO isn_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","uYesu akamuila, Kunsoko wanihengaa, wahuiila. Akendepilwe awo ni ihuiila, shanga ku kihengaa.” ");
INSERT INTO isn_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Uugwa uYesu ai witumile i ilingasiilyo idu ntongeela a amanyisigwa, naiza ikili kukilisigwa mu mbugulu iyi ");
INSERT INTO isn_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ila izi ikilisigwe iti kina muhume ku huiila kina uYesu yuyo Kristo, ng'wana nuang'wa Itunda, ni kina ni mikahuiila mutule nu upanga mu lina nilakwe. ");
INSERT INTO isn_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ze yakilaa imakani ayo uYesu akiika kihenga hangi ku amanyisigwa mu luzi nula Tiberia; iti uu nai wigeelekile mukola, ");
INSERT INTO isn_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","uSimioni Petro ai ukoli palung'wi nu Thomaso nui tangwaa Disimas, Nathanaeli nua ku Galilaya, ana ang'wa Zebedayo ni amanyisigwa angiiza abiili ni ang'wa Yesu. ");
INSERT INTO isn_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","uSimioni Petro aka atambuila, “Unene nalongola kuvua nsamaki.” Ni enso akamutambuila, Ga nusese, kunankile nu ewe.” Akalongola akanankila mu mashua, kuiti u utiku nuanso wihi shanga ikalija kihi. ");
INSERT INTO isn_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ni kidau dau nai ukela, uYesu ai wimikile mu nshemba, ni enso i amanyisigwa shanga ai amumanyile kina ai watulaa Yesu. ");
INSERT INTO isn_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Uugwa uYesu aka atambuila, 'Ahumba, mukete kihi nikakulya?” ni enso akamusukiilya, “Ishi.” ");
INSERT INTO isn_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Aka atambuila, Simyi inyavu nkika a kigoha a mashua, nu nyenye mukulija i ngele.” Ku lulo akasimya i nyavu ao shanga ikahuma kuluta hangi kunsoko a udu nua nsamaki. ");
INSERT INTO isn_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Uugwa uyo u mumanyisigwa naiza uYesu umuloilwe akamutambuila uPetro, “Ingi Mukulu.” Nu ng'wenso uSimioni Petro nai wakija kina ingi Mukulu, akitunga u ng'wenda nuakwe (ndogoelyo shanga ai watulaa witungile iziza), uugwa akigumila mu luzi. ");
INSERT INTO isn_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Awo i amanyisigwa ni angiiza akapembya mu mashua (kuiti shanga ai ukoli kuli ni nshemba, ipikiie migulu igana ling'wi pumiila ku nshemba) ni enso ai atulaa akuluta i nyavu nai yatulaa yizue i nsamaki. ");
INSERT INTO isn_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nai akapika ku nshemba, akihenga moto nua makala pang'wanso migulya akwe ai ikoli nsamaki nu mukate. ");
INSERT INTO isn_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","uYesu aka atambuila, “Leti ing'wi nia nsamaki naza muvuile itungili iti.” ");
INSERT INTO isn_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Uugwa uSimioni Petro akanankila nu kukweha inyavu iyo nai atulaa izue insamaki ni nkulu, ngele a nsamaki 153; ga ni iti anga itule aza idu, inyavu iyo shanga ai itamukile. ");
INSERT INTO isn_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","uYesu aka atambuila, “Pembyi mulije ikitikolo.” Kutili ga nung'wi nua amanyisigwa nai ugemile kumukolya, “Uewe wi nyenyu?” Ai alingile kina ai watulaa ingi Mukulu. ");
INSERT INTO isn_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","uYesu akapembya, akahola u mukate uwo, uugwa akainkiilya, akituma uu nu ku nsamaki izo. ");
INSERT INTO isn_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Iyi ai nkua aka taatu kung'wa Yesu kigeeleka kihenga ku amanyisigwa akwe ze yakilaa kiuka kupuma ku ashi. ");
INSERT INTO isn_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ze yakilaa kutula atikolaa, uYesu aka mutambuila uSimioni Petro, “Simioni ngwana wang'wa Yohana itii, undoilwe u nene kukila awa?” uPetro akasukiilya, “Ee, Mukulu, Uewe ulingile kina unene nukuloilwe.” uYesu akamutambuila, “Lisa iana ankolo ane,” ");
INSERT INTO isn_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Aka mutambuila nkua aka biili, “Simioni ng'wana wang'wa Yona, itii, undoilwe?” uPetro aka mutambuila, Ee, Mukulu, uewe ulingile kina nukuloilwe, uYesu aka mutambuila, “Dima inkolo niane.” ");
INSERT INTO isn_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Aka mutambuila hangi nkua a ka taatu, “Simioni, Ng'wana wang'wa Yohana, itii undoilwe?” Nu ng'wenso uPetro ai usigile ikulu iti nai umutambuiie nkua aka taatu, “Itii, U ewe undoilwe?” Nu ng'wenso aka mutambuila, Mukulu uligile yihi, ulingile kina nukuloilwe,” uYesu aka mutambuila, Lisa inkolo niane. ");
INSERT INTO isn_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Huiila, huiila, ku utambuila, nai ukili wimuhumba ai wiziie kutugala i ang'wenda mukola nu kulongola kihi ku loilwe; kuiti nuikatula wi munyampala, ukugoola imikono ako, nu muya uku utugalya i ang'wenda nu ku utwala ku shanga uloilwe kulongola.” ");
INSERT INTO isn_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","uYesu ai uligitilye aya iti kulagiila ingi mpyani kii a nsha ang'wa Petro niize wikamukulya Itunda. Ze yakilaa kutula waligityaa aya, akamutambuila uPetro, “Ntyate.” ");
INSERT INTO isn_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","uPetro akapiluka nu kumihenga u mu manyisigwa uyo naiza uYesu umuloilwe aka atyata- Uyu yuyo nai watulaa wipantamiiye mu kikua kang'wa Yesu itungo nila ndyaa nia mpindi nu kumukolya uYesu. “Mukulu, ingi nyenyu nuika kugumaniilya?” ");
INSERT INTO isn_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","uPetro ai umihengile ni hangi akamukolya uYesu, “Mukulu, Umuntu uyu wikituma ntuni?” ");
INSERT INTO isn_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","uYesu akamusukiilya, “Anga ndowe wasage kupikiila ni nikapembya, ni lanso likutuile ntuni?” “Ntyate” ");
INSERT INTO isn_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ku lulo ikani ili likenela mukati a awo i aluna, kina u mumanyisigwa nuanso shanga wikasha. Kuiti uYesu shanga ai umutambuie uPetro kina, u mmanyisigwa uyo shanga wikasha, “Anga ndowe ung'wenso wasage kupikiila ni nikapembya ikutuile ntuni?” ");
INSERT INTO isn_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Uyu yuyo mumanyisigwa nuipumyaa u ukuili nua makani aya, hangi yuyo nai ukilisilye imakani aya, hangi kulingile kina u ukuiili nuakwe ingi tai. ");
INSERT INTO isn_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Akoli makani idu naiza uYesu ai witumile. Anga kila ling'wi ai likilisigwe, nsigiie kina u unkumbigulu shanga ai uzeekondela kuieka imbugulu naize ikukiliswa. ");
INSERT INTO isn_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","iMbugulu a kali ai nimikilisilye, Theofilo, nizeligitya ihi uYesu nai wandilye kituma nu kumanyisa, ");
INSERT INTO isn_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kupikiila luhiku naiza uNg'wenso ai usingiigwe migulya. Ili ai lituile ze yakila kupumya ilagiilyo kukiila Ng'wau Ng'welu mu itumi nai watula uaholanilye. ");
INSERT INTO isn_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ze yakilaa u lwago nu lakwe, uNg'wenso ai wigeelekile kitalao aze mupanga ga nu ukaminkiilyi widu uku kuiila. Ku mahiku makumi anne ai wigeelekile kitalao, nu kitambuila kutula utemi nuang'wa Itunda. ");
INSERT INTO isn_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nai watula ukutankana palung'wi nienso, ai ualagiiye aleke kuhega mu Yerusalemu, kuiti alindiile ku nsoko a wigombya nuang'wa Tata, naiza, ai uligitilye, “Ai migule kupuma kitalane ");
INSERT INTO isn_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","kina uYohana ai wogilye nangalu ku mazi, kuiti mikoja ku Ng'wau Ng'welu mu mahiku aya ni masheenyu.” ");
INSERT INTO isn_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Hangi nai atula atankana palung'wi ai amukoilye, “Mukulu, iti ili lili itungo nuika asukiilya ia Israeli u utemi?” ");
INSERT INTO isn_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","uNg'wenso aka atambuila, “Shanga ibahu kitalanyu kulinga itungo ang'wi matungo naiza uTata usigiie ku ukulu nuakwe mukola.” ");
INSERT INTO isn_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kuiti mukusingiilya ingulu, itungo uNg'wau Ng'welu nuikapembya migulya nilanyu, nu nyenye mikatula mia kuiili ane pihi mu Yerusalemu nu uYahudi wihi ni Samaria kupikiila impelo ihi.” ");
INSERT INTO isn_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","uMukulu uYesu nai wakondya kuligitya aya, aze atuile agozee migulya, uNg'wenso ai unyasuwe migulya, ni ilunde likamukunikila aleke kumihenga ku miho ao. ");
INSERT INTO isn_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Matungo nai agozee ki lunde ku ukendegeeli aze ulongoe, kupumpugiilya, antu a biili ai imekile pakati ao atugae ang'wenda elu. ");
INSERT INTO isn_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Akaligitya, “Unyenye antu nia ku Galilaya, ku niki mi mikile apa mugozee kilunde?” Uyu uYesu nu ulumile migulya ki lunde ukusuka ku mpyani yiyo yiiyo anga naza mumihengile ulongoe ki lunde. ");
INSERT INTO isn_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Uugwa akasuka ku Yerusalemu kupuma mu lugulu nula mizeituni, naza lukoli pakupi ni Yerusalemu, lugendo nula luhiku nula kusupya. ");
INSERT INTO isn_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nai akapika akalongola mu ghorofa naiiza ikiie. Ni enso uPetro, Yohana, Yakobo, Andrea, Filipo, Thomaso, Batholomayo, Mathayo, Yakobo Ng'wana wang'wa Alfayo, Simioni Zelote nu Yuda Ng'wana wang'wa Yakobo. ");
INSERT INTO isn_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ihi ai akaminkanile anga muntu ung'wi, ku ukamatiku ai akoli alongolekile mu malompi. Palung'wi ni enso ai akoli asungu, uMariamu nyinya nuang'wa Yesu, ni a heu akwe. ");
INSERT INTO isn_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mu mahiku nanso uPetro ai wimikile pakati a anya ndugu, anga antu 120, akaligitya, ");
INSERT INTO isn_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Anya ndugu, ai yatulaa kusinja kina u ukilisigwa utimiligwe, naza ikali uNg'wau Ng'welu ai uligitilye ki Ilangu nilang'wa Daudi kutulika nu Yuda, naiza ai uaganuie awo nai amuambile uYesu. ");
INSERT INTO isn_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ku nsoko nuanso ai watulaa ung'wi itu hangi ai usingiiye ilundo nilakwe nila usukiiligwa mu uwu u uaiilya” ");
INSERT INTO isn_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Itungili u muntu uyu ai uguile i kipango ku iko nai ukisingiiye ku ubi nuakwe ni pang'wanso ai ugwie aze utongeeye itwe, u muili ukatamuka ni mala akwe ihi akatula ng'walye akahunuka. ");
INSERT INTO isn_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ihi nai ikiie ku Yerusalemu ai igulye kutula ili, uugwa i kipango nikanso kikitangwa ku ntambu ao, “Akeldama” nianso ingi “mugunda nua sakami.”) ");
INSERT INTO isn_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Mu mbugulu a malumbiilyo ikilisigwe, 'Lindiila ikianza kakwe kitule ikumuulu hangi ileke kugombigwa muntu ga nung'wi kikie pang'wanso,' nu 'Lekela muntu mu ngiiza wahole ilyoma nilakwe nila utongeeli,' ");
INSERT INTO isn_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Nilanso ingi ingulu, ku lulo, ung'wi nua itunja naza ukaminkanile nu sese matungo a Mukulu uYesu nai upumile nu kingila mukati itu, ");
INSERT INTO isn_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","kandiilya mu wogogwa wang'wa Yohana ku pikiila u luhiku ulo nai upuilwe migulya, kusinja watule mu kuiili nua ukunukulwa palung'wi nu sese. ");
INSERT INTO isn_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Akaika ntongeela ao agoha abiili, Yusufu nuitangwaa Barnaba, nai iza witangwaa ga ni Yusto nu Mathia. ");
INSERT INTO isn_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","iEnso ai alompile azeligitya, “Uewe, Mukulu, nu lingile i nkolo nia antu ihi, uu ika ng'walyi nu uli kati a awa ni abiili naiza umuholanilye ");
INSERT INTO isn_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","kuhola i lyoma mu uaiilya nua itumi, niiza uYuda ai witumile u ubii nu kulongola nkika niakwe.” ");
INSERT INTO isn_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Akakua kula kunsoko ao, ni kula ikamugwila uMathia naiza ai uaigwe palung'wi ni awo i itumi ikumi na ung'wi. ");
INSERT INTO isn_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nai ikapika luhiku nula Pentekoste, ihi ai akoli palung'wi kipango king'wi. ");
INSERT INTO isn_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kupumpugiilya ukapumila mulilo kupuma kilunde anga ng'wega utaki. ukizulya ito lihi nai amoli ikiie. ");
INSERT INTO isn_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Papo ikapumila nimi, anga nia moto, igalanukile, ikatula migulya ao kila ung'wi ao. ");
INSERT INTO isn_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ni enso ihi akizuligwa nu Ng'wau Ng'welu nu kandya kuligitya ku ntambu ingiiza, anga uu uNg'wau Ng'welu nai ua kendepile kuligitya. ");
INSERT INTO isn_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Itungili ai akoli Ayahudi nai atulaa ikiie ku Yerusalemu, akulya Itunda, kupuma kila ingu pihi ilunde. ");
INSERT INTO isn_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","iMililo iyi nai igigwe, idale nila antu likapemya palung'wi hangi ikaze akete u witumbi ku nsoko kila u muntu ai uigulye akuligitya ku ntambu akwe mukola. ");
INSERT INTO isn_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Akalangula nu ku kuilwa, enso ai aligitilye, “Tai, awa ihi nia kuligitya shanga Agalilaya? ");
INSERT INTO isn_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ku niki usese ku uija, kila u ng'wi ku ntambu ni ku tugeeigwe ni nyenso? ");
INSERT INTO isn_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Aparthia ni Amedi ni Aelamu, ni awo ni ikiie ku Mesopotamia, Uyahudi, ni Kapadokia, nu mu Ponto ni Asia, ");
INSERT INTO isn_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","mu Frigia, Pamfilia, mu Misri, ni nkika a Libya ga ni Kirene, ni aziila kupuma ku Rumi, ");
INSERT INTO isn_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ayahudi ni alokole, Akrete ni Arabu, ku uija akuligitya mu ntambu ni yitu kutula mulimo nua uhumi nuang'wa Itunda.” ");
INSERT INTO isn_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ihi ai atulaa alangula nu ku limangiiligwa; ai itambuuie enso ku enso, “ Iki kikete ndogoelyo kii?” ");
INSERT INTO isn_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kuiti i auya ai akunile azeligitya, “Awa izuigwe ku magai mageni.” ");
INSERT INTO isn_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kuiti uPetro akimika palung'wi ni awo ni ikumi na ung'wi, akitunta, aka atambuila, “Antu a Yudea ni ihi ni ikiie apa mu Yerusalemu, ili likumukile kitalanyu, tegeelyi ku ukendegeeli i makani ane. ");
INSERT INTO isn_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Antu awa shanga agaile anga ni musigile, ku nsoko isaa izi ingi kidaudau saa tatu, ");
INSERT INTO isn_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kuiti ili ai latulaa latambulwaa kukiila munyakidagu uYoeli. ");
INSERT INTO isn_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Yikatula mu mahiku a mpelo; Itunda uligitilye, nikahunula u Ng'wau Ng'welu nu ane ku antu uhi, Ana anyu ni ananso anyu akupumya unyakidagu, ahumba anyu akihenga muloto, ni anyampala anyu akulota ndoti. ");
INSERT INTO isn_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Uu uu migulya a anyamilimo ane ni anyamilimo ane nia kisungu mu mahiku nanso, nikahunula u Ng'wau Ng'welu nuane, nienso akulota. ");
INSERT INTO isn_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nikalagiila ukuilwa migulya milunde ni kilingasiilyo pihi mihi, sakami, moto, nu utunki nua lyuki. ");
INSERT INTO isn_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ni lyoa likukailwa kutula kiti nu ng'weli kutula sakami, ze ikili kupembya i siku kuu hangi naukuilwa nua Mukulu. ");
INSERT INTO isn_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","yikatula nia kina kila ung'wi niiza wilitanga i lina nila Mukulu ukugunika,' ");
INSERT INTO isn_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Antu a Israeli, tegeelyi imakani aya; uYesu nua ku Nazareti, ng'wana adamu nai ukaminkiigwe nu Itunda kitalanyu ku ntendo nia uhumi nu ukuilwa, ni ilingasiilyo naza Itunda kukiila ng'wenso pa kati anyu, anga unyenye akoli ni mulingile. ");
INSERT INTO isn_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kunsoko a masigo nai asigiiwe puma ng'wandyo, nu uhugu nuang'wa Itunda, ai upumigwe, nu nyenye, ku mikono a antu niabipya, ai mimagilye nu kumubulaga, ");
INSERT INTO isn_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","naiza Itunda ai umunyansue, akauheja u uwai nua nsha kitalakwe, ku nsoko shanga ai ihumikile kitalakwe kuhumiiligwa nu wenso ");
INSERT INTO isn_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Iti gwa uDaudi ukuligitya kutula u ng'wenso, 'Ai numihengile nu Mukulu mahiku ihi ntogeela a usu nuane, ung'wenso ukoli mukono nuane nua kigoha iti gwa shanga kuhumbeeligwa. ");
INSERT INTO isn_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ku lulo i nkolo nane ai atulaa nu ulowa nu lulimi nulane lukuloeeligwa. Ga nu muili nuane ukikie mu ukamatiku. ");
INSERT INTO isn_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Shanga ukuleka u umi nuane ulongole ku ulungu, ang'wi shanga ukulekela u Ng'welu nuako kihenga i kiolu. ");
INSERT INTO isn_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Uewe uikile kihenga kitalane i nzila a upanga; uku ntendeela nizule ulowa ntongeela a usu nuako,' ");
INSERT INTO isn_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Anyandugu, nihumile kuligitya kitalanyu ku ukamatiku kutula Tata nuitu uDaudi; nuanso ai ukule nu kuikwa, ni kibiila kakwe kikoli palung'wi nu sese ga ni iti lelo. ");
INSERT INTO isn_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Iti gwa, aiwatuile munyakidagu hangi ai ulingile kina Itunda ai walapaa ku ilapo ni lakwe, kina ukuika ung'wi mu utuugwa nuakwe mi ituntu nila ukulu. ");
INSERT INTO isn_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ai wakayaa kihenga, hangi akaligitya kutula wiukigwa nuang'wa Kristo, 'ang'wi aiwatulaa shanga ulekilwe ku ulungu, ang'wi muili nuakwe shanga ai uoile.' ");
INSERT INTO isn_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Uyu uYesu - Itunda ai umiukilye, naiza usese kihi ingi akuiili. ");
INSERT INTO isn_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ku lulo, anga watule unyansuwe mu mukono nua kigoha nuang'wa Itunda, hangi angaitule wasingiilya ilago nila Ng'wau Ng'welu kupuma kung'wa Tata, nuanso ai udubunkilye ilago ili, naiza unyenye mukihenga nu kija. ");
INSERT INTO isn_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kuiti uDaudi shanga ai ulumile kulongola ki lunde, kuiti ukuligitya, 'MUKULU ai uligitilye ku Mukulu nuane, ");
INSERT INTO isn_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","“ikie mukono nuane nua kigoha, kupikiila ni nika azipya i alugu ako kutula ituntu kusoko a mugulu ako. ");
INSERT INTO isn_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ku lulo ito lihi nila Israeli ni lilinge ku kulu kuulu kina Itunda umuzipilye Nuanso kutula Mukulu hangi Kristo, uyu uYesu naiza mu magilye.” ");
INSERT INTO isn_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Itungili nai akija nianso, akasonswa munkolo niao, akamuila uPetro ni itumi i auya, Aluna, kitume ntuni?” ");
INSERT INTO isn_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Nu Petro aka atambuila, “Ili itunu hangi Mogigwe, kila ung'wi nuanyu, mu lina nilang'wa Yesu Kristo ku nsoko a ulekelwa nua milandu anyu, hangi mukusingiilya ikipegwa nika Ng'wau Ng'welu. ");
INSERT INTO isn_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kuiti kitalanyu ingi wigombya, nu ku ana anyu nu ku awo ihi niakoli kuli, antu idu ku ngele Mukulu Itunda nuitu nuikaitanga. ");
INSERT INTO isn_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ku makani idu ai ukuiie nu kua sinja; ai uligitilye, “Iguni mupume mu ulelwa uwu nu ubibi.” ");
INSERT INTO isn_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Uugwa akamasingiiltya i makani akwe hangi akogigwa, papo akongeeleka mu luhiku nulanso anga umi magana a nzogu ataatu. ");
INSERT INTO isn_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Akalongoleka mu umanyisigwa nua itumi numu muhangu, mu ku uega u mukate nu mu malompi ");
INSERT INTO isn_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Woa ukapembya mu kila umi, nu ukuilwa widu ni ilingasiilyo yikitung'wa kukiila itumi. ");
INSERT INTO isn_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ihi nai ahuiie ai akoli palung'wi nu kutula ni intu niao ku palung'wi, ");
INSERT INTO isn_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","hangi ai aguiye i intu nu usali nuao nu komolania ku ihi kimpyana nu u ula nua kila ung'wi. ");
INSERT INTO isn_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Iti gwa mahiku ze yakilaa mahiku ai alongolekile azeatulaa ni isigo ling'wi mi itekeelo, hangi ai auegile u mukate mu ito, hangi ai ihanguie indya ku ulowa nu uliuki nua nkolo. ");
INSERT INTO isn_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ai amulumbiiye Itunda hangi aze akete u ugombigwa ni antu ihi. uMukulu ai uongeeye mahiku ku mahiku naza atulaa akugunwa. ");
INSERT INTO isn_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Itungili uPetro nu Yohana ai atulaa atungile mi Itekeelo matungo a malompi, saa kenda. ");
INSERT INTO isn_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Muntu nua kituunga, kitele puma kutugwa, ai watulaa ukukenkwa kila mahiku hangi ai watulaa ukulalikigwa mu mulango nui itekeelo nuitangwaa uziza, iti ahume kulompa isongelyo kupuma ku antu nai atulaa atungile mi itekeelo. ");
INSERT INTO isn_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nai wakaihenga ia Petro nu Yohana akuhumbeela kingila mi Itekeelo, ai ulompile isongelyo. ");
INSERT INTO isn_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","uPetro, akamugondoola, palung'wi nu Yohana, ai uligitilye, “kugoze usese.” ");
INSERT INTO isn_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","uKitele aka agoza, aze usumbiiye kusingiilya kintu kituunga kupuma kitalao. ");
INSERT INTO isn_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kuiti uPetro akaligitya, “i mpia ni zahabu unene nimugila, kuiti iko ninkete kukipumya kitalako. Mu lina nilang'wa Yesu Kristo nua ku Nazareti, genda.” ");
INSERT INTO isn_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","uPetro akamuhola ku mukono nuakwe nua kigoha, hangi akamunyansula migulya: itungo ling'wi i migulu akwe ni inungo nia makupa akwe ikalija ingulu. ");
INSERT INTO isn_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Azeputa migulya, umuntu ukitele ai wimikile nu kandya kugenda; akingila mi itekeelo palung'wi nu Petro nu Yohana, azegenda, azeputangila, nu kumukulya Itunda ");
INSERT INTO isn_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Antu ihi ai amihengile ukugenda nu kumukulya Itunda. ");
INSERT INTO isn_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Akalinga kina ai watulaa yuyo muntu naiza watuilee wikiie wazelompa isongelyo mu mulango nu uziza nui itekeelo; ai izuiwe nu ukuilwa nu kukuilwa ku nsoko a iko nazakipumie kitalakwe. ");
INSERT INTO isn_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Kinya iti nai watulaa ua ambiie ia Petro nu Yohana, antu ihi ku palung'wi akamankiila mi itando ni litangwaa nilang'wa Sulemani, aze akuiwe lukulu. ");
INSERT INTO isn_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","uPetro nai wakihenga ili, nuanso aka asukiilya i antu, “Unye antu a Israeli, ku niki muku kuilwa? ku niki mukumatunja i miho anyu kitaitu, anga kina kamuzipyaa uyu wagende ku ngulu yitu akola ang'wi malompi itu?” ");
INSERT INTO isn_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Itunda nuang'wa Ibrahimu, hangi wang'wa Isaka, hangi wang'wa Yakobo, Itunda nua aTata itu, umukuiye u munyamilimo nuakwe uYesu. Uyu yuyo naiza unyenye ai muminkiiye nu kumuhita ntongeela a usu wang'wa Pilato, ga ni iti nuanso ai watulaa walamula kumuleka ilyuuku. ");
INSERT INTO isn_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ai mumuhitile uNg'welu hangi Munya Tai ane, ni badala akwe mikalowa u mubulagi walekwe ilyuuku. ");
INSERT INTO isn_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Unyenye ai mamubulaga u utemi nua upanga, naiza Itunda ai umiukilye kupuma mu ashi - u sese kiakuiili nia ili. ");
INSERT INTO isn_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Itungili, ku uhuiili mu lina nilakwe, u muntu uyu naiza mukumihenga nu kulinga, ai witumilwe kutula ni ingulu, uhuiili niiza kukiila kung'wa Yesu uminkiiye nuanso upanga nu ukondaniie, ntogeela anyu unyenye mihi. ");
INSERT INTO isn_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Itungili, anyandugu, mulingile kina ai mitumile mu upungu, uu nai itumile ga ni atongeeli anyu. ");
INSERT INTO isn_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kuiti makani niiza Itunda ai wakaya kumutambuila ku malangu a anyakidagu ihi, kina uKristo uyu ukagisha, itungili wamakondaniilya. ");
INSERT INTO isn_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ku lulo, ili itunu hangi mupiluke, iti kina i milandu anyu ihume kuhegigwa lukulu, isigo apembye i matungo na kulumiila kupuminkana nu umoli nua Mukulu; ");
INSERT INTO isn_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ni kina wahume kumulagiilya u Kristo naiza wasaguwe kunsoko anyu, uYesu. ");
INSERT INTO isn_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","uNg'wenso yuyo niiza kusinja i ilunde limusingiilye kupikiila itungo nila kusukiiligwa i intu yihi, naiza Itunda ai uligitilye ikali ku malangu a anyakidagu ni elu. ");
INSERT INTO isn_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kulu kuulu uMusa ai uligitilye, 'uMukulu Itunda ukunyansula munyakidagu anga nene kupuma mu aluna anyu. Mukumutegeelya kila ikintu naiza ukumutambuila unyenye. ");
INSERT INTO isn_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ikupumila kina kila muntu niiza shanga witegeelya ku munyakidagu nuanso ukulimiligwa lukulu wapume mu antu.' ");
INSERT INTO isn_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Iti gwa, ni anyakidagu ihi pumiila uSamweli ni awo nai atyatile ze yakilaa u ng'wenso, ai atambue nu kutanantya i mahiku aya. ");
INSERT INTO isn_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Unyenye ingi ana a anyakidagu hangi i lago naiza Itunda ai ulitumile palung'wi ni Isekulu, anga nai uligitilye kung'wa Ibrahimu, 'mu mbeu niako i ndugu yihi nia mihi ikukendepwa,' ");
INSERT INTO isn_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ze yakilaa Itunda kumunyansula u munyamilimo nuakwe, ai umulagiiye kitalanyu hanza, iti amukendepe unyenye kupiluka kupuma mu ubii nuanyu.” ");
INSERT INTO isn_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Matungo uPetro nu Yohana nai atula akuligitya ni antu, akuhani ni asunja ni i tekeelo ni asadukayo ai a atyatile. ");
INSERT INTO isn_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ai atulaa atakisha nangaluu ku nsoko uPetro nu Yohana ai atulaa akuamanyisa i antu kutula uYesu nu kutanantya migulya a kiukigwa kung'waakwe kupuma ku ashi. ");
INSERT INTO isn_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Aka a amba nu kuaika mu kadulumu kupikiila kidaudau nai kityatile, ku nsoko ai yakondaa kutula mpindi. ");
INSERT INTO isn_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Kuiti antu idu nai atulaa ijaa u lukani ai ahuiie; ni ngele a agoha nai atulaa ahuiie ai isigiiwe kutula magana a nzogu a taano. ");
INSERT INTO isn_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ga nai yapika kidaudau luhiku nai lutyatile, kina akulu ao, anyampala ni amanyi, ku palung'wi ai ilundiie ku Yerusalemu. ");
INSERT INTO isn_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","uAnasi kuhani nu mukulu ai umoli, nu Kayafa, nu Yohana, nu Iskanda, ni ihi nai atulaa aluna ang'wa kuhani nu mukulu. ");
INSERT INTO isn_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Nai akatula a aika uPetro nu Yohana pakati ao, ai a akoiye, “Ku uhumi kii, ang'wi ku lina kii mukituma ili?” ");
INSERT INTO isn_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Uugwa, uPetro, aze wizue u Ng'wau Ng'welu, aka atambuila, “Unyenye akulu a antu, ni anyampala, ");
INSERT INTO isn_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","anga ize usese u luhiku nula lelo ku ukoligwa kutula ntendo ni nkende naza litumilwe ku muntu uyu nu mulwae - ku kinya uli u muntu uyu utendilwe mupanga? ");
INSERT INTO isn_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ebu ni likumuke ili kitalantu nu ku antu ihi mu Israeli, kina ku lina ni lang'wa Yesu Kristo nua Nazareti, naiza ai mumagilye, naiza Itunda ai umi ukilye kupuma ku ashi, ingi ku nzila akwe kina u muntu uyu ukimika apa ntongeela anyu aze ukete upanga. ");
INSERT INTO isn_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","uYesu Kristo ingi igwe naiza u nyenye azengi ai mulimeile, kuiti naiza laikilwe kutula igwe ikulu nila kumpelo. ");
INSERT INTO isn_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kutili u ugunwa ku muntu mungiza nuatula wihi. Kundogoelyo kutili ilina ingiiza pihi i lunde nai inkiigwe i antu, naiza ku nilanso ku humile kugunwa.” ");
INSERT INTO isn_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Itungili nai akihenga u ugimya nuang'wa Petro nu Yohana akalinga kina ai atulaa ingi antu a uu niagila u ulingi, ai a akuiwe, akalinga kina uPetro nu Yohana ai atulaa palung'wi nu Yesu. ");
INSERT INTO isn_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ku nsoko ai amihengaa u muntu uyo nai uponigwe wimikile palung'wi nienso, akatula agila ni kakutambula kutula iki. ");
INSERT INTO isn_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kuiti nai atula akondyaa kualagiilya i itumi kuhega ntongeela ianza. ai itambuiie enso ku enso. ");
INSERT INTO isn_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ai aligitilye, ku uatenda uli i antu awa? Ingi tai kina ukuilwa nuitumikile ku kiila enso wakumukaa ni kila ung'wi nui kiee mu Yerusalemu; shanga kuhumile kulihita nilanso. ");
INSERT INTO isn_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kuiti, iti kina ikani ili lileke kenela mukati a antu, ebu kuakanie aleke kuligitya hangi ku untu ihi ku lina ili. ");
INSERT INTO isn_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ai aitangile uPetro nu Yohana mu kati aka alagiilya nangaluu aleke kuligitya ang'wi kumanyisa ku lina nilang'wa Yesu. ");
INSERT INTO isn_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Kuiti uPetro nu Yohana ai asukiiye nu kua atambuila, “Anga ize inonee mi miho ang'wa Itunda kumija unyenye kukila Itunda, lamuli akola. ");
INSERT INTO isn_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ndogoelyo usese shanga kuhumile kuleka kuligitya imakani naiza kumaine nu kumija.” ");
INSERT INTO isn_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ze yakilaa kuakania nangaluu uPetro nu Yohana, ai a alekile alongole. Shanga ai ahumile kulija i nsoko ihi na kua aalya, ku nsoko antu ihi ai atulaa akumukulya Itunda ku iko nai katulaa katulikaa. ");
INSERT INTO isn_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","uMuntu nai watulaa wasingiilya u ukuilwa nua uguniki ai upikiie ilika la myaka makumi anee ikilo. ");
INSERT INTO isn_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ze yakilaa kualekela ilyuuku, uPetro nu Yohana akapembya ku antu ao nu kuaganuila ihi naiza i akuhani akulu ni anyampala ai atulaa a atambuie. ");
INSERT INTO isn_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nai akija, ai ituntile ku palung'wi kung'wa Itunda nu kuligitya, “Mukulu, uewe nai u umbile ilunde ni ihi nu luzi ni kila ikintu mukati akwe, ");
INSERT INTO isn_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","u ewe naiza, ku Ng'wau Ng'welu, ku ilangu ni lang'wa tata itu uDaudi, munyamulimo nuako, ai uligitilye, “Ku niki i antu a ingu itumile u minyomo, ni antu amasigiila i makani nishanga anonee? ");
INSERT INTO isn_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","iAtemi ihi ikitile ku palung'wi, ni ahumi ilundiie ku palung'wi ku Mukulu nu ku musagulwa nuakwe.” ");
INSERT INTO isn_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Igi kulu kuulu, ihi uHerode nu Pontio Pilato, palung'wi ni antu a ingu ni antu a Israeli, ai ilundiie ku palung'wi mu kisali iki ku munyamulimo nuako nu ng'welu uYesu, naiza ai umupuguhie i makuta. ");
INSERT INTO isn_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ai ilundiie ku palung'wi kituma ihi niiza u mukono nuako nu ulowa nuako ai umalagiiye puma u ng'wandyo ze ikili kupumila. ");
INSERT INTO isn_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Itungili, Mukulu, gozeela u ukangi nu ao, hangi uakendepe i anyamulimo niako kululigitya u lukani nu lako ku ugimya wihi. ");
INSERT INTO isn_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Iti kina nu kugoola u mukono nuako kuguna, i ilingasiilyo nu ukuilwa ihume kupumila kukiila i lina nila munyamilimo nuako ni ng'welu uYesu.” ");
INSERT INTO isn_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nai akakondya kulompa, nkika naiza ilundiie ku palung'wi ikahingisigwa, ni ihi ikizuligwa u Ng'wau Ng'welu, hangi ai atambue u lukani nulang'wa Itunda ku ugimya. ");
INSERT INTO isn_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ngele nkulu a awo nai ahuiie ai atulaa ni nkolo nu Ng'wau Ng'welu ung'wi; hangi kutili ga nung'wi ao nai uligitilye kina kihi nai usaile ai katulaa kakwe mukola; badala akwe ai atulaa ni intu yihi muhangu. ");
INSERT INTO isn_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ku ngulu nkulu i itumi ai atulaa akutanantya u ukuiili nuao kutula wiuki nua Mukulu uYesu, nu ukende ukulu ai watulaa migulya ao ihi. ");
INSERT INTO isn_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ai kutili anga muntu wihi mukati ao nai ukepewe i maintu, ku nsoko antu ihi nai akete i mabada a iwanja ang'wi ito, ai aguiye nu kuleta i mpia nia intu nai atulaa aguiye. ");
INSERT INTO isn_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","nu ki ika pihi a migulu a itumi. Nu ugalanigwa ai witumilwe ku kila muhuiili, kuniganiila ni kila ung'wi nai u uiwe. ");
INSERT INTO isn_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","uYusufu, mulawi, muntu kupuma ku Kipro, ai winkiigwe i lina Barnabasi ni itumi (nanso ai impyanigwe, ingi mukende nu upoeelya). ");
INSERT INTO isn_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Aze ukete mugunda, ai u uguiye nu kuleta i mpia, akaiika pihi a migulu a itumi ");
INSERT INTO isn_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Iti gwa, muntu ug'wi nai witangwaa Anania, nu Safira musungu akwe, ai aguiye ipatyo nila nsailo, ");
INSERT INTO isn_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","nu kupiha ipatyo nila mpia nai aguiye (ga nu musungu akwe ai ulilingile ili), nu kuleta ipatyo nilisigile nu kuika mu migulu a itumi. ");
INSERT INTO isn_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Kuiti uPetro ai uligitilye, “Anania, ku nik u mulugu umizuiye inkolo ako kuligitya uteele ku Ng'wau Ng'welu nu kupiha ipatyo nila mugunda? ");
INSERT INTO isn_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Itungo nai watulaa likili kuguligwa, shanga ai latulaa nsailo ako? Hangi zeyakilaa kuguligwa, shanga ai likoli mu ulamuli nuako? itulikile uli usige ikani ili munkolo ako? Shanga uakongee anga ana adamu, ila umukongee Itunda.” ");
INSERT INTO isn_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Mu kija imakani aya, uAnania ai ugwie pihi nu kutinanga inkolo. Nu woa ukulu ai uaziie ihi nai aligulye ili. ");
INSERT INTO isn_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ahumba akapembya ku ntongeela nu kumuikila mu sanda, nu kumutwala kunzi nu kumuika. ");
INSERT INTO isn_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ze yakilaa masaa ataatu iti, u musungu nuakwe ai wingie mukati, aze shanga ulingile naza katulaa kipumie. ");
INSERT INTO isn_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","uPetro akamutambuila, “Ntambuile, anga aza ize muguiye u mugunda ku nsailo nanso.” Akaigitya, “Uu, ku nsailo yiyo.” ");
INSERT INTO isn_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Iti gwa uPetro akamutambuila, “Ikutulika uli kina migombilye ku palung'wi ku mugema u Ng'wau Ng'welu nua Mukulu? Goza, i migulu a awo naza amu ikile u mugoha nuako ikoli pa mumpita, hangi aku ukenga nu ku utwala kunzi.” ");
INSERT INTO isn_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Kupumbugiilya akagwa mu migulu ang'wa Petro, akatinanga inkolo, ni awo i ahumba akapembya mu kati akamuhanga wakondyaa kusha. Akamukenka nu kumutwala kunzi, nu kumuika pakupi nu mugoha nuakwe. ");
INSERT INTO isn_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Woa ukulu ukapembya migulya a itekeelo lihi, nu migulya a ihi nai igulye i makani aya. ");
INSERT INTO isn_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ilingasiilyo idu nu ukuilwa ai yatulaa yukupumila mukati a antu ku kiila mikono a itumi. Ai atulaa palung'wi mi itando nilang'wa Sulemani. ");
INSERT INTO isn_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kuiti, kutili u muntu mungiiza nui nsuta nai watulaa nu ugimya nua kuambinkana ni enso; ga ni iti, ai inkiigwe ikulyo migulya a antu. ");
INSERT INTO isn_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ga ni ahuiili idu ai atulaa akongeeleka ku Mukulu, ingele nkulu a agoha ni asungu. ");
INSERT INTO isn_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ngeli kina ga nai akenkile u ulwae mu kisali, nu kualalisha mu ulili nu mu makoshi, iti kina uPetro anga watule ukukila u mululi nuakwe uhume kusima migulya ao. ");
INSERT INTO isn_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ga ni pan'wanso, ngele nkulu a antu ai apembilye kupuma isali ni ipilimikiiye iYerusalemu, aze a aletile i alwae ni ihi nai ahalinkaniwe ni nkolo ni nshafu, ni ihi ai agunilwe. ");
INSERT INTO isn_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kuiti u kuhani nu mukulu ai unyansukile, hangi ihi nai atulaa palung'wi nu ng'wenso ( naza ingi a makumbiko a asadukayo); hangi ai izuiwe nu wilu ");
INSERT INTO isn_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","akagoola i mikono ao kua amba i itumi nu kua ika mukati a kadulumu nila mu hangu. ");
INSERT INTO isn_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ni matungo a utiku u malaika nua Mukulu akamilugula i milango a kadulumu nu kuatongeela kunzi nu kuligitya. ");
INSERT INTO isn_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Longoli, mimike mi tekeelo nu kuatambuila i antu imakani ihi na upanga uwu.” ");
INSERT INTO isn_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nai akija ili, ai ingie mi tekeelo matungo a maniambwa nu kumanyisa. Kuiti, u kuhani nu mukulu ai uzile ni ihi nai akoli nu ng'wenso, nu kitangiisa i anza lihi ku palung'wi, ni anyampala ihi nia antu a Israeli, nu kua lagiilya mu kadulumu iti kualeta i itumi. ");
INSERT INTO isn_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kuiti i anyamulimo nai akalongola, shanga ai a ahangile mu kadulumu, ai asukile nu kuaganuila. ");
INSERT INTO isn_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Kuhangile i kadulumu ilugaiwe iza, ni asunja imikile pa mulango, kuiti nai katula ku ulugula, shanga kihenga u muntu mukati.” ");
INSERT INTO isn_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Itungili itngo u jemedari nua itekeelo ni akuhani akulu nai akija i makani aya, ai ingiiwe nu woa ukulu ku nsoko ao, azesiga likutulika uli ikani ili. ");
INSERT INTO isn_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Uugwa ung'wi akapembya nu kuatambuila, “iAntu naza muaikile mu kadulumu imikile mi itekeelo nu kumanyisa i antu.” ");
INSERT INTO isn_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Iti gwa u jemedari ai ulongoe palung'wi ni anyamulimo, nu kualeta, kuiti bila a kituma u minyomo, ku nsoko ai a itumbile i antu akuhuma a akue ku magwe. ");
INSERT INTO isn_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nai akondya kualeta, ai a ikile ntongeela a ianza, uKuhani nu mukulu aka akolya, azeligitya, ");
INSERT INTO isn_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Aza kulagiiye muleke kumanyisa ku lina ili, hangi mukili mumizuiye i Yerusalemu ku umanyisa nuanyu, nu kuhung'wa nsula a kuleta isakami a muntu uyu migulya itu. ");
INSERT INTO isn_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Kuiti uPetro ni itumi aka sukiilya. “Kusinja kumukulye Itunda kukila i antu. ");
INSERT INTO isn_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Itunda nua atata itu ai umiukilye uYesu, nai mumubulagile, ku kumutumbika migulya i ikota. ");
INSERT INTO isn_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Itunda ai umukuiye mu mukono nuakwe nua kigoha, nu kumuzipya kutula Mukulu hangi muguni, kupumya upeli ku Israeli, nu ulekelwa nua milandu. ");
INSERT INTO isn_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Usese ingi akuiili nia makani aya, nu Ng'wau Ng'welu, naiza Itunda umupumilye ku awo ni imukulyaa.” ");
INSERT INTO isn_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ianyi anza nai akija iti, ai a ambilwe ni ikuo akalowa kuabulaga i itumi. ");
INSERT INTO isn_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kuiti u pharisayo nai witangwaa Gamalieli, ng'walimu nua malagiilyo, nai ukuigwe ni antu ihi, ai wimikile nu kualagiilya i itumi aholwe kunzi ku itungo ikupi. ");
INSERT INTO isn_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Iti gwa aka atambuila, “Agoha nia Israeli, tuli ahugu nangaluu ni iko ni mukusigiila kua tendeela i antu awa. ");
INSERT INTO isn_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ku nsoko, ikali niaki ilee, uTheuda ai wimikile nu kitendiisa kutula muntu mukulu, ni ngele a antu, apikiie magana anne ai amutyatile. Ai ubulagilwe, ni ihi nai atulaa amukuiye ai asapatie nu kulimila. ");
INSERT INTO isn_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ze yajilaa u muntu uyu, uYuda mu Galilaya, ai uhumbukile i mahiku nanso nia kukilisigwa ualigwa, aka aluta i antu idu ku kituli kakwe. Nu ng'wenso ga ai ulimie ni ihi nai atulaa amukuiye ai asapatie. ");
INSERT INTO isn_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Itungili ku mutambuila, ihuji ni antu awa hangi mualeke i akola, ku nsoko, anga i masigo aya ang'wi mulimo uwu ingi wa antu ukugung'wa. ");
INSERT INTO isn_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Kuiti anga utule wang'wa Itunda, shanga mukuhuma ku ugilya; muhumile ga ukuhanga muki kilya ni Itunda.” Iti gwa, ai alutilwe ni imakani akwe. ");
INSERT INTO isn_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Uugwa, ai aitangile i itumi nuku a kua nu kualagiilya aleke kuligitya ku lina nilang'wa Yesu, nu kualeka alongole yao. ");
INSERT INTO isn_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ai ahegile ntongeela a ianza aze iloile ku soko a aligwa kutula akagisha nu kuhita ku kuligwa ku nsoko a lina ni lanso. ");
INSERT INTO isn_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ku lulo, kila luhiku, mukati i tekeelo nu kupuma mi ito kupikiil ito ai alongolekile kumanyisa nu kutanantya uYesu kina Musagulwa. ");
INSERT INTO isn_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Itungili mu mahiku aya, matungo i ngele a amanyisigwa nai ikatulaa i kongeeleka, u witushi nua Ayahudi nia ki Yunani ai landilye ku a Ebrania, kunsoko ahimbi ao ai atulaa akiwa mu womolang'yi nua kila luhiku nua ndya. ");
INSERT INTO isn_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Itumi ikumi na abiili ai aitangile u milundo wihi nua amanyisigwa nu kuligitya, “Shanga iziza kita itu kululeka u lukani nulang'wa Itunda nu kua aiilya mu meza. ");
INSERT INTO isn_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ku lulo anyandugu, holang'yi, agoha mupungati, kupuma mukati anyu, antu akende, ni izue u Ng'wau Ng'welu nua upolo, naza kuhumile kuinkiilya u uailya uwu. ");
INSERT INTO isn_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nu sese, ku ulongoleka ikali kulompa nu mu uailya nua lukani. ");
INSERT INTO isn_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Uganuli nuao ukaliloeelya ianza lihi. Iti gwa ikamuholania uStefano, muntu nuizuee uhuiili nu Ng'wau Ng'welu, nu Filipo, Prokoro, Nikanori, Timoni, Parmena, nu Nikolao, muokole kupuma ku Antiokia. ");
INSERT INTO isn_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ahuiili ai a aletile i antu awa ntongeela a itumi, nai alompile ni panyambele aka aikiilya i mikono ao. ");
INSERT INTO isn_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Iti gwa, lukani nulang'wa Itunda likenela; ni ngele a amanyisigwa ai ikiile kongeeleka uko ku Yerusalemu; ni ngele nkulu a akuhani aka ukulya u uhuiili. ");
INSERT INTO isn_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Nu Stefano, nai wizuee u ukende ni ngulu, ai watulaa ukituma ukuilwa ni ilingasiilyo ikulu mukati ao mu antu. ");
INSERT INTO isn_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kuiti pang'wanso akanyansuka ang'wi ao a antu atyatiili itekeelo ni litangwaa itekeelo nila Mahulu, ni la a Kirene hangi la Aesksnderia, ni ang'wi kupuma ku Kilikia ni Asia. Antu awa ai atulaa akikolenkeelya nu Stefano ");
INSERT INTO isn_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kuiti, shanga ai ahumile ki kilya nu upolo nua Ng'wau Ng'welu naiza uStefano ai watulaa ukutumila mu witambuili. ");
INSERT INTO isn_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Uugwa ai uapembeseeye ang'wi a antu ku kinkunku kuligitya, “Kigulye uStefano ukuligitya makani a kimeli kung'wa Musa ni kung'wa Itunda.” ");
INSERT INTO isn_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ai a asingilye i antu, anyampala, ni amanyi, nu kumuhanga uStefano, akamuamba, nu kumuleta ntongeela i anza, ");
INSERT INTO isn_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","aka aleta ia kuiili nia uteele, azeligitya, “umuntu uyu shanga ukuleka kitunta i makani ni mabii ku kianza iki ni kelu ni ilagiilyo. ");
INSERT INTO isn_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ku iti kumigulye ukuligitya kina uyu uYesu nua ku Nazareti ukubipya i nkika apa nu kuikaila i ntendo nai kinkiigwe nu Musa.” ");
INSERT INTO isn_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Kila ung'wi nai ukoli mi ananza, akatunja i miho akwe kumugozeela uStefano, ni enso akihenga u usu nuakwe ai watulaa anga usu wang'wa malaika. ");
INSERT INTO isn_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","uKuhani nu mukulu akaligitya, “makani aya ingi a tai?” ");
INSERT INTO isn_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","uStefano akaligitya, Anya ndugu ni a tata ane, ntegeelyi u nene; Itunda nu ikulyo ai umupumie u tata nuitu u Abrahimu matungo nai ukoli ku Mesopotamia, ze wakili kikie ku Harani,' ");
INSERT INTO isn_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","akamuila, 'Hega mi ihi ako ni anya ndugu ako hangi ulongole mi ihi ni nikakulagiila.' ");
INSERT INTO isn_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Iti gwa akahega mihi a Ukalidayo akikie ku Harani, kupuma papo, ze yakilaa u tata nuakwe kusha, Itunda akamuleta mi ihi iyi, ni ikiie itungili. ");
INSERT INTO isn_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Shanga ai uminkiiye kihi anga usali nuakwe, ai kutili ipatyo ga nila kuika u mugulu. Kuiti uAbrahamu ai upewe ilago ze ikili ga nu kulija ung'wana kina ukupegwa ihi anga isalo ni lakwe nu ulelwa nuakwe. ");
INSERT INTO isn_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Itunda ai wituntile nu ng'wenso iti, nia kina ulelwa nuakwe ai uziikie mi ihi a uziila, ni kina i akola ihi nia kuko akuatenda kutula atugwa ao nu kuatenda ibibi ku itungo nila myaka magana anne. ");
INSERT INTO isn_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nu Itunda akaligitya, nikaulamula u ingu niiza ukumutenda aholwa, ni i zeyakilaa nia pang'wanso akupuma nu kumpoelya mu nkika iyi! ");
INSERT INTO isn_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Hangi akaminkiilya uAbrahamu ilago nila kidamu, itigwa u Abrahamu akatula tata wang'wa Isaka akamutwala i kidamu luhiku nula mu nana; uIsaka akatula tata wang'wa Yakobo, nu Yakobo akatula tata nua isekulu itu ikumi na abiili. ");
INSERT INTO isn_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","iIsekulu ni itu akamuonela wilu uYusufu aka mugulya mu ihi a ku Misri, nu Itunda ai watulaa palung'wi nu ng'wenso, ");
INSERT INTO isn_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","hangi akamuguna mu lwago nu lakwe, nu kuminkiilya kipegwa nu upolo ntongeela ang'wa Farao mutemi nua ku Misri. uFarao akamuika watule muhumi migulya a Misri nu migulya a ito ni lakwe lihi. ");
INSERT INTO isn_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Uugwa ikatula ni nzala nkulu nu lwago lidu mu ihi a Misri ni Kanani, ni a tata itu shanga ai aligilye indya. ");
INSERT INTO isn_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kuiti uYakobo nai wakija ikoli idya ku Misri, ai ualagiiye i atata itu ku nkua ang'wandyo. ");
INSERT INTO isn_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Mu muhinzo nua kabiili uYusufu akilagiila ku aluna akwe, anyandugu ang'wa Yusufu akakumuka kung'wa Farao. ");
INSERT INTO isn_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","uYusufu aka alagiilya i aluna akwe alongole kumuila uYakobo tata nuao waze ku Misri, palung'wi ni anya ndugu akwe, kuhanguila antu ihi ingi makumi mupungati na ataano. ");
INSERT INTO isn_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Iti gwa uYakobo akasima ku Misri; Uugwa akasha ng'wenso palung'wi ni atata itu. ");
INSERT INTO isn_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Akaholwa ga nu ku Shekemu akaikwa mu kibiila naiza uAbrahamu ai ukiguile ku ipande nia mpia kupuma ku ana ang'wa Hamori uko ku Shekemu. ");
INSERT INTO isn_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Matungo a ilo ilago naiza Itunda ai umulagile uAbrahamu nai lahumbeela, antu aze atulaa ongeeleka uko ku Misri, ");
INSERT INTO isn_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","matungo nanso ai u ukile mutemi mungiiza migulya a Misri, mutemi ni shanga umulingile u Yusufu. ");
INSERT INTO isn_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","uMutemi uyu nu mungiiza waka akongela i antu itu nu kuatenda ibibi i a tata itu, nu kuaguma i ana ao ni adabu iti aleke ki kie. ");
INSERT INTO isn_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Mu matungo nanso uMusa ai utugilwe; ai muziza ntongeela ang'wa Itunda, akalelwa myeli itaatu mi ito nilang'wa tata nuakwe. ");
INSERT INTO isn_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Itungo nai ugumilwe, u munanso nuang'wa Farao ai umuhoile akamulela anga ng'wana nuakwe. ");
INSERT INTO isn_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","uMusa ai umanyisigwe umanyisigwa wihi nua ku Misri; ai munyangulu mu nkani nu mu ntendo. ");
INSERT INTO isn_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Kuiti ze yakilaa kutimilya myaka makumi anne, ikamuziila mu nkolo akwe kuagendeela i anyandugu akwe, ana a Israeli. ");
INSERT INTO isn_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Nai akamihenga mu Israeli ukutendeelwa ubii, uMusa ai umuguniiye nu kususha u ubii nai watula ukumuonela ku kumukua u mu Misri: ");
INSERT INTO isn_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","aze usigile kina i anya ndugu akwe akulinga kina Itunda ukuaguna ku mukono nuakwe, kuiti shanga ikalinga. ");
INSERT INTO isn_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Luhiku nai lutyatile akalongola ku ang'wi a Aisraeli nai atulaa akilea; wakagema kuahunga; azeligitya, 'Akulu, Unyenye ingi mi ndugu; mbona mukilea nyenye ku nyenye? ");
INSERT INTO isn_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Kuiti nai umuleile u munyakisali nuakwe akamugumiila kuli, nu kuligitya, 'Nyenyu nu kuikile wi muhumi hangi wi mulamula antu? ");
INSERT INTO isn_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Uewe uloilwe kumbulaga, anga naza umubulagile u Mumisri igulo?” ");
INSERT INTO isn_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","uMusa akamanka ze yakilaa kija ayo; akatula muziila mu ihi a Midiani, naiza akatula tata nua ana abiili. ");
INSERT INTO isn_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ze yakilaa myaka makumi anne kukila, malaika akamupumila mu ibambazi nila lugulu nua Sinai, mu lulimi nula moto mukati i kundui. ");
INSERT INTO isn_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Matungo uMusa nai wakihenga u moto, ai ukuiwe iko nai ukihenga, hangi nai ugemile kukihumbeela iti kukigoza, luli nila Mukulu likamuzila luzeligitya, ");
INSERT INTO isn_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Nene Itunda nua atata ako, Itunda wang'wa Abrahamu, hangi wang'wa Isaka, hangi wang'wa Yakobo; uMusa ai ukagatile hangi shanga akagema kugozeela. ");
INSERT INTO isn_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Mukulu akamutambuila, Tugula i ilatu niako, inkika nuimikile ingi kianza kelu. ");
INSERT INTO isn_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nihengaa u lwago nula antu ane niamoli ku Misri; Nijaa kulwala kitalao, nu nene nasimaa iti niagune; itungili pembya, nikakulagiilya uewe ku Misri.' ");
INSERT INTO isn_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Uyu uMusa naiza amuhitile, itungo nai aligitilye, 'nyenyu nukuikile kutula wi muhumi hangi mulamuli nuitu?' - ai watulaa yuyo ng'wenso Itunda ai umulagiiye atule muhumi hangi muguni. Itunda ai umulagiiye ku mukono nuang'wa malaika naiza ai umupumiie uMusa mi ikundui. ");
INSERT INTO isn_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","uMusa ai uatongee kupuma ku Misri ze yakilaa kituma u ukuilwa ni ilingasiilyo mu Misri nu mu luzi nula shamu, nu mu ibambazi ku itungo nila myaka makumi anne. ");
INSERT INTO isn_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ingi uMusa yuyo nai uatambuie i antu a Israeli kina, 'Itunda ukumunyansuilya munyakidagu kupuma mukati a anyandugu anyu munyakidagu anga nene' ");
INSERT INTO isn_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Uyu ingi muntu niiza mu i anza mi ibambazi nu malaika naiza ai utambue nu ng'wenso mu lugulu nula Sinai. Uyu yuyo muntu naiza ai watulaa ni atata itu, uyu ingi muntu naiza ai usingiiye u lukani nulukete u upanga nu kuinkiilya usese. ");
INSERT INTO isn_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Uyu ingi muntu naiza i atata itu ai ahitile ku mukulya; ai amugumiie kuli, nu mu nkolo niao ai apilukie ku Misri. ");
INSERT INTO isn_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Mu itungo nilanso ai amutambuie uHaruni. 'kuzipilye i itunda ni ika kutongeela. Uyu uMusa, nai watulaa uku utongeela kupuma kihi a ku Misri, shanga kulingile nai kimihangile,' ");
INSERT INTO isn_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Iti gwa ai azipilye ndama ku mahiku nanso nu kupumya isongelyo kung'wa nuanso u dudu hangi akiloeelya ku nsoko a mulimo nua mikono ao. ");
INSERT INTO isn_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Kuiti Itunda ai uapiue nu kuinkiilya ipoelye i nzota nia kilunde, anga nai ikilisigwe mu mbugulu a anyakidagu, 'Itii, mampumilyaa unene i masongelyo a ikali nai muisinzile mi ibambazi ku matungo a myaka makumi anne, ito ni lang'wa israeli ");
INSERT INTO isn_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Makigombaa i kitala nika kutankanila ni kang'wa Moleki ni inzota niang'wa Itunda refani, nu mululi ni mu uzipilye nu kuipoelya enso; hangi kumutwala kuli ikilo ni Babeli.' ");
INSERT INTO isn_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","aTata anyu ai akete i kitala nika kutankanila nika ukuiili mu ibambazi, anga Itunda nai ulagiiye nai utambue nu Musa, kina ukukizipya ku mpyani a iko nai ukihengile. ");
INSERT INTO isn_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Iki ingi kitala naiza a tata itu ku itungo ni lao, ai aletilwe mu ihi nu Joshua. Iki ai kipumie matungo nai ingie kusala u ingu naiza Itunda ai uazunsilye ze yakilaa u umoli nu a a tata itu. Iki ai kituile iti kupikiila luhiku u Daudi, ");
INSERT INTO isn_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","naiza ai uligilye u ugombigwa mu miho ang'wa Itunda; nu kulompa kuduma likalo kung'wa Itunda nuang'wa Yakobo. ");
INSERT INTO isn_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kuiti uSelemani ai umuzengee ito Itunda. ");
INSERT INTO isn_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ga ni iti Nukoli kigulya shanga wikiie mu mato nazengilwe ku mkono; iki iti anga u munyakidagu nai uligitilye. ");
INSERT INTO isn_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ilunde ingi ituntu nilane nila ukulu, ni ihi ingi nkika a kuikila migulu ane. Ito la mpyani kii Mukunzengela?, uligitilye Mukulu; ang'wi ingi pii i nkika ane na akusupilya? ");
INSERT INTO isn_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Shanga mukono nuane nuitumile izi i intu yihi?' ");
INSERT INTO isn_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Unye antu niakete nkingo nkaku ni shanga mutawe i kidamu mu nkolo ni akutwi, kila nkua mimukingila u Ng'wau Ng'welu,' mukituma anga i a tata anyu nai itumile. ");
INSERT INTO isn_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ingi munyakidagu kii mu anyakidagu naiza i a tata anyu shanga ai amagilye? Ai a abulagile i anyakidagu ihi nai apumie ze ikili u upembelyo nua Ung'wi munya Tai ane; ni itungili matulaa ahugi hangi abulagi akwe ga, ");
INSERT INTO isn_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","unye antu nai musingiiye ilagiilyo ilo nai lilagiigwe nu malaika kuiti shanga ai muliambile.” ");
INSERT INTO isn_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Uugwa i anyi anza nai akija imakani aya, ai asonsilwe i nkolo niao, akamukilisilya i mino uStefano. ");
INSERT INTO isn_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kuiti nuanso, aze watulaa wizue u Ng'wau Ng'welu, ai ugozile kilunde ku ukendegeeli hangi akihenga ikulyo nilang'wa Itunda,' nu kumihenga uYesu wimikile mukono nua kigoha nuang'wa Itunda. ");
INSERT INTO isn_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","uStefano akaligitya, “Goza nihengaa ilunde lalugukaa, nu Ng'wana wang'wa Adamu wimikile mukono nua kigoha nuang'wa Itunda.” ");
INSERT INTO isn_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kuiti i anyi anza akazogolya ku luli nula migulya, akakiila i akutwi ao, aka mumankiila ku palung'wi, ");
INSERT INTO isn_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","akamuguma kunzi a kisali nu kumukua i magwe; ni akuiili akatugula i ang'wenda ao nia kunzi nu kuika pihi pakupi ni migulu a muhumba nuitangwaa Sauli. ");
INSERT INTO isn_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nai atulaa akumukua i magwe, uStefano ai ulongolekile kumitanga u Mukulu nu kuligitya, “Mukulu Yesu, singiilya i nkolo ane,”. ");
INSERT INTO isn_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Akatugama nu kitanga ku luli lukulu, “Mukulu, leka kua ailya u mulandu uwu. “Nai wakaligitya aya, akatinanga inkolo. ");
INSERT INTO isn_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","uSauli ai watulaa ukoli mu wigombya nua nsha akwe. luhiku nulanso papo nai wandilye kuaja nsuta ni itekeelo nai likoli ku Yerusalemu; ni a huiili ihi nai asapatie mu isali nia Yudea ni Samaria, kwaala i itumi. ");
INSERT INTO isn_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Antu a kinyauwai ai amuikile uStefano nu kuzipya u hongeelya ukulu migulya akwe. ");
INSERT INTO isn_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Kuiti uSauli ai ulimeile nangaluu itekeelo. Ai ulongoe ito ku ito nu kuakweha kunzi asungu i agoha, nu kuagumila mu kadulumu. ");
INSERT INTO isn_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ahuiili naza atulaa asapatie ai akili akulutanantya u lukani. ");
INSERT INTO isn_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","uFilipo akasima mu kisali nika Samaria nu kumutanantya uKristo Yesu ");
INSERT INTO isn_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ze yakilaa i anyianza kija nu kihenga i ilingasiilyo nai witumile u Filipo; akaika ukendegeeli migulya a iko nai uligitilye. ");
INSERT INTO isn_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Kupuma papo i antu idu nai igulye, ahing'wi ai a apumile i antu kunu akulila ku luli lukulu, hangi idu nai akule igandi ni akitele ai agunilwe. ");
INSERT INTO isn_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Hangi ai ukoli ulowa ukulu mu kisali. ");
INSERT INTO isn_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kuiti ai ukoli muntu ung'wi mu kisali nikanso i lina nilakwe Simioni, naiza watulaa ukituma ulogi; naza ai u utumie kua kuila i antu a ingu nua Samaria, itungo wazeligitya kina nuanso ingi muntu nua kusanigwa. ");
INSERT INTO isn_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ia Samaria ihi puma nu muniino ga nu mukulu, akamutegeelya; akaligitya; “umuntu uyu igi iyo i ngulu ang'wa Itunda naiza ingi mukulu.” ");
INSERT INTO isn_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Akamutegeelya, ku ndogoelyo wa akuie ku itungo ilipu ku ulogi nuakwe. ");
INSERT INTO isn_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Kuiti itungo nai ahuiie kina uFilipo ai utanantilye migulya a utemi nuang'wa Itunda nu migulya a lina nilang'wa Yesu Kristo, ai ogigwe, agoha ku asungu. ");
INSERT INTO isn_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Nu Simioni mukola ai uhuiie: ze yakilaa kogigwa, akalongoleka kutula nu Filipo; nai wakihenga i ilingaasiilyo nu ukuilwa nai watula ikitung'wa, ai ukuiwe. ");
INSERT INTO isn_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Matungo i Itumi niaku Yerusalemu nai akija kina ku Samaria asingiilya u lukani nulang'wa Itunda, aka alagiilya uPetro nu Yohana. ");
INSERT INTO isn_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Matungo nai atulaa akusima aka alompeela; kina amusingiilye u Ng'wau Ng'welu. ");
INSERT INTO isn_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kupikiila itungo nilanso, u Ng'wau Ng'welu ai watulaa wakili kuasimiila ga nung'wi ao; ai atulaa ogigwa udu ku lina nila Mukulu uYesu. ");
INSERT INTO isn_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Uugwa uPetro nu Yohana aka aikiilya i mikono, ni enso akasingiilya u Ng'wau Ngwelu. ");
INSERT INTO isn_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Matungo uSimioni nai wakihenga kina u Ng'wau Ng'welu wapumigwa kukiila kuikigwa i mikono ni itumi; akalowa kuinkiilya mpia, ");
INSERT INTO isn_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Akaligitya, “Ninkiilyi ingulu iyi, iti kila ni nikamuikiilya u mukono wasingiilye u Ng'wau Ng'welu.” ");
INSERT INTO isn_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Kuiti uPetro akamutambula, i mpia niako palung'wi nu ewe ilimililee kuli, ku nsoko usigile kina i ipegwa ni ang'wa Itunda iligigwa ku mpia. ");
INSERT INTO isn_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Umugila ipatyo mu ikani ili, ku nsoko inkolo ako shanga ngoloku ntongeela ang'wa Itunda. ");
INSERT INTO isn_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Iti gwa ile itunu u ubii nuako nu kumulompa Itunda kwaala ukulekelwa i masigo na munkolo ako. ");
INSERT INTO isn_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ku ndogoelyo kihenga ukoli mu uhungu nua uwai ni kitungo nika mulandu.” ");
INSERT INTO isn_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","uSimioni akasukiilya nu kuligitya, “Mulompi uMukulu ku nsoko ane, ku nsoko i makani ihi ni mumaligitilye ahumile kumpumila. ");
INSERT INTO isn_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Matungo uPetro nu Yohana nai atula akuiila nu kutanantya u lukani nula Mukulu, ai asukile ku Yerusalemu ku nzila yiyo; ai atanantilye i nkani ninza mu ijiji idu nia a Samaria. ");
INSERT INTO isn_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Uugwa u malaika nua Mukulu akitambulya nu Filipo akaligitya, “Elye hangi ulongole takama mu nzila ni longoe pihi a Yerusalemu kutunga ku Gaza.” (Nzila iyi ikoli mu ibambazi). ");
INSERT INTO isn_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Akelya nu kulongola. Goza, ai ukoli muntu nua ku Ethiopia, Towashi ukete uhumi ukulu pihi a kandase; malkia nua Ethiopia. Nai uikilwe migulya a itulyo nilakwe lihi; nu ng'wenso ai watulaa walongolaa ku Yerusalemu ki kumbika. ");
INSERT INTO isn_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ai watulaa ukusuka wikie mu mutuka nuakwe ukusoma mbugulu a munyakidagu uIsaya. ");
INSERT INTO isn_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ng'wau Ng'welu akaligitya nu Filipo, “Humbeela pakupi nu mutuka uwu uambinkane nu wenso. ");
INSERT INTO isn_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Iti gwa uFilipo akalongola i ntambo, akamija ukusoma mu mbugulu ang'wa Isaya; akaligitya, Itii, ulingile nu kukisoma?” ");
INSERT INTO isn_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","uMuethiopia akaligitya, “nikahuma uli muntu anga wahite kuntongeela?” Akamusinja uFilipo wanankile mu mutuka nu kikie palung'wi nu ng'wenso. ");
INSERT INTO isn_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Itungili ilundo nila ukilisigwa nai utuile ukulisoma uMuethiopia ingi ili, ai utongeewe anga ng'waa nkolo kulongola ku usinzilwo kusinzwa ai ukilagile ihi twii, shanga ai ukunukua ilangu nilakwe; ");
INSERT INTO isn_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ku kinya uwai kakwe ulamuli nua kwe ai uhegigwe; Nyenyu ukuganuila u ulelwa nuakwe? u likalo nulakwe lahegigwe mihi.” ");
INSERT INTO isn_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Uugwa u towashi akamukolya uFilipo, nu kuligitya, “nukulompile, ingi munyakidagu kii naiza utambuwe inkani niakwe, ingi kutula ng'wenso, ang'wi nia muntu mungiiza?” ");
INSERT INTO isn_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","uFilipo ai wandilye kuligitya, ai wandilye ku ukilisigwa uwu nuang'wa Isaya kumutanantilya nkani yang'wa Yesu ");
INSERT INTO isn_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Aze akoli munzila, akapika pa mazi, utowashi akaligitya, “Goza, akoli i mazi apa ntuni ni kikingie ndeke kogigwa”, ");
INSERT INTO isn_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","(imakani aya, ' Iti gwa uMuethiopia akasukiilya, “nihuiie kina uYesu Kristo ingi ng'wana wang'wa Itunda.” amutili mu mbugulu nia kali). Papo uMuethiopia akalagiilya u mutuka wimike. ");
INSERT INTO isn_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ai alongoe mukati a mazi, palung'wi uFilipo nu towashi, uFilipo akamoja. ");
INSERT INTO isn_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Matungo nai akapuma mu mazi, Ng'wau Ng'welu nua Mukulu akamutwala uFilipo kahelu; utowashi shanga akamihenga, akalongola i nzila akwe waze ulumbiiye. ");
INSERT INTO isn_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Kuiti uFilipo akapumila ku Azolo, ai ukiile mu mukoa uwo nu kutanantya nkani ninza mu isali yihi kupikiila nai wakapika ku Kaisaria. ");
INSERT INTO isn_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Kuiti, uSauli, ai ulongolekile kuligitya u utumbani ga nuwu nua nsha ku amanyisigwa a Mukulu, akalongola kung'wa kuhani nu mukulu ");
INSERT INTO isn_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","nu kulompa ibada kunsoko a matekeelo uko ku Dameski, iti kina anga wamulije muntu nukoli mu nzila iyo, atule mugoha ang'wi musungu, wa atunge nu ku aleta ku Yerusalemu. ");
INSERT INTO isn_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ga nai watula ulongoe muhinzo, ai ipumie kina nai wahumbeela ku Dameski, kupumpugiilya ika melya pihi pihii welu kupuma kilunde,' ");
INSERT INTO isn_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","nung'wenso wakagwa pihi hangi akija luli lukumutambuila, “Sauli, Sauli, mbona ukunaja unene?” ");
INSERT INTO isn_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","uSauli akasukiilya, Wi nyenyu u ewe Mukulu? uMukulu akaligitya, “Unene ng'wenso Yesu nuku ntasha; ");
INSERT INTO isn_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Kuiti nyansuka, ingile mu kisali, nu ewe ukutambuilwa nu takiwe kituma. ");
INSERT INTO isn_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","iAntu awo nai akugenda palung'wi nu Sauli akakilaga ihi twii, aze ategeeye u luli, shanga ikihenga u muntu. ");
INSERT INTO isn_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","uSauli akanyansuka mu ihi nai kunukue i miho akwe, shanga akahuma kihenga i kintu, akamuamba u mukono akamuleta kupikiila ku Dameski. ");
INSERT INTO isn_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ku mahiku ataatu shanga ukihenga, shanga ukulya, ang'wi kung'wa. ");
INSERT INTO isn_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Uugwa ai ukoli u mumanyisigwa ku Dameski i lina nilakwe Anania, uMukulu ai uligitilye nu ng'wenso mu muloto, 'Anania.” Nu kuligitya, “ Goza, nkoli apa, Mukulu. ");
INSERT INTO isn_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","“uMukulu akamutambuila, “Nyansuka ulongole mu kisali nikitangwaa Nyofu, nu mu ito nilang'wa Yuda ukolye muntu kupuma ku Tarso, nuitangwaa Sauli; ndogoelyo umoli ukulompa; ");
INSERT INTO isn_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","hangi aza umihengile mu muloto u muntu i lina nilakwe Anania ukingila nu kumuikiilya i mikono migulya akwe iti kina walije kihenga. ");
INSERT INTO isn_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Kuiti u Anania akasukiilya, “Mukulu, nijaa inkani nia muntu uyu ku antu idu, ku ngele kii nukuatendeela ubi i elu nia uko ku Yerusalemu; ");
INSERT INTO isn_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Apa ukete u uhumi kupuma kung'wa kuhani nu mukulu kumuamba kila ung'wi nuenda litanga i lina nilako. ");
INSERT INTO isn_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Kuiti uMukulu akamutambuila, “Longola, ku ndogoelyo nuanso ingi kiseme kihoilwe kitolane, walihole ilina nilane ntongeela a anyaingu ni a temi ni ana a Israeli. ");
INSERT INTO isn_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ndogoelyo nikamulagiila nili idu nakumutulika kagigwa ku nsoko a lina nilane.” ");
INSERT INTO isn_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","uAnania akalongola, akingila umo mito; Akamu ikiilya i mikono akaligitya, Munya ndugu Sauli, uMukulu uYesu, naza ukupumie mu nzila naza watulaa upembilye, undagiiye ulije kihenga hangi wizuligwe u Ng'wau Ng'welu. ");
INSERT INTO isn_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kupumpugiilya ikagwa kupuma mu miho akwe intu anga makulugamba, akalija kihenga, akimika, akogigwa; akalya indya nu kulija ingulu. ");
INSERT INTO isn_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Akikie palung'wi ni amanyisigwa uko ku Dameski ku mahiku idu. ");
INSERT INTO isn_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Matungo yayo yaayo akamutanantya uYesu mu matekeelo, azeligitya kina u ng'wenso ingi ng'wana wang'wa Itunda. ");
INSERT INTO isn_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Hangi ihi nai igulye ai akuiwe nu kuligitya, “Shanga yuyu nai uabipilye ihi nai itangile i lina ili uko ku Yerusalemu? Hangi apa aza uzile ku isigo nila kuatunga nu kuatwala ku akuhani.” ");
INSERT INTO isn_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Kuiti uSauli ai uaiigwe kutanantya nu kuatenda i Ayahudi nai ikiie ku Dameski ahalinkanilwe nu ku kaminkiilya nia kina uyu yuyo Kristo. ");
INSERT INTO isn_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ze yakilaa mahiku idu, Ayahudi akaika ulamuli palung'wi iti amubulage. ");
INSERT INTO isn_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Kuiti isigo lao likakumuka kung'wa Sauli. Akamutugila pa mumpita mung'wi nu utiku alije kumubulaga. ");
INSERT INTO isn_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kuiti amanyisigwa akwe akamuhola utiku akamusimya kukiila mi ikiligo, akamusimya pihi mu nkapu. ");
INSERT INTO isn_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Nu Sauli nai wapika ku Yerusalemu, ai ugemile kihanguila ni amanyisigwa; kuiti ai atulaa akumogopa, shanga akahuiila kina ung'wenso ingi mumanyisigwa. ");
INSERT INTO isn_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kuiti uBarnaba akamuhola nu kumutwala ku itumi, Nu kuaganuila kinyauli uSauli ai umuine u Mukulu mu nzila nu Mukulu nai uligitilye nu ng'wenso, ni kinyauli uSauli nai utanantilye ku ukamatiku ku lina nilang'wa Yesu uko ku Dameski. ");
INSERT INTO isn_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ai utankanile ni enso nai akingila nu kupuma ku Yerusalemu. Akitunta ku ukamatiku ku lina nila Mukulu uYesu, ");
INSERT INTO isn_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","azikolenkeelya ni Ayahudi nia Kiyunani, kuiti azegema nkua ku nkua kumubulaga. ");
INSERT INTO isn_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Matungo ia luna nai alinga ikani nilanso, akamuhola kupika ku Kaisaria, nu kumutwala alongole ku Tarso. ");
INSERT INTO isn_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Uugwa itekeelo lihi mu Uyahudi, Galilaya ni Samaria, ai latula nu ulyuuku, hangi likazengwa, nu kugenda mu woa nua Mukulu ni ipoelya nila Ng'wau Ng'welu, itekeelo likakula ku kongeeleka ingele. ");
INSERT INTO isn_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Uugwa ai upumie uPetro nai ukoli ukupilima pilima nkika yihi nia mukoa, aka asimiila ahuiili ni ikie mu kisali nika Lida. ");
INSERT INTO isn_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Akamihenga kuko muntu ung'wi i lina nilakwe Ainea, muntu uyu watuilee mu ulili myaka munana; ndogoelyo ai watulaa kitele. ");
INSERT INTO isn_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","uPetro akamuila, “ Ainea, uYesu Kristo akugune; Uka hangi witandikilye u ulili nuako,” Nkua yiyo akauka. ");
INSERT INTO isn_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ni atu ihi nai ikiie ku Lida ni Sharoni nai amihengile u muntu uyo, ai amupilukie u Mukulu. ");
INSERT INTO isn_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ai akoli nu mumanyisigwa Yafa nuitangwaaTabitha, niiza limpyanigwe anga “Dorcas.” Uyu musungu ai wizue mulimo ukende ni ntendo nia ukendepwa nai witumaa ku a ula. ");
INSERT INTO isn_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ai ipumie mu mahiku nanso ai ulwae nu kusha; nai amukalalya, ai amunankiiye shumba nika migulya nu kumulalisha. ");
INSERT INTO isn_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ku iti i Linda ai atulaa pakupi ni Yafa, ni amanyisigwa ai igulye kina uPetro ai ukoli kuko, ai a alagiiye antu abiili kitalakwe, aze musinja, “Pembya kitaitu bila kutinia.” ");
INSERT INTO isn_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","uPetro akauka nu kuhega palung'wi ni enso. Nai wakapika, ai amuletile mu shumba nika migulya. Ni ahimbi ihi ai imikile pakupi nu ng'wenso azelila, azemulagiila ia mujulungu ni ang'wenda naza uDorcas ai uahilitiiye itungo nai ukoli palung'wi ni enso. ");
INSERT INTO isn_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","uPetro aka apumya ihi kunzi a shumba, akatugama akalompa, uugwa akaupilukila u muili, akaligitya, “Tabitha, uka.” Akalugula i miho akwe hangi nai wakamihenga uPetro akikie pihi. ");
INSERT INTO isn_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Uugwa uPetro akaminkiilya u mukono nuakwe akamunyansula, hangi nai wakaitanga i ahuiili ni ahimbi, akainkiilya kitalao aze mupanga. ");
INSERT INTO isn_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ikani ili likakumuka i Yafa ihi, ni antu idu akamuhuiila uMukulu. ");
INSERT INTO isn_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ai ipumie uPetro akikie mahiku idu ku Yafa palung'wi ni muntu nuitangwaa Simioni, muzipya ndili. ");
INSERT INTO isn_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ai ukoli nu muntu nua kitungaa mu kisali nika ku Kaisaria, lina nilakwe ai witangwaa Kornelio, ai mukulu wi idale nila Kiitalia. ");
INSERT INTO isn_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ai watulaa mukulya Itunda hangi ai umukuiye Itunda ni ito nilakwe lihi; ai upumilye mpia idu ku Ayahudi hangi ai ulompile kung'wa Itunda mahiku ihi. ");
INSERT INTO isn_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Matungo a saa kenda nia mung'wi, akihenga muloto Malaika nuang'wa Itunda upembilye kitalakwe. uMalaika akamutambuila, “Kornelio! ");
INSERT INTO isn_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","uKornelio akamugoza u malaika hangi ai ukete u woa ukulu nangaluu akaligitya “Iki ki ntuni mukulu?” uMalaika akamutambuila “Malompi ako ni masongelyo ako ku aula yanakilaa migulya anga ukimbukiilyi mu umoli nuang'wa Itunda.” ");
INSERT INTO isn_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Itungili lagiilya i antu alongole ikisali nika Yafa kumuleta muntu ung'wi nuitangwaa Simioni naiza witangwa ga ni Petro. ");
INSERT INTO isn_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Wikiie hangi munonia ndili nuitangwaa Simioni naiza ito nilakwe likoli mpelo a luzi.” ");
INSERT INTO isn_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ze yakilaa uMalaika nai watula ukuligitya nu ng'wenso kuhega, uKornelio akaitanga i anyamulimo ni a mito nilakwe abiili, nu a asikali nai watulaa ukumukulya Itunda pa kati a asikali nai atulaa akumuaiilya. ");
INSERT INTO isn_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","uKornelio ai uatambuie ihi nai apumie nu kualagiilya ku Yafa. ");
INSERT INTO isn_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Luhiku nai lutyatile itungo nila saa mutandatu aze amoli mu nzila hangi ahumbeela mu kisali, uPetro akanankila migulya mu kitala kulompa. ");
INSERT INTO isn_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ga ni hangi akatula ni nzala nu kusiga i kintu ka kulya, kuiti itungo i antu akuluga indya, akalagiilwa muloto, ");
INSERT INTO isn_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","akihenga ilunde laluguka ni kiseme kikusima ni kintu kituunga anga ng'wenda mukulu ukusima pihi mu mahalu mu nkigo niakwe yihi inne. ");
INSERT INTO isn_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mukati akwe ai ikoli mpyani yihi nia ikali ni ikete migulu inne nizi ni yagulaa migulya a mahalu, ni nyunyi nia milunde. ");
INSERT INTO isn_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Hangi luli lukaligitya kitalakwe, “Uka, Petro sinza nu nkulya.” ");
INSERT INTO isn_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Kuiti uPetro akaligitya “Shanga iti, Mukulu ku nsoko nkili nkaye kulya kintu kihi ni kizumi hangi kishapu. ");
INSERT INTO isn_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Kuiti u luli lukapembya kitalakwe hangi ku nkua akabiili “Nukeilye Itunda leka kukitanga kizumi ang'wi ki shapu.” ");
INSERT INTO isn_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Iki ai kipumie nkua itaatu, ni kiseme iko kikatula kaholwaa hangi milunde. ");
INSERT INTO isn_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ni matungo uPetro aze ukoli mu uhalinkanilwa migulya a muloto nuanso ndogoelyo akwe ntuni, Goza, antu nai atulaa alagiigwe nu Kornelio akimika ntongeela a mumpita, azekolya i nzila a kulongola mu ito. ");
INSERT INTO isn_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Hangi akitanga nu ku kolya anga ize uSimioni nuitangwaa ga ni Petro anga ize ai watulaa wkiie pang'wanso. ");
INSERT INTO isn_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Itungo nilanso uPetro nai watulaa ukusiga migulya a uwo u muloto, Ng'wau Ng'welu akaligitya nu ng'wenso, ");
INSERT INTO isn_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","“Uka hangi usime pihi nu kulongola ni enso. Leka kitumba kulongola ni enso, ku nsoko nialagiiye.” ");
INSERT INTO isn_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","uPetro akasima pihi kitalao nu kuligitya, “Unene yuyo ni mukumuduma. Ku niki mupembilye?” ");
INSERT INTO isn_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Akaligitya, “Akida ung'wi i lina nilakwe Kornelio, muntu nua tai ane hangi wilowaa kumukulya Itunda, ni antu imutambulaa ikende mu ingu wihi nua Ayahudi, utambuiwe nu malaika nuang'wa Itunda ku ulagiilya iti ulongole mi ito nilakwe, iti wije u lukani kupuma kitalako.” ");
INSERT INTO isn_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","uPetro aka asingiilya kingila mukati nu kikie palung'wi nu ng'wenso. Kidau dau nai kityatile akauka akalongola palung'wi ni enso, ni anya ndugu asheenyu kupuma ku Yafa akityata nu ng'wenso. ");
INSERT INTO isn_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Luhiku nai lutyatile ai azile ku Kaisaria. Nu Kornelio ai ukoli ualindiie; hangi ai watulaa waitanga palung'wi anya ndugu akwe ni ahumba uya akwe nia pakupi. ");
INSERT INTO isn_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Matungo uPetro nai ukingila mukati, uKornelio akamusingiilya nu kutuna kupika pihi mu migulu akwe ku ikulyo. ");
INSERT INTO isn_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Kuiti uPetro akamunyansula nu kuligitya “Imike; ga nu nene mukola ingi ni bina adamu.” ");
INSERT INTO isn_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Matungo uPetro aze ukoli ukitambuila nu ng'wenso, ai ulongoe mu ito akahanga i antu ilundiila palung'wi. ");
INSERT INTO isn_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Aka aila, Unyenye akola mulingile kina shanga ilagiilyo nila Ayahudi kihanguila ang'wi kugendeelwa nu muntu niiza shanga nua ingu uwu. Kuiti Itunda undagiie unene kina shanga ntakiwe kumitanga muntu wihi ingi muzung'waa ang'wi mushapu. ");
INSERT INTO isn_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Hangi yiyo ndogoelyo mpembilye bila kikungumya, nai ndagiigwe ku nsoko a iko. Kululo numukolye ku niki mulagiigwe ku nsoko ane.” ");
INSERT INTO isn_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","uKornelio akaligitya, “Mahiku anne nakiile, itungo anga lili aza nkoli kulompa itungo nila saa kenda mung'wi mukati ito nilane; Nihenga ntogeela ane muntu wimikile ukete ni ang'wenda elu. ");
INSERT INTO isn_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Akantambuila. “Kornelio malompi ako igigwa nu Itunda, ni masongelyo ako ku aula yatulaa ukimbukiilyi ntongeela ang'wa Itunda. ");
INSERT INTO isn_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Kululo lagiilya muntu ku Yafa nu kumitanga muntu ung'wi nuitangwaa Simioni waze kitalako, naiza hangi witangwaa Petro. naizaa wikiie ku muzipya ndili ung'wi nuitangwaa Simioni naiza ito nilakwe likoli mu mpelo a luzi. ");
INSERT INTO isn_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","(Komaniilya; U lukiili ulu, Nu ng'wenso nuikapemya ukuligitya nu nyenye,” umutule mu ukilisigwa nua kali.) ");
INSERT INTO isn_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Uugwa uPetro akalugula u mulomo nuakwe nuku ligitya “Tai, nahuiila kina Itunda shanga uhumile kutula nu ukuili. ");
INSERT INTO isn_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Badala akwe, kila ingu u muntu wihi nuimukulyaa nu kituma i ntendo nia tai ane ugombekile kitalakwe. ");
INSERT INTO isn_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ulingile u lukani nai u upimilye ku antu a Isreli, nai watulaa ukutanantya lukani nu lukende nula ulyuuku kukiila Yesu Kristo naiza Mukulu nua ihi - ");
INSERT INTO isn_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","nu nyenye akola mulingile i kintu nai kipumie, naiza kipumie ku Yudea ihi hangi ai landiiye ku Galilaya, ze yzkilaa u wogigwa naza uYohana ai utanantilye. ");
INSERT INTO isn_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","i kintu nai katulaa kimutule uYesu Kristo iti Itunda nai umuikie i makuta ku Ng'wau Ng'welu nu ku ngulu. Ai ulongoe nukituma u ukende nu kuaguna ihi naiagigwe nu mulugu, ku nsoko Itunda ai watulaa palung'wi nu ng'wenso. ");
INSERT INTO isn_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Usese ingi akuiili a makani ihi nai witumile mi ihi nia Uyahudi nu mu Yerusalemu- uyu ingi Yesu nai amubulagile nu kumutumbika mikota. ");
INSERT INTO isn_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Uyu muntu wang'wa Itunda nai umiukilye luhiku nula kataatu nu kuminkiilya kukumuka, shanga ku antu ihi, kuiti ku akuiili nai aholanigwe ze ikili ni Itunda. ");
INSERT INTO isn_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","-usese akola, nai kalyaa nu ng'wenso nu kung'waa nu ng'wenso ze yakilaa kiuka kupuma ku ashi. ");
INSERT INTO isn_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ukulagiiye kutanantya ku antu nu ku kuiila kina uyu yuyo naiza Itunda ai umuholanilye kutula mulamuli nua nia panga nawa niakule. ");
INSERT INTO isn_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Mu ng'wenso anyakidagu ihi akuiile, iti kina kila nukuhuiila mu ng'wenso ukusingiilya ulekelwa nua mulandu kukiila i lina nilakwe.” ");
INSERT INTO isn_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Matungo uPetro ulongolekile kuligitya aya, Ng'wau Ng'welu akaizulya ihi nai atulaa akutegeelya u lukani nulakwe. ");
INSERT INTO isn_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Antu awo niatulikile ni idale nila ahuiili nai atawe ikidamu- awo ihi nai azile nu Petro- ai akuiwe, ku nsoko a kipegwa nika Ng'wau Ng'welu nai uhunuwe ga nuku anyaingu. ");
INSERT INTO isn_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ku nsoko ai igule awa anyaingu akutambula ku ntambu ingiiza nu kumukulya Itunda. uPetro akasukiilya. ");
INSERT INTO isn_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ukoli muntu wihi uhumile kugilya i mazi iti i antu aleke kogigwa, Antu awa amusingiilya uNg'wau Ng'welu anga usese?” ");
INSERT INTO isn_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Uugwa akalagiilya ogigwe ku lina nilang'wa Yesu Kristo. Panya mbele akamulompa wikiie nienso ku mahiku kituunga. ");
INSERT INTO isn_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Itumi ni anya ndugu awo nai akoli uko ku Yudea nai igulye kina anyaingu alusingiilya u lukani nulang'wa Itunda. ");
INSERT INTO isn_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","uPetro nai wakiza uko kuYerusalemu, idale ilo nila antu nai atalwa ikidamu akandya ku musosha, Azeligitya, ");
INSERT INTO isn_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Wa ambinkana nia antu nishanga atawe ikidamu nu kulya nienso!” ");
INSERT INTO isn_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kuiti uPetro ai wandilye kuganula i kintu mu kati; azeligitya, ");
INSERT INTO isn_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Aza nkoli kulompa mu kisali nika Yafa, nihenga muloto nua kiseme kikusima pihi anga ng'wenda mukulu ukusima kupuma mi ilunde ku nkigo niakwe inne. kikasima kitalane. ");
INSERT INTO isn_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nikakigoza nu kusiga migulya akwe. Nikihenga ikali nia migulu inne niyikiie mi ihi, ni ikali nia mihaka ni ikali ni yagulaa ni nyunyi nia kilunde. ");
INSERT INTO isn_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Uugwa nikija luli lukuligitya nu nene, “Uka, Petro, sinza hangi ulye!” ");
INSERT INTO isn_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nikaligitya, “Shanga uu, Mukulu, mu mulomo nuane shanga yakaiyee kingila kintu kihi ni shanga keigwe ang'wi kishapu” ");
INSERT INTO isn_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Kuiti u luli lukansukiilya hangi kupuma kilunde, iko Itunda nukitanantilye kutula ingi kelu, leka kukitanga ingi kizung'wa, ");
INSERT INTO isn_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Iki ai kipumie nkua itaatu, ni kila kintu kikaholwa kilunde hangi. ");
INSERT INTO isn_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Goza, itungo nilanso antu a taatu ai atulaa imikile ntongeela ito ilo nai kumoli; alagiigwe kupuma ku Kaisaria kupembya kitalane. ");
INSERT INTO isn_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ng'wau Ng'welu akantambuila kulongola nienso, hangi ndeke kuhutana nienso. Awa agoha ni mu tandatu akalongola palung'wi nu nene hangi ai kulongoe mi ito nila muntu ung'wi. ");
INSERT INTO isn_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ai ukutambuie iti nai umihengile u malaika wimikile mukati ito nilakwe azeligitya, “Ndagiilye ku Yafa numulete uSimioni niiza ilina nilakwe i lulya ingi Petro. ");
INSERT INTO isn_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ukuligitya u lukani kitalako mu uwu ukugunika uewe ni ito nilako lihi.” ");
INSERT INTO isn_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nai nandilye kuligitya nienso, Ng'wau Ng'welu wakiza migulya ao anga kitaitu u ng'wandyo. ");
INSERT INTO isn_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nkimbukile i makani a Mukulu, nai uligitile, “uYohana ai wogilye ku mazi, kuiti mukoja ku Ng'wau Ng'welu.” ");
INSERT INTO isn_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Hangi anga Itunda upumilye isongelyo anga nai ukinkiiye usese nai kumukuiye u Mukulu uYesu Kristo, unene ingi nyenyu, kina nihume kumukingila Itunda? ");
INSERT INTO isn_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nai akija imakani aya, shanga ikasusha, ila akamulumbiilya Itunda nu kuligitya, Itunda upumilye ila itunu kunsoko ni awa anyaingu ga.” ");
INSERT INTO isn_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Uugwa ahuiili naza u lwago ai landiiye mu nsha ang'wa Stephano ai asapatie kupuma ku Yerusalemu- ahuiili awa akalongola kaheelu, kupikiila ku Foinike, Kipro ni Antiokia. Ai a atambuie kutula lukani lang'wa Yesu wing'wene ku Ayahudi nu sese ku muya nuili wihi. ");
INSERT INTO isn_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Kuiti ang'wi ao ingi antu kupuma ku Kipro ni Krene, ai azile ku Antiokia nu kuligitya ni Ayunani nu kumutanantya uMukulu uYesu. ");
INSERT INTO isn_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nu mukono nua Mukulu ai watulaa palung'wi ni enso, ni antu idu akahuiila nu kumupilukila uMukulu. ");
INSERT INTO isn_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Makani ao akapika mu akutwi ni i tekeelo nila ku Yerusalemu; hangi akamulagiilya uBarnaba walongole kupikiila ku Antiokia. ");
INSERT INTO isn_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nai wakapembya nu kihenga i ipegwa niang'wa Itunda ai wiloile; nu kua kinyila ihi kusaga nu Mukulu mu nkolo niao. ");
INSERT INTO isn_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ku nsoko ai watulaa muntu mukende hangi wizuiwe nu Ng'wau Ng'welu nu u huiili ni antu idu akongeeleka mu Mukulu. ");
INSERT INTO isn_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Panyambele, uBarnaba ai ulongoe ku Tarso kumihenga uSauli. ");
INSERT INTO isn_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nai wakamulija, akamuleta ku Antiokia. Ikatula ku ng'waka wihi akilundiila palung'wi ni itekeelo nu kuamanyisa antu idu. Ni amanyisigwa akitangwa akristo ku nkua a ng'wandyo uko ku Antiokia. ");
INSERT INTO isn_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Nu mu mahiku aya anyakidagu akasima kupuma ku Yerusalemu kupikiila ku Antiokia. ");
INSERT INTO isn_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ung'wi ao ingi Agapo uu lina lakwe, akimika aze ulagiiwe nu Ng'wa Ngwelu kina nzala ntaki ikupumila mu unkumbigulu wihi. Iki ai kipumie itungo nula mahiku ang'wa Klaudio. ");
INSERT INTO isn_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ku lulo, amanyisigwa, kila ung'wi nai ukendepilwe. ai alamue kutwala u aiilya ku anyandugu niakoli ku Uyahudi. ");
INSERT INTO isn_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ai itumile iti; Ai atumile i mpia ku mukono wan'gwa Barnaba nu Sauli. ");
INSERT INTO isn_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Itungo nilanso mutemi uHerode wakagoola u mukono nuakwe ku ang'wi a awo niapumile mu milundo iti kuaja. ");
INSERT INTO isn_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Akamubulaga uYakobo muluna wang'wa Yohana ku mpanga. ");
INSERT INTO isn_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ze yakilaa kihenga kina ia loile i Ayahudi, akamuamba nu Petro hangi. Iki ai katulaa itungo nila mikate nishanga i gahiigwe. ");
INSERT INTO isn_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Nai wamuamba, akamuika mu kadulumu nu kuika madale anne a asikali iti kumusunja, ai usigiie kumutwala ku antu ze yakilaa u luhiku nula kusupya. ");
INSERT INTO isn_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","uPetro wakaikwa mu kadulumu, kuiti i malompi akitung'wa ku ngulu ni ilundo ku nsoko akwe kung'wa Itunda. ");
INSERT INTO isn_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Utiku ze ikili uHerode wakili kulongola kumupumya, Utiku nuanso uPetro ai watulaa ulae pakati a asikali abiili, waze utungilwe ni minyororo i biili, ni asunja ntongeela a mumpita ai atulaa akusunja i kadulumu. ");
INSERT INTO isn_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Goza, u malaika nua Mukulu kupumpugiilya wakamupumila nu welu ukelya mukati. Akamukua uPetro mu lubalu nu kumuusha wazeligitya, “Kaya uka.” uugwa i minyororo nai watulaa utungilwe ikatunguka kupuma mu mikono akwe. ");
INSERT INTO isn_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","uMalaika akamuila, “Tugala i ang'wenda ako hangi tugala i ilatu niako.” uPetro akituma uu. uMalaika akamutambuila, Tugala u ng'wenda nuako hangi untyate.” ");
INSERT INTO isn_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Iti gwa uPetro akamutyata uMalaika nu kupuma kunzi. Shanga ai uhuiie nai kitumilwe nu Malaika anga ize ka tai. Ai usigile ukihenga muloto. ");
INSERT INTO isn_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ze yakilaa kukila i sunjo nila ng'wandyo nili nila kabiili, akapika mu mumpita nua shuma nua kingiilila kulongola mu kisali, ukaluguka u wenso ku nsoko ao. Akapuma kunzi akasima mu isali, nkua uMalaika akamuleka. ");
INSERT INTO isn_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","uPetro nai wakilinga, akaligitya, “Itungili nahuiila kina uMukulu aza umulagiiye umalaika nuakwe iti kumpumya mu mikono ang'wa Herode; nu ku masigo a antu idu ni a Ayahudi.” ");
INSERT INTO isn_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ze yakilaa kulinga aya, wakiza mu ito nilang'wa Mariamu nyinya nuakwe uYohana niiza Marko; Akristo idu ai ilundiie akulompa. ");
INSERT INTO isn_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Nai wakapindula pa mumpia nua kukingila, munyamulimo ung'wi munaanso nuitangwaa Roda wakapembya kulugula. ");
INSERT INTO isn_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nai wakalinga ingi luli lang'wa Petro, ku ulowa akaleng'wa ku ulugula u mumpita; badala akwe akamanka mukati a shumba; nu kuapikilya kina uPetro wimikile ntongeela a mumpita. ");
INSERT INTO isn_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Iti gwa, Akaligitya kitalakwe, “Uewe wi muhali” kuiti ai ukomangiie kina itai ingi ng'wenso. Akaligitya “Uyu ingi malaika nuakwe.” ");
INSERT INTO isn_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Kuiti uPetro ai ulongolekile kupindula, hangi nai alugue u mulango, akamihenga nu kukuilwa nanguluu. uPetro aka akilaja ku mukono ihi twii nu kuatambuila kinya uli uMukulu naza umupumilye kupuma mukadulumu. wakaligitya. ");
INSERT INTO isn_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Apikilyi i makani aya uYakobo ni aluna akwe.” Uugwa akahega akalongola nkika ingiiza. ");
INSERT INTO isn_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nai ikatula mung'wi, ikatula nu ukia ukulu kati a asikali, kutulikana ni naikipumie kung'wa Petro. ");
INSERT INTO isn_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ze yakilaa u Herode kumuduma hangi shanga wakamihenga wakaakolya i asunja nu kulagiilya abulagwe. Akalongola kupuma ku Uyahudi nu kupikiila ku Kaisaria nu kikie kuko. ");
INSERT INTO isn_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","uHerode ai watulaa ni ikuo migulya a antu a Tiro ni Sidoni. Akalongola ku palung'wi kitalakwe. Akatula ni kihumbashuya nu Blasto mu ailyaa nua mutemi, iti wa a aiilye. Uugwa akalompa u ulyuuku, ku nsoko ihi ao ai isingiiye indya kupuma mi ihi a mutemi. ");
INSERT INTO isn_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Luhiku nai lusigiiwe uHerode ai utugae ang'wenda a kitemi nu kikie mi ituntu ni lakwe nila kitemi, nu kuatanantilya. ");
INSERT INTO isn_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Antu akakua iyogo, “Ulu ingi luli lang'wa Itunda iti shanga luli lang'wa bina adamu!” ");
INSERT INTO isn_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Itungo kupumpugiilya umalaika akamukua, ku nsoko ai watulaa shanga uminkiiye Itunda ikulyo; akaligwa ni makindi nu kusha. ");
INSERT INTO isn_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Kuiti lukani lang'wa Itunda likakula nu kusapatila. ");
INSERT INTO isn_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ze yakilaa u Barnaba nu Sauli kukondeelya u uailya nuao akapuma pang'wanso akasuka ku Yerusalemu, akamuhola nu Yohana naiza i lina nila kulelwa ingi Marko. ");
INSERT INTO isn_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Itungili mi itekeelo nila ku Antiokia, ai akoli ang'wi a anyakidagu ni a ng'walimu. Ai atulaa Barnaba, Simioni (nai witang'waa Nigeri), Lukio nua ku Krene, Manaeni (muluna ni shanga nua sakami nuang'wa Herode mutongeeli nua mukoa), nu Sauli. ");
INSERT INTO isn_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Nai atulaa akumukulya uMukulu nu kudila kulya, uNg'wau Ng'welu ai uligitilye, “Nkomatuilyi kumpelo uBarnaba nu Sauli, itume u mulimo naza ni itangie” ");
INSERT INTO isn_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ze yakilaa i itekeelo kudila kulya, kulompa, nu kuika i mikono ao migulya a antu awa, aka aleka alongole. ");
INSERT INTO isn_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ku lulo uBarnaba nu Sauli ai amukuiye u Ng'wau Ng'welu nu kusima kutunga ku Seleukia; Kupuma kung'wanso ai atungile u muhinzo mu luzi kutunga i kizonzo nika Kipro. ");
INSERT INTO isn_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Nai akatula mu kisali nika Salami, Ai alutanantilye u lukani nulang'wa Itunda mu matekeelo a Ayahudi. Ai atulaa palung'wi ga nu Yohana Marko anga muailya nuao. ");
INSERT INTO isn_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Nai akalongola mu kizonzo kihi kupikiila ku Pafo, ai ahangile muntu nua kituunga mulogi, Muyahudi munyakidagu nua uteele, naiza i lina nilakwe ai latulaa Bar Yesu. ");
INSERT INTO isn_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","uMulogi uyu ai wihanguie nu Lawi Sergio Paulus, nai watulaa muntu munyamahala. Muntu uyu ai uanile uBarnaba nu Sauli, ku nsoko ai uloilwe kija u lukani nulang'wa Itunda. ");
INSERT INTO isn_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Kuiti Elima “uyo u mulogi” (iti uu i lina nilkwe nai limpyanigwe) ai ua kingie, ai ugemile kumupiula uyo u liwali wapume mu uhuiili. ");
INSERT INTO isn_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Kuiti uSauli nai witangwa Paulo, ai watulaa wizuigwe u Ng'wau Ng'welu, akamukunkuila i miho ");
INSERT INTO isn_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","nu kuligitya “Uewe ng'wana nua mulugu, wizuigwe ni mpyani yihi nia uteele nu unyeku. U ewe ingi wi mulugu nua kia mpyani nia tai ane. Shanga ukuleka kuipiula i nzila nia Mukulu, ni igolokile, itii ukuhuma? ");
INSERT INTO isn_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","“Itungili goza, u mukono nua Mukulu ukoli migulya ako, hangi ukutula wi mupoku. Shanga ukihenga ilyoa ku itungo” nkua ing'wi ikunguguu ni kiti ai igwie migulya a Elimas; akandya kupilima papo wazelompa antu amutongeele kumuamba u mukono. ");
INSERT INTO isn_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ze yakilaa u liwali kihenga nai kipumie, ai uhuiie, ku nsoko ai ukuiwe ku umanyisigwa kutula Mukulu. ");
INSERT INTO isn_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Itungili uPaulo ni ahumbauya akwe ai alongoe muhinzo mu mazi kupuma ku Pafo hangi akapika ku Perge mu Pamfilia. Kuiti uYohana ai ua lekile nu kusuka ku Yerusalemu. ");
INSERT INTO isn_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","uPaulo ni ahumbauya akwe ai atungile u muhinzo kupuma ku Perge nu kupika ku Antiokia a ku Pisidia. Uko ai alongoe mi itekeelo luhiku nula kusupya nu kikie pihi. ");
INSERT INTO isn_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ze yakilaa kusoma i ilagiilyo nu unyakidagu, atongeeli ni itekeelo ai ualagiiye utung'waa wazeligitya, “Anya ndugu, anga ize mukete u utuung'wa nua kuhumya insula antu apa, muligitye.” ");
INSERT INTO isn_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ku lulo uPaulo ai wimikile nu kuanyansuila u mukono; ai uligitilye, “Itunja a ku Israeli nu nyenye ni mimukulya Itunda, tegeelyi. ");
INSERT INTO isn_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Itunda nua awa i antu nia Israeli ai uaholanilye i a tata itu nu kuazipya antu idu nai ikie mi ihi a Misri, nu ku mukono nuakwe kunyansulwa ai uatongee kunzi akwe. ");
INSERT INTO isn_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ku myaka makumi anne ai uagigimiiye mi ibambazi. ");
INSERT INTO isn_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ze yakilaa kumabipya i maingu mutandatu mi ihi a Kanaani, ai uinkiiye i antu itu ihi ao ku usali. ");
INSERT INTO isn_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Maintu aya ihi ai apumie ikilo i myaka magana anne ni makumi a taano. Ze yakilaa i intu izi yihi, Itunda ai uinkiiye alamuli kupikiila uSamweli munyakidagu. ");
INSERT INTO isn_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ze yakilaa aya, antu ai alompile u mutemi, iti Itunda ai uinkiiye uSauli ng'wana wang'wa Kushi, muntu nua ndugu ang'wa Benjameni, kutula mutemi ku myaka makumi anne, ");
INSERT INTO isn_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Uugwa ze yakilaa Itunda akamuheja mu utemi akamunyansula uDaudi kutula mutemi nuao. Ai ituile ingi kutula uDaudi kina Itunda ai uligitilye, 'Namulijaa uDaudi ng'wana nuang'wa Yese kutula muntu nuiloeigwe ni nkolo ane; naiza ukituma kila ikintu nikindoile,' ");
INSERT INTO isn_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kupuma mu ndugu a muntu uyu Itunda umiletee i Israeli muguni, uYesu, anga nai ulagile kituma. ");
INSERT INTO isn_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ili landiiye kupumila, ze ikili uYesu kupembya, uYohana ng'wandyo ai utanantilye wogigwa nua kila itunu ku antu ihi nia Israeli. ");
INSERT INTO isn_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Nu ng'wenso uYohana nai wakatula ukumailya mulimo nuakwe, ai uligitilye, 'Musigile unene ni nyenyu? unene shanga ingi uyo. Kuiti tegeelyi, nupembilye kituli kane, nimugila u uhumi nua kutolya i ilatu nia migulu akwe,' ");
INSERT INTO isn_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Anyandugu, Ana andugu ang'wa Abrahamu, ni awo naza mu kati anyu mi mipoelya Itunda, ingi ku nsoko itu kina ikani nila ugunwa lilagiigwe. ");
INSERT INTO isn_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ku awo ni ikie ku Yersalemu, ni atemi ao, shanga ai amulingile ku kulu kuulu, ni ang'wi shanga ai alulingile u lukani nula anyakidagu naza lisong'wa kila luhiku nula kusupya; ku lulo ai apikiiye u lukani nula anyakidagu ku kumulamula insha uYesu. ");
INSERT INTO isn_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Anga itule shanga ai aligilye i nsoko ni nziza ku nsha mukati akwe, ai amulompile uPilato wamubulage. ");
INSERT INTO isn_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Nai akamala imakani ihi nai akilisigwe kutula nuanso, ai amusimilye kupuma mikota nu kumulalya mu kibiila. ");
INSERT INTO isn_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Kuiti Itunda akamiusha kupuma mu ashi, ");
INSERT INTO isn_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ai wigeelekile ku mahiku idu ku awo nai alongoe palung'wi nu ng'wenso kupuma ku Galilaya kulongola ku Yerusalemu, Antu awa itungili ingi akuiili nia antu. ");
INSERT INTO isn_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Iti gwa ku umuletela nkani ni nkende kutula ilago nai inkiigwe i isekulu itu. ");
INSERT INTO isn_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Itunda ai uikile imalago aya kitaitu, ana ao, mu nilanso ai umiukilye uYesu nu kumususha hangi mu upanga. Ili ga likilisigwe mu malumbiilyo a kabiili; 'Uewe ingi ng'wana nuane, lelo natulaa ni Tata nuako,' ");
INSERT INTO isn_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ga ni kutula i tai ingi kina ai umiukilye kupuma kuashi iti kina muili nuakwe uleke kubipa, uligitilye iti; 'Nikakinkiilya u welu nu ukende kulu kuulu nuang'wa Daudi.' ");
INSERT INTO isn_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Iyi yiyo nsoko waligitya ga mu malumbiilyo ni ma ngiiza, 'Shanga ukulekela u ng'welu nuako kihenga i kiolu.' ");
INSERT INTO isn_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ku nsoko ze yakilaa u Daudi ku uaiilya u ulowa nuang'wa Itunda mu ulelwa nuakwe, ai ulae, akalalikigwa palung'wi ni a tata akwe, hangi ai uihengile u ubipigwa. ");
INSERT INTO isn_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Kuiti nai wiukigwe nu Itunda shanga ai uihengile u ubipigwa. ");
INSERT INTO isn_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Iti gwa ni ilingike kitalanyu, anya ndugu, ku kiila muntu uyu, ulekelwa nua milandu watanantigwa. ");
INSERT INTO isn_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ku nuanso kila nu uhuiie wia iligwaa tai ane ni makani ihi niiza ilagiilyo nilang'wa Musa shanga ai lizee inkiilya i tai ane. ");
INSERT INTO isn_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Iti gwa ila tuli miakendegeeli kina i kintu nai akiganue i anyakidagu kileke kupumila kitalanyu; ");
INSERT INTO isn_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Goza, unye adi ni mimelaa, hangi mende mukuilwe hangi mende mulimiligwe; ku iti kituma u mulimo mu mahiku anyu, Mulimo niiza shanga muhumile ku uhuiila, anga ga nu muntu wikumuganuila.” ");
INSERT INTO isn_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Matungo uPaulo nu Barnaba nai akahega, antu aka alompa aligitye i makani aya luhiku nula kusupya nu luzile. ");
INSERT INTO isn_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Matungo ianza nili tekeelo nai likaula, Ayahudi idu ni aokole akomu ai a atyatile uPaulo nu Barnaba, naza aligitilye ni enso hangi ai a asamiiye alongole mu ukende nu ang'wa Itunda. ");
INSERT INTO isn_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Luhiku nula kusupya nai lutyatile, pakupi kisali kihi ai kilingiie kija u lukani lang'wa Itunda. ");
INSERT INTO isn_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ayahudi nai akihenga iumbi, ai izuiwe nu wilu nu kuligitya makani nai akingie i intu nai itambuwe nu Paulo hangi ai amutukie. ");
INSERT INTO isn_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Kuiti uPaulo nu Barnaba ai atambue ku ukamatiku nu kuligitya, “Ai yatulaa ingulu kina lukani nu lang'wa Itunda luganulwe hanza kitalanyu. Kunsoko mukulu suntiilya kuli kupuma kitalanyu nu kiona kina shanga muhiiye kutula nu upanga nua kali na kali, kendegeeli kuapilukila i anyaingu. ");
INSERT INTO isn_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Anga niiza uMukulu ukulagiiye, azeligitya, 'Numuikile unyenye anga welu ku antu a ingu, kina mulete u ugunwa ku nkika yihi ni yihi.” ");
INSERT INTO isn_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Anya ingu na akija ili, ai iloile nu kulu lumbiilya u lukani nula Mukulu. Idu nai aholanigwe ku upanga nua kali na kali ai ahuiie. ");
INSERT INTO isn_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Lukani nula Mukulu ai lenee ihi ihi ");
INSERT INTO isn_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Kuiti Ayahudi ai a asingilye nai ipumilye ni asungu ni angulu, ga ni atongeeli a kisali. Aya ai akinyie u lwago kung'wa Paulo nu Barnaba hangi ai a agumile kunzi a mimbi nia kisali. ");
INSERT INTO isn_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Kuiti uPaulo nu Barnaba ai akununtile u lunkundi nula migulu ao. Uugwa akalongola mu kisali nika Ikonia. ");
INSERT INTO isn_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ni amanyisigwa ai izuiwe nu ulowa palung'wi nu Ng'wau Ng'welu. ");
INSERT INTO isn_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ikapumila mukati a Ikonia kina uPaulo nu Barnaba ai ingie palung'wi mukati i tekeelo nila Ayahudi nu kutambula kinya iti idale ikulu nila antu a Ayahudi ni Ayunani nai ahuiie. ");
INSERT INTO isn_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Kuiti Ayahudi nishanga ai akuiye ai a akinyiie i mahala i anyaingu nu kuatenda kutula abii kua anya ndugu. ");
INSERT INTO isn_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ku lulo ai ikiie kuko ku itungo ilipu, azeligitya ku ukamatiku ku gulu nia Mukulu, kunu wazepumya u kaminkiilyi kutula lukani nula ukende nuakwe. Ai witumile iti ku kupumya ilingasiiyo nu ukuilwa yitung'we ku mikono a Paulo nu Barnaba. ");
INSERT INTO isn_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kuiti kianza kikulu nika kisali kikagalanuka; ang'wi a antu akatula palung'wi ni Ayahudi, ni ang'wi palung'wi ni itumi. ");
INSERT INTO isn_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Matungo anyaingu ni Ayahudi nai agemile kuapema i atongeeli ao kuatendeela ubi nu kuatulanga i magwe uPaulo nu Barnaba, ");
INSERT INTO isn_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Akalilinga nilanso nu kumankiila mu isali nia Likaonia, Listra ni Derbe ni nkika ni ipilimikiiye pang'wanso, ");
INSERT INTO isn_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","nu kung'wanso ai atanantilye i nkani niza. ");
INSERT INTO isn_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Nu kung'wanso ku Listra ai ukoli nu muntu ung'wi nai wikiie, ai mugila ingulu mu migulu akwe, mulema kupuma munda ang'wa nyinya nuakwe, wakili wakaye kugenda. ");
INSERT INTO isn_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","uMuntu uyu ai umigulye uPaulo ukuligitya. uPaulo akamukunkuila imiho nu kumihenga kina ai watulaa nu uhuiili nua kugunwa. ");
INSERT INTO isn_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Iti gwa ai ulugitilye kitalakwe ku luli nula migulya, “Imike ku migulu ako” Nu muntu uyo ai uputile migulya nu kandya kugenda. ");
INSERT INTO isn_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Iumbi nai lihengile nai ukitumile uPaulo, ai anyansue i nduli niao, azeligitya mu luli nula Kilikaonia, “alungu akusimiila ku mpyani a ki ana adamu.” ");
INSERT INTO isn_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ai amitangile u Barnaba “Zeu,” nu Paulo “Herme” ku nsoko ai watulaa mutambuli nu mukulu. ");
INSERT INTO isn_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","uKuhani nua Zeu, naiza itekeelo nilakwe ai latulaa kunzi a kisali, ai uletile muzagamba nua ng'ombe nu muntungi nua ulua kupikiila mu mumpita nua kisali, uNg'wenso ni iumbi ai aloilwe kupumya isongelyo. ");
INSERT INTO isn_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kuiti i itumi, uBarnaba nu Paulo, nai akalija ili, akatamulania i ang'wenda ao nu ku ukau akalongola kunzi mi iumbi, azelila ");
INSERT INTO isn_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","nu kuligitya, “U nyenye antu, ku niki mukituma imakani aya? Nu sese ga ki ana adamu ni akete i kiwai anga ni kanyu Ku umuletela nkani ni nkende, kina mupiluke kupuma mu intu izi ni shanga izepile nu kumutunga Itunda nuili mupanga, nai u umbile ilunde, ihi nu luzi ni kila intu ni imoli. ");
INSERT INTO isn_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Mu matungo nakiile, ai ualekee i anyaingu kugenda mu nzila niao akola. ");
INSERT INTO isn_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Kuiti ikili, shanga ai uhengile bila mukuili, mu nilanso ai witumile iziza hangi akainkiilya i mbula kupuma kilunde ni matungo a maogola, wazeizulya i nkolo nianyu ku ndya nu ulowa,” ");
INSERT INTO isn_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ga nu ku makani aya, uPaulo nu Barnaba ku lwago ai aligiiye iumbi ku apumilya isongelyo. ");
INSERT INTO isn_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Kuiti ang'wi a Ayahudi kupuma ku Antiokia nu ku Ikonia ai azile kulipema i umbi. Akamukua magwe uPaulo nu kumukweha kupika kunzi a kisali, aze asigile aiwatulaa wakuza. ");
INSERT INTO isn_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ga ni iti amanyisigwa ai atulaa imikile pakupi nu ng'wenso, ai u ukile, akingila mu kisali. Luhiku nula ka biili, akalongola ku Derbe nu Barnaba. ");
INSERT INTO isn_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ze yakilaa kumanyisa nkani ninza mu kisali ni kanso nu kuazipya amanyisigwa idu, akasuka ku Listra, kupikiila ku Ikoniamu, ni kupikiila ku Antiokia. ");
INSERT INTO isn_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ai alongolekile kukaminkiilya u umi nua amanyisigwa nu kuakinyila kulongoleka mu uhuiili, akaligitya, “Kusinja kingile mu utemi nuang'wa Itunda ku kiila lwago lidu.” ");
INSERT INTO isn_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Nai atula a ahola ku nsoko ao anyampala a kila milundo nila ahuiili, hangi aze atulaa alompaa nu kudila kulya, ai ainkiiye ku Mukulu, naiza i enso amuhuiie. ");
INSERT INTO isn_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Uugwa ai akiile mu Pisidia, ai apikile mu Pamfilia. ");
INSERT INTO isn_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Matungo nai atambue i makani mu Perga, ai asimile kulongola ku Atalia. ");
INSERT INTO isn_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Kupuma kuko ai anankie meli kupikiila ku Antiokia nize atulaa ipumya ku ukende nuang'wa Itunda ku nsoko a mulimo niize itungili ai atulaa aukondeelya. ");
INSERT INTO isn_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Nai akapika uko ku Antiokia, nu ki kilingiila u milundo nua palung'wi, akapumya i mpola nia makani naiza Itunda witumile kitalao, ni kinya nai ualuguie u mumpita nua uhuiili ku antu ni anyaingu. ");
INSERT INTO isn_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ai ikie ku itungo ilipu ni amanyisigwa. ");
INSERT INTO isn_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Antu a ki tuunga ai asimile kupuma ku Uyahudi nu kuamanyisa i aluna, azeligitya, “angamuhite kutalwa i kidamu anga ntendo ni ang'wa Musa, shanga muhumile kugunwa.” ");
INSERT INTO isn_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Matungo uPaulo nu Barnaba nai atulaa nu wikungumi nu witambulyi palung'wi ni enso, anyandugu ai alamue kina uPaulo, Barnaba ni auya kituunga alongole ku Yerusalemu ku itumi ni anyampala ku nsoko a ikolyo ili. ");
INSERT INTO isn_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kululo, kulagiiligwa kitalao ni itekeelo, ai akiie ku Foenike ni Samaria azetanantya kupiulwa insula ku anyaingu. Ai aletile ulowa ukulu ku anya ndugu ihi. ");
INSERT INTO isn_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Nai akapembya ku Yerusalemu, ai asingiiigwe ni itekeelo ni itumi ni anyampala, hangi ai apikilye i mpola nia makani ihi naiza Itunda witumile palung'wi ni enso. ");
INSERT INTO isn_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Kuiti i antu akituunga nai ahuiie, nai akoli mi idale nila Afarisayo, ai imikile nu kuligitya, “ingi ingulu kuatwala ikidamu nu kualagiilya aliambe ilagiilyo ni lang'wa Musa.” ");
INSERT INTO isn_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Iti gwa i itumi ni anyampala ai imikile palung'wi kulisiga ikolyo ili. ");
INSERT INTO isn_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ze yakilaa u witambulyi ulipu, uPetro ai wimikile nu kuligitya kitalao, “Anya ndugu mulingile kina itungo iziza nilakilaa Itunda ai witumile uholania mukati anyu, kina ku mulomo nuane Anyaingu igiilye u lukani nula nkani ninza, nu kuhuiila. ");
INSERT INTO isn_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Itunda, nuilingile i nkolo, ukuiie kitalao, ukuinkiilya uNg'wau Ng'welu, anga nai witumile kitalanyu; ");
INSERT INTO isn_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","hangi shanga ai uzipilye utemanuli kati itu ni enso, waze yituma i nkolo niao nziza ku uhuili. ");
INSERT INTO isn_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ku lulo ku niki mukumugema Itunda kina muikile kinyuli migulya a nkingo nia amanyisigwa naiza ga i atata itu ang'wi u sese shanga ai kuhumile ku gigimiilya? ");
INSERT INTO isn_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Kuiti ku huiie kina ku ugunwa ku ukende nua Mukulu uYesu, anga nai atulaa.” ");
INSERT INTO isn_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","uMilundo wihi ai ukilagilye nai atulaa akumutegeelya uBarnaba nu Paulo nai atulaa akupumya i mpola nia ilingasiilyo nu ukuilwa naiza Itunda ai witumile palung'wi ni enso kati a antu a anyaingu. ");
INSERT INTO isn_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Nai akaleka kuligitya, uYakobo ai usukiiye wazeligitya, “Anyandugu ntegeelyi. ");
INSERT INTO isn_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","uSimioni waganula iti hanza Itunda ku ukende ai ua aiye i anyaingu iti kina wiligilye kupuma kitalao antu kunsoko a lina nilakwe. ");
INSERT INTO isn_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","iMakani a anyakidagu igombilye ni ili anga nilikilisigwe. ");
INSERT INTO isn_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Ze yakilaa i makani aya nikasuka kukizenga hangi ikitala nikang'wa Daudi, naikagwizaa pihi; nikanyansula nu ku sukiilya ubipigwa nuakwe, ");
INSERT INTO isn_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","iti kina antu nai asagiie amudume uMukulu, palung'wi ni antu a ingu nai itangilwe kulina nilane.' ");
INSERT INTO isn_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Iti uu nuiligityaa u Mukulu nai witumile i makani aya nakumukile puma ikali nia kali. ");
INSERT INTO isn_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Iti gwa, u usiji nuane ingi, kina kuleke kuinkiilya ulwago i antu i anya ingu niakumupilukila Itunda. ");
INSERT INTO isn_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Kuiti kukilise kitalao kina ihuje nu ubipigwa nua adudu, nsula nia usambo, hangi ni igogilwe, ni sakami. ");
INSERT INTO isn_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kupuma u utugwaa nua anyampala akoli antu mu kila isali ni itanantya nu kumusoma u Musa mu matekeelo kila luhiku nula kusupya.” ");
INSERT INTO isn_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ku lulo yikigeeleka kutula ia loeeye i itumi ni anyampala, palung'wi ni itekeelo lihi kumuholania uYuda nai witangwaa Barnaba, nu Silas nai atulaa atongeeli i tekeelo, nu kualagiilya ku Antiokia palung'wi nu Paulo nu Barnaba. ");
INSERT INTO isn_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ai akilisilye iti, “Itumi, anyampala ni anya ndugu, ku anya ndugu a anyaingu niakoli ku Antiokia, Shamu ni Kilikia, Milamu. ");
INSERT INTO isn_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ai kijaa kina antu a kituunga naza shanga ai kuinkiiye ilagiilyo nilanso, ai apumaa kitalanyu hangi akumajaa ku umanyisigwa nuiletaa u lwago mu umi nuanyu. ");
INSERT INTO isn_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ku lulo yigeeleka ikende kitaitu kihi kuholania antu nu kualagiilya kitalanyu palung'wi ni alowa itu Barnaba nu Paulo, ");
INSERT INTO isn_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","antu nai agilye u likalo nulao ku nsoko a lina nila Mukulu uYesu Kristo ");
INSERT INTO isn_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ku lulo kamulagiilya uYuda nu Sila, akumutambuila makani yao yaayo. ");
INSERT INTO isn_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ku nsoko ai yigeeleka ikende ku Ng'wau Ng'welu nu kitaitu, Kuleka kuika migulya anyu muligo ukulu kukila imakani aya naiza a kusinja; ");
INSERT INTO isn_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Kina mupiluke kupuma mu intu ni ipumigwa ku adudu, sakami intu nia kugogwa, nu usambo. Anga miki ika kuli ni izi, ikutula ikende kitalanyu. Mu lamu.” ");
INSERT INTO isn_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Iti gwa nai asapatiligwa, ai asimiie ku Atiokia; ze yakilaa kilingiila u milundo palung'wi, ai ainkiiye ibada. ");
INSERT INTO isn_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Nai akatula asomaa, ai iloile kunsoko a kukinyilwa inkolo. ");
INSERT INTO isn_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","uYuda nu Sila, ni anyakidagu, ai a akinyie inkolo i aluna ku nkani idu nu kuakinyila ingulu. ");
INSERT INTO isn_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ze yakilaa kikie itungo nila kituunga kuko, ai asapatiigwe ku ulyuuku kupuma ku anya ndugu ku awo nai a alagiiye. ");
INSERT INTO isn_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","(Kuiti ai yigeelekile ikende uSila kusaga kuko) ");
INSERT INTO isn_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Kuiti uPaulo ni auya ai ikie ku Antiokia palung'wi ni auya idu, naize akumanyisa nu kutanantya lukani nula Mukulu. ");
INSERT INTO isn_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ze yakilaa mahiku kituunga uPaulo ai uligitilye kung'wa Barnaba, “Ni kusuke itungili nu kuagendeela i aluna mu kila kisali naikatanantya u lukani nula Mukulu, nukuihenga ni ili. ");
INSERT INTO isn_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","uBarnaba ai utakile ga nu kumuhola palungwi nienso uYohana nai witangwaa Marko. ");
INSERT INTO isn_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Kuiti uPaulo ai usigile shanga iza kumuhola uMarko, nai ualekile uko ku Pamfilia hangi shanga ai ulongolekile ni enso mu mulimo. ");
INSERT INTO isn_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Uugwa pang'wanso ikapumila wikungumi ukulu ku lulo ai atemanukile. nu Barnaba akamuhola uMarko nu kulongola muhinzo ku meli kupikiila ku Kipro. ");
INSERT INTO isn_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Kuiti uPaulo ai umuhole uSila nu kuhega, ze yakilaa kinkiiligwa ni anya ndugu mu ukende nua Mukulu. ");
INSERT INTO isn_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Hangi ai ulongoe kukiila ku Shamu nu ku Kilikia, waze makomisa i matekeelo. ");
INSERT INTO isn_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","uPaulo nai wakapembya ga nu ku Derbe nu ku Listra; hangi goza, pang'wanso ai ukoli nu mumanyisigwa nuitangwa Timotheo, ingi muhumba nai utugilwe nu nyinya nua kiyahudi naiza ingi mu huiili nu tata nuakwe ingi Mugriki. ");
INSERT INTO isn_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Antu aku Listra ni Ikonia ai amukuiie iziza. ");
INSERT INTO isn_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","uPaulo ai umuloilwe akuile iti muhinzo nu ng'wenso, uugwa akamuhola ku mutwala i kidamu ku nsoko a Ayahudi nai akoli uko kuiti ihi ai amulingile kina u tata nuakwe ingi Mugriki ");
INSERT INTO isn_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Nai akatula alongoe ai akiile mu isali nu kupumya i malago ku matekeelo iti kina i malago nanso ai akilisigwe ni itumi ni anyampala uko ku Yerusalemu. ");
INSERT INTO isn_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Iti gwa i matekeelo aka komisigwa ku u huiili nao nai ahuiie akongeeleka ku ngele kila luhuku. ");
INSERT INTO isn_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","uPaulo ni auya akalongola ku Filigia ni Galilaya, kuiti u Ng'wau Ng'welu nuang'wa Itunda ai uagiiye kutanantya u lukani uko kijimbo nila Asia. ");
INSERT INTO isn_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Nai akahumbeela ku Misia, ai agemile kulongola ku Bithinia, kuiti u Ng'wau Ng'welu nuang'wa Yesu aka agilya. ");
INSERT INTO isn_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ku lulo akakila i Misia akapembya kupikiila kisali nika Troa. ");
INSERT INTO isn_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Muloto ai umupumie uPaulo utiku, ai ukoli muntu nua ku Makedonia wimikile, ukimitanga nu kuligitya “Pembyi mukuaiilye kunu ku Makedonia.” ");
INSERT INTO isn_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","uPaulo nai wakihenga u muloto, itungo ki kizepiilya kulongola ku Makedonia, aze ulingile kina Itunda ai ukitangile kulongola ku atanantilya inkani ninza. ");
INSERT INTO isn_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Iti gwa kikahega kupuma ku Troa, kikalongola kukilinkania ku Samothrake, nu luhiku nai lutyatiie kikapika kisali nika Neapoli. ");
INSERT INTO isn_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kupuma papo kikalongola ku Filipi naza ingi king'wi a kisali nika Makedonia, kisali nikangulu mu wilaya nu uhumi nua Kirumi hangi ki kikie mahiku kituunga. ");
INSERT INTO isn_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Luhiku nula kusupya, aikulongoe kunzi a mumpita ku nzila a mongo, nkinka naiza kusigiie yikatula ni kianza nika kitumila i malompi. Ki kikie pihi nu kuligitya ni ana kisungu nai apembilye palung'wi. ");
INSERT INTO isn_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Musungu ung'wi nuitangwaa Lidia, mugulya nzambarau, kupuma mu kisali nika Tiatira, munya kumikumbikila Itunda, ai ukutegeeye, Mukulu ai umulugue i nkolo akwe nu kuikila ukendegeeli i makani nai atambuwe nu Paulo. ");
INSERT INTO isn_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ze yakilaa kogigwa, ng'wenso ni ito nilakwe lihi, ai ukusingilye wazeligitya “anga ize manihenga kina unene ingi ni muhuiili mu Mukulu, uugwa kumusinja mingile nu kikie kitalane.” Akakusinja nangulu. ");
INSERT INTO isn_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ikatula kina, nai katula kulongoe kianza nika kulompa, munanso ung'wi nai watulaa nu hing'wi nua ulingi akatankana nu sese. ai wimuletela u mukulu nuakwe nsailo idu na kulota. ");
INSERT INTO isn_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Umusungu uyu ai umutyatile uPaulo palung'wi nu sese, akakua iyogo nu kuligitya, “Awa i agoha ingi anyamilimo ang'wa Itunda niiza Mukulu, niakumutanantilya unyenye i nkani nia ugunwa.” ");
INSERT INTO isn_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ai witumile iti ku mahiku idu, kuiti uPaulo waze watakigwa ni ntendo nanso, ai upilukile kinyuma nu kumutambuila u hung'wi, “Ku ulagiilya ku lina nilang'a Yesu umupume mukati akwe.” Nu ng'wenso nkua ing'wi wakapuma nu kumuleka. ");
INSERT INTO isn_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Akulu akwe nai akihenga nia kina isigo nila nsailo niao lahega, ai a ambile uPaulo nu Sila nu kuakweha misoko ntongeela a anya uhumi. ");
INSERT INTO isn_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Nai aka apisha ku a lamuli, ai aligitilye, “Awa agoha ingi Ayahudi hangi akusasha minyomo ukulu mu kisali kitu. ");
INSERT INTO isn_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Akumanyisa makani naiza shanga ilagiilyo usese kumasingiilya ang'wi kumatyata anga Arumi. ");
INSERT INTO isn_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Iumbi lika anyansukila nsuta uPaulo nu Sila nu kuatugula nu kulagiilya anyukwe iboko. ");
INSERT INTO isn_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ze ya kilaa kunyukwa iboko idu, mu kadulumu nu kumulagiilya u asikali nua kadulumu kuansunja ikende. ");
INSERT INTO isn_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ze yakilaa kusingiilya ilagiilyo nilanso, uasikali nua kadulumu ai uagumie mu shumba nika mukati a kadulumu nu kuatunga i migulu ao mu nkika nai uaikile. ");
INSERT INTO isn_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Itungo nila utiku wigingu, uPaulo nu Sila akatula akulompa nu kimba mimbo akumukulya Itunda, kunu ia tungwa auya aze a ategeeye, ");
INSERT INTO isn_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kupumpugiilya, ikapumila itetemeko ikulu nu musingi nua kadulumu ukahingisigwa, i milango a kadulumu ikaluguka, ni minyororo a atungwa ihi ikatoligwa. ");
INSERT INTO isn_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","uMusunja nua kadulumu ai u ukile kupuma mu tulo nu kihenga i milango a kadulumu iluguwe; itigwa wakahola i mpanga nuakwe ndogoelyo ai walowa kibulaga ku nsoko ai usigile i atungwa ihi akondya kutigana. ");
INSERT INTO isn_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Kuiti, uPaulo wakazogolya ku luli lukulu, wazeligitya, “leka kilemaalya ku nsoko kihi kukoli i kianza apa.” ");
INSERT INTO isn_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","uMusunja nua kadulumu ai ulompile i ntala iletwe hangi wakingila mukati a kadulumu ku ukau, wazekagata nu kitumba, waka agwila uPaulo nu Sila, ");
INSERT INTO isn_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","nu kuapumya kunzi a kadulumu nu kuligitya, “Akulu, nitume ntuni ndije ku gunika?” ");
INSERT INTO isn_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ni enso akamutambuila, “Mu huiile uMukulu uYesu nu ewe ukugunika palung'wi ni ito nilako.” ");
INSERT INTO isn_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ai ituntile u lukani nula Mukulu kitalakwe, palung'wi ni antu ihi nia mi ito nilakwe. ");
INSERT INTO isn_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","uMusunja nua kadulumu ai uahoile utiku wuwo nu kuoja nkika nai alemaae, nuanso palung'wi ni antu nia mi ito nilakwe itungo akogigwa. ");
INSERT INTO isn_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Waka aleta uPaulo nu Sila mi ito nilakwe nu kuatengela indya. Nu ng'wenso akatula nu ulowa ukulu palung'wi ni antu a mi ito nilakwe ku nsoko ai amuhuiila Itunda. ");
INSERT INTO isn_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Nai ikatula mung'wi, alamuli ai alagiiye lukani ku uyo u musunja nua kadulumu azeligitya, “Wa alekele i antu awo alongole.” ");
INSERT INTO isn_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","uMusunja nua kadulumu akamupindula uPaulo migulya nkani nianso nia kina, “iAlamuli ai alagiiye lukani ndekele muhege; iti gwa pumi kunzi hangi mulongole ku u lyuuku.” ");
INSERT INTO isn_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Kuiti uPaulo waka aila, “Ai akukuile pi galagalo, antu naza ingi Arumi shanga aku ulamula hangi ai alamue ku ugumila mu kadulumu; halafu itungili aloilwe ku upumya ku kinkunku? Ishi, shanga ikuhumika, Enso akola aze ku upumya nkika apa.” ");
INSERT INTO isn_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","iAsunja aka apindula i alamuli migulya a makani nanso, i alamuli akitumba nangaluu pang'wanso nai akalinga kina uPaulo nu Sila ingi Arumi. ");
INSERT INTO isn_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","iAlamuli akapembya nu kuasinja apume, hangi nai aka apumya kunzi a kadulumu, ai a alompile uPaulo nu Sila apume kunzi a kisali ni kao. ");
INSERT INTO isn_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ku lulo uPaulo nu Sila akapuma kunzi a kadulumu akapembya mi ito nilang'wa Lidia. uPaulo nu Sila nai akaihenga i anya ndugu, ai akinyie inkolo hangi uugwa kuhega mu kisali ni kanso. ");
INSERT INTO isn_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Hangi nai akakila mu isali nia Amfipoli ni Apolonia, ai azile kupikiila kisali nika Thesalonike naza likoli i tekeelo nila Ayahudi. ");
INSERT INTO isn_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Anga ni yili ntendo ang'wa Paulo, wakalongola kitalao, nu ku itungo nila mahiku ataatu nia luhiku nula kusupya ai witambuuye nienso migilya a ukilisigwa. ");
INSERT INTO isn_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ai watulaa uku akunukuilya u ukilisigwa nu kuaganuila kina, ai imutakile uKristo wagishe ni uugwa kiuka hangi kupuma ku ashi. Ai uatambuie, “Uyu uYesu nikumutambuila i nkani niakwe yuyo Kristo.” ");
INSERT INTO isn_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ang'wi nia Ayahudi ai apemekile nu kihanguila nu Paulo nu Sila, palung'wi ni Agiriki akulya Itunda, asungu idu aokole ni idale ikulu nila antu. ");
INSERT INTO isn_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Kuiti ang'wi a Ayahudi ni shanga ahuiie, nai izuiwe nu wilu, ai alongoe ki isoko nu kuahola ang'wi a antu ni abibi, akalundiila iumbi nila antu palung'wi, nu kusasha minyomo mu kisali, uugwa akaligilinkiilya ito nilang'wa Jason, aze aloilwe kua amba uPaulo nu Sila iti kualeta ntongeela ya antu. ");
INSERT INTO isn_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Kuiti nai aka aulya, ai amuambile u Yasoni ni ang'wi a anyandugu auya nu kuatwala ntogeela a aofisa nia kisali, azekua iyogo, “Awa i agoha naza aupiue u unkumbigulu apika kupikiila kunu ga. ");
INSERT INTO isn_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Agoha awa naza asingiigwe nu Yasoni akulitumuila ilagiilyo lang'wa Kaisari, akuligitya ukoli mutemi mungiiza nuitangwaa Yesu.” ");
INSERT INTO isn_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Iumbi ni a ofisa nia kisali nai akija i makani nanso, ai ingiiwe nu mitumbo. ");
INSERT INTO isn_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ze yakilaa kutula akondya kuhola i mpia nia nsailo a usunja kupuma kung'wa Yason ni auya, ai a alekee alongole. ");
INSERT INTO isn_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Utiku nuanso anya ndugu ai amulagiiye uPaulo nu Sila ku Beroya. Hangi nai akapika kung'wanso akalongola mi itekeelo nila Ayahudi. ");
INSERT INTO isn_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Antu awo ai atula akete u ulingi ukulu kukila i antu awo nia ku Thesalonike, ku nsoko ai akete nu ukondaniili nua kusingiilya u lukani ku mahala ao, nu kupukania u ukilisigwa kila mahiku iti kihenga anga ize imakani nai aganuwe uu nili. ");
INSERT INTO isn_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ku lulo idu ao ai ahuiie, aze amoli asungu niakete u upemi ukulu nua Kigiriki ni agoha idu. ");
INSERT INTO isn_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Kuiti Ayahudi nia ku Thesalonike nai akalinga kina uPaulo ukutanantya lukani lang'wa Itunda uko ku Beroya, ai alongoe kuko nu kukinyiila ni uugwa nu kandiilya minyomo ku antu. ");
INSERT INTO isn_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ku ukau, i aluna akamutwala uPaulo ku nzila a luzi, kuiti uSila nu Timotheo akasaga pang'wanso. ");
INSERT INTO isn_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Awo i anya ndugu nai amutwae uPaulo ai alongoe nu ng'wenso kupikiila ku Athene, nai akamuleka uPaulo kuko, ai asingiiye i malagiilyo kupuma kitalakwe kina, uSila nu Timotheo apembye kitalakwe ku ukau ni ihumikile. ");
INSERT INTO isn_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ni itungo nai ualindiie uko ku Athene, nkolo akwe ikatakigwa mukati akwe ku iti nai wihengile i kisali nai kizue i adudu idu. ");
INSERT INTO isn_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Itigwa akitambulya mu itekeelo ni Ayahudi awo nai amukiye Itunda nu ku awo ihi nai utankanile ni enso kila luhiku mi soko. ");
INSERT INTO isn_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Kuiti ang'wi a alingi nia a Aepikureo ni Astoiko akamukungiilya. Ni auya akaligitya, “Ingi ki ntuni ukukiligitya uyu u muligitya nu mudabu? iAuya akaligitya, “Yigeelekile ukutanantya nkani niang'wa Itunda muziila.” ku nsoko ukutanantya nkani yang'wa Yesu nu wiukigwa. ");
INSERT INTO isn_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Akamohola uPaulo nu kumuleta ku Areopago, azeligitya, “Kuhumile kulinga uwu umanyisigwa uziila nuku uligitya? ");
INSERT INTO isn_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ku nsoko ukuleta makani maziila mu akutwi itu. Ku iti kuloilwe kulinga makani aya akete ndogoelyo kii?” ");
INSERT INTO isn_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Ni antu ihi nia ku Athene palung'wi ni aziila ni amoli kitalao, itumila itungo nilao ang'wi mu uligitya nu kutegeelya migulya a ikani ni iziila.) ");
INSERT INTO isn_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ku lulo uPaulo akimika pakati a antu nia ku Areopago nu kuligitya, Unyenye antu aku Athene, kihenga kina ingi antu a ikumbiko ku kila mpyani, ");
INSERT INTO isn_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kuiti mu ukili nua ki talane nu kugoza i intu nianyu nia kipoelya, nihengile makani nakilisigwe mu ling'wi ikumbikilo lanyu, likuligitya “KUNG'WA ITUNDA NI SHANGA UKUMUKILE.” Itigwa, nuanso ni mukumipolya ize shanga mulingile, yuyo niku mupikilya unyenye. ");
INSERT INTO isn_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Itunda nai u umbile ihi ni kila i kintu ni kikoli mukati, kunsoko ingi Mukulu nua ilunde ni ihi, shanga uhumile kikie mu matekeelo nazipigwe ni mikono. ");
INSERT INTO isn_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Hangi shanga wi ailigwa ga ni mikono a ana adamu anga kina uloilwe kintu kitalao, kuiti u ng'wenso mukola wi inkiilya antu upanga ni mihupo ni intu ingiiza yihi. ");
INSERT INTO isn_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ku kiila muntu ung'wi, ai uzipilye u ingu wihi ni antu ni ikiie migulya a usu nui ihi, hangi waka aikilya matungo ni mimbi mu nkika ni ikiie. ");
INSERT INTO isn_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ku iti, atakiwe kumuduma Itunda, ni tai amupikiile nu kumulija, hangi ku kulu kuulu wikutili kuli ni kila ung'wi nu itu. ");
INSERT INTO isn_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ki talakwe kikie, kigendaa nu kutula nu upanga nuitu, anga iti mutungi nuanyu ung'wi nua ilumbiilyo nai uligitilye 'ki atuugwa akwe.' ");
INSERT INTO isn_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ku lulo anga itule usese ingi atuugwa ang'wa Itunda, shanga kutakiwe kusiga kina u itunda ingi anga zahabu, ang'wi shaba, ang'wi magwe, adudu nu sesilwe ku ulingi ni masigo a antu. ");
INSERT INTO isn_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ku lulo, Itunda ai ukilagiiye i matungo ayo na upungu, kuiti itungili ulagiiye antu ihi kila kianza ile itunu. ");
INSERT INTO isn_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Iki ingi ku nsoko uikile luhiku nuika milamula ihi ku tai ane ku muntu naiza ai umuholanilye. Itunda ai upumilye i kulu kuulu na mumtu uyu ku kila muntu pang'wanso nai umiukilye kupuma kuashi. ");
INSERT INTO isn_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ni antu a Athene nai akija inkani nia kiukigwa ku ashi, ang'wi ao akamukuna uPaulo, ila i auya akaligitya, “Ku ukutegeelya hangi ku nkani nia ikani ili.” ");
INSERT INTO isn_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ze yakilaa pang'wanso, uPaulo aka aleka. ");
INSERT INTO isn_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Kuiti ang'wi a antu ai ihanguie nu ng'wenso akahuiila, waze umoli uDionisio Mwareopago, nu musungu nuitangwaa Damari ni auya palungwi ni enso. ");
INSERT INTO isn_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ze yakilaa imakani nanso, uPaulo ai uhegile ku Athene kulongola ku Korintho. ");
INSERT INTO isn_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Uko akamulija Muyahudi nuitangwaa Akwila muntu nua kabila nila Ponto, ung'wenso nu musungu nuakwe nuitangwaa Prisila ai apembilye kupuma uko ku Italia, ku nsoko uKlaudia ai ulagiiye i Ayahudi ihi ahege ku Roma; uPaulo akapembya kitalao; ");
INSERT INTO isn_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","uPaulo akikie nu kituma i milimo ni enso kunsoko nuanso witumaa mulimo nuipyani niyi nao. Enso ai iza azepya mahema. ");
INSERT INTO isn_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","uPaulo akitambulya ni enso mi itekeelo kila luhiku nula kusupya. Ai uapemile i Ayahudi palung'wi ni Agiriki. ");
INSERT INTO isn_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Kuiti uSila nu Timotheo nai akapembya kupuma ku Makedonia, uPaulo ai usuntilwe nu Ng'wau Ngwelu kua kuiila i Ayahudi kina uYesu yuyo Kristo. ");
INSERT INTO isn_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Matungo i Ayahudi nai amukua nu kumukuna, iti uPaulo wikapununta u ng'wenda nuakwe ntongeela ao, nu kuatambuila, “Sakami anyu ni itule migulya a matwe anyu akola; Unene nimugila ikinkwaatya. kupuma itungili nu kulongoleka, kuahanga i anyaingu.” ");
INSERT INTO isn_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Iti gwa akahega kupuma pang'wanso akalongola mi ito nilang'wa Tito Yusto, Muntu nai wimukulya Itunda. Ito nilakwe ai likoli pakupi ni itekeelo. ");
INSERT INTO isn_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","uKrispo, mutongeeli nu itekeelo palung'wi ni antu a mi ito nilakwe akamuhuiila uMukulu. Antu idu nia ku Korintho nai amigulye uPaulo ukuligitya ai ahuiie nu kogigwa. ");
INSERT INTO isn_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","uMukulu akamutambuila uPaulo utiku kukiila ku nzila a muloto, “Leka kogopa, kuiti ligitya hangi leka kukilaga. ");
INSERT INTO isn_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ku iti unene nkoli palung'wi nu ewe, hangi kutili nuikagema kuumela, ndogoelyo nkete antu idu mu kisali iki.” ");
INSERT INTO isn_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","uPaulo akikie kuko ku itungo la ng'waka ung'wi ni myeli mutandatu wazemanyisa lukani nulang'wa Itunda mukati ao. ");
INSERT INTO isn_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Kuiti uGalio nai wakatendwa muhumi nua ku Akaya, Ayahudi ai imikile palung'wi nsuta nu Paulo nu kumutwala ntongeela a ituntu nila ulamuli, ");
INSERT INTO isn_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","aze ligitya, “uMuntu uyu wiapemaa i antu kumukulya Itunda nsuta ni malagiilyo.” ");
INSERT INTO isn_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Matungo uPaulo nai wakatula uloilwe kuligitya, uGalio aka atambuila i Ayahudi, “Unyenye Ayahudi, anga aza itule utumuli ang'wi ubipya, aza izeetula tai kuitumila u mulimo. ");
INSERT INTO isn_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Kuiti ku nsoko ingi makolyo, natulikile imakani ni mina, ni malagiilyo anyu, uugwa lamuli nyenye akola. Unene nimugila insula kutula mulamuli ku nkani nia makani nanso.” ");
INSERT INTO isn_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","uGalio akalagiilya ahege ntongeela ituntu nila ulamuli. ");
INSERT INTO isn_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Iti gwa, akamuamba uSosthene, mutongeeli nu itekeelo, akamukua ntongeela ituntu nila ulamuli. Kuiti uGalio shanga ai ukee nai akitumile. ");
INSERT INTO isn_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","uPaulo, ze yakilaa kikie pang'wanso ku itungo ilipu, ai ualekile anya ndugu nu kulongola na meli ku Siria palung'wi nu Prisila nu Akwila. Ze ikili nu kuhega pa bandari, ai uzue insingi niakwe ku nsoko ai watula walapaa kutula munazili. ");
INSERT INTO isn_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Nai akapika ku Efeso, uPaulo ai umulekile uPrisila nu Akwila pang'wanso, kuiti ung'wenso mukola akingila mi itekeelo nu kitambulya ni Ayahudi. ");
INSERT INTO isn_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Nai amutambuie uPaulo wikie ni enso ku itungo ilipu, nuanso ai uhitile. ");
INSERT INTO isn_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Kuiti wakahega kitalao, aka atambuila, “Nikasuka hangi kitalanyu, agaitule ingi ulowa wang'wa Itunda.” Ze yakilaa pang'wanso, wakahega ku meli kupuma ku Efeso. ");
INSERT INTO isn_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","uPaulo nai wakasima ku Kaisaria, ai unankie kulongola kulilamusha itekeelo nila ku Yerusalemu, uugwa akasima pihi ku itekeelo nila ku Antiokoa. ");
INSERT INTO isn_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ze yakilaa kikie ku itungo ilipu pang'wanso, uPaulo ai uhegile kukiila nkika nia ku Galatia ni Frigia nu kuakinyila inkolo i amanyisigwa ihi. ");
INSERT INTO isn_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Muyahudi ung'wi nuitangwaa Apolo, nai utugiwe uko ku Alexandria, ai upembilye ku Efeso. Ai ukete nu ulingi mu kuligitya hangi muhugu mu ukilisigwa. ");
INSERT INTO isn_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","uApollo ai watulaa ulagiiwe mu umanyisigwa nua Mukulu. Ku kinya uli nai ukete nu ukamatiku mu nkolo, ai wiligityaa nu kumanyisa ku uziza imakani namutuile uYesu, ila ai ulingile udu u wogigwa nuang'wa Yohana. ");
INSERT INTO isn_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","uApolo akandya kitamulya ku ukamatiku mi itekeelo. Kuiti uPrisila nu Akwila nai akamija, ai azipilye kihumbashuya nu ng'wenso hangi akamuganuila migulya a nzila niang'wa Itunda ku uziza, ");
INSERT INTO isn_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Nai wakahung'wa insula kuhega kulongola ku Akaya, anyandugu ai amukinyie inkolo nu kuakilisilya ibada i amanyisigwa niakoli ku Akaya iti ahume kumusingiilya. Nuikapikiila, ku ukende ai ua aiiye nangaluu awo nai ahuiie. ");
INSERT INTO isn_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ku ngulu niakwe ni mahala, uApolo ai uakiile i Ayahudi mu kihenga wazelagiila kukiila ukilisigwa niya kina uYesu yuyo Kristo. ");
INSERT INTO isn_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ikatula kina uApolo nai wakatula ku Korintho, uPaulo akakila matumbi a migulya nu kupika kisali nika Efeso, hangi wakahanga amanyisigwa kituunga kung'wanso. ");
INSERT INTO isn_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","uPaulo aka atambuila, “Itii, ai mumusingiiye uNg'wau Ng'welu nai muhuiie?” Aka mutambuila, “Aa, shanga ai kuhumile ga nukija kutula uNg'wau Ng'welu.” ");
INSERT INTO isn_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","uPaulo akaligitya, “Itungili unyenye ai mogigwe uli?” Akaligitya, “Mu wogigwa nuang'wa Yohana.” ");
INSERT INTO isn_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Uugwa uPaulo akasukiilya, “uYohana ai wogilye ku wogigwa nua kila itunu. Aka aila i antu awo kina atakiwe kumuhuiila uyo naiza uzeepembya zeyakilaa nuanso, kuiti, uYesu. ");
INSERT INTO isn_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Antu nai akija u lukani ulu, akogigwa ku lina nila Mukulu uYesu. ");
INSERT INTO isn_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Hangi ikatula uPaulo nai wakaikila i mikono akwe migulya ao, uNg'wau Ng'welu wakiza migulya ao nu kandya kitunta ku ntambu nu kulota. ");
INSERT INTO isn_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Jumla ao ai akoli agoha apikiie ikumi na abiili. ");
INSERT INTO isn_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","uPaulo ai ulongoe mi itekeelo akaligitya ku ukamatiku ku matungo a myeli itaatu. ai utuile utongee u witambuliyi nu kualuta i antu kutula imakani natulikile nu utemi nua ang'wa Itunda. ");
INSERT INTO isn_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Kuiti i Ayahudi auya ai atulaa ilugoha hangi ni shanga ijaa, ai andilye kutambula ubii kutula i nzila ang'wa Kristo ntongeela iumbi. Uugwa u Paulo ai ulekenukile ni enso hangi aka abagula i ahuiili kahelu ni enso. Nu ng'wenso ai wandilye kuligitya kila luhiku mu kianda nika Tirano. ");
INSERT INTO isn_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Iki ai kilongolekile ku myaka ibiili, ku lulo ihi nai atulaa ikii mu Asia ai igule u lukani nila Mukulu, ihi i Ayahudi ni Ayunani. ");
INSERT INTO isn_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Itunda ai watulaa ukituma makani makulu ku mikono ang'wa Paulo, ");
INSERT INTO isn_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","kina ga ni alwae ai akomigwe, ni ahing'wi ai a apumile, itungo nai ahoile u mukako nu ng'wenda nai ipumile mu muili nuang'wa Paulo. ");
INSERT INTO isn_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Kuiti ai amoli Ayahudi akuhiilya a hing'wi ai alongoe muhinzo kukiila i kipango ni kanso, ai alitumie i lina nilang'wa Yesu ku nsoko a utumili nuao akola. Aze atambuila awo nai akete i ahing'wi; Azeligitya, “Kumulagiilya mupume mu lina nilang'wa Yesu naiza uPaulo ukimutanantya.” ");
INSERT INTO isn_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Nai itumile aya ai atulaa ana mupungati ang'wa kuhani nu Mukulu nua Ayahudi, uSkewa. ");
INSERT INTO isn_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ahing'wi aka asukiilya, “uYesu kumulingile, nu Paulo kumulingile; Kuiti unyenye ingi a anyenyu?” ");
INSERT INTO isn_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Uyo u hing'wi mukati a muntu waka aputila i akuhiilya a hing'wi nu kuakilya i ngulu nu kua kua. Uugwa akamanka kupuma ito ilo aze ikipwi nu kuaaligwa. ");
INSERT INTO isn_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ikani ili likakumuka ku ihi. Ayahudi ni Ayunani, naza ikiee uko ku Efeso. Akatula nu woa nangaluu, ni lina nila Mukulu likakila ku kuligwa. ");
INSERT INTO isn_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Hangi, idu a ahuiili ai azile hangi akihanguila hangi azepumilya intendo nimbi nai itumile. ");
INSERT INTO isn_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Idu ai atulaa akituma ukiliki akilingiila i mbugulu niao, akaisonsa ntongeela a kila muntu. Itungo nianso nai aka allya insailo nia intu nianso ai yatulaa ipande magana a nzogu makumi a taano niya mpia. ");
INSERT INTO isn_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Iti gwa ulukani nula Mukulu likakondaniila ku ugali nangaluu mu ngulu. ");
INSERT INTO isn_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ni ang'wa Paulo kukondaniilya u uailya nuakwe uko ku Efeso, Ung'wau Ng'welu aka atongeela kulongola ku Yerusalemu ku kiila ku Makedonia ni Akaya; Akaligitya, Ze yakilaa kutula kung'wanso, intakile ki henga ni Rumi ga.” ");
INSERT INTO isn_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","uPaulo waka alagiilya ku Makedonia i amanyisigwa akwe a biili, uTimotheo nu Erasto, naza atulaa amuaiiye. Kuiti nuanso mukola wakasiga ku Asia ku itungo. ");
INSERT INTO isn_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Itungo lilo ai ipumiie minyomo ukulu uko ku Efeso kutula inzila iyo. ");
INSERT INTO isn_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Mutyani ung'wi i lina nilakwe Demetrio, naiza uzipilye i a dudu nia mpia ni itunda uDiana, ai wiletaa usuluja ukulu ku atyani. ");
INSERT INTO isn_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Uugwa akailingiila i atyani nia mulimo nuanso nu kuligitya, “Akulu, mulingile kina mu usulsja uwu usese kingilya mpia idu. ");
INSERT INTO isn_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Mihengile nu kija kina, shanga udu apa ku Efeso, ila pakupi Asia ihi, uyu uPaulo wa apemaa nu kuapiula i antu idu. Ukuligitya kina kutili i itunda naiza azipigwe ku mikono. ");
INSERT INTO isn_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Hangi shanga udu ikoli ulugu kina usuluja nuitu ukutula shanga utakiwe hangi, kuiti ga ni itekeelo nilang'wa itunda nu musungu niiza mukulu uDiana uhumile kuholwa kutula mugila anga ndogoelyo. Hangi aza uzee huma ga nukulimilya u kulu nuakwe, nuanso naiza ku Asia ni ihi limukulyaa.” ");
INSERT INTO isn_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Nai akija aya, ai izuiwe ni ikuo nu kuzogolya, azeligitya, “uDiana nua ku Efeso ingi mukulu,” ");
INSERT INTO isn_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kisali kihi kikizula minyomo, ni antu akamanka palung'wi mukati a kianda nika miginso, aka a amba ia nyamuhinzo auya nu Paulo, Gayo nu Aristariko, naiapumile ku Makedonia. ");
INSERT INTO isn_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","uPaulo ai uloilwe kingila miumbi nila antu, kuiti i amanyisigwa ai amugiiye. ");
INSERT INTO isn_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ga ni, ang'wi a afisa nia mukoa nu Asia naza atuile ahumbauya akwe akamutwaile lukani ku ngulu nu kumulompa waleke kingila mu kianda nika miginso. ");
INSERT INTO isn_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ang'wi a antu ai atulaa akuligitya i kintu iki ni auya ikani ilo, ku nsoko iumbi nila antu ai latulaa lahalinkanilwa. Idu ao shanga ai ahumile ga nu kulinga ku niki ai azile palung'wi. ");
INSERT INTO isn_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ayahudi akamuleta uIskanda kunzi iumbi nila antu nu kumuika migulya ntongeela a antu. uIskanda akapumya ilingasiilyo ku mukono nuakwe nu kupumya uganulwa ku antu. ");
INSERT INTO isn_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Kuiti nai akalinga kina ung'wenso ingi Muyahudi, ihi akazogolya ku luli lung'wi ku itungo nila saa ibiili, “uDiana ingi mukulu nua Aefeso.” ");
INSERT INTO isn_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ze yakilaa u talishi nua kisali ku likilaja i umbi, ai uligitilye, “Unyenye agoha nia ku Efeso, ingi nyenyu ni shanga ulingile kina i kisali iki nika Efeso ingi musununja nui itekeelo ni lang'wa Diana nu mukulu ni iyo ipisha nai igwie kupuma kilunde? ");
INSERT INTO isn_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Kihenga gwa kina i makani aya shanga ahumikile, kutakiwe kutula nu ulyuuku hangi leki kitumi kihi ku ukau. ");
INSERT INTO isn_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ku ndogoelyo muitangile i antu awa apa pi ibalaza naza shanga i ii itekeelo ang'wi shanga anya kumukuna itunda nuitu nu musungu. ");
INSERT INTO isn_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ku lulo, anga ize uDametrio ni atyani niakoli palung'wi nu ng'wenso akete mitumbo ku muntu wihi, i mabalaza akoli ng'walyi ni aliwali amoli. Ni aletwe ntongeela a lukani. ");
INSERT INTO isn_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Kuiti anga ize u ewe udume kihi kutula makani ni mangiiza, akitung'wa mi ianza nila tai taai. ");
INSERT INTO isn_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ku tai kukoli mu ulugu nua kusigwa ibii kutula minyomo luhiku ulu. Kutili nsoko a ushapu uwu, hangi shanga kuutula nu uhumi nua kuganula. ");
INSERT INTO isn_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ze yakilaa kuligitya aya, aka asapatilya ai anyianza. ");
INSERT INTO isn_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ze yakilaa u minyomo kuhila, uPaulo akaitanga i amanyisigwa nu kuakinyila. Uugwa kualaga nu kuhega kulongola ku Makedonia. ");
INSERT INTO isn_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Nung'wenso nai wakondya kukila mikoa nanso hangi ai watula ukuakinyila i ahuiili, akingila mu Uyunani. ");
INSERT INTO isn_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ze yakilaa ung'wenso kutula pang'wanso ku itungo nila myeli itaatu, ushaala ai uzepigwe ki talakwe ni Ayahudi nai watula ukuhumbeela kutunga muhinzo ku nzila a luzi kutunga ku Shamu, iti akasiga kusuka kukiila ku Makedonia. ");
INSERT INTO isn_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Nai akuie nu ng'wenso kupikiila ku Sopatro, ng'wana nuang'wa Pirho kupuma mu Berea; Aristariko nu Sekundo, ihi kupuma mu ahuiili nia ku Athesalonike; uGayo nua ku Derbe; Timotheo, Tikiko nu Trofimo kupuma ku Asia. ");
INSERT INTO isn_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Kuiti antu awa akondyaa kutongela hangi ai atulaa akulindiila uko ku Troa. ");
INSERT INTO isn_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ku nzila na luzi kupuma ku Filipi ze yakilaa luhiku nula mikate ni shanga i ikiwe igai, nu mu mahiku a taano ki ka apikiila ku Troa. Ki kikie kuko ku mahiku mu tandaatu. ");
INSERT INTO isn_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ga nu luhiku nulang'wandyo nula wiki, nai kukoli kilingiie palung'wi iti ku uega u mukate, uPaulo ai witambuuye ni ahuiili. Ai watulaa ukuzipya kuhega mudau akwe, itigwa akalongoleka kuligitya kupikiila u utiku wigengu. ");
INSERT INTO isn_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ai ikoli intala idu mu shumba nika migulya naiza kilundiie palung'wi. ");
INSERT INTO isn_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mi ibolomyo ai ukoli wikiie muhumba ung'wi i lina nilakwe Utiko, naiza ulemeigwe nu tulo mulito. Ga nu Paulo nai watula ukutanantya ku itungo ilipu, u umuhumba uyu, aze ulae, akagwa pihi kupuma mu gorofa a kataatu hangi ai ukugilwe aze ukule. ");
INSERT INTO isn_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Kuiti uPaulo wakasima pihi, ai wigooe ng'wenso mukola migulya akwe, akamu ungatila. Uugwa akaligitya, Leki kuhung'wi ukata, ku nsoko ukoli mupanga.” ");
INSERT INTO isn_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Uugwa akanankila hangi mu golofa nu ku uega u mukate, akalya. Ze yakilaa kitambuila ni enso ku itngo ilipu kupikiila maniambwa, akahega. ");
INSERT INTO isn_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Akamuleta uyo u muhumba aze mupanga akiloelya nangaluu. ");
INSERT INTO isn_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Usese akola ai kutongee ntongeela ang'wa Paulo ku meli hangi kikatunga ku Aso, naza usese kuzipilye kumuhola uPaulo kuko. Iki kiko ung'wenso mukola ai uloilwe kituma, ku nsoko ai uzipilye kulongola kukiila mihi ni nyumu. ");
INSERT INTO isn_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nai wakapika uko ku Aso, kikamunankilya mu meli kikalongola ku Mitilene. ");
INSERT INTO isn_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Uugwa usese kikahumbuka kupuma kung'wanso nu luhiku nula kabiili ai kupikile nkika a kabiili na kisiwa nika Kio. Luhiku nai lutyatile, kikapikiila ku kisiwa nika Samo, nu mudau akwe kikapika kisali nika Mileto. ");
INSERT INTO isn_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Kunsoko u Paulo ai watulaa walamula kutunga muhinzo kukiila ku Efeso, iti kina waleke kutumila itungo ilipu lihi mu Asia; ku ndogoelyo ai watula nu upepele nua kukaya ku Yerusalemu kunsoko a luhiku nula Pentekoste, anga ai ihumike nuanso kituma iti ");
INSERT INTO isn_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kupuma ku Mileto akalagiilya antu kupika ku Efeso hangi akaitanga anyampala ni itekeelo. ");
INSERT INTO isn_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Nai akapika kitalakwe, aka atambuila, unyenye akola mulingile puma u luhiku nula ng'wandyo nai mpambatile apa ku Asia, iti nai nkoli kitalanyu matungo ihi. ");
INSERT INTO isn_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nitumile ku Mukulu ku ulyuuku wihi hangi ku liholi, nu lwago nai lumpatile unene ku isui nila Ayahudi. ");
INSERT INTO isn_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mulingile iti naiza shanga ai nigiiye kutanantya kitalanyu kintu kihi naza kituile ka kusanigwa, ni iti unene nai numumanyisilye kihenga ga ni kulongola ito ku ito. ");
INSERT INTO isn_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mulingile iti unene nai nongolekile kualanga i Ayahudi ni Ayunani migulya a kila itunu kung'wa Itunda nu u huiili mu Mukulu nuitu uYesu. ");
INSERT INTO isn_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ni itungili, gozeeli, unene, nize nkoli nu muhuiie u Ng'wau Ng'welu kutunga ku Yerusalemu, ndeke kumalinga i makani niiza akumpumila unene kung'wanso, ");
INSERT INTO isn_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ila ku nsoko u Ng'wau Ng'welu winkuiila unene mu kila kisali hangi wiligitya kina i minyororo nu lwago zizo inindiie. ");
INSERT INTO isn_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Kuiti unene shanga ai nsigile kina u likalo nu lane ingi ku nzila ihi na nsailo kitalane, iti nihume kumalinkiilya u lugendo nu lane nu uaiilya nai nsingiiye kupuma ku Mukulu uYesu, kukuiila u lukani nu luza nula ukende nuang'wa Itunda. ");
INSERT INTO isn_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Ni itungili, goza, ningile kina ihi, mukati ao mu awo nai nongoe kuatanantilya u Utemi, shanga mukunihenga u usu hangi. ");
INSERT INTO isn_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ku lulo kumu kuiila lelo yiyi, kina nimugila igazo ku sakami a muntu wihi. ");
INSERT INTO isn_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ku ndogoelyo shanga ai nigiiye kumutanantilya u ulowa nuang'wa Itunda. ");
INSERT INTO isn_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ku lulo tuli akendegeeli migulya anyu unyenye akola, ni migulya idale lihi niize u Ng'wau Ng'welu umuikile unyenye kutula miasunja. Tuli miakendegeeli ku usunja umilundo nua Mukulu, naiza uliguile ku sakami akwe mukola. ");
INSERT INTO isn_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ningile kina ze yakilaa kuhega kitalane, mbugi ni ntaki yukingila mitalanyu, hangi ihite kuliaisiilya idale. ");
INSERT INTO isn_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ningile kina ga nu mukati anyu akola, ang'wi a antu azile nu kuligitya makani a mulimili, iti kualuta i amanyisigwa a atyate enso. ");
INSERT INTO isn_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ku lulo mutule miho. Kimbukiilyi kina ku myaka i taatu shanga ai nihumile kuleka kumanyisa kila ung'wi anyu ku liholi utiku nu mung'wi. ");
INSERT INTO isn_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Ni itungili unene naminkiilya kung'wa Itunda, nu kulukani nula ukende nuakwe, naiza luhumile kumuzenga nu kuminkiilya isalo palung'wi ni enso ihi niaikilwe ikulyo kung'wa Itunda. ");
INSERT INTO isn_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Shanga ai nkete nsula a mpia, zahabu, ang'wi a ng'wenda. ");
INSERT INTO isn_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mulingile unyenye akola kina i mikono iyi ininkiiye u lwinzo nulane mukola nu lwinzo nula awo nai akoli palung'wi nu nene. ");
INSERT INTO isn_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mu makani ihi ai numinkiiye mpyani a iti ni mutakiwe ku a aiilya ia nyeku ku kituma i milimo, ni iti ni mutakiwe ku kimbukiilya i makani a Mukulu uYesu, makani naiza u ng'wenso mukola ai uligitilye; “Ingi ibahu kupumya kukila kusingiilya.” ");
INSERT INTO isn_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ze yakilaa kuligitya kinya iti, ai utugamile akalompa palung'wi ni enso. ");
INSERT INTO isn_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ihi akalila nangaluu nu kumugwila uPaulo mu nkingo nu kumulungila. ");
INSERT INTO isn_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ai ahumilwe kinya uwai ikilo nila ihi ku nsoko a iko naiza watulaa ukiligitilye, kina nangaluu shanga akihenga u usu nuakwe hangi. Uugwa akamutindikiilya mu Melikebu. ");
INSERT INTO isn_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Matungo nai katula kalekanuka ni enso, nu kutunga muhinzo mu luzi, ai kupikiie moja kwa moja mu kisali nika Kosi, nu mudau akwe kikapikiila kisali nika Rodo, nu kupuma kung'wanso kikapikiila kisali nika Patara. ");
INSERT INTO isn_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Nai kuligilye i meli nikuputa kulongola ku Foenike, ai kunankie kikatunga umuhinzo. ");
INSERT INTO isn_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Nai kikapika ntongeela a kisiwa nika Kipro, kikakileka nkika a kisungu, kikatunga u muhinzo kupikiila ku Siria, kikaika i nanga mu kisali nika Toro, ku nsoko kung'wanso kuko i meli ai atulaa isimiligwe i miligo akwe. ");
INSERT INTO isn_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ze yakilaa kuihenga i amanyisigwa, ki kikie kung'wanso mahiku mupungati. iAmanyisigwa awa akamutambuila uPaulo ku kiila ku Ng'wau ng'welu kina u ng'wenso waleke kupambata ku Yerusalemu. ");
INSERT INTO isn_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nai kapikiilya ga ni mahiku nanso, u sese kikahega kulongola yitu. Ihi palung'wi, ni asungu ao ni ana ao, ai akutindikiiye munzila yitu kupikiila nai kikapuma kunzi a kisali. Uugwa kikatugama mu nshemba, kikalompa, kikilaga kila ung'wi. ");
INSERT INTO isn_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Kikanankila i meli, kunu nienso akasuka ku mato ao hangi. ");
INSERT INTO isn_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Nai kikamala ga nu muhinzo nuitu kupuma ku Tiro, kikapikiila ku Tolemai. Pang'wanso ai kika alamusha i anyandugu, nu kikie nienso ku luhiku lung'wi. ");
INSERT INTO isn_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Mudau akwe kikahega kikalongola ku Kaisaria. uSese kikingila mi ito nilang'wa Filipo, mutanantya nua nkani ninza, nai watulaa ung'wi nu awo ni mupungati, nu sese ki kikie palung'wi nu ng'wenso. ");
INSERT INTO isn_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Muntu uyu ai ukete ananso anne a mudama ai ilotaa. ");
INSERT INTO isn_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ze yakilaa kikie kung'wanso ku mahiku kituunga, akasima kupuma ku Uyahudi munyakidagu ung'wi nuitangwa Agabo. ");
INSERT INTO isn_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nuanso ai uzile kitaitu hangi akauhola u mukoha nuang'wa Paulo. ku uwu ai witungile migulu ni mikono akwe mukola nu kuligitya, “Ng'wau Ng'welu wiligityaa itii,” “Ayahudi nia ku Yerusalemu akumutunga u muntu niiza mukola hiu nua mukoha uwu, ni enso akuminkiilya mu mikono a antu ni anyaingu.” ");
INSERT INTO isn_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nai kikija i makani nanso, usese ni antu nai atulaa ikie i kianza ni kanso ai kumusingilye uPaulo waleke kunankila kulongola ku Yerusalemu. ");
INSERT INTO isn_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Uugwa uPaulo ai usukiiye, “Mukituma ntuni, mukulila nu kunihumya ukata mu nkolo ane? ku ndogoelyo nkoli nkondaniie, shanga kutungwa udu, kuiti ga nukushila kuko ku Yerusalemu ku nsoko a lina nila Mukulu uYesu.” ");
INSERT INTO isn_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ku iti uPaulo shanga ai uloilwe kupeng'wa, ai kulekile nu kuligitya, “Uugwa ulowa nuang'wa Itunda utumike.” ");
INSERT INTO isn_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ze yakilaa i mahiku nanso, ai kuhoile i mpinda yitu nu kunankila ku Yerusalemu. ");
INSERT INTO isn_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ze yakilaa i amanyisigwa kupuma ku Kaisaria ai ityatile nu sese ga. Akamuleta muntu ung'wi nui tangwaa Mnasoni, muntu nua ku Kipro, mu manyisigwa nua kali, naiza kikie nu ng'wenso. ");
INSERT INTO isn_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Nai kikapikiila ku Yerusalemu, anyandugu ai akusingiiye ku ulowa. ");
INSERT INTO isn_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Mudau akwe uPaulo ai ulongoe palung'wi nu sese nu Yakobo, ni anyampala ihi nai akoli. ");
INSERT INTO isn_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ze yakilaa kualamusha, ai uinkiiye i makani naizaa Itunda witumile mukati ao i anyaingu kukiila uaiilya nuakwe. ");
INSERT INTO isn_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Matungo nai akija nanso, akamulumbiilya Itunda, hangi akamutambuila, “Wihengaa, munyandugu, akoli magana a nzogu anga ahuiie mukati a Ayahudi. Nienso ihi akete nsula kuamba ilagiilyo. ");
INSERT INTO isn_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Atambuiwe kutula u ewe, kina ukumanyisa i Ayahudi ni ikiie mu anyaingu kulekanuka nu Musa, ni kina ukuatambuila aleke kuatwala i kidamu i ana ao, hangi aleke kutyata i ntendo nia kali. ");
INSERT INTO isn_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Kutakiwe kitume ntuni? Kutile u mintumbo aki giilya kina u ewe wapikiila. ");
INSERT INTO isn_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Iti itume iko usese ni ku ukutambuila itungili; kukete antu anne naza aikile ndagu. ");
INSERT INTO isn_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ahole i antu awa hangi wielye mukola palung'wi ni enso, nu kualipilya u ugulwa nu ao, iti ahume kuzula i matwe ao. Uugwa kila ung'wi walije kilinga kina imakani nai atambuiwe kutula u ewe ingi a uteele. Akimanyisa kina u ewe ga utyatile ilagiilyo. ");
INSERT INTO isn_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Kuiti ku makani a anyaingu naza atulaa ahuiili, ai kukilisilye nu kupumya i malagiilyo kina atakiwe kihuja ni intu naza ipumigwe isongelyo ku a dudu, ni sakami, kupumiila ni iko naza kigogilwe, hangi ihuje nu usambo.” ");
INSERT INTO isn_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Uugwa, uPaulo aka ahola i agoha, nu luhiku nula kabiili, akielya u mukola palung'wi ni enso, akingila mu Itekeelo, kutanantya i tungo nila mahiku na kielya, kupikiila isongelyo lipumigwe ku nsoko a kila ung'wi ao. ");
INSERT INTO isn_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Mahiku nanso ni mupungati nai ahumbela ku ulinkiila, ze yakilaa i Ayahudi kupuma ku Asia akamihenga uPaulo Mitekeelo, ni anyianza akataka, hangi akamugoela u mukono. ");
INSERT INTO isn_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ai atulaa akuzogolya, “Antu a Israeli, kuaiilyi, Uyu ingi yuyo muntu nuenda amanyisa i antu kila nkika i makani niiza nsuta ni antu, ilagiilyo, ni kianza iki. Wa aleta ga ni Ayunani mu Itekeelo nu kuika kibudu kianza apa ni pelu. ");
INSERT INTO isn_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ku nsoko u ng'wandyo ai atulaa amihenga uTrofimo Muefeso aze ukoli palung'wi nu ng'wenso mu kisali, ni enso ai asigiie kina uPaulo ai wamuletaa mitekeelo. ");
INSERT INTO isn_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Kisali kihi ai katulaa nu ukunguali, ni antu akamanka palung'wi nu kumuamba uPaulo. Akamupumya kunzi i Itekeelo, ni milango nkua ikalugailwa. ");
INSERT INTO isn_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Nai ikatula akugema kumubulaga, inkani ikamupikila u mukulu nua anya mbita nia usunji kina i Yerusalemu ihi ai atulaa izula minyomo. ");
INSERT INTO isn_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Itungo lilo aka ahola i asunja nu mukomoli akalimankiila iumbi. Matungo i antu nai akihenga u mukulu nua idale nila asunja, akaleka kumukua uPaulo. ");
INSERT INTO isn_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Uugwa u mukulu nu idale ai umuhumbee nu kumuamba uPaulo, hangi akalagiilya watungwe minyororo ibiili. Akamukolya nuanso ingi nyenyu hangi ukituma ki ntuni. ");
INSERT INTO isn_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ang'wi ao a antu mi umbi ai atulaa akubunuka i kintu iki ni auya kingiiza. Ku nsoko u mukomoli shanga ai uhumile kuatambuila kihi ku nsoko a iyogo ilo, akalagiilya uPaulo waletwe mukati itando. ");
INSERT INTO isn_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Uugwa nai wakapika mu munankiilo, akaholwa nu asikali ku nsoko a minyomo nu i umbi. ");
INSERT INTO isn_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ndogoelyo i umbi nila antu ai limutyatiie nu kulongoleka kukua iyogo, “Muheji uyu.” ");
INSERT INTO isn_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","uPaulo nai watula ukuletwa mukati itando, ai umutambuie u mukulu nu idale, “Nihumilene nukutambuile kintu?” Umukulu uyu nu idale akaligitya, “itii ukutambula Kiyunani? ");
INSERT INTO isn_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Itii, u ewe shanga wi uyo u Mumisri naiza u ng'wandyo ai utongee u upiluki hangi ai uhoile i a kilemu magana a nzogu anne mu wii?” ");
INSERT INTO isn_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","uPaulo akaligitya, “Unene ni Muyahudi, kupuma kisali ka Tarso a ku Kilikia. Unene ni munya ihi nua kisali ni kikumukile. Numulompile, mundeke nitambulye ni antu.” ");
INSERT INTO isn_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Itungo u mukomoli nai umulekee, uPaulo akimika pa munankiilo hangi akapumya kilingasiilyo ku antu ku mukono nuakwe, Itungo nai ikoli ihitwii nangalu, akitambuila ni enso ku Kiebrania. Akaligitya, ");
INSERT INTO isn_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Anyandugu ni a tata ane, tegeelyi u uguniilyi nuane ni nikawituma kitalanyu itungili.” ");
INSERT INTO isn_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Anyianza nai akija uPaulo ukuligitya ni enso ku Kiebrania, aka kilaga. Akaligitya. ");
INSERT INTO isn_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Unene ni Muyahudi, ntugiwe kisali ka Tarso kipango nika Kilikia, ila aindigiiye i kimanyi mu kisali iki, mu migulu ang'wa Gamalieli. Ai manyisigwe kunuganiila ni nzila nziza nia malagiilyo a atata itu. Unene ni munyangulu kung'wa Itunda, anga u nyenye mihi ni mili ilelo. ");
INSERT INTO isn_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ai niagilye ku nzila iyi kupikiila insha; nika atunga agoha ni asungu nu kuagumila mu kadulumu. ");
INSERT INTO isn_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ga nu kuhani nu mukulu ni anyampala ihi ahumile kupumya u ukuiili kina ai nsingiiye ibada kupuma kitalao ku nsoko a anyandugu niakoli ku Dameski, kitalane unene kutunga u muhinzo kulongola kung'wanso. Ai ituile nialete antu ku Yerusalemu ku nzila iyo iti atungwe nu kulingwa njuguda. ");
INSERT INTO isn_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Ai ipumie kina pang'wanso nai natula nkoli muhinzo nu kuhumbeela ku Dameski, itungo nila mung'wi kupumbugiilya welu ukulu ukapumila kilunde ukandya kunelya. ");
INSERT INTO isn_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Nikagwa pihi hangi nikija luli lukumbila, 'Sauli, Sauli ku niki ukuntasha?' ");
INSERT INTO isn_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nikasukiilya, 'u ewe wi nyenyu, Mukulu?' Akantambuila, 'Unene ni Yesu Munazaeti, naiza u ewe ukuntasha.' ");
INSERT INTO isn_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Awo nai akoli palung'wi nu nene ai ihengile u welu, ila shanga ai igulye u luli nulang'wa uyo nai uligitilye nu nene. ");
INSERT INTO isn_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Nikaligitya, 'Nitume ntuni, Mukulu?' uMukulu akantambuila, Imike hangi wingile mu Dameski; kung'wanso ukutambuilwa kila i kintu nutakiwe kituma.' ");
INSERT INTO isn_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Shanga ai nihumile kihenga kunsoko a welu nua welu uwo, uugwa nikalongola ku Dameski ku kutongwa ni mikono nua awo nai akoli nu nene. ");
INSERT INTO isn_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Kung'wanso nikatankana nu muntu nai witangwa Anania, ai watulaa muntu nai uambile ilagiilyo hangi munya ku kuligwa ntongeela a Ayahudi ihi nai ikiie kung'wanso. ");
INSERT INTO isn_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Akapembya kitalane, akimika ntongeela ane, nu kuligitya, Munyandugu Sauli, ulije kihenga. 'Ku itungo lilo liilo nikihenga. ");
INSERT INTO isn_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Akaligitya, 'Itunda nua atata itu ukuholanilye u ewe ulije kulinga u ulowa nuakwe, kumihenga uyo ni munya tai ane, nu kija u luli nulupembeeye milangu nilakwe. ");
INSERT INTO isn_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ku nsoko ukutula wi mukuiili kitalakwe nu kuantu ihi migulya a naza umihengile nu kigiilya. ");
INSERT INTO isn_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Uugwa itungili ku niki ulindiie? Uka, wogigwe, woje i milandu ako, uzelitanga i lina nilakwe.' ");
INSERT INTO isn_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Ze yakilaa kusuka ku Yerusalemu, hangi nai natula kipolya mukati itekeelo, ikapumila kina nikinkiiligwa muloto. ");
INSERT INTO isn_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nikamihenga ukuntammbuila, 'kagupa upume mu Yerusalemu ku ukau, ku nsoko shanga augombile u ukuiili nuako kutula unene.' ");
INSERT INTO isn_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nikaligitya, 'Mukulu, enso akola alingile ai nia tungile mu kadulumu nu kuakua awo nai akuhuiie mu kila itekeelo. ");
INSERT INTO isn_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ni sakami ang'wa Stefano mukuiili nuako nai ihunuwe, Unene ga ai nkoli nimikile pakupi nu kugomba hangi ai natulaa kusunja ang'wenda a awo nai amubulagile.' ");
INSERT INTO isn_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Kuiti ai untambuie, 'Longola, ku nsoko unene nika kulagiilya ulongole kuli ku anyaingu.” ");
INSERT INTO isn_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Antu akamulekela waligitye migulya a lukani ulu. Kuiti panyambele akitunta nu kuligitya, “muheje u muntu uyu mi ihi; ku nsoko shanga iziza wikie.” ");
INSERT INTO isn_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Nai akatula akitunta, nu kuguma i ang'wenda ao nu kupekula u lunkundi migulya, ");
INSERT INTO isn_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","u mukomoli nu mukulu akalagiilya uPaulo waletwe mitando. Akalagiilya wakoligwe kunu wazekuwa i mikoha, iti u ng'wenso mukola walinge ku niki ai atulaa akumuzogoelya iyogo kinya iti. ");
INSERT INTO isn_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ga ni iti nai atulaa amutunga ku ndigi, uPaulo aka mutambuila u akida uyo nai wimikile pakupi nu ng'wenso, “Itii! ingi tai ane kitalanyu kumukua u muntu niza Murumi hangi wakili kulamulwa?” ");
INSERT INTO isn_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","U akida uyo nai wakija i makani aya, akalongola ku mukomoli nu mukulu nu kumutambuila, wazeligitya, “ Uloilwe kituma ntuni? ku ndogoelyo u muntu uyu ingi murumi.” ");
INSERT INTO isn_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","uMukomoli nu mukulu akapembya nu kumutambuila, “Ntambuile, itii, u ewe wi munya kisali nua ku Rumi?” uPaulo akaligitya, “Uu.” ");
INSERT INTO isn_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Umukomoli aka asukiilya, “Ingi kukiila ngele nkulu a mpia uugwa ai ndigilye u unya kisali.” Kuiti uPaulo akamutambuila, “Unene ni murumi nua kutugwa.” ");
INSERT INTO isn_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Uugwa awo nai akoli ihambile kulongola kumukolya akahega nu kumuleka itungo lilo liilo. Nu mukomoli nu ng'wenso akitumba, nai wakalinga uPaulo ingi Murumi, hangi ku nsoko wamutungaa. ");
INSERT INTO isn_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Luhiku nai lutyatile, u mukomoli nu mukulu ai uloilwe kulinga i tai kutula usemelwa nua Ayahudi kung'wa Paulo. Iti gwa akamutunguila i nyuli niakwe akalagiilya i akulu nia akuhani ni anza lihi litankane. Akamuleta uPaulo pihi, nu kumuika pa kati ao. ");
INSERT INTO isn_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","uPaulo aka agozeela kung'wandyo i antu ianza nu kuligitya, “Anyandugu ane, nikie ntongeela ang'wa Itunda ku nsula nziza kupikiila lelo iyi.” ");
INSERT INTO isn_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","uKuhani nu mukulu uAnania aka alagiilya awo nai imikile pakupi nu ng'wenso amukue ilangu nilakwe. ");
INSERT INTO isn_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Uugwa uPaulo akamutambuila, “Itunda uku ukua nu ewe, ikiligo nai lipoguhiwe inswakaala. Wikie ukunamula ku ilagiilyo, nu ewe ukundagiilya nkuwe nsuta ni malagiilyo?” ");
INSERT INTO isn_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Awo nai akoli imikile pakupi nu ng'wenso akaligitya, “Iti uu nu kumutukila u kuhani nu mukulu nuang'wa Itunda?” ");
INSERT INTO isn_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","uPaulo akaligitya, “alunaa ane, unene shanga azaningile kina uyu ingi kuhani nu mukulu. Ku nsoko ikilisigwe, shanga ukuligitya ibibi migulya a mukulu nua antu ako.” ");
INSERT INTO isn_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","uPaulo nai wakihenga ya kina i nkika ing'wi ni ianza ingi Asadukayo ni auya ingi Afarisayo, akitunta nukuligitya, anyandugu ane, unene ni Mufarisayo, ng'wana nua Mufarisayo. Ingi ku nsoko iyi nsumbiiye ku ukamatiku u wiukigwa nua ashi nikulamulwa nu enso.” ");
INSERT INTO isn_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Nai wakamaligitya aya, Wikungumi ukulu ukapumila mukati a Afarisayo ni Asadukayo, ni ianza likagalanuka. ");
INSERT INTO isn_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Ku iti iAsadukayo iligitya kutile u wiukigwa, malaika ang'wi ng'wau ng'welu, ila i Afarisayo iligitya aya ihi akoli. ");
INSERT INTO isn_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Minyomo ukulu ukapumila hangi ang'wi a amanyi nai akoli nkika a Afarisayo akimika nu kisija, azeligitya, “shanga kihengile kihi ni kibibi kung'wa muntu uyu. Uli anga u Ng'weu ng'welu ang'wi malaika uligitilye nu ng'wenso?” ");
INSERT INTO isn_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Itungo nai lipumie ikolyo ikulu, mukulu nu idale ai witubiule kina uPaulo ai uzee tamulanigwa mapuli mapuli ni enso, iti gwa akalagiilya i anyidale asime pihi nu kuhola ku ngulu kupuma ku anyianza ni ianza, nu kumuleta mi itando. ");
INSERT INTO isn_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Utiku nai utyatile uMukulu ai wimikile pakupi nu ng'wenso nu kuligitya, “Leka kitumba, Ku nsoko unkuiie mu Yerusalemu, iti ukupumya ukuiili ga nu mu Roma.” ");
INSERT INTO isn_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Nai ukela, ang'wi a Ayahudi ai azipilye ilago nu kitanga kizumi migulya ao akola; ai aligitilye kina shanga ikalya ang'wi kung'wa kihi kupikiila ni ikamubulaga uPaulo. ");
INSERT INTO isn_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ai akoli antu makumi anne ikilo naza azipilye isui ili. ");
INSERT INTO isn_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","akalongola ku akulu a akuhani ni anyampala nu kuligitya, “Ki ika akola mu kizumi kikulu, kuleke kulya kihi kupikiila kamubulaga uPaulo. ");
INSERT INTO isn_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Iti gwa itungili, ianza limutambuile u mukomoli nu mukulu wamulete kitalanyu, anga kina mukulamula usemelwa nuakwe ku uziza. Kitaitu usese kukoli kihambile kumubulaga ze wakili kupika apa.” ");
INSERT INTO isn_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Kuiti ung'wana nua muluna musungu wang'wa Paulo wakija kina likoli isui, akalongola akingila mukati i itando nu kumutambuila uPaulo. ");
INSERT INTO isn_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","uPaulo akamitanga u akida ung'wi akaligotya, “Muhole u muhumba uyu kung'wa mukomoli; ku nsoko ukete lukani nula kumutambuila.” ");
INSERT INTO isn_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Uugwa u akida akamuhola u muhumba uyo akamutwala kung'wa mukomoli nu mukulu akamutambuila, “uPaulo u mutungwa uyo aza unintangile wandagiilya nukuletele u muhumba uyu kitalako. Ukete lukani nula ku utambuila.” ");
INSERT INTO isn_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","uMukomoli uyo nu mukulu akamuamba ku mukono akibagula nu ng'wenso ku mpelo, nu kumukolya, “Ingi kintu kii nuloilwe kuntambuila?” ");
INSERT INTO isn_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Umuhumba uyu akaligitya, “Ayahudi igombilye ku ulompa umulete uPaulo mudau mi ianza anga kina aloilwe kulija nkani niakwe ku uziza ikilo. ");
INSERT INTO isn_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Uugwa u ewe uleke kugomba ku ndogoelyo antu makumi anne ikilo akumutungila. Itungile ku kizumi, aleke ga nu kulya ang'wi kung'wa kupikiila ni ikamubulaga. Ga ni itungili akoli akondaniie, aze alindiie ugombigwa puma kitalako.” ");
INSERT INTO isn_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Uugwa umukomoli uyo nu mukulu akamuleka u muhumba walongole yakwe, ze yakilaa kumulagiilya “waleke kumuila muntu wihi nia kina wamuganuila aya.” ");
INSERT INTO isn_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Akaitanga i a akida abiili akaligitya azipiilyi i a asikali magana abiili kulongola ku Kaisaria ni a asikali anankila mpalasi makumi mupungati, nawa niakete i ndilima magana abiili, mukuhega zamu a kataatu a utiku. ");
INSERT INTO isn_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Aka atambuila kuika ikali ikondile naiza uPaulo uku mutumila nu kumuhola iziza kung'wa Feliki uGavana. ");
INSERT INTO isn_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Akakilisa ibada ku kinya iti, ");
INSERT INTO isn_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Klaudio Lisia kung'wa Liwali mukuligwa uFeliki, mulamu. ");
INSERT INTO isn_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Umuntu uyu aza uambilwe ni Ayahudi atula pakupi kumubulaga, uugwa nalongola ni idale nila asikali nu kumuguna, nazandigilye inkani nia kina ung'wenso ingi munya ku Rumi. ");
INSERT INTO isn_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Aza ndoilwe kulinga ku niki amusemee, iti gwa namutwala mi anza. ");
INSERT INTO isn_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nihenga kina aza watulaa usemewe ku nsoko a makolyo a malagiilyo ao, ang'wi shanga aza usemewe lukani lihi nu luzipie kubulagwa ang'wi kutungwa. ");
INSERT INTO isn_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Uugwa yakumuka kitalane kina likoli isui ki talakwe, iti gwa ku ukau namulagiilya kitalako, nu kualagiilya niamusemee alete ga nu usemelwa nuakwe ntongeela ako. Ilaga.” ");
INSERT INTO isn_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Uugwa awo i a asikali akakela ilagiilyo; akamuhola uPaulo akamutwala ga nu ku Antipatri utiku. ");
INSERT INTO isn_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Luhiku naza lutyatile, i a asikali idu aka aleka awo ianankila mpalasi alongole palung'wi nu ng'wenso, nianso akasuka yao mitando. ");
INSERT INTO isn_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ni anankila mpalasi nai akapika ku Kaisaria, nu kuminkiilya u liwali ibada, akamuika uPaulo ntongeela akwe. ");
INSERT INTO isn_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Nu ng'wenso u liwali akalisoma ibada, ai umukoiye uPaulo ai upembeeye i jimbo kii, nai wakalinga nia kina ingi muntu nua ku Kilikia, ");
INSERT INTO isn_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","akaligitya, “Nikakija u ewe ni ikapembya awo nia kusemee,” akalagiilya waikwe mu ikulu ang'wa Herode. ");
INSERT INTO isn_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ze yakilaa mahiku a taano, uAnania kuhani nu mukulu, ang'wi a anyampala nu muligitya ung'wi nuitangwaa Tertulo, akalongola pang'wanso. Antu awa aletile usemelwa kutula Paulo kung'wa gavana. ");
INSERT INTO isn_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","uPaulo naza wimikile ntongeela ang'wa gavana, uTertulo akandya kumusemela nu kuligitya kung'wa gavana, “ku nsoko ako kukete ulyuuku ukulu; nu ku muloto nuako wiletaa upiluki uziza mi ihi nilitu; ");
INSERT INTO isn_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","uugwa ku ilumbi lihi kisingiilya kila i kintu nuitumaa, Milamu mukulu Feliki. ");
INSERT INTO isn_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Kuiti ndeke ku ukatalya ikilo, ku inena untegeelye makani masheenyu ku uaiilyi nuako. ");
INSERT INTO isn_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ku ndogoelyo kamulijaa muntu uyu munya lugida, hangi ukusasha iAyahudi ihi kupiluka mi ihi. Hangi ingi lukolongo nua mazindaalo a Anazorayo. (Komaniilya; Ipatyo nila makani a lukiili ulu 24; 6, ");
INSERT INTO isn_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ni hangi ai ugemeeye kuli ikila itekeelo kibudu itigwa kamuamba' umutili mu mbugulu ni nziza nia kali). (Komaniilya; U lukiili ulu ");
INSERT INTO isn_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Lisiasi, afisa, ai uzile nu kumuhola ku ngulu mu mikono itu, umutili mu mbugulu ni nziza nia ukilisigwa nua kali). ");
INSERT INTO isn_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Anga umukolye uPaulo kutula makani aya, ukuhuma ga nukimanyisa ingi kintu kii kumusemee.” ");
INSERT INTO isn_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ayahudi ni enso akamusemela uPaulo, azeligitya kina aya makani aza atulaa atai. ");
INSERT INTO isn_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","uLiwali nai wakamunyansuila u mukono uPaulo waligitye, uPaulo ai usukiiye, “Ningile kina ku myaka idu watuilee wi mulamuli nua ingu uwu, hangi nkete ulowa kitambuilya mukola kitalako. ");
INSERT INTO isn_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Uhumile ki ikilya kulu kuulu kina akili kukila mahiku ikumi na abiili ikilo puma naza nankie kulongola kipolya ku Yerusalemu. ");
INSERT INTO isn_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Hangi naza anihangile mi itekeelo, shanga aza nikungumile nu muntu wihi, hangi shanga aza nitumile anga minyomo mi anza, ang'wi mu matekeelo ang'wi mukati a kisali; ");
INSERT INTO isn_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","hangi ang'wi shanga ahumile kuika kulu kuulu kitalako u usemelwa nia ku usemela kitalane. ");
INSERT INTO isn_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ila kulapa ili kitalako, nia kina ku nzila iyo naiza akitanga i mazindaalo, ku nzila yiyo yiiyo ku mutumikila Itunda nua a tata itu. Unene ingi ni muhuiili ku ihi nakoli mi ilagiilyo nu ukilisigwa nua anyakidagu. ");
INSERT INTO isn_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nkete ugimya wuwo wuuwo kung'wa Itunda naza ga nao nienso au lindiie, kupembya ku wiuki nua ashi, ku ihi anya tai ane hangi ni agila i tai ane ga; ");
INSERT INTO isn_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","nu ku ili, kituma i milimo iti ntule ni isigo nigila i kinkwaatya ntongeela ang'wa Itunda ni ntongeela a antu kukiila makani ihi. ");
INSERT INTO isn_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Itungili ze yakilaa myaka idu nzile kuleta uaiilya ku ingu nuane nu uaiilya nua mpia. ");
INSERT INTO isn_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Nai nitumile iti, Ayahudi kituunga nia ku Asia akanihanga mukati a sherehe nai a kielya mukati itekeelo, bila idale nila antu ang'wi minyomo. ");
INSERT INTO isn_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Antu awa naza atakiwe kutula amoli ntongeela ako itungili iti hangi aligitye iko niakikete migulya ane anga ize akete lukani lihi. ");
INSERT INTO isn_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ang'wi antu awa akola nia ligitye ingi utumuli kii naza awihengile kitalane naza nimikile ntongeela i anza nila Ayahudi; ");
INSERT INTO isn_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","kwaala ku nsoko a kinu king'wi naza nikiligitilye ku luli naza nimikile pakati ao, “ ingi kunsoko a wiuki nua ashi unyenye mukunamula.” ");
INSERT INTO isn_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","uFeliki ai watulaa wapinduwee iziza kutula i nzila, hangi akalidilya i anza. Akaligitya, “Lisia mukomoli nui kiza pihi kupuma ku Yerusalemu nikapumya ulamuli ku usemelwa nuanyu.” ");
INSERT INTO isn_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Iti gwa akamulagiilya u akida wamusunje uPaulo, ila watule ni lyoma hangi waleke kutula ukoli ga nu muntu nua kuagilya i ahumba uya niakwe aleke kumuaiilya ang'wi kumiumba umbila ");
INSERT INTO isn_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Ze yakilaa mahiku kituunga, uFeliki akasuka nu Drusila musungu nuakwe nai watulaa Muyahudi, akalagiilya antu kumitanga uPaulo nu kutegeelya puma kitalakwe nkani nia uhuiili mukati ang'wa Kristo uYesu. ");
INSERT INTO isn_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ila uPaulo nai wakatula ukitambulya nu ng'wenso kutula tai ane, kutula ni ngele nu ulamuli nuikapembya, uFeliki akalija woa akasukiilya, “longola kuli ku itungili, ila anga ndije itungo hangi, nikakitanga.” ");
INSERT INTO isn_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Itungo lilo liilo, ai usumbiiye kina uPaulo ukuminkiilya mpia ku lulo ai umitangile nkua ingiiza akalingitya nu ng'wenso. ");
INSERT INTO isn_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ila myaka ibiili nai akiile, uPorkio Festo akatula Liwali ze yakilaa uFeliki, ila uFeliki ai uloiwe kielya ku Ayahudi, iti gwa akamuleka uPaulo pihi a usunja. ");
INSERT INTO isn_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Uugwa uFesto nai wakingila mukati i jimbo nilanso hangi ze yakilaa mahiku ataatu akalongola kupuma ku Kaisaria kupikiila ku Yerusalemu. ");
INSERT INTO isn_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","uKuhani nu mukulu ni Ayahudi ni asanigwe ai aletile usemelwa kutula Paulo kung'wa Festo. hangi ai aligitilye ku ngulu kung'wa Festo. ");
INSERT INTO isn_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Hangi ai amulompile uFesto Fadhili migulya a makani ang'wa Paulo alije kumitanga ku Yerusalemu iti ahume kumubulaga mu nzila. ");
INSERT INTO isn_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Kuiti uFesto ai usukiiye kina uPaulo ai watulaa mutungwa mu Kaisaria, ni kina ung'wenso mukola ukukaya kusuka kung'wanso. ");
INSERT INTO isn_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ai uligitilye, “Kululo, awo naza ahumile, ahumile kulongola uko nu sese. Anga ize kikoli kintu kibibi ku muntu uyu, mutakiwe kumusemela.” ");
INSERT INTO isn_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Ze yakilaa ki kie mahiku mu nana ang'wi ikumi ni ikilo, wikasuka ku Kaisaria. Nu luhiku nai lutyatile wakikie mi ituntu nila ulamuli nu kulagiilya uPaulo waletwe kitalakwe. ");
INSERT INTO isn_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Nai wakapika, Ayahudi kupuma ku Yerusalemu akimika pakupi, Akapumya usemelwa widu ulito naiza shanga ikahuma ku ukaminkiilya. ");
INSERT INTO isn_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","uPaulo ai witambuiye nu kuligitya, 'Shanga ku lina nila Ayahudi, shanga migulya itekeelo, ni shanga migulya ang'wa Kaisari, nitumile u ubi.' ");
INSERT INTO isn_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Kuiti uFesto ai uloilwe kielya ku Ayahudi, ni lulo aka musukiilya uPaulo ku kuligitya, 'Itii, uloilwe kulongola ku Yerusalemu nu kulamulwa nu nene kutula i makani aya kuko?' ");
INSERT INTO isn_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","uPaulo ai uligitilye, 'nimekile ntongeela i ituntu nila ulamuli ni lang'wa Kaisari naiza ntakiwe kulamulwa. Shanga nia tumuie i Ayahudi, anga u ewe nulingile ibahu. ");
INSERT INTO isn_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Anga itule ntumue hangi anga itule nitumile ni ashanga inonee insha, shanga nihitile kusha. Kuiti anga u usemelwa nuao shanga kintu, kutili u muntu nuhumile kuninkiilya kitalao. Kumulompa uKaisari.' ");
INSERT INTO isn_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ze yakilaa u Festo kuligitya ni i anza akasukiilya, “ukumulompa u Kaisari; ukulongola kung'wa Kaisari.” ");
INSERT INTO isn_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ze yakilaa mahiku kituunga, u mutemi u Agripa nu Bemike ai apikile ku Kaisaria kituma wiumbaumbi kung'wa Festo. ");
INSERT INTO isn_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ze yakilaa kikie papo ku mahiku idu, uFesto ai winkiiye usemelwa nuang'wa Paulo ku mutemi; Akaligitya, 'Muntu ung'wi aza ulekilwe papa nu Feliki anga mutungwa. ");
INSERT INTO isn_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Naza natula ku Yerusalemu akuhani ni akulu ni anyampala a Ayahudi ai aletile usemelwa migulya a muntu uyu kitalane, ni enso ai akoiye migulya a ulamulwa ku ng'waakwe. ");
INSERT INTO isn_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ku ili unene aza niasukiiye kina ku ntendo nia a Roma kumupumya muntu ku kielya badala akwe, u musemelwa utakiwe kutula ni lyoma nila ku gugana ni asemi akwe nu kitambuilya ku usemelwa nuanso. ");
INSERT INTO isn_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Ku lulo, nai akiza palung'wi apa, shanga ai nihumile kulindiila, kuiti luhiku nai lutyatile ai nikie mi tuntu nila ulamuli nu kulagiilya u muntu nuanso waletwe mukati. ");
INSERT INTO isn_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Itungo i asemi naza imikile nu kumusemela, nikasiga kina kutili u usemelwa nu ukulu nu uletilwe kitalakwe. ");
INSERT INTO isn_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Badala akwe ai akete u wikungumi nua kituunga palung'wi nu ng'wenso kutula kizindaalo ni kao ni kutula uYesu naiza ai watulaa wakule, kuiti uPaulo ukudaya kina ukoli upanga. ");
INSERT INTO isn_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ai natulaa nkunikiwe kinya kudumiila ikolyo ili, hangi nikamukolya anga ize ukulongola ku Yerusalemu kulamulwa kutula makani aya. ");
INSERT INTO isn_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Kuiti uPaulo nai wakitangwa waikwe pihi a usunja ku nsoko a ulamuli nua mutemi, ai ndagiiye waikwe ga ni nikamutwala kung'wa Kaisari. ");
INSERT INTO isn_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","uAgripa ai witambuie nu Festo, “aza nzeelowa ga nu kumutegeelya u muntu uyu.” “uFesto, akaligitya, “mudau ukumutegeelya.” ");
INSERT INTO isn_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Iti gwa mudau akwe, uAgripa nu Bernike ai apikile ni sherehe idu; ai apikile mi itando ni a afisa ni idale, ni antu nia asanigwe mu kisali. Nu Festo ai upumilye ilagiilyo, uPaulo waletwe kitalao. ");
INSERT INTO isn_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","uFesto akaligitya, “Mutemi Agripa, ni antu ihi naza amoli apa palung'wi nu sese, mu mihengile u muntu uyu; muhangu wihi nua Ayahudi uko ku Yerusalemu ni apa iti ga aloilwe ni asije, ni enso ikazogolya kitalane kina waleke kikie. ");
INSERT INTO isn_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ai nihengile kina shanga ai witumile lihi nilinonee insha; kuiti ku nsoko wamitangaa u mutemi, ai namue kumutwala kitalakwe. ");
INSERT INTO isn_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Kuiti nimugila i kintu ni kikaminkiie nika kukilisa ku mutemi. Ku nsoko ili, numuletile kitalako Agripa, iti nihume kutula ni kintu nika kukilisa kutula usemelwa. ");
INSERT INTO isn_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ku nsoko kihenga kigila i ndogoelyo kumutwala u mutungwa hangi bila kulagiila u usemelwa nu umukinyiie. ");
INSERT INTO isn_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Iti gwa, uAgripa akamutambuila uPaulo, 'Ugombigwe kitambuilya.' Uugwa uPaulo akagoola u mukono nuakwe akitambuilya iti. ");
INSERT INTO isn_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Kiona ni munya ulowa, Mutemi Agripa, iti kituma u usemelwa nuane ntongeela ako lelo ku usemelwa wihi nua Ayahudi. ");
INSERT INTO isn_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Lukulu, ku nsoko u ewe ingi wi mulingi nua ntendo nia Ayahudi ni makolyo. Iti gwa kulompa untegeelye ku ugimya. ");
INSERT INTO isn_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Tai, i Ayahudi ihi alingile iti nai nikie puma u ugalimanga nuane mu ingu nuane uko ku Yerusalemu. ");
INSERT INTO isn_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Aningile puma u ng'wandyo hangi atakiwe kugomba kina ai nikiie anga Mufarisayo, ikumbiko ni likete u uambiila tai utaki mu kizindaalo ni kitu. ");
INSERT INTO isn_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Itungili nimikile apa namulwe ku nsoko unene naligozee ilago naiza Itunda ai ulitumile ni atata itu. ");
INSERT INTO isn_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ili ingi ilago naiza i ndugu yitu ikumi na ibiili ai isumbiiye kusingiilya anga amipoelye Itunda ku ngulu utiku nu mung'wi. hangi kunsoko a uhuiili uwu, mutemi Agripa, kina i Ayahudi akunsemela. ");
INSERT INTO isn_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ku niki wihi kati anyu usigile ingi ikuilwa kina Itunda wi iusha i ashi? ");
INSERT INTO isn_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Itungo ling'wi ai nsigile mukola kina ai nziituma makani idu ku lina nilang'wa Yesu nua ku Nazareti. ");
INSERT INTO isn_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ai nitumile aya mu Yerusalemu; Ai niatungile i ahuiili idu mu kadulumu, hangi ai natulaa nu uhumi kupuma ku akulu nia akuhani kituma iti; ni matungo niakubulagwa, ai nikua kula kitalao. ");
INSERT INTO isn_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Nkua idu ai niapisiilya mu matekeelo ihi hangi ai ngemile kuazipya auhite u uhuiili nuao. Ai nkete ikuo nangaluu migulya ao hangi ai niazunsilye ga nu mu isali nia uziila ");
INSERT INTO isn_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Matungo nai natulaa kituma aya, ainongoe ku Dameski, nize nkete u uhumi nu ulagiiligwa kupuma ku akuhani ni akulu, ");
INSERT INTO isn_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","nai nikatula munzila matungo a mung'wi, Mutemi, nikihenga welu kupuma kilunde nai watula utaki kukila i mpasu hangi ukelya ku upilimikiilya unene ni antu nai atula atungile u muhinzo palung'wi nu nene. ");
INSERT INTO isn_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Usese kihi nai kikagwa pihi, ai nigulye luli lukitambulya nu nene luzeligitya mu ntambu a Kiebrania; 'Sauli, Sauli ku niki ukunaja? Ingi ikaku kitalako ku ukua ilambi u mushokoo. ");
INSERT INTO isn_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Papo nikaligitya, 'U ewe ingi nyenyu, Mukulu? uMukulu akasukiilya, ' Unene ingiYesu naiza ukunaja. ");
INSERT INTO isn_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Itungili humbuka wimike ku migulu ako; nsoko ku isigo ili unene nigeeleka kitalako, nukuhoie kutula wi munya mulimo hangi mu kuiili migulya a makani naiza ulingile kutula unene itungili ni makani ni nikakulagiila panyambele; ");
INSERT INTO isn_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","hangi Nikakuguna kupuma ku antu ni anyaingu niize ku ulagiilya, ");
INSERT INTO isn_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","kupitya i miho ao nu kuaheja mu kiti kulongola mu welu nu kupuma mu ngulu nia mulugu amupilukile Itunda; iti alije kusingiilya kupuma kung'wa Itunda ulekelwa nua milandu nu usali naza nia inkiiye awo nai niabague ku uhuiili nu ukoli kitalane. ");
INSERT INTO isn_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Iti gwa, mutemi Agripa, shanga ai nihumile kupiluka u muloto nua kilunde, ");
INSERT INTO isn_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","kuiti, ku awo niakoli mu Dameski hanza, ni uugwa ku Yerusalemu ni ihi ihi nuku Yudea, hangi ga ku antu ni a mahi mangiiza, ai ntanantilye kina ile itunu nu kumupilukila Itunda, itume i ntendo ni itakiwe kila itunu. ");
INSERT INTO isn_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ku nsoko iyo i Ayahudi ai amambile mi itekeelo, akagema kumbulaga. ");
INSERT INTO isn_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Itunda unzaiiye kupikiila itungili, iti gwa nimikaa nu ku kuiila ku antu nia nakanda nu ku awo niakulu migulya a ayo naiza anyakidagu nu Musa ai aligitilye akupumila ni shanga ingiiza; ");
INSERT INTO isn_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","kina uKristo kusinja ukagigwa hangi ukutula wang'wandyo kiuka kupuma mu ashi nu kutanantya u welu ku Ayahudi nu ku anyaingu. ");
INSERT INTO isn_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","uPaulo nai wakamala kitambuilya, uFesto ai uligitilye ku luli lukulu, 'Paulo, u ewe wi muhali! kilingi kako kakutendilee utule wimuhali. ");
INSERT INTO isn_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Kuiti uPaulo akaligitya, Unene shanga ni muhali, mukulu Festo; kuiti ku ugimya kuligitya i makani nai a tai ntili. ");
INSERT INTO isn_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ku nsoko mutemi ulingile kutula i makani aya; ni iti, kuligitya ku ulyuuku kitalakwe; ku nsoko ili shanga ai litumilwe anga ku mpelo. ");
INSERT INTO isn_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Itii, uhuiie i anyakidagu, Mutemi Agripa? Ningile kina uhuiie. ");
INSERT INTO isn_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","uAgripa akamuila uPaulo, 'Ku itungo ikupi uhumile kumpema unene nu kuntenda ni Mukristo? ");
INSERT INTO isn_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","uPaulo akaligitya, “Kumulompa Itunda kina, ku itungo ikupi ang'wi ilipu, shanga u ewe du, ila ihi ga niantegeeye i lelo, atule anga unene, kuiti bila minyororo iyi na kadulumu.” ");
INSERT INTO isn_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Uugwa u mutemi ai wimikile, nu liwali, nu Bernike ga, ni awo nai akoli ikie palung'wi ni enso, ");
INSERT INTO isn_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","nai ahegile mu ugalagalo, ai itambuie enso ku enso nu kuligitya, 'Muntu uyu shanga utakiwe insha ang'wi kitungo. ");
INSERT INTO isn_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","uAgripa akamuila uFesto, “Muntu uyu aza uhumile kuikwa ilyuuku anga aza wahite kutema u rufaa kung'wa Kaisari.” ");
INSERT INTO isn_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Nai ilamuwe kina itakiwe kutunga muhinzo ku mazi kulongola ku Italia, ai aminkiiye uPaulo ni atungwa angiiza kung'wa afisa ung'wi nua idale nila Kiroma nai witangwaa Julio, nua idale lang'wa Agustani. ");
INSERT INTO isn_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Kikanankila i meli kupuma ku Adramitamu, naiza ituile itunge muhinzo mu mpelo mpelo a nshemba a Asia. Iti gwa ki kingila mu luzi. uAristaka kupuma ku Thesalonike a ku Makedonia akalongola palung'wi nu sese. ");
INSERT INTO isn_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Luhiku nai lutyatile kikasimya u ludigi mu kisali nika ku Sidoni, naiza uJulio ai umutendee uPaulo ku ukende nu kumulekela kulongola ku ahumbauya akwe kusingiilya u ukende nuao. ");
INSERT INTO isn_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kupuma papo kikalongola mu luzi kikatunga u muhinzo kupilimikiilya i kisiwa nika Kipro naiza katuile kiku kingama u ng'wega, ku nsoko u ng'wega ai watulaa ukugilinkiiye. ");
INSERT INTO isn_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Ze yakilaa kutula katunga u muhinzo mu mazi nakoli pakupi ni Kilikia ni Pamfilia, kikapembya ku Mira, kisali nika Lisia. ");
INSERT INTO isn_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Pang'wanso u afisa uyo nu idale nila Kiroma, akamihanga i meli kupuma ku Alexandria naiza ituile ikatunga muhinzo kutunga ku Italia. Akakunankilya mukati akwe. ");
INSERT INTO isn_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Ze yakilaa kutula katunga u muhinzo ku uembeelu ku mahiku idu ni panyambele kikatula kapika ku lwago pakupi ni Kinidas, u ng'wega shanga wikakulekela hangi kutunga i nzila nanso, itigwa kikatunga u muhinzo mu mpelo mpelo a mululi nua ku Krete kize ku ukigamile u ng'wega, kuhumbeela ni Salmone. ");
INSERT INTO isn_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Kikatunga u muhinzo mu nshemba ku ukaku, kupikiila kianza nai kitangilwe Fari Haveni naiza kikoli pakupi ni kisali nika Lasi. ");
INSERT INTO isn_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Ai katulaa kaholaa matungo idu nangaluu, ga ni itungo nila kuhita kulya nila Kiyahudi ai latulaa lakila, ni itungili ai yatulaa ulugu kulongoleka nu muhinzo. Iti gwa uPaulo aka kuhugula, ");
INSERT INTO isn_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","nu kuligitya, “Agoha, kihenga u muhinzo naiza kuloilwe ku uhole ukutula nu ubii nu u ulya widu, shanga udu ku miligo ni meli, kuiti ga nu ku likalo litu.” ");
INSERT INTO isn_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Kuiti u afisa nu idale nila Kiroma akamutegeelya ikilo u mukulu nuakwe nu mukola hiu nua meli, kukila i makani ayo naiza akutambulwa nu Paulo. ");
INSERT INTO isn_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ku nsoko i bandari shanga ai atulaa kipango kitontu kikie itungo nila ulyuuku, ia baharia idu akasija kutunge u muhinzo kupuma pang'wanso, iti ku mpyani ihi anga kuhume ku kipikiila i kisali nika Foenike, kikie pang'wanso itungo nila u ulyuuku. Foenike ingi bandari uko ku Krete, hangi igozee hukuma kilya ni takama kilya. ");
INSERT INTO isn_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","U ng'wega nua takama nai wandilye ku kunka ku uembeelu, ia baharia akasigiila alija iko naiza atulaa akiloilwe. Akipa u ludigi nu kutunga u muhinzo mpelompelo a Krete pakupi ni nshemba. ");
INSERT INTO isn_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Kuiti ze yakilaa itungo ikupi ng'wega utaki, nuitangwaa nua hukuma kilya, ukandya ku ukua kupuma itumbi nila kisiwa. ");
INSERT INTO isn_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Matungo i meli nai ihumeeigwe nu kuleng'wa ku ugilinkiilya u ng'wega, ki kigombya ni hali yiyo kikatwalwa muhinzo nu wenso. ");
INSERT INTO isn_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Kikamanka kukiila u ng'wega nuanso nkika nai atulaa ikuukingila ung'wega nua kisiwa nikitangwaa Kauda; ni ku lwago nangaluu ai kuligilye ku uguniilya u mutumbwi. ");
INSERT INTO isn_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ze yakilaa kutula kamilutaa, ai atumie ludigi kumitunga i meli. Akitumba kina kuzeehuma kulongola mu kipango nika mahalu idu nika Syiti, iti gwa akasimya u ludigi hangi ai alongoigwe mu mpelo mpelo. ");
INSERT INTO isn_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Kika kuwa ku ngulu nangaluu nu kimpupu, itigwa luhiku nai lutyatile ia baharia akandya kuguma i miligo kupuma mu meli. ");
INSERT INTO isn_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Mahiku a taatu, ia baharia akandya kumapumya i mazi ku mikono ao akola. ");
INSERT INTO isn_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Matungo naiza ilyoa ni nzota shanga ai yukalikie ku mahiku idu, ikili u kimpupu mukulu ai ukukuile, ni isumbiilyo kina kikagunwa ai li limie. ");
INSERT INTO isn_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Ze yakilaa kutula alongolaa matungo malipu bila ndya, pang'wanso uPaulo akimika pakati a abaharia akalingitya, “Agoha, mutakiwe muntegeelye, hangi shanga aza kuziipa u ludigi kupuma ku Krete, iti kulija aya u ulugu nu ulimili. ");
INSERT INTO isn_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ni itungili kumupoeelya mipe inkolo, ku nsoko shanga ikutula nu ulimili nua likalo kati anyu, kwaala ulimili nua meli du. ");
INSERT INTO isn_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ku nsoko utiku nuakilaa malaika wang'wa Itunda, naiza Itunda uyo unene niakwe, ga ni hangi naiza nimipoelya - malaika nuakwe ai wimikile pa mpelo ane ");
INSERT INTO isn_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","nu kuligitya, “Leka kitumba Paulo. Kusinja wimike ntongeela ang'wa Kaisari, hangi goza, Itunda mu ukende nuakwe ukinkiiye awa ihi naza atungile u muhinzo palung'wi nu ewe. ");
INSERT INTO isn_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Iti gwa, agoha, ipi i nkolo, ku nsoko nu muhuiie Itunda, kina ikutula anga nintambuiwe. ");
INSERT INTO isn_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Kuiti kusinja kuaalike ku kukuwa mu ing'wi nia isiwa.” ");
INSERT INTO isn_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Nai ipikile u utiku wigengu, nai ikatula kulongoigwe kunu nu kunu mu luzi nula Adratik, anga u utiku nu igengu iti, abaharia ai asigile kina ahumbeela kihi ni nyumu. ");
INSERT INTO isn_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ai atumie mililo kugemela kina ulundu nua imazi nu kulija mita makumi a taatu ni mutandatu, ze yakilaa itungo ikupi akagemela hangi akalija mita makumi abiili ni mupungati. ");
INSERT INTO isn_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ai itumbile hanza kuhumile kukumpa matalagwe, iti gwa akasimya i nanga inne kupuma mu nkika a kuikila i nanga hangi akalompa kina idau aza izee kaya kuza. ");
INSERT INTO isn_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Awo i abaharia ai atulaa akuduma mpyani a kumigumaniilya i meli nanso hangi akasimya mu mazi i boti ni niino niino nia kugunila u likalo, hangi akitendisa kina akuguma nanga kupuma mu nkika a kuntongeela a boti. ");
INSERT INTO isn_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Kuiti uPaulo akamuila u asikali uyo nuidale nila Kiroma ni asikali awo, “Shanga mukuhuma kugunika kwaala antu awa niakusiga mu meli,” ");
INSERT INTO isn_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Uugwa i asikali awo akatinanga i ndigi nia boti izo nu kulekwa iholwe ni mazi. ");
INSERT INTO isn_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Matungo u welu nua kidau dau nai watula ukupumila, uPaulo aka asinja ihi ageme kulya iniino. Akaligitya, “Ulu luhiku nula ikumi na inne mulindiie shanga mukulya, mukili kulya i kintu. ");
INSERT INTO isn_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Iti gwa kuminena muhole indya iniino, ku nsoko iyi ingi kunsoko a kikie kitalanyu; hangi kutili ga nu lusingi lung'wi mu matwe anyu nulukulimila. ");
INSERT INTO isn_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Nai wakondya kuligitya nanso, akahola u mukate akamulumba Itunda ntongeela a miho a kila muntu. Uugwa akau ega u mukate akandya kulya. ");
INSERT INTO isn_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Uu gwa ihi akakuiligwa inkolo ni enso akahola indya. ");
INSERT INTO isn_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Ai katulaa antu 276 mukati a meli. ");
INSERT INTO isn_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Nai akondya kulya nu kikuta, ai amizipilye i meli kutula mpepeele ku kuguma i ngano mukati a luzi. ");
INSERT INTO isn_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Nai ikatula mung'wi, shanga ai amilingile ihi ni nyumu, kuiti akihenga kipango kihi ni nyumu nai kingie mukati a mazi nai katula ni mahalu idu. Akitambulya anga ize ahumile kumilongolya i meli kutunga pang'wanso. ");
INSERT INTO isn_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Iti gwa akaitolya i nanga akailekela mu luzi Mu itungo lilo liilo akaitolya i nanga nia itanga nu kumihumbula i nkika a kuntongeela kutunga mu ng'wega, iti gwa akatunga mu nkika a mahalu idu. ");
INSERT INTO isn_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Kuiti akapembya kianza naiza ukiilo ubiili nua mazi utankanie, ni meli ikatunga mu mahalu. Ni nkika iyo na ntongeela a meli ikakigama pang'wanso shanga ai ihumile kupuma, Kuiti i kipango nika ntongeela a meli kikandya kubunika ku nsoko a utaki nua maingu. ");
INSERT INTO isn_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Isigo nila asikali awo ai latulaa la kuabulaga i atungwa, iti kina kutili nai uziipumpa nu kutigana. ");
INSERT INTO isn_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Kuiti u asikali uyo nu idale nila Kiroma ai uloilwe kumuguna uPaulo, iti gwa akimisha i masigo ao; nu kulagiilya awo nia humile kipumpa, apute kupuma mu meli hanza nu kulongola kihi ni nyumu. ");
INSERT INTO isn_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Uugwa i agoha ni angiiza akutyata, i auya migulya a ipande nia mabada ni auya migulya a intu ingiiza kupuma mu meli. Ku nzila iyi ikapumila kina ihi kuupika iziza kihi ni nyumu. ");
INSERT INTO isn_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Nai kikapikigwa iziza, kikalinga kina i kisiwa kitangwaa Malta. ");
INSERT INTO isn_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Antu akola kisali a pang'wanso shanga udu kina ai akinkiiye ukende nua nakanda, ila ai a ikiiye u moto nu kuusingiilya kihi, ku nsoko a mbula nu ulyuuku nai atula ilongolekile. ");
INSERT INTO isn_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Kuiti uPaulo nai wakatula wilingiila i miligo a nkwii nu kuikila mu moto, nzoka ni niino nikete uhungu akapuma mu nkwi nianso ku nsoko a uwo u upyu, hangi akipalingiilya mu mukono nuakwe. ");
INSERT INTO isn_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Antu akola ihi a pang'wanso nai akihenga kikali kining'iniie kupuma mu mukono nuakwe, akitambulya enso ku enso, “Muntu uyu kulu kuulu ingi mubulagi naiza utiganile mu luzi, kuiti tai ane shanga imulekee kikie.” ");
INSERT INTO isn_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Kuiti u ng'wenso akakigumila i kikali iko mu moto hangi shanga ia uligilye u ulugu wihi. ");
INSERT INTO isn_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ni anso ai amulindiie waimbe u ulwae ang'wi kupumpugiilya awagwe nu kusha. Kuiti ze yakilaa kumugozeela ku itungo ilipu nu kihenga kina kuitili ikani naiza shanga nila nakanda kitalakwe, ai akaie ni masingo ao nu kuligitya ai watulaa itunda. ");
INSERT INTO isn_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Uugwa kianza ni kanso pakupi ai ikoli ihi naiza atuile nsailo a mukulu nua kisiwa, muntu nui tangwaa Pabilo. Ai ukusingiiye nu ku ukendepa ku mahiku ataatu. ");
INSERT INTO isn_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Ai ipumie kina u tata wang'wa Pabilo ai uambilwe nu ulwae nua kupanza. Nu paulo nai umuhangile, ai ulompile, akaika i mikono migulya akwe, nu kumuguna. ");
INSERT INTO isn_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Ze yakilaa ili kupumila, ga ni antu angiiza pang'wanso mu kisiwa nai atulaa akuawa ai alongoe nu kugunwa. ");
INSERT INTO isn_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Antu aka kukulya ku ikulyo lidu. Nai katula kuihamba kutunga u muhinzo, ai akinkiiye izo nai kuiloilwe. ");
INSERT INTO isn_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Ze yakilaa myeli i taatu, ai kutungile u muhinzo mukati a meli a Iskanda naiza atulaa ikuilwe mpepo papo mu kisiwa, naiza ia lukolongo akwe ai atulaa aluna abiili mintuti. ");
INSERT INTO isn_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Ze yakilaa kutula kasimaa mu kisali nika Sirakusa, ai kikie papo mahiku ataatu. ");
INSERT INTO isn_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Kupumiila papo ai kutungile u muhinzo kikapika mu kisali nika Regio. Ze yakilaa luhiku lung'wi ng'wega nua takama kupumpugiilya ukapumila. hangi ze yakilaa mahiku abiili kikapika mu kisali nika Putoli. ");
INSERT INTO isn_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Kung'wanso ai kuahangile ang'wi a anyandugu hangi aka kusingiilya kikie kuko mahiku mupungati. Ku nzila iyi kikapembya ku Rumi. ");
INSERT INTO isn_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Kupuma kuko awo i anyandugu, Ze yakilaa kutula ijaa inkani ni itu, ai apembilye ku usingiilya uko ku soko nila Apias ni dalimu itaatu. uPaulo nai wakaihenga anyandugu awo ai umulumbile Itunda aki ikilya ukamatiku. ");
INSERT INTO isn_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Nai ki kingila ku Roma, uPaulo ai ulekewe kikie wing'wene palung'wi nu asikali uyo nai watulaa ukumusunja. ");
INSERT INTO isn_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Uugwa ai yatulaa ze yakilaa mahiku a taatu uPaulo ai uitangile palung'wi i agoha awo nai atulaa a lukolongo mu kati a Ayahudi. Nai akapembya ku palung'wi, ai uligitilye kitalao, “Anyandugu, palung'wi ni kina nkili kituma utumuli wihi ku antu awa ang'wi kituma nsuta ni ntendo nia atata itu nai akutongee, nikapumigwa anga mutungwa kupuma ku Yerusalemu kupikiila mu mikono a Arumi. ");
INSERT INTO isn_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ze yakilaa kunkolenkeelya, ai ahumilwe i nsula kundeka ilyuuku, ku nsoko ikatula kutili nsoko kitalane unene ni intakile upisiliigwa nua nsha. ");
INSERT INTO isn_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Kuiti awo i Ayahudi nai aligitilye nsuta a nsula ao, nikisinja kutema rufaa kung'wa Kaisaria, angaitule shanga ai yatulaa anga kina kuleta usemi migulya a anyaigu ane. ");
INSERT INTO isn_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ku nsoko a kutema kitalane u rufaa, iti gwa, ai nompile kuihenga nu kuligitya nu nyenye. Ingi ku soko a iko naiza u Israeli ukete ukamatiku ku nikanso, natungwa ni kitungo iki. ");
INSERT INTO isn_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Uu gwa akamuila, “Kukili kaya kusingiilya ibada kupuma ku Yudea ku utula u ewe, ang'wi kutili muluna nuazile nu kupumya upikiligwa ang'wi kuligitya lukani lihi nu lubi kutula u ewe. ");
INSERT INTO isn_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Kuiti kuloilwe kija kupuma kitalako usigile ntuni kutula idale ili nila antu awa, ku nsoko ikumukile kitaitu kina likuligitya nsuta kila kianza. ");
INSERT INTO isn_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Nai atulaa abague u luhiku ku nsoko akwe, antu idu ikilo ai amuhangile i kianza nai watulaa wikie. Ai uligitilye ikani ilo kitalao nu ku kuiila kutula utemi nuang'wa Itunda. Ai ugemile kuapema kutula uYesu. ku mpyani yihi ibiili kupuma mu malagiilyo ang'wa Musa nu kupuma ku anyakidagu, kandiilya kidau ndau kupikiila mpindi. ");
INSERT INTO isn_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Ang'wi ao ai apemekile kutula makani ayo nai atambuwe, itungo i auya shanga ai ahuiie. ");
INSERT INTO isn_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Nai aki igwe kilinga enso ku enso, ai ahegile ze yakila uPaulo kuligitya ikani ili ling'wi, “Ng'wau Ng'welu ai uligitilye iza kukiila uIsaya munyakidagu ku atata itu. ");
INSERT INTO isn_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Ai uligitilye, 'Longola ku antu awa uligitye, “Ku akutwi anyu mukija, kuiti shanga mukulinga; Nu ku miho anyu mukihenga kuiti shanga mukumanya. ");
INSERT INTO isn_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ku nsoko a nkolo nia antu awa yatuile nyeku, akutwi ao ijaa ku lwago, atutilye i miho ao; iti kina aleke kulinga ku miho ao, nu kija ku akutwi ao, nu kulinga ku nkolo niao, nu kupiluka hangi, hangi ai nzee aguna.” ");
INSERT INTO isn_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Ku lulo, mutakiwe kulinga kina uwu ugunwa nuang'wa Itunda watawee ku anyaingu, hangi akutegeelya.” (Komaniilya; ulukiili ulu, ");
INSERT INTO isn_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","“Itungo nai watula ukuligiya i makani aya, i ayahudi ai ahegile, aze atuile nu wikungumi ukulu mukati ao,” umutili mu mbugulu ni nziza nia kali). ");
INSERT INTO isn_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","uPaulo ai wikie mi ito nilakwe nila kugula ku myaka ihi ibiili, hangi ai uasingiiye ihi nai azile kitalakwe. ");
INSERT INTO isn_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Ai watulaa ukutanantya u utemi nuang'wa Itunda hangi ai watulaa ukumanyisa makani migulya a Mukulu uYesu Kristo ku ukamatiku wihi. Kutili nai umugiiye. ");
INSERT INTO isn_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Paulo, mitumi wang'wa Yesu Kilisto naiwitangilwe kutula mituma milimo, nukimikigwa kunsoko ainjili ang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Iyi yiyi aaiuaie ikali kukiila unyakidagu akwe mumaanko nimaza. ");
INSERT INTO isn_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Ingi yuyu naing'waakwe nautugilwe kupuma mukoo wang'wa Daudi nautugilwe ikumuili. ");
INSERT INTO isn_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Nuanso autanantigwe kina ng'wana wang'wi Tunda. Kungulu nia nkolo ninza kuuki washi Yesu Kilisto mukulu witu. ");
INSERT INTO isn_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Kukiila ng'wenso kasingiilya ukende nuitumi nua ugombi wa uhuili nua mahi ihi kunsoko alina lakwe. ");
INSERT INTO isn_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Muma hi aya, ingi nunye mitangilwe kina miatu ang'wa Yesu kilisto. ");
INSERT INTO isn_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ibarua iyi ingi kua ihi niakoli Kurumi, ni Tunda ualoilwe, nailangilwe kina antu niaza niagila imilandu, nuukende utule kitalanyu, nuupolo kupuma kung'wi Tunda, Tata witu nu mukulu Yesu Kilisto. ");
INSERT INTO isn_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Ng'wandyo, namumba Itunda wane mung'wa Yesu Kilisto kukiila nyenye mihi, kunsoko uhuili wanyu ukutanatigwa unkumbigulu wihi. ");
INSERT INTO isn_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Kunsoko Itunda mikengi wane, ninimitumila munkolo ane kulukani lang'wana akwe, anga niza nimikila kuata imina ao. ");
INSERT INTO isn_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Mahiku ihi nilompa imalompi ane kunzila yihi sunga nihume kupata kulowa wang'wi Tunda kuza kitalanyu. ");
INSERT INTO isn_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Kunsoko nkete insula akumuona nikume kumpa unyenye ipegwa nia munkolo, nihume kumkamatisha. ");
INSERT INTO isn_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Ingi kipumbulya palung'wi nunye, kua nzia akila uung'wi witu, naneniyo nanyu. ");
INSERT INTO isn_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Itungili anyandugu singandoilwe muulye kija inkani, nizandoilwe muulye kiza kitalanyu, ingi iza ngiigwe sunga nitungili, aindoilwe itula iti muhume kutula ninda kitalanyu anga imahi nimangiza. ");
INSERT INTO isn_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Ndaigwe nia Yunani, niageni, niahugu nia pungu. ");
INSERT INTO isn_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Kululo kunkigi ane unene ngombile kutanantya ulukani lang'wa Yesu kitalanyu unye nimukoli kung'wanso Kurumi. ");
INSERT INTO isn_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Singa kuluhumilwa iminyala ulukani lang'wa Yesu, kunsoko uhumi wang'wi Tunda nuileta uguniki kua uyu nuhuie, kung'wa Muyahudi nu kung'wa Muyunani. ");
INSERT INTO isn_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Kunsoko uhuili wang'wa Tunda wakunukula kupuma uhuili nu huili anga niyandikilwe, umunya tai ukikie kuauhuili. ");
INSERT INTO isn_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Nsoko utaki wang'wi Tunda wigeeleka kupuma kilunde nsoko au bi wihi nua antu nuakumigilya itai. ");
INSERT INTO isn_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Kunsoko aya ihi namanyikila kung'wi Tunda akunukulwa kitalao, nsoko Itunda waalagiila. ");
INSERT INTO isn_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Inkani yakwe nishayigela kiisa, yigee kupuma naukuumbwa unkumbigulu. Amanyikile kukiila maintu naakumbwa. Imakanu aya au humi wakwe nuamahiku ihi nung'wandyo wakwe. ");
INSERT INTO isn_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Naiamulinga Tunda shaikamukulya anga Tunda nukumsingiilya, ikalimila muteele ninkolo yao ikizula upungu ikatula ni kiti. ");
INSERT INTO isn_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ikiitanga kina ahugu, sunga ikitula apungu. ");
INSERT INTO isn_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Akaukaila ukulu wang'wi Tunda nimugila uugazanji kumpya ni kelu la muntu numugazanji, niya na nyunyi, niye naikali, nizi niyagula pihi. ");
INSERT INTO isn_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Kululo itunda akaaleka atyate insula ya nkolo yao nia ubi sunga kitegelya ikulyo nila miili ao. ");
INSERT INTO isn_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Kunsoko aiapiue itai ang'wi Tunda kutula uteele, ikatula makulu nukumatumikila imaintu kukila Itunda nauaumbile nuikuligwa mahiku ihi. Amina. ");
INSERT INTO isn_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Kunsoko iyi itunda akaateka atyate insula yao nia minyala kunsoko iasungu ao aiakaie uitumili nuamiili ao ni Tunda auaumbili nianso ikapiula. ");
INSERT INTO isn_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Ingi niitunja nienso ikapiula uitumili kuasungu ao, akapatwa ninsula nimbi ya itunja kua itunja nisinga inonee hangi Tunda akaapa ulamula nua ubi wao. ");
INSERT INTO isn_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Kunsoko aiahitile kutula ni Tunda muma hala ao, akaaleka atyate imahala nisinga maza, ituma ayo nisinga amuloeeye Itunda. ");
INSERT INTO isn_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Izue uubii wihi, nsula nuubi, izue uwilu, ubulagi, wileu, wikongi ni masigo nimabi. ");
INSERT INTO isn_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Ikatula kitambula uubi, kitegeta nukumuhukilwa Itunda. Niakete uwilei, widai, nu kiona kina enso kila kintu, anonelya mabi niagila ikulyo kua leli ao. ");
INSERT INTO isn_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Nianso agila uuhugu, abunangi malagiilyo, agila uulowa nuang'wandyo hangi agila ikinya uwai. ");
INSERT INTO isn_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Alingile u imalagiilyo nang'wi Tunda kina awa niituma intendo izi ni mbi ulamulwa wao kunsha. Kululo gwa singa ituma udu inkani izi, ingi iza igombilyo nao niituma inkani nianso. ");
INSERT INTO isn_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Kululo wimugila uiteteli uewe ni wiapeza iantu ulamulwa, kunsoko ayo niwialamuila niangiza uewe niaza peza iantu uulamulya wituma nkani zizo zizo. ");
INSERT INTO isn_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Ingi kulingila kina ulamulwa wang'wi Tunda ingi watai kuantu niituma inkani anga nianso. ");
INSERT INTO isn_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Kululo uewe siga ili, ue nualamula ao niituma inkani nianso, kunu nuewe wituma zizozizo, kulunge uziza uutiga ne ulamulwa wang'wi Tunda? ");
INSERT INTO isn_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Ang'wi usigile inino kuuza nua udu wa uza wakwe, kutiya upilya wakwe nu gimya wakwe? Singa ulingile kina uuza wakwe. Unonee kuumanyisa uungami nuamunkolo. ");
INSERT INTO isn_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Kunsoko aukaku wako ninkolo ako ningila uugombi ukiikilya uewe imbago nia ubi kuluhiku ulo nula ubi. Ingi uluhiku ulo nulaukunukulwa pa ulamuli wa tai nuang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Nuanso uzepumya ukinya mulimo anga intendo yako naiwituma muunkumbigulu. ");
INSERT INTO isn_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Awa naituma iza intendo yao yaapeza lukumo luza ikolyo nukuhita kugazika. Uzeapa utemi wamahiku ihi. ");
INSERT INTO isn_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Kululo ao niagila itai, nishaigombi itai ilowa uubi ulaki wang'wi Tunda upembilye. ");
INSERT INTO isn_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Itunda ukuleta uubi nuagi kumuntu naiwitumile imilandu, kung'wa Muyahudi hanza nukung'wa Muyunani. ");
INSERT INTO isn_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Kululo lukumo nuluza, ikulyo nuupolo ukiza kumuntu nuitumile nimaza, kumu uyahudi hanzo nu kumuyunani. ");
INSERT INTO isn_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Kunsoko kutile anga wiguniili kung'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Kunsoko anga naiauiye bila ulamulwa akulimila singa azeakoli mulamulwa anga wawa niidu naiauiye niakite uulamulwa azizapegwa uulamulwa tai. ");
INSERT INTO isn_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Kunsoko singa iji aunonelya nuatai pantongeela ang'wi Tunda. ingi ao niituma unonelya niazepegwa itai. ");
INSERT INTO isn_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Kunsoko iantu amunkumbigulu, niagila unoneelya, akituma kunkani ya unoneelya, nianso aile unoneelya ankolo yao hangi nianso agila anga unoneelya. ");
INSERT INTO isn_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Kua ili akulagiila intendo niitakiwe munoneelya wa nkani wandikilwe munkolo yao, hangi inkolo yao yeenda singa, nimasigo ao akenda asemela ienso, ");
INSERT INTO isn_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","hangi Itunda ayo azipumula mumahiku ni Tunda uzeitamula inkunkuni ya antu ihi kunsoko alukani lakwe naigula nulang'wa Yesu Kilisto. ");
INSERT INTO isn_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Kulunge gwa weendi itanga wi Myahudi, naiwikie muzeepilya wawa nkani lumbiilya kikulya kung'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Ulinge ulowa wakwe, nukusiga inkani nishayimpyani ni ninyanso, anga walagiligwa nu nanelya wa nkani. ");
INSERT INTO isn_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Kulunge kina ueweukite ugimya uewe hangi wimutongee wa apoku, wilu mulikua ao nikuli mukiti. ");
INSERT INTO isn_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Mumanyisi wa apungu, mmanyisi wa ang'enya hangi utite munonelya nua uhugu nua tai. ");
INSERT INTO isn_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Uewe gwa nuimutanantilya numungiza, uewe sha wimanyisa nuewe? Ue nuitanantya kuleka kia uewe wia ne? ");
INSERT INTO isn_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ue nuiluga leka kugoolya, wigoolya ne? ");
INSERT INTO isn_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ue nuikulya milago shawimuhumya ni Tunda iminyala kubunanga ilago? ");
INSERT INTO isn_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Kunsoko ilina lang'wa Itunda likuhumigwa minyala kuantu nishanga ahuie kunsoko anyu, anga naiyandikilwe. ");
INSERT INTO isn_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Kunsoko kutalwa kukidamu ni ka tai inonea anga wizugombile kilago, kuhulo uewe ang'wi wimubunangi ilago kutwala kukidamu kung'wako izeze nakanda. ");
INSERT INTO isn_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ang'wi umuntu nisinga utawi kukidamu ulongolekile kukie milago. Kuhita kutwalwa kukila kitalakwe ukutula kina singa utawe kukidamu? ");
INSERT INTO isn_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Nuyu nisinga utwawe kukidamu puma ung'wandyo, singa ukutula lamula anga akondyo kuamba ilago? Iye ingi kunsoko akoli naandikilwe kilago kunu akili mubunangi wi lago. ");
INSERT INTO isn_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Kunsoko uyu singa Muyahudi nukoli muhali akunzi, hangi kukidamu singa uko nia koli kunzi du kimuiili. ");
INSERT INTO isn_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Kululo nuanso Myahudi nuamkati ni lago nila munkolo mung'wang'waung'welu, singa miandiko. Ulukumo la muntu anga uyu shalipumiila anga kuantu lipumaa kung'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Umuyahudi ukiongeelya ntuni? Ukupata ntuni kukidamu? ");
INSERT INTO isn_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Inonee nangulu kunzila yihi, ng'wandyo wa ihi layahudi aapewe ukunukuilwa kupuma kung'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Ikutula uli gwa Iauyahudi niang'wi aiagila uhuili? Kuhita kuhuila kung'wao uuza wang'wi Tunda utule wanakanda nee. ");
INSERT INTO isn_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Kutile kuee leki Tunda igeleke kutula watai, ataize kila umuntu utaale. Anga naiyandikilwe kina uhume kutula wimunya tai minkani yako, hangi uhume kukila kupuma muulamulwa. ");
INSERT INTO isn_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Ingi igaitula ubii witu wigeelekila mtai ang'wi Tunda. Kulunge ntuni. Itunda singa mubi na nuipumya utaki wakwe, iti gwa, ukoli uu ne? Kuligitya kunsoko akiuntu. ");
INSERT INTO isn_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Kutile lukulu, ukutula ule itunda kuupa uulamulwa unkumbigulu? ");
INSERT INTO isn_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Kululo ang'wi tai ang'wi Tunda kukiila uteele wane, ukigeeleka kukiila ng'wenso, kuniki nkili kupegwa ulamulwa anga nimunya milaandu? ");
INSERT INTO isn_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Kuniki kulunga anga naikutungeigwe niantu kina kenda lunga, kitume nimabi nimaza aza”? uulamulwa wao ingi wa tai. ");
INSERT INTO isn_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Kuileteela ntuni, kutile lukulu. Kunsoko usese kihambile kuasemela Ayahudi nia Yunani ihi palung'wi akoli mumilandu. ");
INSERT INTO isn_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Iyi ingi anga naiyandikilwe, kina kutile ata nung'wi nukete itai. ");
INSERT INTO isn_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","kutile ata nung'wi nulingile. Kutile umuntu ata nung'wi nukumupenza Itunda. ");
INSERT INTO isn_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Ihi agaza, ihi palung'wi aulya ana uza. Kutile nuituma nimaza, ata ng'wi. ");
INSERT INTO isn_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Imakolomelo ao ingi ibiila niying'walyi inemi yao yakong'wa. Inkungu ya nzoka ikoli pihi amilomo ao. ");
INSERT INTO isn_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Imilo yao yizue masatiko nuu wai. ");
INSERT INTO isn_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Imigulu ao ikete ntambo yakuhunula. ");
INSERT INTO isn_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Ugaziki nuuhita kuhuila ukoli munzila yao. ");
INSERT INTO isn_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Iantu awa akili kulinga inzila aupolo. ");
INSERT INTO isn_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Kutile anga wao kung'wi Tunda kuntongeela a miho ao. ");
INSERT INTO isn_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Kulengile ayo ihi naligitilgwe nilago iligitigwa kuantu niakoli pihi ilago. Nsoko imilo ihume kukunikilwa, nuunkumbigulu wihi uhume kupegwa uulamulwa ni Tunda. ");
INSERT INTO isn_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Iyi ngi kunsoko kutile muili nuuzepegwa itai kuntendo niyi lago ntongeela amiho ao. Kukiila ilago wiza uhugu wamilandu. ");
INSERT INTO isn_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Kululogwa itungili itai ang'wi Tunda igeeleka pana kulili ilagiilyo, aikengilwe kuamalagiilyo nia nyakidagu. ");
INSERT INTO isn_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","kululo ingi tai ang'wi Tunda kukiila uhuili mung'wa Yesu Kilisto kuantu ihi niahuie. Kunsoko kutile uiholani. ");
INSERT INTO isn_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Kunsoko ihi itumile milandu, nukukepelwa muukulu wang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Apewe natai nakanda ukende akwe kunzila au guniki nukoli mung'wa Kilisto Yesu. ");
INSERT INTO isn_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Itunda aumupumilye u Yesu Kilisto autule muungami kunzila au ungami nua sakami akwe. Aumupumilye Ukilisto anga wikengi wa tai akwe. kunsoko akuheja milandu natongee kitung'wa. ");
INSERT INTO isn_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Ahume kulagiila itai akwe namatungo aya, atule muntu watai, nukuailigwa itai nuanso numuhuie Yesu. ");
INSERT INTO isn_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Ikolipi gwa kikulya? Yalugailwa kunzi, kilago ke? kilago la ntendo? Ingi kilago ni la uhuili. ");
INSERT INTO isn_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Kululo kumailya umuntu wipegwa itai kua uhuili singa kuantendo ni yilago. ");
INSERT INTO isn_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Ang'wi Tunda izi Tunda wa Ayahudi du ne? Ang'wi singa izi Tunda wa antu nia mihi? Ingi iza wa antu ihi nia mihi. ");
INSERT INTO isn_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Anga itule tai Itunda izu ng'wi ukua ailya tai niauza kua uhuili, nao nisinga atawe kukidamu kunzila. ");
INSERT INTO isn_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","usese gwa kuliheja ni lago kua uhuili? Shanga kuheja use kuulikonda niilya ilago. ");
INSERT INTO isn_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Kuulunga ntuni hangi kina Abrahamu, tata witu nukimuili, wigelaa? ");
INSERT INTO isn_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Ang'wi Abrahamu aupewe itai kunsoko antendo, auzetula ni nsoko akikulya, ingi singa kuntongeela ang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Iti imaandiko akulunga uli? Abrahamu aumuhuie Itunda, kilalakwe ikatula muntu wa tai. ");
INSERT INTO isn_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Kumuntu nuitumile umulimo, ikinyamulimo kakwe shakialigwa kina ukende, ingi izi daigwa. ");
INSERT INTO isn_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Kululo kumuntu nishawituma umulimo kunu umu huie uyo uku nukumupa itai nishanga muntu wang'wi Tunda uuhuili wakwe umuntu uyu waalikwa kutula watai. ");
INSERT INTO isn_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","U Daudi ingi waligitya ukembetwa wa muntu ni Tunda wimuailya itai panakutili intendo. ");
INSERT INTO isn_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Akalunga akembetwa ao nuubii wao nualekelwa ni milandu ao akunikilwa. ");
INSERT INTO isn_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Akembetwe umuntu uyu ni Tunda shukumuailya imilandu. ");
INSERT INTO isn_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Iti gwa ukembetwa uwu ingi kuao ni tawe kukidamu du, ang'wi nao nishatawe kukidamu? Kunsoko kuulunga. Kung'wa Abrahamu uuhuili wakwe aikuaigwe kina watai. ");
INSERT INTO isn_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","iti auaigwe uli? Matungo nu Abrahamu aukoli mukidamu, ang'wi aakili kutwalwa kukidamu? Singa aikoli kutwala kukidamu, ingi kuhita kutwalwa kukidamu. ");
INSERT INTO isn_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Abrahamu ausingilye kulingasiilyo ni kakudamu. Iki ai kilingasiilyo ni kitai nikauhuili naakili kutwalwa kukidamu. Kuumailyo wa kilingasiilyo iki, ingi akutula tata wa antu ihi niahuiie ata izeakoli mukidamu. Iyi ingi ikualigwa tai kitalao. ");
INSERT INTO isn_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Iyi hangi ainoneeye kina Abrahamu atule tata wa kidamu singa udu kina ao niapumie mukidamu, ingi nao niaityatile impambatilyo yang'wa tata witu Abrahamu. Nuwu wuwu uhuili naukite kuantu nishaatawe kukidamu. ");
INSERT INTO isn_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Kunsoko singa ai miko kina ilago ailipumiigwe kung'wa Abrahamu nuwilehi wakwe. Ilago ili kina azetula asali amihi ingi kuleka ihi atuile kukiila tai au huili. ");
INSERT INTO isn_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Kunsoko ang'wi ao nia miko wawo asali uhuili watula nakanda ni lago labipa. ");
INSERT INTO isn_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Kunsoko imiko ileta kubipilwa kululo apo nikutile imiko, ikulyo iza kutile. ");
INSERT INTO isn_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Kunsoko aiyi iti ili lipumila kua uhuili, ingi litule laukenda, iliitigwa litule ilago niligeelekile kuwileli wihi, hangi aleki kutula wawa du nialingile imiko, naoga niauhuili wang'wa Abrahamu. kunsoko uyuite tata witu kihi. ");
INSERT INTO isn_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Anga naiyandikilwe, “Nakuika uewe kutula tata wa mahi idu. Abrahamu aukoli mung'wa uyo nauhuie, ingi Itunda uyu nuiapeza uupanga iashi nuitanga inkani nikutile ihume kigela. ");
INSERT INTO isn_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Palung'wi ninkani yidu niakunzi, Abrahamu akimika muhuili wang'wi Tunda mumakani ihi na mahiku napembilye. Kulola akatula tata wa mahi idu anga nailigitigwe. Uu ukutula uwileli wako. ");
INSERT INTO isn_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Nuanso singa aimunino ikiuhuili. Abrahamu akalunga kina umuili wakwe aiwakondya kusha aiwagomba nikululika kusha inda anga Sara. ");
INSERT INTO isn_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Kunsonko autite ilago lang'wi Tunda, Abrahamu singa akisinsila kuhita kuhuila ingi akizuligwa ingulu ya uhuili akamukulya Itunda. ");
INSERT INTO isn_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Aumanyile kina iko naupewe ilago ni Tunda aukete ingulu yakuikondamilya. ");
INSERT INTO isn_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Kululo iyi ikialigwa kitalakwe kina tai. ");
INSERT INTO isn_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Ingi gwa singa andikilwe kitalakwe du, ingi aiaigwe kitalakwe. ");
INSERT INTO isn_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Ingi aiyandikilwe kunsoko itu, kuantu ao naiaikiigwe ialo la kualigwa; usese nikuhuie kung'wa uyo naumukilye umukulu witu Yesu kupuma kuashi. ");
INSERT INTO isn_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Uyu ingi yuyu naupumiigwe kunsoko amagazo itu nu kuukigwa kuhuma kupegwa itai. ");
INSERT INTO isn_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Kunsoko kapegwa itai kunzila auhuili, kutite uupolo ni Tunda kunzila ang'wa mukulu witu Yesu Kilisto. ");
INSERT INTO isn_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Kua kukiila ng'wenso kwa nzila auhuili muukende uwu kitalakwe kuimika. Kuloilwe kunsoko auhuili nukupee Itunda kunsoko amahiku napembilye, nikuihanguila muukulu wang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Sunga uu du ingi kulowe muagigwi witu. Kunsoko kuine kina uagigwa wituga wimiki kuawa niilindiila. ");
INSERT INTO isn_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Uulindiili witugo ugombeki nu gombeki wituga ugimya kunzila na mahiku napembilye. ");
INSERT INTO isn_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Uugimya uwu shawikepya insula kunsoko ulowa wang'wi Tunda uhunuiwe munkolo yetu kukiila ng'waung'welu uyu naupumigwe kitaitu. ");
INSERT INTO isn_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Ungi apo naikukili kiagila ingulu, imatungo ikapika, Ukilisto akasha kunsoko aunyamilandu. ");
INSERT INTO isn_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Ingi ibi umuntu kusha kunsoko amuntu ni munya tai; kululo ihumikile umuntu kugema kusha kunsoko amuntu numaza. ");
INSERT INTO isn_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Ingi Tunda walagiila uulowa wakwe kitaitu kunsoko naaikili kukoli mumilandu Ukilisto aukule kunsoko itu. ");
INSERT INTO isn_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Ingi gwa agakutule kapegwa itai kukiila sakami akwe kuugunika kukiila lilo kupuma muutaki wang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Kulola gwa ang'wi imatungo naikialugu kikakamantanigwa ni Tunda kunzila ansha ang'waakwe hangi anga kakondya kukamatanigwa kugunika kunzila aupanga wakwe. ");
INSERT INTO isn_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Singa uu du, ingi kuloilwe kung'wi Tunda kukiila Yesu Kilisto, kukiila ng'wenso kasingiilya uiungamili uwu. ");
INSERT INTO isn_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Kulola gwa ang'wi kukiila muntu ung'wi imilandu aingie mihi, kua mila iyi isha aingie kukiila milandu. Ni nsha ikenda kuantu ihi kunsoko ihi aitumile imilandu. ");
INSERT INTO isn_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Kupuma ung'wandyo nuamiko, imilandu aikoli muunkumbigulu, kululo imilandu singa ialigwa pana kutile imiko. ");
INSERT INTO isn_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Ingi insha ai temile kupuma kung'wa Adamu ikapika sunga kung'wa Musa, nao ga nisinga ailumile imilandu, kunsoko ang'wa Adamu nauuiye ikulyo, mpyani ang'wa uyo nuuziza. ");
INSERT INTO isn_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Kululo ang'wi uu, isongeelyo la nakanda singa angi gazo, angwi gazo la muntu ung'wi idu aiakule, uukende wang'wi Tunda ni kipegwa nikikoli kuukende wake muntu ung'wi yesu Kilisto kongeelekile kunsoko kuantu ao niidu. ");
INSERT INTO isn_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Kululo isongeelyo singa ailizile kung'wa uyo naiwitumile imilandu, kunkigi ningiza, ikipegwa kanakanda nikiza kuuailigwa nuatai aikizile kumagazo nidu. ");
INSERT INTO isn_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Ingi gwa kukiila igazo la muntu ung'wi, insha ikenela kukiila ung'wi, ingi gwa ao nikusingiilya uukende nuidu palung'wi nikipegwa nikatai akuamba uutemi kukiita upanga wang'wa Yesu Kilisto. ");
INSERT INTO isn_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Ingi gwa, ang'wi kukiila igazo la muntu, antu ihi akatwalwa muulamulwa, kukiila witumi ung'wi nuatai ikahuma kuleta tai naupanga kuantu ihi. ");
INSERT INTO isn_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Kuhita kutula nikulyo kumuntu ung'wi idu akatula akoli mumilandu, kululo kukiila ikulyo la muntu ung'wi, idu akutula akoli mtai. ");
INSERT INTO isn_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Kululo imiko aingie palung'wi igazo lihume kusambaila. Apo nimilandu aiongeelekile kutula idu, Uukende ukatula widu kukilinkila. ");
INSERT INTO isn_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Iyi ingi aipumie kina, anga imilandu naihoile utemi wa insha, uuingi nuukende uhumile kuhola utemi kukiila tai kunsoko a upanga nuakilunde kukiila Yesu Kilisto Mukulu witu. ");
INSERT INTO isn_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Kulunge ntuni gwa? Kulongoleka kikie mumilandu ukende wongeeleke kutula widu? ");
INSERT INTO isn_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Singa uu. Usese naikushie mumilandu, kuhumile ne hangi kikie mumilandu? ");
INSERT INTO isn_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Shamulingile ne ao naiabadisigwe kung'wa Kilisto aiabadisigwe kukiila nsha akwe. ");
INSERT INTO isn_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Aikuikilwe palung'wi nung'wenso kukiila ubatizo wa sha. Iyi aitulikile anga Ukilisto nauukigwe munsha kukiila ukulu wang'wa Tata. Ingi nusese kuhuma kugenda muupanga nuupya. ");
INSERT INTO isn_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Kunsoko anga naikukamantanigwa palung'wi nung'wenso kumpyani ansha akwe, hangi kukamantanigwa muuki wakwe. ");
INSERT INTO isn_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Usese kuine iti umuili witu nuakali aiwagigwi palung'we nung'wenso, ingi umuili wa milandu uhume kugazangigwa, iyi ingi aizile kuleka kulongoleka kutula kianya milandu. ");
INSERT INTO isn_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Uyu naukule watuile munya tai kunsoko walakanukile ni milandu. ");
INSERT INTO isn_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Ang'wi aikule palung'wi nu Kilisto. Kuhuie kina kuzikie palung'wi nung'wenso. ");
INSERT INTO isn_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Kumanyile kina Ukilisto auukile kupuma kuashi, singa ukutula mushi hangi, kitalakwe insha ahiile. ");
INSERT INTO isn_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Insha akwe ai sha amilandu, aukule kang'wi kunsoko aantu ihi. Kululo kuupanga uwu nuikie, wikie kunsoko ang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Kunzila yiyoyiyo, nunyenye inonee mualigwe kina miashi amilandu, kiapanga kukiila Itunda nu Yesu Kilisto. ");
INSERT INTO isn_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Kunsoko nanso leka kumigombya imilandu ikie mumuili wako, ihume kuikulya insula yakwe. ");
INSERT INTO isn_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Leka kuupumya umuili wako mumilandu anga iseme ningila itai, ingi ipumya uewe kung'wi Tunda, anga niapanga kuhega muushi. Hangi pumi imiili anyu anga iseme nia tai kung'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Leki kugomba imilandu umuambe, kunsoko mikutile mumiko, ingi mukoli muukende. ");
INSERT INTO isn_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Ntuni gwa? Kitume ne imilandu kunsoko kikutili pihi amiko, ang'wi pihi aukende? Singa uu. ");
INSERT INTO isn_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Shanga muine kitalakwe nimipumilye anga metumi ingi nyenye muzetula meitumi akwe, nuanso nimunonee kumukulya? Iyi ataize kiasese amilandu nikutwae muushi ang'wi usese nuakuli kuutwala mutai. ");
INSERT INTO isn_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Ingi akuligwe Itunda kunsoko kunsoko ai kianya milandu, itungili ukete ikulyo munkolo yanyu kua umanyisigwa uo naimupewe. ");
INSERT INTO isn_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Malekewe kupuma mumilandu, hangi matula miatugwa atai. ");
INSERT INTO isn_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Kuligitya iti kiuntu kunsoko ansula miili anyu. Anga naimupumilye imiili anyu ku ubi, itungili pumi imiili anyu kutula atugwa atai muhume kegigwa mele. ");
INSERT INTO isn_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Apo naimianya milandu, aizamulekewe kuli ni tai. ");
INSERT INTO isn_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Imatungo nanso, amuukete lielya kii, kwa nkani izo itugili nimenda inonela iminyala kuiona? Kunsoko impelo ankani izi ingi nsha. ");
INSERT INTO isn_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Kululo itungili mapegwa uulekelwa mahega mumilandu hangi matula meitumi kung'wi Tunda, mkete ndya kukiila wigigwa wang'wi Tunda nukupikiila upana nua kali nakali. ");
INSERT INTO isn_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Kunsoko ikipegwa kamilandu ingi nsha nuuza wang'wi Tunda upanga nuakali nakali kung'wa Yesu Kilisto Mukulu wetu. ");
INSERT INTO isn_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Ang'wi aluna ane (shawilengile kunsoko kuligitya niantu niamimanyile imiko), kina imiko imikaila umuntu nikili mupanga? ");
INSERT INTO isn_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Kunsoko umusungu nutinilwe witungwa ni miko amugoha wakwe nikile mupanga, umugoha wakwe aga she ukutula wahega mumiko na kulinwa. ");
INSERT INTO isn_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Kululo gwa umugoha wakwe angatule mupanga, hangi umutinile musungu mungiza ukitangwa mugoolya, ingi gwa umugoha wakwe agosha nuanso ukutula wahega mumiko, nuanso singa ukutula mugoolya kikie numugoha mungiza. ");
INSERT INTO isn_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Kululo aluna ane amuukilwe kuashi kunsoko a miko kunzila amuili wang'wa Kilisto, itulikile iti muhume kukamantanigwa kitalakwe. Kung'wa uyu nauukile kupuma kuashi kunsoko kuhume kumulugile Itunda indya ninza. ");
INSERT INTO isn_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Naikili kukoli ikimuili, insula ya milandu aieujikitwe mumiili anyu kunzila a miko nukumitugila insha indya. ");
INSERT INTO isn_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Ingi itungili kalunguilwa kupuma mumiko. Kahegeka muushi uo naiwi kugilya, kuhume kituma muupya nuang'waung'welu, nu sese kuhegeka miandiko nila kali. ");
INSERT INTO isn_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Kulunge uligwa? Imiko iza milandu? Kutile. Angainihite kulinga imilandu, angaizesinga kunzila amiko. Kululo singa ainezelinga kulowa anga imiko aihite kulunga leka kutula nuulowa nuubi. ");
INSERT INTO isn_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Ingi imilandu aihoile lyoma ilo nililago ikaleta insula yihi kitalane nikulowa, kunsoko imilandu igiulye imiko akuza. ");
INSERT INTO isn_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Unene ainimupanga ung'wandyo naikutile imiko, kululo nailaza ilago, imilandu ikapantika uupanga, nune nikasha. ");
INSERT INTO isn_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Ilago ilo nailizeleta uupanga likapiluka kutula nsha kitalane. ");
INSERT INTO isn_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Kunsoko imilandu aihoile lyoma lilago hangi ikankonga. Kukiila ilago nilanso ikambulaga. ");
INSERT INTO isn_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Kululo imiko iza miziza, ni lago iziziza hangi atai, hangi iza nza. ");
INSERT INTO isn_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Iti gwa iyo nai nza ikatula nsha ane kitalane? Ileke kutula iti lukulu. Kululo imilandu ihume kigeeleka kina milandu lukulu, kukiila ilo niza. Aitetile nsha kitalane. Iye ingi kina kukiila ilago ili, imilandu aongeelekile kutula mbinangulu. ");
INSERT INTO isn_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Ingi kuine kina imiko uandilyo wakwe izaiza munkolo, kululo unene iza ni muntu wa kimuili. Naguigwe musese wa milandu. ");
INSERT INTO isn_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Kunsoko singa ningile iko nenikiawa shanikituma iko nizaniki ihukiwe kiko niluma. ");
INSERT INTO isn_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Kululo anga nitume iko nishanikilowa, ikutula nimigombile imiko kwia kina miza. ");
INSERT INTO isn_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Ingi gwa itungili singa nene itungili ingi nkolo ane ikinda tuma nilanso, ingi milandu nikie milalane. ");
INSERT INTO isn_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Kunsoko ningile kitalane, mumuili wane, shalikie ulukani nuluza. Kunsoko insula akintu nikiza ikoli kitalane ila gwa shakumipata. ");
INSERT INTO isn_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Kunso ilo niza nineliloilwe shanendalituma, ingi gwa ilo nibi nisineliloilwe lilo nilituma. ");
INSERT INTO isn_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Itungili ang'wi kituma ilo nishaniloilwe, singa nene nig'wene nizanazituma, ingi imilandu iyo nikie kitalane. ");
INSERT INTO isn_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Namanya kina ikoli imiko kitalane nakuhia kituwia nimaza, kululo uubi ukoli kitalane. ");
INSERT INTO isn_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Kululo namilumbiilya imiko ang'wi Tunda kunsoko au huili wane. ");
INSERT INTO isn_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Ingi namiona imiko nishimpyani numuili wane. Ikukua ulugu ni miko nimipya mumahala ane. Ikuntwala unene ntule nimusese wa miko amilandu nikoli mumuili wane. ");
INSERT INTO isn_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Unene nimuntu wa ukia nyenyu nuzenguna numuili uwu nua nsha? ");
INSERT INTO isn_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Kululo namulumbiilya Tunda. Kukiila Yesu Kilisto Mukulu witu. Kululo gwa. unene kuma hala ane kumitumila imiko ang'wi Tunda hangi ikimuiili kumitumila imiko amilandu. ");
INSERT INTO isn_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Kululo gwa kutile ulamulwa nuamilandu kuantu ao niakoli muung'wa Kilisto Yesu. ");
INSERT INTO isn_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Kunsoko imiko na gwa ng'waung'welu wa upanga uyo nukoli kung'wa Kilisto Yesu ambikile une kuli ni miko na milandu ni nsha. ");
INSERT INTO isn_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Kunsoko aiko ni miko ailemilwe kituma kunsoko aingila anga ngulu, Itunda aiwitumile. Aumulagiiye ung'wa akwe wing'wene kumpyani amuili wa milandu, atule isongeelyo lamilandu, hangi alongole amepe imilandu ulamulwa nua kimuili. ");
INSERT INTO isn_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Aiwitumile iti nsoko imalagiilyo na miko ahume kukondaniligwa kitaitu. Usese nishakimatyata aya nakimuili, ingi kua kutyata aya nang'wa ng'waung'welu. ");
INSERT INTO isn_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Awa niutyata umuili, isiga yaya namuili, kululo ao niityata namunkolo, imasigo yaya namunkolo. ");
INSERT INTO isn_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Kunsoko insula amuili ingi nsha, ingi insula amunkolo upanga nu upolo. ");
INSERT INTO isn_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Iyi ingi kunsoko insula iyi namuili iza awilei kung'wi Tunda, kunsoko iza ngila angi kulyo kumiko nang'wi Tunda hangi shikuhuma kumikulya. ");
INSERT INTO isn_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Ao niutyata umuili shaakumuloelya Itunda. ");
INSERT INTO isn_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Kululo gwa mikutili ikimuili ingi mukoli kinkolo. Ang'wi tai ung'waung'welu wang'wi Tunda wikie kitalanyu, kululo ang'wi umuntu mugila ung'waung'welu nuang'wa Kilisto, nuanso singa wakwe. ");
INSERT INTO isn_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Ang'wi Ukilisto ukoli kitalanyu. Umuili ukule kunsoko amilandu, ingi inkolo mpanga kunsoko ankani ya tai. ");
INSERT INTO isn_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Anga itule inkolo ang'wa uyo naumuushilye u Yesu kupuma kuashi wikie kitalanyu, nuanso yuyu naumuushilye Ukilisto kupuma kuashi ukumipa hangi imiili na ushi, upanga kunzila nang'wa ng'waung'welu wakwe, nuikie kitalanyu. ");
INSERT INTO isn_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Kululo aluna ane, usese kudaigwe, ingi singa kimuili kina kikie kunsoko kimuili. ");
INSERT INTO isn_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Ang'wi mikie kunsoko amuili, mahugeela kusha, angwa mikie kung'wa ng'waung'welu, maileka intendo niakimuili nunyenye mukutula miapanga. ");
INSERT INTO isn_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Anga wawa niidu nitongeelwa nung'waung'welu wang'wi Tunda, awa ingi ana ang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Kunsoko singa aiimusingiiye inkolo au sese hangi shamukogopa. Sunga mukasingiilya inkolo akula miana kukiila nanso kilila “Abba, Tata!” ");
INSERT INTO isn_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Ung'waung'welu ng'wenso wikonga palung'wi ni nkolo yetu kina kiana ang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Ang'wi kiana, ingi gwa kiashi hangi asali ang'wi Tunda. Nu sese kiasali palung'wi nu Kilisto, ang'wi kuaga nung'wenso nsoko kuhuma kukuligwa palung'wi nung'wenso. ");
INSERT INTO isn_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Kunsoko nuuaiyie uagi nuamatungo uwu kina singa kintu, iga nimpyanie nuukulu nuuzekunukulwa kitaitu. ");
INSERT INTO isn_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Kunsoko maintu idu azizalindiila kunsula ni nkulu kukunukuilwa kuana ang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Kunsoko maintu ili aikilwe muugaziki, singa kua kulowa ng'wenso, ingi kunsoko akwe ng'wenso nauiikila pihi amalago akwe. Nila muhuili. ");
INSERT INTO isn_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Uumbi wakwe nuenso ukulekelwa nakupumigwa musese nuagaziki, nukingiligwa mulekelwa nuakulu wa ana ang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Ingi kulingile kina imaintu ihi ingi ilwala nukaga nuwai palung'wi ni tungili. ");
INSERT INTO isn_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Singa uu du, ingi nuse ung'waung'welu numpya nuingie kitaitu ingi nusese kulwala munkolo yitu, kulindiie kutula kiana, ingi uguniki wa miili itu. ");
INSERT INTO isn_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Kunsoko aulindiili uwu aikugunilwe. Kululo ikintu naikilindiiwe anga kigela kutili ulindiili hangi kunsoko nyenyu uyu nuikilindiila iko nuikiona? ");
INSERT INTO isn_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Ingi iga kukilindiile ikintu nishakikiona kukilindie kua uhuili. ");
INSERT INTO isn_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Anga naikuumbilwe, ung'waung'welu nung'wenso wikuailya mugila ngulu witu. Kunsoko shakumanyile kulompa anga ninonee. Kululo ung'waung'welu ng'wenso wikulompeela kwa kulwala nishai humikile kuligitigwa. ");
INSERT INTO isn_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Nu ng'wenso nuilingula mumyoyo wilinga imahala namunkolo, ingi wilompa kunsoko aantu ao niahuie anga uulowa wang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Nusese kuine kina ao ihi niamuloilwe Itunda, nuanso ukituma nkani yihi palung'wi kuanza ao ihi naitangilwe kunsoko akwe. ");
INSERT INTO isn_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Kunsoko ao ihi auamanyile kupuma ung'wandyo, hangi auaholanilye kupuma ung'wandyo impyanigwe nimpyani nu ng'waakwe, ahume kutula mulelwa wa ng'wandyo mualuna nidu. ");
INSERT INTO isn_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Nao nauaholanilye kupuma ung'wandyo, nienso auitangile hangi. Nao nauitangile nianso akaailya akate itai. Nao nauaiye itai akaakulya. ");
INSERT INTO isn_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Kulunge uli gwa kunkani izi? Itunda ang'wi ukoli kukinge itu. Nyenyu nukukilinkila usese? ");
INSERT INTO isn_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Uyu nishukumuleka ung'waakwe ung'wenso, ingi aumupumilye kunsoko itu usese kihi ukuhita ule kuupa inkani ninza palungwi nung'wenso. ");
INSERT INTO isn_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Nyenyu nukua semela eimikigwa ang'wa Tunda? Itunda ng'wenso mukola kuapa itai. ");
INSERT INTO isn_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Nyenyu nuzeatwala milipo? Ukilisto Yesu ng'wenso naukule kunsoko itu, palung'wi nanso ihi akaukigwa. Hangi ukate uutemi palung'wi ni Tunda pani kulyo likoli, hangi ng'wenso wikulompeela usese. ");
INSERT INTO isn_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Nyenyu nuzekutemanula nu lowa wang'wa Kilisto? Ubi? Ang'wi ndwala, uagigwi, nzala, ang'wi kifwe, ang'wi ubi wa shigu? ");
INSERT INTO isn_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Anga naiyandikilwe, “Kuzizabulagwa mung'wi pi aikuaigwe anga inko yakusingwa. ");
INSERT INTO isn_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Kukiila aya ihi usese kumahumile kukiila uyu naukuloilwe. ");
INSERT INTO isn_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Kunsoko nahuma kulinga tai kina nsha ang'wi upanga, ang'wi amalaika, ang'wi maintu nakuli, ang'wi ngulu. ");
INSERT INTO isn_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","Ang'wi nakoli migulya, ang'wi nakoli pihi ang'wi kintu kilu, singa kikuhuma kuutemanula usese nuulowa wang'wi Tunda, uyu ni Kilisto Yesu Mukulu witu. ");
INSERT INTO isn_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Kuligitya itai mung'wa Kilisto, singa kuligitya uteele, imasigo ane akoli palung'wi nu ng'waung'welu. ");
INSERT INTO isn_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Kina ukoli ukia ukulu nuuwai nukilinkie munkolo ane. ");
INSERT INTO isn_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Ainihumile kulompa mpegwe isatiko nukuikwa kuli nu Kilisto kunsoko aluna ane, nialuna ane niakimuili. ");
INSERT INTO isn_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Nianso Aisraeli. Niatulikile kutula ana, au kulu amalagiilyo, ni songeelyo la miko, kumukulya Itunda ni lagiilyo. ");
INSERT INTO isn_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Nianso atongeeli nu Kilisto uzile kua ikulyo kuutugala umuili uwu. Nuanso Tunda wa maintu ihi. Hangi akuligwe mahiku ihi. Amina. ");
INSERT INTO isn_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Ingi singa kina imalagiilyo ang'wi Tunda alemilwe kupika. Nsoko singi antu ihi niaakoli kihiaku Israeli, iza muisraeli lukulu. ");
INSERT INTO isn_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Nukung'wa Abrahamu singa ai wileli wakwe lukulu. Kululo kukiila wileli wang'wa Isaka ukitang'wa. ");
INSERT INTO isn_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Iyi ingi, iana amuili ingi singa ana ang'wi Tunda. Kululo iana nii lago agizilwe anga ana awileli. ");
INSERT INTO isn_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Kunsoko ingi ulu lukani lilago, “Kumatungo aya nzile, hangi u Sara ukupegwa ung'wana.” ");
INSERT INTO isn_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Ingi singa lili du, nu Rebeka naiwapantika inda kumuntu ung'wi, Isaka tata witu. ");
INSERT INTO isn_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Kina iana aiakili kulelwa, hangi akili kituma lukani lihi nulu za ang'wi nulubi, ingi isigo lang'wi Tunda lihume kutula nu hola ni limike. Hangi singa kua ntendo, ingi kunsoko ang'wa uyo nuitangile, ");
INSERT INTO isn_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","ailigitigwe kitalakwe, “Umukulu ukumitumila numunino.” ");
INSERT INTO isn_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Anga naiyakondigwa kandikwa: “Nimsigile u Yakobo, une u Esau shanumuloilwe.” ");
INSERT INTO isn_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Kulunge uli gwa? Ukoli wioneli ne kung'wi Tunda? Kutile. ");
INSERT INTO isn_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Kunsoko ukulunga kung'wa Musa, zeee nkete kinyauwai kung'wa uyo ninzize nkite ukinyauwai, hangi nzenzo nkete ukende kung'wa uyo ninzempa ukende. ");
INSERT INTO isn_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Ingi gwa singa anga kunsoko ang'wa uyo nulakile, hangi singa kunsoko ang'wa uyo nuimanka, ingi kunsoko ang'wi Tunda uyu nuilagiila nakanda. ");
INSERT INTO isn_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Kunsoko imaandiko alungile kung'wa Farao, kina ainukimikilye kunsoko iyi nihume kulagiila ingulu yane kitalako, Ilina lane litanantigwe ihe ihi. ");
INSERT INTO isn_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Ang'wi uu uyu nuilowa kupegwa nakanda wipegwa nakanda ikinyauwai nuyu nuilowa kupegwa, wimupeza yaya nakutula wilugoha. ");
INSERT INTO isn_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Sunga ukulunga kitalane, kuniki nkili neenda ona igazo? Nyenye naulemig'we nimasigo akwe? ");
INSERT INTO isn_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Ue ng'wamuntu ue wi nyenyu nukumusukiilya Itunda? Kintu naikiumbilwe kimuile ne uyu naukiumbile ite unene? ");
INSERT INTO isn_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Ang'wi umuumbi mugila ingulu nia kuhola uulolo nukeehu nukuumba kiseme king'wi kitule kikulyo nikiuya kitule kigila ikulyo. ");
INSERT INTO isn_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Ntuni gwa naituile Itunda akahia kuteta utaki wakwe, nulagiila uhumi wakwe, akatula nugimya wilu akagumanilya ayo ihi naahumile kitung'wa kua ubi? ");
INSERT INTO isn_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Ingi anga niwitumile iti kina alagiile udu nua ukulu wakwe kuiseme niahumile kulekelwa, izo naiwakondilye kuinonelya kunsoko ukulu? ");
INSERT INTO isn_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Ingi sese naikitangile, singa iantu aku Ayahudi du, nao nishamumanyile Itunda ne? ");
INSERT INTO isn_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Anga nauliyo kung'wa Hosea: “Kuitanga iantu ane awa naisinga antu ane, nu mulowa wakwe uyu nishaiwimlowa. ");
INSERT INTO isn_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Hangi ikutula apo nauliiye kitalao, unye sha miantu ane, pang'wanso akitangwa ana ang'wi Tunda numupanga.” ");
INSERT INTO isn_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","U Isaya nung'wenso wenda pumya uhuli kua Israeli akazelunga, ialo la ana ang'wa Israeli ata lizelidu anga imahalu na muluzi, wawa naiasagie du azegunika. ");
INSERT INTO isn_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Kunsoko utata ukuluhola ulukani lakwe nula mihi, hangi ukukaya kulukondya. ");
INSERT INTO isn_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Anga u Isaya nauliiye ung'wandyo, anga Itunda wa uhumi nishaukulekee uwileli kunsoko itu, aikuzetula anga Isodoma, hangi aikuzitung'wa anga i Gomora. ");
INSERT INTO isn_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Kulunge uli gwa, iantu ao nishaiduma itai, aka lija itai, tai kua uhuili. ");
INSERT INTO isn_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","U Israeli palung'wi nukumilyata imikononi tai, shaiamisigile nukukela imiko nanso. ");
INSERT INTO isn_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Kuniki ikatula iti? Kunsoko shanga ai akumipenza kwa uhuili, ingi nantendo akakumpa migwe nala ukumpi. ");
INSERT INTO isn_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Anga naiyakondigwe kandikwa, “Goza, nalilalya igwe la kukumpa mu Sayuni nu migwe nila kuulya. Uyu nukuhuila kua ili shuzizila iminyala.” ");
INSERT INTO isn_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Aluna ane ayanondoeye munkolo ane kung'wi Tunda, kunsoko akugunika kung'wao. ");
INSERT INTO isn_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Kunsoko naza kumuila kina akazanile kunsoko ang'wi Tunda ingi gwa singa kunsoko auhugu. ");
INSERT INTO isn_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Kunsoko shaamanyile itai hangi akupenza ienso itai ienso, aiagila ikulyo la tai kung'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Kunsoko Ukilisto ng'wenso mpelo amiko kukiila tai a muntu wihi nuhuie. ");
INSERT INTO isn_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Kunsoko u Musa wandikile tai iye nukupumiila mu miko: “Umuntu nukoli mtai na miko ukikie kukiila tai yiyi.” ");
INSERT INTO isn_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Kululo itai nipumie muuhuili ilunga ite, “Uleke kulunga munkolo ako, nyenyu nukuluma kulongola kilunde? ");
INSERT INTO isn_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Iyi ingi kumusimya u Kilisto pihi. Hangi uleke kulunga, “Nyenyu nukusima mikombo?” (Iyi kumuhumbula u Kilisto kupuma kuashi) ");
INSERT INTO isn_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Kululo ikulunga uli, ulukani lukoli pakupi nuewe, mukimilo kako numumoyo wako nulanso ingi lukani la uhuili nikuulutanantya. ");
INSERT INTO isn_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Kunsoko kumulomo wako ugombile kina u Yesu tata hangi uhuie munkolo ako kina Itunda amuukilye kupuma muashi ukugunika. ");
INSERT INTO isn_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Kunsoko inkolo amuntu ihuila nukupantika itai nukuamulomo wakwe wigomba akapantika uguniki. ");
INSERT INTO isn_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Ingi gwa ulukani luhiiye, “Wihi nuhuie shuzepantika iminyala.” ");
INSERT INTO isn_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Kunsoko kutile impyani kina uyu muyahudi nuyu Muunani kunsoko utata yuyo yuyo wa antu ihi, hangi mugole wa antu ihi niimitanga. ");
INSERT INTO isn_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Wihi uyu nulihuie ilina lang'wa Tata ukugunika. ");
INSERT INTO isn_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Ikutulika ule ahume kumitanga nuanso nishaamuhuie? Hangi ikutulika ule kumuhuila uyu niakile kumija? Hangi akija ule ana ahite kutanantiligwa. ");
INSERT INTO isn_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Akuhuma uli kutanantya ulukani aga ahite kulung'wa Anga naiyandikilwe, imigulu ao miza kuantu ao nitanantya inkani ni ya ulumbi ni makani nimaza. ");
INSERT INTO isn_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Kululo ihi singa ulukani lang'wa Yesu kunsoko. U Isaya wilunga, “Utata nyenyu naiwigule ulukumo litu?” ");
INSERT INTO isn_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Kululo uhuili wiza kunsoko nukija kukiila lukani lang'wa Kilisto. ");
INSERT INTO isn_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Kululo kulunga, “singa aigule nee?” Ingi aigule. “Induli yeneela ihe ihi, ninkani yao yasambaila mumpelo ihe ihi.” ");
INSERT INTO isn_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Kululo kulunga, Iaisraeli singa aialingile nekiiza u Musa ukutambula, “Kuapa nsula kuantu ni singa amihi iye, kunzila niningila uhugu, nukuasongeela sunga atake.” ");
INSERT INTO isn_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","U Isaya ingi mugimya hangi wilunga, “Ainigelekile kuantu ao nishaipenza, nekigela kuantu ao nishaiantakile.” ");
INSERT INTO isn_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Kululo Uisraeli ukulunga, “Mahiku ihi aingooe imikono ane kuantu ao niagila ikulyo nao nia kaku ankolo.” ");
INSERT INTO isn_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Kukolya, Itunda auahitile ne iantu akwe? Ingi singa auahitile, ingi nunene ni Mwisraeli nua ukoo wang'wa Abrahamu, nui kabila lang'wa Benyamini. ");
INSERT INTO isn_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Itunda singa auahitile iantu akwe, aualingile kupuma ung'wandyo, iti shamulingile iandiko nuliliiye kung'wa Elia, naumulompile Tunda kuantu akua Israeli. ");
INSERT INTO isn_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","Utata waabulaga ianyakidagu ako, neenso akumulanga imakumbikilo ako. Nasaga ning'wene hangi akupenza upanga wane. ");
INSERT INTO isn_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Isukiilo lang'wi Tunda likulunga ntuni kitalako? “Naika kunsoko ako antu magana nzogu mupungati awa nishaumukulya Itunda wa unkumbigulu” (Baali). ");
INSERT INTO isn_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Kululo nimatungo nitungili akoli niasagiile kunsoko au holanigwa nua ukende. ");
INSERT INTO isn_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Kululo agaitule kuaukende, singa hangi kua ntendo, ang'wi ukendo singa utulo hangi ukende. ");
INSERT INTO isn_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Ntuni gwa? ulukani nu Israeli aukuluduma, singa akalupantika, ingi iaholanigwa kakipantika, niang'wi ikapegwa kiti aleke kuona. ");
INSERT INTO isn_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Anga niyandikilwe: “Itunda uapee nkolo au tu, imiho aleke kuona, nia kutye aleke kija sunga ni leliye.” ");
INSERT INTO isn_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","U Daudi nung'wenso ukulunga, “Leka imeza yao itule nyavu, mntego, nuakukumpa kunsoko awilei wao. ");
INSERT INTO isn_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Leka imiho ao apegwe ikiti aleki kuhuma kuona. Ulongole wendua tunye imigongo ao mahiku ihi.” ");
INSERT INTO isn_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Ingi gwa kulunga, akumpaa nee sunga agwiiza ileka kutula iti itunu. Ingi gwa kua kuleng'wa kitalao, uuguniki wapika kuantu nishaahuie, ingi nienso ahume kupegwa uwilu nuansula. ");
INSERT INTO isn_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Ang'wi kuleng'wa kitalao nsoko augole waunkumbigulu, hangi ang'wi kuulya kitalao kunsoko augoli wa anyakilungu ukondaniili kitalao ukutula ugeile uli? ");
INSERT INTO isn_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Itungile kuligitya nunye nimiantu amihe. Kunsoko naina nimitumi wa mahi mangiza, nainikuilya uitumi wane. ");
INSERT INTO isn_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Ang'wi kuapa nsula ao niamuili ung'wi nunene. Ang'wi niang'wi kua guna. ");
INSERT INTO isn_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Ang'wi kuhitwa kitalako wigombi wa mihi kusingiiligwa kitalao ikutula ule upanga kupuma kuashi. ");
INSERT INTO isn_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Ang'wi indya yang'wandyo iza kiuto nikiza, uu nili nila utu. Ang'wi umuli iza kiuto imataambi nimenso uu. ");
INSERT INTO isn_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Ang'wi imataambi ang'wi aatemilwe anga uewe itaambi nila muzeituni nuamihaka, nautemewe pakati ao, angwe aiwihanguie palung'wi nimihi augoli wa mizeituni, ");
INSERT INTO isn_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","leka kilumbiilya kunsoko amataambi, ang'wi ukilumbiilya, singa wewe wimiailya imili, imili ikuailya wewe. ");
INSERT INTO isn_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Kululo ukulunga imatambi aatemilwe kunsoko nihume kutemelwa. ");
INSERT INTO isn_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Tai ingi: Kunsoko akuhita kuhuila aiatemilwe, kululo uewe aiwimikile kunsoko auhuili wako, uleke kutula kihumbula migulya inonee kogopa. ");
INSERT INTO isn_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Kunso Itunda singa aumalekile imatambi na ng'wandyo, nuewe singa ukuhumila ikinya uwai. ");
INSERT INTO isn_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Goza gwa intendo ninza niang'wi Tunda nizi nintaki, uulaki auzile ku Ayahudi kunsoko naiagwie, kululo kuangiza, uuza wang'wi Tunda wiza kitalako ang'wi ukikie kuuza wakwe. Angaitule shanga uu nuewe ukuhitwa. ");
INSERT INTO isn_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Ang'wi singa akulongoleka kuhita kuhuila kitalao, akulemelwa hangi, kunsoko Itunda ukete uhumi nuakuatemela hangi. ");
INSERT INTO isn_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Kunsoko ang'wi anye amutemilwe kunzi kunsoko ang'wi ung'wandyo aimia muzeituni wamihala ni hangi ang'wi anutemewe ung'wandyo wa muzeituni nuza, ang'wi aikukila i Ayahudi, naatuile anga mataambi ang'wandyo kuhuma kutemelwa hangi mukati amizeituni ao? ");
INSERT INTO isn_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Aluna ane singantakile mulinge unkunku uwu, hangi muleke kutula nimahala nakusiga kitalanyu. Unkunku uwu upumie ukaku ku Israeli sunga kuukondaniili nua unkumbigulu nuuzile. ");
INSERT INTO isn_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Kululo Israeli ihi akugunika anga naiyandikilwe: “Kupuma Sayuni uzile Muguni ukuuheja uubi kupuma kung'wa Yakono. ");
INSERT INTO isn_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Nili likutula ilago lane palung'wi nienso. Matungo ninzaheja imilandu ao.” ");
INSERT INTO isn_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Kua lukumo nula lukani, atula alugu kunsoko anyu kululo kunsoko alukumo nulakung'wanso kimikigwa atula alowa kunsoko a Tata anyu. ");
INSERT INTO isn_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Kunsoko ikipegwa nu witang'wi wang'wi Tunda shawi kailika. ");
INSERT INTO isn_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Kunsoko ung'wandya aimamulekile Tunda kululo itungila mausingiilya ulekelwa wanakanda, kunsoko akumuleka Itunda kitalao. ");
INSERT INTO isn_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Kunzila yiyo yiyo i Ayahudi amulekile Itunda, kunsoko aimusingiiye ulekelwa nienso akusingiilya uulekelwa. ");
INSERT INTO isn_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Kunsoko Itunda ualungile iantuihi muubi, ingi ahume kuahumila ikinya uwayi. ");
INSERT INTO isn_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Anga niza ukulu uugole wakwe nimahala nu hugu wang'wi Tunda, shawilingika nu lamulwa wakwe ni nzila yakwe shayipenzeka. ");
INSERT INTO isn_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Nyenyu naumilengile insula ang'wa Tata? Ang'wi nyenyu naiwimusija? ");
INSERT INTO isn_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Ang'wi nyanyu naumupee ikintu ung'wandya nung'wenso ukulipwa hangi? ");
INSERT INTO isn_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Kunsoko maintu ihi apumie kitalakwe ikoli kua uhumi wakwe, hangi ukusuka kitalakwe, ukulu ukuli kitalakwe ikali na kali. Amina. ");
INSERT INTO isn_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Kululo kumulompa anyandugu kua ukende wakwe Tunda, pumi imiili anyu itule isongeelyo ni panga, niza niligombekile kung'wi Tunda. Ili lili ukuilyo lanyu nilikite insoko. ");
INSERT INTO isn_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Hangi leki kulyatiili na munkumbigulu uwu, ingi mupiulwe nukutula miapya ni masigo anyu. Itumi uu muhume kulinga ulowa wang'wi Tunda nuziza, nakumuloilya nuukondanili. ");
INSERT INTO isn_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Kululo kulunga, kunsoko aukende naimpewe kina muntu wihi nukoli mung'witu, shunonee kusiga nakoli migulya akwe kukila ninonee kusiga, ingi unonee kusiga kua mahala anga Itunda numupee kila umuntu kua uhuili. ");
INSERT INTO isn_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Kunsoko kutite ipango idu mumuili ung'wi ingi singa ipango yihi ikete mulimo ung'wi. ");
INSERT INTO isn_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Uu ingi nusese nikidu kimuili ung'wi kung'wa Kilisto, niungo king'wi kumuya. ");
INSERT INTO isn_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Kukite ipegwa niyilekee kukiila ukende naimupewe. Ang'wi ikipegwa kamuntu unyakidagu itulike kua uhuili wakwe. ");
INSERT INTO isn_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Anga itule ikipegwa ka muntu uaili nitume. Ang'wi numungiza ikipegwa kakwe kumanyisa ingi amanyise. ");
INSERT INTO isn_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Ang'wi kipegwa kamuntu ipumbulyo, ingi apumbulye ang'wi ikipegwa kamuntu kupumya, itume uu kua ukende anga itule kipegwa kakula mutongeeli atule nuukenge, anga itule kipegwa kakuona kinyauwai ingi itulike kutula ilumbi. ");
INSERT INTO isn_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Ulowa uleke kutula wakielya, uhukilwi uubi, muambiile nimaza. ");
INSERT INTO isn_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Kukiila ulowa wakiluna, ilowi nyenye kua nyenye kukiila ikulyo, mipe ikulyo nyenye kua nyenye. ");
INSERT INTO isn_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Mukagupe, muleke kutula miatolo, aya namunkolo. Mutule ninsula, kung'wa Tata mitumili. ");
INSERT INTO isn_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Lumbi mutule nugimya kumahiku napembilye, muzemulindie kumukulya nukimika mumalompi. ");
INSERT INTO isn_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Muze mukoli mumalompi naahuili, ipenzi inzila yidu niakulagiila ukende. ");
INSERT INTO isn_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Alompeeli ukembetwa awa ihi niimaja. Muakembete muleke kuapa imasatiko. ");
INSERT INTO isn_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Lumbiili nawa niza alumbiye, lili palung'wi nao niilila. ");
INSERT INTO isn_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Migombyo palung'wi unyenye kwa nyenye mleke kutula mzidaya, kululo agombi awa niakili adabu ikinkolo. Muleke kutula nuuhugu nua mumasigo anyu du. ");
INSERT INTO isn_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Muleke kumulipa muntu wihi kua kintu nikibi kua ubi. Itumi inkani ninza mumiho na antu ihi. ");
INSERT INTO isn_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Anga yahumika, anga naiiekilwe kitalanyu, mutule nuupolo niantu ihi. ");
INSERT INTO isn_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Alowa leki kilepishi naimigaziiye, pugamuki uutaki wang'wi Tunda. Kunsoko yandikilwe, “Uilipishi wane, nzeelipa ulungile utata.” ");
INSERT INTO isn_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Ang'wi umulugu wako ukete nzala, mulise. Agize ukete nyota mung'wense anga witume iti wamukensha makala amoto mitwe lakwe. ");
INSERT INTO isn_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Leka kuhung'wa nuubi, uhume uubi kua uza. ");
INSERT INTO isn_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Muntu wihi atule ni kulyo kuutemi nuukoli migulya akwe, nuutemi wihi upumie kung' wi Tunda. Nuutemi wihi uikilwe ni Tunda. ");
INSERT INTO isn_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Uyu nukugilya uutemi nuanso, ingi ukugilya utemi wang'a Itunda, nao niugilya akukusingiilya ulumulwa wao ienso. ");
INSERT INTO isn_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","kunsoko iatemi singa ikangilyo kuantu niituma nimaza, ingi kuituma mabe. Uloilwe kuluta kugopa ne uutemi? Itume nimaza ukulumbiiligwa. ");
INSERT INTO isn_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Ingi mitumi wang'wi Tunda kitalako kunsoko amaza, ang'wi ukituma aya nimabe. Ogope, kunsoko shukukenka upanga nitile insonko. Ingi mitumi wang'wi Tunda. Nuipumya utaki kuantu niituma uube. ");
INSERT INTO isn_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Inonee kutula nikulyo, singa kunsoko autaki, ingi kunsoko nayo nakoli munkolo ako. ");
INSERT INTO isn_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","kukiila iyi ukulipa impia, kunsoko iakola uhumi ufumi ang'wi Tunda awa nia longolekile kituma ulukani ulu. ");
INSERT INTO isn_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Mulipi wihi uyu numudaye, ang'wi mpia mumupe impia, ang'wi ahoela mpia ahoele, nuakogopwa, ogopwe, nuikulyo apegwe ikulyo. ");
INSERT INTO isn_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Leki kudaigwa kitu kihi numuntu, ingi milowe unyenye kua nyenye. Kunsoko uyu nizumuloilwe umunyakisali wake wamikondanilya imiko. ");
INSERT INTO isn_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Kunsoko, shukugoolya, shukubulaga, shukia, shukulowa, ang'wi likoli ilago nilulya likaminkanigwe nili, ukumulowa umunya kisali waka anga uewe nuilowa. ");
INSERT INTO isn_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Uulowa shamuaalya umunya kisali nua muntu kululo ulowa ingi wuwo ukondaniili wa miko. ");
INSERT INTO isn_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","kunsonko iyi iti mulingile kina apika imatungo nakuhega, mutulo, kunsoko. Uuguniki witu wa hugeela nangulu kukila imatungo ayo naikuhuie ung'wandyo. ");
INSERT INTO isn_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Utiku walongoleka nu ng'ung'we wahugeela, kuike kumpelo intendo nia kiti, hangi kutugale ishigi ya welu. ");
INSERT INTO isn_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Hangi kulongoleke muuza, kuzekukoli mu welu, singa muulumbili nuaubi ang'wi ugala magai. Hangi kuleke kulongoleka muugooli a ng'wi nsula nisinga ihumile kugiligwa, hangi singa muwisongeeli nu muwilu. ");
INSERT INTO isn_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Ingi kumutugale u Kristo hangi kuleke kuika ilyoma kunsoko amuili, kunsula yakwe. ");
INSERT INTO isn_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Musingili wihi nakili kukoma ikiuhuili, muleke kupumya ulamulwa nuamasigo akwe. ");
INSERT INTO isn_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Umuntu nukite uhuili ukulya kihi, uyu numungiza nakili kukoma ukulya inyenye du. ");
INSERT INTO isn_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Umuntu nuiliza kila ikintu, aleke kumudalaha uyu nishawiliza kila ikintu, nuyu nishawiliza aya ihi aleke kumupa ulamulwa uyu nuiliza imaintu ihi. Kunsoko Itunda wakondya kusingiilya. ");
INSERT INTO isn_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Uewe winyenyu, nukumupa uulamulwa uyu niza mitumi wa mutungwa wa muntu mungiza? Ungi pantongeela amukulu wakwe kina wimika ang'wi wigwiza, kululo ukuukigwa kunsoko utata uhumile kumisha. ");
INSERT INTO isn_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Umuntu wilukulya uluhiku lung'wi kukila ukulya, numungiza wikulya imahiku ihi kina impyani, ingi kila umuntu ikagule ung'wenso mumahala akwe. ");
INSERT INTO isn_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Uyu nizuambile uluhiku, uzuambile kunsoko ang'wa Tata, kunsoko wimupeeza masongeelyo Itunda, uyu nishawiliza wigilya kulya kunsoko ang'wa Tata, nung'wenso wipumya isongeelyo kung'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Ingi kutile nuikie kua nkolo akwe, hangi kutile nuikuza kunsoko akwe ung'wenso. ");
INSERT INTO isn_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Ang'wi kukete uupanga, kiapanga kunsoko ang'wa Tata, ang'wi kuusha, kuusha kunsoko ang'wa Tata, kululo ang'wi kutula kiapanga ang'wi kuusha kinsao yang'wa Tata. ");
INSERT INTO isn_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Kunsoko iyi Ukilisto aukule hangi nukutula mupanga hangi, kina atule Tata wa aihi kuashi nawa niapanga. ");
INSERT INTO isn_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Kululo gwa niki nukumutwala muulamulwa umuluna wako? Hangi niki nukumudalaha umuluna wako? Ingi use kihi kuzizimika pantongeela ni tuntu la ulamulwa kung'wa Tunda. ");
INSERT INTO isn_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Kunsoko yandikilwe, anga ninikie, “Uuliye utata,” kitalane malu ihi azetugama, ninema yihi izepumya ulukumo kung'wi Tunda.” ");
INSERT INTO isn_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Kululo muntu wihi uzepumya ialo lakwe kung'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Kululo kuleke kulongoleka kikensha ulamulwa ntongeela akwe temanula iti, kutile nukuika igiiligwa ni miutego kumuluna wakwe. ");
INSERT INTO isn_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Ningile hangi nagomba kung'wa Tata u Yesu. Kina kutile ikintu nikibi ikenso, ingi kung'wa uyu nusigile kina kihi kibi, kunsoko kitalakwe kibi. ");
INSERT INTO isn_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Ang'wi kunsoko andya umuluna wako ukisusumya, shuku genda hangi muulowa. leka kumugazanja nandya yako umuntu nai nsoko ang'wa Kilisto aukule. ");
INSERT INTO isn_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Kululo gwa uuza wanyu uzeleka kuligitigwa kua ubi. ");
INSERT INTO isn_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Kunsoko uutemi wang'wi Tunda singa kukiila ndya ni ng'wegwa, ingi kukiila tai, upolo, nu kulumba mung'wa ng'waung'welu. ");
INSERT INTO isn_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Kung'wa uyu nuimitumila Ukilisto kua iti ugombekile kung'wi Tunda hangi ugombekile nukuantu. ");
INSERT INTO isn_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Kululo gwa, kutyate inkani nia upolo ninizi niyi muzenga umuntu nimungiza. ");
INSERT INTO isn_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Uleke kugazanja umulimo wang'wi Tunda kunsoko andya, kutai maintu ihi iza maziza, ingi iza ibi kumuntu uyo nuiliza ikamusababisha kugaza. ");
INSERT INTO isn_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Iza kuleka kulya inyama, ang'wi kung'wa intuli, ang'wi kihi nikihumile kumutasha umuluna wako. ");
INSERT INTO isn_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Uhuili uwu nuutite, ieke kitalako nukungwi Tunda. Wakembetwa umuntu uyu nishanga ukikesha uulamulwa wakwe ung'wenso kua iko nukigombile. ");
INSERT INTO isn_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Uyu nukete uwoa wapegwa uulamulwa aga alule ukulya. Kunsoko shi pumie muuhuili. Hangi kitu nishakipumie muuhuili ingi mulandi. ");
INSERT INTO isn_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Usese nikukete ingulu inonee kukenka imilandu iyo naanyamilandu hangi singa inonee kielya kung'witu. ");
INSERT INTO isn_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Kihi mung'witu amuloelya umunya kisali akwe, ingi ikutula lukani luza nulakumzenga. ");
INSERT INTO isn_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Ingi Ukilisto singa aukielya ng'wenso, intongeela akwe ikatula anga naiyandikilwe. Ituki izo naiakulukie yampantika nene. ");
INSERT INTO isn_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Kihi naikitongee kandikwa, aikandikilwe kunsoko akuumanyisa, ingi gwa kukiila ulindiili nu kukiila kupegwa ngulu ni maandiko aikuzetula kimiho. ");
INSERT INTO isn_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","I Tundu nuaulindiili hangi nuaupumbuli ampe imasigo nimaza na mpyani ang'wa Kilisto. ");
INSERT INTO isn_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Ingi kua nkolo ing'wi nu mulomo ung'wi muhume kumukulya Itunda, Tata witu Yesu Kilisto. ");
INSERT INTO isn_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Kululo misiingiilye nyenye kwa nyenye, anga u Yesu Kilisto naukusingiiye. Kunsoko Itunda ahume kukuligwa. ");
INSERT INTO isn_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Kululo kulunga kina Ukilisto waikilwe kutula mitumi wa miko kukiila lai ang'wi Tunda. Aiwitumile ite ahume kuona imalago aya naiapumigwe nia tata itu, ");
INSERT INTO isn_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","niantu kumukulya Itunda kua ukende wakwe, anga niyandikilwe, “Kupumya lukumo mumahi nang'wi, nukimba kulina lako.” ");
INSERT INTO isn_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Hangi iliiye lowi unye antu amumahi palung'wi niantu akwe. ");
INSERT INTO isn_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Ni hangi mulumbiili utata unye mahi ihi; leka iantu amihi amukulye ng'wenso.” ");
INSERT INTO isn_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Hangi u Isaya uliiye, “Lizetula likoli itina la ng'wa Yese, hangi ung'wi uzeukigwa kutula mutemi wihi Niantu azetula nuuhuili kukiila ng'wenso.” ");
INSERT INTO isn_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Ingi gwa Itunda wa uhuili amizulye ulumbi wihi nuupolo kua kuhuila, muhume kutula nuhuili, kukiila ngulu yang'wa ng'waung'welu. ");
INSERT INTO isn_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Aluna ane, nkaminkiigwe unene mukola ku nkani nianyu nia kina unyenye nu nyenye mizue ukende, mizuigwe ulingi wihi, hangi mahumaa kihugula. ");
INSERT INTO isn_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Kululo kumandikila inkani izi kua kukomangiila kitalanyu muhume kukimbuka ukende naimpewe ni Tunda. ");
INSERT INTO isn_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","Ukende uwu aimpewe nlume kutula nimitumi wang'wa Yesu Kilisto naulagiigwe kuantu. Naiwipumilye anga mudimi wa lukani lang'wi Tunda. Ainihumile kituma iti, kipumya kung'wane itule ngombilwe itule yogigwa ni Tunda kukiila nzila ang'wang'welu. ");
INSERT INTO isn_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Kulolu ilumbi lane likoli kung'wa Yesu Kristo ni pa ntongee ang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Singa kugema kuta ulukani nishawitumile Kilisto ku kazi ane, iantu ahume kutula nikulyo kunkani ukuntendo. ");
INSERT INTO isn_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","Kungulu ya ilingasiilyo ni makuuilwa, nukuangulu yang'wa ng'waung'welu. Iyi ingi ai kupuma Kuyerusalem, nukupilimiila ku Iliriko, nihume kuhola kunzi ukondanili ulukani lang'wa Yesu Kilisto. ");
INSERT INTO isn_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Kunzila iyi unene singa ninzutanantya ulukani uko nu Kilisto watongee kutanantigwa nsoko ndeka kuzenga inkani nia muntu mungiza. ");
INSERT INTO isn_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Kululo anga naiyandikilwe, “Kukiila ngwenso agila anga lukumo lakwe auzila kuaona, nao nisingaaiamigule akumulinga. ");
INSERT INTO isn_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Kululo gwa aingieigwe mara du kuza kitalanyu. ");
INSERT INTO isn_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Ingi gwa itungili nimugila ilyoma hangi mihi iyi, hangi miaka idu iza ndoilwe kitalanyu. ");
INSERT INTO isn_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Mahiku ihi ninendo ku Hispania nihuila kuaona ninkiile nukutwalwa kunzila yane nunye, anga natula nalumbiilya palung'wi nunye kumatungo nanso. ");
INSERT INTO isn_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Itungili nauka ku Yerusalemu kua ailya ahuiili. ");
INSERT INTO isn_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Nsoko ainonee iantu Makedonia nawa nia Akaya kuahanguilya iahimbi awa niahuie kung'wanso ku Yerusalemu. ");
INSERT INTO isn_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Ingi aitulikile kua ulowa wao, hangi tai, atula adaigwa ao. Ang'wi awa nisha ahuie atula palung'wi nienso munkani nia munkolo nienso adaigwa kuaailya imaintu nialoilwe kupata. ");
INSERT INTO isn_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Kululo imatungo anga nakondyo iti nukutula nukondaniili wa ndya izi kitalao. Unene kukuila nunyenye kulongola ku Hispania. ");
INSERT INTO isn_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Ningile kina imatungo ninzile kitalanyu, nzile nukondanili nua ukembetwa wa Kilisto. ");
INSERT INTO isn_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Aluna ane, numulompile kukiila Tata wetu Yesu Kilisto, nukua ulowa wang'wa ng'waungwelu, kagupi palung'wi nune mumalompi anyu kunsoko anyu ntongeela ang'wi Tunda. ");
INSERT INTO isn_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Lompi nihume kugunika kupuma kua antu ao niagila ikulyo ku Yudea, nuitumi wane ku Yerusalemu uhume kusingiiligwa nia huili. ");
INSERT INTO isn_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Lompi nihume kuza kitalanyu nilumbi kukiila ulowa wang'wi Tunda, kulume kusupya palung'wi nunye. ");
INSERT INTO isn_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Ni Tunda wa upolo atule palung'wi nunye mihi. Amina. ");
INSERT INTO isn_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Namuika kitalanyu ng'waitu u Fibi adada witu, niza mitumi kitekeelo nilikoli Kenkrea, ");
INSERT INTO isn_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","muhume kumusingiilya kukiila tata. Itumi uu kua nulanso nula uza nua ahuili hangi mimike palung'wi nung'wenso kua lukani lihi nukutula uloilwe kupata kunsoko waina mitumi waantu idu nukunsoko ane hangi mitumi. ");
INSERT INTO isn_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Mulamushe u Priska nu Akila, itumi amilimo palung'wi nune kung'wa Kilisto Yesu. ");
INSERT INTO isn_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Kua upanga wane ikagazanja upanga wao, kupumya isongeelyo kitalao. Hangi singa unene du nukumatekeelo ihi namihi, ");
INSERT INTO isn_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Lilamushe itekeelo nilikoli kitakeo. Mulamushe Epanieto mulowa wane, numulelwa wang'wandyo kung'wa Kilisto ku Asia. ");
INSERT INTO isn_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Mulamushe u Mariamu naukagupile kituma imilimo kunsoko anyu. ");
INSERT INTO isn_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Mulamushe Androniko nu Yunia anyandugu ane, naiatungilwe palung'wi nunene, nawa naiahuiwe muitumi hangi naiatongee kumulinga Ukilisto asese kazekukili kumulinga. ");
INSERT INTO isn_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Mulamshe Ampliato, mulowa wane kung'wa Tata. ");
INSERT INTO isn_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Mulamushe Urbano, mituma milimo palung'wi nune kung'wa Kilisto, nu Stakisi mulowa wane. ");
INSERT INTO isn_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Mulamushe Apele, nugombilwe kung'wa kung'wa Kilisto. Alamushe ihi ao naiakoli mito lang'wa Aristobulo. ");
INSERT INTO isn_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Namushi Herodioni, ahumba iane, namushi antu niamito ang'wa Narkiso niakoli kung'wa Tata. ");
INSERT INTO isn_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Namushi Trifaina nu Trifosa, niakagupile kituma imilimo ang'wa Tata. Mulamushe u Persisi mulowa, nuitumile imilimo nidu kung'wa Tata. ");
INSERT INTO isn_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Mulamushe u Rufo, naiwimikigwe nu Tata nu ia wakwe palung'wi nuia ane. ");
INSERT INTO isn_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Mulamushe Asinkrito, Flegoni, Herme, Patroba, Herma nia aluna ihi niakoli nienso. ");
INSERT INTO isn_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Mulamushe Filologo nu Yulia, Nerea nu muluna wakwe nu Olimpa nia huili ihi niakoli palung'wi nienso. ");
INSERT INTO isn_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Alamushe ung'wiung'wi kua kualungila kuaza. Matekeelo ihi nang'wa Kilisto amulamusha. ");
INSERT INTO isn_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Itungile aluna ane kutuna kusige kiisa iantu akutemanuka, akutemela ni nkani nimbi. Enda atemanuka nayo naikumanyisigwe. Piluki muhege kitalao. ");
INSERT INTO isn_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Kunsoko iantu anga awashanga imitumila Ukilisto tata itumila inda yao. Kua nkani ninza, nia uteele akuikonga inkolo ni ngila imagazo. ");
INSERT INTO isn_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Kumpyani ni kulyo lanyu mapika mihi kululo nalowa kitalanyu, itungili nalowa kitalanyu mutule nimahala ni maza, muuleke kutula nimagazo pantongeela aubi. ");
INSERT INTO isn_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Itunda singa ukutinya kumulimansiilya umulugu kumpambatilyo yanyu. Uukende wang'wa Tata Yesu Kilisto utule palung'wi nunye. ");
INSERT INTO isn_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timoteo, mitumi palung'wi nune amulamusha nu Lukio, Yasoni nu Sospeter ahumba iane. ");
INSERT INTO isn_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Nene Tertio, ainandikile ibada ili, numulamukilye kulina lang'wa Tata. ");
INSERT INTO isn_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gayo, naunoneeye nukitekeelo lihi numulamukilye Erasto, muiki wa mpia wa muki sali, amulamushe, palung'wi nu Kwarto nai muluna. ");
INSERT INTO isn_vpl VALUES ("RM16_25","075_16_25",