﻿USE sofia;
DROP TABLE IF EXISTS sofia.isl_vpl;
CREATE TABLE isl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES isl_vpl WRITE;
INSERT INTO isl_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Mikil er gæfa þess manns sem ekki fer að ráðum óguðlegra, ekki á félagsskap við syndara sem hæða Guð, ");
INSERT INTO isl_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","heldur hefur unun af því að hlýða Drottni og íhuga orð hans dag og nótt, og þannig nálgast hann sífellt meira. ");
INSERT INTO isl_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Hann líkist tré sem stendur við rennandi læk og ber sætan ávöxt sinn á réttum tíma og blöð þess visna ekki. Slíkum manni tekst allt vel. ");
INSERT INTO isl_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","En hvað með syndarana? Það er önnur saga! Þeir fjúka burt eins og hismi undan vindi. ");
INSERT INTO isl_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Þeir munu ekki standast á degi dómsins né heldur í söfnuði réttlátra. ");
INSERT INTO isl_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Drottinn vakir yfir lífi og áformum hinna trúuðu, en vegur óguðlegra endar í vegleysu. ");
INSERT INTO isl_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Hvílík heimska að þjóðirnar skuli ráðast gegn Drottni! Furðulegt að menn láti sér detta í hug að þeir séu vitrari en Guð! ");
INSERT INTO isl_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Leiðtogar heimsins hittast og ráðgera samsæri gegn Drottni og Kristi konungi. ");
INSERT INTO isl_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","„Komum,“ segja þeir, „og vörpum af okkur oki hans. Slítum okkur lausa frá Guði!“ ");
INSERT INTO isl_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","En á himnum hlær Guð að slíkum mönnum! Honum er skemmt með þeirra fánýtu ráðagerðum. ");
INSERT INTO isl_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Hann ávítar þá í reiði sinni og skýtur þeim skelk í bringu. Drottinn lýsir yfir: ");
INSERT INTO isl_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","„Þennan konung hef ég útvalið og krýnt í Jerúsalem, minni helgu borg“. Hans útvaldi svarar: ");
INSERT INTO isl_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","„Ég mun kunngera áform Guðs, því að Drottinn sagði við mig: „Þú ert sonur minn. Í dag verður þú krýndur. Í dag geri ég þig dýrlegan“.“ ");
INSERT INTO isl_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","„Bið þú mig og ég mun leggja undir þig öll ríki heimsins. ");
INSERT INTO isl_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Stjórnaðu þeim með harðri hendi og mölvaðu þau eins og leirkrukku!“ ");
INSERT INTO isl_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Þið, konungar jarðarinnar! Hlustið meðan tími er til! ");
INSERT INTO isl_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Þjónið Drottni með óttablandinni lotningu og fagnið með auðmýkt. ");
INSERT INTO isl_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Fallið á kné fyrir syni hans og kyssið fætur hans svo að hann reiðist ekki og tortími ykkur! ");
INSERT INTO isl_vpl VALUES ("PS2_13","020_2_13","PSA","2","13","13","Gætið ykkar, því að senn mun blossa reiði hans. En munið þetta: Sæll er hver sá sem leitar ásjár hjá honum. ");
INSERT INTO isl_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Sálmur eftir Davíð þegar hann flúði frá Absalon, syni sínum. ");
INSERT INTO isl_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Ó, Drottinn, það eru svo margir á móti mér, svo margir sem gera uppreisn gegn mér. ");
INSERT INTO isl_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Menn segja að Guð muni alls ekki hjálpa mér. ");
INSERT INTO isl_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","En, Drottinn, þú ert skjöldur minn, sæmd mín og von. Þú lætur mig bera höfuðið hátt, þrátt fyrir allt. ");
INSERT INTO isl_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Ég hrópaði til Drottins og hann svaraði mér frá musteri sínu í Jerúsalem. ");
INSERT INTO isl_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Þá lagðist ég fyrir og sofnaði í friði. Síðar vaknaði ég öruggur, því að Drottinn gætir mín. ");
INSERT INTO isl_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Nú er ég óhræddur, jafnvel þótt tíu þúsund óvinir umkringi mig! ");
INSERT INTO isl_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Ég mun hrópa til Drottins: „Drottinn, rís þú upp! Bjargaðu mér, þú Guð minn!“ Og hann mun slá óvini mína og brjóta tennur illvirkjanna. Hjálpin kemur frá Guði. Blessun hans hvílir yfir þjóð hans. ");
INSERT INTO isl_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","2","Þú, Guð réttlætis míns, þú sem hefur annast mig í öllum mínum erfiðleikum. Hlusta nú þegar ég kalla á nýjan leik. Miskunna þú mér. Heyr bæn mína. ");
INSERT INTO isl_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Drottinn Guð spyr: „Þið mannanna börn, ætlið þið endalaust að vanhelga nafn mitt með því að tilbiðja þessa heimskulegu hjáguði? Vitið þið ekki að heiður þeirra er bull og hégómi?“ ");
INSERT INTO isl_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Takið eftir: Drottinn hefur sýnt mér mikla náð og hann mun hlusta og svara mér þegar ég kalla. ");
INSERT INTO isl_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Sýnið Drottni óttablandna lotningu og syndgið ekki gegn honum. Hugsið um þetta í hvílum ykkar og verið þögul. ");
INSERT INTO isl_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Setjið traust ykkar á Drottin, og færið honum þóknanlegar fórnir. ");
INSERT INTO isl_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Margir spyrja hvar hjálp sé að fá. Drottinn, þú ert sá sem hjálpar. Láttu ljós þitt lýsa okkur. ");
INSERT INTO isl_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Gleðin sem þú hefur veitt mér er mun meiri en þeirra sem gleðjast yfir ríkulegri uppskeru. ");
INSERT INTO isl_vpl VALUES ("PS4_9","020_4_9","PSA","4","9","9","Nú leggst ég til hvíldar í friði og sofna, því þú, Drottinn verndar mig gegn öllu illu. ");
INSERT INTO isl_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","2","Drottinn, hlustaðu á orð mín. Heyr þú mína einlægu bæn. ");
INSERT INTO isl_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Hlustaðu á kveinstafi mína, þú Guð, konungur minn, því að ég mun aldrei biðja til neins nema þín. ");
INSERT INTO isl_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Á hverjum morgni horfi ég til himins, já til þín, og legg bænir mínar fram fyrir þig. ");
INSERT INTO isl_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Ég veit að þú fyrirlítur óguðleika og að þeir sem iðka hið illa fá ekki að dveljast hjá þér. ");
INSERT INTO isl_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Hrokafullir syndarar standast augnaráð þitt ekki, því að þú hatar illgjörðir þeirra. ");
INSERT INTO isl_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Þú munt eyða þeim sem tala lygi og þú hefur andstyggð á morðum og svikum. ");
INSERT INTO isl_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","En hvað um mig? Af náð þinni fæ ég að ganga inn í musteri þitt, umvafinn vernd þinni og ást. Ég vil tilbiðja þig í djúpri lotningu. ");
INSERT INTO isl_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Drottinn, leiddu mig eins og þú lofaðir mér, annars munu óvinir mínir sigra mig. Segðu mér skýrt hvað ég á að gera, og hvert ég á að fara, ");
INSERT INTO isl_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","því að þeir reyna að blekkja mig. Hjörtu þeirra eru full af illsku. Tortíming og dauði býr í ráðum þeirra og þeir nota svik og pretti sér til framdráttar. ");
INSERT INTO isl_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Ó, Guð láttu þá fá makleg málagjöld. Þeir lendi í eigin gildru. Hrintu þeim burt vegna hinna mörgu afbrota þeirra, því að þeir storka þér. ");
INSERT INTO isl_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","En þeir sem treysta þér gleðjast og kætast. Þeir hrópa af gleði því þú verndar þá. Þeir sem elska þig gleðjast yfir þér. ");
INSERT INTO isl_vpl VALUES ("PS5_13","020_5_13","PSA","5","13","13","Því að þú, ó Guð, blessar hinn trúaða, þú verndar hann með skildi elsku þinnar. ");
INSERT INTO isl_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","2","Æ, Drottinn! Ekki refsa mér í reiði þinni! ");
INSERT INTO isl_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Miskunnaðu mér því að ég örmagnast. Lækna mig, því að líkami minn er sjúkur. ");
INSERT INTO isl_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Ég er hræddur, veit ekki mitt rjúkandi ráð. Ó, Drottinn, reistu mig á fætur, og það fljótt! ");
INSERT INTO isl_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Komdu Drottinn og læknaðu mig. Bjargaðu mér í kærleika þínum. ");
INSERT INTO isl_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Því að ef ég dey, þá get ég ekki lengur lofað þig meðal vina minna. ");
INSERT INTO isl_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Ég er aðframkominn af kvöl. Hverja nótt væti ég koddann með tárum. ");
INSERT INTO isl_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Augu mín daprast af hryggð vegna illráða óvina minna. ");
INSERT INTO isl_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Farið! Látið mig í friði, þið illmenni, því að Drottinn hefur séð tár mín ");
INSERT INTO isl_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","og heyrt grátbeiðni mína. Hann mun svara öllum mínum bænum. ");
INSERT INTO isl_vpl VALUES ("PS6_11","020_6_11","PSA","6","11","11","Óvinir mínir munu verða til skammar og skelfingin mun steypast yfir þá. Guð mun reka þá sneypta burtu. ");
INSERT INTO isl_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","2","Ég treysti þér, Drottinn, Guð minn, að þú frelsir mig frá þeim sem ofsækja mig. ");
INSERT INTO isl_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","Þeir vilja ráðast á mig úr launsátri eins og ljón, særa mig og draga burt hálfdauðan. Láttu það ekki takast! ");
INSERT INTO isl_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","En Drottinn, ef ég hefði illt fyrir stafni ");
INSERT INTO isl_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","– ef ég launaði gott með illu eða beitti nágranna mína órétti, ");
INSERT INTO isl_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","þá væri réttlátt að þú létir óvini mína eyða mér, fella mig og fótum troða. ");
INSERT INTO isl_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","En Drottinn! Rís þú upp í reiði gegn ofstopa óvina minna. Vakna þú Drottinn! Láttu mig ná rétti mínum! ");
INSERT INTO isl_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","9","Safnaðu saman öllum þjóðum. Taktu þér sæti hátt uppi yfir þeim og dæmdu syndir þeirra. En mig, Drottinn, lýstu mig réttlátan svo allir heyri, auglýstu réttlæti mitt og ráðvendni. ");
INSERT INTO isl_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Stöðvaðu alla illsku, Drottinn, og blessa þá sem í einlægni tilbiðja þig. Því að þú, réttláti Guð, kannar hugarfylgsni mannanna og rannsakar viðhorf þeirra og tilgang. ");
INSERT INTO isl_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Guð er skjöldur minn. Hann mun vernda mig. Hann frelsar þá sem hjartahreinir eru. ");
INSERT INTO isl_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Guð er fullkomlega réttlátur dómari og dag hvern gremst honum illska hinna vondu. ");
INSERT INTO isl_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Ef þeir iðrast ekki mun hann bregða sverði og eyða þeim. Hann hefur spennt boga sinn ");
INSERT INTO isl_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","og lagt eldlegar örvar á streng, – banvænar örvar. ");
INSERT INTO isl_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Hinn illi bruggar launráð og íhugar vélabrögð sín. Hann lætur til skarar skríða með lygum og svikum. ");
INSERT INTO isl_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Hann falli á eigin bragði. ");
INSERT INTO isl_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Ofbeldið sem hann ætlaði öðrum, verði honum sjálfum að fjörtjóni. ");
INSERT INTO isl_vpl VALUES ("PS7_18","020_7_18","PSA","7","18","18","Ég lofa og vegsama Drottinn, því hann er góður. Ég vil lofsyngja nafni Drottins, honum sem er öllum drottnum æðri. ");
INSERT INTO isl_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","2","Ó, Drottinn Guð, mikið er nafn þitt! Jörðin er full af dýrð þinni og himnarnir endurspegla mikilleik þinn. ");
INSERT INTO isl_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Þú hefur kennt börnum að lofsyngja þér. Fyrirmynd þeirra og vitnisburður þaggi niður í óvinum þínum og valdi þeim skömm. ");
INSERT INTO isl_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","Þegar ég horfi á himininn og skoða verk handa þinna, tunglið og stjörnurnar sem þú hefur skapað – ");
INSERT INTO isl_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","þá undrast ég að þú skulir minnast mannsins, láta þér umhugað um mannanna börn. ");
INSERT INTO isl_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Og líka, að þú lést manninn verða litlu minni en Guð! Krýndir hann sæmd og heiðri! ");
INSERT INTO isl_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Þú hefur sett hann yfir allt sem þú hefur skapað, allt er honum undirgefið: ");
INSERT INTO isl_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","Uxar og allur annar fénaður, villidýrin ");
INSERT INTO isl_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","fuglar og fiskar, já, allt sem í sjónum syndir. ");
INSERT INTO isl_vpl VALUES ("PS8_10","020_8_10","PSA","8","10","10","Ó, Drottinn Guð, hversu dýrlegt er nafn þitt um alla jörðina! ");
INSERT INTO isl_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","2","Drottinn, ég vil lofa þig af öllu hjarta og segja öllum frá þínum dásamlegu verkum! ");
INSERT INTO isl_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Ég vil fagna, já, kætast þín vegna! Ég vil lofsyngja þér, Drottinn Guð, þú ert öllum guðum æðri. ");
INSERT INTO isl_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Óvinir mínir hörfuðu undan, já, hrösuðu og fórust fyrir augliti þínu. ");
INSERT INTO isl_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Þú hefur látið mig ná rétti mínum, ábyrgst verk mín og sagt frá hásæti þínu að þau séu góð. ");
INSERT INTO isl_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Þú hefur ávítað þjóðirnar og eytt illvirkjunum, þurrkað út nöfn þeirra að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Þið, óvinir mínir, eruð búnir að vera, og eigið ykkur ekki viðreisnar von. Drottinn mun eyða borgum ykkar og minning þeirra mun gleymast. ");
INSERT INTO isl_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","9","En Drottinn lifir að eilífu. Hann situr í hásæti sínu, sker úr málum þjóðanna og dæmir þær með réttvísi. ");
INSERT INTO isl_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Allir kúgaðir komi til hans. Hann er skjól þeirra og athvarf á neyðarstundu. ");
INSERT INTO isl_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Allir þeir sem þekkja miskunn þína, Drottinn, treysta á hjálp þína. Þú hefur aldrei yfirgefið þá sem treysta þér. ");
INSERT INTO isl_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Lofsyngið Guði, honum sem býr í Jerúsalem! Víðfrægið dáðir hans um allan heiminn! ");
INSERT INTO isl_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Hann sem refsar morðingjum. Hann hlustar eftir þeim sem hrópa á réttlæti. Hann daufheyrist ekki við hrópum þeirra sem eru í nauðum staddir. ");
INSERT INTO isl_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","Og nú, Drottinn, miskunna þú mér, þú sérð hvernig óvinir mínir kvelja mig. Hríf mig úr þessari dauðans hættu. ");
INSERT INTO isl_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Frelsa mig að ég geti lofað þig í allra áheyrn í hliðum Jerúsalem og glaðst yfir því að þú bjargaðir mér. ");
INSERT INTO isl_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Þjóðirnar falla sjálfar í gryfjuna sem þær hafa grafið öðrum, þær hafa lent í eigin gildru. ");
INSERT INTO isl_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Drottinn lætur svikráð þeirra koma þeim sjálfum í koll! ");
INSERT INTO isl_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Illmennin munu hrapa til heljar og eins verða örlög þeirra þjóða sem gleyma Drottni. ");
INSERT INTO isl_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Því að ekki verður skortur hinna snauðu umborinn endalaust og né hjálp fátæklinganna látin dragast lengur. ");
INSERT INTO isl_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Ó, Drottinn, rís þú upp, dæm þjóðirnar og refsa þeim. Lát þær ekki hrósa sigri yfir þér! ");
INSERT INTO isl_vpl VALUES ("PS9_21","020_9_21","PSA","9","21","21","Lát þá skjálfa af ótta og skilja að þeir eru aðeins dauðlegir menn. ");
INSERT INTO isl_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Drottinn, hvers vegna ert þú víðs fjarri og gerir ekkert í málinu?! Hvers vegna felur þú þig þegar ég þarfnast þín svo mjög? ");
INSERT INTO isl_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Komdu og lækkaðu rostann í hinum hrokafullu og illgjörnu sem ofsækja lítilmagnann. Láttu illskubrögð þeirra koma þeim sjálfum í koll! ");
INSERT INTO isl_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Því að þessir menn stæra sig af illsku sinni, hæða Guð og hrósa þeim sem Drottinn fyrirlítur. Að safna auði er þeirra hjartans mál. ");
INSERT INTO isl_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Þessir vondu og sjálfumglöðu menn virðast halda að Guð sé ekki til. Að leita Guðs, það dettur þeim ekki í hug! ");
INSERT INTO isl_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","En samt ná þeir árangri og óvinir þeirra lúta í lægra haldi fyrir þeim. Þeir vita ekki að refsing þín bíður þeirra. ");
INSERT INTO isl_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Sá hrokafulli segir:. „Hvorki Guð né menn geta stöðvað mig, ég mun finna einhverja leið!“ ");
INSERT INTO isl_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Munnur hans er fullur af formælingum, lygi og ofbeldi. Hann hrósar sér af illum áformum. ");
INSERT INTO isl_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Slíkir menn læðast í skúmaskotum borgarinnar og myrða þann sem fram hjá gengur. ");
INSERT INTO isl_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Eins og ljón sitja fyrir bráð sinni, sitja þeir fyrir fátæklingnum, tilbúnir að hremma hann. Þeir leggja snörur fyrir fórnarlömb sín, veiða þau í net. ");
INSERT INTO isl_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Hinir ólánssömu undrast mátt þeirra og falla fyrir skeytum þeirra. ");
INSERT INTO isl_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Þeir segja við sjálfa sig: „Guð sér þetta ekki, og hann mun aldrei komast að því.“ ");
INSERT INTO isl_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Drottinn, rís þú upp! Refsa þeim, ó Guð! Gleymdu ekki fátæklingunum né öðrum sem eiga bágt. ");
INSERT INTO isl_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Hvers vegna lætur þú illmennin sem spotta þig, ganga laus? Þeir halda að þú munir aldrei refsa þeim. ");
INSERT INTO isl_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Drottinn, þú sérð verk þeirra. Þú þekkir öll þeirra brögð. Allt það böl og hryggðina sem þeir hafa valdið, gjörþekkir þú! Refsaðu þeim Drottinn, og það strax! Drottinn, hinn bágstaddi treystir á þig og þú ert kallaður stoð lítilmagnans. ");
INSERT INTO isl_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Brjóttu armlegg illgjörðamannanna. Veittu þeim eftirför uns enginn er eftir orðinn. ");
INSERT INTO isl_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Drottinn er konungur um aldir alda! Þeim sem elta aðra guði verður útrýmt úr landi hans. ");
INSERT INTO isl_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Drottinn, þú þekkir vonir hinna hógværu. Vissulega munt þú heyra hróp þeirra og hugga hjörtu þeirra. ");
INSERT INTO isl_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Þú munt láta munaðarlausa og alla kúgaða ná rétti sínum, svo að mennirnir – þeir eru bara mold – beiti ekki lengur ofbeldi. ");
INSERT INTO isl_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Hvernig getið þið sagt: „Flýðu til fjallanna og leitaðu skjóls!?“ Vitið þið ekki að ég treysti því að Drottinn muni hjálpa mér. ");
INSERT INTO isl_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Óguðlegir leggja ör á streng, spenna boga sína og miða úr launsátri á lýð Guðs. ");
INSERT INTO isl_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Menn segja: „Lögin hafa verið afnumin! Hinir réttlátu verða að forða sér.“ ");
INSERT INTO isl_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","En, Drottinn er enn í sínu heilaga musteri. Hann ríkir enn frá himnum. Hann fylgist grannt með öllu sem gerist á jörðu. ");
INSERT INTO isl_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Hann prófar bæði trúaða og vantrúaða. Hann fyrirlítur þá sem elska ofbeldi. ");
INSERT INTO isl_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Hann mun senda eld og brennistein yfir illgjörðamennina og svíða þá með glóheitum vindi. ");
INSERT INTO isl_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Því að Guð er réttlátur og hefur mætur á góðum verkum. Hinir hjartahreinu munu sjá auglit hans. ");
INSERT INTO isl_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","2","Drottinn! Hjálpa þú! Hinum trúuðu fækkar óðum. Hvar eru þeir sem hægt er að treysta? ");
INSERT INTO isl_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Allir ljúga og iðka svik og pretti, en einlægnin virðist fokin út í veður og vind. ");
INSERT INTO isl_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","5","En Drottinn mun ekki fara mjúkum höndum um þá sem iðka ranglæti. Hann mun útrýma þessum lygurum sem segja: „Við skulum ljúga til um áform okkar, enda ráðum við sjálfir hvað við segjum!“ ");
INSERT INTO isl_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Þessu svarar Drottinn: „Ég mun rísa upp og verja þá kúguðu, fátæku og hrjáðu. Ég mun frelsa þá samkvæmt bænum þeirra.“ ");
INSERT INTO isl_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","Loforð Drottins eru áreiðanleg. Hvert orð á vörum hans er satt og rétt eins og marghreinsað skíragull. ");
INSERT INTO isl_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","Drottinn, við vitum að þú munt varðveita þitt fólk frá verkum illra manna, þó svo þeir vaði alls staðar uppi og njóti heiðurs í landinu. ");
INSERT INTO isl_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","2","Hversu lengi ætlar þú Drottinn að gleyma mér – að eilífu, eða hvað? Ætlar þú sífellt að horfa í aðra átt þegar ég er í nauðum staddur? ");
INSERT INTO isl_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Hve lengi verð ég að byrgja inni angist mína? Hve lengi eiga óvinir mínir að hreykja sér upp yfir mig? ");
INSERT INTO isl_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Svara mér Drottinn, Guð minn, og sendu mér ljós þitt, annars er úti um mig! ");
INSERT INTO isl_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Þaggaðu niður í óvinum mínum sem segja: „Við höfum sigrað hann!“ Láttu þá ekki hlakka yfir því að ógæfa hendi mig. ");
INSERT INTO isl_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","En, – ég mun treysta þér og miskunn þinni hvað sem á gengur og fagna yfir hjálp þinni! ");
INSERT INTO isl_vpl VALUES ("PS13_7","020_13_7","PSA","13","7","7","Ég vil lofsyngja Drottni, því að ríkulega blessaði hann mig. ");
INSERT INTO isl_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","En sá heimskingi sem segir: „Guð er ekki til!“ Sá er líka bæði illur og spilltur og einskis góðs af honum að vænta. ");
INSERT INTO isl_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Drottinn horfir niður af himnum og virðir fyrir sér mennina, hvort einhver sé skynsamur og geri vilja hans. ");
INSERT INTO isl_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Nei, það gerir enginn þeirra. Allir eru þeir viknir af leið, allir spilltir af synd. Enginn er raunverulega góður, ekki einn einasti! ");
INSERT INTO isl_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Þeir kúga og kvelja þjóð mína og dettur ekki í hug að ákalla mig! Skyldu þeir ekki fá að kenna á því illgjörðamennirnir? ");
INSERT INTO isl_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Þeir munu óttast þegar þeir sjá að Guð er með þeim sem elska hann. ");
INSERT INTO isl_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Hann er skjól hinna hrjáðu og hógværu þegar illgjörðamenn ofsækja þá. ");
INSERT INTO isl_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Ó, að lausnardagur þeirra væri nú þegar kominn! Að Guð kæmi frá bústað sínum á Síon til bjargar þjóð sinni. En sá gleðidagur þegar Drottinn frelsar Ísrael! ");
INSERT INTO isl_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Drottinn, hver fær að leita skjóls og hælis í tjaldi þínu á fjallinu þínu helga? ");
INSERT INTO isl_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Sá sem er hógvær og lifir réttlátu lífi. ");
INSERT INTO isl_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Sá sem ekki baktalar náungann, leggur sig ekki eftir slúðri né gerir meðbróður sínum mein. ");
INSERT INTO isl_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","5","Sá sem andmælir illverkum og fyrirlítur þau. Sá sem heiðrar þá er fylgja Drottni í trúfesti og stendur við orð sín hvað sem það kostar. ");
INSERT INTO isl_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Bjarga mér, ó Guð, því að hjá þér leita ég skjóls. ");
INSERT INTO isl_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Ég sagði við Drottin: „Þú ert minn Drottinn, þú ert mín eina hjálp.“ ");
INSERT INTO isl_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Ég þrái samfélag við trúaða fólkið í landinu, á því hef ég alla mína velþóknun. ");
INSERT INTO isl_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Þeir sem kjósa sér annan guð uppskera þrengingu og tár. Ekki vil ég snerta við fórnum þeirra né nefna guði þeirra á nafn. ");
INSERT INTO isl_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Drottinn er arfleifð mín. Hann er fjársjóður minn og fögnuður alla daga! Hann verndar allar eigur mínar. ");
INSERT INTO isl_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Hann hefur gefið mér unaðsreit að erfð. ");
INSERT INTO isl_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Ég lofa Drottin sem gefur mér góð ráð. Á nóttunni leiðbeinir hann mér og segir mér hvað gera skuli. ");
INSERT INTO isl_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Drottinn hverfur mér aldrei úr huga. Af því að hann er með mér hrasa ég hvorki né fell. ");
INSERT INTO isl_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Nú fagnar andi minn, líkami og sál ");
INSERT INTO isl_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","því að þú munt ekki skilja mig eftir meðal hinna dánu né leyfa að þinn elskaði rotni í gröfinni. ");
INSERT INTO isl_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Þú hefur leyft mér að lifa og fagna. Ég mun njóta þeirrar miklu gleði að lifa með þér að eilífu! ");
INSERT INTO isl_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Drottinn, ó hjálpa þú mér, því að ég er heiðvirður og breytni mín réttlát. Hlustaðu þegar ég hrópa til þín! ");
INSERT INTO isl_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Úrskurða mig réttlátan svo að allir heyri, þú réttvísi Drottinn. ");
INSERT INTO isl_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Þú hefur prófað mig, já jafnvel um nætur, en engar illar hugsanir fundið hjá mér, né vond orð mér á vörum. ");
INSERT INTO isl_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Boðorðum þínum hef ég hlýtt og forðast félagsskap við illmenni og rudda. ");
INSERT INTO isl_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Ég hef fylgt leiðsögn þinni og ekki farið villur vegar. ");
INSERT INTO isl_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Ég ákalla þig því að ég veit að þú svarar mér! Já, hlustaðu á bæn mína. ");
INSERT INTO isl_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Sýndu mér kærleika þinn og náð, þú sem frelsar hina ofsóttu. ");
INSERT INTO isl_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Vernda mig eins og sjáaldur augans. Hyl mig í skjóli vængja þinna. ");
INSERT INTO isl_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","Óvinir mínir umkringja mig með morðsvip í augum. ");
INSERT INTO isl_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Þeir eru óguðlegir og beita mig ofbeldi. Hlustaðu á tal þeirra! Hvílíkur hroki! ");
INSERT INTO isl_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Þeir koma nær og nær, ákveðnir í að troða mig undir. ");
INSERT INTO isl_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Þeir líkjast gráðugum ljónum sem vilja rífa mig á hol – ungum ljónum sem liggja í leyni og bíða eftir bráð. ");
INSERT INTO isl_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","14","Drottinn, rís þú upp og hastaðu á þá! Rektu þá frá! Komdu og frelsaðu mig frá hinum óguðlegu sem aðeins leita jarðnesks ávinnings, þeim sem þú hefur gefið auð og völd og ótal afkomendur. ");
INSERT INTO isl_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","En ég sækist ekki eftir veraldlegum auði, heldur því að þekkja þig og lifa réttvíslega – vera sáttur við þig. Ég vil hugsa um þig jafnt á degi sem nóttu og þegar ég vakna mun ég sjá auglit þitt og gleðjast! ");
INSERT INTO isl_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Þennan sálm orti Davíð eftir að Drottinn hafði frelsað hann undan óvinum hans, þeirra á meðal Sál konungi. ");
INSERT INTO isl_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Drottinn – ég elska þig! Þú hefur gert stórkostlega hluti fyrir mig! ");
INSERT INTO isl_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Drottinn er vígi mitt, þar er ég öruggur. Enginn getur veitt mér eftirför og unnið á mér. Hann er felustaður minn, frelsari og varðborg, kletturinn þar sem enginn getur náð mér! Hann er skjöldur minn. Styrkur hans er eins og uxans sem mundar horn sín í vígahug! ");
INSERT INTO isl_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Mér nægir að ákalla hann – lof sé Guði! – og ég frelsast undan öllum óvinum mínum. ");
INSERT INTO isl_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Ég var bundinn hlekkjum dauðans og holskeflur óguðlegra risu ógnandi gegn mér. ");
INSERT INTO isl_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Umkringdur og hjálparvana barðist ég um í netinu sem dró mig niður í djúp dauðans. ");
INSERT INTO isl_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Þá hrópaði ég til Drottins. – Hróp mitt náði eyrum hans á himnum! ");
INSERT INTO isl_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Þá lyftist jörðin og nötraði og undirstöður fjallanna skulfu vegna bræði hans. Hvílíkur landskjálfti! Já, Drottinn reiddist. ");
INSERT INTO isl_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Eldsblossar gengu út af munni hans svo að jörðin sviðnaði og reykur streymdi um nasir hans. ");
INSERT INTO isl_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Hann sveigði himininn og steig niður mér til bjargar! Skýjasorti var undir fótum hans. ");
INSERT INTO isl_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Hann steig á bak kerúbi og sveif til mín með hraða vindsins. ");
INSERT INTO isl_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Hann skýldi sér með myrkri, leyndi komu sinni með regnsorta og dimmu skýi. ");
INSERT INTO isl_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","En svo birtist hann í skýjunum! Hvílík hátign! Eldingar leiftruðu og haglið dundi! ");
INSERT INTO isl_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Himnarnir nötruðu í þrumugný Drottins. Guð allra guða hafði talað! ");
INSERT INTO isl_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Hann sendi út eldingar sínar sem örvar og tvístraði óvinum mínum. Sjá, hvernig þeir flýðu! ");
INSERT INTO isl_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Þá hljómaði skipun Drottins – og hafið hopaði og það sá í mararbotn! ");
INSERT INTO isl_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Þá seildist Drottinn niður frá himnum, greip mig og frelsaði mig úr neyðinni. Hann bjargaði mér úr hyldýpi dauðans. ");
INSERT INTO isl_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Hann frelsaði mig frá ofurafli óvinarins, úr höndum þeirra sem hötuðu mig, því í greipum þeirra mátti ég mín einskis. ");
INSERT INTO isl_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Þeir réðust á mig þegar ég mátti mín einskis, en Drottinn studdi mig. ");
INSERT INTO isl_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Hann leiddi mig í öruggt skjól, því að hann hefur velþóknun á mér. ");
INSERT INTO isl_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Drottinn launaði mér réttlæti mitt og hreinleika. ");
INSERT INTO isl_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Því að ég hef hlýtt boðorðum hans og ekki syndgað með því að snúa í hann baki. ");
INSERT INTO isl_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Ég gætti lögmáls hans í hvívetna og lítilsvirti enga grein þess. ");
INSERT INTO isl_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Ég lagði mig fram við að halda það og forðaðist ranglæti. ");
INSERT INTO isl_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Þess vegna hefur Drottinn launað mér með blessun, því að ég gerði það sem rétt var og gætti hreinleika hjarta míns. Allt þetta þekkti hann, enda vakir hann yfir hverju skrefi mínu. ");
INSERT INTO isl_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Drottinn, þú miskunnar þeim sem auðsýna miskunn og ert góður við ráðvanda. ");
INSERT INTO isl_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Þú blessar hjartahreina en snýrð þér frá þeim sem yfirgefa þig. ");
INSERT INTO isl_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Þú hlífir hinum hógværu, en ávítar stolta og hrokafulla. ");
INSERT INTO isl_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Já, þú lætur lampa minn skína. Drottinn, Guð minn, hefur lýst upp myrkrið sem umlukti mig. ");
INSERT INTO isl_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Með þinni hjálp stekk ég yfir múra og brýt niður borgarveggi óvinarins. ");
INSERT INTO isl_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Drottinn, hann er mikill Guð! Fullkominn í öllum hlutum! Orð hans standast öll. Skjöldur er hann öllum þeim sem til hans leita. ");
INSERT INTO isl_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Því hver er hinn sanni Guð nema Drottinn? Og hver er bjargið nema hann? ");
INSERT INTO isl_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Hann styrkir mig og verndar hvar sem ég fer. ");
INSERT INTO isl_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Hann gerir fætur mína fima sem geitanna á fjöllunum. Hann tryggir mér fótfestu á hæstu tindum. ");
INSERT INTO isl_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Hann æfir hendur mínar til hernaðar og gerir mér kleift að spenna eirbogann. ");
INSERT INTO isl_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Þú fékkst mér skjöld hjálpræðis þíns. Hægri hönd þín, Drottinn, styður mig, mildi þín hefur gert mig mikinn. ");
INSERT INTO isl_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Þú lagðir veg fyrir fætur mína og þar mun ég ekki hrasa. ");
INSERT INTO isl_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Ég veitti óvinum mínum eftirför, elti þá uppi og eyddi þeim. ");
INSERT INTO isl_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Ég tók þá einn af öðrum – þeir gátu enga vörn sér veitt – allir lágu í valnum að lokum. ");
INSERT INTO isl_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Hjálpin frá þér var eins og brynja í bardaganum. Óvini mína beygðir þú undir mig. ");
INSERT INTO isl_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Þú stökktir þeim á flótta og ég eyddi öllum þeim sem ofsóttu mig. ");
INSERT INTO isl_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Þeir hrópuðu á hjálp, en fengu enga. Þeir æptu til Drottins, en hann ansaði ekki, ");
INSERT INTO isl_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","en ég muldi þá mélinu smærra og dreifði þeim upp í vindinn. Ég fleygði þeim burt eins og rusli á haug. ");
INSERT INTO isl_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","46","Þú veittir mér sigur í sérhverri orustu. Þjóðirnar komu og þjónuðu mér. Jafnvel þær sem ég þekkti ekki komu nú og veittu mér lotningu. Útlendingar sem aldrei höfðu mig augum litið lýstu sig reiðubúna til þjónustu. Skjálfandi stigu þeir niður úr virkjum sínum. ");
INSERT INTO isl_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Guð lifir! Lofaður sé hann, klettur hjálpræðis míns. ");
INSERT INTO isl_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Hann er sá Guð sem endurgeldur þeim sem ofsækja mig og auðmýkir þjóðir fyrir augum mér. ");
INSERT INTO isl_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Hann frelsar mig frá óvinum mínum. Hann sér til þess að þeir ná ekki til mín og bjargar mér undan öflugum andstæðingum. ");
INSERT INTO isl_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Fyrir þetta, Drottinn minn, lofa ég þig í áheyrn þjóðanna. ");
INSERT INTO isl_vpl VALUES ("PS18_51","020_18_51","PSA","18","51","51","Oftsinnis hefur þú frelsað mig – það var kraftaverk í öll skiptin! Þú gerðir mig að konungi, þú hefur elskað mig og auðsýnt mér gæsku og eins muntu gera við afkomendur mína. ");
INSERT INTO isl_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","2","Himnarnir sýna okkur dýrð Guðs. Þeir eru þögull vitnisburður um mikilleik verka hans. ");
INSERT INTO isl_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Dagur og nótt vitna um vísdóm Drottins. ");
INSERT INTO isl_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","5","Hljóðlaust og án orða bera þau boðin um gervalla jörðina. Sólin fer sína braut um loftin – einmitt þá sem Drottinn setti henni í upphafi. ");
INSERT INTO isl_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Hnarreist siglir hún yfir hvolfið, geislandi eins og brúður í brúðkaupi eða hlaupari sem hlakkar til að renna sitt skeið. ");
INSERT INTO isl_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Sólin fer um himininn frá austri til vesturs, ekkert fær dulist við geislaflóð hennar og yl. ");
INSERT INTO isl_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","9","Lög Guðs eru fullkomin. Þau vernda og auka skilning, gleðja og lýsa. ");
INSERT INTO isl_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Lög Guðs eru eilíf, réttlát og hrein. ");
INSERT INTO isl_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Þau eru dýrmætari en gull. Þau eru sætari en hunang. ");
INSERT INTO isl_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Því að þau vara okkur við hættum og efla velgengni þeirra sem hlýða þeim. ");
INSERT INTO isl_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Hver verður var við syndina sem loðir við hjarta mitt? Hreinsa mig af leyndum syndum. ");
INSERT INTO isl_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Forða mér frá vondum mönnum, og stöðva hönd mína að ég geri ekkert ljótt. Sýknaðu mig af syndum mínum svo að ég lifi hreinu lífi. ");
INSERT INTO isl_vpl VALUES ("PS19_15","020_19_15","PSA","19","15","15","Ó, að orðin á vörum mér og hugsanir mínar geðjist þér, þú Guð, klettur minn og frelsari. ");
INSERT INTO isl_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","2","Drottinn sé með þér og bænheyri þig á degi neyðarinnar! Guð Jakobs frelsi þig frá allri ógæfu. ");
INSERT INTO isl_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Hann sendi þér hjálp frá helgidómi sínum, styðji þig frá Síon. ");
INSERT INTO isl_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Hann minnist með gleði gjafa þinna og brennifórna. ");
INSERT INTO isl_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Hann veiti þér það sem hjarta þitt þráir og láti öll þín áform ná fram að ganga. ");
INSERT INTO isl_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Þegar við fréttum um sigur þinn, munum við hrópa fagnaðaróp og veifa fánanum Guði til dýrðar, því að mikla hluti hefur hann gert fyrir þig. Hann veiti svör við öllum þínum bænum! ");
INSERT INTO isl_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Guð blessi konunginn! – Já, það mun hann vissulega gera! í himinhæðum heyrir hann bæn mína og veitir mér mikinn sigur. ");
INSERT INTO isl_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Hinir stæra sig af herstyrk og vopnavaldi, en við af Drottni, Guði. ");
INSERT INTO isl_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Þjóðir þessar munu hrasa og farast, en við rísa og standa traustum fótum. ");
INSERT INTO isl_vpl VALUES ("PS20_10","020_20_10","PSA","20","10","10","Drottinn, sendu konungi okkar sigur! Drottinn, heyr þú bænir okkar. ");
INSERT INTO isl_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","2","Drottinn! Yfir valdi þínu og mætti fagnar konungurinn. Hann gleðst stórlega yfir hjálp þinni! ");
INSERT INTO isl_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Því að þú hefur veitt honum það sem hjarta hans þráir, allt sem hann bað þig um! ");
INSERT INTO isl_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Þú leiddir hann til valda og veittir honum velgengni og blessun. Þú krýndir hann kórónu úr gulli. ");
INSERT INTO isl_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Hann bað um langa ævi og góða daga og þú heyrðir bænir hans. Ævidagar hans munu aldrei taka enda! ");
INSERT INTO isl_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Frægð og frama gafst þú honum, íklæddir hann vegsemd og dýrð. ");
INSERT INTO isl_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Þú veitir honum eilífa blessun og gleður hann með nærveru þinni meira en orð fá lýst. ");
INSERT INTO isl_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Konungurinn treystir Drottni og því mun hann aldrei hrasa né falla. Hann reiðir sig á elsku og trúfesti þess Guðs sem er æðri öllum guðum. ");
INSERT INTO isl_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Drottinn, hönd þín mun ná öllum óvinum þínum og hatursmönnum. ");
INSERT INTO isl_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","11","Þegar þú stígur fram eyðast þeir í eldinum sem út frá þér gengur. Drottinn mun afmá þá og afkomendur þeirra. ");
INSERT INTO isl_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Samsæri hafa þeir gert gegn þér Drottinn, en það mun ekki takast. ");
INSERT INTO isl_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Þegar þeir sjá boga þinn spenntan, flýja þeir sem fætur toga. ");
INSERT INTO isl_vpl VALUES ("PS21_14","020_21_14","PSA","21","14","14","Drottinn, þinn er mátturinn og dýrðin! Heyr þú lofgjörð okkar! Um máttarverk þín syngjum við og kveðum!. ");
INSERT INTO isl_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","2","Guð minn, Guð minn, hví hefur þú yfirgefið mig? Hví ert þú þögull og hjálpar ekki þegar ég hrópa til þín í neyð minni? ");
INSERT INTO isl_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Daga og nætur græt ég og ákalla þig, en fæ ekkert svar! ");
INSERT INTO isl_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","5","– En samt ert þú hinn heilagi og lofsöngvar Ísraels óma umhverfis hásæti þitt. Feðurnir treystu þér og þú frelsaðir þá. ");
INSERT INTO isl_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Þú heyrðir er þeir hrópuðu til þín, brást við og bjargaðir þeim. Vonir þeirra brugðust ekki þegar þeir leituðu til þín. ");
INSERT INTO isl_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","En ég er maðkur en ekki maður! Hræddur og fyrirlitinn af minni eigin þjóð – já öllum mönnum. ");
INSERT INTO isl_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","Þeir sem sjá mig hrista höfuðið og senda mér tóninn. ");
INSERT INTO isl_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","„Er þetta sá sem treysti Drottni fyrir málum sínum?“ segja þeir og hlæja. „Sá sem taldi sig öruggan um velþóknun Guðs? Því trúum við ekki fyrr en við sjáum Drottin hjálpa honum.“ ");
INSERT INTO isl_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","12","Drottinn, oft hefur þú hjálpað mér. Móðir mín fæddi mig heilbrigðan í heiminn og þar varst þú til staðar og gættir mín, eins og öll mín bernskuár. Frá fæðingu hef ég átt allt undir þér. Þú varst minn Guð allt frá fyrstu stundu. Yfirgef mig ekki nú, nei ekki núna á neyðarstundu þegar enginn getur hjálpað nema þú! ");
INSERT INTO isl_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Ég er umkringdur illmennum. Þeir líkjast sterkum basan – uxum. ");
INSERT INTO isl_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Þeir æða að mér með opinn skoltinn, eins og öskrandi ljón sem ræðst á bráðina. ");
INSERT INTO isl_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Þrek mitt fjaraði út, rann út í sandinn og bein mín gliðnuðu sundur. Hjartað er bráðnað í brjósti mér ");
INSERT INTO isl_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","og tungan þurr eins og brenndur leir. Þú lætur mig horfast í augu við dauðann. ");
INSERT INTO isl_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Hópur illvirkja hefur umkringt mig. Eins og hundar slá þeir hring um mig. Hendur mínar og fætur hafa þeir gegnumstungið. ");
INSERT INTO isl_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Ég get talið öll mín bein. Þeir stara á mig og senda mér háðsglósur. ");
INSERT INTO isl_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Þeir skipta á milli sín klæðum mínum og varpa hlutkesti um kyrtil minn. ");
INSERT INTO isl_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Ó, Drottinn, vertu ekki fjarri! Drottinn, styrkur minn, skunda mér til hjálpar! ");
INSERT INTO isl_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Bjargaðu mér frá dauða, frá því að falla fyrir hendi kúgarans. ");
INSERT INTO isl_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Frelsaðu mig úr gini þessara varga, undan hornum uxanna! ");
INSERT INTO isl_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Ég vil lofa þig meðal bræðra minna, standa upp í söfnuðinum og vitna um þín undursamlegu verk. ");
INSERT INTO isl_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Ég segi: „Lofið Drottin, allir þið sem óttist hann, hver og einn ykkar heiðri hann og tigni. Allur Ísrael lofsyngi honum, ");
INSERT INTO isl_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","því að hann hefur ekki fyrirlitið ákall mitt um hjálp, ekki snúið við mér baki í eymd minni. Hann heyrði hróp mitt og kom!“ ");
INSERT INTO isl_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Ég vil rísa á fætur og vegsama þig fyrir augum þjóðar minnar. Heit mín vil ég efna í áheyrn allra þeirra sem elska þig og heiðra. ");
INSERT INTO isl_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Fátæklingurinn mun eta sig saddan og allir þeir sem leita Drottins munu finna hann og vegsama nafn hans. Hjörtu þeirra munu fagna að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Öll jörðin mun sjá það og snúa sér til Drottins, og fólk af öllum þjóðum mun vegsama hann. ");
INSERT INTO isl_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Því að Drottinn er konungur yfir öllum þjóðum. ");
INSERT INTO isl_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Jafnt háir sem lágir, allir dauðlegir menn, lúti honum og lofi hann. ");
INSERT INTO isl_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Og börnin okkar, – einnig þau munu þjóna honum því þau hafa heyrt vitnisburð okkar um hann. ");
INSERT INTO isl_vpl VALUES ("PS22_32","020_22_32","PSA","22","32","32","Ófæddar kynslóðir munu heyra um máttarverk hans okkar á meðal. ");
INSERT INTO isl_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Drottinn er minn hirðir, mig mun ekkert skorta. ");
INSERT INTO isl_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Hann lætur mig hvílast á grænum grundum og njóta næðis hjá lygnum vötnum. ");
INSERT INTO isl_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Hann hressir mig og styrkir og leiðir mig réttan veg. Hann hjálpar mér, nafni sínu til vegsemdar. ");
INSERT INTO isl_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Og jafnvel þótt ég fari um dimman dal, óttast ég ekkert illt, því að þú ert hjá mér og hughreystir mig! ");
INSERT INTO isl_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Já, og þú heldur mér veislu frammi fyrir fjendum mínum og þeir geta ekkert við því gert! Þú smyrð höfuð mitt með blessun og annast ríkulega allar mínar þarfir. ");
INSERT INTO isl_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Gæska þín og velþóknun fylgja mér alla ævidaga mína og síðan fæ ég að búa hjá þér að eilífu! ");
INSERT INTO isl_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Jörðin er eign Drottins og allt sem á henni er, – heimurinn og þeir sem í honum búa. ");
INSERT INTO isl_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Það var hann sem safnaði vötnunum saman svo að hafið varð til og þurrlendið birtist. ");
INSERT INTO isl_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Hver fær að stíga upp á fjall Drottins og ganga inn í bústað hans? Hver fær staðist frammi fyrir honum? ");
INSERT INTO isl_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Aðeins þeir sem hafa hreint hjarta og óflekkaðar hendur, heiðarlegt fólk sem segir sannleikann. ");
INSERT INTO isl_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Þeir munu njóta gæsku Guðs, og hann, frelsari þeirra, mun lýsa þá réttláta. ");
INSERT INTO isl_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Það eru þeir sem fá að standa frammi fyrir Drottni og tilbiðja hann, Guð Jakobs. ");
INSERT INTO isl_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Opnist þið fornu dyr! Konungur dýrðarinnar vill ganga inn. ");
INSERT INTO isl_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Hver er konungur dýrðarinnar? Það er Drottinn, hinn voldugi og sterki, sigurhetjan. ");
INSERT INTO isl_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Já, opnist þið ævafornu dyr fyrir konungi dýrðarinnar! ");
INSERT INTO isl_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Hver er þessi konungur dýrðarinnar? Drottinn, sá er ræður öllum hersveitum himnanna, hann er konungur dýrðarinnar! ");
INSERT INTO isl_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","Drottinn, ég sendi bæn mína upp til þín. ");
INSERT INTO isl_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Hafnaðu mér ekki, Drottinn, því að ég treysti þér. Láttu ekki óvini mína yfirbuga mig. Láttu þá ekki vinna sigur. ");
INSERT INTO isl_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Sá sem treystir Drottni, mun ekki verða til skammar en hinir ótrúu verða það. ");
INSERT INTO isl_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Drottinn, sýndu mér þann veg sem ég á að ganga, bentu mér á réttu leiðina. ");
INSERT INTO isl_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Leiddu mig og kenndu mér því að þú ert sá eini Guð sem getur hjálpað. Á þig einan vona ég. ");
INSERT INTO isl_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","7","Drottinn, minnstu ekki æskusynda minna. Líttu til mín miskunnaraugum og veittu mér náð. Minnstu mín í elsku þinni og gæsku, Drottinn minn. ");
INSERT INTO isl_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Drottinn er góður og fús að vísa þeim rétta leið, sem villst hafa. ");
INSERT INTO isl_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Hann sýnir þeim rétta leið sem leita hans með auðmjúku hjarta. ");
INSERT INTO isl_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Þeir sem hlýða Drottni fá að ganga á hans vegum og upplifa elsku hans og trúfesti. ");
INSERT INTO isl_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","En Drottinn, hvað um syndir mínar? Æ, þær eru svo margar! Fyrirgef þú mér vegna elsku þinnar og nafni þínu til dýrðar. ");
INSERT INTO isl_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Sá maður sem óttast Drottin – heiðrar hann og hlýðir honum – mun njóta leiðsagnar Guðs í lífinu. ");
INSERT INTO isl_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Hann verður gæfumaður og börn hans erfa landið. ");
INSERT INTO isl_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Drottinn sýnir trúnað og vináttu þeim sem óttast hann. Hann trúir þeim fyrir leyndarmálum sínum! ");
INSERT INTO isl_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Ég mæni á Drottin í von um hjálp, því að hann einn getur frelsað mig frá dauða. ");
INSERT INTO isl_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Kom þú, Drottinn, og miskunna mér, því að ég er hrjáður og hjálparlaus og ");
INSERT INTO isl_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","vandi minn fer stöðugt vaxandi. Ó, frelsaðu mig úr neyð minni! ");
INSERT INTO isl_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Líttu á eymd mína og sársauka og fyrirgefðu mér syndir mínar! ");
INSERT INTO isl_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Sjáðu óvini mína og hve þeir hata mig! ");
INSERT INTO isl_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Frelsaðu mig frá þessu öllu! Bjargaðu mér úr klóm þeirra! Láttu engan segja að ég hafi treyst þér án árangurs. ");
INSERT INTO isl_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Láttu hreinskilni og heiðarleika vernda mig – já vera lífverði mína! Ég reiði mig á vernd þína. ");
INSERT INTO isl_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","Ó, Guð, frelsa þú Ísrael úr öllum nauðum hans. ");
INSERT INTO isl_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Drottinn, láttu mig ná rétti mínum, því að ég hef kappkostað að halda boð þín og treyst þér af öllu hjarta. ");
INSERT INTO isl_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Rannsakaðu mig yst sem innst, Drottinn, og prófaðu viðhorf mín og einlægni. ");
INSERT INTO isl_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Afstaða mín til lífsins og allra hluta mótaðist hjá þér. Þú kenndir mér elsku og sannleika. ");
INSERT INTO isl_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Ég forðast félagsskap hræsnara og þeirra sem tala lygi. ");
INSERT INTO isl_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Ég hef andstyggð á samkundum syndaranna og stíg ekki fæti þar inn. ");
INSERT INTO isl_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Ég þvæ hendur mínar, gef til kynna sakleysi mitt og geng að altari þínu ");
INSERT INTO isl_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","með þakkargjörð á vörum, minnugur máttarverka þinna. ");
INSERT INTO isl_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Drottinn, ég elska hús þitt – helgidóminn þar sem dýrð þín birtist! ");
INSERT INTO isl_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","10","Láttu mér ekki farnast eins og syndurum og morðingjum eða þeim sem beita saklausa menn vélráðum og heimta mútur. ");
INSERT INTO isl_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Nei, með slíkum á ég enga samleið. Ég geng hinn beina, en bratta veg sannleikans. Miskunna mér og frelsa mig. ");
INSERT INTO isl_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Opinskátt og í áheyrn allra lofa ég Drottin, hann sem ver mig hrösun og falli. ");
INSERT INTO isl_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Drottinn er ljós mitt og frelsari, hvern ætti ég að óttast? Hann er skjól mitt og vígi, og því hræðist ég ekki. ");
INSERT INTO isl_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Þegar illmenni reyna að uppræta mig, þá hrasa þeir sjálfir og falla. ");
INSERT INTO isl_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Þótt voldugur her umkringi mig á alla vegu, þá óttast ég ekki hót! Ég er öruggur og veit að Guð mun frelsa mig. ");
INSERT INTO isl_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Drottinn, þetta þrái ég mest af öllu: Að hugleiða í helgidómi þínum, og vera frammi fyrir þér alla mína ævidaga. Þar vil ég gleðjast yfir dýrð hans og fullkomnun, hún er engu lík! ");
INSERT INTO isl_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Þar verð ég öruggur á óheilladeginum – öruggur í skjóli Drottins. Hann lyftir mér upp á háan klett ");
INSERT INTO isl_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","þar sem óvinirnir ná ekki til mín. Þá mun ég færa honum fórnir og lofa hann fagnandi. ");
INSERT INTO isl_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Drottinn, heyrðu hróp mitt! Ég kalla hátt! Sendu mér miskunn þína og hjálp! ");
INSERT INTO isl_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Drottinn, ég minnist þess sem þú sagðir: „Þú þjóð mín, kom þú og leitaðu mín.“ „Já, Drottinn! Ég kem!“ svara ég. ");
INSERT INTO isl_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Drottinn, hyl þig ekki fyrir mér. Hafnaðu ekki þjóni þínum í reiði. Þú varst mér skjól þegar á móti blés, yfirgefðu mig ekki. Hafnaðu mér ekki, þú Guð hjálpræðis míns. ");
INSERT INTO isl_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Þótt faðir minn og móðir vísuðu mér á bug, þá tækir þú mér tveim höndum og huggaðir mig. ");
INSERT INTO isl_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Drottinn, hvað á ég til bragðs að taka? Svaraðu mér fljótt! Óvinir umkringja mig! ");
INSERT INTO isl_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Láttu þá ekki ná mér, Drottinn! Láttu mig ekki falla þeim í hendur! Þeir ásaka mig að ástæðulausu og sitja á svikráðum við mig. ");
INSERT INTO isl_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","En ég treysti því að Drottinn frelsi mig og að ég sjái hjálp hans, því að enn er von, – enn er ég á lífi! ");
INSERT INTO isl_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Þú, hver sem þú ert, misstu ekki vonina! Treystu Drottni og hann mun frelsa þig! Vertu hugrakkur og djarfur og óttastu ekki. Bíddu um stund og hann mun senda þér hjálp! ");
INSERT INTO isl_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Ég hrópa til þín um hjálp, Drottinn, því að þú ert klettur hjálpræðis míns. Ef þú hjálpaðir ekki væri úti um mig. Framundan væri ekkert nema dauðinn. ");
INSERT INTO isl_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Drottinn, ég lyfti höndum til himins og ákalla þig um hjálp. Ó, heyr þú grátbeiðni mína! ");
INSERT INTO isl_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Drottinn, refsaðu mér ekki ásamt illgjörðamönnunum, þeim sem sitja á svikráðum við nágranna sína. ");
INSERT INTO isl_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Refsaðu þeim eins og rétt er. Illvirki þeirra eiga skilið réttlátan dóm. ");
INSERT INTO isl_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Þeir hugsa ekkert um Guð, sköpun hans og verk. Þess vegna mun Guð ryðja þeim úr vegi, rífa þá eins og ónýtt hús sem ekki verður endurreist. ");
INSERT INTO isl_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Lofaður sé Drottinn! Hann heyrði grátbeiðni mína! ");
INSERT INTO isl_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Hann er styrkur minn, skjól mitt gegn öllum árásum. Honum treysti ég og hann hjálpaði mér. Gleðin svellur í brjósti mér og brýst út í lofgjörð til hans! ");
INSERT INTO isl_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Drottinn verndar sitt fólk og veitir konungi sínum sigur. ");
INSERT INTO isl_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Stattu vörð um þjóð þína, Drottinn! Vernda og blessa þitt útvalda fólk. Eins og fjárhirðir leiðir sauði sína, þá leið og vernda þjóð þína að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Þið englar Drottins, lofið hann í mætti hans og dýrð! ");
INSERT INTO isl_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Lofið hann í mikilleik dýrðar hans, þeirri dýrð er stafar af nafni hans. Tilbiðjið hann í helgum skrúða. ");
INSERT INTO isl_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Raust Drottins fyllir himininn, hún kveður við eins og þruma! ");
INSERT INTO isl_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Rödd hans hljómar kröftuglega, hún hljómar af mikilleik og tign. ");
INSERT INTO isl_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","6","Hún fellir sedrustrén til jarðar og klýfur hin hávöxnu tré í Líbanon. Raust Drottins skekur fjöllin í Líbanon og hristir Hermonfjall. Hans vegna hoppa þau um eins og ungir kálfar! ");
INSERT INTO isl_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","8","Rödd Drottins kveður við í eldingunni og endurómar í eyðimörkinni sem nötrar endanna á milli. ");
INSERT INTO isl_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Raust Drottins skekur skógartrén, feykir burt laufi þeirra og lætur hindirnar bera fyrir tímann. Allir þeir sem standa í helgidómi hans segja: „Dýrð! Já, dýrð sé Drottni!“ ");
INSERT INTO isl_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Flóðið mikla var ógurlegt, en Drottinn er enn meiri! Og enn birtir hann mátt sinn og kraft. ");
INSERT INTO isl_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Hann mun veita lýð sínum styrkleik og blessa hann með friði og velgengni. ");
INSERT INTO isl_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","2","Ég vil lofa þig Drottinn, því að þú hefur frelsað mig frá óvinum mínum. Þú leyfðir þeim ekki að yfirbuga mig. ");
INSERT INTO isl_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Ó, Drottinn Guð minn, ég hrópaði til þín og þú læknaðir mig. ");
INSERT INTO isl_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Þú hreifst mig burt frá barmi grafarinnar, já úr dauðans greipum, og gafst mér líf og framtíð! ");
INSERT INTO isl_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Syngið Drottni lof og þökk, þið sem á hann trúið. ");
INSERT INTO isl_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Reiði hans stendur stutta stund, en náð hans varir að eilífu! Hans vegna stend ég stöðugur, fastur fyrir eins og fjöllin. Gráturinn sækir að um nætur, en gleðisöngur þegar dagur rís. ");
INSERT INTO isl_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","8","Þegar allt gekk mér í hag, hugsaði ég: „Svona verður það alla tíð, nú getur ekkert stöðvað mig framar! Drottinn hefur velþóknun á mér. Hans vegna stend ég stöðugur, fastur fyrir eins og fjöllin!“ Þá snerir þú þér, Drottinn, burt frá mér og hélst aftur af blessun þinni. Skyndilega var kjarkur minn brostinn. Ég varð skelkaður og örvænti um minn hag. ");
INSERT INTO isl_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","Ég hrópaði til þín Drottinn. Já, svo sannarlega ákallaði ég þig! ");
INSERT INTO isl_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Ég sagði: „Hvers vegna vilt þú Drottinn, koma mér á kné? – leiða mig í dauðann? Þar verður lofsöngur minn til lítils gagns. Hvernig á ég þá, liðið lík, að lofa þig, og vegsama trúfesti þína?! ");
INSERT INTO isl_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Heyr þú ákall mitt, Drottinn! Miskunna þú mér og sendu mér hjálp þína.“ ");
INSERT INTO isl_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Þá breytti hann grát mínum í gleðidans! Hann dró af mér sorgarklæðin og færði mig í veisluskrúða! ");
INSERT INTO isl_vpl VALUES ("PS30_13","020_30_13","PSA","30","13","13","Og þá gat ég lofsungið honum og gleymt ógnum grafarinnar! Ó, Drottinn, minn Guð, hvernig fæ ég fullþakkað þér? ");
INSERT INTO isl_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","2","Drottinn, þér einum treysti ég. Láttu ekki óvini mína yfirbuga mig. Bjargaðu mér, því að þú ert réttlátur í öllum hlutum. ");
INSERT INTO isl_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Svara mér í skyndi, nú þegar ég hrópa til þín. Beygðu þig niður að mér og hlustaðu á bæn mína. Vertu mér verndarbjarg, skjól fyrir óvinum. ");
INSERT INTO isl_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Já, þú ert klettur minn og vígi, sýndu mátt þinn og gerðu nafn þitt dýrlegt og bjargaðu mér. ");
INSERT INTO isl_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Forða fæti mínum frá snörunni sem óvinir mínir hafa lagt fyrir mig. Þú einn getur frelsað mig. ");
INSERT INTO isl_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Í þínar hendur fel ég anda minn. Þú, Guð, sem stendur við öll þín orð, þú hefur bjargað mér. Þig einan lofa ég. ");
INSERT INTO isl_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Ég hata alla þá sem dýrka fánýt falsgoð en Drottni treysti ég. ");
INSERT INTO isl_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Ég gleðst mjög, því að þú hefur miskunnað mér, þú gafst gaum að þrengingum mínum og sálarneyð. ");
INSERT INTO isl_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Þú framseldir mig ekki óvinum mínum, heldur rýmkaðir um mig á alla vegu. ");
INSERT INTO isl_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","11","Ó, Drottinn, miskunna mér í neyð minni. Augu mín eru grátbólgin, heilsa mín brostin af sorg. ");
INSERT INTO isl_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Ár mín líða í harmi, hryggðin styttir ævi mína. Syndirnar draga úr mér allan þrótt. Hokinn stend ég – sneyptur af skömm. Óvinirnir spotta mig og nágrannarnir hæða mig. Óhug slær að vinum mínum. Þeir, jafnvel þeir, forðast að mæta mér og líta undan þegar ég geng hjá. ");
INSERT INTO isl_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Ég er gleymdur eins og líkið í gröf sinni – eins og brotið ker sem fleygt hefur verið á haug. ");
INSERT INTO isl_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Ég frétti hvað um mig var sagt – um baktal óvina minna. Ógn og skelfing var hvert sem ég leit, svik og prettir í öllum hornum! ");
INSERT INTO isl_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","16","En Drottinn, þér treysti ég! Ég sagði: „Þú einn ert minn Guð,“ þú ákveður ævilengd mína. Frelsaðu mig Drottinn, undan þeim sem ofsækja mig. ");
INSERT INTO isl_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Láttu velþóknun þína aftur verða augljósa á þjóni þínum. Frelsa mig því að þú ert góður! ");
INSERT INTO isl_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Drottinn, láttu mig ekki verða til skammar þegar ég ákalla þig um hjálp. Láttu illmennin blygðast sín fyrir það sem þau treysta á. Já, sendu þá sneypta og þegjandi í gröfina ");
INSERT INTO isl_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","lygarana sem ásaka réttláta með hroka og fyrirlitningu. ");
INSERT INTO isl_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Mikil er miskunn þín við þá sem treysta þér og vitna um trúfesti þína, þá sem elska þig og heiðra í augsýn annarra. ");
INSERT INTO isl_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Vertu ástvinum þínum skjól gegn svikráðum manna, verndaðu þá fyrir illum tungum. ");
INSERT INTO isl_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Lofaður sé Drottinn, því að hann hefur sýnt mér dásamlega náð og verndað mig gegn illu. ");
INSERT INTO isl_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Í fljótfærni sagði ég: „Drottinn hefur yfirgefið mig.“ En hann heyrði samt bæn mína og svaraði mér! ");
INSERT INTO isl_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Elskið Drottin, öll þið sem honum treystið, því að Drottinn verndar trúfasta, en refsar harðlega þeim sem hafna honum í hroka. ");
INSERT INTO isl_vpl VALUES ("PS31_25","020_31_25","PSA","31","25","25","Verið því glöð og hughraust, öll þið sem vonið á Drottin! ");
INSERT INTO isl_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","2","Hvílík náð að fá syndir sínar fyrirgefnar! Það er dásamlegt þegar afbrotin eru strikuð út! En sá léttir hverjum játandi syndara að heyra Drottin segja: „Ég sýkna þig.“ ");
INSERT INTO isl_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Sú var tíðin að ég þrjóskaðist við og neitaði að iðrast. En synd mín kvaldi mig og nagaði öllum stundum. ");
INSERT INTO isl_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Ég var friðlaus bæði nætur og daga og fann að Drottinn áminnti mig. Styrkur minn þvarr eins og lækur sem þornar á heitu sumri. ");
INSERT INTO isl_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Að lokum játaði ég synd mína fyrir þér, viðurkenndi afbrotin. Ég sagði: „Ég vil játa það allt fyrir Drottni,“ og þá fyrirgafstu mér! Sekt mín var strikuð út! ");
INSERT INTO isl_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Þess vegna segi ég: Þú sem trúir, játaðu synd þína strax fyrir Guði, já, strax og samviskan angrar þig. Notaðu tímann meðan fyrirgefning Guðs stendur þér til boða. Annars vofir dómurinn yfir þér. ");
INSERT INTO isl_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Þú ert skjól mitt í andstreymi lífsins og lausn í nauðum og vanda. Með frelsisfögnuði umlykur þú mig. ");
INSERT INTO isl_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Drottinn segir: „Ég vil fræða þig og vísa þér veginn gegnum lífið. Ég vil gefa þér ráð og fylgjast með framför þinni. ");
INSERT INTO isl_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Vertu ekki eins og þrjóskur hestur! Með taum og beisli verður að temja hann.“ ");
INSERT INTO isl_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Miklar eru þjáningar syndugs manns, en þá sem treysta Drottni umlykur hann elsku. ");
INSERT INTO isl_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Gleðjist yfir Guði, þið sem á hann trúið, og rekið upp fagnaðaróp, þið sem honum hlýðið! ");
INSERT INTO isl_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Gleðjist og fagnið fyrir Drottni, þið hans trúuðu, því að lofsöngur hæfir réttlátum! ");
INSERT INTO isl_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Leikið af þrótti á alls konar hljóðfæri og lofið Drottin. ");
INSERT INTO isl_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Lofsyngið honum með nýjum söngvum. Sláið strengina ákaft og hrópið fagnaðaróp! ");
INSERT INTO isl_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Því að orð Drottins er áreiðanlegt – því má treysta. Öll hans verk eru í trúfesti gjörð. ");
INSERT INTO isl_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Hann elskar allt sem rétt er og gott, kærleikur hans umvefur heiminn. ");
INSERT INTO isl_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","7","Það var orð Drottins sem skapaði himininn og alla hans stjörnumergð. Og höfunum safnaði hann saman og bjó þeim sinn rétta stað. ");
INSERT INTO isl_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Allir heimsbúar – bæði háir og lágir – óttist Drottin, og nálgist hann með lotningu. ");
INSERT INTO isl_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Því að hann talaði og þá stóð heimurinn þar! Orð hans hljómaði og veröldin varð til! ");
INSERT INTO isl_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Drottinn ónýtir áform þjóða sem gegn honum rísa ");
INSERT INTO isl_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","en fyrirætlanir hans standa að eilífu, frá kynslóð til kynslóðar. ");
INSERT INTO isl_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Sæl er sú þjóð sem á Drottin að Guði, það fólk sem hann hefur kosið eignarlýð sinn. ");
INSERT INTO isl_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","15","Drottinn lítur niður af himni, horfir á mannanna börn. Hann hefur myndað hjörtu þeirra og gefur gætur að öllum athöfnum þeirra. ");
INSERT INTO isl_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","17","Velbúinn her tryggir konungi ekki sigur og ofurafl eitt stoðar lítið. Stríðshestur er ekki til að reiða sig á, styrkur hans einn frelsar engan. ");
INSERT INTO isl_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","19","En, – augu Drottins vaka yfir þeim sem óttast hann, þeim sem reiða sig á elsku hans. Hann frelsar þá frá dauða, varðveitir líf þeirra á neyðarstund. ");
INSERT INTO isl_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Ég hef sett traust mitt á Drottin. Enginn getur hjálpað nema hann, hann er skjöldur og vígi! ");
INSERT INTO isl_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Hans vegna gleðjumst við og fögnum. Hans heilaga nafni treystum við. ");
INSERT INTO isl_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Miskunn þín Drottinn umvefji okkur. Við vonum á þig. ");
INSERT INTO isl_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","2","Ég vil lofa Drottin öllum stundum, vegsama hann seint og snemma. ");
INSERT INTO isl_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Ég hrósa mér af Drottni. Hinir hógværu hlusta og öðlast nýjan kjark. ");
INSERT INTO isl_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Lofið Drottin ásamt mér, tignum í sameiningu nafn hans. ");
INSERT INTO isl_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Ég hrópaði til hans og hann svaraði mér, frelsaði mig frá öllu því sem ég hræddist. ");
INSERT INTO isl_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Lítið til hans og gleðjist og þið munuð ekki verða til skammar. ");
INSERT INTO isl_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Ég var vesæll og aumur, en ég hrópaði til Drottins. Drottinn heyrði hróp mitt og frelsaði frá öllu því sem ég hræddist. ");
INSERT INTO isl_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Engill Drottins stendur vörð um þá sem óttast hann, og hann bjargar þeim. ");
INSERT INTO isl_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Finndu og sjáðu hve Guð er góður! Sæll er sá sem leitar hælis hjá honum. ");
INSERT INTO isl_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Treystið Drottni og sýnið honum lotningu – óttist hann – því að þeir sem óttast hann líða engan skort. ");
INSERT INTO isl_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Ung ljón búa við skort en þeir sem leita Drottins fara einskis góðs á mis. ");
INSERT INTO isl_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Börnin góð, komið og ég mun kenna ykkur að óttast Drottin. Það er mikilvægt. ");
INSERT INTO isl_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Viljið þið lifa langa og góða ævi? ");
INSERT INTO isl_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Gætið þá tungu ykkar! Segið aldrei ósatt orð. ");
INSERT INTO isl_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Haldið ykkur frá öllu illu og ástundið það sem gott er. Reynið að lifa í sátt við aðra menn og keppið eftir friði. ");
INSERT INTO isl_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Því að augu Drottins hvíla á hinum réttlátu og hann hlustar eftir bænum þeirra. ");
INSERT INTO isl_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","En öllum óguðlegum mun Drottinn eyða og afmá minningu þeirra af jörðinni. ");
INSERT INTO isl_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Þegar réttlátir hrópa, þá heyrir Drottinn og frelsar þá úr nauðum. ");
INSERT INTO isl_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Já, Drottinn er nálægur öllum þeim sem hafa auðmjúkt hjarta. Hann frelsar þá sem í einlægni og auðmýkt iðrast synda sinna. ");
INSERT INTO isl_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Góður maður kemst oft í vanda – fær sinn skammt af mótlæti – en Drottinn á lausn við öllu slíku. ");
INSERT INTO isl_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Jafnvel gegn slysum verndar Drottinn hann. ");
INSERT INTO isl_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Ógæfan eltir og drepur óguðlegan mann og þeir sem hata réttláta bíða síns dóms. ");
INSERT INTO isl_vpl VALUES ("PS34_23","020_34_23","PSA","34","23","23","En Drottinn frelsar líf þjóna sinna. Enginn sem leitar hælis hjá honum verður dæmdur sekur. ");
INSERT INTO isl_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Drottinn, farðu gegn þeim sem ásækja mig. Berst þú við þá sem berjast gegn mér. ");
INSERT INTO isl_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Klæddu þig brynju, taktu fram skjöld og verndaðu mig. ");
INSERT INTO isl_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Lyftu spjóti mér til varnar, því að óvinir mínir nálgast. Segðu við mig: „Ég bjarga þér!“ ");
INSERT INTO isl_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Láttu þá verða til skammar sem ofsækja mig. Snúðu þeim frá og ruglaðu þá í ríminu! ");
INSERT INTO isl_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Feyktu þeim burt eins og laufum í vindi. Engill þinn varpi þeim um koll. ");
INSERT INTO isl_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Gerðu veg þeirra myrkan og hálan er engill þinn eltir þá. ");
INSERT INTO isl_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Því að þótt ég gerði þeim ekkert illt, lögðu þeir fyrir mig gildru og grófu mér gröf. ");
INSERT INTO isl_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Láttu eyðingu koma yfir þá þegar þeir eiga þess síst von. Þeir falli á eigin bragði og tortímist. ");
INSERT INTO isl_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","En ég mun fagna í Drottni. Hann mun frelsa mig! ");
INSERT INTO isl_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Ég lofa hann af öllu hjarta. Hver er vörn lítilmagnans nema hann? Hver annar en hann verndar hinn veika og þurfandi gegn ofbeldismönnunum sem ræna og rupla. ");
INSERT INTO isl_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Slíkir menn eru ljúgvottar. Þeir ásaka mig um hluti sem ég hef aldrei heyrt. ");
INSERT INTO isl_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Ég gerði þeim gott eitt, en þeir launa mér með illu. Ég er að dauða kominn. ");
INSERT INTO isl_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","Þegar þeir lágu sjúkir klæddist ég sorgarbúningi og var dapur. Ég fastaði – neitaði mér um mat – og bað í einlægni fyrir heilsu þeirra. ");
INSERT INTO isl_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","Ég var harmandi, eins og móðir mín, vinur eða bróðir væru sjúk og að dauða komin. ");
INSERT INTO isl_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","En nú gleðjast þeir yfir óförum mínum. Þeir koma saman til að baktala mig – jafnvel ókunnugir og útlendingar eru í þeirra hópi. ");
INSERT INTO isl_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Þeir ala á illsku, formæla mér og hæða mig. ");
INSERT INTO isl_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","Drottinn, hve lengi ætlar þú að horfa á aðgerðalaus? Gríptu inn í og bjargaðu mér, því að ég er einmana og þessir vargar bíða færis. ");
INSERT INTO isl_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Frelsaðu mig og þá mun ég þakka þér í áheyrn alls safnaðarins, vegsama þig meðal fjölda fólks. ");
INSERT INTO isl_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Láttu þá ekki fá sigur sem ráðast gegn mér án minnsta tilefnis. Láttu mig ekki falla, því það mundi gleðja þá mjög. ");
INSERT INTO isl_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Þeir tala hvorki um frið, né það að gera gott, nei, heldur brugga þeir saklausum mönnum launráð. ");
INSERT INTO isl_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Þeir hafa hátt og segja mig beita ranglæti. „Já!“ segja þeir, „við sáum það með eigin augum!“ ");
INSERT INTO isl_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","En Drottinn þekkir málið betur en nokkur annar. Gríptu inn í! Skildu mig ekki eftir einan og yfirgefinn! ");
INSERT INTO isl_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Stígðu fram, Drottinn, Guð minn! Láttu mig ná rétti mínum. ");
INSERT INTO isl_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Þú ert réttlátur og þekkir málið. Lýstu yfir sakleysi mínu. Láttu ekki óvini mína hlakka yfir ógæfu minni. ");
INSERT INTO isl_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Láttu þá ekki segja: „Gott! Það fór eins og við óskuðum! Loksins tókst okkur að gera út af við hann!“ ");
INSERT INTO isl_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Láttu þá blygðast sín. Láttu þá sem sýna mér hroka og fagna yfir óförum mínum, sjálfa þola skömm og svívirðing. ");
INSERT INTO isl_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Láttu þá sem óska mér blessunar sjá góða daga. Þeir hrópi: „Mikill er Drottinn sem gerir vel við þjón sinn!“ ");
INSERT INTO isl_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Ég vil segja öllum frá réttlæti Drottins og lofa hann liðlangan daginn. ");
INSERT INTO isl_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","2","Rödd syndarinnar talar í huga guðleysingjans og hvetur hann til vondra verka. Enginn guðsótti býr í hjarta hans. ");
INSERT INTO isl_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Syndin dregur hann á tálar, mistök hans verða augljós og menn hata hann. ");
INSERT INTO isl_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Svik og tál eru á vörum hans og hann er hættur að vera hygginn og breyta vel. ");
INSERT INTO isl_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Á nóttunni liggur hann í rúmi sínu og upphugsar svik, forðast ekki hið illa. ");
INSERT INTO isl_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Drottinn, miskunn þín er mikil eins og himinninn og trúfesti þín takmarkalaus. ");
INSERT INTO isl_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Réttlæti þitt er stöðugt eins og fjöllin. Dómar þínir hvíla á vísdómi, þeir vitna um mikilleik þinn líkt og úthöfin. Þú berð umhyggju fyrir mönnum og skepnum. ");
INSERT INTO isl_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Hversu dýrmæt er miskunn þín ó, Guð! Mennirnir leita skjóls í skugga vængja þinna. ");
INSERT INTO isl_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Þú nærir þá með krásum af borði þínu og lætur þá drekka úr lækjum unaðssemda þinna. ");
INSERT INTO isl_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Þú, Drottinn, ert uppspretta lífsins! í þínu ljósi sjáum við ljós. ");
INSERT INTO isl_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Lát miskunn þína haldast við þá sem þekkja þig og réttlæti þitt við þá sem hlýða þér og elska. ");
INSERT INTO isl_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Lát ekki fót hins hrokafulla troða á mér né hendur óguðlegra hrekja mig burt. ");
INSERT INTO isl_vpl VALUES ("PS36_13","020_36_13","PSA","36","13","13","Líttu á! Illgjörðamennirnir eru fallnir! Þeim hefur verið varpað um koll og þeir megna ekki að rísa upp aftur. ");
INSERT INTO isl_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Öfundaðu aldrei vonda menn, ");
INSERT INTO isl_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","því að fyrr en varir eru þeir fallnir og visna eins og grasið. ");
INSERT INTO isl_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Treystu heldur Drottni, vertu góðgjarn og sýndu kærleika. Þá muntu búa öruggur í landinu og farnast vel. ");
INSERT INTO isl_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Þú skalt gleðjast í Drottni – og hann mun veita þér það sem hjarta þitt þráir. ");
INSERT INTO isl_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Fel Drottni framtíð þína, áform þín og verk, og treystu honum. Hann mun vel fyrir öllu sjá. ");
INSERT INTO isl_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Heiðarleiki þinn og hreinskilni verða öllum augljós, og Drottinn mun láta þig ná rétti þínum. ");
INSERT INTO isl_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Hvíldu í Drottni og treystu honum. Bíð þess í þolinmæði að hann hefjist handa. Öfunda ekki vonda menn sem vegnar vel. ");
INSERT INTO isl_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Láttu af reiðinni! Slepptu heiftinni. Vertu ekki svekktur og áhyggjufullur – slíkt leiðir ekki til góðs. ");
INSERT INTO isl_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Þeir sem illt fremja verða þurrkaðir út, en þeir sem treysta Drottni eignast landið og gæði þess. ");
INSERT INTO isl_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Innan skamms verða guðleysingjarnir á bak og burt. Þegar þú leitar þeirra eru þeir horfnir. ");
INSERT INTO isl_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","En hinir hógværu fá landið til eignar, þeir munu hljóta blessun og frið. ");
INSERT INTO isl_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","13","Drottinn hlær að þeim sem brugga launráð gegn hans trúuðu. Hann hefur þegar ákveðið daginn er þeir verða dæmdir. ");
INSERT INTO isl_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Óguðlegir hyggja á illt gegn réttlátum, undirbúa blóðbað. ");
INSERT INTO isl_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","En þeir munu farast fyrir eigin sverði og bogar þeirra verða brotnir. ");
INSERT INTO isl_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Betra er að eiga lítið og vera guðrækinn, en óguðlegur og hafa allsnægtir, ");
INSERT INTO isl_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","því að óguðlegir munu falla, en Drottinn annast sína trúuðu. ");
INSERT INTO isl_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Daglega skoðar Drottinn réttlætisverk trúaðra og reiknar þeim eilíf laun. ");
INSERT INTO isl_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Hann styður þá í kreppunni og heldur lífinu í þeim í hallæri. ");
INSERT INTO isl_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Vantrúaðir farast og óvinir Guðs visna eins og grasið. Eins og sinu verður þeim brennt, þeir líða burt eins og reykur. ");
INSERT INTO isl_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Guðlaus maður tekur lán og borgar ekki, en hinn guðrækni er ónískur og gefur með gleði. ");
INSERT INTO isl_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Þeir sem Drottinn blessar eignast landið, en bannfærðum verður útrýmt. ");
INSERT INTO isl_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Drottinn stýrir skrefum hins guðrækna og gleðst yfir breytni hans. ");
INSERT INTO isl_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Þótt hann falli þá liggur hann ekki flatur því að Drottinn reisir hann á fætur. ");
INSERT INTO isl_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Ungur var ég og nú er ég gamall orðinn, en aldrei sá ég Drottin snúa baki við guðhræddum manni né heldur börn hans biðja sér matar. ");
INSERT INTO isl_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Nei, guðræknir menn eru mildir og lána og börn þeirra verða öðrum til blessunar. ");
INSERT INTO isl_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Viljir þú búa við frið og lifa lengi, þá forðastu illt en gerðu gott, ");
INSERT INTO isl_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","því að Drottinn hefur mætur á góðum verkum og yfirgefur ekki sína trúuðu, hann mun varðveita þá, en uppræta niðja óguðlegra. ");
INSERT INTO isl_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Hinir réttlátu fá landið til eignar og búa þar mann fram af manni. ");
INSERT INTO isl_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","31","Guðrækinn maður talar speki, enda réttsýnn og sanngjarn. Lögmál Guðs er í hjarta hans og hann kann að greina gott frá illu. ");
INSERT INTO isl_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Ranglátir menn njósna um réttláta, vilja þá feiga. ");
INSERT INTO isl_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","En Drottinn stöðvar áform illvirkjanna og sýknar réttláta fyrir dómi. ");
INSERT INTO isl_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Óttastu ekki, því að Drottinn mun svara bæn þinni! Gakktu hiklaust á hans vegum. Á réttum tíma mun hann veita þér velgengni og uppreisn æru. Þá muntu sjá illvirkjunum útrýmt. ");
INSERT INTO isl_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","36","Ég sá vondan mann og hrokafullan – hann þandi sig út eins og laufmikið tré – en svo var hann horfinn! Ég leitaði eftir honum, en fann hann ekki framar. ");
INSERT INTO isl_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","En hvað um hinn ráðvanda og hreinskilna? Það er önnur saga! Því að góðir menn og friðsamir eiga framtíð fyrir höndum. ");
INSERT INTO isl_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Illum mönnum verður útrýmt og þeir eiga enga framtíðarvon. ");
INSERT INTO isl_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Drottinn bjargar hinum guðræknu. Hann er þeim hjálp og skjól á neyðartímum. ");
INSERT INTO isl_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Þeir treysta honum og því hjálpar hann þeim og frelsar þá frá vélráðum óguðlegra. ");
INSERT INTO isl_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","2","Drottinn, ekki refsa mér, þótt þú sért reiður. ");
INSERT INTO isl_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Örvar þínar standa í mér og hönd þín liggur þungt á mér. ");
INSERT INTO isl_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","5","Vegna reiði þinnar er ég sjúkur maður, heilsa mín er farin vegna synda minna. Syndir mínar líkjast flóði sem færir mig í kaf, eins og byrði sem ég kikna undan. ");
INSERT INTO isl_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","7","Ólykt leggur af sárum mínum – það er drep í þeim. Ég er ráðþrota vegna synda minna. Ég ráfa um í angist liðlangan daginn. ");
INSERT INTO isl_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Lendar mínar brenna af sviða og líkami minn er helsjúkur. ");
INSERT INTO isl_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Máttur minn er þrotinn og ég er örvæntingu nær. ");
INSERT INTO isl_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Drottinn, ég þrái bót á meini mínu! Þú heyrir kvein mín og andvörp. ");
INSERT INTO isl_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Hjartað hamast í brjósti mér, kraftar mínir búnir og sjónin dvín. ");
INSERT INTO isl_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Ástvinir mínir og góðir grannar forðast sjúkdóm minn og böl og frændur mínir eru á bak og burt. ");
INSERT INTO isl_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Óvinir mínir sæta færis að drepa mig. Liðlangan daginn sitja þeir á svikráðum, brugga mér banaráð. ");
INSERT INTO isl_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","15","En illráð þeirra verka ekki á mig! Ég virði þá ekki viðlits. Áform þeirra rætast ekki, ");
INSERT INTO isl_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","því að ég vona á þig, Drottinn, Guð minn. Kom þú og vernda mig. ");
INSERT INTO isl_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Þaggaðu niður í þeim sem hlæja að óförum mínum. ");
INSERT INTO isl_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Ég er að falli kominn og angist mín er enn hin sama. ");
INSERT INTO isl_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Ég játa syndir mínar og iðrast þess sem ég hef gert. ");
INSERT INTO isl_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","En ofsóknum óvina minna linnir ekki og heift þeirra minnkar ekki. Þeir hata mig án ástæðu. ");
INSERT INTO isl_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","Þeir launa mér gott með illu, hata mig fyrir góðverk mín. ");
INSERT INTO isl_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Yfirgefðu mig ekki, Drottinn. Vík ekki frá mér! ");
INSERT INTO isl_vpl VALUES ("PS38_23","020_38_23","PSA","38","23","23","Komdu skjótt og hjálpaðu mér, þú frelsari minn! ");
INSERT INTO isl_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","2","Ég hugsaði: „Ég ætla ekki að kvarta, né segja neitt ljótt meðan óguðlegir heyra til.“ ");
INSERT INTO isl_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","4","Og ég þagði. En hið innra leið mér verr og verr. Ég hélt aftur af mér, en gremjan magnaðist í mér. Að lokum gat ég ekki orða bundist: ");
INSERT INTO isl_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","„Drottinn, fæ ég aðeins að lifa örfá ár í viðbót? ");
INSERT INTO isl_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","7","Ævi mín er lítið lengri en höndin á mér! Og í þínum augum er hún nánast ekki neitt! Maðurinn, hvað er hann? Vindblær, flöktandi skuggi! Ys hans og amstur kemur engu til leiðar. Hann rakar saman fé sem svo aðrir eyða!“ ");
INSERT INTO isl_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","En á hvern vona ég þá? Drottinn, ég vona á þig! ");
INSERT INTO isl_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Frelsa mig frá syndum mínum svo að heimskingjarnir hafi mig ekki að spotti. ");
INSERT INTO isl_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Drottinn, ég þegi því að þú hefur talað. Ég vil ekki kvarta, því að þú hefur refsað mér. ");
INSERT INTO isl_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Drottinn láttu refsingu þína taka enda – ég þoli ekki meira! ");
INSERT INTO isl_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Þegar þú hirtir manninn vegna synda hans, þá er nánast úti um hann. Hann er sem mölétin flík, já, hann líður burt eins og gufa. ");
INSERT INTO isl_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Heyr þú bæn mína, Drottinn, hlustaðu á hróp mitt! Vertu ekki hljóður við tárum mínum. Mundu að ég er gestur hér, förumaður á þessari jörð eins og forfeður mínir. ");
INSERT INTO isl_vpl VALUES ("PS39_14","020_39_14","PSA","39","14","14","Miskunna þú mér, Drottinn og læknaðu mig. Lofaðu mér aftur að sjá glaðan dag áður en ég dey. ");
INSERT INTO isl_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","2","Ég setti alla mína von á Drottin. Hann heyrði kvein mitt og að lokum bjargaði hann mér. ");
INSERT INTO isl_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Hann dró mig upp úr glötunargröfinni, hinni botnlausu leðju, og lyfti mér upp á klett. Hann gerði mig styrkan í gangi. ");
INSERT INTO isl_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Þá fylltist munnur minn lofsöng – lofgjörð um Guð. Margir hlustuðu er ég söng um velgjörðir hans við mig. Þeir munu einnig lúta honum og lofa hann, setja traust sitt á hann. ");
INSERT INTO isl_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Þeir sem treysta Drottni verða lánsamir, þeir sem forðast ráð dramblátra og halda sér frá lygi. ");
INSERT INTO isl_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Drottinn, Guð minn, mörg dásemdarverk hefur þú gert og mikillar umhyggju höfum við notið. Ekkert kemst í samjöfnuð við þig! Mér endist ekki tími til að rifja upp öll þín undraverk! ");
INSERT INTO isl_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Sláturfórnir og matfórnir þráir þú ekki frá lýð þínum, og brennifórnir heimtar þú ekki. Nei, þú þráir að ég þjóni þér alla ævi. ");
INSERT INTO isl_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Ég sagði: „Sjá, ég kem, rétt eins og orð þitt býður mér. ");
INSERT INTO isl_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Það að gera vilja þinn, Drottinn minn, þrái ég því að lögmál þitt er ritað á hjarta mitt!“ ");
INSERT INTO isl_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Ég hef vitnað um það fyrir öllum, aftur og aftur, að þú fyrirgefur syndir. Það veistu Drottinn. ");
INSERT INTO isl_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Ég hef ekki þagað yfir réttlæti þínu heldur boðað það öllum. Allur söfnuðurinn hefur heyrt mig tala um elsku þína og trúfesti. ");
INSERT INTO isl_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Þess vegna, Drottinn minn, taktu ekki miskunn þína frá mér! Ég á allt mitt undir kærleika þínum og náð. ");
INSERT INTO isl_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","Sért þú ekki með mér, er úti um mig. Vandamál mín eru mér ofvaxin, og syndir mínar – sem eru fleiri en hárin á höfði mér – hafa lamað mig. Ég veit ekki mitt rjúkandi ráð. ");
INSERT INTO isl_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Ó, Drottinn, ég hrópa til þín! Frelsa þú mig! Komdu fljótt og hjálpaðu mér. ");
INSERT INTO isl_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","16","Ruglaðu þá í ríminu; sem sækjast eftir lífi mínu. Sendu þá burt með skömm! ");
INSERT INTO isl_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Allir þeir sem elska Drottin og leita hans, skulu gleðjast yfir hjálpræði hans. Þeir segi án afláts: „Mikill er Drottinn!“ ");
INSERT INTO isl_vpl VALUES ("PS40_18","020_40_18","PSA","40","18","18","Ég er aumur og fátækur, en þó ber Drottinn umhyggju fyrir mér. Þú, Guð minn, ert hjálp mín, og frelsari; Ó, komdu og bjargaðu mér! Láttu það ekki dragast!. ");
INSERT INTO isl_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","2","Guð blessar þann sem hjálpar bágstöddum. Á mæðudeginum bjargar Drottinn honum. ");
INSERT INTO isl_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Drottinn verndar hann og heldur í honum lífinu. Hann lætur hann njóta sæmdar og frelsar hann frá óvinum hans. ");
INSERT INTO isl_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Drottinn annast hann á sóttarsæng, veitir honum hvíld og hressing. ");
INSERT INTO isl_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Ég bað: „Drottinn, miskunnaðu mér. Læknaðu sál mína því að ég hef syndgað gegn þér.“ ");
INSERT INTO isl_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Óvinir mínir biðja mér bölbæna og segja: „Bara að hann deyi sem fyrst svo að allir gleymi honum!“ ");
INSERT INTO isl_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Sumir sem heimsækja mig í veikindunum eru að þykjast. Innst inni hata þeir mig og líkar vel að ég er sjúkur. Þegar út er komið baktala þeir mig. ");
INSERT INTO isl_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","Hatursmenn mínir hæða mig og spotta. Þeir skrafa og pískra hvað gera skuli þegar ég er allur ");
INSERT INTO isl_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","„Þetta er banvænt, hvað sem það er,“ segja þeir, „honum mun aldrei batna.“ ");
INSERT INTO isl_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Og besti vinur minn, hann snerist líka gegn mér, maðurinn sem ég treysti svo vel, hann sem át við borð mitt. ");
INSERT INTO isl_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","En, Drottinn, yfirgef mig ekki! Miskunnaðu mér og læknaðu mig svo að ég geti endurgoldið þeim! ");
INSERT INTO isl_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Ég veit að þú elskar mig og að þú munt ekki láta óvini mína hlakka yfir mér. ");
INSERT INTO isl_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Vegna sakleysis míns hefur þú varðveitt mig og lætur mig lifa með þér að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS41_14","020_41_14","PSA","41","14","14","Lofaður sé Drottinn, Guð Ísraels, frá eilífð til eilífðar. Amen. Amen. ");
INSERT INTO isl_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","2","Eins og hindin þráir vatnslindir, þrái ég þig, ó Guð. ");
INSERT INTO isl_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Mig þyrstir eftir Guði, hinum lifandi Guði. Hvenær fæ ég að koma og standa frammi fyrir honum? ");
INSERT INTO isl_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Daga og nætur leita ég hans grátandi, en óvinir mínir spotta mig og segja: „Hvar skyldi Guð þinn vera?!“ ");
INSERT INTO isl_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","6","Hresstu þig nú, sál mín! Minnstu þess er þú á hátíðum leiddir skrúðgönguna til musterisins, og söngst lofsöng um Drottin? Það var ógleymanlegt! Til hvers þá að vera hnugginn? Hvers vegna að súta og syrgja? Treystu Drottni! Já, svo sannarlega vil ég lofa hann á ný. Aftur vil ég þakka honum hjálp hans. ");
INSERT INTO isl_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Ég er dapur og stúrinn, en samt vil ég hugsa um þig hér við fjöllin Misar og Hermon þar sem Jórdan streymir fram. ");
INSERT INTO isl_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Bylgjur þínar hafa brotnað á mér og fossar þínir baðað mig í sorg. ");
INSERT INTO isl_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","En þó streymir náð Drottins til mín dag eftir dag og um nætur lofa ég hann og bið til Guðs sem gaf mér lífið. ");
INSERT INTO isl_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Ég bið og segi: „Ó, þú Guð, klettur minn.“ „Hvers vegna hefur þú yfirgefið mig? Hvers vegna verð ég að þola árásir óvina minna?“ ");
INSERT INTO isl_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Mig svíður undan ögrunum þeirra og aftur og aftur gera þeir gys að mér. „Hvar er þessi Guð þinn?!“ segja þeir. ");
INSERT INTO isl_vpl VALUES ("PS42_12","020_42_12","PSA","42","12","12","En sál mín, misstu ekki móðinn. Láttu þér ekki gremjast það. Vonaðu á Guð. Já ég veit að hann mun hjálpa mér og þá mun ég lofa hann fyrir allt það sem hann gerir. Hann er björgun mín! Hann er minn Guð! ");
INSERT INTO isl_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Ó, Guð, láttu mig ná rétti mínum gegn svikulum og vondum mönnum sem ásaka mig. ");
INSERT INTO isl_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Þú einn ert Guð, skjól mitt og vígi. Hvers vegna hefur þú vísað mér frá? Hví verð ég að ganga um harmandi, kúgaður af óvinum? ");
INSERT INTO isl_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Sendu ljós þitt og sannleika til að vísa mér veginn að musteri þínu á Síon, fjallinu þínu helga. ");
INSERT INTO isl_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Þar vil ég ganga að altari Guðs, uppsprettu gleðinnar, og lofa hann með hörpuleik. Ó, Guð, – minn Guð! ");
INSERT INTO isl_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Sál mín hvers vegna ertu döpur og kjarklaus? Treystu Guði! Víst mun ég fá að lofa hann á ný, því hann mun hjálpa mér og aftur mun auglit mitt gleðjast! ");
INSERT INTO isl_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","2","Guð, við höfum heyrt um máttarverk þín á dögum forfeðra okkar. Þeir hafa sagt: ");
INSERT INTO isl_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Hann rak heiðnu þjóðirnar úr landinu og gaf okkur það, lét Ísrael setjast hér að. ");
INSERT INTO isl_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Ekki sigruðu þeir af eigin krafti, heldur vegna máttar þíns og velþóknunar þinnar á þeim. ");
INSERT INTO isl_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Þú ert konungur minn og Guð. Láttu þjóð þína vinna sigur! ");
INSERT INTO isl_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Aðeins í þínum krafti og nafni sigrum við óvininn. ");
INSERT INTO isl_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Vopnin duga skammt, þau tryggja ekki sigur. ");
INSERT INTO isl_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Aðeins með þinni hjálp getum við sigrað. ");
INSERT INTO isl_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Guð, aftur og aftur hrósa ég mér af þér. Hvernig get ég þakkað þér sem skyldi! ");
INSERT INTO isl_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","En þó hefur þú, Drottinn, nú um stund yfirgefið okkur og ekki stutt í orustum. ");
INSERT INTO isl_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Já, þú hefur barist gegn okkur og við höfum flúið. Óvinir okkar gerðu árás. Þeir rændu og rupluðu. ");
INSERT INTO isl_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Þú hefur farið með okkur eins og sláturfé, tvístrað okkur meðal þjóðanna. ");
INSERT INTO isl_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Þú selur þjóð þína fyrir lítið, metur hana einskis virði. ");
INSERT INTO isl_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Nágrannarnir hæða okkur og spotta vegna alls sem þú lætur á okkur dynja. ");
INSERT INTO isl_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Þín vegna er „Gyðingur!“ háðsyrði og hneyksli meðal þjóðanna, öllum til ama. ");
INSERT INTO isl_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","17","Ég verð fyrir stöðugum skömmum, mér er formælt og ég fyrirlitinn af hefnigjörnum óvinum. ");
INSERT INTO isl_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Og þetta hefur gerst, Drottinn, þrátt fyrir tryggð okkar við þig. Sáttmála þinn höfum við ekki rofið. ");
INSERT INTO isl_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Ekki höfum við snúið okkur gegn þér, ekki vikið eitt skref af vegi þínum! ");
INSERT INTO isl_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Væri svo, gætum við skilið refsingu þína, landauðn og niðdimmu dauðans. ");
INSERT INTO isl_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","Ef við hefðum hætt að tilbiðja Guð og snúið okkur að hjáguðadýrkun, ");
INSERT INTO isl_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","hefði honum þá ekki verið kunnugt um það? Hann sem þekkir alla hluti og leyndarmál mannanna. ");
INSERT INTO isl_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","En það höfum við ekki gert. Við erum í dauðans hættu fyrir það eitt að þjóna þér! Við erum eins og lömb leidd til slátrunar! ");
INSERT INTO isl_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Vakna þú! Rís þú á fætur! Hvers vegna sefur þú, Drottinn? Hefur þú hafnað okkur fyrir fullt og allt? ");
INSERT INTO isl_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Hvers vegna horfir þú í aðra átt? Af hverju er þér sama um sorg okkar og neyð? ");
INSERT INTO isl_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Við erum fallnir og liggjum hér endilangir. ");
INSERT INTO isl_vpl VALUES ("PS44_27","020_44_27","PSA","44","27","27","Rís þú upp, Drottinn, komdu og hjálpaðu okkur! Frelsaðu okkur vegna eilífrar elsku þinnar. ");
INSERT INTO isl_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","2","Hjarta mitt svellur af fögrum orðum. Ég vil flytja konungi ljóð. Tunga mín er penni hraðritarans, hún flytur langa sögu á augabragði: ");
INSERT INTO isl_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Þú ert fegurri en mannanna börn. Blessun streymir um varir þínar. Velþóknun Guðs er yfir þér að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Þú hetja, tak herklæði þín, máttugur ertu og krýndur ljóma ");
INSERT INTO isl_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Sæktu fram! Sigursæll ertu, vörður tryggðar og réttlætis. Gakk fram – máttarverk þín verði á allra vörum! ");
INSERT INTO isl_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Örvar þínar eru hvesstar, óvinir falla að fótum þér. ");
INSERT INTO isl_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Hásæti þitt, ó Guð, stendur um eilífð. Réttlætið er sproti þinn. ");
INSERT INTO isl_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Þú elskar hið góða hefur andstyggð á illsku. Því hefur Guð, þinn Guð, sveipað þig gleði sem engan annan. ");
INSERT INTO isl_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Skikkja þín ilmar af myrru, alóe og kassíu. Hallir þínar eru skreyttar fílabeini og fyllast af ljúfum tónum. ");
INSERT INTO isl_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Konungadætur eru í hópi vinkvenna þinna. Drottningin stendur þér við hlið, fagurlega klædd og skreytt skíra gulli frá Ófír! ");
INSERT INTO isl_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","12","„Dóttir mín, hlustaðu. Ég vil gefa þér ráð: Gleymdu heimþránni, vertu ekki döpur. Konungurinn elskar þig og gleðst yfir fegurð þinni. Sýndu honum lotningu því hann er herra þinn. ");
INSERT INTO isl_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Íbúar Týrus, baða þig í gjöfum og auðmenn þjóðarinnar leita hylli þinnar.“ ");
INSERT INTO isl_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Brúðurin – konungsdóttir – bíður í skrauthýsi sínu, íklædd fegursta djásni, kjól skreyttum gulli og perlum. ");
INSERT INTO isl_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Fögur er hún! Meyjarnar leiða hana á fund konungs. ");
INSERT INTO isl_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Þær fara í skrúðgöngu gegnum hliðið. Þarna er höllin! ");
INSERT INTO isl_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","„Synir þínir verða allir konungar og feta í fótspor föður síns. Þeir munu sitja á hásætum víðs vegar um heim!“ ");
INSERT INTO isl_vpl VALUES ("PS45_18","020_45_18","PSA","45","18","18","„Ég mun gera nafn þitt kunnugt meðal allra kynslóða og þjóðir jarðarinnar munu hylla þig að eilífu.“ ");
INSERT INTO isl_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","2","Guð er mér hæli og styrkur, örugg hjálp í nauðum. ");
INSERT INTO isl_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Þess vegna óttumst við ekki, þótt heimurinn farist og fjöllin steypist í hafið. ");
INSERT INTO isl_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Hafið æði og freyði, fjöllin nötri og skjálfi! ");
INSERT INTO isl_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Lækir gleðinnar streyma frá borg Guðs – frá heilögum bústað Guðs hins hæsta. ");
INSERT INTO isl_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Hér býr Guð, hún mun ekki haggast. Þegar þörf er á, kemur Guð henni til hjálpar. ");
INSERT INTO isl_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Þjóðir risu upp og létu ófriðlega en þegar Guð talaði varð heimurinn að þagna og jörðin nötraði. ");
INSERT INTO isl_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Drottinn, hann sem ræður hersveitum himinsins, er hér! Hann er á meðal okkar! Hann, Guð Jakobs, er kominn til að hjálpa. ");
INSERT INTO isl_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Komið og sjáið máttarverk hans á jörðinni. ");
INSERT INTO isl_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Hann stöðvar styrjaldir um víða veröld, brýtur vopnin og kastar á eld. ");
INSERT INTO isl_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","„Þögn! Standið kyrr! Vitið að ég er Guð! Allar þjóðir heims syni mér lotningu.“ ");
INSERT INTO isl_vpl VALUES ("PS46_12","020_46_12","PSA","46","12","12","Drottinn hersveita himinsins er hér, hann er á meðal okkar! Hann, Guð Jakobs, er hér til að frelsa! ");
INSERT INTO isl_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","2","Komið allar þjóðir! Klappið saman höndum af gleði! Hrópið af fögnuði fyrir Guði! ");
INSERT INTO isl_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Drottinn er æðri öllum guðum. Hann er ógurlegur. Honum verður ekki með orðum lýst. Hann er konungur til endimarka jarðarinnar. ");
INSERT INTO isl_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Hann hefur beygt þjóðir undir sig ");
INSERT INTO isl_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","og valið úr yndislegt land og gefið okkur, þjóð sinni, Ísrael. ");
INSERT INTO isl_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Guð er stiginn upp með miklu hrópi og hvellum lúðurhljómi. ");
INSERT INTO isl_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","8","Lofsyngið Guði, konungi okkar. Já, syngið lofgjörðarsöng fyrir konunginn, konung allrar jarðarinnar. Lofsyngið Guði! ");
INSERT INTO isl_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Hann ríkir yfir þjóðunum. Hann situr á hásæti sínu. ");
INSERT INTO isl_vpl VALUES ("PS47_10","020_47_10","PSA","47","10","10","Leiðtogar heimsins koma og taka undir lofgjörðina með lýð Guðs Abrahams. Skjaldarmerki þjóðanna eru sigurtákn hans. Hann er mjög upphafinn. Hann er konungur alls heimsins. ");
INSERT INTO isl_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","2","Mikill er Drottinn! Vegsömum hann, já lofum hann! Hann býr á sínu helga fjalli í Jerúsalem. ");
INSERT INTO isl_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Fallegt er Síonfjall í norðri. Fjallið sem þjóðin elskar, þar sem konungurinn mikli býr. ");
INSERT INTO isl_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Drottinn sjálfur er verndari Jerúsalem. ");
INSERT INTO isl_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","Konungar jarðarinnar sátu þar ráðstefnu. Þeir skoðuðu borgina. ");
INSERT INTO isl_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Þeir urðu agndofa, hræddir og flýðu. ");
INSERT INTO isl_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Hátign Jerúsalem skelfdi þá. Þeir urðu magnþrota eins og kona sem fæðir barn! ");
INSERT INTO isl_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Því að með austanvindinum einum tortímir þú heilum her! ");
INSERT INTO isl_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Dýrð þín, Jerúsalem, er á allra vörum. Þú ert borgin þar sem Guð býr, hann sem ríkir yfir hersveitum himinsins. Við höfum séð hana eigin augum! Guð hefur reist Jerúsalem. Hún mun standa að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Drottinn, í musterinu hugleiðum við kærleika þinn. ");
INSERT INTO isl_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Nafn þitt er þekkt um alla jörðina. Þú ert lofaður um víða veröld vegna hjálpræðis þíns. Vegsemd þín breiðist um allan heim því alls staðar framkvæmir þú réttlætisverk. ");
INSERT INTO isl_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Gleð þig, Jerúsalem! Gleð þig Júdaættkvísl! Því að Guð mun vissulega láta þig ná rétti þínum. ");
INSERT INTO isl_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","Komið og skoðið borgina! Gangið um og teljið turnana! ");
INSERT INTO isl_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","15","Lítið á múrinn og sjáið hallirnar og segið komandi kynslóð frá því að slíkur sé Drottinn! Hann mun leiða okkur um aldur og ævi. ");
INSERT INTO isl_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","3","Hlustið nú háir og lágir, ríkir og fátækir. Allir heimsbúar hlýðið á. ");
INSERT INTO isl_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Ég tala til ykkar vísdómsorð. ");
INSERT INTO isl_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","Með undirleik hörpu kveð ég um hyggindi, veiti svör við spurningum lífsins: ");
INSERT INTO isl_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Láttu ekki ógæfuna hræða þig, né óvini sem umkringja þig með illsku! ");
INSERT INTO isl_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Auðæfum sínum treysta þeir og stæra sig af miklu ríkidæmi ");
INSERT INTO isl_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","en þó gæti enginn þeirra greitt Guði lausnargjald fyrir bróður sinn, keypt hann lausan. ");
INSERT INTO isl_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","10","Sál mannsins er dýrmætari en svo að hún verði keypt fyrir fé. Auður alls heimsins hrekkur ekki til að kaupa einum manni líf og forða honum frá gröfinni. ");
INSERT INTO isl_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Þið auðmenn og vitringar og aðrir sem hreykið ykkur hátt, þið munuð farast eins og aðrir menn. Þið hafið enga kröfu til lífsins fremur en fífl og fáráðlingar. Þið verðið að eftirláta öðrum auð ykkar. ");
INSERT INTO isl_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Hús og eignir bera nöfn ykkar rétt eins og þið ætlið að búa þar að eilífu! ");
INSERT INTO isl_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Nei, maðurinn verður að deyja. Hann er eins og skepnurnar, þrátt fyrir frægð sína og frama. ");
INSERT INTO isl_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Slík verða afdrif hinna hrokafullu en samt mun þeirra getið með virðingu þegar þeir eru dauðir. ");
INSERT INTO isl_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","En þeir fá ekki umflúið dauðann. Þegar upp er staðið verða hinir vondu að þjóna hinum góðu. Vald auðsins er þeim gagnslaust í dauðanum og ekki taka þeir auðæfi sín með sér. ");
INSERT INTO isl_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","En hvað um mig? Guð mun leysa sál mína frá dauða og frelsa mig úr helju. ");
INSERT INTO isl_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Vertu ekki gramur þótt einhver verði ríkur og reisi sér glæsihöll. ");
INSERT INTO isl_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Ekkert af því mun hann taka með sér í gröfina, ekki einu sinni frægð sína! ");
INSERT INTO isl_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","Í lifanda lífi telur hann sig heppinn og heimurinn klappar honum lof í lófa, ");
INSERT INTO isl_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","en þó deyr hann eins og aðrir og hverfur inn í myrkrið. ");
INSERT INTO isl_vpl VALUES ("PS49_21","020_49_21","PSA","49","21","21","Sá sem elskar eigin lofstír deyr eins og skepnan, þrátt fyrir frægð sína og frama. ");
INSERT INTO isl_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Drottinn er alvaldur Guð. Hann kallar þjóð sína saman úr austri og vestri. ");
INSERT INTO isl_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Dýrð Guðs ljómar frá musteri hans á Síonfjalli. ");
INSERT INTO isl_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Hann birtist í þrumugný, umlukinn eyðandi eldi og stormviðri. ");
INSERT INTO isl_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Hann er kominn til að dæma lýð sinn. Hróp hans heyrist á himni og jörðu: ");
INSERT INTO isl_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","„Safnið saman þjóð minni sem með fórnunum á altari mínu hefur gert sáttmála við mig.“ ");
INSERT INTO isl_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Guð mun dæma réttláta dóma. Himinninn vitnar um réttlæti hans. ");
INSERT INTO isl_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","Hlusta þú, þjóð mín! Ég er þinn Guð! Taktu eftir úrskurði mínum: ");
INSERT INTO isl_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Fórnir þínar tek ég gildar. Þar hefur þú sýnt trúfesti. ");
INSERT INTO isl_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","En ég girnist þó ekki uxa þína og geitur, ");
INSERT INTO isl_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","11","því að öll dýr jarðarinnar tilheyra mér! Hjarðirnar á fjöllunum og fuglar loftsins – allt er það mitt. ");
INSERT INTO isl_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Væri ég hungraður, segði ég þér ekki frá því – allt á jörðu er mitt, ekkert er undan skilið. ");
INSERT INTO isl_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Nei, ég þrái ekki kjötfórnir þínar og blóðfórnir, ");
INSERT INTO isl_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","15","heldur þakklæti og orðheldni. Ákallaðu mig á degi neyðarinnar og þá mun ég frelsa þig. Og þú skalt vegsama mig. Já, þetta skaltu gera. ");
INSERT INTO isl_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","En við hina óguðlegu segir Drottinn: „Hættið að þylja upp lögmál mitt og heimta af mér, ");
INSERT INTO isl_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","þið sem hafnið aga og lítilsvirðið boðorð mín. ");
INSERT INTO isl_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Þið aðstoðið þjófinn og samneytið hórkörlum. ");
INSERT INTO isl_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Þið bölvið og ljúgið ");
INSERT INTO isl_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","og baktalið bróður ykkar. ");
INSERT INTO isl_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Þannig ferst ykkur og svo á ég að þegja?! Er ég þá eins og þið? Nei, ég mun hegna ykkur svo ekki verður um villst. ");
INSERT INTO isl_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","En þið sem gleymduð Guði, fáið eitt tækifæri enn, síðan læt ég eyðinguna koma og þá er allt um seinan. ");
INSERT INTO isl_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Sá sem færir þakkargjörð að fórn, heiðrar mig. Og þeir sem breyta eftir orðum mínum fá að sjá hjálpræði mitt.“ ");
INSERT INTO isl_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Þennan sálm orti Davíð ");
INSERT INTO isl_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","eftir að Natan spámaður hafði birt honum dóm Guðs vegna hórdóms hans með Batsebu og morðsins á Úría eiginmanni hennar. ");
INSERT INTO isl_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Þú góði og miskunnsami Guð, ó, fyrirgefðu mér! Vertu mér náðugur! Taktu burt synd mína og skömm! ");
INSERT INTO isl_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Þvoðu mig hreinan af syndasekt minni. Hreinsaðu hjarta mitt ");
INSERT INTO isl_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","því að ég játa synd mína – daga og nætur minnir hún á sig! ");
INSERT INTO isl_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Gegn þér, já þér einum, hef ég brotið. Drýgt hræðilega synd. Þú varst vitni að öllu þessu og dómur þinn er réttlátur. ");
INSERT INTO isl_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Syndugur var ég þegar móðir mín fæddi mig, sekur þegar ég varð til. ");
INSERT INTO isl_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Þú vilt að menn séu hreinskilnir við sjálfa sig, einlægir og segi satt. Gefðu mér náð til að gera það! ");
INSERT INTO isl_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Þvoðu mig að ég verði hreinn, hreinsaðu mig svo ég verði hvítari en snjór. ");
INSERT INTO isl_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Og þegar þú hefur refsað mér, þá gefðu mér gleði mína á ný. ");
INSERT INTO isl_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Einblíndu ekki á syndir mínar, heldur afmáðu þær allar. ");
INSERT INTO isl_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Skapaðu í mér nýtt og hreint hjarta, ó Guð! Gefðu mér þinn heilaga anda svo að ég hugsi rétt og þrái það sem gott er. ");
INSERT INTO isl_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Varpaðu mér ekki burt frá þér og taktu ekki þinn heilaga anda frá mér. ");
INSERT INTO isl_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Fylltu mig aftur gleði þíns hjálpræðis og löngun til að hlýða þér! ");
INSERT INTO isl_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Þá get ég leitt aðra syndara inn á veg þinn svo að þeir – sekir eins og ég – játi syndir sínar og snúi sér til þín. ");
INSERT INTO isl_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","17","Frelsaðu mig frá dauðans háska, ó Guð minn. Þú einn getur frelsað mig! Leyf mér að syngja um miskunn þína, Drottinn. Opnaðu varir mínar svo að ég megi vegsama þig! ");
INSERT INTO isl_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Þú hefur ekki þóknun á dýrafórnum, annars myndi ég láta þær í té. Og brennifórnir eru ekki í uppáhaldi hjá þér. ");
INSERT INTO isl_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Þetta vilt þú: Auðmjúkan anda og iðrandi samvisku. Þann sem iðrast af öllu hjarta, munt þú ó Guð, ekki fyrirlíta. ");
INSERT INTO isl_vpl VALUES ("PS51_20","020_51_20","PSA","51","20","20","Drottinn, lát Ísrael ekki gjalda syndar minnar. Hjálpaðu þjóð þinni og vernda Jerúsalem. ");
INSERT INTO isl_vpl VALUES ("PS51_21","020_51_21","PSA","51","21","21","Þegar hjarta mitt er rétt gagnvart þér, þá gleðst þú yfir verkum mínum og því sem ég fórna á altari þínu. ");
INSERT INTO isl_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Þennan sálm orti Davíð ");
INSERT INTO isl_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","til að andmæla óvini sínum Dóeg sem síðar tók af lífi áttatíu og fimm presta og fjölskyldur þeirra (sjá: 1. Sam. 22.). ");
INSERT INTO isl_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Kallar þú þig hetju?! Þú sem hreykir þér af ódæði gegn þjóð Guðs og herðir þig gegn miskunn hans. ");
INSERT INTO isl_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Þú ert eins og skeinuhættur hnífur, þú svikahrappur! ");
INSERT INTO isl_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Þú elskar illt meir en gott, lygi umfram sannleika. ");
INSERT INTO isl_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Rógburð elskar þú og annað skaðræðistal! ");
INSERT INTO isl_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","En Guð mun koma þér á kné, draga þig út úr húsi þínu og uppræta af landi lifenda. ");
INSERT INTO isl_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Hinir réttlátu munu sjá það og óttast Guð, síðan hlægja og segja: ");
INSERT INTO isl_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","„Svo fer fyrir þeim sem fyrirlíta Guð og treysta á mátt sinn og megin, þeim sem þrjóskast í illsku sinni.“ ");
INSERT INTO isl_vpl VALUES ("PS52_10","020_52_10","PSA","52","10","10","Ég er sem grænt olífutré í garði Guðs. Ég treysti á miskunn hans meðan ég lifi. ");
INSERT INTO isl_vpl VALUES ("PS52_11","020_52_11","PSA","52","11","11","Drottinn, ég vil vegsama þig að eilífu og þakka það sem þú hefur gert. Ég segi hinum trúuðu: Góður er Guð! ");
INSERT INTO isl_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","2","En sú heimska að segja: „Guð er ekki til.“ Hvers vegna segja menn slíkt? Vegna þess að hjörtu þeirra eru spillt og verk þeirra vond. ");
INSERT INTO isl_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Guð lítur niður af himni. Hann rennir augum yfir mannanna börn. Skyldi nokkur vera hygginn og leita vilja Guðs? ");
INSERT INTO isl_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Nei, allir hafa þeir snúið í hann baki. Þeir eru spilltir. Enginn þeirra gerir vilja Guðs, ekki einn einasti! ");
INSERT INTO isl_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Þeir munu fá sinn dóm, illgjörðamennirnir sem ofsækja lýð Guðs. ");
INSERT INTO isl_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Þeir munu þjást af ótta, jafnvel þegar engin hætta er! Guð mun á sínum tíma tvístra þeim. Hann hefur fellt sinn dóm og hafnað þeim. ");
INSERT INTO isl_vpl VALUES ("PS53_7","020_53_7","PSA","53","7","7","Ó, að Guð kæmi frá Síon og frelsaði Ísrael! Þá munum við taka gleði okkar á ný. ");
INSERT INTO isl_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Sálmur eftir Davíð, ");
INSERT INTO isl_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","ortur þegar menn frá Síf reyndu að svíkja hann í hendur Sál konungs. ");
INSERT INTO isl_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Komdu í mætti þínum, ó Guð, og bjargaðu mér! Verndaðu mig með krafti þínum! ");
INSERT INTO isl_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Bænheyrðu mig, ");
INSERT INTO isl_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","því að ofbeldismenn hafa risið gegn mér – heiðingjar sem ekki trúa á þig, sækjast eftir lífi mínu. ");
INSERT INTO isl_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","En Guð er minn hjálpari. Hann er vinur minn! ");
INSERT INTO isl_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Fyrir hans tilverknað mun illska þeirra koma þeim sjálfum í koll. Efndu loforð þitt, Guð, og þurrkaðu út þessa illvirkja. ");
INSERT INTO isl_vpl VALUES ("PS54_8","020_54_8","PSA","54","8","8","Glaður kem ég fram fyrir þig með fórn mína. Ég lofa nafn þitt, Drottinn, því það er gott. ");
INSERT INTO isl_vpl VALUES ("PS54_9","020_54_9","PSA","54","9","9","Guð hefur frelsað mig frá dauða og yfirbugað óvini mína. ");
INSERT INTO isl_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","2","Heyr bæn mína, ó Guð! Snú þér ekki frá þegar ég ákalla þig. ");
INSERT INTO isl_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Hlustaðu á ákall mitt. Ég andvarpa og græt í sorg minni. ");
INSERT INTO isl_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Óvinir mínir æpa á mig, hóta að drepa mig. Þeir umkringja mig og brugga mér banaráð, öskra á mig í hamslausri reiði. ");
INSERT INTO isl_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","6","Ég er lamaður af ótta, fullur örvæntingar. Hvílík skelfing! ");
INSERT INTO isl_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Ó, að ég hefði vængi eins og fuglinn! Þá mundi ég fljúga burt og leita skjóls. ");
INSERT INTO isl_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Ég mundi svífa langt og leita skjóls í eyðimörkinni, ");
INSERT INTO isl_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","flýja á öruggan stað, laus úr allri hættu. ");
INSERT INTO isl_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Ó, Drottinn, ruglaðu þá í ríminu! Sérðu ekki kúgunina sem viðgengst? ");
INSERT INTO isl_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Þeir vakta borgina daga og nætur, ganga múrana og skima eftir óvinum. En neyðin er innandyra, því að ofbeldi og svik eru í borginni, ");
INSERT INTO isl_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","morð og gripdeildir. ");
INSERT INTO isl_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Ekki var það óvinur minn sem ofsótti mig – það gæti ég þolað. Þá hefði ég falið mig um stund. ");
INSERT INTO isl_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","En það varst þú, vinur minn og félagi. ");
INSERT INTO isl_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Við sem vorum alúðarvinir og gengum saman í Guðs hús. ");
INSERT INTO isl_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Dauðinn taki þá og dragi þá til heljar, því að illska er í húsum þeirra, synd í hjörtum þeirra. ");
INSERT INTO isl_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","En ég hrópa til Guðs, og hann mun frelsa mig! ");
INSERT INTO isl_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Kvölds og morgna og um miðjan dag sárbæni ég Guð. Ég veit að hann heyrir til mín og mun svara mér. ");
INSERT INTO isl_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Þótt óvinir mínir séu margir, mun hann samt frelsa mig og gefa mér frið. ");
INSERT INTO isl_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Sjálfur Guð – sem er frá eilífð – mun svara mér, en óvinir mínir, breytast ekki og óttast ekki Guð. ");
INSERT INTO isl_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","En vinur minn, sveik mig og ofsótti – rauf heit sitt. ");
INSERT INTO isl_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Orðin á tungu hans voru ljúf og blíð en hjartað fullt af hatri. ");
INSERT INTO isl_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Varpaðu áhyggjum þínum á Drottin, hann ber umhyggju fyrir þér. Hann mun aldrei láta trúaðan mann verða valtan á fótum. ");
INSERT INTO isl_vpl VALUES ("PS55_24","020_55_24","PSA","55","24","24","Guð mun varpa óvinum mínum til heljar, til dánarheima. Morðingjar og svikarar munu ekki ná háum aldri. En ég treysti þér, að þú leyfir mér að lifa. ");
INSERT INTO isl_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","2","Drottinn, miskunna þú mér, því að liðlangan daginn sækja óvinir mínir að. ");
INSERT INTO isl_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Fjandmennirnir ryðjast fram, fjölmennt lið, þeir ætla að drepa mig. ");
INSERT INTO isl_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Þegar ég er hræddur, set ég traust mitt á þig. ");
INSERT INTO isl_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Ég treysti loforðum Guðs og veit því að þessir óvinir munu ekki ná mér, þeir eru aðeins dauðlegir menn! ");
INSERT INTO isl_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Þeir vinna gegn mér með öllum ráðum og hugsa um það eitt að fella mig. ");
INSERT INTO isl_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Þeir áreita mig, sitja um mig. Þeir liggja í leyni eins og stigamenn, hlusta eftir fótataki mínu og leggja ör á streng. ");
INSERT INTO isl_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Þeir halda sig sleppa við refsingu, og komast undan, en Drottinn, láttu þá fá makleg málagjöld, annað er ekki réttlátt. ");
INSERT INTO isl_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Þú þekkir alla hrakninga mína og tár, já, þekkir þau með tölu! ");
INSERT INTO isl_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Þegar ég hrópa til þín um hjálp, breytist bardaginn. Óvinir mínir flýja! Þá veit ég að Guð er með mér! Hann liðsinnir mér! ");
INSERT INTO isl_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Með hjálp Guðs mun ég lofa orð hans, já vissulega mun ég lofa orð hans. ");
INSERT INTO isl_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","Ég treysti Guði. Loforð hans eru dásamleg! Ég óttast ekki svikráð mannanna – hvað geta þeir gert mér?! ");
INSERT INTO isl_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Drottinn, ég vil standa við orð mín og þakka þér hjálpina! ");
INSERT INTO isl_vpl VALUES ("PS56_14","020_56_14","PSA","56","14","14","Þú hefur frelsað mig frá dauða og forðað frá hrösun og þess vegna fæ ég að njóta ljóss og lífs með þér. ");
INSERT INTO isl_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","2","Þennan sálm orti Davíð þegar hann flýði inn í hellinn undan Sál. (Sjá 1. Sam. 22:1‑2 og 24:1‑9). Ó Guð, vertu mér náðugur, því að ég treysti þér. Ég vil leita skjóls undir vængjum þínum uns storminn hefur lægt. ");
INSERT INTO isl_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Ég hrópa til Guðs hins hæsta, hans sem leysir öll mín mál. ");
INSERT INTO isl_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Hann sendir mér hjálp frá himnum og frelsar mig vegna elsku sinnar og trúfesti. Hann mun bjarga mér frá lygurum sem sitja um líf mitt. ");
INSERT INTO isl_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Ég er umkringdur ofstopamönnum – glefsandi úlfum. Tennur þeirra eru hvassari en örvar og spjót og tungurnar beittari en sverð! ");
INSERT INTO isl_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Drottinn, lofað sé nafn þitt á himnum! Láttu dýrð þína líka birtast á jörðu! ");
INSERT INTO isl_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Óvinir mínir hafa lagt gildru fyrir mig. Þeir hafa grafið mér gryfju. Ég er mæddur og kvíðinn. En! Eitt veit ég: Þeir munu sjálfir falla í hana! ");
INSERT INTO isl_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Guð minn, nú er hjarta mitt rótt og ég treysti þér. Ég vil lofa þig! ");
INSERT INTO isl_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Rís þú nú upp, sál mín! ");
INSERT INTO isl_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Vakna þú harpa og gígja! Bjóddu morgunroðann velkominn með söng! Allir landsbúar heyra þakkargjörð mína. ");
INSERT INTO isl_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Ég vil syngja þér lof meðal þjóðanna. ");
INSERT INTO isl_vpl VALUES ("PS57_12","020_57_12","PSA","57","12","12","Miskunn þín er há eins og himinninn og trúfesti þín nær til skýjanna. ");
INSERT INTO isl_vpl VALUES ("PS57_13","020_57_13","PSA","57","13","13","Þú ert hærri en hæstu himnar, ó, Guð. Láttu dýrð þína breiðast yfir gjörvalla jörðina. ");
INSERT INTO isl_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","2","Þið konungar og leiðtogar þjóðanna, talið þið sannleika? Er réttlæti í dómum ykkar og úrskurðum? ");
INSERT INTO isl_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Nei, svo er ekki. Þið eruð allir svikarar sem seljið „réttlæti“ fyrir mútur. ");
INSERT INTO isl_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Slíkir menn hafa allt frá fæðingu vikið af réttum vegi. Þeir hafa talað lygi frá því þeir fengu málið. ");
INSERT INTO isl_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","6","Eiturnöðrur eru þeir, slöngur sem daufheyrast við skipunum særingamannsins. ");
INSERT INTO isl_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Drottinn, slíttu úr þeim eiturbroddinn! Dragðu vígtennurnar úr þessum vörgum, ó Guð. ");
INSERT INTO isl_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Láttu þá hverfa eins og jörðin hafi gleypt þá. Sláðu vopnin úr höndum þeirra. ");
INSERT INTO isl_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Láttu þá þorna upp eins og snigla og ekki sjá sólina frekar en þeir sem andvana eru fæddir. ");
INSERT INTO isl_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Guð mun svipta þeim burt, eyða þeim skjótar en pottur hitnar yfir eldi. ");
INSERT INTO isl_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Þá munu hinir guðhræddu fagna, þegar réttlætið sigrar og þeir fá að ganga um blóðidrifin stræti fallinna óvina. ");
INSERT INTO isl_vpl VALUES ("PS58_12","020_58_12","PSA","58","12","12","Þá munu menn sjá að réttlætið sigrar og að Guð dæmir jörðina með réttvísi. ");
INSERT INTO isl_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","Þennan sálm orti Davíð þegar Sál konungur sendi menn heim til hans til að handsama hann og drepa (sjá: 1. Sam. 19:11). ");
INSERT INTO isl_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Ó, Guð minn, frelsaðu mig frá óvinum mínum! Verndaðu mig gegn þeim sem vilja drepa mig! ");
INSERT INTO isl_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","Forðaðu mér frá þessum glæpalýð, þessum morðingjum. ");
INSERT INTO isl_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Þeir sitja um líf mitt. Sterkir menn bíða útifyrir. Drottinn, þeir eru ekki hér af því að ég hafi gert þeim rangt. ");
INSERT INTO isl_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Samt vilja þeir drepa mig! Drottinn, vaknaðu! Sjáðu hvað er að gerast! Hjálpaðu mér! ");
INSERT INTO isl_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Þú Drottinn, Guð hinna himnesku hersveita, Guð Ísraels, rís þú upp og refsa heiðnu þjóðunum sem umhverfis okkur búa. Miskunna ekki illgjörðamönnum. ");
INSERT INTO isl_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Að kvöldi koma þeir og njósna. Þeir snuðra eins og hundar og ráfa um borgina. ");
INSERT INTO isl_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Ég heyri háðsglósur þeirra og hvernig þeir formæla Guði. „Enginn heyrir til okkar,“ segja þeir. ");
INSERT INTO isl_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","En þú Drottinn, hlærð að þeim, gerir einnig gys að heiðingjunum sem umhverfis okkur búa. ");
INSERT INTO isl_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Guð, þú ert styrkur minn! Ég vil syngja þér lof, því að þú ert skjól mitt og hlíf. ");
INSERT INTO isl_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Guð mætir mér með náð sinni. Hann lætur mig sjá þegar óvinir mínir verða auðmýktir. ");
INSERT INTO isl_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Ekki lífláta þá, þeirri ráðningu gleymir þjóð mín fljótt. Steyptu þeim heldur af stóli. Varpa þeim til jarðar, Drottinn, þú skjöldur minn. ");
INSERT INTO isl_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Þeir eru hrokafullir. Þeir formæla og ljúga. ");
INSERT INTO isl_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Sviptu þeim burt með reiði þinni svo að þeir verði ekki framar til. Láttu þá kenna á því og sjá að þú, Drottinn, ert við völd í Ísrael og um allan heim. ");
INSERT INTO isl_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Á hverju kvöldi koma þeir aftur, ýlfra eins og hundar og ráfa um borgina, urra og leita að æti. ");
INSERT INTO isl_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","En ég? – Á hverjum morgni vil ég syngja um miskunn þína og mátt, því að á degi neyðarinnar varstu mér vígi. ");
INSERT INTO isl_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Þú styrkur minn, um þig vil ég syngja ljóðin mín. Þú háborg mín! Þú minn miskunnsami Guð! ");
INSERT INTO isl_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Þennan sálm orti Davíð ");
INSERT INTO isl_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","þegar hann átti í ófriði við Sýrlendinga og óvíst var um úrslit. Þetta gerðist á sama tíma og Jóab, hershöfðingi Ísraels, vann sigur á 12.000 Edomítum í Saltdalnum. ");
INSERT INTO isl_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Þú Guð, hefur útskúfað okkur og brotið niður varnirnar. Þú hefur reiðst okkur og tvístrað. Drottinn sýndu aftur miskunn þína. ");
INSERT INTO isl_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Þú lést landið skjálfa, sprungur opnuðust. Drottinn læknaðu það og græddu sárin. ");
INSERT INTO isl_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Þú lést lýð þinn kenna á hörðu, við reikuðum eins og drukknir menn. ");
INSERT INTO isl_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","En nú hefur þú reist okkur herfána! Þangað stefnum við allir sem elskum þig. ");
INSERT INTO isl_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Réttu út þína sterku hönd og frelsaðu okkur! Bjargaðu ástvinum þínum. ");
INSERT INTO isl_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","9","Guð hefur heitið hjálp. Hann hefur svarið það við heilagleika sinn! Er að undra þótt ég sé glaður?! „Síkem, Súkkót, Gíleað, Manasse – allt er þetta mitt,“ segir hann. „Júda gefur konung og Efraím varðmenn. ");
INSERT INTO isl_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Móab er þjónn minn og Edóm þræll. Og yfir Filisteu æpi ég siguróp!“ ");
INSERT INTO isl_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Hver fer með til Edóms, inn í víggirtar borgir hans? ");
INSERT INTO isl_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Guð! Hann sem áður útskúfaði og yfirgaf hersveitir okkar! ");
INSERT INTO isl_vpl VALUES ("PS60_13","020_60_13","PSA","60","13","13","Drottinn, styð okkur gegn óvinunum, því að ekki hjálpa menn. ");
INSERT INTO isl_vpl VALUES ("PS60_14","020_60_14","PSA","60","14","14","Með Guðs hjálp vinnum við stórvirki, hann mun fótum troða óvinina. ");
INSERT INTO isl_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","2","Ó, Guð, heyrðu hróp mitt! Hlustaðu á bæn mína. ");
INSERT INTO isl_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Því að hvar sem ég fer, jafnvel um endimörk jarðar, þá hrópa ég eftir hjálp þinni. Þegar hjarta mitt örmagnast og ég get ekki meir, þá lyftu mér á klett, hjálpræðisbjargið þitt góða, mitt örugga skjól. ");
INSERT INTO isl_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Þú ert skjól mitt, háreist borg, ókleif óvinum. ");
INSERT INTO isl_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Í helgidómi þínum mun ég búa að eilífu, öruggur í skjóli vængja þinna, ");
INSERT INTO isl_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Því að þú, ó Guð, hefur heyrt heit mín og uppfyllt óskir þeirra sem óttast þig og heiðra nafn þitt. ");
INSERT INTO isl_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Þú munt lengja lífdaga mína og láta ævi konungsins vara frá kyni til kyns. ");
INSERT INTO isl_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Ég mun lifa frammi fyrir Drottni að eilífu! Lát elsku þína og trúfesti gæta mín, þá mun ég lofa nafn þitt um aldur og ævi og efna heit mín dag eftir dag. ");
INSERT INTO isl_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","2","Ég bíð rólegur og þögull eftir hjálp Drottins. ");
INSERT INTO isl_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Hann einn er bjarg mitt og lausnari, vörn mín og vígi. Ég hef ekkert að óttast. ");
INSERT INTO isl_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","5","En hvað um þessa menn sem ásaka mig þegar veldi mitt stendur höllum fæti, vilja mig feigan og ljúga og pretta til að steypa mér af stóli. Þeir tala fagurgala, satt er það, en hata mig í hjörtum sínum! ");
INSERT INTO isl_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","En ég stend þögull frammi fyrir fyrir Drottni og vænti hjálpar hans. Hann einn getur hjálpað. ");
INSERT INTO isl_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Já, hann einn er bjarg mitt, og lausnari, vörn mín og vígi. Ég hef ekkert að óttast. ");
INSERT INTO isl_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Öryggi mitt og farsæld er í hendi Drottins. Hann einn er skjól mitt og klettur – þangað kemst óvinurinn ekki! ");
INSERT INTO isl_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Þú þjóð mín, treystu Drottni. Segið honum óskir ykkar, hann getur uppfyllt þær! ");
INSERT INTO isl_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Mennirnir miklast og hrokast í hégóma sínum. Einn þykist öðrum meiri, en hann metur alla jafnt. ");
INSERT INTO isl_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","12","Safnið ekki auði með svikum og ránum og treystið ekki illa fengnu fé. Treystið Drottni! Minnist þess aftur og aftur að Drottins er styrkurinn. ");
INSERT INTO isl_vpl VALUES ("PS62_13","020_62_13","PSA","62","13","13","Já, hjá þér Drottinn, er miskunn og þú launar sérhverjum eftir verkum hans. ");
INSERT INTO isl_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Þennan sálm orti Davíð þegar hann leitaði skjóls í Júdeueyðimörkinni. ");
INSERT INTO isl_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Ó, þú Guð minn, ég leita þín! Mig þyrstir eftir þér í þessari skrælnuðu eyðimörk. Ó, hve ég þrái þig! ");
INSERT INTO isl_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Þegar ég gekk um í helgidómi þínum þá leitaði ég þín, þráði að sjá veldi þitt og dýrð. ");
INSERT INTO isl_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Miskunn þín er betri en lífið sjálft! Með vörum mínum lofa ég þig. ");
INSERT INTO isl_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Ég vil lofa þig svo lengi sem ég lifi, lyfta höndum mínum í bæn til þín. ");
INSERT INTO isl_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Þá mun sál mín mettast og verða glöð, og munnur minn lofa þig með fögnuði. ");
INSERT INTO isl_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Ég ligg andvaka um nætur og hugsa um þig, rifja upp öll þau skipti sem þú hefur hjálpað. ");
INSERT INTO isl_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Þá fyllist ég gleði, finn mig öruggan hjá þér. ");
INSERT INTO isl_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Ég vil halda mér fast við þig, og styðjast við þína sterku hönd. ");
INSERT INTO isl_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Þeir munu sjálfir deyja sem brugga mér banaráð, og hverfa niður til heljar. ");
INSERT INTO isl_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Þeir munu falla fyrir sverði, verða sjakölum að bráð. ");
INSERT INTO isl_vpl VALUES ("PS63_12","020_63_12","PSA","63","12","12","Ég vil gleðjast í Guði! Og þeir sem honum treysta skulu fagna sigri því að munni lygaranna hefur verið lokað. ");
INSERT INTO isl_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","3","Ó, Drottinn, hlustaðu á neyðaróp mitt, því að hópur af þorpurum og bófum hafa gert samsæri gegn mér. Verndaðu mig! ");
INSERT INTO isl_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Orð þeirra eru eins og rýtingur í bakið. Þeir hvæsa á mig og nísta hjarta mitt. ");
INSERT INTO isl_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","6","Þeir senda mér kaldar kveðjur úr launsátri, vinna verk sín í skyndi, eru hvergi smeykir. Þeir sitja á svikráðum. Hittast á laun og leggja gildrur fyrir aðra. „Þetta sér enginn,“ segja þeir. ");
INSERT INTO isl_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Þeir upphugsa ill verk og segja „Nú er allt klappað og klárt!“ Hjörtu þeirra fyllast illsku og svikum. ");
INSERT INTO isl_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","En Guð mun slá þá til jarðar. Eins og hendi sé veifað hittir örin þá ");
INSERT INTO isl_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Tunga þeirra verður þeim að falli. Menn hrista höfuðið yfir þeim og ");
INSERT INTO isl_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","ótta slær á alla. Þeir játa mikilleik Guðs og hans voldugu verk, gefa gætur að því sem hann gerir. ");
INSERT INTO isl_vpl VALUES ("PS64_11","020_64_11","PSA","64","11","11","En hinir trúuðu munu fagna í Drottni, leita hjálpar hans og hrósa sigri með honum. ");
INSERT INTO isl_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","2","Ó, þú Guð á Síon, við lofum þig og vegsömum og efnum heit okkar við þig. ");
INSERT INTO isl_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Þú heyrir bænir og því leita allir menn til þín. ");
INSERT INTO isl_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Margar freistingar urðu mér að falli, ég gerði margt rangt, en þú fyrirgafst mér allar þessar syndir. ");
INSERT INTO isl_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Sá er heppinn sem þú hefur útvalið, sá sem fær að búa hjá þér í forgörðum helgidóms þíns og njóta allsnægta í musteri þínu. ");
INSERT INTO isl_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Með krafti þínum sýnir þú réttlæti þitt, þú Guð, frelsari okkar. Þú ert skjól öllum mönnum, allt að endimörkum jarðar. ");
INSERT INTO isl_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Þú reistir fjöllin í mætti þínum, ");
INSERT INTO isl_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","þú stöðvar brimgný hafsins og háreysti þjóðanna. ");
INSERT INTO isl_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Þeir sem búa við ysta haf óttast tákn þín og austrið og vestrið kætast yfir þér! ");
INSERT INTO isl_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Þú vökvar jörðina og eykur frjósemi hennar. Ár þínar og uppsprettur munu ekki þorna. Þú gerir jörðina hæfa til sáningar og gefur þjóð þinni ríkulega uppskeru. ");
INSERT INTO isl_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Með steypiregni vökvar þú plógförin og mýkir jarðveginn – útsæðið spírar og vex! ");
INSERT INTO isl_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","13","Landið klæðist grænni kápu. Heiðarnar blómstra og hlíðarnar brosa, allt er loðið af gróðri! ");
INSERT INTO isl_vpl VALUES ("PS65_14","020_65_14","PSA","65","14","14","Hjarðirnar liðast um hagana og dalirnir fyllast af korni. Allt fagnar og syngur! ");
INSERT INTO isl_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Allur heimurinn gleðjist með Guði! ");
INSERT INTO isl_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Lofið nafn hans, það er undursamlegt! Segið öllum frá máttarverkum hans! ");
INSERT INTO isl_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Guð, hversu undursamleg eru verk þín! Máttur þinn er stórkostlegur! Ekki er að furða þótt óvinir þínir smjaðri fyrir þér. ");
INSERT INTO isl_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Lofaður sért þú um víða veröld! ");
INSERT INTO isl_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Komið og sjáið máttarverk Guðs! Mikil eru þau undur sem fólk hans fær að sjá og reyna. ");
INSERT INTO isl_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Hann opnaði þeim veg í gegnum hafið! Þar gengu þeir yfir þurrum fótum. Hvílík gleði og fögnuður ríkti þann dag! ");
INSERT INTO isl_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Drottinn mun ríkja að eilífu vegna máttar síns. Hann virðir vandlega fyrir sér mennina. Engir uppreisnarmenn þora að láta á sér bæra. ");
INSERT INTO isl_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Sérhver maður lofi Drottin og vegsami nafn hans. ");
INSERT INTO isl_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Hann gaf okkur lífið og hann verndar frá hrösun. ");
INSERT INTO isl_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Þú, ó Guð, hreinsaðir okkur í eldi eins og silfur er hreinsað. ");
INSERT INTO isl_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Þú hefur fjötrað okkur og lokað inni og lagt á okkur byrðar. ");
INSERT INTO isl_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Þú lést hersveitir troða okkur fótum og við urðum að fara gegnum eld og vatn, en að lokum leiddir þú okkur út og inn í yndislegt land. ");
INSERT INTO isl_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Nú kem ég í helgidóm þinn, fórna og efni þannig heit mitt. ");
INSERT INTO isl_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","Manstu, þegar ég var í nauðum staddur, þá gaf ég þér heit? ");
INSERT INTO isl_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Nú ber ég fram fórn mína: Hrúta, naut og kiðling. Megi reykurinn af fórnum þessum stíga upp til þín. ");
INSERT INTO isl_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Komið og hlustið, þið sem óttist Drottin, og ég skal segja ykkur hvað hann hefur gert fyrir mig!: ");
INSERT INTO isl_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Ég hrópaði til hans um hjálp, – og víst bjó lofgjörðin undir! ");
INSERT INTO isl_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","En fyrst játaði ég synd mína, annars hefði ég ekki fengið svar. ");
INSERT INTO isl_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","En hann heyrði bæn mína og hlustaði, gaf gaum að því sem ég sagði. ");
INSERT INTO isl_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Lof sé Guði! Hann vísaði ekki bæn minni á bug né tók miskunn sína frá mér. ");
INSERT INTO isl_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","2","Ó, veittu okkur miskunn þína og náð! Leyfðu okkur að sjá þig og kærleika þinn. ");
INSERT INTO isl_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Leyfðu öllum mönnum að fá að kynnast þér og þekkja hjálpræði þitt. ");
INSERT INTO isl_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Allar þjóðir skulu lofa Drottin. ");
INSERT INTO isl_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Þær skulu fagna og gleðjast, því að þú færir þeim réttlæti, og leiðir þær um réttan veg. ");
INSERT INTO isl_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Allur heimurinn lofi þig, ó Guð! Já, allar þjóðir í heiminum flytji þér þakkargjörð! ");
INSERT INTO isl_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","8","Því að uppskera jarðarinnar varð mikil og Guð, hefur blessað okkur ríkulega. Og hann blessi okkur áfram svo að allar þjóðir megi óttast hann og elska. ");
INSERT INTO isl_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","2","Þegar Guð rís á fætur þá tvístrast óvinir hans! Þeir sem hata hann flýja sem mest þeir mega. ");
INSERT INTO isl_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Blástu þeim burt eins og reyk í vindi! Bræddu þá eins og vax í eldi! Þannig munu óguðlegir tortímast fyrir Guði. ");
INSERT INTO isl_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","En hinir trúuðu skulu fagna. Þeir kætist og gleðjist ");
INSERT INTO isl_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","og lofsyngi Guði! Hefjið lofsöng til hans sem ekur um á skýjunum. Nafn hans er Drottinn! Gleðjist og fagnið í nærveru hans. ");
INSERT INTO isl_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Hann er faðir föðurlausra og verndari ekkna, hann er heilagur. ");
INSERT INTO isl_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","Hann lætur hinn einmana komast heim aftur og leiðir fanga út í frelsið á ný. Þar verður sungið og fagnað! En uppreisnarmenn skulu búa við sult og seyru. ");
INSERT INTO isl_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","Guð, þegar þú leiddir þjóð þína gegnum öræfin, ");
INSERT INTO isl_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","þá skalf jörðin og himnarnir nötruðu. Sínaífjall hneigði sig fyrir þér af virðingu og ótta – þér Guði Ísraels. ");
INSERT INTO isl_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","11","Þú, Guð, sendir regnskúrir yfir land þitt, hresstir það og endurnærðir. Þar settist þjóð þín að. Þú gafst hinum hrjáðu heimili og skjól. ");
INSERT INTO isl_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","13","Drottinn lætur orð sín rætast og þegar hann talar flýja óvinirnir. Konurnar sem heima eru flytja gleðifrétt: „Óvinaherinn er flúinn, þeir sem vildu eyða öllu og umturna!“ Og konur í Ísrael skipta herfanginu. ");
INSERT INTO isl_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Þær hylja sig með gulli og silfri, rétt eins og dúfan vængjum sínum! ");
INSERT INTO isl_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Þegar Guð stökkti óvinunum á flótta þá snjóaði á Salmonsfjalli. ");
INSERT INTO isl_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","17","Þið voldugu Basanfjöll, þið illkleifu tindar! Hvers vegna horfið þið með öfund til Síonar – fjallsins sem Drottinn hefur kosið sér til bústaðar? ");
INSERT INTO isl_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Með þúsundum vagna lagði Drottinn upp frá Sínaí og kom til síns heilaga musteris á Síon. ");
INSERT INTO isl_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Hann kleif fjöllin, tók með sér fjölda bandingja og veitti viðtöku gjöfum frá mönnum, jafnvel uppreisnarmönnum. Og nú býr hann hér! ");
INSERT INTO isl_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Lofaður sé Drottinn! Hann leiðir okkur dag eftir dag og hjálpar í öllum vanda. ");
INSERT INTO isl_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Guð er hjálpræðisguð. Hann er alvaldur og bjargar frá dauða. ");
INSERT INTO isl_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","En óvinum sínum eyðir hann, þeim sem þrjóskast og halda áfram á glæpabraut. ");
INSERT INTO isl_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","Hann segir: „Komið!“ við óvini þjóðar sinnar, þá sem fela sig til fjalla eða í hafdjúpunum. ");
INSERT INTO isl_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","Þjóð hans vill troða þá undir, ganga í blóði þeirra og gefa hundum hræ þeirra. ");
INSERT INTO isl_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Guð, konungur minn, gengur inn til musteris síns. ");
INSERT INTO isl_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Fremst fara söngvarar, þá hljóðfæraleikarar og stúlkur sem slá taktinn. ");
INSERT INTO isl_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Allur Ísrael gleðjist með Guði, uppsprettu Ísraels á þessum hátíðardegi. ");
INSERT INTO isl_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Fremst fer Benjamínsætt, hún er minnst. Þá koma prinsar og öldungar Júda og síðan höfðingjar Sebúlons og Naftalí. ");
INSERT INTO isl_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Sýn þú, Guð, mátt þinn og styrk, því að mikla hluti hefur þú gert. ");
INSERT INTO isl_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Konungar jarðarinnar gefa gjafir til musteris þíns í Jerúsalem. ");
INSERT INTO isl_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Ávíta þú óvini okkar, Drottinn. Færðu þá hingað, sneypta og berandi skattinn! Tvístraðu þeim sem efna til ófriðar. ");
INSERT INTO isl_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Egyptar sendi gull og Bláland fórni höndum í lotningu til Guðs. ");
INSERT INTO isl_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","Syngið frammi fyrir Drottni, þið konungsríki jarðarinnar, syngið honum lofgjörðarsöng, ");
INSERT INTO isl_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","honum, Guði eilífðar, sem ekur um himininn og talar með þrumuraust svo að undir tekur. ");
INSERT INTO isl_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Drottinn hefur máttinn! Dýrð hans ljómar yfir Ísrael og hans voldugu verk birtast á himninum. ");
INSERT INTO isl_vpl VALUES ("PS68_36","020_68_36","PSA","68","36","36","Við krjúpum fyrir honum í lotningu og ótta í musteri hans. Ísraels Guð veitir þjóð sinni mátt og megin. Lofaður sé Guð! ");
INSERT INTO isl_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","2","Frelsaðu mig, ó Guð, því að vatnið hækkar sífellt ");
INSERT INTO isl_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","og ég sekk æ dýpra í þessa botnlausu leðju. ");
INSERT INTO isl_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Ég er útgrátinn og örmagna, hálsinn þurr og sár og augun þrútin. Góði Guð, bjargaðu mér! ");
INSERT INTO isl_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Þeir eru margir sem hata mig að ástæðulausu, fjöldi manna sem brugga mér banaráð. Þó er ég saklaus. Þeir heimta að ég bæti það sem ég hef ekki brotið! ");
INSERT INTO isl_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","Ó, Guð, þú þekkir heimsku mína og syndir. ");
INSERT INTO isl_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Drottinn Guð, þú sem ræður hersveitum himnanna, láttu mig ekki verða til hneykslunar þeim sem treysta þér. Þú Guð Ísraels, forðaðu mér frá því að valda þeim vonbrigðum, ");
INSERT INTO isl_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","þó svo að þín vegna sé ég hæddur og smáður. ");
INSERT INTO isl_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Jafnvel bræður mínir sniðganga mig! ");
INSERT INTO isl_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Guð, þú ert í huga mér öllum stundum og um musteri þitt hugsa ég. Og vegna þess að ég held uppi málstað þínum, hata þeir mig, rétt eins og þig. ");
INSERT INTO isl_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Ég hef fastað og iðrast frammi fyrir þér, en þeir hæddu mig engu að síður. ");
INSERT INTO isl_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Ég klæddist hærusekk – tákni auðmýktar og iðrunar – og þá ortu þeir um mig níðvísu! ");
INSERT INTO isl_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Ég er nýjasta fréttin í bænum og jafnvel rónarnir spotta mig! ");
INSERT INTO isl_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","En ég held áfram að biðja til þín, Drottinn, og gefst ekki upp, því að þú hlustar! Svaraðu mér með blessun þinni og miskunnaðu mér. ");
INSERT INTO isl_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Dragðu mig upp úr leðjunni, Drottinn, ég finn að ég er að sökkva! Forðaðu mér frá óvinum mínum, úr þessum hræðilega pytti! ");
INSERT INTO isl_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","Láttu ekki flóðið taka mig, hringiðuna svelgja mig! ");
INSERT INTO isl_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Ó, Drottinn, svaraðu bænum mínum, vegna gæsku þinnar og náðar við mig. ");
INSERT INTO isl_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Snúðu ekki við mér bakinu, því að ég er í nauðum staddur! Flýttu þér! Komdu og frelsaðu mig! ");
INSERT INTO isl_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Drottinn, komdu og bjargaðu mér! Leystu mig undan ofríki óvina minna. ");
INSERT INTO isl_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Þú sérð þá og þekkir háðsglósur þeirra, hvernig þeir níða mig niður. ");
INSERT INTO isl_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Háðsyrði þeirra hafa sært mig djúpu sári og andi minn örmagnast. Ó, ef einhver hefði sýnt mér samúð og einhver viljað hugga mig! ");
INSERT INTO isl_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Þeir færðu mér eitraðan mat – malurt – og edik við þorstanum. ");
INSERT INTO isl_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Verði gleði þeirra að sorg og friður þeirra að skelfingu. ");
INSERT INTO isl_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Myrkur komi yfir þá, blinda og ringulreið. ");
INSERT INTO isl_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Reiði þín upptendrist gegn þeim og eldur þinn tortími þeim. ");
INSERT INTO isl_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Leggðu hús þeirra í rúst svo að þar búi enginn framar. ");
INSERT INTO isl_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Því að þeir ofsækja þann sem þú hefur slegið og hlæja að kvöl þess sem þú hefur gegnumstungið. ");
INSERT INTO isl_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Skráðu hjá þér allar syndir þeirra, já láttu enga gleymast. ");
INSERT INTO isl_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Strikaðu þá út af listanum yfir þá sem fá að lifa, leyfðu þeim ekki að njóta lífsins með réttlátum. ");
INSERT INTO isl_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Ó, Guð, frelsaðu mig úr þessari neyð! Ég veit að þú munt bjarga mér! ");
INSERT INTO isl_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Ég lofa Guð í ljóði, mikla hann með lofsöng. ");
INSERT INTO isl_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Það mun gleðja hann meira en margs konar fórnir. ");
INSERT INTO isl_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Hinir auðmjúku munu sjá að Drottinn hjálpar mér og þeir munu gleðjast. Já, gleðjist, þið sem leitið Guðs! ");
INSERT INTO isl_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Því að Drottinn heyrir hróp hinna snauðu, og snýr ekki við þeim bakinu. ");
INSERT INTO isl_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Himinn og jörð, lofið Drottin, og hafið og allt sem í því er! ");
INSERT INTO isl_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","Því að Guð mun frelsa Jerúsalem og endurreisa borgirnar í Júda og þjóð hans mun búa við öryggi. ");
INSERT INTO isl_vpl VALUES ("PS69_37","020_69_37","PSA","69","37","37","Börnin munu erfa landið og þeir sem elska Drottin njóta þar friðar og velgengni. ");
INSERT INTO isl_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","2","Bjargaðu mér, ó Guð! Flýttu þér Drottinn, að hjálpa mér! ");
INSERT INTO isl_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","4","Óvinir mínir sækjast eftir lífi mínu og njóta þess að kvelja mig. Rektu þá burt með skömm! Stöðvaðu þá! Láttu þá ekki hæða mig og spotta. ");
INSERT INTO isl_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Allir þeir sem leita Guðs skulu fagna og gleðjast. Þeir sem elska hjálpræði þitt hrópi: „Lofaður sé Guð!“ ");
INSERT INTO isl_vpl VALUES ("PS70_6","020_70_6","PSA","70","6","6","En ég er í miklum vanda ó, Guð! Flýttu þér að hjálpa mér! Þú ert sá eini sem getur bjargað. Drottinn minn, láttu það ekki dragast! ");
INSERT INTO isl_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","Drottinn, þú ert skjól mitt! Ekki yfirgefa mig! ");
INSERT INTO isl_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Frelsaðu mig frá óvinum mínum, því að þú er réttlátur. Bjargaðu mér! Snúðu eyra þínu að mér og hlustaðu á mína einlægu bæn. ");
INSERT INTO isl_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Vertu mér vígi og skjól gegn öllum árásum. ");
INSERT INTO isl_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","Já, bjargaðu mér ó Guð, frá svikum þessara illmenna. ");
INSERT INTO isl_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Drottinn, þú ert mín síðasta von. Allt frá barnsaldri treysti ég á þig. ");
INSERT INTO isl_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Frá fæðingu hefur þú vakað yfir mér og verndað mig – skyldi ég ekki vegsama þig?! ");
INSERT INTO isl_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Velgengni mína, sem margir undrast, á ég vernd þinni að þakka. ");
INSERT INTO isl_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Ég vil lofa þig liðlangan daginn, ó Guð, því að alls góðs hef ég notið úr hendi þinni. ");
INSERT INTO isl_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Nú þegar aldurinn færist yfir, þá vísa mér ekki frá. Hafnaðu mér ekki þegar þrekið minnkar. ");
INSERT INTO isl_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","11","Óvinir mínir hvísla: „Guð hefur yfirgefið hann! Nú er hann auðveld bráð. Hann hefur engan sér til hjálpar!“ ");
INSERT INTO isl_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","Guð minn, farðu ekki frá mér! Komdu fljótt og hjálpaðu mér! ");
INSERT INTO isl_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Útrýmdu þeim. Láttu þá verða til skammar sem óska mér óhamingju. ");
INSERT INTO isl_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","En ég mun áfram treysta þér og ekki draga úr lofgjörð minni! ");
INSERT INTO isl_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Oftsinnis frelsaðir þú mig úr bráðri hættu. Ég vitna og rifja upp gæsku þína og daglega umhyggju. ");
INSERT INTO isl_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Drottinn, styrkur þinn heldur mér uppi. Það skulu allir vita að þú einn ert góður og réttlátur. ");
INSERT INTO isl_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Guð minn, allt frá æsku hjálpaðir þú mér – um dásemdarverk þín hef ég ekki þagað. ");
INSERT INTO isl_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Nú er ég orðinn gamall og hárin grá, en Drottinn yfirgefðu mig ekki! Láttu mig lifa enn um stund, svo að unga kynslóðin fái að heyra um máttarverk þín. ");
INSERT INTO isl_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Kraftur þinn og kærleikur, Drottinn, nær til himna. Ó, hve það er dásamlegt! Hvar er slíkan Guð að finna sem þig?! ");
INSERT INTO isl_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Þú hefur sent okkur margvíslegt mótlæti – en ég veit að þú munt frelsa á ný og leyfa okkur að lifa! ");
INSERT INTO isl_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Þú munt auka við heiður minn og hugga mig að nýju. ");
INSERT INTO isl_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Ég leik á hörpu mína og lofa þig, því að öll þín orð og fyrirheit hafa staðist, þú hinn heilagi í Ísrael. ");
INSERT INTO isl_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Ég vil lofa þig hárri röddu, því að þú hefur frelsað mig! ");
INSERT INTO isl_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Liðlangan daginn vitna ég um ást þína og réttlæti, því að óvinir mínir sem óskuðu mér ógæfu, voru auðmýktir og roðnuðu af skömm. ");
INSERT INTO isl_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","Guð, hjálpa þú konunginum, að hann fái skorið úr málum manna eftir vilja þínum og hjálpaðu syni hans til að gera rétt. ");
INSERT INTO isl_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","3","Gefðu að hann dæmi þjóð þína með sanngirni og láti hina snauðu ná rétti sínum. Stjórnspeki hans leiði af sér velferð og grósku. ");
INSERT INTO isl_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Styrktu hann að vernda fátæklinga og þurfandi og eyða kúgurum þeirra. ");
INSERT INTO isl_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Þá mun hann lifa meðan sólin skín og tunglið gefur birtu. Já, að eilífu! ");
INSERT INTO isl_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Stjórn hans verður mild og góð eins og gróðrarskúr á sprettutíma. ");
INSERT INTO isl_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Á ríkisárum hans mun réttlætið blómgast og friður eflast, já, meðan veröldin er til. ");
INSERT INTO isl_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Ríki hans mun ná frá hafi til hafs, frá Evfrat-fljóti til endimarka jarðar. ");
INSERT INTO isl_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Óvinir hans munu lúta honum og leggjast flatir á jörðina við fætur hans. ");
INSERT INTO isl_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Konungarnir frá Tarsus og eylöndunum munu færa honum gjafir, og skatt þeir frá Saba og Seba. ");
INSERT INTO isl_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Allir konungar munu lúta honum og þjóðir þeirra þjóna honum. ");
INSERT INTO isl_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Hann mun bjarga hinum snauða er hrópar á hjálp, og hinum þjáða sem enginn réttir hjáparhönd. ");
INSERT INTO isl_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Hann aumkast yfir bágstadda og þá sem ekkert eiga og liðsinnir fátæklingum. ");
INSERT INTO isl_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Hann verndar þá og leysir frá ofríki og kúgun því að líf þeirra er dýrmætt í augum hans. ");
INSERT INTO isl_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Lífið blasir við honum og menn munu gefa honum gull frá Saba. Hann mun njóta fyrirbæna margra og fólk mun blessa hann liðlangan daginn. ");
INSERT INTO isl_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Landið mun gefa góða uppskeru, einnig til fjalla eins og í Líbanon. Fólki mun fjölga í borgunum eins og gras vex á engi! ");
INSERT INTO isl_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Nafn hans mun lofað að eilífu og meðan sólin skín mun orðstír hans aukast. Allir munu óska sér blessunar hans og þjóðirnar segja hann sælan. ");
INSERT INTO isl_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Lofaður sé Drottinn, Guð Ísraels, hann einn gerir furðuverk. ");
INSERT INTO isl_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Lofað sé hans dýrlega nafn að eilífu! Öll jörðin fyllist dýrð hans! Amen, já amen! ");
INSERT INTO isl_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","(Hér enda sálmar Davíðs Ísaísonar.) ");
INSERT INTO isl_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Guð er góður við Ísrael! Hann er góður þeim sem hreinlyndir eru. ");
INSERT INTO isl_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","En hvað um mig? Ég var kominn á ystu nöf. Það munaði engu að mér skrikaði fótur og ég félli! ");
INSERT INTO isl_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","Ég hafði fyllst gremju út af velgengni hinna hrokafullu. ");
INSERT INTO isl_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Þeim virtist ganga allt í haginn. Þeir eru hraustir og sterkir. ");
INSERT INTO isl_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Þeir virðast lausir við alla erfiðleika og áföll sem henda aðra. ");
INSERT INTO isl_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Hrokinn er eins og glitrandi festi um háls þeirra og þeir eru sveipaðir ofríki eins og skikkju. ");
INSERT INTO isl_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Þeir belgjast út af offitu og augu þeirra tútna af ágirnd. ");
INSERT INTO isl_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Þeir hæðast að Guði og hafa í hótunum við fólk hans. Hroki er í hverju orði. ");
INSERT INTO isl_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Þeir stæra sig gegn himninum og blaðrið í þeim heyrist um allar jarðir. ");
INSERT INTO isl_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Þjóð Guðs er orðlaus og gleypir í sig boðskap þeirra. ");
INSERT INTO isl_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","12","„Guð virðist láta þá í friði,“ segir fólk, „já, þessir guðleysingjar lifa áhyggjulausu lífi og verða ríkari með hverjum degi.“ ");
INSERT INTO isl_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Hef ég eytt tíma mínum til einskis? Er til nokkurs að kappkosta að lifa heiðvirðu lífi? ");
INSERT INTO isl_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Allt sem ég hef upp úr því er erfiði og strit – alla daga, sí og æ! ");
INSERT INTO isl_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Ef ég talaði með þessum hætti, væri ég að bregðast lýð þínum. ");
INSERT INTO isl_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","En þetta er samt svo torskilið – velgengni þeirra sem hata Drottin. ");
INSERT INTO isl_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","En dag einn fór ég í helgidóm Drottins til að íhuga, og þá hugleiddi ég framtíð þessara vondu manna. ");
INSERT INTO isl_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Sá vegur sem þeir ganga mun enda í skelfingu. Skyndilega mun þeim skrika fótur og þeir hrasa og steypast fram af brúninni, niður í hyldýpið. ");
INSERT INTO isl_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Það verður snöggur endir á allri „gæfunni“, skyndileg tortíming. ");
INSERT INTO isl_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Líf þeirra líkist draumi. Þeir munu vakna til veruleikans, eins og þegar menn vakna af draumsvefni og sjá að allt var ímyndun ein! ");
INSERT INTO isl_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Þegar ég skyldi þetta, fylltist ég hryggð og leið illa. ");
INSERT INTO isl_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","Ég sá hve heimskur og fávís ég var. Ég hlýt að vera eins og skynlaus skepna í þínum augum, Guð! ");
INSERT INTO isl_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","En samt elskar þú mig! Þú heldur í hægri hönd mína og varðveitir mig. ");
INSERT INTO isl_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Og áfram munt þú leiða mig með vísdómi þínum og speki. ");
INSERT INTO isl_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Hvern á ég að á himnum nema þig? Og þú ert sá sem ég þrái mest á jörðu! ");
INSERT INTO isl_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Heilsu minni hrakar og hjarta mitt þreytist, en Guð lifir! Hann er styrkur minn, ég fæ að tilheyra honum að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Drottinn, þeir sem hafna þér munu farast, því að þú eyðir þeim sem þjóna öðrum guðum. ");
INSERT INTO isl_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","En hvað um mig? Ég vil komast eins nálægt Guði og ég get! Ég hef kosið að trúa á Drottin. Hann er skjól mitt. Ég vil vitna um það í allra áheyrn að margsinnis hefur hann bjargað mér á undursamlega hátt. ");
INSERT INTO isl_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","Guð, hvers vegna hefur þú hafnað okkur fyrir fullt og allt? Af hverju ertu reiður? Við erum þó þín eigin hjörð? ");
INSERT INTO isl_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Mundu, að við erum þjóðin þín – fólkið sem þú forðum leystir úr útlegð og valdir þér til eignar og gleði. Þú útvaldir Jerúsalem sem bústað þinn á jörðu. ");
INSERT INTO isl_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Fáðu þér göngu og skoðaðu rústirnar! Sjáðu, óvinirnir hafa eyðilagt borgina og musteri þitt. ");
INSERT INTO isl_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Þar, já, inni í helgidómnum, æptu þeir heróp, reistu stríðsfána sína og guðamyndir og fögnuðu sigri! ");
INSERT INTO isl_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","6","Allt er eins og rjúkandi rúst, eins og brunninn skógur. Með öxum sínum og sleggjum hjuggu þeir og brutu allan útskurðinn. ");
INSERT INTO isl_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Þeir kveiktu í musterinu og gjöreyddu helgidóm þinn, Drottinn. ");
INSERT INTO isl_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","„Þurrkum út allt sem minnir á Drottin!“ öskruðu þeir og brenndu síðan öll samkomuhús Guðs í landinu. ");
INSERT INTO isl_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","10","Ekkert er nú eftir sem sýnir að við séum þín útvalda þjóð. Spámennirnir eru horfnir og hver getur þá sagt okkur hvenær þessi ósköp munu enda? Hve lengi ætlar þú Guð að leyfa óvinum þínum að óvirða nafn þitt? Ætlar þú að láta þá komast upp með þetta að eilífu? ");
INSERT INTO isl_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Eftir hverju ertu að bíða? Af hverju gerir þú ekkert? Ó, rektu þá burt með þinni sterku hendi! ");
INSERT INTO isl_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Guð, þú ert konungur minn frá alda öðli. Hjálpar þinnar hef ég notið á öllum mínum ferðum. ");
INSERT INTO isl_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","14","Þú klaufst hafið með mætti þínum, molaðir haus sjávarguðsins! ");
INSERT INTO isl_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Eftir skipun þinni opnuðust lindir og þar gat þjóð þín svalað þorstanum. Og þú þurrkaðir fyrir þau farveg Jórdanar, sem annars streymir endalaust. ");
INSERT INTO isl_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Þú stjórnar bæði nóttu og degi og sólina og stjörnurnar hefur þú skapað. ");
INSERT INTO isl_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Öll náttúran er á valdi þínu og vetur og sumar eru þín verk. ");
INSERT INTO isl_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Drottinn líttu á, óvinir þínir spotta þig, ofstopalýður óvirðir nafn þitt! ");
INSERT INTO isl_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Ó, Drottinn, frelsaðu mig! Verndaðu turtildúfuna þína fyrir ránfuglunum. Bjargaðu eignarlýð þínum úr klóm varganna. ");
INSERT INTO isl_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Minnstu loforða þinna! Landið er hulið myrkri og ofbeldismenn út um allt. ");
INSERT INTO isl_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Drottinn, þjóð þín er kúguð, en láttu hana ekki þurfa að þola þessa svívirðing endalaust. Leyfðu hinum fátæku og hrjáðu að lofa nafn þitt! ");
INSERT INTO isl_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","Komdu, ó Guð, og ákærðu óvini okkar. Hlustaðu á óþverrann sem þessi illmenni ausa yfir þig alla daga! ");
INSERT INTO isl_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Gleymdu ekki formælingum óvina þinna, þær glymja hærra og hærra. ");
INSERT INTO isl_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","2","Þökk sé þér Drottinn! Máttarverk þín staðfesta umhyggju þína. ");
INSERT INTO isl_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","„Já,“ svarar Drottinn, „og þegar stundin er komin mun ég refsa öllum illgjörðamönnum! ");
INSERT INTO isl_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Þótt jörðin nötri og íbúar hennar skjálfi af ótta, eru undirstöður hennar traustar, enda verk handa minna!“ ");
INSERT INTO isl_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Ég sagði hinum hrokafullu að láta af drambi sínu og illmennunum að hætta sínum ögrandi augnagotum, ");
INSERT INTO isl_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","að láta af þrjósku og hroka. ");
INSERT INTO isl_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","Velgengni og völd getur enginn þakkað sér sjálfum, ");
INSERT INTO isl_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","allt eru það gjafir frá Guði. Hann upphefur einn, en niðurlægir annan. ");
INSERT INTO isl_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Drottinn heldur á bikar fullum af freyðandi víni – það er dómurinn gegn illmennum heimsins. Þau skulu drekka hann í botn! ");
INSERT INTO isl_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","En ég mun vegsama Guð um aldur og ævi. ");
INSERT INTO isl_vpl VALUES ("PS75_11","020_75_11","PSA","75","11","11","Styrkur hinna óguðlegu verður að engu, en réttlátir skulu ríkja með reisn. ");
INSERT INTO isl_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","2","Orðstír Drottins er mikill í Júda og Ísrael. ");
INSERT INTO isl_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Bústaður hans er í Jerúsalem. Hann situr á Síonfjalli. ");
INSERT INTO isl_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","Þar sundurbraut hann vopn óvina okkar. ");
INSERT INTO isl_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Öll háreist fjöll blikna í ljóma dýrðar hans! ");
INSERT INTO isl_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","Úrvalslið óvinanna er gjörsigrað! Þeir liggja flatir, sofnaðir svefninum langa. Enginn þeirra getur framar lyft hendi. ");
INSERT INTO isl_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Þegar þú, Guð Jakobs, hastaðir á þá, féllu bæði hestar og riddarar. ");
INSERT INTO isl_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","8","Ekki er að undra þótt menn óttist þig! Hver fær staðist reiði Guðs?! ");
INSERT INTO isl_vpl VALUES ("PS76_9","020_76_9","PSA","76","9","9","Þegar þú birtir þeim dóminn frá himnum, þá nötraði jörðin og þagnaði fyrir þér. ");
INSERT INTO isl_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Þú stígur fram til að refsa illgjörðamönnunum, en verndar hina auðmjúku. ");
INSERT INTO isl_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Þegar við sjáum heimsku og reiði mannanna, þá skiljum við enn betur hve dýrð þín er mikil. ");
INSERT INTO isl_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Efnið heitin sem þið gáfuð Drottni, Guði ykkar. Allir sem umhverfis hann eru færa honum gjafir. Þeir nálgast hann með óttablandinni virðingu. ");
INSERT INTO isl_vpl VALUES ("PS76_13","020_76_13","PSA","76","13","13","Hann er sá sem lægir ofstopa höfðingjanna og kemur konungum jarðarinnar á kné! ");
INSERT INTO isl_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","Ég ákalla Drottin. Ég hrópa og kalla til hans. Ó, að hann vildi hlusta! ");
INSERT INTO isl_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Ég er í miklum vanda og þarfnast mjög hjálpar hans. Alla nóttina er ég á bæn, ég lyfti höndum til himins, – ég bið og bið. Ég mun ekki eiga glaðan dag fyrr en Drottinn hefur hjálpað mér. ");
INSERT INTO isl_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","Ég hugsa um Guð, mikið þrái ég hjálp hans! ");
INSERT INTO isl_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Drottinn, mér mun ekki koma dúr á auga fyrr en þú hefur hjálpað mér. Ég er við það að gefast upp, jafnvel bænin er mér erfið. ");
INSERT INTO isl_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Góðar minningar liðinna ára leita sífellt á huga minn. ");
INSERT INTO isl_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Þá sungum við gleðiljóð langt fram á kvöld! Ég velti þessu fyrir mér, íhuga hve allt hefur breyst. ");
INSERT INTO isl_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","Hefur Drottinn hafnað mér fyrir fullt og allt? Mun hann ekki miskunna mér framar? ");
INSERT INTO isl_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","Elskar hann mig ekki lengur og er umhyggja hans búin fyrir fullt og allt? Gekk hann á bak orða sinna? ");
INSERT INTO isl_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","Gleymdi hann miskunn sinni við mig, vesalinginn? Hefur hann í reiðikasti lokað dyrum kærleika síns? ");
INSERT INTO isl_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","„Þetta eru örlög mín,“ sagði ég, „blessun Guðs hefur snúist í bölvun.“ ");
INSERT INTO isl_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Ég renni huganum yfir alla þá blessun sem ég hef notið frá Guði. ");
INSERT INTO isl_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Sú gæfa gleymist seint! – Já, hún líður mér aldrei úr minni! ");
INSERT INTO isl_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","Guð minn, þínir vegir eru heilagir. Hvar skyldi aðra eins að finna? ");
INSERT INTO isl_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Þú ert Guð undra og tákna. Stórvirki þín blasa við augum. ");
INSERT INTO isl_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Með þinni voldugu hendi bjargaðir þú sonum Jakobs og Jósefs. ");
INSERT INTO isl_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Þegar Rauðahafið sá þig, ókyrrðist það! Jafnvel djúpið skalf af ótta! ");
INSERT INTO isl_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Það varð skýfall og þrumur bergmáluðu um himininn. Elding leiftraði. ");
INSERT INTO isl_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Þrumurnar tjáðu reiði þína og eldingarnar lýstu upp jörðina! ");
INSERT INTO isl_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Þú lagðir veg gegnum hafið – veg sem enginn þekkti áður! ");
INSERT INTO isl_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Þú leiddir fólk þitt þessa leið eins og fjárhóp, undir leiðsögn Móse og Arons. ");
INSERT INTO isl_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Þjóð mín, hlustaðu á kenningu mína. Gefðu gaum að því sem ég hef að segja. ");
INSERT INTO isl_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","3","Nú ætla ég að rifja upp fyrir þér liðna atburði, frásagnir sem varðveist hafa frá kynslóð til kynslóðar. ");
INSERT INTO isl_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Ég birti ykkur sannleikann, svo að þið getið sagt börnum ykkar frá dásemdarverkum Drottins, öllum þeim undrum sem hann vann. ");
INSERT INTO isl_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Lögmál sitt gaf hann Ísrael og bauð forfeðrunum að kenna það börnum sínum ");
INSERT INTO isl_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","sem síðan skyldu kenna það sínum afkomendum. Þannig skyldi lögmál hans berast frá einni kynslóðinni til annarrar. ");
INSERT INTO isl_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","Því hefur sérhver kynslóð getað haldið lög Guðs, treyst honum og heyrt um hans dásemdarverk. ");
INSERT INTO isl_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","Ný kynslóð skyldi ekki þurfa að fara að fordæmi feðra sinna sem voru þrjóskir, óhlýðnir og ótrúir og forhertu sig gegn Guði. ");
INSERT INTO isl_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Þótt íbúar Efraím væru alvopnaðir, þá flúðu þeir þegar að orustunni kom. ");
INSERT INTO isl_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Þannig rufu þeir sáttmálann við Guð og fóru sína eigin leið. ");
INSERT INTO isl_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","12","Þeir gleymdu máttarverkum Drottins, sem hann hafði fyrir þá gert og forfeður þeirra í Egyptalandi, ");
INSERT INTO isl_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","þegar hann klauf hafið og leiddi þá yfir þurrum fótum. Vatnið stóð eins og veggur til beggja handa! ");
INSERT INTO isl_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Að degi til leiddi hann þá með skýi, en eldstólpa um nætur. ");
INSERT INTO isl_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Hann rauf gat á klettinn í eyðimörkinni. Vatnið streymdi fram og þeir svöluðu þorsta sínum. ");
INSERT INTO isl_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Já, það flæddi frá klettinum, líkast rennandi á! ");
INSERT INTO isl_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Samt héldu þeir fast við þrjósku sína og syndguðu gegn hinum hæsta Guði. ");
INSERT INTO isl_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Þeir kvörtuðu og kveinuðu og heimtuðu annað að borða en það sem Guð gaf þeim. ");
INSERT INTO isl_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","20","Þeir ásökuðu jafnvel sjálfan Guð og sögðu: „Hann gaf okkur vatn, en hvers vegna fáum við ekki brauð eða kjöt?!“ ");
INSERT INTO isl_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Drottinn hlustaði og honum rann í skap, reiði hans upptendraðist gegn Ísrael. ");
INSERT INTO isl_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","Enda treystu þeir honum ekki, né trúðu forsjá hans. ");
INSERT INTO isl_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Jafnvel þótt hann lyki upp himninum – eins og glugga! – ");
INSERT INTO isl_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","og léti manna rigna niður. ");
INSERT INTO isl_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Já, þeir átu englabrauð! – og urðu mettir. ");
INSERT INTO isl_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Þá lét hann austanvind blása og stýrði vestanvindinum með krafti sínum. ");
INSERT INTO isl_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","Og viti menn, fuglum rigndi af himni, – þeir voru eins og sandur á sjávarströnd! ");
INSERT INTO isl_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","Af hans völdum féllu þeir til jarðar um allar tjaldbúðirnar. ");
INSERT INTO isl_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Og fólkið át nægju sína. Hann mettaði hungur þeirra. ");
INSERT INTO isl_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","En varla höfðu þeir lokið matnum – fæðan var enn í munni þeirra, ");
INSERT INTO isl_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","þá reiddist Drottinn þeim og lagði að velli æskumenn Ísraels. ");
INSERT INTO isl_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","En þeir sáu sig ekki um hönd, en héldu áfram að syndga og vildu ekki trúa kraftaverkum Drottins. ");
INSERT INTO isl_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Þess vegna stytti hann ævi þeirra og sendi þeim miklar hörmungar. ");
INSERT INTO isl_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","En þegar neyðin var stærst, tóku þeir að leita Guðs. Þeir iðruðust og snéru sér til hans. ");
INSERT INTO isl_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Þeir viðurkenndu að Guð er eini grundvöllur lífsins – að hinn hæsti Guð væri frelsari þeirra. ");
INSERT INTO isl_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","En því miður fylgdu þeir honum aðeins í orði kveðnu, en ekki af heilum hug, ");
INSERT INTO isl_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","hjarta þeirra var langt frá honum. Þeir stóðu ekki við orð sín. ");
INSERT INTO isl_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Samt var hann þeim miskunnsamur, fyrirgaf syndir þeirra og tortímdi þeim ekki. Margoft hélt hann aftur af reiði sinni. ");
INSERT INTO isl_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Hann minntist þess að þeir voru dauðlegir menn, eins og andblær sem kemur og fer. ");
INSERT INTO isl_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Já, oft risu þeir gegn Guði í eyðimörkinni og ollu honum vonbrigðum. ");
INSERT INTO isl_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Aftur og aftur sneru þeir við honum baki og freistuðu hans. ");
INSERT INTO isl_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Þeir gleymdu krafti hans og kærleika og hvernig hann hafði frelsað þá frá óvinum þeirra. ");
INSERT INTO isl_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","Þeir gleymdu plágunum sem hann sendi Egyptum í Sóan ");
INSERT INTO isl_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","þegar hann breytti fljótum þeirra í blóð, svo að enginn gat drukkið. ");
INSERT INTO isl_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Eða þegar hann fyllti landið af flugum og froskum! ");
INSERT INTO isl_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","Lirfurnar spilltu uppskerunni og engispretturnar átu allt, hvort tveggja var frá honum komið. ");
INSERT INTO isl_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Hann eyddi vínviði þeirra með hagléli og mórberjatrjánum með frosti. ");
INSERT INTO isl_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","Búpeningurinn hrundi niður í haganum, haglið rotaði hann og sauðirnir drápust í eldingum. ");
INSERT INTO isl_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","Hann úthellti reiði sinni yfir þá, sendi þeim ógn og skelfingu. Hann leysti út sendiboða ógæfunnar – engla sem létu þá kenna á því! ");
INSERT INTO isl_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","Hann gaf reiðinni lausan tauminn. Og ekki hlífði hann Egyptunum. Þeir fengu vænan skerf af plágum og sjúkdómum. ");
INSERT INTO isl_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","Þá deyddi hann frumburði Egypta, efnilegan ungviðinn, sem vonirnar voru bundnar við. ");
INSERT INTO isl_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Sinn eigin lýð leiddi hann styrkri hendi gegnum eyðimörkina. ");
INSERT INTO isl_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Hann var skjól þeirra og vörn. Þeir þurftu ekkert að óttast, en hafið gleypti óvini þeirra. ");
INSERT INTO isl_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Hann greiddi för þeirra til fyrirheitna landsins, til hæðanna sem hann hafði skapað. ");
INSERT INTO isl_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Íbúum landsins stökkti hann á flótta en gaf þar ættkvíslum Ísraels erfðahlut og skjól. ");
INSERT INTO isl_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","En þótt þeir nytu gæsku Guðs, risu þeir gegn hinum hæsta og fyrirlitu boðorð hans. ");
INSERT INTO isl_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","Þeir sneru af leið og rufu trúnað rétt eins og feður þeirra. Eins og bogin ör misstu þeir marksins sem Guð hafði sett þeim. ");
INSERT INTO isl_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Þeir tóku aðra guði, reistu þeim ölturu og egndu Drottin á móti sér. ");
INSERT INTO isl_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Guð sá verk þeirra og reiddist – fékk viðbjóð á Ísrael. ");
INSERT INTO isl_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Hann yfirgaf helgidóm sinn í Síló, bústað sinn meðal manna. ");
INSERT INTO isl_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","Örk sína lét hann falla í hendur óvinanna og vegsemd hans var óvirt af heiðingjum. ");
INSERT INTO isl_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","Hann reiddist lýð sínum og lét hann falla fyrir sverði óvinanna. ");
INSERT INTO isl_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","Æskumenn Ísraels fórust í eldi og ungu stúlkurnar upplifðu ekki sinn brúðkaupsdag. ");
INSERT INTO isl_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Prestunum var slátrað og ekkjur þeirra dóu áður en þær gátu harmað þá. ");
INSERT INTO isl_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Þá var sem Drottinn vaknaði af svefni, eins og hetja sem rís upp úr vímu, ");
INSERT INTO isl_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","og hann gaf þeim vænt spark í bakhlutann og sendi þá burt með skömm, sömu leið og þeir komu. ");
INSERT INTO isl_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Hann hafnaði fjölskyldu Jósefs, ætt Efraíms, ");
INSERT INTO isl_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","en kaus Júdaættkvísl og Síonfjall, sem hann elskar. ");
INSERT INTO isl_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","Þar reisti hann musteri sitt – voldugt og traust rétt eins og himin og jörð. ");
INSERT INTO isl_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","Hann kaus Davíð sem þjón sinn, tók hann frá sauðunum, ");
INSERT INTO isl_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","úr smalamennskunni, til að verða leiðtogi og hirðir þjóðar sinnar. Og hann gætti hennar af öryggi og með hreinu hjarta. ");
INSERT INTO isl_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","Guð, – hefur þú ekki heyrt: Heiðingjarnir hafa ráðist inn í land þitt! Musterið hefur verið saurgað og Jerúsalem er rjúkandi rúst! ");
INSERT INTO isl_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Lík þinna manna liggja á bersvæði og eru fæða hræfugla og villidýra! ");
INSERT INTO isl_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Óvinirnir hafa stráfellt íbúa Jerúsalem, svo að allt flýtur í blóði. Enginn er eftir til að grafa hina föllnu. ");
INSERT INTO isl_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Nágrannaþjóðirnar hæða okkur og spotta og ausa svívirðingum. ");
INSERT INTO isl_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","Drottinn, hversu lengi ætlar þú að vera okkur reiður? Að eilífu? Á vandlæti þitt að brenna þar til öll von er úti?! ");
INSERT INTO isl_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Úthelltu heldur reiði þinni yfir guðlausu þjóðirnar, ekki okkur! Já, yfir konungsríkin sem ekki ákalla nafn þitt. ");
INSERT INTO isl_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","Það eru þau sem hafa útrýmt þjóð þinni og ráðist inn á hvert heimili. ");
INSERT INTO isl_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Við biðjum þig: Láttu okkur ekki gjalda löngu drýgðra synda forfeðranna! Miskunnaðu þig yfir eymd okkar, því að við höfum verið troðnir niður í svaðið! ");
INSERT INTO isl_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","Hjálpaðu okkur, því að þú ert frelsari okkar! Hjálpaðu okkur, vegna þíns eigin orðstírs! Frelsaðu okkur og fyrirgefðu okkur syndirnar. ");
INSERT INTO isl_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Hvers vegna fá heiðnu þjóðirnar að hæða okkur og segja: „Hvar er þessi Guð ykkar?!“ Hefndu ófara lýðs þíns svo að eftir verði tekið! ");
INSERT INTO isl_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Hlustaðu á stunur fanganna og hinna dauðadæmdu. Sýndu mátt þinn og frelsaðu þá. ");
INSERT INTO isl_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","Drottinn, láttu þá fá sjöfalt endurgjald, þessar þjóðir sem hæða þig og spotta! ");
INSERT INTO isl_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Þá munum við, þjóð þín og gæsluhjörð, lofa þig að eilífu og þakka mikilleika þinn frá kynslóð til kynslóðar. ");
INSERT INTO isl_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","2","Þú hirðir Ísraels sem leiðir þjóð þína eins og hjörð. Þú Guð sem situr á hásæti uppi yfir verndarenglunum, beygðu þig niður og hlustaðu á bæn mína. Láttu veldi þitt birtast í geisladýrð! ");
INSERT INTO isl_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","Leyfðu ættkvíslum Efraíms, Benjamíns og Manasse að verða vitni að því er þú frelsar okkur með mætti þínum. ");
INSERT INTO isl_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","Dragðu okkur til þín á ný, ó Guð. Líttu til okkar með velþóknun og kærleika, það er okkar eina von. ");
INSERT INTO isl_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Ó, Drottinn, þú Guð sem stjórnar hersveitum himnanna, hve lengi ætlar þú að draga bænheyrsluna og láta reiði þína haldast? ");
INSERT INTO isl_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Þú hefur alið okkur á sorg og sút ");
INSERT INTO isl_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","og gert okkur að andstyggð í augum nágrannaþjóðanna sem hæða okkur og spotta. ");
INSERT INTO isl_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Drottinn hersveitanna, dragðu okkur til þín á ný. Líttu til okkar með velþóknun og kærleika, annars er úti um okkur. ");
INSERT INTO isl_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Þú fluttir okkur frá Egyptalandi eins og gæðavínvið, upprættir heiðingjana og gróðursettir okkur í landinu. ");
INSERT INTO isl_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Þú plægðir jörðina og braust landið, við skutum rótum og klæddum hæðirnar. ");
INSERT INTO isl_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Við skyggðum á fjöllin og breiddum úr okkur eins og greinar sedrustrésins, ");
INSERT INTO isl_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","þöktum landið frá Miðjarðarhafi og allt til Evfrat. ");
INSERT INTO isl_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","En nú hefur þú brotið niður múra okkar og eftir stöndum við varnarlausir. ");
INSERT INTO isl_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","Landið hefur verið eytt og er nú orðið að bústað villidýra. ");
INSERT INTO isl_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","Við biðjum þig, þú Guð hinna himnesku hersveita, komdu og blessaðu okkur. Líttu niður af himni, sjáðu þjáningar okkar og hlúðu að þessum vínviði þínum! ");
INSERT INTO isl_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Vernda það sem þú sjálfur gróðursettir, einkasoninn þinn! ");
INSERT INTO isl_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Óvinirnir lögðu okkur að velli og kveiktu í borgunum. Þeir farast fyrir augliti þínu! ");
INSERT INTO isl_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Styrktu manninn sem þú elskar, soninn sem þú valdir ");
INSERT INTO isl_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","og við munum aldrei snúa við þér baki. Lífgaðu okkur á nýjan leik og þá skulum við ákalla þig. ");
INSERT INTO isl_vpl VALUES ("PS80_20","020_80_20","PSA","80","20","20","Drottinn, Guð hersveitanna, dragðu okkur til þín á ný. Líttu niður til okkar og láttu okkur sjá velþóknun þína. ");
INSERT INTO isl_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","2","Guð er okkar styrkur! Syngið lofsöng og fagnið fyrir Guði Ísraels! ");
INSERT INTO isl_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Syngið lofsöng og berjið bumbur, sláið strengi hörpunnar og látið gígjurnar hljóma! ");
INSERT INTO isl_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Lúðurinn hvelli! Komið til fagnaðar þegar tunglið er fullt og fjölmennið á hátíðir Drottins. ");
INSERT INTO isl_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Þetta er regla í Ísrael; boðorð frá Guði Jakobs. ");
INSERT INTO isl_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","Við höldum hátíð og minnumst sigurs Drottins á Egyptum þegar við vorum þrælar þar í landi. Ég heyrði ókunna rödd sem sagði: ");
INSERT INTO isl_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","„Ég vil varpa af þér byrðinni, losa af þér ánauðarfjötrana.“ ");
INSERT INTO isl_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","Og hann hélt áfram: „Þú hrópaðir í neyðinni og ég frelsaði þig. Ég svaraði þér úr þrumuskýi. Ég reyndi trú þína hjá Meríba, þar sem þorstinn var sár. ");
INSERT INTO isl_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Hlustaðu nú á mig, þjóð mín, þegar ég áminni þig. Ísrael, ó, að þú vildir hlýða mér. ");
INSERT INTO isl_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Engum öðrum guðum mátt þú þjóna og ekki tilbiðja neina útlenda guði. ");
INSERT INTO isl_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","Því að það var ég, Drottinn, Drottinn Guð þinn sem leiddi þig út úr Egyptalandi. Prófa þú mig einu sinni enn. Opnaðu munninn og sjáðu hvort ég muni ekki fylla hann. Þú munt vissulega fá hjá mér hverja þá blessun sem þú þarft! ");
INSERT INTO isl_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Nei, annars – þjóð mín vill ekki hlusta á mig. Ísrael kærir sig ekki um mig. ");
INSERT INTO isl_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","Þess vegna leyfi ég þeim að ráfa í blindni á vegum þrjósku sinnar og lifa eftir sínum eigin girndum. ");
INSERT INTO isl_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","Aðeins ef þjóð mín vildi hlusta á mig! Ó, að Ísrael kysi nú að fylgja mér, ganga á mínum vegum! ");
INSERT INTO isl_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Þá mundi ég skjótlega brjóta óvini þeirra á bak aftur – reiða hnefann gegn kúgurum þeirra. ");
INSERT INTO isl_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","Þá mundu hatursmenn Drottins skríða fyrir honum og ógæfa þeirra vara við. ");
INSERT INTO isl_vpl VALUES ("PS81_17","020_81_17","PSA","81","17","17","En ykkur mundi hann ala vel! Já, gefa ykkur hunang úr klettaskoru!“ ");
INSERT INTO isl_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Guð stígur fram á himnum. Hann segir: „Réttur er settur!“ Síðan birtir hann úrskurð sinn gegn dómurum á jörðu. ");
INSERT INTO isl_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","Hve lengi ætlið þið, dómarar, að sniðganga réttlætið? Hve lengi ætlið þið að draga taum hinna ranglátu? ");
INSERT INTO isl_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Kveðið upp réttláta dóma í málum hinna fátæku og föðurlausu, bágstöddu og þjáðu, ");
INSERT INTO isl_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Losið fátæklingana úr klóm hinna guðlausu! ");
INSERT INTO isl_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","Þið eruð sljóir og fáfróðir og blindir. Þess vegna riðar þjóðfélagið til falls. ");
INSERT INTO isl_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Ég hef kallað ykkur „guði“ og „syni hins hæsta“, ");
INSERT INTO isl_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","en í raun og veru eruð þið aðeins dauðlegir menn. Þið munuð falla rétt eins og aðrir af höfðingjunum. ");
INSERT INTO isl_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","Rís þú upp, ó Guð, og dæmdu jörðina. Þú hefur hana á valdi þínu og þjóðirnar eru í þinni hendi. ");
INSERT INTO isl_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","2","Guð, vertu ekki þögull og afskiptalaus þegar við biðjum til þín. Svaraðu okkur! Já, bjargaðu okkur! ");
INSERT INTO isl_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Heyrirðu ekki skarkalann og ysinn í hópi óvina þinna? Sérðu ekki hvað þeir aðhafast, þessir hatursmenn þínir? ");
INSERT INTO isl_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Þeir eru með ráðagerðir um að tortíma þeim sem þú elskar! ");
INSERT INTO isl_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","„Komum!“ segja þeir, „þurrkum út Ísrael, svo að þeir hætti að vera til og gleymist.“ ");
INSERT INTO isl_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Þetta var samþykkt af leiðtogum þeirra. Þessir undirrituðu sáttmála um að fylkja liði gegn almáttugum Guði: ");
INSERT INTO isl_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","Ísmaelítar, Edomítar, Móabítar og Hagrítar. ");
INSERT INTO isl_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","Einnig Gebalmenn, Ammon, Amalek, Filistear og Týrusbúar. ");
INSERT INTO isl_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Assýría hefur líka slegist í hópinn og gjört bandalag við afkomendur Lots. ");
INSERT INTO isl_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","Farðu með þá eins og Midíansmenn forðum, já eins og þú fórst með Sísera og Jabín við Kíshonlæk ");
INSERT INTO isl_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","og með óvini þína við Endór, en lík þeirra urðu að áburði á jörðina. ");
INSERT INTO isl_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","Láttu höfðingja þeirra falla eins og Óreb og Seeb, foringja þeirra deyja líkt og Seba og Salmúna ");
INSERT INTO isl_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","sem sögðu: „Leggjum undir okkur haglendi Drottins!“ ");
INSERT INTO isl_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","Þú, Guð minn, feyktu þeim burt eins og ryki, eins og hismi fyrir vindi ");
INSERT INTO isl_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","– eins og skógi sem brennur til ösku. ");
INSERT INTO isl_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","Flæmdu þá burt í óveðri, skelfdu þá með fellibyl þínum. ");
INSERT INTO isl_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Drottinn, láttu þá kenna á andúð þinni uns þeir viðurkenna mátt þinn og vald. ");
INSERT INTO isl_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Láttu öll þeirra verk mistakast, svo að þeir skelfist og blygðist sín ");
INSERT INTO isl_vpl VALUES ("PS83_19","020_83_19","PSA","83","19","19","og viðurkenni að þú einn, Drottinn, ert Guð yfir öllum guðum og að jörðin öll er á þínu valdi. ");
INSERT INTO isl_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","2","Ó, hve musteri þitt er yndislegt, þú Drottinn hersveitanna. ");
INSERT INTO isl_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Mig langar svo mjög, já ég þrái, að nálgast þig, hinn lifandi Guð. ");
INSERT INTO isl_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Jafnvel spörvum og svölum leyfist að búa sér hreiður innan um ölturu þín og eiga þar unga sína. Þú Drottinn hinna himnesku hersveita, konungur minn og Guð minn! ");
INSERT INTO isl_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Sælir eru þeir sem fá að búa í musteri þínu og syngja þér lof. ");
INSERT INTO isl_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Sælir eru þeir sem fá styrk frá þér og þrá það eitt að ganga veg þinn. ");
INSERT INTO isl_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Þegar þeir ganga gegnum táradalinn, þá breytir þú honum í vatnsríka vin og haustregrúð færir þeim blessun. ");
INSERT INTO isl_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","Þeir styrkjast á göngunni og fá að lokum að ganga fram fyrir Drottin í musteri hans á Síon. ");
INSERT INTO isl_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Drottinn, Guð hersveitanna, heyrðu bæn mína! Hlusta þú Guð Ísraels. ");
INSERT INTO isl_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Guð, þú ert vörn okkar, miskunna honum sem þú smurðir til konungs. ");
INSERT INTO isl_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Einn dagur í musteri þínu er betri en þúsund aðrir sem eytt er á öðrum stað! Frekar vildi ég vera dyravörður í musteri Guðs míns, en búa í höllum óguðlegra. ");
INSERT INTO isl_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","Því að Drottinn er okkur ljós og skjöldur. Vegsemd og náð veitir hann. Hann neitar þeim ekki um nein gæði sem hlýða honum. ");
INSERT INTO isl_vpl VALUES ("PS84_13","020_84_13","PSA","84","13","13","Drottinn hersveitanna, sæll er sá maður sem treystir þér. ");
INSERT INTO isl_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","2","Drottinn, þú hefur baðað land þetta blessun! Þú hefur snúið hlutunum Ísrael í hag ");
INSERT INTO isl_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","og fyrirgefið syndir þjóðar þinnar, já, hulið þær allar! ");
INSERT INTO isl_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Reiði þína hefur þú líka dregið í hlé. ");
INSERT INTO isl_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Dragðu okkur nær þér svo að við getum elskað þig heitar, að þú þurfir ekki að reiðast okkur á ný. ");
INSERT INTO isl_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","(Eða mun reiði þín vara að eilífu, frá kynslóð til kynslóðar?) ");
INSERT INTO isl_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","Lífgaðu okkur við, þjóð þína, svo að við getum aftur lofað þig. ");
INSERT INTO isl_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Leyfðu okkur að njóta elsku þinnar og gæsku, ó Guð, og veittu okkur hjálp þína. ");
INSERT INTO isl_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Þegar Drottinn talar til þjóðar sinnar, hlusta ég vel, þegar hann ávarpar sinn útvalda lýð. Hann flytur okkur frið og velgengni þegar við snúum hjörtum okkar til hans. ");
INSERT INTO isl_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Vissulega njóta þeir hjálpar hans þeir sem hlýða honum og heiðra hann. Velgengni og blessun hans mun breiðast yfir allt landið. ");
INSERT INTO isl_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Miskunn og sannleikur munu mætast, réttlæti og friður kyssast! ");
INSERT INTO isl_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Trúfestin eflist á jörðu og réttlætið brosir frá himni! ");
INSERT INTO isl_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Drottinn blessar landið og það ber margfalda uppskeru. ");
INSERT INTO isl_vpl VALUES ("PS85_14","020_85_14","PSA","85","14","14","Réttlæti og friður fylgir Drottni. ");
INSERT INTO isl_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","Drottinn, líttu til mín! Hlustaðu á bæn mína! Svaraðu mér því að ég er í nauðum staddur. ");
INSERT INTO isl_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Bjargaðu mér frá dauða, því að ég tilheyri þér. Frelsaðu mig, því að ég treysti þér og hlýði. ");
INSERT INTO isl_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Miskunna mér, Drottinn. Ég mæni til þín og vona á þig liðlangan daginn. ");
INSERT INTO isl_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Drottinn, leyfðu mér að gleðjast því að ég tilbið þig einan. ");
INSERT INTO isl_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Drottinn, þú ert mildur og góður og fús að fyrirgefa, gæskuríkur við alla sem ákalla þig. ");
INSERT INTO isl_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Heyr þú bæn mína Drottinn, því að ég ákalla þig í neyð minni. ");
INSERT INTO isl_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Þegar ég er í vanda staddur hrópa ég til þín því að þú hjálpar mér. ");
INSERT INTO isl_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","Enginn hinna heiðnu guða stenst samjöfnuð við þig! Þín verk eru engu lík! ");
INSERT INTO isl_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Þjóðirnar – þú skapaðir þær allar – munu koma og lúta þér. Þær munu lofa þitt háa og heilaga nafn ");
INSERT INTO isl_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","því að þú ert mikill og gerir furðuverk. Þú einn ert Guð! ");
INSERT INTO isl_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","Sýndu mér, Drottinn, hvert þú vilt senda mig og þangað mun ég fara, því það er vegur sannleikans. Ó, að ég gæti tignað þig af heilu hjarta og hreinni samvisku! ");
INSERT INTO isl_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","Ég lofa þig Drottinn Guð minn af öllu hjarta. Ég vil vegsama nafn þitt að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Mikill er kærleikur þinn! Þú ert mér alltaf svo góður! Þú frelsaðir mig úr djúpi heljar. ");
INSERT INTO isl_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","Ofstopamenn rísa gegn mér. Guðlaus illmenni vilja ryðja mér burt. ");
INSERT INTO isl_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","En þú, Drottinn, ert miskunnsamur Guð, seinn til reiði, langlyndur og trúr. ");
INSERT INTO isl_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Líttu til mín í náð og styrktu mig. Ég er þjónn þinn, frelsaðu mig. ");
INSERT INTO isl_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Gefðu mér tákn um að þú elskir mig. Þegar óvinir mínir sjá það, munu þeir blygðast sín því að þú hjálpar mér og huggar mig. ");
INSERT INTO isl_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","2","Hátt á hinu heilaga fjalli, stendur Jerúsalem, borg Guðs – borgin sem hann elskar öllum borgum framar. ");
INSERT INTO isl_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","Vel er um þig talað, þú borg Guðs! ");
INSERT INTO isl_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","Ef ég í vinahópi minnist á Egyptaland eða Babýlon, Filisteu eða Týrus eða hið fjarlæga Bláland, þá hrósa þeir sér sem fæddir eru á þessum stöðum. ");
INSERT INTO isl_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","En mestur heiður fylgir Jerúsalem! Hún er móðirin og gott er að vera fæddur þar! Hann, hinn hæsti Guð, mun sjálfur vernda hana. ");
INSERT INTO isl_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Þegar Drottinn lítur yfir þjóðskrárnar, mun hann merkja við þá sem hér eru fæddir! ");
INSERT INTO isl_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Á hátíðum og tyllidögum munu menn syngja: „Jerúsalem, uppsprettur lífs míns eru í þér!“ ");
INSERT INTO isl_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","2","Drottinn, þú Guð minn og hjálpari minn, ég ákalla þig um daga og nætur. ");
INSERT INTO isl_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Svaraðu bænum mínum! Hlustaðu á hróp mitt, ");
INSERT INTO isl_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","því að ég er altekinn ótta og finn dauðann nálgast. ");
INSERT INTO isl_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","„Líf hans er að fjara út,“ segja sumir, „það er vonlaust með hann.“ ");
INSERT INTO isl_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Ég er einn og yfirgefinn og bíð þess eins að deyja, rétt eins og þeir sem falla á vígvellinum. ");
INSERT INTO isl_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Þú hefur varpað mér niður í myrkradjúp. ");
INSERT INTO isl_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Reiði þín hefur þrýst mér niður, hver holskeflan á fætur annarri kaffærir mig. ");
INSERT INTO isl_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Vinir mínir sneru við mér bakinu og eru horfnir – það var af þínum völdum. Ég er innikróaður, sé enga undankomuleið. ");
INSERT INTO isl_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","Augu mín eru blinduð af tárum. Daglega kalla ég eftir hjálp þinni. Ó, Drottinn, ég lyfti höndum í bæn um náð! ");
INSERT INTO isl_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Gerðu kraftaverk svo að ég deyi ekki, því hvað gagnar mér hjálp þín ef ég ligg kaldur í gröfinni? Þá get ég ekki lofað þig! ");
INSERT INTO isl_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","Geta hinir látnu vegsamað gæsku þína? Syngja þeir um trúfesti þína?! ");
INSERT INTO isl_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Getur myrkrið borið vitni um máttarverk þín? Hvernig eiga þeir sem búa í landi gleymskunnar að tala um hjálp þína? ");
INSERT INTO isl_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Ó, Drottinn, dag eftir dag bið ég fyrir lífi mínu. ");
INSERT INTO isl_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Drottinn, hvers vegna hefur þú útskúfað mér? Af hverju hefur þú snúið þér burt frá mér og litið í aðra átt? ");
INSERT INTO isl_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Allt frá æsku hef ég átt erfiða ævi og oft staðið andspænis dauðanum. Ég er magnþrota gagnvart örlögum þeim sem þú hefur búið mér. ");
INSERT INTO isl_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Heift þín og reiði hefur lamað mig. Þessi skelfing þín hefur næstum gert út af við mig. ");
INSERT INTO isl_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Alla daga hvolfist hún yfir mig. ");
INSERT INTO isl_vpl VALUES ("PS88_19","020_88_19","PSA","88","19","19","Ástvinir, félagar og kunningjar – öll eru þau farin. Ég sit hér einn í myrkri. ");
INSERT INTO isl_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","2","Ég vil syngja um miskunn Drottins að eilífu! Ungir sem gamlir skulu fá að heyra um trúfesti þína. ");
INSERT INTO isl_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Elska þín og náð vara að eilífu og trúfesti þín stendur óhögguð eins og himinninn. ");
INSERT INTO isl_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","5","Svo segir Drottinn Guð: „Ég hef gert sáttmála við Davíð, minn útvalda þjón. Ég hef unnið þann eið, að afkomendur hans skuli sitja á konungsstóli héðan í frá og að eilífu!“ ");
INSERT INTO isl_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Himinninn lofi máttarverk þín, Drottinn og herskarar englanna vegsami trúfesti þína. ");
INSERT INTO isl_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Því að hver á himnum kemst í samjöfnuð við Guð? Hinn mesti meðal englanna, hver er hann við hlið Drottins?! ");
INSERT INTO isl_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Hinir voldugu englar nálgast hann með ótta og virðingu. Hann er ægilegur í þeirra augum. ");
INSERT INTO isl_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Drottinn, þú konungur hinna himnesku hersveita, enginn kemst í samjöfnuð við þig! Trúfestin er einkenni þitt! ");
INSERT INTO isl_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Þú hefur hemil á ofstopa hafsins, stöðvar óveðursöldur. Með einu orði lægir þú þær. ");
INSERT INTO isl_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Þú rotaðir skrímslið, það lá marflatt – og tvístraðir óvinum þínum með undramætti. ");
INSERT INTO isl_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Himinninn og jörðin, allt er það þitt. Þú skapaðir það. ");
INSERT INTO isl_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Þú skapaðir norðrið og suðrið líka. Tabor og Hermon kætast, hin háu fjöll, sem hönd þín gjörði. ");
INSERT INTO isl_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Mikill er máttur þinn! Hægri hönd þín er upphafin í mætti og dýrð! ");
INSERT INTO isl_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","16","Tvær eru undirstöður hásætis þíns: Réttvísi og réttlæti, og miskunn og trúfesti eru fylgdarsveinar þínir. Sælir eru þeir sem heyra fagnaðarópið – þeir sem ganga í ljósinu sem stafar frá Drottni. ");
INSERT INTO isl_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Þín vegna gleðjast þeir alla daga og fagna yfir þínum réttlátu verkum. ");
INSERT INTO isl_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Þú ert styrkur þeirra. Þetta er undursamlegt! Já, við hressumst og gleðjumst því við vitum að þú hefur velþóknun á okkur! ");
INSERT INTO isl_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Sjálfur Drottinn er okkar vörn og hann, hinn heilagi í Ísrael – sjálfur Guð – hefur gefið okkur konung. ");
INSERT INTO isl_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Þú talaðir við spámann þinn í sýn og sagðir: „Ég hef fundið rétta manninn meðal fólksins, hann skal verða konungur! ");
INSERT INTO isl_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Það er Davíð, þjónn minn! Ég hef smurt hann minni heilögu olíu. ");
INSERT INTO isl_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Ég vil veita honum kraft og styrkja hann á göngunni. ");
INSERT INTO isl_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Óvinir hans skulu ekki fella hann, né illmennin kúga hann. ");
INSERT INTO isl_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Ég mun láta hann sjá er ég eyði óvinum hans og þurrka út hatursmenn hans. ");
INSERT INTO isl_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Ég mun stöðugt vernda hann og blessa og umvefja hann elsku minni. Mín vegna mun hann verða mikill. ");
INSERT INTO isl_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Ríki hans mun ná frá Miðjarðarhafi til Evfratfljóts. ");
INSERT INTO isl_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Hann mun segja við mig: „Þú ert faðir minn, Guð minn, klettur hjálpræðis míns.“ ");
INSERT INTO isl_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Ég mun líta á hann sem frumgetinn son minn og gera hann fremstan meðal konunga jarðarinnar. ");
INSERT INTO isl_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Ég mun elska hann að eilífu og vera honum góður. Ég mun halda sáttmála minn við hann að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","Hann mun aldrei skorta erfingja og hásæti hans mun standa um eilífð eins og himinninn. ");
INSERT INTO isl_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","33","Ef afkomendur hans hafna lögmáli mínu og óhlýðnast mér, þá mun ég hegna þeim, ");
INSERT INTO isl_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","en aldrei mun ég þó hætta að miskunna þeim, né bregðast loforði mínu. ");
INSERT INTO isl_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Nei, sáttmála minn mun ég alls ekki rjúfa. Ekkert orða minna tek ég aftur. ");
INSERT INTO isl_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","37","Ég hef heitið Davíð því (og hinn heilagi Guð talar sannleika) að konungsætt hans mun vara um aldir alda, já rétt eins og sólin! ");
INSERT INTO isl_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Konungdómur hans skal standa að eilífu eins og tunglið, – trúfasta vitnið á himninum!“ ");
INSERT INTO isl_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","En, – hvers vegna hefur þú þá útskúfað mér?! Hafnað þeim sem þú valdir til konungs? ");
INSERT INTO isl_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Hefur þú rofið sáttmálann við hann? Þú sem kastaðir kórónu hans í skítinn! ");
INSERT INTO isl_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Múra hans hefur þú brotið og rifið niður varnarvirkin. ");
INSERT INTO isl_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Allir vegfarendur ræna hann. Hann er til háðungar nágrönnum sínum. ");
INSERT INTO isl_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Þú magnaðir óvini hans gegn honum, og nú kætast þeir! ");
INSERT INTO isl_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Þú slóst sverð hans til jarðar og neitaðir honum um hjálp í bardaganum. ");
INSERT INTO isl_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Þú hefur bundið enda á vegsemd hans og hrint hásæti hans um koll. ");
INSERT INTO isl_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","Hann lítur út sem öldungur þótt ungur sé, og það er af þínum völdum. Þú hefur hulið hann skömm. ");
INSERT INTO isl_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Ó, Drottinn, hve lengi á þetta ástand að vara? Ætlar þú að fela þig fyrir mér að eilífu? Hve lengi á reiði þín að brenna? ");
INSERT INTO isl_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Mundu hve mannsævin er stutt og að verk okkar flestra eru hégómleg og smá. ");
INSERT INTO isl_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","Enginn maður lifir endalaust. Öll deyjum við að lokum. Og hver getur stigið upp úr gröf sinni? ");
INSERT INTO isl_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","Drottinn, hvar er nú kærleikur þinn til mín? Hvar er gæskan sem þú lofaðir Davíð með eiði? ");
INSERT INTO isl_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","Veistu það, Drottinn, að öll þjóðin hæðist að mér! ");
INSERT INTO isl_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","Óvinir þínir spotta mig, manninn sem þú útvaldir til konungs. ");
INSERT INTO isl_vpl VALUES ("PS89_53","020_89_53","PSA","89","53","53","En þrátt fyrir allt og allt, sé Drottinn lofaður um eilífð! Amen, amen. ");
INSERT INTO isl_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Bæn guðsmannsins Móse. Drottinn, þú hefur verið okkur athvarf frá kynslóð til kynslóðar. ");
INSERT INTO isl_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Áður en þú skapaðir fjöllin og jörðin varð til, varst þú, ó Guð – þú átt þér hvorki upphaf né endi! ");
INSERT INTO isl_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Þú talar – og maðurinn verður aftur að dufti. ");
INSERT INTO isl_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Þúsund ár eru eins og einn dagur fyrir þér, eins og klukkustund! ");
INSERT INTO isl_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","6","Við berumst með straumi tímans og hverfum líkt og í draumi. Við erum eins og grasið sem grær að morgni en skrælnar að kvöldi, visnar og deyr. ");
INSERT INTO isl_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Við föllum fyrir reiði þinni og hnígum fyrir bræði þinni. ");
INSERT INTO isl_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Þú hefur breitt úr syndum okkar frammi fyrir þér – einnig hinum leyndu syndum – engin þeirra er þér hulin. ");
INSERT INTO isl_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Reiði þín er enginn leikur. Er að undra þótt ævin sé erfið og dagarnir líði sem andvarp. ");
INSERT INTO isl_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Ævi okkar er sjötíu ár og þegar best lætur áttatíu ár. En jafnvel bestu árin eru full af mæðu og hégóma. Þau eru horfin áður en varir og við á bak og burt! ");
INSERT INTO isl_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Hver þekkir ógnir reiði þinnar, og hvert okkar óttast þig eins og ber? ");
INSERT INTO isl_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Kenndu okkur að telja alla okkar daga og skilja hve ævin er stutt. Gefðu að við fáum notað hana til góðs. ");
INSERT INTO isl_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","Ó, Drottinn, hve lengi er þess að bíða að þú dragir reiði þína í hlé og blessir okkur á nýjan leik? ");
INSERT INTO isl_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Miskunna okkur á hverjum morgni að við megum gleðjast hvern einasta dag. ");
INSERT INTO isl_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Já, gefðu okkur gleði í stað armæðu liðinna daga. ");
INSERT INTO isl_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Leyfðu okkur aftur að reyna máttarverk þín svo að börn okkar sjái dýrð þína eins og við forðum. ");
INSERT INTO isl_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Náð Drottins Guðs sé með okkur. Hann veiti okkur gæfu og gengi. ");
INSERT INTO isl_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Sæll er sá sem nýtur verndar hins hæsta og hvílir í skjóli hins almáttuga, ");
INSERT INTO isl_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","sá sem getur sagt við Drottin: „Þú ert skjól mitt og vörn! Þú ert minn Guð, ég treysti þér!“ ");
INSERT INTO isl_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Hann frelsar þig úr snörunni og bjargar þér undan plágunni. ");
INSERT INTO isl_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Hann mun skýla þér undir vængjum sínum. Þar muntu finna öruggt skjól! Hann hefur lofað að vernda þig og frelsa. ");
INSERT INTO isl_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Nú þarftu ekki lengur að óttast ógnir myrkursins, né örina sem þýtur að morgni. ");
INSERT INTO isl_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","Heldur ekki drepsótt næturinnar né skelfingu um hábjartan dag. ");
INSERT INTO isl_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Þótt þúsund falli mér við hlið og tíu þúsund mér til hægri handar, þá mun hið illa ekki ná til mín. ");
INSERT INTO isl_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Ég mun horfa á þegar óguðlegum er refsað en sjálfur vera óhultur, ");
INSERT INTO isl_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","því að Drottinn er skjól mitt! Ég hef valið hinn hæsta Guð mér til varnar. ");
INSERT INTO isl_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","Hvernig ætti þá ógæfa að yfirbuga mig eða plága að nálgast hús mitt? ");
INSERT INTO isl_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Eins skipar hann englum sínum að vernda þig, hvar sem þú ert. ");
INSERT INTO isl_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Þeir munu styðja þig á göngunni og forða þér frá hrösun. ");
INSERT INTO isl_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Þótt þú mætir ljóni eða snák, þá er ekkert að óttast – þú munt jafnvel troða þau fótum! ");
INSERT INTO isl_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Hefur Drottinn ekki sagt: „Vegna þess að þú elskar mig, mun ég frelsa þig. Ég bjarga þér af því að þú þekkir mig og veist að mér er óhætt að treysta. ");
INSERT INTO isl_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Þegar þú kallar á mig, svara ég þér. Ég er með þér á hættustund, frelsa þig og held uppi heiðri þínum. ");
INSERT INTO isl_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Ég mun gefa þér langa og góða ævi og láta þig sjá hjálpræði mitt.“ ");
INSERT INTO isl_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","2","Gott er að þakka Drottni og lofsyngja Guði hinum hæsta. ");
INSERT INTO isl_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","Á hverjum morgni segi ég við Drottin: „Þökk sé þér fyrir miskunn þína!“ Og á kvöldin fagna ég yfir trúfesti hans. ");
INSERT INTO isl_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","Syngið honum lof og leikið undir á hörpu og gígju. ");
INSERT INTO isl_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Drottinn, mikið ertu mér góður. Ég syng af gleði! – Er nokkur hissa á því? ");
INSERT INTO isl_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Ó, Drottinn, mikil eru máttarverk þín! ");
INSERT INTO isl_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","Þeir einir sem ekki nenna að hugsa, fara þeirra á mis. Heimskingjarnir skilja ekki ");
INSERT INTO isl_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","að hinir óguðlegu – sem í bili virðast hafa það gott – munu afmáðir að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","En Drottinn, þú lifir að eilífu, hátt upphafinn á himnum, ");
INSERT INTO isl_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","meðan óvinir þínir – illgjörðamennirnir – tvístrast. ");
INSERT INTO isl_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Ég finn styrk og kraft, en Drottinn, allt er það þér að þakka! Blessun þín hefur endurnært mig. ");
INSERT INTO isl_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Ég heyrði dóminn yfir óvinum mínum og sá þegar þeim var eytt. ");
INSERT INTO isl_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","En hinir réttlátu munu blómgast líkt og ávaxtatré, já vaxa eins og sedrustrén í Líbanon. ");
INSERT INTO isl_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Því að þeir eru gróðursettir í garði Drottins og njóta umhyggju hans. ");
INSERT INTO isl_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","Jafnvel á elliárunum bera þeir ávöxt og eru sem laufguð tré. ");
INSERT INTO isl_vpl VALUES ("PS92_16","020_92_16","PSA","92","16","16","Þeir bera vitni um réttlæti Drottins, að hann er skjól og vernd og allt sem hann gerir er gott! ");
INSERT INTO isl_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","2","Drottinn er konungur! Hann er íklæddur mætti og dýrð. Heimurinn allur er hásæti hans. Ó, Drottinn, þú hefur ríkt frá örófi alda. ");
INSERT INTO isl_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Brimöldur hafsins boða dýrð þína. ");
INSERT INTO isl_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","En þú ert meiri en voldugar öldur sem brotna við strendur úthafanna! ");
INSERT INTO isl_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Skipunum þínum fær enginn breytt og heilagleiki er einkenni húss þíns að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","2","Drottinn, þú ert Guð hefndarinnar – sá Guð sem réttir hlut þeirra sem ranglæti eru beittir. Láttu dýrð þína birtast. Rís upp, þú dómari jarðar. Refsaðu ofstopamönnum fyrir illverk þeirra. ");
INSERT INTO isl_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","Drottinn, hve lengi eiga óguðlegir að hrósa sigri? ");
INSERT INTO isl_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","Þeir eru að springa af monti! Hlustaðu á grobbið í þeim! ");
INSERT INTO isl_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Drottinn, líttu á hvernig þeir kúga þjóð þína og kvelja fólkið sem þú elskar. ");
INSERT INTO isl_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","7","Þeir myrða ekkjur og munaðarleysingja og líka útlendinga sem hér hafa sest að. „Drottinn sér þetta ekki,“ segja þeir, „hann lætur sér fátt um finnast.“ ");
INSERT INTO isl_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Heimskingjar! ");
INSERT INTO isl_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","Haldið þið að Guð sé blindur og heyrnarlaus, hann sem skapar bæði augu og eyru! ");
INSERT INTO isl_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","Hann refsar þjóðunum – og nú er komið að ykkur. Enginn hlutur er honum hulinn. Eins og hann viti ekki hvað þið hafið gert! ");
INSERT INTO isl_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","Drottinn þekkir skammsýni og hégómleika mannanna ");
INSERT INTO isl_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","13","og því agar hann okkur til góðs. Það gerir hann til þess að við göngum á hans vegum og gefumst ekki upp í mótlæti. ");
INSERT INTO isl_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Drottinn afneitar ekki lýð sínum né yfirgefur þjóð sína. ");
INSERT INTO isl_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Dómar hans eru réttlátir og fylgjendur hans fagna af hreinu hjarta. ");
INSERT INTO isl_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","Hver vill vernda mig fyrir illgjörðamönnum? Hver vill vera skjöldur minn? ");
INSERT INTO isl_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Án Drottins væri ég dauðans matur. ");
INSERT INTO isl_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Ég æpti: „Drottinn, ég er að hrapa!“ og af gæsku sinni frelsaði hann mig. ");
INSERT INTO isl_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Drottinn, þegar efasemdir ásækja mig og hjarta mitt er fullt af angist, þá gefðu mér frið þinn og endurnýjaðu gleði mína. ");
INSERT INTO isl_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Vilt þú vernda og viðhalda spilltri valdsstjórn sem hallar réttlætinu? Leyfir þú slíkt? ");
INSERT INTO isl_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","22","Hefur þú þóknun á þeim sem dæma saklausa til dauða? Nei! Drottinn, Guð minn, er vígi mitt, kletturinn þar sem ég leita skjóls. ");
INSERT INTO isl_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","Guð lætur syndir óguðlegra koma þeim sjálfum í koll. Illverk þeirra verða þeim að falli. ");
INSERT INTO isl_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Komið! Við skulum lofsyngja Drottni! Hrópum gleðióp til heiðurs kletti hjálpræðisins! ");
INSERT INTO isl_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Komum fram fyrir hann með þakkargjörð, syngjum honum lofgjörðarsálm. ");
INSERT INTO isl_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Því að Drottinn er mikill Guð og æðri öllum sem menn kalla guði. ");
INSERT INTO isl_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Hann hefur upphugsað djúp jarðar og hannað hin hæstu fjöll. ");
INSERT INTO isl_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Hann gerði hafið og myndaði þurrlendið, allt er hans! ");
INSERT INTO isl_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Komið! Föllum fram fyrir Drottni, skapara okkar, ");
INSERT INTO isl_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","því að hann er okkar Guð. Við erum hjörðin hans og hann er hirðir okkar. Ó, að þið vilduð heyra kall hans í dag og koma til hans. ");
INSERT INTO isl_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","Forherðið ekki hjörtu ykkar eins og Ísraelsmenn gerðu hjá Meriba og Massa í eyðimörkinni. ");
INSERT INTO isl_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Þar drógu feður ykkar orð mín í efa – sömu menn og sáu mig gera mörg kraftaverk. Þeir freistuðu mín, kvörtuðu og reyndu á þolinmæði mína. ");
INSERT INTO isl_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","„Í fjörutíu ár hafði ég viðbjóð á þessari kynslóð,“ segir Drottinn Guð. „Hjörtu þeirra allra voru langt í burtu frá mér og ekki vildu þeir halda lög mín. ");
INSERT INTO isl_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Þá hét ég því að þeir skyldu aldrei komast inn í fyrirheitna landið, staðinn sem ég hafði ætlað þeim til hvíldar.“ ");
INSERT INTO isl_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Syngið Drottni nýjan söng! Syngið þann söng um alla jörðina! ");
INSERT INTO isl_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Syngið um velgjörðir hans, lofið nafn hans. Kunngerið hjálpráð hans dag eftir dag. ");
INSERT INTO isl_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Segið frá dýrð hans meðal þjóðanna, – allra þjóða. Kunngerið öllum dásemdarverk hans. ");
INSERT INTO isl_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Því að Drottinn er mikill og mjög vegsamlegur. Hann einn er sá Guð sem rétt er að tilbiðja. ");
INSERT INTO isl_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Þjóðirnar tilbiðja falsguði eina, en okkar Guð hefur skapað himininn! ");
INSERT INTO isl_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Hann er umvafinn heiðri og dýrð, styrkur og fegurð fylla musteri hans. ");
INSERT INTO isl_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Þið kynkvíslir jarðar, játið Drottni heiður og dýrð. ");
INSERT INTO isl_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Heiðrið hann eins og skyldugt er! Berið fram fórnina og tilbiðjið hann. ");
INSERT INTO isl_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Tilbiðjið Drottin í heilagleik og heiðri. Allur heimurinn skjálfi fyrir augliti hans. ");
INSERT INTO isl_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Kunngjörið þjóðunum að Drottinn er konungur. Hann ríkir yfir alheimi. Hann er skapari jarðar og mun dæma allar þjóðir með réttvísi. ");
INSERT INTO isl_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Himnarnir gleðjist og jörðin kætist og brimgnýr hafsins boði tign hans og mátt. ");
INSERT INTO isl_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Ávöxtur jarðar vitnar um dýrð hans og þytur trjánna lofar hann. ");
INSERT INTO isl_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","Því að Drottinn mun dæma heiminn með réttvísi og þjóðirnar eftir trúfesti sinni! ");
INSERT INTO isl_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","Drottinn er konungur! Allur heimurinn gleðjist! Fagnið þið eyjar við ysta haf! ");
INSERT INTO isl_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Tignarleg ský umlykja hann. Réttlæti og réttvísi eru undirstöður hásætis hans. ");
INSERT INTO isl_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Eldur gengur út frá honum og eyðir öllum óvinum hans. ");
INSERT INTO isl_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Elding hans leiftrar og lýsir upp jörðina. Heimurinn skelfur af ótta. ");
INSERT INTO isl_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Fjöllin bráðna eins og vax fyrir Drottni. ");
INSERT INTO isl_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Himnarnir kunngera réttlæti hans og allar þjóðir sjá dýrð hans. ");
INSERT INTO isl_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Allir skurðgoðadýrkendur verða til skammar – þeir sem stæra sig af falsguðum – því að allir slíkir guðir verða að beygja sig fyrir Drottni. ");
INSERT INTO isl_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","9","Jerúsalem og borgirnar í Júda hafa heyrt af réttvísi þinni, Drottinn, og fagna, því að þú ríkir með reisn yfir allri jörðinni og ert hátt yfir alla aðra guði hafinn. ");
INSERT INTO isl_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Drottinn elskar þá sem hata hið illa. Hann verndar líf fylgjenda sinna og frelsar þá undan óguðlegum. ");
INSERT INTO isl_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Ljós skal lýsa hinum réttlátu og gleði hlotnast hinum góðu. ");
INSERT INTO isl_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Allir réttlátir fagni fyrir Drottni og vegsami hans heilaga nafn. ");
INSERT INTO isl_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","Syngið nýjan söng fyrir Drottin því að hann hefur unnið dásamlegt verk! Hann er sigursæll í mætti sínum og heilagleika. ");
INSERT INTO isl_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Hann hefur tilkynnt sigur sinn – birt þjóðunum réttlæti sitt. ");
INSERT INTO isl_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Hann hefur miskunnað lýð sínum, haldið loforð sín til Ísrael. Allur heimurinn sá er Guð bjargaði þjóð sinni. ");
INSERT INTO isl_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Þess vegna hefja löndin fagnaðarsöng, syngja og lofa hann af öllu hjarta. ");
INSERT INTO isl_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Syngið Drottni við undirleik hörpu. ");
INSERT INTO isl_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","Blásið í lúðra og básúnur gjalli! Hljómsveitin spili lofgjörðarlag. Hyllið Drottin, konunginn! ");
INSERT INTO isl_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Hafið drynji og lofi Drottin! Jörðin og íbúar hennar reki upp fagnaðaróp! ");
INSERT INTO isl_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","9","Fossarnir klappi lof í lófa og klettarnir syngi gleðisöng, því að Drottinn mun dæma heiminn í réttlæti sínu og af réttvísi. ");
INSERT INTO isl_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","Drottinn er konungur! Þjóðirnar skjálfi! Hásæti hans stendur miklu ofar englunum. Jörðin nötri í óttablandinni virðingu. ");
INSERT INTO isl_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Drottinn ríkir með hátign á Síon, æðri öllum konungum á jörðu. ");
INSERT INTO isl_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Þeir tigni hans háa og heilaga nafn! ");
INSERT INTO isl_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Drottinn er voldugur konungur. Hann elskar réttlæti. Réttvísi og heiðarleiki einkenna stjórnarfar hans. Þannig ríkir hann í Ísrael. ");
INSERT INTO isl_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","Vegsamið Drottin, hinn heilaga Guð! Föllum fram við fótskör hans. ");
INSERT INTO isl_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Móse og Aron voru prestar hans og Samúel spámaður hans. Þeir báðu til Drottins og hann bænheyrði þá. ");
INSERT INTO isl_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","Úr skýstólpa talaði hann við þá, þeir hlustuðu og hlýddu fyrirmælum hans. ");
INSERT INTO isl_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","Ó, Drottinn, þú ert okkar Guð! Þú svaraðir þeim og fyrirgafst syndir þeirra. ");
INSERT INTO isl_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","Tignið Drottin Guð! Tilbiðjið hann í Jerúsalem á fjallinu helga. Hann er heilagur. ");
INSERT INTO isl_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Öll veröldin fagni fyrir Drottni! ");
INSERT INTO isl_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Þjónið Drottni með gleði, gangið fram fyrir hann með fagnaðarsöng! ");
INSERT INTO isl_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Reynið að skilja hvað í því felst að Drottinn er Guð. Við erum handaverk hans! Fólkið sem hann leiðir. ");
INSERT INTO isl_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Gangið inn um hlið hans með þakkargjörð, í forgarða hans með lofsöng. Þakkið honum, lofið nafn hans. ");
INSERT INTO isl_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Því að Drottinn er góður! Miskunn hans varir að eilífu og trúfesti hans frá kynslóð til kynslóðar. ");
INSERT INTO isl_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","Ég vil syngja um réttlætið og miskunnsemina. Ég vil lofsyngja þér, ó Guð! ");
INSERT INTO isl_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Ég, konungurinn, vil kappkosta að lifa heiðarlega og ganga um heimili mitt í grandvarleik – hjálpaðu mér til þess! ");
INSERT INTO isl_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Gefðu mér að forðast allt sem er gróft og ljótt – að fyrirlíta hið illa. ");
INSERT INTO isl_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Já, ég vil ekki vera sjálfselskur og vondur. ");
INSERT INTO isl_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Ég umber ekki þá sem baktala nágranna sinn, og hroka og dramb mun ég ekki þola. ");
INSERT INTO isl_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Ég leita uppi réttláta menn í landinu og kalla þá til starfa, að þeir búi hjá mér, – þeir einir sem grandvarir eru. ");
INSERT INTO isl_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Svikara og lygara þoli ég ekki í mínum húsum. ");
INSERT INTO isl_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Ég þagga niður í illmennunum í landinu og útrými úr borginni öllum óguðlegum. ");
INSERT INTO isl_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","2","Drottinn, heyrðu bæn mína! Hlustaðu á ákall mitt! ");
INSERT INTO isl_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Snúðu ekki baki við mér á ógæfutímum. Hneigðu eyra þitt að mér og svaraðu mér fljótt. ");
INSERT INTO isl_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","5","Ævi mín líður svo hratt, dagarnir fljúga hver af öðrum. Heilsan er búin, hjartað er sjúkt – ég er eins og visið strá. Maturinn er bragðlaus, ég er hættur að finna bragð. ");
INSERT INTO isl_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Ég er ekkert nema skinn og bein. ");
INSERT INTO isl_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Ég er líkastur pelikan í eyðimörk eða uglu í húsarúst. ");
INSERT INTO isl_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Ég ligg andvaka og styn eins og einmana fugl á þaki. ");
INSERT INTO isl_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","9","Óvinir mínir hæða mig og spotta dag eftir dag. ");
INSERT INTO isl_vpl VALUES ("PS102_10","020_102_10","PSA","102","10","11","Fæða mín er aska, ekki brauð, og drykkur minn blandast tárum mínum. Þú ert mér reiður Drottinn og hefur varpað mér burt frá þér. ");
INSERT INTO isl_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Líf mitt líður burt eins og kvöldskuggi. Ég visna eins og gras ");
INSERT INTO isl_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","en þú Drottinn ríkir í dýrð þinni að eilífu. Þinn orðstír mun lifa frá kynslóð til kynslóðar. ");
INSERT INTO isl_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Ég veit að þú munt koma og vægja Jerúsalem. – Gerðu það núna! – Efndu loforð þitt um hjálp. ");
INSERT INTO isl_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","Því að þjóð þín elskar hvern stein í múr hennar og jafnvel rykið á strætum hennar. ");
INSERT INTO isl_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","Þjóðirnar og konungar þeirra skjálfi fyrir Drottni og hans miklu dýrð, ");
INSERT INTO isl_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","því að Drottinn mun endurreisa Jerúsalem og birtast þar í dýrð! ");
INSERT INTO isl_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Hann hlustar á bænir fátæklinganna, gefur gaum að beiðni þeirra. ");
INSERT INTO isl_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","Þetta hef ég skráð til þess að komandi kynslóðir lofi Drottin fyrir öll hans verk. Fólk sem enn hefur ekki séð dagsins ljós mun vegsama hann. ");
INSERT INTO isl_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","Segið þeim að Drottinn leit niður frá musteri sínu á himnum. ");
INSERT INTO isl_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","21","Hann heyrði stunur þjóðar sinnar í ánauðinni – hún var dauðans matur – og hann frelsaði hana! ");
INSERT INTO isl_vpl VALUES ("PS102_22","020_102_22","PSA","102","22","23","Þess vegna streyma þúsundir til musteris hans í Jerúsalem og lofa hann og vegsama um alla borgina. Konungar jarðarinnar eru í þeim hópi. ");
INSERT INTO isl_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","Hann hefur tekið frá mér lífskraftinn og stytt ævi mína. ");
INSERT INTO isl_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","En ég hrópaði til hans: „Þú, Guð sem lifir að eilífu, láttu mig ekki deyja fyrir aldur fram! ");
INSERT INTO isl_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","Í upphafi lagðir þú undirstöður jarðarinnar og himnarnir eru verk handa þinna. ");
INSERT INTO isl_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","Þau munu hverfa en þú ert að eilífu. Þau fyrnast, líkt og slitin föt sem lögð eru til hliðar. ");
INSERT INTO isl_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","En þú ert hinn sami og ár þín taka aldrei enda. ");
INSERT INTO isl_vpl VALUES ("PS102_29","020_102_29","PSA","102","29","29","En afkomendur okkar munu lifa og þú munt varðveita þá, kynslóð fram af kynslóð.“ ");
INSERT INTO isl_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","Ég vil lofa Guð af öllu hjarta. ");
INSERT INTO isl_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Ég vil vegsama Drottin og minnast allra velgjörða hans við mig. ");
INSERT INTO isl_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Hann fyrirgefur syndir mínar. Hann læknar mig. ");
INSERT INTO isl_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Hann frelsar mig frá dauða. Hann umlykur mig náð og miskunn. ");
INSERT INTO isl_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Hann hleður á mig gjöfum! Hann endurnýjar lífsþrótt minn og gerir mig sterkan sem örn. ");
INSERT INTO isl_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Hann réttir hlut þeirra sem misrétti þola. ");
INSERT INTO isl_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Hann opinberaði Móse vilja sinn og hver hann væri og einnig þjóð sinni Ísrael. ");
INSERT INTO isl_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Hann er miskunnsamur og mildur við þá sem eiga það ekki skilið. Hann er seinn til reiði og fullur náðar og kærleika. ");
INSERT INTO isl_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Hann er ekki langrækinn né eilíflega reiður. ");
INSERT INTO isl_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Hann hefur ekki refsað okkur fyrir syndir okkar eins og sanngjarnt var ");
INSERT INTO isl_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","því að miskunn hans við þá sem óttast hann og heiðra, er eins há og himinninn er yfir jörðinni. ");
INSERT INTO isl_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Hann fleygði burt syndum okkar og það langt, já, eins langt og austrið er frá vestrinu! ");
INSERT INTO isl_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Eins og faðir miskunnar börnum sínum, eins hefur Drottinn miskunnað þeim sem óttast hann, ");
INSERT INTO isl_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","því hann veit að við erum bara dauðlegir menn ");
INSERT INTO isl_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","og að ævi okkar er stutt og líður hratt. Við erum eins og jurt sem vex og blómgast ");
INSERT INTO isl_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","en skrælnar fyrr en varir í brennheitum vindinum, deyr og gleymist. ");
INSERT INTO isl_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","18","En miskunn Drottins endist að eilífu fyrir þá sem reiða sig á orð hans og óttast hann. Og hjálpræði hans nær til barnabarnanna ef við höldum sáttmála hans og hlýðum boðum hans. ");
INSERT INTO isl_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Drottinn hefur reist sér hásæti á himnum og þaðan stjórnar hann heiminum. ");
INSERT INTO isl_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Lofið Drottin, þið voldugu englar sem framkvæmið skipanir hans og takið við fyrirmælum hans. ");
INSERT INTO isl_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Lofið Drottin, þið hersveitir englanna sem framfylgið vilja hans. ");
INSERT INTO isl_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Öll verk Drottins, um víða veröld, lofa hann! Einnig ég vil lofa hann! ");
INSERT INTO isl_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","2","Ég lofa Drottin! Drottinn, þú Guð minn, þú ert undursamlegur! Þú ert íklæddur hátign og dýrð og umlukinn ljósi! Þú þandir út himininn eins og dúk og dreifðir um hann stjörnunum. ");
INSERT INTO isl_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","Þú mótaðir þurrlendið og rýmdir fyrir hafinu. Þú gerðir ský að vagni þínum og ferð um á vængjum vindarins. ");
INSERT INTO isl_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Englarnir eru erindrekar þínir og eldslogar þjóna þér. ");
INSERT INTO isl_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Undirstöður heimsins eru traustar, þær eru þitt verk, og þess vegna haggast hann ekki. ");
INSERT INTO isl_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Þú lést vatnsflóð ganga yfir jörðina og hylja fjöllin. ");
INSERT INTO isl_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","8","Og þegar þú bauðst, safnaðist vatnið saman í höfunum, fjöllin risu og dalirnir urðu til. ");
INSERT INTO isl_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Þú settir sjónum sín ákveðnu mörk svo að hann skyldi aldrei aftur flæða yfir þurrlendið. ");
INSERT INTO isl_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Þú settir lindir í dalina og lækir renna um fjöllin. ");
INSERT INTO isl_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Þeir eru dýrunum til drykkjar og þar svalar villiasninn þorsta sínum. ");
INSERT INTO isl_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Þar gera fuglar sér hreiður og söngur þeirra ómar frá trjánum. ");
INSERT INTO isl_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","Hann sendir regn yfir fjöllin svo að jörðin ber sinn ávöxt. ");
INSERT INTO isl_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Safaríkt grasið vex að boði hans og er búfénu til fæðu. En maðurinn yrkir jörðina, ræktar ávexti, grænmeti og korn, ");
INSERT INTO isl_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","einnig vín sér til gleði, olíu sem gerir andlitið gljáandi og brauð sem gefur kraft. ");
INSERT INTO isl_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Drottinn gróðursetti sedrustrén í Líbanon, há og tignarleg, ");
INSERT INTO isl_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","og þar byggja fuglarnir sér hreiður, en storkurinn velur kýprustréð til bústaðar. ");
INSERT INTO isl_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Steingeiturnar kjósa hin háu fjöll, en stökkhérarnir finna sér stað í klettum. ");
INSERT INTO isl_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Tunglið settir þú til að afmarka mánuði, en sólina til að skína um daga. ");
INSERT INTO isl_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Myrkur og nótt eru frá þér komin, þá fara skógardýrin á kreik. ");
INSERT INTO isl_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Þá öskra ljónin eftir bráð og heimta æti sitt af Guði. ");
INSERT INTO isl_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Þegar sólin rís draga þau sig í hlé og leggjast í fylgsni sín, ");
INSERT INTO isl_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","en mennirnir ganga út til starfa og vinna allt til kvölds. ");
INSERT INTO isl_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","Drottinn, hvílík fjölbreytni í öllu því sem þú hefur skapað! Allt á það upphaf sitt í vísdómi þínum! Jörðin er full af því sem þú hefur gert! ");
INSERT INTO isl_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Framundan mér teygir sig blikandi haf, iðandi af alls konar lífi! ");
INSERT INTO isl_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Og sjá! Þarna eru skipin! Og þarna hvalirnir! – þeir leika á alls oddi! ");
INSERT INTO isl_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Allar skepnur vona á þig, að þú gefir þeim fæðu þeirra á réttum tíma. ");
INSERT INTO isl_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Þú mætir þörfum þeirra og þau mettast ríkulega af gæðum þínum. ");
INSERT INTO isl_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","En snúir þú við þeim bakinu er úti um þau. Þegar þú ákveður, deyja þau og verða að mold, ");
INSERT INTO isl_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","en þú sendir líka út anda þinn og vekur nýtt líf á jörðinni. ");
INSERT INTO isl_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Lof sé Guði að eilífu! Drottinn gleðst yfir verkum sínum! ");
INSERT INTO isl_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Þegar hann lítur á jörðina, skelfur hún og eldfjöllin gjósa við snertingu fingra hans. ");
INSERT INTO isl_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Ég vil lofsyngja Drottni svo lengi sem ég lifi, vegsama Guð á meðan ég er til! ");
INSERT INTO isl_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Ó, að ljóð þetta mætti gleðja hann, því að Drottinn er gleði mín og fögnuður. ");
INSERT INTO isl_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Ó, að misgjörðarmenn hyrfu af jörðinni og að óguðlegir yrðu ekki framar til. En Drottin vil ég vegsama að eilífu! Hallelúja! ");
INSERT INTO isl_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","Þakkið Drottni fyrir öll hans undursamlegu verk og segið frá þeim meðal þjóðanna. ");
INSERT INTO isl_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Syngið fyrir hann, leikið fyrir hann og segið öllum frá máttarverkum hans. ");
INSERT INTO isl_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Lofið og vegsamið hans heilaga nafn. Þið sem tilbiðjið Drottin, fagnið! ");
INSERT INTO isl_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Leitið hans og máttar hans, og keppið eftir að kynnast honum! ");
INSERT INTO isl_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","6","Minnist dásemdarverkanna sem hann vann fyrir okkur, sína útvöldu þjóð, afkomendur Abrahams og Jakobs, þjóna hans. Munið þið hvernig hann útrýmdi óvinum okkar? ");
INSERT INTO isl_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Hann er Drottinn, Guð okkar. Elska hans blasir við hvar sem er í landinu. ");
INSERT INTO isl_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","9","Þótt þúsund kynslóðir líði, þá gleymir hann ekki loforði sínu, sáttmála sínum við Abraham og Ísak. ");
INSERT INTO isl_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","11","Þennan sáttmála endurnýjaði hann við Jakob. Þetta er hans eilífi sáttmáli við Ísrael: „Ég mun gefa ykkur Kanaansland að erfð.“ ");
INSERT INTO isl_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Þetta sagði hann meðan þeir voru enn fámennir, já mjög fáir, og bjuggu sem útlendingar í landinu. ");
INSERT INTO isl_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","Síðar dreifðust þeir meðal þjóðanna og hröktust úr einu landinu í annað. ");
INSERT INTO isl_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","Samt leyfði hann engum að kúga þá og refsaði konungum sem það reyndu. ");
INSERT INTO isl_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","„Snertið ekki við mínum útvöldu og gerið spámönnum mínum ekkert mein.“ sagði hann. ");
INSERT INTO isl_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Og hann lét hungursneyð koma yfir Kanaansland og allur matur gekk til þurrðar. ");
INSERT INTO isl_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","Þá sendi hann Jósef í ánauð til Egyptalands, þjóð sinni til bjargar. ");
INSERT INTO isl_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Þeir hlekkjuðu hann og þjáðu, ");
INSERT INTO isl_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","en Guð lét hann þola eldraunina og batt að lokum enda á fangavist hans. ");
INSERT INTO isl_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Og faraó sendi eftir Jósef og lét hann lausan, ");
INSERT INTO isl_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","og setti hann svo yfir allar eigur sínar. ");
INSERT INTO isl_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","Þá hafði Jósef vald til að fangelsa höfðingja og segja ráðgjöfum konungs til. ");
INSERT INTO isl_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Síðar kom Jakob (Ísrael) til Egyptalands og settist þar að með sonum sínum. ");
INSERT INTO isl_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","Þau ár fjölgaði Ísrael mjög, já svo mjög að þeir urðu fjölmennari en Egyptar, sem réðu landinu. ");
INSERT INTO isl_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","En Guð sneri hjörtum Egypta gegn Ísrael, þeir hötuðu þá og hnepptu í þrældóm. ");
INSERT INTO isl_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Þá útvaldi Guð Móse sem fulltrúa sinn og Aron honum til hjálpar. ");
INSERT INTO isl_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","Hann gjörði tákn meðal Egypta og vakti þannig ótta hjá þeim. ");
INSERT INTO isl_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Þeir fóru að skipun Drottins og hann sendi myrkur yfir landið, ");
INSERT INTO isl_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","breytti ám og vötnum í blóð svo að fiskurinn dó. ");
INSERT INTO isl_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Þá kom flóðbylgja af froskum – þeir voru um allt, jafnvel í svefnherbergi konungs! ");
INSERT INTO isl_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Að skipun Móse fylltist landið af mývargi og flugum. ");
INSERT INTO isl_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Í stað regns dundi banvænt hagl yfir landið og eldingar skelfdu íbúana. ");
INSERT INTO isl_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","Vínviður þeirra og fíkjutré drápust, féllu brotin til jarðar. ");
INSERT INTO isl_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Þá bauð hann engisprettum að naga allan grænan gróður ");
INSERT INTO isl_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","og eyðileggja uppskeruna, – hvílík plága! ");
INSERT INTO isl_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Þá deyddi hann frumburðina, – elsta barn í hverri egypskri fjölskyldu – þar fór framtíðarvonin. ");
INSERT INTO isl_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Og Drottinn leiddi sitt fólk heilu og höldnu út úr Egyptalandi, hlaðið gulli og silfri. Ekkert þeirra var veikt eða vanmáttugt. ");
INSERT INTO isl_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Og Egyptar voru því fegnastir þegar Ísraelsmenn héldu á brott, því að þeir óttuðust þá. ");
INSERT INTO isl_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Um daga breiddi Guð út ský og hlífði þeim gegn brennheitri sólinni og um nætur lýsti hann þeim leiðina með eldstólpa. ");
INSERT INTO isl_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Þeir báðu um kjöt og hann sendi þeim lynghænsni og brauð gaf hann þeim – manna, brauð frá himni. ");
INSERT INTO isl_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Hann opnaði klettinn og vatnið spratt fram og varð að læk í eyðimörkinni. ");
INSERT INTO isl_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Hann minntist loforðs síns til Abrahams, þjóns síns, ");
INSERT INTO isl_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","og leiddi sitt útvalda fólk fagnandi út úr Egyptalandi. ");
INSERT INTO isl_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","Og hann gaf þeim lönd heiðingjanna, sem stóðu í fullum blóma með þroskaða uppskeru og þeir átu það sem aðrir höfðu sáð til. ");
INSERT INTO isl_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","Allt skyldi þetta hvetja Ísrael til trúfesti og hlýðni við lög Drottins. Hallelúja! ");
INSERT INTO isl_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","Hallelúja! Drottinn, þökk sé þér því að þú ert góður! Elska þín varir að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","Hver getur talið upp öll máttarverk Guðs og hver getur lofað hann eins og rétt er og skylt? Enginn! ");
INSERT INTO isl_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Sæll er sá réttláti sem gerir nágrönnum sínum gott. ");
INSERT INTO isl_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","Drottinn, þegar þú blessar og bjargar fólki þínu, minnstu þá einnig mín. ");
INSERT INTO isl_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","Gefðu mér hlut í velgengni þinna útvöldu, að fá að gleðjast með þeim og deila með þeim hjálp þinni. ");
INSERT INTO isl_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Bæði við og feður okkar höfum margvíslega syndgað. ");
INSERT INTO isl_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Máttarverk þín í Egyptalandi mátu þeir lítils og fljótlega gleymdu þeir góðverkum þínum og risu gegn þér við hafið hið rauða. ");
INSERT INTO isl_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","En samt frelsaðir þú þá, hélst uppi heiðri nafns þíns og sýndir mátt þinn. ");
INSERT INTO isl_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","Þú klaufst hafið, lagðir þurran veg um botn þess og leiddir þá þar í gegn. ");
INSERT INTO isl_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","Þannig frelsaðir þú þá frá óvinum þeirra. ");
INSERT INTO isl_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","Síðan féll sjórinn aftur í farveg sinn og óvinir þeirra fórust – ekki einn komst af! ");
INSERT INTO isl_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Þá loks trúðu þeir Drottni og sungu honum lofsöng. ");
INSERT INTO isl_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","En þeir voru fljótir að gleyma honum á ný! Þeir treystu ekki orðum hans ");
INSERT INTO isl_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","en heimtuðu sífellt meira og meira og reyndu eins og þeir gátu á þolinmæði Guðs. ");
INSERT INTO isl_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","Og hann lét að vilja þeirra, en þó ekki að öllu leyti. ");
INSERT INTO isl_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","Þeir gerðu uppreisn gegn Móse og líka Aron, manninn sem Guð hafði valið til prests. ");
INSERT INTO isl_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","Þá opnaðist jörðin og gleypti Datan og flokk Abírams. ");
INSERT INTO isl_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","Eldur féll af himni og eyddi illmennum þessum. ");
INSERT INTO isl_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","20","Þeir gerðu sér líkneski af nauti, sem étur gras, og tilbáðu það í stað hins dýrlega Guðs! ");
INSERT INTO isl_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","22","Þannig óvirtu þeir Guð, frelsara sinn, sem gert hafði undur og tákn í Egyptalandi og við hafið rauða. ");
INSERT INTO isl_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Þess vegna áformaði Guð að eyða þeim öllum. En Móse, hans útvaldi þjónn, tók sér stöðu milli fólksins og Guðs og bað hann að láta af reiði sinni og tortíma þeim ekki. ");
INSERT INTO isl_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","Og ekki vildu þeir inn í fyrirheitna landið, þeir treystu ekki að Guð mundi vernda þá. ");
INSERT INTO isl_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","Þeir kvörtuðu í tjöldum sínum og fyrirlitu skipun hans. ");
INSERT INTO isl_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","Þá ákvað hann að láta þá deyja í eyðimörkinni, ");
INSERT INTO isl_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","tvístra afkomendum þeirra meðal þjóðanna og herleiða þá til annarra landa. ");
INSERT INTO isl_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Og hjá Peór gengu forfeður okkar í lið með fylgjendum Baals og báru fram fórnir til dauðra skurðgoða. ");
INSERT INTO isl_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Það reitti Drottin til reiði og þess vegna braust út plága meðal þeirra. ");
INSERT INTO isl_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Hún hélst þar til Pínehas gekk fram og refsaði þeim sem henni höfðu valdið. ");
INSERT INTO isl_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","Hans verður ætíð minnst fyrir það réttlætisverk. ");
INSERT INTO isl_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","Hjá Meríba reitti Ísrael Drottin aftur til reiði og olli Móse miklum vanda, ");
INSERT INTO isl_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","– hann reiddist og talaði ógætileg orð. ");
INSERT INTO isl_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","Og ekki útrýmdi Ísrael þjóðunum sem fyrir voru í landinu, eins og Guð hafði skipað þeim, ");
INSERT INTO isl_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","heldur blönduðust þeir heiðingjunum og tóku upp ósiði þeirra. ");
INSERT INTO isl_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","Þeir færðu skurðgoðum þeirra fórnir og leiddust burt frá Guði. ");
INSERT INTO isl_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","38","Þeir fórnuðu jafnvel börnum sínum til illra anda – til hjáguða Kanverja – úthelltu saklausu blóði og vanhelguðu landið með morðum. ");
INSERT INTO isl_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","Þeir saurguðust af illverkum þessum, því að með hjáguðadýrkun sinni rufu þeir trúnað við Guð. ");
INSERT INTO isl_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Vegna alls þessa reiddist Drottinn Ísrael, lýð sínum, og fékk viðbjóð á honum, ");
INSERT INTO isl_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","42","og lét hann heiðnar þjóðir drottna yfir honum. Ísrael var stjórnað af óvinum sínum og þeir kúguðu hann. ");
INSERT INTO isl_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Aftur og aftur leysti hann þá undan okinu, en þeir héldu áfram að óhlýðnast honum, uns syndir þeirra komu þeim á kné. ");
INSERT INTO isl_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","Samt bænheyrði hann þá og linaði þjáningar þeirra. ");
INSERT INTO isl_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","Hann minntist loforðsins sem hann gaf þeim og aumkaðist yfir þá í elsku sinni, ");
INSERT INTO isl_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","svo að jafnvel þeir sem kúguðu þá, sýndu þeim miskunn. ");
INSERT INTO isl_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","Ó, frelsaðu okkur, Drottinn Guð! Safnaðu okkur saman frá þjóðunum svo að við getum sameiginlega þakkað þér og lofað nafn þitt. ");
INSERT INTO isl_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","Lofaður sé Drottinn, Guð Ísraels, frá eilífð til eilífðar. Og allt fólkið segi: „Amen!“ Hallelúja. ");
INSERT INTO isl_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","Þakkið Drottni, því að hann er góður og miskunn hans varir að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Hafi Drottinn frelsað þig, þá segðu frá því! Segðu öðrum frá því að hann hafi frelsað þig frá óvinum þínum. ");
INSERT INTO isl_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","Hann leiddi hina útlægu heim frá ystu endimörkum jarðarinnar. ");
INSERT INTO isl_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Þeir ráfuðu heimilislausir um eyðimörkina, ");
INSERT INTO isl_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","hungraðir og þyrstir og að niðurlotum komnir. ");
INSERT INTO isl_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","„Drottinn, hjálpaðu okkur!“ hrópuðu þeir, og hann svaraði bæn þeirra! ");
INSERT INTO isl_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","Hann leiddi þá í öruggt skjól, til byggilegrar borgar. ");
INSERT INTO isl_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","Ó, að þetta fólk vildi nú lofa Drottin fyrir miskunn hans og öll hans dásamlegu verk, ");
INSERT INTO isl_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","því að hann svalar þyrstri sál og mettar hungraðan gæðum. ");
INSERT INTO isl_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Hverjir eru þessir sem sitja í myrkri og skugga dauðans, þjáðir af eymd og volæði? ");
INSERT INTO isl_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","Þeir gerðu uppreisn gegn Drottni, fyrirlitu hann, hinn hæsta Guð. ");
INSERT INTO isl_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Þess vegna beygði hann þá með mæðu. Þeir hrösuðu og enginn gat hjálpað þeim á fætur. ");
INSERT INTO isl_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Þá hrópuðu þeir til Drottins í neyð sinni og hann bjargaði þeim! ");
INSERT INTO isl_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","Hann leiddi þá út úr myrkri og skugga dauðans og braut fjötra þeirra. ");
INSERT INTO isl_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","Þeir skulu lofa Drottin fyrir elsku hans og öll hans miskunnarverk! ");
INSERT INTO isl_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","Því að hann mölvaði hlið dýflissunnar og braut sundur rimlana. ");
INSERT INTO isl_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Sumir kölluðu yfir sig ógæfu með heimsku sinni. ");
INSERT INTO isl_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Loks bauð þeim við öllum mat. Þeir sáu ekkert framundan nema dauðann. ");
INSERT INTO isl_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Þá kölluðu þeir til Drottins í neyð sinni og hann bjargaði þeim úr angist þeirra, kom þeim á réttan veg. ");
INSERT INTO isl_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","Hann sendi út orð sitt og læknaði þá, hreif þá frá dyrum dauðans. ");
INSERT INTO isl_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","Ó, að menn þessir vildu lofa Drottin fyrir elsku hans og öll hans dásemdarverk! ");
INSERT INTO isl_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Þeir þakki honum heilshugar og kunngjöri verk hans með gleði. ");
INSERT INTO isl_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Og svo eru þeir sem sigla um höfin, kaupmenn sem flytja vörur milli landa. ");
INSERT INTO isl_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","Einnig þeir fá að reyna máttarverk Drottins. ");
INSERT INTO isl_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Hann kallar á storminn og lætur öldurnar rísa. ");
INSERT INTO isl_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","Skipin sveiflast til himins og hverfa í öldudali – öllum um borð fellst hugur í neyðinni. ");
INSERT INTO isl_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Þeir ramba og skjögra eins og drukknir menn og vita ekki sitt rjúkandi ráð. ");
INSERT INTO isl_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Þá hrópa þeir til Drottins í neyð sinni og hann frelsar þá. ");
INSERT INTO isl_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","Hann kyrrir bæði sjó og vind. ");
INSERT INTO isl_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Hvílík blessun að ná höfn og njóta lognsins! ");
INSERT INTO isl_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","Ó, að þessir menn vildu þakka Drottni miskunn hans og öll hans dásemdarverk. ");
INSERT INTO isl_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Þeir lofi hann upphátt í söfnuðinum og í áheyrn leiðtoga Ísraels. ");
INSERT INTO isl_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Hann þurrkar upp fljótin ");
INSERT INTO isl_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","og gerir land óguðlegra að skorpinni saltsléttu. ");
INSERT INTO isl_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","En hann kann líka að breyta auðninni í frjósama og vatnsríka vin. ");
INSERT INTO isl_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","Þangað leiðir hann hungraða sem setjast þar að og byggja sér borgir, ");
INSERT INTO isl_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","sá í akra, gróðursetja víngarða og afla afurða. ");
INSERT INTO isl_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Þannig blessar hann! Og þeir margfaldast stórum og fénaði þeirra fjölgar. ");
INSERT INTO isl_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Sumir missa allt í ofsókn, þjáningu og sorg, ");
INSERT INTO isl_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","því að Guð sendir hrokafullum skömm og lætur tignarmenn ráfa um í rústum, ");
INSERT INTO isl_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","en hann bjargar fátæklingum sem honum treysta, gefur þeim fjölda afkomenda og mikla hagsæld. ");
INSERT INTO isl_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Þetta sjá hinir guðhræddu og þeir gleðjast, meðan óguðlegir þegja í skömm. ");
INSERT INTO isl_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Þú sem ert vitur, hugleiddu þetta! Hugsaðu um miskunn og kærleika Drottins. ");
INSERT INTO isl_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","2","Ó, Guð, nú vil ég lofa þig! Ég vil syngja og fagna frammi fyrir þér. ");
INSERT INTO isl_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","Vaknaðu, harpa og gígja! Við viljum bjóða morgunroðann velkominn með söng! ");
INSERT INTO isl_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","Ég vil lofa þig um víða veröld, Drottinn, vegsama þig hjá hverri þjóð. ");
INSERT INTO isl_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","Því að miskunn þín nær til skýjanna og trúfesti þín er ómælanleg! ");
INSERT INTO isl_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","Láttu tign þína og mátt birtast og dýrð þína breiðast yfir jörðina. ");
INSERT INTO isl_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","Hlustaðu á ákall vina þinna og bjargaðu þeim með krafti þínum, já, bænheyrðu þá. ");
INSERT INTO isl_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Fögnum og gleðjumst því að við höfum fengið loforð frá Guði! Hann hefur lofað að gefa okkur Síkemland og Súkkótdal. ");
INSERT INTO isl_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","„Ég á Gíleað, ég á Manasse og Efraím er hjálmurinn á höfði mínu. Júda er veldissproti minn ");
INSERT INTO isl_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","en Móab og Edóm fyrirlít ég og yfir Filisteu æpi ég siguróp.“ ");
INSERT INTO isl_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","Hver nema Guð getur veitt mér styrk til að sigrast á víggirtum borgum? Hver nema hann getur opnað mér leið inn í Edóm? ");
INSERT INTO isl_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Drottinn, hefur þú útskúfað okkur? Hefur þú gert her okkar óvígan? ");
INSERT INTO isl_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Ó, veittu okkur lið gegn óvinum okkar, því að mannahjálp er gagnslaus. ");
INSERT INTO isl_vpl VALUES ("PS108_14","020_108_14","PSA","108","14","14","Með hjálp Guðs munum við vinna hetjudáð og hann mun gjörsigra óvini okkar. ");
INSERT INTO isl_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","Þú Guð sem ég lofa, vertu ekki þögull ");
INSERT INTO isl_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","því að óguðlegir baktala mig og ljúga á mig sökum. ");
INSERT INTO isl_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","Án saka hata þeir mig og ráðast á mig. ");
INSERT INTO isl_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","Ég elska þá, en jafnvel meðan ég bið fyrir þeim, ofsækja þeir mig. ");
INSERT INTO isl_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Þeir gjalda gott með illu og ást mína með hatri. ");
INSERT INTO isl_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","Leyfðu þeim að finna hvernig mér líður! Leyfðu óvini mínum að þola sama óréttlæti og hann beitir mig – vera dæmdur af ranglátum dómara. ");
INSERT INTO isl_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","Og þegar úrskurður fellur, lát hann þá verða honum til tjóns. Líttu á bænir hans eins og innantómt raus. ");
INSERT INTO isl_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","Styttu æviár hans. Skipaðu annan í embætti hans. ");
INSERT INTO isl_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","10","Börn hans verði föðurlaus og kona hans ekkja og rektu þau burt úr rústum heimilis þeirra. ");
INSERT INTO isl_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","Lánardrottnarnir taki landareign hans og ókunnugir fái allt sem hann hafði aflað. ");
INSERT INTO isl_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","13","Enginn sýni honum miskunn né aumki sig yfir föðurlausu börnin hans. Afkomendur hans verði afmáðir og ætt hans eins og hún leggur sig. ");
INSERT INTO isl_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","Refsaðu fyrir syndir föður hans og móður og dragðu ekki af. ");
INSERT INTO isl_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","Láttu misgjörðir hans aldrei falla í gleymsku, en minningu ættarinnar að engu verða. ");
INSERT INTO isl_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","Hann sýndi engum manni miskunn, en ofsótti nauðstadda og steypti aðþrengdum í dauðann. ");
INSERT INTO isl_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","Hann formælti öðrum, bölvunin komi honum sjálfum í koll. Að blessa lét hann ógert, blessun sé því fjarri honum. ");
INSERT INTO isl_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","Að bölva, það átti við hann, það var honum eðlilegt eins og að éta og drekka. ");
INSERT INTO isl_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","Formælingar hans bitni á honum sjálfum, hylji hann, eins og fötin sem hann er í og beltið um mitti hans. ");
INSERT INTO isl_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","Þetta séu laun andstæðinga minna frá Drottni – þeirra sem ljúga á mig og hóta mér dauða. ");
INSERT INTO isl_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","En Drottinn, farðu með mig eins og barnið þitt! Eins og þann sem ber þitt eigið nafn. Frelsaðu mig Drottinn, vegna elsku þinnar. ");
INSERT INTO isl_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","23","Það hallar undan fæti, ég finn að dauðinn nálgast. Ég er hristur til jarðar eins og padda af ermi! ");
INSERT INTO isl_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","Ég skelf í hnjánum – fastan var erfið, ég er ekkert nema skinn og bein. ");
INSERT INTO isl_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","Ég er eins og minnisvarði um mistök og þegar menn sjá mig hrista þeir höfuðið. ");
INSERT INTO isl_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","Hjálpaðu mér Drottinn Guð minn! Frelsaðu mig sakir elsku þinnar og kærleika. ");
INSERT INTO isl_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","Gerðu það svo að allir sjái, svo að enginn efist um að það var þitt verk, ");
INSERT INTO isl_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","– þá mega þeir formæla mér ef þeir vilja, sama er mér, aðeins að þú blessir mig. Þá munu illráð þeirra gegn mér mistakast og ég ganga mína leið, glaður í bragði. ");
INSERT INTO isl_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","Ónýttu áform þeirra! Sveipaðu þá skömm! ");
INSERT INTO isl_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","Þá mun ég ekki láta af að þakka Drottni, lofa hann í allra áheyrn. ");
INSERT INTO isl_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","Því að hann er athvarf fátækra og þeirra sem líða skort. Hann frelsar þá undan óvinum þeirra. ");
INSERT INTO isl_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Guð sagði við minn Drottin – við Krist: „Þú skalt ráða og ríkja mér við hlið. Ég mun sigra óvini þína og láta þá þjóna þér.“ ");
INSERT INTO isl_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Guð hefur reist þér hásæti í Jerúsalem og þaðan muntu drottna yfir óvinum þínum. ");
INSERT INTO isl_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Þegar konungsvald þitt verður lýðum ljóst, mun þjóð þín flýta sér á þinn fund og æskufólk þitt íklæðast helgum skrúða. Eins og döggin er ný á hverjum morgni, eins mun styrkur minn endurnýjast dag eftir dag. ");
INSERT INTO isl_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Guð hefur unnið mér eið – og hann iðrast þess ekki – að þú ert prestur að eilífu að hætti Melkísedeks. ");
INSERT INTO isl_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Guð er þér til hægri handar til að vernda þig. Þegar reiðidómur hans verður birtur mun hann fella marga konunga til jarðar. ");
INSERT INTO isl_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Hann mun refsa þjóðunum, lík þeirra munu liggja út um allt. Hann mun mölva höfuð þeirra. ");
INSERT INTO isl_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Á leiðinni drekkur hann úr lindinni við veginn og ber höfuðið hátt. ");
INSERT INTO isl_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","2","Hallelúja! Ég þakka Guði máttarverk hans, já, í áheyrn og augsýn allrar þjóðarinnar. Allir sem vilja, íhugi þetta ásamt mér. ");
INSERT INTO isl_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Því að máttarverkin lýsa mikilleika hans, hátign og eilífum kærleika. ");
INSERT INTO isl_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Hver getur gleymt dásemdarverkum hans, miskunn hans? ");
INSERT INTO isl_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Hann annast þarfir þeirra sem honum treysta og gleymir ekki loforðum sínum. ");
INSERT INTO isl_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Hann sýndi mátt sinn er hann gaf þjóð sinni landið Ísrael – land sem margar þjóðir byggðu. ");
INSERT INTO isl_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Allt gerir hann af trúfesti og réttlæti og öll fyrirmæli hans eru áreiðanleg og góð, ");
INSERT INTO isl_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","gefin í kærleika og af réttvísi – þau munu standa að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Hann hefur frelsað þjóð sína og gert við hana eilífan sáttmála. Heilagt og óttalegt er nafn Drottins. ");
INSERT INTO isl_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Hvernig öðlast menn visku? Með því fyrst að óttast og heiðra Guð og síðan með því að halda lög hans. Lofað sé nafn hans að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","Dýrð sé Guði! Að trúa á Guð og treysta honum veitir ómælda blessun. Sæll er sá maður sem hefur unun af boðorðum hans. ");
INSERT INTO isl_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Börn hans njóta hvarvetna heiðurs, því að góður arfur eflir göfugan mann. ");
INSERT INTO isl_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Sjálfur býr hann við auðlegð og góðverk hans gleymast ekki. ");
INSERT INTO isl_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Réttlátum er hann ljós í myrkri – miskunn hans og gæska eru augljós. ");
INSERT INTO isl_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Sá mun blessun hljóta sem er góðgjarn og fús að lána og framkvæmir verk sín með réttvísi. ");
INSERT INTO isl_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Slíkur maður verður ekki fórnarlamb illra atvika. Umhyggja Guðs fyrir honum verður umræðuefni þeirra sem þekkja hann. ");
INSERT INTO isl_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Hann óttast ekki vondar fréttir, né kvíðir því sem koma skal. Hann er öruggur og veit að Drottinn annast hann. ");
INSERT INTO isl_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Þess vegna óttast hann ekkert og horfir á óvini sína með stakri ró. ");
INSERT INTO isl_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Hann hefur miðlað mildilega og gefið fátækum. Góðverk hans munu ekki gleymast. Hann mun njóta vinsælda og hafa áhrif. ");
INSERT INTO isl_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Þetta sjá óguðlegir og þeim gremst. Þeir munu gnísta tönnum og tortímast og óskir þeirra rætast ekki. ");
INSERT INTO isl_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","Hallelúja! Þið þjónar Drottins, lofið nafn hans. ");
INSERT INTO isl_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","Lofað sé nafn hans um aldur og ævi! ");
INSERT INTO isl_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","Vegsamið hann frá sólarupprás til sólarlags! ");
INSERT INTO isl_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","Því að hann er hátt upphafinn yfir þjóðirnar og dýrð hans er himnunum hærri. ");
INSERT INTO isl_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Hver kemst í samjöfnuð við Guð hinn hæsta? ");
INSERT INTO isl_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","Hann situr hátt og horfir niður á himin og jörð. ");
INSERT INTO isl_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","Hann reisir hinn fátæka úr skítnum, leiðir hinn hungraða frá sorphaugnum ");
INSERT INTO isl_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","og fær þeim sæti með tignarmönnum! ");
INSERT INTO isl_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Fyrir hans hjálp verður hún hamingjusöm móðir – konan sem ekki gat fætt manni sínum börn. Hallelúja! Lof sé Drottni! ");
INSERT INTO isl_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","Í árdaga, þegar Ísraelsmenn flúðu Egyptaland, land hinnar framandi tungu, ");
INSERT INTO isl_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","varð Júda og Ísrael bústaður Guðs og ríki hans. ");
INSERT INTO isl_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","Hafið rauða sá þá koma og hopaði. Og áin Jórdan, hún stöðvaðist svo að þeir gátu gengið yfir. ");
INSERT INTO isl_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","Fjöllin hoppuðu eins og hrútar og hæðirnar sem lömb! ");
INSERT INTO isl_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","Hvað olli því, þú rauða haf, að þú hopaðir til beggja hliða? Og hvers vegna, áin Jórdan, stöðvaðist rennsli þitt? ");
INSERT INTO isl_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","Og þið fjöll, hvers vegna hoppið þið eins og hrútar og þið hæðir sem lömb? ");
INSERT INTO isl_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","Nötra þú jörð frammi fyrir augliti Drottins, Guðs Jakobs, ");
INSERT INTO isl_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","því að hann lét uppsprettu opnast á klettinum. ");
INSERT INTO isl_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Drottinn, gefðu ekki okkur, heldur þínu nafni dýrðina. Gefðu að allir vegsami þig vegna miskunnar þinnar og trúfesti. ");
INSERT INTO isl_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Hvers vegna leyfir þú heiðingjunum að segja: „Guð þeirra er ekki til!“ ");
INSERT INTO isl_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Guð er á himnum og hann gerir það sem hann vill. ");
INSERT INTO isl_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Guðir heiðingjanna eru mannaverk, smíðisgripir úr silfri og gulli. ");
INSERT INTO isl_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Þeir hvorki tala né sjá, en hafa þó bæði munn og augu! ");
INSERT INTO isl_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Þeir heyra ekki, finna enga lykt ");
INSERT INTO isl_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","og hreyfa hvorki legg né lið! Þeir geta ekki sagt eitt einasta orð! ");
INSERT INTO isl_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Smiðirnir sem þau gera og tilbiðja, eru engu gáfaðri en þau! ");
INSERT INTO isl_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","Ísrael, treystu Drottni! Hann er hjálpari þinn, hann er skjöldur þinn. ");
INSERT INTO isl_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","Þið prestar af Aronsætt, treystið Drottni! Hann er ykkar hjálp og hlíf. ");
INSERT INTO isl_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Þú lýður hans, þið öll, yngri sem eldri, treystið honum. Hann er hjálp og skjöldur. ");
INSERT INTO isl_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","Drottinn mun ekki gleyma okkur og hann blessar okkur öll. Hann blessar Ísraels fólk og prestana af Arons ætt, ");
INSERT INTO isl_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","já, alla, bæði háa og lága – þá sem óttast hann. ");
INSERT INTO isl_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","Drottinn blessi þig og börnin þín. ");
INSERT INTO isl_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","Drottinn, hann sem skapaði himin og jörð, mun blessa þig – já, þig! ");
INSERT INTO isl_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Himinninn tilheyrir Drottni, en jörðina gaf hann mönnunum. ");
INSERT INTO isl_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Ekki geta andaðir menn lofað Drottin hér á jörðu, ");
INSERT INTO isl_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","en það getum við! Við lofum hann að eilífu! Hallelúja! Lof sé Drottni! ");
INSERT INTO isl_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","Ég elska Drottin, því að hann heyrir bænir mínar – og svarar þeim. ");
INSERT INTO isl_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","Meðan ég dreg andann mun ég biðja til hans, því að hann lítur niður og hlustar á mig. ");
INSERT INTO isl_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Ég horfðist í augu við dauðann – var hræddur og hnípinn. ");
INSERT INTO isl_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Þá hvíslaði ég: „Drottinn, frelsaðu mig!“ ");
INSERT INTO isl_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Náðugur er Drottinn og góður er hann! ");
INSERT INTO isl_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","Drottinn hlífir vondaufum og styrkir hjálparvana. ");
INSERT INTO isl_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Nú get ég slakað á og verið rór, því að Drottinn hefur gert mikla hluti fyrir mig. ");
INSERT INTO isl_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","Hann hefur bjargað mér frá dauða, augum mínum frá gráti og fótum mínum frá hrösun. ");
INSERT INTO isl_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","Ég fæ að lifa! Já, lifa með honum hér á jörðu! ");
INSERT INTO isl_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","11","Þegar ég átti erfitt hugsaði ég: Þeir segja ósatt, að allt muni snúast mér í hag. ");
INSERT INTO isl_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","En nú, hvernig get ég nú endurgoldið Drottni góðverk hans við mig? ");
INSERT INTO isl_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Ég vil lyfta bikarnum og vínberjalegi að fórn, þakka honum lífið. ");
INSERT INTO isl_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","Fórnina sem ég lofaði Drottni, færi ég nú í allra augsýn. ");
INSERT INTO isl_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Hann elskar vini sína og lætur þá ekki deyja án gildrar ástæðu. ");
INSERT INTO isl_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","Drottinn, þú hefur leyst fjötra mína, því vil ég þjóna þér af öllu hjarta. ");
INSERT INTO isl_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Ég vil lofa þig og færa þér þakkarfórn. ");
INSERT INTO isl_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","19","Í forgörðum musteris Drottins í Jerúsalem vil ég – og það í augsýn allra – færa honum allt sem ég hafði lofað. Dýrð sé Drottni! ");
INSERT INTO isl_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Lofið Drottin allar þjóðir. Vegsamið hann allir lýðir. ");
INSERT INTO isl_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Miskunn hans er mikil og trúfesti hans varir að eilífu. Lofaður sé Drottinn! ");
INSERT INTO isl_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","Þakkið Drottni því að hann er góður! Elska hans varir að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Söfnuður Ísraels lofi hann og segi: „Elska hans varir að eilífu!“ ");
INSERT INTO isl_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Og prestar Arons taki undir og syngi: „Elska hans varir að eilífu!“ ");
INSERT INTO isl_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Og heiðingjarnir sem trú hafa tekið segi: „Elska hans varir að eilífu.“ ");
INSERT INTO isl_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","Í angist minni bað ég til Drottins. Hann svaraði mér og frelsaði mig. ");
INSERT INTO isl_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Ég er hans! Hvað skyldi ég þá óttast? Hvað geta dauðlegir menn gert mér? ");
INSERT INTO isl_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","Ég er vinur Drottins og hann hjálpar mér. Óvinir mínir skulu vara sig! ");
INSERT INTO isl_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Betra er að treysta Drottni, en að reiða sig á menn. ");
INSERT INTO isl_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","Öruggara er að leita hjálpar hans en stuðnings frá voldugum konungi! ");
INSERT INTO isl_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Þó óvinaþjóðirnar ráðist gegn mér, allar sem ein, þá mun ég ganga fram undir gunnfána hans og gjöreyða þeim. ");
INSERT INTO isl_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Já, þær umkringja mig og gera árás, en ég útrými þeim undir sigurmerki hans. ");
INSERT INTO isl_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Þær þyrpast að mér eins og flugnager, blossa gegn mér sem eyðandi eldur. En undir fána hans gjörsigra ég þá! ");
INSERT INTO isl_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Þú, óvinur minn, gerðir allt til að útrýma mér, en Drottinn kom mér til hjálpar. ");
INSERT INTO isl_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","Þegar orustan stóð sem hæst var hann styrkur minn og lofsöngur og að endingu veitti hann mér sigur. ");
INSERT INTO isl_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","16","Á heimilum réttlátra syngja menn fagnaðarljóð, enda nýkomnar fréttir af sigri! ");
INSERT INTO isl_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Ekki mun ég deyja, heldur lifa og segja öllum frá máttarverkum hans. ");
INSERT INTO isl_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Drottinn refsaði mér, en ofurseldi mig ekki dauðanum. ");
INSERT INTO isl_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Ljúkið upp hliðum musterisins – ég ætla að ganga inn og þakka Drottni. ");
INSERT INTO isl_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Um þessi hlið liggur leiðin til Drottins og réttlátir ganga þar inn. ");
INSERT INTO isl_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Ó, Drottinn, þökk sé þér að þú bænheyrðir og bjargaðir mér. ");
INSERT INTO isl_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Steinninn sem smiðirnir höfðu hafnað var gerður að hornsteini hússins! ");
INSERT INTO isl_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Það var að vilja og fyrir tilstilli Drottins og er í einu orði sagt stórkostlegt! ");
INSERT INTO isl_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Þetta er dagurinn sem Drottinn hefur gert. Fögnum og verum glöð í dag! ");
INSERT INTO isl_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","Ó, Drottinn, hjálpa þú. Frelsa þú okkur. Láttu okkur ná árangri. ");
INSERT INTO isl_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Blessaður sé sá sem er að koma, sá sem sendur er af Drottni. Við blessum þig frá helgidóminum. ");
INSERT INTO isl_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","28","Drottinn er ljósið sem lýsir okkur. Dansið fyrir honum, já, alla leiðina að altari hans. Hann er minn Guð, ég þakka honum og lofa hann. ");
INSERT INTO isl_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","Þakkið Drottni, því að hann er góður! Miskunn hans varir að eilífu! ");
INSERT INTO isl_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Sælir eru þeir sem breyta í öllu eftir lögum Guðs. ");
INSERT INTO isl_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","Sælir eru þeir sem leita Guðs og gera vilja hans í hvívetna, ");
INSERT INTO isl_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","þeir sem hafna málamiðlun við hið illa og ganga heilshugar á Guðs vegum. ");
INSERT INTO isl_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Þú, Drottinn, gafst okkur lög þín til þess að við hlýddum þeim ");
INSERT INTO isl_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","– ó, hve ég þrái að breyta grandvarlega eftir þeim. ");
INSERT INTO isl_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Þá verð ég ekki til skammar, heldur hef hreinan skjöld. ");
INSERT INTO isl_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Ég vil þakka þér leiðsögn þína og réttláta ögun, það hefur kennt mér að lifa lífinu rétt! ");
INSERT INTO isl_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Ég vil vera þér hlýðinn! Og þá veit ég að þú munt alls ekki yfirgefa mig. ");
INSERT INTO isl_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","Hvernig getur ungt fólk lifað hreinu lífi? Með því að hlusta á orð þín og fara eftir þeim. ");
INSERT INTO isl_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Ég leitaði þín af öllu hjarta – láttu mig ekki villast burt frá boðum þínum. ");
INSERT INTO isl_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Ég hef íhugað orð þín af kostgæfni og varðveitt þau í hjarta mínu svo að þau verndi mig frá því að syndga. ");
INSERT INTO isl_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","Lof sé þér Drottinn, kenndu mér lög þín. ");
INSERT INTO isl_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Ég fer með lög þín upphátt ");
INSERT INTO isl_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","– þau veita mér meiri gleði en mikil auðæfi. ");
INSERT INTO isl_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Ég vil íhuga þau og hafa þau í heiðri. ");
INSERT INTO isl_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Ég gleðst yfir þeim og gleymi þeim ekki. ");
INSERT INTO isl_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Leyfðu mér að lifa langa ævi, og læra að hlýða þér meir og meir. ");
INSERT INTO isl_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Opnaðu augu mín svo að ég sjái dásemdirnar í orði þínu. ");
INSERT INTO isl_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Ég er pílagrímur hér á jörðu – mikið vantar mig leiðsögn! Boðorð þín eru mér bæði leiðsögn og kort! ");
INSERT INTO isl_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Ég þrái fyrirmæli þín meira en orð fá lýst! ");
INSERT INTO isl_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Ávítaðu þá sem hafna boðum þínum. Þeir hafa kallað bölvun yfir sig. ");
INSERT INTO isl_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Láttu það ekki viðgangast að þeir spotti mig fyrir að hlýða þér. ");
INSERT INTO isl_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Jafnvel þjóðhöfðingjar hallmæla mér, en samt vil ég halda lög þín. ");
INSERT INTO isl_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Lögmál þitt er mér bæði ljós og leiðsögn. ");
INSERT INTO isl_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Ég er bugaður maður, alveg kominn á kné. Lífgaðu mig með orði þínu! ");
INSERT INTO isl_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Ég sagði þér áform mín og þú svaraðir mér. Skýrðu nú fyrir mér leiðsögn þína, ");
INSERT INTO isl_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","svo að ég skilji hvað þú vilt og upplifi dásemdir þínar. ");
INSERT INTO isl_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Ég græt af hryggð, hjarta mitt er bugað af sorg. Uppörvaðu mig og lífga með orðum þínum. ");
INSERT INTO isl_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","30","Leiddu mig burt frá öllu illu. Hjálpaðu mér, óverðugum, að hlýða lögum þínum, því að ég hef valið að gera rétt. ");
INSERT INTO isl_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","Ég held mér við boðorð þín og hlýði þeim vandlega. Drottinn, forðaðu mér frá öllu rugli. ");
INSERT INTO isl_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Ég vil kappkosta að fara eftir lögum þínum, því að þú hefur gert mig glaðan í sinni. ");
INSERT INTO isl_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","34","Segðu mér, Drottinn, hvað mér ber að gera og þá mun ég gera það. Ég vil hlýða þér af heilum hug svo lengi sem ég lifi. ");
INSERT INTO isl_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Ó, leiddu mig um réttan veg, – því hvað er betra en það?! ");
INSERT INTO isl_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Gefðu að ég hlýði reglum þínum, en leiti ekki eftir rangfengnum gróða. ");
INSERT INTO isl_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Snúðu huga mínum frá öllu öðru en því að fylgja þér. Lífgaðu mig, hresstu mig, svo að ég geti horft til þín. ");
INSERT INTO isl_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Minntu mig á það aftur og aftur að fyrirheit þín gilda fyrir mig! Já, ég treysti þér, heiðra þig og óttast! ");
INSERT INTO isl_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Þaggaðu niður háðið og spottið sem beint er að mér, því að lög þín eru góð og þeim fylgi ég. ");
INSERT INTO isl_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","Ég þrái að hlýða þeim. Þess vegna, Drottinn, lífgaðu mig við! ");
INSERT INTO isl_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","Þú lofaðir að frelsa mig! Miskunna mér nú í kærleika þínum, ");
INSERT INTO isl_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","og þá mun ég geta svarað þeim sem spotta mig, því að orðum þínum treysti ég. ");
INSERT INTO isl_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","Gef að ég gleymi aldrei orðum þínum og treysti alltaf þínum réttláta úrskurði. ");
INSERT INTO isl_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","46","Þess vegna vil ég hlýða þér um aldur og ævi og njóta þess frelsis sem lög þín veita. Ég mun fræða konunga um gildi þeirra og þeir munu hlusta af áhuga og virðingu. ");
INSERT INTO isl_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","Ég elska lög þín! Ég gleðst yfir boðum þínum! ");
INSERT INTO isl_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","„Komið, komið til mín!“ segi ég við þau; því að ég elska þau og þrái að íhuga þau. ");
INSERT INTO isl_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","50","Drottinn, gleymdu ekki fyrirheitum þeim sem þú gafst mér, þjóni þínum, – þau eru það sem ég treysti á. Þau eru styrkur minn þegar á móti blæs – þau hressa mig og lífga! ");
INSERT INTO isl_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","Ofstopamenn spotta mig fyrir hlýðni mína við Guð, en ég læt ekki haggast. ");
INSERT INTO isl_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","Allt frá því ég var barn hef ég leitast við að hlýða þér, orð þín hafa verið mér huggun. ");
INSERT INTO isl_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","Ég reiðist hinum óguðlegu, þeim sem hafna og fyrirlíta lög þín. ");
INSERT INTO isl_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","Því að þessi lög hafa verið uppspretta gleði minnar alla ævi. ");
INSERT INTO isl_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","Um nætur hugsa ég til þín Drottinn og minnist laga þinna. ");
INSERT INTO isl_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","Það hefur veitt mér mikla blessun að halda fyrirmæli þín. ");
INSERT INTO isl_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","Drottinn, þú ert minn og ég hef ákveðið að hlýða orðum þínum. ");
INSERT INTO isl_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","Ég þrái blessun þína af öllu hjarta. Miskunna mér eins og þú lofaðir mér. ");
INSERT INTO isl_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","60","Þegar ég sá að ég var á rangri leið, snéri ég við og flýtti mér aftur til þín. ");
INSERT INTO isl_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","Óguðlegir menn hafa reynt að tæla mig til syndar, en ég er staðráðinn í að hlýða lögum þínum. ");
INSERT INTO isl_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","Um miðnætti rís ég upp og þakka þér þín réttlátu ákvæði. ");
INSERT INTO isl_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","Sá er bróðir minn sem óttast og treystir Drottni og hlýðir orðum hans. ");
INSERT INTO isl_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","Ó, Drottinn, jörðin er full af miskunn þinni! Kenndu mér lög þín! ");
INSERT INTO isl_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","Drottinn, blessun þín umlykur mig, eins og þú hafðir lofað mér. ");
INSERT INTO isl_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Kenndu mér góð hyggindi og þekkingu, því að lög þín vísa mér veginn. ");
INSERT INTO isl_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Áður var ég reikull, þar til þú refsaðir mér, en nú hlýði ég þér með glöðu geði. ");
INSERT INTO isl_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","Þú ert góður og gerir aðeins gott, hjálpaðu mér að fylgja leiðsögn þinni. ");
INSERT INTO isl_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","Ofstopamenn hafa spunnið upp lygar um mig, en málið er, að ég hlýði lögum þínum af öllu hjarta. ");
INSERT INTO isl_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","Þeir eru tilfinningalausir, skilja ekkert, en ég elska þig og fylgi orðum þínum. ");
INSERT INTO isl_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","72","Hirting þín var það besta sem fyrir mig gat komið, því að hún beindi augum mínum að lögum þínum. Lög þín eru mér meira virði en hrúgur af gulli og silfri! ");
INSERT INTO isl_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","Þú, Drottinn, ert skapari minn, gefðu mér vit til að halda lög þín. ");
INSERT INTO isl_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","Allir þeir sem óttast og elska þig, taka mér vel, þeir sjá að einnig ég treysti orðum þínum. ");
INSERT INTO isl_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","77","Ég veit, Drottinn, að ákvarðanir þínar eru réttar og að úrskurðir þínir gerðu mér gott. Huggaðu mig með miskunn þinni, eins og þú lofaðir mér. Umvef mig náð þinni svo að ég haldi lífi. Lög þín eru unun mín. ");
INSERT INTO isl_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","Lát hina stoltu verða til skammar, þá sem beita mig brögðum. En ég vil íhuga fyrirmæli þín. ");
INSERT INTO isl_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","Láttu þá sem treysta þér, þá sem heiðra þig, koma til mín og við munum ræða lög þín. ");
INSERT INTO isl_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","Gefðu mér náð til að þóknast vilja þínum svo að ég verði aldrei til skammar. ");
INSERT INTO isl_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","Ég þrái hjálp þína af öllu hjarta! Þú lofaðir að hjálpa mér! ");
INSERT INTO isl_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","Ég einblíni á þig, bíð eftir því að sjá loforð þitt rætast. Hvenær ætlar þú að hugga mig með hjálp þinni? ");
INSERT INTO isl_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","Ég er eins og hrukkóttur vínbelgur, skorpinn af reyk, uppgefinn af að bíða. Samt held ég fast við lög þín og hlýði þeim. ");
INSERT INTO isl_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","Hve lengi verð ég að bíða þess að þú refsir ofsækjendum mínum? ");
INSERT INTO isl_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","86","Ofstopamenn sem hata sannleika þinn og lög hafa grafið mér gryfju. Lygi þeirra hefur komið mér í mikinn vanda. Þú elskar sannleikann, hjálpaðu mér! ");
INSERT INTO isl_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","Þeir höfðu næstum gert út af við mig, en ég neitaði að láta undan og óhlýðnast lögum þínum. ");
INSERT INTO isl_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","Láttu mig halda lífi sakir miskunnar þinnar og ég mun halda áfram að fara eftir boðum þínum. ");
INSERT INTO isl_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","Drottinn, á himnum stendur orð þitt óhaggað um eilífð. ");
INSERT INTO isl_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","91","Trúfesti þín nær frá kynslóð til kynslóðar, hún stendur óhögguð eins og jörðin sem þú hefur skapað. Hún varir samkvæmt orðum þínum. Allir hlutir lúta þér. ");
INSERT INTO isl_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","Ég hefði örvænt og farist ef lögmál þitt hefði ekki verið unun mín. ");
INSERT INTO isl_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","Ég mun aldrei yfirgefa lög þín, í þeim fann ég lífsgleði og góða heilsu. ");
INSERT INTO isl_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","Ég tilheyri þér! Ég bið þig, varðveittu mig! Ég vil breyta eftir orðum þínum. ");
INSERT INTO isl_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Óguðlegir bíða færis til að drepa, en ég íhuga loforð þín og reglur. ");
INSERT INTO isl_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Ekkert er fullkomið í þessum heimi nema eitt – orð þín. ");
INSERT INTO isl_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","Ég elska þau! Ég íhuga þau liðlangan daginn. ");
INSERT INTO isl_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Þau hafa gert mig vitrari en óvini mína, veitt mér leiðsögn gegnum lífið. ");
INSERT INTO isl_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Ég er orðinn hyggnari en allir kennarar mínir, því að ég íhuga reglur þínar, ");
INSERT INTO isl_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","skynsamari en öldungar, því að ég held fyrirmæli þín. ");
INSERT INTO isl_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Ég hef hafnað vegum illskunnar, því að ég vil vera hlýðinn orðum þínum. ");
INSERT INTO isl_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","103","Ekki hef ég snúið baki við fyrirmælum þínum; orð þín eru sætari en hunang! ");
INSERT INTO isl_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Orð þín ein veita mér skilning og vísdóm, er þá nokkur hissa þótt ég hati lygina? ");
INSERT INTO isl_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Þitt orð er lampi fóta minna, ljós á vegum mínum. Það forðar mér frá hrösun. ");
INSERT INTO isl_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Ég hef sagt það áður og segi enn: „Ég vil hlýða lögum þínum, þau eru yndisleg!“ ");
INSERT INTO isl_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","Óvinum mínum hefur næstum tekist að koma mér á kné, frelsaðu mig eins og þú lofaðir mér! ");
INSERT INTO isl_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","Hlustaðu á þakkargjörð mína og kenndu mér vilja þinn. ");
INSERT INTO isl_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Líf mitt hangir á bláþræði, samt vil ég ekki óhlýðnast boðum þínum. ");
INSERT INTO isl_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","Illmenni hafa lagt gildrur fyrir mig, en ég mun ekki víkja af þínum vegi. ");
INSERT INTO isl_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Lög þín eru það besta sem ég á! – Þau eru fjársjóður minn og endast mér að eilífu! ");
INSERT INTO isl_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Ég er ákveðinn í að hlýða þér allt þar til ég dey. ");
INSERT INTO isl_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","Þeir finnst mér andstyggilegir sem haltra til beggja hliða – þeir sem ófúsir eru að hlýða þér. Mitt val er klárt: Ég elska boðorð þín. ");
INSERT INTO isl_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","Þú ert skjól mitt og skjöldur og ég treysti orðum þínum. ");
INSERT INTO isl_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","Burt frá mér, þið illgjörðamenn! Reynið ekki að fá mig til að óhlýðnast boðorðum Guðs. ");
INSERT INTO isl_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Drottinn, þú lofaðir að halda í mér lífinu. Láttu engan geta sagt að þú hafir brugðist mér. ");
INSERT INTO isl_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","Hjálpaðu mér svo að ég megi frelsast og halda áfram að íhuga orðin þín. ");
INSERT INTO isl_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","Þú snýrð þér frá þeim sem afneita lögum þínum. Þeir verða sjálfum sér til skammar. ");
INSERT INTO isl_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","Illgjörðamennirnir eru eins og sorp í þínum augum. Ég vil ekki vera einn af þeim, og þess vegna elska ég þig og hlýði lögum þínum. ");
INSERT INTO isl_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","Ég skelf af hræðslu við þig; óttast að þú dæmir mig sekan. ");
INSERT INTO isl_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","Ofursel mig ekki duttlungum óvina minna, því að ég hef iðkað réttlæti og verið heiðarlegur í öllu. ");
INSERT INTO isl_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","Lofaðu mér einu: Að blessa mig! Láttu ekki hina hrokafullu kúga mig. ");
INSERT INTO isl_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","Ó, Drottinn, hvenær ætlar þú að efna loforð þitt og frelsa mig? ");
INSERT INTO isl_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Drottinn, gerðu við mig eftir gæsku þinni og kenndu mér, þjóni þínum, hlýðni. ");
INSERT INTO isl_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","Ég er þjónn þinn, gefðu mér því vit til að fara eftir reglum þínum í öllu sem ég geri. ");
INSERT INTO isl_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","Drottinn, láttu nú til skarar skríða! Þessi illmenni hafa brotið lög þín. ");
INSERT INTO isl_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","Ég elska boðorð þín meira en skíra gull! ");
INSERT INTO isl_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","Öll eru þau réttlát, boðorð Guðs, sama um hvað þau fjalla. Aðrar reglur vil ég ekki sjá. ");
INSERT INTO isl_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Lögmál þitt er yndislegt! Er einhver hissa á að ég vilji hlýða því? ");
INSERT INTO isl_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Þú útskýrir fyrir okkur orð þín og jafnvel einfeldningurinn skilur þau. ");
INSERT INTO isl_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","Orð þín vekja áhuga minn, ég hlusta á þau með opnum munni! ");
INSERT INTO isl_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Komdu og miskunnaðu mér, eins og öðrum þeim sem elska þig. ");
INSERT INTO isl_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Leiðbeindu mér með lögum þínum, svo að hið illa nái ekki tökum á mér. ");
INSERT INTO isl_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Bjargaðu mér úr klóm vondra manna svo að ég geti farið eftir fyrirmælum þínum. ");
INSERT INTO isl_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Líttu til mín í náð þinni og kenndu mér lög þín. ");
INSERT INTO isl_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Ég græt því að lög þín eru fótum troðin. ");
INSERT INTO isl_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","Drottinn, þú ert réttvís og refsing þín sanngjörn. ");
INSERT INTO isl_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","Skipanir þínar góðar og réttlátar. ");
INSERT INTO isl_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Ég er í uppnámi og reiðin sýður í mér, því að óvinir mínir hafa forsmáð lög þín. ");
INSERT INTO isl_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Ég hef séð að orð þín eru sönn og hrein, og þess vegna elska ég þau! ");
INSERT INTO isl_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Ég er lítilmótlegur og fyrirlitinn en boðorðum þínum hef ég ekki gleymt. ");
INSERT INTO isl_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","Réttlæti þitt varir að eilífu, og lög þín eru byggð á trúfesti. ");
INSERT INTO isl_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Boðorð þín eru huggun mín í andstreymi og neyð. ");
INSERT INTO isl_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","Lög þín eru réttlát í öllum greinum. Hjálpaðu mér að skilja þau svo að ég haldi lífi. ");
INSERT INTO isl_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","Ég ákalla þig af öllu hjarta! Bænheyrðu mig, Drottinn! Þá mun ég hlýða lögum þínum. ");
INSERT INTO isl_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","„Bjargaðu mér!“ hrópa ég, „svo að ég geti hlýtt þér.“ ");
INSERT INTO isl_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","Fyrir sólarupprás var ég á fótum, ég bað til þín og beið svars. ");
INSERT INTO isl_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","Já, ég vaki um nætur og íhuga fyrirheit þín. ");
INSERT INTO isl_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","Hlustaðu á bæn mína og miskunna mér, bjargaðu lífi mínu eins og þú hefur heitið mér. ");
INSERT INTO isl_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","Nú koma illmennin, nú gera þau árás! Orð þitt þekkja þeir ekki, nei alls ekki. ");
INSERT INTO isl_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","En þú Drottinn ert mér nærri, í trúfesti eru orð þín sögð. ");
INSERT INTO isl_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","Ég heyrði orð þín í bernsku og veit að þau breytast ekki. ");
INSERT INTO isl_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","Líttu á sorg mína og bjargaðu mér, því að boðum þínum hef ég hlýtt. ");
INSERT INTO isl_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","Já, frelsaðu mig frá dauða samkvæmt orði þínu. ");
INSERT INTO isl_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Óguðlegir munu ekki frelsast því að þeim er sama um boðorð þín. ");
INSERT INTO isl_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","Drottinn, mikil er miskunn þín, bjargaðu lífi mínu! ");
INSERT INTO isl_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","Margir eru óvinir mínir og fjendur, en frá reglum þínum hvika ég ekki. ");
INSERT INTO isl_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","Þarna eru svikararnir – mér býður við þeim! Þeim er alveg sama um orð þitt. ");
INSERT INTO isl_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","Drottinn, það skaltu vita, að ég elska boðorð þín. Miskunnaðu mér og leyfðu mér að halda lífi og heilsu. ");
INSERT INTO isl_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Trúfestin er rauði þráðurinn í orðum þínum og reglur þínar vara að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","Höfðingjar ofsækja mig án saka, hvað geri ég? – skoða lög þín með lotningu! ");
INSERT INTO isl_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","Ég fagna yfir lögum þínum eins fundnum fjársjóði. ");
INSERT INTO isl_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","Ég hata lygi og fals, en elska lög þín. ");
INSERT INTO isl_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Sjö sinnum á dag lofa ég þig vegna þinna réttlátu ákvæða. ");
INSERT INTO isl_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Þeir sem elska lögmál þitt eiga frið í hjarta og er ekki hætt við hrösun. ");
INSERT INTO isl_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","Drottinn, ég þrái hjálp þína og þess vegna hlýði ég boðum þínum. ");
INSERT INTO isl_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","168","Ég hef leitað og gætt boðorða þinna og elska þau af öllu hjarta. Þetta veistu, því að allt sem ég geri þekkir þú til fulls. ");
INSERT INTO isl_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","Drottinn, heyr þú hróp mitt og gefðu mér skilning á orði þínu. ");
INSERT INTO isl_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Hlusta á bænir mínar og frelsaðu mig eins og þú lofaðir mér. ");
INSERT INTO isl_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","Ég vegsama þig því að þú kenndir mér boðorð þín. ");
INSERT INTO isl_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","Efni þeirra er lofgjörð mín, öll eru þau réttlát. ");
INSERT INTO isl_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Veittu mér lið þegar ég þarfnast hjálpar, því að ég hef kosið að hlýða þér. ");
INSERT INTO isl_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","Ó, Drottinn, ég þrái hjálpræði þitt og lög þín elska ég! ");
INSERT INTO isl_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Láttu sál mína lifa svo að ég geti lofað þig og orð þín styðja mig á göngu lífsins. ");
INSERT INTO isl_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Ég villist eins og týndur sauður, leitaðu mín, því að boðorðum þínum hef ég ekki gleymt. ");
INSERT INTO isl_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","Ég ákalla Guð í neyð minni og hann hjálpar mér. ");
INSERT INTO isl_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","Drottinn, frelsaðu mig frá svikum og prettum. ");
INSERT INTO isl_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","Þú lygatunga, hver verða örlög þín? ");
INSERT INTO isl_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","Oddhvassar örvar munu stinga þig og glóandi kol brenna þig! ");
INSERT INTO isl_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","6","Hvílík mæða að búa með óguðlegum! Ég er þreyttur á þeim sem hata friðinn. ");
INSERT INTO isl_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","Ég þrái frið, en þeir elska stríð og láta ráð mín sem vind um eyrun þjóta. ");
INSERT INTO isl_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Ég horfi til fjallanna, þar sem Jerúsalem rís. Hvaðan skyldi ég fá hjálp? ");
INSERT INTO isl_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Hjálp mín kemur frá Drottni, skapara himins og jarðar! ");
INSERT INTO isl_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","4","Hann mun aldrei láta mig hrasa eða falla. Hann gætir mín öllum stundum og sefur ekki á verðinum. ");
INSERT INTO isl_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Sjálfur Drottinn gætir þín! Hugleiddu það! Hann verndar þig gegn öllu illu og er þér alltaf nær. ");
INSERT INTO isl_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Hann verndar þig jafnt daga sem nætur. ");
INSERT INTO isl_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Hann frelsar þig frá illu og heldur í þér lífinu. ");
INSERT INTO isl_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Hann hefur augun á þér hvort sem þú gengur út eða inn, já hann varðveitir þig alla daga og að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","Ég varð glaður þegar sagt var við mig: „Komdu! Förum í musterið, hús Drottins!“ ");
INSERT INTO isl_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","3","Við erum stödd í Jerúsalem og borgin er full af fólki. ");
INSERT INTO isl_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","Allur Ísrael – þjóð Drottins – er kominn til að tilbiðja og lofa Drottin samkvæmt reglu lögmálsins. ");
INSERT INTO isl_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","Sjáið! Þarna eru dómararnir í borgarhliðinu, þeir skera úr deilumálum fólksins. ");
INSERT INTO isl_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Biðjið þess að friður haldist í Jerúsalem og að þeir sem hana elska njóti heilla og hamingju. ");
INSERT INTO isl_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","Ég bið að friður ríki umhverfis þig og hagsæld sé í höllum þínum, ");
INSERT INTO isl_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","já, vegna bræðra minna og vina sem hér búa. ");
INSERT INTO isl_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","Ég bið um hamingju þér til handa, Jerúsalem, vegna musteris Drottins sem í þér er. ");
INSERT INTO isl_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","Ó, Guð, þú sem ríkir á himnum, ég hef augu mín til þín. ");
INSERT INTO isl_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","Við horfum til Drottins Guðs, þráum miskunn hans og náð, rétt eins og þjónninn mænir á húsbónda sinn og þernan á húsmóður sína. ");
INSERT INTO isl_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","4","Miskunna okkur, Drottinn, miskunna okkur. Við höfum fengið nóg af háði og spotti hinna hrokafullu. ");
INSERT INTO isl_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","Hefði það ekki verið Drottinn sem með okkur var þetta skulu allir í Ísrael játa – hefði það ekki verið Drottinn, ");
INSERT INTO isl_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","3","þá hefðu óvinirnir gleypt okkur lifandi, útrýmt okkur í heiftarreiði sinni. ");
INSERT INTO isl_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","5","Við hefðum skolast burt á augabragði, horfið í strauminn. ");
INSERT INTO isl_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","Lofaður sé Drottinn, hann bjargaði okkur úr klóm þeirra. ");
INSERT INTO isl_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Við sluppum eins og fugl úr snöru veiðimanns. Snaran gaf sig og við flugum burt! ");
INSERT INTO isl_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Hjálp okkar kemur frá Drottni sem skapaði himin og jörð. ");
INSERT INTO isl_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","Þeir sem treysta Drottni eru eins og Síonfjall, þeir haggast ekki. ");
INSERT INTO isl_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","Fjöllin umhverfis Jerúsalem eru henni til verndar, eins er Drottinn, hann umlykur og verndar sitt fólk. ");
INSERT INTO isl_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","Ekki skulu óguðlegir drottna yfir trúuðum, né réttlátir þvingaðir til illverka. ");
INSERT INTO isl_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","Ó, Drottinn, gerðu vel við þá sem góðir eru, þá sem leitast við að gera vilja þinn, en útrýmdu illgjörðamönnum. Láttu frið og velgengni ríkja í Ísrael. ");
INSERT INTO isl_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Þegar Drottinn flutti þjóð sína aftur til Jerúsalem, heim úr herleiðingunni, þá héldum við að okkur væri að dreyma! ");
INSERT INTO isl_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Við sungum og hlógum af gleði. Þá sögðu heiðnu þjóðirnar: „Drottinn hefur gert ótrúlega hluti fyrir þá!“ ");
INSERT INTO isl_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","Já, undursamlega hluti! Hvílíkt undur! Hvílík gleði! ");
INSERT INTO isl_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Hresstu okkur nú Drottinn, já gefðu okkur kröftuga gróðrarskúr! ");
INSERT INTO isl_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Þeir sem sá með tárum skulu uppskera með gleðisöng. ");
INSERT INTO isl_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Grátandi bera þeir sæðið til sáningar, en syngjandi koma þeir aftur og bera kornbindin heim! ");
INSERT INTO isl_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Ef hús er ekki byggt að ráði Drottins, erfiða smiðirnir til ónýtis. Ef Drottinn verndar ekki borgina, vaka verðirnir til einskis. ");
INSERT INTO isl_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Hvers vegna þrælar þú myrkranna á milli af ótta við skort? Veistu ekki að Guð vill að vinir hans fái þá hvíld sem þeir þarfnast? Á meðan þeir sofa, blessar hann þá með gjöfum. ");
INSERT INTO isl_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Börnin eru gjöf frá Guði, ávöxtur móðurkviðar og laun frá Drottni. ");
INSERT INTO isl_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Börn sem maður eignast ungur, eru eins og beittar örvar – þau koma síðar að gagni! Sæll er sá maður sem hefur fyllt örvamæli sinn með þeim! Hann mun ekki verða til skammar þegar hann þarf að útkljá deilumál við óvini sína! ");
INSERT INTO isl_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","Sæll er hver sá sem heiðrar Drottin, treystir honum og hlýðir. ");
INSERT INTO isl_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","Honum mun launað með velgengni og hamingju. ");
INSERT INTO isl_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","Kona hans hugsar vel um heimilið – og ekki mun þau skorta börn! Þarna sitja þau að matnum, þróttmikil og frísk eins og ung olífutré! ");
INSERT INTO isl_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Þannig launar Guð þeim sem elska hann og treysta honum. ");
INSERT INTO isl_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","Drottinn blessi þig frá musterinu á Síon. Alla þína ævidaga muntu gleðjast yfir velgengni Jerúsalem ");
INSERT INTO isl_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","og eignast marga afkomendur. Friður Guðs sé yfir Ísrael! ");
INSERT INTO isl_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","Allt frá bernsku var ég ofsóttur (það er Ísrael sem talar) ");
INSERT INTO isl_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","og misréttinu linnti ekki – en aldrei var ég þurrkaður út. Aldrei hefur óvinum mínum tekist að uppræta mig! ");
INSERT INTO isl_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","4","Þótt þeir húðstrýktu mig og tættu bak mitt, þá segi ég samt: „Drottinn er góður!“ Því að hann braut hlekkina sem illmennin höfðu fjötrað mig með. ");
INSERT INTO isl_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","Þeir sem hata Jerúsalem skulu verða til skammar og flýja. ");
INSERT INTO isl_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","7","Þeir skulu vera eins og gras á þaki – það skrælnar áður en það hefur vaxið og myndað fræ. Sláttumaðurinn mun grípa í tómt og sá sem bindur fær ekki neitt. ");
INSERT INTO isl_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","Þeir sem framhjá fara skulu ekki óska þér blessunar. En við ykkur segjum við: „Drottinn blessi þig!“ ");
INSERT INTO isl_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","Ó, Drottinn, ég er í nauðum staddur, heyrðu hróp mitt! ");
INSERT INTO isl_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","Hlustaðu á mig! Svaraðu og hjálpaðu mér! ");
INSERT INTO isl_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","4","Drottinn, ef þú rifjaðir sífellt upp syndir okkar, hver fengi þá staðist? En þú fyrirgefur! Getum við annað en óttast þig og elskað? ");
INSERT INTO isl_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Og þess vegna bið ég og vona og treysti hjálp Guðs, því að hann hefur lofað að hjálpa. ");
INSERT INTO isl_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","Næturverðirnir þrá nýjan dag, en ég þrái Drottin enn meira! ");
INSERT INTO isl_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","Ísrael, treystu Drottni því að hann er góður og miskunnsamur og veitir gnægð lausnar. ");
INSERT INTO isl_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","Hann mun sjálfur leysa Ísrael frá öllum misgjörðum hans. ");
INSERT INTO isl_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","Drottinn, ég er hvorki stoltur né hrokafullur. Ég álít sjálfan mig ekki betri en aðra. Ég læt ekki sem ég viti alla hluti. ");
INSERT INTO isl_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","Ég er hljóður fyrir Drottni, eins og barn sem vanið hefur verið af brjósti. Ég er hættur að suða og nauða. ");
INSERT INTO isl_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","Ísrael, ver þú hljóður og treystu Drottni, nú og ævinlega. ");
INSERT INTO isl_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","Manst þú, Drottinn, allar þjáningar Davíðs? ");
INSERT INTO isl_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","5","Hann náði ekki að hvílast, kom ekki dúr á auga. Þá kom honum í hug að reisa hús yfir örk þína, musteri fyrir hinn volduga í Ísrael. Og hann hét því að svo skyldi verða og sór hátíðlegan eið fyrir Drottni. ");
INSERT INTO isl_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Fyrst var örkin í Síló í Efrata og síðan í Jaar. ");
INSERT INTO isl_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","Nú fær hún stað í musterinu, bústað Guðs hér á jörð. Þar munum við falla fram og tilbiðja hann. ");
INSERT INTO isl_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","Rís þú upp, Drottinn! Gakktu inn í musteri þitt ásamt örk þinni, tákni máttar þíns! ");
INSERT INTO isl_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","Við munum íklæða prestana hvítum skrúða, klæðum hreinleikans. Og þjóðin mun hrópa fagnaðaróp! ");
INSERT INTO isl_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","Vísaðu Davíð þjóni þínum ekki frá – konunginum sem þú útvaldir handa þjóð þinni. ");
INSERT INTO isl_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","Þú lofaðir Davíð því að sonur hans yrði eftirmaður hans, skyldi erfa hásætið. Vissulega munt þú aldrei ganga á bak orða þinna! ");
INSERT INTO isl_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","Og annað fyrirheit gafstu Davíð líka: Ef afkomendur hans héldu ákvæði sáttmála þíns við þig, þá mundi konungdómurinn haldast í ætt Davíðs að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","Ó, Drottinn, þú hefur útvalið Jerúsalem að bústað þínum. ");
INSERT INTO isl_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","„Þetta er hvíldarstaður minn um aldur og ævi,“ sagðir þú, „staðurinn sem ég hef þráð. ");
INSERT INTO isl_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","Borg þessa vil ég blessa og auðga og fátæklingar hennar fá nóg að borða. ");
INSERT INTO isl_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","Presta hennar mun ég íklæða hjálpræði, og hinir trúuðu er þar búa munu hrópa fagnaðaróp. ");
INSERT INTO isl_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","Veldi Davíðs mun aukast, og ég mun gefa honum son, eftirmann í hásæti hans. ");
INSERT INTO isl_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","Ég hyl óvini hans skömm, en á honum skal kóróna hans ljóma.“ ");
INSERT INTO isl_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","Sjáið hve yndislegt það er þegar systkini búa saman í sátt og samlyndi! Vináttan er dýrmæt! ");
INSERT INTO isl_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","Hún er eins og ilmolían sem hellt var yfir höfuð Arons, rann niður skeggið og draup á kyrtil hans, ");
INSERT INTO isl_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","eins og áin Jórdan sem sprettur upp við Hermonfjall og vökvar Ísrael. Guð mun blessa Jerúsalem og veita þar líf að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","Já, lofið Drottin, þið sem vakið yfir musteri hans um nætur. ");
INSERT INTO isl_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","Lyftið höndum til helgidómsins og lofið Drottin. ");
INSERT INTO isl_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","Drottinn blessi þig frá Síon, hann sem skapaði himin og jörð. ");
INSERT INTO isl_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","2","Hallelúja! Lýður Drottins lofi hann í forgörðum musteris hans. ");
INSERT INTO isl_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","Lofið Drottin því að hann er góður, vegsamið hans dýrlega nafn. ");
INSERT INTO isl_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","Því að Drottinn hefur kosið Ísrael sér að eignarlýð. ");
INSERT INTO isl_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","Ég þekki mikilleik Drottins – að hann er öllum guðum æðri. ");
INSERT INTO isl_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","Það sem honum þóknast, það gerir hann á himni, á jörðu og einnig í hafdjúpunum! ");
INSERT INTO isl_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","Hann lætur skýin stíga upp af jörðinni og eldinguna leiftra svo að rigni; og vindana lætur hann blása úr forðabúrum sínum. ");
INSERT INTO isl_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","Hann laust frumburði Egyptalands, bæði menn og dýr. ");
INSERT INTO isl_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","Undur og tákn gerði hann í augsýn Faraó og þjóna hans. ");
INSERT INTO isl_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","Fjölmennar þjóðir lagði hann að velli, felldi volduga konunga ");
INSERT INTO isl_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","– Síhon, Amoríta-konung og Óg, konung í Basan og konunga Kanaanslands ");
INSERT INTO isl_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","og gaf Ísrael lönd þeirra til eilífrar eignar. ");
INSERT INTO isl_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","Ó, Drottinn, nafn þitt varir að eilífu! Frægð Drottins er kunn frá kynslóð til kynslóðar, ");
INSERT INTO isl_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","því að hann réttir hlut þjóðar sinnar og miskunnar þjónum sínum. ");
INSERT INTO isl_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","Heiðingjarnir tilbiðja skurðgoð úr gulli og silfri, handaverk manna ");
INSERT INTO isl_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","– mállaus og sjónlaus skurðgoð, ");
INSERT INTO isl_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","sem hvorki heyra né draga andann. ");
INSERT INTO isl_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","Smiðir þeirra líkjast þeim og þeir sem tilbiðja þau. ");
INSERT INTO isl_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","Ísrael, lofa þú Drottin! Æðstuprestar Arons, vegsamið nafn hans, ");
INSERT INTO isl_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","og einnig þið prestar af Levíætt. Já, lofið nafn hans, öll þið sem treystið honum og óttist hann. ");
INSERT INTO isl_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","Þið íbúar Jerúsalem, lofið Drottin, hann sem býr í Jerúsalem! Hallelúja! ");
INSERT INTO isl_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","Þakkið Drottni, því að hann er góður, miskunn hans varir að eilífu! ");
INSERT INTO isl_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","Þakkið Guði guðanna, því að miskunn hans varir að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","Þakkið Drottni drottnanna, því að miskunn hans varir að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","Lofið hann sem einn gjörir furðuverk, því að miskunn hans varir að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","Lofið hann sem skapaði himininn, því að miskunn hans varir að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","Lofið hann sem aðskildi höf og lönd, því að miskunn hans varir að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","Lofið hann sem skapaði ljósgjafa himinsins, því að miskunn hans varir að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","Sólina til að ráða deginum, því að miskunn hans varir að eilífu ");
INSERT INTO isl_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","og tunglið og stjörnurnar til að ráða um nætur, því að miskunn hans varir að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","Lofið Guð sem laust frumburði Egypta, því að miskunn hans við Ísrael varir að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","12","Hann leiddi þá út með mætti sínum og sinni voldugu hendi, því að miskunn hans við Ísrael varir að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","14","Lofið Drottin sem opnaði þeim leið gegnum Rauðahafið, því að miskunn hans – varir að eilífu, ");
INSERT INTO isl_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","en drekkti í hafinu hersveitum faraós, því að miskunn hans við Ísrael varir að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","Lofið hann sem leiddi lýð sinn yfir auðnina, því að miskunn hans varir að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","Lofið hann sem frelsaði lýð sinn undan voldugum konungum, því að miskunn hans varir að eilífu ");
INSERT INTO isl_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","og laust þá til dauða, þessa óvini Ísraels, því að miskunn hans við Ísrael varir að eilífu: ");
INSERT INTO isl_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","Síhon, Amoríta-konung, því að miskunn Guðs við Ísrael varir að eilífu ");
INSERT INTO isl_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","– og Óg, konung í Basan – því að miskunn hans við Ísrael varir að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","Guð gaf Ísrael lönd þessara konunga til eilífrar eignar, því að miskunn hans varir að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","Já, þau skyldu verða varanleg gjöf til Ísrael, þjóns hans, því að miskunn hans varir að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","Hann minntist okkar í eymd okkar, því að miskunn hans varir að eilífu ");
INSERT INTO isl_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","og frelsaði okkur frá óvinum okkar, því að miskunn hans varir að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","Hann gefur fæðu öllu því sem lifir, því að miskunn hans varir að eilífu. ");
INSERT INTO isl_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","Já, færið Guði himnanna þakkir, því að miskunn hans varir að eilífu! ");
INSERT INTO isl_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","Við sátum á bökkum Babylonsfljóts og minntumst Jerúsalem – og grétum. ");
INSERT INTO isl_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","Gígjurnar höfum við lagt til hliðar, hengt þær á greinar pílviðarins. ");
INSERT INTO isl_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","4","Hvernig eigum við að geta sungið? Samt heimta kúgarar okkar söng, vilja að við syngjum gleðiljóð frá Síon! ");
INSERT INTO isl_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","6","Ef ég gleymi þér Jerúsalem, þá visni mín hægri hönd! Ef ég elska annað umfram Jerúsalem, þá sé mér mátulegt að missa málið og tapa röddinni. ");
INSERT INTO isl_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","Ó, Drottinn, gleymdu ekki orðum Edómíta, daginn þegar Babyloníumenn hernámu Jerúsalem. „Rífið allt til grunna!“ æptu þeir. ");
INSERT INTO isl_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","Þú Babýlon, ófreskja eyðingarinnar, þú munt sjálf verða lögð í rúst. Lengi lifi þeir sem eyða þig – þig sem eyddir okkur. ");
INSERT INTO isl_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","Og heill þeim sem tekur ungbörn þín og slær þeim við stein! ");
INSERT INTO isl_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","Drottinn, ég þakka þér af öllu hjarta! Ég vil lofsyngja þér í áheyrn englanna á himnum. ");
INSERT INTO isl_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","Ég vil falla fram fyrir þínu heilaga musteri, þakka þér elsku þína og trúfesti, og loforð þín sem þú hefur innsiglað með þínu mikilfenglega nafni. ");
INSERT INTO isl_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","Þegar ég bið, þá heyrir þú bænir mínar, styrkir mig og hughreystir. ");
INSERT INTO isl_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","Konungar jarðarinnar skulu þakka þér, Drottinn, því að allir heyra þeir rödd þína. ");
INSERT INTO isl_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","Já, þeir skulu syngja um verk Drottins, því að mikil er dýrð hans. ");
INSERT INTO isl_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","En þótt Drottinn sé mikill, þá lýtur hann að hinum lítilmótlegu, en hrokafullir halda sig fjarri. ");
INSERT INTO isl_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","Þótt ég sé umvafinn erfiðleikum, muntu sjá um að allt fari vel. Þú réttir fram hnefann gegn óvinum mínum. Kraftur þinn mun frelsa mig. ");
INSERT INTO isl_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","Drottinn mun leysa úr öllum mínum málum – því að Drottinn, miskunn þín varir að eilífu. Yfirgef mig ekki, því að ég er verk handa þinna. ");
INSERT INTO isl_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Drottinn, þú rannsakar mig út og inn og veist allt um mig. ");
INSERT INTO isl_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Hvort ég sit eða stend, það veist þú. Og þú lest hugsanir mínar úr fjarlægð! ");
INSERT INTO isl_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Þú veist hvert ég stefni og þekkir langanir mínar. Og hvort sem ég geng eða ligg, þá athugar þú það. Þú veist öllum stundum hvar ég er. ");
INSERT INTO isl_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Þú þekkir orðin á tungu minni áður en ég opna munninn! ");
INSERT INTO isl_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Þú bæði fylgir mér og ferð á undan mér, leggur hönd þína á höfuð mitt og blessar mig. ");
INSERT INTO isl_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Þetta er stórkostlegt! Já, næstum of gott til að vera satt! ");
INSERT INTO isl_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Hvert get ég farið frá anda þínum eða flúið frá augliti þínu? ");
INSERT INTO isl_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Fari ég til himna, þá ertu þar, til dánarheima, þá ertu líka þar! ");
INSERT INTO isl_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Ef ég svifi á skýjum morgunroðans og settist við fjarlæga strönd, ");
INSERT INTO isl_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","einnig þar mundi hönd þín leiða mig og ég finna styrk þinn og vernd. ");
INSERT INTO isl_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Og þótt ég reyndi að læðast frá þér inn í myrkrið, þá myndi nóttin lýsa eins og dagur! ");
INSERT INTO isl_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","Því að myrkrið hylur ekkert fyrir Guði, dagur og nótt eru jöfn fyrir þér. ");
INSERT INTO isl_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Öll líffæri mín hefur þú skapað, ofið þau í kviði móður minnar. ");
INSERT INTO isl_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Þökk, að þú skapaðir mig eins undursamlega og raun ber vitni! Þetta er dásamlegt um að hugsa! Handaverk þín eru stórkostleg – það er mér alveg ljóst. ");
INSERT INTO isl_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Þú varst til staðar þegar ég var myndaður í leyni. ");
INSERT INTO isl_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Þú þekktir mig þegar ég var fóstur í móðurkviði og áður en ég sá dagsins ljós hafðir þú ákvarðað alla mína ævidaga – sérhver dagur var skráður í bók þína! ");
INSERT INTO isl_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","18","Hugsanir þínar, ó Guð, eru mér torskildar, en samt eru þær stórkostlegar! Ef ég reyndi að telja þær, þá yrði það mér ofviða því að þær eru fleiri en sandkorn á sjávarströnd! Já, ég mundi vakna eins og af draumi, en hugur minn, hann væri enn hjá þér! ");
INSERT INTO isl_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","Vissulega munt þú, Guð, útrýma níðingunum. Já, burt með ykkur, þið morðingjar! ");
INSERT INTO isl_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Þeir guðlasta og hreykja sér upp gegn þér – hvílík heimska! ");
INSERT INTO isl_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","Drottinn, ætti ég ekki að hata þá sem þig hata? Og ætti ég ekki að hafa viðbjóð á þeim? ");
INSERT INTO isl_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Jú, ég hata þá, því að þínir óvinir eru mínir óvinir. ");
INSERT INTO isl_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","Prófaðu mig Guð. Rannsakaðu hjarta mitt og hugsanir mínar. ");
INSERT INTO isl_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Sýndu mér það í fari mínu sem hryggir þig og leiddu mig svo áfram veginn til eilífs lífs. ");
INSERT INTO isl_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","2","Ó, Drottinn, frelsaðu mig frá vondum mönnum. Verndaðu mig gegn ofbeldismönnunum ");
INSERT INTO isl_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","sem sitja á svikráðum alla daga og vekja ófrið. ");
INSERT INTO isl_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","Orð þeirra eru eins og eitruð höggormsbit. ");
INSERT INTO isl_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","Varðveittu mig gegn ofbeldi þeirra og svikráðum. ");
INSERT INTO isl_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","Þessir ofríkismenn hafa lagt gildru fyrir mig, sett út snöru sína. Þeir bíða þess að geta kastað yfir mig neti, flækja mig í möskva sína. ");
INSERT INTO isl_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","8","Ó, Drottinn, þú ert minn Guð! Hlustaðu á grátbeiðni mína! Láttu ekki svikráð níðinganna heppnast. ");
INSERT INTO isl_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","Láttu þá ekki ná árangri eða hreykja sér hátt. ");
INSERT INTO isl_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","Svikráð þeirra komi þeim sjálfum í koll! ");
INSERT INTO isl_vpl VALUES ("PS140_11","020_140_11","PSA","140","11","11","Eldsglóðum rigni yfir þá. Steyptu þeim í gjár sem þeir komast ekki úr. ");
INSERT INTO isl_vpl VALUES ("PS140_12","020_140_12","PSA","140","12","12","Láttu lygara einskis ávinnings njóta í landi okkar, en refsaðu þeim í skyndi. ");
INSERT INTO isl_vpl VALUES ("PS140_13","020_140_13","PSA","140","13","13","Drottinn mun örugglega rétta hlut fólks sem þolað hefur ofsóknir þeirra, hann mun flytja mál hinna snauðu. ");
INSERT INTO isl_vpl VALUES ("PS140_14","020_140_14","PSA","140","14","14","Hinir guðhræddu þakka þér. Þeir fá að lifa í nálægð þinni. ");
INSERT INTO isl_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","Drottinn, þú hefur hlustað á bæn mína, svaraðu mér fljótt! Heyr þegar ég hrópa til þín eftir hjálp. ");
INSERT INTO isl_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","Líttu á bæn mína sem kvöldfórn, eins og reykelsi sem stígur upp til þín. ");
INSERT INTO isl_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","Hjálpaðu mér, Drottinn, að gæta munns míns – innsiglaðu varir mínar! ");
INSERT INTO isl_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","Frelsaðu mig frá löngun í hið illa. Forðaðu mér frá félagsskap við syndara og þeirra vondu verkum. Láttu mig sneiða hjá svallveislum þeirra. ");
INSERT INTO isl_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","Hirting frá guðhræddum manni er mér til góðs – hún er áhrifaríkt læknislyf! Ég vil ekki hlusta á hrós vondra manna. Ég bið gegn illsku þeirra og svikum. ");
INSERT INTO isl_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","7","Þegar foringjar þeirra fá sinn dóm, þegar þeim verður hrint fram af kletti, þá munu menn þessir hlusta á viðvörun mína og skilja að ég vildi þeim vel. ");
INSERT INTO isl_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","Drottinn, ég horfi til þín í von um hjálp. Þú ert skjól mitt. Láttu þá ekki tortíma mér. ");
INSERT INTO isl_vpl VALUES ("PS141_9","020_141_9","PSA","141","9","9","Forðaðu mér frá gildrum þeirra. ");
INSERT INTO isl_vpl VALUES ("PS141_10","020_141_10","PSA","141","10","10","Hinir óguðlegu falli í eigin net, en ég sleppi heill á húfi. ");
INSERT INTO isl_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","2","Ég bið og bið til Drottins, stöðugt grátbæni ég hann. ");
INSERT INTO isl_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","Ég er hræddur og ráðvilltur. Þú einn þekkir leiðina framhjá gildrum óvina minna. ");
INSERT INTO isl_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","Enginn maður hugsar hlýtt til mín. Hvergi er góð ráð að fá. Öllum er sama um mig. ");
INSERT INTO isl_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","Því bið ég til Drottins og segi: „Drottinn, þú einn ert skjól mitt á jörðu, ég er hvergi öruggur nema hjá þér. ");
INSERT INTO isl_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Heyrðu hróp mitt því að ég er mjög þjakaður. Frelsaðu mig frá þeim sem ofsækja mig, því að þeir eru mér yfirsterkari. ");
INSERT INTO isl_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","Leiddu mig úr þessum mikla vanda og þá mun ég lofa þig. Hinir guðhræddu munu þyrpast til mín og fagna með mér yfir hjálp þinni.“ ");
INSERT INTO isl_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","Drottinn, heyrðu bæn mína. Svaraðu ákalli mínu, því að þú ert réttlátur og stendur við orð þín. ");
INSERT INTO isl_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","Leiddu mig ekki fyrir dóm, því að enginn er réttlátur frammi fyrir þér. ");
INSERT INTO isl_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","Óvinir mínir eltu mig og náðu mér. Þeir slógu mig til jarðar og drógu mig inn í myrkrið – ég er eins og þeir sem gengnir eru til grafar. ");
INSERT INTO isl_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","Ég eygi enga von, er lamaður af ótta. ");
INSERT INTO isl_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","Ég hugsa um máttarverk þau sem þú vannst fyrir langa löngu. ");
INSERT INTO isl_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","Ég leita þín. Mig þyrstir eftir þér eins og örþrota land, skrælnað af þurrki. ");
INSERT INTO isl_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","Komdu skjótt, Drottinn og bjargaðu mér, því að ég er að örmagnast! Snúðu ekki við mér bakinu, því að þá væri úti um mig. ");
INSERT INTO isl_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","Sýndu mér miskunn þína að morgni, því að þér treysti ég. Sýndu mér þann veg er ég á að ganga, því að bæn mín er beðin í einlægni. ");
INSERT INTO isl_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","Frelsaðu mig undan óvinum mínum, Drottinn minn, ég vil flýja í skjól þitt. ");
INSERT INTO isl_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","Hjálpaðu mér að gera vilja þinn, því að þú ert minn Guð. Þinn góði andi leiði mig um réttan veg. ");
INSERT INTO isl_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","Drottinn, láttu mig lífi halda og leystu mig úr öllum þessum nauðum, því að þú ert réttlátur og veist að ég hef ekkert til saka unnið. ");
INSERT INTO isl_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","Ég er þjónn þinn. Þú elskar mig og ert mér svo góður! Ryð þú burt þessum óvinum mínum og láttu þá hverfa sem ofsækja mig. ");
INSERT INTO isl_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","Lofaður sé Drottinn! Hann er bjargið sem líf mitt er byggt á! Hann gefur mér kraft og leikni í bardaga. ");
INSERT INTO isl_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","Hann er miskunn mín. Hann er vígi mitt, borg mín og hjálpari, skjöldur minn og athvarf. Hann leggur þjóðir undir mig. ");
INSERT INTO isl_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","Drottinn, hvers virði er maðurinn að þú ómakir þig og minnist hans? Hvers vegna skyldir þú yfirleitt skipta þér af fólki? ");
INSERT INTO isl_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","Því að maðurinn er eins og vindblær, dagar hans eins og hverfandi skuggi. ");
INSERT INTO isl_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","Drottinn, sveigðu himininn og stígðu niður! Þegar þú tyllir þér á fjöllin þá rýkur úr þeim. ");
INSERT INTO isl_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","Láttu eldingar leiftra, – skjóttu örvum þínum og tvístraðu óvinunum! ");
INSERT INTO isl_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","Réttu hönd þína niður og frelsaðu mig, dragðu mig upp úr hinum djúpu vötnum, undan ofurvaldi óvinanna. ");
INSERT INTO isl_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","Munnur þeirra er fullur af svikum og með hægri hönd sinni innsigla þeir lygi. ");
INSERT INTO isl_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","Ég vil syngja þér nýjan söng, ó Guð, og leika undir á tístrengjaða hörpu, ");
INSERT INTO isl_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","því að þú veitir konungum okkar sigur. Þú frelsar þjón þinn Davíð undan sverði dauðans. ");
INSERT INTO isl_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","Bjargaðu mér! Frelsaðu mig undan óvinum þessum, þeir bæði ljúga og svíkja. ");
INSERT INTO isl_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","15","Nú vil ég lýsa landinu þar sem Drottinn er Guð – hamingjulandinu! Þar eru synirnir hraustir og stæltir eins og þróttmikil tré. Dæturnar fagrar og prúðar eins og úthöggnar hallarsúlur. Hlöðurnar fullar af alls konar afurðum. Hjarðir þúsunda sauða liðast um hagana. Uxarnir eru klyfjaðir og ekkert skarð í múrnum. Friður hvert sem litið er, enginn maður í útlegð og glæpir horfnir af strætunum. Já, sæl er sú þjóð sem á Drottin að Guði. ");
INSERT INTO isl_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","2","Ég vil lofa þig, þú Guð minn og konungur, og vegsama nafn þitt hvern einasta dag, já að eilífu! ");
INSERT INTO isl_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","Mikill er Drottinn! Lofið hann án afláts! Dýrð hans er meiri en við fáum skilið! ");
INSERT INTO isl_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","Sérhver kynslóð fræðir börn sín um hans mörgu dásemdarverk. ");
INSERT INTO isl_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Ég vil íhuga dýrð þína og vegsemd, glæsileik þinn og kraftaverk. ");
INSERT INTO isl_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Undur þín eru á allra vörum, ég vil tala um stórvirki þín. ");
INSERT INTO isl_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Öllum er ljúft að segja frá kærleika þínum, syngja um réttlæti þitt. ");
INSERT INTO isl_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","Náðugur og miskunnsamur er Drottinn, seinn til reiði og fullur góðvildar. ");
INSERT INTO isl_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","Drottinn er öllum góður og miskunn hans hvílir yfir öllu sem hann hefur skapað. ");
INSERT INTO isl_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","Öll sköpunin þakkar þér Drottinn, og þjóð þín lofar þig. ");
INSERT INTO isl_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","Þau segja frá dýrð ríkis þíns, og tala um kraft þinn og mátt. ");
INSERT INTO isl_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","Þau víðfrægja mikilleik þinn og máttarverk – dýrð konungdóms þíns. ");
INSERT INTO isl_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","Því að á ríki þínu er enginn endir, veldi þitt nær frá kynslóð til kynslóðar. ");
INSERT INTO isl_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","Drottinn reisir við hina föllnu og styður þá sem ætla að hníga. ");
INSERT INTO isl_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","Allra augu mæna á þig eftir hjálp, því að þú gefur þeim fæðu þeirra á réttum tíma. ");
INSERT INTO isl_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Þú uppfyllir þarfir þeirra og blessar þá. ");
INSERT INTO isl_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","Drottinn er réttlátur og miskunnsamur í öllu sem hann gerir. ");
INSERT INTO isl_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","Hann er nálægur öllum sem ákalla hann í einlægni. ");
INSERT INTO isl_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Hann uppfyllir þarfir þeirra sem óttast hann og elska. Hann heyrir hróp þeirra og hjálpar þeim. ");
INSERT INTO isl_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","Hann verndar alla þá sem elska hann, en útrýmir öllum óguðlegum. ");
INSERT INTO isl_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Ég vil lofa Drottin! Og þið öll, vegsamið hans heilaga nafn á meðan ævi ykkar endist. ");
INSERT INTO isl_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","Dýrð sé Guði! Já, ég vil vegsama hann! ");
INSERT INTO isl_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Ég vil lofa hann á meðan ég lifi, vegsama hann fram á síðustu stund. ");
INSERT INTO isl_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Reiddu þig ekki á hjálp valdsmanna, því að þeir falla og ekkert verður úr aðstoð þeirra. ");
INSERT INTO isl_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","Þeir munu deyja og andi þeirra líður burt, áform þeirra verða að engu. ");
INSERT INTO isl_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","En sæll er sá maður sem reiðir sig á hjálp Guðs, Guðs Jakobs, sem vonar á Drottin, Guð sinn ");
INSERT INTO isl_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","– þann Guð sem skapaði himin og jörð og hafið og allt sem í því er. Hann er sá Guð sem óhætt er að treysta! ");
INSERT INTO isl_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","Hann leitar réttar fátækra og kúgaðra og gefur hungruðum brauð. Hann frelsar fanga, ");
INSERT INTO isl_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","opnar augu blindra, lyftir okinu af þeim sem eru að bugast. Drottinn elskar þá sem gera rétt. ");
INSERT INTO isl_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","Hann verndar útlendingana sem sest hafa að í landinu og gætir réttinda ekkna og einstæðinga, en ónýtir ráðabrugg vondra manna. ");
INSERT INTO isl_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Drottinn mun ríkja að eilífu. Jerúsalem, veistu að Drottinn er konungur að eilífu?! Hallelúja! ");
INSERT INTO isl_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","Hallelúja! Já, lofið Drottin! Það er gott að lofa Drottin! Indælt og rétt! ");
INSERT INTO isl_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","Hann er að endurreisa Jerúsalem og flytja hina herleiddu heim. ");
INSERT INTO isl_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","Hann reisir upp hina niðurbeygðu og bindur um sár þeirra. ");
INSERT INTO isl_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","Hann þekkir fjölda stjarnanna, já og hverja fyrir sig með nafni! ");
INSERT INTO isl_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","Mikill er Drottinn! Vald hans er stórkostlegt! Þekking hans er takmarkalaus. ");
INSERT INTO isl_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","Drottinn styður auðmjúka, en varpar illmennum til jarðar. ");
INSERT INTO isl_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","Syngið honum þakkarljóð, lofið Guð með hörpuleik. ");
INSERT INTO isl_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","Hann fyllir himininn skýjum, gefur steypiregn og klæðir fjöllin grænu grasi. ");
INSERT INTO isl_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","Hann fæðir hin villtu dýr og hrafnarnir krunka til hans eftir æti. ");
INSERT INTO isl_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","Í hans augum kemst sprettharður foli varla úr sporunum og máttur mannsins má sín lítils. ");
INSERT INTO isl_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","En hann gleðst yfir þeim sem elska hann og reiða sig á kærleika hans og gæsku. ");
INSERT INTO isl_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","Lofa þú hann, Jerúsalem! Vegsama Guð þinn, Síon! ");
INSERT INTO isl_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","13","Því að hann hefur gert múra þína öfluga og blessað börnin þín. ");
INSERT INTO isl_vpl VALUES ("PS147_14","020_147_14","PSA","147","14","14","Hann lætur frið haldast í landinu og fyllir hlöður þínar af úrvals hveiti. ");
INSERT INTO isl_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","Hann sendir boð sín til jarðar, skipanir hans berast hratt eins og vindurinn. ");
INSERT INTO isl_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","Skjannahvít mjöllin er frá honum komin og hrímið sem glitrar á jörðinni. ");
INSERT INTO isl_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","Haglélið er líka hans verk og frostið sem bítur í kinnarnar. ");
INSERT INTO isl_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","En síðan sendir hann hlýjan vorvind, snjórinn þiðnar og árnar ryðja sig. ");
INSERT INTO isl_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","Hann kunngjörði Ísrael lögmál sitt og ákvæði ");
INSERT INTO isl_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","– það hefur hann ekki gert við neina aðra þjóð, nei, þeim kennir hann ekki fyrirmæli sín. Hallelúja! Dýrð sé Drottni! ");
INSERT INTO isl_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","Þið sem búið á himnum, lofið Drottin! Lofið hann í upphæðum! ");
INSERT INTO isl_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","Lofið hann allir englar, allar hersveitir himnanna. ");
INSERT INTO isl_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","Lofið hann sól og tungl og allar lýsandi stjörnur. ");
INSERT INTO isl_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","Lofið hann hæstu himnar og þú dögg er svífur um háloftin. ");
INSERT INTO isl_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","Allt sem hann hefur skapað lofi nafn hans, því að þegar hann talaði, þá varð það allt til, ");
INSERT INTO isl_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","hann fékk þeim stað um aldur og ævi, setti þeim lögmál sem þau fá ekki brotið. ");
INSERT INTO isl_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","Lofið Drottin einnig á jörðu, líka þið skepnur í hafdjúpunum. ");
INSERT INTO isl_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","Eldur og hagl, snjór, regn, vindur og veður öll, – allt hlýði það Drottni. ");
INSERT INTO isl_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","Allt skal þetta lofa Drottin: fjöll og hæðir, ávaxtatré sem önnur tré, ");
INSERT INTO isl_vpl VALUES ("PS148_10","020_148_10","PSA","148","10","10","villidýr og búfé, höggormar og fuglar ");
INSERT INTO isl_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","konungar og allar þjóðir, höfðingjar og dómarar, ");
INSERT INTO isl_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","piltar og stúlkur, aldraðir og börn. ");
INSERT INTO isl_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","Sameiginlega skulu þau lofa Drottin, því að hann einn er þess verður og dýrð hans er ofar himni og jörðu. ");
INSERT INTO isl_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","Hann hefur gert þjóð sína volduga. Heldur uppi heiðri hinna guðhræddu – lýðs Ísraels, þjóðarinnar sem honum stendur næst. Hallelúja! Dýrð sé Drottni! ");
INSERT INTO isl_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","Hallelúja! Lofið Drottin! Syngið honum nýjan söng. Lofsyngið honum öll þjóðin. ");
INSERT INTO isl_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","Ó, Ísrael, gleð þig yfir skapara þínum. Þið sem búið í Jerúsalem, fagnið yfir konungi ykkar! ");
INSERT INTO isl_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","Lofið nafn hans með gleðidansi og leikið fyrir hann á bumbur og gígjur. ");
INSERT INTO isl_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","5","Drottinn hefur unun af lýð sínum. Hann frelsar hina auðmjúku. Hinir trúuðu gleðjist með sæmd og syngi fagnandi í hvílum sínum. ");
INSERT INTO isl_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","7","Lofið hann, þið fólk hans! Framkvæmið refsingu hans á þjóðunum með tvíeggjuðu sverði. ");
INSERT INTO isl_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","Setjið konunga þeirra og fyrirmenn í járn og fullnægið á þeim skráðum dómi. Drottinn er vegsemd þjóðar sinnar. Hallelúja! ");
INSERT INTO isl_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","Hallelúja! Lofið Drottin! Lofið hann í musteri hans, lofið hann á himnum. ");
INSERT INTO isl_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","Lofið hann fyrir máttarverk hans. Lofið hann fyrir mikilleik hátignar hans. ");
INSERT INTO isl_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","Lofið hann með lúðrablæstri, hörpu og gígju. ");
INSERT INTO isl_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","Lofið hann með strengjaleik og hjarðpípum. ");
INSERT INTO isl_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","Lofið hann með hljómandi skálabumbum, já og með hvellum skálabumbum! ");
INSERT INTO isl_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Allt sem andardrátt hefur lofi Drottin! Einnig þú! Hallelúja!");
INSERT INTO isl_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Þessir eru forfeður Jesú Krists, afkomanda Davíðs konungs og Abrahams: ");
INSERT INTO isl_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham var faðir Ísaks. Ísak var faðir Jakobs. Jakob var faðir Júda og bræðra hans. ");
INSERT INTO isl_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Júda var faðir Peresar og Sera (móðir þeirra hét Tamar). Peres var faðir Esroms. Esrom var faðir Rams, ");
INSERT INTO isl_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","en Ram var faðir Ammínadabs og sonur hans var Nakson. Nakson var faðir Salmons. ");
INSERT INTO isl_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon var faðir Bóasar (kona hans var Rut). Óbeð var faðir Ísaís, ");
INSERT INTO isl_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","en Ísaí faðir Davíðs konungs og Davíð faðir Salómons (móðir hans var ekkja Úría). ");
INSERT INTO isl_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salómon var faðir Róbóams og sonur hans var Abía. Abía var faðir Asafs. ");
INSERT INTO isl_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaf var faðir Jósafats. Jósafat var faðir Jórams og Jóram faðir Ússía. ");
INSERT INTO isl_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ússía var faðir Jótams, en sonur hans var Akas og Esekía var sonur hans. ");
INSERT INTO isl_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekía var faðir Manasse, en hann var faðir Amoss og Amos faðir Jósía. ");
INSERT INTO isl_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jósía var faðir Jekonja og bræðra hans (þeir fæddust í herleiðingunni til Babýlon). ");
INSERT INTO isl_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Eftir herleiðinguna: Jekonja var faðir Sealtíels, Sealtíel var faðir Serúbabels, ");
INSERT INTO isl_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serúbabel faðir Abíúds og Abíúd faðir Eljakíms. Eljakím var faðir Asórs, ");
INSERT INTO isl_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","en sonur hans var Sadók. Og Sadók var faðir Akíms, Akím faðir Elíúds ");
INSERT INTO isl_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","og Elíúd faðir Eleasars. Eleasar var faðir Mattans, Mattan faðir Jakobs og ");
INSERT INTO isl_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakob faðir Jósefs en hann var eiginmaður Maríu, móður Jesú Krists. ");
INSERT INTO isl_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Þetta eru fjórtán ættliðir frá Abraham til Davíðs konungs, fjórtán ættliðir frá Davíð fram að herleiðingunni og einnig fjórtán ættliðir frá herleiðingunni fram til Krists. ");
INSERT INTO isl_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Aðdragandinn að fæðingu Jesú var á þessa leið: María móðir hans var trúlofuð Jósef. Hún varð þunguð af völdum heilags anda meðan hún var enn ósnortin mey. ");
INSERT INTO isl_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jósef, unnusti hennar, sem var mjög sómakær maður, ákvað þá að slíta trúlofuninni í kyrrþey, því að hann vildi ekki valda henni opinberri smán. ");
INSERT INTO isl_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Eitt sinn er hann var að íhuga þetta á andvökunóttu, sofnaði hann og dreymdi að engill stóð hjá honum og sagði: „Jósef, sonur Davíðs, hikaðu ekki við að kvænast Maríu, því að barnið sem hún gengur með, er getið af heilögum anda. ");
INSERT INTO isl_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Hún mun eignast son, og þú skalt láta hann heita Jesú (sem þýðir Guð frelsar), því að hann mun frelsa þjóð sína frá syndum hennar. ");
INSERT INTO isl_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Þannig mun rætast það sem spámaður Guðs sagði: ");
INSERT INTO isl_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","„Takið eftir! Meyjan mun þunguð verða! Hún mun fæða son og hann verða kallaður „Immanúel“ (en það þýðir Guð er með okkur)“.“ ");
INSERT INTO isl_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Þegar Jósef vaknaði, ákvað hann að gera eins og engillinn hafði sagt honum og ganga að eiga Maríu, ");
INSERT INTO isl_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","þau höfðu þó ekki kynmök fyrr en eftir að sonurinn var fæddur. Og Jósef gaf drengnum nafnið Jesús. ");
INSERT INTO isl_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús fæddist í bænum Betlehem í Júdeu á valdatímum Heródesar konungs. Um það leyti komu stjörnufræðingar til Jerúsalem frá Austurlöndum og spurðu: ");
INSERT INTO isl_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","„Hvar er nýfæddi Gyðingakonungurinn? Við höfum séð stjörnu hans austur í löndum og nú erum við komnir til þess að sýna honum lotningu.“ ");
INSERT INTO isl_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Heródes konungur varð óttasleginn er hann heyrði þetta, og alls kyns sögusagnir komust á kreik í Jerúsalem. ");
INSERT INTO isl_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Heródes kallaði því saman trúarleiðtoga Gyðinga og spurði: „Hafa spámennirnir sagt hvar Kristur eigi að fæðast?“ ");
INSERT INTO isl_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","„Já,“ svöruðu leiðtogarnir, „í Betlehem, því að þannig skrifaði Míka spámaður: ");
INSERT INTO isl_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","„Þú Betlehem litla, þú ert ekki einhver þýðingarlaus smábær í Júdeu, því frá þér mun koma höfðingi sem annast þjóð mína, Ísrael“.“ ");
INSERT INTO isl_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Heródes sendi þá stjörnufræðingunum leynileg boð um að finna sig, og á þeim fundi fékk hann að vita hvenær þeir hefðu fyrst séð stjörnuna. Síðan sagði hann: ");
INSERT INTO isl_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","„Farið til Betlehem og leitið að barninu, og þegar þið hafið fundið það, skuluð þið koma aftur og láta mig vita hvar það er, svo að ég geti einnig veitt því lotningu!“ ");
INSERT INTO isl_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Að þessum viðræðum loknum héldu stjörnufræðingarnir aftur af stað. Og sjá! Stjarnan birtist þeim á ný og fór fyrir þeim uns hún staðnæmdist loks yfir Betlehem. ");
INSERT INTO isl_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Gleði þeirra var takmarkalaus! ");
INSERT INTO isl_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Þeir gengu inn í húsið þar sem María og barnið voru, krupu á kné frammi fyrir því og tilbáðu það. Síðan tóku þeir upp farangur sinn og gáfu barninu gull, reykelsi og myrru. ");
INSERT INTO isl_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Á heimleiðinni komu þeir ekki við í Jerúsalem til þess að hitta Heródes, því að Guð hafði sagt þeim í draumi að fara aðra leið. ");
INSERT INTO isl_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Þegar þeir voru farnir, dreymdi Jósef að hann sæi engil frá Drottni sem sagði: „Flýðu til Egyptalands og taktu með þér barnið og móður þess, því að Heródes konungur sækist eftir lífi barnsins. Vertu síðan um kyrrt í Egyptalandi þar til ég segi þér að snúa heim aftur.“ ");
INSERT INTO isl_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jósef lagði af stað til Egyptalands með barnið og Maríu þessa sömu nótt. ");
INSERT INTO isl_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Þar dvöldust þau uns Heródes konungur lést, en þá rættust orð spámannsins: „Ég kallaði son minn frá Egyptalandi.“ ");
INSERT INTO isl_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Heródes varð æfur af reiði þegar hann komst að því að stjörnufræðingarnir höfðu brugðist honum og sendi þegar í stað alla hermenn til Betlehem. Hann gaf þeim skipun um að drepa alla drengi, tveggja ára og yngri, sem ættu heima þar í nágrenninu. Þetta gerði Heródes vegna þess að stjörnufræðingarnir höfðu sagt honum að þeir hefðu fyrst séð stjörnuna tveimur árum áður. ");
INSERT INTO isl_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jeremía spámaður hafði sagt fyrir um þennan hryllilega verknað Heródesar með þessum orðum: ");
INSERT INTO isl_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","„Í Rama kveður við angistarvein og óstöðvandi grátur. Rakel grætur börnin sín. Hún er óhuggandi því þau eru ekki lengur lífs.“ ");
INSERT INTO isl_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Eftir dauða Heródesar birtist engill Drottins Jósef í draumi í Egyptalandi og sagði: ");
INSERT INTO isl_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","„Rís þú á fætur og farðu aftur til Ísraels með Jesú og móður hans.“ ");
INSERT INTO isl_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Hann sneri því þegar í stað aftur til Ísraels með Jesú og móður hans. ");
INSERT INTO isl_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Á leiðinni frétti hann sér til mikils ótta að nýi konungurinn í Júdeu væri Areklás, sonur Heródesar. Þá var hann varaður við í öðrum draumi, að fara til Júdeu, og því héldu þau til Galíleu ");
INSERT INTO isl_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","og settust að í Nasaret. Þar með rættist þessi spádómur um Krist: „Hann mun kallaður Nasarei.“ ");
INSERT INTO isl_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Meðan þau bjuggu í Nasaret tók Jóhannes skírari að predika í óbyggðum Júdeu. Kjarninn í boðskap hans var þessi: ");
INSERT INTO isl_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","„Snúið ykkur frá syndinni og til Guðs, því ríki himnanna er nálægt.“ ");
INSERT INTO isl_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jesaja spámaður sagði þannig fyrir um starf Jóhannesar mörgum öldum áður: „Ég heyri hrópað í auðninni: Ryðjið Drottni veg – gjörið beinar brautir hans.“ ");
INSERT INTO isl_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Klæðnaður Jóhannesar var ofinn úr úlfaldahári, og hann notaði leðurbelti. Hann lifði á engisprettum og villihunangi. ");
INSERT INTO isl_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Fólk streymdi frá Jerúsalem, allri Júdeu og úr Jórdandalnum til þess að hlusta á hann. ");
INSERT INTO isl_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Þá sem játuðu syndir sínar skírði hann í ánni Jórdan. ");
INSERT INTO isl_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Margir farísear og saddúkear komu til að láta skírast hjá Jóhannesi. Þegar hann sá þá koma ásakaði hann þá opinberlega og sagði: „Þið höggormssynir! Hver hefur sagt að þið gætuð umflúið reiði Guðs? ");
INSERT INTO isl_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Áður en þið látið skírast verðið þið að sýna í verki að þið hafið snúið ykkur frá syndinni. ");
INSERT INTO isl_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Þið skuluð ekki halda að þið getið sloppið með því að segja: „Það er allt í lagi með okkur, við erum Gyðingar – afkomendur Abrahams“ það er engin trygging í því. Guð gæti breytt grjótinu hérna í Gyðinga, ef hann vildi. ");
INSERT INTO isl_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nú þegar hefur öxi Guðs verið reidd til höggs, því að dómurinn er skammt undan og hvert það tré sem ekki ber ávöxt verður upp höggvið og brennt í eldi. ");
INSERT INTO isl_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Þá sem iðrast synda sinna skíri ég í vatni, en sá sem kemur á eftir mér er mér svo miklu æðri að ég er ekki einu sinni verður þess að halda á skónum hans! ");
INSERT INTO isl_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Hann mun skilja hismið frá kjarnanum og safna korninu í hlöðuna en brenna hismið í óslökkvandi eldi.“ ");
INSERT INTO isl_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Þá kom Jesús frá Galíleu til árinnar Jórdan til þess að skírast hjá Jóhannesi, ");
INSERT INTO isl_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","en Jóhannes færðist undan að skíra hann og sagði: „Kemur þú til að skírast hjá mér?! Ég þyrfti fremur að fá skírn hjá þér.“ ");
INSERT INTO isl_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","„Láttu þetta samt eftir mér því þá gerum við það sem rétt er,“ sagði Jesús. Þá skírði Jóhannes hann. ");
INSERT INTO isl_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Þegar Jesús steig upp úr vatninu að skírninni lokinni, opnuðust himnarnir yfir honum og hann sá anda Guðs koma niður yfir sig, í dúfulíki, ");
INSERT INTO isl_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","og rödd af himni sagði: „Þessi er minn elskaði sonur sem ég hef velþóknun á.“ ");
INSERT INTO isl_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Eftir þetta leiddi heilagur andi Jesú út í óbyggðina, til þess að hans yrði freistað af Satan. ");
INSERT INTO isl_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Þegar Jesús hafði verið þar matarlaus í fjörutíu sólarhringa var hungrið farið að sverfa að. ");
INSERT INTO isl_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Þá reyndi Satan að fá hann til að breyta steinum í brauð og sagði: „Ef þú ert sonur Guðs, þá breyttu þessum steinum í brauð.“ ");
INSERT INTO isl_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","„Nei!“ svaraði Jesús. „Biblían segir að fæðan sé manninum ekki hið eina nauðsynlega heldur það að fara eftir orði Guðs.“ ");
INSERT INTO isl_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Satan fór þá með hann til Jerúsalem, upp á þak musterisins, og sagði: ");
INSERT INTO isl_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","„Ef þú ert sonur Guðs þá kastaðu þér fram af þakbrúninni, því að Biblían segir: „Guð mun senda engla sína til að gæta þín, þeir munu vernda þig svo þú slasist ekki á steinunum fyrir neðan.“ “ ");
INSERT INTO isl_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","„Já, en hún segir einnig að enginn skuli leggja heimskulegar þrautir fyrir Drottin, Guð sinn!“ svaraði Jesús byrstur. ");
INSERT INTO isl_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Því næst fór Satan með Jesú upp á hátt fjall og sýndi honum þaðan þjóðir heimsins og alla dýrð þeirra. ");
INSERT INTO isl_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","„Allt þetta mun ég gefa þér, ef þú krýpur fyrir mér og tilbiður mig.“ ");
INSERT INTO isl_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","„Burt með þig Satan!“ skipaði Jesús. „Guðs orð segir: „Drottin Guð þinn átt þú að tilbiðja og hlýða honum einum.“ “ ");
INSERT INTO isl_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Þá fór Satan burt, en englar komu og þjónuðu Jesú. ");
INSERT INTO isl_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","13","Þegar Jesús frétti að Jóhannes hefði verið handtekinn, fór hann norður í Galíleu. Hann fluttist frá Nasaret og settist að í Kapernaum, sem er við Galíleuvatnið í héraði Sebúlóns og Naftalí. ");
INSERT INTO isl_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Þá rættist þessi spádómur Jesaja: ");
INSERT INTO isl_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","„Í landi Sebúlons og landi Naftalí við vatnið – héraðinu handan Jórdan og í Efri-Galíleu þar sem margir útlendingar búa – var fólkið í myrkri, en dag einn braust ljósið fram og skein á meðal þess.“ ");
INSERT INTO isl_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Upp frá þessu tók Jesús að predika: „Snúið ykkur frá syndinni og til Guðs, því að ríki himnanna er nálægt.“ ");
INSERT INTO isl_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Dag einn var hann á gangi við Galíleuvatnið. Þá hitti hann tvo menn á báti við ströndina. Þetta voru Símon, sem kallaður var Pétur, og Andrés bróðir hans. Þeir voru fiskimenn og voru að kasta neti í vatnið. ");
INSERT INTO isl_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesús kallaði til þeirra: „Komið og fylgið mér, og ég skal kenna ykkur að veiða menn!“ ");
INSERT INTO isl_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Þá yfirgáfu þeir netin og fóru með honum. ");
INSERT INTO isl_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Spölkorn þaðan sá hann tvo aðra menn við vatnið, Jakob og Jóhannes, sem einnig voru bræður. Þeir sátu þar í báti ásamt Sebedeusi föður sínum og bættu net. Jesús kallaði einnig á þá og ");
INSERT INTO isl_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","þeir stóðu samstundis upp frá vinnunni, skildu föður sinn eftir og fylgdu Jesú. ");
INSERT INTO isl_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús ferðaðist um alla Galíleu og talaði í samkomuhúsum Gyðinga (en þar fóru guðþjónustur fram). Hann predikaði gleðiboðskapinn um guðsríki og læknaði hvers konar sjúkdóma og meinsemdir. ");
INSERT INTO isl_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Fregnir af kraftaverkum hans bárust langt út fyrir Galíleu. Sjúkt fólk kom jafnvel alla leið frá Sýrlandi til að fá lækningu hjá honum. Hann læknaði alla sjúka (sama hver sjúkdómurinn var), einnig geðveika og lamaða, og þá sem haldnir voru illum öndum. ");
INSERT INTO isl_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mikill mannfjöldi fylgdi honum hvert sem hann fór – fólk frá Galíleu, bæjunum tíu austanvert við Galíleuvatnið, Jerúsalem, Júdeu og jafnvel frá landsvæðinu handan Jórdanar. ");
INSERT INTO isl_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Dag nokkurn þegar fólkið þyrptist að honum fór hann upp á fjallið ásamt lærisveinum sínum, ");
INSERT INTO isl_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","settist þar niður og kenndi: ");
INSERT INTO isl_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","„Sælir eru auðmjúkir, því að þeirra er himnaríki. ");
INSERT INTO isl_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Sælir eru sorgmæddir, því að þeir munu huggaðir verða. ");
INSERT INTO isl_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Sælir eru hógværir, því að þeir munu eignast landið. ");
INSERT INTO isl_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Sælir eru þeir sem þrá réttlætið, því að það mun falla þeim í skaut. ");
INSERT INTO isl_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Sælir eru miskunnsamir, því að þeim mun miskunnað verða. ");
INSERT INTO isl_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Sælir eru hjartahreinir, því að þeir munu sjá Guð. ");
INSERT INTO isl_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Sælir eru þeir sem vinna að friði, því að þeir munu kallaðir verða synir Guðs. ");
INSERT INTO isl_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Sælir eru þeir sem ofsóttir eru fyrir trú sína á mig, því að þeirra er himnaríki. ");
INSERT INTO isl_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Gleðjist og fagnið þegar fólk talar illa um ykkur, ofsækir ykkur eða ber lognar sakir á ykkur vegna þess að þið fylgið mér, ");
INSERT INTO isl_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","því að mikil laun bíða ykkar á himnum! Minnist þess að hinir fornu spámenn þoldu einnig ofsóknir. ");
INSERT INTO isl_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Þið eruð salt jarðarinnar, þið eigið að bæta heiminn! Hvernig færi ef þið misstuð seltuna? Þið yrðuð einskis nýt eins og rusl sem fleygt er út og fótum troðið. ");
INSERT INTO isl_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Þið eruð ljós heimsins. Allir sjá borg sem reist er á fjalli. ");
INSERT INTO isl_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","16","Felið því ekki ljósið ykkar heldur látið það skína til að allir sjái það! Leyfið öllum að sjá góðverk ykkar, svo að þeir þakki föður ykkar á himnum. ");
INSERT INTO isl_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Misskiljið mig ekki. Ég kom ekki til að afnema lög Móse og viðvaranir spámannanna. Nei, ég kom til að uppfylla hvort tveggja og staðfesta það. ");
INSERT INTO isl_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ég segi ykkur satt: Hver einasta grein lögbókarinnar mun standa óhögguð uns tilgangi hennar hefur verið náð. ");
INSERT INTO isl_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Þar af leiðir að sá sem brýtur hið minnsta boðorð og hvetur aðra til þess að gera hið sama verður minnstur í himnaríki. En sá sem kennir lög Guðs og fer eftir þeim mun verða mikill í himnaríki. ");
INSERT INTO isl_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ég vil benda ykkur á eitt: Ef góðverk ykkar verða ekki fremri góðverkum faríseanna og annarra leiðtoga þjóðarinnar, þá komist þið alls ekki inn í guðsríkið. ");
INSERT INTO isl_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Þannig segir í lögum Móse: „Drepir þú mann, verður þú sjálfur að deyja.“ ");
INSERT INTO isl_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","En ég bæti við: Ef þú reiðist – jafnvel þótt það sé aðeins við bróður þinn á þínu eigin heimili – vofir dómurinn yfir þér! Ef þú kallar vin þinn fífl, átt þú á hættu að þér verði stefnt fyrir réttinn! Og bölvir þú honum áttu eld helvítis yfir höfði þér. ");
INSERT INTO isl_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ef þú stendur frammi fyrir altarinu í musterinu og ert að færa Guði fórn, og minnist þess þá allt í einu að vinur þinn hefur eitthvað á móti þér, ");
INSERT INTO isl_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","skaltu skilja fórn þína eftir hjá altarinu, fara og biðja hann fyrirgefningar og sættast við hann. Komdu síðan aftur og berðu fram fórnina. ");
INSERT INTO isl_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Flýttu þér að sættast við óvin þinn áður en það er um seinan, því að annars mun hann draga þig fyrir rétt. Þá verður þér varpað í skuldafangelsi, ");
INSERT INTO isl_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","þar sem þú verður að dúsa uns þú hefur greitt þinn síðasta eyri. ");
INSERT INTO isl_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Boðorðið segir: „Þú skalt ekki drýgja hór.“ ");
INSERT INTO isl_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","En ég segi: Sá sem horfir á konu með girndarhug, hefur þegar drýgt hór með henni í huga sínum. ");
INSERT INTO isl_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ef það sem þú sérð með auga þínu verður til þess að þú fellur í synd, skaltu stinga augað úr þér og fleygja því. Betra er að hluti af þér eyðileggist en að þér verði öllum kastað í víti. ");
INSERT INTO isl_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ef hönd þín – jafnvel sú hægri – kemur þér til að syndga, þá er betra að höggva hana af og fleygja henni en að lenda í helvíti. ");
INSERT INTO isl_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Í lögum Móse segir svo: „Sá sem vill skilja við konu sína verður að fá henni skilnaðarbréf.“ ");
INSERT INTO isl_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","En ég segi: Skilji maður við konu sína af annarri ástæðu en þeirri að hún hafi verið honum ótrú, veldur hann því að hún drýgir hór, og sá sem síðar kvænist henni drýgir einnig hór. ");
INSERT INTO isl_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Þið þekkið líka þessa gömlu reglu: „Þú skalt ekki sverja rangan eið, og haltu þau heit sem þú hefur gefið Guði.“ ");
INSERT INTO isl_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ég segi: Sverjið ekki, hvorki við himininn, því að hann er hásæti Guðs, ");
INSERT INTO isl_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","né jörðina, því hún er fótskör hans. Sverjið ekki við Jerúsalem, því hún er borg hins mikla konungs. ");
INSERT INTO isl_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Þú mátt ekki heldur sverja við höfuð þitt, því þú getur ekki einu sinni breytt háralit þínum, hvað þá meira. ");
INSERT INTO isl_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Látið nægja að segja: Já, ég vil… eða: Nei, ég vil ekki! Það á að vera hægt að treysta því sem þú segir. Þurfir þú að staðfesta orð þín með eiði er ekki allt með felldu. ");
INSERT INTO isl_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Í lögum Móse stendur: „Stingi maður auga úr öðrum manni, skal hann sjálfur gjalda fyrir það með eigin auga. Brjóti einhver tönn úr þér, skaltu brjóta tönn úr honum í staðinn.“ ");
INSERT INTO isl_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ég segi hins vegar: Launið ekki ofbeldi með ofbeldi! Slái einhver þig á aðra kinnina, snúðu þá einnig hinni að honum. ");
INSERT INTO isl_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Höfði einhver mál gegn þér þannig að þú tapar skyrtunni þinni, skaltu líka láta yfirhöfn þína af hendi. ");
INSERT INTO isl_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ef hermenn skipa þér að bera varning sinn eina mílu, þá skaltu bera hann tvær. ");
INSERT INTO isl_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Gefðu þeim sem biðja þig, og snúðu ekki bakinu við þeim sem vilja fá lán hjá þér. ");
INSERT INTO isl_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Sagt hefur verið: „Elskaðu vini þína og hataðu óvini þína.“ ");
INSERT INTO isl_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","En ég segi: Elskið óvini ykkar og biðjið fyrir þeim sem ofsækja ykkur. ");
INSERT INTO isl_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ef þið gerið það, komið þið fram eins og hæfir sonum hins himneska föður. Hann lætur sólina skína jafnt á vonda sem góða. Hann lætur einnig rigna jafnt hjá réttlátum sem ranglátum. ");
INSERT INTO isl_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Hvaða góðverk er það að elska þá eina sem elska ykkur? Jafnvel skattheimtumennirnir gera það. ");
INSERT INTO isl_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Eruð þið nokkuð frábrugðin heiðingjunum, ef þið eruð einungis vinir vina ykkar? Nei! ");
INSERT INTO isl_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Verið því fullkomin eins og ykkar himneski faðir er fullkominn. ");
INSERT INTO isl_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Gætið þess að vinna ekki góðverk til þess eins að fá hrós hjá mönnum, því að þá farið þið á mis við launin frá föður ykkar á himnum. ");
INSERT INTO isl_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Látið ekki á því bera, eins og hræsnararnir gera, ef þið gefið einhverjum eitthvað. Þeir láta blása í lúður fyrir sig í samkomuhúsunum og á götuhornunum til þess að fá hrós fyrir góðverk sín! Ég segi ykkur satt: Þeir hafa þegar fengið laun sín. ");
INSERT INTO isl_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Gætið þess að ekki beri mikið á því þegar þið réttið einhverjum hjálparhönd. Segið vinstri hendinni ekki hvað sú hægri gerir! ");
INSERT INTO isl_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Faðir ykkar á himnum veit leyndarmálið og mun launa ykkur. ");
INSERT INTO isl_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Verið ekki eins og hræsnararnir þegar þið biðjið. Þeir biðja á áberandi hátt á götuhornum og í samkomuhúsunum, þar sem allir sjá þá. Ég segi ykkur satt. Allt og sumt sem þeir fá fyrir þetta er athygli annarra! ");
INSERT INTO isl_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Vertu í einrúmi þegar þú biður. Lokaðu dyrunum og bið til föður þíns þannig að enginn viti. Faðir þinn, sem þekkir leyndar hugsanir þínar, mun bænheyra þig. ");
INSERT INTO isl_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","8","Þyljið ekki bænir ykkar í belg og biðu eins og heiðingjarnir. Þeir halda að bænin verði heyrð ef hún er nógu löng og fagurlega orðuð. Minnist þess að faðir ykkar veit nákvæmlega hvers þið þarfnist, jafnvel áður en þið biðjið. ");
INSERT INTO isl_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Biðjið þannig: „Kæri Faðir, þú sem ert á himnum, helgist þitt nafn. ");
INSERT INTO isl_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Komi ríki þitt. Verði þinn vilji á jörðu eins og á himnum. ");
INSERT INTO isl_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Gefðu okkur fæðu í dag eins og aðra daga. ");
INSERT INTO isl_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Fyrirgefðu okkur syndirnar, eins og við fyrirgefum þeim sem syndga gegn okkur. ");
INSERT INTO isl_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Leiddu okkur ekki í þyngri prófraunir en þær sem við fáum staðist og frelsaðu okkur frá illu. Amen.“ ");
INSERT INTO isl_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","15","Faðirinn á himnum mun fyrirgefa ykkur ef þið fyrirgefið þeim sem hafa brotið gegn ykkur, en ef þið fyrirgefið þeim ekki, mun hann ekki heldur fyrirgefa ykkur. ");
INSERT INTO isl_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Fastið ekki þannig að á því beri eins og hræsnararnir. Þeir reyna að sýnast aðframkomnir, svo að fólk finni til með þeim en það eru einu launin sem þeir fá. ");
INSERT INTO isl_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Verið heldur vel til fara, hreinir og snyrtilegir, ");
INSERT INTO isl_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","svo að engan gruni að þið séuð hungraðir. Faðir ykkar á himnum veit leyndarmálið og hann mun launa ykkur. ");
INSERT INTO isl_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Safnið ekki auðæfum á jörðu, því að þar eyðast þau og þeim kynni að verða stolið. ");
INSERT INTO isl_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Safnið heldur verðmætum á himnum! Þar munu þau aldrei rýrna og þar stafar engin hætta af þjófum. ");
INSERT INTO isl_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Séu auðæfi þín á himnum, mun einnig hugur þinn og hjarta vera þar, því að hugurinn er bundinn við það sem þér finnst verðmætast. ");
INSERT INTO isl_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Augað er lampi líkamans. Ef augu þín eru heilbrigð, þá verður allur líkami þinn bjartur. En ef þau eru sjúk, þá verður allur líkaminn dimmur. ");
INSERT INTO isl_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ef nú ljósið í þér er myrkur, hvílíkt verður þá myrkrið. ");
INSERT INTO isl_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ekki er hægt að þjóna tveimur guðum, því að þið munuð hata annan en elska hinn. Enginn getur þjónað bæði Guði og peningum. ");
INSERT INTO isl_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ráðlegging mín er þessi: Hafið engar áhyggjur af mat, drykk, fatnaði eða því um líku. Þið eigið nú þegar líf og líkama, og það er miklu dýrmætara en fæðan og fatnaðurinn. ");
INSERT INTO isl_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Takið eftir fuglunum. Þeir hafa ekki áhyggjur af því hvað þeir eiga að borða, þeir þurfa hvorki að sá né uppskera né safna í forðabúr, því að faðir ykkar á himnum sér fyrir þeim. Þið eruð miklu dýrmætari en fuglarnir, í hans augum. ");
INSERT INTO isl_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Haldið þið ef til vill að áhyggjurnar lengi lífið? ");
INSERT INTO isl_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Hvers vegna hafið þið áhyggjur af fatnaði? Virðið fyrir ykkur blómin sem vaxa á jörðinni. Þau kvíða engu. ");
INSERT INTO isl_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Salómon, í allri sinni dýrð var þó ekki klæddur slíku skarti sem þau! ");
INSERT INTO isl_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Skyldi Guð ekki miklu fremur vilja annast ykkur fyrst honum er svona umhugað um blómin, sem standa í dag en eru fallin á morgun! Æ, þið lítiltrúaðir! ");
INSERT INTO isl_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","32","Hafið því engar áhyggjur af fæðu eða fötum! Verið ekki eins og heiðingjarnir sem hugsa ekki um annað. Ykkar himneski faðir veit vel að þið þarfnist alls þessa. ");
INSERT INTO isl_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Sækist fyrst eftir að tilheyra honum og gera vilja hans, þá mun allt þetta veitast ykkur að auki. ");
INSERT INTO isl_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kvíðið ekki morgundeginum því hann er einnig í hendi Guðs. Lifið einn dag í senn. ");
INSERT INTO isl_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Verið ekki aðfinnslusamir, og þá munu aðrir ekki heldur finna að við ykkur. ");
INSERT INTO isl_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Eins og þú ert við aðra, munu þeir verða gagnvart þér. ");
INSERT INTO isl_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Hvers vegna hefur þú áhyggjur af flísinni í auga bróður þíns? Þú ert sjálfur með planka í auganu! – Já, heilan bjálka! ");
INSERT INTO isl_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Er rétt af þér að segja: „Vinur, leyfðu mér að hjálpa þér að fjarlægja þessa flís úr auganu á þér,“ meðan þú sérð alls ekki til vegna plankans sem er í þínu eigin auga? ");
INSERT INTO isl_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Hræsnari! Losaðu þig fyrst við plankann, og eftir það muntu sjá vel til að hjálpa bróður þínum. ");
INSERT INTO isl_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Láttu ekkert heilagt í hendur spilltra manna. Kastaðu ekki perlum fyrir svín, því þau munu troða þær niður í svaðið og ráðast að því búnu gegn þér. ");
INSERT INTO isl_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Biðjið og þið munuð öðlast. Leitið og þið munuð finna. Knýið á og þá mun verða lokið upp. ");
INSERT INTO isl_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Því sá öðlast sem biður. Sá finnur sem leitar og fyrir þeim, sem á knýr, mun opnað verða. ");
INSERT INTO isl_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Hvaða maður gæfi barni sínu stein, ef það bæði um brauð? ");
INSERT INTO isl_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Eða höggorm, ef það bæði um fisk? Enginn! ");
INSERT INTO isl_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Fyrst þið sem eruð vondir og syndugir menn, hafið vit á að gefa börnunum ykkar góðar gjafir, hversu miklu fremur mun þá faðir ykkar á himnum gefa þeim góðar gjafir sem biðja hann? ");
INSERT INTO isl_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Vertu við aðra eins og þú vilt að þeir séu við þig – þetta er kjarninn í lögum Móse. ");
INSERT INTO isl_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Eina leiðin til himins liggur um þrönga hliðið. Vegurinn til glötunar er breiður og hlið hans vítt – greiðfær leið öllum sem hana velja. ");
INSERT INTO isl_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Vegurinn til lífsins er mjór og hlið hans þröngt, fáir eru þeir sem finna hann. ");
INSERT INTO isl_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Gætið ykkar á falskennendum sem dulbúa sig sem saklaus lömb, en eru hið innra sem gráðugir úlfar. ");
INSERT INTO isl_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Þið getið þekkt þá á afleiðingum orða þeirra og verka – á sama hátt og þið þekkið tré af ávöxtum þess. Það er óþarfi fyrir ykkur að ruglast á vínviði og þyrnirunna, eða á fíkjutré og þistlum. ");
INSERT INTO isl_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tré þekkist af ávöxtunum. ");
INSERT INTO isl_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tré sem ber ljúffenga ávexti, ber ekki óæta ávexti, og tré sem ber vonda ávexti, ber ekki góða á sama tíma. ");
INSERT INTO isl_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tré það, sem ber eintómt óæti, er rifið upp og notað í eldinn. ");
INSERT INTO isl_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Leiðin til að þekkja tré eða mann er að kanna ávextina. ");
INSERT INTO isl_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ekki eru allir guðræknir, sem tala guðrækilega. Þeir ávarpa mig: „Herra“ – en munu samt ekki komast til himins, heldur aðeins þeir sem gera það sem faðir minn á himnum vill að þeir geri. ");
INSERT INTO isl_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Margir munu segja við mig á dómsdegi: „Herra, herra, við sögðum fólkinu frá þér, við rákum út illa anda með þínu nafni og unnum mörg önnur mikil kraftaverk.“ ");
INSERT INTO isl_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ég mun svara þeim: „Ég hef aldrei þekkt ykkur né þið haft samfélag við mig. Farið burt, því verk ykkar eru vond.“ ");
INSERT INTO isl_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Þeir sem hlusta á orð mín og fara eftir þeim, líkjast hyggnum manni sem byggir húsið sitt á klöpp. ");
INSERT INTO isl_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Þó að rigni og vatnavextir verði, stormurinn æði og lemji húsið, mun það ekki haggast, því það er byggt á traustum grunni. ");
INSERT INTO isl_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Þeir sem heyrt hafa orð mín, en fara samt ekki eftir þeim, eru heimskir. Þeir eru eins og maður sem byggir húsið sitt á sandi. ");
INSERT INTO isl_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Og þegar stormurinn blæs og flóðbylgjan kemur æðandi og skellur á því, hrynur það með braki og brestum.“ ");
INSERT INTO isl_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Mannfjöldinn undraðist predikun Jesú, því að hann talaði af miklum myndugleika, eins og sá sem valdið hefur, en ekki eins og fræðimennirnir. ");
INSERT INTO isl_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Mikill mannfjöldi fylgdi Jesú þegar hann gekk niður fjallshlíðina að ræðunni lokinni. ");
INSERT INTO isl_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Og viti menn! Þá kom holdsveikur maður til hans. Hann kraup við fætur hans og sagði: „Herra, ef þú vilt getur þú læknað mig.“ ");
INSERT INTO isl_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús snerti manninn og sagði: „Ég vil að þú verðir heilbrigður!“ Og samstundis hvarf holdsveikin! ");
INSERT INTO isl_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesús sagði þá við hann: „Segðu engum frá þessu strax, en farðu rakleitt til prestsins og láttu hann skoða þig. Taktu með þér fórn þá sem lög Móse gera ráð fyrir að holdsveikir beri fram, þegar þeir læknast, sem opinbera staðfestingu þess að þú sért orðinn heilbrigður.“ ");
INSERT INTO isl_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Þegar Jesús kom til Kapernaum mætti hann rómverskum liðsforingja. Liðsforinginn skýrði frá því að þjónn hans lægi lamaður heima og honum liði illa. ");
INSERT INTO isl_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","„A ég að koma og lækna hann?“ spurði Jesús. ");
INSERT INTO isl_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","„Herra,“ sagði liðsforinginn, „ég er ekki verður þess að þú komir inn á heimili mitt (og það er reyndar ekki nauðsynlegt). Segðu aðeins núna: „Læknist þú!“ og þá mun þjónn minn verða heilbrigður! Þetta segi ég vegna þess að ég er settur undir vald æðri liðsforingja, en hef jafnframt sjálfur vald yfir mínum hermönnum. Ég segi við einn þeirra: „Farðu!“ og hann fer, og við annan: „Komdu!“ og hann kemur. Við þjón minn segi ég: „Gerðu þetta!“ og hann hlýðir skilyrðislaust. Þess vegna veit ég að þú hefur vald til að skipa þessum sjúkdómi að fara og hann mun fara!“ ");
INSERT INTO isl_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesús varð undrandi! Hann sneri sér að mannfjöldanum og sagði: „Hvergi í Ísrael hef ég fundið svo mikla trú! ");
INSERT INTO isl_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Og ég skal segja ykkur eitt: Margir útlendingar (eins og þessi rómverski liðsforingi) munu koma hvaðanæva að og sitja með Abraham, Ísak og Jakobi í konungsríki himnanna. ");
INSERT INTO isl_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Mörgum Ísraelsmönnum – já, einmitt þeim sem konungsríkið var ætlað – mun verða kastað út í myrkrið og þar verður grátið og kveinað.“ ");
INSERT INTO isl_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Síðan sagði Jesús við liðsforingjann: „Farðu heim til þín. Verði þér að trú þinni.“ Samstundis varð þjónninn heilbrigður! ");
INSERT INTO isl_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Eftir þetta fór Jesús heim til Péturs. Tengdamóðir Péturs lá þar með mikinn hita. ");
INSERT INTO isl_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesús snerti hönd hennar og við það hvarf hitinn. Hún reis á fætur og gaf þeim að borða. ");
INSERT INTO isl_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Um kvöldið voru færðir til Jesú menn sem höfðu illa anda. Hann rak illu andana út með einu orði og læknaði þá sem sjúkir voru. ");
INSERT INTO isl_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Þarna rættist spádómur Jesaja: „Sjúkdóma okkar og þjáningar tók hann á sig.“ ");
INSERT INTO isl_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Þegar Jesús sá að fólk dreif stöðugt að, sagði hann lærisveinunum að þeir skyldu búa sig undir að sigla yfir vatnið. ");
INSERT INTO isl_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Í sama mund sagði einn af fræðimönnum Gyðinga við hann: „Meistari, ég vil fylgja þér hvert sem þú ferð!“ ");
INSERT INTO isl_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús svaraði: „Refir eiga greni og fuglarnir hreiður, en ég, Kristur, á ekkert heimili – engan stað til að hvílast.“ ");
INSERT INTO isl_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Þá sagði annar úr hópi lærisveinanna: „Herra, þegar faðir minn er dáinn, skal ég fylgja þér.“ ");
INSERT INTO isl_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","„Fylgdu mér núna!“ sagði Jesús. „Láttu hina andlega dauðu annast sína dauðu.“ ");
INSERT INTO isl_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Síðan steig Jesús út í bátinn og hélt yfir vatnið ásamt lærisveinum sínum. ");
INSERT INTO isl_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Þá hvessti skyndilega svo að öldurnar gengu yfir bátinn, en Jesús svaf. ");
INSERT INTO isl_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Lærisveinarnir vöktu hann og hrópuðu: „Drottinn! Bjargaðu okkur Við erum að farast!“ ");
INSERT INTO isl_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","„Lítil er trú ykkar,“ svaraði Jesús. „Hvers vegna eruð þið hræddir?“ Síðan reis hann á fætur og hastaði á vindinn og öldurnar. Þá lægði vindinn og allt varð kyrrt! ");
INSERT INTO isl_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Lærisveinarnir voru orðlausir af undrun og ótta. „Hver er hann eiginlega?“ spurðu þeir hver annan, „vindurinn og vatnið hlýða honum!“ ");
INSERT INTO isl_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Þegar þeir komu að landi í byggðum Gadarena, komu á móti þeim tveir menn haldnir illum öndum. Menn þessir höfðu búið um sig í gröfunum og voru svo óðir að enginn þorði að fara þar um. ");
INSERT INTO isl_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Þeir hrópuðu nú til Jesú og sögðu: „Hvað vilt þú okkur, sonur Guðs? Þú hefur ekki enn leyfi til að tortíma okkur!“ ");
INSERT INTO isl_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Skammt þar frá var svínahjörð á beit. ");
INSERT INTO isl_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Illu andarnir báðu hann og sögðu: „Sendu okkur í svínin, ef þú ætlar að reka okkur út.“ ");
INSERT INTO isl_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","„Já, farið þangað,“ svaraði Jesús. Þá fóru þeir úr mönnunum, í svínin og öll hjörðin æddi fram af hengiflugi og drukknaði í vatninu. ");
INSERT INTO isl_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Þegar svínahirðarnir sáu þetta, flúðu þeir til næsta bæjar og sögðu frá því sem gerst hafði. ");
INSERT INTO isl_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Allir, sem þar bjuggu, flýttu sér út til að sjá Jesú, en eftir það báðu þeir hann að fara og láta sig í friði. ");
INSERT INTO isl_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesús steig því aftur út í bátinn og þeir héldu yfir vatnið til Kapernaum, heimabæjar hans. ");
INSERT INTO isl_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ekki var liðin löng stund er menn báru lamaðan mann til hans á dýnu. Þegar Jesús sá trú þeirra sagði hann við veika manninn: „Vertu hughraustur, vinur minn. Ég hef fyrirgefið þér syndirnar.“ ");
INSERT INTO isl_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","„Guðlast!“ hugsuðu fræðimenn Gyðinganna, sem þarna voru staddir. „Þessi maður heldur þó ekki að hann sé Guð?“ ");
INSERT INTO isl_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesús vissi hvað þeir hugsuðu og spurði því: „Hvers vegna hugsið þið illt? ");
INSERT INTO isl_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","Er erfiðara að fyrirgefa syndir mannsins en að lækna hann?“ Síðan sneri hann sér að lamaða manninum og sagði: „Ég segi við þig, til þess að sanna að ég hef vald hér á jörðu til þess að fyrirgefa syndir: Stattu upp! Taktu dýnuna þína og farðu heim til þín!“ ");
INSERT INTO isl_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Maðurinn spratt á fætur og flýtti sér heim! ");
INSERT INTO isl_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ótti greip fólkið þegar það sá kraftaverkið gerast þannig fyrir augum sér, og það lofaði Guð fyrir að hafa gefið manni slíkt vald. ");
INSERT INTO isl_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús lagði nú af stað niður veginn og sá þá Matteus, skattheimtumann, sitja hjá skattstofunni. „Komdu og vertu lærisveinn minn,“ sagði Jesús við hann. Matteus stóð þegar á fætur og fylgdi honum. ");
INSERT INTO isl_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Síðar voru Jesús og lærisveinar hans saman í boði (heima hjá Matteusi). Meðal gestanna voru margir sem höfðu illt orð á sér, svo sem alræmdir svindlarar. ");
INSERT INTO isl_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nú var faríseunum nóg boðið og þeir spurðu lærisveinana: „Hvers vegna umgengst meistari ykkar slíka menn?“ ");
INSERT INTO isl_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús varð fyrir svörum og sagði: „Vegna þess að heilbrigðir þurfa ekki læknishjálp, heldur hinir sjúku!“ ");
INSERT INTO isl_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Síðan bætti hann við: „Farið og reynið að skilja þetta biblíuvers: „Það eru ekki fórnir ykkar eða gjafir sem ég þrái – heldur að þið sýnið miskunnsemi.“ Ég kom til að leiða synduga menn til Guðs, en ekki réttláta.“ ");
INSERT INTO isl_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Dag einn komu lærisveinar Jóhannesar skírara til Jesú og spurðu: „Hvers vegna fasta lærisveinar þínir ekki? Það gerum við og farísearnir líka.“ ");
INSERT INTO isl_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","„Haldið þið að vinir brúðgumans séu hryggir og fastandi meðan hann er hjá þeim?“ spurði Jesús. „Að því kemur að ég verð tekinn frá þeim, og þá fá þeir nægan tíma til að fasta. ");
INSERT INTO isl_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Hver haldið þið að bæti gamla flík með efni sem á eftir að hlaupa? Bótin mundi rifna frá og gatið verða enn þá stærra en áður. ");
INSERT INTO isl_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Og hver notar gamla vínbelgi undir nýtt vín? Gömlu belgirnir láta undan þrýstingnum og springa, vínið fer allt niður og belgirnir eyðileggjast. Nei, við notum nýja belgi undir nýtt vín og þá varðveitist hvort tveggja.“ ");
INSERT INTO isl_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Rétt í þessu bar að forstöðumann samkomuhússins. Hann kraup að fótum Jesú og sagði: „Litla dóttir mín er nýdáin, en þú getur kallað hana aftur til lífsins ef þú vilt koma og snerta hana.“ ");
INSERT INTO isl_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Meðan Jesús og lærisveinar hans voru á leið heim til forstöðumannsins, ");
INSERT INTO isl_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","læddist kona sem þjáðst hafði af blæðingum í tólf ár, að baki honum og snerti fald yfirhafnar hans. ");
INSERT INTO isl_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Hún hugsaði: „Ef ég aðeins get snert hann, þá mun ég læknast!“ ");
INSERT INTO isl_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesús sneri sér við og sagði við hana: „Dóttir, vertu ekki kvíðin! Trú þín hefur læknað þig!“ Frá þeirri stundu var hún heilbrigð. ");
INSERT INTO isl_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Þegar Jesús gekk inn í hús forstöðumannsins og sá alla í uppnámi og heyrði útfarartónlistina, ");
INSERT INTO isl_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","sagði hann: „Út með allt þetta fólk! – Litla stúlkan er ekki dáin, hún sefur.“ Þá hló fólkið og gerði gys að orðum hans. ");
INSERT INTO isl_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Loksins tókst þó að koma fólkinu út. Jesús gekk að rúmi litlu stúlkunnar og tók í hönd hennar. Við það reis hún upp og varð heilbrigð á sömu stundu! ");
INSERT INTO isl_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Fréttir af þessu stórkostlega kraftaverki bárust um allt héraðið. ");
INSERT INTO isl_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tveir blindir menn eltu Jesú þegar hann yfirgaf hús forstöðumannsins og hrópuðu: „Sonur Davíðs konungs! Vertu okkur miskunnsamur!“ ");
INSERT INTO isl_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Þeir fóru alla leið inn í húsið þar sem hann dvaldist. Jesús spurði þá: „Trúið þið að ég geti gefið ykkur sjónina?“ „Já, herra“, svöruðu þeir, „við trúum því.“ ");
INSERT INTO isl_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Þá snerti hann augu þeirra og sagði: „Verði ykkur að trú ykkar.“ ");
INSERT INTO isl_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Á sömu stundu fengu þeir sjónina! Jesús bannaði þeim stranglega að segja frá þessu, ");
INSERT INTO isl_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","en eigi að síður báru þeir söguna um allan bæinn. ");
INSERT INTO isl_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Þegar Jesús var að fara þaðan mætti hann manni sem var mállaus vegna þess að illur andi var í honum. ");
INSERT INTO isl_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesús rak illa andann út og þá talaði mállausi maðurinn. Fólkið varð forviða og hrópaði: „Aldrei höfum við séð neitt þessu líkt!“ ");
INSERT INTO isl_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","En farísearnir sögðu: „Hann getur rekið illu andana út af því að hann er sjálfur með illan anda. Sjálfur Satan, konungur illu andanna, er í honum!“ ");
INSERT INTO isl_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús ferðaðist nú til allra bæja og þorpa á þessum slóðum. ");
INSERT INTO isl_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Hann kenndi í samkomuhúsum og flutti gleðiboðskapinn um guðsríkið. Hvar sem hann kom læknaði hann fólk af hvers konar sjúkdómum. Hann kenndi í brjósti um mannfjöldann sem til hans kom, því fólkið sá enga lausn á vanda sínum. Það var eins og hjörð án hirðis. ");
INSERT INTO isl_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jesús sagði þá við lærisveina sína: „Uppskeran er mikil en verkamennirnir fáir. ");
INSERT INTO isl_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Biðjið því hann, sem ræður uppskerunni, að senda fleiri verkamenn út á akrana.“ ");
INSERT INTO isl_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesús kallaði nú til sín tólf af lærisveinum sínum, gaf þeim vald til að reka út illa anda og lækna hvers konar sjúkdóma. ");
INSERT INTO isl_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Nöfn þessara tólf lærisveina eru: Símon (einnig kallaður Pétur), Andrés (bróðir Péturs), Jakob Sebedeusson, Jóhannes (bróðir Jakobs), Filippus, Bartólómeus, Tómas, Matteus (skattheimtumaðurinn), Jakob Alfeusson, Taddeus, Símon (en hann var meðlimur róttæks stjórnmálaflokks sem kallaðist Selótar) og Júdas Ískaríot (sá sem síðar sveik hann). ");
INSERT INTO isl_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús sendi þá af stað og gaf um leið þessi fyrirmæli: „Farið hvorki til heiðingja né Samverja. ");
INSERT INTO isl_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Farið aðeins til Ísraelsmanna – hinna týndu sauða Guðs þeirra á meðal. ");
INSERT INTO isl_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Segið þeim að ríki himnanna sé nálægt. ");
INSERT INTO isl_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Læknið sjúka og holdsveika, vekið upp dauða og rekið út illa anda. Gefið á sama hátt og þið hafið þegið! ");
INSERT INTO isl_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Takið ekki með ykkur peninga, ");
INSERT INTO isl_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","föt né skó til skiptanna og jafnvel ekki göngustaf. Þeir sem njóta hjálpar ykkar munu annast ykkur. ");
INSERT INTO isl_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Þegar þið komið inn í bæ eða þorp, reynið þá að finna einhvern sem er opinn fyrir Guði og gistið þar uns þið farið til næsta þorps. ");
INSERT INTO isl_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","13","Þegar þið beiðist gistingar þá blessið heimilið, sé það guðrækið, en ef ekki, haldið þá blessuninni fyrir sjálfa ykkur. ");
INSERT INTO isl_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ef eitthvert þorp eða heimili vill ekki taka við ykkur, dustið þá rykið af fótum ykkar um leið og þið farið þaðan. ");
INSERT INTO isl_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ég segi ykkur satt: Þeim stað mun verr farnast á dómsdegi en borgunum guðlausu, Sódómu og Gómorru. ");
INSERT INTO isl_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ég sendi ykkur sem lömb á meðal úlfa. Verið því kænir sem höggormar en falslausir sem dúfur. ");
INSERT INTO isl_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Gætið að! Þið munuð verða handteknir, yfirheyrðir og húðstrýktir í samkomuhúsunum. ");
INSERT INTO isl_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Þið verðið jafnvel að svara til saka frammi fyrir stjórnvöldum mín vegna. Þá fáið þið tækifæri til að segja þeim frá mér – vitna um mig frammi fyrir heiminum. ");
INSERT INTO isl_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Þegar þið verðið handteknir, hafið þá engar áhyggjur af því hvernig þið eigið að verja mál ykkar, því ykkur verða gefin rétt orð á réttum tíma. ");
INSERT INTO isl_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Það verða ekki þið sem talið, heldur mun andi föður ykkar á himnum tala í ykkur! ");
INSERT INTO isl_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Bróðir mun svíkja bróður sinn í dauðann og feður börn sín. Börn munu einnig rísa gegn foreldrum sínum til að lífláta þá! ");
INSERT INTO isl_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Allir munu hata ykkur vegna þess að þið tilheyrið mér, en þeir sem standa stöðugir allt til enda munu frelsast. ");
INSERT INTO isl_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Þegar þið mætið ofsóknum í einhverri borg, skuluð þið flýja til þeirrar næstu. Ég mun koma aftur áður en þið hafið náð til þeirra allra! ");
INSERT INTO isl_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Nemandi er ekki fremri kennara sínum. Og þjónninn er ekki settur yfir húsbónda sinn. ");
INSERT INTO isl_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nemandinn á hlutdeild í kjörum kennara síns og þjónninn húsbónda síns. En hvernig mun fara fyrir ykkur, fyrst ég, húsbóndinn, hef verið kallaður Satan? ");
INSERT INTO isl_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Óttist ekki þá sem hafa í hótunum við ykkur, því að sannleikurinn mun koma í ljós. ");
INSERT INTO isl_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Það sem ég segi ykkur í rökkrinu, skuluð þið kalla að morgni og það sem ég hvísla í eyru ykkar, skuluð þið hrópa á húsþökum! ");
INSERT INTO isl_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Óttist ekki þá sem aðeins geta deytt líkama ykkar, en megna ekki að skaða sálina. Óttist Guð, því að hann getur tortímt sál og líkama í helvíti. ");
INSERT INTO isl_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Vitið þið verðið á spörfuglum? Fást ekki tveir fyrir einn smápening? Ekki einn einasti þeirra fellur til jarðar án vitundar föður ykkar. ");
INSERT INTO isl_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Hann veit meira að segja hve hárin eru mörg á höfði ykkar! ");
INSERT INTO isl_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Verið því ekki kvíðafullir. Þið eruð dýrmætari í augum Guðs en margir spörfuglar. ");
INSERT INTO isl_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Hvern þann sem viðurkennir mig sem vin sinn fyrir mönnum mun ég viðurkenna sem vin minn fyrir föður mínum á himnum. ");
INSERT INTO isl_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","En hverjum þeim sem afneitar mér fyrir mönnum, mun ég afneita fyrir föður mínum á himnum. ");
INSERT INTO isl_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Haldið ekki að ég sé hér til að koma á friði á jörðu – nei, þvert á móti. ");
INSERT INTO isl_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ég kom til að gera son ósáttan við föður sinn, dóttur ósátta við móður sína og tengdadóttur við tengdamóður sína. ");
INSERT INTO isl_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Heimilismennirnir verða óvinir húsbónda síns. ");
INSERT INTO isl_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ef þið elskið föður ykkar eða móður meira en mig, þá eruð þið ekki verðir þess að tilheyra mér. Sama er að segja ef þið elskið son ykkar eða dóttur meira en mig. ");
INSERT INTO isl_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Sá sem ekki vill deyja sjálfum sér og fylgja mér er mín ekki verður. ");
INSERT INTO isl_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Sá sem vill njóta lífsins sjálfs sín vegna, mun glata því, en sá sem fórnar því mín vegna, mun bjarga því. ");
INSERT INTO isl_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Þeir sem taka við ykkur, taka við mér. Þegar þeir taka við mér, þá taka þeir við Guði sem sendi mig. ");
INSERT INTO isl_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ef þið takið á móti spámanni vegna þess að hann er maður Guðs, þá hljótið þið sömu laun og þeir. ");
INSERT INTO isl_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ef þið, lærisveinar mínir, gefið smælingja þó ekki sé nema glas af svaladrykk, þá mun ykkur vissulega verða launað fyrir það.“ ");
INSERT INTO isl_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Þegar Jesús hafði gefið lærisveinunum tólf þessi fyrirmæli hélt hann áfram að ferðast um og predika í bæjum og þorpum. ");
INSERT INTO isl_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jóhannes skírari sat um þessar mundir í fangelsi. Þegar hann frétti af kraftaverkunum, sem Kristur vann, sendi hann lærisveina sína til hans til að spyrja: ");
INSERT INTO isl_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","„Ert þú í raun og veru sá sem við höfum beðið eftir, eða eigum við að vænta annars?“ ");
INSERT INTO isl_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús svaraði þeim og sagði: „Farið og segið Jóhannesi frá kraftaverkunum sem þið hafið séð mig gera: ");
INSERT INTO isl_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ég hef læknað blinda og holdsveika, og þeir sem lamaðir voru ganga nú óstuddir. Heyrnarlausir heyra, dauðir lifna við og fátækum eru fluttar gleðifréttir. ");
INSERT INTO isl_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Segið honum líka: „Guð blessar þann sem dregur orð mín ekki í efa.“ “ ");
INSERT INTO isl_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Þegar lærisveinar Jóhannesar voru farnir, fór Jesús að tala um hann við mannfjöldann og sagði: „Hvað bjuggust þið við að sjá þegar þið fóruð út í eyðimörkina til Jóhannesar? Strá, skekið af vindi? ");
INSERT INTO isl_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Eða áttuð þið von á að sjá mann klæddan konungsskrúða? ");
INSERT INTO isl_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Eða spámann Guðs? Já, hann er meira en spámaður. ");
INSERT INTO isl_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Hann er sá sem sagt var fyrir um í Biblíunni: „boðberinn sem tilkynnti komu mína og bjó fólk undir að taka á móti mér.“ ");
INSERT INTO isl_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ég segi ykkur satt: Enginn þeirra manna, sem enn hafa fæðst, jafnast á við Jóhannes skírara, þó eru hinir minnstu í himnaríki honum meiri! ");
INSERT INTO isl_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Frá þeirri stundu er Jóhannes skírari hóf að predika og skíra hafa menn viljað ná guðsríki undir sig með valdi. ");
INSERT INTO isl_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Lög Móse og spámennirnir sögðu fyrir um þetta. Síðan kom Jóhannes og sagði það sama. ");
INSERT INTO isl_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ef þið viljið skilja mig rétt, þá er hann sá Elía sem spámennirnir sögðu að koma mundi (áður en guðsríki kæmi). ");
INSERT INTO isl_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ef þið viljið hlusta, takið þá eftir því sem ég segi nú: ");
INSERT INTO isl_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Hvað á ég að segja um þessa þjóð? Hún er eins og börn að leik, sem segja við félaga sína: ");
INSERT INTO isl_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","„Við lékum brúðkaupslag, en þið glöddust ekki, þá lékum við sorgarlag, en samt grétuð þið ekki!“ ");
INSERT INTO isl_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jóhannes skírari drakk ekki vín og fastaði oft. Þá sögðu menn: „Hann er geðveikur!“ ");
INSERT INTO isl_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","En ef ég, Kristur, tek þátt í veislum og drekk, þá er kvartað og ég kallaður átvagl, vínsvelgur og vinur stórsyndara! – Slíkum vitringum finnst allt rétt sem þeir gera sjálfir!“ ");
INSERT INTO isl_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Þá tók hann að ávíta borgirnar, þar sem hann hafði gert flest kraftaverkin, því þær höfðu ekki snúið sér til Guðs. Hann sagði: ");
INSERT INTO isl_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","„Ég kalla dóm yfir þig Kórasín og þig Betsaída! Ef kraftaverk þau sem ég hef gert á strætum ykkar, hefðu gerst í Týrus og Sídon, þá hefðu þær fyrir löngu iðrast og auðmýkt sig. ");
INSERT INTO isl_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Betur mun fara fyrir Týrus og Sídon á dómsdegi en ykkur. ");
INSERT INTO isl_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kapernaum, þér hlotnaðist mikill heiður, en þér verður eytt! Ef öll kraftaverkin, sem ég hef gert í þér, hefðu gerst í Sódómu, stæði hún enn í dag. ");
INSERT INTO isl_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Því segi ég að betur mun fara fyrir Sódómu á degi dómsins en þér, Kapernaum!“ ");
INSERT INTO isl_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Um þetta leyti bað Jesús þessarar bænar: „Þökk sé þér, faðir, Drottinn himins og jarðar, að þú hefur opinberað börnum það sem þú huldir spekingum og fræðimönnum. ");
INSERT INTO isl_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Já, faðir, þannig vildir þú hafa það.“ ");
INSERT INTO isl_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","„Faðir minn hefur falið mér að gera allt sem ég geri. Faðirinn einn gjörþekkir soninn og sonurinn einn þekkir föðurinn, svo og þeir sem sonurinn hefur opinberað hann. ");
INSERT INTO isl_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Komið til mín, allir þið sem erfiðið og berið þungar byrðar, og ég mun veita ykkur hvíld. ");
INSERT INTO isl_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Takið á ykkur ok mitt og lærið af mér, ég er lítillátur og auðmjúkur. Þá munuð þið finna sálum ykkar hvíld. Mitt ok er indælt og byrði mín létt.“ ");
INSERT INTO isl_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Um þetta leyti gekk Jesús á helgidegi yfir kornakur ásamt lærisveinum sínum. Lærisveinarnir voru svangir, svo að þeir týndu nokkur hveitiöx og átu kornið sem í þeim var. ");
INSERT INTO isl_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farísear sem þar voru og sáu til þeirra, sögðu við Jesú: „Sérðu ekki að lærisveinar þínir eru að brjóta lögin? Þetta er bannað að gera á helgidegi!“ ");
INSERT INTO isl_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","En Jesús svaraði þeim: „Hafið þið aldrei lesið hvað Davíð konungur gerði þegar hann og menn hans fundu til hungurs? ");
INSERT INTO isl_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Hann fór inn í guðshús ásamt mönnum sínum og át brauðið sem prestunum einum var heimilt að borða. Það var einnig lagabrot. ");
INSERT INTO isl_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Hafið þið aldrei lesið í lögum Móse að prestarnir, sem gegna þjónustu í musterinu, verða að vinna störf sín á helgidögum jafnt sem aðra daga. ");
INSERT INTO isl_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ég segi: Hér á í hlut sá sem er meiri en musterið. ");
INSERT INTO isl_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Þið hefðuð ekki dæmt þessa saklausu menn, ef þið skilduð hvað þessi orð þýða: „Miskunnsemi met ég meira en fórn“. ");
INSERT INTO isl_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ég, Kristur, er herra hvíldardagsins.“ ");
INSERT INTO isl_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesús lagði nú leið sína til samkomuhússins. ");
INSERT INTO isl_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Þar var staddur maður með bæklaða hönd. Farísearnir spurðu Jesú: „Er leyfilegt að lækna á hvíldardegi?“ (Þeir vonuðu auðvitað að hann mundi svara „já“ svo að þeir hefðu tilefni til að handtaka hann.) ");
INSERT INTO isl_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Hann svaraði: „Ef einhver ætti aðeins eina kind og hún félli í skurð á helgidegi, mundi hann þá ekki leggja það á sig að bjarga henni þótt helgidagur væri? Auðvitað! ");
INSERT INTO isl_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Og er maður ekki meira virði en sauðkind? Þar af leiðir: Það er leyfilegt að vinna góð verk á helgidegi.“ ");
INSERT INTO isl_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Síðan sagði hann við manninn: „Réttu fram hönd þína.“ Maðurinn gerði það og um leið varð hönd hans heil! ");
INSERT INTO isl_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Farísearnir skutu þegar á fundi og gerðu samsæri um að handtaka Jesú og lífláta hann. ");
INSERT INTO isl_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús vissi um áform þeirra og yfirgaf því samkomuhúsið, og fóru margir með honum. Hann læknaði alla sem sjúkir voru meðal þeirra, ");
INSERT INTO isl_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","en varaði þá jafnframt við að bera út fréttir um kraftaverk hans. ");
INSERT INTO isl_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Þar með rættist spádómur Jesaja um hann: ");
INSERT INTO isl_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","„Takið eftir þjóni mínum, sem ég hef útvalið! Ég elska hann og hef yndi af honum. Ég mun gefa honum anda minn og hann mun dæma þjóðirnar. ");
INSERT INTO isl_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Hann beitir engan ofríki og fer ekki með háreysti. ");
INSERT INTO isl_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Hann brýtur ekki hið veika strá og ógnar ekki hinu ístöðulitla. Sigur hans mun stöðva allt misrétti og ranglæti ");
INSERT INTO isl_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","og á hann munu þjóðirnar treysta.“ ");
INSERT INTO isl_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Þá var komið til hans með mann sem var bæði blindur og mállaus og þjáðist af illum anda. Jesús læknaði manninn og hann fékk bæði sjón og mál á ný. ");
INSERT INTO isl_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Þá hrópaði fólkið: „Getur verið að þessi Jesús sé Kristur?!“ ");
INSERT INTO isl_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Þegar farísearnir heyrðu um kraftaverkið sögðu þeir: „Hann rekur út illa anda með aðstoð Satans, foringja illu andanna.“ ");
INSERT INTO isl_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús skynjaði hugsanir þeirra og sagði: „Ríki sem er sundrað hlýtur að leggjast í auðn. Borg eða heimili, þar sem allt logar í ófriði, fær ekki staðist. ");
INSERT INTO isl_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ef Satan rekur Satan út, er hann að berjast gegn sjálfum sér og sundra ríki sínu. Ef ég beiti valdi Satans til að reka út illa anda, ");
INSERT INTO isl_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","með hvaða krafti rekur þá ykkar fólk þá út? Svari það ásökun ykkar! ");
INSERT INTO isl_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","En ef ég rek illa anda út með mætti Guðs, þá er ríki hans komið á meðal ykkar. ");
INSERT INTO isl_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Enginn kemst inn í hús voldugs manns og rænir eigum hans nema binda hann fyrst. Eins er með ríki Satans, sé hann bundinn er hægt að reka illu andana út. ");
INSERT INTO isl_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Sá sem ekki vinnur með mér vinnur gegn mér. ");
INSERT INTO isl_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Háð gegn mér er unnt að fyrirgefa og einnig allar aðrar syndir, nema eina: Lastmæli gegn heilögum anda verður aldrei fyrirgefið, hvorki í þessum heimi né hinum komandi. ");
INSERT INTO isl_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Tré þekkist af ávexti sínum. Tré af valinni tegund ber góðan ávöxt, en léleg tegund vondan ávöxt. ");
INSERT INTO isl_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Þið höggormsafkvæmi! Hvernig ættu vondir menn eins og þið að geta talað máli góðsemi og réttlætis? Hugarfar mannsins ákveður orð hans. ");
INSERT INTO isl_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Góður maður ber vitni um gott innræti með orðum sínum, en vondur maður tjáir illt innræti með tali sínu. ");
INSERT INTO isl_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Eitt er víst: Á degi dómsins verðið þið að gera grein fyrir hverju ónytjuorði sem þið hafið sagt. ");
INSERT INTO isl_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Orð þau, sem þið mælið nú, ákveða örlög ykkar þá. Annað hvort munu þau sýkna ykkur eða sakfella.“ ");
INSERT INTO isl_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Þá svöruðu nokkrir fræðimenn og farísear honum og sögðu: „Sýndu okkur kraftaverk.“ Með kraftaverkinu átti Jesús að sanna að hann væri Kristur. ");
INSERT INTO isl_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","40","Jesús svaraði: „Aðeins vont og vantrúað fólk heimtar slíkar sannanir. Reynsla Jónasar spámanns á að vera ykkur nægileg sönnun. Jónas var þrjá sólarhringa í stórfiskinum, og ég, Kristur, mun sömuleiðis verða þrjá daga í skauti jarðarinnar. ");
INSERT INTO isl_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Á degi dómsins munu íbúar Niníve rísa upp gegn þessari þjóð og dæma hana. Þegar Jónas áminnti þá, iðruðust þeir og sneru sér frá syndum sínum til Guðs. Hér stendur sá sem æðri er Jónasi, en samt viljið þið ekki trúa honum! ");
INSERT INTO isl_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Drottningin af Saba mun rísa upp í dóminum, tala gegn þessari þjóð og dæma hana seka. Hún kom frá fjarlægu landi til að hlýða á speki Salómons, en hér stendur sá sem er æðri en Salómon, og þið neitið að trúa honum.“ ");
INSERT INTO isl_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","45","„Þessi þjóð er líkt og haldin illum anda! Þegar illur andi er farinn úr manni, fer hann út í eyðimörkina um stund og leitar hvíldar, en án árangurs og því segir hann: „Ég vil fara aftur í manninn sem ég var í.“ Þá fer hann og finnur sjö aðra anda, sér verri. Þeir fara síðan og búa um sig í manninum, og ástand hans verður verra en áður.“ ");
INSERT INTO isl_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","47","Meðan Jesús var að tala, kom móðir hans og bræður að útidyrunum og vildu fá að hitta hann (en þau komust ekki inn vegna þrengsla). ");
INSERT INTO isl_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Þegar honum var sagt frá þessu spurði hann: „Hver er móðir mín? Hverjir eru bræður mínir?“ ");
INSERT INTO isl_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Því næst benti hann á lærisveina sína og sagði: „Sjáið! Þarna er móðir mín og bræður.“ ");
INSERT INTO isl_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Síðan bætti hann við: „Hver sá sem hlýðir föður mínum á himnum er bróðir minn, systir og móðir.“ ");
INSERT INTO isl_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Síðar sama dag fór Jesús að heiman og settist við vatnið, ");
INSERT INTO isl_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","3","þar safnaðist að honum mikill mannfjöldi. Hann steig út í bát og kenndi þaðan, en fólkið stóð á ströndinni og hlustaði. Hann sagði margar dæmisögur, þar á meðal þessa: „Bóndi sáði korni í akur sinn. ");
INSERT INTO isl_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Meðan hann var að sá féll sumt af sáðkorninu við götuna og fuglar komu og átu það upp. ");
INSERT INTO isl_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Sumt féll í grýtta jörð þar sem gróðurmold var lítil. Það óx fljótt, ");
INSERT INTO isl_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","en þegar brennheit sólin skein, skrælnaði það og dó, því ræturnar voru litlar. ");
INSERT INTO isl_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Sumt lenti meðal þyrna sem uxu upp og kæfðu það. ");
INSERT INTO isl_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","En sumt féll í góða jörð og bar þrítugfalda, sextugfalda og jafnvel hundraðfalda uppskeru. ");
INSERT INTO isl_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Þetta skuluð þið muna!“ ");
INSERT INTO isl_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Lærisveinar Jesú komu til hans og spurðu: „Hvers vegna notar þú þessar flóknu dæmisögur þegar þú talar til fólks?“ ");
INSERT INTO isl_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Þá sagði hann, að lærisveinunum einum væri ætlað að öðlast skilning á ríki himnanna, öðrum ekki. ");
INSERT INTO isl_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","13","„Þeim sem hefur“ sagði hann, „mun verða gefið enn meira, en frá þeim sem ekkert á, mun jafnvel verða tekið það litla sem hann hefur. Ég nota þessar líkingar til að fólkið heyri og sjái, en skilji ekki. ");
INSERT INTO isl_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Þannig rætast þessi orð Jesaja: „Þeir heyra, en skilja ekki, þeir horfa, en sjá ekki. ");
INSERT INTO isl_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Hugurinn er sljór og heyrnin dauf. Þeir sofa og sjá því hvorki né heyra það sem gæti veitt þeim skilning og leitt þá aftur til Guðs svo þeir hlytu lækningu.“ ");
INSERT INTO isl_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","En ykkar augu eru blessuð, því þau sjá, og eyru ykkar eru líka blessuð, því þau hlusta. ");
INSERT INTO isl_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Margir spámenn og trúað fólk þráði að sjá það sem þið sjáið og heyra það sem þið heyrið, en fengu það ekki.“ ");
INSERT INTO isl_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","„Merking sögunnar, sem ég sagði ykkur áðan um bóndann sem var að sá, er þessi: ");
INSERT INTO isl_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Gatan, þar sem sumt af sáðkorninu féll, táknar hjarta manns sem heyrir gleðitíðindin um guðsríki, en skilur þau ekki. Þá kemur Satan og rænir því, sem sáð var í hjarta hans. ");
INSERT INTO isl_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Grunni, grýtti jarðvegurinn táknar hjarta þess sem heyrir boðskapinn og tekur strax við honum með miklum fögnuði. ");
INSERT INTO isl_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Honum er þó ekki mikil alvara og fræið nær ekki að skjóta djúpum rótum. Síðar þegar erfiðleikar eða trúarofsóknir herja, missir hann allan áhuga. ");
INSERT INTO isl_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Jarðvegurinn þar sem þyrnarnir uxu, táknar mann sem heyrir boðskapinn, en lætur áhyggjur lífsgæðakapphlaupsins kæfa orð Guðs, og fjarlægist Guð smátt og smátt. ");
INSERT INTO isl_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Frjósami jarðvegurinn táknar þann mann sem hlustar á boðskapinn, skilur hann, fer af stað og leiðir þrjátíu, sextíu eða jafnvel hundrað aðra inn í ríki Guðs.“ ");
INSERT INTO isl_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Hann sagði þeim einnig þessa dæmisögu: „Himnaríki er líkt bónda sem sáði góðu sæði í akur sinn. ");
INSERT INTO isl_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nótt eina, meðan hann svaf, kom óvinur hans og sáði illgresi meðal hveitisins. ");
INSERT INTO isl_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Þegar hveitið kom upp, kom illgresið einnig upp. ");
INSERT INTO isl_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Vinnumenn bóndans komu til hans og sögðu: „Húsbóndi! Akurinn, sem þú sáðir góða hveitinu í, er fullur af illgresi.“ ");
INSERT INTO isl_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","„Því hefur einhver óvinur sáð,“ svaraði bóndinn. „Eigum við að reyta illgresið?“ spurðu þeir. ");
INSERT INTO isl_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","„Nei,“ svaraði hann, „því þá gætuð þið einnig slitið hveitið upp. ");
INSERT INTO isl_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Látið hvort tveggja vaxa til uppskerutímans, og þá mun ég segja kornskurðarmönnunum að skilja illgresið frá og brenna það, en setja hveitið í hlöðuna“.“ ");
INSERT INTO isl_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","„Hér er enn ein líking. Ríki himnanna er líkt örsmáu sinnepsfræi sem sáð var í akur. Það er allra sáðkorna minnst, en plantan verður þó hæst allra kryddjurta og verður að tré, þar sem fuglar leita sér skjóls.“ ");
INSERT INTO isl_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesús sagði þeim einnig þessa dæmisögu: „Himnaríki er líkt konu sem bakaði brauð. Fyrst mældi hún mjöl, síðan bætti hún geri í og hnoðaði uns gerið hafði gegnsýrt deigið.“ ");
INSERT INTO isl_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesús notaði ávallt slíkar dæmisögur þegar hann talaði við fólkið og það gerði hann í ákveðnum tilgangi. Spámennirnir höfðu reyndar sagt fyrir að hann myndi nota líkingar. Spádómur þeirra var á þessa leið: ");
INSERT INTO isl_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","„Ég mun tala í dæmisögum. Ég mun útskýra leyndardóma sem legið hafa í þagnargildi frá örófi alda.“ ");
INSERT INTO isl_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesús yfirgaf nú fólkið og gekk inn í hús. Lærisveinar hans báðu hann þá að útskýra líkinguna um illgresið og hveitið. ");
INSERT INTO isl_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","„Það skal ég gera,“ sagði hann. „Ég er bóndinn sem sáir góða sæðinu. ");
INSERT INTO isl_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Akurinn er allur heimurinn. Góða sæðið eru börn guðsríkisins. Illgresið er fólk sem fylgir óvininum. ");
INSERT INTO isl_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Óvinurinn, sem sáði illgresinu meðal hveitisins, er Satan. Uppskerutíminn er dómsdagur. Kornskurðarmennirnir eru englar. ");
INSERT INTO isl_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Eins og illgresi er brennt, eins mun fara við endi veraldar. ");
INSERT INTO isl_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ég mun senda engla mína til að skilja frá alla vonda menn og allt sem veldur synd, ");
INSERT INTO isl_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","varpa á bál og brenna. Þar mun verða grátið og kveinað. ");
INSERT INTO isl_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","En börn Guðs munu ljóma eins og sólin í ríki föðurins. Takið vel eftir þessu!“ ");
INSERT INTO isl_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","„Ríki himnanna er líkt fjársjóði sem maður fann í akri einum. Í ákafa sínum seldi hann allt sem hann átti, til að geta keypt akurinn – og náð fjársjóðnum!“ ");
INSERT INTO isl_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","„Himnaríki er einnig líkt perlukaupmanni, sem leitaði að dýrum perlum. ");
INSERT INTO isl_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Hann gerði góð kaup þegar hann fann afar verðmæta perlu, seldi allar eigur sínar og keypti hana.“ ");
INSERT INTO isl_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","48","„Guðsríki má enn líkja við fiskimann. Hann kastar neti út í vatnið og veiðir í það fisk af ýmsum tegundum, bæði verðmætum og verðlausum. Þegar netið er orðið fullt dregur hann það á land og safnar ætu fiskunum saman, en fleygir hinum. ");
INSERT INTO isl_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Þannig fer líka á dómsdegi. Englar munu koma, skilja hina óguðlegu frá hinum trúuðu og ");
INSERT INTO isl_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","kasta hinum óguðlegu á bálið. Þar verður grátið og kveinað. ");
INSERT INTO isl_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Skiljið þið þetta?“ spurði Jesús. „Já,“ svöruðu þeir. ");
INSERT INTO isl_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Þá bætti hann við og sagði: „Þeir sem vel eru að sér í Guðs orði og hafa gjörst lærisveinar mínir, eiga fjársjóð sem geymir bæði gamla og nýja þekkingu.“ ");
INSERT INTO isl_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Þegar Jesús hafði sagt þessar dæmisögur, sneri hann aftur til Nasaret í Galíleu (þar sem hann hafði átt heima.) Hann kenndi í samkomuhúsinu og fólk undraðist visku hans og máttarverk. „Hvernig stendur á þessu?!“ hrópaði það. ");
INSERT INTO isl_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","„Er þetta ekki sonur smiðsins? Við þekkjum móður hans, Maríu, bræður hans, Jakob, Jósef, Símon og Júdas, ");
INSERT INTO isl_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","og systur hans eru hér allar. Hvaðan hefur hann þetta vald?“ ");
INSERT INTO isl_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Þeir hneyksluðust á honum. Þá sagði Jesús við þá: „Hvergi er spámaður minna metinn en á heimili sínu og meðal eigin fólks!“ Hann gerði fá kraftaverk þar vegna vantrúar þeirra. ");
INSERT INTO isl_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Þegar Heródes konungur frétti um Jesú, ");
INSERT INTO isl_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","sagði hann við menn sína: „Þessi Jesús hlýtur að vera Jóhannes skírari, risinn upp frá dauðum, ");
INSERT INTO isl_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","fyrst hann gerir öll þessi kraftaverk.“ Heródes hélt Jóhannesi hlekkjuðum í fangelsi að kröfu Heródíasar, konu Filippusar bróður síns, ");
INSERT INTO isl_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","en Jóhannes hafði ávítað Heródes fyrir að taka hana frá honum og kvænast henni sjálfur. ");
INSERT INTO isl_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Heródes hefði látið taka Jóhannes af lífi fyrir löngu, ef hann hefði ekki óttast uppþot, því almenningur trúði að Jóhannes væri spámaður. ");
INSERT INTO isl_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Á afmælisdegi Heródesar dansaði dóttir Heródíasar fyrir hann og líkaði honum það svo vel ");
INSERT INTO isl_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","að hann hét að gefa henni hvað sem hún vildi að launum. ");
INSERT INTO isl_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Að ósk móður sinnar bað stúlkan um höfuð Jóhannesar á fati. ");
INSERT INTO isl_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Konungurinn varð hryggur, en hann vildi ekki ganga á bak orða sinna í áheyrn gestanna og gaf því skipun um að þetta skyldi gert. ");
INSERT INTO isl_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Jóhannes var hálshöggvinn í fangelsinu, ");
INSERT INTO isl_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","og stúlkunni fært höfuð hans á fati. Hún afhenti síðan móður sinni það. ");
INSERT INTO isl_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Lærisveinar Jóhannesar sóttu líkið og greftruðu, sögðu síðan Jesú frá atburðinum. ");
INSERT INTO isl_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Þegar Jesús fékk fréttirnar hélt hann, á bátnum, á óbyggðan stað til þess að geta verið einn. Þegar fólkið sá hvert hann fór, streymdi það þangað landleiðina úr þorpunum. ");
INSERT INTO isl_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Þegar Jesús steig á land beið hans mikill mannfjöldi. Hann vorkenndi fólkinu og læknaði þá sem sjúkir voru. ");
INSERT INTO isl_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Um kvöldið komu lærisveinarnir til hans og sögðu: „Það er löngu kominn kvöldverðartími, en hér í óbyggðinni er engan mat að fá. Sendu fólkið burt, svo að það geti farið til þorpanna og keypt sér mat.“ ");
INSERT INTO isl_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","„Það er óþarfi,“ svaraði Jesús, „þið skuluð gefa því að borða!“ ");
INSERT INTO isl_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","„Ha, við!“ hrópuðu þeir. „Við eigum aðeins fimm brauð og tvo fiska.“ ");
INSERT INTO isl_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","„Komið með það hingað,“ sagði Jesús, ");
INSERT INTO isl_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","og því næst sagði hann fólkinu að setjast niður í grasið. Hann tók brauðin fimm og fiskana, horfði til himins og þakkaði Guði fyrir matinn. Þegar hann hafði brotið brauðin í sundur, rétti hann lærisveinunum þau og þeir skiptu þeim meðal fólksins. ");
INSERT INTO isl_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Allir urðu mettir! Eftir á fylltu þeir tólf körfur með brauðmolum sem af gengu! ");
INSERT INTO isl_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","(Um 5.000 karlmenn voru þarna þennan dag, auk kvenna og barna.) ");
INSERT INTO isl_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Strax að þessu loknu sagði Jesús lærisveinunum að fara um borð í bátinn og sigla yfir vatnið, á meðan ætlaði hann að koma fólkinu frá sér. ");
INSERT INTO isl_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","24","Þegar fólkið var farið, fór hann upp á fjallið til að biðjast fyrir. Nóttin skall á og lærisveinarnir áttu í erfiðleikum úti á miðju vatninu. Það hafði hvesst og þeir áttu fullt í fangi með að verja bátinn áföllum. ");
INSERT INTO isl_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Um fjögurleytið kom Jesús til þeirra gangandi á vatninu! ");
INSERT INTO isl_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Þeir æptu af skelfingu, því þeir héldu að þetta væri vofa. ");
INSERT INTO isl_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","En þá kallaði Jesús til þeirra og sagði: „Verið óhræddir, þetta er ég!“ ");
INSERT INTO isl_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Þá hrópaði Pétur til hans og sagði: „Herra, ef þetta ert þú, leyfðu mér þá að koma til þín.“ ");
INSERT INTO isl_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","„Já, gerðu það. Komdu!“ svaraði Jesús. Pétur steig þá yfir borðstokkinn og gekk á vatninu í átt til Jesú. ");
INSERT INTO isl_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","En þegar Pétur sá öldurótið varð hann skelkaður og tók að sökkva. „Jesús, bjargaðu mér!“ hrópaði hann. ");
INSERT INTO isl_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesús rétti honum samstundis höndina og dró hann upp. „Þú hefur litla trú,“ sagði Jesús. „Af hverju efaðist þú?“ ");
INSERT INTO isl_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Veðrið lægði um leið og þeir stigu í bátinn. ");
INSERT INTO isl_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Hinir sem í bátnum voru sögðu þá fullir ótta og lotningar: „Þú ert sannarlega sonur Guðs!“ ");
INSERT INTO isl_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Þegar þeir komu að landi í Genesaret, ");
INSERT INTO isl_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","fréttist jafnskjótt um allan bæinn að þeir væru komnir. Fólk fór um allt og hvatti aðra til að fara með sjúklinga til hans. ");
INSERT INTO isl_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Þeir sem veikir voru báðu hann að leyfa sér að snerta, þó ekki væri nema faldinn á yfirhöfn hans, og allir sem það gerðu læknuðust. ");
INSERT INTO isl_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nokkrir farísear og lögfræðingar komu frá Jerúsalem að ræða við Jesú. ");
INSERT INTO isl_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","„Hvers vegna fara lærisveinar þínir ekki eftir siðum þjóðar okkar?“ spurðu þeir valdsmannslega, og bættu síðan við: „Þeir virða til dæmis ekki regluna um að þvo sér um hendur fyrir máltíðir.“ ");
INSERT INTO isl_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","„En hvers vegna eru þessar siðvenjur ykkar í andstöðu við boðorð Guðs?“ spurði Jesús á móti. ");
INSERT INTO isl_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","„Eitt af boðorðum Guðs er þannig: „Heiðra skaltu föður þinn og móður, hver sá sem formælir foreldrum sínum er dauðasekur.“ ");
INSERT INTO isl_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Þið segið hins vegar: „Þótt foreldrar þínir þarfnist hjálpar, máttu gefa musterinu það fé sem þú hefur lagt til hliðar handa þeim.“ Með þessu mannaboðorði ónýtið þið þá skipun Guðs að menn heiðri og annist foreldra sína. ");
INSERT INTO isl_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Hræsnarar! Orð Jesaja eiga við um ykkur: ");
INSERT INTO isl_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","„Þessir menn heiðra mig með vörunum en hjarta þeirra er langt í burtu frá mér. ");
INSERT INTO isl_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Trúrækni þeirra er gagnslaus, því þeir kenna sín eigin boðorð í stað boðorða Guðs!“ “ ");
INSERT INTO isl_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Síðan hrópaði Jesús til mannfjöldans og sagði: „Hlustið á og reynið að skilja þetta: ");
INSERT INTO isl_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Þið saurgist ekki af matnum sem þið neytið, heldur af orðum ykkar og hugsunum!“ ");
INSERT INTO isl_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Þá komu lærisveinar hans til hans og sögðu: „Þú móðgaðir faríseana með því sem þú sagðir.“ ");
INSERT INTO isl_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Jesús svaraði: „Hver sú jurt sem ekki er gróðursett af föður mínum, verður slitin upp með rótum. Látið þá afskiptalausa. Þeir eru blindir leiðtogar, ef blindur leiðir blindan, falla báðir í sömu gryfjuna.“ ");
INSERT INTO isl_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Þá bað Pétur Jesú að útskýra hvers vegna fólk saurgaðist ekki við að borða mat sem lögin teldu óhreinan. ");
INSERT INTO isl_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","„Skilurðu það ekki?“ spurði Jesús. ");
INSERT INTO isl_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","„Veistu ekki að það sem við borðum fer í gegnum meltingarfærin og síðan úr líkamanum? ");
INSERT INTO isl_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ljót orð koma hins vegar frá illu innræti og spilla þeim sem segir þau. ");
INSERT INTO isl_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Illar hugsanir, morð, hórdómur, saurlifnaður, þjófnaður, lygi og illt umtal, allt á þetta upphaf sitt í huga og sál mannsins. ");
INSERT INTO isl_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Það er þetta sem mengar mannlífið. Það er ekki syndsamlegt að neyta matar með óþvegnum höndum.“ ");
INSERT INTO isl_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesús hélt síðan burt og fór norður til Týrusar og Sídonar, en þangað voru um 80 kílómetrar. ");
INSERT INTO isl_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kanversk kona, sem þar bjó, kom til Jesú og sagði: „Hjálpaðu mér Drottinn, sonur Davíðs konungs! Dóttir mín er með illan anda, sem kvelur hana dag og nótt.“ ");
INSERT INTO isl_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesús svaraði henni engu orði. Lærisveinarnir hvöttu hann til að vísa henni burt og sögðu: „Segðu henni að fara, hún ónáðar með þessu kvabbi.“ ");
INSERT INTO isl_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesús sagði þá við konuna: „Ég var sendur til að hjálpa Gyðingum, en ekki heiðingjum.“ ");
INSERT INTO isl_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Þá kom hún enn nær, hneigði sig og bað á nýjan leik: „Drottinn, hjálpaðu mér!“ ");
INSERT INTO isl_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","„Það er ekki rétt að taka brauðið frá börnunum og gefa það hvolpunum,“ sagði Jesús. ");
INSERT INTO isl_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","„Satt er það,“ sagði hún, „en hvolparnir fá þó að tína molana sem falla á gólfið.“ ");
INSERT INTO isl_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","„Kona,“ sagði Jesús, „þú hefur mikla trú og þú skalt fá það sem þú baðst um.“ Dóttir hennar varð heilbrigð á sömu stundu. ");
INSERT INTO isl_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Eftir þetta fór Jesús aftur að Galíleuvatni. Þar gekk hann upp á fjall og settist niður. ");
INSERT INTO isl_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mannfjöldinn kom til hans með lamaða menn, blinda og mállausa, einnig marga aðra sjúklinga. Þeir lögðu þá við fætur Jesú og hann læknaði þá alla. ");
INSERT INTO isl_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Þetta var stórkostleg sjón! Þeir sem mállausir höfðu verið frá fæðingu töluðu nú reiprennandi. Þeir sem höfðu verið lamaðir gengu um og hlupu. Þeir sem voru blindir áður, horfðu nú furðu lostnir í kringum sig! Allir voru glaðir og undrandi og lofuðu Guð Ísraels. ");
INSERT INTO isl_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Þá kallaði Jesús á lærisveina sína og sagði: „Ég finn til með þessu fólki. Það hefur verið hér í þrjá daga samfleytt, og nú er það orðið matarlaust. Ég vil ekki senda það frá mér þannig á sig komið, því þá örmagnast það á leiðinni heim.“ ");
INSERT INTO isl_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","„Hvernig eigum við að útvega mat hér í óbyggðinni handa öllum þessum fjölda?“ spurðu lærisveinarnir. ");
INSERT INTO isl_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","„Hvað tókuð þið mikið með ykkur?“ spurði Jesús. „Sjö brauð og nokkra smáfiska,“ svöruðu þeir. ");
INSERT INTO isl_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jesús bauð þá fólkinu að setjast niður. ");
INSERT INTO isl_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Síðan tók hann brauðin og fiskana, og þakkaði Guði. Að því búnu skipti hann matnum í skammta, sem lærisveinarnir báru til fólksins. ");
INSERT INTO isl_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","38","Allir fengu nóg, 4.000 karlmenn auk kvenna og barna! Þegar leifunum hafði verið safnað saman, fylltu þær sjö körfur! ");
INSERT INTO isl_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Eftir þetta sendi Jesús fólkið heim, sjálfur fór hann í bátnum yfir til Magadanhéraðs. ");
INSERT INTO isl_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Dag nokkurn komu farísear og saddúkear til Jesú og vildu sannprófa þá fullyrðingu hans að hann væri Kristur. Þeir báðu hann að sýna sér tákn af himni. Þá sagði Jesús: ");
INSERT INTO isl_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","3","„Þið eigið auðvelt með að átta ykkur á veðrinu. Kvöldroði boðar góðviðri að morgni, en morgunroði og dimm ský vita á vont veður. En tákn tímanna, þau getið þið ekki skilið. ");
INSERT INTO isl_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Þessi illa og vantrúaða þjóð biður um sérstakt tákn af himnum, en hún mun ekki fá annað tákn en það sem Jónas fékk.“ Að þessu mæltu gekk hann burt frá þeim. ");
INSERT INTO isl_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Þegar lærisveinarnir komu yfir vatnið, tóku þeir eftir því að þeir höfðu gleymt að hafa með sér nesti. ");
INSERT INTO isl_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","„Varið ykkur!“ sagði Jesús, „varið ykkur á súrdeigi faríseanna og saddúkeanna.“ ");
INSERT INTO isl_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Þeir héldu að hann segði þetta af því að þeir höfðu gleymt að taka með sér brauð. ");
INSERT INTO isl_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús vissi hvað þeir hugsuðu og bætti við: „Lítil er trú ykkar! Af hverju hafið þið áhyggjur af mat? ");
INSERT INTO isl_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Hvar er skilningur ykkar? Munið þið ekki eftir brauðunum fimm sem nægðu handa fimm þúsund manns, og öllu því sem gekk af? ");
INSERT INTO isl_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Og munið þið ekki heldur eftir þúsundunum fjórum og öllu sem þá varð afgangs? ");
INSERT INTO isl_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Hvernig datt ykkur í hug að ég væri að tala um mat? En ég endurtek: Varið ykkur á súrdeigi faríseanna og saddúkeanna!“ ");
INSERT INTO isl_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Þá skildu þeir loks að með „súrdeiginu“ átti hann við varasamar kenningar farísea og saddúkea. ");
INSERT INTO isl_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Þegar Jesús kom til Sesareu Filippí spurði hann lærisveina sína: „Hvern segir fólk mig vera?“ ");
INSERT INTO isl_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Þeir svöruðu: „Sumir segja að þú sért Jóhannes skírari, aðrir Elía, og enn aðrir Jeremía eða einhver af spámönnunum.“ ");
INSERT INTO isl_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","„En þið,“ spurði hann, „hvað segið þið?“ ");
INSERT INTO isl_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Símon Pétur svaraði: „Þú ert Kristur, sonur hins lifanda Guðs.“ ");
INSERT INTO isl_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","„Sæll ert þú, Símon Pétur,“ svaraði Jesús, „því faðir minn á himnum hefur sjálfur sannfært þig um þetta – þú hefur þetta ekki frá neinum manni. ");
INSERT INTO isl_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Þú ert Pétur – kletturinn – á þessum kletti mun ég byggja söfnuð minn og vald vítis mun ekki megna að yfirbuga hann. ");
INSERT INTO isl_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ég mun gefa þér lykla himnaríkis. Það sem þú leysir á jörðu skal verða leyst á himnum!“ ");
INSERT INTO isl_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Síðan lagði hann ríkt á við lærisveinana að segja engum að hann væri Kristur. ");
INSERT INTO isl_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Eftir þetta tók Jesús að segja lærisveinum sínum berum orðum að hann yrði að fara til Jerúsalem. Þar mundu leiðtogar þjóðarinnar ofsækja hann og lífláta, en hann síðan rísa upp að þrem dögum liðnum. ");
INSERT INTO isl_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pétri blöskruðu þessi orð. Hann leiddi Jesú afsíðis til að tala um fyrir honum og sagði: „Guð hjálpi þér! Þetta mun aldrei koma fyrir þig!“ ");
INSERT INTO isl_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesús sneri sér að Pétri og sagði: „Burt með þig Satan! Þú ert á móti mér! Þú lítur ekki á málið frá sjónarmiði Guðs, heldur manna.“ ");
INSERT INTO isl_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Síðan sagði Jesús við lærisveinana: „Vilji einhver fylgja mér þá verður hann að afneita sjálfum sér, taka upp kross sinn og fylgja mér. ");
INSERT INTO isl_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sá sem vill njóta lífsins að eigin geðþótta mun týna því, en sá sem fórnar lífi sínu mín vegna, mun finna það. ");
INSERT INTO isl_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Hverju eru menn bættari þótt þeir eignist allan heiminn, ef þeir glata eilífa lífinu? ");
INSERT INTO isl_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ég, mannssonurinn, mun koma ásamt englum mínum í dýrð föðurins og dæma sérhvern eftir verkum hans. ");
INSERT INTO isl_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Sumir ykkar, sem hér standa, munu lifa og sjá mig í konungsríki mínu.“ ");
INSERT INTO isl_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sex dögum síðar tók Jesús þá Pétur, Jakob og Jóhannes með sér upp á hátt fjall. ");
INSERT INTO isl_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Þegar þangað kom sáu þeir að útlit Jesú breyttist, andlit hans tók að ljóma sem sólin og klæðin urðu skínandi björt. ");
INSERT INTO isl_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Allt í einu birtust Móse og Elía og fóru að tala við hann. ");
INSERT INTO isl_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Þá sagði Pétur: „Drottinn, hér er gott að vera! Ef þú vilt, þá skal ég gera hér þrjú skýli, eitt handa þér, annað handa Móse og það þriðja handa Elía.“ ");
INSERT INTO isl_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","En um leið og hann sagði þetta kom bjart ský yfir þá og úr því heyrðu þeir rödd sem sagði: „Þessi er minn elskaði sonur, sem ég hef velþóknun á. Hlustið á hann!“ ");
INSERT INTO isl_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Lærisveinarnir lutu til jarðar í óttablandinni lotningu. ");
INSERT INTO isl_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesús kom til þeirra, snerti þá og sagði: „Rísið upp og verið óhræddir.“ ");
INSERT INTO isl_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Þegar þeir litu upp sáu þér Jesú einan. ");
INSERT INTO isl_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Á leiðinni niður fjallið bað Jesús þá að segja engum frá því, sem þeir höfðu séð, fyrr en hann væri risinn upp frá dauðum. ");
INSERT INTO isl_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Þá spurðu þeir hann: „Hvers vegna segja leiðtogar þjóðar okkar að Elía verði að koma á undan Kristi?“ ");
INSERT INTO isl_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","„Þetta er rétt hjá þeim,“ svaraði Jesús. „Elía verður að koma og færa allt í lag. ");
INSERT INTO isl_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Hann er reyndar búinn að koma, en menn þekktu hann ekki og margir fóru illa með hann. Ég, Kristur, mun einnig verða að þjást af þeirra völdum.“ ");
INSERT INTO isl_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Þá skildu lærisveinarnir að hann átti við Jóhannes skírara. ");
INSERT INTO isl_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Þegar þeir komu niður af fjallinu beið þeirra mikill mannfjöldi. Maður nokkur kom þá hlaupandi, kraup að fótum Jesú og sagði: ");
INSERT INTO isl_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","„Herra miskunnaðu syni mínum. Hann er geðveikur og þungt haldinn. Hann dettur oft í eld og vatn. ");
INSERT INTO isl_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ég fór með hann til lærisveina þinna, en þeir gátu ekki læknað hann.“ ");
INSERT INTO isl_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","„Æ, þið efagjörnu og rangsnúnu menn!“ sagði Jesús. „Hversu lengi á ég að umbera ykkur? Komið með drenginn til mín.“ ");
INSERT INTO isl_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesús ávítaði illa andann, sem var í drengnum, svo að hann fór úr honum og drengurinn varð heilbrigður á samri stundu. ");
INSERT INTO isl_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Eftir á spurðu lærisveinarnir Jesú hvers vegna þeir hefðu ekki getað rekið illa andann út. ");
INSERT INTO isl_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","„Þið hafið svo litla trú,“ svaraði Jesús. „Ef þið ættuð trú, þó að ekki væri hún stærri en agnarlítið sinnepsfræ, þá gætuð þið sagt við þetta fjall: „Færðu þig!“ og það mundi hlýða ykkur. Ykkur yrði enginn hlutur um megn. ");
INSERT INTO isl_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","En illur andi eins og þessi fer ekki út fyrr en þið hafið beðið og fastað.“ ");
INSERT INTO isl_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Dag einn meðan þeir voru enn í Galíleu sagði Jesús við lærisveinana: „Ég mun verða svikinn í hendur þeirra sem vald hafa til að lífláta mig, en að þrem dögum liðnum mun ég rísa upp.“ Þegar lærisveinarnir heyrðu þetta urðu þeir hryggir og skelfdir. ");
INSERT INTO isl_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Þegar þeir komu til Kapernaum komu menn, sem innheimtu musterisskattinn, til Péturs og spurðu: „Greiðir meistari þinn ekki skatta?“ ");
INSERT INTO isl_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","„Auðvitað gerir hann það,“ svaraði Pétur. Síðan fór hann inn í húsið til að ræða málið við Jesú, en Jesús varð fyrri til og spurði: „Pétur, hvort heldur þú að konungar skattleggi syni sína eða útlendingana, sem þeir undiroka?“ ");
INSERT INTO isl_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","27","„Útlendingana,“ svaraði Pétur. „Fyrst svo er,“ sagði Jesús, „þá eru synirnir skattlausir! En við skulum ekki hneyksla þá. Farðu niður að vatninu og kastaðu út færi. Opnaðu síðan munninn á fyrsta fiskinum sem þú færð og þar muntu finna pening. Taktu hann og greiddu fyrir okkur báða.“ ");
INSERT INTO isl_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Rétt í þessu komu lærisveinarnir til Jesú og spurðu hann hver þeirra yrði mestur í ríki himnanna. ");
INSERT INTO isl_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesús kallaði þá á lítið barn sem stóð þar hjá ");
INSERT INTO isl_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","og sagði: „Ef þið snúið ykkur ekki frá syndinni, til Guðs, og verðið eins og börnin, munuð þið aldrei komast inn í himnaríki. ");
INSERT INTO isl_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Sá sem er auðmjúkur, eins og þetta litla barn, verður mestur í himnaríki. ");
INSERT INTO isl_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ef þið, sem lærisveinar mínir, takið vel á móti barni eins og þessu, þá takið þið á móti mér. ");
INSERT INTO isl_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","En snúi eitthvert þessara barna, sem á mig trúa, við mér baki ykkar vegna, þá væri þeim manni betra að láta kasta sér í hafið með stein bundinn um háls sér. ");
INSERT INTO isl_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Miklar hörmungar bíða þessa heims vegna illsku hans. Við komumst reyndar ekki hjá því að verða fyrir freistingum, en vei þeim manni sem freistingunum veldur. ");
INSERT INTO isl_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ef hönd þín eða fótur kemur þér til að syndga, er betra að skera liminn af, kasta honum burt og koma bæklaður til himins, en hafa bæði hendur og fætur, og lenda í helvíti. ");
INSERT INTO isl_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ef auga þitt fær þig til að syndga, skaltu stinga það úr og fleygja því. Betra er fyrir þig að ná til himna eineygður, en að fara alsjáandi til helvítis. ");
INSERT INTO isl_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Gætið þess að fyrirlíta ekki neitt þessara barna. Ég segi ykkur satt: Englar þeirra eru í nánum tengslum við föður minn á himnum, ");
INSERT INTO isl_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","og ég, Kristur, kom til þess að frelsa þau sem týnd eru. ");
INSERT INTO isl_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Hvað gerir sá sem á hundrað sauði ef einn þeirra villist? Skilur hann ekki hina níutíu og níu eftir og fer að leita þess sem týndist? ");
INSERT INTO isl_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ef hann finnur hann, gleðst hann meira vegna hans en hinna níutíu og níu sem eru öruggir heima. ");
INSERT INTO isl_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Á sama hátt vill faðir minn ekki að eitt einasta þessara barna glatist. ");
INSERT INTO isl_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ef einhver í söfnuðinum syndgar, skaltu fara til hans og ræða við hann einslega um mistök hans. Ef hann hlustar og játar sekt sína, hefur þú bjargað honum. ");
INSERT INTO isl_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","En ef hann lætur sér ekki segjast við orð þín, skaltu fara til hans á ný og fá með þér einn eða tvo til viðbótar til að staðfesta mál þitt. ");
INSERT INTO isl_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ef honum verður ekki þokað þrátt fyrir það, skaltu láta taka málið upp í söfnuðinum. Ef úrskurður safnaðarins verður þér í vil, en bróðir þinn vill ekki beygja sig fyrir honum, skal honum vísað úr söfnuðinum. ");
INSERT INTO isl_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ég segi ykkur hér með: Hvað sem þið bindið á jörðu, mun bundið á himnum, og hvað sem þið leysið á jörðu, verður leyst á himnum. ");
INSERT INTO isl_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ég segi ykkur einnig að verði tveir ykkar sammála um að biðja einhvers, mun faðir minn á himnum veita ykkur það. ");
INSERT INTO isl_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Því að hvar sem tveir eða þrír eru samankomnir mín vegna, er ég mitt á meðal þeirra.“ ");
INSERT INTO isl_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Þá kom Pétur til hans og spurði: „Herra; hve oft á ég að fyrirgefa þeim sem syndgar gegn mér? Sjö sinnum?“ ");
INSERT INTO isl_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","„Nei, sjötíu sinnum sjö, – endalaust!“ svaraði Jesús. ");
INSERT INTO isl_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","„Himnaríki má líkja við konung, sem ákvað að gera upp við þá sem skulduðu honum. ");
INSERT INTO isl_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Meðan á uppgjörinu stóð, var komið með mann sem skuldaði honum margar milljónir. ");
INSERT INTO isl_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Hann gat ekki borgað, og þá skipaði konungurinn svo fyrir að hann, kona hans og börn skyldu seld, ásamt öllum eigum hans, til þess að skuldin yrði greidd. ");
INSERT INTO isl_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Þá varpaði maðurinn sér í gólfið við fætur konungsins og sagði: „Ó, herra minn, miskunnaðu mér og ég mun borga þér alla skuldina!“ ");
INSERT INTO isl_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Þá kenndi konungurinn í brjósti um hann og gaf honum upp alla skuldina! ");
INSERT INTO isl_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Þegar þessi maður kom út frá konunginum, hitti hann félaga sinn sem skuldaði honum smáræði. Hann greip um kverkar honum og skipaði honum að greiða alla skuldina tafarlaust. ");
INSERT INTO isl_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Maðurinn kraup þá við fætur hans og grátbað hann: „Veittu mér dálítinn frest og ég mun greiða þér það sem ég skulda.“ ");
INSERT INTO isl_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","En hinn vildi ekki bíða og lét handtaka skuldunaut sinn og varpa honum í fangelsi, þar varð hann að dúsa uns skuldin var að fullu greidd. ");
INSERT INTO isl_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Samstarfsmönnum þeirra brá í brún og þeir fóru til konungsins og sögðu honum hvað gerst hafði. ");
INSERT INTO isl_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Konungurinn lét þá kalla til sín manninn sem hann hafði gefið upp skuldina og sagði: „Miskunnarlausi þrjótur! Ég gaf þér upp milljóna skuld vegna þess að þú baðst mig um það. ");
INSERT INTO isl_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Átt þú ekki að vera miskunnsamur við aðra eins og ég var miskunnsamur við þig?“ ");
INSERT INTO isl_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Konungurinn varð reiður og sendi manninn til böðlanna sem skyldu gæta hans uns skuldin yrði að fullu greidd. ");
INSERT INTO isl_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Þannig mun faðir minn á himnum einnig fara að við ykkur, ef þið fyrirgefið ekki bræðrum ykkar af heilum hug.“ ");
INSERT INTO isl_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Að lokinni þessari ræðu hélt Jesús af stað frá Galíleu til Júdeu og lagði leið sína um héruðin austan Jórdanar. ");
INSERT INTO isl_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mikill fjöldi fylgdi honum og hann læknaði sjúka. ");
INSERT INTO isl_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Þá komu til hans nokkrir farísear sem vildu ræða við hann og reyna að flækja hann í orðum. „Leyfir þú hjónaskilnað?“ spurðu þeir. ");
INSERT INTO isl_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","„Hafið þið ekki lesið Biblíuna?“ spurði hann. „Þar stendur að í upphafi hafi Guð skapað karl og konu, ");
INSERT INTO isl_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","og sagt að karlmaðurinn ætti að fara að heiman frá foreldrum sínum og búa með eiginkonu sinni upp frá því. ");
INSERT INTO isl_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Þau tvö eiga að verða eitt – ekki framar tvö, heldur eitt! Enginn maður má aðskilja það sem Guð hefur sameinað.“ ");
INSERT INTO isl_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","„En af hverju sagði þá Móse að maðurinn gæti skilið við konu sína með því að afhenda henni skilnaðarbréf?“ spurðu þeir. ");
INSERT INTO isl_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","„Móse leyfði ykkur skilnað vegna illsku ykkar og miskunnarleysis,“ svaraði Jesús, „en það hafði Guð ekki upphaflega áformað. ");
INSERT INTO isl_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ég segi: Sá sem skilur við konu sína af annarri ástæðu en þeirri að hún hafi verið honum ótrú og kvænist annarri, drýgir hór.“ ");
INSERT INTO isl_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","„Ef svo er,“ sögðu lærisveinarnir, „þá er nú betra að kvænast alls ekki!“ ");
INSERT INTO isl_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","„Ég veit að ekki geta allir framfylgt þessu,“ sagði Jesús, „aðeins þeir sem fá hjálp frá Guði. ");
INSERT INTO isl_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Sumir eru fæddir þannig að þeir geta ekki lifað í hjónabandi, aðrir verða þannig af mannavöldum og enn aðrir vilja ekki gifta sig vegna guðsríkisins. Sá sem skilur orð mín ætti að fara eftir þeim.“ ");
INSERT INTO isl_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Fólk færði lítil börn til Jesú og bað hann um að leggja hendur yfir þau og biðja fyrir þeim. Lærisveinarnir brugðust illa við þessu og sögðu: „Verið ekki að ónáða hann.“ ");
INSERT INTO isl_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","En Jesús sagði: „Leyfið börnunum að koma til mín og bannið þeim það ekki, því slíkra er guðsríki.“ ");
INSERT INTO isl_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Og hann lagði hendur sínar á höfuð þeirra, blessaði þau og hélt síðan áfram ferð sinni. ");
INSERT INTO isl_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Maður nokkur kom til Jesú og spurði: „Meistari, hvaða góðverk þarf ég að gera til þess að eignast eilíft líf?“ ");
INSERT INTO isl_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","„Hvers vegna spyrð þú mig um hið góða?“ svaraði Jesús. „Einn er góður og það er Guð. En spurningu þinni skal ég svara. Þú kemst til himins, ef þú hlýðir boðorðunum.“ ");
INSERT INTO isl_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","„Hverjum?“ spurði maðurinn. „Þessum,“ svaraði Jesús: „Þú skalt ekki mann deyða, ekki drýgja hór, ekki stela, ekki ljúga, ");
INSERT INTO isl_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","heiðraðu föður þinn og móður og elskaðu meðbróður þinn eins og sjálfan þig!“ ");
INSERT INTO isl_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","„Ég hef alltaf hlýtt boðorðunum,“ sagði ungi maðurinn, „hvað er það fleira sem ég þarf að gera?“ ");
INSERT INTO isl_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús svaraði: „Ef þú vilt verða fullkominn, þá skaltu selja allt sem þú átt, gefa fátækum andvirðið og þá muntu eignast fjársjóð á himnum. Komdu síðan og fylgdu mér.“ ");
INSERT INTO isl_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Þegar ungi maðurinn heyrði þetta varð hann dapur og gekk burt – hann var mjög ríkur. ");
INSERT INTO isl_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Þá sagði Jesús við lærisveinana: „Ríkum manni mun reynast erfitt að komast inn í guðsríki. ");
INSERT INTO isl_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ég segi, það er auðveldara fyrir úlfalda að komast gegnum nálarauga en fyrir ríkan mann að komast inn í guðsríki!“ ");
INSERT INTO isl_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Lærisveinarnir urðu forviða og spurðu: „Hver getur þá frelsast?“ ");
INSERT INTO isl_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús leit á þá einbeittur á svip og sagði: „Enginn, fyrir mannlegt tilstilli, en Guði eru allir hlutir mögulegir.“ ");
INSERT INTO isl_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","„En við sem yfirgáfum allt og fylgdum þér,“ sagði Pétur, „hvað berum við úr býtum?“ ");
INSERT INTO isl_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús svaraði: „Þegar ég, Kristur, sest í hið dýrlega hásæti mitt í guðsríkinu, munuð þið sitja í tólf hásætum og dæma tólf ættkvíslir Ísraels. ");
INSERT INTO isl_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Hver sá sem yfirgefur heimili, bræður, systur, föður, móður, eiginkonu, börn eða eignir til að geta fylgt mér, mun fá hundraðfalt í staðinn og eignast eilíft líf. ");
INSERT INTO isl_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Margir þeirra, sem nú eru fremstir, verða þá síðastir og hinir síðustu fremstir.“ ");
INSERT INTO isl_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","„Hér er enn ein dæmisaga um himnaríki: Landeigandi nokkur fór að heiman snemma morguns að fá verkamenn til uppskerustarfa. ");
INSERT INTO isl_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Hann samdi við þá um venjuleg daglaun og að því búnu hófu þeir vinnuna. ");
INSERT INTO isl_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tveim stundum síðar gekk hann aftur niður í bæinn og sá þá menn á torginu iðjulausa. ");
INSERT INTO isl_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Þessa menn sendi hann einnig út á akurinn og sagðist mundu borga þeim sanngjörn laun. ");
INSERT INTO isl_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Hann fór einnig út um hádegið og klukkan þrjú, og sama sagan endurtók sig. ");
INSERT INTO isl_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Klukkan fimm síðdegis var hann aftur staddur í bænum og sá þá enn nokkra sem höfðu ekkert fyrir stafni. „Af hverju eruð þið iðjulausir?“ spurði hann. ");
INSERT INTO isl_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","„Við höfum ekki fengið neina vinnu,“ svöruðu þeir. „Farið þá og hjálpið hinum sem eru að vinna á ökrum mínum,“ sagði hann. ");
INSERT INTO isl_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Um kvöldið bauð hann gjaldkera sínum að kalla á mennina og greiða þeim launin og byrja á þeim sem komu síðastir. ");
INSERT INTO isl_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Þeir komu og fengu full daglaun hver um sig. ");
INSERT INTO isl_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Þegar hinir, sem byrjað höfðu fyrr um daginn, komu að ná í sín laun, bjuggust þeir við að fá miklu meira, en þeir fengu sömu upphæð. ");
INSERT INTO isl_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","Þá mótmæltu þeir og sögðu: „Þessir náungar unnu aðeins eina klukkustund, en samt hefur þú greitt þeim jafnmikið og okkur sem höfum stritað allan daginn í þessum hita.“ ");
INSERT INTO isl_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","„Kæri vinur, ég hef ekki beitt þig rangindum!“ sagði maðurinn við einn þeirra. „Þú samþykktir að vinna allan daginn fyrir venjuleg daglaun, var ekki svo? ");
INSERT INTO isl_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Taktu þetta og síðan máttu fara. Mig langar til að borga þessum síðustu jafnmikið og þér. ");
INSERT INTO isl_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Má ég ekki gefa peningana mína þeim sem ég vil? Er það samningsbrot? Eða ertu öfundsjúkur af því að ég er góðsamur?“ ");
INSERT INTO isl_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Hinir fyrstu verða oft síðastir og þeir síðustu fyrstir.“ ");
INSERT INTO isl_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Á leiðinni til Jerúsalem tók Jesús lærisveinana tólf afsíðis, ");
INSERT INTO isl_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","til þess að segja þeim hvað biði hans er hann kæmi til borgarinnar. ");
INSERT INTO isl_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","„Ég verð svikinn í hendur æðstu prestanna og leiðtoganna, og þeir munu dæma mig til dauða. Síðan munu þeir afhenda mig rómversku yfirvöldunum. Ég verð hæddur og krossfestur, en á þriðja degi mun ég rísa upp frá dauðum.“ ");
INSERT INTO isl_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Móðir þeirra Jakobs og Jóhannesar Sebedeussona kom þá með þeim til Jesú, hneigði sig og bað hann að gera sér greiða. ");
INSERT INTO isl_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","„Hvað vilt þú?“ spurði hann. Hún svaraði: „Viltu leyfa þessum sonum mínum að sitja sínum hvorum megin við þig þegar þú sest í hásæti þitt?“ ");
INSERT INTO isl_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","„Þú veist ekki um hvað þú biður“ svaraði Jesús, sneri sér að Jakobi og Jóhannesi og spurði: „Getið þið drukkið þann beiska bikar sem ég tæmi innan skamms?“ „Já, það getum við!“ svöruðu þeir. ");
INSERT INTO isl_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","„Þið fáið sannarlega að drekka hann,“ sagði Jesús. „En það er ekki mitt að segja hverjir eiga að sitja mér við hlið, það er föður míns að ákveða.“ ");
INSERT INTO isl_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Þegar hinir tíu heyrðu hvað Jakob og Jóhannes höfðu beðið um, urðu þeir gramir. ");
INSERT INTO isl_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesús kallaði þá til sín og sagði: „Konungar þjóðanna eru harðstjórar og embættismenn þeirra láta fólkið kenna á valdi sínu. ");
INSERT INTO isl_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Þessu er öfugt farið um ykkur. Sá ykkar sem vill verða leiðtogi, verður að þjóna hinum, ");
INSERT INTO isl_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","og sá sem vill verða fremstur, verður að þjóna eins og þræll. ");
INSERT INTO isl_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Verið eins og ég, Kristur, sem kom ekki til að láta þjóna mér heldur til að þjóna öðrum og gefa líf mitt til lausnar fyrir marga.“ ");
INSERT INTO isl_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Þegar Jesús og lærisveinarnir fóru frá Jeríkó fylgdi þeim mikill mannfjöldi. ");
INSERT INTO isl_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Við veginn út úr bænum sátu tveir blindir menn. Þegar þeir heyrðu að Jesú ætti leið þar um fóru þeir að hrópa og kalla: „Herra, sonur Davíðs konungs, hjálpaðu okkur!“ ");
INSERT INTO isl_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mannfjöldinn skipaði þeim að þegja, en þá hrópuðu þeir enn hærra. ");
INSERT INTO isl_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","33","Jesús nam staðar og kallaði til þeirra: „Hvað viljið þið að ég geri fyrir ykkur?“ „Herra,“ hrópuðu þeir, „gef okkur sjónina!“ ");
INSERT INTO isl_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús kenndi í brjósti um þá og snerti augu þeirra. Við það fengu þeir jafnskjótt sjónina og fylgdu honum. ");
INSERT INTO isl_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jesús og lærisveinar hans nálguðust nú Jerúsalem. Þegar þeir áttu skammt ófarið til þorpsins Betfage á Olíufjallinu, sendi hann tvo þeirra þangað á undan sér. ");
INSERT INTO isl_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","„Þegar þið komið inn í þorpið, munuð þið finna ösnu bundna og fola hjá henni. Leysið þau og færið mér. ");
INSERT INTO isl_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ef einhver spyr hvað þið séuð að gera, skuluð þið svara: „Drottinn þarfnast þeirra,“ og þá mun spyrjandinn láta ykkur afskiptalausa.“ ");
INSERT INTO isl_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Með þessu rættist gamall spádómur sem er svona: ");
INSERT INTO isl_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","„Segið Jerúsalem að konungur hennar sé að koma, auðmjúkur og ríðandi á ösnufola!“ ");
INSERT INTO isl_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Lærisveinarnir tveir gerðu eins og þeim var sagt ");
INSERT INTO isl_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","og komu með ösnuna og folann til Jesú. Þeir lögðu síðan yfirhafnir sínar á folann og Jesús settist á bak. ");
INSERT INTO isl_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Þá breiddu flestir viðstaddra yfirhafnir sínar á veginn en aðrir skáru greinarnar af trjánum og dreifðu þeim á veginn. ");
INSERT INTO isl_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Allt fólkið gekk á undan og hrópaði: „Guð blessi konunginn, son Davíðs! Blessaður sé sá sem kemur í nafni Drottins! Drottinn, sendu honum hjálp þína frá himnum.“ ");
INSERT INTO isl_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Allt komst í uppnám í Jerúsalem við komu Jesú og fólkið þar spurði: „Hver er þetta?“ ");
INSERT INTO isl_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mannfjöldinn, sem fylgdi honum, svaraði þá: „Þetta er Jesús, spámaðurinn frá Nasaret í Galíleu.“ ");
INSERT INTO isl_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesús gekk inn í musterið og rak kaupmennina, sem þar voru, á dyr. Hratt um stöllum dúfnasalanna og borðum þeirra sem skiptu peningum. Hann sagði: ");
INSERT INTO isl_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","„Biblían segir: „Musteri mitt á að vera bænastaður, en þið hafið gert það að ræningjabæli!“ “ ");
INSERT INTO isl_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Blindir menn og bæklaðir streymdu til hans og hann læknaði þá í musterinu. ");
INSERT INTO isl_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Þegar æðstu prestarnir og leiðtogarnir sáu þessi dásamlegu kraftaverk og heyrðu börnin hrópa í musterinu: „Guð blessi son Davíðs!“ urðu þeir gramir og sögðu við hann: „Heyrirðu hvað börnin segja?“ ");
INSERT INTO isl_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","„Já,“ svaraði Jesús, „hafið þið aldrei lesið þetta: „Jafnvel börnin munu lofa hann.“ “ ");
INSERT INTO isl_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Síðan fór Jesús til Betaníu og gisti þar um nóttina. ");
INSERT INTO isl_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Á leiðinni til Jerúsalem, morguninn eftir, fann hann til svengdar. ");
INSERT INTO isl_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Þá tók hann eftir fíkjutré, sem stóð rétt við veginn. Hann gekk að trénu til að athuga hvort á því væru nokkrar fíkjur, en svo var ekki, einungis lauf. Þá sagði hann við tréð: „Upp frá þessu munt þú aldrei bera ávöxt!“ Rétt á eftir visnaði tréð. ");
INSERT INTO isl_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Lærisveinarnir urðu forviða og spurðu: „Hvernig gat tréð visnað svona fljótt?“ ");
INSERT INTO isl_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","„Sannleikurinn er sá,“ svaraði Jesús, „að ef þið trúið án þess að efast, þá getið þið gert slíka hluti og jafnvel enn meiri. Þið gætuð til dæmis sagt við þetta fjall: „Flyttu þig út í sjó,“ og það mundi hlýða. ");
INSERT INTO isl_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Þið getið fengið allt, já allt, sem þið biðjið um – ef þið trúið.“ ");
INSERT INTO isl_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Þegar Jesús var kominn í musterið og farinn að kenna, komu æðstu prestarnir og aðrir leiðtogar þjóðarinnar. Þeir kröfðust þess að hann segði þeim hver hefði gefið honum vald til að reka kaupmennina út daginn áður. ");
INSERT INTO isl_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","„Það skal ég segja ykkur, ef þið svarið einni spurningu fyrst,“ sagði Jesús. ");
INSERT INTO isl_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","„Sendi Guð Jóhannes skírara? Já, eða nei!“ Þeir báru saman ráð sín: „Ef við segjum að Guð hafi sent hann, þá mun hann spyrja af hverju við höfum þá ekki trúað honum. ");
INSERT INTO isl_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","En ef við segjum að Guð hafi ekki sent hann, þá mun fólkið ráðast á okkur, því að það telur að Jóhannes hafi verið spámaður.“ ");
INSERT INTO isl_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Að lokum svöruðu þeir: „Við vitum það ekki.“ „Þá svara ég ekki heldur spurningu ykkar,“ sagði Jesús. ");
INSERT INTO isl_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","„En hvað segið þið annars um þetta: Maður nokkur átti tvo syni. Hann sagði við annan: „Sonur minn, þú skalt vinna í víngarðinum í dag.“ ");
INSERT INTO isl_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","„Æ, nei, ég nenni því ekki,“ svaraði hann, en seinna sá hann sig um hönd og fór. ");
INSERT INTO isl_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Faðirinn sagði síðan við þann yngri: „Heyrðu, þú skalt fara í jarðræktina.“ Sonurinn svaraði: „Já, pabbi, sjálfsagt!“ en fór ekki fet. ");
INSERT INTO isl_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Hvor þessara tveggja hlýddi föður sínum?“ „Sá fyrri, auðvitað,“ svöruðu þeir. Jesús skýrði nú fyrir þeim merkingu sögunnar og sagði: „Illmennum og vændiskonum verður leiðin til himins greiðfærari en ykkur. ");
INSERT INTO isl_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jóhannes skírari sagði ykkur að gjöra iðrun og snúa ykkur til Guðs. Það vilduð þið ekki, en það gerðu hins vegar svindlarar og skækjur. Og þótt þið sæjuð það gerast, vilduð þið samt ekki sjá ykkur um hönd og hlýða honum. Þess vegna gátuð þið ekki trúað.“ ");
INSERT INTO isl_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","„Hlustið á þessa sögu: Landeigandi nokkur plantaði vínviði og gerði skjólgarð umhverfis hann. Því næst reisti hann pall fyrir eftirlitsmanninn og leigði síðan víngarðinn nokkrum bændum með því skilyrði að þeir skiptu uppskerunni með honum. Síðan fluttist hann úr landi. ");
INSERT INTO isl_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Þegar uppskerutíminn kom sendi hann menn sína til bændanna að sækja sinn hluta. ");
INSERT INTO isl_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","En bændurnir gerðu aðsúg að þeim, börðu einn til óbóta, drápu annan og grýttu þann þriðja. ");
INSERT INTO isl_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Þá sendi hann aðra til þeirra, fleiri en þá fyrri, en allt fór á sömu leið. ");
INSERT INTO isl_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Að lokum sendi víngarðseigandinn son sinn, því hann hugsaði: „Þeir munu áreiðanlega bera virðingu fyrir honum.“ ");
INSERT INTO isl_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","En þegar bændurnir sáu son hans koma, sögðu þeir hver við annan: „Þarna kemur erfinginn. Komið! Við skulum drepa hann og þá eigum við víngarðinn!“ ");
INSERT INTO isl_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Síðan drógu þeir hann út úr víngarðinum og drápu hann. ");
INSERT INTO isl_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Hvað haldið þið að landeigandinn muni gera við bændurna þegar hann kemur til baka?“ ");
INSERT INTO isl_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Leiðtogar Gyðinga svöruðu: „Svona illmenni ætti að lífláta og leigja víngarðinn öðrum, sem greiða leiguna skilvíslega.“ ");
INSERT INTO isl_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Þá spurði Jesús: „Hafið þið aldrei lesið þessi ritningarorð: „Steinninn sem smiðirnir höfnuðu, var gerður að hornsteini. Drottinn hefur unnið dásamleg verk!“ ");
INSERT INTO isl_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Það sem ég á við er þetta: Guðsríki verður tekið frá ykkur og gefið öðrum, sem afhenda Guði hans hlut í uppskerunni. ");
INSERT INTO isl_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Þeir sem reka sig á þetta sannleiksbjarg munu sundurmerjast, en þeir sem undir verða myljast mélinu smærra.“ ");
INSERT INTO isl_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Þegar æðstu prestarnir og hinir leiðtogarnir skildu að Jesús átti við þá – að þeir væru bændurnir í sögunni, ");
INSERT INTO isl_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","vildu þeir handtaka hann. Þeir þorðu það þó ekki vegna fólksins sem áleit að Jesús væri spámaður. ");
INSERT INTO isl_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús sagði fólkinu fleiri sögur til þess að auka skilning þess á mætti og valdi Guðs. Hér er ein þeirra: ");
INSERT INTO isl_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","„Guðsríki má líkja við konung sem undirbjó brúðkaupsveislu sonar síns. ");
INSERT INTO isl_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Fjöldi gesta var boðinn, og þegar stundin nálgaðist sendi hann þjóna sína til þess að segja öllum að veislan væri að hefjast. En fólkið vildi ekki koma! ");
INSERT INTO isl_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Hann sendi því aðra með þessi skilaboð: „Allt er tilbúið. Steikin er í ofninum. Flýtið ykkur!“ ");
INSERT INTO isl_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","En þeir sem boðnir voru hlógu aðeins og sneru sér að vinnu sinni, eins og ekkert hefði í skorist. Einn að búskapnum, annar að versluninni, ");
INSERT INTO isl_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","enn aðrir börðu sendiboðana, svívirtu þá og drápu suma þeirra. ");
INSERT INTO isl_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Þá reiddist konungurinn heiftarlega og sendi þangað herlið, drap morðingjana og brenndi borg þeirra. ");
INSERT INTO isl_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Síðan sagði hann við þjóna sína: „Brúðkaupsveislan skal haldin, en gestirnir, sem boðnir voru, eru ekki verðir þessa heiðurs. ");
INSERT INTO isl_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Farið nú út á göturnar og bjóðið þeim sem þið sjáið að koma!“ ");
INSERT INTO isl_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Þjónarnir fóru og náðu í alla sem þeir gátu, bæði vonda og góða, og veislusalurinn varð fullur af brúðkaupsgestum. ");
INSERT INTO isl_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","En þegar konungurinn kom inn til að heilsa gestunum, tók hann eftir manni sem ekki var í brúðkaupsklæðum (þeim sem gestunum hafði verið séð fyrir). ");
INSERT INTO isl_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","„Heyrðu vinur,“ sagði konungurinn, „Hvernig stendur á því að þú ert ekki í brúðkaupsklæðum?“ Maðurinn svaraði engu. ");
INSERT INTO isl_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Þá sagði konungurinn við þjóna sína: „Bindið hann á höndum og fótum og kastið honum út í myrkrið – þar verður grátið og kveinað.“ ");
INSERT INTO isl_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Margir eru kallaðir en fáir útvaldir.“ ");
INSERT INTO isl_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farísearnir sátu nú á fundi, til að ræða hvernig þeir gætu flækt Jesú í orðum, svo hægt væri að handtaka hann. ");
INSERT INTO isl_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Niðurstaðan varð sú að þeir ákváðu að senda lærisveina sína ásamt öðrum úr hópi Heródesarsinna til þess að leggja fyrir hann spurningar og segja: „Herra við vitum að þú ert mjög heiðarlegur og segir sannleikann, hvað sem öðrum finnst. ");
INSERT INTO isl_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Segðu okkur nú, er rétt af okkur að greiða skatt til rómverska ríkisins, eða ekki?“ ");
INSERT INTO isl_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","En Jesús skildi bragðið og kallaði: „Þið hræsnarar! Eruð þið að reyna að leika á mig með lævísum spurningum? ");
INSERT INTO isl_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Sýnið mér mynt.“ Þá réttu þeir honum pening. ");
INSERT INTO isl_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","„Af hverjum er myndin á peningnum,“ spurði hann, „og hvaða nafn er undir myndinni?“ ");
INSERT INTO isl_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","„Keisarans,“ svöruðu þeir. „Jæja,“ sagði hann. „Gjaldið þá keisaranum það sem keisarans er, og Guði það sem Guðs er.“ ");
INSERT INTO isl_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Þeir urðu orðlausir af undrun við þetta svar og fóru burt. ");
INSERT INTO isl_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Þennan sama dag komu nokkrir saddúkear til hans, en þeir héldu því fram að upprisa dauðra ætti sér aldrei stað. Þeir spurðu: ");
INSERT INTO isl_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","„Herra, Móse segir að deyi maður barnlaus, eigi bróðir hans að kvænast ekkjunni og börn þeirra síðan að erfa eignir hins látna. ");
INSERT INTO isl_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Einu sinni voru sjö bræður. Sá fyrsti kvæntist en dó án þess að eignast börn. Konan giftist þá elsta bróðurnum, ");
INSERT INTO isl_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","en sá bróðir dó einnig barnlaus, og þá giftist konan þeim sem næstur var í röðinni. Svona gekk þetta koll af kolli þangað til hún hafði verið gift þeim öllum, og ");
INSERT INTO isl_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","að lokum dó hún einnig. ");
INSERT INTO isl_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nú spyrjum við: Kona hvers þeirra verður hún í upprisunni, fyrst hún var gift þeim öllum?“ ");
INSERT INTO isl_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús svaraði: „Þið vaðið reyk, því þið þekkið hvorki Biblíuna né kraft Guðs. ");
INSERT INTO isl_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Í upprisunni verður ekkert hjónaband, því þá verða allir eins og englarnir á himnum. ");
INSERT INTO isl_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","En hafið þið ekki lesið það sem Biblían segir um upprisu dauðra? Skiljið þið ekki að Guð talar til ykkar þegar hann segir: ");
INSERT INTO isl_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","„Ég er Guð Abrahams, Ísaks og Jakobs.“ Guð er ekki Guð hinna dauðu heldur þeirra sem lifa.“ ");
INSERT INTO isl_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mannfjöldanum þótti mikið til um svör Jesú ");
INSERT INTO isl_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","35","en farísearnir voru ekki á sama máli. Þegar farísearnir fréttu að Jesús hefði gert saddúkeana orðlausa fitjuðu þeir upp á nýrri spurningu, og var lögfræðingur nokkur fenginn til að bera hana fram. Spurningin var þessi: ");
INSERT INTO isl_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","„Herra, hvert er mikilvægasta boðorðið í lögum Móse?“ Jesús svaraði: ");
INSERT INTO isl_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","„Elska skalt þú Drottin Guð þinn af öllu hjarta þínu, allri sálu þinni og öllum huga þínum. ");
INSERT INTO isl_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","39","Þetta er fyrsta og jafnframt æðsta boðorðið. Það næstæðsta er svipað, en það er þannig: „Elskaðu meðbróður þinn eins og sjálfan þig.“ ");
INSERT INTO isl_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Öll hin boðorðin og fyrirmæli spámannanna – já, öll Biblían – byggja á þessu tvöfalda boði. Ef þið hlýðið því, þá hlýðið þið öllum hinum um leið.“ ");
INSERT INTO isl_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","En nú spurði Jesús faríseana: ");
INSERT INTO isl_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","„Getið þið sagt mér hvers son Kristur er?“ „Sonur Davíðs,“ svöruðu þeir. ");
INSERT INTO isl_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","„Hvers vegna talar þá Davíð, knúinn af heilögum anda, um hann sem Drottin?“ spurði Jesús. „Var það ekki Davíð sem sagði: ");
INSERT INTO isl_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","„Guð sagði við minn Drottin: sittu mér til hægri handar uns ég hef lagt óvini þína að fótum þér.“ ");
INSERT INTO isl_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Fyrst Davíð kallar hann „Drottin,“ hvernig getur hann þá verið sonur hans?“ ");
INSERT INTO isl_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Þessu gátu þeir ekki svarað og eftir það þorði enginn að spyrja hann neins. ");
INSERT INTO isl_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jesús talaði til mannfjöldans og lærisveina sinna og sagði: ");
INSERT INTO isl_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","„Halda mætti að þessir leiðtogar og farísear væru sjálfir Móse, því þeir eru alltaf að setja ný lög. ");
INSERT INTO isl_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Þið skuluð gera það sem þeir segja, en eftir verkum þeirra skuluð þið ekki breyta, því að þeir fara sjálfir ekki eftir því sem þeir kenna. ");
INSERT INTO isl_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Þeir krefjast mikils af öðrum, en lítils af sjálfum sér. ");
INSERT INTO isl_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Þeir gera allt til að sýnast. Þeir láta líta út sem þeir séu heilagir með því að breikka minnisborðana og lengja skúfana á skikkjum sínum. ");
INSERT INTO isl_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Þeir njóta þess að sitja við háborðið í veislum og hafa mætur á stúkusætum samkomuhúsanna. ");
INSERT INTO isl_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Þeim líkar vel að tekið sé eftir þeim á götum og þeir vilja gjarnan láta kalla sig „rabbí“ eða „meistari“. ");
INSERT INTO isl_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Látið engan kalla ykkur meistara, því ykkar eini meistari er Guð og allir eruð þið jafnir sem bræður. ");
INSERT INTO isl_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ávarpið heldur engan sem föður á jörðu, því að þannig á aðeins að ávarpa Guð á himnum. ");
INSERT INTO isl_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kallið ykkur ekki heldur „leiðtoga“ því ykkar eini leiðtogi er Kristur. ");
INSERT INTO isl_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Sá ykkar sem er fremstur, á að vera þjónn ykkar. Sá sem er mestur, þjóni hinum! ");
INSERT INTO isl_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Sá sem upphefur sjálfan sig, mun niðurlægjast, en þeir sem auðmýkja sig hljóta heiður. ");
INSERT INTO isl_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Þið farísear og trúarleiðtogar, vei ykkur, því þið eruð hræsnarar! Þið útilokið menn frá því að komast inn í himnaríki og sjálfir munuð þið ekki komast þangað. Þið biðjið langar bænir á almannafæri til að auglýsa guðrækni ykkar, en svo flæmið þið ekkjur út af heimilum sínum Hræsnarar! ");
INSERT INTO isl_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Já, vei ykkur, þið hræsnarar! Þið farið langar leiðir til þess að vinna einn trúskipting, og gerið hann síðan að miklu verra helvítisbarni en þið eruð sjálfir. ");
INSERT INTO isl_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Þið eruð blindir leiðsögumenn. Vei ykkur! Þið segið að það sé markleysa að sverja við musterið, en sá sem sverji við eigur musterisins sé skuldbundinn. ");
INSERT INTO isl_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Blindu heimskingjar! Hvort er meira, gullið eða musterið sem helgar gullið? ");
INSERT INTO isl_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Einnig segið þið að rjúfa megi eið sem svarinn sé við altarið en ekki þann sem svarinn sé við gjöfina á altarinu. ");
INSERT INTO isl_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Þið eruð blindir! Hvort er meira, gjöfin á altarinu eða altarið sjálft, sem helgar gjöfina? ");
INSERT INTO isl_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Þegar þú sverð við altarið, þá sverðu við það sjálft og allt sem á því er. ");
INSERT INTO isl_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Þegar þú sverð við musterið, þá sverðu við það og við Guð sem þar býr. ");
INSERT INTO isl_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Þegar þú sverð við himininn, sverðu við hásæti Guðs og við Guð sjálfan. ");
INSERT INTO isl_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Farísear og aðrir leiðtogar, vei ykkur, því að þið eruð hræsnarar! Þið gætið þess að gjalda tíund, en skeytið ekkert um það sem meira er um vert, réttvísi, miskunnsemi og trúmennsku. Haldið áfram að gefa tíund, en látið hitt ekki ógjört sem mikilvægara er. ");
INSERT INTO isl_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Blindu leiðsögumenn! Þið tínið flugurnar úr matnum, en gleypið svo úlfaldann með húð og hári. ");
INSERT INTO isl_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Vei ykkur, farísear og trúarleiðtogar – hræsnarar! Þið nostrið við að fægja bollann og diskinn að utan, en gleymið að hann er mengaður kúgun og ágirnd að innan. ");
INSERT INTO isl_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Þú blindi farísei! Hreinsaðu fyrst bollann og diskinn að innan svo að hann verði allur hreinn. ");
INSERT INTO isl_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Vei ykkur, fræðimenn og farísear. Þið líkist kölkuðu grafhýsi, sem er fagurt að utan – en að innan fullt af ódaun, rotnun og dauðra manna beinum. ");
INSERT INTO isl_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Þið reynið að sýnast heilagir menn í annarra augum, en hjörtu ykkar eru menguð af hræsni og lögbrotum. ");
INSERT INTO isl_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","Vei ykkur, farísear og fræðimenn – hræsnarar! Þið reisið minnismerki um spámennina sem forfeður ykkar drápu, skreytið grafir guðrækinna manna, sem þeir einnig líflétu, og segið: „Aldrei hefðum við framið slíkt ódæði sem forfeður okkar.“ ");
INSERT INTO isl_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Með þessum orðum lýsið þið yfir að þið séuð synir vondra manna, ");
INSERT INTO isl_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","síðan fetið þið í fótspor þeirra og fullkomnið illverk þeirra. ");
INSERT INTO isl_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Eiturnöðrur og höggormssynir! Hvernig fáið þið umflúið dóm helvítis? ");
INSERT INTO isl_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ég sendi til ykkar spámenn og kennimenn. Suma þeirra munið þið krossfesta, en berja aðra í samkomuhúsum ykkar og ofsækja þá í borg eftir borg. ");
INSERT INTO isl_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Þannig berið þið ábyrgð á lífláti allra guðrækinna manna, allt frá Abel hinum réttláta til Sakaría Barakíasonar, sem þið drápuð milli altarisins og musterisins. ");
INSERT INTO isl_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Dómurinn fyrir glæpaverkin mun koma yfir þessa kynslóð.“ ");
INSERT INTO isl_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","„Jerúsalem, Jerúsalem, þú borg sem líflætur spámennina og grýtir þá sem sendir eru til þín. Oft hef ég viljað safna börnum þínum saman eins og hæna safnar ungum sínum undir vængi sína – en þið hafið ekki viljað það, ");
INSERT INTO isl_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Hús þín munu verða skilin eftir í eyði. ");
INSERT INTO isl_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Og þetta skaltu vita: Þú munt ekki sjá mig aftur fyrr en þú ert reiðubúin að taka á móti þeim, sem Guð sendir til þín.“ ");
INSERT INTO isl_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Þegar Jesús gekk út úr helgidóminum langaði lærisveinana að fá hann með sér í skoðunarferð um musterissvæðið. ");
INSERT INTO isl_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","En hann sagði við þá: „Þessar byggingar verða allar lagðar í rúst svo að ekki mun standa steinn yfir steini!“ ");
INSERT INTO isl_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Stuttu seinna þegar Jesús sat í hlíð Olíufjallsins gengu lærisveinarnir til hans og spurðu hann um þetta: „Hvenær verður það og hvaða atburðir verða á undan endurkomu þinni og endi veraldar?“ ");
INSERT INTO isl_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","„Látið engan blekkja ykkur,“ svaraði Jesús, ");
INSERT INTO isl_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","„því margir munu koma og segjast vera Kristur og leiða marga í villu. ");
INSERT INTO isl_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Þið munuð heyra stríðsfréttir, en þær eru ekki tákn um endurkomu mína. Því að styrjaldir halda áfram eins og verið hefur, en endirinn er ekki þar með kominn. ");
INSERT INTO isl_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Þjóðir og ríki jarðarinnar munu heyja styrjaldir sín á milli og hungursneyð og jarðskjálftar geisa víða. ");
INSERT INTO isl_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Þetta er aðeins byrjun hörmunganna sem koma. ");
INSERT INTO isl_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Þið verðið pyntaðir og líflátnir, og allir munu hata ykkur vegna þess að þið tilheyrið mér. ");
INSERT INTO isl_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Þá munu margir falla frá trúnni, og hata og svíkja hverjir aðra. ");
INSERT INTO isl_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Margir falsspámenn munu koma og leiða marga í villu. ");
INSERT INTO isl_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Afbrot aukast er kærleikur flestra kólnar, ");
INSERT INTO isl_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","en sá sem stöðugur stendur allt til enda mun frelsast. ");
INSERT INTO isl_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Gleðiboðskapurinn um guðsríki verður fluttur öllum þjóðum heimsins, og þá loks mun endirinn koma.“ ");
INSERT INTO isl_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","„Þegar þið sjáið viðurstyggð eyðingarinnar, sem Daníel spámaður talaði um, standandi á helgum stað – lesandinn athugi það! ");
INSERT INTO isl_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Þá verða þeir sem eru í Júdeu að flýja til fjalla, ");
INSERT INTO isl_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","þeir sem staddir eru á svölunum heima hjá sér, fari þá ekki inn til að taka saman föggur sínar áður en þeir flýja. ");
INSERT INTO isl_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Þeir sem þá verða á ökrum fari ekki heim eftir nauðsynjum. ");
INSERT INTO isl_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Neyð þeirra sem þá verða barnshafandi eða hafa fyrir ungbörnum að sjá, mun verða mikil. ");
INSERT INTO isl_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Biðjið að flótti ykkar verði ekki um vetur eða á helgidegi, ");
INSERT INTO isl_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","því þá verða meiri ofsóknir en nokkru sinni fyrr. ");
INSERT INTO isl_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Sannleikurinn er sá að yrði þessi tími ekki styttur, myndi allt mannkynið farast, en vegna hinna útvöldu mun tíminn verða styttur. ");
INSERT INTO isl_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ef einhver segir þá við þig: „Kristur er kominn á þennan eða hinn staðinn,“ eða „hann hefur birst hér eða þar,“ þá trúið því ekki. ");
INSERT INTO isl_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Falskristar munu koma fram og einnig falsspámenn, sem gera munu mikil kraftaverk til að blekkja fólk, jafnvel þá sem Guð hefur kallað. ");
INSERT INTO isl_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Munið að ég hef varað ykkur við. ");
INSERT INTO isl_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ef einhver kemur og segir ykkur að Kristur sé kominn aftur og sé úti í eyðimörkinni, þá sinnið því ekki og farið ekki þangað. Ef sagt er að hann sé í felum á tilteknum stað, þá trúið því ekki! ");
INSERT INTO isl_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ég, Kristur, mun koma jafn óvænt og eldingin sem leiftrar frá austri til vesturs! ");
INSERT INTO isl_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Reynið að skilja tákn tímanna á sama hátt og þið skiljið að þar muni hræið vera sem gammarnir safnast.“ ");
INSERT INTO isl_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","„Eftir þessar ofsóknir mun sólin myrkvast og tunglið hætta að lýsa. Stjörnurnar munu hrapa af himni og kraftar alheimsins ganga úr skorðum! ");
INSERT INTO isl_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Þá mun tákn komu minnar sjást á himninum og allir jarðarbúar skelfast. Þeir munu sjá mig koma í skýjum himinsins með mætti og mikilli dýrð. ");
INSERT INTO isl_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Þegar lúðurinn hljómar, munu englar mínir safna saman þeim sem ég hef valið, úr öllum áttum, heimshorna á milli.“ ");
INSERT INTO isl_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","„Lærið af fíkjutrénu: Þegar greinar þess eru orðnar mjúkar og laufið fer að springa út, þá vitið þið að sumarið er í nánd. ");
INSERT INTO isl_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Eins skuluð þið vita að þegar þið sjáið allt þetta, þá er endurkoma mín í nánd, ");
INSERT INTO isl_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","og þá fyrst mun þessi kynslóð líða undir lok.“ ");
INSERT INTO isl_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","„Himinn og jörð munu hverfa, en mín orð standa að eilífu. ");
INSERT INTO isl_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Enginn veit þann dag eða stund er endirinn verður, hvorki englarnir né sonur Guðs, aðeins faðirinn einn. ");
INSERT INTO isl_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","38","Fólk mun almennt taka öllu með ró eins og allt sé í lagi – það verða veisluhöld, mannfagnaðir og brúðkaup – rétt eins og var á dögum Nóa áður en flóðið kom. ");
INSERT INTO isl_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Menn trúðu ekki orðum Nóa fyrr en flóðið skall á og hreif þá alla burt. Þannig fer einnig við komu mína. ");
INSERT INTO isl_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tveir munu vinna á akri, annar verður tekinn en hinn skilinn eftir. ");
INSERT INTO isl_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tvær verða við heimilisstörf, önnur verður tekin en hin skilin eftir. ");
INSERT INTO isl_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Verið viðbúnir! Þið vitið ekki hvaða dag Drottinn kemur. ");
INSERT INTO isl_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Innbrotsþjófur gerir ekki boð á undan sér, þess vegna verða menn að vera á verði. ");
INSERT INTO isl_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Þess vegna verðið þið að vera stöðugt viðbúnir endurkomu minni.“ ");
INSERT INTO isl_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","„Hver er trúr og hygginn þjónn, sem húsbóndinn hefur falið umsjónarstarfið svo að allir fái fæðu sína á réttum tíma? ");
INSERT INTO isl_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","47","Sæll er sá þjónn sem húsbóndinn finnur að breytir þannig þegar hann kemur. Víst er að hann mun fela honum umsjón með öllu sem hann á. ");
INSERT INTO isl_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","En segi svikull þjónn við sjálfan sig: „Húsbóndinn kemur ekki strax,“ ");
INSERT INTO isl_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","og tekur að berja samstarfsmenn sína og stunda veislur og drykkjuskap ");
INSERT INTO isl_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","þá kemur húsbóndi hans honum að óvörum ");
INSERT INTO isl_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","og refsar honum sviksemina.“ ");
INSERT INTO isl_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","„Himnaríki má líkja við tíu brúðarmeyjar, sem tóku lampa sína og lögðu af stað til móts við brúðgumann. ");
INSERT INTO isl_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Aðeins fimm þeirra gættu þess að fylla lampa sína af olíu, en hinar fimm gleymdu því og fóru með tóma lampa. ");
INSERT INTO isl_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","6","Þegar brúðgumanum seinkaði, syfjaði þær og sofnuðu. En á miðnætti voru þær vaktar með háu hrópi: „Brúðguminn er að koma! Gangið út og takið á móti honum!“ ");
INSERT INTO isl_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","8","Stúlkurnar spruttu á fætur og fóru að sýsla við lampana. Þær fimm sem vantaði olíu, sárbáðu hinar að gefa sér lítið eitt, því það lifði ekki á lömpum þeirra. ");
INSERT INTO isl_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","En hinar svöruðu „Nei, það getum við ekki, því það verður ekki nóg handa okkur öllum. Farið og kaupið olíu handa ykkur.“ ");
INSERT INTO isl_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","En á meðan þær voru fjarverandi kom brúðguminn. Þær sem viðbúnar voru fóru með honum til brúðkaupsins og dyrunum var læst. ");
INSERT INTO isl_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Seinna komu hinar til baka og stóðu fyrir utan og kölluðu: „Herra, opnaðu fyrir okkur!“ ");
INSERT INTO isl_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","En hann kallaði á móti: „Farið! Þið komið of seint!“ ");
INSERT INTO isl_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Vakið því og verið viðbúnir, því þið vitið hvorki daginn né stundina er ég kem aftur.“ ");
INSERT INTO isl_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","„Himnaríki er einnig líkt manni sem fór til útlanda. Hann kallaði saman starfsmenn sína og afhenti þeim fé, sem þeir áttu að ávaxta meðan hann væri í burtu. ");
INSERT INTO isl_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Einum fékk hann tvær milljónir króna, öðrum eina milljón og hinum þriðja hálfa milljón. Þeir fengu misjafnlega mikið eftir hæfileikum sínum og dugnaði. Síðan fór hann úr landi. ");
INSERT INTO isl_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Maðurinn, sem fékk tvær milljónir, fór þegar að versla með peningana og græddi fljótt aðrar tvær milljónir. ");
INSERT INTO isl_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Sá sem fékk eina milljón, hófst handa eins og hinn og hagnaðist um aðra milljón. ");
INSERT INTO isl_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","En maðurinn, sem fékk hálfa milljón, gróf peningana í jörðu svo að hann tapaði þeim ekki. ");
INSERT INTO isl_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Eftir langan tíma kom húsbóndinn aftur úr ferðalaginu. Hann kallaði starfsmennina til sín svo að hann gæti gert upp við þá. ");
INSERT INTO isl_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Sá sem fengið hafði tvær milljónir kom og afhenti húsbónda sínum fjórar milljónir. ");
INSERT INTO isl_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Húsbóndinn hrósaði honum og sagði: „Þetta var vel af sér vikið. Þú varst trúr yfir litlu, nú mun ég setja þig yfir mikið. Komdu og við skulum gera okkur dagamun.“ ");
INSERT INTO isl_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Næst kom sá sem fengið hafði eina milljón. Hann sagði: „Herra þú lést mig fá eina milljón og nú hef ég tvöfaldað þá upphæð.“ ");
INSERT INTO isl_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","„Gott hjá þér!“ sagði húsbóndinn. „Þú ert góður og dyggur þjónn. Þú varst trúr yfir þessu lítilræði, en nú mun ég láta þig fá miklu meira. Komdu, við skulum gleðjast saman!“ ");
INSERT INTO isl_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","25","Síðast kom sá þriðji með sína hálfu milljón og sagði: „Herra, ég vissi að þú ert harður húsbóndi og þar sem ég bjóst við að þú rændir mig hagnaðinum, faldi ég peningana í jörðu og hér hefur þú þá!“ ");
INSERT INTO isl_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","„Letingi!“ svaraði húsbóndinn. „Þú vissir að ég krefði þig um hagnaðinn, ");
INSERT INTO isl_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","svo þú hefðir að minnsta kosti átt að setja peningana í banka til að ég fengi þó vexti. ");
INSERT INTO isl_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Takið peningana af þessum manni og látið þann, sem hefur fjórar milljónirnar, fá þá. ");
INSERT INTO isl_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Sá sem notar vel það sem honum er gefið, mun fá enn meira, og hafa allsnægtir, en sá sem er ótrúr, tapar því litla sem hann hefur. ");
INSERT INTO isl_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kastið nú þessum duglausa þjóni út í myrkrið. Þar verður grátið og kveinað.“ “ ");
INSERT INTO isl_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","„Þegar ég, Kristur, kem aftur í dýrð minni og allir englarnir með mér, mun ég setjast í hástól dýrðarinnar. ");
INSERT INTO isl_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Þá verður öllum þjóðunum safnað saman frammi fyrir mér og ég mun skilja fólkið að, eins og fjárhirðir aðskilur sauðfé og geitur. ");
INSERT INTO isl_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Kindunum mun ég skipa mér til hægri handar og geitunum til vinstri handar. ");
INSERT INTO isl_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Þá mun ég, konungurinn, segja við þá til hægri handar: „Komið, þið hinir blessuðu föður míns, inn í ríkið sem ykkur hefur verið ætlað frá því heimurinn varð til. ");
INSERT INTO isl_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ég var hungraður og þið gáfuð mér að borða, þyrstur og þið gáfuð mér að drekka. Ég var ókunnugur og þið buðuð mér inn á heimili ykkar. ");
INSERT INTO isl_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ég var fatalaus og þið klædduð mig. Ég var sjúkur, og í fangelsi og þið heimsóttuð mig.“ ");
INSERT INTO isl_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Þá svara hinir réttlátu og segja: „Herra, hvenær sáum við þig hungraðan og gáfum þér að borða, þyrstan og gáfum þér að drekka, ");
INSERT INTO isl_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","eða ókunnugan og hjálpuðum þér. Hvenær sáum við þig klæðalausan og klæddum þig, ");
INSERT INTO isl_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","og hvenær veikan eða í fangelsi og litum til þín?“ ");
INSERT INTO isl_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Þá mun ég, konungurinn, svara þeim og segja: „Þetta sem þið gerðuð bræðrum mínum, gerðuð þið mér.“ ");
INSERT INTO isl_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Síðan mun ég snúa mér að þeim sem eru til vinstri og segja: „Burt með ykkur, bölvaðir, í eilífa eldinn sem ætlaður er djöflinum og þjónum hans. ");
INSERT INTO isl_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ég var hungraður, en þið gáfuð mér ekki að borða, þyrstur og þið færðuð mér ekkert að drekka. ");
INSERT INTO isl_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ég var ókunnugur og þið sýnduð mér ekki gestrisni, klæðlaus og þið gáfuð mér enga flík. Ég var veikur og í fangelsi og þið heimsóttuð mig ekki.“ ");
INSERT INTO isl_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Þá munu þeir svara: „Drottinn, hvenær var það sem við sáum þig hungraðan eða þyrstan, ókunnugan, nakinn, sjúkan eða í fangelsi og hjálpuðum þér ekki?“ ");
INSERT INTO isl_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Þá mun ég svara: „Þegar þið neituðuð mínum minnsta bróður um hjálp, þá neituðuð þið mér.“ ");
INSERT INTO isl_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Og þeir munu fara burt til eilífrar refsingar, en hinir réttlátu til eilífs lífs.“ ");
INSERT INTO isl_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Þegar Jesús hafði lokið ræðu sinni, sagði hann við lærisveinana: ");
INSERT INTO isl_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","„Þið vitið að eftir tvo daga koma páskarnir og þá verð ég svikinn og krossfestur.“ ");
INSERT INTO isl_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Um svipað leyti héldu prestarnir fund, ásamt öðrum embættismönnum Gyðinga, í höll Kaífasar æðsta prests. ");
INSERT INTO isl_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Þeir voru að bollaleggja hvernig þeir gætu handtekið Jesú svo lítið bæri á og líflátið hann. ");
INSERT INTO isl_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","„En ekki á sjálfum páskunum, því þá er svo margt aðkomufólk í borginni og hætt við óeirðum,“ samþykktu þeir. ");
INSERT INTO isl_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús fór til Betaníu, heim til Símonar holdsveika. ");
INSERT INTO isl_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Meðan hann mataðist, kom þangað inn kona sem hélt á flösku með mjög dýrri ilmolíu, og hellti henni yfir höfuð hans. ");
INSERT INTO isl_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","9","Lærisveinarnir urðu gramir og sögðu sín á milli: „Til hvers er þessi sóun? Þetta hefði mátt selja fyrir stórfé og gefa peningana fátækum.“ ");
INSERT INTO isl_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús las hugsanir þeirra og sagði: „Hví eruð þið að hryggja konuna? Hún gerði góðverk á mér. ");
INSERT INTO isl_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Þið hafið ávallt fátæka hjá ykkur, en ekki mig. ");
INSERT INTO isl_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Hún hellti ilmvatni þessu yfir mig til þess að búa líkama minn til greftrunar. ");
INSERT INTO isl_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Hennar mun verða minnst og þess getið sem hún gerði, hvar sem fagnaðarboðskapurinn verður fluttur.“ ");
INSERT INTO isl_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Þá fór einn postulanna tólf, Júdas Ískaríot, til æðstu prestanna ");
INSERT INTO isl_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","og spurði: „Hve mikið viljið þið borga mér fyrir að koma Jesú í hendur ykkar?“ Þeir greiddu honum þrjátíu silfurpeninga. ");
INSERT INTO isl_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Upp frá því beið Júdas eftir hentugu tækifæri til að svíkja Jesú í hendur þeirra. ");
INSERT INTO isl_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Á fyrsta degi páskahátíðarinnar (Gyðingar fjarlægðu þegar allt súrdeig – gerbrauð – af heimilum sínum) komu lærisveinarnir til Jesú og spurðu hann: „Hvar eigum við að undirbúa páskamáltíðina?“ ");
INSERT INTO isl_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","„Farið inn í borgina,“ svaraði Jesús, „finnið mann nokkurn og segið við hann: „Meistari okkar segir: Minn tími er kominn. Hjá þér vil ég halda páska með lærisveinum mínum.“ “ ");
INSERT INTO isl_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Lærisveinarnir gerðu eins og Jesús sagði og undirbjuggu páskamáltíðina. ");
INSERT INTO isl_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","21","Þetta kvöld, þegar hann var sestur til borðs ásamt lærisveinunum tólf, sagði hann: „Ég veit að einn ykkar mun svíkja mig.“ ");
INSERT INTO isl_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Hryggð og ótti greip lærisveinana og þeir spurðu hver um sig: „Ekki þó ég?“ Jesús svaraði: ");
INSERT INTO isl_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","„Það er sá sem ég þjónaði fyrst í kvöld.“ ");
INSERT INTO isl_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","„Ég verð að deyja eins og spáð var, en vei þeim manni sem því veldur. Betra væri honum að hann hefði aldrei fæðst.“ ");
INSERT INTO isl_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Júdas sem varð til þess að svíkja hann, spurði líka: „Er það ég?“ Og Jesús svaraði: „Já.“ ");
INSERT INTO isl_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Meðan á máltíðinni stóð tók Jesús brauð, blessaði það og braut í sundur, rétti lærisveinunum og sagði: „Takið þetta og neytið, það er líkami minn.“ ");
INSERT INTO isl_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Og hann tók bikar með víni, gjörði þakkir, rétti þeim og sagði: „Drekkið allir hér af, ");
INSERT INTO isl_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","því þetta er blóð mitt, innsigli nýja sáttmálans. Því er úthellt til syndafyrirgefningar fyrir marga. ");
INSERT INTO isl_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Takið eftir þessum orðum mínum: Ég mun ekki drekka vín á ný fyrr en ég drekk það nýtt með ykkur í ríki föður míns.“ ");
INSERT INTO isl_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Þegar þeir höfðu sungið lofsöng fóru þeir út til Olíufjallsins. ");
INSERT INTO isl_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesús sagði við þá: „Í nótt munuð þið allir yfirgefa mig. Í Ritningunni stendur að Guð muni slá hirðinn og hjörðin tvístrast. ");
INSERT INTO isl_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","En eftir að ég er risinn upp frá dauðum fer ég til Galíleu og hitti ykkur þar.“ ");
INSERT INTO isl_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","„Þótt allir aðrir yfirgefi þig, mun ég ekki gera það,“ sagði Pétur. ");
INSERT INTO isl_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús svaraði: „Sannleikurinn er þó sá, að einmitt í nótt, áður en hani galar við sólarupprás, munt þú afneita mér þrisvar.“ ");
INSERT INTO isl_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","„Fyrr mun ég deyja!“ svaraði Pétur og allir hinir tóku í sama streng. ");
INSERT INTO isl_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jesús fór síðan með lærisveinana inn í garð sem heitir Getsemane, og bað þá að setjast niður meðan hann færi spölkorn lengra til að biðjast fyrir. ");
INSERT INTO isl_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Hann fékk með sér þá Pétur og bræðurna Jakob og Jóhannes Sebedeussyni. Mikill ótti og örvænting kom yfir Jesú og hann sagði: ");
INSERT INTO isl_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","„Sál mín er buguð af ótta og angist allt til dauða. Bíðið hér og vakið með mér.“ ");
INSERT INTO isl_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Hann gekk lítið eitt lengra, hneig til jarðar og bað: „Faðir minn! Taktu þennan bikar frá mér ef mögulegt er, en verði þó þinn vilji en ekki minn.“ ");
INSERT INTO isl_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Síðan kom hann aftur til lærisveinanna þriggja og fann þá sofandi. „Pétur!“ kallaði hann, „gastu ekki einu sinni vakað með mér eina stund? ");
INSERT INTO isl_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Vakið og biðjið, til þess að þið fallið ekki í freistni. Andinn er fús, en holdið er veikt!“ ");
INSERT INTO isl_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Hann fór frá þeim aftur og bað: „Faðir! Ef ekki er unnt að taka þennan bikar frá mér án þess að ég tæmi hann, þá verði þinn vilji.“ ");
INSERT INTO isl_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Síðan sneri hann aftur til þeirra og fann þá enn sofandi, því þeir gátu ekki haldið augunum opnum. ");
INSERT INTO isl_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Hann yfirgaf þá enn og baðst fyrir í þriðja sinn með sömu orðum. ");
INSERT INTO isl_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Eftir það fór hann aftur til lærisveinanna og sagði: „Sofið þið enn og hvílist? Stundin er komin! Ég hef verið svikinn í hendur vondra manna. ");
INSERT INTO isl_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Standið upp, förum! Sjáið! Þarna kemur sá sem svíkur mig.“ ");
INSERT INTO isl_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Meðan hann var enn að tala kom Júdas, einn postulana tólf, og með honum fjöldi manna, sem vopnaðir voru sverðum og bareflum. Þessa menn höfðu leiðtogar Gyðinga sent. ");
INSERT INTO isl_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Júdas hafði sagt þeim að handtaka þann sem hann heilsaði með kossi, því að hann væri maðurinn sem þeir vildu ná. ");
INSERT INTO isl_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Júdas gekk því beint til Jesú og sagði: „Sæll, meistari!“ ");
INSERT INTO isl_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","„Vinur minn,“ sagði Jesús, „hvers vegna komstu hingað?“ Þá gripu sendimennirnir Jesú. ");
INSERT INTO isl_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Einn lærisveina Jesú dró þá sverð úr slíðrum og hjó annað eyrað af þjóni æðsta prestsins. ");
INSERT INTO isl_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","„Slíðraðu sverðið!“ sagði Jesús. „Þeir sem beita sverði munu falla fyrir sverði. ");
INSERT INTO isl_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Veistu ekki að ég gæti beðið föður minn um þúsundir engla okkur til varnar og hann mundi þegar í stað senda þá? ");
INSERT INTO isl_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","En hvernig ættu orð Biblíunnar þá að rætast?“ ");
INSERT INTO isl_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Síðan ávarpaði Jesús mennina og sagði: „Er ég hættulegur afbrotamaður, fyrst þið þurftuð að koma vopnaðir sverðum og bareflum til að handtaka mig? Ég hef gengið um á meðal ykkar og kennt daglega í musterinu en þið handtókuð mig ekki. ");
INSERT INTO isl_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","En þetta, sem nú er að gerast er uppfylling spádóma Biblíunnar.“ Þá yfirgáfu allir lærisveinarnir hann og flúðu. ");
INSERT INTO isl_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Þeir sem handtóku Jesú fóru nú með hann til bústaðar Kaífasar, æðsta prestsins, því þar voru allir leiðtogar Gyðinga saman komnir. ");
INSERT INTO isl_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pétur læddist í humátt á eftir og smeygði sér inn í hallargarð æðsta prestsins og settist niður hjá þjónunum. Þar beið hann þess að sjá hvað yrði um Jesú. ");
INSERT INTO isl_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Æðstu prestarnir – og reyndar allur hæstiréttur Gyðinga – leituðu nú manna er borið gætu lognar sakir á Jesú. Ætlun þeirra var að höfða mál gegn honum og fá hann dæmdan til dauða. ");
INSERT INTO isl_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","En þótt þeir fyndu marga sem vildu bera falsvitni, þá bar vitnisburði þeirra ekki saman. Að lokum fundust þó tveir sem sögðu: „Þessi maður sagði: „Ég er fær um að brjóta niður musteri Guðs og reisa það aftur á þrem dögum.“ “ ");
INSERT INTO isl_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Þá stóð æðsti presturinn upp og sagði við Jesú: „Sagðir þú þetta? Svaraðu! Já, eða nei!“ ");
INSERT INTO isl_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesús þagði. Þá hélt æðsti presturinn áfram og sagði: „Ég krefst þess í nafni hins lifandi Guðs, að þú svarir eftirfarandi spurningu: Heldur þú því fram að þú sért Kristur, Guðssonurinn?“ ");
INSERT INTO isl_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","„Já, ég er hann og þú munt síðar sjá mig, Krist, sitja við hægri hönd Guðs og koma á skýjum himinsins,“ svaraði Jesús. ");
INSERT INTO isl_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","66","Þá reif æðsti presturinn klæði sín og hrópaði: „Guðlast! Nú þurfum við ekki frekar vitnanna við. Þið heyrðuð hann allir segja það! Hver er nú dómur ykkar?“ Þeir hrópuðu: „Hann skal deyja!“ ");
INSERT INTO isl_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Síðan hræktu þeir í andlit hans og slógu með prikum og sögðu: ");
INSERT INTO isl_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","„Kristur! Gettu hver sló þig núna?“ ");
INSERT INTO isl_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Á meðan þetta fór fram sat Pétur úti í hallargarðinum. Þá kom til hans stúlka og sagði: „Þú varst líka með Jesú og þið eruð báðir frá Galíleu.“ ");
INSERT INTO isl_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Þessu neitaði Pétur svo allir heyrðu og hrópaði reiðilega: „Ég veit ekki um hvað þú ert að tala!“ ");
INSERT INTO isl_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Seinna tók önnur stúlka eftir honum úti við hliðið og sagði við nærstadda: „Þessi maður var með Jesú frá Nasaret.“ ");
INSERT INTO isl_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pétur sór og sárt við lagði: „Ég þekki alls ekki manninn.“ ");
INSERT INTO isl_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Stuttu seinna komu þeir, sem þarna stóðu, til Péturs og sögðu: „Við vitum vel að þú ert einn af lærisveinum hans, því við heyrum á málfari þínu að þú ert frá Galíleu.“ ");
INSERT INTO isl_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Þá tók Pétur að blóta og sverja og sagði: „Ég þekki alls ekki þennan mann!“ Og um leið og hann sleppti orðinu gól hani. Þá minntist Pétur orða Jesú: ");
INSERT INTO isl_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","„Áður en hani galar, muntu þrisvar afneita mér.“ Og hann gekk út fyrir og grét sárt. ");
INSERT INTO isl_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Við dagrenningu hittust æðstu prestarnir og leiðtogarnir á ný til að ræða hvernig þeir ættu að fá Jesú dæmdan til dauða. ");
INSERT INTO isl_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Eftir það bundu þeir hann og sendu til Pílatusar, rómverska landstjórans. ");
INSERT INTO isl_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Þegar Júdasi, þeim er sveik hann, varð ljóst að Jesús hafði verið dæmdur til dauða, iðraðist hann gjörða sinna. Hann fór aftur með peningana til æðstu prestanna og hinna leiðtoganna og sagði: ");
INSERT INTO isl_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","„Ég hef syndgað með því að svíkja saklausan mann.“ „Það er þitt mál og þú um það!“ svöruðu þeir hranalega. ");
INSERT INTO isl_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Þá hljóp hann inn í musterið, fleygði peningunum á gólfið, fór síðan burt og hengdi sig. ");
INSERT INTO isl_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Æðstu prestarnir tíndu peningana upp og sögðu: „Okkur er óheimilt að setja þá í samskotabaukinn, því það er ólöglegt að leggja í hann peninga sem greiddir eru fyrir morð.“ ");
INSERT INTO isl_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Síðan ræddu þeir málið og ákváðu loks að kaupa akur nokkurn fyrir peningana, en þar fannst leir sem leirkerasmiðir notuðu við iðn sína. Þetta svæði gerðu þeir síðan að grafreit fyrir útlendinga sem létust í Jerúsalem, ");
INSERT INTO isl_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","og það er ástæða þess að grafreiturinn er enn kallaður „Blóðakur“. ");
INSERT INTO isl_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Þar með rættist spádómur Jeremía: „Og ég tók þessa þrjátíu silfurpeninga – en á það mátu Ísraelsmenn hann – ");
INSERT INTO isl_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","og keypti akur leirkerasmiðsins, eins og Drottinn hafði sagt mér að gera.“ ");
INSERT INTO isl_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Nú stóð Jesús frammi fyrir Pílatusi, rómverska landsstjóranum. „Ert þú Kristur, konungur Gyðinga,“ spurði landstjórinn. „Já,“ svaraði Jesús. ");
INSERT INTO isl_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Þá tóku æðstu prestarnir og leiðtogar þjóðarinnar að bera fram ákærur, en hann svaraði engu. ");
INSERT INTO isl_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","„Heyrirðu ekki hvað þeir segja?“ spurði Pílatus, ");
INSERT INTO isl_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","og honum til mikillar furðu svaraði Jesús engu orði. ");
INSERT INTO isl_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Landstjórinn var vanur að náða einn fanga ár hvert, á páskahátíðinni, einhvern þann sem fólkið kysi. ");
INSERT INTO isl_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Þetta árið var alræmdur glæpamaður að nafni Barrabas í fangelsi. ");
INSERT INTO isl_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pílatus spurði fólkið sem hafði safnast saman framan við höllina: „Hvorn viljið þið að ég náði, Barrabas eða Jesú, sem kallast Kristur?“ ");
INSERT INTO isl_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pílatusi var fullljóst að ástæðan fyrir því að leiðtogar Gyðinga höfðu handtekið Jesú var öfund vegna vinsælda hans meðal fólksins. ");
INSERT INTO isl_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","En rétt í þessu, meðan Pílatus var að stjórna málaferlunum, var komið með eftirfarandi skilaboð frá konu hans: „Láttu þennan góða mann í friði, því í nótt fékk ég hræðilega martröð hans vegna.“ ");
INSERT INTO isl_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Meðan Pílatus var að íhuga skilaboðin frá konu sinni, kepptust æðstu prestarnir og leiðtogar fólksins við að telja mannfjöldanum trú um að best væri að fá Barrabas lausan, en Jesú tekinn af lífi. ");
INSERT INTO isl_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Þegar Pílatus spurði aftur: „Hvorn þeirra viljið þið fá lausan?“ hrópaði múgurinn hátt: „Barrabas!“ ");
INSERT INTO isl_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","„Hvað á ég þá að gera við Jesú, sem kallast Kristur?“ spurði Pílatus. „Krossfestu hann!“ hrópaði mannfjöldinn. ");
INSERT INTO isl_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","„Hvers vegna?“ spurði Pílatus ákveðinn. „Hvað illt hefur hann gert?“ Þá hrópaði fólkið enn hærra: „Krossfestu hann! Krossfestu hann!“ ");
INSERT INTO isl_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Þegar Pílatus sá að hann kom engu til leiðar, og allt var að fara í upplausn, bað hann um skál með vatni, þvoði hendur sínar í augsýn mannfjöldans og sagði: „Ég er saklaus af blóði þessa góða manns. Þið berið ábyrgðina!“ ");
INSERT INTO isl_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Og múgurinn kallaði á móti: „Blóð hans komi yfir okkur og börnin okkar!“ ");
INSERT INTO isl_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Þá lét Pílatus Barrabas lausan, en lét húðstrýkja Jesú og afhenti hann rómversku hermönnunum til krossfestingar. ");
INSERT INTO isl_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Fyrst fóru þeir með hann í vopnabúrið og kölluðu saman alla herdeildina. ");
INSERT INTO isl_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Þeir afklæddu hann og færðu í skarlatsrauða skikkju. ");
INSERT INTO isl_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Síðan fléttuðu þeir kórónu úr hvössum þyrnum og settu hana á höfuð hans. Að því búnu létu þeir prik í hægri hönd hans – það átti að vera veldissproti – og krupu síðan frammi fyrir honum, hæddu hann og æptu: „Lengi lifi konungur Gyðinga!“ ");
INSERT INTO isl_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Og þeir hræktu á hann, rifu af honum prikið og börðu hann með því í höfuðið. ");
INSERT INTO isl_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Eftir þessa niðurlægingu færðu hermennirnir hann úr skikkjunni klæddu hann í hans eigin föt og fóru með hann til krossfestingar. ");
INSERT INTO isl_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Á leiðinni til aftökustaðarins mættu þeir manni frá Kýrene í Afríku, Símoni að nafni, og neyddu hann til að bera kross Jesú. ");
INSERT INTO isl_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Þeir komu nú á stað sem kallast Golgata, en það þýðir „hauskúpuhæð“. ");
INSERT INTO isl_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Þar gáfu hermennirnir Jesú beiskt vín til deyfingar, en þegar hann hafði bragðað það, vildi hann það ekki. ");
INSERT INTO isl_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Eftir að hermennirnir höfðu krossfest Jesú vörpuðu þeir hlutkesti um föt hans, ");
INSERT INTO isl_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","en síðan settust þeir niður til að halda vörð um hann. ");
INSERT INTO isl_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Þeir settu skilti á krossinn og þar stóð: Jesús, konungur Gyðinga. ");
INSERT INTO isl_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tveir ræningjar voru einnig krossfestir þennan sama morgun. ");
INSERT INTO isl_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Fólk, sem leið átti hjá, hreytti ónotum í Jesú, hristi höfuðið og sagði: ");
INSERT INTO isl_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","„Þú ert maðurinn sem getur brotið niður musterið og reist það aftur á þremur dögum. Komdu nú niður af krossinum, ef þú ert sonur Guðs!“ ");
INSERT INTO isl_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","43","Og æðstu prestarnir og leiðtogarnir hæddu hann einnig og sögðu með fyrirlitningu: „Hann bjargaði öðrum, en sjálfum sér getur hann ekki bjargað. Þú þykist vera konungur Ísraels. Komdu nú niður af krossinum og þá skulum við trúa á þig! Hann sagðist treysta Guði. Hvers vegna bjargar Guð honum þá ekki, ef hann hefur mætur á honum? Hann sagðist vera sonur Guðs, var það ekki?“ ");
INSERT INTO isl_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Á sama hátt smánuðu ræningjarnir hann. ");
INSERT INTO isl_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Um hádegið varð myrkur um alla jörðina í þrjár stundir, allt til klukkan þrjú. ");
INSERT INTO isl_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","En þá hrópaði Jesús hátt: „Elí, Elí, lama sabaktaní!“ Það þýðir „Guð minn, Guð minn, hví hefur þú yfirgefið mig?“ ");
INSERT INTO isl_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Sumir þeirra, sem þarna stóðu, misskildu þetta og héldu að hann væri að kalla á Elía spámann. ");
INSERT INTO isl_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Einn þeirra hljóp þá til og fyllti svamp af súru víni, setti hann á stöng og rétti Jesú það að drekka. ");
INSERT INTO isl_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","„Láttu hann eiga sig,“ sögðu hinir. „Sjáum til hvort Elía kemur að bjarga honum.“ ");
INSERT INTO isl_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Þá hrópaði Jesús aftur og gaf upp andann. ");
INSERT INTO isl_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Og í sama bili rofnaði fortjaldið í musterinu í tvennt, – en það huldi hið allra helgasta, – ofan frá og niður úr, jörðin skalf og björgin klofnuðu. ");
INSERT INTO isl_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Þá opnuðust margar grafir og heilagt fólk, sem þar hafði legið, lifnaði við. ");
INSERT INTO isl_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Eftir upprisu Jesú fór þetta fólk út úr gröfunum og gekk inn í Jerúsalem og birtist þar mörgum. ");
INSERT INTO isl_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Þegar foringinn og hermenn hans, sem gættu Jesú, fundu jarðskjálftann og sáu hvað gerðist, greip þá skelfing og þeir hrópuðu: „Þessi maður hefur áreiðanlega verið sonur Guðs!“ ");
INSERT INTO isl_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Margar konur, sem farið höfðu með Jesú frá Galíleu og þjónað honum, fylgdust úr fjarlægð með því sem fram fór. ");
INSERT INTO isl_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Þeirra á meðal var María Magdalena, María móðir Jakobs og Jóse, og móðir Jakobs og Jóhannesar (Sebedeussona.) ");
INSERT INTO isl_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Þegar kvöld var komið fór Jósef frá Arímaþeu, ríkur maður og vinur Jesú, ");
INSERT INTO isl_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","til Pílatusar og bað um lík Jesú. Pílatus lét honum það eftir. ");
INSERT INTO isl_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jósef tók þá líkið, vafði það í hreint léreft ");
INSERT INTO isl_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","og lagði í gröf, sem hann hafði nýlega látið höggva handa sjálfum sér. Síðan velti hann stórum steini fyrir dyr grafarinnar og fór burt. ");
INSERT INTO isl_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","María Magdalena og María hin sátu skammt frá og fylgdust með því sem gerðist. ");
INSERT INTO isl_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Daginn eftir – að kvöldi fyrsta dags páskahátíðarinnar – fóru farísearnir og æðstu prestarnir til Pílatusar ");
INSERT INTO isl_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","og sögðu: „Herra, svikari þessi sagði eitt sinn: „Eftir þrjá daga mun ég rísa upp.“ ");
INSERT INTO isl_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Við viljum því biðja þig að setja vörð við gröfina í þrjá daga til þess að lærisveinar hans komi ekki og steli líkinu, og segi svo öllum að hann hafi lifnað við. Ef svo færi, yrðu seinni svikin verri hinum fyrri!“ ");
INSERT INTO isl_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","„Notið ykkar eigin musterislögreglu,“ svaraði Pílatus, „hún ætti að geta gætt grafarinnar nægilega vel.“ ");
INSERT INTO isl_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Þeir fóru og gengu tryggilega frá gröfinni. Síðan settu þeir innsigli keisarans á steininn í viðurvist varðmannanna, til þess að gröfin yrði ekki opnuð. ");
INSERT INTO isl_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Þegar birti að morgni sunnudagsins fóru María Magdalena og María hin út til að líta eftir gröfinni. ");
INSERT INTO isl_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Skyndilega varð mikill jarðskjálfti! Engill Drottins kom niður af himni, velti steininum frá grafardyrunum og settist á hann. ");
INSERT INTO isl_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Andlit engilsins lýsti sem elding og klæði hans voru skínandi björt. ");
INSERT INTO isl_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Þegar verðirnir sáu hann skulfu þeir af hræðslu og féllu í yfirlið. ");
INSERT INTO isl_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Engillinn sagði þá við konurnar: „Verið óhræddar! Ég veit að þið leitið að Jesú hinum krossfesta, ");
INSERT INTO isl_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","en hann er ekki hér. Hann er upprisinn eins og hann sagði. Komið og sjáið hvar líkami hans lá. ");
INSERT INTO isl_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","En flýtið ykkur nú og segið lærisveinunum að hann sé risinn upp frá dauðum og að hann fari á undan þeim til Galíleu, til að hitta þá þar. Þessu átti ég að skila til ykkar.“ ");
INSERT INTO isl_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Konurnar urðu óttaslegnar en þó glaðar og þær flýttu sér frá gröfinni til að flytja lærisveinunum skilaboð engilsins. ");
INSERT INTO isl_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","En skyndilega mættu þær Jesú og hann heilsaði þeim! Þær féllu til jarðar frammi fyrir honum, gripu um fætur hans og tilbáðu hann. ");
INSERT INTO isl_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","„Verið óhræddar!“ sagði hann, „farið og segið bræðrum mínum að halda þegar til Galíleu og þar munu þeir sjá mig.“ ");
INSERT INTO isl_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Meðan konurnar voru á leið inn í borgina fóru sumir varðmannanna, sem gætt höfðu grafarinnar, til æðstu prestanna og sögðu þeim hvað gerst hafði. ");
INSERT INTO isl_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Allir leiðtogar Gyðinga voru kallaðir saman til fundar. Þar var ákveðið að múta vörðunum til að segja að þeir hefðu sofnað, og um miðja nótt hefðu svo lærisveinar Jesú komið og stolið líkinu. ");
INSERT INTO isl_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","„Þið þurfið engu að kvíða,“ sögðu leiðtogarnir. „Ef landstjórinn fréttir þetta tölum við máli ykkar við hann og friðum hann.“ ");
INSERT INTO isl_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Verðirnir tóku þá við mútufénu og gerðu eins og þeim hafði vefið sagt. Frásaga þeirra barst út á meðal Gyðinga og er henni jafnvel trúað enn í dag. ");
INSERT INTO isl_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Eftir þetta fóru lærisveinarnir ellefu til Galíleu, til fjallsins þar sem Jesús sagðist mundu hitta þá. ");
INSERT INTO isl_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Þegar þeir sáu hann þar, tilbáðu þeir hann – þó sumir væru ekki vissir um að þetta væri sjálfur Jesús. ");
INSERT INTO isl_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Síðan ávarpaði hann lærisveinana og sagði: „Allt vald er mér gefið á himni og jörðu. ");
INSERT INTO isl_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Farið því og gerið allar þjóðir að mínum lærisveinum. ");
INSERT INTO isl_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Skírið þá í nafni föður, sonar og heilags anda, og kennið þeim að halda allt það sem ég hef boðið ykkur. Takið eftir! Ég er með ykkur alla daga allt til enda veraldarinnar.“");
INSERT INTO isl_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Hér hefst hin einstæða frásaga af Jesú Kristi, syni Guðs. ");
INSERT INTO isl_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Í bók Jesaja spámanns stendur að Guð muni senda son sinn til jarðarinnar, en áður en hann komi, muni sérstakur sendiboði koma fram og búa heiminn undir komu hans. ");
INSERT INTO isl_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Jesaja sagði: „Þessi sendiboði mun búa í óbyggðinni og predika að sérhver maður verði að bæta líferni sitt til að vera viðbúinn komu Drottins.“ ");
INSERT INTO isl_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Þessi sendiboði var Jóhannes skírari. Hann dvaldist í óbyggðinni og boðaði að allir skyldu skírast og láta þannig opinberlega í ljós ákvörðun um að þeir sneru baki við syndinni og tækju á móti fyrirgefningu Guðs. ");
INSERT INTO isl_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Fólk frá Jerúsalem og allri Júdeu fór út í Júdeueyðimörkina til að sjá Jóhannes og heyra, og þá sem játuðu syndir sínar skírði hann í ánni Jórdan. ");
INSERT INTO isl_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Hann var í fötum úr úlfaldahári, hafði leðurbelti um mittið og nærðist á engisprettum og villihunangi. ");
INSERT INTO isl_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Hér er dæmi um predikun hans: „Innan skamms mun sá koma sem mér er máttugri, já, svo miklu meiri að ég er ekki einu sinni verður þess að vera þjónn hans. ");
INSERT INTO isl_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ég skíri ykkur með vatni en hann mun skíra ykkur með heilögum anda.“ ");
INSERT INTO isl_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Þá var það dag einn að Jesús kom frá Nasaret í Galíleu og Jóhannes skírði hann í Jórdan. ");
INSERT INTO isl_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Um leið og Jesús steig upp úr vatninu, sá hann himnana opnast og heilagan anda koma yfir sig í dúfulíki. ");
INSERT INTO isl_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Og rödd af himnum sagði: „Þú ert minn elskaði sonur sem ég hef velþóknun á.“ ");
INSERT INTO isl_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","13","Strax að skírninni lokinni knúði heilagur andi Jesú út í eyðimörkina, og þar var hann einn í fjörutíu daga og Satan freistaði hans. Jesús hafðist þar við meðal eyðimerkurdýranna og englar þjónuðu honum. ");
INSERT INTO isl_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Eftir að Heródes konungur hafði látið fangelsa Jóhannes fór Jesús til Galíleu og boðaði þar fagnaðarerindi Guðs. ");
INSERT INTO isl_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","„Stundin er komin,“ sagði hann. „Guðsríki er nálægt! Snúið ykkur frá syndinni og trúið gleðiboðskapnum.“ ");
INSERT INTO isl_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Dag einn er Jesús gekk fram með Galíleuvatninu sá hann bræðurna Símon og Andrés, þeir voru fiskimenn og voru einmitt þessa stundina að leggja netin. ");
INSERT INTO isl_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesús kallaði til þeirra og sagði: „Komið og fylgið mér. Ég skal kenna ykkur að veiða menn!“ ");
INSERT INTO isl_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Þá yfirgáfu þeir netin og fóru með honum. ");
INSERT INTO isl_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Í öðrum bát, skammt frá, voru synir Sebedeusar, Jakob og Jóhannes, að bæta net sín. ");
INSERT INTO isl_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Hann kallaði einnig á þá og þeir skildu Sebedeus og verkamennina eftir í bátnum og fóru á eftir honum. ");
INSERT INTO isl_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesús og félagar hans komu nú til bæjarins Kapernaum og að morgni helgidagsins fóru þeir til samkomuhússins þar sem Gyðingar héldu guðsþjónustur sínar. Þar predikaði Jesús og ");
INSERT INTO isl_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","fólkið undraðist ræðu hans, því að hann talaði eins og sá sem hefur mikið vald en reyndi ekki að sanna mál sitt með sífelldum tilvitnunum í orð annarra eins og venja var. ");
INSERT INTO isl_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Við guðsþjónustuna var maður haldinn illum anda sem tók að hrópa og kalla: ");
INSERT INTO isl_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","„Jesús frá Nasaret, af hverju læturðu okkur ekki í friði? Ertu kannski kominn til að gera út af við okkur illu andana? Ég veit hver þú ert, þú ert hinn heilagi sonur Guðs!“ ");
INSERT INTO isl_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús skipaði andanum að þegja og fara úr manninum. ");
INSERT INTO isl_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Þá æpti illi andinn og hristi manninn ofsalega og fór síðan út af honum. ");
INSERT INTO isl_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Fólkið varð forviða og spurði sín á milli: „Eru þetta ný trúarbrögð? Jafnvel illir andar hlýða honum!“ ");
INSERT INTO isl_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Og fréttin af atburði þessum barst hratt um alla Galíleu. ");
INSERT INTO isl_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","30","Þegar Jesús og lærisveinar hans yfirgáfu samkomuhúsið fóru þeir heim til Símonar og Andrésar, þar sem tengdamóðir Símonar lá með mikinn hita. Þeir sögðu Jesú þegar frá henni. ");
INSERT INTO isl_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Hann gekk að rúminu, tók um hönd hennar og hjálpaði henni að setjast upp og um leið fór hitinn úr henni. Hún klæddi sig og gaf þeim að borða. ");
INSERT INTO isl_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Um kvöldið fylltist garðurinn við húsið af sjúklingum sem færðir höfðu verið til Jesú, ásamt öðrum sem haldnir voru illum öndum. Mikill fjöldi bæjarbúa stóð fyrir utan og fylgdist með. ");
INSERT INTO isl_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Þetta kvöld læknaði Jesús mjög marga og rak illa anda út af mörgum. (Hann bannaði öndunum að tala, því þeir vissu hver hann var.) ");
INSERT INTO isl_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Morguninn eftir var Jesús kominn á fætur löngu fyrir dögun og fór einn á óbyggðan stað til að biðjast fyrir. ");
INSERT INTO isl_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","37","Símon og hinir leituðu hann uppi og þegar þeir höfðu fundið hann sögðu þeir: „Allir eru að spyrja um þig.“ ");
INSERT INTO isl_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","En hann svaraði: „Við verðum einnig að fara til hinna þorpanna og predika þar, því til þess er ég kominn.“ ");
INSERT INTO isl_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Og Jesús ferðaðist um alla Galíleu, predikaði í samkomuhúsunum og leysti marga undan valdi illu andanna. ");
INSERT INTO isl_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Eitt sinn kom holdsveikur maður, kraup frammi fyrir honum og bað um lækningu. „Þú getur læknað mig ef þú vilt,“ sagði hann biðjandi. ");
INSERT INTO isl_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús fann til með honum, snerti hann og sagði: „Ég vil það! Læknist þú!“ ");
INSERT INTO isl_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Samstundis hvarf holdsveikin og maðurinn varð heilbrigður. ");
INSERT INTO isl_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Jesús sagði við hann, ákveðinni röddu: „Farðu nú til prestanna og láttu þá skoða þig. Hafðu hvergi viðdvöl og talaðu ekki við neinn á leiðinni. Taktu með fórnina, sem Móse fyrirskipar þeim, sem læknast af holdsveiki, og þá munu allir sjá að þú ert orðinn heilbrigður.“ ");
INSERT INTO isl_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","En maðurinn sagði öllum sem hann mætti á leiðinni að hann væri heill og þar af leiðandi gat Jesús ekki komið opinberlega til neins bæjar án þess að forvitinn mannfjöldi þyrptist að honum. Hann varð því að hafast við úti í óbyggðinni og þangað streymdi fólkið til hans hvaðanæva að. ");
INSERT INTO isl_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nokkrum dögum síðar sneri Jesús aftur til Kapernaum og fyrr en varði vissu bæjarbúar að hann var kominn heim. ");
INSERT INTO isl_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Á skammri stundu var húsið sem hann dvaldist í orðið svo þéttsetið að fleiri komust ekki þangað inn og meira að segja þröng úti fyrir. Þarna flutti hann orð Guðs. ");
INSERT INTO isl_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Þá komu þar menn sem báru lamaðan mann á börum á milli sín. ");
INSERT INTO isl_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Þeir komust ekki að Jesú vegna mannfjöldans og rufu því gat á leirþakið og létu börurnar með veika manninum síga niður til Jesú. ");
INSERT INTO isl_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Þegar Jesús sá trú þeirra – hversu sannfærðir þeir voru um að hann gæti hjálpað – sagði hann við lamaða manninn: „Sonur minn, syndir þínar eru fyrirgefnar!“ ");
INSERT INTO isl_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nokkrir trúarleiðtogar þjóðarinnar urðu vitni að þessum atburði og hugsuðu með sér: ");
INSERT INTO isl_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","„Hvað er að heyra? Þetta er guðlast! Hann heldur þó ekki að hann sé Guð? Hver getur fyrirgefið syndir nema Guð einn?“ ");
INSERT INTO isl_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesús las hugsanir þeirra og sagði: „Hvers vegna hugsið þið svona? ");
INSERT INTO isl_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Er nokkuð erfiðara að fyrirgefa syndir hans en að lækna hann? ");
INSERT INTO isl_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ég skal sanna ykkur að ég, maðurinn frá himnum, hef fyrirgefið honum syndir hans.“ ");
INSERT INTO isl_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Síðan sneri hann sér að lamaða manninum og sagði: „Taktu börurnar og farðu heim. Þú ert heilbrigður.“ ");
INSERT INTO isl_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Maðurinn spratt á fætur, tók börurnar og ruddi sér leið gegnum mannfjöldann, sem var agndofa af undrun. Og fólkið tók að lofa Guð og hrópa: „Við höfum aldrei séð neitt þessu líkt.“ ");
INSERT INTO isl_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Eftir þetta gekk Jesús niður að vatninu og talaði við mannfjöldann sem þar safnaðist að honum. ");
INSERT INTO isl_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Á leið sinni fram hjá skattstofunni sá hann Leví Alfeusson sitja þar. „Komdu og vertu lærisveinn minn.“ sagði Jesús við hann. Þá stóð Leví upp og fylgdi honum. ");
INSERT INTO isl_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Um kvöldið bauð Leví vinnufélögum sínum á skattstofunni og mörgum sem illt orð fór af, til kvöldverðar, svo þeir gætu hitt Jesú og lærisveina hans. (Í þeim fjölda sem fylgdi Jesú höfðu ekki heldur allir gott orð á sér.) ");
INSERT INTO isl_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Þegar trúarleiðtogar fólksins sáu hann matast með þessum mönnum, sögðu þeir við lærisveina hans: „Hvernig í ósköpunum getur hann fengið af sér að borða með þvílíkum ruslaralýð?“ ");
INSERT INTO isl_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Þegar Jesús heyrði þetta, sagði hann við þá: „Veikir þurfa lækni en heilbrigðir ekki! Ég kom ekki til að hvetja hina „góðu“ til að iðrast synda sinna, heldur þá sem vondir eru.“ ");
INSERT INTO isl_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nú stóð yfir fasta hjá lærisveinum Jóhannesar og faríseunum (en þá neyttu þeir ekki matar af trúarástæðum). Menn komu þá til Jesú og sögðu við hann: „Af hverju fasta þínir lærisveinar ekki eins og hinir?“ ");
INSERT INTO isl_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús svaraði og sagði: „Hvað gera vinir brúðgumans? Hafna þeir kræsingunum í brúðkaupsveislu hans, og eiga þeir að vera daprir í bragði meðan hann er hjá þeim? Nei! ");
INSERT INTO isl_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","En sá dagur kemur að hann verður tekinn frá þeim og þá munu þeir fasta. ");
INSERT INTO isl_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Hver bætir gamla flík með bót sem á eftir að hlaupa? Hvað mundi þá gerast? Bótin mundi hlaupa í fyrsta þvotti og rifna frá og gatið verða ennþá stærra en áður. ");
INSERT INTO isl_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Þið vitið að ekki má setja nýtt vín í gamla skinnbelgi, þá rifna þeir, vínið fer allt niður og belgirnir eyðileggjast. Nýtt vín er sett á nýja belgi.“ ");
INSERT INTO isl_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Seinna – á helgidegi var Jesús ásamt lærisveinum sínum á gangi yfir akur. Lærisveinarnir brutu þá öx af stráunum og átu úr þeim kornið. ");
INSERT INTO isl_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Þá sögðu farísearnir við Jesú: „Þetta mega þeir ekki gera! Það er lagabrot að uppskera korn á helgidegi.“ ");
INSERT INTO isl_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","En hann sagði við þá: „Hafið þið aldrei heyrt hvað Davíð gerði þegar hann og menn hans hungraði? Þeir fóru inn í helgidóm Guðs – það var þegar Abíatar var æðsti prestur – og átu brauðið sem ætlað var prestunum. Það var einnig lagabrot. ");
INSERT INTO isl_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Helgidagurinn varð til mannsins vegna en ekki maðurinn vegna helgidagsins. ");
INSERT INTO isl_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ég, Kristur, hef vald til að ákveða hvað menn mega gera á helgidögum.“ ");
INSERT INTO isl_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Meðan Jesús var í Kapernaum fór hann aftur í samkomuhúsið. Þar tók hann eftir manni með bæklaða hönd. ");
INSERT INTO isl_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Þetta var á helgidegi og því fylgdust óvinir Jesú nákvæmlega með honum. Skyldi hann lækna manninn? Ef svo færi, þá ætluðu þeir að kæra hann. ");
INSERT INTO isl_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesús bað manninn að koma og standa frammi fyrir söfnuðinum. ");
INSERT INTO isl_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Síðan sneri hann sér að óvinum sínum og spurði: „Er leyfilegt að vinna gott verk á helgidegi? Eða er þessi dagur til illverka? Hvort má frekar bjarga lífi eða deyða?“ ");
INSERT INTO isl_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesús horfði reiðilega á þá, því honum blöskraði miskunnarleysi þeirra gagnvart mannlegri neyð. Síðan sagði hann við manninn: „Réttu fram hönd þína.“ Maðurinn gerði svo og um leið varð hönd hans heilbrigð! ");
INSERT INTO isl_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Farísearnir fóru þá til fundar við Heródesarsinnana, því þeir ætluðu í sameiningu að finna ráð til að taka Jesú af lífi. ");
INSERT INTO isl_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Jesús fór þá ásamt lærisveinunum niður að vatninu. Gífurlegur fjöldi fylgdi honum úr allri Galíleu, Júdeu, Jerúsalem, Ídúmeu, frá landsvæðunum handan Jórdanárinnar og jafnvel alla leið frá Týrus og Sídon. Ástæðan var sú að fréttir af kraftaverkum hans höfðu borist víða og margir vildu sjá hann með eigin augum. ");
INSERT INTO isl_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jesús sagði lærisveinunum að hafa smábát til taks handa sér, sem hann gæti farið út í er fólkið tæki að þrengja að honum. ");
INSERT INTO isl_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Hann hafði læknað marga þennan dag og því dreif að fjölda sjúklinga, sem reyndi að snerta hann. ");
INSERT INTO isl_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Þegar þeir sem haldnir voru illum anda, sáu hann, féllu þeir til jarðar við fætur hans og æptu: „Þú ert sonur Guðs.“ ");
INSERT INTO isl_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Þá skipaði hann öndunum að segja engum hver hann væri. ");
INSERT INTO isl_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","15","Næsta dag fór Jesús upp í fjalllendið og boðaði þangað til sín vissa menn úr lærisveinahópnum. Þegar þeir voru komnir valdi hann tólf úr hópnum til að vera með sér, fara í predikunarferðir og reka út illa anda. ");
INSERT INTO isl_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Þetta eru nöfn þeirra sem hann valdi: Símon (sem hann gaf nafnið Pétur), Jakob og Jóhannes (synir Sebedeusar, en þá kallaði Jesús „þrumusynina“), Andrés, Filippus, Bartólómeus, Matteus, Tómas, Jakob Alfeusson, Taddeus, Símon (Selóti – hann var í byltingarsinnuðum stjórnmálaflokki, sem aðhylltist byltingu gegn rómversku landstjórninni) og Júdas Ískaríot (sem síðar sveik hann). ");
INSERT INTO isl_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Þegar Jesús kom aftur heim, tók fólkið að þyrpast að á ný og ekki leið á löngu uns gestirnir voru orðnir svo margir að hann hafði ekki einu sinni næði til að matast. ");
INSERT INTO isl_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Þegar vinir hans heyrðu hvernig ástatt var, komu þeir og vildu fá hann með sér heim til sín. „Hann er ekki með sjálfum sér.“ sögðu þeir. ");
INSERT INTO isl_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Fræðimenn þjóðarinnar, sem komnir voru frá Jerúsalem, sögðu: „Vandi Jesús er sá, að Satan, foringi illu andanna, er í honum og þess vegna hlýða illu andarnir honum.“ ");
INSERT INTO isl_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesús kallaði þessa menn til sín og spurði með dæmi, sem allir skildu: „Hvernig getur Satan rekið Satan út? ");
INSERT INTO isl_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Sundrað ríki mun falla. ");
INSERT INTO isl_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Heimili, þar sem hver höndin er upp á móti annarri, leysist upp. ");
INSERT INTO isl_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Þar af leiðir að ef Satan berst gegn sjálfum sér, þá fær hann ekki staðist og það er úti um hann. ");
INSERT INTO isl_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Sterkan mann verður að binda áður en hægt er að ræna úr húsi hans (og eins verður að binda Satan áður en hægt er að reka þessa illu anda hans út). ");
INSERT INTO isl_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ég lýsi því yfir að sérhverja þá synd, sem mennirnir kunna að drýgja – jafnvel lastmæli gegn mér – er hægt að fyrirgefa, ");
INSERT INTO isl_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","en last gegn heilögum anda verður aldrei fyrirgefið. Það er eilíf synd.“ ");
INSERT INTO isl_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Þetta sagði hann þeim vegna þess að þeir héldu því fram að hann gerði kraftaverk í mætti Satans (í stað þess að viðurkenna að það væri fyrir kraft heilags anda). ");
INSERT INTO isl_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","32","Rétt í þessu komu móðir hans og bræður að húsinu, sem þegar var fullt út úr dyrum. Þau sendu honum boð um að koma út og tala við sig. „Móðir þín og bræður eru úti og spyrja um þig,“ var sagt við hann. ");
INSERT INTO isl_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","„Hver er móðir mín?“ spurði hann. „Og hverjir eru bræður mínir?“ ");
INSERT INTO isl_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Síðan leit hann á þá sem umhverfis hann voru og sagði: „Þessir eru móðir mín og bræður. ");
INSERT INTO isl_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Hver sá, sem gerir vilja Guðs, er bróðir minn, systir eða móðir.“ ");
INSERT INTO isl_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Seinna, þegar mikill fjöldi hafði safnast að honum á strönd Galíleuvatnsins, fór hann út í bát og talaði þaðan til fólksins. ");
INSERT INTO isl_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Hann var vanur að kenna fólkinu í dæmisögum og hér er ein þeirra: ");
INSERT INTO isl_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","„Takið eftir! Bóndi nokkur fór út á akur að sá korni. ");
INSERT INTO isl_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Er hann sáði féll sumt af sáðkorninu á götuna og fuglarnir komu og átu það upp. ");
INSERT INTO isl_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","Sumt féll í grýtta jörð, þar sem jarðvegur var grunnur. Það korn spratt fljótt, en skrælnaði fyrr en varði í hitanum og dó, því það hafði nær engar rætur. ");
INSERT INTO isl_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Annað lenti meðal þyrna sem uxu yfir það og kæfðu það. ");
INSERT INTO isl_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","En sumt af útsæðinu féll í góða jörð og gaf af sér þrítugfalda, sextugfalda eða jafnvel hundraðfalda uppskeru. ");
INSERT INTO isl_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Sá sem hefur eyru til að heyra, taki eftir þessu.“ ");
INSERT INTO isl_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Þegar Jesús var orðinn einn með lærisveinunum spurðu þeir hann: „Hvað þýðir sagan sem þú sagðir áðan?“ ");
INSERT INTO isl_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","12","Jesús svaraði: „Þið fáið að læra margt um guðsríkið, sem hulið er þeim er utan við það standa. Jesaja spámaður sagði: „Þótt þeir sjái og heyri, skilja þeir ekki, né snúa sér til Guðs til þess að fá syndir sínar fyrirgefnar.“ ");
INSERT INTO isl_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Hvernig fer um allar hinar dæmisögurnar, ef þið skiljið ekki þessa einföldu sögu. ");
INSERT INTO isl_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Bóndinn, sem ég sagði ykkur frá, er sá sem flytur öðrum boðskap Guðs. Hann reynir að sá góðu sæði í hjörtu fólksins. ");
INSERT INTO isl_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Troðni stígurinn, þar sem sumt af korninu féll, lýsir hörðum hjörtum, sem heyra orð Guðs, en Satan kemur þegar í stað og reynir að fá þau til að gleyma því. ");
INSERT INTO isl_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Grýtti jarðvegurinn lýsir hjörtum þeirra sem hlusta með ánægju, ");
INSERT INTO isl_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","en það fer fyrir þeim eins og fyrir ungum plöntum í slíkum jarðvegi, ræturnar ná ekki djúpt og þó allt gangi vel í byrjun, þá visna þær – þeir gefast upp jafnskjótt og andstaða og erfiðleikar byrja. ");
INSERT INTO isl_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Þyrnarnir lýsa hjörtum þeirra sem hlusta á gleðitíðindin og taka við þeim. ");
INSERT INTO isl_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","En fyrr en varir hefur athygli þeirra beinst að því sem heimurinn hefur að bjóða og að táli auðæfanna. Löngun í metorð og alls kyns gæði gagntekur hug þeirra, svo þar verður ekkert rúm fyrir orð Guðs. Afleiðingin verður sú að fræið ber engan þroskaðan ávöxt. ");
INSERT INTO isl_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Góði jarðvegurinn táknar hjörtu þeirra sem í sannleika hlusta á Guðs orð og taka við því heils hugar og bera ríkulegan ávöxt – þrjátíu, sextíu eða jafnvel hundrað sinnum meira en upphaflega var sáð til í hjörtu þeirra.“ ");
INSERT INTO isl_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesús sagði við lærisveinana: „Á að byrgja ljósið, þegar kveikt hefur verið á lampanum eða setja hann undir bekk? Nei, auðvitað ekki, því þá kæmi ljósið að engum notum! Lampinn er látinn á góðan stað til að lýsa sem best. ");
INSERT INTO isl_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Dag einn mun allt sem nú er hulið koma í ljós. ");
INSERT INTO isl_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Hlustið, þið sem eyru hafið! ");
INSERT INTO isl_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Gætið þess um fram allt að gera eins og ég segi ykkur, leggið ykkur fram við að skilja orð mín. ");
INSERT INTO isl_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Þeim sem hefur, mun verða gefið, en frá þeim sem ekkert á, mun jafnvel verða tekið það sem hann hefur. ");
INSERT INTO isl_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Hér er önnur líking um guðsríki: Bóndi sáði í akur sinn. ");
INSERT INTO isl_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tíminn leið og kornið óx dag og nótt án þess að maðurinn hjálpaði þar nokkuð til. ");
INSERT INTO isl_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Moldin gaf vöxtinn. Fyrst skutu kímblöðin upp kollinum og síðar mynduðust öxin á kornstönglunum og að lokum þroskaðist kornið. ");
INSERT INTO isl_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Þá kom bóndinn með sigðina og skar kornið.“ ");
INSERT INTO isl_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Síðan spurði Jesús: „Hverju líkist guðsríki? Hvaða dæmisögu eigum við að nota til að lýsa því? ");
INSERT INTO isl_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Það er eins og örlítið sinnepsfræ! Þótt þetta fræ sé minnsta allra frækorna, þá vex upp af því jurt sem verður öllum jurtum stærri og ber langar greinar þar sem fuglarnir geta byggt hreiður sín og leitað skjóls.“ ");
INSERT INTO isl_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Þannig fræddi Jesús fólkið með dæmisögum sem voru í samræmi við skilning þess, ");
INSERT INTO isl_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","dæmisögulaust talaði hann ekki til þess. Þegar hann var orðinn einn með lærisveinum sínum eftir slíkar stundir, útskýrði hann dæmisögurnar fyrir þeim. ");
INSERT INTO isl_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Þegar kvöldaði sagði Jesús við lærisveinana: „Við skulum fara yfir vatnið.“ ");
INSERT INTO isl_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Þá yfirgáfu þeir fólkið á ströndinni og lögðu af stað. Nokkrir bátar fylgdu á eftir þeim. ");
INSERT INTO isl_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Skyndilega gerði mikið rok og gaf mjög á bátinn, svo við lá að hann fyllti. ");
INSERT INTO isl_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesús svaf í skutnum og hafði kodda undir höfðinu. Lærisveinarnir vöktu hann skelfingu lostnir og hrópuðu: „Meistari, sérðu ekki að við erum að farast?“ ");
INSERT INTO isl_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Þá hastaði Jesús á vindinn og sagði við vatnið: „Hafðu hægt um þig.“ Þá lygndi og allt varð kyrrt og hljótt! ");
INSERT INTO isl_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Síðan sneri hann sér að þeim og spurði: „Hvers vegna voruð þið svona hræddir? Hafið þið ekki enn lært að treysta mér?“ ");
INSERT INTO isl_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Hræddir, en fullir lotningar, sögðu þeir hver við annan: „Hver er þessi maður? Bæði vindur og vatn hlýða honum.“ ");
INSERT INTO isl_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","2","Þeir komu að landi austan megin vatnsins. Þegar Jesús var að stíga upp úr bátnum, hljóp þar að maður, haldinn illum anda. ");
INSERT INTO isl_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Hann hélt sig annars í og við grafirnar, og var slíkt heljarmenni að í hvert skipti sem hann var fjötraður – og það gerðist oft – sleit hann í sundur handjárnin, reif af sér hlekkina og fór sína leið. Enginn hafði afl til að yfirbuga hann. ");
INSERT INTO isl_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Hann æddi nætur og daga æpandi um milli grafanna og út í auðnina, og risti sig til blóðs með hvössum steinum. ");
INSERT INTO isl_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Maðurinn hafði séð til bátsins úti á vatninu. Hann kom hlaupandi til móts við Jesú og varpaði sér að fótum hans. ");
INSERT INTO isl_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jesús sagði þá við illa andann sem í manninum var: „Út með þig, illi andi.“ Andinn rak þá upp skelfilegt öskur og spurði: „Hvað ætlar þú að gera við okkur, Jesús, sonur hins æðsta Guðs? Við biðjum þig, láttu okkur ekki kveljast.“ ");
INSERT INTO isl_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","„Hvað heitir þú?“ spurði Jesús. „Hersing.“ svaraði andinn, „því við erum margir í þessum manni.“ ");
INSERT INTO isl_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Því næst báðu andarnir hann að senda sig ekki burt. ");
INSERT INTO isl_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Meðan þetta gerðist var stór svínahjörð á beit í hlíðinni upp af vatninu. ");
INSERT INTO isl_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","„Sendu okkur í svínin þarna,“ báðu andarnir. ");
INSERT INTO isl_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesús leyfði þeim það. Þá fóru andarnir úr manninum og í svínin. Við það tók öll hjörðin á rás og æddi niður bratta hlíðina, fram af klettunum og drukknaði í vatninu. ");
INSERT INTO isl_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Svínahirðarnir flýðu til nærliggjandi bæja og sögðu, á hlaupunum, frá því sem gerst hafði. Fjöldi fólks þusti þá af stað til að sjá þetta með eigin augum. ");
INSERT INTO isl_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Og þegar fólkið sá manninn sitja þar, klæddan og með fullu viti, varð það hrætt. ");
INSERT INTO isl_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Þeir sem vitni höfðu orðið að atburðinum, sögðu öðrum frá ");
INSERT INTO isl_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","og þegar fólkið hafði heyrt frásögnina, bað það Jesú að fara og láta sig í friði! ");
INSERT INTO isl_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesús fór því aftur um borð í bátinn, en þá bað maðurinn, sem haft hafði illu andana, hann að leyfa sér að koma með, ");
INSERT INTO isl_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","en Jesús leyfði það ekki. „Farðu heim til þín og þinna,“ sagði hann; „og segðu þeim hve mikið Guð hefur gert fyrir þig, og hversu hann hefur miskunnað þér.“ ");
INSERT INTO isl_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Maðurinn fór því til þorpanna tíu þar í héraðinu og sagði öllum frá þeim stórkostlegu hlutum sem Jesús hafði gert fyrir hann, og undruðust það allir. ");
INSERT INTO isl_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Þegar Jesús var kominn til baka yfir vatnið, safnaðist að honum fjöldi fólks. ");
INSERT INTO isl_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jaírus, forstöðumaður samkomuhúss staðarins, kom þangað, laut honum, ");
INSERT INTO isl_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","og bað hann heitt og innilega að lækna litlu dóttur sína. „Hún er að deyja,“ sagði hann, angistarfullur. „Gerðu það fyrir mig að koma og leggja hendur þínar yfir hana, svo að hún lifi og verði heilbrigð.“ ");
INSERT INTO isl_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesús fór með honum og allt fólkið fylgdi á eftir. ");
INSERT INTO isl_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Í mannþrönginni að baki Jesú var kona sem hafði haft innvortis blæðingar í tólf ár. ");
INSERT INTO isl_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Árum saman hafði hún þolað þjáningarfullar aðgerðir lækna og eytt í það aleigu sinni, en henni hafði stöðugt versnað. ");
INSERT INTO isl_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Hún hafði heyrt um dásamleg kraftaverk sem Jesús vann, og því læddist hún nú aftan að honum í mannþyrpingunni og snerti föt hans. ");
INSERT INTO isl_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Hún hugsaði: „Ef ég bara gæti snert hann, þá verð ég heilbrigð.“ ");
INSERT INTO isl_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Og það gerðist einmitt! Um leið og hún kom við hann, stöðvaðist blæðingin og hún fann að hún hafði læknast! ");
INSERT INTO isl_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesús varð á sömu stund var við að lækningakraftur fór út af honum. Hann sneri sér því við í mannfjöldanum og spurði: „Hver snerti mig?“ ");
INSERT INTO isl_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","„Fólkið þrýstir að þér á alla vegu og þú spyrð hver hafi snert þig,“ svöruðu lærisveinarnir undrandi. ");
INSERT INTO isl_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","En Jesús horfði í kring um sig til að finna þann sem hafði snert hann. ");
INSERT INTO isl_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Þegar konan sá það, kom hún, hrædd og skjálfandi, kraup niður og sagði honum alla söguna. ");
INSERT INTO isl_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","„Dóttir,“ sagði Jesús við hana, „trú þín hefur læknað þig. Þú ert heilbrigð af sjúkdómi þínum, farðu í friði.“ ");
INSERT INTO isl_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Meðan hann var að tala við hana, kom sendiboði frá heimili Jaírusar. Hann sagði að nú væri allt orðið um seinan – stúlkan væri dáin og tilgangslaust að láta Jesú koma úr þessu. ");
INSERT INTO isl_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","En Jesús lét sem hann heyrði þetta ekki og sagði við Jaírus: „Vertu ekki hræddur. Trúðu á mig og treystu mér.“ ");
INSERT INTO isl_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jesús bað nú mannfjöldann að nema staðar og leyfði engum að fara með sér inn í hús Jaírusar, nema Pétri, Jakobi og Jóhannesi. ");
INSERT INTO isl_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Þegar inn kom sá Jesús að allt var þar í uppnámi, fólkið grét og kveinaði. ");
INSERT INTO isl_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Hann sagði við það: „Hvað á allur þessi grátur og hávaði að þýða? Barnið er ekki dáið, það sefur.“ ");
INSERT INTO isl_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Þá hló fólkið að honum, en hann skipaði því að fara út og tók síðan með sér lærisveinana þrjá og foreldra stúlkunnar og fór inn til hennar. ");
INSERT INTO isl_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","42","Hann tók í höndina á barninu og sagði: „Stúlka litla, rís þú upp.“ Jafnskjótt reis hún á fætur og fór að ganga um gólfið! (Hún var tólf ára). Foreldrar hennar urðu frá sér numdir af gleði. ");
INSERT INTO isl_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesús lagði áherslu á að þau segðu þetta engum og bað þau síðan að gefa henni eitthvað að borða. ");
INSERT INTO isl_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Skömmu síðar yfirgaf hann héraðið og sneri aftur ásamt lærisveinum sínum til Nasaret, þar sem hann hafði átt heima. ");
INSERT INTO isl_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","Á helgideginum fór hann í samkomuhúsið til að kenna. Bæjarbúar undruðust visku hans og kraftaverk, því að hann var frá Nasaret eins og þeir. „Hvar hefur hann lært þetta?“ spurði fólkið. „Hann er ekkert betri en við! Hann er bara smiður – sonur hennar Maríu, bróðir Jakobs, Jósefs, Júdasar og Símonar og systur hans búa líka hér í Nasaret.“ Og allir hneyksluðust á honum. ");
INSERT INTO isl_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Þá sagði Jesús: „Hvergi er spámaður minna metinn en í heimabæ sínum og meðal fjölskyldu sinnar og ættingja.“ ");
INSERT INTO isl_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Og vegna vantrúar þeirra gat hann ekki gert neitt kraftaverk þar, nema hann lagði hendur yfir nokkra sjúka og læknaði þá. ");
INSERT INTO isl_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Hann furðaði sig á vantrú þeirra. Eftir þetta fór Jesús til ýmissa þorpa og kenndi. ");
INSERT INTO isl_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Hann kallaði til sín lærisveinana tólf og sendi þá af stað tvo og tvo saman og gaf þeim vald til að reka út illa anda. ");
INSERT INTO isl_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Hann sagði þeim að hafa ekkert með sér nema göngustaf – ekkert nesti eða farangur, enga peninga og jafnvel ekki skó eða föt til skiptanna. ");
INSERT INTO isl_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","„Hvar sem þið komið eða hafið viðdvöl í borg eða bæ, þá dveljist allan tímann á sama heimili, en farið ekki frá einu heimili til annars. ");
INSERT INTO isl_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Sé einhverstaðar hvorki tekið á móti ykkur né hlustað á orð ykkar, skuluð þið dusta rykið af fótum ykkar um leið og þið farið þaðan. Það er merki þess að þið hafið ofurselt þorpið örlögum sínum.“ ");
INSERT INTO isl_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Lærisveinarnir héldu nú af stað og hvöttu alla til að iðrast og snúa baki við syndinni. ");
INSERT INTO isl_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Þeir ráku út marga illa anda og smurðu fjölda fólks með ólífuolíu og læknuðu það. ");
INSERT INTO isl_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ekki leið á löngu uns Heródes konungur frétti um Jesú, því að alls staðar var verið að tala um kraftaverk hans. Konungurinn hélt að Jesús væri Jóhannes skírari risinn upp frá dauðum og því sagði fólk: „Nú, það er þá ekkert skrítið þótt hann geti gert slík kraftaverk.“ ");
INSERT INTO isl_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Aðrir héldu að Jesús væri Elía, hinn forni spámaður, endurborinn, og enn aðrir töldu hann vera nýjan spámann, svipaðan hinum miklu spámönnum fyrri alda. ");
INSERT INTO isl_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","„Nei, þetta er Jóhannes, maðurinn sem ég lét hálshöggva, hann er risinn upp frá dauðum,“ sagði Heródes. ");
INSERT INTO isl_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Heródes hafði sent hermenn til að handtaka og fangelsa Jóhannes, því Jóhannes hafði alltaf haldið því fram við Heródes að rangt væri af honum að kvænast Heródías, konu Filippusar bróður síns. ");
INSERT INTO isl_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Heródías vildi því hefna sín á Jóhannesi með því að láta drepa hann, en það gat hún ekki án samþykkis Heródesar. ");
INSERT INTO isl_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Heródes bar hins vegar virðingu fyrir Jóhannesi, því hann vissi að hann var góður og heilagur maður, og því hélt hann hlífiskildi yfir honum. Heródesi líkaði vel að tala við Jóhannes, þótt samviska hans yrði óróleg í hvert sinn. ");
INSERT INTO isl_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Loksins sá Heródías sér þó leik á borði. Það var á afmælisdegi Heródesar, en þá bauð hann hallarþjónum sínum og herforingjum, auk helstu fyrirmanna úr Galíleu, til veislu. ");
INSERT INTO isl_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","Dóttir Heródíasar kom þá inn í veislusalinn og dansaði fyrir gestina, öllum til mikillar ánægju. Þá sagði Heródes við stúlkuna: „Þú mátt óska þér hvers sem þú vilt og ég skal gefa þér það, jafnvel hálft konungsríkið.“ ");
INSERT INTO isl_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Stúlkan fór til móður sinnar og ráðfærði sig við hana. Þar fékk hún þetta ráð: „Biddu um höfuð Jóhannesar skírara.“ ");
INSERT INTO isl_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Stúlkan flýtti sér aftur til konungsins og sagði: „Ég vil fá höfuð Jóhannesar skírara á fati – og það strax.“ ");
INSERT INTO isl_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Konungurinn varð hryggur, en þorði þó ekki að ganga á bak orða sinna frammi fyrir öllum gestunum. ");
INSERT INTO isl_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Hann skipaði því einum lífvarða sinna að fara til fangelsisins og hálshöggva Jóhannes og koma með höfuð hans. Hermaðurinn fór og hjó Jóhannes í fangelsinu. ");
INSERT INTO isl_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Síðan kom hann með höfuð hans á fati og rétti stúlkunni, sem fór með það til móður sinnar. ");
INSERT INTO isl_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Þegar lærisveinar Jóhannesar fréttu hvað gerst hafði, sóttu þeir lík hans og jarðsettu það. ");
INSERT INTO isl_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Lærisveinarnir tólf komu nú aftur til Jesú úr predikunarferð sinni og sögðu honum frá öllu því sem þeir höfðu sagt og gert. ");
INSERT INTO isl_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Þá sagði Jesús: „Við skulum yfirgefa mannfjöldann um stund og hvíla okkur.“ Fólk var alltaf að koma og fara, svo að þeir höfðu varla næði til að matast. ");
INSERT INTO isl_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Þeir lögðu því af stað á bátnum og ætluðu á óbyggðan stað. ");
INSERT INTO isl_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","En mannfjöldinn sá til ferða þeirra, hljóp fram með vatninu og tók á móti þeim þegar þeir komu að landi! ");
INSERT INTO isl_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Hann mætti því aftur sama fólki þegar hann steig út úr bátnum. Og Jesús kenndi í brjósti um fólkið, því það var eins og fjárhópur án hirðis, og hann tók að kenna því margt sem það þurfti að vita. ");
INSERT INTO isl_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Þegar á daginn leið komu lærisveinarnir til hans og sögðu: „Segðu nú fólkinu að fara til þorpanna og bóndabæjanna í grenndinni og kaupa sér mat. Hér í óbyggðinni er ekkert að fá, og nú er framorðið.“ ");
INSERT INTO isl_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","„Þið skuluð gefa þeim að borða,“ sagði Jesús. „Já, en hvernig?“ spurðu þeir. „Það kostar stórfé að fæða allan þennan fjölda.“ ");
INSERT INTO isl_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","„Athugið hvað við höfum mikinn mat með okkur.“ sagði Jesús. Þeir komu aftur og sögðu honum að það væru fimm brauð og tveir fiskar. ");
INSERT INTO isl_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Jesús skipaði þá fólkinu að setjast niður. Fljótlega hafði það skipt sér í fimmtíu eða hundrað manna hópa og sest í grasið. ");
INSERT INTO isl_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Hann tók nú brauðin fimm og fiskana, horfði upp til himins og þakkaði Guði. Síðan braut hann brauðin og rétti lærisveinunum þau ásamt fiskunum og sagði þeim að bera það til fólksins. ");
INSERT INTO isl_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Og allir urðu mettir, ");
INSERT INTO isl_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","44","en karlmennirnir einir voru um fimm þúsund, auk kvenna og barna. Að máltíðinni lokinni var afganginum safnað úr grasinu og fyllti hann tólf körfur! ");
INSERT INTO isl_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Eftir þetta bauð Jesús lærisveinunum að fara um borð í bátinn og sigla yfir vatnið til Betsaída, en þar ætlaði hann að hitta þá seinna. Sjálfur ætlaði hann að staldra við, kveðja fólkið og koma því af stað heim. ");
INSERT INTO isl_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Þegar því var lokið gekk Jesús upp á fjallið til að biðjast fyrir. ");
INSERT INTO isl_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Um nóttina þegar lærisveinarnir voru komnir út á mitt vatnið, var Jesús einn á ströndinni. ");
INSERT INTO isl_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Það var hvasst á vatninu og hann sá að róðurinn var þungur hjá þeim. Um klukkan þrjú um morguninn kom hann til þeirra gangandi á vatninu. Hann gekk til hliðar við bátinn eins og hann ætlaði fram hjá. ");
INSERT INTO isl_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Þegar þeir sáu einhvern á gangi við bátshliðina urðu þeir ofsahræddir og æptu, því þeir héldu að þetta væri vofa ");
INSERT INTO isl_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","– þeir sáu hann allir. Þá sneri hann sér að þeim og sagði: „Þetta er ég! Verið óhræddir.“ ");
INSERT INTO isl_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Síðan steig hann upp í bátinn og þá lygndi! Lærisveinarnir sátu agndofa og skildu hvorki upp né niður í öllu þessu. ");
INSERT INTO isl_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Þeir gerðu sér ekki enn grein fyrir hver hann var, þrátt fyrir kraftaverkið kvöldið áður. Það var eins og þeir vildu ekki trúa. ");
INSERT INTO isl_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Þegar þeir komu til Genesaret hinum megin vatnsins stigu þeir á land og bundu bátinn. ");
INSERT INTO isl_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Fólk sem stóð þar hjá, þekkti hann undir eins, ");
INSERT INTO isl_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","og hljóp um allt til að láta vita að hann væri kominn. Nú var hafist handa um að færa til hans veikt fólk á börum og dýnum. ");
INSERT INTO isl_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Hvar sem hann fór – í bæi eða borgir – lagði fólk hina veiku á markaðstorgin eða strætin og bað hann um að leyfa þeim að snerta, þó ekki væri nema faldinn á skikkju hans, og þeir sem það gerðu læknuðust, og hið sama gerðist á bóndabæjum þar sem hann kom. ");
INSERT INTO isl_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Dag nokkurn komu trúarleiðtogarnir frá Jerúsalem til að fylgjast með Jesú. ");
INSERT INTO isl_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Þeir tóku eftir því að sumir lærisveina hans skeyttu engu reglum þeim sem farið var eftir áður en menn neyttu matar. ");
INSERT INTO isl_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Gyðingar, og sérstaklega farísear, mötuðust aldrei nema þeir hefðu, samkvæmt sérstökum trúarsiðum, þvegið sér um hendurnar. ");
INSERT INTO isl_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Þegar þeir komu heim af markaðnum, urðu þeir alltaf að þvo sér á þennan hátt áður en þeir snertu matinn. Þetta var aðeins ein af mörgum reglum þeirra og lögum sem þeir hafa fylgt öldum saman og gera enn. Ein reglan er til dæmis sérstakur trúarlegur þvottur á pottum, pönnum og diskum.) ");
INSERT INTO isl_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Trúarleiðtogarnir spurðu því Jesú. „Hvers vegna hlýða lærisveinar þínir ekki aldagömlum venjum okkar? Þeir borða án þess að þvo sér, en það er brot á reglunum.“ ");
INSERT INTO isl_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","„Þið hræsnarar!“ svaraði Jesús. „Jesaja spámaður lýsti ykkur vel þegar hann sagði: „Fólk þetta talar fagurlega um Drottin, en það elskar hann ekki. Tilbeiðsla þess er einskis virði, því það heldur því fram að það sé skipun Guðs að fólk hlýði öllum þeirra ómerkilegu reglum.“ Jesaja hafði sannarlega rétt fyrir sér! ");
INSERT INTO isl_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Þið virðið að vettugi skýr boð Guðs en takið í staðinn upp ykkar eigin siðvenjur. ");
INSERT INTO isl_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Með þessu hafnið þið boðum Guðs og traðkið á þeim, til þess eins að gera eins og ykkur langar. ");
INSERT INTO isl_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Móse sagði til dæmis: „Heiðraðu föður þinn og móður.“ Hann sagði einnig að hver sá er formælti foreldrum sínum væri dauðasekur. ");
INSERT INTO isl_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Þið segið hins vegar að í lagi sé að menn sinni ekki þörfum foreldra sinna og segi við þau: „Mér þykir leitt að geta ekki hjálpað ykkur, en ég hef gefið Guði það sem ég annars hefði gefið ykkur.“ ");
INSERT INTO isl_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","13","Þannig brjótið þið boðorð Guðs til að geta hlýtt ykkar eigin mannaboðorðum. Þetta er aðeins eitt dæmi, en ég gæti nefnt mörg önnur.“ ");
INSERT INTO isl_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Síðan kallaði Jesús á fólkið og sagði: „Takið eftir, og reynið að skilja. ");
INSERT INTO isl_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Sálir ykkar bíða ekki tjón af því sem þið borðið, heldur hinu sem þið hugsið og segið.“ ");
INSERT INTO isl_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Að því búnu fór hann í húsið til að fá næði fyrir fólkinu. Þá spurðu lærisveinar hans hvað hann hefði átt við með þessum orðum. ");
INSERT INTO isl_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","„Eruð þið líka svona skilningslausir?“ spurði hann. „Getið þið ekki skilið að það sem þið borðið skaðar ekki sál ykkar, ");
INSERT INTO isl_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","því maturinn kemst ekki í snertingu við sálina, hann fer aðeins í gegnum meltingarfærin.“ (Með þessu átti hann við að leyfilegt væri að neyta hvaða matar sem er.) ");
INSERT INTO isl_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Síðan bætti hann við: „Það er hugarfarið sem spillir manninum. ");
INSERT INTO isl_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Frá hjarta hans koma illar hugsanir, girnd, þjófnaður, morð, hórdómur, ");
INSERT INTO isl_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","eftirsókn eftir eigum annarra, illmennska, sviksemi, saurlifnaður, öfund, baktal, hroki og alls konar heimska. ");
INSERT INTO isl_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Allt þetta illa kemur innan frá og spillir og óhreinkar manninn í augum Guðs?“ ");
INSERT INTO isl_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Eftir þetta fór Jesús frá Galíleu og norður til héraðanna umhverfis Týrus og Sídon. Hann reyndi að fara huldu höfði en án árangurs. Fréttirnar um komu hans bárust um allt eins og venjulega. ");
INSERT INTO isl_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kona ein sem þarna var kom til hans. Hún átti dóttur sem haldin var illum anda. Hún hafði heyrt um Jesú og því kom hún nú, kraup við fætur hans, ");
INSERT INTO isl_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","og grátbað hann að losa dótturina við illa andann. (Konan var frá sýrlensku Fönikíu og því heiðingi í augum Gyðinga.) ");
INSERT INTO isl_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesús svaraði henni og sagði: „Fyrst verð ég að hjálpa samlöndum mínum – Gyðingunum. Það er ekki rétt að taka matinn frá börnunum og kasta honum til hvolpanna.“ ");
INSERT INTO isl_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","„Rétt er það, herra, en hvolparnir týna þó upp molana sem börnin leifa,“ sagði hún. ");
INSERT INTO isl_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","„Rétt,“ sagði hann, „þú svaraðir vel – svo vel, að nú hef ég læknað dóttur þína! Farðu nú heim – illi andinn er farinn út af henni.“ ");
INSERT INTO isl_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Þegar konan kom heim lá litla stúlkan róleg í rúminu; illi andinn var farinn. ");
INSERT INTO isl_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Frá Týrus fór Jesús til Sídonar og síðan til Dekapólis (þorpanna tíu) við Galíleuvatnið. ");
INSERT INTO isl_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Þá var leiddur til hans maður sem bæði var heyrnarlaus og mállaus. Bað fólkið Jesú að leggja hendur yfir hann og lækna hann. ");
INSERT INTO isl_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesús fór með hann afsíðis, stakk fingrunum í eyru hans og vætti tungu hans með munnvatni sínu. ");
INSERT INTO isl_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Síðan horfði hann upp til himins, andvarpaði og sagði: „Opnist þú.“ ");
INSERT INTO isl_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Um leið fékk maðurinn fulla heyrn og talaði skýrt! ");
INSERT INTO isl_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesús bannaði fólkinu að láta þetta fréttast, en því meir sem hann bannaði það, því meir var það borið út, ");
INSERT INTO isl_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","kraftaverkið hafði mikil áhrif á alla. Fólk sagði: „Allt sem hann gerir er gott. Hann getur meira að segja gefið heyrnarlausum heyrn og mállausum mál.“ ");
INSERT INTO isl_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Dag einn um þessar mundir safnaðist mikill mannfjöldi að honum og nú varð fólkið matarlaust á ný. Jesús kallaði þá saman lærisveinana til að ræða málið. ");
INSERT INTO isl_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","„Ég finn til með fólkinu,“ sagði hann. „Nú hefur það verið hér í þrjá daga og allur matur er upp urinn. ");
INSERT INTO isl_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ef ég sendi það heim matarlaust mun það örmagnast á leiðinni, því margir eiga langt heim.“ ");
INSERT INTO isl_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","„En er nokkurn mat að finna hér í óbyggðinni?“ spurðu lærisveinarnir. ");
INSERT INTO isl_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","„Hvað eigið þið mörg brauð?“ spurði hann. „Sjö,“ svöruðu þeir. ");
INSERT INTO isl_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Þá sagði hann fólkinu að setjast niður. Síðan tók hann brauðin og þakkaði Guði. Hann braut þau í sundur, rétti lærisveinunum og þeir síðan fólkinu. ");
INSERT INTO isl_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Þeir höfðu einnig nokkra smáfiska sem Jesús þakkaði líka fyrir og bað þá að tilreiða. ");
INSERT INTO isl_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Allir viðstaddir borðuðu sig metta og að því búnu sendi hann þá heim. Þarna voru um fjögur þúsund manns og þegar leifunum hafði verið safnað saman eftir máltíðina, fylltu þær sjö stórar körfur! ");
INSERT INTO isl_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Strax að þessu loknu fór hann á bátnum ásamt lærisveinunum og hélt til Dalmanútahéraðs. ");
INSERT INTO isl_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Þegar leiðtogar staðarins fréttu að Jesús væri kominn, fóru þeir til hans til að þrátta við hann. „Gerðu nú eitthvert kraftaverk fyrir okkur,“ sögðu þeir. „Láttu eitthvað birtast á himninum og þá skulum við trúa á þig.“ ");
INSERT INTO isl_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Þegar hann heyrði þetta stundi hann þungan og sagði: „Nei, ég hef alls ekki hugsað mér að gefa ykkur slíkt tákn.“ ");
INSERT INTO isl_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Síðan steig hann aftur um borð í bátinn og hélt yfir vatnið. ");
INSERT INTO isl_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Þeir höfðu þá aðeins eitt brauð meðferðis því lærisveinarnir höfðu gleymt að birgja sig upp af mat áður en þeir lögðu frá landi. ");
INSERT INTO isl_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Á leiðinni yfir vatnið sagði Jesús við lærisveinana alvarlegur í bragði: „Varið ykkur á súrdeigi Heródesar konungs og faríseanna.“ ");
INSERT INTO isl_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","„Hvað á hann nú við?“ spurðu lærisveinarnir hver annan. Að lokum komust þeir að þeirri niðurstöðu að hann hlyti að eiga við brauðið sem þeir höfðu gleymt að kaupa. ");
INSERT INTO isl_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús vissi um hvað þeir voru að tala og sagði því: „Nei, ég á alls ekki við það! Skiljið þið mig ekki? ");
INSERT INTO isl_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Það er satt sem Jesaja sagði. „Augun eru til að sjá, en hvers vegna notið þið þau ekki? Og hvers vegna hlustið þið ekki, til þess eru eyrun.“ Munið þið ekkert eða hvað? ");
INSERT INTO isl_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Hvað um fimm þúsundirnar sem ég mettaði með brauðunum fimm? Og hvað fylltuð þið margar körfur með brauðmolum á eftir?“ „Tólf,“ svöruðu þeir. ");
INSERT INTO isl_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","„Og þegar ég lét sjö brauð nægja handa fjórum þúsundum, varð þá eitthvað eftir?“ „Sjö fullar körfur,“ svöruðu þeir. ");
INSERT INTO isl_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","„Haldið þið þá enn að ég kvíði brauðleysinu?“ ");
INSERT INTO isl_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Þegar þeir stigu á land í Betsaída var komið með blindan mann og Jesús beðinn að lækna hann. ");
INSERT INTO isl_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesús leiddi blinda manninn út úr bænum, spýtti í augu hans og lagði hendur sínar yfir þau. „Sérðu núna?“ spurði Jesús. ");
INSERT INTO isl_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Maðurinn leit í kring um sig. „Já,“ svaraði hann, „ég sé fólk, en ég sé óskýrt, það er eins og trjástofnar.“ ");
INSERT INTO isl_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Þegar Jesús hafði lagt hendur sínar yfir augu mannsins í annað sinn horfði hann athugull í kringum sig, því nú sá hann allt mjög skýrt. ");
INSERT INTO isl_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesús sagði að hann skyldi halda rakleiðis heim til fjölskyldu sinnar en ekki koma við í bænum á leiðinni. ");
INSERT INTO isl_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesús og lærisveinar hans fóru nú frá Galíleu og til þorpanna í grennd við Sesareu Filippí. Á leiðinni spurði hann þá: „Hvað heldur fólk um mig? Hver heldur það að ég sé?“ ");
INSERT INTO isl_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","„Sumir halda að þú sért Jóhannes skírari,“ svöruðu lærisveinarnir. „Aðrir segja að þú sért Elía eða einhver hinna fornu spámanna risinn upp frá dauðum.“ ");
INSERT INTO isl_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","„En þið?“ spurði hann, „hvern segið þið mig vera?“ Og Pétur svaraði: „Þú ert Kristur.“ ");
INSERT INTO isl_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Þá áminnti Jesús þá um að tala ekki um þetta við nokkurn mann. ");
INSERT INTO isl_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Síðan sagði hann þeim frá þjáningunum sem biðu hans, að honum yrði hafnað af öldungunum, æðstu prestunum og öðrum leiðtogum þjóðarinnar, og eftir það yrði hann deyddur, en risi upp frá dauðum á þriðja degi. ");
INSERT INTO isl_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Hann talaði svo opinskátt við þá um þetta, að Pétur vék honum afsíðis og ávítaði hann. „Svona mátt þú ekki tala,“ sagði Pétur. ");
INSERT INTO isl_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesús sneri sér við, leit á lærisveinana og sagði síðan við Pétur ákveðinni röddu: „Burt með þig, Satan! Þú lítur á málið frá mannlegu sjónarmiði en ekki Guðs.“ ");
INSERT INTO isl_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Síðan kallaði hann á lærisveinana og allt fólkið og sagði: „Vilji einhver fylgja mér, þá afneiti hann sjálfum sér, taki upp kross sinn og fylgi mér fast eftir, ");
INSERT INTO isl_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","því hver sá sem vill eiga líf sitt fyrir sjálfan sig, mun tapa því. Þeir einir, sem afneita sjálfum sér vegna mín og gleðiboðskaparins, munu kynnast lífinu í raun og veru. ");
INSERT INTO isl_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Hvaða gagn er að því að eignast allan heiminn, ef maður týnir við það sálu sinni? ");
INSERT INTO isl_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Er sál mannsins ekki það dýrmætasta sem hann á? ");
INSERT INTO isl_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Þegar ég kem aftur í dýrð föðurins með heilögum englum, mun ég blygðast mín fyrir hvern þann sem blygðast sín fyrir mig og mín orð á þessum tímum syndar og vantrúar.“ ");
INSERT INTO isl_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús hélt áfram að tala við lærisveina sína og sagði: „Sumir ykkar, sem hér standa, munu lifa það að sjá guðsríki – vald Guðs og stjórn – koma með miklum krafti.“ ");
INSERT INTO isl_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sex dögum síðar tók Jesús þá Pétur, Jakob og Jóhannes eina með sér upp á hátt fjall. Skyndilega sáu þeir að andlit hans sveipaðist dýrlegum ljóma ");
INSERT INTO isl_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","og föt hans urðu skínandi björt – hvítari en nokkur föt geta orðið. ");
INSERT INTO isl_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Síðan birtust Móse og Elía og fóru að ræða við Jesú! ");
INSERT INTO isl_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","„Meistari, þetta er stórkostlegt!“ hrópaði Pétur. „Við skulum reisa hér þrjú skýli, eitt handa þér, annað handa Móse og það þriðja handa Elía.“ ");
INSERT INTO isl_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Þetta sagði hann bara til að segja eitthvað, því hann vissi ekki hvað hann átti að gera, og raunar voru þeir allir skelfingu lostnir. ");
INSERT INTO isl_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","En áður en Pétur hafði lokið við setninguna, kom ský yfir þá, sem skyggði á sólina, og þeir heyrðu rödd úr skýinu, sem sagði: „Þessi er minn elskaði sonur. Hlustið á hann.“ ");
INSERT INTO isl_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Er þeir litu í kring um sig, sáu þeir engan nema Jesú einan, – Móse og Elía voru horfnir. ");
INSERT INTO isl_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Á leiðinni niður af fjallinu bað hann þá að segja engum frá því sem þeir höfðu séð, ekki fyrr en hann væri risinn upp frá dauðum. ");
INSERT INTO isl_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Þeir þögðu því um þetta við aðra en ræddu það oft sín á milli og veltu þá fyrir sér hvað hann hefði átt við með orðunum „risinn upp frá dauðum“. ");
INSERT INTO isl_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","En þarna í fjallshlíðinni spurðu þeir hann um nokkuð sem trúarleiðtogar þjóðarinnar töluðu oft um, það að fyrst yrði Elía að koma (áður en Kristur gæti komið). ");
INSERT INTO isl_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Jesús játti því að Elía yrði að koma á undan og ryðja brautina – síðan bætti hann við: „Hann er reyndar búinn að koma! En það var farið hræðilega með hann, rétt eins og spámennirnir höfðu sagt fyrir.“ Síðan spurði hann þá hvað spámennirnir hefðu átt við er þeir spáðu að Kristur ætti að þjást og þola hina dýpstu niðurlægingu. ");
INSERT INTO isl_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Við rætur fjallsins sáu þeir mikinn mannfjölda, sem safnast hafði umhverfis lærisveinana níu, sem orðið höfðu eftir. Þar voru nokkrir fræðimenn að þrátta við þá. ");
INSERT INTO isl_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Þegar Jesús nálgaðist, leit fólkið til hans með lotningu og hljóp til móts við hann til þess að heilsa honum. ");
INSERT INTO isl_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","„Um hvað eruð þið að deila?“ spurði Jesús. ");
INSERT INTO isl_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","„Meistari,“ sagði maður einn í hópnum, „ég kom hingað með son minn til að biðja þig að lækna hann – hann er mállaus, því illur andi er í honum. ");
INSERT INTO isl_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Þegar andinn hefur hann á valdi sínu, kastar hann honum niður svo að hann froðufellir, gnístir tönnum og stífnar upp. Ég bað lærisveina þína að reka þennan illa anda út en þeir gátu það ekki.“ ");
INSERT INTO isl_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Þá sagði Jesús (við lærisveinana): „Æ, lítil er trú ykkar, hversu lengi þarf ég að vera með ykkur til þess að þið trúið? Hversu lengi á ég að umbera ykkur? Komið hingað með drenginn.“ ");
INSERT INTO isl_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Þeir sóttu því drenginn, en þegar illi andinn sá Jesú, þá teygði hann drenginn sundur og saman svo að hann féll til jarðar, veltist um og froðufelldi. ");
INSERT INTO isl_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","„Hve lengi hefur þetta verið svona?“ spurði Jesús föður hans. „Síðan hann var lítill. ");
INSERT INTO isl_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Oft lætur andinn hann falla í eldstóna eða í vatn til að reyna að gera út af við hann. Ó, miskunnaðu okkur og gerðu eitthvað til að hjálpa okkur, ef þú getur.“ ");
INSERT INTO isl_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","„Ef ég get?“ spurði Jesús, og síðan bætti hann við: „Ef þú trúir er allt mögulegt.“ ");
INSERT INTO isl_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","„Ég trúi,“ svaraði maðurinn, „en hjálpaðu mér svo ég eignist enn meiri trú.“ ");
INSERT INTO isl_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Mannfjöldinn þyrptist nú að, en Jesús hastaði á illa andann og sagði: „Þú andi heyrnarleysis og málleysis, ég skipa þér að fara út af þessu barni og koma aldrei aftur.“ ");
INSERT INTO isl_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Þá rak illi andinn upp hræðilegt org, teygði drenginn sundur og saman og fór út úr honum. Drengurinn lá hreyfingarlaus og virtist dáinn. Kliður fór um mannfjöldann – „Hann er dáinn, hann er dáinn.“ ");
INSERT INTO isl_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","En Jesús tók um hönd hans og hjálpaði honum á fætur. Og þarna stóð hann – alheill! ");
INSERT INTO isl_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Eftir á, þegar Jesús var orðinn einn með lærisveinunum innan dyra, spurðu þeir hann: „Hvers vegna gátum við ekki rekið þennan illa anda út?“ ");
INSERT INTO isl_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesús svaraði og sagði: „Við þessu dugar ekkert nema bæn.“ ");
INSERT INTO isl_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Síðan fór hann burt þaðan og ferðaðist um Galíleu. Hann reyndi að forðast að vekja á sér athygli, svo að hann gæti eytt meiri tíma með lærisveinunum og kennt þeim. Hann sagði við þá: „Ég, Kristur, mun verða svikinn og deyddur en á þriðja degi mun ég rísa upp á ný.“ ");
INSERT INTO isl_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Þetta skildu þeir ekki og þorðu ekki að spyrja hann við hvað hann ætti. ");
INSERT INTO isl_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Þeir komu til Kapernaum og er þeir voru komnir þar inn í hús, spurði hann þá: „Um hvað voruð þið að ræða á leiðinni?“ ");
INSERT INTO isl_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Þeir þorðu ekki að svara, því þeir höfðu verið að þrátta um hver þeirra væri mestur. ");
INSERT INTO isl_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Hann settist, kallaði þá til sín og sagði: „Sá sem vill verða mestur, hann verður að vera minnstur; þjónn allra.“ ");
INSERT INTO isl_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Síðan kallaði hann á lítið barn og setti það á meðal þeirra. Að því búnu tók hann það í fang sér og sagði: ");
INSERT INTO isl_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","„Hver sá sem tekur á móti litlu barni eins og þessu, mín vegna, tekur á móti mér, og hver sá sem tekur á móti mér, tekur á móti föður mínum sem sendi mig.“ ");
INSERT INTO isl_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Dag einn sagði Jóhannes, einn af lærisveinum hans, við hann: „Meistari, við sáum mann sem notaði nafn þitt til að reka út illa anda. Við bönnuðum honum það, af því að hann er ekki einn úr okkar hópi.“ ");
INSERT INTO isl_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","„Það skuluð þið ekki gera,“ sagði Jesús, „því að enginn sem unnið hefur kraftaverk í mínu nafni, snýst gegn mér á eftir. ");
INSERT INTO isl_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Sá sem ekki er á móti okkur, hann er með okkur. ");
INSERT INTO isl_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ef einhver gefur ykkur eitthvað, þó ekki sé nema eitt vatnsglas, vegna þess að þið tilheyrið mér – þá skuluð þið vita að hann mun fá sín laun. ");
INSERT INTO isl_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","En! – ef einhver verður til þess að einn af þessum smælingjum sem trúa á mig, glatar trúnni, væri betra fyrir þann mann að vera fleygt í sjóinn, með stóran myllustein bundinn um hálsinn. ");
INSERT INTO isl_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ef hönd þín gerir rangt, þá er betra að skera hana af og hafa aðeins aðra höndina og eignast eilíft líf, en hafa báðar og vera varpað í helvíti. ");
INSERT INTO isl_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ef fótur þinn leiðir þig á veg illskunnar, höggðu hann þá af! Betra er að vera einfættur og eignast eilíft líf, en ganga á báðum fótum til helvítis. ");
INSERT INTO isl_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ef auga þitt teymir þig út í syndina, stingdu það þá úr! Betra er að ganga hálfblindur inn í guðsríki, en hafa bæði augun og líta elda helvítis. ");
INSERT INTO isl_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Þar mun ormurinn aldrei deyja og eldur ekki slokkna. ");
INSERT INTO isl_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Þar eru allir eldi saltaðir! ");
INSERT INTO isl_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Salt er gott, en ef það missir seltuna, þá er það gagnslaust. Gætið því að missa ekki seltuna og haldið frið ykkar á milli.“ ");
INSERT INTO isl_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Eftir þetta fór Jesús frá Kapernaum og kom til Júdeu og byggðanna austan Jórdanar. Fólkið streymdi til hans eins og áður og hann kenndi því. ");
INSERT INTO isl_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nokkrir farísear komu þá til hans og spurðu: „Leyfir þú hjónaskilnað?“ Þeir ætluðu að snúa á hann með þessari spurningu. ");
INSERT INTO isl_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesús svaraði með annarri spurningu: „Hvað sagði Móse um slíkt?“ ");
INSERT INTO isl_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Þeir svöruðu: „Hann sagði að það væri ekkert við það að athuga. Það eina, sem maðurinn þyrfti að gera, væri að afhenda konu sinni skilnaðarbréf. Það væri allt og sumt.“ ");
INSERT INTO isl_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","„Ég skal segja ykkur hvers vegna hann sagði þetta,“ sagði Jesús. „Það var tilslökun vegna illsku ykkar, ");
INSERT INTO isl_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","7","því þannig hafði Guð ekki hugsað sér það. Í upphafi skapaði hann karl og konu og hann ætlaði þeim að lifa saman alla ævi í hjónabandinu. Karlmaðurinn á því að yfirgefa föður og móður, ");
INSERT INTO isl_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","og búa með eiginkonu sinni, svo að þau verði ekki lengur tvö heldur eitt. ");
INSERT INTO isl_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Það sem Guð hefur sameinað, má enginn maður sundur skilja.“ ");
INSERT INTO isl_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Þegar hann síðar var orðinn einn með lærisveinum sínum í húsinu, tóku þeir upp þráðinn á ný. ");
INSERT INTO isl_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Þá sagði Jesús: „Sá sem skilur við konu sína og kvænist annarri, drýgir hór gegn henni. ");
INSERT INTO isl_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Og skilji kona við mann sinn og giftist öðrum, drýgir hún hór.“ ");
INSERT INTO isl_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Sumir komu með börnin sín til Jesús og báðu hann að blessa þau. Lærisveinarnir stugguðu þeim þá frá og sögðu að ekki mætti ónáða hann. ");
INSERT INTO isl_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Þegar Jesús sá þetta, sárnaði honum, og hann sagði við lærisveinana: „Leyfið börnunum að koma til mín og bannið þeim það ekki, því slíkra er guðsríki. ");
INSERT INTO isl_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ég legg á það áherslu að sá, sem ekki vill koma til Guðs eins og lítið barn, mun aldrei komast inn í ríki hans.“ ");
INSERT INTO isl_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Síðan tók hann börnin í fang sér, lagði hendur yfir þau og blessaði. ");
INSERT INTO isl_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesús var í þann veginn að leggja upp í ferð, þegar maður nokkur kom hlaupandi til hans, kraup og spurði. „Góði meistari, hvað verð ég að gera til að eignast eilíft líf?“ ");
INSERT INTO isl_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","„Hvers vegna kallar þú mig góðan?“ spurði Jesús. „Enginn er góður nema einn og það er Guð. ");
INSERT INTO isl_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Þú þekkir boðorðin: Þú skalt ekki morð fremja, ekki drýgja hór, ekki stela, ekki ljúga, ekki svíkja og heiðra skaltu föður þinn og móður.“ ");
INSERT INTO isl_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","„Meistari,“ svaraði maðurinn, „ég hef hlýtt þessum boðorðum allt frá barnæsku.“ ");
INSERT INTO isl_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesú fór að þykja vænt um þennan mann; hann leit á hann og sagði: „Eitt vantar þig samt: Seldu allt sem þú átt og gefðu fátækum peningana – þá munt þú eiga auðæfi á himnum. Komdu síðan og fylgdu mér.“ ");
INSERT INTO isl_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Þá varð maðurinn niðurlútur og fór burt, dapur í bragði, því hann var mjög ríkur. ");
INSERT INTO isl_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesús horfði á eftir honum þegar hann gekk burt, síðan sneri hann sér að lærisveinunum og sagði: „Það er erfitt fyrir ríka menn að komast inn í guðsríki.“ ");
INSERT INTO isl_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Lærisveinarnir urðu undrandi! Jesús sagði því aftur: „Börnin góð, það er erfitt fyrir þá, sem treysta auðæfunum, að komast inn í guðsríki. ");
INSERT INTO isl_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Auðveldara er fyrir úlfalda að fara gegnum nálarauga, en ríkan mann að komast inn í guðsríki.“ ");
INSERT INTO isl_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nú urðu lærisveinarnir öldungis forviða! „Hver getur þá orðið hólpinn?“ spurðu þeir. ");
INSERT INTO isl_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús horfði fast á þá og sagði: „Án Guðs er það ómögulegt, en Guði er enginn hlutur um megn.“ ");
INSERT INTO isl_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Þá tók Pétur að telja upp allt sem hann og lærisveinarnir hefðu yfirgefið og sagði síðan: „Við höfum yfirgefið allt og fylgt þér…“ ");
INSERT INTO isl_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús svaraði: „Ég fullvissa ykkur um að hver sá sem yfirgefur allt – heimili, bræður, systur, móður, föður, börn eða eignir – af kærleika til mín og til að geta flutt öðrum gleðiboðskapinn, mun fá sín laun. ");
INSERT INTO isl_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Honum verður launað hundraðfalt! Heimili, bræður, systur, mæður, börn og land – og ofsóknir. Allt þetta mun hann fá á jörðu og auk þess eilíft líf í hinum komandi heimi. ");
INSERT INTO isl_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Þá mun lítið verða úr mörgum sem nú telja sig mikla, en margir sem nú eru fyrirlitnir, munu þar hljóta virðingu.“ ");
INSERT INTO isl_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nú lá leiðin til Jerúsalem. Jesús gekk hratt á undan lærisveinunum, sem fylgdu honum undrandi og kvíðnir. Jesús fór með þá afsíðis og tók enn að lýsa fyrir þeim því sem biði hans í Jerúsalem. ");
INSERT INTO isl_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","„Þegar þangað kemur mun ég, Kristur, verða handtekinn og leiddur fyrir æðstu prestana og leiðtoga þjóðarinnar. Þeir munu dæma mig til dauða og selja mig í hendur Rómverjanna, svo þeir geti tekið mig af lífi. ");
INSERT INTO isl_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Fyrst munu þeir hæðast að mér og hrækja á mig, síðan húðstrýkja, og því næst lífláta mig. Þrem dögum síðar mun ég rísa upp frá dauðum.“ ");
INSERT INTO isl_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nú komu Jakob og Jóhannes, synir Sebedeusar, til hans og sögðu við hann í hálfum hljóðum: „Meistari, okkur langar að biðja þig um nokkuð.“ ");
INSERT INTO isl_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","„Hvað er það?“ spurði hann. ");
INSERT INTO isl_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","„Okkur langar að sitja næst þér í konungsríki þínu, annar hægra megin, hinn vinstra megin,“ svöruðu þeir. ");
INSERT INTO isl_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","„Þið vitið ekki um hvað þið eruð að biðja!“ sagði Jesús. „Getið þið drukkið þann sorgarbikar sem ég verð að drekka? Eða skírst þeirri þjáningaskírn sem ég verð að skírast?“ ");
INSERT INTO isl_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","„Já, já, það getum við,“ svöruðu þeir. Þá sagði Jesús: „Já, þið munuð vissulega fá að drekka þennan bikar minn og skírast þessari skírn, ");
INSERT INTO isl_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","en ég hef ekki leyfi til að láta ykkur eftir hásætin sem næst mér eru og það hefur reyndar þegar verið ákveðið hverjir þau skuli hljóta.“ ");
INSERT INTO isl_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Þegar hinir lærisveinarnir komust að því hvers Jakob og Jóhannes höfðu spurt, urðu þeir mjög gramir. ");
INSERT INTO isl_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesús kallaði þá til sín og sagði: „Þið vitið að þeir sem teljast ráða yfir þjóðunum, drottna yfir þeim og láta þær kenna á valdi sínu, ");
INSERT INTO isl_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","en þannig er það ekki meðal ykkar. Sá ykkar sem vill verða mikill, verður að vera þjónn hinna, ");
INSERT INTO isl_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","og sá sem vill verða mestur allra, verður að vera allra þræll. ");
INSERT INTO isl_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ég, Kristur, kom ekki hingað til að láta þjóna mér, heldur til að þjóna öðrum, og gefa líf mitt sem lausnargjald fyrir marga.“ ");
INSERT INTO isl_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Þeir komu til Jeríkó. Síðar, þegar þeir voru að fara þaðan aftur, fylgdi honum mikill mannfjöldi. Við veginn sat blindur betlari, Bartímeus, sonur Tímeusar. ");
INSERT INTO isl_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Þegar Bartímeus heyrði að Jesús frá Nasaret færi þar, tók hann að hrópa og kalla: „Jesús, sonur Davíðs, miskunnaðu mér!“ ");
INSERT INTO isl_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Margir skipuðu honum að þegja, en það varð til þess að hann hrópaði enn ákafar: „Sonur Davíðs, miskunnaðu mér!“ ");
INSERT INTO isl_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Þegar Jesús heyrði hrópin, nam hann staðar og sagði: „Segið honum að koma.“ Þeir kölluðu því á blinda manninn og sögðu: „Þú ert heppinn! Hann sagði þér að koma.“ ");
INSERT INTO isl_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bartímeus henti af sér yfirhöfninni, stökk á fætur og flýtti sér til Jesú. ");
INSERT INTO isl_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","„Hvað viltu að ég geri fyrir þig?“ spurði Jesús. „Meistari,“ sagði blindi maðurinn, „mig langar að fá sjónina!“ ");
INSERT INTO isl_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","„Bæn þín er heyrð,“ sagði Jesús. „Trú þín hefur læknað þig.“ Samstundis fékk blindi maðurinn sjónina og fylgdi Jesú áleiðis. ");
INSERT INTO isl_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Þegar þeir komu til Betfage og Betaníu, sem eru smáþorp við Olíufjallið, skammt frá Jerúsalem, sendi Jesús tvo lærisveina sinna á undan sér. ");
INSERT INTO isl_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","„Farið í þorpið þarna á móti,“ sagði hann. „Þegar þið komið þangað, munuð þið finna ösnufola sem enginn hefur komið á bak. Leysið hann og færið mér. ");
INSERT INTO isl_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ef einhver spyr hvers vegna þið gerið þetta, skuluð þið segja: „Meistari okkar þarf á honum að halda, en hann skilar honum fljótt aftur“.“ ");
INSERT INTO isl_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","5","Mennirnir tveir fóru og fundu folann bundinn hjá húsi nokkru við eina götuna. Meðan þeir voru að leysa hann, spurðu menn sem þar voru: „Hvers vegna leysið þið folann?“ ");
INSERT INTO isl_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Þeir svöruðu eins og Jesús hafði sagt þeim að gera og þá leyfðu mennirnir þeim að taka hann. ");
INSERT INTO isl_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Síðan fóru þeir með folann til Jesú. Lærisveinarnir lögðu yfirhafnir sínar á hann og Jesús settist á bak. ");
INSERT INTO isl_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Margir í mannþyrpingunni lögðu yfirhafnir sínar á veginn þar sem Jesús fór, en aðrir lögðu laufgaðar greinar og strá sem þeir höfðu skorið af ökrunum. ");
INSERT INTO isl_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Athygli allra beindist að Jesú og fólkið gekk í hópum á undan og eftir og hrópaði: „Blessaður sé konungurinn, sem kemur í nafni Drottins!“ ");
INSERT INTO isl_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","„Lofaður sé Guð, því hann endurreisir konungdóm Davíðs…“ „Lengi lifi Drottinn himnanna!“ ");
INSERT INTO isl_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Þegar Jesús var kominn til Jerúsalem, fór hann inn í musterið, gekk um og virti allt gaumgæfilega fyrir sér. Um kvöldið fór hann út til Betaníu ásamt lærisveinunum tólf og gisti þar. ");
INSERT INTO isl_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Þegar þeir fóru frá Betaníu daginn eftir, fann Jesús til hungurs. ");
INSERT INTO isl_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Þá kom hann auga á laufgað fíkjutré skammt frá. Hann gekk að trénu til að athuga hvort á því væru nokkrar fíkjur. Þar var aðeins lauf að finna, engar fíkjur, því þetta var snemma árs og fíkjurnar enn ekki sprottnar. ");
INSERT INTO isl_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Þá sagði Jesús við tréð, svo lærisveinarnir heyrðu: „Aldrei framar munt þú ávöxt bera!“ ");
INSERT INTO isl_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Þegar til Jerúsalem kom, fór hann upp í musterið og rak út kaupmennina og viðskiptavini þeirra. Hann hratt um koll stólum dúfnasalanna og borðum þeirra sem skiptu mynt, ");
INSERT INTO isl_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","og stöðvaði þá sem voru að bera inn alls konar söluvarning. ");
INSERT INTO isl_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Hann sagði við þá: „Guðs orð segir: „Musteri mitt á að vera bænastaður fyrir allar þjóðir, en þið hafið breytt því í ræningjabæli“.“ ");
INSERT INTO isl_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Þegar æðstu prestarnir og aðrir leiðtogar þjóðarinnar fréttu þetta, ræddu þeir hvernig þeir gætu ráðið Jesú af dögum, en þeir óttuðust uppþot meðal fólksins, sem líkaði vel það sem Jesús sagði. ");
INSERT INTO isl_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Þetta kvöld fóru Jesús og lærisveinarnir út úr borginni eins og þeir voru vanir. ");
INSERT INTO isl_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Morguninn eftir, þegar þeir gengu framhjá fíkjutrénu, sáu þeir að það hafði visnað frá rótum. ");
INSERT INTO isl_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Þá minntist Pétur þess sem Jesús hafði sagt við tréð daginn áður og hrópaði: „Sjáðu, meistari! Fíkjutréð, sem þú formæltir, er visnað!“ ");
INSERT INTO isl_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","„Ég segi ykkur satt,“ sagði Jesús. „Ef þið trúið á Guð, þá getið þið sagt við Olíufjallið: „Upp með þig og steypstu í hafið“ og það mundi hlýða. Skilyrðið er trú sem ekki efast um mátt Guðs. ");
INSERT INTO isl_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Og takið nú eftir! Þið getið beðið um hvað sem er og ef þið trúið, þá fáið þið það! ");
INSERT INTO isl_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","En áður en þið biðjið, fyrirgefið þá þeim sem þið hafið gert eitthvað á móti, svo að faðirinn á himnum geti fyrirgefið ykkur syndir ykkar.“ ");
INSERT INTO isl_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","28","Þeir komu nú aftur til Jerúsalem. Jesús var á gangi í musterinu þegar æðstu prestarnir og aðrir leiðtogar þjóðarinnar komu til hans og sögðu ákveðnir: „Hvað gengur eiginlega á hér? Hver gaf þér vald til að reka kaupmennina burt héðan?“ ");
INSERT INTO isl_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús svaraði: „Það skal ég segja ykkur, ef þið svarið fyrst einni spurningu: ");
INSERT INTO isl_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Var Jóhannes skírari sendiboði Guðs eða ekki? Svarið mér!“ ");
INSERT INTO isl_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Þeir báru saman ráð sín og sögðu: „Ef við svörum já, þá mun hann segja: „Jæja, hvers vegna trúðuð þið þá ekki orðum hans?“ ");
INSERT INTO isl_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","en ef við segjum nei, þá mun fólkið tryllast.“ (Fólkið trúði því statt og stöðugt að Jóhannes hefði verið spámaður.) ");
INSERT INTO isl_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Þeir svöruðu því: „Við vitum það ekki.“ „Þá svara ég ekki heldur spurningu ykkar,“ sagði Jesús. ");
INSERT INTO isl_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Hér eru nokkrar af dæmisögunum sem Jesús sagði fólkinu þessa daga: „Maður nokkur gerði sér víngarð. Hann hlóð vegg umhverfis garðinn, bjó til þró til að pressa í vínberin og reisti eftirlitsturn. Að því búnu leigði hann vínyrkjubændum garðinn og fluttist sjálfur í annað land. ");
INSERT INTO isl_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Þegar uppskerutíminn kom, sendi hann einn af mönnum sínum til að ná í sinn hluta uppskerunnar. ");
INSERT INTO isl_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","En bændurnir börðu manninn og sendu hann heim tómhentan. ");
INSERT INTO isl_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Eigandinn sendi þá annan mann, en sá fékk jafnvel enn verri útreið, því að þeir börðu hann í höfuðið og særðu hann. ");
INSERT INTO isl_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Sá þriðji sem hann sendi, var drepinn, og seinna voru fleiri ýmist barðir eða drepnir. ");
INSERT INTO isl_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nú átti víngarðseigandinn aðeins einkason sinn eftir. Hann ákvað að senda hann, því hann taldi að þeir myndu áreiðanlega sýna honum virðingu. ");
INSERT INTO isl_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","En þegar bændurnir sáu hann koma, sögðu þeir hver við annan: „Þessi er sonur víngarðseigandans og hann mun erfa víngarðinn þegar faðir hans deyr. Komið, við skulum drepa hann – og þá eigum við garðinn.“ ");
INSERT INTO isl_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Og þeir gripu hann og myrtu og fleygðu líkinu út fyrir vegginn. ");
INSERT INTO isl_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Hvað haldið þið að eigandinn geri þegar hann fær fréttirnar? Hann kemur og drepur þá alla og leigir öðrum víngarðinn. ");
INSERT INTO isl_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Munið þið eftir þessu versi í Biblíunni: „Steinninn, sem smiðirnir höfnuðu, var gerður að hornsteini og hlaut þar með mesta heiður allra steina í byggingunni.“ ");
INSERT INTO isl_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Þetta gerði Drottinn og það er stórkostlegt að vita.“ ");
INSERT INTO isl_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Leiðtogar þjóðarinnar vildu nú ólmir handtaka Jesú, því þeir skildu að dæmisagan var um þá – þeir voru bændaófétin í sögunni. Þeir þorðu samt ekki að taka hann, af ótta við uppþot. Þeir fóru því burt, ");
INSERT INTO isl_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","en sendu aðra í staðinn – menn úr hópi faríseanna og flokki Heródesarsinna. Þessir reyndu nú að fá hann til að segja eitthvað sem hægt væri að handtaka hann fyrir. ");
INSERT INTO isl_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","„Meistari, við vitum að þú segir sannleikann, hver sem í hlut á!“ sögðu þeir. „Þú lætur þig engu varða skoðanir eða viðhorf annarra, þú kennir veg Guðs í sannleika. Segðu okkur eitt: Er rétt af okkur að greiða Rómverjum skatta?“ ");
INSERT INTO isl_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesús sá slægð þeirra og sagði: „Sýnið mér peninginn sem þið borgið skattinn með og þá skal ég segja ykkur það.“ ");
INSERT INTO isl_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Þeir réttu honum myntina og hann spurði: „Hvaða mynd og nafn er á henni?“ „Keisarans,“ svöruðu þeir. ");
INSERT INTO isl_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","„Nú, já“ svaraði hann, „gjaldið þá keisaranum það sem keisarinn á og Guði það sem Guð á.“ Þeir urðu undrandi. Á slíku svari áttu þeir síst von. ");
INSERT INTO isl_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Þá gengu saddúkearnir fram. Þeir álíta að upprisa dauðra sé ekki til. Spurning þeirra var á þessa leið: ");
INSERT INTO isl_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","„Meistari! Móse setti lög sem segja að deyi maður barnlaus, skuli bróðir hans kvænast ekkjunni og eignast börn sem beri nafn látna bróðurins. ");
INSERT INTO isl_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","22","Einu sinni voru sjö bræður. Sá elsti kvæntist og dó barnlaus. Annar bróðirinn kvæntist ekkjunni, en dó líka barnlaus stuttu síðar. Þriðji bróðirinn gekk einnig að eiga ekkjuna, en hann dó einnig barnlaus, og þannig gekk það koll af kolli þar til allir bræðurnir voru dánir, en enginn hafði látið eftir sig barn. Að lokum dó konan líka. ");
INSERT INTO isl_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nú langar okkur að vita hver þeirra muni fá hana fyrir eiginkonu í upprisunni, fyrst hún var gift þeim öllum!“ ");
INSERT INTO isl_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesús svaraði: „Vandi ykkar er sá að þið þekkið ekki Biblíuna og skiljið því ekki mátt Guðs. ");
INSERT INTO isl_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Konan og bræðurnir sjö munu ekki ganga í hjónaband, þegar þau rísa upp frá dauðum, heldur munu þau verða eins og englarnir. ");
INSERT INTO isl_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","En varðandi það hvort um upprisu verði að ræða, vil ég spyrja: Hafið þið aldrei lesið um logandi þyrnirunnann í annarri Mósebók? Guð sagði við Móse: „Ég er Guð Abrahams, ég er Guð Ísaks, og ég er Guð Jakobs.“ ");
INSERT INTO isl_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Guð var að undirstrika fyrir Móse að þessir menn væru lifandi, enda þótt þeir hefðu dáið mörgum öldum áður, því væru þeir ekki á lífi, hefði hann ekki sagt: „Ég er Guð þeirra.“ Þið hafið misskilið þetta hrapallega.“ ");
INSERT INTO isl_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Lögfræðingi nokkrum, sem þar stóð og hlustað hafði á samræðurnar, fannst Jesús hafa svarað vel. Hann spurði því Jesú: „Hvaða boðorð er mikilvægast?“ ");
INSERT INTO isl_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","„Þetta,“ svaraði Jesús: „ „Heyr Ísrael! Drottinn, Guð þinn, er hinn eini og sanni Guð, ");
INSERT INTO isl_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","þú skalt elska hann af öllu hjarta þínu og allri sálu þinni, huga þínum og mætti.“ ");
INSERT INTO isl_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Því næst er þetta: „Þú skalt elska meðbræður þína eins og sjálfan þig.“ Þetta eru æðstu boðorðin.“ ");
INSERT INTO isl_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","„Þetta var gott svar, herra,“ sagði fræðimaðurinn. „Og satt er það að aðeins er til einn Guð og enginn annar. ");
INSERT INTO isl_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ég veit, að það að elska hann af öllu hjarta, huga og mætti og elska aðra eins og sjálfan sig, er langtum mikilvægara en færa allar þessar fórnir á altari musterisins.“ ");
INSERT INTO isl_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Þegar Jesús sá hve skilningsríkur maðurinn var, sagði hann: „Þú ert ekki fjarri guðsríkinu.“ Eftir þetta þorði enginn að spyrja hann neins. ");
INSERT INTO isl_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Seinna, þegar Jesús var að kenna fólkinu á musterissvæðinu, sagði hann: „Segið mér eitt. Hvers vegna segja fræðimenn ykkar að Kristur verði að vera afkomandi Davíðs konungs? ");
INSERT INTO isl_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Davíð sagði fyrir áhrif heilags anda: „Guð sagði við minn Drottin, sittu mér til hægri handar, uns ég legg alla óvini þína að fótum þér.“ ");
INSERT INTO isl_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Fyrst Davíð kallar hann „sinn Drottin“ hvernig getur hann þá verið sonur hans?“ Mannfjöldanum líkaði vel að heyra slíkar röksemdir og hlustaði á Jesú af miklum áhuga. ");
INSERT INTO isl_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús hélt áfram að fræða fólkið og sagði: „Gætið ykkar á fræðimönnunum! Þeir hafa unun af að klæðast skikkjum að hætti ríkra menntamanna, og þegar þeir ganga um bæinn, vilja þeir að allir hneigi sig fyrir þeim. ");
INSERT INTO isl_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Þeir sækjast eftir að sitja í heiðurssætum samkomuhúsanna og við háborðið í veislunum. ");
INSERT INTO isl_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Þeir flæma ekkjur út af heimilum þeirra og þykjast guðræknir með því að biðja langar bænir á almannafæri. Þess vegna munu þeir fá enn þyngri dóm.“ ");
INSERT INTO isl_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Að því búnu fékk Jesús sér sæti hjá söfnunarbaukunum í musterinu og virti fyrir sér fólkið sem var að leggja í þá gjafir sínar. Sumir auðmenn gáfu mikið. ");
INSERT INTO isl_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Þá kom fátæk ekkja og gaf tvo smápeninga í samskotin. ");
INSERT INTO isl_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Jesús kallaði þá á lærisveina sína og sagði: „Þessi fátæka ekkja gaf meira en allir auðmennirnir samanlagt! Þeir gáfu aðeins lítið brot af eigum sínum, en hún gaf aleiguna.“ ");
INSERT INTO isl_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Þegar Jesús gekk út úr musterinu þennan dag, sagði einn lærisveinanna við hann: „Meistari, þetta eru fallegar byggingar! Sjáðu til dæmis myndirnar þarna á veggjunum.“ ");
INSERT INTO isl_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","„Já,“ svaraði Jesús, „en hér verður samt ekki skilinn eftir steinn yfir steini, ekkert nema rústir einar.“ ");
INSERT INTO isl_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","4","Og þegar hann sat í hlíð Olíufjallsins, hinum megin dalsins gegnt musterinu, komu Pétur, Jakob, Jóhannes og Andrés til hans og spurðu: „Hvenær mun þetta verða? Mun eitthvert tákn birtast áður, til viðvörunar?“ ");
INSERT INTO isl_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús svaraði: „Látið engan leiða ykkur afvega, ");
INSERT INTO isl_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","því margir munu koma og segjast vera Kristur, og þeir munu leiða ógæfu yfir marga. ");
INSERT INTO isl_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Óttist ekki þótt styrjaldir geisi, það er óhjákvæmilegt, en endirinn er ekki þar með kominn. ");
INSERT INTO isl_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Þjóðir og ríki munu ráðast hvert gegn öðru, og víða munu verða jarðskjálftar og hungursneyð. Þetta verða fyrirboðar hörmunganna sem framundan eru. ");
INSERT INTO isl_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Gætið ykkar, því að þið verðið í mikilli hættu! Þið verðið dregnir fyrir rétt, þið verðið barðir í samkomuhúsunum og ákærðir frammi fyrir landstjórum og konungum, vegna þess að þið fylgið mér, en þá fáið þið líka tækifæri til að vitna um mig. ");
INSERT INTO isl_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Áður en endalokin koma, verða allar þjóðir að hafa fengið að heyra fagnaðarerindið. ");
INSERT INTO isl_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","En þegar þið verið yfirheyrðir sem fangar, hafið þá ekki áhyggjur af því hvernig þið eigið að verja ykkur – segið það sem Guð minnir ykkur á. Það verða ekki þið sem talið, heldur heilagur andi! ");
INSERT INTO isl_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Bræður munu svíkja hver annan í dauðann, og sama munu feður gera við sín eigin börn og börnin við foreldrana. ");
INSERT INTO isl_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Allir munu hata ykkur af því að þið tilheyrið mér, en þeir sem standa stöðugir allt til enda og afneita mér ekki, munu bjargast. ");
INSERT INTO isl_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Þegar þið sjáið viðurstyggð eyðingarinnar í musterinu – lesandi, taktu eftir því – þá flýi þeir sem eru í Júdeu til fjalla, ");
INSERT INTO isl_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","16","og flýtið ykkur! Sértu staddur við þakdyrnar, farðu þá ekki inn í húsið, og sértu úti á akri, farðu þá ekki heim eftir peningum þínum eða fötum. ");
INSERT INTO isl_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Þær, sem eiga von á barni, verða illa settar á þeim dögum og einnig þær, sem þá hafa börn á brjósti. ");
INSERT INTO isl_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Biðjið að flótti ykkar verði ekki að vetri til. ");
INSERT INTO isl_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Þessir tímar verða svo miklir hörmungatímar, að þvílíkt hefur aldrei fyrr orðið frá upphafi sköpunarinnar og mun aldrei verða. ");
INSERT INTO isl_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ef Drottinn stytti ekki þennan ógæfutíma, kæmist engin sála af í öllum heiminum, en vegna þeirra, sem hann hefur útvalið, mun hann stytta hann. ");
INSERT INTO isl_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ef einhver segir við ykkur: „Þetta er Kristur,“ eða „þarna er hann,“ þá gefið því engan gaum. ");
INSERT INTO isl_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Margir falskristar og falsspámenn munu koma og gera stórkostleg kraftaverk til þess, ef mögulegt er, að villa um fyrir börnum Guðs. ");
INSERT INTO isl_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Varið ykkur! Nú hef ég sagt ykkur það! ");
INSERT INTO isl_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Eftir þessar þrengingar mun sólin myrkvast og tunglið hætta að skína, ");
INSERT INTO isl_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","stjörnurnar munu hrapa og himnarnir nötra. ");
INSERT INTO isl_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Þá mun allt mannkynið sjá mig, Krist, koma í skýjunum með mætti og mikilli dýrð. ");
INSERT INTO isl_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Og ég mun senda englana út um allan heim til að safna saman mínum útvöldu – út til ystu endimarka heimsins. ");
INSERT INTO isl_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Þið getið lært af fíkjutrénu: Þið vitið að vorið er komið, þegar brumið er orðið mjúkt og laufin fara að springa út. ");
INSERT INTO isl_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Þegar þið sjáið þessa atburði gerast, sem ég nú hef lýst, þá getið þið reitt ykkur á að endurkoma mín er fyrir dyrum. ");
INSERT INTO isl_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Þetta eru táknin, sem gefa þessari kynslóð til kynna að endirinn sé kominn. ");
INSERT INTO isl_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Himinn og jörð munu hverfa en orð mín standa að eilífu. ");
INSERT INTO isl_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","En daginn og stundina er þetta gerist, veit enginn, hvorki englarnir né ég, heldur aðeins faðirinn einn. ");
INSERT INTO isl_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Og fyrst þið vitið ekki stundina, verið þá allsgáðir. Vakið og biðjið og verið viðbúnir komu minni. ");
INSERT INTO isl_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Endurkomu minni má líkja við mann, sem ferðaðist til annars lands. Hann sagði starfsmönnum sínum hvað hver og einn ætti að gera meðan hann væri í burtu og bað dyravörðinn að vera vel á verði meðan hann biði komu sinnar. ");
INSERT INTO isl_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","37","Gætið að! Þið vitið ekki hvenær mín er von, hvort það verður að kvöldi, um miðnætti, undir morgun eða árdegis. Látið mig ekki koma að ykkur sofandi, heldur verið vakandi þegar ég kem! Það sem ég segi ykkur, segi ég öllum: Vakið!“ ");
INSERT INTO isl_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tveim dögum síðar hófst páskahátíðin – en þá neyta Gyðingar ekki brauðs með súru geri. Æðstu prestarnir og aðrir leiðtogar þjóðarinnar voru enn að leita að tækifæri til að handtaka Jesú svo lítið bæri á og lífláta hann. ");
INSERT INTO isl_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","„En það er útilokað á páskahátíðinni,“ sögðu þeir, „því þá færi allt í bál og brand.“ ");
INSERT INTO isl_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús var um þessar mundir staddur í Betaníu, heima hjá Símoni holdsveika. Meðan þeir voru að borða kvöldverð, kom kona inn með fallega flösku með dýrri ilmolíu. Hún braut innsiglið af flöskunni og hellti innihaldinu yfir höfuð Jesú. ");
INSERT INTO isl_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","5","Sumir, sem þarna voru, hneyksluðust á þessari „sóun“ eins og þeir kölluðu það. „Hvað á þetta að þýða,“ tautuðu þeir. „Hún hefði getað selt ilmolíuna fyrir stórfé og gefið það fátækum.“ ");
INSERT INTO isl_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","„Látið hana í friði,“ sagði Jesús. „Af hverju gagnrýnið þið hana fyrir gott verk? ");
INSERT INTO isl_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Fátæka hafið þið ávallt hjá ykkur og þeim getið þið liðsinnt hvenær sem þið viljið, en mig hafið þið ekki ávallt. ");
INSERT INTO isl_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Hún gerði það sem hún gat og hún hefur smurt líkama minn fyrir fram til greftrunar. ");
INSERT INTO isl_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ég segi ykkur satt: Hvar sem fagnaðarerindið verður boðað í þessum heimi, mun þess getið sem hún gerði og það lofað.“ ");
INSERT INTO isl_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Þegar hér var komið, fór Júdas Ískaríot til æðstu prestanna, staðráðinn í að svíkja Jesú í hendur þeirra. ");
INSERT INTO isl_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Þegar þeim varð ljóst erindi Júdasar, lifnaði yfir þeim og þeir hétu honum launum. Eftir það leitaði Júdas að hentugu tækifæri til að svíkja Jesú. ");
INSERT INTO isl_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Á fyrsta degi páskahátíðarinnar, þegar lömbunum var slátrað, spurðu lærisveinar Jesú hann hvar hann ætlaði að neyta páskamáltíðarinnar. ");
INSERT INTO isl_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Þá sendi hann tvo þeirra til Jerúsalem til að undirbúa máltíðina. „Þegar þið komið inn í borgina,“ sagði hann, „munuð þið sjá mann koma á móti ykkur með vatnskrús. Fylgið honum eftir. ");
INSERT INTO isl_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Þar sem hann fer inn í hús, skuluð þið segja við húsráðandann: „Meistari okkar sendi okkur til að líta á herbergið, sem þú ætlaðir okkur til að neyta páskamáltíðarinnar í.“ ");
INSERT INTO isl_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Þá mun hann fara með ykkur upp á loft og inn í stórt herbergi, búið þægindum. Þar skuluð þið undirbúa kvöldmáltíð okkar.“ ");
INSERT INTO isl_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Lærisveinarnir tveir fóru því til borgarinnar og fundu allt eins og Jesús hafði sagt og undirbjuggu hátíðarverðinn. ");
INSERT INTO isl_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Um kvöldið kom Jesús ásamt lærisveinunum. ");
INSERT INTO isl_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Þegar þeir voru sestir við borðið sagði Jesús: „Ég segi ykkur satt: Einn ykkar mun svíkja mig, einn ykkar, sem hér sitjið og borðið með mér.“ ");
INSERT INTO isl_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Lærisveinunum brá mjög við þessi orð og mikil spenna lá í loftinu. „Er það ég?“ spurðu þeir einn af öðrum. ");
INSERT INTO isl_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","„Já, það er einn ykkar tólf, sem nú borðið hér með mér,“ svaraði Jesús. ");
INSERT INTO isl_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","„Ég verð að deyja eins og spámennirnir sögðu fyrir, en mikil er ógæfa þess sem mig svíkur. Betra væri að hann hefði aldrei fæðst.“ ");
INSERT INTO isl_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Meðan á máltíðinni stóð tók Jesús brauð, og þakkaði Guði. Hann braut það í bita, rétti þeim og sagði: „Borðið þetta – það er líkami minn.“ ");
INSERT INTO isl_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Síðan tók hann bikar með víni, þakkaði og rétti þeim og þeir drukku allir af honum. ");
INSERT INTO isl_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Síðan sagði hann: „Þetta er blóð mitt, sem úthellt er fyrir marga. Það er innsigli hins nýja sáttmála milli Guðs og manna. ");
INSERT INTO isl_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ég segi ykkur satt að ég mun ekki bragða vín fyrr en ég drekk nýja vínið í guðsríki.“ ");
INSERT INTO isl_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Síðan sungu þeir sálm og að því búnu fóru þeir út til Olíufjallsins. ");
INSERT INTO isl_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","„Þið munuð allir yfirgefa mig,“ sagði Jesús, „því Guðs orð segir: „Ég mun slá hirðinn og hjörðin mun tvístrast.“ ");
INSERT INTO isl_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","En eftir að ég er risinn upp frá dauðum, mun ég fara til Galíleu og hitta ykkur þar.“ ");
INSERT INTO isl_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Þá sagði Pétur: „Ég mun aldrei yfirgefa þig, hvað sem hinir gera.“ ");
INSERT INTO isl_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","„Pétur,“ sagði Jesús, „áður en haninn hefur galað tvisvar í fyrramálið muntu þrisvar afneita mér.“ ");
INSERT INTO isl_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","„Nei!“ hrópaði Pétur. „Ég mun aldrei afneita þér, jafnvel þótt ég ætti að deyja með þér.“ Og allir hinir tóku í sama streng. ");
INSERT INTO isl_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Þeir komu í garð sem heitir Getsemane og þar sagði Jesús við lærisveinana: „Setjist hérna og bíðið meðan ég fer og biðst fyrir.“ ");
INSERT INTO isl_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Síðan gekk hann lengra ásamt Pétri, Jakobi og Jóhannesi. Þá varð hann angistarfullur og tók að skjálfa. ");
INSERT INTO isl_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Hann sagði við þá: „Ég er hryggur og fullur örvæntingar á stund dauðans – bíðið hér og vakið með mér.“ ");
INSERT INTO isl_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Hann gekk spölkorn lengra, féll til jarðar og bað þess að sú hræðilega stund, sem biði hans, rynni aldrei upp, ef unnt væri. ");
INSERT INTO isl_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","„Faðir,“ sagði hann, „allt er þér mögulegt. Taktu þennan þjáningarbikar frá mér, en verði samt þinn vilji en ekki minn.“ ");
INSERT INTO isl_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Síðan gekk hann þangað sem lærisveinarnir þrír voru og fann þá sofandi. „Símon!“ sagði hann. „Ertu sofandi? Gastu ekki einu sinni vakað með mér eina stund? ");
INSERT INTO isl_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Vakið og biðjið til þess að þið fallið ekki í freistni. Þótt andinn sé fús, er holdið veikt.“ ");
INSERT INTO isl_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Síðan fór hann aftur frá þeim og bað sömu bænar. ");
INSERT INTO isl_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Eftir það kom hann til þeirra og fann þá enn sofandi. Þeir voru mjög þreyttir og vissu ekki hvað þeir áttu að segja. ");
INSERT INTO isl_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Í þriðja skipti kom hann til þeirra og sagði: „Sofið þið enn og hvílist? Nú er ekki tími til að sofa! Ég hef verið svikinn í hendur vondra manna. ");
INSERT INTO isl_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Standið upp, við verðum að fara! Sjáið! Svikari minn er að koma!“ ");
INSERT INTO isl_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Áður en hann hafði sleppt orðinu, kom Júdas (einn af lærisveinum hans) með hóp manna vopnaða sverðum og kylfum. Menn þessa höfðu æðstu prestarnir og aðrir leiðtogar þjóðarinnar sent. ");
INSERT INTO isl_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Júdas hafði sagt við þá: „Handtakið þann sem ég heilsa. Það verður auðvelt að ná honum.“ ");
INSERT INTO isl_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Jafnskjótt og þeir komu, gekk Júdas til Jesú og sagði glaðlega: „Meistari!“ og kyssti hann. ");
INSERT INTO isl_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Og þeir lögðu hendur á Jesú og tóku hann. ");
INSERT INTO isl_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Einhver brá sverði á loft og hjó til þjóns æðsta prestsins og sneið af honum eyrað. ");
INSERT INTO isl_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesús sagði við hópinn: „Er ég þá hættulegur ræningi? Þið komið alvopnaðir til að handtaka mig. ");
INSERT INTO isl_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Af hverju tókuð þið mig ekki í musterinu? Þar kenndi ég á hverjum degi! En svona á þetta reyndar að fara, til þess að spádómarnir um mig rætist.“ ");
INSERT INTO isl_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Meðan Jesús var að tala, yfirgáfu allir lærisveinarnir hann og flýðu. ");
INSERT INTO isl_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Og hópurinn lagði af stað með Jesú. En ungur maður, klæddur náttslopp einum saman, kom í humátt á eftir og þegar mennirnir ætluðu að grípa hann, rifnaði sloppurinn og hann flýði nakinn. ");
INSERT INTO isl_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nú var farið með Jesú til hallar æðsta prestsins og þar söfnuðust fljótlega saman allir æðstu prestarnir og aðrir leiðtogar. ");
INSERT INTO isl_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pétur kom langt á eftir og smeygði sér, svo lítið bar á, inn fyrir hliðið við bústað æðsta prestsins og settist við eldinn í garðinum ásamt þjónunum sem þar voru. ");
INSERT INTO isl_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Inni í húsinu reyndi hæstiréttur Gyðinga að finna einhverja sök á hendur Jesú, sem nægja mundi til dauðadóms, en árangurslaust. ");
INSERT INTO isl_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Fjöldi falsvitna gaf sig fram, en framburði þeirra bar ekki saman. ");
INSERT INTO isl_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Loksins stóðu upp nokkrir menn og báru lognar sakir á Jesú. ");
INSERT INTO isl_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Þeir sögðu: „Við heyrðum hann segja: „Ég mun rífa niður þetta musteri sem byggt er af mannahöndum og byggja annað á þrem dögum, án þess að hönd komi þar nærri“.“ ");
INSERT INTO isl_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","En ekki bar þeim heldur saman um þetta. ");
INSERT INTO isl_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Þá reis æðsti presturinn upp og spurði Jesú frammi fyrir réttinum: „Þú svarar engu. Hvað viltu segja þér til varnar?“ ");
INSERT INTO isl_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús svaraði honum ekki einu orði. Þá spurði æðsti presturinn: „Ert þú Kristur, sonur Guðs?“ ");
INSERT INTO isl_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús svaraði: „Já, það er ég og þú munt sjá mig sitja við hægri hönd Guðs og birtast öllum mönnum í skýjum himinsins.“ ");
INSERT INTO isl_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Þá reif æðsti presturinn föt sín og hrópaði: „Þurfum við framar vitnanna við! Þið heyrðuð sjálfir guðlastið. Hvað finnst ykkur?“ Og þeir dæmdu hann til dauða einum rómi. ");
INSERT INTO isl_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nokkrir viðstaddra tóku að hrækja á Jesú, héldu fyrir augu hans og slógu hann í andlitið. „Spámaður!“ æptu þeir hæðnislega, „hver sló þig núna?“ Jafnvel verðirnir slógu hann, þegar þeir leiddu hann burt. ");
INSERT INTO isl_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Meðan þetta gerðist var Pétur niðri í garðinum. Ein þjónustustúlka æðsta prestsins tók þá eftir honum, þar sem hann var að ylja sér við eldinn. Hún veitti honum nánari athygli og sagði síðan: „Þú varst áreiðanlega með Jesú frá Nasaret.“ ");
INSERT INTO isl_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pétur neitaði og sagði: „Ég skil ekki hvað þú átt við!“ Síðan færði hann sig nær hliðinu. Þá gól haninn! ");
INSERT INTO isl_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Eftir stundarkorn kom stúlkan aftur auga á Pétur og sagði við nærstadda: „Þarna er hann! Þarna er þessi lærisveinn Jesú.“ ");
INSERT INTO isl_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","En hann neitaði aftur. Stuttu síðar sögðu aðrir, sem stóðu umhverfis eldinn, við Pétur: „Þú ert líka einn af þeim, því þú ert frá Galíleu.“ ");
INSERT INTO isl_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Þá tók hann að blóta og formæla og sagði: „Ég þekki alls ekki þennan mann!“ ");
INSERT INTO isl_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Þá gól haninn í annað sinn. Og Pétur minntist orða Jesú: „Áður en haninn galar tvisvar, muntu þrisvar afneita mér.“ Þá brast Pétur í grát. ");
INSERT INTO isl_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Snemma morguns kom hæstiréttur saman til að ákveða næsta skref í málinu. Í hæstarétti sátu æðstu prestarnir, öldungar og fræðimenn þjóðarinnar. Niðurstaðan varð sú að þeir ákváðu að senda Jesú í fylgd vopnaðra varðmanna til Pílatusar, rómverska landstjórans. ");
INSERT INTO isl_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","„Ertu konungur Gyðinga?“ spurði Pílatus Jesú. „Já,“ svaraði Jesús, „það er rétt eins og þú orðar það.“ ");
INSERT INTO isl_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","4","Æðstu prestarnir báru nú margar sakir á Jesú. „Af hverju segirðu ekki neitt?“ spurði Pílatus Jesú. „Hvað um allar þessar ákærur?“ ");
INSERT INTO isl_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","En Jesús þagði, Pílatusi til mikillar furðu. ");
INSERT INTO isl_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Það var venja að náða einn fanga á páskunum – einhvern sem fólkið kom sér saman um. ");
INSERT INTO isl_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Um þetta leyti var fangi, Barrabas að nafni, í haldi. Hann hafði ásamt öðrum verið dæmdur fyrir morð í uppreisnartilraun. ");
INSERT INTO isl_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nú kom hópur manna til Pílatusar og bað hann að náða einn fanga á hátíðinni eins og venja var. ");
INSERT INTO isl_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","„Hvernig væri að láta ykkur fá „konung Gyðinga“?“ spurði Pílatus. „Er það hann sem þið viljið fá lausan?“ ");
INSERT INTO isl_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","(Þetta sagði hann því honum var orðið ljóst að réttarhöldin höfðu verið sviðsett af æðstu prestunum, þar eð þeir öfunduðu Jesú vegna vinsælda hans.) ");
INSERT INTO isl_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","En þegar hér var komið sögu, höfðu æðstu prestarnir æst múginn til að krefjast Barrabasar í stað Jesú. ");
INSERT INTO isl_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","„Ef ég sleppi Barrabasi,“ sagði Pílatus, „hvað á ég þá að gera við þennan mann, sem þið kallið konung ykkar?“ ");
INSERT INTO isl_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","„Krossfestu hann!“ hrópuðu þeir. ");
INSERT INTO isl_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","„Hvers vegna?“ spurði Pílatus ákveðinn. „Hvað hefur hann gert rangt?“ Þá öskraði múgurinn enn hærra: „Krossfestu hann!“ ");
INSERT INTO isl_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Þá lét Pílatus Barrabas lausan af því að hann óttaðist uppþot og vildi geðjast fólkinu. Síðan gaf hann skipun um að Jesús skyldi húðstrýktur og sendur til krossfestingar. ");
INSERT INTO isl_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","17","Rómversku hermennirnir fóru með Jesú inn í landsstjórahöllina og kölluðu saman alla varðsveitina. Þeir færðu hann í purpuralita skikkju og fléttuðu kórónu úr þyrnum og settu hana á höfuð honum. ");
INSERT INTO isl_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Síðan heilsuðu þeir honum á hermannavísu og æptu: „Lengi lifi konungur Gyðinga!“ ");
INSERT INTO isl_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Svo börðu þeir hann í höfuðið með priki, hræktu á hann og féllu á kné og þóttust veita honum lotningu. ");
INSERT INTO isl_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Þegar þeir voru orðnir leiðir á leik sínum, færðu þeir hann úr purpuraskikkjunni, klæddu hann aftur í eigin föt og fóru með hann til krossfestingar. ");
INSERT INTO isl_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Símon frá Kýrene varð á vegi þeirra, á leið ofan úr sveit. Hann var neyddur til að bera kross Jesú. (Símon var faðir Alexanders og Rúfusar.) ");
INSERT INTO isl_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Þeir fóru nú með Jesú á stað sem heitir Golgata. (Golgata þýðir hauskúpa.) ");
INSERT INTO isl_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Þar var Jesú boðið beiskt vín, en hann vildi það ekki. ");
INSERT INTO isl_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Eftir það krossfestu þeir hann og vörpuðu hlutkesti um föt hans. ");
INSERT INTO isl_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Krossfestingin átti sér stað um níuleytið að morgni. ");
INSERT INTO isl_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Á krossinn var fest áletrun þar sem afbrot Jesú var gefið til kynna: „Konungur Gyðinga“. ");
INSERT INTO isl_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tveir ræningjar voru einnig krossfestir þennan sama morgun og stóðu krossar þeirra sinn hvorum megin við kross Jesú. ");
INSERT INTO isl_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Þar með rættust orð Gamla testamentisins sem þannig hljóða: „Hann var talinn með illræðismönnum“. ");
INSERT INTO isl_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Fólk sendi honum háðsglósur um leið og það gekk framhjá og hristi höfuðið af vandlætingu. „Hæ! Sjá þig núna!“ æpti það. „Já, þú getur áreiðanlega rifið musterið og byggt það aftur á þrem dögum! Fyrst þú ert svona mikill maður, bjargaðu þá sjálfum þér og stígðu niður af krossinum!“ ");
INSERT INTO isl_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Æðstu prestarnir, sem einnig voru þarna nærstaddir ásamt öðrum trúarleiðtogum, hæddu hann og sögðu: „Hann var nógu iðinn við að „frelsa“ aðra, en sjálfum sér getur hann ekki bjargað!“ ");
INSERT INTO isl_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","„Kristur!“ hrópuðu þeir til hans, „konungur Ísraels! Stígðu nú niður af krossinum og þá skulum við trúa á þig!“ Ræningjarnir, sem áttu að deyja með honum, tóku einnig í sama streng og formæltu honum. ");
INSERT INTO isl_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Um hádegi varð dimmt um allt landið og hélst myrkrið allt til klukkan þrjú síðdegis. ");
INSERT INTO isl_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Þá kallaði Jesús hárri röddu: „Elí, Elí, lama sabaktaní!“ (Guð minn, Guð minn, hví hefur þú yfirgefið mig?) ");
INSERT INTO isl_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Sumir þeirra, sem þarna stóðu, héldu að hann væri að kalla á Elía spámann. ");
INSERT INTO isl_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Þá hljóp einn þeirra eftir svampi, fyllti hann af ediki, rétti Jesú á langri stöng og sagði: „Bíðum við, sjáum hvort Elía kemur og tekur hann niður af krossinum.“ ");
INSERT INTO isl_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","En Jesús kallaði aftur hárri röddu og gaf upp andann. ");
INSERT INTO isl_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Þá rifnaði fortjald musterisins í tvennt, ofan frá og niður úr. ");
INSERT INTO isl_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Þegar rómverski liðsforinginn, sem stóð við kross Jesú, sá hvernig hann gaf upp andann, hrópaði hann: „Þessi maður hefur áreiðanlega verið sonur Guðs.“ ");
INSERT INTO isl_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Hópur kvenna stóð álengdar og fylgdist með öllu sem gerðist. Þeirra á meðal voru María Magdalena, María (móðir Jakobs yngri og Jóse) og Salóme. ");
INSERT INTO isl_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Þær höfðu, auk margra annarra kvenna, fylgt honum og þjónað meðan hann var norður í Galíleu og nú höfðu þær komið með honum til Jerúsalem. ");
INSERT INTO isl_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Atburðir þessir áttu sér stað daginn fyrir helgidaginn. Síðdegis þennan sama dag herti Jósef frá Arímaþeu upp hugann og fór til Pílatusar og bað um líkama Jesú. Jósef þessi var virtur meðlimur hæstaréttar og trúaður maður (sem sjálfur vænti komu guðsríkisins). ");
INSERT INTO isl_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","En Pílatus trúði ekki að Jesús væri þá þegar dáinn og lét því kalla á liðsforingjann, sem sá um aftökuna, og spurði hann. ");
INSERT INTO isl_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Liðsforinginn staðfesti að Jesús væri dáinn og gaf þá Pílatus Jósef leyfi til að taka líkið. ");
INSERT INTO isl_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jósef keypti langan léreftsdúk, tók líkama Jesú niður af krossinum og vafði hann í dúkinn. Síðan lagði hann líkið í gröf sem höggvin hafði verið í klett og velti steini fyrir dyrnar. ");
INSERT INTO isl_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","(María Magdalena og María móðir Jóse fylgdust með þegar Jesús var lagður í gröfina.) ");
INSERT INTO isl_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kvöldið eftir, þegar helgidagurinn var liðinn, keyptu María Magdalena, Salóme og María móðir Jakobs, ilmsmyrsl til að smyrja líkama Jesú. ");
INSERT INTO isl_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Við sólarupprás morguninn eftir fóru þær með smyrslin út að gröfinni. ");
INSERT INTO isl_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Á leiðinni ræddu þær um hvernig þær ættu að velta steininum frá dyrunum – hann var stór og mjög þungur. ");
INSERT INTO isl_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","En þegar þær nálguðust, sáu þær að inngangurinn var opinn – steininum hafði þegar verið velt frá! ");
INSERT INTO isl_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Þær gengu inn í gröfina, en brá mjög er þær sáu ungan mann, hvítklæddan, sitja þar inni, hægra megin. ");
INSERT INTO isl_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","„Verið óhræddar,“ sagði engillinn. „Þið leitið að Jesú frá Nasaret, hinum krossfesta, er ekki svo? Hann er upprisinn. Hann er ekki hér. Sjáið, þarna lögðu þeir hann. ");
INSERT INTO isl_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Farið nú og segið lærisveinum hans – og Pétri: „Hann fer á undan ykkur til Galíleu og þar munuð þið hitta hann eins og hann sagði.“ “ ");
INSERT INTO isl_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Konurnar flýðu skelfingu lostnar frá gröfinni og komu ekki upp nokkru orði. ");
INSERT INTO isl_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Upprisa Jesú átti sér stað snemma á sunnudagsmorgni og María Magdalena sá hann fyrst allra (hún hafði áður haft sjö illa anda sem Jesús rak út af henni.) ");
INSERT INTO isl_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Hún fór og fann lærisveinana samankomna, grátandi af hryggð. „Ég hef séð Jesú!“ hrópaði hún. „Hann er lifandi!“ En þeir trúðu henni ekki. ");
INSERT INTO isl_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Seinna þennan sama dag birtist Jesús tveim mönnum sem voru á gangi frá Jerúsalem, á leið upp í sveit. Í fyrstu þekktu þeir hann ekki, því hann hafði breyst í útliti. ");
INSERT INTO isl_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Þegar þeir loks áttuðu sig á hver hann var, flýttu þeir sér aftur til Jerúsalem og sögðu hinum frá, en þeir trúðu þeim ekki heldur. ");
INSERT INTO isl_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Seinna, þegar lærisveinarnir ellefu sátu saman til borðs, birtist Jesús þeim. Hann ávítaði þá fyrir vantrú þeirra og þrjósku – að þeir skyldu ekki vilja trúa þeim, sem höfðu séð hann upprisinn. ");
INSERT INTO isl_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Síðan sagði hann: „Farið út um allan heiminn og boðið öllum fagnaðarerindið. ");
INSERT INTO isl_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Þeir sem þá trúa og verða skírðir, munu frelsast, en þeir sem hafna trúnni verða dæmdir. ");
INSERT INTO isl_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Þeir sem trúa, skulu fá kraft minn til að reka út illa anda og tala tungum. ");
INSERT INTO isl_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Þeir munu jafnvel geta handleikið höggorma án þess að bíða tjón, og þótt þeir drekki eitthvað eitrað, mun þá ekki saka. Þeir skulu einnig leggja hendur yfir sjúka og lækna þá.“ ");
INSERT INTO isl_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Eftir að Drottinn Jesús hafði talað til þeirra, var hann numinn upp til himins og settist til hægri handar Guði. ");
INSERT INTO isl_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","En lærisveinarnir fóru af stað og predikuðu alls staðar. Drottinn var með þeim og staðfesti það sem þeir sögðu, með kraftaverkum, sem fylgdu orðum þeirra.");
INSERT INTO isl_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2"," Heiðraði Þeófílus. Nú þegar hafa verið skrifaðar allmargar frásögur um Krist, byggðar á heimildum postulanna og annarra sjónarvotta. ");
INSERT INTO isl_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","En ég taldi rétt að rannsaka þessar heimildir á ný frá upphafi til enda, og nú sendi ég þér árangur þeirra nákvæmu athugana sem ég hef gert. ");
INSERT INTO isl_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Þetta geri ég til að fullvissa þig um sannleiksgildi þess sem þú hefur heyrt hjá öðrum. ");
INSERT INTO isl_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Frásaga mín hefst á prestinum Sakaría, sem var uppi á dögum Heródesar konungs í Júdeu. Sakaría var úr flokki Abía, en það var einn af mörgum flokkum musterisþjónanna. Elísabet, kona hans, var einnig af gyðinglegri prestaætt; afkomandi Arons. ");
INSERT INTO isl_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Þau hjón voru bæði guðrækin og leituðust við að halda boðorð Guðs óaðfinnanlega. ");
INSERT INTO isl_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Þau voru barnlaus – Elísabet gat ekki átt börn – og auk þess orðin roskin. ");
INSERT INTO isl_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Dag nokkurn þegar Sakaría var að sinna störfum sínum í musterinu – flokkur hans var einmitt á vakt þá vikuna – féll það í hlut hans að fara inn í musterið og brenna reykelsi frammi fyrir Drottni. ");
INSERT INTO isl_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Eins og ávallt er reykelsisfórnin fór fram, stóð fjöldi fólks fyrir utan musterið á bæn. ");
INSERT INTO isl_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","12","Allt í einu sá Sakaría engil standa hægra megin við reykelsisaltarið. Honum varð hverft við og hann varð mjög hræddur. ");
INSERT INTO isl_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Engillinn sagði: „Sakaría, vertu óhræddur! Ég kem til að segja þér að Guð hefur heyrt bæn þína. Konan þín, hún Elísabet, mun fæða þér son! Þú skalt láta hann heita Jóhannes. ");
INSERT INTO isl_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Fæðing hans mun verða ykkur báðum mikið gleðiefni og margir munu samgleðjast ykkur, ");
INSERT INTO isl_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","því hann á eftir að verða einn af hetjum Guðs. Hann má aldrei snerta vín né sterka drykki, en þess í stað mun hann fyllast heilögum anda, meira að segja áður en hann fæðist! ");
INSERT INTO isl_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Hann mun snúa mörgum Gyðingum til Drottins, Guðs þeirra. ");
INSERT INTO isl_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Hann verður mikilmenni og máttugur eins og Elía, hinn forni spámaður. Hann mun koma á undan Kristi, búa fólkið undir komu hans og kenna því að elska Drottin eins og forfeður þess gerðu, og lifa sem trúað fólk.“ ");
INSERT INTO isl_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Þá sagði Sakaría við engilinn: „Já, en þetta er útilokað! Ég er orðinn gamall og konan mín líka.“ ");
INSERT INTO isl_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Engillinn svaraði: „Ég er Gabríel! Ég stend frammi fyrir hásæti Guðs, sem sendi mig til að flytja þér þessar góðu fréttir ");
INSERT INTO isl_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","En fyrst þú trúðir mér ekki, munt þú verða mállaus þangað til barnið er fætt. Ég ábyrgist að orð mín munu rætast á sínum tíma.“ ");
INSERT INTO isl_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Fólkið beið eftir Sakaría og undraðist hve honum dvaldist í musterinu. ");
INSERT INTO isl_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Þegar hann kom út, gat hann ekkert sagt, og fólkið skildi af látbragði hans að hann hlyti að hafa séð sýn inni í musterinu. ");
INSERT INTO isl_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Eftir þetta dvaldist hann í musterinu sinn tíma og fór síðan heim. ");
INSERT INTO isl_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Stuttu síðar varð Elísabet kona hans þunguð en hún leyndi því fyrstu fimm mánuðina. ");
INSERT INTO isl_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","„En hvað Drottinn er góður að leysa mig undan þeirri skömm að geta ekki átt barn!“ hrópaði hún. ");
INSERT INTO isl_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Mánuði síðar sendi Guð engilinn Gabríel til meyjar sem María hét og bjó í þorpinu Nasaret í Galíleu. Hún var trúlofuð manni að nafni Jósef og var hann af ætt Davíðs konungs. ");
INSERT INTO isl_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gabríel birtist henni og sagði: „Sæl, þú hin útvalda! Drottinn er með þér!“ ");
INSERT INTO isl_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","María varð undrandi og reyndi að skilja hvað engillinn ætti við. ");
INSERT INTO isl_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","„Vertu ekki hrædd, María,“ sagði engillinn, „Guð ætlar að blessa þig ríkulega. ");
INSERT INTO isl_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Innan skamms munt þú verða barnshafandi og eignast dreng, sem þú skalt nefna Jesú. ");
INSERT INTO isl_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Hann mun verða mikill og kallast sonur Guðs. Drottinn Guð mun gefa honum hásæti Davíðs konungs, ættföður hans, ");
INSERT INTO isl_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","og hann mun ríkja yfir Ísrael að eilífu. Á ríki hans mun enginn endir verða!“ ");
INSERT INTO isl_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","„Hvernig má það vera?“ spurði María, „ég hef ekki karlmanns kennt.“ ");
INSERT INTO isl_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Engillinn svaraði: „Heilagur andi mun koma yfir þig og kraftur Guðs mun umlykja þig, barnið þitt verður því heilagt sonur Guðs. ");
INSERT INTO isl_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nú eru sex mánuðir síðan Elísabet frænka þín óbyrjan, eins og fólk kallaði hana – varð þunguð í elli sinni! ");
INSERT INTO isl_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Guði er ekkert um megn.“ ");
INSERT INTO isl_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Og María sagði: „Ég vil hlýða og þjóna Drottni. Verði allt eins og þú sagðir.“ Þá hvarf engillinn. ");
INSERT INTO isl_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Nokkrum dögum síðar fór María til fjallaþorpsins í Júdeu þar sem Sakaría bjó og heimsótti Elísabetu. ");
INSERT INTO isl_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Þegar María heilsaði, tók barn Elísabetar viðbragð í kviði hennar og hún fylltist heilögum anda. ");
INSERT INTO isl_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Hún hrópaði upp í gleði sinni og sagði við Maríu: „Guð hefur blessað þig umfram allar aðrar konur, og barni þínu er ætluð hin æðsta blessun hans. ");
INSERT INTO isl_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Hvílíkur heiður fyrir mig að móðir Drottins míns skuli heimsækja mig. ");
INSERT INTO isl_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Um leið og þú komst inn og heilsaðir mér tók barnið mitt viðbragð af gleði! ");
INSERT INTO isl_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Þú trúðir að Guð mundi standa við orð sín og þess vegna hefur hann ríkulega blessað þig.“ ");
INSERT INTO isl_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Og María sagði: „Ó, ég lofa Drottin! ");
INSERT INTO isl_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ég gleðst í Guði, frelsara mínum. ");
INSERT INTO isl_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Hann mundi eftir lítilmótlegri ambátt sinni og héðan í frá munu allar kynslóðir tala um hvernig Guð blessaði mig. ");
INSERT INTO isl_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Hann, hinn voldugi og heilagi, hefur gert mikla hluti fyrir mig. ");
INSERT INTO isl_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Miskunn hans við þá sem trúa á hann, varir frá kynslóð til kynslóðar. ");
INSERT INTO isl_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Hann hefur unnið stórvirki með mætti sínum og tvístrað hinum stoltu og drambsömu. ");
INSERT INTO isl_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Hann hefur steypt höfðingjum úr hásætum og upphafið auðmjúka. ");
INSERT INTO isl_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Hann hefur mettað hungraða gæðum og látið ríka fara tómhenta frá sér. ");
INSERT INTO isl_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Hann hefur hjálpað þjóni sínum, Ísrael, og ekki gleymt loforðum sínum. ");
INSERT INTO isl_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Hann lofaði feðrum okkar – Abraham og afkomendum hans – að sýna þeim miskunn að eilífu.“ ");
INSERT INTO isl_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Eftir þetta dvaldist María hjá Elísabetu í þrjá mánuði, en að því búnu hélt hún heim. ");
INSERT INTO isl_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Þegar meðgöngutíma Elísabetar lauk, fæddi hún son. ");
INSERT INTO isl_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Vinir og ættingjar fréttu fljótt hve góður Drottinn hafði verið Elísabetu og samglöddust henni. ");
INSERT INTO isl_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Þegar barnið var átta daga gamalt komu þeir til að vera viðstaddir umskurnina. Allir gerðu ráð fyrir að drengurinn yrði látinn heita Sakaría eftir föður sínum, ");
INSERT INTO isl_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","en Elísabet sagði: „Nei, hann á að heita Jóhannes.“ ");
INSERT INTO isl_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","„Hvers vegna?“ spurði fólkið undrandi, „það er enginn með því nafni í allri fjölskyldunni!“ ");
INSERT INTO isl_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Faðir barnsins var síðan spurður með bendingum hvað barnið ætti að heita. ");
INSERT INTO isl_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Hann bað um spjald og skrifaði á það, öllum til mikillar furðu: „Nafn hans er Jóhannes.“ ");
INSERT INTO isl_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Á sama andartaki fékk hann málið og lofaði Guð. ");
INSERT INTO isl_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nágrannarnir urðu undrandi og fréttin um þetta barst um alla fjallabyggð Júdeu. ");
INSERT INTO isl_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Þeir sem heyrðu þetta, veltu því vandlega fyrir sér og sögðu: „Hvað skyldi verða úr þessu barni? Hönd Drottins er greinilega með því á sérstakan hátt.“ ");
INSERT INTO isl_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sakaría, faðir drengsins, fylltist heilögum anda og spáði: ");
INSERT INTO isl_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","„Lofaður sé Drottinn, Guð Ísraels, því hann hefur vitjað þjóðar sinnar til að bjarga henni. ");
INSERT INTO isl_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Hann gefur okkur máttugan frelsara af ætt Davíðs konungs, þjóns síns, ");
INSERT INTO isl_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","eins og hinir heilögu spámenn höfðu sagt fyrir, ");
INSERT INTO isl_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","til að frelsa okkur undan óvinum okkar og öllum þeim sem hata okkur. ");
INSERT INTO isl_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","74","Hann sýndi forfeðrum okkar miskunn og minntist síns heilaga loforðs, sem hann gaf Abraham, að frelsa okkur frá óvinum okkar, ");
INSERT INTO isl_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","helga okkur og gera okkur hæf til að dvelja hjá sér að eilífu. ");
INSERT INTO isl_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Þú, sonur minn, verður kallaður spámaður almáttugs Guðs, því þú munt ryðja Kristi veg. ");
INSERT INTO isl_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Þú munt veita fólkinu þekkingu á hjálpræðinu og fyrirgefningu syndanna. ");
INSERT INTO isl_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Þessu mun kærleikur Guðs og miskunn koma til leiðar, hann sendir okkur ljós sitt. ");
INSERT INTO isl_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Það mun lýsa þeim er sitja í myrkri og skugga dauðans, og leiða okkur á friðarveg.“ ");
INSERT INTO isl_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Og drengurinn óx og Guð styrkti hann. Þegar hann hafði aldur til, fór hann út í óbyggðina og dvaldist þar þangað til hann hóf starf sitt meðal þjóðarinnar. ");
INSERT INTO isl_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Um þetta leyti fyrirskipaði rómverski keisarinn, Ágústus, að manntal skyldi tekið um allt Rómaveldi. ");
INSERT INTO isl_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Þetta fyrsta manntal var gert þegar Kýreníus var landstjóri á Sýrlandi. ");
INSERT INTO isl_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Þess vegna urðu allir að fara til ættborgar sinnar og láta skrá sig þar. ");
INSERT INTO isl_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Þar sem Jósef var af ætt Davíðs konungs, varð hann að fara frá heimabæ sínum, Nasaret í Galíleu, til Betlehem í Júdeu, hinnar fornu borgar Davíðs, ");
INSERT INTO isl_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ásamt Maríu unnustu sinni sem þá var að því komin að eiga barn. ");
INSERT INTO isl_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Meðan þau voru í Betlehem, fæddi hún sitt fyrsta barn og var það drengur. Hún vafði hann reifum og lagði hann í jötu, því ekkert rúm var fyrir þau í gistihúsinu. ");
INSERT INTO isl_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Þessa sömu nótt voru fjárhirðar á völlunum utan við þorpið og gættu hjarðar sinnar. ");
INSERT INTO isl_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Allt í einu birtist þeim engill og ljóminn af dýrð Drottins lýsti upp umhverfið. Hirðarnir urðu skelkaðir, ");
INSERT INTO isl_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","en engillinn hughreysti þá og sagði: „Verið óhræddir! Ég flyt ykkur miklar gleðifréttir sem berast eiga öllum mönnum: ");
INSERT INTO isl_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Frelsari ykkar, sjálfur konungurinn Kristur, fæddist í nótt í Betlehem! ");
INSERT INTO isl_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Þið munuð finna reifabarn, liggjandi í jötu – það er hann!“ ");
INSERT INTO isl_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Um leið var með englunum fjöldi annarra engla – herskarar himnanna – og þeir lofuðu Guð og sungu: ");
INSERT INTO isl_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","„Dýrð sé Guði í upphæðum og friður á jörðu með öllum þeim sem hann elskar.“ ");
INSERT INTO isl_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Þegar englarnir voru farnir aftur til himna, sögðu hirðarnir hver við annan: „Flýtum okkur til Betlehem og sjáum þennan stórkostlega atburð, sem Drottinn hefur sagt okkur frá!“ ");
INSERT INTO isl_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Þeir hlupu til þorpsins og fundu bæði Maríu, Jósef og barnið í jötunni. ");
INSERT INTO isl_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Fjárhirðarnir sögðu síðan öllum hvað gerst hafði og hvað engillinn hafði sagt þeim um þetta barn. ");
INSERT INTO isl_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Allir sem heyrðu frásögn hirðanna, undruðust mjög, ");
INSERT INTO isl_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","en María lagði allt þetta vel á minnið og hugleiddi það með sjálfri sér. ");
INSERT INTO isl_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Fjárhirðarnir fóru nú aftur út í hagann og lofuðu Guð fyrir allt sem þeir höfðu heyrt og séð, og engillinn hafði sagt þeim. ");
INSERT INTO isl_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Að átta dögum liðnum var drengurinn umskorinn og gefið nafnið Jesús, eins og engillinn nefndi hann, áður en hann var getinn í móðurlífi. ");
INSERT INTO isl_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Þegar tími var kominn til að María færði hreinsunarfórn í musterinu, eins og lög Móse krefjast þegar barn hefur fæðst, fóru foreldrar Jesú með hann upp til Jerúsalem til að færa hann Drottni. ");
INSERT INTO isl_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Guð segir svo í þessum lögum: „Ef kona fæðir dreng fyrstan barna sinna, skal hann helgaður Drottni.“ ");
INSERT INTO isl_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Um leið færðu foreldrar Jesú einnig hreinsunarfórnina, sem lögin kröfðust, en hún varð annað hvort að vera tvær turtildúfur eða tvær ungar dúfur. ");
INSERT INTO isl_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Í Jerúsalem bjó maður sem Símeon hét. Hann var góður maður og guðrækinn, fylltur heilögum anda og vænti komu Krists, konungsins, sem Guð hafði lofað að senda. ");
INSERT INTO isl_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Heilagur andi hafði gert honum ljóst að hann mundi ekki deyja fyrr en hann hefði fengið að sjá konunginn Krist. ");
INSERT INTO isl_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Þennan dag hafði hann einmitt fengið vísbendingu frá heilögum anda um að fara í helgidóminn. Þangað kom hann er María og Jósef komu með barnið til að færa það Drottni, eins og lögin mæltu fyrir um. ");
INSERT INTO isl_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Símeon tók barnið í fang sér og lofaði Guð. ");
INSERT INTO isl_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","31","Hann sagði: „Drottinn, nú get ég glaður dáið, því ég hef séð þann sem þú lofaðir að ég skyldi sjá. Ég hef augum litið frelsara heimsins! ");
INSERT INTO isl_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Hann er ljósið, sem lýsa mun þjóðunum, og hann verður vegsemd þjóðar þinnar Ísrael.“ ");
INSERT INTO isl_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jósef og María stóðu hjá og hlustuðu undrandi á það sem Símeon sagði um Jesú. ");
INSERT INTO isl_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Símeon blessaði þau en sagði síðan við Maríu: „Sverð mun nísta sál þína, því margir í Ísrael munu hafna þessu barni og það mun verða þeim til falls, en öðrum verður hann uppspretta gleðinnar. Þannig mun afstaða og hugsanir margra koma fram í ljósið.“ ");
INSERT INTO isl_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Spákona nokkur, Anna að nafni, var einnig stödd í musterinu þennan dag. Hún var Fanúelsdóttir og af ætt Assers. Hún var orðin háöldruð og hafði verið ekkja í áttatíu og fjögur ár eftir sjö ára búskap. Hún fór aldrei út úr musterinu, heldur dvaldist þar dag og nótt. Hún helgaði líf sitt Guði og lofaði hann með bænahaldi og föstu. ");
INSERT INTO isl_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nú kom hún þar að sem Símeon var að tala við Maríu og Jósef og byrjaði einnig að þakka Guði. Hún tók að segja öllum í Jerúsalem, sem væntu komu frelsarans, að Kristur væri loksins kominn. ");
INSERT INTO isl_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Þegar foreldrar Jesú höfðu gert allt sem lögin kröfðust, fóru þau aftur heim til Nasaret í Galíleu. ");
INSERT INTO isl_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Drengurinn óx og þroskaðist og Guð blessaði hann. ");
INSERT INTO isl_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","42","Foreldrar Jesú fóru ár hvert til Jerúsalem á páskahátíðina, og þegar Jesús var tólf ára, fékk hann i fyrsta skipti að fara með. ");
INSERT INTO isl_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Þegar lagt var af stað heim til Nasaret, að hátíðahöldunum loknum, varð Jesús eftir í Jerúsalem. Fyrsta dag heimferðarinnar söknuðu María og Jósef hans ekki, ");
INSERT INTO isl_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","því að þau héldu að hann væri meðal kunningja sem áttu samleið. En þegar hann skilaði sér ekki um kvöldið, fóru þau að leita hans meðal vina og ættingja. ");
INSERT INTO isl_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Leitin varð árangurslaus, og því sneru þau aftur til Jerúsalem til að leita hans þar. ");
INSERT INTO isl_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","47","Þau fundu hann ekki fyrr en eftir þrjá daga. Þá sat hann í musterinu meðal lögvitringanna og ræddi við þá háleit málefni. Undruðust allir skilning hans og svör. ");
INSERT INTO isl_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Foreldrar hans vissu ekki sitt rjúkandi ráð: „Elsku drengurinn minn,“ sagði móðir hans, „af hverju gerðirðu okkur þetta? Við faðir þinn vorum dauðhrædd um þig og höfum leitað þín um allt!“ ");
INSERT INTO isl_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","„Hvers vegna voruð þið að leita að mér?“ spurði hann, „vissuð þið ekki að mér bar að vera í musterinu, húsi föður míns?“ ");
INSERT INTO isl_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","En þau skildu ekki við hvað hann átti. ");
INSERT INTO isl_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Síðan fór hann með þeim heim til Nasaret og var þeim hlýðinn, en móðir hans lagði alla þessa atburði vel á minnið. ");
INSERT INTO isl_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús óx að visku og vexti og allir elskuðu hann, bæði Guð og menn. ");
INSERT INTO isl_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Á fimmtánda stjórnarári Tíberíusar keisara, komu boð frá Guði til Jóhannesar (Sakaríassonar) þar sem hann hafðist við úti í eyðimörkinni. Þegar þetta gerðist var Pílatus landstjóri í Júdeu, Heródes héraðsstjóri í Galíleu og bróðir hans, Filippus, í Átúreu og Trakónítis. Lýsanías var yfir Ablílene og Annas og Kaífas voru æðstuprestar. ");
INSERT INTO isl_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Þá lagði Jóhannes leið sína til ýmissa staða beggja megin Jórdanar og bauð fólkinu að láta skírast og sýna með því að það hefði snúið sér frá syndinni og til Guðs, til að fá fyrirgefningu. ");
INSERT INTO isl_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Þannig lýsti Jesaja spámaður Jóhannesi: „Rödd hrópar í auðninni: „Ryðjið Drottni veg! Fyllið upp dalina! ");
INSERT INTO isl_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Jafnið fjöllin við jörðu! Gerið brautirnar beinar! ");
INSERT INTO isl_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Og mannkynið allt mun sjá hjálpræði Guðs!“ “ ");
INSERT INTO isl_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Hér er lítið sýnishorn af því sem Jóhannes sagði við fólkið þegar það kom til að láta skírast: „Þið höggormsafkvæmi! Þið viljið skírast, svo að þið komist hjá því að taka afleiðingum synda ykkar, en samt viljið þið ekki snúa ykkur til Guðs af heilum hug! ");
INSERT INTO isl_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nei, farið fyrst og sýnið með líferni ykkar að þið hafið í raun og veru tekið nýja stefnu. Þið skuluð ekki halda að ykkur sé borgið vegna þess að þið eruð afkomendur Abrahams, nei, það nægir ekki. Guð getur skapað Abrahamssyni af þessu grjóti! ");
INSERT INTO isl_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Öxi dómarans er reidd gegn ykkur og þið verðið höggvin upp frá rótum. Sérhvert tré, sem ekki ber góðan ávöxt, verður fellt og því kastað í eldinn.“ ");
INSERT INTO isl_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","„Hvað viltu að við gerum?“ spurði fólkið. ");
INSERT INTO isl_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","„Sá sem á tvær skyrtur, gefi aðra fátækum og ef þið eigið umframbirgðir af mat, þá gefið þær hungruðum,“ svaraði hann. ");
INSERT INTO isl_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Jafnvel skattheimtumenn, sem þekktir voru fyrir að stela, komu til að láta skírast. Þeir spurðu: „Með hverju getum við sýnt að við höfum iðrast synda okkar?“ ");
INSERT INTO isl_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","„Með því að vera heiðarlegir,“ svaraði Jóhannes. „Gætið þess að taka ekki hærri skatta af fólkinu en rómversku yfirvöldin krefjast.“ ");
INSERT INTO isl_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","„En við,“ sögðu nokkrir hermenn, „hvað með okkur?“ Jóhannes svaraði: „Reynið ekki að komast yfir peninga með ógnunum og ofbeldi. Dæmið engan ranglega og látið ykkur nægja laun ykkar.“ ");
INSERT INTO isl_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nú hafði vaknað eftirvænting hjá fólkinu og töldu margir jafnvel að Jóhannes væri Kristur. ");
INSERT INTO isl_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","En Jóhannes sagði: „Ég skíri aðeins með vatni, en bráðlega kemur sá sem hefur miklu meira vald en ég. Sannleikurinn er sá að ég er ekki einu sinni verður þess að vera þræll hans. Hann mun skíra ykkur með heilögum anda og eldi. ");
INSERT INTO isl_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Hismið mun hann skilja frá korninu og brenna það í óslökkvandi eldi, en geyma kornið og setja í hlöður sínar.“ ");
INSERT INTO isl_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Margar slíkar viðvaranir flutti Jóhannes fólkinu um leið og hann boðaði því gleðitíðindin. ");
INSERT INTO isl_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","(En þegar Jóhannes gagnrýndi Heródes, landstjóra Galíleu, opinberlega fyrir að kvænast Heródías, konu bróður síns, og fyrir marga aðra óhæfu, lét Heródes varpa honum í fangelsi og jók þar með enn við syndir sínar.) ");
INSERT INTO isl_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Dag einn bættist Jesús í þann stóra hóp, sem tók skírn hjá Jóhannesi. Á meðan hann var að biðjast fyrir, opnuðust himnarnir, ");
INSERT INTO isl_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","og heilagur andi kom yfir hann í dúfulíki. Þá heyrðist rödd af himni sem sagði: „Þú ert minn elskaði sonur, sem ég hef velþóknun á.“ ");
INSERT INTO isl_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús var um þrítugt, þegar hann hóf starf sitt meðal fólksins. Almennt var litið á Jesú sem son Jósefs, Jósef var sonur Elí, ");
INSERT INTO isl_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí var sonur Mattats, Mattat var sonur Leví, Leví var sonur Melkí, Melkí var sonur Jannaí, Jannaí var sonur Jósefs, ");
INSERT INTO isl_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jósef var sonur Mattatíasar, Mattatías var sonur Amosar, Amos var sonur Naúms, Naúm var sonur Eslí, Eslí var sonur Naggaí, ");
INSERT INTO isl_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggaí var sonur Maats, Maat var sonur Mattatíasar, Mattatías var sonur Semeíns, Semeín var sonur Jóseks, Jósek var sonur Jóda, ");
INSERT INTO isl_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jóda var sonur Jóhanans, Jóhanan var sonur Hresa, Hresa var sonur Serúbabels, Serúbabel var sonur Sealtíels, Sealtíel var sonur Nerí, ");
INSERT INTO isl_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerí var sonur Melkí, Melkí var sonur Addí, Addí var sonur Kósams, Kósam var sonur Elmadams, Elmadam var sonur Ers, ");
INSERT INTO isl_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ers var sonur Jesú, Jesús var sonur Elíesers, Elíeser var sonur Jóríms, Jórím var sonur Mattats, Mattat var sonur Leví, ");
INSERT INTO isl_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leví var sonur Símeons, Símeon var sonur Júda, Júda var sonur Jósefs, Jósef var sonur Jónams, Jónam var sonur Eljakíms, ");
INSERT INTO isl_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eljakím var sonur Melea, Melea var sonur Menna, Menna var sonur Mattata, Mattata var sonur Natans, Natan var sonur Davíðs, ");
INSERT INTO isl_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davíð var sonur Ásaí, Ásaí var sonur Óbeðs, Óbeð var sonur Bóasar, Bóas var sonur Salmons, Salmon var sonur Nahsons, ");
INSERT INTO isl_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahson var sonur Ammínadabs, Ammínadab var sonur Arní, Arní var sonur Esroms, Esrom varsonur Peres, Peres var sonur Júda, ");
INSERT INTO isl_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Júda var sonur Jakobs, Jakob var sonur Ásaks, Ásak var sonur Abrahams, Abraham var sonur Tara, Tara var sonur Nakórs, ");
INSERT INTO isl_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakór var sonur Serúks, Serúk var sonur Reús, Reú var sonur Peleks, Pelek var sonur Ebers, Eber var sonur Sela, ");
INSERT INTO isl_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela var sonur Kenans, Kenan var sonur Arpaksads, Arpaksad var sonur Sems, Sem var sonur Nóa, ");
INSERT INTO isl_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Nói var sonur Lameks, Lamek var sonur Metúsala, Metúsala var sonur Enoks, Enok var sonur Jareds, Jared var sonur Mahalalels, Mahalalel var sonur Kenans, ");
INSERT INTO isl_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan var sonur Enoss, Enos var sonur Sets, Set var sonur Adams og faðir Adams var Guð. ");
INSERT INTO isl_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús fylltist heilögum anda, sem leiddi hann frá ánni Jórdan og út í auðnir Júdeu. ");
INSERT INTO isl_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Þar var hann í fjörutíu daga matarlaus og hungrið svarf að. ");
INSERT INTO isl_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Þá freistaði Satan hans og sagði: „Ef þú ert sonur Guðs, þá segðu þessum steini að verða að brauði.“ ");
INSERT INTO isl_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús svaraði: „Biblían segir: „Maðurinn lifir ekki bara á brauði.“ “ ");
INSERT INTO isl_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Þá tók Satan hann með sér og sýndi honum á augabragði öll ríki heimsins ");
INSERT INTO isl_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","og sagði: „Öll þessi ríki og dýrð þeirra er mín eign og ég get ráðstafað þeim að vild. Þetta skal allt verða þitt, ef þú fellur fram og tilbiður mig.“ ");
INSERT INTO isl_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","En Jesús svaraði: „Í Biblíunni stendur: „Drottin Guð þinn átt þú að tilbiðja og þjóna honum einum.“ “ ");
INSERT INTO isl_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Þá fór Satan með hann upp til Jerúsalem og alla leið upp á þakbrún musterisins og sagði: „Ef þú ert sonur Guðs, stökktu þá fram af! Segir Biblían ekki að Guð muni senda engla sína til að gæta þín og vernda þig, svo þú merjist ekki á stéttinni fyrir neðan?“ ");
INSERT INTO isl_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús svaraði: „Þetta stendur einnig í Biblíunni: „Ekki skaltu freista Drottins Guðs þíns.“ “ ");
INSERT INTO isl_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Þegar djöfullinn hafði lokið freistingum sínum, fór hann burt og yfirgaf Jesú að sinni. ");
INSERT INTO isl_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Eftir þetta sneri Jesús aftur til Galíleu, fylltur heilögum anda, og orðrómurinn um hann barst út um öll héruðin þar í grennd. ");
INSERT INTO isl_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Hann predikaði í samkomuhúsunum og allir lofuðu hann. ");
INSERT INTO isl_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Hann kom á æskustöðvar sínar í Nasaret og fór á helgideginum í samkomuhúsið, eins og hann var vanur, og stóð upp til að lesa úr Biblíunni. ");
INSERT INTO isl_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Honum var fengin bók Jesaja spámanns. Hann opnaði hana og las: ");
INSERT INTO isl_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","„Andi Drottins er yfir mér. Hann hefur valið mig til að flytja fátækum gleðilegan boðskap. Hann hefur sent mig til að boða fjötruðum frelsi, gefa blindum sýn, leysa hina undirokuðu frá áþján og boða að Guð sé fús að hjálpa öllum sem til hans koma.“ ");
INSERT INTO isl_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Hann lokaði bókinni og rétti þjóninum. Síðan settist hann niður. Allir störðu á hann fullir eftirvæntingar. ");
INSERT INTO isl_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Hann tók til máls og sagði: „Þessi ritningargrein, sem þið hafið nú heyrt, hefur ræst í dag.“ ");
INSERT INTO isl_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Fólkið lét ánægju sína í ljós og undraðist þau ljúfu orð sem komu af vörum hans. „Hver er skýringin á þessu,“ spurðu menn, „er þetta ekki sonur Jósefs?“ ");
INSERT INTO isl_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Þá sagði Jesús: „Þið minnið mig sjálfsagt á máltækið: „Læknir, læknaðu sjálfan þig“ – og eigið þá við: „Af hverju gerirðu ekki svipuð kraftaverk hér í heimabæ þínum og þú hefur gert í Kapernaum?“ ");
INSERT INTO isl_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ég segi ykkur satt: Enginn spámaður er viðurkenndur í heimabæ sínum! ");
INSERT INTO isl_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Þið munið til dæmis að spámaðurinn Elía gerði kraftaverk til að hjálpa ekkjunni í Sarepta, en hún var útlendingur og bjó í landi Sídonar. Það hafði ekkert rignt í þrjú og hálft ár og mikið hungur var í öllu landinu. Margar Gyðingaekkjur þörfnuðust hjálpar, en þó var Elía ekki sendur til neinnar þeirra. ");
INSERT INTO isl_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Og munið þið eftir spámanninum Elísa? Hann læknaði Naaman frá Sýrlandi, en ekki þá mörgu Gyðinga sem voru holdsveikir og þörfnuðust hjálpar.“ ");
INSERT INTO isl_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Við þessi orð Jesú urðu menn æfir af reiði. ");
INSERT INTO isl_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Þeir stukku úr sætum sínum, þyrptust að honum og hröktu hann út á brún fjallsins, sem bærinn stóð á, með það í huga að hrinda honum fram af þverhnípinu. ");
INSERT INTO isl_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","En Jesús gekk út úr þvögunni og yfirgaf þá. ");
INSERT INTO isl_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Eftir þetta fór hann til Kapernaum, bæjar í Galíleu, og þar predikaði hann í samkomuhúsinu á hverjum helgidegi. ");
INSERT INTO isl_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Hér fór á sömu leið, fólkið undraðist það sem hann sagði, því máttur fylgdi orðum hans. ");
INSERT INTO isl_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Eitt sinn, er Jesús var að kenna í samkomuhúsinu, fór maður, sem hafði illan anda, að hrópa að honum: ");
INSERT INTO isl_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","„Farðu burt! Við viljum ekkert með þig hafa, Jesús frá Nasaret. Þú ert kominn til að granda okkur. Ég veit að þú ert hinn heilagi sonur Guðs.“ ");
INSERT INTO isl_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Þá greip Jesús fram í fyrir illa andanum og sagði skipandi: „Hafðu hljótt um þig og farðu út.“ Andinn fleygði þá manninum í gólfið í augsýn allra og yfirgaf hann án þess að valda honum tjóni. ");
INSERT INTO isl_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Fólkið varð forviða og spurði: „Hvaða vald býr í orðum þessa manns, fyrst illu andarnir hlýða honum!“ ");
INSERT INTO isl_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Fréttin um þetta breiddist eins og eldur í sinu um allt héraðið. ");
INSERT INTO isl_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Þegar Jesús yfirgaf samkomuhúsið fór hann heim til Símonar. Þá var tengdamóðir Símonar þar rúmliggjandi með háan hita. Allir viðstaddir báðu Jesú að lækna hana. ");
INSERT INTO isl_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesús gekk að rúmstokknum og hastaði á sótthitann, sem þá hvarf skyndilega, og hún fór á fætur og matreiddi handa þeim. ");
INSERT INTO isl_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Við sólarlag þetta kvöld komu þorpsbúar með sjúklinga til Jesú. Það skipti ekki máli hver sjúkdómurinn var, þegar Jesús snerti þá læknuðust þeir. ");
INSERT INTO isl_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Sumir höfðu illa anda sem fóru út að skipun hans. Andar þessir æptu: „Þú ert sonur Guðs!“ Þeir vissu að hann var Kristur, en hann þaggaði niður í þeim og leyfði þeim ekki að tala. ");
INSERT INTO isl_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Við sólarupprás morguninn eftir, lagði hann leið sína á óbyggðan stað. Mannfjöldinn leitaði hans um allt og fann hann loks. Fólkið bað hann að fara ekki burt frá Kapernaum, ");
INSERT INTO isl_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","en því svaraði hann: „Ég verð líka að fara á fleiri staði og flytja þar gleðifréttirnar um að Guð sé nálægur með vald sitt og hjálp, því til þess var ég sendur.“ ");
INSERT INTO isl_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Síðan hélt hann áfram ferð sinni og predikaði í samkomuhúsunum í Júdeu. ");
INSERT INTO isl_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Dag einn var hann að predika niðri við strönd Genesaretvatnsins. Fólkið þyrptist að og þrengdi að honum, því allir vildu heyra orð Guðs. ");
INSERT INTO isl_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Hann tók þá eftir tveim mannlausum bátum í fjörunni – áhafnirnar voru þar skammt frá að þvo net sín. ");
INSERT INTO isl_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesús fór út í annan bátinn og bað eigandann, Símon, að leggja lítið eitt frá landi, svo hann gæti setið í bátnum og talað þaðan til mannfjöldans. ");
INSERT INTO isl_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Þegar hann hafði lokið máli sínu sagði hann við Símon: „Farðu nú út á dýpið og leggðu netin.“ ");
INSERT INTO isl_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","„Herra,“ svaraði Símon, „við höfum verið að í alla nótt og ekki orðið varir, en fyrst þú segir það, þá skulum við reyna.“ ");
INSERT INTO isl_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Í þetta skipti varð veiðin svo mikil að netin rifnuðu! ");
INSERT INTO isl_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Þá kölluðu þeir til félaga sinna á hinum bátnum og báðu þá að hjálpa sér. Ekki leið á löngu uns þeir höfðu drekkhlaðið báða bátana. ");
INSERT INTO isl_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Þegar Símon Pétur sá þetta, féll hann að fótum Jesú og sagði: „Farðu frá mér, herra, ég er of syndugur til að vera nálægt þér.“ ");
INSERT INTO isl_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","10","Bæði hann og félagar hans, Jakob og Jóhannes Sebedeussynir, voru gagnteknir af undrun á öllum þessum afla. En Jesús sagði við Símon: „Vertu óhræddur! Héðan í frá skaltu veiða menn.“ ");
INSERT INTO isl_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Þegar þeir höfðu landað aflanum yfirgáfu þeir allt og fylgdu honum. ");
INSERT INTO isl_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Svo bar við, er Jesús var staddur í einu þorpinu, að hann mætti manni sem þjáðist af holdsveiki. Þegar maðurinn sá Jesú, fleygði hann sér í götuna fyrir framan hann og grátbað hann að lækna sig. „Herra, þú getur læknað mig ef þú vilt,“ sagði hann. ");
INSERT INTO isl_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesús rétti út höndina, snerti manninn og sagði: „Ég vil að þú verðir heilbrigður.“ Um leið hvarf holdsveikin! ");
INSERT INTO isl_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesús bað manninn að segja þetta engum, en fara strax og láta prestinn skoða sig. „Fórnaðu síðan því sem lög Móse fyrirskipa þeim sem læknast af holdsveiki,“ bætti Jesús við, „því það er sönnun þess að þér sé batnað.“ ");
INSERT INTO isl_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Orðrómurinn um mátt Jesú breiddist nú æ hraðar út og mikill mannfjöldi kom til að hlusta á hann og fá bót meina sinna. ");
INSERT INTO isl_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Oft dró hann sig þó út úr á óbyggða staði og var þar á bæn. ");
INSERT INTO isl_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Einn daginn, er hann var að kenna, sátu þar nokkrir af leiðtogum og fræðimönnum þjóðarinnar. (Þeir komu úr hverju þorpi í Galíleu og Júdeu og einnig frá Jerúsalem.) Lækningakraftur frá Guði var með Jesú þegar þetta var. ");
INSERT INTO isl_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Þá komu nokkrir menn og báru á milli sín lamaðan mann á dýnu. Þeir reyndu að olnboga sig í gegnum þvöguna og inn til Jesú, en án árangurs. Þá fóru þeir upp á þakið, losuðu nokkrar þakhellur og létu þann lamaða síga á dýnunni niður til Jesú. ");
INSERT INTO isl_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Þegar Jesús sá trú þeirra sagði hann við lamaða manninn: „Vinur minn, syndir þínar eru fyrirgefnar.“ ");
INSERT INTO isl_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","„Hvað heldur maðurinn að hann sé,“ sögðu farísearnir og lögvitringarnir hvorir við aðra. „Þetta er guðlast! Hver getur fyrirgefið syndir nema Guð?“ ");
INSERT INTO isl_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesús vissi hvað þeir hugsuðu og svaraði: „Hvers vegna kallið þið þetta guðlast? ");
INSERT INTO isl_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Hvort er auðveldara að fyrirgefa syndir hans eða lækna hann? ");
INSERT INTO isl_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nú ætla ég að lækna hann og sanna þar með að ég hef vald til að fyrirgefa syndir.“ Síðan sneri hann sér að lamaða manninum og sagði ákveðinn: „Taktu dýnuna þína og farðu heim, því nú ertu orðinn heilbrigður.“ ");
INSERT INTO isl_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Samstundis spratt maðurinn á fætur í augsýn allra, tók dýnuna sína, gekk heimleiðis og lofaði Guð! ");
INSERT INTO isl_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Fólkið varð óttaslegið, lofaði Guð og sagði hvað eftir annað: „Við höfum séð ótrúlega hluti í dag.“ ");
INSERT INTO isl_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Síðar er Jesús var á leið út úr þessum bæ, sá hann skattheimtumann, Leví að nafni, sitja hjá skattstofunni. Það var á allra vitorði að skattheimtumenn þessir sviku fé út úr fólki. Jesús gekk til Leví og sagði: „Komdu og vertu lærisveinn minn.“ ");
INSERT INTO isl_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Leví stóð þá samstundis upp, yfirgaf allt og fylgdi Jesú. ");
INSERT INTO isl_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Stuttu síðar efndi Leví til veislu og var Jesús heiðursgesturinn. Þarna voru samankomnir margir vinnufélagar Leví, svo og aðrir gestir. ");
INSERT INTO isl_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farísearnir og lögvitringarnir komu þá til lærisveina Jesú og kvörtuðu um að Jesús borðaði með slíkum stórsyndurum. ");
INSERT INTO isl_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús varð fyrir svörum og sagði: „Ekki þurfa heilbrigðir læknis við, heldur þeir sem sjúkir eru. ");
INSERT INTO isl_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ég kom til að kalla syndara burt frá syndinni, en ekki til að eyða tíma með þeim sem þegar telja sig nógu góða.“ ");
INSERT INTO isl_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Það næsta sem þeim fannst þeir þurfa að gera athugasemd við, var að lærisveinarnir væru í veislu í stað þess að fasta. „Lærisveinar Jóhannesar skírara fasta oft og biðja,“ sögðu þeir, „einnig lærisveinar faríseanna, en af hverju eru þínir alltaf étandi og drekkandi?“ ");
INSERT INTO isl_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","„Segið mér eitt, fasta menn þegar þeir halda hátíð?“ sagði Jesús. „Er veislumatnum sleppt í brúðkaupsveislum? ");
INSERT INTO isl_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Sá tími mun hins vegar koma er brúðguminn verður tekinn og líflátinn og þá mun þá ekki langa í mat.“ ");
INSERT INTO isl_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesús sagði þeim dæmisögu: „Enginn rífur pjötlu af nýjum fötum til að bæta gamla flík. Þá eyðileggjast ekki aðeins nýju fötin, heldur lítur gamla flíkin verr út en áður! ");
INSERT INTO isl_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Enginn setur nýtt vín á gamla belgi, því þá sprengir nýja vínið belgina og það fer til spillis og belgirnir eyðileggjast. ");
INSERT INTO isl_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nýtt vín verður að láta á nýja belgi. ");
INSERT INTO isl_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Sá sem drukkið hefur gamalt vín, hefur ekki áhuga á nýju. „Það gamla er ljúffengara segir hann.“ ");
INSERT INTO isl_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Svo bar við á helgidegi að Jesús fór um akur ásamt lærisveinunum og þeir tíndu sér kornöx, neru þau með höndunum og átu. ");
INSERT INTO isl_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","„Þetta er bannað“ sögðu farísearnir. „Lærisveinar þínir eru að uppskera korn og lögum samkvæmt er það bannað á helgidögum.“ ");
INSERT INTO isl_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús svaraði: „Hafið þið aldrei lesið hvað Davíð konungur gerði þegar hann og menn hans hungraði? ");
INSERT INTO isl_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Hann fór inn í Guðs hús, tók skoðunarbrauðin og át, ásamt mönnum sínum, en það var óheimilt.“ ");
INSERT INTO isl_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Og Jesús bætti við: „Ég er herra helgidagsins.“ ");
INSERT INTO isl_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Á öðrum helgidegi var hann að kenna í samkomuhúsinu. Þar var þá staddur fatlaður maður – hægri höndin var máttlaus. ");
INSERT INTO isl_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Farísearnir og fræðimennirnir höfðu gætur á því hvort Jesús læknaði manninn á helgidegi – til þess að þeir gætu fundið eitthvað til að kæra hann fyrir. ");
INSERT INTO isl_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","En Jesús vissi hvað þeir hugsuðu. Hann sagði við fatlaða manninn: „Stattu upp og komdu hingað.“ Maðurinn stóð upp og kom til hans. ");
INSERT INTO isl_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Þá sagði Jesús við faríseana og lögvitringana: „Nú spyr ég ykkur: Hvort er leyfilegt að gera gott eða illt á helgidegi? Bjarga lífi eða deyða?“ ");
INSERT INTO isl_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Hann horfði á þá einn af öðrum og sagði síðan við manninn: „Réttu fram höndina.“ Maðurinn hlýddi og um leið varð hönd hans heilbrigð! ");
INSERT INTO isl_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Óvinir Jesú urðu ævareiðir og töluðu saman um hvað þeir gætu gert honum. ");
INSERT INTO isl_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Um þetta leyti fór Jesús til fjalla til að biðjast fyrir og var alla nóttina á bæn. ");
INSERT INTO isl_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Í dögun kallaði hann saman fylgjendur sína og valdi tólf þeirra til að vera postula sína eða sendiboða. ");
INSERT INTO isl_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Þeir hétu: Símon (Jesús kallaði hann einnig Pétur), Andrés (bróðir Símonar), Jakob, Jóhannes, Filippus, Bartólómeus, Matteus, Tómas, Jakob Alfeusson, Símon (félagi í flokki Selóta, byltingarsinnuðum stjórnmálaflokki), Júdas Jakobsson og Júdas Ískaríot (sem síðar sveik Jesú). ");
INSERT INTO isl_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","Þegar þeir komu aftur niður á sléttlendi, var þar fyrir mikill hópur lærisveina hans og fjöldi fólks úr allri Júdeu, Jerúsalem, og jafnvel norðan frá strandhéruðum Týrusar og Sídonar, til að hlusta á hann og fá lækningu. Þarna rak hann út marga illa anda. ");
INSERT INTO isl_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Allir reyndu að snerta hann, því þegar fólk gerði það, þá streymdi lækningakraftur frá honum, svo það læknaðist. ");
INSERT INTO isl_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesús sneri sér að lærisveinunum og sagði: „Sælir eruð þið, fátækir, því ykkar er guðsríki! ");
INSERT INTO isl_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Sælir eruð þið sem þolið hungur, því þið munuð saddir verða. Sælir eruð þið sem nú grátið, því þið munuð hlæja af gleði! ");
INSERT INTO isl_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Þið eruð sælir þegar menn hata ykkur og útskúfa, smána og baktala mín vegna. ");
INSERT INTO isl_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Fagnið þá og látið gleðilátum! Gleðjist, því laun ykkar verða mikil á himnum. Þannig var einnig farið með spámenn Guðs forðum. ");
INSERT INTO isl_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","En þið sem ríkir eruð – ykkar bíður mikil ógæfa. Gleði ykkar er öll hér á jörðu. ");
INSERT INTO isl_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Þótt þið nú séuð saddir og vegni vel, þá bíður ykkar mikill skortur. Nú hlæið þið kæruleysislega, en þá munuð þið sýta og gráta. ");
INSERT INTO isl_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Einnig bíður mikið böl þeirra, sem nú eiga hylli fjöldans – falsspámenn hafa alla tíð verið vinsælir. ");
INSERT INTO isl_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Takið eftir! Elskið óvini ykkar! Verið þeim góðir sem hata ykkur. ");
INSERT INTO isl_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Blessið þá sem bölva ykkur, og biðjið fyrir þeim sem valda ykkur tjóni. ");
INSERT INTO isl_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Þeim sem slær þig á aðra kinnina, skaltu bjóða hina! Láttu þann sem heimtar yfirhöfn þína fá skyrtuna að auki. ");
INSERT INTO isl_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Gefðu þeim sem biður þig, og sé eitthvað haft af þér, reyndu þá ekki að ná því aftur. ");
INSERT INTO isl_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Komið fram við aðra eins og þið viljið að þeir komi fram við ykkur! ");
INSERT INTO isl_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Haldið þið að þið eigið hrós skilið fyrir að elska þá sem elska ykkur? Nei, það gera einnig guðleysingjarnir. ");
INSERT INTO isl_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Hvað er stórkostlegt við það að vera góður við þá sem eru góðir við þig? Það gerir hvaða syndari sem er! ");
INSERT INTO isl_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Og hvaða góðverk er það að lána þeim einum fé, sem geta endurgreitt? Jafnvel verstu illmenni lána fé – en þau vænta líka fullrar endurgreiðslu! ");
INSERT INTO isl_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nei – elskið óvini ykkar! Gerið þeim gott! Lánið þeim og hafið ekki áhyggjur, þótt þið vitið að þeir muni ekki endurgreiða það. Þá munu laun ykkar verða mikil á himnum og framkoma ykkar sýna að þið eruð synir Guðs, því að hann er góður við vanþakkláta og vonda. ");
INSERT INTO isl_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Verið miskunnsamir eins og faðir ykkar er miskunnsamur. ");
INSERT INTO isl_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Verið ekki dómharðir og sakfellið ekki, þá verðið þið ekki heldur sakfelldir. Verið tillitssamir og þá mun ykkur einnig verða sýnd tillitssemi. ");
INSERT INTO isl_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Gefið og ykkur mun gefið verða! Þið munuð fá ríkulega endurgoldið. Laun ykkar verða mæld með sama mæli og þið mælið öðrum, hvort sem hann er lítill eða stór.“ ");
INSERT INTO isl_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús sagði einnig þessar líkingar í ræðum sínum: „Getur blindur leitt blindan? Nei, því þá falla báðir í sömu gryfjuna! ");
INSERT INTO isl_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ekki er nemandinn meiri en kennarinn, en sé hann iðinn og námfús, verður hann eins og kennarinn. ");
INSERT INTO isl_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Hvers vegna sérðu flís í auga bróður þíns – einhver smá mistök sem hann kann að hafa gert – en tekur ekki eftir plankanum í þínu eigin auga! ");
INSERT INTO isl_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Hvernig geturðu sagt við hann: „Bróðir, leyfðu mér að losa flísina úr auga þér,“ meðan þú sérð varla til vegna plankans í þínu eigin auga? Hræsnari! Fjarlægðu fyrst plankann úr þínu auga og þá sérðu nógu vel til að draga út flísina í auga hans. ");
INSERT INTO isl_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Gott tré ber ekki skemmda ávexti og lélegt tré ber ekki góða ávexti. ");
INSERT INTO isl_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tré þekkist af ávexti sínum. Hvorki tína menn fíkjur af þyrnirunnum né vínber af þistlum. ");
INSERT INTO isl_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Góður maður kemur góðu til leiðar, því hann hefur gott hjartalag, en vondur maður verður til ills, vegna síns spillta hugarfars. Orð þín lýsa innra manni. ");
INSERT INTO isl_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Hvers vegna kallið þið mig „Herra“ en viljið svo ekki hlýða mér? ");
INSERT INTO isl_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Sá sem kemur til mín, heyrir orð mín og breytir eftir þeim, er líkur manni sem byggði hús. Hann gróf djúpt og lagði undirstöðuna á klöpp. Þegar vatnsflóð kom, skall beljandi straumurinn á húsinu, en það haggaðist ekki, því það stóð á traustri undirstöðu. ");
INSERT INTO isl_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","En sá sem heyrir orð mín, og fer ekki eftir þeim, er líkur manni sem byggði hús án undirstöðu. Þegar beljandi flóðið skall á því, hrundi það.“ ");
INSERT INTO isl_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Þegar Jesús hafði lokið við að tala til fólksins, fór hann aftur til Kapernaum. ");
INSERT INTO isl_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Rómverskur höfuðsmaður bjó þar og átti þræl sem var honum mjög kær. Nú lá þrællinn fyrir dauðanum. ");
INSERT INTO isl_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Þegar höfuðsmaðurinn frétti af Jesú, sendi hann nokkra virðulega Gyðinga til hans og bað hann að koma og lækna þrælinn. ");
INSERT INTO isl_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Þeir báðu Jesú innilega að koma og hjálpa manninum og sögðu: „Hann á það skilið að þú hjálpir honum, ");
INSERT INTO isl_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","því hann elskar þjóð okkar og lét meira að segja byggja samkomuhúsið fyrir eigið fé.“ ");
INSERT INTO isl_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","8","Jesús fór með þeim. Rétt áður en þeir komu að húsinu sendi höfuðsmaðurinn vini sína til Jesú með þessi skilaboð: „Herra, vertu ekki að ómaka þig með að koma inn til mín, því ég er hvorki verður þess að hitta þig né hafa þig sem gest. Segðu það aðeins með orði, þar sem þú ert staddur, og þá mun þræll minn læknast. Ég skil þig vel, því sjálfur þarf ég að hlýða æðri herforingjum, en hef síðan vald yfir mínum undirmönnum. Ég þarf aðeins að segja við þá: „Farið“ og þá fara þeir, eða: „Komið“ og þeir koma. Við þræl minn segi ég: „Gerðu þetta“ og hann hlýðir. Segðu því bara: „Læknist þú“ og þá mun þræll minn verða heilbrigður.“ ");
INSERT INTO isl_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesús varð undrandi. Hann sneri sér að mannfjöldanum og sagði: „Aldrei hef ég hitt neinn Gyðing, sem átt hefur jafn mikla trú og þessi útlendingur.“ ");
INSERT INTO isl_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Þegar vinir höfuðsmannsins komu aftur inn í húsið fundu þeir þrælinn alheilbrigðan. ");
INSERT INTO isl_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Stuttu seinna fóru Jesús og lærisveinar hans til þorpsins Nain, og enn fylgdi mannfjöldinn. ");
INSERT INTO isl_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Þegar hann nálgaðist þorpshliðið, kom þar að líkfylgd. Hinn dáni var drengur, einkasonur móður sinnar sem var ekkja. Hópur syrgjandi þorpsbúa var í líkfylgdinni ásamt ekkjunni. ");
INSERT INTO isl_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Þegar Drottinn sá hana, kenndi hann í brjósti um hana og sagði: „Gráttu ekki.“ ");
INSERT INTO isl_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Síðan gekk hann að líkbörunum og snerti þær. Þeir sem báru, námu staðar og Jesús sagði: „Ungi maður, ég segi þér: Rístu upp!“ ");
INSERT INTO isl_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Þá settist drengurinn upp og fór að tala við viðstadda! En Jesús gaf hann aftur móður hans. ");
INSERT INTO isl_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Mikil hræðsla greip um sig og fólkið lofaði Guð og hrópaði: „Voldugur spámaður er kominn fram á meðal okkar. Við höfum sannarlega séð Guð að verki í dag.“ ");
INSERT INTO isl_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Og fréttin flaug um nágrennið og landið allt. ");
INSERT INTO isl_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Lærisveinar Jóhannesar fluttu honum fréttirnar um verk Jesú. ");
INSERT INTO isl_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Þegar hann heyrði þær, sendi hann tvo af lærisveinum sínum til Jesú og lét þá spyrja: „Ert þú Kristur? Eða eigum við að halda áfram að bíða hans?“ ");
INSERT INTO isl_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","22","Þegar lærisveinar þessir komu til Jesú, var hann einmitt að lækna fólk af ýmsum sjúkdómum. Hann læknaði lamaða og blinda, og rak út illa anda. Þegar þeir báru fram spurningu Jóhannesar, svaraði hann: „Farið aftur til Jóhannesar og segið honum hvað þið hafið séð og heyrt hér í dag: Blindir fá sjón, lamaðir ganga óstuddir, holdsveikir hreinsast, heyrnarlausir heyra, dauðir lifna við og fátækir og vonlausir fá að heyra gleðifréttir. ");
INSERT INTO isl_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Að lokum skuluð þið segja honum: Blessaður er sá sem ekki glatar trúnni á mig.“ ");
INSERT INTO isl_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Þegar þeir voru farnir, talaði Jesús við fólkið um Jóhannes og sagði: „Hver er hann, þessi maður, sem þið fóruð að sjá út í Júdeuauðninni? Fannst ykkur hann veikburða líkt og strá sem bærist í golunni? ");
INSERT INTO isl_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Var hann klæddur sem ríkmenni? Nei! Menn, sem lifa munaðarlífi, búa í höllum en ekki í eyðimörkum. ");
INSERT INTO isl_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Hvað funduð þið þá? Spámann? Já, og meira en það! ");
INSERT INTO isl_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Biblían segir um hann: „Sjá, ég sendi boðbera minn á undan þér til að undirbúa komu þína.“ ");
INSERT INTO isl_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jóhannes er mestur allra manna, en samt er hinn minnsti þegn í guðsríki honum meiri.“ ");
INSERT INTO isl_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Allir sem hlustuðu á Jóhannes – jafnvel þeir sem dýpst voru sokknir í synd – beygðu sig að kröfu Guðs og létu skírast. ");
INSERT INTO isl_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","En farísearnir og lögvitringarnir höfnuðu áformi Guðs um þá og vildu ekki láta skírast. ");
INSERT INTO isl_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","„Við hvað á ég að líkja slíkum mönnum?“ spurði Jesús. ");
INSERT INTO isl_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","„Þeir eru eins og börn sem kalla hvert til annars: „Við fórum í brúðkaupsleik en þið vilduð ekki vera með, þá fórum við í jarðarfararleik en þið vilduð samt ekki vera með.“ ");
INSERT INTO isl_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jóhannes fastaði oft og bragðaði aldrei áfengi, en þá sögðu menn: „Hann hlýtur að vera skrýtinn.“ ");
INSERT INTO isl_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","En þegar ég borða og drekk eins og aðrir, þá er sagt: „Þessi Jesús, hann er nú meira átvaglið og hann drekkur meira að segja líka! Og vinir hans, það er ljóta hyskið.“ ");
INSERT INTO isl_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Alltaf finnið þið eitthvað til að afsaka ykkur með.“ ");
INSERT INTO isl_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Einn af faríseunum bauð Jesú til máltíðar heima hjá sér og hann þáði boðið. Þeir voru ný sestir að matnum ");
INSERT INTO isl_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","þegar kona nokkur kom inn utan af götunni. Hún var skækja sem hafði frétt að Jesús væri þarna og kom því með flösku af dýrindis ilmolíu. ");
INSERT INTO isl_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Hún gekk rakleitt til Jesú og kraup grátandi að fótum hans. Tár hennar féllu á fætur hans, en hún þurrkaði þá með hári sínu, kyssti þá og hellti síðan ilmolíu yfir. ");
INSERT INTO isl_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Þegar faríseinn sem boðið hafði Jesú sá þetta, og þekkti konuna, sagði hann við sjálfan sig: „Það er auðséð að Jesús er ekki spámaður, því ef Guð hefði sent hann, hlyti hann að vita hvers konar kona þetta er.“ ");
INSERT INTO isl_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Þá sagði Jesús við faríseann: „Símon, ég þarf að segja þér nokkuð.“ „Jæja, meistari, hvað er það?“ spurði Símon. ");
INSERT INTO isl_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Þá sagði Jesús honum eftirfarandi sögu: „Tveir menn fengu peninga að láni hjá auðmanni. Annar fékk fimm hundruð þúsund krónur, en hinn fimmtíu þúsund. ");
INSERT INTO isl_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","En þegar að gjalddaga kom gat hvorugur greitt. Maðurinn gaf þeim þá báðum eftir skuldina og þeir þurftu ekkert að borga! Hvor þeirra heldur þú að hafi elskað hann meira á eftir?“ ");
INSERT INTO isl_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","„Sá sem skuldaði honum meira, býst ég við,“ svaraði Símon. „Alveg rétt!“ sagði Jesús. ");
INSERT INTO isl_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Síðan sneri hann sér að konunni og sagði: „Símon, sjáðu þessa konu sem krýpur hérna. Þegar ég kom inn, léstu það ógert að koma með vatn og þvo rykið af fótum mínum, en hún þvoði þá með tárum sínum og þurrkaði þá með hárinu. ");
INSERT INTO isl_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ekki heilsaðir þú mér með kossi eins og venja er, en hún hefur kysst fætur mína án afláts frá því ég kom. ");
INSERT INTO isl_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Þú sinntir ekki þeirri almennu kurteisi að smyrja höfuð mitt með ólífuolíu, en hún hellti dýrri ilmolíu yfir fætur mína. ");
INSERT INTO isl_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Því segi ég þér, allar hennar mörgu syndir eru fyrirgefnar – og þess vegna elskar hún mig mikið. En sá sem lítið er fyrirgefið, elskar lítið.“ ");
INSERT INTO isl_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jesús sagði síðan við konuna: „Syndir þínar eru fyrirgefnar.“ ");
INSERT INTO isl_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","„Hvað heldur þessi maður eiginlega að hann sé,“ sögðu gestirnir hver við annan. „Hann gengur um og fyrirgefur syndir.“ ");
INSERT INTO isl_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","En Jesús sagði við konuna: „Trú þín hefur frelsað þig, farðu í friði.“ ");
INSERT INTO isl_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Skömmu síðar fór Jesús borg úr borg og þorp úr þorpi, predikaði og boðaði komu guðsríkisins. ");
INSERT INTO isl_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Með í förinni voru postularnir tólf, og einnig nokkrar konur, sem hann hafði rekið illa anda út af eða læknað. Þeirra á meðal voru María Magdalena (en út af henni hafði Jesús rekið sjö illa anda), ");
INSERT INTO isl_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Jóhanna (kona Kúsa, sem var ráðsmaður Heródesar konungs og hafði umsjón með höll hans og hirð), Súsanna og margar aðrar. Veittu þær Jesú og lærisveinum hans fjárhagslegan stuðning. ");
INSERT INTO isl_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Einu sinni sem oftar hópaðist fólkið að Jesú til að hlusta á hann. Fólkið kom víðs vegar að úr ýmsum bæjum. Þá sagði hann þessa dæmisögu: ");
INSERT INTO isl_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","„Bóndi gekk út á akur sinn til að sá korni. Meðan hann var að sá, féll sumt af útsæðinu á götuslóðann og tróðst niður, en síðan komu fuglar og átu það upp. ");
INSERT INTO isl_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Annað féll þar sem grunnt var á klöpp. Það óx, en skrælnaði fljótlega og dó, því raka vantaði í grunnan jarðveginn. ");
INSERT INTO isl_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Sumt lenti meðal þyrna, sem kæfðu viðkvæma kornstönglana. ");
INSERT INTO isl_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","En annað lenti í frjósömum jarðvegi og óx og gaf af sér hundraðfalda uppskeru. Um leið og Jesús sagði þetta hrópaði hann: „Hver sem hefur eyru til að heyra, hann heyri.“ ");
INSERT INTO isl_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Lærisveinarnir spurðu þá Jesú hvað sagan þýddi. ");
INSERT INTO isl_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Hann svaraði: „Guð hefur ætlað ykkur að skilja þessar líkingar, því þær kenna ykkur margt um guðsríki. Fólk almennt heyrir þær, en skilur ekki, rétt eins og spámennirnir fornu sögðu fyrir. ");
INSERT INTO isl_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Merking sögunnar er þessi: Útsæðið er Guðs orð. ");
INSERT INTO isl_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Hjörtu margra sem heyra Guðs orð eru hörð eins og gatan, þar sem fræið féll. Síðan kemur djöfullinn, tekur burt orðið og kemur í veg fyrir að fólkið trúi og frelsist. ");
INSERT INTO isl_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Grýtti jarðvegurinn táknar þá sem taka við orðinu með fögnuði, en það festir ekki rætur hjá þeim. Þeir trúa um stund, en falla frá trúnni þegar á reynir. ");
INSERT INTO isl_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kornið sem lenti meðal þyrnanna, táknar þá sem hlusta og trúa orðum Guðs. En síðar kafnar trú þeirra í áhyggjum, auðæfum og alls konar lífsgæðakapphlaupi. Það fólk ber engan þroskaðan ávöxt trúarinnar. ");
INSERT INTO isl_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Sæðið sem lenti í frjósama jarðveginum táknar þá sem heyrt hafa orðið, geyma það í göfugu og góðu hjarta, og eru stöðuglyndir, þannig að ávextir trúarinnar sjást í lífi þeirra.“ ");
INSERT INTO isl_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Seinna spurði Jesús: „Hafið þið nokkru sinni heyrt um mann sem kveikti á lampa, en stakk honum síðan undir stól, svo að hann lýsti ekki frá sér? Nei, því að lampar eru settir á góðan stað, svo að birtan dreifist vel. ");
INSERT INTO isl_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Þetta auðveldar okkur að skilja að dag einn mun allt sem mannshugurinn geymir verða dregið fram í dagsljósið og verða öllum augljóst. ");
INSERT INTO isl_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Gætið því vel að því sem þið heyrið. Því að þeim sem hefur, mun verða gefið enn meira, en frá þeim sem ekkert á, mun jafnvel verða tekið það sem hann telur sig eiga.“ ");
INSERT INTO isl_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Eitt sinn, er móðir Jesú og bræður komu og ætluðu að hitta hann, komust þau ekki inn í húsið þar sem hann var að kenna, vegna mannfjöldans. ");
INSERT INTO isl_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Þegar Jesús heyrði að þau væru fyrir utan og vildu finna hann, ");
INSERT INTO isl_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","sagði hann: „Móðir mín og bræður mínir eru þeir sem heyra orð Guðs og fara eftir því.“ ");
INSERT INTO isl_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Dag einn var Jesús með lærisveinum sínum í báti úti á vatni. Lagði hann þá til að þeir færu yfir vatnið og í land hinum megin. ");
INSERT INTO isl_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Á siglingunni sofnaði hann. Þá hvessti skyndilega á vatninu svo að gaf á hjá þeim og voru þeir hætt komnir. ");
INSERT INTO isl_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Þeir þutu til, vöktu hann og hrópuðu: „Herra, við erum að farast!“ Þá hastaði Jesús á storminn og sagði: „Hafðu hægt um þig!“ Jafnskjótt lægði vindinn og öldurnar og gerði blíðalogn. ");
INSERT INTO isl_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Síðan sneri hann sér að lærisveinunum og spurði: „Hvar er trú ykkar?“ Þá fundu þeir til ótta gagnvart honum og sögðu hver við annan: „Hver er hann eiginlega? Bæði vindar og vatn hlýða honum.“ ");
INSERT INTO isl_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Þeir komu að landi í Gerasena, en það er landsvæði við vatnið, gegnt Galíleu. ");
INSERT INTO isl_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Þegar hann var að stíga upp úr bátnum, kom þar að maður frá nálægu þorpi. Maður þessi hafði lengi verið haldinn illum anda. Hann var heimilislaus og klæðlaus og hafðist við í gröfunum. ");
INSERT INTO isl_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Um leið og hann sá Jesú, rak hann upp vein, féll til jarðar og hrópaði: „Hvað viltu mér, Jesús, sonur hins hæsta Guðs? Ég bið þig að kvelja mig ekki.“ ");
INSERT INTO isl_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jesús hafði skipað óhreina andanum að fara út af manninum. Oft hafði þessi maður verið hlekkjaður á höndum og fótum, en þegar illi andinn hafði hann á valdi sínu sleit hann í sundur hlekkina og æddi viti sínu fjær út á eyðimörkina. ");
INSERT INTO isl_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","„Hvað heitir þú?“ spurði Jesús illa andann. „Hersing,“ svaraði hann, því í manninum voru mjög margir illir andar. ");
INSERT INTO isl_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Síðan báðu illu andarnir hann að senda sig ekki í botnlausa hyldýpið. ");
INSERT INTO isl_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Í fjallshlíðinni þar rétt hjá, var svínahjörð á beit. Nú báðu illu andarnir hann að leyfa sér að fara í svínin og leyfði hann það. ");
INSERT INTO isl_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Þeir fóru út af manninum og í svínin. Við það tók öll hjörðin á rás niður brekkuna og æddi fram af hengifluginu út í vatnið og drukknaði. ");
INSERT INTO isl_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Þegar svínahirðarnir sáu þetta, flýðu þeir í dauðans ofboði til næsta bæjar og sögðu fréttir af atburðinum. ");
INSERT INTO isl_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Menn fóru til að sjá með eigin augum hvað gerst hafði. Þeir sáu manninn, sem haft hafði illu andana, sitja við fætur Jesú, klæddan og alheilan! Og þeir urðu hræddir, ");
INSERT INTO isl_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","en hinir sem séð höfðu atburðinn gerast, sögðu frá hvernig maðurinn hafði læknast. ");
INSERT INTO isl_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Fólkið bað Jesú að fara burt og leyfa sér að vera í friði, því mikil skelfing hafði gripið það. Hann steig því aftur í bátinn og fór yfir vatnið. Áður en hann fór, ");
INSERT INTO isl_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","bað maðurinn sem illu andarnir höfðu verið í, hann um að leyfa sér að koma með. ");
INSERT INTO isl_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","„Nei,“ svaraði Jesús, „farðu heldur heim til þín og segðu frá hve mikla hluti Guð hefur gert fyrir þig.“ Og maðurinn fór um alla borgina og sagði hve mikið Jesús hafði gert fyrir hann. ");
INSERT INTO isl_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Hinum megin vatnsins beið mannfjöldinn eftir Jesú og tók honum opnum örmum. ");
INSERT INTO isl_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Þá kom þar að maður, Jaírus að nafni, stjórnandi samkomuhússins. Hann kraup að fótum Jesú og grátbað hann að koma heim með sér. ");
INSERT INTO isl_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Einkadóttir hans, tólf ára gömul, lá fyrir dauðanum. Jesús fór með honum og þeir ruddu sér leið gegnum mannþröngina. ");
INSERT INTO isl_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","44","Á leiðinni gerðist það að kona ein, sem hafði innvortis blæðingar, kom að baki Jesú og snart hann. Hún hafði ekki fengið neina bót á meini sínu fram að þessu, þótt hún hefði eytt nær aleigu sinni í lækna. En jafnskjótt og hún snart faldinn á yfirhöfn Jesú stöðvuðust blæðingarnar. ");
INSERT INTO isl_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","„Hver kom við mig?“ spurði Jesús. Þegar enginn gaf sig fram, sagði Pétur: „Meistari, hér er fullt af fólki sem þrengir að þér á allar hliðar.“ ");
INSERT INTO isl_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","„Nei, einhver snart mig af ásettu ráði, því ég fann lækningakraft streyma út frá mér.“ sagði Jesús. ");
INSERT INTO isl_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Þegar konan sá að Jesús hafði orðið var við þetta, kom hún skjálfandi og kraup við fætur hans. Síðan útskýrði hún hvernig í öllu lá og sagði að nú væri hún orðin heilbrigð. ");
INSERT INTO isl_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","„Dóttir, trú þín hefur læknað þig. Farðu í friði,“ sagði Jesús. ");
INSERT INTO isl_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Meðan hann var að tala við konuna, kom maður heiman frá Jaírusi með þær fréttir að litla stúlkan væri dáin. „Hún er skilin við,“ sagði maðurinn við föður hennar, „það er óþarfi að ónáða meistarann lengur.“ ");
INSERT INTO isl_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Þegar Jesús heyrði þetta, sagði hann við föður stúlkunnar: „Vertu ekki hræddur. Trúðu aðeins, og hún verður heilbrigð.“ ");
INSERT INTO isl_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Þegar Jesús kom að húsinu, leyfði hann engum að fara inn með sér nema Pétri, Jakobi og Jóhannesi, auk foreldra stúlkunnar. ");
INSERT INTO isl_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Inni í húsinu var margt syrgjandi fólk, sem grét hástöfum. „Hættið að gráta!“ sagði Jesús, „hún er ekki dáin heldur sefur hún.“ ");
INSERT INTO isl_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Þá kváðu við háðsglósur frá fólkinu, því allir vissu að stúlkan var dáin. ");
INSERT INTO isl_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","En Jesús tók í hönd stúlkunnar og kallaði: „Stúlka litla, rístu upp!“ ");
INSERT INTO isl_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","56","Á sama andartaki lifnaði hún við og reis upp í rúminu! „Gefðu henni eitthvað að borða,“ sagði Jesús við foreldrana sem voru frá sér numdir af gleði. Hann bað þau að segja engum hvernig þetta hefði gerst. ");
INSERT INTO isl_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Dag nokkurn kallaði Jesús lærisveinana tólf til sín og gaf þeim vald yfir öllum illum öndum – til að reka þá út – og til að lækna sjúkdóma. ");
INSERT INTO isl_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Síðan sendi hann þá af stað til að predika og lækna. ");
INSERT INTO isl_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","„Takið ekkert til ferðarinnar,“ sagði hann, „hvorki staf né mat, fé né föt, ");
INSERT INTO isl_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","og gistið aðeins á einu heimili í hverjum bæ fyrir sig. ");
INSERT INTO isl_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Vilji fólkið í þeim bæ ekki hlusta á ykkur þegar þið komið, þá snúið við og gefið í skyn vanþóknun Guðs með því að dusta rykið af fótum ykkar um leið og þið farið.“ ");
INSERT INTO isl_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Þeir lögðu af stað og ferðuðust um þorpin, fluttu gleðiboðskapinn og læknuðu sjúka. ");
INSERT INTO isl_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Þegar Heródes landstjóri frétti um allt er gerst hafði, varð hann undrandi og kvíðinn, því sumir sögðu: „Jesús er Jóhannes skírari risinn upp frá dauðum.“ ");
INSERT INTO isl_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Aðrir sögðu: „Hann er Elía eða einhver hinna fornu spámanna risinn upp frá dauðum“ og sögurnar gengu um allt. ");
INSERT INTO isl_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","„Ég lét hálshöggva Jóhannes,“ sagði Heródes, „en nú heyri ég þessar einkennilegu sögur! Hver er þessi Jesús eiginlega?“ Og hann leitaði færis að sjá Jesú. ");
INSERT INTO isl_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Þegar postularnir komu aftur til Jesú og sögðu honum hvað þeir höfðu gert, fór hann ásamt þeim, svo lítið bar á, áleiðis til Betsaída. ");
INSERT INTO isl_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","En fólkið komst að því hvert hann ætlaði og elti hann. Hann tók vel á móti því, fræddi það enn frekar um guðsríki og læknaði þá sem sjúkir voru. ");
INSERT INTO isl_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Þegar leið að kvöldi, komu lærisveinarnir tólf til hans og hvöttu hann til að senda fólkið til nálægra þorpa og bóndabæja, svo að það gæti náð sér í mat og húsaskjól fyrir nóttina. „Hér í óbyggðinni er engan mat að fá,“ sögðu þeir. ");
INSERT INTO isl_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","„Gefið þið því að borða,“ sagði Jesús. „Ha, við?“ andmæltu þeir, „við höfum aðeins fimm brauð og tvo fiska og það er ekkert handa öllu þessu fólki. Viltu að við förum og kaupum mat handa öllum hópnum?“ ");
INSERT INTO isl_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Karlmennirnir einir vora um fimm þúsund! „Segið þeim að setjast niður í fimmtíu manna hópum,“ svaraði Jesús, ");
INSERT INTO isl_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","og það var gert. ");
INSERT INTO isl_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesús tók þá brauðin fimm og fiskana, leit upp til himins og þakkaði. Síðan braut hann brauðin í smástykki og rétti lærisveinunum, en þeir báru matinn til fólksins. ");
INSERT INTO isl_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Fólkið borðaði vel, en þrátt fyrir það fylltu þeir tólf körfur með brauðmolum að máltíðinni lokinni! ");
INSERT INTO isl_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Eitt sinn þegar Jesús hafði verið einn á bæn, kom hann til lærisveinanna, sem sátu þar skammt frá og spurði: „Hvern segir fólk mig vera?“ ");
INSERT INTO isl_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Þeir svöruðu: „Jóhannes skírara eða Elía, og sumir halda að þú sért einhver hinna fornu spámanna, risinn upp frá dauðum.“ ");
INSERT INTO isl_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","„En þið?“ spurði hann, „hvern segið þið mig vera?“ Pétur varð fyrir svörum og sagði: „Þú ert Kristur, sonur Guðs.“ ");
INSERT INTO isl_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesús lagði ríkt á við þá að hafa ekki orð á þessu við neinn, ");
INSERT INTO isl_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","„því ég, Kristur,“ sagði hann, „verð að þjást mikið. Leiðtogar þjóðar okkar – öldungarnir, æðstu prestarnir og lögvitringarnir – munu hafna mér og taka mig af lífi, en ég mun rísa upp á þriðja degi.“ ");
INSERT INTO isl_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Síðan bætti hann við: „Sá sem vill fylgja mér, verður fúslega að leggja til hliðar eigin þrár og þægindi og dag hvern, þola háð og niðurlægingu, og fylgja mér fast eftir. ");
INSERT INTO isl_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Hver sem fórnar lífi sínu mín vegna, mun bjarga því, en sá sem vill halda því fyrir sjálfan sig, mun glata því. ");
INSERT INTO isl_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Hvaða ávinningur er í því að eignast allan heiminn, ef maður glatar sálu sinni? ");
INSERT INTO isl_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Þegar ég, Kristur, kem í dýrð minni og dýrð föður míns og heilagra engla, mun ég blygðast mín fyrir hvern þann sem blygðast sín fyrir mig og mín orð. ");
INSERT INTO isl_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ég segi ykkur sannleikann: Sumir ykkar, sem hér standa, munu ekki deyja fyrr en þeir hafa séð guðsríki.“ ");
INSERT INTO isl_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Viku síðar tók Jesús þá Pétur, Jakob og Jóhannes með sér og fór upp á fjallið til að biðjast fyrir. ");
INSERT INTO isl_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Meðan hann var að biðja, lýsti andlit hans og föt hans urðu ljómandi hvít. ");
INSERT INTO isl_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Þá birtust allt í einu tveir menn, sem fóru að tala við hann, það voru Móse og Elía. ");
INSERT INTO isl_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Þeir ljómuðu og töluðu við hann um að samkvæmt fyrirætlun Guðs ætti hann að deyja í Jerúsalem. ");
INSERT INTO isl_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Svefn hafði sótt á Pétur og félaga hans. En nú vöknuðu þeir og sáu ljómann sem stóð af Jesú, og mennina tvo standa hjá honum. ");
INSERT INTO isl_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Þegar Móse og Elía voru að skilja við hann, hrökk út úr Pétri, sem var svo ringlaður að hann vissi varla hvað hann sagði: „Meistari, við skulum vera hérna lengur! Við getum reist hér þrjú skýli – eitt handa þér, annað handa Móse og það þriðja handa Elía.“ ");
INSERT INTO isl_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Meðan Pétur sagði þetta myndaðist ský í kringum þá og þeir urðu mjög hræddir. ");
INSERT INTO isl_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Þá kom rödd úr skýinu, sem sagði: „Þessi er minn útvaldi sonur, hlustið á hann.“ ");
INSERT INTO isl_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Þegar röddin hljóðnaði, var Jesús einn eftir með lærisveinum sínum. Lærisveinarnir sögðu engum frá því sem þeir höfðu séð á fjallinu, fyrr en löngu síðar. ");
INSERT INTO isl_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Daginn eftir, er Jesús kom niður af fjallinu ásamt lærisveinunum þremur, mætti þeim mikill mannfjöldi. ");
INSERT INTO isl_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Maður einn í hópnum hrópaði þá til hans og sagði: „Meistari, viltu líta á drenginn minn, hann er einkasonur minn. ");
INSERT INTO isl_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Illur andi er sífellt að ná tökum á honum, svo að hann æpir, fær krampa og froðufellir. Hann lætur hann eiginlega aldrei í friði og er alveg að gera út af við hann. ");
INSERT INTO isl_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ég bað lærisveina þína að reka andann út, en þeir gátu það ekki.“ ");
INSERT INTO isl_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","„Æ, hvað þið eigið erfitt með að trúa,“ sagði Jesús (við lærisveinana), „hversu lengi þarf ég að umbera ykkur? Komið hingað með drenginn.“ ");
INSERT INTO isl_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Meðan drengurinn var á leiðinni til Jesú, fleygði illi andinn honum til jarðar og hann fékk hræðilegt krampakast. Þá skipaði Jesús andanum að fara, hann læknaði drenginn og afhenti föður hans hann. ");
INSERT INTO isl_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Allir urðu forviða á mætti Guðs. En á meðan fólkið var að undrast verk Jesú, sneri hann sér að lærisveinunum og sagði: ");
INSERT INTO isl_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","„Festið vel í minni það sem ég segi nú: Ég, Kristur, mun verða svikinn.“ ");
INSERT INTO isl_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","En þeir skildu ekki við hvað hann átti, þetta var þeim hulið og þeir þorðu ekki að spyrja hann út í þetta. ");
INSERT INTO isl_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nú fóru lærisveinarnir að deila um hver þeirra yrði mestur (í hinu komandi ríki Guðs). ");
INSERT INTO isl_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Þá tók Jesús lítið barn, setti það hjá sér ");
INSERT INTO isl_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","og sagði við þá: „Hver sá sem tekur á móti þessu barni í mínu nafni, tekur á móti mér. Og sá sem tekur á móti mér, tekur á móti Guði, sem sendi mig. Sá ykkar sem fúsastur er að þjóna öðrum, hann er mikill.“ ");
INSERT INTO isl_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jóhannes lærisveinn hans kom til hans og sagði: „Meistari, við sáum mann sem notaði nafn þitt til að reka út illa anda og við bönnuðum honum það, því hann er ekki einn af okkur.“ ");
INSERT INTO isl_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","„Það hefðuð þið ekki átt að gera,“ sagði Jesús, „því að hver sem ekki er andstæðingur ykkar, er vinur ykkar.“ ");
INSERT INTO isl_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nú leið að því að Jesús skyldi fara til himna og því ákvað hann að halda beina leið til Jerúsalem. ");
INSERT INTO isl_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Dag nokkurn sendi hann menn á undan sér til bæjar í Samaríu til að útvega honum gistingu þar. ");
INSERT INTO isl_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","En þorpsbúar ráku sendiboðana til baka! Þeir vildu ekkert með þá hafa, vegna þess að þeir voru á leið til Jerúsalem. ");
INSERT INTO isl_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Þegar Jesús og lærisveinar hans fengu fréttirnar, sögðu Jakob og Jóhannes við Jesú: „Meistari, eigum við að gefa skipun um að eldur falli af himnum og eyði þeim?“ ");
INSERT INTO isl_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","En Jesús ávítaði þá og sagði: „Þið vitið ekki hver fékk ykkur til að segja þetta! Ég, Kristur, kom ekki til að eyða mannslífum, heldur til að bjarga þeim.“ ");
INSERT INTO isl_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Þeir fóru síðan í annað þorp. ");
INSERT INTO isl_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Á leiðinni sagði maður nokkur við Jesú: „Ég vil fylgja þér hvert sem þú ferð.“ ");
INSERT INTO isl_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús svaraði: „Refir eiga greni og fuglarnir hreiður en ég, Kristur, á engan samastað.“ ");
INSERT INTO isl_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Við annan mann sagði Jesús: „Fylg þú mér!“ Maðurinn tók því vel og sagði: „Leyfðu mér samt að annast útför föður míns fyrst.“ ");
INSERT INTO isl_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Þessu svaraði Jesús: „Láttu þá sem ekki eiga eilíft líf um það, en far þú og boða guðsríki.“ ");
INSERT INTO isl_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Enn annar sagði: „Drottinn, ég vil fylgja þér, en leyfðu mér samt fyrst að kveðja þá sem heima eru.“ ");
INSERT INTO isl_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","„Sá sem lætur leiða sig burt frá því verki, sem ég ætlaði honum,“ svaraði Jesús, „er ekki hæfur í guðsríki.“ ");
INSERT INTO isl_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Drottinn valdi nú aðra sjötíu lærisveina og sendi þá tvo og tvo saman til þorpanna, sem hann ætlaði síðar að heimsækja. ");
INSERT INTO isl_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Hann sagði: „Uppskeran er mikil, en verkamennirnir fáir, biðjið því uppskerustjórann að senda fleiri verkamenn til uppskeru sinnar. ");
INSERT INTO isl_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Farið nú og munið að ég sendi ykkur eins og lömb í úlfahóp. ");
INSERT INTO isl_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Takið hvorki peninga með ykkur né nesti og heldur ekki skó til skiptanna, og munið svo að slóra ekki á leiðinni. ");
INSERT INTO isl_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Blessið hvert það heimili sem þið komið á. ");
INSERT INTO isl_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Sé það blessunarvert, mun blessunin koma yfir það, annars mun hún snúa aftur til ykkar. ");
INSERT INTO isl_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Þegar þið komið inn í þorp, gistið þá ekki á mörgum heimilum, dveljið heldur á sama stað. Borðið og drekkið það sem fyrir ykkur er sett. Verið ófeimnir við að njóta góðgerðanna, því að verður er verkamaður launa sinna. ");
INSERT INTO isl_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","9","Taki þorpsbúar ykkur vel, farið þá eftir þessum tveimur reglum: Borðið það sem fyrir ykkur er sett og læknið þá sem sjúkir eru og segið um leið: „Nú standið þið nálægt guðsríkinu.“ ");
INSERT INTO isl_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ef þið komið í þorp sem ekki vill taka við ykkur, farið þá út á göturnar og segið: ");
INSERT INTO isl_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","„Við þurrkum rykið, úr þorpi ykkar, af fótum okkar sem tákn um dóminn, sem yfir ykkur vofir. En vitið samt að guðsríki er í nánd.“ ");
INSERT INTO isl_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Jafnvel Sódóma, borg spillingarinnar, mun fá skárri útreið á dómsdegi en það þorp! ");
INSERT INTO isl_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Þið Kórasín og Betsaída, miklar eru þrengingarnar sem ykkar bíða! Ef kraftaverkin, sem ég gerði í ykkur, hefðu gerst í Týrus og Sídon, þá hefðu íbúar þeirra borga gert iðrun fyrir löngu. Þeir hefðu klæðst tötrum og ausið sig ösku sem tákn um iðrun sína. ");
INSERT INTO isl_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Týrus og Sídon munu hljóta vægari hegningu á dómsdegi en þið. ");
INSERT INTO isl_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Og hvað um ykkur, íbúar Kapernaum? Verðið þið hafnir til himins? Nei, ykkur verður varpað niður til heljar.“ ");
INSERT INTO isl_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Síðan sagði Jesús við lærisveina sína: „Þeir sem taka á móti ykkur, taka á móti mér, en þeir sem hafna ykkur, hafna mér. Þeir sem hafna mér, hafna Guði sjálfum sem sendi mig.“ ");
INSERT INTO isl_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Lærisveinarnir sjötíu komu aftur og sögðu sigri hrósandi: „Jafnvel illu andarnir hlýða okkur, þegar við notum nafn þitt.“ ");
INSERT INTO isl_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","„Já,“ sagði hann, „ég sá Satan falla af himni eins og eldingu! ");
INSERT INTO isl_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ég hef gefið ykkur vald yfir öllu óvinarins veldi. Þið getið stigið ofan á höggorma og sporðdreka og marið þá undir fótum ykkar – ekkert mun geta gert ykkur mein. ");
INSERT INTO isl_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","En gleðjist samt ekki yfir því að andarnir hlýða ykkur, heldur því að nöfn ykkar eru innrituð á himnum.“ ");
INSERT INTO isl_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Um leið varð hann glaður í heilögum anda og sagði: „Ég lofa þig faðir, herra himins og jarðar. Að það sem hulið var fyrir spekingum og vitringum veraldar, hefur þú birt þeim sem treysta þér og trúa eins og lítil börn. Já, faðir, þannig vildir þú hafa það. ");
INSERT INTO isl_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Faðir minn hefur lagt allt í mínar hendur. Soninn þekkir enginn nema faðirinn og föðurinn þekkir enginn nema sonurinn, og þeir sem sonurinn vill að sjái hann.“ ");
INSERT INTO isl_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Síðan sneri hann sér að lærisveinunum og sagði lágt: „Þið eigið gott að hafa fengið að sjá það sem þið sjáið. ");
INSERT INTO isl_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Margir spámenn og konungar fyrri alda þráðu að sjá og heyra það sem þið hafið séð og heyrt.“ ");
INSERT INTO isl_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Dag nokkurn kom fræðimaður í lögum Móse til Jesú og vildi prófa rétttrúnað hans. „Meistari,“ sagði hann, „hvað þarf maður að gera til að eignast eilíft líf?“ ");
INSERT INTO isl_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","„Hvað segja lög Móse um það?“ svaraði Jesús. ");
INSERT INTO isl_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","„Þar stendur: Þú skalt elska Drottin Guð þinn af öllu hjarta þínu, allri sálu þinni, öllum mætti þínum og af öllum huga þínum, og meðbróður þinn eins og sjálfan þig,“ sagði fræðimaðurinn. ");
INSERT INTO isl_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","„Rétt,“ svaraði Jesús, „gerðu þetta og þá muntu lifa.“ ");
INSERT INTO isl_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","En maðurinn vildi afsaka sig og spurði því: „Hver er þá meðbróðir minn?“ ");
INSERT INTO isl_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesús svaraði með þessari sögu: „Maður var á leið frá Jerúsalem til Jeríkó og lenti í höndum ræningja. Þeir rændu fötum hans og peningum, og börðu hann. Síðan skildu þeir hann eftir hálfdauðan við vegarbrúnina. ");
INSERT INTO isl_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Af tilviljun fór prestur þarna um. Þegar hann sá manninn, leit hann undan og hélt áfram. ");
INSERT INTO isl_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Skömmu síðar kom musterisþjónn þar að og er hann sá hinn slasaða, flýtti hann sér fram hjá. ");
INSERT INTO isl_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Síðan kom þar að lítilsmetinn útlendingur – Samverji. Hann sá manninn og kenndi í brjósti um hann. ");
INSERT INTO isl_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Hann gekk til hans, hreinsaði sárin og batt um þau. Að því loknu setti hann særða manninn upp á asnann sinn og studdi hann að næsta gistihúsi, þar sem hann veitti honum aðhlynningu um nóttina. ");
INSERT INTO isl_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Morguninn eftir rétti hann gestgjafanum ríflega upphæð og bað hann að annast manninn. „Ef reikningurinn verður hærri,“ sagði hann, „þá borga ég mismuninn næst þegar ég kem.“ ");
INSERT INTO isl_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Hver finnst þér nú hafa verið sannur meðbróðir mannsins sem lenti í höndum ræningjanna?“ ");
INSERT INTO isl_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","„Sá sem hjálpaði honum,“ svaraði maðurinn. „Já,“ sagði Jesús, „farðu og gerðu slíkt hið sama.“ ");
INSERT INTO isl_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Á leið sinni til Jerúsalem, komu Jesús og lærisveinar hans við hjá konu sem Marta hét. Tók hún vel á móti þeim. ");
INSERT INTO isl_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","María systir hennar sat á gólfinu og hlustaði á Jesú, ");
INSERT INTO isl_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","en Marta var önnum kafin við matreiðslu. Hún gekk þá til Jesú og sagði: „Herra, finnst þér ekki ranglátt af systur minni að sitja hér, en láta mig eina um alla vinnuna? Segðu henni að koma og hjálpa mér.“ ");
INSERT INTO isl_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","„Marta mín,“ sagði Drottinn við hana, „Þú ert önnum kafin og áhyggjufull! ");
INSERT INTO isl_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Eitt er nauðsynlegt og það hefur María komið auga á, ég mun ekki taka það frá henni.“ ");
INSERT INTO isl_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Eitt sinn er Jesús hafði verið í einrúmi á bæn, kom einn lærisveinanna til hans og sagði: „Drottinn, kenndu okkur að biðja eins og Jóhannes kenndi sínum lærisveinum. ");
INSERT INTO isl_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Þá kenndi hann þeim þessa bæn: „Faðir, helgist þitt nafn, komi þitt ríki. ");
INSERT INTO isl_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Gefðu okkur það sem við þörfnumst frá degi til dags. ");
INSERT INTO isl_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Fyrirgefðu okkur syndir okkar, eins og við fyrirgefum þeim sem syndga gegn okkur, og lát okkur ekki verða fyrir freistingu.“ ");
INSERT INTO isl_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Hann hélt áfram að fræða þá um bænina og sagði: „Gerum ráð fyrir að einhver ykkar fari til vinar síns um miðja nótt, veki hann og segi: „Lánaðu mér þrjú brauð, því að vinur minn var að koma í heimsókn og ég á ekki nokkurn matarbita handa honum.“ ");
INSERT INTO isl_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Þá mundi hinn kalla á móti úr rúminu: „Æ, vertu nú ekki að ónáða mig. Það er búið að læsa húsinu og allir eru löngu háttaðir. Ég nenni ekki að fara á fætur um miðja nótt vegna þessara smámuna.“ ");
INSERT INTO isl_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ég segi: Ef haldið er áfram að nauða nógu lengi, þá fer hann að lokum fram úr og lánar vini sínum allt sem hann þarf; ekki af greiðasemi, heldur vegna þess að hinn gefst ekki upp. ");
INSERT INTO isl_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Þannig er það með bænina. Biðjið og þið munuð öðlast. Leitið og þið munuð finna. Knýið á og þá mun verða lokið upp. ");
INSERT INTO isl_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Hver sá sem biður, mun öðlast, sá finnur er leitar og fyrir þeim mun opnað, sem á knýr. ");
INSERT INTO isl_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Þið feður, gefið þið drengnum ykkar stein ef hann biður um fisk? ");
INSERT INTO isl_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Og biðji hann um egg, gefið þið honum þá sporðdreka? Nei, auðvitað ekki! ");
INSERT INTO isl_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Fyrst þið syndugir menn gefið börnum ykkar góðar gjafir, þá er víst að faðirinn á himnum gefur þeim heilagan anda sem biðja um hann.“ ");
INSERT INTO isl_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesús rak illan anda út af mállausum manni og fékk hann þá málið. Mannfjöldinn varð undrandi, ");
INSERT INTO isl_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","en sumir sögðu: „Það er ekkert skrýtið þótt hann geti rekið út illa anda, því hann fær kraft sinn frá Satan, konungi illu andanna.“ ");
INSERT INTO isl_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Aðrir báðu hann um tákn á himni, til að sanna að hann væri Kristur. ");
INSERT INTO isl_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesús vissi hvað þeir hugsuðu og sagði: „Það ríki sem logar í borgarastyrjöld fær ekki staðist, og sama er að segja um heimili þar sem hver höndin er upp á móti annarri. ");
INSERT INTO isl_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Sé það satt sem þið segið að Satan berjist gegn sjálfum sér, með því að gefa mér vald til að reka út hans eigin illu anda, hvernig fær þá ríki hans staðist? ");
INSERT INTO isl_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Og hvað um fylgjendur ykkar, ef ég starfa í krafti Satans? Þeir reka út illa anda! Er það þá sönnun þess að Satan sé í þeim? Spyrjið þessa menn hvort þið hafið á réttu að standa! ");
INSERT INTO isl_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","En ef ég rek út illa anda með krafti Guðs, þá er það staðfesting þess að guðsríki sé komið. ");
INSERT INTO isl_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Þegar sterkur maður ver hús sitt alvopnaður, þá er það ekki í hættu ");
INSERT INTO isl_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","– ekki fyrr en einhver sterkari gerir árás, yfirbugar hann og afvopnar, og tekur eigur hans. ");
INSERT INTO isl_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Sá sem ekki er með mér, er á móti mér. Sá sem ekki vinnur mér gagn, veldur mér tjóni. ");
INSERT INTO isl_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Þegar illur andi er rekinn út úr manni, fer hann út í eyðimörkina og leitar þar hvíldar. Finni hann enga hvíld, leitar hann að manninum sem hann var í ");
INSERT INTO isl_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","og finnur hann opinn og andvaralausan. ");
INSERT INTO isl_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Þá fer hann og sækir sjö aðra anda ennþá verri og þeir fara allir í manninn, sem verður því mun verr settur en áður.“ ");
INSERT INTO isl_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Meðan Jesús var að tala, hrópaði kona ein í mannfjöldanum: „Guð blessi móður þína, sem bar þig og nærði.“ ");
INSERT INTO isl_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","„Já,“ svaraði hann, „en enn meiri blessun hljóta þeir sem heyra orð Guðs og fara eftir því.“ ");
INSERT INTO isl_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","30","Fólkið hélt áfram að streyma að honum og þá sagði hann því þessa líkingu. „Við lifum á vondum tímum og fólkið er vont. Það biður stöðugt um tákn á himnum (til sönnunar því að ég sé Kristur) en eina táknið sem það fær er Jónasartáknið. Fólkið í Niníve áleit reynslu Jónasar sönnun þess að Guð hefði sent hann. Á sama hátt verður það sem gerist með mig, tákn þess að Guð hafi sent mig til ykkar. ");
INSERT INTO isl_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Drottningin af Saba mun rísa upp á dómsdegi, benda á þessa kynslóð og dæma hana seka. Hún lagði á sig langt og erfitt ferðalag til að hlusta á visku Salómons og hér er sá sem er æðri Salómon. ");
INSERT INTO isl_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Íbúar Niníve munu einnig rísa upp og fordæma þessa þjóð, því þeir gerðu iðrun við predikun Jónasar, og þótt hér sé sá sem er miklu æðri Jónasi, vill þessi þjóð ekki hlusta. ");
INSERT INTO isl_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Hver kveikir á lampa og felur hann síðan niðri í kjallara? Enginn! Lampinn er settur á lampastæðið, svo að hann lýsi öllum sem inn koma. ");
INSERT INTO isl_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Augu þín lýsa upp þinn innri mann. Sé auga þitt heilbrigt, þá hleypir það birtu inn í sál þína. Auga sem brennur af fýsn, lokar ljósið úti og steypir þér í myrkur. ");
INSERT INTO isl_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Gættu þess að ljósið sé ekki lokað úti. ");
INSERT INTO isl_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ef þinn innri maður er baðaður ljósi og hvergi ber skugga á, þá ljómar andlit þitt.“ ");
INSERT INTO isl_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","38","Þegar Jesús hafði lokið máli sínu, bauð einn af faríseunum honum heim til sín í mat. Þegar Jesús var kominn inn til hans, settist hann strax að matnum, án þess að þvo sér fyrst eins og venja var hjá Gyðingum. Faríseinn varð undrandi. ");
INSERT INTO isl_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jesús sagði þá við hann: „Þið farísear þvoið það sem út snýr, en að innan eruð þið enn óhreinir – fullir illsku og girndar! ");
INSERT INTO isl_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Þið farið heimskulega að ráði ykkar! Var hið innra ekki eins vel af Guði gert og hið ytra eða hvað? ");
INSERT INTO isl_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Göfuglyndi er besta sönnun þess að inni fyrir búi hreint hugarfar. ");
INSERT INTO isl_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ég ávíta ykkur, farísear! Þið gætið þess að gjalda tíund og það jafnvel af hverju smáatriði, en gleymið svo öllu réttlæti og kærleika til Guðs. Það er rétt að gjalda tíund en hitt skuluð þið ekki vanrækja. ");
INSERT INTO isl_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Vei ykkur, farísear! Þið sækist eftir heiðurssætum í samkomuhúsum og virðingu fólksins á götunum. ");
INSERT INTO isl_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ykkar bíður hræðilegur dómur. Þið eruð eins og grónar grafir sem fólk gengur yfir, grunlaust um alla rotnunina fyrir neðan. ");
INSERT INTO isl_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","„Herra,“ sagði lögfræðingur sem sat rétt hjá honum, „þú lítilsvirðir einnig starf mitt með þessum orðum.“ ");
INSERT INTO isl_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","„Já,“ sagði Jesús, „ekki eruð þið betri! Þið leggið óbærilegar byrðar á fólk með trúar- og siðferðiskröfum ykkar – kröfum sem ykkur sjálfum dytti aldrei í hug að hlýða. ");
INSERT INTO isl_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Vei ykkur! Þið eruð ekki betri en forfeður ykkar, sem drápu spámennina. ");
INSERT INTO isl_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Þið leggið blessun yfir verk forfeðra ykkar með því að prýða legstaði spámannanna, sem þeir myrtu. ");
INSERT INTO isl_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Guð segir um ykkur: „Ég mun senda til ykkar spámenn og postula, suma þeirra munuð þið drepa en ofsækja hina.“ ");
INSERT INTO isl_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Þið sem nú lifið, berið ábyrgðina á morðunum sem framin hafa verið á þjónum Guðs frá upphafi. ");
INSERT INTO isl_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Frá morðinu á Abel til morðsins á Sakaría, sem drepinn var milli altarisins og musterisins. Já, ákærunni verður áreiðanlega beint gegn ykkur. ");
INSERT INTO isl_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Vei ykkur, lögvitringar! Þið felið sannleikann fyrir fólkinu. Sjálfir viljið þið ekki beygja ykkur fyrir honum og síðan hindrið þið aðra í að treysta Guði.“ ");
INSERT INTO isl_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Þegar Jesús hafði lokið máli sínu gekk hann út, en eftir stóðu farísearnir og lögvitringarnir, æfir af reiði. Upp frá þessu voru þeir sífellt að leggja fyrir hann spurningar í þeim tilgangi að fá hann til að segja eitthvað, sem hægt væri að handtaka hann fyrir. ");
INSERT INTO isl_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Fólk flykktist nú að honum tugþúsundum saman, svo að hver tróð annan undir. Þá tók hann að tala við lærisveinana og sagði: „Varið ykkur á faríseunum. Þeir þykjast vera góðir, en svo er ekki. Slíka hræsni er þó ekki hægt að dylja mjög lengi. ");
INSERT INTO isl_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Hún verður eins augljós og gerið í deiginu. ");
INSERT INTO isl_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Allt sem sagt er í myrkrinu, heyrist í birtunni, og það sem þið hafið pískrað í skúmaskotum, verður hrópað af húsþökum svo allir heyri! ");
INSERT INTO isl_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Vinir mínir, verið ekki hræddir við þá sem geta deytt líkamann, þeir geta ekki meira og hafa ekkert vald yfir sálinni. ");
INSERT INTO isl_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ég skal segja ykkur hvern þið eigið að óttast – það er Guð. Hann hefur vald til að taka líf ykkar og kasta ykkur í helvíti. ");
INSERT INTO isl_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Hvað kosta fimm spörfuglar? Varla meira en tvo smápeninga? Samt gleymir Guð engum þeirra. ");
INSERT INTO isl_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hann veit líka hve mörg hár eru á höfði ykkar! Verið ekki kvíðafullir, því að þið eruð miklu meira virði í hans augum en margir spörvar. ");
INSERT INTO isl_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ég segi ykkur: Hvern þann sem játar trú á mig frammi fyrir mönnunum, mun ég, Kristur, viðurkenna frammi fyrir englum Guðs. ");
INSERT INTO isl_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","En þeim sem afneitar mér frammi fyrir mönnunum, mun verða afneitað frammi fyrir englum Guðs. ");
INSERT INTO isl_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Þeir sem lastmæla mér geta þó fengið fyrirgefningu, en þeim sem lastmæla heilögum anda mun aldrei verða fyrirgefið. ");
INSERT INTO isl_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Þegar þið verðið að svara til saka frammi fyrir leiðtogum þjóðarinnar og forstöðumönnum samkomuhúsanna, verið þá ekki áhyggjufullir yfir því hvað þið eigið að segja til varnar. ");
INSERT INTO isl_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Því að heilagur andi mun gefa ykkur rétt orð á réttum tíma.“ ");
INSERT INTO isl_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Þá kallaði einhver úr mannþrönginni: „Herra, segðu bróður mínum að skipta með okkur föðurarfi okkar.“ ");
INSERT INTO isl_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","„Heyrðu vinur,“ svaraði Jesús, „hver setti mig dómara og skiptaráðanda yfir ykkur? ");
INSERT INTO isl_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Gætið ykkar! Sækist ekki stöðugt eftir því sem þið eigið ekki. Lífið er ekki tryggt með eignunum, jafnvel þótt miklar séu.“ ");
INSERT INTO isl_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Síðan sagði hann þeim dæmisögu: „Ríkur maður átti gott bú og fékk mikla uppskeru. ");
INSERT INTO isl_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Hlöðurnar voru yfirfullar, svo að hann kom ekki öllu fyrir. Hann hugsaði málið. ");
INSERT INTO isl_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","„Nú veit ég hvað ég geri,“ sagði hann við sjálfan sig. „Ég ríf þessar hlöður og byggi aðrar stærri og þá verður nóg pláss! ");
INSERT INTO isl_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Eftir það fer ég mér hægt og segi við sjálfan mig: Jæja vinur, nú áttu birgðir til margra ára. Nú skaltu hvílast og njóta lífsins svo um munar.“ ");
INSERT INTO isl_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","En Guð sagði við hann: „Heimskingi! Í nótt muntu deyja og hver fær þá allt sem þú hefur eignast?“ ");
INSERT INTO isl_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Þannig fer fyrir þeim sem safnar auðæfum, en er ekki ríkur hjá Guði.“ ");
INSERT INTO isl_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesús sagði við lærisveina sína: „Hafið ekki áhyggjur af því hvort þið hafið nóg að borða eða föt til að vera í. ");
INSERT INTO isl_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Lífið er miklu meira en föt og fæði. ");
INSERT INTO isl_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Sjáið hrafnana. Þeir sá hvorki né uppskera og ekki hafa þeir forðabúr né hlöður, en samt komast þeir af, því að Guð fæðir þá. Þið eruð miklu dýrmætari en fuglarnir í augum Guðs! ");
INSERT INTO isl_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Hvaða vit er í áhyggjum? Gera þær eitthvert gagn? Geta þær lengt líf þitt um einn dag? Nei, sannarlega ekki! ");
INSERT INTO isl_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Til hvers er þá að hafa áhyggjur, fyrst þær geta ekki komið slíkum smámunum til leiðar? ");
INSERT INTO isl_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Lítið á liljurnar! Þær hvorki vinna né spinna, en samt komst Salómon í öllum sínum skrúða ekki í samjöfnuð við þær. ");
INSERT INTO isl_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Þið efasemdamenn! Hvers vegna haldið þið að Guð muni ekki sjá ykkur fyrir fötum, hann sem skrýðir blómin, sem standa í dag, en falla á morgun? ");
INSERT INTO isl_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Verið ekki heldur kvíðnir vegna matar, hvað þið eigið að borða eða drekka. Nei, hafið ekki áhyggjur af því, ");
INSERT INTO isl_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","það gera hinir guðlausu, en faðirinn á himnum veit hvers þið þurfið með. ");
INSERT INTO isl_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ef þið leitið vilja Guðs með líf ykkar framar öllu öðru, þá annast hann þarfir ykkar frá degi til dags. ");
INSERT INTO isl_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Vertu ekki hrædd, litla hjörð, því faðirinn hefur gefið ykkur ríki sitt. ");
INSERT INTO isl_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Seljið eigur ykkar og gefið þeim sem þurfandi eru og þá munuð þið eignast ótæmandi fjársjóð á himnum! Slíkur fjársjóður mun aldrei rýma né skemmast, því þar eru hvorki þjófar né verðbólga. ");
INSERT INTO isl_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Þar sem fjársjóður þinn er, þar mun og hugur þinn vera. ");
INSERT INTO isl_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Verið viðbúin, alklædd og reiðubúin til starfa, ");
INSERT INTO isl_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","því að húsbóndi ykkar er væntanlegur úr brúðkaupinu. Verið viðbúin að opna dyrnar og hleypa honum inn um leið og hann ber að dyrum. ");
INSERT INTO isl_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Þeir sem eru viðbúnir og bíða komu hans hafa ástæðu til að hlakka til. Hann mun sjálfur leiða þá til sætis og meira að segja þjóna þeim til borðs, en þeir fá að njóta matarins í næði. ");
INSERT INTO isl_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ef til vill kemur hann klukkan níu að kvöldi, eða þá á miðnætti. En hvort sem hann kemur þá eða síðar verður mikil gleði hjá þeim þjónum, sem viðbúnir verða. ");
INSERT INTO isl_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ef þeir vissu nákvæmlega hvenær hann kæmi, mundu þeir allir vera viðbúnir, rétt eins og þeir væru á verði, ef von væri á þjófi. ");
INSERT INTO isl_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Verið því ávallt viðbúin, því að ég, Kristur, kem fyrirvaralaust.“ ");
INSERT INTO isl_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Þá spurði Pétur: „Herra, segir þú þetta aðeins við okkur eða á það við um alla?“ ");
INSERT INTO isl_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","44","Drottinn svaraði: „Orð mín eiga erindi til allra þeirra sem trúir eru og grandvarir, þeirra sem húsbóndinn hefur falið þá ábyrgð að annast hina þjónana. En húsbóndinn mun snúa aftur og sjái hann þá að þjónninn hefur verið samviskusamur, mun hann launa honum. Hann mun setja hann yfir allar eigur sínar! ");
INSERT INTO isl_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","En hugsi þjónninn sem svo: Húsbóndi minn er ekki væntanlegur nærri strax. Tekur síðan upp á því að berja fólkið sem hann á að annast og eyða tímanum í svall og samkvæmislíf. ");
INSERT INTO isl_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Þá mun húsbóndi hans koma fyrirvaralaust og lífláta hann, því að það er hlutskipti hinna ótrúu. ");
INSERT INTO isl_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Sá maður fær þunga refsingu, því að hann gerði ekki skyldu sína þótt hann vissi hver hún væri. ");
INSERT INTO isl_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Sá sem hins vegar gerir rangt án þess að vita það, hlýtur aðeins væga refsingu. Mikils verður krafist af þeim sem mikið hafa hlotið, því að ábyrgð þeirra er meiri en hinna. ");
INSERT INTO isl_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ég kom til þess að kveikja eld á jörðinni. Ó, hve ég vildi að hann væri þegar kveiktur! ");
INSERT INTO isl_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Hræðileg skírn bíður mín og ég er angistarfullur uns henni er lokið. ");
INSERT INTO isl_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Haldið þið að ég hafi komið til að stilla til friðar á jörðinni? Nei! Nærvera mín veldur sundrungu og deilum. ");
INSERT INTO isl_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Upp frá þessu munu fjölskyldur klofna: Þrír með mér og tveir á móti – eða öfugt. ");
INSERT INTO isl_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Faðir mun taka sína afstöðu, en sonurinn aðra. Móðir og dóttir verða ósammála og tengdadóttirin mun hafna áliti hinnar virtu tengdamóður.“ ");
INSERT INTO isl_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Síðan sneri hann sér að mannfjöldanum og sagði: „Þegar þið sjáið ský myndast í vestri, segið þið: „Nú kemur skúr,“ – og það er alveg rétt. ");
INSERT INTO isl_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Sé hann suðlægur, þá segið þið: „Það verður þurrt í dag,“ og það er líka rétt. ");
INSERT INTO isl_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Hræsnarar! Þið eigið gott með að átta ykkur á veðrinu, en þið virðið ekki viðlits þær viðvaranir sem alls staðar blasa við, og boða erfiða tíma. ");
INSERT INTO isl_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Hvers vegna viljið þið ekki gera ykkur grein fyrir staðreyndum? ");
INSERT INTO isl_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Segjum svo að þú sért á leið til réttarins ásamt ákæranda þínum. Reyndu þá að sættast við hann áður en dómarinn fær málið í hendur, því að hann mun áreiðanlega dæma þig í fangelsi ");
INSERT INTO isl_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","og þaðan losnarðu ekki fyrr en þú hefur greitt síðustu krónuna.“ ");
INSERT INTO isl_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Um þetta leyti frétti Jesús að Pílatus hefði látið drepa nokkra Galíleumenn, sem voru að bera fram fórnir í musterinu í Jerúsalem. ");
INSERT INTO isl_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","„Haldið þið að þeir hafi verið meiri syndarar en Galíleumenn almennt?“ spurði hann. „Er það ástæðan fyrir þjáningum þeirra? ");
INSERT INTO isl_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nei, alls ekki! Skiljið þið ekki að sjálfir munuð þið farast, nema þið snúið ykkur frá syndinni og til Guðs? ");
INSERT INTO isl_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Hvað um mennina átján, sem dóu þegar Sílóamturninn hrundi? Voru þeir verstu syndarar í Jerúsalem? ");
INSERT INTO isl_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nei, hreint ekki! Og þið munuð sjálfir týna lífi og glatast, ef þið gerið ekki iðrun.“ ");
INSERT INTO isl_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Því næst sagði Jesús þeim þessa dæmisögu: „Maður nokkur gróðursetti fíkjutré í garði sínum. Oft leitaði hann ávaxta á því, en sér til mikilla vonbrigða fann hann enga. ");
INSERT INTO isl_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Að lokum skipaði hann garðyrkjumanni sínum að höggva tréð upp. „Ég hef beðið í þrjú ár og það hefur ekki borið eina einustu fíkju,“ sagði hann. „Til hvers er að standa í þessu lengur? Það er bara fyrir.“ ");
INSERT INTO isl_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","„Gefum því enn eitt tækifæri,“ sagði garðyrkjumaðurinn. „Látum það standa eitt ár enn og við skulum hugsa sérstaklega vel um það og bera vel á. ");
INSERT INTO isl_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ef við fáum fíkjur eftir árið, þá er allt í lagi. Ef það ber ekki ávöxt, þá fellum við það“.“ ");
INSERT INTO isl_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Helgidag einn var Jesús að kenna í einu af samkomuhúsunum. ");
INSERT INTO isl_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tók hann þá eftir konu sem var illa bækluð. Hún hafði verið krypplingur í átján ár og gat ekki rétt úr sér. ");
INSERT INTO isl_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesús kallaði hana til sín og sagði: „Kona, þú ert læknuð af sjúkdómi þínum.“ ");
INSERT INTO isl_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Og um leið og hann snerti hana rétti hún úr sér og lofaði Guð! ");
INSERT INTO isl_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","En forstöðumaður samkomuhússins varð mjög reiður vegna þess að Jesús skyldi hafa læknað hana á helgidegi og hrópaði: „Við höfum sex daga til að vinna í viku hverri! Komið þá og látið lækna ykkur, en ekki á hvíldardögum.“ ");
INSERT INTO isl_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","„Hræsnarar,“ svaraði Jesús, „þið vinnið á helgidögum. Leysið þið ekki nautgripina af stalli til að brynna þeim jafnt á helgidögum sem aðra daga? ");
INSERT INTO isl_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Er þá rangt af mér að leysa þessa konu úr fjötrum, sem Satan hefur haldið henni í, í átján ár, aðeins vegna þess að það er hvíldardagur?“ ");
INSERT INTO isl_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Óvinir hans urðu skömmustulegir við þessi orð, en fólkið gladdist vegna dásemdarverkanna sem hann vann. ");
INSERT INTO isl_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesús tók á ný að ræða við fólkið um guðsríki og spurði: „Hverju líkist guðsríki? Við hvað á ég að líkja því? ");
INSERT INTO isl_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Það er líkt örsmáu sinnepsfræi, sem sáð er í mold. Áður en langt um líður er það orðið að hávöxnum runna, þar sem fuglarnir byggja hreiður sín. ");
INSERT INTO isl_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","Því má einnig líkja við ger sem hnoðað hefur verið saman við deig, svo það hverfur í deigið, en samt lyftir það öllu deiginu.“ ");
INSERT INTO isl_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Eftir þetta lagði Jesús af stað til Jerúsalem og kom við í mörgum bæjum og þorpum á leiðinni. ");
INSERT INTO isl_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Eitt sinn var hann spurður þessarar spurningar: „Verða þeir fáir sem frelsast?“ ");
INSERT INTO isl_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","25","„Reynið að komast inn um þröngu dyrnar,“ svaraði Jesús, „því að margir munu reyna að komast þangað inn án árangurs, og þegar húsbóndinn hefur læst dyrunum verður það ekki lengur hægt. Ef þið standið þá fyrir utan, berjið og hrópið: „Drottinn, opnaðu fyrir okkur,“ mun hann svara: „Ég þekki ykkur ekki.“ ");
INSERT INTO isl_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","„Já, en… við átum og drukkum með þér og þú kenndir í þorpinu okkar,“ segið þið. ");
INSERT INTO isl_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","En ég svara: „Ég segi ykkur satt: Ég þekki ykkur ekki. Þið getið ekki komist hingað inn, því að þið eruð sekir. Burt með ykkur.“ ");
INSERT INTO isl_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Þið munuð gráta og kveina þegar þið standið fyrir utan og sjáið Abraham, Ísak, Jakob og alla spámennina í guðsríki. ");
INSERT INTO isl_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Því þangað mun fólk streyma hvaðanæva, úr öllum heiminum, og taka þar sæti sín. ");
INSERT INTO isl_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Takið eftir: Sumir sem nú eru fyrirlitnir, munu þá hljóta heiður, en aðrir sem nú eru í hávegum hafðir, verða þá taldir sístir allra.“ ");
INSERT INTO isl_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Í sama bili komu nokkrir farísear til hans og sögðu: „Ef þú vilt sleppa lifandi, komdu þér þá héðan sem fyrst, því Heródes konungur situr um líf þitt.“ ");
INSERT INTO isl_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","„Farið og segið þeim ref,“ svaraði Jesús, „að ég muni halda áfram að reka út illa anda og lækna í dag og á morgun, en þriðja daginn lýk ég mér af. ");
INSERT INTO isl_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Jafnframt þessu mun ég halda áfram ferð minni til Jerúsalem, því ekki hæfir að spámaður láti lífið annars staðar en þar. ");
INSERT INTO isl_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ó, Jerúsalem, Jerúsalem! Borgin, sem líflætur spámennina og grýtir þá sem sendir eru henni til hjálpar. Oft hef ég viljað safna börnum þínum saman, rétt eins og hæna verndar unga sína undir vængjum sér, en þið hafið ekki viljað það. ");
INSERT INTO isl_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Hús ykkar skulu verða skilin eftir í eyði og þið munuð ekki sjá mig aftur fyrr en þið segið: „Blessaður sé sá sem kemur í nafni Drottins.“ “ ");
INSERT INTO isl_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","2","Svo bar við á helgidegi er Jesús var gestur á heimili eins höfðingja faríseanna, að þeir höfðu gætur á honum, því að þeir vildu vita hvort hann læknaði mann sem þar var og þjáðist af vatnssótt. ");
INSERT INTO isl_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesús sneri sér þá að faríseunum og lögvitringunum og spurði: „Stendur það í lögunum að óheimilt sé að lækna á helgidegi?“ ");
INSERT INTO isl_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Farísearnir svöruðu engu orði. Þá snerti Jesús veika manninn, læknaði hann og lét hann fara. ");
INSERT INTO isl_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Síðan sneri hann sér að viðstöddum og sagði: „Segið mér, vinnur enginn ykkar handtak á helgidögum? Segjum svo að kýrin ykkar félli í skurð á helgidegi, hvað mynduð þið gera? Láta hana eiga sig?“ ");
INSERT INTO isl_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","En þeir voru orðlausir og gátu engu svarað. ");
INSERT INTO isl_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Þegar hann veitti því athygli að gestirnir reyndu allir að ná sér í virðulegustu sætin, sagði hann: ");
INSERT INTO isl_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","„Reynið ekki að ná í heiðurssætin í brúðkaupsveislunum! Ef að einhver háttsettari en þú kæmi á eftir þér, ");
INSERT INTO isl_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","þá mundi húsbóndinn leiða hann þangað sem þú sætir og segja við þig: „Leyfðu þessum manni að sitja hér.“ Þú yrðir þér til skammar og yrðir að færa þig í autt sæti við neðsta borðið! ");
INSERT INTO isl_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Sestu heldur fyrst við neðsta borðið og þegar húsbóndinn tekur eftir þér þar, mun hann koma og segja við þig: „Kæri vinur, komdu, við tókum miklu betra sæti frá handa þér.“ Þannig mun þér verða sýnd virðing frammi fyrir öllum gestunum. ");
INSERT INTO isl_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sá sem upphefur sjálfan sig, mun niðurlægjast, en sá sem lítillækkar sig, hlýtur upphefð.“ ");
INSERT INTO isl_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Síðan sneri hann sér að húsráðanda og sagði: „Þegar þú býður til veislu, skaltu ekki bjóða vinum þínum, ættingjum eða ríkum nágrönnum, því að þeir munu allir endurgjalda boðið. ");
INSERT INTO isl_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Bjóddu heldur fátækum, bækluðum, lömuðum og blindum. ");
INSERT INTO isl_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Og í upprisu hinna trúuðu, mun Guð launa þér fyrir að bjóða þeim sem ekki gátu endurgoldið.“ ");
INSERT INTO isl_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Þá sagði einn viðstaddra: „Það eru mikil forréttindi að fá að komast inn í guðsríki.“ ");
INSERT INTO isl_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesús sagði honum þá þessa dæmisögu: „Maður nokkur undirbjó mikla veislu og bauð mörgum. ");
INSERT INTO isl_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Þegar allt var tilbúið sendi hann þjóna sína til að minna boðsgestina á að nú væri stundin komin. ");
INSERT INTO isl_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","En þá fóru allir að afsaka sig. Einn sagði: „Ég er nýbúinn að kaupa jörð og þarf að fara og líta á hana. Ég bið þig að hafa mig afsakaðan.“ ");
INSERT INTO isl_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Annar sagðist hafa verið að kaupa tíu uxa og nú langaði hann til að reyna þá. ");
INSERT INTO isl_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Sá þriðji var nýgiftur og gat því ekki komið. ");
INSERT INTO isl_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Þjónninn sneri þá heim og flutti húsbónda sínum svörin. Þá reiddist húsbóndinn, sagði honum að fara strax út á götur og torg borgarinnar og bjóða betlurum, fötluðum, lömuðum og blindum að koma. ");
INSERT INTO isl_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Það var gert en samt var hægt að bæta við fleirum. ");
INSERT INTO isl_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Þá sagði húsbóndinn við þjóninn: „Farðu nú á göturnar sem liggja út úr bænum og líttu bak við limgerðin og hvettu alla sem þú finnur til að koma, svo að hús mitt verði fullt. ");
INSERT INTO isl_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Enginn þeirra sem ég bauð í fyrstu skal fá að smakka á því sem ég ætlaði þeim.“ “ ");
INSERT INTO isl_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mikill mannfjöldi fylgdi Jesú. Hann sneri sér að fólkinu og ávarpaði það: ");
INSERT INTO isl_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","„Sá sem vill fylgja mér, verður að elska mig meira en föður sinn og móður, meira en konu sína og börn, bræður eða systur. Já, meira en sitt eigið líf, annars getur hann ekki verið lærisveinn minn. ");
INSERT INTO isl_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Enginn getur verið lærisveinn minn nema hann beri sinn eigin kross og fylgi mér eftir. ");
INSERT INTO isl_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","En takið þó ekki ákvörðun um að fylgja mér, fyrr en þið hafið gert ykkur grein fyrir hvað það kostar ykkur. Hver haldið þið að byrji á húsbyggingu án þess að reikna fyrst út kostnaðinn, til að sjá hvort hann hafi nægilegt fé? ");
INSERT INTO isl_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ef hann gerði það ekki, gæti svo farið að hann yrði peningalaus þegar grunnurinn væri búinn. Þá myndu menn gera gys að honum ");
INSERT INTO isl_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","og segja: „Þarna er maðurinn sem fór að byggja en gat ekki lokið við það vegna peningaleysis.“ ");
INSERT INTO isl_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Og hvaða konungur haldið þið að léti sig dreyma um að fara í stríð án þess að setjast fyrst niður, ásamt ráðgjöfum sínum, til að ræða um hvort hann geti yfirbugað 20.000 manna óvinalið með 10.000 mönnum? ");
INSERT INTO isl_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ef niðurstaðan yrði neikvæð, mundi hann senda samninganefnd til óvinanna til að ræða friðarskilmála. ");
INSERT INTO isl_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Af þessu sjáið þið að enginn getur orðið lærisveinn minn nema hann vilji hafna öllu öðru mín vegna. ");
INSERT INTO isl_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Hvaða gagn er í salti sem misst hefur seltuna? ");
INSERT INTO isl_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Bragðlaust salt er einskis virði, það dugar ekki einu sinni í áburð. Það er ónýtt og til þess eins að fleygja því. Ef þið skiljið þetta, þá hugleiðið það vel.“ ");
INSERT INTO isl_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Skattheimtumenn voru þekktir að óheiðarleika. Þeir komu oft ásamt öðrum stórsyndurum til þess að hlusta á Jesú predika. ");
INSERT INTO isl_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Faríseunum og lögvitringunum líkaði meinilla að hann skyldi umgangast jafn fyrirlitlegt fólk, og meira að segja borða með því! ");
INSERT INTO isl_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","4","Jesús sagði þeim því eftirfarandi dæmisögu: „Segjum svo að þú ættir hundrað kindur, en ein þeirra villtist í burtu og týndist í óbyggðinni. Myndir þú þá ekki skilja hinar níutíu og níu eftir og fara að leita þeirrar sem týndist, uns þú fyndir hana? ");
INSERT INTO isl_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Þá yrðir þú svo glaður að þú bærir hana heim á herðum þér. ");
INSERT INTO isl_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Og kallaðir saman vini þína og granna til að gleðjast með þér yfir því að týnda kindin skyldi hafa fundist. ");
INSERT INTO isl_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Á sama hátt verður meiri gleði á himnum vegna eins syndara sem snýr sér til Guðs, en yfir öðrum níutíu og níu sem ekki hafa villst frá Guði! ");
INSERT INTO isl_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Tökum annað dæmi: Kona á tíu dýrmæta silfurpeninga og týnir einum þeirra. Hvað gerir hún þá? Hún kveikir ljós, leitar um allt og sópar hvern krók og kima þangað til hann finnst. ");
INSERT INTO isl_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Síðan kallar hún á vinkonur sínar og fær þær til að samgleðjast sér. ");
INSERT INTO isl_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Á sama hátt gleðjast englar Guðs einnig yfir hverjum þeim syndara sem gerir iðrun.“ Til enn frekari útskýringar sagði hann þeim þessa sögu: ");
INSERT INTO isl_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","„Maður nokkur átti tvo syni. ");
INSERT INTO isl_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Yngri sonurinn sagði við föður sinn: „Ég vil gjarnan fá minn hluta arfsins strax, í stað þess að bíða þangað til þú ert dáinn.“ Þá skipti faðirinn auðæfum sínum á milli sona sinna. ");
INSERT INTO isl_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nokkrum dögum síðar tók yngri sonurinn saman föggur sínar og hélt til fjarlægs lands. Þar eyddi hann öllum peningunum í skemmtanir og skækjur. ");
INSERT INTO isl_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","En þegar hann var að verða peningalaus kom mikil hungursneyð í því landi og hann tók að líða skort. ");
INSERT INTO isl_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Þá réð hann sig sem svínahirði hjá bónda einum. ");
INSERT INTO isl_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Hann varð svo hungraður að hann langaði jafnvel í baunahýðið sem svínin átu. Enginn gaf honum neitt. ");
INSERT INTO isl_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Að lokum áttaði hann sig á eymd sinni og sagði við sjálfan sig: „Verkamennirnir heima hjá föður mínum hafa nóg að borða og meira en það, en hér er ég að veslast upp af hungri! ");
INSERT INTO isl_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ég ætla að fara heim til pabba og segja: „Ég hef syndgað bæði gegn Guði og þér. ");
INSERT INTO isl_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ég er ekki lengur verður að kallast sonur þinn. Viltu ráða mig sem verkamann hjá þér?“ “ ");
INSERT INTO isl_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Síðan lagði hann af stað heim til föður síns. Faðir hans sá til hans þegar hann nálgaðist, kenndi í brjósti um hann, hljóp á móti honum, faðmaði hann og kyssti. ");
INSERT INTO isl_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Þá sagði sonurinn: „Faðir, ég hef syndgað bæði gegn Guði og þér. Ég er ekki verður að kallast sonur þinn.“ ");
INSERT INTO isl_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Faðirinn kallaði þá til þjóna sinna og sagði: „Flýtið ykkur! Náið í fallegustu skikkjuna sem til er og færið hann í. Látið líka hring á fingur hans og sækið nýja skó handa honum. ");
INSERT INTO isl_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Slátrið síðan alikálfinum því að nú ætlum við að halda veislu! ");
INSERT INTO isl_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Þessi sonur minn var dauður, en nú er hann lifnaður við. Hann var týndur, en nú er hann fundinn.“ Síðan hófst veislan. ");
INSERT INTO isl_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Meðan þetta gerðist var eldri sonurinn við vinnu úti á akri. Þegar hann kom heim, heyrði hann danstónlist frá húsinu ");
INSERT INTO isl_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","og spurði einn þjóninn hvað gengi á. ");
INSERT INTO isl_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","„Bróðir þinn er kominn,“ svaraði þjónninn, „og faðir þinn lét slátra kálfinum, sem verið var að ala, og hefur nú stofnað til mikillar veislu til að fagna því að sonurinn er kominn heim heill á húfi.“ ");
INSERT INTO isl_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Þá reiddist eldri bróðirinn og vildi ekki fara inn. Faðir hans fór þá út og bað hann fyrir alla muni að koma inn. ");
INSERT INTO isl_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","En hann svaraði: „Ég hef stritað fyrir þig öll þessi ár og aldrei neitað að gera neitt sem þú baðst mig. Þó hefur þú aldrei gefið mér svo mikið sem eina geit, allan þennan tíma, svo að ég gæti haldið veislu með vinum mínum. ");
INSERT INTO isl_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","En þegar þessi sonur þinn kemur heim, hann sem eyddi peningum þínum í skækjur, þá heldur þú hátíð og slátrar besta kálfinum.“ ");
INSERT INTO isl_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","En faðir hans sagði: „Sonur minn, þú ert alltaf hjá mér og allt sem ég á, átt þú með mér. ");
INSERT INTO isl_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","En nú getum við ekki annað en glaðst, því hann er jú bróðir þinn. Hann var dauður, en er nú lifnaður við! Hann var týndur, en nú er hann fundinn.“ “ ");
INSERT INTO isl_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús sagði lærisveinum sínum eftirfarandi sögu: „Ríkur maður réð til sín framkvæmdastjóra til að annast viðskipti sín. Fljótlega tók að kvisast út að maðurinn væri óheiðarlegur. ");
INSERT INTO isl_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Þá kallaði ríki maðurinn hann fyrir sig og sagði: „Er það satt sem ég heyri, að þú stelir frá mér? Viltu gjöra svo vel að koma reglu á bókhaldið og síðan geturðu farið.“ ");
INSERT INTO isl_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Maðurinn hugsaði með sjálfum sér: „Nú, jæja, þá er búið að segja mér upp! Hvað á ég nú að gera? Ég hef ekki þrek til að grafa skurði og er of stoltur til að betla. ");
INSERT INTO isl_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nú veit ég hvað ég geri til þess að eignast marga vini, sem geta hjálpað mér þegar ég fer héðan.“ ");
INSERT INTO isl_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","6","Síðan bauð hann hverjum skuldunaut fyrir sig að koma og ræða um skuldina. Hann spurði þann fyrsta: „Hve mikið skuldar þú atvinnurekanda mínum?“ „3.500 lítra af ólífuolíu,“ svaraði maðurinn. „Já, rétt er það“ sagði framkvæmdastjórinn, „hérna er samningurinn sem þú undirritaðir. En nú skaltu rífa hann og skrifa annan, fyrir helmingnum af þessu magni.“ ");
INSERT INTO isl_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","„Hve mikið skuldar þú?“ spurði hann næsta mann. „1.000 tunnur af hveiti,“ var svarið. „Hérna,“ sagði hinn, „hirtu samninginn þinn og gerðu nýjan, upp á 800 tunnur.“ ");
INSERT INTO isl_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ríki maðurinn var tilneyddur að dást að þorpara þessum fyrir slægð hans. Satt er það, að guðleysingjarnir eru kænni í viðskiptum sínum við heiminn en hinir trúuðu. ");
INSERT INTO isl_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","En ég segi ykkur: Notið eigur ykkar til þess að afla ykkur vina, svo að þeir fagni ykkur í eilífðinni, þegar þið verðið að skiljast við þær. ");
INSERT INTO isl_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Sá sem er trúr í litlu, verður einnig trúr í stóru. Sá sem svindlar í því sem lítið er, mun einnig fara óheiðarlega með það sem meira er. ");
INSERT INTO isl_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ef ekki er hægt að treysta ykkur í hinu veraldlega, hver mun þá trúa ykkur fyrir hinum miklu auðæfum himnanna? ");
INSERT INTO isl_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ef þið farið illa með fjármuni annarra, hvernig er þá hægt að treysta ykkur fyrir eigin fjármunum? ");
INSERT INTO isl_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Enginn getur þjónað tveim húsbændum – ekki þið heldur. Þið munuð hata annan en aðhyllast hinn – láta ykkur annt um annan en fyrirlíta hinn. Þið getið ekki gert hvort tveggja í senn, þjónað Guði og peningunum.“ ");
INSERT INTO isl_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Þegar farísearnir heyrðu þetta, hlógu þeir háðslega, því að þeir voru fégjarnir menn. ");
INSERT INTO isl_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesús sagði því við þá: „Þið gangið um með virðuleika – og helgisvip – en Guð þekkir illsku ykkar. Með framkomu ykkar aflið þið ykkur lýðhylli, en þetta er viðbjóðslegt í augum Guðs. ");
INSERT INTO isl_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Lög Móse og boðskapur spámannanna var ykkur leiðarljós, þar til Jóhannes skírari kom. Hann flutti þær gleðifréttir að guðsríki væri á næsta leiti og fólkið þyrptist að til að komast þangað. ");
INSERT INTO isl_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Guðs lög hafa þó ekki í hinu minnsta atriði misst kraft sinn, því að þau eru óhagganlegri en himinn og jörð. ");
INSERT INTO isl_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ef einhver skilur við konu sína, drýgir hann hór og sama er að segja um þann sem kvænist fráskilinni konu.“ ");
INSERT INTO isl_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesús hélt áfram og sagði: „Maður nokkur, ríkur, klæddist dýrindisfatnaði og lifði dag hvern í gleðskap og allsnægtum. ");
INSERT INTO isl_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Dag einn var sjúkur betlari, Lasarus að nafni, lagður við dyr hans. ");
INSERT INTO isl_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Þar lá hann og vonaðist eftir leifum af borði ríka mannsins, en hundar komu og sleiktu sár hans. ");
INSERT INTO isl_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Að lokum dó betlarinn og englar báru hann til Abrahams. Ríki maðurinn dó einnig, var grafinn ");
INSERT INTO isl_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","og fór til heljar. En er hann kvaldist þar, sá hann Lasarus álengdar hjá Abraham. ");
INSERT INTO isl_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","„Faðir Abraham,“ kallaði hann, „miskunnaðu mér! Sendu Lasarus hingað til þess að dýfa fingri í vatn og kæla tungu mína, því ég kvelst í þessum loga.“ ");
INSERT INTO isl_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","En Abraham svaraði: „Sonur, mundu að meðan þú lifðir hafðir þú allt sem þú þurftir, en Lasarus var allslaus. Hér huggast hann, en þú kvelst. ");
INSERT INTO isl_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Auk þess er mikið djúp okkar á milli og þeir sem vilja komast héðan yfir til þín, geta það ekki og enginn kemst frá ykkur yfir til okkar.“ ");
INSERT INTO isl_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Þá sagði ríki maðurinn: „Ó, faðir Abraham, gerðu þá annað, sendu hann heim til föður míns ");
INSERT INTO isl_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","– því að ég á fimm bræður og varaðu þá við þessum kvalastað, svo að þeir lendi ekki hér líka þegar þeir deyja.“ ");
INSERT INTO isl_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Þá svaraði Abraham: „Þeir hafa Biblíuna, hlýði þeir henni.“ ");
INSERT INTO isl_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","„Nei, faðir Abraham,“ svaraði ríki maðurinn. „En ef einhver kæmi til þeirra frá hinum dauðu, þá myndu þeir áreiðanlega snúa sér frá syndum sínum.“ ");
INSERT INTO isl_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","En Abraham svaraði: „Ef þeir hlýða ekki orðum Biblíunnar – Móse og spámönnunum – munu þeir ekki heldur láta sannfærast þótt einhver rísi upp frá dauðum.“ “ ");
INSERT INTO isl_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús sagði við lærisveinana: „Fólk mun halda áfram að falla í synd, en vei þeim sem því veldur. ");
INSERT INTO isl_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","3","Honum væri betra að láta fleygja sér í sjóinn, með þungan stein um hálsinn, en skaða sálir smælingjanna. Gætið ykkar! Ávítaðu bróður þinn, ef hann syndgar, en fyrirgefðu honum, þegar hann iðrast. ");
INSERT INTO isl_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Geri hann þér rangt til sjö sinnum á dag og komi til þín eftir hvert skipti og biðji fyrirgefningar, þá fyrirgefðu honum.“ ");
INSERT INTO isl_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Dag einn sögðu postularnir við Drottin: „Við þurfum að öðlast meiri trú, hvernig getum við það?“ ");
INSERT INTO isl_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jesús svaraði: „Ef þið hafið trú á stærð við sinnepskorn, þá er hún nægileg til að rífa upp mórberjatréð sem þarna stendur og senda það í loftköstum á haf út! Orðum ykkar yrði þegar í stað hlýtt. ");
INSERT INTO isl_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","9","Þegar vinnumaður kemur inn frá jarðyrkju eða gegningum, þá sest hann ekki niður til að borða. Hann matreiðir fyrst fyrir húsbónda sinn og ber kvöldverð á borð fyrir hann, áður en hann fær sér sjálfur. Og honum er ekki þakkað, því að þetta eru skylduverk hans. ");
INSERT INTO isl_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Þið eigið ekki heldur að vænta heiðurs fyrir að hlýða mér, því að þá hafið þið aðeins gert skyldu ykkar.“ ");
INSERT INTO isl_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","12","Á leið sinni frá Jerúsalem komu þeir að þorpi á landamærum Galíleu og Samaríu. Þá sáu þeir tíu holdsveika menn, sem stóðu langt frá, utan við þorpið, ");
INSERT INTO isl_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","og hrópuðu: „Jesú, meistari, miskunnaðu okkur!“ ");
INSERT INTO isl_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Hann leit á þá og sagði: „Farið til prestanna og fáið hjá þeim vottorð um að þið séuð heilbrigðir.“ Á meðan þeir voru á leiðinni til prestanna, hvarf þeim holdsveikin! ");
INSERT INTO isl_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Einn þeirra sneri þá aftur til Jesús og hrópaði: „Guði sé lof! Ég er heilbrigður!“ ");
INSERT INTO isl_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Hann fleygði sér á götuna við fætur Jesú og þakkaði honum. Maður þessi var Samverji, en Gyðingar fyrirlitu þá. ");
INSERT INTO isl_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Þá spurði Jesús: „Voru þeir ekki tíu sem ég læknaði? Hvar eru hinir níu? ");
INSERT INTO isl_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Var þessi útlendingur sá eini sem sneri við til að gefa Guði dýrðina?“ ");
INSERT INTO isl_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Síðan sagði hann við manninn: „Stattu upp og farðu leiðar þinnar, trú þín hefur læknað þig.“ ");
INSERT INTO isl_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Dag einn spurðu farísearnir Jesú: „Hvenær kemur guðsríki?“ „Guðsríki birtist ekki þannig að á því beri,“ svaraði Jesús. ");
INSERT INTO isl_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","„Þið munuð ekki geta sagt: „Það hófst á þessum stað eða í þessum landshluta“ því að áhrifa guðsríkisins gætir með manninum.“ ");
INSERT INTO isl_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Síðar ræddi hann þetta við lærisveinana og sagði: „Sá tími mun koma er þið þráið að hafa mig hjá ykkur, þó ekki sé nema einn dag, en þá verð ég ekki hér. ");
INSERT INTO isl_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ykkur munu berast fréttir um að ég sé kominn aftur og sé hér eða þar. Trúið ekki slíku. Farið ekki að leita mín, ");
INSERT INTO isl_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","því að þegar ég kem, þá verður það engum vafa undirorpið. Það verður jafn augljóst og þegar elding leiftrar um himininn. ");
INSERT INTO isl_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","En fyrst verð ég að líða miklar þjáningar og þjóð mín mun hafna mér. ");
INSERT INTO isl_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Þegar ég kem aftur, verður heimurinn jafn sinnulaus um Guð og hann var á dögum Nóa. ");
INSERT INTO isl_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Fólk át og drakk og gifti sig allt til þess dags er Nói gekk inn í örkina. Eftir það kom flóðið og tortímdi þeim öllum. ");
INSERT INTO isl_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Það mun verða eins og á dögum Lots: Fólk sinnti sínum daglegu störfum, át og drakk, keypti og seldi, ræktaði og byggði ");
INSERT INTO isl_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","– allt til þeirrar stundar er Lot yfirgaf Sódómu. Þá rigndi eldi og brennisteini yfir þá af himni og eyddi þeim öllum. ");
INSERT INTO isl_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Þannig mun fólk verða önnum kafið við sín daglegu störf er ég kem aftur. ");
INSERT INTO isl_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Þeir sem úti eru þann dag mega ekki fara inn til að pakka niður. Þeir sem verða við vinnu á ökrum mega ekki heldur fara heim ");
INSERT INTO isl_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","– munið hvað kom fyrir konu Lots! ");
INSERT INTO isl_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Sá sem heldur í líf sitt mun glata því, en sá sem fórnar því, mun bjarga því. ");
INSERT INTO isl_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Þá nótt munu tveir menn sofa í sama rúmi, annar verður tekinn burt en hinn skilinn eftir. ");
INSERT INTO isl_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Tvær konur munu vinna saman að heimilisstörfum, önnur verður tekin, hin skilin eftir. Sama er að segja um þá sem vinna hlið við hlið á ökrunum. Annar verður tekinn, hinn skilinn eftir.“ ");
INSERT INTO isl_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","„Hvar verður hann skilinn eftir?“ spurðu lærisveinarnir. „Það verður augljóst þegar að því kemur,“ svaraði Jesús, „jafn augljóst og það, að þangað sem hræið liggur munu gammarnir þyrpast.“ ");
INSERT INTO isl_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Eitt sinn sagði Jesús lærisveinum sínum þessa sögu til að hvetja þá til að gefast ekki upp að biðja, fyrr en svarið kæmi: ");
INSERT INTO isl_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","„Í borg einni var dómari, sem ekki trúði á Guð, og fyrirleit alla menn. ");
INSERT INTO isl_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ekkja, sem þar bjó, kom oft til hans og bað hann að leita réttar síns gegn manni, sem brotið hafði gegn henni. ");
INSERT INTO isl_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Í fyrstu gaf dómarinn henni engan gaum, en að lokum fór hún að fara í taugarnar á honum. „Ég hræðist hvorki Guð né menn,“ sagði hann við sjálfan sig, „en þessi kona veldur mér ónæði. Ég ætla að sjá til þess að hún nái rétti sínum, því ég er orðinn leiður á henni, hún er alltaf að koma.“ ");
INSERT INTO isl_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","7","Drottinn sagði: „Haldið þið að Guð láti ekki sitt fólk ná rétti sínum, ef það hrópar til hans dag og nótt, fyrst hægt er að hafa áhrif á vondan dómara? ");
INSERT INTO isl_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Jú, áreiðanlega! Og hann mun svara því fljótt! Spurningin er hve marga trúaða og bænrækna ég finn þegar ég, Kristur, kem aftur.“ ");
INSERT INTO isl_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Síðan sagði hann þeim, sem stærðu sig af verkum sínum og fyrirlitu aðra, eftirfarandi sögu: ");
INSERT INTO isl_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","„Tveir men fóru upp í musterið til að biðjast fyrir. Annar var farísei, en hinn var skattheimtumaður. ");
INSERT INTO isl_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Faríseinn bað þannig: „Guð, ég þakka þér að ég er ekki eins og syndararnir, til dæmis eins og þessi skattheimtumaður! Ég stel aldrei, ég drýgi ekki hór, ");
INSERT INTO isl_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ég fasta tvisvar í viku og gef tíund af öllu sem ég vinn mér inn.“ ");
INSERT INTO isl_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Óprúttni skattheimtumaðurinn stóð langt frá og þorði ekki einu sinni að horfa upp til himins meðan hann bað, heldur barði sér hryggur á brjóst og sagði: „Guð, vertu mér syndugum líknsamur.“ ");
INSERT INTO isl_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ég segi ykkur: Þessi syndari fékk fyrirgefningu, en ekki faríseinn! Hinir hrokafullu verða niðurlægðir, en auðmjúkum veitt náð.“ ");
INSERT INTO isl_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Dag einn komu mæður með börnin sín til Jesú til að hann snerti þau og blessaði, en lærisveinarnir skipuðu þeim burt. ");
INSERT INTO isl_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","17","Þá kallaði Jesús börnin til sín og sagði við lærisveinana: „Leyfið börnunum að koma til mín, en hindrið þau ekki. Guðsríki er fyrir þá sem hafa hjartalag og trú eins og þessi litlu börn, en sá sem ekki hefur trú eins og þau, mun aldrei þangað komast.“ ");
INSERT INTO isl_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Höfðingi nokkur spurði Jesú: „Góði meistari, hvað á ég að gera til að eignast eilíft líf?“ ");
INSERT INTO isl_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","„Veistu hvað þú ert að segja þegar þú kallar mig góðan?“ spurði Jesús. „Aðeins einn er góður í raun og veru, og það er Guð. ");
INSERT INTO isl_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Þú þekkir boðorðin: Þú skalt ekki drýgja hór, þú skalt ekki myrða, ekki stela, ekki ljúga, heiðraðu föður þinn og móður þína,“ ");
INSERT INTO isl_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Maðurinn svaraði: „Ég hef hlýðnast öllum þessum boðum frá barnæsku.“ ");
INSERT INTO isl_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","„Eitt vantar þig enn,“ sagði Jesús, „og það er þetta: Seldu allt sem þú átt, gefðu fátækum andvirðið og þá muntu eignast fjársjóð á himnum – komdu síðan og fylgdu mér.“ ");
INSERT INTO isl_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Þegar maðurinn heyrði þetta, fór hann hryggur í burtu, því að hann var mjög ríkur. ");
INSERT INTO isl_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesús horfði á eftir honum og sagði síðan við lærisveina sína: „Það er erfitt fyrir hina ríku að komast inn í guðsríki! ");
INSERT INTO isl_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Það er auðveldara fyrir úlfalda að smjúga gegnum nálarauga, en fyrir ríkan mann að komast inn í guðsríki.“ ");
INSERT INTO isl_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Þegar lærisveinarnir heyrðu þetta hrópuðu þeir: „Hver getur þá orðið hólpinn, fyrst það er svona erfitt?“ ");
INSERT INTO isl_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","„Guð getur það sem menn geta ekki,“ svaraði Jesús. ");
INSERT INTO isl_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Þá sagði Pétur: „Við höfum yfirgefið heimili okkar og fylgt þér.“ ");
INSERT INTO isl_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","„Já,“ svaraði Jesús, „allir sem yfirgefa heimili, konu, bræður, foreldra eða börn vegna guðsríkisins, ");
INSERT INTO isl_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","munu fá margföld laun í þessum heimi, auk eilífs lífs í hinum komandi.“ ");
INSERT INTO isl_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Síðan kallaði hann þá tólf saman og sagði: „Þið vitið að við erum á leiðinni til Jerúsalem. Þegar þangað kemur, mun allt rætast sem hinir fornu spámenn sögðu um mig. ");
INSERT INTO isl_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ég verð framseldur heiðingjunum, en þeir munu hæða mig og spotta. Einnig munu þeir hrækja á mig, ");
INSERT INTO isl_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","húðstrýkja og loks lífláta, en á þriðja degi mun ég rísa upp.“ ");
INSERT INTO isl_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Þeir skildu ekki hvað hann var að segja og fannst það algjör ráðgáta. ");
INSERT INTO isl_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Þegar þeir nálguðust Jeríkó sat blindur betlari við veginn. ");
INSERT INTO isl_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Þegar hann heyrði að mikill mannfjöldi var að nálgast, spurði hann hvað um væri að vera. ");
INSERT INTO isl_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Honum var þá sagt að Jesús frá Nasaret væri þar á ferð. ");
INSERT INTO isl_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Þá fór hann að hrópa í sífellu: „Jesús, sonur Davíðs, miskunnaðu mér!“ ");
INSERT INTO isl_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Fólkið sem gekk á undan Jesú, reyndi að þagga niður í honum. En þá hrópaði hann enn hærra: „Sonur Davíðs, miskunna þú mér!“ ");
INSERT INTO isl_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Þegar Jesús kom nær, nam hann staðar og sagði: „Komið með blinda manninn hingað.“ ");
INSERT INTO isl_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Síðan spurði Jesús hann: „Hvað viltu að ég geri fyrir þig?“ „Drottinn,“ sagði hann biðjandi, „mig langar að fá sjónina.“ ");
INSERT INTO isl_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","„Nú getur þú séð,“ sagði Jesús. „Trú þín hefur læknað þig.“ ");
INSERT INTO isl_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Samstundis fékk maðurinn sjónina og fylgdi Jesú og lofaði Guð. Allir sem þetta sáu lofuðu Guð. ");
INSERT INTO isl_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Í Jeríkó bjó maður sem Sakkeus hét. ");
INSERT INTO isl_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Hann var yfirskattheimtumaður Rómverja og því mjög ríkur. ");
INSERT INTO isl_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Þegar Jesús var á leið um borgina reyndi Sakkeus, sem var mjög lágvaxinn, að sjá Jesú, en hann gat það ekki vegna mannfjöldans. ");
INSERT INTO isl_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Hann hljóp því fram fyrir og klifraði upp í mórberjatré, sem stóð við veginn, til að fá góða yfirsýn. ");
INSERT INTO isl_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Þegar Jesús kom þar að, leit hann upp til Sakkeusar og kallaði: „Sakkeus! Komdu niður! Ég ætla að heimsækja þig í dag.“ ");
INSERT INTO isl_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakkeus varð mjög glaður. Hann flýtti sér niður úr trénu, fullur eftirvæntingar, og fór með Jesú heim til sín. ");
INSERT INTO isl_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Þá lét mannfjöldinn óánægju sína í ljós og sagði: „Hví leyfir hann sér að heimsækja slíkan syndara?“ ");
INSERT INTO isl_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","En á meðan stóð Sakkeus frammi fyrir Drottni og sagði: „Herra, héðan í frá ætla ég að gefa fátækum helming auðæfa minna. Og hafi ég látið einhvern greiða of háa skatta, þá mun ég refsa sjálfum mér með því að greiða honum fjórfalt aftur.“ ");
INSERT INTO isl_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","Þá sagði Jesús við hann: „Þetta sýnir, að í dag hefur hjálp Guðs veist þessu heimili. Þú varst einn hinna týndu sona Abrahams. Ég, Kristur, er kominn til að leita að hinu týnda og frelsa það.“ ");
INSERT INTO isl_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Þegar Jesús var kominn í námunda við Jerúsalem, sagði hann dæmisögu til að leiðrétta þá sem héldu að ríki Guðs stæði fyrir dyrum: ");
INSERT INTO isl_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","„Höfðingi, sem bjó í skattlandi einu, var kvaddur til höfuðborgar ríkisins, en þar átti að krýna hann konung yfir skattlandinu. ");
INSERT INTO isl_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Áður en hann fór, kallaði hann saman tíu aðstoðarmenn sína og afhenti hverjum um sig hálfa milljón króna, sem þeir áttu að versla með meðan hann væri í burtu. ");
INSERT INTO isl_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Sumum landsmanna var illa við hann og því sendu þeir honum sjálfstæðisyfirlýsingu. Þeir tóku fram að þeir hefðu gert byltingu og myndu ekki líta á hann sem konung sinn. ");
INSERT INTO isl_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Þegar hann kom heim aftur, kallaði hann til sín menn þá sem hann hafði afhent peningana. Nú vildi hann fá að vita hvernig þeim hefði gengið og hver ágóði hans yrði. ");
INSERT INTO isl_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Sá fyrsti sagði frá stórkostlegum gróða – hann hafði tífaldað upphæðina! ");
INSERT INTO isl_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","„Glæsilegt!“ hrópaði konungurinn. „Mér líst vel á þig. Þú hefur reynst trúr í því litla sem ég fól þér og í staðinn skaltu fá að stjórna tíu borgum.“ ");
INSERT INTO isl_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Næsti maður hafði einnig góða sögu að segja, hann hafði fimmfaldað upphæðina. ");
INSERT INTO isl_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","„Gott!“ sagði húsbóndi hans. „Þú skalt fá að stjórna fimm borgum.“ ");
INSERT INTO isl_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","En sá þriðji skilaði aðeins sömu upphæð og hann hafði fengið og sagði: „Ég var hræddur og gætti peninganna vel, því að þú ert ekkert lamb að leika við. Þú tekur það sem þú átt ekki og hirðir jafnvel uppskeru annarra.“ ");
INSERT INTO isl_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","„Þú ert latur, þorparinn þinn,“ hreytti konungurinn út úr sér og bætti síðan við: „Er ég harðskeyttur, ha? Já, það er ég og þannig verð ég einmitt við þig! ");
INSERT INTO isl_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Hvers vegna lagðir þú þá peningana ekki í banka svo ég fengi þó einhverja vexti, fyrst þú þekktir mig svona vel?“ ");
INSERT INTO isl_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Síðan sneri hann sér að hinum sem þar stóðu og sagði skipandi: „Takið af honum peningana og fáið þeim sem græddi mest.“ ");
INSERT INTO isl_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","„Já, herra, en er hann ekki þegar búinn að fá nóg?“ spurðu þeir. ");
INSERT INTO isl_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","„Jú,“ svaraði konungurinn, „en sá sem hefur, mun fá enn meira, en sá sem lítið á, mun missa það fyrr en varir. ");
INSERT INTO isl_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","En varðandi þessa óvini mína sem gerðu uppreisn, þá náið í þá og takið þá af lífi að mér ásjáandi“.“ ");
INSERT INTO isl_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Eftir að hafa sagt þessa sögu, hélt Jesús áfram til Jerúsalem og gekk á undan lærisveinunum. ");
INSERT INTO isl_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Þegar þeir nálguðust þorpin Betfage og Betaníu á Olíufjallinu, sendi hann tvo þeirra á undan sér. ");
INSERT INTO isl_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Hann sagði þeim að fara inn í þorpið, sem var nær, og þegar þangað kæmi skyldu þeir leita uppi asna í einni götunni. Þetta átti að vera foli, sem enginn hefði áður komið á bak. „Leysið hann,“ sagði Jesús, „og komið með hann. ");
INSERT INTO isl_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ef einhver spyr hvað þið séuð að gera, skuluð þið segja: „Herrann þarf hans með.“ “ ");
INSERT INTO isl_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Þeir fóru og fundu asnann eins og Jesús hafði sagt, ");
INSERT INTO isl_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","en meðan þeir voru að leysa hann, komu eigendurnir og kröfðust skýringar. „Hvað eruð þið að gera?“ spurðu þeir, „hvers vegna eruð þið að leysa folann okkar?“ ");
INSERT INTO isl_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","„Herrann þarf hans með,“ svöruðu lærisveinarnir. ");
INSERT INTO isl_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Síðan fóru þeir með hann til Jesú og lögðu yfirhafnir sínar á bak folans, handa Jesú að sitja á. ");
INSERT INTO isl_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","37","Fólkið breiddi föt sín á veginn framundan. Þegar komið var þangað, sem vegurinn liggur niður af Olíufjallinu, tók öll fylkingin að hrópa og lofsyngja Guð fyrir öll undursamlegu kraftaverkin sem Jesús hafði gert. ");
INSERT INTO isl_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","„Guð hefur gefið okkur konung!“ hrópaði fólkið í gleði sinni. „Lengi lifi konungurinn! Gleðjist þið himnar! Dýrð sé Guði í hæstum himni!“ ");
INSERT INTO isl_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","En í hópnum voru nokkrir farísear sem sögðu: „Herra, þú verður að banna fylgjendum þínum að segja slíka hluti.“ ");
INSERT INTO isl_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Hann svaraði: „Ef þeir þegðu, myndu steinarnir hrópa gleðióp.“ ");
INSERT INTO isl_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Þegar nær dró Jerúsalem og Jesús sá borgina, grét hann og sagði: ");
INSERT INTO isl_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","„Ó, ef þú hefðir aðeins þekkt veg friðarins, en nú er hann hulinn sjónum þínum. ");
INSERT INTO isl_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Óvinir þínir munu reisa virki gegn borgarmúrum þínum, umkringja þig og inniloka. ");
INSERT INTO isl_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Þeir munu eyða þér og börnum þínum, svo að ekki standi steinn yfir steini – því þú hafnaðir boði Guðs.“ ");
INSERT INTO isl_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesús fór inn í musterið og rak kaupmennina frá borðum sínum ");
INSERT INTO isl_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","og sagði: „Biblían segir: „Musteri mitt er bænastaður, en þið hafið breytt því í þjófabæli.“ ");
INSERT INTO isl_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Eftir þetta kenndi hann daglega í musterinu. Æðstu prestarnir, ásamt öðrum trúarleiðtogum og framámönnum þjóðarinnar, reyndu nú að finna leið til að losna við hann. ");
INSERT INTO isl_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","En þeir fundu enga, því að fólkið leit á hann sem þjóðhetju – það var sammála öllu sem hann sagði. ");
INSERT INTO isl_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Dag nokkurn var Jesús að kenna og predika í musterinu. Þá lögðu æðstu prestarnir til atlögu við hann ásamt öðrum trúarleiðtogum og mönnum úr ráðinu. ");
INSERT INTO isl_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Þeir kröfðust þess að hann segði þeim með hvaða valdi hann hefði rekið musteriskaupmennina út. ");
INSERT INTO isl_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","„Áður en ég svara ætla ég að spyrja ykkur annarrar spurningar,“ svaraði hann: ");
INSERT INTO isl_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","„Var Jóhannes sendur af Guði eða starfaði hann aðeins í eigin mætti?“ ");
INSERT INTO isl_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Þeir ráðguðust um þetta. „Ef við segjum að boðskapur hans hafi verið frá himnum, þá erum við fallnir í gildru, því að þá spyr hann: „Hvers vegna trúðuð þið honum þá ekki?“ ");
INSERT INTO isl_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ef við segjum hins vegar að Jóhannes hafi ekki verið sendur af Guði, þá ræðst múgurinn á okkur, því allir eru vissir um að hann hafi verið spámaður.“ ");
INSERT INTO isl_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Að lokum svöruðu þeir: „Við vitum það ekki.“ ");
INSERT INTO isl_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","„Þá mun ég ekki heldur svara spurningu ykkar,“ sagði Jesús. ");
INSERT INTO isl_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesús sneri sér aftur að fólkinu og sagði því eftirfarandi sögu: „Maður plantaði víngarð, leigði hann nokkrum bændum og fór síðan til útlanda, þar sem hann bjó í nokkur ár. ");
INSERT INTO isl_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Þegar uppskerutíminn kom, sendi hann einn af mönnum sínum til búgarðsins til að sækja sinn hluta uppskerunnar. En leigjendurnir börðu hann og sendu hann tómhentan til baka. ");
INSERT INTO isl_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Þá sendi hann annan, en sama sagan endurtók sig: Hann var barinn og auðmýktur og sendur allslaus heim. ");
INSERT INTO isl_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Sá þriðji var einnig særður og enn fór á sömu leið. Honum var líka misþyrmt og hann rekinn í burtu. ");
INSERT INTO isl_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","„Hvað á ég að gera“ sagði eigandi víngarðsins við sjálfan sig. „Já, nú veit ég það! Ég sendi son minn, sem ég elska, þeir munu áreiðanlega sýna honum virðingu.“ ");
INSERT INTO isl_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","En þegar leigjendurnir sáu son hans, sögðu þeir: „Nú er tækifærið. Þessi náungi á að erfa allt landið eftir föður sinn. Komum! Drepum hann, og þá eigum við þetta allt.“ ");
INSERT INTO isl_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Þeir drógu hann út fyrir víngarðinn og drápu hann. Hvað haldið þið nú að eigandinn hafi gert? ");
INSERT INTO isl_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Það skal ég segja ykkur. Hann mun koma og drepa þá alla og leigja öðrum víngarðinn.“ „Annað eins og þetta getur aldrei gerst,“ mótmæltu áheyrendur. ");
INSERT INTO isl_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesús horfði á þá og sagði: „Hvað á þá Biblían við þegar hún segir: „Steinninn, sem smiðirnir höfnuðu, var gerður að hornsteini.“ ");
INSERT INTO isl_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Og hann bætti við: „Hver sá sem hrasar um þann stein, mun limlestast og þeir sem undir honum verða, munu sundurkremjast.“ ");
INSERT INTO isl_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Nú vildu æðstu prestarnir og trúarleiðtogarnir handtaka hann á stundinni, því að þeir skildu að sagan um víngarðsmennina átti við þá. Þeir voru einmitt þessir forhertu leigjendur í sögunni. En þeir óttuðust að fólkið stofnaði til óeirða ef þeir tækju hann. Þeir reyndu því að fá hann til að segja eitthvað sem hægt væri að ákæra hann fyrir til rómverska landstjórans, og fá hann handtekinn. ");
INSERT INTO isl_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Með þetta í huga sendu þeir til hans njósnara sem þóttust sakleysið uppmálað. ");
INSERT INTO isl_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Þeir sögðu við Jesú: „Herra, við vitum að þú ert heiðarlegur kennari. Þú segir alltaf sannleikann og veitir fræðslu um Guð, en hopar ekki fyrir andstæðingum þínum. ");
INSERT INTO isl_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Segðu okkur nú eitt – er rétt að greiða rómverska keisaranum skatt?“ ");
INSERT INTO isl_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesús sá við bragðinu og svaraði: ");
INSERT INTO isl_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","„Sýnið mér mynt. Hvers mynd og nafn er á henni?“ „Rómverska keisarans,“ svöruðu þeir. ");
INSERT INTO isl_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Þá sagði Jesús: „Greiðið keisaranum allt sem hans er – og gefið Guði það sem Guði ber.“ ");
INSERT INTO isl_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bragðið mistókst. Þeir undruðust svar hans og þögðu. ");
INSERT INTO isl_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","28","Þá komu til hans nokkrir saddúkear. Þeir trúa hvorki á líf eftir dauðann né upprisu. Þeir sögðu: „Lög Móse segja að deyi maður barnlaus, þá eigi bróðir hans að kvænast ekkjunni og börn þeirra skulu teljast börn látna mannsins og bera nafn hans. ");
INSERT INTO isl_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Við vitum um sjö bræður. Elsti bróðirinn kvæntist en dó barnlaus. ");
INSERT INTO isl_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Bróðir hans kvæntist þá ekkjunni og dó líka barnlaus. ");
INSERT INTO isl_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Þannig gekk þetta, koll af kolli, þar til allir sjö höfðu átt konuna, en dáið án þess að eiga börn. ");
INSERT INTO isl_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Að lokum dó konan líka. ");
INSERT INTO isl_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nú spyrjum við: Hverjum þeirra verður hún gift í upprisunni, fyrst hún giftist þeim öllum?“ ");
INSERT INTO isl_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","35","„Hjónabandið er fyrir þá sem lifa á jörðinni,“ svaraði Jesús, „en þeir sem verðskulda guðsríki ganga ekki í hjónaband við upprisuna, ");
INSERT INTO isl_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","og þeir munu aldrei deyja. Þeir eru synir Guðs og eru eins og englarnir. Þeir hafa risið upp frá dauðum til nýs lífs. ");
INSERT INTO isl_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","38","Hvers vegna efist þið um upprisuna? Sjálfur Móse talar um hana. Hann lýsir því hvernig Guð birtist honum í brennandi runna. Hann talar um að Guð sé „Guð Abrahams, Guð Ísaks og Guð Jakobs.“ Ef við segjum að Drottinn sé Guð einhvers manns, þá þýðir það að sá maður er lifandi en ekki dauður! Því Guð er sá sem gefur lífið.“ ");
INSERT INTO isl_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","„Þetta er vel sagt, herra,“ sögðu nokkrir lögvitringar sem þar stóðu. ");
INSERT INTO isl_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","En fleiri urðu spurningarnar ekki, því þeir þorðu ekki að spyrja hann neins! ");
INSERT INTO isl_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nú lagði Jesús spurningu fyrir þá og sagði: „Af hverju segið þið að Kristur sé afkomandi Davíðs konungs? ");
INSERT INTO isl_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Davíð sagði í Sálmunum: „Guð sagði við minn Drottin: „Sittu mér til hægri handar, þar til ég legg óvini þína að fótum þér.“ “ ");
INSERT INTO isl_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Hvernig getur Kristur verið hvort tveggja í senn, sonur Davíðs og Drottinn Davíðs?“ ");
INSERT INTO isl_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Síðan sneri hann sér að lærisveinum sínum og sagði við þá, svo að fólkið heyrði: ");
INSERT INTO isl_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","„Gætið ykkar á þessum fræðimönnum! Þeir njóta þess að ganga um göturnar í fínum fötum og láta fólk hneigja sig fyrir sér. Þeim finnst vænt um heiðurssætin í samkomuhúsum og hátíðarveislum. ");
INSERT INTO isl_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","En meðan þeir þylja sínar löngu bænir með helgisvip, eru þeir jafnvel að hugsa upp ráð til að hafa fé af ekkjum. Guð mun því dæma þessa menn til hinnar þyngstu refsingar.“ ");
INSERT INTO isl_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús stóð í musterinu og virti fyrir sér auðmenn sem voru að bera fram gjafir til musterisins. ");
INSERT INTO isl_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Þá kom þar að fátæk ekkja sem gaf tvo litla koparpeninga. ");
INSERT INTO isl_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","„Þessi fátæka ekkja hefur gefið meira en allir hinir samanlagt,“ sagði Jesús. ");
INSERT INTO isl_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","„Þeir gáfu smábrot af öllum auðæfum sínum, en hún, fátæklingurinn, gaf allt sem hún átti.“ ");
INSERT INTO isl_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nú fóru nokkrir lærisveinanna að tala um fegurð musterisins og höggmyndirnar á veggjum þess. ");
INSERT INTO isl_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","„Sú stund kemur,“ sagði Jesús, „er allt þetta sem þið nú dáist að verður brotið niður, svo að ekki mun standa steinn yfir steini, heldur verða þar rústir einar.“ ");
INSERT INTO isl_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","„Meistari!“ hrópuðu þeir, „hvenær verður þetta? Verðum við varaðir við?“ ");
INSERT INTO isl_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús svaraði: „Látið engan villa ykkur sýn. Margir munu koma og kalla sig Krist og segja: „Stundin er komin.“ En trúið þeim ekki! ");
INSERT INTO isl_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Og þegar þið heyrið um stríð og byltingar, þá verið ekki hræddir. Satt er það að styrjaldir verða, en endirinn er ekki þar með kominn. ");
INSERT INTO isl_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Því að þjóð mun rísa gegn þjóð og ríki gegn ríki. ");
INSERT INTO isl_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Og miklir jarðskjálftar, hungursneyð og farsóttir munu verða vítt um heim. ");
INSERT INTO isl_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","En áður en þetta gerist, munu verða miklar ofsóknir. Mín vegna verðið þið dregnir inn í samkomuhús, fangelsi og fram fyrir konunga og landshöfðingja. ");
INSERT INTO isl_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Þetta mun verða til þess að nafn Krists verður kunnugt og vegsamað. ");
INSERT INTO isl_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Verið því ekki að hugsa um hvernig þið eigið að svara ákærunum. ");
INSERT INTO isl_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Því ég mun gefa ykkur rétt orð að mæla og slíka rökfimi, að mótstöðumenn ykkar munu verða orðlausir! ");
INSERT INTO isl_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Þeir sem ykkur standa næst – foreldrar, bræður, ættingjar og vinir – munu svíkja ykkur í hendur óvina og sumir ykkar verða líflátnir. ");
INSERT INTO isl_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Þið verðið hataðir af öllum mín vegna og vegna þess að þið eruð kenndir við mig. ");
INSERT INTO isl_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","En ekkert hár á höfði ykkar skal þó farast! ");
INSERT INTO isl_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Með stöðuglyndi munuð þið bjarga sálum ykkar. ");
INSERT INTO isl_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Þegar þið sjáið Jerúsalem umkringda hersveitum, þá vitið þið að tími eyðileggingarinnar er nálægur. ");
INSERT INTO isl_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Þá eiga þeir sem eru í Júdeu að flýja til fjalla. Þeir sem þá verða í Jerúsalem ættu að reyna að flýja og þeir sem eru utan við borgina eiga alls ekki að gera tilraun til að fara inn í hana. ");
INSERT INTO isl_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Þessa daga mun dómi Guðs verða fullnægt. Orð Biblíunnar, sem skráð voru af hinum fornu spámönnum, munu vissulega rætast. ");
INSERT INTO isl_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Þá verða hræðilegir tímar fyrir verðandi mæður og þær sem þá verða með börn á brjósti. Miklar hörmungar munu dynja yfir þessa þjóð og mikil reiði blossa upp gegn henni. ");
INSERT INTO isl_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Fólkið verður stráfellt og sumt tekið til fanga, og sent í útlegð út um allan heim. Jerúsalem verður sigruð og fótum troðin af heiðingjunum, þar til yfirráðatími þeirra er liðinn. ");
INSERT INTO isl_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Þá munu gerast einkennilegir hlutir á himninum – illir fyrirboðar. Fyrirboðar þessir verða á sólu, tungli og stjörnum, en á jörðinni birtast þeir sem angist meðal þjóðanna, í vanmætti við brimgný og flóð. ");
INSERT INTO isl_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Margir munu missa kjarkinn vegna þeirra skelfilegu atburða sem þeir sjá gerast í heiminum – því jafnvægi himintunglanna mun raskast. ");
INSERT INTO isl_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Og þá munu þjóðir jarðarinnar sjá mig, Krist, koma í skýi með mætti og mikilli dýrð. ");
INSERT INTO isl_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Þegar þetta tekur að gerast, þá réttið úr ykkur og lítið upp, því að þá er hjálp ykkar á næsta leiti.“ ");
INSERT INTO isl_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Síðan sagði hann þeim líkingu: „Takið eftir trjánum. ");
INSERT INTO isl_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Þegar laufin fara að springa út, þá vitið þið að sumarið er í nánd. ");
INSERT INTO isl_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Og þegar þið sjáið þessa atburði gerast, sem ég var að lýsa fyrir ykkur, þá vitið þið á sama hátt að guðsríki er í nánd. ");
INSERT INTO isl_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ég segi ykkur satt: Þessi kynslóð mun alls ekki deyja fyrr en allt þetta er komið fram. ");
INSERT INTO isl_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","En þótt himinn og jörð líði undir lok, munu orð mín standa óhögguð að eilífu. ");
INSERT INTO isl_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Gætið ykkar! Látið endurkomu mína ekki koma ykkur í opna skjöldu; látið mig ekki rekast á ykkur eins og alla aðra, andvaralausa, við veisluhöld, drykkjuskap og niðursokkna í áhyggjur lífsins. ");
INSERT INTO isl_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Verið á verði og biðjið, að ef mögulegt er, þá mættuð þið komast hjá þessum hörmungum og standast frammi fyrir mér.“ ");
INSERT INTO isl_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","38","Á hverjum degi fór Jesús upp í musterið til að kenna og snemma á morgnana tók fólkið að hópast þangað til að hlýða á hann. Á kvöldin sneri hann svo aftur, því að náttstaður hans var á Olíufjallinu. ");
INSERT INTO isl_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nú voru páskarnir í nánd. Þeir eru mesta hátíð Gyðinga og þá eru einungis borðuð ósýrð brauð. ");
INSERT INTO isl_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Æðstu prestarnir og fræðimennirnir voru að velta því fyrir sér hvernig þeir gætu ráðið Jesú af dögum. En þeir óttuðust að fólkið svaraði með því að gera uppreisn. ");
INSERT INTO isl_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Þegar þetta var fór Satan í Júdas Ískaríot, einn af þeim tólf. ");
INSERT INTO isl_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Júdas kom að máli við æðstu prestana og varðstjóra musterisins til að ræða um hvernig hann ætti að koma Jesú í hendur þeirra. ");
INSERT INTO isl_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Þeir urðu glaðir þegar þeir heyrðu að hann væri fús að hjálpa þeim og hétu honum launum. ");
INSERT INTO isl_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Upp frá þessu beið Júdas eftir hentugu tækifæri til að handtaka Jesú í kyrrþey þegar fólkið væri hvergi nærri. ");
INSERT INTO isl_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Dagurinn fyrir páska rann upp – dagur ósýrðu brauðanna – en þá átti að slátra páskalambinu og borða það með ósýrða brauðinu. ");
INSERT INTO isl_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesús sendi Pétur og Jóhannes af stað til að finna húsnæði þar sem þeir gætu undirbúið páskamáltíðina. ");
INSERT INTO isl_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","„Hvert viltu að við förum?“ spurðu þeir. ");
INSERT INTO isl_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","„Þegar þið komið inn í Jerúsalem,“ svaraði Jesús, „mun mæta ykkur maður sem ber vatnskrús. Fylgið honum eftir þangað sem hann fer ");
INSERT INTO isl_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","og segið húsráðanda þar: „Við erum með skilaboð frá meistara okkar, um að þú sýnir okkur herbergið þar sem hann geti snætt páskamáltíðina með lærisveinum sínum.“ ");
INSERT INTO isl_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Þá mun hann fara með ykkur upp í stórt herbergi sem okkur er ætlað. Það er staðurinn. Farið nú og undirbúið máltíðina.“ ");
INSERT INTO isl_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Þeir fóru til borgarinnar og fundu allt eins og Jesús hafði sagt og undirbjuggu páskamáltíðina. ");
INSERT INTO isl_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Á tilsettum tíma kom Jesús og settist til borðs og postularnir með honum. ");
INSERT INTO isl_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Hann sagði: „Ég hef innilega þráð að neyta þessarar páskamáltíðar með ykkur áður en ég líð, ");
INSERT INTO isl_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","því að það segi ég ykkur að ég mun ekki neyta hennar aftur, fyrr en hún fullkomnast í guðsríki.“ ");
INSERT INTO isl_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Þá tók Jesús bikar, flutti þakkarbæn og sagði: „Takið þetta og skiptið því á milli ykkar. ");
INSERT INTO isl_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ég mun ekki drekka vín á ný fyrr en guðsríki er komið.“ ");
INSERT INTO isl_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Og hann tók brauð, þakkaði Guði og braut það í sundur, fékk þeim og sagði: „Þetta er líkami minn, sem fyrir ykkur er gefinn, gerið þetta í mína minningu.“ ");
INSERT INTO isl_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Á sama hátt tók hann bikarinn eftir kvöldmáltíðina og mælti: „Þessi bikar er hinn nýi sáttmáli í mínu blóði sem fyrir ykkur er úthellt. ");
INSERT INTO isl_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Sá er svíkur mig, situr hér til borðs með mér. ");
INSERT INTO isl_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Að vísu verð ég að deyja, það er liður í áætlun Guðs, en vei þeim manni sem veldur því að ég verð framseldur.“ ");
INSERT INTO isl_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Þá fóru lærisveinarnir að þrátta sín á milli um það hver þeirra gæti fengið sig til slíks, ");
INSERT INTO isl_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","og líka um það hver þeirra gæti talist mestur. ");
INSERT INTO isl_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Þá sagði Jesús: „Konungar þjóðanna drottna yfir þeim og þeir sem láta menn kenna á valdi sínu eru nefndir velgjörðamenn. ");
INSERT INTO isl_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","En meðal ykkar er sá mestur sem þjónar hinum. ");
INSERT INTO isl_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Í heiminum er það foringinn sem situr við borðið og þjónar hans ganga um beina. En hjá okkur er þetta öðruvísi. Ég þjóna ykkur. ");
INSERT INTO isl_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Þið hafið ekki brugðist mér þennan erfiða tíma. ");
INSERT INTO isl_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","En eins og faðir minn hefur gefið mér ríki sitt, eins gef ég ykkur það svo að þið getið ");
INSERT INTO isl_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","etið og drukkið við borð mitt í ríki mínu. Þið munuð sitja í hásætum og dæma hinar tólf ættkvíslir Ísraels. ");
INSERT INTO isl_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Símon, Símon, Satan krafðist þín til að sigta þig eins og hveiti, ");
INSERT INTO isl_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","en ég hef beðið þess að trú þína þrjóti ekki að fullu og öllu. Styrk þú bræður þína þegar þú hefur iðrast og snúið aftur til mín.“ ");
INSERT INTO isl_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Símon svaraði: „Drottinn, ég er reiðubúinn að fara með þér í fangelsi og jafnvel deyja með þér.“ ");
INSERT INTO isl_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","„Pétur,“ svaraði Jesús, „ég skal segja þér nokkuð. Haninn mun ekki gala í dag fyrr en þú hefur þrisvar neitað því að þú þekkir mig.“ ");
INSERT INTO isl_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Og Jesús hélt áfram og sagði: „Þegar ég sendi ykkur í predikunarferðir, peningalausa, nestislausa og án þess að þið hefðuð skó til skiptanna, skorti ykkur þá nokkuð?“ „Nei, ekkert,“ svöruðu þeir. ");
INSERT INTO isl_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","„En núna“ sagði hann, „skuluð þið taka með ykkur nestispoka, ef þið eigið, og peninga. Ef þið eigið ekkert sverð, þá seljið jafnvel fötin ykkar til að geta keypt sverð. ");
INSERT INTO isl_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Þetta segi ég, því að nú er þessi spádómur að rætast: „Hann mun dæmdur sem afbrotamaður.“ Allt sem spámennirnir skrifuðu um mig mun rætast.“ ");
INSERT INTO isl_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","„Meistari“ svöruðu þeir, „við höfum hérna tvö sverð.“ „Það er nóg,“ svaraði hann. ");
INSERT INTO isl_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Síðan yfirgaf Jesús loftherbergið í fylgd lærisveinanna og fór eftir venju út til Olíufjallsins. ");
INSERT INTO isl_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Þegar þangað kom sagði hann: „Biðjið Guð að þið fallið ekki í freistni.“ ");
INSERT INTO isl_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","42","Hann fór spölkorn frá þeim, kraup niður og bað: „Faðir, ef þú vilt, þá taktu þennan bikar frá mér. Verði þó ekki minn vilji, heldur þinn.“ ");
INSERT INTO isl_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Þá birtist honum engill af himni sem styrkti hann. ");
INSERT INTO isl_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Því að hann var í slíkri dauðans angist að sviti hans varð eins og blóðdropar sem féllu á jörðina og bæn hans varð enn ákafari. ");
INSERT INTO isl_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Að lokum stóð hann upp, gekk til lærisveinanna og fann þá sofandi. Þeir höfðu sofnað af þreytu og hryggð. ");
INSERT INTO isl_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","„Hví sofið þið?“ spurði hann, „Rísið upp og biðjið þess að þið fallið ekki fyrir freistingunni.“ ");
INSERT INTO isl_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Hann hafði ekki sleppt orðinu, er hóp manna bar þar að. Fremstur gekk Júdas, einn postulanna. Hann gekk til Jesú og kyssti hann vingjarnlega á kinnina. ");
INSERT INTO isl_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesús sagði við hann: „Júdas, svíkur þú mig með kossi.“ ");
INSERT INTO isl_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Þegar lærisveinarnir ellefu skildu hvað um var að vera, hrópuðu þeir: „Meistari, eigum við að berjast? Við tókum sverðin með okkur.“ ");
INSERT INTO isl_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Einn þeirra brá sverði og hjó hægra eyrað af þjóni æðsta prestsins. ");
INSERT INTO isl_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","En Jesús sagði: „Sýnið enga frekari mótstöðu.“ Síðan snerti hann sárið og læknaði eyrað. ");
INSERT INTO isl_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesús sneri sér nú að æðstu prestunum, varðforingjum musterisins og trúarleiðtogum, sem fremstir stóðu, og spurði: „Er ég þá ræningi? Hvers vegna komið þið með sverð og kylfur til að handsama mig? ");
INSERT INTO isl_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Af hverju handtókuð þið mig ekki í musterinu? Þar var ég daglega. En þetta er ykkar tími og vald myrkraaflanna.“ ");
INSERT INTO isl_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Þá gripu þeir Jesú og leiddu til bústaðar æðsta prestsins. Pétur fylgdi í humátt á eftir. ");
INSERT INTO isl_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Hermennirnir kveiktu bál í húsagarðinum og settust umhverfis það til að hlýja sér, en Pétur smeygði sér inn í hópinn svo lítið bar á. ");
INSERT INTO isl_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Við bjarmann frá eldinum tók ein þjónustustúlkan eftir honum og gaf honum nánar gætur. Loks sagði hún: „Þessi maður var með Jesú.“ ");
INSERT INTO isl_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","„Nei, kona góð,“ svaraði Pétur, „þann mann þekki ég alls ekki.“ ");
INSERT INTO isl_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Stuttu seinna tók einhver annar eftir honum og sagði: „Þú hlýtur að vera einn af þeim.“ „Nei, herra minn, það er ég ekki,“ svaraði Pétur. ");
INSERT INTO isl_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Um það bil klukkustundu síðar fullyrti enn einn þetta og sagði: „Ég veit að þessi maður er einn af lærisveinum Jesú, því að þeir eru báðir frá Galíleu.“ ");
INSERT INTO isl_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","„Góði maður“ svaraði Pétur, „ég skil bara alls ekki hvað þú ert að tala um.“ En áður en hann hafði sleppt orðinu gól hani. ");
INSERT INTO isl_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Á sömu stundu sneri Jesús sér við og leit til Péturs. Þá minntist Pétur orða Jesú: „Áður en haninn galar í dag, muntu þrisvar afneita mér.“ ");
INSERT INTO isl_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Þá gekk Pétur út fyrir og grét sárt. ");
INSERT INTO isl_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Verðirnir sem gættu Jesú, tóku nú að hæða hann. Þeir bundu fyrir augu hans, slógu hann með hnefunum og spurðu: „Hver sló þig núna, spámaður?“ ");
INSERT INTO isl_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Síðan smánuðu þeir hann á allan hátt. ");
INSERT INTO isl_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Í morgunsárið kom hæstiréttur Gyðinga saman. Í honum voru meðal annars æðstu prestarnir og aðrir trúarleiðtogar þjóðarinnar. Jesús var nú leiddur fram fyrir þetta ráð ");
INSERT INTO isl_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","68","og spurður hvort hann héldi því fram að hann væri Kristur. „Þó ég segi ykkur það“ svaraði hann, „þá trúið þið mér ekki og munuð ekki heldur leyfa mér að flytja mál mitt. ");
INSERT INTO isl_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","En innan skamms mun ég, Kristur, setjast í hásæti við hlið almáttugs Guðs.“ ");
INSERT INTO isl_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","„Með þessu ertu að fullyrða að þú sért sonur Guðs,“ hrópuðu þeir. „Já“ svaraði hann, „ég er hann.“ ");
INSERT INTO isl_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","„Við þurfum ekki fleiri vitni!“ æptu þeir. „Við höfum sjálfir heyrt hann segja það.“ ");
INSERT INTO isl_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Síðan lagði allt ráðið af stað með Jesú til Pílatusar landstjóra. ");
INSERT INTO isl_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Er þangað kom, byrjuðu þeir strax að ákæra hann: „Þessi maður var að leiða þjóðina afvega. Hann segir að enginn eigi að borga skatta til rómversku yfirvaldanna og sjálfur segist hann vera Kristur konungurinn.“ ");
INSERT INTO isl_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","„Ert þú Kristur – konungur þeirra?“ spurði Pílatus. „Já,“ svaraði Jesús, „það er eins og þú segir.“ ");
INSERT INTO isl_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Þá sneri Pílatus sér að æðstu prestunum og mannfjöldanum og sagði: „Ég finn alls enga sök hjá honum.“ ");
INSERT INTO isl_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Þá æstust þeir um allan helming og sögðu: „Hann æsir til andófs gegn yfirvöldunum hvar sem hann fer, um allt skattlandið, allt frá Galíleu þar sem hann byrjaði og hingað til Jerúsalem.“ ");
INSERT INTO isl_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","„Er hann frá Galíleu?“ spurði Pílatus. ");
INSERT INTO isl_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Þegar þeir játuðu því, sagði hann þeim að fara með Jesú til Heródesar konungs, því að Galílea væri lögsagnarumdæmi hans. Og þannig vildi til að Heródes var staddur í Jerúsalem um þetta leyti. ");
INSERT INTO isl_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Heródesi þótti gaman að fá tækifæri til að sjá Jesú, því að hann hafði heyrt margt um hann og vonaðist til að sjá hann gera kraftaverk. ");
INSERT INTO isl_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Hann spurði Jesú fjölmargra spurninga, en fékk ekkert svar. ");
INSERT INTO isl_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Á meðan stóðu æðstu prestarnir og hinir trúarleiðtogarnir þar hjá og ákærðu hann harðlega. ");
INSERT INTO isl_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Síðan tóku Heródes og hermenn hans að hæða Jesú og spotta. Þeir klæddu hann í konunglega skikkju og sendu hann síðan aftur til Pílatusar. ");
INSERT INTO isl_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Þennan dag urðu Heródes og Pílatus vinir – en áður höfðu þeir verið svarnir óvinir. ");
INSERT INTO isl_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nú kallaði Pílatus saman æðstu prestana og leiðtoga Gyðinganna, ásamt fólkinu ");
INSERT INTO isl_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","og kunngjörði úrskurð sinn: „Þið komuð hingað með þennan mann og ákærðuð hann fyrir að stjórna uppreisn gegn rómversku yfirvöldunum. Ég hef rannsakað mál hans gaumgæfilega og komist að þeirri niðurstöðu að hann sé saklaus. ");
INSERT INTO isl_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Heródes er mér sammála og hann sendi hann aftur til okkar. Þessi maður hefur ekkert gert sem dauða er vert. ");
INSERT INTO isl_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Ég ætla því að láta húðstrýkja hann og sleppa honum síðan, enda er venja að náða einn fanga á páskunum.“ ");
INSERT INTO isl_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Þá kvað við hávært óp frá mannþyrpingunni – allir hrópuðu sem einn maður: „Burt með hann! Krossfestu hann! En slepptu Barrabasi.“ ");
INSERT INTO isl_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barrabas sat í fangelsi fyrir að vekja uppþot í Jerúsalem gegn yfirvöldunum og fyrir manndráp.) ");
INSERT INTO isl_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pílatus reyndi nú að sannfæra þá, því að hann vildi sleppa Jesú ");
INSERT INTO isl_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","en þeir hrópuðu á móti: „Krossfestu hann! Krossfestu hann!“ ");
INSERT INTO isl_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Enn einu sinni – í þriðja sinn – spurði Pílatus ákveðinn: „Hvers vegna? Hvaða glæp hefur hann drýgt? Ég sé enga ástæðu til að dæma hann til dauða. Ég ætla því að láta húðstrýkja hann og sleppa honum síðan.“ ");
INSERT INTO isl_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Þá heimtuðu þeir aftur að Jesús yrði krossfestur og urðu hróp þeirra svo hávær að þau yfirgnæfðu allt annað. ");
INSERT INTO isl_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Þá dæmdi Pílatus Jesú til dauða, eins og fólkið krafðist, ");
INSERT INTO isl_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","en sleppti Barrabasi samkvæmt ósk þess – manninum sem sat í fangelsi fyrir óeirðir og manndráp. Síðan afhenti hann þeim Jesú, svo að þeir gætu gert við hann það sem þeir vildu. ");
INSERT INTO isl_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Þegar hópurinn var lagður af stað með Jesú til aftökustaðarins, var maður sem var að koma utan úr sveit, Símon frá Kýrene, þvingaður til að bera kross hans. ");
INSERT INTO isl_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mikill mannfjöldi fylgdi á eftir, þar á meðal margar grátandi konur. ");
INSERT INTO isl_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesús sneri sér við og sagði við þær: „Jerúsalemdætur, þið skuluð ekki gráta mín vegna, heldur vegna ykkar sjálfra og barna ykkar. ");
INSERT INTO isl_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Þeir dagar munu koma er barnlausar konur verða taldar heppnar. ");
INSERT INTO isl_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Þá munu menn biðja fjöllin um að hrynja yfir sig og hæðirnar að hylja sig, ");
INSERT INTO isl_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","því að ef þetta er gert við mig, hið lifandi tré, hvernig mun þá fara fyrir ykkur.“ ");
INSERT INTO isl_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","33","Ásamt Jesú voru tveir afbrotamenn leiddir til aftökustaðarins sem hét „Hauskúpa“. Þar voru þeir allir krossfestir, Jesús í miðið, en hinir tveir sinn til hvorrar handar. ");
INSERT INTO isl_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Þá sagði Jesús: „Faðir, fyrirgef þeim, því þeir vita ekki hvað þeir gera.“ Hermennirnir köstuðu nú hlutkesti um föt Jesú, eina flík í senn. ");
INSERT INTO isl_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Fólkið stóð og fylgdist með, en leiðtogar þjóðarinnar gerðu gys að honum og sögðu: „Hann gat hjálpað öðrum, en nú ætti hann að hjálpa sjálfum sér og sanna með því að hann sé í raun og veru Kristur, útvalinn konungur Guðs.“ ");
INSERT INTO isl_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Hermennirnir hæddu hann líka með því að rétta honum súrt vín að drekka. ");
INSERT INTO isl_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Þeir hrópuðu: „Ef þú ert konungur Gyðinga, bjargaðu þá sjálfum þér.“ ");
INSERT INTO isl_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Fyrir ofan hann var neglt spjald á krossinn. Þar stóð: „Þessi er konungur Gyðinga.“ ");
INSERT INTO isl_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Annar afbrotamannanna, sem hékk við hlið hans, sendi honum háðsglósu og sagði: „Svo þú ert Kristur, er það ekki? Sannaðu það þá með því að bjarga sjálfum þér – og okkur.“ ");
INSERT INTO isl_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","41","Hinn glæpamaðurinn mótmælti þeim fyrri og sagði: „Óttastu ekki einu sinni Guð á dauðastundinni? Við höfum unnið til þessarar þungu refsingar, en þessi maður hefur ekkert rangt aðhafst.“ ");
INSERT INTO isl_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Síðan sneri hann sér að Jesú og sagði: „Jesú, minnstu mín þegar þú kemur í ríki þitt.“ ");
INSERT INTO isl_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús svaraði: „Ég lofa þér því, að í dag skaltu vera með mér í Paradís.“ ");
INSERT INTO isl_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nú var komið hádegi, en þá varð dimmt um allt landið fram til klukkan þrjú, ");
INSERT INTO isl_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","því að sólin myrkvaðist. Þá gerðist það að fortjaldið í musterinu rifnaði í tvennt. ");
INSERT INTO isl_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Þá hrópaði Jesús: „Faðir, í þínar hendur fel ég anda minn,“ og að svo mæltu dó hann. ");
INSERT INTO isl_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Þegar rómverski herforinginn, sem stjórnaði aftökunum, sá hvað gerðist, varð hann hræddur og sagði: „Ég er viss um að þessi maður hefur verið saklaus.“ ");
INSERT INTO isl_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Þegar fólkið, sem kom til að fylgjast með krossfestingunni, sá að Jesús var dáinn, fór það heim harmi slegið. ");
INSERT INTO isl_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Meðan þetta gerðist, stóðu vinir Jesú og konurnar, sem fylgt höfðu honum frá Galíleu, álengdar og fylgdust með. ");
INSERT INTO isl_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","52","Maður nokkur frá Arímaþeu, Jósef að nafni, kunnur ráðherra, fór til Pílatusar og bað um líkama Jesú. Hann var guðrækinn maður, sem vænti komu Krists og hafði verið ósammála hinum um hvað gera skyldi við Jesú. ");
INSERT INTO isl_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Hann tók því líkama Jesú niður af krossinum og vafði í léreftsdúk og lagði síðan í nýja gröf sem höggvin hafði verið í klett. ");
INSERT INTO isl_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Þetta gerðist síðdegis á föstudegi, aðfangadegi páska, á sama tíma og fólk var að undirbúa hátíðina. ");
INSERT INTO isl_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Konurnar sáu er líkaminn var tekinn niður og fylgdust með þegar hann var lagður í gröfina. ");
INSERT INTO isl_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Síðan fóru þær heim og tilreiddu kryddjurtir og smyrsl til að smyrja hann með. Í þann mund er þær höfðu lokið verki sínu, gekk hátíðin í garð. Þær héldu kyrru fyrir það kvöld og næsta dag, eins og krafist var í lögunum. ");
INSERT INTO isl_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Mjög snemma á sunnudagsmorgni fóru konurnar með smyrslin til grafarinnar. ");
INSERT INTO isl_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Þá sáu þær að stóra steininum, sem var fyrir grafardyrunum, hafði verið velt frá. ");
INSERT INTO isl_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Þær fóru inn í gröfina og sáu að líkami Drottins Jesú var horfinn. ");
INSERT INTO isl_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Þær skildu ekkert í þessu og reyndu að ímynda sér hvað orðið hefði um hann. En skyndilega birtust tveir menn hjá þeim, í skínandi hvítum klæðum, svo að þær fengu ofbirtu í augun. ");
INSERT INTO isl_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Þær urðu skelfingu lostnar, hneigðu sig og huldu andlit sín. Mennirnir spurðu: „Hvers vegna leitið þið hans sem er lifandi, meðal hinna dauðu? ");
INSERT INTO isl_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Hann er ekki hér. Hann er upprisinn! Munið þið ekki hvað hann sagði við ykkur í Galíleu. Að Kristur yrði svikinn í hendur vondra manna, sem myndu krossfesta hann, en eftir það mundi hann rísa upp á þriðja degi.“ ");
INSERT INTO isl_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Þá minntust þær orða hans ");
INSERT INTO isl_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","og flýttu sér aftur til Jerúsalem til að segja lærisveinunum ellefu – og öllum hinum – hvað gerst hafði. ");
INSERT INTO isl_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Konurnar sem fóru til grafarinnar voru þær María Magdalena, Jóhanna, María móðir Jakobs og nokkrar aðrar. ");
INSERT INTO isl_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","En lærisveinarnir trúðu ekki frásögn þeirra. ");
INSERT INTO isl_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Samt sem áður hljóp Pétur út að gröfinni til að athuga þetta. Hann nam staðar úti fyrir gröfinni og leit inn, en sá ekkert nema léreftsdúkinn. Pétur varð mjög undrandi og fór aftur heim. ");
INSERT INTO isl_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Þennan sama sunnudag fóru tveir af fylgjendum Jesú gangandi til þorpsins Emmaus, sem er rúma 12 kílómetra frá Jerúsalem. ");
INSERT INTO isl_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Á leiðinni ræddu þeir saman um atburði þessa. ");
INSERT INTO isl_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Þá kom Jesús sjálfur til þeirra og slóst í för með þeim, ");
INSERT INTO isl_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","en þeir þekktu hann ekki ( – það var eins og Guð héldi því leyndu fyrir þeim). ");
INSERT INTO isl_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","„Um hvað eruð þið að tala, svona áhyggjufullir?“ spurði Jesús. Þeir námu staðar rétt sem snöggvast, daprir á svip. ");
INSERT INTO isl_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kleófas, annar þeirra, varð fyrir svörum og sagði: „Þú hlýtur að vera eini maðurinn í Jerúsalem, sem ekki hefur heyrt um hina hræðilegu atburði sem þar hafa gerst undanfarna daga.“ ");
INSERT INTO isl_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","„Hvað þá?“ spurði Jesús. „Jú, þetta með Jesú, manninn frá Nasaret,“ sögðu þeir. „Hann var spámaður, sem gerði ótrúleg kraftaverk, og frábær kennari. Hann var virtur bæði af Guði og mönnum. ");
INSERT INTO isl_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","En æðstu prestarnir og leiðtogar þjóðar okkar handtóku hann og framseldu rómversku yfirvöldunum, sem dæmdu hann til dauða og krossfestu hann. ");
INSERT INTO isl_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Við héldum að hann væri Kristur og að hann hefði komið til að bjarga Ísrael. Þetta gerðist fyrir þrem dögum, ");
INSERT INTO isl_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","en nú snemma í morgun fóru nokkrar konur úr hópi okkar, fylgjenda hans, út að gröfinni. Komu síðan aftur með þær furðulegu fréttir að líkami hans væri horfinn og að þær hefðu séð engla, sem sögðu að hann væri á lífi! ");
INSERT INTO isl_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Sumir okkar hlupu þangað til að gá að því og það reyndist rétt – líkami Jesú var horfinn eins og konurnar höfðu sagt.“ ");
INSERT INTO isl_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Þá sagði Jesús: „Æ, skelfing eruð þið heimskir og tregir! Hvers vegna eigið þið svona erfitt með að trúa því sem Biblían segir? ");
INSERT INTO isl_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Sögðu spámennirnir það ekki greinilega fyrir að Kristur yrði að þjást á þennan hátt, áður en hann gengi inn í dýrð sína?“ ");
INSERT INTO isl_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Síðan vitnaði Jesús í hvert spámannaritið á fætur öðru. Hann byrjaði á fyrstu Mósebók og svo áfram í gegnum Gamla testamentið og útskýrði fyrir þeim hvað þar væri sagt um hann sjálfan. ");
INSERT INTO isl_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nú var stutt eftir á leiðarenda. Jesús lét sem hann ætlaði lengra, ");
INSERT INTO isl_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","en þeir margbáðu hann að gista hjá sér, því það var orðið framorðið. Hann lét undan og fór með þeim. ");
INSERT INTO isl_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Þeir settust niður til að borða og Jesús flutti þakkarbæn yfir matnum. Síðan tók hann brauð, braut það og rétti þeim. ");
INSERT INTO isl_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Þá var eins og augu þeirra opnuðust og þeir þekktu hann. En þá hvarf hann þeim sýnum. ");
INSERT INTO isl_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Þeir tóku að ræða saman um hve vel þeim hefði liðið meðan hann talaði við þá úti á veginum og útskýrði fyrir þeim Biblíuna. ");
INSERT INTO isl_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","34","Og þeir biðu ekki boðanna, en lögðu af stað aftur til Jerúsalem. Þar fögnuðu postularnir ellefu þeim og aðrir vinir Jesú, með þessum orðum: „Drottinn er sannarlega upprisinn! Hann hefur birst Pétri.“ ");
INSERT INTO isl_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Lærisveinarnir tveir frá Emmaus sögðu þeim þá hvernig Jesús hafði birst þeim er þeir voru á leiðinni og hvernig þeir hefðu þekkt hann þegar hann braut brauðið. ");
INSERT INTO isl_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Allt í einu, meðan þeir voru að tala um þetta, stóð Jesús sjálfur mitt á meðal þeirra, heilsaði þeim og sagði: „Friður sé með ykkur.“ ");
INSERT INTO isl_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Lærisveinarnir urðu skelfingu lostnir og héldu að þeir sæju vofu! ");
INSERT INTO isl_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","„Hvers vegna eruð þið hræddir?“ spurði hann. „Hvers vegna efist þið um að þetta sé ég? ");
INSERT INTO isl_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Lítið á hendur mínar og fætur. Þið sjáið það sjálfir að þetta er ég. Komið við mig og gangið úr skugga um að ég er ekki vofa. Vofur hafa ekki líkama eins og þið sjáið mig hafa.“ ");
INSERT INTO isl_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Meðan hann var að tala, rétti hann út hendur sínar, svo að þeir gætu séð naglaförin, og hann sýndi þeim einnig særða fæturna. ");
INSERT INTO isl_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Þarna stóðu þeir og vissu ekki hverju þeir ættu að trúa. Þeir voru í senn fullir gleði og efasemda. „Hafið þið nokkuð að borða?“ spurði Jesús. ");
INSERT INTO isl_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Þeir réttu honum stykki af steiktum fiski, ");
INSERT INTO isl_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Sem hann neytti fyrir augum þeirra. ");
INSERT INTO isl_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Hann sagði: „Munið þið ekki að þegar ég var með ykkur, þá sagði ég ykkur að allt, sem skrifað væri um mig af Móse, spámönnunum og í Sálmunum, yrði að rætast.“ ");
INSERT INTO isl_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Síðan opnaði hann hjörtu þeirra til að þeir gætu skilið þessa staði í Biblíunni, ");
INSERT INTO isl_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","og sagði svo: „Fyrir löngu var ritað að Kristur yrði að líða og deyja og rísa síðan upp frá dauðum á þriðja degi, ");
INSERT INTO isl_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","og að svohljóðandi gleðiboðskapur ætti að berast frá Jerúsalem út til allra þjóða: Allir þeir sem iðrast og snúa sér til mín, munu fá fyrirgefningu syndanna. ");
INSERT INTO isl_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Þið hafið séð þessa spádóma rætast. ");
INSERT INTO isl_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ég mun senda heilagan anda yfir ykkur, eins og faðir minn lofaði. Segið engum frá þessu enn sem komið er, en bíðið hérna í borginni þar til heilagur andi kemur og fyllir ykkur krafti frá Guði.“ ");
INSERT INTO isl_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Eftir þetta fór Jesús með þá út að veginum, sem liggur til Betaníu, og þar lyfti hann höndum sínum til himins og blessaði þá. ");
INSERT INTO isl_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","En meðan hann var að blessa þá, hvarf hann sjónum þeirra og fór til himna. ");
INSERT INTO isl_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Lærisveinarnir tilbáðu hann og sneru aftur til Jerúsalem gagnteknir fögnuði. ");
INSERT INTO isl_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Þeir héldu sig síðan stöðugt í musterinu og lofuðu Guð.");
INSERT INTO isl_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Í upphafi, áður en nokkuð varð til, var Kristur hjá Guði. ");
INSERT INTO isl_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Hann hefur verið frá upphafi og sjálfur er hann Guð. ");
INSERT INTO isl_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Allt var skapað vegna hans og án hans varð ekkert til sem til er orðið. ");
INSERT INTO isl_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Í honum er eilíft líf, og þetta líf er ljós fyrir alla menn. ");
INSERT INTO isl_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Líf hans er ljósið sem skín í myrkrinu en myrkrið vill ekkert með það hafa. ");
INSERT INTO isl_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Guð sendi Jóhannes skírara til að vitna um að Jesús Kristur væri hið sanna ljós. ");
INSERT INTO isl_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ekki var Jóhannes ljósið, heldur átti hann að vitna um það. ");
INSERT INTO isl_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Seinna kom sá sem er hið sanna ljós, og hann vill lýsa upp líf sérhvers manns sem fæðist í þennan heim. ");
INSERT INTO isl_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Hann var í heiminum og heimurinn varð til hans vegna, en samt þekkti heimurinn hann ekki. ");
INSERT INTO isl_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","12","Honum var jafnvel hafnað í sínu eigin landi og af eigin þjóð – Gyðingum. Fáir tóku við honum, en öllum þeim sem það gerðu gaf hann rétt og kraft til að verða Guðs börn – þeim sem treystu því að hann gæti frelsað þá. ");
INSERT INTO isl_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Þeir, sem þannig trúa á hann, endurfæðast! Það er ekki líkamleg endurfæðing – afleiðing mannlegra hvata eða áforma – heldur andleg fæðing og samkvæmt vilja Guðs. ");
INSERT INTO isl_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kristur fæddist sem maður og bjó hér á jörðinni meðal okkar, fullur náðar og sannleika. Við sáum dýrð hans – dýrð eingetins sonar hins himneska föður. ");
INSERT INTO isl_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jóhannes benti fólkinu á hann og sagði: „Sá mun koma sem mér er æðri og var löngu á undan mér.“ ");
INSERT INTO isl_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Öll höfum við notið miskunnar hans og kærleika, náðar á náð ofan. ");
INSERT INTO isl_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Móse flutti okkur lögmálið með öllum þess ströngu kröfum og afdráttarlausa réttlæti, en náðin og sannleikurinn kom með Jesú Kristi. ");
INSERT INTO isl_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Enginn hefur nokkurn tíma séð Guð en einkasonur hans, sem stendur næst föðurnum, hefur kennt okkur að þekkja hann. ");
INSERT INTO isl_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Leiðtogar Gyðinga sendu nú presta og musterisþjóna frá Jerúsalem til að spyrja Jóhannes hvort hann væri Kristur, konungur Ísraels. ");
INSERT INTO isl_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","En því neitaði Jóhannes afdráttarlaust og sagði: „Ég er ekki Kristur.“ ");
INSERT INTO isl_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","„Hver ertu þá?“ spurðu þeir, „ertu Elía?“ „Nei,“ svaraði hann. „Ertu spámaðurinn?“ „Nei.“ ");
INSERT INTO isl_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","„Hver þá? Segðu okkur það, svo við getum svarað þeim sem sendu okkur. Hvað viltu segja um sjálfan þig?“ ");
INSERT INTO isl_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Hann svaraði: „Ég er rödd sem hrópar: „Búið ykkur undir komu Drottins!“ “ ");
INSERT INTO isl_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Þeir sem sendir voru frá faríseunum spurðu þá: „Fyrst þú ert hvorki Kristur, Elía né spámaðurinn, hvaða rétt hefur þú þá til að skíra?“ ");
INSERT INTO isl_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","„Ég skíri aðeins með vatni,“ svaraði Jóhannes, „en hér á meðal okkar er sá sem þið þekkið ekki. ");
INSERT INTO isl_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Hann mun brátt hefja starf sitt. Ég er ekki einu sinni verður þess að vera þræll hans.“ ");
INSERT INTO isl_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Þetta gerðist hjá Betaníu, þorpi austan við ána Jórdan, þar sem Jóhannes var að skíra. ");
INSERT INTO isl_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Daginn eftir sá Jóhannes Jesú koma gangandi í átt til sín. „Sjáið!“ sagði Jóhannes, „þarna er Guðs lambið sem tekur burt synd heimsins! ");
INSERT INTO isl_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ég átti við hann þegar ég sagði: „Sá mun koma sem mér er æðri og var á undan mér.“ ");
INSERT INTO isl_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","En ég vissi ekki að þetta væri hann. Mitt hlutverk er að skíra með vatni og benda Ísraelsþjóðinni á hann.“ ");
INSERT INTO isl_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Síðan sagði Jóhannes að hann hefði séð heilagan anda stíga niður af himni eins og dúfu og hvíla yfir honum. ");
INSERT INTO isl_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","„Ég vissi ekki að þetta væri hann,“ sagði Jóhannes aftur, „en þegar Guð sendi mig til að skíra sagði hann: „Þegar þú sérð heilagan anda koma niður og setjast á einhvern – þá er það sá sem þú leitar að. Hann mun skíra með heilögum anda.“ ");
INSERT INTO isl_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Þetta sá ég gerast núna á þessum manni og því segi ég: Hann er sonur Guðs.“ ");
INSERT INTO isl_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Daginn eftir var Jóhannes á sama stað ásamt tveim lærisveina sinna ");
INSERT INTO isl_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","og var Jesús þar aftur á gangi. Jóhannes horfði á hann og sagði: „Sjáið! Þarna er Guðs lambið!“ ");
INSERT INTO isl_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Lærisveinarnir tveir fóru þá á eftir Jesú. ");
INSERT INTO isl_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesús leit við, sá þá koma og spurði: „Hvað viljið þið?“ „Herra,“ svöruðu þeir, „hvar býrðu?“ ");
INSERT INTO isl_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","„Komið og þá sjáið þið það,“ svaraði hann. Síðan fóru þeir með honum þangað sem hann dvaldist og voru hjá honum frá því um fjögurleytið til kvölds. ");
INSERT INTO isl_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Annar þessara manna var Andrés, bróðir Símonar Péturs. ");
INSERT INTO isl_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrés fer nú að finna bróður sinn, Símon, og segir: „Við höfum fundið Krist!“ ");
INSERT INTO isl_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Og hann fór með hann til Jesú. Jesús leit á hann og sagði: „Þú ert Símon Jónasson, en nú skalt þú kallast Pétur, – kletturinn!“ ");
INSERT INTO isl_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Daginn eftir ákvað Jesús að fara til Galíleu. Þá hitti hann Filippus og sagði við hann: „Fylg þú mér.“ ");
INSERT INTO isl_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filippus var frá Betsaída, heimabæ Andrésar og Péturs. ");
INSERT INTO isl_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filippus fór að finna Natanael og sagði við hann: „Við höfum fundið Krist – þann sem Móse og spámennirnir töluðu um! Hann heitir Jesús Jósefsson og er frá Nasaret.“ ");
INSERT INTO isl_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","„Nasaret!“ hrópaði Natanael. „Getur nokkuð gott komið þaðan?“ „Komdu og sjáðu sjálfur,“ svaraði Filippus ákveðinn. ");
INSERT INTO isl_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Þegar þeir komu þangað sagði Jesús: „Hér kemur ósvikinn Ísraelsmaður.“ ");
INSERT INTO isl_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","„Hvaðan þekkir þú mig?“ spurði Natanael. „Ég sá þig undir fíkjutrénu, áður en Filippus kallaði á þig,“ svaraði Jesús. ");
INSERT INTO isl_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","„Herra! Þú ert sonur Guðs! – konungur Ísraels!“ sagði Natanael. ");
INSERT INTO isl_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","„Trúir þú bara vegna þess að ég sagðist hafa séð þig undir fíkjutrénu?“ spurði Jesús. „Þú skalt sjá það sem meira er. ");
INSERT INTO isl_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Þú munt jafnvel sjá himininn opinn og engla Guðs stíga upp og niður frammi fyrir mér.“ ");
INSERT INTO isl_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tveim dögum síðar var móðir Jesú boðin í brúðkaup til bæjarins Kana í Galíleu. ");
INSERT INTO isl_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesús var einnig boðinn, ásamt lærisveinum sínum. ");
INSERT INTO isl_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Meðan á veislunni stóð kláraðist vínið. Móðir Jesú gekk þá til hans og sagði honum þessi vandræði. ");
INSERT INTO isl_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","„Ég get ekki hjálpað þér núna,“ sagði hann, „minn tími er enn ekki kominn.“ ");
INSERT INTO isl_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","En móðir hans sagði við þjónana: „Gerið allt eins og hann segir ykkur.“ ");
INSERT INTO isl_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Þarna stóðu sex steinker, sem notuð voru við ákveðna trúarsiði, og tók hvert þeirra um hundrað lítra. ");
INSERT INTO isl_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","8","Jesús sagði nú þjónunum að fylla þau af vatni. Að því búnu sagði hann: „Takið nú smásopa af þessu og færið veislustjóranum.“ ");
INSERT INTO isl_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Þegar veislustjórinn bragðaði á vatninu, sem nú var orðið að víni, varð hann undrandi því hann vissi ekki hvaðan það var komið (þótt þjónarnir vissu það). Hann kallaði þá á brúðgumann. ");
INSERT INTO isl_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","„Þetta er frábært vín!“ sagði hann. „En þú ert ekki eins og aðrir. Flestir bera fyrst fram besta vínið, en þegar menn eru orðnir ölvaðir og kæra sig ekki um meira, þá eru teknar fram ódýru tegundirnar. Þú hefur hins vegar geymt það besta þar til síðast.“ ");
INSERT INTO isl_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Þetta fyrsta kraftaverk sitt gerði Jesús í Kana í Galíleu og opinberaði með því dýrð sína. Það varð til þess að lærisveinarnir trúðu að hann væri Kristur. ");
INSERT INTO isl_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Eftir brúðkaupið fór Jesús til Kapernaum, ásamt móður sinni, bræðrum og lærisveinum, og voru þau þar í nokkra daga. ");
INSERT INTO isl_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nú leið að páskum og hélt Jesús því til Jerúsalem. ");
INSERT INTO isl_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Á musterissvæðinu sá hann kaupmenn sem seldu nautgripi, kindur og dúfur, er nota átti sem fórnardýr. Þar sátu einnig menn við borð og skiptu peningum. ");
INSERT INTO isl_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesús bjó þá til svipu úr köðlum og rak þá alla út, einnig féð og nautgripina, dreifði smápeningum þeirra sem skiptu myntinni, út um allt gólf og velti um borðum þeirra. ");
INSERT INTO isl_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Því næst gekk hann til dúfnasalanna og sagði við þá: „Út með þetta! Þið hafið ekkert leyfi til að breyta húsi föður míns í markað!“ ");
INSERT INTO isl_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Þetta minnti lærisveinana á spádóm í Biblíunni, sem þannig hljóðar: „Umhyggja fyrir húsi Guðs mun ekki láta mig í friði.“ ");
INSERT INTO isl_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","„Hvaða rétt hefur þú til að reka þá út?“ spurðu leiðtogar fólksins hranalega. „Ef þú hefur vald þitt frá Guði, sýndu okkur þá kraftaverk því til sönnunar.“ ");
INSERT INTO isl_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","„Já,“ svaraði Jesús, „þetta kraftaverk skuluð þið fá: Brjótið þennan helgidóm niður og ég mun reisa hann á þrem dögum!“ ");
INSERT INTO isl_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","„Hvað þá!“ hrópuðu þeir. „Það tók fjörutíu og sex ár að byggja þetta musteri, en þykist þú geta reist það á þrem dögum?“ ");
INSERT INTO isl_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Með orðinu „helgidómur“ átti Jesús við líkama sinn. ");
INSERT INTO isl_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Eftir upprisu hans minntust lærisveinar hans þessara orða, og skildu að það sem hann tilnefndi úr Biblíunni, átti við hann sjálfan og rættist allt. ");
INSERT INTO isl_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Kraftaverkin sem Jesús gerði í Jerúsalem yfir páskahátíðina, sannfærðu marga um að hann væri í raun og veru Kristur. ");
INSERT INTO isl_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","En hann treysti ekki þessu fólki, því að hann þekkti hugsanir þess fullkomlega og vissi hve menn eru fljótir að skipta um skoðun! ");
INSERT INTO isl_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kvöld eitt, eftir að dimmt var orðið, ");
INSERT INTO isl_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","kom einn af ráðherrum Gyðinga, farísei að nafni Nikódemus, til Jesú að ræða við hann. „Herra,“ sagði hann, „við vitum allir að Guð hefur sent þig til að fræða okkur, það sanna kraftaverk þín svo að ekki verður um villst.“ ");
INSERT INTO isl_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","„Ég segi þér satt, Nikódemus,“ sagði Jesús, „ef þú endurfæðist ekki muntu aldrei komast inn í guðsríki.“ ");
INSERT INTO isl_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","„Endurfæðist?“ spurði Nikódemus, „hvað er nú það? Hvernig getur gamall maður komist aftur inn í kvið móður sinnar og fæðst að nýju?“ ");
INSERT INTO isl_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","„Það sem ég á við,“ svaraði Jesús, „er þetta: Ef maðurinn fæðist ekki af vatni og anda, getur hann ekki komist inn í guðsríki. ");
INSERT INTO isl_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Maður getur aðeins fætt af sér aðra mannveru, en heilagur andi gefur nýtt líf frá himnum. ");
INSERT INTO isl_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Vertu því ekki hissa þótt ég segi að þú verðir að fæðast að nýju! ");
INSERT INTO isl_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Þetta er eins og með vindinn. Þú heyrir í honum en veist samt ekki hvaðan hann kemur eða hvert hann fer. Þannig er það einnig með anda Guðs. Við vitum ekki hverjum hann gefur næst líf frá himni.“ ");
INSERT INTO isl_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","„Þetta get ég ekki skilið!“ svaraði Nikódemus. ");
INSERT INTO isl_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","11","„Þú ert mikils metinn kennari hér í Jerúsalem en samt skilur þú þetta ekki!“ sagði Jesús. „Ég er að segja þér það sem ég veit og hef séð, en samt trúir þú mér ekki. ");
INSERT INTO isl_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ef þú trúir mér ekki þegar ég segi þér frá hlutum sem gerast meðal manna, hvernig geturðu þá trúað ef ég segi þér frá himneskum hlutum? ");
INSERT INTO isl_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ég, Kristur, er sá eini sem komið hefur niður til jarðarinnar og mun fara aftur til himins. ");
INSERT INTO isl_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Móse reisti eirorminn upp á stöng í eyðimörkinni og þannig mun mér einnig verða lyft upp, ");
INSERT INTO isl_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","svo að allir sem á mig trúa, eignist eilíft líf. ");
INSERT INTO isl_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Því að svo elskaði Guð heiminn að hann gaf einkason sinn til þess að hver sem trúir á hann glatist ekki, heldur eignist eilíft líf. ");
INSERT INTO isl_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Guð sendi ekki son sinn til jarðarinnar til að dæma heiminn, heldur til að frelsa hann. ");
INSERT INTO isl_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Sá sem trúir á hann verður ekki dæmdur. En sá sem ekki trúir, hefur sjálfur kallað yfir sig dóm og er þegar dæmdur fyrir að vilja ekki trúa syni Guðs. ");
INSERT INTO isl_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ástæður dómsins eru þessar: Ljósið frá himnum kom í heiminn, en mennirnir elskuðu myrkrið meir en ljósið, því verk þeirra voru vond. ");
INSERT INTO isl_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Þeim var illa við þetta himneska ljós, því þá langaði til að syndga í myrkrinu. Þeir héldu sig í skugganum af ótta við að flett yrði ofan af syndum þeirra og þeim refsað. ");
INSERT INTO isl_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","En þeir sem í öllu leitast við að gera rétt, koma fúslega fram í ljósið, svo að allir geti séð að þeir geri Guðs vilja.“ ");
INSERT INTO isl_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Eftir þetta fór Jesús, ásamt lærisveinum sínum, frá Jerúsalem og dvöldust þeir um tíma í Júdeu og skírðu þar. ");
INSERT INTO isl_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Þegar þetta var, hafði Jóhannesi skírara enn ekki verið varpað í fangelsi og var hann að skíra við Aínon, nálægt Salím, því þar var mikið vatn. ");
INSERT INTO isl_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Dag einn fór einhver að deila við lærisveina Jóhannesar og sagði að betra væri að skírast hjá Jesú. ");
INSERT INTO isl_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Þeir fóru því til Jóhannesar og sögðu: „Meistari, maðurinn sem þú hittir hinum megin við ána – sá sem þú sagðir að væri Kristur – hann skírir líka og allir fara til hans.“ ");
INSERT INTO isl_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","„Enginn getur tekið neitt, nema Guð leyfi honum það,“ svaraði Jóhannes. ");
INSERT INTO isl_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","„Mitt hlutverk er að ryðja veginn fyrir Krist, svo að allir fari til hans. Þið vitið sjálfir að ég sagði ykkur að ég væri ekki Kristur. Ég er hér aðeins til að undirbúa komu hans – það er allt og sumt. ");
INSERT INTO isl_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Fólkið fer auðvitað til hans sem hefur mesta aðdráttaraflið – brúðurin fer þangað sem brúðguminn er – og vinur brúðgumans samgleðst honum. Ég er vinur brúðgumans. Ég gleðst innilega yfir árangri hans. ");
INSERT INTO isl_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Hann á að vaxa en ég að minnka. ");
INSERT INTO isl_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Hann kom frá himni og er öllum æðri. Ég er af jörðu og skilningur minn bundinn hinu jarðneska. ");
INSERT INTO isl_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Kristur segir frá því sem hann hefur séð og heyrt, samt trúa honum fáir. ");
INSERT INTO isl_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","34","En þeir sem það gera komast að raun um að Guð er uppspretta sannleikans. Því að Kristur er sendur af Guði og talar Guðs orð og andi Guðs starfar í honum, hindrunarlaust. ");
INSERT INTO isl_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Faðirinn elskar þennan mann, því að hann er sonur hans og hann hefur gefið honum allt. ");
INSERT INTO isl_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Allir sem treysta honum – Guðssyninum – eignast eilíft líf, en þeir sem hvorki trúa honum né hlýða, munu aldrei sjá guðsríki heldur mun reiði Guðs hvíla yfir þeim.“ ");
INSERT INTO isl_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Þegar Drottni varð ljóst að farísearnir hefðu frétt að hann fengi fleiri lærisveina og skírði fleiri en Jóhannes ");
INSERT INTO isl_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Jesús skírði þó ekki sjálfur heldur lærisveinar hans), ");
INSERT INTO isl_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","þá yfirgaf hann Júdeu og hélt aftur til Galíleu. ");
INSERT INTO isl_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Á leiðinni þurfti hann að fara um Samaríu. ");
INSERT INTO isl_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","6","Um hádegi kom hann í Samverjaþorp sem Síkar heitir, nálægt landi því sem Jakob gaf Jósef syni sínum, en þar er Jakobsbrunnur. Jesús var orðinn þreyttur eftir langa göngu og settist því við brunninn. ");
INSERT INTO isl_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Í sama bili kom þar að samversk kona til þess að sækja vatn. Jesús bað hana að gefa sér að drekka. ");
INSERT INTO isl_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Hann var einn þessa stundina, því að lærisveinar hans höfðu farið inn í þorpið til að kaupa mat. ");
INSERT INTO isl_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Konan varð undrandi á að Gyðingur skyldi biðja hana – konu og Samverja – um nokkuð, því að Gyðingar virtu þá ekki viðlits. Hún hafði orð á þessu við Jesú. ");
INSERT INTO isl_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Hann svaraði: „Ef þú þekktir gjöf Guðs og vissir, hver sá er sem biður þig um vatn að drekka, mundir þú biðja mig að gefa þér lifandi vatn.“ ");
INSERT INTO isl_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","„Þú hefur hvorki reipi né fötu og þessi brunnur er mjög djúpur,“ sagði hún, „hvar ætlar þú að ná í þetta lifandi vatn? ");
INSERT INTO isl_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ertu kannski meiri en Jakob forfaðir okkar, sem gaf okkur þennan brunn? Og hvernig ætlar þú að bjóða betra vatn en það sem hann sjálfur drakk og synir hans og kvikfé?“ ");
INSERT INTO isl_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús svaraði henni og sagði að fólk þyrsti fljótlega aftur, þótt það drykki þetta vatn. ");
INSERT INTO isl_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","„En,“ bætti hann við, „vatnið sem ég gef, verður að lind hið innra með þeim og veitir eilífa svölun.“ ");
INSERT INTO isl_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","„Herra,“ sagði konan, „gefðu mér þetta vatn svo að ég verði aldrei þyrst og þurfi ekki að fara hingað daglega eftir vatni.“ ");
INSERT INTO isl_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","„Farðu og náðu í manninn þinn,“ sagði Jesús. ");
INSERT INTO isl_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","18","„Ég er ekki gift,“ svaraði konan. „Satt er það,“ svaraði Jesús, „þú hefur átt fimm menn og þú ert ekki einu sinni gift þeim sem þú býrð með núna.“ ");
INSERT INTO isl_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","„Herra,“ sagði konan, „þú hlýtur að vera spámaður, ");
INSERT INTO isl_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","en segðu mér, af hverju segið þið, Gyðingar, að Jerúsalem sé eini staðurinn þar sem eigi að tilbiðja Guð? Við Samverjar höldum því fram að rétti staðurinn sé hér á Gerasímfjalli, þar sem forfeður okkar tilbáðu.“ ");
INSERT INTO isl_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","24","„Kona,“ svaraði Jesús, „sá tími kemur, þegar ekki skiptir máli hvort við tilbiðjum föðurinn hér eða í Jerúsalem. Spurningin er ekki hvar við tilbiðjum, heldur hvernig. Hverjum manni er nauðsynlegt að fá hjálp heilags anda til að geta tilbeðið Guð á réttan hátt og eftir hans vilja. Þið Samverjar biðjið í blindni, af því að þið þekkið hann ekki nema að litlu leyti, en við Gyðingar þekkjum hann því að heimurinn fær hjálpræðið frá okkur.“ ");
INSERT INTO isl_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","„Ja-á,“ svaraði konan, „ég veit að Kristur kemur – Messías, eins og þið kallið hann – og þegar hann kemur mun hann útskýra þetta allt fyrir okkur.“ ");
INSERT INTO isl_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Þá sagði Jesús: „Ég er hann sem við þig tala.“ ");
INSERT INTO isl_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Rétt í þessu komu lærisveinar hans þar að. Þeir urðu undrandi að sjá hann á tali við konu, en enginn þeirra spurði hann þó hvers vegna eða um hvað þau hefðu verið að tala. ");
INSERT INTO isl_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Konan lagði vatnskrúsina frá sér við brunninn, fór inn í þorpið og sagði við alla: „Komið! Sjáið manninn sem sagði mér allt, sem ég hef aðhafst! Ef til vill er hann Kristur!“ ");
INSERT INTO isl_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Og fólkið streymdi út úr þorpinu til að hitta Jesú. ");
INSERT INTO isl_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Meðan á þessu stóð hvöttu lærisveinarnir Jesú til að fá sér að borða, ");
INSERT INTO isl_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","en hann svaraði: „Nei, ég hef mat sem þið vitið ekki um.“ ");
INSERT INTO isl_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","„Hver gaf honum mat?“ spurðu lærisveinarnir hver annan. ");
INSERT INTO isl_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesús útskýrði þetta og sagði: „Minn matur er að gera vilja Guðs, sem sendi mig, og fullkomna hans verk. ");
INSERT INTO isl_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Haldið þið að uppskeran hefjist ekki fyrr en í lok sumars, eða eftir fjóra mánuði? Lítið í kring um ykkur! Hvert sem litið er eru víðáttumiklir akrar, tilbúnir til uppskeru. ");
INSERT INTO isl_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Sá sem uppsker fær laun og safnar ávöxtum til eilífs lífs, til þess að bæði sá sem sáir og sá sem uppsker geti glaðst saman. ");
INSERT INTO isl_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Einn sáir en annar uppsker. ");
INSERT INTO isl_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ég sendi ykkur til að uppskera þar sem þið hafið ekki sáð, aðrir hafa erfiðað, en þið fáið að bjarga uppskerunni.“ ");
INSERT INTO isl_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Margir úr þessu samverska þorpi trúðu nú að Jesús væri Kristur vegna orða konunnar sem vitnaði: „Hann sagði mér allt sem ég hef aðhafst!“ ");
INSERT INTO isl_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","41","Fólkið kom út að brunninum til hans og bað hann að staldra við hjá sér. Hann dvaldist því þar í tvo daga, og miklu fleiri tóku trú eftir að hafa hlustað á hann. ");
INSERT INTO isl_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Og við konuna sagði fólkið: „Það er ekki framar fyrir þín orð að við trúum, því að við höfum sjálf heyrt og vitum að þessi maður er í sannleika frelsari heimsins.“ ");
INSERT INTO isl_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","44","Eftir tvo daga hélt Jesús áfram til Galíleu. Hann hafði áður sagt: „Spámaður er alls staðar mikils metinn nema í sínum heimahögum.“ ");
INSERT INTO isl_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","En fólkið í Galíleu tók honum samt vel, enda hafði það verið á páskahátíðinni í Jerúsalem og séð sum kraftaverka hans. ");
INSERT INTO isl_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","47","Á leið sinni um Galíleu kom Jesús til Kana, bæjarins þar sem hann hafði áður breytt vatninu í vín. Meðan hann var þar frétti embættismaður nokkur, sem bjó í Kapernaum, að Jesús væri kominn frá Júdeu. Sonur þessa manns var veikur og því fór faðirinn til Kana til að finna Jesú. Hann sárbað Jesú að koma með sér til Kapernaum og lækna son sinn, sem var nær dauða en lífi. ");
INSERT INTO isl_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesús spurði hann: „Hvers vegna er það, getið þið ekki trúað nema þið fáið stöðugt að sjá ný kraftaverk?“ ");
INSERT INTO isl_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","En embættismaðurinn bað hann og sagði: „Herra, komdu áður en barnið mitt deyr!“ ");
INSERT INTO isl_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Þá sagði Jesús: „Farðu heim til þín, sonur þinn lifir:“ Maðurinn trúði honum og lagði af stað heim. ");
INSERT INTO isl_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Á leiðinni mætti hann einum þjóna sinna, sem sagði honum þær gleðifréttir að syni hans væri batnað. ");
INSERT INTO isl_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Þá spurði maðurinn hvenær honum hefði farið að batna og svarið var: „Um eittleytið í gær fór hitinn skyndilega úr honum!“ ");
INSERT INTO isl_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Þá mundi faðirinn að það var einmitt á þeirri stundu sem Jesús hafði sagt við hann: „Sonur þinn lifir.“ Þetta varð til þess að embættismaðurinn og allt hans heimafólk tók trú á Jesú. ");
INSERT INTO isl_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Þetta var annað kraftaverkið sem Jesús vann í Galíleu, en það gerði hann við heimkomuna frá Júdeu. ");
INSERT INTO isl_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Seinna fór Jesús aftur til Jerúsalem til að vera þar á trúarhátíð. ");
INSERT INTO isl_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Inni í borginni rétt við Sauðahliðið var Betesdalaugin og við hana fimm yfirbyggð súlnagöng. ");
INSERT INTO isl_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Þar lá mikill fjöldi af veiku fólki – lömuðu, blindu eða bækluðu. (Fólk þetta beið eftir vissri hreyfingu vatnsins, ");
INSERT INTO isl_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","því að engill Drottins kom af og til og hreyfði við því, og sá læknaðist sem fyrstur komst ofan í eftir það.) ");
INSERT INTO isl_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Þarna lá maður sem verið hafði veikur í þrjátíu og átta ár. ");
INSERT INTO isl_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Þegar Jesús sá hann og vissi hve lengi hann hafði verið veikur, spurði hann: „Viltu verða heilbrigður?“ ");
INSERT INTO isl_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","„Það er útilokað,“ svaraði maðurinn, „ég hef engan til að hjálpa mér ofan í laugina þegar hreyfing verður á vatninu og þess vegna verður alltaf einhver annar á undan mér.“ ");
INSERT INTO isl_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Þá sagði Jesús: „Stattu upp, vefðu saman dýnuna þína og farðu heim til þín!“ ");
INSERT INTO isl_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Maðurinn varð heilbrigður á samri stundu! Hann vafði saman dýnuna og gekk. Þetta gerðist á helgidegi ");
INSERT INTO isl_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","og því sögðu leiðtogar fólksins við manninn sem læknast hafði: „Það er óleyfilegt að vinna á helgidögum, líka að bera dýnu!“ ");
INSERT INTO isl_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","„Sá sem læknaði mig, sagði mér að gera það,“ svaraði maðurinn. ");
INSERT INTO isl_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","„Hver sagði þér að gera slíkt?“ spurðu þeir hranalega. ");
INSERT INTO isl_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Það vissi maðurinn ekki, því að Jesús hafði horfið í mannþröngina. ");
INSERT INTO isl_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Seinna hitti Jesús þennan sama mann í musterinu og sagði við hann: „Nú ertu heilbrigður. Syndga ekki framar, svo ekki hendi þig eitthvað enn verra.“ ");
INSERT INTO isl_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Maðurinn fór þá til leiðtoga fólksins og sagði þeim að Jesús væri sá sem hefði læknað sig. Það varð til þess að ");
INSERT INTO isl_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","þeir ofsóttu Jesú fyrir að brjóta helgidagslöggjöfina. ");
INSERT INTO isl_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Þá sagði hann: „Faðir minn starfar allt til þessa og ég starfa einnig.“ ");
INSERT INTO isl_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Eftir þetta svipuðust leiðtogarnir enn frekar eftir tækifæri til að taka hann af lífi, því að auk þess að brjóta helgidagslöggjöf þeirra, talaði hann um Guð sem föður sinn og gerði sig þar með Guði jafnan. ");
INSERT INTO isl_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Um þetta sagði Jesús: „Sonurinn getur ekkert gert á eigin spýtur. Hann gerir það eitt sem hann sér föðurinn gera og fer síðan eins að. ");
INSERT INTO isl_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Faðirinn elskar soninn og sýnir honum allt sem hann gerir. Seinna mun sonurinn vinna enn meiri kraftaverk en það að lækna þennan mann. ");
INSERT INTO isl_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Hann mun meðal annars vekja upp frá dauðum þá sem hann vill, rétt eins og faðirinn. ");
INSERT INTO isl_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Faðirinn lætur soninn um að dæma syndina, ");
INSERT INTO isl_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","svo að allir heiðri soninn eins og þeir heiðra föðurinn. Ef þið viljið ekki heiðra son Guðs, sem Guð sendi ykkur, þá heiðrið þið ekki heldur föðurinn. ");
INSERT INTO isl_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ég segi ykkur satt og legg á það áherslu, að hver sem heyrir orð mín og trúir Guði, sem sendi mig, eignast eilíft líf og mun aldrei hljóta dóm fyrir syndir sínar, heldur hefur hann þá þegar stigið yfir frá dauðanum til lífsins. ");
INSERT INTO isl_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Og það er líka satt að sú stund kemur, hún er reyndar þegar komin, er hinir dauðu heyra rödd mína – rödd Guðssonarins – og þeir sem heyra munu lifa. ");
INSERT INTO isl_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Faðirinn hefur eilíft líf í sjálfum sér og hann hefur einnig veitt syninum sama líf. ");
INSERT INTO isl_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Og hann hefur veitt honum rétt til að dæma syndir allra manna, því að hann er mannssonurinn. ");
INSERT INTO isl_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Látið það ekki koma ykkur á óvart, en sú stund er svo sannarlega skammt undan, er allir hinir dauðu, sem í gröfunum eru, munu heyra rödd Guðssonarins ");
INSERT INTO isl_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","og rísa upp. Þeir sem gott hafa gert til eilífs lífs, en þeir til dóms, sem lagt hafa stund á hið illa. ");
INSERT INTO isl_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ég dæmi engan án þess að ráðfæra mig fyrst við föður minn. Dómur minn er í fullu samræmi við hans vilja, réttvís og sanngjarn, því að hann er ekki aðeins samkvæmt mínum vilja heldur einnig samkvæmt vilja Guðs sem sendi mig. ");
INSERT INTO isl_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Þegar ég fullyrði eitthvað um sjálfan mig, trúið þið mér ekki, ");
INSERT INTO isl_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","33","en einn maður talar þó mínu máli og það er Jóhannes skírari. Þið fóruð að hlusta á hann og ég undirstrika að allt sem hann sagði um mig er satt! ");
INSERT INTO isl_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Hvers vegna minni ég ykkur á vitnisburð Jóhannesar? Jú, til að auðvelda ykkur að trúa mér og frelsast, en þó er besti vitnisburðurinn um mig ekki frá manni. ");
INSERT INTO isl_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ljós Jóhannesar skein skært um stund og þið nutuð þess og glöddust, ");
INSERT INTO isl_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","en þegar ég segi að ég hafi betra vitni en Jóhannes, þá á ég við kraftaverkin sem ég geri. Faðir minn hefur falið mér að vinna þau og þau sanna að faðirinn hefur sent mig. ");
INSERT INTO isl_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Hann hefur sjálfur vitnað um mig, þó ekki þannig að þið sæjuð hann eða heyrðuð rödd hans. ");
INSERT INTO isl_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Þið vitið ekki heldur hvað hann segir því að þið viljið ekki trúa mér, en boðskapur minn er frá honum. ");
INSERT INTO isl_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Þið rannsakið Gamla testamentið, því að þið álítið að það gefi ykkur eilíft líf, en svo vitið þið ekki að það vitnar um mig! ");
INSERT INTO isl_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Hvers vegna viljið þið ekki koma til mín, svo að ég geti gefið ykkur eilíft líf? ");
INSERT INTO isl_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","42","Ég sækist ekki eftir vinsældum ykkar, því ég veit vel að þið berið ekki kærleika til Guðs. ");
INSERT INTO isl_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ég veit hvað ég er að segja, því að ég kom til að kynna ykkur föður minn. Samt viljið þið ekkert með mig hafa. Þið takið hins vegar vel á móti þeim sem koma á eigin vegum, en þá hef ég ekki sent. ");
INSERT INTO isl_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Það er ekkert undarlegt þótt þið trúið ekki! Þið þiggið heiður hver af öðrum en leitið ekki þess heiðurs sem Guð einn getur veitt! ");
INSERT INTO isl_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","En ég mun samt ekki ákæra ykkur frammi fyrir föðurnum, heldur Móse. Von ykkar um guðsríki hvílir á lögum Móse, ");
INSERT INTO isl_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","en samt hafið þið ekki viljað trúa honum. Hann ritaði um mig, en þið viljið ekki trúa honum og þess vegna viljið þið ekki heldur trúa mér. ");
INSERT INTO isl_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Fyrst þið trúið ekki orðum hans, þá er ekki að undra þótt þið trúið ekki orðum mínum.“ ");
INSERT INTO isl_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Eftir þetta fór Jesús til landsvæðisins hinum megin Galíleuvatnsins, sem kennt er við Tíberías, ");
INSERT INTO isl_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","5","og fylgdi honum gífurlegur mannfjöldi. Margt af þessu fólki var pílagrímar á leið til Jerúsalem á páskahátíðina, en það langaði til að sjá Jesú lækna hina sjúku og því fylgdi það honum hvert fótmál. Jesús gekk upp á fjallið ásamt lærisveinum sínum og settist, og sá þá að mannfjöldinn var að koma. Hann sneri sér að Filippusi og sagði: „Filippus, hvar getum við keypt brauð til að gefa fólkinu að borða?“ ");
INSERT INTO isl_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Jesús hafði ákveðið með sjálfum sér hvað hann ætlaði að gera, en með þessu var hann að reyna Filippus.) ");
INSERT INTO isl_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filippus svaraði: „Þótt við keyptum ekki nema handa hluta þeirra, mundi það kosta mikla peninga!“ ");
INSERT INTO isl_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Þá sagði Andrés, bróðir Símonar Péturs: „Hér er ungur drengur með fimm byggbrauð og tvo fiska, en það dugar að vísu skammt handa öllum þessum fjölda.“ ");
INSERT INTO isl_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","„Látið fólkið setjast niður,“ sagði Jesús. Þá settist allt fólkið niður í grasigróna brekkuna og voru karlmennirnir einir um fimm þúsund. ");
INSERT INTO isl_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Því næst tók hann brauðin, flutti þakkarbæn og skipti þeim meðal fólksins, og fengu allir eins mikið og þeir vildu. ");
INSERT INTO isl_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Þegar allir höfðu borðað nægju sína sagði Jesús: „Tínið nú saman leifarnar svo að ekkert fari til spillis.“ ");
INSERT INTO isl_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Það var gert og afgangs urðu tólf sneisafullar körfur! ");
INSERT INTO isl_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Þegar fólkinu varð ljóst hvílíkt kraftaverk hafði gerst hrópaði það: „Hann er áreiðanlega spámaðurinn, sem við höfum beðið eftir!“ ");
INSERT INTO isl_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Þegar Jesús sá að fólkið ætlaði að taka hann með valdi og gera hann að konungi, gekk hann enn hærra upp á fjallið, einn síns liðs. ");
INSERT INTO isl_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Um kvöldið fóru lærisveinarnir niður að vatninu og biðu hans. ");
INSERT INTO isl_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Þegar myrkrið skall á og Jesús var enn ókominn, stigu þeir í bátinn, héldu út á vatnið og stefndu til Kapernaum. ");
INSERT INTO isl_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","19","En á leiðinni hvessti skyndilega svo vatnið varð mjög úfið. Þeir höfðu róið um sex kílómetra þegar þeir sáu Jesú koma gangandi í átt til sín. Þeir urðu skelkaðir, ");
INSERT INTO isl_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","en þá kallaði hann til þeirra og sagði: „Verið óhræddir, þetta er ég!“ ");
INSERT INTO isl_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Þeir tóku hann upp í bátinn og um leið sáu þeir að þeir voru komnir þangað sem þeir ætluðu sér. ");
INSERT INTO isl_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Morguninn eftir fór fólkið að safnast saman á ströndinni hinum megin vatnsins (í von um að hitta Jesú), því það vissi að hann hafði komið þangað með lærisveinum sínum, og að lærisveinarnir höfðu síðan farið á sínum bát, en skilið Jesú eftir. Þarna voru margir smábátar frá Tíberías. ");
INSERT INTO isl_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Þegar fólkinu varð ljóst að hvorki Jesús né lærisveinar hans voru þar, þá steig það í bátana og fór yfir vatnið til Kapernaum, til að leita hans. ");
INSERT INTO isl_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Þegar fólkið kom þangað og fann hann, spurði það: „Herra, hvernig komstu hingað?“ ");
INSERT INTO isl_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesús svaraði: „Ég segi ykkur satt, þið leitið mín vegna þess að ég gaf ykkur að borða, en ekki vegna þess að þið trúið á mig. ");
INSERT INTO isl_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Hugsið ekki um það sem eyðist, eins og til dæmis mat. Leitið heldur eilífa lífsins sem ég, Kristur, get gefið ykkur, og einmitt þess vegna sendi Guð mig hingað.“ ");
INSERT INTO isl_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","„Hvað eigum við þá að gera til að þóknast Guði?“ spurði fólkið. ");
INSERT INTO isl_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","„Guðs vilji er að þið trúið þeim sem hann sendi,“ svaraði Jesús. ");
INSERT INTO isl_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","„Þá verður þú að sýna okkur fleiri kraftaverk, ef þú vilt að við trúum því að þú sért Kristur,“ svaraði fólkið. „Gefðu okkur ókeypis brauð á hverjum degi eins og forfeður okkar fengu á leið sinni yfir eyðimörkina. Það stendur í Biblíunni að Móse hafi gefið þeim brauð frá himni.“ ");
INSERT INTO isl_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","„Það var ekki Móse, sem gaf þeim það,“ svaraði Jesús, „heldur faðir minn. En nú vill hann gefa ykkur hið sanna brauð af himni. ");
INSERT INTO isl_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Brauð Guðs er sá sem Guð sendi frá himni og gefur heiminum líf.“ ");
INSERT INTO isl_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","„Herra,“ sögðu þeir, „gefðu okkur slíkt brauð á hverjum degi!“ ");
INSERT INTO isl_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","„Ég er brauð lífsins,“ svaraði Jesús, „þann mun ekki hungra sem til mín kemur og þann aldrei þyrsta sem á mig trúir. ");
INSERT INTO isl_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ég segi enn: Vandi ykkar er að þið trúið ekki á mig þótt þið hafið séð mig. ");
INSERT INTO isl_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Allir þeir sem faðirinn gefur mér, koma til mín, og þann sem til mín kemur, mun ég alls ekki reka burt. ");
INSERT INTO isl_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ég kom hingað frá himni til að gera vilja Guðs sem sendi mig, en ekki minn eigin vilja. ");
INSERT INTO isl_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Vilji Guðs er sá að ég týni ekki neinum þeirra sem hann hefur gefið mér, heldur veki þá til eilífs lífs á dómsdegi. ");
INSERT INTO isl_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Það er vilji föður míns að allir sem sjá soninn og trúa á hann, eignist eilíft líf og að ég reisi þá upp á efsta degi.“ ");
INSERT INTO isl_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Þegar Gyðingarnir heyrðu hann segja að hann væri brauð frá himni, gagnrýndu þeir hann sín á milli og hrópuðu: ");
INSERT INTO isl_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","„Ha? Hvað á hann við? Þetta er bara hann Jesús Jósefsson! Við þekkjum föður hans og móður. Hvernig getur hann sagt að hann hafi komið niður af himni?“ ");
INSERT INTO isl_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","„Verið ekki með þennan kurr,“ svaraði Jesús. ");
INSERT INTO isl_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","„Enginn getur komið til mín, nema faðirinn, sem sendi mig, leiði hann og á efsta degi mun ég reisa hann upp frá dauðum. ");
INSERT INTO isl_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Svo segir Biblían um þá: „Guð mun sjálfur fræða þá.“ Þeir sem hlusta á föðurinn og læra sannleikann hjá honum, munu dragast að mér. ");
INSERT INTO isl_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ekki svo að skilja að þeir sjái föðurinn í raun og veru, ég er sá eini sem það hef gert. ");
INSERT INTO isl_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ég segi ykkur satt: „Hver sem trúir á mig, mun þegar í stað eignast eilíft líf!“ ");
INSERT INTO isl_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","51","Ég er brauð lífsins! Það var ekkert líf í brauðinu sem féll af himni og forfeður ykkar átu í eyðimörkinni – þeir dóu allir um síðir. Það er aðeins til eitt himneskt brauð og þeir sem þess neyta munu ekki deyja. Ég er þetta lifandi brauð, sem kom niður af himni, og sá sem neytir þess mun lifa að eilífu. Þetta brauð er ég sjálfur – hold mitt sem gefið er heiminum til lífs.“ ");
INSERT INTO isl_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Þá tóku Gyðingarnir að þrátta sín á milli um það hvað hann ætti við og spurðu: „Hvernig getur þessi maður gefið okkur hold sitt að borða?“ ");
INSERT INTO isl_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús sagði því aftur: „Ég segi ykkur satt og legg á það áherslu: Þið getið ekki átt eilíft líf í ykkur, nema þið etið hold Krists og drekkið blóð hans. ");
INSERT INTO isl_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Sá sem etur hold mitt og drekkur blóð mitt hefur eilíft líf, og ég mun vekja hann upp á efsta degi. ");
INSERT INTO isl_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Hold mitt er sönn fæða og blóð mitt sannur drykkur. ");
INSERT INTO isl_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Hver sem etur hold mitt og drekkur blóð mitt, er í mér og ég í honum. ");
INSERT INTO isl_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ég lifi í krafti föðurins, hans sem lifir, og á sama hátt munu þeir lifa sem hlutdeild eiga í mér. ");
INSERT INTO isl_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ég er hið sanna brauð sem kom niður af himni og hver sem etur þetta brauð, mun lifa að eilífu en ekki deyja eins og forfeður ykkar, sem átu brauð frá himni.“ ");
INSERT INTO isl_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Þessa ræðu hélt Jesús í samkomuhúsinu í Kapernaum. ");
INSERT INTO isl_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Þá sögðu sumir lærisveina hans: „Þetta var hörð ræða! Hver getur hlýtt á annað eins?“ ");
INSERT INTO isl_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesús vissi með sjálfum sér að lærisveinarnir voru óánægðir og sagði því við þá: „Hneykslar þetta ykkur? ");
INSERT INTO isl_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Hvað mynduð þið segja ef þið sæjuð mig, Krist, fara aftur til himins? ");
INSERT INTO isl_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Það er aðeins heilagur andi sem getur lokið þessu upp fyrir ykkur, þið getið aldrei skilið það af eigin mætti. Nú hef ég sagt ykkur hvernig þið getið eignast þetta sanna líf, ");
INSERT INTO isl_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","en sumir ykkar trúa mér samt ekki.“ (Jesús vissi frá byrjun hverjir það voru sem ekki trúðu, og hann vissi einnig hver mundi svíkja hann.) ");
INSERT INTO isl_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Hann bætti við og sagði: „Þetta átti ég við þegar ég sagði að enginn gæti komið til mín nema faðirinn leiddi hann til mín.“ ");
INSERT INTO isl_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Eftir þessi orð Jesú, fóru margir lærisveina hans frá honum fyrir fullt og allt. ");
INSERT INTO isl_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jesús sagði þá við þá tólf: „En þið, ætlið þið líka að fara?“ ");
INSERT INTO isl_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Símon varð fyrir svörum: „Meistari, hvert ættum við að fara? Þú ert sá eini sem hefur orð eilífs lífs, ");
INSERT INTO isl_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","við trúum þér og vitum að þú ert hinn heilagi sonur Guðs.“ ");
INSERT INTO isl_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Þá sagði Jesús: „Ég útvaldi ykkur tólf, en einn ykkar er djöfull.“ ");
INSERT INTO isl_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Hér átti hann við Júdas, son Símonar Ískaríot, einn þeirra tólf, en sá varð síðar til þess að svíkja hann. ");
INSERT INTO isl_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Eftir þetta fór Jesús til Galíleu og ferðaðist frá einu þorpinu til annars. Hann vildi ekki vera í Júdeu því að leiðtogarnir þar sátu um líf hans. ");
INSERT INTO isl_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Brátt leið að laufskálahátíðinni, en það er ein hinna árlegu trúarhátíða Gyðinga. ");
INSERT INTO isl_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Bræður Jesú hvöttu hann til að fara til Júdeu á hátíðina og sögðu ertnislega: „Farðu þangað, því að þá geta miklu fleiri séð kraftaverk þín. ");
INSERT INTO isl_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Þú verður ekki frægur af því að fela þig. Og fyrst þú ert svona mikill, skaltu reyna að sanna það fyrir heiminum!“ ");
INSERT INTO isl_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Bræður Jesú trúðu sem sagt ekki á hann. ");
INSERT INTO isl_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesús svaraði: „Minn tími til að fara er enn ekki kominn. Þið getið hins vegar farið hvenær sem þið viljið, það breytir engu, ");
INSERT INTO isl_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","því heimurinn er ekki á móti ykkur. Hann er á móti mér, því ég ásaka hann fyrir illt athæfi og syndir. ");
INSERT INTO isl_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Þið skuluð fara; ég kem seinna þegar minn tími er kominn.“ ");
INSERT INTO isl_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Af þessari ástæðu varð Jesús eftir í Galíleu. ");
INSERT INTO isl_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","En þegar bræður hans voru farnir til hátíðarinnar fór Jesús líka, en á laun og lét ekkert á sér bera. ");
INSERT INTO isl_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Leiðtogar þjóðarinnar reyndu að finna hann á hátíðinni og héldu uppi spurnum um hann. ");
INSERT INTO isl_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Fólkið ræddi mikið um hann sín á milli og sumir sögðu: „Hann er dásamlegur maður.“ Aðrir sögðu: „Nei, hann blekkir fólkið.“ ");
INSERT INTO isl_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Enginn þorði að taka málstað hans opinberlega af ótta við leiðtoga þjóðarinnar. ");
INSERT INTO isl_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Þegar hátíðin var hálfnuð gekk Jesús inn í musterið og predikaði opinberlega. ");
INSERT INTO isl_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Leiðtogar þjóðarinnar undruðust orð hans og spurðu: „Hvaðan hefur hann þessa þekkingu? Hann hefur aldrei gengið í skóla hjá okkur.“ ");
INSERT INTO isl_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús sagði þá við þá: „Ég kenni ekki eigin hugmyndir, heldur orð Guðs sem sendi mig. ");
INSERT INTO isl_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ef einhver ykkar vill gera vilja Guðs í raun og veru, þá mun hann örugglega sjá hvort boðskapur minn er frá Guði eða frá sjálfum mér. ");
INSERT INTO isl_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Sá sem talar af sjálfum sér vonast eftir hrósi, en sá sem heiðrar þann sem sendi hann, er trúr og sannur. ");
INSERT INTO isl_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Móse gaf ykkur lögin en hvers vegna hlýðið þið þeim þá ekki? Hvers vegna segið þið að ég brjóti þau og hver er ástæða þess að þið viljið lífláta mig?“ ");
INSERT INTO isl_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Fólkið svaraði: „Þú ert ekki með öllum mjalla! Hver er það sem situr um líf þitt?“ ");
INSERT INTO isl_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","23","Jesús svaraði: „Ég læknaði mann á helgidegi og það kom ykkur á óvart, en samt vinnið þið sjálf á helgidögum þegar þið umskerið samkvæmt lögum Móse – reyndar er umskurnin eldri en lögmál Móse. Ef umskurnardag ber upp á helgidag, þá framkvæmið þið umskurnina eins og ekkert sé. Hvers vegna dæmið þið mig þá fyrir að lækna mann á helgidegi? ");
INSERT INTO isl_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Hugsið þetta mál og þá munuð þið komast að raun um að ég hef á réttu að standa.“ ");
INSERT INTO isl_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Sumir íbúar Jerúsalem sögðu þá: „Er þetta ekki maðurinn sem leiðtogar okkar vilja feigan? ");
INSERT INTO isl_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Hvernig stendur þá á því að hann fær að predika óáreittur á almannafæri og þeir gera enga athugasemd? Getur verið að þeir hafi loksins komist að raun um að hann sé Kristur? ");
INSERT INTO isl_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","En hvernig ætti hann annars að vera það? Við vitum, jú, hvar hann er fæddur, en þegar Kristur kemur mun enginn vita hvaðan hann kemur, hann mun birtast allt í einu.“ ");
INSERT INTO isl_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Þetta varð til þess að eitt sinn er Jesús var að predika í musterinu, kallaði hann hátt: „Já, þið þekkið mig og vitið hvar ég fæddist og hvar ég ólst upp, en ég tala máli þess sem þið þekkið ekki og hann er sannleikurinn. ");
INSERT INTO isl_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ég þekki hann því ég var hjá honum og hann sendi mig til ykkar.“ ");
INSERT INTO isl_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Þegar leiðtogarnir heyrðu hann segja þetta leituðust þeir við að handtaka hann. ");
INSERT INTO isl_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Margir þeirra sem komu reglulega í musterið trúðu á hann og sögðu: „Hvaða kraftaverk haldið þið að Kristur geri, sem þessi maður hefur ekki gert?“ ");
INSERT INTO isl_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Þegar farísearnir heyrðu þetta sendu þeir og æðstu prestarnir lögregluna til að handtaka hann. ");
INSERT INTO isl_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Þá sagði Jesús: „Bíðið með þetta! Mér ber að vera hér enn um stund, en að því loknu sný ég aftur til hans sem sendi mig. ");
INSERT INTO isl_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Þið munuð leita mín en án árangurs, því að þangað sem ég fer komist þið ekki.“ ");
INSERT INTO isl_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Leiðtogarnir urðu undrandi á þessum tilsvörum og spurðu: „Hvert skyldi hann ætla? Skyldi hann ætla úr landi til að útbreiða kenningar sínar meðal Gyðinga í öðrum löndum, eða jafnvel meðal heiðingjanna? ");
INSERT INTO isl_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Hvað á hann við þegar hann segir að við munum leita hans, en ekki finna? Og hvað þýðir þetta: Þið komist ekki þangað sem ég fer?“ ");
INSERT INTO isl_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Síðasta daginn – helgasta dag þjóðarinnar – hrópaði Jesús út yfir mannfjöldann: „Ef nokkurn þyrstir þá komi hann til mín og drekki, ");
INSERT INTO isl_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","því Biblían segir um þann sem trúir á mig, að frá hans innra manni muni streyma lækir lifandi vatns.“ ");
INSERT INTO isl_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Hér átti hann við heilagan anda, sem þeir mundu fá, sem tryðu á hann. En ennþá var andinn ekki gefinn, því að Jesús hafði þá ekki enn snúið aftur til dýrðar sinnar á himnum. ");
INSERT INTO isl_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Þegar mannfjöldinn heyrði þetta sögðu sumir: „Þessi maður er áreiðanlega spámaðurinn, sem á að koma á undan Kristi.“ ");
INSERT INTO isl_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","42","Aðrir sögðu: „Hann er Kristur.“ Enn aðrir sögðu: „Það er útilokað að hann sé Kristur. Haldið þið að Kristur komi frá Galíleu? Biblían segir að Kristur muni verða af ætt Davíðs og fæðast í Betlehem þar sem Davíð fæddist.“ ");
INSERT INTO isl_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Fólkið hafði sem sagt ýmsar skoðanir á Jesú. ");
INSERT INTO isl_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Sumir vildu láta handtaka hann, en þó gerði það enginn. ");
INSERT INTO isl_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Musterislögreglan, sem send hafði verið til að handtaka hann, sneri því tómhent aftur til æðstu prestanna og faríseanna. „Hvers vegna komið þið ekki með hann?“ spurðu þeir reiðilega. ");
INSERT INTO isl_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","„Hann segir svo margt stórkostlegt!“ svöruðu þeir. „Við höfum aldrei áður heyrt neitt þessu líkt.“ ");
INSERT INTO isl_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","„Jæja, er þá líka búið að villa um fyrir ykkur?“ spurðu farísearnir hæðnislega. ");
INSERT INTO isl_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","„Hver af okkar leiðtogum eða faríseunum trúir að hann sé Kristur? ");
INSERT INTO isl_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Fólkið trúir því, satt er það, en það er heimskt og hefur ekkert vit á slíkum hlutum, enda hvílir bölvun yfir því!“ ");
INSERT INTO isl_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Þá spurði Nikódemus, einn af leiðtogum þjóðarinnar, sem heimsótti Jesú eitt sinn á laun til að ræða við hann: ");
INSERT INTO isl_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","„Er leyfilegt að dæma nokkurn áður en hann hefur verið ákærður?“ ");
INSERT INTO isl_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","„Ha?“ spurðu hinir, „ert þú kannski einn af þessum auvirðilegu Galíleumönnum? Lestu Biblíuna – enginn spámannanna kom frá Galíleu!“ ");
INSERT INTO isl_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Eftir þetta leystist fundurinn upp og fór hver heim til sín. ");
INSERT INTO isl_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesús fór nú til Olíufjallsins, ");
INSERT INTO isl_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","en snemma næsta morgun var hann aftur kominn í musterið. Fólkið þyrptist að og hann settist niður og ávarpaði það. ");
INSERT INTO isl_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Á meðan hann var að tala, komu farísearnir og aðrir leiðtogar þjóðarinnar með konu sem staðin hafði verið að því að drýgja hór. Þeir stilltu henni upp í allra augsýn. ");
INSERT INTO isl_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","„Kennari,“ sögðu þeir við Jesú. „Þessi kona var staðin að því að drýgja hór. ");
INSERT INTO isl_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Lög Móse segja að slíkar konur eigi að grýta. Hvað viltu segja um það?“ ");
INSERT INTO isl_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ætlun þeirra var að fá hann til að segja eitthvað sem þeir gætu ákært hann fyrir. Þá beygði Jesús sig niður og skrifaði í sandinn með fingrunum. ");
INSERT INTO isl_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Á meðan héldu hinir áfram að krefja hann svars. Jesús stóð upp og sagði: „Allt í lagi. Grýtið hana, en sá ykkar sem syndlaus er, kasti fyrsta steininum!“ ");
INSERT INTO isl_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Síðan kraup hann aftur niður og hélt áfram að skrifa í sandinn, ");
INSERT INTO isl_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","en leiðtogarnir laumuðust í burtu, fyrst sá elsti og síðan einn af öðrum. Að lokum var Jesús þar einn ásamt konunni og mannfjöldanum. ");
INSERT INTO isl_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesús stóð þá upp og spurði konuna: „Hvar eru þeir? Ákærði þig enginn?“ ");
INSERT INTO isl_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","„Nei, herra, enginn,“ svaraði hún. „Ég ákæri þig ekki heldur,“ sagði Jesús, „farðu og syndgaðu ekki framar.“ ");
INSERT INTO isl_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Seinna, þegar Jesús var að ávarpa mannfjöldann, sagði hann: „Ég er ljós heimsins. Sá sem fylgir mér mun ekki staulast í myrkrinu, því ég mun lýsa honum veginn til eilífs lífs.“ ");
INSERT INTO isl_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","„Þetta er lygi!“ hrópuðu farísearnir. „Þú ert alltaf að hrósa sjálfum þér.“ ");
INSERT INTO isl_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","„Það er satt sem ég sagði,“ svaraði Jesús, „enda þótt ég hafi sagt þetta um sjálfan mig, því ég veit hvaðan ég kom og hvert ég fer, en það vitið þið ekki. ");
INSERT INTO isl_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Þið dæmið mig án þess að rannsaka mál mitt fyrst. Ég mun ekki dæma ykkur strax, ");
INSERT INTO isl_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","en þótt ég gerði það, þá væri sá dómur réttlátur að öllu leyti, því faðir minn, sem sendi mig, er með mér. ");
INSERT INTO isl_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Lög ykkar segja að sé vitnisburður tveggja manna samhljóða, sé hann tekinn gildur. ");
INSERT INTO isl_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ég er annað vitnið og hitt er faðir minn sem sendi mig.“ ");
INSERT INTO isl_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","„Hvar er faðir þinn?“ spurðu þeir. „Þið þekkið mig ekki og því þekkið þið ekki heldur föður minn,“ svaraði Jesús. „Ef þið þekktuð mig, þá mynduð þið einnig þekkja hann.“ ");
INSERT INTO isl_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús mælti þetta hjá fjárhirslunni í musterinu. En hann var ekki handtekinn, því að tími hans var enn ekki kominn. ");
INSERT INTO isl_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Seinna sagði Jesús aftur við faríseana: „Ég fer burt og þið munuð leita mín og deyja í syndum ykkar, því að þið getið alls ekki komist þangað sem ég fer.“ ");
INSERT INTO isl_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Þá sögðu þeir: „Ætlar hann að fremja sjálfsmorð? Hvað á hann við með þessu: Þið getið ekki komist þangað sem ég fer?“ ");
INSERT INTO isl_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesús sagði því við þá: „Þið komið að neðan, en ég að ofan. Þið eruð af þessum heimi en ekki ég, ");
INSERT INTO isl_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","og því sagði ég að þið mynduð deyja í syndum ykkar, aðskildir frá Guði. Ef þið trúið ekki að ég sé Kristur, sonur Guðs, þá munuð þið deyja í syndum ykkar.“ ");
INSERT INTO isl_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","„Segðu okkur hver þú ert,“ sögðu þeir. „Ég hef margsinnis sagt ykkur það,“ svaraði hann. ");
INSERT INTO isl_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","„Ég gæti dæmt ykkur fyrir margt og frætt ykkur um margt, en ég vil það ekki, því ég segi aðeins það sem sá er sendi mig biður mig að segja og hann er sannleikurinn.“ ");
INSERT INTO isl_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Þeir skildu ekki enn að hann var að tala við þá um Guð. ");
INSERT INTO isl_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jesús sagði því: „Þegar þið hafið krossfest mig, þá munuð þið skilja að ég er Kristur og að það sem ég hef talað, er ekki frá eigin brjósti heldur frá föðurnum. ");
INSERT INTO isl_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Sá sem sendi mig er með mér – hann hefur ekki yfirgefið mig því ég geri aðeins það sem honum er þóknanlegt.“ ");
INSERT INTO isl_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","31","Eftir þessi orð Jesú, trúðu margir leiðtoganna að hann væri Kristur. Jesús sagði við þá: „Ef þið farið eftir orðum mínum, þá eruð þið sannir lærisveinar mínir, ");
INSERT INTO isl_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","og þið munuð þekkja sannleikann og sannleikurinn mun gera ykkur frjálsa.“ ");
INSERT INTO isl_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","„En við erum afkomendur Abrahams,“ sögðu þeir, „og við höfum aldrei verið þrælar nokkurs manns. Hvað áttu við með orðinu „frjáls“?“ ");
INSERT INTO isl_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","„Þið eruð allir þrælar syndarinnar,“ svaraði Jesús. ");
INSERT INTO isl_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","„Þrælar hafa engin réttindi, en sonurinn hefur öll réttindi. ");
INSERT INTO isl_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ef sonurinn gerir ykkur frjálsa verðið þið sannarlega frjálsir. ");
INSERT INTO isl_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ég veit vel að þið eruð afkomendur Abrahams en samt reyna sumir ykkar að lífláta mig, af því að orð mín fá ekki rúm hjá ykkur. ");
INSERT INTO isl_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ég hef áður sagt ykkur hvað ég sá þegar ég var hjá föður mínum, en þið viljið aðeins fara að ráðum föður ykkar.“ ");
INSERT INTO isl_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","„Abraham er faðir okkar,“ svöruðu þeir. „Nei!“ sagði Jesús, „ef svo væri, færuð þið að ráðum hans. ");
INSERT INTO isl_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","En nú viljið þið hins vegar lífláta mig, einungis vegna þess að ég sagði ykkur sannleikann, sem ég heyrði hjá Guði – slíkt mundi Abraham aldrei gera! ");
INSERT INTO isl_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Þegar þið gerið slíka hluti, þá eruð þið að hlýðnast ykkar raunverulega föður.“ „Við erum ekki óskilgetnir,“ svöruðu þeir. „Guð er okkar eini og sanni faðir.“ ");
INSERT INTO isl_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","„Ef svo væri,“ sagði Jesús, „þá munduð þið elska mig, því að hingað kom ég frá Guði. Það var hann sem sendi mig. Ég er ekki hér á eigin vegum. ");
INSERT INTO isl_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Hvers vegna skiljið þið mig ekki? Jú, það er vegna þess að þið eruð hindraðir af Satan. ");
INSERT INTO isl_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Hann er faðir ykkar og þið njótið þess að framkvæma illvirki hans. Hann var morðingi frá öndverðu og hataði sannleikann – það finnst ekki snefill af sannleika í honum. Honum er fullkomlega eðlilegt að ljúga. Hann er faðir lyginnar, ");
INSERT INTO isl_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","og það er einmitt ástæða þess að þið trúið mér ekki þegar ég segi ykkur sannleikann. ");
INSERT INTO isl_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Getur nokkur ykkar sannað á mig hina minnstu synd? (Nei, enginn!) Nú segi ég ykkur sannleikann, en hvers vegna trúið þið mér ekki? ");
INSERT INTO isl_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Sá sem á Guð að föður, tekur með gleði á móti orði hans. Ef svo er ekki með ykkur, þá sýnir það að þið eruð ekki börn hans.“ ");
INSERT INTO isl_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","„Þú ert Samverji, útlendingur og djöfull!“ hvæstu leiðtogarnir. „Það er langt síðan við sögðum að í þér væri illur andi!“ ");
INSERT INTO isl_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","„Nei,“ svaraði Jesús, „það er enginn illur andi í mér, því ég heiðra föður minn og þess vegna lítilsvirðið þið mig. ");
INSERT INTO isl_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ég hef engan áhuga á að upphefja sjálfan mig, en Guð vill upphefja mig og hann mun dæma þá sem hafna mér. ");
INSERT INTO isl_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ég segi ykkur satt: Sá sem hlýðir orðum mínum, mun aldrei að eilífu sjá dauðann.“ ");
INSERT INTO isl_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","„Nú vitum við að þú hefur illan anda,“ sögðu leiðtogarnir, „því að Abraham dó og sama er að segja um spámennina, en nú segir þú að sá sem hlýði þér, muni aldrei deyja! ");
INSERT INTO isl_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ertu þá meiri en Abraham forfaðir okkar? Því að hann dó. Og ertu meiri en spámennirnir sem dóu? Hver heldurðu eiginlega að þú sért?“ ");
INSERT INTO isl_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Þá svaraði Jesús: „Það væri ekki til neins fyrir mig að hrósa mér, en það er faðir minn – sem þið haldið fram að sé ykkar Guð – sem segir öll þessi yndislegu orð um mig, ");
INSERT INTO isl_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","en hann þekkið þið ekki. Ég þekki hann! Ef ég segði að ég þekkti hann ekki, þá væri ég að ljúga eins og þið! Þegar ég segi að ég þekki hann og hlýði honum í öllu, þá er ég að segja sannleikann. ");
INSERT INTO isl_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham faðir ykkar hlakkaði til að sjá minn dag. Hann vissi að ég var að koma og það gladdi hann.“ ");
INSERT INTO isl_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Þá sögðu leiðtogarnir: „Þú ert ekki einu sinni orðinn fimmtugur, en samt segist þú hafa séð Abraham!“ ");
INSERT INTO isl_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","„Ég segi ykkur satt,“ svaraði Jesús, „ég var til þegar Abraham fæddist!“ ");
INSERT INTO isl_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Þegar leiðtogarnir heyrðu þetta, tóku þeir upp steina til að grýta hann. En þeir misstu sjónar af honum, því hann gekk burt frá þeim og yfirgaf musterið. ");
INSERT INTO isl_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Eitt sinn er Jesús var á gangi, sá hann mann sem hafði verið blindur frá fæðingu. ");
INSERT INTO isl_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","„Meistari,“ sögðu lærisveinar hans, „hvers vegna fæddist þessi maður blindur? Var það vegna þess að hann syndgaði eða foreldrar hans?“ ");
INSERT INTO isl_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","„Hvorugt,“ svaraði Jesús. „Það er til að sýna mátt Guðs. ");
INSERT INTO isl_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Okkur ber að vinna verk þess sem sendi mig, meðan dagur er. Senn kemur nótt og þá leggst öll vinna niður. ");
INSERT INTO isl_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","En meðan ég er enn í heiminum, er ég ljós heimsins.“ ");
INSERT INTO isl_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Síðan hrækti hann á jörðina, bjó til leðju úr munnvatninu, bar hana á augu blinda mannsins ");
INSERT INTO isl_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","og sagði: „Farðu og þvoðu þér í Sílóamlaug.“ (Orðið „Sílóam“ merkir „sendur.“) Maðurinn fór og þvoði sér og kom aftur sjáandi! ");
INSERT INTO isl_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nágrannar hans og aðrir, sem vissu að hann hafði verið blindur betlari, spurðu nú hver annan: „Er þetta sami maðurinn – betlarinn?“ ");
INSERT INTO isl_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Svörin voru á ýmsa vegu og margir hugsuðu: „Þetta getur ekki verið hann, en hann lítur þó eins út!“ En betlarinn sagði: „Ég er maðurinn.“ ");
INSERT INTO isl_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Þá spurðu þeir hann hvernig hann hefði fengið sjónina. „Hvað gerðist?“ ");
INSERT INTO isl_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","„Maður, sem þeir kalla Jesú,“ svaraði hann, „bjó til leðju, bar hana á augu mín og sagði mér síðan að fara og þvo hana burt í Sílóamlauginni. Ég gerði eins og hann sagði, og fékk sjónina!“ ");
INSERT INTO isl_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","„Hvar er Jesús núna?“ spurðu þeir. „Ég veit það ekki,“ svaraði hann. ");
INSERT INTO isl_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Þá fóru þeir með manninn til faríseanna. ");
INSERT INTO isl_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Nú vildi svo til að kraftaverkið hafði gerst á hvíldardegi. ");
INSERT INTO isl_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Farísearnir kröfðu manninn því sagna um atburðinn. Hann sagði þeim hvernig Jesús hefði borið leðjuna á augun og hvernig sjónin hefði komið þegar hann þvoði sér. ");
INSERT INTO isl_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","„Þessi Jesús er ekki frá Guði, fyrst hann vinnur á hvíldardögum,“ sögðu sumir þeirra. Aðrir sögðu: „En hvernig getur þá venjulegur syndari gert slík kraftaverk?“ Þetta varð þeim efni í mikla þrætu. ");
INSERT INTO isl_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Farísearnir sneru sér nú að manninum sem hafði verið blindur og spurðu ákveðnir: „Hvað vilt þú sjálfur segja um þennan mann sem gaf þér sjónina?“ „Ég held hann hljóti að vera spámaður, sendur af Guði,“ svaraði maðurinn. ");
INSERT INTO isl_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Leiðtogar Gyðinga vildu ekki trúa því að maðurinn hefði verið blindur og sendu því eftir foreldrum hans, ");
INSERT INTO isl_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","og spurðu: „Er þetta sonur ykkar? Fæddist hann blindur? Og ef svo er, hvernig hefur hann þá fengið sjónina?“ ");
INSERT INTO isl_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","„Við vitum að hann er sonur okkar og að hann fæddist blindur,“ svöruðu foreldrar hans, ");
INSERT INTO isl_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","„en við vitum ekki hver gaf honum sjónina, spyrjið hann sjálfan, hann ætti að vera nógu gamall til að svara fyrir sig.“ ");
INSERT INTO isl_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","23","Þetta sögðu þau af ótta við leiðtogana, en þeir höfðu sagt að hver sá sem segði að Jesús væri Kristur, fengi ekki að sækja guðsþjónustur. ");
INSERT INTO isl_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Þeir kölluðu því aftur á manninn, sem verið hafði blindur og sögðu: „Gefðu Guði dýrðina, en ekki Jesú, því að við vitum að Jesús er vondur maður.“ ");
INSERT INTO isl_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","„Ekki er það mitt að segja hvort hann sé vondur eða góður,“ svaraði maðurinn, „en það veit ég, að ég, sem var blindur, er nú sjáandi!“ ");
INSERT INTO isl_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","„En hvað gerði hann?“ spurðu þeir, „hvernig læknaði hann þig?“ ");
INSERT INTO isl_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","„Nei, heyrið mig nú!“ hrópaði maðurinn. „Ég hef þegar sagt ykkur það einu sinni. Tókuð þið ekki eftir, eða hvað? Hvers vegna viljið þið fá að heyra það aftur? Ætlið þið kannski líka að verða lærisveinar hans?“ ");
INSERT INTO isl_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Þá formæltu þeir honum og sögðu: „Þú ert lærisveinn hans, en við erum lærisveinar Móse. ");
INSERT INTO isl_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Við vitum að Guð talaði við Móse, en um þennan mann vitum við ekkert.“ ");
INSERT INTO isl_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","„Nú, það er einkennilegt,“ svaraði maðurinn. „Hann læknar hina blindu, en samt vitið þið ekkert um hann. ");
INSERT INTO isl_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Það er nú einu sinni svo að Guð hlustar ekki á vonda menn, heldur á þá sem tilbiðja hann og gera vilja hans. ");
INSERT INTO isl_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Frá því heimurinn varð til hefur enginn maður getað opnað augu blindra, ");
INSERT INTO isl_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","og ef þessi maður er ekki frá Guði, þá gæti hann ekki gert þetta.“ ");
INSERT INTO isl_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","„Þú sem ert fáfróður og fæddur í synd,“ hrópuðu þeir, „ætlar þú nú að fara að kenna okkur?!“ Og þeir fleygðu honum á dyr. ");
INSERT INTO isl_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Þegar Jesús frétti hvað gerst hafði, leitaði hann manninn uppi og sagði: „Trúir þú á Krist?“ ");
INSERT INTO isl_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","„Já, mig langar til þess,“ svaraði maðurinn, „en hver er hann, herra?“ ");
INSERT INTO isl_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","„Þú hefur þegar séð hann,“ svaraði Jesús, „hann er sá sem við þig talar.“ ");
INSERT INTO isl_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","„Já, Drottinn,“ sagði maðurinn, „ég trúi.“ Og hann veitti Jesú lotningu og kraup við fætur hans. ");
INSERT INTO isl_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesús sagði þá við hann: „Ég kom í heiminn til að opna augu blindra og loka augum þeirra sem halda sig sjá.“ ");
INSERT INTO isl_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farísearnir, sem stóðu þar rétt hjá, spurði þá: „Áttu við að við séum blindir?“ ");
INSERT INTO isl_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","„Ef þið væruð blindir, þá væruð þið ekki sekir,“ svaraði Jesús, „en nú segist þið vera sjáandi, en farið þó ekki eftir orðum mínum – sekt ykkar varir við.“ ");
INSERT INTO isl_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","„Sá sem ekki vill ganga inn um dyrnar til að komast inn í sauðabyrgið, heldur klifrar yfir vegginn, hlýtur að vera þjófur. ");
INSERT INTO isl_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Hirðirinn kemur alltaf inn um dyrnar. ");
INSERT INTO isl_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Dyravörðurinn opnar fyrir honum og sauðirnir heyra rödd hans og koma til hans. Síðan kallar hann á sauðina með nafni og fer út með þá. ");
INSERT INTO isl_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Hann gengur á undan þeim og þeir fylgja honum, því að þeir þekkja rödd hans. ");
INSERT INTO isl_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ókunnugum fylgja þeir ekki, heldur forðast þá, því að þeir þekkja ekki rödd þeirra.“ ");
INSERT INTO isl_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Þeir sem heyrðu Jesú segja þessa dæmisögu skildu hana ekki, ");
INSERT INTO isl_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","og því útskýrði hann hana fyrir þeim: „Ég er dyr sauðanna,“ sagði hann. ");
INSERT INTO isl_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","„Allir sem komu á undan mér voru þjófar og ræningjar og sauðirnir hlýddu þeim ekki. ");
INSERT INTO isl_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ég er dyrnar. Þeir sem koma inn um mig munu frelsast, ganga inn og út og fá gott fóður. ");
INSERT INTO isl_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Þjófurinn ætlar sér að stela; drepa og eyðileggja, en ég kom til að veita líf og nægtir. ");
INSERT INTO isl_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ég er góði hirðirinn. Góði hirðirinn leggur líf sitt í sölurnar fyrir sauðina. ");
INSERT INTO isl_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Þegar leiguliðinn sér úlfinn koma, þá flýr hann og yfirgefur sauðina, því að hann á þá ekki. Og úlfurinn ræðst á hjörðina og hún tvístrast. ");
INSERT INTO isl_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Þá flýr leiguliðinn, því að hann hugsar aðeins um launin, en honum er ekki annt um hjörðina. ");
INSERT INTO isl_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ég er góði hirðirinn og þekki mína og þeir þekkja mig, ");
INSERT INTO isl_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","rétt eins og faðirinn þekkir mig og ég föðurinn. Ég fórna lífi mínu fyrir sauðina. ");
INSERT INTO isl_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ég á líka aðra sauði í annarri rétt. Ég verð einnig að leiða þá og þeir munu hlýða rödd minni, það verður ein hjörð og einn hirðir. ");
INSERT INTO isl_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Faðirinn elskar mig vegna þess að ég legg líf mitt í sölurnar til þess síðan að fá það aftur. ");
INSERT INTO isl_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Enginn getur tekið líf mitt án míns samþykkis – ég legg það sjálfviljuglega í sölurnar. Ég hef vald til að gefa það þegar ég vil og ég hef einnig vald til að taka það aftur. Þennan rétt hefur faðir minn gefið mér.“ ");
INSERT INTO isl_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Við þessi orð Jesú urðu leiðtogar Gyðinganna enn einu sinni ósammála í skoðunum sínum um hann. ");
INSERT INTO isl_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Sumir þeirra sögðu: „Annað hvort hefur hann illan anda eða er brjálaður. Hvað þýðir að hlusta á slíkan mann?“ ");
INSERT INTO isl_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Aðrir sögðu: „Okkur virðist hann ekki hafa illan anda. Getur illur andi opnað augu blindra?“ – ");
INSERT INTO isl_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","23","Nú var vetur og Jesús var í Jerúsalem á vígsluhátíðinni. Hann var á gangi í súlnagöngum Salómons í musterinu. ");
INSERT INTO isl_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Þá umkringdu leiðtogar þjóðarinnar hann og spurðu: „Hversu lengi ætlar þú að halda okkur í óvissu? Ef þú ert Kristur, segðu okkur það þá hreinskilnislega.“ ");
INSERT INTO isl_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","„Ég hef þegar sagt ykkur það,“ svaraði Jesús, „en þið trúið mér ekki. Kraftaverkin, sem ég geri í nafni föður míns, bera mér vitni. ");
INSERT INTO isl_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Þið trúið mér ekki af því að þið tilheyrið ekki minni hjörð. ");
INSERT INTO isl_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mínir sauðir þekkja mína rödd og ég þekki þá og þeir fylgja mér. ");
INSERT INTO isl_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ég gef þeim eilíft líf og þeir munu aldrei að eilífu glatast. Enginn skal slíta þá úr hendi minni, ");
INSERT INTO isl_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","því faðir minn, sem hefur gefið mér þá, er máttugri en nokkur annar. Enginn skal ræna þeim frá mér. ");
INSERT INTO isl_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ég og faðirinn erum eitt.“ ");
INSERT INTO isl_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Þegar leiðtogarnir heyrðu þetta tóku þeir enn einu sinni upp steina til að grýta hann. ");
INSERT INTO isl_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Þá sagði Jesús: „Mörg góðverk sýndi ég ykkur frá Guði, fyrir hvert þeirra grýtið þið mig nú?“ ");
INSERT INTO isl_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","„Við grýtum þig ekki fyrir góðverk, heldur guðlast,“ svöruðu þeir. „Þú, sem ert bara venjulegur maður, segist vera Guð!“ ");
INSERT INTO isl_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","36","„Stendur ekki í lögmálinu að menn séu guðir?“ svaraði Jesús. „Fyrst Biblían, sem ekki getur farið með ósannindi, segir að þeir sem fengu boðskap frá Guði séu guðir í augum manna, hvernig getið þið þá kallað það guðlast þegar sá sem faðirinn helgaði og sendi í heiminn, segir: „Ég er sonur Guðs?“ ");
INSERT INTO isl_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Þið trúið mér ekki nema ég geri guðdómleg kraftaverk, ");
INSERT INTO isl_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","en reynið þá að trúa þeim, þótt þið trúið mér ekki, og sannfærist um að faðirinn sé í mér og ég í föðurnum.“ ");
INSERT INTO isl_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Þegar þeir heyrðu þetta reyndu þeir aftur að handtaka hann en misstu af honum. ");
INSERT INTO isl_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","41","Jesús fór austur yfir Jórdan, til staðarins þar sem Jóhannes skírði fyrst. Þar dvaldist hann og margir komu til hans. „Jóhannes gerði að vísu engin kraftaverk,“ sagði fólkið sín á milli, „en allir spádómar hans um þennan mann hafa ræst.“ ");
INSERT INTO isl_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Þarna gerðust margir trúaðir á að Jesús væri Kristur. ");
INSERT INTO isl_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Maður nokkur hét Lasarus og bjó í Betaníu ásamt systrum sínum, Maríu og Mörtu. ");
INSERT INTO isl_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","María var sú sem eitt sinn hellti dýrri ilmolíu yfir fætur Jesú og þurrkaði þá með hári sínu. ");
INSERT INTO isl_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Systurnar Marta og María sendu nú svohljóðandi boð til Jesú: „Herra, sá sem þú elskar, Lasarus, er hættulega veikur.“ ");
INSERT INTO isl_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Þegar Jesús fékk skilaboðin, sagði hann: „Þessi veikindi munu ekki enda með dauða, heldur er þeim ætlað að verða Guði til dýrðar og vegsama mig, son Guðs.“ ");
INSERT INTO isl_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesú þótti mjög vænt um Mörtu, Maríu og Lasarus, ");
INSERT INTO isl_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","en dvaldist þó enn í tvo daga þar sem hann var og sýndi ekki á sér fararsnið. ");
INSERT INTO isl_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Loks, að þeim tíma liðnum, sagði hann við lærisveina sína: „Við skulum fara til Júdeu.“ ");
INSERT INTO isl_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","„Já, en meistari!“ sögðu lærisveinarnir, „það eru aðeins nokkrir dagar síðan leiðtogarnir í Júdeu reyndu að drepa þig. Ætlarðu að fara þangað aftur?“ ");
INSERT INTO isl_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","„Það er bjart tólf stundir á dag,“ svaraði Jesús, „og þá getur maður gengið um öruggur án þess að hrasa, ");
INSERT INTO isl_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","en á nóttunni er manni hætt við að hrasa vegna myrkursins.“ ");
INSERT INTO isl_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Síðan bætti hann við og sagði: „Lasarus, vinur okkar, er sofnaður, en nú ætla ég að fara og vekja hann!“ ");
INSERT INTO isl_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","13","Lærisveinarnir héldu þá að Lasarus hefði fengið góðan nætursvefn og sögðu: „Það er gott að heyra, þá hlýtur honum að vera farið að batna!“ Jesús átti hins vegar við að Lasarus væri dáinn. ");
INSERT INTO isl_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jesús sagði því við þá berum orðum: „Lasarus er dáinn, ");
INSERT INTO isl_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","en það gleður mig ykkar vegna, því að þetta mun styrkja ykkur í trúnni. Komið, við skulum fara til hans.“ ");
INSERT INTO isl_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tómas, sem kallaður var „tvíburinn“, sagði þá við hina lærisveinana: „Við skulum fara líka og deyja með honum.“ ");
INSERT INTO isl_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Þegar þeir komu til Betaníu var þeim sagt að Lasarus væri þegar búinn að liggja fjóra daga í gröfinni. ");
INSERT INTO isl_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betanía var aðeins um þrjá kílómetra frá Jerúsalem. ");
INSERT INTO isl_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Margir leiðtogar Gyðinga voru komnir til að láta samúð sína í ljós og hugga Mörtu og Maríu. ");
INSERT INTO isl_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Þegar Mörtu var sagt að Jesús væri að koma fór hún út til móts við hann, en María var kyrr heima. ");
INSERT INTO isl_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta sagði við Jesú: „Herra, ef þú hefðir komið fyrr væri bróðir minn ekki dáinn. ");
INSERT INTO isl_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ég veit að Guð veitir þér allt sem þú biður hann um.“ ");
INSERT INTO isl_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Þá sagði Jesús: „Bróðir þinn mun rísa upp.“ ");
INSERT INTO isl_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","„Já, það mun hann gera eins og allir aðrir á degi upprisunnar,“ sagði Marta. ");
INSERT INTO isl_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","„Ég er sá sem reisi hina dauðu og gef þeim líf,“ sagði Jesús. „Hver sem trúir á mig mun lifa þótt hann deyi. ");
INSERT INTO isl_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Og sá sem eignast lífið í trúnni á mig, mun aldrei að eilífu deyja. Marta, trúir þú þessu?“ ");
INSERT INTO isl_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","„Já, herra,“ svaraði hún, „ég trúi að þú sért Kristur, sonur Guðs, sem koma átti í heiminn.“ ");
INSERT INTO isl_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Þegar hún hafði sagt þetta, fór hún og kallaði á systur sína og sagði við hana einslega: „Meistarinn er hér og vill finna þig.“ ");
INSERT INTO isl_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Þegar María heyrði þetta fór hún þegar í stað út til hans. ");
INSERT INTO isl_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús hafði staldrað við utan við bæinn, þar sem hann hitti Mörtu fyrst. ");
INSERT INTO isl_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Þegar mennirnir, sem voru í húsinu að reyna að hugga Maríu, sáu hana fara út í flýti, álitu þeir að hún væri að fara út að gröf Lasarusar til að gráta þar, svo að þeir fóru á eftir henni. ");
INSERT INTO isl_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Þegar María kom þangað sem Jesús var, kraup hún við fætur hans og sagði: „Herra, ef þú hefðir verið hér væri bróðir minn enn á lífi.“ ");
INSERT INTO isl_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Þegar Jesús sá hana gráta ásamt mönnunum, varð hann gramur, byrsti sig og spurði: ");
INSERT INTO isl_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","„Hvar er hann grafinn?“ „Komdu, við skulum sýna þér það,“ svöruðu þeir. ");
INSERT INTO isl_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Þá táraðist Jesús. ");
INSERT INTO isl_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","„Þeir voru mjög nánir vinir,“ sögðu Gyðingarnir. „Sjáið bara hve honum hefur þótt vænt um hann.“ ");
INSERT INTO isl_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","38","Aðrir sögðu: „Þessi maður læknaði blindan mann – af hverju kom hann þá ekki í veg fyrir að Lasarus dæi?“ Þegar Jesús heyrði þetta varð hann aftur gramur. Þau gengu að gröfinni, en hún var hellir og hafði stórum steini verið velt fyrir dyrnar. ");
INSERT INTO isl_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","„Veltið steininum frá,“ sagði Jesús. „Já, en það er komin nálykt af honum,“ sagði Marta, systir hins látna. „Hann hefur legið hér í fjóra daga!“ ");
INSERT INTO isl_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","„Sagði ég þér ekki: „Ef þú trúir, muntu sjá dýrð Guðs?“ “ spurði Jesús. ");
INSERT INTO isl_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Síðan var steininum velt frá. Jesús leit upp til himins og sagði: „Faðir, ég þakka þér að þú hefur heyrt bæn mína. ");
INSERT INTO isl_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Auðvitað veit ég að þú bænheyrir mig í hverju sem er, en ég sagði þetta til þess að fólkið, sem hér stendur, trúi að þú hafir sent mig.“ ");
INSERT INTO isl_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Síðan kallaði hann: „Lasarus, komdu út!“ ");
INSERT INTO isl_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Og Lasarus kom! Hann var vafinn líkblæjum og höfuð hans hulið með klút. „Takið af honum líkblæjurnar og látið hann fara.“ sagði Jesús. ");
INSERT INTO isl_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Margir Gyðinganna, sem þarna voru með Maríu, tóku nú loks trú á Jesú, ");
INSERT INTO isl_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","en aðrir fóru til faríseanna til að skýra þeim frá þessu. ");
INSERT INTO isl_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Æðstu prestarnir og farísearnir skutu þá á ráðstefnu til að ræða málin. „Hvað eigum við að gera?“ spurðu þeir. „Þessi maður gerir sannarlega kraftaverk. ");
INSERT INTO isl_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ef við látum hann eiga sig, mun öll þjóðin elta hann. Og þá mun rómverski herinn koma, drepa okkur og kollvarpa heimastjórn okkar Gyðinganna.“ ");
INSERT INTO isl_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Þá sagði Kaífas, en hann var æðsti prestur þetta árið: „Eruð þið alveg skilningslausir? ");
INSERT INTO isl_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Það er betra að einn maður deyi fyrir fólkið, en að öll þjóðin farist.“ ");
INSERT INTO isl_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Spádómsorð þessi, að Jesús ætti að deyja fyrir allt fólkið, flutti Kaífas meðan hann var í stöðu æðsta prestsins. Þessi orð komu ekki frá honum sjálfum, heldur voru þau blásin honum í brjóst. ");
INSERT INTO isl_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Þetta var spádómur um að Jesús mundi ekki einungis deyja fyrir þjóðina, heldur og fyrir öll börn Guðs sem dreifð eru um jörðina. ");
INSERT INTO isl_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Frá þessari stundu, unnu leiðtogar Gyðinga markvisst að því að lífláta Jesú. ");
INSERT INTO isl_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Eftir þetta starfaði Jesús því ekki opinberlega meðal fólksins, heldur fór frá Jerúsalem til bæjarins Efraím við eyðimörkina og þar dvaldist hann með lærisveinum sínum. ");
INSERT INTO isl_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Páskarnir, mesta hátíð Gyðinga, voru á næsta leiti. Margt sveitafólk kom til Jerúsalem nokkrum dögum fyrir hátíðina til að hreinsa sig, samkvæmt siðum þeirra, áður en sjálf hátíðin hæfist. ");
INSERT INTO isl_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Fólk þetta langaði að sjá Jesú og mikið var skrafað í musterinu. „Skyldi hann koma á páskahátíðina?“ spurðu menn hver annan. ");
INSERT INTO isl_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Farísearnir og æðstu prestarnir höfðu tilkynnt opinberlega að hver sem sæi Jesú, yrði strax að láta þá vita, svo að þeir gætu handtekið hann. ");
INSERT INTO isl_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Sex dögum fyrir páska kom Jesús til Betaníu, þar sem Lasarus bjó, sá sem hann hafði reist upp frá dauðum, ");
INSERT INTO isl_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","og nú var haldin veisla Jesú til heiðurs. Marta þjónaði til borðs og Lasarus sat við sama borð og Jesús. ");
INSERT INTO isl_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Þá var það að María tók fram krukku með dýrum ilmsmyrslum úr nardussafa og smurði fætur Jesú, og þurrkaði þá síðan með hári sínu. Við þetta fylltist húsið af sætum ilmi. ");
INSERT INTO isl_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Júdas Ískaríot, einn lærisveina hans – sá sem síðar sveik hann – sagði þá: ");
INSERT INTO isl_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","„Þetta ilmsmyrsl er gífurlega dýrt. Það hefði átt að selja það og gefa fátækum andvirðið.“ ");
INSERT INTO isl_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Þetta sagði hann ekki vegna þess að honum væri annt um fátæka, heldur sá hann um fjárreiður lærisveinanna og dró stundum undan til eigin þarfa. ");
INSERT INTO isl_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesús svaraði: „Láttu hana í friði. Hún var að undirbúa útför mína. ");
INSERT INTO isl_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Þú getur hjálpað fátækum, en samvistir okkar eru brátt á enda.“ ");
INSERT INTO isl_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Þegar almenningur í Jerúsalem frétti að Jesús væri að koma, flykktist fólk til að sjá hann og Lasarus – þann sem hann reisti upp frá dauðum. ");
INSERT INTO isl_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Af þessari ástæðu ákváðu æðstu prestarnir að taka Lasarus líka af lífi, ");
INSERT INTO isl_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","því að hans vegna höfðu margir framámenn yfirgefið þá og voru farnir að trúa því að Jesús væri Kristur. ");
INSERT INTO isl_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","13","Daginn eftir flaug sú frétt um alla borgina að Jesús væri á leiðinni til Jerúsalem. Tóku þá margir hátíðargestanna pálmagreinar sér í hönd, gengu niður veginn á móti honum og hrópuðu: „Frelsarinn! Frelsarinn! Guð blessi konung Ísraels! Dýrð sé Guði!“ ");
INSERT INTO isl_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús hafði ungan asna að reiðskjóta og rættist þar með spádómur er þannig hljóðar: ");
INSERT INTO isl_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","„Óttist ekki, Ísraelsmenn, því að konungur ykkar kemur til ykkar, hógvær og ríðandi á ösnufola!“ ");
INSERT INTO isl_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","(Lærisveinar hans skildu ekki að nú var þessi spádómur að rætast. En þegar Jesús var farinn til dýrðar sinnar á himnum, áttuðu þeir sig á hve margir spádómar höfðu ræst fyrir augum þeirra, án þess að þeir veittu því athygli.) ");
INSERT INTO isl_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Fólkið, sem sá Jesú reisa Lasarus upp frá dauðum, sagði frá þeim atburði, ");
INSERT INTO isl_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","og það varð til þess að margir fóru út til móts við Jesú – fólkið hafði heyrt um þetta stórkostlega kraftaverk. ");
INSERT INTO isl_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Þá sögðu farísearnir hver við annan: „Við höfum tapað! Sjáið þið: Allur heimurinn eltir hann!“ ");
INSERT INTO isl_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Grikkir nokkrir, sem komnir voru til Jerúsalem á páskahátíðina, ");
INSERT INTO isl_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","heimsóttu Filippus, en hann var frá Betsaída. „Herra,“ sögðu þeir við hann, „okkur langar að hitta Jesú.“ ");
INSERT INTO isl_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filippus sagði Andrési frá þessu og fóru þeir báðir til Jesú til að láta hann vita. ");
INSERT INTO isl_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","24","Jesús svaraði þeim og sagði, að nú væri komið að því að hann sneri aftur til dýrðar sinnar á himnum og bætti síðan við: „Ég verð að falla og deyja líkt og hveitikornið, sem fellur í moldina og deyr. Ef ég dey ekki, þá verð ég einsamall, eins og yfirgefið fræ, en dauði minn mun hins vegar leiða af sér mörg ný „hveitikorn“ – ríkulega uppskeru, því margir munu eignast nýtt líf. ");
INSERT INTO isl_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ef þið elskið líf ykkar hér á jörðinni, þá tapið þið því, en ef þið fórnið því, þá eignist þið eilífa dýrð í staðinn. ");
INSERT INTO isl_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ef þessir Grikkir vilja verða lærisveinar mínir, segið þeim þá að koma og fylgja mér, því að þjónar mínir verða að vera þar sem ég er. Ef þeir fylgja mér, mun faðirinn heiðra þá. ");
INSERT INTO isl_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Nú er sál mín sárhrygg. Ætti ég þá að biðja svo: „Faðir, hlífðu mér við því sem bíður mín?“ Nei, það er einmitt ástæðan til þess að ég kom. ");
INSERT INTO isl_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Faðir, gerðu nafn þitt dýrlegt.“ Þá kom rödd af himni, sem sagði: „Ég hef þegar gert það dýrlegt og mun aftur gera það dýrlegt.“ ");
INSERT INTO isl_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Mannfjöldinn heyrði röddina og héldu sumir að það hefði verið þruma, en aðrir sögðu að engill hefði talað við hann. ");
INSERT INTO isl_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Þá sagði Jesús við fólkið: „Röddin kom ykkar vegna, en ekki mín vegna. ");
INSERT INTO isl_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nú er stund dómsins runnin upp yfir þennan heim. Og þá verður Satan, höfðingja þessa heims, varpað á dyr. ");
INSERT INTO isl_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ég verð hafinn upp (á krossinum) og mun draga alla til mín.“ ");
INSERT INTO isl_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Með þessum orðum gaf hann til kynna hvernig hann myndi deyja. ");
INSERT INTO isl_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","„Býstu við dauða þínum?“ spurði fólkið. „Okkur skilst að Kristur eigi að lifa að eilífu og að hann muni aldrei deyja. Af hverju segirðu að hann muni deyja? Um hvaða Krist ertu að tala?“ ");
INSERT INTO isl_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesús svaraði: „Enn um sinn mun ljós mitt skína á meðal ykkar. Gangið því í ljósinu meðan hægt er, áður en myrkrið skellur á, því eftir það getið þið ekki lengur ratað rétta leið. ");
INSERT INTO isl_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Trúið á ljósið meðan tími er til og þá verðið þið ljósberar.“ Að svo mæltu yfirgaf Jesús þá og faldi sig fyrir þeim. ");
INSERT INTO isl_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Þrátt fyrir öll kraftaverkin sem hann hafði gert, trúðu fæstir því, af mannfjöldanum, að hann væri Kristur. ");
INSERT INTO isl_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Þetta kom heim og saman við það sem Jesaja spámaður hafði sagt: „Drottinn, hver mun trúa okkur? Hver mun líta á hin miklu kraftaverk sem vitnisburð um þig?“ ");
INSERT INTO isl_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Þeir gátu sem sagt ekki trúað, enda hafði Jesaja einnig spáð eftirfarandi: ");
INSERT INTO isl_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","„Guð hefur blindað augu þeirra og hert hjörtu þeirra, svo að þeir hvorki sjá né skilja, til að þeir snúi sér til mín og ég geti læknað þá.“ ");
INSERT INTO isl_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Þessi orð Jesaja voru spádómur um Jesú, því að hann hafði séð dýrð Krists í sýn. ");
INSERT INTO isl_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Samt trúðu ýmsir af leiðtogum þjóðarinnar að Jesús væri Kristur. En þeir vildu ekki láta það í ljós af ótta við að farísearnir bönnuðu þeim að sækja guðsþjónustur í samkomuhúsunum. ");
INSERT INTO isl_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Hrós manna var þeim meira virði en dýrð Guðs. ");
INSERT INTO isl_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Nú hrópaði Jesús: „Sá sem trúir mér, trúir sjálfum Guði sem sendi mig. ");
INSERT INTO isl_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Þegar þið sjáið mig, sjáið þið þann sem sendi mig. ");
INSERT INTO isl_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ég er ljós sem kom til að skína í þessum dimma heimi, svo að þeir sem mér treysta, þurfi ekki framar að ganga í myrkrinu. ");
INSERT INTO isl_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ég dæmi ekki þá sem óhlýðnast orðum mínum, því að ég kom til að frelsa heiminn en ekki til að dæma hann. ");
INSERT INTO isl_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Þeir sem hafna mér og mínum boðskap, verða dæmdir á degi dómsins, eftir sannleikanum sem ég hef flutt. ");
INSERT INTO isl_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Það sem ég hef sagt eru ekki mín orð, heldur hef ég flutt ykkur það sem faðir minn bauð mér að segja. ");
INSERT INTO isl_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ég veit að orð hans gefa eilíft líf og þess vegna hef ég sagt allt það sem hann bauð mér að segja.“ ");
INSERT INTO isl_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Það var komið kvöld daginn fyrir páskahátíðina. Jesús vissi, að stund hans var komin að fara burt úr þessum heimi og til föðurins á himnum. ");
INSERT INTO isl_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Þegar þeir neyttu kvöldmáltíðarinnar hafði Satan þegar skotið því að Júdasi Símonarsyni Ískaríot, að nú væri einmitt rétti tíminn til að framkvæma þá fyrirætlun sína að svíkja Jesú. ");
INSERT INTO isl_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús vissi að faðirinn hafði gefið honum allt vald og að hann var kominn frá Guði og mundi snúa aftur til Guðs. ");
INSERT INTO isl_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Jesús stóð nú upp frá kvöldmáltíðarborðinu, fór úr kyrtlinum og batt stóran klút um mitti sér. ");
INSERT INTO isl_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Síðan hellti hann vatni í skál og tók að þvo fætur lærisveinanna og þurrka þá með klútnum sem hann hafði um mittið. ");
INSERT INTO isl_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Þegar hann kom að Símoni Pétri, sagði Pétur: „Meistari, ætlar þú að fara að þvo mér um fæturna?“ ")