﻿USE sofia;
DROP TABLE IF EXISTS sofia.isd_vpl;
CREATE TABLE isd_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES isd_vpl WRITE;
INSERT INTO isd_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Kitu inanggayát na, ay pinarsuwa ne Dios ya lángit se iya kalawagán. ");
INSERT INTO isd_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ay tu kalawagán kitun, ay áwan na nga singasingan, se áwan na nga maya-mayán. Nagìbat tala tu pane ngúdu natu pabeg danum nga magsag-saggiyár. Ay ya Ispiritu ne Dios, ay magalìlekus kitu paningúdu natu danum. ");
INSERT INTO isd_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ay nán ne Dios, “Magwada ka mán,” nán na. Ay tútu atán ya wada ngin. ");
INSERT INTO isd_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ay napiya tutu wala ya wada ki nagsisíngan ne Dios! Ay se na pagsanutan ya wada se iya gìbat. ");
INSERT INTO isd_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ay nengagánan na ya wada ka Algaw, ay nengagánan na pe ya gìbat ka Gabi. Ay se yala nga naggídám, ay se yala nga pagmakát. Ay ittu tun tu nunna nga algaw. ");
INSERT INTO isd_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ay se yala nán manin ne Dios, “Atán din ya pagbàtán naya angap ki ngúdu se iya danum kiya taggad,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ay nàwa nga kurug. Ay díkod, nàwa ne Dios ya ngúdu nga ittu ya nagbàtán naya angap se ya danum ked taggad di. ");
INSERT INTO isd_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ay nengágan ne Dios ya ngúdu ka lángit. Ay tútu naggídám se yala nga pagmakát manin. Ittu tun tu mekàduwa ngalgaw. ");
INSERT INTO isd_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ay se yala nán ne Dios manin, “Maalmung nga mapabeg din kampela ngin nin ya danum, ta senu lumtuwád kuma ya giyán na áwan danum,” nán na. Ay nàwa nga kurug. ");
INSERT INTO isd_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ay nengágan ne Dios ya giyán na áwan danum ka Lusà. Ay tu naalmung nga danum ma napabeg ay nengágan na ka Bebay. Ay napiya tutu wala idi ki nagsisíngan ne Dios. ");
INSERT INTO isd_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ay se yala nga nán ne Dios, “Patubuwam mán na lusà daya ngámin baláki nga kad-kaddat se daya mul-múla nga magbukal se daya kay-káyu wa magbúnga se magbukal pe,” nán na. Ay nàwa nga kurug. ");
INSERT INTO isd_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Tummúbu ki lusà daya ngámin bal-baláki daya mul-múla. Atán ngámin baláki daya magbukal la mul-múla se daya kay-káyu wa magbúnga ka nagbukal. Ay napiya tutu wala idi ki nagsisíngan ne Dios. ");
INSERT INTO isd_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ay se yala manin naggídám ay se yala manin pe ya pagmakát. Ay ittu tun tu mekàlu wa algaw. ");
INSERT INTO isd_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ay nán manin ne Dios, “Lumtuwád din ngámin daya makidde ka wada ka lángit, ta senu atán pangilasínán kiya algaw se kiya gabi. Ay senu atán pe ya pangemaddán kadaya nagbal-baláki nga mà-màwa se kadaya al-algaw se daya dagudagun. ");
INSERT INTO isd_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ay ittu pe dayán daya nawada ka lángit nga mangwada kiya kalawagán,” nán ne Dios. Ay ittu kurug tu nàwa. ");
INSERT INTO isd_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Napaltuwád ne Dios ya duwa nga dadakkal la makawada. Tu ab-abay ay ittu ya mangwada ki algaw, ay tu isa, ay ittu ya mangwada ki gabi. Ay atán pe daya bittuwan. ");
INSERT INTO isd_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Nippáy ne Dios dedi ka lángit, senu wadaán da ya kalawagán. ");
INSERT INTO isd_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Ay senu mangwada da ki algaw se ki gabi, ay aggída pe ya mamagsibna kiya gìbat se iya wada. Ay napiya tutu wala idi ki nagsisíngan ne Dios. ");
INSERT INTO isd_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ay se yala naggídám manin se yala pagmakát manin. Ittu idi ya mekappát ta algaw. ");
INSERT INTO isd_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ay se yala manin nán ne Dios, “Lumtuwád din kiya danum daya nagpapangan na sibbibiyág, ay lumtuwád din pe daya ngámin bal-baláki nga an-an-anù nga magkay-káyab ka ngúdu.” ");
INSERT INTO isd_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ay díkod napaltuwád ne Dios daya dadakkal la alolag ki bebay, se daya adu wa nagbal-baláki nga sissida, se daya adu nga magbiyág ki danum, ay se daya nagbal-baláki nga an-an-anù. Ay napiya tutu wala dedi ki nagsisíngan ne Dios. ");
INSERT INTO isd_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ay se yala nga binindisiyonán ne Dios da nga nán na, “Gumánab kayu ta senu umadu kayu tutu wala nga magyán ki bebay. Ay dakayu wa an-anù, gumánab kayu pe kídi kalawagán,” nán ne Dios. ");
INSERT INTO isd_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ay se yala naggídám se yala manin pagmakát. Ittu tun tu mekalimma nga algaw. ");
INSERT INTO isd_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ay se yala nga nán ne Dios manin, “Paltuwádam mán na lusà ngámin daya bal-baláki nga alolag. Mangiltuwád ka kadaya maáyam ma ummán kadaya báka se daya duddúma. Iltuwád mu pe daya ngámin bal-baláki nga alsádu wa alolag, se daya ul-ulullag ga kumar-káray!” nán ne Dios. Ay ittu mà tu nàwa. ");
INSERT INTO isd_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Napaltuwád ne Dios ngámin na baláki daya alsádu wa ul-ulolag se daya ngámin baláki áyam, ummán kadaya báka se daya duddúma, ay oray pe daya ngámin bal-baláki daya magkar-káray ki lusà. Ay napiya tutu wala dedi ki nagsisíngan ne Dios. ");
INSERT INTO isd_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ay se yala nán ne Dios manin, “Kuwaan tada ya tolay ka ummán kadàtada. Aggída ya pangiturayan tada kadaya ngámin sissida, se kadaya ngámin an-anù, ay se kadaya ngámin na ul-ulolag, alsádu se ámu. Aggída ya mangituráy kadaya ngámingámin na kumar-káray ked útun lusà,” nán ne Dios. ");
INSERT INTO isd_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ay díkod kinuwa ne Dios ya tolay ka ummán kaggína. Nagpáda da se iya tolay. Kinuwa nada ka laláki se babay. ");
INSERT INTO isd_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ay se yala nga binindisiyonán ne Dios da nga nán na kaggída, “Gumánab kayu, ta senu umadu kayu tutu wala. Gumánab kayu kiya ngámin na kalawagán, ay se iturayán nu pe. Iturayán nu daya sissida se daya an-anù se daya ngámin na sibbibiyág ga atán kid útun lusà,” nán ne Dios. ");
INSERT INTO isd_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ay nán ne Dios manin, “Ye sinnan nu! Iddè kadakayu daya ngámin na mul-múla nga magbukal la tumúbu kiya lusà. Ay oray pe daya kay-káyu wa magbúnga se magbukal, ay idde kuda kadakayu pe. Tu dayán daya mabalin nu wa kanan ka pagbiyág nu. ");
INSERT INTO isd_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ay daya kad-kaddat se daya kay-káyu, ay tu dayán daya mabalin kanan daya ngámin na ul-ulolag se daya an-anù se daya ngámin na sibbibiyág nga kumar-káray kid útun lusà,” nán ne Dios. Ay ittu mà kurug ya nàwa. ");
INSERT INTO isd_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ay kurug mà a napiya tutu wala ngámin daya kinuwa ne Dios ki nagsisíngan na. Ay naggídám manin ay se yala manin pagmakát. Ittu idi ya mekannam ma algaw. ");
INSERT INTO isd_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ay díkod, nabalin nin ya namarsuwa ne Dios kiya lángit se ya kalawagán se daya ngámin na atán kadayán. ");
INSERT INTO isd_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ay kitu unag annam ngalgaw, ay nabalin ngámin ne Dios daya ubra na, ay se la nagimáng kitu mekapittu nga algaw. ");
INSERT INTO isd_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Díkod binindisiyonán ne Dios ya mekapittu wa algaw, se na ipadúma kadaya ngámin na algaw, ay se pinagbalin na pe ka napatag ga algaw. Ata ittu tu naggimáng na kadatu ngámin na ubra na nga nagparsuwa. ");
INSERT INTO isd_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ay tu dayán lugud daya kinuw-kuwa ne Dios kaggína nga nagparsuwa kadaya lángit se iya kalawagán. Kitu dam-dámu ne APU Dios nga namarsuwa kiya lángit se kídi kalawagán, ");
INSERT INTO isd_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ay áwan pikam ma mul-múla kadaya tanatanáp, se áwan pikam pe tumúbu wa kad-kaddat, áta akkan pikam ma pinagudán ne APU Dios, ay se áwan pikam pe ya magtálun. ");
INSERT INTO isd_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ngamay atán nala ya danum ma maggayát ka taggad nga gumbuwà, nga ittu tu mangbasa kitu ngámin na lusà. ");
INSERT INTO isd_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ay lusà tu kinuwa ne Apu Dios ka tolay, ay se na ngala nga inangtán tu igung na ka ángat ta mamagbiyág, ay díkod nagángat pe yin tu tolay nga sibbiyág pe yin. ");
INSERT INTO isd_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ay uwad kamulán na kinuwa ne APU Dios ka giyán na nepangágan na ka Eden. Atán kitu pane lattakán. Ay kattoni tu nangippayán na kitu tolay ya kinuwa na. ");
INSERT INTO isd_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ay pinatúbu ne APU Dios ki lusà ngámin datu kay-káyu wa napiya sisinnán, ay se namit pe nga búnga. Ay kitu túlad natu kamulán, ay uwad tu káyu wa nu mangán ta kitu búnga na, ay akkan ta mataatay yin. Ay uwad pe kitúni tu káyu wa nu mangán ta kitu búnga na, ay mammuwán ta ya napiya se ya nadakè. ");
INSERT INTO isd_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ay kattoni Eden, ay atán wángag nga magpagayát kattoni. Ay nepaasà idi kitu kamulán, ta ittu tu mangbasa kitu kamulán. Ay kitu panillod natu kamulán, ay nasiparà a napagkappát tin tu wángag. ");
INSERT INTO isd_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Tu nunna nga pasáni, ay nagngágan ka Pison. Ittu tu manalen kitu lebut natu giyán na nagngágan ka Havila. Uwad balitù kitúni. ");
INSERT INTO isd_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Ay datu balitù kitúni nga giyán, ay pabeg ga napiya. Ay atán da pe datu napatag ga batu wa nagngágan ka bedeliyo se itu batu wa nagngágan ka oniko. ");
INSERT INTO isd_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ay tu mekàduwa nga pasáni natu wángag, ay nepangágan da ka Gihon. Ittu idi ya manalen kitu lebut natu giyán na nagngágan ka Cus. ");
INSERT INTO isd_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ay ya ngágan natu mekàlu, ay Tigris. Manalen ka pane lattakán ka Asiria. Ay tu mekappát ta pasáni natu wángag, ay nengágan ka Eufrates. ");
INSERT INTO isd_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ay kitu kamulán ka Eden ya nangipannán ne APU Dios kitu tolay ya kinuwa na. Aggína ya nippáy ne Apu Dios nga magubra se magtagasíngan kitu kamulán. ");
INSERT INTO isd_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ay se yala nga binílin ne APU Dios tu tolay nga nán na, “Mabalin mu ya mangalà ka búnga daya oray iinna nga káyu kídi kamulán ka kanan mu. ");
INSERT INTO isd_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Tittu ya búnga naya káyu wa pakammuwán ta kiya napiya se nadakè ya kannawan mu. Akkan ka mangán kiyán, áta nu mangán ka kiya búnga na, ay kurug ga matay ka kiya oras sa angngán mu,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ay se yala nán ne APU Dios ki lammat na, “Akkan napiya nu sissa ya laláki. Pangwa ku ka ummán kaggína nga mabalin makaseng kaggína,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ay datu ngámin alolag se an-anù a pinarsuwaán ne Apu Dios kiya lusà, ay nippannán nada ngámin kitu giyán tu tolay, ta sinnan na nu nágan daya ipangágan na kaggída. Ay nu nágan tu nepangágan na kaggída, ay ittu tunin tu ngag-ngágan da. ");
INSERT INTO isd_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ay tútu nginagánan natu tolay ngámin datu áyam se datu an-anù se datu alsádu wa ulolag. May tu Adan (tu yán tu ngágan natu tolay) ay áwan na nga nasingan a ummán kaggína nga makaseng kaggína. ");
INSERT INTO isd_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ay díkod ya kinuwa ne APU Dios, ay pinatalà na tu Adan. Ay nìlà tutu wala kurug tu Adan. Ay se yala nga inalà ne Dios tu isa nga tàgáng tu Adan, ay se nala manin pinolit tu baggi na. ");
INSERT INTO isd_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ay ya kinuwa ne APU Dios kitu tàgáng nga inalà na kitu laláki, ay kinuwa na ka tolay pe nga babay. Ay se na ngala nippan kitu laláki. ");
INSERT INTO isd_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ay tútu nán tu laláki, “Tu idi yin gáyám. Ittu idi ya kapádà tutu wala. Ay nagpáda pe ya baggi mi nga duwa. Ay gapu ta iyà kam ma laláki ya naggayatán na, ay ipangágan ku ka babay,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ay gapu ta ummán kiyán ya nàwa, ay túya masápul la panáwan naya laláki ya ama se ina na, ay se la mawe mepagsissa kiya atáwa na, ta senu magbalin da nga duwa ka sissa. ");
INSERT INTO isd_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ay tu laláki se itu atáwa na, ay soba da ngamay akkan da wayya nga mìpat. ");
INSERT INTO isd_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ay kadaya ngámin na alsádu wa ulolag ga pinarsuwa ne APU Dios, ay tu idaw ya kasiríbán na mangasaba. Ay isa nga algaw, nán na kitu babay, “Kurug ga nán ne Dios kadakayu nga akkan kayu mangán kiya búnga daya kay-káyu kiya kamulán?” nán na. ");
INSERT INTO isd_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","May nán natu babay kitu idaw, “Mabalin mi kanan kanu daya búnga daya kay-káyu kiya kamulán ");
INSERT INTO isd_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ngamay akkan ya búnga naya káyu nga atán kiya túlad naya kamulán. Ay akkan mi kanu pe ya tùbítan. Ay nu mangán kami onu tùbítan mi, ay matay kami kanu,” nán natu babay. ");
INSERT INTO isd_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ay se yala manin nán natu idaw kitu babay, “Akkan kayu mà kurug ga matay a! ");
INSERT INTO isd_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Nán ne Dios kiyán áta ammu na nga kiya angngán nu kiya búnga na, ay árig malùtán daya lam-lammat nu. Ay ammu nu win ya napiya se iya nadakè, ay ummán kayu pe yin kaggína,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ay díkod kane masingan natu babay nga nakal-kalùmímit tu búnga natu káyu, ay nán na nga napiya kanan. Ay nammuwán na pe nga makapasírib, áta malásin na ya napiya se iya nadakè nu mangán kitu búnga na. Ay díkod nangalà kitu búnga na, ay se na kanan. Ay se na niddán pe tu atáwa na nga atán pe yin kitu giyán na. Ay díkod, nangán pe. ");
INSERT INTO isd_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ay ittu pe yin tu pagkìlát da ngala nga ummán ka nalùtán tu mata da nga duwa. Ay nammuwán da pe yin na soba da gáyám. Ay díkod, nagásip da kadatu dadakkal la adon nga ittu tu pinagken da. ");
INSERT INTO isd_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ay kitu gid-gidám min, ay nagìna da nge Apu Dios sa atán kitu kamulán na magdàdàdà. Ay tútu nagsirù da ke APU Dios kadatu kay-káyu kitu kamulán. ");
INSERT INTO isd_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ay díkod kirrawán ne Apu Dios tu laláki nga nán na kaggína, “Wà naya giyán mu?” nán na. ");
INSERT INTO isd_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ay, “Nagsirù à kidde!” nán na. “Ta nagìna taka nga magdàdàdà kiya kamulán, ay mìpat tà magpassingan kikaw, áta soba ngà,” nán tu Adan. ");
INSERT INTO isd_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ay tútu nán ne Apu Dios, “Inna ya magkuna kikaw nga soba ka? Nangán kayu ta, kitu búnga natu káyu wa akkan ku wa pakkán kadakayu?” nán na. ");
INSERT INTO isd_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ay summungbát tu laláki nga nán na, “Ay tu babay ya niddem ma kabul-bulun ku ya nangidde kiyà, ay kinnán ku pe,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ay se yala nán ne APU Dios kitu babay, “Taanna, tura mu wa kinuwa yán ta?” nán na. “Ay tu idaw mà! Kinasaba nà, ay nangán nà a kurug,” nán natu babay. ");
INSERT INTO isd_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ay díkod nán ne APU Dios kitu idaw, “Gapu ta kinuwa mu idi, ay mapánis ka. Kakal-kalakkán ka kadaya ngámin ulolag ga áyam se kadaya ngámin na alsádu. Ata manggayát kídi, ay ya sinay mu ya panalen mu; Ay melubulubu ki lusà daya kanan mu panda kiya agbiyág mu. ");
INSERT INTO isd_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Manggayát kídi ay pagkalingáan takayu se iya babay. Ay ummán pe kadaya annánà nu wa duwa. Palpálan na ya an-anà na ya úlum, ay tugkawwan mu ya túmang na,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ay nán ne Apu Dios kitu babay, “Gapu kiya kinuwám, ay paaduwan ku daya rígát mu kiya kabùsit mu, ay se pagbalinan ku ka natakit ya aggan-anà mu. Ay oray nu mapakuna, ay masápul mu pikam mala ya amminya naya atáwam, ay se iturayán naka pe.” ");
INSERT INTO isd_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ay nán ne APU Dios kitu Adan, “Gapu ta nekurug mu ya atáwam, ay se ka nga nangán pe kitu búnga natu káyu wa akkan ku pakkán kadakayu, ay pagdakean ku ya lusà. Manggayát kídi panda kiya agbiyág mu, ay magrig-rígát ka pikam ma magkuwa kiya lusà se mu la nga mapowad ya kanan mu. ");
INSERT INTO isd_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ay tumúbu pe daya kaddat ta narasi se nabúdu. Ay oray nu mapakuna, ay daya imúlam ya paggalakkán mu ka kanan mu. ");
INSERT INTO isd_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Magpakarígát ka pikam ma magkuwa se mu la nga mapowad ya kanan mu. Ummán kiyán nin ya agbiyág nu panda kiya katay nu nga ittu yanin ya aggulli nu kiya lusà a naggayatán nu. Ata nàwa kayu ka lusà. Ay díkod lusà pe ya tungpál nu kammin,” nán ne Apu Dios. ");
INSERT INTO isd_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ay nengagánan tu Adan ka Eva tu atáwa na. (Ya sarut nayán na ngágan, ay biyág). Ata aggína ya bíláng ina daya ngámin na tolay oray ka wàna. ");
INSERT INTO isd_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ay pinangwa ne APU Dios de Adan na magatáwa ka kawas da nga lálat nga ittu tu pinagbádu da ngin. ");
INSERT INTO isd_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ay se yala nga nán ne APU Dios, “Kídi yin, ay nagbalin daya tolay ka ummán kadàtada, ta ammu da ngin ya napiya se nadakè. Nadà-dakè nu rán dala nga mangán pe kitu búnga natu káyu wa mamagbiyág ka áwan panda, áta akkan da ngin mataatay,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ay tútu pinatálaw ne APU Dios da kitu kamulán ka Eden, se na pinapan ne Adan na magkuwa kiya lusà nga ittu ya naggayatán na kampela ngin nin. ");
INSERT INTO isd_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Pinatálaw nada, ay se yala nangippáy ka isa kadaya kangatuwán na ilángit kitu pane lattakán natu kamulán. Ay uwad pe ya nippáy na nga miwas-wasáwas nga maggilagiláb ba apuy nga sinan ispáda nga ittu tu magbantáy kitu káyu wa mamagbiyág ka áwan panda. ");
INSERT INTO isd_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ay díkod din nagallay de Adan se Eva nga magatáwa. Nabùsit se nagan-anà e Eva ka isa nga laláki. Ay nengágan na ka Cain. Ay nán na, “Nagan-anà à ka laláki gapu kiya nesisseng ne Apu kiyà,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ay se yala nagan-anà manin ka isa nga laláki. Ay nepangágan na ka Abel. Ay díkod atán na wagi tu Cain nin. Kane umabay da nga duwa, ay tu Abel tu maragtarakan kadatu karneru da. Ay tu Cain tu magtal-tálun. ");
INSERT INTO isd_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ay kane din na mabà-bayág, ay nangidátun tu Cain ke APU kitu ápit na kitu tálun na. ");
INSERT INTO isd_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ay ummán pe kitu Abel. Nagparti kadatu nunna nga annánà datu tarakan na nga karneru. Ay piníli na datu kapíyán na lápi, ay ittu datun datu nedátun na ke APU Dios. Ay naganggam me APU Dios kitu nedátun tu Abel. ");
INSERT INTO isd_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ngamay akkan na nga pinagan-anu tu nedátun tu Cain. Ay tútu nalùsaw pànang tu Cain. Melalásin nala kitu singan na. ");
INSERT INTO isd_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ay tútu kinuna ne APU kitu Cain, “Tura ka nga malùsaw ta? Ay se tura ka pe nalom-lomád? ");
INSERT INTO isd_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Wayya taka la nga di pàgan nu ya napiya ya kinuwám! Ay nu akkan napiya daya kuk-kuwaan mu, ay tagay ka tutu wala makabásul lin, ay meparò ka magbásul lin nu kuwa. Ngamay masápul la pàkadan mu yán,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ay tu Cain, ay inayabán na tu Abel la wagi na nga mawe kitu tal-tálun. Ay kane atán da ngin kitu tal-tálun, ay inámang tu Cain tu Abel, ay napatay na. ");
INSERT INTO isd_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ay tútu nán ne APU kitu Cain, “Ka wàna giyán ne Abel nga wagi mu?” nán na. Ay nán tu Cain na sumungbát, “Mai! Wayya ngala nga iyà ya magtag-tagasíngan kaggína!” nán na. ");
INSERT INTO isd_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ay tútu, “Nágan naya kinuwám kitu wagim ta?” nán ne APU. “Ya dága na ki lusà ya mangipakammu kiya kinuwám kaggína. Ummán ka makap-apáuy nga makiseng kiyà nga bumálat,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","“Ay gapu kiyán na kinuwám, ay áwan mu málaálà ki lusà nga ittu ya nanglassap kitu dága natu wagi mu nga pinatay mu. ");
INSERT INTO isd_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ay oray nu magkuwa ka, ay áwan mu wayya nga maap-ápit. Ay magal-aliwagwag ka pe yin na áwan pagag-agyanán,” nán ne APU Dios kitu Cain. ");
INSERT INTO isd_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ay nán tu Cain ke APU, “Akkan ku meturad idi ya pannakapánis ku gapu kitu nàwà, áta nadammat pànang. ");
INSERT INTO isd_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Pagtaláwan nà kídi ya lusà, ay meadayyu wà pe yin kikaw. Magal-aliwagwag gà in, ay áwan ku pe pagyanán. Ay patayan dà daya makasingan kiyà,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ay tútu nán ne Apu Dios kaggína, “Akkan. Ta nu atán mamatay kikaw, ay mamin-pittu ya dammat naya kapánis na,” nán na. Ay díkod, uwad nippáy ne Apu Dios nga tagematun na kitu Cain, ta senu akkan patayan daya makasingan kaggína. ");
INSERT INTO isd_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ay díkod nagtálaw tu Cain ki àráng ne Apu Dios se yala nagyán ka Nod nga pane lattakán ka Eden. ");
INSERT INTO isd_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ay nangatáwa tu Cain kitúni, ay se da nagan-anà ka isa nga laláki. Ay nepangágan da ka Enoc. Nangwa pe tu Cain ka íli kitúni, se nepangágan na pe ka Enoc. ");
INSERT INTO isd_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Tu Enoc, ay pútut na tu Irad, ay tu Irad, ay pútut na tu Mehujael. Tu Mehujael, ay pútut na tu Metusael. Ay ya pútut tu Metusael ay tu Lamec. ");
INSERT INTO isd_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Ay tu Lamec nangatáwa ka duwa. Tu Ada se tu Zilla. ");
INSERT INTO isd_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Tu Ada ay neanà na tu Jabal. Ay idi ya Jabal, aggína ya makin-pútut kadatu maragtarakan kadaya báka. Ay baw-bawi pe yala tu nag-agyanán da. ");
INSERT INTO isd_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ay tu Jabal ay atán wagi na nga Jubal. Aggína tu bátug apuapu datu marammalíing se datu maggitarra. ");
INSERT INTO isd_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ngamay tu Zilla, ay nagan-anà pe ka laláki, ay nepangágan na ka Tubal-Cain. Aggína tu nunna nga maragbattál kadaya aruminta nga balayyáng se bága. Ay uwad pe ya wagi tu Tubal-Cain na babay, ay nepangágan da ka Naama. ");
INSERT INTO isd_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ay isa nga algaw, nán tu Lamec kadatu attáwa na, “Gìnán dà, dakayu Ada se Zilla. Dakayu wa duwa nga attáwà, gìnán nu ya kagiyan ku: Uwad pinatay ku nga laláki ta tinalíngu nà. Sinúlung nà yán na bag-bagu. ");
INSERT INTO isd_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ay nu mamin-pittu ya bálat kiya pumatay ke Cain, ay mamin-pittu púlu se pittu ya bálat kiya pumatay kiyà.” ");
INSERT INTO isd_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ay nagan-anà manin pe de Adan se tu Eva. Nagan-anà da ka laláki, ay nepangágan da ka Set (ay ya sarut nayán, ay nidde). Ata nán tu Eva nga niddán ne Apu Dios manin ka isa nga an-anà a kasukát tu Abel ta pinatay lugud tu Cain. ");
INSERT INTO isd_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Nangatáwa tu Set, ay se nagan-anà da pe ka isa nga laláki. Ay nepangágan da ka Enos. Ay kitun na al-algaw pe yin tu inanggayát datu tolay ya magday-dáyaw ke Dios. ");
INSERT INTO isd_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Ay kitu inamarsuwa ne Dios ki tolay, ay kinuwa na ka ummán kaggína. Laláki se babay datu tolay ya kinuwa na. Binindisiyonán nada ay se nengagánan nada ka Tolay kitu namarsuwa na kaggída. Ay tu idi ya lista datu gakagaka natu Adan. ");
INSERT INTO isd_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ay kitu magatut se tallu púlu dagun tu Adan nin, ay nakapútut ka isa nga laláki nga kamur-murangán na kam. Nepangágan na ka Set. ");
INSERT INTO isd_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Nanggayát kitu nekeanà natu Set, ay walu gatut ta dagun pikam tu inagbiyág natu Adan. Uwad da pikam duddúma nga pútut na. ");
INSERT INTO isd_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ay díkod, ya dágup natu dagun natu Adan, ay siyám gatut se tallu púlu se la nga natay. ");
INSERT INTO isd_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Ay kane magatut se limma dagun tu Set tin, ay neanà tu pútut na nga Enos. ");
INSERT INTO isd_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Nanggayát kitu nekeanà natu Enos, nagbiyág tu Set ka walu gatut se pittu dagun. Uwad pikam pe datu duddúma nga pútut na. ");
INSERT INTO isd_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ay díkod, ya dágup natu dagun natu Set, ay siyám gatut se sangapúlu se duwa dagun se yala nga natay. ");
INSERT INTO isd_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ay kane siyám púlu dagun tu Enos sin, ay neanà tu an-anà na nga Kenan. ");
INSERT INTO isd_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ay nanggayát kitu nekeanà tu Kenan, ay nagbiyág pikam tu Enos ka walu gatut se sangapúlu se limma dagun. Ay uwad da pikam sabáli nga pútut na. ");
INSERT INTO isd_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ay díkod, ya dágup natu dagun natu Enos, ay siyám gatut se limma se la nga natay. ");
INSERT INTO isd_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Ay kane pittu púlu dagun tu Kenan nin, ay neanà tu Mahalalel nga pútut na. ");
INSERT INTO isd_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Ay nanggayát kitu nekeanà tu Mahalalel, ay nagbiyág pikam tu Kenan ka walu gatut se appát púlu dagun. Uwad da pikam pe sabáli nga annánà na. ");
INSERT INTO isd_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ay díkod, ya dágup tu dagun na inagbiyág tu Kenan, ay siyám gatut se sangapúlu se la nga natay. ");
INSERT INTO isd_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ay kane annam púlu se limma dagun tu Mahalalel lin, ay neanà tu Jared nga pútut na. ");
INSERT INTO isd_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Nanggayát kitu nekeanà natu Jared, ay nagbiyág pikam tu Mahalalel ka walu gatut se tallu púlu dagun. Ay uwad da pikam pe sabáli nga pútut na. ");
INSERT INTO isd_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ay díkod, ya dágup natu dagun tu Mahalalel, ay walu gatut se siyám púlu se limma se la nga natay. ");
INSERT INTO isd_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Ay kane magatut se annam púlu se duwa dagun tu Jared din, ay neanà tu Enoc nga pútut na. ");
INSERT INTO isd_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Nanggayát kitu nekeanà tu Enoc, ay nagbiyág pikam tu Jared ka walu gatut dagun. Ay uwad da pikam pe sabáli nga pútut na. ");
INSERT INTO isd_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ay díkod, ya dágup tu dagun tu Jared ay siyám gatut se annam púlu se duwa dagun, ay se yala nga natay. ");
INSERT INTO isd_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ay kane annam púlu se limma dagun tu Enoc kin, ay neanà tu Metusela nga pútut na. ");
INSERT INTO isd_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Nanggayát kitu nekeanà tu Metusela, ay nagbiyág pikam tu Enoc kídi kalawagán ka tallu gatut ta dagun. Uwad da pikam pe sabáli nga pútut na. Ay kadatun na dagudagun, ay nebul-bulun peyapeyang ke Dios. ");
INSERT INTO isd_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ay díkod, ya dágup datu dagudagun na kaatán tu Enoc kídi kalawagán ay tallu gatut se annam púlu se limma dagun. ");
INSERT INTO isd_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Ay se yala nga umawan, áta inalà ne Dios ka lángit nga sibbibiyág. ");
INSERT INTO isd_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Ay kane magatut se walu púlu se pittu dagun tu Metusela ngin, ay neanà tu Lamec nga pútut na. ");
INSERT INTO isd_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Nanggayát kitu nekeanà tu Lamec, ay nagbiyág pikam tu Metusela ka pittu gatut se walu púlu se duwa nga dagun. Ay uwad da pikam pe sabáli nga pútut na. ");
INSERT INTO isd_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ay díkod, ya dágup natu dagun tu Metusela ay siyám gatut se annam púlu se siyám, ay se la nga natay. ");
INSERT INTO isd_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ay kane magatut se walu púlu se duwa dagun tu Lamec kin, ay nakapútut ka isa nga laláki. ");
INSERT INTO isd_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ay nepangágan na ka Noa. Ata nán na, “Idi nga an-anà, ay ittu ya mangidde kadàtada ka pakemangngán tada kiya nasulit nga ubra tada kídi ya lusà a ginedán ne APU,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nanggayát kitu nekeanà tu Noa, ay nagbiyág pikam tu Lamec ka limma gatut se siyám púlu se limma nga dagun. Ay uwad pikam pe datu duddúma nga pútut na. ");
INSERT INTO isd_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ay díkod, ya dágup natu dagun tu Lamec ay pittu gatut se pittu púlu se pittu dagun, ay se la nga natay. ");
INSERT INTO isd_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ay kane limma gatut dagun tu Noa ngin, ay nagpútut ka tallu nga lalláki: de Sem, tu Ham, se tu Jafet. ");
INSERT INTO isd_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ay kane umadu datu tolay kídi ya kalawagán, ay ummadu pe datu babbay. ");
INSERT INTO isd_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ay datu pasúrut ne Dios, ay nasingan da nga napiya datu babbay. Ay díkod inatawán da datu piyán da kampela ngin nin. ");
INSERT INTO isd_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ay tútu nán ne APU, “Ya Ispiritù, ay akkan mabalin na magyán peyapeyang kadaya tolay. Ata tolay da ngala. Pumanda ya agbiyág da ki unag magatut se duwa púlu dagun nala,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ay kitun kam ma al-algaw, ay uwad pe yin datu nagdin-dinnámag ga rungat, ay se dadakkal tutu wala pe nga tolay, nga ittu datu nagtálaw nga pasúrut ne Dios. Ay inatawán da datu babbay kídi kalawagán, ay nagannánà da. Ay ittu datu nagdin-dinnámag pe nga mengal kitun. ");
INSERT INTO isd_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ay kane umadu win datu tolay kid kalawagán ni, ay adu tutu wala datu nadakè a kuk-kuwaan da pe. Ngámin na lam-lammat da, ay pabeg nadakè peyapeyang. Ay kane masingan ne APU Dios idi, ay ");
INSERT INTO isd_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","nakappoli kitu namarsuwa na ki tolay. Nagpannakit pànang tu uray na. ");
INSERT INTO isd_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ay tútu nán ne APU, “Rapúnan ku dedi ya tolay nga pinarsuwà. Ay oray pe daya ngámin na ulolag, se daya ngámin na kumar-káray ki lusà, ay se daya ngámin na an-anù. Nakappoli yà a namarsuwa kaggída,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ngamay pinatag ne APU tu Noa nga pútut tu Lamec. ");
INSERT INTO isd_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Tu Noa ay namáru nga tolay. Awan na nga kuk-kuwaan na nadakè. Sur-surútan na peyang daya piyán ne Dios. Tu idi ya gin-ginnápuwán na. Tallu datu pútut na nga pabeg lalláki: ");
INSERT INTO isd_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","tu Sem, se tu Ham, se tu Jafet. ");
INSERT INTO isd_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ay nagbalin ka nadakè tutu wala ki àráng ne Dios ya kuk-kuwaan datu tolay kídi kalawagán. Pabeg nadakè ya mà-màwa ki ngámin giyán kídi ya kalawagán. ");
INSERT INTO isd_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ummán kiyán tu nasingan ne Dios sa kinadakè datu tolay kitun. Dummakè da ngin, ta kuwaan da ngin datu akkan rumbang. ");
INSERT INTO isd_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ay díkod nán ne Dios kitu Noa, “Palánu ku win nga rapúnan daya tolay, áta pabeg nadakè tutu wala daya mà-màwa ngin kídi kalawagán gapu kaggída. Ay dadàlan ku ngámin pe yin daya atán kídi ya kalawagán,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","“Mangwa ka lugud ka abay pànang nga biray mu, ay ya kaligdaán na káyu ya usaram. Lunítam ka níkat ya panin unag na, se ya panin lasi na. Ay se mu wala nga kuw-kuwartuwan. ");
INSERT INTO isd_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ay ya kadakkal na ya kuwaam, ay magatut se tallu púlu se walu mitru ya pásit na, duwa púlu se tallu mitru ya súba na, ay se sangapúlu se limma mitru ya kalingúdu na. ");
INSERT INTO isd_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Kuwaam ka tallu sarundù ya datág na. Akkam litupan ya pane ngúdu wa dingding na. Mangibansi ka ka bittì a bátug lamdáwan na kiya gudduwa mitru panda kiya útun na. Ay ya gagyangán na, ay ippáy mu kiya bíkat na. ");
INSERT INTO isd_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Kuwaam yán, áta pagdallisan ku, ta senu matay ngámin daya sibbibiyág kídi kalawagán. ");
INSERT INTO isd_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ngamay nu ikaw, ay magkari yà kikaw. Ay magunag kayu ngámin kiya abay pànang nga biray nga kuwaan mu, dakayu nga magatáwa se daya pútut mu se daya attáwa da pe. ");
INSERT INTO isd_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ay mangalà ka ka agtangapagatawán kadaya ngámin baláki daya sibbibiyág, ay se mu la ibulun kikaw ta senu metangabiyág da kikaw. ");
INSERT INTO isd_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ki káda baláki daya an-anù, ay mangalà ka ka tangapagatawán. Ay ummán pe kadaya ulolag se kadaya kumar-káray ki lusà. Mangalà ka ka agtangapagatawán ki kada baláki da. ");
INSERT INTO isd_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ay mangitúgut ka pe kadaya ngámin baláki nga akakkanan se mu iarimán. Ittu dayán daya kanan nu se daya ulolag ga alà mu.” ");
INSERT INTO isd_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ay díkod kinuwa ne Noa ngámin datu nebílin ne Dios nga kuwaan na. ");
INSERT INTO isd_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ay se yala nán ne APU kitu Noa, “Magunag kayu win se daya akkobung mu kiya biray. Biyágan taka, áta sissa ka nga nasingan ku wa kurug ga namáru kadaya ngámin tolay kadedi nga al-algaw. ");
INSERT INTO isd_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Alà mu pe yin datu agtangapagatawán kadatu ngámin ulolag ga pálà ku kikaw. Ngamay kadaya mabalin pagbasu wa áyam, ay mangalà ka ka agpipittu wa pagattawán. ");
INSERT INTO isd_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ay ummán pe kadaya an-anù a mabalin pagbasu, mangalà ka pe ka agpipittu nga pagattawán, ta senu gumánab da manin kiya kalawagán. ");
INSERT INTO isd_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ata kalpasán naya pittu walgaw, ay pagudanan ku ka appát púlu wa algaw se appát púlu wa gabi. Rapúnan ku ngámin daya pinarsuwà a sibbibiyág kid kalawagán,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ay díkod kinuwa tu Noa datu ngámin na nebílin ne APU kaggína. ");
INSERT INTO isd_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Annam gatut tu dagun tu Noa kitu nilalbet natu dallis kídi kalawagán, ");
INSERT INTO isd_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","ay kitun pe tu nagunag de Noa ngin na magatáwa, se datu annánà da, se datu attáwa da kitu kinuwa na nga biray, ta senu melísi da kitu dallis. ");
INSERT INTO isd_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ay ngámin datu nagbal-baláki nga ulolag ga pálà ne Apu Dios kitu Noa, datu mabalin pagbasu se akkan, ay naglalbet da pe yin kitu biray. Ummán pe kadatu an-anù se datu ulolag ga kumar-káray ki útun lusà. ");
INSERT INTO isd_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Agtangapagatawán da nga inumbet, se da nagunag pe yin na kabulun tu Noa. Ta ittu tu bílin ne Dios kaggína. Ngamay datu mabalin na nga pagbasu wa ulolag se an-anù, ay agpipittu wa pagattawán da. ");
INSERT INTO isd_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ay kane malpás ya pittu wa algaw, ay ittu tu inanggayát na nga magdallis. ");
INSERT INTO isd_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ay kitu annam gatut ta dagun tu Noa ngin, kitu mekasangapúlu se pittu walgaw kitu mekàduwa búlán, ay ittu tu inanggayát tutu wala natu udán. Ay ginumbuwà pe ya danum ki taggad. ");
INSERT INTO isd_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Appát púlu ngalgaw se appát púlu gabi tu naggudán na. ");
INSERT INTO isd_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Kitu nanggayát natu udán, ay atán pe yin de Noa nga tangabalay kitu unag natu biray da. Atán ngámin nin pe datu magwawági. Tu Sem, se tu Ham, se tu Jafet se datu attáwa da. ");
INSERT INTO isd_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","15","Nagunag ngámin pe yin datu ngámin baláki ulolag nga alsádu, se ngámin baláki daya naámu, se ngámin baláki daya magkar-káray ya ulolag, se ngámin baláki daya an-anù, se daya nagpayà a ibulun na kaggína. Agtangapagatawán da nga inumbet. ");
INSERT INTO isd_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Nagunag da ngámin nin ta ittu tu nán ne Dios kitu Noa. Ay se negitap ne APU pe yin tu gagyangán tu biray. ");
INSERT INTO isd_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ummabay yala nga ummabay tu danum panda kitu appát púlu wa algaw. Ay tu abay ya biray, ay maglalattát pe yin. ");
INSERT INTO isd_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","19","Ay ummabay tutu wala pànang tu danum panda kitu nekalnap datu ngámin na alingúdu wa ban-bantay. Nalnap tutu wala ngámingámin ya kalawagán. Ngamay itu abay biray, ay maglalattát tala. ");
INSERT INTO isd_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Datu alingúdu wa bantay, ay nalnap da pikam ka moli pittu mitru ya kadallam da. ");
INSERT INTO isd_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ay díkod narápun ngámingámin datu sibbibiyág kídi kalawagán kitu danum. Natay ngámin datu tolay, se datu ngámin ulolag ga alsádu se naámu, se datu ngámin na an-anù, se datu mamalábal nga ul-ulullag. ");
INSERT INTO isd_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Oray nágan na kadatu sibbibiyág kid útun lusà, ay nalimat da ngámin. ");
INSERT INTO isd_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ummán kiyán tu nangrápun na kadatu ngámingámin na sibbibiyág kid kalawagán, tolay, ulolag, daya kumar-káray ya ul-ulullag, se da an-anù. Tittu de Noa se datu kabbulun na kitu abay ya biray na datu nabiyág. ");
INSERT INTO isd_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Limma búlán tu dallis. ");
INSERT INTO isd_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ngamay e Dios, ay siddadamdam kitu Noa se datu akkobung na, se datu ngámin na ulolag ga atán kitu abay nga biray. Ay díkod pinagbáli ne Apu Dios, tútu nanggayát pe yin na magassi tu danum. ");
INSERT INTO isd_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ata nakusap pin tu naggat tutu wala nga udán, ay se nakusap pe yin tu gumbuwà a danum ma maggayát ki taggad. ");
INSERT INTO isd_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ay umassiassi la nga umassiassi yin tu danum. Ay díkod kane mabalin tu magatut se limma púlu walgaw, bittì tu danum min. ");
INSERT INTO isd_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ay kitu mekasangapúlu se pittu kitu mekapittu wa búlán, ay nesar-át tu abay nga biray kitu bantay Ararat. ");
INSERT INTO isd_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Bumittì la nga bumittì tu danum. Ay kitu nunna nga algaw natu mekasangapúlu búlán nin, ay masissingan nin datu útun datu ban-bantay. ");
INSERT INTO isd_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ay kane malpás manin tu appát púlu walgaw, ay linùtán tu Noa tu lamdáwan natu abay nga biray. ");
INSERT INTO isd_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ay se yala nga nangipakáyab ka gayáng. Ngamay nagkay-káyab bala tu gayáng panda kitu nekassiyánan tu danum. ");
INSERT INTO isd_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ay se yala manin nangipakáyab ka kalapáti. Ta paninnán na nu nassiyán tutu wala tu danum min. ");
INSERT INTO isd_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ngamay tu kalapáti, ay áwan na pagdapúnán, ay tútu nagulli kammin kitu abay biray. Ata danum pikam ngámin tu kalawagán. Díkod pinagdápun ne Noa tu kalapáti kitu íma na se na alà kammin. ");
INSERT INTO isd_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ay díkod nagiddag pikam ka pittu walgaw, se nala nepakáyab manin tu kalapáti. ");
INSERT INTO isd_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ay kitu gídám natun na algaw, ay nagulli kammin tu kalapáti nga sittatangál kitu namáta nga adon káyu wa olíbo. Díkod nammuwán tu Noa ngin na nassiyánan tu danum min. ");
INSERT INTO isd_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Nagiddag manin ka pittu walgaw se yala nangipakáyab ka kalapáti manin, ngamay akkan nin na nagulli tu kalapáti. ");
INSERT INTO isd_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ay kitu nunna nga algaw kitu munna nga búlán natu mekannam gatut se isa nga dagun natu Noa ngin, ay ittu tu nekassiyánan tutu wala tu danum min. Linùtán tu Noa tu lamdáwan tu biray, ay nasingan na nga nasiyánan tu danum min. ");
INSERT INTO isd_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ay kitu mekàduwa púlu se pittu wa algaw natu mekàduwa búlán natun kam ma dagun, ay tútu nanggayát magmaga tu lusà in. ");
INSERT INTO isd_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ay tútu nán ne Dios sin kitu Noa, ");
INSERT INTO isd_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Lumawán kayu win se daya pútupútut mu se daya mannúgáng mu. ");
INSERT INTO isd_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ay ilawán mu pe yin ngámingámin daya ulolag, se daya ul-ulullag ga magkar-káray nga nekíwid mu se daya an-anù se daya ngámingámin na nekíwid mu, ta senu gumánab da manin kídi ya kalawagán, ay se umadu da tutu wala manin,” nán ne Dios. ");
INSERT INTO isd_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ay tútu lummawán kurug tu Noa, se tu atáwa na, se datu annánà na, se datu mannúgáng na. ");
INSERT INTO isd_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ay nelawán na pe yin datu ul-ulolag, se datu an-anù, se datu ulullag ga magkar-káray ya inalà na kitu biray. Nagpapáris da nga naglalawán kitu biray. ");
INSERT INTO isd_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ay se yala nangwa tu Noa ka annìdúgán na ka pagbasu, ay se yala nagbasu ke Apu. Nangalà kadatu para basu wa áyam se datu an-anù. Ay ittu datun datu nebasu na ke Apu. ");
INSERT INTO isd_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ay kane maláb ne APU tu nabangug ga aláb datu pinagbasu tu Noa, ay nán na kaggína kampela ngin nin, “Akkan ku win na dadàlan daya magbiyág kid útun lusà gapu kadaya nadakè a kuk-kuwaan daya tolay, ta gangay da kammala ngin nin oray kitu dam-dámu. Ay akkan ku pe dadàlan daya oray nágan na nga sibbibiyág kid kalawagán. Akkan ku kuwaan nin tu kinuwa ku. ");
INSERT INTO isd_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Kiya kaatán nedi ya kalawagán ay atán ya panagmul-múla, atán ya aggagáni, atán ya panaggannag na ay atán ya aggigáw na. Atán pe ya gabi se ya algaw. Akkan makusap dayán.” ");
INSERT INTO isd_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ay binindisiyonán ne Dios tu Noa se datu pútupútut na, ay se na nán kaggída, “Gumánab kayu, ta senu adu tutu wala manin daya tolay kid kalawagán. ");
INSERT INTO isd_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ay magansing ngámin daya ulolag kadakayu, se daya ngámin na an-anù. Oray pe ngámin daya magkar-káray ki útun lusà, se ngámin daya lamas. Iturayán nuda. ");
INSERT INTO isd_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Idde ku da ngámin kadakayu. Daya ulolag ga sibbibiyág kid kalawagán, ay iddè dayán ka kanan nu, nga ummán kadaya mul-múla nga pakkán ku kadakayu. ");
INSERT INTO isd_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ngamay akkan kayu mangán ka karni nga siddadága, áta ya dága, ay túyán ya gapu naya biyág na. ");
INSERT INTO isd_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ay túya nu dága ya nippà, ay dága pe kasukát na. Ay nu atán tolay ya pumatay ka páda na nga tolay, ay masápul naya bálat. Ay páda na pe nu ulolag ya pumatay ka tolay. Masápul atán bálat naya biyág tolay. ");
INSERT INTO isd_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Masápul la matay pe ya tolay nga pumatay ki kasittolay na. Ata kinuwà ya tolay ka ummán ki singan ku. ");
INSERT INTO isd_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ngamay dakayu, ay gumánab kayu se umadu kayu tutu wala kídi ya kalawagán.” ");
INSERT INTO isd_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ay se yala nán manin ne Dios kitu Noa se datu pútupútut na, ");
INSERT INTO isd_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Damdamman nu idi! Magkari yà kadakayu, ay se oray pe kadaya gakagaka nu se ");
INSERT INTO isd_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","kadaya ngámin na sibbibiyág ga nekíwid mu, daya ul-ulolag, se an-anù, se kadaya ngámingámin na sibbibiyág kid kalawagán. ");
INSERT INTO isd_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Tu idi ya karì kadakayu: Manggayát kídi, ay akkan ku win na dadàlan ka danum daya ngámin na sibbibiyág kid kalawagán. Awan pe yin ya dallis ka panda, nga mangrápun kadaya sibbibiyág kídi ya kalawagán,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ay se manin nán ne Dios, “Tu idi ya pakasinnán nu wa atán ya nekarì kadakayu se kadaya ngámin na gakagaka nu se daya ngámin na sibbiyág: ");
INSERT INTO isd_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Pamunglunan ku kiya angap nga ittu ya tagematun nga atán ya karì kadakayu ngámin na sibbibiyág kid kalawagán. ");
INSERT INTO isd_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ay nu paangpán ku, ay se yala nga mamunglun, ");
INSERT INTO isd_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ay madamdam ku ya nekarì kadakayu se kadaya ngámin na sibbibiyág nga akkan ku wa pagdallisan nin ka pangrápun ku kadaya sibbibiyág. ");
INSERT INTO isd_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ay nu mamunglun, ay masingan ku, ay díkod madamdam ku ya nekarì ka áwan panda kadaya ngámin na sibbibiyág kid kalawagán.” ");
INSERT INTO isd_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ay nán manin ne Dios kitu Noa, “Tu yán ya mangipassingan nga atán ya nekarì kadakayu ngámin na sibbibiyág kid kalawagán,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Ay datu annánà tu Noa nga uwad kitu abay pànang nga biray, ay tu Sem, tu Ham se tu Jafet. Tu Ham tu ama tu Canaan. ");
INSERT INTO isd_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ay datun na tallu wa annánà tu Noa, ya naggay-gayatán daya ngámin tolay kid kalawagán. ");
INSERT INTO isd_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Maragtálun tu Noa. Ay aggína tu nunna nga nagmúla ka úbás ");
INSERT INTO isd_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","nga ittu tu binási na. Isa ngalgaw, ay ninglaw tutu wala tu Noa. Ay nagwaren nala kitu báwi na nga sissusoba. ");
INSERT INTO isd_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ay tu Ham nga ama tu Canaan, ay nasingan na tu Noa nga ama na nga sissusoba. Ay kinagi na kadatu duwa nga wawwági na nga atán kitu lasi. ");
INSERT INTO isd_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ay díkod nangalà tu Sem se tu Jafet ka ulat. Se da nagpungtuwán na binìlád se da inultán tu ama da. Ay akkan da nasingan tu ama da nga sissusoba, ta naginúnud da nga nawe kitu giyán na. ");
INSERT INTO isd_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ay kane memawátan tu Noa kitu inglaw na, ay nammuwán na tu kinuwa tu Ham nga udiyán na an-anà na. ");
INSERT INTO isd_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Ay tútu nalùsaw nga nán na, “Mapak-pakallà ala daya gakagaka ne Canaan. Magbalin da ka kababaán na asassu daya gakagaka daya wawwági na,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ay nán na pe, “Ay daya gakagaka ne Sem, ay bindisiyonán ne APU nga Dios ku da. Ay daya gakagaka ne Canaan ay magasassu da ngala kaggída. ");
INSERT INTO isd_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ay paabayyan ne Dios ya lusà ne Jafet, ay se magbubúlun daya gakagaka na se daya gakagaka ne Sem. Ay daya gakagaka ne Canaan daya asassu da,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Nanggayát kitu nekasiyánan tu dallis, ay nagbiyág pikam tu Noa ka tallu gatut se limma púlu dagun. ");
INSERT INTO isd_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Siyám gatut se limma púlu dagun tu Noa se yala nga natay. ");
INSERT INTO isd_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Tu dedi daya pútupútut tu Sem, tu Ham se tu Jafet nga pútupútut tu Noa. Nagpútut da ka lalláki kalpasán tu dallis. ");
INSERT INTO isd_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Datu pútut tu Jafet nga lalláki ay datu: Gomer, Magog, Madai, Javan, Tubal, Mesec, se tu Tiras. ");
INSERT INTO isd_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Datu pútut tu Gomer nga lalláki ay datu: Askenaz, Rifat, se tu Togarma. ");
INSERT INTO isd_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ay datu pútut tu Javan nga lalláki ay datu: Elisa, Tarsis, Cyprus se tu Rodes. ");
INSERT INTO isd_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ay aggída tu naggay-gayatán datu tolay ya naggunà ki adanni ki bebay. Ay tu dayán datu gakagaka tu Jafet nga lalláki. Ay uwad íli kampela naya isaisa kaggída ngin. Ay sabáli kampela ngin nin pe ya aggúni naya agtangámalán kaggída. Ay sabáli kampela ya nasiyon naya isaisa kaggída ngin. ");
INSERT INTO isd_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ay datu pútut tu Ham nga lalláki, ay datu Cus, Egipto, Put se tu Canaan. ");
INSERT INTO isd_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ay datu pútut tu Cus nga lalláki, ay datu Seba, tu Havila, tu Sabta, tu Raama se tu Sabteca. Ay datu pútupútut tu Raama nga lalláki ay datu Seba se tu Dedan. ");
INSERT INTO isd_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Ay uwad pútut tu Cus nga nagngágan ka Nimrod. Ay aggína tu nun-unna nga katurayán kídi kalawagán. ");
INSERT INTO isd_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ay nalaing pe nga mangnígay ki agsisíngan ne Dios. Ay díkod aggína ya agpadígán da kadaya ummán kaggína. Ay nán da mepanggap kaggída, “Ay nalaing nga mangnígay ki agsisíngan ne Dios nga ummán kitu Nimrod,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Tu nunna nga nagturayán na nga il-íli ay ka Babel, ka Erek, se ka íli Akkad. Ngámin dedi nga il-ileli, ay atán da ka probinsiya Sinar. ");
INSERT INTO isd_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Ay nanggayát kadedi nga il-íli, ay nawe manin ka Asiria, ay se na pinagbalin ka il-ileli daya giy-giyán na Nineve, Rehobot-ir, Cala ");
INSERT INTO isd_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","se tu giyán Resen, nga atán kitu nagbàtán Nineve se Cala. Nagbalin ka abay pànang nga íli tu Resen. ");
INSERT INTO isd_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Ay tu Egipto, ay nagpútut pe. Datu pútupútut na ay datu Lydia, tu Anam, tu Lehab, tu Naftu, ");
INSERT INTO isd_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","tu Patros, tu Caslu, se tu Caftor (aggína tu naggagayatán datu iFilistia). ");
INSERT INTO isd_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Ay tu Canaan, ay uwad da pútupútut na pe. Tu manákam ma pútut na ay tu Sidon, ay se la tu Het, ");
INSERT INTO isd_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","tu Jebuseo, se tu Amorreo, tu Girgaseo, ");
INSERT INTO isd_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","tu Heveo, tu Arkeo, tu Sineo, ");
INSERT INTO isd_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","tu Arvadeo, tu Zemareo, se tu Hemateo. Ay se la nga nasip-siparà datu pútupútut Cananeo. ");
INSERT INTO isd_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ay ya íli datu Cananeo ay manggayát ka Sidon nga adanni ka Gerar, panda ka íli Gaza nga adanni ka íli Sodom se ka il-ileli Gomorra, se Adma, se Zeboiim panda ka íli Lasa. ");
INSERT INTO isd_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ay tu dayán daya gakagaka tu Ham nga lalláki nga ittu datu naggay-gayatán datu nagbal-baláki nga tangámalán na nagbal-baláki aggúni da se nagsab-sabáli nga íli se nasiyon. ");
INSERT INTO isd_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Ay tu Sem ay uwad da pe pútupútut na. Aggína tu manákam ma wagi tu Jafet, ay se aggína ya apuapu datu gakagaka tu Eber. ");
INSERT INTO isd_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Datu pútupútut tu Sem ma lalláki ay tu Elam, tu Assur, tu Arpaksad, tu Lud, se tu Aram. ");
INSERT INTO isd_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ay datu pútupútut tu Aram nga lalláki ay tu Uz, tu Hul, tu Geter, se tu Mesec. ");
INSERT INTO isd_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Ay tu Arpaksad tu ama tu Sela. Ay tu Sela tu ama tu Eber. ");
INSERT INTO isd_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ay tu Eber, ay uwad da duwa nga pútut na nga lalláki. Tu Peleg ya isa. (Ya sarut naya ngágan na ay mauwár ya kalawagán). Ya ngágan tu wagi na, ay tu Joktan. ");
INSERT INTO isd_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ay tu Joktan tu ama datu Almodad, tu Selef, tu Hazarmavet, tu Jera, ");
INSERT INTO isd_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","tu Hadoram, tu Uzal, tu Dikla, ");
INSERT INTO isd_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","tu Obal, tu Abimael, tu Seba, ");
INSERT INTO isd_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","tu Ofir, tu Havila, se tu Jobab. Tu dayán datu ngámin annánà tu Joktan nga lalláki. ");
INSERT INTO isd_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ay ya sákup naya nag-agyanán da nga íli ay panda ka Mesa dumatang ka padne Sefar kitu ban-bantay ka padne lattakán. ");
INSERT INTO isd_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Tu dayán datu pútupútut tu Sem nga lalláki nga ittu datu naggay-gayatán datu magtatangámalán na tolay se nagbal-baláki nga aggúni nga nag-agyán ka nagbal-baláki nga il-ileli se nas-nasiyon. ");
INSERT INTO isd_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ay tu dayán datu naggay-gayatán datu ngámingámin na pútupútut datu annánà tu Noa se datu nas-nasiyon da nga ittu datu naggay-gayatán datu nagbal-baláki nga nas-nasiyon kídi kalawagán kalpasán natu dallis. ");
INSERT INTO isd_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Kitun, ay sissa tu aggúni datu ngámin tolay kid kalawagán ni, se sissa ya kabalìtán na. ");
INSERT INTO isd_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ay kane mawe da ka padne lattakán, ay nasingan da tu tanáp ka Sinar, ay naggunà da kitúni yin. ");
INSERT INTO isd_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Ay se da nán kitu isaisa kaggída, “Mangwa tada kídi ka íli tada. Ay mangwa tada pe ka alingúdu pànang nga torre ya magiddadatang ka lángit, ta senu medin-dinnámag tada kadaya tolay. Akkan tada pe masip-siparà kiya kalawagán,” nán da. Ay tútu nán da kitu isaisa kaggída, “Ara nu, mangwa tada ka ladrilyu, ay kuwaan tada ka nakulnit tutu wala. Ay díkod nangwa da kurug ka ladrilyu nga ittu tu pinangdarupírip da. Ay ispaltu tu bátug pinagsumintu da.” ");
INSERT INTO isd_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ay kane madama da ngin na mangwa kitu íli se tu torre da, ay inumbet te APU, ta sinnan na tu kuk-kuwaan da. ");
INSERT INTO isd_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ay kane masingan ne APU tu kuk-kuwaan da, ay nán na, “Kurug ga sissa daya tolay. Tu yán ya anggayát da nga mangwa kiya piyán da kampela ngin nin. Ay màwa da tutu wala ngámin na asikkuwaan da, áta sissa mà ya aggúni da, ay magkiinnawátan da ngámin,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","“Ay mawe tada pagbal-balakiyan ya aggúni da, ta senu akkan da magkiinnawátan,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ay díkod gapu kiya akkan da agkikinnawátan, ay nasip-siparà da pe yin ki ngámin giyán kídi kalawagán. Ay tútu akkan da nabalin tu kuk-kuwaan da nga íli. ");
INSERT INTO isd_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ay tútu nepangágan da ka Babel tun na giyán, áta pinagbal-baláki ne Dios tu aggúni datu tolay kídi kalawagán. Ay tu pe tun tu namagsip-siparà ne APU kaggída ki ngámin giyán kídi kalawagán. ");
INSERT INTO isd_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ay tu dedi datu pútupútut tu Sem. Kitu magatut dagun tu Sem, ay neanà tu Arpaksad nga pútut na nga laláki. Kustu duwa dagun kalpasán tu dallis. ");
INSERT INTO isd_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ay atán pe datu duddúma nga pútupútut na. Ay kane meanà tu Arpaksad, ay nagbiyág pikam tu Sem ka limma gatut dagun. ");
INSERT INTO isd_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ay kane tallu púlu se limma dagun tu Arpaksad, ay neanà tu Sela nga pútut na. ");
INSERT INTO isd_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Ay adu pikam pe datu pútupútut na. Nanggayát kitu nekeanà tu Sela, ay nagbiyág pikam tu Arpaksad ka appát gatut se tallu dagun. ");
INSERT INTO isd_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Ay kane tallu púlu dagun tu Sela, ay neanà tu Eber nga pútut na. ");
INSERT INTO isd_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Adu pikam datu pútupútut na. Nanggayát kitu nekeanà tu Eber, ay nagbiyág pikam tu Sela ka appát gatut se tallu dagun. ");
INSERT INTO isd_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ay kane tallu púlu se appát dagun tu Eber, ay neanà tu Peleg nga pútut na. ");
INSERT INTO isd_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ay atán pikam pe datu duddúma pútupútut na. Nanggayát kitu nekeanà tu Peleg, ay nagbiyág pikam tu Eber ka appát gatut se tallu púlu dagun. ");
INSERT INTO isd_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Ay kane tallu púlu dagun tu Peleg gin, neanà tu Reu nga pútut na. ");
INSERT INTO isd_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Ay uwad da pikam sabáli nga pútupútut na. Nanggayát kitu nekeanà tu Reu, ay nagbiyág pikam tu Peleg ka duwa gatut se siyám dagun. ");
INSERT INTO isd_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ay kane tallu púlu se duwa dagun tu Reu, ay neanà tu Serug ga pútut na. ");
INSERT INTO isd_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Ay uwad da pikam pe sabáli nga pútupútut na. Nanggayát kitu nekeanà tu Serug, ay nagbiyág pikam tu Reu ka duwa gatut se pittu dagun. ");
INSERT INTO isd_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Ay kane tallu púlu dagun tu Serug gin, ay neanà tu Nahor nga pútut na. ");
INSERT INTO isd_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Ay uwad da pikam sabáli nga pútupútut na. Nanggayát kitu nekeanà tu Nahor, ay nagbiyág pikam tu Serug ka duwa gatut dagun. ");
INSERT INTO isd_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Ay kane duwa púlu se siyám dagun tu Nahor rin, ay neanà tu Tera nga pútut na. ");
INSERT INTO isd_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Ay uwad da pikam pe sabáli pútupútut na. Nanggayát kitu nekeanà tu Tera, ay nagbiyág pikam tu Nahor ka magatut se sangapúlu se siyám dagun. ");
INSERT INTO isd_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Ay kane pittu púlu dagun tu Tera ngin, ay nanggayát nagpútut. Nakapútut ka tallu nga lalláki. Tu Abram, tu Nahor, se tu Haran. ");
INSERT INTO isd_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tu dedi lugud datu pútupútut tu Tera: Tu Abram, tu Nahor, se tu Haran. Tu Haran tu ama tu Lot. ");
INSERT INTO isd_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","May nunna natay tu Haran may tu ama na nga Tera. Natay ka íli Ur ka Caldea nga neanaán na pe. ");
INSERT INTO isd_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ay tu Abram se tu Nahor, ay nangatáwa da pe yin. Tu ngágan natu atáwa natu Abram ay Sarai. Ay Milca tu ngágan tu atáwa natu Nahor. Pútut kam pe tu Haran tu Milca se tu Isca. ");
INSERT INTO isd_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ay tu Sarai nga atáwa tu Abram, ay akkan makapagan-anà. Díkod áwan na an-anà. ");
INSERT INTO isd_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Ay inalà na tu Tera de Abram nga pútut na, se tu Lot nga apúku na ke Haran, se tu Sarai nga manúgáng na nga atáwa tu Abram, ay se da nagtálaw ngámin ka Ur ka Caldea, ta mawe da kuma ka Canaan. Ngamay kane dumatang da ka íli Haran, ay nagyán da kitúni. ");
INSERT INTO isd_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ay natay tu Tera kannán Haran kane duwa gatut se limma dagun na ngin. ");
INSERT INTO isd_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ay nán ne APU kitu Abram, “Panáwam ya íli mu se daya pan-pane mu, ay se ya balay tu ama mu. Ta mawe ka kiya giyán na ipassingan ku kikaw. ");
INSERT INTO isd_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ay se ku wala nga pagbalinan ka adu tutu wala daya gakagaka mu, ay magbalin da ka abay nga nasiyon. Iyà ya sumeng kikaw, ay se ku la nga pagbalinan ka nadáyaw pànang ya ngágan mu. Ay senu ikaw ya sumeng kadaya duddúma pe. ");
INSERT INTO isd_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ay namáru wà kadaya namáru kikaw. May gedán ku daya magged kikaw. Gapu kikaw, ay pàgan ku daya ngámin tolay kid kalawagán.” ");
INSERT INTO isd_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ay tútu nawe tu Abram nga ummán kitu kinagi ne APU kaggína. Inalà na pe tu Lot. Pittu púlu se limma dagun na ngin kane magtálaw ka Haran. ");
INSERT INTO isd_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Nawe da se tu Sarai nga atáwa na, se tu Lot nga amanakan na. Ay inalà da ngámin pe datu kuw-kuwa da nga inùnúdán da. Ay inalà da pe datu asassu da nga nálà da Haran. Ay se da nagrubbuwát nga mawe ka Canaan. Ay kane makadatang da kattoni Canaan, ");
INSERT INTO isd_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ay liniwánan da. Nangaw-át da pikam ka panda Sekem. Atán pikam datu iCanaan kitúni Canaan kitun. Nawe da kitu giyán tu abay káyu ka More. Ay nagyán da kitúni ka nakaru. ");
INSERT INTO isd_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ay se yala nagpassingan ne APU kitu Abram nga nán na, “Iddè idi nga lusà kadaya gakagaka mu,” nán na. Ay tútu nangwa tu Abram ka annìdúgán na ka pagbasu na ke APU nga nagpassingan kaggína. ");
INSERT INTO isd_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Akkan nabayág, ay nagtálaw manin de Abram. Nameyag da manin kadatu ban-bantay ya atán kitu padne lattakán ka Betel. Ay nangwa ka báwi na kitúni kitu nagbàtán Betel se Ai. Kitu padne sirbútán natu báwi na, ay ittu tu giyán na Betel, ay padne lattakán kitu báwi na tu íli Ai. Ay nangwa kitúni ka agbasuwán na pe ke Apu. Ay ittu tuni pe ya agkararágan na ke Apu Dios. ");
INSERT INTO isd_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ay nawe manin tu Abram. Namarè nga nameyag ka Negeb. ");
INSERT INTO isd_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Kitun kam pe nga tiyampu, ay magulát da kattoni Canaan. Ay díkod nanagut tu Abram se nawe ka Egipto, ta mag-agyán pikam kitúni ta napgus tu ulát. ");
INSERT INTO isd_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ay kane tagay da lumnà in kitu íli Egipto, ay nán tu Abram kitu Sarai nga atáwa na, “Ammù nga napiya ka. ");
INSERT INTO isd_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Ay nu masingan daka daya iEgipto ay nán da nga, ‘Tu idi 'kaw ya atáwa na,’ nán da, ay se dà patayan. Ngamay akkan daka patayan. ");
INSERT INTO isd_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ay túya nán mu nga wagi taka, ta senu namáru da kiyà, ay akkan dà patayan gapu kikaw,” nán tu Abram. ");
INSERT INTO isd_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ay kane lumnà tu Abram kitu íli Egipto, ay nasingan datu iEgipto nga napiya tutu wala kurug tu atáwa na. ");
INSERT INTO isd_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ay kane masingan datu upisiyál natu ári, ay kinagi da kaggína nu wà ummán tu kinapiya na. Ay tútu pinálà natu ári tu Sarai, se da nippan kitu palásiyu natu ári. ");
INSERT INTO isd_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ay gapu kaggína, ay namáru tu ári kitu Abram. Niddán na ka karneru na, báka na, kabalyu na, kámel na se puunán se toru nga asnu, ay se niddán na pe ka asassu na nga lalláki se babbay. ");
INSERT INTO isd_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ngamay pinagtakit tutu wala ne APU tu ári, se datu akkobung na gapu kitu Sarai. ");
INSERT INTO isd_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Ay tútu pinàrawán tu ári tu Abram, ay se na nán kaggína, “Taanna, tura ummán kiyán ya kinuwám kiya ta? Tura mu netuláyaw kiyà nga magatáwa kayu! ");
INSERT INTO isd_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Tura mu nán nga magwagi kayu? Ay túya inalà ku nga atawán kuma! Ye idi yin ya atáwam. Alà mun ta magtálaw kayun,” nán tu ári. ");
INSERT INTO isd_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ay se na la binílin datu tolay na ka panggap kitu Abram. Ay díkod pinarbuwát dada nga magatáwa. Ay inalà tu Abram ngámin pe datu kuw-kuwa na. ");
INSERT INTO isd_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ay díkod nagtálaw de Abram nga magatáwa ka Egipto. Nanùdu da kammin ka Negeb se tu Lot. Inalà na ngámin pe datu kuw-kuwa na. ");
INSERT INTO isd_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ay nabànáng tutu wala tu Abram. Adu datu báka na, se adu pe tu pirà na se tu balitù na. ");
INSERT INTO isd_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ay nagtálaw da manin ka Negeb se da namarè nga nawe ka Betel, kitu giyán na nagbàtán Betel se Ai, tu nangwaán na kam ka baw-bawi na kitun. ");
INSERT INTO isd_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Ay kitúni kam pe tu nunna nga nangwaán na ka agbasuwán na nga nagday-dayáwan na ke Apu. Ay dinay-dáyaw na manin ne Apu kitúni. ");
INSERT INTO isd_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Tu Lot ta amanakan tu Abram nga nekíwid na, ay adu pe yin datu áyam na nga báka se karneru. Ay atán kampela pe yin datu pamilya na se datu asassu na. ");
INSERT INTO isd_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ay gapu ta umadu tutu wala datu áyam da nga duwa, ay akkan maanáy yin tu lusà a pagpastuwán da. Ay díkod akkan da pe makapagbulun nin. ");
INSERT INTO isd_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Magsasáwad din datu para pastor tu Abram se datu para pastor tu Lot. Kitun na tiyampu, ay mag-agyán kitúni pe datu iCanaan se datu iPerezo. ");
INSERT INTO isd_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ay díkod, nán tu Abram kitu Lot, “Masápul la makusap ya akas-asasáwad daya para pastor mu se dayán kiyà. Lùsawan ku nga magsáwad ta pe, áta magama ta mà,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","“Sinnam kod ya kalawág naya lusà. Masápul la magsibna ta ngin. Nu mawe ka kiya pane diwanán, ay mawe yà kiya pane kasígid. Ay nu mawe ka kiya pane kasígid, ay mawe yà kiya pane diwanán,” nán natu Abram. ");
INSERT INTO isd_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ay díkod neapaapág tu Lot tu mata na, ay nasingan natu tanáp kitu Jordan nga mameyag ka Zoar nga nadam-ag se madanumán pànang, nga ummán ka kamulán ne APU. Ummán pe kitu lusà ka Egipto, kitu akkan pikam dinadál ne APU ya Sodom se Gomorra. ");
INSERT INTO isd_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ay díkod ittu tu piníli tu Lot, tu tanáp kitu Jordan, ay se la nameyag ka padne lattakán. Díkod ittu tun nagsibna da. ");
INSERT INTO isd_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Tu Abram, ay nagyán ka Canaan may tu Lot, ay nawe nagyán kitu íli kitu tanáp. Nekalit na pe tu báwi na kitu adanni ka Sodom. ");
INSERT INTO isd_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Datu tolay ka Sodom, ay napalotán tu agbas-básul da ke APU. ");
INSERT INTO isd_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ay kane sumibna tu Lot tin, ay nán ne Apu Dios kitu Abram, “Iapaapág mu ya matám kiya magpingipíngit, Abram, ");
INSERT INTO isd_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","áta ngámin yán na lusà a masingam, ay ipakin-kuwà kikaw ka áwan panda se kadaya ngámin na gakagaka mu. ");
INSERT INTO isd_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ay paaduwan ku tutu wala daya gakagaka mu. Ay ummán kiya kaadu naya tápù ya kaadu da, áta áwan makabíláng kaggída,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","“Ara, dàdáan mu win ya lusà, ta idde ku mà in kikaw,” nán ne Apu Dios. ");
INSERT INTO isd_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ay nealit manin tu Abram tu báwi na, ay se nagyán kitu kakayuwán ka Mamre nga adanni ka Hebron. Ay se yala nangwa manin ka annìdúgán na ka pagbasu na ke APU. ");
INSERT INTO isd_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Kitu kinaári tu Amrafel ka Sinar, tu ári Arioc tu ári ka Elasar. Tu ári ka Elam, ay tu ári Kedorlaomer. Ay tu ári Tidal, tu ári ka Goiim. ");
INSERT INTO isd_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Ay ngámin dayán na à-ári, ay naggagdù da nga nakigubát kadatu naggagdù pe nga à-ári nga ittu datu: ári Bera nga ári ka Sodom, tu ári Birsa nga ári ka Gomorra, tu ári Sinab nga ári ka Adma, tu ári Semeber nga ári ka Zeboiim, ay se itu ári ka Bela (Zoar kam yán). ");
INSERT INTO isd_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Dedi nga à-ári, ay pinaggaámung da ngámin datu suldádu da kitu natanáp pa íli nga Siddim (kídi yin ay ittu ya bebay nga napet tu danum na). ");
INSERT INTO isd_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Netur-turayán tu ári Kedorlaomer da kitun ki únus sangapúlu se duwa dagun. Ngamay kitu mekasangapúlu se tallu dagun, ay lumában da ngin kaggína. ");
INSERT INTO isd_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","6","Ay kitu mekasangapúlu se appát dagun, ay ginubát natu ári Kedorlaomer se datu kabbulun na nga à-ári datu mag-Refaim ka Asterot Karnaim, se datu mag-Zuzim ka Ham se datu mag-Emim ka Save-kiriataim, se datu Horeo ka bantay Seir panda ka El Paran nga atán kitu nagpandanán tu ir-ir-er. Ay inábà natu ári Kedorlaomer da ngámin. ");
INSERT INTO isd_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ay se da nagpatoli ka Enmispat (Kades kam yán). Ay ginubát da pe datu gakagaka natu Amalek se datu Amorreo nga mag-agyán ka Hazazon-tamar. Ay inábà dada pe. ");
INSERT INTO isd_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ay kitúni, ay summabat ta makigubát kaggída datu tangabubúlun na à-ári ka Sodom, ka Gomorra, ka Adma, ka Zeboiim, se ka Bela (Zoar kam yán). Naggugubát da kitu tanáp natu íli Siddim se ");
INSERT INTO isd_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","tu ári Kedorlaomer nga ári ka Elam se ári Tidal nga ári ka Goiim, se ári Amrafel nga ári ka Sinar, se ári Arioc nga ári ka Elasar. Dedi nga appát datu nakigubát kadatu limma. ");
INSERT INTO isd_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ay kitu tanáp natu íli Siddim, ay uwad da abbut nga napnu ka naringkat ta ummán ki ispaltu. Ay kane magtatálaw datu à-ári ka Sodom se Gomorra se datu suldádu da, ay nepisuán datu duddúma kaggída kadatun na abbut. Ay datu duddúma, ay nagtatálaw da kadatu ban-bantay. ");
INSERT INTO isd_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ay díkod datu kalínga da, ay inalàán da datu kuw-kuwa datu iSodom se iGomorra se datu akakkanan da. Ay se da nagtatálaw. ");
INSERT INTO isd_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ay inalà da pe tu Lot nga amanakan tu Abram kitu wagi na nga laláki. Ata mag-agyán pe ka Sodom. Inalàán da pe datu kuw-kuwa na. Ay seda nagtálaw. ");
INSERT INTO isd_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ay uwad isa nga nakatálaw. Ay aggína tu nawe nangikagi kitu Abram nga Hebreo nga magag-agyán kitu adanni kitu kakayuwán tu Mamre nga Amorreo nga wagi de Escol se Aner. Kagdù tu Abram dedi. ");
INSERT INTO isd_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ay kane magìna tu Abram nga tiniliw da tu amanakan na, ay nawe nada impal panda ka íli Dan. Kabulun na datu asassu na nga neanà in ka balay na, nga tinùgúdán na nga makigubát. Tallu gatut se sangapúlu se walu da ngámin. ");
INSERT INTO isd_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Pinagkaduwa na datu tolay na se datu asassu na, ay se da ngináyaw datu kalínga da kane gabi. Nagtuway da nga nangpal kadatu kalínga da. Pinalsu dada, ay tútu nagtatálaw da. Nasìmát dada ka Hoba pane dáya ka Damasco. Ay inábà dada kattoni. ");
INSERT INTO isd_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ay díkod nilbet tu Abram kammin datu kuw-kuwa datu iSodom, ay se nálà na kammin pe tu amanakan na nga Lot se datu kuw-kuwa na. Ay nálà na kammin pe datu ngámin tolay ya natiliw, meráman datu babbay. ");
INSERT INTO isd_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ay kane maábà tu Abram tu ári Kedorlaomer se datu duddúma nga ári nga kabulun na, ay sinabat natu baru wa ári ka Sodom kitu tanáp tu Save (ya sarut na, ay tanáp tu ári). ");
INSERT INTO isd_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ay tu Melkisedec nga ári ka Salem, ay nangilbet ka sinápay se bási (nga nàwa ki digu úbás). Aggína pe tu pádi ne Dios sa kangatuwán. ");
INSERT INTO isd_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ay se na nekarárag tu Abram nga nán na, “Abram, kalakkán naka nge Dios nga kangatuwán, nga ittu ya namarsuwa ki lángit se kalawagán; ");
INSERT INTO isd_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ay maday-dáyaw we Dios nga Kangatuwán nga ittu ya sinummeng kikaw wa nangábà kadatu kalíngam,” nán na. Ay nidde tu Abram ke Melkisedec tu pagkapúlu datu ngámin na nálà na nga kuw-kuwa. ");
INSERT INTO isd_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ay tu ári ka Sodom, ay nán na kitu Abram, “Iddem kiyà kammin daya tolay ku, ngamay alà mu ngámin daya kuw-kuwa,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ngamay nán tu Abram kaggína, “Sinipataán ku ke APU Dios nga Kangatuwán nga namarsuwa ki lángit se kalawagán, ");
INSERT INTO isd_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","nga akkan nà mangalà oray binola ngala onu isa nga sandal lala, ay oray nágan na nga kuw-kuwám, ta senu akkan mu makuna nu kuwa nga, ‘Bumànáng a nge Abram ta gapu kiyà,’ nán mu. ");
INSERT INTO isd_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Awan ku nga alà. Tittu daya kinnán daya babbágù i, se ya kípát daya tolay nga kummíwid kiyà, de Aner, Escol se Mamre. Iddem ya kípát da,” nán tu Abram. ");
INSERT INTO isd_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ay kalpasán dayán na mà-màwa, ay nagpatagenap nge APU kitu Abram, ay nán na kaggína, “Akkan ka magansing Abram, ta igdù taka peyang. Ay se abay pànang pe ya pagsubálit ku kikaw,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Ay nán tu Abram, “Apu Dios, nágan na pe ya sur-surbi daya iddanám kiyà, ay áwan ku mà a pútut oray isa. Ay ya ammù a mangtáwid kadaya kuw-kuwa ku, ay e Eleazar ra iDamasco nga asassu ku, áta akkan nà niddán ka an-anà,” nán tu Abram. ");
INSERT INTO isd_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","May nán ne APU kaggína, “Akkan! Ata atán ya pútut mu kampela ngin nin na ittu ya mangtáwid kadaya ngámin na kuw-kuwám,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ay tútu nippan ne Apu Dios nge Abram ka lasi, ay se na nán, “Maglángad ka Abram ta bilángan mu daya bittuwan nu mabíláng muda. Ummán kiya kaadu dayán ya kaadu daya gakagaka mu,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ay kinurug tu Abram me APU. Ay nebíláng ne APU nga namáru tu Abram gapu kitu inangngurug na. ");
INSERT INTO isd_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ay se nán manin kitu Abram, “Iyà ya APU nga namatálaw kikaw ka Ur ka Caldea, ta ipakin-kuwà kikaw idi nga lusà,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ngamay nán tu Abram, “APU Dios, paanna ya akammù nga kurug mepakin-kuwa kiyà idi ya lusà?” nán na. ");
INSERT INTO isd_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ay tútu nán ne APU Dios kaggína, “Mangilbet ka ka isa nga bumal-balásang nga báka nga tallu dagun na ngin, isa nga bumal-balásang nga kalding se isa toru nga karneru nga agtàlu dagun da, se isa nga ladágan se isa nga ubbun kalapáti,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Díkod nilbet tu Abram ngámin dayán, ay se nada sinìlatán na pinagkaduwa ngámin, se nada binìlád da pinagtuway. Ngamay datu an-anù, ay akkan na sinìlát da. ");
INSERT INTO isd_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ay nu atán datu karabúngan na melug mangán kadatu nasìlát ta animál, ay sabúgan tu Abram da. ");
INSERT INTO isd_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ay kane tagay masirbut tu mata ngin, ay nìlà tutu wala tu Abram. Ay se la nga naggìbat tutu wala nga nakapap-panansing tu giyán na. ");
INSERT INTO isd_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ay se la nga nán ne APU kaggína, “Ammuwán mu tutu wala idi, nga daya gakagaka mu, ay magyán da ka íli nga akkan da nga kurug íli. Ngamay agtangeli da ngala kiyán na íli. Magasassu da se mapal-pallà da kiyán na íli ki unag appát gatut dagun. ");
INSERT INTO isd_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ngamay panísan ku daya tolay nga mangasassu kaggída. Ay se la nga magtálaw daya gakagaka mu nga adu daya kuw-kuwa da ngin. ");
INSERT INTO isd_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ay nu ikaw, ay akkan màwa dayán kikaw. Maglàlakay ka pikam pànang nga simpipiya ya uray, se kala matay. ");
INSERT INTO isd_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Ay daya gakagaka mu, ay magulli da kanedi, ngamay manggayát kadaya mekappát pagwawagíyán nala. Ata ya kinadakè daya Amorreo, nga ittu daya mag-agyán pikam kídi, ay akkan pikam pumanda.” ");
INSERT INTO isd_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ay kane masirbut tu mata ngin, se naggìbat tutu wala pe yin, ay pagkìlát na ngala ya ummán ka dubúan nga apuy. Ay se yala nga uwad apuy nga ummán ki maggatagatang nga páur ra nanalen kitu túlad datu sinì-sìlát na nga animál. ");
INSERT INTO isd_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ay kitun kam nga algaw, ay nagkari ye APU kitu Abram nga nán na, “Iddè idi nga lusà kadaya gakagaka mu. Maggayát kitu wángag ka Egipto panda kiya wángag Eufrates nga ittu ya kabayyán na wángag. ");
INSERT INTO isd_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Daya lusà daya Kineo se daya Kenezeo, daya Kadmoneo, ");
INSERT INTO isd_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","daya Heteo, daya Perezeo, daya Refaim, ");
INSERT INTO isd_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","daya Amorreo, daya Cananeo, daya Gergeseo, se daya Jebuseo, ay iddè kadaya gakagaka mu,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Ay tu Sarai, ay akkan na middán ka an-anà tu Abram nga atáwa na. Ay uwad asassu na nga babay nga iEgipto nga nagngágan ka Hagar. ");
INSERT INTO isd_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Isa ngalgaw, ay nán tu Sarai kitu Abram, “Gapu ta akkan nà a pagan-anaan ne APU, ay paanna nu mawem allayan ne Hagar ra asassu ku ta. Get aggína ya pakalakkán ku ka an-anà ku,” nán na. Ay díkod kinurug tu Abram tu kinagi tu Sarai. ");
INSERT INTO isd_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ay díkod kane mekasangapúlu dagun tu Abram min ka Canaan, nilbet tu Sarai kaggína tu Hagar nga iEgipto nga asassu na ta allayan na. ");
INSERT INTO isd_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ay inlay kurug tu Abram tu Hagar, ay tútu nabùsit. Ay kane nammuwán na nga nabùsit, ay irupat na tu Sarai nga apu na gapu ta akkan magan-anà. ");
INSERT INTO isd_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ay gapu ta irupat tu Hagar tu Sarai kane mabùsit, ay nán natu Sarai kitu Abram, “Básul mu idi nga angngirupat na kiyà. Tura nà mán kammin na irupat te Hagar kane mabùsit, ay iyà ya nangipalúbus sa allayam. E Apu Dios sala ya makammu kikaw,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ngamay nán tu Abram kitu Sarai, “Ikaw mà ya apu na. Ay kuwaam mu wala kaggína ya piyám kampela ngin nin,” nán na. Ay díkod nagraw-rawtán natu Sarai tu Hagar. Ay tútu nagtálaw. ");
INSERT INTO isd_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ay nasmà naya anghel ne APU tu Hagar kitu adanni kitu gabbuwà kitu ir-ir-er, tu gabbuwà a atán kitu mameyag ka Sur. ");
INSERT INTO isd_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ay nán tu anghel kaggína, “Wà naya kapannám, Hagar nga asassu ne Sarai, ay se kawà naya naggayatám?” nán na. Ay “Magtálaw wà kitu apu ku wa Sarai,” nán tu Hagar. ");
INSERT INTO isd_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ngamay nán natu anghel ne APU kaggína, “Magulli ka kitu apu mu, ay peturayán ka ngala pe kaggína,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ay nán pikam tu anghel, “Paaduwan ne APU tutu wala pe daya gakagaka mu. Awan makabíláng kaggída. ");
INSERT INTO isd_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Nabùsit ka. Ay laláki ya an-anà mu. Ya ipangágan mu kaggína, ay Ismael. (Ya sarut nayán ay Manggìna nge Dios). Ata nagìna ne APU Dios ngámin daya pannakit mu wa nàlamám. ");
INSERT INTO isd_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ay ya an-anà mu, ay nasúkir ra ummán kiya alsádu wa asnu. Kagúra na daya ngámin tolay. Ay túya kagúra da ngámin pe. Adayyuwán na daya ngámin pan-pane na ta kagúra nada,” nán natu anghel. ");
INSERT INTO isd_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Nanggayát kitun, ay nengágan tu Hagar nge APU ka, “El-roi.” Ay ya sarut nayán ay “Ikaw ya Dios sa naningan kiyà” áta nán na nga, “Nasingan ku we Dios, may sibbibiyág gà pikam,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Díkod nepangágan da tu bubun ka “Beer-lahai-roi.” Ya sarut nayán ay “Ya bubun naya Sibbiyág ga Naningan Kiyà.” Tun na bubun, ay atán kitu nagbàtán naya Kades se Bered. ");
INSERT INTO isd_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ay díkod nagan-anà tu Hagar ka laláki. Tu idi yin tu an-anà da se tu Abram. Ay nengágan tu Abram ka Ismael. ");
INSERT INTO isd_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Kane ianà tu Hagar tu Ismael, ay walu púlu se annam dagun tu Abram min. ");
INSERT INTO isd_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ay kane siyám púlu se siyám dagun tu Abram min, ay nagpassingan manin ne APU kaggína. Ay nán na kaggína, “Iyà e Dios sa Mannakabalin. Ikurug nà, ay se akkan ka nga mangwa ka oray nágan na nga nadakè. ");
INSERT INTO isd_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ay ikarì manin kikaw nga paaduwan ku tutu wala daya gakagaka mu,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ay tútu nagukkab tu Abram. Ay netul-túluy ne Apu Dios ya nakiamomán kaggína. ");
INSERT INTO isd_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Ay nán na, “Iyà ay atán ikarì kikaw. Ay kurug idi ya nán ku wa pagbalinan ku daya gakagaka mu ka adu tutu wala nga umíli. ");
INSERT INTO isd_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ay ya isa pe, ya ngágan mu, ay akkan nin na Abram nu di Abraham min. (Ya sarut nayán ay ‘Ama daya adu wa nas-nasiyon’). Ittu yán nin ya ngágan mu, áta pagbalinan taka lugud ka apuapu daya adu tutu wala nga nas-nasiyon. ");
INSERT INTO isd_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Paganában ku tutu wala daya gakagaka mu. Daya nas-nasiyon, ay maggayát da ngámin kikaw. Ay se adu kadaya gakagaka mu daya magbalin ka ári. ");
INSERT INTO isd_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Magkari yà kikaw se kadaya gakagaka mu se kadaya gakagaka da ka áwan panda. Ya karì kadakayu ay idi: Iyà ya Dios nu, ikaw se daya ngámin gakagaka mu. ");
INSERT INTO isd_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ay se ku idde kikaw se kadaya gakagaka mu ya ngámin Canaan nga pagkaw-kawiliyán nu pikam kídi. Ipakin kuwà dayán kaggída ka áwan panda ngin. Ay iyà ya Dios da,” nán ne Dios. ");
INSERT INTO isd_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ay se la nán manin ne Apu Dios kitu Abraham, “Ngamay nu ikaw, ay akkan mu kaligpanán ya pagturatuwán tada nga ipàwà kikaw se kadaya ngámin gakagaka mu se kadaya gakagaka da. ");
INSERT INTO isd_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Tu idi ya ipàwà kikaw se kadaya gakagaka mu, nga akkan nu kal-kaligpanán: Ngámin daya lalláki kadakayu, ay masápul la makúgit da. ");
INSERT INTO isd_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Masápul nga makúgit kayu ta ittu ya pakasinnán nga atán nagtuturatuwán tada. ");
INSERT INTO isd_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","Ngámingámin daya lalláki nga atán ki biyáng mu, ay masápul makúgit da nu walu ngalgaw da ngin manggayát ki keanà da. Ay masápul la kuwaan ngámin da pútupútut mu idi se daya asassu mu, neanà da ki balay mu se akkan. Oray nu ginátang mu da ki agtangeli, ay masápul makúgit da ngámin. Ay díkod ya nagkakariyán tada, ay atán peyapeyang ya pakasinnán nu ki baggi nu ki áwan panda. ");
INSERT INTO isd_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ay ngámin daya maddi magkúgit, ay akkan da mebíláng ka tolay ku, áta akkan da kinurug ya nagkakariyán mi.” ");
INSERT INTO isd_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ay se la nán ne Dios kitu Abraham, “Ay nu e Sarai nga atáwam, ay ingágan mu win ka Sara. Akkan Sarai ya ngágan na ngin. ");
INSERT INTO isd_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Paganggamman ku, ay se pagan-anaan ku ka isa nga laláki. Ay aggína pe ya magbalin ka bátug ina ngámin daya nagbal-baláki nga tul-tolay. Daya magári kadaya nas-nasiyon, ay maggayát kadaya an-annánà na,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ay se la nagukkab tu Abraham se nakagalà nga nán na kaggína kampela ngin nin, “Makapagan-anà kami nád pikam? Ay magatut dagun ku win, ay siyám púlu dagun Sara ngin,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ay se la nán Abraham ke Dios, “Ay nu mabiyág kuma nge Ismael ki agtagasíngam, Apu, ay aggína ngin ya kàwaán daya kar-kari mu” nán na. ");
INSERT INTO isd_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ay nán ne Dios, “Akkan ummán kiyán ya nán ku. E Sara mismu nga atáwam ay mabùsit. Magan-anà ka isa nga laláki. Ay ingágan mu ka Isaac. Ay aggína ya pagkariyán ku. Magkari yà kaggína para kadaya gakagaka na ka áwan panda. ");
INSERT INTO isd_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ay nu e Ismael, ay maawátan ku ya piyán mu. Ay bindisiyonan ku pe. Paaduwan ku tutu wala pe daya gakagaka na. Sangapúlu se duwa kadaya gakagaka na ya magbalin ka prinsipe. Pagbalinan ku ka adu nga tangámalán. ");
INSERT INTO isd_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ngamay e Isaac nga pútut mu ke Sara ya pagkariyán ku. Meanà nu isa nga dagun ki am-amung nedi,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ay kane mabalin makibàbànán ne Dios kitu Abraham, ay ummawan nin. ");
INSERT INTO isd_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ay díkod kitun kam ma algaw, ay inalà tu Abraham tu Ismael se ngámin datu asassu wa lalláki nga neanà kitu balay na se datu ginátang na nga asassu pe, ay se nada kinúgit ngámin nga ummán kitu pàwa ne Dios kaggína. ");
INSERT INTO isd_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Tu Abraham, ay siyám púlu se siyám dagun na ngin kitu nagkúgit na. ");
INSERT INTO isd_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ay tu Ismael nga an-anà na, ay sangapúlu se tallu dagun na kane magkúgit. ");
INSERT INTO isd_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","27","Kitun kam ma algaw tu nagkúgit tu Abraham se tu Ismael nga magama, se datu ngámin lalláki nga neanà ki balay na, se datu asassu na nga ginátang na kada agtangeli. ");
INSERT INTO isd_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Kitu aggag-agyán pikam tu Abraham kitu kakayuwán ka Mamre, ay nagpassingan ne APU kaggína. Atán magtutúgaw kitun kitu gagyangán natu báwi na kitu kapasúngat pànang tu algaw kitun. ");
INSERT INTO isd_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ay kane maglanga, ay pagkìlát na ngala daya tallu wa lalláki nga magsisíkád kitu ad-adanni kitu giyán na. Ay tútu nagkirut ta nawe nanabat kaggída, ay nagukkab kitu lusà kitu àráng da. ");
INSERT INTO isd_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ay nán na kaggída, “Magsíbál kayu pikam kídi, Apu. Ta senu masirbiyán takayu pikam, nu paganggammán nu ya agsurbì kadakayu. ");
INSERT INTO isd_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Magimáng kayu pikam ki layyung ned káyu wi, ta mawe yà a mangalà ka danum ma pamgù kadaya síkil nu, ta senu malnawán kayu. ");
INSERT INTO isd_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ay magsagána ngà pikam ka kanan tada, senu atán pamílag nu wa manalen. Ay se kayu wala mawe nu mabalin kayu mangán. Atán kayu mà in ked balay yi, ay díkod masápul la magserbi yà kadakayu,” nán tu Abraham. Ay díkod, “Ara lugud a nu ittu ya piyám,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ay díkod nagkaru wa nawe tu Abraham kitu báwi da se na nán kitu Sara, “Mangwa ka ka sinápay ya kanan dedi ya tallu tolay. Tu kapiyaán na arína ya usaram,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ay se la manin nanugkam tu Abraham ka isa kadatu báka na. Piníli na tu napiya nga urbun pikam. Ay se na nidde kadatu asassu na. Ay kinaru da nga pinarti se da linútu pe yin. ");
INSERT INTO isd_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ay kane makalútu da ngin, ay nagduy-ág da ngin. Ay uwad pe gátas se itu pinakulnit ta gátas. Ay díkod nangán datu tallu kitu layyung káyu, ay atán pe tu Abraham kitu giyán da, kaggída nga mangán. ");
INSERT INTO isd_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ay nán datu tallu kitu Abraham, “Wàna giyán ne Sara nga atáwam?” nán da. Ay “Atán kiya báwi,” nán tu Abraham. ");
INSERT INTO isd_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ay nán natu isa kadatu tallu, “Umbet tà manin kídi nu isa nga dagun ki am-amung nedi. Magan-anà e Sara ka isa nga laláki,” nán na. Ay kitu inangngagi na, ay uwad tu Sara kitu gagyangán natu báwi da nga padne likud kitu tolay. ");
INSERT INTO isd_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ay tu Abraham se tu Sara ay làlakay se bàbakat da ngin, ay díkod akkan magan-anà tu Sara ngin. ");
INSERT INTO isd_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ay tútu nakagalà kampela ngin nin tu Sara nga nán na, “Ay se yà nád maganásan manin meallay kane magbàbakat tà pànang ngin se maglàlakay pànang pe yin ya atáwà?” nán na. ");
INSERT INTO isd_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ay tútu nán ne APU kitu Abraham, “Tura nakagalà e Sara? ‘Kurug nád da magan-anà à kídi ya bàbakat tà in,’ tura na nán? ");
INSERT INTO isd_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Atán kadi ya nasulit kiyà nga APU?” “Ay kiya umbet ta dagun ki am-amung nedi, ay kurug ga umbet tà manin, nga ummán kitu kinagì kikaw. Ay atán ya an-anà ne Sara nga laláki kiyán nin,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","May tu Sara ay netuláyaw na tu nakagalà na, áta magansing. Ngamay nán ne APU, “Kurug mà a nga nakagalà ka,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ay se yala nga nagrubbuwát datu tallu. Ay binulun ne Abraham da panda kitu giyán na am-amawán da tu Sodom ka amarbuwát na kaggída. ");
INSERT INTO isd_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ay nán ne APU, “Akkan ku nád ipakammu ke Abraham ya asikkuwaan ku? ");
INSERT INTO isd_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ay e Abraham mà ya paggayatán daya adu tutu wala nga umíli nga magbalin ka abay nga nasiyon, ay gapu kaggína ay maganggam da ngámin pe. ");
INSERT INTO isd_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Aggína ya pinílì a makapútut ka adu, senu tùgúdán nada ngámin se daya akkobung na nga sumúrut kiyà nga APU ki angwa da kadaya napiya se daya kustu. Ta senu magun-ud da tu nekari ku ke Abraham,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ay díkod nepakammu ne APU kitu Abraham nga nán na, “Nasamnga ya pipílit kiyà panggap kadaya iSodom se iGomorra, ta napalotán ya kinadakè da se agbas-básul da. ");
INSERT INTO isd_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ay masápul la mawe yà managut ta sinnan nu kurug dedi ya nammuwán ku onu akkan,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ay díkod datu duwa nga lalláki, ay nawe da ka Sodom min. Ngamay tu Abraham, ay atán pikam magsisíkád kitu àráng ne APU. ");
INSERT INTO isd_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ay ummadanni tu Abraham ke APU, ay se na nán, “Wayya mu la nga itangapatay daya namáru wa tolay kadaya nadakè? ");
INSERT INTO isd_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ay kas pangarígan nu atán limma púlu wa namáru wa tolay kiya íli, ay dadàlan mu kammala ya íli? Wayya mu la di ditaan nala gapu kadaya limma púlu nga atán kitúni! ");
INSERT INTO isd_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Akkan á rumbang nga kuwaan mu yán! Nu itangapatay mu daya namáru kadaya nadakè! Wayya la nga nagpáda ya angwám kadaya namáru se daya nadakè? Ikaw mà ya sissa nga mabalin mangguwes kadaya ngámin tolay kid kalawagán! Ay áwan na di kurug kiya angguwes mu!” nán tu Abraham. ");
INSERT INTO isd_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ay tútu nán ne APU, “Ay nu atán masmà ku wa limma púlu wa namáru ka Sodom, ay akkan ku dadàlan ya íli gapu wala kaggída,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ay nán manin tu Abraham, “Oray ammù na lusà à ala se abu, ay paturínán ku wala ya makibàbànán kikaw, Apu,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","“Ay mapaanna nu akkan limma púlu, may atán appát púlu se limma nga namáru? Dadàlan mu ya íli gapu ta kúráng ka limma ngin?” nán na. Ay “Akkan ku dadàlan á nu atán masmà ku nga appát púlu se limma nga namáru,” nán ne APU. ");
INSERT INTO isd_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ay nán manin tu Abraham kaggína, “Ay kas pangarígan na ap-appát púlu da?” “Akkan ku pe á nga dadàlan gapu kadayán na appát púlu wa namáru,” nán ne APU. ");
INSERT INTO isd_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ay nán tu Abraham manin, “Akkan nà kuma nga lùsawan, Apu, ta atán kammala ya kagiyan ku. Ay nu kas pangarígan na tal-tallu púlu da nga namáru?” Ay nán manin pe ne APU, “Akkan ku pe nga dadàlan da á nu atán tallu púlu,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ay se yala nán manin tu Abraham, “Inagturad ku kurug ya magúni ki ummán kídi kikaw APU. Ngamay mapaanna nu dudduwa púlu da?” nán na. Ay “Akkan ku pe nga dadàlan á gapu kadayán na duwa púlu,” nán ne APU. ");
INSERT INTO isd_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ay nán pikam mala natu Abraham ke APU, “Akkan nà din lùsawan ta tu idi yin ya muddi nga kagiyan ku. Ay nu rán nala nga atán sangapúlu wa namáru?” nán na. Ay nán manin pe ne APU, “Ay akkan ku pe a nga dadàlan gapu kadaya sangapúlu nga namáru,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ay kane din mabalin makibàbànán ne APU Dios kitu Abraham, ay nagtálaw win. Ay nawe pe yin tu Abraham. ");
INSERT INTO isd_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ay datu duwa nga anghel, ay inumbet da ka Sodom kitu gabi. Tu Lot, ay uwad kitu dadnuwángan tu íli nga magtutúgaw. Ay kane masingan tu Lot da, ay nawe na sinabat da, se nagukkab kitu lusà a nagdáyaw kaggída. ");
INSERT INTO isd_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ay se na nán kaggída, “Apu, magsíbál kayu pikam agpà ki balay, se kayu la sumápa nga mawe nu kaláwa, senu mausesuwán ku pikam da síkil nu,” nán na. Ngamay nán da, “Akkan. Magyán kami la kiya amuwág naya íli,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ngamay pinílit nada. Díkod nawe da kitu balay na. Ay tútu pinamotun nada ka panggídám da. Ay nangwa pe ka sinápay ya áwan pamalbád. Ay se da nangán. ");
INSERT INTO isd_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ay kitu tagay da matúdug gin, ay naglalbet datu ngámin lalláki kitu íli Sodom. Linìmut da ngámin tu balay tu Lot. Atán ngámin nanákam se nabbing nga lalláki. ");
INSERT INTO isd_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ay se da nesáraw kitu Lot, “Wà giyán datu lalláki nga inumbet kanedi kídi nga gabi? Palawanan muda kidde, ta senu allayan mida,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Ay díkod lummawán tu Lot, ta we na amomanán datu lalláki. May negitap na kammin tu balay da. ");
INSERT INTO isd_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ay nán na, “Wawwági, pangaási nu agpà ta akkan nu kuwaan ya nadakè. ");
INSERT INTO isd_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Atán duwa nga babbalásang ku kiddi nga áwan pikam neallay kaggída nga laláki. Palawanan kuda ta kuwaan nu wala ya piyán nu kaggída. May pangaási nu ta akkan nu an-anuwan dedi nga lalláki ta sangaíli ku dedi. Ay yà ya makakaammu nu atán màwa kaggída nga nadakè,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ngamay nán datu lalláki, “Gayán! Agtangeli ka kanedi, ay tura la ikaw ya agginkakagi kadakami nu nágan naya kuwaan mi ta. Nadà-dakè lugud la ngin ya kuwaan mi kikaw may ya kuwaan mi kaggída,” nán da. Ay se da la nga maggugúru nga mangisùlin kitu gitap, ay malipit pe tu Lot tin. ");
INSERT INTO isd_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ngamay datu duwa nga sangaíli tu Lot, ay ginamnid da kitu unag, ay se da nga pinasuwalán tu gitap. ");
INSERT INTO isd_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ay se da pinagkúláp ngámin datu lalláki nga maggugúru nga mangisùlin kitu gitap. Ngámin da, lal-làlákay se nabbing. Ay díkod akkan da masmà in tu gagyangán. ");
INSERT INTO isd_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ay nán datu duwa nga lalláki kitu Lot, “Atán da kabbulun mu kiddi, ummán kadaya manúgáng mu onu annánà mu se daya duddúma nga induan nu? Itálaw nuda kanedi ya íli ");
INSERT INTO isd_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ta dadàlan mi idi yin na íli. Ta palotán pànang ngin ya kinadakè daya kuk-kuwaan dedi nga tolay yin. Ay túya nebon nakami ye APU nga manadál kiya íli,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ay tútu nawe tu Lot kitu giyán datu tali manugángan na ngin na lalláki se na nán kaggída, “Bumángun kayu ta magtálaw tada kídi ya giyán, ta dadàlan ne APU win idi ya íli,” nán na. May dálin da nu pangisoru tu Lot tu nán na. ");
INSERT INTO isd_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ay kane danni láwa ngin, ay binur-burung datu anghel tu Lot. “Bumángun ka ngin! Alà mu ya atáwam se daya duwa nga babbalásang mu, ta senu akkan kayu metangatay kadaya umíli ta panísan ne Dios da,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ngamay min-induwán mán kammin tu Lot. Ay tútu rinùrut da de Lot ta magatáwa se datu duwa babbalásang da. Ta kinalakkán ne APU da. Ay tútu nippan dada kitu lasi natu íli. ");
INSERT INTO isd_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ay kane mippan dada kitu lasi natu íli, ay nán da kaggída, “Magtálaw kayu senu akkan kayu matay. Akkan kayu maglingay. Akkan kayu magsin-sínang oray ka wàna kiya tanáp. Mawe kayu kadaya ban-bantay ta senu akkan kayu matay,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","19","May nán tu Lot kaggída, “Akkan, Apu. Nu mawe kami kadaya ban-bantay, get madànganán nakami pikam ya annadál ne Apu, ay matay kami. Gapu ta nepassingan nu win ya kinamáru nu kiyà in kiya angngilísi nu kiyà kiya pakatayán ku, ay palubúsán nà ala nga mawe ");
INSERT INTO isd_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","kiya íli kitúni. Adanni kam yán na pagtaláwan mi. Bittì nga íli may áwan ku kaan-anuwán kannán,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ay nán tu isa kaggída kitu Lot, “Ara, ay atán pikam napiya nga kuwaan ku para kikaw. Akkan ku wa dadàlan ya nán nu wa íli. ");
INSERT INTO isd_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Magkaru kayu lugud da mawe kannán nin ta áwan ku nga màwa panda ki akkan nu idaddatang kiyán na íli,” nán na. Ay túya tun na íli, ay nengágan ka Zoar (bittì ya sarut na). ");
INSERT INTO isd_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ay linumtà tu mata ngin kane dumatang de Lot kitu íli Zoar. ");
INSERT INTO isd_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ay se yala pinagdittág ne APU ya apuy se maggatagatang nga asufre ka Sodom se Gomorra. ");
INSERT INTO isd_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ay dinadál na datu il-íli kitúni se datu tan-tanáp pa giyán. Ay nagkakátay ngámin pe datu tolay kattoni, se ngámin na sibbiyág se ngámin mul-múla se kad-kaddat. ");
INSERT INTO isd_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ngamay tu atáwa tu Lot, ay naglinggaw mán kammin kaggída nga magtálaw, ay díkod nagbalin ka sibbukal la asin. ");
INSERT INTO isd_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ay kane pag-pagmakát, ay nawe tu Abraham kitu giyán na nagamomanán da se APU. ");
INSERT INTO isd_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ay se na amawán ya Sodom se Gomorra se ngámin datu il-ileli kitu tanáp. Ay tútu nasingan na tutu wala ngin na magat-atù tutu wala pànang datu il-ileli. ");
INSERT INTO isd_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ay ummán kiyán tu nàwa kane dadàlan ne Dios datu il-ileli kitu tanáp. Akkan kam kinaligpanán ne Dios tu Abraham ta pinatálaw na tu Lot pikam se na ngala nga dinadál datu il-ileli meráman tu nagyanán tu Lot. ");
INSERT INTO isd_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Ay kane din kuwa, ay nagtálaw tu Lot ka Zoar. Nanùdu da nga nawe kadatu ban-bantay. Aggída se datu duwa nga babbalásang na. Magansing da nga magyán ka Zoar. Ay díkod nag-agyán da ngala ngin kitu isa nga abay nga liyáng. ");
INSERT INTO isd_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Isa ngalgaw, nán tu manákam ma babbalásang kitu udiyán na, “Làlakay ama ngin, ay áwan nala oray isa nga laláki nga mangatáwa kadàta. ");
INSERT INTO isd_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Pinglawan ta nge ama se ta la nga allayan, ta senu atán an-anà ta ke ama,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ay tútu kane gabi, ay pinemum da tu ama da ka bási panda kitu nekinglaw na. Ay se la neallay tu manákam kaggína. Ay akkan na am-ammu nu inna tu neallay kaggína se tu nagtálaw na. ");
INSERT INTO isd_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ay kane kaláwa, ay nán natu manákam kitu udiyán, “Uy, kitu gabi ay iyà tu neallay ke ama. Pinglawan ta manin nu gabi, ay se mu allayan. Ta senu atán an-anà ta ke ama,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ay díkod pinenum da manin tu ama da kitun na gabi panda kitu nekinglaw na. Ay se yala neallay tu udiyán kaggína. Ay áwan na am-ammu kitu neallay kaggína se tu nagtálaw na. ");
INSERT INTO isd_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Ay díkod, datu duwa nga babbalásang tu Lot, ay nabùsit da. ");
INSERT INTO isd_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ay kane magan-anà da ngin, ay laláki tu an-anà tu manákam. Ay nepangágan na ka Moab. Aggína ya apuapu datu Moabita kadedi ya al-algaw. ");
INSERT INTO isd_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ay tu udiyán, ay nagan-anà pe ka isa nga laláki. Ay nepangágan na ka Ben-ammi. Ay aggína ya apuapu ngámin daya Amonita kadedi ya al-algaw. ");
INSERT INTO isd_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ay naggayát kitúni Mamre, ay nawe manin tu Abraham kitu sakúpan Negeb. Nagyán kitu giyán na atán kitu nagbàtán Kades se Sur. Ay se nagyán ka nakaru wala ka Gerar. ");
INSERT INTO isd_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ay tu Abraham ay kagiyan na manin kadatu tolay kitúni Gerar nga wagi na tu Sara nga atáwa na. Ay díkod tu Abimelec nga ári ka Gerar, ay pinálà na tu Sara kitu palásiyu na. ");
INSERT INTO isd_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ngamay, kane gabi ay nagpatagenap pe Dios kitu Abimelec. Ay nán na kaggína, “Matay ka, gapu kiya babay nga pinálà mu, áta atán atáwa na ngin,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ay tu Abimelec ay akkan na pikam inlay tu Sara. Ay tútu nán na, “Apu, patayam agpà ya tolay ya áwan na kinuwa nga nadakè? ");
INSERT INTO isd_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Nán na mà kampela ngin nin nga magwagi da. Ay nán pe tu babay nga magwagi da kurug. Ay túya kinuwà idi, áta akkan ku kurug ammu ya kurug na. Ya kustu mà ala ya piyán ku wa kuwaan,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ay tútu nán ne Dios kaggína kitu tagenap na, “Kurug. Ammù nga kinuwám idi ta kurug ga akkan mu ammu. Ay túya nelísi taka kiya pakabasúlán mu kuma kiyà. Túya akkan ku nepalúbus nga kuwaan mu ya piyán mu kaggína. ");
INSERT INTO isd_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ipatullim lugud din ya babay, ta ya atáwa na, ay profetà. Ikarárag naka ta senu akkan ka matay. Ngamay nu akkam ipatulli, ay kurug ga matay ka, ikaw se daya ngámin tolay mu.” ");
INSERT INTO isd_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ay díkod sumápa nga ginumniya tu Abimelec, ay se na kirrawán ngámin datu asassu na. Ay se na kinagi kaggída tu ngámin na nàwa. Ay nagansing tutu wala ngámin datu asassu na. ");
INSERT INTO isd_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Ay se la pinàrawán natu Abimelec tu Abraham. Ay nán na kaggína, “Taanna, tura ummán kídi ya kinuwám kadakami ta? Nágan na agpà ya nagbasúlán ku kikaw ta, tura nakami tag-tagge pagbasúlan, se daya itur-turayán ku? Turám agpà kinuwa kiyà yán ta?” nán na. ");
INSERT INTO isd_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ay nán pikam tu Abimelec kitu Abraham, “Nágan tu lam-lammat mu ta, tura mu kinuwa yán?” ");
INSERT INTO isd_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ay nán natu Abraham, “Kinuwà tun, áta dálin ku nu áwan tutu wala ya magansing ke Dios kanedi nga giyán. Ay get nu patayan dà gapu kiya atáwà, nán natu uray ku. ");
INSERT INTO isd_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ay se ya isa pe, ay kurug mà a magwagi kami. Magwagi kami ka ama ngala. Sabáli ya ina na kampela ngin nin. May nagatáwa kami. ");
INSERT INTO isd_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ngamay kane papannan nakami ye Apu Dios nga pag-agyanan ka nagbal-baláki nga íli maggayát ka balay tu ama ku, ay nán ku kaggína, ‘Tu idi ya kuwaam ka angngipassingan mu kiya kinamárum kiyà. Kadaya ngámin il-ileli nga kapannán ta, nán mu wa wagi nà gane’ nán ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ay tútu niddán natu Abimelec tu Abraham ka karneru se báka, ay se niddán na pe ka asassu na nga babbay se lalláki. Ay se na ipatulli kaggína kammin tu Sara nga atáwa na. ");
INSERT INTO isd_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ay se nán tu Abimelec kitu Abraham, “Lusà ku ngámin idi nga masingan mu. Magyán ka ngala kiya piyám pagyanán,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ay nán na pe kitu Sara, “Niddán ku ya wagi mu ka maríbu wa pinaláta nga pirà. Túyán ya bátug pangappiya ku, ta senu mammuwán daya ngámin na kabbulun nu nga áwan mu kinuwa nga nadakè. Ay ammuwán da ngámin pe nga nagkakappiya tada ngámin nin,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Ay tútu nagkarárag tu Abraham ke Dios. Ay díkod impoli ne Dios tu Abimelec se tu atáwa na se datu asassu na nga babbay, ta senu makapagan-anà da kammin. ");
INSERT INTO isd_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Ata akkan kuma pagan-anaan ne Dios ngámin da babbay nga akkobung tu Abimelec nu akkan na nepatulli tu Sara nga atáwa tu Abraham. ");
INSERT INTO isd_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Ay e APU, ay nepassingan na kurug ya kinamáru na kitu Sara, ay se tinungpál na tu nekari na. ");
INSERT INTO isd_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Ata oray nu làlakay yin tu Abraham se bàbakat tu Sara ngin, ay kurug ga nabùsit se nagan-anà ka isa nga laláki kitu oras sa kinagi ne Apu Dios kitu Abraham. ");
INSERT INTO isd_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ay Isaac ya nepangágan natu Abraham kitu an-anà da. ");
INSERT INTO isd_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ay kane walu ngalgaw natu an-anà, ay kinúgit natu Abraham, áta ittu lugud tun tu bílin ne Dios kaggína. ");
INSERT INTO isd_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Kitu nekeanà natu Isaac, ay magatut tu dagun natu Abraham min. ");
INSERT INTO isd_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ay nán tu Sara, “Niddán nà e Apu Dios ka paganggammán ku. Ay oray nu inna nga makadámag nga nabùsit tà, ay mepaganggam da pe kiyà. ");
INSERT INTO isd_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ata inna pe ya mangipapáti nga magan-anà à kammala ta! Ngamay oray làlakay ye Abraham min, ay tura ngà kurug ga nakapagan-anà pikam,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ay ummabay tu Isaac kin. Ay díkod pinísu da pe yin. Ay kitu namísu da kaggína, ay namadumag nagsay-am tu Abraham. ");
INSERT INTO isd_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ay kitu isa ngalgaw, ay nasingan tu Sara tu pútut tu Abraham kitu Hagar nga iEgipto nga ag-agbán na nge Isaac nga an-anà na. ");
INSERT INTO isd_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Ay tútu nán tu Sara kitu Abraham, “Pataláwam ya asassu kiyán se iya an-anà na. Ta akkan mabalin na mepangtáwid kadaya kuw-kuwám ya an-anà na ke Isaac nga an-anà ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Magpannakit pànang tu Abraham ta pútut na mà lugud pe tu Ismael. ");
INSERT INTO isd_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ngamay nán ne Dios kitu Abraham, “Akkan ka magpannakit gapu kiya an-anà se ya ina na nga asassum. Nu nágan naya piyán ne Sara, ay ittu ya kuwaan mu, ta ngámin daya gakagaka mu ay e Isaac ya paggayatán da. ");
INSERT INTO isd_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ay iya an-anà naya asassu mu wa babay, ay pagbalinan ku ka adu tutu wala daya gakagaka na nga magbalin da ka isa nga nasiyon pe. Kuwaan ku yán gapu ta pútut mu lugud pe,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ay díkod kane kaláwa, ay gummabi nga bumángun tu Abraham. Nangalà ka sinápay se danum se na idde kitu Hagar. Ay se na pe nepàbay tu an-anà se nada papannan nin. Nawe da nga magina se da nga nagal-aliwagwag kitu ir-ir-er ka Beerseba. ");
INSERT INTO isd_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ay kane mammin tu danum da, ay nelídum na tu an-anà kitu isa nga kaykayu. ");
INSERT INTO isd_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ay se yala nawe nagtutúgaw kitu ad-adayyu. Annung na dalotán ka bútug tu kadayyu na. Ta nán na kitu uray na, “Akkan ku piyán sinnan ya pannakatay naya an-anà ku,” nán na. Kaggína nga magtutúgaw, ay sumángit tu an-anà. ");
INSERT INTO isd_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ay nagìna ne Dios tu an-anà. Ay díkod uwad anghel ne Dios nga atán ka lángit nga kinumraw kitu Hagar. Ay nán na, “Nágan naya pakariribuán mu, Hagar? Akkan ka malídug. Ata nagìna ne Dios ya sangit naya an-anà. ");
INSERT INTO isd_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ara, mawem arikúpan se anannayan ya an-anà. Ta daya pútupútut na, ay pagbalinan kuda ka isa nga abay nga nasiyon,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ay se la nepassingan ne Dios kaggína tu bubun. Nawe kitu bubun se na pannuwan ka danum tu agdanumán na nga lálat. Ay se na pe penuman tu an-anà. ");
INSERT INTO isd_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ay tinag-tagasinnán ne Dios tu an-anà. Ummabay kitu ir-ir-er ka Paran. Ay lummaing pe nga magusár ki bútug. ");
INSERT INTO isd_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ay se la pinagsápul tu ina na ka Egipto ka atáwa na. ");
INSERT INTO isd_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ay kitun kam ma al-algaw, ay nawe tu ári Abimelec se tu Ficol nga ap-apu datu suldádu natu ári kitu giyán Abraham. Ay nán da kaggína, “Ammu mi nga bul-bulunan naka peyapeyang nge Dios ki oray inna ya kuwaam. ");
INSERT INTO isd_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ay ikari mu mán tutu wala kiyà ki àráng ne Dios, nga akkan nà kas-kasbaan se daya pútupútut ku se daya gakagaka ku. Namáru wà kikaw, ay ummán ka din pe kiyà. Ay akkan mu din pe pagdudoray ya íli nga nagkawiliyám,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ay tútu nán natu Abraham kaggína, “Ò, isipatà nga kuwaan yán,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ay tútu neríri pe natu Abraham kitu Abimelec tu isa nga bubun na nga simpal datu asassu tu Abimelec. ");
INSERT INTO isd_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","May nán tu Abimelec, “Akkan ku am-ammu nu iinna ya nangwa kiyán. Apakagìnà ala yán kídi kammin kane kagiyam kiyà. Awan mu mà kinagi kiyà kitun,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ay díkod nangidde tu Abraham kitu Abimelec ka kar-karneru se bak-báka, ay se da nagturátu wa duwa. ");
INSERT INTO isd_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Nangisibna tu Abraham ka pittu nga babbay ya urbun karneru kadatu karneru na. ");
INSERT INTO isd_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ay tútu nán natu Abimelec kitu Abraham, “Nágan naya piyám kagiyan kiyán? Turám nesibna ya pittu wa urbun karneru nga pabeg babbay?” nán na. ");
INSERT INTO isd_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ay nán tu Abraham kitu Abimelec, “Alà mu dedi nga babbay nga urbun karneru, ta ittu daya pakammuwán nga iyà ya nagkorob kitu bubun,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ay díkod tun na giyán, ay nengágan da ka Beerseba, ta kitúni ya nagsipataán da nga duwa. ");
INSERT INTO isd_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ay kane mabalin da magkinnari ka Beerseba, ay nagulli da pe yin ka Filistia de Abimelec se tu Ficol nga ap-apu datu suldádu natu ári. ");
INSERT INTO isd_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ay tu Abraham, ay nangimúla ka isa nga káyu wa tamáris ka Beerseba. Ay nagday-dáyaw kitúni ke APU nga atán peyapeyang. ");
INSERT INTO isd_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ay nabà-bayág pikam tu Abraham nga nepagíli ka íli Filistia. ");
INSERT INTO isd_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Akkan nabayág, ay inumbet tu agtisting ne Dios kitu Abraham. Ay kinumraw kaggína nga nán na, “Abraham!” nán na. Ay, “Inna tun, Apu?” nán tu Abraham. ");
INSERT INTO isd_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ay tútu nán ne Apu Dios kaggína, “Alà mu we Isaac, nga sissa nga an-anà mu nga pà-pàgam. Ay se ka mawe ka Moria, ay se mu la sìdúgan na idátun kiyà kiya bantay nga itùgud ku kikaw,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ay díkod kane kaláwa, ay gummabi tu Abraham ma ginumniya. Nanaltág ka káyu wa pagupu na kitu angngibasu na kitu an-anà na. Ay se yala nga nagtakay kitu asnu na, ay se yala nagrabbuwát ta kabulun na tu Isaac se datu duwa nga asassu na. Ay se da mawe yin kitu giyán na kinagi ne Apu Dios. ");
INSERT INTO isd_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ay kane mekàlu walgaw da ngin kitu dálen, ay se yala nga nalágib tu Abraham tu giyán na nán ne Apu Dios. ");
INSERT INTO isd_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ay nán tu Abraham kadatu asassu na, “Magyán kayu wala kídi, ay sinnan nu ya asnu ta mawe kami se iya an-anà ku kannán na magdáyaw ke Apu Dios, ay se kami yala nga umbet kammin nu mabalin kami,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ay díkod inalà tu Abraham tu káyu se na ipabugtung kitu Isaac. Inalà na pe tu palsing da, se itu ippapatay na nga lansíta. Ay se da nawe nga duwa. ");
INSERT INTO isd_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ngamay nán tu Isaac kitu Abraham ma ama na, “Ama!” nán na. Ay “Inna tun, ugu?” nán tu Abraham. Ay, “Atán palsing ta se káyu ta, ngamay wà giyán naya urbun karneru wa pagbasu ta?” nán tu Isaac. ");
INSERT INTO isd_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ngamay, “E Dios kampela ngin nin ya makakaammu kiyán,” nán tu Abraham. Ay netul-túluy da tu agdal-dalen da. ");
INSERT INTO isd_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ay dummatang da kitu giyán na kinagi ne Dios. Ay díkod nangwa tu Abraham kitu annìdúgán na ka pagbasu na. Ay nippáy na pe yin tu káyu. Ay se na nga pingílan tu Isaac se na nga ippáy kitu útun datu káyu wa nippáy na kitu útun natu agbasuwán na kinuwa na. ");
INSERT INTO isd_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ay se na la alà tu lansíta na ngin ta patayan na kuma tu an-anà na ngin. ");
INSERT INTO isd_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ngamay uwad anghel ne APU nga kinumraw kaggína ka lángit nga nán na, “Abraham! Abraham!” nán na. Ay, “Inna tun, Apu?” nán na. ");
INSERT INTO isd_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ay nán natu anghel, “Di mu! Akkam an-anuwan ya an-anà mu. Ammù in na kurug ga e Dios ya kur-kurugan mu, áta oray ya sissa nga an-anà mu, ay akkam itagàna kaggína,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ay se yala neapág tu Abraham tu mata na, ay nasingan na tu isa nga toru karneru wa nasipután tu sàgud na kitu karìmannán. Ay ittu tu inalà na ka sinìdug na nga pinagbasu na ke Apu Dios nga nepatáli na kitu an-anà na. ");
INSERT INTO isd_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ay tútu nepangágan tu Abraham tun na giyán ka “E APU ya mangidde”. Ay oray kadedi yin na al-algaw nán da tolay ya “Mangidde ye APU kiya bantay na.” ");
INSERT INTO isd_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ay kinumraw manin tu anghel ne Dios kitu Abraham ");
INSERT INTO isd_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","nga nán na, “Nán ne APU ‘Magsipata ngà kampela ngin nin gapu kiyán na kinuwám, nga akkan mu netagàna kiyà ya sissa nga an-anà mu. ");
INSERT INTO isd_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Ay ya kuwaan ku, ay paganggamman taka pà-pànang. Paaduwan ku tutu wala daya gakagaka mu, ta senu ummán kiya kaadu daya bittuwan ya katabbun da, onu ummán kiya kaadu daya ginat kiya kapanágan ya kaadu da. Ay sengán kuda pe, ta senu abákan da daya kalínga da, ay aggída ngin ya mangituráy kadaya il-íli da. ");
INSERT INTO isd_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ay gapu kaggída, ay mapaanggam ngámin daya umíli kid kalawagán. Kuwaan ku yán, áta nekurug nà,’ nán ne Apu Dios,” nán natu anghel. ");
INSERT INTO isd_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ay díkod nagulli de Abraham min kitu giyán datu asassu na nga pinanáwan da. Ay nawe da ngámin nin ka Beerseba. Ay nagyán da kitúni yin. ");
INSERT INTO isd_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Akkan nabayág nanggayát kitun, uwad nangagi kitu Abraham nga adu annánà tu Milca se tu Nahor ra wagi na nga laláki. ");
INSERT INTO isd_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Tu dedi datu pútut na nga lalláki: Tu manákam ay tu Uz, se la tu Buz, se la tu Kemuel nga ama tu Aram, ");
INSERT INTO isd_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","se la tu Kesed, tu Hazo, tu Pildas, tu Jidlaf, se tu Betuel. ");
INSERT INTO isd_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Tu Betuel tu ama tu Rebecca. Dayán na walu, ay aggída datu annánà tu Milca se tu Nahor nga wagi tu Abraham. ");
INSERT INTO isd_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ay tu Reuma nga nekàduwa tu Nahor, ay atán appát annánà na nga pabeg lalláki. Tu Teba, tu Gaham, tu Tahas, se tu Maaca. ");
INSERT INTO isd_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Tu Sara ay magatut se duwa púlu se pittu dagun na se la natay. ");
INSERT INTO isd_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Natay ka Kiriatarba (Hebron kam yán), ka íli Canaan. Ay díkod nagmanakit tu Abraham. ");
INSERT INTO isd_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Kitu aggiinnatay da, ay nagtálaw tu Abraham kitu giyán tu innát, ay se na nán kadatu Heteo, ");
INSERT INTO isd_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Agtangeli yà kadakayu, ay se mepag-agyán nà ala kadakayu kanedi. Ay túya masápul ku ya pangitamnán ku ki minatay ku. Túya gumátang ngà kuma ka lusà nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ay tútu nán datu Heteo kitu Abraham, ");
INSERT INTO isd_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Apu, gìnán dakami. Ikaw ay ibíláng mi ka nga naturáy nga nadiosán. Túya kagiyan mi kikaw nga itaman mu wala ya minatay mu kiya kapíyán na agtamnán mi. Awan ya mangitagàna kadakami kadaya agtamnán mi kikaw ka pangitamnán mu ki minatay mu,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ay tútu nagukkab tu Abraham kitu àráng ngámin datu Heteo nga ittu datu umíli kitúni. ");
INSERT INTO isd_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","9","Ay se na nán kaggída, “Ay nu ipalúbus nu lugud da itaman ku ya minatay ku kanedi, ay piyán ku kuma tu liyáng ka Macpela nga atán kitu lusà ne Efron. Atán kitu tapungtu natu lusà. Amomanán nu mán ta iláku na kuma kiyà. Gatángan ku kaggína ki kustu nga banor na. Dakayu ya bátug sistígù kiya anggátang ku kaggína kiyán na pangitamnán ku ki minatay ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ay kitun kam nga oras ay atán tu Efron na mepagtutúgaw kadatu páda na nga Heteo. Ay tútu sinungbátan tu Efron tu Abraham. Ay maggigìna ngámin datu Heteo nga atán kitúni, datu inumbet kampela ngin kitúni íli. ");
INSERT INTO isd_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Ay nán tu Efron, “Akkan, Apu. Akkan ku iláku kikaw. Kurug idi nga nán ku. Iddè ala kikaw ya lusà ku se itu liyáng kitúni. Kiya aggigìna ngámin dedi nga tolay yi, kagiyan ku nga idde ku wala kikaw tu lusà ku. Itaman mu la ya minatay mu kitúni,” nán na kitu Abraham. ");
INSERT INTO isd_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ay tútu nagukkab tu Abraham ki àráng ngámin datu umíli. ");
INSERT INTO isd_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Ay se na nán kitu Efron, “Ay gìnán nà pe, gane,” nán na. “Bayádan ku kikaw ya lusà. Alà mu kuma agpà ya pagbáyad ku ki lusà mu, ta senu metaman ku ya minatay ku kitúni,” nán tu Abraham. Ay gigìnán datu umíli nga uwad kitúni tun na kinagi tu Abraham. ");
INSERT INTO isd_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ay nán lugud pe yin tu Efron kitu Abraham, ");
INSERT INTO isd_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Apu, gìnán nà pe. Oray appát gatut ta pinaláta nga silber ngala lugud ya pangbanor ku kiya lusà ku. Ay manu mà pe la yán kadàtada ta? Alà mu kurug gin, ay itaman mu ya minatay mu kitúni,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ay tútu nayát pe yin tu Abraham kitu piyán tu Efron. Díkod kinílu tu Abraham min tu silber ka pagbáyad na kitu Efron. Kinílu na sigun kitu agkílu datu maglà-láku. Appát gatut ta pinaláta nga pirà tu kinagi ne Efron ki aggigìna datu Heteo. ");
INSERT INTO isd_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Ay díkod tu lusà tu Efron ka Macpela nga padne lattakán ka Mamre, ay kuw-kuwa tu Abraham min. Ráman natu lusà tu liyáng se datu ngámin kay-káyu nga atán kitu sákup natu lusà. Ay datu Heteo kitúni, datu inumbet kitu íli datu sistígu kitu nangingágan da kitu lusà ka kuw-kuwa natu Abraham. ");
INSERT INTO isd_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ay díkod netaman tu Abraham tu Sara nga atáwa na kitu liyáng nga atán kitu apanggátang na nga lusà ka Macpela ka padne lattakán ka Mamre (ka Hebron yán) ka Canaan. ");
INSERT INTO isd_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ay díkod tu lusà se tu liyáng nga agtamnán nin nga kuw-kuwa datu Heteo kitun, ay nengágan nin kitu Abraham. ");
INSERT INTO isd_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ay tu Abraham, ay làlakay tutu wala pànang pe yin. Kinalakkán ne APU ki ngámingámin ki inagbiyág na. ");
INSERT INTO isd_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Isa ngalgaw, ay nán tu Abraham kitu isa nga asassu na, tu manákam kaggída ngámin, nga ittu tu makakaammu kadatu ngámin na kuw-kuwa na, “Ippáy mu mán ya ímam kiya panìgad lappu ku, ");
INSERT INTO isd_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ta pagsipataan taka. Isipatám kiyà ki àráng ne APU nga Dios ka lángit se ngámin kalawagán, nga akkan ka maw-awe kadaya babbalásang ka Canaan, nu pagsápul mu ya pútut ku ka atáwa na, oray nu nag-agyán nà kanedi Canaan. ");
INSERT INTO isd_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","May mawe ka kitu ílì kampela ngin kadatu pan-pane ku kammin se mu pagsápul le Isaac nga pútut ku ka atáwa na,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ay nán natu asassu kaggína, “Ay get nu maddi kumíwid ya masmà ku nga babay kanedi. Alà ku lugud kammin ya pútut mu kannán íli nga naggayatán mu?” nán na. ");
INSERT INTO isd_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ay nán tu Abraham, “Akkan! Akkan mu ippan kammin kannán ya pútut ku. ");
INSERT INTO isd_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","E APU nga Dios ka lángit, ay paginunnaan na kikaw ya anghel na. Ta senu makasmà ka kattoni ka atawán ne Isaac nga pútut ku. Ta e Dios kam tu nagpigsán kiyà kiya balay amà se kitu íli nga neanaán ku. Nagsipata kiyà nga nán na, ‘Iddè idi nga lusà kadaya pútupútut mu,’ nán na kiyà. ");
INSERT INTO isd_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ay nu maddi kumíwid kikaw ya babay nga masmà mu, ay áwan mu win na básul kiya nesipatám kiyà. Akkan mu la nga iulli kammin kannán ya pútut ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ay díkod nippáy tu asassu tu íma na kitu panìgad lappu natu Abraham nga apu na, se na nesipata nga kuwaan na tu piyán tu Abraham. ");
INSERT INTO isd_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ay díkod nangalà tu asassu ka sangapúlu kadatu kámel natu apu na. Nangalà pe kadatu kuw-kuwa natu apu na kadatu nagbal-baláki nga napiya nga rigálo. Ay se la nawe ka Mesopotamia ka íli Nahor. ");
INSERT INTO isd_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ay kane dumatang kattoni, ay pinagimáng na datu kámel na kitu adanni kitu bubun nga atán kitu lasi natu íli. Ay gid-gidám pe yin. Ittu tu oras nga agsasàdu datu babbay. ");
INSERT INTO isd_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ay nán na, “APU nga Dios natu apu ku wa Abraham, ipalúbus mu agpà nga málà ku ya gákat ku kanedi kídi nga algaw. Ay ikarárag ku pe kikaw nga ipassingam ke Abraham nga apu ku ya áwan kapal-palíyán na aminyám. ");
INSERT INTO isd_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ay atán nà a magsisíkád kiddi adanni ked bubun ni. Ay tagay maglalbet daya babbalásang da tolay kanedi nga magsàdu. ");
INSERT INTO isd_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ipalúbus mu kuma nga ya babay ya pagkunaán ku ka, ‘Uminum ta mán,’ ay se nà penuman ay se na penumán pikam pe daya kámel, ay aggína kuma ya píli mu para ke Isaac nga bobonam. Ay ittu yán ya pakammuwán ku nga nepassingan mu ya áwan kapal-palíyán na aminya mu kitu apu ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","16","Ay oray kitu akun-oni na pikam, ay atán na la ngin tu Rebecca ngin na sittututun ka amutu nga umbet magsàdu. Tu Rebecca, ay an-anà tu Betuel nga an-anà tu Milca se tu Nahor nga wagi tu Abraham nga laláki. Napiya tutu wala, ay se babbalásang pikam pe. Ay akkan pikam pe neallay ki oray inna nga laláki. Pinnu na tu amutu na ka danum. ");
INSERT INTO isd_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ay kane masingan tu asassu tu Rebecca, ay nawe na sinabat, ay se na nán, “Uminum ta mán,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ay nán tu Rebecca, “Ara, apu uminum ka,” nán na. Ay burung na pe nga mangipasekig kitu amutu na. ");
INSERT INTO isd_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ay kane mabalin mamenum kitu asassu, ay nán na manin, “Pagsàdu ku pe daya kámel mu, ápu, ta senu makenum da ngámin pe,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ay díkod nesiyà na la ngin tu danum kitu amutu na kitu lútung nga agginumán datu kámel. Ay se nada pinagsàdu panda kitu nakenum da ngámin. ");
INSERT INTO isd_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Kinas-kasisinnán natu asassu tu Rebecca, ta sinnan na nu nidde ne APU kaggína ngin tu negákat na kitúni onu akkan pikam. ");
INSERT INTO isd_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ay kane mabalin uminum ngámin datu kámel lin, ay inalà natu asassu datu nakangin-ngína nga sangkilat ta balitù se duwa nga galáng nga nangína pànang pe se na idde kitu Rebecca, ");
INSERT INTO isd_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","ay se na nán kaggína, “Inna ya makin-an-anà kikaw? Ay mabalin mi nád se daya kabbulun ku ya magdagus ka balay nu kídi nga gabi?” nán na. ");
INSERT INTO isd_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ay nán tu Rebecca kaggína, “E Betuel ya ama ku. Ukò ku tu Milca nga atáwa tu Nahor,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ay se na nán pe, “Ay adu makkán animál ka balay, se adu dagámi pe. Ay atán pe kuwartu nga annung nu patudúgán nu gabi,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ay tútu nagukkab tu asassu nga nagdáyaw ke APU. ");
INSERT INTO isd_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Ay nán na, “Maday-dáyaw ka APU nga Dios natu apu ku nga Abraham. Ta nepassingam ya áwan kapal-palíyán na aminyám se ya kinamárum kaggína. Ay se neturung nà pe kiya balay daya pan-pane natu apu ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ay tu Rebecca, ay nanagtág ga nawe kitu giyán tu ina na se na kinagi tu ngámin kaggína. ");
INSERT INTO isd_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ay atán wagi tu Rebecca nga laláki. Laban tu ngágan na. Nagìna tu Laban tu kinagi tu Rebecca. Ay kane masingan na tu sangkilat se itu galáng kadatu íma ne Rebecca nga wagi na, ay se na magìna tu kinagi na nga “Nán natu laláki kiyà” nán na, ay tútu nanagtág nga nawe naningan kitu asassu. Ay dinatang na nga magsisíkád kitu giyán tu bubun. Ay atán pe datu kámel na kitúni. ");
INSERT INTO isd_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ay tútu nán tu Laban kitu asassu, “Dadin ka balay, ápu. Ammù nga nebon naka nge APU. Tura ka magsisíkád dala ki lasi? Nakasagána ngin ya kuwartu mu, ay atán pagyanán pe daya kámel mu,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ay díkod linumnà kurug tu tolay. Ay tu Laban, ay aggína tu nakammu kadatu kámel na. Niddán nada ka dagámi se nada pe pinenumán. Nagsàdu pe ka pagusesu natu tolay se datu kabbulun na nga lalláki. ");
INSERT INTO isd_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ay nakadasár tu panggídám da pe yin. Ngamay nán tu asassu, “Kagiyan ku pikam ya gákat ku se yà ala mangán,” nán na. Tútu nán tu Laban, “Ara lugud, kagiyan mu win,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Díkod, “Iyà ay asassu nà e Abraham,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","“Kinalakkán pànang ne Apu Dios tu apu ku. Ay díkod bumànáng tutu wala. Niddán ne APU Dios ka adu karneru, se kalding se adu wa báka. Ay adu kámel na pe se asnu na. Niddán na pe ka balitù se pirà se adu pe datu asassu na, babbay se lalláki. ");
INSERT INTO isd_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Tu Sara nga atáwa na, ay nagan-anà ka isa nga laláki kitu kabàbakat na ngin. Ay nepatáwid naya apù kaggína ya ngámingámin na kuw-kuwa na. ");
INSERT INTO isd_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Pinagsipata nà ya apù nga akkan nà magsápul ka atawán naya pútut na kadaya babbalásang ka Canaan, oray kattoni ya pag-agyanán na. ");
INSERT INTO isd_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Piyán na nu umbet tà kanedi ya íli datu apuapu na se giyán daya ngámin na pan-pane na. Kanedi ya piyán na nga pagsapúlán ku ka atawán naya pútut na. ");
INSERT INTO isd_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ay sinaludsud ku kaggína, ‘Mapaanna nu maddi kumíwid ya babay kiyà?’ nán ku. ");
INSERT INTO isd_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ngamay nán na kiyà nga ‘E APU nga ittu ya sur-surútan ku peyapeyang, ay ibon na ya anghel na nga mamulun kikaw. Sengán naka ki kapannán mu. Mawe ka lugud kadaya pan-pane ku ka íli tu amà ta magsápul ka ka atawán naya bag-bagù. ");
INSERT INTO isd_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ay nu atán masmà mu, ay se maddi da pekíwid kikaw, ay áwan mu wa básul lin oray nagsipata ka kiyà,’ nán na. ");
INSERT INTO isd_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Alalbet tà kídi. Ay kitu giyán tu bubun, ay nagkarárag gà ke APU nga nán ku, ‘APU nga Dios naya apù a Abraham, ipalúbus mu mán ya negákat ku kanedi. ");
INSERT INTO isd_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ay ipakammum kiyà oray kídi ya kaatán ku wa magsisíkád kídi adanni ki bubun ni. Ya babay ya umbet nga magsàdu nga ittu ya pagkunaán ku ka, Uminum ta mán kiya sàdu mu, ");
INSERT INTO isd_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ay se sungbátan nà pe ka, Ara, uminum ka ngala, ay se pagsàdu ku pe daya kámel mu, nán na ay ittu kuma ya pílim, Apu, nga atáwa naya bag-bagu na apù,’ nán ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Ay kitu akun-onì pikam, ay atán nala kurug ge Rebecca ngin. Sittututun ka amutu na nga umbet kitu bubun na magsàdu. Ay nán ku kaggína kane makasàdu, ‘Uminum ta mán,’ nán ku. ");
INSERT INTO isd_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ay nepasekig na nga dágus tu amutu na nga nán na, ‘Ara, uminum. Ay penumán ku pe daya kámel mu,’ nán na. Ay díkod umminum mà. Ay pinenum na pe datu kámel ku. ");
INSERT INTO isd_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ay tútu sinaludsud ku kaggína, ‘Makin-an-anà kikaw?’ nán ku. Ay ‘E Betuel ya ama ku. Ukò ku tu Milca nga atáwa tu Nahor,’ nán na. Díkod nippáy ku ya arítus ki igung na, se datu galáng kadatu labunugán na. ");
INSERT INTO isd_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ay tútu nagukkab bà sè dinay-dáyaw we APU se pinatag ku we APU nga Dios natu apù a Abraham. Aggína ya nangiturung kiyà kanedi, ta senu alà ku ya babbalásang nga pan-pane na kam ka atáwa naya pútut na. ");
INSERT INTO isd_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ay lugud kídi yin, pangaási nu ta kalakkán nu ya apu ku ta ikagi nu wala kiyà nu mayát kayu kiya piyán na. Ay nu maddi kayu, ay kagiyan nu pe kiyà, ta senu ammù ya kuwaan ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ay summungbát pe yin de Laban se Betuel nga nán da, “Pagayatán ne APU yán, ay túya akkan kami makaturáy. ");
INSERT INTO isd_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Atán mà Rebecca kídi yin. Alà nu se kayu la mawe. Aggína ya atawán naya an-anà natu apu mu, ta ittu mà ya nepakammu ne APU,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ay kane magìna natu asassu natu Abraham tu nán da, ay nagukkab kitu lusà nga nagdáyaw ke APU. ");
INSERT INTO isd_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ay díkod nelawannán natu asassu datu iggagaldid nga nàwa ki pirà se balitù, se bádu se na nidde ngámin kitu Rebecca. Niddán da pe tu wagi na nga laláki se tu ina na kadatu nabanor nga iggagaldid. ");
INSERT INTO isd_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ay se la naggan-gánas tu asassu se datu kabbulun na. Nagkakán da se naggiínum da. Ay nagidda da pikam pe. Ay kane pagmakát, ay nán datu asassu kadatu bumalay, “Makipalúbus kami yin, ta magulli kami yin ka giyán tu apu mi,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ay nán natu wagi ne Rebecca se itu ina na, “Magbansi kuma pikam me Rebecca. Se yala mawe kalpasán naya sangapúlu algaw,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ngamay nán tu asassu kaggída, “Pangaási nu ta akkan dà a tàtáan nin. E APU ya nangipalúbus kiya negákat ku kanedi. Palubúsán dà in na magulli kitu apù,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ay tútu nán da, “Karrawán tada nge Rebecca ta pamutuán tada,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ay díkod inayabán da tu Rebecca se da nán kaggína, “Piyám ya kumíwid kídi tolay yi?” nán da. Ay “Ò” nán tu Rebecca nga summungbát. ");
INSERT INTO isd_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ay tútu pinalubúsán da ngin na kumíwid din tu Rebecca nga wagi da, se tu magtar-tarakan kaggína kadatu asassu tu Abraham se datu kabbulun na. ");
INSERT INTO isd_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ay pinarbuwát da tu Rebecca nga nán da, “Wagi,” nán da, “Magan-anà ka kuma ka adu tutu wala. Ay se daya gakagaka mu, ay abákan da kuma ngámin daya kumalínga kaggída,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ay se da la nagrubbuwát. Nagtakay de Rebecca se datu kabbulun na nga babbay kadatu kámel. Ay gumun-gunud da kitu asassu. Ay ummán kiyán tu nakálà natu asassu kitu Rebecca, ay se la nawe yin. ");
INSERT INTO isd_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ay tu Isaac, ay nagulli pe yin na gayát ka Beer-lahai-roi. Mag-agyán ka Negeb. ");
INSERT INTO isd_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Kitu isa nga gídám, ay nawe kitu ir-ir-er nga magdàdàdà. Ay kane maglanga, ay pìlát na ngala datu kámel nga umbet kitu giyán na. ");
INSERT INTO isd_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ay tu Rebecca, ay nasingan na nge Isaac kane maglanga. Ay díkod nagdisáag kitu takay na nga kámel. ");
INSERT INTO isd_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Ay se na sinaludsud kitu asassu, “Inna tu laláki kitúni ir-ir-er nga mameyag kanedi?” nán na. Ay nán natu asassu, “Nge apu ku nga Isaac,” nán na. Ay tútu nagladdung se na tàbán tu murang na. ");
INSERT INTO isd_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ay kane magtammu da, ay kinagi natu asassu ke Isaac tu ngámin na kinuwa na. ");
INSERT INTO isd_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ay díkod nippan natu Isaac tu Rebecca kitu báwi natu ina na kitu kasibbiyág na. Ay nagatáwa da pe yin. Pàgan tu Isaac tu Rebecca. Ay díkod nearingringa pe yin ne Isaac kitu nekatay natu ina na. ");
INSERT INTO isd_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ay kane kuwa, ay nangatáwa manin tu Abraham. Ketura ya ngágan tu inatawán na. ");
INSERT INTO isd_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ay datu pútut na kitu Ketura nga pabeg lalláki, ay tu Zimran, tu Jocsan, tu Medan, tu Midian, tu Isbac, se tu Sua. ");
INSERT INTO isd_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Tu Jocsan tu ama natu Seba se tu Dedan. Ay datu pútut tu Dedan nga lalláki, ay tu Assurim, tu Letusim, se tu Leummim. ");
INSERT INTO isd_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ay datu pútut tu Midian nga lalláki, ay tu Efa, tu Efer, tu Hanoc, tu Abida, se tu Eldaa. Ngámin dayán, ay gakagaka tu Ketura da. ");
INSERT INTO isd_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ngamay nidde tu Abraham kitu Isaac ngámin datu kuw-kuwa na. ");
INSERT INTO isd_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ay kitu kasibbiyág na pikam, ay nginan-nganiyán ne Abraham ngala datu pútupútut na nga lalláki kadatu Hagar se Ketura. Ay se nada pinasibna kitu Isaac. Pinapan nada kitu giyán na padne lattakán kaggída. ");
INSERT INTO isd_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Nadatang tu Abraham ya magatut se pittu púlu se limma dagun ");
INSERT INTO isd_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","ay se la nga natay. Làlakay tutu wala kane matay. ");
INSERT INTO isd_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ay netaman de Isaac se Ismael la pútupútut na kitu liyáng kitu pínát ka Macpela nga atán kitu lusà tu Efron nga Heteo, nga pútut tu Zohar kitun. Atán kitu padne lattakán ka Mamre. ");
INSERT INTO isd_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Ittu tu lusà a ginátang tu Abraham kadatu Heteo nga nangitamnán na kitu atáwa na. Ay ittu pe tun tu nangitamnán da kaggína. ");
INSERT INTO isd_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ay kane áwan tu Abraham min, ay tinag-tagasinnán ne Apu Dios tu Isaac nga pútut na. Nagyán tu Isaac ka íli Beer-lahai-roi. ");
INSERT INTO isd_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ay tu dedi datu pútupútut tu Ismael la pútut tu Abraham kitu Hagar nga iEgipto nga asassu tu Sara. ");
INSERT INTO isd_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ay datu pútut tu Ismael nga lalláki ay tu dedi ya ngag-ngágan da. Naggugúnud da sigun kitu nekeanà da: tu Nebayot nga ittu tu manákam ma pútut tu Ismael. Ay se la tu Kedar se la tu Adbeel, tu Mibsam, ");
INSERT INTO isd_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","tu Misma, tu Duma, se la tu Masa, ");
INSERT INTO isd_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","se la tu Hadad, se la tu Tema, se la tu Jetur, tu Nafis, se la tu Kedema. ");
INSERT INTO isd_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Tu dayán daya ngag-ngágan datu lalláki nga pútupútut tu Ismael. Ay ngámin datu il-ileli da se datu nagbabalayán da, ay nengagánan da pe kadatu ngag-ngágan da. Sangapúlu se duwa nga magtangámalán da, ay sangapúlu se duwa da nga prinsipe. Isa nga prinsipe ki kada tangámalán. ");
INSERT INTO isd_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Dinatang tu Ismael ya magatut se tallu púlu se pittu dagun se la nga natay. ");
INSERT INTO isd_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ay nagyán datu pútupútut tu Ismael manggayát ka Havila panda ka Sur, panidmáng Egipto nga padne Asiria. Nagpadne lattakán da kadatu duddúma nga pútupútut Abraham. ");
INSERT INTO isd_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ay tu Isaac nga pútut tu Abraham, ay tu dedi datu pútupútut na: ");
INSERT INTO isd_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Tu Isaac, ay appát púlu dagun na ngin kane atawán na tu Rebecca nga an-anà tu Betuel nga Arameo nga iPaddan-aram. Tu Rebecca, ay wagi pe natu Laban nga Arameo pe. ");
INSERT INTO isd_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ay gapu ta akkan magan-anà tu Rebecca, ay nekar-karárag tu Isaac ke APU. Ay sinungbátan ne APU tu karárag na, ay díkod nabùsit tu Rebecca ");
INSERT INTO isd_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","ka síngin. Ay akkan makasinád datu síngin kitu unag na. Ummán da ka maggabbu. Ay tútu nán na, “Nu APU ya gapu nedi, ay taanna, tura nád ummán kammin kídi ya kàwaán ku ta?” nán na. Ay tútu nagkarárag ga nagsaludsud ke APU. ");
INSERT INTO isd_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ay nán ne APU kaggína, “Daya atán kiya unag mu, ay aggída ya paggayatán da duwa nga nasiyon. Ay magkagúra dayán na duwa nga nasiyon. Nabílag ya udiyán may manákam. Ay ya manákam, ay aggína ya magsurbi kiya udiyán na,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ay kane oras na nga magan-anà, ay nagan-anà ka síngin. ");
INSERT INTO isd_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Tu nunna nga lummawán, ay dag-daggáng. Ay se nagdùdut pe ngámin baggi na. Díkod nepangágan da ka Esau. ");
INSERT INTO isd_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ay se yala lumawán pe yin tu kasíngin na nga laláki pe. Ay tura na la im-immán tu túmang tu Esau. Díkod nepangágan da ka Jacob. Annam púlu dagun tu Isaac kin kane meanà da. ");
INSERT INTO isd_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ay kane umabay da, ay nagbalin tu Esau ka nalaing nga marangnígay se pàgan na ya sirát. Ngamay tu Jacob, ay nadínang se akkan únáy lumaw-lawán ki balay da. ");
INSERT INTO isd_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Pàgan tu Isaac tu Esau, ta pà-pàgan na daya manigáyan na ki sirát. Ngamay tu Rebecca, ay pàgan na tu Jacob. ");
INSERT INTO isd_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Isa ngalgaw kane atán tu Jacob ba manglappa ka daggáng nga antà, ay inumbet tu Esau nga gayát ka sirát. Ay nabisinán tutu wala. ");
INSERT INTO isd_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ay tútu nán na kitu Jacob, “Iddán nà mán kiya limpa mu wa dag-daggáng ta nabisin nà tutu wala,” nán na. (Díkod nengágan da pe ka Edom tu Esau, ta ya daggáng ki aggúni da ay Edom). ");
INSERT INTO isd_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","May nán tu Jacob, “Iddán taka á nu iddem ngámin kiyà daya pagrabngán mu wa manákam ma an-anà,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ay nán ne Esau, “Ara ngin á. Matay yà tutu wala ngin ki bisin ku. Ay nágan sur-surbi naya karbangán ku ta!” nán na. ");
INSERT INTO isd_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ay tútu nán ne Jacob, “Ay isipatám pikam a nga iddem kurug kiyà ya pagrabngám ma manákam,” nán na. Nagsipata kurug tu Esau, se na nepàbág kitu Jacob tu ngámin na pagrabngán na nga manákam ma an-anà. ");
INSERT INTO isd_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Díkod niddán natu Jacob tu Esau ka sinápay se kitu limpa na. Nangán tu Esau se la nawe kammin kane mabalin. Akkan lugud pinagan-anu tu Esau tu pagrabngán na nga manákam an-anà. ");
INSERT INTO isd_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Nagulát manin kattoni íli Canaan. Nagulát da pe yin kitun, kitu kowad pikam tu Abraham. Ay nawe tu Isaac ka Gerar kitu giyán tu Abimelec nga ári datu iFilistia. ");
INSERT INTO isd_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ay kitu dálen kaggína mawe, ay nagpassingan ne APU kaggína. Ay nán na kaggína, “Akkan ka maw-awe ka Egipto. Magyán ka ngala ki giyán na kagiyan ku kikaw. ");
INSERT INTO isd_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ay mepagíli ka kiyán na íli. Bul-bulunan taka, se tag-tagasinnán taka pe. Ata ipakin-kuwà yán na lusà kikaw se kadaya gakagaka mu. Tungpálan ku tu kari ku nga nesipatà kitu Abraham nga ama mu. ");
INSERT INTO isd_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Paaduwan ku daya gakagaka mu, nga ummán ki kaadu daya bittuwan. Ay ipakin-kuwà kadaya gakagaka mu dedi nga lusà. Ay gapu kadaya gakagaka mu, ay mabindisiyonán ngámin daya nas-nasiyon kídi kalawagán. ");
INSERT INTO isd_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Ata nekurug nà tu Abraham se na kinuwa ngámin tu nepàwà kaggína, ay se ngámin pe datu lin-lintag ku se bil-bílin ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Díkod nagyán nala tu Isaac ka Gerar. ");
INSERT INTO isd_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ay nu saludsúdan datu lalláki kitúni ya panggap kitu atáwa na, ay “Wagi ku yán,” nán na. Ta mansing mangikagi kaggída nga magatáwa da, ta get patayan kanu datu tolay kitúni, se da alà tu Rebecca. Ata napiya tu Rebecca. ");
INSERT INTO isd_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ay kane mabà-bayág da kitúni yin, ay nasingan tu Abimelec nga ári datu iFilistia tu Isaac nga um-umàán na tu Rebecca nga atáwa na. Nasingan nada kane maglamdaw. ");
INSERT INTO isd_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ay tútu pinàrawán tu ári Abimelec tu Isaac, se na nán kaggína, “Magatáwa kayu gáyám! Tura mu nán nga magwagi kayu?” nán na. Ay nán tu Isaac kaggína, “Get patayan dà gapu kaggína nán ku nu kagiyan ku nga magatáwa kami,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ay tútu nán tu Abimelec, “Sinnam a ya kinuwám. Nu tura la atán neallay ki atáwam, di kami mapabásul ngámin, ay ikaw ya gapu na,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ay tútu kinagiyánan natu Abimelec datu tolay kattoni nga nán na, “Papatay ku oray inna nga tolay ya mangwa ka nadakè kadedi nga magatáwa,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ay nagtálun tu Isaac kitúni yin. Ay kitun kam nga dagun, nakagáni ka magatut ya kaadu na kitu nemúla na, ta kinalakkán ne APU. ");
INSERT INTO isd_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Pummiya la nga pummiya tu biyág tu Isaac. Ay díkod nagbalin ka nabànáng tutu wala. ");
INSERT INTO isd_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Adu datu karneru na se báka na, ay se adu bobonan na pe. Ay díkod, asílan datu Filisteo win. ");
INSERT INTO isd_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ay díkod datu Filisteo, ay dinarúnán da datu bubun na kinubkobán datu asassu natu Abraham ma ama na kitu kakowad na. ");
INSERT INTO isd_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ay tútu nán tu Abimelec, “Mawe ka ngin. Magtálaw ka ngin kídi íli mi yin, ta naturáy ka ngin pànang may dakami,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ay díkod nagtálaw tu Isaac kitúni. Nawe kitu tanáp ka Gerar. Nangwa ka báwi na ta magyán nin kitúni. ");
INSERT INTO isd_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ay kinubkobán manin tu Isaac datu bubun nga kinuwaán tu ama na nga Abraham. Ata dinarúnán datu Filisteo da kane matay tu Abraham. Nengagánan na datu bubun kammin kadatu ngag-ngágan da nga nepangágan tu ama na nga Abraham kitu kowad na pikam. ");
INSERT INTO isd_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ngamay kane magkubkob datu bobonan tu Isaac ka bubun kitu tanáp, ay nakasmà da ka gabbuwà. ");
INSERT INTO isd_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ay datu magpas-pastor ka Gerar, ay sináwad dada. Nán da nga, “Kuwa mi ya danum kiddi!” Díkod nengágan tu Isaac tun ka Esek, áta nakisáwad da kaggína. ");
INSERT INTO isd_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Nagkorob da manin ka sabáli nga bubun. Nagriríri da manin. Díkod nengágan tu Isaac tun na bubun ka “Nagsasawdán.” ");
INSERT INTO isd_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ay díkod, nagalit da manin. Se da manin magkubkob ka bubun. Ay áwan kam pe nakiríri yin kaggída. Díkod nengágan na tun ka “Rehobot (naláwa ya sarut na).” Ata nán na, “Niddán nitta nge Apu win ka naláwa nga pagyanán tada. Ay gumánab tada kanedi yin,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ay se la manin nawe ka Beerseba. ");
INSERT INTO isd_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ay nagpassingan ne Apu kaggína kitu gabi natu nedaddatang na. Ay nán ne APU kaggína, “Iyà ya Dios natu Abraham nga ama mu. Akkan ka magansing ta bul-bulunan taka. Bindisiyonán taka se paaduwan ku daya gakagaka mu, gapu kitu Abraham ma bobonan ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Díkod nangwa tu Isaac ka annìdúgán na ka pagbasu na, nga ittu tu pagday-dayáwan na ke Apu. Ay nepasíkád na pe yin tu báwi na. Ay nagkorob manin datu bobonan na ka bubun kitúni. ");
INSERT INTO isd_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ay kane kuwa isa ngalgaw, inumbet tu ári Abimelec kitu giyán tu Isaac. Gayát da ka Gerar. Kabulun na de Ahuzzat nga ittu tu agpamutuán na, se tu Ficol nga apu datu suldádu na. ");
INSERT INTO isd_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ay nán ne Isaac kaggída, “Nágan na ya gákat nu, tura kayu inumbet? Di dà mà a lùsawan? Pinatálaw dà mà ka giyán nu!” ");
INSERT INTO isd_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ay nán da, “Melalásin nala nga bul-bulunan naka nge APU. Ay túya piyán mi ya makiturátu kikaw. Piyán mi nu magkakari tada. ");
INSERT INTO isd_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ikarim kadakami nga akkan dakami gubatan. Ata akkan mika inan-anu. Ay tittu daya napiya pe daya kinuwa mi kikaw. Pinapan mika ngala nga áwan naan-anuwán. Ay kídi yin, ay kinalakkán naka nge APU,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ay díkod nesay-am nada, ay naggiínum da. ");
INSERT INTO isd_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ay kane pagmakát, ay summápa da nga bummángun, ay se da nagsisipata. Ay pinarbuwát tu Isaac da, se da la nawe pe yin. Napiya datu ur-uray da ngin na nagtutúway. ");
INSERT INTO isd_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ay kitun kam nga algaw inumbet datu bobonan natu Isaac nga nán da kaggína, “Atán danum min tu bubun na kinubkobán mi,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ay nengágan na tu bubun ka Siba (sipata ya sarut na). Ay díkod tu íli, ay nengágan da ka Beerseba (bubun na nagsipataán ya sarut na) panda kadedi yin na al-algaw. ");
INSERT INTO isd_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ay tu Esau, kane appát púlu dagun na ngin, ay nangatáwa pe yin. Inatawán na tu Judit, nga an-anà tu Beeri. Ay se na inatawán pe tu Basemat nga an-anà tu Elon. Ay Heteo dayán. ");
INSERT INTO isd_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ay gapu kaggída, ay adu nakariribuán de Isaac se tu Rebecca nga mannákam tu Esau. ");
INSERT INTO isd_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Naglàlakay pànang ngin tu Isaac. Akkan makas-asingan nin kitu kinalakay na. Isa ngalgaw kirrawán tu Isaac tu Esau, nga manákam ma pútut na. Ay nán na, “Ugu,” nán na. “Nágan na tun,” nán tu Esau. ");
INSERT INTO isd_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","“Làlakay yà pànang ngin. Ay akkan ku ammu nu kannungay na ya katay ku win. ");
INSERT INTO isd_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ay tu idi ya pàwa ku kikaw. Alà mu ya bútug mu ta mawe nà pangnígay ki sirát. ");
INSERT INTO isd_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ay se nà ala paglútu kitu namit nga piyán ku tutu wala. Ay nu mabalin nà a mangán, ay bindisiyonán taka ngin. Ittu yán ya piyán ku wa kuwaam ki dì pikam katay,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ay kitu nagamomán tu Isaac se tu Esau, ay atán Rebecca nga nagtal-talagìna. Díkod kitu likud tu Esau nga nawe ka sirát nga mangnígay, ay ");
INSERT INTO isd_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","nán tu Rebecca kitu an-anà na nga Jacob, “Nagìna ku tu nagamomán de Esau se ya ama mu. ");
INSERT INTO isd_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Nán na ama nu ke Esau, ‘Pangnígay nà se nà a paglútu kitu namit nga isida. Ay nu mabalin nà a mangán, ay se taka bindisiyonán ki àráng ne APU ki dì pikam katay,’ nán na. ");
INSERT INTO isd_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ay díkod, kuwaam ngámin daya ipàwà kikaw, ugu. ");
INSERT INTO isd_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Mawe ka mangalà ka duwa nga nalùmag kadatu urbun kalding tada. Ta maglútu wà kitu namit ta isida nga pà-pàgan tutu wala naya ama mu. ");
INSERT INTO isd_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ay se mu la idde ke ama mu, ta senu nu mabalin mangán, ay ikaw ya bindisiyonán na ki di na pikam katay,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ngamay nán tu Jacob kitu Rebecca nga ina na, “Ay dinùdut mà nge Esau, ay iyà ay akkan. ");
INSERT INTO isd_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ay get nu immán nà e ama. Ay di ku ummán ka ug-ogan. Ay di ya agged na lugud agkà ya málà ku nga akkan ya bindisiyon na kiyà,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","May nán tu ina na kaggína, “Iyà ala ya pagdittagán naya ged na kikaw, ugu. Kuwaan mu wala ya ipàwà kikaw. Ara ngin mawe mangalà in kadatu urbun kalding,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ay díkod nawe nangalà, ay se nada idde kitu ina na. Ay linútu natu Rebecca tu pà-pàgan tu Isaac nga isida. ");
INSERT INTO isd_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ay se na inalà tu kapíyán na bádu natu Esau nga manákam an-anà na, nga nearimán kitu balay, se na nga ipabádu kitu Jacob nga udiyán na an-anà na. ");
INSERT INTO isd_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ay datu lálat datu urbun kalding, ay nippáy na kadatu íma na se kitu parte bùlaw na nga áwan dùdut ");
INSERT INTO isd_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ay se na nga idde pe yin kitu Jacob tu linútu na nga misida se itu sinápay nga kinuwa na. ");
INSERT INTO isd_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ay díkod nawe yin kitu giyán tu ama na, ay se na nán, “Ama,” nán na. “Atán nà kiddi,” nán na. “Iinka, ugu?” nán tu Isaac. ");
INSERT INTO isd_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Ay, “E Esau wà ama,” nán pe natu Jacob kitu ama na. “Iyà nge Esau wa manákam ma an-anà mu. Kinuwà in tu nán mu kiyà. Ye idi yin. Mangán ka ngin kiya nígay ku. Ay se nà bindisiyonán nu mabalin ka mangán,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ngamay nán natu Isaac kaggína, “Pinaannám, ugu, ta tura ka nakar-karu?” Ay nán na pe, “Ata nge APU wa Dios mu, ay sinengán nà,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ay díkod nán natu Isaac kitu Jacob, “Umbet ka kídi lugud, ugu, ta senu mìmán taka, ta senu ammu ku nu ikaw kurug ge Esau onu akkan,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Ay díkod umadanni kurug tu Jacob kitu Isaac nga ama na. Inimmán na, ay se na nán, “Alangáag Jacob ya alangáag mu, may ya ímam ay íma Esau,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ay akkan na kurug nalásin, ta tu íma na, ay ummán kurug kitu íma Esau nga dinùdut. Díkod binindisiyonán na. ");
INSERT INTO isd_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Ay nán na, “Ikaw kurug ge Esau nga an-anà ku ta?” nán na. Ay nán tu Jacob, “Ò, iyà,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ay tútu nán tu Isaac kitu Jacob, “Ilbet mu lugud kídi, ugu, ta senu makakkán nà in ki nígay mu, ay se taka la bindisiyonán,” nán na. Díkod nilbet tu Jacob kitu giyán na tu kanan na, ay se la nangán. Pinangilbet na pe ka bási, ay díkod umminum. ");
INSERT INTO isd_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ay se nán natu ama na kaggína, “Umbet ka kídi, ugu, se nà umàán,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ay díkod ummadanni, ay se na umàán tu ama na. Ay naláb kurug natu Isaac tu aláb bádu tu Esau. Díkod binindisiyonán na nga nán na, “Ya aláb nedi an-anà ku ay tagan tálun nga nabindisiyonán ne APU. ");
INSERT INTO isd_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Paudanán kuma ne Dios se padam-aggan na ya lusà para kikaw. Ay paaduwan na kuma ya ápit mu, ta senu adu ammay mu se básim. ");
INSERT INTO isd_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Surbiyán daka kuma daya nas-nasiyon, ay se ikurug daka din daya tolay. Ikaw kuma ya mangituráy kadaya induan mu ki wagi mu, se daya pan-pane na ina mu. Daya magged kikaw, ay magedán da kuma. Ay se mapaanggam kuma daya mamindisiyon kikaw,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ay kitu babbalin tu Isaac nga namindisiyon kitu Jacob, kitu layun natu nepappan na ngin, ay atán pe yin tu Esau nga wagi na. Alalbet ta gayát nangnígay. ");
INSERT INTO isd_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Naglútu pe kitu pàgan tu ama na nga isida, se na pe yin na ilbet kitu giyán na. Ay se na nán kaggína, “Bumángun ka ngin, ama. Mangán nin kídi linútu ku nga nígay ku, ay se nà a bindisiyonán,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ay nán natu Isaac kaggína, “Iinka?” nán na. “Iyà nge Esau. Manákam nga an-anà mu,” nán natu Esau. ");
INSERT INTO isd_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ay tútu nagpil-pilpig tutu wala pànang tu Isaac kitu rungat na. Ay nán na, “Inna lugud tu nangilbet kídi ka linútu wa karni kídi kammin, ay se ka la inumbet? Ay nangán nà pe, ay sè ala binindisiyonán. Ay kurug maparabúrán pe,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ay kane magìna tu Esau tu kinagi natu ama na, ay summángit tutu wala pànang. Ay se na nán, “Ay iyà pe, ama! Masápul la bindisiyonán nà pe!” nán na. ");
INSERT INTO isd_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ngamay nán natu Isaac, “Sinábag nà tu wagi mu, ay inalà na ngin tu bindisiyon nga iddè kuma kikaw. Aggína tu binindisiyonán ku win,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ay nán Esau, “Tu idi yin ya mekàduwa nga nangultit na kiyà! Nunna, ay ya karbangán ku wa manákam ma an-anà. Inalà na ngin! Ay se la manin idi. Inalà na manin pe ya bindisiyon ku. Tu nád da nengágan ka Jacob?” (Ki úni Hebreo, ya kabalikát na ya ngágan Jacob, ay tagge mepáda ki kabalikát naya úni nga ya sarut na, ay marangngultit). Ay se na manin nán, “Ay áwan mu la netagirán na bindisiyon para kiyà?” ");
INSERT INTO isd_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ay nán tu Isaac kaggína, “Ay nágan na pikam ya iddè kikaw, ugu? Ay aggína ya mangituráy kadakayu se ngámin daya pan-pane mu, ay magbalin da ka asassu na. Ay papaadu ku pe ya ápit na nga trígo se úbás, ta senu adu bási na. Ay nágan pikam ya middè kikaw, ugu?” nán na. ");
INSERT INTO isd_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ay nán manin tu Esau, “Sissa agpà bindisiyon mu ama ta? Bindisiyonán nà agpà pe,” nán na. Ay díkod summángit tutu wala pànang manin tu Esau. ");
INSERT INTO isd_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ay tútu nán tu Isaac nga ama na kaggína, “Akkan nadam-ag ya pagmul-muláan mu, ay akkan pe pànang maud-udanán. ");
INSERT INTO isd_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ay magbiyág ka ki ampiláng mu, ay se magbalin ka nga asassu na wagi mu. Ngamay nu sumúkir ka ngin kaggína, ay akkan naka pe meturayán nin,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ay díkod lùsawan tu Esau tu Jacob gapu kitu inagbindisiyon natu ama da kaggína. Ay tu Esau kuma tu mabindisiyonán. Ay nán tu Esau kitu uray na, “Tagay matay ama ngin, se ya agmanakit ku kaggína. Ay kalpasán nayán, ay patayan ku pe ye Jacob bin na wagi ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ngamay nammuwán tu Rebecca datun na lam-lamtan tu Esau nga manákam ma an-anà na. Díkod pinaayabán na tu Jacob, ay se na nán kaggína, “Pal-palanuwan naka Esau nga patayan, ta ittu ya kearing-ringa naya uray na. ");
INSERT INTO isd_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Díkod kuwaan mu ya kagiyan ku kikaw, ugu. Magtálaw ka kídi. Mawe ka ka Haran ka giyán tu wagi ku nga Laban. ");
INSERT INTO isd_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Magyán ka pikam kattoni giyán na, panda ki kippà naya angngalùsaw na wagi mu kikaw. ");
INSERT INTO isd_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ay mippà ya lùsaw na nu maligpanán na ngin tu kinuwám kaggína. Ay se taka la pálà kattoni nu kuwa. Ta lùsawan ku nga maggindán kayu wa matay ki isa nga algaw,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ay se la nán tu Rebecca kitu Isaac, “Awan gánas na biyág ku kídi, ta molaw wà tutu wala kadaya attáwa ne Esau nga Heteo. Ay nu ra la mangatáwa pe ye Jacob kadaya babbay ya Heteo, ay napì-piya la nga matay yà yin,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ay tútu kirrawán tu Isaac tu Jacob, ay se na bindisiyonán se na binílin nga nán na, “Akkan ka mangatáwa kadaya babbay kídi Canaan. ");
INSERT INTO isd_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Díkod mawe ka ka Paddan-aram ka giyán de kakay mu wa Betuel. Ay mangatáwa ka kattoni. Magibabbay ka kadatu annánà ne Laban nga ulitag mu. ");
INSERT INTO isd_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Kalakkán naka nge Dios nga katurayán. Ay se na paganában tutu wala daya pútupútut mu, ta senu magbalin kayu ka adu wa nagbal-baláki nga nas-nasiyon. ");
INSERT INTO isd_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Bindisiyonán naka kuma se daya ngámin na pútupútut mu ka ummán kitu bindisiyon na nidde na kitu kakay mu wa Abraham. Ta senu mepakin-kuwa kuma kikaw ya lusà a pag-agyanán tada kídi bíláng agtangeli, ta nepakin-kuwa ne Dios sin kitu kakay mu wa Abraham,” nán tu Isaac. ");
INSERT INTO isd_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ay tútu pinapan tu Isaac tu Jacob bin. Díkod nawe ka Paddan-aram kitu giyán de Laban nga an-anà tu Betuel nga Arameo. Tu Laban ay wagi tu Rebecca nga ina de Jacob se Esau. ");
INSERT INTO isd_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ay tu Esau, ay nammuwán na nga binindisiyonán tu Isaac tu Jacob se na papannan ka Paddan-aram, ta senu kitúni ya pangatawán na. Nammuwán na tu inangbindisiyon tu Isaac kitu Jacob se itu inangbílin na nga nán na, “Akkan ka mangatáwa kadaya babbay ya iCanaan.” ");
INSERT INTO isd_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Nammuwán na pe nga kinurug natu Jacob tu nán datu ina se ama da se nawe ka Paddan-aram. ");
INSERT INTO isd_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ay kane nammuwán natu Esau nga akkan piyán tu Isaac nga ama da datu iCanaan na babbay, ");
INSERT INTO isd_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ay nawe lugud kadatu babbalásang tu Ismael nga an-anà pe tu Abraham, se la nangatáwa manin. Inatawán na tu Mahalat nga wagi natu Nebayot nga an-anà natu Ismael. ");
INSERT INTO isd_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Nagtálaw tu Jacob ka Beerseba se la nameyag ka Haran. ");
INSERT INTO isd_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ay kane magìbattán kitu isa nga giyán, ay nagapár rala kitúni. Nangalà ala ka batu, nga ittu tu pinagpungán na. Ay se la natúdug gin. ");
INSERT INTO isd_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ay kitun na gabi ay tinagimpán na nga atán kanu mà ya isa nga agdán nga dumatang ka lángit. Ay kitu agdán ay panaba-sábat ta umunè se umúlug datu anghel ne Dios. ");
INSERT INTO isd_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ay e Dios, ay atán kitu ngúdu natu agdán. Ay nán na kanu kitu Jacob, “Iyà e APU nga Dios de Abraham nga kakay mu se Isaac nga ama mu. Ya lusà a pagid-iddaán mu ay iddè kikaw se kadaya gakagaka mu. ");
INSERT INTO isd_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ay daya gakagaka mu, ay umadu da pe tutu wala nga ummán ki kaadu naya tápù ki kalawagán. Ay umarà kayu ki ngámin súli na kalawagán. Ay gapu kikaw se kadaya gakagaka mu ay mabindisiyonán daya ngámin tolay kídi ya kalawagán. ");
INSERT INTO isd_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Akkam kal-kaligpanán nga bul-bulunan taka peyapeyang, ay se tag-tagasinnán taka. Ay pagulliyan taka pe kídi ya giyán. Mepagataatán nà peyapeyang kikaw. Ay tungpálan ku pe datu nekar-karì kikaw,” nán ne Dios. ");
INSERT INTO isd_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ay se la nga nalukág tu Jacob. Ay nán na, “Atán ne Apu kanedi! Akkan ku la am-ammu,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ay tutu nagansing nga nán na, “Nakapap-panansing idi nga giyán. Ittu idi ya pag-agyanán ne Dios, gane. Ittu kid idi, gane, ya lalangkán na mawe ka lángit,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ay díkod nagabi nga bummángun tu Jacob. Ay se na inalà tu nagpunganán na nga batu, se na nepasíkád, ay se na siniyaán ka denu tu otun na, ta nasantuwán kaggína tun na giyán. ");
INSERT INTO isd_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ay nengágan na tu giyán ka Betel (Balay ne Dios ya sarut na). Ay tu nunna nga ngágan natun na íli ay Luz. ");
INSERT INTO isd_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","21","Ay se la nagsipata tu Jacob ke APU nga nán na, “Ikaw kurug ya APU ku se Dios ku, nu bul-bulunan nà kadaya kap-apannán ku se tag-tagasinnán nà, ta senu atán kanan ku se atán pagkawas ku, ay se nu makapagulli yà kammin ke ama nga áwan kaan-anuwán. ");
INSERT INTO isd_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ay kídi nga giyán na nangipasikádán ku kídi nga batu, ay ittu ya pagday-dayáwan kikaw nga Dios. Ay se ngámin daya iddem kiyà ay iddè kammin ya pagkapúlu kikaw,” nán na ke Apu. ");
INSERT INTO isd_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Nagtul-túluy tu Jacob kitu agdal-dalen na. Ay se la nga dumatang kitu isa nga giyán ka padne lattakán. ");
INSERT INTO isd_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ay kane maglang-langa, ay nasingan na ya isa nga bubun ki ir-ir-er. Ay se na nasingan pe ya tallu bagtu wa karneru nga atán magid-idda kitu adanni kitu bubun. Ata datun na karneru ay penumán dada kitu danum kitu bubun. Ay tu takkab natu bubun ay abay pànang nga batu. ");
INSERT INTO isd_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ay nu atán ngámin datu ipas-pastor da nga karneru kitúni, ay isùlin datu magtar-tarakan kadatu karneru tu batu se da penumán datu karneru da, ay se da manin ìkab tu batu kitu bubun. ");
INSERT INTO isd_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Ay nán tu Jacob kadatu magtar-tarakan kadatu karneru, “Wà babalay nu kabbulun?” nán na. Ay “Ka Haran,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ay tútu nán na kaggída, “Am-ammu nu we Laban na apúku ne Nahor?” nán na. Ay “Ò, am-ammu mi,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ay nán na manin kaggída, “Ay nabílag da kam, a,” nán na. “Ò, nabì-bilag da kam. Ye, yán ne Raquel lin na an-anà na nga babay. Ilbet na pe yin daya karneru da!” nán da. Ata atán pe yin tu Raquel la mameyag kitu giyán da. ");
INSERT INTO isd_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ay nán ne Jacob kaggída, “Ay algaw pànang pikam a. Akkan pikam tu oras nga angippan nu kadaya ipas-pastor nu. Penuman nu daya karneru nu se nuda ipastor pikam,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ngamay nán da kaggína, “Akkan mida mapenum panda ki akkan mi akaurnung kaggída ngámin. Ay se mi manin isùlin ya batu wa takkab naya bubun,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Kitu akibàbànán na kaggída, ay atán pe yin tu Raquel nga mangiábug kadatu karneru tu ama na ta aggína lugud tu magpas-pastor. ");
INSERT INTO isd_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ay kane masingan natu Jacob tu Raquel nga an-anà tu Laban na wagi natu ina na, se datu karneru tu Laban, ay nawe na nesùlin tu batu kitu otun tu bubun, ay se na penumán datu karneru. ");
INSERT INTO isd_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Ay se na la ummàán tu Raquel ay se la sumángit pànang. ");
INSERT INTO isd_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ay se na kinagi kitu Raquel nga induan natu ama na. Kinagi na pe nga ina na tu Rebecca. Ay tútu nawe nanagtág tu Raquel la nawe nangikagi kadatu nekagiyán natu Jacob kaggína. ");
INSERT INTO isd_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ay kane magìna tu Laban tu mepanggap kitu Jacob, nga amanakan na kitu wagi na nga babay, ay nawe na sinabat. Ay se na ginàbal la ummàán, ay se na nippan kitu balay na. Ay díkod nebàbànán natu Jacob ya ngámin kitu Laban. ");
INSERT INTO isd_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ay tútu nán tu Laban kaggína, “Kurug nga magama ta kam,” nán na. Ay nepagyán tu Jacob kaggína ka tangabúlán. ");
INSERT INTO isd_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Ay se la nán natu Laban kitu Jacob, “Oray nu amanakan taka, ay piyán taka suwilduwán kiya aggubra mu para kiyà. Piga ya piyán mu nga panangdán ku kikaw ta?” nán na. ");
INSERT INTO isd_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Tu Laban ay atán duwa nga annánà na nga babbay. Tu Lea tu manákam ay se tu Raquel tu udiyán na. ");
INSERT INTO isd_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Napiya datu mata tu Lea ngamay napì-piya kammala datu mata tu Raquel. ");
INSERT INTO isd_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Ay piyán tu Jacob tu Raquel. Ay tutu nán na kitu Laban, “Magsurbi yà kikaw ka pittu dagun, nu ipalúbus mu nga atawán ku we Raquel,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Ay nán tu Laban, “Napì-piya kurug nu ikaw kammin ya mangatáwa ke Raquel, ngam daya sabáli nga lalláki. Magyán ka ngin kanedi,” nán tu Laban kitu Jacob. ");
INSERT INTO isd_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ay díkod nagsurbi kurug tu Jacob kitu Laban ka pittu dagun para kitu Raquel. May ummán ka abibbà ala nga algaw tu pittu dagun gapu kitu amminya na tutu wala kaggína. ");
INSERT INTO isd_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ay se la nán tu Jacob kitu Laban, “Nabalin nin ya pittu dagun. Ay piyán ku nu magatáwa kami se Raquel lin,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ay díkod inayabán natu Laban ngámin datu tolay kitúni, ay se la magsay-am. ");
INSERT INTO isd_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ngamay kane gabi yin, ay tu Lea tu pinappan tu Laban kitu Jacob. Ay díkod nagallay da. ");
INSERT INTO isd_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Ay nekíwid tu Laban tu Zilpa, isa nga asassu na nga babay, kitu Lea ta senu ittu tu magtag-tagasíngan kaggína.) ");
INSERT INTO isd_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ay kane pagmakát tin, ay nasingan tu Jacob nga tu Lea gáyám tu kallay na kitu gabi. Ay tútu nán na kitu Laban, “Taanna, tura ummán kiyán ya kinuwám kiyà? E Raquel mà tu atawán ku kitu inagsurbì kikaw! Ay tura nà kinasaba ngala ta?” nán na. ");
INSERT INTO isd_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Ay tútu nán tu Laban, “Ngamay akkan ummán kiyán ya gangay mi kanedi nga giyán. Akkan mi ipaatáwa ya udiyán nu akkan pikam nangatáwa ya manákam. ");
INSERT INTO isd_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Idaggám mala ya kabalin naya láwas nga aggaattáwa. Ay se ka la magsurbi kiyà ka pittu dagun pikam, ay se ku la nga ipaatáwa kikaw manin ya isa,” nán tu Laban. ");
INSERT INTO isd_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ay ittu tun kurug tu kinuwa natu Jacob. Ay kane malpás tu makaláwas nga say-am, ay nepaatáwa natu Laban tu Raquel kitu Jacob. ");
INSERT INTO isd_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Ay nepekíwid ne Laban tu Bilha nga asassu na nga babay kitu Raquel ka magtag-tagasíngan kaggína.) ");
INSERT INTO isd_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ay díkod inlay tu Jacob tu Raquel pe. Ay ab-abay ya amminya natu Jacob kitu Raquel may kitu Lea. Ay nagsurbi manin tu Jacob kitu Laban ki unag pittu dagun. ");
INSERT INTO isd_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ay kane masingan ne APU nga lùsawan tu Jacob tu Lea, ay aggína tu pinagan-anà na. May tu Raquel, ay akkan na nga pinagan-anà. ");
INSERT INTO isd_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Ay nabùsit tu Lea se la nagan-anà ka laláki. Ay nengágan na ka Ruben. Ata nán na nga, “Nasingan ne Apu ya pannakit ku. Kídi yin, ay piyán nà in ya atáwà,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ay nabùsit manin tu Lea se nagan-anà manin laláki. Ay nán na, “Niddán nà manin ne APU ka isa nga laláki, ta nasingan na nga akkan nà pàgan ya atáwà,” nán na. Ay túya gapu na nga nepangágan naya an-anà ka Simeon. ");
INSERT INTO isd_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ay nabùsit manin se la nagan-anà ka laláki manin. Ay nán na, “Kídi yin ay piyán nà in ya atáwà, ta nagan-anà à in ka tallu wa lalláki,” nán na. Ay tútu nepangágan na tu an-anà na ka Levi. ");
INSERT INTO isd_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ay nabùsit manin se la manin nagan-anà ka laláki. Ay nán na manin, “Kídi ay dayáwan ku we Apu,” nán na. Ay díkod nepangágan na tu an-anà ka Juda. Ay panda ke Juda, ay nakusap nagan-anà e Lea. ");
INSERT INTO isd_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ay díkod gapu ta áwan an-anà tu Raquel, ay magimli kitu wagi na nga Lea. Ay tútu nán na kitu Jacob, “Iddán nà ka annánà! Nu akkan, ay matay yà!” nán na. ");
INSERT INTO isd_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Ay tútu nakarungat tu Jacob kitu Raquel. Ay nán na, “Wayya la nga iyà ya Dios, nga akkan mamagan-anà kikaw!” nán na. ");
INSERT INTO isd_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ay tútu nán natu Raquel kitu Jacob, “Atán ne Bilha kiyán nga magtar-tarakan kiyà. Allayam ta senu makapagan-anà para kiyà. Ta senu atán an-anà ku pe gapu kaggína,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Díkod nidde na kurug tu Bilha nga maragtarakan kaggína nga atawán tu Jacob. Ay inlay natu Jacob tu Bilha. ");
INSERT INTO isd_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ay díkod nabùsit se la nagan-anà ka laláki. ");
INSERT INTO isd_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ay nán tu Raquel, “Nidde ne Dios kiyà ya pagrabngán ku. Ginìna na ya karárag ku, ay se nà a niddán ka an-anà ku nga laláki,” nán na. Ay díkod nepangágan na tu an-anà ka Dan. ");
INSERT INTO isd_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Nabùsit manin tu Bilha nga magtar-tarakan kitu Raquel. Ay nagan-anà manin ka laláki. ");
INSERT INTO isd_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ay nán tu Raquel, “Makipásipásil là kiya wagi ku, ay atán nà in na mangábà,” nán na. Ay díkod nepangágan na tu an-anà ka Naftali. ");
INSERT INTO isd_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ay kane nammuwán tu Lea nga akkan makapagan-anà in, ay nepaatáwa na kitu Jacob tu Zilpa nga magtar-tarakan kaggína. ");
INSERT INTO isd_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ay nabùsit tu Zilpa ay se la pe magan-anà ka laláki. ");
INSERT INTO isd_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Ay nán Lea, “Nagásat tà,” nán na. Díkod nepangágan na tu an-anà ka Gad. ");
INSERT INTO isd_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Nagan-anà manin tu Zilpa nga asassu ne Lea ka laláki. ");
INSERT INTO isd_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ay nán tu Lea, “Magang-anggam mà. Ata nán daya babbay nga nagásat tà,” nán na. Díkod nepangágan na tu an-anà ka Aser. ");
INSERT INTO isd_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ay kitu aggagáni yin ay nawe tu Ruben kitu tal-tálun. Ay nakasmà ka adu wa mandrigoras, ay se na nilbet kitu Lea nga ina na. Ay se la nán tu Raquel kitu Lea, “Iddán nà mán agpà kadatu mandrigoras nga nilbet natu an-anà mu,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","May nán tu Lea kaggína, “Pinagasissaán mu win ya atáwa ta. Ay kídi yin ay piyán mu manin alà daya mandrigoras na an-anà ku!” nán na. Ay tútu nán tu Raquel, “Nu iddán nà kadaya mandrigoras na an-anà mu, ay peallayan ku we Jacob kikaw daddán gabi,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ay díkod kane umbet tu Jacob ba gayát ka tálun, ay sinabat tu Lea nga nán na, “Masápul la magidda ka ka balay daddán gabi, ta inabángan taka ka mandrigoras nga inalakkán na an-anà ku,” nán na. Díkod inlay na kitun na gabi. ");
INSERT INTO isd_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ay ginìna ne Dios tu Lea. Ay nabùsit se nagan-anà ka laláki. Ittu tun tu mekalimma nga an-anà da se tu Jacob. ");
INSERT INTO isd_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ay nán tu Lea, “Tinangdánan nà e Dios ta niddè tu magtar-tarakan kiyà kitu atáwà,” nán na. Díkod nepangágan na tu an-anà ka Isacar. ");
INSERT INTO isd_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Ay nabùsit manin tu Lea se manin nagan-anà ka laláki. Tu idi ya mekannam nga an-anà da se tu Jacob. ");
INSERT INTO isd_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ay nán na manin, “Arig niddán nà manin ne Dios ka tádug ku. Kídi yin kobungan nà ya atáwà in, ta annam da annánà mi yin,” nán na. Ay díkod nepangágan na tu an-anà na ka Zebulun. ");
INSERT INTO isd_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ay se la nagan-anà ka isa nga babay. Nepangágan na ka Dina. ");
INSERT INTO isd_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ay se la nga kinalakkán ne Dios nge Raquel. Ginìna na tu karárag na, ay se na pagan-anaan. ");
INSERT INTO isd_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Nabùsit se la nagan-anà ka laláki. Ay nán na, “Nippà ne Dios sin ya keap-appattán ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ay díkod nepangágan na tu an-anà na ka Jose. Ay nán na manin, “Iddán nà kuma ne Dios ka isa pikam ma laláki,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Ay kane meanà natu Raquel tu Jose, ay nán natu Jacob kitu Laban, “Palubúsán nà a mawe yin ka babalay mi,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","“Alà ku daya attáwà, ta neubra ku da mà kikaw, ay alà ku pe daya annánà ku. Palubúsám da ngámin, ta ammum mà nu wà ummán natu inaggubrà para kikaw,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ay nán pe tu Laban, “Atán pe ya ikagì kikaw. Akkan nà agpà panáwan. Nammuwán ku ki isa nga mamadtu nga kinalakkán nà e Dios gapu kikaw. ");
INSERT INTO isd_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ikagim mala ya piyám ma suwildu, ay ittu yán ya panuwildù kikaw,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ay nán tu Jacob, “Ammum mà kampela ngin nin nu wa ummán naya inagsurbì kikaw. Ummadu mà daya bákam gapu kiyà. ");
INSERT INTO isd_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ata kitu nilalbet ku, ay bittè da pikam. Ay kiddi yin ay umadu da tutu wala ngin. Ay kinalakkán naka nge Apu kadaya ngámin na kinuw-kuwà. Ay paanna ngà pe yin? Nungay na pe ya anningan ku kampela ngin nin kadaya akkobung ku?” nán na. ");
INSERT INTO isd_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Ay nán manin tu Laban, “Nágan na lugud ya piyám ma iddè kikaw?” nán na. Ay nán tu Jacob, “Nu ya suwildù, ay akkan nà magadang. May atán ya palánù nu mayát ka. Itúluy ku wa tarànan daya áyam mu. ");
INSERT INTO isd_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","May nu piyám, ay mawe yà sinnan daya karnerum se daya kalding mu. Ay ngámin daya labáng se buritàtà nga karneru se kalding se daya ngísit ta urbun karnerum, ay alà kuda ngámin ta ittu dayán daya tangdán ku. ");
INSERT INTO isd_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ay díkod nu umbet mu sinnan daya inalà ku wa tangdán ku, ay se nu atán masingam ma akkan labáng onu buritàtà a karneru se kalding onu ngísit ta urbun karneru, ay ‘nagtákaw,’ nán mu kiyà,” na tu Jacob. ");
INSERT INTO isd_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Ay nán natu Laban, “Napiya yán. Ittu kurug ya kuwaan ta,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ngamay kitun na algaw, ay nesibnaán tu Laban datu toru wa kalding nga gárit se labáng, se datu puunán na kalding nga labáng se datu buritàtà, se datu ngámin atán pusà se datu ngísit ta urbun karneru, ay se na ipatarakan kadatu annánà na. ");
INSERT INTO isd_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ay se nada nga netálaw kitu adayyu. Tallu walgaw ta dalenan ya kadayyu da kitu Jacob. Ay se la tinarànán tu Jacob datu nabansi kadatu karneru se kalding natu Laban. ");
INSERT INTO isd_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Ay ya kinuwa tu Jacob ay nangalà ka nangalug ga pasanga alamo, almendras se kastano nga káyu. Ay se na kulkul-etán da, ta senu masingan tu pusà kitu pasanga. ");
INSERT INTO isd_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ay se na ippáy datun na pasanga kitu panin àráng datu karneru se kalding nu uminum da kitu agginumán da. Ata ittu tu agdadákay datu animál nu mawe da uminum. ");
INSERT INTO isd_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ay díkod nu magdadákay da, ay umàráng da kadatu pasanga. Ay díkod labáng onu gárit onu buritàtà daya urbun datun na karneru se kalding. ");
INSERT INTO isd_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Ay díkod neamung natu Jacob datu urbun kadatu kuwa na. Ay se na manin pe nga nesibna datu babbay ya karneru se kalding kadatu toru. Ay se na nepadakay datu babbay kadatu ngísit toru se datu gárit. Díkod ummadu datu karneru se kalding natu Jacob. Naggayát da kam kadatu karneru se kalding natu Laban. ");
INSERT INTO isd_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ay nu magdakay datu nabílag kadatu karneru se kalding, ay ipasíkád tu Jacob tu pasanga kitu lútung da, kitu panin àráng da ta senu magdakay da kitu giyán datu pasanga. ");
INSERT INTO isd_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ngamay nu datu nakapsut datu magdadákay, ay akkan na nga ippáy datu pas-pasanga. Díkod datu nakapsut, ay kuwa tu Laban da, ay datu nabílag ay kuwa tu Jacob da. ");
INSERT INTO isd_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Díkod gapu kitun na kinuwa na, ay bumànáng tutu wala tu Jacob. Adu tutu wala datu karneru se kalding na, se kámel na se asnu na. Ay adu pe datu asassu na nga lalláki se babbay. ");
INSERT INTO isd_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ay nagìna natu Jacob nga nán datu pútupútut tu Laban nga lalláki, “Nálà ne Jacob ngámin na kuw-kuwa ne ama. Ay ngámin na bànáng na, ay gayát da ngámin kiya kuw-kuwa ama,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ay nàmud pe tu Jacob nga tare yin tu uray tu Laban kaggína. Akkan nin na ummán kitun. ");
INSERT INTO isd_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ay se la nán ne APU kitu Jacob, “Magulli ka ngin kitu íli natu ama mu, se kitu giyán datu pan-panem. Abul-bulunan taka,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Díkod pinàrawán natu Jacob tu Raquel se tu Lea kitu giyán na. Atán kitu ir-ir-er nga mangipastor kadatu karneru na. ");
INSERT INTO isd_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ay nán na kaggída, “Nàmud ku nga naulis sin ya amminya naya ama nu kiyà. Akkan nin na ummán kitun. Ngamay ya Dios natu ama ku, ay bul-bulunan nà peyang. ");
INSERT INTO isd_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ammu nu mà nga nippáy ku ya kabailán ku nga nagsurbi kiya ama nu. ");
INSERT INTO isd_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","May kul-kultit nà mà. Naminsangapúlu na nga inulis ya suwildù. Yán nala ya annágid na kiyà ya akkan na màwa, áta akkan ipalúbus ne Dios. ");
INSERT INTO isd_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Sesengán nà e Dios. Túya nu nán na nga datu nasul-sulpangngán datu bátug tangdán ku, ay magan-anà daya ngámin kalding ka nasul-sulpangngán. Ay nu nán na nga datu labáng datu tangdán ku, ay magan-anà daya kalding ka labáng. ");
INSERT INTO isd_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ay inalà ne Dios daya áyam naya ama nu, se nada nga iddanán kiyà. ");
INSERT INTO isd_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Ay kiya tiyampu nga agpadakay daya babbay nga kalding, ay uwad tagenap ku. Naglangngò à kanu mà, ay se ku la nasingan nga datu ngámin na toru nga manakay kaggída, ay gárit, labáng se buritàtà da. ");
INSERT INTO isd_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ay se yala nga nán naya anghel ne Apu kiyà kitu tagenap ku, ‘Jacob,’ nán na. ‘Inna tun nán ku!’ ");
INSERT INTO isd_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ay se na nán ‘Sinnam kod. Ngámin datu toru nga manakay kadatu kalding, ay labáng se nasul-sulpangngán. Ata sikkaammu wà kiya kuk-kuwaan ne Laban kikaw. ");
INSERT INTO isd_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Iyà ya Dios ka Betel, kitu giyán na nangipasikádán mu ka batu se mu siniyaán ka denu, ay se ka la nga nagkari kiyà. Panáwam idi nga íli kiddi yin, ay se ka magulli lugud din kitu íli nga neanàán mu,’ nán natu anghel,” nán natu Jacob kadatu attáwa na. ");
INSERT INTO isd_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ay tútu nán de Raquel se Lea kaggína, “Awan mà nengáni ama kadakami kadaya kuw-kuwa na. ");
INSERT INTO isd_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ummán nakami ka akkan na nga pútut. Bíláng neláku nakami yin, ay se na pe yin na immin na ginastu tu báyad kadakami. ");
INSERT INTO isd_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ay ngámin datu inalakkán ne Dios nga kuw-kuwa ne ama nga nidde na kikaw, ay kuwa mi mà kammala ngin nin se daya annánà mi. Ay díkod, nu nágan naya ipàwa ne Dios kikaw, ay masápul la ittu ya kuwaan mu,” nán da kitu Jacob. ");
INSERT INTO isd_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Díkod nagrubbuwát tin de Jacob. Netakay na datu annánà na se datu attáwa na kadatu kámel. ");
INSERT INTO isd_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Ay se na pe ya iturung datu animál na, se datu ngámin na nàluwán na, se ngámin datu animál na nga inalà na ka Paddan-aram. Ay se da la nga nagrubbuwát ta mawe kitu giyán tu Isaac nga ama na ka íli Canaan. ");
INSERT INTO isd_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ay tu Laban, ay nawe nga mamúkis kadatu karneru na. Ay díkod nawe tinákaw tu Raquel datu sinan diy-diyos natu ama na. ");
INSERT INTO isd_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Sinistemaán natu Jacob tu Laban na Arameo. Ata akkan na nepak-pakammu tu palánu na nga magtálaw. ");
INSERT INTO isd_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Inalà na ngámin datu kuw-kuwa na. Dummalákit ka wángag Eufrates se la nga nameyag ka Gilead nga ban-bantay. ");
INSERT INTO isd_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ay se dala kagiyan kitu Laban nga nagbarráw tu Jacob kitu mekàlu wa algaw nanggayát kitu likud da. ");
INSERT INTO isd_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Tútu impal nada. Inayabán na datu pan-pane na se da inumpal. Ay nasingan dada kitu mekapittu nga algaw kitu ban-bantay kitu Gilead. ");
INSERT INTO isd_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ngamay nagpatagenap pe Dios kitu Laban kitu gabi. Ay nán ne Dios kitu tagenap na, “Sin-sinnam ta áwan mu nga kag-kagiyan nga makaulis ki palánu ne Jacob,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Ay sinìmát natu Laban tu Jacob. Nagbáwi de Jacob kitu ban-bantay. Ay tu Laban se datu kabbulun na, ay nagkampu da kitu panidmáng kade Jacob. ");
INSERT INTO isd_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ay nán tu Laban kitu Jacob, “Taanna, tura nà linibátan ta? Nibraw mu daya annánà nga ummán da ka bálud ki gubát. ");
INSERT INTO isd_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Tura kayu naglíbát ta? Di takayu kuma nga pinarbuwát ka napiya. Naggan-gánas tada kuma pikam. Nagkansiyon tada kuma se nagtutukár tada kuma pikam. ");
INSERT INTO isd_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ay gapu ki kinuwa mu, ay akkan ku ngámin naparbuwát daya apúku ku se daya pútut ku. Akkan kuda naummàán. Sabáli ya inangwa mu. ");
INSERT INTO isd_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Annung taka kuma nga sagídan. Ngamay ya Dios naya ama mu, ay inamomanán nà kitu gabi nga nán na, ‘Sin-sinnam ta áwan mu wa kag-kagiyan na makaulis ki palánu ne Jacob,’ nán na. ");
INSERT INTO isd_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Nagtálaw ka ta matalekág ka pànang kiya íli nu, may tura mu ngámin inalà datu sinan diy-diyos ku?” nán na. ");
INSERT INTO isd_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Ay nán tu Jacob kitu Laban, “Nagbarráw wà a, ta malídug gà. Ata nán ku nu pilítan mu alà kammin daya pútut mu. ");
INSERT INTO isd_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ay nu mepanggap kadaya sinan diy-diyos mu, ay matay ya pakasmàán mu. Ki àráng dedi ngámin na pan-pane tada, ay itùgud mu la ya atán kiyà nga kuwám ta alà mu wala,” nán na. Ngamay akkan am-ammu tu Jacob nga sinákaw tu Raquel datu sinan diy-diyos. ");
INSERT INTO isd_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ay díkod nawe tu Laban kitu báwi tu Jacob, ay se la nga kitu báwi tu Lea, se la kitu báwi datu duwa nga bobonan da nga babbay. Ngamay áwan na nga nasmà. Lummawán se la nawe kitu báwi tu Raquel. ");
INSERT INTO isd_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ay e Raquel, inalà na datu sinan diy-diyos se nada nga nippáy kitu silya natu kámel na, ay se na nga nagtugawán. Siningan ne Laban ngámin tu báwi ngamay áwan na nga nasmà kitúni. ");
INSERT INTO isd_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ay nán tu Raquel kitu ama na, “Akkan nà lùsawan ama ta akkan nà makapagsíkád ta magbúlán nà,” nán na. Ay díkod nagsápul lala nge Laban, ngamay áwan na nga nasmà kadatu sinan diy-diyos. ");
INSERT INTO isd_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ay tútu nalùsaw tu Jacob kitu Laban, ay tútu nakisuway kaggína ngin. Ay nán na, “Nágan naya kinuwà a nadakè ta? Nágan naya nagbasúlán ku ta, ta tura dà tutu wala nga impal? ");
INSERT INTO isd_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Nasingan nu ngámin nin daya kuw-kuwa ku, ay wàna pe ya nasmà nu nga kuw-kuwa nu? Ara, ippáy nu wala kiddi ki pagmar-marngán daya pan-pane ta, ta senu aggída ya mangikagi nu inna ya atán básul kadàta nga duwa. ");
INSERT INTO isd_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ki unag na duwa púlu dagun na nagpas-pastor ku para kikaw, ay áwan nala kadatu karneru se kalding mu ya nabùsit ta di nagan-anà. Ay áwan ku la pe nga inagparti kadatu torum. ");
INSERT INTO isd_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ay datu kinnán ulolag, ay binayádan kuda mà pe kikaw. Akkan ku da la nga linam-át kikaw. Ay ngámin datu natákaw, ay binayádan ku da ngámin pe. Oray algaw onu gabi tu nekatákaw da. ");
INSERT INTO isd_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ay pasuráy bittì ala tu tudúgan ku kitu nagpas-pastor ku. Nu algaw, ay netur-turad ku wala tu takit tu sínág. Ay nu gabi pe, ay netur-turad ku la pe tu siyam. ");
INSERT INTO isd_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Sangapúlu se appát dagun ku nga nagsurbi kikaw gapu kadaya duwa nga annánà mu, se annam dagun gapu kadaya áyam mu. Ay kadayán na dagudagun, ay naminsangapúlu mu wa inulis tu suwildù. ");
INSERT INTO isd_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ay nu akkan nala nga gapu ke Dios nga Dios natu kakay ku nga Abraham se Dios tu ama ku nga Isaac, ay mabalin na pinapan dà ala nga áwan netúgutúgut. Ngamay nasingan ne Dios datu rig-rígát ku, se nu mapaanna tu inaggubrà ki biyáng mu. Ay tútu kinagiyánan naka kitu gabi,” nán tu Jacob. ");
INSERT INTO isd_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Ay tútu summungbát tu Laban na nán na kitu Jacob, “Kurug ga daya babbay ay pútut kuda, se atán pe kalintaggán ku kadaya annánà da. Ay daya animál pe, ay kuw-kuwa kuda ngámin pe. Ngámin dayán ay kuw-kuwa kuda ngámin. Ngamay áwan ku wa màwa ngin. Akkan ku wayya nga magáput pe daya pútut ku se daya apúku ku. ");
INSERT INTO isd_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Túya masápul la magturátu ta lugud dala ngin na magkatugángan nga magkappiya ta ngin. Ay se ta nga mangwa ka tagematun ta.” ");
INSERT INTO isd_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ay díkod, nangalà tu Jacob ka abay batu se na nga ipasíkád. ");
INSERT INTO isd_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ay se na nga nán kadatu pan-pane na, “Ara, maggalà kayu ka batu,” nán na. Ay díkod naggalà da ka batu se da nga binuntun. Ay se da la nga nagkakán ngámin kitu bíkat natu binuntun na batu. ");
INSERT INTO isd_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Ay nepangágan tu Laban tun ka Jegar-Sahaduta ki úni da nga Arameo. Ngamay nepangágan tu Jacob ka Galeed kiya úni nga Hebreo. ");
INSERT INTO isd_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Ay nán tu Laban, “Idi nga binuntun na batu ya mangipakammu kadàta nga duwa kiya nagkappiya ta,” nán na. Ay tútu nepangágan na pe yin tun na giyán ka Galeed. ");
INSERT INTO isd_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ay nán pikam tu Laban, “E Dios kuma ya magtag-tagasíngan kadàta nu magadayyu ta ngin,” nán na. Ay díkod, nepangágan na pe tu binuntun na batu ka Mizpa. ");
INSERT INTO isd_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ay nán manin tu Laban, “Nu ra mu la nga pagraw-rawtán daya pútut ku, onu mangatáwa ka manin ka sabáli, oray akkan ku am-ammu, ay lam-lamtan mu wa e Dios ya magsisíngan kadàta,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ay se la nga nán tu Laban kitu Jacob, “Sinnam kod idi nga binuntun na batu se idi nga batu wa nepasíkád kídi nga nagbàtán ta nga duwa. ");
INSERT INTO isd_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Dedi ay tagematun da nga akkan nà lumíwán kídi nga mawe kiya giyán mu nga makigubát kikaw. Ay akkan ka pe nga umbet kanedi giyán ku wi nga makigubát kiyà. ");
INSERT INTO isd_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ay E Dios nga Dios tu Abraham se tu Nahor se datu manákam da ya makakaammu kadàta nga duwa,” nán na. Díkod nagsipata tu Jacob ke Dios nga day-dayáwan tu Isaac nga ama na. ");
INSERT INTO isd_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ay se la nga nagbasu tu Jacob ke Dios kitun na bantay, ay se na nga inayabán datu pan-pane na, se da nga nagkakán. Ay kane mabalin da mangán, ay nagidda da pikam kitúni nga bantay. ");
INSERT INTO isd_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ay kitu láwa natun ay gummabi tu Laban. Nakiparbuwát kadatu pútut na se datu apúku na. Inummàán nada ngámin se nada nga nekarárag, ay se la nawe nga nagulli yin ka babalay da. ");
INSERT INTO isd_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ay díkod nagtul-túluy tu Jacob kitu kapannán na. Ay uwad da nga anghel ne Dios nga summabat kaggína. ");
INSERT INTO isd_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ay kane masingan natu Jacob da, ay nán na, “Ittu idi 'kaw ya kampu ne Dios!” nán na. Ay díkod, nepangágan na tun na giyán ka Mahanaim. ");
INSERT INTO isd_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ay nangibon tu Jacob kadatu tolay na nga maginunna nga mawe kitu giyán tu Esau nga wagi na nga atán ka íli Seir ka Edom. ");
INSERT INTO isd_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Binílin nada nga nán na, “Tu idi ya kagiyan nu kitu wagi ku nga Esau: ‘Apu, pekagi ne Jacob nga asassu mu nga panda kídi, ay mepag-agyán nala ka balay de Laban. May piyán na ngin, ápu, ya magulli kanedi. ");
INSERT INTO isd_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Atán da báka na, se asnu na, se kalding se karneru na. Ay atán da pe bobonan na nga lalláki se babbay. Nebon nakami, ta piyán na nga pekagi kikaw, ápu, nga piyán na ya makikappiya kikaw kanu,’ nán nu,” nán tu Jacob. ");
INSERT INTO isd_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Díkod nawe datu nebon. Ay kane magulli da, ay nán da kitu Jacob, “Naggayát kami ka giyán Esau nga wagi mu. Ay umbet nga sumabat kikaw. Ay atán da kabbulun na nga appát gatut nga tolay na,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ay nagansing pànang se nariribù tu Jacob. Ay díkod pinagkaduwa na datu tolay na, ay se datu kalding se karneru se datu báka na se datu kámel na. ");
INSERT INTO isd_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ata nán na, “Nu umbet te Esau se na masingan ya isa nga bagtu, ay se nada nga rapúnan, ay atán pikam daya isa nga bagtu nga annung da ya magtálaw,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ay se la nagkarárag tu Jacob ba nán na, “O Dios nga Dios datu kakay ku nga Abraham se tu ama ku nga Isaac. O APU, ikaw ya nangagi kiyà nga magulli yà kiya ilì kampela ngin na giyán pe daya pan-panè. Ay kinagim pe nga ikaw ya magtagasíngan kiyà, ta senu napiya ya kapàyanán ku. ");
INSERT INTO isd_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Akkan nà a mekari kiya áwan kapal-palíyán na amminya mu, se ya kinamárum ma nepassingan mu kiyà nga asassum mala. Ata kitu inagbàláng ku kitun kídi wángag Jordan, ay tittu ya tàdukud ya ag-agtù. Ngamay kídi yin ay duwa ngarkuwátan nà in. ");
INSERT INTO isd_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Pangaásim ta igdù nà kitu wagi ku nga Esau. Magansing ngà kaggína, ta get nu patayan nakami ngámin se daya annánà se daya ina da. ");
INSERT INTO isd_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ngamay kinagim mà kiyà nga napiya ya pagbalinán ku. Ay se paaduwan mu daya gakagaka ku, nga ummán ki kaadu daya ginat ki bebay, nga áwan makabíláng kaggída,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Nagidda da pikam kattoni. Ay kane din algaw, ay nagurnung ka panaruanggam na kitu wagi na kadatu noray atán kaggína ngin. ");
INSERT INTO isd_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Nangalà ka duwa gatut ta kalding nga babbay se duwa púlu wa toru, se duwa gatut ta babbay ya karneru se duwa púlu wa toru, ");
INSERT INTO isd_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","se tallu púlu wa kámel la magpasúsu se datu urbun da, appát púlu puunán nga báka se sangapúlu wa toru, duwa púlu wa puunán na asnu se sangapúlu toru. ");
INSERT INTO isd_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Pinagbabagtu na dedi nga animál se na ikípát kadatu asassu na tu kada baláki animal. Ay se na nán kaggída, “Ara, munna kayu. Ipurtut nuda nga magsasarunu may maggaadayyu kayu,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ay binílin na tu naginunna, “Ay nu sabtan naka nge Esau nga wagi ku, ay se na salúdsúdan kikaw nga, ‘Inna ya apu mu, ay se kawà naya kapannán mu, se makin-kuwa kadedi ya ipur-purtut mu?’ nu nán na, ");
INSERT INTO isd_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ay nán mu kaggína, ‘Kuwa Jacob nga wagi mu ngámin dedi. Ay idde na ngámin dedi kikaw, ápu. Atán na sumar-sarunu kadakami,’ nán nu,” nán tu Jacob. ");
INSERT INTO isd_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Binílin na pe datu mekàduwa se tu mekàlu se aggída ngámin nga nán na, “Ittu pe yán ya kagiyan nu ke Esau nu mesabat nu. ");
INSERT INTO isd_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ay nán nu pe nga, ‘Ay atán na sumar-sarunu kadakami ye Jacob nga wagi mu,’ nán nu,” nán tu Jacob kaggída. Ata nán na ki uray na nga, “Anannayan ku ya wagì kadedi nga panaruanggam ku nga ipainunnà. Ay se kami la magsingan nin, ay get pakawanan nà kiyán nin,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Ay díkod pinaginunna na datu asassu na nga pinamulun na kadatun na panaruanggam na kitu Esau. May nagidda pikam kitu kampu da kitun na gabi. ");
INSERT INTO isd_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Kitun kam ma gabi, ay bumángun tu Jacob se na nga alà datu duwa nga attáwa na, se datu duwa nga magtar-tarakan kadatu attáwa na, se datu sangapúlu se isa nga annánà na, ay se da nga magbàláng ngin kitu wángag Jabbok. ");
INSERT INTO isd_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ay kane makapagbàláng ngin datu akkobung na, ay nepibta na pe ngámin nin datu kuw-kuwa na. ");
INSERT INTO isd_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ay díkod sissa ngin tu Jacob kitu dammáng. Ay uwad tolay ya inumbet nakigbu kaggína ka panda kitu danni láwa. ");
INSERT INTO isd_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","May kane akkan maábà natu tolay tu Jacob, ay sinúlung na tu apel natu Jacob. Ay tútu nalipdu tu Jacob. ");
INSERT INTO isd_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ay se la nán tu laláki, “Mawe yà in ta algaw win,” nán na. Ngamay nán tu Jacob, “Akkan taka papannan nu akkan na pikam bindisiyonán,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ay nán natu tolay kaggína, “Inna ngágan mu ta?” nán na. Ay, “Jacob,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ay nán tu tolay, “Akkan Jacob bin ya ngágan mu, ta panda kídi yin ay Israel ya ngágan mu win. Ata nakiparáng ka ke Dios se kadaya tolay, ay nangábà ka,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ay tútu sinaludsud tu Jacob ya ngágan natu laláki, nga nán na, “Ay ikaw, inna ya ngágan mu?” nán na. Ngamay nán natu tolay, “Taanna tura mu piyán ammuwán ya ngágan ku?” nán na. Ay se na nga bindisiyonán tu Jacob. ");
INSERT INTO isd_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ay díkod nepangágan tu Jacob tun na giyán ka Peniel. Ata nán na, “Nasingan ku ya murang ne Dios may akkan nà a natay,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ay linumtà tu mata ngin kaggína nga nagtálaw ka Peniel nga nagtag-tagkilay gapu kitu lappu na nga nalipdu. ");
INSERT INTO isd_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ay díkod panda kadedi yin na al-algaw, ay áwan kadaya gakagaka tu Jacob ya mangán ka piskal apel animál, áta ittu tun tu nasúlung kitu Jacob. ");
INSERT INTO isd_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Ay kane maglanga tu Jacob, ay nasingan na nga atán nin tu Esau nga umbet. Kabulun na datu appát gatut ta tolay na. Ay díkod inuwár na datu annánà na kitu Lea se tu Raquel se datu duwa nga bobonan da nga babbay. ");
INSERT INTO isd_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ay pinaginunna na datu duwa nga bobonan da nga babbay se datu annánà da. Ay se yala tu Lea se datu annánà na. Nepalodi na tu Raquel se tu Jose. ");
INSERT INTO isd_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ay aggína tu naginunna kaggída ngámin. Ay kane umad-adanni kitu wagi na, ay nagukkab ba naminpittu kitu lusà. ");
INSERT INTO isd_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ngamay nanagtág ga summabat te Esau kaggína, se na nga ginàbal, se na ummàán. Ay se da summángit ta duwa. ");
INSERT INTO isd_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ay kane masingan natu Esau datu babbay se datu annánà, ay nán na, “Indedi kabbulun mu?” nán na. Ay nán tu Jacob, “Tu dedi daya pútupútut ku nga nidde ne Dios kiyà gapu ki kinamáru na,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ay se la umadanni pe datu bobonan da nga babbay se datu annánà da. Ay nagukkab da ngámin kitu lusà pe. ");
INSERT INTO isd_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ay ummán pe tu Lea se datu annánà na. Umadanni da se da nga nagukkab kitu lusà. Ay se la nga tu Raquel se tu Jose nga magina. Inumbet da se da nga nagukkab kitu lusà pe. ");
INSERT INTO isd_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ay nán tu Esau kitu Jacob, “Ay datu nunna nga nesabat ku? Nágan naya piyán mu wa kagiyan kadatun?” nán na. Ay nán tu Jacob ba summungbát, “Panaruanggam ku datun kikaw, ápu. Ta piyán ku ya makikappiya kikaw,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ngamay nán tu Esau, “Adu pe yin daya kuw-kuwà, wagi. Alà mu la datun nin ka kuwám,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ngamay nán tu Jacob, “Akkan. Alà mu kuma datun. Nu kurug ga pinakawan nà in, ay alà mu agpà datun na panaruanggam ku. Ata kane masingan ku ya nagganggam mu nga nangáwat kiyà, ay ummán ku pe ka nasingan ne Dios,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","“Ara kurug gin, alà mu kurug daya panaruanggam ku kikaw. Ta kinalakkán nà tutu wala nge Dios, ay túya adu daya kuw-kuwà,” nán ne Jacob nga nepílit. Ay tútu inalà ne Esau da pe yin. ");
INSERT INTO isd_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ay se yala nán tu Esau, “Mawe tada lugud din. Ay bulunan taka ngin,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ngamay nán tu Jacob kaggína, “Ara ngin, ápu. Munna kayu wala ta nonawán se nakapsut dedi annánà in. Ay tagasinnán ku pe daya animál la atán pasusuwan. Ata nu bur-burungan ta dedi ki isa ngalgaw, ay matay da kid ngámin ki unaw da. ");
INSERT INTO isd_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Munna kayu wala ngin, ápu. Umunud kami la, ta an-annungan mi la ya magdal-dalen. Ipànung mi la ya annalen mi kiya kabailán daya báka nga magin-inona kadakami, ay se kiya annalen pe dedi annánà. Dàngan mi kayu la kannán giyán nu ka Seir,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ay tútu nán tu Esau, “Pagbansiyan ku lugud daya duddúma nga tolay ku nga sumeng kikaw,” nán na. Ngamay “Akkan nala tagge yin, ápu. Ya nán ku kuma ngala ngin ya surútan ta,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Díkod nagulli yala tu Esau kitun kam nga algaw ka Seir. ");
INSERT INTO isd_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ngamay tu Jacob, ay nawe ka Succot. Nagbáwi kattoni se nangwa pe ka kurál datu animál na. Ay túya gapu na nga nengágan na tun ka Succot. ");
INSERT INTO isd_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ay kane kuwa, ay nawe tu Jacob ka íli Sikem ka Canaan kitu naggayát na ka Mesopotamia. Dumatang da kattoni nga áwan napà-pàyanán. Ay nagbáwi manin kitu adanni kitu íli. ");
INSERT INTO isd_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ay ginátang na tun na lusà a nagbawiyán na kadatu pútupútut natu Hamor nga ama tu Sikem. Magatut ta pinaláta nga pirà tu pinanggátang na. ");
INSERT INTO isd_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ay se la pe nga nangwa ka pagday-dayáwan na ke Dios. Nengágan na ka El-Elohe-Israel (Para kiya Dios ne Israel ya sarut na). ");
INSERT INTO isd_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ay tu Dina nga an-anà natu Lea se tu Jacob, ay nawe naggagáyám kadatu babbay kitúni íli Canaan. ");
INSERT INTO isd_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ay kane masingan tu Sikem nga prinsipe kitúni nga an-anà tu Hamor nga Heveo ay sinikap na. ");
INSERT INTO isd_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ngamay kane kuwa, ay kelugán na kurug pe yin. Piyán na tutu wala pe yin tu Dina. Ay tútu inan-anannay na. ");
INSERT INTO isd_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ay se la nán tu Sikem kitu ama na, “Piyán ku atawán idi nga babay, ama. Alà mu ka para kiyà,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Nagìna natu Jacob tu nanikap tu Sikem kitu Dina nga pútut na. Datu annánà na, ay atán da kitu ir-ir-er nga mangipastor kadatu báka da. Díkod akkan nala pikam nagun-úni tu Jacob panda kitu nelalbet da. ");
INSERT INTO isd_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Ay tu Hamor nga ama natu Sikem, ay nawe makiamomán kitu Jacob. ");
INSERT INTO isd_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ay se la nga inumbet pe yin datu lalláki nga pútupútut natu Jacob nga gayát ka ir-ir-er. Ay kane mammuwán da tu nàwa, ay nagpannakit da, ay se nalùsaw da tutu wala. Ata kitu namílit tu Sikem kitu Dina nga pútut natu Jacob, ay neap-appat na daya iIsrael, áta nadakè tutu wala tuni kaggída. ");
INSERT INTO isd_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ngamay nakiamomán tu Hamor kaggída nga nán na, “Kurug ga kelugán natu bag-bagu ku nga Sikem ya an-anà nu. Túya pangaási nu ta pagatawán tada da. ");
INSERT INTO isd_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ipalúbus nu kuma ngin na annung mi ya mangatáwa kadakayu, ay ummán kayu pe, annung nu pe ya mangatáwa kadakami. ");
INSERT INTO isd_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Mepagyán kayu kadakami. Awan ya mangiagáwa kadakayu kiya lusà. Magbalay kayu nu ittu, onu maglà-láku kayu. Annung nu pe ya magtagikuw-kuwa kanedi,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ay nán pe tu Sikem kitu Jacob ba ama tu Dina, se kadatu wawwági na nga lalláki, “Ipalúbus nu agpà in ya agngan ku kadakayu. Idde ku kadakayu oray nágan na ya agngan nu. ");
INSERT INTO isd_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ikagi nu wala nu nágan naya piyán nu wa panádug ku, ta idde ku ngámin. Basta ipalúbus nu wala nga atawán ku we Dina,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ay datu lalláki nga pútupútut tu Jacob, ay sinungbátan da tu Sikem se itu ama na nga Hamor. Ngamay tu sungbát da, ay annábag da ngala kadatu magama gapu lugud kitu nangiap-appat da ke Dina. ");
INSERT INTO isd_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ay nán da kaggída, “Akkan mi màwa yán. Akkan mabalin na ipaatáwa mi ya wagi mi kadaya akkan nagpakúgit. Ata nakap-appat yán kadakami. ");
INSERT INTO isd_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Mabalin na mayát kami ki nán nu, nu kuwaan nu ya isa ngala nga pàwa mi kadakayu. Masápul magpakúgit daya ngámin lalláki kadakayu. ");
INSERT INTO isd_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Nu kuwaan nu yán, ay annung nu ya mangatáwa kadaya babbalásang mi, ay se annung mi pe yin ya mangatáwa kadaya babbay nu. Ay díkod mepagyán kami pe yin kadakayu, ay díkod áwan tada pagdúmán nin. ");
INSERT INTO isd_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ngamay nu maddi kayu kiya nán mi nga magpakúgit kayu, ay alà mi kammin ya wagi mi se kami la nga mawe,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ay nayát tu Hamor se tu Sikem nga magama kitu piyán datu magwawági. ");
INSERT INTO isd_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ay akkan nin-induwán tu bag-bagu kitu nán da. Ta piyán na kurug ge Dina nga an-anà tu Jacob. Tu Sikem pe tu ikaliyaw datu ngámin pan-pane na. ");
INSERT INTO isd_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Díkod miníting da nga magama ngámin datu lalláki kitu íli nga nán da, ");
INSERT INTO isd_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Dedi nga tolay, ay namáru da kadàtada. Ay túya pagyanan tada da kanedi yin íli tada ngi. Annung da pe yin ya maglà-láku kanedi, ta abay mà ya íli para kadàtada ngámin. Annung tada pe yin ya mangatáwa kadaya babbalásang da, ay se annung da pe yin ya mangatáwa kadaya babbalásang tada. ");
INSERT INTO isd_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ngamay atán masápul la kuwaan tada pikam. Masápul la magpakúgit daya ngámin na lalláki kadàtada, nga ummán kadaya ngámin lalláki kaggída. Nu kuwaan tada yán, ay mepagyán se mepagsissa dedi yin na tolay kadàtada kanedi. ");
INSERT INTO isd_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ay nu umannúgut tada ki piyán da, se da nga mepagyán nin kadàtada kanedi, ay kuwa tada pe yin daya ngámin na kuw-kuwa da se daya ngámin na áyam da,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ay nayát ngámin datu umíli kitu nán datu Hamor nga magama. Ay díkod nagpakúgit ngámin datu lalláki kitúni nga íli. ");
INSERT INTO isd_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ay kitu mekàlu wa algaw kitu sillalanát da pikam kitu nagpakúgit da, ay nagtagiampiláng tu Simeon se tu Levi nga pútupútut natu Jacob nga wawwági tu Dina. Ay se da nga nawe kitu íli nga áwan makammu kadatu umíli kitu palánu da. Ay se da pinatayán ngámin datu lalláki kaggída. ");
INSERT INTO isd_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Pinatay da pe tu Hamor se tu Sikem nga magama. Ay se da nga inalà tu Dina se dala nga nagtálaw. ");
INSERT INTO isd_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ay datu duddúma nga pútupútut natu Jacob, ay inumbet da kitu íli, se da nga alakkán datu kuw-kuwa datu tolay. Kinuwa da tun, áta neap-appat datu umíli tu wagi da nga babay. ");
INSERT INTO isd_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Inalà da datu báka da, se datu karneru da se kalding da, se datu asnu da, se datu ngámin na atán kitu íli se datu atán kitu tálun. ");
INSERT INTO isd_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Inalà da tu ngámin na kuw-kuwa da se datu annánà da, se datu attáwa da, se ngámin na masingan da kadatu babalay da. ");
INSERT INTO isd_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","May nán tu Jacob kitu Simeon se tu Levi, “Tura dà pe ya iraaráas ta? Kídi yin ay kalingáan dà daya iCanaan se daya iPerezo. Bittì tada. Ay nu tura da la nga umbet nga makigubát kadàtada, ay kurug gala a nga matay tada ngámin, ta adu da,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ngamay nán da pe, “May tura da la pe pinagbalin ya wagi mi ka ummán ka púta ta!” nán da. ");
INSERT INTO isd_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ay nán ne Dios kitu Jacob, “Mawe ka magyán ka Betel. Ay mangwa ka pe kannán ka annìdúgán mu ka pagbasu mu kiyà. Iyà kam tu nagpassingan kikaw kitu inagtálaw mu ke Esau nga wagi mu,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ay díkod nán natu Jacob kadatu akkobung na se datu tolay na, “Ippà nu ngámin daya sinan diy-diyos nu nga negayát nu ki sabáli nga giyán, se nu dalusán daya bag-baggi nu, se kayu pe magsukát ka nadalus sa bádu. ");
INSERT INTO isd_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ta magalit tada ngin ka Betel. Mangwa ngà kattoni ka pagday-dayáwan ke Dios, nga ittu ya sinummeng kiyà kitu inagrig-rígát ku. Ay atán peyapeyang kadatu nap-apannán ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Díkod niddánán da kitu Jacob ngámin datu sinan diy-diyos nga negayát da ka sabáli nga giyán, se datu tatalobang da nga gayát kadatu sinan diy-diyos. Ay se na nekorob ngámin datun kitu linung tu káyu wa lugo nga adanni ka Sikem. ");
INSERT INTO isd_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ay kitu agdal-dalen da, ay pinagansing ne Dios datu tolay kadatu il-íli nga liw-liwánan da kaggída. Díkod áwan nangpal kaggída. ");
INSERT INTO isd_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Ay díkod dummatang tu Jacob se datu ngámin akkobung na se datu tolay na ka Luz (Betel kam yán), nga atán kam pe ka Canaan. ");
INSERT INTO isd_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Nangwa kattoni ka pagday-dayáwan na ke Dios. Nepangágan na tu giyán ka El Betel, áta kattoni tu nagpassingannán ne Dios kaggína kitu inagtálaw na kitu Esau. ");
INSERT INTO isd_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ay natay kattoni tu Debora nga magtar-tarakan kitu Rebecca. Netaman da kattoni kitu linung natu káyu wa lugo kitu panimbaw Betel. Díkod nepangágan da tu giyán ka “Lugo wa Agmanakit.” ");
INSERT INTO isd_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ay díkod ittu idi tu nàwa. Kane maggayát tu Jacob ka Paddan-aram, ay nagpassingan manin ne Dios kaggína, ay se na binindisiyonán pe. ");
INSERT INTO isd_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ay nán ne Dios kaggína nga namindisiyon, “Ya ngágan mu ay Jacob, ngamay akkan ittu yanin ya ngágan mu, ta Israel ya ngágan mu win,” nán na. Díkod Israel lin tu ngágan na nanggayát kitun. ");
INSERT INTO isd_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ay nán ne Dios manin kaggína, “Iyà e Dios nga Mannakabalin. Magpaadu kayu, ta senu gumánab kayu. Magbalin kayu ka isa nga nasiyon, ay se ikaw ya paggayatán daya tangabubúlun na nas-nasiyon. Ikaw pe ya paggayatán daya à-ári daya il-íli. ");
INSERT INTO isd_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ay tu lusà a nekarì kitu Abraham, se kitu Isaac ay ipakin-kuwà pe kikaw se kadaya ngámin na gakagaka mu,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ay se la pinanáwan ne Dios tu Jacob kitúni nga giyán nga nangamomanán na kaggína. ");
INSERT INTO isd_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Nangipasíkád tu Jacob ka batu kitúni ka tagematun na kitu nakibàbànán na ke Dios. Ay se na la nga siniyaán ka bási ka dátun na, ay se na pe siyaán ka denu tu batu, ta senu magbalin ka napatag. ");
INSERT INTO isd_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ay nepangágan tu Jacob tun na giyán ka Betel. ");
INSERT INTO isd_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ay nagrubbuwát da manin de Jacob ba tangabalay ka Betel. Ay ad-adayyu da pikam ka Efrata ngin, kane umbet pe tu oras tu Raquel la magan-anà. Ay nasulitán pànang kitu nanggìgìna na. ");
INSERT INTO isd_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ay kane palotán nin tu rígát natu anggì-gìna na, ay nán tu mamalugganà kaggína, “Akkan ka mansing ngin. Laláki manin ya an-anà mu,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ngamay natay kammala tu Raquel. Kitu anggassát na, ay nepangágan na tu an-anà ka Benoni. Ngamay nepangágan natu Jacob ka Benjamin. ");
INSERT INTO isd_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Netaman da tu Raquel kitu adanni dálen na mawe ka Efrata (ay Betlehem kam yán na giyán). ");
INSERT INTO isd_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Nangipasíkád tu Jacob ka batu kitu otun tu lúbù na. Ittu tun tu tagenatun na kitu lúbù natu Raquel. Atán pikam tun na batu panda kadedi yin na al-algaw. ");
INSERT INTO isd_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Netul-túluy da tu nagdal-dalen. Ay kane dumatang da kitu giyán tu torre Eder, ay nagbáwi da manin kitu giyán na adanni kitúni. ");
INSERT INTO isd_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ay kitu kowad da kitúni nga giyán, ay nawe inlay tu Ruben tu Bilha nga isa kadatu attáwa natu Jacob nga ama na. Ay nammuwán tu Jacob tun na nàwa. Sangapúlu se duwa ngámin datu pútupútut natu Jacob nga lalláki. ");
INSERT INTO isd_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Datu annánà da se tu Lea nga lalláki, ay tu Ruben (aggína tu manákam ma pútut tu Jacob), tu Simeon, tu Levi, tu Juda, tu Isacar, se tu Zebulun. ");
INSERT INTO isd_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Datu annánà da se tu Raquel nga lalláki, ay tu Jose se tu Benjamin. ");
INSERT INTO isd_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Datu annánà da nga lalláki se tu Bilha nga bobonan tu Raquel, ay tu Dan se tu Naftali. ");
INSERT INTO isd_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ay datu annánà tu Jacob se tu Zilpa nga bobonan natu Lea, ay tu Gad se tu Aser. Tu dayán ngámin datu pútupútut natu Jacob. Neanà da ngámin ka Mesopotamia. ");
INSERT INTO isd_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Ay nawe tu Jacob ka Mamre nga Kiriatarba kam pe (ay Hebron kam yán) nga giyán tu Isaac nga ama na. Kattoni pe tu nag-agyanán tu Isaac se tu Abraham nga magama. Nepagíli da ngala kitúni. ");
INSERT INTO isd_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Ay magatut se walu púlu tu dagun natu Isaac ");
INSERT INTO isd_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","se la nga natay. Làlakay pànang ngin kane matay. Ay díkod netaman de Esau se tu Jacob tu Isaac nga ama da. ");
INSERT INTO isd_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Tu dedi datu lalláki nga pútupútut tu Esau (nga Edom kam pe). ");
INSERT INTO isd_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Nangatáwa nge Esau kadatu babbay ka Canaan. Tu dedi datu attáwa na: Tu Ada nga an-anà natu Elon nga Heteo, tu Oholibama nga an-anà natu Ana. Tu Ana ay an-anà natu Zibeon nga Heveo. ");
INSERT INTO isd_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Atáwa natu Esau pe tu Basemat nga wagi natu Nebayot. Pútut tu Ismael datun na duwa. ");
INSERT INTO isd_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Tu laláki nga an-anà natu Esau se tu Ada ay tu Elipaz. Ay tu laláki nga an-anà da se tu Basemat ay tu Ruel. ");
INSERT INTO isd_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Ay datu lalláki nga annánà da se tu Oholibama, ay tu Jeus, tu Jalam se tu Kora. Tu dayán datu pútupútut tu Esau nga lalláki nga neanà ka Canaan. ");
INSERT INTO isd_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Umadayyu tu Esau kitu Jacob nga wagi na. Inalà na ngámin datu kuw-kuwa na nga nálà na ka Canaan, se da la nga nagtálaw nga tangabalay. Inalà na datu báka na, se datu ngámin na animál na. ");
INSERT INTO isd_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Nagtálaw, áta adu tutu wala ngin datu animál da se tu Jacob. Akkan da mabalin ya magbulun nin. Ta akkan umanáy yin tu lusà kadatu animál da nga duwa, áta adu tutu wala ngin. ");
INSERT INTO isd_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Díkod nawe naggunà tu Esau kitu ban-bantay nga íli ka Seir. (Tu Esau ay Edom kam). ");
INSERT INTO isd_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ay tu dedi datu pútupútut tu Esau wa apuapu datu Edomita. Nagyán da ngámin kitu ban-bantay nga íli Seir. ");
INSERT INTO isd_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Tu dedi lugud daya ngag-ngágan datu lalláki nga pútupútut tu Esau. Tu Elipaz nga an-anà da se tu Ada. Tu Ruel nga an-anà da se tu Basemat. ");
INSERT INTO isd_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ay tu Elipaz, ay atán da pe pútupútut na nga lalláki. Tu dedi datu ngag-ngágan da: tu Teman, tu Omar, tu Zefo se tu Gatam se tu Kenaz. ");
INSERT INTO isd_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Ay atán pe isa nga laláki nga pútut natu Elipaz kitu Timna nga kàduwa nga atáwa na. Amalek ya ngágan na. Tu dayán datu pútupútut tu Esau kitu Ada. ");
INSERT INTO isd_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Tu dedi datu lalláki nga pútupútut tu Ruel nga an-anà tu Esau se tu Basemat: tu Nahat, tu Zera, se tu Samma se tu Mizza. Tu dayán datu apúku tu Esau kitu Basemat. ");
INSERT INTO isd_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ay tu dedi datu lalláki nga pútupútut tu Esau se tu Oholibama nga an-anà tu Ana nga an-anà tu Zibeon: tu Jeus se tu Jalam se tu Kora. ");
INSERT INTO isd_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Tu dedi datu apúku natu Esau nga naggay-gayatán datu gakagaka na. Datu apúku na nga lalláki kitu Elipaz nga manákam ma pútut na, ay tu dedi datu ngag-ngágan da: tu Teman, tu Omar, tu Zefo tu Kenaz, ");
INSERT INTO isd_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","tu Kora, tu Gatam se tu Amalek. Tu dayán datu lalláki nga pútupútut natu Elipaz nga ap-apu datu tolay ka íli Edom. Apúku tu Ada ngámin dayán. ");
INSERT INTO isd_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ay datu lalláki nga apúku tu Esau kitu Ruel nga naggay-gayatán datu gakagaka na ay: tu Nahat, tu Zera, tu Samma, se tu Mizza. Tu dayán datu lalláki nga apúku tu Esau kitu Ruel nga an-anà da se tu Basemat. Aggída ya à-apu pe datu tolay ka Edom. ");
INSERT INTO isd_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Tu dedi datu lalláki nga pútupútut tu Esau kitu Oholibama nga an-anà natu Ana: tu Jeus, tu Jalam se tu Kora. ");
INSERT INTO isd_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Aggída pe daya naggayatán datu tolay ka Edom. ");
INSERT INTO isd_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Tu dedi datu ngag-ngágan datu apuapu datu duddúma nga tolay ka Edom nga à-apu pe datu gakagaka da kampela ngin nin: tu Lotan, tu Sobal, tu Zibeon, tu Ana, tu Dison, se tu Ezer se tu Disan. Tu dayán datu lalláki nga pútupútut tu Seir nga Horeo. ");
INSERT INTO isd_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ay datu lalláki nga pútupútut tu Lotan ay de Hori se tu Heman. Ay uwad wagi natu Lotan nga babay. Timna tu ngágan na. ");
INSERT INTO isd_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ay datu lalláki nga pútupútut natu Sobal ay de Alban, tu Manahat, tu Ebal, se tu Sefo se tu Onam. ");
INSERT INTO isd_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ay datu lalláki nga pútupútut natu Zibeon, ay tu dedi: tu Aya se tu Ana. Tu Ana tu nakasmà kitu gabbuwà a napásu tu danum na kitu ir-ir-er, kaggína na nga mangipas-pastor kadatu asnu natu Zibeon nga ama na. ");
INSERT INTO isd_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ay tu pútut natu Ana nga laláki ay tu Dison, ay se tu Oholibama tu pútut na nga babay. ");
INSERT INTO isd_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ay tu dedi datu lalláki nga pútupútut natu Dison: tu Hemdan, tu Esban, tu Itran se tu Keran. ");
INSERT INTO isd_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ay tu dedi datu lalláki nga pútupútut natu Ezer: tu Bilhan, se tu Zaban, se tu Akan. ");
INSERT INTO isd_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ay datu lalláki nga pútupútut natu Disan ay tu dedi: tu Uz se tu Aran. ");
INSERT INTO isd_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Tu dedi datu naggay-gayatán datu Horeo nga à-apu pe kadatu tolay da kampela ngin nin: tu Lotan, tu Sobal, tu Zibeon, tu Ana, ");
INSERT INTO isd_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","tu Dison se tu Ezer se tu Disan. Tu dayán datu apuapu datu Horeo nga atán ke íli Seir. ");
INSERT INTO isd_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ay tu dedi datu à-ári nga nangitur-turáy ka íli Edom. Nagári da kitu áwan pikam ári kadatu iIsrael. ");
INSERT INTO isd_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Tu Bela nga pútut natu Beor tu nagári ka íli Dinhaba ka Edom. ");
INSERT INTO isd_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Ay kane matay tu Bela, ay tu Jobab nga pútut natu Zera nga iBozra tu summukát ta nagári. ");
INSERT INTO isd_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Ay kane matay tu Jobab, ay tu Husam nga iTeman ya summukát ta nagári. ");
INSERT INTO isd_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Ay kane matay tu Husam, ay tu Hadad nga pútut natu Bedad ya summukát ta nagári. Tu Bedad nga iAvit tu namalsu kadatu gakagaka natu Midian kitu naggugubát da ka Moab. ");
INSERT INTO isd_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Ay kane matay tu Hadad, ay tu Samla nga iMasreka tu summukát nga nagári. ");
INSERT INTO isd_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Ay kane matay tu Samla, ay tu Saul la iRehobot tu summukát ta nagári. Adanni ka wángag Eufrates ya Rehobot. ");
INSERT INTO isd_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Ay kane matay tu Saul, ay tu Baal-hanan nga pútut natu Akbor tu summukát nga nagári. ");
INSERT INTO isd_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ay kane matay tu Baal-hanan, ay tu Hadar nga iPau tu summukát ta nagári. Atáwa na tu Mehetabel nga an-anà tu Matred nga an-anà tu Mezahab. ");
INSERT INTO isd_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Díkod tu dedi datu ngag-ngágan datu gakagaka natu Esau. Ittu pe ya ngag-ngágan datu tangámalán da se datu il-íli da, se aggída pe datu à-apu datu gakagaka da kampela ngin nin: tu Timna, tu Alva, tu Jetet, ");
INSERT INTO isd_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","tu Oholibama, tu Ela, tu Pinon, ");
INSERT INTO isd_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","tu Kenaz, tu Teman, tu Mibzar ");
INSERT INTO isd_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","se tu Magdiel se tu Iram. Tu dayán datu gakagaka natu Esau (Edom kam pe ya Esau). Datu ngag-ngágan da pe ya ngag-ngágan datu il-íli nga nagyanán da, ay se aggída pe daya à-apu kadayán il-íli da. ");
INSERT INTO isd_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Ay naggunà tu Jacob ka Canaan, nga ittu pe tu nepagiliyán datu mannákam na. ");
INSERT INTO isd_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ay tu dedi datu nà-nàwa kade Jacob ba tangabalay. Ay gapu ta sangapúlu se pittu dagun natu Jose yin, ay aggína tu isa nga magtar-tarakan kadatu karneru se kalding da. Sinengán na datu wawwági na nga lalláki, nga annánà tu Bilha se tu Zilpa nga attáwa pe natu ama na. Ay tu Jose pe tu mangipipílit kitu ama da kadatu nadakè a kuk-kuwaan datu wawwági na. ");
INSERT INTO isd_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Tu Jose tu idum-dúma natu Jacob kadatu ngámin na annánà na, áta neanà kitu kalàlakay na ngin. Ay pinangwa na tu Jose ka bádu na nga adaddu se adaddu pe íma na. ");
INSERT INTO isd_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ay kane mammuwán datu wawwági na tu angngidúma natu ama da kaggína, ay tútu lùsawan da pe yin. Ay akkan napiya pe yin datu akiamomán da kaggína. ");
INSERT INTO isd_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ay isa nga gabi, ay uwad tagenap tu Jose. Ay kane ibàbànán na tu tagenap na kadatu wawwági na, ay naturun lugud agpà tu angngalùsaw da kaggína. ");
INSERT INTO isd_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ata nán na kaggída, “Gìnán nu kod idi nga tagenap ku kitu gabi. ");
INSERT INTO isd_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Atán tada kanu mà a magbattà ka ginápas kiya isa nga tálun. Ay isa kanu mà kadatu bintàán ku ya nagsíkád. Ay datu bintàán nu, ay nepalìmut da kitu bintà ku, se da kanu mà a miplog kitu bintà ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ay tútu nán da kaggína, “Inna! Ya nán mu, gane, ay ikaw ya magári kadakami onu mangituráy kadakami,” nán da kaggína. Ay tútu naturun tu angngalùsaw da kaggína gapu kadatu nebàbànán na kaggída panggap kitu tagenap na. ");
INSERT INTO isd_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ay kane isa nga gabi manin, ay uwad manin tagenap na. Ay nebàbànán na manin kadatu wawwági na. Ay nán na, “Atán kod mà tagenap ku manin. Tagenap ku nga ya mata se ya búlán se sangapúlu se isa nga bittuwan, ay nagukkab da kanu mà kiya àráng ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ay kane ibàbànán na pe kitu ama na, ay pináas na nga nán na, “As, nágan na nga tagenap yán! Ya piyám nga kagiyan, ay iyà nga ama mu se iya ina mu se daya wawwágim, ay magukkab kami ngámin ki àráng mu?” nán tu ama na. ");
INSERT INTO isd_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ay tútu magimli datu wawwági na kaggína gapu kadatun na tag-tagenap na. Ngamay linam-lammat tala natu ama na datun. ");
INSERT INTO isd_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ay kane din isa nga algaw, nawe nepastor datu wawwági natu Jose datu karneru se kalding natu ama da ka Sikem. ");
INSERT INTO isd_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","14","Ay nán tu Jacob kitu Jose, “Nawe nepastor datu wawwágim datu karneru se kalding ka Sikem. Mawe muda nga sùbangán. Mawe mu sinnan nu mapà-paanna da ngin se datu ipas-pastor da. Ay umbet ka kammin, ta senu ammuwán ku nu mapà-paanna da,” nán na. “Mawe yà a lugud,” nán tu Jose. Ay tútu nagrubbuwát tin ka Hebron nga íli nga natanáp, nga mawe ka Sikem. Ay kane dumatang ka Sikem, ay sapúlan na ngin datu wawwági na. ");
INSERT INTO isd_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Ay uwad isa nga laláki nga nakasingan kaggína nga magaw-awagwag kitu ir-ir-er. Ay tútu sinaludsud natu laláki kaggína, “Inna ya sap-sapúlam?” nán na. ");
INSERT INTO isd_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","“Sap-sapúlan ku datu wawwágì nga mangipas-pastor kadatu karneru se kalding mi. Ikagim mán agpà kiyà nu wàna giyán da,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","“Awan da ngin kanedi,” nán natu tolay. “Nagìnà a ‘Dadun mawe tada ka Dotan,’ nán da,” nán tu tolay. Díkod nawe na sinapúlan datu wawwági na, ay nasmà nada ka Dotan. ");
INSERT INTO isd_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Adayyu pikam tu Jose, ay nasingan datu wawwági na ngin. Kitu adayyu pakam, ay naggaamomanán da nga patayan. ");
INSERT INTO isd_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Nán da kitu isa isa kaggída, “Ye atán nin tu maragtagenap. ");
INSERT INTO isd_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ara nu, ta patayan tada, se tada nga ipisù kiya nasiyánan na bubun. Ay se tada la nga nán ke ama nga pinatay se kinnán ulolag. Ay sinnan tada nu atán pagtung-tungpálan datu tag-tagenap na,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","May kane magìna tu Ruben tu kinagi da, ay sinipa nada nga nán na. “Akkan tada nga patayan. ");
INSERT INTO isd_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ipisù tada ngala kiya bubun kídi ir-ir-er,” nán natu Ruben kaggída. May nán na ngala tun, áta palánu na nga alà kammin, ta senu makapagulli kammin kitu ama na. ");
INSERT INTO isd_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ay díkod kane dumatang tu Jose kitu giyán datu wawwági na, ay dinugkam da se da làbuwan tu bádu na nga adaddu nga adaddu íma na, ta ittu tun tu pinagbádu na. ");
INSERT INTO isd_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ay se da nga nippan na nepisù kitu bubun na nasiyánan. ");
INSERT INTO isd_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ay kane atán da nga mangán, ay uwad nalágib da nga tangabubúlun na tolay ya mameyag kitu giyán da. Datu gakagaka natu Ismael da. Gayát da ka Gilead, may mawe da magláku se maggátang ka Egipto. Díkod adu datu agtu da nga ittatánib se datu ibbabalsamár nga netakay da kadatu kámel da. ");
INSERT INTO isd_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ay nán tu Juda kadatu wawwági na, “Awan tada málaálà, wawwági, nu patayan tada ya wagi tada, se tada nga ituláyaw. ");
INSERT INTO isd_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Napì-piya la ngin nu iláku tada kadaya Ismaelita. Akkan tada patayan, ta wagi tada kam. Kabaggiyán tada kam yán,” nán na. Ay nayát datu wawwági na kitu nán na. ");
INSERT INTO isd_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ay kane lumíwán datu iMidian nga maglà-láku, ay inalà da kammin tu Jose kitu bubun, ay se da neláku kadatu Ismaelita ka duwa púlu wa pinaláta nga pirà. Ay díkod nippan da tu Jose ka Egipto. ");
INSERT INTO isd_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ay kane mawe toliyan tu Ruben tu Jose kitu bubun, ay áwan na nasingan kaggína. Ay tútu nagpannakit, ay pinìsi natu bádu na kitu pannakit na. ");
INSERT INTO isd_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Nawe kitu giyán datu wawwági na se na nán kaggída, “Awan Jose kitu bubun! Ay nágan naya kuwaan kun!” nán na. ");
INSERT INTO isd_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ay tu bádu natu Jose, ay inalà da se da nga namatay ka kalding se da nga nidsam kitu dága. ");
INSERT INTO isd_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Nippan da tu bádu kitu ama da, ay se da nga nán kaggína, “Nasmà mi idi nga bádu. Sinnam mán nu ittu yán tu bádu natu an-anà mu,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Nalásin na tu bádu. “Saay! Ittu idi ya bádu natu an-anà ku. Kinnán ulolag á nge Jose. Nalápi-lápi á tu an-anà ku!” nán na. ");
INSERT INTO isd_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ay tútu pinìsi na tu bádu na kitu pannakit na. Nagbádu ka langgusti ta nagmanakit gapu kitu an-anà na. Nabayág ga nagmanakit. ");
INSERT INTO isd_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Anannayan datu pútut na ngamay maddi maanannay. “Magmanakit tà ki an-anà ku panda ki katay ku,” nán na. Ay pabegan na tu sumángit. ");
INSERT INTO isd_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ngamay tu Jose, ay neláku datu iMidian ka Egipto kitu Potifar ra isa nga kapitán datu guwardiya natu ári. ");
INSERT INTO isd_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Akkan nabayág nanggayát kitu nangiláku da kitu Jose, ay pinanáwan natu Juda datu wawwági na, ay se la nawe nagyán kitu adanni kitu giyán tu Hira nga iAdullam. ");
INSERT INTO isd_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ay kitúni ay nasingan natu Juda tu babbalásang tu Sua nga Cananeo. Ay inatawán tu Juda tu babbalásang. ");
INSERT INTO isd_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Nabùsit, ay se la nagan-anà ka isa nga laláki. Nepangágan na ka Er. ");
INSERT INTO isd_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Akkan nabayág ay nabùsit manin, ay nagan-anà ka isa nga laláki. Nengágan na ka Onan. ");
INSERT INTO isd_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ay se la manin nagan-anà ka isa nga laláki kitu kaatán na ka Akzib. Ay nepangágan na ka Sela. ");
INSERT INTO isd_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Pinagsápul natu Juda tu Er nga manákam ma pútut na ka atáwa na. Ay nasmà na tu Tamar. ");
INSERT INTO isd_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ngamay tu Er, ay nadakè datu kuk-kuwaan na ki agsisíngan ne APU, ay tútu pinatay na. ");
INSERT INTO isd_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Díkod nán tu Juda kitu Onan, “Rabbang na nga ikaw ya mangidde ka pútupútut na wagi mu. Ay túya mawem allayan ya ípág mu,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ngamay ammu natu Onan nga ya an-anà, ay akkan mepakin-kuwa kaggína. Díkod, nu meallay tu Onan kitu ípág na, ay ippà na peyang tu maggayát kaggína, ta tagànaán na ka an-anà tu wagi na. ");
INSERT INTO isd_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Nalùsaw we APU kitun na kinuwa tu Onan, ay tútu pinatay na pe. ");
INSERT INTO isd_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ay díkod nán natu Juda ke Tamar nga manúgáng na, “Mawe ka pikam ka balay nu. Idaggám ya ikà-abay ne Sela nga pútut ku,” nán na. Nán na tun ta malídug ta get matay pe nga ummán kadatu wawwági na. Díkod nawe tu Tamar ka balay da. ");
INSERT INTO isd_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ay kane mabà-bayág gin, ay natay tu atáwa tu Juda. An-anà tu Sua mà tu atáwa na. Ay kane mabalin tu agmanakit natu Juda, ay nawe da se itu opun na nga Hira nga iAdullam ka Timna. Atán da kitúni datu maragpúkis kadatu karneru na. ");
INSERT INTO isd_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ay uwad nagkuna kitu Tamar ka, “Mawe ye katugángam ka Timna nga magpapúkis kadatu karneru na,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ay tu kinuwa natu Tamar pe, ay nippà na tu bádu na nga ibbabádu da nga búkud, ay se la pe magladdung ka natàbán ngámin tu murang na. Nagbugubugut pe, ta senu akkan malas-lásin. Ay se la nawe nagtutúgaw kitu ruwángan natu íli Enaim nga dadalenán da nga mawe ka Timna. Kinuwa na tun, áta nasingan na nga abay yin tu Sela ngamay akkan dada pikam pinagatáwa. ");
INSERT INTO isd_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ay kane masingan natu Juda, ay páti na nu isa nga púta, áta tinàbán na tu murang na. ");
INSERT INTO isd_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Tútu nawe kitu giyán na se nán kaggína, “Dadin ta maggan-gánas ta,” nán na, áta akkan na ammu nga ittu tun tu manúgáng na. Ay nán natu babay, “Ay nágan iddem kiya?” nán na. ");
INSERT INTO isd_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ay nán natu Juda nga summungbát, “Patuludán taka ka isa nga urbun kalding,” nán na. Ay nán manin tu babay, “Napiya nu patingáan nà panda ki agpetulud mu ki urbun kalding,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","“Nágan na nga patínga ya iddè kikaw?” nán natu Juda. “Ya sangkilat ta immamarkám se iya kadena na, se ya tàdukud mu,” nán tu babay. Díkod nidde na ngámin datun kaggína, se da nga nagallay. Ay se la nawe tu Juda. Ay nanggap-gapu tu Tamar. ");
INSERT INTO isd_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Nawe pe yin, ay se na nga ippà pe yin tu laddung na, ay se na ngin pagbádu tu ibbabádu da búkud. ");
INSERT INTO isd_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ay kane pidde natu Juda ngin tu urbun kalding kitu opun na nga iAdullam kitu babay, ay akkan na nga masmà tu babay. Alà na kuma pe yin datu patínga na. ");
INSERT INTO isd_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Díkod sinaludsud na kadatu lalláki kitúni nga nán na, “Ka wàna giyán natu púta nga uwad magtutúgaw kitu bíkat dálen ka Enaim?” nán na. Ngamay nán da, “Awan mà púta nga inummang kanedi a!” nán da. ");
INSERT INTO isd_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Díkod, nagulli kitu Juda se na nga nán, “Awan ku nasmà kitu babay. Ay ‘Awan mà inummang nga púta kanedi,’ nán datu lalláki kitúni,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ay tútu nán natu Juda, “Kuwa na la ngin datu nepatíngà kaggína. Ta get igal-galà ditta da tolay. Piddè mà kikaw idde nga kalding may áwan mu masmà kaggína mà,” nán natu Juda. ");
INSERT INTO isd_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Moli kid tallu búlán ka panda, ay uwad nagkuna kitu Juda nga, “E Tamar nga manúgáng mu, ay atán kal-allay na ngin. Ay nabùsit pe yin,” nán na. Ay tútu nán natu Juda, “Ilawán nu, se nu sìdúgan yán na babay panda ki katay na,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ay kitu angngilawán da kitu Tamar, ay nepekagi na kadatu tolay kitu katugángan na ya, “Ya laláki nga makin-kuwa kadedi, ay aggína ya ama nedi bùsit ku wi,” nán na. “Sinnan muda agpà se mu kagiyan kiyà nu inna ya makin-kuwa kadedi nga sangkilat ta immamarka se ya kadena na, se ya tàdukud,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Ay binigbig natu Juda nga kuw-kuwa na datun. Ay se na nga nán, “Awan na nga básul. Iyà ya atán básul ta akkan ku nepaatáwa ke Sela nga pútut ku,” nán na. Ay akkan inlay natu Juda tu Tamar rin. ");
INSERT INTO isd_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ay kitu aggan-anà na ngin, ay síngin datu annánà na. ");
INSERT INTO isd_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ay kane manggì-gìna ngin, ay lummawán tu íma natu isa kadatu annánà. Inimmán natu mamalugganà tu íma na se na babbaddan ka daggáng nga binola. Ta aggína tu nunna nga lumawán. ");
INSERT INTO isd_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ngamay kane gamnídan na kammin tu íma na kitu unag, ay lumawán tu kasíngin na. Ay laláki. Ay nán tu mamalugganà, “Tura ka pe makiguru nga lumawán!” nán na. Díkod nepangágan da tun ka Perez. ");
INSERT INTO isd_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ay se la pe nga lumawán tu wagi na nga nababbaddán ka daggáng nga binola. Ay laláki pe. Ay nepangágan da ka Zera. ");
INSERT INTO isd_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ay nu tu Jose, ay nippan datu Ismaelita ka Egipto. Ay ginátang tu Potifar tu Jose kaggída. Tu Potifar ay isa nga iEgipto nga kapitán datu guwardiya ka palásiyu natu ári. ");
INSERT INTO isd_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","E Apu ya atán peyapeyang nga mamul-bulun kitu Jose. Ay tútu napiya tu nà-nàwaán na. Ay díkod atán pe yin kitu balay natu apu na nga iEgipto. ");
INSERT INTO isd_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Nalásin natu apu na nga atán ne APU peyapeyang kaggína. Ay ngámin na kuwaan natu Jose, ay papiyaan ne APU da ngámin. ");
INSERT INTO isd_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Díkod pàgan na nge Jose. Tútu pinagbalin na ka bobonan na kampela ngin. Ay pinagbalin na pe ka maragtagasíngan kitu balay na, ay se nepiyár na kaggína pe datu ngámin na kuw-kuwa na. ");
INSERT INTO isd_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Nanggayát kitu nangngipiyár na kadatu ngámin na kuw-kuwa na se itu balay na kitu Jose, ay tinag-tagasinnán pe ne APU tu iEgipto, se datu akkobung na, se datu kuw-kuwa na, se datu mul-múla na. Kinuwa ne APU tun gapu kitu Jose. ");
INSERT INTO isd_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Díkod nepiyár na tu ngámingámin na kuw-kuwa na kitu Jose. Gapu kitu Jose, ay áwan na nga lid-lídug ki oray inna. Tittu la tu kanan na. Tu Jose ay natáram se nabakad. ");
INSERT INTO isd_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ay kane din isa ngalgaw, ay natarmán tu atáwa ne Potifar kitu Jose. Ay tútu nán na kitu Jose, “Umbet ikaw, magallay,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ngamay naddi tutu wala tu Jose, ay nán na kaggína, “Nepiyár naya apù ya ngámingámin na kuw-kuwa na kiyà. Awan na lid-lídug kadaya kuw-kuwa na kídi balay gapu lugud ta piyáran nà. ");
INSERT INTO isd_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Nagpáda ngin ya turáy mi kídi nga balay. Ay áwan na nga netagàna kiyà. Ikaw wala nga atáwa na. Ay túya maddi yà kiya nadakè tutu wala nga talipàwa mu kiyà. Lùsawan ku ya magbásul ke Dios,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ay oray inalgaw tu angngagi na kitu Jose nga magallay da, ay akkan na inat-atangya, ay se lanídán na peyang pe. ");
INSERT INTO isd_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ngamay kane isa ngalgaw kane mawe ye Jose kitu balay da nga mangwa ngin kadatu ubra na, ay nipàmu pe nga áwan pe datu lalláki ya atán kitu balay. ");
INSERT INTO isd_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","13","Dinugkam natu atáwa Potifar tu Jose nga nán na, “Ara, allayan nà kídi yin!” nán na. Ngamay naglàmut tu Jose. Nagtálaw se lumawán kitu balay, ngamay nabansi tu amin lasi nga bádu na kitu babay. Ay tútu ");
INSERT INTO isd_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","nakas-asáraw kanu mà pe nga nagkarraw kadatu lalláki nga magub-ubra kitu balay da. Ay nán na kaggída, “Sinnan nu kod! Tali iap-appat nitta ya Hebreo nga nilbet natu atáwà kanedi balay yi. Tagge nà ala nga sìpan ngamay se yà a nakas-asáraw. ");
INSERT INTO isd_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ay kane makas-asáraw wà ay nagkirut nagtálaw. Ay tútu akkan na natagmit idi bádu na ngi,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ay se na nga nippapáy tu bádu natu Jose kitu giyán na panda kitu nilalbet natu atáwa na. ");
INSERT INTO isd_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ay kane umbet tu atáwa na, ay nagpipílit nga nán na, “Tu asassu mu nga Hebreo nga inalà mu kanedi, ay linumnà kídi giyán ku se nà sìpan kuma ");
INSERT INTO isd_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ngamay kane makasáraw wà, ay nagkirut nagtálaw se la lumawán. Ay túya nabansi na ya bádu na ngi,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ay kane magìna natu apu tu Jose tu nekagiyán tu atáwa na, ay nakarungat pànang. ");
INSERT INTO isd_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Díkod tiniliw na tu Jose se na nga ibálud kitu agba-balúdán na giyán pe datu bálud natu ári. ");
INSERT INTO isd_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ngamay atán pe APU Dios nga sumeseseng peyang kitu Jose. Nepassingan na tu kinamáru na kaggína kane idúma manin natu apu kitu agba-balúdán tu Jose. ");
INSERT INTO isd_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ay tu Jose tu pakammuwan natu ap-apu kitu agba-balúdán kadatu duddúma nga bálud. Tu Jose pe tu nangipiyáran na kadatu ngámingámin na mà-màwa kitu agba-balúdán. ");
INSERT INTO isd_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ay díkod, áwan lidu-lídug natu ap-apu datu bálud kadatu nepiyár na kitu Jose, áta e APU ya sumeseseng kaggína. Ay oray inna nga kuwaan na, ay napiya peyang ya pagbalinán da, ta e APU ya sumeseseng kaggína. ");
INSERT INTO isd_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Akkan nabayág, datu ap-apu datu para tog kitu ári ka Egipto se itu ap-apu datu maragkuwa ka sinápay na, ay nakabásul da. ");
INSERT INTO isd_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Ay díkod nalùsaw tu ári kaggída nga duwa. ");
INSERT INTO isd_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Ay díkod nepebálud nada kitu balay natu kapitán datu guwardiya, kitu nangibalúdan da kam pe kitu Jose. ");
INSERT INTO isd_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Nabà-bayág da kam kitu agba-balúdán. Ay tu Jose tu nangipiyáran natu kapitán kaggída nga duwa. Tu Jose tu makammu kadatu masap-sápul datu duwa. ");
INSERT INTO isd_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Isa nga gabi kitu agba-balúdán, ay nagtatagenap datu duwa nga bálud; tu apu datu para tog kitu ári ka Egipto se itu apu datu para kuwa na ka sinápay. Nagbaláki datu tagenap da, ay atán kampela kesarután da ngin. ");
INSERT INTO isd_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ay kane pagmakát, ay nalásin tu Jose nga ummán ka mariribù da nga duwa. ");
INSERT INTO isd_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Díkod sinaludsud na kaggída, “Tura kayu sùsoot kídi nga algaw?” nán na. ");
INSERT INTO isd_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","“Uwad da tagenap mi, may áwan makekagi kadakami ki sarut da,” nán da. Ngamay nán tu Jose, “E Dios sala ya makesarut kadayán. Kagiyan nu mán kiyà daya tagenap nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Díkod nekagi natu apu datu para tog natu ári tu tagenap na. Ay nán na, “Tagenap ku nga uwad kanu mà tangapun úbás ");
INSERT INTO isd_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","nga tallu tu pasanga na. Kane magtaríngit, ay nagbùgà ala ngin, ay se nagbúnga pe yin, ay se nalútu kanu mà pe yin datu búnga na ngin. ");
INSERT INTO isd_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Im-immán ku kanu mà pe tu akap ne ári. Inalà ku kanu mà datu búnga natu úbás se kuda pagtan kitu akap ne ári, sè idde kaggína ta nagbalin nin ka bási,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Ay tútu nán natu Jose kaggína, “Tu idi ya kesarután naya tagenap mu. Tu tallu wa pasanga ay tallu algaw ya sarut na. ");
INSERT INTO isd_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ki unag tallu ngalgaw, ay pakawanan naka ya ári yin, se naka pelawán nin, ay se naka pagubraan kammin. Ikaw kammin ya para tog kiya ári nga ummán kitu kuk-kuwaan mu kitun. ");
INSERT INTO isd_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ngamay akkan nà agpà kaligpanán, gane, nu pàgan naka kammin. Ikagi nà agpà ala ke ári, ta senu makalawán na pe yin kanedi,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","“Hebreo wà kampela ngin nin, may inalà dà a pinílit kanedi. Ay oray nu áwan ku wa bas-básul ay nebálud dà,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ay kane nagìna natu ap-apu datu para kuwa ka sinápay natu ári nga napiya tu sarut natu tagenap natu ap-apu datu para tog natu ári, ay nán na pe kitu Jose, “Iyà pe, ay uwad tagenap ku. Uwad kanu mà tallu nga maglulosud nga làba nga tutututun ku, nga napnu ka sin-sinápay. ");
INSERT INTO isd_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ay tu amin otun na làba, ay nagbal-baláki kanu mà nga sinápay nga para kiya ári tu minayán na. Ngamay uwad da kanu mà nga an-anù nga magkán kadatun na sinápay,” nán na kitu Jose. ");
INSERT INTO isd_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Ay tútu nán natu Jose, “Tu idi ya sarut natu tagenap mu: Datu tallu wa làba ay tallu algaw ya sarut na. ");
INSERT INTO isd_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ki unag tallu walgaw, ay pelawán naka ya ári ngamay papútul naka. Ay se na pebissin ya baggi mu ki isa nga káyu. Ay maglalbet daya an-anù a magkán kikaw,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ay kane mekàlu nga algaw, ay ittu tu algaw wa nekeanà natu ári. Nagsay-am tu ári para kadatu bobonan na. Ay nepelawán na datu duwa nga bálud ki pagmar-marngán datu duddúma nga bobonan na. ");
INSERT INTO isd_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ay tu ap-apu datu para tog kitu ári, ay aggína tu para tog kammin. Díkod aggína kammin tu manog kitu ári. ");
INSERT INTO isd_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ngamay tu ap-apu datu para kuwa ka sinápay natu ári, ay pinapútul na. Ay díkod nàwa ngámin datu kinagi natu Jose nga sarut datu tag-tagenap da. ");
INSERT INTO isd_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ngamay tu ap-apu datu para tog tu ári, ay naligpanán na tu Jose yin. Awan na nga nakadamdammám pe yin kaggína. ");
INSERT INTO isd_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ay kane malpás ya duwa dagun ka panda, ay uwad pe tagenap tu ári. Tagenap na kanu mà nga magsisíkád kitu dappit natu wángag Nile. ");
INSERT INTO isd_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Ay pìlát na kanu wala daya pittu wa báka nga nappiya se nallùmag, nga gumàdáng nga gayát kitu wángag, ay se da la nga magárab kitu katub-tubngán. ");
INSERT INTO isd_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ay se la uwad kanu mà manin pe ya pittu wa báka nga naniw-níwáng nga nagpag-pagrát tala datu tàgáng da. Ay gumàdáng da pe, nga gayát kitu wángag. Nawe da nga tummaging kadatu pittu nga nallùmag nga atán pe kitu dappit Nile. ");
INSERT INTO isd_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ay datu naniw-níwáng nga báka ay kinnán da kanu mà datu pittu wa nappiya se nallùmag ga báka. Ay se la nga nalukág tu ári. ");
INSERT INTO isd_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ay nìlà manin tu ári, ay se uwad manin tagenap na. Tagenap na ya pittu ngabgát ta ammay ki isa nga dáwa. Nabgát da tutu wala, ay se nalútu da pe yin. ");
INSERT INTO isd_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ay se la pe uwad linumtuwád da pittu ngabgát ta ammay, may pabeg da lappit se nakarsi da gapu ki bal-báli nga gayát ki lattakán. ");
INSERT INTO isd_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ay datu pittu ngabgát ta lappit ta ammay, ay sillan da datu pittu ngabgát ta nabgát se nalútu. Ay nalukág manin tu ári ta tagenap na ngala gáyám tun. ");
INSERT INTO isd_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ay kane din pagmakát, ay nariribù. Ay tútu pinaayabán na datu atán kababalin se mamasírib ba lalláki ki ngámin Egipto. Ay se na la kagiyan tu tagenap na kaggída, ngamay áwan makekagi kaggída kitu kesarután natu tagenap na. ");
INSERT INTO isd_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ay se la nán tu ap-apu datu para tog kitu ári, “Apu, nepadamdam kiyà kídi nga algaw ya básul ku kitu isa nga bálud. ");
INSERT INTO isd_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Kitu nangalùsaw mu kadakami nga bobonan mu, ay nebálud nakami se itu ap-apu datu para kuwa ka sinápay mu kitu balay natu kapitán daya guwardiya. ");
INSERT INTO isd_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Isa nga gabi kitu agba-balúdán, ay nagtagenap kami. Nagbaláki datu tagenap mi, se nagbaláki pe datu sarut da. ");
INSERT INTO isd_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ay kitu agba-balúdán, ay uwad pe isa nga Hebreo nga bálud nga bobonan natu kapitán datu guwardiya. Nekagi mi kaggína datu tagenap mi, ay nesarután nada. ");
INSERT INTO isd_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ay nàwa kurug pe datu kinagi na nga sarut datu tagenap mi. Pinagulli nà kammin kurug kídi ubra ku, ay se pinapatay mu tu ap-apu datu para kuwa ka sinápay mu, nga ummán kitu kinagi na,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ay díkod pinálà natu ári tu Jose. Ay dágus da la kurug nelawán tu Jose kitu agba-balúdán. Nagim-íming pikam se nagsukát, ay se la nga nawe kitu giyán tu ári. ");
INSERT INTO isd_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ay nán tu ári kitu Jose, “Uwad tagenap ku ngamay áwan nala ya makekagi kiyà ki sarut na. Nagìna ku nga annung mu kanu ya mangisarut kadaya tag-tagenap,” nán tu ári. ");
INSERT INTO isd_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ay nán natu Jose kitu ári, “Akkan iyà, ápu, ya makekagi ki kustu nga sarut daya tagenap mu, nu di e Dios sala,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ay díkod nán natu ári kitu Jose, “Tagenap ku nga atán nà kanu mà a magsisíkád ki dappit Nile. ");
INSERT INTO isd_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ay pagkìlát ku kanu mà ala ya pittu wa nappiya se nallùmag ga báka nga gummàdáng gayát kitu wángag. Ay se dala kanu mà a nagárab kitu katub-tubngán. ");
INSERT INTO isd_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ay se la uwad kanu mà manin pittu nga báka nga naniw-níwáng nga nagpag-pagrát tu tàgáng da. Pissán ku pikam makasingan ka ummán kadatun ki ngámin Egipto. ");
INSERT INTO isd_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ay datu naniw-níwáng nga báka, ay kinnán da kanu mà datu nunna nga pittu nga nallúmag. ");
INSERT INTO isd_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ngamay oray kitu nakkán da ngin datu nallùmag ga báka, ay akkan ta pe makagi nga kinnán dada ta, it-ittu da kam ma naniw-níwáng. Ay se yà a nalukág. ");
INSERT INTO isd_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ay kane matúdug gà manin ay uwad manin tagenap ku. Tagenap ku nga uwad kanu mà nasingan ku nga pittu ngabgát ta ammay ki isa nga dáwa. Nabgát se nalútu kanu mà datu ammay. ");
INSERT INTO isd_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ay uwad kanu mà nasingan ku pe nga pittu ngabgát ta pabeg lappit se nakarsi kitu dáwa. Nakarsi da gapu ki bal-báli nga maggayát ki lattakán. ");
INSERT INTO isd_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ay datu pabeg lappit ta ammay, ay sillan da kanu mà datu nabgát. Kinagi ku dedi yin kadaya mamasírib, ngamay áwan ya makesarut kaggída,” nán tu ári. ");
INSERT INTO isd_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ay tútu nán natu Jose kitu ári, “Daya duwa nga tagenap mu, ápu, ay sissa kam ya sarut da,” nán na. “Nepakammu ne Dios kikaw, ápu ári, ya palánu na nga kuwaan kídi. ");
INSERT INTO isd_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ya sarut datu pittu wa nallùmag nga báka se datu pittu ngabgát ta ammay nga nabgát ay sissa kam. Pittu dagun ya sarut da. ");
INSERT INTO isd_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ya sarut datu pittu wa naniw-níwáng se nagpag-pagrát ta tàgáng nga báka se datu pittu ngabgát ta ammay nga lappit se nakarsi gapu ki bal-báli nga gayát ki lattakán, ay pittu dagun na ulát. ");
INSERT INTO isd_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ummán kitu nán ku win kikaw, ápu ári, nepakammu ne Dios kikaw ya palánu na nga kuwaan. ");
INSERT INTO isd_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Atán pittu dagun na adu tutu wala ya maápit tada ngámin kanedi Egipto. ");
INSERT INTO isd_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ngamay kalpasán nayán, ay sumarunu pe yin ya pittu dagun na ulát. Ay áwan tada akadamdam nu wà ummán natu pittu dagun nin na adu tutu wala ya ápit tada, áta palotán ya ulát, ay marápun daya umíli nu áwan sumeng kaggída. ");
INSERT INTO isd_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Maligpanán daya tolay pe yin datu pittu dagun na adu tutu wala ya ápit tada, ta palotán tutu wala ya ulát kiyán. ");
INSERT INTO isd_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Duwa ya nangidalenán ne Dios kiya piyán na kagiyan kikaw, ápu ári, áta napalánu na ngin, ay se tagay ya kàwa na pe yin. ");
INSERT INTO isd_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Ay díkod sumápul ka ngin, ápu ári, ka isa nga laláki nga nabobot se nasírib. Aggína ya pakammuwan mu ki ngámin Egipto. ");
INSERT INTO isd_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Pumíli ka pe, ápu ári, kadaya ù-upisiyál nga ittu daya magpaurnung ka pagkalimma daya ap-ápit da tolay ki ngámin Egipto kiya pittu dagun na adu tutu wala ya ápit tada. ");
INSERT INTO isd_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ay paurnung mu pe kaggída ya ngámin na mabunna da kadaya dagun na adu tutu wala ya maápit da. Magpàwa ka ka álang kadaya il-íli nga ittu ya pangipintàán kadayán. Ay se mu la nga pabantayán. Ingágan mu dayán kikaw, ápu ári. ");
INSERT INTO isd_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ngámin dayán, ay sagáma da ngámin para kadaya dagun na aggulát naya ngámin Egipto, ta senu akkan matay da tolay ki ulát,” nán natu Jose. ");
INSERT INTO isd_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ay pàgan natu ári se datu ù-upisiyál na tun na palánu. ");
INSERT INTO isd_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ay nán natu ári kadatu ù-upisiyál na, “Awan tada masmà a tolay ya nasì-sírib may idi ya tolay, ta atán kaggína ya Ispiritu ne Dios,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ay díkod, nán natu ári kitu Jose, “Ay gapu ta nepakammu ne Dios kikaw ngámin dedi, inna nád pikam mala ya nalàlaing se nasì-sírib may ikaw? ");
INSERT INTO isd_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ikaw ya pakammuwan ku kídi pangiturayán ku. Ngámin na kagiyam ay ikurug dedi nga tolay ku. Ikaw ya sumarunu kiyà ki turáy,” nán natu ári. ");
INSERT INTO isd_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","“Ikaw win ya pakammuwan ku ki ngámin Egipto,” nán natu ári. ");
INSERT INTO isd_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ay se la nga linàmut natu ári tu sangkilat ta immamarka na se na isangkilat kitu Jose ka pakasinnán ki turáy natu Jose. Binaduwán na pe ka dilána, ay se na pe sipattallán ka kadena nga balitù. ");
INSERT INTO isd_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ay pinagtakay na pe tu Jose kitu mekàduwa nga takay na. Ay se na nán kadatu tolay, “Magukkab kayu!” nán na. Díkod pinagbalin na ka apu tu Jose ki ngámin Egipto. ");
INSERT INTO isd_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ay nán pikam natu ári kitu Jose, “Iyà ya ári kídi Egipto, ngamay áwan oray inna ki ngámin Egipto ya makàwa ka oray nágan nu akkan mu ipalúbus,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Ay nengágan natu ári tu Jose ka Zafenat Panea. Ay niddán na pe ka atáwa na. Tu Asenat ta pútut tu Potifera nga pádi ka íli On tu inatawán na. Ay díkod nagbalin ka naturáy Jose ki ngámin tu Egipto. ");
INSERT INTO isd_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Tallu púlu dagun tu Jose yin kaggína nga manggayát ta magsirbi kitu ári ka Egipto. Ay díkod nagpakáda tu Jose kitu ári, se na nawe dinàdàdà tu ngámin il-ileli ka Egipto. ");
INSERT INTO isd_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ay kadatu pittu dagun na adu ápit datu tolay, ay adu tutu wala kurug datu ápit da. ");
INSERT INTO isd_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ay pinaurnung natu Jose ngámin datu pagkalimma datu ápit da kitu nunna nga pittu dagun, se na nga nepippáy kadatu al-álang da kadatu il-ileli ka Egipto. Datu ápit datu il-ileli, ay naurnung se neálang kampela ngin nin kitun na íli. ");
INSERT INTO isd_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Ay adu tutu wala datu ammay ya napaurnung tu Jose. Inupatán da bilángan tu kaadu na, ta ummán ka kaadu ginat ki bebay tu kaadu na. ");
INSERT INTO isd_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ay kitu akkan pikam inumbet tu ulát, ay duwa ngin datu annánà tu Jose se tu Asenat ta an-anà natu Potifera nga pádi ka On. ");
INSERT INTO isd_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Nepangágan tu Jose tu manákam ka Manase. Ata nán na nga, “Pinakaligpanán ne Dios kiyà datu rig-rígát kun, se ya katalekág ku ke ama se kadatu wawwágì,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ay nán na pe nga, “Niddán nà e Dios ka pútut ku kídi íli nga nagrig-rigátan ku,” nán na. Ay tútu nengágan na tu udiyán na an-anà na ka Efraim. ");
INSERT INTO isd_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ay kane pumanda ngin tu pittu dagun na aggaápit da ka Egipto, ");
INSERT INTO isd_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ay nanggayát pe yin tu pittu dagun na ulát nga ummán kitu nepadtu natu Jose. Molát ngámin datu duddúma nga íli. Ngamay ka Egipto, ay adu tu kanan datu tolay kitúni. ");
INSERT INTO isd_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ay nu áwan kanan datu iEgipto win, ay magadang da kitu ári ka kanan da. Ngamay, “Mawe kayu ke Jose. Nu nágan naya kagiyan na kadakayu, ay ittu ya kuwaan nu,” nán na kaggída. ");
INSERT INTO isd_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Díkod molát ngámin nin datu il-íli ka Egipto, ay tútu nagpalawán tu Jose yin kadatu álang, ay se na iláku kadatu tolay. ");
INSERT INTO isd_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ay ngámin tolay ki ngámin kalawagán nin datu naglalbet ka Egipto nga gumátang ka kanan da kitu Jose, áta palotán tu ulát ki ngámin kalawagán. ");
INSERT INTO isd_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ay kane magìna tu Jacob nga adu ammay da ka Egipto, ay nán na kadatu annánà na, “Ay nágan na kuwaan nu, tura kayu wala di magkínin!” nán na. ");
INSERT INTO isd_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","“Nagìnà nga adu kanan da ka Egipto. Mawe kayu magkálap kattoni, ta senu akkan tada matay ki bisin,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ay díkod datu sangapúlu kadatu kasiyoma tu Jose, ay nawe da ka Egipto nga gumátang ka baggát. ");
INSERT INTO isd_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ngamay akkan nepekíwid tu Jacob tu Benjamin na wagi natu Jose. Ata iamà na, ta get atán màwa nga nadakè kaggína. ");
INSERT INTO isd_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Díkod nebulun datu magwawági kadatu duddúma nga mawe gumátang ka kanan da ka Egipto, ta molát da pe ka Canaan. ");
INSERT INTO isd_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ay gapu ta tu Jose tu gubernador ka Egipto, ay aggína tu magláku ka ammay kadatu ngámin tolay ki kalawagán. Ay inumbet pe yin datu wawwági na. Nagukkab da panda kitu lusà kitu àráng na. ");
INSERT INTO isd_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Ay kane masingan natu Jose datu wawwági na, ay nalásin nada. Ngamay nagpìduman na akkan nada am-ammu. Ay nepar-par-áng na tu nagsaludsud kaggída nga nán na, “Ka wàna naggayatán nu ta?” nán na. Ay nán da, “Ka íli Canaan, ápu. Inumbet kami nga gumátang ka kanan mi,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Am-ammu natu Jose nga wawwági na datun, ngamay akkan da am-ammu nga aggína tun. ");
INSERT INTO isd_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ay se la nadamdam tu Jose datu tag-tagenap na mepanggap kaggída, nga magukkab da kaggína. Ay tútu nán na kaggída, “Ispiya kayu kammala ngin nin a. Inumbet kayu kanedi, ta we nu sinnan nu inna ya pagkapsútán naya íli mi, se da kami la gubatan,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","“Akkan, ápu,” nán da. “Inumbet kami ngala nga gumátang ka kanan mi. ");
INSERT INTO isd_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Sissa ama mi ngámin. Namáru kami nga tolay, ápu. Akkan kami wayya nga ispiya,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ngamay, “Akkan a! Inumbet nu sinnan ya pagkapsútán naya íli mi, ay se da kami la gubatan,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ay nán da kaggína, “Sangapúlu se duwa kami nga magwawági, ápu. ICanaan kami, ay sissa ama mi ngámin. Ay ya ud-udiyán kadakami, ay atán kam ka balay nga kabulun ama, ay ya isa ay natay yin,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Ngamay nán natu Jose kaggída, “Kustu ya nán ku nga ispiya kayu. ");
INSERT INTO isd_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Tu idi ya kuwaan ku ka paninnán ku nu kurug akkan kayu ispiya. Isingán ku kiya ngágan naya ári kanedi nga akkan kayu makappan panda ki angilbet nu kanedi kiya udiyán na wagi nu nga nán nu. ");
INSERT INTO isd_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ipàrob nu ya isa kadakayu, ta we na nga alà ya isa nga wagi nu. Ngamay mabansi nga mabálud daya duddúma kadakayu kanedi. Sinnan ku nu kurug daya kag-kagiyan nu. Ngamay nu akkan, ay isingán ku ki ngágan ári nga kurug ispiya kayu,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ay se nada nepebálud ngámin ki unag tallu ngalgaw. ");
INSERT INTO isd_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ay kitu mekàlu ngalgaw, ay nán natu Jose kaggída, “Managgansing ngà ke Dios nga tolay. Díkod tu idi ya kuwaan nu, ta senu akkan takayu papatay. ");
INSERT INTO isd_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Nu kurug ga namáru kayu nga tolay, ay bansiyan nu ya isa kadakayu nga mebabálud. Ay daya duddúma kadakayu ay mawe da ngin na ippan kadaya mabis-bisinán na akkobung da ya ammay nga ginátang nu. ");
INSERT INTO isd_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ay se nu wa ilbet kanedi ya udiyán na wagi nu, ka pakammuwán ku nga kurug daya kag-kagiyan nu, ay díkod akkan takayu papatay,” nán na. Ay ittu kurug tu kinuwa da. ");
INSERT INTO isd_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ay se la nán natu isaisa kaggída, “Magikáru tada ngin kitu nadakè a kinuwa tada kitu wagi tada. Ata nasingan tada tu pannakit na kitu nakim-imallà na kadàtada, ngamay akkan tada nga ginì-gìna. Ay díkod tu idi pe yin ya pagpannakitán tada,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ay nán tu Ruben kaggída, “Nán ku mà kammala ngin nin kadakayu nga akkan nu an-anuwan, ngamay akkan dà pà-pàgan. Ay ittu pe yin idi ya pannakapánis tada gapu kitu nekatay na,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ngamay akkan da am-ammu nga naawátan tu Jose ngámin datu kinag-kagi da. Ata kitu nakibàbànán na kaggída, ay uwad nga tarupiti da. ");
INSERT INTO isd_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ay díkod pinanáwan tu Jose da, ta nawe sumángit. Ay kane daddán, ay inumbet manin kitu giyán da, se nada inamomanán. Ay se na nga itùgud tu Simeon, se na pinapíngil kitu pagmar-marngán da ngámin. ");
INSERT INTO isd_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Ay se la pinapnu tu Jose datu ngámin na langgusti da ka ammay. Ay se nepippáy na kammin pe datu pirapirà da kitu langgusti da. Piniddán nada pe ka bálun da nga magulli. Ay díkod kinuwa datu bobonan na ngámin dayán. ");
INSERT INTO isd_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ay díkod netakay datu wawwági tu Jose ngámin nin datu ammay kadatu asnu da, ay se da la nga nawe. ");
INSERT INTO isd_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ay kane magimáng da kitu pagdagusán da, ay iddán kuma natu isa kaggída tu asnu na ka kanan na. Ngamay nasdaáwan ta tu pirà a pinagbáyad na, ay nepanin-otun kitu mayán natu langgusti na. ");
INSERT INTO isd_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ay díkod nán na kadatu wawwági na, “Sinnan nu kod! Atán kod mà kammin tu pirà ku kídi langgusti ku!” nán na. Ay tútu nalídug da, ay magtartartar da ngin kitu ansing da. Ay nán tu isaisa kaggída, “Nágan nedi nga kinuwa ne Dios kadàtada?” nán da. ");
INSERT INTO isd_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ay kane dumatang da ka Canaan nga giyán tu ama da nga Jacob, ay kinagi da ngámin datu napas-pasámà kaggída. Ay nán da, ");
INSERT INTO isd_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Pinar-par-áng nakami tu tolay ya apu da kitu íli. Padalínán nakami pe ka magis-ispiya kitu íli da ngi. ");
INSERT INTO isd_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ngamay nán mi kaggína nga, ‘Namáru kami nga tolay. Akkan kami wayya nga ispiya. ");
INSERT INTO isd_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Sangapúlu se duwa kami nga magwawági nga pabeg lalláki. Sissa ya ama mi ngámin. Natay ya isa ngin, ay ya udiyán mi, ay atán kannán Canaan nga giyán mi. Kabulun ne ama,’ nán mi. ");
INSERT INTO isd_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ay díkod nán natu apu da kitúni, ‘Tu idi ya pakammuwán ku nu kurug namáru kayu wa tolay,’ nán na. ‘Bansiyan nu pikam ya isa kadakayu. Ay daya duddúma, ay mawe da ngin na ippan ya ammay nga ginátang nu kadaya akkobung nu wa mabis-bisinán. ");
INSERT INTO isd_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ay se nu ilbet kanedi ya udiyán pànang nga wagi nu. Ay díkod ammuwán ku nga kurug namáru kayu nga tolay, nga akkan kayu wayya nga ispiya. Ay iddè kammin ya wagi nu kadakayu, ay se annung nu pe yin ya maggà-gátang se maglà-láku kanedi íli mi,’ nán na,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ay kane ùbuwán da ngin datu langgusti da, ay atán kammin datu pir-pirà a pinagbáyad da kadatu langgusti da. Ay kane masingan da se tu ama da datu pir-pirà da, ay nagansing da. ");
INSERT INTO isd_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ay nán tu Jacob nga ama da, “Ummawan daya pútut ku win gapu ki angwa nu. Awan tu Jose yin, áwan Simeon nin, ay kídi manin piyán nu manin na alà e Benjamin. Tura dà pagpan-pannakitan ta!” nán na. ");
INSERT INTO isd_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ay se la nán tu Ruben kitu ama na, “Nu akkan ku nga milbet kammin ne Benjamin, ay oray nu patayan mu datu duwa nga annánà ku wa lalláki. Ipindu mu la kiyà, ay iyà ya makammu nga mangilbet kaggína kammin kikaw,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ngamay nán na, “Akkan mabalin na ikíwid nu we Benjamin! Natay yin tu wagi na, ay sissa ngin na nabansi nga pútut ku kiya maniyumán kadakayu. Ay nu tura la atán màwa kaggína nga nadakè kiya dálen nu wa mawe, ay matay yà tutu wala ngin. Làlakay yà pànang ngin, ay ipatay ku ya pannakit ku win,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Napalotán tutu wala tu ulát kitu íli Canaan. ");
INSERT INTO isd_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ay kane mammin da tu ammay nga ginátang da ka Egipto, ay nán tu ama da kaggída, “Mawe kayu manin gumátang ka bittì a kanan tada,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ngamay nán ne Juda kaggína, “Kinagi tutu wala natu tolay nga akkan kami magpas-passingan kaggína, nu akkan mi kabulun ya wagi mi. ");
INSERT INTO isd_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ay nu pekíwid mu ya wagi mi kadakami, ay mawe kami nga gumátang ka kanan tada. ");
INSERT INTO isd_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ngamay nu akkan mu pekíwid, ay maddi kami mawe, áta kinagi tutu wala natu apu nga akkan kami magpassingan kaggína, nu akkan mi kabulun ya wagi mi,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ay nán tu Israel nga ama da, “Tura nu pe kinagi kaggína nga atán pikam isa nga wagi nu ta! Tura dà niddán ka pagproblemaán ku!” nán na. ");
INSERT INTO isd_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ay summungbát da nga nán da, “Kinappiya nakami tutu wala nga sinal-saludsúdán tu tolay. Sinaludsud na ngámin ya panggap kadakami se kadaya induan mi. Sinaludsud na pe nu sibbiyág pikam ya ama mi. Sinaludsud na pe nu atán pikam sabáli wagi mi. Ay sinungbátan mi yala datu saludsud na kadakami. Wayya mi la nga ammu nga pilbet naya wagi mi!” nán da. ");
INSERT INTO isd_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ay nán natu Juda kitu ama da, “Pekíwid mu win kiyà ya ababbing, ta senu makarbuwát kami yin, ta senu akkan tada nga matay ngámin se daya annánà ki bisin. ");
INSERT INTO isd_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Iyà ya makakaammu kaggína. Nu akkan ku meulli kammin na simbibiyág, ay iyà ya makin-básul ki áwan panda. ");
INSERT INTO isd_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ata nung kuma ta akkan tada nga tinàtàtà ya rubbuwát mi, ay oray namidduwa kami yin na nagpat-patoli,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ay tútu nán natu Israel kaggída, “Nu ittu ya masápul la kuwaan nu, ay ittu ya màwa. Ngamay tu idi pe ya kuwaan nu: mangitúgut kayu kadaya kapíyán na búnga káyu kanedi ta idde nu kiya apu ka panaruanggam nu kaggína. Mangalà kayu kadaya bang-bangug se pangrikádu, se digu álig, se piniones se almendras ");
INSERT INTO isd_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ay ya pirà a itúgut nu, ay mamidduwa pe ya kaadu na kitu nunna. Ipatulli nu pe tu pirà a nasmà nu kadatu langgusti nu, ta get nasábag da ngala. ");
INSERT INTO isd_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ay ikíwid nu pe ya wagi nu, se kayu mawe lugud manin kitu apu. ");
INSERT INTO isd_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ay e Dios nga mannakabalin nala ya magkallà kadakayu kiya akiamomán nu manin kitu tolay, ta senu pekíwid na kadakayu nge Simeon se e Benjamin nu magulli kayu. Ay nu masápul la umawan kiyà daya pútut ku, ay iturad ku wala,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ay díkod nangalà datu magwawági kadatu panaruanggam da, se da dinuble tu bíláng tu netúgut da nga pirà kitu nunna, ay se da pe nga nekíwid tu Benjamin, ay se da ngin na nagrubbuwát nga mawe ka Egipto. Ay kane dumatang da, ay nawe da nga nagpassingan kitu Jose. ");
INSERT INTO isd_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ay kane masingan natu Jose nga kabulun da tu Benjamin, ay nán na kitu pakammuwan na kitu balay na, “Ippan mu daya tolay ka balay, ay se ka nga magparti ka mesida se ka mamotun pe yin ta mepangán dedi nga tolay kiyà nu agpapásu,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ay díkod kinuwa natu tolay tu nán tu Jose. Díkod nippan na datu magwawági kitu balay tu Jose. ");
INSERT INTO isd_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ay nagansing datu magwawági kane ippan dada kitu balay tu Jose. Ay nán da, “Ippan ditta ka balay na gapu kid kadatu pirà a nasuwà tada kammin kadatu langgusti tada. Waya na idi yin na mamabásul kadàtada, ta senu atán pambarán na nga mangasassu kadàta se mangalà kadaya asnu tada,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ay díkod nawe da kitu pakammuwan da kitu balay tu Jose se da inamomanán nala kitu gagyangán natu balay. ");
INSERT INTO isd_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Ay nán da, “Apu, kitu nunna nga neà-angay mi kanedi nga gumátang ka ammay, ");
INSERT INTO isd_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ay tura nepatulli kammin kadakami ngámin datu pirà a pinagbáyad mi. Nammuwán mi kane dumatang kami kitu dagus mi. Kane lùtán mi datu langgusti mi, ay tura la atán datu pirà mi nga áwan nàsáy. Ay díkod nilbet mi da kammin. ");
INSERT INTO isd_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ay se nangitúgut kami ka sabáli nga pirà ka igátang mi manin ka kanan mi. Akkan mi ammu nu inna tu nangippáy kammin kadatu pirà mi kadatu langgusti mi,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ay summungbát tu tolay ya nán na, “Akkan kayu wa malídug. Akkan kayu pe nga magansing. Ta ya Dios nu nga Dios kam naya ama nu ya nagpippáy ka pirà kadatu langgusti nu ka para kadakayu. Nálà ku mà datu pir-pirà nu,” nán na. Ay se na nga nelawán tu Simeon. ");
INSERT INTO isd_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ay nippan natu tolay da ka balay tu Jose. Ay kane dumatang da, ay niddán nada ka pinagusesu da. Ay niddán na pe datu asnu da ka kanan da. ");
INSERT INTO isd_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ay nesagána pe datu magwawági datu panaruanggam da kitu Jose, ta idde da kaggína nu umbet nu agpapásu. Ata nakagi da kaggída nga mamásu da kitúni. ");
INSERT INTO isd_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ay kane umbet tu Jose yin kitu balay na, ay nilbetán da pe yin datu panaruanggam da kaggína, ay se da nga nagukkab panda kitu lusà ka ammatag da kaggína. ");
INSERT INTO isd_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ay se la sinaludsud tu Jose nu mapà-paanna kam ya biy-biyág da. Ay nán na, “Ay tu ama nu, tu làlakay nga nán nu kitun, sibbiyág pikam? Nabílag kam?” nán na. ");
INSERT INTO isd_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ay nán da, “Saay, ápu. Sibbiyág se nabílag kam nge ama,” nán da. Ay se da nga nagpalintud se nagukkab kitu àráng na. ");
INSERT INTO isd_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ay se na nasingan tu Benjamin na kurug wagi na kane iapág natu mata na. Ay nán na, “Aggína tu nán nu kiyà kitun na ud-udiyán na wagi nu? Kalakkán naka ne Dios, ugu!” nán na. ");
INSERT INTO isd_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","May nagkirut nagtálaw tu Jose ta ningbáwan pànang kitu wagi na, ay magissasangit tin. Ay tútu nawe summángit kitu isa nga kuwartu. ");
INSERT INTO isd_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ay se la nga nagidárup se la nga lumawán. Ay se na la nga nán kadatu bobonan na kane madurayán na ngin tu uray na, “Ara ngin. Magdasár kayu win,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ay díkod dinasarán da tu Jose nga sissa. Ay dinasarán da pe datu wawwági na kampela ngin nin. Ay nesibna kampela datu iEgipto win kaggída, áta kannawan datu iEgipto tu mepangán kadatu Hebreo. Ata melalais kanu datu iEgipto nu mepangán da kadatu Hebreo. ");
INSERT INTO isd_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ay díkod nagtugaw da ngámin kitu àráng tu Jose. Ay nagsasarunu da manggayát kitu manákam panda kitu udiyán. Ay magsisinningan da ngala ta pagballà da tu kà-kàwaán da. ");
INSERT INTO isd_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Maggayát kitu tebol natu Jose datu idasár da kaggída. Ay tu binglay tu Benjamin, ay mamillimma tu kaadu na kitu kuwa datu duddúma. Ay nepangán se nepaginum da kitu Jose, ay naggan-gánas da ngámin. ");
INSERT INTO isd_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ay se la nga binílin tu Jose tu pakammuwan na kitu balay na nga nán na, “Pannuwam datu langgusti da ka ammay panda kitu mabaal da akkatan. Ay ippáy mu kammin pe daya pir-pirà da kadaya langgusti da ki otun ammay. ");
INSERT INTO isd_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ay se mu ippáy pe ya napatag akap ku kitu langgusti natu udiyán kaggída kabulun natu pirà na kiya otun na ammay,” nán na. Ay kinuwa kurug natu pakammuwan da kitu balay tu kinagi tu Jose. ");
INSERT INTO isd_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ay kane nawà-wada ngin kitu pagmakát, ay pinapan dada ngin. Nelúgán da datu agtu da kadatu asnu da. ");
INSERT INTO isd_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ay kane makaadayyu da ka bittì kitu íli, ay nán tu Jose kitu pakammuwan na kitu balay na, “Ara, mawe mu da aplan. Ay nu masìmát muda, ay nán mu kaggída, ‘Tura pe nadakè ya pagsubálit nu ki napiya ta! Tura nu sinákaw ya napatag ga akap na apu ku? ");
INSERT INTO isd_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ittu mà yán ya agginumán na, se ittu pe yán ya us-usaran na nga mamadtu. Nakabásul kayu a kurug kaggína,’ nán mu kaggída,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ay nawe kurug impal natu pakammuwan ne Jose da. Ay díkod kane masìmát nada, ay kinagi na kurug datu na pekagi tu Jose. ");
INSERT INTO isd_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ay nán da kaggína, “Taanna, ápu, tura ummán kiyán ya aggun-únim! Wayya mi la nád màwa ya ummán kiyán? ");
INSERT INTO isd_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ay datu pirà a nasuwà mi kadatu langgusti mi kitun, ay nepatulli mi da mà. Ay tura mi mán kammin na takáwan ya pirà onu balitù naya apu mu! ");
INSERT INTO isd_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ay nu iinna ya pakasmàán mu kiyán na akap, ay papatay mu, ay dakami nga mabansi ay paasassu kami pe yin kikaw,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ay tútu nán na, “Mayát tà kiya nán nu, ngamay ya pakasmàán ku wala kiya akap ya magbalin ka asassu ku. Ay daya duddúma kadakayu ay akkan da nga mapabásul,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ay díkod dintagán da nga dágus datu agtu da, ay se da nga bùliyán datu langgusti da. ");
INSERT INTO isd_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ay ginayatán na kurug tu magsápul kitu akap. Ginayatán na kitu manákam panda kitu udiyán kaggída. Ay nasmà na tu akap kitu langgusti tu Benjamin. ");
INSERT INTO isd_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ay kane mammuwán datun, ay pinìsi da datu bádu da ta magpannakit da. Netakay da kammin datu agtu da kadatu asnu da, ay se da ngámin magulli kammin kitu íli. ");
INSERT INTO isd_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ay kane dumatang de Juda nga magwawági kitu balay tu Jose, ay atán kam tu Jose kitúni. Ay díkod nagukkab da kitu lusà kitu àráng na. ");
INSERT INTO isd_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ay nán tu Jose kaggída, “Taanna, tura nu kinuwa yán! Akkan nu ammu nga iyà ay annung ku ammuwan ya panda ngala oray akkan ku nasingan?” nán na. ");
INSERT INTO isd_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ay nán natu Juda kaggína, “Akkan mi ámmu ya kagiyan mi kikaw, ápu. Ay áwan mi pe makagi. Akkan mi pe ammu nu nágan naya kuwaan mi, ta senu kurugan nakami nga áwan mi kinuwa nga nadakè. Ammánis kid Dios idi kadakami. Magasassu kami kikaw win, ápu, dakami ngámin se iya wagi mi nga nakasmàán nu kitu akap,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ngamay nán tu Jose, “Akkan. Akkan ummán kiyán ya kuwaan ku. Tittu ya nakasmàán kitu akap ya magbalin ka asassu ku. Ngamay nu dakayu, mawe kayu win kiya ama nu. Awan nu wa básul, ay díkod áwan pe màwa kadakayu.” ");
INSERT INTO isd_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ay se la nga umadanni tu Juda kitu giyán na, ay se na nán, “Apu, gìnám agpà ya kagiyan ku. Akkan nà agpà a lùsawan, ta atán kagiyan ku. Ammù a ummán ki turáy na ári mismu ya turáy mu. ");
INSERT INTO isd_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Sinaludsud mu mà kadakami, ápu, nu atán pikam ama mi se nu atán wagi mi. ");
INSERT INTO isd_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ay kinagi mi kikaw, ápu, nga atán ama mi may làlakay yin, ay se atán pikam pe isa nga wagi mi nga udiyán mi nga pútut ne ama kiya kalàlakay na. Uwad wagi na, ngamay natay yin. Díkod sissa ngin na an-anà ne ama kitu isa nga atáwa na. Ay pà-pàgan tutu wala ama yán na udiyán mi. ");
INSERT INTO isd_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ay se pinilbet mu kadakami ta nán mu wa piyán mu wa masingan. ");
INSERT INTO isd_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ay kinagi mi kikaw nga akkan mapanáwan na ababbing ya ama mi, áta ipatay ne ama ya keadayyu naya ababbing. ");
INSERT INTO isd_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","May nán mu kadakami nga nu akkan mi ikíwid ya udiyán mi, ay akkan kami tagge magpassingan nin kikaw. ");
INSERT INTO isd_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ay kane magulli kami ke ama, ay kinagi mi kaggína datu kinagim kadakami. ");
INSERT INTO isd_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Ay kane pagulliyan nakami manin ne ama kanedi nga gumátang ka kanan mi, ");
INSERT INTO isd_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ay kinagi mi kaggína nga akkan kami makapagulli, ta akkan kami makapagpassingan kitu apu nu akkan mi kabulun ya udiyán na wagi mi. ‘Mawe kami la nu pekíwid mu kadakami ya wagi mi nga udiyán,’ nán mi kaggína. ");
INSERT INTO isd_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ay tútu nán ne ama kadakami, ‘Ammu nu nga dudduwa dayán na annánà ku kitu naniyumán kadakayu. ");
INSERT INTO isd_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Tu isa ay áwan nin. Nán ku kitun na kinnán ulolag. Ay áwan ku nasingan nin kaggína ka panda. ");
INSERT INTO isd_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ay nu itálaw nu manin idi ya isa, ay se tura la atán màwa nga nadakè kaggína, ay ipatay ku tutu wala ngin ya agpannakit ku,’ nán na. ");
INSERT INTO isd_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Díkod ummán ka ya biyág ne ama, ay atán kiya ababbing. Díkod nu magulli kami ke ama nga áwan ya an-anà, ");
INSERT INTO isd_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ay ipatay na ya pannakit na, nu áwan na masingan na kabulun mi ya an-anà. Ay dakami ya bátug gapu naya pannakatay ne ama, nu tura la kurug ga matay gapu ki pannakit na gapu kiya an-anà. ");
INSERT INTO isd_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ta iyà, ápu, ya makakaammu kiya ababbing. Kinagì ke ama nga, ‘Nu akkan ku mepatulli ya ababbing kikaw, ay iyà ya mapabásul ka panda ki agbiyág ku.’ ");
INSERT INTO isd_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Díkod, pangaásim agpà ala, ápu, ta iyà ala ngin ya magbansi nga magasassu kikaw, akkan ya an-anà. Pekíwid mu agpà ala ngin ya ababbing kadaya wawwági ku nga magulli kammin ke ama. ");
INSERT INTO isd_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ta akkan nà makapagulli ke ama nu akkan ku kabulun ya an-anà. Lùsawan ku sinnan ya nadakè a màwa ke ama nu akkan na nga masingan ya an-anà,” nán tu Juda. ");
INSERT INTO isd_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ay akkan tutu wala madurayán tu Jose yin tu aggissa-sangit na. Ay tútu pinatálaw na ngámin datu bobonan na nga atán kitu giyán na. Díkod tittu tu Jose se datu wawwági na kane magpakammu kaggída. ");
INSERT INTO isd_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ay se la nga nagogolán tu Jose. Ay díkod nagìna datu iEgipto se datu bobonan tu ári tu sangit na. ");
INSERT INTO isd_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ay nán tu Jose kadatu wawwági na, “Iyà e Jose. Sibbiyág pikam kurug ama?” nán na. Ngamay akkan makasungbát datu wawwági na ta nagansing da. ");
INSERT INTO isd_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ay díkod nán tu Jose kadatu wawwági na, “Umbet kayu kod kídi.” Ay ummadanni da kurug kaggína. Ay nán na manin, “Iyà e Jose nga wagi nu, nga neláku nu kitun kadatu maglà-láku, ay neláku dà kídi Egipto. ");
INSERT INTO isd_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Akkan kayu magpannakit, se akkan nu pe lùsawan daya baggi nu kampela ngin gapu ki nangiláku nu kiyà kanedi. Ata ittu ya nangidalenán ne Dios kiya nagpainunna na kiyà kanedi, ta senu iyà ya mamiyág kadakayu. ");
INSERT INTO isd_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ata duwa dagun nin idi nga ulát, ay limma dagun pikam ma áwan makapagmúla, ay díkod áwan pe magáni. ");
INSERT INTO isd_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Pinaginunna nà e Dios kanedi, ta senu biyágan takayu se daya akkobung nu, ay díkod gumánab kayu. ");
INSERT INTO isd_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Díkod ya kurug na, ay akkan dakayu ya nangipàrob kiyà kanedi, nu di e Dios. Pinagbalin nà ka kangatuwán na upisiyál naya ári. Iyà ya pakammuwan naya ári ki ngámin na iturayán na, ay se iyà pe ya mangitur-turáy ki ngámin Egipto. ");
INSERT INTO isd_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ara mawe kayu win, ta we nu kagiyan ke ama nga pinagbalin nà nge Dios ka apu daya ngámin iEgipto. Kagiyan nu kaggína nga palbetan ku kanedi. Ay karuwan na ya umbet. ");
INSERT INTO isd_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ta magyán kayu ngámin ka íli Gosen, dakayu se ngámin da annánà nu, se daya ngámin na animál nu, se daya ngámin na kuw-kuwa nu. ");
INSERT INTO isd_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ay tarànan takayu kattoni. Iddán takayu ka kanan nu, ta limma dagun pikam idi nga ulát. Ta nu akkan, ay mabis-bisinán kayu ngámin se daya tarakan nu wa animál. ");
INSERT INTO isd_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ay nasingan dà in na mismu, ay oray ye Benjamin na wagi ku, ay nasingan na nga iyà mismu kurug idi nga makibàbànán kadakayu. ");
INSERT INTO isd_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ara, mawe kayun, ta ilbet nu we ama kanedi. Ikagi nu kaggína nu mapaanna ya angrispitár da tutu wala kiyà kanedi Egipto. Ay kagiyan nu pe kaggína ngámin daya nas-asingan nu.” ");
INSERT INTO isd_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ay se na nga ginàbal tu Benjamin na wagi na se sumángit. Ay sumángit pe tu Benjamin. ");
INSERT INTO isd_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ay sumángit pe nga nangummà kadatu wawwági na. Ay se la pe yin na nakiamomán datu wawwági na kaggína. ");
INSERT INTO isd_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ay kane madámag natu ári nga inumbet datu wawwági ne Jose, ay naganggam se datu upisiyál na. ");
INSERT INTO isd_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ay nán tu ári kitu Jose, “Kagiyam kadaya wawwágim nga tàyán da daya asnu da ka ammay, se da la nga magulli kammin ka Canaan. ");
INSERT INTO isd_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Pálà mu kaggída nge ama nu se daya akkobung na, se da umbet kammin kanedi. Pekagim nga iddè kaggína ya kapíyán na giyán kanedi Egipto. Ay adu ya makkán kanedi Egipto nga pagbiyág da. ");
INSERT INTO isd_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Masápul la ikagim pe kaggída nga maggalà da kadaya karisun kanedi Egipto nu mawe da ngin, ta pangitàyán da kadaya annánà da se kadaya attáwa da. Ay se da la nga umbet kammin kanedi kabulun da nge ama nu. ");
INSERT INTO isd_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Akkan da paglídug daya kuw-kuwa da nga mabansi, áta iddè kaggída daya kapíyán kanedi Egipto,” nán natu ári kitu Jose. ");
INSERT INTO isd_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ay kinurug datu annánà tu Israel tu kinagi natu ári. Ay niddán tu Jose da ka karisun, se nada pe pinabalúnán nga ummán kitu kinagi natu ári. ");
INSERT INTO isd_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Niddán nada ka aggisa da nga páris sa pagsukatán da nga bádu nga nappiya. Ngamay niddán na tu Benjamin ka tallu gatut ta pirà nga pinaláta se limma páris nga nappiya nga bádu nga pagsukatán na. ");
INSERT INTO isd_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ay tu ama na, ay pinaw-ítán na ka sangapúlu wa asnu nga napakagtuwán kadatu nappiya nga pruduktu nga gayát ka Egipto. Niddán na pe ka sangapúlu nga babbay ya asnu nga napakagtuwán ka ammay se sinápay, se duddúma pikam ma akakkanan nga masápul na nu umbet ka Egipto. ");
INSERT INTO isd_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ay se na ngin pinapan datu wawwági na. Ay binílin nada kane magrubbuwát da ngin. “Akkan kayu a nga magsasáwad ki dálen,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Díkod nagrubbuwát da ka Egipto. Ay kane dumatang da ka Canaan, kitu balay Jacob nga ama da, ay ");
INSERT INTO isd_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","nán da kaggína, “Sibbiyág kod mà e Jose! Aggína ya ap-apu ki ngámin Egipto,” nán da. Akkan nakoni tu Jacob. Akkan nada nga kurugan. ");
INSERT INTO isd_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ngamay kane kagiyan da ngin ngámin datu kinag-kagi tu Jose, ay se kane masingan na datu karisun na pinálà tu Jose kaggída nga pangitàyán da kaggína, ay pummiya tu uray na. ");
INSERT INTO isd_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ay nán tu Jacob, “Nágan na pikam mala ya masápul ku ammuwan? Sibbiyág pikam gáyám me Jose nga an-anà ku! Masápul mawe yà a sinnan ki kasibbiyág ku pikam,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ay díkod inalà tu Jacob ngámin datu kuw-kuwa na, ay se la nga nagrubbuwát nga mawe ka giyán Jose. Ay kane dummatang ka Beerseba, ay nagdátun ke Dios, nga Dios pe natu Isaac nga ama na. ");
INSERT INTO isd_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ay kitu gabi, ay inamomanán ne Dios kitu ummán ki tagenap na. Ay nán na, “Jacob, Jacob!” nán na. “Inna tun, Apu,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ay se nán ne Dios, “Iyà e Dios, nga Dios natu ama mu. Akkan ka nga magansing nga mawe ka Egipto, ta kitúni, ay pagbalinan ku ka adu tutu wala daya gakagaka mu, ay magbalin da ka abay nga nasiyon. ");
INSERT INTO isd_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Bulunan taka nga mawe ka Egipto, ay alà ku kammin daya gakagaka mu kanedi nga íli. Nu matay ka ngin, ay e Jose ya mamaluggagsát kikaw,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ay se la nagrubbuwát tu Jacob ka Beerseba. Netakay datu pútut na ka karisun nga nidde natu ári nga pangitàyán da kaggína. Netakay da pe datu pútupútut da, se datu attáwa da kadatu karisun. ");
INSERT INTO isd_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Netúgut da pe datu ngámin na báka da, se ngámin na kuw-kuwa da nga naurnung da kitu nag-agyán da ka Canaan. Díkod nawe tu Jacob ka Egipto kabulun na ngámin datu gakagaka na; ");
INSERT INTO isd_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","datu ngámingámin annánà, se datu ngámingámin appúku na. ");
INSERT INTO isd_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Tu dedi ya ngag-ngágan datu iIsrael nga pútupútut kam tu Jacob nga nawe ka Egipto: Tu Ruben nga manákam nga pútut na ");
INSERT INTO isd_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","se datu ngámin pútupútut tu Ruben nga lalláki nga ittu de Hanoc, tu Pallu, tu Hezron, se tu Carmi. ");
INSERT INTO isd_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Tu Simeon nga pútut Jacob se datu pútupútut na nga lalláki nga ittu de Jemuel, Jamin, Ohad, Jakin, Zohar, se tu Saul nga pútut na kitu iCanaan na babay. ");
INSERT INTO isd_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Tu Levi nga pútut tu Jacob se datu pútupútut na nga lalláki nga ittu de Gerson, tu Kohat, se tu Merari. ");
INSERT INTO isd_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Tu Juda nga pútut tu Jacob se datu pútupútut na nga lalláki nga ittu de Er, Onan, Sela, Perez, se Zera (ngamay natay tu Er se tu Onan ka Canaan). Kabulun da pe datu pútupútut tu Perez nga tu Hezron, se tu Hamul. ");
INSERT INTO isd_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Tu Isacar nga pútut tu Jacob se datu pútupútut na nga lalláki nga de Tola, Puva, Yob, se tu Simron. ");
INSERT INTO isd_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Tu Zebulun nga pútut tu Jacob se datu pútupútut na nga lalláki nga ittu de Sered, tu Elon, se tu Jaleel ");
INSERT INTO isd_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","(tu dayán datu annánà de Jacob se tu Lea nga neanà ka Paddan-aram. Ay uwad pe tu Dina nga pútut na nga babay. Tallu púlu se tallu ngámin datu pútupútut tu Jacob kitu Lea). ");
INSERT INTO isd_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Datu pútupútut natu Gad nga lalláki, ay tu Zifion, tu Aggi, tu Suni, tu Ezbon, tu Eri, tu Arodi, se tu Areli. ");
INSERT INTO isd_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Datu pútupútut tu Aser nga lalláki, ay tu Imna, Isva, Isvi, Beria, se tu Sera nga wagi da nga babay. Ay kabulun da pe datu pútupútut tu Beria nga lalláki nga ittu de Heber, se tu Malkiel ");
INSERT INTO isd_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","(tu dayán datu pútupútut tu Jacob kitu Zilpa nga asassu da nga nidde tu Laban kitu Lea nga pútut na. Sangapúlu se annam da ngámin). ");
INSERT INTO isd_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ay datu pútupútut natu Jacob nga lalláki kitu Raquel, ay tu Jose, se tu Benjamin. ");
INSERT INTO isd_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Ay datu pútupútut natu Jose nga lalláki ay tu Manase se tu Efraim nga annánà na kitu Asenat, nga an-anà tu Potifera nga pádi ka On. Neanà da ka Egipto. ");
INSERT INTO isd_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Ay datu pútupútut tu Benjamin nga lalláki, ay tu Bela, Beker, tu Asbel, tu Gera, tu Naaman, tu Ehi, tu Ros, tu Muppim, tu Huppim, se tu Ard. ");
INSERT INTO isd_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","(Tu dayán datu pútupútut natu Jacob kitu Raquel. Sangapúlu se appát da ngámin). ");
INSERT INTO isd_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Nawe ka Egipto pe tu Dan se itu Husim nga pútut na nga laláki. ");
INSERT INTO isd_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nawe pe tu Naftali se datu pútupútut na nga lalláki nga ittu de Jazeel, tu Guni, tu Jezer, se tu Sellim. ");
INSERT INTO isd_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","(Tu dayán datu pútupútut natu Jacob kitu Bilha nga asassu da nga nidde natu Laban kitu Raquel. Pittu da ngámin). ");
INSERT INTO isd_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ay ya dágup ngámin datu pútupútut tu Jacob nga nawe ka Egipto, ay annam púlu se annam da ngámin. Akkan meráman datu attáwa datu pútupútut na nga lalláki. ");
INSERT INTO isd_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ay datu pútupútut tu Jose nga lalláki ay dudduwa da. Ya dágup datu ngámingámin na akkobung natu Jacob nga inumbet ka Egipto ay pittu púlu. ");
INSERT INTO isd_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Pinaginunna natu Jacob tu Juda nga mawe kitu giyán tu Jose nga mangagi kaggína nga sabtan nada ka Gosen. Ay díkod dumatang da ka Gosen. ");
INSERT INTO isd_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Ay tu Jose, inalà na tu lúgán na, se na nawe sinabat tu ama na nga Israel ka Gosen. Ay kane makaadanni kaggína, ay ginàbal na se la sumángit ka nabayág. ");
INSERT INTO isd_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ay nán natu Israel kitu Jose, “Ay oray yà ala matay yin, ta nasingan taka ngin na sibbiyág,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ay nán ne Jose kadatu wawwági na se kadatu akkobung natu ama na, “Mawe yà kagiyan ke ári nga atán kayu win nga naggagayát ka Canaan, dakayu se de ama nga inumbet mepagyán kiyà kanedi. ");
INSERT INTO isd_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Kagiyan ku pe kaggína nga magtar-tarakan kayu ka karneru se daya duddúma nga an-animál. Kagiyan ku kaggína nga nilbetán nu ngámin daya tarakan nu se ngámin daya kuw-kuwa nu. ");
INSERT INTO isd_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ay nu palbetan nakayu ya ári, ay se na saludsúdan nu nágan naya ubra nu, ay ");
INSERT INTO isd_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","kagiyan nu wala kaggína nga magtar-tarakan kayu ka karneru se daya duddúma nga animál. Kagiyan nu wa ittu yán ya ubra nu nanggayát kitu kabibittì nu, ay se ittu yán pe ya ubra datu apuapu nu. Ittu yán ya kagiyan nu ta senu pagyanan nakayu ka Gosen. Ata lùsawan daya iEgipto ya mepagyán kadaya maragtarakan ka karneru,” nán tu Jose. ");
INSERT INTO isd_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Ay díkod nawe tu Jose kinagi kitu ári nga nán na, “Atán de ama ngin se datu wawwágì nga gayát ka Canaan. Inalà da ngámin datu karneru se kalding se datu báka da, se ngámin na kuw-kuwa da. Atán da ka Gosen nin,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ay se na inayabán ya limma kadatu wawwági na, ay se nada nga iam-ammu kitu ári. ");
INSERT INTO isd_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Ay nán natu ári kadatu wawwági tu Jose, “Nágan naya ubra nu?” nán na. Ay nán da nga summungbát kitu ári, “Maragtarakan kami ka karneru, ápu, nga ummán kadatu man-mannákam mi,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","“Inumbet kami, ápu, nga makipastu ka makaru wala kanedi giyán nu, ta áwan mi mabalin pangipastorán kadaya karneru mi kannán Canaan, ta napágus tutu wala ya ulát kannán. Ay túya nu mabal-balin kuma ngala, ápu, ay magyán kami nga makaru ka íli Gosen,” nán da kitu ári. ");
INSERT INTO isd_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ay se la nán natu ári kitu Jose, “Atán nin ne amám se daya wawwágim. ");
INSERT INTO isd_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ay ikaw ya makammu ki ngámin lusà kídi Egipto. Pagyanan muda ka Gosen, ta ittu ya kapíyán na lusà kanedi Egipto. Ay nu atán ammum kaggída nga makammu magpastor, aggída ya pakammuwan mu kadaya bákà,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ay se la nga nilbet tu Jose tu Jacob nga ama na kitu giyán tu ári. Ay binindisiyonán tu Jacob tu ári. ");
INSERT INTO isd_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Ay nán natu ári kitu Jacob, “Piga dagun mu win?” nán na. ");
INSERT INTO isd_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Ay nán tu Jacob kitu ári, “Magatut se tallu púlu win, ápu ya dagun ku. Abibbà ya biyág ku se narígát pànang nga akkan ummán kadatu mannákam ku. Adaddu tu inagbiyág da oray nagali-alit da pe,” nán tu Jacob. ");
INSERT INTO isd_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ay binindisiyonán manin tu Jacob tu ári, se la nga nawe yin. ");
INSERT INTO isd_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ay díkod pinagyán tu Jose tu ama na se datu wawwági na ka Egipto. Niddán nada ka lusà da kitu giyán nga adanni ka íli Rameses, ta ittu tu kapíyán na lusà kannán. Ittu yán tu kinagi natu ári nga kuwaan na. ");
INSERT INTO isd_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ay niddán tu Jose tu ama na se datu wawwági na se datu ngámin na akkobung natu ama na ka kanan da. Nepà-pànung na kampela ngin nin ki kaadu naya tangabalay. ");
INSERT INTO isd_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Napágus tu ulát pikam ka Egipto se ka Canaan, ay díkod áwan kanan datu tolay. Ay tútu kumapsut da ngámin. ");
INSERT INTO isd_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ay tu Jose tu naurnúngán ngámin datu pir-pirà datu tolay ka Egipto se Canaan ta negatángan da ka ammay kaggína. Ay se na nippannán datun kitu ári. ");
INSERT INTO isd_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ay kane mammin tu pirà datu tolay yin ka Egipto se Canaan, ay áwan da ngin na igátang. Ay umbet datu tolay kitu Jose nga magadang ka kanan da. “Iddán dakami mán ka kanan mi. Akkan dakami agpà pagdudoray yala nga matay. Awan mi tutu wala nga pirà in,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Ngamay nán tu Jose kaggída, “Ay nu áwan nu pirà in, ay oray daya animál la ngin ya ikálap nu ki kanan nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ay díkod nilbetán da pe yin datu báka da kitu Jose. Niddán tu Jose da ka kanan da. Kasukát datu kabalyu da, karneru da, báka da, onu datu asnu da. Ay niddán nada ka kanan da kitun na dagun ka kasukát datu báka da. ");
INSERT INTO isd_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ay kane malpás tun na dagun, ay inumbet manin datu tolay kitu Jose. Ay nán da kaggína, “Akkan metuláyaw kikaw, ápu nga áwan ya ngámingámin nin kadakami. Awan mi pir-pirà in, ay áwan mi tutu wala báka pe yin. Tittu win ya lusà mi se ya baggi mi ya nabansi yin. ");
INSERT INTO isd_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Akkan dakami agpà pagdudoray ta lùsawan mi ya matay. Gatángan dakami yala ngin se daya lusà mi. Iddán dakami yala ka kanan mi. Magasassu kami yala ngin kiya ári, ay se kuw-kuwa na pe daya lusalusà mi. Iddán dakami ka ammay ya pagbiyág mi se talìgì mi, ta senu atán agpà imúla mi, ta senu akkan masáyang ya lusà,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ay díkod nagátang tu Jose ngámin datu lusà ka Egipto para kitu ári. Ata neláku ngámin datu iEgipto datu tal-tálun da, ta napágus tutu wala tu ulát ka Egipto. Díkod, ngámin datu tálun da, ay kuw-kuwa natu ári da ngámin nin. ");
INSERT INTO isd_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ay pinagbalin tu Jose ngámin datu tolay ka asassu natu ári. Nilbetán na ngámin datu tolay kadatu il-íli ki ngámin Egipto. ");
INSERT INTO isd_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Tittu datu lusà datu pappádi tu akkan ginátang tu Jose. Ata atán ya suwildu datu pappádi nga gayát kitu ári. Ay ittu tun tu pinagbiyág da. Ay díkod akkan da tagge neláku datu lusà da. ");
INSERT INTO isd_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Ay díkod nán natu Jose kadatu tolay, “Kídi yin, ay ginátang takayu ngámin nin se daya tal-tálun nu nga kuw-kuwa naya ári tada. Iddán takayu ka aggì, ay mulán nu daya tal-tálun nu. ");
INSERT INTO isd_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ay nu aggagáni, idde nu ya pagkalimma naya maápit nu kiya ári. Ay ya appát ta pagkalimma ay ittu ya kuwa nu. May ráman nayán ya aggì nu se kanan nu wa tangabalay,” nán tu Jose. ");
INSERT INTO isd_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ay nán datu tolay, “Biniyág nakami. Metul-túluy kuma ya kinamárum kadakami, ápu. Magasassu kami yala kiya ári,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Díkod gapu kitu Jose, ay ittu tun tu lintag da panda kadedi nga al-algaw ka ngámin Egipto, nga midde kiya ári ya pagkalimma naya ápit da tolay. Tittu datu lusà datu pappádi datu akkan nepakin-kuwa kiya ári. ");
INSERT INTO isd_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ay díkod datu gakagaka natu Jacob nga ittu datu nepangágan ka Israelita, ay nagyán da ka Egipto ka íli Gosen. Umadu da tutu wala kitúni, ay se bumànáng da pe kitúni. ");
INSERT INTO isd_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Sangapúlu se pittu dagun na nagyán tu Jacob ka Egipto. Dinatang na ya magatut se appát púlu se pittu dagun se la natay. ");
INSERT INTO isd_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ay kane tagay matay tu Jacob bin, ay pinalbet na tu Jose, ay se na nán kaggína, “Nu pàgan nà, ay atán mán ya ipàwà kikaw. Ippáy mu ya ímam kiya panìgad lappu ku, ay se mu isipata kiyà nga ipatag nà, se kuwaan mu ya ipàwà kikaw. Akkan dà itaman kanedi Egipto. ");
INSERT INTO isd_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Nu matay yà ay itálaw dà kanedi Egipto. Itaman dà kitu neketamnán datu ama ku se kakay ku,” nán na. Ay nán tu Jose, “Ò, ama. Ittu yán ya kuwaan ku nu ittu ya piyán mu,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ay nán tu Jacob, “Isipatám kiyà nga kurug ga kuwaan mu yán,” nán na. Ay nesipata natu Jose kurug. Ay se la nga nagùmà tu Jacob kitu ùluwán natu káma na ka aggiyáman na. ");
INSERT INTO isd_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Akkan nabayág ka panda, ay uwad nangidámag kitu Jose nga magtakit tu ama na. Díkod, nawe da nga maggaáma se tu Manase se tu Efraim. ");
INSERT INTO isd_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ay kane dumatang da, ay kinagi da kitu Jacob, “Atán ne Jose nga pútut mu nga maggagáyám kikaw,” nán da. Ay díkod, pinaturínán na la tu bumángun se magtugaw kitu káma na. ");
INSERT INTO isd_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ay nán tu Jacob kitu Jose, “E Dios nga mannakabalin, ay nagpassingan kiyà ka íli Luz ka Canaan. Binindisiyonán nà, ay se na ");
INSERT INTO isd_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","nán kiyà, ‘Paganában taka se paaduwan ku tutu wala daya gakagaka mu, ta pagbalinan kuda ka adu wa nagbal-baláki nga nas-nasiyon. Ipakin kuwa ku pe idi Canaan kaggída ka kuw-kuwa da ka áwan panda,’ nán na. ");
INSERT INTO isd_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ay de Manase se Efraim nga pútupútut mu wa lalláki nga neanà kanedi Egipto kitu akkan ku pikam ma nilalbet kanedi, ay bíláng annánà kuda nga ummán kade Ruben se Simeon. ");
INSERT INTO isd_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ay daya pútupútut mu pikam nga lalláki, ay ittu dayán daya pútut mu. Akkan ku ibíláng pútut ku dayán. Ay ipatáwid mu kaggída daya ipatáwid mu kuma kade Manase se Efraim. ");
INSERT INTO isd_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Kuwaan ku idi gapu kitu ina mu wa Raquel. Nipnakit ku tutu wala tu nekatay na kitu naggayát mi ka Paddan. Uwad kami yin ka Canaan kitu nekatay na. Tare kami ad-adayyu pikam kitun ka Efrata (Betlehem kam yán). Ay tútu netaman na la ngin kitúni, kitu adanni kitu bíkat kalsáda nga mameyag ka Efrata.” ");
INSERT INTO isd_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ay kane masingan tu Israel datu pútupútut tu Jose nga lalláki, ay nán na, “Iin dedi?” nán na. ");
INSERT INTO isd_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Ay nán tu Jose, “Pútupútut ku dayán nga nidde ne Dios. Neanà dayán kanedi,” nán na. Ay nán tu Israel, “Ilbet muda mán kídi giyán ku, ta senu mabindisiyonán kuda,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Ay gapu ta làlakay pànang tu Jacob bin, ay ittu tu akkan makasingan nin. Ay tútu nippan natu Jose datu annánà kitu giyán na. Ay ginàbal nada se nada pe umàán. ");
INSERT INTO isd_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ay nán natu Jacob kitu Jose, “Akkan ku innanamán na masingan taka manin. Ngamay, sinnam, nepalúbus ne Dios nga masingan taka se daya pútupútut mu pe,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ay se la nga inalà tu Jose datu pútupútut na nga neaàrun kitu Jacob, ay se nagukkab panda kitu lusà kitu àráng na. ");
INSERT INTO isd_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ay se la nga nilbet manin natu Jose tu Efraim se tu Manase kitu giyán tu Jacob. Nepanin-kasígid tu Efraim kaggína, ay nepanin-diwanán tu Manase. ");
INSERT INTO isd_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ngamay pinagbangkál na datu íma na se na neparotun tu diwanán na kitu Efraim, oray nu aggína tu udiyán, se itu kasígid na ay neparotun na kitu Manase nga ittu tu manákam. ");
INSERT INTO isd_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ay se na bindisiyonán da nga nán na, “E Dios nga ittu ya sinur-súrut datu mannákam ku nga Abraham se Isaac, ay aggína pe ya nagtag-tagasíngan kiyà panda kadedi ya al-algaw. ");
INSERT INTO isd_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Aggína pe ya nangibon ka anghel na nga nangiadayyu kiyà kadaya nadakè. Ay aggína ya magkallà kadedi nga annánà. Ay gapu kaggída, ay akkan mataatay ya ngágan ku se daya ngágan datu mannákam ku nga Abraham se Isaac; Ay umadu tutu wala kuma daya gakagaka da,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ay kane masingan tu Jose nga nepaparotun tu diwanán na kitu úlu ne Efraim, ay tareyan na. Ay nekalit na tu íma natu Jacob kitu úlu ne Manase. ");
INSERT INTO isd_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ay nán tu Jose kitu ama na, “Nasábag ka, ama. Ta idi ya manákam kaggída. Iparotun mu ya diwanán na ímam kaggína,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ngamay ipílit natu ama na tu piyán na nga nán na, “Ammù yán, ugu. Umadu pe daya gakagaka na, ay se magbalin pe ka naturáy. Ngamay ya udiyán na, ay magbalin ka natù-turáy may aggína. Ay daya gakagaka na, ay umadu da tutu wala pe, ay se magbalin da ka nagbal-baláki nga nas-nasiyon,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ay ittu lugud tun na algaw tu inangbindisiyon na kadatu annánà a nán na, “Daya iIsrael ay mamindisiyon da pe yin gapu kadaya ngag-ngágan nu. Ay nán da, ‘Pagbalinan nakayu we Dios ka ummán kade Efraim se Manase,’ nán da,” nán na. Ay díkod nepadúma tu Efraim kitu Manase kitu inangwa na. ");
INSERT INTO isd_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ay se la nga nán tu Israel kitu Jose, “Ammum nga tagay yà a matay yin. Ay e Dios sala ya mamul-bulun kikaw. Ay ipalúbus na kuma nga makapagulli ka kammin kiya íli daya man-mannákam mu. ");
INSERT INTO isd_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ay ya isa pe, ay tu lusà nga nálà ku kadatu Amorreo kane abákan kuda ki gubát, ay ikaw ya pangiddanán ku nga akkan wayya daya wawwágim nga lalláki,” nán natu Jacob. ");
INSERT INTO isd_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Ay se la nga pinàrawán tu Jacob ngámin datu pútupútut na nga lalláki. Ay nán na kaggída, “Magguurnung kayu ngámin kídi ta kagiyan ku kadakayu daya mà-màwa kadakayu kadaya masanguwánan na al-algaw. ");
INSERT INTO isd_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Magguurnung kayu se kayu manggìna, dakayu wa pútupútut ne Jacob. Gìnán nu ya kagiyan ne Israel nga ama nu. ");
INSERT INTO isd_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, ikaw ya manákam. Ikaw ya nunna nga pútut ku kitu kabílag ku pikam. Ikaw pe ya kadayáwan se ikaw ya katurayán kadaya pútut ku. ");
INSERT INTO isd_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ngamay ummán ka ka balnag nga akkan meturung. Díkod akkan ikaw win ya katurayán. Ata rinag-ragitán mu ya idda naya ama mu, se rinag-ragitán mu ya dáyaw na, ta inlay mu ya naniyumán kikaw. ");
INSERT INTO isd_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Dakayu Simeon se Levi, dakayu nga magwagi naranggás kayu kadaya ampiláng nu. ");
INSERT INTO isd_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Akkan ku iannúgut ya uray ku kadaya lam-lammat nu. Maddi yà pe makilangláng kiya bungguy nu. Ta pummatay kayu gapu wala ta atán lùsawan nu, ay se ur-uráyan nu wala nga piltángan daya báka. ");
INSERT INTO isd_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Nadakè kuma ya kapàyanán daya gakagaka nu, ta áwan nu agkallà nu malùsaw kayu. Nadakè kuma ya kapàyanán nu, ta narawat kayu nu makarungat kayu. Ay túya mawara-warà kayu kuma kanedi, ay metar-tarerà kayu kanedi íli Israel. ");
INSERT INTO isd_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Ikaw Juda, ay pàgan daka daya wawwágim ma lalláki. Abákan mu daya kumalínga kikaw. Ay ngámin daya wawwágim ma lalláki ay dayáwan daka. ");
INSERT INTO isd_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ikaw, ay árig mu ya bumarítu wa láyon. Nu mabalin mu kanan ya nígay mu, mawe ka kammin kiya agsiruán mu. Magidda ka nga magimáng nga ummán kiya kuwaan daya láyon. Ay áwan naturad da manglukág kikaw. ");
INSERT INTO isd_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ikaw Juda, ay magturáy peyapeyang daya gakagaka mu, Panda ki ilalbet naya magturáy nga ittu kurug ya katurayán. Ay aggína ngin ya kur-kurugan da tolay se day-dayáwan da. ");
INSERT INTO isd_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Kiya kapíyán na múla úbás ya pangigalútán mu kiya urbun asnu mu, ta adu tutu wala ya múla mu wa úbás. Annung mu sùnaán ya bádum ki bási úbás, ta daggáy tutu wala ya bási mu. ");
INSERT INTO isd_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Dumgáng daya mata mu ki agginum mu ki bási úbás, Ay magkappag ka pe ka gátas. ");
INSERT INTO isd_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Ikaw Zebulun, daya gakagaka mu, ay mag-agyán da ki dappit bebay, nga dudungán daya ngámin bir-biray. Panda ka Sidon ya lusà mu, áta kurug ga abay. ");
INSERT INTO isd_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Ikaw Isacar, daya gakagaka mu, ay árig da ya nakulnit ta asnu; mag-agyán da kiya tulatúlad daya púkù daya karneru. ");
INSERT INTO isd_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Kane masingan da nga napiya nga giyán tu nagimangán da, se kitu lusà ay natalobu da mul-múla da, ay akkan da pinagan-anu tu magrígát, nagasassu da ngala ngin oray tu apu da ay narawat. ");
INSERT INTO isd_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Ikaw Dan, daya gakagaka mu, ay aggída ya mangguwes kadaya tolay da, ta isa da pe nga netangámalán ka Israel; ");
INSERT INTO isd_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Meárig ka ki idaw nga atán ki dálen, nadíta nga idaw ki bíkat dálen; nga nu tugkawwan na daya síkil daya kabalyu nga manalen ay daya magtatákay, ay mapalikud da nga mekálin. ");
INSERT INTO isd_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Id-idaggán ku, O APU, ya algaw wa angngalà mu kadakami nga tolay mu. ");
INSERT INTO isd_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Ikaw Gad, daya gakagaka mu, ay rautan daya tirung da. Ngamay labánan dada, ay se dada aplan. ");
INSERT INTO isd_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ikaw Aser, daya gakagaka mu, ay namit peyang daya kan-kanan da, ay daya akakkanan daya à-ári, ay aggída ya paggayatán da. ");
INSERT INTO isd_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Ikaw Naftali, daya gakagaka mu, ay ummán da ka nakulasit nga ugta, nga nakagan-gánas daya bibittì a urbun da. ");
INSERT INTO isd_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Ikaw Jose, daya gakagaka mu, ay árig da ya nabúnga tutu wala nga pasanga naya múla úbás nga ki adanni ki awweg ya nagtubuwán da; ay kumaray-kay da ki darupírip abut daya pas-pasanga da. ");
INSERT INTO isd_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Bút-bútug daya marammútug; gangngatan da, se pagan-anitán dada tutu wala; ");
INSERT INTO isd_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ngamay akkan nala nga makínin datu pas-pasanga da. Nasikan datu im-íma da, ta pinasikan ne Dios nga Mannakabalin nga Dios ne Jacob, e Dios nga árig Maragtarakan ka karneru, se aggína ya mangigdù kadaya iIsrael; ");
INSERT INTO isd_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","e Dios ya sumeng kaggída, nga Dios naya ama da, e Dios nga Mannakabalin ki ngámin, ay ittu ya magkallà kaggída, kadaya pagkallà a maggayát ka lángit ummán ki udán, se daya pagkallà a maggayát ki taggad lusà, ummán ki gabbuwà, se ya pagkallà nga adu annánà. ");
INSERT INTO isd_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ya bindisiyon nga nidde kiyà nga ama mu, ay napatag da pà-pànang may daya atán peyapeyang nga ban-bantay, se daya midde daya akkan mippaippà a babbalantay. Ngámingámin dayán ay mepakin-kuwa da ngámin kadaya gakagaka mu, Jose, nga nepadúma kadaya wawwágim. ");
INSERT INTO isd_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Ikaw Benjamin, daya gakagaka mu, ay árig da ya narungat ta átu wa alsádu; Inalgaw se ginnabi, atán peyang ya nígay da nga kanan da, ta abákan da daya kalínga da nga makigubát kaggída” nán na. ");
INSERT INTO isd_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ay ittu dedi daya sangapúlu se duwa nga apuapu nga magtatangámalán ka Israel. Ay ittu dayán datu kinag-kagi natu ama da kaggída kitu inangbindisiyon na kaggída, sigun kitu mepà-pànung kitu isaisa kaggída. ");
INSERT INTO isd_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ay se na la nga binílin datu pútupútut na nga nán, “Kídi yin ay tagay yà matay yin. Piyán ku nu itaman dà kammin kitu liyáng ka Macpela, nga netamnán datu man-mannákam ku nga atán kitu tálun tu Efron nga Heteo. ");
INSERT INTO isd_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Ya Macpela, ay atán ki dáya na Mamre ka Canaan. Ginátang tu Abraham kitu Efron nga Heteo tu lusà nga giyán natu liyáng ka agtamnán tada. ");
INSERT INTO isd_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Kattoni ya netamnán natu apuapu tada nga Abraham se itu Sara nga atáwa na. Ay itunni pe ya netamnán natu kakay nu wa Isaac se tu ukò nu wa Rebecca. Ay itunni pe ya nangitamnán ku kitu atáwa ku nga Lea. ");
INSERT INTO isd_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Nagátang tuni yin na lusà. Ay itaman dà kitu liyáng nga atán kitúni,” nán natu Jacob. ");
INSERT INTO isd_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ay kane mabalin na nga binil-bílin datu pútupútut na, ay nagidda ngin, ay ittu pe yin tu nekatay na. ");
INSERT INTO isd_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Ay se la nga naglàbán natu Jose tu ama na, ay se la nga magsángit se na pe inum-ummàán. ");
INSERT INTO isd_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ay se nepabalsamár tu Jose tu ama na kadatu tolay na nga iEgipto nga maragbalsamár. Ay díkod binalsamár da tu Jacob bin. ");
INSERT INTO isd_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ay appát púlu wa algaw tu namalsamár da kaggína, nga ummán kitu gangay ya panagbalsamár da. Ay pittu púlu walgaw tu nagmanakit datu iEgipto kaggína. ");
INSERT INTO isd_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ay kane mabalin tu nagmanakit da kaggína, ay nán natu Jose kadatu upisiyál natu ári, “Ipangaási nu agpà, ta ikagi nu mán ke ápu ári nga kitu tagay matay yin ne ama, ay ");
INSERT INTO isd_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","pinagsipata nà a itaman ku kammin kitu liyáng nga kinuwa na ka agtamnán da ka Canaan. Ay díkod palubúsán nà din nga mawe mangitaman kaggína. Ay se yà a magulli kammin,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ay nán natu ári kaggína, “Ara lugud, mawe mu itaman ya ama mu, nga ummán kitu sinipataán mu kaggína,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ay díkod nawe netaman tu Jose tu ama na. Ay kumíwid pe ngámin datu ù-upisiyál natu ári, se datu ngámin na agtuturáy ka Egipto. ");
INSERT INTO isd_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Ay kummíwid pe datu akkobung tu Jose, datu wawwági na, se datu akkobung natu ama na. Tittu datu bibittì a annánà ya nabansi ka Gosen, se datu kak-kalding se kak-karneru se datu bak-báka da. ");
INSERT INTO isd_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ay adu tutu wala datu kummíwid kaggína. Datu suldádu, ay sittatakay da kadatu takay suldádu kampela ngin nin, ay atán pe datu nakakabalyu wala nga suldádu. ");
INSERT INTO isd_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ay kane dumatang da kitu agaggián ka Atad nga atán kitu dáya Jordan, ay naggiinnatay da manin. Nagsasángit da tutu wala manin. Ay pittu walgaw da manin na naggiinnatay kitúni. ");
INSERT INTO isd_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ay kane masingan datu iCanaan tu nagsasángit datu tolay kitu agaggián ka Atad, ay nán da, “Napgus gáyám ya aggiinnatay daya iEgipto,” nán da. Ay díkod nengágan datun na giyán na atán kitu dammáng Jordan ka Abel-mizraim. (Ya piyán na nga kagiyan yán ay tanáp daya iEgipto.) ");
INSERT INTO isd_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ay tinungpál kurug datu pútupútut natu Jacob tu nebílin natu ama da kaggída, ");
INSERT INTO isd_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","áta nippan datu baggi na ka Canaan se da netaman kitu liyáng kitu lusà ka Macpela nga adanni ka Mamre. Ittu tun tu lusà a ginátang tu Abraham kitu Efron na Heteo ka agtamnán da. ");
INSERT INTO isd_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Ay kane mabalin da magtal-ud, ay nagulli tu Jose yin ka Egipto kabulun na datu wawwági na se datu ngámin na nepagtal-ud kaggída kitu ama da. ");
INSERT INTO isd_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ay kalpasán natu pannakatay natu ama da, ay nalídug datu wawwági natu Jose nga nán da kitu isaisa kaggída, “Paanna nád nu lùsawan nitta pikam ne Jose, se nitta baltan gapu kadatu nadakè a kinuw-kuwa tada kaggína?” nán da. ");
INSERT INTO isd_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ay díkod nepekagi da ngala ngin kitu Jose nga nán da, “Kitu kasibbiyág pikam ne ama, ay nebílin na kadakami nga ");
INSERT INTO isd_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","ikagi mi kikaw nga pakawanan nakami kadatu kinuw-kuwa mi nga nadakè se datu bas-básul mi kikaw. Ay lugud kiddi yin ay pakawanan nakami din, ta ikur-kurug mi pe ye Dios, nga Dios natu ama tada,” nán da. Ay summángit tu Jose kane magìna na tu nepekagi da kaggína. ");
INSERT INTO isd_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ay kalpasán nayán ay inumbet pe datu wawwági na. Nagukkab da kitu àráng na se da nán kaggína, “Atán kami kídi, ta alà nakami ka asassu mu win,” nán da. ");
INSERT INTO isd_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ay nán natu Jose kaggída, “Akkan kayu magansing ta akkan takayu panísan ta akkan nà wayya nga Dios,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","“Ta oray nadakè tu panggap nu kiyà kitun, ay napiya mà tu panggap ne Dios, ta senu adu tutu wala daya tolay nga mabiyág, nga ummán ki nàwa kadedi nga al-algaw. ");
INSERT INTO isd_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Túya akkan kayu magansing, ta iyà ya makammu kadakayu se kadaya pútupútut nu,” nán na. Gapu kadatun na kinagi tu Jose se tu kinamáru na kaggída, ay bumagkad se pummiya datu uray da. ");
INSERT INTO isd_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Nagyán tu Jose se datu ngámin akkobung tu ama na ka Egipto. Magatut se sangapúlu dagun tu Jose se la nga natay. ");
INSERT INTO isd_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ngamay nasingan na pikam datu apúku tu Efraim se datu apúku tu Manase ke Makir nga an-anà na. Ay kinobung ne Jose da pikam pe. ");
INSERT INTO isd_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Ay nán tu Jose kadatu wawwági na, “Tagay yà a matay yin. May e Dios ya magtagasíngan kadakayu. Ay itálaw nakayu kanedi se na kayu ippan kiya lusà a nekari na kitu Abraham se kitu Isaac se kitu ama tada nga Jacob nga ipakin-kuwa na kaggída,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ay se la nebílin tu Jose kadatu kamungayán na nga Israelita nga nán na, “Isipata nu kiyà nga nu ippan nakayu ne Dios sin kiyán na lusà, ay alà nu pe daya tuláng ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ay natay tu Jose ka Egipto kitu magatut se sangapúlu tu dagun na. Binalsamár da se da nelungun.");
INSERT INTO isd_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Tu dedi daya ngag-ngágan datu pútupútut natu Jacob nga lalláki nga kummíwid kaggína ka Egipto. Kabulun da datu attáwa da se datu annánà da: ");
INSERT INTO isd_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","De Ruben, Simeon, Levi, de Juda, ");
INSERT INTO isd_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","de Isacar, de Zebulun, de Benjamin, ");
INSERT INTO isd_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","de Dan, de Naftali, de Gad, se de Aser. ");
INSERT INTO isd_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Ya dágup ngámingámin datu pútupútut se apúku natu Jacob ba kummíwid kaggína, ay pittu púlu, ta tu Jose nga an-anà na pe, ay napadán nin ka Egipto. ");
INSERT INTO isd_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Ay kane din mabayág ga dagudagun nin, ay natay de Jose nga magwawági yin, se datu annánà da, se ngámin datu tolay ya karusadán da. ");
INSERT INTO isd_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Ngamay gumánab datu pútupútut da nga ittu datu iIsrael. Nagánab da, ay díkod ummadu da tutu wala pànang, se nagbalin da ka nabílag tutu wala nga umíli. Ay tútu atán da pe yin kadatu ngámin giy-giyán ka Egipto. ");
INSERT INTO isd_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Ay kane din na mabà-bayág gin, ay baru wa ári yin tu magturáy ka Egipto. Idi nga ári, ay áwan na am-ammu mepanggap kitu Jose. ");
INSERT INTO isd_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ay isa ngalgaw nán natu ári kadatu tolay na, “Sinnan nu kod daya iIsrael. Adu da tutu wala pànang ngin. Ay túya nabílag da pe yin may dàtada. ");
INSERT INTO isd_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Masápul la siríbán tada da, ta senu akkan da umadu win. Ata nu akkan tada pakunán, ay se tura la nga atán manggubát kadàtada, ay se dala nga umamung nga pumane kadaya kalínga tada, ay ittu pe yanin ya agbarráw da ngin,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Díkod, tu kinuwa da, ay neapuwán dada. Pinar-parígát dada kadatu nadammat tutu wala nga nepà-paubra da kaggída. Pinàwa da kaggída datu íli Pitom se íli Rameses nga ittu datu il-íli nga agdarnán da kadatu kuw-kuwa da se akakkanan da. ");
INSERT INTO isd_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ngamay nu wà ummán natu ammaturù da kitu ammarígát da kaggída, ay naturù mán kammin pe tu ikà-adu da. Atán da kadatu ngámin giy-giyán nin. Ay díkod ummamà pànang datu iEgipto win kadatu iIsrael. ");
INSERT INTO isd_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Ay tútu áwan agkallà datu iEgipto win kadatu iIsrael kitu angngasassu da kaggída. ");
INSERT INTO isd_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Pinà-paultu dada kitu agsurbi da kadatu iEgipto. Pinagpaggus dada kitu angwa da kitu ladrilyu se kadatu nadammat tutu wala nga pà-paubra da kaggída kadatu tal-tálun datu iEgipto. Awan da agkallà kitu angipàwa da kaggída kadatu ngámin na nepà-paubra da kaggída. ");
INSERT INTO isd_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Ay tu ári ka Egipto, ay binílin na datu Hebreo nga mamalugganà nga de Sifra se Pua. ");
INSERT INTO isd_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Ay nán na kaggída, “Nu mamalugganà kayu kadaya iIsrael, ay patayan nu ngámin daya lalláki nga maladága, ngamay daya babbay ay biyágan nuda,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ngamay datu mamalugganà, ay magansing da ke Dios. Ay tútu akkan da kinurug tu bílin natu ári kaggída. Biniyág da datu annánà a lalláki. ");
INSERT INTO isd_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Díkod pinaayabán natu ári datu mamalugganà, ay se na nán kaggída, “Taanna, tura ummán kiyán ya kinuwa nu. Tura nu biniyág daya annánà a lalláki!” nán na. ");
INSERT INTO isd_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ngamay nán datu mamalugganà kitu ári, “Apu, daya babbay ya Hebreo, ay nabílag da. Ay túya nalà-lapat ya aggan-anà da, túya napardád da. Akkan kami pikam nakadatang, ay lumawán nin ya an-anà da. Akkan da ummán kadaya babbay ked Egipto wi.” ");
INSERT INTO isd_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Gapu kitun na kinuwa datu mamalugganà, ay kinalakkán ne Dios da, ta nagansing da kaggína. Pinagánab nada pe. Ay umadu la nga umadu datu iIsrael. Ay díkod bummílag da la nga bummílag ga umíli. ");
INSERT INTO isd_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ay díkod binílin natu ári datu tolay na nga nán na, “Alà nu ngámin daya maladága nga lalláki nga Hebreo se nuda illudán ngámin ki wángag Nile. Ngamay daya babbay, ay akkan nuda an-anuwan.” ");
INSERT INTO isd_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Kadatun na al-algaw, ay uwad isa nga laláki nga kaputútán tu Levi nga nangatáwa ka isa nga babay ya kaputútán tu Levi pe. ");
INSERT INTO isd_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Nabùsit tu babay, ay se nagan-anà ka laláki. Ay kane masingan na nga dumúma tu piya natu an-anà, ay nesir-sirù na ki unag tallu búlán. ");
INSERT INTO isd_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ay kane akkan na nga mesirù in, ay pinangwa na tu an-anà na ka idda na nga ummán ka làba nga sidaddu. Datu tubutúbung tu kinuwa na. Pinintaán na ka níkat tu úbat natu sinan làba, ay se na ipidda tu an-anà, ay se na mawe isrà kitu dappit natu wángag kitu giyán datu tubutúbung. ");
INSERT INTO isd_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ay tu babay ya wagi natu an-anà, ay nagsisíkád kitu ad-adayyu ta sin-sinnan na nu nágan tu màwa kitu an-anà. ");
INSERT INTO isd_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ay tu babay ya an-anà natu ári, ay nawe kitu wángag nga magdígut. Ngamay datu asassu na nga babbay nga kabulun na, ay nagdal-dalen da ngala kitu dappit. Ay se na la nga nasingan tu sinan làba kitu tubutúbung. Ay díkod pinálà na kitu isa kadatu asassu na. ");
INSERT INTO isd_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ay kane lùtán na, ay nasingan na tu an-anà a sumángit. Nakalakkán kaggína, ay nán na, “Isa kadaya annánà daya Hebreo idi ya an-anà,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Ay se la nga nán natu wagi natu an-anà a babay kitu an-anà natu ári, “Nu piyán mu, ay pagsápul taka kadaya babbay nga Hebreo ka managíbi kiya an-anà para kikaw,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Ay tútu, “Ara lugud,” nán tu an-anà natu ári. Ay díkod nawe tu an-anà, se na nga ayabán tu ina natu an-anà. ");
INSERT INTO isd_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Ay nán natu an-anà natu ári kitu ina, “Alà mu idi nga an-anà ta tagibiyam para kiyà, ay tangdánan taka,” nán na. Ay díkod inalà natu babay tu an-anà se na tagibiyan. ");
INSERT INTO isd_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ay kane umabay tu an-anà, ay nilbet natu babay kitu an-anà natu ári se na tagábuwan. Ay nán na, “Ingágan ku idi nga an-anà ka Moses, ta nasmà ku ki danum,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Isa ngalgaw kane umabay tu Moses sin, ay nawe na siningan datu kamungayán na nga Hebreo. Ay nasingan na nu wà ummán tu agrígát da kadatu nadammat ta ubra da. Ay uwad pe nasingan na nga iEgipto nga atán magpatay kitu isa nga Hebreo nga isa kadatu kamungayán na. ");
INSERT INTO isd_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Naglangalanga kitu lib-lebut na. Ay kane áwan na masingan, ay pinatay na tu iEgipto, ay se na itaman kitu karagintán. ");
INSERT INTO isd_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ay kane láwa natun, ay lumawán manin. Ay tura na la nasingan ya duwa nga Hebreo nga magpatay. Ay tútu nán na kitu nakabásul, “Tura mu pe la nga patayan ya kamungayán mu kam!” nán na. ");
INSERT INTO isd_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ay nán natu tolay nga summungbát, “Inna pe ya namagbalin kikaw ka apu mi se marangguwes kadakami ta? Asippatayan nà kid pe gane, nga ummán kitu nammatay mu kitu iEgipto,” nán na. Ay díkod nagansing tu Moses nga nán na, “Nammuwán da tolay yin 'kaw tu kinuwà,” nán na kitu lammat na. ");
INSERT INTO isd_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Ay kane mammuwán kurug natu ári, ay papatay na tu Moses sin. Ngamay nagbarráw tu Moses se la mawe ka íli Midian. Ay kane dumatang kitúni, ay nagtutúgaw wala ki bíkat tu isa nga bubun kitúni. ");
INSERT INTO isd_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Ay se la atán pe yin datu pittu wa babbalásang nga annánà natu pádi ka Midian. Inumbet da nga magsàdu ka ippáy da kadatu lútung ka inuman datu karneru natu ama da. ");
INSERT INTO isd_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ngamay uwad da pe inumbet nga magpas-pastor nga lalláki, ay se dada nga pàradan. Ay nigdù ne Moses da, ay se nada pe yin sengán nga magpenum kadatu ipas-pastor da. ");
INSERT INTO isd_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ay kane magulli da ngin kitu giyán tu Jetro nga ama da, ay nán na kaggída, “Tura kayu nakaru inumbet kídi nga algaw?” nán na. ");
INSERT INTO isd_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Tútu nán da, “Uwad isa nga laláki nga iEgipto nga nangigdù kadakami kadatu magpas-pastor nga lalláki, ay se nakami pe pinagsàdu se na pinenumán datu karneru.” ");
INSERT INTO isd_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ay tútu nán na kadatu pútupútut na, “Ka wàna giyán na ngin? Tura nu pinanáwan nala nga di inayabán kídi, ta senu mangán pikam!” Ay díkod inayabán da tu Moses. ");
INSERT INTO isd_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Panda kitun, ay nakikobung tu Moses sin kade Jetro. Ay nepaatáwa pe natu Jetro kitu Moses tu Zipora nga an-anà na. ");
INSERT INTO isd_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Nagan-anà ka isa nga laláki. Nán tu Moses nga, “Agtangeli yà kanedi nga giyán, túya ipangágan ku ka Gersom idi nga pútut ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Ay kane mabà-bayág gala ga dagudagun nin, ay natay tu ári ka Egipto. May datu iIsrael, ay ittu na kam ma makat-atúlág da kiya kapar-parigátan da gapu kitu angngasassu datu iEgipto kaggída. Ay tútu nakim-imallà da nga makiseng ke Dios. ");
INSERT INTO isd_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Nagìna ne Dios tu akat-atúlág da, ay tútu nepalammat kaggína tu kari na kade Abraham, de Isaac se de Jacob. ");
INSERT INTO isd_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Nasingan ne Dios tu kapà-pàyanán datu iIsrael, ay tútu nakalakkán kaggída. ");
INSERT INTO isd_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Ay díkod tu Moses sin tu magtar-tarakan kadatu karneru se kalding tu Jetro, nga katugángan na nga pádi ka Midian. Isa ngalgaw nippan na datu ipas-pastor na nga karneru kitu dammáng natu ir-ir-er. Ay dummatang kitu bantay Horeb, nga bantay ya agpassingannán ne Dios. ");
INSERT INTO isd_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ay kitúni, ay uwad anghel ne APU nga nagpassingan kaggína. Tu inagpassingan na, ay ummán ka apuy ya maggatagatang ki isa nga kaykayu. Kane masingan tu Moses tun, ay ummadanni. Ay gumata-gatang tu kaykayu ngamay akkan mà masìdug. ");
INSERT INTO isd_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Ay nán tu Moses kitu lammat na, “Wè mán sinnan yán na nakas-kasdáaw, ta tura akkan masìdug ya kaykayu kiyán,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ay kane masingan ne APU nga umadanni tu Moses nga mawe maningan kitu kaykayu, ay nagúni kitu kaykayu nga nán na kaggína, “Moses! Moses!” nán na. Ay nán tu Moses, “Inna tun, APU?” nán na. ");
INSERT INTO isd_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ay tútu nán ne APU kaggína, “Mamanda ka ngala kiyán. Ay ippà mu daya palluka mu, ta atán ka nga magsisíkád kiya nasantuwán na lusà. ");
INSERT INTO isd_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Iyà ya Dios natu ama mu, se Dios de Abraham, se de Isaac se de Jacob,” nán na. Ay tútu imput tu Moses tu múkát na ta magansing maningan ke Dios. ");
INSERT INTO isd_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ay se la nán ne APU kaggína, “Nasingan ku ya agrig-rígát daya tolay ku nga atán ka Egipto. Nagìna ku pe ya akim-imallà da gapu ki rawat daya mangitur-turáy kaggída. Sikkaammu wà kadaya kapar-parigátan da. ");
INSERT INTO isd_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ay ittu ya gapu na nga inumbet tà nga mangitálaw kaggída kiya biyáng daya iEgipto, ay se kuda itálaw kiyán na íli, se kuda ippan kiya abay se napiya nga lusà nga giyán daya ngámin masápul da. Ay ittu pe ya giyán pikam daya Cananeo, daya Heteo, daya Amorreo, daya Perizeo, daya Heveo, se daya Jebuseo. ");
INSERT INTO isd_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ay nagìnà kurug ya akim-imallà daya iIsrael, ay se nasingan ku tutu wala pe ya amal-pallà daya iEgipto kaggída. ");
INSERT INTO isd_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Ay túya ibon taka kiya ári ka Egipto, ta mawem alà daya iIsrael la tolay ku, se muda itálaw ka Egipto,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Ngamay nán natu Moses ke APU Dios, “Inna ngà nád pe yala nga mawe kiya ári ka Egipto nga mangalà kadaya iIsrael se mangitálaw kaggída ka Egipto!” nán tu Moses. ");
INSERT INTO isd_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ngamay nán ne APU DIOS, “Bulunan taka mà. Ay tu idi ya pakelasínan nga iyà ya nangibon kikaw: Nu metálaw mun daya iIsrael ka Egipto, ay day-dayáwan dà nga Dios nu kídi ya bantay,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ay se la nga nán tu Moses ke Dios, “Ay nu dumatang ngà kannán giyán daya iIsrael, ay se ku la nán kaggída nga, ‘Nebon nà ya DIOS daya apuapu nu,’ nu nán ku, ay se dala nga saludsúdan kiyà nu inna ya ngágan mu, ay nágan naya kagiyan ku kaggída?” nán tu Moses. ");
INSERT INTO isd_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ay tútu nán ne Dios kitu Moses, “Iyà ya Iyà,” nán na. Ay se na nán manin, “Tu idi ya kagiyan mu kadaya iIsrael la tolay ku, ‘Ya nagngágan ka Iyà ya Iyà, ay nepàrob nà kadakayu,’ nán mu,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ay nán pe ne Dios kitu Moses, “Ay nán mu kídi kadaya iIsrael, ‘Nge APU nga Dios datu apuapu nu wa Abraham, se de Isaac, se de Jacob, ya nangipàrob kiyà kadakayu,’ nán mu. Ay ittu yán ya ngágan ku ka áwan panda. Ittu pe yán ya ipangágan kiyà daya ngámingámin na tolay ka panda. ");
INSERT INTO isd_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Mawe ka lugud din ta mawem urnúngán ngámin daya pangmanàman daya iIsrael, ay se mu kagiyan kaggída nga, ‘Nge APU nga Dios datu apuapu nu wa Abraham, se Isaac, se Jacob, ay nagpassingan kiyà,’ nán mu kaggída. Ikagim pe kaggída nga ginìna ku da ngin se nasingan ku pe yin ya kapà-pàyanán da ka Egipto. ");
INSERT INTO isd_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ay gapu kídi, ay pinalánù a itálaw ku da ngin kadaya kapar-parigátan da ka Egipto. Ay se kuda nga ippan kiya napiya se nadam-ag tutu wala nga lusà a pag-agyanán pikam daya Cananeo, daya Heteo, daya Amorreo, daya Perizeo, daya Heveo, se daya Jebuseo. ");
INSERT INTO isd_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Ay ikurug daka. Ay se kayu wala nga mawe se daya pangmanàman daya iIsrael kiya giyán naya ári ka Egipto, ay se nu wala nán kaggína, ‘E APU nga Dios mi nga Hebreo, ay nagpassingan kadakami. Palubúsán nakami agpà nga mawe ka ir-ir-er ka tallu ngalgaw ta magbasu kami ka pagdáyaw mi ke APU wa Dios mi,’ nán nu. ");
INSERT INTO isd_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ammu ku win nga akkan nakayu palubúsán ya ári ka Egipto nu akkan mapalsu pikam kiya kababalin ku. ");
INSERT INTO isd_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Ay túya ipassingan ku kaggída nga iEgipto ya kababalin ku. Panísan kuda kadaya nakas-kasdáaw nga kuwaan ku kaggída. Díkod palubúsán nakayun na mawe. ");
INSERT INTO isd_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Ay nu magtálaw kayun, ay pagmaruwan ku daya iEgipto kadakayu, ta senu adu daya itug-túgut nu kadakayu mawe ta iddán dakayu. ");
INSERT INTO isd_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ay magadang daya Hebreo nga babbay kadaya babbay nga iEgipto ka balitù a iggagaldid da se daya duddúma nga nangína nga kuw-kuwa da, ay iddán dada. Ay iddán dada pe kadaya bad-bádu wa pagbádu da se daya annánà da. Díkod málàán nu daya iEgipto kadaya kuw-kuwa da,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Ay se la nga summungbát tu Moses nga nán na, “Ay kas pangarígan ta akkan dà kurugan se akkan da gìnán daya kag-kagiyan ku, ta get nán da nga, ‘Busid mu mà yán a, nga nagpassingan kikaw we APU,’ get nu nán da,” nán tu Moses. ");
INSERT INTO isd_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ay tútu nán ne APU kaggína, “Nágan naya im-immán mu ta?” Ay “Tàdukud mà,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Ay nán ne APU, “Ibbatám,” nán na. Ay tútu nibbatán na kurug. Ay pagkìlát na ngala nga nagbalin ka idaw tu tàdukud. Ay díkod inadayyuwán tu Moses. ");
INSERT INTO isd_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","May nán ne APU kaggína, “Tàmám ki íput,” nán na. Ay tútu tingkam na kurug, ay nagbalin ka tàdukud manin. ");
INSERT INTO isd_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“Tu yán ya kuwaam, ta senu mangurug da nga kurug ga nagpassingan kikaw we APU nga Dios datu apuapu da nga Abraham se Isaac, se Jacob,” nán ne APU. ");
INSERT INTO isd_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ay nán manin pe ne APU kaggína, “Isùsù mu ya ímam ki unag bádum,” nán na. Ay tútu nesùsù na kurug tu íma na kitu unag bádu na. Ay kane ilawán na kammin, ay tura la pummusà tutu wala nga nagsadúra. ");
INSERT INTO isd_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Ay nán manin ne APU kaggína, “Isùsù mu manin ya ímam ki unag bádum,” nán na. Díkod, nesùsù na kurug manin. Ay kane din na ilawán na manin, ay ummawan tu sadúra na ngin. Napiya ngin tu íma na nga ummán kadatu duddúma nga parte baggi na. ");
INSERT INTO isd_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","“Ay nu akkan da pà-pàgan tu nunna nga pakelasínán da kuma, ay mabalin na kurugan da ngin ya mekàduwa. ");
INSERT INTO isd_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ay nu akkan da pikam kurugan dayán na duwa nga nakas-kasdáaw nga pakelasínán da, ay se akkan da ka pe nga ikur-kurug, ay mangirod ka ka danum kitu wángag Nile, ay se mu la nga isiyà ki namaga nga lusà. Ay magbalin ka dága tu danum ma nesiyà mu,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ngamay nán tu Moses ke APU, “APU, gángay kammala nga akkan nà mà nalaing magúni, ay oray kídi. Akkan na nalaing magúni, ay se akkan ku ammu ya kagiyan ku nu duddúma,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ay tútu nán ne APU kaggína, “Inna ya nangwa kadaya mutumútung nu nga tolay ka nán mu ta? Inna ya makabalin mamagúmal, onu mamagbanggag kadaya tolay ta? Onu inna ya makabalin mamakúláp se mamakasingan kaggída ta? Akkan agkà iyà nga APU nu ta? ");
INSERT INTO isd_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ay túya mawe ka lugud din. Ay bul-bulunan taka, ay iyà ya mamagúni kikaw, se iyà ya magikagi kikaw kadaya masápul la ikagim,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Ay nán manin tu Moses, “Apu, pangaásim mán ta mangibon ka ngin ka sabáli tolay,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Ay tútu nakarungat te APU kitu Moses, ay nán na lugud din, “Atán mà nge Aaron nga wagim nga pútut pe tu Levi. Ammù nga nalaing nga magúni. Ay atán nin na umbet manabat kikaw. Ay nu masingan naka, ay makaanggam pànang. ");
INSERT INTO isd_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ay masápul amomanám se mu kagiyan kaggína daya masápul la kagiyan na kadaya tolay. Iya ya mamagúni kadakayu duwa, ay se ipakammù kadakayu daya masápul la kuwaan nu. ");
INSERT INTO isd_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Aggína ya panguniyan mu kadaya tolay, ta aggína ya árig mútung mu. Díkod ikaw ya árig Dios nga magpekagi kaggína kadaya kagiyan na. ");
INSERT INTO isd_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ay masápul la ag-agtum peyang ya tàdukud mu, ta ittu ya usaran mu wa mangipassingan kadaya nakas-kasdáaw wa pakelasínán da,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","19","Ay nagulli tu Moses ka Midian kitu giyán de Jetro nga katugángan na. Ay kitu kowad na kitúni, ay nán ne APU kaggína, “Magulli ka ngin ka Egipto, ta ngámin datu magasippatay kikaw, ay nagkakátay da ngin,” nán na. Ay tútu nakipalúbus tu Moses kitu katugángan na nga nán na, “Pangaásim mán ta palubúsán nà agpà a magulli kammin ka Egipto kadatu pan-pane ku. Ta 'wè sinnan nu sibbiyág da pikam,” nán na. Ay tútu nán tu Jetro kaggína, “Mawe ka lugud, ay simpipiya kuma ya uray mu wa mawe,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Ay díkod, inalà tu Moses datu pútut na nga pabeg lalláki se tu atáwa na, ay se nada netakay kitu asnu da, ay se dala nga nagrubbuwát nga magulli ka Egipto. Ay ag-agtu pe tu Moses tu tàdukud nga pausár ne Dios kaggína. ");
INSERT INTO isd_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Ay nán ne APU kitu Moses, “Ay nu atán kayu win ka Egipto, masápul ipassingan mu kiya ári datu nakas-kasdáaw wa mà-màwa nga pàwà kikaw, ta niddán taka ngin ka kababalin mu wa mangwa kadatun. Ngamay pagsukíran ku ya uray na. Ay díkod akkan na palubúsán na mawe daya tolay. ");
INSERT INTO isd_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ay se mu la kagiyan kiya ári, 'Tu idi ya nán ne APU. ‘Daya iIsrael, ay árig da ya an-anà ku wa laláki nga manákam. ");
INSERT INTO isd_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Díkod palubúsán muda nga mawe magday-dáyaw kiyà. Ay nu akkan muda palubúsán na mawe, ay tu idi ya kuwaan ku: patayan ku ya manákam ma an-anà mu wa laláki,’ nán mu,” nán ne APU. ");
INSERT INTO isd_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ay kitu isa nga balay ya nagdagusán da kitu ammeyag da ka Egipto, ay nagpassingan ne Apu kitu Moses. Ay patayan na kuma. ");
INSERT INTO isd_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Ngamay tu Zipora nga atáwa na, ay nangalà ka natadam ma batu, ay se na nga kugítan tu manákam ma an-anà da nga laláki, ay se na ilìlet kadatu síkil tu Moses tu lublub nga nippà na kitu an-anà da. Ay nán na kaggína nga mangilìlet, “Kurug ga ikaw ya atáwà nga nagpadága,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Ay tútu akkan netúluy ne Dios tu palánu na. Ay ittu tu inangngagi ne Zipora ka, “Atáwa taka gapu ki dága naya panagkúgit,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Ay nán ne APU kitu Aaron, “Mawem sabtan ne Moses ka ir-ir-er,” nán na. Ay díkod nawe na sinabat tu Moses kitu bantay ya agpassingannán ne Dios, ay se na umàán. ");
INSERT INTO isd_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Ay kinagi tu Moses kitu Aaron ngámin datu kinag-kagi ne APU Dios nga pekagi na kaggída se ngámin datu nakas-kasdáaw wa pakelasínán da nga piyán ne Dios pepàwa kaggída. ");
INSERT INTO isd_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Ay díkod nawe de Moses se tu Aaron kitu giyán datu iIsrael, se da urnúngan datu pangmanàman da. ");
INSERT INTO isd_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Ay díkod kinagi tu Aaron ngámin datu kinagi ne APU kitu Moses, ay se da nepassingan datu nakas-kasdáaw wa pakelasínán nga kurug datu kinag-kagi da. ");
INSERT INTO isd_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Ay nangurug datu tolay nga e APU kurug tu nangibon kaggída. Ay nagukkab da nga nagday-dáyaw ke APU, kane magìna da nga inumbet siningan ne APU da nga iIsrael, ay díkod sikkaammu pe kadatu ngámin na kapar-parigátan da. ");
INSERT INTO isd_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Ay kane din mabalin tun, ay nawe de Moses se Aaron kitu ári ka Egipto, ay se da nán kaggína, “Tu idi ya nán ne APU nga Dios daya iIsrael, ‘Palubúsán mu nga mawe daya tolay ku, ta senu màwa da ya piyasta nga para kiyà ka ir-ir-er,’ nán na,” nán da. ");
INSERT INTO isd_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Ngamay nán tu ári, “Inna yán na APU ta, tura ku kurugan daya kag-kagiyan na nga magpapan kiyà kadaya iIsrael? Akkan ku am-ammu yán na APU, ay se kannán ku papannan daya iIsrael!” nán na. ");
INSERT INTO isd_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ay tútu nán de Moses se Aaron, “Ya Dios daya Hebreo, ay nagpassingan kadakami. Papannan nakami ka ir-ir-er, nga tallu ngalgaw wa dalenan ya kadayyu na, ta senu makapagbasu kami ka pagday-dáyaw mi ke APU wa Dios mi. Nu akkan mi kuwaan yán ay patayan nakami ka sinakit onu ki gubát,” nán da. ");
INSERT INTO isd_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ngamay nán tu ári ka Egipto kaggída, “Dakayu Moses se Aaron, taanna tura nu piyán ilísi daya tolay kadaya ubra da ta? Ara ngin, mawe kayun kadaya ub-ubra nu!” ");
INSERT INTO isd_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Ay se la nán pikam tu ári, “Sinnan nu kod. Adu da tutu wala pànang ngin may daya tolay kídi nga íli, ay piyán nu nu magimáng da!” nán na. ");
INSERT INTO isd_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ay kitun mismu nga algaw, ay binílin na datu mangiapu kadatu tolay se datu kak-kapatás da nga nán na, ");
INSERT INTO isd_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Manggayát kídi yin, ay akkan nu iddán daya tolay ka dagámi para kiya kuwaan da nga ladrilyu. Aggída kampela ngin ya maggalà kadaya dagámi nga masápul da. ");
INSERT INTO isd_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ngamay akkan nu pe assayán ya nìdang nga bíláng naya ladrilyu nga kuwaan da. Ittu kam ya kaadu naya kuwaan da. Magsad-sadut da kammala ngin nin, ay túya akipalúbus da nga mawe ka ir-ir-er nga magbasu ka pagdáyaw da kiya Dios da. ");
INSERT INTO isd_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Ay kadamtan nu wala ya ubra daya lalláki, ta senu mapasiya da pànang, ay díkod akkan da at-atangyaan nin daya busid da bàbànán,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Ay díkod datu ù-upisiyál se datu kak-kapatás da, ay nawe da kinagi kadatu tolay datu kinagi tu ári kaggída. Ay nán da, “Tu idi ya nán naya ári, ‘Akkan kayun na middán ka dagámi. ");
INSERT INTO isd_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Dakayu kampela ngin nin ya mawe magsápul. Ngamay ya nìdang nga kuwaan nu nga ladrilyu, ay akkan màsayán,’ nán na,” nán da. ");
INSERT INTO isd_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Ay díkod nasip-siparà datu tolay kadatu ngámin giyán ka Egipto nga magidagámi. ");
INSERT INTO isd_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Ay datu ù-upisiyál se datu kak-kapatás da, ay pardadán da kammala datu tolay ya nán da, “Masápul a nga balinan nu ya ubra nu. Ay páda na kitun kitu middán kayu pikam ka dagámi,” nán da. ");
INSERT INTO isd_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Ay datu iIsrael la pinagkapatás datu upisiyál nga iEgipto, ay bináubáut dada. “Taanna tura kúráng kitu dáti ya kinuwa nu kídi nga algaw?” nán da. ");
INSERT INTO isd_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Ay díkod datu kak-kapatás sa iIsrael, ay nawe da kitu giyán tu ári nga magríri. Ay nán da, “Apu, taanna tura dakami pe pakunán na asassu nu. ");
INSERT INTO isd_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Awan midde kadakami nga dagámi, ngamay páda na kam ya nìdang nga ubra mi. Ay se dakami pe ya báu-báut daya tolay mu. Ngamay daya tolay mu ya atán básul,” nán da. ");
INSERT INTO isd_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ngamay nán tu ári, “Nasadut kayu kammala ngin nin! Nasadut kayu ngámin! Túya peyapeyang ya akipalúbus nu wa mawe nga magbasu ka pagdáyaw nu kiya APU nu. ");
INSERT INTO isd_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Mawe kayun kadaya ubra nu. Ata áwan kammala nga dagámi nga midde kadakayu, ay se oray nu mapakuna ay páda na kitu dáti ya mìdang nga ubraan nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Ay kane makagi kadatu kak-kapatás nga iIsrael nga akkan màsayán tu nìdang kaggída nga ubra da, ay nammuwán da ngin na nadakè in tu kapà-pàyanán da. ");
INSERT INTO isd_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ay kane lumawán da nga gayát kitu giyán tu ári, ay nesabat da de Moses se Aaron na atán magid-iddag kaggída. ");
INSERT INTO isd_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ay nán da kade Moses se Aaron, “E APU ya makammu wa mamánis kadakayu, áta gapu kadakayu, ay lùsawan nakami ya ári yin se daya ù-upisiyál na. Ay atán pambarán da ngin na mamatay kadakami,” nán da. ");
INSERT INTO isd_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Ay tútu nakiamomán manin ne Moses ke APU nga nán na, “Apu, taanna, tura nadakè ya kinuwám kadaya tolay? Taanna, tura nà ala nebon kaggída? ");
INSERT INTO isd_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Ata nanggayát kitu nangipàrob mu kiyà kiya giyán naya ári nga mangiúni kikaw, ay nadakè in ya pamà-pàyanán na kadaya tolay yin, ay áwan mu pikam kinuwa ka angngilísim kaggída,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Ay se la nán ne APU kitu Moses, “Kídi ay masingan mun ya kuwaan ku kiya ári. Ata gapu kiya pannakabalin ku, ay palubúsán nakayu. Akkan nakayu wala nga palubúsán na mawe, nu di na kayu pe pataláwan kiya íli na,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ay nán ne APU Dios kitu Moses, “Iyà ya APU. ");
INSERT INTO isd_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nagpassingan nà kitu Abraham, kitu Isaac se kitu Jacob. Nagpassingan nà a Dios nga mannakabalin kaggída. Ngamay akkan nà nagpakammu kaggída kiya ngágan ku nga Yahweh. ");
INSERT INTO isd_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Nekar-karì pe kaggída nga ipakin-kuwà kaggída ya íli Canaan, ya íli nga nag-agyanán da kitu agtangeli da kitúni. ");
INSERT INTO isd_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ay se ku pe nagìna daya aggul-ulul daya iIsrael gapu ki amar-parígát datu iEgipto nga ittu daya mangasassu kaggída. Ay díkod nadamdam ku tu nekarì kaggída. ");
INSERT INTO isd_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Kagiyan mu lugud kadaya iIsrael nga iyà ya APU. Ay itálaw takayu kiya angngasassu daya iEgipto kadakayu, se ya amar-parígát da kadakayu kadaya nasulit ta ipaubra da kadakayu. Ipassingan ku kaggída ya kababalin ku ki angngalà ku kadakayu. Ay se kuda nga panísan tutu wala. ");
INSERT INTO isd_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ay dakayu win daya tolay ku, ay iyà in ya Dios nu. Ay mammuwán nu wa kurug ga iyà ya APU nga Dios nga nangitálaw kadakayu kiya angngasassu daya iEgipto. ");
INSERT INTO isd_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ay se takayu ippan kiya íli nga nekarì, nga idde kadatu apuapu nu wa Abraham, se Isaac, se Jacob. Iddè kadakayu ka kuw-kuwa nu win. ‘Iyà ya APU nu,’ nán na, nán mu kaggída.” ");
INSERT INTO isd_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ay ittu tu kinagi tu Moses kadatu iIsrael. Ngamay akkan da pà-pàgan tu Moses ta nippà tu agnamnáma da ngin gapu kitu kinarungat pànang datu mangasassu kaggída. ");
INSERT INTO isd_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ay tútu nán ne APU kitu Moses, ");
INSERT INTO isd_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Mawe ka kiya giyán naya ári ka Egipto, ay se mu kagiyan kaggína nga pataláwan na daya iIsrael kiya íli na,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ngamay nán tu Moses ke APU, “Akkan dà pà-pàgan daya iIsrael, ay tu nád agpà kiya ári nu pàgan nà. Tàwán kam kiya akkan ku ammu magúni,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ngamay inamomanán ne APU tu Moses se tu Aaron. Binílin nada mepanggap kadaya iIsrael se kiya ári ka Egipto. Binon nada nga mawe mangitálaw kadatu iIsrael ka íli Egipto. ");
INSERT INTO isd_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ay tu dedi daya tul-tolay nga naggay-gayatán tu Moses se tu Aaron. Ay datu lalláki nga pútupútut tu Ruben na manákam ma pútut tu Israel, ay tu Hanoc, tu Pallu, Hezron, se tu Carmi. Tu dayán datu pútupútut tu Ruben. ");
INSERT INTO isd_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Datu pútupútut tu Simeon nga lalláki, ay tu Jemuel, tu Jamin, tu Ohad, tu Jacin, tu Zohar, se tu Saul nga pútut na kitu babay ya iCanaan. Tu dayán datu pútupútut tu Simeon. ");
INSERT INTO isd_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Ay tu dedi daya ngag-ngágan datu pútupútut tu Levi. Tu Gerson tu manákam, ay se la tu Kohat, ay se la nga itu Merari. Magatut se tallu púlu se pittu tu dagun tu Levi se la natay. ");
INSERT INTO isd_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Ay datu pútupútut tu Gerson na lalláki, ay tu Libni, se tu Semei. Ay adu pe datu pútupútut da. ");
INSERT INTO isd_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Ay datu pútupútut natu Kohat nga lalláki, ay tu dedi: tu Amram se tu Izar, se tu Hebron, se tu Uzziel. Ay nagdagun ka magatut se tallu púlu se tallu tu Kohat se la nga natay. ");
INSERT INTO isd_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Ay datu pútupútut natu Merari nga lalláki, ay tu Mali se tu Musi. Ay ittu dayán datu pútupútut tu Levi se datu pútupútut da kampela ngin. ");
INSERT INTO isd_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Tu Amram ay inatawán na tu Jocebed nga wagi natu ama na. Ay tu Moses se tu Aaron datu annánà da. Nagdagun ka magatut se tallu púlu se pittu tu Amram, ay se la nga natay. ");
INSERT INTO isd_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ay datu pútupútut tu Izar nga lalláki ay tu Kora, se tu Nefeg, se tu Zicri. ");
INSERT INTO isd_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ay datu pútupútut tu Uzziel nga lalláki ay tu Misael, tu Elsafan se tu Sitri. ");
INSERT INTO isd_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Ay tu Aaron ay inatawán na tu Eliseba nga pútut tu Amminadab se wagi natu Naason. Ay appát datu annánà da nga lalláki: tu Nadab, se tu Abihu, se tu Eleazar, se itu Itamar. ");
INSERT INTO isd_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Ay datu pútupútut natu Kora nga lalláki ay tu Assir se tu Elkana se tu Abiassaf. Tu dayán datu tangámalán datu Korahiteo. ");
INSERT INTO isd_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Tu Eleazar nga pútut Aaron nga laláki ay inatawán natu isa kadatu pútut tu Putiel nga babbay. Ay tu Finehas tu an-anà da. Tu dayán datu apuapu datu gakagaka se datu pampamilya datu naggayát kitu Levita. ");
INSERT INTO isd_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ay tu Aaron se tu Moses nga nakagi kadayán, ay ittu kam de Aaron se Moses nga nagkunaán ne APU ka, “Itálaw nu daya iIsrael kiya íli Egipto, ngámin da nga tangámalán.” ");
INSERT INTO isd_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ay aggída kam pe tu Moses se tu Aaron nga nawe kitu ári ka Egipto nga nangikagi kaggína nga itálaw da datu iIsrael ka Egipto. ");
INSERT INTO isd_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Kitu algaw nga nangamomán ne APU kitu Moses kitu kowad na ka Egipto, ");
INSERT INTO isd_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","ay nán ne APU kaggína, “Iyà ya APU. Ikagim kiya ári ka Egipto ngámin daya kag-kagiyan ku kikaw,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Ngamay nán tu Moses ke APU, “APU akkan nà mà nalaing magúni. Paanna pe ya anggìna naya ári kiyà?” nán na. ");
INSERT INTO isd_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ay nán ne APU kitu Moses, “Sinnam á, ta pagbalinan taka ka ummán ke Dios ki àráng naya ári. Ay e Aaron nga wagi mu ya bátug panguniyam. ");
INSERT INTO isd_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ikagim mala ngámin ke Aaron datu nebílin ku kikaw, ay aggína ngala ya mangikagi kiya ári ka Egipto nga pataláwan na daya iIsrael kiya íli na. ");
INSERT INTO isd_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ngamay pagsukíran ku ya uray naya ári, ta senu oray nu kaduwan ku wala daya nakas-kasdáaw wa ipassingan ku kiya íli Egipto, ");
INSERT INTO isd_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ay akkan naka pà-pàgan ya ári. Ay se ku la nga idde kaggída nga iEgipto ya nadammat tutu wala nga dúsa da, ay se ku la nga itálaw daya ngámin tangámalán na iIsrael nga tolay ku kiya íli Egipto. ");
INSERT INTO isd_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Ay díkod mammuwán daya iEgipto nga iyà ya APU nu panísan kuda se ku itálaw kaggída daya iIsrael,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Ay tu Moses se tu Aaron, ay kinuwa da kurug datu ipàwa ne APU kaggída. ");
INSERT INTO isd_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Ay kitun na nipappan da kitu giyán tu ári ka Egipto, ay walu púlu dagun tu Moses sin se walu púlu se tallu tu dagun tu Aaron nin. ");
INSERT INTO isd_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Ay nán ne APU kitu Moses se tu Aaron, ");
INSERT INTO isd_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Ay nu masápul naya ári ya nakas-kasdáaw wa pakelasínán na nga kurug daya kag-kagiyan nu, ay pelubtág mu ke Aaron ya tàdukud ki àráng naya ári ta senu magbalin ka idaw,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Ay díkod nawe de Moses se Aaron kitu giyán tu ári. Ay kinuwa da kurug tu nebílin ne APU kaggída. Nelubtág kurug tu Aaron tu tàdukud kitu àráng tu ári se datu ù-upisiyál na, ay nagbalin kurug ka idaw. ");
INSERT INTO isd_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ay tútu kirrawán tu ári datu mamasírib ba tolay se datu durarákit na, se datu maragsalamangka ka Egipto. Ay gapu kitu sírib da, ay kinuwa da pe tu ummán kitu kinuwa tu Aaron. ");
INSERT INTO isd_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Nelubtagán da datu tàdukud da, ay nagbalin da pe ka idaw. Ngamay tu tàdukud tu Aaron, ay sillan na ngámin datu tàdukud da. ");
INSERT INTO isd_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Ngamay nagsúkir pikam mala tu uray tu ári, ay akkan nada nga kur-kurugan nga ummán kitu kinagi ne APU. ");
INSERT INTO isd_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Ay se la nga nán ne APU kitu Moses, “Akkan papannan naya ári daya tolay, ta summúkir ya uray na. ");
INSERT INTO isd_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Mawe ka manin kaggína nu pagmakát kaláwa. Idaggán nu kiya dappit naya wángag ta mawe kiyán. Alà mu tu tàdukud mu wa nagbalin ka idaw kagedamen. ");
INSERT INTO isd_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ay se mu la nán kaggína, ‘Nge APU nga Dios daya Hebreo, ay nepàrob nà. Nán na nga pataláwan mu kanu daya tolay na, ta senu mawe da ki ir-ir-er nga magday-dáyaw kaggína. Kinagi na yanin kikaw, may panda kídi ay akkan mu ikur-kurug.’ ");
INSERT INTO isd_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ay túya nán ne APU kídi kikaw, ‘Tu idi ya pakasinnám nga aggína kurug ya APU. Sinnam ta ibadit ku idi ya tàdukud ku kídi wángag Nile, ay magbalin ka pabeg dága ya danum na. ");
INSERT INTO isd_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Matay ngámin daya sissida na, ay se nabuyù ya aláb na. Díkod akkan mainum daya iEgipto ya danum na,’ nán na,” nán tu Moses. ");
INSERT INTO isd_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ay nán ne APU kitu Moses, “Ay kagiyan mu ke Aaron nga alà na ya tàdukud se na la nga itatáyag ki bátug daya dan-danum ki Egipto, ummán kadaya wángawángag, se aw-awweg, daya pisu-pisung se daya bat-battung, ta senu magbalin dayán ngámingámin ka dága. Ay magbalin ka dága ngámin daya danum ki Egipto, oray daya atán kadaya ngámin baláki nga agdanumán da,” nán ne APU. ");
INSERT INTO isd_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Ay díkod kinuwa tu Moses se tu Aaron tu nebílin ne APU kaggída. Netáyag tu Aaron tu tàdukud na, se na nebadit kitu danum kitu wángag Nile. Ay nagbalin ka dága tu danum kitu wángag. Kinuwa na idi kitu pagmar-marngán tu ári se datu ù-upisiyál na. ");
INSERT INTO isd_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ay natay ngámin datu sissida kitu wángag, ay se nabuyù tutu wala tu danum. Díkod akkan makenum datu iEgipto kitu danum nga maggayát kitu wángag Nile. Dága ngámin datu giy-giyán ki Egipto nga kowaddán danum. ");
INSERT INTO isd_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ay nàwa pe datu maragsalamangka ka Egipto tu kinuwa tu Moses se tu Aaron gapu kitu sírib da kampela ngin nin. Díkod akkan na naulis tu kinasúkir tu ári. Akkan nada nga kinur-kurug nga ummán kitu kinagi ne APU. ");
INSERT INTO isd_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Ay se nawe la ngin tu ári kitu palásiyu na. Akkan na nga linam-lammat tin tu nàwa. ");
INSERT INTO isd_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Ay datu iEgipto, ay nambug da kitu dappit tu wángag Nile ka pagsàduwán da, ta akkan da nga mainum tu danum natu wángag. ");
INSERT INTO isd_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Ay pittu ngalgaw ya napalábas sin nanggayát kitu namagbalin ne APU kitu wángag Nile ka dága. ");
INSERT INTO isd_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Ay nán manin ne Apu kitu Moses, “Mawe ka manin kiya ári, ay nán mu kaggína, ‘Tu idi ya nán ne APU, Papannam daya tolay ku ta senu mawe da magday-dáyaw kiyà. ");
INSERT INTO isd_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ay nu akkan muda palubúsán, ay pannuwan ku ka tukà ya ngámingámin giyán ki íli mu. ");
INSERT INTO isd_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Mapnu tutu wala ka tukà ya wángag Nile. Ay se la nga gumàdáng dayán na tukà, se da la umbet kiya palásiyum. Madaran da kiya kuwartu mu se kiya káma mu, se kadaya babbalay daya ù-upisiyál mu se daya tolay mu. Magyán da pe kadaya aglutuwán nu ka sinápay se kadaya besin nga aglammugán nu ka arína ");
INSERT INTO isd_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Dayán na tukà, ay unekan daka, se daya bobonan mu se daya ngámin tolay mu,’ nán mu,” nán ne APU. ");
INSERT INTO isd_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ay nán manin ne APU kitu Moses, “Kagiyan mu ke Aaron nga alà naya tàdukud, se na la nga itáyag kiya bátug daya wángawángag, se daya aw-awweg se daya bat-battung ta senu lumawán ngámin daya tukà, se da magkakápan kadaya ngámin giy-giyán ka Egipto,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Ay netáyag kurug tu Aaron tu tàdukud na kitu bátug datu wángawángag se datu aw-awweg se datu bat-battung ka Egipto. Ay naglalbet kurug datu tukà, ay nalokop tu ngámin Egipto kaggída. ");
INSERT INTO isd_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ngamay gapu kitu am-ammu kampela ngin nin datu maragsalamangka nga iEgipto, ay nàwa da pe ya ummán kitun. ");
INSERT INTO isd_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Ay se la nga kirrawán tu ári tu Moses se tu Aaron, ay se na nán kaggída, “Makim-imallà kayu mán ke APU, ta pataláwan na kuma ngámin daya tukà kiya palásiyù, se kadaya babbalay daya tolay ku, ay se ku la nga palubúsán na mawe daya iIsrael nga magday-dáyaw ke APU,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Ay nán tu Moses kitu ári, “Akkan ka ngala min-induwán na mangikagi kiyà nu nungay naya piyám ma angngikarárag ku kikaw se kadaya ù-upisiyál mu se kadaya tolay mu, ta senu umawan daya ngámin tukà kiya palásiyum se kadaya babbalay. Ay tittu ya wángag Nile ya giyán da ngin,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Ay nán tu ári, “Kaláwa,” nán na. Ay nán tu Moses, “Nu ittu ya nán mu, ay ittu ya màwa, ta senu mammuwán mu nga áwan tutu wala ya mepáda ke APU wa Dios mi. ");
INSERT INTO isd_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Umawan daya tukà ki palásiyum se kadaya babbalay daya bobonam, se kadaya babbalay daya tolay mu. Tittu ya wángag Nile ya giyán da ngin,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ay díkod pinanáwan de Moses se Aaron tu ári. Ay se la nga nakim-imallà tu Moses ke APU panggap kadatu tukà nga ummán kitu nagamomanán da se itu ári. ");
INSERT INTO isd_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ay kinuwa kurug ne APU tu inadang tu Moses. Natayán ngámin datu tukà nga atán kadatu babbabalay, se kadatu amuwág da, se kadatu tal-tálun da. ");
INSERT INTO isd_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Ay inurnúngán datu iEgipto ngámin datu natay nga tukà, se dada binun-buntun. Ay nagalibàbà tutu wala ki buyù tu ngámin Egipto. ");
INSERT INTO isd_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Ay kane masingan tu ári nga napiya tu kà-kàwaán da ngin, ay summúkir manin tu uray na nga ummán kitu nán ne APU. Maddi na pà-pàgan tu Moses se tu Aaron. ");
INSERT INTO isd_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Díkod nán manin ne APU kitu Moses, “Kagiyan mu ke Aaron nga alà na tu tàdukud, ay se na la nga ibáut kiya lusà. Ay magbalin ka agukup ya tápù ki ngámin Egipto,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Díkod ittu kurug tu kinuwa da. Inalà tu Aaron tu tàdukud, ay se na ibáut kadatu tápù ki lusà. Ay nagbalin datu tápù ki ngámin Egipto ka agukup, ay se da tutu wala nga malokop kadatu tolay se kadatu áyam da. ");
INSERT INTO isd_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ay datu maragsalamangka nga iEgipto, ay pinadásan da ngámin pe datu am-ammuwán da nga sírisírib da nga mamowad kuma ka agukup, may áwan da tutu wala nga nàwa. Nalokop datu tolay se datu animál da kadatu agukup. ");
INSERT INTO isd_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ay tútu nán datu maragsalamangka kitu ári, “E Dios kurug ya nangwa kídi,” nán da. Ngamay summúkir manin tu uray tu ári nga ummán kitu kinagi ne APU. Akkan na pà-pàgan tu Moses se tu Aaron. ");
INSERT INTO isd_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Ay se la nán manin ne APU kitu Moses, “Sumápa ka nga malukág kaláwa, se mu la idaggán ya ári nga mawe kiya wángag. Ay se mu la nán kaggína, ‘Tu idi ya kagiyan ne APU kikaw, Papannam daya tolay ku, ta senu mawe da nga magday-dáyaw kiyà. ");
INSERT INTO isd_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ay nu akkan muda papannan, ay palbetan ku daya pangang-angpan na lángaw. Díkod malángalángaw ka, se daya ù-upisiyál mu, se daya tolay mu. Lángaw ngámin daya babbalay mu, se daya babbalay daya ngámin iEgipto, ay oray pe daya ngámin lusà a pagdam-án da, ay pabeg lángaw pe. ");
INSERT INTO isd_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Ta senu ammuwán mu nga iyà nga APU, ay atán kídi nga giyán, ay ipadúmà ya íli Gosen, nga ittu ya pag-agyanán daya tolay ku. Awan mawe nga lángaw kitúni ta ");
INSERT INTO isd_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","paglasínan ku daya tolay mu se daya tolay ku. Kaláwa ya kàwa nedi nga nakas-kasdáaw nga màwa, nán na,’ nán mu” nán ne APU. ");
INSERT INTO isd_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Ay ittu kurug tu kinuwa ne APU, ay díkod pangang-angpan na lángaw datu inumbet kitu palásiyu natu ári se kadatu babbabalay datu ù-upisiyál na. Nadakè ya nà-nàwaán tu ngámin íli Egipto gapu kadatu lángaw. ");
INSERT INTO isd_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Ay tútu pinaayabán natu ári tu Moses se tu Aaron, ay se na nán, “Ara, mawe kayu magbasu ka pagday-dáyaw nu kiya Dios nu, ngamay kuwaan nu kídi unag íli,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ngamay nán tu Moses kaggína, “Nadakè ya ummán kiyán, áta kalùsawan dakami daya iEgipto nu masingan da daya animál nga pagbasu mi ke APU nga Dios mi. Ay patayan dakami tutu wala ki tùtò. ");
INSERT INTO isd_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Masápul la tallu walgaw mi nga magdal-dalen se kami la makadatang kitu ir-ir-er nga pagbasuwán mi ka pagday-dáyaw ke APU wa Dios mi, ta ittu yán tu nebílin na kadakami,” nán tu Moses. ");
INSERT INTO isd_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Ay tútu nán tu ári, “Palubúsán takayu wa mawe kiya ir-ir-er nga magbasu se magday-dáyaw kiya APU wa Dios nu, ngamay akkan kayu wa umadayyu pànang. Ikarárag nà lugud din,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Ay tútu nán tu Moses pe, “Panáwan taka lugud din ta mawe yà makim-imallà ke APU, ta senu magtatálaw da ngin kaláwa daya lángaw nga atán ki giyán mu, se kadaya bobonan mu, se daya tolay mu. Ay akkan nakami a nga pagbus-busidán manin. Get akkan mu manin papannan daya tolay ya mawe magbasu ke APU,” nán tu Moses. ");
INSERT INTO isd_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Ay díkod pinanáwan tu Moses sin tu ári, ay se la nawe nagkarárag ke APU. ");
INSERT INTO isd_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Ay kinuwa kurug ne Apu tu nekarárag natu Moses. Ay umawan datu lángaw wa atán kitu giyán tu ári se kitu giyán datu bobonan na se kitu giyán datu tolay na. Awan nala nabansi oray isa nga lángaw. ");
INSERT INTO isd_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ngamay pinasúkir manin tu ári tu uray na, ay akkan na manin palubúsán na mawe datu tolay. ");
INSERT INTO isd_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Ay se la manin nán ne APU kitu Moses, “Mawe ka manin kiya ári, ay se mu kagiyan kaggína, ‘Tu idi ya nán ne APU nga Dios daya Hebreo, Papannam daya tolay ku, ta senu makapagday-dáyaw da kiyà. ");
INSERT INTO isd_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ay nu akkan muda manin na papannan, ");
INSERT INTO isd_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ay panísan takayu manin. Pagpistiyan ku daya ngámin na an-animál kadaya pas-pastu nu; daya bak-báka nu se daya kabalyu nu, se daya asnu nu, se daya karneru se kalding nu, se daya kámel nu. ");
INSERT INTO isd_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Ngamay pagduman ku daya animál daya iEgipto se daya animál daya iIsrael. Awan matay kadaya animál daya iIsrael, nán na,’ nán mu,” nán ne APU. ");
INSERT INTO isd_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Ay nìdang ne APU ya kàwa nedi, ta nán na nga, “Kuwaan ku idi kaláwa kídi Egipto.” ");
INSERT INTO isd_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ay kane láwa na, ay kinuwa ne APU tu kinagi na. Ay ngámin datu an-animál datu iEgipto, ay natayán da, ngamay áwan nala oray isa ya natay kadatu animál datu iIsrael. ");
INSERT INTO isd_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Díkod nangibon tu ári ka mawe maningan kitu nàwa. Ay kurug ga áwan oray isa kadatu báka datu iIsrael tu natay. Ngamay pinasúkir tu ári tu uray na. Ay akkan na papannan datu tolay. ");
INSERT INTO isd_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ay nán manin ne APU kitu Moses se tu Aaron, “Mangalà kayu ka abu kiya dapug. Ay se la nga itábur ne Moses ki ngúdu ki àráng naya ári. ");
INSERT INTO isd_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Magwáras ya abu nga ummán ki nemà tutu wala nga tápù ki ngámin Egipto. Ay ittu yán ya mamaltuwád ka lattag kadaya tolay se mamagrasa kaggída se kadaya an-animál ki ngámin Egipto,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Díkod nangalà da ka abu ki dapug, ay se da nawe kitu giyán tu ári. Ay kaggína nga magsisíngan, ay netábur tu Moses ka ngúdu tu abu. Ay naglalattag datu tolay se datu an-animál. Ay nagbalin ka rasa datu lattag da kane mabsiyán da. ");
INSERT INTO isd_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ay datu maragsalamangka nga iEgipto, ay akkan da tutu wala makapagsíkád da sumángu kitu Moses gapu kadatu lattag da, áta naglattag da pe se datu ngámin iEgipto. ");
INSERT INTO isd_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ngamay pinagsúkir ne APU tu uray tu ári. Ay tútu akkan nada kinur-kurug nga ummán kitu kinagi ne APU kitu Moses. ");
INSERT INTO isd_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Ay se la nán manin ne APU kitu Moses, “Sumápa ka nga gumniya kaláwa, ta mawem amomanán ya ári. Ay nán mu kaggína, ‘Tu idi ya kagiyan ne APU nga Dios daya Hebreo kikaw, Papannam daya tolay ku, ta senu makapagday-dáyaw da kiyà. ");
INSERT INTO isd_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ay nu akkan mu da nga papannan, ay nadammat daya iddè nga dúsa kikaw mismu se daya bobonan mu, se daya ngámin tolay mu ta senu ammuwán mu nga áwan mepáda kiyà ki ngámin kalawagán. ");
INSERT INTO isd_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Annung taka kuma nga pinatay yin se daya tolay mu ki sinakit, ta senu áwaáwan kayun, ");
INSERT INTO isd_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","ngamay akkan ku kinuwa ta piyán ku ipassingan kikaw ya pannakabalin ku, ta senu mewaragáwag ki ngámin kalawagán ya ngágan ku. ");
INSERT INTO isd_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ikaw ya makalípa-lípán kadaya tolay ku. Akkan muda tutu wala nga papannan. ");
INSERT INTO isd_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Sinnam á ta kaláwa ki am-amung nedi nga ur-oras, ay pagarnaban ku ka ullalágu nga mangan-anansing ya daggat na. Ittu pikam idi ya kàwa naya ummán kídi nanggayát kitu inagbalin naya Egipto ka íli. ");
INSERT INTO isd_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ay díkod mawem pelídum min daya bak-bákam se daya duddúma nga animál mu wa atán kadaya tal-tálun, ta ngámin daya an-animál la akkan melidúmán se daya tolay ya atán kadaya tal-tálun, ay maarnabán da ngámin kiya ullalágu, ay matay da ngámin, nán na,’ nán mu,” nán ne APU. ");
INSERT INTO isd_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ay díkod datu ù-upisiyál tu ári nga mansing ke Dios, ay nelidúmán da datu as-asassu da datu bak-báka da ki nalídum ma giyán. ");
INSERT INTO isd_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ngamay datu akkan mangur-kurug kitu bàbànán ne APU, ay binay-án da ngala datu asassu da se datu bak-báka da kadatu pastu da. ");
INSERT INTO isd_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ay nán ne APU kitu Moses, “Itáyag mu ya ímam se mu ituldu ya lángit, ta senu magarnáb ka ullalágu ki ngámin na Egipto, ay maarnabán daya tul-tolay se daya an-animál se daya mul-múla ki oray wàna nga giyán kídi Egipto,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Ay díkod netáyag tu Moses tu tàdukud na se na nga ituldu ka lángit. Pinagaddug ne APU se pinagarnáb na ka ullalágu se pinagsal-sal-it na ki ngámin Egipto. ");
INSERT INTO isd_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Pinagudán ne APU ka dadakkal tutu wala nga ullalágu se na kan-kanáyun na pinagsal-sal-it pe. Ay áwan pikam nàwa nga ummán kídi kiddi Egipto, nanggayát kitu inagbalin na ka íli. ");
INSERT INTO isd_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ay rinápun natu ullalágu datu ngámin na atán kadatu tal-tálun ki ngámin Egipto, tolay se daya an-animál. Dinadál na pe ngámin datu mul-múla se datu kay-káyu. ");
INSERT INTO isd_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Tittu ka íli Gosen na giyán datu iIsrael ya akkan neráman na naarnabán ka ullalágu. ");
INSERT INTO isd_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Ay tútu pinaayabán tu ári tu Moses se tu Aaron. Ay nán na kaggída, “Nammuwán ku kídi nga iyà ya nagbásul. Kustu we APU. Dakami se daya tolay ku daya nasábag. ");
INSERT INTO isd_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Makim-imallà ka mán ke APU ta napalotán nin dedi ya addug se ullalágu. Papannan takayu tutu wala ngin na akkan kayu magulli yin,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Ay nán tu Moses kaggína, “Ay nu makalawán nà ki íli yin, ay magkarárag gà ke APU. Makusap kurug daya addug se ya aggudán na ka ullalágu, ta senu ammuwán mu nga oray idi ya kalawagán, ay kuw-kuwa ne APU. ");
INSERT INTO isd_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ngamay ammù nga dakayu se daya ù-upisiyál mu, ay áwan nu pikam ma aggansing ke APU wa Dios.” ");
INSERT INTO isd_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Ay datu lino se sebáda ay nadadál da tutu wala, áta nakulnit pe yin tu sebáda, ay madama magbísì datu lino da. ");
INSERT INTO isd_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ngamay datu trígo da, ay áwan nadadál kaggída ta akkan da pikam nakatúbu). ");
INSERT INTO isd_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Ay díkod, pinanáwan tu Moses tu ári, se mawe kitu lasi natu íli, ay se na itáyag datu íma na nga makim-imallà ke APU. Ay nakusap datu addug se tu aggarnáb na ka ullalágu ay áwan pe tu udán nin. ");
INSERT INTO isd_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ngamay kane masingan natu ári nga nakusap tu addug gin se tu ullalágu se tu udán, ay pinasúkir na manin tu uray na. Ay ummán pe datu bobonan na. Díkod nakabásul da manin. ");
INSERT INTO isd_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Díkod akkan pinapan tu ári datu iIsrael, ta summúkir manin tu uray na nga ummán kitu kinagi ne APU kitu Moses. ");
INSERT INTO isd_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ay se la kinagi manin ne APU kitu Moses, “Mawe ka manin kiya ári, ta pinasúkir ku ya uray na, se ya uray datu ù-upisiyál na, ta senu mepassingan ku kaggída daya nakas-kasdáaw nga mà-màwa ku. ");
INSERT INTO isd_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Ay ta senu mekagi mu pe kadaya pútupútut mu se daya apúku mu ya namàpaultu ku kadaya iEgipto kitu inangwà kadatu nakas-kasdáaw kaggída. Ay senu mammuwán nu ngámin na iyà ya APU,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ay díkod nawe manin tu Moses se tu Aaron kitu giyán tu ári. Ay nán da kaggína, “Tu idi ya nán ne APU nga Dios daya Hebreo, ‘Ka nungay na tutu wala pe ya agpakumbabám kiyà? Papannan mu win daya tolay ku, ta senu mawe da nga magday-dáyaw kiyà. ");
INSERT INTO isd_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ay nu akkan muda manin papannan, ay palbetan ku daya adu tutu wala nga dúdun kiya íli mu nu kaláwa. ");
INSERT INTO isd_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Malokop tutu wala ya ngámin lusà gapu kaggída. Ay áwan nu masingan ki lusà gapu ki katabbun da. Ay seda kanan ngámin daya mul-múla nga akkan nadadál kitu ullalágu, ay oray pe daya ngámin kay-káyu. ");
INSERT INTO isd_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ay mapnu pe ya palásiyu mu kaggída, ay se daya babbabalay daya ù-upisiyál mu, se daya ngámin na babbabalay daya iEgipto. Napalotán ya kaadu da, se napalotán ya angdadál da. Ay oray daya kakay nu se daya apuapu nu, ay áwan da pikam nasingan na ummán kídi panda kitu nekeanà da,’ nán na,” nán da. Ay kane makagi na datun, ay pinanáwan na tu ári yin. ");
INSERT INTO isd_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Ay nán datu bobonan tu ári, “Ka nungay na nád ya kakusap nayán na tolay ki angriribù na kadàtada? Papannan mu win daya tolay, ta senu maday-dáyaw da ya APU nga Dios da. Di mu pikam nasingan ta, nga nadadál tutu wala ngin ya Egipto wi!” nán da. ");
INSERT INTO isd_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Díkod pinaayabán na manin tu Moses se tu Aaron. Ay nán na kaggída, “Mawe kayun na magday-dáyaw kiya APU wa Dios nu. Ngamay iinda daya mawe?” nán na. ");
INSERT INTO isd_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Ay nán tu Moses nga summungbát, “Mawe kami ngámingámin se daya annánà mi se daya apuapu mi. Alà mi pe daya ngámin bak-báka mi, se daya karneru se kalding mi, ta masápul la magpiyasta kami ka pagday-dáyaw mi ke APU,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Ay tútu nán tu ári kaggída, “Ay sápay kuma ta kalakkán nakayu nge APU, ta akkan ku kammala pekíwid daya annánà nu kadakayu, ta masissingan nala nga atán nadakè a asikkuwaan nu. ");
INSERT INTO isd_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Maddi mabalin! Dakayu wala nga nanákam ma lalláki ya mawe magday-dáyaw ke APU, ta ittu yán ya daw-dawásan nu,” nán na. Ay se la nga pinatálaw tu ári da ngin. ");
INSERT INTO isd_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ay se la nga nán ne APU kitu Moses, “Itáyag mu daya ímam ta ibúgit mu ngámin ya Egipto, ta senu maglalbet daya adu tutu wala nga dúdun, ay senu kanan da daya ngámingámin na mul-múla nga nabansi kitu naggarnáb na ka ullalágu,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Díkod netáyag tu Moses tu tàdukud na, se na ibúgit tu ngámin Egipto. Ay se la nga pinagbáli ne Dios ka tangalgaw se tangagabíyán nga nepeyag na kitu íli. Nagpagayát tu báli ka padne lattakán. Ay kane pagmakát tin, ay nagilbet ka nagadu tutu wala nga dúdun tu báli. ");
INSERT INTO isd_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Ay nagwáras datu dúdun kitu ngámin na giy-giyán ka Egipto. Ay ittu pikam tun na dumúma katabbun na dúdun nga naglaltuwád. Awan na nga kapáda, ay ittu pe tun nin ka panda. ");
INSERT INTO isd_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Nalokop tu ngámin lusà kadatu dúdun, ay tútu nangísit tu lusà kaggída. Ay kinnán da ngámin datu mul-múla se ngámin datu búnga datu kay-káyu nga nabansi kitu naggarnáb na ka ullalágu. Díkod áwan tutu wala nabansi nga kay-káyu se mul-múla ki oray ka wàna ka Egipto. ");
INSERT INTO isd_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Ay tútu dágus sala nga pinàrawán tu ári tu Moses se tu Aaron. Ay nán na kaggída, “Nagbásul là kurug ke APU wa Dios nu se kadakayu pe. ");
INSERT INTO isd_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Túya pakawanan dà agpà manin. Tú la idi yin. Ay pangaási nu mán ta ikarárag nu kiya APU wa Dios nu nga ippà na dedi nga makappatay nga pamánis na kiyà. Ittu kurug idi yin.” ");
INSERT INTO isd_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Díkod pinanáwan tu Moses tu ári, ay se la nga nakim-imallà ke APU. ");
INSERT INTO isd_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Ay tútu binaliwág ne APU tu báli. Nagpagayát ka padne sirbútán tu naggat tutu wala nga báli. Ay ittu tun tu nangìpur se nangippà kadatu dúdun kitu bebay nga nengágan da ka Daggáng Bebay. Awan oray isa nga dúdun ya nabansi ka Egipto. ");
INSERT INTO isd_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ngamay akkan kammala papannan tu ári datu tolay ta pinagsúkir ne APU tu uray na. ");
INSERT INTO isd_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Ay se yala nga nán ne APU kitu Moses, “Itáyag mu ya ímam se mu ituldu ya lángit, ta senu maggìbat tutu wala ki ngámin Egipto. Ay màmud tutu wala da tolay yán na gìbat,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Ay díkod netáyag tu Moses kurug tu íma na nga nangituldu kitu lángit, ay tútu naggìbat tutu wala ka tallu walgaw tu ngámin Egipto. ");
INSERT INTO isd_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Díkod akkan makapagsisingan datu iEgipto. Tútu áwan nala nga lumawán kaggída kadaya babbabalay da ki unag tallu walgaw. Ngamay kitu giyán datu iIsrael, ay nawada kampela ngin nin. ");
INSERT INTO isd_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Ay tútu pinaayabán tu ári tu Moses ay se na nán kaggína, “Mawe kayun na magday-dáyaw ke APU. Alà nu pe yin daya annánà nu. Ngamay ibansi nu daya bak-báka nu se daya karneru se kalding nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Ngamay nán tu Moses kaggína, “Ngamay masápul atán daya idátun mi se daya masìdug ga pagbasu mi para ke APU nga Dios mi. ");
INSERT INTO isd_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Masápul la alà mi pe ngámin daya bak-báka mi. Awan oray isa ya mabansi kaggída ta masápul la piliyán mi kadaya animál mi ya ibasu mi ka pagdáyaw mi ke APU nga Dios mi. Ay akkan mi pikam ammu nu iina kadayán ya usaran mi nga pagbasu mi ka pagday-dáyaw mi ke APU panda ki di mi akadatang kannán,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ngamay gapu ta pinasúkir ne APU tu uray tu ári, ay akkan na palubúsán na mawe datu iIsrael. ");
INSERT INTO isd_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Ay se la nán tu ári kaggína, “Magtálaw ka! Akkan ka nga magpas-passingan nin kiyà! Nu masingan taka manin ay papatay taka ngin!” nán na. ");
INSERT INTO isd_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Ay nán tu Moses, “Ò á, nu ittu ya nán mu. Panda ku win na magpassingan kikaw,” nán tu Moses. ");
INSERT INTO isd_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ay kitu akkan pikam nagtálaw tu Moses kitu àráng tu ári, ay nán pikam ne APU kaggína, “Isa pikam ma dúsa ya iddè kiya ári se kadaya iEgipto. Kalpasán nedi, ay papannan nakayu win. Ay pilítan nakayu wa pataláwan tutu wala ngin. ");
INSERT INTO isd_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Kagiyan mu win kadaya ngámin tolay nga magadang da kadaya keliyán da nga iEgipto kadaya balitù se daya nakangin-ngína nga iggagaldid da,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Pinagmáru tutu wala ne APU datu iEgipto kadatu iIsrael. Ay se tu Moses, ay aggína tu kapàgán na tolay ki ngámin íli Egipto. Pà-pàgan datu bobonan tu ári se datu tolay. ");
INSERT INTO isd_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ay se la nán tu Moses manin kitu ári, “Tu idi ya nán ne APU, ‘Nu túlad gabi, ay umbet tà magdàdàdà ki ngámin Egipto. ");
INSERT INTO isd_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Ay ngámin daya manákam ma laláki ki Egipto, ay matay da ngámin. Manggayát kiya manákam ma an-anà naya ári nga laláki, nga ittu ya sumarunu nga magári, panda kiya manákam ma an-anà a laláki naya asassu wa babay nga para irid ki trígo. Ay oray pe daya nunna nga urbun daya an-animál nga toru, ay matay da pe. ");
INSERT INTO isd_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ay napágus tutu wala ya agsasángit daya iEgipto. Ay áwan tutu wala pikam ya nàwa nga agsángit nga ummán kiyán, ay akkan pe yin na màwa ka panda. ");
INSERT INTO isd_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Ngamay kadaya iIsrael, ay áwan na la nga magìna oray agtol da átu wala, gapu kadaya tolay onu gapu kadaya animál, ta senu ammuwán nu nga pagdumáan ne APU daya iEgipto se daya iIsrael. ");
INSERT INTO isd_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ay daya ù-upisiyál mu, ay umbet da kiyà a makim-imallà nga nán da, Magtálaw kayun se daya tolay nga maminya kumíwid kikaw, nán da kiyà,’ nán na. Ay magtálaw wà kurug kiyán nin,” nán tu Moses. Ay sirrurungat pànang nga namánaw kitu ári. ");
INSERT INTO isd_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ay se la nga nán ne APU kitu Moses, “Akkan naka pikam kur-kurugan ya ári. Màwa yán ta senu adu pikam daya mepas-passingan ku kadaya ngámin iEgipto kadaya nakas-kasdáaw wa ipas-passingan ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Nepassingan tu Moses se tu Aaron ngámin dedi nga nakas-kasdáaw kitu ári. Ngamay pinasúkir ne APU tu uray natu ári. Díkod akkan na tutu wala palubúsán na magtálaw kitu íli na datu iIsrael. ");
INSERT INTO isd_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Ay nán manin ne APU kitu Moses se kitu Aaron kitu kowad da ka Egipto, ");
INSERT INTO isd_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Manggayát kídi yin, idi nga búlán ya panggayatán nu wa magbíláng kadaya búlán naya dagun. ");
INSERT INTO isd_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Kagiyam kadaya ngámin na iIsrael nga kiya mekasangapúlu wa algaw nedi ya búlán, ngámin daya apu daya magkukobung, ay mangalà da ka isa nga urbun karneru ka para kiya kukobung da. Isa urbun ki kada magkukobung. ");
INSERT INTO isd_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ay nu abay pànang ya urbun para kiya isa nga balay ta bittì da, ay makipnu da ngala ngin kiya karúba da, ay se dala nga pagbibingáyan ya urbun sigun kiya kaadu daya mangán. ");
INSERT INTO isd_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ya urbun, ay mabalin na karneru onu kalding. Ngamay masápul la tangadagun na ngin na toru, ay se áwan na tutu wala nga sad-sadúra. ");
INSERT INTO isd_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ikísi nu panda kiya gabi naya mekasangapúlu se appát ta algaw nedi ya búlán, nga ittu yán ya agparti nu ngámin na iIsrael kadaya urbun. ");
INSERT INTO isd_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ay se da la nga mangalà kitu dága se dala nga ipinta kiya gamba naya gagyangán naya balay ya panganán da kiya karni na. ");
INSERT INTO isd_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Kiyán na gabi, ay isúnu da ya karni se da nga kanan kiyán kam ma gabi. Isida da ka sinápay ya áwan na pamalbád, se tagilpa nga napet. ");
INSERT INTO isd_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Akkan kayu magkilaw onu maglanggang kiya karni. Masápul isúnu nu oray ya úlu, onu daya síkil se daya sinay. ");
INSERT INTO isd_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ay masápul la áwan nu wa ibunna kiya pagmakát. Ay nu atán bunna nu, ay masápul sìdúgan nu. ");
INSERT INTO isd_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ay ki angngán nu, ay ummán pe kídi ya kuwaan nu: magbádu kayu win ki para kiya agtálaw nu, ay se magsandál kayun, ay se im-immán nu pe yin ya tàdukud nu, ay se magburung kayu wa mangán. Ittu idi ya agpiyasta nu gapu ki ilillíwán ku nga APU. ");
INSERT INTO isd_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Ata kiyán na gabi, dàdáan ku ya ngámin Egipto se ku la nga patayan ngámin daya manákam ma laláki nga annánà daya iEgipto se daya nunna nga toru nga annánà daya an-animál da. Ay dadàlan ku pe kiyán na oras daya ngámin na sinan diy-diyos kiya Egipto. Ta iyà ya APU. ");
INSERT INTO isd_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ay ya dága nga nepinta nu kadaya gagyangán daya babbalay nu ya pangimaddán ku kadaya babbabalay nga giyán nu. Ay nu masingan ku ya dága, ay làtáwan takayu. Awan kadakayu ya meráman kiya ammánis ku kadaya iEgipto. ");
INSERT INTO isd_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Idi nga algaw, ay masápul la dam-damdamman nu se daya gakagaka nu peyapeyang ngin ka áwan panda. Bílin ku yán kadakayu. Magpiyasta kayu ka angsilibrár nu kídi nga algaw para ke APU. ");
INSERT INTO isd_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Ki unag naya pittu wa walgaw, ay sittu ya sinápay nga áwan pamalbád ya kanan nu. Ki munna nga algaw nayán, ay ippà nu ngámin daya pamalbád da atán kiya balay nu. Ata ya mangán kiya sinápay ya atán pamalbád kiya unag nayán na pittu walgaw, ay akkan nin mebíláng nga iIsrael. ");
INSERT INTO isd_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Kiya munna se mekapittu nga algaw, ay magguurnung kayu ngámin na magday-dáyaw kiyà. Awan ya magubra kadakayu, malaksid dala nu maglútu kayu ka kanan nu kampela ngin nin. ");
INSERT INTO isd_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Ay masápul la silibráran nu ya Piyasta nga panagkakán nu ka sinápay ya áwan pamalbád. Ata kiyán na algaw, ay netálaw takayu ka Egipto. Túya silibráran nu yán na algaw, dakayu se daya ngámin na gakagaka nu, ta tu idi ya bílin ku kadakayu peyapeyang ngin. ");
INSERT INTO isd_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Ay kiya gabi naya mekasangapúlu se appát ta algaw naya munna nga búlán, ay mangán kayu ka sinápay ya áwan pamalbád panda kiya pagmakát naya mekàduwa púlu se isa kiyán na búlán. ");
INSERT INTO isd_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Kiya unag pittu walgaw masápul la áwan tutu wala ya pamalbád kiya unag balay nu. Ay oray iinna ya mangán ka sinápay ya napayán ka pamalbád, ay akkan mebíláng yán nin nga iIsrael, sangaíli mán onu gángay iIsrael. ");
INSERT INTO isd_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Ay akkan kayu mangán ka oray nágan na nga atán pamalbád. Oray ka wàna nga pagyanán nu, ay masápul la áwan pamalbád da sinápay ya kanan nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ay se la nga kirrawán tu Moses datu ngámin na pangmanàman datu iIsrael, ay se na nán kaggída, “Mamíli ya isa isa kadakayu ka urbun karneru onu urbun kalding ka partiyan nu ka kanan na pamilya nu ki Paskuwa. ");
INSERT INTO isd_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Nu naparti yin ya urbun, ay mamsat kayu ka isopo, ta ittu ya pagpinta nu kadaya gagyangán nu kiya dága naya urbun. Ay nu napintáan nin ya gagyangán nu ka dága, ay áwan nin ya lumaw-lawán kadakayu panda ki pagmakát. ");
INSERT INTO isd_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Ata umbet magdàdàdà e APU nga magpatay kadaya iEgipto. Ay nu masingan naya gagyangán na napintáan ka dága, ay làtáwan nayán na balay. Akkan na palnàan ya magpatay kiya balay nu. ");
INSERT INTO isd_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Manggayát kiddi yin ka panda, ay kuwaan nu idi nga bílin ku kadakayu se daya ngámin na gakagaka nu. ");
INSERT INTO isd_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Ay nu dumatang kayu win kiya íli nga nekari ne APU nga idde kadakayu, ay sil-silibráran nu ya Paskuwa ki káda dagun. ");
INSERT INTO isd_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ay nu saludsúdan daya annánà nu, nu nágan naya sarut nedi nga agsilibrár nu, ");
INSERT INTO isd_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ay kagiyan nu kaggída nga ‘Ittu ya agbasu tada ke APU ka angsilibrár tada kiya nanglàtaw na kadaya balay tada ngámin na iIsrael, kane patayan na daya manákam ma laláki nga annánà daya iEgipto. Liniwánan na daya babbabalay tada,’ nán nu” nán ne Moses. Ay dinay-dáyaw datu tolay nge APU. ");
INSERT INTO isd_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ay se yala nga nawe datu iIsrael se da kinuwa tu ummán kitu pàwa ne APU kaggída nga nepekagi na kitu Moses se tu Aaron. ");
INSERT INTO isd_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ay kitu túlad tu gabi, ay pinatayán ne APU ngámin datu manákam ma lalláki nga annánà datu iEgipto, neráman na ngámin oray tu manákam ma laláki nga an-anà tu ári nga ittu sumarunu kaggína nga mangituráy ka Egipto, se daya mannákam ma lalláki nga annánà datu bálud nga atán ki agba-balúdán. Pinatayán na pe datu ngámin nunna nga toru daya animál da. ");
INSERT INTO isd_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Ay ginumniya tu ári kitun na gabi se datu ù-upisiyál na, ay se ngámin datu iEgipto. Nagìna na tu aggul-ulul tutu wala datu tolay, áta áwan balay nga áwan minatay na. ");
INSERT INTO isd_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ay tútu pinaayabán natu ári tu Moses se tu Aaron kitun na gabi, ay se na nán kaggída, “Ara, magtálaw kayun kanedi! Panáwan dakami se daya tolay ku. Dakayu ngámin na iIsrael. Mawe kayu ngámin nin na magday-dáyaw ke APU nga ummán kitu piyán nu wa kuwaan. ");
INSERT INTO isd_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Alà nu ngámin daya bak-báka nu, se daya karneru se kalding nu, se kayu magtálaw win. Ay se ikarárag dà pe ta kalakkán nà din,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Ay binur-burung datu iEgipto nga pinatálaw datu iIsrael kitu íli da ta nán da, “Matay kami ngámin nin,” nán da. ");
INSERT INTO isd_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Ay tútu nabur-burung pe yala nga nagtálaw datu tolay. Inalà da pe yala ngin datu limmug da nga arína nga akkan pikam napayán ka pamalbád nga atán kadatu aglammugán da nga lagíma. Ay se da nga tinúput datun se da la nga pintukelán. ");
INSERT INTO isd_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ay nagadang pe datu iIsrael ka balitù se datu nakangin-ngína nga iggagaldid se bádu kadatu keliyán da nga iEgipto nga ummán kitu kinagi tu Moses kaggída. ");
INSERT INTO isd_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Ay kinuwa ne APU nga pàgan datu iEgipto datu iIsrael. Ay díkod niddánán nala datu iEgipto datu ngámin na agngan datu iIsrael. Díkod, adu tutu wala datu inalàán datu iIsrael kadatu iEgipto. ");
INSERT INTO isd_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Ay díkod naggayát ka Rameses, ay nagdal-dalen da la nga nawe datu iIsrael ka Succot. Moli annam gatut ta ríbu datu lalláki ngala nga nagdal-dalen, akkan meráman datu babbay se datu annánà. ");
INSERT INTO isd_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ay adu pe datu nagbal-baláki nga agtangeli nga kummíwid kaggída. Adu tutu wala datu báka se karneru se kalding nga netúgut da. ");
INSERT INTO isd_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ay linútu da la ka sinápay datu limmug ga arína nga netúgut da. Akkan napayán ka pamalbád gapu kitu nekàtatán da nga nagtálaw ka Egipto. Tútu áwan da oras. Akkan da pe nakapagsagána kadatu bálun da. ");
INSERT INTO isd_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Ya dágup tu dagun na inag-agyán datu iIsrael ka Egipto, ay appát gatut se tallu púlu dagun. ");
INSERT INTO isd_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ay kitun mismu nga algaw wa kabalin natu mekappát gatut se tallu púlu walgaw, ay ittu tu inagtálaw datu ngámin na tolay ne APU ka Egipto. ");
INSERT INTO isd_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ittu tun na gabi tu inagtagasíngan ne APU kadatu iIsrael, kitu nangitálaw na kaggída ka Egipto. Ay idi pe nga gabi, ay ittu ya dam-damdamman peyang pe datu iIsrael se datu gakagaka da ka áwan panda ka ammadáyaw da ke APU. ");
INSERT INTO isd_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Ay se la nán ne APU kitu Moses se kitu Aaron, “Tu idi ya lintag ki Piyasta nga Paskuwa: áwan agtangeli nga mangán kiya kanan nu ki Paskuwa. ");
INSERT INTO isd_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Ngamay daya ginátang nu wa asassu nu wa nakúgit tin, ay annung da ya mangán kadaya akakkanan ki Paskuwa. ");
INSERT INTO isd_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Akkan mabalin mangán pe daya sangaíli nu se daya pillu nu wa magubra kadakayu. ");
INSERT INTO isd_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Kanan nu wala ki isa nga balay ya pinarti nu nga urbun karneru onu urbun kalding. Akkan kayu mangilawán kiya balay kiya karni na. Ay se áwan nu wa ritúan na tuláng na. ");
INSERT INTO isd_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Masápul la silibráran ngámin daya iIsrael idi nga Piyasta nga Paskuwa. ");
INSERT INTO isd_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Ay nu atán agtangeli nga mepagyán kadakayu, ay se piyán na ya mepangán kiya Paskuwa, ay masápul pikam ma kugítan nu daya ngámin na laláki kiya pamilya na. Mebíláng pe yin na isa kadakayu, ay díkod annung na ngin ya mepangán kiya Paskuwa. Ngamay akkan mabalin mepangán daya akkan nakúgit. ");
INSERT INTO isd_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Sissa ya lintag para kadakayu se para kadaya agtangeli nga mepagyán kadakayu,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Ay díkod kinurug ngámin datu tolay tu nebílin ne APU kitu Moses se tu Aaron. ");
INSERT INTO isd_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ay kitun mismu nga algaw, ay ittu tu inangngitálaw ne APU kadatu ngámin iIsrael kitu íli Egipto. ");
INSERT INTO isd_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Ay nán ne APU kitu Moses, ");
INSERT INTO isd_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Ikísim para kiyà ngámin daya lalláki nga munna nga meanà, tolay mán onu animál. Kuwà ngámin daya manákam ma meanà,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Ay nán tu Moses kadatu tolay, “Akkan nu kal-kaligpanán idi nga algaw wa nekawayaán nu kiya inangngasassu daya iEgipto kadakayu, se ya inagtálaw nu ka Egipto. Ata gapu kiya pannakabalin ne APU, ay netálaw nakayu kanedi nga giyán. Kídi nga algaw, akkan kayu tutu wala mangán ka sinápay ya napayán ka pamalbád. ");
INSERT INTO isd_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Idi nga munna nga algaw naya búlán Abib (búlán na agmayán daya mait) ya agtálaw nu ki Egipto. ");
INSERT INTO isd_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Silibráran nu idi nga Piyasta ki káda nga munna nga búlán ki dagun, nu mippan nakayu ne APU win kiya napiya se nadam-ag tutu wala nga lusà nga nekar-kari na kadatu apuapu nu. Atán pikam da Cananeo, se daya Heteo, se daya Amorreo, se daya Heveo, se daya Jebuseo kiyán na lusà. ");
INSERT INTO isd_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Ki unag pittu walgaw, ay áwan kadakayu ya mangán ka sinápay ya napayán ka pamalbád. Ay kiya mekapittu wa algaw, ay magpiyasta kayu ka agday-dáyaw nu ke APU. ");
INSERT INTO isd_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Ki unag pittu walgaw, tittu daya sinápay ya áwan pamalbád ya kanan nu. Ay masápul la áwan masmà a pamalbád onu sinápay ya atán pamalbád na ki oray ka wàna kiya íli nu. ");
INSERT INTO isd_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ay ikagi nu kadaya annánà nu wa lalláki, nga kuk-kuwaan nu idi gapu kiya kinuwa ne APU para kadakayu kitu nagtálaw nu ka Egipto. ");
INSERT INTO isd_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ay idi nga piyasta, ay árig na ya panda ngala nga nippapáy kiya kurimang nu, onu kiya kíday nu ka panamdammán nu peyang kadaya bil-bílin ne APU. Ata gapu kiya pannakabalin ne APU, ay netálaw nakayu ka Egipto. ");
INSERT INTO isd_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Díkod akkan nu kal-kaligpanán dedi nga bil-bílin. Dam-damdamman nuda nu umbet ya oras da kampela ngin ki kada dagun. ");
INSERT INTO isd_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Ay nu mippan nakayu ne APU win kiya íli nga nekar-kari na nga idde kadakayu se kadatu apuapu nu nga ittu ya giyán pikam daya Cananeo, ay se midde na pe yin kadakayu, ");
INSERT INTO isd_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ay masápul la ikísi nu para ke APU ngámin daya mun-unna nga laláki nga annánà nu; se daya mun-unna nga toru daya áyam nu, ay mepakin-kuwa da ke APU. ");
INSERT INTO isd_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Ngamay daya mun-unna nga toru nga an-anà daya asnu nu, ay sukatán nu ke APU ka urbun karneru. Ay nu akkan nu masukatán, ay masápul ritúan nu ya bùlaw na. Ay ngámin pe nga manákam ma laláki nga an-anà nu, ay masápul la sakaan nu ke APU. ");
INSERT INTO isd_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Ay nu umbet ya oras sa agsaludsud naya an-anà nu, nu nágan naya piyán kagiyan naya ummán kiyán na kuwaan nu, ay ittu idi ya ikagi nu kaggína, ‘Gapu kiya pannakabalin ne APU, ay netálaw nakami ngámin ka Egipto kitu inangngasassu datu iEgipto kadakami. ");
INSERT INTO isd_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Ay kitu nagsúkir natu ári nga akkan nakami papannan, ay pinatayán ne APU ngámin datu manákam ma laláki nga annánà datu iEgipto se datu ngámin nunna toru nga annánà datu an-animál da pe. Ay túya medátun ngámin daya munna nga lalláki nga annánà daya an-animál. Ngamay ngámin daya manákam ma laláki nga annánà, ay masápul masaka da,’ nán nu kaggína. ");
INSERT INTO isd_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Iyán na kuwaan nu, ay meárig ka panda ngala nga megalut kiya kurimang nu, onu mippáy kiya kíday nu ka pakadamdammán nu nga gapu kiya pannakabalin ne APU, ay netálaw nakayu ka Egipto,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Ay kane pataláwan natu ári datu tolay yin, ay nealekaw ne APU da kitu íli datu Filisteo kane idalen nada, nga ittu tun kuma tu adanni nga dalenan da, áta nán ne APU Dios nga, “Get tala nu makappoli daya tolay nu gubatan dada daya kalínga da, ay magulli da ka Egipto,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ay díkod nealekaw ne Dios da kitu ir-ir-er ra mameyag kitu Daggáng nga Bebay. Ay datu iIsrael, ay sissasagána da nga makigubát kitun na nagtálaw da kitu íli Egipto. ");
INSERT INTO isd_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Kitun na nagtálaw da, ay netúgut pe tu Moses datu tuláng tu Jose, áta nepesipata na kadatu iIsrael nga kuwaan da tu piyán na. Ay nán na kaggída kitun, “Umbet ya oras nga angngalà ne Dios kadakayu. Ay kiyán na oras, ay masápul la alà nu daya tuláng ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Ay tútu nagrubbuwát da ka Succot, ay se da la nga nangipasíkád ka kampu da kane dummatang da ka Etam kitu panda natu ir-ir-er. ");
INSERT INTO isd_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Ay kitu agdal-dalen da, ay uwad ummán ka abay tutu wala nga adígi nga angap nga nagin-inunna kaggída nu algaw. E APU tun nga mangitur-turung kaggída. Ngamay nu gabi tu agdal-dalen da, ay maginunna kaggída tu ummán ka abay tutu wala nga adígi nga apuy, nga ittu tu dílág da, ta senu annung da ya magdal-dalen ki algaw se gabi. ");
INSERT INTO isd_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Akkan tutu wala nga umawan kitu àráng datu tolay tu angap nu algaw se tu apuy nu gabi kitun na nagdal-dalen da. ");
INSERT INTO isd_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ay se la manin nán ne APU kitu Moses, ");
INSERT INTO isd_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Kagiyan mu kadaya tolay ya magulli da, ta magkampu dala ngin kitu adanni ki bebay kitu àráng Pihahirot, kitu nagbàtán Migdol se tu Daggáng nga Bebay, kitu pane àráng kitu Baal-zefon. ");
INSERT INTO isd_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Ay díkod nán naya ári ka Egipto nga nagal-aliwagwag kayu, ay se napúkù kayu kiya ir-ir-er. ");
INSERT INTO isd_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ay pagsukíran ku ya uray naya ári, ay díkod aplan nakayu. Ay mapadayáwan nà manin kiya angngábà ku kiya ári se kadaya suldádu na. Gapu kiyán, ay mammuwán daya iEgipto nga iyà ya APU,” nán na. Ay ittu tu kinuwa da kurug. ");
INSERT INTO isd_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ay kane kagiyan da kitu ári nga nagtálaw datu iIsrael lin, ay naulis manin tu uray na se datu uray datu ù-upisiyál na. Ay nán da, “Sinnan nu kod ya kinuwa tada! Tura tada pinapan datu iIsrael lin, ay aggída mà tu magsur-surbi kadàtada!” nán da. ");
INSERT INTO isd_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Díkod nepesagána na tu takay na, se na inayabán datu suldádu na. ");
INSERT INTO isd_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Annam gatut tu kapíyán na takay suldádu tu inalà da, ay se inalà da pe ngámin datu takay suldádu ka Egipto. Atán ap-apu ngámin dayán. ");
INSERT INTO isd_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Pinagsúkir ne APU tu uray natu ári ka Egipto. Ay díkod nagrubbuwát da ngin na mangpal kadatu iIsrael la sittuturad da magtálaw win. ");
INSERT INTO isd_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Impal datu suldádu nga iEgipto da nga sittatakay kitu kabalyu da se kadatu takay suldádu da. Uwad pe datu kabalyu natu ári se ngámin datu suldádu na. Ay sinìmát dada nga atán magkampu kitu adanni kitu bebay nga adanni pe ka Pihahirot kitu pane àráng Baal-zefon. ");
INSERT INTO isd_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Ay kane umadanni tu ári kitu giyán da, ay naamawán datu iIsrael da. Ay nasingan da nga atán datu suldádu nga iEgipto nga umad-adanni kaggída. Ay díkod nagansing da tutu wala. Ay tútu nagkarárag datu iIsrael ke APU. ");
INSERT INTO isd_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ay se da nán kitu Moses, “Taanna, tura nakami yala nippan kanedi ir-ir-er ra matay? Awan agkà kampusantu ka Egipto wa annung da pangitamnán kadakami ta? Sinnam kod ya kinuwám! Tura nakami netálaw ka Egipto! ");
INSERT INTO isd_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ittu mà idi kammala tu nán mi kikaw win ka Egipto! Tútu kinagi mi nga bay-án nakami yala nga magsurbi kadaya iEgipto. Ta napì-piya ya magsurbi kadaya iEgipto, may ya matay kídi ir-ir-er,” nán da. ");
INSERT INTO isd_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Ngamay nán tu Moses kadatu tolay, “Bag-bagkaddan nu wala daya ur-uray nu, ay se akkan kayu wa magansing. Sinnan nu wala ya angngilísi ne APU kadakayu kídi. Ata daya iEgipto nga sisinnán nu kídi, ay áwan nu wa masingan nin kaggída nu kuwa. ");
INSERT INTO isd_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","E APU ya makigubát para kadakayu. Maging-inggap kayu wala,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ay nán ne APU kitu Moses, “Taanna, tura ka pikam mala makiseng kiyà. Kagiyan mu kadaya tolay nga itul-túluy da la ya agdal-dalen da. ");
INSERT INTO isd_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Itáyag mu ya tàdukud mu, se mu la ibúgit kiya bebay, ta senu magtuway ya danum, ay senu magdal-dalen dala kiya namaga nga lusà nga dumalákit kiya bebay daya iIsrael. ");
INSERT INTO isd_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ay pagsukíran ku daya uray daya iEgipto, ta senu aplan dakayu ki agbàláng nu, ay senu madáyaw wà kiya angngábà ku kiya ári se daya suldádu na se daya magtatákay kadaya takay na se daya suldádu na nga sittatakay kadaya takay da. ");
INSERT INTO isd_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ay díkod mammuwán daya iEgipto nga iyà ya APU, nu napadayáwan nà in kiya angngábà ku kiya ári da, se daya suldádu na nga sittatakay kadaya takay na, se daya sittatakay kadaya takay da kampela ngin nin,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ay se la nga nagpalodi tu anghel ne Dios nga nagin-inunna kadatu iIsrael kitu agdal-dalen da. Ay tu magin-inunna kaggída nga ummán ka abay pànang nga adígi nga angap, ay nagpalodi pe. ");
INSERT INTO isd_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Atán nin kitu nagbàtán datu iIsrael se datu suldádu nga iEgipto. Ay naggìbat tu tapíngit ta padne kitu giyán datu iEgipto. Ngamay nawada tu tapíngit ta padne kitu giyán datu iIsrael. Díkod akkan makaadanni datu iEgipto kaggída. ");
INSERT INTO isd_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Ay se la nga netáyag tu Moses datu íma na se nu ibúgit kitu bebay. Ay nalawagán nga pinagbáli ne APU ka naggat tutu wala nga nagpagayát ka pane lattakán, ay ittu tu namagtuway kitu danum. Namaga nga lusà tu nagtuwayyán tu danum. ");
INSERT INTO isd_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Ay díkod nanalen nala nga dummalákit datu iIsrael kitu bebay. Nanalen da kitu nagbàtán tu danum nga ummán ka darupírip kitu magpíngit kaggída. ");
INSERT INTO isd_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ay impal datu suldádu wa iEgipto da, se datu suldádu natu ári nga sittatakay kadatu kabalyu na, se datu sittatakay kitu takay suldádu. Dumalákit da kuma pe kitu bebay. ");
INSERT INTO isd_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ay kane danni láwa ngin, e APU nga atán kitu apuy se kitu angap, ay nasingan na datu iEgipto. Ay tútu pinagriddù nada. ");
INSERT INTO isd_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Netalatalán datu lígay datu takay da, ay tútu nasulitán da tutu wala. Ay tútu nán datu iEgipto, “Pagdita tada ngala daya iIsrael lin, ta e APU ya mangigdù kaggída kadàta nga iEgipto,” nán da. ");
INSERT INTO isd_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ay se la nga nán ne APU kitu Moses, “Itáyag mu manin daya ímam se mu ibúgit kiya bebay, ta senu magamung manin daya danum, ay senu malnap daya iEgipto nga sittatakay kadaya takay da nga suldádu se kadaya kabalyu da,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Ay tútu netáyag kurug tu Moses datu íma na, se na ibúgit kitu bebay. Ay tútu nagulli kammin kitu napadan na gangay na tu bebay kane pagmakát. Magtálaw kuma datu iEgipto nga nán da, ngamay linimat ne APU da ngala ngin kitu túlad tu bebay. ");
INSERT INTO isd_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Nagamung kammin tu danum, ay díkod linnap na datu takay datu suldádu se datu sittatakay kadatun, se ngámin na suldádu natu ári nga inumpal kadatu iIsrael kitu bebay. Awan nabiyág kaggída oray isa. ");
INSERT INTO isd_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Ngamay datu iIsrael, ay nagdal-dalen da ngala kitu namaga nga dálen kitu nagbàtán tu nagtuway ya danum nga ummán ka darupírip kitu magpíngit kaggída. ");
INSERT INTO isd_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Ay díkod kitun na algaw, ay nigdù ne APU datu iIsrael kadatu iEgipto. Nasingan datu iIsrael kitu dappit tu bebay datu baggi datu iEgipto nga nagkakátay. ");
INSERT INTO isd_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Ay nasingan ngámin datu iIsrael tu nakas-kasdáaw wa kinuwa ne APU kadatu iEgipto. Ay díkod nagansing da se nangurug da ke APU se kitu Moses nga bobonan na. ");
INSERT INTO isd_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Ay se yala nga nagkansiyon de Moses se datu iIsrael ka pagdáyaw da ke APU. Ay nán na kídi tu kansiyon da, “Magkansiyon nà ke APU gapu kiya nadáyaw wa nangábà na. Linimat na daya kabalyu se datu magtatákay kaggída ki bebay. ");
INSERT INTO isd_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","E APU ya pabilgan ku. Ay aggína ya nangigdù kiyà. Aggína ya Dios ku, ay se day-dayáwan ku. Aggína pe ya Dios datu apuapu ku, ay túya ipangátù. ");
INSERT INTO isd_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","E APU, ay nabílag ki gubát. Yahweh ya ngágan na. ");
INSERT INTO isd_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Nelimat na kiya bebay datu suldádu naya ári se datu takay da. Nelimat na datu karungtán na suldádu naya ári kiya Daggáng nga Bebay. ");
INSERT INTO isd_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Nalnap da. Inumlad da nga ummán ka batu. ");
INSERT INTO isd_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Naturáy se mannakabalin ya diwanán na ímam, O, APU, ta netar-tarawesáng ngala daya kalínga mu. ");
INSERT INTO isd_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ay gapu kiya kinaturáy mu tutu wala, ay ur-úray la daya kumalínga kikaw. Gapu kiya rungat mu, ay masìdug da ngala nga ummán ki dànág. ");
INSERT INTO isd_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Oray ya aggángat mu wala, ay naurnung ya danum, ay se nagsíkád da ummán ki darupírip, ay nagsibbukal lala ya danum ki túlad bebay. ");
INSERT INTO isd_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Ay nán daya kalínga, ‘Aplan kuda. Sìmatan kuda. Abáan kuda, se ku alà daya kuw-kuwa da. Alà ku ngámin ya piyán ku kaggída. Patayan kuda ki ampiláng ku. Ya ímà mismu ya mamatay kaggída,’ nán da. ");
INSERT INTO isd_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ay kane pagbaliyam, ay nalnap da ki bebay. Inumlad da ngala nga ummán ki buli kitu magsag-saggiyár nga danum. ");
INSERT INTO isd_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Awan mepáda kikaw APU, oray iinna nga diy-diyos. Nakas-kasdáaw ya kinadáyaw mu se kinamárum. Ay nakas-kasdáaw pe ya diláng mu se daya kuk-kuwaan mu. ");
INSERT INTO isd_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Kane ùnatan mu wala ya diwanán na ímam, ay sillan lusà da ngala. ");
INSERT INTO isd_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Gapu kiya akkan maul-ulis nga aminya mu, ay neturung mu daya tolay mu wa inalà mu. Gapu kiya pannakabalin mu, ay netur-turung muda panda kiya nasantuwán na lusà a giyán mu. ");
INSERT INTO isd_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Kane magìna da tolay ya kinuwám, ay nagansing da tutu wala. Daya umíli ka Filistia, ay magansing da. ");
INSERT INTO isd_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Ay nagansing tutu wala pànang daya agtuturáy da ka Edom. Ay nagpil-pilpig datu à-apu daya iMoab kitu ansing da tutu wala. Ay daya umíli ka Canaan, ay naawanán da ka namnáma gapu ki ansing da. ");
INSERT INTO isd_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Napalotán tu aggansing da gapu kiya napágus tutu wala nga pannakabalin mu. Ummán da tutu wala ki batu wa áwan kíni-kínin panda kiya akalíwán daya netálaw mu, O APU, nga tolay mu. ");
INSERT INTO isd_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Alà muda tolay mu, ay se muda nga paggunàan kiya bantay mu, nga ittu ya pinagbalin mu, O APU, ka pagag-agyanán se giyán mu, O APU nga ikaw kampela ngin nin ya nangwa. ");
INSERT INTO isd_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","E APU ya magturáy peyapeyang ngin ka áwan panda.” ");
INSERT INTO isd_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Kane atán datu kabalyu natu ári se datu takay suldádu se datu sittatakay kadatun nga manalen da kuma pe kitu namaga nga lusà, ay pinagamung kammin ne APU tu nagtuway nga danum. Ngamay datu iIsrael, ay nagdal-dalen da ngala kitu namaga nga lusà kitu bebay. ");
INSERT INTO isd_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ay tu Miriam nga isa nga profeta nga wagi tu Aaron, ay nangalà ka kir-kirreng, ay se nala nga negayát nga magsasála datu kabbulun na nga babbay nga atán kir-kirreng pe. ");
INSERT INTO isd_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Ay se la nga nangansiyon tu Miriam. Tu idi tu kansiyon na, “Magkansiyon kayu ke APU, ta nadáyaw tutu wala ya nangábà na. Linimat na ki bebay datu kabalyu se datu magtatákay kaggída,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ay se la nga nirbuwát tu Moses datu iIsrael kitu Daggáng nga Bebay, se da mawe kitu ir-ir-er ka Sur. Tallu walgaw da kitu ir-ir-er may áwan da masmà nga danum. ");
INSERT INTO isd_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ay kane dummatang da ka Mara, ay akkan da mainum tu danum na ta napet. Ittu lugud tu gapu na nengágan ka Mara, ta napet tu danum kitúni. ");
INSERT INTO isd_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Ay tútu nagríri datu tolay kitu Moses nga nán da, “Ay nágan naya inuman mi yin?” nán da. ");
INSERT INTO isd_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Ay tútu nakiseng tu Moses ke APU. Ay tútu uwad netùgud ne APU nga káyu. Inalà ne Moses tu káyu, ay se na ipisù kitu danum, ay tútu nagbalin ka namit tu danum min. Ay kitúni, ay uwad kinagi ne APU kaggída nga bílin na masápul surútan da. Ay sinisímán nada kitúni. ");
INSERT INTO isd_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ay nán na, “Nu gìnán nu tutu wala ya kagiyan ku nga APU nga Dios nu, ay se nu kuwaan ya kustu ki agsisíngan ku, ay se nu kurugan daya lin-lintag se bil-bílin ku, ay akkan takayu pagtakitan. Akkan màwa kadakayu tu kinuwà kadatu iEgipto. Ata iyà nga APU ya mamabílag kadakayu,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ay se da la nga dumatang ka Elim nga giyán datu sangapúlu se duwa nga gabbuwà, se pittu púlu wa múla nga ummán ki buwa. Ay nagkampu da kitu adanni kadatu danum. ");
INSERT INTO isd_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Ay nagrubbuwát manin datu ngámin na iIsrael ka Elim. Nawe da manin, ay se dala nga dummatang kitu ir-ir-er ka Sin, nga atán kitu nagbàtán Elim se Sinai. Tu algaw wa nedaddatang da kitúni, ay kitu mekasangapúlu se limma natu mekàduwa búlán panda kitu inagtálaw da ka Egipto. ");
INSERT INTO isd_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ay ngámin da nga iIsrael, ay nagríri da kitu Moses se kitu Aaron kane atán da kitu ir-ir-er. ");
INSERT INTO isd_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Ay nán da kaggída nga duwa, “Napì-piya kuma ngala nu pinatayán nakami ne APU win kitu kowad mi pikam ka Egipto nga magbattug kadatu karni se sinápay kannán. Ngamay nilbet nakami kídi ya ir-ir-er nga matay ngámin ki bisin,” nán da. ");
INSERT INTO isd_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ay se yala nga nán ne APU kitu Moses, “Sinnam á ta pagudanan ku ka makkán. Ay inalgaw wala ya aggalà nu se daya tolay ka annung nu wala kanan ki tangalgaw. Ummán kiyán ya kuwaan ku ka paninnán ku nu ikurug da ya bílin ku onu akkan. ");
INSERT INTO isd_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ay ya alà da kiya mekannam ma algaw, ay mamidduwa ya kaadu na kitu al-alà da ki inalgaw,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Ay tútu nán tu Moses se tu Aaron kadatu iIsrael, “Nu gabi, ay mammuwán nu wa e APU ya nangitálaw kadakayu ka Egipto. ");
INSERT INTO isd_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Ay nu pagmakát, ay masingan nu ya kinadáyaw ne APU, áta nagìna na ya agríri nu kaggína. Iin kami ka nán nu ta, nga ririyan nu peyang?” nán da. ");
INSERT INTO isd_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Ay nán tu Moses, “Nu gabi iddán nakayu we apu ka karni, se iddán nakayu ka sinápay nu pagmakát, ta senu mabtug kayu ki piyán nu, áta nagìna na ya nagríri nu kaggína. Ata kiya agríri nu, ay akkan dakami ya kurug ririyan nu, nu di ye APU, ta iin kami ka nán nu ta?” nán tu Moses. ");
INSERT INTO isd_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ay nán tu Moses kitu Aaron, “Kagiyan mu kadaya ngámin tolay nga umadanni da ke APU, ta nagìna na daya ríri da,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ay kitu akun-oni pikam tu Aaron kadatu tolay ay linam-aw datu tolay tu ir-ir-er. Ay nasingan datu diláng ne APU kitu angap. ");
INSERT INTO isd_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ay nakiamomán ne APU kitu Moses nga nán na, ");
INSERT INTO isd_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Nagìna ku ya agríri daya tolay. Kagiyan mu kaggída nga nu masirbut tin ya mata, ay mangán da ngin ka karni. Ay nu pagmakát, ay mabtug da pe a sinápay, ta senu ammuwán da ngámin na iyà ya APU nga Dios da,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ay kane din na gid-gidám min, ay adu tutu wala datu ammà a naglalbet kitu giyán datu báwi da. Ay nalokop tu kampu da kaggída. Ay kane pagmakát adu lapáat kitu giyán datu báwi da. ");
INSERT INTO isd_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ay kane umawan datu lapáat, ay atán kitu útun lusà ya pus-pusà a bibittì a ummán ka ning-ingpit ta papel. ");
INSERT INTO isd_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ay kane masingan datu tolay tun, ay nán da kitu isaisa kaggída, “Nágan dedi?” nán da. Ata akkan da ammu nu nágan datun. Ay nán tu Moses kaggída, “Sinápay yán na nidde ne APU kadakayu ka kanan nu. ");
INSERT INTO isd_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ay tu idi ya bílin ne APU kadakayu, ‘Maggalà ya isaisa kadakayu sigun kiya annung na kanan. Ipànung nu wala kiya kaadu nu kiya isa nga báwi. Gudduwa salup ki kada isa tolay,’ nán na” nán tu Moses. ");
INSERT INTO isd_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Ay ittu kurug tu kinuwa datu tolay. Uwad kaggída datu naggalà ka nasurù kitu masápul da, ay uwad kaggída datu kúráng tu inalà da. ");
INSERT INTO isd_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ngamay kane salupan da ngin, ay áwan sur-surù onu kur-kúráng datu inalàán da. Nepà-pakustu wala kadatu masápul da. ");
INSERT INTO isd_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ay nán tu Moses kaggída, “Akkan kayu mangibunna kiyán,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ngamay akkan da nga kinur-kurug tu Moses. Díkod nangibunna datu duddúma kaggída. Ay naagtán se nabuyù tu nebunna da. Ay tútu nalùsaw tu Moses kaggída. ");
INSERT INTO isd_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Kada pagmakát, ay maggalà da kitun sigun la ngin kitu annung da nga kanan. Ay nu natà-takit sínág gin, ay marúnát pe yin. ");
INSERT INTO isd_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ay ya alà da kiya mekannam ma algaw, ay mamidduwa ya kaadu na kitu inalgaw wa alà da. Agtangasalup ya kada isa tolay kaggída. Ay kane umbet datu pangmanàman datu tolay kitu Moses ta saludsúdan da kaggína nu taanna, ");
INSERT INTO isd_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","ay nán tu Moses kaggída, “Tu idi ya nán ne APU, ‘Kaláwa ay algaw wa pinaggiimáng. Nasantuwán yán na algaw para ke APU. Túya lutuwan nu ngámin nin daya masápul nu. Ay daya bunna nu, ay iarimán nu ka para kaláwa,’ nán na,” nán tu Moses. ");
INSERT INTO isd_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ay díkod nangibunna da nga ummán kitu kinagi tu Moses kaggída. Ay akkan naagtán se akkan nabuyù datu bunna da. ");
INSERT INTO isd_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Ay nán tu Moses kaggída, “Kanan nu kídi nga algaw datu bunna nu. Awan nu masmà kiyán kiya lasi, áta kídi nga algaw ay algaw panaggimáng ne APU. ");
INSERT INTO isd_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Annam ma algaw ya aggalà nu kiyán, ngamay kiya mekapittu wa algaw nga ittu ya algaw wa pinaggiimáng, ay áwan nu wa masmà,” nán tu Moses. ");
INSERT INTO isd_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ay kitu mekapittu wa algaw uwad kaggída datu nawe kammala nga maggalà kuma kitun na akakkanan. Ngamay áwan da nga nasmà. ");
INSERT INTO isd_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ay tútu nán ne APU kitu Moses, “Nungay na ya angikurug nu tutu wala kadaya bil-bílin ku se daya lin-lintag ku kadakayu? ");
INSERT INTO isd_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Sinnan nu kod! Nidde ne APU kadakayu ya algaw wa pinaggiimáng. Túya kiya mekannam ma algaw, ay nidde na kadakayu ya kanan nu kiya duwa algaw. Ay túya magyán kayu wala kiya unag báwi nu kiya mekapittu wa algaw.” ");
INSERT INTO isd_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Ay tútu nagimáng datu tolay kitu mekapittu wa algaw. ");
INSERT INTO isd_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Ay nepangágan datu iIsrael tun na akakkanan ka “mána.” Ummán ka bì-bitì a buk-bukal nga pus-pusà tu singan na tun. Ay ya ramán na, ay ummán ka ramán naya ning-ingpit ta sinápay ya napayán ka digu. ");
INSERT INTO isd_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Ay nán tu Moses kadatu tolay, “Tu idi ya bílin ne APU. ‘Mangisirù kayu ka gudduwa salup kiyán na akakkanan, ta senu masingan daya ngámin gakagaka nu. Díkod masingan da nu wà ummán naya akakkanan na nepakkán ku kadakayu kiya ir-ir-er kitu nangitálaw ku kadakayu ka Egipto,’ nán na,” nán tu Moses. ");
INSERT INTO isd_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Ay nán tu Moses kitu Aaron, “Mangalà ka ka bánga ka pangippayán mu ka gudduwa salup kiya mána, ay se mu la ippáy ki àráng ne APU, ta isirù tada para kadaya gakagaka tada,” nán tu Moses. ");
INSERT INTO isd_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Ay nippáy natu Aaron tu tangabánga nga mána kitu àráng natu arko nga giyán natu nekesurátán datu bil-bílin ne APU Dios, ta iarimán da nga ummán kitu nebílin ne APU kitu Moses. ");
INSERT INTO isd_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Appát púlu dagun na nagkán datu iIsrael kitu mána panda kitu nedaddatang da kitu giyán nga annung da paggunàán, kitu panda natu íli Canaan. ");
INSERT INTO isd_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Ya gudduwa salup, ay pagkapúlu natu iggugukud da kitun). ");
INSERT INTO isd_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Nagtálaw datu iIsrael kitu ir-ir-er ka Sin, ay se da nga mawe ka Refidim. Namin-adu da nga nagsin-sínang, ta ittu tu bílin ne APU. Ay kane dumatang da ka Refidim, ay nagkampu da manin. May áwan da pagsàduwán kitúni. ");
INSERT INTO isd_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Ay tútu nagríri manin datu tolay kitu Moses nga nán da, “Wàna giyán danum ma inuman mi?” nán da. Ay tútu nán tu Moses kaggída, “Tura dà pabasúlan peyang ta? Tura nu peyang pe tistíngan ne APU?” nán na. ");
INSERT INTO isd_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ngamay datu tolay, ay sikkinum da tutu wala, ay tútu magríri da kitu Moses nga nán da, “Tura nakami yala netálaw ka Egipto ta? Ta senu patayan nakami se daya annánà mi se daya an-animál mi ki awwaw mi!” nán da. ");
INSERT INTO isd_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Ay tútu nakiseng manin tu Moses ke APU nga nán na, “Nágan naya pamàyanán ku kadedi tolay yi? Tagay dà tùtoán nin na patayan!” nán tu Moses. ");
INSERT INTO isd_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Ngamay nán ne APU kitu Moses, “Ayabán mu daya pangmanàman daya tolay, ay se kayu maginunna kadaya tolay. Ay alà mu pe tu tàdukud mu wa nebadit mu kitu wángag Nile. ");
INSERT INTO isd_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Mawe kayu ka Horeb. Idaggán taka kitúni kitu giyán tu batu kitúni. Baditán mu tu batu, ay gumbuwà ya danum nga ittu ya inuman daya tolay,” nán na. Ay ittu kurug tu kinuwa tu Moses kitu pagmar-marngán datu pangmanàman datu iIsrael. ");
INSERT INTO isd_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ay nepangágan tu Moses tun na giyán ka Massa se Meriba, áta ittu tu giyán da kitu nammar-parut da se nagríri da ke APU kitu inagkuna da ka, “Bul-bulunan nitta ne APU onu akkan?” nán da. ");
INSERT INTO isd_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Ay kitu kowad da ka Refidim, ay inumbet datu Amalekeo, ay se da ginubát datu iIsrael. ");
INSERT INTO isd_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Ay nán tu Moses kitu Josua, “Magpíli ka kadaya lalláki ta mawe kayu makigubát kadaya Amalekeo. Kaláwa, ay mawe yà a magsisíkád kitu otun tu bantay, ay se ku itatáyag ya tàdukud da pinálà APU kiyà,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Ay kinuwa kurug natu Josua tu kinagi tu Moses kaggína, ay se nawe nakigubát kadatu Amalekeo. Ay tu Moses se tu Aaron se tu Hur, ay nawe da nanùdu kitu bantay. ");
INSERT INTO isd_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Ay nu itatáyag tu Moses datu íma na, ay mangábà datu iIsrael. Ngamay nu ianìgad nada, ay datu Amalekeo datu mangábà. ");
INSERT INTO isd_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ngamay nakásay pe yin datu íma tu Moses. Díkod tu kinuwa da, ay nangalà da ka batu wa nagtugawán na, ay se netatáyag tu Aaron se tu Hur datu íma tu Moses. Nagsissaán da datu íma na. Díkod netatáyag datu íma na panda kitu masirbut tu mata ngin. ");
INSERT INTO isd_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ay tútu inábà de Josua datu Amalekeo. ");
INSERT INTO isd_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ay se la nga nán APU kitu Moses, “Isúrát mu idi ki libru ka panamdammán nu, ay se ikagim ke Josua: Ippà ku tutu wala daya Amalekeo kídi kalawagán, senu áwan makadamdam kaggída ngin,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Ay tútu nangwa tu Moses ka annìdúgán ka pagbasu. Ay nepangágan na ka “E APU ya banderà.” ");
INSERT INTO isd_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ata nán na nga, “Itáyag ku ya bandera naya nangábà ne APU. Gubatan ne APU daya Amalekeo peyapeyang ngin,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Ay tu Jetro nga pádi ka Midian nga katugángan tu Moses, ay nagìna na ngámin datu kinuw-kuwa ne APU para kitu Moses se kadatu iIsrael nga tolay na. Nagìna na nu mapaanna tu nangngitálaw ne APU kadatu iIsrael ka Egipto. ");
INSERT INTO isd_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","4","Ay kane papannan tu Moses tu Zipora nga atáwa na se datu duwa nga annánà da nga lalláki, ay inalà kammin natu Jetro da. Ya ngágan natu isa nga an-anà na, ay Gersom (áta nán tu Moses nga, “Gapu ta agtangeli yà ka nakaru,” nán na.) Ay ya ngágan tu isa, ay Eliezer (áta nán tu Moses nga, “Ya Dios datu apuapu ku ya sinummeng kiyà. Nelísi nà kitu aggasippatay natu ári kiyà,” nán na). ");
INSERT INTO isd_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Ay inumbet tu Jetro nga katugángan tu Moses kitu giyán de Moses kitu ir-ir-er nga ittu tu nagkampuwán da kitu adanni kitu bantay ne APU. Kabulun na tu atáwa Moses se datu duwa nga annánà na. ");
INSERT INTO isd_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Nepekagi na kitu Moses nga nán na, “Atán umbet nge Jetro nga katugángam. Kabulun na ya atáwam se daya duwa nga annánà nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Ay tútu nawe Moses sa nanabat kitu katugángan na, se nagukkab ka angrispitár na kaggína, ay se na inumàán. Nagkikinnumusta da, ay se dala nga nawe kitu báwi natu Moses. ");
INSERT INTO isd_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Ay se yala kinagi natu Moses kitu katugángan na ngámin datu kinuw-kuwa ne APU kitu ári datu iEgipto se kadatu iEgipto gapu kadatu iIsrael. Kinagi na pe datu ngámin na nagrig-rigátan da kitu dadalenán, se datu ngámin na nesisseng ne APU kaggída gapu kadatun. ");
INSERT INTO isd_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Ay naganggam tu Jetro gapu kadatun na napiya nga kinuw-kuwa ne APU para kadatu iIsrael, se itu nangitálaw na kaggída kadatu iEgipto. ");
INSERT INTO isd_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Ay nán tu Jetro, “Maday-dáyaw we APU wa ittu ya nangilísi kadakayu kadatu iEgipto se kitu ári da. ");
INSERT INTO isd_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Kídi, ay ammu ku win na e APU, ay nangátu may ngámin daya diy-diyos. Ata nelísi na daya tolay na kadatu iEgipto nga ittu datu mangirupat tutu wala kaggída,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Ay se la nga nagbasu tu Jetro nga katugángan tu Moses ka sinìdug ga pagbasu ka pagdáyaw na ke Dios. Ay inumbet tu Aaron nga kabulun na datu pangmanàman datu iIsrael, ay se da nepangán kitu katugángan tu Moses kitúni nga nagdayáwan da ke Dios. ");
INSERT INTO isd_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ay kane láwa na, ay ginayatán tu Moses tu nagar-ariglu kadatu ríriríri datu tolay kadatu isaisa kaggída. Ginayatán na kitu pagmakát panda tutu wala kitu gabi yin. ");
INSERT INTO isd_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Ay kane masingan natu katugángan na tun na kuk-kuwaan na para kadatu tolay, ay nán na, “Nágan naya kuk-kuwaan mu? Taanna, tura ka sissa la nga mangwa kiyán para kadaya ngámin tolay? Ay manangalgaw kayu tutu wala se daya tolay!” nán na. ");
INSERT INTO isd_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Ay nán tu Moses kitu katugángan na, “Ata nu atán piyán dedi tolay ya ammuwán nu nágan naya piyán Dios, ay iyà ya kapannán da. ");
INSERT INTO isd_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ay nu atán ríri naya isa kiya isa, ay iyà pe ya kapannán da se iyà ya mangguwes kaggída, ay se ku ipakammu kaggída ya bílin ne Dios se daya lin-lintag na,” nán tu Moses. ");
INSERT INTO isd_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Ay nán tu katugángan na kaggína, “Akkan napiya ya angwa mu. ");
INSERT INTO isd_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Unawán mu ya baggim kampela ngin nin se daya tolay. Nadammat pànang yán na ubra. Akkan mu mabalin pagasissaan yán. ");
INSERT INTO isd_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Gìnán nà ta law-lawagán taka. Ay sengán naka pe ye Dios. Ikaw ya mangiúni kadaya tolay ke Dios. Ay ikaw pe ya mangiamomán ke Dios kadaya ríri naya isa kiya isa kaggída. ");
INSERT INTO isd_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ay ikaw pe ya magtùgud kaggída kadaya bil-bílin se lin-lintag ne Dios. Itùgud mu pe daya napiya nga sur-surútan da se daya napiya nga kuwaan da. ");
INSERT INTO isd_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ngamay magsápul ka pe kada tolay nga annung da ya mangiapu. Pilíyam daya tolay ya managgansing ke Dios se daya mapiyár se daya akkan mabalin pasùsúán. Ay ittu dayán daya ippáy mu wa mangiapu kadaya tolay. Atán pangiapuwan mu ka maríbu, atán mangiapu magatut, se atán mangiapu ka limma púlu se atán mangiapu ka sangapúlu. ");
INSERT INTO isd_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Ittu dayán nin daya mangguwes peyang ngin kadaya tolay. Daya nadammat ta kásu, ay ittu dayán daya ilbet da kikaw. Ay nu daya bibittì a kásu, ay aggída kampela ngin nin ya makammu. Sengán daka kiya ubra, ay díkod malaptán ka. ");
INSERT INTO isd_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ay nu pakunán mu kídi, sigun kiya piyán pe ne Dios nga kuwaan mu, ay akkan ka masulitán, ay se makaru pe nga maariglu daya tolay. Díkod makappan daya tolay pe yin na makaru kadaya babbabalay da nga napiya uray.” ");
INSERT INTO isd_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Ginìna tu Moses datu kinag-kagi natu katugángan na. Ay kinuwa na kurug ngámin datu kinag-kagi na. ");
INSERT INTO isd_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Nagpíli kurug tu Moses ka lalláki kadatu iIsrael nga makabaal kitu ubra, ay se nada pangiapuwan kadatu tolay. Atán da tu mangiapu ka maríbu tolay, atán datu mangiapu ka magatut, atán mangiapu ka limma púlu tolay, ay se atán da mangiapu ka sangapúlu tolay. ");
INSERT INTO isd_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Aggída datu bíláng guwes datu tolay. Aggída kampela ngin tu mangguwes kadatu bittì ala nga kásu. Ay datu nadammat ta kásu, ay ittu datu nilbet da kitu Moses. ");
INSERT INTO isd_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Akkan nabayág panda kitun, ay nawe pe yin tu Jetro kitu íli na, ay pinarbuwát natu Moses sin. ");
INSERT INTO isd_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Nagtálaw datu iIsrael ka Refidim. Ay kitu munna nga algaw kitu mekàlu búlán panda kitu inagtálaw datu iIsrael ka Egipto, ay dummatang da kitu ir-ir-er kitu bantay Sinai. Ay nagkampu da kitu adanni kitu bantay. ");
INSERT INTO isd_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Ay nanùdu tu Moses sa mawe makiamomán ke Dios. Ay kinumraw we APU kaggína kitu bantay nga nán na, “Kagiyam idi kadaya iIsrael nga gakagaka natu Jacob: ");
INSERT INTO isd_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Nasingan nu datu kinuwaán ku kadatu iEgipto. Ay se sikkaammu kayu kiya nangippan ku kadakayu kanedi. Arig ku ya karabúngan na nangikáyab kadakayu kanedi. ");
INSERT INTO isd_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ay díkod nu kurugan nu daya kag-kagiyan ku se akkan nu paglikudán ya nagkakariyán tada, ay dakayu daya tolay ku. Kuw-kuwà ya ngámin kalawagán, ngamay dakayu ya idum-dúmà tutu wala kadaya ngámin tolay. ");
INSERT INTO isd_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Dakayu daya tolay ya nekísì para kiyà a pagbalinan ku ka pappádì a magsurbi kiyà. Tu dedi daya ikagim kadaya iIsrael,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ay tútu nanagut tu Moses, ay se na inurnung ngámin datu pangmanàman datu iIsrael, ay se na nga kagiyan ngámin datu pekagi ne APU kaggína. ");
INSERT INTO isd_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ay nagsissa ngámin datu tolay nga summungbát nga nán da, “Kuwaan mi ngámin daya kinag-kagi ne APU,” nán da. Ay se la nga kinagi tu Moses ke APU tu kinagi datu tolay. ");
INSERT INTO isd_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ay se la kinagi ne APU kitu Moses, “Umbet tà kadakayu may maglingad da ki nànag ga angap, ta senu magìna dà daya tolay nu makiamomán nà kikaw, ay senu kurugan daka peyapeyang ngin ka panda,” nán na. Ay se la nga kinagi tu Moses ke APU tu kinagi datu tolay. ");
INSERT INTO isd_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ay tútu nán ne APU kitu Moses, “Mawe ka ngin kadatu tolay, ay se muda pagdalusan kídi se kaláwa. Pasùnàám kaggída daya bad-bádu da. ");
INSERT INTO isd_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Ay magsagána da kiya mekàlu wa algaw nga ittu ya annagut ku nga APU da kídi bantay Sinai. Ay atán da nga magsisíngan kiyán na annagut ku. ");
INSERT INTO isd_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ay kiya lebut na bantay, ay mangippáy ka pamandanán daya tolay. Ay nán mu kaggída, ‘Sin-sinnan nu ta áwan kadakayu ya manùdu kiya bantay, onu manùbit kiya panda na. Ay nu atán ya manùbit kiya bantay, ay masápul la matay. ");
INSERT INTO isd_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Masápul la matùtokán onu mabútug. Oray tolay onu animál, ay masápul la matay,’ nán mu. Ngamay nu magìna da ngin ya mabayág ga tannug na tarumpeta, ay ittu yán ya annùdu da kiya bantay,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Ay díkod nanagut tu Moses kitu bantay se la nawe kadatu tolay. Pinagdalus na datu tolay. Ay sinùnaán datu tolay datu bad-bádu da. ");
INSERT INTO isd_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ay se na nán pikam kaggída, “Masápul nakasagána kayu win kiya mekàlu wa algaw. Dakayu wa lalláki, ay akkan kayu meallay kadaya attáwa nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ay kane pagmakát natu mekàlu wa algaw, ay uwad addug se kilát se uwad nagìbat ta angap kitu bantay. Ay uwad pe naggat tutu wala nga tannug tarumpeta. Kane magìna datu tolay ya atán kitu kampu da, ay nagtar-tartar da kitu ansing da gapu kitu daggat na. ");
INSERT INTO isd_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Ay se la neapu tu Moses sa nelawán datu tolay kitu kampu da ta mawe da sinnan ne APU Dios. Nagsisíkád da ngala kitu adanni kitu bantay. ");
INSERT INTO isd_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ay tu bantay Sinai, ay ummán ka nakalumotán ka atù, áta naganìgad de APU kitúni yin kiya apuy. Ay tu atù na, ay umas-asbà nga ummán ki atù pugun. Ay nangyagyag pe ka naggat tutu wala kitu bantay. ");
INSERT INTO isd_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Ay kane dumgat tala nga dumgat tu tannug natu tarumpeta, ay nagúni tu Moses. Ay sinungbátan ne Dios kitu addug. ");
INSERT INTO isd_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Ay se la nga naganìgad de APU kitu otun tu bantay Sinai. Pinalbet ne APU tu Moses kitu otun tu bantay, ay tútu nanùdu tu Moses. ");
INSERT INTO isd_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Ngamay nán ne APU kitu Moses, “Mawe ka pikam managut, ta kagiyánam datu tolay, ta get tala nu lumàsig da nga maningan kiyà nga APU, ay adu kaggída ya matay. ");
INSERT INTO isd_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ay kagiyam pe kadaya pappádi nga umadanni kiyà nga dalusán da daya baggibaggi da, áta nu akkan, ay panísan kuda,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Ay nán tu Moses ke APU, “Akkan manùdu daya tolay kídi bantay Sinai, áta ikaw mismu ya namílin kadakami nga ibíláng mi ka nasantuwán idi nga bantay, ay se kami mangippáy ka pamandanán kiya lebut na,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ay nán ne APU kaggína, “Mawe ka managut ta mawem alà nge Aaron. Ngamay akkan mu ipalúbus nga lumàsig daya pappádi se daya tolay nga umbet kanedi giyán ku, áta panísan kuda tutu wala nu kuwaan da yán,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ay díkod nanagut tu Moses kadatu tolay, ay se na nga kagiyan kaggída datu pekagi ne APU. ");
INSERT INTO isd_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ay se la nagúni ye APU Dios, ay ittu dedi daya kinag-kagi na: ");
INSERT INTO isd_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Iyà ya APU nga Dios nu wa nangitálaw kadakayu ka Egipto kitu inangngasassu da kadakayu. ");
INSERT INTO isd_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Awan nu sabáli ibíláng ka diyos nu di iyà ala. ");
INSERT INTO isd_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Akkan kayu mangwa ka sinan tolayán na diyos nu, onu panda ngala nga sinan singan daya panda ngala nga atán ka lángit, onu atán ki kalawagán, onu atán ki bebay. ");
INSERT INTO isd_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Akkan kayu magukkab onu day-dayáwan dayán, áta iyà nga APU wa Dios nu, ay naabugu wà a Dios. Panísan ku daya kumagúra kiyà, se daya annánà da, se daya gakagaka da panda kiya mekàlu se mekappát nga paganakán. ");
INSERT INTO isd_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Ngamay kadaya maminya kiyà se mangikurug kadaya bil-bílin ku, ay ipassingan ku kaggída ya áwan kaul-ulissán na amminyà oray panda ki mekasangaríbu nga paganakán. ");
INSERT INTO isd_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Akkan nu ur-uráyan usaran ya ngágan ne APU wa Dios nu. Ata panísan ku tutu wala daya mangur-úray magusár ki ngágan na. ");
INSERT INTO isd_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Ngilínan nu ya Algaw wa Pinaggiimáng se ibíláng nu ka nasantuwán. ");
INSERT INTO isd_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Annam ngalgaw ya angwa nu kadaya ngámin ubra nu. ");
INSERT INTO isd_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Ngamay ya mekapittu wa algaw, ay Algaw wa Pinaggiimáng para ke APU wa Dios nu. Awan magubra tutu wala kadakayu kiyán na algaw, oray daya annánà nu, se daya asassu nu, se daya agtangeli nga atán ki balay nu. Akkan nu pe iubra daya animál nu. ");
INSERT INTO isd_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ata ki unag annam algaw kinuwa ne APU ya lángit se iya kalawagán se iya bebay se daya ngámin na atán kadayán. Ay kitu mekapittu wa algaw, ay nagimáng. Díkod binindisiyonán ne APU yán algaw, ay se na kinuwa ka napatag. ");
INSERT INTO isd_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Ipatag nu daya ama nu se ina nu, ta senu adaddu ya agbiyág nu kiya lusà a idde ne APU wa Dios nu kadakayu. ");
INSERT INTO isd_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Akkan kayu pumatay. ");
INSERT INTO isd_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Akkan kayu manaládag onu makidaládag. ");
INSERT INTO isd_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Akkan kayu magtákaw. ");
INSERT INTO isd_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Akkan kayu magbus-busid kiya agsistígu nu kiya kumuntra kiya kasittolay nu. ");
INSERT INTO isd_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Akkan nu asílan ya balay naya kasittolay mu, onu ya atáwa na, onu ya asassu na, onu ya báka na nga para ubra, onu ya asnu na onu panda ngala nga kuw-kuwa naya kasittolay mu.” ");
INSERT INTO isd_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Ay kane màmud ngámin datu tolay tu aggaddug na se tu agsal-sal-it na se magìna da tu tarumpeta, ay se masingan da nga magat-atù tu bantay, ay nagansing da tutu wala. Tútu nagyán da ngala kitu ad-adayyu. ");
INSERT INTO isd_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ay se dala nga nán kitu Moses, “Ikaw ya mangamomán kadakami, ay gìnán mika. May kagiyam ke Dios nga akkan nakami amomanán ta matay kami,” nán da. ");
INSERT INTO isd_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Ay tútu nán tu Moses kadatu tolay, “Akkan kayu magansing ta tistíngan nakayu, ay piyán na nu magansing kayu peyang ngin kaggína, ta senu akkan kayu magbásul,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Ay nag-agyán nala datu tolay kitu ad-adayyu. Ngamay tu Moses, ay umadanni kitu nagìbat ta angap nga ittu tu giyán ne APU Dios. ");
INSERT INTO isd_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Ay nán ne APU kitu Moses, “Tu idi ya kagiyan mu kadaya iIsrael, ‘Nasingan nu mismu nga iyà nga APU nga atán kídi lángit ya nangamomán kadakayu. ");
INSERT INTO isd_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ay túya akkan kayu mangwa ka sinan diyos nu nga nàwa ka balitù onu nàwa ka silber se nu dayáwan na ummán ki agdáyaw nu kiyà. ");
INSERT INTO isd_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Mangwa kayu ka agbasuwán nu para kiyà, ay lusà ala ya usaran nu. Mangwa kayu kiyán na agbasuwán kadaya giy-giyán na pagpakammuwán ku kadakayu. Ay umbet tà nga mamindisiyon kadakayu. Yán na agbasuwán ya panìdúgán nu kadaya pagbasu nu wa karneru onu báka, se ittu yán pe ya pangidatúnán nu kadaya karneru se báka ka aggiyáman nu ke APU. ");
INSERT INTO isd_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ay nu batu ya usaran nu wa mangwa kiya agbasuwán nu kiyà, ay akkan nu usaran daya killután na batu, áta rag-ragitán nu ya batu ki angngusár nu ki aruminta. ");
INSERT INTO isd_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Akkan nu payán ka pákad ya ù-ùneán nu kiyán na agbasuwán nu para kiyà, áta nu umunè kayu, ay get tala masingan ya kannawan nu ipassingan,’ nán na,” nán mu. ");
INSERT INTO isd_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Ay nán manin ne Apu kitu Moses “Tu dedi daya lin-lintag ga ipasúrut mu kaggída. ");
INSERT INTO isd_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Nu gumátang kayu ka laláki nga asassu wa Hebreo, ay annam dagun ya agsurbi na kadakayu, ay se la nga mawe yin nu mekapittu dagun na, nga áwan na bay-bayádan. ");
INSERT INTO isd_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ay nu áwan na atáwa kane gatángan nu, ay papannan nu wa áwan atáwa. Ngamay nu atán atáwa na ngin kadakayu nga gumátang kaggína, ay kabulun na nga mawe yin ya atáwa na. ");
INSERT INTO isd_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ay nu ya laláki nga asassu, ay pinangatáwa naya apu na ka asassu wa babay, ay se da nagan-anà, tu apu natu babay ya makin-kuwa kaggína se datu annánà na. Ay mawe nga sissa tu laláki. ");
INSERT INTO isd_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ngamay nu nán natu laláki nga asassu nga, ‘Piyán ku ya apu ku se ya atáwà se daya annánà ku, ay maddi yà mawe,’ nu nán na, ");
INSERT INTO isd_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","masápul la ippan naya apu na kitu pagday-dayáwan ke Dios, ay se na ipadat tu talínga natu asassu kitu gitap na gagyangán onu kitu gamba natu gagyangán, ay se na rabngan ki dúut. Ay se la magsurbi tu asassu kitu apu na kiya kasibbiyág na. ");
INSERT INTO isd_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Ay nu ya isa nga laláki, ay iláku na ya an-anà na nga babay ka asassu, ay sabáli ya kàwaán na kiya kàwaán naya asassu wa laláki. ");
INSERT INTO isd_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ay nu tu apu na, ay pinalánu na nga atawán, ay se akkan na piyán nin, ay masápul la pasaka na kammin kadatu maganà kaggína. Awan na rabbang mangiláku kaggína ka sabáli tolay, áta nadakè tu namàyanán na kaggína. ");
INSERT INTO isd_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ngamay nu ipaatáwa na kiya an-anà na nga laláki, ay masápul ibíláng na ka an-anà na pe yin. ");
INSERT INTO isd_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ay nu atawán natu apu, ay se la nga mangàduwa, ay masápul la ya angwa natu apu kaggína ay páda na kiya atáwa na. Akkan màsayán ya kanan se ya bádu na, se daya duddúma nga pagrabngán na. ");
INSERT INTO isd_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Ay nu akkan kuwaan na apu dedi ya tallu wa bánag, ay masápul la mawe yin ya asassu wa babay nga áwan na bay-bayádan. ");
INSERT INTO isd_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Ya tolay ya mangámang ki kasittolay na, ay se na mapatay ay masápul la matay pe. ");
INSERT INTO isd_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ngamay nu akkan na pinalánu patayan may nepalúbus ne Dios, ay annung na ya magsirù kiya isa nga giyán na kagiyan ku kadakayu. ");
INSERT INTO isd_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ngamay nu ginúrát na isa tolay ya pumatay se nelíbát na ya namatay, ay se la nawe nagsirù kiya altár ku, ay masápul alà nu kitúni se nu la patayan pe. ");
INSERT INTO isd_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Daya manúlung kadaya mannákam da, ay masápul matay da. ");
INSERT INTO isd_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Daya magkidnap ay masápul matay da, oray neláku da ngin ya tolay ya kinidnap da, onu atán pikam kaggída. ");
INSERT INTO isd_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Daya magged kadaya mannákam da, ay masápul matay da pe. ");
INSERT INTO isd_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","19","Ay nu atán da magsáwad, ay se masúlung na ya isa ya isa, onu bàbàan na ka batu, ay se la natalíngu may akkan natay, ay akkan mapánis tu nakasúlung, nu tu nasúlung ay bumílag kammin onu annung naya magtàdukud da magdal-dalen. Ngamay masápul bayádan natu nakasúlung tu nasáyang nga oras natu sinúlung na, ay se aggína ya makammu kitu sinúlung na panda kiya ibibbílag na tutu wala. ");
INSERT INTO isd_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Ay nu baútan na tolay ya asassu na nga laláki onu babay, ay se matay nga dágus kiyán na nagbáut na, ay masápul la mapánis. ");
INSERT INTO isd_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Ngamay nu magbiyág pikam ka isa onu duwa ngalgaw ya asassu, ay akkan na mapánis, áta kuw-kuwa na kampela ngin nin ya asassu. ");
INSERT INTO isd_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Ay nu atán da lalláki nga magpatay, ay se matakitán da pe ya isa nga babay ya nabùsit, ay se la nga mippà ya an-anà na may áwan nin nadakè a nàwa kaggína ka panda, ay masápul magawát tu nakasúlung kaggína kiya banor ra kagiyan naya atáwa na. Ay akkan magsurù kiya kagiyan daya mangguwes kaggína. ");
INSERT INTO isd_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Ngamay nu atán pikam nadakè a màwa kitu babay ittu pe ya màwa kitu laláki. Nu natay, ay matay pe tu laláki. ");
INSERT INTO isd_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Nu nakúláp ay makúláp pe tu laláki. Ay nu nippà ya ngípan natu babay, ay masápul mippà ya ngípan pe natu laláki. Nu íma ay íma pe, ay nu síkil ay síkil pe natu laláki. ");
INSERT INTO isd_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Nu nasìdug ay masìdug pe ya laláki, ay nu natalíngu ay matalíngu pe tu laláki. Ay nu nàrusán ya baggi tu babay, ay masápul màrusán pe tu laláki. ");
INSERT INTO isd_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Ay nu ya isa nga laláki, ay nakúláp na ya asassu na nga laláki onu babay, ay masápul wayaan na ngin tu asassu na ka pinakabáyad na kitu mata na. ");
INSERT INTO isd_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ay páda na pe nu ngípan ya mippà. Masápul nga wayaan na ngin tu asassu na ka pinakabáyad na kitu ngípan na. ");
INSERT INTO isd_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Ay nu ya isa nga toru wa báka, ay sàgúdan na ya isa nga laláki onu babay, ay se matay ya tolay, ay masápul la matùtokán ya toru panda ki katay na. Ay áwan mangán kiya karni naya toru. Ay tu makin-kuwa kitu toru, ay akkan na mapabásul. ");
INSERT INTO isd_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ngamay nu tu toru, ay nakasàgud kitun nin, ay se nakagiyánan nin ya makin-kuwa, ngamay akkan na nepupúkù, ay se la makapatay ya toru, ay masápul la matùtokán ya toru, ay se matay pe ya makin-kuwa. ");
INSERT INTO isd_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Ay nu makiawát daya natayán, ay masápul la bayádan na ya awát nga kagiyan da, ta senu akkan da patayan. ");
INSERT INTO isd_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ay nu ya masàgud, ay an-anà ay páda na nga lintag ya surútan nu ki angwa nu kiya makin-kuwa kiya toru. ");
INSERT INTO isd_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ay nu asassu ya sàgúdan naya toru, magbáyad ya makin-kuwa kitu toru kitu apu natu asassu ka pagkàlu kílu nga silber, ay se matùtokán tu toru panda kitu katay na. ");
INSERT INTO isd_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Ay nu akkan nepatulli na tolay ya takkab naya bubun onu nagkorob ka bubun ta akkan na tinàbán, ay se la atán toru onu asnu nga nepisù kitu bubun, ");
INSERT INTO isd_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ay masápul magbáyad ka pirà tu tolay kitu makin-kuwa kitu animál. Ngamay kuwa na ngin tu natay ya animál. ");
INSERT INTO isd_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Ay nu ya toru na isa tolay, ay napatay na ya toru pe naya isa tolay, masápul iláku datu sibbiyág ga toru, ay se da paguwarán tu báyad na. Ay uwaran da pe tu karni natu natay ya toru. ");
INSERT INTO isd_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ay nu gángay kammala nga sumàgud tu toru, ay se akkan nepúkù natu makin-kuwa, masápul bayádan natu natay ya toru ka sibbiyág ga toru, ay kuwa na pe yin tu natay ya toru. ");
INSERT INTO isd_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Nu nagtákaw ya isa tolay ka toru wa báka onu karneru, ay se na pinatay yin onu neláku na ngin, ay masápul bayádan na ka limma nga toru ya isa nga toru, onu appát ta karneru ya isa nga karneru. Ay nu áwan na nga pagbáyad, ay masápul la meláku yán na tolay ka asassu ta senu atán pagbáyad na. ");
INSERT INTO isd_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Ay nu atán pikam kaggína tu tinákaw na nga toru wa báka onu karneru onu asnu, ay se sibbiyág pikam, masápul la mamidduwa ya pagbáyad na. ");
INSERT INTO isd_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Ay nu atán nasukalán na manglannà a magtákaw ki gabi, ay se mapatay, ay áwan mapabásul kiya pannakatay na. ");
INSERT INTO isd_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Ngamay nu algaw ya kàwa na, ay mapabásul ya nakapatay kaggína. ");
INSERT INTO isd_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Ay nu magamet ya animál naya isa nga tolay kiya tálun onu kaubásan naya kasittolay na, onu ipaamet na ya tálun onu kaubásan na kasittolay na, ay masápul la magbáyad. Ay ya kapíyán kiya tálun onu kaubásan na ya pagbáyad na. ");
INSERT INTO isd_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Ay nu sumìdug ya tolay, ay se la sarátan na apuy ya naalmung ngin na ammay onu datu ammay nga akkan pikam nagáni onu nasìdug ya tálun, ay masápul la bayádan natu nanìdug ngámin datu nadadál. ");
INSERT INTO isd_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Ay nu nepiyár naya isa tolay kiya kasittolay na ya pirà na, onu panda ngala nga napatag ga sanikuwa na, ay se la nga natákaw datun, masápul la sapúlan da tu nagtákaw, ay se la magbáyad ka mamidduwa ya kaadu na kitu tinákaw na. ");
INSERT INTO isd_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Ngamay nu akkan da masmà tu nagtákaw, ay masápul la mippan tu nangiarimán kadatu pirà se sanikuwa kiya pagday-dayáwan ke Dios, ay se na nga sipataán nu inalà na onu akkan tu nepearimán da kaggína. ");
INSERT INTO isd_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Ay nu atán ríri mepanggap ki magtakkil ki báka onu asnu, onu karneru, onu bádu onu panda ngala nga newágà na isa tolay, tu idi ya kuwaan nu. Ilbet nu ya kásu ke Dios. Ay ya pabasúlan ne Dios, ay magbáyad ka mamidduwa kitu makin-kuwa kitu talitakkilan na. ");
INSERT INTO isd_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Ay nu nepatarakan na ya isa tolay ya asnu na onu báka, onu karneru onu panda ngala nga animál kiya isa nga tolay, ay se natay onu natalíngu onu nagtálaw tu nepatarakan kaggína, may áwan makasistígu, ");
INSERT INTO isd_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ay masápul la magsipata tu nagtarakan ke APU nu aggína ya nangwa kiya nàwaán naya nepatarakan kaggína onu akkan. Ay nu sipataán na nga akkan aggína ya nangwa kiya nàwaán naya nepatarakan kaggína ay masápul la kurugan naya nangipatarakan ya sipata. Ay akkan na magbáyad tu nangipatarànán. ");
INSERT INTO isd_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ngamay nu natákaw tu nepatarakan kaggína, masápul magbáyad. ");
INSERT INTO isd_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ay nu pinatay ulolag, masápul ilbet na ya baggi natu nepatarakan kaggína ka pakasinnán na kurug tu nàwa. Ay díkod akkan magbáyad kitu makin-kuwa. ");
INSERT INTO isd_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Ay nu nagtakkaw ya isa tolay ka panda ngala nga animál, ay se natalíngu onu natay tu tingkaw na, ay se áwan tu makin-kuwa kitu nekàwa na, ay masápul bayádan natu nagtakkaw tu animál. ");
INSERT INTO isd_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Ngamay nu atán tu makin-kuwa, ay akkan magbáyad tu nagtakkaw. Ay nu inarkilaan na tu animál, ay tittu tu arkila ya idde na. ");
INSERT INTO isd_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Ay nu ayuyútan naya isa nga laláki nga allayan ya isa nga babbalásang nga áwan na pikam kal-allay, masápul la manádug, ay se atawán na pe yin tu babbalásang. ");
INSERT INTO isd_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ngamay nu maddi tutu wala tu ama natu babbalásang, ay magawát ya laláki ka gángay banor tádug naya babbalásang nga meatáwa nga áwan pikam neallayán. ");
INSERT INTO isd_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Masápul matay daya babbay ya durarákit. ");
INSERT INTO isd_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Masápul la matay ya laláki nga mangwa ki animál. ");
INSERT INTO isd_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Daya magbasu ka pagday-dáyaw da kiya sabáli nga diyos, ay masápul la matay. Tittu we APU ya rabbang na nga pagbasuwán. ");
INSERT INTO isd_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Akkan nu pà-paultuwan daya agtangeli ta agtangeli kayu pe kitun ka Egipto. ");
INSERT INTO isd_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Akkan nu pà-paultuwan daya ulíla se daya bubbúkud da babbay. ");
INSERT INTO isd_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ay nu pà-paultuwan nuda, ay se da makim-imallà kiyà, ay kalakkán kuda, ");
INSERT INTO isd_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ay se yà malùsaw tutu wala kadakayu, ay se takayu patayan ki gubát. Díkod mabúkud ya atáwa nu se maulíla pe daya annánà nu. ");
INSERT INTO isd_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Ay nu magpàkaw kayu ka pirà kadaya napubri nga tolay ku, akkan kayu magadang ka ábang na pirà nu. Akkan nu tal-taldan daya magpà-paábang ka pirà. ");
INSERT INTO isd_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ay nu isalda naya keliyán nu kadakayu ya bádu na, masápul la ipatulli nu kaggína ki gídám. ");
INSERT INTO isd_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Ata get tittu yán ya annung na nga pagbádu. Awan na bádu wa matúdug. Ay nu makiseng kiyà, ay kalakkán ku áta maragkallà à. ");
INSERT INTO isd_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Akkan nu irupat te Dios, ay se akkan nu pe gedán daya mangitur-turáy kadakayu. ");
INSERT INTO isd_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Akkan nu wa tàtáan ya angngidátun kadaya dátun nu kadaya munna nga gáni nu se kadaya bási nu. Idde nu kiyà daya manákam ma annánà nu wa lalláki. ");
INSERT INTO isd_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ay páda na pe kadaya toru wa báka nu, se daya toru wa karneru nu. Ipatagíbi nuda kadaya ina da ki unag pittu walgaw. Ay se nuda la nga idátun kiyà ki mekawalu wa algaw. ");
INSERT INTO isd_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Dakayu daya nekísì a tolay ku. Túya akkan kayu mangán kadaya karni áyam nu wa pinatay ulolag. Idde nu wala ngin kadaya átu. ");
INSERT INTO isd_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Akkan kayu mangiwar-waragáwag ka busid da dámag. Ay akkan kayu pe tumistígu ka busid nga pumane kiya nadakè a tolay. ");
INSERT INTO isd_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Akkan kayu mear-arát kadaya kadúwán ki angwa da ki nadakè. Akkan kayu pe tumistígu ka pumane kiya kadúwán nga mamalintag ki akkan kustu. ");
INSERT INTO isd_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ay akkan nu pe paneyan ya isa tolay gapu wala ta napubri. ");
INSERT INTO isd_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Ay nu masingan nu ya toru wa báka naya kagúra nu onu ya karneru na nga magal-aliwagwag gin, ay alà nu se nu wa ipatulli kammin kaggína. ");
INSERT INTO isd_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ay nu masingan nu ya asnu naya kumagúra kadakayu nga nekakálin gapu ki dammat na agtu na, ay sengán nu ya kumagúra kadakayu nga mangipasíkád kitu asnu na. Akkan nu bay-bay-án nala. ");
INSERT INTO isd_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Akkan nu bal-balintaggan ya lintag gapu wala ta napubri ya nedarum. ");
INSERT INTO isd_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Akkan nu pà-pàgan daya busid da darum. Akkan nu pabasúlan se nu la patayan daya áwan básul, se daya kustu kuk-kuwaan na tolay, áta panísan ku daya nakabásul la tolay. ");
INSERT INTO isd_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Akkan kayu wa papasùsúán, áta ya pasùsù, ay ittu ya árig mangúláp kadaya agtuturáy. Ittu pe ya manadál kiya pakalintaggán kuma daya áwan bas-básul. ");
INSERT INTO isd_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Akkan nu pà-paultuwan ya agtangeli. Ammu nu nu wà ummán naya ur-uray naya agtangeli, áta agtangeli kayu pe kitun ka Egipto. ");
INSERT INTO isd_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Mulán nu ya lusà nu ki unag annam dagun. ");
INSERT INTO isd_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Ngamay kiya mekapittu wa dagun, ay bay-án nu la. Akkan nu ganiyan daya búnga daya nagitubuwán kiyán na dagun, ta kuw-kuwa daya napubri nga keliyán nu. Ay daya mebunna da, ay para kadaya alsádu wa ulolag gin. Ay pakunán nu pe kadaya kamulán nu ka úbás se kadaya kamulán nu ka olíbo. ");
INSERT INTO isd_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Magubra kayu kadaya ubra nu kiya unag annam ngalgaw. Ay kiya mekapittu walgaw, ay magimáng kayu. Ta senu makemáng pe daya asassu nu wa neanà ki balay nu, se daya agtangeli nga pilluwan nu, ay senu memangán pe daya pagubra nu wa toru wa báka se daya asnu nu. ");
INSERT INTO isd_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Gìnán nu ngámin dedi nga kinag-kagì kadakayu. Ay akkan kayu makiseng kadaya sabáli nga diy-diyos. Kannawan nu dayán, oray ya angngikagi nu wala ki ngágan da. ");
INSERT INTO isd_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Mamìlu kayu wa magpiyasta ka para kiyà ki makadagun. ");
INSERT INTO isd_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Silibráran nu ya piyasta nga pinagkakán nu sinápay ya áwan pamalbád. Nebílin ku kadakayu nga kiya nìdang nga al-algaw ki búlán na Abib, ay pittu walgaw ya angngán nu ka sinápay ya akkan napayán ka pamalbád. Ata ki am-amung dayán na al-algaw tu inagtálaw nu ka Egipto. Ngámingámin kayu, ay masápul atán dátun nu kiyà. ");
INSERT INTO isd_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Ay masápul silibráran nu pe ya piyasta nga aggagáni nga ittu yán tu angngidátun nu kiyà kadaya munna nga gáni nu kadaya mul-múla nu. Ay nu tagay malpás ya dagun nin, ay silibráran nu pe ya piyasta nga pinagbubúrás nga ittu yán ya agbúrás nu kadaya úbás nu se daya búnga daya kay-káyu nu. ");
INSERT INTO isd_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Ay ngámin daya lalláki kadakayu, ay masápul la mamìlu da magpassingan ke APU wa Dios ki makadagun. ");
INSERT INTO isd_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Ay kiya angngidátun nu kiyà kiya dága naya pagbasu nu, ay masápul la áwan na kabulun na sinápay ya nakibugán ka pamalbád. Ay masápul la áwan mabunna panda kaláwa kiya taba naya pinagbasu nu. ");
INSERT INTO isd_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Ay daya kapíyán kiya munna nga magáni nu kiya tálun nu, ay ilbet nuda kiya balay ne APU wa Dios. Akkan nu ilútu ya karni urbun karneru onu kalding ki gattà naya ina na. ");
INSERT INTO isd_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Mangibon nà ka anghel nga maginunna kadakayu nga ittu ya magtagasíngan kadakayu kiya dadalenán se mangippan kadakayu kiya giyán nga nesagánà para kadakayu. ");
INSERT INTO isd_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Gìnán nu ya kagiyan na se ikurug nu, áta iyà ya nangidde kaggína ka turáy. Akkan nu kaguráan, áta akkan nakayu tutu wala nga pakawanan. ");
INSERT INTO isd_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ngamay nu kapiyánan nu gìnán daya kagiyan na, ay se nu kuwaan daya ngámin na pekagì kaggína, ay sengán takayu kadaya kalínga nu. Ay kalínga kuda pe yin. ");
INSERT INTO isd_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ay ya anghel nga maginunna kadakayu, ay ippan nakayu kiya giyán daya Amorreo, daya Heteo, daya Perizeo, daya Cananeo, daya Heveo se daya Jebuseo. Ay rapúnan kuda. ");
INSERT INTO isd_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Ay nu atán kayu win kannán, ay akkan nu ipat-patag onu day-dayáwan daya sinan diy-diyos da. Akkan kayu mear-arát kadaya kuk-kuwaan daya magday-dáyaw kaggída, nu di nu kuma nga dadàlan dayán na sinan diy-diyos, se daya dadakkal batu para kaggída. ");
INSERT INTO isd_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Iyà nga APU wa Dios nu wala ya day-dayáwan nu. Ay bindisiyonan ku daya akakkanan nu, se ya danum ma inuman nu, ta sen ittu daya mamabílag kadakayu, ay se ku ippà daya sin-sinakit kadakayu. ");
INSERT INTO isd_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Awan pe yin kadaya nabùsit ya mippà ya bùsit da, ay se áwan pe kadakayu win daya babbay ya di magan-anà. Ay se adaddu pe ya agbiyág nu.” ");
INSERT INTO isd_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Oray kiya akkan nu pikam nedaddatang, ay pappanansingan ku se riribuan ku daya tolay ya gubatan nu. Pataláwan ku daya kalínga nu nu masingan dakayu. ");
INSERT INTO isd_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Mangipàrob bà ka adu balábal la abubúyug. Ta senu ittu dedi daya mamàpur rin kadaya Heveo, kadaya Cananeo, se kadaya Heteo kiya ligge nu wa magdal-dalen. ");
INSERT INTO isd_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Ngamay akkan kuda pikam pàpurán ki unag makadagun, ta senu akkan mapanáwan ya lusà, ay umadu daya alsádu wa ulolag, ay masulitán kayu kaggída. ");
INSERT INTO isd_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","In-inútan kuda nga pàpuran panda kiya ikà-adu nu win na mangalà kiya lusà. ");
INSERT INTO isd_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Ipandà ya lusà nu manggayát ka Daggáng nga Bebay panda kitu Bebay nga adanni kitu giyán datu Filisteo. Manggayát kitu ir-ir-er panda kitu wángag Eufrates. Pàpuran nu datu mag-agyán kitúni áta paábà kuda kadakayu. ");
INSERT INTO isd_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Akkan kayu makitur-turátu kaggída onu kadaya sinan diy-diyos da. ");
INSERT INTO isd_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Masápul magtálaw da kiya lusà nu, ta get nu aggída ya panggayatán naya agbásul nu kiyà. Ata nu umatangya kayu kiya agdáyaw da kadaya sinan diy-diyos da, ay ittu ya kàna nu win ki kàrung.” ");
INSERT INTO isd_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Ay se la nán ne APU kitu Moses, “Manùdu kayu kídi giyán ku nga APU nu. Dakayu se de Aaron, se de Nadab, se de Abihu se daya pittu púlu wa pangmanàman daya iIsrael. Umbet kayu nga magdáyaw kiyà, may magyán kayu kiya ad-adayyu. ");
INSERT INTO isd_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Sissa ka ngala, Moses, nga umadanni kiyà nga APU. Ay daya kabbulum, ay akkan da umadanni kiyà. Ay akkan mabalin mepanùdu daya tolay kikaw,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Ay se la inumbet tu Moses kitu giyán datu tolay, ay se na kinagi kaggída ngámin datu kinag-kagi ne APU se ngámin datu bil-bílin na. Ay nagsissa datu tolay ya summungbát kaggína nga nán da, “Ngámin daya kinag-kagi ne APU, ay kuwaan mi ngámin dayán,” nán da. ");
INSERT INTO isd_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Ay nesúrát tu Moses ngámin datu kinagi ne APU. Ay kane pagmakát, ay nasápa ginumniya, ay se la nangwa ka annìdúgán ka pagbasu kitu pungut natu bantay. Ay nangipasíkád pe ka sangapúlu se duwa nga dadakkal nga batu, nga ittu pe ya bíláng daya tangámalán ka Israel. ");
INSERT INTO isd_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Ay se la nangipàrob kadatu babbágu nga iIsrael nga ittu datu nagidátun kadatu masìdug ga dátun da ke APU, ay se da pe nangidátun kadatu báka nga toru para ki akikappiya da ke APU. ");
INSERT INTO isd_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Ay inalà tu Moses tu gudduwa natu dága, ay se na nippáy kadatu besin, ay tu gudduwa, ay nesiy-siyà na kitu agbasuwán. ");
INSERT INTO isd_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ay se na nga inalà tu libru wa nekesurátan datu bil-bílin ne Dios, ay se na nebása kadatu tolay. Ay nán datu tolay kane mabalin na nga ibása tu libru, “Kuwaan mi ngámin daya kinagi ne APU, ay se mi ikurug da ngámin,” nán da. ");
INSERT INTO isd_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Ay se na inalà tu dága nga nabansi, ay se na iwar-warsì kadatu tolay, ay se na nán, “Tu idi nga dága ya mamairut kiya kari ne APU kadakayu, kane idde na kadakayu dedi nga bil-bílin na,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Ay se la nga nanùdu tu Moses se tu Aaron se tu Nadab se tu Abihu se datu pittu púlu wa pangmanàman datu iIsrael. ");
INSERT INTO isd_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Ay nasingan da nge Dios nga Dios daya iIsrael. Magsisíkád kiya ummán ka nasumintu ka napatag nga batu wa safiro ya ngágan na. Nalitáw tutu wala nga ummán ka singan lángit tu singan natu batu. ");
INSERT INTO isd_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Akkan inan-anu ne Dios datu pangmanàman datu iIsrael. Nasingan da nge Dios. Ay se da nagkakán se umminum kitúni. ");
INSERT INTO isd_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Ay nán ne APU kitu Moses, “Manùdu ka ki bantay, ay se nà idaggán kiyán. Atán idde ku kikaw nga dalumpenág ga batu wa nangisurátan ku kadaya bil-bílin ku se lin-lintag nga ittu ya itùgud mu kadaya tolay,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ay tútu nagrubbuwát tu Moses, kabulun na tu Josua nga kaseng na. Nanùdu tu Moses kitu bantay nga nagpassingannán ne Dios. ");
INSERT INTO isd_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Ay nán tu Moses kadatu pangmanàman datu iIsrael, “Idaggán dakami yala kídi ta magulli kami kammin. Mabansi de Aaron se Hur ka kabulun nu. Ay nu atán daya atán ríri, ay aggída ya kapannán nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Ay se la nga nanùdu tu Moses kitu bantay. Ay nalngúpán ka angap tu bantay. ");
INSERT INTO isd_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Naganìgad ya diláng ne APU kitu bantay Sinai. Ay nalngúpán tu bantay kitu angap ki unag annam ngalgaw. Ay kitu mekapittu walgaw, ay kinumraw kitu Moses kitu angap. ");
INSERT INTO isd_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Kitun, ya singan natu diláng ne APU kitu otun tu bantay, ay ummán tutu wala ki apuy ya maggang-gangláyab kitu agsisíngan datu iIsrael. ");
INSERT INTO isd_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Ay sirrà tu Moses tu angap, ay se manùdu kitu bantay. Ay nakappát púlu gabi se appát púlu ngalgaw tu Moses kitu bantay. ");
INSERT INTO isd_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Ay nán ne APU kitu Moses, ");
INSERT INTO isd_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Kagiyam kadaya iIsrael nga mangilbet da ka dátun da kiyà. Alà mu ya dátun daya ngámin tolay ya sikkaanggam mangidde kadaya dátun da kiyà. ");
INSERT INTO isd_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Tu dedi daya dátun nga alà mu: daya balitù, daya silber, se daya bága. ");
INSERT INTO isd_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","Alà mu pe daya abal nga mannáw, daya bayolet, daya dag-daggáng se daya napiya nga dilána. Alà mu pe daya dùdut kalding ");
INSERT INTO isd_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","se daya lálat toru wa karneru nga nakulorán ka daggáng, se daya napiya nga lálat báka. Ay alà mu pe daya tarikáyu nga akasiya. ");
INSERT INTO isd_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Alà mu pe daya idde da nga denu olíbo wa para ki dílág, se daya talibangug nga para kiya denu nga ikkiípu se para kiya insensu. ");
INSERT INTO isd_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Alà mu pe daya idde da nga batu wa oniko, se daya napatag ga batu-batu nga para kiya efod daya pappádi se para kiya aruwátan da ki gútù da. ");
INSERT INTO isd_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Magpàwa ka kaggída ka napatag nga pagyanán ku nga tabernákulu, ta senu mepagataatán nà kaggída. ");
INSERT INTO isd_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Ki angwa da kiyán na tabernákulu, ay masápul surútan da ya kàwa na nga kagiyan ku kikaw. Ay daya ar-aruminta kiya unag na, ay dayán nala kagiyan ku kikaw pe ya masúrut. ");
INSERT INTO isd_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Magpàwa ka kaggída ka arko nga nàwa ka káyu nga akasiya. Ya kadaddu na, ay isa mitru se sangapúlu sentimitru. Ya kadakkal na, ay pittu púlu sentimitru, ay ummán pe ya kadallam na. ");
INSERT INTO isd_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ay se mu la nga pakalupkopán ya ngámin panin lasi na se ya amin unag na ka pabeg balitù. Ay se mu pe pakalupkopán daya ngámin na lebi-lebig na. ");
INSERT INTO isd_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Magpàwa ka pe ka appát nga galáng nga pabeg pe nga balitù. Ay se mu la nga ikabit kadatu síkil na kadatu appát síku na. ");
INSERT INTO isd_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Ay se ka la magpàwa pe ka duwa nga takkan na káyu nga nàwa pe ka káyu wa akasiya. Ay páda na pe, pakalupkopán muda pe ka pabeg balitù. ");
INSERT INTO isd_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Ay dedi nga takkan, ay meruwad da kadatu galáng kadatu maganubáng nga síkil naya arko. Ay ittu daya pagbúlig da kiya arko. ");
INSERT INTO isd_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Ay daya takkan, ay meruruwad da peyapeyang kadatu galáng, nga akkam da ip-ippà. ");
INSERT INTO isd_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ay iunag mu kitu arko ya nekesurátan daya bil-bílin ku nga ittu daya iddè pikam kikaw. ");
INSERT INTO isd_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Ay se ka la magpàwa pe ka takkab naya arko ka pabeg pe nga balitù. Ittu ya akim-imallàán ke Dios. Ya kadaddu na, ay isa mitru se sangapúlu sentimitru, se ya kadakkal na, ay pittu púlu sentimitru. ");
INSERT INTO isd_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Ay magpàwa ka pe ka duwa nga sinan kerubin kiya magpungtu kiya takkab na nga ittu ya akim-imallàán ke Dios. Ya usaran mu, ay pinitpet nga balitù. ");
INSERT INTO isd_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Díkod magpungtu daya duwa nga sinan kerubin. Mekanáyun da kam kiya akim-imallàán ke Dios. ");
INSERT INTO isd_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Ay daya duwa nga kerubin, ay magàráng da, ay se daya payà da, ay mepangátu ya kaùnát da. Díkod, layyungán da ya akim-imallàán ke Dios nga ittu tu sisinnán da. ");
INSERT INTO isd_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Ay yán na akim-imallàán ke Dios, ay mìkab kiya arko. Ay iunag mu kiya arko ya nekesurátan daya bil-bílin ku nga iddè kikaw. ");
INSERT INTO isd_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ay kiyán na akim-imallàán ke Dios, ay amomanán taka kiya nagtuldán daya duwa nga sinan kerubin. Ikagiyán ku kikaw ngámin daya bil-bílin ku kadaya iIsrael. ");
INSERT INTO isd_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Magpàwa ka pe ka tebol. Ya kadaddu na, ay siyám púlu sentimitru, ay ya kadakkal na, ay gudduwa mitru. Ya kalingúdu na, ay pittu púlu sentimitru. Ya káyu wa akasiya ya usaram pe. ");
INSERT INTO isd_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Kalupkopán mu ka pabeg balitù, ay pakalupkopán mu pe daya lebi-lebig na ka pabeg pe nga balitù. ");
INSERT INTO isd_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Ay palebután mu ya otun na ka káyu wa tangagakam ya lampád na. Ay kalupkopán mu pe ka pabeg balitù, se mu pe pakalupkopán daya lebi-lebig na ka pabeg balitù pe. ");
INSERT INTO isd_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Ay pangwa mu pe ka appát nga galáng nga ittu daya ikabit mu kadaya appát síkil na. ");
INSERT INTO isd_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Dayán na galáng nga keruwaddán daya takkan na káyu nga pagbúlig kiyán na tebol, ay ipanìgad mu la ka bittì kiya lebig na. ");
INSERT INTO isd_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Mangwa ka pe ka takkan na káyu, nga ittu daya pamúlig nu kiya tebol. Ya káyu wa akasiya ya usaram, ay se kalupkopán muda pe ka balitù. ");
INSERT INTO isd_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Magpàwa ka pe ka gupagupán se pippinggán se daya pitser se daya bawl nga ittu daya mausár para kadaya dátun nga mainum. Màwa pe dayán ki pabeg balitù. ");
INSERT INTO isd_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ay mangippáy ka peyapeyang ka átang nga sinápay nga sisinnán ku peyang. ");
INSERT INTO isd_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Magpàwa ka pe ka kandelero nga pabeg balitù. Ya pungut na se arutáng na, ay se daya mal-malúkung na, ay màwa da ka pinitpet nga balitù. Daya dekorasyon na nga but-bútà se daya aken da, ay mekanáyun da kiya arutáng na. ");
INSERT INTO isd_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Ay yán na kandelero, ay atán annam ma pas-pasanga na nga magtutúway kiya arutáng na. Tallu kiya tapíngit, ay tallu pe kiya tapíngit. ");
INSERT INTO isd_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Ay ki kada pasanga, ay payán mu ka tallu wa mal-malúkung nga sinan bútà almendras nga atán tu bísì se aken da. ");
INSERT INTO isd_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Ay kiya arutáng mismu naya kandelero, ay payán mu ka appát nga nagsasarundù a sinan bútà almendras nga atán tu aken da. ");
INSERT INTO isd_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Payám ka isa nga sinan bútà ya panìgad daya munna nga duwa pasanga nga nagtuway, ay se la manin isa kiya panìgad daya mekàduwa, ay se la isa manin kiya mekàlu. Pakunán mu ngámin daya annam ma pas-pasanga naya kandelero. ");
INSERT INTO isd_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Ngámin dayán na but-bútà, se datu pas-pasanga, ay mekanáyun da kiya arutáng na. Ay ngámin da, ay màwa da ka tang-tangapánid nga pinitpet nga pabeg balitù. ");
INSERT INTO isd_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Ay magpàwa ka ka pittu wa pingki nga ittu daya meparotun kadaya pas-pasanga na, ta senu mawadaán ya àrangan na. ");
INSERT INTO isd_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Daya kartib pabílu daya pingki se daya aggippayán kadayán, ay màwa da pe ka pabeg balitù. ");
INSERT INTO isd_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Ay ya kandelero se ngámin daya ar-aruminta na, ay màwa da ka 34 kílu nga pabeg balitù. ");
INSERT INTO isd_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Ay ki angwám kadayán, ay masápul surútam tutu wala ya palánu nga sisinnán mu kídi nga bantay.” ");
INSERT INTO isd_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Ay nu iya tabernákulu, ya angwa mu, ay mangwa ka ka sangapúlu wa tulda nga naabal ka napiya nga dilána nga mannáw, se bayolet, se dag-daggáng. Ay burdáan muda pe ka dekorasyon da nga kerubin. ");
INSERT INTO isd_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Sangapáda ya kadadakkal ngámin dayán na tulda. Ya kadaddu da, ay sangapúlu mitru se gudduwa. Ay ya kába da, ay isa mitru se walu púlu sentimitru. ");
INSERT INTO isd_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Pagtatakípan mu daya limma nga tulda, ay se pagtatakípan mu manin pe daya limma. ");
INSERT INTO isd_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Ay se mu la lanángan ka galáng nga nàwa ki binola nga mannáw ya bíkat naya tapungtu nga tulda kitu limma nga nagtatákip, ay se mu la pakunán pe ya bíkat naya tapungtu nga tulda naya mekàduwa nga nagtatákip pa limma nga tulda. ");
INSERT INTO isd_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Limma púlu nga galáng ya ippáy mu ki isa nga tulda, ay ummán pe kitu isa. Magbabátug ngámin daya gala-galáng da nga duwa. ");
INSERT INTO isd_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Ay se ka magpàwa pe ka limma púlu wa sagpit nga pabeg balitù, nga ittu daya pagsagpit mu nu pagsulpítan mu win datu tulda. Díkod, matangtangapánid ya tabernákulu. ");
INSERT INTO isd_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Ay mangwa ka pe ka sangapúlu se isa tulda nga naabal ka dùdut kalding, nga ittu ya ìnáp mu kiya tabernákulu. ");
INSERT INTO isd_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Ay kuwaan mu ka sangapáda ya kadadakkal dayán na tulda. Ya kadaddu da, ay sangapúlu se tallu mitru se gudduwa, ay se ya kába da ay isa mitru se walu púlu se siyám sentimitru. ");
INSERT INTO isd_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Pagtatakípan mu ya limma nga tulda, se pagtatakípan mu pe daya annam. Ay ya mekannam, ay màpil la mapagkadduwa, nga ittu ya mepanin àráng kiya tabernákulu. ");
INSERT INTO isd_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Ay se ka la mangwa ka limma púlu wa galáng kiya bíkat naya tapungtu wa tulda kadatu nagtatákip pa tulda, ay se limma púlu galáng pe kiya bíkat naya tapungtu nga tulda naya mekàduwa nga nagtatákip pa tulda. ");
INSERT INTO isd_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ay se ka la mangwa ka limma púlu nga sagpit nga nàwa ka bága. Ittu dayán daya pagsagpit mu kadatu gala-galáng datu tulda nu pagtakípan muda ngin. Díkod tang-tangapánid ya pagbalinán naya tabernákulu. ");
INSERT INTO isd_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ay ya mekasangapúlu se isa nga tulda, ay mekikeway yala ya gudduwa na kiya likud naya tabernákulu. ");
INSERT INTO isd_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ay ya gudduwa mitru kitu tapíngit bíkat na, ay mekikeway kampela ngin nin kiya bíkat naya tabernákulu. Ay ya gudduwa mitru kiya tapíngit bíkat na, ay mekikeway kampela ngin nin kiya tapíngit bíkat naya tabernákulu ta senu matàbán. ");
INSERT INTO isd_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Ay mangwa ka pe ka ìnáp mu manin kiya tabernákulu. Ya usaram, ay lálat toru wa karneru. Ay se ka la manin mangwa ka panin lasi nga annáp nga nàwa ka napiya nga lálat. ");
INSERT INTO isd_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Ay se ka mangwa ka dab-dabbi nga ittu daya anumalay naya tabernákulu. Ay ya káyu wa akasiya ya usaram. ");
INSERT INTO isd_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Ya kadaddu dayán na dab-dabbi, ay appát mitru se gudduwa. Ay ya kalampád da, ay pittu púlu sentimitru. ");
INSERT INTO isd_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Ay kiya tapungtu naya kada dabbi, mangwa ka ka duwa nga padíla nga magdammáng. Ittu dayán daya pagtatakípán dayán na dab-dabbi. ");
INSERT INTO isd_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Mangwa ka ka duwa púlu dabbi para ki panillod naya tabernákulu, ");
INSERT INTO isd_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ay se ka mangwa ka appát púlu wa pangipasikádan kadaya dab-dabbi. Ya usaram ay silber. Duwa nga agpasikádan ya pagsàraddán naya isa nga dabbi, nga ittu ya kesulpongán datu duwa nga padíla na. Ay se duwa manin kiya sumarunu nga dabbi, nga ittu pe ya kesulpongán daya duwa nga padíla na. ");
INSERT INTO isd_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ay kiya tapíngit bíkat naya tabernákulu, kiya panidáya, ay mangwa ka pe ka duwa púlu wa dabbi. ");
INSERT INTO isd_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Mangwa ka pe ka appát púlu wa agpasikádan kadaya dab-dabbi nga silber. Duwa nga agpasikádan ya kada dabbi. ");
INSERT INTO isd_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Ay kiya panin likud na ya tabernákulu, kiya pane sirbútán, ay mangwa ka ka annam dabbi. ");
INSERT INTO isd_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Ay se ka pe mangwa ka duwa dabbi para kadaya síku naya tabernákulu ki likud. ");
INSERT INTO isd_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Magrewing da ki panìgad panda ki paningúdu kiya giyán naya munna nga galáng. Páda na pe kiya isa nga atán ki síku. ");
INSERT INTO isd_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Díkod walu ngámin daya dabbi se sangapúlu se annam ngámin daya agpasikádan. Duwa ki kada dabbi. ");
INSERT INTO isd_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Magpàwa ka ka takkan na nàwa ka káyu wa akasiya. Limma ya para kiya tangapíngit naya tabernákulu, ");
INSERT INTO isd_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ay limma pe ya mippáy kiya tapíngit. Ay limma pe nga takkan ya mippáy kadaya dabbi nga atán kiya padne sirbútán nga ittu ya likud naya tabernákulu. ");
INSERT INTO isd_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Ay ya takkan na mippáy kiya panin ábà daya dabbi, ay tanganáyun. ");
INSERT INTO isd_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Ay ngámin daya dabbi, ay kalupkopán muda ka balitù. Kuwaan mu pe daya gala-galáng da ka balitù. Ittu dayán ya pangiruwaddán mu kadaya tak-takkan na káyu. Ay kalupkopán mu pe daya ngámin na takkan ka balitù. ");
INSERT INTO isd_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Ay se mu la ipasíkád ya tabernákulu, nga ummán kitu palánu nga nepassingan kikaw kitu bantay. ");
INSERT INTO isd_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Magpàwa ka pe ka abay nga kurtína nga naabal ka mannáw se bayolet se dag-daggáng nga binola nga dilána. Ay se la makappiya maburdáan pe ka kerubin. ");
INSERT INTO isd_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Ikabit mu idi kiya appát adígi nga káyu akasiya nga nakalupkopán ka balitù. Ipasíkád muda ki appát nga agpasikádan na nàwa ka silber. Payán mu daya adígi ka sáwit nga nàwa ka balitù. ");
INSERT INTO isd_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Irabit mu ya kurtína ka sagpit nga nàwa ka balitù. Ay se mu la ilnà ya arko nga giyán tu nekesurátan datu bil-bílin ku kiya nakurtináan na giyán. Ay tu kurtína ya pagbàtán daya duwa nga kuwartu. Ya isa ay ittu ya kuwartu nga Napatag, ay ya isa ay ittu kuwartu nga Kapà-pàgán. ");
INSERT INTO isd_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Ìkab mu ya takkab nga akim-imallàán ke Dios kitu arko, ay se mu la ippáy kiya kuwartu nga Kapà-pàgán. ");
INSERT INTO isd_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Ay tu tebol, ay ippáy mu kiya panin lasi naya kurtína. Ay ya kandelero, ay ippáy mu kiya panillod da unag naya tabernákulu, nga magpanidmáng kiya tebol. Ay ya tebol, ay ippáy mu kiya panidáya kiya unag naya tabernákulu. ");
INSERT INTO isd_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Ay payán mu pe ka kurtína ya lalangkán naya tabernákulu. Ya kurtína ay maabal ka mannáw, se bayolet, se dag-daggáng nga binola dilána nga napiya. Paburdáan mu ya kurtína. ");
INSERT INTO isd_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Ikabit mu idi nga kurtína kiya limma adígi nga akasiya nga nakalupkopán ka balitù. Ipasíkád mu da ki limma nga agpasikádan nga nàwa ka bága. Payán muda pe ka sáwit nga nàwa ka balitù nga ittu daya pangikabitán mu kiya kurtína.” ");
INSERT INTO isd_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Ay se ka manin mangwa ka annìdúgán ka pagbasu. Ya kadakkal na, ay duwa mitru se tallu púlu sentimitru nga nagbaal. Ay ya kadallam na, ay isa mitru se tallu púlu sentimitru. Ya káyu wa akasiya ya usaram. ");
INSERT INTO isd_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Kiya útun daya appát síku na, ay payán muda ka sinan sàgud. Ay mekanáyun da kiya annìdúgán. Ay se mu la nga kalupkopán ya annìdúgán ka bága. ");
INSERT INTO isd_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Ay se ka la magpàwa ka timba nga aggapuyán se kadaya agtallaán kiya abu, se daya pal-pála. Magpàwa ka pe kada besin se daya pagkáwit ka karni. Ay kuwaan mu dayán ngámin na ar-aruminta ka bága. ");
INSERT INTO isd_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ay mangwa ka pe ka bága nga sinan balúláng nga issaságat na. Payán mu ka galáng daya appát síku naya sinan balúláng nga nàwa pe ka bága. ");
INSERT INTO isd_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Ay se mu la ippáy kiya unag naya annìdúgán. Ikabit mu kiya panìgad naya lebig na, ta senu dumatang kiya ábà na. ");
INSERT INTO isd_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Mangwa ka pe ka takkan na káyu ka pagbúlig kiya annìdúgán. Káyu wa akasiya ya kuwaam, ay se kalupkopán mu pe ka bága. ");
INSERT INTO isd_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Ay dayán na takkan, ay meruwad da kadaya galáng nga atán kiya magpíngit kiya bíkat naya annìdúgán nu bulígán da. ");
INSERT INTO isd_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ay ya dingding naya annìdúgán, ay tabla. Díkod ummán ka kahon ya kàwa na. Kuwaan mu dayán ngámin ka ummán kitu nepassingan ku kikaw kitu bantay. ");
INSERT INTO isd_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Ay mangwa ka pe ka amuwág naya tabernákulu. Ya amuwág na ki panillod, ay abutan mu ka kurtína nga nàwa ka napiya nga dilána nga appát púlu se annam mitru ya kadaddu na. ");
INSERT INTO isd_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Mangwa ka ka duwa púlu wa pagadígi mu kiya amuwág. Mangwa ka pe ka duwa púlu nga pangisiínán mu kadayán. Pabeg bága ya usaram kadayán ngámin. Ngamay daya sáwit da se daya saríkáw da, ay silber ya usaram. ");
INSERT INTO isd_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Ay páda na pe kiya panidáya. Maabut pe ya amuwág ka kurtína nga appát púlu se annam mitru ya kadaddu na. Ay duwa púlu pe ya adígi na nga mesíin pe. Ay màwa dayán ka bága. Ngamay daya sáwit da se daya saríkáw da, ay màwa da ka silber. ");
INSERT INTO isd_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Ya súba naya amuwág kiya pane sirbútán, ay duwa púlu se tallu mitru. Sangapúlu wa adígi ya ippáy mu se isíin muda pe. Ay maabut ka kurtína pe. ");
INSERT INTO isd_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ay ya súba naya amuwág ga panin àráng ki padne lattakán, ay duwa púlu se tallu mitru pe. ");
INSERT INTO isd_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Ya kadaddu naya kurtína kiya tapíngit naya lalangkán na, ay annam mitru se siyám sentimitru. Ay ya angadigiyán na, ay tallu se mesíin da pe. ");
INSERT INTO isd_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Ay ya tapíngit na, ay maabut pe ka kurtína. Ay annam mitru se siyám sentimitru ya kadaddu na pe. Ay tallu pe ya angadigiyán na se mesíin pe. ");
INSERT INTO isd_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Ya ruwángan naya amuwág, ay mapayán pe ka annam mitru se siyám sentimitru wa kurtína nga nàwa ki mannáw, bayolet se dag-daggáng nga naabal ki napiya nga dilána. Ay maburdáan pe. Mekabit yán ki appát ta adígi nga nesisíin pe. ");
INSERT INTO isd_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Ngámin daya adígi ki amuwág, ay atán bagákat da nga silber, se daya sáwit da ay silber da pe. Ay daya nesiínán da, ay pabeg bága. ");
INSERT INTO isd_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Ya pásit naya amuwág, ay appát púlu se annam mitru, se ya súba na, ay duwa púlu se tallu mitru. Ay maabut ka kurtína nga nàwa ki napiya nga dilána nga ya kadaddu na, ay duwa mitru se tallu púlu sentimitru. Ay mesíin daya adígi na ka bága. ");
INSERT INTO isd_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Ngámin daya maus-usár ra ar-aruminta kiya tabernákulu, ay se daya pat-pátù na, se daya pat-pátù naya amuwág na, ay màwa da ngámin ka bága. ");
INSERT INTO isd_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Ay ibílin mu pe kadaya iIsrael nga mangilbet da ka denu olíbo wa napabeg ka para kiya dílág, ta senu masibtán peyang ya kandelero kiya oras nga kasibtán na. ");
INSERT INTO isd_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Ay kiya tabernákulu kiya panin lasi naya kurtína nga giyán natu nekesurátán datu bil-bílin, de Aaron na maggaáma ya magtagasíngan kiya dílág, ta senu siggagatang da peyang ki àráng ne APU. Ay metul-túluy idi ya bílin pe yin kadaya sumar-sarunu nga tolay nga iIsrael.” ");
INSERT INTO isd_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Ay se mu la alà e Aaron na wagi mu se daya pútupútut na nga lalláki, nga de Nadab, se Abihu, se e Eleazar, se Itamar. Ikísi muda kadaya iIsrael ta aggída daya pappádi nga magsurbi kiyà. ");
INSERT INTO isd_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Pangwa mu nge Aaron nga wagi mu ka napatag nga bádu pádi nga ittu ya kapiyaán na pagbádu na. ");
INSERT INTO isd_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ay se mu la kagiyan kadaya ngámin nalaing nga niddán ku ka paglaingán da, nga pangwa da nge Aaron ka ibbabádu na, nga ittu ya mangipakammu nga aggína ya nekísi nga pádi ku. ");
INSERT INTO isd_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ay tu dedi daya ibbabádu na nga kuwaan da: annáp gútù, ya efod, ya kamason na, ya amin unag nga kamason na nga nabúrì, ya pagabungut na, se ya pagbagákat na. ");
INSERT INTO isd_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Ya usaran da, ay binola nga balitù se mannáw, bayolet, dag-daggáng se napiya nga dilána. ");
INSERT INTO isd_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Kuwaan da ya efod ka binola nga balitù se binola nga mannáw se bayolet se dag-daggáng se napiya nga dilána nga napiya ya nekaabal na. ");
INSERT INTO isd_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Atán duwa nga sadáng na nga ittu ya pagtakípan naya panin àráng se panin likud na. ");
INSERT INTO isd_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Ay ya naburdáan na bagákat na, ay páda na pe ya kàwa na. Daya mausár ay balitù, se mannáw, bayolet, se dag-daggáng nga binola se napiya nga dilána. ");
INSERT INTO isd_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Mangalà ka ka duwa pilà a oniko se mu la nga imarka daya ngag-ngágan datu lalláki nga pútupútut tu Israel, ");
INSERT INTO isd_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","annam ngágan kiya isa nga batu, ay annam pe kiya isa nga batu. Pagsasarunuwan muda nga imarka sigun kitu nekeanà da. ");
INSERT INTO isd_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Ya kesúrát dayán nga ngag-ngágan daya pútupútut tu Israel, ay ummán kiya angngimarka naya maragkuwa ka sangkilat nga immamarka. Ay se muda la nga ipigkat dayán na batu kiya ummán ki nalága nga bibittì a bárus nga balitù. ");
INSERT INTO isd_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Ay se muda la iparikkáp kadaya abága natu sinadáng naya efod. Dayán na batu ya panamdammán nu kadatu pútupútut natu Israel. Bug-bugtung ne Aaron daya ngag-ngágan da ki akiàráng na ke APU ka panamdammán na kaggída. ");
INSERT INTO isd_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Mangwa ka ka ummán ka nalága nga bibittì bárus nga balitù nga ittu daya pangipigkattán mu kadaya batu. ");
INSERT INTO isd_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Ay magpàwa ka pe ka duwa kadena nga pabeg balitù. Lubídan muda, se muda ikabit kadatu nangipigkattán mu kadatu batu.” ");
INSERT INTO isd_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Ay magpàwa ka pe kiya annáp gútù na nga usaran na nu magsaludsud ke APU. Masápul la napiya ya kàwa na nga ummán kiya kàwa naya efod. Ya usaran mu pe, ay balitù se binola nga mannáw, bayolet, se dag-daggáng se napiya nga dilána. ");
INSERT INTO isd_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Nu màpil ay magbalin ka kuwadradu ya kàwa na. Siyám inses ya kadaddu na, ay siyám inses pe ya kalampád na. ");
INSERT INTO isd_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Ay payán mu ka appát daládag ga nagbal-baláki nga batu. Ya isa nga daládag, ay daya batu wa karnelia, crisolite, se esmeralda. ");
INSERT INTO isd_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Ya mekàduwa nga daládag ay turkísa, safiro, se diyamante. ");
INSERT INTO isd_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Ay ya mekàlu wa daládag, ay daya batu wa jacinto, aget, se amatista ya ippáy mu. ");
INSERT INTO isd_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Ay ya mekappát daládag ay berilo, oniko se haspe. Mepigkat da pe ka nalága nga bibittì a bárus nga balitù. ");
INSERT INTO isd_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Sangapúlu se duwa ngámin daya batu nga kemarkaán daya ngag-ngágan datu pútupútut tu Israel. Díkod ummán da ka immamarka daya batu. Atán ngágan datu batu. Ngágan datu sangapúlu se duwa nga tangámalán. ");
INSERT INTO isd_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Mangwa ka ka kadena nga pabeg balitù para kiya annáp gútù. Lubídan mu dayán na kadena. ");
INSERT INTO isd_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Mangwa ka pe ka duwa galáng nga pabeg balitù. Ippáy muda kadaya duwa nga síku naya annáp gútù. ");
INSERT INTO isd_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Ay se mu la ikabit datu duwa nga nalúbid da kadena nga balitù kadatu duwa nga galáng nga atán kadatu síku natu annáp gútù. ");
INSERT INTO isd_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Ay datu tapungtu datu duwa nga nalúbid nga kadena, ay ikabit muda kadatu duwa nga nepigkat ta batu kadatu abága naya efod. Díkod mekabit datu kadena kiya àráng se kitu abága naya efod. ");
INSERT INTO isd_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Ay se ka manin mangwa ka duwa galáng nga balitù. Ikabit muda kadaya panìgad nga síku naya annáp gútù ki linung na nga otun tu efod. ");
INSERT INTO isd_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Mangwa ka manin ka duwa nga galáng nga balitù se mu ikabit kiya panìgad kiya amin lasi daya duwa nga sadáng naya efod kiya nagpandanán na kiya paningúdu naya naburdáan na sadáng naya efod. ");
INSERT INTO isd_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Ay daya galáng naya annáp gútù, ay mekabit da kadaya gala-galáng naya efod ka mannáw nga lúbid. Díkod magpanin otun ya annáp gútù kiya naburdáan na parte naya efod. Ay akkan mesibna pe yin kiya efod. ");
INSERT INTO isd_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Ay díkod, e Aaron, ay ag-agtu na ki adanni ki púsu na daya ngag-ngágan datu lalláki nga pútupútut natu Israel nga nesurátan kiya annáp gútù nu magunag kiya Kapàgán na kuwartu nga magadang ka sírib ke APU. Ay díkod mepadamdam da peyang ngin ke APU. ");
INSERT INTO isd_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ay kiya annáp gútù nga magpasírib, ay ippáy mu daya Urim se Tummim. Masápul la adanni da ki púsu Aaron nu mawe makiàráng ke APU. Díkod ag-agtu na peyang nu makiàráng ke APU ya magpasírib kaggína kiya agdisisyon na para kadaya iIsrael.” ");
INSERT INTO isd_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Ya kamason nga magpanin linung kiya efod, ay pabeg mannáw. ");
INSERT INTO isd_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Ya bùlaw na ay mapayán ka natùlapid da bibittì lúbid ka tapár na ta senu akkan mapìsi. ");
INSERT INTO isd_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Ay kiya gayádan na, ay maarumaymayán ka sinan bayábat nga nga nàwa ka binola nga mannáw, bayolet se dag-daggáng. Ay kiya nagbabàtán da, ay maarumaymayán ka bibittì a kingkeng nga nàwa ka balitù. ");
INSERT INTO isd_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Díkod isa nga kingkeng ki kada isa nga sinan bayábat. Ay díkod mapalebután ya gayádan naya bádu. ");
INSERT INTO isd_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Ittu ya pagbádu ne Aaron nu magubra ngin kiya kinapádi na. Ay magìna ya agkingkeng na nu magunag kitu napatag nga giyán nga umàráng ke APU. Ay ummán pe nu lumawán nin. Ay díkod akkan matay. ");
INSERT INTO isd_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Ay mangwa ka pe ka sagápaw na nga nàwa ki pabeg balitù nga nadikorasyonán ka but-bútà. Ay se mu la imarka kiyán ya ‘Napatag ke APU.’ ");
INSERT INTO isd_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Ikabit mu idi kiya panin àráng naya abungut na. Ay mannáw wa lúbid ya pangikabit mu. ");
INSERT INTO isd_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Mippáy idi kiya kíday ne Aaron. Ay e Aaron ya mangáku kadaya ngámin kinadakè daya dátun daya iIsrael ki angdalus da ngin kadayán nu idátun dada ngin ke APU. Ay masápul la atán peyang yán na sagápaw kiya kíday ne Aaron, ta senu pàgan ne APU da. ");
INSERT INTO isd_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Ay ya amin unag ga nabúrì a kamason, ay naabal ka napiya nga dilána. Ay páda na pe ya abungut na. Màwa pe ka napiya nga dilána. Ay ya bagákat na, ay màwa ki naburdáan na abal. ");
INSERT INTO isd_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Ay ya para kadaya lalláki nga pútupútut ne Aaron, ay magpàwa ka ka kam-kamason se bag-bagákat da se daya abungut da, ta senu napiya se nadáyaw tutu wala ya sing-singan da. ");
INSERT INTO isd_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Ibádum ke Aaron se kadaya pútupútut na dayán na ikkaaruwát da, se muda ipuwán ka denu se muda ikarárag ka angngikísi mu kaggída ka maurdenán nga pappádi nga magsurbi kiyà. ");
INSERT INTO isd_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Ay pangwa muda pe ka kalsunsilyu da nga dilána, ta senu matàbán ya kinasoba da. Ya kadaddu da, ay panda ki panda lappu da kampela ngin. ");
INSERT INTO isd_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Isúut de Aaron dayán se daya pútupútut na nu magunag da kiya tabernákulu, onu nu umbet da kiya annìdúgán ka insensu nga magsurbi kiyà kiya Napatag nga Kuwartu, ta senu akkan da magbásul se akkan da matay. Tu idi peyang ngin ya sur-surútan nu panggap kaggína se daya ngámin na pútupútut na.” ");
INSERT INTO isd_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Ay nán manin ne Apu “Ay tu idi ya kuwaan mu kiya angngikísi mu kaggída, ta senu magsurbi da ka pádi ku. Mangalà ka ka isa nga nabagu pikam ma toru báka se duwa nga toru wa karneru nga áwan tutu wala nga sad-sadúra. ");
INSERT INTO isd_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Mangwa ka pe ka sinápay ya akkan nakibugán ka pamalbád, se sinápay ya áwan pamalbád da nakibugán ka denu se ning-ingpit nga sinápay nga napìgesán ka denu. Ya kapíyán na arína ya usaran mu ki angwa mu kadayán. ");
INSERT INTO isd_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Ippáy muda ki sissa nga làba, ay se mu la ilbet ya làba se ya toru wa báka se daya duwa toru wa karneru. ");
INSERT INTO isd_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Alà mu de Aaron se daya pútupútut na kiya gagyangán naya tabernákulu, ay se muda la nga digútan. ");
INSERT INTO isd_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Ay se mu la nga alà datu ikkaaruwát da. Ikamason mu ke Aaron ya amin unag ga kamason na se la ya kamason na kippayán naya efod. Isúut mu ya efod kaggína se ya annáp gútù se mu la bagakátan kiya naburdáan na bagákat naya efod. ");
INSERT INTO isd_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Ay iabungut mu pe ya abungut na se ipasagápaw mu pe daya napatag nga sagápaw kiya abungut na. ");
INSERT INTO isd_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Ay se ka mangalà ka ikkiípu nga denu, ay se mu la nga isiyà ki úlu na ka angngipassingan mu nga aggína ya pílì. ");
INSERT INTO isd_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Ay se mu la alà daya pútupútut na, ay se muda suútán ka kamason ");
INSERT INTO isd_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ay se muda pe bagakátan kiya ibbabagákat da. Ay se muda pe nga abungután. Ay metudin kaggída ngin ya kinapádi gapu kiya akkan mippaippà a bílin ku. Ittu lugud yán ya isa nga kuwaan mu ka angngikísim ke Aaron se kadaya pútupútut na. ");
INSERT INTO isd_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Alà mu ya toru wa báka kiya gagyangán naya tabernákulu. Ay de Aaron se daya annánà na, ay iparotun da daya íma da kiya úlu naya toru. ");
INSERT INTO isd_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Ay se mu la nga patayan ya toru kiya àráng ne APU kiya gagyangán naya tabernákulu. ");
INSERT INTO isd_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Ay se ka la mangalà ki dága naya toru, ay se mu la nga ipìges kadaya sinan sàgud, nga atán kadaya síku naya annìdúgán. Ya intutuldum la ya pangipìges mu. Ay ya bunna kiya dága, ay isiyà mu kiya pungut naya annìdúgán. ");
INSERT INTO isd_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Ay alà mu ngámin daya taba nga nekalupkop kadaya inunag naya báka, se ya kapíyán kiya agtay na, se daya duwa nga analbát na se daya nekalupkop nga taba. Ay se muda la sìdúgan kiya annìdúgán. ");
INSERT INTO isd_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Ngamay daya tabbit naya toru se daya lálat na se daya kawel na, ay sìdúgan muda kiya lasi naya íli. Tú dayán daya pagbasu ki básul. ");
INSERT INTO isd_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Ay se mu la nga alà ya isa kadatu toru wa karneru, ay se dala iparotun de Aaron na maggaáma kiya úlu naya toru daya íma da, ");
INSERT INTO isd_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ay se mu la pe nga patayan ya toru. Alà mu ya dága na, ay se mu la nga isà-sàyu kadaya ngámin dingding naya annìdúgán. ");
INSERT INTO isd_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Ay se mu la nga tup-tup-an ya toru. Bagguwán mu daya inunag na se daya síkil na. Ay se muda la iamung kadatu tabbit nga natupà se itu úlu na. ");
INSERT INTO isd_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Ay se mu la nga sìdúgan ya ngámingámin kiya annìdúgán. Ittu yán ya sinìdug nga dátun ke APU. Pàgan na ya aláb. ");
INSERT INTO isd_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Ay se mu alà manin tu isa nga toru, ay se la nga iparotun de Aaron na maggaáma ya íma da kitu úlu natu toru, ");
INSERT INTO isd_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","ay se mu la nga patayan ya toru. Mangalà ka kitu dága na se mu la ipìges kiya adon naya panin diwanán na talínga de Aaron se daya pútupútut na. Ay pìgesán mu pe daya indadakkal naya diwanán íma da, ay se daya indadakkal naya diwanán na sik-síkil da. Ay se mu la isà-sàyu kiya ngámin dingding naya annìdúgán ya bunna nga dága. ");
INSERT INTO isd_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Ay se ka mangalà kitu dága nga atán kiya annìdúgán, ay se ka pe mangalà kitu denu wa ikkiípu, ay se mu la war-warsián de Aaron na maggaáma se daya bad-bádu da kadayán. Ay díkod de Aaron na maggaáma se daya bad-bádu da, ay kuw-kuwa kuda ngámin. ");
INSERT INTO isd_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Ay alà mu pe datu taba natu toru wa karneru; datu nataba nga íput se datu taba nga nekalupkop kadatu inunag na. Ay alà mu pe tu kapíyán natu agtay na, se datu duwa nga analbát na meráman datu taba nga nekalupkop kadayán. Alà mu pe ya panin diwanán na apel na (ta tu idi ya toru karneru nga para kiya angngikísi) ");
INSERT INTO isd_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Mangalà ka pe tangabukal sinápay kadatu linàba nga sin-sinápay nga nedátun ke Apu. Mangalà ka pe ka tangapánid nga sinápay nga nakibugán ka denu, se isa nga ning-ingpit nga sinápay. ");
INSERT INTO isd_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Ay se mu la nga ippáy ngámin dayán kiya im-íma de Aaron na maggaáma, ay se mu petáyag kaggída dayán, nga ittu dayán daya netatáyag ga dátun ke APU. ");
INSERT INTO isd_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Ay se mu la alà kammin kaggída, se mu la iparotun kitu masìdug ga dátun ke APU kiya annìdúgán. Ay díkod metangasìdug da pe yin, ay nabangug ke APU ya aláb na. Ittu yán ya masìdug ga dátun ke APU. ");
INSERT INTO isd_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Ay se mu la alà tu gútù natu toru wa karneru nga para ki pannakaurden ne Aaron. Ay se mu la nga itáyag nga ittu yán ya netatáyag nga dátun ke APU. Ay ittu yán ya púpug mu. ");
INSERT INTO isd_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Ay ikarárag mu ya gútù se itu apel nga netáyag mu nga dátun nga gayát kitu toru wa karneru nga para kitu nekaurdenán de Aaron na maggaáma. ");
INSERT INTO isd_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Ittu yán ya dátun daya iIsrael ke APU gapu kiya akikappiya da kaggína. Ittu dayán daya mepakin-kuwa kade Aaron se kadaya pútupútut na. Ay ittu pe yán nin ya sur-surútan da peyapeyang ngin ka panda. ");
INSERT INTO isd_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Ay daya napatag ga aruwátan ne Aaron, ay mepatáwid da kadaya pútupútut na, ta senu ittu dayán daya pagaruwát da pe yin nu mekísi da se maurdenán da. ");
INSERT INTO isd_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ya pútut na nga sumukát kaggína kiya kinapádi na, ay isúut na dayán ka pittu ngalgaw nu magunag kiya tabernákulu nga magubra kiya Napatag nga Kuwartu. ");
INSERT INTO isd_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Ay ya karni natu toru wa karneru nga nekaurdenán ne Aaron, ay ilanggang mu kiya giyán na nepakin-kuwa kiyà in. ");
INSERT INTO isd_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Ay de Aaron na maggaáma ya mangán kiya karni. Ay isida da kiya sinápay ya nippapáy ki làba nga atán ki gagyangán naya tabernákulu. ");
INSERT INTO isd_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Aggída ya mangán kadaya karni daya animál nga nebasu ka pakapakawanán daya bas-básul da kiya pannakakísi da se pannakaurden da. Awan sabáli tolay ya mepangán kiyán na karni ta nepakin-kuwa ke APU. ");
INSERT INTO isd_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ay nu atán mabunna da kiya karni onu kiya sinápay panda ki pagmakát, ay masìdug da. Akkan da mabalin kanan ta kuw-kuwa APU da. ");
INSERT INTO isd_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Ay díkod kuwaan mu kade Aaron na maggaáma daya nebil-bílin ku kikaw. Pittu ngalgaw ya angngurden mu kaggída. ");
INSERT INTO isd_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Kiya unag nayán na pittu ngalgaw, ay inalgaw ka nga magbasu ka isa toru wa báka ka pakapakawanán daya bas-básul. Ay magbasu ka pe ka angdalus mu kiya annìdúgán, se mu siyaán ka denu ka angngikísi mu se angngipakin-kuwa mu ke APU. ");
INSERT INTO isd_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Ay pittu ngalgaw ka pe nga makabasubasu para kiya pakapakawanán daya bas-básul ki angngipakin-kuwa mu ke APU kiya annìdúgán. Ay díkod, magbalin ka napatag pànang ke APU yán. Ay ngámin na melìlet kiyán, ay magbalin ka napatag pe. ");
INSERT INTO isd_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Ay tu idi ya idátun mu kiya annìdúgán ki káda algaw. Duwa nga urbun karneru nga tangadagun da ngin. ");
INSERT INTO isd_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Ya isa, ay idátun mu ki pagmakát, ay ya isa ay ki gídám. ");
INSERT INTO isd_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Ay ibulun mu kiya munna nga urbun na dátun ya duwa litru nga kapíyán na arína nga nakibugán ka isa nga litru nga denu nga napgat ki búnga olíbo, se isa litru nga bási nga ittu ya mainum nga dátun. ");
INSERT INTO isd_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ay tu isa nga urbun karneru nga medátun ki gídám, ay pasingkunan mu pe kiya dátun ki pagmakát. Masìdug pe ta senu mepàsob ke APU ya aláb na, ay paganggammán na. ");
INSERT INTO isd_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ay kiya kaatán mu, ay ummán kiyán peyapeyang ngin ya dátun nu kiya gagyangán naya tabernákulu nga ittu ya pagtammuwán ta se ya angngamomanán ku kikaw. ");
INSERT INTO isd_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Ay kiyán pe ya pagtatammuwán mi se daya iIsrael. Ay gapu kiya pannakabalin naya diláng ku, ay magbalin yán ka kuw-kuwà. ");
INSERT INTO isd_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Ikísi ku ka kuw-kuwà ya tabernákulu se ya annìdúgán. Ay ummán pe kade Aaron na maggaáma, ikísi kuda pe ka pappádi nga magsurbi kiyà. ");
INSERT INTO isd_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Mepagataatán nà kadaya iIsrael, ay Iyà ya Dios da. ");
INSERT INTO isd_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Ay ammuwán da nga Iyà ya APU nga Dios da nga nangitálaw kaggída ka íli Egipto. Netálaw kuda ta senu mepagataatán nà kaggída. Iyà ya APU nga Dios da.” ");
INSERT INTO isd_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Ay mangwa ka pe ka annìdúgán ka insensu. Ya káyu wa akasiya ya kuwaan mu. ");
INSERT INTO isd_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Ya kadakkal na, ay gudduwa mitru nga magbaal, ay ya kalingúdu na, ay siyám púlu sentimitru. Ay payán mu pe ka sinan sàgud daya síku na, ay ikanáyun mu kiya baggi na. ");
INSERT INTO isd_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ay se mu la nga kalupkopán ya otun na se daya dingding na ka pabeg balitù, ay oray pe datu sinan sàgud na. Ay payán mu ka napiya nga kalupkop nga pabeg balitù daya ngámin na ráging na. ");
INSERT INTO isd_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Ay payán mu pe ka agduduwa galáng nga balitù ya magpíngit bíkat na kiya linung naya lebig na nga adanni kadaya síku na. Ittu dedi daya keruwaddán daya takkan nga pagbúlig kiyán. ");
INSERT INTO isd_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Ay daya takkan, ay màwa da pe ka káyu wa akasiya, ay se muda la nga kalupkopán pe ka balitù. ");
INSERT INTO isd_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ippáy mu yán na annìdúgán ka insensu kiya panin àráng naya kurtína, nga atán ki àráng naya arko, nga nekippayán naya nekesurátan daya bil-bílin nga nekeparotunán pe naya akim-imallàán ke APU, nga ittu pe ya angngamomanán ku kikaw. ");
INSERT INTO isd_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Ya annìdúgán pe ya panìdúgán ne Aaron ka angngidátun na ka nabangug nga insensu. Tu yán ya kuwaan na ki káda pagmakát nu kappiyánan na daya dil-dílág. ");
INSERT INTO isd_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Ay páda na pe ki gídám, nu kappiyánan na daya dil-dílág. Manìdug peyang ngin ka insensu ka nabangug nga dátun ke APU. Ittu pe yán ya kuwaan daya sumar-sarunu nga gakagaka nu. ");
INSERT INTO isd_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Akkan ka mangidátun ka ur-úray nga insensu kídi nga annìdúgán. Akkan ka pe manìdug ka dátun na animál kídi onu daya dátun na trígo. Ay akkan ka pe mangisiyà kiyán ka dátun na mainum. ");
INSERT INTO isd_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Ki káda dagun, ay pìgesán ne Aaron ka dága pinagbasu daya sinan sàgud na ka angdalus na kiyán. Yán na kuwaan na, ay ittu pe ya màwa ngin kadaya sumar-sarunu nga gakagaka nu. Ittu yán ya kapàgán ke APU.” ");
INSERT INTO isd_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Ay nán manin ne APU ke Moses: ");
INSERT INTO isd_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Nu kuwaan mu ya sensus para kadaya iIsrael ka angngirigistru mu kaggída, ngámin da ay masápul la mangidde da ke APU ka pagsaka da ki biyág da, ta senu áwan umbet nga sinakit kaggída gapu ki agrigistru da. ");
INSERT INTO isd_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ay tu idi ya báyad naya káda isa nga magparigistru: gudduwa sikel kiya agkílu na tabernákulu. Idi nga gudduwa sikel ay medátun ke APU. ");
INSERT INTO isd_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Ngámin daya merigistru nga magdagun ka duwa púlu se daya magdagun ka nasurù duwapúlu, ay mangidde da ngámin kídi nga dátun ke APU. ");
INSERT INTO isd_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Ay kiyán na midde nga dátun ka bátug pagsaka da kadaya biyág da, ay sangapáda ya idde da ngámin nga gudduwa sikel. Akkan maamúngán kadaya nabànáng, ay akkan màsayán kadaya napubri. ");
INSERT INTO isd_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Alà mu ya pirà a báyad biyág daya iIsrael, ay ittu ya gastuwan nu kadaya masap-sápul kiya tabernákulu. Ay iyán na pirà a pinangsaka da kiya biyág da ya mangipadamdam ke APU kaggída.” ");
INSERT INTO isd_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Netul-túluy ne APU ya nangamomán kitu Moses: Ay nán na manin, ");
INSERT INTO isd_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Mangwa ka pe ka besin se ya síkil na nga pangiparotunán mu. Kuwaan mu dayán ka bága. Ippáy mu kiya nagbàtán daya Tabernákulu se iya annìdúgán ka pagbasu. Ay payán mu ya besin ka danum. ");
INSERT INTO isd_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Ay ya danum na ya pagbagguwán se pagusesuwán de Aaron se daya pútupútut na ");
INSERT INTO isd_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","nu magunag da kiya Tabernákulu, onu nu mawe da kiya giyán naya annìdúgán na magubra kiya angngidátun da ke APU kiya masìdug ga dátun. ");
INSERT INTO isd_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Masápul magbaggu da se magusesu da, ta senu akkan da matay. Ay akkan mippaippà idi yin na bílin kaggína se daya ngámin gakagaka na se daya gakagaka da.” ");
INSERT INTO isd_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Ay nán ne APU kitu Moses: ");
INSERT INTO isd_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Mangalà ka kadaya kapíyán na talibangug. Mangalà ka ka annam kílu nga mira, tallu kílu wa sinamon na nabangug, ay se tallu kílu pe nga nabangug nga kanela. ");
INSERT INTO isd_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","Mangalà ka pe ka annam kílu nga kasiya sigun kiya agrukud da kiya tabernákulu, ay se ka mangalà ka appát litru nga denu olíbo. ");
INSERT INTO isd_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Ay pagkikibúgam dedi nga ummán kiya angwa daya maragkuwa ka talibangug. Mangwa ka nabangug nga denu nga ikkiípu para kadaya napatag ke Dios. Ay napatag ke APU idi nga denu. ");
INSERT INTO isd_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Warsián mu ya tabernákulu, se ya arko nga giyán naya nekesurátán daya bil-bílin kiyán na denu ka amagbalin mu kadayán ka kuw-kuwa ne APU. ");
INSERT INTO isd_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","Siyaán mu pe ya tebol se daya ar-aruminta na, se ya kandelero se daya ar-aruminta na, ay se ya annìdúgán ka insensu, ");
INSERT INTO isd_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","se ya annìdúgán ka pagbasu nga áyam se daya ar-aruminta na, ay se ya abay besin se ya síkil na. ");
INSERT INTO isd_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ikísi muda, ta senu magbalin da ka kapàgán ke APU. Ay ngámin daya melìlet kadayán, ay magbalin da pe ka napatag. ");
INSERT INTO isd_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Ipuwan mu pe ye Aaron se daya pútupútut na ka angngikísim kaggída, ta senu magsurbi da kiyà nga pappádi ku. ");
INSERT INTO isd_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Ay kagiyám kadaya iIsrael nga nán mu kaggída, ‘Tu idi nga denu ya isiyasiyà ku kadaya napatag ga mepakin-kuwa ke APU ki peyapeyang ngin ka panda.’ ");
INSERT INTO isd_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Kannaw usaran idi nga ikilapu ki baggi tul-tolay yala. Ay kannaw pe ya mangwa ki páda na. Napatag ke APU idi, ay ipatag nu pe. ");
INSERT INTO isd_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ay nu atán manlad mangwa kídi nga denu onu magusár ki panda ngala nga tolay, ay mebíláng yán ka agtangeli kadakayu.” ");
INSERT INTO isd_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Ay nán pikam ne APU kitu Moses, “Mangalà ka kadaya nabangug nga bang-bangug nga istakte, onitsa, galbanum, se napabeg insensu. Sangapáda ya kaadu naya isa isa kadayán. ");
INSERT INTO isd_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Paglilibúgán mu dayán ki angwa mu ka insensu, ummán kiya angwa naya maragkuwa ka talibangug. Asinán mu pe, ay áwan mu ikibu-kibug gin. Napatag idi ke APU. ");
INSERT INTO isd_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Ay se ka mangalà kiyán ka pulbúsan mu, ay se mu la ippáy kiya nekeppayán naya nesúrát ta bil-bílin kiya tabernákulu nga angngamomanán ku kikaw. Ay ibíláng mu yán ka kapà-pàgán kikaw. ");
INSERT INTO isd_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Akkan ka mangwa ka insensu nga ummán kadayán daya kibukibug na ka para usár nu. Ibíláng nu nga napatag ga kuw-kuwa kampela ne APU yán na insensu. ");
INSERT INTO isd_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ay nu atán manlad mangwa ka ummán kiyán ka talibangug na, ay mebíláng agtangeli kadakayu.” ");
INSERT INTO isd_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Ay se la manin nán ne APU kitu Moses, ");
INSERT INTO isd_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Piníli ku nge Bezalel nga an-anà ne Uri nga an-anà ne Hur nga netangámalán ke Juda. ");
INSERT INTO isd_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Inalubuwán ku ka Ispiritu nga gayát kiyà. Niddán ku pe ka kababalin na, se laing na, se ya sírib na nga mangammu kadaya nagbal-baláki nga ubra, ");
INSERT INTO isd_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ta senu aggína ya mangwa kadaya nagánas nga kàwaán daya balitù, silber se bága. ");
INSERT INTO isd_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Ay aggína pe ya magkallut kadaya napatag nga batu nga dekorasyon bádu, se káyu, se daya duddúma pikam ma nagánas nga pamàyanán kadayán. ");
INSERT INTO isd_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ay akkan nala yán ta piníli ku pe ye Oholiab nga an-anà ne Ahisamak nga netangámalán ke Dan ka kaseng na. Ay niddán ku pikam pe ka kababalin daya ngámin na nalaing nga tolay, ta senu màwa da ngámin daya ipàwà kikaw nga ummán kadaya ");
INSERT INTO isd_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","tabernákulu, ya arko nga kippayán naya nekesurátán daya bil-bílin, se ya takkab na, nga ittu ya akim-imallàán ke APU, se daya ngámin na ar-aruminta naya tabernákulu, ");
INSERT INTO isd_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ay se iya tebol, se daya ar-aruminta na, se iya kandelero nga pabeg balitù, se daya ar-aruminta na, se iya annìdúgán ka insensu, ");
INSERT INTO isd_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","se ya annìdúgán ka pagbasu nga áyam, se daya ngámin na ar-aruminta na, se iya abay besin se ya síkil na. ");
INSERT INTO isd_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Aggída pe ya mangwa kadaya bur-burda daya napatag nga ar-aruwátan ne Aaron kiya kinapádi na se daya ar-aruwátan daya pútupútut na kiya agsurbi da kiyà ka pappádi ku. ");
INSERT INTO isd_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Aggída pe daya mangwa kiya denu nga ikkiípu, se ya nabangug nga insensu nga para kiya napatag nga kuwartu. Kuwaan da ngámin dayán nga ummán kadatu nebil-bílin ku kikaw.” ");
INSERT INTO isd_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Ay nán manin ne APU kitu Moses, ");
INSERT INTO isd_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Ikaw mismu ya mangikagi kadedi kadaya iIsrael: ‘Ipatag nu ya algaw wa panaggiimáng. Ata ittu idi ya pakammuwán tada se daya gakagaka nu ka panda, nga iyà nga APU, ay piníli takayu ka tolay ku. ");
INSERT INTO isd_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","15","Ipatag nu ya algaw wa aggiimáng ta nepadúma yán na algaw kadakayu. Kiya annam ngalgaw, ay magubra kayu. Ngamay kiya mekapittu nga algaw, ay napatag yán na algaw ke APU. Ay ittu ya panaggiimáng nu tutu wala. Ay ya tolay ya mangirupat kiyán na algaw se magubra, ay akkan nin mebíláng nga tolay ku, ay se masápul matay pe. ");
INSERT INTO isd_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Díkod masápul ipatag ngámin daya iIsrael ya algaw wa aggiimáng. Ngilínan da yán na algaw se daya gakagaka da. Masápul ikurug da yán ka panda. ");
INSERT INTO isd_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ittu yán ya pakammuwán da ka áwan panda, nga iyà ya APU da se aggída daya tolay ku, nga ki unag naya annam ngalgaw, kinuwa ne APU ya lángit se iya kalawagán. Ay se la nagimáng kiya mekapittu nga algaw, ay díkod nemangán.’” ");
INSERT INTO isd_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ay kane mabalin mangamomán ne Apu Dios kitu Moses kitu bantay Sinai, ay nidde na kaggína tu duwa pánid nga batu nga nekesurátán datu bil-bílin na nga e Dios mismu ya nagisúrát. ");
INSERT INTO isd_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Ay kane nàtorán datu tolay kitu Moses, ta nabayág gin, ay akkan pikam nanagut kitu bantay, ay linìmut da nge Aaron se da nán kaggína, “Ara, pangwa nakami yin ka diyos mi nga ittu ya mangiapu kadakami. Ata akkan mi am-ammu nu nágan naya napà-pàyanán naya Moses kiyán na nangitálaw kadakami ka Egipto,” nán da. ");
INSERT INTO isd_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ay tútu nán tu Aaron kaggída, “Alà nu lugud daya balitù a tatalobang daya at-attáwa nu se, se daya annánà nu, ta ilbetán nuda kiyà,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ay díkod nippàán datu tolay datu balitù a tatalobang da se da nilbet ke Aaron. ");
INSERT INTO isd_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Inalà ne Aaron datun na balitù, ay se la nangwa ka urma, ay se la nangwa ka sinan bak-báka. Ay se nán datu tolay, “Tu idi ya diyos nu nga iIsrael nga nangitálaw kadakayu ka Egipto,” nán da. ");
INSERT INTO isd_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ay kane masingan ne Aaron ya màwa, ay nangwa ka annìdúgán ka pagbasu da. Ay se na la kinagi kadatu tolay, “Kaláwa, ay ittu ya panaggan-gánas tada para ke APU,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Ay kane láwa na, ay nagabi da nga ginumniya. Ay se dala nga nagbasu, ay sinìdug da tu pinagbasu da. Ay nagbasu da pe ka akikappiya da. Ay nagkakán se naggiínum datu tolay, ay se da naggiinglaw. ");
INSERT INTO isd_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Ay nán ne APU kitu Moses, “Ara ngin, magkaru ka managut! Ta daya tolay mu nga netálaw mu ka Egipto, ay nadakè ya kuk-kuwaan da ngin. ");
INSERT INTO isd_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Nagkaru da naglikud din kadatu nebil-bílin ku kaggída. Nangwa da ka sinan bak-báka nga ittu ya day-dayáwan da ngin. Ay ittu pe yin ya pagbasuwán da. Ay nán da kadaya tolay, ‘Dakayu wa iIsrael, tu idi yin ya diyos nu nga nangitálaw kadakayu ka Egipto!’ nán da,” nán ne APU. ");
INSERT INTO isd_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ay nán manin ne APU kitu Moses, “Nammuwán ku win ya katutolay dedi ya tolay. Inagsúkir da! ");
INSERT INTO isd_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ay díkod, bay-án nà la ngin, ta senu mepassingan ku tutu wala kaggída ya rungat ku, ta rapúnan kuda. Ay se taka la pagbalinan ka pungut daya adu tutu wala nga tolay.” ");
INSERT INTO isd_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Ngamay nakim-imallà e Moses ke APU nga Dios na nga nán na, “APU, taanna, tura mu pe lùsawan tutu wala daya tolay mu nga netálaw mu ka Egipto? Netálaw muda gapu ki áwan panda nga kinaturáy mu se ya ammanakabalin mu. ");
INSERT INTO isd_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ay nágan pe naya kagiyan daya iEgipto? Di da nán nga, ‘Nadakè kammala ya panggap na nga nangitálaw kaggída. Talipatayán nada kammala ngin nin kadaya ban-bantay. Paawanan nada ngin kídi ya kalawagán,’ di da nán? Akkan ka din nin na makarungat kaggída. Ay appoliyan mu din nin ya lammat mu. Akkan mu din na itúluy ya ammatay mu kadaya tolay mu. ");
INSERT INTO isd_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Damdamman mu la ngin agpà, APU, ya nekar-karim kade Abraham, Isaac se Israel nga bobonan mu. Nesip-sipata mu tu nangngagim kaggída ka, ‘Paaduwan ku tutu wala daya gakagaka nu nga ummán kiya kaadu daya bittuwan. Ay ya lusà nga nekarì kadakayu, ay ittu ya tawídan daya gakagaka nu ka áwan panda,’ nán mu mà,” nán tu Moses. ");
INSERT INTO isd_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ay díkod impoli kurug ne APU tu palánu na nga mamatay kadatu tolay na. ");
INSERT INTO isd_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Ay tútu nanagut tu Moses sin kitu bantay. Agtu na datu duwa pánid nga batu nga nekesurátan datu bil-bílin. Nasurátan da ki magpíngit. ");
INSERT INTO isd_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","E APU ya nangwa kadatu duwa pánid nga batu, ay aggína mismu pe ya nagsúrát kadatun nga nemarka na. ");
INSERT INTO isd_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Ay kane magìna natu Josua tu págat datu tolay ya makas-asáraw, ay nán na kitu Moses, “Maggugubát da ki kampu, ta tura napágat,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ngamay nán natu Moses, “Akkan na páuy daya nangábà yán, onu agmanakit daya naábà. Págat daya magguudma ya magìna ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Ay kane makaadanni kurug tu Moses kitu kampu da, ay nasingan na tu sinan bak-báka se itu agsasála da. Ay nakarungat tutu wala. Ay tútu nebàbà na datu duwa pánid da batu kitu pungut natu bantay. Ay díkod narupà da. ");
INSERT INTO isd_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ay se na inalà tu sinan bak-báka nga kinuwa da, ay se na sinìdug, se na màmàan, ay se na nga nekibug kitu danum, se na nepenum kadatu iIsrael. ");
INSERT INTO isd_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Ay nán tu Moses kitu Aaron, “Pinaannán da ka pe dedi tolay ta, ta tura ka nangwa ka nakabasúlán da ka abay tutu wala?” nán na. ");
INSERT INTO isd_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Ay nán tu Aaron, “Akkan nà din lùsawan tutu wala, ápu, ta ammum mà nga nadakè kammala ya as-asikkuwaan dedi nga tolay. ");
INSERT INTO isd_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Nán da kiyà nga, ‘Pangwa nakami ka diyos mi, nga ittu ya mangiapu kadakami. Ay nu itu Moses nga nangitálaw kadakami ka Egipto, ay akkan mi ammu ya napà-pàyanán na ngin,’ nán da. ");
INSERT INTO isd_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Díkod nán ku kaggída, ‘Ngámin kayu nga atán tatalobang nga balitù, ay idde nuda kiyà’ nán ku. Ay nilbetán da kurug da kiyà. Ay linúnág ku pe yin, ay tu idi nga sinan bak-báka ya nagbalinán na,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Ay kane masingan tu Moses nga kuk-kuwaan datu tolay yin datu piyán da kampela ngin nin (ta binaybay-án tu Aaron da ngala ngin, ay tútu ag-agbán datu kalínga da da), ");
INSERT INTO isd_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ay nagsíkád kitu ruwángan natu kampu da, ay se na nán kaggída, “Iinda daya pumane ke APU? Umbet kayu ngámin kídi!” nán na. Ay ngámin datu pútupútut tu Levi nga lalláki, ay inumbet da kitu giyán na. ");
INSERT INTO isd_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ay nán na kaggída, “Tu idi ya nán ne APU nga Dios daya iIsrael, ‘Magtagiampiláng kayu ngámin. Ay mawe kayu kiya ngámin giyán kiya unag naya kampu ta patayan nu daya tolay, oray wagi nu, onu opun nu, onu karúba nu,’ nán na,” nán tu Moses. ");
INSERT INTO isd_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Ay kinuwa kurug datu pútupútut tu Levi tu ipàwa tu Moses. Ay kitun na algaw, ay moli tallu ríbu wa tolay tu pinatay da. ");
INSERT INTO isd_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Ay nán tu Moses kaggída, “Kídi nga algaw, ay naintuúdan ya agsurbi nu ke APU. Gapu ta akkan nu kinengán ya an-anà nu, onu wagi nu, ay nagun-ud nu ya ammatag ne APU kadakayu,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ay kane láwa na, ay nán tu Moses kadatu tolay, “Nakabásul kayu kurug ka abay pànang. Ngamay mawe yà manùdu kammin kitu giyán APU, ta get mekáru ku ya básul nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Ay díkod nagulli kammin tu Moses ke APU ay se na nán, “Nakabásul kurug dedi nga tolay ka abay pànang nga básul. Nangwa da ka sinan diy-diyos da nga balitù. ");
INSERT INTO isd_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ngamay pakawanan muda kuma, APU, kiya básul da. Ngamay nu akkan, ay ippà nà pe yin kiya libru wa nangisurátan mu kiya ngag-ngágan daya tolay mu.” ");
INSERT INTO isd_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ngamay nán ne APU kitu Moses, “Ngámin daya nakabásul kiyà, ay ittu dayán daya mippà kiya libru ku. ");
INSERT INTO isd_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ngamay mawe ka ngin. Iapu muda nga mawe kitu giyán na kinagì kikaw. Ipakammù kikaw nga maginunna ya anghel ku. Ngamay nu umbet ya oras nga ammánis ku kadaya nakabásul, ay panísan kuda kiya nagbasúlán da,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ay se la nga niddán ne Dios datu tolay ka sinakit da, gapu kitu inangwa da ka sinan bak-báka, nga kinuwa kam tu Aaron. ");
INSERT INTO isd_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Ay nán ne APU kitu Moses, “Mawe ka ngin. Magtálaw kayu win kídi nga giyán. Alà mu daya tolay nga netálaw mu ka íli Egipto, ay se kayu la nga mawe kitu lusà a nesip-sipatà kitu Abraham se kitu Isaac se kitu Jacob kane kagiyan ku kaggída ya, ‘Kadaya gakagaka mu ya pangiddanán ku kiyán,’ nán ku. ");
INSERT INTO isd_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Atán anghel la paginunnaan ku kadakayu. Pataláwan ku daya Cananeo, daya Amorreo, daya Heteo, daya Perizeo, daya Heveo, se daya Jebuseo. ");
INSERT INTO isd_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Mawe kayu kiya lusà a nadam-ag tutu wala nga lusà. Ngamay akkan nà a mebulun kadakayu, ta get ta la nu rapúnan takayu kiya ammeyag nu. Ata nasúkir kayu wa tolay,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Ay kane magìna datu tolay datun na natakit nga úni, nagpannakit da. Ay áwan kaggída tu nagarítus gapu kitu pannakit da. ");
INSERT INTO isd_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Ata kinagi ne APU kitu Moses nga, “Kagiyan mu kadaya iIsrael nga, ‘Nasúkir kayu wa tolay. Ay oray nu makaru wala ya kebulun ku kadakayu nga mawe, ay rapúnan takayu. Ay díkod ippà nu daya ar-arítus nu, ay se ku la sinnan nu nágan naya pamàyanán ku kadakayu,’ nán mu,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Ay díkod, nippaán ngámin datu iIsrael datu ar-arítus da kitu nagrubbuwát da kitu Bantay Horeb ka panda. ");
INSERT INTO isd_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Ay tu Moses, ay alà na peyang pe tu báwi, ay se na ipasíkád kiya lasi naya kampu da. Ippáy na kiya ad-adayyu kiya kampu da. Nepangágan na idi nga báwi ka agtammuwán. Ay ngámin daya atán saludsud ke APU, ay mawe da kitu báwi nga agtammuwán nga atán kitu lasi natu kampu da. ");
INSERT INTO isd_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Ki peyang nga ipappan tu Moses kitu báwi, ay magsíkád ngámin datu tolay kitu gagyangán datu bawi-báwi da. Ay sisinnán da tu Moses panda kitu aggunag na ngin kitu báwi. ");
INSERT INTO isd_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ay nu atán tu Moses sin kitu unag, ay tu sidaddu nga angap, ay maganìgad pe yin, ay se la magyán kitu gagyangán natu báwi. Ay se la makiamomán ne APU kitu Moses. ");
INSERT INTO isd_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Ay nu masingan datu tolay tu ummán ka adígi nga angap kitu gagyangán natu báwi, ay magùmà da ngámin nga magdáyaw wala kitu gagyangán datu báwi-báwi da. ");
INSERT INTO isd_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Ay ya akiamomán ne APU kitu Moses, ay magàráng da nga ummán kiya aggamomán daya magkopun. Ay se la nga magulli ye Moses kitu kampu da. Ngamay tu Josua nga kaseng tu Moses, nga nabagu nga pútut tu Nun, ay magbansi kitu báwi. ");
INSERT INTO isd_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Ay nán tu Moses ke APU, “Nán mu mà kiyà nga ‘Alà mu dedi nga tolay’ ngamay akkan mu pikam kinagi kiyà nu inna ya ipàrob mu wa kabulun ku. Ay nán mu pe kiyà nga, ‘Ammu taka pànang, se pàgan taka.’ ");
INSERT INTO isd_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ay nu kurug ga napatag gà kikaw, ay ipakammu mu mán lugud kiyà daya palánu mu, ta senu mammuwán taka, ay senu pà-pàgan nà. Ay lam-lamtam pe nga dedi nga tolay, ay tolay muda,” nán tu Moses. ");
INSERT INTO isd_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ay nán ne APU, “Abul-bulunan taka, ay se kapiyánan ku ya ur-uray mu pe,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Ay nán tu Moses, “Nu akkan ka nga mebulun kiyà, ay akkan nakami agpà itálaw kanedi. ");
INSERT INTO isd_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Ata paanna pe ya akammu mi nga pàgan nakami se daya tolay mu nu akkan nakami bulunan? Nu bulunan nakami, ay mepasabáli kami se daya tolay mu kadaya duddúma nga tolay kídi nga kalawagán,” nán tu Moses. ");
INSERT INTO isd_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ay nán ne APU kitu Moses, “Ay ngámin daya agngan mu, ay màwa da, ta pàgan taka, ay se nepadúma taka,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Ay nán pikam tu Moses, “Ipassingan mu mán agpà ya kinadáyaw mu,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ay nán ne APU, “Ipassingan ku tutu wala ya kinapiya ku, ay se kagiyan ku ya ngágan nga ‘Nge APU’. Induan ku kampela ngin nin daya piyán ku induan, ay kalakkán ku kampela ngin nin daya piyán ku kalakkán. ");
INSERT INTO isd_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ngamay akkan mu masingan ya murang ku, áta áwan tolay ya magbiyág nu masingan na ya murang ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Ay nán pikam ne APU, “Sinnam kod ya pínát kiya giyán na adanni kiyà. Magsíkád ka kiyán. ");
INSERT INTO isd_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ay kiya ilillíwán naya diláng ku, ay ipalidang taka kiya gangngár naya pínát, ay se taka tàbán ki ímà panda ki akalíwán ku win. ");
INSERT INTO isd_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Ay se ku la nga ippà ya ímà, ay masingan mu ya addag ku, ngamay akkan mu masingan ya murang ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Ay nán ne APU kitu Moses, “Magkallut ka ka duwa pánid nga batu nga ummán kadatu nunna, ay se ku manin isúrát datu nesur-súrát ku kadatu nunna nga rinupà mu. ");
INSERT INTO isd_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Magsagána ka ngin kaláwa. Manùdu ka ka bantay Sinai nu pagmakát, ay se kala magpassingan kiyà kitu útun tu bantay. ");
INSERT INTO isd_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Awan mu kabulun na manùdu. Ay se áwan umbet kiya oray ka wàna nga giyán kiya bantay. Ay áwan pe nga karneru onu báka nga magárab kiya adanni kiya bantay,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Díkod nagkallut ka duwa pánid nga batu nga ummán kadatu nunna, ay se la nga sumápa nga ginumniya, se la nawe nanùdu kitu Bantay Sinai nga ummán kitu nebílin ne APU kaggína. Agtu na datu duwa pánid nga batu. ");
INSERT INTO isd_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Ay naganìgad nge APU ki angap, ay se yala nepagsisíkád kaggína kitúni, ay se na la kinagi ya, “Nge APU.” ");
INSERT INTO isd_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Lumíwán ne APU kitu àráng na nga nán na, “Nge APU, nge APU, Dios nga maragkallà se namáru, se nasulit malùsaw, ay se maraminya tutu wala se akkan mauli-ulis ya amminya na, ay se mapiyár peyapeyang. ");
INSERT INTO isd_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Akkan mauli-ulis, se áwan panda naya aminya na kadaya tolay na. Pakawanan na daya kinadakè se daya bas-básul se ya kinasuwáy da tolay. Ngamay akkan na piddudoray daya nakabásul. Nu di na lugud da ipanùnut ya básul da kadaya annánà da se kadaya annánà daya annánà da panda kiya mekàlu se mekappát ta paganakán.” ");
INSERT INTO isd_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Ay dágus sala nga nagukkab kitu lusà tu Moses nga nagdáyaw. ");
INSERT INTO isd_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ay nán na, “Ay nu pàgan nà kam APU, ay bulunan nakami mán, Apu. Oray nasúkir daya tolay, ay pakawanan nakami agpà kiya kinadakè mi se daya bas-básul mi. Ay se alà nakami ka kuw-kuwa mu nga tolay mu,” nán tu Moses. ");
INSERT INTO isd_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ay nán ne APU, “Makiturátu wà lugud kadakayu. Mangipassingan nà kadaya tolay mu kadaya nakas-kasdáaw wa mas-asingan na áwan pikam nangipassingan oray ka wàna nga giyán kídi ya kalawagán. Ay ngámin daya tolay kiya pag-agyanán nu, ay masingan da ya mà-màwa ne APU. Ata nakas-kasdáaw pànang ya kuwaan ku ki pagmar-marngán nu.” ");
INSERT INTO isd_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","“Kuwaan nu daya nebílin ku kadakayu kídi. Sinnan nu ta pataláwan ku daya Amorreo, daya Cananeo, daya Heteo, daya Perizeo, daya Heveo, se daya Jebuseo. ");
INSERT INTO isd_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Taronan nu ta akkan kayu wa makitur-turátu kadaya tolay kiya kapannán nu wa íli, ta ittu yán ya magbalin ka kàrung kadakayu. ");
INSERT INTO isd_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Dadàlan nu daya annìdúgán da ka pagbasu da, se daya day-dayáwan da nga pin-pínát. Ìlangngán nu pe daya ad-adígi natu diy-diyos da nga Aserim. ");
INSERT INTO isd_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Akkan kayu magdáyaw kadaya sab-sabáli nga diy-diyos, áta nge APU nga nagngágan pe ka Abugu, ay naabugu nga Dios. ");
INSERT INTO isd_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Akkan kayu wa makitur-turátu kadaya tolay kiya kapannán nu nga íli, áta nu magday-dáyaw da kadaya sinan diy-diyos da se da magbasu pe kadayán, ay atán nala nga atán ya magayáb kadakayu, ay se kayu pe yin na mepangán kadaya pinagbasu da. ");
INSERT INTO isd_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Ay ya pagang-angayán na, ay iatáwa nu win daya babbágu nu kadaya babbalásang da. Ay daya annánà da nga magday-dáyaw kadaya sinan diy-diyos da, ay pilítan da pe yin daya annánà nu nga mepagday-dáyaw kadayán na sinan diy-diyos da. ");
INSERT INTO isd_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Akkan kayu nga mangurma kadaya sinan diy-diyos. ");
INSERT INTO isd_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Akkan nu kaligpanán ya piyasta nga pinagkakán nu ka sinápay nga áwan pamalbád ki algaw nga nìdang ku nga búlán naya Abib. Ata kitu búlán Abib tu netattálaw nu ka Egipto. Pittu algaw ya angngán nu ka sinápay ya áwan pamalbád. ");
INSERT INTO isd_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Ay ngámin daya manákam ma annánà a lalláki, ay kuw-kuwa ku da. Ay páda na pe kadaya áyam nu nga báka se daya karneru. Kuw-kuwa ku pe daya mun-unna nga toru da. ");
INSERT INTO isd_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Ay ya munna nga toru daya asnu nu, ay sukatán nu ka urbun karneru. Ay nu akkan nu masukatán, ay ritúan nu ya bùlaw na. Ngámin daya annánà nu nga lalláki, ay masápul la sakaan nuda pe. Awan magpassingan kiyà nga áwan id-idde. ");
INSERT INTO isd_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Annam ngalgaw ya aggubra nu. May kiya mekapittu ngalgaw, ay masápul magimáng kayu. Oray kiya tiyampu na panaggarádu onu panaggáni, ay masápul magimáng kayu. ");
INSERT INTO isd_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Silibráran nu pe ya piyasta daya lig-liggu, se ya piyasta naya munna nga kabuyág daya trígo, se iya piyasta naya muddi nga aggáni nu kiya panggibúsán naya dagun. ");
INSERT INTO isd_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Ay ngámin daya lalláki kadakayu, ay mamìlu da ki káda dagun na magpassingan ke APU wa Dios nga Dios daya iIsrael. ");
INSERT INTO isd_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Pataláwan ku daya tul-tolay kiya kapannán nu, ay se ku paabayyan ya pamandanán naya lusà nu. Ay áwan pe ya umsil kiya lusà nu nu mamìlu kayu ki káda dagun na mawe magpassingan ke APU nga Dios nu. ");
INSERT INTO isd_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Akkan kayu mangidátun kiya dága naya pinagbasu nu kiyà nu nakibugán ka pamalbád. Ay áwan nu ibunna panda ki pagmakát kiya pinagbasu nu ki piyasta naya nanglàtaw ku kadakayu. ");
INSERT INTO isd_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Ay ilbet nu pe kiya balay ne APU nga Dios nu daya kapíyán na munna nga ápit nu. Ay akkan kayu mangilútu ka karni urbun kalding kiya gattà naya ina na,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Ay nán pikam ne APU kitu Moses, “Isúrát mu dedi nga úni, áta nakiturátu wà kikaw se kadaya iIsrael kadedi nga un-úni,” nán na. ");
INSERT INTO isd_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Nebul-bulun tu Moses kitúni ke APU ka appát púlu ngalgaw se appát púlu nga gabi. Ay akkan nangán onu umminum kadatun na al-algaw. Ay nesúrát na ki dalumpenág ga batu datu bil-bílin nga ittu datu sangapúlu wa bil-bílin. ");
INSERT INTO isd_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Ay se la nanagut tu Moses kitu Bantay Sinai. Ay kaggína managut nga sikkaagtu kadatu duwa pánid da batu nga nekesurátán datu bil-bílin, ay akkan na am-ammu nga dumiláng tu murang na, áta nakibàbànán ke Dios. ");
INSERT INTO isd_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Ay kane masingan tu Aaron se datu iIsrael tu Moses, ay dumiláng tu murang na. Ay magansing da nga umadanni kaggína. ");
INSERT INTO isd_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ngamay kirrawán tu Moses da. Ay tútu inumbet tu Aaron se datu pangapuwan datu tolay, ay se da nga nakibàbànán kaggína. ");
INSERT INTO isd_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Ay kane din kuwa, ay ngámin datu iIsrael, ay umadanni da ngin kaggína. Ay nebílin na ngin kaggída ngámin datu nekagiyán ne APU kaggína kitu Bantay Sinai. ");
INSERT INTO isd_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Ay kane mabalin magúni, ay nagladdung. ");
INSERT INTO isd_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ngamay ki káda ipappan na nga makibàbànán ke APU, ay ippà na tu laddung na panda kiya ilallawán na. Ay nu kagiyan na ngin kadatu iIsrael datu nebílin ne APU kaggína, ");
INSERT INTO isd_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ay masingan datu iIsrael tu murang tu Moses nga dumiláng. Ay díkod magladdung manin panda kitu akiamomán na manin ke APU. ");
INSERT INTO isd_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Ay se la inurnung tu Moses ngámin datu iIsrael, ay se na la nán kaggída, “Tu dedi daya bil-bílin ne APU nga pasúrut na kadakayu: ");
INSERT INTO isd_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Annam ngalgaw ya angwa nu kadaya ub-ubra nu. Ngamay kiya mekapittu nga algaw, ay magimáng kayu tutu wala ta napatag yán na algaw ke APU. Ay oray nu iinna ya magubra kiyán na algaw, ay masápul matay. ");
INSERT INTO isd_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Awan ya magapuy kadaya pag-agyanán nu kiya mekapittu nga algaw.” ");
INSERT INTO isd_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Ay nán tu Moses kadatu ngámin na iIsrael, “Tu idi ya nebílin ne APU: ");
INSERT INTO isd_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Mangidde kayu ka dátun nu ke APU. Dakayu wa naparon mangidde kayu ke APU kadaya balitù, silber, se bága ");
INSERT INTO isd_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","se daya mannáw se báyolet, se daya dag-daggáng nga binola, ay se daya napiya nga dilána, se daya dùdut kalding, ");
INSERT INTO isd_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","se daya lálat toru wa karneru, se daya napiya nga lálat báka, ay se ya tarikáyu nga akasiya. ");
INSERT INTO isd_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","Mangidde kayu pe ka denu wa para ki dílág, se daya talibangug para ki denu wa ikkiípu se panalibangug ki insensu. ");
INSERT INTO isd_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Mangidde kayu pe kadaya batu nga oniko se daya napatag ga batu nga mippáy ki efod se ki annáp gútù. ");
INSERT INTO isd_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Ay daya atán paglaingán kadakayu, ay umbet da ta aggída ya mangwa kadaya ngámin na ipàwa ne APU, ummán kiya tabernákulu ");
INSERT INTO isd_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","se iya báwi na, se ya taddung na. Mangwa da pe ka sagpit se daya dabbi na, daya takkan na káyu, se daya adígi, se daya pagsiínán kadaya dab-dabbi na. ");
INSERT INTO isd_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Kuwaan da pe ya arko se daya takkan na, se ya akim-imallàán ke APU nga ittu ya takkab na. Kuwaan da pe ya kurtína nga panglipad. ");
INSERT INTO isd_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Mangwa da pe ka tebol se daya ibbubúlig na, se daya ar-aruminta na. Mangwa da pe ka sinápay ya medátun ke APU. ");
INSERT INTO isd_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Kuwaan da pe ya kandelero nga para kadaya dílág se daya ar-aruminta na, se daya pingki na. Ay masápul pe ya denu para ki dílág. ");
INSERT INTO isd_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Mangwa da pe ka annìdúgán ka insensu se daya pagbúlig nga takkan na káyu. Mangwa da pe ka denu nga ikkiípu, se daya nabangug nga insensu. Mangwa da pe ka kurtína para kiya ruwángan naya tabernákulu. ");
INSERT INTO isd_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Kuwaan da pe ya annìdúgán ka pagbasu nga áyam, se ya issaságat na nga bága, se daya ibbubúlig na nga takkan na káyu, se daya ar-aruminta na. Màwa pe ya abay besin se ya síkil na. ");
INSERT INTO isd_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Ay màwa pe daya kurtína nga pinangkaabut naya amuwág se daya ad-adígi na, se daya pagsiínán da, se daya kurtína naya gagyangán na. ");
INSERT INTO isd_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Màwa pe daya pat-pátù naya tabernákulu se daya pat-pátù naya amuwág na se daya lúbi-lúbid da. ");
INSERT INTO isd_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Ay màwa pe daya napiya nga ikkaaruwát ne Aaron na pádi kiya aggubra na kiya napatag nga kuwartu, se daya ikkaaruwát daya pútupútut na kiya agsurbi da kiya kinapádi da.” ");
INSERT INTO isd_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Ay kane magìna ngámin datu iIsrael datun, ay pinanáwan da tu Moses. ");
INSERT INTO isd_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Ay se la inumbet manin ngámin datu maganggam mangidde se datu nalagpat ta uray. Nilbetán da ngin datu dátun da ke APU para kitu tabernákulu, se ngámin datu ar-aruminta nga masápul na, se ngámin na mausár kadatu napatag ga ikkaaruwát datu pappádi. ");
INSERT INTO isd_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Inumbet ngámin datu nalagpat, babbay se lalláki. Nilbetán da datu nagbal-baláki nga ikkaarmat ta balitù ummán kadaya meispili ki gútù, tatalobang, sangkilat, pulseras, bísin, sipattal, se daya duddúma pikam. Nangilbet tu isa isa kaggída ka dátun na ke APU. ");
INSERT INTO isd_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Ay ngámin datu atán binola nga mannáw, onu bayolet, onu dag-daggáng onu napiya nga dilána onu dùdut kalding onu lálat toru wa karneru onu napiya lálat báka, ay nilbetán datu noray atán kaggída. ");
INSERT INTO isd_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Ay datu ngámin atán midde nga silber se bága, ay nilbetán da nga nedátun ke APU datu noray atán kaggída. Ay datu atán akasiya nga tarikáyu nga mausár kiya ubraan da, ay nilbetán dada pe. ");
INSERT INTO isd_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ay datu babbay ya nalaing mangwa ka binola, ay nilbetán da datu kinuwa da nga mannáw se bayolet se dag-daggáng nga binola se datu napiya nga dilána. ");
INSERT INTO isd_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ngámin datu babbay nga nalaing mangwa ka binola nga nalagpat, ay naganggam da pe yala nga nangwa ka binola nga dùdut kalding. ");
INSERT INTO isd_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Ay datu pangmanàman da, ay nagilbet da kadatu batu wa oniko, se daya napatag ga batu nga mippáy kitu efod se kitu annáp gútù. ");
INSERT INTO isd_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Nangilbet da pe kadatu talibangug se denu para kadatu dílág se denu nga ikkiípu, se datu talibangug ga para ki insensu. ");
INSERT INTO isd_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Ay ngámin datu iIsrael, babbay se lalláki, nga maminya mangilbet kadatu masap-sápul kadatu ubra nga nebílin ne APU kitu Moses nga kuwaan na, ay sikkaanggam da nangilbet kadatu dátun da ke APU. ");
INSERT INTO isd_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Ay se la nán tu Moses kadatu iIsrael, “Piníli ne APU nge Bezalel nga pútut ne Uri nga pútut tu Hur nga isa kadaya tangámalán tu Juda. ");
INSERT INTO isd_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Ay se na nga alubuwán kiya Ispiritu nga gayát kaggína. Niddán na ka am-ammu na, se paglaingán na, se ya kinasírib na nga mangwa kadaya ngámin baláki naya nagánas nga ubra. ");
INSERT INTO isd_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Aggína ya mamalabúga kadaya nagánas nga disayn, ay se aggína pe ya makammu mangiubra kadayán kadaya balitù se silber se bága. ");
INSERT INTO isd_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Aggína pe ya magkallut kadatu mekapat nga bat-batu, se magabur-búrì kadaya káyu, ay ammu na daya nagbal-baláki nga nagánas nga ub-ubra. ");
INSERT INTO isd_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Ay niddán pe ne APU ka kabailán na nga magtùgud, aggída se Oholiab, nga pútut ne Ahisamak nga isa kadaya tangámalán tu Dan, ta senu tùgúdán da daya duddúma. ");
INSERT INTO isd_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Niddán nada ka laing da nga mangwa kadaya ngámin baláki nga ubra naya magabur-búrì onu daya maragkuwa ka dikurasyon onu daya maragburda kadaya mannáw, bayolet se dag-daggáng nga binola se daya napiya nga dilána, onu daya maraggabal. Ammu da ya ngámin baláki naya magabur-búrì se angwa ki dikurasyon.” ");
INSERT INTO isd_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“De Bezalel se Oholiab se daya ngámin atán paglaingán nga niddán ne APU ka ammu se pannakaáwat mepanggap kadaya ngámin ubra ki angwa da kiya tabernákulu, ay aggída ya mangwa se manúrut kadaya ngámin na ubra nga nebílin ne APU.” ");
INSERT INTO isd_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Ay se la kirrawán tu Moses de Bezalel se Oholiab se datu ngámin na niddán ne APU ka paglaingán da, se datu ngámin malagpat mepagubra. ");
INSERT INTO isd_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Ay se la nga idde tu Moses kaggída ngámin datu dátun datu ngámin iIsrael nga nilbetán da nga mausár para kitu tabernákulu. Ay adu pikam ya ilbetán datu tolay kitu Moses nga dátun da ki káda pagmakát. ");
INSERT INTO isd_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Ay díkod inumbet kitu Moses ngámin datu magub-ubra kadatu ngámin baláki ubra kitu tabernákulu, ");
INSERT INTO isd_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ay se da nán kitu Moses, “Adu pikam ya ilbetán daya tolay. Ay nasurù pànang ngin kiya kasapúlán kadaya ipàwa ne APU kadàtada,” nán da. ");
INSERT INTO isd_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Ay díkod, nepekagi tu Moses kitu kampu nga áwan tutu wala ya mangilbet tin ka dátun da para ki tabernákulu. Ay tútu nakusap pe yin datu tolay ya mangilbet ka dátun da. ");
INSERT INTO isd_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Ata nasurù pànang ngin datu nilbetán da. ");
INSERT INTO isd_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Ay datu nalaing kadatu magub-ubra, ay aggída tu nangwa kadatu sangapúlu wa tulda natu tabernákulu. Naabal da kadatu napiya nga dilána se datu binola nga mannáw se bayolet se dag-daggáng. Netangaabal da pe tu bubburda da nga kerubin. ");
INSERT INTO isd_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Ya kadaddu natu isa tulda, ay sangapúlu se duwa se gudduwa mitru. Ay ya kadakkal na, ay isa mitru se siyám púlu sentimitru. Ay sangapáda ya kadadakkal da ngámin. ");
INSERT INTO isd_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Pinagtatákip da datu limma nga tulda, ay pinagtatákip da pe datu limma pikam. ");
INSERT INTO isd_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ay pinayán da ka galáng nga binola nga mannáw tu nagkulpiyán natu tapungtu nga tulda kitu nunna nga nagtatákip. Ay páda na pe tu kinuwa da kitu mekàduwa nga nagtatákip pa tulda. ");
INSERT INTO isd_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Limma púlu galáng ya nippáy da kitu nunna nga nagtatákip, ay ummán pe kitu mekàduwa. Ay magsabat datun na gala-galáng. ");
INSERT INTO isd_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ay se da la nangwa ka limma púlu nga sagpit nga balitù nga ittu datu pinagsagpit da kane pagtakípan na datu tulda ngin. Díkod tang-tanganáyun tu tulda natu tabernákulu. ");
INSERT INTO isd_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Nangwa da pe ka tulda nga nàwa ki dùdut kalding. Ittu tu magpanin otun kitu nunna nga tulda. Nangwa da ka sangapúlu se isa. ");
INSERT INTO isd_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Ay ya kadaddu natu isa tulda, ay sangapúlu se tallu se gudduwa mitru, ay tu kalampád na, ay isa mitru se walu púlu sentimitru. Sangapáda ya kadakkal da ngámin. ");
INSERT INTO isd_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Pinagtatákip da datu limma nga tulda, ay se da pe pagtatakípan datu annam. ");
INSERT INTO isd_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Pinayán da ka limma púlu nga gala-galáng nga binola tu nagkulpiyán natu tapungtu nga tulda, se da pe payán ka limma púlu nga gala-galáng pe tu tapungtu natu isa. ");
INSERT INTO isd_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ay se da la pe nangwa ka limma púlu nga sagpit nga bága, nga ittu datu pinagsagpit da kadatu gala-galáng. Ay díkod, tang-tanganáyun datu tulda. ");
INSERT INTO isd_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ay se da la manin nangwa ka takkab natu tabernákulu nga nàwa ki lálat toru wa karneru, ay se nangwa da pe ka panin otun na takkab na nga nàwa ki lálat báka. ");
INSERT INTO isd_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Ay se da la nangwa ka akasiya nga dab-dabbi natu tabernákulu. ");
INSERT INTO isd_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Ya kadaddu da, ay appát se gudduwa mitru, ay ya kalampád da, ay pittu púlu sentimitru. ");
INSERT INTO isd_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Ya isa isa kadayán na dab-dabbi, ay atán duwa nga padíla na nga ittu ya pagtatakípán da. ");
INSERT INTO isd_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Pinakunán da ngámin datu dab-dabbi. Duwa púlu dabbi ya nippáy kitu panillod nga pásit na. ");
INSERT INTO isd_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Ay nangwa da pe ka appát púlu silber nga pagsiínán datu duwa púlu nga dabbi. Ya munna nga dabbi, ay mesàrád kiya duwa nga pagsiínán ta meruwad datu padíla na kitu abbut datu pagsiínán. Ay se la manin duwa kitu sumarunu nga dabbi ta meruwad pe datu duwa nga padíla na. ");
INSERT INTO isd_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ay se da la nangwa pe ka duwa púlu wa dab-dabbi nga mippáy kitu panidáya nga pásit natu tabernákulu, ");
INSERT INTO isd_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","se datu appát púlu nga pagsiínán nga silber. Duwa nga pagsiínán ya kippayán natu munna nga dabbi, ay se la duwa pe kitu sumarunu. ");
INSERT INTO isd_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ay se da la nangwa ka annam ma dabbi para kitu pane sirbútán na súba natu tabernákulu nga ittu tu likud na. ");
INSERT INTO isd_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Nangwa da ka duwa nga dabbi para kadatu síku na kitu panin likud. ");
INSERT INTO isd_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Pinagrewing da da panda kitu ngúdu kitu munna nga giyán galáng. Nangwa da ka duwa nga ummán kadedi para kadatu duwa nga síku. ");
INSERT INTO isd_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Díkod walu ngámin datu dabbi kitun na likud na. Ay sangapúlu se annam tu pagsiínán nga nàwa ki silber, duwa ki káda dabbi. ");
INSERT INTO isd_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Ay se da la nangwa ka takkan na káyu nga akasiya. Limma para kadatu dabbi kitu isa pásit natu tabernákulu. ");
INSERT INTO isd_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Ay limma pe nga takkan para kadatu dabbi kitu tapíngit pásit na. Ay limma pe ya para kadatu dabbi kitu likud na kitu panilattakán. ");
INSERT INTO isd_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ay tu takkan na káyu nga meruwad kitu ábà datu dabbi, ay kinuwa da nga sinnáyun. ");
INSERT INTO isd_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ay se da kinalupkopán datu dab-dabbi ka pinitpet ta balitù. Ay datu galáng nga keruwaddán datu takkan na káyu, ay nàwa da ka balitù. Ay datu takkan, ay nakalupkopán da pe ka pinitpet nga balitù. ");
INSERT INTO isd_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Ay inabal da tu kurtína kitu unag ka binola nga mannáw, bayolet, se dag-daggáng, se napiya nga dilána. Napiya ya nekaburdaan na ka kerubin. ");
INSERT INTO isd_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ay se da la nangwa ka appát adígi na nga akasiya, ay se da kinalupkopán ka pinitpet nga balitù. Ay datu sáwit na, ay nàwa da pe ka balitù. Ay se da la nagurma pe ka appát nga pagsiínán nga silber. ");
INSERT INTO isd_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Nangwa da pe ka kurtína natu lalangkán natu tabernákulu nga naabal ka binola nga mannáw, bayolet, se dilána. Ay naburdáan pe. ");
INSERT INTO isd_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Ay nangwa da pe ka limma nga adígi na nga atán sáwit na nga kerabitán natu kurtína. Kinalupkopán da datu magpungtu ka balitù, ngamay tu pagsiínán da, ay naurma ka bága. ");
INSERT INTO isd_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Ay kinuwa tu Bezalel tu arko ka kayu wa akasiya. Ya kadakkal na, ay isa mitru se sangapúlu sentimitru ya kadaddu na, ay pittu púlu sentimitru ya kadakkal na, ay se pittu púlu sentimitru pe ya kadallam na. ");
INSERT INTO isd_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Ay se na kinalupkopán ka pinitpet nga balitù ya unag na se ya lasi na. Ay se na pe pinayán ka nabúrì nga kalupkop nga balitù datu ráging na. ");
INSERT INTO isd_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Ay se yala nagurma pe ka appát nga galáng nga balitù para kadatu appát síkil na. ");
INSERT INTO isd_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Ay nangwa pe ka duwa nga takkan na káyu akasiya, ay se na pe kinalupkopán ka balitù. ");
INSERT INTO isd_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Neruwad na datun kadatu galáng kadatu síkil natu arko. Ittu dedi ya pagbulígán da kitu arko. ");
INSERT INTO isd_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Ay tu takkab na, nga ittu tu akim-imallàán ke APU, ay kinuwa na ka pabeg balitù. Ya kadaddu na, ay isa mitru se sangapúlu sentimitru, ay se ya kalampád na, ay pittu púlu sentimitru. ");
INSERT INTO isd_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Nangwa ka duwa nga sinan kerubin nga mippáy kadatu tapungtu na. Kinuwa nada ka pinitpet nga balitù. ");
INSERT INTO isd_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Isa nga kerubin kitu tapungtu, ay isa pe kitu tapungtu. Nekanáyun da kitu takkab. ");
INSERT INTO isd_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Magàráng datu kerubin na magsisíngan kitu takkab. Datu payà da, ay naùnát da nga nepanin-àráng nga magpayyung kitu takkab. ");
INSERT INTO isd_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Kinuwa tu Bezalel pe tu tebol ka káyu wa akasiya. Tu kadaddu na, ay siyám púlu sentimitru, ay tu kadakkal na, ay gudduwa mitru, ay tu kalingúdu na, ay pittu púlu sentimitru. ");
INSERT INTO isd_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Ay se na kinalupkopán ka balitù, ay se na pe pinayán ka nabúrì nga kalupkop nga balitù datu ráging na. ");
INSERT INTO isd_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Ay pinalebután na pe ka tangagakam ma ummán ka pángal nga nepalawlaw kitu otun na. Ay se na pe pinayán ka nabúrì nga kalupkop pa balitù datu ráging na. ");
INSERT INTO isd_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Ay pinangurma na pe ka appát galáng nga balitù, se nada nekabit kadatu síku na nga giyán datu síkil na. ");
INSERT INTO isd_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Nippáy nada kitu adanni kitu lebig na datun na galáng nga ittu datu pangiruwaddán na kadatu takkan na pagbúlig kitu tebol. ");
INSERT INTO isd_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Datu takkan, ay kinuwa nada pe ka akasiya, ay se nada pe nga kinalupkopán ka balitù. ");
INSERT INTO isd_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ay datu ar-aruminta nga mippáy kitu tebol, ay kinuwaán nada pe ka pabeg balitù; datu paláter, se datu gupán na para kadatu insensu. Ay ummán pe kadatu malúkung se datu pitser nga ittu datu pangialúbu kadatu mainum nga dátun. ");
INSERT INTO isd_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Kinuwa na tu kandelero ka pabeg balitù. Tu arutáng na se pungut na, ay nàwa da ka pinitpet nga balitù. Datu mal-malúkung na se datu but-bútà a dikurasyon na, se datu aken datun na but-bútà, ay nekanáyun da kitu arutáng na. ");
INSERT INTO isd_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Annam datu pas-pasanga nga nagtutúway kitu arutáng na. Tallu ya atán ki tapíngit, ay tallu pe kiya tapíngit. ");
INSERT INTO isd_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ki kada pasanga, ay napayán ka isa nga sinan mal-malúkung nga bútà almendras ya singan da. Ay neráman pe datu ak-aken datun na but-bútà. Ay napakuna ngámin datu annam ma pas-pasanga. ");
INSERT INTO isd_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Ay kitu arutáng tu kandelero, ay appát ta nagsasarundù datu sinan mal-malúkung nga bútà almendras datu singan da. Atán pe datu ak-aken da. ");
INSERT INTO isd_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Isa nga sinan bútà se itu aken na ya atán kiya panìgad datu munna nga nagtuway nga pasanga, ay isa pe nga sinan bútà se itu aken na pe ya atán ki panìgad datu sumarunu nga nagtuway ya pasanga. Ay napakuna pe datu duddúma nga pas-pasanga. ");
INSERT INTO isd_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Ay datun na sinan but-bútà se datu pas-pasanga natu kandelero, ay tang-tanganáyun da. Nàwa ngámin dedi ki tang-tangapánid da napitpet nga pabeg balitù. ");
INSERT INTO isd_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Datu pingki natu kandelero se datu ippapatay kadatu apuy da se itu pippinggán na angilubtagán da, ay nàwa da ngámin pe ki pabeg balitù. ");
INSERT INTO isd_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Tallu púlu se appát kílu nga pabeg balitù ya nausár na kitu inangwa na kitu kandelero se datu ngámin na ar-aruminta na. ");
INSERT INTO isd_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Ay kinuwa pe tu Bezalel tu annìdúgán ka insensu ka káyu nga akasiya. Tu kadakkal na, ay gudduwa mitru nga nagbaal. Ay siyám púlu sentimitru tu kalingúdu na. Ay datu sinan sàgud kadatu síku na, ay nekanáyun da kitu baggi na. ");
INSERT INTO isd_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Kinalupkopán na ka balitù datu bika-bíkat na se itu otun na, se datu sinan sàgud. Ay pinayán na pe ka nabúrì nga kalupkop nga balitù datu ráging na. ");
INSERT INTO isd_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Ay pinangwa na pe ka agduduwa nga galáng nga balitù datu magpíngit bíkat na, nga ittu datu pangiruwaddán da kadatu takkan na pagbulígán da. Nippáy nada kitu panìgad natu lebig na. ");
INSERT INTO isd_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Datu takkan na, ay kinuwa nada pe ka káyu wa akasiya, ay se nada pe kalupkopán ka balitù. ");
INSERT INTO isd_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Nangwa pe kitu napatag ga denu nga ikkiípu kadatu píli ne APU, se itu napabeg nga insensu nga nabangug. Tu inangwa na, ay ummán ki angwa datu maragkuwa ka bang-bangug. ");
INSERT INTO isd_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Kinuwa tu Bezalel tu annìdúgán ka pagbasu ka káyu wa akasiya. Ya kadakkal na, ay duwa mitru se tallu púlu sentimitru nga nagbaal. Ay ya kalingúdu na, ay isa mitru se tallu púlu sentimitru. ");
INSERT INTO isd_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Pinangwa na pe ka sinan sàgud datu appát síku na nga nekanáyun kitu baggi na. Ay se na nga kalupkopán ka bága. ");
INSERT INTO isd_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Ay kinuwa na ngámin pe datu ar-aruminta nga mausár kitúni ka bága, ummán kadatu dadakkal kalderu, datu pála, datu besin, datu ikkakáwit ka karni se datu aggapuyán na. ");
INSERT INTO isd_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Pinangwa na pe ka issaságat na nga nalága nga bárus nga bága, nga ittu tu nippáy na kitu danni kitu otun na nga namanda kitu ábà kitu unag na. ");
INSERT INTO isd_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Pinangurma na pe ka appát galáng nga bága se nada nippáy kadatu bátug síku natu issaságat nga ittu datu pangiruwaddán da kadatu takkan na pagbúlig da. ");
INSERT INTO isd_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Kinuwa na datu takkan ka akasiya, ay se nada kalupkopán ka bága. ");
INSERT INTO isd_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Ay se nada nga neruwad kadatu galáng kadatu magpíngit bíkat natu annìdúgán. Ittu dedi daya pagbúlig da nu bulígán da. Ay tun na annìdúgán, ay kinuwa na ka tabla, ay ummán ka kahon tu singan na. ");
INSERT INTO isd_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Kinuwa na ka bága pe tu abay besin se itu síkil na. Tu inusár na, ay datu nàwa ka bága nga am-amínaw datu babbay ya magub-ubra kitu gagyangán natu tabernákulu. ");
INSERT INTO isd_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Ay se na pe yin na kuwaan tu amuwág ka panillod. Ay tu bátug abut na nga kurtína nga naabal ka napiya binola nga dilána, ay appát púlu se annam mitru tu kadaddu na. ");
INSERT INTO isd_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Ay datu duwa púlu nga adígi na se datu pagsiínán da, ay kinuwa nada ka bága. Ngamay datu sáwit datu adígi se datu bagákat da, ay silber da. ");
INSERT INTO isd_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Ay tu amuwág ka panidáya, ay appát púlu se annam mitru pe tu kadaddu natu kurtína na. Ay datu duwa púlu pe nga adígi na se datu pagsiínán da, ay nàwa da pe ka bága. Ngamay datu sáwit se datu bagákat da, ay silber da. ");
INSERT INTO isd_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ay tu amuwág ka padne sirbútán, ay duwa púlu se tallu mitru tu kadaddu na, ay atán pe kurtína na. Ay sangapúlu datu adígi na se datu pagsiínán da. Ay datu sáwit da se datu bagákat da, ay nàwa da ka silber. ");
INSERT INTO isd_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ay tu amuwág kitu àráng na nga pane lattakán, ay duwa púlu se tallu mitru pe tu súba na. ");
INSERT INTO isd_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Ay tu kurtína natu tapíngit natu gagyangán, ay annam mitru se siyám púlu sentimitru ya kadaddu da. Ay tallu datu adígi na se datu pagsiínán da. ");
INSERT INTO isd_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Ay tu tangapíngit natu gagyangán, ay annam mitru se siyám púlu sentimitru pe tu kadaddu natu kurtína na. Ay tallu pe datu adígi na se datu pagsiínán da. ");
INSERT INTO isd_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Ngámin datu kur-kurtína datu am-amuwág na, ay pabeg napiya nga dilána. ");
INSERT INTO isd_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Ay datu pagsiínán kadatu adígi na, ay bága. Ngamay datu saw-sáwit datu adígi se datu bagákat da, ay silber da. Ay datu untù da ay nakalupkopán ka silber. Ay datu pangibissinán kadatu kurtína, ay nàwa ka pabeg silber. ");
INSERT INTO isd_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Ay tu kurtína natu lalangkán natu amuwág, ay naburdáan ka binola nga mannáw se bayolet se dag-daggáng se napiya nga binola nga dilána. Ay siyám mitru tu kadaddu na, ay se duwa mitru se tallu púlu sentimitru tu kalampád na, nga ummán kadatu kur-kurtína natu amuwág. ");
INSERT INTO isd_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Ay datu appát ta adígi nga nangikaptán da kitu kurtína se datu pagsiínán da, ay nàwa da ka bága. Pabeg silber datu sáwit na, ay datu untù da se datu bagákat da, ay nakalupkopán da ka silber. ");
INSERT INTO isd_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Ay datu ngámin pátù natu tabernákulu se datu pátù datu amuwág na, ay nàwa da ngámin ka bága. ");
INSERT INTO isd_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Ay tu idi ya lista datu kinuw-kuwa da se tu kaadu datu inus-usár da kitu inangwa da kitu tabernákulu nga giyán natu nekippayán datu nesur-súrát ta bil-bílin. Nepesúrát tu Moses kadatu Levita nga neapuwán natu Itamar nga pútut natu pádi nga Aaron. ");
INSERT INTO isd_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Tu Bezalel nga pútut natu Uri nga an-anà natu Hur nga isa kadatu tangámalán tu Juda ya nangwa kadatu ngámin na nebílin ne APU kitu Moses. ");
INSERT INTO isd_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Tu kabulun na, ay tu Oholiab nga pútut tu Ahisamak nga isa kadatu tangámalán tu Dan. Aggína tu nakammu nga magbur-búrì se aggína pe tu nakammu nu wà ummán natu kàwaán da. Aggína pe tu nagburda kadatu napiya nga dilána ka mannáw se bayolet, se dag-daggáng nga binola. ");
INSERT INTO isd_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Ya dágup natu nausár ra balitù kadatu ngámin na nà-nàwa kitu tabernákulu, ay isa ríbu kílu kitu ikkikílu kiya tabernákulu. Nilbetán tolay ngámin dayán na balitù. ");
INSERT INTO isd_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Ya dágup datu silber nga naurnung da nga pinagbáyad datu tolay ya nebíláng kitu sensus, ay tallu ríbu se appát gatut kílu kitu ikkikílu da kiya tabernákulu. ");
INSERT INTO isd_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Tu báyad isa tolay, ay annam grámu nga silber (nu makílu kitu ikkikílu ka tabernákulu). Ay adu tu dágup na, áta tu bíláng datu tolay nga nabíláng da kitu sensus nga magdagun ka duwa púlu se datu nasurù ay 603,550 nga lalláki. ");
INSERT INTO isd_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Tu tallu ríbu se appát gatut kílu nga silber tu nausár kadatu pagsiínán kadatu dabbi tu tabernákulu, se datu pagsiínán kadatu adígi para kadatu kurtína. Ya dammat natu isa pagsiínán, ay tallu púlu se appát kílu, ay magatut nga pagsiínán tu kinuwa da. ");
INSERT INTO isd_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ay duwa púlu kílu nga silber ya nausár kadatu sáwit kadatu adígi se kitu pinagkalupkop da kadatu untù datu adígi se datu bagákat da. ");
INSERT INTO isd_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Ay tu bága nga niddánán datu tolay, ay duwa ríbu se appát gatut kílu. ");
INSERT INTO isd_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Ittu tu inusár da kitu inangwa da kadatu pagsiínán datu adígi kitu lalangkán natu tabernákulu, se kitu annìdúgán ka pagbasu se itu issaságat na se datu ngámin ar-aruminta na. ");
INSERT INTO isd_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Ay ittu pe ya nangallakán da kitu inusár da kadatu pagsiínán kadatu adígi natu amuwág se datu pat-pátù natu tabernákulu se datu pat-pátù natu amuwág. ");
INSERT INTO isd_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Ay datu binola nga mannáw se bayolet se dag-daggáng, ay ittu datu inabal da ka napiya, se kinuwa da ka napatag nga aruwátan datu pappádi kitu agsirbi da ke APU kitu napatag nga kuwartu. Pinangwa da tu Aaron kadatu aruwátan na nga ummán kitu nebílin ne APU kitu Moses. ");
INSERT INTO isd_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Kinuwa de Bezalel tu efod ka balitù, se kadatu binola nga mannáw, se bayolet, se dag-daggáng se ka napiya nga binola nga dilána. ");
INSERT INTO isd_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Pinitpet da tu balitù, ay se da kinuwa ka binola nga ittu tu nebulun na kadatu mannáw se datu bayolet se datu dag-daggáng nga binola nga neabal da kitu napiya nga dilána. Napiya tu nekadisaynán da. ");
INSERT INTO isd_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Pinangwa da tu efod ka sadáng ki abága na nga nekabit kadatu duwa nga síku na. ");
INSERT INTO isd_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ay tu nausár se nekàwa natu bagákat na, ay páda na pe kitu efod. Nàwa pe ka binola nga balitù se mannáw se dag-daggáng nga neabal ki napiya nga dilána nga ummán kitu nebílin ne APU kitu Moses. ");
INSERT INTO isd_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ay datu duwa nga batu na nga oniko, ay nekapat dada kitu nalága nga bibittì a bárus nga balitù. Nemarka da datu ngag-ngágan datu pútupútut tu Israel. ");
INSERT INTO isd_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Nekapat dada kitu sadáng natu efod nga ummán kitu nebílin ne APU kitu Moses. Ittu datun datu mangipadamdam ke APU kadatu pútupútut tu Israel. ");
INSERT INTO isd_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Ay tu annáp gútù, ay kinuwa da pe ka napiya nga ummán kitu efod. Kinuwa da pe ka binola nga balitù, mannáw, bayolet se dag-daggáng nga neabal ki napiya nga dilána. ");
INSERT INTO isd_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Tu annáp gútù, ay duwa púlu se duwa sentimitru nga nagbaal ya kadakkal na, nga nàpil ka duble. ");
INSERT INTO isd_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Pinayán da ka appát daládag ga pinilà a batu-batu. Tu nunna daládag, ay datu batu wa karnelia, krisolito, se esmeralda. ");
INSERT INTO isd_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Ay tu mekàduwa daládag, ay turkisa, safiro, se diyamante. ");
INSERT INTO isd_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Tu mekàlu daládag, ay datu batu wa hasinto, búngut, se amatista. ");
INSERT INTO isd_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Ay tu mekappát daládag, ay datu batu wa berilo, oniko se haspe. Nekapat da ngámin ka nalága nga bibittì nga bárus nga balitù. ");
INSERT INTO isd_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Sangapúlu se duwa datu batu nga nekemarkaán datu ngag-ngágan datu pútupútut natu Israel. Isa ngágan ki kada batu. Ittu dayán daya sangapúlu se duwa nga tangámalán tu Israel. ");
INSERT INTO isd_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Pinayán da ka kadena nga nàwa ki nalúbid da pabeg balitù tu annáp gútù. ");
INSERT INTO isd_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Nangippáy da kitu síku natu annáp gútù ka duwa pánid nga nalága nga bibittì a bárus sa balitù nga pangikaptán da ka duwa nga galáng nga balitù ");
INSERT INTO isd_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","nga ittu daya kigpattán datu nalúbid da balitù. ");
INSERT INTO isd_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Ay datu tapungtu datu nalúbid nga balitù, ay nekabit dada kadatu duwa nga nalága nga bibittì a bárus nga balitù nga atán kitu panin àráng datu sadáng natu efod. ");
INSERT INTO isd_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Ay nangwa da pe ka duwa nga galáng nga balitù, ay se dada ippáy kadatu síku natu annáp gútù kitu tapíngit ta pane kitu efod. ");
INSERT INTO isd_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Nangwa da pe ka duwa galáng nga balitù se dada nga ikapat kitu panìgad datu duwa nga sadáng natu efod kitu panda natu naburdáan na bagákat na. ");
INSERT INTO isd_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Ay se da nigpat ka mannáw nga lúbid datu galáng natu annáp gútù kadatu galáng natu efod, ta senu magpaningúdu kitu naburdáan na bagákat natu efod. Ay senu akkan pe mapkit kitu efod. Ittu yán tu nebílin ne APU kitu Moses. ");
INSERT INTO isd_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Kinuwa tu Bezalel pe tu kamason na magpanin unag kitu efod. Kinuwa da ka naabal nga mannáw nga binola. ");
INSERT INTO isd_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Ay tu bùlaw natu kamason, ay atán kitu túlad, ay se la pe napayán ka tapár na, ta senu akkan mapìsi. ");
INSERT INTO isd_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Ay kitu gayádan natu kamason, ay pinalebután da ka sinan bayábat nga nàwa ka binola nga mannáw se bayolet se dag-daggáng se neburda da ki napiya nga dilána. ");
INSERT INTO isd_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Nangwa da pe ka bibittì a kingkeng nga pabeg balitù nga ittu datu nippáyán da kadatu nagbabàtán datu sinan bayábat kitu gayádan tu kamason. ");
INSERT INTO isd_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Ya isa nga kingkeng, ay mapasarunuwán ka isa nga sinan bayábat. Napalebután tu gayádan tu kamason na pagkamason tu Aaron nu magsirbi ke APU. Ittu yán tu nàwa ta ittu yán tu nebílin ne APU kitu Moses. ");
INSERT INTO isd_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Nangwa da pe ka panin lasi nga kamason para kitu Aaron se datu annánà na. Nàwa da ki napiya nga dilána. ");
INSERT INTO isd_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Ay tu abungut da, ay nàwa da pe ka napiya nga dilána. Ay ummán pe datu babbad úlu da, se datu kalsunsilyu da. ");
INSERT INTO isd_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Ay tu bagákat da, ay nàwa da pe ka napiya nga dilána nga naburdáan ka binola nga mannáw se bayolet, se dag-daggáng, nga ummán kitu nebílin ne APU kitu Moses. ");
INSERT INTO isd_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ay se da la nga kinuwa tu napatag ga sagápaw pádi nga namarkaán ka “Napatag ke APU”. Pabeg balitù tu kinuwa da. ");
INSERT INTO isd_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Pinayán da ka mannáw nga lúbid nga ittu tu pangigpat da kitu abungut nga ummán kitu nebílin ne APU kitu Moses. ");
INSERT INTO isd_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Ay nabalin lugud ngámin datu ub-ubra kitu tabernákulu. Kinuwa datu iIsrael ngámin datun ka ummán kadatu nebil-bílin ne APU kitu Moses. ");
INSERT INTO isd_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Ay díkod nilbet da kitu Moses datu ngámin ar-aruminta natu tabernákulu, datu tulda, se datu ngámin na ar-aruminta kitu unag na. Datu saw-sáwit na se datu dab-dabbi na, datu tak-takkan na nga káyu, se datu adígi na se datu pagsiínán da. ");
INSERT INTO isd_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Nilbetán da pe datu takkab nga nàwa ki lálat toru wa karneru se napiya nga lálat báka se itu kurtína natu lalangkán. ");
INSERT INTO isd_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Atán pe yin tu arko nga kippayán natu nekesur-surátan datu bil-bílin ne Dios, se datu takkan na ibbubúlig, se itu takkab na nga ittu tu akim-imallàán ke APU. ");
INSERT INTO isd_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Nilbet da pe yin tu tebol se datu ar-aruminta na se itu Dátun nga Sinápay. ");
INSERT INTO isd_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Nilbet da pe yin tu kandelero nga nàwa ki pabeg balitù se datu pingki na, se datu ar-aruminta na. Ay atán pe yin na denu para kadatu pingki. ");
INSERT INTO isd_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Nilbet da pe yin tu annìdúgán nga balitù, datu ikkiípu nga denu se datu nabangug nga insensu. Atán pe yin tu kurtína natu lalangkán natu tabernákulu. ");
INSERT INTO isd_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Atán pe yin tu annìdúgán nga bága, se itu issaságat na nga bága pe, datu takkan na se datu ar-aruminta na. Nilbet da pe yin tu besin se itu síkil na. ");
INSERT INTO isd_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Nilbet da pe yin datu kur-kurtína natu amuwág, se datu ad-adígi na se datu pagsiínán kadatun na adígi. Nilbet da pe tu kurtína natu lalangkán natu amuwág, se datu lúbid se datu pátu-pátù. Nilbetán da pe yin ngámin datu ar-aruminta nga masápul kadatu mà-màwa kitu tabernákulu. ");
INSERT INTO isd_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Nilbet da ngin datu napiya nga ikkaaruwát datu pappádi nu magubra da kitu napatag nga giyán. Atán pe yin datu napatag ga ibbabádu tu Aaron nga pádi nu magsirbi ke APU, ay se datu ngámin na ibbabádu datu pútupútut na nu magubra da kiya kinapádi da. ");
INSERT INTO isd_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Kinuwa datu iIsrael ngámin datu ub-ubra nga ummán kadatu nebil-bílin ne APU kitu Moses. ");
INSERT INTO isd_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Ay kane masingan tu Moses nga kinuwa da ngámin datu ub-ubra nga ummán kadatu nebil-bílin ne APU, ay nekarárag nada. ");
INSERT INTO isd_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Ay inamomanán ne APU tu Moses nga nán na, ");
INSERT INTO isd_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Kiya munna nga algaw naya munna nga búlán, ay ittu ya angngipasíkád mu kiya tabernákulu nga agtammuwán. ");
INSERT INTO isd_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Iunag mu kiyán ya arko nga kippayán naya nekesurátán datu bil-bílin. Ay se mu la nga kurtináan ya giyán na ka angilingad mu kiyán. ");
INSERT INTO isd_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Iunag mu pe yin ya tebol, ay se mu kapiyánan ippáy datu ar-aruminta na. Iunag mu pe yin ya kandelero, ay se mu pe yin na ippáy daya pingki na. ");
INSERT INTO isd_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ippáy mu ya balitù a annìdúgán ka insensu kiya lasi naya kurtína nga panin sángu kiya arko nga giyán datu nekesurátán daya bil-bílin ne APU, ay se mu la kurtináan ya lalangkán naya tabernákulu. ");
INSERT INTO isd_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Ippáy mu ya annìdúgán ka pagbasu kiya sángu naya lalangkán kiya tabernákulu nga agtammuwán. ");
INSERT INTO isd_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ippáy mu tu abay besin kiya nagbàtán daya agtammuwán se ya annìdúgán ka pagbasu. Ay payán mu ka danum na. ");
INSERT INTO isd_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ay se mu la pe ipasíkád ya abut naya amuwág nga nepalìmut kiya tabernákulu, ay se mu la kurtináan pe ya lalangkán na. ");
INSERT INTO isd_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Ay se mu la alà ya denu wa ikkiípu se mu la warsián ya tabernákulu se daya ngámin na inunag na ka angngikísi mu kadayán se daya ar-aruminta na, ta senu magbalin da ka kuw-kuwa ne APU. ");
INSERT INTO isd_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ay warsián mu pe ya annìdúgán ka pagbasu se daya ar-aruminta na ka angngikísi mu pe kiya annìdúgán. Díkod magbalin da ka kapàgán nga kuw-kuwa ne APU. ");
INSERT INTO isd_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Warsìán mu pe ya abay besin se iya síkil na ka angngikísi mu pe kiyán. ");
INSERT INTO isd_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Ay se mu la alà de Aaron na maggaáma kiya lalangkán naya tabernákulu, ay se mu dala nga bagguwán. ");
INSERT INTO isd_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ay se mu ibádu ke Aaron daya napatag ga ibbabádu na, ay se mu ipuwan ka denu ka angngikísi mu kaggína ka para kiyà ta senu magsirbi ka pádi ku. ");
INSERT INTO isd_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Alà mu pe daya pútupútut na, ay se mu la ibádu kaggída datu kamason da, ");
INSERT INTO isd_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","ay se muda la nga ipuwán kitu denu, nga ummán kitu kinuwám kiya ama da, ta senu magsirbi da kiyà ka pappádi ku. Ay ya angngípu mu kaggída ya mamagbalin kaggída ka pappádi ku peyang ngin ka panda, oray daya sumar-sarunu pikam ma gakagaka da,” nán ne APU. ");
INSERT INTO isd_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Ay díkod kinuwa tu Moses tu ngámingámin nga ummán kitu nebil-bílin ne APU kaggína. ");
INSERT INTO isd_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Kitu munna nga algaw natu munna nga búlán natu mekàduwa dagun, ay nepasíkád tu Moses tu tabernákulu. ");
INSERT INTO isd_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Nippáy da datu pagsiínán na se datu dab-dabbi na, ay se da la neruwaddán datu takkatakkan na nga káyu, ay se da pe yin nepasíkád datu adígi na. ");
INSERT INTO isd_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Ay se na pe yin na isalukop tu tulda kitu tabernákulu, se na manin ilànù tu takkab natu tulda kitu otun na, nga ummán kitu nebílin ne APU kaggína. ");
INSERT INTO isd_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Ay se na alà tu nekesurátán datu bil-bílin, ay se na nga ippáy kitu arko, ay se na pe yin na iruwad datu takkan na, ay se na nga ippáy tu takkab na nga akim-imallàán ke APU. ");
INSERT INTO isd_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ay nilnà na ngin tu arko kitu tabernákulu, ay se na nga ippáy pe yin tu kurtína nga lipad natu arko nga ummán kitu bílin ne APU kaggína. ");
INSERT INTO isd_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Neunag na pe yin tu tebol kitu tabernákulu. Nippáy na kitu panidáya kitu tabernákulu, kitu panin lasi natu kurtína. ");
INSERT INTO isd_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Ay se na nga ippáy tu sinápay kitu kippayán na nga àráng ne APU nga ummán kitu bílin na kitu Moses. ");
INSERT INTO isd_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Neunag na pe tu kandelero kitu tabernákulu. Nippáy na kitu bátug tu tebol kitu panillod kitu unag tabernákulu. ");
INSERT INTO isd_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Ay se na ippáy datu pingki na pe ki àráng ne APU, ummán kitu nebílin ne APU kitu Moses. ");
INSERT INTO isd_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Neunag na pe tu balitù a annìdúgán se na ippáy kitu sángu natu kurtína natu arko. ");
INSERT INTO isd_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Nanìdúgán na pe yin ka nabangug nga insensu nga ummán kitu nebílin ne APU. ");
INSERT INTO isd_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Ay se na nippáy tu kurtína natu lalangkán natu tabernákulu. ");
INSERT INTO isd_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Nepatugaw na tu annìdúgán ka pagbasu kitu sángu natu lalangkán natu tabernákulu nga agtammuwán. Ay nanìdug pe yin ka pagbasu, se nangidátun pe yin kitu dátun nga ummán kitu nebílin ne APU kaggína. ");
INSERT INTO isd_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Nippáy na tu besin kitu nagbàtán datu báwi nga agtammuwán, se itu annìdúgán ka pagbasu. Ay pinayán na pe yin ka danum nga pagbaggu. ");
INSERT INTO isd_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Ittu win tu nagbagguwán se naggusesuwán tu Moses se de Aaron na maggaáma. ");
INSERT INTO isd_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Nu magunag da kitu báwi nga agtammuwán se nu umbet da kitu giyán tu annìdúgán, ay magbaggu da nga ummán kitu nebílin ne APU kaggína. ");
INSERT INTO isd_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Ay nepasíkád na pe yin tu abut natu amuwág nga nepalebut kitu tabernákulu se itu annìdúgán ka pagbasu, ay se na pe yin ippáy datu kurtína kitu lalangkán na. Ay díkod nabalin tu Moses datu ub-ubra na. ");
INSERT INTO isd_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Ay se yala naangpán tu báwi nga agtammuwán kitu angap, ay nadilangán ngámin tu unag tu tabernákulu kitu diláng ne APU. ");
INSERT INTO isd_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Ay akkan nakalnà tu Moses kitu agtammuwán, áta nagdagát tu angap kitúni, ay se nadilangán tu ngámin unag tu tabernákulu kitu diláng ne APU. ");
INSERT INTO isd_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ay ki kada agtálaw natu angap kitu tabernákulu, ay magsagána pe yin datu iIsrael nga mawe manin na magdal-dalen. ");
INSERT INTO isd_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Ngamay nu akkan magal-alit tu angap, ay akkan da pe magal-alit panda kitu aggalit na manin. ");
INSERT INTO isd_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Ata sisinnan peyang datu iIsrael tu angap ne APU kitu nagdal-dalen da. Atán kitu ngúdu natu tabernákulu ki algaw. Ay nu gabi, ay atán apuy kitu angap.");
INSERT INTO isd_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Tú idi ya gin-ginnápuwán se naggay-gayatán ne Jesu-Cristo wa gaka natu David. Ay tu David, ay gaka natu Abraham. ");
INSERT INTO isd_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ay tu Abraham, ay ama natu Isaac. Ay tu Isaac, ay ama natu Jacob. Ay tu Jacob, ay ama de Juda nga magwawági nga pabeg lalláki. ");
INSERT INTO isd_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ay tu Juda, ay ama de Fares se Zara, ay Tamar tu ina da. Ay tu Fares, ay ama natu Esrom. Ay tu Esrom, ay ama natu Aram. ");
INSERT INTO isd_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ay tu Aram, ay ama natu Aminadab. Ay tu Aminadab, ay ama natu Naason. Ay tu Naason, ay ama natu Salmon. ");
INSERT INTO isd_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ay tu Salmon, ay ama natu Booz. (Ay tu Rahab ya ina tu Booz.) Ay tu Booz, ay ama natu Obed. (Ay tu Ruth tu ina natu Obed.) Ay tu Obed, ay ama natu Jesse. ");
INSERT INTO isd_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ay tu Jesse, ay ama natu Ari David. Tu David, ay ama natu Solomon nga pútut na kitu búkud natu Urias. ");
INSERT INTO isd_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ay tu Solomon, ay ama natu Roboam. Ay tu Roboam, ay ama natu Abias. Ay tu Abias, ay ama natu Asa. ");
INSERT INTO isd_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ay tu Asa, ay ama natu Josafat. Ay tu Josafat, ay ama natu Joram. Ay tu Joram, ay ama natu Ozias. ");
INSERT INTO isd_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ay tu Ozias, ay ama natu Jotam. Ay tu Jotam tu ama natu Acaz. Ay tu Acaz tu ama natu Ezekias. ");
INSERT INTO isd_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ay tu Ezekias, ay ama natu Manase. Ay tu Manase, ay ama natu Amon. Ay tu Amon, ay ama natu Josias. ");
INSERT INTO isd_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ay tu Josias, ay ama de Jeconias nga magwawági nga pabeg lalláki. Ay kitu kakowad da, ay ittu tun tu nangngalà datu iBabilonia kiti íli da kadatu iIsrael la pinalsu da. ");
INSERT INTO isd_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ay kane mippan datu iIsrael lin ka Babilonia, ay nakapútut tu Jeconias. Ay tu pútut na, ay tu Salatiel. Ay tu Salatiel, ay ama natu Zerobabel. ");
INSERT INTO isd_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ay tu Zerobabel, ay ama natu Abiud. Ay tu Abiud, ay ama natu Eliakim. Ay tu Eliakim, ay ama natu Azor. ");
INSERT INTO isd_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ay tu Azor, ay ama natu Sadoc. Ay tu Sadoc tu ama natu Akim. Ay tu Akim, ay ama natu Eliud. ");
INSERT INTO isd_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ay tu Eliud, ay ama natu Eleazar. Ay tu Eleazar, ay ama natu Matan. Ay tu Matan, ay ama natu Jacob. ");
INSERT INTO isd_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ay tu Jacob, ay ama natu Jose, nga atáwa ne Maria nga ina ne Jesus nga nengagánan da ka Cristo. ");
INSERT INTO isd_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ay díkod nanggayát kitu Abraham panda kitu David, ay sangapúlu se appát ta paganakán ngámin. Ay nanggayát kitu David panda kitu nangngippan datu iBabilonia kadatu iIsrael ka Babilonia, ay nagsangapúlu se appát pe nga paganakán. Ay sangapúlu se appát paganakán pe panda kitu nangngippan da kadatu iIsrael ka Babilonia, panda kitu nekeanà ne Cristo. ");
INSERT INTO isd_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ay ummán kídi ya istoriya natu nekeanà ne Jesu-Cristo. E Maria nga ina na, ay nekari yin na meatáwa ke Jose. Ay kitu akkan da pikam ma inaggallay, ay nammuwán ne Jose nga nabùsit te Maria. Ngamay akkan na nga am-ammu wa napabùsit te Maria gapu kiya pannakabalin naya Ispiritu ne Dios. ");
INSERT INTO isd_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ay tútu linam-lammat na nga maddi yin ke Maria. Ngamay ya piyán na, ay akkan na nga ipak-pakammu ka sabáli tolay ya aggadi na. Ata oray nu maragtungpál kadaya lin-lintag, ay lùsawan na nga meap-appat te Maria. ");
INSERT INTO isd_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ngamay kitu atán ka uray na tunin, ay uwad anghel ne Apu wa nagpatagenap kaggína nga nán na, “Jose, akkan ka nga min-induwán na mangatáwa ke Maria, áta ya bùsit na, ay gapu kiya Ispiritu ne Dios. ");
INSERT INTO isd_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Magan-anà ka isa nga laláki, ay ya ipangágan mu kaggína, ay Jesus (ay ya sarut nayán ay Marammiyág). Ata aggína ya mamiyág kadaya tolay na gapu kadaya bas-básul da, nga pakatayán da ka áwan panda,” nán natu anghel ke Jose nga gakagaka tu David. ");
INSERT INTO isd_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ay nàwa ngámin dedi ta senu makurug datu bàbànán ne Apu, nga nepekagi na kadatu pagbàbànánan na kitun nga nán na kídi: ");
INSERT INTO isd_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mapabùsit ya isa nga babbalásang. Ay magan-anà ka isa nga laláki. Ay mengagánan ka Emmanuel,” nán na. (Ya sarut naya Emmanuel, ay inumbet nge Dios kadàtada.) ");
INSERT INTO isd_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ay kane din malukág ge Jose, ay kinurug na tu bílin natu anghel ne Apu. Ay díkod inatawán na nge Maria. ");
INSERT INTO isd_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ngamay akkan na pikam ma neallay kaggína panda kitu naggan-anà na. Ay kane magan-anà e Maria, ay nepangágan ne Jose tu an-anà ka Jesus. ");
INSERT INTO isd_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ay neanà e Jesus ka íli Betlehem ka probinsiya Judea kitu inagturáy tu Ari Herodes. Ay kitun, ay uwad da nga mamasírib nga tolay mepanggap kadaya bittuwan. Naggayát da ka padne lattakán nga inumbet ka Jerusalem. Ay nagsaludsud da nga nán da, ");
INSERT INTO isd_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Kawà naya giyán naya neanà nga Ari daya Judyu? Nasingan mi tu bittuwan ka lattakán nga mangipakammu kiya nekeanà na. Ay túya inumbet kami nga magdáyaw kaggína,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ay kane magìna tu Ari Herodes tun, ay nariribù. Ay ummán pe datu iJerusalem, nariribù da pe. ");
INSERT INTO isd_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ay díkod inayabán tu Herodes ngámin datu ap-apu datu pappádi se datu maragtùgud ki lintag. Ay se na sinaludsud kaggída nu kawà naya keanaán naya Cristo. ");
INSERT INTO isd_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ay tútu nán da kaggína, “Ka Betlehem ka Judea, áta ittu mà ya nesúrát natu pagbàbànánan ne Dios kitun nga nán na, ");
INSERT INTO isd_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ay dakayu wa iBetlehem ka probinsiya Juda, akkan kayu wayya nga kababaán kadaya ngámin na tolay kadaya il-íli kídi Judea. Ata lumtuwád kadakayu ya mangituráy kadaya tolay ku wa iIsrael,’ nán na,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ay tútu inayabán tu Herodes datu mamasírib ba tolay nga áwan makam-ammu. Ay inammu na kaggída nu inna tutu wala nga oras tu inagpassingan natu bittuwan. ");
INSERT INTO isd_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ay se nada pinapan nin ka Betlehem nga nán na kaggída, “Mawe nu wa kappiyánan na saludsúdan ya mepanggap kiya an-anà. Ay nu masmà nu, ay magulli kayu ta idámag nu kiyà ta senu umang ngà pe nga magdáyaw kaggína,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ay kane magìna da tu bílin tu Ari Herodes, ay nagrabbuwát da pe yin. Ay kitu kakowad da kitu dálen, ay nagpassingan manin tu bittuwan na nasingan da ka lattakán. Ay ittu tu naginunna kaggída. Ay kane bumátug kitu balay ya giyán natu an-anà, ay nagsínang ngin. ");
INSERT INTO isd_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ay tútu nagpatag da tutu wala. ");
INSERT INTO isd_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ay kane lumnà da kitu balay, ay nasingan da tu an-anà se Maria nga ina na. Ay se da nagpalintud da nagukkab nga magdáyaw kaggína. Ay se da ngala nga idde datu balitù, insensu se itu talibangug ga míra nga pannaruanggam da kaggína. ");
INSERT INTO isd_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ay nepakammu ne Dios kaggída ka tagenap, nga nu magulli da, ay akkan da nga magsíbál lin ka giyán tu Ari Herodes. Ay díkod nagalíli da kane mawe da ngin ka íli da. ");
INSERT INTO isd_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ay kane likud datu mamasírib ba nawe, ay nagpatagenap tu anghel ne Apu ke Jose. Ay nán na, “Bumángun ka, ay ibráw mu daya magina ka Egipto. Ay magyán kayu kannán panda kiya agpaulli ku kadakayu. Ata lam-lamtan ne Herodes nga pasápul ya an-anà ta papatay na,” nán natu anghel. ");
INSERT INTO isd_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ay tútu bummángun ne Jose se na nippan datu magina ka Egipto kitun na gabi. ");
INSERT INTO isd_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ay nagyán da kitúni panda kitu nekatay tu Herodes. Ay nàwa ngámin dedi ta masápul la màwa tu kinagi ne Apu nga nepekagi na kitu pagbàbànánan na kitun nga nán na kídi: “Inayabán ku ya an-anà ku nga atán ka Egipto,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ay kane mammuwán tu Herodes nga nagbusidán datu mamasírib ba tolay, ay nakarungat pà-pànang, ay tútu pinapatay na ngámin datu annánà a lalláki ka Betlehem se kadatu lib-lebut na, nga magdagun ka duwa se datu kúráng duwa dagun da pikam. Ata moli kid duwa dagun nin panda kitu inakasingan datu mamasírib ba tolay kitu bittuwan. ");
INSERT INTO isd_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ay díkod nàwa kurug tu kinagi natu Jeremias, nga pagbàbànánan ne Dios kitun, nga nán na kídi: ");
INSERT INTO isd_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ay uwad magìna nga págat ka Rama. Agsángit naya magmanakit. Ul-ululán ne Raquel daya annánà na. Maddi mearingringa, áta natay daya annánà na,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ay kane din na matay tu Herodes sin, ay nagpatagenap manin tu anghel ne Apu ke Jose nga atán ka Egipto. Ay nán na, ");
INSERT INTO isd_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Bumángun ka, ay iulli mu win daya magina ka íli Israel. Ata natay yin tu magasippatay kiya an-anà,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ay tútu bummángun ne Jose se na iulli yin datu magina ka íli Israel. ");
INSERT INTO isd_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ngamay magansing manin ne Jose nga mawe kitúni ta nadámag na nga nge Arkelao wa an-anà tu Herodes ya summukát kammin kaggína nga ári ka Judea. Ngamay kinagiyánan manin ne Dios ka tagenap na. Ay tútu nawe da ka probinsiya Galilea. ");
INSERT INTO isd_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ay díkod naggunà da ka íli Nazaret. Ay nàwa nga kurug tu kinagi datu pagbàbànánan ne Dios kitun nga nán na kídi, “Aggína, ay mengagánan ka Nazareno,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ay kitun na al-algaw kane nabayág de Jesus sin ka Nazaret, ay nagpakammu tu Juan na marammawtisár. Nagbàbànán kadatu tolay ya nawe kitu giyán na ka ir-ir-er ka Judea. ");
INSERT INTO isd_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ay nán na nga nagbàbànán, “Makappoli kayu kadaya bas-básul nu, ta tagay pànang ngin ya angngituráy ne Dios,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ata tu Juan tu kepapannán natu nesúrát ta kinag-kagi natu Isaias nga pagbàbànánan ne Dios kitun kitu inagkuna na kídi: “Tú idi ya isar-sáraw naya isa nga tolay ka ir-ir-er: Magsagána kayu kiya ilalbet ne Apu. Kappiyánan nu ya dalenan na, nán na.” ");
INSERT INTO isd_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Tu bádu tu Juan, ay nàwa ki dùdut kámel, ay se nagsinturon ka lálat. Ay datu kininna-kinnán na, ay dúdun se digu álig gala. ");
INSERT INTO isd_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ay kitun, ay adu wa tolay datu naglalbet kitu giyán na. Naggagayát da ka Jerusalem, ka Judea se kadaya ngámin na il-íli nga adanni kitu wángag Jordan. ");
INSERT INTO isd_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nepudnuwán da datu bas-básul, ay tútu binawtisarán tu Juan da kitu wángag Jordan. ");
INSERT INTO isd_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ngamay kane masingan tu Juan nga adu datu Pariseo se datu Saduceo nga naglalbet ta makibawtisár kaggína, ay nán na kaggída, “Dakayu wa ummán ka gámad idaw wa gangay! Ta daddán! Inna nád ya nangagi kadakayu wa malìlíán nu ya ammabásul ne Dios kadakayu, ta tura kayu inumbet!” nán na. ");
INSERT INTO isd_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","“Ipassingan nu kadaya kuk-kuwaan nu nga kurug nakappoli kayu win kadaya bas-básul nu, ");
INSERT INTO isd_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","nga akkan nu nán na, oray ta gakagaka nakami tu Abraham ma tolay ne Dios kitun. Ata ikagì kadakayu wa annung ne Dios nga pagbalinan dedi ya batu ka tolay ya magbalin ka gakagaka natu Abraham. ");
INSERT INTO isd_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ay oray kídi yin, ay meaayang ngin ya parakul la pangìlang kadaya káyu wa akkan magbúnga ka napiya, ay se da nga masìdug.” ");
INSERT INTO isd_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ay bawtisarán takayu ka mangipassingan nga nakappoli kayu win kadaya bas-básul nu. Ngamay atán ya sumar-saridát kiyà nga naturáy pànang may iyà. Ay oray ya mangagtu wala kadaya sapátus na, ay akkan nà mekari. Aggína ya árig mamawtisár kiya Ispiritu ne Dios se aggína pe ya mangukum. ");
INSERT INTO isd_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Meárig kiya isa tolay ya inumbet ta mangisáp kiya nàgì nga ammay. Urnúngan na daya nabgát se na iarimán. Ay daya lappit ay urnúngan na se na sìdúgan kiya apuy ya siggagatang peyang nga akkan mataatay,” nán ne Juan. ");
INSERT INTO isd_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Akkan nabayág, ay inumbet te Jesus ka Jordan. Gayát ka Galilea, nga makibawtisár kitu Juan. ");
INSERT INTO isd_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ngamay tu Juan, ay maddi kuma. Nán na nga, “Iyà kuma ya rabbang na nga bawtisarám, may tura la ikaw ya inumbet makibawtisár kiyà,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ngamay nán ne Jesus sa summungbát kitu Juan, “Kuwaam mala idi kídi, ta tú idi ya masápul la kuwaan ta ka annungpál ta kadaya ngámin na piyán ne Dios,” nán na. Ay tútu nalagpat tu Juan. ");
INSERT INTO isd_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ay kane din na mabawtisarán nge Jesus sin, ay gumàdáng, ay se pagkìlát na ngala nga ummán ka nalùtán ya lángit. Ay se na nasingan ya Ispiritu ne Dios nga singan ladágan tu singan na nga naganìgad se nagyán kaggína ngin. ");
INSERT INTO isd_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ay se yala uwad úni nga gayát ka lángit ta nán na, “Tú idi ya pà-pàgan ku wa an-anà ku se pagang-anggammán ku pànang pe,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ay se yala nga neturung na Ispiritu ne Dios nge Jesus ka ir-ir-er ta senu par-paroan ne Sairu. ");
INSERT INTO isd_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nagngílin nangán ka appát púlu ngalgaw se appát púlu gabi, ay se yala nabisinán. ");
INSERT INTO isd_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ay nawe dinatang ne Sairu, ay nán na kaggína, “Nu kurug ga ikaw ya An-anà ne Dios, ay pagbalinam mán lugud dedi nga batu ka sinápay,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ay nán ne Jesus, “Nán naya nesúrát ta bàbànán ne Dios nga, Akkan magbiyág ya tolay gapu ki makkán nala, nu di gapu pe kadaya ngámin na kagiyan ne Dios kadaya tolay,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ay se yala nga neturung manin ne Sairu we Jesus, nga mawe ka Jerusalem ay se da ummunè kitu kalinguduwán pànang natu templo. ");
INSERT INTO isd_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ay se na nán manin ke Jesus, “Nu kurug ga ikaw ya An-anà ne Dios, ay magsappáw ka mán lugud kídi. Oray ta akkan ka maan-anu, áta nán mà naya nesúrát ta bàbànán ne Dios nga, ‘Patagasinnán naka nge Dios kadaya anghel na.’ Ay nán na pe nga, ‘Tagagán daka kiya íma da ta senu akkan matalíngu daya síkil mu kadaya batu,’ nán na,” nán ne Sairu. ");
INSERT INTO isd_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ay nán ne Jesus manin kaggína, “May nán pe naya nesúrát ta bàbànán ne Dios nga, akkan ta sisímán ne Apu wa Dios tada, nán na,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ay se yala manin nippan ne Sairu we Jesus kitu alingúdu pànang nga bantay, ay se na ipassingan kaggína ngámin ya il-íli kídi kalawagán se ya kinapiya da, ");
INSERT INTO isd_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ay se na nán ke Jesus, “Kuwà ngámin dedi yin, ay idde ku ngámin dedi kikaw nu magpalintud ka nga magdáyaw kiyà,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ngamay nán ne Jesus kaggína, “Magtálaw ka mà Sairu! Ta nán naya nesúrát ta bàbànán ne Dios nga, ‘E Dios nga Apu mu ya day-dayáwan mu. Ay se aggína ngala ya ikur-kurug mu,’” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ay tútu nagtálaw we Sairu. Ay se yala uwad da inumbet ta anghel ne Dios sa nangidde ki ngámin na masápul na. ");
INSERT INTO isd_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ay kane madámag ne Jesus nga nabálud tu Juan, ay nagulli kammin ka Galilea. ");
INSERT INTO isd_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ay akkan na nagyán nin ka Nazaret. Nawe nagyán ka Capernaum. Idi ya íli, ay adanni ka pisung ka Teberias nga adanni pe ka sakúpán naya íli Zebulun se íli Naftali. ");
INSERT INTO isd_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ay kitu nagyán ne Jesus kitúni, ay nàwa nga kurug tu nebàbànán natu Isaias sa pagbàbànánan ne Dios kitun nga nán na kídi: ");
INSERT INTO isd_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ya lusà naya Zebulun se Naftali, ay atán kiya adanni ka dappit tu pisung ka Galilea, panidmáng naya wángag Jordan, ka sákup Galilea nga pagag-agyanán daya akkan Judyu. ");
INSERT INTO isd_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Datu tolay kitúni nga árig atán ki kagìbattán, ay nakasingan da ka nawada pànang ngin. Ay nawadaán nin daya ngámin na mameyag kiya pakatayán da ka áwan panda,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ay nanggayát kitun na nelalbet ne Jesus ka Capernaum, ay ginayatán na pe yin tu magbàbànán. Ay nán na nga nagbàbànán: “Makappoli kayu win kadaya bas-básul nu ta tagay pànang ngin ya angngituráy ne Dios,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ay kane isa ngalgaw wa magdal-dalen ne Jesus kitu dappit natu pisung ka Galilea, ay nasingan na datu magwagi, de Simon na nepangágan da pe ka Pedro se Andres nga wagi na. Atán da nga manabúkul, áta marangnígay da lugud. ");
INSERT INTO isd_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ay nán ne Jesus kaggída, “Kumíwid kayu kiyà ta tùgúdán takayu wa manganannay kadaya tolay nga mangurug kiyà nga ittu dayanin daya bátug sissida nga nigáyan nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ay nigsán da ngala ngin na dágus datu tabúkul da, ay se da nebulun nin kaggína. ");
INSERT INTO isd_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ay kane makawáyad da, ay nasingan manin ne Jesus datu duwa manin na magwagi, de Santiago se Juan, nga annánà ne Zebedeo. Atán da kitu barangay da nga magurip kitu inninígay da. Ay inayabán ne Jesus da. ");
INSERT INTO isd_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ay díkod, dágus da ngala nga pinanáwan tu barangay da, se tu ama da, ay se da nga kummíwid pe yin kaggína. ");
INSERT INTO isd_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ay ingngay ngámin ne Jesus tu ngámin na giyán ka Galilea. Nangisur-súru kadatu kap-kapilya da. Nebàbànán na ya Napiya nga Dámag mepanggap ki angngituráy ne Dios. Ay pinabílag na ngámin pe datu tolay kitúni nga atán sin-sinakit se sad-sadúra. ");
INSERT INTO isd_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ay nammuwán ngámin datu iSiria ya pannakabalin na, ay tútu nippannán datu tolay ngámin datu atán nagbal-baláki ya sin-sinakit se sad-sadúra kitu giyán na. Atán da nga naar-aránan, datu magkangkang, ay se datu magdapepe, may inagásan nada ngámin. ");
INSERT INTO isd_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ay adu tutu wala nga tolay datu nagkikíwid kaggína. Naggayát da ka Galilea, ka Decapolis, ka Jerusalem, Judea, ay se ka dammáng Jordan. ");
INSERT INTO isd_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Isa ngalgaw kane masingan ne Jesus datu adu wa tolay, ay nanùdu kitu bantay. Ay kane magtugaw, ay inumbet datu tolay na. ");
INSERT INTO isd_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ay tinùgúdán nada nga nán na, ");
INSERT INTO isd_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Maganggam daya makammu kiya akasápul da pànang ke Dios, áta aggída ya meráman kiya pangiturayán na. ");
INSERT INTO isd_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ay maganggam daya magpannakit gapu kadaya nadakè a mà-màwa, áta liw-liwaan ne Dios da. ");
INSERT INTO isd_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ay maganggam daya natulù ke Dios, áta mepakin-kuwa kaggída ya baru wa kalawagán. ");
INSERT INTO isd_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ay maganggam daya magasikkuwa kadaya pagmaruwán da ki àráng ne Dios, áta sengán nada nga mangwa kadayán. ");
INSERT INTO isd_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ay maganggam daya nakallà, áta kalakkán ne Dios da. ");
INSERT INTO isd_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ay maganggam daya mangipas-pasnà kiya ur-uray da kiya mepanggap kiya angngituráy ne Dios, áta masingan da nge Dios. ");
INSERT INTO isd_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Maganggam daya tolay ya ittu da la pà-pàgan ya napiya nga panagbubúlun, áta mengagánan da ka annánà ne Dios. ");
INSERT INTO isd_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Maganggam daya mapal-pallà gapu kiya angngikurug da kadaya piyán ne Dios, áta meráman da kiya pangiturayán na. ");
INSERT INTO isd_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Maganggam kayu nu ug-ogan dakayu, onu pal-palakkan dakayu onu pad-padàsán dakayu oray akkan kammala kurug gin gapu kiyà. ");
INSERT INTO isd_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Maganggam se magpatag kayu wala, áta napatag pà-pànang ya supápà a midde kadakayu ka lángit. Ay oray datu pagbàbànánan ne Dios kitun kam ma nun-unna may dakayu, ay pinal-pallà datu tolay da pe,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Dakayu, ay árig nu ya asin kadaya tolay kídi kalawagán ni. Ngamay ya asin, nu mippà ya apet na, ay akkan ta mabalin na mapaapet kammin. Ay díkod áwan na sur-surbi yin, nu di ta ngala ngin na iburráw kiya dálen ta senu dam-dam-án daya tolay. ");
INSERT INTO isd_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Dakayu, ay árig nu pe ya dílág kadaya tolay ked kalawagán. Ay ya íli nga nàwa ki otun bantay ay akkan wayya nga mesirù. ");
INSERT INTO isd_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ay áwan tolay pe ya manibat ka ingki, ay se na tàbán, nu di na nga ippáy ka alingúdu ta senu mawàdáran ngámin daya atán kiya unag balay. ");
INSERT INTO isd_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ay ummán din kiyán ya angngipassingan nu kadaya napiya nga kuk-kuwaan nu kadaya tolay, ta senu masingan da, ay dayáwan da ya Ama nu wa atán ka lángit.” ");
INSERT INTO isd_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ay akkan nu wa nán na inumbet tà nga mamagbalin ka áwan surbi datu lin-lintag tu Moses se datu nesur-súru datu pagbàbànánan ne Dios kitun. Akkan ittu yán ya gákat ku, nu di ya mangipakammu kadaya ngámin na kepapannán datun. ");
INSERT INTO isd_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ikagì kadakayu ya kurug, nga oray nu pumanda ya lángit se ya kalawagán, ay áwan oray bittì ala nga súrát kadatun na lin-lintag ya mippà panda kiya katungpál ngámin datun. ");
INSERT INTO isd_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ay díkod, oray iinna nga di mangikurug kadaya ibíláng da nga akkan napatag pànang kadatun na lin-lintag, ay se isúru na pe kadaya duddúma, ay akkan na rabbang yán na tolay ya meráman kiya pangiturayán ne Dios. Ngamay ngámin daya mangikurug kadatun na lin-lintag, ay se isúru da pe, ay tú dayán daya nadáyaw ke Dios kiya pangiturayán na. ");
INSERT INTO isd_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ay ikagì pe kadakayu nga akkan kayu meráman kiya pangiturayán ne Dios nu ya kinamáru nu, ay ummán nala kiya kinamáru daya magtù-tùgud ki lintag se daya Pariseo.” ");
INSERT INTO isd_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Nagì-gìna nu win na nebílin kadatu in-inagkona tada ya, ‘Akkan ka pumatay! Ay daya pumatay, ay mapabásul da’, nán na. ");
INSERT INTO isd_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ngamay kídi yin, ikagì kadakayu wa ngámin daya mangalùsaw kiya kasittolay da nga áwan na gapu, ay mapabásul da pe. Ay daya mangagi kiya kasittolay da ka, ‘Ang-ang ka,’ ay mabustigár da kiya kangatuwán na agbustigarán ka Jerusalem. Ay se ngámin daya mangagi kiya kasittolay da ka, ‘Ug-og ka,’ ay mippan ka impiyernu. ");
INSERT INTO isd_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ay díkod, nu rán ka la nga mangidde ka pamaanggam mu ke Dios, ay se mu la madamdam nga atán nagbasúlám kiya kasittolay mu ay, ");
INSERT INTO isd_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","panáwam pikam ya iddem ke Dios kiya agbasuwán se ka la mawe makikappiya kaggína. Ay se mu la idde ke Dios ya pamaanggam mu. ");
INSERT INTO isd_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ay nu atán mangidarum kikaw, ay karuwam ya makikappiya kiya mangidarum kikaw ki di pikam kàwa naya darum. Ata nu akkam pakunán, ay paayabán naka kadaya guwes, ay daya guwes ay iáwat daka kadaya pulis sen ibálud daka. ");
INSERT INTO isd_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ay ikagì kikaw nga akkan ka nga makalawán kitúni yin panda kiya agbáyad mu kiya ngámin na pagmultám gapu ki básul mu.” ");
INSERT INTO isd_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ay nagì-gìna nu pe yin nga nebílin pe kadaya tolay ya, ‘Akkan ka manaládag.’ ");
INSERT INTO isd_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ngamay ikagì kadakayu nga ya tolay nga nadakè ya lam-lamtan na kiya babay ya masingan na, ay dinaládag na ngin kiya ur-uray na. ");
INSERT INTO isd_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ay díkod, nu iya diwanán na matám ya mamagbásul kikaw, ay tukilam ta ippà mu. Ta napì-piya ngala ya atán kúráng naya baggim, may iya áwan kurakúráng may mippan ka ka impiyernu. ");
INSERT INTO isd_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ay páda na pe nu iya diwanán na ímam ya gapuwánan naya pakabasúlám. Ay pùdam ta ippà mu. Ata napì-piya ngala ya pukul may iya áwan kurakúráng naya baggim may mippan ka ka impiyernu.” ");
INSERT INTO isd_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ay nagì-gìna nu pe yin na nebílin kadatu tolay kitun nga nu iinna ya mangigsán kiya atáwa na, ay masápul la kuwaan na ya kasurátan naya panaggadi na. ");
INSERT INTO isd_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ngamay ikagì kadakayu, nga nu igsán naya laláki ya atáwa na, nga akkan wayya nakidaládag, ay mapabásul ya laláki kiya angngulis naya babay ya angngatáwa, áta mebíláng makidaládag tu babay. Ay ya laláki pe ya umatáwa kiya nagadiyán, ay bíláng na pe ya manaládag.” ");
INSERT INTO isd_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ay nagì-gìna nu pe yin nga nebílin kadatu in-inagkona ya, akkan kayu magsingán na magkari nu akkan nu tungpálan. Masápul la tungpálam daya nagsingánam ma nekarim ke Apu. ");
INSERT INTO isd_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ngamay ya ikagì kadakayu kídi yin, ay akkan kayu magsingán ki oray nágan na. Akkan nu pagsingánan ya lángit, áta ittu ya pangiturayán ne Dios. ");
INSERT INTO isd_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ay akkan nu pe pagsingánan ya kalawagán ta ittu ya bátug ga pagdadam-án na. Ay akkan nu pagsingánan ya Jerusalem ta ittu ya bíláng íli ne Dios nga katurayán na Ari. ");
INSERT INTO isd_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ay akkan nu pagsingánan ya baggi nu kampela ngin nin, áta akkan nu mapagbalin daya ngísit ta abù nu ka pusà onu daya pusà ka ngísit. ");
INSERT INTO isd_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ya kuwaan nu wala ay, ‘Ò’ nán nu wala nu ò, se ‘Akkan’ nán nu wala nu akkan. Ay nu magsingán kayu pikam mala, ay gayát yanin ke Sairu.” ");
INSERT INTO isd_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ay nagì-gìna nu pe yin na nebílin pe kitun na, nu kulápan naya isa tolay ya kasittolay na, ay masápul la kulápan da pe ka angngibálat da. Ay ummán pe nu ngípan ya mippà. ");
INSERT INTO isd_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ngamay ya nán ku kadakayu, ay akkan nu baltan daya mangwa ka nadakè kadakayu. Ay nu tappítan da ya diwanán na pàngit nu, ay pàpit nu pe ya tapíngit. ");
INSERT INTO isd_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ay ummán pe nu atán na mangidarum kadakayu ka pangalakkán na kiya bádu nu, ay bay-án nu nga alà na pikam ya diyáket nu. ");
INSERT INTO isd_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ay nu atán ya mangargador kadakayu ka isa nga kilumitru, ay itulbu nu ka tangakilumitru pikam. ");
INSERT INTO isd_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ay nu atán magadang kadakayu, ay iddán nu. Ay ummán pe nu atán ya umútáng kadakayu ay pautángan nu.” ");
INSERT INTO isd_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Nagì-gìna nu pe yin kitun ya, piyán nu daya kabbulun nu, ay kaguráan nu daya kumagúra kadakayu. ");
INSERT INTO isd_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ngamay ya ikagì kadakayu kídi, ay piyán nu daya kumagúra kadakayu. Ikar-karárag nu daya mamal-pallà kadakayu. ");
INSERT INTO isd_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ta senu mepassingan na dakayu daya kurug ga annánà ne Dios Ama nga atán ka lángit. Ata napádapáda nga pasinágan ne Dios daya namáru se daya nadakè, ay se paudanán na pe daya makammu kiya napiya se daya akkan. ");
INSERT INTO isd_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ata nu tittu daya maminya kadakayu daya piyán nu, ay áwan wayya nga supápà nga idde ne Dios kadakayu. Ay oray daya nadakè a magpab-pabáyad ka buis, ay piyán da pe daya maminya kaggída. ");
INSERT INTO isd_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ay páda na pe nu tittu wala daya maminya kadakayu daya atangyaan nu, ay akkan nu pakedayáwan yán, áta áwan nu dúma kadaya duddúma. Oray daya akkan makammu ke Dios, ay kuwaan da mà pe ya ummán kiyán. ");
INSERT INTO isd_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ay díkod áwan nu din lugud da pagkurángan, áta áwan pagkurángan naya Ama nu wa atán ka lángit,” nán ne Jesus kadatu tolay na. ");
INSERT INTO isd_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ay kiya angwa nu kadaya napiya, ay sin-sinnan nu wa akkan din ya agdáyaw daya tolay kadakayu ya lam-lamtan nu. Ata nu pakunán nu, ay akkan nakayu tangdánan naya Ama nu wa atán ka lángit. ");
INSERT INTO isd_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ay díkod, nu mangidde kayu ka pagkallà, ay akkan nu ibanábag nga ummán kiya kuk-kuwaan daya magpì-pìmáru. Ata nu mangidde da ka pagkallà, ay iban-banábag da kadaya sin-sinagoga se kadaya kal-kalsáda nga giyán daya tolay. Ata ya piyán dayán, ay dayáwan daya tolay da. Ikagì kadakayu wa dayán, ay nálà da ngin ya tangdán da kiya kinuwa da, ta dináyaw daya tolay da ngin. ");
INSERT INTO isd_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ay nu mangipalimus kayu, ay akkan nu ipak-pakammu ki oray iinna nga tolay, ");
INSERT INTO isd_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ta senu nasirù tu nangngipalimus nu. Ay ya Ama nu wa makasingan kadaya nasirù, ay aggína ya mangsupápà kadakayu.” ");
INSERT INTO isd_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ay ummán pe nu magkarárag kayu, ay akkan nu tal-taldan daya magpì-pìmáru. Ata dayán, ay pà-pàgan da ya magsisíkád da magkarárag kadaya sin-sinagoga, ay se kadaya bíkat kalsáda, ta senu masingan daya tolay da, ay pàgan dada. Ay ikagì kadakayu nga nagun-ud da ngin ya tangdán da ta pinatag daya tolay da ngin. ");
INSERT INTO isd_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ngamay nu magkarárag kayu, ay manggitap kayu kiya kuwartu nu se kayu wala nga magkarárag ke Ama nu wa akkan masingan. Ay ya Ama nu wa makasingan kadaya nasirù, ay aggína ya mangsupápà kadakayu. ");
INSERT INTO isd_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ay kiya agkarárag nu pe, ay akkan nu iduràmát ya adu wa úni nga áwan sur-surbi, nga ummán kiya angwa daya tolay ya magdáyaw kadaya sinan diy-diyos. Ta papáti da nu gìnán ne Dios da nu adu ya kag-kagiyan da kiya karárag da. ");
INSERT INTO isd_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Akkan nuda nga tal-taldan. Ata ammu naya Ama nu daya masápul nu, oray kiya akkan nu pikam ma aggadang kaggína. ");
INSERT INTO isd_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ay ummán kídi ya panagkarárag nu lugud: ‘Ama nga atán ka lángit, mepatag din ya kinaDios mu. ");
INSERT INTO isd_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ikaw din ya mangitur-turáy kadakami. Ay daya piyám mala din daya makurug kídi ya kalawagán nga ummán pe ki kàwa da ka lángit. ");
INSERT INTO isd_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ay iddán nakami din ka kanan mi kiya inalgaw. ");
INSERT INTO isd_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ay pakawanan nakami kadaya bas-básul mi, nga ummán pe kiya nammakawan mi kadaya nakabásul kadakami. ");
INSERT INTO isd_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Iadayyu nakami pe kadaya kepar-paroán mi se kadaya nadakè a mà-màwa,’ nán nu. ");
INSERT INTO isd_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ata nu pakawanan nu daya kasittolay nu kadaya nagbasúlán da kadakayu, ay pakawanan nakayu pe ya Ama nu wa atán ka lángit. ");
INSERT INTO isd_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ngamay nu akkan nu pakawanan daya kasittolay nu, ay akkan nakayu pe pakawanan ya Ama nu wa atán ka lángit.” ");
INSERT INTO isd_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ay nu magngílin kayu wa mangán gapu kiya agkar-karárag nu ke Dios, ay akkan nu ipassingan ki murang nu ya agngílin nu, nga ummán kiya kuk-kuwaan daya magpì-pìmáru. Gurátan da nga akkan kappiyánan ya singan da ta senu masingan daya tolay ya agngílin da, ay pàgan dada. Ikagì kadakayu wa nagun-ud da ngin ya tangdán da. ");
INSERT INTO isd_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ngamay nu magngílin kayu wa mangán (gapu ki agkar-karárag nu), ay mangípu se magid-idárup kayu. ");
INSERT INTO isd_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ay díkod áwan makammu wa magngílin kayu wa mangán. Tittu ya Ama nu wa akkan masingan ya makammu. Ay aggína pe ya mangsupápà kadakayu, áta aggína ngala ya makasingan kadaya nasirù a kuk-kuwaan nu.” ");
INSERT INTO isd_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Akkan nu ittu wa gamgam-gáman daya pagbànángan nu kídi kalawagán. Ata mabalin na dadàlan daya ul-ulullag dayán kídi onu magkíráng da onu takáwan daya mangraut kiya balay nu. ");
INSERT INTO isd_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ay ya urnúngan nu kuma, ay ya pagbànángan nu ka lángit. Ay áwan ul-ulullag nga mangdadál kitúni, ay akkan pe ya magkíráng, ay se áwan pe ya mangraut ta magtákaw. ");
INSERT INTO isd_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ata nu kawà naya giyán naya pagbànángan nu, ay ittu peyang pe ya giyán naya ur-uray nu.” ");
INSERT INTO isd_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ya mata ta, ay ittu ya bátug dílág naya baggi ta. Ay díkod nu nawada ya isissingan ta, ay mawadaán ngámin pe ya baggi ta. ");
INSERT INTO isd_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ngamay nu nadakè ya isissingan ta, ay ummán ta ka atán peyang kiya nagìbat. Ay lugud, nu rán nala nga ya nán tada nga dílág naya uray tada ay gìbat kammala ngin nin, ay nagìbat pà-pànang yán.” ");
INSERT INTO isd_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ay áwan asassu wa mabalin magasassu kiya duwa nga apu. Ata ya màwa, ay kalùsawan na ya isa, ay pàgan na ya isa onu ipatag na ya isa, ay irupat na ya isa kaggída. Ay ummán pe kiyán, akkan nu mapagpáda ya amminya nu ke Dios se ya amminya nu ki pirà. ");
INSERT INTO isd_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ay túya, ya nán ku kadakayu, ay akkan nu ittu wa paglídug daya pagbiyág nu. Akkan nu paglídug daya kanan nu se daya inuman nu onu daya pagkawas nu. Ata napà-patag ya biyág nu ngam daya ak-akakkanan. Ay ummán pe ya baggi nu, napatag may daya kawakawas. ");
INSERT INTO isd_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Sinnan nu kod daya an-anù. Akkan da mà magmul-múla dayán, ay akkan da pe maggáni, ay se akkan da pe wayya nga magùnud kadaya kanan da. Ngamay e Dios Ama nga atán ka lángit ya mamangán kaggída. Ay akkan wayya nga nabà-banor dayán ke Dios may dakayu. ");
INSERT INTO isd_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ay oray iinna kadakayu, ay akkan na mà wayya masulpítán ya biyág na oray nu maglídug. ");
INSERT INTO isd_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ay taanna, tura nu wa paglídug daya pagkawas nu? Sinnan nu kod daya but-bútà daya kaddat kiya kalawagán. Akkan magkuwa mà dayán na kaddat, ay akkan da pe ya magabal ka pagkawas da. ");
INSERT INTO isd_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ngamay kagiyan ku kadakayu, nga oray tu Solomon na nabànáng tutu wala kitun, oray napiya tutu wala datu kawakawas na, ay áwan na nga pinagkawas nga napì-piya may daya but-bútà dayán na kaddat. ");
INSERT INTO isd_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ay dayán na kaddat, ay makar-karu ya biyág dayán. Mabalin na sisinnán tada pikam dayán kídi, ay mabalin na matay dayanin kaláwa, ay sìdúgan dada ngin. Ay nu e Dios ya magpabútà kadayán na kaddat nga ittu ya bátug pagkawas da, ay tú nád agpà ya ammakawas na kadakayu! Inagkabittì naya angngurug nu kaggína! ");
INSERT INTO isd_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ay díkod, akkan kayu lugud da managlídug. Akkan nu nán na, ‘Nágan nád naya kanan mi?’ onu, ‘Nágan nád ya inuman mi?’ onu, ‘Nágan nád ya pagkawas mi?’ ");
INSERT INTO isd_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ay akkan nu din tal-taldan daya akkan mangurug ke Dios. Ata ittu dayán daya gamgam-gáman da. Ay ammu mà ne Dios Ama nga atán ka lángit nga masápul nu ngámin dayán. ");
INSERT INTO isd_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ngamay nu dakayu, ya masápul la kuwaan nu, ay lam-lamtan nu peyapeyang ya angngituráy ne Dios se ya ammagbalin na kadakayu ka namáru. Ay se na nga idde ngámin dedi ya masápul nu. ");
INSERT INTO isd_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ay akkan nu lugud paglídug daya mepanggap kadaya mà-màwa kaláwa. Kaláwa kampela ngin nin ya aglam-lammat ta kadayán. Anayan ta ngin daya parikut ta kiya isa ngalgaw.” ");
INSERT INTO isd_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Akkan kayu tagapab-pabásul lala kadaya kasittolay nu ta senu akkan nakayu pabasúlan ne Dios. ");
INSERT INTO isd_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ata nu wà ummán naya ammabásul nu kadaya kasittolay nu, ay ummán pe kiyán ya ammabásul ne Dios kadakayu. Ay nu nágan naya pagbasarán nu wa mamabásul kadaya kasittolay nu, ay ittu pe ya pagbasarán ne Dios kiya ammabásul na kadakayu. ");
INSERT INTO isd_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ay tura nu masingan ya bittì a púling naya kasittolay nu, may akkan nu màmud ya megugulad da púling nu kampela ngin? ");
INSERT INTO isd_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ay mapaanna lugud ya angnguna nu kiya kasittolay nu ka, ‘Ippà ku mán ya púling mu,’ nán nu, ay atán mà ya megugulad da púling nu? ");
INSERT INTO isd_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Magpì-pìmáru kayu nu mapakuna. Masápul la ippà nu pikam ya megugulad da púling nu, ta senu nawada ya isissingan nu kiya angngippà nu kiya bittì a púling naya kasittolay nu. ");
INSERT INTO isd_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ay akkan ta nga idde kadaya átu ya pinagbasu wa áyam, ta napatag ke Dios. Ta get tala pe nu kagatan dakayu. Ay ya búngut, ay akkan ta pe ya idde kadaya ábuy, áta dam-dam-án da ngala. Ay ummán pe akkan ta nga ipílit ibàbànán ya mepanggap kiya Napiya nga Dámag kadaya tolay ya mamáas.” ");
INSERT INTO isd_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Magadang kayu ke Dios, ay iddán nakayu. Nu e Dios ya pagsapúlán nu kadaya masápul nu, ay masmà nuda. Ay nu makilukát kayu pe kaggína ay ilukát nakayu. ");
INSERT INTO isd_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ata oray iinna nga magadang ke Dios, ay middán. Ay makasmà pe daya magsápul ke Dios se ilukát ne Dios ngámin daya makilukát kaggína. ");
INSERT INTO isd_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Iinna kadakayu wa ama ya mangidde ka batu kiya an-anà na nu magadang ka sinápay? ");
INSERT INTO isd_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Onu magadang ka sissida, ta iddán nu ka idaw? ");
INSERT INTO isd_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ay nu dakayu wa nadakè a tolay, ay ammu nu kam pe daya napiya nga idde nu kadaya annánà nu, ay tú nád agpà in ya angngidde naya Ama nu wa atán ka lángit kadaya napiya kadaya ngámin na magadang kaggína. ");
INSERT INTO isd_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ay nu nágan daya piyán nu wa kuwaan daya kasittolay nu kadakayu, ay ittu pe dayán daya kuwaan nu kaggída. Ata ittu idi ya kepapannán datu lin-lintag natu Moses se datu nesur-súru datu pagbàbànánan ne Dios kitun.” ");
INSERT INTO isd_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Abay ya gagyangán, ay se nalà-lapat ya dálen na mameyag kiya pakadadàlán ka áwan panda, ay adu manalen kiyán. Ngamay kuwaan nu ya kabailán nu wa lumnà kiya bittì a gagyangán. ");
INSERT INTO isd_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ata kurug ga bittì ya gagyangán, ay se nasulit ya dálen na mameyag kiya pakabiyágan ka áwan panda. Ay túya man-manu daya makasmà kiyán.” ");
INSERT INTO isd_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Atán daya magkuna nga pagbàbànánan ne Dios da, may busid da kammala ngin nin. Taronan nu dayán, ta umbet da kadakayu wa magpìduman na namáru da, ngamay ya kinur-korugán, ay mangdadál ya ung-unggan dayán. ");
INSERT INTO isd_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ngamay mammuwán nu dayán kiya kuk-kuwaan da. Ata akkan ta mà wayya mabúrás ya búnga úbás kadaya panda ngala nga lásiw. Ay ummán pe kiya búnga nga gígus, akkan ta pe wayya nga mabúrás kadaya kad-kaddat tala. ");
INSERT INTO isd_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Gángay nga daya napiya nga káyu, ay magbúnga ka napiya pe. Ay ummán pe kadaya nadakè a káyu, ay gángay nga nadakè pe ya búnga dayán. ");
INSERT INTO isd_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ata ya napiya nga káyu, ay akkan wayya nga magbúnga ka nadakè. Ay ya nadakè a káyu, ay akkan pe wayya nga magbúnga ka napiya. ");
INSERT INTO isd_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ay díkod, ngámin daya káyu wa maddi magbúnga ka napiya, ay màpu da, ay se da nga masìdug. ");
INSERT INTO isd_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ay díkod, mammuwán nu daya magpìduman na pagbàbànánan ne Dios, gapu kadaya kuk-kuwaan da.” ");
INSERT INTO isd_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ay akkan ngámin daya magkuna ka, Apu, Apu kiyà, ay málà kiya pangiturayán ne Dios. Ata tittu daya mangwa kadaya piyán ne Dios Ama nga atán ka lángit daya málà. ");
INSERT INTO isd_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ay nu iya muddi ya algaw, ay adu daya akkan málà kiya pangiturayán ne Dios nga magkuna kiyà nga, ‘Apu! Apu, nebàbànán mi mà ya Napiya nga Dámag gapu kiya pannakabalin mu. Ay nagpatálaw kami kadaya áran kadaya tolay gapu ki kinaturáy mu. Ay se adu pe daya nakas-kasdáaw wa kinuw-kuwa mi gapu ki pannakabalin mu,’ nán da. ");
INSERT INTO isd_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ay nán ku wala kaggída nga, ‘Akkan takayu am-ammu. Magtálaw kayu! Dakayu wa nadakè a kuk-kuwaan na tolay,’ nán ku kaggída.” ");
INSERT INTO isd_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ay ngámin lugud daya manggìna kadedi ya kag-kagiyan ku, se da nga kuwaan pe, ay meárig da kiya nasírib ba tolay ya nagbalay ki pidtà. Nekorob na daya adígi ka adallam. ");
INSERT INTO isd_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nagudán ka naggat, ay díkod nalnap tu balay, ay se nabaliyán ka naggat pe. Ngamay akkan na nìlang tu balay, áta naligda lugud ya nekàwa na. ");
INSERT INTO isd_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ngamay ngámin daya makagìna kadedi ya kag-kagiyan ku, ay se akkan da nga kuwaan, ay meárig da kiya ang-ang nga nagbalay kiya karagintán. ");
INSERT INTO isd_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ay kane magudán ka naggat se malnap, ay se mabaliyán pe tu balay na, ay nìlang ngala. Ay natar-tarawesáng tutu wala tu balay kane marba,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ay kane mabalin nge Jesus nga nangagi kadatun nin, ay nasdaáwan pànang datu adu wa tolay kitu inagtùgud na, ");
INSERT INTO isd_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","áta naturáy kitu angngisúru na kaggída, nga akkan ummán kadatu angngisúru datu maragtùgud ki lintag. ");
INSERT INTO isd_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ay kane managut te Jesus, ay adu tutu wala datu tolay ya gummunud kaggína. ");
INSERT INTO isd_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ay se yala nga uwad naglappang nga inumbet, ay se nagpalintud da nakim-imallà kaggína nga nán na, “Apu, nu piyán nà ala nga agásan ay maagásan nà,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ay tútu inimmán ne Jesus, ay se na nán kaggína, “Saay, pumiya ka lugud din,” nán na. Ay tútu dágus sala nga pummiya ngin tu baggi natu naglappang. ");
INSERT INTO isd_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ay nán ne Jesus nga namílin kaggína, “Akkam kag-kagiyan idi ki oray iinna. Ngamay mangaw-át ka ngin na magpassingan kitu pádi, ay se ka la mangidátun ke Dios ka ummán kitu nebílin natu Moses, ta senu mepassingan kadaya tolay nga naagásan ka ngin,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ay se yala nameyag ge Jesus ka Capernaum. Ay kane din na makadatang kitúni, ay uwad iRoma nga kapitán daya suldádu wa inumbet ta nakim-imallà kaggína. ");
INSERT INTO isd_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ay nán na, “Apu, sengán nà mán, ta ya asassu ku wa laláki, ay atán ka balay ya mapar-parigátan pànang. Ay magdapepe yin gapu kiya sinakit na,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ay nán ne Jesus, “Mawe yà lugud agásan,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ngamay nán natu kapitán kaggína, “Apu, akkan ka tagge mawe ka balay ta áwan ku wa kekariyán na manangaíli kikaw kiya balay ku. Annung na ngin ya angngagim ma bumílag ya asassù. ");
INSERT INTO isd_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ata iyà ay atán mangituráy kiyà, ay se atán pe daya suldádu wa itur-turayán ku. Ay túya ammù ya mepanggap kiya kinaturáy. Ata nu nán ku kiya isa suldádu nga, ‘Mawe ka kannán,’ ay mawe kurug. Ay nu nán ku pe kiya isa nga, ‘Umbet ka kídi,’ ay umbet pe kurug. Ay páda na pe kiya asassù. Nu, ‘Kuwaam idi,’ nán ku kaggína, ay kuwaan na kurug,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ay nasdaáwan ne Jesus kane magìna na tun. Ay nán na kadatu gumun-gunud kaggína, “Ikagì kadakayu, nga kurug ga áwan ku pikam nammuwán na ummán kídi ya angngurug oray kadaya iIsrael. ");
INSERT INTO isd_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ay ikagì pe kadakayu nga adu daya maggagayát kadaya ngámin giyán kídi kalawagán nga mepaggan-gánas kiya pangiturayán ne Dios kade Abraham se Isaac se Jacob. ");
INSERT INTO isd_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ngamay daya Judyu wa aggída kuma ya makin-kuwa kiya pangiturayán ne Dios, ay aggída ya mippan kiya nagìbat pànang nga giyán. Kitúni ay sumángit da, ay se magngar-ngarasiyat da,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ay se na nán kitu kapitán datu suldádu, “Mawe ka ngin. Ay ya kurugam nga màwa, ay ittu kurug ya màwa,” nán na. Ay tu asassu natu kapitán, ay bumílag kurug kitun mà ala nga oras. ");
INSERT INTO isd_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ay kane mawe ye Jesus ka balay de Pedro, ay dinatang na tu katugángan ne Pedro nga magdagáng. ");
INSERT INTO isd_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ay inimmán na tu íma na, ay tútu bummílag kammin. Ay díkod bummángun, ay se aggína ngin tu namangán kaggída. ");
INSERT INTO isd_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ay kane din gabi yin, ay nilbetán datu tolay ke Jesus datu adu wa naar-aránan. Ay kiya úni na ngala, ay pinataláwan na datu áran kaggída, ay pinabílag na ngámin pe datu magtatakit. ");
INSERT INTO isd_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ay gapu kadedi ya kinuw-kuwa na, ay nàwa nga kurug tu kinagi natu Isaias sa pagbàbànánan ne Dios kitun nga, “Nippaán na daya sad-sadúra tada, ay se inagásan na daya sin-sinakit tada,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ay kane masingan ne Jesus datu adu pànang nga tolay, ay pinagbatta na datu tù-tùgúdán na. ");
INSERT INTO isd_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ay se yala uwad da magtù-tùgud ki lintag ga inumbet, ay se na nán ke Jesus, “Misturu, kumíwid dà kikaw oray kawà na ya pam-pameyaggám,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ay nán ne Jesus kaggína, “Daya buwat, ay atán abbut da, ay daya an-anù, ay atán dápun da, ngamay nu iyà a nengágan da kitun ka An-anà Tolay, ay áwan ku wa makagi nga balay ku wa aggimangán ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ay nán pe natu isa kadatu tolay na, “Apu palubúsán nà pikam ta mawe yà itaman tu ama ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ngamay nán ne Jesus kaggína, “Daya meárig ka natay daya pakammuwan mu la ngin kiya minatay da kampela ngin. Ngamay ikaw, ay kumíwid ka kiyà,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ay kane magtakay ye Jesus kitu biray, ay nagtakay pe yin datu tolay na. ");
INSERT INTO isd_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ay kane magbatta da ngin, ay pagkìlát da ngala nga nagbáli ka naggat pànang. Ay natalabtabbán da kadatu bal-balnag. Ngamay e Jesus, ay natalà ala. ");
INSERT INTO isd_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ay nawe da linukág ga nán da kaggína, “Apu sengán nakami ta malimat tada ngin,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ay nán na kaggída, “Taanna, tura kayu magansing ta! Inagkabittì naya angngurug nu ta!” nán na. Ay se yala bummángun se na nga pinakusap tu báli, ay se na pinalanay datu bal-balnag. Ay díkod napiya tutu wala ngin tu kalawagán. ");
INSERT INTO isd_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ay tútu nasdaáwan da ngámin nga nán da, “Nágan nád naya kinatutolay nedi ta! Ta oray báli se danum, ay ikurug da,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ay kane din na makadatang da ka dammáng, ka Gadara, ay uwad duwa nga naar-aránan na summabat kaggína. Naggayát da kitu kalubúán. Nakapap-panansing da ta narungat da pànang, ay tútu áwan maketurad da manalen kitúni nga dálen. ");
INSERT INTO isd_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ay nán da nga nesar-sáraw, “Ikaw wa An-anà ne Dios, nágan naya kuwaam kadakami? Inumbet ka nga mamarígát kadakami ta, oray akkan pikam ma itu oras mi?” nán da. ");
INSERT INTO isd_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ay kitu akkan adayyu pànang kitúni, ay uwad da adu wa ábuy ya magsabbù. ");
INSERT INTO isd_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ay nakim-imallà datu áran ke Jesus nga nán da, “Nu pataláwan nakami, ay papannan nakami agpà ala ngin kadatu ábuy yi,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ay nán ne Jesus kaggída, “Mawe kayu lugud,” nán na. Ay tútu nagtálaw da kadatu tolay, ay se da magunag kammin kadatu ábuy. Ay nagtatagtág datu ábuy ya nameyag kitu tappáng. Ay nepaspáw da, ay se da nga nepisù kitu pisung. Ay tútu nalimat da ngámin. ");
INSERT INTO isd_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ay datu tolay ya magtar-tarakan kadatu ábuy, ay nagkakápan da kitu íli. Ay nedámag da tu nàwa, ay oray pe tu nàwa kadatu naar-aránan. ");
INSERT INTO isd_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ay díkod adu datu nawe naningan ke Jesus. Ay kane masingan da nge Jesus, ay nakim-imallà da kaggína nga magtálaw kuma kitu íli da. ");
INSERT INTO isd_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ay tútu nagtakay ye Jesus kitu biray, ay se da nga nagbatta nga mawe ka íli na kampela ngin nin. ");
INSERT INTO isd_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ay se yala uwad da nga tolay nga nangilbet ka magdapepe nga nepipidda. Ay kane mammuwán ne Jesus nu wà ummán natu angngurug da, ay nán na kitu magdapepe, “Akkan ka malídug, ugu! Ta napakawan ka ngin kadaya bas-básul mu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ay díkod, datu duddúma nga maragtùgud ki lintag, ay nán da kitu isaisa kaggída, “Tura ipáda nedi ya tolay ya baggi na ke Dios!” nán da. ");
INSERT INTO isd_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ngamay gapu ta nammuwán ne Jesus tu lammat da, ay nán na kaggída, “Tura nadakè ya uray nu ta! ");
INSERT INTO isd_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mabalin na nán nu wa nalapat tala nga kagiyan kiya tolay ya, ‘Napakawan ka ngin kadaya bas-básul mu,’ ta akkan masápul ya pakasinnán, may iya, ‘Bumángun ka, ay se ka la manalen!’ ");
INSERT INTO isd_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ngamay pabilgan ku ya magdapepe ta senu mammuwán nu wa iyà nga nengágan da kitun ka An-anà Tolay, ay atán turáy ku kídi ya kalawagán nga mamakawan kadaya bas-básul,” nán na. Ay díkod, tútu nán na kitu magdapepe, “Bumángun ka! Alà mu ya idda mu, ay se ka la nga mawe ka balay nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ay bummángun kurug tu tolay se la nga nawe ka balay da. ");
INSERT INTO isd_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ay kane masingan datu adu wa tolay tu nàwa, ay nasdaáwan da pà-pànang. Dinay-dáyaw da nge Dios gapu kitu inangngidde na kitu ummán kitun na pannakabalin kiya isa nga tolay. ");
INSERT INTO isd_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ay nagtálaw we Jesus kitúni. Ay kitu agdal-dalen na, ay nasingan na nge Mateo. Atán na magtutúgaw kitu aggubraán na nga pagbay-bayádán da ka buis. Ay nán na kaggína, “Kumíwid ka kiyà,” nán na. Ay kummíwid kurug gin kaggína. ");
INSERT INTO isd_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ay kane atán ne Jesus sa magtutúgaw kitu giyán tebol la mangán, ay inumbet datu adu wa magpab-pabáyad ka buis se datu maragbas-básul. Ay nepangán da kade Jesus se datu tù-tùgúdán na. ");
INSERT INTO isd_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ay kane masingan datu Pariseo da, ay nán da kadatu tù-tùgúdán ne Jesus, “Taanna, tura meduwa ya misturu nu wa mangán kadaya magpab-pabáyad ka buis sa nadakè se kadaya maragbas-básul?” nán da. ");
INSERT INTO isd_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ay nagìna ne Jesus tun, ay tútu aggína ya summungbát ta nán na, “Akkan ittu daya magkuna nga nabílag da daya makasápul kiya duktor, nu di daya makammu wa magtakit da,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","“Ay anágan nu kod ya kepapannán naya nesúrát ta bàbànán ne Dios nga nán na kídi, ‘Ya agkallà nu kadaya kasittolay nu ya napatag kiyà, akkan daya dátun nu kiyà,’ nán na. Ata iyà, ay akkan nà gummákat ta magayáb kadaya manguna nga namáru da, nu di daya mamigbig ga maragbásul da,” nán ne Jesus kadatu Pariseo. ");
INSERT INTO isd_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ay inumbet pe ke Jesus datu tù-tùgúdán ne Juan na marammawtisár nga nagsaludsud nga nán da, “Taanna, tura kami ya nakírad da magngílin mangán se daya Pariseo gapu ki agkar-karárag mi ke Dios, ngamay akkan kid kadaya tù-tùgúdán mu?” nán da. ");
INSERT INTO isd_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ay nán ne Jesus kaggída, “Magngílin mangán kadi daya sangaíli kiya aggaattawán nu kabul-bulun da ya mangatáwa? Ngamay umbet ya algaw wa ummawan kaggída ya mangatáwa, ay ittu yanin ya agngílin da nga mangán,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ay áwan ya mangìpit ka bar-baru wa lúpus kiya rugrugà. Ata nu mapakuna, ay se kumsan tu bar-baru wa pinagappit, ay umabay ya pìsi na. ");
INSERT INTO isd_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ay áwan pe ya mangippáy ka apammási ya bási kiya nausár rin na lálat ta aggippayán ka bási, ay se na nga laptan. Ata nu pakunán na, ay mabtà ya aggippayán ka bási. Ay madadál tu aggippayán ay madadál pe tu bási. Masápul la ya bar-baru wa lálat ta aggippayán ka bási ya kippayán naya apammási kampela ngin nin ta senu napiya ya kàwaán da,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ay kitu angngag-kagi pikam ne Jesus kadedi kaggída, ay uwad ap-apu ki sinagoga nga inumbet. Ay nagpalintud da nakim-imallà kaggína nga nán na, “Atattay tu babbalásang ku, ay mawe ta agpà ka balay ta immanam ta senu lumtu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ay tútu ginumnikát te Jesus se la nga mawe yin. Ay kumíwid pe datu tù-tùgúdán na. ");
INSERT INTO isd_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ay uwad kitúni pe ya babay ya sangapúlu se duwa dagun na ngin na magdága. Nawe kitu likud ne Jesus se na 'we tùbítan tu arumaymáy natu bádu na. ");
INSERT INTO isd_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ata nán na kitu lammat na nga, “Maagásan nà a nán ku nu matùbit ku wala ya bádu na,” nán na kampela ngin nin. ");
INSERT INTO isd_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ay nasingan ne Jesus kane maglingay, ay tútu nán na kaggína, “Akkan ka malídug gin, ta naagásan ka ngin gapu ki angngurug mu,” nán na. Ay dágus sala nga naagásan tu babay yin. ");
INSERT INTO isd_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ay kane dummatang nge Jesus kitu balay natu ap-apu, ay dinatang na datu adu wa tolay ya magmanakit se datu marammalíing nga mamulun nu magtal-ud da. ");
INSERT INTO isd_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ay nán ne Jesus kaggída, “Magtálaw kayu pikam, ta akkan wayya natay ya an-anà. Matúdug gala yán,” nán na. Ngamay pináas da. ");
INSERT INTO isd_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ay kane mapalawán na datu adu wa tolay yin, ay linumnà ay se na immán tu íma natu an-anà. Ay dágus sala nga linumtu. ");
INSERT INTO isd_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ay idi ya nàwa ay newar-waragáwag kadatu ngámin giyán kitúni. ");
INSERT INTO isd_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ay kane din na magtálaw we Jesus kitúni nga íli, ay uwad duwa nga lalláki nga kúláp pa umun-unud kaggína. Ay nán da nga nekar-karraw, “Gaka natu David, kalakkán nakami agpà!” nán da. ");
INSERT INTO isd_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ay kane linumnà kitu balay, ay dinatang datu duwa nga kúláp. Ay tútu nán ne Jesus kaggída, “Mangurug kayu nga màwà dayán?” nán na. Ay “Ò, Apu,” nán da nga nesungbát. ");
INSERT INTO isd_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ay díkod, tútu inimmán na datu mata da se na nán, “Ay màwa ngin kadakayu ya piyán nu gapu ki angngurug nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ay tútu makasingan da ngin. Ay binil-bílin nada nga kinappiya nga nán na, “Akkan nu wa ikag-kagi idi ki oray iinna,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ngamay kane magtálaw da kitu balay, ay newar-waragáwag da mán kammin ya mepanggap ke Jesus kadatu ngámin tolay kitúni nga giyán. ");
INSERT INTO isd_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ay kitu likud da ngin, ay uwad nilbet da ke Jesus nga pinagúmal áran. ");
INSERT INTO isd_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ay kane pataláwan ne Jesus tu áran kitu tolay, ay nakapagúni yin. Ay díkod nasdaáwan datu adu wa tolay. Ay nán da, “Awan tada pikam ma nasingan na ummán kídi ya mà-màwa kanedi Israel!” nán da. ");
INSERT INTO isd_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ngamay nán datu Pariseo, “Mapatálaw na daya áran, áta ya apu daya áran ya nangidde kaggína ka turáy na nga mamatálaw kadayán,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ay nagdàdàdà e Jesus kadatu ngámin il-ileli se babbabalay kitúni nga nagtù-tùgud kadatu sinagoga da. Ay nebàbànán na pe ya Napiya nga Dámag mepanggap kiya angngituráy ne Dios, ay se inag-agásan na pe datu ngámin na sin-sinakit se sad-sadúra datu tolay. ");
INSERT INTO isd_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ay kane masingan na datu adu wa tolay kitu nagdàdàdà na, ay nakalakkán kaggída, áta mapà-paultu da se kù-kùlelà da. Ay ummán da ka karneru wa áwan na magtar-tarakan. ");
INSERT INTO isd_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ay se na nga nán kadatu tù-tùgúdán na, “Adu daya magáni ngamay bittì daya maggáni. ");
INSERT INTO isd_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ikarárag nu lugud ke Dios sa makin-kuwa kadayán na tolay nga mangiparob din nin ka maganannay kaggída,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ay inayabán ne Jesus datu sangapúlu se duwa nga tù-tùgúdán na, ay se nada iddán ka turáy da nga mamatálaw kadaya ar-áran se niddán nada pe ka pannakabalin da nga mangágas kadaya ngámin na sin-sinakit se sad-sadúra. ");
INSERT INTO isd_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ay tú dedi datu ngag-ngágan datun na sangapúlu se duwa nga tù-tùgúdán na. Munna nge Simon na nengágan da pe ka Pedro, nge Andres nga wagi na, de Santiago se Juan na magwagi nga annánà ne Zebedeo. ");
INSERT INTO isd_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Nge Felipe, nge Bartolome, nge Tomas, ay se nge Mateo nga magpab-pabáyad ka buis. Nge Santiago nga an-anà ne Alfeo, nge Tadeo, ");
INSERT INTO isd_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","nge Simon na nepangágan da pe ka Cananeo, se tu Judas Iscariote nga ittu tu namatiliw ke Jesus. ");
INSERT INTO isd_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ay binílin ne Jesus dedi ya sangapúlu se duwa. Nebon nada nga magbàbànán. Ay tú idi tu bílin na kaggída, “Akkan kayu wa maw-awe kiya íli daya akkan Judyu, se kadaya iSamaria. ");
INSERT INTO isd_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ngamay mawe kayu wala kadaya iIsrael la árig karneru wa nagaw-awagwag. ");
INSERT INTO isd_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ay mawe nu ibàbànán kaggída ya napiya nga dámag. ‘Tagay yin ya angngituráy ne Dios,’ nán nu. ");
INSERT INTO isd_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pabilgan nu daya magtatakit se mamaltu kayu pe kadaya natay, ay se mangágas kayu pe kadaya maglappang. Ay magpatálaw kayu pe kadaya áran kadaya naar-aránan. Awan nu wa binayádan kiya kabailán nu wa mangwa kadayán, ay túya akkan kayu pe ya makitangdán kadaya kuwaan nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Akkan kayu wa magtag-tagipirà oray isa nga sintábu. ");
INSERT INTO isd_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ay akkan kayu pe ya magtagiannupútán se magtagiaglilíyán. Ay akkan kayu wa magtagisapátus onu magtagitàdukud. Ata daya pagubraán nu daya makammu kadaya masápul nu. ");
INSERT INTO isd_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ay nu dumatang kayu kadaya il-íli se daya babbabalay, ay sumápul kayu ka mayát ta manangaíli kadakayu. Ay mepagyán kayu kaggída panda kiya agtálaw nu kiyán na íli. ");
INSERT INTO isd_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ay nu lumnà kayu kiya balay da, ay nán nu, ‘Napiya din ya ur-uray nu wa tangabalay,’ nán nu. ");
INSERT INTO isd_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ay nu sangailiyan dakayu daya bumalay, ay napiya kaggída, ngamay nu akkan, ay dakayu kampela ngin nin ya magkapiya kiya kagiyan nu. ");
INSERT INTO isd_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ay nu rán nala nga atán balay onu íli ya mangagáwa kadakayu onu akkan manggìna kadakayu, ay sap-sapuwán nu daya tápù kadaya bingil nu se kayu wala magtálaw kiyán na balay onu íli. ");
INSERT INTO isd_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ay ikagì kadakayu wa kurug ga an-annung na kam ya ammánis ne Dios kadaya iSodom se iGomorra ngam ya ammánis na kadaya tolay kiyán na íli,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Dam-damdamman nu wa árig nu daya karneru wa ipàrob ku kadaya alsádu nga ul-ulolag ga magasikkán kaggída. Ay túya magsírib kayu nga ummán kadaya idaw, ay se magdínang kayu nga ummán kadaya kalapáti. ");
INSERT INTO isd_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ay taronan nu dayán na nadakè a tolay áta tú dayán daya mangippan kadakayu kadaya pagbustigarán da kadaya sinagoga da, ay se dakayu pe ya sap-saplit. ");
INSERT INTO isd_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ay ippan dakayu pe kadaya gubernador se kadaya à-ári nga pabustigár gapu kiyà. Ay ikagi nu daya kurug mepanggap kiyà kaggída, ay se kadaya akkan Judyu. ");
INSERT INTO isd_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ay kiya angngipabustigár da kadakayu, ay akkan nu wa paglídug nu nágan daya kagiyan nu onu mapaanna ya angngagi nu. Ata daya masápul la kagiyan nu, ay mepakammu da ngala ngin nu itu oras na. ");
INSERT INTO isd_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ay akkan nu wayya nga uray kampela ngin nin ya ikagi nu, áta ya Ispiritu ne Dios nga Ama nu ya makin-úni kadaya iúni nu. ");
INSERT INTO isd_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ay papatay pe daya tolay daya wawwági da kampela ngin nin. Ay ittu pe ya kuwaan daya ama kadaya an-annánà da. Ay kalùsawan daya annánà daya mannákam da se dada papatay. ");
INSERT INTO isd_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ay kalùsawan dakayu daya tolay gapu kiya angngurug nu kiyà. Ngamay ngámin daya maketurad kiyán panda kiya panda na, ay tú dayán daya meráman kiya pangiturayán ne Dios. ");
INSERT INTO isd_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ay nu pal-palakkan dakayu kiya isa nga íli, ay magalit kayu kiya isa. Ata kagiyan ku tutu wala kadakayu nga akkan nu pikam ma nangngayán daya ngámin na il-íli kídi Israel, ay atán nà kammin nin nga nengágan da kitun ka An-anà Tolay.” ");
INSERT INTO isd_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ya magsur-súru, ay akkan wayya nga nangátu may iya mangisúru kaggína. Ay ummán pe ya asassu, akkan wayya nga nangátu may iya apu na. ");
INSERT INTO isd_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Annung na nga mepáda ya magsur-súru kiya mangisúru kaggína, ay ummán pe kiyán kiya asassu se ya apu na. Ay díkod nu Beelzebub ya agpangágan daya tolay kiyà nga Apu nu, ay innanamán nu wa natù-turù ya pamàyanán da kadakayu ta pasúrut takayu wala. ");
INSERT INTO isd_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ay túya akkan kayu wa magansing kaggída, áta áwan wayya nesir-sirù a di mepassingan, ay áwan pe ya akkan da ipak-pakammu wa di mepakammu. ");
INSERT INTO isd_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ay ngámin daya isur-súrù kadakayu kampela ngin nin se daya iar-aratát ku, ay ibàbànán nu kadaya ngámin tolay. ");
INSERT INTO isd_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ay akkan kayu wa makan-ansing kadaya magasippatay kadakayu, áta tittu ya baggi ya mabaal da nga patayan. Akkan da nga mapatay ya kaduduwa nu. Ay ya rabbang na nga ikansing nu, ay ya atán pannakabalin na nga mamatay se mangiimpiyernu. ");
INSERT INTO isd_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Daya ballit, ay akkan da nga nabanor, áta makagátang ta ka duwa kaggída ka busait tala. Ngamay áwan mà kaggída ya matay nu akkan na uray ne Dios nga Ama nu. ");
INSERT INTO isd_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ay oray ya abù nu, ay ammu na ya bíláng na, áta am-ammu nakayu pànang. ");
INSERT INTO isd_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ay túya akkan kayu wa magansing ta napà-patag kayu kaggína may oray adu kadayán na an-anù. Awan màwa kadakayu wa akkan na uray ne Ama,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ay ngámin daya mangipakammu kadaya tolay nga iyà ya Apu da, ay tú dayán daya ikagì nga tolay ku ke Ama nga atán ka lángit. ");
INSERT INTO isd_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ngamay nu iinna ya mangituláyaw kiyà kadaya tolay, ay rabbang na nga ituláyaw kuda pe kiya Amà nga atán ka lángit.” ");
INSERT INTO isd_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Akkan nu nán nga ya gapu naya nelalbet ku, ay mangidde ka napiya nga panagbubúlun daya ngámin tolay. Ata ya nelalbet ku, ay ittu ya panggayatán daya tolay nga magsisibna ka uray. ");
INSERT INTO isd_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ata gapu kiya nelalbet ku, ay màwa nga: Ya an-anà a laláki ay kaguráan na ya ama na, ay se ya an-anà nga babay ay kaguráan na pe ya ina na, ay se magkagúra pe daya magkatugángan na babbay. ");
INSERT INTO isd_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ay màwa pe, nga ya kagúra naya isa nga tolay, ay daya akkobung na kampela ngin nin. ");
INSERT INTO isd_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ay akkan rumbang nga makiapu kiyà daya tolay ya tú dala pà-pàgan daya ama da se ina da may iyà. Ay ummán pe kadaya tolay ya pà-pàgan da daya annánà da may iyà. ");
INSERT INTO isd_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ay akkan pe rumbang nga makiapu ya isa nga tolay kiyà nu akkan na nga iturad daya kapal-palakkán na gapu kiyà se nu akkan na mebulun peyang kiyà. ");
INSERT INTO isd_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ay daya magkikenga kiya biyág da kídi ya kalawagán, ay killotán da ya biyág ga áwan panda. Ay daya makiránud gapu kiyà, ay tú dayán daya middán ka biyág ga áwan panda.” ");
INSERT INTO isd_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ay nu iinna ya manangaíli kadakayu, ay bíláng iyà ya sinangaíli da, ay daya manangaíli kiyà, ay bíláng nga sinangaíli da ya nangibon kiyà. ");
INSERT INTO isd_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ay daya manangaíli kiya pagbàbànánan ne Dios gapu ta ammu da nga pagbàbànánan ne Dios da, ay mepáda ya tangdán da kitu tangdán tu pagbàbànánan ne Dios. Ay ummán pe kadaya manangaíli kadaya namáru wa tolay gapu ta ammu da nga namáru da, ay mepáda ya tangdán da kiya tangdán tu namáru wa tolay nga sinangaíli da. ");
INSERT INTO isd_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ay oray iinna ya sumeng kadaya áwan sáasáad da tolay ku, oray ya mangidde ka danum mala kaggída, ay akkan wayya nga di magun-gunaán,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ay kane mabalin ne Jesus sa mamílin kadatu sangapúlu se duwa nga tù-tùgúdán na, ay nawe nagtùgud se nagbàbànán kadatu il-íli nga adanni kitúni. ");
INSERT INTO isd_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ay kane magìna natu Juan na marammawtisár nga atán kitu agbalúdán datu kuk-kuwaan naya Cristo, ay nangipàrob kadatu tù-tùgúdán na ke Jesus. ");
INSERT INTO isd_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ay nán da ke Jesus, “Ikaw win kanu tu nekar-kari kadakami nga umbet onu atán pikam sabáli nga idaggán mi,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ay, “Magulli kayun ta ikagi nu ke Juan ngámin daya nag-agìna nu se nas-asingan nu,” nán ne Jesus kaggída. ");
INSERT INTO isd_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","“Daya kúláp ay makasingan da ngin, ay makadalen pe yin daya pílay, ay se naagásan pe yin daya maglappang. Makagìna pe yin daya bangngag, ay napaltu pe yin daya natay, ay se nebàbànán pe yin ya Napiya nga Dámag panggap ki angngituráy ne Dios kadaya nakal-allà. ");
INSERT INTO isd_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ay kagiyan nu pe kaggína nga, maganggam daya tolay ya akkan maduw-duwa kiyà,” nán na kadatu tù-tùgúdán ne Juan. ");
INSERT INTO isd_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ay kane likud da ngin, ay nagbàbànán ne Jesus kadatu adu wa tolay ka mepanggap ke Juan nga nán na, “Kitu inannatang nu ke Juan ka ir-ir-er, nágan natu nawe nu siningan? Datu pattáw wa sal-saluysoyán naya bal-báli? ");
INSERT INTO isd_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ay nágan na lugud ya we nu siningan kitúni? Tolay ya nakabádu ka napiya? Daya tolay ya napiya ya bad-bádu da, ay balay ári ya pag-agyanán da. ");
INSERT INTO isd_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ay tura kayu lugud da nawe? Nágan lugud tu nawe nu siningan kitu ir-ir-er? Isa nga pagbàbànánan ne Dios tu we nu siningan? Kurug yán, ta nán ku kadakayu wa nadà-dáyaw may daya kadúwán na pagbàbànánan ne Dios nge Juan. ");
INSERT INTO isd_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ata e Juan ya kepapannán datu nesúrát ta kinag-kagi natu pagbàbànánan ne Dios kitun, nga nán na, ‘Gìnám ya kagiyan ku. Mangibon nà ka pagbàbànánan ku nga maginunna kikaw, nga mamagsagána kadaya tolay kiya ilalbet mu,’ nán na.” ");
INSERT INTO isd_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Ay kagiyan ku kurug kadakayu nga kadaya ngámin tolay, ay áwan pikam neanà a mebíláng nga nangátu may e Juan na marammawtisár. Ngamay oray daya áwan sáasáad da meráman kadaya iturayán ne Dios, ay bíláng nga nangà-ngátu da may e Juan. ");
INSERT INTO isd_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ay nanggayát kitu inagbàbànán ne Juan, ay makiranut daya adu wa tolay ya maminya tutu wala nga meráman kiya pangiturayán ne Dios, ay oray pe daya nadakè. ");
INSERT INTO isd_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ata datu nesur-súrát tu Moses se datu duddúma nga pagbàbànánan ne Dios ya nangipakammu kiya mepanggap kiya angngituráy ne Dios panda kitu nelaltuwád ne Juan. ");
INSERT INTO isd_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ay nu piyán nu wa awátan ya piyán ku wa kagiyan, tu bátug Elias nga nán datu pagbàbànánan ne Dios kitun nga umbet, ay e Juan kam. ");
INSERT INTO isd_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ay dakayu wa makagìna kadedi, ay lam-lamtan nu pànang daya magìna nu,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ay nán na manin, “Nágan nád naya pangiarígán ku kadakayu wa tolay kídi ya al-algaw? Iárig takayu kadaya annánà kiya amuwág ga mepagkagkagu kadaya duddúma nga annánà. Ay nán da kadakayu daya kakagkagu nu. ");
INSERT INTO isd_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Magtukár kami ta magsála kayu,’ nán da may maddi kayu mà magsála. Ay, ‘Magkansiyon kami ka nakùkùlelà,’ nán da, may maddi kayu pe ya sumángit. ");
INSERT INTO isd_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Tú dayán ya árig nu ta akkan ta ammu ya piyán nu. Ata inumbet te Juan na maddi mepangán se maddi mepaginum, ay nán nu wa naar-aránan. ");
INSERT INTO isd_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ay kane inumbet tà a nengágan da kitun ka An-anà Tolay, ay se yà a mepangán se maginum, ay nán nu manin nga, ‘Sinnan nu kod ya tolay kiyán! Maglin-linát se maging-inglaw!’ nán nu. ‘Bungguy na daya magpab-pabáyad ka buis nga nadakè se daya maragbas-básul,’ nán nu. Ngamay oray nu ummán, ay mepassingan na kurug ya kinasírib ne Dios gapu kadaya napiya nga mà-màwa,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ay se yala inal-alngán ne Jesus datu tolay kadatu il-íli nga nangipassingannán na kadatu adu wa nakas-kasdáaw wa kinuw-kuwa na. Ata akkan da nga nakappoli kadatu bas-básul da. ");
INSERT INTO isd_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ay nán na, “Kakal-kalakkán kayu wa iCorazin! Ay nakal-allà kayu pe nga iBetsaida, áta akkan kayu pikam ma nakappoli kadaya bas-básul nu. Ay nu ka íli Tiro se Sidon ya nangwaán ku kadatu nakas-kasdáaw wa nepassingan ku kadakayu, oray akkan da mangurug ke Dios, ay nabayág da kuma ngin na nepassingan nga nakappoli da kadaya bas-básul da kiya agbádu da ka langgusti se agsap-sapu da kadatu úlu da ka abu. ");
INSERT INTO isd_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ay ikagì kadakayu nga nu iya algaw wa angngukum ne Dios, ay tare kam ya kàwaán daya iTiro se iSidon may dakayu. ");
INSERT INTO isd_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ay dakayu pe nga iCapernaum, nu nán nu wa mepangátu kayu panda ka lángit, ay akkan! Ta merungsap kayu ka impiyernu! Ata nung kuma nu ka íli Sodom ya nangipassingannán ku kadatu nakas-kasdáaw wa nepas-passingan ku kadakayu, ay atán kuma kam tu íli Sodom ka panda kídi. ");
INSERT INTO isd_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ay ikagì kadakayu nga nu iya algaw wa angngukum ne Dios, ay tare kam ya kàwaán daya iSodom may dakayu,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ay kitun pe nga oras, ay nán ne Jesus, “Magiyáman nà kikaw Ama nga Apu ka lángit se kídi kalawagán, ta nelingalingad mu ya kepapannán dedi ya kuk-kuwaam kadaya magkuna nga nasírib da se kadaya atán ádal. Ngamay nepakammum kadaya tolay ya ummán ka uray an-anà ya uray da. ");
INSERT INTO isd_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Magiyáman nà kurug kikaw Ama, áta ittu mà ya paganggammám.” ");
INSERT INTO isd_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ay nán manin ne Jesus, “Iyà ya nangipiyáran ne Ama kadaya ngámingámin. Ay áwan ya kurug ga makammu kiya An-anà nu di tittu we Ama, ay áwan pe ya kurug ga makammu kiya Ama, nu di iyà ala nga An-anà na se daya piyán ku wa pangipakammuwán kaggína. ");
INSERT INTO isd_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Umbet kayu kiyà, dakayu wa mun-onawán se madam-damtán, ta pagimangan takayu. ");
INSERT INTO isd_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Surútan nu daya ipasúrut ku, ay se magsur-súru kayu pe kiyà. Ata napakumbaba ngà se natulù à. Ay túyán ya akasmà nu win kiya pagimangán daya ur-uray nu ka áwan panda. ");
INSERT INTO isd_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ata daya ipasúrut ku ay nalapat da, ay se nalangpaw wala daya bátug ipakagtù kadakayu.” ");
INSERT INTO isd_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ay akkan nabayág ka panda, ay nanalen de Jesus se datu tù-tùgúdán na ki kammayán, ay Sabado kitun. Ay gapu ta nabisinán datu tù-tùgúdán na, ay nangdut da kadatu dáwa ay se da bùsílán nga kanan. ");
INSERT INTO isd_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ngamay kane masingan datu Pariseo tu agbùsil da, ay nán da ke Jesus, “Ye sinnam kod daya tù-tùgúdám! Tura da kuwaan ya ipànaw naya lintag tada ki algaw wa aggiimáng!” nán da. ");
INSERT INTO isd_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ay nán na kaggída, “Akkan nu pikam nabása ta, tu kinuwa natu Ari David se datu tolay na kane mabisinán da?” nán na. ");
INSERT INTO isd_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","“Ay nawe da mà kitu nengágan ka balay ne Dios, ay se da kanan tu sinápay ya nedátun ke Dios. Ay kannaw mà pe kaggída ya mangán kitun nu di daya pappádi yala. ");
INSERT INTO isd_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ay akkan nu nád pe nabása ta kitu nesur-súrát natu Moses, nga kiya algaw wa panaggiimáng, ay akkan magimáng daya pappádi gapu ki ubra da. Ay akkan da mà wayya nga mapabásul datun! ");
INSERT INTO isd_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ngamay ikagì kadakayu wa atán kídi ya natù-turáy may daya lin-lintag ki templo. ");
INSERT INTO isd_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ay akkan nu kuma pabasúlan daya áwan bas-básul, nu ammu nu kuma ngala ya sarut nedi ya nesúrát kitun: ‘Ya agkallà nu kadaya kasittolay nu ya napatag kiyà nga akkan daya dátun nu kiyà,’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ata iyà nga nengágan da kitun ka An-anà Tolay ya makammu kiya kurug mepanggap kiya algaw wa panaggiimáng,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ay se yala nangaw-át te Jesus kitu sinagoga da. ");
INSERT INTO isd_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Uwad laláki kitúni nga nangasa tu isa nga íma na. Ay nagsaludsud da ke Jesus nga nán da, “Meallang nád ya mangágas ki algaw wa aggiimáng?” nán da, áta pagsapúlán da ka ipabásul da kaggína. ");
INSERT INTO isd_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ay tútu nán ne Jesus kaggída “Kas pangarígan, ya isa kadakayu, ay atán karneru na nga nepisù kiya abbut ki algaw wa aggiimáng, akkan nu nád 'we alà?” nán na. ");
INSERT INTO isd_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","“Ay nabà-banor mà ya tolay may iya karneru! Ay túya umannúgut kiya lintag ya mangwa ka napiya ki algaw wa panaggiimáng,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ay se na nán kitu tolay, “Ùnatam ya ímam,” nán na, ay inùnát kurug natu laláki tu íma na, ay pummiya nga ummán kitu isa nga íma na pe yin. ");
INSERT INTO isd_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ay datu Pariseo, ay nagkirut da nga nawe se da nagguumomán nu mapaanna ya ammatay da kaggína. ");
INSERT INTO isd_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ay kane nammuwán ne Jesus idi, ay nagtálaw kitúni. Ay adu datu gummunud kaggína. Ay pinabílag na ngámin datu atán sin-sinakit. ");
INSERT INTO isd_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ay binílin nada nga akkan da din na iwar-waragáwag ya mepanggap kaggína. ");
INSERT INTO isd_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ay nàwa idi ta senu mammuwán nga kurug tu kinagi natu Isaias sa pagbàbànánan ne Dios kitun nga nán na kídi: ");
INSERT INTO isd_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Tú idi ya pinílì a bobonan ku. Aggína ya pà-pàgan ku se aggína ya paganggammán ku pànang pe. Ialúbù ya Ispiritù kaggína, ay aggína ya mangipakammu kadaya akkan Judyu nu mapaanna ya akkan ammabásul ne Dios kaggída. ");
INSERT INTO isd_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Akkan na makisaw-sáwad se akkan naggat ya aggúni na pe. Ay akkan manggat ta magbàbànán nga magìna kadaya kal-kalsáda. ");
INSERT INTO isd_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ay politán na daya naparpár ra bassáw, ay se pagàngan na pe daya magim-immamátay ya ingki, ka panda kiya di na mapangábà tutu wala ya kinapiya. ");
INSERT INTO isd_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ay aggína ya namnamáan daya akkan Judyu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ay se yala uwad da nga nangilbet ka laláki ya pinagúmal se kinúláp daya áran na nagunag kaggína. Ay inagásan ne Jesus, ay díkod nakapagúni se nakasingan tu laláki yin. ");
INSERT INTO isd_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ay pinagballà datu adu wa tolay. Ay nán da, “Akkan nád tú idi ya gaka tu Ari David nga ittu ya Nebon ne Dios?” nán da. ");
INSERT INTO isd_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ngamay kane magìna datu Pariseo tun, ay nán da nga summungbát, “Mapatálaw na daya áran a, ta e Beelzebub nga apu daya áran ya mangidde ka pannakabalin na,” nán da nga pamáas ke Jesus. ");
INSERT INTO isd_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ngamay ammu ne Jesus nu nágan tu lam-lamtan da. Ay tútu nán na kaggída, “Nu magpapátay kampela ngin nin daya tolay kiya isa nga pangiturayán, ay akkan nanáyun yán na pangiturayán. Ay ummán pe, nu magpapátay kampela ngin nin daya tangeliyán onu daya tangabalay, ay akkan da pe ya nanáyun. ");
INSERT INTO isd_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ay ummán pe nu e Sairu kampela ngin nin ya mamatálaw kadaya pumane kaggína, ay mapaanna lugud ya angngituráy na. ");
INSERT INTO isd_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ay nu nán nu wa magpatálaw wà kadaya áran gapu kiya pannakabalin ne Beelzebub, ay iinna lugud ya mangidde kadaya pasúrut nu ka pannakabalin da nga mamatálaw kadaya áran, nu akkan e Dios? Ay díkod, daya pasúrut nu kam ya makekagi nga nasábag kayu! ");
INSERT INTO isd_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ngamay nu gapu ki Ispiritu ne Dios ya ammatálaw ku kadaya ar-áran, ay atán kadakayu win ya angngituráy ne Dios. ");
INSERT INTO isd_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ata akkan mà wayya malnà naya isa tolay ya balay naya nakulnit nga tolay nu di na pikam punnán na pingílan. Ay nu mapíngil na ngin, ay ittu yanin ya akálà na kadaya kuw-kuwa na. ");
INSERT INTO isd_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ay daya akkan na umannúgut kiyà, ay tú dayán daya kumagúra kiyà. Ay ummán pe daya akkan mepagurnung kiyà, ay tú dayán daya magaw-awagwag. ");
INSERT INTO isd_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ay tú idi ya kagiyan ku kadakayu. Ya mangug-og ke Dios se daya duddúma nga básul, ay mabalin mapakawan dayán. Ngamay ya mangagi ka nadakè panggap kiya Ispiritu ne Dios, ay akkan mapakawan yán. ");
INSERT INTO isd_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ay mapakawan daya mangagi ka nadakè kiyà a nengágan da kitun ka An-anà Tolay. Ngamay daya mangagi ka nadakè kiya Ispiritu ne Dios, ay akkan tutu wala mapakawan yán oray ka áwan panda.” ");
INSERT INTO isd_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Napiya nán nu kiya káyu nu napiya ya búnga na, ay nadakè nán nu nu nadakè ya búnga na, áta mammuwán ya káyu kiya búnga na kampela ngin nin,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ay nán na kadatu Pariseo, “Dakayu wa ummán ka gaka idaw! Atán nád ya makagi nu wa napiya, ay nadakè kayu? Ata nu nágan naya atán ki lam-lammat nu, ay ittu ya makagi nu. ");
INSERT INTO isd_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ay ya meúni yala naya namáru wa tolay, ay daya napiya nga lam-lamtan na. Ay ummán pe daya nadakè a tolay, meúni da ngala daya nadakè a lam-lamtan da. ");
INSERT INTO isd_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ay ikagì kadakayu nga nu iya algaw wa angngukum ne Dios, ay ngámin na barabárang nga nakagi daya tolay, ay sungbátan da ke Dios. ");
INSERT INTO isd_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ata gapu kadaya makag-kagi nu, ay mapabásul kayu onu akkan,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ay se yala nán datu duddúma nga magtù-tùgud ki lintag se datu Pariseo, “Misturu,” nán da. “Passingannán nakami mán ka nakas-kasdáaw wa mà-màwa ka pangilasínán mi nga e Dios ya naggayatán naya pannakabalin mu,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ngamay nán ne Jesus nga summungbát, “Inagdakè nu wa tolay kídi yin na al-algaw. Ay akkan pe kurug ya amminya nu ke Dios. Sap-sapúlan nu ya pagilasínán nu ngamay áwan ya mepassingan kadakayu, nu di tittu ya ummán kitu nagilasínán da kitu Jonas nga pagbàbànánan ne Dios kitun. ");
INSERT INTO isd_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ata tu Jonas, ay tallu walgaw se tallu gabi na kitu sinay natu abay pànang nga sissida. Ay ummán pe kiyán ya kabayág naya ag-agyán ku kiya lúbù, iyà nga nengágan da kitun ka An-anà Tolay. ");
INSERT INTO isd_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ay nu iya algaw wa angngukum ne Dios, ay pabasúlan daya iNineve daya tolay kídi ya al-algaw, áta nakappoli mà datu iNineve kane magìna da tu inagbàbànán tu Jonas ka Nineve. Ay atán nà kiddi yin na natù-turáy may tu Jonas! ");
INSERT INTO isd_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ay kiyán na algaw pe, ay pabasúlan pe naya katurayán na babay nga maggayát ka adayyu pànang nga kalawagán, daya tolay kadedi ya al-algaw. Ata aggína, oray adayyu pà-pànang tu paggayatán na, ay inumbet ta nanggìna kitu napiya nga isur-súru natu Solomon kitun. Ay atán kídi yin ya natù-turáy may tu Solomon!” ");
INSERT INTO isd_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Nu magtálaw ya áran kiya tolay, ay mawe magdàdàdà kiya ir-ir-er nga magsápul ka paginggappán na. Ay nu áwan na nga masmà ");
INSERT INTO isd_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ay nán na kiya uray na, ‘Magulli yà kammin kitu balay ku wa pinanáwan ku,’ nán na. Ay nu magulli, ay se na áwan madatang nga magyán kitu balay na, ay se napiya se nadalus pe, ");
INSERT INTO isd_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ay mawe mangalà kadaya pittu pikam ma kabbulun na nga nadà-dakè may aggína, ay se da magunag ngámin kitu tolay. Ay díkod dumà-dakè ya kapàyanán na. Ay ummán pe kídi ya kàwaán daya tolay kadedi ya al-algaw ta dumà-dakè da pe,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ay kitu madama nga magbàbànán ne Jesus kadatu tolay, ay inumbet tu ina na se datu wawwági na nga lalláki. Ay nagyán da ngala kitu lasi, ay piyán da nga amomanán. ");
INSERT INTO isd_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ay uwad nanguna kaggína nga, “Atán ka lasi nge inám se da wawwágim, ay piyán daka nga amomanán,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ngamay nán ne Jesus sa sumungbát kaggína, “Inna ya inà se iinna daya wawwágì?” nán na. ");
INSERT INTO isd_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ay se na ituldu datu tù-tùgúdán na nga nán na, “Tú mà dedi daya mebíláng inà se daya wawwágì,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","“Ata oray iinna nga mangwa kadaya piyán ne Ama ka lángit, ay tú dayán daya bíláng wawwágì se inà,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ay kitun kam ma algaw, ay lummawán ne Jesus kitu balay, ay se yala nawe nagtutúgaw kitu kapanágan tu pisung. ");
INSERT INTO isd_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ay adu pànang datu tolay ya gummánat kaggína. Ay díkod, nawe nagtugaw kitu biray se la umàráng kadatu tolay nga nagtutúgaw wala kitu kapanágan. ");
INSERT INTO isd_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ay adu datu netù-tùgud na ngamay nepangárig nada. Ay nán na nga nagpangárig, “Uwad tolay ya nawe nagwárit ka aggì ka tálun na. ");
INSERT INTO isd_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kaggína nga magwárit tin, ay nagdattág datu duddúma kitu dálen. Ay inumbet datu an-anù se da immin sinimtúán. ");
INSERT INTO isd_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ay nagdattág datu duddúma nga aggì kitu nalus-án na pínát, ay nakaru da nga tumúbu ta akkan da lugud nadarúnán pànang. ");
INSERT INTO isd_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ay kane sumínág, ay nalaylay da ngala se nakarsiyán da ta áwan da pànang nga gamut. ");
INSERT INTO isd_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ay nagdattág datu duddúma nga aggì kitu agkadtán. Ay tummúbu da may tummúbu pe datu kaddat nga ittu datu naníput kadatu tumúbu wa aggì. ");
INSERT INTO isd_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ay datu duddúma nga aggì, ay nagdattág da kitu kadam-aggán natu lusà. Ay nagbúnga da. Nagbúnga datu duddúma ka adu tutu wala, ay ad-adu kam ya búnga datu duddúma, ay annung na pe ya búnga datu duddúma. ");
INSERT INTO isd_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ay dakayu wa maggigìna kídi, ay lam-lamtan nu pànang ya nagìna nu,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ay inumbet datu tù-tùgúdán ne Jesus kaggína, ay se da nán, “Taanna, turám ipangárig ya magtùgud kadaya tolay?” nán da. ");
INSERT INTO isd_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ay tútu sumungbát te Jesus kaggída nga nán na, “Mepakammu kadakayu daya akkan pikam ma nepakammu kitun mepanggap kiya angngituráy ne Dios, ngamay kaggída ay akkan. ");
INSERT INTO isd_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ata dakayu wa atán angngurug, ay maamúngán daya ammu nu, ta senu umadu pànang. Ngamay daya áwan na angngurug, ay mippà oray ya bittì a ammu da. ");
INSERT INTO isd_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ay túya gapu na nga pabeg pangárig ya angngikagì kaggída, áta maddi da mà ilasínán ya angngituráy ne Dios oray sisinnán da, ay se maddi da pe ya awátan oray gigìnán da. ");
INSERT INTO isd_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ay díkod mapagintutuwán kaggída tu nán natu Isaias nga, ‘Oray maggigìna kayu wala nga maggigìna ay akkan kayu makaáwat. Ay oray singan kayu wala nga singan, ay akkan kayu wa makalásin. ");
INSERT INTO isd_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ata nagkulnit tin ya uray daya tul-tolay. Ay pinagbangngag da daya talínga da ngin, ay se pinagkúláp da daya mata da. Ata galù da nga makagìna da se makasingan da, ay maawátan da se masingan da ya kà-kàwaán da. Ay magulli da kiyà,’ nán ne Dios, ‘ay pakawanan kuda kadaya bas-básul da,’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ngamay maganggam kayu ta malásin nu daya masingan nu se maawátan nu daya magìna nu. ");
INSERT INTO isd_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ay kurug ya nán ku kadakayu nga adu kadatu pagbàbànánan ne Dios kitun se datu namáru wa tolay ya maminya tutu wala nga makasingan kadaya nas-asingan nu se makagìna kadaya nag-agìna nu ngamay akkan da nga nasingan se nagìna.” ");
INSERT INTO isd_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ay gìnán nu lugud ya kepapannán natu pangárig mepanggap kitu tolay ya nawe nagwárit ka aggì. ");
INSERT INTO isd_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nu atán makagìna kiya bàbànán na mepanggap ki angngituráy ne Dios, ay se akkan na nga maawátan, ay umbet te Sairu wa mangippà kitu nagìna na. Túyán ya árig datu aggì a nagdattág ki dálen. ");
INSERT INTO isd_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ay tu nalus-án na pínát ta nagdattagán datu aggì, ay meárig da kadaya nakagìna kiya bàbànán ne Dios, ay sikkaanggam da nga nangurug. ");
INSERT INTO isd_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ngamay akkan na nepalam-lammat kaggída tu nagìna da. Ay túya akkan nagbayág, ay naglikud da ngin kane umbet ya kapar-parigátan se kapal-palakkán da gapu kitu bàbànán na nagìna da. ");
INSERT INTO isd_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ay tu agkadtán nga nagdattagán datu aggì, ay meárig kadaya makagìna kiya bàbànán ne Dios, ay se da nga nangurug. Ngamay gapu ki lid-lídug da kídi ya kalawagán se ya amminya da kiya kinabànáng, ay napsílán tu nammuwán da. Ay díkod áwan nagbal-balínán natu nagìna da. ");
INSERT INTO isd_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ay tu nadam-ag ga lusà a nagdattagán datu aggì, ay árig kadaya nakagìna kiya bàbànán ne Dios, ay naawátan da pe. Ay nagbúnga da. Adu búnga datu duddúma, ad-adu pe ya búnga datu duddúma, ay datu duddúma ay adu pànang ya búnga da,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ay nagpangárig manin ne Jesus kaggída. Ay nán na, “Ummán pe kídi ya kearígán naya pangiturayán ne Dios. Nawe ya isa nga tolay ya magwárit ka aggì. Ay tu aggì a newárit na, ay áwan na kibukibug. ");
INSERT INTO isd_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ngamay kane matúdug ngámin datu tolay yin, ay nawe tu kalínga na nga nagwárit pe ka bukal kaddat, ay se la nawe yin. ");
INSERT INTO isd_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ay díkod, kane magdadakkal datu ammay, ay se da nagbúnga, ay malásin pe yin datu kad-kaddat. ");
INSERT INTO isd_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ay díkod datu asassu natu makin-kuwa kitu tálun, ay inumbet da, ay nán da kaggína, ‘Apu, di mà áwan kibukibug ga aggì tu newárit mu kiya tálun? Ay ka wàna lugud ya naggayatán daya kaddat?’ nán da. ");
INSERT INTO isd_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","‘Ya kumalínga kiyà ya nangippáy kadayán!’ nán na kaggída. ‘Ay piyán mu lugud nu mawe mida nga bàdútán?’ nán da. ");
INSERT INTO isd_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ngamay, ‘Akkan,’ nán na. ‘Ata get nu metangabàdut nu daya ammay nu bàdútán nu daya kaddat. ");
INSERT INTO isd_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ditán da ngala. Bay-án nuda nga metangaabay kadaya ammay. Ta nu aggagáni, ay kagiyan ku wala kadaya maggáni nga bàdútán da nga munna daya kaddat se da nga pastan da se dada nga sìdúgan. Ay se da ngala ganiyan ya ammay, ay se dada ipintà kiya álang ku,’ nán na,” nán ne Jesus nga nagpangárig. ");
INSERT INTO isd_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ay uwad manin na isa nga pangárig ga nebàbànán ne Jesus kadatu tolay. Ay nán na, “Ya pangiturayán ne Dios, ay meárig pe kiya bukal kaykayu nga mustása nga nemúla naya isa nga tolay. ");
INSERT INTO isd_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Bì-bitì a bukal ngamay nu umabay, ay ittu win ya kabayyán nin kadaya ngámin kaykayu. Ay nagbalin ka káyu wa mabalin na pagsùbútán daya an-anù,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ay uwad manin na pangárig ne Jesus nga nán na, “Ya angngituráy ne Dios, ay meárig ka bittì a pamalbád nga nekibug naya isa nga babay kiya limmug na nga arína. Ay ummarà tu pamalbád, ay díkod linumbád ngámin tu tallu wa là-lata nga arína,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nepangárig ne Jesus ya inangngagi na kadedi kadatu tolay. Awan na nga nebàbànán kaggída nga akkan na nga nepangárig. ");
INSERT INTO isd_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kinuwa na datun ta senu màwa nga kurug tu kinagi natu pagbàbànánan ne Dios kitun nga nán na, “Idalen ku ka pangárig ya makibàbànán kaggída. Ay ipakammù kaggída ngámin daya akkan pikam ma nepakammu panda kitu nekàwa nedi ya kalawagán,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ay se la pinanáwan ne Jesus datu adu wa tolay, ay se linumnà kitu balay. Ay inunud pe datu tù-tùgúdán na. Ay nán da kaggína, “Ilaw-lawág mu mán kadakami ya sarut natu pangárig mepanggap kadatu kaddat kitu tálun.” ");
INSERT INTO isd_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ay summungbát ta nán na, “Tu nagwárit kitu napiya nga aggì, ay ya nengágan da kitun ka An-anà Tolay. ");
INSERT INTO isd_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ay tu tálun, ay ya kalawagán ni. Datu napiya nga aggì, ay ittu dayán daya itur-turayán ne Dios. Ay datu kaddat, ay ittu dayán daya itur-turayán ne Sairu. ");
INSERT INTO isd_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ay tu kumalínga kiyà nga ittu ya nangiwárit kaggída, ay e Sairu. Tu kagáni da, ay ittu ya ipappanda naya kalawagán. Ay datu maggáni ay daya anghel. ");
INSERT INTO isd_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ay nu wà ummán naya kaurnung se kasìdug datu kaddat, ay ummán pe kiyán ya màwa kadaya nadakè a tolay kiya ipappanda naya kalawagán. ");
INSERT INTO isd_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ay iyà nga nengágan da kitun ka An-anà Tolay, ay ibon ku daya anghel la umang nga mangurnung kadaya ngámin tolay ya paggayatán naya panagbas-básul se daya ngámin tolay ya nadakè kuk-kuwaan, ay se dada nga isibna kadaya itur-turyán ne Dios. ");
INSERT INTO isd_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ay se dada nga isungap kiya maggatagatang nga apuy. Ay sumángit da se magngar-ngarasiyat da. ");
INSERT INTO isd_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ay daya annánà ne Dios, ay atán da ngin kiya pangiturayán naya Ama da nga dumiladiláng da nga ummán kiya mata. Ay dakayu wa malagpat ta manggìna, ay lam-lamtan nu pànang daya magìna nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ya pangiturayán ne Dios, ay meárig kiya napatag pànang nga kuw-kuwa nga nekubkob kiya unag tálun nga nasmà naya isa nga tolay ya maglà-láku. Ay kane masmà na, ay tinàbúnán na pikam, áta ningbáwan. Ay se yala nagulli ka balay da, ay se na iláku ngámin datu kuw-kuwa na, ay se na mawe gatángan tun na lusà,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ya angngituráy ne Dios, ay meárig pe kídi: Uwad isa nga tolay ya maglà-láku nga magsap-sápul kadaya napatag ga perlas. ");
INSERT INTO isd_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ay kane makasuwà ka isa nga napatag pà-pànang nga perlas, ay nawe na neláku ngámin datu kuw-kuwa na, ay se na nga gatángan tun. ");
INSERT INTO isd_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ya pangiturayán ne Dios, ay ummán pe ka dàlis nga medàlis kiya bebay, ay se makálà ka ngámin na baláki daya sissida. ");
INSERT INTO isd_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ay kane adu tutu wala ngin tu màna da, ay rinùrut da tu dàlis ka gàdáng, ay se da nga piliyán. Datu napiya, ay ittu datun datu nippáy da ki kiláwag da, ay datu nadakè, ay nippà dada. ");
INSERT INTO isd_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ay ummán pe kídi ya màwa kiya ipappanda naya kalawagán. Umbet daya anghel la mangisibna kadaya nadakè a tolay kadaya namáru. ");
INSERT INTO isd_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ay daya nadakè ay mesungap da kiya maggatagatang nga apuy. Ay sumángit da se magngar-ngarasiyat da.” ");
INSERT INTO isd_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ay se yala saludsúdán ne Jesus datu tù-tùgúdán na nga nán na, “Maawátan nu ngámin dedi?” nán na. “Ò,” nán da nga summungbát. ");
INSERT INTO isd_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ay se na nán kaggída, “Ay lugud, nu atán na magtù-tùgud ki lintag ga mangammu kiya mepanggap kiya angngituráy ne Dios, ay meárig kiya nabànáng nga tolay nga mangilawán kadaya bar-baru se dadán na kuw-kuwa na kiya aggisiruán na,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ay kane mabalin ne Jesus sin na magkakagi kadatun na pangárig, ay nagtálaw kitúni. ");
INSERT INTO isd_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ay se la mawe kitu íli na kampela ngin. Ay nangisur-súru kitu sinagoga da. Ay nasdaáwan datu naggigìna kaggína. Ay nán da, “Kawà nád ya naggayatán naya sírib nedi ya tolay se ya pannakabalin na nga mangwa kadaya nakas-kasdáaw wa mà-màwa? ");
INSERT INTO isd_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Di mà an-anà natu karpinteru yán? Di mà e Maria ya ina na? Ay de Santiago se Jose, se Simon, se Judas daya wawwági na?” nán da. ");
INSERT INTO isd_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","“Ay magag-agyán pe kídi daya wawwági na nga babbay! Ay kawà na nád lugud ya nangalakkán na kiya sírib na se kababalin na?” nán da. ");
INSERT INTO isd_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ay tútu akkan da pinatag ge Jesus. Ngamay nán ne Jesus kaggída, “Maday-dáyaw ya pagbàbànánan ne Dios kadaya oray wà na nga íli, malaksid dala kiya íli na kampela ngin nin se kadaya akkobung na,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ay akkan nangipassingan ka adu wa nakas-kasdáaw kitúni, gapu kitu akkan da angngurug kaggína. ");
INSERT INTO isd_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kitun na tiyampu, ay nadámag natu Ari Herodes ya mepanggap ke Jesus. ");
INSERT INTO isd_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ay díkod, nán na kadatu bobonan na, “Aggína tu Juan na marammawtisár nga linumtu kammin, ay túya atán pannakabalin na nga mangwa kadayán na nakas-kasdáaw,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ata tu Herodes tu nangipatiliw kitu Juan. Ay pinapíngil na ay se na nepebálud pe. Kinuwa na tun gapu kitu Herodias nga ípág na nga atáwa natu Felipe nga wagi na. ");
INSERT INTO isd_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ay kagiyan peyang tu Juan kitu Herodes nga, “Nadakè nga atawán mu ya ípág mu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ay gapu kídi, ay patayan kuma natu Herodes tu Juan, ngamay umamà kadatu Judyu, áta kurugan da nga isa nga pagbàbànánan ne Dios tu Juan. ");
INSERT INTO isd_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ay kane umbet tu algaw wa nekeanà tu Herodes, ay nagsay-am da. Ay nagsála tu babbalásang nga an-anà tu Herodias kitu àráng ngámin datu adu wa sangaíli na. Ay gapu ta naanggammán tutu wala pànang tu Herodes, ");
INSERT INTO isd_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ay tútu nekar-kari na tutu wala kitu babbalásang nga idde na oray nágan na nga agngan na. ");
INSERT INTO isd_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ay gapu ta binílin natu ina na, ay nán na, “Iddem kiyà kídi yin ya úlu ne Juan na marammawtisár, ay ippáy mu kiya paláter,” nán na, áta ittu tu pekagi natu ina na. ");
INSERT INTO isd_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ay nagpannakit pànang tu ári, ngamay gapu ta nekar-kari na, ay se àráng pe datu sangaíli na ya nagkariyán na, ay tútu pinidde na ngala ngin kitu babbalásang tu agngan na. ");
INSERT INTO isd_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ay díkod, pinapútul na tu Juan nga atán kitu agba-balúdán. ");
INSERT INTO isd_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ay nippáy da tu úlu na ki paláter, ay se da ilbet kitu babbalásang nga ittu tu nawe na nga nidde kitu ina na. ");
INSERT INTO isd_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ay díkod nawe inalà datu tù-tùgúdán natu Juan tu baggi na se da netaman. Ay se da nawe pe ya nekagi ke Jesus tu nàwa. ");
INSERT INTO isd_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ay kane magìna ne Jesus tu dámag, ay nagtálaw kitúni. Nagtakay kitu biray se la nawe nga magasissa kitu ir-ir-er. Ngamay kane mammuwán datu adu wa tolay, ay nagtálaw da kadatu il-íli da, ay seda ummunud ke Jesus. Ay nagsasal-ay da ngala. ");
INSERT INTO isd_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ay kane maglagsi ye Jesus kitu biray, ay nasingan na datu adu tutu wala nga tolay. Ay nakalakkán pànang kaggída, ay inagásan na datu atán sin-sinakit kaggída. ");
INSERT INTO isd_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ay kane din na gumídagídám min, ay inumbet datu tù-tùgúdán na. Ay nán da kaggína, “Gídám min, ay áwan ta pe ammu wa babalay kídi ir-ir-er. Ay túya papannan mu wala ngin daya tolay kadaya íli nga magsápul ka gatángan da nga kanan da,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ay nán ne Jesus, “Akkan da masápul ya mawe. Iddán nuda ka kanan da,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ay tútu nán da kaggína, “Lim-limma bukal sinápay se dudduwa ngabgi nga sissida mà ala ya atán,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ay tútu, “Ilbet nuda kídi,” nán na kaggída. ");
INSERT INTO isd_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ay pinagtugaw na datu tolay kitu kakadtán. Inalà na datu sinápay se sissida, ay se la naglángad da magiyáman gapu kadatun. Ay se na nga sinappitappig se na nga idde kadatu tù-tùgúdán na, nga ittu datu nidde da kadatu tolay. ");
INSERT INTO isd_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ay nangán da ngámin, ay nabtug da ngámin pe. Ay nakùnud pikam datu tù-tùgúdán na ka sangapúlu se duwa baki nga bunna da. ");
INSERT INTO isd_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ay moli limma ríbu tu bíláng datu lalláki nga nangán. Ay akkan netangabíláng datu babbay se annánà. ");
INSERT INTO isd_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ay se yala nga pinagtakay ne Jesus datu tù-tùgúdán na kitu biray, ay se nada pinaginunna nga magbatta. Ay se na pe yin papannan datu adu wa tolay. ");
INSERT INTO isd_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ay kane mabuwà na datu adu wa tolay, ay nanùdu wa nagas-asissa kitu bantay ta magkarárag. Ay sissa ngala kitúni panda kitu gabi. ");
INSERT INTO isd_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ngamay kitun na oras, ay nawáyad din tu biray kitu naday-ág ga pisung. Ay mepalupalun tu biray da, áta mepasabat tu báli kaggída. ");
INSERT INTO isd_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ay kane din na danni láwa ngin, ay dinatang ne Jesus da kitu giyán da. Ay nagdal-dalen kitu otun tu danum. ");
INSERT INTO isd_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ay kane din na masingan datu tù-tùgúdán na nga magdal-dalen kitu danum, ay nagansing da tutu wala nga nán da nga nakasáraw, “Balangobáng!” nán da. ");
INSERT INTO isd_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ngamay dágus sala nga nagúni nge Jesus nga nán na, “Akkan kayu wa magan-anansing ta iyà kam ide. Akkan kayu wa malídug,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ay tútu, “Apu,” nán ne Pedro. “Nu kurug ga ikaw yán, ay palbetan nà mán na manalen ki otun danum,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ay tútu, “Umbet ka a,” nán ne Jesus. Ay díkod naglagsi ye Pedro kitu biray se la manalen kitu otun danum ma mameyag kitu giyán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ngamay kane màmud na tu báli, ay nagansing. Ay ittu win tu inanggayát na nga umlad din. Ay tútu nakasáraw nga nán na, “Apu alà nà!” nán na. ");
INSERT INTO isd_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ay tútu kinaru ne Jesus nga dinugkam tu íma ne Pedro, ay se na nga gamnídan nga nán na, “Inagkabittì naya angngurug mu ta! Taanna, tura ka naggad-gadduwa ta!” nán na. ");
INSERT INTO isd_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ay tútu nagtakay da nga duwa ngin kitu biray da, ay nakusap pe yin tu báli. ");
INSERT INTO isd_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ay datu atán kitu biray, ay dinay-dáyaw da nge Jesus nga nán da, “Kurug ga ikaw ya An-anà ne Dios!” nán da. ");
INSERT INTO isd_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ay kane din na dummung de Jesus sin ka dammáng, ay gummàdáng da ka Genesaret. ");
INSERT INTO isd_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ay kane malásin datu tolay kitúni ye Jesus, ay nedámag da kadatu ngámin tolay kitúni ya íli. Ay díkod nilbetán da ngámin datu magtatakit, ta paagásan dada kaggína. ");
INSERT INTO isd_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ay nakim-imallà da kaggína ta tùbítan da kuma oray tu arumaymáy natu bádu na ngala. Ay ngámin datu nakatùbit, ay bummílag da ngámin. ");
INSERT INTO isd_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ay se yala uwad da nga Pariseo se datu magtù-tùgud kadatu lin-lintag ga gayát ka Jerusalem nga inumbet ta magsaludsud ke Jesus nga nán da, ");
INSERT INTO isd_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Taanna, tura akkan kurugan daya tù-tùgúdán mu ya nesur-súru wa gangay datu mannákam tada mepanggap kiya panagbaggu? Mangán da ngala nga akkan na magbaggu,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ay summungbát te Jesus nga nán na, “Ay dakayu, taanna, tura nu akkan kurugan ya bílin ne Dios gapu wala kadaya gagángay nu wa sur-surútan nu? ");
INSERT INTO isd_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ata nán naya bílin ne Dios nga, ‘Ipatag mu ya amám se inám,’ ay nán na pe nga, ‘Ngámin daya makakagi ka nadakè kiya ama na se ina na, ay masápul la matay,’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ngamay isúru nu mà nga nu atán ya tolay nga atán ya iseng na kuma kiya ama na onu ina na, ay annung na nga nán kaggída, ‘Iddè kuma idi ka iseng ku kadakayu may akkan ku wa midde yin ta iddè ke Dios,’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ay díkod idi nga tolay, ay akkan na nga masápul la ipatag ya ama na. Ay nu ummán kiyán, ay akkan nu win na pinagan-anu ya bílin ne Dios gapu wala kiya angngikurug nu kadaya gagángay nu. ");
INSERT INTO isd_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Dakayu wa magpì-pìmáru! Kurug tu nán tu Isaias kitun mepanggap kadakayu, kitu inagkuna na nga, ");
INSERT INTO isd_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Dayáwan dà dedi ya tolay ngamay kiya úni da ngala. Ata ya kurug na, ay adayyu daya ur-uray da kiyà. ");
INSERT INTO isd_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ay túya áwan sur-surbi naya panagday-dáyaw da kiyà, áta daya gagángay tolay yala daya isur-súru da, nga nán da nga bílin pe ne Dios sin,’ nán na,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ay pinaderun ne Jesus datu adu wa tolay, ay se na nán kaggída, “Gìnán nu ya ikagiyán ku, ay se awátan nu pe. ");
INSERT INTO isd_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ya mamar-paragit kiya isa nga tolay, ay akkan wayya nga ya kanan na nu di daya iúni na.” ");
INSERT INTO isd_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ay se yala inumbet datu tù-tùgúdán na nga nán da kaggína, “Ammum nga napasagídán datu Pariseo gapu kitu nagìna da nga kinagim?” nán da. ");
INSERT INTO isd_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ay nán ne Jesus sa summungbát, “Ngámin daya múla nga akkan nemúla naya Amà ka lángit, ay masápul la mabàdut da. ");
INSERT INTO isd_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pagdudoray nuda ngala. Ata árig da ya kúláp pa magbaybay. Ay nu baybáyan naya kúláp ya páda na nga kúláp, ay mepisù da nga duwa ki abbut,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ay tútu nán ne Pedro kaggína, “Ikagim mán kadakami ya sarut natu pangárig mu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ay tútu nán ne Jesus, “Akkan nu pikam pe maawátan ta! ");
INSERT INTO isd_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Akkan nu wa ammu wa ngámin daya itàmul naya tolay nga kanan na, ay mawe kiya sinay na, ay se lumawán kammin. ");
INSERT INTO isd_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ngamay daya iúni na nga maggayát kiya uray na, ay ittu yán ya mamaragit kaggína. ");
INSERT INTO isd_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ata ya uray ya paggayatán daya nadakè a pan-panúnut naya isa nga tolay, nga ummán kadaya pumatay, manaládag, se daya nadakè a kuk-kuwaan daya babbay se lalláki, magtákaw, magbusid se mamad-padakè. ");
INSERT INTO isd_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ay ittu dayán daya mamaragit kiya tolay, nga akkan wayya nga ya akkan na nga agbaggu nu mangán,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ay nagtálaw we Jesus kitúni, ay se yala nawe kitu giyán nga adanni ka Tiro se Sidon. ");
INSERT INTO isd_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ay uwad inumbet ki giyán na nga iCanaan na babay nga mag-agyán kitúni. Ay idi ya babay, ay akkan Judyu. Ay nán na nga kinggat ke Jesus, “Apu nga gakagaka tu David! Kalakkán nà agpà ta naar-aránan ya an-anà ku wa babay!” nán na. ");
INSERT INTO isd_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ngamay akkan sinung-sungbátan ne Jesus. Ay díkod inumbet datu tù-tùgúdán na nga nán da kaggína, “Pataláwam, Apu! Makasar-sáraw wala nga um-umpal kadàtada,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ay tútu nán ne Jesus, “Nebon nà ala kadaya Judyu wa árig ga nawagwag ga karneru ka Israel,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ngamay inumbet tu babay ya nagpalintud ki àráng ne Jesus nga nán na, “Sengán nà agpà!” nán na. ");
INSERT INTO isd_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ay nán ne Jesus nga summungbát, “Akkan rumbang nga alà ta ya kanan daya annánà se tala ipakkán kadaya átu,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ay nán natu babay ya summungbát, “Kurug yán Apu, may daya átu, ay kanan da mà pe ya bugta daya apu da kiya tebol,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ay tútu nán ne Jesus kitu babay, “Abay pànang kurug ya angngurug mu. Ay màwa kurug ya piyám ma màwa,” nán na. Ay kitun kam ma oras, ay bumílag tu an-anà na ngin. ");
INSERT INTO isd_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ay kane magtálaw manin ne Jesus kitúni, ay nanalen kitu dappit tu pisung ka Galilea. Ay se nanùdu kitu bantay, ay se yala nga nagtutúgaw. ");
INSERT INTO isd_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ay adu tutu wala datu tolay ya inumbet. Ay nilbetán da datu akkobung da nga pílay, datu magdapepe, datu kúláp, datu úmal se duddúma pikam ma magtatakit. Ay nippannán dada kitu àráng ne Jesus, ay pinabílag nada ngámin. ");
INSERT INTO isd_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ay nasdaáwan datu tolay kane masingan da datu úmal la makapagúni yin, se datu bummílag nga magdapepe, ay se datu pílay ya makadalen nin, se datu kúláp pa makasingan nin. Ay dinay-dáyaw da nge Dios nga Dios daya iIsrael. ");
INSERT INTO isd_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ay kirrawán ne Jesus datu tù-tùgúdán na, ay se na nán kaggída, “Makalakkán nà kadedi ya tolay, áta tallu nga algaw da ngin na nebul-bulun kadàtada kídi ya giyán. Ay áwan da nga kanan nin. Ay akkan kuda piyán papannan na sibbibisin ta get nu mullaullap da kiya dálen,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ay nán datu tù-tùgúdán na kaggína, “Ay kawà na nád ya pangalakkán tada kídi ir-ir-er ka maanáy nga ipakkán tada kadedi ya adu pànang nga tolay?” nán da. ");
INSERT INTO isd_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ay nán ne Jesus kaggída, “Piga pikam tu sinápay nu ta?” nán na. “Ay atán pikam pittu, ay se atán pe ya bittè a bibittì a sissida,” nán datu tù-tùgúdán na. ");
INSERT INTO isd_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ay tútu pinagtugaw ne Jesus datu tolay kitu lusà. ");
INSERT INTO isd_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ay se na inalà datu pittu wa sinápay se datu sissida, ay se la magiyáman ke Dios. Ay kane mabalin, ay sinappitappig na, ay se na nekípát kadatu tù-tùgúdán na ta senu ikípát da kadatu tolay. ");
INSERT INTO isd_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nangán da ngámin, ay se nabtug da ngámin pe. Ay pittu pikam ma baki ngámin tu naùnud datu tù-tùgúdán na nga bunna da. ");
INSERT INTO isd_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ay datu nangán, ay appát ríbu wa lalláki, akkan meráman datu babbay se datu annánà. ");
INSERT INTO isd_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ay pinapan ne Jesus datu tolay yin, ay se da la nga nagtakay kitu biray, ay se da nawe kitu giyán na sakúpan naya íli Magadan. ");
INSERT INTO isd_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Isa ngalgaw, ay uwad da nga Pariseo se Saduceo wa inumbet ki giyán ne Jesus. Piyán da nga sisímán ne Jesus, ay tútu pangipassingannan da ka nakas-kasdáaw wa maggayát ka lángit. ");
INSERT INTO isd_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ngamay nán ne Jesus nga summungbát kaggída, “Nu masir-sirbut ya mata, ay se nu wa masingan na mangarindadága ya lángit, ay nán nu wa napiya ya kalawagán kaláwa. ");
INSERT INTO isd_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ay nu masingan nu wa mangarindadága se nagìbat ya lángit ki pagmakát, ay nán nu wa magudán. Ammu nu wa isarután daya sing-singan naya lángit, ngamay tura nu akkan na ammu isarután daya mà-màwa kadedi yin na al-algaw! ");
INSERT INTO isd_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Dakayu wa tolay kadedi yin na al-algaw wa nadakè se akkan kurug mangurug ke Dios! Magsap-sápul kayu ka pagilasínán nu, ngamay áwan mepassingan kadakayu nu di tittu tu pagilasínán na nàwa kitu Jonas,” nán na. Ay se nada ngala nga pinanáwan. ");
INSERT INTO isd_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ay kane din na atán datu tù-tùgúdán na ngin kitu panidmáng natu pisung, ay nadamdam da nga naligpanán da ya nagbálun ka sinápay. ");
INSERT INTO isd_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ay gapu ta piyán ne Jesus nga pagtaronan datu tù-tùgúdán na kadatu isur-súru datu Pariseo se datu Saduceo, ay tútu nán na kaggída, “Sin-sinnan nu se taronan nu ya ammal-palabbád daya Pariseo se daya Saduceo,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ay tútu binàbànán da tu kinagi na nga nán da, “Kinagi na tun, áta akkan tada nga nagtagisinápay,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ngamay ammu ne Jesus tu pagbàbànánan da, ay tútu nán na kaggída, “Tura nu agpà a pagbàbànánan ya áwan nakapangitúgut ka sinápay kadakayu! Inagkabittì naya angngurug nu ta!” nán na kaggída. ");
INSERT INTO isd_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","“Akkan kayu agpà makaaw-áwat pikam ta! Naligpanán nu win ta, tu limma bukal sinápay ya tim-timpig ku nga ittu tu niddè kadatu limma ríbu wa tolay? Ay piga nga baki tu napnu kitu bunna da ta! ");
INSERT INTO isd_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ay akkan nu pe madamdam tu pittu bukal sinápay ya kinnán datu appát ríbu wa tolay? Piga baki nga bunna tu naurnung nu kitun ta? ");
INSERT INTO isd_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ay tura nu akkan pikam mala nga maawátan nga akkan wayya nga panggap ka sinápay tu nán ku kadakayu! Taronan nu ya ammal-palabbád daya Pariseo se daya Saduceo,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ay díkod tútu naawátan datu tù-tùgúdán na ngin nga akkan wayya nga tu pamalbád ka sinápay tu nán ne Jesus nga taronan da, nu di itu isur-súru datu Pariseo se datu Saduceo. ");
INSERT INTO isd_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ay kane atán de Jesus se datu tù-tùgúdán na kitu giyán na sakúpan naya íli Cesarea ka Filipos, ay sinaludsúdán ne Jesus datu tù-tùgúdán na nga nán na, “Inna ngà kanu wa nán daya tolay, iyà nga nengágan da kitun ka An-anà Tolay?” ");
INSERT INTO isd_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ay nán da nga summungbát, “Nán daya duddúma nga ikaw kanu tu Juan na marammawtisár. Ay e Elias ka kanu wa nán daya duddúma. Ay nán daya duddúma nga ikaw kanu tu Jeremias onu isa kadatu pagbàbànánan ne Dios kitun,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Ay dakayu, inna ngà ka nán nu?” nán na. ");
INSERT INTO isd_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ay nge Simon Pedro tu summungbát ta nán na, “Ikaw ya Cristo nga An-anà naya sibbibiyág ga Dios!” nán na. ");
INSERT INTO isd_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ay tútu nán ne Jesus nga summungbát kaggína, “Maganggam ka Simon na an-anà ne Jonas! Ata akkan tolay ya nangipakammu kikaw kiyán na kinagim, nu di ya Amà nga atán ka lángit. ");
INSERT INTO isd_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ay ya ikagì pe kikaw, ay ikaw we Pedro. Ay batu ya sarut naya ngágan mu. Ay yán na árig pínát, ay ittu ya pangipasikádan ku kiya simbáan ku. Ay áwan makaábà kídi ya simbáan ku oray ya kinaturáy naya pannakatay. ");
INSERT INTO isd_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ay ikaw ya pakammuwan ku kiya pannakeráman daya tolay kiya pangiturayán ne Dios. Ay oray nágan na nga iallang mu kídi kalawagán, ay meallang pe ka lángit. Ay daya ipalúbus mu kídi kalawagán ay mepalúbus pe ka lángit,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ay se na nga kinappiya nga binílin datu tù-tùgúdán na nga áwan da nga pangikag-kagiyán nga aggína ya Cristo. ");
INSERT INTO isd_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nanggayát kitun na oras, ay ginayatán ne Jesus ya mangipakammu kadatu tù-tùgúdán na nga masápul la mawe ka Jerusalem. Ay kitúni, ay adu ya mà-màwa kaggína nga pamarígát datu pangmanàman datu Judyu se datu maragtùgud ki lintag se datu ap-apu datu pappádi kaggína. Patayan da ngamay lumtu kammin nu mekàlu nga algaw. ");
INSERT INTO isd_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ay tútu inaptán ne Pedro we Jesus kitu ad-adayyu, ay se na lùsawan nga nán na kaggína, “Akkam kagiyan yán Apu! Akkan ipalúbus ne Dios nga màwa kikaw ya kinagi mu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ngamay ummàráng nge Jesus ke Pedro, ay se na nga nán, “Umadayyu ka kiyà, Sairu! Ikaw ya mamar-parò kiyà. Ata akkan na panaglam-lammat nga gayát ke Dios ya panaglam-lammat mu nu di gayát ki tolay yala,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ay se yala nán ne Jesus kadatu tù-tùgúdán na, “Nu iinna ya maminya nga magbalin ka tolay ku, ay masápul la kaligpanán na ya mepanggap ki baggibaggi na kampela ngin nin. Ay se na la bugtúngan ya krus na. Ay se yala nga sumúrut kiyà. ");
INSERT INTO isd_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ata ngámin daya magkikenga kiya biyág da mepanggap kiyà, ay tú dayán daya mangiwágà kiya pakabiyágan da kuma ka áwan panda. Ngamay daya mewágà ya biyág da gapu kiyà, ay tú dayán daya makasuwà kiya pakabiyágan da ka áwan panda. ");
INSERT INTO isd_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ata áwan wayya magun-ud naya isa nga tolay oray nu kuw-kuwa na ngámin ya atán kídi ya kalawagán, nu killotán na ya pakabiyágan na kuma ka áwan panda! Ay áwan pe wayya nga mabalin na idde naya isa nga tolay ta senu málà na ya pakabiyágan na ka áwan panda. ");
INSERT INTO isd_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ata umbet tà kammin na nengágan da kitun ka An-anà Tolay nga sittuturáy kiya turáy ne Dios, kabulun ku daya anghel ku kiyán na ilalbet ku. Ay se ku la idde kadaya ngámin tolay ya pagrabngán daya kinuw-kuwa da. ");
INSERT INTO isd_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kurug idi ya kagiyan ku kadakayu, nga atán da kadakayu kídi ya akkan matay panda kiya akasingan da kiyà a nengágan da kitun ka An-anà Tolay nga mangitur-turáy,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ay kane din annam ngalgaw ka panda, ay nekíwid ne Jesus de Pedro se de Santiago se Juan na magwagi. Nawe da nagatittu kitu alingúdu wa bantay. ");
INSERT INTO isd_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ay kitu kaatán da kitúni, ay naussi tu singan ne Jesus kitu pagmar-marngán da. Pummaláng nga ummán ki mata tu murang na. Ay tu bádu na ay nagpusà tutu wala nga dummiláng pe. ");
INSERT INTO isd_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Se dala pagkìlát tu Moses se tu Elias nga makibàbànán ke Jesus. ");
INSERT INTO isd_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ay tútu nán tu Pedro ke Jesus, “Apu, napiya nu magyán tada kídi. Nu piyán mu ay mangwa ngà ka tallu wa baw-bawi kídi. Kuwám ya isa, kuwa Moses ya isa, ay ya isa, ay kuwa ne Elias,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ay kitu akun-oni ne Pedro, ay naangpán da kitu dumiláng nga angap. Ay uwad úni nga naggayát kitu angap nga nán na kade Pedro, “Tú idi ya An-anà ku wa pà-pàgan ku, nga anggamman ku pànang pe. Manggìna kayu kaggína,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ay kane magìna datu tù-tùgúdán na tu úni, ay nagpalintud da se da nagukkab kitu lusà. Nagansing da pànang. ");
INSERT INTO isd_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ngamay nawe tinùbítán ne Jesus da nga nán na kaggída, “Gumnikát kayu, ay akkan kayu mansing!” nán na. ");
INSERT INTO isd_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ay kane maglanga da, ay e Jesus sala tu nasingan da. ");
INSERT INTO isd_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ay kitu annagut da kitun na bantay, ay binil-bílin ne Jesus da nga nán na, “Akkan nu kag-kagiyan ki oray iinna tu nasingan nu panda kiya ilaltù a nengágan da kitun ka An-anà Tolay,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ay nagsaludsud datu tù-tùgúdán na kaggína nga nán da, “Taanna, tura lugud nán daya maragtùgud ki lintag nga munna pikam ma umbet tu Elias sa pagbàbànánan ne Dios,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ay nán ne Jesus nga summungbát, “Kurug ga munna nga umbet tu Elias nga mangappiya kiya ngámingámin. ");
INSERT INTO isd_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ngamay kagiyan ku kadakayu nga inumbet tin tu Elias may akkan nalas-lásin daya tolay. Ay kinuwa da kaggína tu piyán da kampela ngin. Ay ummán pe kiyán ya kuwaan da kiyà a nengágan da kitun ka An-anà Tolay. Par-parigátan dà pe,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ay tútu naawátan datu tù-tùgúdán na ngin nga tu Juan na marammawtisár tu kag-kagiyan na kaggída. ");
INSERT INTO isd_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ay kane makadatang da kitu giyán datu adu wa tolay, ay uwad isa nga laláki nga inumbet nga nagpalintud ki àráng ne Jesus nga nán na, ");
INSERT INTO isd_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Apu! kalakkám mán agpà ya an-anà ku wa laláki, ta magkangkang. Ay mapar-parigátan pànang. Nakírad da mìtol kiya apuy, ay oray pe kiya danum. ");
INSERT INTO isd_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nilbet ku kadaya tù-tùgúdán mu, ngamay akkan da mà maagásan,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ay nán ne Jesus nga summungbát, “Dakayu wa tolay kadedi yin na al-algaw, tura nu áwan pikam ma angngurug ta! Akkan nu ammu win ya napiya. Tagay yà in na molaw ngamay anúsán ku wala ya sumeng kadakayu. Ilbet nu kídi ya an-anà!” nán na. ");
INSERT INTO isd_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ay se yala linùsaw ne Jesus tu áran kitu an-anà ta palawanan na, ay tútu lummawán. Ay díkod dágus sala nga naagásan tu an-anà. ");
INSERT INTO isd_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ay se yala nga inumbet datu tù-tùgúdán ne Jesus kane sissa. Ay nán da kaggína nga nagsaludsud, “Taanna tura mi akkan na mapatálaw tu áran?” nán da. ");
INSERT INTO isd_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","“Ò á, ta bittì pànang ya angngurug nu,” nán ne Jesus. “Ata ikagì kadakayu nga, nu ya angngurug nu ay ummán kuma ngala kiya kadakkal naya bukal mustása, ay mabalin nu wa nán kídi ya bantay, ‘Magalit ka kitúni,’ nán nu, ay magalit kurug. Ay áwan nu wa di màwa. ");
INSERT INTO isd_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ngamay itun nga áran, ay akkan nu wala nga mapatálaw nu akkan kayu magngílin mangán kiya agkar-karárag nu,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ay kane magguurnung manin de Jesus se datu tù-tùgúdán na ka Galilea, ay nán ne Jesus kaggída, “Iyà nga nengágan da kitun ka An-anà Tolay, ay ipatiliw dà. ");
INSERT INTO isd_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ay se dà a patayan, ngamay lumtu wà kiya mekàlu wa algaw,” nán na. Ay díkod nagpannakit pànang datu tù-tùgúdán na. ");
INSERT INTO isd_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ay kane atán de Jesus sin se datu tù-tùgúdán na ka Capernaum, ay nagsaludsud ke Pedro tu magpab-pabáyad ka buis kitu Templo nga nán na, “Magbay-báyad ya misturu nu ka buis na para kiya Templo?” nán na. ");
INSERT INTO isd_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Magbay-báyad á,” nán ne Pedro wa summungbát. Ay kane dummatang da kitu balay, ay aggína tu nunna nga inamomanán ne Jesus nga nán na, “Nágan naya nán mu kídi Simon? Inda ya pagbayádan naya ári ka sedula se buis, daya akkobung na onu daya akkan na nga akkobung?” nán na. ");
INSERT INTO isd_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ay nán ne Pedro, “Daya akkan na nga akkobung á,” nán na. Ay tútu nán ne Jesus, “Ay nu mapakuna, ay akkan lugud magbáyad daya annánà na. ");
INSERT INTO isd_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ngamay ta senu akkan ditta lùsawan daya magpab-pabáyad ka buis ka Templo, ay magbáyad ta. Mawe ka lugud da maneding ka bebay. Ay ungátam ya bugung naya sissida nga munna nga mànám, ay atán pirà a masingan mu. Ay alà mu ta ittu ya iddem nga pagbuis ta nga duwa kiya Templo,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ay kitun na oras, ay ummadanni datu tù-tùgúdán ne Jesus kaggína nga nán da, “Inna nád ya kangatuwán kiya pangiturayán ne Dios?” nán da. ");
INSERT INTO isd_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ay tútu kirrawán ne Jesus tu isa nga an-anà, ay se na nga pinagsíkád kitu àráng da. ");
INSERT INTO isd_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ay se na nán kaggída, “Dam-damdamman nu idi ya nán ku, nga akkan kayu wa makalnà kiya pangiturayán ne Dios nu akkan kayu wa manguliulis se magbalin ka ummán kadaya annánà. ");
INSERT INTO isd_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ata oray iinna nga magpakumbaba se magbalin ka ummán kídi ya an-anà, ay ittu yán ya kangatuwán kiya pangiturayán ne Dios. ");
INSERT INTO isd_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ay nu iinna ya mamatag kiya an-anà a ummán kídi gapu kiya angngurug na kiyà, ay bíláng nga iyà ya pinatag na.” ");
INSERT INTO isd_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ngamay nu iinna nga tolay ya gapu naya pakabasúlán dedi ya annánà a mangurug kiyà, ay napì-piya ngala kiyán na tolay nu mabissinán ka abay batu ya bùlaw na se yala mepisù kiya kadalmán naya bebay. ");
INSERT INTO isd_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Nasulit pànang ya kapà-pàyanán daya tolay kídi ya kalawagán gapu kadaya kapar-paroán da! Ata atán peyang daya kapar-paroán da, ngamay kakal-kalakkán ya tolay ya kegay-gayatán da! ");
INSERT INTO isd_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ay nu iya ímam onu síkil mu ya gapu naya akabásul mu, ay pùdam se mu la ippà. Ata napì-piya ya sissa íma se síkil la mawe ka lángit may iya duwa síkil se duwa íma nga mippan ka impiyernu. ");
INSERT INTO isd_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ay ummán pe, nu ya isa mata mu ya gapu naya akabásul mu, ay tukilam se mu la nga ippà. Ata napì-piya ya sissa mata nga mawe ka lángit may iya duwa mata nga mippan ka impiyernu.” ");
INSERT INTO isd_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Sinnan nu ta áwan nu wa irupat kadedi ya annánà,” nán na kadatu tù-tùgúdán na. “Ta kurug ya ikagì kadakayu nga daya anghel la magtagasíngan kaggída, ay atán da peyang kiya àráng naya Amà nga atán ka lángit. ");
INSERT INTO isd_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ata iyà nga nengágan da kitun ka An-anà Tolay, ay inumbet tà a mangalà kadaya nawagwag,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Kiya kapanunútán nu, nágan naya kuwaan naya isa tolay nu ra la nga nawagwag ya isa kadaya magatut ta karneru na nga ipas-pastor na? Ay gángay á nga panáwan na datu siyám púlu se siyám kitu pagpastuwán na, ay se na nga we sapúlan tu nawagwag. ");
INSERT INTO isd_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ay nu masmà na, ay ab-abay ya agganggam na kídi ya isa may iya agganggam na kadatu siyám púlu se siyám ma akkan na nawagwag. ");
INSERT INTO isd_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ay ummán pe kiyán ke Ama nu wa atán ka lángit. Akkan na nga piyán nu atán ya mawagwag ka áwan panda kadedi ya annánà.” ");
INSERT INTO isd_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ay nu makabásul kikaw ya wagi mu, ay mawem ipakammu kaggína ya básul na. Ngamay masápul la dudduwa kayu kampela ngin. Ay nu gìnán naka, ay napatolim ya agwagi nu. ");
INSERT INTO isd_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ngamay nu akkan naka pàgan, ay magayáb ka ka duwa onu tallu wa magsistígu kadaya paggaamomanán nu. ");
INSERT INTO isd_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ay nu maddi manggìna kaggída pe, ay ipakammu mu win kadaya kabbulun nu wa tolay ne Dios. Ay nu akkan pikam manggìna kaggída, ay ibíláng nu win na áwan na nga angngurug ke Dios onu ummán kadaya nadakè a magpab-pabáyad ka buis.” ");
INSERT INTO isd_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ikagì kadakayu nga, oray nágan na nga iallang nu kídi ya kalawagán, ay meallang pe ka lángit. Ay oray nu nágan pe nga ipalúbus nu kídi ya kalawagán, ay mepalúbus pe ka lángit. ");
INSERT INTO isd_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ay ikagì manin kadakayu nga nu atán duwa kadakayu kídi ya kalawagán ya magannúgut ka uray nga magadang kiya piyán da nga agngan, ay idde ne Ama nga atán ka lángit ya agngan nu. ");
INSERT INTO isd_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ata oray wà naya giyán daya duwa onu tallu wa nagguurnung gapu kiyà, ay mepagataatán nà pe kaggída,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kitun, ay ummadanni ye Pedro ke Jesus, ay se na nán kaggína, “Apu, mamin-piga nga makabásul kiyà ya wagi ku nga annung ku pakawanan? Mamin-pittu nád?” nán na. ");
INSERT INTO isd_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","“Akkan nala nga mamin-pittu,” nán ne Jesus, “nu di mamin-pittu púlu wa pittu,” nán na ke Pedro. ");
INSERT INTO isd_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ay se yala nga nán manin ne Jesus, “Ya angngituráy ne Dios, ay meárig kiya kinuwa naya isa nga ári nga nawe magsingir kadatu asassu na. ");
INSERT INTO isd_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ay idi nga ári, kane manggayát magsingir, ay nilbet da tu isa nga nakaútáng kaggína ka sangapúlu ríbu wa pinaláta nga silber. ");
INSERT INTO isd_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ay gapu ta áwan umanáy ya pagbáyad natu nakaútáng, ay masápul la meláku da kuma nga maggaáma se maggiína se ngámin na kuw-kuwa na ka pagbáyad na kitu útáng na. ");
INSERT INTO isd_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ay tútu nagpalintud nga nakim-imallà tu asassu kitu apu na nga nán na, ‘Anúsán nà agpà pikam ápu, ta bayádan ku ngámin daya útáng ku kikaw nu kuwa!’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ay díkod nakalakkán tu ári kitu asassu. Ay tútu binay-án na ngala ngin ngámin tu útáng natu asassu, ay se na nga pinapan nin. ");
INSERT INTO isd_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ngamay kane mawe tu asassu win, ay nesalabatán na tu páda na nga asassu nga nakaútáng kaggína ka limma gatut pinaláta nga silber. Ay dinugkam na, ay se na nga pàlan nga nán na kaggína, ‘Bayádam tu útáng mu!’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ay díkod, tu páda na nga asassu, ay nagpalintud nga nakim-imallà kaggína nga nán na, ‘Anúsán nà pikam agpà ta bayádan ku ya útáng ku kikaw nu kuwa,’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ngamay akkan na nga kinalakkán nu di na lugud nepebálud panda kitu agbáyad na kitu útáng na. ");
INSERT INTO isd_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ay kane masingan datu páda da nga asassu tu kinuwa na, ay nagpannakit da pànang gapu kitu isa. Ay nawe da nga nepipílit kitu apu da tu ngámin na nà-nàwa. ");
INSERT INTO isd_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ay díkod pinaayabán natu apu da tu asassu na. Ay nán na kitu asassu, ‘Nagdakè mu wa asassu! Pinakawan taka kitu ngámin na útáng mu kane makim-imallà ka kiya! ");
INSERT INTO isd_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kinalakkán taka, may taanna, tura mu di kinalakkán ya pádam ma asassu nga ummán kitu inagkallà ku kikaw!’ nán natu apu. ");
INSERT INTO isd_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ay díkod nakarungat pànang tu apu na. Ay tútu nepebálud na tu asassu panda kitu akabáyad na kitu ngámin útáng na. ");
INSERT INTO isd_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ay ummán pe kiyán ya kuwaan naya Amà ka lángit kadakayu nu akkan nu pakawanan tutu wala ya wagi nu,” nán ne Jesus kadatu tù-tùgúdán na. ");
INSERT INTO isd_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ay kane mabalin ne Jesus nga kagiyan datun, ay nagtálaw win kitúni Galilea, ay se yala nawe kitu giyán na sakúpan naya Judea nga panidmáng wángag Jordan. ");
INSERT INTO isd_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ay adu tutu wala datu tolay ya gummunud kaggína. Ay pinabílag na datu atán sin-sinakit kaggída. ");
INSERT INTO isd_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ay uwad da nga Pariseo wa inumbet ta magsisim ke Jesus. Ay nán da kaggína, “Meallang nád kiya lintag, nga magadi ya isa nga tolay kiya atáwa na ka panggap ka oray nágan na?” nán da. ");
INSERT INTO isd_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ay summungbát ta nán na, “Akkan nu nád pikam nabása kiya nesúrát ta bàbànán ne Dios, nga kitu inanggayát na, ay kinuwa ne Dios ya tolay ka laláki se babay? ");
INSERT INTO isd_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ay nán na pe nga, ‘Gapu kídi, ay panáwan naya laláki daya maganà kaggína ta mawe na nga kobungan ya atáwa na, ay magbalin da nga duwa ka sissa,’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ay túya akkan da nga duwa ngin nu di da nga sissa ngin. Ay díkod akkan mabalin na pagsibnaan naya tolay ya pinagamung ne Dios,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ay tútu nagsaludsud manin datu Pariseo nga nán da, “Ay taanna lugud, tura nepalúbus tu Moses kitu lintag na nga mangidde ya laláki ka kasurátan kiya atáwa na, ay se yala nga magadi,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ay nán ne Jesus kaggída manin, “Nepalúbus tu Moses nga magadi kayu kadaya attáwa nu gapu kiya kinasúkir nu. Ngamay akkan ummán kiyán kitu inanggayát na. ");
INSERT INTO isd_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ay ya kagiyan ku kadakayu, ay nu iinna nga laláki ya mangigsán kiya atáwa na, ay se mangatáwa ka sabáli, ay bíláng nga manaládag yán, malaksid nu makidaládag tu atáwa na.” ");
INSERT INTO isd_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ay tútu nán datu tù-tùgúdán na kaggína, “Ay nu ummán lugud kiyán ya kàwaán daya maggaattáwa ay napì-piya ngala ngin lugud nu akkan ta tagge mangatáwa,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ngamay nán na kaggída, “Akkan ngámin tolay ya makabaal kadedi ya sur-súru nu di yala daya pangitudinán ne Dios. ");
INSERT INTO isd_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ata adu ya gapu na nga maddi makapangatáwa daya duddúma. Atán da nga maddi makapangatáwa áta neanà da nga atán sadúra kiya kinalaláki da. Ay atán da pe ya maddi makapangatáwa áta linsitán da tolay da. Ay atán pe daya duddúma nga maddi da kammala ngin gapu kiya amminya da nga magsirbi ke Dios mepanggap kiya angngituráy na. Ay daya makabaal la mangwa kídi ay kuwaan da ngala.” ");
INSERT INTO isd_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ay uwad da pe ya nangilbet kadatu annánà da ke Jesus, ta senu immán nada nga ikarárag. Ngamay kinalùsaw datu tù-tùgúdán na da. ");
INSERT INTO isd_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ngamay nán ne Jesus, “Palubúsán nu wala daya annánà nga umbet kiyà. Akkan nuda paddiyan, áta ummán kadedi ya annánà daya itur-turayán ne Dios kiya pangiturayán na,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ay tútu inimmán na tu úlu ngámin datu annánà ay se yala nga nawe. ");
INSERT INTO isd_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ay uwad isa nga laláki ya inumbet ta nagsaludsud ke Jesus. Ay nán na, “Misturu, nágan naya napiya nga kuwaan ku ta senu middán nà ka biyág ga áwan panda?” nán na. ");
INSERT INTO isd_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ay nán ne Jesus kaggína, “Tura nà a saludsúdán nu nágan naya napiya? Ay sissa ngala ya makàwa ka napiya. Ay nu piyán mu ya mabiyág ka áwan panda, ay kurugam daya bil-bílin ne Dios,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“Nágan na nga bílin?” nán tu laláki. Ay tútu nán ne Jesus, “Datu lin-lintag ummán kadaya akkan ka pumatay, akkan ka nga manaládag, akkan ka nga magtákaw, akkan ka nga magbusid. ");
INSERT INTO isd_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ipatag mu daya amám se inám, ay piyám ya kasittolay mu nga ummán kiya amminyám kiya baggim, nán na,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","“Kur-kurugan ku mà ngámin dayanin na bil-bílin,” nán natu laláki nga summungbát. “Ay nágan pikam daya masápul la kuwaan ku?” nán na. ");
INSERT INTO isd_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ay tútu nán ne Jesus kaggína, “Ay nu piyán mu ya áwan pagkur-kurángan, ay mawe mu iláku ngámin datu kuw-kuwám ta iddem ya paglakúwám kadaya napubri. Ay díkod atán ya bànáng mu ka lángit tin. Ay se ka la nga kumíwid kiyà,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ay kane magìna natu bag-bagu tun, ay nagtálaw nga sippapannakit, áta nabànáng pànang. ");
INSERT INTO isd_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ay se la nán ne Jesus kadatu tù-tùgúdán na, “Kagiyan ku kadakayu nga nasulit kadaya nabànáng ya meráman kiya pangiturayán ne Dios. ");
INSERT INTO isd_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ata ikagì kadakayu nga nalà-lapat tala nga lumbut kiya abbut dágum ya kámel may iya keráman daya nabànáng kiya pangiturayán ne Dios.” ");
INSERT INTO isd_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ay kane magìna datu tù-tùgúdán na tun na kinagi na, ay nasdaáwan da pànang nga nán da, “Ay iinda lugud daya málà kiya pangiturayán ne Dios?” nán da. ");
INSERT INTO isd_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ay binubutgán ne Jesus da nga nán na, “Akkan màwa naya tolay yala idi, may áwan na di màwa ne Dios,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ay tútu nán ne Pedro wa summungbát, “Ay mapaanna kami lugud? Nigsán mi ya ngámingámin gapu kiya ikikkíwid mi kikaw. Ay nágan naya magun-ud mi?” nán na. ");
INSERT INTO isd_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ay nán ne Jesus kaggída, “Damdamman nu idi nga kagiyan ku kadakayu. Nga iyà nga nengágan da kitun ka An-anà Tolay, nu kiya agtugaw ku wa mangituráy kiya baru wa kalawagán, ay dakayu wa kumiw-kíwid kiyà, ay mepagtugaw kayu pe kiyà nga mangituráy kadaya sangapúlu se duwa nga tangámalán ka Israel. Ay kiyán na al-algaw, ay nadáyaw ya angngituráy ku. ");
INSERT INTO isd_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ay se ngámin daya namánaw kadaya balay da, wawwági da, onu daya magannánà kaggída, onu daya annánà da, onu ya lusà da gapu kiya ikikkíwid da kiyà, ay mapataliyán da ka ad-adu may dayán na nigsán da. Ay mabiyág da pe ka áwan panda. ");
INSERT INTO isd_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ngamay adu daya magkuna nga mepangátu da, ngamay ummán da ka mebaba. Ay adu pe daya magkuna nga nababa da, ngamay ummán da ka mepangátu áta nagpapáda ya màwa kadaya napuddi onu napunna nga sumúrut kiyà.” ");
INSERT INTO isd_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ata ya pangiturayán ne Dios, ay meárig kiya kinuwa naya tolay ya atán kaubásan. Gumab-gabi ya lumawán nga magsápul ka pilluwan na nga magubra kiya kaubásan na. ");
INSERT INTO isd_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ay kane mapaggaamomanán da se datu tolay nga tangdánan nada kitu gángay ya panangdán kiya tangalgaw, ay pinapan nada kitu kaubásan na. ");
INSERT INTO isd_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ay kane sir-sirnà in, ay lummawán manin. Ay nasingan na datu tolay ya magsisíkád dala kitu sininda nga áwan kuk-kuwaan. ");
INSERT INTO isd_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ay tútu nán na kaggída, ‘Mawe kayu pe ya magubra kitu kaubásan ku. Ay annung na kam ya panangdán ku kadakayu,’ nán na. Ay tútu nawe manin datu tolay. ");
INSERT INTO isd_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ay kane din na mangalintutúgu, ay se kitu amreg na, ay ittu manin tu kinuwa na. Ay nakasmà manin ka pilluwan na. ");
INSERT INTO isd_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ay kane gumídagídám min, ay lummawán manin, ay nasmà na manin datu duddúma nga tolay ya magis-istambay yala. Ay nán na kaggída, ‘Tura kayu nanangalgaw wala nga nagistambay kídi?’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ay nán da kaggína, ‘Awan mà mayát mamillu kadakami,’ nán da. Ay tútu nán na kaggída, ‘Mawe kayu lugud pe nga magubra kitu kaubásan ku,’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ay kane gì-gìbat tin, ay nán tu tolay yin kitu piyáran na, ‘Mawem buwàan datu magubra ta tangdánan muda ngin. Gayatam kadatu nuddi ya inumbet se yala kadatu nunna,’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ay kane inumbet datu tolay ya nagídám ma summikáp pa nagubra, ay natangdánan da pe kitu gángay ya tangdán kiya tangalgaw. ");
INSERT INTO isd_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ay kane din na dumatang kadatu nagabi nga sumikáp pa nagubra, ay dálin da nu ad-adu tu tangdán da. Ngamay akkan, ta sangapáda da ngámin ka tangdán. ");
INSERT INTO isd_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ay díkod kane málà da datu tangdán da, ay nagríri da kitu makin-kuwa kitu kaubásan, ");
INSERT INTO isd_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","nga nán da, ‘Tang-tanga oras ya naggubra dedi ya napuddi, ay nepádam kadakami ya pinanangdán mu kaggída! Ay dakami ay tangalgaw kami nga napasiya se nagánus kiya takit naya sínág,’ nán da. ");
INSERT INTO isd_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ngamay nán tu tolay kitu isa kaggída, ‘Akkan taka mà kinultit a, opun! Di mà a tu gángay tangdán kiya tangalgaw tu nagturatuwán ta? ");
INSERT INTO isd_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Alà mu ya tangdán mu ta mawe ka ngin. Piyán ku kampela ngin nin nga ipáda ya panangdán ku kadedi ya napuddi kiya pinanangdán ku kikaw. ");
INSERT INTO isd_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Rabbang ku mà a kuwaan ya piyán ku kampela ngin nin na kuwaan kiya pirà ku. Umsil ka kid gapu ta naparon nà!’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ay díkod daya magkuna nga mepangátu da ay mebaba da. Ay daya magkuna nga nababa da, ay mepangátu da,” nán ne Jesus kaggída. ");
INSERT INTO isd_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ay kane manùdu da ngin na mameyag ka Jerusalem, ay nagatittu de Jesus se datu sangapúlu se duwa nga tù-tùgúdán na. Ay se na nán kaggída kane magdal-dalen da, ");
INSERT INTO isd_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Jerusalem ya pameyaggán tada kídi. Ay iyà nga nengágan da kitun ka An-anà Tolay, ay ipatiliw dà kitúni, ay se dà ippan kadaya nangátu wa pappádi se kadaya maragtùgud ki lintag. Ay se dà a sentinsiyaán ka pannakatay. ");
INSERT INTO isd_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ay se dà iáwat kadaya akkan Judyu ta senu ug-ogan dà se dà pe ya sap-saplit. Ay se dà a ilansa ki krus ka ammatay da kiyà, ngamay kiya mekàlu ngalgaw ay lumtu wà kammin,” nán na kadatu tù-tùgúdán na. ");
INSERT INTO isd_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ay se yala nga inumbet ke Jesus tu atáwa ne Zebedeo se datu duwa nga annánà na. Nagpalintud ki àráng ne Jesus ta atán piyán na agngan. ");
INSERT INTO isd_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ay se yala nán ne Jesus kaggína, “Nágan naya masápul mu?” nán na. Ay summungbát ta nán na, “Pepagtugawan mu mán kikaw daya duwa nga annánà ku nu umbet ka nga mangituráy. Isa kiya padne diwanán mu, ay isa kiya padne kasígid mu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ngamay summungbát te Jesus nga nán na “Akkan mu wa maaw-awátan ya agngam. Meturad nu nád daya meturdán ku?” nán na. Ay, “Annung mi,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ay nán na kaggída, “Annung nu wa meturdán daya meturdán ku, ngamay áwan ku pagrabngán na mangpíli nu iinna ya mepagtugaw kiyà kiya padne diwanán ku se padne kasígid ku. Ata dedi ya pagtugawán, ay kuwa daya nangisaganáan naya Amà,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ay kane magìna datu sangapúlu wa tù-tùgúdán ne Jesus tun, ay kinalùsaw da datu magwagi. ");
INSERT INTO isd_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ay tútu kirrawán nada ngámin se na nán kaggída, “Ammu nu wa daya agtuturáy daya akkan Judyu, ay itur-turayán da daya tolay da. Ay se daya ap-apu kaggída, ay ipassingan da ya kinaapu da kadaya tolay. ");
INSERT INTO isd_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ngamay akkan ummán kiyán ya màwa kadakayu. Ata ya maminya nga mepangátu, ay masápul la aggína ya magsirbi kadaya kabbulun na. ");
INSERT INTO isd_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ay nu iinna kadakayu ya maminya nga mangiapu, ay aggína kuma ya bátug asassu nu, ");
INSERT INTO isd_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","nga ummán kiyà a nengágan da kitun ka An-anà Tolay. Akkan nà inumbet ta pasirbiyán kadaya tolay, nu di iyà ya magsirbi kaggída. Ay inumbet tà pe nga mebasu ta senu mekáru daya bas-básul daya adu wa tolay.” ");
INSERT INTO isd_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ay kane din na magtálaw da ka Jerico, ay adu datu tolay ya gumun-gunud ke Jesus. ");
INSERT INTO isd_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ay uwad da nga duwa nga lalláki nga kúláp nga magtutúgaw kitu bíkat kalsáda. Ay kane mammuwán da nga lumíwán ne Jesus, ay nán da nga nesar-sáraw, “Gaka natu David! Kalakkán nakami agpà,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ay kinalùsaw datu tolay da, ay se dada anawáan, ngamay kinggat da mán kammin tu nagkuna da ka, “Gaka tu David! Kalakkán nakami agpà, Apu!” nán da. ");
INSERT INTO isd_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ay tútu nagsínang nge Jesus, ay se nada nga pinalbet. Ay nán na kaggída, “Nágan naya piyán nu wa kuwaan ku kadakayu?” nán na. ");
INSERT INTO isd_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ay nán da kaggína, “Apu, pakasinnan nakami mán,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ay nakalakkán ne Jesus kaggída, ay tútu inimmán na datu mata da, ay dágus sala nga nakasingan da. Ay se da nga kummíwid kaggína ngin. ");
INSERT INTO isd_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ay kane din na magiddadatang da ngin ka Jerusalem, ta atán da ngin ka Betpage kitu bantay Olivo, ay nepàrob ne Jesus datu duwa nga tù-tùgúdán na nga nán na kaggída, ");
INSERT INTO isd_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Mawe kayu kiya amin-dupálan na íli, ay masingan nu wala nga dágus ya negagálut ta asnu wa atán urbun na. Ubbadán nu, ay se nuda nga ilbet kídi. ");
INSERT INTO isd_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ay nu atán mangsitár kadakayu, ay kagiyan nu wala nga, ‘Masápul ne Apu da,’ nán nu, ay pálà nada ngin kadakayu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ay nàwa idi ta senu màwa kurug tu kinagi natu pagbàbànánan ne Dios kitun nga nán na: ");
INSERT INTO isd_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Kagiyam kadaya iJerusalem. Sinnan nu! Umbet tin kadakayu ya ári nu. Napakumbaba, ay urbun asnu wala ya nagtàyán na,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ay díkod nawe datu tù-tùgúdán na, ay kinurug da tu nán ne Jesus kaggída. ");
INSERT INTO isd_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nilbet da datu asnu se itu urbun na, ay se da nga nesàláp datu bádu da kitu addag datu asnu, ay se yala nagtakay ye Jesus kitu urbun. ");
INSERT INTO isd_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ay kaaduwán kadatu tolay, ay nesàlapán da datu bádu da kitu kalsáda. Ay datu duddúma ay nagtappád da kadatu pas-pasanga datu káyu, ay se da iap-apán kitu kalsáda. ");
INSERT INTO isd_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ay datu adu wa tolay ya magin-inona kaggína se datu gumun-gunud, ay nán da nga nesar-sáraw, “Maday-dáyaw ya gaka tu Ari David. Tag-tagasinnán ne Apu Dios ya nebon na! Maday-dáyaw we Dios nga kangatuwán!” nán da. ");
INSERT INTO isd_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ay kane makalnà nge Jesus ka Jerusalem, ay naburbur datu tolay. Ay nán da, “Inna nád tuni?” nán da. ");
INSERT INTO isd_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ay tútu nán datu tolay, “Tú yán ne Jesus nga iNazaret ka Galilea nga isa nga pagbàbànánan ne Dios,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Linumnà e Jesus kitu Templo, ay se na pataláwan ngámin datu maglà-láku se datu gumà-gátang kitu unag natu templo. Nìtolán na datu tebol datu maragsupli ka pirà se datu tugaw datu maglà-láku ka ladágan. ");
INSERT INTO isd_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ay nán na kaggída, “Nán naya nesúrát ta bàbànán ne Dios nga, ‘Ya balay ku ay mengagánan ka balay ya agkararágan,’ nán na. Ngamay tura nu mán kammin pinagbalin ka balay daya maragtákaw,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ay uwad da nga kúláp se pílay nga inumbet kitu giyán ne Jesus kitu Templo, ay inagásan nada. ");
INSERT INTO isd_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ay nalùsaw datu ap-apu datu pappádi se datu maragtùgud ki lintag kane masingan da datu nakas-kasdáaw wa kinuw-kuwa ne Jesus, se kane magìna da datu annánà a atán kitu unag Templo nga isar-sáraw da ya, “Maday-dáyaw ya gaka natu David!” nán da. ");
INSERT INTO isd_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ay tútu nán da kaggína, “Magìna mu ya isar-sáraw da?” nán da. Ata nalùsaw da ta pagdudoray ne Jesus datu annánà kitu isar-sáraw da. Ay nán ne Jesus kaggída, “May ò,” nán na. “Akkan nu pikam nabása ta, tu nesúrát kiya bàbànán ne Dios kitun nga nán na, ‘Nasuruwán daya ababbing se daya annánà nga mangagi kiya kurug ga panagday-dáyaw kikaw,’ nán na!” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ay pinanáwan ne Jesus da, ay se yala nagtálaw kitu íli se yala nawe ka Betania. Ay nagidda kitúni. ");
INSERT INTO isd_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ay kane magulli kammin ka Jerusalem kane pagmakát, ay nabisinán. ");
INSERT INTO isd_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ay tútu, kane masingan na tu káyu wa gígus kitu bíkat dálen, ay nawe nagsápul ka búnga na, may áwan na nga nasuwà nu di adon nala. Ay tútu nán na kitu káyu, “Ay akkan ka din makapagbúnga ngin ka panda,” nán na. Ay pìlát tala nga nalaylay tu káyu. ");
INSERT INTO isd_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ay díkod nasdaáwan datu tù-tùgúdán na kane masingan da tun. Ay nán da, “Mapaanna ya nàwa? Tura dágus sala nga nalaylay ya káyu kídi?” nán da. ");
INSERT INTO isd_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ay nán ne Jesus nga summungbát kaggída, “Damdamman nu idi nga, nu mangurug kayu wa áwan nu wa aggad-gadduwa, ay mabalin nu pe nga kuwaan ya kinuwà kídi ya káyu. Ay akkan nala tittu yán ta oray nán nu kídi nga bantay ya, ‘Magalit ka kiyán se ka la magpisù kiya bebay,’ nán nu, ay màwa nga kurug. ");
INSERT INTO isd_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ay oray nágan naya agngan nu kiya karárag nu nu atán ya angngurug nu, ay midde kadakayu.” ");
INSERT INTO isd_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ay nagulli kammin ne Jesus kitu Templo nga magtùgud. Ay kane magtù-tùgud din, ay inumbet nga nagsaludsud datu ap-apu datu pappádi se datu pangmanàman datu Judyu nga nán da, “Wà naggayatán naya turáy mu wa mangwa kadedi nga kuk-kuwaan mu, ay se iinna ya nangidde kikaw kiyán na turáy mu?” nán da. ");
INSERT INTO isd_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","May nán ne Jesus nga summungbát, “Magsaludsud dà pikam kadakayu. Ay nu masungbátan dà, ay ikagì pe kadakayu nu wà naya naggayatán naya turáy ku wa mangwa kadedi,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","“Wà na lugud ya naggayatán natu turáy natu Juan nga mamawtisár? Naggayát ke Dios onu kadaya tolay?” nán na. Ay tútu nán da nga nagsisinnaludsud. “Nágan naya pagsungbát tada? Nu nán tada nga, ‘Naggayát ke Dios,’ ay, ‘Tura nu lugud da akkan kinurug tu Juan?’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ngamay nu nán tada nga, ‘Gayát kadaya tolay,’ ay dedi manin na tolay ya ikansing tada, ta kurugan da nga isa nga pagbàbànánan ne Dios tu Juan,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ay díkod nán da ngala ngin na summungbát ke Jesus, “Akkan mi ammu,” nán da. Ay tútu nán ne Jesus pe kaggída, “Ay akkan ku lugud pe ikagi kadakayu nu wà naggayatán naya turáy ku wa mangwa kadedi,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ay nán ne Jesus kaggída, “Nágan naya makagi nu kídi? Atán tolay ya atán duwa annánà na nga lalláki. Ay nán natu ama kitu manákam, ‘Mawe ka mán na magubra kiya kaubásan, ugu,’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ay, ‘Maddi yà,’ nán tu an-anà. Ngamay naulis kammin tu uray na kane daddán, ay tútu nawe kitu kaubásan da. ");
INSERT INTO isd_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ay nán manin tu tolay kitu udiyán, ‘Mawe ka mán na magubra kiya kaubásan, ugu,’ nán na. Ay, ‘Ò ama,’ nán na, ngamay akkan nawe. ");
INSERT INTO isd_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ay iinna lugud kaggída nga duwa tu nangikurug kitu piyán natu ama da?” nán ne Jesus. “Tu manákam á,” nán da. Ay nán ne Jesus kaggída, “Tú idi ya kagiyan ku kadakayu. Munna daya magpab-pabáyad ka buis nga nadakè se daya put-púta nga makalnà kiya pangiturayán ne Dios may dakayu. ");
INSERT INTO isd_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ata inumbet tu Juan na mangipakammu kiya panagmar-máru nu, ngamay akkan nu wa kinurug. Ay datu magpab-pabáyad ka buis se datu púta ay kinurug da. Ay oray kitu inakasingan nu kitu inangngurug da kitu Juan, ay akkan kayu wa nakappoli se nangurug kaggína,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Ay gìnán nu pikam idi ya isa nga pangárig,” nán ne Jesus. “Uwad tolay ya nagmúla ka adu wa úbás. Ay se nada abutan. Ay se nagabbut ka abay kitu pínát ka pamgattán da kitu búnga úbás. Ay nangwa pe ka alingúdu wa bal-balay. Ay se na nga pinatagasinnán tu kaubásan kadatu magtal-tálun, ay se mawe ka sabáli íli. ");
INSERT INTO isd_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ay kane din na pinagbubúrás sin, ay nangibon tu makin-kuwa kadatu asassu na nga mawe mangalà kitu kípát na kadatu magtag-tagasíngan kitu kaubásan na. ");
INSERT INTO isd_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ngamay inámang mán kammin datu magtag-tagasíngan kitu kaubásan datu asassu natu tolay. Binaubáut da tu isa, ay pinatay da tu isa, ay tinùtoán da tu isa. ");
INSERT INTO isd_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ay díkod, nangibon ka ad-adu wa asassu may datu nunna. Ngamay páda na kam tu kinuwa da kadatu nebon na. ");
INSERT INTO isd_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ay tu nuddi ya nebon na, ay tu an-anà na, áta nán na nga, ‘Ipatag da kam agkà ala ya an-anà ku!’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ngamay kane masingan datu magtag-tagasíngan kitu kaubásan tu an-anà tu tolay, ay nán da kitu isaisa kaggída, ‘Ye, tú yán ya mangtáwid kídi ya kaubásan. Patayan tada ta senu kuw-kuwa tada ngámin dedi ya tawídan na,’ nán da. ");
INSERT INTO isd_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ay tútu dinugkam da tu an-anà se da nga ippan kitu lasi natu kaubásan, ay se da pinatay,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Lugud,” nán ne Jesus kaggída, “nu umbet ya makin-kuwa kitu kaubásan, nágan naya nán nu wa kuwaan na kadatu magtag-tagasíngan kitu kaubásan na?” nán na. ");
INSERT INTO isd_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ay nán da nga summungbát, “Kurug gala á, nga patayan na datu nadakè a magtag-tagasíngan, ay se na pe yin na ipatagasíngan ka sabáli nga magtal-tálun na makidde kaggína kiya kípát na nu pinagbubúrás,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ay nán ne Jesus kaggída, “Akkan nu nád pikam ma nabása kiya nesúrát ta bàbànán ne Dios ya, ‘Tu batu wa lùsawan daya maragbalay, ay ittu tu nesulalit ta nagbalin ka kaligdaán na paniínán kiya súli naya balay. Kinuwa ne Apu Dios nga ummán kiyán ta ittu ya piyán na. Ay nakas-kasdáaw kadàtada yán na kinuwa na,’ nán na,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ay tútu nán ne Jesus manin, “Ay túya ikagì kadakayu nga ya pangiturayán ne Dios, ay akkan na mepakin-kuwa kadakayu wa Judyu ta midde yin kadaya tolay ya maminya nga mangwa kadaya piyán na. ");
INSERT INTO isd_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ay nu iinna ya medùláp kiyán na batu, ay matumatumà. Ay ya ketànagán na nu ittu ya metànág, ay mamàmà tutu wala,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ay kane magìna datu ap-apu datu pappádi se datu Pariseo tu kinag-kagi ne Jesus nga pangárig, ay naawátan da nga aggída tu kepapannán datun. ");
INSERT INTO isd_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ay tútu piyán da nga tiliwan, may umamà da kadatu adu tutu wala nga tolay ta ibíláng da nga pagbàbànánan ne Dios. ");
INSERT INTO isd_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ay nepangárig manin ne Jesus tu inangngagi na kadatu kinag-kagi na kadatu tolay. Ay nán na, ");
INSERT INTO isd_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ya angngituráy ne Dios, ay meárig kiya kinuwa naya ári nga nangisay-am kiya panaggaattáwa kiya an-anà na nga laláki. ");
INSERT INTO isd_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nebon natu ári datu asassu na nga mawe ya magayáb kadatu napadán naimbitarán, ngamay naddi da. ");
INSERT INTO isd_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ay tútu nangibon manin ka sabáli pikam ma asassu na. Ay nán na nga namílin kaggína, ‘Nán mu kadatu naimbitarán nga nesagána ngin ya panagpangán kiya say-am ku. Pinaparti ku win datu toru wa báka, ay oray pe datu pinalùmag ku wa urbun. Nán mu wa nakasagána ngámin nin. Túya umbet da ngámin kídi nga makisay-am.’ ");
INSERT INTO isd_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ngamay akkan nangur-kurug datu naimbitarán. Nawe datu duddúma kadatu tal-tálun da, ay datu duddúma, ay nawe da kadatu aglakúwán da. ");
INSERT INTO isd_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ay datu duddúma, ay dinugkam da mán kammin datu asassu se dada nga pinal-pallà, ay se dada nga pinatay. ");
INSERT INTO isd_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ay nalùsaw tu ári, ay tútu nebon na datu suldádu na nga mawe magpatay kadatu nagpatay kadatu asassu na, ay se na pasìdug ngámin babalay kitu íli da pe. ");
INSERT INTO isd_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ay díkod nán natu ári kadatu duddúma nga asassu na, ‘Nesagána ngámin nin ya say-am ku ngamay naddi mán kammin datu tolay ya pinaayabán ku,’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","‘Ay túya mawe kayu lugud kiya kal-kalsáda, ay se nuda ayabán kídi ya say-am daya ngámin tolay ya masingan nu,’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ay díkod, nawe datu asassu na kadatu kal-kalsáda nga nagayáb kadatu ngámin tolay ya masingan da, oray datu nadakè se datu namáru. Ay díkod napnu tutu wala ka tolay tu pagsasay-ammán. ");
INSERT INTO isd_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ay kane umbet tu ári nga maningan kadatu tolay, ay uwad isa nga tolay ya nasingan na nga akkan na nakabádu ka bádu nga para ki say-am. ");
INSERT INTO isd_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ay tútu sinaludsud na nga nán na, ‘Opun, atán ka kídi may taanna, tura ka akkan nakabádu ka bádu wa para say-am?’ nán na. Ay akkan nagun-úni tu laláki. ");
INSERT INTO isd_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ay tútu nán natu ári kadatu asassu na nga magdasár, ‘Pingílan nu ay se nu wala nga ippan kiya kagìbattán kiya lasi. Ay kitúni, ay sumángit daya tolay ay se magngar-ngarasiyat da,’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ata kurug ga adu daya maayabán may bittì daya mapíli,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ay nagkakáwe datu Pariseo win ta mawe da nga paggaamomanán ya pamàyanán da, senu atán ya pambarán da nga maniliw ke Jesus kadaya kagiyan na. ");
INSERT INTO isd_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ay tútu nepàrob da datu tolay da se datu duddúma nga bungguy ne Herodes ka giyán ne Jesus. Ay nán datu nebon, “Misturu, ammu mi nga akkan ka nga magbutabutal. Ay se isúrum pe ya kurug mepanggap kiya piyán ne Dios kadàtada nga tolay. Ay akkan mu pe ya pagdudúmán daya tolay oray nágan naya sáad da. ");
INSERT INTO isd_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ay ikagim mán lugud kadakami nu nágan naya kapanunútám. Umannúgut nád kiya lintag tada nga Judyu nu magbáyad kami ka buis mi ke Ari Cesar ka Roma, onu akkan?” nán da. ");
INSERT INTO isd_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ngamay nammuwán ne Jesus nga nadakè tu panggap da. Ay tútu nán na kaggída, “Dakayu wa magpì-pìmáru! Tura dà sisímán ta! ");
INSERT INTO isd_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Passingannán dà mán kiya pirà a pagbuis nu,” nán na. Ay tutu nidde da kaggína tu pinaláta nga pirà. ");
INSERT INTO isd_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ay se na sinaludsud kaggída, “Inna ya makin-murang se makin-ngágan kiya atán kídi ta?” nán na. ");
INSERT INTO isd_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“May e Cesar nga ári ka Roma,” nán da. Ay tútu nán ne Jesus kaggída, “Idde nu lugud ke Ari Cesar ya pagrabngán na, ay idde nu ke Dios pe daya pagrabngán na kampela ngin nin,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ay tútu nasdaáwan da kane magìna da tu kinagi na, ay tútu pinanáwan da ngala nge Jesus sin. ");
INSERT INTO isd_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ay kitun kam ma algaw, ay uwad da nga Saduceo wa inumbet kitu giyán ne Jesus. Daya Saduceo, ay tú dedi daya akkan mangurug nga lumtu daya natay. Ay nagsaludsud da ke Jesus ");
INSERT INTO isd_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","nga nán da, “Misturu,” nán da, “Nán tu Moses kitun kitu bílin na kadàtada nga Judyu, nga nu matay ya isa nga laláki, ay se áwan na nga pútut, ay masápul la umatáwa manin ya wagi na kitu atáwa na ta senu daya annánà da, ay mebíláng da nga annánà natu natay,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","“Ay uwad kadakami ya pittu wa magwawági nga pabeg lalláki. Nangatáwa tu manákam, may natay nga áwan na nga pútut. Ay díkod inatawán natu mekàduwa nga wagi na tu nabúkud ta senu magan-anà ka para kitu natay. ");
INSERT INTO isd_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","May páda na kam tu nàwa. Ay se yala manin tu mekàlu. Ay se yala manin datu duddúma ka panda kitu udiyán. ");
INSERT INTO isd_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Akkan nabayág panda kitu nekatay da ngámin, ay natay pe yin tu babay. ");
INSERT INTO isd_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ay díkod nu kiya ilaltu ngámin daya natay, ay iinna lugud kadatu pittu wa magwawági ya makin-atáwa kammin kitu babay? Ay umatáwa da mà ngámin kaggína,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ngamay nán ne Jesus nga summungbát kaggída, “Masábag kayu kiya aglam-lammat nu kiyán. Ata akkan nu maaw-awátan ya nesúrát ta bàbànán ne Dios, ay se akkan nu pe ammu ya kababalin ne Dios. ");
INSERT INTO isd_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ata kiya ilaltu datu natay, ay áwan nin ya maggaattáwa. Ka lángit, ay ummán da ngin kadaya anghel ne Dios. ");
INSERT INTO isd_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ay nu mepanggap kiya ilaltu daya natay yin, ay kurug ga lumtu da. Akkan nu pikam nabása ta, kiya nesúrát nga bàbànán ne Dios ya nán na kadakayu! ");
INSERT INTO isd_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Nán na nga, ‘Iyà ya Dios ne Abraham se Dios nà pe ye Isaac, ay se Jacob,’ nán na. E Dios ay akkan mà wayya Dios daya natay nu di Dios daya sibbiyág.” ");
INSERT INTO isd_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ay kane magìna datu tolay tu sungbát na ay nasdaáwan da. Nasdaáwan da pe kadatu itù-tùgud na. ");
INSERT INTO isd_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ngamay kane madámag datu Pariseo wa akkan nakun-oni yala datu Saduceo kitu inagsung-sungbát ne Jesus, ay nagguurnung da ta mawe da pe ka giyán na. ");
INSERT INTO isd_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ay isa nga nasírib ki lintag daya Judyu nga kabulun da tu magsisim ke Jesus. Ay nagsaludsud nga nán na, ");
INSERT INTO isd_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Misturu,” nán na, “inna ya kapàgán pànang kadaya bil-bílin kiya lintag tu Moses?” nán na. ");
INSERT INTO isd_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ay nán ne Jesus kaggína, “Ipas-pasnà mu tutu wala ya amminyám ke Apu wa Dios mu. Aggína ya pàgan mu ki ngámin na ur-uray mu se ki ngámin na lam-lammat mu, ay se ki ngámin na biyág mu. ");
INSERT INTO isd_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ittu yán ya mun-unna se kapàgán na bílin. ");
INSERT INTO isd_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ay ya mekàduwa nga kapàgán na bílin, ay páda na kam tu munna. Nán na nga, ‘Piyám ya kasittolay mu nga ummán kiya amminyám kiya baggim,’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kadedi duwa nga bílin ya kebatayán ngámin datu bil-bílin natu Moses se datu isur-súru datu pagbàbànánan ne Dios kitun,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ay kitu atán pikam datu Pariseo wa nagguurnung, ay sinaludsúdán ne Jesus da nga ");
INSERT INTO isd_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","nán na, “Nágan naya makagi nu mepanggap kiya Cristo? Iinna ya makin-gaka kaggína?” nán na. Ay, “Gaka natu David,” nán da nga summungbát. ");
INSERT INTO isd_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ay tútu nán ne Jesus manin, “Ay taanna lugud, tura nengagánan tu David ka Apu ya Cristo kane itur-turayán naya Ispiritu ne Dios? Ata nán mà tu David nga, ");
INSERT INTO isd_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ay nán ne Apu kiya Apu ku, Magtugaw ka kiya pane diwanán ku win panda kiya ammasúkù kadaya kumagúra kikaw,’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ay nu ‘Apu’ nán tu David kiya Cristo, ay mapaanna lugud ya inagbalin naya Cristo ka gaka natu David?” nán na. ");
INSERT INTO isd_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ay áwan oray isa kaggída ya nakasungbát. Ay nanggayát kitun, ay áwan tutu wala ngin ya maketurad da magsaludsud kaggína. ");
INSERT INTO isd_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ay se yala nán manin ne Jesus kadatu adu wa tolay se kadatu tù-tùgúdán na. ");
INSERT INTO isd_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Daya maragtùgud ki lintag se daya Pariseo, ay tú dayán daya mangisur-súru kiya lintag ga nesúrát tu Moses. ");
INSERT INTO isd_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ay díkod, kurugan nu se kuwaan nu pe daya isur-súru da kadakayu. Ngamay akkan nu kuwaan daya kuk-kuwaan da, áta akkan da mà a kuwaan daya isur-súru da. ");
INSERT INTO isd_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nasulit pànang nga kuwaan daya nepar-paruntù da kadatu lin-lintag nga ipasúrut da kadaya tolay, ngamay aggída mismu, ay akkan da tutu wala nga sengán daya tolay kiya angngikurug da kadayán na ipasúrut da. ");
INSERT INTO isd_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ngámin daya kuk-kuwaan da, ay pagpasindáyaw da ngala kadaya tolay. Ay túya kuwaan da ka dadakkal datu nekesurátan datu duddúma nga bílin ne Dios nga igpat da kiya íma da. Ay kadadduwan da pe ya arumaymáy naya bádu da, ta senu dágus sala nga malásin da tolay da. ");
INSERT INTO isd_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ay pà-pàgan da pe ya magtugaw kiya agtugawán daya nangátu wa tolay kadaya pagsasay-ammán se kadaya sinagoga. ");
INSERT INTO isd_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ay pà-pàgan da pe ya rispitaran daya tolay da kiya pagad-aduwán se pà-pàgan da pe ya ingágan da tolay da ka misturu. ");
INSERT INTO isd_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ngamay nu dakayu, akkan nu paganggammán nu ingagánan dakayu ka misturu, áta sissa ngà ala nga Misturu nu, ay magwawági kayu ngámin. ");
INSERT INTO isd_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ay áwan nu wa ingágan ka Ama kídi ya kalawagán, áta sissa ngala ya Ama nu nga ittu ya atán ka lángit. ");
INSERT INTO isd_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ay akkan kayu pe pepangágan ka Apu, áta e Cristo wala ya Apu nu. ");
INSERT INTO isd_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ya kangatuwán kadakayu, ay ittu kuma ya bíláng asassu nu. ");
INSERT INTO isd_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ata daya mangipangátu kiya baggi da kampela ngin, ay mebaba da, ay daya mangibaba kiya baggi da, ay mepangátu da.” ");
INSERT INTO isd_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ay kakal-kalakkán kayu wala nga maragtùgud ki lintag se dakayu wa Pariseo! Dakayu wa magpì-pìmáru! Ata dakayu ya gapu naya akkan kálà daya tolay kiya pangiturayán ne Dios. Lùsawan nu ya málà kiya pangiturayán ne Dios, ay iallang nu pe kadaya mayát. ");
INSERT INTO isd_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Kakal-kalakkán kayu wa maragtùgud ki lintag se dakayu wa Pariseo! Ata magpì-pìmáru kayu! Tap-taplan nu daya kuw-kuwa daya bubbúkud da babbay. Magpìkarárag kayu ka adaddu ka panglingad nu kadaya nadakè a kuk-kuwaan nu. Ay túya gapu na nga nadà-dammat ya kapánis nu. ");
INSERT INTO isd_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Kakal-kalakkán kayu wa maragtùgud ki lintag se dakayu wa Pariseo! Dakayu wa magpì-pìmáru! Ata oray battaan nu ya bebay, ay se oray adayyu ya madàdàdà nu basta atán nala oray isa nga akkan Judyu wa maáwis nu wa mangurug kiya kur-kurugan daya Judyu. Ay nu maáwis nu pe yin, ay magbalin ka ab-abay ya kekariyán na nga maimpiyernu may dakayu gapu kadaya isur-súru nu. ");
INSERT INTO isd_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Kakal-kalakkán kayu kurug ta ummán kayu kiya kúláp nga magbaybay. Ta nán nu nga, nu atán tolay nga pagsingánan naya Templo, ay áwan na nga patag yán. Ngamay nu ya balitù ki Templo ya pagsingánan na, ay masápul la tungpálan na ya kari na. ");
INSERT INTO isd_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Dakayu wa árig kúláp! Nganna agpà ya kinaug-og nu ta! Wayya la nga napà-patag ya balitù may ya Templo nga namagbalin kiya balitù ka napatag ke Dios? ");
INSERT INTO isd_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ay nán nu pe nga, nu pagsingánan naya isa tolay ya agbasuwán ay áwan na nga surbi. Annung na nga di tungpálan tu kari na. Ngamay nu pagsingánan na datu pagbasu kiya agbasuwán, ay masápul la tungpálan na ya kari na. ");
INSERT INTO isd_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ay árig nakúláp kayu wa kurug gin! Wayya la nga napà-patag ya pagbasu may ya agbasuwán nga ittu ya namagbalin kiya pagbasu ka napatag ke Dios? ");
INSERT INTO isd_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ay díkod, nu pagsingánan naya isa tolay ya agbasuwán, ay pagsingánan na ya pagbasu se ngámin na atán kitúni. ");
INSERT INTO isd_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ay nu Templo ya pagsingánan naya isa nga tolay, ay bíláng nga pagsingánan na pe ye Dios nga ittu ya magag-agyán kitúni. ");
INSERT INTO isd_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ay nu lángit ya pagsingánan naya isa tolay, ay akkan tittu ya lángit ya pagsingánan na nu di pe ye Dios, áta ittu ya mangitur-turáy kitúni. ");
INSERT INTO isd_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Kakal-kalakkán kayu wala nga maragtùgud ki lintag se dakayu wa Pariseo. Dakayu wa magpì-pìmáru! Napiya mà kurug ta id-idde nu ke Dios ya pagkapúlu daya pangrikádu nu, ngamay akkan nu kuma nga idil-dilig kiyán daya napà-patag kadaya bil-bílin ne Dios, nga ummán kadaya angwa nu ka napiya kadaya kasittolay nu, ya agkallà nu kadaya kasittolay nu se ya angngikurug nu ke Dios. Tú kuma dedi pe daya kinuw-kuwa nu win. ");
INSERT INTO isd_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Dakayu wa árig kúláp pa maragbaybay. Ay tura nu sagátan ya inuman nu, ka angngippà nu ka púrà, ngamay tura nu mán kammin na itangainum daya dadakkal la ul-ulullag. ");
INSERT INTO isd_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Kakal-kalakkán kayu wala nga maragtùgud ki lintag se dakayu wa Pariseo. Dakayu wa magpì-pìmáru! Ugatán nu ya lasi daya akap nu se pinggán nu, ngamay napnu da kadaya nakultit nu kadaya tolay se daya inágum nu. ");
INSERT INTO isd_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Dakayu wa Pariseo wa árig kúláp! Pagbalinan nu pikam ka nadalus daya inunag daya akap nu se pinggán nu, ay senu magbalin ka nadalus pe yin ya lasi da. ");
INSERT INTO isd_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Kakal-kalakkán kayu wala nga maragtùgud ki lintag se dakayu wa Pariseo! Dakayu wa magpì-pìmáru! Ata ummán kayu kadaya lúbù a napintáan ka pusà. Napiya ya singan naya lasi da, may ya inunag da, ay pabeg ga tuláng se datu naragit. ");
INSERT INTO isd_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Dakayu, ay ummán kayu kadayán. Ata namáru kayu kiya agsisíngan daya tolay, ngamay ya ung-unggan nu, ay panagpì-pìmáru se iya kinadakè.” ");
INSERT INTO isd_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kakal-kalakkán kayu wala nga maragtùgud ki lintag se dakayu wa Pariseo! Dakayu wa magpì-pìmáru! Ta pinangwa nu datu pagbàbànánan ne Dios kitun se datu namáru wa tolay kitun ka lúbù da. Ay payán nuda pe ka pangpapiya, ");
INSERT INTO isd_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ay se nu la nán na, ‘Nu uwad kami kuma ngala ngin kitu kakowad datu mannákam mi nga nagpatay kadaya pagbàbànánan ne Dios, ay akkan mi kuma nga nepalúbus sa patayán dada,’ nán nu. ");
INSERT INTO isd_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ay díkod dakayu kampela ngin nin ya nangagi nga pútut dakayu datu nagpatay kadatu pagbàbànánan ne Dios kitun. ");
INSERT INTO isd_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ara nu lugud! Balinan nu lugud dala ngin tu negayát datu apuapu nu. ");
INSERT INTO isd_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Dakayu wa ummán ka gámad idaw wa gangay! Inagdakè nu! Ay makalísi kayu kod pikam mala kiya pannakapánis nu ka impiyernu! ");
INSERT INTO isd_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ta senu metungpal nu tu ginayatán datu apuapu nu, ay túya mangibon nà kadaya pagbàbànánan ku se daya nasírib ba tolay ku se daya pagtù-tùgúdan ku kadakayu. Ay patayan nu daya duddúma, ay se ilansa nu ka krus daya duddúma, ay sap-saplit nu daya duddúma kadaya sinagoga nu, ay se nuda pataláwan kadaya il-ileli. ");
INSERT INTO isd_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ay díkod dakayu pe ya kidsuwán naya pannakapánis datu apuapu nu gapu kitu inagpatay da kadatu namáru wa tolay. Manggayát kitu Abel la áwan bas-básul la pinatay da, panda kitu Zacarias nga an-anà tu Barakias nga ittu pe tu pinatay nu wa Judyu kitu nagbàtán naya Templo se ya agbasuwán. ");
INSERT INTO isd_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kagiyan ku kadakayu ya kurug, nga ya pannakapánis gapu kadatun na kinuw-kuwa datu apuapu nu, ay midsu kadakayu wa tolay kadedi ya al-algaw.” ");
INSERT INTO isd_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Dakayu wa iJerusalem! Dakayu wa nagpatay kadatu pagbàbànánan ne Dios kitun se nagtùtò kadatu nebon ne Dios kadakayu! Namin-adu wà in na tagge ngala nga mangalmung kadakayu nga ummán kiya angngalukup naya úpa kadaya pippíyà na. May maddi kayu mán kammin,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","“Ngamay kídi yin ay piddudoray yala ne Dios sin ya Templo nu. Ay mabaaw win. ");
INSERT INTO isd_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ay ya ikagì kadakayu, ay akkan dà in na masingan panda kiya akasingan nu kammin kiyà, nga ittu yanin ya agkuna nu wa, ‘Maday-dáyaw ya umbet ta nebon ne Apu kídi,’ nán nu,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ay kitu ipappan ne Jesus sin kane lumawán kitu templo, ay umadanni datu tù-tùgúdán na kaggína. Ay netuldu da nga ipassingan ke Jesus tu simbáan se datu báwi kitu amuwág na. ");
INSERT INTO isd_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ngamay nán na kaggída nga summungbát, “Kurug ga masingan nu pikam ngámin dedi kídi. Ngamay ikagì kadakayu ya kurug, nga áwan nala ya mabansi nga maglànù kadedi nga batu nga di mepúkay,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ay kitu kowad ne Jesus nga magtutúgaw kitu bantay Olivo, ay inumbet datu tù-tùgúdán na nga áwan makam-ammu. Ay nán da kaggína, “Ikagim mán kadakami nu nungay na ya kàwa ngámin datun. Ay se nu nágan daya mà-màwa nga pagilasínán mi kiya ilalbet mu kammin se daya mà-màwa nga pakelasínán mi kiya ipappanda naya ngámingámin,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ay nán ne Jesus nga summungbát kaggída, “Magtaron kayu! Akkan kayu wa paal-alílaw ki oray iinna. ");
INSERT INTO isd_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ta adu daya tolay ya umbet ta magkuna nga, ‘Iyà ya Cristo,’ nán da. Ay adu daya tolay ya al-aliláwan da. ");
INSERT INTO isd_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ay magìna nu daya maggugubát, ay se madámag nu pe daya maggugubát kadaya sabáli nga il-ileli. Ngamay akkan kayu wa magansing. Ata masápul la màwa pikam dayán. Ngamay akkan pikam ittu ya ipappanda naya ngámingámin. ");
INSERT INTO isd_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ata maggugubát daya il-íli, ay se maggugubát pe daya il-íli nga iturayán daya à-ári. Ay umbet pe ya pinagguulát, ay se mangyagyag pe kadaya nagbal-baláki ya giyán. ");
INSERT INTO isd_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ngamay ngámin dedi, ay anggayát tala naya kapar-parigátan nu. ");
INSERT INTO isd_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Kalùsawan dakayu daya tolay gapu kiya angngurug nu kiyà. Ipatiliw dakayu kadaya agtuturáy, ay se dakayu wa par-parigátan. Ay patayan da daya duddúma kadakayu. ");
INSERT INTO isd_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ay túya adu daya mangigsán kiya angngurug da kiyà in. Ay ipatiliw da pe daya kabbulun da ngin, ay se maglilinnùsaw da pe. ");
INSERT INTO isd_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ay adu daya umbet ta busid nga pagbàbànánan ne Dios. Ay adu daya al-aliláwan da nga tolay. ");
INSERT INTO isd_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ay gapu ta umadu ya kinadakè, ay mapsílán ya amminya daya tolay kiya isaisa kaggída. ");
INSERT INTO isd_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ngamay nu iinna ya maketurad kadayán panda kiya panda na, ay ittu yán ya alà ne Dios. ");
INSERT INTO isd_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ay idi ya Napiya nga Dámag mepanggap kiya angngituráy ne Dios, ay mebàbànán pikam kiya ngámin na kalawagán ta senu mammuwán pikam daya ngámin tolay, ay se yala umbet tin ya ipappanda naya ngámingámin.” ");
INSERT INTO isd_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ay masingan nu kiya balay ne Dios tu kadàsán na masingan nga ummán kitu nepekagi ne Dios kitu Daniel la pagbàbànánan na kitun. (Awátan pànang din naya magbása.) ");
INSERT INTO isd_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ay nu masingan nu yanin, ay masápul la magkakáwe daya atán ka Judea kadaya ban-bantay. ");
INSERT INTO isd_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ay daya tolay ya mepas-pasmu wa atán ka atap balay da, ay akkan da tagge nga umúlug ga maggalà kadaya kuw-kuwa da nga atán kiya unag balay da. ");
INSERT INTO isd_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ay daya atán kiya komán da, ay akkan da masápul ya mawe ka balay da nga mangalà kiya bádu da. ");
INSERT INTO isd_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ay kiyán na oras ay kakal-kalakkán daya nabùsit se daya atán tagíbi. ");
INSERT INTO isd_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ikar-karárag nu wa akkan din kiya aggamiyán na se akkan kiya algaw wa panaggiimáng ya kàwa nayán. ");
INSERT INTO isd_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ata kiyán na algaw, ay napanat pà-pànang ya kapar-parigátan daya tolay. Ay áwan pikam ma ummán kiyán na nakapar-parigátan daya tolay nanggayát kitu nammarsuwa ne Dios kídi ya kalawagán panda kídi, ay se áwan nin ya màwa nga ummán kiyán. ");
INSERT INTO isd_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ay nu akkan nala nga kinabib-án ne Dios ya algaw nayán, ay áwan tolay ya mabiyág. Ngamay gapu kadaya píli ne Dios, ay kinabib-án na ya algaw nayán. ");
INSERT INTO isd_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ay nu atán magkuna kadakayu nga, ‘Atán kídi ya Cristo!’ onu, ‘Atán kannán!’ nán na, ay akkan nu kur-kurugan. ");
INSERT INTO isd_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ata atán da umbet ta magpamaráng nga Cristo, se atán da pe magpamaráng nga pagbàbànánan ne Dios. Magipas-passingan da kadaya nakas-kasdáaw pànang nga mà-màwa ka pangalílaw da kadaya tolay. Ay nu mabal-balin kuma ngala, ay ialílaw da pe daya piníli ne Dios. ");
INSERT INTO isd_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","May kinagì kadakayu mà in ki di na pikam kàwa. ");
INSERT INTO isd_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ay díkod oray nu nán da kadakayu wa, ‘Atán kitúni ir-ir-er,’ nán da, ay akkan kayu wa maw-awe. Ay nu nán da nga, ‘Atán kiyán unag kuwartu,’ nán da, ay akkan nuda pà-pàgan. ");
INSERT INTO isd_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ata ya ilalbet ku kammin na nengágan da kitun ka An-anà Tolay, ay masingan dà ngámin daya tolay! Ummán kiya kilát ta palangán na ya magpíngipíngit oray nu kiya lattakán nala ya paggayatán na,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Ay oray kawà naya giyán naya innát, ay atán pe daya karabúngan.” ");
INSERT INTO isd_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ay nu mabalin nin ngámin dayán na rig-rígát kiyán na al-algaw, ay matay pe yin ya mata, ay se akkan na pumaláng pe yin ya búlán. Ay daya bittuwan ka lángit ay metànagán da. Ay makínin pe daya duddúma pikam nga atán ka lángit. ");
INSERT INTO isd_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ay se yala nga masingan ka lángit ya pagilasínán kiya ilalbet ku, iyà nga nengágan da kitun ka An-anà Tolay. Ay ngámin daya tolay kídi ya kalawagán, ay magpannakit da, ay se dà ala masingan na nengágan da kitun ka An-anà Tolay nga umbet tin na mebulun ki angap. Ay kiyán na oras ay mepassingan ya kinaturáy ku se ya kinadáyaw ku. ");
INSERT INTO isd_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ay se yala atán magìna da nga naggat pànang nga ummán ka metanggoyob nga ittu pe yanin ya angngibon ku kadaya anghel ne Dios nga mangurnung kadaya ngámin na píli ne Dios nga tolay na nga maggayát kadaya ngámin na giy-giyán kídi kalawagán.” ");
INSERT INTO isd_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Dam-damdamman nu ya mà-màwa kadaya káyu wa gígus. Nu maglannuway da ngin, ay ammu nu win na tagay yin ya agdagun na. ");
INSERT INTO isd_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ay ummán pe, nu masingan nu win datun na kinag-kagì a mà-màwa, ay ammu nu pe yin na tagay pànang ngin ya ilalbet ku. ");
INSERT INTO isd_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ikagì kadakayu wa màwa ngámin dedi kiya akkan pikam katay daya tolay ya sibbiyág kadedi ya al-algaw. ");
INSERT INTO isd_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Madadál lala ya lángit se ya kalawagán ngamay daya bàbànán ku, ay akkan da wayya nga di màwa.” ");
INSERT INTO isd_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ay nu iya algaw se oras nga kàwa ngámin dayán, ay áwan ya makammu oray daya anghel ne Dios, ay oray iyà a An-anà na, nu di tittu ya Ama. ");
INSERT INTO isd_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ya ilalbet ku kammin na nengágan da kitun ka An-anà Tolay, ay ummán kitu nelalbet natu dallis kitu kakowad tu Noa. ");
INSERT INTO isd_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ata kadatu al-algaw wa áwan pikam tu dallis, ay mangán se uminum, se maggaattáwa ngala datu tolay panda kitu algaw wa nelalnà tu Noa kitu abay pànang nga biray na. ");
INSERT INTO isd_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Akkan da tutu wala am-ammu tu màwa panda kitu nelalbet tu dallis nga ittu tu nangrápun kaggída ngámin. Ay ummán pe kiyán kiya ilalbet ku wa nengágan da kitun ka An-anà Tolay. ");
INSERT INTO isd_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ay kiyán na oras, ay atán duwa nga lalláki ya magkuwa kiya komán da. Málà ya isa, ay mabansi ya isa. ");
INSERT INTO isd_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Atán duwa nga babbay ya magirid. Ay málà ya isa, ay mabansi pe ya isa. ");
INSERT INTO isd_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ay túya sissasagána kayu din peyang ta akkan nu wa ammu ya algaw wa ilalbet naya Apu nu. ");
INSERT INTO isd_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Damdamman nu nga, nu ammu kuma naya ama naya bumalay nu nungay na ki gabi ya ilalbet naya maragtákaw, ay magbantáy kuma ngala ngin ta senu akkan malnà naya maragtákaw ya balay na. ");
INSERT INTO isd_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ay lugud, masápul la sissasagána kayu peyang, ta umbet tà a nengágan da kitun ka An-anà Tolay kiya oras sa akkan nu wa aggin-indag kiyà.” ");
INSERT INTO isd_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ya mapiyár se nasírib ba asassu, ay aggína ya pakammuwan naya apu na kadaya páda na nga asassu. Aggína ya magpangán kadaya duddúma nga asassu kiya oras sa pinagkakán da. ");
INSERT INTO isd_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Maganggam yán na asassu wa dàngan naya apu na nga ummán kiyán ya kuk-kuwaan na. ");
INSERT INTO isd_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ay kurug ya ikagì kadakayu nga aggína ya pakammuwan natu apu na kadaya ngámin na kuw-kuwa na. ");
INSERT INTO isd_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ngamay nu ya nadakè a asassu, ay nán na kiya uray na, ‘Mabayág pikam, ay se yala umbet tu apù,’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ay se na ngala nga gayatán pagraw-rawtán daya páda na nga asassu, ay se yala pe yin na mawe mepangapangán se mepaggiínum kadaya maging-inglaw. ");
INSERT INTO isd_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ay se yala nga umbet tu apu na kiya algaw wa akkan na nga panaggin-indag, ay se kiya oras sa akkan na nga am-ammu. ");
INSERT INTO isd_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ay panísan tutu wala natu apu na, ay se na ngin na ibíláng kadaya managpì-pìmáru. Ay ippan na pe yin kitu giyán da. Ay kiyán na giyán, ay magngar-ngarasiyat se sumángit da,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ya kálà nu kiya pangiturayán ne Dios, ay meárig kiya annabat daya sangapúlu wa babbalásang kiya mangatáwa. Ay dedi ya babbalásang, ay siddidílág da ngámin. ");
INSERT INTO isd_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ngamay ya limma kaggída, ay umang-ang-ang da. Ay datu limma ay nasírib da. ");
INSERT INTO isd_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ay datu umang-ang-ang, ay nagtagidílág da pe, ngamay akkan da nga nangalà ka sagáma da nu mamminán da ka agás. ");
INSERT INTO isd_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ngamay datu nasírib, ay nangalà da pikam ka agtangabutilya da nga agás nga sagáma da. ");
INSERT INTO isd_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ay nabayág se yala inumbet tu mangatáwa, ay tútu nadà-dappán datu babbalásang, ay díkod nagkakatúdug da ngámin. ");
INSERT INTO isd_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ngamay kitu túlad tu gabi yin, ay uwad kinumraw wa nán na, ‘Atán nin tu mangatáwa! Sabtan nu win!’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ay nalukág datu sangapúlu wa babbalásang, ay se da nga kappiyánan datu dílág da. ");
INSERT INTO isd_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ay nán datu umang-ang-ang kadatu nasírib ba babbalásang, ‘Iddán dakami mán ka agás ta natayán kami yin,’ nán da. ");
INSERT INTO isd_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ngamay nán datu nasírib ba summungbát, ‘Akkan kid da umanáy kadàtada ngámin ya nesagána mi nga agás! Mawe kayu wala ngin na gumátang ka agás nu kadaya sininda,’ nán da. ");
INSERT INTO isd_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ngamay kitu likud da nga gumátang, ay inumbet pe yin tu mangatáwa, ay díkod datu nasírib ba babbalásang, ay netangalnà da pe yin kaggína kitu pagsasay-ammán, ay se da pe yin na gìpán tu gagyangán. ");
INSERT INTO isd_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ay kane daddán, ay inumbet pe yin datu umang-ang-ang. Ay nán da, ‘Apu, lùtán dakami mán,’ nán da. ");
INSERT INTO isd_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ngamay nán natu mangatáwa, ‘Akkan takayu mà kurug am-ammu!’ nán na.” ");
INSERT INTO isd_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ay se yala nán ne Jesus, “Magsagána kayu lugud, áta akkan nu wa ammu ya algaw se oras sa ilalbet ku nga nengágan da ka An-anà Tolay,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ata ya kàwaán na kiya pangiturayán ne Dios, ay meárig kiya kinuwa naya isa nga tolay ya nawe kiya adayyu wa íli. Kitu ipappan na ngin, ay inayabán na datu asassu na, se na nga ikípát ta ipiyár kaggída tu pirà na. ");
INSERT INTO isd_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ay niddán na ka limma ríbu tu isa, ay duwa ríbu kitu mekàduwa, ay se maríbu kitu mekàlu. Ata sigun kitu kabailán da kampela ngin nin. Ay se la nawe yin. ");
INSERT INTO isd_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ay tu niddán ka limma ríbu, ay dágus na ngala nga nenigúsiyu tu pirà na. Ay nakaganansiya ka limma ríbu pe. ");
INSERT INTO isd_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ay ummán pe tu mekàduwa, nakaganansiya ka duwa ríbu pe. ");
INSERT INTO isd_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ngamay itu asassu wa niddán ka maríbu, ay nawe na nga nekubkob kitu lusà tu pirà natu apu na. ");
INSERT INTO isd_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ay kane mabà-bayág ka panda, ay inumbet tin tu apu da nga maningan kadatu pirà na nga nepiyár na kadatu asassu na. ");
INSERT INTO isd_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ay ya inumbet ta nunna, ay tu niddán na ka limma ríbu písus, ay se na nga idde tu pirà kitu apu na. Ay nán na, ‘Apu, nakaganansiya tu limma ríbu wa niddem kiyà ka limma ríbu pe,’ nán natu asassu. ");
INSERT INTO isd_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ay, ‘Pàgan ku ya kinuwám,’ nán natu apu na. ‘Namáru ka se mapiyár ka nga asassu,’ nán na. ‘Ay gapu ta mapiyár ka kiya bittì ala nga bánag, ay ikaw ya pakammuwan ku kadaya dadakkal la bánag. Umbet ka ta mepaganggam ka kiyà nga apu mu,’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ay se yala umbet pe yin tu niddán ka duwa ríbu. Ay nán na, ‘Apu, niddán nà kitun ka duwa ríbu, ay tú idi ya ganansiyà, duwa ríbu písus pe,’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ay nán tu apu, ‘Pàgan ku ya kinuwám! Namáru ka se mapiyár ka nga asassu. Ay gapu ta mapiyár ka kiya bittì ala nga bánag, ay ipindu ku pe kikaw daya dadakkal la bánag. Ay umbet ka ta mepaganggam ka kiyà, nga apu mu,’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ay inumbet pe yin tu niddán ka maríbu wa písus. Ay nán na kitu apu na, ‘Apu, ammù a narungat ka. Ganiyan mu ya akkan mu wayya netugnu, ay se burásan mu ya búnga naya akkam nemúla. ");
INSERT INTO isd_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ay gapu ta mansing ngà kikaw, ay túya nekubkob ku tu pirà mu. Ye kam idi tu pirà mu,’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ay nán natu apu na kaggína, ‘Nadakè ka se nasadut ka nga asassu! Ammum lugud din na ganiyan ku ya oray akkan ku wa netugnu, ay se burásan ku ya akkan ku wa nemúla, ");
INSERT INTO isd_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ay turám lugud da di nebangku ya pirà ku ta senu atán kuma ngin ya an-anà na kídi ya naggulli ku!’ nán na. ");
INSERT INTO isd_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ay tútu nán na kadatu duddúma nga asassu na, ‘Alà nu ya pirà kaggína, ay se nu idde kiya asassu wa atán sangapúlu ríbu na,’ nán na,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","“Ata daya makammu kiya nepiyár kaggída, ay maamúngán pikam, ay umadu pànang ya atán kaggída. Ngamay daya akkan makammu kiya nepiyár kaggída, ay màpoli kammin tu nepiyár kaggída. ");
INSERT INTO isd_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ay nán tu apu manin, ‘Ay kídi yin, ippan nu ya áwan sur-surbi nga asassu kiyán kiya kagìbattán kiya lasi. Ay sumángit daya tolay kiyán, ay se magngar-ngarasiyat da.’” ");
INSERT INTO isd_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ay nu umbet tà a nengágan da kitun ka An-anà Tolay, ay kabbulun ku daya anghel ne Dios. Ay kiyán na ilalbet ku, ay mepassingan ya kinaDios ku, ay se ittu pe yanin ya nadáyaw wa angngituráy ku. ");
INSERT INTO isd_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ay ngámin daya tolay kídi kalawagán, ay maur-urnung da kiya àráng ku. Ay pagsisibnaan kuda nga ummán kiya ammagsisibna naya magpas-pastor kadaya karneru se kalding. ");
INSERT INTO isd_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ay daya árig karneru, ay pabegan kuda kiya padne diwanán ku. Ay daya árig kalding, ay pabegan kuda kampela ngin nin pe kiya padne kasígid ku. ");
INSERT INTO isd_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ay iyà nga Ari da kiyanin, ay nán ku kadaya atán ki padne diwanán ku, ‘Dakayu wa inanggam naya Amà, ay umbet kayu! Ta magyán kayu win kiya pangiturayán na nga nesag-sagána kadakayu oray kitu akkan pikam nàwa idi ya kalawagán. ");
INSERT INTO isd_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ata kitu nabisin nà, ay pinangán dà. Ay kitu aggasikkinum ku ay pinenum dà. Ay oray agtangeli yà kadakayu, ay pinalnà dà. ");
INSERT INTO isd_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ay kitu áwan ku bádu, ay binaduwán dà. Ay kitu inagtakit ku, ay tinalimaduwán dà. Ay kitu nekebálud ku, ay sinù-sùbangán dà,’ nán ku kaggída. ");
INSERT INTO isd_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ay se da la nán kiyà pe dayán na namáru, ‘Kannungay na pe Apu ya inakasingan mi nga nabisin ka, ay se mika pinangán? Ay kannungay na pe ya inaggasikkinum mu wa pinenum mika? ");
INSERT INTO isd_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ay kannungay naya inakasingan mi kikaw wa agtangeli ka, may pinalnà mika? Ay kannungay na pe ya nekalàbuwán mu wa binaduwán mika? ");
INSERT INTO isd_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ay se kannungay na pe ya nekabálud mu wa sinù-sùbangán mika, se ya inakasingan mi kikaw nga nagtakit nga tinalimaduwán mi?’ nán da. ");
INSERT INTO isd_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ay iyà nga Ari da, ay nán ku pe ya sumungbát kaggída, ‘Ikagì kadakayu nga gapu ta kinuwa nu dayán kadedi ya nababa nga wawwágì ay bíláng kinuwa nu pe kiyà,’ nán ku kaggída. ");
INSERT INTO isd_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ay se ku la nga kagiyan kadaya atán ki padne kasígid ku, ‘Magtálaw kayu kiyà, dakayu wa kalùsawan ne Dios. Mawe kayu kiya apuy ya akkan mataatay nga nesag-sagána ke Sairu se kadaya itur-turayán na. ");
INSERT INTO isd_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ta kitu nabisin nà, ay akkan dà a pinangán, ay se kitu sikkinum mà, ay akkan dà pinenumán. ");
INSERT INTO isd_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Agtangeli yà kadakayu, ngamay akkan dà a pinalnà. Nalàbuwán nà may di dà binaduwán. Nagtakit tà may akkan dà tinalimaduwán. Ay akkan dà pe ya sinù-sùbangán kitu nekabálud ku,’ nán ku kaggída. ");
INSERT INTO isd_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ay nán da pe nga sumungbát, ‘Apu, kannungay naya nakasingan mi kikaw wa nabisin, onu nagasikkinum, onu agtangeli ka onu magtakit ka onu nabálud ka, ngamay akkan mika nga sinengán?’ nán da. ");
INSERT INTO isd_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ay nán ku pe sumungbát kaggída, ‘Kagiyan ku kadakayu nga, gapu ta akkan nu wa kinuwa dayán kadedi ya kababaán na wawwágì, ay bíláng akkan nu wa kinuwa pe kiyà.’ ");
INSERT INTO isd_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ay se da la nga mippan kiya pakapanísán da ka áwan panda. Ngamay nu daya namáru, ay mawe da kiya pakabiyágan da ka áwan panda,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ay kane din na mabalin ne Jesus nga magkakagi kadatun na nesur-súru na, ay nán na kadatu tù-tùgúdán na, ");
INSERT INTO isd_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ammu nu wa duwa ngalgaw wala ngin, ay se yala màwa ya piyasta. Iyà nga nengágan da kitun ka An-anà Tolay, ay ipatiliw dà, ay se dà a ilansa ki krus,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kitun na oras, ay nagguurnung datu ap-apu datu pappádi se datu pangmanàman datu Judyu kitu balay ne Caifas nga nangátu wa pádi. ");
INSERT INTO isd_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ay se da nga naggaamomanán nu mapaanna ya kuwaan da ta senu nalingad ya anniliw da ke Jesus se ya ammatay da kaggína. ");
INSERT INTO isd_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ay nán da nga, “Akkan tada nga ipàmu kiya piyasta ta magariguddò daya tolay,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ay kane atán de Jesus ka Betania kitu balay de Simon, tu naglappang kitun, ");
INSERT INTO isd_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ay uwad babay ya nangitúgut ka tangabutilya nga nangína pànang nga talibangug. Ay kane atán ne Jesus nga magtutúgaw wa mangán, ay inumbet tu babay, ay se na nga isiyasiyà tu talibangug kitu úlu ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ngamay kane masingan datu tù-tùgúdán na tu kuwaan natu babay, ay nalùsaw da nga nán da, “Taanna, tura na nga dadàlan ya talibangug kiyán? ");
INSERT INTO isd_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Adu kuma ya paglakúwán na kiyán nu iláku na, ay se na nga idde kuma ya pirà kadaya napubri,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ay ammu ne Jesus tu kag-kagiyan da, ay tútu nán na kaggída, “Taanna, tura nu wa lùsawan ya babay ta, ay napiya mà ya kinuwa na kiyà! ");
INSERT INTO isd_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Daya napubri, ay kabul-bulun nuda peyang, ngamay nu iyà, ay akkan. ");
INSERT INTO isd_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kídi ya inangngípu na kiyà kídi ya talibangug ay ittu ya angngisagána na kiyà kiya pannaketaman ku. ");
INSERT INTO isd_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ay ikagì kadakayu nga oray kawà na kídi kalawagán ya kebàbànánan naya Napiya nga Dámag, ay mebàbànán pe ya kinuwa nedi ya babay ka panamdammán da kaggína,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ay se yala nga nawe kadatu ap-apu datu pappádi tu isa kadatu sangapúlu se duwa, tu nagngágan ka Judas Iscariote. ");
INSERT INTO isd_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ay nán na kaggída, “Nágan naya idde nu kiyà nu mepatiliw ku kadakayu we Jesus?” nán na. Ay tútu tinangdánan da ka tallu púlu wa pinaláta nga silber. ");
INSERT INTO isd_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ay díkod, nanggayát kitun, ay isingasingan na ngin ya angngipatiliw na ke Jesus. ");
INSERT INTO isd_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ay kitu nunna nga algaw natu piyasta nga angngán da ka sinápay ya áwan pamalbád, ay inumbet datu tù-tùgúdán ne Jesus. Ay nán da kaggína, “Kawà na nga balay ya piyám ma pangisaganáan mi ka panggídám tada kídi nga piyasta?” nán da. ");
INSERT INTO isd_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ay nán na kaggída, “Mawe kayu kiya íli, ay se nu wala nga sapúlan nge kuwa. Ay ikagi nu kaggína nga nán nu, ‘Nán ne Misturu nga inumbet tin tu oras na. Ay idi balay mu kanu ya panggidáman mi kídi nga piyasta,’ nán nu,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ay kinurug datu tù-tùgúdán na tu nebílin na kaggída. Ay tútu nawe da nga nesagána tu panggidáman da kitun na piyasta. ");
INSERT INTO isd_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ay kane gabi yin, ay nagdudúwa de Jesus se datu sangapúlu se duwa nga tù-tùgúdán na nga mangán. ");
INSERT INTO isd_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ay kitu kowad da ngin na magkakán, ay nán ne Jesus kaggída, “Ipà-painunnà a ikagi kadakayu, nga atán kadakayu ya mangipatiliw kiyà,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ay tútu nagpannakit da pànang ngámin. Ay nán tu isaisa kaggída, “Akkan iyà yán, Apu” nán da. ");
INSERT INTO isd_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ay summungbát te Jesus nga nán na, “Tu negindán kiyà nga nangidnat kitu sinápay na kitu malúkung, ay aggína ya mangipatiliw kiyà. ");
INSERT INTO isd_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ngamay màwa mà kammala ngin nin kiyà nga nengágan da kitun ka An-anà Tolay ya ummán kitu nán naya nesúrát ta bàbànán ne Dios mepanggap kiyà. Ngamay kakal-kalakkán ya tolay ya mangipatiliw kiyà. Napì-piya kuma ngala kaggína nu akkan tagge neanà,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ay tu Judas nga ittu tu mangipatiliw kaggína, ay nán na, “Apu, iyà nád ya nán mu?” nán na. Ay nán ne Jesus kaggína, “Nakagi mu win!” nán na. ");
INSERT INTO isd_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ay kitu agkakán da, ay nangalà e Jesus ka sinápay, ay se yala nagiyáman ke Dios, ay se na sinappitappig se na nekípát kadatu tù-tùgúdán na nga nán na, “Alà nu ta kanan nu. Tú idi ya baggì,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ay se na la pe ya inalà tu binásu wa inuman da, ay se yala nagiyáman. Ay se na nidde kaggída nga nán na, “Uminum kayu ngámin kídi,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","“Ta tú idi ya dágà a katungpálan naya baru nga kari ne Dios kadaya tolay. Mearúyut ya dágà ta senu mapakawan daya bas-básul daya adu wa tolay. ");
INSERT INTO isd_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ay ikagì kadakayu nga akkan nà in na uminum kídi ya mainum nga nàwa ki digu búnga úbas, panda kiya angnginum ku manin kídi nga kabulun takayu win kiya pangiturayán naya Amà.” ");
INSERT INTO isd_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ay kane mabalin da nga mangansiyon ka isa nga kansiyon, ay lummawán da, ay se da mawe kitu bantay Olivo. ");
INSERT INTO isd_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ay nán ne Jesus kaggída, “Kídi nga gabi, ay pagtataláwan dà ngámin gapu kiya màwa kiyà. Ata atán na nesúrát kiya bàbànán ne Dios nga nán na, ‘Patayan ku ya magtag-tagasíngan kadaya karneru, ay masip-siparà daya karneru,’ nán na,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“Ngamay nu lumtu wà in, ay inunnaán takayu ka Galilea,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ay nán ne Pedro kaggína, “Ay oray nu pagtataláwan daka ngámin gapu kiya màwa kikaw, ay akkan taka paglikudán,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ngamay nán ne Jesus kaggína, “Kagiyan ku kikaw ya kurug nga, kídi ya gabi, ki di pikam aggiittaráut daya anù kiya danni láwa ay namìluwán nà in na netuláyaw,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ay nán manin ne Pedro, “Oray nu metangatay yà kikaw, ay kurug ga akkan taka nga ituláyaw,” nán na. Ay ittu pe yán tu kinagi ngámin datu tù-tùgúdán na. ");
INSERT INTO isd_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ay se yala manin na nawe de Jesus kitu giyán na Getsemani. Ay nán na kadatu tù-tùgúdán na, “Magtutúgaw kayu wala kídi ta mawe yà a magkarárag kitúni,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ay nebulun na de Pedro se datu duwa nga annánà tu Zebedeo. Ay nanggayát ta mariribù, ay magpannakit pànang pe. ");
INSERT INTO isd_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ay nán na kaggída, “Magpannakit tà pànang, ay ummán nà ka matay gapu kídi ya pannakit ku. Magbansi kayu kídi ngamay mepagpúyát kayu kiyà,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ay nawe kitu ad-adayyu, ay se la nagukkab kitu lusà, ay se yala magkarárag, nga nán na, “Ama, nu mabalin kuma ngala, ay ilísi nà kídi ya pannakatay ku, ngamay akkan ya piyán ku ya masúrut, nu di ya piyán mu kampela ngin,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ay kane magulli kitu giyán datu tallu wa tù-tùgúdán na, ay dinatang nada nga magkakatúdug. Ay nán na ke Pedro, “Pedro akkan nu mabaal gane, ya mepagpúyát kiyà ka oray isa ngala nga oras? ");
INSERT INTO isd_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Magpúyát kayu, ay se magkarárag kayu ta senu malisiyán nu din daya kepar-paroán nu. Kurug ga piyán nu kiya uray nu ya akkan meparò ngamay nakapsut ya baggi nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ay pinidduwa na manin tu nawe nagkar-karárag kitu ad-adayyu. Ay nán na nga nagkarárag, “Ama, nu akkan mabalin na di màwa idi kiyà, ay ya piyám mala ya màwa,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ay inumbet manin kitu giyán datu tù-tùgúdán na, ay dinatang nada manin na magkakatúdug ta akkan da nga marngát datu mata da. ");
INSERT INTO isd_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ay díkod, pinanáwan nada, ay se yala nawe nagkarárag. Ay ittu kam tu nekagi na kitu karárag na kídi ya kapamìlu na. ");
INSERT INTO isd_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ay se yala inumbet kadatu tù-tùgúdán na, ay nán na kaggída, “Matúdug kayu pikam ma magimáng? Inumbet tin tu oras sa angngipatiliw da kiyà a nengágan da kitun ka An-anà Tolay kadaya maragbásul. ");
INSERT INTO isd_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Bumángun kayu ta mawe tada ngin. Sinnan nu kod. Atán nin tu mangipatiliw kiyà,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ay kitu akun-oni pikam ne Jesus, ay inumbet tu Judas nga isa kadatu sangapúlu se duwa nga tù-tùgúdán na. Ay kabbulun na datu adu wa tolay ya nagtagiampiláng se nagtagipapangkur nga ittu datu nebon datu ap-apu datu pappádi se datu pangmanàman datu Judyu. ");
INSERT INTO isd_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ay tu Judas nga ittu tu mangipatiliw kaggína, ay nekagi na ngin ya pakammuwán datu tolay ke Jesus. Ata nán na kaggída, “Ya tolay ya umàán ku, ay aggína ngin. Dugkamman nu!” nán na. ");
INSERT INTO isd_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ay díkod kane umbet, ay nagkaw-át ke Jesus se na nán, “Mapaanna ngin, Misturu?” nán na, ay se na nga ummàán. ");
INSERT INTO isd_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ay nán ne Jesus kaggína, “Opun, kuwaan mu win ya gákat mu kídi,” nán na. Ay se yala nga dummarup datu tolay, ay se da tiniliw nge Jesus. ");
INSERT INTO isd_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ay inásut natu isa kadatu kabbulun ne Jesus tu ampiláng na, ay se na nga kintab tu asassu natu nangátu wa pádi. Ay nataptáp pala tu talínga na. ");
INSERT INTO isd_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ngamay nán ne Jesus kaggína, “Ippáy mu kammin ya ampiláng mu kiya balay na, áta daya magtag-tagiampiláng ka ippapatay da, ay ampiláng pe ya katayán da,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","“Dálin nu kid nga akkan ku annung ya makigdù kiya Amà, ay se dágus sala nga mangibon ka rinibu-ríbu wa anghel na?” nán na. ");
INSERT INTO isd_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","“Ngamay nu ittu yán ya kuwaan ku, ay mapaanna lugud ya kàwa kurug daya bàbànán ne Dios nga nesúrát? Ay nán na mà nga màwa dedi!” nán na. ");
INSERT INTO isd_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ay se yala nán ne Jesus kadatu adu wa tolay, “Tirung ngà ka nán nu ta! Ta tura kayu wa nagtagiampiláng se nagtagipapangkur ra inumbet ta maniliw kiyà! Atán nà mà peyang kiya algaw wa magtùgud kiya Templo, ay tura dà akkan na tiniliw kitun kam?” nán na. ");
INSERT INTO isd_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","“Ngamay nàwa dedi ta senu màwa datu nesur-súrát datu pagbàbànánan ne Dios kitun,” nán ne Jesus. Ay se nagtataláwan datu tù-tùgúdán na. Ay piniddudoray da ngala ngin. ");
INSERT INTO isd_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ay se da la nippan ne Jesus kitu balay ne Caifas nga nangátu wa pádi, áta ittu tu nagguurnúngán datu maragtùgud ka lintag se datu pangmanàman da. ");
INSERT INTO isd_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ay gummunud pe ye Pedro may nagpal-palodi yala panda kitu amuwág tu balay natu nangátu wa pádi. Ay kane atán kitu amuwág gin, ay nepagtutúgaw kadatu guwardiya ta sinnan na nu nágan tu màwa. ");
INSERT INTO isd_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ay ngámin datu ap-apu datu pappádi se datu pangmanàman da se datu maragtùgud ki lintag ga nagguurnung kitúni, ay magsap-sápul da ka oray busid dala ngin na ipabásul da ke Jesus ta senu mabalin da nga papatay. ");
INSERT INTO isd_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ngamay áwan da nga masmà oray nu adu win datu nagsistígu ka busid. Ay se yala uwad duwa tolay ya nagsíkád. ");
INSERT INTO isd_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ay nán da, “Nán nedi ya tolay nga mabalin na kanu wa gabbán ya Templo, ay se na ipasíkád kanu kammin kiya unag tallu walgaw,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ay nagsíkád tu nangátu wa pádi se na nán ke Jesus, “Inna ya mesungbát mu kiyán na ipabásul da kikaw?” nán na. ");
INSERT INTO isd_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ngamay akkan nagun-úni ye Jesus. Ay nán manin tu nangátu wa pádi kaggína, “E Dios ay maggigìna kídi. Ikagim lugud tutu wala kadakami nu kurug ga ikaw ya An-anà ne Dios nga ittu ya Cristo?” nán na. ");
INSERT INTO isd_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ay tútu nán ne Jesus kaggína, “Ay kinagi mu mà in,” nán na. “Ngamay ikagì pe kadakayu nga, manggayát kídi yin ka panda, ay mammuwán nu nga iyà nga nengágan da kitun ka An-anà Tolay, ay magtugaw wà kiya padne diwanán ne Dios. Ay masingan nu pe nga umbet tà a mebulun ki angap nga maggayát ka lángit,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ay kane magìna natu nangátu wa pádi tu kinagi ne Jesus, ay pinìsi na tu bádu na kampela ngin nin. Ay se na nán, “Pangirupat na ke Dios datu kinag-kagi na á! Akkan tada masápul lin daya sistígu, áta nagìna nu mà in ya angngirupat na ke Dios. ");
INSERT INTO isd_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ay nágan naya nán nu?” nán na kadatu kabbulun na. Ay, “Masápul la matay a, ta ittu mà yán ya rabbang na gapu kiya básul na,” nán da nga summungbát. ");
INSERT INTO isd_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ay se da nga linutában tu murang na, ay se da pe ya sulusúlung. Ay timpit pe datu duddúma. ");
INSERT INTO isd_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ay nán da ke Jesus nga sikkaamítang, “Gattuam mán lugud Cristo nu iinna ya nampit kikaw!” nán da. ");
INSERT INTO isd_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ay e Pedro, ay uwad da magtutúgaw kitu lasi, kitu amuwág natu agbustigarán da. Ay ummadanni kaggína tu isa nga babay ya asassu. Ay nán na, “Ikaw pe tu kabul-bulun ne Jesus nga iGalilea á!” nán na. ");
INSERT INTO isd_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","“Akkan ku am-ammu ya kag-kagiyam,” nán ne Pedro nga nagtuláyaw kaggída ngámin. ");
INSERT INTO isd_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ay nawe manin kitu balkon, ay uwad manin na nakasingan kaggína nga asassu wa babay. Ay nán natu babay kadatu atán kitúni, “Kabulun ne Jesus nga iNazaret ide ya tolay,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ay nagtuláyaw manin ne Pedro. “Am-ammù kadi yán na tolay,” nán na nga nesipata. ");
INSERT INTO isd_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ay kane daddán manin, ay umadanni datu tolay ya atán kitúni ke Pedro. Ay nán da, “Kurug mà nga isa ka kaggída, áta melásin nala kiya áyug naya panaggun-únim,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ay tútu pinagsingánan na ngin tu baggi na nga nagsipata. “Akkan ku am-ammu yán na tolay,” nán na. Ay ittu pe tun tu inaggittaráut datu anù. ");
INSERT INTO isd_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ay se ittu pe yin tu inakadamdam ne Pedro kitu kinagi ne Jesus kaggína nga, “Kiya di pikam ma nakapagittaráut daya anù, ay namìluwán nà in na netuláyaw,” nán na. Ay tútu lummawán ne Pedro, ay se tutu wala nga summángit. ");
INSERT INTO isd_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ay kane pagbarngát, ay nagguumomán datu ap-apu datu pappádi se datu pangmanàman datu tolay nu paannán da tu mangipapatay ke Jesus. ");
INSERT INTO isd_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ay tútu piníngil da tu íma na se da ippan ke Gubernador Pilato. ");
INSERT INTO isd_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ay kane mammuwán tu Judas, tu nangipatiliw ke Jesus, nga patayan da nge Jesus, ay nakappoli. Ay tútu nawe na ipatulli tu tallu púlu wa pinaláta nga silber kadatu ap-apu datu pappádi se datu pangmanàman da. ");
INSERT INTO isd_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ay nán na, “Nagbásul là ta turà a nepatiliw kadakayu ya áwan bas-básul la tolay!” nán na. Ngamay nán da, “Ay nágan naya biy-biyáng mi kiyán. Ikaw ya makammu kampela kiyanin,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ay nebàbà tu Judas datu piniláta nga silber kitu giyán templo, ay se yala nawe ya nagbísin na nagpattal. ");
INSERT INTO isd_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ay díkod inurnúngán datu pappádi datu piniláta nga silber. Ay nán da, “Meallang kiya lintag tada ya mangippáy kiya pirà kiya kága Templo, áta báyad naya biyág naya isa nga tolay,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ay tútu naggaamomanán da nu paannán da tu silber. Ay negátang da kitu lusà natu magkuwa ka bánga nga ittu tu kinuwa da nga kampusantu datu agtangeli. ");
INSERT INTO isd_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ay ittu tu gapu na nga Lusà Dága ya nepangágan kitun na lusà ka panda kadedi ya al-algaw. ");
INSERT INTO isd_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ay díkod nàwa kurug tu kinagi natu Jeremias nga pagbàbànánan ne Dios kitun nga nán na kídi, “Inalà da tu tallu púlu wa pinaláta nga silber nga báyad naya biyág naya isa nga tolay, nga daya duddúma nga iIsrael kam ya nangbanor kaggína. ");
INSERT INTO isd_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ay se da nga negátang ka lusà natu maragkuwa ka bánga nga ummán kitu nán ne Dios nga kuwaan ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ay atán ne Jesus sin kitu àráng natu gubernador. Ay nán natu gubernador ra namustigár kaggína, “Ikaw ya ári daya Judyu?” nán na. Ay nán ne Jesus nga summungbát, “Kinagi mu mà ya kurug,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ngamay nu datu ap-apu datu pappádi se datu pangmanàman da tu mamustigár kaggína, ay áwan na nga isung-sungbát kaggída. ");
INSERT INTO isd_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ay tútu nán ne Pilato kaggína, “Akkan mu agpà magìna daya ipab-pabásul da kikaw!” nán na. ");
INSERT INTO isd_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ngamay áwan tútu wala nga nesung-sungbát ne Jesus kadatu ipabásul da kaggína. Ay tútu pagballà pànang tu gubernador. ");
INSERT INTO isd_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ay ki peyang nga piyasta, ay nepagangay kitu gubernador ya mangipalawán ka isa nga bálud nga pepalawán da tolay kaggína. ");
INSERT INTO isd_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ay kitun ay uwad bálud da nga nagdin-dinnámag ya kinadakè na. Ya ngágan na ay Barrabas. ");
INSERT INTO isd_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ay kane maur-urnung ngin datu tolay, ay saludsúdán ne Pilato da ngin nga nán na kaggída, “Inna ya piyán nu wa ipalawán ku?” nán na. “E Barrabas onu e Jesus nga nengágan ka Cristo?” nán na. ");
INSERT INTO isd_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ata ammu na nga nedarum mala datu tolay ye Jesus kaggína gapu wala kiya ásil da. ");
INSERT INTO isd_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ay ya isa pe, kitu kakowad ne Pilato wa magtutúgaw kitu tugaw na nga magbustigár, ay nepekagi natu atáwa na kaggína nga nán na, “Akkan ka nga mepagbiy-biyáng kiyán na tolay ya áwan bas-básul. Ata nagpannakit tà gapu ki tagenap ku mepanggap kaggína.” ");
INSERT INTO isd_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ay datu ap-apu datu pappádi se datu pangmanàman da, ay nesug-sugsug da datu tolay ta senu e Barrabas tu pepalawán da, ay e Jesus, ay papatay da. ");
INSERT INTO isd_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ay nán ne gubernador ra nagsaludsud kaggída, “Inna kadedi ya duwa ya piyán nu ipalawán ku?” nán na. Ngamay, “E Barrabas!” nán da nga summungbát. ");
INSERT INTO isd_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ay nán ne Pilato kaggída, “Ay nágan lugud ya kuwaan ku ke Jesus nga nengágan ka Cristo?” nán na. Ngamay nán da ngámin, “Pelansám ki krus,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","“Taanna ta?” nán na. “Nágan naya básul na ta?” nán na. Ngamay kinggat da mán kammin na nesar-sáraw ya, “Pelansám ki krus!” nán da. ");
INSERT INTO isd_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ay tútu, kane mammuwán ne Pilato nga áwan na kammala nga màwa ngin, ay nagpálà ka danum, ay se yala nga nagbaggu kitu àráng datu tolay nga nán na, “Awan ku win na biy-biyáng kiya pannakatay nedi ya tolay ya áwan básul. Dakayu kampela ngin nin ya makammu,” nán na. Ata nasingan na pe yin na magariguddò datu tolay yin. ");
INSERT INTO isd_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ay nán ngámin datu tolay ya nesungbát kaggína, “Dakami se daya annánà mi yala ya magsungbát kiya pannakatay na!” nán da. ");
INSERT INTO isd_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ay díkod, nepepalawán na nge Barrabas. Ay e Jesus, kane mabalin na nga pasaplit, ay neáwat na kaggída ta senu ilansa da ki krus. ");
INSERT INTO isd_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ay díkod inalà datu suldádu ne gubernador nge Jesus kitu balay tu gubernador, ay se da nga inaribungbong, aggída nga tangabatalyon. ");
INSERT INTO isd_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Linàbuwán da, ay se da nga binaduwán ka dag-daggáng nga bádu. ");
INSERT INTO isd_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ay se da pe ya nangilung kadatu pas-pasanga nga sirrarasi, ay se da nga ipasagápaw kaggína. Ay se da pe ya nepikkam kitu diwanán na íma na tu tàdukud. Ay se da nagpalintud kitu àráng na nga nán da, “Madáyaw ya ári daya Judyu!” nán da nga pangug-og kaggína. ");
INSERT INTO isd_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ay se da manin na linut-lutában. Inalà da pe tu tàdukud, ay se da ipangkur kitu úlu na. ");
INSERT INTO isd_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ay kane mabalin da tu mamà-paultu kaggína, ay linàbu da kammin tu nepabádu da kaggína, ay se da ipabádu kammin tu bádu na. Ay se da nga nelawán ta mawe da ngin na ilansa ki krus. ");
INSERT INTO isd_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ay kane makaadayyu da kitu íli, ay nesabat da ya isa nga tolay nga nagngágan ka Simon nga iCerene. Ay nepakagtu da kaggína tu krus ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ay kane dumatang da kitu giyán na nengágan ka Golgota (ya sarut na yán, ay giyán Tuláng Ulu), ");
INSERT INTO isd_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ay niddán da nge Jesus ka bási ya nakibugán ka apdu. Ngamay kane maramanán na, ay akkan na ininum. ");
INSERT INTO isd_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ay kane melansa da kitu krus, ay nagguuwarán da datu bádu na, sigun kitu nabúnut da. ");
INSERT INTO isd_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ay se da ngala nga nagtutúgaw kitúni ya magbantáy kaggína. ");
INSERT INTO isd_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ay kitu paningúdu kitu úlu na, ay nesúrát ka karátula tu ipabásul da kaggína nga nán na, “E Jesus nga Ari daya Judyu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ay uwad da pe nga duwa nga tirung nga negindán da nga nelansa kaggína. Nepanin-túlad de Jesus kaggída nga duwa. ");
INSERT INTO isd_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ay datu tul-tolay ya maglilíwán, ay magwing-wingíwing da se da igal-galà. ");
INSERT INTO isd_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ay nán da kaggína, “Di mu mà nán na gabbán mu ya Templo, ay se mu la manin ipasíkád ki unag tallu walgaw! Ay turám di igdù ya baggim kampela ngin nin! Ay nu kurug ga ikaw ya An-anà ne Dios, ay umúlug ka mán lugud kiya krus mu!” nán da. ");
INSERT INTO isd_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ay ummán ngámin pe datu ap-apu datu pappádi se datu maragtùgud ki lintag se datu pangmanàman da. Ay ag-agbán da nge Jesus nga nán da, ");
INSERT INTO isd_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Biniyág na daya duddúma nga tolay, ay tura na akkan na mabiyág ya baggi na kampela ngin. Ay nán na pe nga aggína ya ári daya iIsrael. Ay nu umúlug kiya krus na, ay mangurug kami kaggína,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","“Magpiyár ke Dios, ay se nán na pe nga An-anà ne Dios. Ay nu kurug ga pàgan ne Dios, ay sinnan tada mán lugud kídi nu alà ne Dios,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ay datu tirung nga negindán da kaggína nga nelansa kitu krus, ay ummán pe kiyán tu inammáas da kaggína. ");
INSERT INTO isd_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ay kane mangalintutúgu, ay naggìbat tutu wala tu kalawagán panda kitu namreg na. ");
INSERT INTO isd_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ay kane mamreg gin, ay nán ne Jesus nga nepáuy, “Eli, Eli, lema sabactani!” Ya sarut nayán ay, “Dios ku, Dios ku, tura nà pinagdudoray!” nán na. ");
INSERT INTO isd_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ay kane magìna datu duddúma nga atán kitúni tu kinagi ne Jesus, ay nán da. “Karrawán na nge Elias,” ");
INSERT INTO isd_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ay nanagtág tu isa kaggída nga nawe ya nangalà kitu ummán ka lúmut ta sib-sibbukal. Ay se na nga nidsam ka lassam, ay se na nga isarípit kitu adaddu wa bìlà se na kuma nga ipasapsap ke Jesus. ");
INSERT INTO isd_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ngamay nán datu duddúma, “Dita nala kiyán, ta sinnan tada nu umbet kurug ge Elias nga mangalà kaggína,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ay se yala nga nakapáuy manin ne Jesus nga ittu pe yin tu nepappan tu biyág na. ");
INSERT INTO isd_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ay ittu pe idi tu sinindán natu abay pànang nga kurtína kitu unag Templo na nasìlát ta napagkaduwa nga nepagayát kitu pane ngúdu. Ay se yala nangyagyag ka naggat, ay nabkiyán datu pin-pínát. ");
INSERT INTO isd_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ay nalùtán pe datu lúbù a imbután na pínát, ay adu datu natay ya tolay ne Dios tu linumtu kitun na oras. ");
INSERT INTO isd_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Lummawán da kitu lúbù da. Ay kane lumtu we Jesus sin, ay nawe da ngámin ka Jerusalem. Ay adu wa tolay tu nakasingan kaggída. ");
INSERT INTO isd_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ay atán tu kapitán se datu suldádu na nga magbantáy ke Jesus. Ay kane magìna da tu yagyag, se da masingan pe datu nà-nàwa, ay nagansing da tutu wala. Ay nán da, “Kurug nga An-anà ne Dios idi nga tolay!” nán da. ");
INSERT INTO isd_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ay adu pe datu babbay ya nagsisíkád da magsisíngan kitu ad-adayyu. Ay tú dedi datu gumun-gunud kaggína nga naggayát ka Galilea, áta aggída tu sinummeng kaggína. ");
INSERT INTO isd_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ay kabbulun da de Maria Magdalena, se Maria nga ina de Santiago se Jose se itu ina datu annánà tu Zebedeo. ");
INSERT INTO isd_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ay kane gídám min, ay uwad inumbet ta isa nga nabànáng nga iArimatea. Jose tu ngágan na. Isa nga pasúrut ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ay nawe na nga kinagi ke Pilato nga alà na tu baggi ne Jesus. Ay tútu nepidde ne Pilato win kaggína. ");
INSERT INTO isd_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ay díkod inalà tu Jose tu baggi ne Jesus, ay se na nga kinalatkattán ka bar-baru wa binára nga dilána. ");
INSERT INTO isd_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ay se na nga nilnà a netádag kitu ababbalin na nga pinàbután na pínát ta lúbù. Ay se na nesùlin na negitap tu abay ya dalumpenág ga batu kitu gagyangán natu lúbù, ay se yala nawe yin. ");
INSERT INTO isd_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ay nge Maria Magdalena se itu isa nga Maria, ay uwad da nga magtutúgaw kitu àráng natu lúbù. ");
INSERT INTO isd_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ay kitu láwa natu algaw wa panagsagána da kitu panaggiimáng da, ay nawe datu ap-apu datu pappádi se datu Pariseo kitu giyán tu Pilato. ");
INSERT INTO isd_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ay nán da, “Gubernador, madamdam mi nga kitu kasibbiyág pikam natun na mangal-alílaw, ay nán na nga lumtu kanu kammin kiya mekàlu walgaw. ");
INSERT INTO isd_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ay túya pabantayán mu tu lúbù panda ki mekàlu wa algaw ta get mawe takáwan datu tù-tùgúdán na tu baggi na, ay se da nán kadaya tolay ya linumtu kammin. Ata nu ummán kiyán ya màwa, ay nakar-káru yán na angngal-alílaw na may itu nunna,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ay tútu nán tu Pilato kaggída, “Mangalà kayu lugud kadaya suldádu nga magbantáy. Ay pabantayán nu pànang,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ay díkod, tútu nawe da. Kabulun da datu guwardiya, ay seda kinappiya tutu wala negitap tu gitap natu lúbù. Pinasuwalán da tu batu nga gitap na. ");
INSERT INTO isd_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ay kane láwa natu algaw wa panaggiimáng, kitu pagmakát pànang tu Dominggo win, ay nge Maria Magdalena se itu isa nga Maria tu nawe naningan kitu lúbù ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ay turán nala nga nangyagyag ka naggat. Inumbet gayát ka lángit ya isa nga anghel ne Apu nga ittu tu nangisùlin kitu batu wa gitap natu lúbù, ay se na la nga nagtutúgawán. ");
INSERT INTO isd_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Dumiláng tu singan na nga ummán ki kilát. Ay tu bádu na ay napusà tutu wala pe. ");
INSERT INTO isd_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ay datu magbantáy, ay nagansing da pànang kitu anghel, ay tútu nagtar-tartar da. Ay nagbalin da ka ummán ka natay. ");
INSERT INTO isd_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ngamay nán tu anghel kadatu babbay, “Akkan kayu wa mansing! Ammù nga sap-sapúlan nu we Jesus nga nelansa kitu krus. ");
INSERT INTO isd_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ay áwan kídi yin, áta linumtu win, nga ummán kitu kinagi na kadakayu kitun. Umbet kayu ta mawe nu sinnan tu netadágan na. ");
INSERT INTO isd_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ay se nu wala nga karuwan na mawe ikagi kadatu tù-tùgúdán na nga linumtu win. Mawe maginunna ngin ka Galilea. Ay masingan nu kannán. Ittu la yán ya kagiyan ku kadakayu,” nán tu anghel. ");
INSERT INTO isd_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ay díkod nabur-burung datu babbay ya nagtálaw kitu lúbù. Nagansing da kitu anghel ngamay sikkaanggam da pe. Nanagtág da nga nawe nangidámag kadatu tù-tùgúdán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ay kitu dálen, ay pagkìlát da ngala nge Jesus nga summabat kaggída. Ay nán na, “Kumusta kayu!” nán na. Ay umadanni da kaggína, ay se da immán tu bingil na se da dinay-dáyaw. ");
INSERT INTO isd_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ay nán ne Jesus kaggída, “Akkan kayu wa magansing. Mawe nu wa ikagi kadatu ngámin wawwági nga mawe da ka Galilea ta kattoni ya pakasinnán da kiyà,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ay kitu kakowad datu babbay kitu dálen, ay uwad pe yin datu duddúma kadatu suldádu wa nagbantáy nga mameyag kitu íli da nga mangagi kadatu ap-apu datu pappádi kadatu ngámin na nà-nàwa. ");
INSERT INTO isd_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ay tútu nagguurnung datu ap-apu datu pappádi se datu pangmanàman datu Judyu. Nagguumomán da nga pasùsúán da datu nagbantáy ka adu wa pirà. ");
INSERT INTO isd_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ay nán da kaggída, “Ya ikagi nu kadaya tolay, ay nán nu kídi, ‘Kitu gabi ya kakowad mi ya matúdug, ay inumbet datu tù-tùgúdán na nga nangálà kitu baggi na,’ nán nu,” nán datu ap-apu datu pappádi. ");
INSERT INTO isd_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","“Ay nu mammuwán ne gubernador idi, ay dakami yala ya mangamomán kaggína ta senu áwan nu wa problema ngin,” nán da. ");
INSERT INTO isd_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ay tútu inalà in datu nagbantáy tu pirà, ay se da kuwaan nin tu nebílin da kaggída. Ay díkod, ittu tunin tu dámag ga newar-waragáwag kadatu ngámin na Judyu. Ay kadedi nga al-algaw, ay ittu idi kam ya nán daya duddúma nga Judyu. ");
INSERT INTO isd_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ay díkod datu sangapúlu se isa nga tù-tùgúdán na, ay nawe da ka Galilea, kitu bantay nga nebílin ne Jesus nga kapannán da. ");
INSERT INTO isd_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ay kane din na masingan da nge Jesus, ay dinay-dáyaw da, oray atán da magduw-duwa kaggída. ");
INSERT INTO isd_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ay umadanni ye Jesus kaggída se na nán, “Ngámin na kinaturáy ka lángit se kídi ya kalawagán, ay nidde ngámin nin kiyà,” nán na. ");
INSERT INTO isd_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","“Ay túya mawe kayu lugud da magtù-tùgud kadaya ngámin na tolay ta senu umapu da kiyà. Bawtisarán nuda ka pakammuwán da nga ya Ama se ya An-anà se ya Ispiritu ne Dios ya mangitur-turáy kaggída ngin. ");
INSERT INTO isd_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ay suruwán nuda nga mangikurug kadatu ngámin na nebílin ku kadakayu. Dam-damdamman nu wa atán nà peyapeyang kadakayu panda kiya panda naya kalawagán,” nán ne Jesus.");
INSERT INTO isd_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ya nanggayatán naya Napiya nga Dámag nga mepanggap ke Jesu-Cristo wa An-anà ne Dios, ");
INSERT INTO isd_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ay tu nekàwa kurug natu ummán kitu nesúrát ta kinag-kagi natu Isaias nga pagbàbànánan ne Dios kitun nga nán na, “Kagiyan ku kikaw nga mangibon nà ka pagbàbànánan ku nga maginunna kikaw nga mangisagána kiya ilalbet mu. ");
INSERT INTO isd_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ay tú idi ya isarasáraw na ka ir-ir-er: ‘Magsagána kayu kiya ilalbet ne Apu. Kappiyánan nu ya dalenan na!’ nán na nga magbàbànán.” ");
INSERT INTO isd_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ay nawe kurug tu Juan na marammawtisár kitu ir-ir-er. Ay nebàbànán na kadatu tolay nga masápul makappoli da kadatu bas-básul da se da makibawtisár ta senu pakawanan ne Dios da. ");
INSERT INTO isd_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ay adu tolay ya naglalbet kitun na naggigìna ke Juan, nga naggagayát kitu ngámin na il-íli ka Judea se Jerusalem. Ay binawtisarán na datu nangipudnu ke Dios kadatu bas-básul da kitu wángag Jordan. ");
INSERT INTO isd_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nagbádu ngala tu Juan ka bádu wa nàwa ka dùdut kámel se nagsinturon ka lálat. Ay dúdun se digu álig gala pe datu kininna-kinnán na. ");
INSERT INTO isd_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ay nán na pe nga nebàbànán kadatu tolay, “Atán umbet ta sumar-sarunu kiyà nga naturáy pànang may iyà. Ta oray ya magubbád dala kiya gálut sapátus na, ay akkan nà mekari. ");
INSERT INTO isd_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Kídi ay bawtisarán takayu wala pikam, ngamay aggína ya árig mamawtisár kadakayu kiya Ispiritu ne Dios,” nán ne Juan kadatu tolay. ");
INSERT INTO isd_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ay akkan nin na nabayág panda kitun, ay inumbet te Jesus sin na naggayát ka Nazaret ka probinsiya Galilea nga makibawtisár ke Juan kitu wángag Jordan. ");
INSERT INTO isd_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ay kane gumàdáng nge Jesus, ay nasingan na nga ummán ka nalùtán tu lángit. Ay se la nga naganìgad nga nagyán kaggína ya Ispiritu ne Dios nga singan ladágan tu singan na. ");
INSERT INTO isd_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ay se la uwad pe ya úni nga gayát ka lángit nga nán na, “Ikaw ya An-anà ku wa pà-pàgan ku, ay pagang-anggammán taka pànang pe,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ay kane mabalin makibawtisár nge Jesus, ay dágus sala nga neturung naya Ispiritu ne Dios ka ir-ir-er. ");
INSERT INTO isd_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ay appát púlu walgaw na nga nagag-agyán kitúni. Ay pinar-parò ne Sairu kitúni. Ay adu pe datu alsádu wa ul-ulolag kitúni. Ay kane mabalin na mapar-parò, ay uwad datu anghel ne Dios nga nangidde kadatu ngámin na masápul na. ");
INSERT INTO isd_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ay kane ibálud da tu Juan nin, ay nawe pe ye Jesus sin nga nagbàbànán ka Galilea. Nebàbànán na ya Napiya nga Dámag mepanggap ki angngituráy ne Dios. ");
INSERT INTO isd_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ay nán na nga nagbàbànán, “Inumbet tin ya oras, ay tagay pànang ngin ya angngituráy ne Dios. Ay túya makappoli kayu kadaya bas-básul nu win, ay se nu kurugan idi ya Napiya nga Dámag,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ay kane isa ngalgaw nga magdal-dalen ne Jesus kitu dappit tu pisung ka Galilea, ay nasingan na datu duwa nga magwagi, de Simon se Andres nga magtabúkul, ta marangnígay da. ");
INSERT INTO isd_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ay nán ne Jesus kaggída, “Kumíwid kayu kiyà ta tùgúdán takayu wa manganannay kadaya tolay nga mangurug kiyà nga ittu daya bátug nigáyan nu win,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ay tútu dágus da la nga nigsán datu inninígay da, se da ngala nga nebulun nin kaggína. ");
INSERT INTO isd_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ay kane makawáyad da kitu agdal-dalen da, ay nasingan manin ne Jesus de Santiago se Juan na magwagi nga annánà ne Zebedeo. Atán da kitu biray da, nga magur-urip kitu inninígay da. ");
INSERT INTO isd_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ay kirrawán nada manin. Ay dágus da pe yala nga kummíwid. Pinanáwan da ngala ngin tu ama da, se datu kaseng na nga atán kitu biray. ");
INSERT INTO isd_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ay nawe de Jesus ka Capernaum. Ay kitu algaw wa aggiimáng da ay nagtùgud kitúni. ");
INSERT INTO isd_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ay nasdaáwan da kitu agtùgud na, áta naturáy nga akkan ummán kitu agtùgud datu maragtùgud ki lintag. ");
INSERT INTO isd_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ay kitun na oras, kitu sinagoga, ay uwad tolay ya naar-aránan. ");
INSERT INTO isd_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ay nakasáraw nga nán na, “Nágan naya pamàyanám kadakami, Jesus nga iNazaret? Inumbet ka nga mamánis kadakami ta! Ammù mà nu iin ka! Ikaw ya An-anà ne Dios nga nebon na!” nán na. ");
INSERT INTO isd_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ngamay inal-alngán ne Jesus nga nán na, “Náwa ka! Ay magtálaw ka kiya tolay!” nán na. ");
INSERT INTO isd_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ay tútu pinagkangkang natu áran tu tolay, ay se nakapáuy, se yala nga nagtálaw kaggína. ");
INSERT INTO isd_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ay pinagballà ngámin datu tolay, nga nán da kitu isaisa kaggída, “Nágan nedi! Baru nga sur-súru idi a! Naturáy pe. Mandáran na oray daya áran na palawanan, ay ikurug da mà nga kurug!” ");
INSERT INTO isd_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ay dágus pe yala nga nepadámag kadatu ngámin na il-íli nga adanni ka probinsiya Galilea ya mepanggap ke Jesus. ");
INSERT INTO isd_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ay kane lumawán da kitu sinagoga, ay nawe da kitu balay de Simon se Andres. ");
INSERT INTO isd_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ay tu katugángan ne Simon nga babay ay madagáng. Ay díkod kinagi da nga dágus ke Jesus. ");
INSERT INTO isd_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ay díkod ummadanni ye Jesus kitu madagáng se na immán tu íma na se na bangúnan, ay tútu áwan tu dagáng na ngin. Ay tútu aggína ngin tu namangán kaggída. ");
INSERT INTO isd_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ay kane din na masirbut tin tu mata, ay nilbetán ngámin datu tolay datu magtatakit se datu naar-aránan kaggína. ");
INSERT INTO isd_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ay nagdadar-dáran ngámin datu umíli kitu balkon natu balay nga giyán na. ");
INSERT INTO isd_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ay adu datu pinabílag na nga nagbal-baláki datu sinakit da. Ay adu áran pe nga pinataláwan na, may áwan na nga pinagúni kaggída ta am-ammu da mà aggína. ");
INSERT INTO isd_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ay kane dan-danni láwa kane kaláwa, ay gummabi ye Jesus nga bumángun, ay se la nawe nagkar-karárag kitu áwan tolay nga giyán. ");
INSERT INTO isd_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","May sinap-sápul de Simon se datu kabbulun na. ");
INSERT INTO isd_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ay kane masmà da, ay nán da kaggína, “Sap-sapúlan daka ngámin daya tolay,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","May nán ne Jesus kaggída, “Mawe tada kadaya sumarunu nga íli ta senu mebàbànán ku pe kaggída ya Napiya nga Dámag, áta ittu mà ya gákat ku wa inumbet kiddi,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ay tútu nawe ka ngámin ka Galilea. Nebàbànán na ya Napiya nga Dámag kadatu sin-sinagoga, ay nagpatálaw pe kadatu áran kadatu naar-aránan. ");
INSERT INTO isd_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ay kitu kaatán ne Jesus kitu isa nga íli, ay uwad tolay ya naglappang nga inumbet kitu giyán na. Ay nagpalintud da nakim-imallà kaggína nga nán na, “Apu, nu piyán nà ala nga agásan, ay maagásan nà,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nakalakkán ne Jesus kaggína, ay tútu inimmán na se na nán, “Saay, pumiya ka lugud din,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ay tútu dágus sala nga umawan tu lappang na, ay pummiya pe yin tu baggi. ");
INSERT INTO isd_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Ay nán ne Jesus nga namílin tutu wala kaggína kane papannan na ngin, “Akkam kag-kagiyan idi ki oray iinna,” nán na. “Ngamay mangaw-át ka ngala ngin na magpassingan kitu pádi, ay se ka la nga mangidátun ke Dios ka ummán kitu nebílin natu Moses, gapu kiya nekaagásan mu, ta senu mepassingan kadaya tolay nga naagásan ka ngin,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ngamay nawe yin tu tolay se na mán kammin iwaragáwag tu nàwa kaggína. Ay tútu akkan nin na makapagpassingan ne Jesus kadatu il-íli. Ay díkod nagyán nala kitu lasi natu íli nga áwan tolay. Ngamay ngámin datu tolay ya maggayát kadatu il-ileli, ay nawe da ngámin kitu giyán na. ");
INSERT INTO isd_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ay kane isa ngalgaw, ay nagulli kammin ne Jesus ka Capernaum. Nedam-dámag nga atán ka balay da ngin. ");
INSERT INTO isd_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ay tútu adu tutu wala datu tolay ya naglalbet kitu giyán na. Ay díkod áwan da pagyanán nin oray kitu gagyangán. Ay nebàbànán na tu Napiya nga Dámag kaggída. ");
INSERT INTO isd_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ay kitu kaatán na nga magbàbànán, ay uwad da appát tolay ya nangilbet ka magdapepe. ");
INSERT INTO isd_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ay kane akkan da meadanni tu tolay kitu giyán ne Jesus gapu kadatu tolay, ay neunè da kitu atap natu balay. Ay se da binutbotán tu bátug ne Jesus, ay se da nepudsar tu magdapepe nga inabáyun da nga nepipidda kitu abà na. ");
INSERT INTO isd_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ay kane masingan ne Jesus nu wà ummán natu angngurug da, ay nán na kitu magdapepe, “Mapakawan ka ngin kadaya bas-básul mu, ugu.” ");
INSERT INTO isd_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ay uwad pe datu maragtùgud ki lintag ga magtutúgaw kitúni. Ay nán da nga nagsaludsud kitu ur-uray da, ");
INSERT INTO isd_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Tura ummán kiyán ya aggun-úni nayán na tolay! Ay bíláng nga ug-ogan na nge Dios kiyán a! E Dios mà ala ya makapakawan kadaya bas-básul,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ngamay dágus sala nga nammuwán ne Jesus tu agbàbànán da kampela ngin nin panggap kadatun na sal-saludsud da. Ay tútu nán na kaggída, “Tura magsabbat daya uray nu ta!” nán na. ");
INSERT INTO isd_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","“Mabalin na nán nu wa nalapat tala nga kagiyan kiya tolay ya, ‘Napakawan ka ngin kadaya bas-básul mu,’ may iya, ‘Bumángun ka, alà mu ya idda mu, ay se ka la nga manalen.’ ");
INSERT INTO isd_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ngamay ta senu mammuwán nu nga iyà nga nengágan da kitun ka An-anà Tolay, ay atán turáy ku ked kalawagán na mamakawan kadaya bas-básul…” ay se nán kitu magdapepe, ");
INSERT INTO isd_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Bumángun ka! Alà mu ya iddám se ka la mawe ka balay nu!” nán na. ");
INSERT INTO isd_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ay bumángun kurug tu tolay se na nga alà tu idda na, ay se yala nga mawe yin. Ay sisinnán ngámin datu tolay, ay pinagballà da ngámin. Ay dinay-dáyaw da nge Dios nga nán da, “Awan mi pikam ma nasingan na ummán kiyán,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ay kane isa ngalgaw, ay nawe manin ne Jesus kitu kapanágan natu pisung ka Galilea. Ay naglalbet ngámin pe datu tolay kitu giyán na, ay díkod tinùgúdán nada. ");
INSERT INTO isd_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ay nagtálaw manin kitúni. Ay kaggína nga magdal-dalen, ay nasingan na nge Levi nga an-anà ne Alfeo nga magtutúgaw kitu pagbay-bayádán da ka buis. Ay nán ne Jesus kaggína, “Kumíwid ka kiyà,” nán na kaggína, ay kummíwid kurug kaggína ngin. Ay inayabán pe yin ne Levi kitu balay da. ");
INSERT INTO isd_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ay kane atán de Jesus nga magtutúgaw nga mangán ka balay de Levi, ay adu kadatu magpab-pabáyad ka buis se kadatu maragbas-básul tu nepagtutúgaw kaggída ta adu datu kummíwid kaggída. ");
INSERT INTO isd_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ay kane masingan datu maragtùgud ki lintag se datu Pariseo da, ay nán da kadatu tù-tùgúdán ne Jesus, “Taanna, tura meduwa nga mangán ya misturu nu kadaya magpab-pabáyad ka buis se kadaya maragbas-básul?” nán da. ");
INSERT INTO isd_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ay kane magìna ne Jesus tu kinagi da, ay nán na kaggída, “Akkan ittu daya magkuna nga nabílag da daya makasápul kiya duktor, nu di daya makammu wa magtakit da!” nán na. “Akkan nà inumbet nga magayáb kadaya magkuna nga namáru da nu di kadaya mamigbig ga maragbásul da,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ay kane din na isa ngalgaw, ay nagngílin nangán datu tù-tùgúdán tu Juan na marammawtisár se datu Pariseo gapu kitu panagkar-karárag da. Ay díkod nawe datu tolay nga nepamutù ke Jesus nga nán da, “Taanna, tura magngílin na mangán daya tù-tùgúdán ne Juan se daya tù-tùgúdán daya Pariseo, ay akkan kid kadaya tù-tùgúdán mu?” nán da. ");
INSERT INTO isd_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ay nán na kaggída, “Magngílin mangán kadi daya sangaíli naya mangatáwa nu kabul-bulun da ya mangatáwa! Akkan á! Basta kabulun da ya mangatáwa, ay áwan da nga agngílin mangán. ");
INSERT INTO isd_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ngamay umbet ya algaw wa umawan kaggída ya mangatáwa, ay ittu yanin ya agngílin da nga mangán,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ay nagpangárig manin ne Jesus nga nán na, “Awan ya mangìpit ka bar-baru wa lúpus kiya rugrugà. Ata nu pakunán na, ay se kumsan tu bar-baru wa pinagappit na, ay umabay ya pìsi na,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Ay áwan pe ya mangippáy ka apammási kiya nausár rin na lálat ta aggippayán ka bási, ay se na nga laptan. Ata nu pakunán na, ay mabtà tu aggippayán ka bási, ay madadál pe tu bási. Díkod, mippáy ya apammási kiya baru wa lálat nga aggippayán kampela ngin nin,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ay kane isa nga algaw wa aggiimáng, ay nanalen de Jesus se datu tù-tùgúdán na kitu kammayán. Ay kaggída nga manalen kitúni, ay naggalà datu tù-tùgúdán na ka ammay se da nga bùsílán. ");
INSERT INTO isd_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ngamay kane masingan datu Pariseo tu kinuwa da, ay nán da ke Jesus, “Ye sinnam kod daya tù-tùgúdán mu! Tura da kuwaan ya ipànaw naya lintag tada kiya algaw wa aggiimáng!” nán da. ");
INSERT INTO isd_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","May nán ne Jesus kaggída, “Akkan nu nabása ta, tu kinuwa natu Ari David se datu tolay na kane mabisinán da?” nán na. ");
INSERT INTO isd_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","“Linumnà da kitu balay ne Dios se da kanan tu sinápay ya medátun ke Dios oray nu ammu na nga kannaw ki oray inna nu akkan pádi. Ay nàwa idi kitu inagpádi natu Abiatar nga kangatuwán na pádi,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","“Ya tolay ya pinangwa ne Dios ka algaw wa aggiimáng, nga akkan wayya ya algaw nga aggiimáng ya pinangwa na ka tolay,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","“Díkod iyà nga nengágan da kitun ka An-anà Tolay ya apu pe naya algaw wa aggiimáng,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ay kane isa ngalgaw wa aggiimáng manin, ay nawe ye Jesus kitu sinagoga nga magtùgud. Ay uwad laláki kitúni nga nagngasa tu isa nga íma na. ");
INSERT INTO isd_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ay díkod sisímán da nge Jesus ta get nu pabilgan na tu tolay kitun na algaw wa aggiimáng. Ay atán ya ipabásul da kaggína. ");
INSERT INTO isd_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ay tútu nán ne Jesus kitu tolay ya nagngasa tu íma na, “Umbet ka kidde!” nán na. ");
INSERT INTO isd_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ay se yala nán ne Jesus kaggída, “Inna ya umannúgut kiya lintag tada, ya mangwa ka napiya onu ya mangwa ka nadakè ki algaw wa aggiimáng? Ya mamiyág onu ya pumatay?” nán na. Ngamay áwan nagúni kaggída. ");
INSERT INTO isd_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ay tútu binubutgán nada nga sirrurungat. Ay sippapannakit pe gapu kitu akkan da nga angngur-kurug. Ay se na nán kitu tolay, “Ùnatam ya ímam!” nán na. Ay tútu inùnát na kurug, ay pummiya kurug gin tu íma na. ");
INSERT INTO isd_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ay nagkirut datu Pariseo nga nawe yin, ay se da nagkaw-át kitu giyán datu pumane kitu Ari Herodes ta paggaamomanán da nu paannán da tu mamatay ke Jesus. ");
INSERT INTO isd_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ay nagtálaw de Jesus se datu tù-tùgúdán na kitúni se da nawe kitu dappit natu pisung ka Galilea. Ay adu tutu wala datu tolay ya kummíwid kaggína. Naggagayát da ka Galilea se Judea se ");
INSERT INTO isd_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem se Idumea se kitu panidmáng natu wángag Jordan, ay se kadatu il-íli nga adanni ka Tiro se Sidon. Gummánat da ngámin kaggína, áta nagìna da ngin datu kinuw-kuwa na. ");
INSERT INTO isd_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ay kinagi ne Jesus kadatu tù-tùgúdán na nga pad-padánan da tu barangay nga pagtàyán na, ta senu akkan na masid-sidtán ta adu tutu wala datu tolay. ");
INSERT INTO isd_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ata adu pinabílag na kitun, ay díkod piyán tutu wala datu magtatakit ya umadanni kaggína ta senu matùbit da. ");
INSERT INTO isd_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ay nu masingan datu naar-aránan nge Jesus, ay magukkab da kitu àráng na, ay se makasáraw datu áran kaggída nga nán da, “Ikaw ya An-anà ne Dios!” nán da. ");
INSERT INTO isd_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ngamay binílin tutu wala ne Jesus datu áran nga akkan da ipak-pakammu nu nágan ya katutolay na. ");
INSERT INTO isd_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ay nanùdu manin ne Jesus kitu bantay, ay se na inayabán datu piníli na nga tolay na. Ay tútu kummíwid da kaggína, ");
INSERT INTO isd_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Namíli ka sangapúlu se duwa kaggída, nga ittu datu kabul-bulun na, ay se aggída pe ya papannan na nga magbàbànán. Aggída pe tu nengagánan na ka apostoles. ");
INSERT INTO isd_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ay niddán nada pe ka turáy da nga mamatálaw kadaya áran. ");
INSERT INTO isd_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ay tú dedi datu sangapúlu se duwa nga piníli na. Nge Simon na nengágan na ka Pedro, ");
INSERT INTO isd_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","de Santiago se Juan nga magwagi nga annánà ne Zebedeo nga ittu datu nengágan na ka Boanerges nga “Annánà Addug” ya sarut na. ");
INSERT INTO isd_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ay se nge Andres se Felipe se Bartolome, Mateo se Tomas, Santiago nga an-anà ne Alfeo se Tadeo se Simon na nepangágan da ka Cananeo. ");
INSERT INTO isd_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ay se tu Judas Iscariote nga ittu tu namatiliw kammin ke Apu Jesus. ");
INSERT INTO isd_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ay nawe de Jesus sin ka balay da. Ngamay akkan da tutu wala nga makapangán se datu tù-tùgúdán na ta adu manin datu tolay ya naglalbet. ");
INSERT INTO isd_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ay kane ammuwán datu akkobung na tun, ay nawe da nga alà, ta nán da tolay nga magallut. ");
INSERT INTO isd_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ay nán pe datu maragtùgud ki lintag ga naggayát ka Jerusalem nga, “Napatàyán ke Beelzebub nga ap-apu daya áran nga ittu ya mangidde ka turáy na, ay túya mapatálaw na daya ar-áran,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ay tútu kirrawán ne Jesus datu tolay, ay se la nga nagpangárig kaggída nga nán na, “Mabalin nád da pataláwan ne Sairu nge Sairu?” nán na. ");
INSERT INTO isd_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","“Oray nágan na nga umíli, ay akkan na nanáyun nu magpapátay da. ");
INSERT INTO isd_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ay ummán pe nu magpapátay kampela daya tangabalay yin, ay akkan pe ya nanáyun dayán. ");
INSERT INTO isd_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ay ummán pe nu e Sairu kampela ngin nin ya kumagúra kadaya pumane kaggína, ay akkan pe nanáyun nu di pumanda pe yin. ");
INSERT INTO isd_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ngamay ya kurug ga kàwaán na, ay akkan wayya nga malnà naya isa nga tolay ya balay naya nakulnit ta tolay nu di na pikam punnán na pingílan. Ay nu mapíngil na ngin, ay ittu yanin ya akálà na kadaya kuw-kuwa naya nakulnit ta tolay kiya balay na,” nán ne Jesus kadatu tolay. ");
INSERT INTO isd_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ay, “Kurug ya nán ku kadakayu nga mapakawan ngámin na básul daya tolay oray daya nadakè a kag-kagiyan da ke Dios. ");
INSERT INTO isd_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ngamay ya mangirupat kiya Ispiritu ne Dios, ay akkan tutu wala nga mapakawan yán na básul. Ay díkod sibbabásul da peyapeyang,” nán ne Jesus, ");
INSERT INTO isd_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","áta nán datu tolay nga naar-aránan ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ay inumbet tu ina na se datu wawwági na, may nagsisíkád da ngala kitu lasi natu balay se da nga pinàrawán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ay adu datu tolay ya nagtutúgaw kitu lebut. Ay nán da kaggína, “Atán kiya lasi tu inám se datu wawwágim. Ay awágan daka,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ay nán ne Jesus nga summungbát kadatu tolay, “Iinda ya bíláng nga inà se wawwágì ta?” nán na. ");
INSERT INTO isd_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ay se na la iapaapág tu mata na kadatu magtutúgaw se na nán, “Tú mà dedi daya bíláng inà se wawwágì,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","“Ata ngámin daya mangwa kadaya piyán ne Dios, ay tú dayán daya bíláng inà se wawwágì,” nán ne Jesus kadatu tolay. ");
INSERT INTO isd_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ay kitu isa nga algaw manin, ay nawe nagtùgud nge Jesus kitu kapanágan. Ay adu pànang datu tolay ya gummánat kaggína. Ay tútu nawe nagtugaw kitu biray se la umàráng kadatu tolay nga nagtutúgaw wala kitu kapanágan. ");
INSERT INTO isd_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ay adu datu netù-tùgud na may nepangárig nada. Ay nán na kaggída, ");
INSERT INTO isd_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Gìnán nu idi nga ibàbànán ku. Uwad isa nga tolay ya nawe nagwárit ka aggì ki tálun na. ");
INSERT INTO isd_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kaggína nga magwárit, ay nagdattág datu duddúma kitu dálen, ay inumbet datu an-anù se da inimmin sinimtúán. ");
INSERT INTO isd_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ay nagdattág datu duddúma kitu nalus-án na pínát, ay nakaru da nga tumúbu ta akkan da lugud da nadarúnán pànang. ");
INSERT INTO isd_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ngamay kane sumínág, ay nalaylay da ngala se nakarsiyán da ta áwan da nga gamut. ");
INSERT INTO isd_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ay nagdattág datu duddúma nga aggì kitu agkadtán. Ay tumúbu da may tumúbu pe datu kaddat, ay tútu nasíput da, ay díkod akkan da nga nakapagbúnga. ");
INSERT INTO isd_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ay nagdattág datu duddúma nga aggì kitu kadam-aggán natu lusà, ay díkod natalobu da. Ay an-annung na kam pe tu búnga datu duddúma, ay ad-adu kam búnga datu duddúma, ay adu tutu wala tu búnga datu duddúma. ");
INSERT INTO isd_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ay dakayu wa maggigìna kídi, ay lam-lamtan nu daya nagì-gìna nu,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ay kane sissa nge Jesus sin, ay inumbet datu sangapúlu se duwa nga tù-tùgúdán na se datu duddúma kadatu naggigìna kaggína, se da saludsúdan kaggína tu sarut natu pangárig na. ");
INSERT INTO isd_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ay tútu nán ne Jesus kaggída, “Mepakammu kadakayu daya akkan pikam ma nepakammu kitun mepanggap kiya angngituráy ne Dios,” nán na. “Ngamay kadaya duddúma, ay mepangárig gala kaggída. ");
INSERT INTO isd_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ta, Akkan da melasínán oray sisinnán da, ay se akkan da piyán ammuwán oray gì-gìnán da, ta get magulli da ke Dios, ay pakawanan nada kadaya bas-básul da,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","“Akkan nu kurug ga maawátan tu pangárig ku, gane!” nán na. “Ay paannán nu lugud ya mangammu kadaya duddúma pikam?” nán na. ");
INSERT INTO isd_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Ay tú idi ya sarut natu pangárig. Tu aggì a newárit natu tolay ay árig na ya bàbànán ne Dios. ");
INSERT INTO isd_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ay datu nagdattág kitu dálen, ay árig daya bàbànán ne Dios nga nagìna daya tolay, ay inumbet pe ye Sairu nga nagippà kitu nagìna da. ");
INSERT INTO isd_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ay datu nagdattág nga aggì kitu nalus-án na pínát, ay árig daya bàbànán ne Dios nga nagìna da, ay sikkaanggam da nga nangurug kadatu nagìna da. ");
INSERT INTO isd_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","May árig akkan naggamut tu nagìna da. Ay túya akkan da nga nakapagbayág, ay naglikud da ngala ngin kane umbet ya kapar-parigátan se kapal-palakkán da gapu kitu bàbànán na nagìna da. ");
INSERT INTO isd_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ay tu kearígán datu nagdattág kitu agkadtán, ay tu bàbànán ne Dios nga nagìna da, ay se da nga kinurug. ");
INSERT INTO isd_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ngamay gapu kiya lid-lídug da kídi ya kalawagán se ya amminya da kiya kinabànáng, se kadaya duddúma pikam, ay napsílán tu nammuwán da. Ay díkod áwan nagbal-balínán natu nagìna da. ");
INSERT INTO isd_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ay nu itu nadam-ag ga lusà a nagdattagán datu aggì, ay árig kadaya nakagìna kiya bàbànán mepanggap kiya angngituráy ne Dios, ay kinurug da pe. Ay nagbúnga da. An-annung na kam ya búnga datu duddúma, ay ad-adu ya búnga datu duddúma, ay adu tutu wala ya búnga datu duddúma,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ay nán manin ne Jesus kaggída, “Nu masibtán ya pingki, ay akkan ta wayya nga tàbán wànu isirù, nu di ta nga iparotun. ");
INSERT INTO isd_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ay umbet tala ya oras sa kepassingan ngámin daya nasirù. Ay ngámin daya akkan pikam am-ammu daya tolay, ay mepakammu da nu kuwa áta mawadaán da ngin. ");
INSERT INTO isd_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ay kappiyánan nu wa lam-lamtan daya nagìna nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ay se na manin nán kaggída, “Lam-lamtan nu daya nagìna nu. Ay ya panggukud nu para kadaya duddúma, ay ittu kammin ya panggukud ne Dios para kadakayu, ay ad-adu pikam ya midde kadakayu. ");
INSERT INTO isd_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ata daya mangikurug kadaya kagiyan ku, ay maamúngán ya ammu da. Ngamay kadaya akkan mangikurug kadaya kag-kagiyan ku, ay oray daya nán da nga ammu da ngin, ay mippà pikam,” nán ne Jesus kaggída. ");
INSERT INTO isd_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ay nán manin ne Jesus nga nagpangárig, “Ya kàwaán naya angngituráy ne Dios, ay meárig pe kiya nàwa kane mawe ya isa nga tolay ya magtugnu kiya komán na. ");
INSERT INTO isd_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ay se na ngala nga binay-án. Matúdug gala se gumniya ki pagmakát tu kuk-kuwaan na may tumúbu wala tu aggì a netugnu na. Natalobu oray nu áwan na nga inam-ammu. ");
INSERT INTO isd_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ata tumúbu kampela ngin kiya lusà, ay ittu kampela ngin nin ya mamaabay se mamagbúnga. Ay munna ya kabuyág na se la nga magbaggát. ");
INSERT INTO isd_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ay nu malútu win, ay túya aggáni na ngin kitu netugnu na, ta aggagáni pe yin,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ay nán manin ne Jesus nga nagpangárig, “Nágan nád ya pangiarígán ku kiya pangiturayán ne Dios? ");
INSERT INTO isd_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","May iárig ku wala kiya màwa kiya bì-bittì a bukal kaykayu nga mustása nga nemúla. ");
INSERT INTO isd_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","May nu tumúbu se umabay, ay magbalin na ittu ya kabayyán nin kadaya ngámin na kaykayu, ay magbalin na káyu wa nasagúngut nga pagdap-dapúnán se pagsùbútán daya an-anù,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","34","Nepangárig na ngámin datu netù-tùgud na kaggída, ngamay nu tittu da se datu tù-tùgúdán na ay ilaw-lawág naya ngámingámin kaggída. ");
INSERT INTO isd_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ay kane din gídám min, ay nán ne Jesus kadatu tù-tùgúdán na, “Dádun ka dammáng,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ay díkod pinanáwan da ngala datu adu wa tolay kitu dappit. Nagtakay datu tù-tùgúdán na kitu biray nga nagtutúgawán na, ay se da la nagbatta. Ay uwad da pikam ma biray ya nebulun kaggída. ");
INSERT INTO isd_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kaggída nga magbatta, ay pagkìlát tala nga nagbáli ka naggat, ay nepalu-palun tu biray da se natal-talabtabbán da pe. ");
INSERT INTO isd_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ay e Jesus, ay uwad kitu panin íput ta matúdug ga sippupungán. Ay tútu nawe linukág datu tù-tùgúdán na nga nán da kaggína, “Misturu, turám bay-bay-án ya kàwaán tada ngi? Matay tada ngin!” nán da. ");
INSERT INTO isd_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ay tútu bummángun ne Jesus se na pinakusap tu báli, ay se na pinalanay datu bal-balnag, ay díkod nakusap tu báli se lummanay datu bal-balnag. Ay tútu napiya tutu wala tu kalawagán nin. ");
INSERT INTO isd_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ay se na nán, “Taanna, tura kayu malídug ta! Awan nu agpà pikam ma angngurug ta!” ");
INSERT INTO isd_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ay tútu nasdaáwan pànang ngámin datu kabbulun na nga nán da, “Nágan nád naya katutolay nedi ya tolay? Tura oray báli se danum, ay ikurug da,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ay kane dumatang da ngin ka Geraseno nga panidmáng ngin kitu pisung, ");
INSERT INTO isd_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ay naglagsi ye Jesus sin. Ay dágus sala nga summabat kaggína tu isa nga tolay ya naar-aránan na naggayát kitu kalubúán ");
INSERT INTO isd_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","nga ittu tu pag-agyanán na. Ay áwan ya makagáput kaggína ngin oray nu káwar tu pamíngil da kaggína. ");
INSERT INTO isd_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nakírad da nga pingílan may rag-ragsud na ngala. Ay ummán pe tu bingil na, pingílan da pe. May pitapitáng nada ngala datu káwar nga pinamíngil da! Awan tutu wala ngin ya makagáput kaggína. ");
INSERT INTO isd_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ay peyang gabi se algaw, ay atán kitu kalubúán se kadatu ban-bantay ya makapà-páuy nga tal-talinguwan na tu baggi na kampela ngin nin ka batu. ");
INSERT INTO isd_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ay kane masingan na nge Jesus, oray kitu adayyu pikam, ay nanagtág se la nga nagpalintud nga nagdáyaw kaggína nga nán na nga nesáraw, ");
INSERT INTO isd_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","“Jesus nga An-anà ne Dios nga kangatuwán! Nágan na ngin ya kuwaan mu kiyà? Makim-imallà à kikaw ki àráng ne Dios. Akkan nà agpà a parigátan!” nán natu áran. ");
INSERT INTO isd_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Nán na yán áta nán ne Jesus nga, “Lumawán ka ngin kiya tolay ikaw wa áran,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ay se manin nán ne Jesus kaggína, “Inna ya ngágan mu ta?” nán na. Ay tútu, “Riníbu ya ngágan ku ta adu kami,” nán tu áran. ");
INSERT INTO isd_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ay se yala nga nakim-imallà nga akkan na din na ipàruwà ka sabáli nga íli. ");
INSERT INTO isd_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ay kitúni nga bantay, ay uwad da nga adu wa ábuy ya magsasabbù kitúni. ");
INSERT INTO isd_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ay nán datu áran ke Jesus nga nakim-imallà, “Papannan nakami agpà ala ngin na magunag kadatu ábuy yi,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ay tútu pinapan ne Jesus da. Ay tútu nagtálaw datu áran kitu laláki, ay nagkakápan da kadatu moli duwa ríbu wa ábuy. Ay tútu nabukubúkus datu ábuy se da naggugúru wa nagtatagtág ga nameyag kitu tappáng. Ay tútu nepaspáw da ngámin kitu bebay, ay nalimat da ngámin. ");
INSERT INTO isd_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ay díkod datu magtar-tarakan kadatu ábuy, ay nagkakápan da kadatu íl-ileli se kadatu babbabalay nga nedámag tu nàwa. Ay díkod nagkakáwe datu tolay nga siningan tu nàwa. ");
INSERT INTO isd_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Inumbet da kitu giyán ne Jesus, ay nasingan da tu tolay ya nagunggán datu riníbu nga áran, nga nakabádu win se napiya pe tu uray na ngin nga magan-antutúgaw. Ay nagansing ngámin datu tolay. ");
INSERT INTO isd_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ay ngámin datu nakasingan kitu nàwa, ay kinagi da kadatu tolay tu nàwa kitu tolay se kadatu ábuy. ");
INSERT INTO isd_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ay díkod nakim-imallà da ke Jesus nga panáwan na kuma ngin tu íli da. ");
INSERT INTO isd_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ay kane magtakay kitu biray, ay inumpal tu naar-aránan na tolay ya makim-imallà a kumíwid kuma kaggína. ");
INSERT INTO isd_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ngamay pinaddi ne Jesus nga nán na kaggína, “Mawe ka ngin ka babalay nu. Ay ikagim kadaya ù-opun mu ya inagkallà se ya kinuwa ne Apu kikaw,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ay díkod nawe lugud tu tolay yin, ay se nawe kadatu sangapúlu wa il-íli ka Decapolis se na ibàbànán tu kinuwa ne Jesus kaggína. Ay ngámin datu nakagìna, ay pinagballà da pànang. ");
INSERT INTO isd_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ay kane magulli manin de Jesus ka panidmáng natu pisung, ay adu manin tolay ya naglalbet kaggína kitu dappit. ");
INSERT INTO isd_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ay uwad isa nga ap-apu ka sinagoga nga Jairo tu ngágan na. Ay kane masingan na nge Jesus, ay nagpalintud kitu àráng na ");
INSERT INTO isd_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","nga nakim-imallà nga nán na, “Magimmamátay ya an-anà ku wa babay,” nán na. Ay, “Mawe ta agpà ka balay ta immam ta senu bumílag kammin,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ay tútu kummíwid de Jesus. Ay adu manin pe tolay ya kummíwid. Ay pangar-aribungbong datu tolay kaggína. ");
INSERT INTO isd_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ay uwad kadatun pe ya isa nga babay nga sangapúlu se duwa dagun na ngin na magdága. ");
INSERT INTO isd_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ay napal-pallà kitu namàyanán datu du-duktor ta ginastu na ngámin nin datu kuw-kuwa na, ay áwan na ngala nga kaagásan, nu di naturun lugud agpà mán kammin. ");
INSERT INTO isd_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ay nagìna na ngin ya mepanggap ke Jesus, ay tútu pinumsil pe kadatu tolay nga inumpal ke Jesus, se na tùbítan tu bádu ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ata nán na nga, “Maagásan nà ala nga nán ku basta matùbit ku wala ya bádu na,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ay tútu nàmud na nga naagásan nin kitu sinakit na, áta dágus sala nga nakusap tu agdága na. ");
INSERT INTO isd_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ay gapu ta nàmud ne Jesus nga atán pannakabalin na nga lummawán kaggína, ay nagbaliwág nga umàráng kadatu tolay nga nán na, “Inna ya nanùbit ki bádù?” nán na. ");
INSERT INTO isd_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ay tútu nán datu tù-tùgúdán na kaggína, “Tura mu saludsúdan nu inna ya nanùbit kikaw, ay ammum nga adu tolay ya dumlig kikaw!” nán da. ");
INSERT INTO isd_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ay tútu sap-sapúlán ne Jesus nu iinna tu nanlig kaggína. ");
INSERT INTO isd_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ay gapu ta ammu natu babay tu nàwa kaggína, ay tútu nagtar-tartar kitu ansing na. Ay nawe nagpalintud kitu àráng ne Jesus se na ikagi tu kinur-korugan kitu nàwa. ");
INSERT INTO isd_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ay tútu nán ne Jesus kaggína, “Naagásan ka ngin gapu ki angngurug mu. Mawe ka ngin, ay áwan mu riribù in. Ay maagásan ka ngin ki sinakit mu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ay kitu akun-oni pikam ne Jesus, ay uwad pe yin datu magdámag nga gayát kitu balay ne Jairo nga nán da kaggína, “Natay yin tu an-anà mu,” nán da. Ay, “Akkan mu tagge rikurikud de Misturu win,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ngamay nagìna pe ne Jesus tu nepadámag da, ay tútu nán na ke Jairo, “Akkan ka nga malídug! Mangurug ka ngala kiyà,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ay kane mawe da, ay tittu de Pedro se Santiago se Juan na magwagi datu kabulun na. ");
INSERT INTO isd_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ay kane dumatang da kitu balay natu ap-apu, ay tu da la nga linapútán datu gigìnán da nga magariguddò a magsasángit nga pangngadùdukit. ");
INSERT INTO isd_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ay nán ne Jesus kane makalnà, “Tura kayu agpà a magariguddò se makas-asangit, ay akkan wayya nga natay ya an-anà! Matúdug gala,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ay tútu pináas da, áta ammu da nga kurug ga natay yin. Ay pinalawán nada. Awan na nga pinalnà a sabáli kitu netadágan natu an-anà, nu di tittu datu maganà kitu an-anà ala se datu kabbulun na. ");
INSERT INTO isd_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ay inimmán ne Jesus tu íma natu an-anà se na nán, “Talíta kumi,” nán na. Ya sarut nayán, ay “Bumángun ka isang,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ay tútu dágus sala nga bummángun kurug tu an-anà se nanalen, ta sangapúlu se duwa dagun na ngin. Ay pinagballà da pànang tun. ");
INSERT INTO isd_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ay akkan tutu wala nepekag-kagi ne Jesus ki oray iinna nga tolay. Ay se na piniddán tu an-anà ka kanan na. ");
INSERT INTO isd_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ay nagtálaw kitúni ye Jesus se la mawe kitu íli na kampela ngin nin. Ay kumíwid pe datu tù-tùgúdán na. ");
INSERT INTO isd_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ay kane algaw wa aggiimáng, ay nagtùgud kitu sinagoga da. Ay nasdaáwan datu adu wa naggigìna kaggína nga nán da, “Kawà nád ya nakammuwán nedi ya tolay kadayán? Se kawà naya naggayatán naya sírib na se ya pannakabalin na nga mangwa kadaya nakas-kasdáaw wa mà-màwa? ");
INSERT INTO isd_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Di mà ittu yán tu karpinteru wa an-anà ne Maria? Ay de Santiago se Jose se Simon se Judas daya wawwági na? Ay di mà a mag-agyán pe kanedi daya wawwági na nga babbay?” nán da. Ay ittu win tu akkan da nga angngurug gin kaggína. ");
INSERT INTO isd_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ay tútu nán ne Jesus kaggída, “Maday-dáyaw ya pagbàbànánan ne Dios kadaya oray wà na nga íli, malaksid dala kiya íli na kampela ngin nin se kadaya pan-pane na se kadaya akkobung na,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ay díkod akkan nada mapassingannán ka nakas-kasdáaw, áta akkan da nga kurugan. Tittu wala datu ag-aggisa nga magtatakit ta inimmán na nga bummílag. ");
INSERT INTO isd_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ay pagballà nada tura da maddi mangurug kaggína. Ay nawe manin ne Jesus kadatu babbabalay ya magtù-tùgud. ");
INSERT INTO isd_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ay kirrawán na datu sangapúlu se duwa, ay se nada ibon nga matagduduwa nga mawe magbàbànán. Ay niddán nada pe ka turáy da nga mamatálaw kadaya áran. ");
INSERT INTO isd_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ay binílin nada nga nán na, “Akkan kayu tagge ya magbalubálun onu magtuputúput onu magtagipirà. May magtàdukud kayu wala,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ay pinagsapátus nada may akkan nada tagge nga pinagbádu ka naglànù. ");
INSERT INTO isd_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","“Ay nu nágan na nga balay ya linnà nu nga pagdagusán, ay akkan kayu magal-alit kiyán panda ki agtálaw nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","“Ay nu atán íli nga mangagáwa se akkan manggìna kadakayu, ay panáwan nuda ngala, ngamay sap-sapuwán nu daya tápù kadaya bingil nu kiya aglikud nu ngin nga mawe ka angngipakammu nu wa nadakè ya kinuwa da kadakayu,” nán ne Jesus kaggída. ");
INSERT INTO isd_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ay díkod ittu win tu nagkakápan datu tù-tùgúdán na ngin, ay se da nebàbànán nga masápul la makappoli daya tolay kadaya bas-básul da. ");
INSERT INTO isd_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ay adu datu pinat-patálaw da nga ar-áran kadatu tolay, se adu datu magtatakit ta linùlosán da ka denu, ay bummílag da. ");
INSERT INTO isd_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ay nadámag pe natu Ari Herodes ya mepanggap ke Jesus, áta nagdinnámag ya ngágan na. Ay díkod nán datu duddúma nga, “Aggína kam tu Juan na marammawtisár ra linumtu kammin,” nán da. “Ay túya atán ya pannakabalin na nga mangwa kadaya nakas-kasdáaw,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ay nán datu duddúma nga magbaabáag, “E Elias yán,” nán da. Ay nán datu duddúma nga, “Pagbàbànánan ne Dios yán na ummán kadatu nunna nga pagbàbànánan na kitun,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ay nán pe natu Herodes sa, “E Juan kam yán na pinapútul ku kitun na linumtu kammin,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ata tu Herodes kam tu namatiliw kitu Juan se itu nagpebálud kaggína gapu kitu Herodias sa ípág na nga atáwa tu Felipe, áta inatawán na. ");
INSERT INTO isd_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ata kag-kagiyan peyang tu Juan kitu Herodes ya, “Nadakè a atawán mu ya ípág mu,” nán na kaggína. ");
INSERT INTO isd_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ay díkod tútu inangngalùsaw natu Herodias kitu Juan. Ay piyán na tutu wala nga patayan ngamay áwan na nga màwa, ");
INSERT INTO isd_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ta mansing tu Herodes kitu Juan, áta ammu na nga namáru wa tolay, ay se kur-kurugan na nge Dios. Nu magìna na nge Juan, ay mariribù pànang, ngamay pàgan na mà nga gigìnán datu kag-kagiyan tu Juan. ");
INSERT INTO isd_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","May kane din umbet tin tu algaw wa nekeanà tu Herodes, ay nagsay-am, se na inayabán ngámin datu ap-apu ka Galilea se datu kak-kapitán datu suldádu da se datu ngámin na nangátu wa tolay kitúni. ");
INSERT INTO isd_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ay kane umbet tu an-anà tu Herodias sa babbalásang se magsála kitu àráng de Herodes se ngámin datu sangaíli na, ay naganggam tutu wala pànang tu Herodes se datu sangaíli na. Ay tútu nán na kitu babbalásang, “Magadang ka oray iinna, ay idde ku kikaw,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","“Ikari ku tutu wala nga idde ku oray nágan naya piyám, oray gudduwa naya pangiturayán ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ay tútu nawe tu babbalásang nga nepamutù kitu ina na nu nágan natu agngan na kitu ári. Ay nán na, “Nágan naya agngan ku?” nán na. Ay nán natu ina na, “Ya úlu ne Juan na marammawtisár, nán mu,” nán tu ina na. ");
INSERT INTO isd_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ay tútu nagulli tu babbalásang kitu giyán natu ári se na nán, “Ya úlu ne Juan na mamawtisár ya piyán ku wa iddem kiyà kídi yin na nippapáy ka paláter,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ay nagpannakit pànang tu ári, ngamay gapu ta nekar-kari na kitu àráng datu sangaíli na, ay akkan na makagi ya akkan kaggína. ");
INSERT INTO isd_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ay díkod nepilbet na tu úlu tu Juan kitu isa nga guwardiya. Ay tútu nawe tu guwardiya nga pinútul tu Juan nga atán kitu agba-balúdán. ");
INSERT INTO isd_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ay nilbet na tu úlu nga nippapáy ka paláter, ay se na nga idde pe yin kitu babbalásang. Ay díkod nidde natu babbalásang pe yin kitu ina na. ");
INSERT INTO isd_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ay kane magìna datu tù-tùgúdán tu Juan tu nàwa kaggína, ay nawe da nga inalà tu baggi na ay se da netaman. ");
INSERT INTO isd_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ay inumbet pe yin datu sangapúlu se duwa nga nebon ne Jesus. Ay kinagi da kaggína ngámin datu kinuw-kuwa da se datu netù-tùgud da. ");
INSERT INTO isd_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ay adu pe datu tolay ya naglalbet kitu giyán da. Ay díkod oray tu mangán, ay akkan matagammu de Jesus se datu tù-tùgúdán na. Ay tútu nán na kaggída, “Mawe tada nga magatittu ta senu makemáng kayu ka bittì,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ay tútu nagbiray da ngin na nawe magat-atittu kitu giyán nga áwan tolay. ");
INSERT INTO isd_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ngamay adu datu tolay ya nakasingan kaggída kitu neduddúlay da, ay nalásin dada. Ay díkod ngámin datu naggayát kadatu il-íli da, ay nagsasal-ay da ngala ta kumiguru da nga dumatang kitu dúngan de Jesus. Ay nunna da nga nakadatang. ");
INSERT INTO isd_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ay kane din maglagsi ye Jesus kitu biray, ay nasingan na datu adu tutu wala nga tolay, ay nakalakkán pànang kaggída kane pak-pakilamtan na nga ummán da ka karneru wa áwan ya magtar-tarakan kaggída. Ay díkod tútu ginayatán na manin tu magtùgud kaggída. Ay adu tu netù-tùgud na kaggída. ");
INSERT INTO isd_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ay kane din na gumídagídám mala ngin, ay inumbet datu tù-tùgúdán na ngin nga nán da, “Gídám min, ay áwan mà babalay kídi ir-ir-er,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","“Ay túya napiya nu papannam mala ngin daya tolay ta senu makammu da kampela ngin nin na mawe magsápul ka gatángan da nga kanan da kadaya íli se kadaya babalay kiya lebulebut tada,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ngamay nán ne Jesus nga summungbát kaggída, “Iddán nuda ka kanan da,” nán na. Ay tútu summungbát da kaggína nga nán da, “Kawà na pe ya pangalakkán mi ka igátang mi ka kanan da nga magbanor ka duwa gatut ta denari,” nán da ke Jesus. ");
INSERT INTO isd_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ay tútu nán na, “Piga pikam tu sinápay nu ta? Sinnan nu mán,” nán na. Ay tútu nawe da siningan, ay, “Atán limma bukal se atán duwa nga sissida,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ay díkod pinagtugaw na nga pinagbabagtu datu tolay kitu kakadtán. ");
INSERT INTO isd_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ay díkod nagbagbagtu datu tolay. Agmamagatut ta tolay tu duddúma nga bagtu, ay aglilimma púlu tu duddúma. ");
INSERT INTO isd_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ay se la inalà ne Jesus sin datu limma nga bukal sinápay se datu duwa ngabgi nga sissida, se naglángad ka lángit nga nagiyáman ke Dios gapu kadatun. Ay se na sinappitappig tu sinápay se na pekípát kadatu tù-tùgúdán na kadatu tolay. Ay nepekípát na pe datu duwa nga sissida kaggída ngámin. ");
INSERT INTO isd_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ay tútu nagkakán da, ay nabtug da ngámin. ");
INSERT INTO isd_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ay nakùnud da pikam ka sangapúlu se duwa nga baki nga bunna. ");
INSERT INTO isd_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ay limma ríbu tu bíláng datu lalláki yala nga nangán. ");
INSERT INTO isd_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ay kitu ligge ne Jesus nga mamuwà kadatu tolay, ay pinaginunna na ngala ngin datu tù-tùgúdán na nga pinagbatta ta mawe da ka Betsaida nga panidmáng natu pisung. ");
INSERT INTO isd_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ay kane maparbuwát na ngámin nin datu tolay, ay nanùdu pe yin kitu bantay ta mawe ya magkar-karárag. ");
INSERT INTO isd_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ay kane din gid-gidám min, ay uwad din tu biray kitu túlad natu pisung. Ay uwad kam me Jesus kitu bantay nga sissa. ");
INSERT INTO isd_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ay sisinnán na nga masulitán datu tù-tùgúdán na ngin na makauweuwela ta mepasabat tu báli kaggída. Ay kane din danni láwa ngala ngin, ay dinatang nada kitu giyán da. Ay nagdal-dalen kitu otun tu danum. Ay làlápan nada kuma, ");
INSERT INTO isd_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ngamay kane masingan da nga magdal-dalen kitu otun tu danum, ay dálin da nu balangobáng, ay tútu nakasáraw da. ");
INSERT INTO isd_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ata nagansing da tutu wala kane masingan da. Ay tútu dágus sala nga nagúni ye Jesus nga nán na kaggída nga, “Akkan kayu wa magansing ta iyà kam ide,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ay tútu nepagtakay kaggída ngin, ay nakusap pe yin tu báli. Ay tútu pinagballà da pànang ngin. ");
INSERT INTO isd_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ata oray tu kinuwa ne Jesus kadatu sinápay, ay akkan da pe ya naaw-awátan, áta akkan da mapal-pallíiw datu ur-uray da panggap kitu sinápay. ");
INSERT INTO isd_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ay kane dummung da ngin ka dammáng nga ittu tu nangibansiyán da kitu biray da, ay gumàdáng da ka Genesaret. ");
INSERT INTO isd_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ay kane maglagsi da, ay nalásin datu tolay ye Jesus, ");
INSERT INTO isd_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ay nedámag da kadatu ngámin na tolay kitúni ya íli. Ay díkod nilbetán da ngámin datu magtatakit kitu pagpagiyanán da ke Jesus ta paagásan dada kaggína. ");
INSERT INTO isd_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ay oray ka wàna tu angngayán ne Jesus nga babbabalay se il-íli se kadatu agtatáwan, ìmuwán pe datu tolay datu magtatakit kaggína ay se da makim-imallà kaggína nga tùbítan da kuma oray tu arumaymáy yala natu bádu na. Ay ngámin datu nakatùbit, ay bummílag da. ");
INSERT INTO isd_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ay isa ngalgaw uwad da nga Pariseo se datu maragtùgud ki lintag nga gayát ka Jerusalem nga inumbet ka giyán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ay kane magkakán da, ay nasingan da nga mangán nala datu duddúma nga tù-tùgúdán ne Jesus nga naragit datu íma da. Akkan da nagbaggu. ");
INSERT INTO isd_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Ata kadatu Pariseo se kadatu duddúma nga Judyu, ay kurugan da pànang tu gagángay datu mannákam da nga akkan da mangán nu akkan da pikam kapiyánan tu magbaggu. ");
INSERT INTO isd_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ay se páda na pe kadaya gatángan da kadaya sininda, ay akkan da makkán nu akkan munna nga mabguwán. Ay adu pikam daya gagángay datu mannákam da nga pà-pàgan da, ummán kiya aggalinsaw kadaya akap, se aggúgát da kadaya aglutuwán da se datu aruminta da nga bága.) ");
INSERT INTO isd_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ay tútu nagsaludsud datu Pariseo se datu maragtùgud ki lintag ke Jesus nga nán da, “Tura akkan surútan daya tù-tùgúdán mu daya nasur-súru tada nga gagángay datu mannákam tada mepanggap kiya panagbaggu? Mangán da ngala nga akkan na nagbaggu,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ay tútu nán ne Jesus kaggída, “Kurug mà tu kinagi natu Isaias ka mepanggap kadakayu wa tolay ya magpì-pìmáru nga nán na kídi, ‘Dayáwan dà dedi ya tolay ngamay kiya úni da ngala. Ata ya kurug na, ay adayyu ya ur-uray da kiyà. ");
INSERT INTO isd_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ay díkod áwan sur-surbi naya panagday-dáyaw da kiyà, áta daya gagángay tolay yala daya isur-súru da, nga nán da nga bílin pe ne Dios sin,’ nán natu nesúrát ta kinagi tu Isaias.” ");
INSERT INTO isd_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Akkan nu pagan-anu datu bil-bílin ne Dios, ta pà-pàgan nu wa kur-kurugan nin daya sur-súru daya tolay yala,” nán na kaggída. ");
INSERT INTO isd_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ay nán na pe kaggída, “Dakayu ay nasírib kayu wa mangalílaw kiya bílin ne Dios ta senu mekurug nu daya gagángay nu wa tolay kampela ngin nin,” nán na kaggída. ");
INSERT INTO isd_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","“Ata nán natu Moses nga, ‘Ipatag mu ya amám se ya inám. Ay ngámin daya makakagi ka nadakè kiya ama na se ina na, ay masápul la matay,’ nán na. ");
INSERT INTO isd_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ngamay isúru nu mà nga nu atán tolay nga atán ya iseng na kuma kiya ama na se ina na, ay ipalúbus nu mà nga nán kaggída, ‘Iddè kuma kadakayu idi ka iseng ku kadakayu may akkan ku wa midde yin ta iddè ke Dios,’ nán na. ");
INSERT INTO isd_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ay díkod ipalúbus nu idi ya tolay, nga áwan na ngala ngin na iseng kiya ama na se ina na. ");
INSERT INTO isd_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ay nu ummán kiyán, ay akkan nu win na pinagan-anu ya bílin ne Dios gapu wala kiya angngikurug nu kadaya gagángay ya isur-súru nu kadaya tolay. Ay adu pikam daya duddúma nga ummán kadedi ya kuk-kuwaan nu,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ay kirrawán ne Jesus datu tolay, ay se na nán kaggída, “Gìnán nu idi ya kagiyan ku kadakayu ta senu maawátan nu pe,” nán na kaggída. ");
INSERT INTO isd_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","“Akkan wayya nga ittu mamar-paragit kiya isa nga tolay daya makkán na, nu di daya meúni na daya mamaragit kaggína. ");
INSERT INTO isd_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ay dakayu wa maggigìna ay awátan nu lugud ya magìna nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ay tútu pinanáwan ne Jesus sin datu tolay, ay se la nawe kitu balay da. Ay tútu nagsaludsud datu tù-tùgúdán na mepanggap kitu pangárig na. ");
INSERT INTO isd_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ay tútu nán na kaggída, “Oray dakayu gane, ay akkan nu wa maawátan?” nán na. “Akkan nu kadi pikam ammu nga oray nágan naya kanan naya isa nga tolay, ay akkan wayya ittu ya mamadakè kaggína. ");
INSERT INTO isd_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ata akkan na mawe kiya uray na, nu di mamanda ngala kiya sinay na, ay lumawán kammin.” (Díkod, nepakammu na nga nadalus daya ngámin akakkanan.) ");
INSERT INTO isd_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","“Ngamay daya maggayát kiya uray naya tolay, ay ittu dayán daya mamadakè kaggína. ");
INSERT INTO isd_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ata ya uray ya paggayatán daya nadakè a pan-panúnut naya isa nga tolay, ummán kiya nadakè a mepanggap kiya laláki se babay se ya magtákaw se ya pumatay ");
INSERT INTO isd_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","se manaládag, se magágum se mangultit se duddúma pikam ma kinadakè. Ya umsil se ya mamad-padakè se ya magpang-pangátu se ya magpang-pangrát. Maggayát ngámin dayán ki uray naya tolay. ");
INSERT INTO isd_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ay tú ngámin dedi nga nadakè daya mepalawán na maggayát kiya ur-uray daya tolay nga mamaragit kaggída,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ay se yala nawe manin ne Jesus kadatu il-íli nga adanni ka Tiro se Sidon. Ay linumnà kitu isa nga balay kitúni, ay piyán na kuma nu áwan ya makammu. Ngamay akkan makaturáy ta nammuwán kammala datu tolay. ");
INSERT INTO isd_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ay uwad isa nga babay nga atán an-anà na nga babay nga naar-aránan. Nagìna na pe yin ya mepanggap ke Jesus. Ay inumbet ta nagukkab kitu àráng ne Jesus nga ");
INSERT INTO isd_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","nakim-imallà, ta papatálaw na kuma tu áran na nagunag kitu an-anà na. Ay akkan Judyu tun na babay ta neanà ka Fenisia nga isa nga íli ka Siria. ");
INSERT INTO isd_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ay tútu nán ne Jesus kaggína, “Akkan rumbang nga alà ta ya akakkanan daya annánà ka ipakkán ta kadaya átu. Masápul la panganan ta pikam daya annánà,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ay nán tu babay ya summungbát, “Kurug yán Apu, may daya átu, ay kanan da mà pe daya bugta daya annánà kiya sídung tebol da,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ay tútu nán ne Jesus kitu babay, “Ay gapu kiyán na kinagim, ay mawe ka lugud din, ta nagtálaw win tu áran kitu an-anà mu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ay nawe kurug gin tu babay, ay dinatang na ngin tu an-anà na nga magid-idda. Ay nagtálaw kurug gin tu áran kaggína. ");
INSERT INTO isd_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ay nagtálaw manin ne Jesus ka íli ka Tiro se manalen ka Sidon se kitu sakúpan na Decapolis, se magulli kammin kitu dappit pisung ka Galilea. ");
INSERT INTO isd_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ay uwad nangilbet ka tolay ya bangngag se tápap pe. Ay se da makim-imallà ke Jesus nga immán na din. ");
INSERT INTO isd_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ay díkod, nead-adayyu ne Jesus tu tolay kadatu adu wa tolay ta senu magadudduwa da kampela ngin nin. Ay se na nedùdù tu intutuldu na kitu talínga natu tolay, ay se na linuluwán se na iikkam kitu díla na. ");
INSERT INTO isd_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ay se naglángad ka lángit se nakapangtád, se na nán, “Ippata,” nán na. Ay “malùtán” ya sarut na. ");
INSERT INTO isd_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ay dágus sala nga makagìna tu tolay pe yin. Ay se nawangdát pe yin tu aggúni na. ");
INSERT INTO isd_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ay binílin ne Jesus datu tolay nga áwan da kuma nga pangikag-kagiyán nga tolay, ngamay gummagat da mán kammin na nangibàbànán kitu nàwa. ");
INSERT INTO isd_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ay ngámin datu nakagìna kitu dámag, ay pinagballà da nga nán da, “Napiya ngámin daya kuk-kuwaan na,” nán da. “Ta oray bangngag se tápap, ay pakagìnaan na se paguniyan na ka napiya,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ay akkan pikam ma nabayág ka panda, ay nagguurnung manin datu tolay kitu giyán ne Jesus. Ay áwan da nga kanan nin. Ay tútu kirrawán ne Jesus datu tù-tùgúdán na, ay se na nán kaggída, ");
INSERT INTO isd_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Makalakkán nà kadedi ya tolay ta tallu nga algaw da ngin na nebul-bulun kadàtada, ay áwan da nga kanan. ");
INSERT INTO isd_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ay nu papannan kuda nga sibbibisin, ay get mullaullap da kiya dálen. Adayyu pe din ya naggayatán daya duddúma,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ay tútu nán datu tù-tùgúdán na kaggína, “Ay mapaanna ya amangán tada kídi ya ir-ir-er kiya ummán kídi kaadu nga tolay?” nán da. ");
INSERT INTO isd_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ay tútu nán ne Jesus kaggída, “Piga bukal sinápay ya atán kadakayu ta?” nán na. Ay nán da, “Atán pittu,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ay díkod pinagtugaw ne Jesus sin datu tolay kitu lusà. Ay se na inalà datu pittu wa sinápay se na la nga nagiyáman ke Dios, ay se nada sinappitappig, ay se na nepekípát kadatu tù-tùgúdán na kadatu tolay. ");
INSERT INTO isd_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ay uwad da pe ya bittè a bibittì a sissida da. Ay inalà pe ne Jesus se na la pe ya nagiyáman ke Dios, ay se na pe nepekipakípát kadatu tù-tùgúdán na kadatu tolay. ");
INSERT INTO isd_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ay nangán da ngámin, ay nabtug da ngámin pe. Ay nakùnud da pikam ka pittu baki nga bunna da. ");
INSERT INTO isd_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ay moli appát ríbu datu tolay ya nagkakán. Ay se la pinapan ne Jesus datu tolay. ");
INSERT INTO isd_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ay nagtakay da pe se datu tù-tùgúdán na kitu biray, se da makìtuway kadatu tolay. Ay nawe da ka Dalmanuta. ");
INSERT INTO isd_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ay kane din na isa ngalgaw, ay inumbet manin datu Pariseo wa makisuw-suwáy kaggína ta piyán da nga sisímán. Ay ittu tu agpàwa da kaggína ka nakas-kasdáaw wa maggayát ka lángit. ");
INSERT INTO isd_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ay tútu nakapangtád de Jesus nga nán na, “Taanna, tura piyán pikam mala dedi ya tolay nu atán mepassingan kaggída nga nakas-kasdáaw. Ngamay kurug idi ya nán ku kadakayu nga áwan nin ya mepassingan na pagilasínán nu wa tolay,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ay tútu nagtakay da kammin kitu biray se da panáwan da, ay seda mawe ka dammáng natu pisung. ");
INSERT INTO isd_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ay kane din na atán da ngin kitu dammáng, ay nadamdam da nga naligpanán da ya nagbálun ka sinápay, ay tang-tangabukal tu atán kaggída kitu biray da. ");
INSERT INTO isd_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ay nán ne Jesus kaggída, “Sin-sinnan nu se taronan nu ya pamal-palabbád daya Pariseo se Ari Herodes,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ay tútu binàbànán da tu kinagi ne Jesus nga nán da, “Kinagi na tun ta ammu na nga áwan tada bálun nga sinápay,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ngamay nammuwán ne Jesus tu kinagi da. Ay tútu nán na kaggída, “Tura nu pagbàbànánan ya áwan nakapangitúgut kadakayu ka sinápay? Akkan kayu agpà makaaw-áwat pikam ta! Kumulnit pe yin daya ur-uray nu ta?” nán na. ");
INSERT INTO isd_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","“Simmamata kayu, ay tura nu di masingan! Se sittatalínga kayu pe, ay tura kayu di makagìna! Naligpanán nu win ta, ");
INSERT INTO isd_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","tu inannappitappig ku ka limma bukal sinápay nga para kadatu limma ríbu wa tolay! Ay piga baki datu napnu kitu bunna da nga inùnudán nu ta?” nán na. “Sangapúlu se duwa,” nán da nga summungbát. ");
INSERT INTO isd_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ay ummán pe kitu pittu wa bukal la sinápay ya sinappitappig ku para kadatu appát ríbu wa tolay. Piga baki tu bunna nga naurnung nu?” nán na. Ay, “Pittu baki,” nán da nga summungbát. ");
INSERT INTO isd_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ay se na la nán kaggída, “Ay akkan nu nád pikam mala maawátan tu nán ku?” nán na. ");
INSERT INTO isd_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ay kane atán da ngin ka Betsaida, ay uwad da tolay ya nangilbet ka kúláp ke Jesus, ay nakim-imallà da kaggína nga immán na din. ");
INSERT INTO isd_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ay díkod binaybay ne Jesus tu kúláp, se na ilawán kitu babalay. Ay se na luluwán tu mata na se na iparotun tu íma na kaggína, ay se na saludsúdan, “Makasingan ka ngin?” nán na. ");
INSERT INTO isd_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ay tútu, “Ò. Masingan ku daya tolay may ummán da ka magdal-dalen na káyu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ay tútu inimmán manin ne Jesus tu mata natu tolay, ay se kappiyánan tu tolay tu isissingan na. Ay tútu nagwada kammin nin tu isissingan na kadatu ngámin nin. ");
INSERT INTO isd_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ay se la pinapan ne Jesus sin tu tolay kitu balay da, ay binil-bílin na nga nán na, “Akkan ka tagge maw-awe kiya íli,” nán na kitu tolay. ");
INSERT INTO isd_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ay netul-túluy de Jesus se datu tù-tùgúdán na tu nagdal-dalen ta mawe da ka íli Cesarea nga sakúpan na Filipos. Ay kaggída nga magdal-dalen, ay sinaludsúdán ne Jesus da nga nán na, “Iinna ngà kanu wa nán daya tolay?” nán na. ");
INSERT INTO isd_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ay tútu nán da nga summungbát, “Nán daya duddúma nga ikaw kanu tu Juan na marammawtisár. Ay e Elias ka kanu wa nán daya duddúma. Ay nán pe daya duddúma nga isa ka nga pagbàbànánan ne Dios kitun nga linumtu,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ay, “Dakayu, iinna ngà ka nán nu?” nán na kaggída na. Ay e Pedro tu summungbát nga nán na, “Ikaw ya Cristo,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ay binílin ne Jesus da tutu wala nga akkan da kag-kagiyan tun na mepanggap kaggína ki oray iinna nga tolay. ");
INSERT INTO isd_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ay nanggayát kitun na oras, ay ginayatán ne Jesus sin tu mangipakammu kadatu tù-tùgúdán na, nga masápul la adu ya kapal-palakkán naya nengágan da kitun ka An-anà Tolay. Ta lùsawan daya pangmanàman da nga Judyu se daya ap-apu daya pappádi se daya maragtùgud ki lintag. Patayan da ngamay lumtu kammin kiya mekàlu wa algaw. ");
INSERT INTO isd_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ay kinagi na tutu wala yán nga akkan na nepà-pàlíli. Ay tútu inaptán ne Pedro we Jesus nga neadudduwa kitu ad-adayyu se na lùsawan. ");
INSERT INTO isd_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ay nagbaliwág ge Jesus se umàráng kadatu tù-tùgúdán na se na nga kinalùsaw we Pedro nga nán na, “Umadayyu ka kiyà, Sairu!” nán na. “Ta akkan na panaglam-lammat nga gayát ke Dios ya panaglam-lammat mu, nu di gayát ki tolay yala,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ay pinaadanni ne Jesus datu tù-tùgúdán na se datu adu wa tolay kaggína, se na nán kaggída, “Ay nu iinna ya maminya nga magbalin ka tolay ku, ay masápul la kaligpanán na ya mepanggap ki baggibaggi na kampela ngin nin. Ay se na bugtúngan ya krus na, ay se la kumíwid kiyà. ");
INSERT INTO isd_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ata ngámin daya magkikenga kiya biyág da ka mepanggap kiyà, ay tú dayán daya mangiwágà kiya pakabiyágan da kuma ka áwan panda. Ngamay daya akkan magkikenga kiya biyág da gapu kiyà se kiya Napiya nga Dámag, ay tú dayán daya makasmà kiya pakabiyágan da ka áwan panda. ");
INSERT INTO isd_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ata áwan wayya nga magun-gun-ud naya isa nga tolay oray nu kuw-kuwa na ya ngámin na atán kídi ya kalawagán, nu killotán na ya pakabiyágan na ka áwan panda. ");
INSERT INTO isd_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ay áwan pe wayya nga mabalin na idde naya isa tolay ta senu málà na ya pakabiyágan na ka áwan panda. ");
INSERT INTO isd_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ay nu kìpattán nà ya isa nga tolay se iya bàbànán ku kiya pagad-aduwán daya maragbásul se áwan angngurug ga tolay, ay kìpattán ku pe, iyà nga nengágan da kitun ka An-anà Tolay, nu umbet tà a sittuturáy kiya turáy ne Dios nga Ama ku. Ay kiyán na ilalbet ku ay kabul-bulun ku daya anghel ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ay se na la nán kaggída, “Ay kurug idi nga kagiyan ku kadakayu, nga atán da kadakayu kídi ya akkan matay panda kiya akasingan da kiya naturáy nga angngituráy ne Dios,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ay kane din annam ngalgaw ka panda, ay nekíwid ne Jesus nge Pedro se de Santiago se Juan nga magwagi. Ay nawe da nga nagatittu kitu alingúdu wa bantay. Ay kitu kaatán da kitúni, ay naussi tu singan ne Jesus kaggída nga magsisíngan. ");
INSERT INTO isd_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ay tu bádu na, ay pummusà tutu wala pànang nga áwan makadna kitu pusà na kídi ya kalawagán. ");
INSERT INTO isd_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ay pinagkìlát da ngala tu Moses se tu Elias nga makibàbànán ke Jesus. ");
INSERT INTO isd_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ay tútu nán ne Pedro ke Jesus, “Misturu, napiya ngala ta atán kami pe kídi, ta mangwa kami ka tallu wa baw-bawi. Kuwa mu ya isa, ay kuwa Moses ya isa, ay kuwa ne Elias ya isa,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ngamay akkan na urauray tu kinagi na, áta nagansing da tutu wala. ");
INSERT INTO isd_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ay se da la naangpán, ay uwad úni ya nagìna da nga naggayát kitu angap, nga nán na, “Tú idi ya An-anà ku wa pà-pàgan ku. Manggìna kayu kaggína,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ay kane sinnan da tu lib-lebut da, ay áwan da masingan na kabulun da ngin, nu di e Jesus sala. ");
INSERT INTO isd_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ay kitu annagut da ngin kitun na bantay, ay binil-bílin ne Jesus da nga akkan da ikag-kagi ki oray iinna tu nasingan da panda kitu ilaltu na kammin na nengágan da kitun ka An-anà Tolay. ");
INSERT INTO isd_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ay díkod kinurug da tu kinagi na, ngamay nagsisinnaludsúdán da kampela ngin nin tu sarut natu mepanggap kitu ilaltu na kammin. ");
INSERT INTO isd_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ay se da la nagsaludsud kaggína nga nán da, “Taanna tura nán daya maragtùgud ki lintag nga munna pikam ma umbet tu Elias nga pagbàbànánan ne Dios,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ay summungbát te Jesus nga nán na, “Kurug ga munna nga umbet te Elias nga mangappiya kiya ngámingámin. Ngamay di mà a nesúrát kadatu bàbànán ne Dios nga masápul la pal-palakkan daya tolay ka napanat ya nengágan da kitun ka An-anà Tolay, se irupat da pe?” nán na. ");
INSERT INTO isd_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","“Ngamay kagiyan ku kadakayu wa inumbet tin tu Elias, ay kinuwa da ngala kaggína tu piyán da nga ummán kitu nán natu nesur-súrát panggap kaggína,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ay kane makadatang da kitu giyán datu duddúma nga tù-tùgúdán na, ay adu datu tolay ya nasingan da kitúni, ay uwad da pe ya maragtùgud ki lintag nga makisuw-suwáy kadatu tù-tùgúdán na. ");
INSERT INTO isd_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ay kane masingan datu tolay ye Jesus, ay naganggam da pànang, ay tútu nagtatagtág da nga summabat kaggína. ");
INSERT INTO isd_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ay tútu nán ne Jesus kaggída, “Nágan naya pakisuw-suwayán nu kaggída?” nán na. ");
INSERT INTO isd_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ay uwad isa kadatu tolay ya nagkuna nga, “Misturu, nilbet ku kikaw ya an-anà ku wa laláki ta nagunggán áran, nga ittu ya namagúmal kaggína. ");
INSERT INTO isd_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ay káda sumru ya sinakit na, ay mìtol lala. Ay magbúgabúgà ya bugung na, ay magngar-ngarasiyat se kumítur pe. Papatálaw ku kadaya tù-tùgúdán mu ya áran, may akkan da mabaal,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ay tútu nán ne Jesus nga summungbát, “Dakayu wa tolay kadedi nga al-algaw nga áwan angngurug. Tagay yà in na molaw ngamay anúsán ku wala ya sumeng kadakayu. Ilbet nu kídi ya an-anà,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ay tútu nilbet da tu an-anà ke Jesus. Ay kane masingan natu áran ne Jesus, ay pinagkangkang na tu an-anà. Ay nekálin tu an-anà se magkur-kurisagsag se magbúgabúgà tu bugung na. ");
INSERT INTO isd_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ay nagsaludsud de Jesus kitu ama natu an-anà nga nán na, “Kannungay naya inanggayát nayán mapak-pakuna kiyán ta?” nán na. “Nekab-kabittì na kammala ngin nin,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Ay nakírad tutu wala nga isungap naya áran kiya apuy se ipisù na kiya danum nu duddúma ta asippatayan na. Ay túya kalakkán nakami agpà ta sengán nakami nu mabaal mu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ay tútu nán ne Jesus, “Taanna, tura mu nán nu mabaal mu,” nán na. Ay, “Màwa mà ya ngámin kiya tolay ya mangurug ke Dios,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ay tútu nán tu ama natu an-anà a nesáraw, “Mangurug gà,” nán na. “May sengán nà ta nakapsut ya angngurug ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ay kane masingan ne Jesus datu adu wa tolay nga maglalbet kaggína, ay tútu linùsaw na tu áran nga nán na, “Ikaw wa áran na namagúmal se namagbangngag kídi ya an-anà, lumawán ka, ay maddiaddi ka ngin kaggína,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ay tútu nakapáuy tu áran se na pinagkangkang tu an-anà se la nga nagtálaw, ay ummán tutu wala ka innát tu an-anà. Ay tútu nán datu duddúma nga, “Natay!” nán da. ");
INSERT INTO isd_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ngamay kane immán ne Jesus tu íma natu an-anà se na bangúnan, ay nagsíkád dala nga dágus. ");
INSERT INTO isd_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ay kane uwad de Jesus kitu balay yin, ay tittu da ngin se datu tù-tùgúdán na. Ay nagsaludsud da kaggína nga nán da, “Taanna, tura mi akkan mapatálaw tu áran?” nán da. ");
INSERT INTO isd_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ay tútu nán ne Jesus kaggída, “Mapatálaw wala daya ummán kadatun na áran gapu ki kar-karárag,” nán ne Jesus kadatu tù-tùgúdán na. ");
INSERT INTO isd_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ay nagtálaw da kitúni nga giyán, ay nanalen da ka Galilea. Ay akkan piyán ne Jesus nga atán makammu kitu giy-giyán na, ");
INSERT INTO isd_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","áta piyán na nga suruwán datu tù-tùgúdán na. Ay nán na kaggída, “Ipatiliw dà a nengágan da kitun ka An-anà Tolay. Patayan dà, ngamay kiya mekàlu wa algaw ay lumtu wà kammin,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ngamay akkan naaw-awátan datu tù-tùgúdán na tu kinagi na, may magansing da la nga manaludsud kaggína. ");
INSERT INTO isd_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ay se da la dumatang ka Capernaum. Ay kane atán da kitu isa balay kitúni, ay nagsaludsud de Jesus kaggída nga nán na, “Nágan natu pagsuw-suwayán nu kitu dálen?” nán na. ");
INSERT INTO isd_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","May áwan makoni a, ta nagsuw-suwayán da nu iinna tu kangatuwán kaggída. ");
INSERT INTO isd_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ay díkod nagtugaw we Jesus se na pinaderun datu sangapúlu se duwa se na nán kaggída, “Ya maminya nga magbalin ka kangatuwán, ay masápul la ittu kuma ya kababaán kadakayu ngámin se aggína pe ya bátug asassu nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ay se la nangalà ka isa nga an-anà se na ipasíkád kitu àráng da. Ay se na tàboyatan nga nán na, ");
INSERT INTO isd_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Nu iinna ya mamatag kídi ya an-anà gapu kiya angngurug na kiyà, ay bíláng iyà ya pinatag na. Ay daya mamatag kiyà, ay akkan nala nga iyà ya pinatag da, nu di pe iya nangibon kiyà.” ");
INSERT INTO isd_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ay nán tu Juan ke Jesus, “Apu, nakasingan kami ka tolay nga magusár ki ngágan mu nga magpatálaw ka áran kadaya naar-aránan na tolay, ngamay pinongát mi ta akkan tada mà kabulun,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ngamay nán ne Jesus kaggína, “Akkan nu pongatan, ta áwan ya makàwa ka nakas-kasdáaw nga mangusár kiya ngágan ku se nà ala nga pad-padàsán nin nu kuwa. ");
INSERT INTO isd_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ta nu iinna ya akkan kumagúra kadàtada, ay kabulun tada,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","“Ay dam-damdamman nu idi,” nán ne Jesus nga, “nu iinna ya makidde kadakayu ka danum gapu ta tolay nakayu win ne Cristo, ay akkan wayya nga di magun-gunaán,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ngamay nu iinna nga tolay ya gapu naya pakabasúlán dedi ya annánà nga mangurug kiyà, ay napiya ngala kiyán na tolay nu mabissinán ka abay ya batu ya bùlaw na se la mepisù kiya kadalmán naya bebay. ");
INSERT INTO isd_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ay díkod nu ímam ya gapu naya pakabasúlám, ay pùdam, ta napì-piya nga pukul ka nga mawe ka lángit may iya duwa íma nga mawe ka impiyernu nga ittu ya giyán naya apuy ya akkan mataatay. ");
INSERT INTO isd_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ay kiyán na giyán ay ittu ya giyán daya aggat ta akkan mataatay se apuy ya akkan mataatay. ");
INSERT INTO isd_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ay páda na pe nu ya síkil mu ya gapu naya pakabasúlám, ay pùdam pe yala, ta napì-piya ngala ya áwan síkil la mawe ka lángit may iya duwa síkil la mawe ka impiyernu. ");
INSERT INTO isd_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ay kiyán na giyán ay ittu ya giyán daya aggat ta akkan mataatay se apuy ya akkan mataatay. ");
INSERT INTO isd_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ay ummán pe nu ya isa matám ya gapu naya akabásul mu, ay tukilan mu wala ngin. Ata napì-piya ya sissa ya matám ma mawe ka pangiturayán ne Dios, may iya duwa mata nga mippan ka impiyernu. ");
INSERT INTO isd_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ay ittu yán ya giyán daya akkan mataatay ya aggat se akkan mataatay ya apuy. ");
INSERT INTO isd_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ata ngámin tolay ay madalusán ka apuy, ta senu áwan nin ya makadadál kaggída nga ummán kiya akakkanan na maasinán ta akkan pe yin na madadál. ");
INSERT INTO isd_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Nasurbi ya asin, may nu mippà ya apet na, ay akkan ta mabalin na mapaapet tin. Ay màwa nu din ya màwa naya asin ta senu napiya ya panagbubúlun nu,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ay se yala nagtálaw manin ne Jesus kitúni, se la nawe ka probinsiya Judea se kitu panidmáng tu wángag Jordan. Ay adu manin datu tolay ya gummánat kaggína, ay nesúru nada ta ittu tu gangay na. ");
INSERT INTO isd_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ay uwad da pe ya Pariseo wa inumbet ta magsisim kaggína. Ay nán da kaggína, “Meallang nád kiya lintag, nga magadi ya isa nga laláki kiya atáwa na?” nán da ke Jesus. ");
INSERT INTO isd_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ay tútu sinungbátan ne Jesus da ka saludsud nga nán na, “Nágan natu bílin ne Moses kadakayu ta?” nán na. ");
INSERT INTO isd_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ay summungbát da nga nán da, “Nepalúbus natu Moses kiya lintag na nga mangwa ya laláki ka kasurátan kiya atáwa na, ay se yala nga magadi,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","May nán ne Jesus kaggída, “Nepalúbus tu Moses nga magadi kayu kadaya atáwa nu gapu kiya kinasúkir nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","“Ngamay akkan ummán kiyán kuma ya kàwaán na, ta kitu inanggayát natu nekàwa naya kalawagán, ay kinuwa ne Dios ya tolay ka laláki se babay. ");
INSERT INTO isd_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ay gapu kídi, ay panáwan naya laláki daya maganà kaggína ta mawe na kobungan ya atáwa na. ");
INSERT INTO isd_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ay magbalin da nga duwa ka sissa,” nán na. “Ay díkod akkan da nga duwa ngin, nu di da nga sissa ngin. ");
INSERT INTO isd_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Díkod, akkan mabalin na pagsibnaan naya tolay ya pinagamung ne Dios,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ay kane lumnà da kammin kitu balay, ay sinaludsud manin datu tù-tùgúdán na tu kinagi na. ");
INSERT INTO isd_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ay nán na kaggída, “Ya laláki nga mangigsán kiya atáwa na, ay se mangatáwa ka sabáli, ay bíláng nga manaládag yán. ");
INSERT INTO isd_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ay páda na pe kiya babay, nu magadi pe kiya atáwa na se umatáwa pe ka sabáli ay makidaládag pe yán,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ay uwad da nga nangilbet kadatu annánà da ke Jesus, ta senu immán nada. May kinalùsaw datu tù-tùgúdán na da. ");
INSERT INTO isd_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ngamay kane masingan ne Jesus tu kinuwa da, ay nalùsaw. Ay tútu nán na, “Palubúsán nu wala daya annánà nga umbet kiyà. Akkan nuda nga paddiyan, áta ummán kadedi ya annánà daya itur-turayán ne Dios kiya pangiturayán na,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","“Ay lam-lamtan nu idi nga kagiyan ku, nga akkan kurug ga málà kiya pangiturayán ne Dios oray iinna, nu akkan na peturayán ke Dios nga ummán kiya agpeturáy dedi annánà.” ");
INSERT INTO isd_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ay tútu inàrun na datu annánà se na iparotun tu íma na kaggída se nada nga nekar-karárag. ");
INSERT INTO isd_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ay kane din na magrabbuwát te Jesus sin, ay uwad laláki nga inumpal kaggína, ay se magpalintud kitu àráng na nga nán na, “Namáru nga Misturu!” nán na ke Jesus. “Kagiyan mu mán kiyà nu nágan naya kuwaan ku ta senu mabiyág gà ka áwan panda,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ay nán ne Jesus kaggína, “Tura nà ingágan ka namáru,” nán na, “ay áwan mà ya namáru nu di e Dios sala!” nán na. ");
INSERT INTO isd_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","“Ay nu mepanggap kitu saludsud mu, ay ammum mà datu bil-bílin ne Dios nga, ‘Akkan ka pumatay, akkan ka manaládag, akkan ka magtákaw. Akkan ka magbusid, akkan ka mangultit. Ipatag mu ya amám se inám,’ nán na,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ay tútu, “Misturu, nanggayát kitu kabittì ku, ay sur-surútan ku ngámin dayán na bil-bílin,” nán natu bag-bagu. ");
INSERT INTO isd_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ay binubutgán ne Jesus ta pinatag na. Ay se na nán, “Atán pikam isa nga masápul la kuwaam. Mawem iláku ngámin daya kuw-kuwám, ay se mu idde kadaya napubri ya paglakúwám, ay díkod ya bànáng mu, ay atán ka lángit tin. Ay se ka la nga kumíwid kiyà,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ay kane magìna natu bag-bagu tun, ay naglamma ngala, ay sippapannakit ta namánaw ke Jesus, áta nabànáng pànang. ");
INSERT INTO isd_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ay se la ummàráng nge Jesus kadatu tù-tùgúdán na se na nán kaggída, “Nganna ya inagsulit daya babànáng nga meráman kiya pangiturayán ne Dios,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ay akkan ammu datu tù-tùgúdán tu pamàyanán da kitun na kinagi na. Ngamay netul-túluy ne Jesus tu kagiyan na nga nán na, “Annánà ku, nasulit kurug meráman kiya pangiturayán ne Dios daya tolay ya ittu dala pagtalgad ya kinabànáng da. ");
INSERT INTO isd_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ikagì kadakayu nga nalà-lapat tala nga lumbut kiya abbut dágum ya kámel may iya keráman daya nabànáng kiya pangiturayán ne Dios,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ay díkod nasdaáwan pànang datu tù-tùgúdán na nga nán da, “Iinda lugud daya málà kiya pangiturayán ne Dios?” nán da. ");
INSERT INTO isd_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ay binubutgán ne Jesus da nga nán na, “Akkan màwa daya tolay yala idi, may áwan ya di màwa ne Dios,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ay tútu nán ne Pedro wa summungbát, “Ay paanna kami, ay nigsán mi ya ngámingámin gapu kiya ikikkíwid mi kikaw?” nán na. ");
INSERT INTO isd_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","May nán ne Jesus kaggída, “Ikagì ya kurug kadakayu, nga nu iinna ya namánaw kiya balay na se kadaya wawwági na onu daya ina na se ama na, onu kadaya annánà na onu ya lusà na gapu kiyà se kiya Napiya nga Dámag, ");
INSERT INTO isd_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ay ad-adu may tu nigsán na ya mepatáli nga midde kaggína kídi ya kalawagán. Ta ad-adu wa babalay se wawwági, se ina, se annánà se lusà ya mepakin-kuwa kaggína, ay se mabiyág pe ka áwan panda nu umbet ya algaw na. Ngamay masápul la mapal-pallà pikam. ");
INSERT INTO isd_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","May adu kadaya magkuna nga nangátu da, may aggída ya mebaba. Ay adu pe daya magkuna nga nababa da, may mepangátu da,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ay kane manùdu da ngin na mameyag ka Jerusalem, ay magin-inunna nge Jesus kadatu malídug nga tù-tùgúdán na. Ay datu gummunud kaggída ay magansing da. Ay pinagatittu ne Jesus datu sangapúlu se duwa nga tù-tùgúdán na se na ikagi kaggída ya màwa kaggína nga nán na, ");
INSERT INTO isd_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Ka Jerusalem ya pameyaggán tada kídi, ay kattoni ay ipatiliw dà a nengágan da kitun ka An-anà Tolay. Ay ippan dà kadaya nangátu wa pappádi se kadaya maragtùgud ki lintag, ay se dà a papatay gapu kiya ipabásul da kiyà, ay se dà iáwat kadaya akkan Judyu. ");
INSERT INTO isd_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ay ug-ogan dà se lut-lutában dà se sap-saplit dà. Ay se dà ala nga patayan. Ngamay lumtu wà kammin kiya mekàlu wa algaw,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ay se la umadanni de Santiago se Juan na annánà ne Zebedeo ke Jesus. Ay nán da kaggína, “Misturu,” nán da. “Piyán mi nga kuwaan mu ya ikagi mi kikaw,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ay tútu nán ne Jesus kaggída, “Nágan naya piyán nu nga kuwaan ku para kadakayu ta?” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ay tútu nán da, “Pagtugawan nakami mán na duwa kiya giyán mu nu mangituráy ka. Isa kiya pane diwanán mu, ay isa kiya pane kasígid mu,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ngamay nán ne Jesus kaggída, “Akkan nu wa maaw-awátan ya agngan nu,” nán ne Jesus. “Mabalin nu nád iturdán ya ummán kiya kapar-parigátan ku?” nán na. “Meturad nu nád pe daya meturdán ku?” nán na. ");
INSERT INTO isd_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Annung mi,” nán da. Ay tútu nán ne Jesus kaggída, “Mabalin na annung nu wa meturdán daya meturdán ku ");
INSERT INTO isd_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ngamay áwan ku pagrabngán na magpíli nu iinna ya magtugaw kiya pane diwanán ku se kiya pane kasígid ku. Ata dedi ay para kadaya nangisaganáan ne Dios kampela ngin nin,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ay kane magìna datu sangapúlu nga tù-tùgúdán na tun, ay kinalùsaw da de Santiago se Juan. ");
INSERT INTO isd_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ay tútu kirrawán ne Jesus da ngámin se na nán kaggída, “Ammu nu nga daya agtuturáy daya akkan Judyu, ay itur-turayán da daya tolay. Ay se daya ap-apu kaggída, ay ipassingan da ya kinaapu da kadaya tolay. ");
INSERT INTO isd_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ngamay akkan ummán kiyán ya màwa kadakayu. Ata ya maminya nga mepangátu, ay masápul la aggína ya magsirbi kadaya kabbulun na. ");
INSERT INTO isd_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ay nu iinna kadakayu ya maminya nga mangiapu, ay aggína kuma ya bátug ga asassu nu ngámin. ");
INSERT INTO isd_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ata oray iyà a nengágan da kitun ka An-anà Tolay, ay akkan nà a inumbet ta pasirbiyán kadaya tolay, nu di iyà ya magsirbi kaggída. Ay inumbet tà pe nga mebasu ta senu mekáru daya bas-básul daya tolay,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ay dummatang de Jesus sin ka Jerico. Ay kane magtálaw da kitúni yin se datu tù-tùgúdán na se datu adu wa tolay ya ummunud kaggída, ay uwad pe ye Bartimeo, nga isa nga kúláp nga an-anà ne Timeo. Uwad da magtutúgaw kitu bíkat kalsáda. ");
INSERT INTO isd_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ay kane mammuwán na nga lumíwán ne Jesus nga iNazaret, ay nán na nga nesáraw, “Jesus nga gakagaka natu David! Kalakkán nà agpà!” nán na. ");
INSERT INTO isd_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ay adu tolay tu nangalùsaw kaggína nga anawáan da may kinggat na mán kammin tu nagkuna nga, “Gakagaka natu David! Kalakkán nà agpà,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ay tútu nagsínang nge Jesus se na pilbet. Ay tútu kirrawán da nga nán da, “Maganggam ka ngin. Ay gumnikát ka ta karrawán naka,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ay díkod nippà na tu kebál na se nakalagtu nga nawe kitu giyán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ay nán ne Jesus, “Nágan naya piyám ma kuwaan ku kikaw?” nán na. Ay, “Pakasinnan nà kammin, Misturu,” nán natu kúláp. ");
INSERT INTO isd_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ay tútu nán ne Jesus, “Mawe ka ngin. Ay makasingan ka kurug gin gapu kiya angngurug mu kiyà,” nán na. Ay dágus sala nga nakasingan nin, ay kummíwid pe yala ngin kade Jesus. ");
INSERT INTO isd_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ay kane magiddadatang da ngin ka Jerusalem, ta atán da ngin kitu bantay Olivo wa nagbàtán daya íli Betpage se Betania, ay nangipàrob nge Jesus ka duwa kadatu tù-tùgúdán na ");
INSERT INTO isd_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","nga nán na, “Mawe kayu kiya amin-dupálan na íli. Ay nu lumnà kayu win, ay masingan nu ya urbun asnu wa nesisílu wa áwan pikam ya nagtakay kaggína. Ay ubbadán nu ta ilbet nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","“Ay nu atán ya magkuna kadakayu ka, ‘Kannán nu wa ubbadán yán?’ nán na, ay nán nu kaggína nga, ‘Masápul ne Apu, ay ipatulli na kammin pe,’ nán nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ay díkod tútu nawe da kurug gin, ay nedúpág gala tu mata da kitu urbun asnu kitu kalsáda nga nesisílu kitu lalàsígán naya isa nga balay. Ay kane ubbadán da ngin, ");
INSERT INTO isd_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ay uwad da kadatu magsisíkád kitúni ya nagkuna kaggída nga nán da, “Tura nu ubbadán ya urbun?” nán da. ");
INSERT INTO isd_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ay tútu kinagi da tu pekagi ne Jesus, ay díkod pinálà da kaggída. ");
INSERT INTO isd_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ay tútu nilbet da tu urbun kitu giyán ne Jesus, ay se da la nga nesàlapán datu bádu da kitu addag natu urbun, ay se yala nagtakay ye Jesus. ");
INSERT INTO isd_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ay adu kadatu tolay tu nangisàláp kadatu bad-bádu da kitu kalsáda. Ay datu duddúma, ay nagtappád da kadatu pas-pasanga datu kay-káyu se da iap-apán kitu kalsáda. ");
INSERT INTO isd_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ay ngámin datu tolay ya nagin-inunna se datu gumun-gunud kaggína, ay nesar-sáraw da ya, “Madáyaw we Dios!” nán da. “Madáyaw ya inumbet nga nebon ne Apu. ");
INSERT INTO isd_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Maday-dáyaw ya umbet ta pangiturayán nga ummán kitu pangiturayán tu apuapu tada nga David. Madáyaw we Dios nga kangatuwán,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ay tútu linumnà e Jesus ka Jerusalem, ay se la nawe kitu templo. Ay kane masingan na ngámin nin datu atán kitúni, ay nawe da se datu sangapúlu se duwa nga tù-tùgúdán na ka Betania, áta gídám pe yin. ");
INSERT INTO isd_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ay kane kaláwa kane inumbet da nga gayát ka Betania, ay nabisinán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ay nasingan na tu káyu wa gígus kitu ad-adayyu kitu dálen nga nasagúngut. Ay tútu nawe na siningan nu atán búnga na. May áwan na nga nasuwà a búnga na, nu di tittu tu adon na ngala, ta akkan agbubúnga daya gígus lugud. ");
INSERT INTO isd_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ay tútu nán na kitu káyu, “Awan nin ya makaramán ka búnga mu win ka panda,” nán na. Ay nagìna datu tù-tùgúdán na tu kinagi na. ");
INSERT INTO isd_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ay kane makadatang da ngin ka Jerusalem, ay linumnà e Jesus kitu Templo se na pataláwan ngámin datu maglà-láku se maggà-gátang kitu unag na. Ay nìtolán na datu tebol datu maragsupli ka pirà se datu tugaw datu maglà-láku ka ladágan. ");
INSERT INTO isd_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ay se na iallang ya atán agtu wa lumíwán kitu amuwág natu Templo. ");
INSERT INTO isd_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ay se yala nga mangisúru kadatu tolay nga nán na, “Nán naya nesúrát ta bàbànán ne Dios nga, ‘Ya balay ku, ay mengagánan ka balay ya agkararágan ngámin tolay ked kalawagán,’ ngamay tura nu mán kammin na pinagbalin ka balay daya maragtákaw,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ay kane magìna datu ap-apu datu pappádi se datu maragtùgud ki lintag tun na kinagi na, ay lam-lamtan da ngin na patayan may umamà da ta pagballà ngámin datu tolay tu angngisúru na. ");
INSERT INTO isd_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ay kane gídám min, ay nagtálaw da ngin kitu íli. ");
INSERT INTO isd_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ay kane pagmakát tin kane lumíwán da manin kitu gígus, ay nasingan da ngin na nalaylay ngámin nin oray tu arutáng na. ");
INSERT INTO isd_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ay gapu ta nadamdam ne Pedro tu nàwa kitu gídám, ay tútu nán na ke Jesus, “Misturu,” nán na, “sinnam kod tu gígus nga ginedán mu may nalaylay yin,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ay tútu nán ne Jesus kaggída, “Mangurug kayu wala ke Dios. ");
INSERT INTO isd_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ay kagiyan ku kadakayu nga mabalin nu pe nga nán kídi ya bantay, ‘Magkalit ka kiyán se ka la magpisù kiya bebay,’ nán nu, nga akkan nu wa paggad-gadduwán nga kurugan na màwa ya piyán nu, ay màwa kurug. ");
INSERT INTO isd_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ay túya kagiyan ku pe kadakayu nga, oray nágan naya piyán nu wa agngan kiya karárag nu, ay kurugan nu nga málà nu kurug, ay midde kurug kadakayu. ");
INSERT INTO isd_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ay ki peyang nga agkar-karárag nu, ay masápul la pakawanan nu daya ammu nu wa nakabásul kadakayu, ta senu ya Ama nu wa atán ka lángit, ay pakawanan nakayu pe kadaya bas-básul nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","“Ngamay nu akkan nu pakawanan daya duddúma, ay akkan nakayu pe pakawanan ya Ama nu wa atán ka lángit,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ay nagulli kammin de Jesus ka Jerusalem. Ay kitu kowad ne Jesus nga magdal-dalen kitu unag templo, ay inumbet datu ap-apu datu pappádi se datu maragtùgud ki lintag se datu pangmanàman datu Judyu, ");
INSERT INTO isd_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","nga nán da, “Kawà naggayatán naya turáy mu wa mangwa kadaya kuk-kuwaam, ay se iinna ya nangidde kikaw kiyán na turáy?” nán da. ");
INSERT INTO isd_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","May nán ne Jesus nga summungbát, “Magsaludsud dà pikam kadakayu, ay nu masungbátan dà, ay túya ikagì pe nu wà naggayatán naya turáy ku wa mangwa kadaya kuk-kuwaan ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ay nán na, “Wà naggayatán natu turáy tu Juan na marammawtisár? Naggayát ke Dios onu kadaya tolay?” nán na. ");
INSERT INTO isd_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ay tútu nagsisinnaludsud da nga nán da, “Nu nán tada nga naggayát ke Dios, ay, ‘Tura nu lugud da akkan kinurug tu Juan,’ nán na. ");
INSERT INTO isd_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ngamay akkan tada makagi nga, ‘Gayát kadaya tolay,’” nán da. Ata magansing da kadatu tolay, áta kurugan datu tolay nga kurug isa nga pagbàbànánan ne Dios tu Juan. ");
INSERT INTO isd_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ay díkod nán da ngala ngin na summungbát ke Jesus, “Akkan mi ammu,” nán da. Ay tútu nán pe ne Jesus kaggída, “Akkan ku lugud pe ikagi nu wà naya naggayatán naya turáy ku wa mangwa kadaya kuk-kuwaan ku,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ay se manin nán ne Jesus nga nagpangárig, “Atán isa nga tolay ya nagmúla ka adu wa úbas, ay se na abutan. Ay nagabbut pe ka abay kitu pínát ta pagaggián da kitu búnga tu úbas ka angngalà da kitu digu na. Ay nangwa pe ka alingúdu wa bal-balay ka pagbantáyan da. Ay se na nga pinatagasinnán ka sabáli tolay, ay se la nawe ka sabáli ya íli. ");
INSERT INTO isd_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ay kane pinagbubúrás sin, ay nangibon tu makin-kuwa kadatu asassu na nga mawe mangalà kitu kípát na kadatu magtag-tagasíngan kitu kaubásan na. ");
INSERT INTO isd_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ngamay dinugkam mán kammin datu magtag-tagasíngan tu nebon na, se da nga sap-saplit se da pinatálaw wa áwan niddeidde kaggína. ");
INSERT INTO isd_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ay díkod nangibon manin ka sabáli nga asassu, may tinal-talíngu da ka pangkur se da neap-appat. ");
INSERT INTO isd_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ay nangibon manin ka sabáli ya asassu, ay pinatay da mán kammin. Ay ummán nala nga ummán tu kinuw-kuwa da kadatu duddúma pikam ma nebon na. Binaubáut da datu duddúma, ay pinatay da datu duddúma. ");
INSERT INTO isd_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","May atán pikam isa nga annung na nga ibon. Tu pà-pàgan na nga an-anà na nga laláki. Ay tútu nebon na tu an-anà na, áta nán na kitu lammat na nga, ‘Ipatag da kam agpà ala ya an-anà ku wi,’ nán na. ");
INSERT INTO isd_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ngamay kane masingan datu magtag-tagasíngan kitu kaubásan tu an-anà natu tolay, ay nán da kitu isaisa kaggída, ‘Tú idi ya magtáwid kídi ya kaubásan. Patayan tada ta senu kuw-kuwa tada ngámin dedi ya tawídan na,’ nán da. ");
INSERT INTO isd_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ay tútu dinugkam da se da nga nippan kitu adayyu kitu kaubásan, ay se da pinatay,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ay se la nán ne Jesus, “Nu umbet tu makin-kuwa kitu kaubásan, ay nágan lugud ya kuwaan na kadatu magtag-tagasíngan kitu kaubásan na, nu di nada nga patayan, ay se na ipatagasíngan ka sabáli yin tu kaubásan na,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ay se na nán kaggída manin, “Akkan nu nád pikam ma nabása kiya nesúrát ta bàbànán ne Dios ya nán na nga, ‘Tu batu wa lùsawan daya maragbalay, ay ittu tu nesulalit nga nagbalin ka kaligdaán na paniínán kiya súli naya balay. ");
INSERT INTO isd_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kinuwa ne Dios nga ummán kiyán ta ittu ya piyán na. Ay nakas-kasdáaw kadàtada yán na kinuwa na,’” nán na. ");
INSERT INTO isd_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ay kane maawátan da nga aggída tu kepapannán natu kinag-kagi ne Jesus nga pangárig na, ay tútu piyán da nga tiliwan, ngamay umamà da kadatu adu wa tolay. Ay tútu nagtatálaw da ngala ngin. ");
INSERT INTO isd_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ay díkod kane magkakápan nin datu Pariseo, ay nagibon da kadatu duddúma nga Pariseo se kadatu bungguy ne Herodes nga mawe ka giyán ne Jesus nga magsisim kaggína kadaya kagiyan na, ta senu atán ya pambár da nga maniliw kaggína nga nán da. ");
INSERT INTO isd_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ay tútu inumbet da kitu giyán na, ay nán da, “Misturu, ammu mi nga akkan ka nga magbutabutal. Ay se kurug pe nga isúrum ya mepanggap kiya piyán ne Dios kadàtada nga tolay. Ay akkan mu pe ya pagdudúmán daya tolay oray nágan naya sáad da. Ay nágan naya nán mu kídi lugud, magbásul kami nád kiya lintag ne Dios nu magbáyad kami ka buis ke Ari Cesar ka Roma, onu akkan?” nán da. ");
INSERT INTO isd_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","“Magbáyad kami nád, onu akkan?” nán da. May nammuwán ne Jesus tu agpì-pìduman da. Ay tútu nán na kaggída, “Tura dà sisímán ta? Iddán dà mán ka pinaláta nga pirà ta sinnan ku,” nán na kaggída. ");
INSERT INTO isd_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ay niddán da ka isa, ay nán na kaggída, “Iinna ya makin-murang se makin-ngágan kiya atán kídi ta?” nán na. “May e ári Cesar,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ay tútu nán na, “Idde nu lugud ke Ari Cesar ya pagrabngán na, may idde nu pe ke Dios ya pagrabngán na kampela ngin,” nán na kaggída. Ay nasdaáwan da tutu wala kitu kinagi na. ");
INSERT INTO isd_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ay uwad da pe nga Saduceo wa inumbet kitu giyán ne Jesus. Daya Saduceo, ay tú dedi daya akkan mangurug kiya ilaltu daya natay. Ay nagsaludsud da ke Jesus nga nán da, ");
INSERT INTO isd_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Misturu,” nán da. “Kinagi natu Moses kitun kitu bílin na kadàtada nga Judyu, nga nu matay ya isa nga laláki ay se áwan na nga pútut, ay masápul la atawán naya wagi natu natay tu búkud, ta senu daya pútut da ay mebíláng da ka pútut natu wagi na nga natay. ");
INSERT INTO isd_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ay uwad pittu wa magwawági nga pabeg lalláki. Nangatáwa tu manákam, may natay yala nga áwan na nga pútut. ");
INSERT INTO isd_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ay díkod inatawán natu mekàduwa nga wagi na tu ípág na. May páda na kam tu nàwa. Natay pe tu laláki nga áwan da pe an-anà. Ay páda na kam pe tu nàwa kitu mekàlu. ");
INSERT INTO isd_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ay áwan ya nakapútut kadatu pittu. Ay se yala natay pe yin tu babay. ");
INSERT INTO isd_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ay díkod nu iya ilaltu daya natay, iinna ya makin-atáwa kitu babay, ay ummatáwa da mà ngámin na pittu kaggína?” nán da ke Jesus. ");
INSERT INTO isd_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ay tútu sinungbátan ne Jesus da nga nán na, “Masábag kayu kiya aglam-lammat nu kiyán a, ta akkan nu maaw-awátan ya nesúrát ta bàbànán ne Dios, ay se akkan nu pe ammu ya kababalin ne Dios,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","“Ata kiya ilaltu kammin datu natay, ay áwan nin ya maggaattáwa kadaya lalláki se babbay. Ata ummán da ngin kadaya anghel ne Dios,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Ay nu mepanggap kiya ilaltu daya natay yin, ay kurug ga lumtu da. Akkan nu pikam nabása kitu nesúrát tu Moses ta, kitu inagkuna ne Dios kitu inagpassingan na kitu maggatagatang nga kaykayu nga nán na, ‘Iyà ya Dios ne Abraham, se Dios pe ne Isaac se Dios pe ne Jacob,’ nán na. ");
INSERT INTO isd_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ata e Dios, ay akkan Dios daya natay, nu di aggína ya Dios daya magbiyág,” nán na. “Kurug tutu wala nga nasábag kayu,” nán ne Jesus kadatu Saduceo. ");
INSERT INTO isd_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ay kane magìna natu isa nga maragtùgud ki lintag tu nagsuw-suway da se itu napiya nga sungbát ne Jesus, ay inumbet pe, se nagsaludsud pe ke Jesus nga nán na, “Misturu, iinna ya kapàgán pànang kadaya ngámin na bil-bílin kiya lintag natu Moses?” nán na. ");
INSERT INTO isd_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ay tútu nán ne Jesus, “Tú idi ya kapàgán pànang, ‘Gìnán nu wa iIsrael. E Apu wa Dios tada, ay sissa nga Apu. ");
INSERT INTO isd_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ipas-pasnà mu tutu wala ya amminya mu ke Apu wa Dios mu. Aggína ya pàgam ki ngámin na ur-uray mu se ki ngámin na biyág mu se ki ngámin na bílag mu,’ nán na. ");
INSERT INTO isd_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ay ya mekàduwa ay, ‘Piyán mu ya kasittolay mu nga ummán kiya amminyám kiya baggim,’” nán ne Jesus. “Ay áwan lintag ga napà-patag may dedi,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","“Ay kurug ya nán mu Misturu,” nán natu maragtùgud ki lintag. “Kurug ya nán mu wa sissa ya Dios, áwan sabáli yin. ");
INSERT INTO isd_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ay se masápul la sissa ya uray naya tolay nga maminya ke Dios se piyán ta ki ngámin na biyág ta, se ki ngámin na bílag ta, se piyán ta pe ya kasittolay ta, nga ummán kiya amminya ta kiya baggi ta. Ay kurug ga napà-patag pànang dedi ngam ngámin daya sinìdug ga pagbasu se dátun,” nán natu maragtùgud ki lintag. ");
INSERT INTO isd_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ay kane nammuwán ne Jesus nga nasírib kitu inagsungbát na, ay tútu nán na, “Adanni ka kiya pangiturayán ne Dios sin,” nán na. Kalpasán natun, ay áwan tutu wala ya maketurad da magsaludsud din kaggína. ");
INSERT INTO isd_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ay kitu agbàbànán pikam ne Jesus kitu Templo, ay nán na, “Taanna, tura kagiyan daya maragtùgud ki lintag nga e Cristo, ay pútupútut tu Ari David? ");
INSERT INTO isd_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ay uwad mà nepekagi naya Ispiritu ne Dios kitu David nga, ‘Nán ne Apu kiya Apu ku, Magtugaw ka kiya pane diwanán ku panda kiya ammasúkù kadaya kumalínga kikaw,’ nán na. ");
INSERT INTO isd_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ay nu ‘Apu’ nán natu David kiya Cristo, ay mapaanna lugud ya agbalin naya Cristo ka gaka natu David?” nán na. Ay naganggam pànang datu tolay ya naggigìna kaggína. ");
INSERT INTO isd_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ay nagtùgud pikam me Jesus nga nán na, “Taronan nu daya maragtùgud ki lintag. Pàgan da ya magdàdàdà a sibbabádu ka adaddu se pà-pàgan da pe ya rispitaran tolay da kiya pagad-aduwán. ");
INSERT INTO isd_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ay pà-pàgan da pe ya magtugaw kadaya agtutúgawán daya nangátu wa tolay kadaya sin-sinagoga se kadaya pagsasay-ammán. ");
INSERT INTO isd_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ngamay tap-taplan da daya kuw-kuwa daya bubbúkud da babbay, ay se da kadadduwan ya magpì-pìkarárag ka panarukkab da kadaya kuk-kuwaan da nga nadakè. Ngamay nadammat tutu wala ya kapanísán daya ummán kadayán na tolay,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ay kane uwad de Jesus kitu templo, ay nagtutúgaw kitu bátug tu aggippayán da ka uperta nga pirà. Ay sin-sinnan na datu tolay ya magippáy kadatu uperta da. Ay adu datu nippáyán datu babànáng. ");
INSERT INTO isd_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ay uwad pe isa nga napubri nga búkud da babay ya nangipisù ka dudduwa nga sintábu. ");
INSERT INTO isd_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ay tútu pinaderun ne Jesus kaggína datu tù-tùgúdán na se na nán kaggída, “Kurug idi nga ikagì kadakayu nga bíláng ad-adu tu nidde natu napubri ya búkud da babay ngam ngámin na nidde datu duddúma,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","“Ata datu duddúma, ay nagidde da ngala kadatu surù ala datu bànáng da. Ngamay aggína, ay oray nganna ya kinapubri na, ay nidde na ngámin tu tittu wa pagbiyág na,” nán na kadatu tolay na. ");
INSERT INTO isd_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ay kane lumawán ne Jesus kitu Templo, ay nán natu isa kadatu tù-tùgúdán na kaggína, “Misturu, sinnam kod, nganna ya inagkadadakkal daya batu-batu na se inagkadadakkal daya bal-balay kiya lebut na,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ngamay nán ne Jesus nga nesungbát, “Sisinnán mu pikam ngámin dedi ya napiya nga bal-balay kídi, may ikagì kadakayu nga umbet ya algaw nga áwan nala ya mabansi nga maglànù a batu nga di mepúkay,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ay kitu kowad ne Jesus nga magtutúgaw kitu bantay Olivo wa umàráng kitu templo, ay inumbet de Pedro se Santiago se Juan se Andres kitu giyán na. Ay tittu da kitúni, ay nán da kaggína, ");
INSERT INTO isd_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ikagim mán kadakami nu nungay naya kàwa ngámin datun. Ay se nu nágan daya pagilasínán mi kiya kàwa ngámin datun,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ay tútu nán ne Jesus, “Magtaron kayu! Akkan kayu wa paal-alílaw ki oray inna! ");
INSERT INTO isd_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ata adu daya tolay ya umbet nga magpamaráng nga magkuna nga, ‘Iyà ya Cristo!’ nán da. Ay adu daya sabágan da. ");
INSERT INTO isd_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ay akkan kayu wa malídug oray madámag nu daya gubagubát se oray magìna nu mismu dayán. Ta masápul la màwa ngámin dayán na munna. May akkan pikam ittu ya panda naya kalawagán,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","“Ata maggugubát pikam daya il-íli ay se maggugubát pe daya il-íli nga iturayán daya à-ári. Ay mangyagyag pe kadaya nagbal-baláki nga giyán, ay se umbet pe ya pinagguulát. May anggayát tala naya kapar-parigátan nu yán. ");
INSERT INTO isd_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ay nu dakayu, ay magtar-taron kayu wala, ta ipatiliw dakayu daya tolay gapu kiya angngurug nu kiyà. Sap-saplit dakayu kadaya sinagoga. Ay ippan dakayu kadaya àráng daya agtuturáy se daya à-ári gapu kiyà, ay tú yanin ya angngipakammu nu kaggída kiya mepanggap kiyà. ");
INSERT INTO isd_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ay se masápul pikam pe ya kebàbànán naya Napiya nga Dámag kadaya ngámin il-íli,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ay se na pe nán, “Ay nu idarum dakayu se dakayu pabasúlan, ay akkan nu punnán na paglídug nu nágan daya isung-sungbát nu. Ata kiya oras na, ay tittu daya mepakammu kadakayu daya isung-sungbát nu. Ata akkan dakayu kampela ngin nin ya magun-úni nu di ya Ispiritu ne Dios. ");
INSERT INTO isd_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ay daya tolay ay papatay da daya wawwági da kampela ngin nin. Ay ummán pe kiyán ya kàwaán daya maggaáma. ");
INSERT INTO isd_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ay kalùsawan dakayu pe daya ngámin tolay gapu kiya angngurug nu kiyà. Ngamay nu iinna ya maketurad panda kiya panda na, ay ittu ya alà ne Dios,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ay nu masingan nu win tu kadàsán na masingan nga atán kiya akkan na kuma kippayán, (Ay maawátan kuma din pànang naya magbása) ay daya atán ka Judea, ay masápul la magkakáwe da ngámin kadaya ban-bantay. ");
INSERT INTO isd_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ay daya mepas-pasmu wa atán kiya atap daya babalay da, ay akkan da tagge umúlug ga maggalà kadatu kuw-kuwa da nga atán kitu unag tu balay da. ");
INSERT INTO isd_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ay daya atán kiya komán da, ay akkan da pe tagge masápul ya umang pikam kadaya babalay da nga mangalà ka bádu da. ");
INSERT INTO isd_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ay kiyán na oras, ay kakal-kalakkán daya nabùsit se daya atán na tagíbi. ");
INSERT INTO isd_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ay ikarárag nu ke Dios nga akkan din na màwa kiya aggamiyán na. ");
INSERT INTO isd_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ata kiyán na algaw, ay napanat pànang ya kapar-parigátan daya tolay. Ta áwan pikam ma ummán kiyán na nakapar-parigátan daya tolay nanggayát kitu nammarsuwa ne Dios kídi ya kalawagán panda kiyán. Ay áwan nin pe ya màwa nga ummán kiyán. ");
INSERT INTO isd_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ay nu akkan nala nga kinabib-án ne Dios ya algaw nayán na kà-kàwaán, ay áwan tolay ya magbiyág. Ngamay gapu kadaya píli ne Dios, ay túya kinabib-án na ya algaw nayán na panagrig-rígát. ");
INSERT INTO isd_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ay nu kiyán na oras, ay atán da magkuna kadakayu nga, ‘Atán kídi ya Cristo,’ onu, ‘Atán kannán,’ nán da, ay akkan nuda kur-kurugan. ");
INSERT INTO isd_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ata daya magpamaráng nga Cristo se daya magpamaráng nga pagbàbànánan ne Dios, ay maglaltuwád da ngin kiyán na al-algaw. Mangipas-passingan da kadaya nakas-kasdáaw pànang nga mà-màwa ka pangalílaw da kadaya tolay. Ay nu mabal-balin kuma ngala ay ialílaw da pe daya píli ne Dios ka tolay na. ");
INSERT INTO isd_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ngamay magtar-taron kayu. Oray ta nekagì ya ngámingámin nin kadakayu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ay nu mabalin ngámin dayanin na rig-rígát, ay maggìbat pe yin ya mata, ay akkan pe yin na pumaláng ya búlán. ");
INSERT INTO isd_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ay metànagán pe daya bittuwan ka lángit se makínin pe daya duddúma pikam nga atán ka lángit. ");
INSERT INTO isd_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ay tú yanin ya akasingan da ngin kiyà a nengágan da kitun ka An-anà Tolay ya umbet tin na mebulun ki angap. Ay masingan da pe ya kinaturáy ku pànang se iya kinadáyaw ku. ");
INSERT INTO isd_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ay se ku wala ibon daya anghel ne Dios nga magurnung kadaya ngámin na píli ne Dios nga tolay na nga maggagayát kadaya ngámingámin na giy-giyán ked kalawagán,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ay damdamman nu ya mà-màwa kadaya káyu wa gígus. Ata nu maglannuway da ngin, ay ammu nu win na tagay yin ya agdagun na. ");
INSERT INTO isd_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ay ummán pe kiyán nga nu masingan nu win datun na kinag-kagì a mà-màwa, ay ammu nu pe yin na tagay tutu wala pe yin ya ilalbet ku. ");
INSERT INTO isd_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ay ikagì tutu wala kadakayu nga màwa ngámin dedi ki di pikam katay ngámin daya tolay kadedi ya al-algaw. ");
INSERT INTO isd_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Madadál lala ya lángit se ya kalawagán, may ya bàbànán ku ay, akkan da wayya nga di màwa,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ay nu iya algaw se oras nga kàwa dayán, ay áwan ya makammu. Oray daya anghel ne Dios, ay oray iyà a nengágan da kitun ka An-anà Tolay. Tittu ya Ama nga atán ka lángit ya makammu. ");
INSERT INTO isd_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Magtaron kayu lugud se sissasagána kayu kuma peyang ta akkan nu lugud ammu nu nungay na ya kàwa nayán. ");
INSERT INTO isd_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ata ya kàwaán na ay meárig kiya kuwaan naya isa nga tolay nga mawe ka adayyu wa íli. Nga nu panáwan na ya balay na, ay patagasinnán na kadaya asassu na, ay ibílin na pe ya kuwaan naya isaisa kaggída. Ay ummán pe ya guwardiya, bilínan na nga magguwardiya kiya gagyangán na. ");
INSERT INTO isd_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ay díkod magsagána kayu peyang ta akkan nu ammu nu nungay naya ilalbet naya makin-balay, bárang kiya gid-gidám onu kiya túlad gabi onu kiya danni láwa, onu kiya pagmakát. ");
INSERT INTO isd_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ay get tala nga malàdadán kayu, ay dàngan nakayu wa matúdug. ");
INSERT INTO isd_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ay daya kinag-kagì kadakayu, ay ittu pe ya kagiyan ku kadaya ngámin tolay,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ay duwa ngalgaw wala ngin se yala nga itu algaw wa piyasta nga panagbabasu se itu angngán da ka sinápay ya áwan pamalbád. Ay datu ap-apu datu pappádi se datu maragtùgud ki lintag, ay magsap-sápul da ka pamàyanán da ta senu nalingad ya anniliw se ammatay da ke Jesus. ");
INSERT INTO isd_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ata nán da nga, “Akkan tada nga ipàmu ki piyasta ta get tala nu maggariguddò daya tolay,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ay kane atán nin de Jesus ka Betania kitu balay ne Simon, tu naglappang kitun, ay uwad isa nga babay ya inumbet kitu giyán ne Jesus, kitu kowad da nga mangán. Ay uwad netúgut na nga tangabutilya nga talibangug nga nangína pànang, ta nàwa ka nardo nga áwan na nga kibukibug. Ay linùtán na tu butilya, ay se na nga isiyasiyà tu talibangug kitu úlu ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ngamay kane masingan datu duddúma nga tolay kitúni, ay nagsabbat tu uray da nga nán da kitu isaisa kaggída, “Tura na dadàlan ya talibangug na,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","“Neláku na kuma ka tallu gatut ta denari yán se na idde kuma ya paglakúwán na kadaya napubri,” nán da, ay se da linùsaw tu babay. ");
INSERT INTO isd_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ngamay nán ne Jesus kaggída, “Bay-án nu wala a. Tura nu pe ya lùsawan, ay napiya mà ya kinuwa na kiyà,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","“Ta daya napubri, ay kabul-bulun nuda peyang, ay oray nágan na nga oras, ay annung nu ya sumeng kaggída, ngamay nu iyà ay akkan nà atán peyang kadakayu. ");
INSERT INTO isd_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ay kinuwa na ya kabailán na. Idi ya nangngípu na kiyà kídi ya talibangug ay angngisagána na kiyà kiya pannaketaman ku. ");
INSERT INTO isd_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ay ikagì kadakayu nga oray kawà na ked kalawagán ni ya kebàbànánan naya Napiya nga Dámag, ay mebàbànán pe ya kinuwa nedi ya babay ka panamdammán daya tolay kaggína,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ay se yala nga nawe pe yin tu Judas Iscariote nga isa kadatu sangapúlu se duwa nga tù-tùgúdán na kitu giyán datu ap-apu datu pappádi, ta mawe na iamomán kaggída ya anniliw da ke Jesus. ");
INSERT INTO isd_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ay kane mammuwán datu ap-apu datu pappádi, ay nagpatag da. Ay tútu kinariyán da ngin ka pirà. Ay tútu isingasingan na pe yin tu oras nga napiya nga angngipatiliw na ke Jesus. ");
INSERT INTO isd_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ay kitu munna nga algaw natu piyasta nga angngán da ka sinápay ya áwan pamalbád, (nga ittu pe tu algaw natu agbasu da ka karneru) ay nán datu tù-tùgúdán ne Jesus kaggína, “Kawà na ya piyám ma pangisaganáan mi ka panggídám tada kídi ya piyasta?” nán da. ");
INSERT INTO isd_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ay tútu nebon na datu duwa kaggída nga nán na, “Mawe kayu kiya íli, ay sabtan nakayu ya isa nga laláki nga sikkaagtu ka tangaamutu nga danum, ay kumíwid kayu win kaggína. ");
INSERT INTO isd_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ay lumnà kayu pe kiya balay nga langkan na, ay se nu wala nán kiya bumalay nga, ‘Pasaludsud ne Misturu nu ka wàna nga kuwartu kanu ya panggidáman na se daya tù-tùgúdán na kídi ya piyasta nga panagbabasu,’ nán nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","“Ay itùgud na kadakayu ya amingúdu wa kuwartu wa abay, ay se atán ngámin pe yin daya masap-sápul kitúni. Ay kitúni ya pangisaganáan nu kiya panggídám tada,” nán ne Jesus kadatu duwa. ");
INSERT INTO isd_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ay díkod, nawe yin datu duwa kitu íli, ay nasmà da kurug ngámin tu kinagi ne Jesus kaggída. Ay tútu nesagána da ngámin nin tu panggídám da kitun na piyasta. ");
INSERT INTO isd_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ay kane gídám min, ay inumbet nge Jesus kitúni yin se datu sangapúlu se duwa. ");
INSERT INTO isd_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ay kitu kowad da ngin na magkakán, ay nán ne Jesus kaggída, “Ikagì tutu wala kadakayu nga atán kadakayu nga kaduwà a mangán ya mangipatiliw kiyà,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ay nagpannakit datu tù-tùgúdán na, ay tútu nagsaludsud tu isaisa kaggída ke Jesus nga nán da, “Iyà ya nán mu?” nán da. ");
INSERT INTO isd_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ay tútu nán na kaggída, “Ya isa kadakayu wa sangapúlu se duwa nga mepúnu kiyà ka pangidnattán ka sinápay, ay aggína,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","“Ngamay màwa mà kammala ngin nin kiyà a nengágan da kitun ka An-anà Tolay ya ummán kitu nesúrát ta bàbànán ne Dios mepanggap kiyà. Ngamay kakal-kalakkán ya tolay ya mangipatiliw kiyà. Napì-piya kuma ngala kaggína nu akkan na neanà,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ay kitu agkakán da, ay nangalà e Jesus ka sinápay, ay se yala nga nagiyáman se na la sinappitappig, ay se na la nidde kaggída, ay se na la nga nán, “Alà nu idi ta kanan nu. Tú idi ya baggì,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ay se na la pe inalà tu binásu wa inuman da. Ay kane mabalin magiyáman, ay nidde na pe kaggída ta senu umminum da ngámin kitúni. ");
INSERT INTO isd_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ay nán na kaggída, “Tú idi ya dágà a katungpálan naya baru nga kari ne Dios kadaya tolay. Mearúyut ya dágà ta senu mapakawan daya bas-básul daya adu wa tolay. ");
INSERT INTO isd_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ay ikagì kadakayu nga akkan nà in na uminum kídi ya mainum nga nàwa ki digu búnga úbas, panda kiya algaw wa angnginum ku manin nu atán nà in kiya pangiturayán ne Dios.” ");
INSERT INTO isd_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ay kane mabalin da nga mangansiyon ka isa nga kansiyon, ay lummawán da ngin, se da nawe kitu bantay Olivo. ");
INSERT INTO isd_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ay nán ne Jesus kaggída ngámin, “Kídi yin na gabi, ay pagtataláwan dà ngámin nin gapu kiya màwa kiyà. Ata atán ya nesúrát kiya bàbànán ne Dios nga nán na, ‘Patayan ku ya magtag-tagasíngan kadaya karneru, ay masip-siparà daya karneru,’ nán na,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“Ngamay nu lumtu wà kammin, ay inunnaán takayu ka Galilea,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ay tutu nán ne Pedro kaggína, “Oray nu pagtataláwan daka ngámin, ay akkan taka paglikudán,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ngamay nán ne Jesus kaggína, “Kagiyan ku tutu wala kikaw nga kídi yin na gabi, ki di pikam ma kapamidduwa daya anù a magittaráut, ay namìluwán nà in na netuláyaw,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ay tútu nag-aggat lugud din tu nangnguna ne Pedro ka, “Oray nu metangatay yà kikaw, ay akkan taka ituláyaw,” nán na. Ay ittu pe yán tu kinagi ngámin datu tù-tùgúdán na. ");
INSERT INTO isd_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ay tútu nawe da ngin kitu giyán na Getsemani. Ay kane dumatang da, ay nán na kadatu tù-tùgúdán na, “Magtutúgaw kayu wala kídi ta mawe yà a magkar-karárag,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ay nebulun na de Pedro se datu duwa nga magwagi, de Santiago se Juan. Ay se yala nagpannakit se nariribù pànang. ");
INSERT INTO isd_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ay se na nán kaggída, “Magpannakit tà pànang, ay ummán nà ka matay gapu kídi ya pannakit ku. Magbansi kayu kídi ngamay mepagpúyát kayu wala kiyà,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ay tútu nawe kitu ad-adayyu, ay se la nagukkab kitu lusà se magkarárag, nga nu mabalin kuma ay melísi kitun na màwa kaggína. ");
INSERT INTO isd_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ay nán na “Ama, mabalin mu kuwaan ya ngámingámin,” nán na. “Nu mabalin kuma ngala, ay ilísi nà kídi ya pannakatay ku, ngamay akkan ya piyán ku ya masúrut, nu di ya piyán mu kampela ngin nin,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ay kane umbet kitu giyán datu tallu, ay dinatang nada nga magkakatúdug. Ay tútu nán na ke Pedro. “Simon, matúdug ka ta? Akkam mabaal, gane, ya mepagpúyát kiyà ka oray isa ngala nga oras! ");
INSERT INTO isd_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Magpúyát kayu se magkarárag kayu ta senu malisiyán nu din daya kapar-paroán nu. Ata kurug ga piyán nu kiya uray nu ya akkan meparò, ngamay nakapsut ya baggi nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ay se la nawe manin na nagkarárag, ay ittu na kam tu nekarárag na. ");
INSERT INTO isd_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ay se la inumbet manin kitu giyán da, ay dinatang nada manin na magkakatúdug, áta akkan da tutu wala nga marngát datu mata da. Ay akkan da ammu nu nágan tu kagiyan da kaggína. ");
INSERT INTO isd_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ay kitu kapamìlu na ngin na manatang kaggída, ay nán na kaggída, “Matúdug kayu pikam ma magimáng? Annung na yanin. Ay inumbet tin tu oras nga angngipatiliw da kiyà a nengágan da kitun ka An-anà Tolay kadaya tolay ya maragbásul. ");
INSERT INTO isd_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ay bumángun kayu ta mawe tada ngin. Sinnan nu kod. Atán nin tu nangipatiliw kiyà,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ay kitu akun-oni pikam ne Jesus, ay inumbet tu Judas nga isa kadatu sangapúlu se duwa nga tù-tùgúdán na. Kabulun na datu adu pànang nga tolay ya nagtagiampiláng se nagtagipapangkur nga nebon datu ap-apu datu pappádi, se datu maragtùgud ki lintag, se datu pangmanàman datu Judyu. ");
INSERT INTO isd_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ay nekagi na ngin kadatu tolay tu pangilasínán da ke Jesus nga nán na, “Ya tolay ya ummàán ku, ay aggína. Ay tiliwan nu se nu wa guwardiyaán na ippan nin,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ay díkod, kane umbet, ay nagkaw-át ke Jesus se na nán, “Misturu,” nán na, se na inummàán. ");
INSERT INTO isd_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ay tútu dinugkam da nge Jesus. ");
INSERT INTO isd_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ay inásut natu isa kadatu kabbulun ne Jesus tu ampiláng na, ay se na nesapgut kitu asassu natu nangátu wa pádi. Ay nataptáp pala tu talínga na. ");
INSERT INTO isd_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ay se yala nga nán ne Jesus kadatu tolay, “Tirung ngà ka nán nu ta! Tura kayu nagtagiampiláng se nagtagipapangkur ra inumbet ta maniliw kiyà! ");
INSERT INTO isd_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Inalgaw wà mà a magtùgud kiya templo, ay tura dà akkan tiniliw kitun kam!” nán na. “Ngamay nàwa idi ka pakatungpálan datu nesur-súrát datu pagbàbànánan ne Dios kitun.” ");
INSERT INTO isd_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ay tútu nagtataláwan datu tù-tùgúdán na. Ay piniddudoray da ngala ngin. ");
INSERT INTO isd_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ay uwad kam isa nga bag-bagu wa nangunud ke Jesus nga sikkikebál lala. Ay dinugkam da. ");
INSERT INTO isd_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ngamay tittu tu kebál na ngala tu nálà da. Ay díkod nagtálaw wala nga sissusoba. ");
INSERT INTO isd_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ay se da la nga nippan ne Jesus kitu balay natu nangátu wa pádi. Ay nagguurnung ngámin nin datu maragtùgud ki lintag se datu pangmanàman da. ");
INSERT INTO isd_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ay ummunud pe ye Pedro, may nagpal-palodi yala. Namanda kitu amuwág tu balay natu nangátu wa pádi. Ay nepagtutúgaw kadatu guwardiya kitúni nga mepagginúdu. ");
INSERT INTO isd_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ay datu ap-apu datu pappádi nga nagguurnung kitúni se datu duddúma nga ap-apu, ay magsap-sápul da ngin ka ipabásul da ke Jesus, ta senu mabalin da nga papatay. Ngamay áwan da masmà a básul na. ");
INSERT INTO isd_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ay adu pe datu magsistígu ka busid kammala ngin nin, may akkan maggaannúgut datu kagiyan da. ");
INSERT INTO isd_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ay uwad da pe kaggída datu nagsíkád nga magsistígu ka busid nga nán da, ");
INSERT INTO isd_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nagìna mi tu kagiyan na nga nán na, ‘Gabbán ku idi ya templo nga kinuwa tolay, may ki unag tallu ngalgaw, ay mangipasíkád dà kammin ka sabáli nga akkan tolay yin ya mangwa,’ nán na.” ");
INSERT INTO isd_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ngamay akkan na maggaannúgut datu kag-kagiyan da nga ipabásul da kaggína. ");
INSERT INTO isd_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ay tútu nagsíkád tu nangátu wa pádi se na nán ke Jesus, “Inna ya mesungbát mu kiyán na ipabásul da kikaw?” nán na. ");
INSERT INTO isd_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ngamay akkan nagun-úni ye Jesus. Awan na tagge nìbág. Ay díkod nagsaludsud manin tu nangátu wa pádi kaggína nga nán na, “Ikaw ya Cristo nga An-anà ne Dios nga kangatuwán?” nán na. ");
INSERT INTO isd_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","“Iyà mà lugud,” nán na. “Ay masingan nu win nu kuwa nga iyà nga nengágan da kitun ka An-anà Tolay ay magtutúgaw wà kiya padne diwanán ne Dios nga katurayán. Ay masingan dà pe nga umbet ta mebulun ki angap nga maggayát ka lángit,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ay tútu pinìsi natu nangátu wa pádi tu bádu na kampela ngin nin ta nakarungat. Ay nán na, “Akkan tada masápul lin daya sistígu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","“Ata nagìna nu win ya kinagi na nga pangirupat na ke Dios. Nágan lugud ya kapanunútán nu?” nán na kadatu tolay. Ay ngámin da ngin ya mamabásul kaggína, ay se da nán na, “Masápul la matay!” nán da. ");
INSERT INTO isd_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ay se linutában datu duddúma tu murang na. Ay se da pe ya amitangngán se da nga sulúngan. Ay se da nán kaggína, “Gattuam mán lugud ya nanúlung kikaw,” nán da. Ay se la simpit datu guwardiya pe kane itálaw da ngin. ");
INSERT INTO isd_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ay kitu kowad ne Pedro wa magtutúgaw kitu amuwág, ay inumbet tu isa kadatu babbay ya asassu natu kangatuwán na pádi. ");
INSERT INTO isd_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ay kane masingan na nge Pedro wa magginúdu, ay kinappiya na nga pinalingig nga nán na, “Kabulun naka mà pe ne Jesus nga iNazaret a!” nán na. ");
INSERT INTO isd_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ngamay netuláyaw ne Pedro nga nán na, “Akkan ku am-ammu ya nán mu,” nán na. “Ay akkan ku pe ya maawátan ya kag-kagiyam,” nán na. Ay se yala nawe kitu lalàsígán. ");
INSERT INTO isd_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ay uwad manin na asassu wa babay ya nakasingan kaggína kitúni, ay nán na kadatu atán kitúni, “Kabulun ne Jesus pe idi ya tolay,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ngamay netuláyaw manin ne Pedro. Ay kane daddán manin, ay umadanni datu atán kitúni ke Pedro, ay nán da, “Kurug mà! Ikaw ya isa kaggída ta iGalilea ka mà,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ay tútu pinagsingánan na tu baggi na nga nagsipata nga nán na, “Akkan ku am-ammu yán na tolay nga kag-kagiyan nu,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ay ittu pe yin tu kapamidduwa datu anù a magittaráut. Ay ittu pe yin tu inakadamdam ne Pedro kitu kinagi ne Jesus kaggína nga, “Kiya di pikam kapamidduwa daya anù a magittaráut ay namìluwán nà in na netuláyaw,” nán na. Ay tútu summángit tutu wala. ");
INSERT INTO isd_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ay kane din na pagbarngát tin, ay nagguurnung datu ap-apu datu pappádi se datu pangmanàman daya Judyu se datu maragtùgud ki lintag se ngámin datu ap-apu da, ta paggaamomanán da nu nágan tu pamàyanán da ke Jesus. Ay inalà da nge Jesus se da pingílan datu íma na, ay se da ippan ke Pilato. ");
INSERT INTO isd_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ay tútu nagsaludsud de Pilato wa nán na, “Ikaw ya ári daya Judyu?” nán na. Ay tútu, “Ò, mà, kurug ya kinagim,” nán ne Jesus. ");
INSERT INTO isd_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ay gapu ta adu datu ipab-pabásul datu ap-apu datu pappádi kaggína, ");
INSERT INTO isd_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ay tútu nán tu Pilato, “Awan mu agpà tutu wala nga mesungbát ta!” nán na. “Sinnam kod, adu daya ipab-pabásul da kikaw,” nán na. ");
INSERT INTO isd_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ay akkan tagge sinung-sungbátan ne Jesus. Ay tútu pagballà ne Pilato. ");
INSERT INTO isd_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ay ki peyang nga piyasta, ay nepagangay kaggína ya mangipalawán ka isa nga bálud da pepalawán daya tolay. ");
INSERT INTO isd_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ay kitun na oras, ay atán tolay ya nagngágan ka Barrabas nga atán ka agba-balúdán. Ay uwad da pe ya kabbulun na nga nabálud gapu kitu angngagúra da ki gubirnu se pummatay da pe. ");
INSERT INTO isd_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ay tútu nawe datu adu wa tolay ke Pilato nga magpepalawán kaggína nga ummán kitu gangay na. ");
INSERT INTO isd_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ay díkod tútu nán ne Pilato kaggída, “Piyán nu lugud nu pepalawán ku kadakayu ya ári nu wa Judyu?” nán na. ");
INSERT INTO isd_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ata nammuwán na nga gapu kitu ásil datu ap-apu datu pappádi tu nangidarum da ke Jesus kaggína. ");
INSERT INTO isd_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ay díkod nesug-sugsug datu ap-apu datu pappádi datu tolay nga tu Barrabas tu pepalawán da ke Pilato. ");
INSERT INTO isd_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ay tútu nán manin ne Pilato kadatu tolay, “Nágan lugud naya piyán nu wa kuwaan ku kiya nán nu wa ári nu wa Judyu?” nán na. ");
INSERT INTO isd_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ngamay nán da ngámin na nesar-sáraw, “Pelansám ki krus,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","“Taanna ta!” nán na. “Nágan naya básul na ta!” nán na. Ngamay kinggat da mán kammin tu inangngisáraw da ka, “Pelansám ki krus,” nán da. ");
INSERT INTO isd_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ay díkod gapu ta piyán ne Pilato wa paanggamman datu tolay, ay tútu nepepalawán na tu Barrabas. Ay e Jesus